﻿USE sofia;
DROP TABLE IF EXISTS sofia.zamNT_vpl;
CREATE TABLE zamNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zamNT_vpl WRITE;
INSERT INTO zamNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Loo libr ndxè' nda' cuent cón che'n rye mèn co' ngòc xudgool che'n Jesucrist co' nde bin David co' ngòc rey póla. No nda' loo libr ndxè' cuent le' Jesucrist nac bin che'n tedib mbi' co' ngo ban más pólle'a. Mbi'a ngro' lèe Abraham. ");
INSERT INTO zamNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ngòc xud thìb mbyòo co' ngro' lèe Isaac. Ngoloa, ngòc Isaac xud thìb mbyòo co' ngro' lèe Cob. Le' Cob na, ngòc xud thìb mbyòo co' ngro' lèe Judá con taamas hues Judá. ");
INSERT INTO zamNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Le' Judá na, mblo xin' thìb xa'got co' ngro' lèe Tamar, xa'got Judá. Mxan Tamar Far no Zar. Ngòc Judá no Tamar xud no xna' Far no Zar. Le' Far na, ngòc xud thìb mbyòo co' ngro' lèe Esrom. Esrom na, ngòc xud thìb mbyòo co' ngro' lèe Aram. ");
INSERT INTO zamNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram na, ngòc xud Aminadab. Aminadab na, ngòc xud Naasón. Naasón na, ngòc xud Salmón. ");
INSERT INTO zamNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Le' Salmón na, mblo xin' Rahab, xa'got Salmón. Ngóol thìb mbyòo co' ngro' lèe Booz. Booz na, mblo xin' Rut, xa'got Booz. Sya, ngóol thìb mbyòo co' ngro' lèe Obed. Obed na, ngòc xud thìb mbyòo co' ngro' lèe Isaí. ");
INSERT INTO zamNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaia na, ngòc xud thìb mbyòo co' ngro' lèe David co' ngòc rey póla. David co' ngòc reya mque noque' thìb xa'got co' ngòc sa'l thìb mbi' co' ngro' lèe Uri. Ale mxan xa'gota thìb xgan' David. Xgan' Davida ngro' lèe Salomón. Ale ngòc David con xa'gota xud no xna' Salomón. ");
INSERT INTO zamNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón na, ngòc xud thìb mbyòo co' ngro' lèe Roboam. Roboam na, ngòc xud thìb mbyòo co' ngro' lèe Abi. Abi na, ngòc xud thìb mbyòo co' ngro' lèe As. ");
INSERT INTO zamNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","As na, ngòc xud thìb mbyòo co' ngro' lèe Josafat. Josafat na, ngòc xud thìb mbyòo co' ngro' lèe Joram. Joram na, ngòc xud thìb mbyòo co' ngro' lèe Usi. ");
INSERT INTO zamNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usi na, ngòc xud thìb mbyòo co' ngro' lèe Jotam. Jotam na, ngòc xud thìb mbyòo co' ngro' lèe Acaz. Acaz na, ngòc xud thìb mbyòo co' ngro' lèe Ezequi. ");
INSERT INTO zamNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequi na, ngòc xud thìb mbyòo co' ngro' lèe Manasés. Manasés na, ngòc xud thìb mbyòo co' ngro' lèe Amón. Amón na, ngòc xud thìb mbyòo co' ngro' lèe Josi. ");
INSERT INTO zamNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josi na, ngòc xud thìb mbyòo co' ngro' lèe Jeconi, no xud taamas hues Jeconi, co'se' ngòc tiemp co'se' ngòc mèn nación Israel xal moz loo mèn nación Babiloñ. ");
INSERT INTO zamNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ngolo nguri'th tiemp co'se' ngòc mèn nación Israel xal moz loo mèn nación Babiloñ, Jeconi ngòc xud thìb mbyòo co' ngro' lèe Salatiel. Salatiel na, ngòc xud thìb mbyòo co' ngro' lèe Zorobabel. ");
INSERT INTO zamNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel na, ngòc xud thìb mbyòo co' ngro' lèe Abiud. Abiud na, ngòc xud thìb mbyòo co' ngro' lèe Eliaquim. Eliaquim na, ngòc xud thìb mbyòo co' ngro' lèe Azor. ");
INSERT INTO zamNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor na, ngòc xud thìb mbyòo co' ngro' lèe Sadoc. Sadoc na, ngòc xud thìb mbyòo co' ngro' lèe Aquim. Aquim na, ngòc xud thìb mbyòo co' ngro' lèe Eliud. ");
INSERT INTO zamNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud na, ngòc xud thìb mbyòo co' ngro' lèe Eleazar. Eleazar na, ngòc xud thìb mbyòo co' ngro' lèe Matán. Matán na, ngòc xud thìb mbyòo co' ngro' lèe Cob. ");
INSERT INTO zamNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Cob na, ngòc xud thìb mbyòo co' ngro' lèe Chè. Le' Chè na, ndoole' ngòc sa'l Mari. Mari na, mxan Jesús co' ne' tedib lèe co' nac Crist. ");
INSERT INTO zamNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Loo ryete bin ndxè', tiemp co' mbri'th desde co'se' ngo ban mbi' co' ngro' lèe Abraham axta co'se' ngo ban mbi' co' ngro' lèe David co' ngòc rey póla mdyaa sida bin. Lomisque' ne, tiemp co' mbri'th co'se' ngo ban Davida ngòc taasida bin axta co'se' ngòc mèn nación Israel moz yèe loo mèn nación Babiloñ. Lomisque' ne, tiemp co' mbri'th co'se' mtlo ngòc mèn nación Israel moz yèe loo mèn nación Babiloñ ngòc taasida bin axta co'se' ngóol Crist. ");
INSERT INTO zamNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Taandxè' mod ngòc con' co'se' ngóol Jesucrist. Thìb mza' yòn co' ngro' lèe Mari ngòp trat con thìb mbyòo co' ngro' lèe Chè. Ngòc mza' co' lèe Maria xna' Jesucrist. Chè mdoodi's no Mari par selya' Chè con Mari. Per ndoore' selya' Chè con Mari no tyub no Chè Mari, ale gunèe Chè mbe' xin'le' Mari. Per ne'nda'de Chè cuent xá mod mbe' xin' Mari. Mari mquée loo xin' por con' roo no con' xèn che'n Diox co' ngòc loo Mari por cón che'n Xpii Natú'. ");
INSERT INTO zamNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Chè co' ngòcque' xin' sa'l Mari, Chè ngòc thìb mbi' nalì no thìb mbi' nambìi loo Diox. Co'se' gunèe Chè mbe' xin'le' Mari, indlya'ste Chè yecloo Chè loo Mari no quexù' Chè Mari loo xnaa. Ale mbli Chè xtùuz xexte lá' Chè Mari par ne'ta'de mèn cuent le' Chè xexte mblá' Mari. ");
INSERT INTO zamNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Per láth ngue li Chè xtùuz con'a, chàa, ngro' too thìb angl co' mtel' Tad Diox loo Chè làth mcal'. Ndxab angl loo Chè': ―Chè, lùu co' nde bin David co' ngòc rey póla, ne'zyebtel no ne'yecloodel no ne'thyontel càaya'que' Mari par tyub nol Mari xal xin' sa'lpe'l. Tac thìb mbedbi' co' tyan Mari co' yi'th yáal yiloa, mbedbi'a mquée loo loo Mari por cón che'n Xpii Natú'. ");
INSERT INTO zamNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tyan Mari thìb mbed. Yiloa, lùu tub lèe mbed Jesús. Tataa ryo' lèe mbed tac mbed tí' no làa mbed mèn co' nac mèn nación mbed loo xquin mèn no loo xtol mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tataa ngòc ryete con'a par mdyaaque' no ngòcque' no ndubque' di's co' gunii Diox por cón che'n thìb mbi' co' mde'th di's co' ndxab Diox. Ndxab mbi'a: ");
INSERT INTO zamNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Le' thìb mza' yòn quée looque' xin'. Mza'a tyan thìb xgan' mza' no ryo' lèe mbeda Emanuel. Di's co' nac di's Emanuel nee di's: Nzole' Diox làth na'. ");
INSERT INTO zamNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Co'se' ngro' mcal' loo Chè, mbli Chè xal mnibe' angl co' mtel' Tad Diox loo Chè. Mqueltàa no Chè Mari. No mdub no Chè Mari xal xin' sa'lpe' Mari. ");
INSERT INTO zamNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Per mastale' mqueltàa no Chè Mari no mdub no Chè Mari le'n rye huiz co' mdoo nac xin' Mari, ne'ngàalte Chè Mari axta ngóol ner mbed co' ngòc mbed ndlyo loo Mari. Axta syare' ngòc Mari xa'gotpe' Chè. Ngoloa, mdub lèe Chè mbeda Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Co'se' ngolo nguri'th plá huiz ngóol Jesús le'n thìb yèez co' lèe Belén, yèez co' nac thìb yèezya' che'n làaz mèn jude, le'xque' le'n tiempa ngòc thìb mbi' co' ngro' lèe Herod rey loo mèn le'n nación Israel. Làth xtau'a, mzin plá mèn co' anze'f ndxác le'n ciuda Jerusalén. Mèna nde par ned ndlyen huiz. ");
INSERT INTO zamNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mnibdi's mèna loo mèn ciuda Jerusalén. Ndxab mèna: ―¿Máa mbeto' co' ngóolle'a, à', mbed co' gàc rey loo mèn nación Israel? Nu' gunèele' mbèelhui' co' mblu' le' mbed ngóolle'. Mbèelhui'a mbyú' loo loo nu' par ned ndlyen huiz. Cona, nde nu' axta trè' par tyub xib nu' loo mbed no par còo' nu' yéc nu' loo mbed co' gàc reya. ");
INSERT INTO zamNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Co'se' mbìn Herod con ryete mèn ciuda Jerusalén le' mèna mnibdi's máa mbed, ne'ñeede rey Herod cón li rey Herod. Ale mbyàa mbye'th xtùuz rey Herod. Ne'mbe see teede lezo' rey Herod con ryete mèn che'n ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Sya, mbli Herod mandad. Ndye'th ryete mèn co' ngòc jef co' más mnibe' loo nguley' no mèn co' ngòc maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn nación Israel tiempa. Mnibdi's Herod loo mèna. Ndxab Herod: ―¿Ché' non gu' pá gàc co'te' gáal Crist, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mèna mcàb loo Herod. Ndxab mèna: ―Crist gáal le'n yèez Belén co' nac thìb yèezya' che'n làaz mèn jude tac tataa ndub di's loo libr co' mque' mèn co' mde'th di's co' ndxab Diox ye's co' ndxab: ");
INSERT INTO zamNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Gu' co' nac mèn yèez Belén co' nac thìb yèezya' che'n làaz mèn jude, mastale' iñaade gu' xal mèn roo no mèn xèn làth mèn co' ñibe' rye yèezya', per làth gu' gáal thìb mbi' co' gàc jef loo gu' co' ñibe', no co' tyoo ner, no co' quenap mèn co' nac mèn nación Israel co' nac mèn nacionpe' daa. ");
INSERT INTO zamNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sya, xexte ngurez rey Herod mèn co' ndxáca par huen huen ñibdi's Herod loo mèna par ta' mèna cuent loo Herod pól mtlo ngòc gunèe mèna mbyú' loo mbèelhui' loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ngoloa, mtel' rey Herod mèna par ya mèna par ned le'n yèez Belén. Ndxab rey loo mèna: ―Huàa que tee gu' le'n yèeza. Huen huen ñibdi's gu' cón che'n mbeda loo mèn yèeza. No co'se' yilo zyal gu' mbeda, yi'th ta' gu' cuenta loon par ga too naan mbed, par tyub xiben no còo'en yéquen loo mbed, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Co'se' ngolo mbìn mèna di's co' ndxab rey, mxen mèna ned, nda mèna. Láth ndoo mèna ned, nda mèna par yèez Belén, mbere mbèelhui', mbyú' loo mbèelhui' loo mèna tedib vez, leque mbèelhui' co' mbyú' loo loo mèna co'se' mdoo mèna ned ndoore', nde mèna par ned ndlyen huiz. Co'se' gunèe mèn co' ndxáca mbèelhui'a, anze'f mdyac tín' lezo' mèna axta plóthe. Le' mbèelhui'a na, xèegà xèegà nda nerte loo mèna tedib vez axtaque' mblu' mbèelhui' loo mèna co'te' ngo mbed. Sya, xèe ngo too mbèelhui'a gáp yéc yòo co'te' ngo mbed, xgan' Mari. ");
INSERT INTO zamNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sya, ngòo mèna loo lue' co'te' ngòc liz mèn co'te' ngo xna' mbed con mbed. Texal gunèe mèna mbed con xna' mbed co' ngro' lèe Mari, ale mdub xib mèna loo mbed no mcòo' mèna yéc mèna loo mbed no ndxab mèna loo Diox: ―¡Ay, Dio's! Mbi' roo no mbi' xèn gàc mbed ndxè'. Ngoloa, mxal' mèna caj mèna co'te' ndxosua' tesor. Angmda'la's mèna tesor càa xna' mbed, co' gàc che'npe' mbed yiloa. Tesora nac or, no thìb xla' co' ndlya' xal zen yal', no thìb xla' co' ndlya' xal perfum co' lèe mirr. ");
INSERT INTO zamNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ngolo mbli mèna con'a, mda' Diox cuent loo mèn co' ndxáca làth mcal' le'n huiza ne'berede mèna leque ned nde mèna par ne'ri'thte mèna co'te' nac liz rey Herod. Sya, mxen mèna tedib ned, ndyàa mèna par làaz mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Co'se' ngolo mxen mèn co' ndxáca ned ndyàa mèna, thìb angl che'n Tad Diox mxo'f loo loo Chè làth mcal'. Ndxab angl loo Chè: ―Chè, jer goo che. Leque nal yál' fxen ned. Be' mbed con xna' mbed. Huàa xon' par ned le'n nación mèn egipt. Gòo gu' tya axtaque' lin avis loo gu'. Tac rey Herod ndlya's cua'n mbed par guthxù' Herod mbed. ");
INSERT INTO zamNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sya, ngro' mcal' loo Chè. Ngo che Chè. Ndxab Chè loo Mari: ―Mari, jer goo che. Nda no na' mbed par ned le'n nación mèn egipt nalle'. Mbe' Chè mbed no xna' mbed yál'a. Mxon' no Chè ryop Mari par ned le'n nación mèn egipt. ");
INSERT INTO zamNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ngo ban Chè ryop Mari, co' ngòc xin' sa'l Chè, con mbed le'n nación mèn egipt axta mzin huiz nguth Herod. Ngòc con' ndxè' loo Chè no loo mbed par ngòcque', no par mdyaaque', no par mdubque' di's co' gunii Tad Diox por cón che'n mèn co' mde'th di's co' ndxab Diox xal nac di's co' ndxab Diox: ―Par ned le'n nación che'n làaz mèn egipt ngo casloo xgan'en. No co'te' ngo casloo xgan'en, mblin par mbere xgan'en, ndye'th xgan'en par ned liz no làaz xgan'en tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Co'se' mden' rey Herod ya ne'ngri'thte mèn co' ndxáca liz rey Herod tedib vez, syare' mda' rey Herod cuent cón che'n mbed no cón che'n mèna le' mèn co' ndxáca mxìis no Herod. Sya, ngocloo tín' Herod. Ale de xyàn mnibe' Herod loo solndad par ya yuth solndad ryete myen' bix co' nac ante myen'bi' co' nzo ban le'n yèez Belén no le'n rye yèezya' co' ñibe' yèez Belén, myen' bix co' nzo chop lin' par xàn', co' nee di's, xal nda tee tiemp co' mda' mèn co' ndxáca cuent loo Herod par bel'que' yigaa mbed xin' Mari loo solndad làtha. ");
INSERT INTO zamNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Axta syare' mdyaa di's no mdubque' di's co' ndxab Jeremi co' mde'th di's co' ndxab Diox, co' mque' Jeremi ye's loo libr co' nac xti's Diox co' mbez: ");
INSERT INTO zamNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Anze'f thìb ruid mbyèn le'n yèez Ramá. Tant thìb mèngo'r mdub yen mèn no lezo' mèn no tant mbín' mèn no ngrozèe yath mèn. Ne' tí' yéc no ne' tí' lezo' rye mèngot co' nac mèn nación Israel por mbín' mèngota por cón che'n xgan' bix mèngota. Indlya'ste mèngota tegán mèngota lezo' mèngota no yende mod tegán taamas mèn lezo' mèngota tac ryete myen'bi' bix xgan' mèngota nguth. ");
INSERT INTO zamNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Co'se' mzin huiz nguth rey Herod, thìb angl co' mtel' Tad Diox mbere mxo'f loo angl loo Chè làth mcal' le'n nación mèn egipt. Ndxab angl loo Chè: ");
INSERT INTO zamNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Chè, Diox mtel' daa par gal lin avis lool: Fthop taa rye con' ngue nol. Tac gu' bii no mbed par ned le'n yèezya' che'n làaz mèn nación Israel. Tac mèn co' mbli purad par guth mèn mbed, mèna nguthle'. ");
INSERT INTO zamNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sya, co'se' ngo nìi izlyo' tedib huiz co' nde nquea, mthop mtaa Chè rye con' co' ngòc che'n Chè. Sya, ndxab Chè loo Mari: ―Ndyàa no na' mbed par ned le'n yèezya' che'n làaz mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Láth ndoo Chè ned con Mari no mbed, nda zin Chè le'n yèezya' che'n làaz mèn nación Israel, mbìn Chè le' Arquela, xgan' rey Herod, nacle' gobernador loo mèn gulàaz Jude lugar che'n Herod, xud Arquela. Sya, mzyeb Chè bii Chè par ned le'n yèezya' co' nac làaz mèn jude. Tya, mbere Diox, mdoodi's no Diox Chè làth mcal' xá mod li Chè. Ngoloa, mxen Chè ned con Mari co' nac xa'got Chè no con mbed co' nac Jesús. Ndyàa Chè le'n thìb yèez chu'th co' nac yèezya' che'n làaz mèn galile. ");
INSERT INTO zamNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Per ya que mzinle' Chè con Mari no mbed, ngòo ban Chè con Mari no mbed le'n thìb yèez co' lèe Nazaret. Tataa ngòca loo Chè no loo Mari par ngòcque' di's, no mdyaaque' di's, no mdubque' di's co' gunii mèn co' mde'th di's co' ndxab Diox le' mbed co' hue' lèe Jesús hue' tedib lèe co' lèe Jesús nazaren. ");
INSERT INTO zamNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Le'n tiemp co' ngo ban Jesús le'n yèez Nazaret, le'n tiempa mblo Juàn Bautist yalbàn loo mèn co'te' nagán, co'te' nac yèezya' che'n làaz mèn jude. Mblo Juàn Bautist yalbàn loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mbez Juàn Bautist co'se' ngo Juàn yalbàn loo mèn: ―Blàa gu' yéc gu' no blàa gu' lezo' gu'. No fse' gu' xtùuz gu' no mod co' ndxàp gu' loo Diox. Tac tiemp co' mblya's Diox ñibe' Diox loo gu' loo cón che'n Diox nde zin' gaxle'. ");
INSERT INTO zamNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Cón che'n Juàna ngòc di's co' mque' Sayi ye's, di's co' ndxab Diox loo Sayi. Taandxè' mbez di's loo ye's: Ndxèn thìb di's che'n thìb mbi' co' mbez yèe cabii co'te' nagán co'se' ngo mbi' yalbàn. Mbez mbi': Bli nab gu' gu' loo cón che'n con' ndac. Fse' gu' ryethe mod ye'rsin' co' ndxàp gu' loo Diox par gàc nab gu' co'se' yi'th ñibe' Tad Diox gu' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Xab Juàn co' mdoc Juàn nayà' con yis yid camell. Lomisque', cinch co' ngo le'n Juàn natoxcua' con yid má'. Lua' Juàn no xít Juàn ngòc mbiistoo no mzin huan. ");
INSERT INTO zamNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Co'se' mtlo Juàn mblo Juàn yalbàn, sya, ndxi'th mèn ciuda Jerusalén, no ryete mèn yèezya' co' nac làaz mèn jude, no ryete mèn co' nac mèn yèezya' co' nziri' gax ro yó'be' Jordán, loo Juàn par gòn mèna di's co' mbez Juàn no co' nde'th Juàn. ");
INSERT INTO zamNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Le' sya, texal ndxelo mxo'f dol mèna no ngo ro mèna cón che'n xquin mèna no cón che'n xtol mèna loo Juàn, ndli Juàn bautizar mèna le'n yó'be' Jordán. ");
INSERT INTO zamNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Látha, ñèe Juàn nde huax mèn co' nac mèn xley' farise no co' nac mèn xley' saduce loo Juàn. Mèna nde loo Juàn par li Juàn bautizar mèna. Sya, ndxab Juàn loo mèna: ―¡Aa mèn xley' farise, no mèn xley' saduce, mèn co' nayi' co' nac xal mbel' co' lèe huid! Leque gu' ndlu' loo xtàa gu' nado' nac gu'. Per par le'n lezo' gu' nzo con' ye'rsin'. ¿Chó mblu' loo gu' par lyá' gu' loo con' ye'rsin' co' gàc loo gu' co'se' gàc tiemp co'se' yecloo Diox loo gu' axta plóthe, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nabe'ste fque tee ban gu' loo mèn no nabe'ste gòp gu' mod loo mèn par lu' gu' loo mèn le' gu', lìcque', ngulàale' yéc no ngulàale' lezo' gu' loo Diox cón che'n con' ye'rsin' co' ndli gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ne' ne' li gu' xtùuz le'n lezo' gu' no ne' ne' gab gu' loo lezo' gu' anze'f ntac naca loo Diox le' Abraham nac xudgool gu'. Tac daa ngue nii loo gu': Diox, lìcque', gác li par bix loo quèe ndxè' no gàc quèe ndxè mèn co' naban co' nac binpe' che'n Abraham. ");
INSERT INTO zamNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nde niin thìb con' loo gu', ne: Le'i ndxàcle' loo gu' nalle' nde zin' gaxle' co' xà' Diox gu' par cobii Diox gu' le'n ye'rbìil thidtene xal co'se' ncho' mèn thìb xan' yaa xlè co' inda'de xlè ndac par co mèn yaa xlèa loo quìi. ");
INSERT INTO zamNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Lìcpe' ba'i, na ndli bautizar gu' con nít par ndxàca thìb muestr loo mèn co' ndlu' loo mèn le' gu' ngulàale' yéc no ngulàale' lezo' gu' no mse'le' gu' mod co' ngòp gu' loo Diox. Per nalle' ndele' thìb mbi' co' yi'th loo gu' yilo lin bautizar mèn. Mbi'a li bautizar gu' co'se' lyàa Xpii Natú' loo gu' co' gàc xal thìb quìi no thìb bèel. Mbi'a ndxàp más con' la's nii mbi' no la's ya' mbi' leque daa. No ne' por chu'th ne'ta'den par mbi'a. No axta ne' libid co' ngue nii mbi', indxàalte daa par làan libid nii mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Li mbi' thìb con' loo mèn, ne, xal co'se' nzole' pal ya' thìb mbi' par toocua' mbi' nzob triu par quis mbi' nzob triu mbi'. Yiloa co' xà' mbi' nzob triu loo yix nzob triu. Yiloa na, cosua' mbi' nzob triu. Le' yix co' yende chó juisa na, tec mbi' loo quìi co' ne'yu'de thidtene. Tataa li mbi', co' yi'th loo gu' yiloa, loo mèn co' tyal yila's loo mbi'a par ryo xà' mèna loo mèn co' ne'tyalte yila's loo mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Le'n huiz co' ngue go Juàn yalbàn, Jesús ngro' par ned le'n yèezya' che'n làaz mèn galile. Ngua Jesús par ned ro yó'be' Jordán co'te' ngo Juàn par mbli Juàn bautizar Jesús le'n yó'be' Jordán. ");
INSERT INTO zamNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ndxab Jesús loo Juàn li Juàn bautizar Jesús. Per co'se' mbìn Juàn li Juàn bautizar Jesús, ne'ndalte Juàn li Juàn bautizar Jesús. Ndxab Juàn loo Jesús: ―U' ndxàal li bautizar daa, Tad. ¿Xá mod ndlya's U' ale daa li bautizar U', yey? ");
INSERT INTO zamNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ndxab Jesús loo Juàn: ―Lìcque' nac di's co' ngolo guneel ba'. Yende cón niin lool. Per mastale' nden'l ndxàal lin bautizar lùu, bli co' ñibe'en lool. Bli bautizar daa tac taandxè'que' ndxàal li na' par tyaaque', no gàcque', no tyubque' di's xal mnibe' Diox par gàca. Syare', mdyal Juàn. Mbli Juàn bautizar Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Per texal ngulàa Jesús le'n nít par ngòc bautizar Jesús le'n nít, no ngro' Jesús le'n nít, chàa, mxyal' loo bé'. Látha, gunèe Jesús Xpii Natú' che'n Diox co' ñaa xal thìb palomxtil' hora co' nde làa loo bé' loo Jesús. Sangmbyan' Xpii Natú' loo Jesús. No ngo no Xpii Natú' Jesús thidtene. ");
INSERT INTO zamNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Leque hora, mbyèn thìb di's loo bé' co' ndxab: ―Mbi' ba' nac xgan' daa co' anze'f ngudloon no lezon. Por cón che'n mbi' ba' anze'f ndyac tín' lezon. ");
INSERT INTO zamNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ngoloa, mbli Xpii Natú' che'n Diox mxen Jesús ned. Nda Jesús thìb lugar co'te' nagán par cobya' Mebizya Jesús no li Mebizya preb thìb con' loo Jesús par ñee Mebizya ñeene' ché' tli Jesús co' gab Mebizya loo Jesús. Mebizya mblya's andoo Jesús cua'n Jesús xquin Jesús no xtol Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Le'n rye huiza, xlat Jesús. Ne'nghuade Jesús le'n cho' huiz no le'n cho' yál'. Ngoloa, anze'f mblyan' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Látha, ngua Mebizya loo Jesús par ñee Mebizya ñeene' ché' tli Jesús co' gab Mebizya loo Jesús tac Mebizya nanee le' Jesús ndlyan'. Ndxab Mebizya loo Jesús: ―Chele' lùu, lìcque', nac xgan'pe' Diox, bnibe' loo quèe ndxè' gàc quèe ndxè' pan par hual. ");
INSERT INTO zamNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús mcàb loo Mebizya. Ndxab Jesús: ―Loo libr co' nac xti's Diox ndub di's co' mbez: Iante con pan cue ban mèn loo izlyo'. Ndxe'leque', mèn cue ban loo izlyo' ndxè' por cón che'n ryete di's co' gunii Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ngoloa, mbe' Mebizya Jesús le'n ciuda Jerusalén co' nac ciuda natú' che'n Diox. Mbli Mebizya par mquée Jesús yéc templ co'te' nac más gáp. ");
INSERT INTO zamNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tya, ndxab Mebizya loo Jesús: ―Chele' lùu nacque' xgan'pe' Diox, lyazen que'l thìb brinc trè' axta loo yòo. Tac loo libr co' nac xti's Diox ndub di's co' mbez: Yub Diox ñibe' loo angl che'n Diox par quenap angl lùu. Angl te'f ya' angl par lyàal ya' angl par ne'lyàadel loo quèe no ne'huí'de ladl loo quèe. ");
INSERT INTO zamNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús mcàb loo Mebizya. Ndxab Jesús: ―Loo libr co' nac xti's Diox ndub di's co' mbez: Ne'lidel preb no ne'cobya'del Tad co' nac Tad Diox lùu par ñeel ñeene' ché' tetìi Tad Diox lùu por cón che'n con' ye'rsin' co' ngue lil. ");
INSERT INTO zamNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ngoloa, mbe' Mebizya Jesús loo thìb yii roo. Mblu' Mebizya ryete nación co' nziri' dib athu loo izlyo' loo Jesús. Mblu' Mebizya ryethe con' co' nac con' roo no con' xèn che'n rye nación co' nziri' dib athu loo izlyo' loo Jesús, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ndxab Mebizya loo Jesús: ―Ryete con' ba' tan càal par gàca che'npe'l chele' lùu tyub xib loon no còo'l yécl loon. ");
INSERT INTO zamNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Le' sya, ndxab Jesús loo Mebizya: ―Biiche thìb lad loon, Mebizya. Byàa. Tac ndub di's loo libr co' nac xti's Diox co' mbez: Ante loo Dioxpe' lùu tyub xibl no còo'l yécl no ante loo Dioxpe' lùu lil sirv. ");
INSERT INTO zamNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sya, xexte mxen Mebizya ned. Ndyàa Mebizya. Mblá' Mebizya Jesús. Ngoloa, mzin angl che'n Diox loo Jesús. Mbli angl mandad loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Leque le'n huiza, mbìn Jesús le' Juàn Bautist ngue lezi'f. Mbere Jesús, ndyàa Jesús par ned le'n yèezya' che'n làaz mèn galile. ");
INSERT INTO zamNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tya, sangnguri'th Jesús yèez Nazaret. Ne'mbedte Jesús le'n yèez Nazaret. Ndxe'leque', ngua ban Jesús le'n yèez co' lèe Capernaum co' nac thìb yèez co' nziri' gax ro lagun, lagun co' nziri' loo xyòn mèn galile co'te' nazal' xyòn mèn che'n làaz mèn zabulón, no co'te' nazal' xyòn mèn che'n làaz mèn neftalí. ");
INSERT INTO zamNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tataa ngòc con'a loo Jesús par ngòcque', no mdyaaque', no mdubque' di's co' mque' Sayi ye's, Sayi co' mde'th di's che'n Diox. Sayi ndxab: ");
INSERT INTO zamNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Co'se' yi'th Crist, Crist ya que tee par ned le'n yèezya' che'n làaz mèn zabulón, no par ned le'n yèezya' che'n làaz mèn neftalí, no par ned co' nsyo ro níttó' co' nda tedib lad ro yó'be' Jordán. No ya que tee Crist par ned le'n yèezya' che'n làaz mèn galile co'te' nzo ban huax mèn co' inacte mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mèn co' nzo ban par neda, mèna ngure li con' co' mcàb loo mèna loo cón che'n Diox xal mèn co' ngure loo yál'cuau. Diox mbli par mdyub xnìi yéc mèna no par mdyub xnìi lezo' mèna por cón che'n Crist. No ryethe mèn co' alithe nzi ban loo con' co' ncàb yalguth loo mèna, Diox ntenìi yéc mèna no ntenìi Diox lezo' mèna por cón che'n Crist. ");
INSERT INTO zamNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Axta syare' mtlo Jesús, mblo Jesús yalbàn loo mèna tya. Mbez Jesús loo mèn par neda: ―Gulàa yéc gu' no gulàa lezo' gu'. Fse' gu' xtùuz gu' no mod co' ndxàp gu' loo Diox. Tac tiemp co' ndlya's Diox ñibe' Diox loo gu', tiempa mzinle' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Láth nda riid Jesús ro lagun co' nziri' loo xyòn che'n mèn galile, gunèe Jesús chop mbi' co' ndxàc hues. Thìb mbi' ngro' lèe Mon Pedr. Le' tedib mbi'a na, ngro' lèe Ndech. Nzi gobii ryop hues mbi' yex le'n nít loo lagun par yigaa mbèel loo ryop hues mbi' tac ryop hues mbi' ndyen mbèel. ");
INSERT INTO zamNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Sya, ndxab Jesús loo Pedr no loo Ndech: ―Ya' gu' nda na'. Ftoo nque gu' xísen. Daa li le' ryop gu' gàc mbi' co' lu' loo mèn cón che'n Diox par yòo mèn loo cón che'n Diox xal ndxàc co'se' ndyen gu' mbèel con yex gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Co'se' mbìn ryop hues mbi' tataa ndxab Jesús, mblá' ryop hues mbi' yex. Nda nque ryop hues mbi' xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Gundee Jesús taandxepte más delant, gunèe Jesús taachop mbi' co' ndxàcguè' hues. Thìb mbi' ngro' lèe Cob. Tedib mbi' ngro' lèe Juàn. Ryop hues mbi'a ndxàc xgan' thìb mbi' co' ngro' lèe Zebede. Nzo ryop hues mbi' le'n thìb yòoyaa con xud mbi'. Ngue go bdè' ryop hues mbi' yex le'n yòoyaa con xud mbi'. Jesús ngurez ryop hues mbi'a. Ndxab Jesús: ―Ftoo nque gu' xísen. Ya' gu' nda na', ey. ");
INSERT INTO zamNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Leque hora mblá' myen' yòoyaa con xud myen'. Nda nque myen' xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Be' taa be' taa nda tee lu' Jesús mèn le'n rye yèezya' che'n làaz mèn galile. Ngue lu' Jesús mèn le'n sinagog mèn co' nziri' rye lugar co'te' mque tee Jesús. Ngo Jesús yalbàn. Mbez Jesús loo mèn cón che'n di's ndac cón che'n xá mod ndlya's Diox ñibe'pe' Diox loo mèn. No mteyac Jesús mèn, mèn co' mque no chol yíiz le'n rye yèezya' ned mque tee Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Láth mque tee Jesús par neda, anze'f thìb mèn yèezya' che'n làaz mèn sir mbìn cón che'n Jesús. Mbi'th no mèna ryete mèn yíiz co' nzo par neda, mèn co' ndyac len chol yíiz, no mèn co' mden' chol yalnè, no rye mèn co' mque no chol mbii che'n xpii meexù', no mèn co' mque no yíiz enferesi, no mèn co' mque no yíiz mbii co' nac yíiz bech. Mteyac Jesús ryete mèn yíiza. ");
INSERT INTO zamNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mdoo nque huax mèn yèezya' che'n làaz mèn galile, no mèn yèezya' che'n làaz mèn decápolis, no mèn che'n ciuda Jerusalén, no mèn yèezya' che'n làaz mèn jude, no mèn rye yèezya' co' nziri' par ned ndlyen huiz, ned nziri' yó'be' Jordán, xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Co'se' gunèe Jesús anze'f thìb mènléy' nziri' con Jesús, Jesús mquée loo thìb yii co' ndub tya. Mdub Jesús loo yiia. Le' myen' xin' mté'th Jesús na, thidte mqueltàa, ngure myen' dib vuelt loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Mtlo Jesús, mblu' Jesús myen' xin' mté'th Jesús. Ndxab Jesús loo myen' taandxè': ");
INSERT INTO zamNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Huen nda mèn, mèn, co' nden' le'n lezo' nac mèna mèn be'the loo Diox no co' nden' le'n lezo' yende mod li mèna con' ndac co' ndxòo lezo' Diox. Tac Diox co' ñibe'pe' loo mèna ndli par ndxàc con' ndac loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Huen nda mèn co' nzi xi yéc no co' nzi xi lezo' tac Diox tegánque' lezo' mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Huen nda mèn nado' co' inacte mèn nate's no co' inacte mèn naxal', mèn co' ndoo xal' lezo', tac gàc che'npe' mèna loo izlyo' co' ngòc con' co' mcàbgòn Diox càa mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Huen nda mèn co' ndyub yo'f lezo' no co' anze'f ndlya's que tee nalì mèna loo Diox xal mèn co' ndlyan' no co' ndxec lezo' tac Diox lyath no mèna que tee nalì mèna loo xtàa mèna no que tee nalì mèna loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Huen nda mèn co' ndlyat lezo' ñèe hues xtàa tac Diox lyatque' lezo' ñèe Diox mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Huen nda mèn co' ndxàp mod par li mèn sirv loo Diox thìb lì yéc mèn no thìb lì lezo' mèn tac mèna hui'que' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Huen nda mèn co' ndli mbe nagàl lezo' hues xtàa mèn no ndli mèna ndxu' ndxàl lezo' hues xtàa mèn co' nziri' con nado' di's nado' cuent tac Diox mbez no ngòoque' Diox cuent le' mèna nacque' xin' Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Huen nda mèn co' ndyub ngu's mèn por mod co' nac mod ndac co' nzi tee ban mèna tac loo mèna tyalque' Diox no ta' Diox lugar yòo mèna loo cón che'n Diox par ñibe'pe' Diox loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Huen nda gu', myen', co'se' aseli mèn ta' mèn xyàn lezo' gu', no li mèn ngòc nguàal con' loo gu', no ñee mèn chol di's ye'rsin' loo gu' por cón chenen no maste. ");
INSERT INTO zamNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Fxo'f nde' fxo'f ndla' lezo' gu' no gure gu' guyith guxìis tac con' roo no con' xèn gàc co' ta' Diox càa gu' loo bé' yiloa. Cona, ngue niin loo gu': Fxec gu' loo con' ndxàc loo gu' tac tatua'que' mque tee mdub ngu's mèn prob mèn co' mde'th di's co' ndxab Diox, mèn co' mque tee ban póla ndoore' co'se' gáal gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Tolo ndxab Jesús loo myen' xin' mté'th Jesús: Nde niin thìb con' loo gu': Neeque' gu' le' ted ndli par ne'yiza'de chol nít yèth o bél' co' ngo mèn ted loo, ¿lé'? Chele' teda alithe nzo'f di's nac ted co' inaziide par ne'yiza'de con' co' ngo mèn ted, sya, ya yende cón ntac ted. No cobii mèn ted par loo tub mèn loo ted. Tataa mod, ne, gu' nzo làth mèn co' alithe nque tee ban loo chol con' ye'rsin' par càba loo mèna le' mèna ne'tolode cua'n mod gàc mèna mèn ye'rsin' axta plóthe. Per chele' gu' ne'que tee ban ndacte loo mèn ye'rsin'a, càba le' mèna tolo li con' ye'rsin' axta plóthe no yende cón ntac gu' loo Diox. Sya, gàca loo gu' co' xà' Diox gu' loo zin' che'n Diox xal co'se' mblobii mèn teda. ");
INSERT INTO zamNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Lomisque' ne, gu' nac xal xnìi loo mèn ye'rsin' loo izlyo'. Neeque' gu' no nda'que' gu' cuent le' thìb ciuda co' nziri' gáp loo thìb yii yende mod ga's loo mèn. Thidteneque' ndxú' ciudaa loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ne' ne' co mèn xnìi thìb lampr no yiloa tau' mèn loo lampr con thìb cajón. Ndxe'leque', quetal mèn lampr gáp par tenìi lampr loo mèn co' nzo le'n nyòo liz mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Cona, ngue niin loo gu': Tataaque' bli gu' no fque tee ban ndac gu' loo mèn, gu' co', lìcque', nac xal xnìi loo mèn ye'rsin' loo izlyo' par hui' mèn no ta' mèn cuent loo ryethe con' ndac co' ndli gu'. Co'se' ñèe mèn le' gu' ndlique' con' ndac, le' sya, mèna tolo li gàc con' guryath no con' guryèn loo Diox xud gu' por cón che'n gu' làth mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ne'lide gu' xtùuz no ne' ne' yila's gu' le' daa ndal par techeen no ton'en ley co' mxo'f Moisés loo mèn. Ne'ngalten par ton'en ley co' mxo'f Moisés loo mèn. Ne' ne' ngalen par techeen di's co' gunii mèn co' mde'th di's co' ndxab Diox póla. Ne'ngalten par techeen no ton'en cón che'n leya no cón che'n di'sa. Ndxe'leque', ndalen par lipe'en ryethe con' cón nee di'spe' cón che'n ley no di's co' mde'th mèn co' ndxab Diox póla. ");
INSERT INTO zamNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tac, lìcpe' ba'i, na ngue nii lo gu': Láth be' nziri' bé' co' nac loo bé' no izlyo', ne'biichede nec thìb letr no nec thìb yalnibe' ne'zye'de no ne' ne' bix loo co' nac cón che'n ley co' mxo'f Moisés loo mèn axtaque' gàcque', no tyaaque', no tyubque' di's ryete con' co' mdoo lezo' Diox gàc por cón che'n ley co' mxo'f Moisés loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Cona, ngue niin loo gu': Le' mèn co' tè'b no ne'lide mèn cas di's co' ñibe' ley co' mxo'f Moisés ndxè', co' nac yalñibe' co' nac más be'the, no chele' mèna ndlu' loo taamas mèn leque con' ndli mèna, Diox co cuent le' mèna nac más mèn be'the loo rye mèn co' ñibe' Diox. Per mèn co' ndyubdi's loo ryethe di's co' ñibe' ley co' mxo'f Moisés loo mèn, no ndlu' mèna loo xtàa mèna li xtàa mèna xalque' ndli mèna, le' sya, co Diox cuent gàc mèna mèn roo no mèn xèn loo taamas mèn loo cón che'n co'te' ñibe' Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Daa ngue nii loo gu': Chele' gu' ne'que tee ban ndacte thìb yalnaban co' nac thìb yalnaban más ndac leque mod co' nzi tee ban mèn co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn nación Israel, no mod co' nzi tee ban mèn co' nac mèn xley' farise, le' sya, thidteneque' ne'gàcte loo gu' yòo gu' co'te' ñibe' Diox par ñibe' Diox loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Gu' nanee no nonque' gu' no nda'que' gu' cuent xal ngòc di's co' mblu' mèn mod che'n mèn loo xtàa mèn làth di's co' ndub loo ley co' mxo'f Moisés loo mèn pólle'a: Ne'guthte gu' xtàa gu'. Tac chele' chol mèn guth chol hues xtàa mèn, cón che'n mèna tub rez thìb juez. ");
INSERT INTO zamNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Per daa ngue nii loo gu': Chol mèn co' angnziri' ndxàc nayi' no ndxòo xyàn lezo' mèna ñèe mèna hues xtàa mèna, cón che'n mèna ndxàal tub rez thìb juez. Lomisque' ne, chol mèn co' nque di's con xtàa mèn, sya, cón che'n mèna ndxàal tyub rez loo mèn co' ndyoo ner, no co' ndyoo naa, no co' ñibe', loo mèn nación Israel. No chol mèn co' gab loo hues xtàa mèna le' mèna nac mèn naxèn no mèn nasan no mèn yéc brel, mèna nzo ryes yòo ye'rbìil co'te' ndxetoo bèel no quìi. ");
INSERT INTO zamNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Más de cona, ngue niin con' ndxè' loo gu': Chele' chó gu' nzi yoo làth gu', no láth nzi yoo gu'a, hue' gu' gòn gu' no ofrend gu' par ta' gu'i loo cón che'n Diox no cuec gu' ofrend gu' co' nac gòn loo mes, no axta syare' te' lezo' gu' le' hues gu' no xtàa gu' ndxecloo ñèe gu', ");
INSERT INTO zamNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","sya, lá' gu' ofrend gu'a loo mes par ner ya gu', ya tàl gu' loo di's no loo cuent loo chol hues gu' no loo chol xtàa gu' co' ndxàc con' ye'rsin' loo. Sya, bere gu', ye'th gu' co'te' ndoo mes. No gab gu' loo Diox: Ofrend nu' ndxè', Tad Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tolo ngue niin loo gu', ne: Chele' chol mèn co' ngyoo no gu' ya ta' part cón che'n gu' loo juez, bli gu' par tyoodi's ryop gu' mèna ned nda gu' ñeene' xá mod li gu' no xá mod gàc cón che'n gu' par ne'quexù'de mèna gu' loo juez ó loo xcal. Yiloa na, ta' juez o xcal gu' loo xa' co' nac tinient o mayor. Le' tinient o mayor na, co gu' lezi'f. ");
INSERT INTO zamNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Lìcpe' ba'i, daa nii loo gu': Tya nzo gu'. Ne'ryo'de gu' lezi'f axtaque' zib gu' tmi co' nac mult gu'. Sya, co' juez o xcal gu' lezi'f. ");
INSERT INTO zamNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Lomisque' ne, nonque' gu' no nda'que' gu' cuent xal ngòc di's no cuent co' mblu' mèn mod che'n mèn loo xtàa mèn làth di's co' ndub loo ley co' mxo'f Moisés loo mèn póla co' mbez: Ne'lide gu' yalburrid. ");
INSERT INTO zamNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Per daa ngue nii loo gu': Chol mèn co' ndyub yo'f lezo' ngüi' mèna loo thìb xa'got par gàal mèna xa'gota, mblile' mèna yalburrid le'n lezo' mèna con xa'gota. ");
INSERT INTO zamNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Lomisque' ne, angab na'i: Chele' gu' ndli cuent no nden' gu' le' ngudloo gu' co' nac ladli, lìcque', nac co' ndli par cua'n gu' xquin gu' no xtol gu', más huen blo' gu' ngudloo gu' thìb lad loo gu'. Tac más huen gàca loo gu' yende sa ngudloo gu' leque tyactìi dib lad gu' loo quìi no loo bèel le'n ye'rbiil. ");
INSERT INTO zamNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","No chele' gu' ndli cuent le' ya' gu', lìcque', nac co' ndli par cua'n gu' xquin gu', más huen fcho' gu' ya' gu' no blobii gu' ya' gu' thìb lad loo gu'. Le' sya, más huen gàca loo gu' yende sa ya' gu' co' nac thìb part che'n lad gu' leque lyàa dib lad gu' le'n ye'rbìil. Por cona, thidtene ne'cua'nte gu' xquin gu' no xtol gu' par ne'yòode gu' le'n ye'rbìil. ");
INSERT INTO zamNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Tolo ndxab Jesús loo mèna: ―Nonque' gu' no naneeque' gu' xal nac di's co' ndub loo ley co' mxo'f Moisés loo mèn póla le' chol mèn co' mbez lá'xù' mèna xin' sa'l leque mèna, ta' mèna ye's co' lèe act co' ta' cuent no co' lu' le' mèna mblá'xù' xin' sa'l. ");
INSERT INTO zamNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Per daa ngue nii loo gu': Chele' thìb mbi' lá'xù' xin' sa'lpe' mbi' no ingue lide xin' sa'l mbi' yalburiid, le' sya, leque mbi' ngue li par mbez mèn le' xin' sa'l mbi' ngue li yalburrid mastale' ingue lide xa'i. No mèn co' selya' con xa'got co' mblá'xù' sa'la ndoore', xa'bi'a ngue li yalburrid con xa'gota, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Más de cona, nonque' gu' no nda'que' gu' cuent xal mbez di's co' ndub loo libr co' ngòc ley co' mxo'f Moisés loo mèn póla co' mbez: Ne'lá'de gu' no ne'yathla'ste gu' li gu' co' mcàbgòn gu' li gu' co'se' mde'th gu' lèe Diox loo mèn par li gu' chol con'. ");
INSERT INTO zamNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Per daa ngue nii loo gu': Nec thìb mod no nec tedib mod ne'te'thte gu' lèe Diox. Nec thìb mod no nec tedib mod ne'te'thte gu', co' nee di's, nac lèe bé', xal ndli taamas mèn tac loo bé' nac co'te' nzo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ne' ne' te'th gu', co' nee di's, nac lèe izlyo' xal ndli taamas mèn. Tac izlyo' nac loo Diox xal co'se' ndli nii mèn descans loo thìb banc. Ne' ne' te'th gu', co' nee di's, nac lèe ciuda Jerusalén xal ndli taamas mèn. Tac ciuda Jerusalén nac lizpe' no làazpe' che'n rey roo no che'n rey xèn co' nac yub daa co' nac Crist. ");
INSERT INTO zamNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ne' ne' te'th gu', co' nee di's, nac lèe yéc gu' xal ndli taamas mèn. Tac gu' ne'gácte toxcua' nec thìb yis yéc gu', co' nac yis guch no co' nac yis nagat par yan'a thidtene tataa. ");
INSERT INTO zamNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Más huen guuz gu': Neeca, o guuz gu': Tyè'. Tac ryete di's co' mbez mèn co' nac masre' di's loo con' mbezen ndxè', ale ndli mèn con'a por cón che'n Mebizya. ");
INSERT INTO zamNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Más de cona, nonque' gu' no nda'que' gu' cuent xal mbez di's co' ndub loo libr co' nac ley co' mxo'f Moisés loo mèn póla: Chele' chó mèn cue yoo no teza' thìb mbi' thìb ngudloo xtàa mbi', mèn teza' thìb ngudloo mbi' co' mteza' ngudloo xtàa mbi'a, ne. Lomisque' ne, chele' chó mèn cue yoo no co' yèe thìb mbi' thìb quele xtàa mbi', lomisque' mod, co' mèn thìb quele mbi' co' mblo' quele xtàa mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Per daa ngue nii loo gu': Fxec gu' loo chol con' ye'rsin' co' li no mèn hues xtàa gu' gu'. Chele' chol mèn co' lya's quis thìb lad rloo gu', fte'b gu' tedib lad rloo gu' loo mèna par quis mèna tedib lad rloo gu', ne. ");
INSERT INTO zamNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","No chele' chol mèn ndlya's li de mandar gu' no ale ndlya's mèna teche mèna camis gu', fta' gu' chamar gu' hue' mèna, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Lomisque' ne, chele' chol mèn ndlya's ñibe'xù' mèna loo gu' par hue' gu' yó' co' nac che'npe' mèn xís gu' casque' son kilometr, be' gu'i xís gu' taason kilometr. ");
INSERT INTO zamNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","No chol mèn co' ña'b ro chol con' loo gu', fta' gu' con' càa mèna. No chol mèn co' lya's teche gu' con' loo mèn, fteche gu'i loo mèna no ne'cà'de gu'i loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Más de cona, nonque' gu' no nda'que' gu' cuent xal ngòc di's co' mblu' mèn loo xtàa mèn xal mbez di's co' ndub loo ley co' mxo'f Moisés loo mèn póla: Fque' lezo' gu' gunèe gu' mèn co' ndxàc amiu gu'. Le' mèn co' nac ngolo ngola's che'n gu' na, gocloo gu' gunèe gu' mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Per daa ngue nii loo gu': Fque' lezo' gu' gunèe gu' mèn co' nac ngolo ngola's che'n gu'. Nado' di's nado' cuent tyoodi's no gu' mèn co' ñii yèe ñii tìi cón che'n gu'. Bli gu' con' ndac loo mèn co' ndxòo xyàn lezo' ñèe gu'. Gurez gu' Diox cón che'n mèn co' angnziri' ndli ngòc nguàal con' loo gu' no ndub ngu's mèn gu', ne. ");
INSERT INTO zamNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chele' gu' li tataa, lìcpe' ba'i, gàc gu' xin' xud gu' Diox co' nzo loo bé'. Tac Diox xud gu'a ndli le' huiz ntenìi loo mèn ye'rsin' no loo mèn ndac. No ndli xud gu' Diox ndlyàa yuu loo mèn co' nac mèn nalì no mèn nambìi loo Diox no loo mèn ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tac chele' gu' ante nque' lezo' ñèe gu' mèn co' nque' lezo' ñèe gu', ¿ché' ndyac gu' ngue li gu' con' ndac loo Diox sya, cà'? Ingue lide gu' con' ndac loo Diox, ey. Tac axta mèn co' ndli cobrar tmi cón che'n contribución ndli tataa. Ante nque' lezo' mèna ñèe mèna mèn co' nque' lezo' ñèe leque mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","No chele' gu' nii Diox ante loo mèn gulàazpe' gu', ¿chó con' ndac ndli gu' loo Diox co'se' ndli gu' tataa, sya? Yende chó con' ndac ndli gu' loo Diox chele' gu' ngue li tataa, ey. Tac leque con'a ndli mèn co' inacte mèn nación Israel. ¡Aa, gu' mèn izlyo'! ");
INSERT INTO zamNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Gòc gu' mèn nalì no gòc gu' mèn nambìi co', lìcque', nque' lezo' ñèe hues xtàa xal nac xud gu' Diox co' nzo loo bé', Diox co' nac Diox nalì no Diox nambìi. Tac xud gu' Diox nque'que' lezo' ñèe alux mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tolo mblu' Jesús loo mèn. Mbez Jesús: ―Nabe'ste fque tee ban ndac gu' loo Diox. Ne'gàcte gu' arid mèn nate's par hui' chol mèn co' ndxàc hues xtàa gu' loo con' ndli gu'. Tac chele' gu' li tataa, sya, tataa mod ndye's gu'. Le' sya, xud gu' co' nzo loo bé' ne'lide par gàp gu' cón che'n gu' loo xud gu' Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ngue niin loo gu', ne: Ne'tubte gu' arid ruid loo mèn par cuez mèn trompet loo mèn xal ndli mèn co' anze'f ntembìi ro no co' anze'f ntembìi xti's le'n sinagog no le'n yèez par ned ndxè' par ned ba'. Ale tataa ndli mèna par gab chol mèn: Susque' huen nac mèn ba', yoo. Lìcpe' ba'i, daa ngue nii loo gu': Por gust co' nda' mèna lezo' mèna, ale leque mèna ndli par guneei loo mèna. No yende chó con' co' gàc che'n mèna gàp mèna loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Per co'se' ta' gu' gòn càa mèn prob, bli gu' par ne' mèn co' ndxàc amiu gu' ne'ta'de cuent pló cón nac co' nda' gu' gòn. ");
INSERT INTO zamNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Más huen xexte fta' gu' gòn càa prob mèna. Le' sya, xud gu' Diox co' nzo loo bé', co' ngue hui' loo gu'a, li par tolo anggàc con' ndac loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Tolo mblu' Jesús mèn. Ndxab Jesús: ―Co'se' cuez gu' Diox, ne'gàcte gu' xal mèn co' ntembìi ro no xal mèn co' ntembìi xti's. Mèna anze'f ndyubla's cuez Diox, ndoo ga' mèn le'n sinagog. Mèna ndyubla's ndyoo ga' pál squin ned, ne, par cuez mèna Diox par hui' no ñaa hues xtàa mèna loo mèna. Lìcpe' ba'i, daa ngue nii loo gu': Con mod co' ndxàp mèna, leque mèna mbli guneei loo mèna. No tataa mod yende chó con' co' gàc che'n mèna gàp mèna loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Per co'se' cuez gu' Diox, gòo gu' le'n nyòo co'te' ndxàt gu' no ftau' gu' ro ryo'. Gurez gu' Diox xud gu' co' nzo loo gu' le'n cuart co'te' ndxàt gu'. Xud gu' Diox co' ngue hui' xexte loo gu', xud gu' Diox li par gàc con' ndac loo gu' loo xnaa. ");
INSERT INTO zamNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Co'se' cuez gu' Diox, ne'cuezte gu' lèe Diox goze goze con leque di's co' mbez gu' co' intacte xal ndli mèn co' inacte mèn nación Israel. Tac ndli mèna xtùuz por di's co' mbez mèna goze goze no maste tataa mod más ndxòn Diox ro mèna co'se' tataa mbez mèna loo Diox. Per ilìcte con'a. ");
INSERT INTO zamNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ne'gàcte gu' lalque' xal mèna, tá, tac xud gu' Diox naneeque' no nonque' cópe' nquin gu' ndoore' co'se' ña'b gu' con'a loo xud gu' Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Cona, ngue niin loo gu' taandxè' mod cuez gu' Diox: Diox xud nu', co' nzo loo bé', ndlya's nu' no ña'b nu' loo U' le' mèn ta' cuent no ten' mèn thidte U' nac Diox natú'pe'. ");
INSERT INTO zamNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nu' mbez loo U' no ña'b nu' loo U' le' U' ñibe'pe' loo mèn dib athu loo izlyo'. No gàca xal nee lezo' U' loo izlyo' ndxè' xalque' ndxàc co' nee lezo' U' loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Fta' U' lua' nu' no xít nu' co' hua nu' nalze no taamas con' co' naquinque' nu' atate huiz. ");
INSERT INTO zamNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Fton' U' xquin nu' no xtol nu' xal nteri'th ntecan' nu' xèn xyàn co' ndli hues xtàa nu' loo nu'. ");
INSERT INTO zamNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ne'lá'ya'de U' nu' par aseli nu' cua'n nu' xquin nu' no xtol nu' loo U'. Ndxe'leque', blàa U' nu' loo ryethe con' ye'rsin'. Tac U' ñibe' loo ryethe con'. No ndxàp U' ryethe con' roo no ryethe con' xèn la's nii U' no la's ya' U'. No che'npe' U' nac ryethe con' roo no con' xèn le'n lín' co' ntlo, no le'n lín' co' ndxelo, no le'n lín' co' ne'lith node thidtene. Taandxè' gàca. ");
INSERT INTO zamNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tac chele' gu' nteri'th no ntecan' chol xen no xyàn co' ndli chol mèn hues xtàa gu' loo gu', le' sya, xud gu' Diox co' nzo loo bé' ton'que' xquin gu' no xtol gu' co' ncua'n gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Per chele' gu' ne'teri'thte no ne'tecan'te chol xen no xyàn co' ndli hues xtàa gu' loo gu', ne' xud gu' co' nzo loo bé' ne'ton'te xtol gu' no xquin gu' co' ncua'n gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Co'se' lya's gu' cue xlat gu' por ndxep tiemp, ne'lu'de gu' loo mèn le' gu' nzi xi lezo' xal ndli mèn co' ntembìi ro no mèn co' ntembìi xti's. Tac mèna asendli ndlu' mèna loo mèn le' mèna nxi lezo'. No nse' mèna rloo mèna par hui' taamas mèn le' mèna nzi xlat. Lìcpe' ba'i, daa ngue nii loo gu': Gust co' nda' mèna lezo' mèna, con'a ndli tyathe guneei loo mèna loo Diox. No yende chó cón co' gàc che'n mèna gàp mèna loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Per gu', co'se' cue xlat gu', blo gu' chu'th aceit yéc gu' no ftee gu' bèu yéc gu'. No ftech gu' rloo gu' par ne'lu'de gu' gu' loo mèn nzi xlat gu' xal ndli mèn co' ntembìi ro no co' ntembìi xti's ");
INSERT INTO zamNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","par tataa mod ne'ten'te lezo' mèn le' gu' nzi xlat. Ndxe'leque', ante xud gu' Diox co' nzo no gu' non no nanee cón che'n gu'. Sya, xud gu' Diox li anggàc con' ndac loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Lomisque', ngue niin loo gu', ne: Ne'gath lyuxte gu' par que no gu' yalgon' gu' loo izlyo' ndxè', co'te' ndxeza' yalgon', no co'te' ndlyux yalgon', no co'te' nquée mxìl yalgon', no co'te' mquée mbèd yalgon', no co'te' ndli huan' huan' yalgon'. ");
INSERT INTO zamNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Más huen, fcua'n gu' mod no bli gu' par gàp gu' yalgon' loo bé' co'te' ne'quéede mxìl yalgon', no ne'huade mbèd yalgon', no co'te' yende cón li par yiza' yalgon', no co'te' ne'li huan'te huan' yalgon'. ");
INSERT INTO zamNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tac chele' gu' anze'f nque' lezo' ñèe yalgon', sya, li gu' cuent yalgon'a nac lezo' gu' no ngudloo gu' por anze'f ndyac gu' ñèe gu' yalgon'a. Le' con' co' más nac cón che'n Diox na, thìb lad nque' gu' con' co' nac cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Con ngudloo mèn ngüi' mèn chol con', ¿lé'? Per chele' mèn indyubte yo'f lezo' loo con' ngüi' mèn, mastale' ngüi' mèn loo chol con' ngüi' mèn, no chele' mèn inda'de lugar li mèn con' ye'rsin' por cón che'n con' co' ngüi' mèn, sya, nambìique' ndoo mèn no huen nque tee mèn loo Diox. Sya, ne' ne' inac ngudloo mèn co' ncua'n xquin mèn loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Per ndxe'leque', chele' mèn thìb lìte ndli xtùuz no nden' mèn le'n lezo' mèn ante li mèn con' ye'rsin' por ngüi' mèn loo con' con ngudloo mèn par gàc che'n mèna cón che'n yalgon' che'n izlyo' ndxè', mèna thidtene ncuau yéc no ncuau loo par ne'ñeede mèna chó ro yila's mèn co'se' tyoodi's mèn. Ne'ñeede lezo' mèna cón che'n xá mod ndxàal que tee ban ndac mèna. No thidtene nanguib mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Cona, ngue niin loo gu' tedib vez: Yende chó moz nzo co' li zin' loo chop patrón. Tac chele' moz li preb li moz zin' loo chop patrón, sya, yòo xyàn lezo' moz ñèe moz thìb patrón. Le' tedib patrón na, más huen tyac lezo' moz ñèe moz patrona. O bien, más altant tyoo moz loo thìb patrón. Le' loo tedib patrón na, yecloo moz. Cona, ngue niin loo gu': Yende mod li mèn sirv loo Diox chele' mèn más ndxath ndlyux loo cón che'n yalgon' che'n izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Niin loo gu', ne, ey: Ne'tyóode gu' no ne'gath lyuxte gu' par gab gu' loo lezo' gu' pá ned ya gu' zin' par que no gu' cón hua gu' no cón gu gu'. Ne' ne' tyóo gu' par gab gu' loo lezo' gu' pá ned tyee centav par tyu' xab gu' co' goc gu'. ¿Ché' ndli gu' cuent ante par hua mèn nzi ban mèn loo izlyo' ndxè', cà'? No ¿ché' ndli gu' cuent más ntac xab mèn leque ladpe' mèn, cà'? Yende xàa. ");
INSERT INTO zamNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Hui' gu' loo mbin bé' co' nxobii loo mbii. No bli gu' xtùuz cón che'n mbin. Mbin ingode bin. Ne' ne' inthop mbin cosech. Ne' ne' ingosua' mbin cosech. Mastale' tataa ndxàca loo mbin, xud gu' Diox co' nzo loo bé' neeque' xá mod huaa xud gu' Diox mbin. Ale'que' gu' más ntac leque mbin. ¡Pà ne' huaa Diox gu' xal nguaa Diox mbin! ");
INSERT INTO zamNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Chó thìb gu' co' nziri' trè' co' más ndxath ndlyux gác gu' zib gu' mase taarol metr loo gu' par yol' gu' taachu'tha? Yende xàa, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Chonon susque' ndyóo gu' cón che'n xab gu' co' nquin gu', à'? Hui' gu' loo ye' madalen co' nzo'f yii den xal ndryoo ye' madalen. Ne' ne' indli ye' madalen zin'. Ne' ne' inzìi ye' madalen dó. ");
INSERT INTO zamNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Per na ngue nii loo gu': Ne' Salomón co' ngòc rey póla ne'ngoc xabte xal ye' madalen, mastale' mque no Salomón huax xab Salomón co' nabe's natoxcua'. ");
INSERT INTO zamNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Chele' Diox tataa ndli mdoc xab yii den no yé' huize' tec mèn huana le'n rdii liz mèn, ale'que' loo gu' ne' li Diox más co' ndac xal huana. ¡Aa mèn izlyo' co' pente ndxela's loon! ");
INSERT INTO zamNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Por cona, ngue niin loo gu': Ne'tyóode gu' no ne'gath lyuxte gu' par gab gu': ¿Pá ned tyee co' hua na'? ¿Pá ned tyee co' gu na' yé' huize', yoo? No ¿pá ned tyee centav par tyu' xab na' yé' huize', ne? ");
INSERT INTO zamNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ne'lide gu' tataa tac mèn co' nziri' dib athu loo izlyo' co' inacte mèn nación Israel, mèna ncua'n no ndyóo mèna cón che'n ryethe con'a. Per xud gu' Diox co' nzo loo bé' nonque' no naneeque' le' gu' naquinque' ryete con'a. ");
INSERT INTO zamNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Con' co' ngue niin loo gu' ndxè' nac nerleque' con' ndxàal li gu': Fta' gu' lugar ñibe'pe' Diox loo gu'. No fcua'n gu' mod que tee ban lì gu' xal ndxòo lezo' Diox li gu'. Chele' gu' tataa li, sya, Diox li par que no gu' ryethe taamas con' co' nquin gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Por cona, ngue niin loo gu', ne: Ne'tyóode gu' no ne'gath lyuxte gu' nalle' cón che'n con' co' hua gu' no con' co' gu gu' no con' co' nquin gu' yé' huize'. Ne'gabte gu' loo xtàa gu': Huen ngua na' nalze. Mzyal thìb le' rol lua' na' par nduhua na' no xít na' co' gu na'. Per ¿yé', à'? ¿Cón hua na' no cón gu na'? Anxle' mbez gu' tataa. ¿Chonon anze'f ndyóo gu' cón che'n con' co' gàc loo gu' yé' huize', à'? Nzoque' huax con' co' nac cón che'n con' co' ndxàc loo gu' nalle' par tyóo gu' no par gath lyux gu' nalle', ey. ");
INSERT INTO zamNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ne'hui'de gu' no ne'ñaade gu' loo con' ndli taamas mèn par quexù' gu' mèna. Tac chele' gu' tataa tolo li, le' sya, Diox tub rez cón che'n gu' par quexù' Diox gu' yé' huize', ne. ");
INSERT INTO zamNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tac Diox tub rez cón che'n gu' co'se' gàc huiza par tetìi Diox gu' xalque' ngüi' gu' no ñaa gu' loo taamas mèn par quexù' gu' mèna. Xalque' nac mod co' ndxàp gu' con taamas mèn, tataaque' li no Diox gu' co'se' tub rez Diox cón che'n gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Xá mod más ngüi' gu' loo thìb le' chu'th yix co' nzo ngudloo hues xtàa gu' leque hui' gu' loo yix co' más naroo co' nzo ngudloo gu', co' nee di's, ale más ngüi' gu' loo ndxepte con' ye'rsin' co' ndli hues xtàa gu' no ingüi'de gu' loo huax con' ye'rsin' co' ndlipe' gu', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","No ¿xá mod ale ndli gu' ryes mbez gu' loo hues xtàa gu': Hues, led cuante. Bla' go'en thìb le' yix chu'th co' nzo ngudlool ba'. No inda'de gu' cuent cón che'n yix co' nac más naroo co' nzo ngudloo gu' ba', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Aa, que ndxác gu' ntembìi gu' ro gu' no ntembìi gu' xti's gu', ndee gu'. Ner blo' gu' yix co' nac más naroo co' nzo ngudloo gu' ba'. Le' yiloa na, gu' nee xá mod co' gu' yix chu'th co' nzo ngudloo hues xtàa gu' ba', co' nee di's, blá' gu'. Ya ne'tolode li gu' huax con' ye'rsin' co' ndli gu'. Sya, tataa mod gàp gu' razon co'x gu' loo xtàa gu' cón che'n ndxepte con' ye'rsin' co' ngue li hues xtàa gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ne'tolode ta' gu' cuent no te'th gu' cón che'n di's ndac che'n Diox loo mèn co' nac mèn nayi' no loo mèn ye'rsin' tac ne'stolque', chàa, gàc nayi' mèna loo gu' xal mbac nayi'. No ne'stolque' xìis no mèna cón che'n di's ndaca xal ndli nguch co'se' ndla's xi nguch con' ndxuhua nguch. No ndlo ndub nguch loo con' ndxuhua nguch. ");
INSERT INTO zamNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Cona, ngue niin loo gu': Co'se' cuez gu' Diox, gurez gu' Diox taandxè' mod xal ndli mèn co' ña'b con' loo xtàa mèn. Le' sya, Diox li par que no gu' con' co' ña'b gu'a. No co'se' cuez gu' Diox, bli gu' loo Diox xal ndli mèn co'se' mtuhuan mèn thìb con' ntac. Yiloa, noo noo ncua'n mèn con' mdyuhuana axta zyal con'a loo mèn. Le' sya, tataa mod li Diox par ta' Diox con' ña'b gu' loo Diox càa gu'. No co'se' cuez gu' Diox, bli gu' xal mèn co' nte's ryo' liz mèn axtaque' xal' mèn ryo' par yòo gu'. Tataa mod, li Diox que no gu' con' co' ña'b gu' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tac mèn co' tolo mbez Diox, dib nzo yéc mèn no dib nzo lezo' mèn, Diox li cas mèna. Lyath no Diox mèna no xal' Diox ned no xal' Diox yó' loo mèna par que no mèna con' co' tolo ña'b mèna loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Ché' nzo chó gu' co' nac gundan loo xin' gu', angab na'i, chele' xin' gu' ña'b con' hua xin' gu' loo gu', ché' tòo valor loo gu' no ché' tli gu' ryes ta' gu' thìb le' quèe càa xin' gu' lugar de ta' gu' pan càa xin' gu' co'se' ña'b xin' gu' pan loo gu' par hua xin' gu', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Lomisque' ne, ¿ché' tòo valor loo gu' no ché' tli gu' ryes ta' gu' thìb mbel' càa xìn' gu' co'se' ndlya's xin' gu' hua xin' gu' thìb mbèel, cà'? Ne'lide gu' ryes li gu' tataa, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mastale' nac gu' gundan más naxin no gundan ye'rsin' loo xin' gu', per gu' lyatque' lezo' ñèe gu' xin' gu'. No ta' gu' con' ndac co' ña'b xin' gu' loo gu', ¿lé'? Ale'que' xud gu' Diox co' nzo loo bé' ne' ta' con' ndac loo mèn co' ña'ba loo xud gu' Diox, co' nee di's, loo mèn co', lìcque', ndxela's loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Gu' ndlya's le' chol mèn gàp mod loo gu' loo ryethe con', ¿lé'? Lomisque', ngue niin loo gu': Gòp gu' mod loo chol mèn thidtene, que naca ndxàp mèn mod loo gu', que naca indxàpte mèn mod loo gu'. Con' ndxè' nac di's co' ñibe' ley co' mxo'f Moisés loo mèn póla. No naca leque di's co' mque' mèn co' mde'th cón che'n co' ndxab Diox ye's loo libr póla. ");
INSERT INTO zamNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Non gu' no naneeque' gu' nzo puert naya no nzo ned naya. Nagàn naca yòo mèn ro puerta no nagàn naca tyee mèn neda, ¿lé'? Lomisque' ne, nzo puert naxèn no nzo huax ned naxèn. Inagànte yòo mèn ro puerta no inagànte tyee mèn neda, ¿lé'? Mod co' ndxàp mèn loo Diox co' ndli le' mèna ndryo xà' loo Diox thidtene co'se' gath mèna, moda nac xal co'se' ndxòo mèn ro puert naxèn no xal co'se' ndyee mèn ned naxèn. Huax mèn ndli tataa. Inagànte li mèn tataa. Per mod co' ndxàp mèn par nalìte yòo mèna loo Diox loo bé' co'se' gath mèna, moda nac xal co'se' ndxòo mèn ro puert naya no xal co'se' ndyee mèn ned naya. Añenti gác mèn li mèn con'a. Ndxepte mèn ndxàp moda par yòo mèna loo Diox loo bé'. No nagàn tín' naca par li mèn tataa. ");
INSERT INTO zamNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Anderhuen gu'. Leque gu' quenap gu' loo mèn co' mbez ndyoodi's mèna cón che'n Diox per yalgutyè'i. Mèna yi'th loo gu'. No gàp mèna mod nado'. Ndxàc mèna loo gu' xal mbacxil'. Per le'n lezo' mèna nzo con' ye'rsin'. No li mèna xtùuz ye'rsin. Gàc mèna mèn nayi' xal mquè'th. ");
INSERT INTO zamNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Gu' ta' cuent còn che'n mèna por con' co' li mèna. Tarte gòn mèn làa mèn ngud uv loo chol yaa yis, ¿lé'? Ne' ne' tar gòn mèn làa mèn ngudyuug loo yaa yis cordonsant, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tataa nac mod co' ndxàp mèn xal yaa xlè. Ryete yaa huen nda' xlè huen. Le' yaa xlè co' nac yaa xlè ye'rsin' na, nda' xlè ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yende mod ta' yaa xlè, co' nac yaa xlè ndac, xlè ye'rsin'. Ne' ne' yen mod ta' yaa xlè, co' nac yaa xlè ye'rsin', xlè ndac. ");
INSERT INTO zamNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ryete yaa xlè co' inda'de xlè ndac, cho' mèn yaa xlèa no co mèn yaa xlè ye'rsin'a rdìi. ");
INSERT INTO zamNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Por cona, por mod co' ndxàp mèn, libe' gu' mèn. No ta' gu' cuent xá nac mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Iryede mèn co' mbez: Tad, loon, tyal mèna ta' mèna lugar ñibe'pe' xuden Diox loo mèna. Ndxe'leque', mèn co' ndli xal neepe' lezo' xuden Diox co' nzo loo bé', mèna tyalque' ñibe'pe' xuden Diox loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Huax mèn ñee loon, co'se' gàc huiz co'se' tub rez Diox cón che'n mèna: Tad, ¿ché' ne'nde'thte nu' di's por cón che'n lèe U'? No ¿ché' impor lèede U' mblo' nu' meexù'? No ¿ché' impor lèede U' mbli nu' huax yalguzye', à'? Neeque' U' no nonque' U' mbli nu'i, Tad. ");
INSERT INTO zamNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Per ndxe'leque', huiza càben loo mèna: Thidteneque' ne'needen gu' no indlibeden gu'. Biiche xà' gu' loon. Huàa gu' thìb lad, gu' co' más ngòo lezo' mbli gu' con' ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Chol mèn co' ndxònque' di's co' mbezen no ndli mèna xal ñibe'en loo mèna, daa tetac cón che'n mèna xal thìb mbi' co' altant ndyoo naa loo rsin'pe' mbi'. Mbi'a mxít te'f liz mbi' loo quèe co'te' maciz nac loo yòo. ");
INSERT INTO zamNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ngoloa, ngulàa yùu. Ngro' nít yòo. No mxyo'f mbii. No ngo zi'f nít yòo loo yòo cal co' nac liz mbi'a. Per ne'ngobiide yó'be' yòo cala tac ndub yòo cala loo quèe co'te' maciz loo yòo. Thìba con' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Le' tediba na, chol mèn co' ndxòn di's co' ndyoodizen, no indlide mèn xal ñibe'en, mèna lalque' nac xal thìb mbi' naad no thìb mbi' tont co' mxít te'f yòo cal liz mbi' loo yuux. ");
INSERT INTO zamNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ngoloa, ngulàa yùu. No ngro' nít yòo. No mxyo'f mbii. No ngo zi'f nít yòo yó'be'a loo yòo cal. No mblyau yòo cala. Por lult, thidtene mblyux yòo cala. ");
INSERT INTO zamNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Co'se' ngolo mdoodi's Jesús di'sa, ryete mèn co' nzi yòn di'sa, ante mbui' mèna no ante gunaa mèna cón che'n di's co' ngue lu' Jesús loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tac ndlu' Jesús mèna xal thìb mbi' co' ndxàp con' roo no con' xèn la's nii mbi' no la's ya' mbi'. No indlu'de Jesús loo mèna xal ndlu' mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Co'se' nde làa tùub Jesús loo yii co'te' ngua tub Jesús, anze'f thìb mèn ndoo nque xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Làth mèna ngo thìb mbi' co' ndyac thìb yíiz ndxa's, yíiz co' nteyèe yid lad mbi'. Mbii gax mbi' loo Jesús. Mdub xib mbi' loo Jesús. No mcòo' mbi' yéc mbi' loo Jesús. Ndxab mbi' loo Jesús: ―Tad, chele' U' lyat lezo' ñèe U' daa, nzoque' mod teyac U' daa. Fteyac U' daa. No ftembìi U' laden, Tad. ");
INSERT INTO zamNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sya, mbuàal Jesús lad mbi'. Ndxab Jesús: ―Ndlyat lezon ñèenl. Teyaquenl no tembìin ladl. Ngolo ndxab Jesús di'sa, ale chàa, ngro xbiiz lad mbi'. No mbembìi mbi' loo yíiza. ");
INSERT INTO zamNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Le' sya, ndxab Jesús loo mbi'a: ―Hui' nexa. Yende chó loo gabtel cón che'n con' co' mbli nonl ba', ndee. Ante ndlyazen huàa lu'l loo nguley'. No huàa ta'l ofrend co' mnibe' Moisés ta' mèn co' mbyac loo yíiz ba' par ta' mèn cuent no non mèn le' lùu mbyacle' loo yíiz ba'. ");
INSERT INTO zamNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Texal ngòo Jesús yèez Capernaum, mbi'th thìb capitán co' ñibe' thìb ayo solndad loo Jesús. Nalyat gunii capitán di's loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Taandxè' ndxab capitán loo Jesús: ―Tad, moz daa nax. Ngue tequech mbii moz daa. No ya ne'xecte moz tant thìb yalnè nden' moz por mbiia axta nax tinle' liz moz daa. ");
INSERT INTO zamNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ndxab Jesús loo mbi'a: ―Neeca, nal gan par teyaquen mbíiz. ");
INSERT INTO zamNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sya, mcàb capitán loo Jesús. Ndxab capitán: ―Tad, indxàalte daa par yòo U' le'n nyòo lizen. Más huen, ante ñibe' U' loo yíiz. Daa ndxelasque' biiche yíiz loo moz daa. ");
INSERT INTO zamNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tac leque daa nda cuent naquin tyubdizen loo tamas mèn co' ñibe' loon xal ñibe' mèna loon. No lomisque' nde nxon', ngue non solndad co' ñibe'en loo. Co'se' ñibe'en loo thìb solndad par ya solndad thìb mandad, solndad ya. No co'se' ñibe'en loo tedib solndad par yi'th solndad loon, solndad yi'th loon. No co'se' ñibe'en loo thìb moz daa par ya li moz daa thìb zin' loon, moz ya lii. ");
INSERT INTO zamNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Co'se' mbìn Jesús di'sa, ante mbui' Jesús no ante gunaa Jesús. Ndxab Jesús loo mèn co' ngure no Jesús: ―Lìca, na nii loo gu': Ne' làth rye mèn nación Israel tarte zyál' daa nec thìb mèn no tarte nèen nec thìb mbi' co' anze'f ndxela's loon xal mbi' ba'. ");
INSERT INTO zamNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Daa ngue nii loo gu': Huax mèn co' inacte mèn nación Israel, mèna ryo' par ned ndlyen huiz no par ned mbix huiz par yi'th queltàa no mèna Abraham no Isaac no Cob loo cón che'n Diox co'te' ñibe'pe' Diox loo mèn par tyac lezo' mèna axta plóthe. ");
INSERT INTO zamNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Per cón che'n mèn nación Israel co' ndxab Diox no co' gunii Diox le' mèna yòo co'te' ñibe'pe' Diox par ñibe'pe' Diox loo mèn, ale ndxe'leque', co' xà' Diox mèna thìb lad loo Diox co'te' nac yál'cuau co'te' nzyalque' mèna tith cue mèna loo Diox. Tya, gón' mèna axta plóthe no hua le mèna axta plóthe. ");
INSERT INTO zamNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sya, mbere Jesús, ndxab Jesús loo capitana: ―Byàa, ey. Texalque' nac co' ndxela'sl no co' nda'l cuent loon nacl, tataaque' gàca lool. No ale leque hora mbyac moz capitana. ");
INSERT INTO zamNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ngoloa, ngua Jesús liz Pedr. Gunèe Jesús nax xna'zap Pedr loo xlé'. ");
INSERT INTO zamNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Per ale ante mxo'f Jesús ya' Jesús lad xna'zap Pedr, ngro xlé' xna'zap Pedr. Sya, ngo che xna'zap Pedr. Mbli xna'zap Pedr mandad loo mèna. No mbli xna'zap Pedr cas mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Co'se' mzyèle' izlyo' huiza, mbi'th no mèn huax mèn yíiz co' mque no mbii che'n xpii ye'rsin' loo Jesús. Ante gunii Jesús loo xpii ye'rsin'a, ngro xpii ye'rsin'a loo rye mèn yíiza. No mteyac Jesús ryete mèn yíiz co' mque no chol yíiz. ");
INSERT INTO zamNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tataa mbli Jesús par ngòcque', no mdyaaque', no mdubque' di's co' gunii Sayi co' mde'th di's co' ndxab Diox. Sayi ndxab: Yub xa' mteche ryethe yíiz na' co' mden' na' no co' mque no na'. No mden' xa' ryethe yalnè cón che'n na' lad xa'. ");
INSERT INTO zamNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Látha, co'se' gunèe Jesús anze'f thìb mènléy' nziri' dib vuelt loo Jesús, mnibe' Jesús loo myen' xin' mté'th Jesús par ya riid no Jesús myen' xin' mté'th Jesús loo yòoyaa tedib lad ro lagun. ");
INSERT INTO zamNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Láth ndoore' tyee Jesús, mzin thìb mbi' co' ngòc maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn nación Israel loo Jesús. Ndxab mbi'a loo Jesús: ―Maistr, no daa ndlyaz ga non U' pál co'te' ya U'. ");
INSERT INTO zamNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mcàb Jesús loo mbi'. Ndxab Jesús: ―Hui' nexa. Mbe'th ngue no quèe lyo' co'te' ndxàt mbe'th. Le' mbin bé' na, ngue no xyòn mbin co'te' ndxàt mbin, ne. Per daa, co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, ingue noden thìb lugar co' nac che'npe'en co'te' guixen chu'th yéquen par ryo xcuen chu'th laden, co' nee di's, tegaan chu'th xísen par lin descans. ");
INSERT INTO zamNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Látha, tedib myen' xin' mté'th Jesús ndxab loo Jesús: ―Tad, daa lyaz ner ta' U' permis loon par ga casen thebol xuden. Yiloa, sya, nda na'. ");
INSERT INTO zamNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús mcàb. Ndxab Jesús loo mbi' xin' mté'th Jesús: ―Mèn co' ne'tyalte yila's loo cón chenen, mèna nac xal mèn nguth loon. La'a ca's mèna thebol xud lùu ba'. Le' lùu na, ftoo nque xísen. Ya' nda na'. ");
INSERT INTO zamNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ngoloa, ngòo Jesús loo thìb yòoyaa con myen' xin' mté'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Láth ngue tetee myen' yòoyaa loo lagun, ngro' thìb mbiidó' loo lagun axta mxít too mbii nít loo lagun. No mblo mbii nít le'n yòoyaa. Per ndxe'leque', láth ndxàc con'a, ante mde mcal' Jesús. Nax yàt Jesús le'n yòoyaa. ");
INSERT INTO zamNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Sya, yende izlyo' ngua myen' xin' mté'th Jesús co'te' nax Jesús. Mblo' myen' mcal' loo Jesús. Ndxab myen' loo Jesús: ―Tad, jer goo che U'. Blo' U' mcal' loo U'. Hui' U' ñeene' xá mod li U' par lyá' na' loo con' ryes. Yòoyaa na' ngue dep le'n nít. ");
INSERT INTO zamNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mcàb Jesús. Ndxab Jesús loo myen': ―¡Aa, mèn izlyo'! Susque' nzyeb gu', yey. Ndxepte ndxela's gu'. No ndxepte ndxàp gu' yalxla's loo Diox, ¿lé'? Sya, ngo che Jesús. Ale ante gunii Jesús loo mbiidó'a no ante gunii Jesús loo nít. Xèegà nguled mxyo'f mbiidó'a. No xèegà nguled ndxetoo nít che'n níttó' loo lagun. ");
INSERT INTO zamNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Sya, ryete mèn co' ngua no Jesús, ante mbui' no ante gunaa mèna loo con' ngòc. Ndxab mèna: ―¿Chó mbi' nac mbi' ba'? ¿Chonon tua'te ndxab mbi'? No ale xèegà nguled nxyo'f mbii. No xèegà nguled ndxetoo nít loo lagun. ");
INSERT INTO zamNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Co'se' ngolo mzin Jesús tedib lad ro lagun co' nac che'n làaz mèn gadar, ngro' chop xa'bi' le'n panteón loo Jesús. Ryop xa'bi'a mque no mbii che'n xpii ye'rsin'. No anze'f nayi' tín' ngòc ryop xa'bi'a. Axta ne' ne' yen mod riid chol mèn par neda. ");
INSERT INTO zamNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Cabii ngure bez ryop xa'bi'a loo Jesús. Ndxab xa'bi'a loo Jesús: ―¿Chonon nde U' co'te' nzo nu', à', Jesús, xgan'pe' Diox? ¿Ché' nde U' par tetìi U' nu' ndoore' gàc tiemp co'se' tetìi Diox nu', cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Leque hora, gaxte tya nzi tee yuhua thìb partid nguch. ");
INSERT INTO zamNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sya, mbii che'n xpii ye'rsin'a mbli par nalyat ndxab ryop mbi'a loo Jesús: ―Chele' U' co' nu' trè', bla' U' yòo nu' loo partid nguch co' nzi tee go'. ");
INSERT INTO zamNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sya, ndxab Jesús loo xpii ye'rsin'a: ―Gro' gu'. Huàa yòo gu' loo nguch, tá. Hora ngro xpii ye'rsin'a loo ryop xa'bi'a. Ngua yòo xpii ye'rsin'a loo partid nguch. Ngoloa ale ryete ngucha mquée mbii. Ale mbyùub nguch lad yii co'te' nzi tee yuhua nguch. Ngulàa ryete ngucha axta le'n lagun. Nguap nguch nít. Ale nguth ryete nguch. ");
INSERT INTO zamNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Le' mèn co' ngue quenap ngucha na, ale mque' mèna carre. Ngua ta' mèna cuent loo mèn làth yèez ryete con' co' ngòca, tant mzyeb mèna. No mda' mèna cuent con' ngòc loo ryop xa'bi' co' mquée mbii che'n xpii ye'rsin'a loo mèn làth yèez. ");
INSERT INTO zamNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Sya, ryete mèn yèeza ngro'. Mbi'th mèna co'te' nzo Jesús. Texal gunèe mèna Jesús, ale mna'b mèna di's loo Jesús. Ndxab mèna: ―Más huen gro' trè'. Byàa ned, ndeel. ");
INSERT INTO zamNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sya, ngòo Jesús loo thìb yòoyaa. Mdoo Jesús loo nít loo lagun. Mbii Jesús tya axta ngro xo'f Jesús tedib lad ro lagun. Mzin Jesús yèez co'te' nac làazpe' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Láth nzo Jesús tya, mzin no mèn thìb mbi' co' mtequech mbii loo Jesús. Nzo'f mbi' loo thìb cami nde no mèn mbi' loo Jesús. Co'se' gunèe Jesús le' mèna, lìcque', ndxela's loo Jesús no ngòp mèna yalxla's loo Jesús, ndxab Jesús loo mbi' yíiza: ―Huen blo lezo'l, ndee, xgan'. No gòp yalxla's loon. Xquin lùu no xtol lùu mdyon'le'. ");
INSERT INTO zamNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Per làth mèn co' nziri' loo Jesús, ngo ndxep mèn co' ngòc maistr co' mblu' cón che'n ley co' mxo'f Moisés loo mèn nación Israel. Mèna ndxab loo lezo' mèna: Lìcpe' ba'i, mbi' ba' ñii yèe ñii tìi cón che'n Diox no ngue nii mbi' ba' ngòc nguàal con' cón che'n Diox, cara. ");
INSERT INTO zamNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Per Jesús nonque' no naneeque' Jesús con' co' nzi li mèna xtùuz le'n lezo' mèna. Ndxab Jesús loo mèna: ―¿Chonon susque' nazab ngue li gu' xtùuz, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Xá nee gu'? ¿Cón más inagànte nac, ndyac gu', par gaben loo mbi' ba'? ¿Ché' más inagànte gaben: Xquin lùu no xtol lùu mdyon'le' o ché' más inagànte gaben: Goo che. Fxen ned. Byàa, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Per hui' gu' nexa. Daa lu' loo gu' le' daa, co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, daa ndxàp con' roo no con' xèn la's niin no la's yan loo izlyo' par ton'en xquin mèn no xtol mèn loo izlyo'. Sya, mbere Jesús ndxab Jesús loo mbi' co' mtequech mbii: ―Goo che. Fthùuz dáa co' ngo'thl. Bye' dáa. No tee càal ned. Byàa par lizl. ");
INSERT INTO zamNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sya, ale ngo too mbi' co' mtequech mbiia. Mxen mbi' ned. Ndyàa mbi' par liz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Co'se' gunèe mèn co' nziri' no Jesús mbli Jesús con'a, mzyeb tín' mèn. Ngurez mèna Diox. Ndxab mèna: ¡Ay, Dio's! U' ndli ndxàp mbi' ba' con' roo con' xèn la's nii mbi' no la's ya' mbi' par ndli mbi' con' roo no con' xèn loo mèn loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Co'se' mbere Jesús, ngro' Jesús yèez co'te' nac làazpe' Jesús, láth nda riid Jesús par neda, gunèe Jesús ndub thìb mbi', co' lèe Mate, loo mes co'te' ndyee thix mèn tmi cón che'n contribución. Ndxab Jesús loo mbi'a: ―Goo too. Ya' nda na'. Mate ngo too. Nda no Mate Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ngòc thìb con' thìb vez. Ngua thuhua Jesús liz Mate. Láth ndub yuhua Jesús loo mes, mzin huax mèn co' ndli cobrar cón che'n contribución no plá mèn co' ngòc mèn ye'rsin'. Thidte mdub mèn loo mes con Jesús no con myen' xin' mté'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Co'se' ñèe mèn co' nac mèn xley' farise con'a, ndxab mèna loo myen' xin' mté'th Jesús: ―¿Chonon nzi yuhua no maistr gu' mèn co' ndli cobrar cón che'n contribución no mèn co' ncua'n xquin no co' ndxàp xtol ba', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Co'se' mbìn Jesús di'sa, Jesús ndxab loo mèn xley' farise: ―Mèn co' nden' yende chó yíiz ndyac mèn no mèn co' nden' huen nzo lezo' mèn, mèna ndyac inquinte mèna doctor. Per ndxe'leque', mèn co' nden' ndyac len mèna, mèna nonque' naquinque' mèna doctor. ");
INSERT INTO zamNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Byàa gu'. No huen huen té'th gu' ñeene' cón nee di's di's co' ndub loo libr co' nac xti's Diox co' ngue niin loo gu' ndxè' co' mbez: Ndlyazen le' gu' lyat lezo' ñèe gu' hues xtàa gu'. No indlyasten guth gu' má' no xo gu' ren má' loon par teri'then no tecan'en cón che'n xquin gu' no cón che'n xtol gu'. Tac ne'ngalten par gòn mèn ron no par yila's mèn loon, mèn co' nden' nac mèna mèn nalì par lyàa yéc mèna no lyàa lezo' mèna. Ndxe'leque', ndalen par gòn mèn ron no par yila's mèn loon, mèn co' non no mèn co' nda' cuent nac mèna mèn co' ncua'n xtol no mèn co' ncua'n xquin, par lyàa yéc mèna no lyàa lezo' mèna par zye' mod co' ndxàp mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Látha, note myen' xin' mté'th Juàn Bautist, ngro' nxon', mbi'th myen' loo Jesús. Ndxab myen' loo Jesús: ―¿Chonon nu', no mèn xley' farise, mbe xlat huax vez per myen' xin' mté'th U' ba' imbe xlatte, à', Tad? ");
INSERT INTO zamNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ndxab Jesús loo myen'a: ―Nde niin thìb con' loo gu': ¿Ché' xec mèn co' ndxàc convid, mèn co' nda lyath no thìb mbyòo co' selya', par cue xi lezo' mèna par ne'huade mèna co'se' ñèe mèna nzo mbyòo co' selya' no nzo con' co' hua mèn, cà'? Yende mod cue xi lezo' mèna par cue xlat mèna tataa, ¿lé'? Hui' gu' nexa. Mèna cue xi lezo' par cue xlat mèna co'se' nguri'thle' yalhua liz mbyòo no ndyàa mbyòo co' mselya'. ");
INSERT INTO zamNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ne' ne' yen chó mèngot nzo co' co bdè' thìb le' lar' cub loo thìb lar'can' gox tac lar' cub co' yo bdè' lar'can' goxa bech. Le' sya, lar' cub, co' ngo bdè' lar'can' goxa, li par ryed yèe lar'can' goxa. No yiloa más nazab ñaa lar'can' gox chele'i naroo ryed. ");
INSERT INTO zamNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tolo ndxab Jesús loo mèna: Yende chó mèn nzo co' co mezcal co' diz ngro' palenc le'n thìb garrafón gox co' nalé'le', ne, ¿lé'? Tac chele' mèn co mezcal co' diz ngro' palenc le'n thìb garrafón gox co' nalé'le', le' sya, le'le' lyé' garrafón goxa no xyo mezcala. Ngòc perdid ryop con'a. Por cona, más huen co mèn mezcal co' diz ngro' palenc le'n thìb garrafón cub. Sya, tataa mod nabe'ste quenap mèn ryop con'a. ");
INSERT INTO zamNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Láth be' ngue toodi's no Jesús mèn, mbii gax thìb mbi' co' nac jef che'n mèn nación Israel loo Jesús. Mdub xib mbi' loo Jesús. No mcòo' mbi' yéc mbi' loo Jesús. Ndxab mbi' loo Jesús: ―Tad, rsap daa ngolole' nguth. ¿Ché' tli U' favor ya U' lizen? Lyazen ante xo'f U' ya' U' lad mza'. Mza' ryo xbanque'. ");
INSERT INTO zamNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Sya, mxen Jesús ned con myen' xin' mté'th Jesús. Nda no Jesús mbi' co' nac jefa par liz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Per láth ndoo Jesús ned, nda no Jesús mbi'a con taamas mèn, xi'th mèna ngo thìb xa'got. Xa'gota ndxàcle' si' fchop lín' ndyac xa' yíiz ndlyath ren. Mbii gax xa'gota par ned xís Jesús par gàal xa'gota ro xab Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tac xa'gota mbli xtùuz le'n lezo' xa'gota. Ndxab xa'gota loo lezo' xa'gota: Chele' daa ante gàal ro xab Jesús, yac daa. Tataa mbli xa'gota. No, chàa, mbyac xa'gota loo yíiz xa'. ");
INSERT INTO zamNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Co'be'xque' ngòc con'a loo xa'gota, Jesús mbere par ned xís Jesús. Gunèe Jesús xa'gota. Ndxab Jesús loo xa'gota: ―Rsap, huen blo lezo'l no ftac lezo'l, ndee. Lùu mbyacle' tac ngola'sque'l loo cón chenen. Leque hora, sandante mbyac xa'gota. ");
INSERT INTO zamNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Co'se' mzin Jesús liz mbi' co' nac jefa, ndxòn Jesús le' musc ndxol' bàanle' par ryo bàan mza' co' ngutha liz mza' par ya ca's mèn mza'. No ñèe Jesús ndxòo ndryo' mèn le'n nyòo par ndlas yál' mèn mza' no ndyoodi's no mèn mza'. ");
INSERT INTO zamNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ndxab Jesús loo mèn co' nzo le'n nyòoa: ―Bli gu' favor, blá' gu' mza'. No biiche gu' thìb lad loo mza'. Part cón chenen, mza' ne'ngathte. Na ngüi' loo mza' xal thìb mza' co' nax yàt. Le' sya, ale le'le' mxìis no rye mèn co' nzo liz mza' co' ngutha Jesús tac non mèna nguthque' mza'. ");
INSERT INTO zamNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Texal ngolo ngro' ryete mèna par fuer, Jesús ngòo le'n nyòo co'te' nzo'f mza'. Mxen Jesús ya' mza'. No mbli Jesús ngo che mza'. ");
INSERT INTO zamNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Syase, por derech, mxyo'f lèe mxyo'f xti's Jesús por cón che'n con' co' mbli Jesús loo mza'a le'n ryete yèezya' co' nziri' par neda. ");
INSERT INTO zamNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Texal ngro' Jesús liz mbi' co' ngòc jefa, mdoo nque chop xa'bi' sieu xís Jesús. Cabii mbez ryop xa'bi' sieua loo Jesús: ―Gulat lezo' U' gunèe U' nu', U' co' nde bin David co' ngòc rey póla. Per Jesús ne'nglide cas ryop xa'bi' sieua. Xa'bi' sieua tolo mdoo nque xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Co'se' ngòo Jesús liz mèn co'te' nguled Jesús yèez Capernaum, ryop xa'bi' sieua mbii gax loo Jesús. Jesús mnibdi's loo ryop xa'bi' sieua: ―¿Ché' ndxela's gu' le' daa gác li par hui' gu', cà'? Ryop xa'bi' sieu mcàb: ―Aa, Tad. Ndxela'sque' nu'i. ");
INSERT INTO zamNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Le' sya, ante mbuàal Jesús ngudloo ryop xa'bi' sieua. No ndxab Jesús loo ryop xa'bi' sieua: ―Gàca loo gu' xalque' ndxela's gu' loon, ndee gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Sya, chàa, ndxe'sleque' mbui' ryop xa'bi' sieua. Ngoloa, negadi's mnibe' Jesús loo ryop xa'bi' sieua. Ndxab Jesús: ―Yende chó loo gabte gu' cón che'n con' mbli non gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Per ndxe'leque', pente mbii ryop xa'bi' sieua, cón che'n con' mbli Jesús loo ryop xa'bi' co' ngòc sieua loo mèn co' nac mèn ryete yèezya' co' nziri' par neda. ");
INSERT INTO zamNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Sete ngolo mbii ryop xa'bi' sieua, mbi'th no taandxep mèn thìb mbi' mud co' mque no thìb xpii ye'rsin' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Texal ngolo xec mbli Jesús par ngro xpii ye'rsin' loo mbi' muda, ndxe'sleque' mdoodi's mbi'. Le' mèn co' nziri' no Jesús na, ante mbui' mèna no ante gunaa mèna loo mbi' muda. Ndxab mèna: ―Dib tiemp co' nziri' mèn nación Israel tarte ñee mèn gàc con' co' ngòc loo mbi' mud ba', cara. ");
INSERT INTO zamNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Per mèn che'n xley' farise ale mbez: ―Por cón che'n leque xa' co' nac jef che'n xpii meexù' ngo' Jesús xpii meexù' loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ngolo nguri'th con'a, mque tee Jesús le'n rye yèezya' no rye ranch par neda. Mque tee lu' Jesús mèn rye lugar co'te' nqueltàa mèn co'te' ndub sinagog mèn par neda. Mblo Jesús yalbàn no mde'th Jesús cón che'n di's ndac xá mod ndlya's Diox ñibe'pe Diox loo mèn. Làth xtau'a, mteyac Jesús mèn co' mque no chol yilíiz no ryete mèn nayíiz le'n rye yèezya'a. ");
INSERT INTO zamNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Co'se' gunèe Jesús prob mèna, anze'f mblyat lezo' Jesús gunèe Jesús mèna tac anze'f nzi xi lezo' mèna. No yende chó gust nziri' mèna. No más de cona, alithe nzi ban mèna. Ngòc mèna xal mbacxil' co' ingue node pastor. ");
INSERT INTO zamNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sya, ndxab Jesús loo myen' xin' mté'th Jesús: ―Lìcpe' ba'i, anze'f huax mèn nzo co' ndxàal gòn cón che'n di's ndac par lyá' mèn loo ryethe co' nac con' ryes xal co'se' ndláp mèn cosech par ne'yiza'de cosech no par ne'tyuhuante cosech. Per yende huax mèn co' ya te'th no co' ya lo yalbàn cón che'n di's ndac loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Cona, ngue niin loo gu': Gurez gu' Tad Diox no guuz gu' loo Tad Diox tel' Tad Diox mèn par ya te'th mèn no par ya lo mèn yalbàn cón che'n di's ndac loo mèn xal co'se' tel' thìb patrón moz par ya láp moz cosech patrón tac Tad Diox nac patrón loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ngolo tataa mdoodi's Jesús loo mèn, ngurez Jesús ryete si' fchop myen' xin' mté'th Jesús. Ndxab Jesús loo myen' xin' mté'th Jesús: ―Nalle' lin loo gu' par gác gu' co' gu' xpii ye'rsin' loo mèn, no par teyac gu' mèn co' ngue no chol yilíiz, no par teyac gu' ryete mèn yíiz ned ya que tee gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Taandxè' lèe ryete si' fchop myen' xin' mté'th Jesús, myen' co' mtel' Jesús co' mbe' di's che'n Jesús loo mèn no co' mde'th di's che'n Jesús loo mèn. Nerleque' myen' co' mcui Jesús ngòc Mon co' ne' tedib lèe Pedr. Mcui Jesús Ndech, ne, co' nac huespe' Pedr. Xísa nde nque Cob no Juàn, huespe' Cob. Ryop hues mbi'a ngòc xgan' thìb mbi' co' ngro' lèe Zebede. ");
INSERT INTO zamNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Xísa nde nque Lip. Nde nque Bartol. Nde nque Max. No nde nque Mate co' mbli cobrar cón che'n contribución, co' nac daa. Xísa nde nque tedib mbi' co' lèe Cob, ne. Mbi'a ngòc xgan' thìb mbi' co' ngro' lèe Alfe. Xísa nde nque Lebe co' ne' tedib lèe Tade. ");
INSERT INTO zamNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Xísa nde nque tedib mbi' co' lèe Mon. Mona nac thìb mbi' co' mqueltàa no thìb ned mèn, mèn co' ngro' lèe partid cananist. Xísa nde nque Jud Iscariot co' mcua'n mod mda'xù' Jesús loo mèn ye'rsin' yiloa. ");
INSERT INTO zamNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús mtel' ryete si' fchop myen'a. Mnibe' Jesús loo myen'a. Ndxab Jesús: ―Ne'yade gu' làaz mèn co' inacte mèn nación Israel. Ne' ne' yòo gu' co'te' nac làaz mèn nación Samari. ");
INSERT INTO zamNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Más huen huàa gu' loo mèn co' nac mèn nación Israel tac mèna nziri' xal mbacxil' co' nzi tee tuhuan. ");
INSERT INTO zamNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Huàa te'th gu' no blo gu' yalbàn no gab gu' loo mèna le' tiemp co' tlo ñibe'pe' Diox loo mèn ndxàcle' loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Fteyac gu' mèn co' ndyac yíiz ndxa's co' nteyèe yid lad no mèn co' ndyac chol yilíiz. Blo xban gu' mèn nguth. Lomisque', blo' gu' rye xpii ye'rsin' loo rye mèn co' ngue no xpii ye'rsin'. Ne'nguixte gu' nec thìb centav loon por mdan lugar gác gu' li gu' con' co' ngue ñibe'en loo gu' ndxè'. Por cona, co'se' yilo li gu' ryete con' co' ngue ñibe'en loo gu' ndxè' loo mèn, ne'lide gu' cobrar nec thìb centav loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Co'se' yòo gu' ned ya gu', tua'te gu' ya gu'. Ne'hue'de gu' pes or. Ne' ne' hue' gu' pes plat. Ne' ne' hue' gu' centav cobr. ");
INSERT INTO zamNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ne' ne' hue' gu' morral gu' co'te' co gu' che'n gu'. Ne' ne' hue' gu' chop ned xab gu' par goc gu'. Ne' ne' hue' gu' chop ned yilid. Ne' ne' co gu' mached ya' gu' co'se' tyee gu'. Tac liz mèn co'te' zin gu' co'te' co gu' yalbàn cón che'n di's ndac loo mèn, mèna ta' con' nquin gu'. Gàc con' ndxè' loo gu' xal ndxàca loo mèn co' ndyee zin' par li mèna gan con' nquin mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Co'se' zin gu' le'n chol ciuda o le'n chol yèez bix co'te' yòo gu', ner cua'n gu' mèn co' gàp confians con gu'. Yan' gu' liz mèna axtaque' ryo' gu', bii gu' le'n yèeza no ciudaa. ");
INSERT INTO zamNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Texal yòo gu' liz mèna, gunii gu' Diox loo mèn guliza. No gab gu' loo mèna: Nagàl blo gu' lezo' gu' loo alux con'. ");
INSERT INTO zamNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chele' mèn guliza nac mèn ndac co' ndli cuent ndxàalque' yòo gu' làth mèna, tolo cue rye nda mèna no rye ndye'th mèna por cón che'n gu'. Nacque'le' mèn guliza nac mèn co' ndli xtùuz indxàalte yòo gu' liz mèna, sya, gab gu' loo mèna: Huena, amiu, yan' cón che'n gu' co' ndli gu' ba' loo Diox co'se' tub rez Diox cón che'n gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","No chol mèn co' ne'ta'de lugar yòo gu' liz mèn no làaz mèn par cued gu' làaz mèn plá huiz no ne' ne' ta' mèn lugar gòn mèn di's co' co gu' yalbàn, gro' gu' liz mèna no làaz mèna. No bzib gu' yòoya's co' ndoo nii gu', co' nee di's, yan' cón che'n con' mbli no mèna gu' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","No tolo tyub quìi tyub bèel lezo' mèn ciudaa no mèn yèeza axta co'se' gàc huiz co'se' tub rez Diox cón che'n mèna. Lìcpe' ba'i, na nii loo gu': Co'se' gàc huiz co'se' tub rez Diox cón che'n mèna, más nè gàc yaltìi co' gàc loo mèna huiza leque yaltìi co' gàc loo mèn ciuda Sodom no loo mèn ciuda Gomor. ");
INSERT INTO zamNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Hui' gu' nexa. Na ngue tel' gu' loo mèn nayi'. Ya gu' loo mèna xal mbacxil' co' yub mbii loo mbée loo mèna. Nalas gure gu' loo mèn yèez no loo mèn ciuda co'te' yòo gu' xal nalas mbel' co'se' ñee mbel' mèn par xyon' mbel'. No gòc nado' gu' loo mèna xal palomxtil'. ");
INSERT INTO zamNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Anderhuen gu'. Chó Diox chó nee gu'. Nee gu' xá nda gu'. Tac loo mèn co'te' ya gu'a, mèna ta'xù' gu loo mèn co' nxo'f zin' loo cón che'n sinagog mèn. No hue' mèna gu' par tin mèna gu' co'te' nac sinagog che'n mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","No axta hue' mèna gu' loo mèn co' nac gobernador no loo mèn co' nac rey ante por cón chenen no maste. No co'se' tataa mod gàc con'a loo gu', más dibaxla's tyoodi's gu' no ta' gu' cuent cón chenen loo mèna no loo mèn dib athu loo izlyo', mèn co' inacte mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Co'se' ta'xù' mèna gu' loo mèna, ne'tyóode gu' arid cón gab gu' no cón tyoodi's gu' hora. Tac leque hora Diox li yub di's ye'th yéc gu' par gác gu' càb gu' loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tac inacte gu' co' ñii hora no co' tyoodi's hora. Ndxe'leque', Diox xud gu' li, por cón che'n Xpii Natú' che'n Diox, par gác gu' càb gu' loo mèna hora. ");
INSERT INTO zamNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Huiza, leque myen' co' ndxàc hues ta'xù' hues myen' loo mèn par guth mèna hues myen'. Lomisque' ne, leque mèn co' nac gundan ta'xù' xgan' loo mèna par guth mèna myen' co' nac xgan' gundana. Lomisque' ne, myen' co' nacle' xgan' gundan bixyath contra gundan co' nac gundan loo myen'. No axta guthxù' myen' gundan co' nac xud myen'. ");
INSERT INTO zamNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","No ale yòo xyàn lezo' ryete mèn dib athu loo izlyo' ñèe mèn gu' ante por cón chenen no maste. Per mèn co' thidteneque' mbli nèe no nxec yèe mèna axta gath mèna, mèna lyá'que' thidtene loo con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Co'se' tlo mèn, tyoo nque mèn xís gu' par tub ngu's mèn gu' le'n thìb ciuda, fxon' gu' le'n tedib ciuda. Tac, lìcpe' ba'i, na ngue nii loo gu': Le' daa, co' mbal yáal loo izlyo' ndxè' xal ndxáal chol mèn, daa gal nque xís gu' ndoore' yilo que tee gu' le'n dib nación che'n mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Fte' lezo' gu' con' ndxè: Nec thìb myen' co' nac myen' xin' mté'th thìb maistr, ne'ta'de myen'a con xtùuz co' ndli maistr no xtùuz co' ndli myen'. Lomisque' ne, nec thìb moz co' ndli zin' con patrón, ne'ta'de moza con xtùuz co' ndli patrón moz con xtùuz co' ndli moz. ");
INSERT INTO zamNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Más huen blec lezo' gu' gàc gu' mèn co' gàc xin' mté'th daa. No gàc gu' xal daa co' nac maistr gu' no li gu' xal ndlin. Lomisque' ne, blec lezo' gu' gàc gu' xal thìb moz co' lalque' nac xal patrón moz, co' nee di's, nac yub daa. Lomisque' ne, chele' mèn mbez loon le' daa co' nac xal thìb gundan co' ñibe' liz gundan, le' daa lèe Beelzebú co' nac jef che'n meexù', ale'que' loo gu' co' nac xal xin' mbi'a ne' gab mèn masre' con' axta plóthe, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Por cona, ngue niin loo gu': Ne'zyebte gu' ñèe gu' mèn co' tataa li no gu'. Tac yende nec thìb con' co' nzo casloo co' ne'ryo xo'fte. No yende nec thìb con' co' xexte ndxàc loo yál'cuau co' ne'yathte no co' ne'yènte. ");
INSERT INTO zamNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ryete con' co' ngue tan cuent loo gu' xexte ndxè', guuz gu'i loo mèn alanleque' loo xnaa. No di's co' ngue niin loo gu' xexte ndxè', cabii fte'th gu' di's ndxè' no negadi's blo gu' yalbàn cón che'n di's ndxè' par gòn ryete mèna di's ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ne'zyebte gu' ñèe gu' mèn co' ndxuth bél'yòo lad mèn. Mèna ne'lide gan guth alm no xpii xtàa mèn. Ndxe'leque', bzeb gu' gunèe gu' Diox co' ndxác cobii alm mèn no xpii mèn le'n ye'rbìil co' nac loo bèel no loo quìi ngolo nguth mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Ché' intho'de mèn chop mbin bix co' lèe mbyé' por si' centav, cà'? Ntho' mèn mbin tataa, ¿lé'? Mastale' ndli mèn cuent yende cón ntac mbin co' lèe mbyé' loo mèn, per ne' ne' gath mbina chele' Diox ne'lá'ya'de mbina gath mbina. ");
INSERT INTO zamNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","No axta yis co' ndoo yéc gu', Diox naneeque' no nonque' Diox plá yis ndoo yéc gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Por cona, ngue niin loo gu', ey: Ne'zyebte gu' ñèe gu' mèna. Le' gu' masque' ntac leque ryethe mbin co' lèe mbyé'. ");
INSERT INTO zamNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Chol mèn co' co ro cón chenen no co xo'f mèn cón chenen loo xtàa mèn co' nziri' loo izlyo', daa, ne, go xo'f no go ron cón che'n mèna loo xuden Diox co' nzo loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","No chol mèn co' cà di's cón chenen loo xtàa mèn co' nziri' loo izlyo', daa, ne, cà di's cón che'n mèna loo xuden Diox co' nzo loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ne'lide gu' xtùuz le' daa ndal par lin cue mèn rye nda mèn no rye ndye'th mèn làth xtàa mèn loo izlyo'. ¡Tyè'! Ndxe'leque', ndalen par lin yitoo di's làth mèn por cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tac daa ndal par lin yitoo di's loo mèn con xud mèn liz mèn. No lin par yitoo di's loo thìb mza' con xna' mza' liz mèn. No lin par yitoo di's loo thìb guxiix con xna'zap guxiix co'te' ya mza' guxiix liz mèn por cón chenen no maste. ");
INSERT INTO zamNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","No ale tataa mod leque mèn guliza gàc ngolo ngola's loo xtàa mèn guliza. ");
INSERT INTO zamNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Más de cona, ngue niin con' ndxè' loo gu': Le' mèn co' más nque' lezo' ñèe xud no mèn co' más nque' lezo' ñèe xna' leque que' lezo' mèna ñèe mèna daa, indxàalte mèna yòo mèna loo cón chenen. Lomisque', mèn co' más nque' lezo' ñèe xgan' no rsap leque que' lezo' mèna ñèe mèna daa, indxàalte mèna yòo mèna loo cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Chele' chó gu' lya's que tee noque' daa ned ngue tee'en, atate huiz bli gu' xtùuz co' huenleque' ñeene' ché' txec gu' par tyoo nque gu' xísen co'se' li mèn ngòc nguàal con' loo gu' por cón chenen. Tac mèn co' yòo loo cón chenen, mèn ye'rsin' tethonque' mèna xalque' ntethon solndad che'n ciuda Rom mèn co'se' ñibe' yèe solndad loo mèn hue' mèn cruzpe' mèn ndoore' que' solndad mèna loo cruz par guth solndad mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tac mèn co' ante ndoo lezo' ndxath ndxey' no ndxath ndlyux mèn par que no mèn che'npe' mèn loo izlyo' ndxè', loo mèna ne'ta'de Diox lugar yòo ban no mèna Diox thidtene. Per mèn co' lá' ryethe con' co' nac yalndac che'npe' mèn co' gác li mèn gan loo izlyo' ndxè' por cón chenen, loo mèna ta' Diox lugar par yòo ban no mèna Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Mèn co' ta' lugar yòo no gu' mèn liz mèn no làaz mèn, mèna ta' lugar yòo non mèna. Le' mèn co' ta' lugar no tyal mèn yòo non mèn, mèna ta' lugar no tyal mèna yòo no mèna xuden Diox co' mtel' daa. ");
INSERT INTO zamNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mèn co' ta' lugar yòo mèn co' nde'th di's co' ndxab Diox liz mèn no làaz mèn por nac mèna mèn co' mde'th di's co' ndxab Diox, loo mèna li Diox leque con' ndac co' li Diox loo mèn co' mde'th di's co' ndxab Diox, ne. Lomisque' ne, mèn co' ta' lugar yòo thìb mbi' nalì no thìb mbi' nambìi liz mèn no làaz mèn tac non mèn nac mbi' mbi' nalì no mbi' nambìi, loo mèna li Diox leque con' ndac co' li mèn loo mèn co' nac mèn nalì no mèn nambìi. ");
INSERT INTO zamNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Lomisque' ne, chol mèn co' ta' thìb xii nítdòp loo chol mèn prob par gu mèn proba por nac mèn proba mèn co' nac xin' mté'th daa, no por ndyoo nque mèn proba xísen, lìcpe' ba'i, na nii loo gu': Loo mèna li Diox anggàc huax con' ndac xalque' ndli Diox loo mèn co' nac xin' mté'th daa. ");
INSERT INTO zamNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Co'se' ngolo mnibe' Jesús loo myen' no mdoodi's no Jesús ryete si' fchop myen' xin' mté'th Jesús, mxen Jesús ned. Nda Jesús par ned làaz myen' par lu' Jesús no co Jesús yalbàn cón che'n di's ndac loo mèn par ned nda myen'. ");
INSERT INTO zamNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nde nxon', le'pe' ngue Juàn Bautist lezi'f le'n huiza, mbìn Juàn cón che'n co' ngue tee li Jesús. Sya, mtel' Juàn chop myen' xin' mté'th Juàn loo Jesús ");
INSERT INTO zamNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","par ya nibdi's myen' loo Jesús. Ndxab myen' loo Jesús: ―¿Ché' U' nac Crist co' ndxath yi'tha o ché' más huen cued nu' yi'th tedib xa' co' nacpe' Crist, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús mcàb. Ndxab Jesús loo myen': ―Byàa gu'. No fta' gu' cuent loo Juàn cón che'n con' co' gunèele' gu' no cón che'n con' co' mbìnle' gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Guuz gu' loo Juàn: Mèn sieu ngüi'. Mèn coj mdyoxcua' nii. No ndyee mèn coj. Mèn co' ndyac yíiz ndxa's lad, co' ndxèe yid lad, ndxac no ndxembìi mèna. Mèn cué' ndxòn di's. Mèn nguth, ale, ndryo xban. Le' loo chol mèn prob no loo mèn naxèn co' ndyac yaltìi na, ndxàthle' no ndxènle' cón che'n di's ndac co' ndlu' cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Huen nda mèn co' ne'tyoo xà'de lezo' no mèn co' ne'ten'te arid ngòc nguàal con' por cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Co'se' mbii myen' xin' mté'th Juàn Bautist loo Jesús, mtlo Jesús, mdoodi's Jesús cón che'n Juàn Bautist loo mèn co' nziri'. Ndxab Jesús loo mèna: ―Co'se' ngua tee hui' gu' Juàn co'te' nagána, ¿ché' ngua tee hui' gu' thìb xan' nixxtil' co' ngol' mbii, cà'? Yende xàa. ");
INSERT INTO zamNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Lomisque' ne, niin loo gu': ¿Chó loo ngua tee hui' gu'? ¿Ché' ngua tee hui' gu' thìb mbi' co' noc thìb ned lar' huen, cà'? Gu' nonque' no naneeque' gu' le' mèn co' ndxoc anabte lar' huen, mèna mbe liz rey, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Xá nee gu'? ¿Chó loo ngua tee hui' gu', sya? ¿Ché' ngua tee hui' gu' thìb mbi' co' nde'th di's co' ndxab Diox, sya, cà'? Aa, lìcpe' ba'i. Gu' ngua tee hui' thìb mbi' co' más ñaare' loo mèn co' mde'th di's co' ndxab Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Cón che'n Juàn Bautist nac di's co' ndub loo libr co' nac xti'sdiox co' ndxab: Na tel' ner thìb mbi' co' ya te'th ner di's ndac ndxè' lool. No lu' mbi' cón che'n lùu loo mèn par li mèn xtùuz no par tyoodi's no mèn lezo' mèn ndoore' co'se' galen loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na nii loo gu': Làth rye mèn co' ngóol xàn' nii xna' mèn no xàn' nii xud mèn, tarte gáal thìb mbi' co' nde'th di's co' ndxab Diox co' más ñaare' leque Juàn Bautist. Mastale' tataa naca, desde nalle' par delant, mèn co' nac más be'the co' ngue ta' lugar ñibe'pe' Diox loo mèn, más huen nda mèna loo Diox leque Juàn Bautist. Tac Diox co xo'f más con' ndac cón che'n Diox loo mèna leque con' co' mblo xo'f Diox loo Juàn Bautist cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tac axta co'se' ngòc tiemp co'se' mtlo Juàn Bautist, mde'th Juàn Bautist no mblo Juàn Bautist yalbàn cón che'n di's ndac, no axta huiz nalze mbyath mbyèn cón che'n di's ndac co' ndlu' xá mod ndlya's Diox ñibe'pe' Diox loo mèn. No ryete mèn co' mbìn di'sa nguátbèe par mbli mèna co' nzote mod li mèna par yòo mèna loo cón che'n Diox par ñibe'pe' Diox loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tac ryete mèn co' mde'th di's co' ndxab Diox co' mque' ye's co' nac xti's Diox, no loo libr co' ngòc ley co' mnibe' Diox co' mxo'f Moisés loo mèn ndyoodi's no nda' cuent cón che'n xá mod ndlya's Diox ñibe'pe' Diox loo mèn ndoore' gàc tiemp co'se' yi'th Juàn Bautist. ");
INSERT INTO zamNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Chele' gu' yila's di's co' ngue niin loo gu' ndxè', gola's gu' le' Juàn Bautist nac Lii co' mbyath yi'th, Lii co' mde'th di's co' ndxab Diox póla. ");
INSERT INTO zamNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Chele' gu' nden' cón nee di's co' ngue niin loo gu' ndxè', fta' gu' lugar yaa'd di's ndxè' le'n lezo' gu'. No gola's gu' di'sa. ");
INSERT INTO zamNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Xá nee gu'? ¿Con chó con' tetaquen mèn co' nzi ban tiemp ndxè', à'? Ndyaquen le' mèn co' nzi ban tiemp ndxè' nac xal myen' bix co' mbe nguith loo xbi'. No mbez yèe myen' bixa loo xtàa myen'. Mbez myen': ");
INSERT INTO zamNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nu' mbil' dii loo flaut no ale ne'ngol' niide gu'. Mbil' ro bàan nu' no ale ne'ngón'te gu' con nu'. Tataaque' nac mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Per na nii loo gu': Co'se' mbi'th Juàn Bautist, ne'ngàcte tataa loo Juàn. Tac Juàn ne'nghuade no ne'ngude Juàn axta plóthe mblya's Juàn xal nac mod co' ndxuhua chol mèn. No ale mbez gu' cón che'n Juàn: Xpii meexù' ngue tee no Juàn. ");
INSERT INTO zamNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ngoloa, ndalen, daa co' mbal yáal loo izlyo' ndxè' xal ndxáal chol mèn. Daa ndxuhua. Daa ndxu. Per co'se' ñèe gu' tataa ndxuhuan no tataa ndxun, ale mbez gu': Susque' ndxuhuacho' mbi' ba', yoo. No ale mbez gu': Susque' ndxòo lezo' mbi' ndxu mbi' vin. No ale mbez gu': Ndxàc amiu mbi' con mèn co' ndli cobrar cón che'n contribución no con mèn co' ndxàp xtol. Mastale' tataa mbez gu' nac daa, daa nii loo gu': Yende chó mport nzo lezon cón che'n con' ndli gu' xtùuz cón che'n Juàn no cón chenen tac mèn co' ndxácpe', mèna nonque' no naneeque' mèna le' con' co' ngue li Diox por cón che'n Juàn no por cón chenen nac con' ndac co' ncàb loo co' ndxác ryop nu' Juàn. ");
INSERT INTO zamNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Sya, mtlo Jesús, mbyoo Jesús rye mèn co' nac che'n rye yèez co'te' mblile' Jesús huax yalguzye' tac ne'nglàade yéc mèna no ne'nglàade lezo' mèna. Ndxab Jesús loo mèna: ");
INSERT INTO zamNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Ay, prob gu' izlyo', mèn yèez Corazín. Ay, prob gu' izlyo', mèn yèez Betsaid. Tac chele' le'n yèez Tir no le'n yèez Sidón ngàc ryethe yalguzye' ndxè' xal ndxàca loo gu' nalle', mèna nglàa yéc no nglàa lezo' mèna, no ngoc mèna lar' lut por cón che'n yalnaxi co' ngòc loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Por cona, daa ngue nii loo gu', mèn yèez Corazín no mèn yèez Betsaid: Le' loo mèn yèez Tir no loo mèn yèez Sidón más xhuite gàc yaltìi le'n huiz co'se' tub rez Diox cón che'n mèna leque co'se' tub rez Diox cón che'n gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","No gu', mèn yèez Capernaum co' nac mèn nate's no mèn naxal', ¿ché' ngue li gu' cuent no ché' nden' gu' le'n lezo' gu' le' gu' ndoo lìte yòo loo bé', cà'? Yende xàa. Ndxe'leque', gu' ndoo lìte lyàa loo quìi no loo bèel co'te' lyàa mèn co' ndryo xà' loo cón che'n Diox. Tac chele' loo mèn yèeza ngàc rye loothe yalguzye' co' ngòc loo gu'a, mèn yèeza ngyan'que' axta huiza no axta huiz nalze. ");
INSERT INTO zamNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Por cona, daa ngue nii loo gu', mèn yèez Capernaum: Co'se' gàc huiz co'se' tub rez Diox cón che'n mèn, más nè gàc yaltìi loo gu' leque loo mèn co' ngure ban ned nziri' yèez Sodom. ");
INSERT INTO zamNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Le'n huiza ndxab Jesús loo Diox: ―Diox quix U', Pay, U' co' ñibe'pe' loo alux con' loo bé' no loo izlyo'. U' mtau' yéc mèn no lezo' mèn, mèn co' mbez anze'f ndxác no mèn co' mbez nden' di's par ne'ten'te mèna di's no par ne'ta'de mèna cuent cón che'n ryop na'. Ndxe'leque', U' mblo xo'f cón che'n na' loo mèn co' nau' loo nau' yéc xal loo myen' bix. ");
INSERT INTO zamNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tataaque' mbli U', Pay, tac tataa mblya's U' li U'i. ");
INSERT INTO zamNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mbere Jesús, ndxab Jesús loo mèna tedib vez: ―Ngue niin con' ndxè' loo gu', ne: Mda'le' xuden ryethe con' ndxàp xuden la's nii xuden no la's ya' xuden loon thidte vez. Lìcpe' ba'i, yende chó mèn tarte libe' daa. No tarte ta' mèn cuent cón chenen, daa co' nac xgan' xuden Diox. Ante Diox co' nac xuden ndlibe'que' daa. No, lìcpe' ba'i, yende chó mèn nzo co' ndlibe'que' xuden Diox. Ante daa, co' nac xgan' xuden Diox, ndliben xuden Diox. No loo mèn co' ndlyazen go xo'fque'en cón che'n xuden Diox, mèna mté'thque' no nda'que' mèna cuent cón che'n xuden Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ndxab Jesús loo mèna, ne: ―Gòo gu' loo cón chenen no gola's gu' loon, gu' co' anze'f nxi lezo' por chol yaltìi co' ndxàc loo gu'. Daa li par cue see tee lezo' gu' no par tí' lezo' gu' loo ryethe con'. ");
INSERT INTO zamNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tac daa nac mbi' nado'. No indye'ste daa. Ne' ne' inxal' daa. Por cona, ngue niin loo gu': Ftubdi's gu' loon no bìn gu' di's co' ngue niin loo gu' ndxè'. No bli gu'i xal ngue ñibe'ena loo gu' xal ndxàca loo thìb ned ngon co'se' nxo'f xuan' ngon yuug xís yen ngon. Fté'th gu' co' nac cón chenen. Chele' gu' yòo loo cón chenen no yila's gu' loon xal ngue niina loo gu' ndxè', por derech, cue see tee lezo' gu' loo ryethe con'. ");
INSERT INTO zamNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tac con' co' ñibe'en loo mèn co' ndxòo loo cón chenen par li mèna, inacte con'a arid nagàn par li mèna. Ne' ne inaca xal thìb yó' co' anze'f né' par hue' mèn yó'a xís mèn. Ndxe'leque', naca thìb con' par tí' lezo' mèn no yo nagàl lezo' mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Leque le'n huiza, thìb huiz sabd co' ngòc huiz descans tiempa, Jesús nda riid con myen' xin' mté'th Jesús co'te' nax thìb le' yòo co'te' nzo'f ña' triu. Le' myen' xin' mté'th Jesús na, mblyan'. Ale mtlo myen', mcho' myen' triu. No mblobya' myen' triu la's ya' myen' par ngro' nzob triu par hua myen'. ");
INSERT INTO zamNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Làth mèn co' ndoo nque xís Jesús ngo ndxep mèn xley' farise. Co'se' ñèe mèn xley' farise ndli myen' con'a, ndxab mèn xley' farisea loo Jesús: ―Hui' nexa, mbi'. Myen' xin' mté'th lùu ngue li zin' co' indxàalte li myen' huiz sabd co' nac huiz descans, cara. ");
INSERT INTO zamNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús ndxab loo mèn xley' farise: ―Aa, ¿ché' tarte lab gu' loo libr no ché' tarte ta' gu' cuent cón che'n con' co' mbli David co' ngòc rey póla thìb vez co'se' mblyan' David con mèn co' ngure no David tiempa, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","David ngòo le'n templ. No ale mxen David pan co' ngòc pan natú' loo Diox co' mbec mèn loo mes. Indxàalte David nghua David pana con mèna. Tac pana, ante nguley', co' ndxòo le'n templ che'n Diox, ndxàp permis ndxuhua pana tiempa. ");
INSERT INTO zamNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ché' tarte lab gu' loo libr, co' ngòc ley co' mnibe' Diox mxo'f Moisés loo mèn, le' rye nguley' co' ndxòo templ indlide descans huiz descans no mxo'f zin' nguley' le'n templ huiz descans, cà'? No non gu' le' con' co' ndli nguley'a incàbte con'a xquin nguley' no xtol nguley', ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ngue niin loo gu': Trè' nzo thìb mbi' co' nac más mbi' roo mbi' xèn leque templ, co' nee di's, mbi'a nac yub daa. No con' ndlin inacte co' ngue cuanen xquin daa no xtol daa xal ndli gu' cuent. ");
INSERT INTO zamNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Gu' tarte ten' no tarte yaa'd di's loo gu' cón nee di's co' ngue niin loo gu' ndxè': Daa ndlyaz le' gu' lyat lezo' ñèe gu' hues xtàa gu'. No indlyasten le' gu' tolo guth má' par quix gu' cón che'n xtol gu' loo Diox por ren má' co' nxo gu' loo izlyo'. Le' sya, chele' gu' non no ta' gu' cuent cón nee di's co' ngue niin loo gu' ndxè', axta ne' ne' quexù' gu' daa, daa co' ingue cua'nte xquin no xtol. ");
INSERT INTO zamNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo', daa ñibe' loo mèn no niin loo mèn cón li mèn huiz sabd. Tac Diox mbli ndxàpen con' la's niin no la's yan par ñibe'en loo mèn cón li mèn huiz sabd. ");
INSERT INTO zamNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ngoloa, mbii Jesús tya. Ngòo Jesús le'n thìb sinagog che'n mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Làth mèna ngo thìb mbi' co' nayíiz sa ya'. Ya' mbi'a yende mod huin. No yende mod ga'. Sya, asembli mèna, mnibdi's mèna loo Jesús cón che'n mbi'a par cua'n mèna mod quexù' mèna Jesús. Ndxab mèna loo Jesús: ―Mbi', ¿ché' nzo mod teyac mèn thìb mèn yíiz nalze co' nac huiz descans, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mcàb Jesús loo mèna. Ndxab Jesús: ―¿Ché' nzo chó thìb gu' co' nzo làth gu' ndxè', angab na'i, chele' gu' ngue no thìb mbacxil' no ngob che mbacxil'a le'n thìb tó' le'xque' huiz sabd co' nac huiz descans, ché' ne'co'de gu' mbacxil'a le'n tó', sya, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ale'que' thìb mbi' ne' intac más leque thìb mbacxil'. Cona, ngue niin loo gu': Ndxàalque' li mèn con' ndac loo mèn huiz sabd co' nac huiz descans. ");
INSERT INTO zamNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ngolo ndxab Jesús di'sa loo mèna, ndxab Jesús loo mbi' yíiza: ―Ftega' ya'l, ey. Co'se' mtega' mbi' ya' mbi', mbyac ya' mbi' xalque' taasa lad ya' mbi' co' nac ya' huen mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sya, ngro' mèn xley' farise. Mdoodi's mèna con xtàa mèna xá mod guthxù' mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Co'se' mden' lezo' Jesús con' ndlya's mèna li no mèna Jesús, mbii Jesús tya. No anze'f thìb mèn mdoo nque xís Jesús. Làth xtau'a, mteyac Jesús mèn yíiz co' nde làth mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mnibe' Jesús loo mèna yende chó loo gabte mèna chó nac Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tataa mnibe' Jesús loo mèna par ngòcque', no mdyaaque', no mdubque' di's co' mde'th Sayi co' mde'th di's co' ndxab Diox. Sayi ndxab: ");
INSERT INTO zamNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Mbi' ndxè' nac mbi' co' nxo'f zin' zin' cón chenen. Daa mcui mbi' ndxè'. Mbi' ndxè' anze'f lezon ngudloon. No cón che'n con' ndli mbi' ndxè' anze'f ndyac tín' lezon. Daa làa Xpii Natú' co' nac Xpiipe' daa loo mbi' co' nxo'f zin' zin' cón chenen. Te'th mbi' no lu' mbi' loo mèn dib athu loo izlyo' le' daa nalì no nambìi tub rezen cón che'n rye mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ne'yoo di'ste mbi' con nec thìb mèn. Ne' ne' te'th mbi' cón che'n mbi' ayen di's ayen cuent loo mèn. Ne' ne' yo mèn co' gòn di's co' gab mbi' ayen di's ayen cuent ned riid mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ne' ne' qui's mbi' co' nxo'f zin' zin' cón chenen thìb xan' nixxtil' co' ndoo gon' no co' ndoo rec par gas nixxtil'a. Ne' ne' teche mbi'a bxec loo mech che'n lintern co' pente ndoo yol axta co'se' gàc huiz co'se' thìb lìte ñibe' mbi' co' nxo'f zin' zin' cón chenen loo mèn dib athu loo izlyo'. Ne'lide mbi'a con'a tant nado' mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","No loo mbi' co' nxo'f zin' zin' cón chenen cue quee lezo' mèn co' nac mèn dib athu loo izlyo', mèn co' inacte mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ngolo mdoodi's Jesús di'sa, mbi'th no mèn thìb mbi' sieu co' mque no thìb mbii ye'rsin' che'n meexù'. Nde nxon', mud mbi', ne. Jesús mteyac mbi'. Ngoloa, ndxe'sleque' mdoodi's mbi' no mbui' mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Co'se' ñèe mèn co' nziri' loo Jesús le' Jesús mbli con'a, ante mbui' mèna no ante gunaa mèna. Mbez mèna: ―¿Ché' mbi' ba' co' mbez mèn nac xgan' David co' ngòc rey póla, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Co'se' mbìn mèn xley' farise tataa gunii mèna no mdoodi's mèna cón che'n Jesús, ndxab mèn xley' farise loo mèna: ―Mbi' ba' ngo' xpii ye'rsin' ante por ryethe con' roo no con' xèn co' nzo la's nii no co' nzo la's ya' che'n xa' co' lèe Beelzebú co' nac jef che'n rye xpii ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Per Jesús mda' cuent no mden' lezo' Jesús xal nac xtùuz mèna. Ndxab Jesús loo mèna: ―Nde niin thìb con' loo gu', mèn xley' farise: Ryete mèn co' nxo'f zin' no gobiern loo cón che'n gobiern, chele' mèna ndxàc chop ned mèn no leque mèna bixyath contra xtàa mèn, leque mèn guth xtàa axta telux mèna xtàa mèn. Le' sya, tataa mod gobierna lyux. Lomisque' ne, chele' mèn che'n thìb yèez o thìb ned mèn guliz co' ndxàc famil ndxàc chop ned no bixyath mèna contra xtàa mèna, no bixyath mèn guliz co' ndxàc famila contra mèn guliz por mbe yoo mèna, pues mèna ne'xecte loo con'a axta lyux mèn yèeza no axta lyux mèn co' ndxàc mèn guliza, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Cona, ngue niin loo gu': Lomisque' mod ndxàca loo Mebizya, ne. Tac chele' Mebizya tlo li par gàc mèn mèn nado' loo izlyo', ¿xá mod ryo' loo co' ndlya's Mebizya li mèn, sya? Yende moda, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Gu' mbez le' daa ngo' xpii ye'rsin' loo mèn por cón che'n con' roo no con' xèn co' nzo la's nii no co' nzo la's ya' che'n xa' co' lèe Beelzebú, ¿lé'? Chele' daa tataa ndli, ¿chó nda' yalnibe' loo mèn co' ndxòo lad che'n gu' par ngo' mèna xpii ye'rsin' loo mèn co' mque no xpii ye'rsin', sya? Cona, ngue niin loo gu': Leque mèn co' ndyoo nque xís gu'a nda' cuent no ngo xo'f mèna cón che'n gu', ale nquée mbii yéc gu', no ndxos xtùuz gu', no ne' ne' inda' gu' cuent cón mbez gu' co'se' ndli gu' xtùuz cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ndxe'leque', daa ngo' xpii ye'rsin' loo mèn por cón che'n Xpii Natú' che'n Diox. No con' ndlin loo mèna ndlu' loo mèn par ta' mèn cuent no non mèn mzinle' tiemp co' ngue ñibe'pe' Diox loo mèn làth gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Gunee gu' loon: ¿Xá mod gàc yòo chol mèn liz thìb mbi' tín' co' anze'f nayi' par li huan' mèna con' co' nac che'n mbi'a chele' mèn ne'tyente mbi' par ner quedó' mèn mbi'? Chele' mèn ante tataa gác li loo mbi', le' sya, nzoque' mod li huan' mèna che'n mbi' co' ndxàp mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mèn co' inda'de lad chenen, mèna nac ngolo ngola's loon. Lomisque' ne, mèn co' inqueltàa node daa par lyath no mèn daa par gon taamas mèn loo cón che'n Diox, ale ndxe'leque', le'le' ndli mèna ndryo xà' taamas mèn loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Cona, ngue niin loo gu': Nzoque' mod tyon' rye xtol mèn no xquin mèn co' mcua'n mèn. No nzoque' mod tyon' rye di's co' ñii yèe ñii tìi mèn cón che'n Diox. Per chele' chol mèn ñii yèe ñii tìi cón che'n Xpii Natú', mèna, por derech, thidteneque' ne'tyon'te xtol no xquin. ");
INSERT INTO zamNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Chol mèn co' ñii yèe ñii tìi cón chenen, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, nzoque' mod tyon' xtol no xquin mèna chele' mèna ña'ba loo Diox ton' Diox xtol mèna. Per chele' chol mèn ñii yèe ñii tìi cón che'n Xpii Natú', mèna, por derech, thidteneque' ne'tyon'te xtol no xquin mèn, que naca naban mèn loo izlyo' ndxè', que naca yòo ban mèn tedib izlyo' co' cue yiloa. ");
INSERT INTO zamNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Angab na'i, chele' gu' too thìb xan' yaa xlè co' ta' xlè ndac, yaa xlèa ta' xlè ndac. No chele' gu' too thìb xan' yaa xlè ye'rsin', yaa xlèa ta' xlè ye'rsin'. Sya, mèn libe' no ta' mèn cuent cón che'n yaa xlèa por thìb loo thìb loo xlè co' nda' yaa xlèa. Tataa ndxàc be' mèn, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Aa mèn ye'rsin' co' nac xal mbel' co' lèe huid! ¿Xá mod gác gu' tyoodi's gu' con' ndac co'se' angcual nac gu' mèn ye'rsin', à'? Yende mod tyoodi's gu' con' ndac. Tac di's co' alithe ndyoodi's chol mèn, di'sa nac di's co' alithe ndye'th xtùuz mèn co' ndyro' ndlyen' lezo' mèn par tyoodi's mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tolo ndxab Jesús loo mèna: ―Nde niin tedib con' loo gu': Mèn co' nac mèn ndac, mèna ndxòo lezo' ndyoodi's con' ndac. Tac con' ndac co' ndyoodi's mèna nac di's co' ndryo' le'n lezo' mèna. Le' mèn co' nac mèn ye'rsin' na, mèna ndxòo lezo' ndyoodi's con' ye'rsin'. Tac con' ye'rsin' co' ndyoodi's mèna, lomisque', ndryo' le'n lezo' mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Más de cona, niin loo gu': Ryete di's co' alithe ndyoodi's mèn, cón che'n leque di'sa ta' mèn cuent loo Diox co'se' gàc huiz co' tub rez Diox cón che'n mèn loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tac leque di's co' tyoodi's gu' no co' ta' gu' cuent huiza, leque di'sa co xo'f gu' par ñeene' chó mèn nac gu', ¿ché' nac gu' mèn ndac no mèn nalì o ché' nac gu' mèn co' ncua'n xquin no xtol par thidtene quexù' Diox gu' no tetìi Diox gu'? ");
INSERT INTO zamNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sya, plá mèn xley' farise no plá mèn co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, ndxab mèna loo Jesús: ―Maistr, nu' ndlya's ñèe le' lùu li thìb con' co' gàc thìb yalguzye' loo nu'. ");
INSERT INTO zamNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús mcàb loo mèna. Ndxab Jesús: ―¿Mèn co' ngolo ngolux ñibe' loon par lin thìb con' co' nac yalguzye', cà'? Yende xàa. Ya yende chó más yalguzye' gàc loo mèn ba'. Ndxe'leque', thìb señ co' hui' mèn ba' gàc loo mèn xal señ co' ngòc loo Jonás co' mde'th di's co' ndxab Diox póla. ");
INSERT INTO zamNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tac texal ngo Jonás le'n xti' thìb mbèel roo, co' mtoxcua' Diox, le'n son huiz no le'n son yál', tataa daa ne, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, daa go le'n bá' le'n son huiz no le'n son yál'. ");
INSERT INTO zamNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tolo niin loo gu': Mèn ciuda Nínive co' ngure ban póla ryo' too loo mèn, co'se' gàc huiz co' tub rez Diox cón che'n ryethe mèn co' nzi ban tiemp ndxè', par quexù' mèn ciuda Nínive mèn co' nzi ban tiemp ndxè'. Tac mèn ciuda Nínive ngulàa yéc no ngulàa lezo' loo xtol mèn no loo xquin mèn no mzye' mod co' ngòp mèna co'se' mde'th Jonás no mblo Jonás yalbàn cón che'n di's ndac che'npe' Diox loo mèna. No nalle' na nii loo gu': Trè' nzo thìb mbi' loo gu', co' nac daa, co' nac más mbi' roo mbi' xèn leque Jonás. ");
INSERT INTO zamNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Lomisque' ne, thìb xa'got co' ngòc rein loo nación co' ngure par ned sur tiempa, xa'gota, ne, ryo' too loo mèn co'se' gàc huiz co' tub rez Diox cón che'n mèn co' nziri' tiemp ndxè' par tolo quexù' xa'gota mèn co' nziri' tiemp ndxè' loo Diox. Tac xa'gota ngro' làaz xa' co' ngureri' tedib lad ro izlyo' co'te' ngòc más tith tiempa par mbi'th yòn xa'gota di's co' ngòc di's co' ngóc Salomón co' ngòc rey tiempa. No nalle' na nii loo gu': Trè' nzo thìb mbi', co' nac daa, co' nac más mbi' roo mbi' xèn leque Salomón. ");
INSERT INTO zamNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Niin tedib con' loo gu', ne: Co'se' ndryo' thìb xpii ye'rsin' loo thìb mèn, xpiia ngro'. No nda que tee xpiia co'te' nagán par cua'n xpii co'te' yòo xpii par li xpii descans. Per co'se' ñee xpii yende pá yòo xpii, ndli xpii xtùuz. ");
INSERT INTO zamNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","No mbez xpii loo lezo' xpii: ¿Cón lin? Capas daa, beren, ndyàan loo mbi' co'te' ngro'ena. Per co'se' mbere xpiia, ndye'th xpii loo mbi', ñèe xpii mbi'a xal thìb liz mèn co' nítleque' mblyo'f no co' mblyath no co' nabe'ste ñaa. ");
INSERT INTO zamNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sya, bere xpiia, ya xpiia, ya xi xpii taagaz xpii co' nac más xpii ye'rsin' leque xpiia. Sya, yòo rye xpiia loo prob mbi'a. Le' sya, por lult más nazab tyen mbii mbi'a no quée mbii loo mbi'a leque co'se' ner vez ngòo xpii loo mbi'a. Tataa gàca loo mèn co' nac bin ye'rsin' co' nziri' tiemp ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús tatabe' ndoo toodi's loo mèn co' nziri' loo Jesús co'se' mzin xna' Jesús no myen' huespe' Jesús gax co'te' ngo Jesús. Ne'ngòode xa'. Par fuer no maste ngure xa'. Mblya's xa' toodi's no xa' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sya, thìb xa' co' ndoo xì'tha xexte ndxab loo Jesús: ―Xna' U' no myen' huespe' U' nzi fuer ba'. No ndlya's xa' tyoodi's no xa' U', Tad. ");
INSERT INTO zamNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Per ndxe'leque', Jesús mcàb loo xa' co' mbli avis loo Jesús. Ndxab Jesús: ―¿Ché' ndlya'sl niin lool chó mèn, lìcque', nac xal xnan no chó mèn, lìcque', nac xal huesen, cà'? Na nii lool chó nac xal xnan no chó nac xal huesen. ");
INSERT INTO zamNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Sya, mblu' Jesús myen' xin' mté'th Jesús loo xa'a no loo mèn co' nziri'a. Ndxab Jesús: ―Myen' ba' nac xal xnan no myen' ba' nac xal huespe'en, ne, ey. ");
INSERT INTO zamNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tac chol mèn co' ndli xal nee lezo' xuden Diox co' nzo loo bé' no xal ndlya's xuden Diox, mèna nac xal huesen. Mèna nac xal ftanen. No nac mèna xal xnan. ");
INSERT INTO zamNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Leque huiza ngro' Jesús liz thìb mbi' co'te' ngo Jesús. Ngua tub Jesús ro thìb lagun co' nziri' tya. ");
INSERT INTO zamNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Huiza, anze'f thìb mèn mqueltàa co'te' mdub Jesús. Sya, ngo too Jesús. Ngua tub Jesús le'n thìb yòoyaa loo lagun. Le' mèna na, ngure loo yux ro lagun loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sya, mtlo Jesús. Alithe mtetac Jesús huax con' loo mèna. Ndxab Jesús loo mèna: ―Nde niin thìb con' loo gu': Ngo thìb mbi' co' ngo bin. ");
INSERT INTO zamNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mbi' ngro', ngua lo mbi' bin. Láth nge go mbi' bina, ngulàa ndxep bin ro ned. Ngoloa, mbi'th mbin bé'. Mblo' mbin biz bina loo yòo. Nduhua mbin biz bina. ");
INSERT INTO zamNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Le' taandxep biz bina na, ngulàa loo yòo quèe co'te' xite yòo nzi'f loo quèe. Setilte ngulen biz bina tac inacha'de nzi'f yòo loo quèea. ");
INSERT INTO zamNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Per co'se' mtlo mdín bée biz bina, ale mtec mso' bée biz bina tac yende arid xcop loo yòo co'te' ngulen biz bina tac yende pá ned xon' no lyàa lox biz bina. Ale mbiiz bina. ");
INSERT INTO zamNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Le' taandxep biz bina na, ngulàa le'n huan. No más mbryoo mxyèn huan leque biz bina. Ale mblyus biz bina nzo biz bina le'n huan. ");
INSERT INTO zamNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Le' taandxep biz bina na, ngulàa loo yòo be'f. Biz bina mda' thìb cosech ndac. Chó biz bina mda' thìb ayo nzob. Chó biz bina mda' ayon nzob. Chó biz bina mda' gal psi' nzob tac huenque' ngòc cosech che'n biz bina loo yòoa. ");
INSERT INTO zamNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Chele' gu' nden' cón nee di's ndxè', fta' gu' lugar yaa'd di's ndxè' le'n lezo' gu'. No fta' gu' cuent cón nee di's di's co' ngue niin loo gu' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Sya, mbii gax myen' xin' mté'th Jesús loo Jesús. Ndxab myen' loo Jesús: ―Tad, ¿chonon tatua' ndyoodi's U' loo mèn ba' con di's co' alithe mtetac U' ba', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús mcàb loo myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Loo mèna, tataa mdyoodizen tac mèna indxaa'dte di's. Ne' ne' gác mèna ta' mèna cuent cón che'n di's co' ndlu'en loo mèn. Per part cón che'n gu', Diox ngue li le' gu' nda' cuent cón che'n mod co' be' nacasloo xá mod ndlya's Diox ñibe'pe' Diox loo mèn, Diox co' ndub loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Lomisque' ne, mèn co' ngue no con', tolo que no mèna más con' axtaque' que no mèna huax con'. Per ndxe'leque', mèn co' ingue node con', ale tyuhuan mèna ndxepte con' ngue no mèna. Con'a nee di's, tolo gòn mèn no tolo ta' mèna cuent cón che'n con' co' nac cón che'n Diox. Per mèn co' indxaa'dte di's no co' inda'de cuent cón che'n Diox no mèn co' indyalte tolo gòn cón che'n Diox, loo mèna Diox li tolo yau' xtùuz mèna no tolo yau' lezo' mèna loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Cona, ndyoodizen loo mèna con di's co' alithe ntetaquen tac mèna ngue li cuent ngue hui' ndac mèna no ndxòn ndac mèna loo cón chenen. No ndli mèna cuent ndxòn ndac mèna di's co' ndlu' cón chenen. Per ndxe'leque', nac mèna xal mèn co' ne'ñeede cón ngue hui' mèna loo cón chenen. Lomisque', nac mèna xal mèn co' inda' ndacte cuent cón chenen. Ndxàca tataa loo mèna tac indxaa'dte di's co' ndyoodizen yéc mèn. Ne' ne' inda' mèna cuent cón ngue lin. ");
INSERT INTO zamNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","No nalle' ndxàcque' con' loo mèna xal nac di's co' ndxab Sayi co' mde'th di's co' ndxab Diox. Ndxab Sayi: Lìcpe' ba'i, mèn gòn di's co' tyoodizen. Per ne'yaa'dte mèna di'sa. Lìcpe' ba'i, mèn hui' loo con' lin. Per ne'ta'de mèn cuent cón ngue lin. ");
INSERT INTO zamNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tac lezo' mèna no xtùuz mèna ngòc naad no ngòc nguud. Anze'f nazab ndxòn mèna di's no nden' mèna di's co' ndyoodizen. Loo cón che'n Diox nac mèna xal mèn sieu. No nac mèna xal mèn co' nathath ngüi' loo cón che'n Diox. Ale ryethe con'a ndxàc loo mèna par ne'ta'de mèna cuent no par ne'gònte mèna cón che'n Diox ne' ne' yaa'd di'sa le'n xtùuz mèna no le'n lezo' mèna. Rye con'a ncàb loo mèna par ne'tyalte mèna lyàa yéc mèna no lyàa lezo' mèna. Ne' ne' tyal mèna par zye' mod co' ndxàp mèna par telá'en mèna loo con' ryes. Cona, tataa ndxàca loo mèna xal gunii Sayi cón che'n mèna póla. ");
INSERT INTO zamNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Huen nda gu', ey, tac gu' ngüi'que' no ndxònque' gu' co' huen huen cón che'n Diox. No ndxaa'dque' gu' di's co' ngue niin loo gu' le'n xtùuz gu' no le'n lezo' gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Lìcpe' ba'i, na nii loo gu': ―Huax mèn co' ngo póla, mèn co' ngòc mèn co' mde'th di's co' ndxab Diox no taamas mèn co' ngòc mèn ndac, anze'f mblya's mèna ngüi' mèna loo con' co' ngüi' gu' nalle'. Per ne'ngàcte gan ngüi' mèna con' ndxè'. Lomisque' ne, mblya's mèna ngòn mèna cón che'n con' co' ndxòn gu' nalle'. Per ne'ngàcte gan ngòn mèna cón che'n con' co' ndxòn gu' nalle'. ");
INSERT INTO zamNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Bìn gu' di's co' tan cuent loo gu' nalle' co' alithe mtetaquen loo gu'a, co' nee di's, cón che'n thìb mbi' co' mblo biz bina. ");
INSERT INTO zamNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Di's co' guniin loo gu'a nac con' ndxè': Mèn co' ndxòn di's co' nac di's ndac che'n Diox co' ndlu' xá mod ndlya's Diox ñibe'pe' Diox loo mèn, no indxaa'dte di'sa le'n lezo' mèna, ne' ne' inda' mèn cuent cón che'n di'sa, mèna nac xal biz bin co' ngulàa ro ned. Tac co'se' ndxi'th Mebizya loo mèna, ndli Mebizya loo mèna par ne'ten'te mèna no par setilte yathla's mèna cón che'n di's ndac co' mbìn mèna no co' ngulàa le'n xtùuz mèna no co' ngulàa le'n lezo' mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Le' biz bin co' ngulàa loo yòo quèea na, nac xal mèn co' ndxòn cón che'n di's ndaca. No co'se' ndxòn mèna cón che'n di's ndaca, ndyac tín' lezo' mèn ndxòn mèn cón che'n di'sa. ");
INSERT INTO zamNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Per yiloa pláte huiz ndxàc ndxòn mèna cón che'n di's ndaca, ndxàca loo mèn xal biz bin co' ngulàa loo yòo quèea. Biz bina ne'ngxecte por yende co'te' lyàa lox biz bina no yende pá xon' lox biz bina. Tac co'se' ndxàc ngòc nguàal con' loo mèna no co'se' ndyub ngu's mèn prob mèna por cón che'n di's ndac, le' sya, xexte ndlá' mèna. Ya indlya'ste mèna tolo gòn mèna cón che'n di's ndac che'n Diox tac ngo tac lezo' mèna loo con'a. ");
INSERT INTO zamNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Le' biz bin co' ngulàa le'n huana na, ndlu' loo na' cón che'n mèn co' ndxòn cón che'n di's ndac. Per mèna más nde yath ñèe yalgon' co' nthop mèn loo izlyo' ndxè'. Le' sya, yalgon' co' ndxàp mèn loo izlyo' ndxè', por yalgon'a leque mèna nquedìi mèna par ndxau' yéc mèn no ndxau' lezo' mèn loo cón che'n Diox. Por cona, incàb ndacte nec thìb con' ndac loo mèna loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Le' biz bin co' ngulàa loo yòo be'fa na, ndlu' loo na' cón che'n mèn co' ndxaa'd cón che'n di's ndac co' ngulàa le'n xtùuz mèn no le'n lezo' mèn. Le' sya, mèna ndli par ndxòn taamas mèn cón che'n di's ndac no par yòo taamas mèn loo cón che'n Diox. Tataa mod nac mèna xal biz bin co' nda' thìb cosech ndac, co' nee di's, chó biz bin nda' thìb ayo xlè. Chó biz bin nda' ayon xlè. Chó biz bin nda' gal psi' xlè. ");
INSERT INTO zamNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús ndxab loo mèna: ―Nde tetaquen tedib con' loo gu': Con' co' ndxàc par ñibe'pe' Diox loo mèn nac xal nac di's co' nde niin loo gu' ndxè'. Thìb mbi' ngro', ngua lo mbi' biz bin co' nac nzob bin triu ndac loo xyòn mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Per co'se' ryete mèn guliz mbi' co' ngòc xuan' yòoa mxen mcal', ngòo tedib mbi' co' ngòc ngolo ngola's mbi'a loo xyòn mbi'a. Ngua lobii mbi' biz nzob bin triu huan co' ñaa xalque' ñaa nzob bin triua loo xyòn mbi'. Ngoloa, ndyàa mbi' co' ngòc ngolo ngola's mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Per co'se' ngulen nzob bin triua, no mbryoo mxyèna, no mtlo ngos bacdò ña' triua, axta syare', thidte gunaa ña' triua con biz huan co' ngua lobii mbi'a loo xyòn tedib mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sya, ngua nee moza loo mbi' co' ngòc patrón moz. Ndxab moz loo mbi': ―Tad, chele' U' ngua lo ante nzob bin triu ndac loo xyòn U', ¿pá ned ngro' biz huan co' ñaa xal ñaa triu le'n ña' sya, Tad? ¿Xá mod ngulen biz bina le'n ña', ne, Tad? ");
INSERT INTO zamNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Patrón mcàb loo moz. Ndxab patrón: ―Nzo chó mbi' co' ndxecloo ñèe daa ngua li con'a loo xyònen. Sya, mnibdi's moz loo patrón. Ndxab moz: ―¿Ché' ndlya's U' ya quib nu' huan co' ñaa xal ñaa ña', cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Per patrón ndxab loo moza: ―Aa'a. La' tee nzo'fa. Ne'ya quibtel huana le'n ña'. Tac chele' lùu quib huana, nzo ryes quib lùu ña', ne. ");
INSERT INTO zamNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","La'a thidte ryoo triu huana con ña' triu más huen axta co'se' gàc tiemp lyáp ña'. Sya, por derech, tel'en moz co' ya li zin' par quib moz huan ye'rsin'a no, yiloa, tedó' moz huana por manoj par tec moz huana loo quìi. Le' nzob triu ndaca na, cosua' moz le'n sac co'se' yilo láp moz triu ndaca. ");
INSERT INTO zamNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Mtetac Jesús tedib di's loo mèn. Ndxab Jesús: ―Nde niin tedib con' loo gu': Mod co' tlo queltàa mèn co' tyal par tlo Diox, ñibe'pe' Diox loo mèn nac xal thìb biz bin bix che'n mostaz co' mblo thìb mbi' bin loo xyòn mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","No, lìcpe' ba'i, biz bin mostaza nac thìb biz bin más bix loo rye loothe biz bin co' nzo. Per co'se' ndlyen biz bin mostaza no ndryooi, ndxàca thìb xan' huan co' más ndryoo no nxyèn le'n ña' mèn. No ndxàca casque' xal thìb xan' yaa co'te' ndlyàa mbin bé' par ntoxcua' mbin xyòn mbin loo ram yaaa. ");
INSERT INTO zamNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Diox co' ngue tlo ñibe' loo mèn, nerleque' mtlo Diox, ñibe' Diox loo nagabte mèn no más. No xèegà xèegà tolo yar' mèn co' ngue ñibe' Diox loo axta nzoque' mèn dib athu loo izlyo', mèn co' ñibe' Diox loo. Cón che'n mèna nac xal ndxep dii levadur co' ndyen thìb xa'got par ncos xa' diia con son kil harin. No con le' laate diia tyub bes son kil harina. ");
INSERT INTO zamNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ryete con'a mdoodi's no Jesús mèn co' mqueltàa loo Jesús co' ngòc di's co' mtetac Jesús loo mèn. Asembli Jesús ante mtetac Jesús di's loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tataa ngòc co' mbli Jesús par ngòcque', no mdyaaque', no mdubque' di's co' gunii thìb mbi' co' mde'th di's co' ndxab Diox, co'se' mque' mbi'a ye's loo thìb libr, di's co' mbez: Daa tyoodiz con mèn ante con di's co' tetaquen loo mèn. Daa tyoodiz no mèn no tan cuent loo mèn cón che'n con' co' nacasloo axta co'se' mbli Diox ngure izlyo' no mblec Diox izlyo' no axta nalle'. ");
INSERT INTO zamNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ngolo gunii Jesús Diox loo mèn co' mqueltàa loo Jesús ro laguna, mbii Jesús tya. Ngòo Jesús liz thìb mbi' co' ndub gaxte tya. Liz mbi'a mqueltàa ryete myen' xin' mté'th Jesús loo Jesús. Ndxab myen' loo Jesús: ―Tad, blo xo'f U' di's co' mtetac U' cón che'n huan ye'rsin' co' ñaa xal ñaa triu loo nu' co' ngo no co' ngulen loo xyòn mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús mcàb loo myen' xin' mté'th Jesús. Ndxab Jesús loo myen'a: ―Xa' co' ngo nzob bin ndac co' nac triu, xa'a nac daa, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","No con' co' nee di's co'te' nac xyòn mbi'a co'te' ngo bina, con'a ndlu' loo na' nac izlyo' ndxè'. Le' nzob bina na, ndlu' loo na' nac mèn co' Diox, lìcque', ñibe'pe' loo. Le' triu huan ye'rsin' co' ngulen le'n ña' triua na, ndlu' loo na' nac mèn co' nac che'npe' Mebizya. ");
INSERT INTO zamNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Le' xa' co' nac ngolo ngola's co' mblo bin ye'rsin'a na, ndlu' loo na' nac yub Mebizya. Le' co'se' ngolo ngòc cosecha na, con'a ndlu' co'se' lyux no co'se' lith no izlyo' ndxè'. Le' mèn co' thop cosecha na, ndlu' loo na' nac angl co' yi'th thop mèn huen no mèn ye'rsin' co'se' lith no no lyux izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Xalque' mthop moz triu huan ye'rsin' co' ñaa xal ñaa ña'a par tec moz huana loo quìi, tataa gàca loo mèn, ne, co'se' lith no no lyux izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn, daa tel' angl daa co'se' gàc tiempa par yi'th thop angl rye mèn ye'rsin' co' ndli par ncua'n taamas mèn xtol mèn no chol mèn co' ncua'n xquin no xtol, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Co angl rye mèn ye'rsin'a le'n ye'rbìil co'te' nzo quìi no bèel. Tya, gón' mèna no hua le mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Sya, mèn co' mdyal, mèn co' mbli co' mnibe'pe' Diox loo mèn, loo mèna quée xnìi xal co'se' ndxa'x xnìi huiz co'se' gàc tiemp co' ñibe'pe' Diox xud gu' loo ryethe con'. Gu' co' nden' co' nee di's co' ngue niin loo gu' ndxè', fta' gu' lugar yaa'd di's ndxè' le'n lezo' gu'. No gola's gu' loo di's co' ngue niin loo gu' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tolo ndxab Jesús loo mèna: Nde tetaquen tedib con' loo gu': Con' co' nden' mèn no ndyac lezo' mèn cón che'n Diox, mèn co' tlo yila's loo Diox tac Diox mdyal yòo mèn loo cón che'n Diox, nac thìb con' ndac tín' xal co'se' mzyal thìb mbi' tmi co' nzo casloo loo xyòn thìb xtàa mbi'. Per co'se' mzyal mbi' tmi co' nzo casloo loo xyòn xtàa mbi'a, ale mbere mbi', mtau' mbi' loo tmia tya tedib vez. No de tant ndyac lezo' mbi' co'se' mzyal mbi' tmi loo xyòn tedib mbi', ale mbere mbi', ndye'th mbi', mtho' mbi' rye con' ndxàp mbi' par ti' mbi' xyòn mèna loo mèn co' nac che'n yòoa. ");
INSERT INTO zamNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Mèn co' ñibe'pe' Diox loo nac xal thìb mbi' co' ndyee viaj co' ngue tee cua'n perl co' anze'f náp ntac. ");
INSERT INTO zamNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Co'se' mzyal mbi' perl co' anze'f náp ntac, mbere mbi', ndye'th mbi' par liz mbi' par tho' mbi' rye con' ndxàp mbi' par ryo' tmi loo con' ndxàp mbi'. Sya, bere mbi', ya mbi' par ti' mbi' perl co' anze'f ntac. Tataa mod nden' mèn co' ndyal ñibe'pe' Diox loo mèn tac anze'f thìb con' ndac no con' huen ndli Diox loo mèna tataa. ");
INSERT INTO zamNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Mèn nde'th no ngo mèn yalbàn cón che'n di's ndac xá mod ndlya's Diox ñibe'pe' Diox loo mèn. Huax mèn nqueltàa no mèn co' ngòo loo cón che'n Diox xal ndxàca co'se' ngobii mèn thìb yex le'n níttó'. No co'se' ndlyàa yexa le'n níttó', ndxegaa huax loo mbèel le'n yex. ");
INSERT INTO zamNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","No co'se' ndxegaa huax loo mbèel le'n yex, le' sya, mèn co' ndyen mbèel ngo' yex par ro play. Tya, ndyub mèna par noo noo co' mèna mbèel ye'rsin'. No ngobii mèn mbèel ye'rsin'a thìb lad. Le' mbèel co' nac mbèel huena na, mbèela ngòo mèn le'n thìb cardor. ");
INSERT INTO zamNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tataaque' gàca co'se' zin huiz no zin ze co'se' ñibe' Diox lyux izlyo' no lith no izlyo'. Sya, ryo' angl. No co' xà' angl mèn ye'rsin' làth mèn nalì no làth mèn nambìi. ");
INSERT INTO zamNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Co angl mèn ye'rsin'a le'n ye'rbìil co'te' ndxetoo bèel no quìi. Tya, gón' mèna no hua le mèna tant nè naca, ndyac mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sya, mnibdi's Jesús loo myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―¿Ché' ndxaa'd ryethe di's ndxè' le'n quèe yéc gu' no le'n lezo' gu', à'? Myen' xin' mté'th Jesús ndxab: ―Aa, Tad. Ndxaa'dque' di's ba' le'n quèe yéc nu' no le'n lezo' nu'. ");
INSERT INTO zamNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sya, ndxab Jesús loo myen' xin' mté'th Jesús: ―Co'se' huen huen mté'th thìb mbi' cón che'n ley co' mxo'f Moisés loo mèn no yiloa mtlo mbi', huen huen mtéth mbi'a cón che'n xá mod ñibe'pe' Diox loo mèn nalle', ndxàc loo mbi'a xal loo thìb patrón co' ngo' con' cub no con' gox le'n cuart co'te' ngocsua' patrona rye con' ndac che'n patrón. ");
INSERT INTO zamNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Co'se' ngolo mda' Jesús cuent cón nee di's di's co' angmtetac Jesús loo mèn, mbii Jesús tya. Ndyàa Jesús par làaz Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Co'se' mzin Jesús làaz Jesús, tya mtlo Jesús, mblu' Jesús mèn co'te' ndub sinagog che'n mèn gulàaz Jesús. Le' rye mèn co' mqueltàa le'n sinagoga na, ante ngüi' mèna no ante ñaa mèna loo Jesús. No mbez mèna loo xtàa mèna: ―¿Pá ngua té'th mbi' ba' rye con' co' ndxác mbi' no xá mod susque' ndxác mbi' ba' ndli mbi' yalguzye' co' ndli mbi' ba', ne? ");
INSERT INTO zamNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Na' nanee le' mbi' ba' nac xgan' Chè carpinter. No nac mbi' xgan' Mari. Nanee na' le' mbi' ba' ndxàc hues Cob, hues Chè, hues Mon, no hues Jud. ");
INSERT INTO zamNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","No myen'got co' nac fta'n mbi' ba' nzo ban làth na' trè'. ¿Xá mod susque' ndxác mbi' ba' ndli mbi' ryete yalguzye' co' ndli mbi' ba'? No sate ndlu're' mbi' taamas con' ndli mbi' loo mèn, yey. ");
INSERT INTO zamNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Por xtùuz co' mbli mèna cón che'n Jesús no cón che'n mèn guliz Jesús, ale tataa mod leque mèna mbli par ngo tac lezo' mèna con Jesús. No mden' mèna ngòc nguàal di's cón che'n Jesús. Sya, ndxab Jesús loo mèna: ―Huax mèn ndli ndyu' thìb mbi' co' nde'th di's co' ndxab Diox. No ndli mèn cas mbi'a. Per mèn co' nac mèn gulizpe' mbi'a no mèn co' nac mèn gulàazpe' mbi'a, ¡pà li mèna cas mbi'a! ");
INSERT INTO zamNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Con'a mbli ya ne'ntolode ngli Jesús huax yalguzye' tya tac mèna ne'ndalte ngala's cón che'n con' ndli Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Leque le'n huiza mbìn thìb mbi' co' ngro' lèe Herod, co' mnibe' loo mèn co' nac mèn gulàaz che'n mèn galile tiempa, cón che'n Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Sya, ndxab Herod loo mèn co' ngòc moz Herod co' ngo no Herod: ―Peser Juàn Bautist nac mbi'a. Thìb descuid pá ngro xban Juàn làth mèn nguth cona ndxàp mbi'a con' la's nii mbi' no la's ya' mbi' par ndli mbi' chol yalguzye'. ");
INSERT INTO zamNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tataa ndxab Herod loo mèn co' nqueltàa no Herod. Tac Herod neeque' le' Herod mnibe' loo solndad ya tedó' solndad nii Juàn Bautist con thìb caden le'n lezi'f ante por cón che'n thìb xa'got co' ngro' lèe Herodi co' ngòc sa'l Lip, hues Herod. ");
INSERT INTO zamNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tataa mnibe' Herod ngòc loo Juàn Bautist tac de yalquìite ndxab Juàn loo Herod indxàalte que no Herod xa'got Lip xal xa'gotpe' Herod. ");
INSERT INTO zamNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Leque hora ngulàa xyàn lezo' Herod. Mblya's Herod ngnibe' Herod loo solndad par ya yuth solndad Juàn. Per Herod mzyeb gunèe Herod mèn co' nziri' huiza. Tac ryete mèna mbli xtùuz cón che'n Juàn no mbez mèna loo xtàa mèn le' Juàn ante ndyoodi's cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Per huiz co'se' mbli Herod thìb lni co' ngòc huiz co' ngóol lèe Herod, sya, thìb mza' co' nac rsap Herodia, asembli mza'. Ngro' mza'. Mbil' nii mza' loo Herod no loo mèn co' nziri' no Herod, mèn co' mbli Herod convid. No anze'f thìb gust mda' lezo' Herod gunèe Herod mod co' mbil' nii mza'. ");
INSERT INTO zamNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ale mde'th Herod Diox loo mza' no loo rye mèn co' nziri' no Herod. Ndxab Herod loo mza' le' Herod li ryethe con' ndlya's mza' o ta' Herod ryethe con' ndlya's mza' par càa mza'. ");
INSERT INTO zamNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Le' xna' mza' na, ndoole' mquil' mza'. Ndxab xna' mza' loo mza': ―Guuz loo rey Herod ta' rey yéc Juàn Bautist càal loo thìb plat. Le' sya, co'se' mbere mza', ndye'th mza', ndxab mza' loo rey Herod: ―Rey, daa ndlyaz ta' U' yéc Juàn Bautist càan loo thìb plat nalle'. ");
INSERT INTO zamNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Co'se' mbìn Herod tataa ndxab mza' loo Herod, anze'f mxi lezo' Herod por con' li Herod. Per com le' Herod mde'th lèe Diox, ¿lé'?, no ngro'le' di's ro Herod loo ryete mèn co' nziri' con Herod, mèn co' mbli Herod convid, le' Herod li con' ndlya's mza', ¿lé'?, mnibe' Herod ya xi solndad yéc Juàn Bautist loo thìb plat par càa mza'. ");
INSERT INTO zamNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Sya, que nzo ne' ñee lezo' Herod, mtel' Herod solndad par ngua cho' solndad yéc Juàn le'n lezi'f. ");
INSERT INTO zamNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ngoloa, ndye'th no solndad yéc prob Juàn loo thìb plat. Mda' solndad yéc Juàn loo thìb plat mcàa mza'. Le' mza' na, xexte ngro'. Ngua ta' mza' plat con yéc Juàn loo xna' mza'. ");
INSERT INTO zamNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ngolo mbeth solndad Juàn, mzin myen' xin' mté'th thebol Juàn Bautist. Ngua lo' myen' thebol Juàn lezi'f. Ngua ca's myen' thebol Juàn. Ngoloa, ngua ta' myen' cuent loo Jesús cón ngòc loo Juàn Bautist. ");
INSERT INTO zamNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Co'se' mbìn Jesús con' ngòc loo Juàn, mbii Jesús tya. Ngòo thidte Jesús le'n thìb yòoyaa con myen' xin' mté'th Jesús par ya Jesús xà'le' tedib lugar. Per mèn co' ngure no Jesús tya mbìn le' Jesús ndale' loo nít loo lagun. Sya, ngro' tee rye mèn co' nzo ban par neda angnzo ro lagun. Nda nque mèna xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Texal ngro' Jesús le'n yòoyaa, ñèe Jesús nziri'le' huax mèn loo Jesús. Nalyat ngòc lezo' Jesús gunèe Jesús mèna. Mblyat lezo' Jesús gunèe Jesús mèna. Mteyac Jesús rye mèn yíiz co' nde no mèna loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Co'se' ñèe myen' xin' mté'th Jesús nde zèle' izlyo' huiza, ngua myen' loo Jesús. Ndxab myen' loo Jesús: ―Mzyèle' izlyo', Tad. Neeque' U' co'te' nziri' na' ndxè' nac thìb lugar nagán. No yende chó mèn nzo co' tho' co' hua mèn trè'. Más huen gunii U' Diox loo mèn ba' par bii mèn par ya cua'n mèn con' hua mèn le'n yèez ba' no le'n ranch co' nziri' le'n yii ba'. ");
INSERT INTO zamNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sya, mcàb Jesús loo myen'. Ndxab Jesús: ―Inquinte bii mèn, yey. ¿Máa yob yéc gu', na? Fta' gu' con' hua mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Myen' ndxab loo Jesús: ―Yende cón ngue no nu' arid trè', yey. Pente ngue no nu' ga'y pan no chop mbèel no maste. ");
INSERT INTO zamNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús ndxab loo myen': ―Que de no gu' con' ngue no gu'a trè'. Ñeene'. ");
INSERT INTO zamNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sya, gunii Jesús loo mèna. Ndxab Jesús: Nabe'ste gure tub gu' loo huan ba', ey. Ngoloa, mxen Jesús ga'y pana no chop mbèela. Mbui' Jesús loo bé'. Ndxab Jesús: Ay, Dio's. Diox quix U', Diox, por pan ndxè' no por mbèel ndxè'. Sya, mchì'x Jesús pana no mbèela. No mbli Jesús par mbyar' pana no mbèela. Mda' Jesús pana no mbèela loo myen' xin' mté'th Jesús. Le' myen' xin' mté'th Jesús na, mbli'tha loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ryete mèna nduhua rsè axta plóthe mblya's mèna. Ngolo nduhua rsè mèna, msè myen' xin' mté'th Jesús si' fchop cardor pan no mbèel co' mbyan' xo'f. ");
INSERT INTO zamNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mèn co' nduhua rsèa ngòc ga'y mil mèn, ante mènbi'. Xà'que' mèngot no xà'que' myen' bix. Indxòode cuent mèngot no myen' bix co' nduhua. ");
INSERT INTO zamNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ngoloa, mnibe' Jesús loo myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Gòo gu' le'n yòoyaa ba'. Ftlo gu', fteteegu' yòoyaa. Ya ner gu' par zin gu' tedib lad ro lagun. Yiloa, ndal que'en ba'. Láth nda myen'a, Jesús gunii Diox loo mènléy' co' nziri'a. ");
INSERT INTO zamNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ngolo gunii Jesús Diox loo mènléy'a, mxen Jesús ned. Nda Jesús loo thìb yii co' ndub gaxte tya par cuez thidte Jesús Diox. Co'se' ngulàa yál' izlyo' huiza, thidte Jesús mbyan' loo yiia. ");
INSERT INTO zamNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Le' myen' xin' mté'th Jesús na, láth co'se' nda tetee myen' yòoyaa grolthe loo lagun, ngro' thìb mbiidó' co' mtau' ned nda yòoyaa. Nde nxon', mxít too mbii nít. Ngo mbii nít le'n yòoyaa. No ngüin mbii nít cho yòoyaa. ");
INSERT INTO zamNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Xtil'a, cuar ngro' too gax Jesús loo myen'. Nde tee nii Jesús loo nít loo lagun loo myen'. ");
INSERT INTO zamNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Co'se' ñèe myen' xin' mté'th Jesús nde tee Jesús loo nít loo myen', anze'f mzyeb myen' no ngo no lezo' myen'. Ngrozèe zeb myen'. Ndxab myen': ―¡Ay, con' mal nde go', cara! ¡Con' mal nde go', cara! ");
INSERT INTO zamNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Per Jesús gunii loo myen'. Ndxab Jesús loo myen': ―Ne'zyebte gu', ey. Blo gu' valor loo gu'. Daa na. ");
INSERT INTO zamNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Sya, ndxab Pedr loo Jesús: ―Tad, chele'i U', bli U' par teniin loo nít par galen loo U' axta co'te' ndoo U' ba'. ");
INSERT INTO zamNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Sya, ndxab Jesús loo Pedr: ―Neeca. Que de, tá. Sya, ngulàa Pedr loo yòoyaa. Mtlo Pedr, mdee nii Pedr loo nít par ya Pedr co'te' ndoo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Per co'se' mda' Pedr cuent anze'f thìb mbii nzo'f loo lagun, mzyeb Pedr. No co'se' mden' Pedr mtlole' ngue dep Pedr le'n nít, mtlo Pedr, ngrozèe Pedr. Mbez Pedr: ―Tad, Tad, jer que de. Guree U' daa par lyá' daa trè'. ");
INSERT INTO zamNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Texal mzin Jesús loo Pedr, chàa, nguree Jesús ya' Pedr. No ndxab Jesús loo Pedr: ―¡Jaa, Pedr! Pente ndxela'sl, ¿lé'? ¿Chonon ne'ngàptel yalxla's loon par ne'dyeptel le'n nít, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Co'se' mquée Jesús loo yòoyaa con Pedr, xèegà nguled mxyo'f mbii loo nít loo lagun. ");
INSERT INTO zamNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Le' sya, co'se' gunèe ryete myen' co' nzo le'n yòoyaa con' co' ngòca, mdub xib myen' loo Jesús. Mcòo' myen' yéc myen' loo Jesús. No ndxab myen' loo Jesús: ―Lìcpe' ba'i, Tad, U' nac xgan'pe' Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ngoloa, tolo mtetee myen' yòoyaa loo nít loo lagun axta mzin myen' tedib lad ro lagun con Jesús co'te' nac loo xyòn mèn che'n làaz mèn genesaret. ");
INSERT INTO zamNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Co'se' mblibe' mèn yèezya' che'n làaz mèn genesareta Jesús na, mde'th mèna di's loo rye mèn yèez gaxa. Co'se' mbìn mèna le' Jesús nzo tya, mbi'th no mèna huax mèn yíiz loo Jesús co'te' ngo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nalyat mna'b mèna di's loo Jesús par ta' Jesús lugar ante gàal mèna ro xab Jesús yac mèna loo yíiz co' ndyac mèna. Tataa mod ryete mèn co' ante mbuàal ro xab Jesús mbyacque'. ");
INSERT INTO zamNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sya, mbii gax plá mèn xley' farise no plá mèn co' ngòc maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn loo Jesús. Mèna nde par ned ciuda Jerusalén par asembli mèna mnibdi's mèna di's loo Jesús. Ndxab mèna loo Jesús: ");
INSERT INTO zamNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Chonon indubdi'ste myen' xin' mté'th lùu ba' cón che'n costumbr che'n xudgool na', à'? Ale ndxe'leque', intechte myen' ya' myen' ndoore' tyub myen' par hua myen' xalque' nac costumbr co' ngue no na' no co' mbed no na'. ");
INSERT INTO zamNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús mnibdi's loo mèna. Ndxab Jesús: ―Nde niin thìb con' loo gu', ne, por cón che'n con' co' mnibdi's gu' loon: ¿Chonon indyubdi'ste gu' loo Diox par li gu' xal nac co' ñibe' Diox loo gu' li gu', à'? Ale más ndli gu' xal nac costumbr co' ngue no gu' no co' mbed no gu' leque li gu' xal ñibe' Diox loo gu' par li gu', ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","¿Ché' inda'de gu' cuent le' Diox ndxab loo di's co' mnibe' Diox co'se' ndxab Diox: Gòp gu' mod gunèe gu' xud gu' no gòp gu' mod gunèe gu' xna' gu'. Per ndxe'leque', mèn co' ñii yèe ñii tìi cón che'n xud mèn no cón che'n xna' mèn, mèn li mandad guth mèn mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Per ndxe'leque', gu' mbez nzoque' mod gab thìb mbi' loo xud mbi' no loo xna' mbi': Yende mod lyath non gu', Pay, May, con con' ndxàpen tac ryete con' co' ndxàpen, na mdeth lèe Diox le' con' co' ndxàpen nac che'npe' Diox. Tataa mbez gu' mastale' inda'de gu' con'a càa Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","No tolo mbez gu': Le' chol mèn co' mbez tataa loo xud mèn no loo xna' mèn, ya inquinte tolo lyath no mèna xud mèna no xna' mèna. Tataa mod ndlá' gu' co' mnibe' Diox loo gu' li gu' par más li gu' con' co' nac costumbr co' mbed no gu' no mod co' ndxàp gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Aa, mèn xley' farise. Aa, mèn co' nac maistr che'n ley co' mxo'f Moisés loo mèn. Aa, que ndxác gu' ntembìi gu' ro gu' no ntembìi gu' xti's gu' loon, ¿lé'? Bien lal ro Sayi co' mde'th di's co' ndxab Diox co'se' mque' Sayi ye's cón che'n gu'. Sayi ndxab: ");
INSERT INTO zamNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Mèn nación Israel ndxè' alithe ndyoodi's di's par li mèn con' guryath loon no par li mèn con' guryèn loon. Per mod co' ndxàp mèn nación Israel co' ndlu' mèn nación Israel cón chenen, ingue lu'de mèna loon dib nzo yéc mèn no dib nzo lezo' mèn le' mèna ndubdi's ndac loon. ");
INSERT INTO zamNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Anxle' ncòo' mèn nación Israel yéc mèn nación Israel loon, ne. No anxle' mbez mèna lèen co'se' ndlu' mèna cón che'n xley' leque mèna loo xtàa mèn. Per ndxe'leque', xley' co' ndlu' mèna nac leque xley' che'n mèn izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sya, ngurez Jesús rye mèn co' mqueltàa loo Jesús, co' nziri' loo Jesús. Ndxab Jesús loo mèna: ―Ndlyazen gòn gu' di's ndxè'. No ndlyazen ta' gu' cuent cón che'n di's ndxè'. No ndlyazen ta' gu' lugar yaa'd di's ndxè' le'n xtùuz gu' no le'n lezo' gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Inacte por intechte mèn ya' mèn no inacte por con' co' ndxuhua mèn ndxàc con' ye'rsin' loo mèn no ndli mèn con' ye'rsin'. Ndxe'leque', di's co' ndyoodi's mèn co' ndryo' ndlyen' le'n xtùuz mèn no le'n lezo' mèn, con'a nac co' ndli par ndxàc mèn mèn zab no mèn ye'rsin' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sya, mbii gax myen' xin' mté'th Jesús loo Jesús. Ndxab myen' loo Jesús: ―Tad, ¿ché' ne'nda'de U' cuent le' mèn xley' farise no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, nazab nden' mèna di's co'se' mbìn mèna di's co' ndxab U'? Mbli mèna cuent le' di'sa ngòc di's co' guñii yèe U' no co' guñii tìi U' cón che'n mèna. No mbli mèna cuent le' di'sa ngòc ngòc nguàal di's co' gunii U' cón che'n mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Per Jesús ndxab loo myen' xin' mté'th Jesús: ―Nde niin thìb con' loo gu': Mèna nac xal thìb xan' yaa co' mxenle' lox. Per chol xan' yaa co' tarte too xuden Diox co' nzo loo bé', mèn quib alox xan' yaaa, co' nee di's, nac mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bla' gu' tee nziri' mèna, ey. Mèna nac xal mèn sieu co' ndyen ya' tedib mèn sieu par tetee mèn sieu xtàa mèn sieu. No chele' thìb mèn sieu ndyen ya' tedib mèn sieu, co' nee di's, par tetee sieu xtàa sieu, ¿ché' ngue li gu' xtùuz ne'yizi'fte ryop mèn sieua le'n thìb ye'r, cà? Tazi'f ryop mèn sieu le'n thìb ye'r, ¿lé'? Tataa nac mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Sya, mcàb Pedr. Ndxab Pedr loo Jesús: ―Tad, fta' U' cuent loo nu' cón che'n di's co' mtetac U' loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús ndxab loo myen' xin' mté'th Jesús: ―¿Ché' no gu' inda'de cuent cón che'n di's co' mtetaquen loo mèna, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ché' inonte gu' no ché' inda'de gu' cuent le' ryete con' ndxuhua mèn thìb lì ndxòoi le'n xti' mèn no ndxeloa ndri'tha loo mèna co'se' nda mèn mandad mèn, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Per di's co' ñii mèn no co' ndyoodi's mèn na, di'sa nac co' más nabe's ndryo' ro mèn no lezo' mèn tac di'sa más ndryo' ndlyen' le'n lezo' mèn par ndyoodi's mèn. No leque di'sa ndli ntezab mèn no ndlu' mod co' nac mèn par ndxàc mèn mèn ye'rsin' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tac leque le'n quèe yéc mèn no le'n lezo' mèn ndryo' xtùuz ye'rsin' co' ndli mèn xtùuz. Angab na'i, xal xtùuz co' ndli mèn co' ndli chol xtùuz ye'rsin' par guth mèn xtaa mèn; xal xtùuz co' ndli mèn co' ndli xtùuz par cua'n mèna xin' huan mèna, no li mèna yalburrid; xal xtùuz co' ndli mèn co' ndli xtùuz par li huan' mèn; xal xtùuz co' ndli mèn co' ndli xtùuz par toxcua' mèn yalgutyè'; no xal xtùuz co' ndli mèn par ndxòo lezo' mèn cón che'n cuent yix. ");
INSERT INTO zamNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ryete con' co' ndli mèn xtùuza, ntezab xtùuz mèn no lezo' mèn par ndxàc mèn mèn ye'rsin' loo Diox. Per mèn co' tyub par hua mèn lua' mèn no xít mèn, co'se' intechte mèn ya' mèn, xal nac costumbr co' ndxàp mèn co' mbed no mèn, intezabte con'a xtùuz mèn no lezo' mèn par gàc mèna mèn ye'rsin' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ngoloa, ngro' Jesús tya. Mxen Jesús ned. Nda Jesús par ned le'n rye yèezya' che'n làaz mèn ciuda Tir no le'n rye yèezya' che'n làaz mèn ciuda Sidón. ");
INSERT INTO zamNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Láth nda zin Jesús ned nda Jesús par neda, mbi'th thìb xa'got co' ngòc mèntèe che'n thìb di'stèe co' lèe canane, co' naban par neda, loo Jesús. Cabii mbez xa'gota loo Jesús: ―Tad, naneequen le' U' nac bin David co' ngòc rey póla. Por cona, gulat lezo' U' gunèe U' daa. ¿Xá nee U'? Mza' co' nac rsapen ndxè' nquée mbii che'n xpii ye'rsin' no anze'f nè nquée mbii rsap daa, Tad. ");
INSERT INTO zamNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Per Jesús yende chó di's mcàb loo xa'gota. Sya, mbi'th myen' xin' mté'th Jesús loo Jesús. Mna'b myen' di's loo Jesús. Ndxab myen' loo Jesús: ―Tad, guuz U' loo xa'got ba' bii xa' tac anze'f nazab mbez yèe xa' ned xís na'. ");
INSERT INTO zamNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús ndxab loo myen' xin' mté'th Jesús: ―Aa'a. Yende cón gaben loo xa'got ba'. Diox mtel' daa par mbalen ante loo mèn nación Israel, mèn co' nac xal mbacxil' co' nzi tee huan. ");
INSERT INTO zamNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Látha, negadi's mbii gax xa'gota loo Jesús. No mdub xib xa'gota loo Jesús. Ndxab xa'gota loo Jesús: ―Tad, bli U' favor blo' U' xpii ye'rsin' loo rsap daa. ");
INSERT INTO zamNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Per Jesús asembli par mtetac Jesús thìb di's loo xa'gota. Ndxab Jesús loo xa'gota: ―Ihuente nac co' li mèn chele' mèn teche pan loo xin' mèn no ta' mèn pana par hua mbac, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Chàa, mcàb xa'gota loo Jesús. Ndxab xa'gota: ―Aa, Tad. Lìcque' nac co' ngolo gunee U' loon ba'. Yende cón niin loo U'. Per hui' U' nexa. Mbac nthopque' pan byòo bix co' ndxàb ro mes co'se' ndxuhua mèn par hua mbac. ");
INSERT INTO zamNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sya, ndxab Jesús loo xa'gota: ―Ngot, nase ngolo guneen, lìcque', ndxela'sque'l loo cón chenen, ndee. Liquen con' ndlya'sl, ndee, ey. Texal ngolo ndxab Jesús di'sa loo xa'gota, leque hora mbyac rsap xa'gota. No mbiiche mbii co' mzib yéc rsap xa'gota. No mdyub xnìi yéc rsap xa'gota no mdyub xnìi lezo' rsap xa'gota loo mbii co' mquée yéc rsap xa'gota. ");
INSERT INTO zamNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Mbii Jesús tya. Mdee nii Jesús dib vuelt ro lagun co' ne' lèe lagun che'n làaz mèn galile axta mzin Jesús tedib lad ro laguna. Ngoloa, mquée Jesús loo thìb yii par tyub Jesús tya. ");
INSERT INTO zamNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Látha, mzin huax mèn loo Jesús co'te' ndub Jesús. Nde no mèna mèn coj, mèn sieu, mèn mud, mèn co' yende nii, no mèn co' yende ya', no taamas mèn nayíiz co' ndyac chol yíiz par teyac Jesús rye mèna. Mteyacque' Jesús rye mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Co'se' ngolo gunèe rye mèn co' ngureri'a ngòc con'a, ante mbui' mèna no ante gunaa mèna co'se' gunèe mèna le' mèn co' ngòc muda ndyoodi's; co'se' gunèe mèna le' mèn co' yende nii no mèn co' yende sa ya' mdyoxcua', ngòc mèna xal mèn huen; co'se' gunèe mèna le' mèn renc mdee; no co'se' gunèe mèna le' mèn sieu ngüi'. Mèna mtlo ngurez Diox, Diox co' nac Dioxpe' mèn nación Israel. Mbez mèn di's roo no di's xèn no di's natú' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sya, ngurez Jesús myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Anze'f ndlyat' lezon ñèen prob mèn ba'. Tac ndxàcle' son huiz nzo mèn ba' trè' con daa. No yende cón nde no mèn par hua mèn. Indlyasten tel'en mèn par bii mèn liz mèn no làaz mèn tac daa nanee le' mèn ba' nzi lan'. No nzo ryes guu's mèn no lyàa fuerz mèn ned bii mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Per myen' xin' mté'th Jesús ndxab loo Jesús: ―Tad, ¿xá mod li na' par que no na' con' hua ryethe mèn ba'? Tac U' nanee le' co'te' nzo na' ndxè' nac lugar nagán. No yende chó mèn nzo co' naban par nedrè' par tho' mèn co' hua rye mèn ba'. ");
INSERT INTO zamNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sya, mnibdi's Jesús loo myen': ―¿Plá pan ngue no gu', à'? Myen' mcàb. Ndxab myen': ―Pente ngue no nu' gaz pan no ndxepte mbèel bix no maste. ");
INSERT INTO zamNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sya, ndxab Jesús loo mèna nabe'ste tyub mèna loo yòo co'te' nziri'te mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sya, mxen Jesús gaz pana no ndxep mbèel bixa. Ndxab Jesús loo Diox: Ay, Dio's, Diox quix U', Diox, por pan ndxè' no por mbèel ndxè'. Ngoloa, mchì'x Jesús pana no mbèela par mbyar' pana no mbèela. Ngoloa, mda' Jesús pana no mbèela loo myen' xin' mté'th Jesús. Le' myen' na, mbli'th pan no mbèel loo rye mèn co' nziri'a. ");
INSERT INTO zamNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ryete mèna nduhuaque' axta plóthe mblya's mèna. Ngolo nduhua mèna, mthop myen' rye le' pan no mbèel co' mbyan' xo'fa. Msè myen' gaz cardor pan no mbèel co' mbyan' xo'f co' nduhua rye mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mèn co' nduhua axta plóthea, mèna ngòc thap mil mèn co' ngòc ante mènbi'. Xà' mèngot. No xà' myen' bix. Indxòode cuent mengot no indxòode cuent myen' bix co' nduhua axta plóthe. ");
INSERT INTO zamNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ngolo nduhua mèna, gunii Jesús Diox loo mèna. Ngòo Jesús le'n thìb yòoyaa co' ndub ro laguna con myen' xin' mté'th Jesús. Nguri'th Jesús par ned co'te' nzi thìb yèez co' lèe Magdala. ");
INSERT INTO zamNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Láth nda riid Jesús par neda, ngua sál' ndxep mèn co' ngòc mèn xley' farise no mèn co' ngòc mèn xley' saduce Jesús par mcua'n mèna mod ñeene' ché' tli mèna gan gàal di's mèna Jesús par yigaa Jesús loo mèna. Ndxab mèna loo Jesús: ―Tad, ¿xá neel? Nu' ndlya's lil thìb yalguzye'pe' loo nu' par hui' nu' chó yalguzye' lil co' yú' xal thìb señ loo bé' loo nu'. ");
INSERT INTO zamNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Per Jesús mcàb. Ndxab Jesús loo mèna: ―Nde niin thìb con' loo gu' co' ta' cuent xá nac gu'. Co'se' mzyèle' izlyo', xèe ngüi' gu' loo bé'. No co'se' ñèe gu' nquée xcuau nane loo bé', mbez gu' loo xtàa gu': Nde zin'le' tiemp lyàa yì', cara. ");
INSERT INTO zamNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Le' co'se' ñèe gu' blé' blé' nac xcuau co' nquée loo bé' ndxáal xtil' na, mbez gu' loo xtàa gu': Nalle' huin xòo o lyàa yùu quèe. ¡Aa, mèn xley' farise no mèn xley' saduce! Susque' ndxác gu' ntembìi gu' ro gu' no ntembìi gu' xti's gu' loon. Ale ngo' gu' cuent cón che'n señ co' ndxú' loo bé'. Per ingo'de gu' cuent no ne' ne' indli gu' cuent cón che'n señ co' ntlole' ndxàc tiemp ndxè' co' lu' le' Diox mtel' daa par ndxàpen con' roo con' xèn la's niin no la's yan. ");
INSERT INTO zamNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tolo ndxab Jesús loo mèna: ―¿Gu' co' nac mèn ye'rsin', gu' ñibe' loon par lin thìb yalguzye' co' ndlya's gu' hui' gu', cà'? Yende xàa. Ya yende chó más yalguzye' lin loo gu' par hui' gu'. Ndxe'leque', con' ndxè' no maste niin loo gu': Con' co' ngòc loo Jonás póla nac co' ta' cuent loo gu' cón che'n con' co' gàc loon yiloa. Ngolo mdoodi's Jesús di'sa, taate mbyan' mèna tya. Ne'ncàbte mèna loo Jesús. Le' Jesús na, mxen ned. Ndyàa Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Co'se' mzin Jesús con myen' xin' mté'th Jesús tedib lad ro lagun tedib vez, ne'nte'de lezo' myen' xin' mté'th Jesús ndi' myen' pan par nque no myen' pan. ");
INSERT INTO zamNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sya, ndxab Jesús loo myen' xin' mté'th Jesús: ―Chó Diox chó nee gu' no anderhuen gu'. Leque gu' fquenap gu' loo cón che'n dii levadur co' nac cón che'n xley' mèn farise no co' nac cón che'n xley' mèn saduce. ");
INSERT INTO zamNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Per myen' xin' mté'th Jesús, mtlo myen', ndxab myen' loo xtàa myen': ―Tatua' gunee Tad loo na', cara, tac ne'nte'de lezo' na' ndi' na' pan par que no na' pan. ");
INSERT INTO zamNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús mden' lezo' no mda' Jesús cuent con' co' mbli myen' xtùuz. Ndxab Jesús loo myen': ―¿Chonon mbez gu' loo xtàa gu': Tatua' mbez Tad loo na' tac ingue node na' pan? Susque' pente ndxàp gu' yalxla's loon, yey. ");
INSERT INTO zamNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ché' tarte ta' gu' cuent co' huenleque' no ché' ne'tyede lezo' gu' cón che'n con' mblin con gaz pan co' mblin mandad co' mbli'th gu' loo ga'y mil mèn, cà'? ¿Plá cardor pan co' mchìxena mbyan' xo'f co' mthop gu', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ché' ne'tyede lezo' gu' co' mblin con gaz pan co' mblin mandad mbli'th gu' loo thap mil mèn, ne? No ¿plá cardor pan co' mbyan' xo'f mthop gu'a, à'? ¿Ché', ndyac gu', ne'gácte daa toxcuan sa pan hua na', cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Chonon ne'nda'de gu' cuent no ne'nglide gu' xtùuz le' daa ne'ndoodi'ste cón che'n panpe' loo gu' co'se' guniin loo gu' anderhuen gu' no chó Diox chó nee gu', fquenap gu' gu' loo dii levadur co' nac còn che'n xley' mèn farise no loo dii levadur co' nac còn che'n xley' mèn saduce, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ale axta syare' mda' myen' cuent le' Jesús ingue bezte loo myen' le' myen' quenap myen' loo cón che'n dii levadur co' ndli ndyoo bes pan. Ndxe'leque', myen' mden' no mda' myen' cuent le' Jesús ngue lu' loo myen' leque myen' quenap myen' loo cón che'n xley' che'n mèn xley' farise no loo cón che'n xley' che'n mèn xley' saduce. ");
INSERT INTO zamNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Co'se' mzin Jesús le'n yèezya' che'n làaz mèn ciuda Cesar co' mblec thìb mbi' co' lèe Lip Tetrarc, Jesús mnibdi's loo myen' xin' mté'th Jesús. Ndxab Jesús: ―¿Chó mèn mbez mèn nac daa, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo' ndxè', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Myen' xin' mté'th Jesús mcàb. Ndxab myen' loo Jesús: ―Ndxep mèn mbez le' U' nac Juàn Bautist. Taandxep mèn mbez le' U' nac Lii. No nzore' mèn co' mbez le' U' nac Jeremi. Mbez mèna, ne, nzo chó mèn co' nde'th di's co' ndxab Diox nac U'. ");
INSERT INTO zamNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sya, ndxab Jesús loo myen' xin' mté'th Jesús: ―¿Gu', à'? ¿Chó mèn mbez gu' nac daa? ");
INSERT INTO zamNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sya, ngro' nxon' Mon Pedr. Ndxab Mon Pedr loo Jesús: ―U' nac yubpe' Crist. Nac U' xgan'pe' Diox co' nabanpe'. ");
INSERT INTO zamNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús mcàb loo Pedr. Ndxab Jesús: ―Anze'f huen ndal, Mon, xgan' Jonás. Tac nec thìb mèn che'n izlyo' ndxè' tarte lu' cón che'n con' co' ngolo guneel loon ba' lool. Ndxe'leque', yub xuden Diox mbli par non lùui par guneela loon. ");
INSERT INTO zamNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","No nalle' daa nii lool: Lùu hue' tedib lèe co' nac Pedr, co' nee di's, nac quèe. No loo di's co' ngolo guneel loon ba' co' nac xal thìb quèe roo xal thìb quèe rhue' no xal thìb quèe co' ngóol loo izlyo', loo cón che'n di'sa daa li par dyop mèn no queltàa mèn loo cón chenen par gàc mèna che'npe' daa. No ne' ne' gác Mebizya li Mebizya gan co' xà' Mebizya mèna loon no loo cón chenen co'se' gath mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pedr, daa ñibe' lool le' lùu ñibe' loo mèn co' Diox ñibe' loo. Gàcl xal mèn co' altant ndyoo ner no ndyoo naa loo mèna. Con' co' ñibe'l loo mèn yende mod li mèn, con'a gàc con' co' mnibe' lezon loo bé' gàc con' co' yende mod li mèn, mèn co' nzo loo cón chenen. No con' co' ñibe'l loo mèn par li mèn, con'a gàc con' co' mnibe' lezon loo bé' gàc loo mèn no con' co li mèn, mèn co' nqueltàa loo cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ngoloa, sya, mnibe' Jesús loo myen' xin' mté'th Jesús. Ndxab Jesús loo myen' yende chó loo gabte myen' le' Jesús nac Crist. ");
INSERT INTO zamNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Desde huiza par delant Jesús mtlo mda' cuent loo myen' xin' mté'th Jesús le' Jesús naquinque' ya ciuda Jerusalén. Ndxab Jesús loo myen', ne, le' mèngool, no mèn co' nac jef co' más ñibe' loo rye nguley', no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn nación Israel, ryete mèna yátbèe par tetìi mèna Jesús axta plóthe lya's mèna. Ndxab Jesús loo myen', ne, le' mèna li par guthxù' mèn Jesús. Per co'se' yilo son huiz nguth Jesús, Jesús ryo xban làth mèn nguth. ");
INSERT INTO zamNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sya, xexte mblo' Pedr Jesús. Mbe' Pedr Jesús thìb lad loo myen' co' ndxàc xtàa Pedr. Ale mtlo Pedr, mco'x Pedr Jesús. Ndxab Pedr loo Jesús: ―Ne'ñeede Diox conax, Tad, par ale tataa gàca loo U'. Thidtene ne'ta'de U' lugar li mèn con'a loo U'. ");
INSERT INTO zamNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Per Jesús mbere loo loo Pedr. Ndxab Jesús loo Pedr: ―Biiche loon, Pedr. Te' nac Mebizya nacl loon. Susque' nda'l xyàn lezon. Lùu indye'thte xtùuz yéc xal ndli Diox xtùuz cón chenen. Lùu, ndxe'leque', ndli xtùuz cón chenen xalque' ndli mèn izlyo' xtùuz cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sya, ndxab Jesús loo myen' xin' mté'th Jesús: ―Chele' chol gu' ndlya's tyoo nque xísen ned ndan, leque gu' bli par ne'lide gu' co' ndyub yo'f lezo' gu' par li gu'i. Ndxe'leque', gàp gu' lezo' gu' no ñibe' gu' loo lezo' gu' par ne'lide gu' con' co' ndyub yo'f lezo' gu' li gu'. Blec lezo' gu' par xec gu' tyactìi gu' co'se' tyub ngu's mèn gu' no li mèn preb tethon mèn gu' por cón chenen ned nda na'. Le' sya, ya' gu' too nque gu' xísen. Nda na'. ");
INSERT INTO zamNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tac mèn co' ante ndoo lezo' ndxath ndxey' no ndxath ndlyux mèn par que no mèn che'npe' mèn, mèna ante ndoo lezo' que no mèn cón che'npe' izlyo' ndxè'. Loo mèna ne'ta'de Diox lugar ne' ne' tyal Diox yòo ban no mèn Diox thidtene yiloa. Per mèn co' lá' ryethe con' co' nac yalndac che'npe' mèn co' gác li mèn gan loo izlyo' ndxè' por cón chenen, loo mèna ta' Diox lugar no tyal Diox par yòo ban no mèna Diox thidtene yiloa. ");
INSERT INTO zamNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Lomisque' ne, ¿cón co' thìb mbi' no chó yalndac gác li mbi' gan co'se' gàc che'npe' mbi' dib athu loo izlyo' tac chele' mbi' tataa mod li, gab Diox loo mbi' yende mod yòo ban no mbi' Diox thidtene yiloa? Yende cón li mbi' gan chele' mbi' li tataa, ¿lé'? ¿Xá nee gu', ne? ¿Plál quix thìb mbi' loo Diox par yòo ban no mbi' Diox co'se' ngolo gunii Diox loo mbi' ne'tyalte Diox yòo ban no mbi' Diox, à'? Yende mod li thìb mbi' gan li mbi' tataa, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tac co'se' gàc huiz galen loo izlyo' ndxè' tedib vez, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo', daa gal xalque' nac ryethe con' roo con' xèn co' nac xuden Diox. No galen con angl co' nzo loo xuden Diox. Axta syare' quix thìb thìb mèn cón che'n mèn loo Diox xalque' ngòc mod co' ngòp mèn láth nziri' mèn loo izlyo' ndxè', que naca mbli mèn con' huen, que naca mbli mèn con' ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Lìcpe' ba'i, na ngue nii loo gu': Nzo ndxep mèn co' nziri' loon trè' co' ne'gathte axta co'se' gàc huiz hui' mèna loon, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn, co'se' gàc tiemp co' gal ñibe'pe'en loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ngolo xop huiz ngòc con'a, mbe' Jesús Pedr no mbe' Jesús Cob no mbe' Jesús Juàn, hues Cob. Mbe' Jesús yon myen'a loo thìb yii roo. ");
INSERT INTO zamNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Láth ngo no Jesús myen' loo yiia, chàa, mzye' loo loo Jesús loo myen'. Gunaa loo Jesús xal loo huiz co'se' nguin bée rol huiz. Nde nxon', xab Jesús co' noc Jesús ante nagus bèelleque' gunaa xalque' thìb con' co' nquée xnìi. ");
INSERT INTO zamNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Láth nzi li myen' xin' mté'th Jesús xtùuz cón ndxàc loo Jesús, chàa, ngro' too Moisés no Lii co' mde'th di's co' ndxab Diox póla. Ngure toodi's no Moisés no Lii Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Sya, ndxab Pedr loo Jesús: ―Tad, susque' huen naca nzo na' trè', cara. ¿Ché' ndlya's U' toxcua' nu' son ramad par yòo gu'? Thìba par yòo U'. Tediba par yòo Moisés. Le' tediba na, par yòo Lii. ");
INSERT INTO zamNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tatabe' ndoo toodi's Pedr con Jesús, chàa, ngulàa beu. Mtau' beu loo ryete xa'. Látha, chàa, mbyèn thìb di's le'n beu co' ndxab: ―Mbi' ndxè' nac xgan'en. Anze'f ngudloon no lezon mbi' ndxè'. Bìn gu' di's co' ndyoodi's mbi' loo gu', ndee gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Texal mbìn myen' xin' mté'th Jesús di's co' mbyèna, ale mcuau myen'. Ale, ngulàa cotloo myen' loo yòo, tant mzyeb myen'. ");
INSERT INTO zamNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sya, mbii gax Jesús co'te' nzi myen', co'te' ngulàa cotloo myen'. Mxo'f Jesús ya' Jesús lad myen'. Ndxab Jesús loo myen': ―Goo che gu', ey. Ne'zyebte gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Co'se' ngo che myen', ngüi' ndxè' myen'. Ngüi' ba' myen'. ¿Máa Moisés ryop Lii? Per ñèe myen' yende Moisés. No yende Lii. Ante Jesús no maste ñèe myen' ndoo. ");
INSERT INTO zamNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sya, mbii Jesús con myen' loo yiia. Láth nde làa tùub Jesús con myen' le'n yiia, Jesús mnibe' loo myen'. Ndxab Jesús loo myen': ―Yende chó loo gabte gu' le' gu' gunèe con' co' mxyo'f loo loo gu', ndee. Ne'ta'de gu' cuent cón che'n co' gunèe gu'a loo mèn axta co'se' gàc huiz ryo xban daa làth mèn nguth, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo'. Axta syare', ta' gu' cuent loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Sya, mnibdi's myen' xin' mté'th Jesús loo Jesús cón che'n co' mbez maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn le' Lii yi'th. Ndxab myen' loo Jesús: ―Tad, fta' U' cuent loo nu' ¿xá mod chonon mbez maistra loo mèn le' ner Lii yi'th, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús mcàb loo myen'. Ndxab Jesús loo myen': ―Lìcque' nac xal mbez mèn le' Lii yi'th. Lìca, ngole' Lii làth mèn le'n tiemp ndxè'. Lii mbli par lyàa yéc mèn no lyàa lezo' mèn no zye' mod co' ndxàp mèn par thìb lìte yòo mèn loo cón che'n Diox tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Per daa ngue nii loo gu' tedib vez: Lii mbi'thle'. No ne'nda'de mèn cuent le' Lii nac mbi' co' mbi'thle'. Ndxe'leque', mbli mèn ngòc nguàal con' xal mblya's mèn con mbi' co' ngòc Lii. Lomisque' mod ne, tataa tetìi mèn daa xal lya's mèn, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Axta syare', mda' myen' xin' mté'th Jesús cuent le' Jesús ngue ta' cuent loo myen' cón che'n Juàn Bautist. ");
INSERT INTO zamNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Texal mzin Jesús con myen' xin' mté'th Jesús loo mèn co' mqueltàale' co' nzi bed, ngro' thìb mbi' xi'th mèna. Mbii gax mbi'a loo Jesús. Mdub xib mbi' loo Jesús. Ndxab mbi' loo Jesús: ");
INSERT INTO zamNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Tad, gulat lezo' U' gunèe U' mbyòo daa ndxè'. Nde teele' ndyac mbyòo daa ndxè' yíiz mbii. Cadque' co'se' nquée mbii che'n yíiz ndxè' loo mbyòo, anze'f nè nquée mbii mbyòo. No nde teele' ngobii mbii mbyòo loo quìi. No ngobii mbii mbyòo le'n nít. ");
INSERT INTO zamNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","No nalle' ndal non mbyòo loo myen' xin' mté'th U' trè' par bel'que' li myen' gan teyac myen' mbyòo. Per axta nalle' tarte li myen' gan teyac myen' mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sya, cabii ndxab Jesús loo mbii. Ndxab Jesús: ―¡Aa, mèn co' nziri' loo izlyo' tiemp ndxè'! ¡Susque' thidtene indxela'ste gu' loon no indxela'ste gu' con' mbezen loo gu'! ¡Susque' nala's gu' no naad gu' no nguud gu'! ¡Axta pól tolo go non gu' par lin gan gàc nado' gu' loon! No ¡axta pól tolo nquin xequen con gu' tua'the nala's gu' no tua'the naad gu' no nguud gu'! Huàa xi mbyòo. Yi'th mbyòo ndxè'. Ñeene'. ");
INSERT INTO zamNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sya, mbyoo Jesús xpii ye'rsin'a. Ante gunii Jesús loo xpii ye'rsin'a, ngro xpii ye'rsin'a loo mbyòo. Ale leque hora mbyac mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ngolo mbli Jesús ngòc con'a loo mbyòo, sya, xexte mdoodi's myen' xin' mté'th Jesús thìb lad con Jesús. Mnibdi's myen' loo Jesús. Ndxab myen': ―Tad, ¿chonon ne'ngácte nu' ngo' nu' xpii ye'rsin'a loo mbyòo, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús ndxab loo myen': ―Ne'ngácte gu' ngo' gu' xpiia loo mbyòoa tac gu' pente ndxela's loon. Lìcpe' ba'i, na nii loo gu': Chele' gu' ndxela's ndxepte loon xalte nac thìb biz mostaz, gu' gác gab gu' loo yii co' ndub go': Biiche trè', yii. Huàa tub tedib lugar ba'. Yiia biiche. Yende chó con' ne'gácte gu' li gu' co' gàc cón chenen chele' gu', lìcque', yila'spe' loon no yila'spe' gu' loo con' lin. ");
INSERT INTO zamNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Per thìb loo xpii ye'rsin' xal xpii ye'rsin' co' ngòo loo mbyòoa, ne'ryo'de tua'te. Ndxe'leque', xpii ye'rsin'a ryo' ante co'se' cuez mèn Diox co'se' cue xlat mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Láth thidte mque tee no Jesús myen' xin' mté'th Jesús par ned le'n yèezya' che'n làaz mèn galile, Jesús ndxab loo myen' xin' mté'th Jesús: ―Daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo', thìb ned mèn tyenxù' daa par ta' mèna daa loo tedib ned mèn co' tetìi daa. ");
INSERT INTO zamNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","No guth mèna daa. Per co'se' yilo son huiz nguth daa, daa ryo xbanque'. Co'se' mbìn myen' xin' mté'th Jesús tataa mde'th Jesús di's loo myen', anze'f mxi lezo' myen'. ");
INSERT INTO zamNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Co'se' mzin Jesús con myen' xin' mté'th Jesús le'n yèez Capernaum, le'pe' nzi tee mèn co' nthop tmi co' nquin mèn par tyoxcua' templ. Ngua mèna loo Pedr. Mnibdi's mèna loo Pedr: ―Pedr, ¿ché' ne'ta'de maistr gu' plá pes par ayud che'n templ, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedr mcàb loo mèna. Ndxab Pedr loo mèna: ―Peser ta' maistra. Le' sya, texal ngòo Pedr le'n nyòo co'te' nzo Jesús, ale ner Jesús gunii loo Pedr. Ndxab Jesús loo Pedr: ―¿Xá neel, Mon? ¿Chó loo mèn ndli mèn co' ñibe' loo izlyo' ndxè' cuent ña'b mèna tmi par ta' mèn ayud che'n contribución, à'? ¿Ché' ndli mèna cuent ngue na'b mèna ayuda loo mèn gulàazpe' mèn o ché' ndli mèna cuent ña'b mèn ayud loo mèn tith co' nde làazpe' mèn co' nac trè', cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedr mcàb loo Jesús. Ndxab Pedr: ―Mèna ña'b ayud loo mèn tith. Sya, ndxab Jesús loo Pedr: ―Chele'i tataa nac, le' sya, mèn gulàaz che'n mèn co' ñibe' inquinte quix tmi che'n contribución sya, xàa. ");
INSERT INTO zamNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Per par ne'ta'de na' xyàn lezo' mèn ba', huàa loo lagun co' nzi go'. Huàa lobii lansuel le'n lagun. Le' sya, ner mbèel co' yigaa loo lansuel, tyenl mbèela. No xal' ro mbèela. Le'n ro mbèela ryo' thìb pes fchòo plat, co' nee di's, thìb pes. Con sobr thìb pesa ta'l ayud loo mèna cón che'nl no ta'l ayud cón chenen co' nac impuest co' ña'b mèna loo na', ndee. ");
INSERT INTO zamNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Leque le'n huiza myen' xin' mté'th Jesús thidte mqueltàa loo Jesús. Mnibdi's myen' loo Jesús. Ndxab myen': ―Tad, ¿chó mèn nac más mèn roo no mèn xèn co'te' ñibe'pe' Diox loo bé' nalle', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sya, ngurez Jesús thìb mbedbi' chu'th. Mdoo Jesús mbedbi' chu'tha loo myen'. ");
INSERT INTO zamNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ndxab Jesús loo myen': ―Lìcque' nac co' nde niin loo gu' ndxè': Chele' gu' ne'tyalte lyàa yéc gu' no lyàa lezo' gu' no zye' mod co' ndxàp gu' par gàp gu' mod xal ndxàp mbedbi' chu'th ndxè' mod, chele' gu' ne'taade li, ne'tyalte Diox ta' Diox lugar loo gu' yòo gu' loo cón che'n Diox par ñibe'pe' Diox loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Cona, ngue niin loo gu': Mèn co' gàc más mèn roo no mèn xèn co' ñibe'pe' Diox loo, mèna nac mèn co' indye'ste no co' inxyal'te. No ndxàc mèna mèn nado' co' ndxàp mod xal mbedbi' chu'th ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Le' chol mèn co' tyal ta' lugar yòo mèn co' ndxela's loon làth mèna tac ndxela's mèna loon, mastale' nac mèna mèn nado' xal mbedbi' chu'th ndxè', ndxàca loo mèna ndyalque' mèna no nda' mèna lugar ndxòon làth mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Chol gu' co' asendli par cua'n mèn co' ndxela's loon, co' nac mèn nado' co' indye'ste no co' inxyal'te, xquin mèn no xtol mèn, más huen gàca loo gu' quedó' mèn thìb quèe yees yen gu' no yiloa cobii mèn gu' loo níttó' par tataa mod dyep gu' le'n níttó'. ");
INSERT INTO zamNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Susque' nazab ndxàca loo mèn loo izlyo' ndxè' tac anze'f thìb con' nzo co' ndli par cua'n mèn xtol mèn no xquin mèn. De tods mod nzoque' con' co' ndli ncua'n mèn xquin mèn no xtol mèn loo izlyo'. Per más nalyat gàca loo mèn no más nè gàca loo mèn co' ndli ncua'n taamas mèn xquin mèn no xtol mèn loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Cona, ngue niin loo gu': Chele' gu' ndli cuent le' nii gu' o ya' gu', lìcque', ndli par ncua'n gu' xtol gu' no xquin gu' por mdyub yo'f lezo' gu' loo con' co' mque no gu' no con' co'te' ngua gu', más huen cho' gu' nii gu' no ya' gu' no tith blobii gu' nii gu' no ya' gu' loo gu'. Tac más huen gàca loo gu' yòo ban no gu' Diox thidtene, yende ya' gu' o yende nii gu', leque lyàa gu' le'n ye'rbìil co'te' nzo quìi no bèel co' ne'yu'de thidtene con ryop nii gu' no con ryop ya' gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","No chele' gu' ndli cuent le' ngudloo gu', lìcque', nac co' ndli ncua'n gu' xquin gu' par tyub yo'f ye'rsin' lezo' gu' loo con' ngüi' gu', más huen blo' gu' ngudloo gu' no blobii gu'i tith loo gu'. Tac más huen gàca loo gu' chele' gu' yòo co'te' yòo ban no gu' Diox thidtene con sate ngudloo gu' leque yòo gu' ye'rbìil co'te' ndxetoo quìi no bèel co' ne'yu'de thidtene con ryop ngudloo gu'. Por cona, thidtene ne'cua'nte gu' xquin gu' par ne'yòode gu' le'n ye'rbìil. ");
INSERT INTO zamNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nde niin tedib con' loo gu', ne, ey: Ne'co' toode gu' myen' bix co' nac xal myen' bix ndxè' thìb lad loon, ndee gu'. Tac angl co' nac angl che'n myen' bix thidtene nzo loo xuden Diox co' nzo loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tac daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo', daa ndal par telá'en mèn loo con' ryes, mèn co' nzi tee huan loo Diox por con' ye'rsin' co' ndli mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Xá nee gu'? Chele' thìb mbi' ngue no thìb ayo mbacxil' no mtuhuan mbi' thìb mbacxil', ¿ché' ne'queltàade mbi' ryete thap gal nzo si'n thap mbacxil'a thidte lugar par ya cua'n mbi' thìz mbacxil' co' mdyuhuana, cà'? Queltàaque' mbi' rye mbacxil' thidte lugar, ¿lé'? Tataaque' li mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","No chele' mbi' mbli gan mzyal mbacxil' co' mdyuhuana, daa ngobe' más tyac lezo' mbi' co'se' ngolo mzyal mbi' mbacxil'a leque tyóo mbi' cón che'n rye thap gal nzo si'n thap mbacxil' co' mtan' mbi'a co' ne'nduhuanta, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Cona, ngue niin loo gu': Lomisque' mod ne, xud gu' co' nzo loo bé' indlya'ste tyuhuan nec thìb mèn co' nac mèn prob no mèn ladyox co' ñaa xal ñaa mbedbi' chu'th ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Chele' thìb mèn co' nac hues xtàa gu' li con' ye'rsin' loo gu', xexte blo' gu' xa' thìb lad par tyoodi's no gu' xa' cón che'n con' mbli no xa' gu'. Bli gu' par ta' xa'a cuent cón che'n xquin xa' no xtol xa' loo gu'. Chele' xa'a li cas loo di's co' tyoodi's gu'a, le' sya, mbli gu' gan mbyu' mbyàl loo di'sa no loo cuenta cón che'n ryop gu' xa'. ");
INSERT INTO zamNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Per chele' hues xtàa gu'a ne'lide cas xal nac di's co' ndyoodi's no gu' hues xtàa gu', sya, gurez gu' chop o son mèn par queltàa no gu' mèna par non mèna no ta' mèna cuent xá nac di's co' tyoodi's gu' con hues xtàa gu'. Le' sya, chop o son mèna nac testiu co' ta' cuent xal nac di's co' mdoodi's gu' con hues xtàa gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Lomisque' ne, chele' xa'a ne'lide cas loo chop o son gu' co' queltàa con xa'a, guuz gu'i no fta' gu' cuent loo mèn co' nqueltàa loo cón chenen. Chele' xa'a ne'lide cas loo mèn co' nqueltàa loo cón chenen, sya, bli gu' cuent le' xa'a nac xal mèn co' indxela'ste loo Diox o nac xa'a xal thìb mèn co' ndlixù' cobrar tmi co' nac che'n nación na' par ta'xù' mèna tmi loo gobiern co' ndub ciuda Rom. ");
INSERT INTO zamNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Lìcpe' ba'i, na ngue nii loo gu': Con' co' ñibe' gu' loo mèn yende mod li mèn, con'a gàc con' co' mnibe' lezon loo bé' gàc con' co' yende mod li mèn, mèn co' nzo loo cón chenen. No con' co' ñibe' gu' loo mèn par li mèn, con'a gàc con' co' mnibe' lezon loo bé' gàc loo mèn no con' co' li mèn, mèn co' nqueltàa loo cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Niin loo gu', ne: Chele' chop gu' thidte gàc xtùuz no thidte gàc lezo' gu' loo con' lya's gu' ña'b gu' loo Diox loo izlyo' ndxè' co'se' cuez gu' Diox, le' sya, xuden Diox co' nzo loo bé' li par que no gu' con' ña'b gu'. No li xuden Diox gàcque' con' co' ña'b gu' loo xuden Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tac co'te' nzo chop o son mèn co' nqueltàa loo cón chenen por lèen, làth mèna nzoquen. ");
INSERT INTO zamNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sya, mbii gax Pedr loo Jesús. Mnibdi's Pedr loo Jesús. Ndxab Pedr: ―Tad, chele' thìb huesen cua'n xtol no xquin huesen huax vez loon, ¿plá vez teri'th tecanen con' co' ndli huesen loon, à'? ¿Ché' teri'th tecanen con' ye'rsin' co' ndli huesen loona gaz vez, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús mcàb loo Pedr. Ndxab Jesús: ―Iniiden lool: Teri'thl no tecan'l xèn xyàn co' ndli huesla lool gazte vez, Pedr. Ndxe'leque', ngue niin lool: Fteri'th ftecan' xèn xyàn co' ndli huesl loola thap ayo nzo thap gal nzo si' vez loo huesl. ");
INSERT INTO zamNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nde niin tedib con' loo gu', ey: Le' mod co' ñibe'pe' Diox loo mèn no mod co' ndlya's Diox gàp mèn làth xtàa mèn nac taandxè': Mèn co' ñibe'pe' Diox loo nac xal nde niin loo gu' ndxè' xal thìb rey co' mblya's co' cuent cón che'n yalgute'f co' ndeb rye moz loo rey. ");
INSERT INTO zamNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Le'pe' mtlo rey, ngue go' rey cuent plál ndeb moz loo rey, nde no mèn thìb mbi' co' ngro' te'f huax millón pes loo rey. ");
INSERT INTO zamNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Per com le' moz ndyac ingue node moz tmi par quix moz tmi co' ndeb moz loo reya, ¿lé'?, rey mnibe' loo taamas moz rey ya tho' moz mbi'a nazal' rye mèn famil mbi' con rye co' ndxàp mbi' liz mbi' par tataa mod yax mase ndxep yalgute'f co' ndeb mbi' loo rey. ");
INSERT INTO zamNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sya, yende izlyo', mdub xib mbi' loo rey co' ngòc patrón mbi'. Nalyat ndxab mbi' loo rey: Tad, ftedó' U' thìb le' lar' yéc U' loo cuent ndxè'. Fcha'la's U' taandxep con daa. Sau' sau' quixen ryete yalgute'f co' ndeben loo U', ndee U'. ");
INSERT INTO zamNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Le' sya, rey co' ngòc patrón moza, ale le'le' mblyat lezo' patrón gunèe patrón moza. Mton' rey co' ngòc patrón moza rye yalgute'f co' ngro' te'f moz loo rey, co' nee di's, yende cón ndeb moz loo reya. Ngoloa, mbla' rey moz, ndyàa moz par liz moz. ");
INSERT INTO zamNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Per pente ngro' moza. Ndyàa moz. Mzyál' moz tedib xtàa moz ned ndyàa moz co' ndeb pláte pes loo moz. Le' sya, moz co' más ngro' te'fa mxen tedib moza. Ale mdèe moz co' más ngro' te'fa yen tedib moza. No mtlo ngòc nayi' moza loo xtàa moz. Mdi' moza yen xtàa moza. Ndxab moz: ¡Máa yob yécl, sin vergüenz! ¿Pól quixl tmi co' ndebl loon? Inthyontel. Ale nduhuaxù'l tmi daa. ");
INSERT INTO zamNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Sya, moz co' nac xtàa mbi'a mdub xib loo mbi'. No nalyat mde'f ro moz. Ndxab moz loo mbi': Amiu, Compañer, ftedó' thìb le' lar' yécl loo cuent ndxè', yey. Fcha'la's taandxep con daa. Sau' sau' quixen ryethe yalgute'f co' ndeben lool, ndee. ");
INSERT INTO zamNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Per mbi' co' ngòc ner moza ne'ndalte ncha'la's loo mbi' por yalgute'f chu'th che'n moz co' ngòc xtàa mbi'a. Ndxe'leque', ngua ta' mbi' co' ngòc ner moza part loo mèn nac zin'. Le' mèn nac zin' na, mbli mandad mque moza lezi'f axta quix moza no zib moza tmi co' ndeb moz loo tedib mbi' co' nac xtàa moz. ");
INSERT INTO zamNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Co'se' gunèe taamas xtàa moz moz ndxàc con'a, anze'f mden' moza no mxi lezo' moz ngòc con'a. Sya, mxen taamas moza ned. Ngua nee moza loo rey co' ngòc patrón moza ryete con' ngòc loo prob tedib moza. ");
INSERT INTO zamNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Sya, mbli rey co' ngòc patrón moza mandad par ye'th mbi' co' ngòc ner moza loo rey. Sya, ndye'th no mèn mbi' co' ngòc ner moza loo rey. Rey ndxab loo moz: Susque' mèn ye'rsin'l, moz. No mozdèe lùu. Na mton' ryethe yalgute'f co' ngro' te'f lùu loon tac nalyat mde'f rol mdoodi'sl loon, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Lùu, ne, ndxàal nglat lezo'l ngnèel xtàa mozl xalque' ngulat lezon gunèenl. ");
INSERT INTO zamNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sya, mbi' co' ngòc reya anze'f ngocloo tín' gunèe mbi' co' ngòc ner moza. Mbli rey mandad ya tin mèn mbi' co' ngòc ner moza axtaque' quix mbi' ryethe yalgute'f co' ndeb mbi' loo rey. ");
INSERT INTO zamNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Co'se' ngolo mdoodi's Jesús rye di'sa, ndxab Jesús loo myen' xin' mté'th Jesús: ―Tataa li xuden Diox co' nzo loo bé' con gu' chele' gu' ne'teri'thte no ne'tecan'te, dib nzo yéc gu' no dib nzo lezo' gu', cón che'n xèn xyàn co' ndli hues xtàa gu' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ngolo mdoodi's Jesús ryete di'sa loo mèn, ngro' Jesús le'n yèezya' che'n làaz mèn galile. Mxen Jesús ned. Ndyàa Jesús par ned le'n yèezya' che'n làaz mèn jude co' nziri' par ned ndlyen huiz co' nac tedib lad ro yó'be' Jordán. ");
INSERT INTO zamNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Anze'f thìb mènléy' mdoo nque xís Jesús. No mteyac Jesús huax mèn yíiz par ned ngua que tee Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Sya, ngua plá mèn xley' farise loo Jesús par ñee mèna ñeene' ché' tli mèna gan gàal di's mèna Jesús par tataa mod quexù' que' fals mèna Jesús yiloa. Asembli mèna, mnibdi's mèna loo Jesús. Ndxab mèna: ―¿Ché' nzo mod lá' thìb mbi' thìb xa'got co' nac sa'lpe' mbi' por chol con' bix co' mbli xa'gota no maste, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús mcàb loo mèna. Ndxab Jesús: ―¿Ché' tarte lab gu' di's co' ndub loo libr co' nac xti's Diox, cà'? No ¿ché' tarte ta' gu' cuent cón nee di's di'sa? Co'se' mblec Diox no mtoxcua' Diox izlyo', Diox mbli thìb con'. Mblec Diox mènbi' no mèngot loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Lomisque', ndub di's loo libr co' nac xti's Diox co' mbez taandxè': Mèn co' nac mènbi', lá' mèn xud mèn no lá' mèn xna' mèn par thidte queltàa mèna con xa'got co' gàc xin' sa'l mèna. Co'se' tataa ndxàca loo ryop sa'l mèna, ndxàca loo ryop sa'l mèna le' ryop sa'l mèna ndxàc thidte bél' no thidte zith loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Por cona, ngue niin loo gu': Co'se' nqueltàa thìb mènbi' con thìb mèngot par selya' mènbi' con mèngot, ya inacte ryop mèna chop. Ndxe'leque', ryop mèna ngòc thidte bél' no thidte zith loo Diox. Por cona, yende chó derech ngue no chol mèn par li mèn lá' thìb xa'bi' thìb xa'got co' nac xin' sa'l xa'bi'. ");
INSERT INTO zamNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Sya, asembli mèn xley' farise. Mnibdi's mèn xley' farise loo Jesús. Ndxab mèna: ―¿Chonon mnibe' Moisés ta' thìb mènbi', co' nac sa'l thìb xa'got, ye's co' lèe act loo mèngot, sya ndli mènbi' par tataa mod lá' mènbi' xa'got co' nac sa'l mènbi', sya? ");
INSERT INTO zamNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús ndxab loo mèna: ―Aa, tataa mbli Moisés loo gu' tac Moisés non no nanee Moisés le' gu' anze'f naad no nguud gu'. Cona, mda' Moisés lugar ta' gu' ye's co' lèe act loo xa'got par lá' gu' xa'got co' nac xin' sa'l gu'. Per ne'nda'de Diox lugar ngàca tataa làth mèn ndoore' gàc tiemp co'se' yo ban Moisés. ");
INSERT INTO zamNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Na ngue nii loo gu', ne: Le' thìb xa'bi' co' lá' sa'lpe' no ingue lide sa'lpe' xa'bi'a yalburrid, no selya' xa'bi'a con tedib xa'got, le' sya, xa'bi'a ngue li yalburrid con tedib xa'gota. Lomisque' ne, chele' thìb xa'bi' selya' con thìb xa'got co' mblá' sa'l, xa'bi'a ngue li yalburrid con xa'gota, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Sya, myen' xin' mté'th Jesús ndxab loo Jesús: ―Chele'i tataa ndxàc loo mènbi' con xa'got co' nac sa'l mènbi', indxàalte selya' mèn sya xàa, ndyac nu'. ");
INSERT INTO zamNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús ndxab loo myen' xin' mté'th Jesús: ―Iryede mèn nden' cón che'n di's ndxè' par tyubdi's mèn loo di's ndxè'. Inacte di's ndxè' par ten' rye mèn cón che'n di's ndxè'. Ndxe'leque', mèn co' nden' no nda' mèn cuent nac mèna mèn co' Diox ndli par ten' mèn di's no ta' mèn cuent cón che'n di's ndxè' par tyubdi's mèna loo di's ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nzo huax mènbi' co' inselya'de con mèngot. Nzo ndxep mènbi' co' ancual ngóol co' inselya'de con mèngot. No nzo taamás mènbi' co' inselya'de con mèngot tac ngo mèn co' mbli capón mèna. No nzo taamas mènbi' taate mbyan'. Inselya'de mèna tac mèna mnibe' loo lezo' mèna ante li mèna sirv loo Diox no maste. Cona, ngue niin con' ndxè' loo gu', gu' co' nden' no co' ndxòn di's co' ngue niin loo gu' ndxè' par tyubdi's gu' loon: Bìn gu' di's no fta' gu' cuent cón nee di's ndxè'. No fta' gu' lugar yaa'd di's ndxè' le'n lezo' gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Làth xtau'a, mbi'th no mèn co' nac xna' myen' bix myen' bix loo Jesús par xo'f Jesús ya' Jesús lad myen' no par cuez Jesús Diox cón che'n myen'. Per ndxe'leque', myen' xin' mté'th Jesús mtlo ngocloo. No mbyoo myen' xin' mté'th Jesús xna' myen' bix o mèn co' nde no myen' bixa. ");
INSERT INTO zamNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Sya, ndxab Jesús loo myen' xin' mté'th Jesús: ―La' gu' tetee myen' bix ba' loon chele' myen' bix ba' nde loon. Ne'tau'te gu' loo mèn co' nde no myen' bix ba'. Tac mèn co' ndyal no nda' mèna lugar ñibe'pe' Diox loo mèna, ndxàca loo mèna ndxàc mèna xal myen' bix ba'. ");
INSERT INTO zamNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ngolo mxo'f Jesús ya' Jesús lad myen' bixa, no ngolo ngurez Jesús Diox por cón che'n myen' bixa, mbii Jesús tya. ");
INSERT INTO zamNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Látha, mzin thìb mbyòo loo Jesús. Ndxab mbyòo loo Jesús: ―Maistr Ndac, ¿chó con' ndac tolo lin par thìb lìte yòo ban non Diox thidtene, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús mcàb loo mbyòo. Ndxab Jesús loo mbyòo: ―¿Chonon mbez lùu loon le' daa nac thìb maistr ndac, à'? Yende chó mèn co', lìcque', nac mèn ndac. Angoluxte Diox nac xa' ndac. Chele' lùu indlide cuent no inden'te lezo'l nac daa Diox, axta ne' ne' ñeel loon nac daa maistr ndac. Per chele' lùu, lìcque', lya's yòo ban nol Diox thidtene, ftubdi's xal nac di's co' ñibe' ley co' mxo'f Moisés loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mbyòo mcàb. Ndxab mbyòo loo Jesús: ―¿Chópe' yalñibe' nac co' más ñibe' ley co' mxo'f Moisés loo mèn par lina, à', Tad? Jesús ndxab loo mbyòo: ―Yalñibe'a nac di's ndxè': Ne'guthtel mèn; ne'que tee lidel yalburrid; ne'li huan'tel; ne'toxcua'del yalgutyè' cón che'n nec thìb mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gòp mod gunèe xudl no xna'l. Fque' lezo' gunèe huesl no xtàal xalque' ngue lezo'l ñèel leque lùu. ");
INSERT INTO zamNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mbyòo ndxab loo Jesús: ―Aa, Tad, ryete con' co' ñibe' di'sa loo mèn par li mèn ndliquen desde ndoo roon no desde ndoo xènen. ¿Ché' nzo chóre' con' ndxàc falt ndyac U' tolo lin, à', Tad? ");
INSERT INTO zamNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús ndxab loo mbyòo: ―Chele' lùu, lìcque', lya's gàc mèn nambìi no mèn nalì loo Diox, huàa tho' ryethe con' ndxàpl par ryo' tmi looi. Yiloa qui'thl tmia loo mèn co' ndyac yaltìi. Le' sya, tataa mod tolo gàpl yalgon' no yalndac loo bé'. Yiloa ndye'thl. Tyoo nquel xísen. Nda na'. ");
INSERT INTO zamNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Per co'se' mbìn mbyòo di's co' ndxab Jesús, nalyat mdeb ro mbyòo, ndyàa mbyòo, por tant ndxàp mbyòo che'n mbyòo no nèe la's mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Sya, ndxab Jesús loo myen' xin' mté'th Jesús: ―¡Lìcque' nac co' ngue niin loo gu' ndxè', cara! Axta arid nagàn naca par tyal mèn ric no ta' mèn ric lugar loo Diox par ñibe'pe' Diox loo mèn ric. ");
INSERT INTO zamNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Beren, niin con' ndxè' loo gu' tedib vez: Más inagànte naca riid thìb má' co' lèe camell le'n ye'r co' nac ngudloo thìb aguj leque tyal mèn ric no ta' mèn ric lugar loo Diox ñibe'pe' Diox loo mèn ric. ");
INSERT INTO zamNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Co'se' mbìn myen' xin' mté'th Jesús di's co' ndxab Jesús loo myen', ante mbui' myen' no ante gunaa myen' loo xtàa myen'. Mnibdi's myen' loo xtàa myen'. Ndxab myen': ―Chele'i tataa nac, ¿chó mèn gác lyá' loo con' ryes, sya? ");
INSERT INTO zamNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús xèe mbui' loo myen'. No ndxab Jesús loo myen': ―Yende mod li chol mèn gan li mèn con' par lyá' mèn loo con' ryes. Per Diox ndxácque' li Diox chol con' xal ndlya's Diox li Diox loo mèn. Yende chó mèn gác cuee cà' Diox loo chol con'. ");
INSERT INTO zamNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Sya, ndxab Pedr loo Jesús: ―Tad, nu' mblá'ya' ryete con' mque no nu' no con' ngòp nu'. No ngue tee nqueque' nu' xís U' ned ngue tee U'. ¿Cón gàp nu' no cón que no nu' yiloa, sya? ");
INSERT INTO zamNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús mcàb loo myen'. Ndxab Jesús: ―Lìcpe' ba'i, na ngue nii loo gu': Co'se' gàc tiemp no co'se' gàc cub ryethe con', no lomisque', co'se' tub ñibe'en, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, loo thìb asient co'te' gàc thìb lugar co'te' ñibe'pe'en por cón che'n ryethe con' roo con' xèn co' gàpen la's niin no la's yan huiza, le' sya, gu' co' ndoo nque xísen nalle', gu' co' ne'nglá'de daa, ryete si' fchop gu' tyub loo si' fchop asient par tub rez gu' cón che'n mèn nación Israel huiza, mèn co' nac si' fchop ned co' mblec biz no bin. ");
INSERT INTO zamNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","No ryete mèn co' mblá'ya' liz no co' mblá'ya' hues, no fta'n, no bél, no xud, no xna', no sa'l, no xin', no xyòn ante por cón chenen no maste, mèna gàc che'n no càaya' mèna masre' thìb ayo tant con' loo co' nac che'n mèn co' mblá'ya' mèn. No más de cona, mèna yòo ban no Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Per nalle' loo izlyo' ndxè' nzo huax gu' co' nac mèn nación Israel. Gu' nzi li xtùuz anze'f ntac gu' loo Diox no anze'f mèn roo no mèn xèn nac gu' loo Diox por nac gu' mèn nación Israel. Per ndxe'leque', Diox li le' gu' gàc mèn be'the loo Diox tac Diox ndxecloo ñèe gu'. Per part cón che'n Diox, mèn co' ingode gu' cuent anze'f ntac mèn loo Diox, mèn co' inacte mèn nación Israel, Diox li gàc huax mèna mèn co' más ntac loo Diox leque gu'. No gàc mèna mèn co' más ndyac lezo' Diox ñèe Diox por mbli mèna cas loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nde niin thìb con' loo gu', myen', cón che'n xá mod ncàba loo mèn, mèn co' ndyal no mèn co' nda' lugar ñibe'pe' Diox loo mèn: Moda nee di's nac xal thìb mbi' co' mque no thìb ranch. Mbi'a ngo chegà thìb xtil' par nda cua'n mbi' moz co' que zin' par làa moz uv loo lus uv loo xyòn mbi'. Mzyalque' mbi' moz xtil'a. ");
INSERT INTO zamNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sya, ndxab mbi' co' ngòc xuan' yòo lus uva loo moz le' mbi' quix xop pes càa moz huiz par làa moz uv. Moz mdyalque' que moz zin' no yax càa moz xop pes huiz. Ngolo mbli la's mbi' con moz le' mbi' tataa quix huiz moz, mtel' mbi' moz loo xyòn mbi' par tlo moz, làa moz uv loo xyòn mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ngoloa, ngro' mbi' como hor nquée guyè' xtil' tedib vez legue huiza. Gunèe mbi' nziri' ndxep moz co' nalath loo xbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ndxab mbi' loo moza: Daa ndlyaz ya gu' zin' loo xyònen par ya làa gu' uv loo lus uv loo xyònen. No ndoo lìte gon ray gu'. Ngoloa, mxen moza ned. Nda moz zin' loo xyòn mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Casque' rol huiz mbere mbi', ngro' mbi', ngua cua'n mbi' moz tedib vez. No casque' hor mquée guyon bzyè mbere mbi', ngro' mbi' tedib vez par ngua li mbi' lomisque' con' loo taamas moz. ");
INSERT INTO zamNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Co'se' ngóol hor mquée yuga'y bzyè, mbere mbi', ngro' mbi' tedib vez. Nda mbi' loo xbi'. Mzyál' mbi' taandxep moz co' nalath co' nziri' par neda. Ndxab mbi' loo moza: ¿Chonon nziri' gu' trè' dib huiz nalze no ne'nquede gu' zin', yey? ");
INSERT INTO zamNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Moz ndxab loo mbi': Angngure' nu' trè' nalze tac yende chó mèn co' nac patrón ngzál' nu' par ngna'b nu' zin' nque nu' loo patrón. Sya, ndxab mbi' loo moza: Huàa gu' zin' loo xyònen, yey. Na ndoo lìte go ray gu' yilo huiz. ");
INSERT INTO zamNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Co'se' mzyèle' izlyo' huiza, mbi' co' ngòc patrona ngurez mandador co' ndyoo naa no co' ndyoo ner loo zin'. Ndxab mbi' loo mandador: Mandador, gurez rye moz co' ngue zin' no blo ray moz. Ftlo blo ray moz co' ngòo bluz loo zin'. No yiloa, col ray moz co' ngòo ner loo zin'. ");
INSERT INTO zamNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Sya, ndye'th moz co' ngòo loo zin' co'se' ngòc hor nquée yuga'y bzyè. Mblo mandador ray moza xop pes co' ngòc ray che'n thìb huiz zin'. ");
INSERT INTO zamNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ngoloa, ndye'th moz co' más ngòogà loo zin'. Mbli moza xtùuz masre' yòo ray moz por más ngòogà moz loo zin' huiza. Per ndxe'leque', thìb thìb moz ngòo ray xop pes co' ngòc ray che'n thìb huiz zin'. ");
INSERT INTO zamNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Co'se' ngolo ngòo ray moz co' mtlogà zin'a, ngua nee moza loo patrón: ¿Chonon le laate ngo U' ray ryete moz no taamas moz ndale' huiz ngòo loo zin'? No lomisque', ngo ray moz con moz co' ngòogà loo zin'. ");
INSERT INTO zamNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Tolo ndxab moz loo patrón: Moz co' más bluz ngòo loo zin' ba', moz ba' pente mbli zin' thìb hor no maste. No ale lalque' mblo U' ray moz ba' con' co' mblo U' ray nu'. Nu' mque zin' dib huiz. No mxec nu' mtec mso' bée lad nu'. ");
INSERT INTO zamNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Per mbi' co' ngòc patrona mcàb loo thìb moz. Ndxab mbi' loo moza: Amiu, nec thìb mod no nec tedib mod ingue tetìiden gu'. Daa ngue lique' con' co' nac nalì loo gu'. ¿Ché' ne'ngyan'te ryop na' di's le' daa guix xop pes càa gu' thìb huiz zin', cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Bye' xop pes ba'. Byàa. Na ndlyas go ray moz co' ngòo más bluz loo zin' lomisque' xal mblon ray lùu ba'. ");
INSERT INTO zamNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Ché' ngue lil cuent yende mod lin xal ndlyazen con tmi daa, cà'? ¿Ché' ndxan lezo'l ñèel daa tac huen nac daa con chol mèn, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sya, tolo ndxab Jesús loo mèna: Na nii con' ndxè' loo gu': Gu' ndli xtùuz por nac gu' mèn nación Israel anze'f ntac gu' loo Diox, ¿lé'? Per Diox lu' loo gu' le' Diox indyacte lezo' ñèe Diox gu'. Ndxe'leque', ndxecloo Diox ñèe Diox gu'. Le' tedib cua' mèn co' inacte mèn nación Israel, mèn co' nzi li gu' xtùuz ndxecloo Diox ñèe Diox mèna, per ndxe'leque', Diox lu' loo gu' le' làth mèna nzo huax mèn co' ndyac lezo' Diox ñèe Diox. Diox mbli thìb con'. Ngurez Diox huax mèn par yila's mèna loo Diox no loo cón che'n Diox. Per ndxepte mèn nzo co' mdyal mbìn cón che'n Diox no co' mdyal mdubdi's loo Diox. Diox mcui mèn co' ngola'sque' loo Diox par nac mèna xin' Diox nalle'. ");
INSERT INTO zamNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Láth ndoo Jesús ned nda Jesús par ciuda Jerusalén con myen' xin' mté'th Jesús no taamas mèn co' nda no Jesús, mbe' Jesús ryete si' fchop myen' xin' mté'th Jesús thìb lad loo mèn. Ndxab Jesús loo myen': ");
INSERT INTO zamNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Hui' gu' nexa. Nase ñee gu' no nda' gu' cuent le' na' ndoole' ned. Nda quée na' par ciuda Jerusalén. No gàca loon le' thìb mbi' ta'xù' daa loo mèn, mèn co' nac jef co' más ñibe' loo rye nguley' no loo mèn co' nac maistr che'n ley co' mxo'f Moisés loo mèn. No axta quexù' que' fals mèna daa par guthxù' mèna daa, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","No ta'xù' mèna daa, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn, loo mèn tith co' inacte mèn nación Israel par xìis no mèna daa. No ta' mèna chenen axtaque' que' mèna daa loo thìb cruz. Per co'se' ngolo son huiz nguth daa, daa ryo xban làth mèn nguth. ");
INSERT INTO zamNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sya, mbii gax xa'got co' nac sa'l Zebede, xa'got co' nac xna' Cob no Juàn, loo Jesús con Cob no Juàn. Mdub xib xna' myen' loo Jesús. Mna'b xna' myen' loo Jesús. Ndxab xna' myen': ―Tad, bli U' favor loon. ");
INSERT INTO zamNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús mnibdi's loo xna' myen'. Ndxab Jesús: ―¿Cón ndlya'sl li na, ey? Xna' myen' ndxab loo Jesús: ―Co'se' ñibe'pe' U' loo nu' loo izlyo' ndxè', ta' U' lugar gàc thìb xgan' daa síndico no gàc tedib xgan' daa juez co' lyath no U' hora. Con'ate no más ndlyazen, Tad. ");
INSERT INTO zamNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Per Jesús mcàb loo xna' myen' no loo myen'. Ndxab Jesús: ―Axta ne' ne' ñee gu' cón ngue na'b gu' loon. Nibdizen thìb con' loo gu': ¿Xá nee gu'? ¿Ché' tác gu' no ché' xec gu' tyactìi gu' xalque' gàc yaltìi co' xec daa gàc loon le'n huiz ndxè' co' nac xalque' co'se' gu mèn thìb taz nít cuan' huan nalà, cà'? No ¿ché' tli gu' ryes gath gu' xalque' gàca loon yé' huize', cà'? Myen' mcàb loo Jesús. Ndxab myen': ―Xec nu', pues. ");
INSERT INTO zamNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús mcàb loo myen'. Ndxab Jesús: ―Lìcpe' ba'i, le'i gàc loo gu' le' gu' tyactìi tín' xalque' gàc yaltìi tín' loon yé' huize' axtaque' gath gu' xalque' gath daa. Per con' co' ndlya's gu' gàc gu' xal thìb síndico no xal thìb juez par ñibe' no gu' daa, inacte con'a cón chenen par tan lugar loo gu' gàca tataa loo gu'. Ndxe'leque', mèn co' gàc xal juez no xal síndico co' ñibe' no daa, mèna nac mèn co' gunee lezo' xuden Diox, no mèn co' mdoo lezo' xuden Diox gàc mèna xal síndico no xal juez co' lyath no daa co'se' ñibe'en loo mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Co'se' mbìn taasi' myen' xin' mté'th Jesús con' ndxab Cob no Juàn no xna' Cob no Juàn loo Jesús, ngocloo tín' myen' loo ryop hues Cob Juàn. ");
INSERT INTO zamNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Co'se' gunee Jesús ndxecloo myen' loo Juàn no loo Cob, ngurez Jesús ryete myen'. Ndxab Jesús loo myen': ―Com le' gu' nda'le' cuent no nonque' gu' le' mèn co' ñibe' loo chol nación loo izlyo' ndxè', mèna ñibe' yèe loo mèn co' nac che'n nación par yende chó ñii loo mèn co' ñibe'. Le' rye mèn co' nac más mèn roo mèn xèn làth rye nación loo izlyo' ndxè', lomisque', ñibe' yèe mèna loo mèn che'n nación. ");
INSERT INTO zamNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Per part cón che'n gu', ne'lide gu' tataa làth gu'. Ndxe'leque', gu' co' ndlya's ñibe' loo xtàa gu' no gu' co' ndlya's gàc mèn roo no mèn xèn làth xtàa gu', gu'a gàc mèn co' li sirv loo xtàa gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","No chol gu' co' ndlya's ñibe' loo xtàa gu', no co' ndlya's tyoo ner no tyoo naa loo xtàa gu', gu'a gàc xal thìb moz loo xtàa gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Gu'a ndxàal li xalque' ndlin. Tac daa ne'ngal yáalte loo izlyo' ndxè' par li mèn sirv loon. Ndxe'leque', daa mbal yáal loo izlyo' ndxè' par lin sirv loo mèn no par le'le' daa ta' yalnaban daa loo yalguth xal mèn co' nguix cón che'n thìb con' co anze'f ntac. Tataa lin par lyá' huax mèn loo con' ryes por cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Co'se' nda ro' Jesús con myen' xin' mté'th Jesús ro ciuda Jericó par quée Jesús ned ciuda Jerusalén, anze'f thìb mèn nda nque xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ned nda Jesús, ndub chop mèn sieu ro ned. Co'se' mbìn mèna le' Jesús nde riid, cabii ngurez mèna. Ndxab mèna: ―Tad, U' co' nde bin David co' ngòc rey póla, gulat lezo' U' gunèe U' nu'. ");
INSERT INTO zamNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Co'se' ñee mèn co' nda nque xís Jesús mbez yèe ryop mbi' sieua, mèna mbyoo ryop mbi' sieu par cued, ya ne'cozèede ryop mbi'a más. Per ndxe'leque', ryop xa'bi' sieua sate más cabii mbez yèe. Mbez ryop xa'bi' sieua: ―Tad, U' co' nde bin David co' ngòc rey póla, gulat lezo' U' gunèe U' nu'. ");
INSERT INTO zamNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Sya, nguled Jesús ned. Ngurez Jesús ryop xa'bi' sieua. Mnibdi's Jesús loo xa'. Ndxab Jesús: ―¿Cón ndlya's gu' li non gu', à', ey? ");
INSERT INTO zamNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ryop xa'bi' sieua mcàb. Ndxab xa' loo Jesús: ―Nu' ndlya's gác nu' hui' nu', Tad. ");
INSERT INTO zamNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Sya, mblyat lezo' Jesús gunèe Jesús ryop xa'bi' sieua. Ante mbuàal Jesús ngudloo ryop xa'. Chàa, mdub xnìi ngudloo ryop xa'. No ndxe'sleque' mbui' ryop xa'. Ngoloa, mxen ryop xa'bi' co' ngòc sieu ned. Nda nque xa' xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Co'se' yamerle' nde zin gax Jesús con mèn co' nda nque xís Jesús ro ciuda Jerusalén, mzin Jesús con mèna yèez Betfagé co' nziri' gaxte co'te' ndub thìb yii co' lee yii che'n yaa oliv. Tya, mtel' Jesús chop myen' xin' mté'th Jesús par ya myen' thìb mandad le'n yèez Betfagé. ");
INSERT INTO zamNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ndxab Jesús loo ryop myen': ―Huàa gu' le'n yèez chu'th co' nziri' go'. Tua' zyal gu' thìb burrgol con xin' burrgol co' ndoo quedó'. Fxac gu' burrgola. No ye'th no gu' burrgol con xin' burrgol trè'. ");
INSERT INTO zamNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Chele' chol mèn ñee loo gu': ¿Chonon ngue xac gu' burrgol ba'?, gab gu' loo mèna: Tad na' nquin má'. Sya, mèna la' ye'th no gu' má' loon. ");
INSERT INTO zamNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ngòc con'a loo Jesús par ngòcque', no mdyaaque', no mdubque' di's co' gunii thìb xa' co' mde'th di's co' ndxab Diox co'se' mque' xa'a ye's loo libr co' nac xti's Diox, di's co' mbez: ");
INSERT INTO zamNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Guuz gu' loo mèn ciuda Jerusalén: Hui' gu' nexa. Mbi' co' nac rey gu' nde loo gu'. Anze'f nado' nac mbi'. No ndub mbi' thìb burr yèn' co' nac xin' thìb burrgol co' ndxe' yó'. ");
INSERT INTO zamNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Sya, mxen ryop myen' xin' mté'th Jesús ned. Nda li myen' xal mnibe' Jesús loo myen' li myen'. ");
INSERT INTO zamNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ndye'th no myen' burrgol con burr yèn'. No nabe'ste mtoxcua' myen' co'te' tyub Jesús con xab myen'. Ngoloa, mquée Jesús burr yèn'a. ");
INSERT INTO zamNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Le' rye mèn co' nde nque xís Jesús na, msil' mèna xab mèna xtau' ned par riid Jesús loo xab mèna tant mdyac lezo' mèna ñèe mèna Jesús. Le' taamas mèna na, mcho' laa yaa yin. No mdoo mèna laa yaa yina ro ned co'te' riid Jesús tant ndyac lezo' mèna ñèe mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sya, rye mèn co' nda no Jesús, mtlo mèna, mbez yèe mèna. Le'le' mbez yèe mèn co' ndoo ner loo Jesús. No le'le' mbez yèe mèn co' ndoo nque ned xís Jesús. Mbez mèna: ―Mbi' roo mbi' xèn nac mbi' co' nac bin David co' ngòc rey póla. Toloque' gab na' di's natú' no di's roo di's xèn cón che'n mbi' co' mtel' Diox: ¡Ay, Dio's! Anze'f Diox roo no Diox xèn nac Tad Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Co'se' ngòo no Jesús rye mèn co' nda no Jesús ro ciuda Jerusalén, rye mèn ciuda Jerusalén ngro' che liz mèn. No mbyàa mbye'th lezo' mèn. Mbez mèn loo xtàa mèn: ―¿Chó mbi' nac mbi' co' nde go', yoo? ");
INSERT INTO zamNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Le' mèn co' nde no Jesús na, mcàb. Ndxab mèna loo mèn ciuda Jerusalén: ―Jesús co' nde'th di's co' ndxab Diox co' nac mbi' che'n yèez Nazaret che'n làaz mèn galile na. ");
INSERT INTO zamNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ngoloa, ngòo Jesús le'n templ che'n Diox. Mblo' Jesús rye mèn co' ntho' le'n templ no rye mèn co' ndi' le'n templ. No mtexyath Jesús rye mes che'n mèn co' nsil tmi. No mtexyath Jesús asient co'te' ndyub mèn co' ntho' palomxtil'. ");
INSERT INTO zamNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ndxab Jesús loo mèna: Loo libr co' nac xti's Diox ndub di's co' mbez: Lizen o templ daa ngro' lèe co'te' cuez mèn daa. Per gu' co' ntho' trè' no gu' co' ndi' trè', ale mbli gu' le' templ daa ngòc xal thìb lyo' che'n huan'. ");
INSERT INTO zamNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Láth ndxàc con'a loo mèn le'n templ, mbii gax plá mèn sieu loo Jesús no mbii gax plá mèn renc loo Jesús par teyac Jesús mèna. Jesús mteyacque' mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Co'se' gunèe mèn co' ngòc jef co' más ñibe' loo rye nguley' no mèn co' ngòc maistr co' mblu' cón che'n ley co' mxo'f Moisés loo mèn tiempa yalguzye' co' mbli Jesús, no co'se' ndxòn mèna le' myen' bix mbez yèe, mbez myen' bixa: Mbi' roo no mbi' xèn nac mbi' co' nac bin che'n David co' ngòc rey póla, anze'f ngòcloo tín' mèna gunèe mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ndxab mèna loo Jesús: ―¿Ché' ndxònl con' mbez myen' bix ba', à'? Jesús mcàb loo mèna. Ndxab Jesús: ―Aa. Ndxònquena. ¿Ché' tarte lab gu' loo libr co' nac xti's Diox co' nda' cuent xal nac di's co' mbez myen' ba', cà? Loo libr ndub di's co' mbez taandxè': Lùu mbli le' myen' bix no rye mbeto' co' be' ndxàaz ndxol' ro labans co' nac di's roo di's xèn co' ngue te'th myen' cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ngoloa, mxen Jesús ned. Mbii Jesús ciuda Jerusalén con myen' xin' mté'th Jesús. Ndyàa Jesús le'n yèez Betañ. Le'n yèeza mdàt Jesús yál'a. ");
INSERT INTO zamNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Co'se' ngo nìi izlyo' tedib huiz co' nde nquea, mxen Jesús ned. Nda Jesús par ned ciuda Jerusalén tedib vez. Láth ndoo Jesús ned nda Jesús, mblyan' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Le'pe' nda riid Jesús tya, gunèe Jesús thìb xan' yaa ngudyuug co' ndoo gax ro ned. Sya, ngua tee hui' Jesús loo yaa ngudyuuga, bel'que' pá ndoo ngudyuug loo yaa par hua Jesús ngudyuug. Per co'se' ngua tee hui' Jesús loo yaa, ante laa ndoo loo yaaa. Sya, ndxab Jesús loo yaa ngudyuuga: ―Desde nalle' par delant ya ne'ta'del xlè thidtene, ndee. Texal ngolo ndxab Jesús di'sa loo yaa ngudyuug, ale be' nzi hui' myen' xin' mté'th Jesús, setilte mbiiz yaa ngudyuug. ");
INSERT INTO zamNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Co'se' ngolo gunèe myen' xin' mté'th Jesús tataa ngòc con' mbli Jesús, ante mbui' myen' no ante gunàa myen'. Sya, mnibdi's myen' loo Jesús. Ndxab myen': ―Tad, ¿xá mod chonon ale setilte mbiiz yaa ngudyuug ba', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús mcàb loo myen'. Ndxab Jesús loo myen': ―Lìcpe' ba'i, na nii loo gu': Chele' gu' yila's loon no ne'gàc chopte lezo' gu' loo cón chenen, le' sya, iante gác gu' li gu' xal mblin loo yaa ngudyuug ba'. Ndxe'leque', gu' gab loo yii co' ndub go': Yii, biiche tua'. Huàa tyub le'n níttó'. Tataaque' gàca loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","No ryete con' co' ña'b gu' co'se' cuez gu' Diox, chele' gu', lìcque', ndxela's loon no ndxàp gu' yalxla's loon, le' sya, Diox lique' le' gu' que no ryete con' ña'b gu' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sya, ngòo Jesús le'n templ. Láth ngue lu' Jesús mèn co' nac cón che'n xti's Jesús no co' nac cón che'n xley' Jesús, ngua gax mèn co' ngòc jef co' más ñibe' loo rye nguley', no mèngool co' ñibe', no co' ndyoo ner, no co' ndyoo naa, loo mèn nación Israel loo Jesús. Mnibdi's mèna loo Jesús. Ndxab mèna: ―¿Chó mnibe' lool mblil con' mblil ná'a no pá ngua té'thl par ngóc mblil con'a, ne, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús mcàb loo mèna. Ndxab Jesús: ―Daa, ne, nibdiz thìb con' loo gu' ñeene' ché' tác gu' càb gu' loon. Chele' gu' gác càb gu' loon, sya, daa, ne, nii loo gu' chó mnibe' loon mblin con'a ná'a. ");
INSERT INTO zamNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Co'se' mbi'th li Juàn Bautist bautizar mèn, ¿chó mnibe' loo Juàn Bautist mbi'th li Juàn Bautist bautizar mèn, à'? ¿Ché' Diox mnibe' loo Juàn mbi'th Juàn o ché' nzo chó mèn co' nziri' loo izlyo' mnibe' loo Juàn, cà'? ¿Xá nee gu'? Fcàb gu' loon. Co'se' mbìn mèna tataa mnibdi's Jesús loo mèna, mtlo mèna, mdoodi's no mèna xtàa mèna. Ndxab mèna loo xtàa mèna: ―Chele' na' gab: Diox mnibe' loo Juàn, sya, ñee Jesús loo na': Chele' Diox mnibe' loo Juàn, ¿chonon ne'ngala'ste gu' loo con' mbli Juàn, sya? Aa, que tont gu' se. ");
INSERT INTO zamNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","No chele' na' gab loo Jesús nzo chó mèn mtel' Juàn, sya, que nzo ne'ñee lezo' na', na' zyebque' por mèn co' nziri' ba'. Tac ryete mèn ba' ngola's le' Juàn Bautist guniique' cón che'n Diox no mde'thque' Juàn cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Con'a, mcàb mèna loo Jesús. Ndxab mèna: ―Ne'neede nu' chó mtel' Juàn. Sya, ndxab Jesús loo mèna: ―Ne' daa ne'niide loo gu' chó mnibe' loon mblin con' mblin ná'a, no con' ndlin loo mèn, no chol con' ndlu'en loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús ndxab loo mèna: ―Nde niin thìb con' loo gu' ñeene' cón ñee gu' cón che'n di's co' nde niin loo gu' ndxè': Ngo thìb mbi' co' ngòp chop xgan'. Ndxab mbi' loo thìb xgan' mbi': Xgan', huàa li zin' loo lus uv na' nalze. Huàa làa uv loo lus uv. ");
INSERT INTO zamNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Xgan' mbi' mcàb loo mbi'. Ndxab xgan' mbi' loo mbi': Indlyasten gan. Per ngoloa, mse' mbyòo xtùuz mbyòo. Ngua que mbyòo zin' loo lus uv. ");
INSERT INTO zamNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ngoloa, ngua ñibe' mbi' loo tedib xgan' mbi' par ya xgan' mbi' zin'. Lomisque', mcàb xgan' mbi' loo mbi'. Ndxab xgan' mbi': Neeca, Tad, nal gan. Per mbyòo nguri'th nza di'sa. Ne'ngade mbyòo zin'. ");
INSERT INTO zamNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Látha, chàa, ndxab Jesús loo mèna: ―Gunee gu' loon. De loo ryop hues mbyòo, ¿chó mbyòo, lìcque', mbli con' mblya's xud mbyòo, à'? Mèna mcàb loo Jesús: ―Mbyòo nera mbli con' mblya's xud mbyòo. Sya, ndxab Jesús loo mèna: ―Aa. Lìcque' nac con' co' nee gu' ba'. Yende cón niin loo gu'. No, lìcpe' ba'i, na nii loo gu': Le' mèn co' ndli cobrar cón che'n contribución, no mèngot co' mbli yalburrid, mèna, ndxe'leque', yòo loo cón che'n Diox par ñibe'pe' Diox loo mèna ndoore' tyal gu' no ta' gu' lugar par ñibe'pe' Diox loo gu' loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tac Juàn Bautist mbi'th lu'le' loo gu' xá mod ndxàal que tee ban ndac gu'. Ne'ngala'ste gu' di's co' mblu' Juàn loo gu'. Per ndxe'leque', mèn co' ndli cobrar cón che'n contribución no mèngot co' mbli yalburrid ngola's loo di's co' mblu' no co' mde'th Juàn. Per part cón che'n gu', mastale' gunèe gu' ryete con' co' ngòc le'n tiemp ndxè', ne'nglàade yéc gu' no ne'nglàade lezo' gu' loo ryethe xquin gu' no xtol gu' par nse' gu' mod co' ndxàp gu' par, bel'que', ngala's gu' loo Juàn no ngala's gu' loon. ");
INSERT INTO zamNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Bìn gu' cón che'n tedib di's co' nde tetaquen loo gu' ndxè', ne: Ngo thìb mbi' co' mque no thìb ranch co'te' mxen' mbi' lus uv loo xyòn mbi'. Ngoloa, mblo mbi' yaaloo dib vuelt ro xyòn mbi'. Mtoxcua' mbi' thìb tanc par yòo nít uv co'se' co' mbi' nít uv. Mtoxcua' mbi' thìb yòobé' par quée mèn par la's mèn loo xyòn mbi'. Ngoloa, mda' mbi' xyòn mbi' cuent rol loo thìb ned mèn, mèn co' ndli zin' loo lus uv. Ngoloa, mxen mbi' ned. Mdee mbi'. Nda mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Co'se' mzin tiemp co' gàc rol cosech che'n uv che'n mbi', mbi'a mtel' moz mbi' par ña'b moz no càaya' moz uv co' gàc cuent rol co' gàc che'n mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Per ndxe'leque', mèn co' mbli zin' loo lus uva mxen moz mbi'. No mtin mèna moz mbi'. No mbeth mèna ndxep moz mbi'. No mbuaa'd quèe mèna taandxep moz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mbi' co' nac xuan' lus uva mbere, mtel' taamasre' moz loo moz co' ngua nera. Per mèn co' mbli zin' loo lus uva lomisque' mbli loo mbryop ned moza. ");
INSERT INTO zamNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Por lult, mtel' mbi' co' nac che'n lus uva xgan'pe' mbi'. Mbli mbi' xtùuz: Yende cón li no mèna xgan' daa. Ndxab mbi' loo lezo' mbi': Peser gàp mèna mod ñèe mèna xgan' daa. ");
INSERT INTO zamNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Per co'se' ñèe mèna nde xgan' mbi' co' nac che'n lus uva, le' sya, mèn co' ndli zin' loo lus uva, mèna ndxab loo xtàa mèn: ―Hui' gu' nexa. Mbi' ba' nac mbi' co' yan' no yòo co' nac che'n lus uv ndxè'. Ya' gu' nda yuth na' mbi' par gàc che'n na' yòo lus uv ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Por lult, mxen mèn co' mbli zin' loo lus uva mbyòo co' ngòc xgan' mbi'a. Mblo' mèna mbyòo thìb lad ro yòo lus uv. No mbeth mèna mbyòo, tya. ");
INSERT INTO zamNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ngolo mdoodi's Jesús loo mèna tataa, mnibdi's Jesús loo mèn co' ngòc jef co' más ñibe' loo rye nguley', no loo mèngool co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel. Ndxab Jesús loo mèna: ―Co'se' yi'th mbi' co' nac xuan' yòo lus uva, ¿xá nee gu'? ¿Cón li no mbi' mèn co' mbli zin' loo yòo lus uva, sya, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mèna mcàb loo Jesús. Ndxab mèna: ―Mbi' co' nac che'n lus uva guth mèna. Ne'lyatte lezo' mbi' ñèe mbi' mèna. No yilo guth mbi' mèn ye'rsin'a, ta' mbi' xyòn mbi' loo tedib ned mèn co' li zin' loo xyòn mbi'. Mèna gàc mèn co', lìcque', li rol uv co' gàc che'n mbi' co'se' gáal tiemp làa mèn uv. ");
INSERT INTO zamNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús mcàb loo mèna. Ndxab Jesús: ―¿Ché' thidtene tarte lab gu' di's co' ndub loo libr co' nac xti's Diox cà? Hui' gu' nexa. Di's mbez taandxè': Quèe co' mblobii albañil thìb lad, leque quèea mbli sirv par ngòc quèea quèe scuadr co' mdub squin yòo. Yub Tad Diox mbli con'a. No por cona, ante ngüi' na' no ante ñaa na' xal mbez di's ndxè' loo con' co' ngòca. ");
INSERT INTO zamNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Cona, ngue niin loo gu: Prob gu' izlyo'. Ngòc che'npe' gu' par yòo gu' loo cón che'n Diox par ñibe'pe' Diox loo gu'. Per nalle' Diox ne'tolode tyal no ne'tolode ta' Diox lugar loo gu' yòo gu' loo cón che'n Diox par ñibe'pe' Diox loo gu'. Ndxe'leque', Diox tyal no ta' Diox lugar loo mèn par yòo mèn loo cón che'n Diox par ñibe'pe' Diox loo mèn, mèn co' li co' ñibe'pe' Diox loo mèna xalque' mbli mèn co' mbli rolpe' uv che'n mbi' co' ngòc che'n xyòn lus uva. ");
INSERT INTO zamNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Le' cón che'n quèe, co' nee di's nacpe' daa na, mèn co' yixud loo quèea, co' nee di's, nden' mèna ngòc nguàal con' cón chenen, mèna lyux xal thìb yèt co' ayè'thax ndxàc co'se' ndlyé' yèt. Le' loo mèn co' lyàa quèea na, co' nee di's nac daa, daa telux mèna xal co'se' ndlé' ndoo quèe thìb con'. ");
INSERT INTO zamNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Co'se' mbìn mèn co' ngòc jef co' más mnibe' loo rye nguley' no mèn co' ngòc mèn xley' farise di's co' mtetac Jesús loo mèna, nazab ngulàa di'sa le'n lezo' mèna. Mden' mèna no mda' mèna cuent le' Jesús mtetac di's cón che'n mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Co'se' mbìn mèna di'sa, capas mèna tyenxù' mèna Jesús. Per nzyeb mèna ñèe mèna mèn co' nziri' no Jesús. Tac mèn co' nziri' no Jesús ante ndli xtùuz cón che'n Jesús le' Jesús ante ndyoodi's di's co' mnibe' Diox loo Jesús par tyoodi's Jesús di'sa. ");
INSERT INTO zamNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Mbere Jesús, mtetac Jesús di's loo mèn tedib vez. Ndxab Jesús loo mèn co' nziri' loo Jesús: ―Nde niin thìb con' loo gu': ");
INSERT INTO zamNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Diox co' ñibe' loo mèn nac xal thìb rey co' mbli thìb fandang che'n thìb xgan' rey co' mselya'. ");
INSERT INTO zamNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mtel' rey moz rey par ngua li moz convid mèn no par li moz avis loo mèn co' ngòc convid par yi'th lyath no mèn mbi' loo fandang che'n mbyòo co' mselya'a. Per mèn co' ngòc convida ne'ndalte ngui'th. ");
INSERT INTO zamNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mbere rey co' mbli nab fandanga, mtel' rey tedib cua' moz. Ndxab rey loo moz: Huàa gu' no guuz gu' loo mèn co' ngòc convida yi'th mèna fandang, le' rey ngolole' mbli nab con' hua mèn. Le' rey mbli mandad mbeth mèn ngon no taamas má' nacha'. No ryete con' hua mèna ya ngolole' ngòc nable'. Guuz gu' loo mèna li mèna purad yi'th mèna fandang co' nac yalhua. ");
INSERT INTO zamNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Per mèn co' ngua li moz convida, co' ngua lile' moz avis looa, ne'ndalte mèna ngui'th mèna. Ne' ne' ngli mèna cas di's co' ndxab moz. Chó mèna nda ta' vuelt loo xyòn mèna. Chó mèna nda loo rsin' mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Le' taamas mèn co' ne'ndalte nga fandang che'n mbyòo co' mselya'a na, mèna mxen moz rey. Ale mbli mèna ngòc nguàal con' con moz rey axta mbeth mèna moz rey. ");
INSERT INTO zamNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Co'se' gunèe rey tataa ngòc con'a, anze'f ngocloo tín' rey axta mtel' rey solndad rey par ngua yuth solndad mèn co' mbeth moz rey. Mtec solndad liz mèna no làaz mèna, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ngoloa, ndxab mbi' co' nac reya loo tedib cua' moz: Ryete con' ngolo ngòc nab co' nac che'n fandang par selya' mbyòo daa ndxè'. Huenque' mbli mèn co' ngòc convida ne'ngui'thte mèn. Tac inzyalte mèna no indxàalte mèna ngui'th mèna loo fandang na' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Más huen huàa gu'. Huàa tau' gu' loo rye mèn co' ñèe gu' riid rye ned. No guuz gu' loo mèna yi'th mèna loo fandang na' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Sya, ngro' moz. Ngua thop moz ryete mèn co' mzyál' moz, mèn co' ngòc mèn ndac no mèn co' ngòc mèn ye'rsin', par yi'th mèna fandang che'n mbyòo co' mselya'a. Mbi'thque' mèna axta mzyè le'n nyòo liz mbi', tant thìb mèn mbi'th. ");
INSERT INTO zamNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Sya, ngòo rey le'n nyòo. Xèe mbui' rey loo rye mèn co' mbi'th, mèn co' ngòc convida. Gunèe rey ndub thìb mbi' xi'th rye mèna. Per rey gunèe inocte mbi' xab mbi' co' ndxàal goc mèn co'se' ya mèn thìb fandang che'n thìb ned myen' co' nselya'. ");
INSERT INTO zamNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ndxab rey loo mbi'a: Amiu, ¿xá mod mblil ngòol trè' no inoctel xabl co' ndxàal ngocl par ngui'thl loo fandang che'n myen' co' nselya', à'? Per más quee lezo' mbi'a xèe mdub mbi'. Ne'ncàbte mbi' loo rey. ");
INSERT INTO zamNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Sya, ndxab mbi' co' ngòc reya loo moz mbi' co' ngue li mandad loo mes: Quedó' gu' ya' mbi' ba' no quedó' gu' nii mbi' ba'. No càa mbi' ba'. Blo' gu' par fuer loo yál'cuau. Tya gón' mbi' no hua le mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tataa mod ndli Diox, ne, par ndxòn huax mèn cón che'n Diox par yòo mèn loo cón che'n Diox par ñibe'pe' Diox loo mèn. Per ale ndxe'leque', ndxepte mèn nzo co' mdyal ngòo loo cón che'n Diox. Mèna ngòc mèn co' mcuipe' Diox par ñibe'pe' Diox loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ngolo mbìn mèn xley' farise di's co' ndxab Jesús, mxen mèna ned. Ndyàa mèna. Sya, thidte ngòc mèna. Mdoodi's no mèna xtàa mèna par gab mèna chol di's loo Jesús par bel'que' tataa mod li mèna par gàal di's mèn Jesús no tataa mod li mèna gan par quexù' que' fals mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Por lult, mtel' mèna ndxep mèn co' nqueltàa loo cón che'n xley' mèna con taandxep mèn co' ngòc thìb ned mèn co' ngro' lèe partid herodist loo Jesús par tyoodi's no mèna Jesús. Sya, ndxab mèna loo Jesús: ―Maistr, nu' non no naneeque' nu' le' U', lìcque, ndyoodi's co' nac di's lìcpe'. No lìcque' nac ned co' ndlu' U' par yòo mèn loo cón che'n Diox. Más de cona, nonque' nu' no naneeque nu' yende chó mport nzo lezo' U' con' co' mbez mèn loo U'. Ne' ne' indla's U' mèn par ñèe U' xal nac mod co' ndxàp mèn. Ne' ne' indla's U' xal ñaa mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Per nalle' gunee U' loo nu' ¿ché' tli huen ta' nu' tmi o quix nu' tmi cón che'n contribución loo mbi' co' nac gobiern co' ndub le'n ciuda Rom o ché' indxàalte quix nu'i? ¿Xáa nee U'? ");
INSERT INTO zamNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Per Jesús mden' lezo' no mda' Jesús cuent le' mèna asembli mcua'n mèna mod par gàal di's mèna Jesús par yigaa Jesús loo mèna. Sya, ndxab Jesús loo mèna: ―Aa mèn xley' farise, susque' ndxác gu' ntembìi gu' ro gu' no ntembìi gu' xti's gu' loon. ¿Chonon asendli gu' ncua'n gu' mod par gàal di's gu' daa par yigaa daa loo gu', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Blu' gu' thìb pes co' nguix gu' cón che'n contribución loon. Neene'. Sya, ngua xi mèna thìb pes par mblu' mèn pesa loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Co'se' gunèe Jesús pesa, mnibdi's Jesús loo mèna. Ndxab Jesús: ―¿Chó che'n gunab co' ngue loo pes ndxè' no chó che'n lèe co' ngue loo pes ndxè', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mèna mcàb loo Jesús. Ndxab mèna: ―Gunab ba' no lèe ba' nac che'n gobiern co' ñibe' yèe loo na'. Jesús ndxab loo mèna: ―Aa. Pues, fta' gu' con' co' nac che'npe' gobiern co' ñibe' loo gu' par càa gobiern che'n gobiern. No fta' gu' con' co' nac che'npe' Diox par càa Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Co'se' mbìn mèna tataa ndxab Jesús loo mèn, ante mbui' mèna no ante gunaa mèna cón che'n Jesús. Xexte mxen mèna ned. Ndyàa mèna. Taate mblá' mèna Jesús tya. ");
INSERT INTO zamNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Leque huiza ngua plá mèn co' ngòc mèn xley' saduce loo Jesús co'te' nzo Jesús par la's mèn cón ngue li Jesús. Mèna ngola's no mbez mèna: Pà ryo xban mèn. Yende chó mèn ryo xban. Tataa mod mdub nii mèna par aseli mèna ndxab mèna thìb con' loo Jesús par gàal di's mèna Jesús. Ndxab mèna: ");
INSERT INTO zamNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maistr, Moisés mtan' di's loo nu' chele' thìb mbi' co' mselya' nguth no ne'ndante xa'got mbi' xin' mbi', le' sya, hues mbi' selya' con xa'got viuda par que no xa'gota xin' mbi'. Sya, yòo cuent xin' mbi' nac mbed co' tyan xa'got viuda con hues ndlyo mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pues làth nu' ngo gaz mbi' co' ngòc hues. Mbi' ndlyoa mselya'. Làth xtau'a, tee yath mbi'. Per mbi' ne'ndante xin' con xa'got co' ngòc sa'l mbi', ¿lé'? Mbyan' xa'gota viud. Ndoole' hues mbi' co' nde nque xís mbi' mcàaya' xa'got viuda. ");
INSERT INTO zamNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Lomisque', nguth mbi'a. Ngoloa, mbyan' xa'gota viud tedib vez. Ndoole' tedib hues mbi' co' nde nquea tee càaya' xa'gota. Lomisque', nguthguè' mbi'a, ne. Lomisque', ngòca loo taamas myen' axta nguth rye gaz hues myen'a. ");
INSERT INTO zamNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ngolo nguth rye gaz hues myen'a, tee yath xa'gota, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nalle' gunee loo nu', co'se' ryo xban rye hues myen' co' ngutha, ¿chó myen' gàc sa'lpe' xa'gota por mque no xa'gota rye gaz hues myen', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús mcàb loo mèna. Ndxab Jesús: ―Aa, que tont gu'se. Thidtene ncuau lezo' gu', ndee. Nazab ndli gu' xtùuz. No inalìde ngue li gu' xtùuz. Tatua' ndli gu' xtùuz tac inda'de gu' cuent co' huenleque' di's co' ndub loo libr co' nac xti's Diox. Ne' ne' inda' gu' cuent co' nac con' roo no con' xèn co' ndxàp Diox la's nii Diox no la's ya' Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tac co'se' gàc huiz co' ryo xban mèn nguth, mèn co' ngòo loo cón che'n Diox, huiza ya ne'berede mèna, selya' mèna tedib vez. Huiza no tiempa gàc mèna xal angl che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Per cón che'n xal ndli gu' xtùuz no xal mbez gu' le' mèn co' nguth ne'ryo xbante, ¿ché' tarte lab gu' di's co' ndub loo libr co' nac xti's Diox co' gunii yub Diox loo mèn póla, cà'? Diox ndxab taandxè': ");
INSERT INTO zamNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","―Daa nac Diox che'n xudgool gu' Abraham, Isaac, no Cob. Hui' gu' nexa. Yende mod gàc Diox Diox che'n mèn co' ndxelo ndxelux co'se' ñeei loo mèn. Por cona, non na' le' Abraham no Isaac no Cob naban co'te' ndyàa xa' tac Diox mbez nac Diox Diox che'n xa'a. ");
INSERT INTO zamNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Co'se' ngolo mbìn mèn co' ngureri' tataa ndxab Jesús, ryete mèn ante mbui' no ante gunaa xal ngòc di's co' mblu' Jesús loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Co'se' mbìn mèn xley' farise le' Jesús mbli gan par ya ne'tolode ndoodi's mèn xley' saduce con Jesús, mbere mèn xley' farise, mqueltàa mèn xley' farise tedib vez loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sya, thìb mbi' co' ngòc mèn xley' farise co' ngòc maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn tiempa nzo xi'th mèna. Mbi' mblya's ngàal di's mbi' Jesús par ñee mbi' ñeene' ché' tagaa Jesús loo mbi' con di's co' càb Jesús. Mnibdi's mbi' loo Jesús. Ndxab mbi': ");
INSERT INTO zamNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maistr, ¿chó di's nac di's co' más ntac co' ñibe' loo ley co' mxo'f Moisés loo mèn, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús ndxab loo mbi' co' ngòc maistra: ―Di'sa nac di's co' mbez: Fque' lezo' gu' Tad Diox gu' dib nzo yéc gu', no dib nzo lezo' gu', no dib nzo xtùuz gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Di'sa nac ner di's co' mtan' Diox loo mèn loo ley co' mxo'f Moisés loo mèn. No nac di'sa di's co' más ntac no co' más ñibe' loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Le' di's co' nac mbryop di's co' nde nque loo ner di'sa na, lalque' nac xal ner di'sa. No mbez di's ndxè' loo mèn: Fque' lezo' gu' gunèe gu' hues xtàa gu' xalque' co'se' leque gu' ngue lezo' ñèe gu' gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ryop di's co' taandxè' mbez no co' ndlu' loo mèn, ryop di's ndxè' nac di's co' mnibe' Diox loo Moisés par mbyan' di's ndxè' loo ley co' mxo'f Moisés loo mèn. Lomisque' nac di's ndxè' con di's co' gunii Diox loo mèn co' mde'th di's co' ndxab Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Láth be' nziri' mèn co' nac xley' farise loo Jesús, ");
INSERT INTO zamNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús mnibdi's loo mèna. Ndxab Jesús: ―¿Xá nee gu'? ¿Cón ndli gu' xtùuz cón che'n Crist? ¿Chó xin nac Crist, à'? Mèna mcàb. Ndxab mèna loo Jesús: ―Crist nac xgan' David co' ngòc rey póla. ");
INSERT INTO zamNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sya, ndxab Jesús loo mèna: ―Chele' Crist nac xgan' David, ¿chonon ndxab David por cón che'n Xpii Natú' che'n Diox le' Crist nac yub Tad che'n David, sya? Tac David ndxab: ");
INSERT INTO zamNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tad Diox ndxab loo Tad daa: Ftub cuaten axtaque' lin le' ryete mèn co' nac mèn ngolo ngola's che'nl gàc nado' lool. ");
INSERT INTO zamNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Xá mod ndli gu' cuent nac Crist xgan' David co'se' leque yub David mbez: Tad daa, loo Crist, sya? ¿Máa yob yéc gu', na? ");
INSERT INTO zamNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yende chó mèna ngác ncàb nec thìb di's loo Jesús. No desde huiza par delant nec thìb mèna ne'tolode ngli ryes ñibdi's mèna taamas con' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sya, ndxab Jesús loo mèn co' ngureri' loo Jesús no loo myen' xin' mté'th Jesús: ");
INSERT INTO zamNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Le' maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn nación Israel no mèn xley' farise, anze'f ndli ryop ned mèn ba' cuent le' mèna ngue no zin' co' nac zin' co' ndlu' mèn cón che'n ley co' mxo'f Moisés loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Cona, ngue niin loo gu': Ftubdi's gu' loo di's co' mbez mèn ba'. No bli gu' co' ñibe' mèna. Per ne'que tee lide gu' xal nac mod co' ndxàp mèn ba'. Tac mèna ñibe' loo mèn li mèn thìb con'. No leque mèna indlide con' xal ñibe' mèna li taamas mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nde niin tedib con' loo gu': Co'se' ndli mèn ba' tataa, ndli mèna xal co'se' ntecue mèn thìb yó' xís xtàa mèn, yó' co' ne'xecte mèn hue' mèn. No ñibe' yèe mèna loo prob xtàa mèn par hue' mèna yó'. Per mèn ba', nec thìb mod no nec tedib mod ne'tyalte mèn no ne' ne' li mèn xtùuz teche mèn nec thìb yalnibe' bix co' indubte loo ley co' ngue no mèn loo xtàa mèn co' nac ley co' mnibe' Diox mxo'f Moisés loo mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Asendli mèn ba' ryete con' co' nac mod co' ndxàp mèn ba' par hui' mèn no ñaa mèn loo mèn ba'. Anze'f ndyubla's mèn farise ba', no mèn co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, hue' mèn di's co' nac ndxep di's che'n xti's Diox loo thìb le' ye's lechuz mèn no co'te' nac bél'cha' ya' mèn. No anze'f ndyubla's mèn ba' goc mèn ba' xab mèn co' nac lar' co' ndoo flec co' nac xab mèn más nol' no flec más nol' leque co' ndli taamas mèn us. ");
INSERT INTO zamNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ale ndubla's yèe mèn ba' tyub mèn ba' co'te' más huen par tyu' mèn ba' co'te' ndxàc chol yalhua. No ndubla's yèe mèn ba' tyub mèn ba' co'te' gàc gab chol mèn cón che'n mèn ba': Susque' mèn guryath no mèn guryèn nac mèn ba' le'n sinagog. ");
INSERT INTO zamNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","No anze'f ndubla's yèe mèn ba' ñii chol mèn Diox loo mèn ba' pál co'te' nzyál' mèn mèn ba' no por fuerz gàp mèn mod ñèe mèn mèn ba' co'se' zyál' mèn mèn ba'. No anze'f ndubla's yèe mèn ba' gab chol mèn: San, Maistr, loo mèn ba' pál co'te' nzyál' mèn ba' chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Per ndxe'leque', part cón che'n gu', ne'ta'de gu' lugar ñee chol mèn Maistr loo gu'. Tac thidte mbi' co' nac merpe' Maistr nzo. Mbi'a nac Crist, co' nee di's, nac yub daa. Le' rye gu' na, ndxàc hues por cón che'n Maistr gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ne' ne' gab gu': Pay, loo nec thìb mèn co' nziri' loo izlyo'. Tac ante thidte Xud gu' ngue no gu'. Xud gu'a nzo loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ne' ne' ta' gu' lugar ñee chol mèn loo gu' le' gu' nac jef. Tac angoluxte Crist nac jef che'npe' gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Le' gu' co' ndli mandad loo hues xtàa gu' na, gu'a nac más xa' roo no xà' xèn làth xtàa gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tac gu' co' ndli cuent no ndlu' gu' loo xtàa gu' le' gu' nac más mèn roo no mèn xèn làth xtàa gu', loo gu'a Diox li gàc gu' mèn be'the yiloa. Le' gu' co' nac mèn nado' no mèn be'the làth xtàa gu', loo gu'a Diox li par gàc gu' mèn roo no mèn xèn làth xtàa gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Mbere Jesús, ndxab Jesús loo mèn co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn no loo mèn xley' farise: ―Ay, prob gu' izlyo', gu' co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn. Lomisque' ne, gu', mèn xley' farise. Ay, prob gu' izlyo'. Aa que ndxác gu' ntembìi gu' ro gu' no ntembìi gu' xti's gu' loon. Tac gu' ncà no nca' gu' loo mèn par ne'yòode mèn loo cón che'n Diox par ñibe'pe' Diox loo mèn. Ne' ne' tyal gu' no ne' ne' ta' gu' lugar par ñibe'pe' Diox loo gu'. Ne' ne' ndla' gu' yòo mèn co' ndyal yòo loo cón che'n Diox par ñibe'pe' Diox loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ay, prob gu' izlyo', gu' co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn. Lomisque' gu' ne, mèn xley' farise. Prob gu' izlyo'. Aa que ndxác gu' ntembìi gu' ro gu' no ntembìi gu' xti's gu' loon. Ale ndyac gu' con' huen co' ngue li gu'. Tac por thìb con' co' iñaade ndyenxù' gu' no ndxàc che'n gu' liz prob mèngot viud. No par ndli gu' xal mèn co' ne'ñeede no mèn co' inda'de cuent cón li mèn, ale asendli gu' ngol' gu' xley' gu' co'se' mbez gu' Diox. Por con' co' ndli gu'a, más nayi' tín' gàc Diox loo gu' par tetìi Diox gu' yiloa. ");
INSERT INTO zamNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Tedib vez niin loo gu': Ay, prob gu' izlyo', gu' co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn. Lomisque' gu' ne, mèn xley' farise: Ay, prob gu' izlyo'. Aa que ndxác gu' ntembìi gu' ro gu' no ntembìi gu' xti's gu' loon. Ale ndyac gu' con' huen nac co' ngue li gu'. Gu' nque tee cua'n mèn loo izlyo' no loo níttó' par mbli gu' mse' mèna mod co' ngòp mèn par yila's mèna loo xley' gu' xalque' ndxela's gu' loo xley' gu' par gàc mèna thidte mèn con gu'. No co'se' ngolo mbli gu' gan par gàc mèna thidte mèn con gu' no ngòo mèna loo xley' gu', ndli gu' par ndxàc loo mèna chop cua' con' ye'rsin'túb leque loo gu' par thìb lìte yòo prob mèna le'n ye'rbìil co'te' nac loo quìi no loo bèel. ");
INSERT INTO zamNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ay, prob gu' izlyo', gu' co' nac xal mèn sieu co' ndyoo ner loo mèn. Gu' mbez: Chele' chol mèn càbgòn thìb con', lugar de te'th mèn lèe Diox mbez mèn: Por lèe templ ba' lina. Sya, mbez gu': Indlide arid precis li lùu co' ndxab lùu li lùu por mdeth lùu lèe templ ba'. Per ndxe'leque', mbez gu': Chele' mèn gab: Lina o gàca loon por mde'th mèn or co' nacsua' templ ba', sya, mbez gu': Syase, ndlique' precis li gu' con' co' ndxab gu' li gu' loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Susque' tont gu'. No susque' nac gu' xal mèn sieu co' nau' loo no co' nau' yéc. ¿Cón ndli gu' cuent nac con' más ntac, à'? ¿Ché' ndli gu' cuent más ntac or o más ntac templ co' ndli ndxàc natú' ora, cà'? Yende xàa. Más ntac templ, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Lomisque', mbez gu' loo mèn, ne: Chele' chol mèn càbgòn li mèn thìb con' o gàc thìb con' loo mèn, chele' mèna gab: Gàca o lina xalque' nac loo còo' le'n templ ba', le' sya, gu' mbez: Inquinte arid li gu' co' mde'th gu' xal nac loo còo' le'n templ ba'. Lomisque', más mbez gu': Chele' mèn te'th li mèn thìb con' o gàc thìb con' loo mèn, no te'th mèn por cón che'n gòn co' mbec mèn loo còo' le'n templ, sya, mbez gu': Syase, por fuerz gàcque' o li gu' con' co' mcàbgòn gu' loo mèn li gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Susque' tont gu'se. No susque' nac gu' xal mèn sieu co' nau' loo nau' yéc. ¿Cón ndli gu' cuent más ntac, à'? ¿Ché' ndli gu' cuent más ntac gòn co' mbec gu' loo mes co' mbez gu' nac loo còo' o ché' ndli gu' cuent más ntac con' co' nzi'f gu' loo còo' leque más natú' nac còo' co' ndli ndxàc natú' con' loo Diox, cà'? Yende xàa. Más ntac loo còo', ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tac mèn co' nde'th di's co' nac cón che'n loo còo', ingue te'thte mèna di's ante co' nac cón che'n loo còo'. Ndxe'leque', mèna ngue te'th di's co' nac lèe ryethe con' co' nzi'f loo còo', ne. ");
INSERT INTO zamNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Le' mèn co' nde'th di's co' nac lèe templ na, ingue te'thte mèna ante lèe templ. Ndxe'leque', ngue te'th mèna di's co' nac lèe Diox tac Diox nzo le'n templ, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Lomisque', mèn co' nde'th di's co' nac lèe bé', mèna ngue te'th di's co' nac lèe co'te' nzo Diox. No ngue te'th mèn lèe merpe' Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Lomisque', ndxab Jesús loo mèna: ―Ay, gu' co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn no gu' co' nac mèn xley' farise. ¡Prob gu' izlyo'! Susque' ndxác gu' ntembìi gu' ro gu' no ntembìi gu' xti's gu'. Ale, ngo' gu' si' si' centav loo thìb thìb pes co' nac che'n con' nayèe co' ntho' gu' co' nac fthyoxtil, no anís, no comin. Per ale ndxe'leque', indlide gu' cas cón che'n di's co' nac di's co' ñibe' loo ley co' mxo'f Moisés loo mèn, co' nee di's, gàc gu' mèn nalì no mèn nambìi loo Diox no gàc gu' mèn co' ndlyat lezo' ñèe xtàa no gàc gu' mèn co', lìcque', ndxàp yalxla's no co', lìcque', ndxela's loo Diox. Lìcque, ndxàalque' ta' gu' diezm loo con' ndli gu' gan co'se' ntho' gu' con'. Per más ndxàal li gu' par gàc gu' mèn nalì no mèn nambìi loo Diox, no gàc gu' mèn co' ndlyat lezo' ñèe xtàa, no gàc gu' mèn co' ndxela's loo Diox no co' ndxàp yalxla's loo Diox. Per gu' indlide con'a, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ay, prob gu' izlyo', gu' co' ndyoo ner loo taamas mèn loo cón che'n Diox, gu', co' nee di's, nac xal mèn sieu co' ndyoo ner loo taamas mèn co' nac xal mèn sieu. Loo cón che'n Diox ndli gu' cuent anze'f mèn nambìi nac gu' no mèn nalì nac gu' loo Diox. Per ale ndxe'leque', loo cón che'n Diox nac gu' xal mèn co' nzib thìb taz café co'se' ndlyàa thìb ngru's chu'th le'n café par gu gu' café. Per ne'ta'de gu' cuent le' loo cón che'n Diox nac gu' xal mèn co' ngueb thìb camell, co' nee di's, nzo le'n taz café co' ngue yu gu'. Per con' co' ndli gu' ba' nee di's ale más ndxòo yéc gu' ndli gu' con' co' intacte arid loo Diox. Ale ndxe'leque', indlide gu' cas no ingüinte gu' arid par li gu' con' co' más ntac loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ay, prob gu' izlyo', gu' co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn no gu' co' nac mèn xley' farise. Susque' ndxác gu' ntembìi gu' ro gu' no ntembìi gu' xti's gu'. Loo cón che'n Diox, ndlu' gu' gu' loo mèn le' gu' nac mèn nambìi no mèn nalì loo Diox. Per le'n lezo' gu' no le'n xtùuz gu' nzo huax con' ye'rsin'túb por mod co' ndxàp gu' tac gu' ndli huan' mèn. No nqueli'th gu' cón che'n taamas mèn. No ndxan lezo' gu' ñèe gu' cón che'n taamas mèn. Cona, ngue niin loo gu': Nac gu' xal plat no taz co' ante ntech mèn par xís. Per par le'na taate nazab ñaa. ");
INSERT INTO zamNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Aa, mèn xley' farise. Susque' nau' loo nau' yéc gu' loo cón che'n Diox. Más huen blo yéc gu' no blo lezo' gu' par tembìi gu' xtùuz gu' no teche gu' ryethe mod ye'rsin' co' ndxàp gu' le'n xtùuz gu' no le'n lezo' gu' no mod ye'rsin' co' ndxàp gu' loo mèn. Le' sya, tataa mod se' gu' mod co' ndxàp gu' par, lìcque', gàc gu' mèn nalì no mèn nambìi loo Diox xal co'se' tech mèn par le'n taz no plat par nambìi gàca. ");
INSERT INTO zamNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ay, prob gu' izlyo', gu' co' nac maistr co' ndlu' cón che'n ley loo mèn no gu' co' nac mèn xley' farise. Susque' ndxác gu' ntembìi gu' ro gu' no ntembìi gu' xti's gu'. Gu' lalque' nac xal bá' che'n thìb mèn nguth, co' ante nabe's natoxcua', co' ante nagus bèeleque' ñaa par xís. Per par ned le'n bá' anze'f nazab ndlya' no anze'f thìb zith che'n mèn nguth nzo. ");
INSERT INTO zamNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tataaque' nac gu', mèn xley' farise tac gu' ndlu' gu' loo mèn anze'f mèn ndac nac gu'. Tataa ndli gu' par ndxác gu' ntembìi gu' ro gu' no ntembìi gu' xti's gu' loo mèn par indlu'de gu' ndli gu' chó con' ye'rsin' co' ndli gu' loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ay, prob gu' izlyo', gu' co' nac maistr loo mèn, gu' co' ndlu' di's co' nac ley co' mxo'f Moisés loo mèn. Ay, prob gu' izlyo', mèn xley' farise. Susque' ndxác gu' ntembìi gu' ro gu' no ntembìi gu' xti's gu'. Tac gu' mbli mandad mtoxcua' mèn armit che'n mèn co' mde'th di's co' ndxab Diox, co' nguth póla. No nabe's mtoxcua' gu' co'te' ndoo gunab co' nac monument co' nac xin no xnaa che'n mèn co' mbez gu' ngòc mèn ndac. ");
INSERT INTO zamNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","No nabe'ste ntoxcua' gu' yalgutyè'. Mbez gu': Chele' na' ngo ban le'n tiemp co' mban xudgool na', ne'nqueltàa node na' xudgool na' par nguth na' mèn co' mde'th di's co' ndxab Diox con xudgool na', ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Por di's co' mbez gu' no por di's co' ndyoodi's gu', leque gu' ngue go xo'f co' mbli gu' no nda' gu' cuent nac gu' bin mèn co' mbeth mèn co' mde'th di's co' ndxab Diox. Cona, ngue niin loo gu': Leque co'te' mdoo nii xud gu' no leque co'te' mdoo ya' xud gu', leque tya tyoo nii gu' no leque tya tyoo ya' gu', ne. ¿Cón más ndlya's gu' ñee gu' loon? ");
INSERT INTO zamNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Cona, ngue niin loo gu': Ftolo bli gu' con' xal mbli xudgool gu' póla. Ftolo guth gu' taamas mèn co' nde'th di's co' ndxab Diox. Yiloa nee gu' cón che'n gu' co'se' tub rez Diox cón che'n gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Aa, mèn co' nac xal mbel' co' lèe huid. ¿Xá mod gác gu' lyá' gu' loo yaltìi tín' co' gàc loo gu' co'se' tetìi Diox gu' le'n ye'rbìil co'te' nzo quìi no bèel? ¡Pà lyá' gu'! ");
INSERT INTO zamNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Por cona, na ngue nii loo gu': Na tel' huax mèn làth gu'. Ndxep mèna gàc mèn co' te'th di's co' ndxab Diox loo gu'. Taandxep mèn gàc mèn co' ndxác cón che'n Diox. Taandxep mèn gàc mèn co' lya's lu' loo gu' cón che'n Diox co' nac con' lìcpe' par ta' gu' cuent cón che'n Diox. Per ale ndxe'leque', guth gu' ndxep mèna. Taandxep mèna que' gu' loo thìb cruz. No ta' gu' che'n taandxep mèna le'n sinagog gu'. No tyoo nque gu' xís taandxep mèna le'n thìb yèez no le'n tedib yèez axtaque' li gu' con' ndlya's gu' con mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Por cona, con' ye'rsin' co' nde teele' ndli gu' con rye mèn co' tel'en loo gu' li par yan' cón che'n gu' loo Diox por cón che'n rye mèn co' ngòc mèn ndac co' mbethxù' xudgool gu' póla no co' mbethxù' gu' le'n tiemp ndxè'. Tac anon co'se' mbethxù' thìb mbi' co' ngòc xudgool gu' Abel co' ngòc thìb mbi' nambìi no thìb mbi' nalì loo Diox, mtlo mbethxù' xudgool gu' taamas mèn desde huiza no axta tiemp co'se' mbethxù' xudgool gu' Zacari, xgan' Berequi, co' mbeth xudgool gu' le'n templ co'te' ndoo mes co'te' mbec mèn gòn o ofrend loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Lìcque' nac di's co' ngue niin loo gu' ndxè': Dol no yalnquexù' co' ngòc cón che'n rye mèn co' mbethxù' prob mèna yizi'f no yiga's loo gu' co' naban tiemp ndxè' par tetìi tín' Diox gu' axta plóthe yiloa. ");
INSERT INTO zamNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ay, prob gu' izlyo', mèn ciuda Jerusalén, gu' co' mbeth mèn co' mde'th di's co' ndxab Diox, gu' co' mbuaa'd quèe mèn co' mtel' Diox co' mbi'th lo yalbàn loo gu'. Anze'f mblyazen nqueltàan gu' loon xal ndli nguiiddol colec con nguiid yèn' co'se' ngue's nguiiddol colec nguiid yèn' xan' xíl' nguiiddol colec. Per gu' ne'ndalte thidtene no ne'nda'de gu' lugar par ngàca tataa loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Per nalle' hui' gu' nexa. Nase thidtene mblá'ya' Diox gu' liz gu' no làaz gu'. Nee gu' cón che'n gu' nalle'. ");
INSERT INTO zamNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tac daa ngue nii loo gu': Gu' ya ne'berede hui' loon le'n tiemp ndxè'. Gu' bereque' hui' loon per axta co'se' gàc tiemp co'se' ñeepe' gu' no co'se' gab gu' loo Diox: Anze'f mbi' huen no anze'f mbi' ndac nac mbi' co' nde ba' tedib vez, Tad Diox. U' mtel' mbi'. Nde mbi'. Axta syare', hui' gu' loon tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ngolo mdoodi's Jesús rye di'sa loo mèn ciuda Jerusalén, ngro' Jesús le'n templ. Le'pe' tyen Jesús ned bii Jesús, mbii gax myen' xin' mté'th Jesús loo Jesús. Látha, nzi tee yot myen'. Xèe ngüi' myen' loo templ. Mbez myen' loo Jesús: Tad, susque' nabe's ñaa templ ndxè' no susque' naroo templ ndxè', cara. ");
INSERT INTO zamNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Per ale le'le' mcàb Jesús. Ndxab Jesús loo myen': ―¿Ché' nzi tee yot gu', ngüi' gu' loo templ ndxè' no ndli gu' xtùuz cón che'n templ ndxè', ne, cà'? Per hui' gu' nexa. Lìcque' nac di's co' nde niin loo gu' ndxè': Desde nalle' par delant, nde zin' gaxle' le' mèn sil templ ndxè'. No ya ne'hui'de gu' nec thìb quèe loo ftoo ndxè'. Thidtene telux mèn templ ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ngoloa, mxen Jesús ned. Nda no Jesús myen' xin' mté'th Jesús loo thìb yii co' lèe yii che'n yaa oliv. Co'se' ñee myen' ndub Jesús tya, mbii gax myen' xin' mté'th Jesús loo Jesús. Xexte ndxab myen' loo Jesús: ―Tad, nu' ndlya's ñee U' loo nu' ¿pól gàc co' nee U' loo nu' gozea cón che'n templ ba' no chó señ yú' loo mèn co'se' gàc huiz co'se' bere U', yi'th U' loo izlyo' ndxè' tedib vez no co'se' gàc huiz lyux no lith no izlyo', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sya, ndxab Jesús loo myen': ―Chó Diox chó nee gu'. Ne'ta'de gu' lugar quedìi chol mèn gu' cón che'n con' niin loo gu' nalle', ndee gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tac anze'f huax mèn nare' gáal loo izlyo' no que tee te'th mèna cón che'n lèen. No gab mèn no que tee te'th mèna loo mèn: Daa nac Crist. Le' sya, tataa mod anze'f huax mèn quedìi mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Huiza gòn gu' tyoodi's mèn cón che'n xó'. No tyoodi's mèn cón che'n con' ryes co' ndxàc cón che'n xó'. Per nalle' niin loo gu': Thidtene ne'zyebte gu' co'se' gàc huiz no tiemp co'se' gòn gu' di's co' tataa ta' mèn cuent loo gu'. Tac naquinque' tataa gàca. Per mastale' tataaque' gàca le'n huiza, tarte gàc tiemp co'se' lyux no lith no izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Sya, gàc huiz tel' mèn che'n thìb nación solndad che'n mèn nación par yoo mèna con mèn co' nac tedib nación. Lomisque' ne, li mèn thìb nación xó' con mèn co' nac tedib nación. Huiza o tiempa, por derech, lyàa huin loo izlyo'. Lyàa yilíiz. Huin xòo huax lugar loo izlyo', ne. ");
INSERT INTO zamNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Per pente tlo gàc rye con'a par ten' mèn no ta' mèn cuent le' mèn tolo tyactìi par delant co' nac más con' tín' co' nde nque co' gàc loo co' ngue niin loo gu' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Láth ndxàc rye con'a le'n tiempa, mèn tyenxù' gu' no ta' mèn gu' loo xtàa mèn par li no mèn gu' chol con' ye'rsin' xal ndlya's mèna axta guth mèna gu'. Tiempa, mèn dib athu loo izlyo' yòo xyàn lezo' ñèe mèna gu' ante por cón chenen no maste. ");
INSERT INTO zamNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Le'n huiza no le'n tiempa, anze'f thìb mèn ryo xà' loo cón chenen. Ya ne'tolode yila's mèna loon. Le' sya, leque mèn co' ngro xà' loo cón chenen, leque mèna ta'xù' mèn co' ndxela's loon loo mèn co' nac mèn ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Le'n huiza anze'f huax mèn gutyè' ryo xo'f loo mèn. Ta' mèna cuent no te'th mèna loo chol mèn le' mèna ngro' tee par tyoodi's mèna cón che'n Diox loo mèn. Tataa mod anze'f huax mèn quedìi mèna, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Láth ndxàc con'a, anze'f huax con' ye'rsin' gàc loo mèn. Anze'f huax mèn ya ne'que'de lezo' mèn ñèe mèn xtàa mèn. Ndxe'leque', yòo xyàn lezo' mèn ñèe mèn xtàa mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Per mèn co' thidtene mbli nèe lezo' no mbli nèe yéc par tolo queltàa mèna loo cón chenen axta gath mèna, mèna mblyá'que' loo con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Le' cón che'n di's ndac co' ndlu' xá mod ndlya's Diox ñibe'pe' Diox loo mèn na, yath yèn no co mèn yalbàn cón che'n di's ndac loo mèn rye nación co' nziri' dib athu loo izlyo' par de que ryete mèn naciona gòn cón che'n di's ndac no ta' mèna cuent cón che'n di's ndaca. Yiloa, syase lyux no lith no izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Gu' co' ndlab ye's, bìn gu' di's co' ngue niin loo gu' ndxè' no fta' gu' cuent cón nee di's ndxè' no ften' gu' cón nee di's ndxè'. Mbi' co' ngro' lèe Daniel co' mde'th di's co' ndxab Diox, Daniel mque' ye's loo libr co' nac xti's Diox cón che'n thìb mbi' zab thìb mbi' cap. Mbi'a aseli teza' mbi' cón che'n chol con' co' nac cón che'n Diox. Co'se' ñèe gu' ndxàc con' ndxè' le'n templ che'n Diox, non gu' no nanee gu' ndxàcla xal mque' Daniel ye's. ");
INSERT INTO zamNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Sya, huen gàca loo mèn chele' mèn co' nzo le'n yèezya' co' nac làaz mèn jude xyon' par co'te' ndub yii par ne'gàcte yaltìi co' gàcque' loo gu', gu' co' nac mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Huen gàc loo mèn co' nzi yéc zote liz mèn chele' mèna, texal bilàa mèna yéc zotea, sangxyon' mèn no yende chó mport nzo lezo' mèn rye che'n mèn co' ndxàp mèn le'n nyòo par ne'yigaade mèna loo yaltìi co' gàcque' loo gu', mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Lomisque' ne, mèn co' ngue zin' huan huiza, huen gàca loo mèna chele' mèna ne'ye'thte liz mèn huiza par co' mèn rye che'n mèn co' ndxàp mèn par ne'yigaade mèna loo yaltìi co' gàcque' loo gu', mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ay, prob rye mèngot izlyo', mèngot co' nzi nac xin' huiza. No ay, prob rye mèngot izlyo', mèngot co' nzi xèn' xin' huiza por cón che'n yaltìi co' gàc loo gu', mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gurez gu' Diox no bna'b gu' loo Diox le' tiemp co' xyon' mèn loo con' ryes no loo yaltìi co' gàc huiza par ne'gàcte tiempa tiemp xìl' no ne' ne' gàc huiz co' xyon' mèn huiz descans. ");
INSERT INTO zamNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tac co'se' gàc ryethe con'a, huiza anze'f thìb yaltìi tín' gàc le'n huiza loo mèn nación Israel. Yaltìi co' gàc loo mèna tarte gàc dib lal mblec Diox izlyo' no mxèn' Diox izlyo'. No yiloa, thidtene ya ne'berede yaltìi tín'a gàc yaltìi tín'a tedib vez xal gàc yaltìi tín'a huiza loo mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","No chele' Diox ne'tedópte huiz tiempa, yende mod lyá' nec thìb mèn. Per ndxe'leque', Diox tedóp huiz tiempa por nque' lezo' Diox ñèe Diox mèn, mèn co' Diox mcui, mèn co' Diox mblo xà' par ngòo mèna loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Le' sya, chele' chol mèn ñee loo gu': Hui' gu' nexa. Trè' nzo Crist; o chele' mèn ñee loo gu': Tua' nzo Crist, ne'yila'ste gu'i, ndee gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tac co'se' gàc huiza, anze'f huax mèn gutyè' ryo' no ryo xo'f mèna loo mèn. Nee mèna loo mèn le' mèna nac Crist. No ñee mèna loo mèn le' mèna nde'th di's co' gunii Diox. No li mèna huax yalguyze' roo no yalguzye' xèn co' nac señ co' hui' mèn no co' ñaa mèn. Per ryethe con' co' ñee mèna no co' li mèna nac yalgutyè'túb. No axta quedìi mèna mèn co' ndxela's chele' mèna gác li mèna gan quedìi mèna mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Hui' gu' nexa. Fte' lezo' gu' le' daa guniile' con' ndxè' loo gu' ndoore' gàca loo gu', ndee gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Cona, beren, ngue niina loo gu': Chele' mèna ñee loo gu': Hui' gu' nexa. Crist nzo co'te' nagán, ne'yade gu' tya. No chele' mèna ñee loo gu': Hui' gu' nexa. Crist nzo le'n cuart ndxè', ne'yila'ste gu' con' co' ñee mèna loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tac co'se' gàc huiz co' galen, daa co' mbal yáal loo izlyo' ndxè' xal ndxáal chol mèn, setilte gàca xal co'se' ndlyàa bèel gundi co'se' ndxú' izlyo' par ned ndlyen huiz no par ned mbix huiz. ");
INSERT INTO zamNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Cón che'n mèn gutyè' co' ngue tan cuent loo gu' nalle' nac xal co'te' nax thìb má' ya's co'te' ndlyàa ngool loo má' ya's par hua ngool bél' má' ya'sa. ");
INSERT INTO zamNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Co'se' yilo riid rye huiz co' gàc rye yalnaxia loo mèn, tlo cuau loo huiz. Ne'tenìide huiz loo izlyo'. Lomisque' ne, ne'tenìide mbe' loo izlyo'. Le' mbyáaz co' nzi'f loo bé' na, tlo huin loo bé' axta tlo gàb che mbyáaz loo bé'. No ryethe con' co' nac con' roo no con' xèn loo bé' tlo huin no xi'th loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yiloa, axta syare' hui' gu' no yú' thìb señ co' gàc cón chenen, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo'. Le' mèn co' naban dib athu loo izlyo' na, mèna gón' co'se' hui' mèna loon, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo'. Con'a gàc loo mèn co'se' galen le'n xcuau co'se' gàpen rye loothe con' roo no con' xèn la's niin no la's yan. No hui' mèna co'se' gàc con' roo con' xèn loon. ");
INSERT INTO zamNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nibe'en loo angl huiza par cabii cuez angl trompet par thop angl rye mèn co' naban dyap lad loo izlyo', co' nee di's, nac thìb lad ro izlyo' axta tedib lad ro izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Bli gu' xtùuz cón che'n thìb di's co' nde niin loo gu' co' ndlu' cón che'n yaa ngudyuug: Hui' gu' nexa. Co'se' ngolole' ngòb laa loo yaa ngudyuug no nde xiisle' laa yen' loo yaa ngudyuug, gu' nonque' no nda'que' gu' cuent nde zin' gaxle' tiemp co' nac tiemp bée co'se' más ndxàc ney' loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Lomisque' nac con' co' ngue niin loo gu': Co'se' ñèe gu' ndxàc ryete con'a, gu' nonque' no naneeque' gu' nde zin' gaxle' tiemp co' lyux izlyo' no lith no izlyo'. Setilte gàc con'a xal thìb mbi' co' ndoo ro ryo' liz mbi' par yòo mbi' liz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Lìcpe' ba'i, na nii loo gu': Ryete con'a gàcque' ndoore' lyux mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ryethe con' co' nac cón che'n bé' no ryethe co' nac cón che'n izlyo', le'i lyuxque' no lith noi. Ya ne'tolode cue ryethe con'a. Per di's co' ngue niin loo gu' ndxè', di's ndxè' tyaaque', no gàcque', no tyubque' di's cón che'n di's co' ngue niin loo gu' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Per co'se' gàc huiza no co'se' gàcpe' hora, yende chó mèn izlyo' non chó huiz gàca no coyor gàca. Ne' ne' yub angl co' nzo loo bé', ne' ne' yub daa co' nac xgan'pe' Diox, nanee coyor gàc con'a. Angoluxte Diox co' nac xuden nanee coyor gàc con'a. ");
INSERT INTO zamNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Gàcque' con'a xalque' ngòca co'se' ngulàa yuuloo tiemp co'se' ngo ban thìb mbi' co' ngro' lèe Noé. Tataa gàca co'se' galen, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Le'n tiemp co' ngo ban Noea no ndoore' lyàa yuuloo co' ngulàa, le'n tiempa mèn alithe ndxuhua no alithe ndxu mèn loo izlyo'. Ngure selya' mèn. Nda' mèn rsap mèn par nselya' rsap mèn le'n rye tiempa axta ngòo Noé le'n yòoyaa. ");
INSERT INTO zamNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","No axta ne' ne' inon mèn no ne' ne' inda' mèn cuent le' yuuloo lyàaque'. Ante co'se' mbyà'x xnìi lezo' mèn le' yuuloo mtlole' ndoo làa. Axta syare', ne' ne' ñee mèn cón li mèn. Ale mbeth yuuloo rye mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Le'pe' co'se' gàc huiz co' galena na, chop xa'bi' que zin' loo rsin' xa' huan. Thìb xa' li Diox par yáp xa' loo bé'. Le' tedib xa' na, taate yan'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Lomisque' ne, co'se' gàc huiza, chop xa'got cue yu' loo yees. Thìb xa', chàa, li Diox yáp xa' loo bé'. Le' tedib xa' na, taate yan'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nalas gure gu' no gunee gu' xal nziri' gu' loo cón che'n Diox co' ndxela's gu'. Tac gu ne'ñeede no inonte gu', ne, coyor yi'th Tad Diox gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hui' gu' nexa, ey. Nde niin thìb con' loo gu': Chele' thìb mbi' co' nac gundan che'n thìb yòo nanee coyor yál' lyàa huan' par li huan' huan' liz mbi', mbi' ne'gàtte. Ndxe'leque', tyub naa mbi'. No tataa mod ne'la'de mbi' yòo huan' liz mbi' par li huan' huan' che'n mbi' liz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Cona, ngue niin loo gu': Nalas gure gu' no gunee gu' xal nziri' gu'. No bli nab gu' gu' loo cón che'n Diox. Tac thìb huiz co'se' ingue lide gu' xtùuz cón che'n Diox pól galen, chàa, ñèe gu' no ta' gu' cuent le' daa ndale' loo mbii loo bé' loo gu', daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nde niin tedib di's loo gu', ne: Cón che'n con' co' gàc loo mèn co'se' galen loo izlyo' ndxè' tedib vez nac xal ndxàc loo moz co' ngue no thìb patrón. ");
INSERT INTO zamNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Huen nda moz co' mtan' no patrón liz patrón chele' moz huenque' ngue li zin' co' ndxàalque' li moz co'se' zin patrón liz patrón. ");
INSERT INTO zamNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Lìcpe' ba'i, na nii loo gu': Le' patrón ñibe' loo moz par gàc moz thìb mandador par tyoo naa moz loo zin' no quenap moz ryethe con' co' ndxàp patrón liz patrón. ");
INSERT INTO zamNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Per chele' moza nac thìb moz ye'rsin' no gab moz le'n lezo' moz: Aa'a. Patrón daa lyen'. Ne'ye'thgàade patrón daa. ");
INSERT INTO zamNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Le' sya, por ne'ye'thgàade patrón moz, tlo moza, tetìi moza xtàa moz. No que tee no moz mènguy. Que tee yuhua moz. Que tee yu moz con mènguya. ");
INSERT INTO zamNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Le' sya, láth tataa ngue tee moz, chàa, mzin patrón moz thìb huiz co' indlide moz xtùuz le' patrón zin no zin patrón thìb hor co' indlide moz xtùuz zin patrón no co' inonte moz. ");
INSERT INTO zamNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","¿Xá nee gu'? ¿Cón li patrón con moza, sya? Tetìi patrón moza axta plóthe no co' patrón moza loo rsin' patrón, ¿lé'? Por cona, thìb lìte tel' patrón moz par bii moz ye'rbìil co'te' ndxetoo bèel no ndxetoo quìi par yòo no moz mèn co' ntembìi ro no co' ntembìi xti's tya. ");
INSERT INTO zamNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Cón che'n xá mod altant ndxàal cue mèn loo mod co' ndlya's Diox ñibe'pe' Diox loo mèn, mèna nac xal si' myen'got yèn' co' nde tan cuent loo gu' ndxè'. Ngòc thìb con' loo rye si' myen'gota. Ngro' myen'. No mbe' myen' candil aceit myen' par ngua myen' liz thìb mbyòo par lyath no myen' mbyòo co' mselya' liz mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ga'y myen'gota ngòc lijer. Le' taaga'y myen'gota na, ale msyen. ");
INSERT INTO zamNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Co'se' ngro' myen'got co' msyena, ne'nghue'de myen'got aceit par sè myen'gota candil myen'gota co'se' nquin myen'a aceit. ");
INSERT INTO zamNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Le' taaga'y myen'got co' ngòc lijera na, mte'que' lezo' myen' mbe' myen' bote che'n aceit par tolo sè myen' candil myen' co'se' gáal hor naquin myen' candil myen'. ");
INSERT INTO zamNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nde nxon', mbyòo co' mselya'a mblyen'. Ne'nzin'gàade mbyòo liz mbyòo yál'a. Le' myen'gota na, láth nzi bed myen' yál'a par zin mbyòo co' mselya'a, ale mxen mcal' myen'. Taate mblá' myen' candil myen' con xnìi. Ne'ntu'de myen' candil myen'. ");
INSERT INTO zamNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Per casque' co'se' nde yál' gulal yál' cabii ngrozèe thìb mèn co' mbez: Ndye'thle' mbyòo co' mselya'a, ey. Gro' gu' par ya càa ned gu' mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Sya, ngo che ryete myen'gota. No mbli nab myen' candil myen'. ");
INSERT INTO zamNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Per ga'y myen'got co' ngòc myen'got nasana ndxab loo taaga'y myen'got co' ngòc más lijera: Cara, techè gu' chu'th aceit gu' loo nu' par co nu' aceit candil nu'. Tac candil nu' ngue yu'le' xnìi. ");
INSERT INTO zamNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Le' sya, ga'y myen'got co' ngòc lijera mcàb loo taaga'ya myen'got co' ngòc myen'got nasana. Ndxab myen'gota: Ne'techède nu' aceit nu' loo gu', cara, tac yiloa ne'gàalta par nu' no ne'gàalta par gu', ne. Más huen huàa gu' co'te' ntho' mèn aceit. Fxi' gu' aceit co' nquin gu' tya. ");
INSERT INTO zamNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Per láth nda ti' myen'got co' msyena aceit myen', mzin mbyòo co' mselya'a. Le' taaga'y myen'got co ngòc lijera na, altantleque' nziri' myen' tac mbli nabque' myen' candil myen'. Sangngòo no myen' mbyòo le'n nyòo loo yalhua co' ndxàc por mselya' mbyòo. Sya, mbli mbyòo mandad mbyau' ro ryo'. ");
INSERT INTO zamNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ngoloa, mzin taaga'y myen'got co' ngòc myen'got nasana. Ndxab myen' loo mbyòo co' mselya'a: Tad, fxal' U' puert par yòo nu'. ");
INSERT INTO zamNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mbyòo mcàb loo myen'a. Ndxab mbyòo: Lìcpe' ba'i, daa indlibede gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ngoloa, sya, ndxab Jesús loo myen' xin' mté'th Jesús: ―Nalas gure gu', ey. Leque gu' ñee xal nziri' gu' loo cón che'n Diox. Gòc gu' xal mèn co' nzi naa tac gu' inonte. Ne' ne' inda' gu' cuent chó huiz galen no coyor galen, daa co' mbal yáal loo izlyo' ndxè' xal ndxáal chol mèn loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nde niin tedib con' loo gu', ne: Cón che'n mèn co' ndyubdi's ndac no cón che'n mèn co' indyubdi's ndacte co'se' ñibe'pe' Diox loo mèn, mèna nac xal moz con thìb mbi' co' nac patrón. Pues co'se' nda ro' mbi' liz mbi' no làaz mbi' par ya mbi' tedib nación co' nziri' tith, co'se' yamerle' ryo' mbi', ngurez mbi' moz mbi' par càaya' moz mbi' tmi par li moz zin' con tmi co' tan' no mbi' moz. ");
INSERT INTO zamNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Loo thìb moz mbi' mda' mbi' casque' ga'y mil pes. Le' loo tedib moz mbi' na, mda' mbi' casque' chop mil pes. Le' loo tedib moz na, mda' mbi' casque' thìb mil pes. Ngolo mtan' no mbi' moz tmi, xalque' nda' mbi' cuent no ñee mbi' xal ndli moz zin' no xal nzo moz, mxen mbi' ned. Nda mbi' tedib nación. ");
INSERT INTO zamNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Le' sya, moz co' mbyan' no ga'y mil pes, mtlo moz, mbli moz zin' con ga'y mil pesa. Ale mbli moza gan taaga'y mil pes. ");
INSERT INTO zamNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Lomisque' ne, loo tedib moz co' mtan' no mbi' taachop mil pes, moza, ne, mbli gan taachop mil pes loo chop mil pes co' mtan' no mbi' moz. ");
INSERT INTO zamNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Per loo moz co' mtan' no mbi' thìb mil pesa, moza quej quej mblosua' thìb mil pes che'n mbi' le'n thìb ye'r co' mden' moz loo yòo. ");
INSERT INTO zamNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Pues ngolo nguri'th huax tiemp. Yende mbi' co' nac patrón moza. Per mzin thìb huiz mzin mbi' loo moz tedib vez. Sya, mbli mbi' cuent con moz mbi' par ñee mbi' ñeene' plá pes mbli thìb thìb moz gan loo tmi co' mtan' no mbi' moz. ");
INSERT INTO zamNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mzin ner moz co' mbyan' no ga'y mil pes loo mbi'. Ndxab moz loo mbi': Tad, aa U' ga'y mil pes co' mtan' no U' daa thìb cua'a co'se' mdee U'a. No aa U' taaga'y mil pes co' mblin gan con ga'y mil pes co' mda' U' loon, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ndxab mbi' loo moz: Huen zyax. Huenque' mblil, ey. Lùu nac thìb moz ndac. Anze'f altant mdool loo zin' co' mblil. Pues ya que altantleque' mdool loo zin' co' mblil con ndxepte tmi co' mtan'en lool, tan lugar ñibe'l loo huax con'. Que de par yòo nol daa no tyac lezo'l con daa. ");
INSERT INTO zamNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ngoloa, mzin moz co' mtan' no mbi' taachop mil pes loo mbi'. Ndxab moza loo mbi': Tad, aa U' chop mil pes U' ndxè'. No aa U' taachop mil pes co' mblin gan loo chop mil pes co' mtan' no U' daa. ");
INSERT INTO zamNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mbi' ndxab loo moz: Huen zyax. Huenque' mblil, ey. Lùu nac thìb moz ndac. No anze'f altant mdool loo zin' co' mblil. Pues ya que altantleque' mdool loo zin' co' mblil con ndxepte tmi co' mtan'en lool, tan lugar ñibe'l loo huax con'. Que de par yòo nol daa no tyac lezo'l con daa. ");
INSERT INTO zamNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Per co'se' mzin moz co' mtan' no mbi' thìb mil pes, moza ndxab loo mbi': Tad, daa nanee le' U' nac thìb patrón nala's no nac U' thìb patrón nayi'. No nthop U' cosech co'te' ingode U' bin. No ndláp U' co'te' tarte co U' nec thìb quèe bin. ");
INSERT INTO zamNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Por cona, mzyeb daa ñèen U'. Ale ngua teyòoen tmi U'. Aa U' tmi U' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mbi' mcàb loo moza. Ndxab mbi': Aa, moz ye'rsin', moz za'f. Chele' lùu nda' cuent no naneel le' daa nthop cosech co'te' ingoden bin no ndlápen co'te' tarte gon nec thìb quèe bin, ");
INSERT INTO zamNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","chele' lùu nanee tataa nac daa, más quee lezo'l nga la'l tmi daa loo banc. Le' sya, co'se' beren galen, nga lo'en tmi daa loo banc nazal' xin' tmi daa co' mbli tmi daa gan. ");
INSERT INTO zamNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Sya, ndxab mbi' loo taamas moz co' nzi tya: Fteche gu' thìb mil pes co' ngue no moz ba'. Fta' gu'i càa moz co' ngue no si' mil pes. ");
INSERT INTO zamNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mèn co' ngue no ndxep tmi no huen ndli mèna zin' con tmii par tataa mod li mèna gan más tmi, mèna que no más tmi. Per mèn co' ngue no ndxepte tmi no ihuente ndli mèna zin' con tmia, mèna tuhuan tmi co' mque no mèna. No yiloa yan' mèna nague's nii mèna no nague's ya' mèna. Cona nee di's, mèn co huen huen nxo'f zin' cón che'n zin' co' mxo'f zin' Diox loo mèn xalque' mbli Diox par ndxác mèna, mèna nzi tee ndacque' loo cón che'n Diox. Per mèn co' inxo'f zin' ndacte loo cón che'n Diox, xal ndlyath no Diox mèn par li mèna zin' co' mxo'f zin' Diox loo mèna, Diox li par ne'gácte mèna xo'f zin' ndac mèna cón che'n Diox thidtene. No yiloa tetìi Diox mèna axta plóthe. ");
INSERT INTO zamNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Le' mbi' co' nac patrona na, tolo ndxab loo moz: Fxen gu' moz co' yende chó juis ba'. Be' gu' moz za'f ba'. Càa moz ba'. Blo' gu' par fuer. Huàa tyee gu' moz ba' thìb lad loon co'te' nacuau thidtene co'te' gón moz no co'te' hua le moz thidtene tac axta arid nè ten' moz gàc yaltìi loo moz tya. Tolo ndxab Jesús: Tataaque' gàca loo gu', ne, co'se' galen loo izlyo' ndxè' tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Sya, ndxab Jesús: ―Co'se' galen loo izlyo' ndxè' tedib vez, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn, par gal ñibe'en loo mèn, galen làth thìb baan angl. Yiloa tu'ben par ñibe'en loo ryethe con' par xyo'f lèe xyo'f xti's daa no gàc con' roo no con' xèn loon thidtene. ");
INSERT INTO zamNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Huiza hidte queltàan mèn co' nac mèn rye nación co' nziri' dib athu loo izlyo' loon par co' xà'en thìb ned mèn loo tedib ned mèn xal ndli pastor co'se' ngo' xà' pastor mbacxil' làth chiv. ");
INSERT INTO zamNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Huiza cuequen mèn co' nac xal mbacxil' loon cuaten co' nac ladlì. Le' mèn co' nac xal chiv loon na, cuequen mèna cuaten co' nac lad rebes. ");
INSERT INTO zamNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Sya gaben, daa co' nac rey tiempa, loo mèn co' nziri' cuaten co' nac ladlì: Que de gu' loon, ey, gu' co' mblole' Diox xuden cuent nac gu' mèn ndac no cón che'n gu' Diox gunii di's ndac. Gu' tlo ñibe' no Diox loo cón che'n Diox co' mbli nab Diox par ñibe' no gu' Diox. Ndoore' cobe' Diox no toxcua' Diox loo izlyo', Diox mnibe' lezo' no mdoo lezo' Diox ñibe' no gu' Diox loo ryethe con' yiloa. ");
INSERT INTO zamNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tataa mnibe' Diox loo lezo' Diox li Diox tac co'se' mque tee lan'en, mda' gu' thìb le' rol luan nduhuan. Co'se' mque tee yec lezon, mda' gu' chu'th nít gun. Co'se' mque tee'en xal mèn tith làaz gu' no loo gu', gu' mda' liz gu' nguleden. ");
INSERT INTO zamNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Co'se' mque tee'en ngox mdyal xaben, gu' mda' xaben par mdoquen. Co'se' mxac lenen, gu' mbi'th too naa daa co'te' naxen. Co'se' mque'en lezi'f, mbi'th toodi's no gu' daa ro lezi'f. ");
INSERT INTO zamNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Huiza ñee mèn co' daa mdyal no co' daa mda' lugar par ngòo mèn loo cón chenen: Tad, ¿pól gunèe nu' U' le' U' mque tee lan' no mda' nu' thìb le' rol yèth par nduhua U', à'? No ¿pól gunèe nu' U' le' U' mque tee yec lezo' no mda' nu' chu'th nít ngu' U', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Pól gunèe nu' U', mque tee U' xal mèn tith no mda' nu' liz nu' nguled U', à'? ¿Pól gunèe nu' mque tee U' ngox mdyal tab U' no mda' nu' xab U', ne, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","No ¿pól gunèe nu' U' mxac len U' no pól gunèe nu' U' mque U' lezi'f no ngua toodi's no nu' U' ro lezi'f, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Le' sya, daa co' nac rey tiempa, daa càb loo mèna: Licpe ba'i, gu' ne'nglide rye con'a loon. Per chele' gu' mbli rye con'a loo chol mèn co' ndxàc hues xtàan por ndxela's mèna loon, daa ngo cuent loope'en mbli gu' rye con'a. ");
INSERT INTO zamNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Sya, daa co' nac rey tiempa, daa càb loo mèn co' cue cuaten lad rebes: Biiche gu' loon, gu' co' nac mèndèe too ze too yál'. Gu' lyàa loo quìi co'te' ne'yu'de bèel no quìi co'te' ngòc nab par lyàa Mebizya no meexù' co' nac che'npe' Mebizya. ");
INSERT INTO zamNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tac co'se' mblyan' daa, ne'nda'de gu' thìb le' rol yèth nghuan. Co'se' mque tee yec lezon, ne'nda'de gu' ne' chu'th nít ngun. ");
INSERT INTO zamNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ngòc daa xal mèn tith loo gu'. No ne'nda'de gu' liz gu' par mbeden. Ngòc falt xaben loon. Gu' ne'nglatte lezo' ngnèe gu' daa. Ne'nda'de gu' thìb ned xab gu' par ngoquen. Mxac lenen. Ne'ngui'th too naade gu' daa. Mque'en lezi'f. Ne'ngui'thte gu' par ngtoodi's no gu' daa ro lezi'f. ");
INSERT INTO zamNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Le' sya, mèna ñee loon, daa co' nac rey tiempa: Tad, ¿pól gunèe nu' le' U' mque tee lan', no mque tee yec lezo' U', no ngòc U' xal mèn tith, no mque tee U' yende xab U', no mxac len U', no mque' U' lezi'f no ne'nglyath node nu' U', à'? ");
INSERT INTO zamNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Le' sya, daa co' nac rey tiempa, daa càb loo mèna. Gaben: Lìcpe' ba'i, na ngue nii loo gu': Chele' gu' ne'nglide chol con' co' nac co' ngue niin loo gu' ndxè' loo mèn prob co' ndxàc hues daa no co' ndxàc xtàa daa, daa ngo cuent ne'nglide gu' con'a loon. ");
INSERT INTO zamNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mèn ye'rsin'a yòo co'te' tyactìi mèna thidtene. Le' mèn co' daa mdyal no co' daa mda' lugar yòo mèna loo cón chenen na, mèna yòo ban no daa thidtene. ");
INSERT INTO zamNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Co'se' ngolo mdoodi's Jesús rye di'sa loo mèn co' nziri' loo Jesús, Jesús ndxab loo myen' xin' mté'th Jesús: ");
INSERT INTO zamNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Gu' neeque' no nonque' gu' taachopte huiz no maste ndxàc falt gàc lni pasc. Le'n huiz lnia tyenxù' mèn daa, daa co' mbal yáal loo izlyo' xal ndxáal chol mèn, par que' mèna daa loo thìb cruz. ");
INSERT INTO zamNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Le' sya, mèn co' nac jef co' más mnibe' loo nguley', no mèn co' na maistr co' ndlu' ón che'n ley co' mxo'f Moisés loo mèn, no mèngool co' ñibe', no mèn co' ndyoo ner, no co' ndyoo naa, loo mèn nación Israel, rye mèna thidte mqueltàa loo lue' che'n palas co' nac liz Caifás co' nac jef co' más ñibe' loo rye nguley' tiempa. ");
INSERT INTO zamNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Liz mbi' co' lèe Caifasa, tya mdoodi's rye mèna no mblo xnee mèna xá mod yigaaxù' Jesús loo mèna con purte yalgutyè' par guth mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Per mbez mèna loo xtàa mèna: ―Más huen ne'guthte na' mbi' le'n huiz lni par ne'tezebte na' mèn co' yi'th lni par ne'tyub bènte lezo' mèna no yiloa yecloo mèna loo na'. ");
INSERT INTO zamNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Láth ndyoodi's mèna, Jesús ngo yèez Betañ liz thìb mbi' co' lèe Mon co' mxac thìb yíiz co' nac yíiz ndxa's co' nteya's no co' nteyèe yid lad mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tya mbii gax thìb xa'got loo Jesús. Xa'gota nde no thìb frasc co' natoxcua' con thìb loo quèe huen co' lèe alabastr. Le'n frasca nzo thìb loo aceit co' anze'f nazi' ndlya'. No anze'f náp ntac aceita. Láth co'se' ndub Jesús loo mes, xa'gota mbii gax loo Jesús. Mblath xa'gota aceit co' nzo le'n frasca yéc Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Per co'se' ñèe myen' xin' mté'th Jesús ngue li xa'gota con'a loo Jesús, ale ngocloo myen'. No mtlo myen'. Mbez myen' loo xtàa myen': ―¿Chonon ale ngue teza'xù' xa'gota aceit ba', yoo? ");
INSERT INTO zamNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nzoque' mod ntho' xa'gota aceit ba' par ryo' tmi loo aceit. Le' sya, que no xa'got huax tmi par ta' xa' tmi loo mèn prob co' naquin tmi. ");
INSERT INTO zamNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús mbìn di's co' mdoodi's myen'a. Sya, ndxab Jesús loo myen': ―¿Chonon ngue li xol gu' xa'got ndxè' no ngue tethon gu' xa', à'? Con' co' ngue li xa'got ndxè' loon nac thìb con' ndac. ");
INSERT INTO zamNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Por part cón che'n gu', gu' thidteneque' yo ban no mèn co' ndxàc hues gu' no mèn co' ndxàc xtàa gu' co' nac mèn prob. Per part cón chenen, gu' ya ne'tolode yo no daa nen tiemp loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tac con' co' ngue li xa'got ndxè' loon, xa' mblath aceit co' anze'f nazi' ndlya' ba' laden. Xa' mblath aceit laden par ne'yitoode xla' laden co'se' ya ca's mèn daa. ");
INSERT INTO zamNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Lìcpe' ba'i, na ngue nii loo gu', ey: Pál co'te' co mèn yalbàn cón che'n di's ndac no te'th mèn cón che'n di's ndac par non mèn xá mod lyá' mèn loo con' ryes loo mèn co' nziri' dib athu loo izlyo', gòn mèn con' co' mbli xa'got ndxè' loon par te' lezo' mèn no ta' mèn cuent cón che'n con' mbli xa'got ndxè' loon. ");
INSERT INTO zamNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Látha, xexte ngro' thìb mbi' co' ndxàc xin' mté'th Jesús co' ngro' lèe Jud Iscariot. Ngua toodi's no Jud mèn co' ngòc jef che'n nguley' tiempa. ");
INSERT INTO zamNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ndxab Jud loo mèn co' ngòc jef che'n rye nguley': ―¿Plál quix gu' càan chele' daa lu' Jesús loo gu' no cuanen mod taxù'en Jesús loo gu', à'? Sya, mèna mdix gal psi' pes plat loo Jud par li Jud con' ye'rsin'a. ");
INSERT INTO zamNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Desde hora, mcua'n Jud mod ñeene' xá mod li Jud par ta'i thìb lugar loo Jud par ta'xù' Jud Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Co'se' ngòc ner huiz co' nac huiz lni, co' nee di's, huiz vispr co' ngòc huiz co' ndxuhua mèn nación Israel pan co' ingode mèn dii levadur, huiza mnibdi's myen' xin' mté'th Jesús loo Jesús. Ndxab myen': ―Tad, ¿pá ndlya's U' ya li nab nu' no ya toxcua' nu' con' hua rsè na' co' nac xít mèn no lua' mèn co' ndxuhua mèn co'se' ndxáal lni pasc, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús ndxab loo myen': ―Huàa gu' le'n ciuda Jerusalén ba'. No yòo gu' liz thìb mbi'. Gab gu' loo mbi'a: Maistr gunee loo nu' par gab nu' lool no ta' nu' cuent cón che'n di's ndxè' lool. Maistr gunee: Nde zin' gaxle' hor co'se' tyactìin. No nalle' ndlyazen ta'l lizl par gàc nab xít mèn no lua' mèn par hua rsè'en co' nac cón che'n lni pasc con myen' xin' mté'th daa. ");
INSERT INTO zamNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Sya, ngua li myen' xin' mté'th Jesús xalque mnibe' Jesús loo myen' li myen'. Sya, mtoxcua' myen' rsè co' hua rsè no myen' Jesús co' nac cón che'n lni pasc. ");
INSERT INTO zamNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Co'se' ngulàa yál' izlyo' huiza, Jesús mdub no ryete si' fchop myen' xin' mté'th Jesús loo mes. ");
INSERT INTO zamNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Láth nzi yuhua rsè no Jesús myen', ndxab Jesús loo myen': ―Lìcpe' ba'i, na ngue nii loo gu': Thìb gu' co' nzo làth na' ndxè' cua'n mod xexte ta'xù' gu' daa loo mèn co' nac ngolo ngola's chenen. ");
INSERT INTO zamNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Sya, ryete myen' xin' mté'th Jesús anze'f ngure xi lezo'. Mtlo myen', mnibdi's thìb thìb myen' loo Jesús. Mbez myen': ―Tad, ¿ché' ne'stolque' daai, cà'? ¿Ché' ne'stolque' daai, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús mcàb. Ndxab Jesús loo myen': ―Thìb gu' co' ngue yuhua no daa thidte yen', gu'a ta'xù' daa loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, loon gàcque' ryethe con' ryes xalque' mbez di's co' ndub loo libr co' nac xti's Diox. Per ay, prob mbi' izlyo'. Mandit mbi' too ze too yál', mbi' co' ta'xù' daa loo mèn co' nac ngolo ngola's chenen. Más huen ngàca loo mbi' thidtene ne'ngáalte mbi' loo izlyo' ndxè' leque ta'xù' mbi' daa loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sya, Jud co' mda'xù' Jesús loo mèna ndxab loo Jesús: ―Maistr, ne'stolque' ngue lil cuent daa taxù' lùu loo mèn, cà'? Jesús mcàb loo Jud. Ndxab Jesús: ―Aa. Lùui, pues. ");
INSERT INTO zamNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Láth nzi yuhua myen' xin' mté'th Jesús con Jesús, Jesús mxen pan. Ndxab Jesús loo Diox: Diox quix U', Diox. Ngoloa, mbli rol Jesús pan. Mda' Jesús pan loo myen'. Ndxab Jesús loo myen': ―Dhua gu' pan ndxè', ndee. Pan ndxè' nac cón che'n bél'yòo laden co' gath por cón che'n rye mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ngoloa, mxen Jesús thìb vas vin. Ndxab Jesús: ―Diox quix U', Diox, loo Diox. Ngoloa, mteri'th Jesús vas vin loo myen' xin' mté'th Jesús. Ndxab Jesús: ―Gu ryete gu' thìb ro thìb ro vin co' nzo le'n vas ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tac vin ndxè' nac cón che'n ren laden co' xyo loo izlyo' par li nèen tedib conveñ co' gàc thìb conveñ cub yiloa. Xyo ren laden loo izlyo' por cón che'n huax mèn par tataa mod, mèn co' yila's cón chenen, mèna tyon' xquin no tyon' xtol mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Per daa ngue nii loo gu': Desde nalle', ya ne'bereden gun nít uv co' nda' lus uv loo izlyo' ndxè'. Na bere gu nít uv co' nda' lus uv con gu' co'se' ñibe'pe' xuden Diox loo mèn co' ngòole' loo cón che'n Diox por cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Le' sya, ngolo mbil'ro myen' xin' mté'th Jesús thìb himn con Jesús, nda no Jesús myen' loo thìb yii co' lèe yii che'n yaa oliv. ");
INSERT INTO zamNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tya, ndxab Jesús loo myen' xin' mté'th Jesús: ―Ryete gu' anze'f xi lezo' yál' ndxè', no tyoo xà' lezo' gu' no ya ye'th lezo' gu' por cón chenen yál' ndxè'. Gàca loo gu' tataa tac loo libr co' nac xti's Diox ndub di's co' ndxab: Daa guth pastor. Le' partid mbacxil' co' ngue tee no pastor na, rye's pál. ");
INSERT INTO zamNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Per co'se' yilo ryo xban daa, daa ga ner loo gu' le'n thìb yèez co' nac yèezya' che'n làaz mèn galile par zyál' na' tya. ");
INSERT INTO zamNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Sya, mcàb Pedr loo Jesús. Ndxab Pedr: ―Mastale' ryete myen' xi lezo' no tyoo xà' lezo' myen' nal yál' por cón che'n con' ryes co' gàc loo U', na ne'xide lezo' no ne' ne' tyoo xà' lezon co'se' gàc cón gàc loo U', Tad. ");
INSERT INTO zamNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Per Jesús ndxab loo Pedr: ―Pedr, lìcpe' ba'i, na ngue nii lool: Ndoore' lé' nguiidtee yál' nal yál', lùu cà di's daa son vez loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedr mcàb. Ndxab Pedr loo Jesús: ―Mastale' no daa gath con U', per par cà dizen U', daa ne'cà di'ste U' loo mèn. No ale ryete myen' xin' mté'th Jesús, leque di'sa ndxab myen' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ngoloa, ngua no Jesús myen' xin' mté'th Jesús thìb lugar co' lèe Getsemaní. Ndxab Jesús loo myen' xin' mté'th Jesús: ―Trè' gaate ftub gu' láth nda bezen Diox tua'. ");
INSERT INTO zamNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ante mbe' Jesús Pedr no ryop hues myen' co' nac xgan' thìb mbi' co' lèe Zebede ndxepte más delant co'te' ngurez Jesús Diox. Tya, mtlo Jesús, mxi lezo' Jesús. No naxut naxut mtlo gunaa loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Sya, ndxab Jesús loo Pedr no loo ryop hues myen' xgan' Zebede: ―Nase nxyon' lezon. No nden'en le' daa gath por ne'xecte daa nal yál', ndyaquen, ey. Trè' gaate byan' gu' no gure naa gu' con daa. Ne'gàtte gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ngoloa, ngua Jesús taachu'thte más delant loo myen'. Tya, mdub xib Jesús. No mcotloo Jesús loo yòo. Ngurez Jesús Diox. Ndxab Jesús: ―Diox, U' co' nac xuden, chele'i nzo mod, bli U' ne'gàcte arid nè yaltìi co' gàc xal thìb preb loon le'n huiz ndxè'. Indlyasten gàca loon xal neete lezon. Ndxe'leque', ante gàca loon xal neepe' lezo' U'. ");
INSERT INTO zamNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Co'se' mbye'th tee hui' Jesús máa Pedr con ryop hues myen' co' nac xgan' mbi' co' lèe Zebede co'te' mtan' Jesús Pedr con myen', ale le'le' nzi yàt myen'. Sya, ndxab Jesús loo Pedr: ―Pedr, ¿ché' ne'nglide gu' gan mbe naa gu' con daa nec thìb hor, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Gure naa gu', yey. No gurez gu' Diox par ne'ta'de Diox lugar loo gu' ne'aselide gu' cua'n gu' xquin gu'. Lìcpe' ba'i, xtùuz gu' no lezo' gu' anze'f ndlya's le' gu' cuez Diox. Per bél'yòo lad gu' ba' ndli nden' gu' ngo zan gu'. No ngulàa fuerz gu'. Por con'a, ale mbuu's gu' nzi gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Mbryop vez mbere Jesús. Nda Jesús leque tya. Ngurez Jesús Diox taandxè': ―Diox, U' co' nac xuden, chele' yaltìi co' gàc loon yende mod riid tua'te, gàca loon xal neepe' lezo' U'. ");
INSERT INTO zamNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mbere Jesús. Ndye'th Jesús tedib vez co'te' mtan' Jesús Pedr con taachop myen'a. Lomisque', ñèe Jesús nzi yàt myen' tac ngudloo myen' ya ne'xecte tant thìb mcal' nzo loo myen'. ");
INSERT INTO zamNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Taate mblá' Jesús myen'. Mbyon vez mbere Jesús, nda Jesús par ngurez Jesús Diox tedib vez. Leque di's co' ndxab Jesús ndoore' ndxab Jesús tedib vez loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ngoloa, mbere Jesús, ndye'th Jesús tedib vez loo myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Nase bli gu' descans no bdàt gu'. Ya mzinle' hor co' ta'xù' thìb mbi' daa loo mèn co' ncua'n xquin no xtol, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jer goo too gu'. Ya' gu' ndyàa na'. Mbi' co' ta'xù' daa loo mèna, mbi' nzole' ned, nde mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tatabe' ngue toodi's Jesús co'se' gunèe Jesús le' Jud co' ndxòo cuent nac si' fchop myen' xin' mté'th Jesús ngro zi'fle' nde con huax mèn. Ale nzo spad no nzo yaa ya' mèn. Nde mèn con Jud. Rye mèna nde por mnibe' mèn co' nac jef che'n nguley' no por mnibe' rye mèngool co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Le' Jud co' mblu'xù' Jesús no co' mda'xù' Jesús loo mèna na, Jud mbli thìb con' con mèna ndoore'. Ndxab Jud loo mèna: ―Mbi' co' seron cuat, mbi'a nac Jesús. Luega tyen gu' mbi' no bli gu' segur mbi' co' huen huen. ");
INSERT INTO zamNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sya, mbii gax Jud loo Jesús. Mde's Jud yen Jesús. No msero Jud cuat Jesús. Ndxab Jud: ―San, Maistr. ");
INSERT INTO zamNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús mcàb loo Jud. Ndxab Jesús: ―Amiu, ¿chó zin' ndel, à'? Sya, mbii gax mèna loo Jesús. Mxen mèna Jesús. Mbe' mèna Jesús xal ndxe' mèn thìb pres. ");
INSERT INTO zamNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Láth ndxàc con'a, thìb mbi' co' nac xin' mté'th Jesús ngua ya' rlan'. Mdo'f mbi' spad le'n cubiert. Chàa, mblàa mbi' thìb ya' spad nza thìb moz co' nac moz che'n nguley'. Ale mcho' mbi' nza moz. ");
INSERT INTO zamNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sya, ndxab Jesús loo mbi' co' ngòc xin' mté'th Jesús: ―Blosua' spadl le'n cubiert. Tac ryete mèn co' ndxuth xtàa con spad, leque loo spad ya mèn looi, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ché' inontel no ché' tarte ta'l cuent le' daa nzoque' mod bez Diox co' nac xuden no nzoque' mod ña'ben loo Diox co' nac xuden tel' Diox masre' thap gal mil solndad co' nac angl par tí' no làa angla daa la's ya' mèn ndxè', cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Per chele' daa tataa li, ¿xá mod gàcque' no xá mod tyaaque' di's co' ndub loo libr co' nac xti's Diox co' mbez no co' ndlu' taandxè'que' ndxàal gàca loon, sya? ");
INSERT INTO zamNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ngoloa, ndxab Jesús loo mèna: ―¿Ché', lìcque', co'se' ngro' gu' mxen gu' spad no mxen gu' yaa par tyen gu' daa xal thìb mbi' co' nac xal thìb huan', cà'? Gu' nda'que' cuent no ndlibe'que' gu' daa le' daa mdubque' làth gu' le'n templ atate huiz par mblu'en gu'. No ne'nglide gu' ryes nden gu' daa xal ndyen mèn thìb huan' xal ngue ten gu' daa nalle', ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Per ndxàc ryete con' ndxè' loon nalle' par gàcque' no tyaaque' xalque' mbez di's co' ndub loo libr co' nac xti's Diox co' mque' mèn co' mde'th di's co' ndxab Diox ye's cón chenen. Látha, rye myen' xin' mté'th Jesús mxon'. Mblá' myen' thidte Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Le' sya, mèn co' mxenxù' Jesús mbe' Jesús loo Caifás co' nac jef co' más ñibe' loo rye nguley' tiempa tac liz Caifás mqueltàa ryete mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, no rye mèngool co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Le' Pedr na, tith tith mdoo mque xís Jesús axta mzin Pedr loo lue' liz mbi' co' lèe Caifás co' nac jef co' más ñibe' loo rye nguley'. Pedr ngòo. No ndub Pedr làth rye mèn co' mqueltàa tya, mèn co' nquenap con' co' nac che'n templ no co' nque zin' le'n templ par ñee Pedr ñeene' xá mod tolo quexù' que' fals mèna Jesús no tolo li la's mèna cón che'n Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nde nxon', mèn co' nac jef che'n rye nguley', no rye mèngool, no rye mèn co' nxo'f zin' zin' che'n templ, no mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel, sate más mcua'n mèna mod xá mod tolo quexù' que' fals mèna Jesús axtaque' li mèna gan gàp mèna razon guth mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Per yende mod li mèna gan tolo ntec mèna Jesús mastale' huax mèna mqueltàa loo Jesús no mastale' antub yalgutyè'túb ngòc di's co' ngue zib quìi mèna Jesús. Por lult, mbi'th chop mèn co' mbi'th ta' cuent cón che'n Jesús co' nac di's yalgutyè'túb. ");
INSERT INTO zamNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Mèna ndxab: ―Nu' mbìn le' mbi' ba' gunii pezea, ndxab mbi' le' mbi' cobii templ che'n Diox. No bere mbi', xít te'f mbi' templ le'n son huiz no maste. ¿Xá nee gu'? ¿Ché', lìcque', li mbi' con'a? ");
INSERT INTO zamNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sya, ngo too nde'f mbi' co' nac jef co' más ñibe' loo rye nguley'. Ndxab mbi' loo Jesús: ―¿Ché' yende mod càbl loo ryop mbi' ba', cà'? ¿Xá mod chonon tatua' nac rye di's co' mbez ryop mbi' cón che'nl, à'? ¡Fcàb! ");
INSERT INTO zamNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Per Jesús yende chó di's mcàb. Sya, ndxab mbi' co' nac jef loo rye nguley' loo Jesús: ―Por lèe Diox co' naban, daa ngue te'th Diox lool: Nu' ndlya's ñeel loo nu: ¿Ché', lìcque', lùu nac Crist, xgan' Diox o ché' inacte lùu Crist, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús ndxab loo jef: ―Aa. Nacque' daa xgan'pe' Diox, pues, xalque' ngue bezl ba'. No thidte vez ngue niin loo ryete gu' le' gu' hui' loon, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo', co'se' tuben cuat Diox, Diox co' ndxàppe' ryethe con' la's ya' Diox no la's nii Diox. No hui' gu' loon co'se' gàc huiz co' ro'en loo bé' par galen le'n xcuau loo izlyo' ndxè' tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sya, jef co' más ñibe' loo nguley' ngo too nde'f. Mched jef xab jef. No ndxab jef: ―Mbi' ndxè' thidteneque' ñii yèe ñii tìi cón che'n Diox con di's co' ndyoodi's mbi'. ¿Cón li taamas mèn co' ta' cuent cón che'n mbi' ba' loo na'? Ya inquinte na' taamas mèn, ¿lé'? Gu' nde teele' ndxòn di's co' ndyoodi's mbi' co' ñii yèe ñii tìi mbi' cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Xá nee gu'? ¿Xá gàc mbi'? ¿Cón li no na' mbi'? Mèna mcàb: ―Ndxàalque' gath mbi' tac mbi' ndxàp dol. ");
INSERT INTO zamNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sya, ale msuc mèna rloo Jesús. No mda' mèna golp Jesús. Le' taandxep mèna mdis rloo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","No mbez mèna loo Jesús: ―Com le' lùu mbez lùu nac Crist, ¿lé'?, bli divin ¿chó nu' mda' che'nl? ");
INSERT INTO zamNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Láth ngue tetìi mèna Jesús no nzi li mèna xal ndlya's mèna con Jesús, Pedr ndub par fuer ro ned loo lue'. Sya, mbii gax thìb mozgot loo Pedr. Mozgota ndxab loo Pedr: ―Pedr, lùu, ne, mque tee noque' Jesús co' nac mèn gulàaz che'n mèn galile, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedr mcà di's Jesús loo mozgota loo rye mèn co' nziri' tya. Ndxab Pedr loo mozgota: ―Aa'a. Ne'needen chó cuent ngue ta'l. ");
INSERT INTO zamNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Le'pe' nda ro Pedr ro puert co'se' gunèe tedib mozgot Pedr. Sya, ndxab mozgota loo mèn co' nziri' tya: ―Mbi' ba', ne, mque tee noque' Jesús co' nac mèn yèez Nazaret. ");
INSERT INTO zamNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mbere Pedr, mcà di's Pedr Jesús tedib vez. Ndxab Pedr: ―¡Tyoxca lìca, cara! Ne'libeden mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pente ndxàc mcà di's Pedr cón che'n Jesús, mbere mèn co' nziri' tya, ngua bii gax mèna loo Pedr. Ndxab mèna loo Pedr: ―Lìcpe' ba'i, cara, lùu, ne, nac thìb mbi' co' mque tee noque' Jesús tac ndxàc be'l axta por mod co' ndyoodi's lùu. ");
INSERT INTO zamNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Sya, leque Pedr, nazab gunii yèe gunii tìi Pedr cón che'n Jesús. No mde'th Pedr Diox. Ndxab Pedr: ―¡Tyoxca lìca, cara! Ne'libeden mbi'a. Leque hor co'se' ndxab Pedr di'sa, chàa, ngrozèe nguiidtee mblé' nguiidtee yál'. ");
INSERT INTO zamNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Sya, chàa, mte' lezo' Pedr di's co' ndxab Jesús loo Pedr co'se' ndxab Jesús loo Pedr: Ndoore' cozèe nguiidtee lé' nguiidtee yál', lùu cà di's daa son vez. Sya, mbii Pedr tya. No ne'tí' ne' ñee lezo' Pedr, mbín' Pedr tant mxi lezo' Pedr no mthyon Pedr por mcà di's Pedr Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Co'se' ngo nìi izlyo' tedib huiz co' nde nquea, ryete mèn co' nac jef loo rye nguley' co' más ñibe' loo rye nguley', no ryete mèngool co' ñibe' loo mèn nación Israel, thidte gunii rye mèna no thidte mdoodi's rye mèna par mblo xnee mèna le' mèna guthque' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sya, mbe' mèna Jesús, natub dó' ya' Jesús, loo tedib mbi' co' ngro' lèe Pons Pilat co' nac gobernador le'n ciuda Jerusalén tiempa. ");
INSERT INTO zamNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Co'se' gunee Jud co' mda'xù' Jesús loo mèna le' mèna mquexù' mque' fals Jesús par guth mèna Jesús, axta syare' ngulàa yéc Jud no ngulàa lezo' Jud. Ale ngua sere Jud gal psi' pes plat co' mdix mèn loo Jud loo mèn co' nac jef che'n nguley' co' más ñibe' loo nguley' no loo mèngool co' ndyoo ner no co' ndyoo naa loo mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ndxab Jud loo mèna: ―Daa mcuan xquin daa no xtol daa loo Diox por mdaxù'len thìb mbi' loo gu' co' yende chó xquin ndxàp no co' yende chó xtol ndxàp par guth gu' mbi'. Per mèna mcàb loo Jud. Ndxab mèna: ―Yende chó mport nzo lezo' nu' con' mblil. Lùu nee cón lil. Con'a ya nacle' cón che'nl. ");
INSERT INTO zamNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Sya, ndxecleque' tmia mblobii Jud rloo mèna le'n templ. Ngoloa, ndyàa Jud. Ngua lo Jud dó' yen Jud. Ale leque Jud setilte mbeth Jud. ");
INSERT INTO zamNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sya, mèn co' nac jef che'n nguley' co' más ñibe' loo nguley' mthop tmi co' mblobii Juda. Ndxab mèna loo xtàa mèna: ―Yende mod co na' tmi ndxè' le'n caj co'te' ndxòo tmi co' ndyop gòn o ofrend. Tmi ndxè' nac tmi, co' nee di's, mxi na' mbi' ba' par guth na' mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ngoloa, luega mdoodi's mèna con xtàa mèna. Ndxab mèna: ―Más huen tyen na' tmi ba' par ti' na' thìb le' yòo bte'f co' nac yòo co'te' ntoxcua' mèn plat no taz no taamas con' par gàc yòoa thìb lugar co'te' cuec mèna thìb panteón par ca's mèna mèn co' nac mèn tedib nación co' nzo ban ciuda ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Por cona, axta huiza no axta huiz nalze lèe lugar co' ngòc yòo bte'fa yòo bte'f co' mdyu' con tmi co' ngòc tmi co' mxi mèn thìb mbi' co' mbethxù' mèn par mxyo ren mbi' loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tataa mod ngòcque' no mdyaaque' cón che'n di's co' gunii Jeremi co' mde'th di's co' ndxab Diox co'se' ndxab Jeremi: Mxen mèn gal psi' pes plat co' ngòc tmi co' ndxab mèn ntac mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","No con tmia mxi mèna thìb le' yòo bte'f co'te' ndli mèn zin', mèn co' ntoxcua' plat no taz no taamas con'. Mblique' mèn con'a xalque' mnibe' Tad Diox loon par mdethen di's ndxè' co' ngòc di's co' gunee Tad Diox loon. ");
INSERT INTO zamNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ngoloa, mbe' mèna Jesús loo gobernador co' ngro' lèe Pilat. Sya, mnibdi's gobernador loo Jesús. Ndxab gobernador loo Jesús: ―¿Ché', lìcque', lùu nac rey che'n mèn nación Israel, cà'? Jesús ndxab loo gobernador: ―Aa. Nac daa rey che'n mèn nación Israel, pues, xalque' ngue bezla ba'. ");
INSERT INTO zamNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Per co'se' ngue quexù' ngue que' fals mèn co' nac jef co' más ñibe' loo nguley' no mèngool Jesús, nec thìb di's ne'ncàbte Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sya, ndxab Pilat loo Jesús: ―¿Ché' indxònte lùu no ché' inden'te lùu rye di's co' mbez mèn ba' cón che'n lùu, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Per Jesús nec thìb di's ne'ncàbte loo gobernador. Ante mbui' no ante gunaa gobernador loo Jesús axta ne' ne' ñee gobernador cón li gobernador xtùuz. ");
INSERT INTO zamNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nde nxon', mque no mèn co' ndxàc gobernador thìb costumbr ngo' mèn co' ndxàc gobernador thìb pres co' mbez mèn loo gobernador ryo' cad lín' co'se' ndxáal lni pasc. ");
INSERT INTO zamNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Le'pe' lín'a, ngo thìb mbi' co' anze'f mxyo'f lèe no co' anze'f mxyo'f xti's co' ngòc thìb mbi'guth mèn. Mbi'a ngro' lèe Barrabás. ");
INSERT INTO zamNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Láth co'se' mqueltàa rye mèna loo Pilat co' nac gobernador, Pilat mnibdi's loo mèna. Ndxab Pilat: ―De loo ryop mbi', Barrabás co' ngue lezi'f no Jesús co' nda gu' cuent loon, ¿chó mbi' ndlya's gu' telá'en par bii mbi', à'? ¿Ché' ndlya's gu' telá'en Barrabás o ché' ndlya's gu' la'en bii Jesús co' ne' tedib lèe Crist, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tac Pilat nonque' no nda'que' Pilat cuent por ndxecloo mèna ñèe mèna Jesús no por ndxàn lezo' mèna ñèe mèna Jesús, por cona asembli mèna mda'xù' mèna Jesús loo Pilat. ");
INSERT INTO zamNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Láth ndub Pilat co'te' ndub rez Pilat di's cón che'n mèn, xa'got co' nac sa'l Pilat mtel' mandad par ndxab sa'l Pilat loo Pilat: Anderhuenl, Pilat. Ne'tetìidel mbi' ba'. No yende cón li nol mbi' co' nac mbi' nalì no mbi' nambìi ba'. Tac daa msa' lezo' thìb mcal' fier no anze'f mzeb mcal' daa por cón che'n mbi' ba' ná' xhuina. ");
INSERT INTO zamNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Per mèn co' nac jef co' más ñibe' loo rye nguley' no mèngool co' ñibe' loo mèn nación Israel, thidte ngòc ryop ned mèna. Thidte ndxab rye mèna loo Pilat más huen ryo' no lyá' Barrabás. Le' Jesús ba' na, gath. ");
INSERT INTO zamNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mbere Pilat co' nac gobernador, ndxab Pilat loo mèna. No mnibdi's Pilat loo mèna tedib vez: ―De loo ryop mbi', ¿chó mbi' ndlya's gu' telá'en, à'? Mèna ndxab: ―Blo' Barrabás lezi'f. No bla' bii Barrabás. ");
INSERT INTO zamNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat mnibdi's tedib vez loo mèna. Ndxab Pilat: ―Le' loo Jesús co' mbez mèn nac Crist, ¿cón ndlya's gu' li non Jesús, à'? Ryete mèna mcàb: ―Fcàa Jesús. Fque' loo cruz. ");
INSERT INTO zamNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mbere Pilat, ndxab Pilat loo mèna: ―Per ¿chó con' ye'rsin' mbli mbi' ndxè', yey? Per ale le'le' mcàb rye mèna. Ndxab rye mèna loo Pilat: ―Pues, nu' ngue bez lool: Fcàa mbi' ba'. Fque' loo cruz. ");
INSERT INTO zamNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Co'se' ñee Pilat ya yende mod li Pilat gan no, ndxe'leque', sate más ndxátbèe mèna no ndxecloo mèn ñèe mèn Jesús, mbli Pilat mandad. Ngua xi mèn nít par mtech Pilat ya' Pilat loo mèna. Láth ngue tech Pilat ya' Pilat, ndxab Pilat loo mèna: ―Yende chó cón chenen par la's ron cón che'n mbi' ba' par niin guthen mbi'. Ne' ne' la's ron cón che'n mbi' ba' par niin loo gu' guth gu' mbi' ba'. Mbi' indxàpte nec thìb xquin no xtol par guthen mbi'. Con' co' ndlya's gu' li gu' ba' ya nacle' cón che'n gu'. Gu' nee cón li no gu' mbi'. Yende chó cón chenen par xon ren mbi'. Nambìi ndoon loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sya, ryete mèna mcàb loo Pilat. Ndxab mèna: ―Yan' cón che'n mbi' co' gath ba' cón che'n nu' no cón che'n xin' nu', xàa. Mbi' gath. Ngolo cuent. ");
INSERT INTO zamNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Sya, mblo' Pilat Barrabás lezi'f. No mtelá' Pilat Barrabás. Le' Jesús na, mbli Pilat mandad ngua ta' mèn che'n Jesús. Ngoloa, mda' Pilat Jesús loo mèna par ya que' mèna Jesús loo cruz. ");
INSERT INTO zamNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ngoloa, mbe' solndad co' nac solndad Pilat, co' nac gobernador, Jesús co'te' nac palas che'n Pilat. Tya mqueltàa rye solndad dib vuelt loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mteche solndad xab Jesús co' noc Jesús. Ngoloa, mtegoc solndad Jesús thìb ned xab Jesús co' ngòc lar' nanee. ");
INSERT INTO zamNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ale mtoxcua' solndad thìb coron yis. Ngoloa, mdub solndad coron yisa yéc Jesús. No mblo solndad thìb le' yaa ya' Jesús co' nac ladlì. Sya, asembli solndad, mdyub xib solndad loo Jesús. No mxìis no solndad Jesús. No ale ndxáp nxyán' solndad ñèe solndad Jesús. Mbez solndad loo Jesús: ―San, Rey, lùu co' mbez nac lùu rey che'n mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ale msuc solndad rloo Jesús. No leque yaa co' mblo solndad ya' Jesús, mxen solndad par mblàa solndad yaaa yéc Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ngoloa tataa mxìis no solndad Jesús no mbli solndad ngòc nguàal con' con Jesús, mteche solndad cap co' noc Jesús. Mbere solndad, mtegoc solndad xab Jesús. Ngoloa, mbe' solndad Jesús par ya que' solndad Jesús loo cruz. ");
INSERT INTO zamNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Láth nda ro' solndad ro ciuda Jerusalén con Jesús, asal' too solndad con mèna thìb mbi' co' nac mbi' gulàaz che'n làaz mèn siren. Mbi'a ngro' lèe Mon. Ale mtau' solndad loo mbi'. No mnibe' yèe solndad loo mbi'a par mbe' mbi' cruz Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Co'se' ngolo mzin no solndad Jesús con mèn co'te' lèe Gólgota, co' nee di's, thìb den co' ñaa xal thìb calaver yéc mèn, ");
INSERT INTO zamNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","tya, mcos solndad vin con thìb loo cuan' co' anze'f nala par ta' solndad vina gu Jesús. Per co'se' ngolo mbli Jesús preb vin co' nos cuan' nalaa, ne'càbte Jesús gu Jesús vina. ");
INSERT INTO zamNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Co'se' ngolole' mque' solndad Jesús loo cruz, mblo solndad xab Jesús rif. No mdith no solndad dad loo xab Jesús par ñee solndad ñeene' chó solndad gàc che'n xab Jesús. Tataa ngòc con'a par ngòcque', no mdyaaque', no mdubque' di's co' gunii thìb mbi' co' mde'th di's co' ndxab Diox co' ndxab: Mblo mèn xaben rif no mdith no mèn dad loo xaben par ñee mèna ñeene' chó mèn gàc che'n xaben. ");
INSERT INTO zamNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ngolo mdith no solndad dad loo xab Jesús, tya gaate ngure solndad par mquenap solndad Jesús bzyèa. ");
INSERT INTO zamNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nde nxon', mnibe' Pilat loo solndad mque' solndad plá di's co' mbez no co' ndlu' loo thìb ye's yéc cruz Jesús xá mod mquexù' mque' fals mèn Jesús. Di'sa mbez: Mbi' ndxè' nac Jesús co' nac rey che'n mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mque' solndad chop huan' ryop lad cuat Jesús loo cruz leque huiza, ne. Thìb mbi' mquée cuat Jesús ladlì. Tedib mbi' mquée cuat Jesús lad rebes. ");
INSERT INTO zamNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Látha, asembli mèn mbri'th mèn co'te' ngue Jesús loo cruz. No be' taa mcuin mèn yéc mèn. Mbez mèn loo Jesús: Mzyalque'la, ndee. No sate más mxìis no mèn Jesús no ndxáp nxyán' mèn ñèe mèn Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","No mbez mèna loo Jesús: ―Lùu co' gunee loo nu' le' lùu cobii templ loo yòo no le'n sonte huiz berel xít te'fl templ tedib vez, nalle' leque lùu bli par lyá'l. Chele' lùu, lìcque', nac xgan'pe' Diox, bilàa loo cruz co'te' nguel ba'. ");
INSERT INTO zamNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Lomisque' ne, mxìis no ryete mèn ndxè' Jesús, mèn co' nac jef co' más ñibe' loo rye nguley', no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, no mèn co' nac mèn xley' farise, no mèngool co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel. Mbez mèna loo xtàa mèna, ne: ");
INSERT INTO zamNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―¿Xá ngóc mbi' ba' mtelá' mbi' chol mèn loo chol yaltìi no nalle' ale ne'ngácte mbi' li mbi' par lyàa mbi' loo cruz co'te' ngue mbi' ba'? Chele' mbi' nacque' rey che'n mèn nación Israel, leque mbi' li par lyàa mbi' loo cruz co'te' ngue mbi' ba' par yila's na' no li la's na' lìcque' nac con' co' mbez mbi' nac mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Anze'f ngòp mbi' yalxla's loo Diox. Nee Diox xá mod telá' Diox mbi' loo cruz co'te' ngue mbi' ba' chele' mbi' nac anze'f ngudloo Diox no lezo' Diox. Más de cona, mbi' guneeque' loo na' le' mbi' nac xgan' Diox. Nal ñee na'i ñeene' ¿ché', lìca? ");
INSERT INTO zamNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Axta ryop huan' co' mquée loo cruz con Jesús mbez ngòc nguàal con' loo Jesús, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","No dib lal ngue tetìi mèna Jesús, ngóol rol huiz. Desde hora axta hor mquée guyon bzyè, dib lal hora mcuau loo izlyo'. Ale mbyau' loo huiz. Syare', mtenìi huiz loo izlyo' tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","No leque hor mquée guyon bzyèa cabii ngrozèe yii ngrozèe den Jesús. Ndxab Jesús: ―Eli, Eli, ¿lama sabactani? Di'sa nee di's ndxab Jesús loo Diox: Ay, Diox, Ay, Diox, ¿chonon mblá'ya' U' daa, à'? ");
INSERT INTO zamNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ndxep mèn co' nziri' tya mbìn di's co' ndxab Jesús. Sya, ndxab mèna loo xtàa mèna: ―Mbi' ba' ngue bez Lii. Gu' neeque' no nonque' gu' le' Lii ngòc thìb mbi' co' mde'th di's co' ndxab Diox póla, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Leque hora mque' thìb mbi' co' nzo làth mèn carre. Ngua xi mbi' thìb sponj. Mtegaz mbi' sponj con vin co' nos con cuan' nala. Mdub mbi' sponja loo thìb punt bar. Ale mzi mchep mbi' sponja ro Jesús par gu Jesús vin co' nos cuan' nala. ");
INSERT INTO zamNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Per taamas mèna ndxab loo mbi'a: ―Lá'a. Tee quée mbi' tua' par ñee na' ñeene' ché' ti'th Lii par telá' Lii mbi' no làa Lii mbi' co'te' ngue mbi' ba'. ");
INSERT INTO zamNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mbere Jesús, ngrozèe yii no ngrozèe den Jesús. Ngoloa, site nguth Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Leque hor co'se' nguth Jesús, mbli Diox le' cortin co' ngue le'n templ mbryed grolthe axta gáp no axta xàn'. Ale chop le' ngòc cortin. Látha, mbuin thìb xòo brut. No ngulàa bes huax quèe rhue' no ngulàa bes huax quèe co' ngóol yub loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","No mxyal' ro bá' co'te' mbua's huax thebol co' ngola's loo Diox. Rye mèna ngro xban hora. ");
INSERT INTO zamNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ngolo ngro xban mèna, ngro' mèna le'n panteón co'te' mbua's mèna. Ndyàa mèna par ciuda Jerusalén co' nac ciuda natú' che'n mèn nación Israel. Huax mèn ciuda Jerusalén gunèe mèn co' ngro xbana, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Le' sya, co'se' ñèe capitán con solndad co' nzi quenap Jesús mbuin xòo no tolo ngòc taamas con' naze'f, anze'f mzyeb capitán con taamas solndada. Ale ndxab capitán no mèn co' nziri' no capitana: ―Lìcpe' ba'i, ndee gu'. Mbi' ba', lìcque', ngòc xgan' Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ngure huax mèngot tya, mèngot co' ngure hui' xal ngòc con' loo Jesús. Mèngota mdoo nque xís Jesús axta co'se' ngro' Jesús le'n yèezya' che'n làaz mèn galile. Mblyath no mèngota Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Láth rye mèngota ngo son xa'got. Thìb xa'got lèe Mari. Xa'gota ngòc mèn yèez Magdala. Mbryop xa'gota ngòc Mari co' ngòc xna' ryop hues myen' co' ngro' lèe Cob no Chè. Mbyon xa'gota ngòc xin' sa'l thìb mbi' co' lèe Zebede, Zebede co' ngòc xud myen' co' lèe Juàn no Cob. ");
INSERT INTO zamNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Co'se' nde làale' yál' izlyo' huiza, mbi'th thìb mbi' ric co' lèe Chè. Mbi'a ngòc mbi' yèez co' lèe yèez Arimate. Ngòc mbi'a xin' mté'th Jesús, ne. ");
INSERT INTO zamNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ngua nee Chè loo Pilat ta' Pilat lugar par hue' Chè thebol Jesús. Sya, mnibe' Pilat loo mèn. Ngua ta' mèn thebol Jesús mcàa Chè. ");
INSERT INTO zamNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sya, mbe' Chè thebol Jesús. Mchì'x Chè thìb sab co' ante nagus bèeleque' ñaa lad thebol Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ngoloa, ngua lo Chè thebol Jesús le'n thìb ye'r quèe co' mbli Chè mandad mden' mèn par ga's Chè yiloa. Per ndxe'leque', le'n ye'r quèe co'te' ya lo mèn Chèa, mblo Chè thebol Jesús. Ngolo mblo Chè thebol Jesús tya, mtau' Chè ro ye'r quèea con tedib quèe roo. Ngoloa, ndyàa Chè. ");
INSERT INTO zamNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Le' Mari co' nac mèn yèez Magdala no tedib Mari co' mqueltàa no Maria, nguled ryop Maria ro ye'r quèea axta ngolo mblo Chè thebol Jesús le'n ye'r quèea. ");
INSERT INTO zamNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Co'se' ngo nìi izlyo' tedib huiz co' nde nquea, co' nee di's, ngolo nguri'th huiz co' ngòc nab mèn par huiz lni co' nac huiz yub lni, mqueltàa mèn co' ngòc jef co' más mnibe' loo rye nguley' no mèn xley' farise yòolau co'te' nzo Pilat. ");
INSERT INTO zamNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ndxab mèna loo Pilat: ―Tad, nu' nte' lezo' cón che'n mbi' gutyè'a co'se' be' naban mbi', mbi' gunee loo nu' co'se' yilo son huiz nguth mbi', mbi' ryo xban làth mèn nguth. ");
INSERT INTO zamNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Cona, nde nee nu' loo U', le' U' ñibe' ya quenap solndad ro ye'r quèe axta yilo son huiz par tataa mod ne'yade myen' xin' mté'th mbi' yál' no ya lo' myen' mbi' co' ngòc thebola le'n ye'r quèe. Le' sya, gab myen' no te'th myen' loo mèn le' mbi' ngro xbanle' làth mèn nguth. Le' sya, tataa mod más ndoo lìte toxcua' myen' yalgutyè' leque yalgutyè' co' ngòc di's co' gunii Jesús ndoore' láth co'se' be' naban Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat ndxab loo mèna: ―Gu' ngue no thìb tant solndad la's ya' gu' co' ngue li sirv loo gu'. Más huen leque gu' nibe' par ya quenap solndad ro ye'r quèe thìb mod co' más gác solndad quenap solndad ye'r quèe co' nac bá'. ");
INSERT INTO zamNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Sya, mxen mèna ned. Nda mèna ro ye'r quèe co'te' mblo Chè thebol Jesús. Mque' mèna thìb le' ye's loo quèe co' ngue di'sbè' co' ñibe' yende chó mèn cuin quèe co' ndoo nau' ro ye'r quèe co'te' mblo mèn thebol Jesús. Ngoloa, mtan' mèna solndad co' mbyan' quenap ro ye'r quèea par ñee solndad ñeene' cón gàc le'n yon huiza. ");
INSERT INTO zamNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Co'se' ngolo nguri'th huiz sabd co' ngòc huiz descans tiempa no nde yinìile' izlyo' huiz doming co' nac ner huiz che'n sman, Mari co' nac mèn yèez Magdala no tedib Mari ngua tee hui' ryop Mari ro ye'r quèe co'te' mblo Chè thebol Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Leque hora, chàa, mbuin thìb xòo brut. Láth ngüin xòoa, ngulàa thìb angl che'n Tad Diox loo bé'. Co'se' mzin angl ro ye'r quèe co'te' mblo Chè thebol Jesús, mteche angl quèe co' ndoo nau' ro ye'r quèea. Ngoloa, mdub angl loo quèe co' mteche angla. ");
INSERT INTO zamNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Látha, ante nquée xnìi angla xal co'se' ndxà'x bèel gundi. Le' xab angla na, ante nagus bèeleque' ñaa xal ñaa xil'. ");
INSERT INTO zamNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Co'se' gunèe solndad angl, ale mxi'th solndad tant mzyeb solndad. Ngob solndad loo yòo. Ale mcuau solndad. Ngòca loo solndad xal mèn co' nguth. ");
INSERT INTO zamNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Sya, ndxab angl loo mèngota: ―Ne'zyebte gu', ey. Na nanee no ndaquen cuent le' gu' nde cua'n Jesús co' mque' mèn loo cruz. ");
INSERT INTO zamNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ya yende Jesús le'n ye'r quèe ba'. Jesús ngro xbanle'. Ngòcle' con' loo Jesús xalque' mde'th Jesús loo gu' le' Jesús ryo xban. Que de gu' ndxè' par hui' gu' co'te' mdi'x Chè thebol Jesús par yila's gu' le' thebol Jesús yende trè'. ");
INSERT INTO zamNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Lijer byàa gu'. No fta' gu' cuent ndxè' loo myen' xin' mté'th Jesús le' Jesús ngro xbanle' làth mèn nguth. Fta' gu' cuent loo myen' no guuz gu' loo myen' le' Jesús ya ner loo gu' le'n thìb yèez che'n làaz mèn galile. Tya, hui'pe' gu' loo Jesús. Diox mtel' daa par tan cuent cón che'n di's ndxè' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Sya, sirs sirs mxen mèngota ned. Mbii mèngota ro ye'r quèea. Thìb part mzyeb mèngota. Tedib part na, más ndyac lezo' mèngota. Ale tolo mque' mèngota carre par ya ta' mèngota cuent loo myen' xin' mté'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Látha, chàa, ngro' too Jesús loo mèngota. No gunii Jesús Diox loo mèngota. Sya, mbii gax mèngota loo Jesús. No mdub xib mèngota loo Jesús. No thidte ngua mèngota. Mde's mèngota nii Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Sya, ndxab Jesús loo mèngota: ―Ne'zyebte gu', ey. Huàa ta' gu' cuent ndxè' loo myen' huesen. Guuz gu' loo myen' ya bed myen' daa le'n thìb yèez che'n làaz mèn galile. Tya, hui' myen' loon. ");
INSERT INTO zamNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Láth ndoo mèngota ned, ndyàa mèngota, mxen plá solndad co' mquenap ye'r quèe co'te' mblo Chè thebol Jesús ned. Nda ta' solndad cuenta loo mèn le'n ciudad Jerusalén loo mèn co' ngòc jef co' más ñibe' loo rye nguley' cón che'n ryete con' co' ngòca. ");
INSERT INTO zamNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Le' sya, mèn co' nac jef co' más ñibe'a ngua toodi's no mèngool co' ñibe' loo mèn nación Israel par thidte gàc mèna no thidte tyoodi's mèna par li nèe mèna cón che'n di's co' mda' solndad cuenta. Ngoloa, mda' mèna huax tmi par mcàa solndad. ");
INSERT INTO zamNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","No ndxab mèna loo solndad: ―Taandxè' gab gu' loo mèn che'n ciuda Jerusalén. Gab gu': Láth nzi yàt nu' xhuina, ne'nden'te nu' no ne'nda'de nu' cuent xal mbi'th li huan' myen' xin' mté'th thebol Jesús thebol Jesús le'n ye'r quèe. ");
INSERT INTO zamNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","No chele' gobernador ta' nza gobernador par gòn gobernador cón che'n di's co' ngolo mdoodi's na' ndxè', nu' tolo li nèe par yila's gobernador di's ndxè'. Tataa mod li nu' par ne'gàcte con' ryes loo gu' no ne'tub rezte gobernador cón che'n gu' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Le' sya, ndoo lìte mxèn solndad tmia. Ngua li solndad xal ndxab mèna. Di'sa be' nac di's co' mbez mèn nación Israel axta huiza no axta huiz nalze. ");
INSERT INTO zamNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Le' sya, rye si' fthìb myen' xin' mté'th Jesús na, myen' mxen ned. Nda myen' par le'n thìb yèez che'n làaz mèn galile co'te' ndub thìb yii co' ndxab Jesús loo myen' cued myen'. ");
INSERT INTO zamNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Co'se' gunèe myen' Jesús, mdub xib myen' loo Jesús no mcòo' myen' yéc myen' loo Jesús mastale' be' ngan lezo' myen' no mastale' be' ndxàc chop lezo' myen' ché', lìcque', nac mbi'a Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sya, mbii gax Jesús loo myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Hui' gu' nexa, ey. Diox mbli par ndxàpen rye loothe con' roo con' xèn la's niin no la's yan par ñibe'en loo ryethe con', que naca con' co' nziri' loo izlyo' ndxè', que naca con' co' nzo loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nalle' daa ngue ñibe' loo gu': Huàa gu' loo rye mèn le'n rye nación co' nziri' dib athu loo izlyo'. Huàa lu' gu' loo mèna co' nac cón chenen no bli gu' le' mèna gàc xin' mté'thpe' daa. No bli gu' bautizar mèna por lèe xuden Diox no por lèen, daa co' nac xgan' Diox, no por lèe Xpii Natú' che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Blu' gu' loo mèna tyubdi's mèna loo rye di's co' nac di's co' ñibe'en loo gu' lu' gu' loo mèna. No fte' lezo' gu' le' daa nzo noque' gu' thidtene no ne'lá'ya'den gu' ryethe huiz desde huiz nalze no axta co'se' gàc huiz co' lith no izlyo'. Taandxè' gàca loo gu', ey.");
INSERT INTO zamNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Taandxè' mod mtlo mbyath no mbyèn cón che'n di's ndac che'n Diox co' ndlu' cón che'n Jesucrist co' nac xgan'pe' Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Thìb mbi' co' ngro' lèe Sayi co' mde'th di's co' ndxab Diox, mbi'a mque' ye's loo libr co' nac xti's Diox co' mbez taandxè': Daa tel' ner thìb mbi' co' xo'f zin' zin' co' gàc rsinen. Mbi' yi'th ner lool par te'th mbi' di's no co mbi' yalbàn cón che'nl no par li mbi' le' mèn tlo gòn di's cón che'nl, ne, par li nab mèn mèn loo cón che'n Diox ndoore' co'se' yi'th lu'l loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mbyèn thìb di's che'n thìb mbi' co' mblo yalbàn cabii co'te' nagán. Mbez mbi': Ftub xnìi yéc gu' no ftub xnìi lezo' gu' loo cón che'n Tad Diox. Fxal' gu' xtùuz gu' no fxal' gu' lezo' gu' par ñee gu' no ta' gu' cuent cón che'n Tad Diox. Tataa mod gàc nab gu' ndoore' yi'th Tad Diox gu' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Cona, ngro xo'f Juàn Bautist no ngro' too Juàn loo mèn co'te' nagán par li Juàn bautizar mèn. Mbez Juàn loo mèn co' ndxi'th loo Juàn naquinque' gàc bautizar mèn par tataa mod lu' mèn le' mèn, lìcque, ngulàa yéc no ngulàa lezo' no mzye' ryethe mod ye'rsin' co' ngòp mèn par càba loo mèn ton' Diox xquin mèn no xtol mèn co' ndxàp mèn no co' ncua'n mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Látha, mbi'th mèn gulàaz che'n làaz mèn jude no mèn ciudape' Jerusalén par gòn mèn di's co' mbez Juàn. Co'se' ndxelo nxo'f dol mèn xtol mèn loo Juàn no ngo ro mèn cón che'n xtol mèn loo Juàn, ndli Juàn bautizar mèn le'n nít le'n yó'be' Jordán. ");
INSERT INTO zamNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Xab Juàn co' mdoc Juàn ngòc lar' co' mbuàb mèn con yis lad má' co' lèe camell. Cinch co' ngòo le'n Juàn ngòc cinch che'n yid má', ne. Lua' Juàn no xít Juàn ngòc mbiistoo no mzin huan. ");
INSERT INTO zamNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Co'se' ngo Juàn yalbàn loo mèn cón che'n di's ndac, taandxè' mod mbez Juàn: ―Nare' yi'th thìb mbi' co' más ndxàp con' roo con' xèn la's nii mbi' no la's ya' mbi' leque daa. Por con' roo con' xèn co' ndxàp mbi' la's nii mbi' no la's ya' mbi', pà tan con mbi' con co' ndxác mbi'. Axta ne' ne' lin ryes còo'en loo mbi' par xaquen bòo co' natedó' yilid co' ngue nii mbi. ");
INSERT INTO zamNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mbez Juàn, ne: ―Daa ndli bautizar gu' le'n nít. Per mbi'a li par yòo gu' loo cón che'n Diox por cón che'n Xpii Natú' xalque' ndxàc bautizar mèn le'n nít. ");
INSERT INTO zamNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Leque le'n huiza, Jesús ngro' le'n yèez Nazaret co' nac thìb yèez che'n làaz mèn galile. Mbi'th Jesús co'te' ngo Juàn par li Juàn bautizar Jesús le'n yó'be' Jordán. ");
INSERT INTO zamNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Texal ngolo ngro' Jesús le'n nít, ngolo ngòc bautizar Jesús, gunèe Jesús mxyal' loo bé' no gunèe Jesús nde làa Xpii Natú' loo bé' loo Jesús. Gunaa Xpii Natú'a xal ñaa thìb palomxtil' hora. ");
INSERT INTO zamNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","No leque hora mbyèn thìb di's loo bé' co' ndxab loo Jesús: ―Lùu nac xgan'pe' daa co' anze'f ngudloon no lezon. No por cón che'nl, anze'f ndyac lezon. ");
INSERT INTO zamNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ngolo ngòc con'a, Xpii Natú' mbli par mxen Jesús ned. Nda Jesús co'te' nagán. ");
INSERT INTO zamNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ngo ban Jesús co'te' nagána cho' huiz làth má' huan. Làth xtau'a, mbi'th Mebizya loo Jesús par li Mebizya preb loo Jesús no par cobya' Mebizya Jesús par ñee Mebizya ñeene' ché' tli Jesús cón ndlya's Mebizya. Per Jesús ne'nglide cas Mebizya. Ngoloa, mzin angl che'n Diox loo Jesús par mbli angl mandad loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Per pente ndxàc plá huiz nguri'th con'a, mxen mèn Juàn Bautist. No mque' mèn Juàn Bautist lezi'f. Le' Jesús na, ngua le'n huax yèezya' che'n làaz mèn galile par ngua lo Jesús yalbàn. No ngua te'th Jesús cón che'n di's ndac co' ndlu' loo mèn xá mod ndlya's Diox yòo mèn loo cón che'n Diox par ñibe'pe' Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mbez Jesús loo mèn par neda: ―Nase mzinle' tiemp co'se' ndlya's Diox yòo gu' loo cón che'n Diox par ñibe'pe' Diox loo gu. Blàa yéc gu' no blàa lezo' gu' no fse' gu' mod co' ndxàp gu' loo Diox. No gola's gu' di's co' mbezen loo gu' co' ndlu' xá mod lyá' mèn loo ryethe co' nac con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Láth co'se' nda riid Jesús ro lagun co' nziri' loo xyòn che'n làaz mèn galile, gunèe Jesús chop hues myen' co' lèe Mon no Ndech. Ryop hues Ndech Mon ngòc mèn co' ndyen mbèel. Nzi go ryop hues Ndech Mon yex le'n nít par yigaa mbèel le'n yex. ");
INSERT INTO zamNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ndxab Jesús loo ryop hues Ndech Mon: ―Ya' gu' nda na', ey. Ftoo nque gu' xísen. Na li le' gu' gàc mèn co' lu' loo mèn cón che'n Diox par yòo mèn loo cón che'n Diox xal ndxòo mbèel le'n yex co'se' ndyee ten gu' mbèel. ");
INSERT INTO zamNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Leque hora, mblá' Mon ryop Ndech yex. Nda nque Mon ryop Ndech xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ngoloa, tolo mdoo Jesús ned, nda Jesús. Per ndxepte más gundee Jesús delant, gunèe Jesús thìb mbi' co' lèe Cob co' ngòc xgan' thìb mbi' co' ngro' lèe Zebede. Gunèe Jesús Juàn hues Cob, ne. Nzi yon xgan' Zebede le'n yòoyaa. Nzi go bdè' Zebede yex con Cob no con Juàn. ");
INSERT INTO zamNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ngurez Jesús Cob no Juàn. Ndxab Jesús loo myen: ―Ya' gu' nda na'. Ftoo nque gu' xísen. Sya, nda no myen' Jesús. Taate mtan' myen' xud myen', Zebede, le'n yòoyaa con moz. ");
INSERT INTO zamNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tolo mdoo Jesús ned con dyap myen' axta mzin Jesús thìb yèez co' lèe Capernaum. Co'se' ngòc huiz sabd co' ngòc huiz descans tiempa na, ngòo Jesús le'n sinagog mèna par lu' Jesús mèn cón che'n di's ndac che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Le' sya, ryete mèn co' ndxòn di's co' nac di's ndac che'n Diox co' ngo Jesús yalbàn, ante ngüi' mèna no ante ñaa mèna loo Jesús. Tac Jesús ngue lu' loo mèna xal thìb mèn co' ndxàp con' roo no con' xèn la's nii mèn no la's ya' mèn par ñibe'pe' Jesús loo mèn. Mèna mden' no mda' mèna cuent ingue lu'de Jesús loo mèn xal nac mod co' ndlu' thìb maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hora ngo thìb mbi' co' nac mèn gulàaz che'n yèeza làth mèn le'n sinagog. Mbi'a mque no thìb xpii ye'rsin'. Xpii ye'rsin'a mbli ale ngrozèe mbi'. No mbli xpii ye'rsin' ndxab mbi' loo Jesús: ");
INSERT INTO zamNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Chonon ndxòo U' làth nu', à', Jesús, U' co' nac mèn yèez Nazaret? ¿Ché' nde U' trè' par telux U' nu', cà? Na ndlibeque' U' le' U' nac mbi' natú' che'n Diox. U' ngro' loo Diox. No mtel' Diox U' nde U' loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sya, mbyoo Jesús xpii ye'rsin' co' mque no mbi'. Ndxab Jesús loo xpii ye'rsin'a: ―¡Quex! Ftau' rol. No gro' loo mbi' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Per xpii ye'rsin'a mbli mquée mbii mbi'. No mblobii mbii mbi' loo yòo. No mbli mbii cabii ngrozèe mbi'. Ngoloa, chàa, ngro xpii ye'rsin'a loo mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Le' sya, ryete mèn co' ñèe ndxàc con'a loo mbi', anze'f mzyeb mèn no mnibdi's mèn loo xtàa mèn. Ndxab mèn: ―¿Chó con' co' ndxàc ba', yoo? ¿Chó di's cub no cón nac co' ndlu' mbi' ba'? Mbi' ba' ndxàp con' roo no con' xèn la's nii mbi' no la's ya' mbi', cona, axta xpii ye'rsin' ndxòn ro mbi' no nden' xpii ye'rsin' di's co' mbez mbi' loo xpii ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","No ale huizte huizte mbìn rye mèn gulàaz che'n làaz mèn galile cón che'n ryethe con' co' ndli Jesús no co' ndlu' Jesús loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Co'se' ngolo ngro' Jesús con myen' no mèn le'n sinagog, Jesús nda no Cob no Juàn. Ngua Jesús liz Mon no liz Ndech. ");
INSERT INTO zamNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Le'pe' huiza nax xna'zap Mon loo xlé'. Ndxab mèn guliz Mon loo Jesús le' xna'zap Mon ndyac len. ");
INSERT INTO zamNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Sya, ngòo Jesús co'te' nax xna'zap Mon. Mxít che Jesús xna'zap Mon. Mteyac Jesús xna'zap Mon. Leque hora, ngro xlé' xna'zap Mon. Sya, mtlo xna'zap Mon, mbli zna'zap Mon cas mèna con Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Co'se' mzyèle' izlyo' huiza no ngulàale' yál' izlyo' huiza, mzin no mèn huax mèn yíiz no huax mèn co mque no chol xpii ye'rsin' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Leque hora, ryete mèn yèez Capernaum mqueltàa ro ryo' liz Pedr loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Sya, mteyac Jesús huax mèn co' mque no chol yíiz. No mblo' Jesús xpii ye'rsin' loo huax mèn co' mque no xpii ye'rsin'. Ndxe'sleque' ndxàc mèna. No inda'de Jesús lugar loo xpii ye'rsin'a par angli xpii tyoodi's mèn co' nquée mbii yéca cón che'n Jesús tac xpii ye'rsin'a huen huen nanee chó mbi' nac Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Co'se' ndoore' yinìi izlyo' tedib huiz co' nde nquea, cuar ngo che Jesús. Ngro' Jesús thìb lad ro yèez Capernaum par cuez Jesús Diox tya. ");
INSERT INTO zamNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Látha, ne'nda'de Mon cuent con myen' co' ndxàc xtàa Mon máa Jesús. Mon ngua cua'n Jesús con myen' co' ndxàc xtàa Mon pá ned nda Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Co'se' mzyal Mon con myen' co' naqueltàa Mon Jesús, Mon no myen'a ndxab loo Jesús: ―Ryete mèn ngue tee cua'n U', Tad. ");
INSERT INTO zamNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Per Jesús ndxab loo Mon no loo myen' co' ngue tee no Mon: ―Nda na' le'n taamas yèez co' nziri' gax loo na' ba' par tan cuent no gon yalbàn cón che'n di's ndac che'n Diox loo mèn par ned ba', ne. Tac por cona ngro'en loo Diox par ndalen loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Sya, mxen Jesús ned. Nda lo Jesús yalbàn loo mèn le'n sinagog mèn le'n rye yèez co'te' ngue no mèn sinagog mèn. No mblo' Jesús xpii ye'rsin' loo rye mèn co' mquée mbii che'n xpii ye'rsin' loo mèn gulàaz che'n làaz mèn galile. ");
INSERT INTO zamNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ned nque tee Jesús, ngo thìb mbi' làth mèn. Mbi'a mque no thìb yíiz ndxa's co' nteya's no co' nteyèe yid lad mèn. Mbii gax mbi'a loo Jesús. No mdub xib mbi' loo Jesús. Ndxab mbi' loo Jesús: ―Tad, U' anze'f ndxác nteyac chol yíiz co' ndxàp mèn. ¡Oj li U' favor tembìi U' daa no teyac U' daa loo yíiz ndxa's ndxè', huen! ");
INSERT INTO zamNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sya, mblyat lezo' Jesús gunèe Jesús mbi'. Ante mbuàal Jesús lad mbi'. No ndxab Jesús loo mbi': ―Ndlyazen le' lùu yac, ey. Sya, mteyac Jesús mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","No texal ngolo ndxab Jesús di's, mbembìi yid lad mbi' co' mque no yíiz ndxa'sa. Ale, lueg mbyac mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Mnibe' yèe Jesús loo mbi'. Ndxab Jesús loo mbi': ");
INSERT INTO zamNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Hui' nexa. Yende chó loo gabtel co' ngolo mbli nonl ba', ndee. Ante ndlyazen yal loo nguley' par ñèe nguley' lùu. No sangya lá'l ofrend co' nac gòn loo Diox por cón che'n con' co' mtembìin ladl, ofrend co' nac gòn co' mnibe' Moisés ta' mèn par tataa mod ñèe mèn no yila's mèn le' lùu mbyacle' loo yíiz ndxa's co' mque nol ladl. Ngolo gunii Jesús Diox loo mbi', mtel' Jesús mbi', bii mbi' par liz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Per co'se' ndyàa mbi' par liz mbi', ale le'le' mtlo mbi', mda' mbi' cuent loo rye mèn co' mzyál' mbi' ned xá mod mbyac mbi'. No con'a mbli ya yende mod ngòo Jesús alanleque' le'n nec thìb yèez che'n làaz mèn galile. Más quee lezo' Jesús mque tee Jesús thìb lad ro yèez co'te' ihuaxte mèn nzo. Per mastale' thìb lad mque tee Jesús, rye mèn co' naban par neda nda nqueque' xís Jesús par hui' mèn loo Jesús no par libe' mèn Jesús no par ñèe mèna yalguzye' co' ndli Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ngolo nguri'th plá huiz, mbere Jesús. Ngòo Jesús le'n yèez Capernaum tedib vez. Mbyath di's le' Jesús nzo liz thìb mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Sya, setilte mqueltàa huax mèn liz mbi'a loo Jesús axta ne' ne' gàal ro ryo' yòo mèn, tant huax mèn mqueltàa. Le' Jesús na, mtlo ngo yalbàn cón che'n di's ndac che'n Diox loo mèn par yòo mèn loo cón che'n Diox par ñibe'pe' Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Látha, mzin thap xa'bi' co' ne' thìb mbi' loo thìb cami loo Jesús. Mbi'a mque no thìb mbii che'n thìb yíiz co' ntequech lad mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Co'se' ñèe mèna yende mod yòo mèna ro ryo', tant huax mèn par yòo no mèna mbi' loo Jesús, sya, añenti mtequée mèna mbi' par yéc yòo no mblit mèna tej yéc yòo par làa mèna mbi' nazal' cami mbi' loo Jesús par le'n nyòo. ");
INSERT INTO zamNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Co'se' ñèe Jesús le' mèna ndxela'spe' le' Jesús ndxác teyac mèn, ndxab Jesús loo mbi' yíiza: ―Xgan', xtol lùu no xquin lùu mdyon'le'. ");
INSERT INTO zamNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Per plá mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn co' ndub làtha, mèna mbli xtùuz le'n lezo' mèn: ");
INSERT INTO zamNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Chonon tatua' ndyoodi's mbi' ba'? Mbi' ba' ñii ngòc nguàal di's cón che'n Diox. Ngue ta' mbi' xyàn lezo' Diox tac yende chó mèn gác ton' xtol mèn co' ndxàp xtol. Ante Diox ndxác nton' xtol mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Per yub Jesús non no nanee Jesús cón ngue li mèna xtùuz. Ndxab Jesús loo mèna: ―¿Chonon tatua' nzi li gu' xtùuz, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Xá nee gu'? ¿Chó di's nac co' más inagànte, ndyac gu', par gaben loo mbi' yíiz ndxè', à'? ¿Ché' más inagànte naca, ndyac gu', gaben loo mbi': Xtol lùu mton'len o ché' más inagànte gaben: Goo too. Bye' camil ba'. Byàa par lizl, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pues daa ndxab di's loo mbi' yíiz ba' no nalle' lu'en loo gu' le' daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn, daa ndxàp con' roo no con' xèn la's niin no la's yan par ton'en xtol chol mèn loo izlyo' ndxè'. Sya, mbere Jesús. Ndxab Jesús loo mbi' co' mque no yíiz becha: ");
INSERT INTO zamNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Na ñibe' lool. Goo too. Fthùuz dáa co' ngo'thl. Bye' dáa. No tee càa ned, byàa par lizl. ");
INSERT INTO zamNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Leque hora, ngo too mbi' co' mque no yíiz bech. Mxen mbi' ned. Ngro' mbi' loo ryete mèn co' nziri' tya. Ndyàa mbi' par liz mbi'. Por cona, ryete mèna ante mbui' no ante gunaa. No ngurez mèna Diox. Ndxab mèna: ―¡Ay, Dio's! Dib lal nzi nu' loo izlyo' tarte hui' nu' con' co' tatua' ndxàc ba'. ");
INSERT INTO zamNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ngoloa, ngua Jesús ro lagun co' nziri' ro xyòn mèn che'n làaz mèn galile tedib vez. Tya mqueltàa huax mèn loo Jesús. Le' Jesús na, mblu' cón che'n di's ndac che'n Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Láth nda riid Jesús par neda, gunèe Jesús ndub thìb mbi' co' lèe Leví co' nac xgan' thìb mbi' co' lèe Alfe. Leví ndub co'te' ndyee thix mèn tmi cón che'n contribución. Jesús ndxab loo Leví: ―Leví, goo too. Ftoo nque xísen. Ya' nda na'. Sya, ngo too Leví. Mblá' Leví zin' Leví. Nda no Leví Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nde nxon', ngòc thìb con' loo Jesús. Láth ngue yuhua Jesús sa yèth liz Leví, anze'f thìb mèn co' ndli cobrar cón che'n contribución mqueltàa, no huax mèn co' ngòp xtol, loo Jesús. No thidte mdub mèna loo mès con Jesús no con myen' xin' mté'th Jesús. Le'pe' le'n huiza, anze'f huax mèn mqueltàa loo Jesús. Mdoo nque mèna xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Co'se' ñèe mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn no mèn che'n xley' farise le' Jesús thidte ndub yuhua no rye mèna loo mes, ndxab mèna loo myen' xin' mté'th Jesús: ―¿Xá mod ale thidte ngue yuhua maistr gu' no ale thidte ngue yu no maistr gu' mèn co' ndli cobrar cón che'n contribución no con mèn ye'rsin' co' anze'f thìb xtol ndxàp ba', à'? ");
INSERT INTO zamNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Co'se' mbìn Jesús tataa ndxàb mèna loo myen' xin' mté'th Jesús, yub Jesús ndxab loo mèna: ―Mèn co' ndyac huen nzo lezo' mèn no ndyac mèn yende chó yíiz nden' mèn, mèna ndyac inquinte mèna doctor par teyac doctor mèna. Ndxe'leque', mèn co' nden' yíiz, mèna nden' naquinque' mèna doctor par teyac doctor mèna. Hui' gu' nexa. Na ne'ngalte loo izlyo' ndxè' par bezen no cuin mèn co' nden' nac mèn mèn huen. Ndxe'leque', daa ndal loo izlyo' ndxè' par bezen no cuin mèn co' nden' nac mèna mèn ye'rsin' no mèn co' nden' nac mèna mèn co' ndxàp xtol loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Thìb vez ngòc thìb con'. Co'se' ngure xlat myen' xin' mté'th Juàn Bautist no myen' xin' mté'th mèn xley' farise, mbi'th plá mèn loo Jesús. Mnibdi's mèna loo Jesús: ―¿Chonon mbe xlat myen' xin' mté'th Juàn Bautist no myen' xin' mté'th mèn xley' farise per myen' xin' mté'th lùu imbe xlatte, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús mcàb loo mèna. Ndxab Jesús: ―¿Ché' ngue li gu' xtùuz nzo mod cue xlat mèn co' ngòc convid par ya thuhua mèn co'te' mselya' thìb ned myen' co' mselya' láth nzi mèna liz myen' con myen' co' mselya'a, cà'? Yende xàa. Chele' myen' co' mselya'a nziri' con mèn co' ngòc convida, yende mod cue xlat mèna, ey. ");
INSERT INTO zamNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Per co'se' zin hor bii myen' co' mselya'a, sya, cue xlat mèn co' ngòc convida. ");
INSERT INTO zamNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nde niin thìb con' loo gu': Yende chó mèngot nzo co' co bdè' thìb le' lar' cub loo thìb lar'can' gox. Tac chele' lar'can' goxa yo bdè' lar' cub, le' sya, co'se' yech lar'can' goxa, lar' cub co' nzo bdè' lar'can' goxa ched yèe lar'can'a. Le' sya, lar'can'a más naroo ryed. ");
INSERT INTO zamNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","No ne' ne' co mèn mezcal co' diz ngro' palenc le'n thìb garrafón gox co' nalé'le'. Tac thìb descuid mezcal li par tolo lyé' garrafón gox co' nalé'. Le' sya, tataa mod gàc perdid mezcal no gàc perdid garrafón, ne. Cona, ngue niin loo gu': Más huen gàca co mèn mezcal co' diz ngro' palenc le'n garrafón cub par ne'gàcte perdid mezcal no par ne'lyé'de garrafón, ne. ");
INSERT INTO zamNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Thìb huiz sabd co' ngòc huiz descans tiempa, Jesús nda riid co'te' nax thìb le' yòo co'te' nzo'f ña' triu con myen' xin' mté'th Jesús. Le' myen' xin' mté'th Jesús na, mtlo mcho' bacdò triu. No ngobya' myen' bacdò triu. No mbla' myen' mbii loo nzob triu par ryo yix loo nzob triu par hua myen' nzob triu. ");
INSERT INTO zamNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Le' sya, mèn xley' farise co' nzo làth mèn co' nda nque xís Jesús ndxab loo Jesús: ―Jesús, hui' nexa. ¿Chonon ndli myen' xin' mté'th lùu zin' co' indxàalte li mèn huiz descans, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sya, mcàb Jesús. Ndxab Jesús loo mèn xley' farisea: ―Aa, ¿ché' nec thìb vez tarte lab gu' loo libr co' nac xti's Diox, co'te' nda' cuent cón che'n David co' ngòc rey póla, con' co' mbli David thìb vez co'se' mblyan' David con mèn co' mblyath no David ned mque tee David, cà'? David mblyan' no mquinque' hua David con mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David ngòo le'n templ le'n tiemp co'se' ngòc Abiatar jef che'n nguley' co' más mnibe' loo rye nguley'. Ale mxen David pan co' ngòc pan co' mbec mèn loo mes le'n templ, co' nee di's, mbec mèn pan loo Diox. Pana ante nguley' ndxàp permis par hua nguley' pana tiempa. Mda' David pana nduhua mèn co' ngure no David, ne. ");
INSERT INTO zamNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ndxab Jesús loo mèna, ne: ―Diox mtan' thìb huiz co' nac huiz sabd par ne'lide mèn zin' co' mbyan' tub co' ne'ngácte ntelo mèn le'n sman, no par gàc con' ndac loo Diox, no par li mèn descans. Per ne'ntan'te Diox huiz sabd par ñibe' yèe mèn loo xtàa mèn loo co' nac costumbr co' nzi no mèn no co' mbed no mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Por cona, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo', daa ndxàp con' la's niin no la's yan par ñibe'en loo mèn cón ndxàal li mèn huiz sabd co' nac huiz descans. ");
INSERT INTO zamNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mbere Jesús, ngòo Jesús le'n thìb sinagog co' ndub le'n thìb yèez par neda. Làth mèn co' ngo le'n sinagoga, ngo thìb mbi' co' nayíiz sa ya'. Ya' mbi'a yende mod huin. No yende mod ga'. ");
INSERT INTO zamNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Látha, xèe nzi la's mèn loo Jesús par ñèe mèna ñeene' ché' teyac Jesús ya' mbi'a huiz sabd co' nac huiz descans par tataa mod cua'n mèna mod xá mod quexù' que' fals mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sya, Jesús ndxab loo mbi' co' nayíiz ya'a: ―Goo too co'te' ndubl ba'. ");
INSERT INTO zamNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sya, ndxab Jesús loo mèn co' xèe nzi la's loo Jesús: ―¿Xá nee gu'? ¿Ché' nda' ley co' mxo'f Moisés loo mèn lugar li mèn con' ndac o li mèn con' ye'rsin' le'n huiz co' nac huiz descans co' nac huiz sabd no ché' nda' ley lugar loo mèn telá' mèn thìb mèn loo con' ryes o ché' nda' ley lugar guth mèn thìb mèn le'n huiz descans co' nac huiz sabd, cà'? Fcàb gu' loon, ey. Per ndxe'leque', mèna ne'ngácte ncàb loo Jesús. Ale mbyau' ro rye mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Sya, ngocloo Jesús mbui' Jesús loo mèna. No mxi lezo' Jesús con mèna tac ne'nglàa huente di's co' ndxab Jesús le'n lezo' mèna. No ne'ngaa'dte mèna di's co' mbez Jesús loo mèna. Sya, ndxab Jesús loo mbi' yíiza: ―Ftega' ya'l, ey. Sya, mtega' mbi' ya' mbi'. Ngoloa, ale chàa, mbyac ya' mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ngoloa, ngro' mèn co' nac mèn xley' farise. Mtlo mèna, mdoodi's mèna con mèn co' nac partid che'n mèn herodist par cua'n ryop ned mèna mod xá mod guth mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús nda co'te' nziri' lagun gaxte co'te' nziri' yèez co' lèe Capernaum con myen' xin' mté'th Jesús. No anze'f thìb mèn gulàaz che'n làaz mèn galile nda nque xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Co'se' mbìn mèn le' Jesús ndli yalguzye' roo no yalguzye' xèn loo chol mèn, anze'f thìb mèn gulàaz che'n làaz mèn jude, no mèn ciudape' Jerusalén, no mèn gulàaz che'n làaz mèn idume, no mèn yèezya' co' nziri' par ned ndlyen huiz par ned ndri'th yó'be' Jordán, no mèn gulàaz che'n làaz mèn ciuda Tir, no mèn gulàaz che'n làaz mèn ciuda Sidón, mbi'th rye mèna loo Jesús par hui' mèna no ñèe mèna cón ndli Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Por cona, co'se' mqueltàa huax mèn loo Jesús, ndxab Jesús loo myen' xin' mté'th Jesús ya cua'n myen' thìb yòoyaa par yòo thidte Jesús le'n yòoyaa par ne'tí'de mèn arid Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tac Jesús mteyacle' huax mèn yíiz. Cona, ryete mèn co' ndyac yíiz ndxezi'f no ndxega's Jesús no nzi mchep mèn xtàa mèn par ante gàal mèna Jesús, sya, yac mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Co'se' ñèe mèn co' mque no xpii ye'rsin'a Jesús, xpii ye'rsin' co' nzo loo mèna mbli par mdub xib mèna loo Jesús. No cabii mbez yèe mèna loo Jesús. Mbez mèna: ―U' nacpe' xgan' Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Per Jesús mnibe' yèe loo xpii ye'rsin' co' ngo loo mèna. Ndxab Jesús loo xpii ye'rsin'a: ―Ñibe'en loo gu' yende chó loo gabte gu' chó nac daa. ");
INSERT INTO zamNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ngoloa, ngua quée Jesús loo thìb yii co' ndub gaxte tya. Ngurez Jesús mèn co' mblya's Jesús mcui Jesús. Sya, ngua gax mèna co'te' ndub Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ngoloa, mblec Jesús si' fchop myen' no mblo' xà' Jesús si' fchop myen' par mque tee no myen'a Jesús no par tel' Jesús myen'a par te'th myen'a no par co myen'a yalbàn cón che'n di's ndac che'n Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jesús mbli par mque no myen' con' la's nii myen' no con' la's ya' myen' par ante ñii myen' loo xpii ye'rsin', ryo xpii ye'rsin' loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ryete si' fchop myen' co' ngòc nerleque' myen' co' mcui Jesús, myen'a lèe taandxè': Ner mbi' co' Jesús mcui lèe Mon. Loo Mon mda' Jesús tedib lèe co' lèe Pedr. ");
INSERT INTO zamNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","No ngurez Jesús Cob no Juàn co' ndxàc ryop hues xgan' thìb mbi' co' lèe Zebede. Jesús mdub lèe ryop hues myen' na, Boanerg, co' nee di's, anze'f nayez yéc myen' co'se' ndyoodi's myen'. ");
INSERT INTO zamNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Xísa ngurez Jesús Ndech, Lip, Bartol, Mate, Max, Cob co' ngòc xgan' tedib mbi' co' lèe Alfe. No ngurez Jesús Tade, no tedib mbi' co' lèe Mon co' ngòo loo thìb ned mèn co' ngro' lèe partid cananist. ");
INSERT INTO zamNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","No lult ngurez Jesús Jud Iscariot. Jud ngòc leque thìb myen' xin' mté'th Jesús co' mda'xù' Jesús loo mèn ye'rsin' yiloa. Ngoloa, ngòo Jesús liz thìb mbi' con myen' xin' mté'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Le' mèn co' mbìn cón che'n Jesús na, mqueltàa mèna loo Jesús axta ne' ne' ngác nghua no Jesús myen' xin' mté'th Jesús tant thìb mèn mqueltàa. ");
INSERT INTO zamNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Co'se' mbìn mèn guliz Jesús cón ngue li Jesús no con' co' ndxàc loo Jesús, mbi'th mèna loo Jesús par hue' yèe mèna Jesús tac mbez mèna no ndyoodi's mèna le' Jesús nquée mbii yéc. ");
INSERT INTO zamNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lomisque' ne, mèn co' ngòc maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, co' nde par ned ciuda Jerusalén no co' nac mèn co' nzo làth mèn co' nde nque xís Jesús, mbez mèna loo mèn co' mqueltàa loo Jesús: ―Beelzebú co' nac jef che'n rye xpii ye'rsin' ngue tee no mbi' ndxè'. No por cón che'n con' roo no con' xèn co' ndxàp Beelzebú la's nii Beelzebú no la's ya' Beelzebú ngo' mbi' xpii ye'rsin' loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sya, ngurez Jesús mèn co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn. Mtetac Jesús thìb di's loo mèna. Ndxab Jesús: ―¿Xá mod leque Mebizya co'pe' Mebizya loo mèn, à'? ¡Máa yob yéc gu', na! ");
INSERT INTO zamNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Anggab na'i, chele' mèn co' ñibe' loo thìb gobiern, gàc mèna chop partid no cue yoo ryop partid mèna, le' sya, gobierna yende mod tolo xec no yende mod tolo yo gobiern, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Lomisque' ne, chele' thìb ned mèn guliz co' nzo ban thìb yòo, tlo gàc mèn guliza chop ned mèn por nzi yoo mèn guliza, yende mod tolo xec mèn guliza par yo ban mèn guliza thidte yòo par tolo gàc mèna thìb nedte mèn, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Lomisque' ne, chele' Mebizya bix yath loo cón che'n Mebizya, yende mod tolo cue no yo Mebizya. Ale ndxe'leque', lyux Mebizya thidtene. ");
INSERT INTO zamNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Lomisque' ne, yende chó mèn gác yòo liz thìb mbi' co' nac mbi' tín' par li huan' mèn cón che'n mbi' liz mbi' chele' mèn ne'quedó'de mbi' tín'a ner. Per chele' mèn ner quedó' nii mbi' no ya' mbi', le' sya, tataa mod lique' mèn gan li huan' mèn che'n mbi' liz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Na ngue nii tedib con' co' nac con' lìcpe' loo gu', ne: Nzoque' mod tyon' rye xquin mèn no xtol mèn no ryethe di's co' nac di's ye'rsin' co' ndyoodi's mèn loo xtàa mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Per mèn co' ñii ngòc nguàal con' cón che'n Xpii Natú', yende mod tyon' xtol mèna thidtene. Ndxe'leque', ndxàp mèna dol thidtene par tetìi Diox mèna yiloa. ");
INSERT INTO zamNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tataa mtetac Jesús rye di'sa loo mèn tac mèna mbez nzo thìb xpii ye'rsin' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ngoloa, mzin xna' Jesús no myen' huespe' Jesús loo Jesús co'te' nzo Jesús. Per ne'ngòode xa' par le'n nyòo. Par fuer no maste ngure xa'. Ndxab xa' loo mèn co' nziri' tya: ―Guuz gu' loo Jesús yi'th Jesús ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mèna mteri'th di's par le'n nyòo. Le' sya, plá mèn co' nzi dib vuelt loo Jesús ndxab loo Jesús: ―Tad, xna' U' no myen' huespe' U' nziri' fuer. Ngue bez xa' U' par tyoodi's no xa' U'. ");
INSERT INTO zamNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Per Jesús ndxab loo mèna: ―¿Ché' ndlya's gu' niin loo gu' chó mèn, lìcque', nac xal xnan no myen' huesen? ");
INSERT INTO zamNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ngoloa, mbui' Jesús loo mèn co' nziri' dib vuelt loo Jesús. Ndxab Jesús loo mèna: ―Niin loo gu' chó mèn nac xal xnan no xal myen' huespe'en. Ryete gu' co' nziri' loon ndxè' lalque' nac xal xnan no nac gu' xal huesen. ");
INSERT INTO zamNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tac chol mèn co' ndli xal nee lezo' Diox, mèna nac xal huesen. Mèna nac xal ftanen. No nac mèna xal xnan. ");
INSERT INTO zamNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mbere Jesús. Mtlo Jesús, mblu' Jesús mèn ro lagun co' nziri' tya. Anze'f thìb mèn mqueltàa co'te' ngo Jesús. No de tant huax mèn mqueltàa, más quee lezo' Jesús ngua tub Jesús le'n thìb yòoyaa co' ndub loo lagun gaxte ro lagun. Le mèna na, ngure loo yux ro lagun. ");
INSERT INTO zamNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sya, mtetac Jesús di's loo mèn par tataa mod lu' Jesús huax con' loo mèn no ta' Jesús cuent cón che'n di's co' ngue tetac Jesús loo mèn. Mbez Jesús loo mèn: ");
INSERT INTO zamNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Bìn gu' di's co' tyoodizen loo gu' ndxè'. Thìb mbi' co' ngo bin, mbi' ngro'. Nda lo mbi' bin. ");
INSERT INTO zamNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Láth ngue go mbi' bin, ngulàa ndxep biz bin ro ned. Ngoloa, mbi'th mbin. Mblo' mbin biz bina. Nduhua mbin biz bina. ");
INSERT INTO zamNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Le' tedib lugar na, láth ngue go mbi' biz bin, ngulàa ndxep biz bin loo yòo quèe co'te' xhuite yòo nzi'f loo quèe. Luega ngulen biz bina tac inacha'de nzi'f yòo loo quèe. ");
INSERT INTO zamNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Per co'se' mtlo mdín bée ro'tha, ale mbiiz ro'tha tac yende mod ngroo ngxèn lox ro'tha loo yòo quèea. ");
INSERT INTO zamNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tedib lugar na, láth ngue go mbi' biz bin, ngulàa ndxep biz bin le'n huan. Per co'se' ngulen ro'tha, mtlo mblyus ro'th le'n huan tac mdín huan ro'th. Por lult ne'nda'de ro'th cosech tac mdín huan ro'th. ");
INSERT INTO zamNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Le' tedib lugar na, mblo mbi' biz bin antub loo yòo be'f. Tyase huen ngulen ro'th. No mbryoo mxyèn ro'th. No mda' biz bina thìb huen cosech. Thìb nzob bin mda' gal psi' quèe nzob. Tedib nzob bin mda' ayon quèe nzob. Tedib nzob bin mda' thìb ayo quèe nzob. ");
INSERT INTO zamNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tolo ndxab Jesús loo mèna: ―Gu' co' ndxác ta' gu' cuent co' huenleque' cón nee di's di's co' ngue toodizen loo gu' ndxè', no chele' gu' ten' cón nee di's di's ndxè', bìn gu' di's co' ngue niin loo gu' ndxè' no fta' gu' lugar yaa'd di's ndxè' le'n lezo' gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Per co'se' ngolo mbii rye mèn, taate mbyan' Jesús con taandxep mèn co' be' mbyan' con ryete si' fchop myen' xin' mté'th Jesús. Mnibdi's mèna no myen' xin' mté'th Jesús loo Jesús cón nee di's di's co' mdoodi's Jesús co' mtetac Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sya, ndxab Jesús loo mèna no loo myen' xin' mté'th Jesús: ―Por part cón che'n gu', ey, Diox angndli loo gu' par ta' gu' cuent no non gu' xá mod ndlya's Diox ñibe'pe' Diox loo mèn. Cón che'n con'a be' nzo casloo loo taamas mèn. Cona, ndxe'leque', loo mèn co' tarte tyal yila's par ta' mèn lugar ñibe'pe' Diox loo mèn, na ntetac di's loo mèna par tataa mod ndyoodiz non mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tataa ndlin par gàca co'se' hui' mèna loo cón chenen, con'a ndli gàc mèna xal mèn co' ingüi'de. No co'se' gòn mèn di's co' mbezen, gàc mèna xal mèn co' ne'ta'de cuent cón che'n di's co' mbezen par tataa mod ne'lyàade yéc mèna no ne'lyàade lezo' mèna no ne'se'de mèna mod co' ndxàp mèna par ne'tyon'te xtol mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tolo ndxab Jesús loo mèna no loo myen' xin' mté'th Jesús: ―¿Ché' no gu' ne'nda'de cuent cón che'n di's co' mtetaquen loo gu', cà'? Chele' gu' ne'nda'de cuent cón nee di's co' ngolo guniin loo gu'a, ¿xá mod ta' gu' cuent no ten' gu' cón che'n taamas di's co' tolo tetaquen loo mèn, sya? ");
INSERT INTO zamNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Di's co' ngolo mtetaquen loo mèna nee di's ndxè': Mbi' co' ngo biz bin nee di's nac xal mèn co' nde'th di's no co' ngo yalbàn cón che'n di's ndac che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nzo ndxep mèn co' nac xal nzob bin co' ngulàa ro ned. Mèna nee di's nda' mèna lugar ndxòn mèna di's cón che'n di's ndac che'n Diox. Per co'se' ndxàcle' ndxep huiz mbìn mèna di's, no queltàa yende chó mèn tolo lu' loo mèna xal tolo nda di's no xal tolo ndyee di's, látha xaste ndli Mebizya par ndxathla's mèn cón che'n di's co' mbìn mèn co' mbli mden' mèn le'n lezo' mèn xá nac co' ndlya's Diox li mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nzo taamas mèn co' nac xal biz bin co' ngulàa loo yòo quèe, co' nee di's, co'se' mbìn mèn di's ndac che'n Diox, mbìn mèn di's ndac che'n Diox dib nzo yéc mèn no dib nzo lezo' mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mèna nac xal ro'th co' ngulengà. Yende fuers lox ro'tha no ne'nxecte ro'tha arid nen tac yende pá xon' lox ro'th. Le' sya, co'se' ndxàc ngòc nguàal con' loo mèna no ndxàc yalndyub ngu's loo mèna por cón che'n di's ndac che'n Diox, sya, ntlo mèna, ndyoo xà' lezo' mèna loo cón che'n di's ndaca. ");
INSERT INTO zamNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nzo taamas mèn co' nac xal biz bin co' ngulàa le'n huan. Mèna ndxòn di's co' nac di's ndac che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Per látha, más ndxath ndlyux mèn loo yalgon' che'n izlyo' ndxè'. No leque mèn ndli par leque mèn nquedìi mèn loo yalgon' mèn. No sate más ndlya's mèn no ndxòo yéc mèn que no mèn chol con'. Le' sya, ryete xtùuz co' más ndli mèn cón che'n con'a ndli ndxathla's mèn cón che'n di's ndac che'n Diox par tataa mod ne'gàcte mèn xal biz bin co' ta' huax cosech. ");
INSERT INTO zamNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Per nzo ndxep mèn co' ndxòn cón che'n di's ndac che'n Diox, no ndyubdi's mèn co' mbez di's ndac. Mèna nac xal biz bin co' ngulàa loo yòo be'f. Nzo ndxep mèn co' nac xal thìb quèe nzob co' mda' gal psi' quèe nzob. No nzo taamas mèn co' nac xal biz bin co' mda' ayon quèe nzob. No nzo taamas mèn co' nac xal bin co' mda' thìb ayo quèe nzob, co' nee di's, nac nzob bina bin co' mda' más huax cosech. ");
INSERT INTO zamNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ndxab Jesús loo mèn, ne: ―¿Ché' nzo mod tub mèn thìb lampr co' nzo xnìi le'n thìb cajón o tub mèn lampr xàn' thìb lun', cà'? Yende xàa. Ndxe'leque', mèn quetal lampr gáp par tenìi lampr loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na nii loo gu', ne: Yende nec thìb con' co' nzo casloo co' ne'ryo xo'fte loo xnaa. No yende nec thìb con' co' xexte ndxàc co' ne'yathte no co' ne'yènte loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Gu' co' ndxaa'd di's nza par ta' gu' cuent co' huenleque' cón nee di's co' ngue niin loo gu' ndxè', bìn gu' di's co' ngue niin loo gu' ndxè' no fta' gu' lugar yaa'd di's ndxè' le'n lezo' gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ndxab Jesús loo mèn, ne: ―Huen huen bli gu' xtùuz cón che'n di's co' nzi yòn gu' nalle'que'. Tac leque mod co' ndxàp gu' no co' ndli gu' loo hues xtàa gu', leque moda gàp Diox con gu' no li Diox loo gu'. No masre' tolo zib Diox loo gu' xalque' nac co' ndli gu' loo hues xtàa gu', gu' co' nzi yon di's ndxè', que naca li gu' con' ye'rsin', que naca li gu' con' ndac. Diox lique' gàca loo mèn xalque' nac con' mbli mèn loo xtàa mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tac loo mèn co' nda' lugar ndxòn ndac mèn cón che'n di's ndac che'n Diox, loo mèna Diox tolo li más gòn ndac mèna cón che'n di's ndac che'n Diox yiloa. Per ndxe'leque', mèn co' indyalte no mèn co' indub nzade par tolo gòn mèn cón che'n di's ndac che'n Diox, loo mèna Diox sate li par yau' xtùuz mèn no yau' lezo' mèn par gàca loo mèn, por derech, yathla's mèn cón che'n di's ndac co' mbìn mèn no co' mde'th mèn co' ngo yalbàn cón che'n Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ndxab Jesús loo mèn, ne: ―Mod co' ndxar' mèn no mod co' nqueltàa mèn, mèn co' ndyal yòo mèn loo cón che'n Diox par ñibe'pe' Diox loo mèn, nac xal co'se' ngo thìb mbi' biz bin loo yòo. ");
INSERT INTO zamNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Co'se' ngolo mblo mbi' biz bin loo yòo, nda li mbi' descans no ndxàt mbi' no ndxeche mbi' xal nac mod che'n mbi'. Látha, ndri'th thìb huiz no ndri'th tedib huiz co'se' ñee mbi' le' biz bin ngulenle', no nzi roole' bin, no nzi xènle' biz bin. Per ne'ta'de mbi' cuent xá mod nzi roo biz bin no xá mod nzi xèn biz bin. ");
INSERT INTO zamNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Per yòo co' mblo mbi' biz bina, ancualque' ndxàc ña'. Ner ndlyen ña'. Ndxeloa, ndxas bacdò ña'. Yiloa, ndryo yas lad ña'. ");
INSERT INTO zamNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","No co'se' mzinle' tiemp ntlo nguus ña', ntlo moz ngro' moz par ya thop moz cosech tac mzinle' huiz dyop cosech. ");
INSERT INTO zamNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ndxab Jesús loo mèna, ne: ―Nde niin tedib con' loo gu': ¿Xá nee gu' no xá nden' gu' xal nac mod co' tlo queltàa mèn par tyal mèn ñibe'pe' Diox loo mèna, à'? No ¿xá nee gu'? ¿Chó tedib con' tetaquen mod co' yòo mèn loo cón che'n Diox par ñibe'pe' Diox loo mèna, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Pues mod co' tlope' Diox, ñibe'pe' Diox loo mèn gàc nagabte mèn co' tlo yòo loo cón che'n Diox. No con mènate no más li yila's huax mèn loo cón che'n Diox no tyal huax mèn ñibe'pe' Diox loo mèn co' nac che'npe' Diox xal thìb biz bin mostaz co' iñaade naroo co' ngo mèn loo yòo. Gu' ñee le' biz mostaz nac thìb biz más bix co' nzo loo rye biz bin, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tac co'se' ngo mèn biz huan mostaz loo yòo, ndlyen huan mostaz. No más ndryoo nxyèn huan mostaz leque taamas huan no loo con' nayèe co' ngo mèn bin. Le' sya, axta mbin bé' nde càl loo huan mostaza. ");
INSERT INTO zamNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tataa mod mblu' Jesús mèn cón che'n di's ndac che'n Diox con huax di's co' mtetac Jesús loo mèn par gòn ndac mèn di's co' nzote mod gòn mèn no co' nzote mod más ta' mèn cuent cón che'n di's ndaca. ");
INSERT INTO zamNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nec thìb di's ne'ndoodi'ste Jesús loo mèn chele' Jesús intetacte di's loo mèn. Per ndxe'leque', loo myen' xin' mté'th Jesús más ndoo lìte mda' Jesús cuent loo myen' no nambìite ngo xo'f Jesús cón che'n di'sa loo myen'. ");
INSERT INTO zamNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Leque huiza co'se' ngulàa yál' izlyo', Jesús ndxab loo myen' xin' mté'th Jesús: ―Ya' gu' nda na' tedib lad ro lagun ba', ey. ");
INSERT INTO zamNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Sya, taate mblá' myen' xin' mté'th Jesús mèna tya. Mbe' myen' Jesús le'n thìb yòoyaa co' ndub loo lagun tya. No mdoo nque taamas mèn, co' mque no yòoyaa tya, xís Jesús par thidte nda no mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Per láth ngue tetee myen' yòoyaa loo lagun, mtlo mxyo'f thìb mbiido' loo lagun no ale ngo too ol nít loo lagun. No ndoo yòole' nít le'n yòoyaa axta ndoo zèle' nít le'n yòoyaa. ");
INSERT INTO zamNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Láth ndxàc con'a, ale le'le' mde mcal' Jesús. Nax yàt Jesús par xís barc loo thìb almad. Sya, yende izlyo', mblo' myen' mcal' loo Jesús. Ndxab myen': ―Maistr, ¿ché' indyóode U' yòoyaa na' ngue dep le'n nít, cara? ");
INSERT INTO zamNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sya, ngo che Jesús. Gunii Jesús loo mbii no loo nít co' ndxe too loo lagun. Ndxab Jesús: ―Xèe gure gu'. Sya, por derech, xèe ngure nít loo lagun. No xèe ngure mbii. ");
INSERT INTO zamNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ngoloa, ndxab Jesús loo myen' xin' mté'th Jesús: ―¿Chonon susque' anze'f nzyeb gu', à', ey? ¿Xá mod susque' indxàpte gu' yalxla's con daa, yey? ");
INSERT INTO zamNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Per myen' xin' mté'th Jesús sate más mzyeb. No mbez myen' loo xtàa myen': ―¿Chó mbi' nac mbi' ba', cara? ¿Xá mod ale axta mbii no nít ndxòn ro mbi' ba' no ndubdi's mbii no nít ro mbi' ba'? ");
INSERT INTO zamNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pues mzin Jesús tedib lad ro lagun co' nziri' loo xyòn mèn che'n làaz mèn gadar con myen' xin' mté'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Per texal ngro' Jesús le'n yòoyaa, ngro' thìb mbi' co' nzo casloo le'n armit panteón loo Jesús. Loo mbi'a ngo huax xpii ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mbi'a ngo ban le'n armit panteón. No yende chó mèn ngli gan tyen mbi' par tub dó' mèn mbi'. No ne' ne' yen chó mèn ngác quedó' mèn mbi' con caden. ");
INSERT INTO zamNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Huax vez mquedó' mèn ya' mbi' no nii mbi' con caden per ale ndli mbi' gan ncho' mbi' caden. Ale thìb le' thìb le' ndli mbi' caden. No yende chó mèn ngác li gan par gàc nado' mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nque tee bez yèe mbi' ze no yál' le'n yi'x no le'n huan no le'n armit thebol le'n panteón. No ale leque mbi' nguin quèe lad mbi' co'se' nquée mbii che'n xpii ye'rsin'a mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Per co'se' gunèe mbi' tithre' nde Jesús, mque' mbi' carre. Mdub xib mbi' loo Jesús. No mcòo' mbi' yéc mbi' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Sya, mbli xpii ye'rsin' ngrozèe mbi' cabii. No mbli xpii ye'rsin' ndxab mbi' loo Jesús: ―Jesús, xgan' Diox roo Diox xèn co' ñibe' loo ryethe con', ¿chonon nde U' co'te' nzo nu' ndxè', à'? Na'b nu' loo U', por lèe che'n Diox, ne'tetìide U' nu', ndee U'. ");
INSERT INTO zamNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tataa mbli xpii ye'rsin' ndxab mbi' loo Jesús tac Jesús ngue bezle' no ngue ñibe'le' loo xpii ye'rsin' par ryo xpii ye'rsin' loo mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sya, mnibdi's Jesús loo mbi'. Ndxab Jesús loo mbi': ―¿Chó lèel, à'? Le' sya, xpii ye'rsin' co' nzo loo mbi'a mbli ndxab mbi': ―Nu' lèe Legión tac anze'f huax nac nu'. ");
INSERT INTO zamNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sya, xpii co' nzo loo mbi'a mbli nalyat ndxab mbi' loo Jesús par ne'tel'te Jesús xpii ye'rsin'a tedib ned tedib lad le'n yèezya' co' nac làaz mèn gadar. ");
INSERT INTO zamNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Le'xque' tya ndub thìb yii co'te' ngue tee yuhua thìb partid nguch. ");
INSERT INTO zamNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Rye xpii ye'rsin' co' ngo loo mbi' mbli ndxab mbi' loo Jesús: ―Ftel' U' nu' loo nguch co' nzi tee go' par yòo nu' loo nguch. ");
INSERT INTO zamNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Sya, mda' Jesús lugar loo xpii ye'rsin'a. Ngro xpii ye'rsin'a loo mbi'. Ngòo xpii ye'rsin'a loo partid nguch. No por loo rye nguch ne'que' chop mil nguch co' nzi tee yuhua tya. Per co'se' ngòo xpii loo partid ngucha, ryete ngucha mbyùb lad yiia. No ale ngulàa ryete ngucha le'n lagun. Tya nguáp rye nguch nít. No nguth rye chop mil ngucha. ");
INSERT INTO zamNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Le' sya, mèn co' ngue queno ngucha mxon' tant mzyeb mèna. Ngua ta' mèna cuenta loo mèn làth yèez no loo mèn co' ngue zin' huan. Sya, mbi'th tee hui' rye mèna con' co' ngòc. ");
INSERT INTO zamNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Co'se' mzin mèn co'te' nzo Jesús, gunèe mèn ndxe'sleque' ndub mbi' co' mque no mbii che'n rye xpii ye'rsin'a. Noc xable' mbi' ndub mbi'. Sya, sate más mzyeb mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mèn co' gunèe mbi' ndoore' teyac Jesús mbi', mèna mda' cuent con' ngòc loo mbi', mbi' co' mquée mbii che'n xpii ye'rsin'. No mda' mèna cuent xalque' ngòca loo nguch. ");
INSERT INTO zamNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Le' sya, mèna mtlo ndxab loo Jesús li Jesús favor ryo' Jesús, bii Jesús làaz mèna par ned nde Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Co'se' gunèe mbi' co' mque no xpii ye'rsin'a ngòo Jesús le'n yòoyaa par bii Jesús tya, nalyat mna'b mbi' di's loo Jesús par ta' Jesús lugar tyoo nque mbi' xís Jesús par tyee no mbi' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Per ndxe'leque', Jesús ne'ndalte no ne'nda'de Jesús lugar nga nque mbi' xís Jesús. Ale le'le' ndxab Jesús loo mbi': ―Byàa par lizl con mèn co' nac mèn gulizl ba'. No fta' cuent loo mèna ryete con' co' mbli nole' Tad Diox lùu. No fta' cuent xá mod mblyat lezo' Tad Diox gunèe Tad Diox lùu, ndee. ");
INSERT INTO zamNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Sya, mxen mbi' ned. Ndyàa mbi'. Mtlo mbi', mda' mbi' cuenta loo mèn co' nac che'n rye yèezya' che'n làaz mèn decápolis ryete con' xal mbli Jesús loo mbi'. Le' ryete mèn yèez co' mbìn di's co' mda' mbi' cuenta na, ante mbui' rye mèna no ante gunaa rye mèna loo mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Co'se' mbere Jesús, ndye'th Jesús, ngua Jesús par ned le'n yèezya' che'n làaz mèn gadar, ndye'th Jesús loo yòoyaa tedib lad ro lagun co' ne' lèe lagun che'n mèn làaz mèn galile. Tya, mqueltàa huax mèn loo Jesús. No por mqueltàa mèn loo Jesús tya, tyate mbyan' Jesús con mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Látha, mzin thìb mbi' co' ngòc jef che'n thìb sinagog co' ndub le'n thìb yèez co' nziri' gaxte co'te' ngo Jesús. Mbi'a ngro' lèe Jair. Co'se' gunèe mbi' Jesús, mbii gax mbi' loo Jesús. Mdub xib mbi' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","No anze'f nalyat mna'b mbi' di's loo Jesús. Ndxab mbi': ―Tad, rsap daa nax tin liz. Na ndal na'b thìb favor loo U'. Tyee U'. Nda na' lizen. Daa ndlyaz ante xo'f U' ya' U' lad mza' daa. Yac mza' daa. No ryo xban mza' daa. ");
INSERT INTO zamNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Sya, mxen Jesús ned. Nda no Jesús Jair par liz Jair. Le' rye mèn co' nzi no Jesús na, nda nque xís Jesús axta mdí' mèna Jesús tant thìb mèn nda no Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Láth rye mèna ngo thìb xa'got co' mque no yíiz co' nac yíiz ndlyath ren. Le'n rye tiemp co' ndxàc mque no xa'gota yíiza ndxàcle' si' fchop lin'. ");
INSERT INTO zamNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Le'n rye tiempa, anze'f thìb yalnè mden' xa'gota por mbli huax doctor remed xa'. No anze'f thìb tmi mbli xa' gast axta mtho' xa'gota rye con' mque no xa'. Per ne' por chu'th ne'ngyath ndacte xa' con remeda. Ndxe'leque', sate más mxyo yíiza loo xa'gota. ");
INSERT INTO zamNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Co'se' mbìn xa'gota nde'th mèn le' Jesús nde par neda, ngo xa'gota làth rye mèna par ngua gax xa' co'te' nzo Jesús, par ned xís Jesús làth mèna. Látha, xexte mbuàal xa'gota xab Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tataa mbli xa'gota tac ndoore' ndxab xa'gota loo lezo' xa': Chele' daa ante gàal xab Jesús, ngobe'en yac daa. ");
INSERT INTO zamNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Texal ngolo mbuàal xa'gota xab Jesús, mbyau' loo ren co' ndoo lath xa'. No luega mden' xa' mbyac xa' loo yíiz co' mque no xa'. ");
INSERT INTO zamNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Lomisque', mden' Jesús le'n lezo' Jesús le' Diox mteyac thìb mèn yíiz por cón che'n con' roo con' xèn co' ndxàp Jesús la's nii Jesús no la's ya' Jesús. Sya, chàa, mbere Jesús, mbui' Jesús par ned xís Jesús. No mnibdi's Jesús loo mèna. Ndxab Jesús loo mèna: ―¿Chó gu' mbuàal xaben par ned xísen, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Sya, myen' xin' mté'th Jesús ndxab loo Jesús: ―Tad, con que U' ñee le' mèn ngue tí' U' no mbez U' ¿chó mèn mbuàal daa par xísen, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Per Jesús mbui' ndxè' mbui' ba' loo mèna par ñèe Jesús ñeene' chó mèn mbuàal xab Jesús par mbyac mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Látha, xa'gota ante nxi'th ndoo tant mzyeb xa'gota. No nanee xa'gota cón ngòc loo xa'. Sya, xex xex mbii gax xa' loo Jesús. Mdub xib xa' loo Jesús. No mda' xa' cuent rye con' co', lìcque', ngòc loo xa' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús ndxab loo xa'gota: ―Rsapa, lùu mbyacle', ndee, tac ngola'sque'l loon. Byàa. Ne'tyóodel. No huen blo lezo'l. Lùu ya ne'tolode tyac len. ");
INSERT INTO zamNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tatabe' ngue toodi's Jesús con xa'gota co'se' mzin plá mèn guliz mbi' co' nac jef che'n sinagog co' ndub gaxte tya. Ndxab mèn guliza loo mbi' co' nac xud mza': ―Lá'a. Ya ne'tolode li xol maistr. Loo rsap lùu ngolole' guneei. ");
INSERT INTO zamNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Per Jesús ne'nglide cas di's co' ndxab mèn guliz mbi'a loo mbi'. Ndxab Jesús loo mbi': ―Ne'zyebtel por rsapl, ndee. Gola's loon no maste. ");
INSERT INTO zamNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ne'nda'de Jesús lugar loo rye mèna par ya nque mèna xís Jesús par ned liz mbi'. No maste mbe' Jesús Pedr, no Cob, no Juàn co' nac hues Cob par ya no myen'a Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Co'se' mzin Jesús con myen' liz mbi' co' ngòc jef che'n singoga, ñèe Jesús ndxàc thìb con'. No ñèe Jesús ndxón' mèn no mbez yèe mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús ngòo liz mbi'. No asembli Jesús, ndxab Jesús loo mèna: ―¡Susque' thìb ruid ndli gu' no ndxón' gu', yoo! Por part cón chenen, mza' ba' inacte mza' co' nguth. Ndxe'leque', part cón chenen, mza' nax yàt thìb mcal'guth. ");
INSERT INTO zamNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Per co'se' mbìn mèna tataa ndxab Jesús loo mèna, ale mxìis no mèna Jesús. Sya, ndxab Jesús loo mèna: ―Bli gu' favor, gro' gu' par fuer. Sya, ngòo no Jesús xud mza', no xna' mza', no yon myen' xin' mté'th Jesús co' ngua no Jesús par le'n nyòo co'te' nzo'f mza' loo mes. ");
INSERT INTO zamNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Sya, mxen Jesús ya' mza' co' nguth co' nzo'f loo mes. Ndxab Jesús loo mza': ―Talita cumi. Di's ndxè' nee di's: Mza', na ngue nii lool: Goo che. Goo too. ");
INSERT INTO zamNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","No texal ngolo tataa ndxab Jesús loo mza', ngo che mza'. No luega mdee mza'. No pente nzo mza' si' fchop lin' co'se' ngòc con'a loo mza'. Le' mèn co' ngureri'a na, ante mbui' mèna no ante gunaa mèna no ante mzyeb mèna co'se' gunèe mèna le' mza' ngro xban. ");
INSERT INTO zamNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Per Jesús mnibe' yèe loo rye mèn co' ngureri'a par ne'ta'de mèna nec thìb cuent loo nec thìb mèn cón che'n con' co' ngòc loo mza'a. Ngoloa, mnibe' Jesús loo xna' mza' ta' xna' mza' con' hua mza'. ");
INSERT INTO zamNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús mbii liz Jair. Mbere Jesús, ndyàa Jesús co'te' nac yèez co' nac làazpe' Jesús. Ngua no myen' xin' mté'thpe' Jesús Jesús, ne. ");
INSERT INTO zamNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Co'se' ngòc huiz sabd co' ngòc huiz descans tiempa, Jesús mtlo mblu' mèn le'n sinagog mèn. Le' mèn co' mbìn di's co' mblu' Jesús na, ante ngüi' mèna no ante ñaa mèna loo Jesús. No mbez mèna loo xtàa mèna: ―¿Pá ngua té'th mbi' ba' rye di's co' ndyoodi's mbi'? No ¿pá ned ngro' co' ndxác mbi' ba' no yalguzye' co' ndli mbi', cara? ");
INSERT INTO zamNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Na' nanee le' mbi' ba' nac xgan' Mari. No nac mbi' carpinter. Mbi' ba' ndxàc hues Cob. No ndxàc hues mbi' Chè no ndxàc hues mbi' Jud no Mon. No myen'got co' ndxàc fta'n mbi' nzo ban làth na' trè'. Ale leque mèn gulàaz Jesús ndlyàa xyàn lezo' ñèe Jesús. No nden' mèna ilé'de nac con' co' ndli Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Sya, ndxab Jesús loo mèna: ―Nzo huax mèn co' ndli cas no intè'bte mèna mèn co' nde'th di's co' ndxab Diox por nac mèna mèn tith. Per chele' mèn co' nde'th di's co' ndxab Diox nac mèn gulàazpe' mèn, pà li mèn cas mèn co' nde'th di's no pà li mèn guliz mèn co' nde'th di's cas mèn co' nde'th di's xal ndxàca loon con mèn co' nac mèn gulàazpe' dàa. ");
INSERT INTO zamNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","No ne'ngácte Jesús ngli Jesús nec thìb yalguzye' loo mèn gulàaz Jesús. Ante mxo'f Jesús ya' Jesús lad ndxep mèn yíiz par mteyac Jesús ndxep mèn no maste. ");
INSERT INTO zamNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Látha, ante ngüi' Jesús no ante ñaa Jesús loo mèn gulàaz Jesus tac thidtene indlya'ste mèna yila's mèna loo Jesús. No indxàpte mèna yalxla's loo Jesús. Ngoloa, mque tee lu' Jesús rye mèn yèezya' co' nziri' gax loo yèez co' nac làaz Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ngoloa, ngurez Jesús ryete si' fchop myen' xin' mté'th Jesús co' mcui Jesus. Mtlo Jesús, mtel' Jesús chop chop myen' par ya lo myen' yalbàn loo mèn. No mbli Jesús par ngòp myen' con' la's nii myen' no la's ya' myen' par co' myen' xpii ye'rsin' loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","No mnibe' Jesús loo myen' yende cón hue' myen' co'se' tyen myen' ned ya myen'. No maste co myen' thìb bro yaa ya' myen'. Ne'hue'de myen' yex lua' myen'. Ne' ne' hue' myen' tmi. ");
INSERT INTO zamNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","No mnibe' Jesús loo myen' que' myen' yilid co' ngòcte ñaa nii myen'. No hue' myen' ante xab myen' co' nocte myen'. Ne'hue'de myen' chop ned xab myen'. ");
INSERT INTO zamNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ndxab Jesús loo myen', ne: ―Co'se' yòo gu' liz mèn co'te' zin gu', cued gu' liz mèna axtaque' bii gu' le'n rye yèezya' ned ya gu' no axtaque' ryo' gu' le'n rye yèezya' ned ya gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","No chele' chó làaz mèn no liz mèn ne'tyalte mèn ta' mèn lugar yòo gu' no ne'tyalte mèn gòn mèn di's co' gab gu' loo mèn, gro' gu' liz mèna no làaz mèna. Bzib gu' yòoya's co' ndoo nii gu' loo mèna. Con'a nee di's tolo tyub quìi tyub bèel lezo' mèna por con' co' mbli no mèna gu'. Yan' cón che'n mèna loo Diox. Le' Diox tub rez cón che'n mèna co'se' gàc huiza, ne. No co'se' gàc huiz co' tub rez Diox cón che'n mèna, lìcpe' ba'i, na nii loo gu': Más be'te tetìi Diox mèn ciuda Sodom no mèn ciuda Gomor leque loo mèn yèez co' ne'tyalte ta' lugar yòo gu' liz mèna no làaz mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Sya, mxen myen' ned. Ndyàa myen'. Nda lo myen' yalbàn no nda te'th myen' cón che'n di's ndac che'n Diox loo mèn le' mèn na, ndxàal lyàa yéc no ndxàal lyàa lezo' mèn no se' mèn mod co' ndxàp mèn par lyá' mèn loo con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mblo' myen' xin' mté'th Jesús huax xpii ye'rsin' loo mèn, ne. No mtà myen' aceit lad huax mèn. Mteyac myen' mèn yíiz co' mden' chol yíiz, ne. ");
INSERT INTO zamNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nde nxon', mbìn Herod co' ngòc rey con'a. Per máa rye mèn nonle' cón che'n co' ngue tee li Jesús. Sya, ndxab Herod loo mèn co' ndxàc xtàa Herod co' nqueltàa no Herod: ―Peser Juàn Bautist ngro xban làth mèn nguth. Cona, ndli Juàn con' roo con' xèn loo mèn xalte nac con' co' nzo la's nii Juàn no la's ya' Juàn. ");
INSERT INTO zamNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Taamas mèn mbez: ―Lii, co' mde'th di's co' ndxab Diox, na. Taamas mèn mbez: ―Nzo chó xa'gool co' mde'th di's co' ndxab Diox póla ngro xban. ");
INSERT INTO zamNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Co'se' mbìn Herod tataa mbez mèn, Herod ndxab loo mèn: ―Mbi'a nac Juàn Bautist co' mnibe'en ngua cho' solndad yéc, ndyaquen. No nalle' ngro xban Juàn làth mèn nguth, ngobe'en. ");
INSERT INTO zamNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tataa ndxab Herod loo mèn tac ndoore' Herod mnibe' loo solndad ngua que' solndad Juàn lezi'f. No mtedó' solndad Juàn con caden ante por cón che'n Herodi. Herodia ngòc sa'l Lip, hues Herod ndoore'. Ale mbli Herod ngòc Herodi xal xa'gotpe' Herod. Mque no Herod Herodia xal xa'gotpe' Herod. ");
INSERT INTO zamNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tac yalquìite ndxab Juàn Bautist loo Herod: ―Herod, indxàalte que no U' xa'got hues U' ne' ne' gàal U' xa' xal xa'gotpe' U'. ");
INSERT INTO zamNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Per Herodi axta ngòc loc tant ngulàa xyàn lezo' Herodi gunèe Herodi Juàn Bautist. Axta mblya's Herodi leque hora nguth Herodi Juàn por conate no más. Per yende mod ngli Herodi gan nguth Herodi Juàn. ");
INSERT INTO zamNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod mquenap Juàn tac Herod huen huen nanee le' Juàn ngòc thìb mbi' ndac no thìb mbi' nalì no thìb mbi' natú'. Por cona, nzyeb Herod ñèe Herod Juàn. No ne'ngla'de Herod ngli Herodi yalquìi loo Juàn. Más de cona, mastale' inden'te Herod no indxaa'dte Herod di's cón che'n con' co' ngue lu' Juàn loo Herod cón che'n Diox, ndyac lezo' Herod nque nza Herod di's co' ndyoodi's Juàn loo Herod con huen di's no con huen cuent. ");
INSERT INTO zamNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Per Herodi huen ngua tac le'pe' mzyal thìb mod loo Herodi par guth yèe Herodi Juàn. Tac co'se' ngóol lni co' ngòc huiz co' ngóol Herod, huiza mbli Herod thìb yalhua par hua mèn co' ngòc jef loo Herod, no mèn co' ngòc commandant loo Herod, no taamas mèn co' mbli Herod cuent anze'f ntac mèn loo Herod, mèn co' nac mèn co' ñibe' loo mèn gulàaz Galile. ");
INSERT INTO zamNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Le'pe' láth nzi yuhua rye mèna, ngòo mza' co' nac rsap Herodi loo mèn co' nzi yuhuaa. Nde yol' nii mza'. Nde nxon', anze'f ndyac lezo' Herod con mèn co' nzi yuhua rsèa co'se' ñèe Herod no mèna nabe'ste nde yol' nii mza' ngo mza'. Ale con gust ndxab Herod loo mza': ―Mza', bna'b con' ndlya'sl loon. Na tai càal. ");
INSERT INTO zamNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","No mde'th Herod Diox loo mza' no mcàbgòn Herod di's loo mza' le' Herod ta' rye con' lya's mza' càa mza'. Ndxab Herod loo mza' axta rol làaz mèn co' ñibe' Herod ta' Herod càa mza' chele' mza' lya's càai por nabe's ndxol' nii mza' loo mèn co' mqueltàa. ");
INSERT INTO zamNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Sya, yende izlyo', ngro' mza' loo rye mèna. Ngua mza' loo xna' mza'. Ndxab mza': ―May, ¿cón ndlya's U' ña'ben loo Herod, à'? Xna' mza' ndxab loo mza': ―Bna'b yéc Juàn Bautist loo Herod càal. ");
INSERT INTO zamNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sya, yende izlyo', ndye'th mza' loo Herod tedib vez co'te' ndub Herod. Ndxab mza' loo Herod: ―Rey Herod, daa ndlyaz ta' U' yéc Juàn Bautist càan loo thìb plat nalle'que'. ");
INSERT INTO zamNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Per co'se' mbìn Herod tataa ndxab mza' loo Herod, anze'f mxi lezo' Herod. Per máa le' Herod mde'thle' Diox loo mza', ¿lé'?, no mbìn rye mèn co' nziri' no Herod di's co' ndxab Herod loo mza', ¿lé'?, que nzo ne' ñee lezo' Herod, mbli Herod co' mblya's mza', xàa. ");
INSERT INTO zamNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Lueg lueg mtel' Herod thìb solndad. No mnibe' Herod loo solndad ya cho' solndad yen Juàn par ye'th no solndad yéc Juàn loo Herod. ");
INSERT INTO zamNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nda solndad. Ngòo solndad le'n lezi'f. Mblo nde'f solndad yen Juàn. No nabe'ste mdub solndad yéc Juàn loo thìb plat. Ndye'th no solndad yéc Juàn loo Herod. Le' Herod na, mda' yéc Juàn loo mza'. Le' mza' na, ndoole' ngua la' yéc Juàn par mcàa xna' mza'. ");
INSERT INTO zamNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Co'se' mbìn myen' xin' mté'th Juàn le' Juàn nguthle', le' Herod mnibe' loo solndad ngua yuth solndad Juàn, ngua lit myen' thebol Juàn par ngua ca's myen' thebol Juàn. ");
INSERT INTO zamNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ngoloa, ndye'th ryete si' fchop myen' xin' mté'th Jesús co' ngua lu' di's cón che'n Jesús loo mèn. Mqueltàa no myen' Jesús tedib vez. Látha, mda' myen' cuent ryete con' xal mque tee li myen' no mque tee lu' myen' loo mèn ned ngua myen'. ");
INSERT INTO zamNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús ndxab loo myen': ―Ya' gu' nda li na' chu'th descans thìb lugar co'te' ne'ñeede mèn na'. Tataa ndxab Jesús tac anze'f thìb mèn, chó mèn ndyàa no chó mèn nde loo Jesús, axta ne' ne' yen mod hua Jesús con myen' xin' mté'th Jesús mase thìb le' yèth. ");
INSERT INTO zamNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Sya, ante myen' xin' mté'th Jesús, no Jesús, ngòo le'n thìb yòoyaa. Ngua Jesús tedib lugar xà' con myen' xin' mté'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Per huax mèn gunèe nda Jesús par neda. Mblibe' mèna Jesús. Ale mque' mèna carre. Nda tau' mèna loo Jesús co'te' zin Jesús. No ner mèna mzin leque Jesús con myen' xin' mté'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Co'se' ngro' Jesús le'n yòoyaa, anze'f thìb mèn gunèe Jesús nziri'. Mblyat lezo' Jesús gunèe Jesús mèna tac nziri' prob mèna xal mbacxil' co' yende pastor co' nqueno mbacxil'. Sya, mtlo Jesús, mblu' Jesús mèna huax con'. ");
INSERT INTO zamNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Per co'se' mzyèle' izlyo' huiza, myen' xin' mté'th Jesús ngua nee loo Jesús. Ndxab myen' loo Jesús: ―Tad, mzyèle' izlyo' no yende chó mèn nzo ban trè' par ya ti' mèn con' hua mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gunii U' Diox loo mèn ba'. No yiloa, guuz U' loo mèn ya ti' mèn con' hua mèn le'n rye ranch co' nzo le'n huan no le'n rye yèez co' nziri' gax tac yende cón ngue no mèn par hua mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Per Jesús, ndxe'leque,' mcàb. Ndxab Jesús loo myen': ―Gu' nee, xàa. Fta' gu' con' hua mèn ba'. Myen' mcàb loo Jesús. Ndxab myen' loo Jesús: ―Tad, ¿xá nee U'? ¿Ché' tàal thìb mil chop ayo pes pan par hua mèn ba' chele' nu' ya ti' pan par hua mèn ba', à'? ");
INSERT INTO zamNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús ndxab loo myen': ―¿Plá pan ngue no gu', à'? Huaa tee hui' gu', ñeene'. Co'se' ngua tee hui' myen', ndye'th myen'. Ndxab myen' loo Jesús: ―Pente nzo ga'y pan no chop mbèel no maste. ");
INSERT INTO zamNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sya, mnibe' Jesús loo mèna tyub thìb tant thìb tant mèn ndxè' ba' ndxè' ba' loo yiixii co' nzo'f tya. ");
INSERT INTO zamNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","No mdub thìb tant mèn, co' nee di's, thìb ayo mèn no tedib tant mèn, co' nee di's, cho' psi' mèn. No tataa tolo mdub mèn ndxè' ba' ndxè' ba'. ");
INSERT INTO zamNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sya, mxen Jesús rye ga'y pana no ryop mbèela. Látha, mbui' Jesús loo bé'. Ndxab Jesús loo Diox: ―Diox quix U', Diox par pan ndxè' no mbèel ndxè' co' hua nu'. Sya, mchì'x Jesús pana. Thìb le' thìb le' mbli Jesús pana. Ngoloa, mbli Jesús mbyar' pana. No mda' Jesús pana loo myen' xin' mté'th Jesús par qui'th myen' pana loo mèna. No mbli'th myen' ryop mbèel co' mbli Jesús ngòc thìb le' thìb le' co' mbyar' loo mèna, ne. ");
INSERT INTO zamNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nduhua ryete mèna axta plóthe. ");
INSERT INTO zamNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","No co'se' ngolo nduhua mèna, msè myen' xin' mté'th Jesús si' fchop cardor pan no mbèel co' mbyan' xo'f co' mbli Jesús mbyar' no co' mbli Jesús ngòc thìb le' thìb le'. ");
INSERT INTO zamNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","No loo rye mèn co' nduhua pana no mbèela ngòcque' ga'y mil mèn, ante mènbi'. Xà'que' nduhua mèngot no xà'que' nduhua myen' bix. ");
INSERT INTO zamNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sya, láth ngue nii Jesús Diox loo mèn, Jesús mtel' ner myen' xin' mté'th Jesús loo yòoyaa par zin myen' yèez Betsaid ndoore' zin Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Co'se' ngolo gunii Jesús Diox loo mèna, mxen Jesús ned. Nda Jesús loo thìb yii co' ndub gaxte tya par cuez Jesús Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Co'se' ngulàa yál' izlyo' huiza, pente nda tee myen' grolthe loo lagun. Le' Jesús na, thidte mbyan' loo yòo biiz. ");
INSERT INTO zamNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Látha, ñee Jesús xá ndxàc myen'. Ya ne'ñeede myen' xá mod li myen' par tetee myen' yòoyaa tac ngue chep mbii yòoyaa myen' rye lad. Per co'se' ngóol coyor cuar xex xex mzin Jesús loo myen'. Nde tee nii Jesús loo nít loo lagun. Mblya's Jesús sangnguri'th Jesús loo myen' co'te' ndub ca' yòoyaa myen' loo lagun. ");
INSERT INTO zamNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Co'se' gunèe myen' xin' mté'th Jesús nde tee nii Jesús loo nít loo lagun, mbli myen' xtùuz con' mal ñèe myen'. Sya, mtlo myen', mbez yèe myen' ");
INSERT INTO zamNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tac ryete myen' gunèe nde tee Jesús loo nít loo lagun. Per ale ne'ñeede myen' cóna. Cona, mzyeb myen'. Per Jesús gunii loo myen'. Ndxab Jesús loo myen': ―Ne'zyebte gu', ey. Blo gu' valor loo gu'. Daa na. Susque' naze'f gu', yey. ");
INSERT INTO zamNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sya, ngòo Jesús loo yòoyaa co'te' nzo myen'. Ngoloa, xèegà nguled mxyo'f mbii. Le' myen' na, sate más mzyeb no ante mbui' myen' no ante gunaa myen' cón ngòc loo myen' xal ndee tee nii Jesús loo nít loo lagun. ");
INSERT INTO zamNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tataa ngòca loo myen' tac myen' tarte ta' cuent co' huenleque' cón che'n yalguzye' co' mbli Jesús ngòc loo pana por tatabe' naad myen' no tatabe' nguud myen'. ");
INSERT INTO zamNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ngoloa, tolo mtetee myen' barc. Tolo nda tee myen' axta mzin myen' tedib lad ro lagun con Jesús loo xyòn mèn co' nac làaz mèn genesaret. Ro laguna mtedó' myen' yòoyaa lad thìb quèe. ");
INSERT INTO zamNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Per texal ngro' no Jesús myen' le'n yòoyaa, mèn co' nzo tya lueg mblibe' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Sya, mque' mèna carre. Ngua mèna rye yèezya' co'te' nac làaz mèn. No mtlo mèna, nde no mèna rye mèn yíiz loo cami axta co'te' non mèn nzo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","No nde no mèn mèn yíiz pál co'te' ndxòo Jesús no co'te' ndri'th Jesús, que naca ranch, que naca le'n yèez, que naca ned huan. Nguix mèn rye mèn yíiz ro ned co'te' ndri'th Jesús. No nalyat mbez mèn loo Jesús la' Jesús gàal mèn ante xab Jesús. Le' sya, ryete mèn co' ante mbuàal xab Jesús, ale mbyac mèna loo yíiz. ");
INSERT INTO zamNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Látha, mbii gax plá mèn co' nac mèn xley' farise no ndxep mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn loo Jesús. Mèna nac mèn ciuda Jerusalén. Nde mèna par ned ciuda Jerusalén loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mèna gunèe le' ndxep myen' xin' mté'th Jesús ne'ntechte myen' ya' myen' par tyub myen' hua myen'. Nzi yuhua myen' con ya' myen' co' ne'ntechte myen', co' nee di's, taate ya' myen' nzi yuhua myen' pan. Ne'ntechte myen' ya' myen' xal nac costumbr co' ngue no mèn xley' farise ntech mèn ya' mèn ndoore' hua mèn. No por conate mquexù' mque' fals mèna myen' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tac mèn co' nac mèn xley' farise no ryete mèn nación Israel nzi no costumbr no mbed no mèna costumbr che'n mèngool. Tac chele' mèna ne'techte ya' mèn lilleque' ndoore' tyub mèna par hua mèna, más quee lezo' mèna ne'huade mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","No co'se' mbere mèna, ndye'th mèna, ngua ti' mèna loo xbi', ne'huade mèna chele' mèna ne'lide xal nac mod che'n costumbr co' ndxàp mèna co' ntech mèna ya' mèna. No nzore' más mod che'n costumbr co' mbed no mèna co' nac ntech mèna taz, plat, camplor, no taamas yèt co' ndli zin' mèna cosin. No masre' con' ndli mèna. Ale axta lun' co'te' ndxàa mèna, ntech mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Sya, mèn co' nac mèn xley' farise no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, mnibdi's mèna loo Jesús. Ndxab mèna loo Jesús: ―¿Chonon indlide myen' xin' mté'th lùu cas costumbr co' mtan' mèngool loo na', à'? Ale tua'te ya' myen' ndxuhua myen' xít myen' no lua' myen'. Intechte myen' ya' myen'. ");
INSERT INTO zamNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús mcàb loo mèna. Ndxab Jesús: ―Aa. Yende con' niin loo gu'. Bien lal ro Sayi co'se' ndxab Sayi no ngro' di's ro Sayi co' mde'th di's co' ndxab Diox le' gu' anze'f ndxác ntembìi gu' ro gu' no ntembìi gu' xti's gu' loo Diox co'se' mque' Sayi ye's cón che'n gu' loo libr co' nac xti's Diox co' mbez taandxè': Mèn ba' mbez di's guryath no di's guryèn loon con di's co' ndryo' ro mèn. Per con' co' nzo le'n lezo' mèn no con' co' ndli mèn xtùuz ndlu' loon pà li mèn con' guryath no con' guryèn loon. No pà li mèn cas loo cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yende cón ntac co' ndli mèn co'se' ncòo' mèn yéc mèn loon no co'se' mbez mèn lèen, ne, tac ley co' ndlu' mèn no yalñibe' co' ndxàp mèn nac xley' no yalñibe' che'n mèn izlyo'pe' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Guniin di's ndxè' loo gu' tac gu' ndlá' con' co' nac yalñibe' che'n Diox par ne'lide gu' cas co' ñibe' Diox loo gu' par li gu'. Más ndli gu' par ndli gu' costumbr che'n mèngool co' mbed no gu' co' nac co' ntech mèn camplor no taz no plat. No ndli gu' taamasre' con' co' nac leque xal con' ndli gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tataa ndxab Jesús loo mèna: ―Cona, ngue niin loo gu': Más ndlá' gu' co' nac yalñibe' che'n Diox thìb lad loo gu' par tolo ndli gu' ryethe con' co' nac costumbr co' mtan' xudgool gu' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés mnibe' loo mèn nación Israel tiempa co'se' ndxab Moisés taandxè': Gòp gu' mod gunèe gu' xud gu'. No gòp gu' mod gunèe gu' xna' gu'. Le' mèn co' ñii yèe ñii tìi cón che'n xud no cón che'n xna' na, Moisés mnibe' loo mèn guth mèn mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Le' gu' na, ale mbez nzoque' mod gab thìb mbi' loo xud mbi' no loo xna' mbi' taandxè' mod: Pay, May, yende mod lyath non gu' tac ryete con' co' nac con' ngue non co' ndxàpen nac co' mcàbgònen loo Diox, co' nee di's, naca che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tataa mbez gu' loo mèn mastale' huax vez ne'nda'de mèn con'a loo Diox par ngàc con'a che'n Diox. No chele' thìb mbi' gab tataa loo xud mbi' no loo xna' mbi', gu' ndoole' par gab gu' loo mbi': Ya inquinte lyath nol xudl no lyath nol xna'l, ndee. ");
INSERT INTO zamNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Le' sya, con con' ndli gu'a, ndlu' gu' yende cón ntac con' co' nac yalnibe' che'n Diox loo gu' por cón che'n costumbr co' mbed no gu' co' ndli thìb ned gu' no co' ndli tedib ned gu'. No anze'f thìb con' ndli gu' co' lalque' nac xal con' co' ndli gu'a. ");
INSERT INTO zamNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesús ngurez mèn tedib vez. Ndxab Jesús loo mèn: ―Bìn gu' co' ngue toodizen loo gu' ndxè'. No ndlyazen ta' gu' lugar yaa'd di's ndxè' le'n lezo' gu' par ta' gu' cuent cón nee di's ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nde niin thìb con' loo gu': Nec thìb con' co' nac con' ndxuhua mèn indli malte no indlide con' zab loo mèn. Ndxe'leque', rye con' co' ndryo' le'n lezo' mèn no con' co' ndli mèn xtùuz, con'a ndli ntezab mèn no ndli ndxàc mèn mèn ye'rsin' no mèn zab loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Gu' co' nzi yòn di's ndxè' no gu' co' ndxaa'd di's le'n lezo', ften' gu' di's ndxè' le'n lezo' gu' no fta' gu' cuent co' huenleque' cón nee di's di's ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Co'se' mblá' Jesús mèna no ngòo Jesús liz thìb mbi', myen' xin' mté'th Jesús mnibdi's loo Jesús cón che'n di's co' mtetac Jesús loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús ndxab loo myen': ―¿Ché' no gu' inda'de cuent cón nee di's co' mtetaquen loo mèna, cà'? ¿Ché' iñeede gu' no ché' inda'de gu' cuent le' ryete con' co' nac xít mèn no lua' mèn co' ndxuhua mèn ndxòo le'n xti' mèn? No indlide con'a con' ye'rsin' loo mèn par li mèn con' ye'rsin' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tac con' co' ndxuhua mèn indxòode le'n lezo' mèn no le'n xtùuz mèn. Ndxe'leque', le'i ndxòo le'n xti' mèn no le'n pans mèn. Ndxeloa, ndri'tha loo mèna co'se' nda mèn mandad mèn. Tataa ndxab Jesús loo myen' par mblu' Jesús cón che'n di'sa loo myen' le' ryete con' ndxuhua mèn nambìique' nac. ");
INSERT INTO zamNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesús ndxab loo myen' xin' mté'th Jesús, ne: ―Con' co' ndryo' le'n lezo' mèn no con' co' ndli mèn xtùuz, con'a ndli leque mèn ndli con' ye'rsin' loo Diox no ndxàc mèn mèn ye'rsin' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tac le'n lezo' mèn ndryo' chol xtùuz ye'rsin' co' ndli mèn xtùuz, anggab na'i, xtùuz co' ndli mèn co'se' ndlya's mèn li mèn yalburrid; no xtùuz co' ndli mèn co'se' ndlya's mèn cua'n mèn xin' huan mèn; no xtùuz co' ndli mèn co'se' ndlya's mèn guthxù' mèn xtàa mèn; ");
INSERT INTO zamNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","no xtùuz co' ndli mèn co'se' ndlya's mèn li huan' mèn; no xtùuz co' ndli mèn co'se' ndlya's mèn nqueli'th mèn cón che'n xtàa mèn; no xtùuz co' ndli mèn co'se' ndlya's mèn li mèn chol con' ye'rsin; no xtùuz co' ndli mèn co'se' ndlya's mèn quedìi mèn xtàa mèn; no xtùuz co' ndli mèn co'se' indlya'ste mèn thyon mèn loo con' ye'rsin' co' ngue li mèn; no xtùuz co' ndli mèn co'se' ndxàn lezo' mèn ñèe mèn xtàa mèn; no xtùuz co' ndli mèn co'se' ndxòn mèn cuent yix no nteri'th mèn cuent yix loo xtàa mèn; no xtùuz co' ndli mèn co'se' ndye's mèn loo xtàa mèn no nxyal' mèn loo xtàa mèn; no xtùuz co' ndli mèn par li mèn con' co' inda'de taamas mèn cuent cón ngue li mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ryete con' ye'rsin'a ndryo' ndlyen' le'n lezo' mèn par tyub yo'f lezo' mèn par li mèn con' co' ndli mèn xtùuz. No ntezab ryete con'a xtùuz mèn no lezo' mèn par ndxàc mèn mèn zab no mèn ye'rsin' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ngoloa, mbii Jesús tya. Nda Jesús le'n rye yèezya' co' nac yèezya' che'n làaz mèn ciuda Tir no co' nac yèezya' che'n làaz mèn ciuda Sidón. Jesús ngòo liz thìb mbi'. No mblya's Jesús yende chó mèn non nzo Jesús liz mbi'a. Per ne'ngácte Jesús ngàca tataa loo Jesús. No yende mod nga's Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Setilte mbìn thìb xa'got co' ngòc xna' thìb mza' co' mque no mbii che'n xpii ye'rsin' le' Jesús nzo liz mbi'a. Mbi'th xna' mza' loo Jesús. No mdub xib xna' mza' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Xa'gota ngòc thìb xa'got tith. Ngòc xa'gota mèn nación Sirofenis. Mbi'th xa'got loo Jesús. Nalyat mde'b ro xa'gota. Mna'b xa'got di's loo Jesús par ante nii Jesús ryo xpii ye'rsin'a loo mza', rsap xa'got. ");
INSERT INTO zamNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Per Jesús asembli, mtetac Jesús thìb di's loo xa'got. Ndxab Jesús loo xa'got: ―La'a hua myen' ner. Tac ihuente naca teche mèn pan loo myen' par ta' mèn pana hua mbac. ");
INSERT INTO zamNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Per máa xa'got lueg mcàb loo Jesús. Ndxab xa'got: ―Aa, Tad, lìcque' co' nee U' ba'. Yende cón niin loo U'. Per neeque' U', Tad, axta rye mbac co' nzi tee ned ba' nde xàn' mes par nthop mbac rye pedaz pan co' ngobii myen' xàn' mes par hua mbac. Nthop mbac. Ndxuhua mbac. ");
INSERT INTO zamNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sya, ndxab Jesús loo guna': ―Aa, huenque' mcàbl loon xal nac di's co' mtetaquen lool. No mda'l cuent cón nee di's di'sa. Nzoque' mod biil. Ngro'le' xpii ye'rsin' co' ngòo loo rsapl, ndee. ");
INSERT INTO zamNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Co'se' mzin xa'got liz xa'got, gunèe xa'got le' mza' naxle' loo lun'. Le' xpii ye'rsin'a na, ngro'le' loo mza'. ");
INSERT INTO zamNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mbere Jesús, ngro' Jesús le'n rye yèezya' co' nac yèezya' che'n làaz mèn ciuda Tir. Ngua riid Jesús le'n rye yèezya' che'n làaz mèn ciuda Sidón no le'n rye yèezya' che'n làaz mèn decápolis axta mzin Jesús ro lagun co' nziri' loo xyòn mèn co' nac che'n làaz mèn galile tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tya, ngua no mèn thìb mbi' mud loo Jesús. Nde nxon', ncue' nza mbi'. Nalyat mde'b ro mèn. Mna'b mèn di's loo Jesús xo'f Jesús ya' Jesús lad mbi' par teyac Jesús ryop yíiz co' ngue no mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mbe' Jesús mbi'a thìb lad loo mèn par mdyee Jesús cuen ya' Jesús le'n nza mbi'. Ngoloa, mxuc Jesús loo thìb cuen ya' Jesús no mbuàal Jesús looz mbi' con cuen ya' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ngoloa, chàa, mbui' Jesús loo bé'. Mdi' lezo' Jesús. Láth ngue hui' Jesús loo bé', ndxab Jesús: ―Efata, co' nee di's, Fxal'. ");
INSERT INTO zamNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Látha, chàa, mxyal' nza mbi' muda. No mbìn mbi' ruid. No luega, ndxe'sleque' mdoodi's mbi' tac Jesús mbli ngro xban looz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ngoloa, mnibe' yèe Jesús loo mèn yende chó loo mèn ta' mèna cuent con' co' mbli Jesús. Per lugar de gòn mèna di's, yende chó loo mèn nda' mèn cuent, ale sate más co' mbli mèna. Mda' mèna cuent con' mbli Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Le' rye mèn co' nziri' tya na, ante ngüi' mèna no ante ñaa mèna loo con' mbli Jesús. Mbez mèna: ―Ryete con' huenque' mbli Jesús. Ale axta ndli Jesús le' mèn co' ncue' ndxòn di's no ndli Jesús le' mèn mud ndyoodi's. ");
INSERT INTO zamNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Le'xque' le'n huiza, anze'f thìb mèn mqueltàa loo Jesús. Nde nxon', yende cón ngue no mèna par hua mèna. Sya, ngurez Jesús myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ");
INSERT INTO zamNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Anze'f ndlyat lezon ñèen prob mèn co' nziri' ba', cara. Más de cona, ndxàcle' son huiz nziri' mèn ba' con daa no yende cón ngue no mèn par hua mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Chele' daa tel' mèn par bii mèn no tarte hua mèn, tguu's mèn ned bii mèn. Tac nzo ndxep mèn ba' anze'f tith ngro' par nde mèn loon. ");
INSERT INTO zamNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Myen' xin' mté'th Jesús mcàb. Ndxab myen' loo Jesús: ―¿Per xá mod ndlya's U' gàc hua mèn trè' co'te' yende chó mèn nac par ti' mèn con' hua mèn, Tad? ");
INSERT INTO zamNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús mnibdi's loo myen'. Ndxab Jesús: ―¿Plá pan ngue no gu', à'? Myen' mcàb. Ndxab myen': ―Gaz pan no maste ngue no nu'. ");
INSERT INTO zamNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Sya, mnibe' Jesús loo mèn tyub mèn loo yòo. Làth xtau'a, mxen Jesús rye gaz pana. No ndxab Jesús loo Diox: ―Diox quix U', Diox, por pan ndxè'. Ngoloa, mchì'x Jesús gaz pana. Mda' Jesús pana loo myen' xin' mté'th Jesús. Le' myen' na, mbli'th pana loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mque no myen' xin' mté'th Jesús plá mbèelli bix, ne. Jesús mbli léy' mbèelli bixa no mnibe' Jesús loo myen' li'th myen' mbèelli bixa loo mèn, ne. ");
INSERT INTO zamNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sya, ryete mèna nduhua pan no mbèelli bixa axta plóthe mblya's mèn. Ngolo nduhua mèna, mthop myen' gaz cardor le' pan co' mbyan' xo'f loo gaz pan no loo mbèelli bix co' mbli Jesús mbyar'. ");
INSERT INTO zamNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ryete mèn co' nduhuaa, ne'que' thap mil mèn. Ngoloa, gunii Jesús Diox loo mèna. Ndyàa Jesús con myen' xin' mté'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ngòo Jesús le'n thìb yòoyaa con myen' xin' mté'th Jesús. Nda Jesús par le'n rye yèezya' co' nac làaz mèn dalmanut con myen' xin' mté'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Látha, mzin mèn xley' farise loo Jesús. Mtlo mèna, mdoodi's no mèna Jesús. Par gàal di's mèna Jesús, mbli mèna thìb con' par ñee mèna ñeene' ché' tli Jesús con' ndlya's mèna li Jesús. Mna'b mèna loo Jesús li Jesús par gàc thìb con' loo bé' xal thìb con' co' nac yalguzye' loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sya, axta le'n lezo' Jesús mdi' lezo' Jesús. Ndxab Jesús loo mèn co' nziri' loo Jesús: ―¿Chonon ña'b mèn xley' farise co' nziri' go' loon par lin gàc thìb con' xal thìb señ loo bé' co' nac thìb yalguzye' loo mèn ba', yey? Lìcpe' ba'i, na nii loo gu': Nec thìb señ ne'gàcte loo mèn ba' thidtene. ");
INSERT INTO zamNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ngoloa, ngòo Jesús le'n yòoyaa. Ndyàa Jesús tedib lad ro lagun tedib vez. Le' mèn co' ngure no Jesús tya na, tyate mblá' Jesús mèna. Gunee mèna cón che'n mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nde nxon', ne'nte'de lezo' myen' xin' mté'th Jesús nghue' myen' pan. Ante sa pan no maste mque no myen' le'n yòoyaa. ");
INSERT INTO zamNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sya, asembli Jesús. Ndxab Jesús loo myen': ―Anderhuen gu', myen', leque gu' quenap gu' gu' loo dii levadur che'n mèn xley' farise no loo dii levadur che'n Herod co' nac rey. ");
INSERT INTO zamNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Le' myen' xin' mté'th Jesús na, mtlo myen', ndxab myen' loo thìb xtàa myen' no loo tedib xtàa myen': ―¿Ché' por ne'nte'de lezo' na' ndi' na' pan, cona tataa gunee Jesús loo na', cà'? Thìb descuid conai, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Per Jesús mda' cuent no mden' lezo' Jesús cón che'n di's co' gunii myen'. Ndxab Jesús loo myen': ―¿Chonon mbez gu' le' gu' ingue node pan, à'? ¿Ché' axta nalle' tarte ta' gu' cuent co' mbezen loo gu' co' huenleque', cà'? ¿Chonon susque' naad gu' no nguud gu', yoo? ");
INSERT INTO zamNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ingüi'de gu' con ngudloo gu', ndee. No ne' ne' indxòn gu' con' con nza gu'. ¿Ché' ne'tyede lezo' gu' huax con' co' nde teele' ndlin, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Ché', lìcque', ne'tyede lezo' gu' co'se' mchì'xen ga'y pan co' nduhua ga'y mil ante mènbi' no xà'que' nduhua mèngot no myen' bix, cà'? Tiempa, ¿plá cardor le' pan co' be' mbyan' xo'f co' mblin mbyar' mthop gu', à'? Myen' ndxab: ―Lìca, Tad, mthop nu' si' fchop cardor le' pan co' be' mbyan' xo'f. ");
INSERT INTO zamNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Tolo ndxab Jesús loo myen', ne: ―¿Ché' ne'tyede lezo' gu', ne, co'se' mchì'xen gaz pan par nduhua thap mil mèn, plá cardor le' pan co' be' mbyan' xo'f loo gaz pan co' mblin mbyar' mthop gu', à'? Myen' mcàb loo Jesús tedib vez. Ndxab myen': ―Lìca, Tad, mthop nu' gaz cardora tiempa, ne. ");
INSERT INTO zamNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Sya, ndxab Jesús loo myen': ―Ngolo gunee gu'i, xàa. No axta nalle', ¿tarte ta' gu' cuent co' huenleque', cà? ¿Máa yob yéc gu', na? ");
INSERT INTO zamNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ngoloa, mzin no Jesús myen' xin' mté'th Jesús le'n thìb yèez co' lèe Betsaid. Tya, mbi'th no mèn thìb mbi' sieu loo Jesús. Nalyat mde'b ro mèna. Mna'b mèna favor loo Jesús par gàal Jesús ngudloo mbi' sieu par tyub xnìi ngudloo mbi'. Hui' mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sya, mxen Jesús ya' mbi' sieu. Mbe' Jesús mbi' thìb lad ro yèez. Tya, mtà Jesús rsuc Jesús ngudloo mbi'. No mxo'f Jesús ya' Jesús lad mbi'. Ngoloa, mnibdi's Jesús loo mbi'. Ndxab Jesús: ―Mbi, ¿ché' ngue hui'l mase ndxep? ");
INSERT INTO zamNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mbi' co' ngòc sieua mbui' ndxè' no mbui' ba'. Ndxab mbi' loo Jesús: ―Aa. Daa ngue hui' loo mèn co' nziri' go'. Per ngüi'en mèn xal yaa xcàl. No ngüi'en ndyee mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mbere Jesús. Mbuàal Jesús ngudloo mbi' con ya' Jesús tedib vez. Sya, por derech, ndxe'sleque' mbui' mbi' loo ryete con' no ale sandante mbui' mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","No ndxab Jesús loo mbi': ―Ne'yòodel le'n yèez Betsaid luega. Ne' ne' gabl loo mèn yèez con' mbli nonl. Sya, mtel' Jesús mbi'. Ndyàa mbi' par liz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ngoloa, ngua Jesús con myen' xin' mté'th Jesús le'n rye yèezya' che'n làaz mèn ciuda Cesar co' mnibe' thìb mbi' co' lèe Lip. Co'se' ndoo Jesús ned nda Jesús con myen' xin' mté'th Jesús, mnibdi's Jesús loo myen' xin' mté'th Jesús. Ndxab Jesús: ―¿Xá nee gu'? ¿Chó mbez mèn nac daa, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Myen' mcàb. Ndxab myen' loo Jesús: ―Ndxep mèn mbez le' U' nac Juàn Bautist. Taandxep mèn mbez le' U' nac Lii co' mde'th di's co' ndxab Diox. No nzore' taandxep mèn co' mbez: Nzo chó mèngool co' mde'th di's co' ndxab Diox póla nac mbi' ba'. ");
INSERT INTO zamNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sya, mnibdi's Jesús loo myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―¿Gu' à'? ¿Chó mèn mbez gu' nac daa? Sya, chàa, ngro' nxon' Pedr loo Jesús. Ndxab Pedr: U' nac yub Cristpe', Tad. ");
INSERT INTO zamNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Per Jesús ndxab loo myen' xin' mté'th Jesús yende chó loo gabte myen' le' Jesús nac yub Cristpe'. ");
INSERT INTO zamNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sya, mtlo Jesús, noo noo mda' Jesús cuent loo myen' xin' mté'th Jesús. Ndxab Jesús: ―Daa, co' mbal yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo', daa tyactìique'. No tè'b rye mèngool, no mèn co' nac jef loo rye nguley', no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn daa. No ndxab Jesús loo myen' le' rye mèna guth Jesús no co'se' yilo son huiz nguth Jesús, Jesús ryo xban. ");
INSERT INTO zamNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nalì mda' Jesús cuent ndxè' loo myen' xin' mté'th Jesús. Ngoloa, mbe' xà' Pedr Jesús thìb lad. Ale mtlo Pedr, mbyoo Pedr no mco'x Pedr Jesús por ndxab Jesús di'sa loo myen'. ");
INSERT INTO zamNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Per Jesús, chàa, mbere, xèe mbui' Jesús loo myen' xin' mté'th Jesús. Sya, ndxab Jesús loo Pedr: ―Biiche loon, Pedr. Te' nac Mebizya nacl loon. Lùu ndlu' loon ndxàpl mod xal nac mod co' ndxàp Mebizya. Tac lùu indyóode no indlidel xtùuz xal ndli Diox xtùuz. Ndxe'leque', lùu ndli xtùuz xalque' ndli chol mèn izlyo' xtùuz cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sya, ngurez Jesús myen' xin' mté'th Jesús. No ngurez Jesús mèn co' nziri' no Jesús. Ndxab Jesús loo myen' no loo rye mèna: ―Chele' chó gu' ndlya's, lìcque', tyoo nque gu' xísen, leque gu' bli par ne'lide gu' con' co' ndyub yo'f lezo' gu' par li gu'i. Ndxe'leque', gòp gu' lezo' gu' no ñibe' gu' loo lezo' gu' par ne'lide gu' con' co' ndyub yo'f lezo' gu'. No blec lezo' gu' par xec gu' tyactìi gu' co'se' tub ngu's mèn gu' por cón che'n daa ned nda na'. Le' sya, ya' gu' too nque gu' xísen. Nda na'. ");
INSERT INTO zamNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tac mèn co' ante ndoo lezo' ndxath ndxey' no ndxath ndlyux mèn par que no mèn che'npe' mèn ante loo izlyo' ndxè', loo mèna ne'ta'de Diox lugar ban mèn thidtene loo Diox. Per mèn co' lá' ryethe con' co' nac yalndac no co' nac yalgon' che'npe' mèn co' gác li mèn gan loo izlyo' ndxè' por cón chenen no por cón che'n di's ndac co' ndlu' xá mod lyá' mèn loo con' ryes, loo mèna ta' Diox lugar par ban mèna thidtene loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Lomisque' ne, ¿cón co' thìb mbi' no chó yalndac gác li thìb mbi' gan co'se' gàc che'npe' mbi' dib athu loo izlyo' tac chele' mbi' tataa mod li, gab Diox loo mbi'a yende mod yòo ban no mbi' Diox thidtene yiloa? Yende cón li mbi' gan chele' mbi' li tataa, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","No ndlyazen ñee gu' loon. ¿Plál quix thìb mbi' loo Diox par yòo ban no mbi' Diox co'se' ngolo gunii Diox loo mbi' ne'tyalte Diox yòo ban no mbi' Diox, à'? Yende mod li mbi' gan li mbi' tataa, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tac chele' chó mèn co' ndxela'sle' loon thyon loo cón chenen no thyon mèna ta' mèna cuent cón chenen loo mèn co' nac mèn co' thidtene indyubdi'ste loon, mèn co' ncua'n xquin no xtol, daa ne, co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo' ndxè', daa thyon loo Diox por cón che'n mèna co'se' galen loo izlyo' ndxè' con angl co' nac angl natú' no con ryethe con' roo no con' xèn co' ndxàp xuden Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tolo ndxab Jesús loo mèn, ne: ―Lìcpe' ba'i, na nii loo gu': Le' ndxep gu' co' nziri' loon nalle', ne'gathte gu' axtaque' ñèe gu' co'se' gàc huiz co' tlo ñibe'pe' Diox loo mèn loo izlyo' xal nac ryethe con' roo no con' xèn co' nzo la's nii Diox no co' nzo la's ya' Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pente ndxàc xop huiz ndxab Jesús tataa loo mèn, mbe' Jesús Pedr no Cob no Juàn. Nda tyonte Jesús con myen' loo thìb yii roo. Tya, ale nzi huite myen', chàa, mzye' loo Jesús loo myen'. ");
INSERT INTO zamNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Nde nxon', xab Jesús co' noc Jesús ante mquée xnìi no ante nagus bèelleque' gunaa. Gunaa xab Jesús xal xil', co' nee di's, nec thìb xa'got co' nzo loo izlyo' ne'gácte tech lar' ante nagus xal gunaa xab Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Látha, gunèe yon myen'a Lii no Moisés. Ndyoodi's no Lii ryop Moisés Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Sya, ndxab Pedr loo Jesús: ―Maistr, anze'f huen naca nzo na' trè'. ¿Xá nee U'? ¿Ché' toxcua' nu' son ramad? Thìba par yòo U'. Tediba par yòo Moisés. No tediba par yòo Lii. ");
INSERT INTO zamNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Per por mzyeb yon myen' xin' mté'th Jesús, con'a axta ne' ne' ñee Pedr cón tyoodi's Pedr loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Látha, ngulàa beu. Mtau' beu loo ryete xop xa' co'te' ngure xa'. Le'n beua mbyèn thìb di's co' ndxab: ―Mbi' ndxè' nac xgan' daa. Anze'f ngudloon no lezon mbi' co' nac xgan' daa ndxè'. Bìn gu' ro mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Per texal nguát beu, chàa, mbui' ndxè' mbui' ba' myen'. Ya yende chó nac. Ya yende chó ñèe myen' nziri' con myen'. Ante Jesús no maste nzo no myen'. ");
INSERT INTO zamNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Per co'se' ngolo mbii Jesús con myen' tya, no láth nde làa tùub Jesús con myen' le'n yiia, ndxab Jesús loo myen' yende chó loo gab myen' cón che'n con' co' gunèe myen'. Ndxe'leque', mnibe' Jesús loo myen' le' myen' ta' cuent cón che'n Jesús, Jesús co' mbi'th yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo', axta co'se' yilo ryo xban Jesús làth mèn nguth. ");
INSERT INTO zamNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Por cona, xexte ngòc myen'. Le'n lezo'te myen' non myen' cón gunèe myen'a. Per mnibdi'sque' myen' loo xtàa myen'. Ndxab myèn: ―¿Cón nee di's di's co' ngolo gunee Jesús loo na' le' Jesús ryo xban làth mèn nguth, à', cara? ");
INSERT INTO zamNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sya, mnibdi's myen' loo Jesús. Ndxab myen': ―Tad, ¿chónon mbez mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn naquinque' ner Lii yi'th loo izlyo' leque yi'th Crist loo izlyo', à'? ");
INSERT INTO zamNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús mcàb. Ndxab Jesús loo myen': ―Lìcque' le' Lii yi'th ner. Per co'se' yi'th Lii, Lii li nab mèn no te'th Lii loo mèn par ta' mèn lugar no tyal mèn yila's mèn loo Crist no yila's mèn cón che'n Crist yiloa. Per ¿xá nac di's co' ndub loo libr co' nac xti's Diox cón chenen, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo' ndxè'? Loo libr co' nac xti's Diox ndub di's co' ndxab le' daa tactìique', no tè'b mèn daa thìb lad, no xìis no mèn daa, no yáp xyán' mèn ñèe mèn daa. ");
INSERT INTO zamNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Per daa nii loo gu' le' Lii mbi'thle'. No mblile' mèn co' mblya's mèn con Lii xalque' ndub di's loo libr co' nac xti's Diox co' ndlu' cón che'n con' co' mquin ngòcque' loo Lii. ");
INSERT INTO zamNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Texal mzin Jesús con Pedr no Cob no Juàn loo taamas myen' xin' mté'th Jesús, gunèe Jesús nziri' huax mèn loo myen' xin' mté'th Jesús. No nziri' mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn. Noo noo mnibdi's maistra loo myen' cón che'n Jesús. Nen ngure toodi's maistra con myen', ne. ");
INSERT INTO zamNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Per texal gunèe mèna Jesús, ryete mèna ante mbui' no ante gunaa loo Jesús. Mque' mèna carre par ngua nii mèna Diox loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sya, mnibdi's Jesús loo myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―¿Cón nzi toodi's gu' con mèn ba', ey? Susque' nen ngure toodi's gu'. No susque' noo noo ndyoodi's gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sya, mcàb thìb mbi' co' nzo làtha loo Jesús. Ndxab mbi' loo Jesús: ―Maistr, daa ndal no mbyòo daa loo U' trè'. Mbyòo ngue no thìb loo mbii che'n xpii ye'rsin' no ale mbli mbii che'n xpii ye'rsin' ngòc mud mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","No pál co'te' ngue tee mbyòo ndyen mbii che'n xpii ye'rsin' mbyòo no ngobii mbii mbyòo. Látha, ndryo' zib fsin' ro mbyòo. No ndxuhua le mbyòo. Por cona, yende fuerz mbyòo. Daa mna'b loo myen' xin' mté'th U' ba' li myen' favor co' myen' xpii ye'rsin' loo mbyòo. Per ne'ngácte myen' ngli myen'a. ");
INSERT INTO zamNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús ndxab loo ryete mèn co' nziri' loo Jesús: ―Aa que gu' mèn izlyo', pápe' ya gu' gòn gu' di's no yila's gu'. Thidtene nac gu' mèn co' indxela'ste loon no loo con' ndlin. ¿Axta pól tolo naquin go non gu'? No ¿axta pól tolo naquinque' xec daa con gu', yey? Ngoloa, ndxab Jesús loo mbi'a: ―Huàa xi mbyòo. Yi'th mbyòo ndxè'. Ñeene'. ");
INSERT INTO zamNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Sya, nde no mèn mbyòo. Co'se' gunèe xpii ye'rsin' co' ngo loo mbyòoa Jesús, mquée mbii xpiia mbyòo. No mbli mbii par ngobii mbyòo loo yòo. Ale mbixyath mcotloo mbyòo nax mbyòo. No ndryo' zib fsin' ro mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sya, mnibdi's Jesús loo xud mbyòo. Ndxab Jesús: ―¿Pól mtlo ndxàc mxen mbii mbyòo, à'? Xud mbyòo ndxab loo Jesús: ―Anon ndoo xèn mbyòo ngulen yíiz ba' loo mbyòo, Tad. ");
INSERT INTO zamNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Huax vez co'se' ndyen mbii che'n xpii ye'rsin' ba' mbyòo, ngobii mbii mbyòo loo quìi no le'n nít par guth mbii mbyòo. Cona, ndlyazen chele' U', lìcque', ndxác ngo' xpii ye'rsin' loo mèn, bli U' favor. Blo' U' xpii ye'rsin' co' nzo loo mbyòo daa ndxè'. Blat lezo' U' gunèe U' daa con mbyòo daa. No blyath no U' nu', Tad. ");
INSERT INTO zamNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús ndxab loo mbi': ―Chele' lùu yila'spe' loon le' daa ndxác teyac mbyòo, sya, lina. Tac ryethe con' nzoque' mod gàc loo mèn, mèn co' ndxela's loon no co' ndxela's loo con' ndlin. ");
INSERT INTO zamNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sya, ngrozèe xud mbyòo. Ndxab xud mbyòo loo Jesús: ―Ndxelazquen loo U' no ndxelazquen loo con' ndli U'. Blyath no U' daa par toloque' yilazen loo U' xal ndxàala. ");
INSERT INTO zamNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Co'se' gunèe Jesús anze'f thìb mèn mqueltàa loo Jesús, Jesús mbyoo mbii che'n xpii ye'rsin'a. Ndxab Jesús loo mbii che'n xpii ye'rsin'a: ―Xpii mud no xpii cue', na ñibe' lool: Gro' loo mbyòo ndxè'. No ya ne'beredel yòol loo mbyòo ndxè' tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sya, mbli xpii ye'rsin'a par ngrozèe yii ngrozèe den mbyòo. No mbli xpii par mquée mbii mbyòo. Ngoloa, ngro xpii loo mbyòo. Per co'se' mquée mbii che'n xpii ye'rsin'a loo mbyòo, casque' nguth mbyòo. No co'se' ñèe mèn co' nziri' con' ngòc loo mbyòo, ndxab mèna loo xtàa mèn: ―Nguth mbyòo, cara. ");
INSERT INTO zamNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Per ndxe'leque', Jesús mxen ya' mbyòo. Mxít che Jesús mbyòo. No ngo too mbyòo loo rye mèna. Ale mbyac mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ngoloa, ngòo Jesús liz thìb mbi' con myen' xin' mté'th Jesús. Sya, xexte mbe' myen' Jesús thìb lad par mnibdi's myen' loo Jesús. Ndxab myen': ―Tad, ¿xá nee u'? ¿Chonon ne'ngácte nu' ngo' nu' xpii ye'rsin'a loo mbyòoa, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús ndxab loo myen': ―Thìb loo xpii ye'rsin' co' nac xal xpii ye'rsin'a, ne'ryo'de tua'te loo mèn. Naquin cuez mèn Diox no cue xlat mèn. Sya, tataa mod ryo xpii ye'rsin'a. ");
INSERT INTO zamNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Co'se' mbii Jesús liz mbi'a con myen' xin' mté'th Jesús, ngua riid Jesús le'n huax yèezya' che'n làaz mèn galile. No indlya'ste Jesús gòn nec thìb mèn le' Jesús ngue tee par neda. ");
INSERT INTO zamNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tac Jesús ngue lu' myen' xin' mté'th Jesús no ngue ta' Jesús cuent le' Jesús, co' mbi'th yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo' ndxè', Jesús yigaaque' ya' mèn ye'rsin'. No guth mèna Jesús. Per co'se' yilo son huiz mbeth mèna Jesús, Jesús ryo xban. ");
INSERT INTO zamNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Per myen' xin' mté'th Jesús ne'nda'de cuent cón che'n di's co' ngue bez Jesús loo myen'. Ne' ne' indxòn myen' cón nee di'sa. No más de cona, ale mzyeb myen' ñibdi's myen' cón che'n di'sa loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ngoloa, nda Jesús con myen' xin' mté'th Jesús par yèez Capernaum. Co'se' mzin Jesús tya, ngòo Jesús liz thìb mbi'. Tya, mnibdi's Jesús loo myen' xin' mté'th Jesús. Ndxab Jesús: ―¿Chó cón che'n con' ngue toodi's gu' ned nde na', à'? Susque' noo noo ndyoodi's gu' con xtàa gu', ne. ");
INSERT INTO zamNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Per myen' yende chó ngabte loo Jesús tac mzyeb myen' no nthyon myen' tac myen' naneeque' le' myen' nde toodi's ned nde myen' cón che'n chó myen' gàc thìb myen' co' más ñibe'pe' co'se' ñibe'pe' Jesús loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sya, mdub Jesús loo myen' no ngurez Jesús ryete si' fchop myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Chele' chol gu' ndlya's gàc mèn co' tyoo ner loo xtàa gu', no co' tyoo naa, no co' ñibe' loo xtàa gu', nquin gàc gu'a xal thìb moz prob co' nque zin' loo mèn par li gu' sirv loo xtàa gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ngoloa, mxen Jesús thìb mbedbi' chu'th. Mdoo Jesús mbedbi' chu'tha loo myen' xin' mté'th Jesús. Mde's Jesús mbedbi' chu'tha. Ndxab Jesús loo myen': ");
INSERT INTO zamNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Nde niin thìb con' loo gu': Le' mèn co' tyal ta' lugar yòo thìb mbedbi' chu'th xal mbedbi' ndxè' liz mèn ante por lèen, con'a ndlu' le' mèna tyal ta' lugar gòon làth mèna, ne. Le' mèn co' tyal gòon làth mèna, inacte ante loon ndyal mèna nda' mèna lugar gòon làth mèna. Ndxe'leque', con'a ndlu' le' mèna ndyal nda' mèna lugar yòo xuden Diox co' mtel' daa làth mèna, ne. ");
INSERT INTO zamNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Sya, ndoole' Juàn, ndxab Juàn loo Jesús: ―Maistr, nu' gunèe thìb mbi'. Ante mde'th mbi' lèe U', mblo' mbi' mbii che'n xpii ye'rsin' loo mèn. Per com le' mbi' inqueltàa node na', ¿lé'?, nu' ne'nda'de lugar loo mbi' tolo li mbi' con'a. ");
INSERT INTO zamNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Per Jesús ndxab loo Juàn: ―Aa'a. Bla' gu' tolo li mbi' con'a. Ne'cà'de gu' loo mbi'. Tac yende chó mèn nzo co' li gàc thìb yalguzye' ante por mbez mèn lèen no yiloa nazab nii yèe nii tìi mèn cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tac mèn co' inacte ngolo ngola's che'n na', mèna nda' lad che'n na'. ");
INSERT INTO zamNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","No chol mèn co' ta' mase thìb taz nít gu gu' ante por cón che'n lèen, no por nzo gu' loo cón chenen, daa co' nac Crist, lìcpe' ba'i, na nii loo gu', ngue cón che'n con' mbli mèn loo gu'a loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Tolo ndxab Jesús loo mèn: ―Chol mèn co' asendli par cua'n mèn co' nau' loo nau' yéc xtol mèn, mèn co' sete ndxela's loon, más huen gàca loo mèna que' mèn thìb quèe yees yen mèna no cobii mèn mèna le'n níttó' par tataa mod lyux mèna leque tolo li mèna con' ye'rsin' loo mèn co' ndxela's loon. ");
INSERT INTO zamNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Cona, ngue niin loo gu': Chele' gu' ndli cuent no nden' gu' le'n lezo' gu' le' ya' gu', lìcque', ndli par ncua'n gu' xtol gu' no xquin gu' por mdyub yo'f lezo' gu' loo con' ngue no gu', más huen gàca loo gu' cho' gu' ya' gu' par cobii mèn ya' gu' thìb lad tith loo gu'. Tac más huen ngàca loo gu' yòo gu' co'te' yòo ban no gu' Diox thidtene con sate ya' gu' leque lyàa gu' le'n ye'rbìil, co'te' nzo quìi no bèel co' thidtene ne'yu'de, con ryop ya' gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tya, ne'gathte mbey no ne'gathte mbye'th. No ne'yu'de quìi no bèel thidtene. ");
INSERT INTO zamNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","No chele' gu' ndli cuent no nden' gu' le'n lezo' gu', lìcque', ndli nii gu' par cua'n gu' xtol gu' no xquin gu' por mdyub yo'f lezo' gu' ngua gu' co'te' ngua gu', más huen gàca loo gu' cho' gu' nii gu' par cobii mèn nii gu' thìb lad tith loo gu'. Tac más huen gàca loo gu' yòo gu' co'te' yòo ban no gu' Diox thidtene con sate nii gu' leque lyàa gu' le'n ye'rbìil, co'te' ne'yu'de quìi no bèel thidtene, con ryop nii gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tya, ne'gathte mbey no ne'gathte mbye'th. No ne'yu'de quìi no bèel thidtene. ");
INSERT INTO zamNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","No chele' gu' ndli cuent le' ngudloo gu', lìcque', ndli par ncua'n gu' xquin gu' no xtol gu' no par tyub yo'f co' nac con' ye'rsin' le'n lezo' gu' loo con' ngüi' gu', más huen blo' gu' ngudloo gu' no blobii gu' ngudloo gu' thìb lad tith loo gu'. Tac más huen gàca loo gu' chele' gu' yòo co'te' yòo ban no gu' Diox thidtene con sate ngudloo gu' leque lyàa gu' le'n ye'rbìil co'te' ndxetoo quìi no bèel no co'te' ne'yu'de quìi no bèel thidtene. ");
INSERT INTO zamNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tya, ne'gathte mbey no ne'gathte mbye'th. No ne'yu'de quìi no bèel thidtene. ");
INSERT INTO zamNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tac co'se' gàc huiza, ryete mèn co' lyàa le'n ye'rbìil yidin' bèel lad mèn xal co'se' nxob mèn ted yol loo bél' má' co' mbeth mèn póla par mbec mèn bél' má'a loo mes xal thìb ofrend loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Huenque' nac ted tac nazi ted, ¿lé'? Per chele' ted inazide, ¿xá mod tezi mèn con' hua mèn con ted co' inazide, sya? Yende mod gàca tataa, ¿lé'? Gòp gu' lezo' gu' no fquenap gu' gu' loo cón che'n Diox, par ne'yiza'de gu' loo cón che'n Diox no par ne'càbte con' ye'rsin' loo gu' loo cón che'n Diox. Tataa bli gu' xal co'se' ndli mèn co' ndxuth má' co'se' ntoxcua' mèn bél' con ted. Ntezi mèn bél' par ne'yiza'de bél'. Lomisque' ne, ngue niin loo gu': Tataa bli gu' par que tee ban gu' rye nda gu' no rye ndye'th gu' làth xtàa gu', ne, ndee gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ngolo mblu' Jesús di'sa loo mèn no mdoodi's no Jesús mèn, ngro' Jesús le'n yèez Capernaum con myen' xin' mté'th Jesús. Nda que tee Jesús le'n rye yèezya' co' nac làaz mèn jude. No ngua que tee Jesús le'n rye yèezya' co' nac loo xyòn mèn co' naban par ned lad ndlyen huiz co' nziri' ned ro yó'be' Jordán. Tya, mbere mèn, mqueltàa mèn loo Jesús co'te' ngo Jesús. Mbere Jesús, mblu' Jesús mèna xalque' ngòc mod co' ngòp Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sya, ngua gax ndxep mèn xley' farise loo Jesús par asembli mèn ngua gàal di's mèna Jesús par ñee mèna ñeene' ché' tagaa Jesús loo mèna con di's co' gàal di's mèna Jesús xal co'se' ndxegaa chol má' bix loo tramp. Mnibdi's mèna loo Jesús par gòn mèn no ñee mèn ñeene' ché' huen naca, ndyac Jesús, lá' thìb mbi' sa'l mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús mcàb loo mèna. Ndxab Jesús: ―¿Cón mnibe' Moisés loo gu' co' nac ley co' mxo'f Moisés loo gu', à'? ");
INSERT INTO zamNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mèna ndxab loo Jesús: ―Moisés mda' lugar loo nu' toxcua' nu' thìb ye's co' lèe thìb act. Sya, ta' nu' acta loo xa'got nu'. Sya, tataa mod con huen di's no con huen cuent lá' nu' xa'got nu'. ¿Xá neel, Jesús? ¿Ché' huen naca o ché' ihuente nac co' mbli Moisés? ");
INSERT INTO zamNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús ndxab loo mèna: ―Tataa mnibe' Moisés loo gu' li gu' tac Moisés naneeque' no mda'que' Moisés cuent le' gu' anze'f naad lezo' no anze'f nguud lezo' gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Per daa nde nii thìb con' loo gu': Nerleque' co'se' mtlo Diox, mblec Diox no mxèn' Diox ryethe con' loo izlyo', Diox mtoxcua' mènbi' no mèngot co' nac mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Por cona, thìb xa'bi' ryo xà' loo xud xa' no loo xna' xa' par thidte queltàa xa' con xa'got co' gàc xin' sa'l xa' par tyub ban no xa' xa'gota. ");
INSERT INTO zamNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","No co'se' ngolo mqueltàa ryop xa', xa'bi'a no xa'gota, thidte nac ryop sa'l xa' loo Diox. Le' sya, tataa mod ya inacte xa' chop mèn loo Diox. Ndxe'leque', thidte ngòc ryop xa' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Por cona, indxàalte li chol mèn par lá' mèn xtàa mèn co' nac xin' sa'l mèn tac Diox mbli thidte mqueltàa mènbi' con mèngot par gàc xa' xin' sa'l. ");
INSERT INTO zamNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Co'se' ngo myen' xin' mté'th Jesús con Jesús liz thìb mbi', mbere myen', mnibdi's myen' loo Jesús cón che'n di's co' mdoodi's no Jesús mèn xley' farisea. ");
INSERT INTO zamNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Sya, ndxab Jesús loo myen' xin' mté'th Jesús: ―Mènbi' co' lá' xa'got co' nac sa'l mènbi'a, no selya' mènbi'a con tedib xa'got, mènbi'a ngue cua'n xtol co' nac yalburrid loo ner xa'got co' nac sa'lpe' mènbi'a. ");
INSERT INTO zamNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","No chele' thìb xa'got lá' sa'l xa'gota no selya' xa'gota con tedib xa'bi', xa'gota, ne, ngue li yalburrid. ");
INSERT INTO zamNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Látha, nde no mèn co' nac xna' myen' bix ndxep myen' bix loo Jesús par ante gàal Jesús lad myen' bixa par gàc con' ndac loo myen' bixa. Per ndxe'leque', myen' xin' mté'th Jesús ale mtlo myen', mbyoo myen' mèn co' nde no myen' bix par ne'tolode yi'th no mèn myen' bix loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Co'se' gunèe Jesús ngue yoo myen' mèna, ngocloo Jesús loo myen'. Ndxab Jesús loo myen': ―Bla' gu' yi'th myen' bix ba' loon. Ne'càde gu' loo myen'. Tac mèn co' ndxòo loo cón che'n Diox par ñibe'pe' Diox loo mèn, mèna ndxàc xal nac myen' bix ba'. ");
INSERT INTO zamNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Lìcpe' ba'i, na nii loo gu': Mèn co' ne'tyalte yòo loo cón che'n Diox par ñibe'pe' Diox loo mèn no gàp mèna yalxla's loo Diox xalque' ndxàp myen' bix yalxla's loo Diox con dib nzo yéc myen' no con dib nzo lezo' myen', thidtene ne'yòode mèna loo cón che'n Diox par ñibe'pe' Diox loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sya, mde's mcàa Jesús myen' bixa. No mxo'f Jesús ya' Jesús loo myen'. No ndxab Jesús loo myen': ―Daa ngue li gàc con' ndac loo gu' no ngue lin par tyac lezo' gu', ne, ndee. ");
INSERT INTO zamNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Le'pe' tyen Jesús ned par tolo ya que tee Jesús par neda, carre mbii gax thìb mbi' loo Jesús. No sangmdub xib mbi' loo Jesús. Mnibdi's mbi' loo Jesús. Ndxab mbi': ―Maistr Ndac, ¿cón lin no xá mod lin par que non no gàpen yalnaban thidtene co'te' nzo Diox, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús mcàb loo mbi'. Ndxab Jesús: ―¿Chonon mbezl loon anze'f maistr ndac nac daa, à'? Yende chó mèn co', lìcque', nac xa' ndac. Angoluxte yub Diox nac xa' ndac. Chele' lùu indlide cuent no inden'te lezo'l nac daa Diox, axta ne' ne' ñeel loon nac daa maistr ndac. ");
INSERT INTO zamNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Lùu nda'que' cuent no naneeque'l xal ñibe' di's co' ndub loo libr co' nac xti's Diox co' ndxab: Ne'lidel yalburrid. Ne'guthtel mèn. Ne'li huan'tel. Ne'tyè'del loo nec thìb mèn. Ne'quedìidel nec thìb mèn. Gòp mod gunèe xudl no gunèe xna'l. ");
INSERT INTO zamNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mbi' mcàb loo Jesús. Ndxab mbi': ―Maistr, ryete con'a mbliquen anon ndoo xènen no be' ngue lin con'a axta nalle'. ");
INSERT INTO zamNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús mbui' loo mbi'. No mque' lezo' Jesús gunèe Jesús mbi'. Ndxab Jesús loo mbi': ―Nzo thidte con' co' be' ndxàc falt lil, ey. Huàa tho' ryete con' ndxàpl par co'l tmi loo con' ndxàpla. Yiloa, ta'l tmia càa mèn prob. Le' sya, tataa mod que nol taamas con' ndac loo bé'. Yiloa, sya, ndel. Nda na' ned ga que tee'en. No xecl ryethe con' gàc lool co' li no mèn lùu par tethon mèn lùu ante por cón chenen, ndee. ");
INSERT INTO zamNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Per co'se' mbìn mbi' tataa ndxab Jesús loo mbi', anze'f mxi lezo' mbi' no nalyat mde'b ro mbi'. Ndyàa mbi' tac anze'f thìb yalgon' ngòp mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sya, mbui' Jesús dib vuelt loo mèn co' nziri' loo Jesús. No ndxab Jesús loo myen' xin' mté'th Jesús: ―Myen', anze'f nagàn tín' naca, cara, par tyal mèn ric yòo mèn ric loo cón che'n Diox par ñibe'pe' Diox loo mèn ric. ");
INSERT INTO zamNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Per myen' xin' mté'th Jesús ante mbui' no ante gunaa myen' loo Jesús por cón che'n di's co' ndxab Jesús cón che'n mbi'a. Sya, mbere Jesús. Ndxab Jesús loo myen' xin' mté'th Jesús tedib vez: ―Xin'a, susque' nagàn tín' naca par yòo mèn ric loo cón che'n Diox par ñibe'pe' Diox loo mèn ric co'se' más ndxàp mèn yalxla's loo ryethe yalgon' co' ndxàp mèn ric. Tac mèn ric ndli cuent ante por yalgon' co' ndxàp mèn ric no maste gàc ryethe con' ndac loo mèn ric. ");
INSERT INTO zamNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lìcpe' ba'i, na nii loo gu': Más inagànte gàca loo thìb má' co' lèe camell par riid má' co' lèe camell ye'r ngudloo thìb aguj leque yòo mèn co' ndxàp huax yalgon' loo cón che'n Diox par ñibe'pe' Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Co'se' mbìn myen' xin' mté'th Jesús tataa ndxab Jesús, ante mbui' myen' no ante gunaa myen'. No mnibdi's myen' loo xtàa myen'. Ndxab myen': ―Chele'i tatua' nac, ¿chó mèn gác lyá' loo con' ryes, sya? ");
INSERT INTO zamNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús xèe mbui' loo myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Ne'gácte chol mèn li chol mèn par lyá' mèn co' ndxàp xtol loo con' ryes. Per Diox ndxácque'. Tac ryethe con' co' ndlya's Diox li Diox, ndxácque' Diox li Diox con'a. ");
INSERT INTO zamNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Sya, ngro' nxon' Pedr, ndxab Pedr loo Jesús: ―Tad, nu' mblá'ya' ryete con' mque no nu'. Nu' ngue que tee noque' U' ned nque tee U'. ");
INSERT INTO zamNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús mcàb loo Pedr. Ndxab Jesús: ―Lìcpe' ba'i, na nii loo gu': Chol mèn co' lá'ya' liz, no hues, no fta'n, no xud, no xna', no sa'l, no xin', no xyòn ante por cón chenen no maste, no ante por cón che'n di's ndac co' ndlu' xá mod lyá' mèn loo con' ryes, ");
INSERT INTO zamNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","gàc che'n mèna nalle' thìb ayo tant con' loo con' co' mblá'ya' mèna loo izlyo' ndxè' xal liz mèn, no hues mèn, no fta'n mèn, no xna' mèn, no xin' mèn, no xyòn mèn. Gàca loo mèna tataa mastale' gàc tub ngu's mèn mèna. Per co'se' cue tedib cua' izlyo' co' cue yiloa, que no mèna yalnaban thidtene par ban no mèna Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nalle' loo izlyo' ndxè' nzo huax gu' co' nac mèn nación Israel. Gu' nzi li xtùuz anze'f ntac gu' loo Diox. No nzi li gu' xtùuz anze'f mèn roo no mèn xèn nac gu' loo Diox por nac gu' mèn nación Israel. Per ndxe'leque', Diox li le' gu' gàc mèn be'the loo Diox tac Diox ndxecloo ñèe Diox gu'. Per part cón che'n Diox, mèn co' gu' ingode cuent ntac mèn loo Diox, mèn co' inacte mèn nación Israel, Diox li par gàc huax mèna mèn co' más ntac loo Diox leque gu'. No gàc mèna mèn co' más ndyac lezo' Diox ñèe Diox por mbli mèna cas loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Le'pe' le'n huiza, mnibe' Jesús loo lezo' Jesús ya Jesús ciuda Jerusalén. Láth nda quée Jesús con myen' xin' mté'th Jesús, nda Jesús par ned ciuda Jerusalén no ndoo ner Jesús loo myen'. Le' myen' na, ante ngüi' no ante ñaa xá nzo Jesús ned nda Jesús par ciuda Jerusalén. No mzyeb myen' nda nque myen' xís Jesús. Le' sya, ale mbere Jesús, mbe' Jesús rye si' fchop myen' xin' mté'th Jesús thìb lad. Mtlo Jesús, mda' Jesús cuent loo myen' cón che'n xá mod tyactìi Jesús le'n huiza. ");
INSERT INTO zamNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ndxab Jesús loo myen' xin' mté'th Jesús: ―Gu' naneeque' no nda'que' gu' cuent le' na' ndoole' ned. Nda quée na' par ned ciuda Jerusalén co'te' tyenxù' mèn daa, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo'. Mèn co' nac jef loo rye nguley' co' más ñibe' no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, mèna quexù' que' fals daa par ta'xù' mèna daa loo mèn co' inacte mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Xìis xyán' mèn co' inacte mèn nación Israel ñèe mèna daa. No ta' mèna golp daa. Suc mèna rloon. No yiloa, guth mèna daa. Per yilo son huiz co' mbeth mèn daa, daa ryo xban làth mèn nguth. ");
INSERT INTO zamNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sya, látha ngua gax ryop hues Cob Juàn co' ngòc xgan' Zebede loo Jesús. Ndxab ryop hues myen' loo Jesús: ―Maistr, nu' ndlya's li U' thìb favor co' ña'b nu' loo U'. ");
INSERT INTO zamNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús mnibdi's loo myen'. Ndxab Jesús: ―¿Chó favor ndlya's gu' lin loo gu', à', ey? ");
INSERT INTO zamNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Sya, ndxab myen' loo Jesús: ―Tad, favor co' ndlya's nu' li U' nac con' ndxè': Co'se' gàc hor co' ñibe' U' loo mèn nación Israel, fta' U' lugar gàc thìb nu' síndico che'n U' no gàc tedib nu' juez che'n U' par thidte ñibe' no nu' U' loo mèn nación Israel tiempa. ");
INSERT INTO zamNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Sya, ndxab Jesús loo myen': ―Axta ne' ne' ñee gu' cón ngue na'b gu' loon. No axta ne' ne' ta' gu' cuent cón ngue na'b gu' loon, ey. Nibdizen thìb con' loo gu'. ¿Xá nee gu'? ¿Ché' tác gu' no ché' xec gu' tyactìi gu' xalque' gàc yaltìi co' xec daa gàc loon le'n huiz ndxè' co' nac xalque' co'se' gu mèn thìb taz nít cuan' huan nalà, cà'? No ¿ché' tác gu' no ché' xec gu' guth yèe mèn gu' xal guthyèe mèn daa le'n huiz ndxè', cà'? ");
INSERT INTO zamNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Myen' mcàb loo Jesús. Ndxab myen': ―Xec nu'i, Tad. Jesús mcàb loo myen'. Ndxab Jesús: ―Lìcpe' ba'i, gàca loo gu' le' gu' tyactìi tín' xalque' gàc yaltìi tín' loon yé' huize' axtaque' gath gu' xalque' gath daa. ");
INSERT INTO zamNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Per con' co' ndlya's gu' par gàc thìb gu' síndico che'n daa, no tedib gu' gàc juez che'n daa co'se' ñibe'en loo mèn nación Israel, inacte con'a cón chenen par tan lugara loo gu' par gàca tataa loo gu', cara. Ndxe'leque', Diox mbli nab no mbli nèe Diox lezo' Diox chó nac mèn co' gàc síndico che'n daa, no chó mèn co' gàc juez che'n daa co'se' gàc huiz co'se' ñibe'pe'en loo mèn nación Israel yiloa. ");
INSERT INTO zamNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Co'se' mbìn taasi' myen' xin' mté'th Jesús tataa ndxab ryop hues Cob Juàn no tataa ndxab Jesús, ale ngocloo myen' gunèe myen' Cob no Juàn. ");
INSERT INTO zamNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Sya, ngurez Jesús myen'. No ndxab Jesús loo myen': ―Gu' nda'que' cuent no nonque' gu' le' mèn co' nac gobiern loo chol nación dib athu loo izlyo', gobierna ñibe' yèe loo mèn rye naciona. Le' mèn co' nac mèn roo no mèn xèn co' naqueltàa loo gobierna, mèna, ne, nqueltàa con gobierna par tolo nquil' mèna gobiern par sate más ñibe' gobiern loo mèn naciona axta ne' ne' xec prob mèna loo con'a. ");
INSERT INTO zamNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Per ndxe'leque', Diox indlya'ste gàca tataa làth gu'. Le' gu' co' ndlya's gàc más mèn roo no mèn xèn làth gu', gu'a li mandad loo taamas xtàa gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","No chol gu' co' ndlya's ñibe' loo xtàa gu', gu'a ndxàal gàc xal moz loo rye gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tac daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo' ndxè', ne'ngalten par li mèn mandad loon. Ndxe'leque', daa mbal par lin sirv loo mèn no par tan yalnaban daa loo yalguth xal thìb con' co' anze'f ntac par tataa mod gàca le' rye mèn co' yila's loon, mèna que no yalnaban thidtene no lyá' mèna loo con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Sya, mzin Jesús ciuda Jericó. Láth co'se' nda riid Jesús le'n ciuda Jericó con myen' xin' mté'th Jesús, thìb mbi' sieu co' ngro' lèe Bartime ndub na'b gòn loo mèn co' ndri'th par neda. Mbi'a ngòc xgan' thìb mbi' co' ngro' lèe Tim. ");
INSERT INTO zamNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Per co'se' ndxòn mbi' mbez mèn le' Jesús co' nac mèn yèez Nazaret nde riid co'te' ndub mbi', mtlo mbi' sieua, mbez yèe mbi'. Mbez mbi': ―Jesús, U' co' nde bin David co' ngòc rey póla, gulat lezo' U' gunèe U' daa, yey. ");
INSERT INTO zamNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ale huax mèn ale mtlo mbyoo mbi' par yau' ro mbi'. Per ndxe'leque', sate más cabii mbez yèe mbi'. Mbez mbi': ―U' co' nde bin David co' ngòc rey póla, gulat lezo' U' gunèe U' daa, niin. ");
INSERT INTO zamNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sya, nguled Jesús. Ndxab Jesús loo mèn co' nda no Jesús: Huàa rez gu' mbi' sieu ba'. Sya, ngua mèn co'te' ndub mbi'. Ndxab mèna loo mbi': ―Huen blo lezo'l no ftegán lezo'l. Jer, goo too. Jesús ngue bezl. ");
INSERT INTO zamNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Sya, ndxecleque' sab co' mcap mbi' mblobii mbi'. Ngoloa, thìdte nguát mbi' par setilte mzin gax mbi' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sya, mnibdi's Jesús loo mbi'. Ndxab Jesús: ―¿Cón ndlya'sl li nonl, à', ey? Mbi' sieu mcàb. Ndxab mbi': ―Maistr, daa ndlyaz tub U' xnìi ngudloon par ndxe'sleque' hui'en. ");
INSERT INTO zamNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús ndxab loo mbi': ―Nzole' mod biil, ey. Ngudlool mdyuble' xnìi tac ngola'sque'l loon. Leque hora ndxe'sleque' mbui' mbi' sieua. Ngoloa, mdoo nque mbi' xís Jesús. Nda no mbi' Jesús ned nda Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Co'se' nda zin gax Jesús con myen' xin' mté'th Jesús ciuda Jerusalén, gaxte tya nziri' chop yèez bix co' lèe Betfagé no Betañ. Ryop yèeza nziri' loo thìb yii co' lèe yii che'n yaa oliv. Tya, mnibe' Jesús loo chop myen' xin' mté'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ndxab Jesús loo myen': ―Huàa gu' lè'n yèez co' nziri' loo na' ba'. Co'se' yamerle' zin gu' le'n yèez ba', gu' hui' ndoo quedó' thìb burr. Burra nec thìb mèn tarte tyub. Fxac gu' burra. No ye'th no gu' burr loon trè'. ");
INSERT INTO zamNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Chele' chó mèn nibdi's loo gu' chonon ngue xac gu' burr, gab gu' loo mèna: Tad nu' naquin burr. No yiloa, luega tel' Tad nu' par yilá' nu' burr. ");
INSERT INTO zamNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mxen myen' ned. Nda myen'. No gunèeque' myen' ndoo quedó' burr. Ndoo quedó' burr gax cuat thìb puert thìb lad ro ned. Mxac myen' burr. Ndye'th no myen' burr loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Sya, ndxab ndxep mèn co' ngure co'te' ndoo quedó' burra loo myen': ―¿Cón ngue li no gu' burr ba', ngue xac gu' burr ba', à'? ");
INSERT INTO zamNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Sya, mcàb myen' loo mèna xalque' ndxab Jesús loo myen'. Sya, mbla' mèna. Ndye'th no myen' burr loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mbe' myen' burr loo Jesús. No mxo'f myen' xab myen' xís burr. Ngoloa, mdub Jesús burr taate burr. ");
INSERT INTO zamNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Làth xtau'a, huax mèn msil xab mèn xtau' ned. Le' taamas mèn na, mcho' laa yin no ram yaa no yíi. Mdoo mèn rye làaa ro ryop lad ro ned co'te' nda riid Jesús par ned ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sya, mèn co' nda ner loo Jesús delant, no mèn co' nde nque par ned xís Jesús, mtlo mèna, mbez yèe mèna. Mbez mèna: ―¡Ay, Dio's! Anze'f ndyac lezo' mbi' ba' no anze'f mbi' ndac nac mbi' ba'. Mbi' ba' nde por lèe Tad Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Anze'f con' ndac gàc loo mèn co' yòo loo cón che'n Diox par ñibe'pe' Diox loo mèna, tac Diox ñibe'pe' loo mèn por cón che'n thìb mbi' co' nac bin David co' ngòc rey póla. Por cona, mbez na': ―Anze'f Diox roo Diox xèn nac Diox, ne. ");
INSERT INTO zamNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ngoloa, ngòo Jesús ciuda Jerusalén. No ngòo Jesús le'n templ. Ngolo huen huen mbui' Jesús rye lad le'n templ, mxen Jesús ned. Nda Jesús par yèez Betañ con ryete si' fchop myen' xin' mté'th Jesús tac mzyèle' izlyo' huiza. ");
INSERT INTO zamNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ngonìi izlyo' tedib huiz co' nde nquea. Co'se' ngro' Jesús le'n yèez Betañ, mtlo mblyan' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sya, tithre' nde Jesús gunèe Jesús ndoo thìb xan' yaa ngudyuug co' ante nayèe ñaa ndoo laa. Jesús ngua tee hui' loo yaa ñeene' ché' ndoo ngud loo yaaa par hua Jesús. Per yende chó ngud ndoo loo yaaa tac inacta tiemp co' tyoo ngud loo yaa. ");
INSERT INTO zamNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sya, gunii Jesús loo yaa ngudyuug. Ndxab Jesús: ―Nase biizl. Ya yende chó más mèn hua ngud co' ta'l. Myen' xin' mté'th Jesús mbìn di's co' gunii Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ngoloa, mbere Jesús, mzin Jesús ciuda Jerusalén con myen' xin' mté'th Jesús. No co'se' ngòo Jesús le'n templ, mtlo Jesús, mblo' Jesús rye mèn co' ntho' no mèn co' ndi' le'n templ. Ndxecleque' rye con' mblobii Jesús par fuer. Mtexyath Jesús mes che'n mèn co' nsil' tmi. No mtexyath Jesús asient che'n mèn co' ntho' palomxtil'. Ndxec ndxec rye asient co' mdyub mèna mblobii Jesús par fuer, ne. ");
INSERT INTO zamNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ne'nda'de Jesús lugar loo nec thìb mèn, mbere mèn, ngòo mèn che'n mèn le'n templ tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mblu' Jesús di's loo mèn le'n templ. Ndxab Jesús loo mèn: ―Loo libr co' nac xti's Diox ndub di's co' mbez: Lizen nac co'te' cuez mèn rye nación lèen. Per gu', ale ndxe'leque', mbli le' lizen nac xal thìb quèe lyo' co'te' ndxòo ban huan' no co'te' ndxòo casloo huan'. ");
INSERT INTO zamNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Per mèn co' nac jef co' más ñibe' loo rye nguley' no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, mèna mbìn di's co' ndxab Jesús. Sya, mtlo mèna, mcua'n mèna mod guth mèna Jesús tant mzyeb mèna ñèe mèna Jesús. Más de cona, ryete mèn co' nziri' no Jesús ante ngüi' no ante ñaa loo con' ndlu' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Per co'se' ngulàa yál' izlyo' huiza, Jesús mbii le'n ciuda Jerusalén tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Co'se' ngonìi izlyo' tedib huiz co' nde nquea, xtil'leque' nguri'th Jesús con myen' xin' mté'th Jesús par ned ndoo yaa ngudyuuga. Gunèe myen' mbiizle' yaa ngudyuug axta lox yaa ngudyuug no axta loo punt yaa ngudyuug. ");
INSERT INTO zamNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Sya, chàa, mte' lezo' Pedr máa yaa ngudyuuga. Ndxab Pedr loo Jesús: ―Maistr hui' U' nexa. Yaa ngudyuug co' gunii yèe U' no co' mquedèe U' loo ná'a mbiizle'. ");
INSERT INTO zamNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús mcàb. Ndxab Jesús loo myen': ―Gola's gu' loo Diox. No gòp gu' yalxla's loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tac lìcpe' ba'i, na nii loo gu': Le' chol mèn co', lìcque', ndxela's loo Diox, ante gab mèna no ante ñii mèna loo yii ndxè' biiche yii ndxè' trè' no ya tub yii ndxè' le'n níttó', chele' mèna por derech, lìcque', ndxela's no inacte mèna chop loo chop la's mèn loo Diox, le' sya, Diox lique' gàc con' ña'b mèna loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Cona, ngue niin loo gu': Ryete con' co' ña'b gu' loo Diox co'se' mbez gu' Diox, chele' gu' ndxela's le' con' co' ña'b gu' loo Diox li Diox par que no gu' co' ña'b gu' loo Diox, le' sya, ryete con' co' ña'b gu' loo Diox gàcque' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","No chele' chó gu' ngocloo gunèe xtàa gu', no chele' chó gu' be' ndxecloo ñèe gu' xtàa gu' co'se' tlo cuez gu' Diox, fteri'th ftecan' gu' con' co' mbli xtàa gu' loo gu'a. Le' sya, tataa mod, ne, xud gu' co' nzo loo bé' ton' xtol gu' no xquin gu' co' mcua'n gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Per chele' gu' ne'talte yéc gu' no lezo' gu' par teri'th gu' no tecan' gu' xtol chol mèn co' ndli mèn loo gu', le' sya, ne' xud gu' Diox co' nzo loo bé' ne'ton'te xtol gu' no xquin gu' co' mcua'n gu' con mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ngoloa, mbere Jesús con myen' xin' mté'th Jesús. Ndye'th Jesús con myen' par ciuda Jerusalén tedib vez. Per co'se' ñèe mèn co' nac jef co' más ñibe' loo rye nguley', no mèn co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, no mèngool co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nacionpe' Israel le' Jesús ngue que tee le'n templ, ngua gax mèna loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Mnibdi's mèna loo Jesús. Ndxab mèna: ―Gunee loo nu', ¿chó yalñibe' ndxàpl no chó mnibe' lool mblil con' co' mblil ná'a, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús mcàb loo mèna. Ndxab Jesús: ―Na, ne, nibdi's thìb con' loo gu'. Chele' gu' càb loon, sya, na nii loo gu' con chó yalñibe' mblin con' mblin loo gu'a. ");
INSERT INTO zamNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Xá nee gu'? ¿Chó mtel' Juàn Bautist par mbi'th li Juàn bautizar mèn? ¿Ché' Diox mtel' Juàn mbi'th Juàn o ché' chol mèn mtel' Juàn mbi'th Juàn par mbli Juàn bautizar mèn, à'? Fcàb gu' loon. ");
INSERT INTO zamNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sya, leque mèna mtlo, noo noo mdoodi's no mèna xtàa mèna cón che'n di's co' ndxab Jesús loo mèna. Ndxab mèna loo xtàa mèna: ―Chele' na' gab: Diox mtel' Juàn, le' sya, càb mbi' ba' loo na'. Ñee mbi': ¿Chonon ne'ngala'ste gu' loo Juàn, sya? ");
INSERT INTO zamNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","O ¿ché' tab na' loo mbi' ba': Chol mèn izlyo' mtel' Juàn, cà'? Axta ne' ne' ñee mèna cón gab mèna tac mèna mzyeb ñèe rye mèn co' nziri' loo Jesús. Tataa mbez mèna tac mèna naneeque' no mda'que' mèna cuent le' rye mèn co' nziri'a ngola's loo Juàn le' Juàn mdoodi's part cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","No por mzyeb mèna, mcàb mèna loo Jesús. Ndxab mèna: ―Ne'ñeede nu' chó mtel' Juàn, cara. Sya, ndxab Jesús loo mèna: ―Ne' daa ne'niide loo gu' con chó yalñibe' mblin con' co' mblin ná'a. ");
INSERT INTO zamNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sya, mtlo Jesús, mdoodi's Jesús loo mèn. No mtetac Jesús di's. Ndxab Jesús loo mèn: ―Nde niin thìb con' loo gu', ey: Ngo thìb mbi' co' mdoo ampurte lus uv loo xyòn mbi'. Ngoloa, mblo mbi' yaaloo dib vuelt ro yòo co'te' mdoo mbi' lus uv. Mtoxcua' mbi' thìb tanc co'te' tí' moz uv par ryo' nít uv. No mbli mbi' mandad mdyoxcua' thìb cuart co' mdub axta arid gáp par gáple'que' la's moz loo zin' no loo yòo co'te' nzo'f lus uva. Ngoloa, mda' mbi' xyòn mbi' loo tedib mèn par li mèn zin' cuent rol loo xyòn mbi'. Ngoloa, mxen mbi' ned. Nda mbi' thìb viaj tith. ");
INSERT INTO zamNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Co'se' mzin tiemp gàc rol uv, mbi'a mtel' thìb moz mbi' par yi'th càaya' moz uv co' li rol mèn co' ngue li zin' cuent rol par gàc che'n mbi' uv. ");
INSERT INTO zamNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Per mèn co' mbli zin' loo yòo co'te' mxyo'f lus uv, mèna mxen moz no mdin mèna moz. No mtel' mèna moz nague's ya' moz ndyàa moz. Ne'nda'de mèna uv nghue' moz. ");
INSERT INTO zamNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Sya, mbi' co' nac xuan' yòoa mbere mtel' tedib moz. Per mèn co' mbli zin' loo yòoa, mbuaa'd quèe moz. Mblé' mèna yéc moz. No mxìis no mèna moz axta plóthe. Ngoloa, taate moz ndyàa moz. ");
INSERT INTO zamNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mbere mbi' co' nac xuan' yòoa. Mtel' mbi' tedib moz par mbi'th moz loo mèna. Per mèna mxen moz. Mbeth mèna moz. Ngoloa, mtel' mbi' co' nac xuan' yòoa huax moz loo mèna. Lomisque' mbli mèn. Chó moz mbuaa'd quèe mèn. Chó moz mbeth mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Per mbi' co' nac xuan' yòo lus uv ngue no thìb xgan' co' nac angoluxte xgan' mbi'. Xgan' mbi'a anze'f ngudloo mbi' no anze'f lezo' mbi'. Por lult mtel' mbi' xgan' mbi' loo mèna. Ndxab mbi' loo lezo' mbi': Tel'en xgan' daa ndxè'. Daa ngobe' li mèna cas no gàp mèna mod ñèe mèna xgan' daa ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Per co'se' gunèe mèn co' ndli zin' loo lus uv nde mbyòo loo mèna, ndxab mèna loo xtàa mèna: ―Mbyòo ba' yan' no yòo lus uv ndxè'. ¿Xá nee gu'? Nda yuth na' mbyòo. Sya, gàc che'n na' yòo lus uv ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ale mxen mèna xgan' mbi'a. Mbeth mèna xgan' mbi'. Ngoloa, mblo' mèna thebol xgan' mbi' thìb lad ro yòo co'te' nzo'f lus uv. ");
INSERT INTO zamNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Sya, mnibdi's Jesús loo mèna. Ndxab Jesús loo mèna: ―¿Xá nee gu'? ¿Cón li mbi' co' nac xuan' xyòn lus uva con mèna, à'? Na nii loo gu' cón li mbi'. Mbi' yi'th. No guth mbi' mèna. No ta' mbi' xyòn mbi' co'te' nzo'f lus uva loo tedib cua' mèn co' ndli leque zin'a, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ché' tarte lab gu' loo libr co' nac xti's Diox par ta' gu' cuent xal mbez di'sa, cà'? Di's co' ndub loo libr co' nac xti's Diox mbez taandxè': Le' quèe co' mbli mèn co' nac albañil cuent ne'li zin'te albañil, leque quèea ngòc quèe ngua lit Tad, Tad co' ngòc xal thìb albañil par ngòc quèea ner quèe co' mbli sirv loo zin' co' mbli Tad. ");
INSERT INTO zamNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","No con' co' ngòca mbli yub Tad Diox. Por cona, por part cón che'n na', ante ngüi' na' no ante ñaa na' xá mod nac con' co' mbli Tad Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Co'se' mbìn mèna tataa ndxab Jesús, capas mèna, ale ndyac mèna mxenle' mèna Jesús xal ndyen mèn thìb pres tac mèna mda' cuent no mden' mèna di's co' ndxab Jesús tac por cón che'n mèna mtetac Jesús di'sa. Per com le' mèna mzyeb ñèe mèn co' nziri' loo Jesús, ¿lé'?, xexte mblá' mèna Jesús. Ndyàa mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ngoloa, mtel' mèn co' nac jef co' más ñibe' loo nguley', no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, no mèngool co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel ndxep mèn xley' farise no ndxep mèn co' nac partid che'n Herod loo Jesús par aseli mèna yecloo Jesús no gab Jesús ngòc nguàal di's loo mèna par tataa mod quexù' que' fals mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Sya, ngua mèna loo Jesús. Ndxab mèna loo Jesús: ―Maistr, nu' nanee lìcque' nac co' mbez U'. No ne' ne' indli U' cas co' ndli mèn no co' mbez mèn. Tac indla'ste U' xal nac mod co' ndxàp mèn. Ndxe'leque', ndlu' U' co' nac lìcpe' xá mod yòo mèn loo cón che'n Diox. Per nalle', ndlya's nu' ñee U' loo nu': ¿Xá nee U'? ¿Ché' ndxàal quix nu' cón che'n contribución loo gobiern federal che'n mèn ciuda Rom o ché' indxàalte quix nu'i? ");
INSERT INTO zamNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Per Jesús mda'que' cuent no nonque' Jesús xá nac mod co' ndxàp mèna co'se' ntembìi ro mèna no ntembìi xti's mèna loo Jesús. Sya, ndxab Jesús loo mèna: ―¿Chonon ncua'n gu' mod asendli gu' par yigaa daa loo gu' xal co'se' ndxegaa mèn loo tramp, à'? Huàa xi gu' thìb pes gu' par hui'en ñeene' xá ñaai. ");
INSERT INTO zamNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Sya, ngua xi mèna thìb pes pchò. Co'se' gunèe Jesús pesa, mnibdi's Jesús loo mèna. Ndxab Jesús: ―¿Chó che'n gunab co' ngue loo pes ndxè'? no ¿chó che'n lèe co' ngue loo pes ndxè', ne, à'? Sya, ncàb mèna loo Jesús. Ndxab mèna: ―Gunab ba' no lèe ba' nac che'n gobiern co' ndub ciuda Rom. ");
INSERT INTO zamNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sya, ndxab Jesús loo mèna: ―Pues, fta' gu' co' nac che'npe' gobiern co' ndub ciuda Rom càa gobiern. No fta' gu' co' nac che'npe' Diox càa Diox. Ngoloa, ante mbui' mèna no ante gunaa mèna loo Jesús xal nac di's co' mcàb Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ngoloa, ngua ndxep mèn xley' saduce co' mbez no co' ndxela's le' mèn nguth ne'ryo xbante thidtene loo Jesús. No por cona, asembli mèna, mnibdi's mèna thìb con' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ndxab mèna loo Jesús: ―Maistr, Moisés mtan' ye's co' ndlu' loo nu' chele' thìb mbi' gath no yan' sa'l mbi', yende xin' sa'l mbi', le' sya, hues mbi' co' ngutha selya' con xa'got viud co' mbyan'a par que no hues mbi' co' ngutha xin' hues mbi' co' ngutha con xa'got viud co' mbyan' co' nac sa'l thebol par gàc xin' hues thebol xin' thebol co' nguth. ");
INSERT INTO zamNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tolo ndxab mèna loo Jesús: ―Pues ngo gaz hues myen'. Mzin huiz mselya' mbyòo ndlyoa. Per pente ndxàc chop o son lín' mselya' mbyòo ndlyoa, nguth mbyòo ndlyoa. Ne'ndante xa'got co' ngòc sa'l mbyòo xin' mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ngoloa, mselya' mbyòo co' nde nque xís mbyòo ndlyoa con xa'got viuda. Nguth mbyòo ropa, ne. No ne'ndante xa'got viuda xin' mbyòo. Lomisque' ngòca loo tedib mbyòo co' nde nque xís mbyòo ropa, ne. ");
INSERT INTO zamNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Por lult ryete gaz hues myen' mselya' con xa'got viuda. Ale ne'ndante xin' xa'got viuda con nec thìb rye myen' hues thebol co' ngòc sa'lpe' xa'gota. Por lult, guneei loo xa'got viuda, ne. ");
INSERT INTO zamNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Cona ngue nibdi's nu' loo U': Co'se' gàc huiz co'se' ryo xban mèn co'se' cue ban mèn tedib vez, de loo rye gaz hues myen' co' mselya' con xa'gota, ¿chó myen' gàc sa'lpe' xa'got viuda, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sya, mcàb Jesús loo mèna. Ndxab Jesús: ―Susque' ndxos xtùuz gu' no susque' yéc brèl gu'. Ndxàc con' ba' loo gu' tac ne'ta'de gu' cuent cón mbez di's co' ndub loo libr co' nac xti's Diox. No ne' ne' ta' gu' cuent con' co' nac con' roo no con' xèn co' nzo la's nii Diox no co' nzo la's ya' Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tac co'se' ryo xban mèn nguth, mèn co' ngòo loo cón che'n Diox, ne'selya'de mèna. Ne' ne' ya na'b mèna xìix mèna. Ndxe'leque', mèna gàc xal angl co' nzo loo bé' huiza, co' nee di's, ne'selya'de mèn huiza. ");
INSERT INTO zamNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Per cón che'n mèn co' nguth co' ryo xban, ¿ché' tarte lab gu' loo libr co' nac xti's Diox co' mque' Moisés ye's xal ngòc di's co' mdoodi's Diox loo Moisés le'n yaa zars co'se' xèe ngue hui' Moisés ndxol' yaa zars? Taandxè' ndxab Diox loo Moisés: ―Daa nac Diox che'n Abraham. Nac daa Diox che'n Isaac. No nac daa Diox che'n Cob. ");
INSERT INTO zamNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Diox inacte Diox loo mèn nguth. Ndxe'leque', nac Diox Diox loo mèn co' be' naban. Por cona, ngue niin loo gu': Axta ne' ne' ñee gu' cón mbez gu' loon no cón ñibdi's gu' loon por nac gu' mèn co' ndxos xtùuz. ");
INSERT INTO zamNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Látha, mzin thìb mbi' co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn. Mbi'a noo noo mque' nza di's co' mdoodi's Jesús con mèn xley' saduce. Mbi' mda' cuent huenque' mcàb Jesús loo mèna. Mnibdi's mbi' loo Jesús. Ndxab mbi': ―De loo rye si' di's co' mnibe' Diox loo na', no co' mtan' Moisés loo na', ¿chó di's nzo làtha co' más ñibe' Diox loo na' par tyubdi's na' loo Diox, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús mcàb loo mbi'a. Ndxab Jesús: ―Ner di's co' más ñibe' Diox loo mèn par tyubdi's mèn loo Diox cón li mèn nac di's ndxè' co' mbez taandxè': Bìn gu' di's ndxè', mèn nación Israel, le' Tad co' nac Diox na', Tada nac thidte Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Fque' lezo' gu' Tad Diox gu', tá, dib nzo yéc gu' no dib nzo lezo' gu'. Di's ndxè' nac ner di's co' mnibe' Diox loo na' par li na'. No nac di's ndxè' co' más ntac loo rye taamas yalñibe' par li na' xal ñibe' Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","No casque' lal nac tedib di's xal ner di's ndxè'. Mbryop di'sa ñibe' loo na' taandxè'. Mbez di'sa: Fque' lezo' gu' gunèe gu' hues xtàa gu' xalque' ngue lezo' gu' ñèe gu' gu'. Ya yende tedib di's co' más mnibe' Diox loo na' co' ndxàal li na' co' nac xal di's co' ñibe' di's ndxè' loo na' par li na'i. ");
INSERT INTO zamNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Sya, ndxab maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn loo Jesús: ―Huenque' gunee U', Maistr. Lìcque' naca xal ngolo gunee U'i ba'. Thidte Diox nzo no yende tedib Diox co' nzo. ");
INSERT INTO zamNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","No que' lezo' mèn Diox dib nzo yéc mèn no dib nzo lezo' mèn, no que' lezo' mèn ñèe mèn hues xtàa mèn xalque' ngue lezo' mèn ñèe mèn mèn. Lìca, masque' ntac li mèn xal ngolo gunee U' leque li mèn xal co'se' nda' mèn che'n izlyo' ncàa izlyo', co' nee di's, co'se' ndxuth mèn ngon yèn' no mbacxil' yèn' par nxo mèn ren má'a loo izlyo'. No, lìcque', más ntac li mèn xal ngolo gunee U' ba' leque li mèn xal co'se' nda' mèn ofrend o gòn co' mbec mèn loo Diox no co' mtec mèn bél' má' co' mbeth mèn loo mes co' nac loo còo' par nquée zen che'n bél' má'a loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Le' sya, co'se' gunee Jesús huenque' mcàb mbi' loo Jesús, ndxab Jesús loo mbi': ―Itithte nzol loo cón che'n Diox par yòol loo cón che'n Diox, ey, par ñibe'pe' Diox lool. Ngoloa, ya yende chó mèn tolo ngli ryes ngnibdi's taamas con' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús ngue lu' mèn le'n templ thìb vez. No mbez Jesús loo mèn: ―¿Xá nee gu'? ¿Xá mod chonon mbez mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn le' Crist nac xgan' David co' ngòc rey póla, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tac Xpii Natú' mbli le' yub David gunii no mde'th David cón che'n Crist. Ndxab David: Tad Diox ndxab loo Tad daa: Ftub cuaten axta lin le' rye mèn co' nac ngolo ngola's che'n lùu gàc nado' loo lùu. ");
INSERT INTO zamNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Cona, ngue niin loo gu': ¿Xá mod gàc Crist xgan' David co'se' leque David mbez loo Crist: Tad daa, à'? Per yende cón mcàb mèna. Rye mèn co' ngòc huax mèn co' nziri'a, axta gust mda' lezo' mèna co'se' mbìn mèna tataa ndxab Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Co'se' ngue lu' Jesús mèn, mbez Jesús loo mèn: ―Nee gu' nee gu' xá que tee gu' loo mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn. Mèna ndyubla's goc xab lar' nol', no anze'f ndubla's mèna ñii chol mèn Diox loo mèna pál co'te' nzyál' mèn mèna par tyu' mèna loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mèna anze'f ndxòo lezo' cua'n mèna lugar co'te' tyub mèna le'n sinagog par gàc con' guryath no con' guryèn loo mèna no par más tyu' mèna loo mèn le'n sinagog. No ndxòo lezo' mèna tyub mèna co'te' más tyu' mèna loo mes par hua mèna co'se' ndxàc chol yalhua. ");
INSERT INTO zamNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ale nde yath mèna ndyenxù' mèna no ncàaxù' mèna liz prob mèngot viud por pláte pes no maste. No par ndli mèna xalque' mèn co' ne'ñeede, ale asendli mèna, nteyol' mèna di's co'se' mbez mèna Diox. Per, lìcpe' ba'i, na nii loo gu': Por con' ndli mèna gàc más yaltìi tín' loo mèna co'se' gàc huiz tub rez Diox cón che'n mèna loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Thìb vez mdub Jesús le'n templ gaxte co'te' nzo'f caj co' ngo mèn ofrend o gòn. Xèe ngue hui' Jesús xá ndxàc mèn ngo mèn gòn le'n caj no xá ndxàc rye mèn ric ngo mèn ric gòn le'n caj. ");
INSERT INTO zamNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Látha, mzin thìb xa'got viud. Xa'got viuda pente mblo chop centav co' ngue no xa' co' be'te ntac le'n caj co' nzo'f tya. ");
INSERT INTO zamNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sya, ngurez Jesús myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Lìcpe' ba'i, na nii loo gu': Le' Diox más ngo cuent cón che'n gòn co' mblo prob xa'got viud ba' le'n caj leque gòn co' mblo mèn ric le'n caj. ");
INSERT INTO zamNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tac ryete mèn ba' mblo huax tmi co' nac gòn le'n caj tac mbyan' xo'f tmi loo mèn ba'. Per prob xa'got viud ba', ale tyan' hualeque' xa', mblo xa' gòn chop centav le'n caj co' nac co' be'te ngue no xa' par ti' xa' con' hua xa'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ngoloa, co'se' nda ro Jesús le'n templ, thìb myen' co' nac xin' mté'th Jesús ndxab loo Jesús: ―Maistr, hui' U' nexa. Susque' nabe's ñaa quèe co' natoxcua' templ no quetal nabe's ñaa templ ba', ne, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Per ale mcàb Jesús loo myen'. Ndxab Jesús: ―Ale xèe ndoo yotl, ngüi'l loo templ ba', ¿lé'? Lùu ndli cuent anze'f nabe's ñaa ftoo co' natoxcua' templ ba', ¿lé'? Per na nii lool: Ya ne'yan'te nec thìb quèe loo xtàa quèe co' nacsua' ftoo ba'. Thidtene telux mèn ryethe con' co' ngüi'l co' natoxcua' templ ba' yé' huize'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sya, ngua no Jesús myen' xin' mté'th Jesús loo thìb yii co' lèe yii che'n yaa oliv. Yiia ndub thìb lì loo templ. No co'se' mdub Jesús tya, Pedr, Cob, Juàn, no Ndech, xexte ndxab myen' loo Jesús: ");
INSERT INTO zamNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Tad, nu' ndlya's ñee U' loo nu' pól gàc co' gunee U' loo nu' gozea cón che'n templ no chó con' tlo yú' loo mèn no co' tlo gàc co'se' tlo gàc co' gunee U' gàca, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús mcàb loo myen'. Ndxab Jesús loo myen': ―Anderhuen gu'. Chó Diox chó nee gu'. Nee gu' nee gu' xá nzi tee gu'. Ne'ta'de gu' lugar quedìi chol mèn gu' cón che'n con' co' tlo gàc co'se' gàc tiemp co' tlo gàc con' xal nac di's co' guniin loo gu' cón che'n templ no cón che'n xá mod lith no izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tac co'se' gàc tiempa, anze'f huax mèn ryo' tee no yi'th que tee mèna yèez por yèez mèn no liz por liz mèn. Mèna ñee le' daa mtel' mèna. No ñee mèna le' mèna nac Crist. Tataa mod anze'f huax mèn quedìi mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Lomisque' ne, co'se' gòn gu' nde'th mèn ndxàc xó', no anze'f ryes naca par tlo xó' le'n tiempa, ne'zyebte gu' co'se' gòn gu' te'th mèn tataa tac tataaque' naquin tlo gàca. Per mastale' tataa gàca le'n tiempa, ne'gàcte tiempa lult huiz co' lyux izlyo' no lith no izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tac le'n tiemp co' tlo gàc co' guniin loo gu'a, mèn thìb nación tlo yecloo no tlo yòo xyàn lezo' mèn ñèe mèn tedib nación. No tlo mèn thìb nación, por derech, cua'n xó' mèna thìb xó' loo mèn tedib nación. Le'n tiempa huin xòo huax lugar. No lyàa huin huax lugar. No tlo yátbèe mèn. Tlo mèn, li mèn thìb revuelt. No con' co' tlo gàca nac thìb yalnaxi no thìb yalnè co' pente tlo par tlo tyactìi tín' mèn loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Anderhuen gu'. Chó Diox chó nee gu'. Leque gu' quenap gu' co'se' tlo gàc con'a le'n tiempa. Le'n tiempa, ale ta'xù' mèn gu' loo mèn nac zin' yòolau chol lugar. No ta' mèn che'n gu' co'te' nac sinagog mèn. Gu' tyooxù' loo mèn co' nac gobernador no loo mèn co' nac rey por cón chenen no maste. Tataa mod más gác gu' no ta'i thìb lugar loo gu' par ta' gu' cuent loo mèn cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Cona, ngue niin loo gu': Ndoore' co'se' lyux izlyo' no lith no izlyo', naquinque' yath yèn cón che'n di's ndac che'n Diox co' ndlu' xá mod lyá' mèn loo con' ryes. No naquinque' co mèn yalbàn cón che'n di's ndac loo mèn, mèn co' nac mèn chol nación co' nziri' dib athu loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","No co'se' hue' mèn gu' par ta' mèn gu' loo mèn nac zin' yòolau chol lugar, ne'tyóode gu', no ne'zyebte gu', no ne' ne' gab gu' loo lezo' gu' cón gab gu' loo mèna. Guuz gu' di's co' lu' Diox loo gu' loo mèna hora. Tac inacte ante gu' co' ñii loo mèna. Ndxe'leque', Xpii Natú' nac xa' co' ñii no co' tyoodi's por ro gu', co' nee di's, co' nac di's co' ryo' ro gu' hora. ");
INSERT INTO zamNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Leque mèn co' ndxàc huespe' cua'n mod par ta'xù' mèna hues mèn par guth mèn hues mèn. No leque mèn co' nac gundan loo mèn cua'n mod par ta'xù' gundan xin' gundan loo mèn par guth mèn xin' gundan. Le' myen' co' nac xgan' gundan na, myen' cua'n mod par bixyath myen' contra xud myen' par ta'xù' myen' xud myen' loo mèn par guth mèn xud myen'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ryete mèn co' nac mèn chol nación, mèna yecloo ñèe gu' por cón chenen no maste. Per chol gu' co' mbli nèeque' gu' loo cón chenen par yòo gu' loo cón chenen axta gath gu', gu'a lyá'que' loo con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Tolo niin loo gu', ne: Le' mbi' co' ngro' lèe Daniel co' mde'th di's co' ndxab Diox, mbi' mque' ye's loo libr co' nac xti's Diox cón che'n thìb mbi' co' li par gàc mèn mèn zab loo Diox no co' li par tyuhuan mèn loo Diox par lyux mèn loo cón che'n Diox. Co'se' ñèe gu' ndoo mbi' zaba co'te' indxàalte tyoo mbi' thidtene, syare' ta' mèn cuent, mèn co' ndlab ye's, chó mbi' nac mbi'a. Le' sya, mèn nación Israel co' nzo le'n yèezya' co' nac làaz mèn jude, mèna ndxàal xyon' par yii no par huan tith ya xon' mèna loo con' ryes co' gàc loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Le' mèn co' nzi tee yéc zote liz mèn huiza na, más huen ne'bilàade mèna par co' mèn mase ndxepte che'n mèn le'n nyòo. Más huen thìb lìte xyon' mèna tith. ");
INSERT INTO zamNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Lomisque' ne, mèn co' ngue zin' huan huiza, más huen ne'ye'thte mèna liz mèna huiza par co' mèna mase xobis mèna liz mèna. Más huen thìb lìte xyon' mèna más tith. ");
INSERT INTO zamNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Lomisque' ne, ay, prob rye mèngot izlyo', mèngot co' nzi nac xin' le'n huiza, no rye mèngot co' nacàa mbeto' co' ndxàaz le'n huiza, tac yende mod xyon' mèna huiza. ");
INSERT INTO zamNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bna'b gu' loo Diox par ne'gàcte tiemp co' xyon' gu'a tiemp xìl', ndee gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tac tiempa gàc huiz co' más ten' mèn yalnè no huiz co'se' más tyac mèn yaltìi. Con' co' gàc tiempa nac co' tarte gàc dib lal naban mèn loo izlyo'. Más de cona, ya ne'berede gàca loo mèn tedib vez xal gàc con'a le'n tiempa thidtene. ");
INSERT INTO zamNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","No chele' Tad Diox ne'nglide par mdyóp tiemp co'se' gàc yaltìia loo mèn, yende chó mèn gác lyá' loo con' ryes. Per por mque' lezo' Diox ñèe Diox mèn, mèn co' ngòo loo cón che'n Diox, mèn co' Diox mcui, por cona, mtedópque' Diox tiempa loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Le' sya, chele' chol mèn ñee loo gu' le'n tiempa: Hui' gu' nexa. Trè' nzo Crist, o hui' gu' nexa, tua' nzo Crist, ne'yila'ste gu'i, ndee gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tac tiempa yi'th huax mèn gutyè' co' ñee loo gu' nac mèna Crist xal daa. No ñee mèna loo gu' nac mèna mèn co' nde'th di's co' ndxab Diox cón che'n Diox. No li mèna gàc huax yalguzye' co' gàc xal thìb señ co' hui' mèn loo mèna. No li mèna huax yalguzye' roo no yalguzye' xèn par quedìi mèna mèn. No axta li mèna preb, ¿ché' tli mèna gan quedìi mèna mèn co' yub Diox mcui par yila's mèn co' Diox mcui loo mèna, ne? ");
INSERT INTO zamNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Per ndxe'leque', nalas gure gu'. Neeque' gu' le' daa guniile' con' ndxè' loo gu' ndoore' gàc con'a loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Tolo niin con' loo gu': Co'se' yilo riid tiemp co'se' ten' mèn yalnèa no yaltìia, syare' gàc tiemp co'se' cuau loo huiz no cuau loo mbe' par ne'tenìide huiz no ne'tenìide mbe' loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Huiza lyàateri' huax mbèelhui' no huax mbyáz loo izlyo'. No ryete con' co' nac con' roo no con' xèn loo bé' tlo huin no xi'th le'n tiempa. ");
INSERT INTO zamNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Axta syare' hui' mèn loon, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo' ndxè', tac tiempa galen loo izlyo' ndxè' tedib vez le'n xcuau con ryethe con' co' nac con' roo no con' xèn co' ndxàpen la's niin no co' ndxàpen la's yan. No hui' mèn xal ndxàc con' roo no con' xèn loon tiempa. ");
INSERT INTO zamNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Leque tiempa, tel'en angl daa par thidte queltàa angl mèn co' ngòole' loo cón chenen, mèn co' nac mèn co' mcuin par ned co'te' nac dyap lad ro izlyo' co' nac más tith ro izlyo' no co' nac más tith xàn' bé'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Bìn gu' di's co' ngue tetaquen loo gu' ndxè', ne: Fté'th gu' no bli gu' xtùuz xal ndxàca loo yaa ngudyuug. Co'se' ndxàb laa loo yaa ngudyuug, no mbere laa yen', xiis laa yen' loo yaa ngudyuug tedib vez, gu' nonque' no nda'que' gu' cuent co'se' nde xiisle' laa loo yaa ngudyuug nde zin' gaxle' tiemp yùu co'se' más nso' bée loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Lomisque' mod ne, co'se' ñèe gu' ndxàcle' ryethe con' loo izlyo' xalque' ngue niina loo gu' ndxè', fta' gu' cuent no ften' gu' nde zin' gaxle' lyux izlyo' no lith no izlyo'. Nac con'a xal thìb mbi' co' ndoo ro ryo' liz mbi' par yòo mbi' liz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Lìcpe' ba'i, na nii loo gu': Ryete con' co' ngue niin loo gu' ndxè' gàcque' no tyaaque' no tyubque' di'sa ndoore' lith no mèn nación Israel no lyux mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Bé' no izlyo' co' nziri' nalle' lyux. Ya ne'tolode cue bé' no izlyo' yé' huize'. Per di's co' ndyoodizen no con' co' ndlu'en ne'ri'thte tua'te. Le'i gàcque', no tyaaque', no tyubque' di'sa xalque' ngue toodizen loo gu' nalle'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Per huiz co'se' gàcpe' con'a no hor co'se' gàcpe' con'a, yende chó mèn nona no yende chó mèn naneei. Ne' yub angl co' nzo loo bé' inaneede pól gàc con'a. Ne' ne' daa co' nac xgan' Diox, inaneeden nalle' coyor gàc con'a. Angoluxte Diox xuden nanee pól gàc tiempa. ");
INSERT INTO zamNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Por cona, ngue niin loo gu': Nalas gure gu'. Ne'gàcte gu' xal mèn co' nzi yàt loo cón che'n Diox. Gurez gu' Diox. Tac gu' inda'de cuent pól zin tiemp co'se' gàc con' co' ngue niin loo gu' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Cón che'n tiemp co' nac tiemp ndoore' co'se' beren, galen loo izlyo' ndxè' tedib vez, nac xal thìb mbi' co' ngro' tee nda viaj tith. Per ndoore' co'se' ryo' mbi' liz mbi', mtan' mbi' di's loo moz mbi' cón li moz. No mtan' mbi' zin' loo thìb thìb moz par li moz zin' láth yende mbi'. No mnibe' mbi' loo moz co' nquenap puert liz mbi' par altant tyoo moz quenap moz liz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Cona, ngue niin loo gu': Nalas gure gu'. No gure naa gu' loo cón che'n Diox. Tac gu' ne'ta'de cuent pól zin Tad, co' nee di's nac daa, co' nac che'n liza. ¿Ché' zin daa hor co' nde làa yál' izlyo' o ché' zin daa gulal yál' o ché' zin daa hor co'se' lé' nguiidtee yál' o ché' zin daa hor co'se' nde yinìi izlyo'? Ne'neede na' coyor gàc con'a, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tac thìb descuid, chàa, galen loo izlyo' ndxè' thìb hor co' ne'ñeede gu' no thìb hor co' indlide gu' xtùuz zin daa. Ale le'le' zin daa loo gu' hor co'se' le'pe' nziri' gu' loo cón che'n Diox xal mèn co' nzi yàt. ");
INSERT INTO zamNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Leque di's co' ngue niin loo gu' ndxè' nac di's co' tan'en loo mèn par ta' mèn cuent cón che'n di's ndaca loo alux mèn dib athu loo izlyo' co' naban chol tiemp. Di'sa nee di's: Nalas cue mèn loo cón che'n Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Le'n huiza, chop huiz no maste ndxàc falt par tlo lni pasc no lni co'se' ndxuhua mèn nación Israel pan co' ingòode mèn dii levadur. Le' mèn co' nac jef che'n nguley' co' más ñibe' loo nguley', no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn na, mèna mcua'n mod par tyenxù' mèna Jesús con purte di's gutyè', no con mod gutyè' co' mdoodi's mèn thidte di's co' ngòc par cua'n mèna mod guthxù' mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","No mbez mèna loo xtàa mèna: ―Ne'lide na' con' ndlya's na' con Jesús le'n huiz lni par ne'xide lezo' mèn no par ne'yátbèede mèn co' yi'th lni contra na'. ");
INSERT INTO zamNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Le'n huiza, ngo Jesús yèez Betañ liz thìb mbi' co' mdub lèe mèn Mon Lepros. Láth ndub Jesús loo mes liz mbi'a, mzin thìb xa'got loo Jesús. Nde no xa' thìb frasc co' natoxcua' con thìb loo quèe co' lèe alabastr. Frasca zyè nzo aceit co' ndlya' purte xla' ye' nard. Aceita anze'f náp ntac. Sya, mblé' xa'gota frasc par mblath xa'gota aceita yéc Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Per ndxep mèn co' ngo tya, mèna ale ngocloo gunèe xa'gota. Ndxab mèna loo xtàa mèna: ―¿Chonon ale ngue teza'xù' xa'got ba' aceit co' anze'f nazi' ndlya', yoo? ");
INSERT INTO zamNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nzoque' mod tho' xa'got aceit ba' por mil xon ayo pes. No yiloa, li'th xa'gota tmi par ta'la's xa'got tmia càa mèn prob. No ale ngòo xyàn lezo' mèna gunèe mèna xa'gota. ");
INSERT INTO zamNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Per Jesús ndxab loo mèna: ―Bla' gu' tee tub xa'got ndxè'. ¿Chonon ngue tethon gu' xa' no ngue li xol gu' xa', à'? Tac con' co' ngue li xa'got ndxè' loon anze'f huen naca. ");
INSERT INTO zamNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gu' thidteneque' nzo làth mèn prob. No nzo mèn prob làth gu'. No nzoque' mod li gu' con' ndac loo mèn prob co'se' ndlya's gu' li gu'i. Per part cón chenen, ya ne'tolode go non gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Prob xa'got ndxè' ngue li co' nzote mod li xa' loon. Xa'got ndxè' ngue go xla' aceit co' anze'f nazi' ndlya' ba' laden ndoore' co'se' ca's mèn daa par ne'yitoode xla' laden co'se' ya ca's mèn daa. ");
INSERT INTO zamNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Lìcpe' ba'i, na nii loo gu': Pál co'te' co mèn yalbàn no te'th mèn cón che'n di's ndac che'n Diox co' ndlu' xá mod telá' Diox mèn loo con' ryes dib athu loo izlyo', ta' mèna cuent cón che'n con' mbli no xa'got ndxè' daa par te' lezo' mèn cón che'n xa'got ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Le' sya, Jud Iscariot, co' nac thìb myen' xin' mté'th Jesús, ngua toodi's no mèn co' nac jef che'n nguley' co' más ñibe' loo nguley' par ñeene' xá mod li Jud par ta'xù' Jud Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Co'se' mbìn mèn co' nac jef che'n nguley' co' más ñibe' loo nguley' di's co' ndxab Jud loo mèna, anze'f mdyac lezo' mèna. No mcàbgòn mèna loo Jud ta' mèna tmi càa Jud co'se' yilo ta'xù' Jud Jesús loo mèna. Leque hora mtlo Jud, mcua'n Jud mod xá mod ta'xù' Jud Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Co'se' ngonìi izlyo' co' nac huiz yub lni co'se' ndxuhua mèn pan co' ingòode mèn dii levadur no co'se' ndxuth mèn mbacxil' co' ndxuth mèn loo Diox co'se' ndxáal lni pasc, huiza myen' xin' mté'th Jesús mnibdi's loo Jesús. Ndxab myen' loo Jesús: ―Tad, ¿pá ndlya's U' li nab nu' thìb lugar par hua rsè na' rsè co' nac che'n lni pasc, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sya, mtel' Jesús chop myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Huàa gu' le'n ciuda Jerusalén ba'. Tua' zyál' gu' thìb mbi' co' ne' thìb rre nít. Ftoo nque gu' xís mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","No co'se' zin mbi' co'te' yòo mbi', yòo gu' con mbi'. Sya, gab gu' loo mbi' co' nac gundan co' nac che'n liza: Maistr nu' gunee di's ndxè' loo nu' par ñee nu' di's ndxè' lool: ¿Pá ndub cuart co'te' gòon par hua rsè'en co' nac rsè pasc con myen' xin' mté'th daa, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Le' sya, mbi' co' nac gundan co' nac che'n yòoa lu' loo gu' pá ndub thìb cuart co' más naroo loo pis gáp liz mbi'. Cuarta mblyo'fle' no mdyoxcua'le'. Tya toxcua' gu' con' hua rsè na' co' nac nte' lezo' mèn pasc. ");
INSERT INTO zamNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Sya, mxen myen' xin' mté'th Jesús ned. Nda myen'. Mzin myen' le'n ciuda Jerusalén. No ngòcque' con' loo myen' xalque' ndxab Jesús loo myen'. Sya, mtoxcua' myen' nítyèth co' hua rsè no myen' Jesús par te' lezo' myen' cón che'n pasc. ");
INSERT INTO zamNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Co'se' ngulàa yál' izlyo' huiza, mzin Jesús con ryete si' fchop myen' xin' mté'th Jesús loo pis gáp co'te' nac cuart liz mbi'a par hua rsè no Jesús myen' tya. ");
INSERT INTO zamNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Co'se' ndub yuhua rsè no Jesús myen' xin' mté'th Jesús loo mes, ndxab Jesús loo myen': ―Lìcpe' ba'i, na nii loo gu' le' thìb gu', co' ngue yuhua no daa, ta'xù' daa loo mèn co' nac ngolo ngola's che'n daa. ");
INSERT INTO zamNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Sya, mxi lezo' myen' xin' mté'th Jesús. No mtlo myen', mnibdi's myen' loo thìb xtàa myen' no loo tedib xtàa myen'. Mbez myen': ―Ne'stolque' daai, yoo. No mbez tedib myen' loo xtàa myen': ―Ne'stolque' daai, yoo. ");
INSERT INTO zamNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús mcàb loo myen'. Ndxab Jesús: ―Thìb gu' co' nzo làth rye si' fchop gu' co' mcuin co' ngue yuhua non thidte plat, gu'a ta'xù' daa loo mèn co' nac ngolo ngola's chenen. ");
INSERT INTO zamNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Huenque' naca, ey, le' daa, co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo', gàca loon xalque' mbez di's co' ndub loo libr co' nac xti's Diox cón chenen. Per ay, prob mbi' izlyo', mbi' co' ta'xù' daa loo mèn co' nac ngolo ngola's chenen. Más huen ngàca loo mbi'a ne'ngáalte mbi' loo izlyo' thidtene leque ta'xù' mbi'a daa loo mèn ye'rsin'a. ");
INSERT INTO zamNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Láth ngue yuhua rsè myen' xin' mté'th Jesús con Jesús, mxen Jesús pan. Ndxab Jesús: ―Diox quix U', Diox, loo Diox. Ngoloa, mchì'x Jesús pan. Mda' Jesús pan loo myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Dhua gu' pan ndxè', ey. Pan ndxè' nee di's nac cón che'n bél'yòo laden co' gath por cón che'n rye mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sya, mxen Jesús thìb vas vin. Ndxab Jesús: ―Diox quix U', Diox, loo Diox. Ngoloa, mda' Jesús vas vin loo myen' xin' mté'th Jesús. Sya, ngu ryete myen' chu'th chu'th vin. ");
INSERT INTO zamNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ngoloa, ndxab Jesús loo myen': ―Vin co' ngolo ngu gu' ba' nee di's nac cón che'n ren laden co' xyo loo izlyo' par li nèen tedib conveñ co' gàc thìb conveñ cub yiloa. No xyo ren laden loo izlyo' por cón che'n huax mèn par tataa mod, mèn co' yila's loo cón chenen, tyon' xtol mèna no tyon' xquin mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Per, lìcpe' ba'i, na ngue nii loo gu': Desde nalle' par delant, ne'bereden gun vin xal ngue yun vin nalle' con gu' loo izlyo' ndxè'. Na gu vin con gu' tedib vez axta co'se' ñibe'pe' xuden Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Co'se' ngolo mbil' ro no Jesús myen' xin' mté'th Jesús thìb himn, nda Jesús con myen' loo thìb yii co' lèe yii che'n yaa oliv. ");
INSERT INTO zamNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sya, láth ndoo Jesús ned, ndxab Jesús loo myen': ―Nase, ryete gu' anze'f xi lezo' no tyoo xà' lezo' gu' por cón chenen yál' ndxè', ey. Tac loo libr co' nac xti's Diox ndub di's co' mbez: Daa guth pastor. Le' mbacxil' pastor na, rye's pál. ");
INSERT INTO zamNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Per co'se' yilo ryo xban daa, daa ga ner loo gu' le'n thìb yèezya' che'n làaz mèn galile. ");
INSERT INTO zamNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Sya, ndxab Pedr loo Jesús: ―Mastale' ryete myen' ba' xi lezo' no tyoo xà' lezo' myen' ba' loo cón che'n U', per part cón chenen daa ne'xide lezo' no ne' ne' tyoo xà' lezon ñèen cón gàc loo U'. ");
INSERT INTO zamNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Per Jesús ndxab loo Pedr: ―Pedr, lìcpe ba'i, na nii lool: Nal xhuin ndoore' lé' nguiidtee yál' no cozèe nguiidtee chop vez, lùu cà di's daa son vez loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Per Pedr mbli nèe di's. Ndxab Pedr loo Jesús: ―Mastale' gath daa con U', Tad, na ne'cà di'ste U'. No ale ryete myen' xin' mté'th Jesús thidte di's ndxab loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sya, nda no Jesús myen' xin' mté'th Jesús thìb lugar co' lèe Getsemaní. Tya, ndxab Jesús loo myen' xin' mté'th Jesús: ―Trè'te gure tub gu' láth nda bezen Diox tachu'thte más ba'le'. ");
INSERT INTO zamNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ante mbe' Jesús Pedr, no Cob, no Juàn. Le' Jesús na, naxut naxut gunaa loo. No mxi tín' lezo' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","No ndxab Jesús loo myen': ―Nden' lezon axta arid nalyat gàca loon co'se' tetìi mèn daa axta gath daa. Trè'te byan' gu'. Gure naa gu' no ne'gàtte gu', ndee gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Sya, ngua Jesús tachu'thte más delant. Tya, mdub xib Jesús. No mcotloo Jesús loo yòo. Ndxab Jesús loo Diox: ―Tad, chele' U' nee lezo', ne'ten'ten arid yalnè co' gàc loon le'n huiz ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Láth ngue bez Jesús Diox, ndxab Jesús loo Diox, ne: ―Pay, yey, ryete con' nzoque' mod li U'. Ftelá' U' daa loo yalnè co' gàc co' ten'en co'se' tyactìi daa. Per, lìcpe' ba'i, indlyasten gàca loon xal ndlyazen. Ndxe'leque', ndlyazen gàc loon xal neete lezo'pe' U' no maste. ");
INSERT INTO zamNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ngoloa, ndye'th Jesús co'te' mbyan' Pedr, no Cob, no Juàn. Per co'se' gunèe Jesús myen', ale nzi yàt myen'. Sya, mblo' Jesús mcal' loo myen'. Ndxab Jesús loo Pedr: ―Mon, ¿ché' nax yàtl, cà'? ¿Ché' ne'nxectel ndub naal mase thìb hor, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Gure naa gu' mase chu'th, yey. No gurez gu' Diox par ne'aselide gu' cua'n gu' xquin gu' naba'. Lìcpe' ba'i, xtùuz gu' no lezo' gu' anze'f ndlya's le' gu' cuez Diox. Per bél'yòo lad gu' ba' ndli nden' gu' ngo zan gu'. Cona, ngulàa fuerz gu'. Ale mbuu's gu' nzi gu'. ");
INSERT INTO zamNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ngoloa, mbere Jesús, nda bez Jesús Diox mbryop vez. Ndxab Jesús leque di'sa loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mbere Jesús, ndye'th Jesús co'te' mbyan' Pedr, no Cob, no Juàn. Lomisque', nzi yàt myen' tac ngudloo myen' ne'nxecte tant thìb mcal' nzo ngudloo myen'. Per axta ne' ne' ñee myen' cón gab myen' loo Jesús co'se' gunèe myen' ndye'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ngolo mbyon vez ndye'th Jesús co'te' mbyan' Pedr, no Cob, no Juàn par ñèe Jesús máa myen'. Ndxab Jesús loo myen': ―¿Ché' ngue li gu' cuent gàt gu' nal xhuin, cà'? Pà gàt gu'. Mzinle' hor co'se' ta'xù' thìb mbi' daa, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo', loo mèn ye'rsin' co' ndxàp xquin no co' ndxàp xtol. ");
INSERT INTO zamNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Goo too gu'. Ya' gu' ndyàa na'. Ndele' mbi' co' ta'xù' daa loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tatabe' ngue toodi's no Jesús myen' xin' mté'th Jesús co'se' ngro zi'f Jud, nde Jud, Jud co' ngòo cuent nac si' fchop myen' xin' mté'th Jesús. Nde no Jud huax mèn. Chó mèn nzo spad ya'. Chó mèn nzo thìb bro' yaa ya'. Mèn co' mbi'th ngòc mèn co' mtel' jef che'n nguley' co' más ñibe' loo nguley', no mèn co' mtel' mèn co' ngòc maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, no mèn co' mtel' rye mèngool co' ndyoo ner, no co' ndyoo naa, no co' ñibe' loo mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Le' Jud co' mda'xù' Jesús loo mèn ye'rsin' na, ndxab loo mèn co' nde no Jud ndoore' ryo' Jud con mèna: ―Neeque' gu' mbi' co' tan thìb chit ro, mbi'a nac Jesús. Tyen gu' mbi'. No ne'lá'de gu' mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","No texal mzin Jud loo Jesús, mbii gax Jud loo Jesús. Ndxab Jud loo Jesús chop vez: ―Maistr, Maistr. Látha, thidte de repent mda' Jud thìb chit ro Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Sya, mxen mcàa mèna Jesús. Mbe' mèna Jesús xal thìb pres loo rye mèn co' mtel' mèn co' mbe' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Per thìb myen' xin' mté'th Jesús co' nzo làtha mdob spad le'n cubiert. Mblàa myen'a thìb ya' spad nza thìb moz che'n jef che'n nguley' co' más mnibe' loo rye nguley'. Ale mblo nde'f myen'a nza moz. ");
INSERT INTO zamNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sya, ndxab Jesús loo rye mèna: ―¿Ché', lìcque', por derech, ngro' gu' con spad no con thìb bro' yaa ya' gu' par tyenxù' gu' daa no hue' gu' daa xal ndxe' mèn thìb huan' chele' daa ngàc huan', cà'? ");
INSERT INTO zamNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ndxab Jesús loo mèna, ne: ―Atate huiz ngo non gu'. No mblu'en gu' le'n templ gu'. No le'n rye huiza ne'ndenxù'de gu' daa xal thìb pres, ¿lé'? Per ndxàc con' ndxè' loon par tyaaque' no gàcque' no tyubque' di's cón che'n daa xal ndub di's loo libr co' nac xti's Diox. ");
INSERT INTO zamNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Látha, ale ryete myen' xin' mté'th Jesús mxon'. Mblá' myen' thidte Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Per thìb mbyòo co' mdoo nque xís Jesús, mbyòoa mcap thìb sab no maste. Sya, mxen mèna mbyòo par hue' mèna mbyòo, ne. ");
INSERT INTO zamNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Per mbyòo mcua'n mod ngro' thin mbyòo le'n sab. Che mbyòo, mxon' mbyòo, ndyaa mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sya, mbe' rye mèna Jesús loo ner jef che'n nguley' co' más ñibe' loo rye nguley'. No mqueltàa ryete mèn co' nac jef che'n nguley', no mqueltàa ryete mèngool co' ndyoo ner, no co' ndyoo naa, no co' ñibe' loo mèn nación Israel, no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn co'te' mdoo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Le' Pedr na, tith tith mdoo nque xís Jesús. Mzin Pedr axta loo lue' liz ner jef co' más ñibe'a. Tya, ale note Pedr mdub biiz ro rdii làth mèn co' ngòc polesi co' ngue quenap Jesús par ne'xon'te Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Le' rye mèn co' nac jef che'n nguley' co' más ñibe', no rye mèn co' ndyoo ner, no co' ndyoo naa, no co' ñibe' loo mèn nación Israel, mèna mcua'n mod xá mod quexù' que' fals mèna Jesús par tataa mod guth yèe mèna Jesús. Per ne'nglide mèna gan mcua'n mèna mod ngli mèna con'a. ");
INSERT INTO zamNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","No anze'f thìb mèna mbez ampurte di's gutyè' cón che'n Jesús axta ne' ne' ñee mèna chó ro gòn mèna. Ale leque mèna ngue go xo'f cón che'n yalgutyè' co' mbez mèna con xtàa mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ndxetoo ndxega' ndxep mèna. No nda' mèna cuent gutyè' par quexù' que' fals mèna Jesús. Mbez mèna loo xtàa mèna: ");
INSERT INTO zamNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Nu' mbìn le' mbi' ba' ndxab le' mbi' telux templ che'n Diox co' mtoxcua' mèn póla. No tolo ndxab mbi' le'n son huiz no maste xít te'f mbi' tedib templ. No templ co' mbez mbi' toxcua' mbi' ne'toxcua'de chol mèn. Ne' ne' lyath no mèn mbi' toxcua' mbi' templa. ");
INSERT INTO zamNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Per mastale' tataa mda' mèna cuent, inda'de mèna cuent thidte di's cón che'n Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Sya, ngoo too nde'f mbi' co' nac jef che'n nguley' co' más ñibe' loo rye nguley' làth rye mèna. Mnibdi's mbi' loo Jesús. Ndxab mbi': ―¿Ché' yende chó di's ndlya'sl ñeel loon, cà'? ¿Xá mod chonon tatua' mbez mèn ba' cón che'nl, cara? ");
INSERT INTO zamNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Per Jesús yende chó di's ngab. Xèe mdoo Jesús loo mèna. Mbere mbi' co' ngòc jef che'n nguley'a, mnibdi's mbi' loo Jesús tedib vez. Ndxab mbi' loo Jesús: ―¿Ché', lìcque', nac lùu Crist, xgan'pe' Diox, Diox co' thidteneque' ndyac lezo', cà'? ");
INSERT INTO zamNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús ndxab loo jef che'n nguley'a: ―Aa. Nacque' daa Crist, pues. Na nii lool nalle' le' gu' hui' loon, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo', co'se' tuben cuat Diox co' ndxàp rye loothe con' roo no con' xèn la's nii Diox no la's ya' Diox. No hui' gu' loon co'se' gàc huiz co'se' galen loo izlyo' ndxè' tedib vez le'n xcuau. ");
INSERT INTO zamNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Co'se' mbìn mbi' co' ngòc jef che'n nguley' co' más ñibe' tataa ndxab Jesús, ale mched yèe mbi' xab mbi' tac mden' mbi' le' Jesús gunii yèe gunii tìi cón che'n Diox. Sya, ndxab mbi' loo mèn co' nziri' no mbi'a: ―¿Cón li no na' más mèn co' ta' cuent cón che'n mbi' ba'? Con di's co' ngolo gunee mbi' ba' ngogaale' mbi' loo yalgutyè' mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gu' mbìn no mda'que' gu' cuent xal ngolo gunii yèe gunii tìi mbi' ba' cón che'n Diox, ¿lé'? ¿Xá nee gu'? ¿Cón li no na' mbi' ba'? Sya, ryete mèna mquexù' mque' fals Jesús par guth mèn Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Le' sya, mtlo ndxep mèna, msuc mèna rloo Jesús. No mtau' mèna loo Jesús con thìb le' lar'. No ale mda' mèna che'n Jesús. Ale mbez mèna loo Jesús: ―Bli divin chó ngue ta' che'nl. Le' mèn co' ngòc polesi che'n templ co' nquenap templ na, ale nguis mèna rloo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Láth ngue li no mèn con'a loo Jesús, Pedr xexte ndoo par xàn' blé' loo lue'. Per láth ndoo Pedr tya, mzin thìb mza' co' ngòc criad che'n jef che'n nguley' co'te' ndoo Pedr. ");
INSERT INTO zamNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Texal gunèe criad ndoo biiz Pedr ro dìi, xèe mbui' criad loo Pedr. Sya, ndxab criad loo Pedr: ―Lùu, ne, naqueltàa no Jesús che'n yèez Nazaret, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Per Pedr ale mcà' di's Jesús. Ndxab Pedr: ―Ne'libeden chó mbi' nac mbi' ba'. No axta ne' ne' indxònen cón ndyoodi'sl. Sya, xexte ngro' Pedr par ned ro puert. Láth nda ro' Pedr, chàa, ngrozèe thìb nguiidtee mblé' nguiidtee yál'. ");
INSERT INTO zamNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mbere criad, xèe mbui' criad loo Pedr tedib vez. Mtlo criad, ndxab criad loo mèn co' nziri' tya: ―Mbi' ba', ne, nac thìb mbi' co' naqueltàa no Jesús, ndyaquen. ");
INSERT INTO zamNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mbere Pedr, mcà' di's Pedr Jesús tedib vez. Pente ndxàc nguri'th con'a, mbere mèn co' nziri' tya. Ndxab mèn loo Pedr: ―Lìcpe' ba'i, lùu, ne, nac thìb myen' co' ngue tee no Jesús. Tac lùu nac mèn gulàaz che'n làaz mèn galile. No mod co' ndyoodi's lùu ba' nac co' ndlu' xal ndyoodi's mèna. ");
INSERT INTO zamNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sya, leque Pedr mtlo gunii ngòc nguàal di's. No mde'th Pedr Diox. Ndxab Pedr loo mèna: ―Ne'libeden mbi' co' ñibdi's gu' loon, cara. ");
INSERT INTO zamNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Leque hora, chàa, ngrozèe nguiidtee mbryop vez mblé' nguiidtee yál'. Axta syare' mte' lezo' Pedr di's co' ndxab Jesús loo Pedr: Ndoore' co'se' cozèe nguiidtee chop vez, lùu cà di's daa son vez. Co'se' mbli Pedr xtùuz cón che'n di's co' ndxab Jesús loo Pedr, ne'tí' ne'ñee lezo' Pedr mbín' Pedr axta plóthe. ");
INSERT INTO zamNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Co'se' ngonìi izlyo' tedib huiz co' nde nquea, mèn co' ngòc jef che'n nguley' co' más ñibe' loo nguley', no mèngool co' ndyoo ner, no co' ndyoo naa, no co' ñibe' loo mèn nación Israel, no rye mèn co' ngòc maistr co' mblu' cón che'n ley co' mxo'f Moisés loo mèn, no rye mèn co' más ñibe' loo mèn nación Israel, ryete mèna thidte mqueltàa par mdub dó' mèna ya' Jesús par mbe' mèna Jesús loo Pilat. ");
INSERT INTO zamNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sya, mnibdi's Pilat loo Jesús. Ndxab Pilat: ―¿Ché' nac lùu rey che'n mèn nación Israel, cà'? Jesús mcàb. Ndxab Jesús loo Pilat: ―Aa. Nac daa rey, pues, xalque' ngolo guneela ba'. ");
INSERT INTO zamNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Le' mèn co' ngòc jef che'n nguley' co' más ñibe' loo nguley'a na, anze'f thìb con' ngue quexù' ngue que' fals Jesús loo Pilat. ");
INSERT INTO zamNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Le' sya, mbere Pilat, mnibdi's Pilat loo Jesús. Ndxab Pilat: ―¿Ché' yende chó di's lya'sl càbl loo mèn ba', cà'? Hui' no maste napló con' ngue quexù' ngue que' fals mèn ba' lùu. ");
INSERT INTO zamNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Per ndxe'leque', yende chó di's mcàb Jesús loo mèna. Le' Pilat na, axta ne' ne' ñee Pilat cón li Pilat xtùuz cón che'n Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nde nxon', mque no mèn nación Israel costumbr làa mèn co' ndxàc gobiern thìb pres cad lin' co'se' ndxáal lni che'n pasc. Pres co' gab mèn lyá', presa lyá'. ");
INSERT INTO zamNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Le'xque' le'n huiza, thidte mque' thìb mbi' co' ngro' lèe Barrabás lezi'f con taamas mèn co' mbeth mèn por thìb huelg co' mbli mèn tiempa. ");
INSERT INTO zamNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Láth ndooxù' Jesús loo Pilat, ngua mèn nación Israel loo Pilat par mna'b mèn di's loo Pilat làa Pilat thìb pres co' ndlya's mèn lyá' xalque' nac costumbr co' ndxàp mèn tiempa. ");
INSERT INTO zamNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat mcàb loo mèna. Ndxab Pilat: ―¿Chó ndlya's gu' telá'en, à'? ¿Ché' ndlya's gu' telá'en mbi' co' mbez nac rey che'n mèn nación Israel, cà'? ");
INSERT INTO zamNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Per Pilat nonque' no nda'que' Pilat cuent por ndxàn lezo' mèna ñèe mèna Jesús, con'a mda'xù' mèn co' nac jef che'n nguley'a Jesús loo Pilat. ");
INSERT INTO zamNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Per mèn co' ngòc jef che'n nguley' co' más ñibe' loo rye nguley', mbli mèna par a la fuerz gab rye mèn, co' nziri' loo Pilat, más huen co' Pilat Barrabás lezi'f lugar de lá' Pilat Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Sya, mnibdi's Pilat loo rye mèna. Ndxab Pilat: ―¿Cón ndlya's gu' li non mbi' co' mbez mèn nac rey che'n mèn nación Israel, à'? ");
INSERT INTO zamNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Sya, cabii ndxab mèna: ―Fcàa mbi' ba'. Bnibe' quée mbi' loo cruz. ");
INSERT INTO zamNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat ndxab loo mèna: ―Per ¿chó con' ye'rsin' ndyac gu' mbli mbi', à'? Sya, mbere mèna, cabii ndxab mèna: ―Nu' ngue bez lool, bnibe' quée mbi' ba' loo cruz. ");
INSERT INTO zamNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Per com le' Pilat mblya's yan' bien Pilat con mèn co' nziri'a, ¿lé'?, mnibe' Pilat ngua lo' mèn Barrabás lezi'f. Le' Jesús na, ngolo mbli Pilat mandad mda' mèn che'n Jesús, mda' Pilat Jesús loo mèna par ya que' mèna Jesús loo cruz. ");
INSERT INTO zamNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ngoloa, mbe' solndad Jesús loo lue' che'n palas. Tya, mbli mèna mandad mqueltàa ryete solndad par li solndad ngòc nguàal con' loo Jesús par tataa mod xìis no solndad Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ale asembli solndad mtegoc solndad Jesús thìb xab Jesús color morad. No mdub solndad thìb coron yis co' mtà' solndad yéc Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ngoloa, mtlo solndad, cabii mbez solndad loo Jesús. Ndxab solndad: ―San, rey che'n mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","No tataa mblàa solndad bar yéc Jesús. No msuc solndad rloo Jesús. No mdyub xib solndad loo Jesús. Mbli solndad loo Jesús xalque' ndli mèn co'se' ñii mèn Diox loo thìb rey par tataa mod más mxìis no solndad Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ngolo mxìis no solndad Jesús axta plóthe, mteche solndad xab Jesús co' ngòc lar' morada lad Jesús. Mtegoc solndad Jesús xabpe' Jesús. Ngoloa, mbe' solndad Jesús par ya que' solndad Jesús loo cruz. ");
INSERT INTO zamNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Le'pe' ndxàc con'a, ndye'th thìb mbi' co' ngua zin' huan. Mbi'a ngòc mèn gulàaz che'n làaz mèn ciren. Mbi'a ngro' lèe Mon. Ngòc mbi' xud Alejandr no Ruf. Láth nde riid mbi' ro ciuda Jerusalén, ngro' no mèna Jesús. Asal' too mbi' mèna, ale mtau' solndad loo mbi' bere mbi' par xyo'f yen mbi' cruz co'te' que' solndad Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mbe' mèna Jesús loo thìb den co' lèe Gólgota, co' nee di's, Calaver tac dena ñaa xal thìb quèe yéc mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tya, mda' solndad thìb loo vin co' nos con thìb loo cuan' co' lee mirr par ngu Jesús. Per ne'ndalte Jesús ngu Jesús vina. ");
INSERT INTO zamNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sya, mque' solndad Jesús loo cruz. Ngoloa, mdith no solndad dad loo xab Jesús par ñee solndad ñeene' chó solndad hue' thìb le' thìb le' xab Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Hor co' mque' solndad Jesús loo cruz ngòc hor nquée guyè' xtil'. ");
INSERT INTO zamNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nde nxon', mque' solndad plá di's loo thìb le' ye's loo cruz yéc Jesús. Di'sa mbez taandxè': ―Rey che'n mèn nación Israel. Tataa mdub solndad di's yéc cruz tac mèn mquexù' mque' fals Jesús le' Jesús ndxab: ―Daa nac rey che'n mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Thidte mque' mèn Jesús loo cruz con chop mbi' co' ngòc huan'. Thìb mbi' mquée loo cruz cuat Jesús ladlì. Tedib mbi' mquée loo cruz cuat Jesús lad rebes. ");
INSERT INTO zamNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tataa ngòca par ngòcque' no mdubque' di's co' mde'th mèn co' ndub loo libr co' nac xti's Diox co' mbez: ―Mbli mèn cuent no Crist ngòc mèn ye'rsin' con mèn ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Le' sya, mèn co' ndri'th co'te' ngue Jesús loo cruz, asembli mèna, mbez mèna ngòc nguàal di's loo Jesús. No tataa mcuin mèna yéc mèna loo Jesús. Mbez mèna loo Jesús: ―Nase, yixo. Lùu co' mbez cobiil templ no yilo son huiz ngolole' mxít te'fl templ tedib vez, mzyalque'la nguel tua'. ");
INSERT INTO zamNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Leque lùu bli par lyá'l loo con' ryes no bilàa loo cruz co'te' nguel ba'. ");
INSERT INTO zamNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Lomisque' ne, mèn co' ngòc jef che'n nguley' co' más ñibe' loo nguley', no mèn co' ngòc maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, ale mxìis no mèna Jesús. No mbez mèna loo xtàa mèna: ―Mbi' ba' mtelá' mèn loo con' ryes. Per nalle', ale, ne'gácte mbi' telá' mbi' mbi' loo con' ryes. Mzyalque' mbi'i. ");
INSERT INTO zamNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Chele' na' ñèe le' mbi' co' mbez nac Crist no co' mbez nac rey loo na' bilàa loo cruz nalle', syase, yila's na' le' mbi' ba' nac Crist, ¿lé'? No ale axta ryop mbi' co' mquée loo cruz cuat Jesús ndxab ngòc nguàal di's loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Dib lal ngue que' mèna Jesús loo cruz, ngóol hor rol huiz. Per co'se' ngóol rol huiz axta hor mquée guyon bzyè mbyau' loo huiz dib athu loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Co'se' ngòc hor mquée guyon bzyè huiza, ngrozèe yii ngrozèe den Jesús. Ngro' di's ro Jesús. Ndxab Jesús: ―Eloi, Eloi, ¿lama sabactani? Di's ndxè' nee di's: U' co' nac Diox daa, ¿chonon mblá'ya' U' daa? ");
INSERT INTO zamNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Per ndxep mèn co' ngure gax loo Jesús hora, mèna mbìn di's co' ndxab Jesús. Mèna ndxab loo xtàa mèna: ―Bìn gu' di's co' ngue bez mbi' ba'. ¿Ché' ndyac gu'i mbi' ngue bez Lii co' mde'th di's co' ndxab Diox póla, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sya, thìb mbi' co' nzo làtha mque' carre. Ngua tegaz mbi' thìb sponj con thìb loo vin nala co' nos con thìb loo cuan' nala. Sya, mdub mbi'a sponj loo thìb punt bar no mzi mchep mbi' sponja ro Jesús par gu Jesús vina. No ndxab mbi': ―Blá' gu' teeque' mbi' par ñee na' neene' ché' ti'th Lii par làa Lii mbi'. ");
INSERT INTO zamNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Leque hora, ngrozèe yii ngrozèe den Jesús. No setilte nguth Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","No texal ngolo nguth Jesús, Diox mbli ngòc rol cortin co' ngue le'n templ. Desde gáp axta xàn' cortin ale mbryed grolthe cortin. ");
INSERT INTO zamNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Le' capitán co' nac capitán che'n gobiern co' ndub ciuda Rom, co' ndoo naa no co' ndoo hui' xal ngòca loo Jesús loo cruz, co'se' gunèe capitán ngrozèe yii ngrozèe den Jesús no co'se' gunèe capitán xá mod nguth Jesús, ndxab capitán loo mèn co' ngure tya: ―Lìcpe' ba'i, cara, mbi' ba' ngòc xgan'pe' Diox, ndyaquen. ");
INSERT INTO zamNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Lomisque' ne, ngure ndxep mèngot, co' ngure hui' tith xal ngòca loo Jesús loo cruz. Láth rye mèngota ngo thìb xa'got co' ngro' lèe Mari co' ngòc mèn yèez Magdala. No ngo tedib xa'got co' ngro' lèe Mari co' ngòc xna' ryop hues myen' co' ngro' lèe Cob no Chè. Coba mdub lèe mèn Cob Chu'th. No ngo tedib xa'got tya co' ngro' lèe Salomé. ");
INSERT INTO zamNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ryete xa'gota mdoo nque xís Jesús. No mbli xa'gota mandad loo Jesús co'se' mque tee Jesús le'n rye yèezya' co' nac ned làaz mèn galile. Más de cona, taamas mèngot co' mdoo nque xís Jesús, co'se' mquée Jesús par ned ciuda Jerusalén le'n huiza, ndoo hui' xal ndxàc con' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Huiz co'se' nguth Jesús, huiza ngòc huiz vispr che'n huiz roo co' nac huiz sabd co' ngòc huiz descans tiempa. Casque' hora nde làale' yál' izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ngoloa, mbi'th thìb mbi' co' lèe Chè. Mbi'a ngòc mèn yèez Arimate. Ngòc mbi' thìb jef loo mèn co' nqueltàa par ndyoo ner, no ndyoo naa, no ñibe' mbi' loo mèn nación Israel, ne. Mbi'a ndub quee lezo' pól gàc tiemp co'se' ñibe'pe' Diox loo mèn loo izlyo'. Pues ngòo valor loo mbi'. Negadi's ngua mbi' co'te' ndub Pilat par ña'b mbi' loo Pilat ta' Pilat permis làa mbi' thebol Jesús loo cruz. ");
INSERT INTO zamNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Co'se' mbìn Pilat di's co' ngue ta' Chè cuent loo Pilat, ante mbyu' mbyàl Pilat co'se' mbìn Pilat le' Jesús nguthle'. Sya, ngurez Pilat capitán par ñibdi's Pilat loo capitán. Ndxab Pilat: ―¿Ché', lìcque', ngolole' nguth Jesús, cà'? ―Aa, ndxab capitán. ");
INSERT INTO zamNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Co'se' mcàb capitán, ndxab capitán: ―Aa, ngolole' nguth Jesús, sya, mda' Pilat permis loo Chè par yilàa Chè thebol Jesús loo cruz. ");
INSERT INTO zamNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ngoloa, ngua ti' Chè thìb sab co' anze'f náp ntac. Ndye'th Chè. Mblàa Chè thebol Jesús loo cruz. Mchi'x Chè saba lad thebol Jesús. Ngoloa, ngua lo Chè thebol Jesús le'n thìb ye'r quèe co' naden' cho thìb quèe. Ngoloa, mtau' Chè ro ye'r quèe con tedib quèe laj. ");
INSERT INTO zamNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Le' Mari, co' ngòc mèn yèez Magdala, no tedib xa'got co' lèe Mari co' ngòc xna' Chè na, ngua tee hui' co'te' mblo Chè, co' ngòc mèn yèez Arimete, thebol Jesús le'n ye'r quèea. ");
INSERT INTO zamNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Co'se' nguri'th huiz sabd co' ngòc huiz descans tiempa, thìb xa'got co' ngro' lèe Mari co' ngòc mèn yèez Magdala, no tedib xa'got co' ngro' lèe Mari co' ngòc xna' Cob, no tedib xa'got co' ngro' lèe Salomé, yon xa'gota mxi' thìb loo nít perfum par ya tà' xa' nít perfuma lad thebol Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Co'se' ngonìi izlyo' huiz doming co' nac ner huiz che'n sman, tatabe' ñaa mbe'th izlyo', nda yon xa'gota ro ye'r quèe co'te' mblo mèn thebol Jesús. No mzin xa' ro ye'r quèea le'pe' nde len huiz. ");
INSERT INTO zamNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Per co'se' yamerle' zin xa' ro ye'r quèea, ndxab xa' loo xtàa xa': ―Per nalle' na, ¿chó teche quèe ro ye'r quèe par yòo na' le'n ye'r quèe, yey? ");
INSERT INTO zamNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Per co'se' mzinpe' xa' ro ye'r quèe, gunèe xa' le' quèe laj roo co' ndoo nau' ro ye'r quèea ya indoo nau'te ro ye'r quèe. Ale ndoo xal'le' ro ye'r quèe. ");
INSERT INTO zamNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Per co'se' ngòo xa'gota le'n ye'r quèe, gunèe xa' ndub thìb mbyòo ladlì co'te' ndoo xa'. Noc mbyòo thìb ned xab mbyòo co' dib ando mbyòo co' ante nagus bèeleque' ñaa. Co'se' gunèe xa'gota ndub mbyòo, ale mzyeb xa'gota. ");
INSERT INTO zamNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Per mbyòo ndxab loo xa'gota: ―Ne'zyebte gu', ey. Na neeque' le' gu' nde cua'n Jesús che'n yèez Nazaret co' mque' mèn loo cruz. Jesús ngro xbanle'. Yende Jesús trè'. Huen huen hui' gu' co'te' mdi'xsua' mèn Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nalle', huàa li gu' avis ndxè' loo myen' xin' mté'th Jesús no loo Pedr. Guuz gu' loo myen' le' Jesús ya ner loo myen' le'n thìb yèez co' nac gulàaz che'n làaz mèn galile. Tya, tolo hui' myen' loo Jesús xalque' ndxab Jesús loo myen' pezea. ");
INSERT INTO zamNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Sya, yende izlyo', mque' yon xa'gota carre. Mbii xa' ro ye'r quèea. Ale nxi'th xa' tant nzyeb xa'. No yende chó ngabte xa' loo nec thìb mèn tant nzyeb xa'. ");
INSERT INTO zamNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Co'se' ngolo ngro xban Jesús huiz co' ngòc ner huiz che'n sman co' nac huiz doming, nerleque' loo Mari co' ngòc mèn yèez Magdala, Mari co' mque no gaz xpii meexù' ndoore', ngro' too Jesús no mblu' loo Jesús Jesús loo Mari. ");
INSERT INTO zamNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ngoloa, mxen Mari ned. Ngua li Mari avisa loo rye mèn co' mque tee no Jesús ndoore'. Prob mèna nzi xi lezo' no nzi yón' mèna por cón che'n con' co' ngòc loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Co'se' mbìn mèna ngue ta' Mari cuent le' Jesús ngro xbanle' no gunèele' Mari Jesús, ne'ngala'ste mèna di's co' ngue ta' Mari cuent. ");
INSERT INTO zamNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Per loo ngro' too Jesús no mblu' loo Jesús loo Mari co' ngòc mèn yèez Magdala, ngro' too Jesús no mblu' loo Jesús tedib mod loo taachop myen' xin' mté'th Jesús co'se' ndoo ryop myen'a ned ndyàa myen' ned co' nac ned huan. ");
INSERT INTO zamNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Co'se' ngolo gunèe myen' Jesús, mxen myen' ned. Ngua ta' myen' cuent loo taamas myen' xin' mté'th Jesús. Lomisque' ne, ne'ngala'ste taamas myen' xin' mté'th Jesús cuent co' mda' ryop myen'a loo myen'. ");
INSERT INTO zamNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Per más nde tee huiz, por derech, ngro' too Jesús no mblu' loo Jesús loo ryete si' fthib myen' xin' mté'th Jesús láth co'se' ndub myen' loo mes liz thìb mbi'. Sya, mbyoo Jesús myen' tac axta arid naad myen' no nguud myen' no por nayez lezo' myen' tac indxela'ste myen' cuent co' mbìn myen' cón che'n mèn co' mda' cuent loo myen' le' mèna gunèe Jesús loo ngro xban Jesús. ");
INSERT INTO zamNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sya, ndxab Jesús loo myen': ―Nase, ndlyazen ya gu' dib athu loo izlyo'. Ya ta' gu' cuent cón che'n di's ndac ndxè' co' ndlu' xá mod lyá' mèn loo con' ryes loo rye mèn co' nzi ban dib athu loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","No ndxab Jesús: ―Mèn co' tyal yila's loon no loo cón chenen no yiloa gàc bautizar mèn, mèna lyá'que'. Per ndxe'leque', mèn co' ne'tyalte yila's loon no loo cón chenen, mèna thidteneque' quexù' Diox par tetìi Diox mèna yiloa. ");
INSERT INTO zamNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Lu'en loo gu' xal ñaa señ no yalguzye' co' li Diox loo mèn, mèn co' tyal yila's loon. Lomisque' ne, ngue ñibe'en loo gu' por cón che'n con' roo no con' xèn co' nzo làs niin no co' nzo la's yan, co' gu' xpii meexù' loo mèn. Lomisque' ne, lin par tyoodi's gu' tedib di'stèe co' inacte di'stèe co' ndyoodi's gu' loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","No lomisque' ne, lin co'se' tyen gu' mbel', ne'quelede mbel' gu'. Ta' mèn nít yèth co' nos cuan' hua gu' no ne'lide cuan'a yalquìi loo gu' par gath gu'. Más de cona, ante gàal gu' lad mèn yíiz, yac mèn yíiz loo yíiz co' mque no mèn, ne. ");
INSERT INTO zamNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Texal ngolo mdoodi's no Jesús myen' xin' mté'th Jesús, xèe nzi hui' myen' xal nguáp Jesús loo bé'. No co'se' ngolo mzin Jesús loo bé', mdub Jesús cuat Diox loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ngoloa, mbii myen' co'te' ngo no myen' Jesús. Mxen myen' ned. Nda te'th myen' no ngua lo myen' yalbàn co' ndlu' xá mod lyá' mèn loo con' ryes loo mèn dib athu loo izlyo'. Yub Tad Jesús mque tee no myen' ned mque tee myen'. No yub Tad Jesús ndli par ndxàc huax señ no huax yalguzye' loo mèn por cón che'n myen', par ndlu' Tad Jesús loo mèn lìcque' nac di's co' ngue go myen' yalbàn no co' nde'th myen' loo mèn, no co' ndxàc loo mèn. Taandxè'que' tolo gàca, ndee gu'.");
INSERT INTO zamNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Anze'f huax mèn mdoo lezo' par mque' mèna ye's cón che'n Jesucrist par mda' mèna cuent cón che'n thìb thìb con', con' co' ngòc làth nu', Tyofl. ");
INSERT INTO zamNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mque' mèna ye's no mda' mèna cuent xal ngòcpe'i. Mèna ngòc mèn co' gunèepe' con' co' ngòc. No mque tee lyath no mèna mèn co' mque tee go yalbàn cón che'n di's ndac cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Daa, ne, noo noo mbral no cón che'n thìb thìb con' co' ngòc, axta co'se' mtlo ngòca. No ndyaquen huen naca que'en ye's cón che'n xal ngòc ryethe con'a lool, Tyofl, lùu co' anze'f ndyu' loon no co' anze'f ndlin cas. ");
INSERT INTO zamNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Por cona, ngue que'en ye's ndxè' lool par ta'l cuent no par nonl co' huen huen cón che'n con' co' nac lìcpe' cón che'n Jesucrist co' mblu'le' mèn lool. ");
INSERT INTO zamNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Hui' nexa, Tyofl. Co'se' ngòc Herod rey loo mèn yèezya' co' ngòc mèn gulàaz mèn jude tiempa, le'xque' le'n tiempa ngo ban thìb mbi' co' ngòc nguley'. Mbi'a ngro' lèe Zacari. Thidte mxo'f zin' mbi' yalnguley' con thìb ned mèn co' mnibe' tedib mbi' co' ngòc nguley' co' ngro' lèe Abi. Le' xa'got Zacari na, ngro' lèe Elisabet. Ngòc Elisabet bin che'n thìb mbi' co' ngro' lèe Aarón, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ngòc Zacari ryop Elisabet mèn nalì no mèn nambìi loo Diox. Mdyubdi's Zacari ryop Elisabet xal mnibe' Diox loo ley co' mxo'f Moisés loo mèn tiempa. Nec thìb mod no nec tedib mod yende chó mèn ngo tiempa co' ngác ñii yèe ñii tìi cón che'n Zacari ryop Elisabet loo chol con' co' nac cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Zacari ryop Elisabet ne'ndante xin' tac Elisabet ngòc xa'got rnith. Leque tiempa ngòc ryop sa'l Zacari xa'gool, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Co'se' mzin huiz co' ngòc tiemp co' xo'f zin' mèn co' thidte nxo'f zin' no Zacari yalnguley' par li mèna sirv loo Diox le'n templ, ");
INSERT INTO zamNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","xalque' ngòc mod co' mque no mèn co' mxo'f zin' thìb thìb mèn zin' cón che'n yalnguley' le'n templ, le'xque' tiempa ngro' lèe Zacari rif par xo'f zin' Zacari le'n templ che'n Diox par tec Zacari du'r zen yal' le'n templ. ");
INSERT INTO zamNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sya, láth ngue tec Zacari du'r zen yal' le'n templ, ryete mèn co' mqueltàa nziri' fuer loo lue' co'te' ndub templ. Nzi bez mèna Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Làth xtau'a, mbyú' loo thìb angl che'n Tad Diox loo Zacari. Ndoo angl ladlì che'n còo' co'te' ntec nguley' du'r zen yal'. ");
INSERT INTO zamNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Co'se' gunèe Zacari ndoo angl, ne'ñeede Zacari cón li Zacari tant nzyeb Zacari. ");
INSERT INTO zamNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sya, gunii angla. Ndxab angl loo Zacari: ―Zacari, ne'zyebtel. Diox mbìnque' di's co' ngue bezl loo Diox. Nalle' ngue niin lool: Xa'gotl co' nac Elisabet tyan thìb xgan'l. No tub lèel mbed Juàn. ");
INSERT INTO zamNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Anze'f xyo'f nde' xyo'f ndla' lezo'l no anze'f tyac tín' lezo'l por cón che'n mbed. Más de cona, anze'f huax mèn tyac lezo' por cón che'n mbed co' tyan xa'gotl. ");
INSERT INTO zamNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tac xgan' lùu co' gáala gàc thìb mbi' co' anze'f tyu' loo Diox. Ne'gude xgan'l vin. Ne' ne' gu xgan'l nítguy. Ndoore' gáal xgan'l tlo Xpii Natú', ñibe' Xpii Natú' loo xgan'l. ");
INSERT INTO zamNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Xgan' lùua li le' huax mèn nación Israel lyàa yéc no lyàa lezo' par bere mèn nación Israel, yòo mèn nación Israel loo cón che'n Dioxpe' mèna tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Xgan' lùu, co' ryo' lèe Juàn, ya lu' ner loo mèn cón che'n Crist ndoore' yi'th lu' Crist loo mèn loo izlyo'. Que tee te'th Juàn di's loo mèn cón che'n Crist xalque' mque tee te'th Lii co' mde'th di's co' ndxab Diox loo mèn póla. No gàp Juàn con' la's nii Juàn no la's ya' Juàn xalque' ngòp Lii con' la's nii Lii no la's ya' Lii póla. Tataa li Juàn loo mèn par yu' yàl lezo' mèn co' nac gundan loo xin' mèn no par tlo té'th mèn tyubdi's mèn co' nac mèn naad no mèn co' nac mèn nguud loo Diox xalque' mèn co' ndxác. Tataa li Juàn par gàc nab mèna loo cón che'n Diox par tyubdi's mèn loo Crist co'se' yi'th Crist loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacari mnibdi's loo angl. Ndxab Zacari loo angl: ―¿Xá mod gác yilazen ché', lìcque', gàc con' co' ngue nee U' loon ba', à'? Hui' U' nexa. Daa ngoxle' no xa'got daa ngoxle', ne. ");
INSERT INTO zamNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angl mcàb. Ndxab angl loo Zacari: ―Daa nac Gabriel co' nzo loo Diox par lin co' ñibe' Diox loon. Diox mnibe' loon par mbal toodiz nonl par tan cuent cón che'n di's co' gunee Diox loon par niin di's ndxè' lool. ");
INSERT INTO zamNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Per nalle' gàc thìb con' lool. Desde nalle' par delant lùu gàc mud. Ne'gáctel tyoodi'sl le'n rye mbe' co' tyoo nac xin' xa'gotl. Con'a gàc lool tac ne'ngala'stel di's co' ngue niin lool ndxè'. Gàcque' con'a lool axta tyaa huiza no axta zin tiemp co'se' tyan xa'gotl xin' xa'gotl. ");
INSERT INTO zamNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Láth ndxàc con'a loo Zacari, mèn nziri' par fuer loo lue' co'te' ndub templ. Nzi bed mèn ryo' Zacari le'n templ. Per ante mbui' mèn no ante gunaa mèn cón ndxàc loo Zacari no cón mxac Zacari susque' nen ndlyen' Zacari le'n templ. ");
INSERT INTO zamNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Co'se' ngro' Zacari le'n templ, ne'ngácte Zacari tyoodi's no Zacari mèn. Syare', mden' lezo' mèn no mda' mèn cuent le' Zacari mxyo'f loo con' loo le'n templ. Mbli Zacari señ loo mèn le' Zacari ngòc mud. ");
INSERT INTO zamNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Co'se' ngolo mdyaa huiz co' ngòc huiz co' mxo'f zin' Zacari zin' che'n yalnguley' le'n templ, mdyàa Zacari par liz Zacari. ");
INSERT INTO zamNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ngolo nguri'th con'a, Elisabet, xa'got Zacari, mquée loole' xin'. No ale ne'ngro'de Elisabet, ne' por chu'th, liz Elisabet le'n ga'y mbe' tac mbli Elisabet xtùuz, ndxab Elisabet le'n lezo' Elisabet: ");
INSERT INTO zamNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Tad Diox mbli con' ndxè' loon nalle' par taandxè' mod ne'tolode xìis no mèn daa. ");
INSERT INTO zamNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ngolo ndxàc xop mbe' ndoo nac xin' Elisabet, Diox mtel' angl Gabriel par ngua angl le'n thìb yèez che'n làaz mèn galile, yèezya' co' lèe Nazaret. ");
INSERT INTO zamNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ngua too naa angla thìb mza' yòn co' ngro' lèe Mari. Mza'a ngòp trat con thìb mbi' co' ngro' lèe Chè par selya' mza' con Chè. Chèa nde bin thìb mbi' co' ngro' lèe David co' ngòc rey póla. ");
INSERT INTO zamNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Sya, ngòo angl co'te' nzo mza'. Ndxab angl loo mza': ―San, Mari. ¿Máal, ey? Anze'f thìb con' ndac li Diox anggàc lool le'n huiz ndxè'. Diox nzo noque' lùu. Anze'f tyac lezo'l, Mari, loo rye mèngot co'se' yilo gàc con' ndxè' lool. ");
INSERT INTO zamNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Per co'se' ñèe Mari ndyoodi's no angl Mari, ante mbui' Mari no ante gunaa Mari. Ndxab Mari loo lezo' Mari: ¿Chonon tatua' ngue toodi's angl che'n Diox ba' loon, yoo? ¿Cón gàc loon nalle'? ");
INSERT INTO zamNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sya, ndxab angl loo Mari: ―Mari, ne'zyebtel. Ngro' lezo' Diox li Diox anggàc thìb con' ndac lool. Hui' nexa xá nac di's co' ngue niin lool ndxè': ");
INSERT INTO zamNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Lùu quée loo xin'. No tyanl thìb xgan'l. Tub lèel mbed Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mbed co' tyan lùua gàc thìb mbi' roo no thìb mbi' xèn. Hue' mbed tedib lèe co' lèe Xgan'pe' Diox, co' nee di's, gàcque' mbed xgan'pe' Diox. Noo noo ta' mèn cuent le' mbed, lìcque', nac xgan'pe' Diox, Diox co' nac Diox roo no Diox xèn loo ryethe con'. No li Tad Diox gàc mbed rey loo mèn nación Israel xal ngòc David co' ngòc xudgool lùu rey loo mèn nación Israel póla. ");
INSERT INTO zamNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ne'lyuxte no ne' ne' lith no tiemp co' ñibe' xgan'l loo mèn nación Israel thidtene yiloa. ");
INSERT INTO zamNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Sya, mnibdi's Mari loo angl. Ndxab Mari loo angl: ―¿Xá mod gàc con' ndxè' loon, yey? Daa tarte que no sa'len. Más de cona, tarte neen cón mènbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angl mcàb. Ndxab angl loo Mari: ―Diox làa Xpii Natú' lool. Por cón che'n Xpii Natú'a, Diox li anggàc con' roo con' xèn lool par ndootel hue' xin'l. Por cona, mbed co' tyanla gàc xgan'pe' Diox par xo'f zin' mbed cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","No nalle' nde niin tedib con' lool: Elisabet co' ndxàc mèn gulizl tyan thìb xgan' Elisabet, ne. Mastale' ngoxle' Elisabet no mastale' mbez mèn le' Elisabet nac xa'got rnith, per nalle' ndxàcle' xop mbe' ndoo nac xin'le' Elisabet. ");
INSERT INTO zamNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ryethe con' co' ndlya's Diox li Diox nzoque' mod li Dioxa xal ndlya's Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Le' sya, ndxab Mari loo angl: ―Ana Diox. Daa nacle' moz che'n Diox. Li Diox con' loon xal ngue nee U'i loon. Ngolo ndxab Mari tataa loo angl, ndyàa angl. ");
INSERT INTO zamNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Leque le'n huiza, anze'f mguen lezo' Mari. Mxen Mari ned, nda Mari le'n thìb yèez co' nziri' le'n yiido' par ned làaz mèn jude. ");
INSERT INTO zamNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ngua Mari liz Zacari. Gunii Mari Diox loo Elisabet. Ndxab Mari: ―San, Elisabet. ¿Máal? ¿Cón ngue lil? ");
INSERT INTO zamNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Co'se' mbìn Elisabet gunii Mari Diox loo Elisabet, ale mbuin mbed le'n xàn' le'n Elisabet. Sya, ngulàa Xpii Natú' loo Elisabet par tlo Xpii Natú', ñibe' Xpii Natú' loo Elisabet. ");
INSERT INTO zamNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Sya, cabii ndxab Elisabet loo Mari: ―Mari, angngro' lezo' Diox mbli Diox ngòc más con' ndac lool leque loo rye mèngot co' naban dib athu loo izlyo'. No angngro' lezo' Diox gàc más con' ndac loo xgan'l co' gáala. ");
INSERT INTO zamNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tolo mdoodi's Elisabet. Ndxab Elisabet loo Mari: ―¿Chó nac daa par yi'th too naa xna' Tad daa daa, yoo? Yende cón ntac daa, ndyaquen. ");
INSERT INTO zamNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tac texal mbìnen guniil Diox loon, Mari, ale chàa, mden'en mbuin mbed co' ndoo nac xin'en ndxè' le'n xàn' le'nen, tant ndyac lezo' mbed, ndyaquen. ");
INSERT INTO zamNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Huen ndal, Mari, tac ngola'sl le' Tad Diox lique' co' mcàbgòn Tad Diox lool li Tad Diox lool. ");
INSERT INTO zamNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Sya, ndxab Mari loo Elisabet: Elisabet, dib nzo yéquen no dib nzo lezon mbezen loo Tad Diox: Tad Diox roo Tad Diox xèn nac U, Tad Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Leque daa ngue xo'f nde' ngue xo'f ndla' lezon. No anze'f ndyac lezon loo Diox, Diox co' nac Diox daa co' mtelá' daa loo ryethe con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tad Diox ngoque' cuent le' daa nacque' thìb moz loo Diox mastale' ndyaquen yende cón ntac daa. No desde nalle' par delant, ryete mèn co' naban chol tiemp, ñee mèna loon: Huen ndal, Mari, por cón che'n con' co' ngòc loon. ");
INSERT INTO zamNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Diox, co' nac Diox roo Diox xèn mblile' ngòc con' co' hui' mèn no con' co' ñaa mèn loon. Anze'f natú' nac lèe Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tlatque' lezo' Diox ñèe Diox mèn, mèn co' zyeb no mèn co' tyóo loo cón che'n Diox le'n rye tiemp. ");
INSERT INTO zamNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Con' roo no con' xèn nac co' nde teele' ndli Diox loo mèn. No mbli Diox ngòc nado' mèn nate's no mèn naxal'. ");
INSERT INTO zamNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mbli Diox par ngòc mèn co' mnibe' loo izlyo' ndxè' mèn be'the loo yalnibe' co' mnibe' mèn loo xtàa mèn. Le' loo mèn prob co' inacte mèn nate's na, mbli Diox ngòc mèn proba mèn roo no mèn xèn loo xtàa mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Le' mèn co' mque tee lan', mèn co' msyon co' hua, loo mèna Diox mbli ngòp mèna che'n mèn. Loo mèn ric na, mbli Diox nague's ya' mèna no nague's nii mèna. Yende cón ngòp mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Mblyath no Diox mèn nación Israel, mèn co' mxo'f zin' cón che'n Diox. Mblyat lezo' Diox gunèe Diox mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","No ngòcque' mblyath noque' Diox mèn nación Israel xalque' ngòc di's co' mcàbgòn Diox loo mbi' co' ngro' lèe Abraham co' ngòc xudgool na' no loo mèn guliz mbi' thidtene. ");
INSERT INTO zamNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ngolo mdoodi's Mari di'sa loo Elisabet, mbyan' Mari liz Elisabet casque' le'n son mbe'. Ngoloa, ndyàa Mari par liz Mari. ");
INSERT INTO zamNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nde nxon', mdyaa huiz co' mdoo nac xin' Elisabet. Ngóol xin' Elisabet. ");
INSERT INTO zamNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Co'se' mbìn mèn vecin Elisabet no mèn guliz Elisabet le' Diox mbli con' ndac loo Elisabet, ngua too naa mèna Elisabet no mbed par tyac lezo' mèna con Elisabet. ");
INSERT INTO zamNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ngolo xon huiz ngóol xin' Elisabet, mbe' Zacari ryop Elisabet mbed par gàc circuncidar mbed xal ngòc costumbr che'n mèn tiempa. Leque tiempa mblya's mèn tub lèe mèn mbed xal lèe Zacari, xud mbed. ");
INSERT INTO zamNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Per xna' mbed ndxab loo mèna: ―¡Aa'a! Juàn ryo' lèe mbed. ");
INSERT INTO zamNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mèna ndxab loo xna' mbed: ―¿Chonon indlya'stel ryo' lèe mbed Zacari, à'? Yende chó mèn gulizl nzo co' lèe Juàn, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sya, mbli mèna señ loo Zacari, xud mbed, par ñee mèna chó lèe ndlya's Zacari tyub lèe mbed. ");
INSERT INTO zamNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Per Zacari co' nac xud mbed mna'b thìb le' ye's loo mèna. Sya, mdub xud mbed di's loo ye's. Co'se' gunèe mèna mdub Zacari lèe mbed loo ye's co' ndlya's Zacari ryo' lèe mbed co' ndxab Zacari loo mèna loo ye's: Juàn ryo' lèe mbed, ante mbui' mèna no ante gunaa mèna por tataa mdub Zacari lèe mbed loo ye's. ");
INSERT INTO zamNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Leque hora, mbere Zacari, mdoodi's Zacari tedib vez. Ndxab Zacari: ―Anze'f Diox roo no Diox xèn nac Diox. No anze'f ndac tín' nac Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Co'se' ngolo nguri'th con' ngòc loo Elisabet no loo Zacari, ryete mèn xtàa no vecin Elisabet co' nzo ban no gax Zacari no Elisabet anze'f mzyeb no ante mbui' mèna no ante gunaa mèna. No mbyath mbyèn con' co' ngòc loo Elisabet no loo Zacari par ned le'n rye yèezya' co' nziri' le'n yiidyo' co' nac gulàaz che'n mèn jude. ");
INSERT INTO zamNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Co'se' mbìn rye mèn par neda con' co' ngòc loo Elisabeta, mbli mèna xtùuz no mnibdi's thìb thìb mèna loo thìb xtàa mèna no loo tedib xtàa mèna: ―¿Cón li mbeda? No ¿cón gác mbeda? Tac, lìcpe' ba'i, anze'f thìb con' ndac angmbli Tad Diox loo mbeda. ");
INSERT INTO zamNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Hora mbli Diox mtlo Zacari, mdoodi's Zacari tedib vez. No ngulàa Xpii Natú' che'n Diox loo Zacari. Mtlo Xpii Natú', mnibe' Xpii Natú' loo Zacari par bere Zacari, tyoodi's Zacari di's co' ndxab Diox angndoo Zacari tyoodi's Zacari. Ndxab Zacari: ");
INSERT INTO zamNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Loo Tad Diox co' nac Diox che'npe' mèn nación Israel ndyazen gab mèn le' Diox roo no Diox xèn nac Diox tac Diox mbi'th loo na', na' co' nac mèn nacionpe' che'n Diox. Mtelá'le' Diox na' loo con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mbli Diox par gáal thìb mbi' co' gàp con' roo no con' xèn la's nii mbi' no la's ya' mbi' par tí' no làa mbi' na' loo con' ryes. Gáal mbi'a làth mèn co' nac bin che'n David co' ngòc rey póla co' mxo'f zin' thìb zin' co' nac cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tataa mcàbgòn Diox gàca loo mèn nación Israel xal ndxab Diox te'th mèn co' mde'th di's co' ndxab Diox cón che'n co' gàc loo mèn nación Israel más póla. ");
INSERT INTO zamNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mbi' co' gáala yi'th yáal par tí' no làa mbi' na' loo mèn co' nac ngolo ngola's na' no la's ya' rye mèn co' ndxòo xyàn lezo' ñèe mèna na'. ");
INSERT INTO zamNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ndlyatque' lezo' Tad Diox ñèe Tad Diox na' xal mcàbgòn Tad Diox di's loo mèn co' ngòc xudgool na' li Tad Diox loo na'. Axta huiza no axta huiz nalze ne'ngyathla'ste Tad Diox cón che'n conveñ natú' co' mbli Diox con xudgool na'. ");
INSERT INTO zamNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Con' ndxè' nac con' co' mcàbgòn Diox loo xudgool na', Abraham, li Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Le' Diox tí' no làa Diox na' loo mèn co' nac ngolo ngola's na' par tataa mod ne'zyebte na' li na' sirv loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tataa li Diox par gàc na' mèn co' thidtene ngro xà' loo cón che'n xab izlyo' par gàc na' che'npe' Diox no par gàc na' mèn nalì no mèn nambìi loo Diox le'n ryethe huiz co' naban na'. ");
INSERT INTO zamNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ngolo gunii Zacari di's ndxè' loo Diox, mbere Zacari, mtlo Zacari, mdoodi's no Zacari Juàn xgan' Zacari co' nac mbedto' hora. Ndxab Zacari loo Juàn: ―Le' loo lùu na, xgan', lùu ryo' lèe mèn co' te'th di's co' gunii Tad Diox co' nac thidte Diox roo Diox xèn. Loo Tad Crist lùu ya ner par ya lu'l loo mèn no li nabl mèn par yòo mèn loo cón che'n Tad, ");
INSERT INTO zamNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","par tataa mod mèn co' nac mèn nacionpe' Diox ta' cuent xá mod lyá' mèna loo con' ryes no par ta' mèna cuent xá mod tyon' xtol mèna, ndee. ");
INSERT INTO zamNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tataa li Diox lool por tant ndlyat lezo' Diox ñèe Diox mèn no por anze'f nque' lezo' Diox ñèe Diox mèn. Lomisque', yi'th yáal thìb mbi' loo izlyo' ndxè'. Mbi'a li par tyub xnìi yéc mèn no li mbi' par tyub xnìi lezo' mèn loo cón che'n Diox xal co'se' ndlyen huiz par tenìi huiz loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mbi'a li par tyub xnìi yéc mèn no par tyub xnìi lezo' mèn, mèn co' nau' yéc nau' loo loo cón che'n Diox. No li mbi'a par tyub xnìi yéc mèn no par tyub xnìi lezo' mèn loo cón che'n Diox, mèn co' nzi tee ban loo co' nac xin no loo co' nac xnaa che'n con' co' ncàb nquée yalguth loo mèn. No li mbi'a par que tee ban na' rye nda na' no rye ndye'th na' làth xtàa na'. Con' ndxè' ngòc di's co' gunii Zacari no co' mde'th Zacari loo mbedto' co' ngòc Juàn, xgan' Zacari. ");
INSERT INTO zamNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Le' mbed xgan' Zacari co' nac Juàn na, mtlo mbed, ndoo roo mbed ndoo xèn mbed. No sate más ndyub xnìi yéc mbed no ndyub xnìi lezo' mbed loo co' nac xtùuz mbed loo cón che'n Diox. No ale ngua mbed par ngòo ban mbed co'te' nagán axta mzin huiz leque mbed mblu' too mbed loo mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Le'xque' le'n tiemp co'se' ngóol Juàn, ngo thìb mbi' co' ngòc gobiern co' mnibe' loo mèn casque' dib athu loo izlyo' tiempa. Mbi'a ngro' lèe rey Agust. Mbi'a mdub ñibe' loo mèn nación Israel, ne. Mnibe' mbi'a loo mèn yèezya' che'n rye làaz mèn nación Israel que no mèn nac zin' thìb padron yòolau. ");
INSERT INTO zamNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ner ye's co' ngòc padron mtoxcua' mèn co'se' ngòc thìb mbi' co' ngro' lèe Ciren gobernador loo mèn rye yèezya' co' nac mèn gulàaz siria. ");
INSERT INTO zamNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mnibe' Cesar Agust le' ryete mèn co' inzo bante co'te' nac làazpe' mèn no co'te' nac lizpe' mèn, mèn co' nzo ban chol lugar co'te' inacte làaz mèn, bii mèn par làaz mèn par gàc empadronar mèn, co' nee di's, ya lo mèn lèe mèn loo ye's yòolau co'te' nac làaz mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Cona, por fuerz mbli Chè ngro' Chè ryop Mari le'n yèez Nazaret. Ngua Chè ryop Mari thìb yèez co' nac làaz mèn jude par ngua Chè ryop Mari yèez Belén, co'te' ngóol mbi' co' ngro' lèe David co' ngòc rey axta pólle'a, par ya lo Chè lèe Chè loo padron yòolau tya tac Chè nde bin David co' ngòc reya póla. ");
INSERT INTO zamNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Sya, ngua Chè ryop Mari yèez Belén par ngua lo Chè lèe Chè ryop Mari loo padron par nacle' di's le' Mari selya' con Chè. No le'pe' ante pen ndoo Mari ndoo nac xin' Mari. ");
INSERT INTO zamNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Láth nzo Chè ryop Mari le'n yèez Belén, ale mtlo mden' Mari mquée yo'f lezo' Mari par gáal xin' Mari. Ale ngóol xin' Mari. ");
INSERT INTO zamNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Pues yèez Belena ngóol mbed co' ngòc ner mbed ndlyo xgan' Mari. Ngóol mbed le'n liz ngon co'te' ndoo ngon. Ngolo ngóol mbed, mchix Mari mbed lar' lad mbed. Ngoloa, ngua thix Mari mbed le'n thìb bate yaa co'te' ndxuhua ngon yix tac ya yende lugar co'te' cued Chè ryop Mari le'n mesón, tant huax mèn ndoo ned ndye'th. ");
INSERT INTO zamNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tiempa, mque no mèn co' ngòc mèn yèeza ranch mèn gaxte ro yèez Belén par huan par nqueno mèna mbacxil' tac mèna ngòc pastor co' thìb loote que no mbacxil' par nquenap mèna mbacxil' ndxáal yál'. ");
INSERT INTO zamNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Látha, chàa, ngro' too thìb angl che'n Tad Diox loo mèna. No mbyà'x thìb xnìi tín' che'n Tad Diox loo mèna. Látha, anze'f mzyeb mèna axta plóthe. ");
INSERT INTO zamNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Sya, ndxab angl loo mèna: ―Ne'zyebte gu', ey. Daa ndal no di's co' nac di's ndac co' tan cuent loo gu'. Di's ndac ndxè' càb le' rye mèn xyo'f nde' xyo'f ndla' lezo'. ");
INSERT INTO zamNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Di's ndac co' ngue niin loo gu' ndxè' no co' ngue tan cuent loo gu' ndxè' nac: Nalle'que' ngolo ngóol thìb mbed co' tí' no làa gu' loo con' ryes. Ngóolle' mbeda le'n yèez Belén co' ngòc liz no làaz che'n mbi' co' ngro' lèe David co' ngòc rey póla. Mbeda nac Crist co' nac Tad loo ryethe con'. ");
INSERT INTO zamNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Di's co' ngue niin loo gu' ndxè' nac di's co' ngue tan cuent loo gu' pá ngóol mbed. Co'se' ñèe gu' nax thìb mbeto' le'n thìb bate yaa co'te' ndxuhua ngon no nabix mbeto'a lar', sya, ta' gu' cuent mbedai. ");
INSERT INTO zamNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Leque hora, chàa, mbyú' loo huax angl loo angla no loo mèn co' nquenap mbacxil' ndxáal yál' rancha. Mtlo angla, mbil' ro angla loo Diox. Ndxab angla: ");
INSERT INTO zamNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Li na' le' lèe Diox gàc con' guryath no con' guryèn loo bé'. Le' loo izlyo' na, Diox li yu' yàl lezo' mèn loo Diox no cue ban mèn rye nda mèn no rye ndye'th mèn làth xtàa mèn. No tyac lezo' mèn loo con' co' nac co' nee lezo' Diox, mèn co' ndxòo lezo' Diox ñèe Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Le' sya, co'se' ngolo ndyàa rye angl loo bé' tedib vez, mtlo mèn co' nquenap mbacxil' rancha, mbez mèna loo thìb xtàa mèna no loo tedib xtàa mèna: ―Nda na' yèez Belén, tá. Nda tee hui' na' ñeene' cón ngòc cón che'n co' gunee Tad Diox loo na'a. ");
INSERT INTO zamNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mxen mèna ned. Sirs sirs nda mèna par yèez Belén. Látha, chàa, ngua loo mèna. Gunèe mèna Mari no Chè. Gunèe mèna mbed, ne. Nax mbed le'n thìb bate yaa co'te' ndxuhua ngon yix. ");
INSERT INTO zamNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Co'se' gunèe mèn co' ngue no ranch huan co' nquenap mbacxil' ndxáal yál' mbed, mda' mèna cuent loo chol mèn xal mda' angl cuent loo mèna cón che'n mbed. ");
INSERT INTO zamNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Co'se' ndxòn chol mèn cuent co' mda' mèna cuent, mèn co' nqueno mbacxil' ndxáal yál', ante ngüi' rye mèna no ante ñaa rye mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Co'se' mbìn Mari cón che'n di's co' ndyoodi's mèn co' nqueno mbacxil' ndxáal yál', ante le'n lezo' Mari non Mari di'sa. Yende chó loo mèn nda' Mari cuenta. Ante mdyóo Mari cón che'n di'sa no maste. ");
INSERT INTO zamNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ngolola na, mxen mèn co' nqueno mbacxil'a ned, ndyàa mèna. No mbez mèna naroo nac Diox no con' roo con' xèn nac co' mbli Diox. No ndxab mèna: Diox quix U', Diox, loo Diox tac ngòcque' con' xalque' mda' angl cuenta loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ngolo xon huiz ngóol mbed, mbli Chè ryop Mari mandad ngòc circuncidar mbed xal ngòc costumbr che'n mèn tiempa. No sangmdub lèe Chè ryop Mari mbed Jesús co' ngòc lèe co' ndxab angl loo Mari co'se' ndoore' quée loo mbed lezo' Mari. ");
INSERT INTO zamNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Co'se' ngolo mdyaa sman mbembìi Mari loo yíiz ftan xal ngòc costumbr co' mnibe' ley co' mxo'f Moisés loo mèn, mbe' Chè ryop Mari mbed le'n templ co' ndub le'n ciuda Jerusalén par lu' Chè ryop Mari mbed loo nguley' par ngòcque' no mdyaaque' no mdyubque' di's co' gunii Diox no co' mnibe' Diox li mèn par lu' mèna le' mbed nac che'npe' Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tataa mbli Chè ryop Mari tac loo ley co' mxo'f Moisés loo mèn ndub di's co' mnibe' Tad Diox le' ryete mbedbi' co' nerleque' gáal, mbeda gàc che'n Diox, co' nee di's, xo'f zin' mbed cón che'n Diox loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mbe' Chè ryop Mari chop mbin par guth nguley' mbina loo Diox xal mnibe' ley co' mxo'f Moisés loo mèn cón che'n mbed ndlyo, di's co' mbez: Chele' mèn ne'guthte chop ngoo', guth mèn chop palomxtil'. ");
INSERT INTO zamNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Le'n tiempa ngo ban thìb mbi' le'n ciuda Jerusalén co' ngro' lèe Simeón. Mbi'a ngòc thìb mbi' ndac. No thidtene indxàc falte mbi' le'n templ par mbez mbi' Diox no par mcòo' mbi' yéc mbi' loo Diox. Mdub quee lezo' mbi' ¿pól zin thìb huiz no zin thìb ze co'se' tel' Diox Crist co' mcui Diox par tí' no làa Diox mèn nación Israel loo mèn co' ngòc ngolo ngola's che'n mèn nación Israel por cón che'n Crist? No thidteneque' ñibe' Xpii Natú' che'n Diox loo mbi' co' ngro' lèe Simeón. ");
INSERT INTO zamNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Xpii Natú' che'n Diox mblo xo'f di's loo Simeón le' Simeón ne'gathte ndoore' hui' Simeón loo Crist co' tel' Diox, co' yi'th yáal loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simeón ngua le'n templ xal mnibe' Xpii Natú' loo Simeón. Co'se' ngòo no Chè ryop Mari mbed, co' lèe Jesús, le'n templ par gàca loo mbed xal ñibe' di's co' ndub loo ley co' mxo'f Moisés loo mèn, ");
INSERT INTO zamNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","sya, mxen mbi' co' ngro' lèe Simeón mbed. Mde's mbi' mbed. Ndxab mbi' di's co' nac di's natú' no di's roo no di's xèn loo Diox. Ndxab mbi' loo Diox, ne: ");
INSERT INTO zamNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Tad, nase gàca xal nee lezo' U' loon. La' U' gath daa tac U' mblile' no ngòcle' con' mcàbgòn U' gàc loon, daa co' nac moz U', Tad. ");
INSERT INTO zamNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nase gunèelen mbed co' tí' no làa mèn loo con' ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","No ngóol mbed ndxè' làth mèn. No mdoo U' mbed ndxè' loo mèn par tí' no làa mbed ryete mèn loo con' ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mbed ndxè' li par tyub xnìi yéc mèn no par tyub xnìi lezo' mèn loo cón che'n Diox, mèn co' inacte mèn nación Israel. No por cón che'n con' co' li mbed ndxè', xyo'f lèe xyo'f xti's mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Le' Chè ryop Mari na, ante mbui' no ante gunaa co'se' mbìn Chè ryop Mari di's co' mbez Simeón cón che'n mbed loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ngoloa, ndxab Simeón loo Mari no loo Chè: ―Ndlyazen le' Diox li huen nda gu', ndee gu'. Sya, ndxab Simeón loo Mari, xna' Jesús, ne: ―Mari, hui' nexa. Càba loo mèn nación Israel por cón che'n mbed ndxè' huax mèn lyá' loo con' ryes. No huax mèn tolo ryo xà' loo cón che'n Diox, ne, por cón che'n mbed ndxè'. No gàc mbed ndxè' xal thìb señ loo mèn nación Israel. Ale tè'b mèn nación Israel mbed no chobla' mèn nación Israel mbed. ");
INSERT INTO zamNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","No por cón che'n mbed, yú' no gàc be' xá ñaa con' ndli thìb thìb mèn xtùuz le'n lezo' mèn. Le' part cón che'nl na, Mari, ryete con' co' gàc loo xgan'l ndxè' càb lool xi lezo'l no ten'l thìb yalnè tín' le'n lezo'l xal co'se' nguiid mèn cuchi lad xtàa mèn. Thìba con' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Le' tediba na, le'xque' tiempa ngo thìb xa'gotgool co' ngro lèe An le'n templ. Xa'gota ngòc rsap thìb mbi' co' ngro' lèe Fanuel. Mbi' co' ngro' lèe Fanuela nde bin tedib mbi' co' ngro' lèe Aser. An ngòc thìb xa'gotgool tiempa, ngoxle' An. Per co'se' mselya' An, myen'got yèn'leque' An mselya' An. Pente mdub An con mbyòo co' mselya' Ana gaz lín' no maste ndoore' gath mbyòo. An be' mxec gunèe An mbed co' lèe Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Mxec An, mbyan' thìb An, thap gal nzo thap lín' anon nguth mbyòo co' ngòc sa'l An. Thidteneque' ngòo An le'n templ ze no yál'. Mxo'f zin' An zin' cón che'n Tad Diox. Huax vez xlat An mbez An Diox, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Le'xque' hora, mzin An le'n templ. Gunèe An mbed co' lèe Jesús. Ngurez An Diox. Ngolo ndxab An Diox quix U', Diox, loo Diox por cón che'n mbed co' lèe Jesús, mtlo An, mdoodi's An cón che'n mbed co' lèe Jesús loo mèn le'n ciuda Jerusalén, mèn nación Israel co' nzi quee lezo' lyá' mèn loo ryethe con' ryes la's ya' mèn co' ngòc ngolo ngola's loo mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Co'se' ngolo mdyaa ryete di's co' ndub loo ley co' mxo'f Moisés loo mèn nación Israel cón che'n ner myen'bi' bix co' ndxáal, ndyàa Chè ryop Mari con mbed co' lèe Jesús par ned le'n yèezya' che'n làaz mèn galile co'te' ngòc làazpe' Chè no Mari co' ngòc yèez Nazaret tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Le' mbed na, sate más ndoo roo mbed, no sate más ndoo xèn mbed, no sate más ale yub mbed ndoo yác mbed. Làth xtau'a, Diox mbli sate más ndxàc con' ndac loo mbed, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tiempa, xud mbed no xna' mbed mque tee lni pasc atate lín' co' ndxàc ciuda Jerusalén. Co'se' ndxàc lnia, huen huen nte' lezo' mèn nación Israel cón che'n co'se' mtelá' Diox mèn nación Israel la's ya' mèn nación Egipt más tiemp co' nde teele' ndri'th. ");
INSERT INTO zamNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Co'se' mtaa Jesús si' fchop lín', ngua Chè ryop Mari con Jesús lni pasc ciuda Jerusalén xalque' nac costumbr co' ngure no mèn tiempa no co' nguled no mèna tiempa. ");
INSERT INTO zamNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Co'se' ngolo mblyuz huiz lnia, mbii Chè ryop Mari ciuda Jerusalén. Per ne'nda'de Chè ryop Mari cuent le' Jesús mbyan' le'n ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mbli Chè ryop Mari xtùuz peser làth rye mèn co' ngua lnia ndye'th Jesús. Pues mdoo Chè ryop Mari ned thìb huiz. Syare', mcua'n Chè ryop Mari Jesús làth rye mèn guliz Chè no Mari no làth rye mèn co' ndlibe' Chè no Mari. ");
INSERT INTO zamNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Co'se' ñee Chè ryop Mari ne'yilode syal Jesús làth rye mèna, mbere Chè ryop Mari. Mquée Chè ryop Mari par ciuda Jerusalén tedib vez par cua'n Chè ryop Mari Jesús tya. ");
INSERT INTO zamNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Axta ngolo son huiz, syare' mbli Chè ryop Mari gan mzyal Jesús. Ndub Jesús làth mèn co' ngòc maistr che'n ley co' mxo'f Moisés loo mèna le'n templ. Ndub yòn Jesús di's co' ndyoodi's mèna no le'le' mnibdi's Jesús di's cón che'n di's co' ndyoodi's mèn loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Co'se' ndxòn rye mèn co' nac maistra di's co' ndyoodi's Jesús, ante ngüi' mèna no ante ñaa mèna xá mod susque' ndxác Jesús no xá mod susque' ndxác Jesús ncàb ndac Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Co'se' mzyal Chè ryop Mari Jesús, ndub Jesús le'n templ. Ale mbyu' mbyàl Chè ryop Mari. Ndxab Mari loo Jesús: ―Xgan', ¿chonon tatua' mbli nol nu', à'? Daa no xudl anze'f mdyóo nu' máal. No ale ngue tee cua'n nu' lùu. ");
INSERT INTO zamNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Sya, mcàb Jesús loo Chè no loo Mari. Ndxab Jesús: ―¿Chonon ngue tee cua'n gu' daa, à'? ¿Ché' inonte gu' le' daa naquinque' xo'f zin' zin' loo con' co' nac cón che'n xudpe'en, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Per ale ndxe'leque', ne'nda'de Chè ryop Mari cuent no indxònte Chè ryop Mari cón nee di's co' ndxab Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ngoloa, ndye'th no Chè no Mari Jesús par yèez Nazaret. Le' Jesús na, toloque' mdubdi's loo Chè ryop Mari. Le' di's co' ndxab Jesús loo Maria na, ante le'n lezo' Mari nanee Mari cón che'n di'sa. Yende chó loo mèn nda' Mari cuent cón che'n di'sa. Ante Mari ndyóo cón che'n di'sa. ");
INSERT INTO zamNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Látha, sate más ndoo roo mbed no ndoo xèn mbed. No sate más ndye'th xtùuz mbed yéc mbed. No sate más non mèn no nanee mèn le' mbed nac thìb mbed ndac loo Diox no loo mèn por cón che'n con' ndac co' mtlo ndli mbed. ");
INSERT INTO zamNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Co'se' ngòc lín' lín' si'n, lín'a o tiempa mdub mnibe' thìb mbi' co' ngòc rey loo mèn. Mnibe' mbi'a loo mèn casque' dib athu loo izlyo' tiempa. Mbi'a ngro' lèe Tiber. Leque lín'a ngòc Pons Pilat gobernador loo mèn co' ngòc mèn yèezya' che'n làaz mèn jude. Le' Herod na, ngòc gobernador loo mèn yèezya' che'n làaz mèn galile. Le' Lip hues Herod na, ngòc gobernador loo mèn yèezya' che'n làaz mèn iture. No ngòc Lip gobernador loo mèn yèezya' che'n làaz mèn traconit. Le' Liseni na, ngòc gobernador loo mèn yèezya' che'n làaz mèn abilini. ");
INSERT INTO zamNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Leque tiempa, ngòc Anás no Caifás nguley' roo no nguley' xèn loo mèn nación Israel. Leque le'n tiempa, Diox mblu' loo Juàn xgan' Zacari co'te' nagán xá mod que tee xo'f zin' Juàn zin' co' nac rsin' Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ngua riid Juàn huax lugar co'te' nziri' mèn gax ro yó'be' Jordán. Mbez Juàn loo mèna: ―Gulàa yéc gu' no gulàa lezo' gu' par tataa mod se' gu' mod co' ndxàp gu' loo Diox par tataa mod gàc tyon' xtol gu' no yiloa lin bautizar gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ngòcque' con'a tataa xalque' mque' Sayi co' mde'th di's co' ndxab Diox ye's loo libr co' nac xti's Diox. Sayi ndxab: Mbyèn thìb di's che'n thìb mbi' co' mbez yèe cabii co'te' nagán co'se' ngo mbi' yalbàn. Mbez mbi': Bli nab gu' gu' par tyubdi's gu' loo Tad Diox gu' tac Tad Diox gu' yi'th ñibe' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bli gu' par gàc loo gu' loo ryethe mod ye'rsin' co' ndxàp gu' xal ndli mèn co'se' nsè mèn thìb ftee, no xal ndli lal mèn thìb yii no thìb den, no xal ntelì mèn thìb ned co' nac ned narec, no xal ndli mèn co'se' ndli lal mèn thìb ned co' mtelau nít yòo par tataa mod gàc nab gu' co'se' yi'th ñibe' Tad Diox gu' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","No gàca le' ryete mèn gòn cón che'n xá mod tí' no làa Diox mèn loo con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Co'se' ndryo' mèn liz mèn no làaz mèn par nde mèn loo Juàn par li Juàn bautizar mèna, mbez Juàn loo mèna: ―¡Aa mèn ye'rsin'túb! Susque' nayi' gu' xal mbel' co' lèe huid. ¿Chó mèn ngòc mèn co' mda' cuent loo gu' par yi'th gu' loon par lyá' gu' la's ya' Diox co'se' gàc tiemp tetìi Diox gu', à'? ");
INSERT INTO zamNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nabe'ste fque tee ban lì gu' no gòc gu' mèn ndac par lu' gu' gu' loo mèn le' gu', lìcque', mzye' mod co' nac gu' no co' ndxàp gu' loo Diox. No ne'gabte gu' loo xtàa gu': Abraham ngòc xudgool na'. Na nii loo gu': Axta loo chol quèe co' ngüi' gu' ba', Diox ndxácque' par li Diox le' quèe ba' gàc xin' Abraham. No gàcque' quèe ba' xin' Abraham. ");
INSERT INTO zamNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ndxàcla loo gu' nalle'que' nde zin' gaxle' tiemp co'se' tlo gàc tub rez Diox cón che'n gu' par tetìi Diox gu' xal co'se' ntlo mèn, ngue cho' mèn thìb xan' yaa xlè co' inda'de xlè ndac. Yaa xlèa cho'. No tec mèn yaa xlèa loo quìi. ");
INSERT INTO zamNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sya, mnibdi's mèna loo Juàn. Ndxab mèna: ―¿Cón ndxàal li nu' loo cón che'n Diox nalle', sya? ");
INSERT INTO zamNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juàn mcàb loo mèna. Ndxab Juàn: ―Gu' co' ngue no chop camis, ndxàal ta' gu' thìb camis càa mèn co' ingue node nec thìb camis par goc mèna. Le' gu' co' ngue no xít gu' no lua' gu' na, ndxàal ta' gu' thìb ro xít gu' no lua' gu' par hua prob mèn co' ingue node con' hua mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Làth xtau'a, mbi'th plá mèn co' ndli cobrar cón che'n contribución loo Juàn par li Juàn bautizar mèna. Mèna mnibdi's loo Juàn. Ndxab mèna: ―Maistr, ¿nu', à'? ¿Con ndxàal li nu'? ");
INSERT INTO zamNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juàn ndxab loo mèna: ―Ne'lide gu' cobrar masre' loo mèn cón che'n contribución loo co' ñibe' ley loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mnibdi's plá solndad loo Juàn, ne. Ndxab solndad: ―¿Nu', a'? ¿Cón ndxàal li nu'? Juàn mcàb. Ndxab Juàn loo solndada: ―Ne'techede gu' nec thìb con' loo nec thìb mèn. Ne' ne' quexù' que' fals gu' mèn loo con' co' tarte li mèn. Blec lezo' gu' loo tmi co' ndli gu' gan thìb huiz zin'. ");
INSERT INTO zamNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Per ryete mèn co' nzi beda, imbe see teede xtùuz mèna no lezo' mèna. Ndli mèna xtùuz cón che'n Juàn: Ne'stolque' Juàn nac Crist. ");
INSERT INTO zamNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juàn mcàb loo mèna. Ndxab Juàn: ―Lìcpe' ba'i, daa ndli bautizar gu' con nít. Per axta nare' yi'th thìb mbi' co' lipe' par tlo ñibe' Xpii Natú' loo gu'. No tub rez mbi' cón che'n con' ye'rsin' co' ndli gu' par tetìi mbi' gu'. Mbi'a ndxàp más con' roo no con' xèn la's nii mbi' no la's ya' mbi' leque daa. Ne' ne' indxàal daa par xaquen bò co' ndub dó' yilid nii mbi' par làan yilid nii mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nde niin thìb con' loo gu': Nde zin' gaxle' huiz no nde zin' gaxle' ze co'se' li Diox loo gu' xal ndli mèn co' nguis nzob triu. Nguis mèn nzob triu no ngo' xà' mèn nzob triu loo yix triu. Ndxeloa, ngosua' mèn nzob triu. Le' yix triu na, tec mèn. Tataa li no Diox mèn. Le' mèn co' ngòc mèn nalì no mèn nambìi loo Diox na, Diox hue' mèna loo bé'. Le' mèn co' ngòc mèn naad no mèn nguud loo cón che'n Diox na, Diox ñibe' par ya mèna le'n ye'rbiil co'te' ne'yu'de quìi no bèel thidtene. ");
INSERT INTO zamNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Taandxè' mod ngo Juàn yalbàn. No tolo mco'x Juàn thìb mod no tedib mod co'se' mde'th Juàn no mblo Juàn yalbàn loo mèn cón che'n di's ndac. ");
INSERT INTO zamNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Más de cona, ale mbyoo Juàn Herod co' ngòc gobernador co' ngòc hues Lip tac Herod mque no Herodi co' ngòc sa'l Lip xal xa'got Herod. Mbyoo Juàn Herod por mbli Herod taamas con' ye'rsin', ne. ");
INSERT INTO zamNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Per lugar de gòn Herod di's no ten' Herod di's co' ndxàb Juàn cón che'n Herod, ale mbli Herod tedib con' ye'rsin'. Mbli Herod mandad ya que' solndad Juàn lezi'f. ");
INSERT INTO zamNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ndoore' que' solndad Juàn Bautist lezi'f, ngòc thìb con'. Juàn mbli bautizar huax mèn. Látha, mbli Juàn bautizar Jesús, ne. Ngolo ngòc bautizar Jesús, ngurez Jesús Diox. Látha, chàa, mxyal' loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ngulàa Xpii Natú' loo bé'. Hora, gunaa Xpii Natú'a xal thìb palomxtil' co'se' ngulàa Xpii Natú' loo Jesús. Texal ngulàa Xpii Natú' loo Jesús, mbyèn thìb di's loo bé' co' mbez: ―Lùu nac xgan' daa co' anze'f lezon no ngudloon. Anze'f ndxòo lezon ñèen cón che'nl, ey. ");
INSERT INTO zamNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Co'se' mtlo Jesús, mxo'f zin' Jesús zin' co' ngòc rsin' Jesús xal mnibe' Diox loo Jesús par li Jesús, nzo Jesús gal psi' lín'. Ngòc Jesús xgan' Chè xal mxyo'f di's co' ngola's mèn cón che'n Chè tiempa. Le' Chè na, ngòc xgan' thìb mbi' co' ngro' lèe Elí. ");
INSERT INTO zamNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Le' Elí na, ngòc xgan' Matat. Le' Matat na, ngòc xgan' Leví. Le' Leví na, ngòc xgan' Melqui. Le' Melqui na, ngòc xgan' Jan. Le' Jan na, ngòc xgan' tedib mbi' co' ngro' lèe Chè. ");
INSERT INTO zamNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Le' Chèa na, ngòc xgan' Matati. Le' Matati na, ngòc xgan' Amós. Le' Amós na, ngòc xgan' Nahum. Le' Nahum na, ngòc xgan' Esli. Le' Esli na, ngòc xgan' Nagai. ");
INSERT INTO zamNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Le' Nagai na, ngòc xgan' Maat. Le' Maat na, ngòc xgan' Matati. Le' Matati na, ngòc xgan' Semei. Le' Semei na, ngòc xgan' tedib mbi' co' ngro' lèe Chè. Le' Chèa na, ngòc xgan' Judá. ");
INSERT INTO zamNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Le' Judá na, ngòc xgan' Joan. Le' Joan na, ngòc xgan' Res. Le' Res na, ngòc xgan' Zorobabel. Le' Zorobabel na, ngòc xgan' Salatiel. Le' Salatiel na, ngòc xgan' Ner. ");
INSERT INTO zamNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Le' Ner na, ngòc xgan' Melqui. Le' Melqui na, ngòc xgan' Adi. Le' Adi na, ngòc xgan' Cosam. Le' Cosam na, ngòc xgan' Elmodam. Le' Elmodam na, ngòc xgan' Er. ");
INSERT INTO zamNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Le' Er na, ngòc xgan' Josué. Le' Josué na, ngòc xgan' Eliezer. Le' Eliezer na, ngòc xgan' Jorim. Le' Jorim na, ngòc xgan' tedib mbi' co' ngro' lèe Matat. ");
INSERT INTO zamNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Le' Matata na, ngòc xgan' tedib mbi' co' ngro' lèe Leví. Le' Levia na, ngòc xgan' Simeón. Le' Simeón na, ngòc xgan' tedib mbi' co' ngro' lèe Judá. Le' Judaa na, ngòc xgan' tedib mbi' co' ngro' lèe Chè. Le' Chèa na, ngòc xgan' Jonán. Le' Jonán na, ngòc xgan' Eliaquim. ");
INSERT INTO zamNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Le' Eliaquim na, ngòc xgan' Mele. Le' Mele na, ngòc xgan' Mainán. Le' Mainán na, ngòc xgan' tedib mbi' co' ngro' lèe Matat. Le' Matata na, ngòc xgan' Natán. ");
INSERT INTO zamNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Le' Natán na, ngòc xgan' David. Le' David na, ngòc xgan' Isaí. Le' Isaí na, ngòc xgan' Obed. Le' Obed na, ngòc xgan' Booz. Le' Booz na, ngòc xgan' Salmón. Le' Salmón na, ngòc xgan' Naasón. ");
INSERT INTO zamNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Le' Naasón na, ngòc xgan' Aminadab. Le' Abinadab na, ngòc xgan' Aran. Le' Aran na, ngòc xgan' Esrom. Le' Esrom na, ngòc xgan' Far. Le' Far na, ngòc xgan' tedib mbi' co' ngro' lèe Judá. ");
INSERT INTO zamNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Le' Judaa na, ngòc xgan' Cob. Le' Cob na, ngòc xgan' Isaac. Le' Isaac na, ngòc xgan' Abraham. Le' Abraham na, ngòc xgan' Tar. Le' Tar na, ngòc xgan' Nacor. ");
INSERT INTO zamNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Le' Nacor na, ngòc xgan' Serug. Le' Serug na, ngòc xgan' Rag. Le' Rag na, ngòc xgan' Peleg. Le' Peleg na, ngòc xgan' Heber. Le' Heber na, ngòc xgan' Sal. ");
INSERT INTO zamNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Le' Sal na, ngòc xgan' Cainán. Le' Cainán na, ngòc xgan' Arfax. Le' Arfax na, ngòc xgan' Sem. Le' Sem na, ngòc xgan' Noé. Le' Noé na, ngòc xgan' Lamec. ");
INSERT INTO zamNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Le' Lamec na, ngòc xgan' Matusalén. Le' Matusalén na, ngòc xgan' Enoc. Le' Enoc na, ngòc xgan' Jared. Le' Jared na, ngòc xgan' Mahalaleel. Le' Mahalaleel na, ngòc xgan' tedib mbi' co' ngro' lèe Cainán. ");
INSERT INTO zamNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Le' Cainana na, ngòc xgan' Enós. Le' Enós na, ngòc xgan' Set. Le' Set na, ngòc xgan' Adán. Adana ngòc ner mbi' co' nerleque' mtoxcua' Diox. Adana ngòc nerleque' mbi' co' ngòo loo izlyo' co' mblec biz no bin loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ngolo mbli Juàn Bautist bautizar Jesús, mbere Jesús, mbii Jesús ro yó'be' Jordán. Làth xtau'a, Xpii Natú' mnibe' loo Jesús, nda Jesús thìb lugar co'te' nagán. ");
INSERT INTO zamNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ngo Jesús co'te' nagána cho' huiz. Le'n huiza, ngua Mebizya co'te' ngo Jesús par mblobya' Mebizya Jesús. No mbli Mebizya preb loo Jesús par ñee Mebizya ñeene' ché' tli Jesús con' co' gab Mebizya loo Jesús. Le'n huiza ne'nghuade Jesús thidtene. Ngolo nguri'th rye huiza, anze'f mblyan' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sya, ndxab Mebizya loo Jesús: ―Chele' lùu, lìcque', nac xgan'pe' Diox, bli le' quèe ndxè' gàc pan par hual. ");
INSERT INTO zamNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús mcàb loo Mebizya. Ndxab Jesús: ―Loo libr co' nac xti's Diox ndlu': Iante con xít mèn no lua' mèn ban mèn. Ndxe'leque', mèn ban por cón che'n ryete di's co' nac xti's Tad Diox co' mbez Tad Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ngoloa, mbe' Mebizya Jesús loo thìb yii roo. No mbli Mebizya setilte mbyú' ryete nación co' nziri' dib athu loo izlyo' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Sya, ndxab Mebizya loo Jesús: ―Daa ta lugar lool par ñibe'l loo rye nación ba'. No tan lugar lool gàc ryethe con' roo no con' xèn che'n rye nación ba' che'npe' lùu tac che'npe'en nac rye nación ba' no ndana loo chol mèn co' ndlyazen tana. ");
INSERT INTO zamNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Chele' lùu tyub xib loon no còo'l yécl loon, ryethe con' ba' gàc che'nl. ");
INSERT INTO zamNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Per ale ndxe'leque', mcàb Jesús loo Mebizya. Ndxab Jesús: ―Byàa, Mebizya. Biiche loon. Loo libr co' nac xti's Diox ndlu': Diox ñibe' loo mèn. No ante loo Dioxpe' tyub xib mèn no còo' mèn yéc mèn loo Dioxpe' no maste. No ante loo Dioxpe' li mèn sirv. ");
INSERT INTO zamNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ngoloa, mbe' Mebizya Jesús le'n ciuda Jerusalén. Mtequée Mebizya Jesús yéc templ. Ndxab Mebizya loo Jesús: ―Chele' lùu, lìcque', nac xgan'pe' Diox, leque lùu bla' par gàb chel loo yòo. ");
INSERT INTO zamNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tac loo libr co' nac xti's Diox ndub di's co' mbez: Diox ñibe' loo angl che'n Diox par quenap angl lùu. ");
INSERT INTO zamNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Le' angl te'f ya' angl par lyàal ya' angl par quenap angl lùu par ne'huí'de niil loo quèe co'te' gàb chel. ");
INSERT INTO zamNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús mcàb loo Mebizya. Ndxab Jesús: ―Loo libr co' nac xti's Diox ndlu': Ne'aselidel par lil preb Tad Diox, co' nac Tad Diox lùu, par ñeel ñeene' ché' tli Tad Diox lùu con' ndlya'sl. ");
INSERT INTO zamNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Co'se' ñee Mebizya ya yende mod li Mebizya gan loo Jesús par li Jesús con' ndlya's Mebizya co'se' mblobya' Mebizya Jesús no co'se' mbli Mebizya preb loo Jesús par ñee Mebizya ché' tli Jesús con' ndlya's Mebizya, mxen Mebizya ned. Ndyàa Mebizya. Mblá' Mebizya Jesús ndxep tiemp. ");
INSERT INTO zamNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Le' Jesús na, mbere ndyàa par ned le'n yèezya' che'n làaz mèn galile. No Xpii Natú' che'n Diox thidteneque' ngo loo Jesús par li Xpii Natú' con' roo no con' xèn por cón che'n Jesús. Por cona, mbyath no mbyèn cón che'n Jesús le'n rye yèezya' che'n làaz mèn galile. ");
INSERT INTO zamNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mque tee lu' Jesús mèn co'te' ndub sinagog mèn ned ngua que tee Jesús. Ryete mèna sate más ndli mxyo'f lèe mxyo'f xti's Jesús. No ndxàc con' guryath no con' guryèn cón che'n Jesús làth mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ngoloa, ngro' Jesús par ned làaz mèn galile. Ndyàa Jesús par yèez Nazaret co'te' mbryoo mxyèn Jesús. Co'se' ngòc huiz sabd co' ndli mèn descans tiempa, Jesús ngòo le'n sinagog xalque' ngòc mod che'n Jesús par ndlab Jesús libr co' nac xti's Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Le' sya, mbi' co' ndyoo ner no co' ndyoo naa loo mèn le'n sinagog, mbi'a mda' libr co' mque' Sayi co' mde'th di's co' ndxab Diox ye's par lab Jesús ye'sa. Mxen Jesús libr. Co'se' mxal' Jesús loo libra, mzyal Jesús di's co' ndub loo libr co' mbez taandxè': ");
INSERT INTO zamNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Xpii Natú' che'n Tad Diox ngue ñibe' loon. Diox mdoo daa loo mèn par gon yalbàn no tethen cón che'n di's ndac co' nac cón che'n Diox loo mèn prob. No mtel' Diox daa par tegánen lezo' mèn co' nxi tín' lezo'. No mtel' Diox daa par telá'en mèn co' nac xal pres loo cón che'n Mebizya, no par tuben xnìi yéc mèn no lezo' mèn loo cón che'n Diox, mèn co' nau' yéc no mèn co' nau' loo loo cón che'n Diox. No mdoo Diox daa par telá'en mèn co' ndxezi'f no mèn co' ndxega's loo ryethe yaltìi co' nac cón che'n Mebizya. ");
INSERT INTO zamNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mdoo Diox daa loo mèn par tethen no gon yalbàn co' nac xti's Diox loo mèn le'n tiemp ndxè' co' nac tiemp ndac co' nac co' guneepe' lezo' Diox par tlo mèn, lyá' mèn loo ryethe con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ngolo mblab Jesús di'sa, mtau' Jesús loo libr. Mda' Jesús libr loo thìb mbi' co' nquenap sinagog. Ngoloa, mdub Jesús. Látha, xèe ngüi' mèn loo Jesús ñeene' cón gab Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sya, mtlo Jesús, mdoodi's Jesús. Ndxab Jesús loo mèna: ―Nalzepe' ngòcque' no mdyaaque' no mdyubque' di's co' ndub loo libr ba' co' ngolo mbìn gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Látha, rye mèna huenque' mdoodi's cón che'n Jesús. No ante ngüi' mèna no ante ñaa mèna cón che'n di's co' nabe's ndyoodi's Jesús loo mèna. No ale mnibdi's mèna loo xtàa mèna. Mbez mèna: ―¿Xá nee gu'? ¿Ché' inacte mbi' ba' xgan' Chè, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús ndxab loo mèna: ―Na tolo nii loo gu': Lìcpe' ba'i, daa ngobe' gu' ñee loon xal ndxab di's co' mbez: Doctor, leque lùu fteyacl. No ñee gu' loon: Con' co' mbìn nu' cón che'n con' co' mblil loo mèn yèez Capernaum, bli con'a loo mèn gulàazpe'l, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tolo ndxab Jesús loo mèna: ―Lìcpe' ba'i, na nii loo gu': Nec thìb mèn gulàaz che'n thìb mbi' co' nde'th di's co' ndxab Diox, ne'ñèe loo ndacte mèn gulàazpe' mèna loo prob mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Daa nii tedib con' co' nac lìcpe' loo gu', ne: Huax xa'got viud ngo ban trè' làth mèn nación Israel le'n tiemp co'se' mde'th Lii di's co' ndxab Diox co'se' ngòc tiemp co' ne'nglàade yuu le'n son lín' narol loo mèna. Ngulàa thìb huin tín' loo mèna tiempa, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Per Diox ne'ntel'te Lii loo nec thìb mèngot viud co' ngo ban làth mèna tiempa. Ndxe'leque', Diox mtel' Lii loo thìb xa'got viud co' ngo ban le'n thìb yèez tith co' ngro' lèe Sarept co' ngure gaxte ciuda Sidón. ");
INSERT INTO zamNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nonque' gu', ne, ngo huax mèn co' mque no thìb yíiz co' mteya's no co' mteyèe yid lad mèn le'n nación Israel, co' ngòc tiemp co'se' mde'th Elise di's co' ndxab Diox. Per ne'ngyacte nec thìb mèna por cón che'n Elise tiempa. ");
INSERT INTO zamNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Co'se' ngolo mbìn mèn co' ngo le'n sinagog di's co' ndxab Jesús, sya, ryete mèna anze'f ngocloo gunèe Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ngo too nde'f mèna. No nguree mcàa mèna Jesús. Mblo' mèna Jesús thib lad ro ciuda. Ale mbe' mèna Jesús loo thìb yii co'te' nziri' thìb yèez. Loo yiia ngue thìb quèe rhue. Tya mbe' mèna Jesús par tùub mèna Jesús par xàn'. ");
INSERT INTO zamNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Per co'se' mzin no mèna Jesús ro quèe rhue'a, mbli Jesús ale xèe ngure mèna. Látha, mbli Jesús thìb con' loo mèna. Xex xex nguri'th nde'f Jesús xi'th mèna, ndyàa Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ngoloa, mxen Jesús ned. Nda Jesús par ned ciuda Capernaum co' nac thìb ciuda che'n làaz mèn galile. Tya mblu' Jesús mèn atate huiz sabd co' ngòc huiz descans tiempa. ");
INSERT INTO zamNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Per co'se' ndxòn mèn di's co' ndyoodi's Jesús, mèna ante mbui' no ante gunaa mèna xal ngue lu' Jesús mèn tac ndyoodi's Jesús xalque' ñibe' Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Le'xque' huiza, ngo thìb mbi' le'n sinagog mèna. Mbi'a mque no thìb xpii ye'rsin'. Mbli xpiia par cabii ndxab mbi' loo Jesús: ");
INSERT INTO zamNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Blá' U' nu', Jesús, U' co' nac mèn yèez Nazaret. ¿Chonon ndxòo U' xi'th nu', à'? ¿Ché' nde U' par telux U' nu', cà'? Daa ndlibe' U', Jesús. Daa naneeque' le' U' nac mbi' natú' che'npe' Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús mbyoo xpii ye'rsin'a. Ndxab Jesús loo xpiia: ―¡Quex! Ftau' ro'l. Gro' loo mbi' ba'. Sya, mbli xpiia mquée mbii yéc mbi'. Ale ngulàa mbi' loo yòo loo ryete mèn co' ngo le'n sinagoga. Ngro xpii ye'rsin'a loo mbi'. Ale yende chó yalquìi ngòc loo mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ryete mèna mzyeb co'se' gunèe mèna con' co' ngòc loo mbi'a. No mbez mèna loo thìb xtàa mèna no loo tedib xtàa mèna: ―Susque' ndxác mbi' ba'. Ñibe' mbi' loo chol con'. No axta xpii ye'rsin' che'n meexù' ndxòn di's co' mbez mbi'. No ndryo xpii ye'rsin' che'n meexù' loo mèn ante por di's co' mbez mbi' no maste. ");
INSERT INTO zamNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","No ale ndyoodi's rye mèn yèezya' co' nac che'n làaz mèn ciuda Capernaum co' nziri' gax loo ciuda Capernaum cón che'n Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Texal ngro' Jesús le'n sinagog, ngòo Jesús liz Mon. Le'pe' nax xna'zap Mon loo xlé'. Nalyat ndxab mèn guliza loo Jesús: ―Tad, fteyac U' mbíiz ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Sya, mbii gax Jesús co'te' nax xna'zap Mon. Mteyac Jesús guna'. Leque hora, ngro xlé' guna'. No ngo che guna'. Mbli guna' cas mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Co'se' nde bix huiz huiza, nde no mèn mèn yíiz co' ndyac len chol yíiz loo Jesús par teyac Jesús mèna. Ante mxo'f Jesús ya' Jesús lad rye mèn yíiza, mteyac Jesús mèn yíiza. ");
INSERT INTO zamNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Làth rye mèn yíiz co' mbi'th no mèn loo Jesús ngòo mèn co' mque no xpii che'n meexù', ne. Co'se' mblo' Jesús xpii che'n meexù' loo mèna, mbli xpii meexù'a par mbez mèna cabii loo Jesús: ―U' nac xgan'pe' Diox. Jesús mbyoo xpii meexù'a. Ne'nda'de Jesús lugar tolo ngnii xpiia tac xpii meexù' co' ngo loo mèna nonque' no naneeque' le' Jesús nacque' Crist. ");
INSERT INTO zamNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Co'se' ngo nìi izlyo' tedib huiz co' nde nquea, Jesús ngro' thìb lad ro ciuda co'te' yende chó mèn nzo no co'te' ne'ñeede mèn Jesús. Per mèn co' nziri'a mcua'nque' Jesús. Ngua mèna co'te' nzo Jesús. Mcua'n mèna mod par telen' mèna Jesús par ne'biide Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesús ndxab loo mèna: ―Bla' gu' biin, ey. Tac daa naquinque' ga lo yalbàn loo mèn le'n taamas yèez, ne, cón che'n xá mod ndlya's Diox ñibe'pe' Diox loo mèn. Tac por cona mtel' Diox daa loo mèn loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Cona, toloque' mque tee go Jesús yalbàn loo mèn le'n rye yèezya' co'te' ndub sinagog che'n mèn co' nac mèn yèezya' che'n làaz mèn galile. ");
INSERT INTO zamNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Thìb vez ngòc thìb con'. Jesús ngo gax ro thìb lagun co' lèe lagun che'n làaz mèn genesaret. Látha, anze'f thìb mènléy' mqueltàa loo Jesús axta mdí' mèna Jesús. Anze'f thìb mèn mblya's ngòn di's ndac che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús gunèe ndub chop yòoyaa loo laguna gaxte ro play. No gunèe Jesús yende chó mèn nzo loo yòoyaaa. Tac mèna ngro' loo yòoyaa par tech mèna yex mèna. Mèna ngòc mèn co' ndyen mbèel. ");
INSERT INTO zamNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Le' sya, ngòo Jesús loo thìb yòoyaa. Yòoyaaa ngòc che'npe' Mon Pedr. Mna'b Jesús loo Mon Pedr tetee Mon Pedr yòoyaa taachu'te más par le'n lagun. Mtlo Jesús, mblu' Jesús mèn axta co'te' ndub yòoyaa loo lagun. Le' mèna na, ngure ro laguna. ");
INSERT INTO zamNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Co'se' ngolo mdoodi's Jesús loo mèn co' mqueltàa, ndxab Jesús loo Mon Pedr: ―Ya' nda na', Mon. Ftetee yòoyaa. Nda na' co'te' más na's nzi nít par cobii gu' yex gu' le'n nít par yigaa mbèel le'n yex. ");
INSERT INTO zamNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mon Pedr mcàb loo Jesús. Ndxab Mon Pedr: ―Maistr, dib xec yál' mque tee gobii nu' yex le'n nít. Per nec thìb mbèel ne'nglide nu' gan ngagaa. Per ya que ñibe'le' U' loon, nda lobiin yex le'n nít ñeene' ché' tagaa mbèel le'n yex. ");
INSERT INTO zamNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Co'se' mblobii Mon Pedr con myen' xtàa Mon Pedr yex le'n nít, axta mbryed yex tant thìb mbèel ngogaa le'n yex. ");
INSERT INTO zamNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sya, mbli Mon Pedr no xtàa Mon Pedr señ loo taamas mèn co' nac xtàa Mon Pedr co' nzo le'n tedib yòoyaa par yi'th lyath no myen' Mon Pedr. Sya, mtetee myen' yòoyaa myen' loo nít axta co'te' ndub yòoyaa Mon Pedr loo nít. Mblyath no myen' Mon Pedr con xtàa Mon Pedr. Msè myen'a ryop yòoyaa con anab mbèel axta yamerle' dyep yòoyaa le'n nít tant né' yòoyaa con anab mbèel. ");
INSERT INTO zamNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Co'se' ñèe Mon Pedr ndxàc con'a, mdub xib Mon Pedr loo Jesús. Ndxab Mon Pedr loo Jesús: ―Tad, inzyalte daa ngue tee non U' tac daa nac thìb mbi' co' ndxàp xtol no co' ncua'n xquin. Más huen ya ne'tolode que tee non U', ndyaquen. ");
INSERT INTO zamNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ante mbui' Mon Pedr con myen' co' ngòc xtàa Mon Pedr no ante gunaa Mon Pedr con myen' co' ngòc xtàa Mon Pedr por tant thìb mbèel co' ngogaa le'n yex. ");
INSERT INTO zamNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Leque con' co' ngòc loo Pedr ngòc loo Cob no Juàn co' ngòc xgan' Zebede co' ngòc xtàa Mon Pedr. Per mden' lezo' Jesús con'a. Jesús ndxab loo Mon Pedr: ―Ne'zyebtel, Mon. Desde nalle' par delant, ñibe'en lool tatua' lil loo mèn par tyal mèn yòo mèn loo cón che'n Diox xalque' mblin ngogaa tant mbèel ba' le'n yex. ");
INSERT INTO zamNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Co'se' mzin no rye mèna yòoyaa ro yòo biz, taate mblá' Mon Pedr no Cob no Juàn yòoyaa nazál' mbèel yòoyaa. Mblá' Mon Pedr no Cob no Juàn zin'a, ne. Mdoo nque Pedr no Cob no Juàn xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Láth ngo Jesús le'n thìb yèez, mzin thìb mbi' co' mque no thìb yíiz co' nteya's no co' nteyèe yid lad mbi' loo Jesús. Co'se' gunèe mbi' Jesús, mdub xib mbi' loo Jesús no mcòo' mbi' yéc mbi' loo Jesús. Nalyat mde'f ro mbi' loo Jesús. Mna'b mbi' loo Jesús. Ndxab mbi': ―Tad, chele' U' ndlya's teyac U' daa, U' ndxác nteyac mèn. Fteyac U' daa, Tad. ");
INSERT INTO zamNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sya, ante mxo'f Jesús ya' Jesús lad mbi' no ndxab Jesús loo mbi': ―Ndlyazen le' lùu yac. Texal ngolo ndxab Jesús di'sa loo mbi', chàa, mbyac mbi'. Mbembìi lad mbi'. Mbiiche yíiz co' mteya's no co' mteyèe yid lad mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sya, mnibe' Jesús loo mbi'. Ndxab Jesús: ―Yende chó loo ta'l cuent cón che'n con' co' ngolo ngòc lool ba'. Ante huàa lu'l loo nguley' le'n templ. No sangta'l ofrend co' mnibe' Moisés loo mèn ta' mèn co'se' ndxelo ndxac mèn loo yíiz co' mxac lùu ba'. Tataa huàa li par non mèn no ta' mèn cuent le' lùu mbyacle'. ");
INSERT INTO zamNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Le' cón che'n Jesús na, sate más ndxath ndxèn no sate más mqueltàa mèn loo Jesús par gòn mèn di's ndac che'n Diox co' ndyoodi's Jesús no par teyac Jesús mèn loo chol yíiz co' mque no mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Per ale ndxe'leque', ngro' Jesús thìb lad làth mèna. Ngua rez Jesús Diox tya. ");
INSERT INTO zamNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ngòc thìb con' thìb huiz láth ngue lu' Jesús mèn liz thìb mbi'. Xi'th mèn co' nziri'a nzi ndub ndxep mèn co' ngòc mèn xley' farise. No mdub ndxep mèn co' ngòc maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn nación Israel. Mèna ngro' le'n rye yèezya' che'n làaz mèn galile, no co' nac rye yèezya' che'n làaz mèn jude, no ngro' mèna ciuda Jerusalén. Látha, ndxàc con' roo no con' xèn che'n Diox la's nii Jesús no la's ya' Jesús par ngue teyac Jesús mèn yíiz. ");
INSERT INTO zamNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Látha, mzin ndxep mènbi'. Nde no mèna thìb mbi' loo thìb cami. Mbi' mque no mbii che'n yíiz co' ntequech mèn. Ale mtequech mbii mbi'. Mblya's mèna ale sangyòo no mèna mbi' le'n nyòo co'te' nzo Jesús par quix mèna mbi' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Per yende mod yòo no mèna mbi' yíiza loo Jesús le'n nyòo tant thìb mènléy' nziri' loo Jesús. Sya, mcua'n mèna mod. Mquée no mèna mbi'a par yéc yòo. Ale mxal' mèna yéc yòo. No mcua'n mèna mod. Mtedó' mèna cami con dó' par làa mèna mbíiz nazál' cami mbíiz par le'n nyòo xi'th mèn loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Co'se' ñèe Jesús le' mèna ndxela'spe' no, lìcque', ndxàp mèna yalxla's loo Jesús, ante ndxab Jesús loo mbi' yíiza: ―Mbi', xtol lùu no xquin lùu mton'len. ");
INSERT INTO zamNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Sya, mèn co' ngòc maistr cón che'n ley co' mxo'f Moisés loo mèn no mèn xley' farise, mtlo mèna, mbli mèna xtùuz le'n lezo' mèna no ndxab mèna le'n lezo' mèna: ¿Chó mbi' ndli mbi' ba' cuent nac mbi'? Ale ndli mbi' ba' cuent nac mbi' Diox. Anze'f nazab nac co' ndli mbi' cuent nac mbi'. Non na' no nanee na' yende chó mèn izlyo' gác ton' xtol mèn no xquin mèn. Angoluxte Diox ndxác nton' xtol mèn no xquin mèn, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Per Jesús nonque' con' co' ngue li mèna xtùuz. Ndxab Jesús loo mèna: ―¿Chonon tatua' ndli gu' xtùuz le'n lezo' gu', à'? ¿Xá nee gu'? ");
INSERT INTO zamNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ñibdizen thìb con' loo gu': ¿Cón nac co' más inagànte par daa par gaben loo mbi' ba'? ¿Ché' más inagànte gaben: Xtol lùu mton'len o ché' más inagànte gaben: Goo che no byàa lizl, cà'? Per ale yende chó mèn mcàb loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tolo ndxab Jesús loo mèna: ―Daa ndxab loo mbi' ba' mton'len xtol mbi' par ñee gu' no yila's gu' le' daa, co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo', ndxàpen con' la's niin no la's yan loo izlyo' ndxè' par ton'en xtol mèn. Sya, alanleque' ndxab Jesús loo mbi' yíiz co' mtequech mbiia loo rye mèna, loo lùu ngue niin: ―Goo too, fthùuz dáal, byàa lizl. ");
INSERT INTO zamNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Leque hora, chàa, ngo too nde'f mbi' co' mtequech mbiia loo rye mènléy' co' nziri'. Ale mthùuz mbi' dáa mbi' co' ngo'th mbi'. No ale mxen mbi' ned, ndyàa mbi'. No mbez mbi': ―Ay, Dio's. Con' roo con' xèn mbli Diox loon, yey. Ale mteyac Diox daa. ");
INSERT INTO zamNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ryete mèn co' nziri'a, ante mbui' mèna no ante gunaa mèna. Mbez mèna: ―Con' roo no con' xèn nac co' ndli Diox, cara. No por gunèe mèna le' mbi'a mbyacle', anze'f mzyeb mèna no ndxab mèna loo xtàa mèna: ―Nalze, por derech, mbui' na' ngòc thìb yalguzye' roo no thìb yalguzye' xèn loo na' no loo mbi' co' mbyaca, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ngolo ngòc con' co' ngòc loo mbi' co' mtequech mbiia, ngro' Jesús liz mbi' co'te' ngòc con'a. Láth nda riid Jesús par neda, gunèe Jesús mdub thìb mbi' co' ngro' lèe Leví. Ndub li mbi' cobrar cón che'n contribución. Ndxab Jesús loo mbi': ―Ftoo nque xísen. Ya' nda na'. ");
INSERT INTO zamNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Texal mbìn mbi' di's co' ndxab Jesús, ngo too mbi'. Mblá' mbi' rye con' ngue no mbi' tya. Nda no mbi' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ngolo nguri'th plá huiz, mbli Leví mandad ngòc thìb yalhua liz Leví par hua no Leví Jesús. Nde nxon', mqueltàa huax mèn co' ndli cobrar cón che'n contribución no taamas mèn liz Leví par thidte hua no mèna Leví con Jesús loo mes. ");
INSERT INTO zamNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mèn co' ngòc mèn xley' farise no mèn co' ngòc maistr co' mblu' cón che'n ley co' mxo'f Moisés loo mèn, mèna nziri' loo lue' no ro ryo' liz Leví. Nzi la's mèna xal ngue yuhua no Jesús Leví no taamas mèn co' mqueltàaa. Sya, mtlo mèna, xexte ngue bez mèna loo myen' xin' mté'th Jesús. Ndxab mèna: ―¿Chonon nzi yuhua no gu' mèn co' ndli cobrar cón che'n contribución no con mèn co' ndxàp xtol, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Per lugar de càb myen' xin' mté'th Jesús loo mèna, ale yub Jesús mcàb loo mèna. Ndxab Jesús loo mèna: ―Hui' gu' nexa. Daa tetac thìb di's loo gu'. Le' mèn co' huen nzo lezo' no indyac yíizte mèn, mèna ndyac inquinte teyac doctor mèna. Per mèn co' ndyac yíiz, mèna naquinque' teyac doctor. ");
INSERT INTO zamNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Daa ne'ngalte par bezen mèn co' ndyac nac mèn ndac. Ndxe'leque', daa ndal par bezen mèn co' non le' mèna ndxàp xtol par lyàa yéc mèna no lyàa lezo' mèna no par zye' mod co' ndxàp mèna loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sya, mnibdi's mèn farise no mèn co' ngòc maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn loo Jesús. Ndxab mèna: ―¿Chonon mèn co' ngòc xin' mté'th Juàn no mèn co' ngòc xin' mté'th mèn xley' farise anze'f ngure xlat no ngòc mèna mèn co' anze'f ngurez Diox. Per ndxe'leque', myen' xin' mté'th lùu ba' ale ndxuhuaque' no ndxuque', à'? ");
INSERT INTO zamNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús mcàb loo mèna. Ndxab Jesús loo mèna: ―Nde niin thìb con' loo gu'. No ndlyazen càb gu' loon: ¿Ché' nzo mod li gu' thìb con' co'se' mselya' thìb ned myen' co' mselya' par cue xlat mèn co' nac mèn guliz mbyòo láth nzo yalhua liz mbyòo co' mselya' no láth nzi no mbyòo mèna liz mbyòo, cà'? Yende moda, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Per zin thìb huiz no zin thìb ze co'se' ya ne'yo node no ya ne'cue node mbyòo co' mselya' mèn co' nac mèn guliz mbyòo. Axta syare', gàc huiz co'se' cue xlatque' mèn co' nac mèn guliz mbyòo co' mselya'. ");
INSERT INTO zamNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mtetac Jesús tedib di's loo mèna, ne. Ndxab Jesús loo mèna: ―Nde niin tedib con' loo gu': Yende chó xa'got nzo co' cho'xù' thìb vestid cub par co bdè xa'gota lar' co' nac vestid cub thìb vestid gox. Chele' xa'gota tataa li, ale teza'xù' xa'gota vestid cub, ¿lé'? Más de cona, indxàalte yòo bdè lar' cub che'n vestid cub loo vestid gox. ");
INSERT INTO zamNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tolo ndxab Jesús loo mèna: Yende chó mèn nzo co' co mezcal co' diz ngro' palenc le'n thìb garrafón gox co' nalé'le', ¿lé'? Tac chele mèn co mezcal co' diz ngro' palenc le'n thìb garrafón gox co' nalé'le', le' sya, tolo lyé' garrafón goxa no xyo mezcala. Ngòc perdid ryop con'a. ");
INSERT INTO zamNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Por cona, más huen co mèn mezcal co' diz ngro' palenc le'n thìb garrafón cub. Sya, tataa mod nabe'ste quenap mèn ryop con'a. ");
INSERT INTO zamNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Más de cona, yende chó mèn co' ndxu mezcal co' ndxàcle' mbe' ngue no mèn tyubla's mèna gu mèna mezcal co' diz ngro' palenc. Tac mbez mèna loo xtàa mèna: Ale ndyac na' masque' nix nac mezcal co' ndxàcle' mbe' ngue no na' leque mezcal co' diz ngro' palenc, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ngòc thìb con' thìb huiz sabd co' ngòc huiz descans tiempa. Nda riid Jesús co'te' nax thìb le' yòo co'te' mblo mèn bin nzob triu. Láth nda riid no Jesús myen' xin' mté'th Jesús le'n ña' triua, mtlo myen' xin' mté'th Jesús, mcho' myen' bacdò triua. No mtlo myen', mdobya' myen' bacdò triu par hua myen' nzob triua. ");
INSERT INTO zamNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sya, ndxab ndxep mèn xley' farise co' nziri' tya loo myen' xin' mté'th Jesús: ―¿Chonon indyubdi'ste gu' xal mnibe' Moisés loo na' loo ley co' mxo'f Moisés loo na' par ne'lide gu' zin' huiz descans co' nac huiz sabd, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Per ale le'le' yub Jesús mcàb loo mèna. Ndxab Jesús: ―¿Ché' tarte lab gu' di's co' ndub loo libr co' nac xti's Diox co' nda' cuent no co' ndlu' cón che'n con' co' mbli David co' ngòc rey póla thìb vez co'se' mblyan' David no mblyan' mèn co' mque tee no Davida, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David ngòo le'n tabernáculo che'n Diox tiempa. Negadi's mxen David pan co' nzi'f loo mes co' ngòc pan natú' loo Diox ndoore'. Nduhua David pana. Mda' David pana nduhua mèn co' ngo no David le'n tabernáculo, ne. Per gu' nonque' no naneeque' gu' le' pana indxàalte hua chol mèn. Ndxe'leque', ante nguley' ndxàp permis hua pana xalque' ngòc mod co' ngòp mèna tiempa. Per ale ne'ngode Diox cuent le' David mbli con' ye'rsin' co'se' mbli David con'a. ");
INSERT INTO zamNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ndxab Jesús loo mèna, ne: ―Daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo' ndxè', daa ñibe'pe' loo mèn cón li mèn huiz sabd. ");
INSERT INTO zamNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ngòc tedib con' tedib huiz sabd co' nac huiz descans co' nde nquea. Jesús ngòo le'n sinagog. Mtlo Jesús, mblu' Jesús mèn. Ngo thìb mbi' yíiz xi'th mèna, ne. Mbi'a mque no sa ya' mbi' co' nac ladlì. Ale mbiiz cue' sa ya' mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Làth mèna ngòo ndxep mèn co' ngòc maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèna no ndxep mèn xley' farise, ne. Mèna xèe nzi la's loo Jesús par ñee mèna ñeene' ché' teyac Jesús mbi'a huiz sabd par tataa mod tyub nii mèna quexù' que' fals mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Per Jesús nonque' xtùuz co' ngue li mèna xtùuz. Ndxab Jesús loo mbi' co' nayíiz ya'a: ―Goo too xi'th mèn ba'. Sya, ngo too mbi' xi'th mèn co' nziri' tya. ");
INSERT INTO zamNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Sya, mbere Jesús. Ndxab Jesús loo mèn co' ngòc maistr no loo mèn xley' farise: ―Ñibdizen thìb con' loo gu'. ¿Cón nac con' co', lìcque', mnibe' Diox loo mèn li mèn huiz sabd co' nac huiz descans? ¿Xá nee gu'? ¿Ché' ndxàal li mèn con' ndac o ché' ndxàal li mèn con' ye'rsin', à'? ¿Ché' más ndxàal tí' no làa mèn xtàa mèn loo con' ryes huiz sabd co' nac huiz descans o ché' más ndxàal guth mèn xtàa mèn huiz sabd co' nac huiz descans, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sya, mbui' Jesús loo ryete mèn co' nziri' loo Jesús. No ndxab Jesús loo mbi' yíiza: ―Ftega' ya'l, ey. Mbi' mtega' ya' mbi'. Ale, chàa, mbyac ya' mbi'. Mbyan' ya' mbi' xalque' taasa ya' mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Syase, por derech, ngòc loc mèn xley' farise no mèn co' ngòc maistr che'n ley co' mxo'f Moisés loo mèn, tant ngro' nayi' mèna gunèe mèna Jesús. Mtlo mèna, mbez mèna loo thìb xtàa mèn no loo tedib xtàa mèn: ―¿Cón li no na' mbi' ba' par guth na' mbi' ba' thidtene, cara? ");
INSERT INTO zamNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Leque le'n huiza, mxen Jesús ned. Nda Jesús loo thìb yii par cuez Jesús Diox. No dib yál' ngurez Jesús Diox yál'a. ");
INSERT INTO zamNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Co'se' ngo nìi izlyo' tedib huiz co' nde nquea, Jesús mtel' chez mèn co' ngòc xin' mté'th Jesús par mqueltàa no mèna Jesús. Mcui Jesús si' fchop myen'. Jesús mblo lèe myen'a mèn co' ndxe' di's che'n Jesús loo mèn dib athu loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ryete si' fchop myen'a ngòc mèn ndxè': Mon, co' mdub Jesús tedib lèe co' ngòc lèe Pedr; Ndech, hues Mon; Cob; Juàn; Lip; Bartol; ");
INSERT INTO zamNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mate; Max; Cob, co' ngòc xgan' Alfe; Mon, co' ngòc thìb mbi' co' ngòc partid che'n thìb ned mèn co' ngro' lèe cananist; ");
INSERT INTO zamNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jud, hues Cob; no Jud Iscariot, co' ngòc entregador co' mblu'xù' Jesús loo mèn co' ngòc ngolo ngola's che'n Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ngoloa, ngulàa tùub no Jesús myen' xin' mté'th Jesús loo yiia. Jesús mbyan' loo thìb la's co' nziri' xan' yiia con myen' co' ngòc xin' mté'th Jesús. Ngure huax mènléy' tya, ne. Mèna nde le'n rye yèezya' co' nac che'n làaz mèn jude. No nde mèn ciuda Jerusalén. No nde mèn costeñ co' nde par ned cost Tir no mèn costeñ co' nde par ned cost Sidón. Mèna mbi'th par gòn mèna di's co' ngo Jesús yalbàn no par teyac Jesús mèn co' ndyac chol yíiz. ");
INSERT INTO zamNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mblo' Jesús xpii meexù' loo mèn co' mxactìi por cón che'n xpii meexù'a, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ryete mèn yíiz mblya's ante gàal mèn yíiz Jesús tac mèna ñee mteyac Jesús mèna ante por cón che'n con' co' nzo la's ya' Jesús no co' nzo la's nii Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Látha, mbui' Jesús loo myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Huen nda gu' co' nac mèn prob tac Diox ñibe'pe' loo gu' nalle'. ");
INSERT INTO zamNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Huen nda gu', gu' co' nde che con' loo no gu' co' nzi yath huin nalle' tac yiloa Diox li hua gu' axta plóthe. Huen nda gu', gu' co' ndxón' nalle'. Per zin thìb huiz no zin thìb ze li Diox tyac lezo' gu' no xyo'f nde' xyo'f ndla' lezo' gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Huen nda gu' co'se' tlo yòo xyàn lezo' mèn ñèe mèn gu'; co'se' tè'b mèn gu' thìb lad; co'se' aseli mèn ta' mèn xyàn lezo' gu'; no co'se' ne' ne' indlya's mèn gòn mèn cón che'n gu'. Mèna li cuent le' gu' nac mèn ye'rsin' por cón chenen, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Cona, ngue niin loo gu': Fxo'f nde' fxo'f ndla' lezo' gu' axta plóthe no cue gu' guyith guxìis le'n tiemp ndxè' tac Diox angta'la's huax con' ndac loo gu' loo bé' co' gàc che'n gu' co'se' gàc huiza. Gu' nonque' no naneeque' gu' tatua'que' mbli xudgool mèna ngòc nguàal con' loo prob mèn co' mde'th di's co' ndxab Diox póla, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tolo ndxab Jesús: ―Per, ay prob gu' izlyo', mèn ric. Tac nalle' ngolole' mda' gu' gust lezo' gu' axta plóthe. Nase guneele' cón che'n gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ay, prob gu' izlyo'. Ale ndlya's gu' que no gu' ryethe con' lya's gu' axta plóthe. Yiloa, ten' gu' huin axta plóthe, ne. Ay, prob gu' izlyo', gu' co' alithe ndyac lezo' no co' alithe nzo'f nde' nzo'f ndla' lezo'. Zin thìb huiz no zin thìb ze co'se' gón' gu' no xi lezo' gu' axta plóthe. ");
INSERT INTO zamNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ay, prob gu' izlyo'. Ryete mèn nabe'ste nda' cuent cón che'n gu' nalle'. Pues, tataaguè' mbli mèn co' ngòc mèngool tiempa con mèn gutyè' co' ndxab mde'th mèna di's co' ndxab Diox. Per ilìcte mde'th mèna di's co' ndxab Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Gu' co' nzi yòn di's co' ngue niin loo gu', niin con' ndxè' loo gu': Fque' lezo' gu' gunèe gu' mèn co' nac ngolo ngola's che'n gu'. Bli gu' con' ndac loo mèn co' ndxòo xyàn lezo' ñèe gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nado' di's nado' cuent gunii gu' loo mèn co' ñii yèe ñii tìi cón che'n gu'. Gurez gu' Diox por cón che'n mèn co' asendli ngòc nguàal con' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Chele' chó mèn quis thìb lad cuat gu', fta' gu' tedib lad cuat gu' par quis mèna, ne. Chele' chó mèn ndlya's a la fuerz teche mèna chamar gu', bla' gu' teche mèna camis gu', ne. ");
INSERT INTO zamNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ftechè gu' con' loo mèn co' nde techè con' loo gu'. Le' mèn co' angmbe'xù' cón che'n gu' na, yende chó gabte gu' loo mèna par bere mèna, yilá' mèna co' mteche gu' loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Fcua'n gu' mod li gu' con' ndac loo mèn co' ndxàc hues xtàa gu' xalque' ndlya's gu' cua'n mèna mod li mèna con' ndac loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Chele' gu' ante que' lezo' ñèe mèn co' nque' lezo' ñèe gu', ¿ché' ndyac gu' ngue li gu' con' ndac co'se' ngue li gu' tataa, cà'? Yende xàa. Tac chol mèn co' nac ante mèn ye'rsin', ne, ante nque' lezo' ñèe xtàa mèna, mèn co' ndli con' ndac loo mèn ye'rsin'a. Chele' gu' tataa ndli, le' sya, lalque' nac gu' con mèna no lalque' ngue li gu' xal ndli chol mèn ye'rsin', cara. ");
INSERT INTO zamNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","No chele' gu' ante li con' ndac loo mèn co' ndli con' ndac loo gu', ¿ché' ndyac gu' ngue li gu' con' ndac co'se' ngue li gu' tataa, cà'? Yende xàa. Lomisque' ne, chol mèn co' nac mèn ye'rsin' ndli con'a con xtàa mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Chele' gu' ntechè con' loo mèn ante por cón che'n interes co' ta' mèn càa gu' par li gu' gan por mtechè gu' con' loo mèn, ¿ché' ndyac gu' no ché' ngue li gu' cuent ngue li gu' con' ndac loo mèn co'se' ngue li gu' tataa, cà'? Yende xàa. Lomisque' mod ne, mèn ye'rsin' ntechè con' loo xtàa mèna ante por interes co' càa mèna yiloa no maste. ");
INSERT INTO zamNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Per ndxe'leque', gu' ndxàal que' lezo' ñèe gu' mèn co' nac ngolo ngola's che'n gu' no li gu' con' ndac loo chol mèn. No ftechè gu' con' loo mèn co'se' nquin mèn con'. No ne'cue queede lezo' gu' techè gu' con' por interes co' ta' mèn ndxep con' càa gu' por cón che'n con' co' mtechè gu' loo mèn. Chele' gu' tataa li, sya, Diox tolo li anggàc más con' ndac loo gu'. Sya, non mèn no ñee mèn le' gu', lìcque', nac xin'pe' Diox co' ñibe' loo alux con'. Tac Diox, ne, ndlique' huax con' ndac loo mèn co' indxàpte mod par gab mèn Diox quix U', Diox, loo Diox, no loo mèn co' nac mèn ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gòc gu' mèn co' ndlyat lezo' ñèe hues xtàa mèn xalque' ndlyat lezo' xud gu' Diox ñèe xud gu' Diox chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ne'hui'de gu' no ne'ñaade gu' loo mèn par la's gu' loo mèn. Le' sya, tataa mod ne'tub rezte Diox cón che'n gu', ne, por mcua'n gu' xquin gu' tataa co'se' ndla's gu' loo mèn. Ne' ne' cua'n gu' mod quexù' gu' no que' fals gu' chol mèn. Le' sya, Diox ne'quexù'de gu' por mcua'n gu' xquin gu' no xtol gu' co'se' nquexù' gu' no nque' fals gu' mèn. Fteri'th ftecan' gu' chol con' ye'rsin' co' ndli xtàa gu' loo gu' par tataa mod ton' Diox xtol gu', ne. ");
INSERT INTO zamNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Fta' gu' con' ncàa mèn co' naquin con'. Le' sya, Diox, ne, ta' con' naquin gu'. No co'se' ta' Diox con' càa gu'a, Diox ta'i loo gu' xal co'se' nchìx mèn nzob, ndub ndub nzob loo xibè' no loo almud no xal co'se' ndi' mèn nzob le'n bols. No nzib mèn bols par tolo lyàa loo nzob le'n bols. Leque moda, ta' Diox con' càa gu' xalque' mda' gu' con' ncàa mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ngoloa, mtetac Jesús thìb di's loo myen' xin' mté'th Jesús. Ndxab Jesús: ―Nde niin thìb con' loo gu': ¿Ché' nzo mod tyen thìb mbi' co' nac mbi' sieu ya' tedib mbi' co' nac mbi' sieu par tyoo ner mbi' sieua loo xtàa sieu mbi', cà'? ¿Ché' ngobe' gu' ne'yizi'fte no ne'yiga'ste ryop mèna le'n thìb ye'r, cà'? Tazi'fque' ryop mbi' sieua le'n ye'r, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nec thìb myen' co' nac xin' mté'th thìb maistr ne'ta'de myen'a con xtùuz co' ndli maistr no xtùuz co' ndli myen'. Per co'se' axta yilo li myen' stud, syare' gàc myen' xal maistr myen'. ");
INSERT INTO zamNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nde niin tedib con' loo gu', ne: ¿Xá mod más ngüi' gu' loo thìb le' chu'th yix co' nzo ngudloo hues xtàa gu' leque hui' gu' loo thìb le' yaa vig co' nac más naroo co' nzo ngudloope' gu', co' nee di's, ale más ngüi' gu' loo ndxep con' ye'rsin' co' ndli hues xtàa gu' no ingüi'de gu' loo gu' loo huax con' ye'rsin' co' ndlipe' gu', à'? ");
INSERT INTO zamNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","No ¿xá mod ale ndli gu' ryes mbez gu' loo hues xtàa gu': Hues, led cuante; bla' go'en thìb le' yix chu'th co' nzo ngudlool ba', no inda'de gu' cuent cón che'n yaa vig co' nac más naroo co' nzo ngudloo gu' ba', à'? Aa que ndxác gu' ntembìi gu' ro gu' no ntembìi gu' xti's gu', ndee gu'. Ner blo' gu' yaa vig co' más naroo co' nzo ngudloo gu' ba'. Le' yiloa na, co' gu' yix co' nzo ngudloo hues xtàa gu' ba'. ");
INSERT INTO zamNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Nde niin tedib con' loo gu', ne: Yende thìb yaa xlè ndac co' ta' thìb xlè ye'rsin'. Ne' ne' yen thìb yaa xlè ye'rsin' co' ta' xlè ndac. ");
INSERT INTO zamNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tac thìb thìb yaa xlè ndxàc be' por xlè co' nda' yaa xlè. Yende mod làa mèn ngudyuug loo thìb yaa yis, ¿lé'? Ne' ne' làa mèn uv loo yaa yis sars, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lomisque' ne, thìb mbi' ndac ndlique' con' ndac tac mbi' ndxòoque' lezo' li con' ndac co' ndye'th xtùuz yéc mbi' li mbi'. Per mbi' co' nac mbi' ye'rsin' ndli con' ye'rsin' tac mbi' ye'rsin' ndxòoque' lezo' li con' ye'rsin' co' ndye'th xtùuz yéc mbi' li mbi'. Tac ryete di's co' ndyoodi's mèn, que naca di's ndac, que naca di's zab, di'sa nac co' ndli mèn xtùuz no di'sa nac co' más nda' gust lezo' mèn par ndyoodi's mèn di'sa. ");
INSERT INTO zamNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Chonon co'se' mbez gu' daa, mbez gu', Tad, loon no indlide gu' cas di's co' ñibe'en loo gu', à'? ");
INSERT INTO zamNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nde niin loo gu': ¿Chó mèn nac xal nac mèn co', lìcque', nqueltàa loon no ndxòn mèn di's co' mbezen no ndli mèn con' co' ñibe'en? ");
INSERT INTO zamNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Pues mèna nac xal thìb mbi' co' mxít te'f thìb liz ro thìb yó'be'. Nerleque' con' mbli mbi', na's mden' mbi' cimient par tub mbi' liz mbi'. Co'te' mden' mbi' cimient ngòc antub loo quèe. No ngolo mxít te'f mbi' liz mbi', ngulàa thìb nít yòo yó'be'a. Ngozi'f nít yòoa cho liz mbi' con dib fuerz che'n nít. Per yende cón mxac liz mbi' tac ndub liz mbi' loo cimient co' nac antub loo quèe. ");
INSERT INTO zamNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Per mèn co' nzi yòn di's co' ngue bezen no indlide mèna cas loo di's co' ngue bezen, mèna nac xal thìb mbi' co' mxít te'f thìb liz mbi' ro thìb yó'be'. No sangmblít te'f mbi' ftoo liz mbi' loo yòo. Ne'ngen'te mbi' cimient co'te' mdub mbi' liz mbi'. Co'se' ngro' nít yòo no nguáp nít yòo yó'be'a, ngozi'f nít yòoa liz mbi'. Ale mtexyath nít yòoa liz mbi'. Por derech, mblyux liz mbi' thidtene tac antub loo yòo mdub mbi' liz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Co'se' ngolo mdoodi's Jesús loo mèn co' mqueltàa loo Jesús, mxen Jesús ned. Nda Jesús par ciuda Capernaum. ");
INSERT INTO zamNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Le'n ciuda Capernaum ngo thìb mbi' co' ngòc capitán. Mbi'a ngòc mèn gulàaz che'n mèn ciuda Rom. Mque no mbi' thìb moz. No nde nxon', anze'f nque' lezo' mbi' gunèe mbi' moz mbi'. Mxac len moz axta yamerle' mtin liz moz. ");
INSERT INTO zamNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Co'se' ndxòn capitán le' Jesús nteyac mèn yíiz, mtel' capitán plá mèngool co' nac mèn nación Israel loo Jesús par ya na'b mèna di's loo Jesús par ya teyac Jesús moz capitán. ");
INSERT INTO zamNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mèngoola mbii gax loo Jesús. Mtlo mèngoola, nalyat mbez mèngoola loo Jesús. Ndxab mèngoola: ―Tad, ndxàalque' li U' favor ya lyath no U' capitán. ");
INSERT INTO zamNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tac capitana anze'f nque' lezo' ñèe capitán mèn nación na'. No mnibe' capitán mxít te'f mèn thìb sinagog nu' cón che'n capitán. ");
INSERT INTO zamNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Sya, mxen Jesús ned. Nda no Jesús mèngoola. Co'se' nda zin' gaxle' Jesús con mèngoola liz capitán, capitán mtel' plá amiu capitán par ya sál' amiua Jesús. Ndxab mèn co' ndxàc amiu capitana loo Jesús: ―Tad, indlya'ste capitán li xol capitán U' tac nden' capitán inzyál'te capitán yòo U' liz capitán. ");
INSERT INTO zamNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Cona, ne'nglide capitán ryes ngui'th yub capitán loo U' par ngui'th cua'n yub capitán U'. Cona, mtel' capitán nu', nde nu'. No gunee capitán di's loo nu' co' ta' nu' cuent loo U'. Taandxè' gunee capitán: Tad Jesús, daa ngue na'b loo U', bli U' favor, ante ñibe' U' le' moz daa yac. Ndxelazquen yac moz daa. ");
INSERT INTO zamNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tac leque yub daa nzo xan' yalñibe' co' nac yalñibe' roo no ngue non solndad co' ñibe'en loo. Chele' daa gab loo thìb solndad par ya solndad thìb mandad, solndad ya. No chele' daa gab loo tedib solndad par yi'th solndad loon, solndad yi'th loon. No chele' daa ñibe' loo moz daa par li moz daa thìb zin', moz ya lii. ");
INSERT INTO zamNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Co'se' mbìn Jesús di's co' ndxab mèna, ante mbui' Jesús no ante gunaa Jesús cón che'n capitana. Mbui' Jesús loo mèn co' nziri' co' nda nque xís Jesús. Ndxab Jesús loo mèna: ―Lìcpe' ba'i, ne' ne' làth rye mèn nación Israel iñèeden nec thìb mèn co' anze'f ndxela's no co' ndxàp yalxla's loo Diox xal capitán ba'. ");
INSERT INTO zamNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Co'se' mbere mèn co' ngòc amiu capitán co' ngua sál' Jesús con mèngoola, ndye'th mèna con mèngoola par liz capitana, ale ñee mèna mbyacle' moz capitán tac Jesús mteyac moza axta co'te' ndoo Jesús ned nda Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ngolo ngòc con'a loo moz capitana, tedib huiz co' nde nquea, mxen Jesús ned. Nda Jesús par tedib yèez, yèez co' ngro' lèe Naín. Nda no Jesús ryete myen' xin' mté'th Jesús. No nda nque rye mèn co' mqueltàa loo Jesús xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Co'se' nda zin gax Jesús ro yèez Naín, ñèe Jesús ne' mèn thìb thebol. Nda ca's mèn thebola panteón. Thebola ngòc angoluxte mbyòo loo guna' co' nac xna' thebol. Ngòc guna' co' nac xna' thebola thìb viud, ne. Anze'f thìb mèn yèeza mqueltàa con xna' thebol par nda ca's mèna thebol. ");
INSERT INTO zamNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Co'se' gunèe Tad Jesús guna'a, mblyat lezo' Tad Jesús gunèe Tad Jesús guna'. Ndxab Tad Jesús loo guna': ―Ne'gón'tel, ey. ");
INSERT INTO zamNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sya, mbii gax Jesús. Mbuàal Jesús caj che'n thebol. Le' mèn co' ne' thebol na, ngo too. Nguled mèna cuante. Ndxab Jesús loo thebola: ―Mbyòo, na ngue nii lool: Goo che. ");
INSERT INTO zamNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Le' sya, mbyòo co' ngutha, chàa, ngro xban mbyòo no ngo che mbyòo. No mdub mbyòo. Mtlo mbyòo, mdoodi's mbyòo. Sya, mdix mèna caj loo yòo. Le' Jesús na, mxen ya' mbyòo. Mxít too Jesús mbyòo. Ndxab Jesús loo xna' mbyòo: Xgan'l ndxè', ey. ");
INSERT INTO zamNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Co'se' gunèe mèn ngolo ngòc con'a, ryete mèna mzyeb. Mtlo mèna, ndxab mèn di's natú' no di's roo di's xèn loo Diox. No mbez mèna: ―¡Ay, Dio's! Thìb mbi' roo no thìb mbi' xèn nac mbi' co' nde làth na' co' nde'th di's co' ndxab Diox loo na'. Mbez mèna, ne: ―Yub Diox nde lyath no na', na' co' nac mèn nacionpe' Diox, cara. ");
INSERT INTO zamNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","No mbyath mbyèn cón che'n con' mbli Jesús loo mbyòoa loo ryete mèn yèezya', co' nee di's, co' nac rye yèezya' co' nac che'n làaz mèn jude no taamas yèez co' nziri' gaxte loo yèezya' che'n làaz mèn jude. ");
INSERT INTO zamNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juàn Bautist mbìn con' co' mbli Jesús tac myen' co' ngòc myen' xin' mté'th Juàn Bautist mda' cuent cón che'n con' co' nde tee ndli Jesús loo mèn loo Juàn. Sya, mtel' Juàn mèn co' ngua mandad par ngua xi mèna chop myen' xin' mté'th Juàn par tyoodi's no Juàn myen' ro lezi'f co'te' nzo Juàn. ");
INSERT INTO zamNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Mtel' Juàn ryop myen'a loo Jesús par ñibdi's myen' loo Jesús ñeene' ché', lìcque', nac Jesús Crist co' ndxath no co' mxyo'f di's yi'th o ché' ndxàal cued mèn yi'th tedib mbi' co' nacpe' Crist. ");
INSERT INTO zamNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sya, ngua ryop myen' co' mtel' Juàna loo Jesús. Ndxab myen' loo Jesús: ―Juàn Bautist mtel' nu' par ñibdi's nu' loo U' ñeene' ¿ché' U' nac Crist co' ndxath yi'th o ché' ndxàal cued nu' yi'th tedib mbi' co' nacpe' Crist, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Le'xque' hor co'se' mzin myen'a loo Jesús, Jesús ngue teyac huax mèn yíiz co' mque no chol yilíiz ye'rsin'. No ngue go' Jesús xpii meexù' loo mèn. No mdub Jesús xnìi ngudloo huax mèn sieu. ");
INSERT INTO zamNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesús ndxab loo myen': ―Byàa gu'. No fta' gu' cuent loo Juàn ro lezi'f con' co' ngolo gunèe gu' no con' co' ngolo mbìn gu'. Fta' gu' cuent xá mod mduben xnìi ngudloo mèn sieu no ngüi' mèn sieua; xá mod mtoxcuan nii mèn coj par nalì ndyee mèn coj; xá mod mteyaquen mèn co' ndxa's no ndxèe yid lad; xá mod ndxòn mèn di's, mèn co' mcue' nza; xá mod ngo xbanen mèn nguth. Le' loo mèn prob na, ndethen no ngon yalbàn cón che'n di's ndac che'n Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Huen nda mèn co' ne'ten'te gàc ngòc nguàal con' loo mèn por cón chenen no maste. ");
INSERT INTO zamNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Co'se' ngolo ndyàa mèn co' mtel' Juàn Bautist loo Jesús, Jesús mtlo mdoodi's loo taamas mèn cón che'n Juàn. Ndxab Jesús loo mèn: ―Co'se' ngua tee hui' gu' co'te' nagána, ¿cón ngua tee hui' gu' co'te' nagána, à'? ¿Ché' ngua tee hui' gu' thìb xan' yíi co' ngol' mbii, cà'? Tyè', ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Cón ngua tee hui' gu', sya? ¿Ché' ngua tee hui' gu' thìb mbi' co' noc xab thìb ned lar' huen, cà'? Tyè', ¿lé'? Gu' nonque' no naneeque' gu' le' mèn co' ndxoc thìb ned lar' huen no mèn co' ante nda' gust lezo', mèna más ñèe mèn co'te' nac liz thìb rey, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Xá nee gu'? ¿Cón ngua tee hui' gu', sya? ¿Ché' ngua tee hui' gu' thìb mbi' co' nde'th di's co' ndxab Diox, cà'? Aa. Lìcpe' ba'i, gu' ngua tee hui'que' thìb mbi' co' nde'th di's co' ndxab Diox. No ngua tee hui'que' gu' thìb mbi' co' nac más mbi' roo no mbi' xèn leque chol mèn co' mde'th di's co' ndxab Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Cón che'n Juàn co' ngua tee hui' gu'a nac di's co' ndub loo libr co' nac xti's Diox co' mbez: Na tel' ner thìb mbi' co' ya te'th ner di's ndac ndxè'. No lu' mbi' cón che'n lùu loo mèn par li nab mèn xtùuz mèn no lezo' mèn loo cón che'n lùu ndoore'. No gàc con'a loo mèn xal co'se' ntoxcua' mèn thìb ned no ndli lal mèn thìb ned. ");
INSERT INTO zamNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na ngue nii loo gu' nalle': Yende chó mèn co' nde teele' ndxáal xàn' nii xna' mèn no xàn' nii xud mèn tarte gáal thìb mbi' co' nac más mbi' roo no mbi' xèn co' nde'th di's co' ndxab Diox leque Juàn Bautist. Mastale', axta nalle' par delant mèn co' nac más be'the co' ngue ta' lugar par ñibe'pe' Diox loo mèn, más huen nda mèna loo Diox leque Juàn Bautist tac Diox co xo'f más con' co' nac cón che'n Diox loo mèna leque con' co' mblo xo'f Diox co' nac cón che'n Diox loo Juàn. ");
INSERT INTO zamNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Co'se' mbìn mèn di's co' ndxab Jesús cón che'n Juàn, ryete mèn co' mbli Juàn bautizar no mèn co' ndli cobrar cón che'n contribución co' mbli Juàn bautizara, axta syare' mblila's mèna no mda' mèna cuent le' Diox nac Diox nalì loo ryethe con' co' ndli Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Per mèn co' ngòc mèn xley' farise no mèn co' ngòc maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn nación Israel tiempa, mèna ne'ndalte ngli Juàn bautizar mèna. Mèna mtè'b di's no mxìis no mèna con' co' mblya's Diox angli Diox loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tad Jesús ndxab loo mèna: ―¿Xá nee gu'? ¿Chó con' tetaquen mèn co' nziri' tiemp ndxè', à'? ¿Chó con' nac lalque' xal mèn ndxè', à'? ");
INSERT INTO zamNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nde niin thìb con' loo gu': Mèn co' nziri' tiemp ndxè' lalque' nac xal myen' bix co' nguith loo xbi' co'se' mbez yèe myen', no ndxón' myen', no ndxecloo myen' loo xtàa myen'. Mbez myen' loo xtàa myen': Daa mque dii loo flaut no ale ne'ngol' niide gu'. Lomisque', mbil' ro bàanen loo gu' no ne'ngxide lezo' gu' par ngón' gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tataa nac gu' tac co'se' mbi'th que tee Juàn Bautist làth gu', Juàn ne'nghuade pan axta plóthe xal ndxuhua chol mèn pan axta plóthe. No ne' ne' ngu Juàn vin axta plóthe xal ndxu chol mèn vin axta plóthe. Mbez gu' loo xtàa gu' cón che'n Juàn le' Juàn mque no xpii che'n meexù'. ");
INSERT INTO zamNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ngoloa, ndalen, daa co' mbal yáal làth gu' xal ndxáal chol mèn. Na ndxuhua. No ndxun. Per ale mbez gu' le' daa ndxuhuacho' pan no ndxucho'en vin. No ale mbez gu' ndxàc amiu daa mèn co' ndli cobrar cón che'n contribución no mqueltàan con mèn co' ndxàp xquin no xtol. ");
INSERT INTO zamNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Per yende chó mport nzo lezon cón che'n con' co' ndli gu' xtùuz cón che'n Juàn no cón chenen tac mèn co', lìcque', ndxác, mèna nonque' no naneeque' mèna le' con' co' ngue li Diox por cón che'n Juàn no por cón chenen nac con' ndac. ");
INSERT INTO zamNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ngolo gunii Jesús di'sa, thìb mbi' co' ngòc mèn xley' farise co' ngua nee loo Jesús ya thuhua Jesús sa yèth liz mbi' con mbi', mbe' mbi' Jesús liz mbi'. No mdub no mbi' Jesús loo mes. ");
INSERT INTO zamNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Látha, mzin thìb xa'got ye'rsin' co' ngòp xtol co' nzo ban leque le'n yèeza. Co'se' mbìn xa'gota le' Jesús nda liz mbi' xley' farise par hua no Jesús mbi', ale negadi's ngòo xa'gota liz mbi' con thìb bote aceit perfum co' natoxcua' con quèe marm loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ndxón' xa'gota. Mbii gax xa'gota loo Jesús co'te' mdub Jesús loo mes. Mtlo xa'gota, mtech xa'gota nii Jesús con nít loo xa'gota co' ndxón' xa'gota. Ngoloa, mtecui's xa'gota nii Jesús con yis yéc xa'gota. Sya, msero xa'gota nii Jesús. Ngoloa, mtàa xa'gota aceit perfum co' anze'f nazi' ndlya' nii Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Co'se' ñèe mbi' xley' farise co' ngua nee loo Jesús ya thuhua Jesús liz mbi' con'a, mbli mbi' xtùuz. Ndxab mbi' loo lezo' mbi': Chele' mbi' ndxè', lìcque', nac thìb mbi' co' nde'th di's co' ndxab Diox, ngnon mbi' no ngda' mbi' cuent chó nac xa'gota no chó loo xa'got nac xa'got co' ngue gàal mbi'. Pues daa nanee le' xa'got ba' nac thìb xa'got ye'rsin' co' ndxàp xtol. ");
INSERT INTO zamNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sya, ndxab Jesús loo mbi' xley' farise: ―Mon, ndlyazen niin thìb con' lool, cara. Mbi' mcàb loo Jesús. Ndxab mbi': ―Gunee U'i loon, Maistr. ");
INSERT INTO zamNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús ndxab loo mbi': ―Ngo chop mbi' co' ngro' te'f loo thìb mbi' co' ntechè tmi loo mèn. Thìb mbi' ngro' te'f casque' thìb mil pes. Le' tedib mbi' na, ngro' te'f casque' thìb ayo pes loo mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ryop mbi'a ne'ngácte nguix tmi loo mbi' co' ntechè tmi loo mèn. Mblyat lezo' mbi' gunèe mbi' ryop mbi' co' ngro' te'f tmia. Mton' mbi' yalgute'f co' ngro' te'f ryop mbi'a. Per nalle' lyazen ñeel loon, Mon, de loo ryop mbi' co' ngro' te'fa, ¿chó mbi'a más mque' lezo' mbi' co' mton' yalgute'f che'n ryop mbi'a, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mon mcàb loo Jesús. Ndxab Mon: ―Ndyaquen le' mbi' co' mtechè tmia más ngulat lezo' gunèe mbi' co' más ngro' te'fa leque tedib mbi'. Jesús ndxab loo Mon: ―Lìcque' con' neel ba'. Yende cón niin lool. ");
INSERT INTO zamNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Látha, xèe ngüi' Jesús loo xa'gota. Ndxab Jesús loo Mon: ―¿Ché' ngue hui'l con' ngue li no xa'got ndxè' daa, à'? Anon ngòon lizl, ne'nda'del nít loon par ntechen niin. Per ndxe'leque', xa'got ndxè' mtech niin con nít loo xa' co' ndxón' xa'. No mtecui's xa'got ndxè' niin con yis yéc xa'. ");
INSERT INTO zamNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ne'nserodel cuaten. Per xa'got ndxè' anon ngòo xa', thidteneque' ngue sero xa' niin. ");
INSERT INTO zamNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ne'ntàdel aceit yéquen xal nac mod co' ndli mèn. Per xa'got ndxè' mtegad aceit perfum co' anze'f nazi' ndlya' niin. ");
INSERT INTO zamNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Por cón che'n con' co' ngue li xa'got ndxè' loon, anze'f ndlu' xa'got ndxè' nque' lezo' xa'got ndxè' ñèe xa'got ndxè' daa. Por con' co' ngue li no xa'got ndxè' daa, ngue lu' xa'got ndxè' le' xa' non le' Diox mton'le' ryethe xquin xa' no xtol xa' co' ngòp xa'. Lomisque', ngue niin lool, Mon, le' mèn co' nden' le'n lezo' mèna indxàpte mèna xquin mèna no xtol mèna, no nden' mèna inquinte mèna le' Diox ton' xtol mèna, mèna indlu'de nque' lezo' mèna ñèe mèna xtàa mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Le' sya, ndxab Jesús loo xa'gota: ―Ngot, mton'len xtol lùu, ndee. ");
INSERT INTO zamNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Le' mèn co' ndxab Mon ya thuhua mèn sa lua' liz Mon na, mèna nzi ndub no Jesús loo mes, ne. Mtlo mèna, mbez mèna loo xtàa mèna: ―¿Xá nee gu'? ¿Chó mbi' ndli mbi' ba' cuent nac mbi' tac ale mbez mbi' axta xtol mèn no xquin mèn nton' mbi'? ");
INSERT INTO zamNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Per Jesús ndxab loo xa'gota: ―Lùu mblyá'le' loo ryethe con' ryes tac ngola'sque'l loon. Nabe'ste byàa. Daa mblile' le' lùu nagàl yo lezo' loo cón che'n Diox, ndee. ");
INSERT INTO zamNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ngolo ngòc plá huiz ngua thuhua Jesús liz Mon, Jesús ngua que tee huax yèez no huax ranch. Mque tee go Jesús yalbàn cón che'n di's ndac co' ndlu' xá mod ndlya's Diox ñibe'pe' Diox loo mèn. Mque tee noque' Jesús ryete si' fchop myen' xin' mté'th Jesús, ne, myen' co' ne' tedib lèe mèn co' ndxe' di's che'n Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Mque tee no ndxep xa'got Jesús, ne, xa'got co' mteyac Jesús, no taamas xa'got co' mblo' Jesús xpii che'n meexù' loo. Làth rye xa'gota, mque tee Mari co' ne' ryop lèe Mari che'n mèn yèez Madalen. Loo Maria mblo' Jesús gaz xpii meexù' ndoore'. ");
INSERT INTO zamNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Làth xa'gota mque tee Juan, sa'l Chus co' ngòc mandador che'n rey Herod tiempa, ne. Ngo thìb xa'got co' ngro' lèe Susan làth xa'gota, ne. No ngo taamas mèngot co' mblyath no Jesús con con' co' mque note xa'gota. ");
INSERT INTO zamNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","No anze'f thìb mèn mqueltàa ned nda Jesús par hui' mèna loo Jesús. Co'se' gunèe Jesús mqueltàa huax mèn loo Jesús, Jesús mcua'n mod mtetac Jesús di's loo mèna. Ndxab Jesús loo mèna: ―Nde niin thìb con' loo gu', ey: ");
INSERT INTO zamNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Thìb vez ngro' thìb mbi' co' ngo biz bin par co mbi' bin. Per co'se' mtlo mbi', mblo mbi' biz bin, mblo mbi' ndxep biz bin gaxte ro ned. Per mèn co' mbri'th par neda, mèna mblo mdub loo bina. Làth xtau'a, mbi'th mbin bé'. Nduhua mbin biz bina. ");
INSERT INTO zamNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Le' tedib lugar na, mblo mbi' biz bin loo yòo quèe. Per texal ngulen bina, ale sangmbiiz biz bina tac yende xcop loo yòo quèea. ");
INSERT INTO zamNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Le' taandxep biz bin co' mblo mbi'a na, ngulàa le'n huan. Per más mbryoo mxyèn huan leque bina. Ale mblyus bina le'n huan. ");
INSERT INTO zamNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Per taandxep biz bin co' mblo mbi'a ngulàa loo yòo be'f. Co'se' ngolo mbryoo mxyèn bina, mda' bina thìb cosech ndac axta plóthe ale axta thìb ayo nzob mda' thìb thìb quèe biz bina. Ngolo ndxab Jesús di'sa loo mèn, cabii ndxab Jesús loo mèn co' nziri'a: ―Chele' gu' nden' co' nee di's co' ngue niin loo gu' ndxè', fta' gu' lugar yaa'd di's ndxè' le'n lezo' gu'. No gola's gu' di's ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Myen' xin' mté'th Jesús mnibdi's loo Jesús. Ndxab myen': ―¿Cón nee di's di's co' mtetac U' loo mèna, à', Tad? ");
INSERT INTO zamNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús ndxab loo myen': ―Por part cón che'n gu', leque Diox li loo gu' par ta' gu' cuent no ten' gu' cón che'n xá mod ndlya's Diox ñibe'pe' Diox loo mèn. Le'i be' nzo casloo loo alux mèn loo izlyo'. Loo taamas mèn daa ndyoodizque' con di's co' ntetaquen loo mèn. Le' sya, co'se' ndxòn mèn di's co' ngue tetaquen, gàca loo mèn xal loo mèn co', por derech, indxú'de con' loo. No co'se' ndxòn mèn di'sa, gàca loo mèna ne'yaa'dte di'sa le'n lezo' mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Con' ndxè' nac co' nee di's di's co' mtetaquena: Biz bin co' mblo mbi'a nee di's nac di's ndac che'n Diox co' ngo mèn yalbàn. ");
INSERT INTO zamNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Le' biz bin co' ngulàa ro neda nee di's nac mèn co' ndxòn di's ndac che'n Diox. Per co'se' nde Mebizya, ngo' Mebizya di's co' mbìn mèna le'n lezo' mèna no le'n xtùuz mèna par ne'yila'ste mèna cón che'n di's ndac no par ne'lyá'de mèna loo con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Le' biz bin co' ngulàa loo yòo quèea na, nee di's nac mèn co' ndxòn di's ndac che'n Diox. No co'se' ndxòn mèn di'sa, axta gust nda' lezo' mèn ndxòn mèn di's ndaca. Per nac mèna xal thìb xan' ña' co' yende huax lox. Ndxela's mèn cón che'n di's ndac ndxepte tiemp. No co'se' ndli xtàa mèna ngòc nguàal con' loo mèna, ndryo xà' lezo' mèna loo con' co' nac di's ndac che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Le' biz bin co' ngulàa le'n huana na, nee di's nac mèn co' ndxòn cón che'n di's ndac che'n Diox. Per mastale' ndxòn mèn cón che'n di's ndaca, toloque' nzi tee ban mèn xal nee lezo' mèn. Más ndli mèna ndxath ndxey' lezo' mèna loo yalgon' co' ndxàp mèna. No más ndxòo yéc mèna xá mod tolo ta' mèna gust lezo' mèna. Co'se' ndli mèna con'a, sya, ndxàc mèna xal biz bin co' mblyus le'n huan. Cona nee di's thidteneque' ne'nglide mèna cas cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Le' biz bin co' ngulàa loo yòo be'fa na, nee di's nac mèn co' ndxòn cón che'n di's ndac che'n Diox dib nzo yéc mèn no dib nzo lezo' mèn. Mdyubdi's mèna xal mbez di's ndac no toloque ndli nèe mèna mèna loo cón che'n di's ndac. ");
INSERT INTO zamNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Mtetac Jesús tedib di's loo mèn. Ndxab Jesús loo mèn: ―Nde niin tedib con' loo gu', ey: Yende chó mèn nzo co' ngo xnìi thìb lampr par tau' mèn loo xnìi con thìb bald o too mèn lampr xàn' thìb lun', ¿lé'? Ndxe'leque', mèna quetal lampr gáp par tenìi lampr loo mèn co' ndxòo no mèn co' ndryo' le'n nyòo. Lomisque' ne, tataa ndxàal gàc cón che'n di's ndac par yath yèna loo mèn par tyub xnìi yéc mèn no par tyub xnìi lezo' mèn loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yende nec thìb con' co' nacasloo loo mèn co' ne'ryo xo'fte. No yende nec thìb con' co' xexte ndli mèn co' ne'yathte no co' ne'yú'de loo xnaa. ");
INSERT INTO zamNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Cona, ngue niin loo gu': Fta' gu' lugar yaa'd di's co' ngue niin loo gu' ndxè' le'n lezo' gu'. Tac mèn co' ndxòn ndac cón che'n di's ndac che'n Diox, mèna más tolo gòn ndac cón che'n di's yiloa. Per ndxe'leque', mèn co' indyalte par tolo gòn mèna cón che'n di's ndac che'n Diox, Diox tau' yéc mèna no tau' Diox lezo' mèna par gàca loo mèna, por derech, yathla's mèna cón che'n di's ndac co' mbìn mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Látha, mzin xna' Jesús no myen' huespe' Jesús co'te' nzo Jesús. Per yende mod bii gax xna' Jesús no myen' huespe' Jesús loo Jesús tant thìb mèn nziri'. ");
INSERT INTO zamNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Sya, mbli mèna avis loo Jesús. Ndxab mèn: ―Tad, xna' U' no myen' huespe' U' nzi par xís mèn ba'. Ndlya's myen' tyoodi's no myen' U'. ");
INSERT INTO zamNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mcàb Jesús loo mèna. Ndxab Jesús: ―Mèn co' ndxaa'd di's co' nac di's ndac che'n Diox no nté'th mèn xal ndlu' di'sa, mèna nac xal xnan no nac mèna xal huespe'en. ");
INSERT INTO zamNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ngòc thìb con' le'n huiza. Thìb huiz Jesús ngòo le'n thìb yòoyaa con myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Nda na' tedib lad ro lagun ba'. Mtetee myen' yòoyaa loo nít. Nda no myen' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Per láth nda tetee myen' yòoyaa loo lagun, Jesús mxen mcal'. Ale mdàt Jesús. Leque hora ngro' thìb mbiidó' loo lagun. Mtlo mbii, mxít too mbii nít loo lagun. No ngòo mbii nít le'n yòoyaa. Ale mzyè nít le'n yòoyaa. Casque' ryes ngòc ngue dep yòoyaa le'n nít. ");
INSERT INTO zamNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sya, ¡yende myen' izlyo'!, ngua lo' myen' mcal' loo Jesús. Ndxab myen' loo Jesús: ―Tad, blo' U' mcal' loo U'. Yòoyaa na' ngue dep le'n nít, yey. Sya, ngo che Jesús. Gunii Jesús loo mbii no gunii Jesús loo nít co' ndxetoo loo lagun. Texal gunii Jesús di'sa, xèe ngure mbii no xèe ngure nít. ");
INSERT INTO zamNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sya, ndxab Jesús loo myen' xin' mté'th Jesús: ―¿Máa yalxla's co' ndxàp gu' loo Diox no loon, à', ey? Per myen', ale ndxe'leque', mzyeb tín'. No ale ante mbui' myen' no ante gunaa myen' loo Jesús. No mnibdi's myen' loo thìb xtàa myen' no loo tedib xtàa myen'. Mbez myen': ―¿Chó mbi' nac mbi' ba', yey? Ale ante mnibe' mbi' loo mbii no loo nít, xèe ngure mbii no xèe ngure nít co' ndxetoo ba'. ");
INSERT INTO zamNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ngoloa, mzin Jesús con myen' xin' mté'th Jesús le'n yèezya' co' nac che'n làaz mèn gadar. Yèezya'a nziri' tedib lad ro laguna. Nziri' yèezya'a loo xnaaleque' loo xyòn che'n làaz mèn galile, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Texal mbilàa Jesús con myen' loo yòoyaa, mbii gax thìb mbi' yèez Gadar loo Jesús. Ndxàcle' tiemp ngue no mbi' thìb mbii co' nzib ndlau mbi'. Mbiia ngòc thìb baan xpii meexù' co' ngòo loo mbi'. Co'se' nquée mbii mbi'a, che mbi' nque tee mbi'. Ne' ne' indoo lezo' mbi' yo ban mbi' liz mbi'. Ndxe'leque', co'se' nquée mbii mbi', ndxòo mbi' le'n panteón. No ale ndxàt mbi' le'n armit co'te' nac panteón. Tac huax vez nquée mbii che'n xpii meexù'a loo mbi'. Cona, ntedó' mèn ya' mbi' no nii mbi' con caden par ne'ryo'de mbi', ya mbi' pál. Per co'se' nquée mbii che'n xpii meexù'a mbi', ale ncho' mbi' caden con fuerz co' ndxàp mbi' co' ndli xpii meexù' loo mbi'. No ndli xpii meexù' nque' mbi' carre par nda mbi' co'te' nagán. ");
INSERT INTO zamNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Co'se' gunèe mbi' Jesús, xpii meexù'a mbli mdub xib mbi' loo Jesús. No mbli xpii meexù' ngrozèe yii no ngrozèe den mbi'. Ndxab mbi' loo Jesús: ―¿Chonon ngue go U' xí U' loo cuent cón chenen, Jesús, xgan' Diox, co' ñibe' loo ryethe con', à'? Ña'ben loo U', ne'tetìide U' arid daa, Tad. ");
INSERT INTO zamNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Xpii meexù' mbli tataa ndxab mbi' loo Jesús tac Jesús ngue ñibe' loo xpii meexù' par ryo xpi meexù' loo mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús mnibdi's loo mbi'. Ndxab Jesús: ―¿Chó lèel, à'? Per xpii meexù' co' nzo loo mbi' mbli par ndxab mbi': ―Daa lèe Legión. Tataa mod ndxab mbi' loo Jesús tac thìb baan ngòc xpii meexù' co' ngòo loo mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Sya, thidte ngòc rye xpii meexù'a. Mna'b xpii meexù'a loo Jesús par ne'cobiide Jesús xpii meexù' le'n ye'rbiil. ");
INSERT INTO zamNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Gaxte tya nzi tee yuhua thìb partid nguch cho thìb yii. Rye xpii meexù'a mna'b loo Jesús la' Jesús yòo xpii meexù'a loo nguch. Jesús mda' lugar loo xpii meexù' par ngòo xpii meexù'a loo nguch. ");
INSERT INTO zamNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Le' sya, ngro' rye xpii meexù'a loo mbi'a. No ngòo rye xpii meexù'a loo partid nguch co' nzi tee yuhua cho yiia. Ale angnziri' nguch, mque' nguch carre. Ale mbyùub nguch, ngulàa nguch le'n lagun. Ryete nguch nguáp nít. Nguth rye nguch. ");
INSERT INTO zamNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Co'se' gunèe mèn co' ngue queno ngucha le' nguch mbyùub le'n lagun, mquée nít yéc nguch, nguáp nguch nít loo lagun, ante mzyeb mèna. Mque' mèna carre. Ngua ta' mèna cuent loo mèn yèez. No ngua ta' mèna cuenta loo mèn co' nzi tee par huan. ");
INSERT INTO zamNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ngro' mèn yèeza par ya tee hui' mèn con' co' ngòc loo nguch. Co'se' mzin mèn co'te' nzo Jesús, mzyal mèn mbi' co' ngòo xpii meexù' looa. Ngro'le' xpii meexù' loo mbi'. Mdub mbi' loo Jesús. Noc xable' mbi'. No ndxe'sleque' mbi' mdub mbi'. Ale ryete mèna mzyeb gunèe mèna mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mèn co' gunèe xá mod ngro xpii meexù' loo mbi', mèna mda' cuent loo rye mèn co' mbi'tha xá mod mblo' Jesús rye xpii meexù' loo mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Sya, rye mèn yèezya' che'n làaz mèn gadar mtlo mna'b loo Jesús más huen ryo' Jesús tya tac anze'f mzyeb mèna gunèe mèna con' mbli Jesús loo mbi' co' mque no xpii meexù'a. Sya, ngòo Jesús loo yòoyaa. Mbii Jesús tya. ");
INSERT INTO zamNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Le' mbi' co' ngro xpii meexù' looa na, nalyat mde'b ro mbi'. Mna'b mbi' loo Jesús ta' Jesús lugar loo mbi' par ya no mbi' Jesús. Per Jesús ne'ndalta. Mnibe' Jesús loo mbi' más huen yan' mbi'. No ndxab Jesús loo mbi': ");
INSERT INTO zamNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Aa'a. Bere byàa par lizl. No fta' cuent loo mèn ryethe con' mbli no Diox lùu. Pues mxen mbi' ned. Ndyàa mbi'. No mda' mbi' cuent loo chol mèn dib le'n yèezpe' mbi' cón che'n con' co' mbli Jesús loo mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Co'se' mbere Jesús, mzin Jesús tedib lad ro leque laguna, ryete mèn mdyac lezo' mzin Jesús tedib vez tac ryete mèna nzi bed ye'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Látha, mzin thìb mbi' co' ngro' lèe Jair co' ngòc jef che'n thìb sinagog loo Jesús. Texal mzin mbi' loo Jesús, mdub xib mbi' loo Jesús. Nalyat mde'b ro mbi', mna'b mbi' loo Jesús par ya Jesús liz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Tac mbi' ngue no thidte mza' co' nac rsap mbi'. No pente nzo mza' si' pchop lín' no maste. No nqueltàa nax tin liz mza'. No texal mxen Jesús ned, nda no Jesús mbi' par ned liz mbi', ndoo nque huax mènléy' xís Jesús axta ndí' mèna Jesús tant huax mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Làth rye mèna ngo thìb xa'got. Xa'gota ndxàcle' si' fchop lín' ndyac len thìb yíiz co' ngòc yíiz ndlyath ren. Ya mbryele' rye con' mque no prob xa'gota. Mtho' xa'gota ryethe con' co' mque no prob xa'gota par ngro' tmi mdix xa'gota loo doctor por remed co' mbli doctor xa'. Per ne' doctor no ne' mèn co' ndli remed crioll ne'nglide gan nteyac mèna xa'gota. ");
INSERT INTO zamNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Láth nda Jesús liz Jair con rye mèna, xex xex mbii gax xa'gota loo Jesús par ned xís Jesús. Tac mbli xa'gota xtùuz chele xa' ante gàal ro xab Jesús yac xa'. No tataaque' mbli xa'. Ante mbuàal xa' ro xab Jesús. Chàa, mbyau' loo yíiz ndlyath rena. ");
INSERT INTO zamNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sya, mnibdi's Jesús loo mèn co' nda no Jesús loo ned. Ndxab Jesús: ―¿Chó gu' mbuàal daa, à', ey? Ryete mèna mcàb. Ndxab mèna: ―Nec thìb nu' ne'ngàalte U'. Pedr mcàb. Ndxab Pedr con myen' xtàa Pedr loo Jesús: ―Maistr, ¿ché' iñeede U' mèn nzi chep U' rye lad no ndí' mèn U' rye lad? No mbez U': ¿Chó gu' mbuàal daa, à', ey? ");
INSERT INTO zamNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús ndxab loo Pedr: ―Nzoque' thìb mèn co' mbuàal daa, Pedr. Mèna mbuàal daa dib nzo yéc mèna no dib nzo lezo' mèna par mteyaquen mèna. Tac mden'en le'n lezon le' Diox mteyac thìb mèn por cón che'n con' roo no con' xèn co' nzo la's niin no co' nzo la's yan. ");
INSERT INTO zamNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Co'se' ñee xa'gota yende mod ga's xa'gota loo Jesús le' xa'gota nac xa' co' mbuàal ro xab Jesús par yac xa', ante mxi'th xa'. Mbii gax xa' loo Jesús. Mdub xib xa' loo Jesús. Mblo ro xa'gota loo Jesús loo ryete mèna con' mbli xa'gota no xá mod, chàa, mbyac xa'gota loo yíiz ndlyath ren. ");
INSERT INTO zamNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús ndxab loo xa'gota: ―Rsap, yíiz co' mque nol mteyaclen tac lùu ngola'sque' loon no loo cón chenen. Nabe'ste byàa, ndee. Diox mtu'le' no mtàlle' Diox ryethe con' ye'rsin' le'n lezo'l, ndee. ");
INSERT INTO zamNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Be' ngue toodi's no Jesús xa'gota, mzin thìb xa' guliz Jair co' ngòc jef che'n thìb sinagog. Ndxab xa'a loo Jair: ―Lá'a. Ya ne'tolode li xol Maistr. Rsapl ngolole' mtin liz. ");
INSERT INTO zamNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Co'se' mbìn Jesús di's co' ndxab mbi' guliz Jair loo Jair, Jesús ndxab loo Jair: ―Lá'a, Jair. Ne'zyebtel. Ante gola's loon. Rsapl ryo xban no yac rsapl. ");
INSERT INTO zamNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Co'se' mzin Jesús liz Jair, Jesús ne'ngla'de ngòo nec thìb mèn con Jesús le'n nyòo. Ante Pedr, no Cob, no Juàn, no xud mza', no xna' mza' ngòo le'n nyòo con Jesús co'te' nzo'f mza' loo mes. ");
INSERT INTO zamNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ryete mèn guliz co' nzo le'n nyòo co'te' nzo'f mza' loo mes, nzi yón' no nzi bez yèe yath por mza' co' nguth co' nzo'f loo mes. Per Jesús ndxab loo mèna: ―Ne'gón'te gu', ey. Part cón chenen, mza' ba' ne'ngathte thidtene. Loon nac mza' ba' xal thìb mza' co' nax yàt. ");
INSERT INTO zamNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Per co'se' mbìn mèna tataa ndxab Jesús, ale mxìis no mèna Jesús tac mèna nonque' no naneeque' mèna le' mza' nguthque'. ");
INSERT INTO zamNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sya, mxen Jesús ya' mza'. Cabii ndxab Jesús loo mza': ―Mza', goo che, ey. ");
INSERT INTO zamNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sya, ngro xban mza'. Leque hora, ngo che mza'. Jesús mnibe' loo xna' mza' no loo xud mza'. Ndxab Jesús: ―Fta' gu' con' hua mza', ey. ");
INSERT INTO zamNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Xud mza' no xna' mza' ante mbui' no ante gunaa loo con' co' mbli Jesús loo mza'. Ngoloa, mnibe' Jesús loo xud mza' no loo xna' mza'. Ndxab Jesús: ―Yende chó gabte gu' loo mèn cón che'n con' mblin loo mza' ba'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ngoloa, mbli Jesús par thidte mqueltàa ryete si' fchop myen' xin' mté'th Jesús loo Jesús. Mnibe' Jesús loo myen'. No mbli Jesús le' myen' ngòp con' roo con' xèn la's nii myen' no la's ya' myen' par tataa mod ya lo' myen' rye xpii che'n meexù' co' nzo loo mèn no par teyac myen' chol mèn yíiz co' ndyac len chol yíiz. ");
INSERT INTO zamNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mtel' Jesús myen' par ya que tee myen' huax yèezya' par te'th myen' no par co myen' yalbàn cón che'n di's ndac che'n Diox xá mod ndlya's Diox ñibe'pe' Diox loo mèn. No mtel' Jesús myen' par teyac myen' mèn yíiz. ");
INSERT INTO zamNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ndxab Jesús loo myen': ―Yende con' hue' gu' co'se' tyoo gu' ned. Ne'hue'de gu' yaagà gu'. Ne'hue'de gu' morral gu'. Ne'hue'de gu' lua' gu'. Ne'hue'de gu' tmi. Ne'hue'de gu' tedib ned xab gu' co' goc gu'. Ante co' nocte gu' ba' be' gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ndxab Jesús loo myen', ne: Chol liz mèn co'te' yòo gu' par cued gu' tya, cued gu' liz mèna axta zin huiz bii gu' le'n yèeza. ");
INSERT INTO zamNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","No chol yèez co'te' ne'tyalte mèn yòo gu' no cued gu' yèeza plá huiz, ryo' gu' yèeza no zib gu' yòoya's co' ndoo nii gu'. Le' sya, co'se' ngue zib gu' yòoya's co' ndoo nii gu'a o co' ndoo nii pantalón gu', con'a nee di's, yan' con' co' mbli mèn loo gu'a cón che'n Diox co'se' tyub rez cón che'n mèn dib athu loo izlyo' co'se' gàc huiz tub rez Diox cón che'n mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ngro' myen'. Mxen myen' ned, nda myen'. Ngua que tee myen' huax yèezya'. Mque tee go myen' yalbàn cón che'n di's ndac che'n Diox. No mque tee teyac myen' mèn yíiz rye ned mque tee myen'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Per mbi' co' lèe Herod co' ngòc gobernador tiempa mbìn cón che'n rye con' co' nde teele' mbli Jesús. Per ¡prob Herod izlyo'! Axta ne' ne' ñee Herod chó ro gòn Herod cón che'n Jesús. Tac ndxep mèn mbez peser Jesús nac Juàn Bautist co' ngro xban làth mèn nguth co' ngue tee li con'a. ");
INSERT INTO zamNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Le' taamas mèn na, mbez: Peser Lii co' mde'th di's co' ndxab Diox nac xa' co' ngro xo'f loo mèn. Taamas mèn mbez: Peser nzo chó mèngool co' mde'th di's co' ndxab Diox póla nac mèn co' ngro xban. ");
INSERT INTO zamNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Per Herod mbez loo mèn: ―¡Máa yob yéc gu', na! Con que yub daa mnibe' loo solndad par ngua teche solndad yéc Juàn con thìb spad le'n lezi'f. Per mbi'a, ¿chó mbi' nac mbi' co' nda' mèn cuent loon le' mbi'a anze'f thìb con' ngue tee li, sya? Mcàb mèna: ―Ne no. Ne'neede nu' chó mbi' nac mbi'a, cara. No anze'f mguen lezo' Herod, mblya's Herod ñèe Herod Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ndxàc plá huiz ngòc con'a, mbere myen' xin' mté'th Jesús co' ngua te'th di's cón che'n Jesús. Ndye'th myen' ned ngua myen'. Mda' myen' cuent loo Jesús con' mbli myen' ned ngua myen'. Ngolo mda' myen' cuenta loo Jesús, mbe' Jesús myen'. Nda no myen' Jesús thìb lad gaxte ro yèez co' lèe Betsaid. ");
INSERT INTO zamNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Co'se' mbìn mèn le' Jesús nda par neda, mdoo nque mèn xís Jesús. Mdyac lezo' Jesús ngure no mèna Jesús. Mdoodi's Jesús loo mèna cón che'n xá mod ndlya's Diox ñibe'pe' Diox loo mèn. No mteyacque' Jesús mèn yíiz. ");
INSERT INTO zamNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Co'se' nde zèle' izlyo' huiza, ryete si' fchop myen' xin' mté'th Jesús co' mtel' Jesús co' ndxe' di's che'n Jesús, mbii gax myen' loo Jesús. Ndxab myen' loo Jesús: ―Tad, co'se' yilo tyoodi's U' loo mèn ba', gunii U' Diox loo mèn par bii mèn, no par ya li mèn descans, no par ya cua'n mèn con' hua mèn le'n làth yèez ba', no ya cua'n mèn con' hua mèn liz mèn co'te' nac ranch gaxte. Tac co'te' nziri' na' ndxè' yende cón nac par hua mèn trè'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús ndxab loo myen': ―Fta' gu' con' par hua mèn ba'. Myen' mcàb. Ndxab myen' loo Jesús: ―Ingue node nu' huax pan. Pente ngue no nu' ga'y pan no chop mbèel. ¡Pà gàal co' ngue note nu' ndxè' par hua mèn ba'! Thuaque' mèn chele' nu' ya ti' pan par hua rye mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Per ne'que' ga'y mil ante mènbi' co' ngure tya. Xà' mengot no xà' myen' bix. Indxòode cuent mèngot no myen' bix co' nduhua. Jesús ndxab loo myen' xin' mté'th Jesús: ―Bnibe' gu' loo mèn par tyub mèn. No tyub thìb thìb tant mèn co' ne' cho' psi' cho' psi' mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tataa mnibe' myen' xin' mté'th Jesús loo mèn par tyub ryete mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sya, mxen Jesús ga'y pana no chop mbèela. Mbui' Jesús loo bé'. Ndxab Jesús loo Diox: ―¡Ay, Dio's! Diox quix U', Diox, por pan ndxè' no mbèel ndxè'. Sya, mchì'x Jesús pana no mbèela. Mda' Jesús pana no mbèela loo myen' xin' mté'th Jesús par li'th myen' pana no mbèela loo mèn co' nziri'a. ");
INSERT INTO zamNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nix nduhua ryete mèna axta plóthe. Mzyè lezo' mèna. Ngolo nduhua rye mèna axta plóthe, msè myen' xin' mté'th Jesús si' fchop cardor pan no mbèel co' mbyan' xo'f loo pan no mbèel co' mbyar'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Thìb vez co'se' ngue bez Jesús Diox thìb lad, no thidte ngure no myen' xin' mté'th Jesús con Jesús tya, ngolo ngurez Jesús Diox, mnibdi's Jesús loo myen' xin' mté'th Jesús. Ndxab Jesús: ―¿Ché' nzo cón ndxòn gu' chó mbez mèn nac daa, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Myen' mcàb. Ndxab myen' loo Jesús: ―Nu' ndxòn le' ndxep mèn mbez le' U' nac Juàn Bautist. Le' taandxep mèn na, mbez le' U' nac Lii. No nzore' taandxep mèn co' mbez le' U' nac xa'gool co' ngo póla, xa'gool co' mde'th di's co' ndxab Diox. Mbez mèn: Peser U' nac thìb xa'goola co' ngro xban. ");
INSERT INTO zamNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Sya, mnibdi's Jesús loo myen'. Ndxab Jesús: ―¿Gu', à'? ¿Chó mbez gu' nac daa? Pedr ndxab loo Jesús: ―U' nac Crist co' Diox mtel' loo izlyo' ndxè', co' nee di's, le' Diox mxo'f zin' loo U' par tí' no làa U' mèn loo con' ryes. Ndxab Jesús loo Pedr: ―Lìcque' nac co' ngolo gunèel ba', Pedr. Yende cón niin lool. ");
INSERT INTO zamNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sya, Jesús mnibe' yèepe' loo myen' xin' mté'th Jesús yende chó loo gab myen' con'a. ");
INSERT INTO zamNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ndxab Jesús loo myen', ne: ―Daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, anze'f tyactìi daa. Ryete mèngool, no mèn co' nac jef co' más ñibe' loo rye nguley', no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn nación Israel, mèna tè'b daa thìb lad no cà di's mèna cón chenen. Yiloa, ñibe' mèna le' taamas mèn guth daa. Per co'se' yilo son huiz mbeth mèna daa, daa ryo xban. ");
INSERT INTO zamNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ngoloa, ndxab Jesús loo rye mèn tedib vez: ―Chele' chó gu' ndlya's que tee noque' gu' daa ned ngue tee'en, blá'ya' gu' rye con' ndxàp gu' no byathla's gu' con' co' ndxàp gu'. No atate huiz fteche ftexyath gu' xtùuz gu' no lezo' gu' par ñee gu' ñeene' ché' xec gu' tyoo nque gu' xísen co'se' li mèn ngòc nguàal con' loo gu' por cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tac mèn co' ante ndoo lezo' ndxath ndxey' no ndxath ndlyux mèn par que no mèn che'npe' mèn loo izlyo' ndxè', loo mèna ne'ta'de Diox lugar ban mèna thidtene loo Diox. Per mèn co' lá'ya' ryethe con' co' nac yalndac che'npe' mèn co' gác mèn li mèn gan loo izlyo' ndxè' por cón chenen, loo mèna ta' Diox lugar yòo ban no mèna Diox thidtene yiloa. ");
INSERT INTO zamNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nde niin thìb con' loo gu': ¿Cón li thìb mbi' gan no chó yalndac gàc loo thìb mbi' chele' mbi' li gan gàc che'npe' mbi' dib athu izlyo', chele' mbi' tataa mod li par càba loo mbi' ryo xà' mbi' loo Diox thidtene yiloa? Yende cón li mbi' gan chele' mbi' li tataa, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tolo ndxab Jesús loo rye mèn: Chele' chó gu' thyon loo cón chenen no thyon gu' por cón che'n di's ndac co' ngon yalbàn, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, daa, ne, thyon por cón che'n gu' co'se' gal ñibe'en loo izlyo' xal thìb rey yiloa. Huiza gàc con' roo con' xèn che'n xuden Diox loon. No gàc con' roo con' xèn loon por cón che'n angl natú'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Lìcpe' ba'i, daa nii loo gu': Nzo ndxep gu' co' nzo làth na' ndxè'. Gu' ne'gathte ndoore' hui' gu' co'se' tlo Diox, ñibe'pe' Diox loo mèn loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Co'se' ngolo nguri'th xon huiz mdoodi's Jesús di'sa, ngòc thìb con'. Jesús mxen ned. Nda Jesús loo thìb yii par cuez Jesús Diox tya. Mbe' Jesús Pedr, no Cob, no Juàn. ");
INSERT INTO zamNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Láth ngue bez Jesús Diox, mzye' loo loo Jesús. No angndoo Jesús mquée xnìi loo Jesús. Le' xab Jesús na, ante nagus bèelleque' gunaa. ");
INSERT INTO zamNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Làth xtau'a, mbyú' loo chop xa'bi' co' ndoo toodi's no Jesús loo Jesús. Ryop xa'bi'a ngòc Moisés no Lii. ");
INSERT INTO zamNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Co'se' mxyo'f loo ryop xa'a loo Jesús, angnziri' xa' mquée xnìi tín' loo ryop xa'bi'a. No ndxaa'd bèel lad xa'. No mdoodi's no ryop xa'bi'a Jesús cón che'n xá mod gath Jesús le'n ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nde nxon', Pedr con taachop myen' co' ngòc xtàa Pedra, ale nde mcal' loo myen' nziri' myen'. Mxen mcal' myen'. Pente mxec myen' mdub naa myen'. Láth ngue toodi's Jesús con Moisés ryop Lii, gunèe myen' mquée xnìi loo Jesús no loo Moisés ryop Lii. ");
INSERT INTO zamNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Co'se' mbii Moisés ryop Lii, láth nda quée ryop Moisés Lii loo bé' loo Jesús, Pedr ndxab loo Jesús: ―Maistr, anze'f huen naca nzo na' trè'. ¿Xá nee U'? Nu' ndlya's toxcua' nu' son ramad par ta'i xcàl. Thìba par càl U'. Tediba par càl Moisés. No tediba par càl Lii. ¡Prob Pedr izlyo'! Leque Pedr ne'ñeede no ne'ta'de Pedr cuent cón ngue toodi's Pedr. ");
INSERT INTO zamNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Láth be' ngue toodi's no Pedr Jesús, chàa, ngulàa thìb beu loo yiia. Mtau' beu loo myen'. Látha, anze'f mzyeb Pedr con taachop myen' xtàa Pedr co'se' gunèe myen' nzo myen' le'n beu. ");
INSERT INTO zamNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Leque hora, mbyèn thìb di's le'n beu co' mbez: ―Mbi' ndxè' nac xgan'pe' daa co' anze'f ngudloon no lezon. Bìn gu' ro mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Co'se' ngolo mbyèn di'sa le'n beu, chàa, nguát beu. Gunèe myen' thidte Jesús ndoo. Per yende chó ngabte myen' loo Jesús. No ne' ne' yen cón ngab myen' cón che'n con' gunèe myen'a loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tedib huiz co' nde nque co'se' ngulàa tùub Jesús con yon myen' xin' mté'th Jesús loo yiia, huax mèn ngro' le'n rye yèez co' nziri' gax par ngua sál' mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Làth mèna nzo thìb mbi'. Cabii ndxab mbi' loo Jesús: ―Maistr, bli U' favor hui' U' cón ndyac mbyòo daa ndxè'. Mbyòo thidte nac mbi' loon co' ngue non. ");
INSERT INTO zamNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Anze'f nquée mbii che'n xpii ye'rsin' mbyòo. Co'se' nquée mbii mbyòo, angndoo mbyòo, mbez yèe mbyòo. No ncuau mbyòo. Ndryo' rsi'f fsin' ro mbyòo. Anze'f ntetìi mbiia mbyòo co'se' nquée mbii che'n xpii ye'rsin' mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tolo ndxab mbi' loo Jesús: ―Daa mna'b loo myen' xin' mté'th U' par co' myen' xin' mté'th U' xpii loo mbyòo daa ndxè'. Per ne'ngácte myen' ngo' myen' xpii loo mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús mbere ndxab loo myen' xin' mté'th Jesús: ―¡Aa, myen' co' thidteneque' indxela'ste! ¿Chonon susque' naad gu' no nguud gu', yey? ¿Axta pól naquinque' tolo go non gu' no axta pól naquinque' tolo xequen con gu', à'? Le' loo xud mbyòoa na, ndxab Jesús: ―Huàa xi xgan'l. Yi'th xgan'l ndxè', tá. ");
INSERT INTO zamNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Per co'se' mbii gax mbyòo loo Jesús, xpii ye'rsin'a mbli mquée mbii mbyòo. Ngulàa mbyòo loo yòo. No mbli xpii ye'rsin'a mquée mbii yíiz enferesi mbyòo loo Jesús. Per ante gunii Jesús loo xpii ye'rsin'a, ngro xpii loo mbyòo. Mteyac Jesús mbyòo. Sya, ndxab Jesús loo xud mbyòo: ―Mbyòo lùu ndxè'. Ngro'le' xpii ye'rsin' loo mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ryete mèn co' nziri' tya, ante mbui' mèna no ante gunaa mèna cón che'n con' roo no con' xèn co' mbli Diox loo mbyòoa. Láth ngüi' mèna no ñaa mèna cón che'n con' ngue li Jesús loo mbyòoa, Jesús ndxab loo myen' xin' mté'th Jesús: ");
INSERT INTO zamNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Bìn gu' di's co' nde niin loo gu' ndxè' co' huenleque'. No ne'yathla'ste gu' di's ndxè'. Daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, le' mèn ta'xù' daa loo mèn co' ndlya's guthxù' daa. ");
INSERT INTO zamNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Per myen' xin' mté'th Jesús ne'nda'de cuent cón nee di's co' ndxab Jesús loo myen'a. Ale mbyau' xtùuz myen' par ne'nda'de myen' cuent cón nee di'sa. No ne'ngòode valor loo myen' par ngna'b myen' loo Jesús nda' Jesús cuent loo myen' cón che'n di'sa tac mzyeb myen'. Thìba con' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Le' tediba na, angnziri' myen' xin' mté'th Jesús, mbye'th xtùuz yéc myen'. Mdoodi's myen' loo xtàa myen' cón che'n chó myen' gàc co' más ñibe' loo xtàa myen'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús nonque' no nda'que' Jesús cuent cón che'n xtùuz myen' co' nzi li myen' xtùuz. Sya, mxen Jesús thìb mbedbi' chu'th. Mdub Jesús mbedbi' chu'tha loo xab Jesús loo myen' xin' mté'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jesús ndxab loo myen' xin' mté'th Jesús: ―Chol gu' co' ndli cas loo chol myen' bix xal mbedbi' chu'th ndxè' xal nac di's co' mté'thle' gu' loon, le' sya, ndxàca loo gu' le' gu' ndlique' cas daa, ne. Chele' gu' ndlique' cas daa, gu' ngue lique' cas loo xa' co' mtel' daa. Le' gu' co' gàc más be'the làth gu' na, gu'a gàc xa' co' más ñibe' làth gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Le' sya, ndxab Juàn loo Jesús: ―Maistr, nu' gunèe le' thìb mbi' ngo' xpii ye'rsin' loo mèn. Ante mbez mbi' lèe U', ndryo xpii ye'rsin'a loo mèn. Per nu' ne'tolode ngla' ngli mbi'i tac ingue que tee node mbi' na'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús ndxab loo Juàn: ―La' gu' tolo li mbi'i. Tac mèn co' inacte ngolo ngola's na', mèna nda' lad che'n na'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Co'se' ñee Jesús nde zin' gaxle' tiemp bii Jesús loo izlyo' ndxè' no yáp Jesús loo bé' tedib vez, mbli Jesús ryes no ngo valor loo Jesús. Mxen Jesús ned. Nda Jesús par ned ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jesús mtel' ner myen' par ngua myen' thìb yèez chu'th che'n làaz mèn samari par ya cua'n myen' lugar co'te' cued Jesús con myen' xin' mté'th Jesús yál'a. ");
INSERT INTO zamNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Per mèn samaritan ne'ndalte nda' mèn lugar par cued Jesús con myen' xin' mté'th Jesús le'n yèez Samari yál'a. Tac ñee mèna le' Jesús sangnde ri'th le'n yèezya' che'n làaz mèn samari par zin Jesús ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Co'se' ñèe Cob no Juàn, co' nac xin' mté'th Jesús ne'tyalte mèna ta' mèna lugar par cued no Jesús myen' tya, ndxab myen' loo Jesús: ―Tad, ¿xá nee U'? ¿Ché' ndlya's U' le' nu' ñibe' par lyàa quìi bèel loo bé' par lyux mèn ndxè' xal mbli Lii co' mde'th di's co' ndxab Diox loo mèn póla, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesús xèe mbui' loo ryop myen'. No mbyoo Jesús myen'. Ndxab Jesús loo myen': ―¡Aa que naxèn gu'se! Gu' ne'ta'de cuent no ne'ñeede gu' chó loo xpii nzo loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, daa ne'ngalte par teluxen mèn. Ndxe'leque', daa ndal par telá'en mèn loo con' ryes. Sya, tolo mdoo myen' ned. Nda myen' con Jesús. Nda no myen' Jesús tedib yèez. ");
INSERT INTO zamNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Láth ndoo Jesús ned nda Jesús con myen' xin' mté'th Jesús, ngro' thìb mbi' liz mbi' ro ned. Ndxab mbi' loo Jesús: ―Tad, na, ne, ndlyaz ga non U' pál co'te' ya U'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús mcàb loo mbi'. Ndxab Jesús: ―Hui' nexa. Mbe'th ngue no quèe lyo' co'te' nac liz mbe'th. Le' mbin bé' na, ngue no xyòn mbin co'te' ndxàt mbin. Le' daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, ingue noden lizen co'te' gàten par ryo xcuen chu'th laden. ");
INSERT INTO zamNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ndxab Jesús loo tedib mbi': ―Ftoo nque xísen. Nda na'. Per mbi' ndxab loo Jesús: ―Tad, fta' thìb tiemp loon ner ga casen xuden co' ngolo nguth. Yiloa, sya, nda na'. ");
INSERT INTO zamNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús mcàb loo mbi'a. Ndxab Jesús: ―Hui' nexa. Mèn co' ne'tyalte yila's loo cón chenen, mèna nac xal mèn nguth loon. La'a ya ca's mèn guliz lùu thebol xud lùu co' nguth. Per ndxe'leque', lùu ya te'th no col yalbàn cón che'n di's ndac loo mèn xá mod ndlya's Diox ñibe'pe' Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ndxab tedib mbi' loo Jesús, ne: ―Tad, daa too nque xís U', ne. Per fta' U' thìb tiemp loon par ga niin Diox loo mèn gulizen. ");
INSERT INTO zamNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Per ale ndxab Jesús loo mbi': ―Hui' nexa. Daa nde nii thìb con' lool: Le' thìb mbi' ndyen yaarad no ngue gan' mbi' yòo con ngon. No láth ngue gan' mbi' yòo con ngon, chàa, mbui' mbi' par ned xís mbi' par ñee mbi' ñeene' ché' nalì nac surc co' ngue que' mbi'. Látha, chàa, mcan' yaarad thìb lad le'n surc. Ya ne'ngro'de nalì surc mbi'. Lomisque' mod ne, mèn co' tlo li con' co' ñibe'en loo mèn no yiloa más li mèna cas loo cón che'n taamas mèn leque li mèna cas loo cón chenen, mèna yende chó juis par ñibe' Diox loo mèna par ya xo'f zin' mèna con' co' ñibe' Diox loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ngolo mdoodi's Tad Jesús di'sa loo mèna, Tad Jesús mcui ayon psi' mèn. No mtel' Tad Jesús chop chop mèn par ya ner mèna loo Tad Jesús ryete yèez no ryete lugar co'te' naquin ya Tad Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ndxab Tad Jesús loo mèna: ―Lìcpe' ba'i, anze'f huax mèn nzo co' ndxàal gòn cón che'n di's ndac par lyá' mèna loo ryethe con' ryes xal ndláp mèn cosech par ne'tyuhuante cosech. Per yende huax mèn co' ya lo yalbàn loo mèna. Cona, ngue niin loo gu': Gurez gu' Tad Diox. No guuz gu' loo Tad Diox tel' Tad Diox mèn par ya te'th mèn no ya lo mèn yalbàn cón che'n di's ndac loo mèna xal co'se' ntel' thìb patrón moz par ya láp moz cosech patrón. ");
INSERT INTO zamNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Huàa gu' loo mèna. Hui' gu' nexa. Na ngue tel' gu' par ya gu' loo mèna co' nac mèn nayi' xal thìb mbacxil' co' yub mbii loo mbée par co gu' yalbàn no te'th gu' cón che'n di's ndac loo mèn nayi'a. ");
INSERT INTO zamNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Lomisque' niin loo gu', ne: Ne'hue'de gu' yex lua' gu'. Ne' ne' hue' gu' billeter gu' co' ngosua' gu' tmi. Ne'hue'de gu' chop son ned yilid. No maste be' gu' yilid co' ngue tee ni gu' ba'. Ne'lyen'te gu' ned arid par nii gu' Diox loo chol mèn co' ndoo ned. ");
INSERT INTO zamNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Co'se' yòo gu' chol liz mèn, ner gunii gu' Diox loo mèn. No gab gu' loo mèn guliza: Nu' ndlya's nagàl yo lezo' gu' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","No chele' liz mèn co'te' cued gu'a nac mèn co' nagàl nzo lezo' loo xtàa mèn no nziri' mèna rye nda mèn no rye ndye'th mèn con xtàa mèn co'se' ñii gu' Diox co' nac di's ndac loo mèna no huen yan' lezo' mèna con gu', cued gu' liz mèna sya. Nacquele' mèna, inagàlte nzo lezo' mèna con xtàa mèna no inzide rye nda no rye ndye'th mèna làth xtàa mèna co'se' ngue nii gu' Diox loo mèna, sya, ne'tyalte mèna nii mèna Diox loo gu'. Ne'cuedte gu' liz mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nacquele' mèna huen nzo lezo' ñèe mèna gu' na, cued gu' liz mèna no yan' gu' liz mèna. Hua gu' no gu gu' con' co' cuec mèna loo gu' tac thìb mèn co' ngue li zin' ndxàp derech hua mèn no gu mèn por zin' co' ngue li mèna. Cona, ngue niin loo gu': Ne'que teede gu' liz por liz mèn yèeza. ");
INSERT INTO zamNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Co'se' zin gu' chol yèez no ta' mèna lugar yòo gu' yèeza, hua gu' no gu gu' con' cuec mèna loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Fteyac gu' mèn yíiz co' nzo yèeza. No fta' gu' cuent loo mèna nde zin' gaxle' co'se' Diox ñibe'pe' loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Per chele' gu' yòo le'n thìb yèez co'te' ne'tyalte mèn yèeza ta' mèna lugar par yòo gu' yèeza, gro' gu' par ned no alanleque' gab gu' loo mèna loo xnaa: ");
INSERT INTO zamNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Yende cón lii, cara. Axta yòoya's co' nac che'n liz gu' no co' nac che'n làaz gu' co' mquée nii nu', no co' mquée nii cazon nu', zib nu' loo gu' co' càb loo Diox cón che'n gu' ba' co'se' tub rez Diox cón che'n gu'. No ndlya's nu' le' gu' non no ta' gu' cuent co' huenleque' nde zin' gaxle' huiz co'se' gàc huiz co' ndlya's Diox ñibe'pe' Diox loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Cona, ngue niin loo gu': Co'se' gàc huiz co'se' tub rez Diox cón che'n mèn, huiza gàc más yaltìi loo mèn yèeza leque loo mèn ciuda Sodom. ");
INSERT INTO zamNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ay, prob gu' izlyo', mèn yèez Corazín. No prob gu' izlyo', mèn yèez Betsaid. Tac chele' loo mèn ciuda Tir no loo mèn ciuda Sidón ngàc yalguzye' co' ngòc loo gu'a, ne' pól mtlo ngalàa yéc mèna no ngalàa lezo' mèna par ngse' mèna mod co' ngòp mèna por xquin mèna no por xtol mèna. No nglu' mèna le' mèna nxi yéc no nxi lezo' mèna. Sya, ngàca loo mèna xal mèn co' ndxoc dib ndoote lar' nagat, co' nee di's, anze'f nxi lezo' mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Per nalle', hui' gu' nexa. Más yaltìi gàc loo gu', mèn yèez Corazín no loo gu' mèn yèez Betsaid, co'se' gàc huiz co'se' tub rez Diox cón che'n mèn leque loo mèn ciuda Tir no loo mèn ciuda Sidón. ");
INSERT INTO zamNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Le' gu' na, mèn yèez Capernaum, ¿ché' ngue li gu' cuent no ché' ndxela's gu' le' gu' yòo loo bé', cà'? Yende xàa. Ndxe'leque', gu' lyàa loo quìi no loo bèel co' nac ye'rbìil co'te' yòo mèn, mèn co' Diox co' xà' loo Diox yiloa. ");
INSERT INTO zamNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mèn co' gòn di's co' tyoodi's gu', mèna gòn di's co' tyoodizen loo mèn. Le' mèn co' tè'b gu' no mèn co' chep di's gu', mèna tè'b daa no chep di's mèna daa, ne. Lomisque' ne, mèn co' tè'b daa no mèn co' chep di's daa, mèna tè'b xa' co' mtel' daa no chep di's mèna xa' co' mtel' daa. ");
INSERT INTO zamNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Co'se' ndye'th ryete ayon psi' mèn co' mtel' Jesús loo Jesús, anze'f ndyac lezo' mèna co'se' mbere mèna, ndye'th mèna. Ndxab mèna loo Jesús: ―Tad, axta xpii che'n meexù' mbìn ro nu' co'se' mbez nu' lèe U'. ");
INSERT INTO zamNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús ndxab loo mèna: ―Aa. Huenque' gunèe gu' ngòc huax con' ned ngua gu'. Per daa masre' con' gunèen. Tac daa gunèe co'se' ngro' Mebizya loo bé', ngulàa Mebizya loo izlyo'. Ngulàa Mebizya loo izlyo' xal thìb bèel gundi. ");
INSERT INTO zamNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Daa mnibe' loo gu' no mblin le' gu' ngòp con' roo no con' xèn la's nii gu' no la's ya' gu' par loo tub gu' loo mbel', no loo tub gu' loo mbacxub, no par li gu' gan loo Mebizya co' lya's tetìi gu'. No ne'gàcte nec thìb yalquìi loo gu' láth gàc con'a loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ndxab Jesús loo mèna, ne: ―Ne'tyacte lezo' gu' arid por ndxòn xpii ye'rsin' ro gu'. Ndxe'leque', ftac lezo' gu' le' lèe gu' ndub loo libr co' ngue no Diox loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Leque hora, Xpii Natú' mbli le' Jesús anze'f mdyac lezo' no mxyo'f nde' mxyo'f ndla' lezo' Jesús. Ndxab Jesús loo Diox: ―Ngue bezen di's roo no di's xèn no di's natú' loo U', Pay, tac U' ñibe'pe' loo bé' no loo izlyo' no nac bé' no izlyo' che'npe' U'. Más de cona, U' mcasloo cón che'n di's ndac co' ndlu' xá mod ñibe'pe' U' loo mèn, loo mèn co' nde'f di's ndyac ndxác li huax con' no loo mèn co' nde'f di's ndyac ndxác mèna ndxòn mèna huax con'. Ndxe'leque', ndlu' U' con'a loo mèn co' nac xal myen' bix, co' nee di's, mèn co' ne'gácte no co' nac mèn co' lya's té'th. Tataa mbli U'i, Pay, tac tataa gunee lezo' U' li U'i loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ngoloa, ndxab Jesús loo mèna, ne: ―Hui' gu' nexa. Niin con' ndxè' loo gu', ne: Diox xuden thidte vez mda' ryethe con' loon par ñibe'en loo ryethe con'. Yende chó mèn nda' cuent no non mèn chó nac daa, daa co' nac xgan' Diox. Ndxe'leque', yub Diox co' nac xuden naneei no nona. Lomisque' ne, yende chó mèn non chó nac xuden. Ante daa co' nac xgan' Diox xuden non chó nac xuden. No mèn co' yub daa nda' lugar non chó nac xuden, mèna non no nanee mèna chó nac xuden, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Le' sya, mbui' Jesús loo myen' xin' mté'th Jesús. No ndxab Jesús ante loo myen' xin' mté'th Jesús: ―Huen nda mèn, mèn co' ngue hui' con ngudloope' mèn loo con' ndxàc làth gu' co' ndlin. ");
INSERT INTO zamNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Daa ngue nii loo gu': Huax mèn co' mde'th di's co' ndxab Diox no huax mèn co' ngòc rey póla, mèna mblya's ngüi' loo con' co' ngue hui' gu' nalle'. Per ne'ngüi'de mèna loo con' ndxè'. Mblya's mèna ngòn mèna cón che'n con' co' ndxòn gu' nalle', ne, per ne'ngácte mèn ngòn mèna con' co' ngue yòn gu' nalle'. ");
INSERT INTO zamNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sya, ngo too thìb mbi' co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn làth mèna. Mnibdi's mbi' loo Jesús par ñee mbi' ñeene' cón càb Jesús. Ndxab mbi' loo Jesús: ―Maistr, ¿cón ndxàal lin par gòo ban non Diox loo bé' thidtene, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús mcàb. Ndxab Jesús loo mbi'a: ―¿Cón mbez di's co' ndub loo ley co' mxo'f Moisés loo mèn póla, à'? ¿Cón nee di's di'sa co'se' ndlabl di'sa, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mbi' co' nac maistra mcàb loo Jesús. Ndxab mbi': ―Di's co' ndub loo ley co' mxo'f Moisés loo mèn mbez: Fque' lezo' gu' Tad Diox gu' dib nzo yéc gu' no dib nzo lezo' gu'. No fque' lezo' gu' gunèe gu' hues xtàa gu' xalque' ngue lezo' gu' ñèe gu' gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sya, ndxab Jesús loo mbi' co' nac maistra: ―Anze'f huen mcàbl, ndee. Yende cón niin lool. Chele' lùu, lìcque', ndli con'a, yòo ban no lùu Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Per mbi' co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn mden' lezo' le' Jesús mbli par mden' mbi' di's. No mden' mbi' nèe ngulàa di'sa le'n lezo' mbi'. Sya, mblya's mbi' mdub mbi' razon che'n mbi' cón che'n di's co' mnibdi's Jesús loo mbi'. Por cona, ndxab mbi' loo Jesús: ―Tad, ¿chó mèn nac hues xtàa daa? ");
INSERT INTO zamNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mcàb Jesús loo mbi'. Ndxab Jesús: ―Nde niin thìb con' lool, mbi': Thìb mbi' nde làa tùub par ned ciuda Jerusalén. Nda mbi' par ned ciuda Jericó. Per láth nde làa tùub mbi'a, ngro' plá huan' loo mbi'. Mbli huan' huan' che'n mbi' axta xab mbi' co' noc mbi' mbli huan' huan'. Mda' huan' che'n mbi'. Casque' yamerle' nguth huan' mbi'. Ngolo mbli huan' con'a, mxon' huan'. ");
INSERT INTO zamNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Per le'pe' ngolo xec ngòc con'a, nde làa tùub thìb mbi' co' ngòc nguley' leque par neda. Per co'se' gunèe mbi' co' ngòc nguley'a nax prob mbi'a tya, ale nguri'th mbi' co' ngòc nguley'a thìb lad co'te' nax prob mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Lomisque', nde làa tùub tedib mbi' co' nac mbi' co' nxo'f zin' le'n templ tiempa. Co'se' gunèe mbi' nax mbi'a tya, ale sangnguri'th mbi'a thìb lad co'te' nax prob mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Per ndxe'leque', thìb mbi' co' nac mèn che'n thìb yèezya' che'n làaz mèn samari, mbi'a ndyee viaj. Nde riid mbi'a par neda, ne. Co'se' gunèe mbi' samaritan nax prob mbi'a tya, mblyat lezo' mbi' samaritan gunèe mbi' samaritan prob mbi' co' naxa. ");
INSERT INTO zamNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Sya, mbii gax mbi' samaritan loo mbi' co' naxa. Mbli mbi' samaritan remed lad mbi' co' mbuí'a con aceit no vin. No mchi'x mbi' lar' lad mbi'a. Ngoloa, mxít che mbi' samaritan mbi'a. Mteque' mbi'a mbi' co' mbuí'a burr. Mbe' mbi'a mbi' co' mbuí' par làth yèez. Mna'b mbi' posad loo mèn yèeza par quenap mèna mbi' co' mbuí'a liz mèn yál'a. ");
INSERT INTO zamNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Co'se' ngonìi izlyo' tedib huiz co' nde nquea, mdix mbi' si' fchop pes loo mèn co' mda' posada. No ndxab mbi' samaritana loo mèna: Fquenap gu' mbi' ndxè'. Chele' mbi' tolo li gast, co'se' beren ndyalen, sya, tolo quixen tmi loo gu' cón che'n gast co' tolo li mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ngoloa, ndxab Jesús loo mbi' co' nac maistr: ―¿Xá neel, maistr? Loo yon mèna, ¿chó mèn ndyacl ngòc hues no xtàa che'n prob mbi' co' mbli huan' huan'a, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Sya, mcàb maistra. Ndxab maistr loo Jesús: ―Ndyaquen mbi' co' más mblyat lezo' gunèe prob mbi' co' mbuí'a ngòc hues no xtàa mbi'a. Sya, ndxab Jesús loo mbi' co' nac maistr: ―Byàa. No huàa li loo mèn huesl no xtàal xal mbli mbi' samaritana loo mbi' co' mbuí'a, ndee. ");
INSERT INTO zamNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Le' Jesús na, mxen ned. Nda Jesús. Mzin Jesús thìb yèez chu'th. Mzyál' Jesús thìb xa'got co' lèe Mart. Mart ndxab loo Jesús: ―Tad, nda na' lizen par cued U' plá huiz lizen. Sya, ngua Jesús liz Mart ndxep tiemp. ");
INSERT INTO zamNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta mque no thìb bél Mart co' ngro' lèe Mari. Mari más mbli mdub Mari loo Jesús par ndxòn Mari di's co' ndyoodi's Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Le' Mart na, más mbix no rsin' Mart. Sya, mbii gax Mart loo Jesús. Ndxab Mart loo Jesús: ―Tad, ¿ché' indyacte U' ilé'de nac co' ngue li Mari, bél daa ba', tac mblá' Mari daa? Ale thidten ngue bix no rsin'en ndxè'. Guuz U' loo Mari lyath no Mari daa. ");
INSERT INTO zamNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús mcàb loo Mart. Ndxab Jesús: ―Mart, ale más ndyóol gàc loo rsin'l co' ngue lil ba'. ");
INSERT INTO zamNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Per nzo thidte con' co' más naquin cui mèn. Mari mbye'th yéc li Mari co' nac más con' ndac. Le' sya, con' ndac co' ngue li Mari ndxè', yende chó mèn techei loo Mari. La' taa tub Mari loon. ");
INSERT INTO zamNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Thìb vez Jesús ngue bez Diox thìb lugar. Co'se' ngolo ngurez Jesús Diox, thìb myen' xin' mté'th Jesús ndxab loo Jesús: ―Tad, blu' U' nu' xá mod cuez nu' Diox xal mblu' Juàn Bautist myen' xin' mté'th Juàn Bautist. ");
INSERT INTO zamNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús ndxab loo myen' xin' mté'th Jesús: ―Co'se' cuez gu' Diox, taandxè' gurez gu' Diox: Diox, U' co' nac xud nu'; U' co' nzo loo bé'; nu' ndlya's le' U' li le' ryethe mèn loo izlyo' gab le' natú' nac lèe U'. Lomisque', ña'b nu' loo U', bli U' par gàc yalnibe' che'n U' loo izlyo' ndxè'. No gàc xal nee lezo' U' loo izlyo' ndxè' xalque' ndxàc yalñibe' che'n U' loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Lomisque' ne, ña'b nu' loo U': Bli U' par que no nu' con' naquin nu', que naca con' hua nu', que naca chol con' naquin nu' thìb huiz no tedib huiz. ");
INSERT INTO zamNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Fton' U' xtol nu' no xquin nu' tac nu', ne, nteri'th ntecan' xquin no xtol che'n ryete mèn co' ndli con' ye'rsin' loo nu'. Ne'lá'ya'de U' nu' par cobya' Mebizya nu' no li Mebizya preb nu' par ñeene' ché' tli nu' con' ye'rsin'. Ndxe'leque', ña'b nu' loo U' ftelá' U' nu' loo chol con' ryes no loo chol con' ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ndxab Jesús thìb di's loo myen' xin' mté'th Jesús, ne: ―Angab na'i, chele' chó gu' ngue no thìb amiu gu' no yi'th amiu gu' liz gu' coyor yál' no ñee amiu gu'a loo gu': Amiu, bli favor, techè son yèth loon, cara. ");
INSERT INTO zamNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Tac thìb amiu daa co' nac mèn tith ngolo xec mzin lizen nalle'. No nalle' nec thìb sa yèth yende le'n roob par ta' nu' sa lua' rsè amiu daa. ");
INSERT INTO zamNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Más de cona, angab na'i, mbi' co' nac vecin gu'a, mbi' càb loo gu' par le'n nyòo. Ñee mbi' loo gu': Ne'li xoltel daa, cara. Ndale' yál' nalle'. Ryo' quej ndoo nau'. Más de cona, myen' bix nzo cuat nu' loo lun'. Nzi yàt myen'. Yende mod yiche nu' par ta' nu' yèth càal, cara. ");
INSERT INTO zamNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Per na nii loo gu': Mastale' indlya'ste xa' co' nac vecin gu'a yiche xa' par ta' xa' con' naquin gu', per ndxe'leque', ngo cheque' xa'bi'a con sa'l xa' par mda' xa' ryethe con' naquin gu' par ne'tolode li xol gu' xa'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Por cona, ngue niin loo gu': Co'se' cuez gu' Diox, gurez gu' Diox taandxè' mod xal ndli mèn co' ña'b con' loo xtàa mèn. Le' sya, Diox lique' par que no gu' con' co' ña'b gu'a. No co'se' cuez gu' Diox, bli gu' loo Diox xal mèn co' mtuhuan thìb con'. Yiloa, noo noo ncua'n mèn con'a axta zyal con'a loo mèna. Le' sya, tataa mod Diox li par ta' Diox con' co' ngue na'b gu' loo Diox. No co'se' cuez gu' Diox, bli gu' xal mèn co' nte's ryo' axtaque' xal' mèn ro ryo' par yòo gu'. Tataa mod gàcque' loo gu' co' ña'b gu' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tac mèn co' tolo mbez Diox dib nzo yéc mèn, no dib nzo lezo' mèn, Diox li cas loo mèna. No lyath no Diox mèna no xal' Diox ned no xal' Diox yó' par que no mèna con' co' tolo ña'b mèna loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ngoloa, mnibdi's Jesús thìb di's loo mèn. Ndxab Jesús: ―¿Ché' nzo chó gu' co' nac gundan loo xin' gu' co' nzo trè', angab na'i, chele' xin' gu'a ña'b sa pan hua xin' gu', ché' tli gu' ryes ta' gu' thìb quèe hua xin' gu'a co'se' ña'b xin' gu' pan, cà'? o ¿ché' tli gu' ryes ta' gu' thìb mbel' hua xin' gu' co'se' ndlya's xin' gu' hua xin' gu' thìb le' mbèel, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","No co'se' ña'b xin' gu' thìb ngò par hua xin' gu', ¿ché' tli gu' ryes ta' gu' thìb mbacxub hua xin' gu', cà'? Yende mod li gu' tataa loo xin' gu', ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mastale' nac gu' gundan nalas no gundan ye'rsin', gu' ta'que' con' ndac co' ña'b xin' gu' loo gu', ¿lé'? Chele' gu' tataa nque' lezo' ñèe gu' xin' gu', ale'que' xud gu' Diox co' nzo loo bé' ne' li par làa xud gu' Diox Xpii Natú' loo mèn no yo Xpii Natú' loo mèn no ñibe'pe' Xpii Natú' loo mèn, mèn co' ña'b loo Diox par li Diox gàca tataa loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ngo thìb mbi' co' mque no thìb xpii che'n meexù'. Xpiia mbli ngòc mud mbi'. Per co'se' mblo' Jesús xpii loo mbi'a, ngóc mbi' mdoodi's mbi' tedib vez. Le' mèn co' ngure loo Jesús co' gunèe mblo' Jesús xpii loo mbi'a na, ante mbui' mèna no ante gunaa mèna loo con' mbli Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Per taandxep mèn co' ngureri' tya, mèna ndxab loo xtàa mèn: ―Tyè'. Mbi' ba' ngo' xpii che'n meexù' loo mèn ante por cón che'n Beelzebú co' nac jef che'n rye xpii meexù'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Le' taamas mèn na, ndxab loo Jesús ale angli Jesús gàc thìb con' roo no thìb con' xèn loo bé' co' gac xal thìb señ par hui' mèn par ñee mèna ñeene' ché' tác Jesús li Jesús yalguzye' co' gàc thìb señ loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Per Jesús nonque' xtùuz co' ndli mèna xtùuz le'n lezo' mèna. Ndxab Jesús loo mèna: ―Nde niin thìb con' loo gu': Chele' thìb nación gàc rol mèn co' nzo naciona no leque mèna bixyath contra xtàa mèn, sya, leque mèna li par lyux nación mèna. Lomisque' ne, chele' chop ned mèn guliz naban thidte yòo no cua'n leque mèna xó' loo xtàa mèna, por lult lyux mèn guliza. ");
INSERT INTO zamNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Chele' rye xpii che'n meexù' co' ñibe' Beelzebú tlo gàc rol, sya, leque xpii meexù'a cue contra xtàa xpii. ¿Xá mod tolo ñibe' Beelzebú loo xpiia, sya? Con' ndxè' nac di's co' ngue niin loo gu' tac gu' mbez loon le' daa ngo' xpii che'n meexù' loo mèn por cón che'n Beelzebú co' nac jef che'n xpii che'n meexù'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Chele' daa ngo' xpii che'n meexù' loo mèn por cón che'n Beelzebú, ¿por cón che'n chó xa' ndli mèn co' nqueltàa no gu' par co' mèna xpii che'n meexù' loo mèn, sya? Mèna tub rez cón che'n gu' par non gu' ilé'de nac co' ngue li gu' xtùuz. ");
INSERT INTO zamNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Per ndxe'leque', daa ngo' xpii che'n meexù' loo mèn xalque' nac con' roo con' xèn che'npe' Diox co' nzo la's niin no la's yan. No con' co' ndlin loo mèna ndlu' loo mèna mzinle' tiemp co'se' tlo ñibe'pe' Diox loo mèn. Thìba con' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Le' tediba na, nde niin tedib con' loo gu': Co'se' nac thìb mbi' mbi' tín', mbi'a ngue no huax scopet liz mbi'. Ndyen mbi' scopet mbi' par quenap mbi' liz mbi'. Le' sya, con scopet co' nzo ya' mbi' co' nquenap mbi' liz mbi'a, segur nzo ryethe con' co' ndxàp mbi' liz mbi'. Yende chó mèn li ryes bii gax loo liz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Per chele' tedib mbi' co' nde li huan' liz mbi'a nac más mbi' tín' leque mbi'a, le' sya, mbi' co' ndea teche rye scopet che'n ner mbi' co' ndli cuent anze'f mbi'a, co' nac leque mbi' co' ndxàp yalxla's yende chó bii gax loo liz mbi' por ryete scopet co' mque no mbi' liz mbi'. Tataa mod li mbi' co' ndea gan ryete con' co' mque no ner mbi' liz mbi' axta li'th mbi' ryete con' co' mbli huan' mbi' liz mbi'a loo xtàa mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tolo ndxab Jesús loo mèna: ―Mèn co' inda'de lad chenen, mèna nac ngolo ngola's loon. Le' mèn co' indlyath node daa loo zin' co' mxo'f zin' xuden loon, ndxe'leque', mèna nteza' zin' co' ngue lin. ");
INSERT INTO zamNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Co'se' ndryo' thìb xpii che'n meexù' loo thìb mbi' por cón chenen, xpii che'n meexù' ndryo'. Nda que tee xpii co'te' nagán par cua'n xpii che'n meexù' co'te' li xpiia descans. Per co'se' ne'yilode zyal xpiia co'te' li xpii descans, sya, leque xpii gab loo lezo' xpii: Capas daa ale beren, ndyàan loo mbi' co'te' ngòc lizen co'te' ngro'en. ");
INSERT INTO zamNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Per co'se' mbere xpiia, ndye'th xpiia loo mbi'a, ñèe xpii ndxe'sleque' mbi' ngue tee mbi'. No ante nambìi ñaa le'n lezo' mbi' xal thìb le'n nyòo co' ante nítleque' ndlyo'f no xal thìb liz mèn co' natoxcua' per tarte yòo Xpii Natú' che'n Diox loo mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Sya, nda xi xpiia taagaz xpii co' nac más xpii ye'rsin' leque ner xpiia par queltàa no xpiia ryete gaz xpiia par thidte ngòc rye xpiia ngòo rye xpiia loo mbi'a. Por lult más nazab ngòca loo mbi' leque ndoore' ryo' ner xpiia loo mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Be' ndoo toodi's Jesús loo mèna, ngrozèe thìb xa'got làth mèna. Ndxab xa'gota loo Jesús: ―Huen nda xa'got co' nac xna' U' co' mdoo nac U', U' co' nac xin' xa'gota. No huen nda xa'gota por nacque' xa' xna' U' tac mda' xa'gota xìiz xa'gota ngòoz U'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús mcàb loo xa'gota. Ndxab Jesús: ―Lìcque' nac di's co' neel ba'. Yende cón niin lool. Per más huen nda mèn co' ndxòn di's no co' ndxaa'd di's co' mbez Diox loo mèn par tyubdi's mèna di's co' ñibe' Diox loo mèna par li mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Látha, tolo mqueltàa mèn loo Jesús. Le' Jesús na, mtlo mdoodi's loo mèna. Ndxab Jesús loo mèna: ―Mèn co' naban le'n tiemp ndxè' axta arid nazab nac mèna. No ale ña'b mèna loon anglu'en thìb con' loo mèn co' gàc xal thìb señ loo mèna. Per ya ne'liden nec thìb con' loo mèna. Ante tan cuent loo mèna cón che'n con' co' ngòc loo thìb mbi' co' ngro' lèe Jonás, mbi' co' mde'th di's co' ndxab Diox loo mèn. Con' co' ngòc loo mbi' co' ngro' lèe Jonás gàc xal thìb señ loo mèn co' naban tiemp ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Texal ngòc thìb con' loo mbi' co' ngro' lèe Jonás co' ngòc thìb señ co' mbui' mèn no co' gunaa mèn, mèn co' ngòc mèn ciuda Nínive tiempa, tataa gàca loon, ne, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo', loo mèn co' naban tiemp ndxè' xal ngòc señ loo mbi' co' ngro' lèe Jonás. ");
INSERT INTO zamNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Co'se' gàc huiz co' tub rez Diox cón che'n mèn co' naban tiemp ndxè', huiza thìb xa'got co' ngòc rein loo thìb nación par ned sur, xa'gota ryo' too loo mèn co' naban tiemp ndxè' no quexù' xa'gota mèn co' naban tiemp ndxè' loo Diox. Tac xa'gota ngro' co'te' ngòc nacionpe' xa', nación co' ngòc tedib lad ro izlyo' par ned sur, par mbi'th yòn xa'gota di's co' anze'f ngóc Salomón. Per nalle' nzo thìb mbi' co' nac más mbi' roo mbi' xèn leque Salomón làth gu'. No ale indlide gu' cas mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","No co'se' gàc huiz tub rez Diox cón che'n mèn co' naban tiemp ndxè', mèn co' ngo ban ciuda Nínive ryo' too loo mèn co' naban tiemp ndxè'. No quexù' mèn co' ngo ban ciuda Nínive mèn co' naban tiemp ndxè' loo Diox tac mèn ciuda Nínive ngulàa yéc no ngulàa lezo' no mzye' mod co' ngòp mèn ciuda Nínive co'se' mbìn mèna xti's Diox co' mde'th Jonás co' ndxab Diox loo mèna. No nalle' nzo thìb mbi' co' nac más mbi' roo mbi' xèn leque Jonás làth gu' no ale indlide gu' cas mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Lomisque' ne, yende chó mèn nzo co' co xnìi thìb lampr no yiloa casloo mèn lampra thìb lugar co'te' naga's. No ne' ne' tau' mèn loo lampra con thìb cajón par yau' loo xnìi. Ndxe'leque', quetal mèn lampr gáp par gápleque' tenìi lampr loo mèn co' ndxòo no loo mèn co' ndryo' le'n nyòo. ");
INSERT INTO zamNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ngudloo mèn ndli ngüi' mèn ned ndyee mèn. Le' xtùuz mèn na, ndli par nteche ntexyath mèn lezo' mèn loo con' huen no loo con' ye'rsin'. Chele' gu' nalì no nambìi ndli xtùuz, le' sya, nalìque' no nambìique' nac yalnaban gu' loo Diox. No chele' ngudloo gu' ihuente ndli, indxú' ndacte con' loo gu' ned ndyee gu'. Lomisque', ndxàca loo gu' nacquele' nac xtùuz gu' xtùuz ye'rsin' co' ngue li gu'a, sya, nac gu' mèn ye'rsin' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Anderhuen gu'. Nee gu' xá nzi tee gu'. Tac ne' ngue yàc xnìi co' mduble' yéc gu' no xnìi co' mduble' lezo' gu'a loo cón che'n Diox xal yál'cuau co' ndli ncuau izlyo', co' nee di's, tlo gu' li gu' xal nac cón che'n xab izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Chele' gu' ndli xtùuz dib nzo yéc gu' no dib nzo lezo' gu' co' nac xtùuz ndac, sya, ndxàca loo gu' ndyub xnìi yéc gu' no ndyub xnìi lezo' gu' loo cón che'n Diox co' nac con' ndac. Tataa mod gàc loo gu' loo cón che'n Diox xal thìb lampr co' ntenìi loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Co'se' ngolo tataa mdoodi's Jesús di'sa loo mèna, thìb mbi' xley' farise ndxab loo Jesús: ―Nda thuhua na' lizen, ey. Sya, nda no Jesús mbi'. Ngòo Jesús le'n nyòo. Mdub Jesús loo mes con mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mbi' xley' farisea ante mbui' no ante gunaa co'se' gunèe mbi' ne'ntechte Jesús ya' Jesús par hua Jesús xal nac costumbr co' mque no mèn loo xley' mèn tiempa. ");
INSERT INTO zamNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Per Jesús ndxab loo mbi' xley' farisea: ―Gu' co' nac mèn xley' farise, más nxyo'f ndeleque' lezo' gu' par li gu' xal nac costumbr par tech gu' taz no plat co' ndli zin' gu' leque la's gu' gu' loo cón che'n xtùuz co' ndli gu' le'n lezo' gu'. Tac gu' ndli xtùuz le'n lezo' gu' xá mod xexte li huan' gu' cón che'n xtàa gu' no xá mod xexte li gu' chol con' ye'rsin' loo chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Susque' naad gu' no susque' nguud gu' ñeene' ¿ché' inonte gu' no ché' inda'de gu' cuent leque Diox co' mtoxcua' le'n plat, leque Dioxa mtoxcua' xís plat, ne, cà'? Cona nee di's, Diox mbli ngue no gu' yéc gu' no lezo' gu' par li gu' xtùuz xalque' mbli Diox par que no gu' taamas part che'n lad gu' par gàc lad gu' thìb con' co' li zin' loo gu, ey. ");
INSERT INTO zamNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ndxàalque' ta' gu' gòn dib nzo yéc gu' no dib nzo lezo' gu' cón che'n ryethe con' co' ndxàppe' gu'. Le' sya, nalì no nambìi gàc gu' loo Diox no ne'tyóode gu' cón che'n plat no taz. ");
INSERT INTO zamNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ay, prob gu' izlyo', mèn xley' farise, tac gu' nzo yen' nzo xique' co'se' tub rez Diox cón che'n gu'. Tac axta fthyoxtil', no rud, no taamas huan nayèe co' ndxàp gu' nda' gu' diezm loo Diox. Per incua'nte gu' mod xá mod que tee ban nalì gu' loo hues xtàa gu' no xá mod que' lezo' gu' Diox. Ndxàalque' ta' gu' diezm xal ndli gu' ba'. Per más naquin li mèn par cua'n mèn mod que tee nalì mèn loo hues mèn no loo xtàa mèn no que' lezo' mèn Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ay, prob gu' izlyo', mèn xley' farise, tac gu' nzo yen' nzo xique' co'se' tub rez Diox cón che'n gu'. Gu' asendli par ndyub gu' loo asient le'n sinagog loo mèn par hui' mèn no par ñaa mèn loo gu' par gab mèn anze'f mèn guryath mèn guryèn nac gu'. No a la fuerz ndlya's gu' nii mèn Diox loo gu' no gàp mèn mod ñèe mèn gu' ned co'te' zyál' mèn gu' làth taamas mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ay, prob gu' izlyo', mèn xley' farise, tac gu' nzo yen' nzo xique' co'se' tub rez Diox cón che'n gu'. Aa que ndxác gu' ntembìi ro gu' no ntembìi xti's gu'. Per daa nii loo gu' le' gu' nac xal bá' mèn nguth co' indxú'de pá nax o pá nziri' bá' le'n panteón. No ale ndloo ndub mèn loo bá' tac indxú'de pá nax bá'. Pues, co' ngue niin loo gu' ndxè' nee di's le' mèn co' ndli cas gu', prob mèna inonte xá nac mod ye'rsin' co' ngue no gu' no co' ndxàp gu' le'n lezo' gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sya, ngro' nxon' thìb mbi' co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn. Mcàb mbi' loo Jesús. Ndxab mbi' loo Jesús: ―Maistr, di's co' ngolo ndxab U' loo mèn ba', ngue gòo di's U' cón che'n nu', ne. No nazab ndlyàa di's ba' le'n lezo' nu', ndyaquen. ");
INSERT INTO zamNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús mcàb loo mbi'. Ndxab Jesús loo mbi': ―Ay, prob gu' izlyo', gu' co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, tac nzo yen' nzo xique' gu' co'se' tub rez Diox cón che'n gu'. Tac gu' tolo nzib con' co' ñibe' gu' loo mèn li mèn cón che'n Diox co' ne'xecte mèn tolo li mèn xal ñibe' gu'. No nec thìb mod no nec tedib mod incua'nte gu' mod teche gu' yalnibe' co' mnibe' gu' loo mèn par li mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ay, prob gu' izlyo', gu' co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn. Tac gu' ñibe' toxcua' mèn armit che'n prob mèn co' mde'th di's co' ndxab Diox póla. No ale leque xudgool gu' co' ngo ban póla mbethxù' prob mèn co' mde'th di's co' ndxab Dioxa. ");
INSERT INTO zamNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Con' co' ndli gu'a nee di's thidte ngòc gu' con xudgool gu' no con con' co' mbli xudgool gu'. Xudgool gu' mbeth mèna. Le' gu' na, mbli mandad par mtoxcua' mèn armit che'n mèn co' mde'th di's co' ndxab Diox co' mbeth xudgool gu'a. ");
INSERT INTO zamNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Por anze'f ndxác tín' Diox, cona, ndxab Diox: Na tel' mèn co' te'th di's co' gaben loo mèn. Tel'en mèn co' ndxe' di's cón che'n di's ndac loo mèn, ne. Tub ngu's mèna mèn co' tel'en. No guth mèna mèn co' tel'en, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Co'se' tub rez Diox cón che'n rye mèn, gu', ne, nzo yen' nzo xique' gu'. Ale le'le' gu' co' naban tiemp ndxè', tyactìi gu' por cón che'n mèn co' mbethxù' xudgool gu' póla, mèn co' mtlo mde'th di's axta co'se' diz mtlo mblec Diox izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Diox li rez cón che'n ren co' mxyo axta co'se' mbeth mèn co' ngòc xudgool gu' Abel póla no axta mbeth mèn hues xtàa gu' Zacari le'n templ gaxte loo còo' le'n tiemp ndxè'. Cona, ngue niin loo gu': Le' Diox tub rezque' cón che'n gu' co' naban tiemp ndxè' par tyactìi gu' por mbeth xudgool gu' mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ay, prob gu' izlyo', gu' co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn, no gu' mèn xley' farise. Gu' nzo yen' nzo xique' co'se' tub rez Diox cón che'n gu'. Gu' mtau' ned mtau' yó' par ne'té'thte mèn cón che'n Diox. No ne'ngòode gu' loo cón che'n Diox. Ne' ne' indla' gu' yòo mèn co' lya's té'th cón che'n Diox loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Co'se' mbìn mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn no mèn xley' farise tataa ndxab Jesús loo mèna, anze'f ngocloo tín' mèna gunèe mèna Jesús. Mtlo mèna, mnibdi's mèna huax con' loo Jesús. Ale asembli mèna, mnibdi's mèna chol con' loo Jesús par bel'que' tataa mod yitac lezo' Jesús ñèe Jesús mèna, ");
INSERT INTO zamNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","par ñee mèna ñeene' ché' bel'que' tataa mod yigaa Jesús loo mèna loo di's co' gab Jesús par gàc li mèna gan quexù' que' fals mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Làth xtau'a, sate más mqueltàa mèn loo Jesús. Per mil mil mèn mqueltàa loo Jesús axta mblo mdub mèn loo xtàa mèn. Le' Jesús na, mtlo mdoodi's loo mèna tedib vez. Nerleque' loo myen' xin' mté'th mtlo Jesús, mdoodi's Jesús. Ndxab Jesús loo myen': ―Anderhuen gu', ey. Fquenap gu' gu' loo mod ye'rsin' co' ndxàp men xley' farise ba'. Tac mod ye'rsin' co' ndxàp mèna ntolo nteza' huax mèn loo cón che'n Diox. Mèn ba' anze'f ndxác ntembìi ro no ntembìi xti's. ");
INSERT INTO zamNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Fté'th gu' no fte' lezo' gu' yende nec thìb con' co' nau' loo co' ne'ryo xo'fte. No ne' ne' yen nec thìb con' co' xexte ndxàc co' ne'yathte no co' ne'yènte. ");
INSERT INTO zamNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Por cona, chol con' ye'rsin' co' mbez mèn xexte co'te' yende chó mèn gòn mbez mèn di'sa, alanleque' yath yèn di'sa loo mèn loo xnaa. No di's ye'rsin' co' ndyoodi's mèn xexte le'n nyòo liz mèn, di'sa yath yèn cabii loo chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Myen', gu' co' ndxàc amiu daa, nde niin thìb con' loo gu': Ne'zyebte gu' ñèe gu' mèn co' ndxác guth bél'yòo ladpe' gu'. Tac co'se' yilo guth mèn bél'yòo ladpe' gu', ya yende cón tolo li mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Niin loo gu' chó loo ndxàal zyeb gu'. Bzeb gu' gunèe gu' Diox tac co'se' ngolo nguth bél'yòo lad mèn, ante Diox ndxàp con' la's nii Diox no la's ya' Diox par tetìi Diox mèn le'n ye'rbìil, mèn co' ndxàal yòo ye'rbìil. ");
INSERT INTO zamNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Ché' tarte ñee gu' ndyo' ga'y mbin por thìb pes, cà'? Mastale' yende cón ntac mbin, ndyac mèn, per Diox indxathla'ste cón che'n nec thìb mbin. ");
INSERT INTO zamNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hui' gu' nexa. Axta yis yéc gu' co' ndoo yéc gu' ba' Diox naneeque' plá yis ndoo yéc gu'. Cona, ngue niin loo gu': Gu' masque' ntac leque huax mbin bé'. ");
INSERT INTO zamNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Chol mèn co' ta' cuent loo xtàa mèn le' daa nac xgan' Diox co' mtel' Diox loo izlyo', daa, ne, co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, daa ta cuent no gaben loo angl che'n Diox loo Diox le' mèna nac mèn che'npe'en. ");
INSERT INTO zamNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Per rye mèn co' cà' di's daa loo xtàa mèn no ne'ta'de mèn cuent le' daa nac xgan' Diox loo mèna, cón che'n mèna daa ta cuent no gaben loo angl loo Diox le' mèna inacte mèn co' nzo loo cón che'npe'en. ");
INSERT INTO zamNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Lomisque' ne, chol mèn co' ñii yèe ñii tìi cón chenen, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, mèna nzoque' mod tyon' xtol. Per mèn co' ñii yèe ñii tìi cón che'n Xpii Natú', cón che'n xtol mèn co' mcua'n mèn por gunii yèe gunii tìi mèna cón che'n Xpii Natú' ne'tyon'te thidtene. ");
INSERT INTO zamNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Niin tedib con' loo gu': Co'se' hue' mèn co' ndxecloo ñèe gu' gu' loo mèn co' nqueltàa sinagog, no co'se' hue' mèn gu' loo juez, no co'se' hue' mèn gu' loo mèn nac zin' yòolau, co'se' cue gu' loo mèna, ne'tyóode gu' xá mod càb gu' loo mèna o cón gab gu' loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tac co'se' zin hora, Xpii Natú' lu' loo gu' xá mod ndxàal càb gu' no xá mod ndxàal tyoodi's gu' loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Be' ngue toodi's Jesús loo mèn. Làth mèna nzo thìb mbi' co' ndxab loo Jesús: ―Maistr, guuz loo huesen ta' huesen herens co' nac chenen càan. ");
INSERT INTO zamNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús ndxab loo mbi'a: ―¡Aa, mbi'! ¿Chó mdoo daa loo gu' par gàc daa xal thìb juez loo gu' no par gàc daa xal thìb mbi' co' ndli rol xyòn gu' loo gu', à'? Inacte zin'a zin' co' ndlin. ");
INSERT INTO zamNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ndxab Jesús loo mèna, ne: ―Anderhuen gu'. Leque gu' hui' xal nziri' gu'. Fquenap gu' gu' loo ryethe con' co' ndli ndyub yo'f lezo' mèn par que no mèn con' co' ndli ndyub yo'f lezo' mèn par ne'queli'thte gu' con' co' ndli ndyub yo'f lezo' gu'. Tac mastale' ndli gu' xtùuz que no gu' huax con' co' ndryo' ndlyen' le'n lezo' gu', inacte con' co' ncàb loo yalgon'a co', lìcque', li le' mèn ban no Diox thidtene, ey. ");
INSERT INTO zamNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jesús ndxab loo mèna, ne: ―Nde niin tedib con' loo gu': Ngo thìb mbi' ric. Mbi'a anze'f ngòp che'n. No anze'f thìb cosech mthop mbi' loo rye xyòn mbi' co' mque no mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Per thìb huiz xèe mdub mbi'. Mbli mbi' xtùuz le'n lezo' mbi'. Ndxab mbi' loo lezo' mbi': ¿Cón lin con rye cosech co' mthopen ba', yoo? Ingue noden co'te' gosuan cosech daa ba'. ");
INSERT INTO zamNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mbere mbi' rica, mbli mbi' xtùuz le'n lezo' mbi' tedib vez. Ndxab mbi': Neequen xá ñaa thìb con' nde lin. Na nda sil yòo co'te' ngosuan cosech daa ba'. Per leque tua' toxcuan tedib yòo co' más naroo leque co' silen. Le' sya, tya gosuan ryete cosech co' mthopen. No gosuan ryete con' ngue non. ");
INSERT INTO zamNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Le' sya, gaben loo lezon: ¡Cara! Nase ngue non huax con' co' nzosua' par que no na'i huax lín'. Li na' descans, hua na', no gu na' axta plóthe. Más de cona, ndxàal ta' na' gust lezo' na' ndxep. ");
INSERT INTO zamNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Per Diox ndxab loo mbi' rica: ¡Aa mbi'! Susque' naadl no susque' nguudl. Leque yál' ndxè' gathl no ryete con' ngue nol ba', ¿chó mèn gàc che'na yiloa, à'? Axta ne' ne' gàc ryete cosech ba' cón che'npe'l, ndee. ");
INSERT INTO zamNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tataa ndxàc loo chol mèn, mèn co' ante ndoo lezo' que no yalgon' loo izlyo' ndxè' no ndxàc ric mèna axta plóthe. No loo cón che'n con' co' angli Diox loo mèn no con' co' anggàc che'n mèn loo Diox ale le'le' ndlyàa tìi mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ngolo mdoodi's Jesús di'sa loo mèn, ndxab Jesús loo myen' xin' mté'th Jesús: ―Nde niin thìb con' loo gu', ey: Ne'gath lyuxte gu' loo cón che'n yalnaban gu' par tyóo gu' cón goc gu' yé' huize'. ");
INSERT INTO zamNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ndxe'leque', más ntac yalnaban mèn leque con' hua mèn. No más ntac yalnaban mèn leque xab mèn co' goc mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hui' gu' loo rsin' ngáa co' ndli ngáa. Ngáa ingode bin. Ne' ne' inthop ngáa cosech. Ne' ne' ingosua' ngáa nzob. Mastale' indlide ngáa con'a, Diox nguàaque' ngáa. Ale'que' gu' co' más ntac leque thìb ngáa, pà ne'huàade Diox gu', ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Chó thìb gu' co' nzo làth gu' co' más ndxath ndlyux par gác gu' zib gu' loo gu' taarol metr par yol gu' taachu'th, à'? Yende chó gu' gác lii, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Chele' gu' ne'gácte li thìb con' co' nac más chu'th o más be'the, ¿chonon susque' más ndxath ndlyux gu' par li gu' con' co' más ñaare', sya? ");
INSERT INTO zamNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Hui' gu' no gunaa gu' xá mod ndryoo nxyèn ye' co' mbez mèn lèe ye' madalen. Ye'a indlide zin'. Ne' ne' inzìi ye' madalen dó' par goc xab ye' madalen. Mastale' yende cón ndli ye' madalen, per más nabe's ñaa ye' madalen leque Salomón co' ngòc rey co'se' mdoc Salomón xab Salomón no co'se' ante nít nayèe gunaa Salomón mdoc xab Salomón. ");
INSERT INTO zamNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","¡Aa mèn co' xhuite ndxela's loon no mèn co' xhuite ndxàp yalxla's loon! Chele' Diox tataa mod nxèn' huan co' nzo'f yii no den, no yé' huize' mbiizte huana, gàc huana yaa biiz co' yòo le'n thìb gor, ale'que' gu' ne' li Diox par que no gu' ryethe con' naquin gu'. ¡Aa mèn izlyo'! Axta ne' ne' inda' gu' cuent cón ndxàc loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Por cona, ne'xide lezo' gu'. No ne' ne' tyóo gu' cón hua gu' no cón gu gu' yé' huize'. ");
INSERT INTO zamNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tac chol mèn co' alithe naban dib athu loo izlyo', más ndyóo mèna xá mod gàp mèna rye con' naquin mèna. Tac con' co' ncua'n mèn nac con' co' alithe ncua'n mèna. Per gu' ngue no xud gu' co' nonque' no co' naneeque' co'pe' naquin gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Más huen blo yéc gu' ta' gu' lugar ñibe'pe' Diox loo gu' no cua'n gu' mod li gu' con' co' ndxòo lezo' Diox. Chele' gu' tataa li, Diox lyath no gu' que no gu' ryethe con' naquin gu', ne. ");
INSERT INTO zamNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ne'zyebte gu', myen', gu' co' nac xal mbacxil' daa. Mastale' nagabte gu' nzo loon, per Diox xud gu' ndyac lezo' yòo gu' loo cón che'n Diox xud gu' par ñibe'pe' Diox loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chele' gu' tho' ndxep con' co' ngue no gu' par ryo' tmi loo con'a par ta'la's gu' tmi loo mèn co' naquin tmi, sya, tataa mod gàca loo gu' yòo lezo' Diox loo cón che'n con' co' ngue li gu'. Sya, Diox tolo li par que no gu' huax con' ndac axta plóthe loo bé' co'te' ne'lyuxte con', no co'te' ne'yiza'de con', no co'te' ne'yòode huan' par li huan' huan' yalgon'a, no co'te' ne'gácte mxìl yòo mxìl par teza' mxìl con' co' gàp gu' loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Le' sya, co'te' ndxàple' gu' yalgon'pe' gu', tya más tyub yo'f lezo' gu' no anze'f ngue li gu' purad par yòo gu' tya par hui' gu' loo yalgon'pe' gu' co' ndxàple' gu' tya. ");
INSERT INTO zamNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tolo ndxab Jesús: ―Bli nab gu' gu' loo cón chenen xal mèn co' altant nziri' loo zin'. No gòc gu' xal co'se' ngo mèn xnìi thìb lampr par tenìi lampr loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","No bli gu' xal ndli moz co' nzi bed coyor zin patrón moz co'se' bere patrón, ye'th patrón co'te' ngua patrón co'te' mselya' thìb ned myen'. Sya, co'se' mbere patrón, ndye'th patrón, texal zin patrón altant ndoo moz, xal' moz puert ro ned co'se' te's patrón puert. ");
INSERT INTO zamNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Huen nda moza tac ndub naa moz co'se' mzin patrón. Lìcpe' ba'i, na nii loo gu': Yub patrón toxcua' co' hua moz. No yiloa, ñibe' patrón loo moz tyub moz loo mes. Yiloa na, cuec patrón co' hua moz loo mes. ");
INSERT INTO zamNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mastale' zin patrón gulal yál', o mastale' zin patrón coyor cuar, chele' patrón ñèe altantque' ndoo moz no ndub naa moz co'se' zin patrón, anze'f huen nda moza, sya, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nde niin thìb con' loo gu', myen', par ta' gu' cuent: Angab na'i, chele' thìb mbi' co' ñibe' liz mbi' non mbi'a coyor yi'th huan', mbi' tyub naa no ne'gàtte mbi'. Sya, tataa mod li mbi' gan ne'la'de mbi' xal' huan' liz mbi' par yòo huan' liz mbi', li huan' huan' che'n mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Cona, ngue niin loo gu': Altant gure gu' loo cón chenen tac zin thìb huiz no zin thìb ze co'se' yende chó mèn ta' cuent no co'se' indyóode mèn cón gàc huiza. Huiza, chàa, galen loo izlyo' ndxè' tedib vez, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sya, mnibdi's Pedr loo Jesús. Ndxab Pedr: ―Tad, ¿ché' ante cón che'n nu' co' nac myen' xin' mté'th U' ndyoodi's U' di's co' mtetac U' di's ba' o ché' ngue toodi's U' di's ba' cón che'n ryete mèn co' nzi yòn di'sa, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","43","Ndxab Tad Jesús loo Pedr: ―¿Chó moz ñibe' patrón gàc moz mandador liz patrón, no loo taamas moz liz patrón par ñibe' moza loo taamas moz, no ta' moz con' hua xtàa moz co'se' gáal hor hua moz, à'? Niin loo gu' chó gàc moza. Gàc moz mandador, moz co' altant ndoo loo zin' patrón no co' ndyubdi's ndac loo patrón. Huen nda moza co'se' ndye'th patrón moz, ngua patrón moz viaj, ");
INSERT INTO zamNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","no ñèe patrón moz ndli moz xal mtan' patrón di's loo moz. Lìcpe' ba'i, na nii loo gu': Le' patrón moz ñibe' par gàc moz mandador loo ryethe con' ngue no patrón liz patrón. ");
INSERT INTO zamNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Per, angab na'i, chele' moza li xtùuz no gab moz loo lezo' moz le' patrón moz lyen' huax huiz no ne'zingàade patrón moz, sya, tlo moz, tetìi moz taamas xtàa moz. No tetìi moza criad, ne. Más de cona, tlo moz, hua moz, no gu moz, no ale axta tyuuz moz. ");
INSERT INTO zamNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Làth xtau'a, patrón moz zin thìb huiz co' indub bedte moz zin patrón moz. No zin patrón moz thìb hor co' indlide moz xtùuz zin patrón moz. Le' sya, patrón moz tyen mached no làa patrón moz mached rloo moz axta guth patrón moz moz. Tataa mod li patrón moz loo moz par yòo moz co'te' yòo mèn co' ne'tyalte yila's loon. ");
INSERT INTO zamNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Le' tedib moz co' nonque' no co' naneeque' xal nac co' ndlya's patrón moz li moz no ne'nglide moza no ne' ne' ndubdi's ndac moza ro patrón moz, patrón moza ta' che'n moza axta plóthe. ");
INSERT INTO zamNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Per moz co' inonte no co' inda'de cuent xal ñibe' patrón moz no mbli moz con' co' indxàalte li moz, mastale' ndxàal ta' patrón che'n moz, per xhuite ta' patrón che'n moz. Tac mèn co' más mté'th mod che'n patrón par li ndac mèn co' ñibe' patrón, loo mèna más tan' patrón di's par li mèna con' lya's patrón. Le' loo mèn co' ngòp patrón más confians na, loo mèna tolo chal patrón par li mèna más con' ndac co' lya's patrón li mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tolo ndxab Jesús loo mèna: ―Daa ndal par go xo'fen cón che'n mod co' ndxàp mèn loo izlyo'. No por con' ndal lo xo'fen cón che'n mèn, con'a li càb loo mèn tlo mèn, tyub quìi tyub bèel lezo' mèn ñèe mèn xtàa mèn por cón chenen. ¡Ngaca cón gàca! Luega tlo gàca loo mèn. ¡Huen! ");
INSERT INTO zamNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","¡Cara! Huen huen naneen le' mèn tetìi daa axta gath daa. No naneen nzo yen' nzo xique' daa gàcque' con'a loon. No thìb ndlyazen setilte riida loon. ");
INSERT INTO zamNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ché' ndli gu' cuent le' daa ndal loo izlyo' par lin le' gu' cue ban rye nda gu' no rye ndye'th gu' làth xtàa gu', cà'? Yende xàa. Ndxe'leque', daa ndal par lin zyal di's zyal cuent làth gu'. No axta gàc gu' chop ned mèn làth xtàa gu' por cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tac desde nalle' par delant ga'y mèn co' naban thìb yòo co' nac liz mèn, son mèna tyoo xà' lezo' loo xtàa mèn co' naban yòoa. Mèna cue yoo con taachop mèn co' nzo leque yòoa por cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Lomisque' mod gàca loo taamas xtàa mèn, ne. Leque gundanbi' yecloo ñèe xgan' gundanbi'. No leque xgan' gundanbi' yecloo ñèe gundanbi'. No leque gundangot yecloo ñèe rsap gundangot. No leque rsap gundangot yecloo ñèe gundangot. Le' mèn co' nac xna'zap na, yecloo ñèe xa'got co' nac xìix. Le' xa'got co' nac xìix na, yecloo ñèe xna'zap por cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ndxab Jesús loo mèn, ne: ―Co'se' ñèe gu' ndxetoo xcuau par ned ndlyen huiz, mbez gu': Yamerle' lyàa yùu, cara. No lìcque', ndxàca tataa loo gu', ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","No co'se' ñèe gu' ndryo' mbii par ned sur, mbez gu': Anze'f thìb bée lyàa. No, lìcque', ndxàca loo gu', ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Aa mèn izlyo'! Aa que ndxác gu' ntembìi gu' ro gu' no ntembìi gu' xti's gu'. Non gu' xá ñaa co' ndxàc co'se' ngo' gu' cuent cón che'n señ co' ndxú' loo bé' no señ co' ndxàc loo izlyo'. Chele gu' tataa non no nda' gu' cuent cón che'n bé' no izlyo', ¿chonon ne'gácte gu' ta' gu' cuent cón che'n con' co' ndxàc le'n tiemp ndxè' xal nda' gu' cuent cón che'n señ co' ngüi' gu' no co' ñaa gu', à'? ");
INSERT INTO zamNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Chonon indlide gu' par leque gu' tub rez cón che'n gu' no par li gu' con' co' nac con' nambìi no con' co' nac con' nalì, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Chele' chó mèn ta' part cón che'n gu' loo xcal no ya no mèna gu' yòolau par ya be' gu' loo xcal yòolau, más huen cua'n gu' mod xá mod tàl gu' loo di's no loo cuent ned nda gu' par ne'hue'de mèna gu' loo xcal. Tac chele' cón che'n gu' tyub rez loo xcal, xcal ta' gu' loo tenient par ya que' tenient gu' lezi'f. ");
INSERT INTO zamNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na nii loo gu': Ne'ryo'de gu' lezi'f axtaque' quix gu' mult co' quib xcal lad gu'. Sya, ryo' gu' lezi'f. ");
INSERT INTO zamNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Leque le'n huiza, ngua plá mèn loo Jesús par ngua ta' mèn cuent loo Jesús xá mod asembli Pilat mandad mbeth solndad ndxep mèn par ned le'n yèezya' che'n làaz mèn galile láth ngo mèna le'n templ par mcos solndad ren mèn con ren má' co' mbeth mèna par xo mèn rena loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús ndxab loo mèna: ―¿Ché' ndli gu' xtùuz no ché' ndli gu' cuent le' con' co' ngòc loo mèn par ned le'n yèezya' che'n làaz mèn galile ngòc loo mèna por ngòc mèna mèn co' ngòp más xquin no xtol leque taamas mèn co' ngòc mèn gulàaz mèna, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yende xàa. Cona, ngue niin loo gu': Chele' gu' ne'lyàade yéc no ne'lyàade lezo' loo con' ye'rsin' co' ndli gu' no chele' gu' ne'zye'de mod co' ndxàp gu', gu', ne, lyux. ");
INSERT INTO zamNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Ché' ndxela's gu' co'se' nguth ryete si'n pson mèn co' nguth co'se' mbua's ftoo che'n thìb yòobé' co' mdub co'te' ngure tanc che'n Siloé co' ngob che loo mèna, mèna más ngòp xquin no xtol leque taamas mèn co' nzo ban ciuda Jerusalén, cà'? Yende xàa. ");
INSERT INTO zamNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Cona, ngue niin loo gu': Chele' gu' ne'lyàade yéc no ne'lyàade lezo' gu' loo con' ye'rsin' co' ndli gu' no chele' gu' ne'zye'de mod co' ndxàp gu', gu', ne, lyux. ");
INSERT INTO zamNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús ndxab loo mèna, ne: ―Nde tetaquen thìb con' loo gu'. Ngo thìb mbi' co' ngòc patrón. Mbi'a mque no thìb xan' yaa ngudyuug loo xyòn mbi'. Ndxàc plá lín' seguid nda tee hui' mbi' loo yaa ngudyuug ñeene' ché' ndoole' ngudyuug loo yaa. Per co'se' ndyee tee hui' mbi' loo yaaa, nec thìb ngudyuug iñèede mbi' ndoo loo yaaa. ");
INSERT INTO zamNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Sya, ndxab mbi' loo moz mbi' co' ndli zin' loo yòoa: Hui' nexa, moz. Nde teele' son lín' seguid ndalen loo yaa ngudyuug ba' par ñeen ñeene' ché' ndoole' ngudyuug loo yaa ba'. No co'se' ndalen, iñèeden nec thìb ngudyuug loo yaa ba'. Más huen fcho' yaa ba' tac nca'i loo xyónen. ");
INSERT INTO zamNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Per moz co' ndli zin' loo yòoa mcàb loo mbi'. Ndxab moz: Tad, la'a tee tooi lín' ndxè'. Nda tele'en yòo xàn'a no gon be'f xàn'a. ");
INSERT INTO zamNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ne'stolque' lín' ndxè' ta'i xlè. Per chele'i ne'ta'de xlè, syase, li U' mandad cho'i. Tataa ndxab Jesús loo mèna par lu' Jesús loo mèna le' Diox ncha'la's tín' loo mèn. Per chele' mèn ne'tyalte lyàa yéc mèn no chele' mèn ne'tyalte lyàa lezo' mèn loo con' ye'rsin' co' ndli mèna no se' mèna mod co' ndxàp mèna loo Diox, telux Diox mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ngoloa, ngòc thìb con'. Thìb huiz sabd co' ngòc huiz descans tiempa, Jesús ngue lu' mèn le'n thìb sinagog. ");
INSERT INTO zamNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Làth mèn co' ngo le'n sinagoga, ngo thìb xa'got. Xa'gota ndxàcle' si'n pson lín' ngue no thìb mbii ye'rsin'. Mbii ye'rsin'a mbli mblyeng xís xa'gota. Le'n rye lín'a, yende mod ndoo lì xís xa'gota thidtene. ");
INSERT INTO zamNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Co'se' gunèe Jesús xa'gota, Jesús ngurez xa'gota. Ndxab Jesús loo xa'gota: ―Ngot, ya ne'tolode que nol mbii ye'rsin' ba' xísl. ");
INSERT INTO zamNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Sya, ante mxo'f Jesús ya' Jesús loo xa'gota, leque hora mdoo lì xís xa'gota. Ndxab xa'gota: ―¡Ay, Dio's! Con' roo con' xèn mbli U' loon. Mteyac Tad ba' daa. ");
INSERT INTO zamNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Per mbi' co' ngòc jef che'n sinagog co' ndyoo naa loo mèn le'n sinagoga, anze'f ngocloo mbi' loo Jesús tac mteyac Jesús xa'gota huiz sabd co' ngòc huiz descans tiempa. Sya, ndxab mbi' loo rye mèn co' nziri': ―Xop huiz nac thìb sman par li mèn zin'. Más huen yi'th gu' le'n huiz sman par gàc remed gu'. Ne'yi'thte gu' huiz co' nac huiz descans par gàc remed gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sya, ndxab Jesús loo mbi' co' ndyoo ner no co' ndyoo naa loo mèn le'n sinagog: ―¡Aa que ndxácl ntembìi rol no ntembìi xti'sl con xtàal loon, cara, gu' co' thidte mod ndxàp loo cón che'n huiz descans. ¿Ché' nzo chó gu' co' nziri' trè' co' nac arid mènley' ne'xacte gu' ngon gu' no ne'xacte gu' burr gu' huiz sabd co' nac huiz descans par ya ta' gu' nít gu ngon gu' no burr gu' huiz descans, à'? Txac gu' má' gu', ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Lomisque', tan cuent loo gu' cón che'n xa'got ndxè' co' nac bin Abraham co' ngolo mteyaquen. Mebizya mtedó' xa'got ndxè' con thìb yíiz mbii che'n xpii ye'rsin' co' mbli mteleng yíiz xa'got ndxè'. No ndxàcle' si'n pson lín' thidtene mteleng mbii xís xa'got ndxè'. No nalle' ndlyazen ñee gu' loon: ¿Ché' ngue li gu' cuent indxàalte xaquen xa'got ndxè' loo yíiz mbii co' ndub xís xa'got ndxè' par yac xa' nalze co' nac huiz sabd co' nac huiz descans, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Co'se' ngolo ndxab Jesús di'sa, ryete mèn co' ngòc ngolo ngola's che'n Jesús mthyon tín'. Per ndxe'leque', taamas mèn co' nziri', anze'f mdyac lezo' mèna co'se' gunèe mèna con' roo con' xèn co' mbli no Jesús xa'gota loo mèna. Thìba con' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Le' tediba na, Jesús ndxab loo mèn: ―Nde niin thìb con' loo gu' cón che'n xal nac mod co' ñibe'pe' Diox loo mèn nalle'. ");
INSERT INTO zamNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mod co' tlo yar' mèn co' ndyal yòo loo cón che'n Diox par ñibe'pe' Diox loo mèn, le'i nac xal biz bin mostaz co' mblo thìb mbi' bin loo xyòn mbi'. No ndryoo nxyèn huan mostaza yamerle' xal thìb xan' yaa xcàl. No ale axta mbin bé' ntoxcua' xyòn mbin loo huan yaa mostaza. ");
INSERT INTO zamNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ndxab Jesús loo mèn, ne: ―¿Xá nee gu'? ¿Chó con' tetaquen mod co' ndxàc co'se' tlo ñibe'pe' Diox loo mèn nalle'? ");
INSERT INTO zamNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pues mod co' tlo ngue ñibe' Diox loo mèn nac xal co'se' xèegà xèegà ndxos con' ye'rsin' con con' ndac co' ndlu' cón che'n di's ndac loo mèn dib athu izlyo' xal co'se' ndyen thìb xa'got ndxepte dii levadur par ncos xa' son bols harin par tyoo bes co'f par toxcua' xa'gota pan. ");
INSERT INTO zamNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ngolo mdoodi's Jesús di'sa, mxen Jesús ned. Nda Jesús par ned ciuda Jerusalén. Co'se' nda riid Jesús, nguri'th Jesús le'n rye ciuda no le'n rye yèez co'te' mblu' Jesús cón che'n di's ndac loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ned nguri'th Jesús ngo thìb mbi' co' mnibdi's thìb con' loo Jesús. Ndxab mbi' loo Jesús: ―¿Ché' ndyac U' ndxepte mèn nzo co' lyá' loo ryethe con' ryes, lé'? Jesús mcàb loo mbi'. Ndxab Jesús loo mbi': ");
INSERT INTO zamNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Bli gu' purad yòo gu' loo cón che'n Diox tac loo cón che'n Diox anze'f nagàn nac par yòo mèn. Mod co' yòo mèn loo cón che'n Diox nac xal co'se' ndlya's mèn yòo mèn ro thìb puert co' anze'f naya. Anze'f huax mèn nzo co' lya's yòo loo cón che'n Diox per ne'gácte mèna yòo mèna loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tac ne'stolque' gàca loo gu' ne'tyalgàde gu' yòo gu' loo cón che'n Diox. Sya, gàca loo gu' loo cón chenen xal co'se' mtau' thìb mbi' co' nac gundan puert ro ned liz mbi' ndxáal yál'. Yiloa, syare' nde mèn. Ndoo mèn ro ned. No nte's mèn ryo'. Mbez mèn loo mbi': Tad, fxal' U' puert par yòo nu'. Sya, mbi' co' nac che'n liza càb loo mèna. Gab mbi': Byàa gu'. Ne'needen pá ned ngro' tee gu' no ne'needen pá ned ngro yáal gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Axta syare', tlo gab gu' loo mbi' co' nac gundana, co' nee di's, daa nac mbi'a: Nu' nduhua no U'. No ngu no nu' U'. No mblu' U' nu' co'se' mbi'th riid U' làaz nu'. ");
INSERT INTO zamNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Per mbi' càb loo mèna no ñee mbi' loo mèna: Na guniile' loo gu': Ne'needen pá ned ngro' tee ngro yáal gu'. Biiche gu' loon, rye gu' co' nziri' ro puert ba', gu' co' ndli con' ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Co'se' gath gu', bii xpii gu' no alm gu' le'n ye'rbìil. Tya tlo gu' gón' gu' no hua le gu'. Tac axta syare' hui' gu' loo Abraham no loo Isaac no loo Cob. No hui' gu' loo ryete mèn co' mde'th di's co' ndxab Diox póla co'te' ngue ñibe' no mèna Diox co'te' ñibe'pe' Diox loo ryethe con'. No axta syare' li la's gu' cón che'n co' ngue niin loo gu' ndxè'. Per ale ndxe'leque', ne'yòode gu' làth mèna thidtene. ");
INSERT INTO zamNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Co'se' gàc tiempa, yi'th rye mèn co' naban par ned ndlyen huiz, no mèn co' naban par ned mbix huiz, no mèn co' naban par ned nort, no mèn co' naban par ned sur par yòo mèna co'te' ngue ñibe'pe' Diox. Tya gàca loo mèna angta'la's Diox huax con' ndac loo mèn xal co'se' ndxòo mèn loo thìb lni par tyac tín' lezo' mèna. Tataa gàca loo mèna loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tiemp ndxè' nzoque' mèn co' pente mxyal' ned mxyal' yó' loo par ndxòn mèn cón che'n di's ndac xá mod ndlya's Diox ñibe'pe' Diox loo mèn. Mèna sangngola's co'se' mbìn mèna di'sa no ngòoque' mèna loo cón che'n Diox. Per lomisque', nzoque' huax mèn co' mxyal' ned mxyal' yó' loo par ndxòn mèna cón che'n di's ndac xá mod ndlya's Diox ñibe'pe' Diox loo mèn. Per mastale' mbìn mèna cón che'n di's ndaca, ne'ndalte mèna ngòo mèna loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ngolo ndxab Jesús di'sa loo mèn, leque le'n huiza mzin ndxep mèn xley' farise loo Jesús. Ndxab mèna loo Jesús: ―Byàa. Gro' trè'. Tac Herod co' nac rey ndlya's guth lùu. ");
INSERT INTO zamNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús mcàb loo mèna. Ndxab Jesús: ―Byàa gu' no guuz gu' loo Herod co' nac xal mbée co' ngo to': Hui', Herod. Mbi' co' lèe Jesús gunee loo nu': Nalze no yé' be' go'en xpii ye'rsin' loo mèn. No be' teyaquen mèn yíiz. No axta huize' telon zin' co' ngue xo'f zin'en. ");
INSERT INTO zamNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Taapláte huiz no maste be' ngue tee xo'f zin'en co' nac huiz co' ngue que tee'pe'en taachu'th. Yiloa, tenen ned. Gan par ned ciuda Jerusalén tac yende mod gath thìb xa' co' nde'th di's co' ndxab Diox thìb lad co'te' inacte le'n ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Aa mèn ciuda Jerusalén, gu' co' mbeth mèn co' mbi'th te'th di's co' ndxab Diox! No mbuaa'd quèe gu' mèn co' mbi'th lo yalbàn co' nac di's ndac che'n Diox loo gu', mèn co' mtel' Diox loo gu'. Ne' pól ndxàc mblyazen thidte queltàan gu' loon xal ndli nguiiddol colec co'se' ngue's nguiiddol colec nguiid yen' xàn' xíl' nguiiddol colec per thidtene ne'ndalte gu' ngàca tataa loo gu', ey. ");
INSERT INTO zamNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Per nalle', hui' gu' nexa. Na nii loo gu', mèn ciuda Jerusalén, le' Diox mblá'ya'le' gu'. Más de cona, gu' ya ne'berede hui' loon axta co'se' zin huiz no zin ze co'se' gab mèn: Anze'f ndyac tín' lezo' mbi' co' nde por lèe che'n Tad Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ngòc thìb con' loo Jesús thìb huiz sabd co' ngòc huiz descans tiempa. Jesús ngua thuhua no thìb mbi' co' ngòc jef che'n mèn xley' farise liz mbi'. Le' taamas mèn xley' farise co' nziri'a na, xèe nzi la's loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ngo thìb mbi' co' mxac yíiz quìi làth mèna loo Jesús, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sya, mnibdi's Jesús loo mèn co' ngòc maistr che'n ley co' mxo'f Moisés loo mèn no loo mèn xley' farise. Ndxab Jesús: ―¿Xá nee gu'? ¿Ché' ndxàal teyaquen thìb mbíiz huiz co' nac huiz descans o ché' indxàalte lina, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Per mèna xèe ngure. Yende chó ngabte mèna. Sya, mxen Jesús ya' mbi'a. Mteyac Jesús mbi'a. Ndxab Jesús loo mbi': ―Byàa par lizl, ndee. ");
INSERT INTO zamNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ngoloa, ndxab Jesús loo mèn xley' farise: ―Yende chó gu' co' nziri' trè' co' ne'co'de thìb burr gu' o thìb laa ngon gu' le'n thìb tó' huiz sabd chele' thìb burr gu' o ngon gu' ngòb che le'n tó' huiz sabd co' nac huiz descans, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mèna yende cón ngác ncàb loo Jesús. Thìba con' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Le' tediba na, xèe ngüi' Jesús xal ndxàc mèn co' nda fandang co'te' mselya' thìb ned myen'. Mdub mèn loo asient co'te' más tyu' mèn no tye's mèn loo xtàa mèn loo mes. Jesús mco'x di's ndxè' loo mèna. Ndxab Jesús loo mèna: ");
INSERT INTO zamNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Nde niin thìb con' loo gu': Co'se' chol mèn yi'th nee loo gu' par ya gu' fandang co'te' selya' thìb ned myen' par ya thuhua gu', ne'tyubte gu' loo asient co'te' ndyub mèn co' más ndli cuent nac mèn roo no mèn xèn tac, ne'stolque', yi'th mèn co' más nzo'f lèe nzo'f xti's leque gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Le' sya, mèn co' mbli convid ryop ned mèna, ñee mèna loo gu': Fta' asient co' ndubl ba' tyub mèn ndxè' loo mes. Sya, mèna xít too gu' loo asient loo mes. Sya, que nzo ne'ñee lezo' gu', yitoo gu' loo asient loo mes par tyub mèna co'te' yitoo gu'. Le' gu' na, nalyat nde'f ro ya tub gu' loo asient co' nziri' axta squin le'n nyòo. ¿Xá lyàai le'n lezo' gu' li mèna tataa loo gu', sya? ");
INSERT INTO zamNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ndxe'leque', co'se' li mèn convid gu' par ya thuhua gu' sa lua' gu' co'te' mselya' thìb ned myen', na nii loo gu': Más huen tyub gu' loo asient co' nziri' axta squin le'n nyòo par ñee mèn, co' ngua li convid gu'a loo gu', tyub gu' loo asient co'te' ndxàal más tyu' gu': Amiu, ftub co'te' más ndyu' mèn ba'. Le' sya, tataa mod más tyu' gu' loo mèn co' ndub loo mes. ");
INSERT INTO zamNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tac mèn co' asendli ndye's, thyon mèna loo Diox. Le' mèn co' ndxàp mod no indlu'de mèna ndye's mèna, Diox li loo mèna le' mèna gàc mèn roo no mèn xèn loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ndxab Jesús loo mbi' co' mbli convid Jesús, ne: ―Co'se' lil thìb yalhua, que naca xhui, que naca rsè, ne'lidel convid mèn co' nac amiu lùu, ne' ne' lil convid mèn co' nac mèn huespe'l, ne' mèn co' nac mèn gulizl, ne' mèn ric co' nac vecinl. Tac mèna lique' convidl cadque' co'se' li mèna yalhua. Chele' lùu ante ndli tataa, sya, ante nda'l gust lezo'l no ndyacl ndxàc con' ndac lool. Per loo Diox ne'yòode cuent cón che'n con' ndlil. ");
INSERT INTO zamNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ndxe'leque', co'se' lil thìb yalhua, bli convid mèn prob, no mèn yíiz, no mèn renc, no mèn sieu. ");
INSERT INTO zamNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Huen ndal chele' lùu li tataa loo mèna tac mèna ne'gácte quix por con' mda'l nduhua mèna. Le' part cón che'nl na, Diox li anggàc con' ndac lool co'se' gàc huiz co'se' ryo xban mèn co' nac mèn nalì no mèn nambìi loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Co'se' mbìn thìb mbi' co' nzo làth mèn co' mdub loo mes tataa ndxab Jesús, mbi' ndxab loo Jesús: ―Ndyac lezo' mèn co' hua no U' làth mèn co'te' ñibe'pe' Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús ndxab loo mbi'a: ―Thìb mbi' mbli convid huax mèn par yi'th mèna loo thìb yalhua co' li nab mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Co'se' ngóol hor hua mèna, mbi' mtel' moz mbi' par ngua li moz avis loo mèna par yi'th mèna loo yalhua. Ndxab moz loo mèna: Bli gu' purad par ya thuhua gu' loo yalhua tac con' co' hua gu' ngòc nable'. ");
INSERT INTO zamNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Per ryete mèn co' ngòc convida, thidte mcàb mèna loo moz co' ngua li avis loo mèn. Ner mbi' co' ngòc avis looa, mbi'a ndxab loo moz co' ngua li avisa: Na ngolo mxi thìb le' xyònen, no nalle' daa nda tee hui' xá nax xyònen. ¡Cara! Guuz loo patronl nee patronl xá mod li patronl par ba'. Na ne'gade loo yalhua. ");
INSERT INTO zamNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Le' tedib mbi' na, ndxab: Na ngolo mxi ga'y ned ngon. No nalle' nda lin preb má' xàn' yaarad par ñeen ñeene' xá ryo' má'. ¡Cara! Guuz loo patronl nee patronl xá mod li patronl par ba'. Na ne'gade loo yalhua. ");
INSERT INTO zamNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Le' tedib mbi' na, ndxab loo moz: ¡Cara! Na ngolo mselya' con thìb mza'. No conate ndli yende mod gan loo yalhua. Guuz loo patronl nee patronl xá mod li patronl par ba'. Le' daa ne'gade loo yalhua. ");
INSERT INTO zamNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Co'se' mbere moz, ndyàa moz par liz patrón, mda' moz cuent xá mod ngòca loo moz loo patrón. Co'se' mbìn patrón di's co' ndxab moz cón che'n mèna, anze'f ngocloo tín' patrón moz con mèna. Sya, ndxab patrón loo moz: Goror huàa cua'n mèn co'te' nac ned yòo no co'te' nac rye ned co' nsyo le'n yèez par ya xil mèn prob, no mèn yíiz, no mèn renc, no mèn sieu, yi'th mèna loo yalhua. ");
INSERT INTO zamNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ngoloa, co'se' ndye'th moz, ndxab moz loo patrón moz: Daa mblile' xal mnibe' U' loon. No tatabe' nalath co'te' tyubre' mèn par yi'th mèn loo yalhua. ");
INSERT INTO zamNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Patrón mbere ndxab loo moz tedib vez: Bere, huàa tee hui' co'te' nac ned yòo no rye co'te' nsyo ned. Por fuerz guuz loo rye mèn co' zyál'l par yi'th mèna, hua mèna no par yi'th mèna, gu mèna. Tac ndlyazen zyè lizen con rye mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tolo ndxab patrón loo moz: Na nii lool: Nec thìb mèn co' nerleque' mblin convid ne'taden lugar loo mèna yòo mèna le'n nyòo lizen par yòo mèna loo yalhua. ");
INSERT INTO zamNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ngoloa, anze'f thìb mèn mdoo nque xís Jesús. No mbere Jesús ned xís Jesús. Mbez Jesús loo mèna: ");
INSERT INTO zamNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Chele' chó gu' nde nque xísen, no más ndli gu' cas xud gu', no xna' gu', no xa'got gu', no xin' gu', no hues gu', no fta'n gu', no ndxàc chop lezo' gu' chonon mblá' gu' yalgon' gu' no ryethe con' co' nda' gust lezo' loo izlyo' ndxè' leque más ngue li gu' cas cón chenen, yende mod gàc gu' myen' xin' mté'th daa. ");
INSERT INTO zamNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","No gu' co' ne'xecte gàc ngòc nguàal con' loo gu' por cón chenen, gu'a yende mod gàc myen' xin' mté'th daa. ");
INSERT INTO zamNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jesús tolo ndxab loo mèna: ―Nde niin tedib con' loo gu', ne: Angab na'i, chele' chol gu' co' nziri' trè' ndlya's toxcua' gu' thìb liz gu' con vari no con ciment co' gàc chop son pis, ner ndyub gu' par co xnee gu' plál li gu' gast no par ñee gu' ñeene' ché' taal tmi co' mqueltàa gu' par telo gu' zin'a, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Per ndxe'leque', chele' gu' msèle' cimient co'te' tyub liz gu' no ne'lide gu' gan telo gu' liz gu'a, le' sya, ryete mèn co' hui' tataa nac zin' co' ngue li gu'a, tlo mèna xìis no mèna gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","No gab mèna: ¡Ay, prob mbi' ba' izlyo'! Mbi' ba' ngue xít te'f thìb liz mbi' co' nac chop o son pis no ale ne'nglide mbi' gan ntelo nxít te'f mbi' liz mbi' ba'. ");
INSERT INTO zamNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Tolo ndxab Jesús loo mèna: Nde niin tedib con' loo gu', ne: Chele' thìb rey nzo lezo' li rey thìb xó' con tedib rey, ¿ché' ngue li gu' cuent ne'tyubte reya ner par co xnee reya ñeene' ché' tli si' mil solndad che'n reya gan loo gal mil solndad che'n tedib rey co' nac ngolo ngola's co' nde li xó' loo solndad reya, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","No chele' ner reya mblo xnee ne'lide ner reya gan loo xó', no tatabe' tith nzo tedib reya, le' sya, ner reya tel' di's loo tedib rey par tàl ner reya loo di's no loo cuent par tataa mod tu' tàl rey ndxè' loo di's no loo cuent. ");
INSERT INTO zamNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Cona, ngue niin loo gu': Chele' chol gu' más ndli cas loo cón che'n gu' leque li gu' cas loo cón chenen, gu'a yende mod gàc lìcpe' xin' mté'th daa. ");
INSERT INTO zamNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nde niin tedib con' loo gu', ne: Anze'f huen nac ted. No axta arid nquin mèn ted. Per chele' ted nac ted nala, ¿xá mod gàc nazii teda no xá mod tezii ted con' ndxuhua mèn, sya? Yende mod gàca tataa tac ted nac ted, ¿lé? ");
INSERT INTO zamNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ne'lide sirv ted par gàc ted yòo. Ne' ne' li sirv ted par gàc ted be'f. Alithe cobii mèn ted. Gu' co' ndxaa'd di's ndxè', bìn gu' di's ndxè' no fta' gu' cuent co' huenleque' cón nee di's di's ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Láth be' ngue toodi's no Jesús mèna, rye mèn co' ndli cobrar tmi cón che'n contribución no rye mèn co' ngòp xquin no co' ngòp xtol mbii gax loo Jesús par gòn mèna di's co' ndyoodi's Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","No co'se' ñèe mèn xley' farise no mèn co' ngòc maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn tiempa xal mqueltàa mèn loo Jesús, xèe ndla's mèna loo Jesús. No xexte mbez mèna loo xtàa mèna: ―Hui' gu' nexa. Mbi' ba' nqueltàa no mèn co' ndxàp xquin no co' ndxàp xtol. No axta ndxuhua no mbi' mèn ba'. Nazab ngue li mbi' ba', ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesús ndxab loo mèna: ");
INSERT INTO zamNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Nde niin thìb con' loo gu': De loo rye gu' co' nziri' trè', angab na'i, ¿ché' nzo thìb gu' co' ngue no thìb ayo mbacxil' no láth ngue tee queno gu' mbacxil'a, xexte mdyuhuan thìb mbacxil' ngro' mbacxil' làth partid, ché' ne'yòode valor loo gu' par lá' gu' rye partid mbacxil', co' nac thap gal nzo si'n thap mbacxil' ante mbacxil' ned huana co'te' nac segur par ya cua'n gu' mbacxil' co' taa mdyuhuan axtaque' zyal gu' thìb mbacxil'a, cà'? Lìcque', lá' gu' rye mbacxil'a thìb lugar, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","No co'se' zyal gu' mbacxil'a, xo'f gu' mbacxil'a xís yen gu', tant ndyac lezo' gu' mzyal gu' mbacxil'a. No ndye'th no gu' mbacxil'a, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","No co'se' zin gu' liz gu', li gu' par queltàa mèn co' ndxàc amiu gu' no mèn co' ndxàc vecin gu' liz gu'. Sya, gab gu' loo mèna: Quede gu' par tyac lezo' gu' con daa tac daa mzyalle' mbacxil' daa co' mdyuhuan. ");
INSERT INTO zamNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na nii loo gu': Lomisque' mod más tyac lezo' angl co' nzo loo bé' por cón che'n thìb mbi' co' mcua'n xtol co'se' lyàa yéc mbi' no lyàa lezo' mbi' loo Diox leque tyac lezo' angl ñèe angl thap gal nzo si'n thap mèn co' ndli cuent nac mèn mèn ndac no mèn co' ndli cuent inquinte lyàa yéc mèn no lyàa lezo' mèn loo Diox par zye' mod co' ndxàp mèn loo Diox. Thìba con' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Le' tediba na, xá ñaa thìb xa'got co' ngue no si' billet no ntac thìb thìb billeta thìb ayo pes. No mtuhuan xa'gota thìb billet co' ntac thìb ayo pes. ¿Ché' ngue li gu' cuent ne'quede xa'gota xnìi thìb brujit par cua'n xa' billeta abix ncan' no lo'f xa'gota le'n nyòo liz xa' lilleque' axta li xa' gan zyala? Zyalque' xa'i, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","No co'se' ngolo mzyal xa' billet co' mdyuhuan co' ntac thìb ayo pes, xa'got li par queltàa mèn co' ndxàc amiu xa'gota no mèn co' ndxàc vecin xa'gota. No gab xa'gota loo mèngota: Ndlyazen tyac lezo' gu' con daa tac mblin gan mzyal pes bchò co' mdyuhuana. ");
INSERT INTO zamNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na nii loo gu': Tataa tyac lezo' angl loo Diox loo bé' por cón che'n thìb mbi' co' ngòp xquin no co' ngòp xtol co'se' ngulàa yéc mbi' no ngulàa lezo' mbi' loo Diox par mzye' mod ye'rsin' co' ngòp mbi' loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús ndxab loo mèna, ne: ―Ngo thìb mbi' co' mque no chop xgan'. ");
INSERT INTO zamNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Per mbyòo co' ngòc mbyòo bluz loo hues mbyòo, mbyòoa ndxab loo xud mbyòo: Pay, fta' U' herens co' mbez U' nac chenen par càan. Sya, xud myen' mbli rol herens myen' par càa thìb thìb myen' herens myen'. ");
INSERT INTO zamNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Per pláte huiz ndxàc mcàaya' mbyòo bluza herenspe' mbyòo, mtlo mbyòo, mthop mtaa mbyòo rye con' ngòc che'n mbyòo par tho' mbyòoi. Mtho' mbyòo xyòn mbyòo, ne. Ngoloa, mxen mbyòo ned. Nda mbyòo tedib nación más tith loo làaz mbyòo. Tya, mteluxxù' mbyòo tmi mbyòo co' mque no mbyòoa. No mda' mbyòo gust lezo' mbyòo axta plóthe loo con' ye'rsin' con tmi mbyòo co' mtho' mbyòo che'n mbyòoa no co' mtho' mbyòo xyòn mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Per co'se' ngolo mblixù' mbyòo gast tmi mbyòo, ngulàa thìb huin tín' le'n naciona. Le' mbyòo na, mtlo mden' huin. ");
INSERT INTO zamNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sya, mcua'n mbyòo zin' liz mèn co' nac mèn naciona par li mbyòo zin'. Mzyalque' mbyòo zin'. Per mbi' co' mda' zin' mbli mbyòo, mbi'a mque no thìb partid nguch. Mtel' mbi' mbyòo co'te' ngòc ranch mbi' par ngua queno mbyòo nguch no ta' mbyòo con' hua nguch. ");
INSERT INTO zamNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Per prob mbyòo izlyo'. Axta mblya's mbyòo nguhua mbyòo tá' che'n yaa yis tá' co' nguaa mbyòo nguch par zyè lezo' mbyòo con tá' che'n yaa yis tá' tac patrón mbyòo anze'f tazad mda' co' ndxuhua mbyòo por huin co' ngulàa naciona. ");
INSERT INTO zamNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Axta syare' mdub xnìi yéc mbyòo no mdub xnìi lezo' mbyòo no ngulàa yéc mbyòo no ngulàa lezo' mbyòo loo con' ye'rsin' co' mbli mbyòo. Ndxab mbyòo loo lezo' mbyòo: Napló moz ngue zin' liz xuden. No nzo cón hua moz axta plóthe axta ndxan' xo'f con' ndxuhua moz. Per daa ndxath huin trè'. ");
INSERT INTO zamNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Más huen beren, ndyàan co'te' nac liz xuden. No gaben loo xuden: Pay, daa mcuan xtol daa no xquin daa loo Diox no mcuanen xtol daa no xquin daa loo U'. ");
INSERT INTO zamNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ya indliden cuent nac daa xin' U'. Más huen li U' cuent nac daa xal thìb moz U', ndyaquen. ");
INSERT INTO zamNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sya, mxen mbyòo ned. Mbere mbyòo, ndye'th mbyòo par liz xud mbyòo. Tatabe' tithre' ndye'th mbyòo, gunèe xud mbyòo mbyòo. Sya, mblyat lezo' xud mbyòo gunèe xud mbyòo mbyòo. Mque' xud mbyòo carre. Ngua càa ned xud mbyòo mbyòo. Mde's mcàa xud mbyòo mbyòo. No msero xud mbyòo ro mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Sya, ndxab mbyòo loo xud mbyòo: ―Pay, daa mcuan xtol daa no xquin daa loo Diox. No mcuanen xtol daa no xquin daa loo U'. Ya indxàalte daa gab U' le' daa nac xgan' U'. ");
INSERT INTO zamNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Per xud mbyòo ndxab loo moz: ―Jer, huàa lo' gu' xab huen mbyòo. No ftegoc gu' mbyòo xab mbyòo. No blo gu' thìb ani cuen ya' mbyòo. No fque' gu' yilid nii mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Huàa xi gu' thìb laa tor co' más nacha'. Beth gu' tora par hua na'. No li na' thìb lni loo mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tac mbyòo co' nac xgan'en ndxè' ngòc xal thìb mèn co' nguth loon. No ale ndyaquen xgan'en ndxè' ngòc xal thìb xa' co' ngro xban loon. Mdyuhuan xgan'en ndxè' loon per nalle' ngro xo'f xgan'en ndxè' loon. Sya, mtlo mèn guliz xud mbyòo. Mbli mèna lni loo mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Láth ndxàc lnia, mbyòo ndlyoa ngue zin' huan. Co'se' mzyèle' izlyo' huiza, ndye'th mbyòo ndlyo par liz mbyòo. No co'se' nde zin gax mbyòo ndlyo liz mbyòo, ndxòn mbyòo ndlyoa ndxol' musc. No ngüi' mbyòo nzi yol' nii mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Sya, ngurez mbyòo ndlyoa thìb moz co' nzo làth mèn co' nziri'a. Mnibdi's mbyòo loo moza. Ndxab mbyòo loo moz: ¿Chó lni nzo lizen, cara? ¿Cón ndxàc? ");
INSERT INTO zamNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Moza ndxab loo mbyòo: Huesl mzin, yey. No mbli xudl mandad mbeth nu' thìb tor co' más nacha' par hua no xudl huesl. Tataa mbli xudl tac huesl huenque' mzin tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Per mbyòo co' nac mbyòo ndlyoa mdèn. No ngocloo mbyòo. Ale indlya'ste mbyòo yòo mbyòo liz mbyòo. Sya, ngro xud mbyòo ned. Ngua xi xud mbyòo mbyòo par ngòo mbyòo liz mbyòo tac mbyòo ndub tèn tya. ");
INSERT INTO zamNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ndxab mbyòo loo xud mbyòo: ―Pay, U' nda'que' cuent napló zin' mblin loo U' huax lín'. No thidteneque' ndyubdizquen loo U'. Per U' ne'nglatte lezo' ngnèe U' daa par nda' U' mase thìb chiv par nglin thìb lni chu'th par hua non myen' co' ndxàc amiu daa. ");
INSERT INTO zamNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","No nalle' mzin xgan' U' ba'. No mda' xgan' U' ba' gust lezo' xgan' U' con myen'got co' ndxòo lezo' li con' ye'rsin'. No ale mbli U' mandad mbeth moz thìb laa tor co' más nacha' par mbli U' lni. ¿Ché' ndyac U' anze'f huen nac co' ngue li U' ba', cà'? Yende xàa. ");
INSERT INTO zamNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Sya, ndxab xud mbyòo loo mbyòoa: Ryete con' co' ndxàpen, le'i nac che'nl. ");
INSERT INTO zamNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Per nalle' ndxàalque' li na' thìb lni par tyac lezo' na' tac huesl co' ngòc xal mèn nguth loo na', ngòc huesl xal mèn co' ngro xban loo na' nalle'. Ngòc huesl mèn co' mdyuhuan loo na' per nalle' yub huesl mzin loo na'. Ya' ndyàa na'. Ne'yecloodel. ");
INSERT INTO zamNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ndxab Jesús loo myen' xin' mté'th Jesús: ―Myen', nde niin thìb con' loo gu': Ngo thìb mbi' ric co' mque no thìb mandador. Mzin thìb huiz ngòo ndxep mèn co' mda' cuent loo mbi' ric cón che'n mandador le' mandador indyoode altant loo rsin' che'n mbi' rica. ");
INSERT INTO zamNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Sya, ngurez mbi' ric mandador. Ndxab mbi' rica loo mandador: Ndlyazen ta'l cuent loon. ¿Xá mod nac cuent co' mda' mèn loon cón che'nl, cara? Fta' cuent loon xal nac zin' co' ngue lil. Tac lùu ya ne'tolode gàc mandador loo rsinen. ");
INSERT INTO zamNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Sya, mbli mbi' co' ngòc mandadora xtùuz. Ndxab mbi' loo lezo' mbi': Per nalle' na, ¿cón lin? Patrón daa teche zin' loon. Más de cona, yende fuerz daa par que'en zin' huiz con barret no con yi'f yaa. No chele' daa ga na'b gòn, thyon daa ña'ben gòn. ");
INSERT INTO zamNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Neequen xá ñaa co' lin par que non mèn co' ta' sa yèth huan no ta' mèna liz mèna par gòon plá huiz co'se' ne'ta'de patrón más zin' lin trè'. ");
INSERT INTO zamNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Sya, ngurez mandador thìb thìb mèn co' ndeb loo mbi' rica. Mnibdi's mandador loo ner mbi' co' ndeba. Ndxab mandador: ¿Plál ndebl loo patrón daa, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mbi' co' ndeba mcàb. Ndxab mbi' loo mandador: Daa ndeb thìb ayo barril aceit loo patrón. Sya, ndxab mandador loo mbi' co' ndeba: Ye's co' nac val lùu ndxè'. Ftub loo asient no xax xax toxcua' tedib val. No ftub loo val le' lùu ndeb cho' psi' barril aceit no maste. ");
INSERT INTO zamNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ngoloa, mnibdi's mandador loo tedib mbi' co' ndeb loo patrón mandador, ne. Ndxab mandador loo mbi'a: ¿Lùu, à'? ¿Plál ndebl loo patrón daa? Mbi' co' ndeba ndxab: Daa ndeb thìb ayo almud triu loo patrón. Sya, ndxab mandador loo mbi' co' ndeba: Ye's co' nac val lùu ndxè'. Nalle' ftoxcua' tedib val. Ftub cuent loo val co' toxcua'l ba' le' lùu ndeb thap gal almud triu no maste loo patrón daa. ");
INSERT INTO zamNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","¡Per máa mbi' ric! Lueg mden' lezo' mbi' ric no mda' mbi' rica cuent le' mandador ngòc lijerle' xal nac mod co' ndxàp mandador loo zin' co' ndyoo naa mandador. ¡Ne'yila'ste gu' con' nde niin loo gu'! Más nalas nac mèn co' alithe naban loo izlyo' ndxè' loo mod co' ndxàp mèn li mèn loo thìb xtàa mèn no loo tedib xtàa mèn leque mèn co' mblá'le' ryethe cón che'n xab izlyo' no mèn co' ndyub xnìi yéc no co' ndyub xnìi lezo' loo cón che'n Diox loo rsin' che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Por cona, ngue tan'en di's ndxè' loo gu' le' gu' co' nac xal mandador che'n Diox, nalas gure gu' loo izlyo' ndxè' loo interes co' ncàb con' ye'rsin' loo mèn par li zin' gu' che'n gu' co' ndxàp gu' par tataa mod gàc amiu gu' con huax mèn loo izlyo' ndxè'. Le' sya, lomisque' mod, gàca loo gu' co'se' gath gu' ndoo lìte ta' Diox lugar loo gu' yòo gu' loo Diox co'te' ban gu' thidtene tac altant mdoo gu' loo zin' che'n Diox xal thìb mandador ndac. ");
INSERT INTO zamNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mèn co' altant ndyoo no co' ñee rsi' ñee rso par quenap mèna co' nac che'npe' mèna con' co' ngue note mèna, mèna altantleque' tyoo no ñee rsi' ñee rso mèna par quenap mèna taamas huax con' chele' Diox li par que no mèna taamas con'. Le' mèn co' nquedìi xtàa loo ndxepte con', mèna quedìi xtàa loo huax con' chele' mèna li gan. ");
INSERT INTO zamNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Cona, ngue niin loo gu': Chele' gu' indyoode altant no iñee rsi'de gu' no iñee rsode gu' yalgon' co' nthop gu' no co' ndxàp gu' loo izlyo' ye'rsin' ndxè', ¿chó mèn gàp yalxla's loo gu' no chó mèn yila's le' gu' tyoo altant no ñee rsi' gu' no ñee rso gu' zin' ndac co' nac cón che'n Diox, à'? Yende mod gàca tataa, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","No chele' gu' indyoode altant loo con' co' nac che'n taamas mèn, ¿chó ta' con' càa gu', con' co' gàc che'npe' gu', sya? Yende mod gàca tataa, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nde niin thìb con' loo gu': Yende mod li thìb moz sirv loo chop patrón. Bien li moz cas loo thìb patrón. Le' loo tedib patrona yecloo moz ñèe moz patrona. Bien más altant tyoo moz loo thìb patrón. Le' loo tedib patrón na, tyoo xà' lezo' moz ñèe moz tedib patrona. Cona, ngue niin loo gu': Yende mod xo'f zin' mèn zin' co' nac cón che'n Diox chele' mèn más nde yath nde lux ñèe yalgon' che'n izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Per mèn xley' farise, co' más nde yath nde lux ñèe yalgon', nzi yòn di's co' ndxab Jesús. Sya, ndxáp nxyán' mèna no mxìis nxyán' mèna ñèe mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús ndxab loo mèna: ―Anze'f thìb con' ndli gu' par ndxàc gu' mèn ndac loo mèn. Per Diox non no nanee Diox xá nac con' co' ndli gu' xtùuz le'n lezo' gu'. Tac ryete con' co' ndli mèn cuent nac más con' roo con' xèn loo mèna, Diox ndxòo xyàn lezo' ñèe Diox mèn co'se' ndli mèn con'a. ");
INSERT INTO zamNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ndoore' gàc tiemp co' mbi'th Juàn Bautist, nzo'fle' ley che'n Diox co' mxo'f Moisés loo mèn no nzole' libr co' mque' mèn ye's, mèn co' mde'th di's co' ndxab Diox. Per axta tiemp co' mbi'th Juàn Bautist, mtlo mbyath mbyèn cón che'n di's ndac co' ndlu' xá mod ndlya's Diox ñibe'pe' Diox loo mèn. No ryete mèn co' mbìn di'sa nguátbèe par mbli mèn co' nzote mod li mèn par ñibe'pe' Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Más inagànte naca lyux no lith no izlyo' no bé' leque ne'gàcte con' co' nac más be'the' co' mcàbgòn Diox li Diox loo ley co' mxo'f Moisés loo mèn. Aa. Gàcpe'i. ");
INSERT INTO zamNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Niin con' ndxè' loo gu', ne: Chele' thìb xa'bi' negadi's tè'b no chobla' xa'bi' sa'l xa' no selya' xa'bi' con tedib xa'got, sya, xa'bi'a ngue li yalburrid. Le' thìb xa'bi' co' selya' con thìb xa'got co' mtè'b sa'l no co' mchobla' sa'l, xa'bi'a ngue li yalburrid, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús ndxab loo mèn: ―Nde tan cuent cón che'n co' ngòc loo thìb mbi' ric loo gu'. Mbi' rica mdoc xab mbi' co' nabe's mdyoxcua' no co' ante nít nayèe ñaa. No ryete huiz ndli mbi' lni liz mbi' axta mod co' mblya's mbi' no xal nda' gust lezo' mbi' li mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ngo thìb mbi' prob, ne. Mbi' proba ngro' lèe Lars. Mdoo thìb loo yé's ya's dib lad Lars. Ndyee tub Lars ro ryo' liz mbi' rica. ");
INSERT INTO zamNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Látha, ndyub bed Lars no ndyub quee lezo' Lars ña'b Lars pedaz yèth no nítyèth co' ndxan' xo'f loo mes co' ndxuhua mbi' rica par hua Lars par be'te' que' ni'i lezo' Lars. Láth ndub bed Larsa, nde ley mbac loo yé's ya's co' ndoo lad Lars. ");
INSERT INTO zamNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mzin thìb huiz nguth prob Lars. Per angl che'n Diox mbi'th. Mbe' angl xpii Lars no alm Lars par ngo no Lars Abraham co'te' ngo Abraham le'n parais. Mzin huiz nguth mbi' rica, ne. Ngua ca's mèn thebol mbi' rica panteón. Le' alm mbi' no xpii mbi' na, ndoo lìte ngulàa le'n ye'rbìil. ");
INSERT INTO zamNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Per láth nden' mbi' rica yaltìi no ndxec nzyo mbi' le'n ye'rbìil co'te' mbii xpii no alm mèn ye'rsin' co' ndxath, gunèe mbi' rica tith nzo no Lars Abraham. ");
INSERT INTO zamNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Sya, ngrozèe mbi' rica. Ndxab mbi' ric loo Abraham: Tad Abraham, gulat lezo' U' gunèe U' daa. Ftel' U' Lars ya tegaz Lars cuen ya' Lars con nít no yi'th tegaz Lars looz daa trè' tac anze'f nèe nac co' nden'en loo quìi no loo bèel co'te' nzon ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham ndxab loo mbi' ric co' nguth: Mbi', fte' lezo'l, lùu anze'f huen ngua le'n rye tiemp co' ngo banl lada. Per prob Lars ndxè', anze'f thìb con' ye'rsin' no con' nalyat ngòc loo prob Lars. No nalle', ale ndxe'leque', ndyac lezo' Lars co'te' nzo Lars trè'. Le' lùu na, ale ndxe'leque', nden'l ndxec nzyol loo quìi no loo bèel co'te' nzol ba'. ");
INSERT INTO zamNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Más de cona, ndri'th thìb ftee co' anze'f na's tín' trè' co' ntau' loo nu' no co' ntau' lool. No chele' lùu lya's riid co'te' nzo nu' ndxè', yende mod riidl. No chele' nu' lya's riid co'te' nzol ba', yende mod riid nu'. ");
INSERT INTO zamNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Sya, ndxab mbi' rica loo Abraham: Daa ña'b loo U', Tad Abraham, ftel' U' Lars ya Lars liz xuden ");
INSERT INTO zamNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","co'te' ngue non ga'y myen' huesen, par ta' Lars cuent loo myen' huesen par tataa mod ne'yi'thte myen' trè' co'te' anze'f ndxàc yaltìi loo mèn ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Per Abraham ndxab loo mbi' rica: Myen' ngue noque' di's co' mque' Moisés ye's co' nac ley co' mxo'f Moisés loo mèn. No ngue noque' myen' di's co' mque' mèn co' mde'th di's co' ndxab Diox ye's loo libr. Loo di'sa nzoque' mod li myen' cas chele' myen' lya's tyubdi's. ");
INSERT INTO zamNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mbi' rica mcàb loo Abraham. Ndxab mbi': Lìca xá nee U' ba', Tad Abraham. Yende cón niin loo U' cón che'n di's co' ngolo gunee U' ba'. Per más segur gàca chele' thìb mèn nguth ryo xban par ya mèn ngutha loo myen' huesen par ta' mèn ngutha cuent loo myen' huesen, ndyaquen. Sya, lyàa yéc myen' no lyàa lezo' myen' no zye' mod co' ndxàp myen' par lyá' myen' loo ryethe con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham ndxab loo mbi' rica: Chele' myen' indlide cas no indyubdi'ste myen' loo ley co' mxo'f Moisés loo mèn no loo di's co' mde'th mèn co' mde'th di's co' ndxab Diox, ne' ne' yila's myen' loo mèn co' yaa, mèn co' ryo xban làth mèn nguth. ");
INSERT INTO zamNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús ndxab loo myen' xin' mté'th Jesús: ―Thidteneque' nzoque' con' co' ndli par ncua'n mèn xtol mèn no xquin mèn. Per mandit mbi' too ze too yál', mbi' co' aseli par cua'n mèn xquin mèn no xtol mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Más huen ngàca nquedó' mèn thìb quèe yees yen mbi' ye'rsin'a. No yiloa, cobii mèn mbi'a le'n níttó' leque li mbi' ye'rsin'a le' mèn co' be' nau' loo no mèn co' be' nau' yéc ncua'n mèna xquin mèna no xtol mèna, mèn co' nac mèn co' pente mtlo ndxela's loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Anderhuen gu'. No gunee gu' xá nzi tee ban gu'. Chele' chol hues xtàa gu' cua'n xtol cón che'n gu', gunii gu' loo hues xtàa gu'a no bco'x gu' ndxep loo hues xtàa gu'a. No chele' hues xtàa gu'a lyàa yéc no lyàa lezo' loo con' mbli hues xtàa gu'a, fteri'th ftecan' gu' xtol no xquin co' mcua'n hues xtàa gu' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mastale' cua'n hues xtàa gu'a xtol no xquin hues xtàa gu'a loo gu' gaz vez thìb huiz, no chele' hues xtàa gu' yi'th loo gu' gaz vez no ñee hues xtàa gu' loo gu' gaz vez: Ya ne'bereden cuanen xtol daa lool, hues, le' sya, gu' co' ndxàc hues xtàa por cón che'n Crist, fteri'th ftecan' gu' xtol no xquin co' ndli hues xtàa gu' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Myen' xin' mté'th Jesús co' ne' tedib lèe apostl, co' nee di's, mèn co' ndxe' di's cón che'n Tad Jesús, myen'a ndxab loo Tad Jesús: ―Tad, bli U' par tolo yila's nu' no tolo gàp nu' más yalxla's loo ryethe con' cón che'n U'. ");
INSERT INTO zamNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Sya, ndxab Tad Jesús loo myen': ―Chele' gu' pente ndxela's no, lìcque', ndxela'spe' gu', nzoque' mod gab gu' loo yaa sicomr ndxè': Na nii lool, yaa sicomr, yi'fl trè'. No leque lùu ya ro níttó' par tyool ro níttó'. Na nii loo gu' le' yaa sicomr ndxè' gòn ro gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nde niin thìb con' loo gu': Chele' chó gu' ngue no thìb moz, no ndye'th moz ngua moz zin' huan, bien ngua gan' moz ngon, o bien ngua queno moz ngon, ¿ché' tab gu' loo moz co'se' ndye'th moz ngua moz zin': Moz, quede. Ftub loo mes par bequen con' hua rsèl, ndee? ");
INSERT INTO zamNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yende xàa. Ndxe'leque', gu' gab loo moz: Jer toxcua' con' hua rsè'en no altant ftoo par lil mandad loon láth ngue yuhuan no láth ngue yun. Sya, co'se' ngolo nduhuan no co'se' ngolo ngun, sau' tyubl hual. ");
INSERT INTO zamNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Ché' ndyac gu' le' patrón gab loo moz: Diox quixl, moz, tac mtoxcua'l con' nduhua rsè'en, ndee? ¡Jaa! Pà gab patrón tataa loo moz, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Cona, ngue niin loo gu', ne: Co'se' yilo li gu' ryete con' co' mnibe' Diox loo gu' par li gu'i, ndxàal gab gu' loo Diox: Nu' nac moz co' yende cón ntac no co' yende chó juis tac mbli nu' ante con' co' mnibe'te U' loo nu' par li nu'i. ");
INSERT INTO zamNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Co'se' tolo mdoo Jesús ned, nda Jesús par ned ciuda Jerusalén, ngua riid Jesús rye yèezya' che'n làaz mèn samari no che'n làaz mèn galile. ");
INSERT INTO zamNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Texal ngòo Jesús ro thìb yèez, ngua sál' si' xa'bi' co' ndyac yíiz ndxa's, yíiz co' nteya's no co' nteyèe yid lad mèn, loo Jesús. Tith ngure prob mèna loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Cabii ngrozèe mèna loo Jesús. Ndxab mèna loo Jesús: ―Jesús, U' co' nac maistr, gulat lezo' U' gunèe U' nu', yey. ");
INSERT INTO zamNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Co'se' gunèe Jesús mèna, ndxab Jesús loo mèna: ―Huàa gu'. Huàa lu' gu' gu' loo nguley'. Sya láth ndoo mèna ned nda mèna, mbembìi lad mèna xalque' thìb mèn huen. ");
INSERT INTO zamNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sya, thìb mbi' co' ndxòo cuent si' mèn co' mbyaca, co'se' gunèe mbi' mbyac mbi', mbere mbi', ndye'th mbi' loo Jesús. Cabii mbez mbi' di's natu' loo Diox. Ndxab mbi': ―¡Ay, Dio's! Con' roo con' xèn mbli U' loon. Tac mteyac Jesús mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mdub xib mbi' loo Jesús. No xex xex mcotloo mbi' xàn' nii Jesús. Ndxab mbi' loo Jesús: ―Diox quix U', Tad. No ngòc mbi'a mèn gulàaz mèn samaritan. ");
INSERT INTO zamNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Sya, ndxab Jesús loo mèn co' nziri' loo Jesús: ―¿Ché' iryede si' mèna mbyac, cà'? ¿Máa taayè' mèna? ");
INSERT INTO zamNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ché' angoluxte mbi' co' nac mèn tith ndxè' mbere ndye'th loon par ndxab mbi': Diox quix U', Diox, loo Diox, cà'? ¿Xá nee gu'? ¿Ché' huen nac co' mbli mèna, cà'? Yende xàa. ");
INSERT INTO zamNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesús ndxab loo mbi'a: ―Goo too, ndee. Fxen ned. Byàa. Lùu mbyacle' tac ngola'sque'l loon. ");
INSERT INTO zamNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Leque sya, mèn xley' farise mnibdi's loo Jesús. Ndxab mèna loo Jesús: ―¿Pólxe gàc tiemp co'se' tlo ñibe'pe' Diox loo mèn, à'? Jesús mcàb loo mèna. Ndxab Jesús: ―Co'se' tlo ñibe'pe' Diox loo mèn, ne'yú'da loo mèn xal co'se' ñibe'pe' chol rey loo mèn loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ne'gabte mèn loo xtàa mèn: Trè' nac co'te' ñibe'pe' Diox loo mèn. O tua' nac co'te' ñibe'pe' Diox loo mèn. Aa. Diox ngue ñibe'pe' loo mèn co' ndyubdi'sque' loo Diox làth gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sya, ndxab Jesús loo myen' xin' mté'th Jesús: ―Zin thìb huiz no zin thìb ze co' lya's gu' hui' gu' mase thìb huiz láth co'se' ngue ñibe'pe'en loo izlyo' ndxè', daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn. Per ndxe'leque', ya inabante gu' axta co'se' zin huiza. ");
INSERT INTO zamNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","No zin thìb huiz no zin thìb ze co'se' ñee mèn co' nac mèn gutyè'a loo gu': Mzinle' Jesús loo izlyo' tedib vez. Trè' nzo Jesús. O ñee mèn gutyè'a loo gu': Tua' nzo Jesús. Per na ngue nii loo gu': Ne'yila'ste gu' ro mèna. Ne' ne' ta' gu' lugar tyoo nque gu' xís mèna co'se' zin huiza. ");
INSERT INTO zamNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tac texal co'se' ndlyàa bèel gundii loo izlyo', chàa, ndxà'x xnìi bèel gundii thìb lad ro izlyo' axta tedib lad ro izlyo'. Tataa gàca loo mèn co' nziri' dib athu loo izlyo' co'se' gàc huiz co' galen loo izlyo' tedib vez, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn. Huiza rye mèn co' nziri' dib athu loo izlyo' nonque' cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Per ndoore' zin huiza naquinque' ner gàc huax yaltìi loon. Le' mèna tè'b daa thìb lad. No chobla' mèn daa, mèn co' nzi ban le'n tiemp ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Xalque' ngòca le'n huiz co' mque tee ban Noé, tataa gàca le'n huiz co' gàc huiz co' galen loo izlyo' tedib vez, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tiemp co'se' ngo ban Noé loo izlyo', alithe ngure yuhua mèn. No alithe ngure yu mèn. No alithe mbli mèn di's nselya' xin' mèn. Ndyee na'b mèn xìix mèn. Nda' mèn xgan' mèn nda buuz axta co'se' mzin huizpe' co'se' ngòo Noé con rye famil Noé le'n yòoyaa. Le' Diox na, mbli ngulàa thìb yuu axta ngòc lal nít loo rye yii par tataa mod nguth rye mèn co' ne'ngala'ste loo di's co' ndxab Noé. Ale nguth mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ndxab Tad Jesús, ne: Tataa ngòca le'n huiz co'se' ngo ban thìb mbi' co' ngro' lèe Lot, ne. Alithe ngure yuhua mèn. No alithe ngure yu mèn. Alithe ngure ndi' mèn. No alithe ngure ntho' mèn. Alithe ngo mèna bin. No alithe mtoxcua' mèna liz mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Per leque huiz co'se' mxon' mbi' co' ngro' lèe Lot con famil mbi', ngro' mbi' le'n ciuda Sodom. Ngoloa, mbli Diox, chàa, ngulàa quìi no bèel no asufr loo bé' loo mèn ciudaa xal co'se' ndlyàa yuuxò'. No mbeth quìi no bèel ryete mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tataa gàca, ne, co'se' gàc huiz co'se', chàa, galen no yú' daa loo mèn, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Huiza, chele' chó mèn ngue tee loo zote yéc yòo, no ngue no mèna che'n mèn co' nzosua' le'n nyòo, más huen ne'lyàade mèna loo yòo par co' mèna che'n mèna le'n nyòo. No chele' chó mèn ngue zin' huan, más huen ne'berede mèna par liz mèna tac ya ne'zin'te bere mèna liz mèna huiza. ");
INSERT INTO zamNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Fte' lezo' gu' con' co' ngòc loo xa'got che'n mbi' co' ngro' lèe Lot par ten' gu' di's co' ngue niin loo gu' no li gu' cas loo con' ngue niin loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mèn co' alithe nque tee ban loo izlyo' par que no mèna ante con' co' ndryo' ndlyen' lezo' mèna, loo mèna ne'gàcte con' ndac co' nac cón che'n yalnaban par ban no mèna Diox thidtene yiloa. Per mèn co' too lezo' tuhuan mèn ryethe con' ndryo' ndlyen' lezo' mèn cón che'n mèn loo izlyo' ndxè' ante por cón chenen, mèna ban noque' xuden Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ndxab Jesús loo mèna, ne: Ngue niin loo gu': Leque hor co' galen, que naca ze, que naca yál', chop mèn nzi yàt loo thìb lun'. Hora daa li, chàa, yáp thìb xa' par ya sál' xa' daa loo bé'. Le' tedib xa' na, taate yan'. ");
INSERT INTO zamNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Leque hora, ne, gàca chop xa'got thidte ngue yu'. Thìb xa'gota, chàa, lin par yáp xa'gota loo bé' par ya sál' xa' daa. Le' tedib xa'gota na, taate yan'. ");
INSERT INTO zamNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Lomisque' ne, leque hora, gàca chop xa'bi' ngue zin' huan. Thìb xa', chàa, lin par ya sál' xa' daa loo bé'. Le' tedib xa'bi'a na, taate yan'. ");
INSERT INTO zamNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Co'se' mbìn mèna tataa ndxab Jesús, mnibdi's mèna loo Jesús. Ndxab mèna: ―¿Pá gàc con'a, Tad? Jesús mcàb. Mtetac Jesús thìb di's loo mèna. Ndxab Jesús: ―Pues, gu' nda' cuent co'te' nax nde'f thìb má' ya's, anze'f thìb ngool ndlyàa loo má' ya's tya, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús mtetac tedib di's loo mèna, ne, par mblu' Jesús loo mèn xá mod ndxàalque' thidteneque' cuez mèn Diox no par ne'yitacte lezo' mèn cuez mèn Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ndxab Jesús: ―Nde niin thìb con' loo gu': Ngo thìb mbi' co' ngòc juez le'n thìb ciuda. Mbi'a ne'ngzebte ngnèe Diox ne' ne' indyóo mbi' ngnèe mbi' chol mèn. Ne' ne' yen chó mport nzo lezo' mbi' ñèe mbi' chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Leque le'n ciudaa ngo ban thìb xa'got viud. Xa'got viuda seguid nda li xol mbi' co' ngòc jueza par li mbi' justis no tub rez mbi' cón che'n thìb yalgyoo co' mbyoo xa'got viuda con mèn co' ngòc ngolo ngola's che'n xa'got viuda. ");
INSERT INTO zamNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nguri'th huax huiz no nguri'th huax mbe', mbi' co' ngòc jueza ne'nglide cas xa'gota. Per ngoloa, mbli mbi' xtùuz cón che'n xa'got viud co' mbli xol mbi' co' ngòc jueza. Sya, ndxab mbi' loo lezo' mbi': Neequen cón lin teeca. Daa inzyebte ñèen Diox ne' ne' yen chó mport nzo lezon ñèen nec thìb con'. ");
INSERT INTO zamNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Per mastale', guneei xá go teei, na nda li justis cón che'n xa'got viuda par ya ne'tolode yi'th ta' xa' xyàn lezon trè'. Tac ya ngo dible' lezon ñèen xa'got viuda. No ya ne'tolode xec daa ñèen xa'gota. ");
INSERT INTO zamNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tad Jesús ndxab loo mèna, ne: ―Bìn gu' di's co' ngòc di's co' gunii mbi' co' ngòc juez ye'rsin'a. ");
INSERT INTO zamNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Cona, ngue niin di's ndxè' loo gu': ¿Ché' ngue li gu' cuent le' Diox ne'tí'de no ne'làade Diox mèn, mèn co' Diox mcui, mèn co' mbez Diox ze no yál', cà'? ¿Ché' ndli gu' cuent ndlyen' Diox par lyath no Diox mèna, cà'? Yende xàa. ");
INSERT INTO zamNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Daa nii loo gu' le' Diox setilte lyath no mèna. No nibdizen thìb con' loo gu': ¿Xá nee gu'? Co'se' galen loo izlyo' tedib vez, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, ¿ché' ndyac gu' nzoque' mèn loo izlyo' co' be' nzi yila's loon huiza, cà'? Chele' gu', lìcque', tolo yila's loon no tolo gàp gu' yalxla's loon thidtene, le'i gàcque' le' mèn be' ndxela's loon co'se' galen loo izlyo' tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús mtetac tedib di's loo mèna cón che'n mèn co' nzo làth mèna, mèn co' ndyac nac mèna anze'f mèn ndac. No leque mèna indlide cas xtàa mèna. Ndxab Jesús: ");
INSERT INTO zamNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Nde niin thìb con' loo gu': Ngua chop xa'bi' le'n templ par cuez xa' Diox. Thìb xa' nac xa' che'n xley' farise. Le' tedib xa' na, nac xa' co' ndli cobrar cón che'n contribución. ");
INSERT INTO zamNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mbi' co' nac mbi' xley' farise mdoo. No ngurez mbi' Diox taandxè'. Ndxab mbi': Tad Diox, na nii loo U', Diox quix U' tac inacte daa xal taamas mèn; mèn co' ndli huan'; mèn ye'rsin'; no mèn co' ndli yalburrid. Ne' ne' inac daa xal mbi' ba', mbi' co' ndli cobrar cón che'n contribución. ");
INSERT INTO zamNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Chop vez ndlin ndxàc yalxlat loon le'n thìb sman. No ndan centav co' nac diezm cón che'n rye yalgon' co' ndxàpen no cón che'n zin' co' ndlin. ");
INSERT INTO zamNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Per ndxe'leque', prob mbi' co' ndli cobrar cón che'n contribución, tith mdoo mbi'. Ne'ngòode valor loo mbi' mase ngüi' mbi' loo bé'. Ndxe'leque', mbez mbi': ―¡Ay, Dio's! No taa nguin mbi' ya' mbi' pech mbi'. No tolo mbez mbi': Gulat lezo' U' gunèe U' daa, Tad. Daa nac thìb mbi' co' ndxàp xtol no co' ndxàp xquin. ");
INSERT INTO zamNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mbere Jesús, ndxab Jesús loo mèna: ―Na nii loo gu' le' Diox mton' xtol no xquin mbi' co' ndli cobrar cón che'n contribución. No ngòo lezo' Diox mod co' ngòp mbi'. Ngoloa, ndyàa mbi' par liz mbi'. Per ndxe'leque', Diox ne'ndon'te xtol mbi' no xquin mbi' co' nac mbi' xley' farise. Tac chol mèn co' ndye's, loo mèna Diox li gàc mèna mèn be'the. Le' loo mèn co' nac mèn nado' na, loo mèna Diox li gàc con' guryath no con' guryèn loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Le'n huiza, mbi'th no mèn myen' bix loo Jesús par que's càa Jesús myen' bixa. Per co'se' ñèe myen' xin' mté'th Jesús con' co' ndxàc, mbyoo myen' xin' mté'th Jesús mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesús ngurez myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Bla' gu' tetee myen' bix ba' loon con xna' myen'. Ne'tau'te gu' loo myen' no loo mèn co' nde no myen' loon. Tac mèn co' ndyal par ñibe'pe' Diox loo mèn, mèna ndxàp mod no nac mèna xal myen' bix ba'. ");
INSERT INTO zamNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Lìcpe' ba'i, na nii loo gu': Mèn co' ne'tyalte gàp mod xal thìb myen' bix ndxè' par ñibe'pe' Diox loo mèn loo cón che'n Diox, mèna yende mod yòo loo cón che'n Diox par ñibe'pe' Diox loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Làth mèn co' nziri' ngo thìb mbi' co' ngòc jef co' ndyoo ner, no co' ndyoo naa, no co' ñibe' loo mèn nación Israel. Mnibdi's mbi' loo Jesús. Ndxab mbi': ―Maistr Ndac, ¿cón ndxàal lin par gàpen yalnaban thidtene, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús ndxab loo mbi': ―¿Chonon mbezl Maistr Ndac nac daa, à'? Yende chó mèn nac xa' ndac. Ante thìb xa' co' nac Diox nac xa' ndac. Chele' lùu indlide cuent no inden'te lùu le'n lezo lùu nac daa Diox, ne' ne' ñeel loon Maistr Ndac. ");
INSERT INTO zamNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Lùu ndxác di's co' ndlu' loo mèn cón ndxàal li mèn, ¿lé'?, di's co' ndxab: Ne'lide gu' yalburrid; ne'guthte gu' xtàa gu'; ne'li huan'te gu'; ne'tyè'de gu' loo nec thìb mèn; gòp gu' mod loo xud gu' no loo xna' gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mbi' ndxab loo Jesús: ―Ryete con'a ndyubdizquen no ndliquena axta co'se' ngòc daa myen' bix no axta mtlon mdoo xènen. ");
INSERT INTO zamNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Co'se' mbìn Jesús tataa ndxab mbi' loo Jesús, ndxab Jesús loo mbi': ―Tatabe' ndxàc falt lil thìb con', cara. Huàa tho' rye con' ndxàpl par ryo' tmi loo con' ndxàpla. Sya, qui'thl tmia par càa mèn prob co' nquin tmi. Tataa mod gàpl más yalgon' loo bé'. Yiloa, yi'thl, tyoo nquel xísen. Nda na', ndee. ");
INSERT INTO zamNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Co'se' mbìn mbi' tataa ndxab Jesús loo mbi', anze'f mxi lezo' mbi' tac mbi' ngòc thìb mbi' co' anze'f ngòp che'n. ");
INSERT INTO zamNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Per co'se' ñèe Jesús nalyat nde'f ro mbi', Jesús ndxab loo taamas mèn co' nziri' loo Jesús: ―Anze'f nagàn naca par yòo thìb mèn ric loo cón che'n Diox par ñibe'pe' Diox loo mèn ric. ");
INSERT INTO zamNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Más inagànte naca riid thìb má' co' lèe camell le'n ye'r co' nac ngudloo thìb aguj leque yòo mèn ric loo cón che'n Diox par ñibe'pe' Diox loo mèn ric. ");
INSERT INTO zamNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Co'se' mbìn mèn co' nziri' di'sa, ndxab mèna loo xtàa mèna: ―Chele'i tataa nac, ¿chó mèn gác lyá' loo con' ryes, sya? ");
INSERT INTO zamNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús ndxab loo mèn co' nzi yòn di'sa: ―Con' co' ne'gácte li mèn, Diox ndxácque' li Diox con'a. ");
INSERT INTO zamNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedr ndxab loo Jesús: ―Tad, nu' mblá'ya' ryete con' co' ngòp nu' par ndoo nque nu' xís U'. ");
INSERT INTO zamNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Sya, mcàb Jesús. Ndxab Jesús loo myen' xin' mté'th Jesús: ―Lìcpe' ba'i, le' chol mèn co' lá'ya' liz; no co' lá'ya' xud; no co' lá'ya' hues; no co' lá'ya' sa'l; no co' lá'ya' xin' par tyal mèna yòo mèna loo cón che'n Diox par ñibe'pe' Diox loo mèna loo cón che'n Diox, ");
INSERT INTO zamNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Diox li par gàp mèna masre' con' ndac loo izlyo' ndxè'. No más de cona, gàp mèna yalnaban thidtene co'se' cue tedib cua' izlyo' le'n tiemp co' nde nque. ");
INSERT INTO zamNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ngoloa, xà' ngurez Jesús ryete si' fchop myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Nase nda na' ciuda Jerusalén, cara, co'te' tyaa ryete con' xal ndub di's loo libr co' mque' mèn co' mde'th di's co' ndxab Diox ye's cón chenen, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Lìca, mèn ta'xù' daa loo mèn co' nac mèn tith. No xìis no mèna daa. No yáp xyán' mèna ñèe mèn daa. No aseli mèna ta' mèna xyàn lezon. No ale suc mèna rloon. ");
INSERT INTO zamNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ta' mèna chenen. No yiloa, guth mèna daa. No co'se' yilo son huiz mbeth mèna daa, daa ryo xban làth mèn nguth. ");
INSERT INTO zamNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Per myen' xin' mté'th Jesús ne'nda'de cuent cón nee di's co' ndxab Jesús. Axta ne' ne' ñee myen' no axta ne' ne' nden' myen' cón ndxab Jesús loo myen'. Di'sa ngòc di's co' ne'gácte myen' nda' myen' cuent. ");
INSERT INTO zamNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Co'se' yamerle' yòo Jesús ro ciuda Jericó, gunèe Jesús ndub thìb mbi' sieu ro ned. Ndub na'b mbi' sieu gòn loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Co'se' ndub yòn prob mbi' sieua ndoo riid mèn ned, mnibdi's mbi' loo mèn. Ndxab mbi': ―¿Cón ndxàc? ¡Susque' thìb mèn ndoo riid! ");
INSERT INTO zamNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mèna ndxab loo mbi' sieua: ―Jesús che'n yèez Nazaret nde riid par nedrè'. ");
INSERT INTO zamNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Sya, cabii ngurez mbi' Jesús. Ndxab mbi': ―¡Jesús, U' co' nde bin che'n David co' ngòc rey póla, gulat lezo' U' gunèe U' daa, yey! ");
INSERT INTO zamNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Per mèn co' nda ner delant loo Jesús, mèna mbyoo mbi' sieua par cued, ya ne'tolode li mbi' ruid. Per ale ndxe'leque', sate más cabii mbez mbi' Jesús. Ndxab mbi': ―¡Jesús, co' nde bin che'n David, gulat lezo' U' gunèe U' daa, yey! ");
INSERT INTO zamNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Sya, nguled Jesús ned. Mnibe' Jesús loo mèn ya xi mèn mbi' sieua. Co'se' mzin gax mbi' loo Jesús, mnibdi's Jesús loo mbi'. Ndxab Jesús loo mbi': ");
INSERT INTO zamNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Cón ndlya'sl li nonl, à', ey? Mbi' sieua ndxab loo Jesús: ―Tad, ndlyazen ftub U' xnìi ngudloon par hui'en, yey. ");
INSERT INTO zamNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ante ndxab Jesús loo mbi' sieua: ―Ngudlool ngo nìile'. Mdublen xnìi ngudlool tac lùu ngola'sque' loon. ");
INSERT INTO zamNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Leque hora, mbi' sieua mbui'. No mdoo nque mbi' xís Jesús. Nda no mbi' Jesús. No mbez mbi': ―¡Ay, Dio's! Con' roo con' xèn mbli U' loon. Lomisque', ryete mèn co' gunèe ngòc con'a loo mbi', mbez mèna: ―¡Ay, Dio's! Con' roo con' xèn mbli U' loo mbi' ba'. ");
INSERT INTO zamNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Láth ndoo Jesús ned con taamas mèn, nda Jesús par ciuda Jerusalén. Thìb lì nguri'th Jesús le'n ciuda Jericó. Co'se' yamerle' riid Jesús tedib lad ro ciuda Jericó, ");
INSERT INTO zamNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","tya ngro' thìb mbi' ric co' ngro' lèe Zaque par ngua sál' mbi' Jesús. Le'xque' le'n tiempa ngòc mbi' jef loo mèn co' ndli cobrar cón che'n contribución. ");
INSERT INTO zamNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Anze'f mblya's Zaque hui' Zaque loo Jesús par libe' Zaque Jesús. Per yende mod bii gax Zaque loo Jesús par hui' Zaque loo Jesús. Nde nxon', anze'f chu'th Zaque. Nde nxon', anze'f thìb mèn mtau' loo Jesús, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sya, mque' Zaque carre. Mner Zaque loo mèn. Ngua quée Zaque loo thìb yaa co' lèe yaa sicomr par gác hui' Zaque loo Jesús láth nde riid Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Co'se' nda riid Jesús xàn' yaa co'te' mquée Zaque loo yaa, Jesús mbui' ndub Zaque loo yaa. Ndxab Jesús loo Zaque: ―Zaque, jer bilàa loo yaa ba' tac nalze ta'l posad loon par yan' daa lizl, ey. ");
INSERT INTO zamNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sya, yende izlyo', mbilàa Zaque loo yaa sicomr. No axta gust mbyan' lezo' Zaque mbe' Zaque Jesús liz Zaque. ");
INSERT INTO zamNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Co'se' gunèe rye mèna ngòo Jesús liz Zaque, ryete mèn co' nde no Jesús, xexte mbez mèna loo xtàa mèn co'te' nziri' mèn: ―Hui' gu' nexa xal ngòo Jesús liz mbi' co' ndxàp xtol ba' par yan' Jesús liz mbi'. Nazab nac con' ngue li Jesús, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sya, xi'tha mdoo Zaque, nague's ya' Zaque loo Jesús. Ndxab Zaque loo Jesús: ―Hui' U' nexa, Tad. Na ta rol yalgon' co' ngue non loo mèn co' ndyac yaltìi no loo mèn prob. No chele' daa mbli huan' tmi loo ndxep mèn por yalgutyè' co' mtoxcuan, chele' mèna ñeei loon, seren thap tant co' mblin gan loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús ndxab loo Zaque: ―Nalze mzin huiz lyá'l con rye xin'l loo con' ryes. Ngoloa, ndxab Jesús loo rye mèn co' ngure no Jesús: Taandxè' ndxaben loo Zaque tac Zaque, ne, nac bin che'n Abraham co' mbloj msi' bin co' ngòc mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tolo ndxab Jesús loo mèna: ―Daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, daa ndal cuanque' mèn co' ndxàp xtol no mèn co' ndxàp xquin, no par telá'en mèn co' nzi tee huan loo xquin mèn no loo xtol mèn loo Diox loo con' ryes par yòo mèn loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ngoloa, láth nda no Jesús mèna par ned ciuda Jerusalén, Jesús mtetac thìb di's loo mèn co' nzi yòn di's co' ndyoodi's Jesús. Co'se' nde zin' gaxle' Jesús ciuda Jerusalén, mèna mbli xtùuz le' tiemp co' tlo ñibe'pe' Diox loo mèn mzinle' leque hora. ");
INSERT INTO zamNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Sya, ndxab Jesús loo mèna: ―Nde niin thìb con' loo gu': Ngo thìb mbi' co' ngòc bin che'n thìb famil ndac co' ngòc mèn roo no mèn xèn. Mbi'a ngro' tee. Nda mbi' tedib nación co' nziri' tith par li mèn naciona le' mbi' gàc rey loo mèn làazpe' mbi'. No yiloa bere mbi', ye'th mbi' tedib vez par làaz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ndoore' ryo' mbi' par ya mbi' le'n tedib naciona, ngurez mbi' si' moz mbi'. Mda' mbi' gal bga'y mil pes loo thìb thìb moz. No ndxab mbi' loo thìb thìb moz: Aa. Bli zin' loo tmi ndxè' axta co'se' galen ñeene' máai. ¿Ché' ngue lii gan xin'a ó ché' ingue lida gan xin'a? ");
INSERT INTO zamNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Per mèn co' nac mèn gulàaz mbi' anze'f ngòo xyàn lezo' gunèe mèna mbi'. Mtel' mèn gulàaz mbi' mèn co' nda nque xís mbi' par gab mèna loo mèn nación co'te' nda mbi': Le' nu' indlya'ste gàc mbi' ba' rey par ñibe' mbi' ba' loo nu'. ");
INSERT INTO zamNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Per te' ñeel tataa mbli mèn gulàaz mbi', ngòcque' mbi' rey. No mbereque' mbi', ndye'th mbi' par làaz mbi'. Co'se' mzin mbi' làaz mbi', mtel' mbi' mandad, ngua càa moz co' mtan' no mbi' tmia par ñee mbi' pló xin' tmi nde teele' ndli thìb thìb moz gan. ");
INSERT INTO zamNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mbi'th ner moz loo mbi' co' ngòc reya. Ndxab moz loo mbi' co' ngòc rey: Tad, tmi U' co' mtan' U' loona, le'i mbli gan taasi' tant tmi loo tmi co' mtan' U' loon. ");
INSERT INTO zamNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mbi' co' ngòc reya mcàb loo moz: ¡Huen zyax! Lùu nac thìb moz ndac. Lùu altantque' mdoo no gunee rsi'que'l no gunee resoque'l loo ndxepte con' ngòpl. Cona, daa li le' lùu gàc gobernador loo si' yèez. ");
INSERT INTO zamNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ngoloa, ndye'th tedib moz loo mbi' co' ngòc reya. Ndxab moz loo mbi': Tad, tmi U' co' mtan' U' loona, le'i mbli gan taaga'y tant tmi loo tmi co' mtan' U' loon. ");
INSERT INTO zamNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mbi' co' ngòc reya mcàb loo moz. Ndxab mbi': Lùu, ne, gàc gobernador loo ga'y ciuda. ");
INSERT INTO zamNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ngua tedib moz loo mbi' co' ngòc reya. Ndxab moz loo mbi' co' ngòc reya: Tad, tmi U' co' mtan' no U' daaa, le'i ndxè'. Na mblosua'i loo thìb panid. ");
INSERT INTO zamNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tac daa nzyeb ñèen U' tac U' nac thìb mbi' co' anze'f nanguib. No anze'f nde yath U'. Más de cona, ale nthop U' cosech co'te' ne'nglide U' zin'. No nthop U' cosech co'te' ne'ngode U' bin. ");
INSERT INTO zamNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Sya, ndxab mbi' co' ngòc reya loo moz: ¡Aa moz zab! ¡Moz ye'rsin'! Co'se' tubl razon cón che'nl, con leque di's co' ndyoodi'spe'l ba' quexù'enl. Chele' lùu nanee le' daa, lìcque', nac thìb mbi' nanguib no thìb mbi' co' nde yath, no chele' lùu non le' daa nac thìb mbi' co' nthop cosech co'te' indliden zin' no nac daa mbi' co' nthop cosech co'te' ingoden bin, ");
INSERT INTO zamNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","chele' lùu ñee tataa nac daa no tataa ndlin, ¿chonon ne'nga lodel tmi daa loo banc, le' sya, par co'se' ngyalen par lizen ya ri'then no nga lo'en tmi daa loo banc con tod xin'a co' ngue lii gan? Per moza yende cón ngab. ");
INSERT INTO zamNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Sya, ndxab mbi' co' ngòc reya loo mèn co' ngureri'a: Fteche gu' tmi loo mbi' ba'. No fta' gu' tmi ba' loo mbi' co' mbli gan taasi' tant tmi. ");
INSERT INTO zamNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mèna ndxab loo mbi' co' ngòc reya: Tad, per mbi' ba' ngue nole' si' tant tmi. ¿Cópe' li no mbi' tant tmi, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mbi' co' ngòc reya ndxab: Na nii loo gu' le' mèn co' ndxàp con' no nalas mèn, mèna gàpre' mas. Per mèn co' indxàpta, loo mèna biiche rye con' ndxàp mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Le' cón che'n rye mèn co' nac ngolo ngola's chenen, mèn co' ne'ndalte gàc daa rey par ñibe'pe'en loo mèna, huàa xi gu' mèna, yi'th mèna ndxè'. Beth gu' mèna loon. ");
INSERT INTO zamNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ngolo mdoodi's no Jesús mèna, mbere Jesús, mxen Jesús ned. Nda Jesús con taamas mèn par ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Co'se' yamerle' zin no Jesús mèna yèez Betfagé no yèez Betani gaxte co'te' ndub thìb yii co' ngro' lèe yii che'n yaa oliv, mtel' Jesús chop myen' xin' mté'th Jesús par ngua myen' le'n yèeza. ");
INSERT INTO zamNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ndxab Jesús loo myen' xin' mté'th Jesús: ―Huàa gu' le'n yèez ba'. Texal zin gu' ro yèez ba' ñèe gu' thìb burr co' ndoo quedó' ro yèez ba'. Yende chó mèn tar tyub burra. Fxac gu' burra no ye'th no gu' burra trè'. ");
INSERT INTO zamNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","No chele' chó mèn ñibdi's loo gu', ñee mèn loo gu': ¿Chonon ngue xac gu' burr? guuz gu' loo mèna: Tad Jesús naquin burr. ");
INSERT INTO zamNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Sya, mxen myen' xin' mté'th Jesús ned, nda myen'. Co'se' nde zin gax myen' ro yèeza, gunèe myen' ndoo burr xalque' ndxab Jesús loo myen'. ");
INSERT INTO zamNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sya, ngua xac myen' burr. Per co'se' gunèe mbi' co' ngòc xuan' burra ngue xac myen' burr, mbi'th nibdi's mbi' loo myen'. Ndxab mbi' loo myen': ―¿Chonon ngue xac gu' burr daa ba', à'? ");
INSERT INTO zamNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Myen' xin' mté'th Jesús mcàb loo mbi' co' ngòc xuan' burr. Ndxab myen' loo mbi': ―Nu' ngue xac burr tac Tad Jesús naquin burr. Sya, mblá' mbi' burr ndye'th no myen' burr. ");
INSERT INTO zamNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Sya, mbe' myen' burr loo Jesús. No par ne'tyubte Jesús burr taate burr, mxo'f myen' xab myen' xís burr. Ngoloa, mquée Jesús burr. Mdub Jesús burr. ");
INSERT INTO zamNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","No texal nda tee Jesús ned, tataa nda sil myen' xin' mté'th Jesús xab myen' ned nda Jesús par riid Jesús loo xab myen' tant ndyac lezo' myen' ñèe myen' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Co'se' nda zin gax Jesús con mèn co' ndxela's loo Jesús con myen' xin' mté'th Jesús loo yii co' ngro' lèe yii che'n yaa oliv, mèn co' ndxela'sa mtlo, mbez yèe mèna de gust. Mbez mèna: Diox roo Diox xèn nac Diox, por gunèe mèna rye yalguzye' no con' roo con' xèn co' mbli Jesús loo chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mbez mèna, ne: ―Anze'f ndyac lezo' rey no huen nzo lezo' rey, rey co' nde por lèe Tad Diox, rey co' mtel' Tad Diox loo na'. Por cón che'n rey ba' mbyu' mbyàlle' lezo' Tad Diox no ngo nagàlle' lezo' Tad Diox gunèe Tad Diox mèn. Por cona, ndxàc con' roo no con' xèn loo Diox co' nac thidte Diox por cón che'n rey ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Láth mbez mèna tataa, ndxep mèn xley' farise co' nzo làth mèna ndxab loo Jesús: ―Maistr, byoo ndxep mèn co' ndxela's lool ba' par ne'gabte mèna arid di's ba'. ");
INSERT INTO zamNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesús mcàb loo mèna. Ndxab Jesús loo mèna: ―Na nii loo gu': Chele' mèn ba' yau' ro, quèe co' nziri' ned ndan ndxè' cozèe no ñee quèe leque di's ba'. ");
INSERT INTO zamNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Co'se' mzin gax Jesús ro ciuda Jerusalén no gunèe Jesús ciuda Jerusalén, mbín' Jesús gunèe Jesús ciuda Jerusalén por cón che'n mèn ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Cabii ndxab Jesús loo mbii loo mèn ciuda Jerusalén: ―Huen ngàca loo gu', mèn ciuda Jerusalén, oj ché' co' ta' gu' cuent mase le'n lult huiz co' nac huiz nalze, co' nac con' ndac co' ndlya's Diox li Diox anggàc loo gu'. Per nalle', ndxe'leque', yende mod gàc con' ndac loo gu'. Nac con' ndaca xal thìb con' co' ngo casloo loo gu' nalle'. No yende mod ta' gu' cuent no non gu' cón che'n con'a nalle'. ");
INSERT INTO zamNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Per zin thìb huiz no zin thìb ze co'se' gàc con' ye'rsin' loo gu'. Le' mèn co' nac ngolo ngola's che'n gu'a na, mèna toxcua' thìb ftoo dib vuelt ro ciuda gu' rye lad xal co'se' ngo mèn thìb yaaloo quèe dib vuelt xís yòo liz mèn par tataa mod yende mod ryo' gu' par tataa mod cua'n mèna xó' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tùub mèn co' nac ngolo ngola's gu' ciuda gu'. Guth mèna rye gu' co' naban ciuda gu'. No ne'tan'te mèna nec thìb quèe loo xtàa quèe loo ftoo ciuda gu'. Tataa gàca loo gu' tac gu' ne'nda'de cuent cón che'n tiemp co' mbi'th que tee Diox làth gu' no mbi'th too naa Diox gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ngolo ndxab Jesús di'sa, tolo nda Jesús axta mzin Jesús co'te' mdub templ tiempa. Sya, ngòo Jesús le'n templ. Mtlo Jesús, mblo' Jesús mèn par fuer, mèn co' ntho' no mèn co' ndi' le'n templ. ");
INSERT INTO zamNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ndxab Jesús loo mèna: ―¡Aa mèn izlyo'! Loo libr co' nac xti's Diox ndub di's co' mbez: Lizen nac co'te' cuez mèn lèen no ña'b mèn con' loon. Per gu' le'le' ndli ndxàc liz xuden co'te' ndli huan' mèn xtàa mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ryete huiz ndlu' Jesús le'n templ. Per mèn co' ngòc jef che'n nguley' tiempa, no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn tiempa, no mèn co' ngòc mèn nac zin' che'n ciuda Jerusalén, ryete mèna mqueltàa par mcua'n mèna mod guth mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Per ne'ñeede mèna xá mod li mèn con'a tac ryete mèn co' nziri' no Jesús, xèe nziri' mèna. Ndxòn mèna di's co' mbez Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Thìb huiz Jesús nzo le'n templ. Ngue lu' Jesús mèn, no ngue te'th Jesús, no ngue go Jesús yalbàn cón che'n di's ndac loo mèn xá mod lyá' mèn loo con' ryes. Látha, mzin mèn co' ngòc jef co' más ñibe' loo nguley' no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn. Thidte mqueltàa rye mèna con rye mèngool co' ndyoo ner no co' ndyoo naa loo mèn nación Israel loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ndxab mèna loo Jesús: ―Gunee loo nu' ¿chó mnibe' lool ndlil rye con' ndlil? No ¿xá mod ndxàpl con' la's niil no con' la's ya'l par ndlil tatua', à'? ");
INSERT INTO zamNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sya, mcàb Jesús loo mèna. Ndxab Jesús: ―Na, ne, ñibdiz thìb con' loo gu'. No ndlyazen fcàb gu' loon: ");
INSERT INTO zamNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Chó mnibe' loo Juàn Bautist par mbli Juàn bautizar mèn, à'? ¿Ché' Diox mnibe' loo Juàn mbli Juàn bautizar mèn o ché' chol mèn mnibe' loo Juàn mbli Juàn bautizar mèn, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lugar de càb mèna loo Jesús, ale mtlo mèna, mdoodi's mèna con xtàa mèna. Ndxab mèna: ―¿Xá nee gu'? ¿Cón gab na' loo mbi' ba'? Chele na' gab: Diox mnibe' loo Juàn, sya, ñee mbi' loo na': ¿Chonon ne'ngala'ste gu' con' mbli Juàn, sya? ");
INSERT INTO zamNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","No chele' na' gab: Juàn mbli bautizar mèn tac ngo chol mèn co' mnibe' loo Juàn li Juàn con'a, sya, ryete mèn co' nziri' no Jesús, tlo mèna, gàa'd quèe mèna na' no guth mèna na' con quèe. Tac ryete mèn nación Israel nonque' no naneepe' mèna le' Juàn Bautist ngòc thìb mbi' co' mbi'th lo yalbàn xal mnibe' Diox loo Juàn. ");
INSERT INTO zamNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Sya, mèna mcàb loo Jesús. Ndxab mèna: ―Ne'ñeede nu' chó mnibe' loo Juàn par mbli Juàn bautizar mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sya, mcàb Jesús loo mèna. Ndxab Jesús: ―Ne' ne' daa nii loo gu' chó mnibe' loon mblin con'a no chó mnibe' loon ngue lin con' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Mtlo Jesús, mdoodi's Jesús loo mèn. Ndxab Jesús: ―Tetaquen thìb con' loo gu': Ngo thìb mbi' co' mque no thìb le' xyòn mbi'. Mdoo mbi' lus uv loo xyòn mbi'. Ngoloa, mda' mbi' xyòn mbi' cuent rol loo ndxep mèn co' ndli zin' loo lus uv. Ngoloa, ngro' mbi' liz mbi'. Mblá' mbi' xyòn mbi' huax lín' loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Per co'se' mzin tiemp co' tlo làa mèn uv, mtel' mbi'a thìb moz mbi' par gab moz loo mèn co' ngue li zin' cuent rol gàc rol xlè uv co' gàc che'n mbi'. Per mèn co' ngue li zin' cuent rol loo yòoa, ale le'le' mxen mèna prob moza. Mbuaa'd ya' mèna prob moz. No mtel' mèna prob moz, ndyàa moz, nague's ya' moz. ");
INSERT INTO zamNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ngoloa, mbere mbi' co' nac che'n yòoa. Mtel' mbi' tedib moz loo mèna. Mtetìi mèna moza no mda' mèna xyàn lezo' moz, no mbuaa'd ya' mèna moz. No mtel' mèna moz, ndyàa moz, nague's ya' moz. ");
INSERT INTO zamNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mbere mbi' co' nac che'n yòo lus uva, mtel' mbi'a tedib moz. Per mèn co' ndli zin' cuent rol loo lus uva, mèna mda' che'n moz. Mtehuí' mèna moz no mchobla' mèna prob moz. ");
INSERT INTO zamNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Por lult, ndxab mbi' co' nac che'n yòoa loo lezo' mbi': ¿Per nal na? ¿Cón lin? Neequen xá ñaa thìb con' lin. Tel'en xgan' daa co' anze'f nque' lezon ñèen loo mèna. Ne'stolque', co'se' ñèe mèna zin xgan'en loo mèna, gàp mèna mod ñèe mèna xgan'en. ");
INSERT INTO zamNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Co'se' gunèe mèn co' ndli zin' cuent rol loo yòoa nde xgan' mbi'a, ndxab mèna loo thìb xtàa mèna no loo tedib xtàa mèna: Mbyòo co' nde go' nac mbyòo co' yan' no xyòn mbi' co' nac che'n yòo ndxè'. ¿Xá nee gu'? Nda yuth na' mbyòo par gàc che'n na' yòo lus uv ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Sya, mxen mèna mbyòo. Mblo' mèna mbyòo thìb lad ro yòo lus uva. Mbeth mèna mbyòo. Sya, mnibdi's Jesús loo mèn co' nzi yòn di'sa: ―¿Xá nee gu'? ¿Cón li mbi' co' nac che'n yòo lus uva loo mèn ye'rsin'a, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Na nii loo gu' cón li mbi'. Mbi' ya no moz mbi'. No ñibe' mbi' loo moz guth moz rye mèn ye'rsin' co' mbli zin' cuent rol loo xyòn mbi'. No yiloa ta' mbi' xyòn mbi' loo tedib ned mèn co' li más zin' ndac. Co'se' mbìn mèn di's co' mdoodi's Jesús, ryete mèna ndxab: ―¡Ay, Dio's! ¡Ne'neede Diox conax! ");
INSERT INTO zamNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Per Jesús xèe mbui' loo rye mèna. Sya, ndxab Jesús loo mèna: ―¿Cón nee di's di's co' ndub loo libr co' nac xti's Diox, à'? Di'sa nac di's ndxè': Quèe co' mblobii mèn co' nac albañil, co' mbli mèn albañil cuent yende chó juis quèea, leque quèea ngòc quèe scaudr co' más ntac. Quèea ngòc quèe co' ndub squin yòo. ");
INSERT INTO zamNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Leque sya, ndxab Jesús di's ndxè' loo mèna, ne: ―Chol mèn co' yixud loo quèea, lyé' zith lad mèna no huí' lad mèna. No loo mèn co' lyàa quèea, quèea lé' mèna no to' quèea mèn thidtene. ");
INSERT INTO zamNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mèn co' ngòc jef che'n nguley' tiempa no mèn co' ngòc maistr co' mblu' cón che'n ley co' mxo'f Moisés loo mèn nación Israel tiempa, mèna mblya's leque hora nden mèna Jesús. Tac mèna mda' cuent cón che'n mèna ngòc di's co' mtetac Jesús loo mèn. Per mzyeb mèna ngli mèna con'a por nziri' mèn co' nziri' no Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Sya, mtel' mèn co' ngòc jef che'n nguley' no mèn co' nac maistr che'n ley mèn ye'rsin' co' asembli par ngòc mèna mèn guryath no mèn guryèn loo Jesús par mbi'th la's mèna loo Jesús. Látha, mque di's mèna con Jesús par bel'que' tataa mod gol' Jesús di's con mèna par tataa mod li mèna gan yigaa Jesús loo mèna. Yiloa, ta' mèna Jesús loo gobernador. ");
INSERT INTO zamNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Por cona, mnibdi's mèna taandxè' loo Jesús. Ndxab mèna loo Jesús: ―Maistr, nu' nanee no non nu' le' U' ndyoodi's no ndlu' U' ante con' co' nac con' lìcpe'. No indyu'de thìb mèn más loo U' leque tedib mèn. Ndxe'leque', non nu' no nanee nu' le' U' ndlu' loo mèn xá mod ndlya's Diox cue ban mèn no xá mod ndlya's Diox que tee ban ndac mèn loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gunee U' loo nu': ¿Ché' ndxàal quix nu' tmi co' nac cón che'n contribución co' ña'b gobiern co' ndub ciuda Rom o ché' indxàalte quix nu'i, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Per Jesús nonque' no naneeque' Jesús xá nac xtùuz ye'rsin' co' ngue li mèna xtùuz. Jesùs ndxab loo mèna: ―¿Chonon ngue gàal di's gu' daa par tyenxù' gu' daa por di's co' càben loo gu', à'? ");
INSERT INTO zamNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Blu' gu' thìb pes plat loon par hui'en ñeene' ¿chó che'n gunab co' ngue loo pes ndxè' no chó lèe mbi' co' nac che'n gunab co' ndub loo pes ndxè', à'? Sya, mblu' mèna thìb pes plat loo Jesús. Jesús ndxab loo mèna: ―¿Chó che'n gunab ngue loo pes ndxè', à'? Mèna ndxab: ―Gunab che'n Ces co' nac gobiern na. ");
INSERT INTO zamNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús ndxab loo mèna: ―Aa. Pues, fta' gu' con' co' nac che'npe' Ces co' nac gobiern loo Ces. No fta' gu' con' co' nac che'npe' Diox loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mèna ne'nglide gan par mtec mèna Jesús xal ngòc di's co' mnibdi's mèna loo Jesús loo rye mèn co' nziri' loo Jesús. Ndxe'leque', más mbui' mèna no más gunaa mèna loo Jesús co'se' mbìn mèna tataa mdoodi's Jesús no co'se' gunee mèn xal nac di's co' mcàb Jesús loo mèna. No yende chó ngabte mèna loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ngoloa, mbii gax ndxep mèn xley' saduce loo Jesús. Mèn xley' saduce indxela'ste le' mèn nguth ryo xban. Ale ndxab mèna loo Jesús: ");
INSERT INTO zamNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maistr, Moisés mtan' di's loo na' loo ley co' mxo'f Moisés loo mèn póla chele' thìb xa'bi' nguth no mbyan' xa'got xa'bi'a no ne'ndante xa'gota xin' xa'gota, hues thebola selya' con xa'got viuda par bel'que' tyan xa'gota xin' xa'gota par gàc myen' bix co' gáala xin' thebol. ");
INSERT INTO zamNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pues, ngòc thìb con'. Ngo ban gaz hues myen'. Mselya' mbyòo co' ngòc mbyòo ndlyo con sa'l mbyòo. Per pente mdub no mbyòo sa'l mbyòo pláte lín' no maste. Làth xtau'a, mzin huiz nguth mbyòo ndlyo. Le' xa'got mbyòo ndlyoa na, ne'ndante xin' mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Sya, mdoole' mbyòo ropa tee selya' con xa'got co' mbyan' viud. Lomisque', ale nguth mbyòo ropa. Ne'ndante xa'got viuda xin' mbyòo ropa. ");
INSERT INTO zamNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Látha, ndoole' mbyòo yona tee selya' con xa'gota. Lomisque', ale nguth mbyòo yona, ne. Por lult, ale ryete gaz myen' mselya' con xa'gota. No nguth ryete gaz myen'. Nec thìb myen' ne'ndante xin' con xa'gota. ");
INSERT INTO zamNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Por lult, nguth xa'gota. ");
INSERT INTO zamNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Cona, ngue nibdi's nu' loo U', co'se' gàc huiz co' ryo xban mèn nguth, ¿chó myen' gàc sa'lpe' xa'gota tac ryete gaz hues myen' mselya' con xa'gota, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Sya, mcàb Jesús. Ndxab Jesús loo mèna: ―Loo izlyo' ndxè' nselya' mènbi' no nselya' mèngot. ");
INSERT INTO zamNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mèn co' ngòo Diox cuent yòo tedib izlyo' co' nac yòoba' co'te' ban no mèn Diox thidtene co' nde nque, mèna ngòo Diox cuent ryo xban làth mèn nguth. Mèna ne'selya'de ne' ne' ta' mèna xgan' mèna no rsap mèna par selya' myen'a tya. ");
INSERT INTO zamNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mèna ya ne'gathte tya tac mèna gàc xal angl. No gàcpe' mèna xin'pe' Diox por ngro xban mèna làth mèn nguth huiza. ");
INSERT INTO zamNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Axta Moisés mblu' le' mèn, lìcque', ryo xban làth mèn nguth xal ndub di's co' nda' cuent loo libr co' nac xti's Diox co'se' gunèe Moisés ndoo yol yaa yis sars. Leque loo libra ndlu' loo na', ne, le' Diox nac Diox che'n Abraham, no nac Diox Diox che'n Isaac, no nac Diox Diox che'n Cob. ");
INSERT INTO zamNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Diox inacte Diox che'n mèn co' mbez gu' nguth no mblyux co' mbez gu' ne'ryo xbante. Tac co'se' ndxath mèn, inacta mblyux mèna thidtene. Ndxe'leque', Diox non le' mèn nabanque' co'te' ndyàa mèn co'te' ñibe' Diox ndyàa mèn co' nguth. Tac Diox ndli indxelode no indxeluxte mèn thidtene xal ndli gu' cuent nguth mèn no mblyux mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sya, ngro nxon', ndxep mèn co' ngòc maistr co' mblu' cón che'n ley co' mxo'f Moisés loo mèn ndxab mèna loo Jesús: ―Huenque' gunee U', Maistr. Ndxàp U' razon. Yende chó ñeede nu' loo U'. ");
INSERT INTO zamNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mèna ya ne'tolode ngli ryes ngnibdi's taamas con' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús ndxab loo mèna: ―¿Xá mod mbez mèn le' Crist nac xgan' David co' ngòc rey póla, sya? ");
INSERT INTO zamNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Con que yub David co' ngòc rey ndxab xalque' mbez di's co' ndub loo libr co' nac xti's Diox co' nac libr che'n Salmos: Yub Tad Diox ndxab loo Tad daa: Ftub cuaten co' nac ladli ");
INSERT INTO zamNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","axtaque' lin le' ryete mèn co' ngòc ngolo ngola's lùu gàc mèn nado' lool. ");
INSERT INTO zamNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Xá mod ndlya's gu' ale gàc Crist xgan' David co' ngòc rey co'se' leque yub David mbez le' Crist nac Tad David, sya? Yende yob yéc gu' co' taate mbeza, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ryete mèn co' nziri' loo Jesús nzi yòn di's co'se' ndxab Jesús loo myen' xin' mté'th Jesús: ");
INSERT INTO zamNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Anderhuen gu'. Chó Diox chó nee gu'. Nee gu' xal nzi tee gu' loo mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn tac mèna anze'f ndyubla's que tee noc lar' nol' co' nac xab mèna. No ndlya's mèna le' gu' gàp mod ñii gu' Diox loo mèna co'se' nzyál' gu' mèna loo xbi'. No ndxòo lezo' mèna tyub mèna loo ner asient co'te' más ndyu' mèna le'n sinagog. No lomisque', ndxòo lezo' mèna ndyub mèna loo mèn co'te' más ndyu' mèna par hua mèna co'se' ndli mèn convid mèna ya mèna loo thìb yalhua. ");
INSERT INTO zamNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Lomisque' ne, ale nde yath mèna ndyenxù' mèna no ncàaxù' mèna liz prob mèngot viud por pláte pes no maste. No par ndli mèna xalque' mèn co' ne'ñeede, ale asendli mèna nteyol' mèna di's co'se' mbez mèna Diox. Per, lìcpe' ba'i, na nii loo gu': Por con' ndli mèna, gàc más yalquìi tín' loo mèna co'se' gàc huiz tub rez Diox cón che'n mèna loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Láth ngue lu' Jesús mèn le'n templ, ñèe Jesús ngo mèn, co' ngòc mèn ric, tmi le'n alcansi co'te' ngo mèn ofrend tiempa. ");
INSERT INTO zamNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Látha, gunèe Jesús thìb xa'got viud prob co' mblo chop co' ga'y charud le'n alcansi, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Sya, ndxab Jesús loo mèn co' nziri': ―Part cón che'n Diox, Diox ngòo cuent más huax tmi mblo prob xa'got viud ba' le'n alcansi leque tmi co' mblo taamas mèn ric ba'. ");
INSERT INTO zamNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tac ryete mèn ric ba' co' mblo tmi le'n alcansi ba', mèn ric mblo tmi co' mbyan' xo'f loo con' mxi mèn co' nac co' naquin mèn le'n alcansi. Per prob xa'got viud ba' mblo tmi co' be'te' ngue no xa' par ti' xa' gast xa' le'n alcansi. ");
INSERT INTO zamNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Látha, ngure ndxep mèn co' nda ndye'th, nzi tee yot mèna rye lad le'n templ. No ndyoodi's mèna cón che'n templ. Mbez mèna: ―Susque' nabe's ñaa templ con rye loo quèe co' natoxcua' templ ba' no con rye loo con' huen co' natoxcua' le'n templ por cón che'n ofrend co' mda' mèn loo Diox, yoo. Látha, ndxab Jesús loo mèn co' nzi tee yot le'n templa: ");
INSERT INTO zamNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Nde niin thìb con' loo gu': Zin thìb huiz no zin thìb ze co'se' ryete con' nzi hui' gu' ba' lyux. Yé' huize' yi'th mèn, sil mèn ftoo ba' no làare' mèn ftoo ba'. Ya ne'tan'te mèn nec thìb quèe loo xtàa quèe co' nac ftoo ba'. Yende chó ftoo yan' co' ne'silte mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sya, mnibdi's mèna loo Jesús. Ndxab mèna loo Jesús: ―Maistr, ¿pól gàc con'a, sya? No ¿cón tlo yú' loo mèn co'se' tlo gàc con'a? ");
INSERT INTO zamNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús ndxab loo mèna: ―Anderhuen gu'. Nee gu' xá nzi tee gu'. Ne'la'de gu' quedìi chol mèn gu'. Tac anze'f huax mèn yi'th. No ñee mèna loo gu': Daa nac merpe' Crist. No ñee mèna loo gu': Nalle' mzin huiz co' yi'th Crist. Per mastale' tataa ñee mèna loo gu', ne'tyoo nquede gu' xís mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","No co'se' gòn gu' tyoodi's mèn cón che'n xó' no cón che'n revuelt, ne'zyebte gu'. Tac naquin ner gàc con'a. Per mastale' tlo gàc con'a, tarte gàc huiz co'se' lith no izlyo' tiempa. ");
INSERT INTO zamNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesús tolo mdoodi's loo mèna. Ndxab Jesús loo mèna: ―Tiempa tlo mèn thìb nación cue yoo mèna con mèn co' nac che'n tedib nación. Cue yoo mèn thìb nación contra mèn tedib nación. ");
INSERT INTO zamNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Le'n tiempa huin xòo brut huax lugar no lyàa yilíiz huax lugar. Huiza tlo gàc no tlo yú' con' roo con' xèn loo bé' co' tarte hui' mèn. Co'se' hui' mèn gàc señ co' tarte hui' mèn gàc loo bé', tlo mèn zyeb mèn, por derech. ");
INSERT INTO zamNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Per ndoore' co'se' tlo gàc ryete con'a, mèn ye'rsin' tlo tyenxù' gu' no tub ngu's mèna gu'. Hue' mèna gu' co'te' nac sinagog mèna par tub rez mèna cón che'n gu'. Yiloa, que' mèna gu' lezi'f. Hue' mèna gu' loo mèn co' nac rey mèn co' ñibe' no hue' mèna gu' loo mèn co' nac gobernador no loo mèn nac zin' yoolau. Ryethe con'a li no mèn gu' por cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Gàc con'a loo gu', ey, par tataa mod negadi's ta' gu' cuent cón chenen loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bli yéc gu' no bli lezo' gu' par ne'tyóode gu' no par ne'lide gu' xtùuz cón gab gu' no cón tyoodi's gu' loo mèna, par tub gu' razon cón che'n leque gu' loo mèna huiza. ");
INSERT INTO zamNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tac daa ne'lá'ya'de gu' hora. Na li par tyoodi's gu'. No lin par gácpe' gu' hora par nec thìb mèn co' nac ngolo ngola's gu' ne'gácte mèna ñii mèna ngòc nguàal con' loo gu' huiza. ");
INSERT INTO zamNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Le'n huiza, ne, axta xud gu', no huespe' gu', no mèn guliz gu', no mèn co' ndxàc amiu gu' bixyath contra gu'. Ta'xù' mèna gu' loo mèn co' nac ngolo ngola's che'n gu' axta guth mèna ndxep gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ale rye mèn chol lugar yòo xyàn lezo' ñèe mèna gu' ante por cón chenen no maste. ");
INSERT INTO zamNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Per mastale' tataa li no mèn gu', gàca loo gu' axta ne' ne' thìb yis yéc gu' ne'tyuhuante. ");
INSERT INTO zamNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Chele' gu' thidteneque' cue nèe loo cón chenen no xec yèe gu' loo cón chenen, le' sya, tataa mod gu' que noque' yalnaban, co' nee di's, ban no gu' Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Niin con' ndxè' loo gu', ne: Co'se' ñèe gu' le' solndad mtau'le' dib vuelt ro ciuda Jerusalén, sya, ta' gu' cuent no li la's gu' yamerle' tlo solndad par setilte telux solndad mèn ciuda Jerusalén no tùub solndad ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Co'se' gàc huiza, mèn co' naban rye yèezya' co' nac yèezya' che'n làaz mèn jude, más huen xyon' mèna par yii den par casloo mèna le'n yix no le'n huan. Le' mèn co' nac mèn ciudape' Jerusalén na, más huen xyon' mèna, ryo' mèna le'n ciuda Jerusalén. Lomisque' ne, mèn co' ngue quenap ranch huan, más huen ne'berede mèna par ye'th mèna le'n ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tac huiza gàc huiz co'se' tub rezpe' Diox loo mèn ciuda Jerusalén cón che'n con' ye'rsin' co' mbli mèna par gàcque' ryete con' loo mèna xal ndub di's loo libr co' nac xti's Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ay, prob rye xa'got co' nzi nac xin' le'n huiza no rye xa'got co' diz ngóol xin' le'n huiza. Tac le'n huiza cue xi lezo' mèn no gàc yalquìi loo mèn dib anax le'n nación Israel. No nzyalque' mèna tataa tetìi Diox mèna axta plóthe. ");
INSERT INTO zamNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mèn co' nac ngolo ngola's che'n mèn ciuda Jerusalén guth huax mèn ciuda Jerusalén loo xó'. Chó mèn gath loo xó'. Chó mèna hue' mèn co' ngòc ngolo ngola's mèn co' ngogaaa axta le'n taamas nación co' nziri' loo izlyo'. No gàca le' mèn co' nac mèn chol nación gàc che'npe' mèna ciuda Jerusalén. No ñibe'pe' mèna loo ciuda Jerusalén axta tyaa huiz co'se' ta' Diox lugar gàc ciuda Jerusalén che'npe' mèn nación Israel tedib vez. No ñibe'pe' mèn nación Israel loo ciuda Jerusalén tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Sya, ndxab Jesús: ―Nde niin con' ndxè' loo gu', ne: Huiza tlo yú' yalguzye' co' li Diox co' gàc loo huiz no loo mbe' no loo mbyáaz. Le' loo izlyo' ndxè' na, anze'f huax mèn ya ye'th lezo'. No zyeb mèn co'se' gòn mèn ruid che'n ol níttó' co' yitoo loo níttó'. ");
INSERT INTO zamNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Huiza, alux mèn yo no lezo' no ne' ne' ñee mèna pá ndoo mèn no pá nziri' mèn tant nzyeb mèn co'se' li mèn xtùuz cón gàc loo izlyo' tiempa. Huiza no zea huin huiz co'te' ndub huiz. No huin mbe' co'te' ndub mbe'. No huin mbyáaz co'te' nzi'f mbyáaz. ");
INSERT INTO zamNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Axta syare' hui' mèn dib athu loo izlyo' loon, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn. No co'se' galen le'n tiempa, galen le'n thìb le' xcuau. No ndxàpen rye loothe con' la's niin no la's yan co' yú' loo mèn co'se' galen. Tiempa mèn ta' cuent no non mèn cón che'n con' roo no con' xèn co' nac cón che'npe'en. ");
INSERT INTO zamNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Co'se' tlo gàc con'a, bli gu' par ye'th lezo' gu'. Bdi'x xnìi yéc gu' no bdi'x xnìi lezo' gu' tac huiza non gu' no ta' gu' cuent ya nde zin' gaxle' lyá' gu' thidtene loo con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mtetac Jesús thìb di's loo mèna. Ndxab Jesús: ―Nde niin thìb con' loo gu': Hui' gu' loo yaa ngudyuug no loo chol taamas yaa nayèe. ");
INSERT INTO zamNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Co'se' ñèe gu' ngòble' laa loo yaaa no nde xìis tedib cua' laa yèn' loo yaaa, leque gu' non no nda' gu' cuent nde zinle' tiemp co'se' más nguin bée loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Lomisque' ne, co'se' ñèe gu' ndxàcle' con'a, leque gu' nda' cuent no non gu' nde zin' gaxle' tiempa co'se' tlo Diox, ñibe'pe' Diox loo mèn xal ndlya's Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Lìcpe' ba'i, na nii loo gu': Ryete con'a gàcque' ndoore' lyux no lith no mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Con' co' nac cón che'n bé' no con' co' nac che'n izlyo' lyuxque' no lith noque'. Per di's co' ndyoodizen inacte di's co' angndyoodizen. Gàcque' no tyubque' di's co' ndyoodizen ndxè' xal ngue toodizena loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Anderhuen gu'. Leque gu' hui' xá nzi tee gu'. Ne'ta'de gu' lugar tyub yo'f lezo' gu' par lyàa gu' loo chol con' ye'rsin' par tataa mod yitac lezo' gu' loo cón chenen. Tac látha, chàa, lyàa gu' loo yalguy no tlo gath lyux gu' loo yalgon' che'n izlyo' ndxè'. Nalas gure gu' loo cón chenen par ne'gàcta loo gu' huiza xal co'se' mzin thìb amiu gu' thìb hor co' ne'ta'de gu' cuent no co' inonte gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Huiza gàca loo mèn co' naban dib athu loo izlyo' xal thìb tramp co', chàa, ndlyàa par yigaa má' loo tramp. Tataa gàca loo mèn huiza. ");
INSERT INTO zamNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nalas gure gu'. Ne'cuedte gu' no ne'yathla'ste gu' thidteneque' gure rez gu' Diox par gàca loo gu' tataa mod li gu' par lyá' gu' loo ryethe con' ryes co' gàcque' huiza. No par tataa mod li gu' gan par yòo gu' loo cón chenen, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ndxáal ze ndlu' Jesús mèn le'n templ. Le' ndxáal yál' na, ndyee Jesús co'te' ndub thìb yii co' lèe yii che'n yaa oliv par li Jesús descans tya. ");
INSERT INTO zamNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Le' ryete mèn co' ndyee yòn di's co' ndlu' Jesús le'n templ na, mèna ndxechegà par zingà mèna le'n templ par gòn mèna di's co' ndlu' Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nde nxon', nde zin gax huiz co' ngòc huiz lni co' ndli mèn nación Israel co'se' ndxuhua mèna pan co' indxòode dii levadur. Mbez mèn nación Israel lni pasc loo lnia. ");
INSERT INTO zamNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Le' mèn co' nac jef che'n nguley' no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn nación Israel na, mèna mcua'n mod xá mod guth mèna Jesús. Per mzyeb mèna guth mèna Jesús por cón che'n mèn co' ngureri', mèn co' mbi'th lni co' nziri'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Látha, ndoole' Mebizya. Ngulàa Mebizya le'n lezo' Jud co' ne' tedib lèe Iscariot. Juda ngòc thìb myen' xin' mté'th Jesús, ne, co' ndxòo cuent nac si' fchop myen' xin' mté'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ngua nee Jud loo mèn co' ngòc jef co' más ñibe' loo nguley' tiempa no loo mèn co' mxo'f zin' cón che'n templ tiempa. Mdoodi's no Jud mèna. Ndxab Jud neeque' Jud xá mod li Jud par ta'xù' Jud Jesús la's ya' rye mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Co'se' mbìn mèna tataa ndxab Jud loo mèna, axta con gust ndxab mèna loo Jud ta' mèna ndxep tmi càa Jud cuent li Jud con'a. ");
INSERT INTO zamNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jud mda' lugar. No mblec lezo' Jud li Jud con'a tataa. Sya, mtlo Jud, mcua'n Jud mod par ta'xù' Jud Jesús loo mèna thìb tiemp co'se' ñee Jud yende chó mèn nziri' no Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Le'xque' le'n huiza mzin huiz lni co'se' ndxuhua mèn nación Israel pan co' indxòode dii levadur. Huiza ndxuth mèna mbacxil' co' mbez mèn nac lni pasc. ");
INSERT INTO zamNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Le' Jesús na, mtel' Pedr ryop Juàn. Ndxab Jesús loo Pedr ryop Juàn: ―Huàa li nab gu' con' hua rsè na' par li na' lni pasc. ");
INSERT INTO zamNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Myen' mnibdi's. Ndxab myen' loo Jesús: ―Tad, ¿pá ndlya's U' ya toxcua' nu' con' hua rsè na', à'? ");
INSERT INTO zamNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús mcàb. Ndxab Jesús loo myen': ―Co'se' yòo gu' ro ciuda Jerusalén, tya zyál' gu' thìb mbi' co' ne' thìb rre nít. Ftoo nque gu' xís mbi' axta zin mbi' liz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Co'se' zin gu' co'te' zin mbi'a, gab gu' loo mbi' co' nac gundan che'n yòoa: Maistr mtel' nu' par ñee nu' loo U': ¿Pá ndub cuart co'te' hua rsè'en, par lin lni co' nac pasc con myen' xin' mté'th daa, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Sya, lu' mbi' thìb cuart roo co' nac chop pis loo yòo loo gu'. Cuarta natoxcua'le'. Tya toxcua' gu' con' par hua rsè na' par li na' lni pasc. ");
INSERT INTO zamNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mxen Pedr ryop Juàn ned. Nda Pedr ryop Juàn. No mzyál' myen' mbi' xalque' ndxab Jesús. Mtlo Pedr ryop Juàn, mtoxcua' Pedr ryop Juàn con' hua rsè no myen' Jesús par li myen' lni pasc con Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Co'se' ngóol hor hua rsè Jesús con myen', mdub Jesús con myen' xin' mté'th Jesús co' ndxe' di's che'n Jesús loo mèn loo mes. ");
INSERT INTO zamNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús ndxab loo myen': ―Ne' pól ndxàc anze'f ndryo' ndlyen' lezon hua rsè na' sa pan par li na' lni pasc ndoore' zin huiz gath daa. ");
INSERT INTO zamNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Daa nii loo gu': Ya ne'bereden lin tedib yalhua ndxè' xal ngue li na' nalle'. Lin yalhua ndxè' tedib vez axta co'se' gàc tiemp co'se' tlo ñibe'pe' Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sya, mxen Jesús thìb vas nít uv. Ndxab Jesús: Diox quix U', Diox, loo Diox. Ngoloa, ndxab Jesús loo myen' xin' mté'th Jesús: ―Fteri'th gu' vas ndxè' loo thìb thìb xtàa gu' par gu gu' thìb ro chu'th nít uv ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Na nii loo gu': Ya ne'bereden gun nít uv ndxè' xalque' ngue lina nalle'. Na gu nít uv ndxè' tedib vez axta co'se' gàc huiz tlo ñibe'pe' Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ngoloa, mxen Jesús pan. Ndxab Jesús: ―Diox quix U', Diox, loo Diox. Sya, mchì'x Jesús pana thìb le' chu'th, thìb le' chu'th. Ngoloa, mda' Jesús pana loo myen' xin' mté'th Jesús. Ndxab Jesús loo myen' xin' mté'th Jesús: ―Pan ndxè' nee di's nac cón che'n bél'yòo ladpe'en co' tyenxù' mèn par tetìi mèn bél'yòo laden por cón che'n gu'. Taandxè' ñibe'en loo gu' hua gu' pan ndxè'. No taandxè' ñibe'en loo gu' gu gu' nít uv ndxè' par te' lezo' gu' cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tataa mbli Jesús, ne, co'se' mxen Jesús thìb vas nít uv, no co'se' ngolo nduhua rsè no Jesús myen'. Ndxab Jesús loo myen': ―Nít uv co' nzo le'n vas ndxè' nee di's cón che'n conveñ cub co' li nèen thidtene por cón che'n ren laden co' xyo co'se' gath daa por cón che'n xquin mèn no xtol mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Per nalle' mbi' co' ta'xù' daa loo mèn, mbi' ndub loo mes ndxè' con na'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Cona, ngue niin loo gu': Daa mbal yáal loo izlyo' xalque' ndxáal chol mèn par gathxù' daa xal ndlu' xti's Diox cón chenen. Per part cón che'n prob mbi' co' ta'xù' daa loo mèn, ¡ay, prob mbi' izlyo'!, tac mbi' thidtene nac thìb mbi'dèe loo Diox too ze too yál'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Sya, mtlo myen' xin' mté'th Jesús, mnibdi's myen' loo xtàa myen'. Mbez myen: ―¿Chó nac na' co' ta'xù' Jesús loo mèna, cara? ");
INSERT INTO zamNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Leque xhuina mque di's myen' làth xtàa myen'. Mbez myen': ―¿Chó na' gàc co' más ñibe' loo xtàa na' yiloa, à'? ");
INSERT INTO zamNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús ndxab loo myen': ―Hui' gu' nexa. Mèn co' ndxàc rey co' ñibe', mèna ñibe' loo mèn nación xal loo moz. Le' mèn co' ndxàc jef na, mbez anze'f mbi' mèna por con' co' ndli mèna loo mèn co' nac mèn nación mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Per part cón che'n gu', indxàalte li gu' tatua' no xal nzi li gu' xtùuz làth gu' nalle'. Ne' ne' indxàal gab gu' tatua'. Ndxe'leque', chol gu' co' nzo làth gu' co' mbez nac más mbi' roo no más mbi' xèn, leque gu'a li par gàc gu' xal thìb mbyòo yen' co' más be'the làth gu'. Le' gu' co' lya's ñibe'a na, gu'a ndxàal gàc xal thìb moz co' li mandad loo gu' làth gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nde niin thìb con' loo gu' xal ndli mèn loo xtàa mèn co' más ñaare' taachu'th loo xtàa mèn loo izlyo' ndxè': ¿Xá nee gu'? ¿Chó mèn ndli gu' cuent más ntac loo xtàa mèn co'se' ñibe' mèn loo xtàa mèn? ¿Ché' más ntac mèn co' ndyub loo mes par cuec mèn con' hua mèn co' ndub loo mes o ché' más ntac mèn co' mbec con' hua mèn co' ndub loo mes, cà'? ¿Xá nee gu'? ¿Ché' ngue li gu' cuent ilìcte masque' ntac mèn co' ndyub loo mes co' mbed huaa, cà'? Masque' ntac mèna, ¿lé'? Per daa, ale ndxe'leque', ndal xi'th gu' par lin sirv loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Gu' nda'que' cuent no ngo noque' gu' daa. No gunèe gu' ryethe con' nde teele' ndli no mèn daa. ");
INSERT INTO zamNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Por cona, tan lugar no lin le' gu', ne, ñibe' loo thìb baan mèn xal mnibe' xuden Diox loon par ñibe'en loo ryethe con'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","No tan lugar par hua no gu' daa no par gu no gu' daa loo mes daa co'se' gàc huiz co' ñibe'pe'en loo ryethe con' no tyub ñibe' gu' par tub rez gu' loo si' fchop ned mèn co' ngòc bin thìb mbi' co' ngro' lèe Israel co' mbloj msi' bin co' nac mèn co' lèe mèn nación Israel nalle'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ndxab Jesús loo Mon Pedr, ne: ―Mon, gunee xá ngue teel tac Mebizya ndlya's li preb loo gu'. No ngue li Mebizya par ñee Mebizya ñeene' ché' ta' gu' lugar cuee ca' Mebizya gu' no co' xà' Mebizya gu' loo cón chenen xal nzib mèn nzob triu par co' mèn yix loo nzob triu. ");
INSERT INTO zamNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Per daa mna'ble' loo Diox no ngurezen Diox por lùu le' lùu toloque' yila's loon. No co'se' berel, lyàa yécl no lyàa lezo'l loo con' lil loo cón chenen, lyazen le' lùu tegán lezo' myen' co' ndxàc huesl no xtàal loo cón chenen par tolo ye'th lezo' myen' loo cón chenen huiza. ");
INSERT INTO zamNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mon mcàb loo Jesús. Ndxab Mon: ―Tad, na ne'lá'de U'. No daa ga lezi'f con U'. Co'te' gath U', tya gath daa, ne. Daa inzyebte. ");
INSERT INTO zamNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús ndxab loo Mon Pedr: ―Pedr, na nii lool: Leque nalxhuin ndoore' cozèe nguiidtee lé' nguiidtee yál', lùu cà di's daa son vez loo mèn. Gabl loo mèn ne'libe'del daa. ");
INSERT INTO zamNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sya, mnibdi's Jesús loo myen' xin' mté'th Jesús. Ndxab Jesús loo myen': ―Co'se' mtel'en gu', ngua gu' le'n nación che'n mèn Israel, daa mnibe' loo gu' ne'hue'de gu' yex lua' gu'; ne'hue'de gu' billeter co'te' ngosua' gu' tmi gu'; no ne'hue'de gu' tedib ned yilid gu'. Co'se' mnibe'en loo gu' mbli gu' tataa, ¿ché' ngotub con' mquin gu' ned ngua gu' sya, cà'? Myen' mcàb. Ndxab myen' loo Jesús: ―Yende xàa, Tad. ");
INSERT INTO zamNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesús ndxab loo myen': ―Pesea, mnibe'en loo gu' ne'hue'de gu' con'. Per nase, lyazen le' gu' co' ngue no yex lua' gu', be' gu' yex lua' gu'. Le' gu' co' ngue no billeter gu' na, be' gu' billeter gu'. Le' gu' co' ingue node spad gu' na, ftho' gu' chamar gu' par ti' gu' thìb spad par que no gu' thìb spad. ");
INSERT INTO zamNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tac daa nii loo gu': Nase mzinle' hor gàcque' con' loon xal mbez di's co' ndxab cón chenen, di's co' ndub loo libr co' nac xti's Diox co' mbez: Thidte mde'th mèn di's no mbli mèn cuent nac daa mbi' ye'rsin' làth mèn ye'rsin'. Cona, ngue niin loo gu': Le' di's co' ndub loo libr co' nac xti's Diox ndlu' cón chenen le'i naquinque' tataa gàca loon le'n huiz ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Sya, ndxab myen' loo Jesús: ―Tad, trè' ngue no nu' chop spad. Jesús mcàb. Ndxab Jesús: ―Con sobr chop spad ba'. ¿Cón más? ");
INSERT INTO zamNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ngoloa, ngro' Jesús, nda Jesús co'te' ndub yii co' lèe yii che'n yaa oliv xalque' nac mod co' ndxàp Jesús. Per myen' xin' mté'th Jesús ne'nglá'de Jesús. Mdoo nque myen' xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Co'se' mzin Jesús co'te' ndub yiia, ndxab Jesús loo myen': ―Gurez gu' Diox, ndee gu', par ne'ta'de gu' lugar leque gu' li chol con' ye'rsin' co'se' cobya' Mebizya gu' naba'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tya mtan' Jesús myen' xin' mté'th Jesús. Le' Jesús na, ngua taachu'te más tith loo myen' xal thìb distans co' ndlyàa thìb quèe co' ngobii mèn con ya' mèn. Tya mdub xib Jesús par ngurez Jesús Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ndxab Jesús loo Diox: ―Pay, yey, chele' U' ndlya's telá' U' daa co'se' gàc hor ye'rsin' loon, nzoque' mod li U' par ne'gàcte yaltìi co' gàc loon co'se' le'le' daa quix loo U' cón che'n xquin no xtol ryethe mèn. Per Pay, indlyasten gàca xal neete lezon. Ndxe'leque', ndlyazen gàca xal neepe' lezo' U'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Látha, chàa, ngro' too thìb angl co' ngulàa loo bé' loo Jesús. Angla mbli par ngòp Jesús fuerz no ngo valor loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Láth co'se' mden' Jesús mxi lezo' Jesús axta plóthe, látha sate más nalyat ngurez Jesús Diox. No nen mdub xib Jesús. Ngurez Jesús Diox. No cabii ngurez Jesús Diox axta ante bel'yòo Jesús nít tant ndyoo nít Jesús mbez Jesús Diox. No axta ren nos nít co' ndyoo nít Jesús. No axta gos gos ngòb nít co' mdoo nít Jesús loo yòo. ");
INSERT INTO zamNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Co'se' ngolo ngurez Jesús Diox, mdyàa Jesús co'te' nziri' myen' xin' mté'th Jesús. Per co'se' mzin Jesús co'te' nziri' myen', ale mxen mcal'guth myen' tant mdyóo myen' no tant mxi lezo' myen' cón che'n con' co' gàc loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Sya, mblo' Jesús mcal' loo myen'. Ndxab Jesús loo myen': ―Blo' gu' mcal' loo gu', yey. ¿Chonon susque' ndxàt gu'? Goo che gu'. Gurez gu' Diox par ne'ta'de gu' lugar li gu' chol con' ye'rsin' co'se' cobya' Mebizya gu' naba'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús tatabe' ndoo toodi's co'se' mzin huax mènléy' loo Jesús. Le' mbi' co' ngro' lèe Jud co' ngòc xin' mté'th Jesús co' ndxòo cuent ngòc si' fchop myen' xin' mté'th Jesús na, ndoo ner loo mèna. Mbii gax Jud loo Jesús par sero Jud loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sya, ndxab Jesús loo Jud: ―Jud, ¿ché' con thìb besit co' nda'l loon taandxè' mod mda'xù'l daa, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn, cà'? ¿Ché' tatua' mod mblila, cà', Jud? ");
INSERT INTO zamNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Per co'se' ñèe myen' xin' mté'th co' nziri' con Jesús ndxàc con'a, ndxab myen' loo Jesús: ―Tad, ¿xá nee U'? ¿Ché' tlàa nu' spad rloo mèn ba', à'? ");
INSERT INTO zamNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Láth ndxàc con'a, thìb myen' xin' mté'th Jesús co' nzo làth taamas myen' con Jesús mblàa thìb ya' spad nza thìb mbi' co' ngòc moz che'n jef co' más ñibe' loo nguley'. Mblo nde'f myen'a nza moz co' nac ladlì. ");
INSERT INTO zamNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Per Jesús ndxab loo myen'a: ―Bla' gu' tee nziri' mèn ba'. Con sobr con' mbli no gu' mèn ba'. Con con' ba'te ya guneela. Sya, mblít Jesús nza mbi' co' ngo nde'ba loo yòo. Nzi huite mèn, mdub Jesús nza mbi' lad quèe yéc mbi' tedib vez. Chàa, mbyac nza mbi' xalque' thìb nza mèn co' yende con' mxac. ");
INSERT INTO zamNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ngoloa, ndxab Jesús loo mèn co' ngòc jef co' más ñibe' loo nguley', no loo mèn co' ngòc mèn nac zin' co' nquenap templ tiempa, no loo mèngool, mèn co' mbi'th par hue' mèna Jesús: ―¿Ché', por derech, ngro' gu' con spad no con yaa par tyen gu' daa xal ndyen mèn thìb huan', cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Co'se' ngo non gu' le'n templ huax vez, ne'nglide gu' ryes ngàal gu' daa. Per nase mzinle' hor che'npe' gu' co' nac tiemp co'se' Mebizya ngue ñibe' loo gu' par li no gu' daa cón ndlya's gu'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sya, mdub dó' mèna ya' Jesús. Mbe' mèna Jesús liz mbi' co' nac jef co' más ñibe' loo nguley'. Le' Pedr na, tith tith ndoo nque xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ngoloa, mtol' mèna quìi xtau'the loo lue' liz mbi' co' nac jefa. No mdub mèna dib vuelt ro dii. Nzi biiz mèna tant nàl. Ale note Pedr mdub biiz ro dii xi'th mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Co'se' gunèe thìb criadgot che'n jefa no Pedr ndub ro dii làth mèna, xèe mbui' criadgota loo Pedr. Ndxab criadgot loo taamas mèn co' nziri' ro dii: ―Mbi' ba', ne, mque tee noque' Jesús, ndyaquen. ");
INSERT INTO zamNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Per prob Pedr mcà di's. Ndxab Pedr: ―Criad, indlibeden mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pente ndxàc gunii criadgot loo Pedr, gunèe tedib mbi' Pedr. Ndxab mbi' loo Pedr: ―Lùu, ne, nac thìb mbi' co' naqueltàa no mèna, ¿lé'? Per prob Pedr ndxab: ―Yende xàa. Ne'ngòoden làth mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pente ndxàc thìb hor nguri'th con'a, tedib mbi' mbli nèe loo mèn co' nziri' ro diia. Ndxab mbi' loo mèna: ―Lìcpe' ba'i, mbi' ba' ngo no Jesús, ne, tac mbi' ba' nac mbi' che'n làaz mèn galile. ");
INSERT INTO zamNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Per Pedr ndxab loo mbi'a: ―Mbi', ne'needen cón ngue bezl. Leque hor co' be' ngue toodi's Pedr loo mbi'a, chàa, ngrozèe nguiidtee mblé' nguiidtee yál'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Leque hora, Tad Jesús mbere loo, mbui' Tad Jesús loo Pedr. Chàa, mbui' Pedr loo Tad Jesús, ne. Sya, mte' lezo' Pedr di's co' ndxab Tad Jesús loo Pedr: Lùu cà di's daa son vez nalyál' ndoore' co'se' tlo cozèe nguiidtee lé' nguiidtee yál'. ");
INSERT INTO zamNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Sya, ngro' Pedr làth mèna. Ne'tí' ne'ñee lezo' Pedr, mbìn' Pedr axta plóthe tant mxi yéc Pedr no mxi lezo' Pedr por mcà di's Pedr Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Le' mèn co' ngue no Jesús na, ngue li ngòc nguàal con' loo Jesús. No nzi tin mèna Jesús xal mblya's mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mtau' mèna ngudloo Jesús con thìb panid. No be' taa nguis mèna thìb lad tedib lad rloo Jesús par nda' mèna xyàn lezo' Jesús. No ale mbez mèna loo Jesús: ―Bli divin chó mda' che'nl. ");
INSERT INTO zamNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","No asembli mèna mbez mèna huax con' co' nac ngòc nguàal con' loo Jesús par mda' mèna xyàn lezo' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Co'se' ngo nìi izlyo' tedib huiz co' nde nquea, ryete mèngool co' ñibe' loo mèn nación Israel, no ryete mèn co' nac jef co' más ñibe' loo nguley', no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn mqueltàa par mbe' mèna Jesús loo rye mèn co' mqueltàa no mèna. Tya mnibdi's mèna loo Jesús. Ndxab mèna loo Jesús: ");
INSERT INTO zamNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Gunee loo nu' ¿ché', lìcque', lùu nac Crist, à'? Jesús mcàb loo mèna. Ndxab Jesús: ―Chele' daa nii loo gu' daa nacque' Crist, ¡pà yila's gu' co' ngue niin loo gu'! ");
INSERT INTO zamNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Más de cona, chele' daa ñibdi's thìb con' loo gu', ne'càbte gu' loon, ndyaquen. No ne' ne' lá' gu' daa par biin. ");
INSERT INTO zamNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Per desde nalle' par delant, daa co' mbal yáal làth gu' xalque' ndxáal chol mèn, daa nduble' cuat Diox co' nac ladli che'n Diox, Diox co' ndxàp ryethe con' roo no con' xèn la's nii Diox no la's ya' Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Co'se' mbìn mèna tataa ndxab Jesús, mnibdi's mèna loo Jesús. Ndxab mèna: ―¿Ché' nacque' lùu xgan'pe' Diox, sya, cà'? Jesús mcàb loo mèna. Ndxab Jesús: ―Nacque' daa xgan'pe' Diox, pues. Yub gu' ngolo guneei loon. ¿Cón más ndlya's gu' niin loo gu'? ");
INSERT INTO zamNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Sya, thidte ndxab mèna no thidte gunii mèna loo xtàa mèna: ―¿Cón li más mèn co' ta' cuent loo na' cón che'n mbi' ba'? Ya mbìnle' na' cón che'n mbi' xal nac di's co' ngro' rope' mbi' co' ngolo gunee mbi' loo na' nalle'. ");
INSERT INTO zamNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Sya, ryete mèna nguátbèe. Mbe' mèna Jesús loo Pilat co' ngòc gobernador loo ciuda Jerusalén tiempa. ");
INSERT INTO zamNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mtlo rye mèna, mquexù' mque' fals mèna Jesús loo Pilat. Mbez mèna loo Pilat: ―Mbi' ndxè' ngogaa loo nu'. Ngue lu' mbi' xley' mbi' loo mèn gulàaz nu' par se' mèn mod co' ndxàp mèn. No ale mbez mbi' loo nu' indxàalte quix nu' cón che'n contribución loo mbi' co' lèe Ces co' nac gobiern co' ndyub ciuda Rom. No ale yende cón ndxòn mbi'. Mbez mbi' le' mbi' nac Crist, co' nee di's, nac mbi' rey. ");
INSERT INTO zamNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Sya, mnibdi's Pilat loo Jesús. Ndxab Pilat: ―¿Ché', lìcque', lùu nac rey co' ñibe' loo mèn nación Israel, cà'? Jesús mcàb. Ndxab Jesús loo Pilat: ―Aa. Lùu yub ngue beza loon nalle'. ");
INSERT INTO zamNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ngoloa, sya, ndxab Pilat loo mèn co' ngòc jef co' más ñibe' loo nguley' no loo rye mèn co' ngureri': ―Indxegaade nec thìb xquin mbi' ndxè' loon, cara. ");
INSERT INTO zamNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Per mèna sate más mbli par ngola's Pilat di's co' mbez mèn. Mbez mèna loo Pilat: ―Mbi' ndxè' ngue lu' xley' mbi' loo mèn par mtlo mèn, mbos xtùuz mèn no mse' mèn mod co' ndxàp mèn, mèn co' nac mèn rye yèezya' che'n làaz mèn jude, por cón che'n con' co' ngue lu' mbi' loo mèna. No nalle' mtlole' mbi', ndlu' mbi' mèn par ned le'n yèezya' co' nac ned yèezya' che'n làaz mèn galile. Más de cona, mtlole' mbi', ngue lu' mbi' xley' mbi' loo mèn par nedrè', ne. ");
INSERT INTO zamNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Co'se' mbìn Pilat di'sa, mnibdi's Pilat loo mèna: ―¿Ché' nac mbi' ba' mèn che'n làaz mèn galile, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Co'se' ndxab mèn loo Pilat: Aa, nacque' mbi' mèn che'n làaz mèn galile, mtel' Pilat mèn par mbe' mèn Jesús loo Herod tac Herod ngòc gobernador co' mnibe' loo mèn yèezya' che'n làaz mèn galile. No le'xque' le'n huiza ngo Herod le'n ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Co'se' gunèe Herod Jesús, anze'f mdyac lezo' Herod. Tac ndxàcle' tiemp anze'f mblya's Herod hui' Herod loo Jesús. Ante ndxòn Herod cón che'n Jesús no maste. No mbez Herod ndoore': ¿Pól zin thìb huiz no zin thìb ze hui'en loo Jesús no li Jesús thìb yalguzye' loon? ");
INSERT INTO zamNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herod mnibdi's huax con' loo Jesús. Per Jesús yende cón mcàb. ");
INSERT INTO zamNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ngure mèn co' ngòc jef co' más ñibe' loo nguley' no mèn co' ngòc maistr co' mblu' cón che'n ley co' mxo'f Moisés loo mèn tiempa loo Herod. Mèna sate más mquexù' mque' fals Jesús thìb mod tedib mod loo Herod. ");
INSERT INTO zamNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Sya, mtlo Herod, no mtlo solndad co' mque no Herod, mbli Herod ngòc nguàal con' con Jesús con solndad co' ngure no Herod. Ale asembli Herod, mnibe' Herod loo solndad par mtegoc solndad Jesús thìb ned lar' co' nabe's natoxcua' xal xab rey. Ngoloa, mbere Herod, mtel' Herod solndad, mbe' solndad Jesús loo Pilat tedib vez con mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Leque huiza mbere Herod, ngòc amiu Herod con Pilat tedib vez tac ndoore' gàc con'a yende mod ñèe Herod loo Pilat tac ngòc Pilat ngolo ngola's che'n Herod. ");
INSERT INTO zamNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Sya, mbli Pilat mandad mqueltàa rye jef co' más ñibe' loo nguley', no mèn nac zin', no taamas mèn co' nziri' loo Pilat. ");
INSERT INTO zamNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ndxab Pilat loo rye mèna: ―Gu' mbi'th no mbi' ba' loon. Mbez gu' le' mbi' ngue li le' mèn ndxos xtùuz no ndli mbi' nzi yátbèe mèn par nzi li mèn ngòc nguàal con'. Per gu' nonque' no nda'que' gu' cuent le' daa mbral nole' cón che'n mbi' ba' loo gu'. Gu' ñee yende chó xquin mbi' no yende chó xtol mbi' co' ndli par yigaa mbi' loon xalque' nac con' co' mbez gu' ndli mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","No ne' ne' loo Herod ngagaa mbi' loo xquin mbi' no xtol mbi'. Ndxe'leque', mtel' Herod mbi' loon tedib vez. Ngolo gunee gu' yende cón tar li mbi' par naquinque' gath mbi' no zyál'que' gath mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Per nalle', daa ñibe' loo solndad ya ta' solndad che'n mbi'. Yiloa, la'en bii mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Cad lin' co'se' ndli mèn nación Israel lni pasc, mque no mèna thìb costumbr. Le'n huiz lnia ntelá' gobiern thìb pres. Cona, le'n huiz lnia mnibe' mèna loo Pilat telá' Pilat thìb pres co' ngue lezi'f co' ndlya's mèna lyá'. Pilat mblya's ntelá' Pilat Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Per ryete mèna thidte mcàb, ngrozèe mèna. Ndxab mèna loo Pilat: ―Fcàa mbi' ba'. Beth thidtene. Más huen bla' ryo' Barrabás par bii Barrabás. ");
INSERT INTO zamNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mèn nac zin' mque' Barrabás lezi'f por thìb revuelt co' mbli Barrabás le'n ciuda Jerusalén no por thìb mèn co' mbeth Barrabás. ");
INSERT INTO zamNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat mbere ndxab loo mèna: ―Na ndlyazque' làan Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Per mèna sate más cabii mbez yèe loo Pilat. Mbez mèna: ―Fque' U' mbi' ba' loo cruz. Fque' U' mbi' ba' loo cruz. ");
INSERT INTO zamNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sya, mbyon vez ndxab Pilat loo mèna: ―¿Chonon ndlya's gu' ñibe'en loo mèn par que' mèn Jesús loo cruz? ¿Chó con' ye'rsin' mbli Jesús, à'? Yende chó xquin no xtol Jesús ndxegaa loon par, con provech, ñibe'en loo mèn guth mèn Jesús. Xalque' niin loo gu'a, na ñibe' loo solndad ya ta' solndad che'n Jesús. Yiloa, ñibe'en loo gu': La' gu' bii Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Per mèna thidte ngòc. Tolo mbli nèe mèna mna'b mèna di's loo Pilat par ñibe' Pilat loo mèn que' mèn Jesús loo cruz. No axta con gust ngrozèe mèna, no mèn co' ngòc jef co' más ñibe' loo nguley', tac mblique' Pilat con' co' mblya's mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ale mnibe' Pilat lezo' Pilat li Pilat co' lya's mèna li Pilat. ");
INSERT INTO zamNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Sya, mnibe' Pilat loo mèn par ngua lo' mèn Barrabás lezi'f, Barrabás co' ndxab mèn ryo' lezi'f. Barrabás mque' lezi'f por revuelt co' mbli Barrabás no por mèn co' mbeth Barrabás. Ngoloa, mda' Pilat Jesús loo mèna. Nee mèna cón li no mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Co'se' nda no mèna Jesús par que' mèna Jesús loo cruz, ale mbree mcà mèna thìb mbi' co' ngòc mèn che'n làaz mèn ciren. Mbi'a ngro' lèe Mon. Le'pe' ndxàc con'a ndye'th mbi', ngua mbi' huan. Ale asal too mbi' mèn co' nda nque Jesús loo cruz, mnibe' yèe mèna loo mbi' par hue' mbi' cruz che'n Jesús no tyoo nque mbi' xís Jesús ned nda Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Anze'f thìb mènbi' nda nque xís Jesús. No anze'f huax mèngot nda nque xís Jesús. Mèngota mbín' no mbez yèe yath mèngota gunèe mèngota Jesús tant nxi lezo' mèngota ñèe mèngota cón gàc loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Per Jesús mbui' loo mèngota. Ndxab Jesús: ―Mèngot che'n ciuda Jerusalén, ne'gón'te gu' no ne'tyóode gu' por cón chenen, ey. Más huen ften' gu' no bín' gu' por cón che'n con' co' gàc loo gu' no por cón che'n con' co' gàc loo xin' gu' yiloa. ");
INSERT INTO zamNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tac zin thìb huiz no zin thìb ze co'se' gab mèn: Huen nda mèn co' ne'gácte tyan xin'. No huen nda mèn co' thidteneque' ne'nquée loode xin'. No huen nda mèn co' thidteneque' ne'ngàazte xin'. ");
INSERT INTO zamNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Huiza tlo mèn, gab mèn loo yii no loo den: ¿Cón ngàc yii no den ba'? ¿Cón gàc huan ba'? Ale huen gàc lyàa yii ba' no den ba' loo na' par guth yii ba' no den ba' na' leque yigaa na' loo mèn ye'rsin' co' yi'th yé' huize'. ");
INSERT INTO zamNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tac chele' mèn guthxù' daa, daa co' nac xal thìb xan' yaa nayèe, ale'que' gu', mèn ciuda Jerusalén, masre' con' ye'rsin' ne' gàc li mèn loo gu', gu' co' nac xal thìb xan' yaa biiz. ");
INSERT INTO zamNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nda no mèna chop mbi'guth mèn con Jesús par thidte junt guth mèna ryop mbi'a con Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Co'se' mzin mèna con Jesús loo thìb dèn co' mbez mèn tiempa lèe quèe yéc mèn, tya mque' mèna Jesús loo thìb cruz. Mque' mèna ryop mbi'guth mèna loo cruz cuat Jesús, ne. Thìb mbi' mquée loo cruz ladlì cuat Jesús. Tedib mbi' mquée loo cruz ladrebes cuat Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Láth ngue que' mèna Jesús loo cruz, ndxab Jesús loo Diox: ―Pay, fton' U' xquin mèn ndxè' no xtol mèn ndxè' tac prob mèn ndxè' ne'ñeede no ne'ta'de mèn cuent cón ngue li no mèn ndxè' daa. Le' solndad na, mdith no dad loo xab Jesús par ñee solndad ñeene' chó solndad li gan gàc che'n solndad xab Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Huax mèn ngure tya. Nzi hui' mèn xal ndxàc mèna ngue que' mèna Jesús loo cruz. No axta mèn nac zin' che'n ciuda Jerusalén mxìis no Jesús hora. No ngòo xyàn lezo' mèna ñèe mèna Jesús. Mbez mèna loo xtàa mèna: ―Mbi' ba' mtelá' chol mèn loo yaltìi no loo con' ryes. Per nase ndlya's na' hui' na' leque mbi' li par lyàa mbi' co'te' ngue mbi' ba'. No leque mbi' li par lyá' mbi' loo con' ryes chele' mbi', lìcque', nac Crist co' Diox mcui par xo'f zin' mbi' thìb zin' co' ñibe' Diox loo mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ale note solndad co' nziri' tya, mxìis no Jesús. Ale mbii gax solndad loo Jesús. No mda' solndad thìb loo vin co' nac vin nala par ngu yèe Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","No mbez solndad loo Jesús: ―Chele' lùu nac rey co' ñibe' loo mèn nación Israel, leque lùu bli par lyàal co'te' nguel ba'. ");
INSERT INTO zamNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","No mbli Pilat mandad par mque' mèn plá di's loo thìb le' ye's loo cruz gáp loo yéc Jesús co' ngòc di'stèe grieg no di'stèe latin no di'stèe hebre co' mbez: Mbi' ndxè' nac rey co' mnibe' loo mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Làth xtau'a, thìb mbi'guth mèn co' mque' loo cruz cuat Jesús, asembli mbi', mbez mbi' ngòc nguàal di's loo Jesús. Ndxab mbi': ―Chele' lùu, lìcque', nacpe' Crist, leque lùu bli par lyá'l no bli par lyá' nu', ne. ");
INSERT INTO zamNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Per tedib mbi' co' ngue tedib lad cuat Jesús mbyoo xtàa mbi'. Ndxab mbi' loo xtàa mbi': ―Tua'le' nguel co'te' nguel ba'. No ¿be' ncàb rol loo Jesús, cà'? Inzyebtel ñèel Diox, ndee. ");
INSERT INTO zamNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Part cón che'n na', mzyalque' na'i, ngue na' trè'. Ngue guix na' xquin na' por cón che'n con' ye'rsin' co' mbli na'. Per prob mbi' ba' yende chó con' ye'rsin' mbli mbi'. No ngue mbi' co'te' indxàalte quée mbi'. ");
INSERT INTO zamNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sya, ndxab mbi' ropa loo Jesús: ―Tad Jesús, fte' lezo' U' cón chenen co'se' gàc tiemp co' ñibe' U' loo mèn loo izlyo' ndxè', ndee U'. ");
INSERT INTO zamNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús ndxab loo mbi'a: ―Lìcpe' ba'i, na ngue nii lool: Leque nalze yòo nol daa co'te' nac parais. ");
INSERT INTO zamNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hora casque' nde yáal rol huiz. Leque hora, dib athu loo izlyo' mcuau tac mcuau loo huiz. No axta hor mquée guyon bzyè mbembìi loo huiz. Mtenìi huiz loo izlyo' tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Leque hor co' mcuau loo huiza, Diox mbli ale mbryed grolthe vel co' ngue le'n templ tiempa. ");
INSERT INTO zamNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sya, ngrozèe yath Jesús. Ndxab Jesús loo Diox: ―Pay, yey, nase fcàaya' U' alm daa no xpii daa. Ngolo ndxab Jesús di'sa, chàa, nguth Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Co'se' gunèe capitán che'n ciuda Rom ngòc con' ryes tín'a, ndxab capitana: ―¡Ay, Dio's! Lìcpe' ba'i, mbi' ba' ngòc mbi' nalì no mbi' nambìi loo U', Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ryete mèn co' ngure tya, mèna gunèe rye con' ngòc. Mxen mèna ned, ndyàa mèna. No taa nguin mèna ya' mèna pech mèna. Mbez mèna: ¡Ay, Dio's! ¿Xá ñaa con' ngòcle'? tant nzyeb mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Per ryete mèn co' mblibe' Jesús, no mèn co' huen huen mda' cuent cón che'n Jesús, no ryete mèngot co' mdoo nque xís Jesús axta co'se' ngro' Jesús le'n yèezya' che'n làaz mèn galile, mèna ngure tith loo Jesús par mbui' mèna con' co' ngòc loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ngolo ngòc ryethe con'a, mbi'th thìb mbi' co' ngro' lèe Chè. Mbi'a ngòc mbi' yèez Arimate co' nac thìb yèez che'n làaz mèn jude. Ngòc mbi'a thìb jef loo mèn nación Israel. Ngòc mbi' mbi' ndac no mbi' nalì no mbi' nambìi loo Diox, ne. ");
INSERT INTO zamNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Chèa ndub quee lezo' pól gàc tiemp co'se' ñibe'pe' Diox loo mèn. Por cona, ne'ngòode lezo' Chè thidte ngàc Chè con mèn co' mqueltàa co' thidte ngòc par mbli mèn con' ye'rsin' loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ngolo nguth Jesús, negadi's ngua Chè loo Pilat par mna'b Chè loo Pilat ta' Pilat lugar teche Chè thebol Jesús loo cruz. Mda'que' Pilat lugar loo Chè. ");
INSERT INTO zamNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ngolo mteche Chè thebol Jesús loo cruz, mchi'x Chè thìb sab lad thebol Jesús. Ngoloa, ngua lo Chè thebol Jesús le'n thìb ye'r quèe co' mden' mèn ndoore'. Le'n ye'r quèea yende chó thebol tarte ca's mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Huiz co'se' ngòc ryethe con' tín'a loo Jesús, huiza ngòc huiz vispr co' ngòc huiz yub lni che'n pasc. Hora, casque' ndub bix huiz no nde zèle' izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ryete mèngot co' ngro' no Jesús le'n rye yèezya' che'n làaz mèn galile, ryete mèngota ngua tee hui' ro ye'r quèe. No mbui' mèngota xá mod mchi'x Chè sab lad thebol Jesús no xá mod mblo Chè thebol Jesús le'n ye'r quèea. ");
INSERT INTO zamNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Co'se' mbere mèngota, ndye'th mèngota par liz mèngota, mbli nab mèngota perfum no te perfum. Ngoloa, mbli mèngota descans huiz sabda tac huiza ngòc huiz co' ndli mèn descans xal mnibe' ley co' mxo'f Moisés loo mèn nación Israel tiempa. ");
INSERT INTO zamNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Co'se' nde yinìi izlyo' huiz doming co' nac ner huiz che'n sman, tatabe' ñaa mbe'th izlyo' ngua rye xa'gota ro ye'r quèe lyo' co'te' mca's mèn thebol Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mbe' mèngota te perfum co' mtoxcua' mèngota ro ye'r quèe lyo'a par tà mèngota tea lad thebol Jesús. Co'se' mzin mèngota ro ye'r quèe lyo', ale ndoo xal' ro ye'r quèe lyo'. ");
INSERT INTO zamNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mèngota ngòo le'n ye'r quèe lyo' par hui' mèngota máa thebol Tad Jesús. Per co'se' ngòo mèngota le'n ye'r quèe lyo'a, ya yende thebol Jesús le'n ye'r quèe lyo'. ");
INSERT INTO zamNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ale mzyeb mèngota no mbos xtùuz mèngota axta ne' ne' ñee mèngota cón li mèngota co'se' gunèe mèngota ndoo chop xa'bi' loo mèngota. Noc xab xa'bi'a thìb xab co' ante nquée xnìi. ");
INSERT INTO zamNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","No de tant mzyeb mèngota co'se' gunèe mèngota xa'bi'a, mblàa quèe mèngota yéc mèngota par loo yòo. Sya, ndxab xa'bi'a loo mèngota: ―¿Chonon nde cua'n gu' Tad Jesús co' ngue tee banle', à', yey? ");
INSERT INTO zamNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yende Tad Jesús trè', ey. Tad Jesús ngro xbanle'. Fte' lezo' gu' xal ngòc di's co' mda' Tad Jesús cuent loo gu' co'se' ngo no Tad Jesús gu' le'n yèezya' che'n làaz mèn galile thìb cua'a, ");
INSERT INTO zamNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","co'te' mda' Tad Jesús cuent loo gu' le' Tad Jesús co' mbi'th yáal loo izlyo' xalque' ndxáal chol mèn, Tad Jesús yigaaque' ya' mèn ye'rsin'. No que'que' mèna Tad Jesús loo cruz. No yilo son huiz ryo xban Tad Jesús làth mèn nguth. ");
INSERT INTO zamNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Axta syare' mte' lezo' mèngota di's co' mdoodi's Jesús loo mèn le'n yèezya' co' nac yèezya' che'n làaz mèn galile. ");
INSERT INTO zamNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Co'se' mbere mèngota, ndye'th mèngota, ngua mèngota ro ye'r quèe co'te' ngua ca's Chè thebol Tad Jesús, mda' mèngota cuent con' ngòc loo mèngota loo rye si' fthìb myen' xin' mté'th Jesús co' hue' di's no co' te'th di's cón che'n Tad Jesús loo mèn loo izlyo' no loo taamas mèn co' ne'nqueltàa node myen' xin' mté'th Jesús hora. ");
INSERT INTO zamNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mèngot co' ngua ta' cuent no co' ngua te'th loo ryete si' fthìb myen' xin' mté'th Jesús, mèngota ngòc Mari che'n yèez Magdala, no tedib xa'got co' ngro' lèe Juan, no tedib Mari co' ngòc xna' Cob, no taamas mèngot co' mqueltàa no mèngota. ");
INSERT INTO zamNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Per ndxe'leque', myen' xin' mté'th Jesús mxac ale mquée mbii yéc mèngota, cona, tataa mbez mèngota. No ale ne'ngala'ste myen' di's co' mda' mèngota cuent loo myen'. ");
INSERT INTO zamNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mastale' ne'ngala'ste rye myen' di's co' ndxab mèngota loo myen', per Pedr ngro', mxen Pedr ned. Ngua tee hui' Pedr ro ye'r quèe lyo'. Co'se' mzin Pedr ro ye'r quèe lyo', huen huen mbui' Pedr. Gunèe Pedr ante sab co' mchi'x Chè thebol Jesús nax thìb lad le'n ye'r quèea. Ndye'th Pedr par liz Pedr. No ante mbui' no ante gunaa Pedr. No anze'f ndyóo Pedr cón che'n con' co' ngòc. ");
INSERT INTO zamNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Leque huiza mdoo chop myen' xin' mté'th Jesús ned. Ndyàa myen' par thìb yèez co' ngro' lèe Emaús. Yèeza nziri' thìb distans co' ne' si' fchop kilometr par co'te' nziri' ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nda toodi's ryop myen' cón che'n con' co' ngòc loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Láth ndyoodi's ryop myen'a thìb con' no tedib con' cón che'n con' mbli no mèn Jesús, chàa, ngro' too yub Jesús loo ryop myen'a. Nda no Jesús ryop myen'. ");
INSERT INTO zamNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mastale' ngüi' ryop myen' loo Jesús, ale ngòc tont myen'. Ne'nglibe'de myen' no ne'nda'de myen' cuent le' Jesús nac mbi' co' nda no myen'. ");
INSERT INTO zamNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Láth nda tee no Jesús myen', mnibdi's Jesús loo myen'. Ndxab Jesús: ―¿Chó cuent ndyoodi's gu' láth ndoo gu' ned, ndye'th gu', yey? ¿Chonon nalyat nde'b ro gu', à'? ");
INSERT INTO zamNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","De loo ryop myen'a, thìb myen' co' ngro' lèe Cleof mcàb loo Jesús. Ndxab Cleof loo Jesús: ―Ryete mèn non cón che'n con' co' ngòc le'n ciuda Jerusalén le'n huiz ndxè' no maste. ¿Ché' angoluxte lùu nac mbi' co' ngo tya co' inonte cón che'n con' co' ngòc, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Sya, ndxab Jesús loo ryop myen': ―¿Cón ngòc, yey? Cleof ndxab loo Jesús: ―Cón che'n con' ngòc loo Jesús co' ngòc mbi' yèez Nazaret, yey. Jesús ngòc thìb mbi' co' mde'th di's co' ndxab Diox. No ngòc Jesús thìb mbi' roo mbi' xèn loo Diox no loo mèn loo ryethe con' mbli Jesús no ryete di's co' mdoodi's Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","No ale mbli rye mèn co' nac nguley' no mèn co' nac gobiern loo nación na' par mcua'n mèna mod mda'xù' mèna Jesús leque loo xtàa mèna. No mquexù' mque' fals mèna Jesús. Ngoloa, ngua que'xù' mèna Jesús loo cruz axta nguth yub Jesús loo cruz. ");
INSERT INTO zamNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nu' ngure quee lezo' le' Jesús li par co' Jesús no teche Jesús mèn nación Israel la's ya' mèn co' nac ngolo ngola's che'n mèn nación Israel. Per más de cona, nalze ngolo son huiz ngòc con'a. No mca's mèn Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nalxtil', tatabe' ñaa mbe'th izlyo', ndxep mèngot co' mqueltàa no nu' ngua ro ye'r quèe lyo' co'te' mca's Chè thebol Jesús. Mèngota mzeb nu' goze xtil'a. No mbli mèngota ante mbui' nu' no ante gunaa nu'. ");
INSERT INTO zamNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mda' mèngota cuent loo nu' le' mèngota ne'ngnèede thebol Jesús le'n ye'r quèe lyo'. Más de cona, mda' mèngota cuent loo nu' mxyo'f loo chop angl loo mèngota. No ndxab angl loo mèngota le' Jesús naban. ");
INSERT INTO zamNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ngoloa, lueg lueg mxen plá myen' co' ndxàc xtàa nu' ned. Ngua tee hui' myen' ro ye'r quèe lyo'a. No gunèe myen', lìcque', naca xal mda' mèngota cuent loo nu'. Per ne' myen' ne'ñèede máa Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Sya, ndxab Jesús loo ryop myen'a: ―Aa que naad gu'se. Inda'de gu' cuent cón che'n di's co' mbìn gu'. Tarte ya'x xnìi yéc gu' no tarte ya'x xnìi lezo' gu'. Tatabe' naad gu' no nguud gu' par yila's gu' rye di's co' mde'th mèn co' ndxab Diox póla cón che'n Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ché' ndli gu' cuent inaquinte tataa ndactìi Crist ryethe con'a ndoore' yòo Crist loo bé' par gàc con' roo con' xèn loo Crist, cà'? ");
INSERT INTO zamNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Sya, mtlo Jesús, mda' Jesús cuent cón che'n di's co' ndub loo rye libr co' nac xti's Diox co' nda' cuent cón che'n Jesús. Mtlo Jesús con libr che'n Moisés. Be' taa be' taa tolo mda' Jesús cuent loo ryop myen' xal mda' rye libr co' mque' mèn ye's, mèn co' mde'th di's co' ndxab Diox cuent cón che'n Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Co'se' nda zin gax myen' ro yèez co'te' zin myen', Jesús mbli xal mèn co' be' tyoo ned nda. ");
INSERT INTO zamNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Per ryop myen'a mbli fuerz mbyan' Jesús. Ndxab myen' loo Jesús: ―Byan' no nu', mbi'. Izlyo' mzyèle'. No ndele' yál' izlyo', yey. Sya, mbyan' no Jesús myen' liz myen'. ");
INSERT INTO zamNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Láth ndub no Jesús ryop myen' loo mes par hua rsè no Jesús myen' sa yèth, mxen Jesús yèth. Ndxab Jesús loo Diox: Diox quix U', Diox, nu' hua rsè sa yèth. Sya, mbli rol Jesús yètha. Mda' Jesús rolgà yètha loo ryop myen'a. ");
INSERT INTO zamNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Leque hora, ale chàa, mdyub xnìi yéc myen' no, chàa, mdyub xnìi lezo' myen'. Syare', mda' myen' cuent le' mbi'a nac Jesús. Texal mda' myen' cuent le' mbi'a nac yub Jesús, chàa, mdyon' Jesús loo ryop myen'. ");
INSERT INTO zamNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Sya, ndxab thìb myen' loo xtàa myen': ―¿Ché' ndyacl ne'ngda'de gust lezo' na' no ne'ngye'thte lezo' na' co'se' mbìn na' mda' mbi' cuent loo na' no ngue go xo'f mbi' cón che'n di's co' ndub loo libr co' nac xti's Diox loo na' co'se' mdoodi's no mbi' na' ned ndye'th na', cà'? Lìcque', axta gust mbyan' lezo' na' co'se' mbìn na' di'sa, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Le' sya, leque hora, yende izlyo', mxen ryop myen' ned. Mbere ryop myen' nda myen' par ciuda Jerusalén par ngua sál' myen' taamas myen' xin' mté'th Jesús tya. No ngua ta' myen' cuent loo ryete si' fthìb myen' xin' mté'th Jesús no taamas mèn co' mqueltàa no myen' xin' mté'th Jesús le'n ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Sya, pente ngòo ryop myen' le'n nyòo co'te' nzo si' fthìb myen' xin' mté'th Jesús. Sangmtlo myen' xin' mté'th Jesús, mda' myen' xin' mté'th Jesús cuent loo ryop myen'a: ―Lìcpe' ba'i, Tad Jesús ngro xbanle'. No más de cona, Mon gunèele' Tad, cara. ");
INSERT INTO zamNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Syare', noo noo mtlo ryop myen', mda' myen'a cuent loo myen' xin' mté'th Jesús xal ngòca loo myen' co'se' mdoo ryop myen' ned ndyàa myen' par yèez Emaús no xá mod mblibe' myen' Jesús. No mda' myen' cuent le' Jesús ngòc mbi'a co'se' mbli rol mbi'a yèth. ");
INSERT INTO zamNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tatabe' ngue ta' ryop myen'a cuent con' co' ngòc loo myen'a loo myen' xin' mté'th Jesús co'se', chàa, ngro' too Jesús loo rye myen'a. No gunii Jesús Diox loo myen'. Ndxab Jesús loo myen': ―Ftac lezo' gu' axta plóthe no blec see tee lezo' gu', ndee gu', ey. ");
INSERT INTO zamNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Per myen' xin' mté'th Jesús no mèn co' nziri' no myen'a anze'f mzyeb axta ne' ne' ñee myen' no axta ne' ne' ñee mèna cón li myen' no cón li mèna. Tac mbli ryete mèn xtùuz le' thìb xpii mbyu' loo loo mèna co'se' gunèe mèna ngro' too Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Per Jesús ndxab loo ryete mèna: ―¿Chonon nzyeb gu', ey? ¿Chonon nzi gàn lezo' gu' no ndxàc chop lezo' gu', à'? ");
INSERT INTO zamNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Hui' gu' la's yan no hui' gu' niin. Yub daa ndoo loo gu'. Buàal gu' daa. No huen huen hui' gu' loon. Thìb xpii ingue node bél'yòo. No ne' ne' ingue no xpii zith xal ngüi' gu' loon ndoon trè'. ");
INSERT INTO zamNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ngolo ndxab Jesús di'sa loo mèna, mblu' Jesús la's ya' Jesús. No mblu' Jesús nii Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Per co'se' ñèe Jesús le' myen' xin' mté'th Jesús no mèna tarte yila's di's co' ngue bez Jesús loo myen' no loo mèna tant ndyac lezo' myen', no tant ndyac lezo' mèna, no tant ngüi' no ñaa myen' no mèna cón che'n Jesús, Jesús ndxab loo myen' xin' mté'th Jesús no loo mèna: ―¿Ché' nzo chó con' ngue no gu' co' mbyan' xo'f par huana trè', ey? ―Aa. Nzoca, ndxab myen' xin' mté'th Jesús loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sya, mda' myen' thìb le' bél' mbèel mbye'x loo Jesús no mda' myen' thìb le' mcu's co' nzo mzin loo Jesús par nduhua Jesús. ");
INSERT INTO zamNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Mxen Jesús mbèela no mcu'sa. Nduhua Jesús con'a loo myen'. ");
INSERT INTO zamNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ngoloa, ndxab Jesús loo mèna: ―Con' co' mxaclen ndxè' co' gunèele' gu', le'i ngòc loon xal mdoodizlen loo gu' co'se' be' ngo non gu' ndoore' gàca loon. Ngòc con'a loon par ngòcque' no mdyaaque' no mdyubque' di's ryete di's co' ndub loo libr co' nac ley co' mxo'f Moisés loo mèn cón chenen. No mdyaaque' ryete di's co' mque' ryete mèn co' mde'th di's co' ndxab Diox ye's cón chenen, no xal nac di's co' ndub loo libr che'n Salmos cón chenen. Le'i ngòcque' loon. ");
INSERT INTO zamNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Axta syare' mbli Jesús gan nguàa'd myen' xin' mté'th Jesús di's no mda' myen' cuent cón che'n di's co' ndub loo libr co' nac xti's Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ndxab Jesús loo myen', ne: ―Tataa ndub di's loo libr co' nac xti's Diox le' Crist mquinque' gath. No yilo son huiz co' nguth Crist, naquinque' ngro xban Crist làth mèn nguth. ");
INSERT INTO zamNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tolo ndxab Jesús loo myen': ―No nalle', por derech, naquinque' te'th mèn no co mèn yalbàn cón chenen loo mèn rye nación co' nziri' dib athu loo izlyo'. Tlo mèn te'th mèn cón chenen par ned ciuda Jerusalén. Gab mèn no te'th mèn cón chenen loo mèn co' ndxàp xquin no co' ndxàp xtol loo Diox par lyàa yéc mèn no lyàa lezo' mèn par tataa mod zye' mod co' ndxàp mèn loo Diox par ton' Diox xtol mèn loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Gu' nac mèn co' ya te'th no co' ya ta' cuent cón chenen tac gu' nonque' no nda'que' gu' cuent ryethe con' cón chenen desde co'se' mtlo mque tee'en axta co'se' nguth daa no ngro xban daa. ");
INSERT INTO zamNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Hui' gu' nexa. Daa ñibe' lyàa Xpii Natú' loo gu' co' mcàbgòn xuden Diox lyàa loo gu'. Per ndlyazen cued gu' le'n ciuda Jerusalén ndxè' axta zin huiz no zin ze co'se' gàc huiz co' lyàa Xpii Natú' loo gu'. Xpiia ryo' loo bé'. Xpii Natú'a lyath no gu' par gác li gu' con' roo no con' xèn loo mèn ned ya que tee gu' por cón che'n con' roo no con' xèn co' nzo la's nii Diox no co' nzo la's ya' Diox. ");
INSERT INTO zamNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ngolo mdoodi's Jesús ryete di'sa loo myen', mbe' Jesús myen' xin' mté'th Jesús thìb lad ro ciuda Jerusalén gaxte co'te' nziri' yèez Betañ. Tya, mblit Jesús ya' Jesús loo myen'. Mde'f Jesús ya' Jesús loo myen'. Tataa mbli Jesús par mblu' Jesús loo myen' le' Jesús lique' huen ya myen' ned ya myen' yiloa. ");
INSERT INTO zamNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Láth mde'f Jesús ya' Jesús loo myen', xèegà xèega mquée Jesús gáp loo bé'. Mquée Jesús loo bé' loo myen'. ");
INSERT INTO zamNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Le' myen' xin' mté'th Jesús na, mcòo' yéc no mdub xib myen' xin' mté'th Jesús loo Jesús láth nda quée Jesús loo bé'. No ngurez myen' Diox. Ngolo ngurez myen' Diox, ndyac tín' lezo' myen'. Ngoloa, mbere myen', ndye'th myen' par ned le'n ciuda Jerusalén tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","No toloque' nque tee myen' ndxòo ndryo' myen' le'n templ atate huiz par mbez myen' loo Diox: ¡Ay, Dio's! Susque' con' roo con' xèn ndlu' U' no ngue li U' loo mèn dib athu loo izlyo'. Taandxè'que' gàca.");
INSERT INTO zamNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ndoore' cuec Diox no toxcua' Diox chol con' loo bé' no loo izlyo' nzole' Crist co' mblo xo'f loo mèn cón che'n con' co' ndli Diox xtùuz. Thidte ngo no Crist Diox. No nac Crist co' mblo xo'f loo mèn cón che'n con' co' ndli Diox xtùuz Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Crist thidte ngo no Diox ndoore' gacsua' con' no cuec Diox con' loo bé' no loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mbli Crist par ngure no mbyan' ryethe con' co' nziri', que naca con' co' nzo loo bé', que naca con' co' nziri' loo izlyo'. No yende chó con' co' nziri' no co' mbyan' ne'mbede no ne'ngyan'te chele' Crist ne'nglide par ngurei no par mbyan'a. ");
INSERT INTO zamNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Crist nabanque' thidtene. No ndxàp Crist con' roo con' xèn la's nii Crist no la's ya' Crist par li Crist le' mèn ban no Diox thidtene yiloa. Yalnaban co' nda' Crist loo mèn, yalnabana ndli ntenìi yéc mèn no ntenìi lezo' mèn loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yalnaban co' ndli ndyub xnìi yéc mèn no ndyub xnìi lezo' mèn loo cón che'n Diox, yalnabana ndli par non mèn le' cón che'n xab izlyo' ndli par ndxezi'f no ndxega's mèn loo con' ye'rsin' xal mèn co' ndyee yál' co'se' nacuau yál'. Per mastale' anze'f thìb con' nzo co' mbez mèn nac con che'n xab izlyo', ne'ngácte con' co' nac cón che'n xab izlyo' par tau' con' co' nac cón che'n xab izlyo' loo di's co' ndlu' loo mèn xá mod yòo ban no mèn Diox thidtene yiloa. Thìba con' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Le' tediba na, loo ngòc con' ndxè' ngo thìb mbi' co' mtel' Diox. Mbi'a ngro' lèe Juàn. ");
INSERT INTO zamNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Juàn ngòc thìb mbi' co' mbi'th ta' cuent loo mèn nación Israel cón che'n Crist, Crist co' mbli par mdyub xnìi yéc mèn no par mdyub xnìi lezo' mèn par yila's mèn nación Israel cón che'n di's co' mbi'th ta' Juàn cuent cón che'n Crist co' mblo xo'f loo mèn cón che'n con' ndli Diox xtùuz. ");
INSERT INTO zamNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Inacte Juàn Crist co' mbi'th li par mdyub xnìi yéc mèn no par mdyub xnìi lezo' mèn loo cón che'n Diox. Ndxe'leque', mbi'th Juàn par mbi'th ta' Juàn cuent cón che'n Crist co' mbi'th li par mdyub xnìi yéc mèn no mdyub xnìi lezo' mèn loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Crist co', lìcque', angoluxte nac thidte mbi' co' mbi'th li par tyub xnìi yéc mèn no par tyub xnìi lezo' mèn loo cón che'n Diox, Crist mbi'th yáal loo izlyo' ndxè' xalque' ndxáal chol mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Loo izlyo' ndxè' mbi'th yáal Crist co' mblo xo'f loo mèn cón che'n con' ndli Diox xtùuz. Crist mbli par ngure no mbyan' alux con' co' nziri' loo izlyo'. Per ryethe mèn co' nziri' loo izlyo', ne'nglibe'de mèna chó mbi' nac Crist. ");
INSERT INTO zamNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Loo izlyo' co' nac che'npe' Crist mbi'th Crist. Per mèn co' ngòc mèn gulàazpe' Crist, mèna mcà di's Crist. No mtè'f mèna Crist thìb lad. ");
INSERT INTO zamNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Per ryete mèn co' mdyalque' ngola's loo Crist no loo cón che'n Crist, Diox mblo ro le' mèna ndxàp con' la's nii mèna no la's ya' mèna par gàc mèna xin'pe' Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mèna gàc xin'pe' Diox tac tataa mnibe' Diox no tataa gunee lezo' Diox. Inacta xal mèn co' ndxáal por xud mèn no xna' mèn. Ne' ne' inaca xal nee lezo' thìb mbi' li thìb mbi' con thìb xa'got bin par gàc mèna xin' Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Per Crist co' mblo xo'f loo mèn cón che'n con' co' ndli Diox xtùuz, Crist mbi'th yáal xalque' ndxáal chol mèn loo izlyo' par ngòc Crist xalque' chol mèn loo izlyo'. No mque tee ban Crist làth nu' ndxep tiemp. Látha, gunèe nu' con' roo con' xèn co' mbli Crist co' mblu' loo nu' nacpe' Crist angoluxte xgan'pe' Diox. No gunèe nu', lìcque', anze'f nque' lezo' Crist ñèe Crist mèn. No gunèe nu', lìcque', inquedìide Crist mèn. Ndxe'leque', ndlique' Crist con' co' mcàbgòn Crist li Crist loo mèn. No gunèe nu' le' Crist angndli huax con' ndac loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juàn Bautist mda' cuent cón che'n Crist loo mèn. Cabii ndxab Juàn loo mèn: ―Cón che'n Crist nac co' mdalen cuent loo gu' le' Crist co' nare' yi'th nque xísen, Crist nac más xa' roo xa' xèn leque daa tac Crist nzole' ndoore' gal yáal daa loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Lìcque', anze'f thìb con' ndac angmbli Crist loo na' par gàc con' ndac loo na' thìb mod tedib mod por cón che'n Crist. ");
INSERT INTO zamNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Diox mnibe' loo Moisés par mxo'f Moisés ley loo na'. Per Jesucrist mbi'th par mblu' Jesucrist loo mèn le' Diox, lìcque', nque' lezo' ñèe Diox mèn. No mblu' Jesucrist le' Diox ndlya's li Diox anggàc con' ndac loo mèn. No mblu' Jesucrist loo mèn le' cón che'n Jesucrist nac con' lìcpe'. ");
INSERT INTO zamNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yende chó mèn tarte ñèe xá ñaa loo Diox thidtene. Angoluxte xgan'pe' Diox co' thidte nac con Diox no co' nzoque' loo Diox, xgan' Dioxa mda' cuent no mblo ro xgan' Diox cón che'n Diox loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel, co' nac leque mèn co' ngo ban ciuda Jerusalén, mèna mtel' mèn co' ngòc nguley' no mèn co' ndlyath no nguley' le'n templ par ngua nibdi's mèna loo Juàn ché' nac Juàn Crist. ");
INSERT INTO zamNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juàn mda' cuent loo mèna no mblo ro Juàn. Ndxab Juàn: ―Tyè'. Inacte daa Crist, yey. ");
INSERT INTO zamNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Sya, tolo mnibdi's mèna loo Juàn. Ndxab mèna: ―¿Chó nac lùu, sya? ¿Ché' lùu nac Lii co' mbi'th te'th di's co' ndxab Diox póla, cà'? Juàn mcàb. Ndxab Juàn loo mèna: ―Tyè'. Inacte daa Lii. Sya, mbere mèna, mnibdi's mèna tedib vez loo Juàn: ―¿Xá neel, sya? ¿Ché' lùu nac mbi' co' te'th di's co' ndxab Diox co' ndxath yi'th, cà'? Juàn mcàb. Ndxab Juàn: ―Yende xàa. Inacte daa mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mbere mèna, ndxab mèna loo Juàn: ―¿Chó mèn nac lùu, sya? Gunee loo nu'. Sya, tataa ta' nu' cuent loo mèn co' mtel' nu'. ¿Xá neel cón che'nl, yey? ");
INSERT INTO zamNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Sya, ndxab Juàn loo mèna: ―Daa nac xal thìb mbi' co' ngue bez cabii co'te' nagán co' mbez loo mèn: Bli le' mèn gàc nab loo cón che'n Tad Diox xal ntelì mèn thìb ned xalque' nac di's co' ndxab Sayi' co' mde'th di's co' ndxab Diox póla. ");
INSERT INTO zamNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mèn co' ndyoo ner, no co' ndyoo naa, no co' ñibe' loo mèn nación Israel, mèn co' ngòc mèn xley' farise, mèna nac mèn co' mtel' ndxep mèn co' ngua toodi's no Juàn. ");
INSERT INTO zamNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Mèna tolo mnibdi's loo Juàn. Ndxab mèna: ―Chele' lùu inacte Crist, ne' ne' inacl Lii, no ne' ne' inacl xa' co' te'th di's co' ndxab Diox co' ndxath yi'th, ¿chonon ndlil bautizar mèn, sya? ");
INSERT INTO zamNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Sya, mcàb Juàn loo mèna. Ndxab Juàn: ―Lìcque', daa ndli bautizar mèn con nít. Per làth gu' nzoque' thìb mbi' co' tarte ta' gu' cuent co' huenleque' chó nac mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mbi'a nac xa' co' nare' yi'th nque xísen. No mbi'a nac más xa' roo xa' xèn leque daa. Mastale' ndli gu' cuent nac daa xa' roo xa' xèn, nden' daa no ndyaquen thidtene inzyál'te daa que tee non mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ryete con'a ngòc thìb lugar co' ngro' lèe Betábara co' nziri' ned ndlyen huiz gaxte ro yó'be' Jordán co'te' ngue li Juàn bautizar mèn tiempa. ");
INSERT INTO zamNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tedib huiz co' nde nquea, gunèe Juàn le' Jesús nde loo Juàn. Ndxab Juàn loo mèn co' nziri' loo Juàn: ―Hui' gu' nexa. Mbi' co' nde go' ne' tedib lèe co' nac lèe Mbacxil' che'n Diox, co' nee di's, tyactìi mbi' ba' par tyon' xtol che'n mèn loo izlyo', mèn co' tyal gòn ro mbi'. ");
INSERT INTO zamNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Cón che'n mbi' ba' nac co' mdalen cuent loo gu' le' xísen yi'th nque tedib mbi' co' nac más mbi' roo mbi' xèn leque daa. Tac ndoore' gal yáal daa loo izlyo' nzoque' mbi' ba' con Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yub daa ne'nglibe'de chó mbi' nac mbi' ba'. Ne' ne' tan cuent chó nac mbi' ba'. Ndxe'leque', mbalen par ndlin bautizar mèn con nít par tataa mod lu'en mbi' ba' loo gu' co' nac mèn nación Israel no par tan cuent cón che'n mbi' no chó nac mbi' ba' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ndxab Juàn loo mèna, ne: ―Daa gunèe ngulàa Xpii Natú' che'n Diox loo bé' loo mbi' ba'. Gunaa Xpii Natú'a xal ñaa thìb palomxtil' hora. No sangngòo Xpii Natú' loo mbi' ba' par mbyan' no Xpii Natú' mbi' ba' par ñibe'pe' Xpii Natú' loo mbi' ba'. ");
INSERT INTO zamNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Per leque hora ne' daa tarte libe' mbi'. Ne' ne' tar tan cuent chó mbi' nac mbi'. Per xa' co' mtel' daa par ndlin bautizar mèn con nít, xa'a gunee loon: ―Co'se' ñèel lyàa Xpii Natú' loo mbi' no sangyòo Xpii Natú' loo mbi' par yan' no Xpii Natú' mbi' par ñibe'pe' Xpii Natú' loo mbi', axta syare' ta'l cuent le' mbi'a nac mbi' co' li bautizar mèn por cón che'n Xpii Natú'. ");
INSERT INTO zamNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tolo ndxab Juàn: ―Daa gunèeque' xal ngulàa Xpii Natú' loo mbi' co' nac Jesús. Cona, ndan cuent no ndethen le' Jesús ba' nacque' xgan'pe' Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tedib huiz co' nde nquea, ngue tee Juàn Bautist leque par neda con chop myen' xin' mté'th Juàn. ");
INSERT INTO zamNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Láth co'se' nde riid Jesús par neda, gunèe Juàn Jesús. Ndxab Juàn loo ryop myen' xin' mté'th Juàn: ―Hui' gu' nexa. Mbi' ba' nac xa' co' mbezen loo mèn nac mbi' co' ne' tedib lèe co' nac lèe Mbacxil' che'n Diox. Tac mbi' ba' tyactìi no gath mbi' ba' por cón che'n xtol mèn xal ndxuth mèn mbacxil' loo Diox nalle' par teri'th tecan' Diox cón che'n xtol mèn nalle'. ");
INSERT INTO zamNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Co'se' mbìn ryop myen' xin' mté'th Juàn tataa ndxab Juàn loo myen', mxen myen' ned. Mdoo nque myen' xís Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Sya, ndxepte mdee myen', mbere Jesús par ned xís Jesús. Gunèe Jesús le' ryop myen' nde nque xís Jesús. Ndxab Jesús loo myen': ―¿Cón ncua'n gu', à', ey? Myen' mcàb loo Jesús. Ndxab myen': ―Maistr, ¿pá mèn U', à'? No ¿chó mèn yèez nac U', ne, à'? ");
INSERT INTO zamNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús mcàb loo myen'. Ndxab Jesús: ―Ya' gu' nda na'. Sya, hui' gu' pá nzon. Sya, mdoo nque myen' xís Jesús par gunèe myen' co'te' nzo ban Jesús. Tya, mbyan' no myen' Jesús yál'a tac hora casque' ngòc hor nquée guthap bzyè. ");
INSERT INTO zamNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Thìb mbi' co' ngola's di's co' ndxab Juàn no nda nque mbi' xís Jesús, mbi'a ngro' lèe Ndech, hues Mon Pedr. ");
INSERT INTO zamNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Sya, yende izlyo', ngua cua'n Ndech Mon, hues Ndech. No ndxab Ndech loo Mon: ―Hues, mzyál'le' nu' mbi' co' nac Mesías, xa' co' nee di's nacpe' Crist, ndyaquen. ");
INSERT INTO zamNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sya, mbe' Ndech Mon loo Jesús co'te' ngo Jesús. No co'se' gunèe Jesús Mon, ndxab Jesús loo Mon: ―Mon, lùu nac xgan' thìb mbi' co' lèe Jonás, ¿lé'? Per nalle' lùu ryo' lèe Cef, co' nee di's, hue'l tedib lèe co' lèe Pedr. ");
INSERT INTO zamNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tedib huiz co' nde nque, Jesús mblya's ya par ned le'n yèezya' co' nac làaz mèn galile. Láth ndoo Jesús ned, mzyál' Jesús thìb mbi' co' lèe Lip. Ndxab Jesús loo Lip: ―Ya' nda na', Lip. ");
INSERT INTO zamNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Lipa ngòc mèn yèez Betsaid co' nac leque yèez che'n Ndech no Pedr. ");
INSERT INTO zamNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Sya, ngua cua'n Lip Natanael. Ndxab Lip loo Natanael: ―Mzyál'le' nu' mbi' co' lèe Jesús. Cón che'n mbi'a nac di's co' mque' Moisés ye's loo libr co' nac ley. No cón che'n mbi'a mque' mèn co' mde'th di's co' ndxab Diox ye's loo libr. Mbi'a nac Jesús, xgan' Chè, co' nac mèn yèez Nazaret. ");
INSERT INTO zamNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Sya, ndxab Natanael loo Lip: ―¿Ché' tác li mèn yèez Nazaret ndxep con' ndac, sya, cà', Lip? Lip mcàb. Ndxab Lip: ―Ya' nda tee hui' na', nexa. Sya, ñeela no yila'sla. ");
INSERT INTO zamNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Co'se' gunèe Jesús nde zin gax Natanael loo Jesús, ndxab Jesús loo mèn co' nziri' loo Jesús cón che'n Natanael: ―Hui' gu' nexa. Mbi' co' nde go' nac mèn che'n nación Israel. No nac mbi' ba' thìb mbi' ndac. Tac mbi' ba' nac thìb mbi' co' thidtene inquedìide xtàa. No ne' ne' indyè' mbi'. ");
INSERT INTO zamNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Sya, ndxab Natanael loo Jesús: ―¿Pá mblibe' U' daa, à', Tad? Jesús mcàb loo Natanael. Ndxab Jesús: ―Daa gunèe lùu co'se' ndubl xàn' yaa ngudyuug co'se' ndoore' cuez Lip lùu. ");
INSERT INTO zamNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mcàb Natanael loo Jesús. Ndxab Natanael: ―Maistr, U' nac xgan'pe' Diox. No nac U' rey che'n mèn nación Israel, ndyaquen. ");
INSERT INTO zamNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Sya, mcàb Jesús loo Natanael. Ndxab Jesús: ―¿Ché' tac guniilen lool gunèenl xàn' yaa ngudyuuga ndxela'sl, cà', Natanael? Lùu ñèe gàc más con' roo con' xèn loon leque con' ndxè' yiloa, ey. ");
INSERT INTO zamNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tolo ndxab Jesús loo Natanael: ―Lìca, na nii lool, no ngue niina loo ryete mèn co' nziri' loon: Desde nalle' par delant, gu' hui' ndoo xal' loo bé'. No hui' gu' xá mod quée no lyàa angl che'n Diox loon, daa co' mbal yáal loo izlyo' xalque' ndxáal chol mèn loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ngolo nguri'th son huiz co'se' mdoodi's Jesús di'sa, mselya' thìb ned myen' le'n yèez Caná co' nac yèezya' che'n làaz mèn galile. Nde nxon', ngo xna' Jesús tya, ne. ");
INSERT INTO zamNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mbli mèn guliza convid Jesús con myen' xin' mté'th Jesús par cue no Jesús myen' co' mselya'a liz myen'. ");
INSERT INTO zamNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Per co'se' gunèe xna' Jesús mbiiz vin co' ngue gui'th mèn loo mèn làtha, xna' Jesús ndxab loo Jesús: ―Mbiizle' vin mèn guliz ndxè', cara. ");
INSERT INTO zamNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Sya, ndxab Jesús loo xna' Jesús: ―Ngot, ¿chonon le'le' lùu más ndyac no ndyóol cón che'n mèn ba', à'? Yende chó cón chenen con lùu con mèn ba'. Tarte gáal hor co'se' tlo lu'en con' roo con' xèn co' nac cón chenen loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Per ndxe'leque', ndxab xna' Jesús loo mèn co' nzi li mandad loo mes: ―Bli gu' rye con' ñee Jesús loo gu', ndee gu'. ");
INSERT INTO zamNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nde nxon', nziri' xop yèt nít tya co' ngòo mèn guliza nít xal nac costumbr co' ndxàp mèn nación Israel par ntech mèn ya' mèn, no par ntech mèn trast co' ndli zin' mèn cusin, no taamas con' co' nac co' ndli zin' mèn. No thìb thìb yèta ndxàalque' ndxòo chop o son rre nít. ");
INSERT INTO zamNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Sya, ndxab Jesús loo mèn co' nzi li mandada: ―Fsè gu' ryete yèt ndxè' con nít. No msè myen' rye yèta con nít axta mxyo'f lal nít loo rye yèta. ");
INSERT INTO zamNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ngoloa, ndxab Jesús loo myen': ―Nalle', blo' gu' ndxep nít le'n yèt ba'. No huàa lá' gu'i loo mbi' co' ndyoo naa loo mèn loo mes. Sya, mbe' myen' níta loo mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Per texal mbli mbi' co' ndyoo naa loo mèn loo yalhua preb nít co' ngòc vina, ngurez mbi' myen' co' mselya'. Tac ne'ñeede mbi' co' ndyoo naa loo mèna pá ned nde nít co' ngòc vina. Per myen' co' nzi li mandad co' mblo' nít, myen'a nanee xá mod ngòcsua' níta vin. ");
INSERT INTO zamNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Sya, ndxab mbi' co' ndyoo naa loo mèna loo mbi' co' mselya'a: ―¿Cón ndxàc, yey? Ryete mèn co' ndli thìb yalhua, ner ngui'th mèna thìb ya' vin co' nac vin más huen loo mèn loo mes. No co'se' nde teele' ndxu mèn co' ngòc convid vin axta plóthe ndlya's mèna, sya, ntlo mèn, ngui'th mèn vin co' nac vin más corient. Per lùu, ale ndxe'leque', nare' ngue gui'thl vin co' nac vin más huen. ¿Chonon tatua' ndlila, ey? ");
INSERT INTO zamNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yalguzye' co' mbli Jesús le'n yèez Caná co' nac yèezya' che'n làaz mèn galile ngòc nerleque' yalguzye' co' mbli Jesús. No por yalguzye' co' mbli Jesús, mtlo Jesús, mblu' Jesús con' roo con' xèn co' ndxàp Jesús la's nii Jesús no la's ya' Jesús. Le' myen' xin' mté'th Jesús na, mtlo ngola's loo Jesús hora. ");
INSERT INTO zamNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ngolo ngòc con'a, nda Jesús par yèez Capernaum con xna' Jesús, no con myen' huespe' Jesús, no con myen' xin' mté'th Jesús. Ngo ban no Jesús xna' Jesús, no myen' huespe' Jesús, no myen' xin' mté'th Jesús pláte huiz le'n yèez Capernaum. ");
INSERT INTO zamNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Le'n huiza, nde zin' gaxle' huiz lnii pasc co' ndli mèn nación Israel. Sya, mxen Jesús ned. Mbii Jesús yèez Capernaum. Nda Jesús par ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Co'se' ngòo Jesús le'n templ, gunèe Jesús nziri' mèn co' ntho' ngon, co' ntho' mbacxil', no co' ntho' palomxtil'. Gunèe Jesús nziri' mèn co' nzi sil' tmi che'n mèn, ne. ");
INSERT INTO zamNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Co'se' gunèe Jesús con'a, mqui's Jesús thìb dó' par mda' Jesús che'n mèn con dó'. Tataa mbli Jesús par mblo' Jesús mèna no má'a par fuer. Le' tmi che'n mèn co' nzi sil' mèn co' nsil' tmia na, ndxecleque' tmia mblobii Jesús. No mtexyath Jesús rye mes mèna loo yòo. ");
INSERT INTO zamNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Le' loo mèn co' nzi tho' palom na, ndxab Jesús: ―Fcàa rye má' ba. Blo' gu' par fuer. Ne'cue tho'de gu' trè' co'te' nac co'te' mbez mèn lèe xuden Diox xal mèn co' ntho' loo thìb xbi'. ");
INSERT INTO zamNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Axta syare' mte' lezo' myen' xin' mté'th Jesús di's co' ndub loo libr co' nac xti's Diox co' nac testamentgool co' mbez: Con' co' ndli más ndyóon no ngue xyàn daa nac ndlyazen le' templ co'te' mbez mèn lèe xuden Diox yumbìi no gàca thìb lugar natú' par cuez mèn lèe xuden Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sya, mnibdi's mèngool co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel loo Jesús. Ndxab mèna loo Jesús: ―¿Chó yalguzye' roo lil loo nu' co' gàc thìb señ par ñee nu' le' lùu, lìcque', ndxàp derech mblil con' mblil ba', à'? ");
INSERT INTO zamNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Sya, mcàb Jesús loo mèna. Ndxab Jesús: ―Gu' telux templ ndxè' no yiloa le'n son huiz leque daa bere xít te'f templ ndxè' tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Sya, chàa, ngro' di's ro rye mèngoola. Ndxab mèna loo Jesús: ―Jaaa. Le'n cho' fxop lín' mblyen' mèn par mxít te'f mèn templ ndxè'. ¿No lùu mbez: Le'n son huiz no maste xít te'fl templ, cà'? Aa, mbi'. ¿Máa yob yéc lùu, na? ");
INSERT INTO zamNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Per ndxe'leque', cón che'n templ co' ngue ta' Jesús cuent loo mèna nac bél'yòo ladpe' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Cona, co'se' ngro xban Jesús làth mèn nguth, axta syare' mte' lezo' myen' xin' mté'th Jesús le' Jesús guniique' di'sa. No tolo ngola's myen' di's co' ndub loo libr co' nac xti's Diox. No tolo ngola's myen' di's co' guniile' Jesús loo myen' le' Jesús guniique' di'sa cón che'npe' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Láth ngo Jesús le'n ciuda Jerusalén le'n huiz lni che'n pasc, huiza huax mèn ngola's loo Jesús no loo cón che'n Jesús por gunèe mèn mbli Jesús rye yalguzye' co' mbli Jesús loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Per leque yub Jesús ne'ngàpte yalxla's loo mèna xal nac mod co' ngòp mèna. Tac Jesús naneeque' no nonque' Jesús xal nac xtùuz rye mèn no xal nac co' nzo le'n lezo' rye mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ne' ne' inquin Jesús ta' chol mèn cuent cón che'n xtàa mèn loo Jesús tac Jesús naneeque' no nonque' Jesús xal nac xtùuz rye mèn no xal nac co' nzo le'n lezo' rye mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ngo thìb mbi' co' ngòc mèn che'n xley' farise. Mbi'a ngro' lèe Nicodem. Ngòc mbi' thìb mbi' co' mnibe', no co' mdyoo ner, no co' mdyoo naa loo mèn nación Israel, ne. ");
INSERT INTO zamNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nicodema ngua too naa Jesús thìb yál'. Látha, ndxab Nicodem loo Jesús: ―Maistr, nu' nda' cuent no nanee nu' le' Diox mtel' U' par gàc U' thìb maistr co' lu' nu'. Tac yende chó mèn tar gác lu' no co' li yalguzye' roo no yalguzye' xèn xal ndli U' chele' Diox indlyath node mèna par li mèna con'a. ");
INSERT INTO zamNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Sya, ndxab Jesús loo Nicodem: ―Lìcpe' ba'i, na nii thìb con' lool, Nicodem: Le' mèn co' ne'tyalte yòo loo cón che'n Diox xal thìb mbetoo' co' diz ngóol, yende mod yòo mèna loo cón che'n Diox par ñibe'pe' Diox loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ndxab Nicodem loo Jesús: ―¿Xá mod gáal thìb mbi' tedib vez co'se' ngoxle' mbi'? ¿Ché' tác yòo mbi' le'n lezo' xna' mbi' par gáal mbi' tedib vez, cà'? Yende xàa. ");
INSERT INTO zamNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús mcàb loo Nicodem. Ndxab Jesús: ―Lìca, na nii lool, Nicodem: Le' mèn co' ne'tyalte gàc mèn men cub loo cón che'n Diox por cón che'n nít no por cón che'n Xpii Natú', mèna yende mod yòo loo cón che'n Diox par ñibe'pe' Diox loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mèn co' ante ngóol xal nac bin che'n bél' lad xud mèn no xna' mèn, mèna alithe nziri' loo cón che'n xab izlyo' ndxè'. Per ndxe'leque', mèn co' mbli Xpii Natú' le' mèna nac mèn cub loo cón che'n Diox, mèna ndoo lìte nzi que tee ban par li mèna xal nac co' ñibe'pe' Xpii Natú' loo mèna par li mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ne'hui'del, no ne'ñaadel, no ne'tyóodel arid cón che'n con' ngue niin lool nalle'. Naquinque' gáal gu' tedib vez xal ngolo guniina lool. ");
INSERT INTO zamNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hui' nexa. Mbii nxyo'f pál co'te' nxyo'f mbii. No ndxònl co'se' ndxa'x nxyo'f mbii, ¿lé'? Per ne'ñeedel pá ned ndryo' mbii. No ne' ne' ñeel pá ned ndyàa mbii. Tataa naca, ne, con ryete mèn co' mbli Xpii Natú' par ngòc mèna mèn cub loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Sya, mbere Nicodem, ndxab Nicodem loo Jesús tedib vez: ―¿Xá mod gàc con'a, yoo? ");
INSERT INTO zamNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús mcàb loo Nicodem. Ndxab Jesús: ―¿Ché' ndyaquen lùu nac ner maistr che'n mèn nación Israel no inontel cón che'n con' ndxè', cà'? ");
INSERT INTO zamNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Lìca, na ngue nii lool: Le' cón che'n con' co' non nu', ndyoodi's nu'. No cón che'n con' co' gunèele' nu', nda' nu' cuent. No ndxe'leque', indxònte gu' di's no indxela'ste gu' di's co' nda' nu' cuent loo gu' no co' ndyoodi's nu' loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Chele' daa tyoodiz no tan cuent cón che'n izlyo' ndxè' loo gu' no ne'yila'ste gu'i, ¿xá mod yila's gu' chele' daa ta cuent cón che'n bé' loo gu', sya? ");
INSERT INTO zamNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Axta nalle' yende chó mèn tar quée loo bé' par té'th mèna cón che'n con' co' ngue niin lool trè', Nicodem. Ndxe'leque', angolux daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo', thidte daa non cón che'n bé', daa co' ngro' le'n bé'. Tac le'n bé' loo bé' nac lizpe' daa, no nac làazpe' daa, no nac loo bé' xnedpe' daa. ");
INSERT INTO zamNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hui' nexa, Nicodem. Nde niin thìb con' lool: Texal mquetal Moisés thìb mbel' loo thìb bro yaa nol' no mdoo Moisés yaaa, ngue tal mbel' loo yaa co'te' nagán, tataaque' naquin que' mèn daa, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo', loo thìb cruz ");
INSERT INTO zamNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","par gàca le' ryete mèn co' tyal yila's loon, Diox ne'quexù'de mèna par co' xà' Diox mèna loo Diox yiloa. Ndxe'leque', mèn co' tyal yila's loon, mèna yòo ban no Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tac Diox axta arid nazin' mèn no nque' lezo' Diox ñèe Diox mèn loo izlyo'. Por cona, mtel' Diox angoluxte xgan' Diox loo izlyo' par gàca le' ryete mèn co' yila's loo xgan' Diox, ne'quexù'de Diox mèna par co' xà' Diox mèna loo Diox yiloa. Ndxe'leque', yòo ban no mèna Diox thidtene yiloa. ");
INSERT INTO zamNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Diox ne'ntel'te xgan' Diox loo izlyo' par quexù' xgan' Diox mèn loo izlyo'. Ndxe'leque', mtel' Diox xgan' Diox loo mèn loo izlyo' par lyá' mèn loo con' ryes por cón che'n xgan' Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mèn co' ndxela's loo xgan' Diox, Diox ne'quexù'de mèna thidtene. Per mèn co' ne'tyalte yila's loo xgan' Diox, Diox ngue quexù'que' mèna por ne'ngala'ste mèna loo mbi' co' nac angoluxte xgan' Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Co'se' mbi'th xa' co' ndli par ndyub xnìi yéc mèn no ndyub xnìi lezo' mèn loo cón che'n Diox, más mda' gust loo lezo' mèn no más mdubla's mèn cón che'n xab izlyo' leque li mèn cas loo mbi' co' ndli par ndyub xnìi yéc mèn no ndyub xnìi lezo' mèn loo cón che'n Diox. Tac ryethe con' ndli mèn nac con' ye'rsin'. No con' co' nda' gust lezo' mèn ndli ngue quexù' Diox mèn loo izlyo'. ");
INSERT INTO zamNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tac ryete mèn co' ndli con' ye'rsin', mèna ndxòo xyàn lezo' ñèe mèna mbi' co' mbi'th li par ndyub xnìi yéc mèn no ndyub xnìi lezo' mèn loo cón che'n Diox. No thidtene ne'ndalte mèna yòo mèna loo cón che'n mbi' co' ndli par ndyub xnìi yéc mèn no ndyub xnìi lezo' mèn cón che'n Diox tac indlya'ste mèn ye'rsin'a ryo xo'f con' ye'rsin' co' ndli mèna loo xnaa. ");
INSERT INTO zamNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Per ndxe'leque', mèn co' nzi tee ban xal nac con' lìcpe', mèna ndyal yòo loo cón che'n mbi' co' ndli ndyub xnìi yéc mèn no ndyub xnìi lezo' mèn loo cón che'n Diox par ndxàc be' mèna le' Diox ndlyath no mèna loo con' ndac co' ngue li mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ngolo nguri'th con'a, ngua Jesús con myen' xin' mté'th Jesús par ned yèezya' che'n làaz mèn jude. Ngo no Jesús myen' tya pláte huiz. Látha, mbli myen' xin' mté'th Jesús bautizar mèn tya. ");
INSERT INTO zamNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juàn Bautist, ne, ngue li bautizar mèn co'te' ndub len nít thìb lugar co' lèe Enón co' nziri' gaxte co'te' nziri' thìb yèez co' lèe Salim tac tya anze'f nal' nít nzo. No huax mèn nde loo Juàn par ndli Juàn bautizar mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Be' ndli Juàn bautizar mèn tiempa tac tarte que' mèn Juàn lezi'f. ");
INSERT INTO zamNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Leque le'n huiza, mque di's myen' xin' mté'th Juàn con plá mèngool co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel cón che'n mod co' mbez mèn ndxàc mèn nambìila's loo xley' mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Sya, ngua myen' xin' mté'th Juàn loo Juàn. Ngua ta' myen' cuent loo Juàn. Ndxab myen': ―Maistr, hui' U' nexa. Mbi' co' ngo no U' tedib lad ro yó'be' Jordán par ned ndlyen huiz, mbi' co' mda' U' cuent cón che'n loo nu'a, mbi' ngue li bautizar mèn. No anze'f thìb mèn ndoo nque xís mbi'. ");
INSERT INTO zamNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mcàb Juàn loo myen'. Ndxab Juàn: ―La' gu'. Tac yende cón gác li mèn chele' Diox ne'nxo'f zin'te thìb zin' loo mèn par li mèn zin'a. ");
INSERT INTO zamNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Leque gu' nda' cuent cón chenen co'se' nambìite ndxaben loo mèn le' daa inacte Crist. Ndxe'leque', Diox mtel' daa par ndal neren loo Crist. ");
INSERT INTO zamNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tolo ndxab Juàn loo myen': ―Nde niin thìb con' loo gu': Xa'bi' co' nac sa'l thìb xa'got, xa'bi'aque' nac sa'l xa'gota. Per thìb xa'bi' co' ndxàc amiu che'n mbi' co' nac sa'l xa'gota, xa'a ndoo tya. No ndoo yòn xa' di's co' ndyoodi's mbi' co' nac sa'l xa'gota. No co'se' ndoo yòn mbi' di's co' ndyoodi's xa'bi'a, anze'f ndyac lezo' mbi' ndxòn mbi' di's co' ndyoodi's mbi' co' nac sa'l xa'gota. Cona, daa, ne, anze'f ndyac lezo' ndxònen cuent co' ngue ta' gu' loon ba' cón che'n mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Por part cón che'n mbi'a, sate más ndoo yàc mbi' mbi' roo mbi' xèn. No thidteneque' naquinque' gàc mbi'a thìb mbi' roo thìb mbi' xèn. Per part cón chenen, ale ndxe'leque', ale xèegà xèegà ya yende cón tolo lin. Ndxe'leque', gàc daa mèn co' iñaade ntac loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ngue niin loo gu': Le' Crist co' ngro' loo bé', Crist ñibe'pe' loo ryethe con'. Per mèn co' ndxáal loo izlyo', che'n izlyo' nac mèna. No cón che'n izlyo' ndyoodi's mèna. Per Crist co' ngro' le'n bé' loo bé', Crist ngüi' ñaa loo ryethe con'. No ñibe'pe' Crist loo ryethe con'. ");
INSERT INTO zamNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ndyoodi's Crist cón che'n con' co' gunèe Crist no cón che'n con' co' mbìn Crist. Per casque yende chó mèn nzo' co' ndxela's cón che'n di's co' mbez Crist no co' nda' Crist cuent loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Per chele' chó mèn yila's di's co' mbez Crist no di's co' nda' Crist cuent loo mèn, leque mèna li nèe xtùuz mèn no li nèe mèn lezo' mèn le' Diox ndyoodi's no nda' Diox cuent ante cón che'n con' co' nac con' lìcpe'. ");
INSERT INTO zamNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tac Diox co' mtel' Crist, Diox mtel' Crist par tyoodi's Crist ante di's co' mnibe' Diox tyoodi's Crist no co' ta' Crist cuent loo mèn. Lomisque' ne, Diox ne'nglàade Xpii Natú' loo Crist xal thìb con' co' nchi'x mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Diox co' nac xud Crist Jesús, Diox anze'f nque' lezo' ñèe Diox Crist Jesús co' nac xgan'pe' Diox. Por cona, mblec Diox ryethe con' no mtan' Diox ryethe con' la's nii Crist Jesús no la's ya' Crist Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Cona, ngue niin: Le' mèn co' ndxela's loo xgan' Diox no loo cón che'n xgan' Diox, mèna yòo ban no Diox thidtene. Per mèn co' ne'tyalte yila's loo xgan' Diox no loo cón che'n xgan' Diox, mèna ne'yòo ban node Diox thidtene. Ndxe'leque', Diox ndxecloo ñèe mèna nalle' par tetìi Diox mèna thidtene yiloa. ");
INSERT INTO zamNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nde nxon', mbìn mèn xley' farise más ndli Jesús bautizar mèn leque Juàn Bautist, ");
INSERT INTO zamNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","mastale indli yubte Jesús bautizar mèn. Ndxe'leque', myen' xin' mté'th Jesús mbli bautizar mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Per co'se' mbìn Jesús le' mèn xley' farise nonle' cón che'n Jesús, ngro' Jesús le'n yèezya' che'n làaz mèn jude par bere Jesús, ya Jesús par ned le'n yèezya' che'n làaz mèn galile tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Láth ndoo Jesús ned, nda Jesús par ned làaz mèn galile, thìb lì nguri'th Jesús par ned le'n yèezya' co' nac làaz mèn samari, ");
INSERT INTO zamNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","axta mzin Jesús thìb yèez co' lèe Sicar co' nac thìb yèezya' che'n làaz mèn samari. Yèez Sicar nziri' gaxte co'te' nax thìb le' xyòn Cob co' mtan' Cob loo Chè co' nac xgan' Cob póla. ");
INSERT INTO zamNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Loo xyòn Coba ndub thìb tó' co' mbez mèn nac tó' che'n Cob. Per com le' Jesús ndoo ned, ¿lé'?, mdub Jesús ro tó'a tac ngo zan Jesús. Hora casque' ngòc rol huiz. ");
INSERT INTO zamNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Láth ndub li Jesús descans ro tó', nde xi thìb xa'got co' nac thìb xa'got che'n làaz mèn samari nít ro tó'. Ndxab Jesús loo xa'gota: ―Ngot, fta' chu'th nít gun, ey. ");
INSERT INTO zamNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Látha ne, myen' xin' mté'th Jesús yende. Myen' nda le'n yèez par nda ti' myen' co' hua no myen' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sya, ndxab xa'got co' nac xa'got gulàaz mèn samari loo Jesús: ―¿Xá mod ale ña'b U' nít loon par gu U', U' co' nac mèn gulàaz che'n mèn nación Israel, no daa co' nac xa'got che'n làaz mèn samaritan, à'? Gu' nda'que' cuent no naneeque' gu' le' mèn nación Israel inzyál' di'ste no inzyál' be'de co' huenleque' con mèn co' nac mèn gulàaz che'n làaz mèn samari. ");
INSERT INTO zamNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Sya, mcàb Jesús loo xa'gota. Ndxab Jesús: ―Chele' lùu naneele' no nda'lel cuent cón che'n con' ndac co' angli Diox loo mèn, no chele'l nda' cuent no nonl chó mbi' nac mbi' co' ngue ña'b nít lool nalle', lìcpe' ba'i, lùu ngna'b nít loon par gul, nít co' li par yòo ban nol Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Sya, ndxab xa'gota loo Jesús: ―Tad, per ne' ne' ingue no U' con' par co' U' nít le'n tó'. Más de cona, anze'f na's tó'. ¿Pá yixi U' nít co' ta' U' gun, nít co' mbez U' gun par gòo ban non Diox thidtene, sya? ");
INSERT INTO zamNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Cob co' ngòc xudgool na' póla mtan' tó' ndxè' co'te' mblo' Cob nít par ngu Cob con myen' xin' Cob no par ngu má' co' mxèn' Cob. ¿A poc ñee U' más xa' roo xa' xèn nac U' leque xudgool na' Cob sya, cà'? ");
INSERT INTO zamNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús mcàb. Ndxab Jesús loo xa'gota: ―Ryete mèn co' toloque' gu nít ndxè', mèna toloque' yec lezo'. ");
INSERT INTO zamNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Per ndxe'leque', mèn co' tyal no co' ta' lugar yòo cón chenen loo mèna xal co'se' gu mèn nít, mèna thidteneque' yo nagàl lezo' loo cón che'n Diox xal mèn co' ne'yecte lezo' par nquin mèn gu mèn nít tedib vez. Tac con' co' lin loo mèna co' gàc con' co' yòo le'n lezo' mèna, con'a li loo mèna gàc con' ndac tín' loo mèna xal gàc con' ndac loo mèn co'se' ndub zib ndub len nít par li níta con' ndac loo mèna. Con' co' lin loo mèna càb loo mèna yòo ban no mèna Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Sya, ndxab xa'gota loo Jesús: ―Tad, fta' U' níta gun, tá, par ya ne'tolode yec lezon no par ya ne'tolode gal lo'en nít le'n tó' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Sya, mcàb Jesús loo xa'gota. Ndxab Jesús: ―Huàa xi xa'bi' co' nac sa'll. Yi'th ryop gu' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Xa'gota mcàb. Ndxab xa'gota loo Jesús: ―Ingue noden sa'len. Sya, ndxab Jesús loo xa'gota: ―Aa. Lìcque' nac co' guneel ba': Ingue nodel sa'l. Yende con' niin lool. ");
INSERT INTO zamNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Lùu nde teele' mque no ga'y sa'l. No lomisque', xa'bi' co' ndub nol nalle' inacte xa' sa'll. Lìcque' nac di's co' ngolo guneel ba'. ");
INSERT INTO zamNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Co'se' mbìn xa'gota tataa ndxab Jesús, ndxab xa'gota loo Jesús: ―Tad, ndyaquen le' U' nac thìb xa' co' nde'th di's co' ndxab Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Xudgool nu', co' ngòc mèn che'n yèezya' che'n làaz mèn samari, ndyee chez Diox loo yii co' ndub go'. No gu', co' nac mèn che'n yèezya' che'n làaz mèn jude, ale mbez le'n templ co' ndub le'n ciuda Jerusalén nac co'te' nquin cuez mèn Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús mcàb. Ndxab Jesús loo xa'gota: ―Gola's loon, ngot, nde zin' gaxle' tiemp no nde zin' gaxle' huiz co'se' ne' loo yii ndxè' no ne' ne' le'n ciuda Jerusalén gàc co'te' cuez gu' Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gu' co' nac mèn yèezya' che'n làaz mèn samari, axta ne' ne' ñee gu' chó loo con' mbez gu' nac Diox. Per nu' non no naneeque' nu' chó mbez nu' nac Diox. Tac por cón che'n nu' co' nac mèn nación Israel Diox mbli par non mèn xá mod lyá' mèn loo con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Per nase mzinle' huiz no mzinle' tiemp no nalle'que' ndxàc co'se', lìcque', nalìque' no nambìique' que tee ban mèn loo Diox xal ñibe'pe' Xpii Natú' loo mèn no xal ndlu' xti's Diox loo mèn cón che'n con' lìcpe'. Tac Diox xud na' ncua'n mèn co' cuezpe' Diox xud na' tataa mod, Diox co', lìcque', nac thidte Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diox nac thìb xpii. No mèn co' lya's cuez Diox mod co' li par yòo lezo' Diox ñèe Diox mèn, mèna naquinque' nalìque' no nambìique' que tee ban loo Diox xalque' ñibe'pe' Xpii Natú' loo mèn, no xalque' ndlu' xti's Diox loo mèn cón che'n con' lìcpe'. ");
INSERT INTO zamNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Sya, ndxab xa'gota loo Jesús: ―Daa nanee le' thìb xa' co' lèe Mesías yi'th, xa' co' ne' tedib lèe Crist. Co'se' yi'th xa', xa' ta' cuent no co ro xa' ryete con' cón che'n Diox loo na'. ");
INSERT INTO zamNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús mcàb loo xa'gota. Ndxab Jesús: ―Xa' co' nac Crist nac daa co' ngue toodi's nol, ey. ");
INSERT INTO zamNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Látha, ndye'th myen' xin' mté'th Jesús loo Jesús. Ante mbui' myen' no ante gunaa myen' le' Jesús ngue toodi's no xa'gota. Per nec thìb myen' ne'nglide ryes ngnibdi's myen' loo Jesús par ngab myen': ―¿Cón ndlya's xa'got ba' o chó di's ngue toodi's U' con xa'got ba'? ");
INSERT INTO zamNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Sya, taate mblá' xa'gota rre xa'. Ndyàa xa' làth yèez par ngua ta' xa' cuenta loo mèn yèez. Ndxab xa' loo mèn yèeza: ");
INSERT INTO zamNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ya' gu' nda tee hui' na' thìb mbi'. Mbi'a guneele' cón che'n ryethe con' nde teele' mblin. Ne'stolque' mbi'a nac Crist, cara. ");
INSERT INTO zamNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Sya, ryete mèn yèeza ngro'. Ngua no mèna xa'got co'te' ndub Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Láth nda xa'gota làth yèez, myen' xin' mté'th Jesús nalyat ndxab loo Jesús: ―Maistr, que de U'. Hua na' mase sa pan, yey. ");
INSERT INTO zamNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Per ndxe'leque', Jesús ndxab loo myen': ―Yende xàa, ey. Ne'huaden. Daa ngue no ndxep con' huan. No nít yèth co' huana, gu' inonte chó nít yèth nac nít yèth co' huana. ");
INSERT INTO zamNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Sya, mtlo myen' xin' mté'th Jesús, mnibdi's myen' loo xtàa myen': ―¿Xá nee gu'? ¿Ché' ndyac gu' nzo chó mèn mbi'th lá'le' con' nduhua maistr, lé'? ");
INSERT INTO zamNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ale le'le' mcàb Jesús loo myen': ―Yende xàa. Zin' co' ndlin ndxè' nac rsin' che'n xa' co' mtel' daa par lin co' nee lezo' xa'. Ndlin cuent le' zin'a nac xal xíten no xal luan. Le' zin' co' nac rsin' xa'a na, na teloque' zin'a. ");
INSERT INTO zamNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Gu' ngue no thìb di's co' mbez gu': Tatabe' ndxàc falt thap mbe' par zin tiemp co'se' lyáp, ¿lé'? Per nalle' nde tetaquen thìb di's loo gu' par ta' gu' cuent: Lyazen hui' ndxè' hui' ba' gu' loo xyòn mèn co' ngue lad yii ba'. Lìcque', huax cosech nzo co' yamerle' dyop. Tatua' nzo mèn loo izlyo' co' nzi bed gòn no co' ndlya's gòn cón chenen par yòo mèna loo cón che'n Diox, co' nee di's, nac mèna xal cosech ba'. ");
INSERT INTO zamNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Naneeque' gu' le' mèn co' ndli zin' loo cosech, mèna thìb lìte ndxòo ray. Niin tedib di's loo di's ndxè' loo gu', ne: Mèn co' gàc xal cosech loo cón che'n Diox, mèna yòo ban noque' Diox thidtene. Tataa ndxàca par gàca le' mèn co' nde'th no co' ngo yalbàn cón che'n Diox, no mèn co' ndxòo loo cón che'n Diox xal ndláp mèn, thidte tyac lezo' mèna loo cón che'n Diox no loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tac lìcque' nac con' ndxè' xal ndxab di's co' mbez mèn: Xà'que' nac mèn co' ngo bin. No xà'que' nac mèn co' nthop cosech. ");
INSERT INTO zamNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Daa mtel' gu' liz mèn no làaz mèn par ngua ta' gu' cuent no par ngua lo gu' yalbàn cón chenen loo mèn ned ngua gu' par ngola's mèn loon no ngòo mèn loo cón chenen xal co'se' nthop mèn cosech. Ne'ngode gu' yalbàn cón chenen arid xal mèn co' ngo bin. Taamas mèn mde'th cón chenen no mblo mèn yalbàn cón chenen xal mèn co' mque' zin' loo ña'. No gu' pente mbli ndxep zin' loo mèna par ngòo mèn loo cón chenen xal mèn co' inque'de zin' loo ña' no alithe mthop mèn cosecha par hua mèn cosech co'te' ne'nque'de mèn zin'. ");
INSERT INTO zamNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Huax mèn yèez che'n yèezya' che'n làaz mèn samari ngola's loo Jesús por di's co' mda' xa'got samaritan cuent loo mèna co'se' ndxab xa'gota: Jesús mda' cuent cón che'n ryete con' co' nde teele' ndlin loon, cara. ");
INSERT INTO zamNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Por cona, co'se' ngua mèn che'n yèezya' che'n làaz mèn samari loo Jesús, nalyat mde'b ro mèna. Mna'b mèna di's loo Jesús par yan' no Jesús mèna tya. No mbyan' no Jesús mèna tya chop huiz. ");
INSERT INTO zamNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","No ale sate más tolo ngola's huax mèna loo Jesús por di's co' mda' yub Jesús cuent loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Sya, ndxab mèn che'n yèezya' che'n làaz mèn samari loo xa'gota: ―Nase ngola'sque' nu' cón che'n Jesús. Ne'ngala'ste nu' cón che'n Jesús ante por di's co' mda'l cuent loo nu'. Ndxe'leque', nu' ngola's loo Jesús por mda' yub Jesús cuenta loo nu'. No, lìcpe' ba'i, naneeque' nu' le' mbi' ba' nac yubpe' Crist co' mxo'f zin' Diox loo par ntelá' Crist mèn che'n izlyo' ndxè' loo con' ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Co'se' ngolo nguri'th chop huiz, mbii Jesús le'n yèezya' che'n làaz mèn samari. Nda Jesús par ned le'n yèezya' co' nac che'n làaz mèn galile. ");
INSERT INTO zamNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tac yub Jesús ndxab loo mèn nación Israel: ―Thìb mbi' co' nde'th di's co' ndxab Diox, co' nac mbi' yèezpe' no mbi' gulàazpe' che'n thìb yèez, mèn gulàaz mbi' no mèn yèez mbi' ne'lide par gàc con' guryath no con' guryèn loo mbi'a. Ndxe'leque', tè'b mèna mbi'a. ");
INSERT INTO zamNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Co'se' mzin Jesús le'n yèezya' che'n làaz mèn galile, nabe'ste ngo no mèna Jesús. No nabe'ste mdoodi's no mèna Jesús tac rye mèna ngua lni Jerusalén. No gunèe mèna rye con' co' mbli Jesús le'n huiz lni le'n templ ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Làth xtau'a, ngua riid Jesús le'n yèez Caná, co' nac thìb yèezya' che'n làaz mèn galile, co'te' mbli Jesús ngòc nít vin. Nde nxon', ngo thìb mbi' che'n yèez Capernaum co' ngòc thìb jef che'n gobiern co' ñibe' rey. Mque no mbi' thìb xgan' mbi' co' ndyac len. ");
INSERT INTO zamNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Co'se' mbìn mbi'a le' Jesús ngro' le'n yèezya' che'n làaz mèn jude no mzin Jesús par ned le'n yèezya' che'n làaz mèn galile, mbi'th nee mbi' loo Jesús. Nalyat mde'b ro mbi'. Mna'b mbi' favor loo Jesús par ya teyac Jesús xgan' mbi' liz mbi' tac xgan' mbi' nax tinle' liz. ");
INSERT INTO zamNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Sya, ndxab Jesús loo mbi': ―Gu' ne'yila'ste loon chele' gu' ne'ñèede señ no yalguzye' co' ndlin, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Per mbi' co' mxo'f zin' zin' loo gobiern ndxab loo Jesús: ―Lìca, Tad, inacte nu' mèn co' ndxela's arid. Per jer ya' U', nda na' lizen ndoore' gath mbyòo daa, yey. ");
INSERT INTO zamNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sya, ndxab Jesús loo mbi': ―Byàa par lizl. Mbyòo lùu mbyacle'. No nabanque' mbyòo. Mbi'a ngola's di's co' ndxab Jesús loo mbi'. Mxen mbi' ned, ndyàa mbi' par liz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Co'se' yamerle' zin mbi' liz mbi', mtel' mèn guliz mbi' moz par ngua càa ned moz mbi'. Sya, ndxab moz loo mbi': ―Ne'tyóode U'. Mbyòo U' mbyacle'. No nabanque' mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Sya, mnibdi's mbi' loo moz. Ndxab mbi': ―¿Coyor mtlo mbyath ndac mbyòo, à'? Moz ndxab loo mbi': ―Ná'a com hor mquée guthìb bzyè ngro xlé' mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Lueg mda' xud mbyòo cuent le' hora ngòc leque hor co'se' ndxab Jesús loo mbi': ―Mbyòo lùu mbyacle'. No nabanque' mbyòo lùu. Syase ngola's mbi' loo Jesús no loo con' ndli Jesús con rye mèn guliz mbi'. ");
INSERT INTO zamNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Con yalguzye' co' mbli Jesús loo mbyòo xgan' mbi'a, ngòc mbryop yalguzye' co' mbli Jesús loo ngro' Jesús le'n yèezya' che'n làaz mèn jude co'se' mbere Jesús, ngòo Jesús le'n yèezya' che'n làaz mèn galile. ");
INSERT INTO zamNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ngolo nguri'th con'a, mzin huiz lni co' nac huiz lni che'n mèn nación Israel. Làth xtau'a, Jesús mbere ngua par ned le'n ciuda Jerusalén. ");
INSERT INTO zamNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Le'n ciuda Jerusalén, ndoo thìb puert co' ngro' lèe Puert che'n Mbacxil'. Ngo'th thìb tanc nít tya. No tanca ngro' lèe di'stèe hebre Betesda. Ro tanca nziri' thìb corredor co' mque no ga'y portal co' ngòc ga'y arc. ");
INSERT INTO zamNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ro portal che'n corredora ngureri' huax mèn yíiz, mèn sieu, mèn renc, no mèn co' mque no yíiz bech. Mèna nzi bed par huin nít. ");
INSERT INTO zamNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tac thìb angl ndryo' le'n bé' no ndlyàa angl loo bé' cad pól no ncuin angl nít. No mèn yíiz co' nerleque' ndlyàa le'n níta láth ngüin nít, ndxac mèna loo chol yíiz co' mque no mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ngo thìb mbi' làth rye mèn yíiza tya. Mbi'a ndxàcle' gal psi' pxon lín' ndyac len. ");
INSERT INTO zamNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Co'se' gunèe Jesús nax mbi'a no non Jesús ndxàcle' lín' ndyac len mbi'a, ndxab Jesús loo mbi': ―¿Ché' ndlya'sl yacl, cà', ey? ");
INSERT INTO zamNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mbi' mcàb loo Jesús. Ndxab mbi': ―Aa, Tad, per yende chó mèn lyath no daa par làa mèn daa le'n tanc co'se' ngüin nít. Tac co'se' ndlyazen làan le'n tanc, no ndoore' zin daa ro tanc, tedib mèn ngulàale' le'n tanc. Cona, ngue niin loo U': Ne'lide thidten gan par làan le'n tanc, Tad. ");
INSERT INTO zamNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús ndxab loo mbi': ―Goo che. No fthùuz dáal co' ndxàa'l. No fxen ned. Byàa par lizl. ");
INSERT INTO zamNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Leque hora, chàa, mbyac mbi'. Mthùuz mbi' dáa mbi'. Mxen mbi' ned. Ndyàa mbi' par liz mbi'. No le'xque' huiz co' mbyac mbi'a ngòc huiz sabd co' ngòc huiz descans tiempa. ");
INSERT INTO zamNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Sya, ndxab mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel loo mbi' co' mbyaca: ―Mbi', nalze nac huiz sabd co' nac huiz descans. Indxàalte hue'l dáa ba'. ");
INSERT INTO zamNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Per mbi' co' mbyaca mcàb loo mèna. Ndxab mbi': ―Xa' co' mteyac daa, yub xa' gunee loon: Fthùuz dáa. No bye' dáa. Byàa par lizl. ");
INSERT INTO zamNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Sya, mnibdi's mèna loo mbi'. Ndxab mèna: ―¿Chó mbi' nac mbi' co' gunee lool: Fthùuz dáal no bye' dáa no byàa, à'? ");
INSERT INTO zamNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Per mbi' co' mbyaca ne'nda'de cuent no inonte mbi' chó nac mbi' co' mteyac mbi'a tac anze'f thìb mèn ngureri' tya. Nde nxon', mbiile' Jesús làth mèna, ne. ");
INSERT INTO zamNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ngoloa, mzyál' Jesús mbi' le'n templ. Ndxab Jesús loo mbi': ―Hui' nexa. Lùu mbyacle' nalle'. Chó Diox chó neel. Ya ne'tolode cua'nl xquinl. Tac yiloa más nazab gàca lool. ");
INSERT INTO zamNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Sya, mxen mbi' ned. Ndyàa mbi'. Ngua ta' mbi' cuent loo mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel le' Jesús nac xa' co' mteyac mbi'. ");
INSERT INTO zamNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ante por mbli Jesús con'a huiz sabd co' ngòc huiz descans tiempa, mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel mtlo mdub ngu's Jesús. Anze'f mblya's mèna guth mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Per com le' Jesús nonque' xal nac xtùuz mèna, ¿lé'?, co'se' ngòc nayi' mèna loo Jesús, sya, mcàb Jesús loo mèna. Ndxab Jesús: ―Axta nare' ngue li xuden Diox thìb zin'. Daa, ne, ngue li zin'. ");
INSERT INTO zamNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Le' sya, por cona sate más mbli mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel fuerz par guthxù' mèna Jesús. Tac iante de indlide Jesús cas huiz sabd xal nac costumbr co' mque no mèn nación Israel huiz sabd co' ngòc huiz descans tiempa, mblya's mèna guth mèna Jesús. Ndxe'leque', por mbez Jesús le' xudpe' Jesús nac Diox no por lalque' ndxàc Jesús con Diox, cona, mblya's mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel guth mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Le' sya, ndxab Jesús loo mèna: ―Lìcpe' ba'i, na nii loo gu': Le' daa, co' nac xgan' Diox, ne'gácte lin nec thìb con' ante xal nee lezon. Ndxe'leque', daa co' nac xgan' Diox, ndlin con' co' ñèen ndli xuden Diox. Tac ryete con' co' ndli xuden Diox, daa co' nac xgan'pe' Diox ndlii, ne. ");
INSERT INTO zamNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tac Diox co' nac xuden nque' lezo' xgan'pe' Diox co' nac daa. No ndlu' Diox ryete con' co' ndli Diox loon, daa co' nac xgan' Diox. Rsin' Diox co' nac más con' roo con' xèn leque con' ndxè', Diox lu're'i loon, daa co' nac xgan'pe' Diox. No por cón che'n con' co' hui' gu' co' li xuden Diox yiloa, con'a li par ante hui' gu' no ante ñaa gu' loon yiloa, ne. ");
INSERT INTO zamNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tac texal ngo xban Diox xuden mèn co' nguthle', no nda' xuden Diox yalnaban loo mèn co' nguthle'a, lomisque', daa co' nac xgan' Diox ta yalnaban co' nac yalnaban thidtene loo mèn co' ndlyazen que no mèna yalnaban thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Xuden Diox indub rezte cón che'n nec thìb mèn. Ndxe'leque', mda' xuden Diox ryete con' roo no ryete con' xèn co' nzo la's nii xuden Diox no co' nzo la's ya' xuden Diox loon, daa co' nac xgan' xuden Diox par tub rezen cón che'n ryete mèn loo izlyo', ");
INSERT INTO zamNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","par tataa mod gàca le' ryete mèn li con' guryath no con' guryèn loon, daa co' nac xgan' Diox, xalque' ndli mèn con' guryath no con' guryèn loo xuden Diox. Tac mèn co' indlide con' guryath no con' guryèn loon, mèna indlide con' guryath no con' guryèn loo Diox xuden co' mtel' daa loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Lìcpe' ba'i, na ngue nii loo gu': Le' mèn co' ndyub nza no mèn co' ndxàa'd di's co' ngue bezen loo mèn no mèn co' ndxela's loo xuden Diox co' mtel' daa, mèna yòo ban noque' Diox thidtene yiloa. Loo mèna ne'zib quìide Diox xtol mèn no xquin mèn loo mèna. Ndxe'leque', ngòc mèna mèn co' ne'co' xà'de Diox loo Diox ngolo nguth mèna. No thìb lìte yòo ban noque' mèna Diox thidtene yiloa. ");
INSERT INTO zamNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Lìcpe' ba'i, na ngue nii loo gu': Nde zin' gaxle' huiz no nde zin' gaxle' tiemp no nalle'que' ndxàca co'se' mèn co' be' naban co' nac xal mèn nguth loo cón che'n Tad Diox, gòn mèna ron, daa co' nac xgan' Diox. No mèn co' ndxòn di's no co' ndxàa'd di's co' mbezen, yòo ban noque' mèna Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tac yub xuden Diox ndxàp con' la's nii xuden Diox no la's ya' xuden Diox par li xuden Diox par yòo ban no mèn xuden Diox thidtene. No lomisque', niin: Mda'le' xuden Diox ryethe con' roo no con' xèn co' nzo la's nii xuden Diox no co' nzo la's ya' xuden Diox loon par lin yòo ban no mèn xuden Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","No mda'le' xuden Diox ryethe con' roo con' xèn co' nzo la's nii xuden Diox no co' nzo la's ya' xuden Diox loon par tub rezen cón che'n mèn loo izlyo' tac daa mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ne'hui'de gu' no ne'ñaade gu' loo con' ndxè'. Tac zin thìb huiz no zin thìb ze co'se' ryete mèn nguth co' mbua'sle' gòn di's co' tyoodizen co'se' gàc huiza, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Lomisque' niin, ne: Huiza, ryo xban mèn nguth le'n bá' mèn nguth. Mèn co' mbli con' ndac, mèna ryo xban par yòo ban no mèn Diox thidtene. Per ndxe'leque', mèn co' mbli con' ye'rsin', mèna ryo xban par zib quìi Diox mèna par co' xà' Diox mèna loo Diox thidtene yiloa. ");
INSERT INTO zamNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Toloque' ndxab Jesús loo mèn: ―Yende mod lin nec thìb con' xal nee lezon no xal ndlyazen. Ndxe'leque', daa ndub rez cón che'n mèn xalque' ñibe' xuden Diox loon. No nalì no nambìi nac mod co' ndub rezen cón che'n mèn. Indoode lezon lin co' neete lezon. Ndxe'leque', ndlin ante xal ndlya's xuden Diox no xal nee lezo' xuden Diox co' mtel' daa par lina. ");
INSERT INTO zamNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tac chele' daa ngue ta cuent ante cón che'npe'en, le' sya, nzoque' mod gab mèn le' cuent co' ngue tan cuent cón che'npe'en, inacte con' lìcpe'. ");
INSERT INTO zamNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Per daa ngue nii loo gu': Nzoque' thìb xa' co' nda' cuent cón che'npe' daa. No daa nanee le' cuent co' nda' xa' cón che'npe'ena, le'i lìcpe' nac. ");
INSERT INTO zamNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Gu' mtel' mèn co' ngua loo Juàn Bautist par ñibdi's mèn cón chenen loo Juàn. No cuent co' mda' Juàn loo gu' cón chenen ngòc lìcque'. ");
INSERT INTO zamNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Per part cón chenen, indxòode lezon no yende chó mport nzo lezon co'se' ndxònen nda' mèn cuent cón chenen. Ndxe'leque', niin di's ndxè' loo gu' par lyá' gu' loo con' ryes. ");
INSERT INTO zamNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juàn ngòc xal thìb manoj ye'rbèel co' mbyol no co' mtenìi loo mèn, co' nee di's, par mda' gu' cuent co' nac cón che'n Diox. Per part cón che'n gu', gu' mbli xal mèn co' ngòo lezo' no co' mdyac lezo' ndxep tiemp loo cón che'n di's co' mda' Juàn cuent loo gu', Juàn co' mbli par mdyub xnìi yéc mèn no co' mbli par mdyub xnìi lezo' mèn loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Per part cón chenen, nzoque' thìb xa' co' más nalì no más nambìi nda' cuent cón chenen leque di's co' mdyoodi's Juàn cón chenen. Tac con' co' ndlin nac lomisque' con' co' gunee xuden Diox loon par lin. No con' co' ndlina, le'i ndlu' le' xuden Diox, lìcque', mtel' daa. ");
INSERT INTO zamNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Xuden Diox co' mtel' daa, leque yub xuden Diox ndlu' no nda' xuden Diox cuent cón chenen. Per part cón che'n gu', axta nalle' tarte gòn gu' xal ndyoodi's xuden. Ne' ne' tar ñee gu' xal ñaa xuden Diox no xal nacpe' xuden Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ne' ne' tar yaa'd di's co' mbez xuden Diox loo gu' le'n lezo' gu' no le'n xtùuz gu' thidtene. Tac tarte yila's gu' loon, daa co' yub xuden Diox mtel' loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gu' nteche ntexyath ye's co' nac che'n libr co' nac xti's Diox. Noo noo ndlab gu' libr. Tac gu' nden' no ndyac gu' le' loo libra ndlu' le' gu' nzi quee lezo' yòo ban no gu' Diox thidtene. Per mastale' ndlab gu' libr co' nac xti's Diox, ne' ne' inda' gu' cuent le' cón chenen nac co' nda' libr cuent no co' ndlu' libr loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","No ale indlya'ste gu' ta' gu' lugar par thidte queltàa no gu' daa no yòo gu' loo cón chenen par yòo ban no gu' Diox thidtene yiloa. ");
INSERT INTO zamNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Yende chó mport nzo lezon no ne' ne' indlin cas mèn co' asendli ndxàc daa mèn guryath no mèn guryèn loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Más de cona, huen huen ndan cuent cón che'n gu'. No ndlibe'quen gu' le' gu' inque'de lezo' Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Daa ndal por cón che'n xuden Diox. No indlide gu' cas daa. Per chele' tedib mèn yi'th por part cón che'n leque mèna, mèna se lique' gu' cas, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Xá mod gác gu' yila's gu' loon no loo Diox chele' gu' más ndli cas loo con' co' nac con' guryath no con' guryèn cón che'n xtàa gu' no indxòode lezo' gu' li gu' con' guryath no con' guryèn loo xa' co' nde no co' ngro' loo thidte Diox, sya? ¡Pà gác gu' li gu'i! ");
INSERT INTO zamNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ne'tyóode gu' no ne'yila'ste gu' par gab gu' le'n lezo' gu' le' daa queyèe gu' loo xuden Diox yé' huize'. Xa' co' nqueyèe gu'a nac yub Moisés, mastale' nzi quee lezo' gu' gàc con' ndac loo gu' por mdoo nque gu' loo ley co' nac di's co' mxo'f Moisés loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tac chele' gu', lìcque', ngala's loo di's co' mbez Moisés, ngala's gu' loon, ne. Tac ye's co' mque' Moisés co' mtan' Moisés di's loo gu', di'sa nda' cuent cón chenen no ndlu' di's cón chenen, ne. ");
INSERT INTO zamNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Chele' gu' ne'ngala'ste loo di's co' mque' Moisés ye's co' mtan' Moisés loo gu', ¿xá mod yila's gu' loo di's co' ndyoodizen loo gu', sya? Yende mod yila's gu' di's, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ngolo nguri'th ryete con'a, mxen Jesús ned. Nda Jesús tedib lad ro lagun co' nziri' loo xyòn mèn yèezya' che'n làaz mèn galile co' nac leque lagun co' ne' tedib lèe lagun che'n mèn ciuda Tiberias. ");
INSERT INTO zamNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","No anze'f thìb mèn nda nque xís Jesús tac gunèe mèna yalguzye' co' mbli Jesús co'se' mteyac Jesús huax mèn yíiz. ");
INSERT INTO zamNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Sya, mquée Jesús loo thìb yii. Ngua tub Jesús tya con myen' xin' mté'th Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nde nxon', leque le'n huiza nde zin' gaxle' huiz lni che'n pasc co' ndli mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Co'se' gunèe Jesús nde nque huax mènléy' xís Jesús, Jesús ndxab loo Lip: ―¿Pá ya ti' gu' pan par hua rye mèn ba', Lip? ");
INSERT INTO zamNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Per Jesús asembli tataa ndxab Jesús loo Lip par ñee Jesús ñeene' cón càb Lip loo Jesús. Tac yub Jesús naneeque' xá mod li Jesús par hua rye mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Sya, mcàb Lip loo Jesús. Ndxab Lip: ―Tad, chele' na' ti' thìb mil chop ayo pes pan par hua rye mèn ba', pà gàala par hua rye mèn ba' sa sai. ");
INSERT INTO zamNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Le' sya, ndxab thìb myen' xin' mté'th Jesús co' lèe Ndech, co' ndxàc hues Mon Pedr, loo Jesús: ");
INSERT INTO zamNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Tad, làth na' ndxè' nzo thìb mbyòo co' ngue no ga'y pan nagus no chop mbèel bix. Per pà gàal pana no mbèela par hua ryethe mèn ba' thìb le'i thìb le'i. ");
INSERT INTO zamNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Sya, ndxab Jesús loo myen' xin' mté'th Jesús: ―Guuz gu' loo rye mèn ba' tyub mèn loo yixii co' nzo'f ba'. Tataa ndxab Jesús tac anze'f thìb yixii mxyo'f tya. Sya, mdub mèna. Mèn co' nduhua, casque' ngòc ga'y mil mèn, ante mènbi'. Xà' mèngot. No xà' myen' bix. Indxòode cuent mèngot no myen' bix co' nduhua, ne. ");
INSERT INTO zamNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Sya, mxen Jesús ga'y pana. No ndxab Jesús: ―Diox quix U', Diox, loo Diox. Ngolo ndxab Jesús: Diox quix U', Diox, loo Diox, mbli Jesús par mbyar' pana. Ngoloa, mda' Jesús pana loo myen' xin' mté'th Jesús. Le' myen' na, mbli'th pana loo mèn co' nzi nduba. Lomisque' mbli Jesús con mbèela. No nduhua mèna pana no mbèela axta plóthe mblya's mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Co'se' ngolo nduhua mèna axta plóthe mblya's mèna pan no mbèel co' mteyar' Jesús, Jesús ndxab loo myen' xin' mté'th Jesús: ―Fthop gu' rye le' pan co' mbyan' xo'f ba' par ne'yiza'de nec thìb le'i. ");
INSERT INTO zamNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Sya, mthop myen' si' fchop cardor le' pan co' mbyan' xo'f loo ga'y pan co' nduhua mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Per co'se' gunèe mèna yalguzye' co' mbli Jesús, syare', ndxab mèna loo xtàa mèna: ―Lìcpe' ba'i, mbi' ba' nac mbi' co' nde'th di's co' ndxab Diox co' ndxath yi'th loo izlyo', cara. ");
INSERT INTO zamNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Per com le' Jesús nonque' no nda'que' Jesús cuent le' mèna mbli nèele' lezo' mbi'th mèna par hue' yèe mèna Jesús par sanggàc Jesús reype' mèna, sya, ngro' thidte Jesús thìb lad loo mèna. Mbere Jesús, nda Jesús loo yiia tedib vez. ");
INSERT INTO zamNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Co'se' mzyèle' izlyo' huiza, mxen myen' xin' mté'th Jesús ned. Ngulàa tùub myen'. Nda myen' anzo anzo ro lagun. ");
INSERT INTO zamNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Sya, ngòo myen' loo thìb yòoyaa par tlo tetee myen' yòoyaa loo lagun par zin myen' tedib lad ro lagun co'te' nziri' yèez Capernaum. Hora, nde làale' yál' izlyo'. Le' Jesús na, yende pá ñaa bere par thidte ya no Jesús myen'. ");
INSERT INTO zamNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Per le'pe' tlo tetee myen' yòoyaa loo lagun, mtlo ngro' thìb mbiidó'. No mxít too mbii nít loo lagun. ");
INSERT INTO zamNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Co'se' nde teele' ndyee myen' loo lagun thìb distans co' ne' ga'y mil metr, gunèe myen' nde tee nii Jesús loo nít loo lagun. Per ne'ñeede myen' ché' Jesús na. Co'se' gunèe myen' nde zin gax Jesús loo myen', ale mzyeb myen'. ");
INSERT INTO zamNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesús ndxab loo myen': ―Ne'zyebte gu', ey. Daa na. ");
INSERT INTO zamNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Le' sya, mdyac lezo' myen' ngo no myen' Jesús loo yòoyaa. No ale setilte mzin myen' con Jesús yèez Capernaum co'te' nda myen'. ");
INSERT INTO zamNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Per tedib huiz co' nde nquea, rye mèn co' be' mbyan' tedib lad ro leque laguna, mèna gunèe le' myen' xin' mté'th Jesús ngòo loo thidte yòoyaa co' ndub tya. No yende pá gunèe mèna ngòo no Jesús myen' loo yòoyaa. ");
INSERT INTO zamNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Per láth nzi li mèna xtùuz no mbez mèna loo xtàa mèna: ¿Pá ned nda Jesús, yey?, sya, mzin ndxep yòoyaa co' ndye'th par ned yèez Tiber, yèez co' nziri' gaxte co'te' nduhua mèn pan co'se' ngolo ndxab Tad Jesús: Diox quix U', Diox, loo Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Co'se' gunèe mèna yende pá ndye'th Jesús làtha, ne' myen' xin' mté'th Jesús, ngòo mèna loo leque yòoyaa co' mzin tya par nda cua'n mèna Jesús par ned le'n yèez Capernaum. ");
INSERT INTO zamNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Co'se' mzin mèna co'te' nzo Jesús tedib lad ro lagun, ndxab mèna loo Jesús: ―Maistr, ¿pól mzin U' par nedrè', yey? ");
INSERT INTO zamNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Mcàb Jesús loo mèna. Ndxab Jesús: ―Lìcpe' ba'i, na ngue nii loo gu': Le' gu' mcua'n daa por nduhua gu' pan axta plóthe mblya's gu'. Per incua'nte gu' daa por ndxòn gu', no por mden' gu', no por mda' gu' cuent cón che'n yalguzye' co' gunèe gu' mblin. ");
INSERT INTO zamNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ne'gath lyuxte gu' por xít gu' no lua' gu' co' nde che loo gu' thìb thìb huiz. Ndxe'leque', guth blux gu' loo xít gu' no lua' gu' co' ne'lyuxte no co' ne'ryede loo gu', co' nee di's, con' co' ndlin par yòo ban no gu' Diox thidtene. Tac daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo' ndxè', daa ndli par yòo ban no mèn Diox thidtene xal nac xít mèn no lua' mèn co' ngàal mèn co'se' ndxuhua mèn xít mèn no lua' mèn. Tac Diox co' nac xuden mblu' loon no mnibe' Diox loon par lin ryethe con' co' ngue lin loo izlyo' ndxè' no par xo'f zin'en ryethe con' co' mnibe' xuden Diox loon par lina. ");
INSERT INTO zamNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Sya, ndxab mèna loo Jesús: ―¿Cón li nu' par tolo li nu' ryethe con' co' ñibe' Diox no co' nee lezo' Diox, sya? ");
INSERT INTO zamNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús mcàb loo mèna. Ndxab Jesús: ―Con' co' ndlya's Diox li gu' nac ante yila's gu' no gàp gu' yalxla's loo xa' co' mtel' Diox loo gu', co' nac yub daa. ");
INSERT INTO zamNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Le' sya, ndxab mèna loo Jesús: ―Neeca. Ndxònque' nu' di's co' mbezl ba'. Per nu' ndlya's ñèe chó yalguzye' lil loo nu' par ñèe nu' lil yalguzye' no yila's nu' lool. ¿Chó con' lil loo nu' co' gàc xal thìb señ par ñèe nu'i, à'? ");
INSERT INTO zamNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Xudgool nu' co' ngo ban póla nduhua thìb loo pan co' ngro' lèe maná co'te' nagán, xalque' nac di's co' ndub loo libr co' nac xti's Diox co' mbez le' Diox mblàa thìb loo pan loo bé' par nduhua mèn tiempa. ¿Chó señ lil par ñèe nu' lila, à'? ");
INSERT INTO zamNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mcàb Jesús loo mèna. Ndxab Jesús: ―Lìcpe' ba'i, na ngue nii loo gu': Ne'ngàcte Moisés xa' co' mda' pan che'n bé' par nduhua mèn co' ngòc xudgool gu'. Ndxe'leque', xuden Diox nac xa' co' nda' pan co' nac lìcpe' pan che'n bé' par hua gu' nalle', co' nee di's, nac yub daa. ");
INSERT INTO zamNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tac pan co' nda' Diox par hua mèn nalle', pana nac xa' co' ngulàale' loo bé', co' nee di's, nac daa. No daa li le' mèn co' tyal yòo loo cón chenen, mèna yòo ban noque' Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Sya, ndxab mèn loo Jesús: ―Tad, fta' U' pana par hua nu', tá. ");
INSERT INTO zamNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús ndxab loo mèna: ―Daa nac xa' co' ndli par yòo ban no mèn Diox thidtene xal ndli xít mèn no lua' mèn par ban mèn loo izlyo'. Mèn co' tyal yòo loo cón chenen no yila's mèn loon, mèna gàc xal mèn co' ne'gath huinte no co' ne'lyan'te thidtene. No mèn co' tyal yòo loo cón chenen no co' yila's loon, mèna gàc xal mèn co' ne'yecte lezo' thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Per daa guniile' loo gu': Mastale' gunèele' gu' daa, indxela'ste gu' loon no indxela'ste gu' loo con' ndlin. ");
INSERT INTO zamNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Per ryete mèn co' ndli Diox xuden tyal par yòo mèna loo cón chenen par yila's mèna loon, ne'tèbten mèna no ne'co' tooden mèna par biiche mèna thìb lad loon thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tac daa ne'ngro'de loo bé' par ngal lin con' co' neete lezon. Ndxe'leque', ngro'en loo bé' par ndlin con' co' nee lezo' xuden Diox co' mtel' daa. ");
INSERT INTO zamNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","No con' co' nee lezo' xuden Diox co' mtel' daa par lina nac le' ryete mèn co' mbli Diox mdyal par ngòo mèn loo cón chenen, nec thìb mèna ne'ryo' xà'de loo Diox thidtene yiloa. Ndxe'leque', go xbanen mèna le'n huiz co' gàc lult tiemp loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tac con' ndxè' nac co' nee lezo' xuden Diox co' mtel' daa le' ryete mèn co' huen huen tyóo loo cón chenen no yila's mèn loon, daa co' nac xgan' Diox, mèna yòo ban noque' Diox thidtene. No na go xban mèna le'n huiz co' gàc lult tiemp loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Co'se' mbìn mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel tataa ndxab Jesús, sya, xexte gunii mèna cón che'n Jesús tac ndxab Jesús loo mèna: Daa nac pan co' ngulàale' loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tolo mdoodi's mèna. Ndxab mèna: ―¿Ché' inacte Jesús ba' xgan' Chè, cà'? Na' ndlibe'que' xud Jesús no xna' Jesús. ¿Xá mod ale mbez Jesús le' Jesús ngro'le' loo bé' no nde Jesús loo izlyo' ndxè', sya? ");
INSERT INTO zamNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Sya, mcàb Jesús loo mèna. Ndxab Jesús: ―Cabii ftoodi's gu'. Ne'tyoodi'ste gu' xexte cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yende chó mèn gác yòo loo cón chenen chele' xuden Diox co' mtel' daa ne'lide par yòo mèn loo cón chenen. No daa go xban mèna le'n huiz co' gàc lult tiemp loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Loo libr co' mque' mèn co' mde'th di's co' ndxab Diox ye's co' nac xti's Diox mbez taandxè': Diox lu' loo ryete mèn. Por cona, ryete mèn co' gòn no co' té'th cón che'n xuden Diox, mèna yòo loo cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tarte yo nec thìb mèn loo izlyo' co' gunèele' xá ñaa xuden Diox. Angoluxte daa co' ngro' loo Diox, daa gunèele' xá ñaa xuden Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Lìcpe' ba'i, na ngue nii loo gu': Mèn co' ndxela's loon no ndxela's mèn loo cón chenen, mèna yòo ban noque' xuden Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Daa nac xa' co' ndli par yòo ban noque' mèn Diox thidtene xal ndli xít mèn no lua' mèn co' ndxuhua mèn par tolo cue ban mèn loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Jesús tolo ndxab loo mèna: ―Nde niin thìb con' loo gu', ne, ey: Mèn co' ngòc xudgool gu' nduhua thìb loo pan co' ngro' lèe maná co'te' nagán. Per mastale' nduhua mèna pana, nguthque' mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Per daa ngue ta cuent loo gu' co' nac cón chenen, daa co' nac xal nac pan co' ngulàa loo bé' par gàca le' mèn co' yòo loo cón chenen, xal co'se' ndxuhua mèn pan, mèna ne'co' xà'de Diox loo Diox thidtene co'se' ngolo nguth mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yub daa nac xa' co' ngro' loo bé' co' ndli par yòo ban no mèn Diox thidtene xal pan co' ndxuhua mèn co' ndli par ban mèn loo izlyo' ndxè'. Chele' chol mèn hua pana, co' nee di's, yòo mèn loo cón chenen, mèna ban noque' Diox thidtene. No pan co' angtan par hua mèna, pana nac bél'yòo ladpe'en co' leque daa li gath par gàca le' chol mèn izlyo' co' tyal yòo loo cón chenen, mèna ban noque' Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Sya, mèngool co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel noo noo ndyoodi's cón che'n Jesús làth xtàa mèn. Mbez mèna loo xtàa mèn: ―¿Xá mod li mbi' ba' par ta' mbi' bél' lad mbi' par hua mèn, cara? ");
INSERT INTO zamNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús tolo mtetac di's loo mèna. Ndxab Jesús: ―Lìcpe' ba'i, na nde nii tedib con' loo gu', ne: Chele' gu' ne'huade bél'yòo laden no ne'gude gu' ren laden, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo' ndxè', ne'yòo ban node gu' Diox thidtene yiloa. ");
INSERT INTO zamNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mèn co' hua bél'yòo laden no gu mèn ren laden, mèna yòo ban noque' Diox thidtene. No daa go xban mèna co'se' gàc huiz co' gàc lult tiemp loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tac, lìcpe' ba'i, por cón che'n bél'yòo laden no por cón che'n ren laden li yòo ban no mèn Diox thidtene xal ndxàca loo mèn co'se' ndxuhua mèn xít mèn no lua' mèn par ban mèn loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Chol mèn co' yòo loo cón chenen, co' nee di's, nac cón che'n bél'yòo laden no cón che'npe' ren laden, mèna thidte ndxàc con daa thidtene. No go noquen mèna thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tac xuden Diox co' mtel' daa naban thidtene no ndli xuden Diox naban taamas con' co' naban. No naban daa por cón che'n xuden Diox. Lomisque' mod ne, mèn co' tyal yaa'd di's no ten' mèn di's co' ndyoodizen loo mèn, gàca loo mèna xal co'se' nguè' xít mèn no lua' mèn mèn, co' nee di's, nac daa, mèna yòo ban noque' Diox thidtene por cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Cón che'n pan co' ngulàale' loo bé' co' ngue niin loo gu' ndxè', nac daa. Cón che'n pan ndxè' inacta xal maná co' nduhua xudgool gu' póla. Per mastale' nduhua xudgool gu' manaa, nguthque' xudgool gu'. Per mèn co' tyal hua pan co' ngue tan cuent loo gu' ndxè' co' nac cón che'n daa, mèna yòo ban noque' Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús ndxab di's ndxè' loo mèn co'se' mblu' Jesús mèn le'n sinagog co' ndub le'n yèez Capernaum. ");
INSERT INTO zamNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Co'se' mbìn mèn di's co' ngue lu' Jesús loo mèn, huax mèn co' mdoo nque xís Jesús ndxab loo xtàa mèn: ―Anze'f nagàn naca par ta' na' cuent cón nee di's no par yaa'd di's le'n lezo' na' par li na' xal mbez mbi'. ¿Chó mèn gác gòn di's co' mbez mbi', cara? Yende chó mèn gác, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Sya, mden' lezo' Jesús le' mèna xexte nzi toodi's cón che'n di's co' mblu' Jesús loo mèn. Ndxab Jesús loo mèna: ―¿Ché' nazab ngulàa di's co' ngue niin loo gu' ndxè' le'n lezo' gu', cà'? ¿Ché' nden' gu' ngue niin ngòc nguàal di's loo gu', ne, cà'? Yende xàa. ");
INSERT INTO zamNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Chele' gu' tataa ngue li xtùuz no nden' gu' le'n lezo' gu' nè nac di's ndxè', ¿cón li gu' no cón gab gu' loo lezo' gu' co'se' ñèe gu' gápen loo bé' tedib vez co'te' ngon ndoore' galen loo izlyo' ndxè', daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo' ndxè', sya? ");
INSERT INTO zamNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mèn yòo ban no Diox thidtene por cón che'n con' co' ndli Xpii Natú' che'n Diox loo xpii mèn. Yende cón ntac bél'yòo ladpe' mèn loo cón che'n Diox par yòo ban no mèn Diox thidtene. Cona, di's co' ngue niin loo gu' ndxè', di'sa ndlu' loo gu' xá mod li gu' par yòo ban no gu' Diox thidtene. Chele' gu' li xal ngue niin loo gu' ndxè', gu' yòo ban noque' Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Per daa nanee no ndan cuent co' huenleque' tatabe' nzo ndxep gu' co' indxela'ste di's co' mbezen loo gu'. Tataa ndxab Jesús loo mèna tac anon mtlo Jesús, mque tee lu' Jesús mèn, Jesús naneele' chó mèn nac mèn co' ne'yila'ste loo Jesús no loo cón che'n Jesús. No naneele' Jesús chó mèn nac mèn co' ta'xù' Jesús loo mèn co' guth Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Sya, ndxab Jesús loo mèna: ―Por cona, guniilen loo gu' nec thìb mèn ne'gácte yòo loo cón chenen chele' xuden Diox ne'lide par yòo mèna loo cón chenen. ");
INSERT INTO zamNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Desde huiza par delant, huax mèn co' mdoo nque xís Jesús mblá' Jesús. Ya ne'tolode nque tee no mèna Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Sya, mnibdi's Jesús loo rye si' fchop myen' xin' mté'th Jesús: ―¿Ché' no gu' ndlya's lá' gu' daa no ya ne'tolode que tee no gu' daa, cà'? ");
INSERT INTO zamNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Per Mon Pedr ndoole' mcàb loo Jesús. Ndxab Mon Pedr: ―Tad, chele' nu' lá' U', ¿chó loo ya nu'? Thidte U' ndlu' di's co' nac lìcque' no co' nac di's co' ndlu' xá mod li mèn par yòo ban no mèn Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nu' ndxela'sque' no nonque' nu' le' U' nac Crist co' nac xgan'pe' Diox, Diox co' naban thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mcàb Jesús loo Pedr. Ndxab Jesús: ―Aa. Huenque' nac co' ngue neel ba', Pedr. Yende cón niin lool. Per hui' nexa. Yub daa mcui si' fchop gu'. No thìb gu' co' nzo làth gu' nac xal Mebizya. ");
INSERT INTO zamNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús ngue ta' cuent loo myen' cón che'n Jud Iscariot, xgan' thìb mbi' co' ngro' lèe Mon. Tac Jud mdoo lezo' ta'xù' Jud Jesús loo mèn mastale' ngòc Jud thìb myen' xin' mté'tth Jesús co' ndxòo cuent nac si' fchop myen'. ");
INSERT INTO zamNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ngolo mdoodi's Jesús ryete di's co' mdoodi's Jesús, Jesús ngua que tee par ned le'n yèezya' che'n làaz mèn galile tac ya indlya'ste Jesús ya que tee Jesús par ned le'n yèezya' che'n làaz mèn jude. Non Jesús le' mèn co' nac mèn gulàaz che'n làaz mèn jude mblya's nguthxù' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Le'pe' le'n huiza nde zin gax lni co' ngòc thìb lni co' ndli mèn nación Israel. Lnia ngro' lèe lni che'n ramad. ");
INSERT INTO zamNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Sya, ndxab myen' huespe' Jesús loo Jesús: ―Gro' trè'. Más huen huàa par ned le'n rye yèezya' che'n làaz mèn jude par hui' mèn co' nqueltàa con lùu tya loo con' co' ndlil. ");
INSERT INTO zamNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tac nec thìb mèn co' ndli thìb con', ne'lide mèn con'a xexte. Tac co'se' ndlya's mèn libe' taamas mèn mèna, ndxàal li mèn con' co' ndli mèna loo xnaa. Ya que ndlil chol yalguzye' co' nac yalguzye' roo yalguzye' xèn, huàa li yalguzye' co' ndlil loo xnaa par neda, ne, par ñèe mèna ñeene' ché' tala's mèn tya loo con' ndlil. ");
INSERT INTO zamNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tataa ndxab myen' huespe' Jesús loo Jesús tac axta ne' myen'a indxela'ste loo Jesús no loo con' ndli Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Sya, ndxab Jesús loo myen' huespe' Jesús: ―Tarte zin huiz no tarte zin tiemp co'se' lu'pe'en daa chó nac daa loo mèn. Per part cón che'n gu', aa guneei coyora huenque' naca par gu' co'se' lu' gu' mod co' ndxàp gu' loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Part cón che'n gu', yende mod yòo xyàn lezo' mèn izlyo' ñèe mèn izlyo' gu'. Per ndxe'leque', part cón chenen, mèn izlyo' ndxòoque' xyàn lezo' ñèe mèn izlyo' daa tac daa nda cuent loo mèn izlyo' le' ryete con' ndli mèna nac con' ye'rsin'. ");
INSERT INTO zamNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Huàa gu' lni. Per daa ne'gade lni nalle' tac tarte tyaa huiz no tiemp co'se' lu'pe'en daa loo mèn chó nac daa. ");
INSERT INTO zamNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ngolo tataa ndxab Jesús di'sa loo myen' huespe' Jesús, mbyan' Jesús le'n yèezya' che'n làaz mèn galile. ");
INSERT INTO zamNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Per co'se' ndale' myen' huespe' Jesús lnia, mxen Jesús ned. Nda Jesús lnia, ne. Per ne'nglu' loode Jesús loo mèn loo xnaa. Ndxe'leque', xexte mque tee Jesús làth mèn huiz lnia. ");
INSERT INTO zamNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Le' mèngool co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel na, mèna mque tee cua'n Jesús làth mèn huiz lnia. No mbez mèna loo xtàa mèna: ―¿Pá ned ngue tee mbi'a, yey? ¿Chonon iñèede na' mbi'? ");
INSERT INTO zamNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","No làth rye mèn co' ngua lnia, anze'f thìb mèn mdoodi's cón che'n Jesús. Ndxep mèn mbez: ―Mbi'a nac mbi' ndac. Per taandxep mèn mbez: ―Pà gàc mbi'a mbi' ndac. Ndxe'leque', nquedìi mbi'a mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Per yende chó mèn ngli ryes ndoodi's cón che'n Jesús loo xnaaleque' tac nzyeb mèna ñèe mèna mèngool co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel. ");
INSERT INTO zamNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Co'se' ngrolthe ndxàc lnia, syare' ngòo Jesús le'n templ. Mtlo Jesús, mblu' Jesús mèn le'n templ. ");
INSERT INTO zamNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Sya, rye mèngool co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel ante mbui' no ante gunaa cón che'n di's co' mblu' Jesús loo mèn le'n templ. No mbez mèna loo xtàa mèn: ―¿Xá mod ndxác mbi' ba' huax con' co' ndlu' mbi' ba' loo mèn? Non na' le' mbi' ba' thidtene ne'nglide stud. ¿Cón tub yác mbi' ba'? ");
INSERT INTO zamNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús mcàb loo mèna. Ndxab Jesús: ―Cón che'n con' co' ngue lu'en loo gu' ndxè', inacte con' ndxè' cón chenen. Ndxe'leque', nac con' ngue lu'en loo gu' ndxè' cón che'n xa' co' mtel' daa loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Chele' chó mèn ndlya's li xal ndlya's Diox no xal nee lezo' Diox, leque mèn ta' cuent no ten' mèn le'n lezo' mèn ché' nac di's co' ngue lu'en ndxè' cón che'n Diox o ché' naca di's co' ndyoodizen co' alithe ndlin xtùuz xalque' ndye'th xtùuz yéquen. ");
INSERT INTO zamNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Le' mèn co' ndyoodi's xal ndye'th xtùuz yéc mèn, mèna tataa ndli par leque xtàa mèn li con' guryath no con' guryèn loo mèna. Per mbi' co' más ndxòo yéc gàc con' guryath no con' guryèn loo Diox co' mtel' mbi', mbi'a ndlu' di's co' nac lìcpe' no yende chó yalgutyè' gác mbi' li mbi'. ");
INSERT INTO zamNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Ché' ilìcte naca le' Moisés mtan' di's co' nac ley loo gu', cà'? Mastale' mtan' Moisés di's co' nac ley loo gu', per nec thìb gu' indyubdi'ste xal mbez di's co' nac ley. Chele' di's co' ngue bezen loo gu' ndxè' ilìcte nac, ¿chonon ncua'n gu' mod guthxù' gu' daa, sya? ");
INSERT INTO zamNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Sya, mcàb mèna loo Jesús. Ndxab mèna: ―Aa. Nquée mbii yécl, ndee. ¿Chó mèn ncua'n mod guthxù' mèn lùu, à'? ");
INSERT INTO zamNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús ndxab loo mèna: ―Por mblin thìb con' huiz sabd co' nac huiz descans, con'a ndli ante ngüi' gu' no ante ñaa gu' loon, ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Lìcpe' ba'i, Moisés mda' yalnibe' che'n circuncisión loo gu' mastale' ne'ngàcte yub Moisés co' mtlo mbli circuncidar mèn. Ndxe'leque', xudgool Moisés nerleque' ngòc mèn co' mbli circuncidar mèn. Por cona, gu', ne, ndli circuncidar myen'bi' bix. No yende chó mport nzo lezo' gu' mastale' huiz sabd co' nac huiz descans ndli gu'i. ");
INSERT INTO zamNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Cona, ngue niin loo gu': Chele' xtàa gu' ndxàc circuncidar huiz sabd co' nac huiz descans par tyubdi's gu' loo ley co' mxo'f Moisés loo gu', ¿chonon ndxecloo gu' ñèe gu' daa tac mteyaquen thìb mbi' huiz sabd co' nac huiz descans, sya? ");
INSERT INTO zamNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ne'tub rezte gu' cón chenen por cón che'n mbi' co' gunèe gu' mteyaquen huiz sabd co' nac huiz descans xal ndub rez gu' cón che'n thìb mèn co' ndli con' ye'rsin' huiz sabd. Más huen, nalì no nambìi li gu' xtùuz no bla's gu' loo ley co' mxo'f Moisés loo mèn par ñee gu' ñeene' ché' lé' nac co' mblin loo mbi' co' mteyaquen par ta' gu' cuent co' huenleque', huenque' mblin loo mbi'. ");
INSERT INTO zamNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Látha ngo ndxep mèn co'te' ngo Jesús, mèn co' ngo ban le'n ciuda Jerusalén. Mtlo mèna, mnibdi's mèna loo xtàa mèn: ―¿Ché' inacte mbi' ba' mbi' co' ngue tee cua'n mèn par guth mèn mbi', cà'? ");
INSERT INTO zamNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hui' gu' nexa. Mbi' ba' alanleque' ndyoodi's loo xnaa. No yende chó mbezte mèn loo mbi'. Ne'stolque', lìcque', no mèn co' ñibe' loo na', no co' ndyoo ner, no co' ndyoo naa loo na' ndxela's, ne, le' mbi' ba' nac Crist. ");
INSERT INTO zamNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Per na' nonque' no nanee na' pá mèn mbi' ba'. Per ndxe'leque', co'se' yi'th Crist, yende chó mèn ñee pá ned ryo' tee ryo' yáal Crist, ndyac na', ¿lé'? ");
INSERT INTO zamNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Per co'se' mbìn Jesús tataa nzi nii mèna làth ngue lu' Jesús mèn le'n templ, cabii ndxab Jesús loo mèna: ―Aa. Lìcque', ndlibe' gu' daa. No ndyac gu' naneeque' gu' pá mèn daa. Daa ne'ngalte xal nee lezon. Ndxe'leque', daa ndal loo izlyo' ndxè' xalque' mtel' thìb xa' daa, xa' co' naban thidtene co' nac yub Diox. Per ¡pà libe' gu' xa'a! ");
INSERT INTO zamNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Per daa ndlibe'pe' xa' co' mtel' daa tac loo xa' ngro'en. No mtel' xa' daa. ");
INSERT INTO zamNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Sya, mblya's mèna nghue' mèna Jesús xal ndxe' mèn thìb pres par guth mèn Jesús. Per nec thìb mèna ne'nglide ryes nden mèna Jesús tac tarte zin tiemp co'se' ta' Diox lugar tetìi mèn Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Per mastale' tataa mblya's mèn li no mèn Jesús, huax mèn ngola's loo Jesús. Mèna ndxab loo xtàa mèn: ―¿Xá nee gu'? Co'se' yi'th Crist, ¿ché' tli Crist más yalguzye' leque co' ndli mbi' ba', cà'? ");
INSERT INTO zamNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mèn xley' farise mbìn xal nac di's co' nzi toodi's mèn xexte cón che'n Jesús. Sya, mqueltàa mèna con mèn co' nac jef che'n nguley' co' más ñibe' loo nguley' tiempa par mtel' mèna myen' nac zin' par ya myen' nac zin' le'n templ par ya tenxù' myen' Jesús par hue' myen' Jesús loo mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sya, ndxab Jesús loo myen' nac zin' co' nde tenxù' Jesús: ―Be' go non gu' taapláte huiz. No yiloa beren, biin loo xa' co' mtel' daa. ");
INSERT INTO zamNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Gu' cua'n daa yiloa. Per ya ne'zyál'te gu' daa tac gu' ne'gácte yòo co'te' gòon. ");
INSERT INTO zamNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Le' sya, mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel, mèna mnibdi's loo xtàa mèna: ―¿Pá ned ya mbi' ba'? ¿Chonon mbez mbi' ne'gácte na' zyál' na' mbi'? ¿Ché' ta mbi' loo mèn nación Israel co' nzi tee re's làth mèn nación Grieg par ya lu' mbi' mèn nación Israela tya no sanglu' mbi' mèn nación Grieg, ne, cà'? Pà yila's na'i. ");
INSERT INTO zamNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Lomisque' ne, ¿cón nee di's co' ngolo gunee mbi' loo na' ba' co' nee mbi': Gu' cua'n daa. Per ne'zyál'te gu' daa tac gu' ne'gácte yòo co'te' gòon? ");
INSERT INTO zamNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Per huiz co' ngòc huiz merpe' huiz lni, huiza Jesús ngo too loo mèn. No mtetac Jesús thìb di's loo mèn. Cabii ndxab Jesús: ―Chele' chol gu' ndryo' ndlyen' lezo' yòo gu' loo cón chenen xal mèn co' ndxec lezo' par gu mèn nít, yi'th gu' loon no daa li yo nagàl lezo' gu' loo cón che'n Diox xal mèn co' mbyec tín' lezo' no ngu mèn nít par nagàl yo lezo' mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mèn co' ndxela's loon xalque' mbez di's co' ndub loo libr co' nac xti's Diox, loo mèna li Xpii Natú' le' mèna li huax con' ndac loo xtàa mèna xal ndxàc con' ndac loo mèn co'se' ndli zin' mèn nít co' nzo'f thìb yó'be' par gàca le' xtàa mèna yòo ban noque' Diox thidtene, ne. ");
INSERT INTO zamNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tataa ndxab Jesús loo mèna par mda' Jesús cuent cón che'n Xpii Natú' co' yòo loo mèn co' yila's loo Jesús. Le'n huiza tarte lyàa Xpii Natú' loo mèn tac Jesús tarte yáp loo bé' par gàc con' roo no con' xèn loo Jesús loo bé'. ");
INSERT INTO zamNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Le' sya, ndxep mèn co' ngo làth mèn co' ngure yòn di'sa ndxab: ―Lìcpe' ba'i, mbi' ba' nac thìb mbi' co' nde'th di's co' ndxab Diox co' ndxath yi'th. ");
INSERT INTO zamNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Taandxep mèn mbez: ―Mbi' ba' nac Crist. Per taandxep mèn mbez: ―¿Xá mod ndlya's gu' le' Crist nac mèn che'n thìb yèezya' che'n làaz mèn galile, yey? ");
INSERT INTO zamNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Loo libr co' nac xti's Diox mbez le' Crist gàc bin che'n David co' ngòc rey póla. No gàc Crist xa' yèezpe' Belén co' nac leque yèez co' ngòc liz no làaz David. ");
INSERT INTO zamNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","No ale por conate ngòc chop ned mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Làtha, ngo ndxep mèn co' mblya's ndenxù' Jesús. Per yende chó mèn co' nzo tya ngli ryes nden Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Co'se' mbere myen' nac zin' co' nquenap templ, ndye'th myen' ngua myen' loo Jesús, loo mèn xley' farise, no loo jef che'n nguley' co' más ñibe' loo nguley' tiempa, ndxab mèn xley' farise no mèn co' ngòc jef che'n nguley' co' más ñibe' loo nguley' loo myen': ―¿Chonon ne'ngye'th node gu' mbi'a, à'? ");
INSERT INTO zamNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Myen' nac zin' mcàb loo mèna. Ndxab myen': ―Nu' ndyac thidteneque' yende chó mèn nzo co' ndyoodi's xal ndyoodi's mbi'a, cara. ");
INSERT INTO zamNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sya, mcàb mèn co' ngòc mèn xley' farise loo myen' nac zin'a: ―¿Ché' no gu' mbla' mquedìi mbi'a gu', ne, cà'? ");
INSERT INTO zamNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Ché' yende pá ñee gu' ne'stolque' ngo ndxep mèn co' nac jef che'n nguley' no chol mèn co' nac mèn xley' farise co' ngola's di's co' ndyoodi's mbi'a, à'? ");
INSERT INTO zamNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Per mèn co' nziri' go co' inda'de cuent no co' ne'ñeede co' ndxab di's co' ndub loo ley co' mxo'f Moisés loo mèn, mandit mèn ba' too ze no too yál' tac ndxela's mèn ba' di's co' ndyoodi's mbi'. ");
INSERT INTO zamNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ndoole' Nicodem co' ngua loo Jesús thìb yál', co' ngòc mèn xley' farise, ndxab loo mèna: ");
INSERT INTO zamNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Hui' gu' nexa. Loo ley na' ndlu' indxàalte tetìi na' thìb mbi' co'se' tarte ñee na' no non na' xá nac xquin mbi' co' mbli mbi'. ");
INSERT INTO zamNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Sya, mcàb mèna loo Nicodem. Ndxab mèna: ―¿Ché' no luu nac mèn yèezya' che'n làaz mèn galile, ne, cà'? Bral no bla's co' huen huen loo libr co' nac xti's Diox. Sya, ñeel no ta'l cuent le' le'n yèezya' co' nac ned làaz mèn galile, yende pá mbez loo libr ryo' tee ryo' yáal thìb mbi' co' nde'th di's co' ndxab Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ngoloa, thìb thìb mèna mxen ned, ndyàa mèna par liz mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Le' Jesús na, mxen ned, nda Jesús loo thìb yii co' lèe yii che'n yaa oliv co' ndub gaxte tya. ");
INSERT INTO zamNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Co'se' ngo nìi izlyo' tedib huiz co' nde nquea, mbere Jesús, ngòo Jesús le'n templ tedib vez. No ryete mèn ciuda Jerusalén mqueltàa loo Jesús. Mdub Jesús le'n templ. Mtlo Jesús, mblu' Jesús mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Látha, nde no mèn co' nac maistr co' ndlu' cón che'n ley co' mxo'f Moisés loo mèn thìb xa'got co' ngogaa loo yalburrid loo mèna. Ale mdoo mèna xa'gota xtau'the rye mèn co' nziri' loo Jesús le'n templ. ");
INSERT INTO zamNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Sya, ndxab mèna loo Jesús: ―Maistr, le'pe' ngue li xa'got ndxè' yalburrid con thìb mbi' ngogaa xa' loo nu'. ");
INSERT INTO zamNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","¿Xá nee U', Maistr? Ley co' mxo'f Moisés loo nu' ñibe' loo nu' guth nu' thìb mèngot, co' ndli yalburrid xal xa'got ndxè', con quèe. Gunee U' loo nu' cón ndxàal li nu'. ");
INSERT INTO zamNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ale asembli mèna tataa ndxab mèna loo Jesús par ñee mèna ñeene' ché' tli Jesús con' ndlya's mèna par tataa mod quexù' que' fals mèna Jesús. Per látha, chàa, mdub còo' Jesús loo yòo. Mque' Jesús plá di's loo yòo con cuen ya' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Látha, tolo nzi ñibdi's mèna loo Jesús. Sya, ngo too ndé'f Jesús. Ndxab Jesús loo mèna: ―Chol gu' co' nziri' trè' co' indxàpte xquin no co' indxàpte xtol, ner gu'a fxen quèe no bga'th quèe gu' xa'got ba' no beth gu' xa' thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mbere Jesús, mdub còo' Jesús loo yòo tedib vez. Tolo mque' Jesús taaplá di's loo yòo con cuen ya' Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Per co'se' mbìn mèn co' mquexù' xa'gota di's co' ndxab Jesús loo mèna, ale le'le' mthyon mèna tac leque mèna mden' lezo' ihuente nac con' co' ngue li mèna con xa'gota. Sya, más quee lezo' mèna thìb thìb mèna ngro', ndyàa mèna. Ner, mèn gox mtlo ngro' mbii. Xísa mdoo nque rye myen'bi' co' mqueltàa no mèna. Rye mèn co' ngro'a ngòc mèn co' mquexù' xa'gota loo Jesús. Ngoloa, thidte Jesús mbyan' no xa'gota con mèn co' ngue lu' Jesús le'n templ. ");
INSERT INTO zamNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Sya, ngo too ndé'f Jesús. Mbui' ndxè', mbui' ba' Jesús par ñèe Jesús máa mèna. Ya yende chó mèn ñèe Jesús nziri'. Ante xa'gota no maste ngòc xa'got co' mbyan'. Sya, ndxab Jesús loo xa'gota: ―Ngot, ¿máa mèn co' mquexù' mque' fals lùu, à'? ¿Ché' nec thìb mèna ne'nquexù'de no ne'nque' falste lùu, cà'? ");
INSERT INTO zamNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Sya, mcàb xa'gota. Ndxab xa'gota loo Jesús: ―Yende chó mèn nzo trè' co' mquexù' mque' fals daa, Tad. Sya, ndxab Jesús loo xa'gota: ―Ne' daa ingue quexù'del. Fxen ned. Byàa par lizl nalle'. Ya ne'tolode cua'nl xquinl, ndee. ");
INSERT INTO zamNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mbere Jesús, ndxab Jesús loo mèn co' be' mbyan'a: ―Nde niin tedib con' loo gu', ey: Daa nac xa' co' ndli par ndyub xnìi yéc mèn no par ndyub xnìi lezo' mèn loo izlyo' ndxè' loo cón che'n Diox. Mèn co' tyal yòo loo cón chenen, mèna ne'que tee bante loo con' co' nac xab izlyo' no loo con' co' nac costumbr. Ndxe'leque', con' co' ndlin par tyub xnìi yéc mèn no par tyub xnìi lezo' mèn loo cón che'n Diox, con'a ndli par ncàb loo mèn yòo ban no mèn Diox thidtene. ");
INSERT INTO zamNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sya, ngro' nxon' ndxep mèn xley' farise co' ndxab loo Jesús: ―Leque lùu ngue ta' cuent cón che'n lùu. Per cuent co' nda'l cón che'nl ba' yende cón ntac par nu'. ");
INSERT INTO zamNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús mcàb loo mèna. Ndxab Jesús: ―¿Xá mod? Con' co' niin cón chenen ntacque'. Mastale' leque daa nda cuent cón chenen, daa nanee pá ned ngro'en no naneen pá ned biin yiloa. Per ndxe'leque', gu' ne'ñeede no inda'de gu' cuent pá ned ngro'en. No ne' ne' ñee gu' no ne' ne' inda' gu' cuent pá ned biin yiloa. ");
INSERT INTO zamNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Gu' más ndla's loo mèn xal nac mod co' nzi tee ban mèn loo izlyo' par quexù' gu' mèn. Per part cón chenen, yende chó loo mèn ndlasen loo izlyo' ndxè' par quexù'en mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Per chele' daa ndlas loo mèn loo izlyo' ndxè', nalì no nambìi ndlasen. Tac inacte daa thidte xa' co' ndla's loo mèn par tub rezen loo mèn. Ndxe'leque', xuden Diox co' mtel' daa, thidte ndxàc ryop xud nu' par ndla's nu' loo mèn no tub rez nu' loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Loo ley co' mxo'f Moisés loo gu' ndub di's co' mbez: Co'se' chop mèn co' nac testiu nda' cuent leque cón che'n thìb con', ndxàal yila's mèn cuent co' nda' ryop mèna cuent. ");
INSERT INTO zamNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Cona, ngue niin loo gu': Leque daa nac mèn co' nda' cuent cón chenen. Xuden Diox co' mtel' daa nac tedib xa' co' nda'guè' cuent cón chenen, ne. ");
INSERT INTO zamNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Sya, mnibdi's mèna loo Jesús. Ndxab mèna: ―¿Máa xudl, na? ¿Pá nzo xudl? Jesús mcàb loo mèna: ―Gu' indlibe'de daa no ne' ne' ndlibe' gu' xuden. Tac chele' gu' ndlibe'que' daa, ndlibe'que' gu' xuden, ne. ");
INSERT INTO zamNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Di's ndxè' ndxab Jesús láth ngue lu' Jesús mèn co'te' ndxòosua' caj gòn le'n templ. Yende chó mèn ngli ryes ndenxù' Jesús xal thìb pres tac tarte zin hor co'se' tyactìipe' Jesús par guthxù' mèn Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mbere Jesús, ndxab Jesús loo mèn tedib vez: ―Daa biique' co'te' ngro'en. Gu' cua'nque' daa no gath noque' gu' xtol gu'. Cona, ngue niin loo gu': Co'te' biin, gu' ne'gácte yòo tya. ");
INSERT INTO zamNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Sya, ndxab mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel loo xtàa mèn: ―¿Ché' leque mbi' ba' guth mbi', cona mbez mbi': Co'te' biin, gu' ne'gácte yòo tya, cà'? ");
INSERT INTO zamNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Sya, ndxab Jesús loo mèn tedib vez: ―Lizpe' gu' no làazpe' gu' no che'npe' gu' nac izlyo' ndxè'. Per part cón chenen, lizpe'en no làazpe'en no che'npe'en nac loo bé'. Gu' nac mèn che'npe' izlyo' ndxè'. Per daa inacte che'npe' izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Por cona, ngue niin loo gu': Le' gu' gath noque' xtol gu' tac chele' gu' ne'yila'ste le' daa nacpe' Crist co' mbez mèn Crist, gu' gath noque' xtol gu'. ");
INSERT INTO zamNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Sya, mnibdi's mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel loo Jesús. Ndxab mèna loo Jesús: ―¿Chóxe' nac lùu, à'? Sya, ndxab Jesús loo mèna: ―Daa ya guniile' loo gu' chó nac daa axta co'se' mtlon, mblon yalbàn cón che'n Diox loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Anze'f huax con' ndlyazen niin loo gu'. No anze'f huax con' nzo par tub rezen loo gu'. Lomisque', xa' co' mtel' daa, xa' nda' cuent co' nac lìcpe' loon. Indyè'de xa'a. Di's co' mbìnlen co' nda' xa' cuent loon, cona ndyoodizen loo mèn loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Per ndxe'leque', mèna ne'ta'de cuent no ne'neede mèn le' Jesús ngue toodi's cón che'n Diox co' nac xudpe' Jesús loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Cona, tolo ndxab Jesús loo mèna: ―Co'se' que' gu' daa loo cruz no xít che gu' daa, daa co' mbal yáal loo izlyo' ndxè' xalque' ndxáal chol mèn loo izlyo', loo thìb cruz no too gu' cruz, axta syare' li la's gu' le' daa nac Cristpe'. No syare' ta' gu' cuent yende cón ndlin co' ante guneete lezon. Ndxe'leque', ante ndyoodizen loo gu' xal nac di's co' mblu' xuden Diox loon. ");
INSERT INTO zamNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tac Diox co' nac xuden co' mtel' daa, Diox thidteneque' nzo no daa. Indlá'ya'de xuden Diox daa. Xuden Diox tarte lá' daa thidten tac daa thidteneque' ndli con' co' ndxòo lezo' xuden Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Co'se' ngolo ndxab Jesús di'sa, huax mèn ngola's loo Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Sya, ndxab Jesús loo mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel co' ngola's loo Jesús: ―Chele' gu' thidteneque' li nèe gu' gu' loo con' guniin loo gu', lìcpe' ba'i, le' sya, gàcque' gu' myen' xin' mté'thpe' daa, ");
INSERT INTO zamNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","par tyub xnìi yéc gu' no par tyub xnìi lezo' gu' loo cón che'n Diox par ta' gu' cuent cón che'n con' co' nac lìcpe'. Le' sya, di's co' ndyoodizen co' nac lìcpe' li par ta' gu' cuent inquinte li gu' chol costumbr co' ñibe' yèe loo mèn, no li di's co' ndyoodizen co' nac lìcpe' par lá' gu' ryethe con' co' nac cón che'n xab izlyo'. Tac ryethe con'a ndli mbee ncà gu' loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Le' sya, mcàb mèna loo Jesús. Ndxab mèna: ―Nu' nac bin che'n Abraham. No, thidteneque' tarte gàc nu' xal thìb moz co' ndli yèe zin' ze no yál' loo nec thìb mèn. ¿Chonon mbezl: Nzo con' mbee ncà nu' loo cón che'n Diox, sya? ");
INSERT INTO zamNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús mcàb loo mèna: ―Lìca, na ngue nii loo gu': Ryete mèn co' ncua'n xquin no xtol, mèna nac xal moz yèe loo xquin mèn no loo xtol mèn co' ñibe' loo mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nde niin tedib con' loo gu': Hui' gu' nexa. Mèn co' nac moz loo thìb patrón, mèna thidtene yende mod gàc mèna mèn guliz patrón. Per ndxe'leque', thìb mbyòo co' nac xgan' thìb mbi', mbyòoa thidteneque' ndxòo cuent nac mèn guliz xud mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Por cona, ngue niin loo gu': Chele' daa co' nac xgan' Diox ngue li par ryo xà' gu' loo chol costumbr no loo cón che'n xab izlyo', lìcpe' ba'i, yende chó cón co' nac xab izlyo' co' nac costumbr co' mbed no gu' cuee cà gu' loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Daa naneeque' no ndaquen cuent le' gu' nac bin che'n Abraham co' ngo ban póla. Per ale ndxe'leque', ndlya's gu' guthxù' gu' daa tac indlé'de ndlyàa di's co' ngue niin loo gu' ndxè' le'n lezo' gu'. ");
INSERT INTO zamNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Daa ndyoodiz cón che'n con' co' mblu' xuden Diox loon. Le' gu' na, más ndxòo lezo' gu' li gu' con' co' gunee xud gu' loo gu' par li gu' cón mbez xud gu' li gu'. ");
INSERT INTO zamNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mcàb mèna loo Jesús. Ndxab mèna: ―Abraham nac xudgool nu'. Jesús ndxab loo mèna: ―Chele' gu', lìcque', ngàc bin che'n Abraham, ngàp gu' mod co' ngòp Abraham, no ngli gu' xal mbli Abraham, sya, xàa. ");
INSERT INTO zamNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Per mastale' mbez gu' nac gu' mèn co' nac bin che'n Abraham, ale ndxe'leque', ndlya's gu' guthxù' gu' daa. No, ndxòn gu' le' daa ngue ta' cuent co' nac lìcpe' co' mblu' Diox loon loo gu'. Fta' gu' cuent co' huenleque' le' Abraham thidteneque' ne'nglide xal ndlya's gu' li no gu' daa nalle'. Por cona, inacte gu' binpe' Abraham. ");
INSERT INTO zamNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Gu' ndlique' cón ndli xud gu'. Sya, mcàb mèna loo Jesús. Ndxab mèna: ―Nu' inacte xin' chop son mbi', co' nee di's, inacte nu' xin' thìb xna' nu'. Thidte xud nu' ngue no nu', co' nac Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Sya, mcàb Jesús loo mèna. Ndxab Jesús: ―Chele' xud gu', lìcque', ngàc Diox, gu' huen ngàc con daa no que'que' lezo' gu' ñèe gu' daa tac daa ngro' loo Diox. Cona, ndalen loo izlyo' ndxè' no nzon trè'. Ne'ngàlten por gunee lezon. Ndxe'leque', Diox mtel' daa. Cona, ndalen loo izlyo' ndxè'. ");
INSERT INTO zamNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Chonon inda'de gu' cuent no indxaa'dte gu' di's co' nde teele' ndan cuent loo gu', à'? Neequen chonon indlya'ste gu' tyal gu' gòn gu' di's co' ngue tan cuent loo gu'. Tac gu' indlya'ste gòn di's cón che'n Diox co' ngue tan cuent loo gu'. Con'ai. ");
INSERT INTO zamNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Na nii loo gu': Xa' co' nac xud gu'a nac Mebizya. Le' gu' na, nac mèn co' ndli ryethe con' co' ndryo' ndlyen' lezo' xud gu' co' nac Mebizya. Mebizya ngòcle' thìb xa' co' ndli par ndxuthxù' mèn xtàa mèn loo izlyo' anon ngure izlyo'. No thidteneque' indxòode lezo' Mebizya gòn Mebizya con' co' nac lìcpe'. Ne' ne' indxòo lezo' Mebizya tyoodi's Mebizya con' co' nac lìcpe'. Co'se' ndyoodi's Mebizya di's co' nac yalgutyè'túb, ngue lu' Mebizya xal nac Mebizya no xal nac mod co' ndxàp Mebizya. Tac Mebizya nacpe' thìb xa' gutyè'. No nac Mebizya thìb xa' co' ndli par ndxàc taamas mèn che'n izlyo' mèn gutyè'. ");
INSERT INTO zamNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Per com le' daa ndyoodi's di's co' nac lìcpe' cón che'n Diox, cona, ne'tyalte gu' yila's gu' di's co' ndyoodizen. ");
INSERT INTO zamNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Per nalle' ndlyazen ñeen chó thìb gu' ñee loon le' daa ndxàp xtol. Chele' daa ndyoodi's di's co' nac lìcpe' cón che'n Diox, ¿chonon indxela'ste gu' loo di's co' ndyoodizen loo gu', sya? ");
INSERT INTO zamNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mèn co' ngòo loo cón che'n Diox par nac mèna che'n Diox, mèna ndyal par ndxòn mèna di's co' nac xti's Diox. Per com le' gu' inacte mèn co' nzo loo cón che'n Diox, por cona, indlya'ste gu' tyal gu' par ta' gu' nza gu' par gòn gu' di's co' ndyoodizen. ");
INSERT INTO zamNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sya, mcàb mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel loo Jesús. Ndxab mèna: ―Nu' ndyac huenque' nac di's co' ngue bez nu' lool le' lùu nac thìb mbi' yèezya' che'n làaz mèn samari no nzo thìb xpii ye'rsin' lool. ");
INSERT INTO zamNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Mcàb Jesús loo mèna. Ndxab Jesús: ―Inzode nec thìb xpii ye'rsin' loon. Ndxe'leque', con' co' ndlin ndli le' loo xuden gàc con' guryath no con' guryèn. Per gu', ale ndxe'leque', indlide par gàc con' guryath no con' guryèn loon. ");
INSERT INTO zamNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Daa incua'nte mèn co' li par gàc con' guryath no con' guryèn loon. Daa nanee nzoque' thìb xa' co' ncua'n mod par li xa' gàc con' guryath no con' guryèn loon. Xa'a ndub rez loo mèn co' ne'tyalte li con' guryath no con' guryèn loon. ");
INSERT INTO zamNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Lìcpe' ba'i, na ngue nii loo gu': Le' mèn co' ndyub nza no nda' mèn lugar par ndxòn mèn di's co' ndyoodizen, mèna yòo ban noque' Diox thidtene. No ne'co' xà'de Diox mèna. No ne'co' toode Diox mèna loo Diox co'se' ngolo nguth mèna. ");
INSERT INTO zamNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Le' sya, mcàb mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel loo Jesús. Ndxab mèna: ―Nase mbli la's nu' nzoque' thìb xpii ye'rsin' lool. Abraham nguth. Ryete mèn co' mde'th di's co' ndxab Diox nguth, ne. No lùu ale mbez: Mèn co' tyub nza no gòn mèn di's co' mbezen, mèna thidteneque' ne'gathte. ");
INSERT INTO zamNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tlate ñeel nacl más xa' roo xa' xèn no más mèngool leque xudgool na' Abraham co' nguth. Abraham nguthque'. No ryete mèn co' mde'th di's co' ndxab Diox nguthque'. ¿Chóxe' mèn mbezl nacl, sya? ");
INSERT INTO zamNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús mcàb loo mèna. Ndxab Jesús: ―Chele' daa yub ndli par ndxàc con' guryath no con' guryèn loon, le' sya, con' guryath no con' guryèn co' nglin ngàc loona yende cón ntaca loo Diox co' mtel' daa. Per xa' co' ndli par ndxàc con' guryath no con' guryèn loon, xa'a nac Diox co' nac xudpe'en. No nac xa' merpe' xa' co' mbez gu' nac Dioxpe' gu'. ");
INSERT INTO zamNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gu' indlibe'de xa' co' nac Diox xudpe'en. Per daa ndlibe'que' xuden Diox. No chele' daa nii loo gu' indlibeden xuden Diox, sya, lalque' ndyè' daa xal ndyè' gu'. Per ndxe'leque', daa ndlibeque' Diox co' nac xuden. No ndlin cas xalque' nac di's co' ndyoodi's Diox co' nac xudpe'en loon. ");
INSERT INTO zamNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham co' ngòc xudgool gu' póla, axta gust mbyan' lezo' Abraham láth ndub quee lezo' Abraham huiz co' gàc huiz galen loo izlyo' ndxè'. Gunèeque' Abraham co'se' ngòc huiz co' mbalen loo izlyo' ndxè'. No mdyac lezo' Abraham axta plóthe cón che'n huiza. ");
INSERT INTO zamNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Le' sya, ndxab mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel loo Jesús: ―Ne' ne' tar taal cho' psi' lin' no ¿mbezl gunèelel Abraham co' ngòc xudgool na', cà'? ");
INSERT INTO zamNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús mcàb loo mèna. Ndxab Jesús: ―Lìca, na nii loo gu': Ndoore' co'se' tarte gáal Abraham, nzolen. ");
INSERT INTO zamNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Per co'se' mbìn mèna tataa ndxab Jesús, mxen mèna quèe par gathquèe mèna Jesús. Per ale, chàa, mdyon' Jesús loo mèna. Ale ne'nda'de mèna cuent ngro' Jesús loo mèna le'n templ. Mxen Jesús ned, ndyaa Jesús. ");
INSERT INTO zamNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Láth nda riid Jesús par ned nda Jesús, gunèe Jesús thìb mbi' sieu co' ngóol sieu co' ndub par neda. ");
INSERT INTO zamNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Myen' xin' mté'th Jesús mnibdi's loo Jesús. Ndxab myen': ―Maistr, ¿chonon texal ngóol mbi' ba' sieu mbi', à'? ¿Ché' tac ngòp xud mbi' xtol xud mbi' no ngòp xna' mbi' xtol xna' mbi' cona ngóol mbi' sieu o ché' naca por xtolpe' mbi', cona ngóol mbi' sieu, cà'? ");
INSERT INTO zamNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús ndxab loo myen': ―Aa que tont gu' se. Ne'ngáalte mbi' ba' sieu por xtolpe' mbi'. Ne' ne' ngáal mbi' sieu por xtol xud mbi' no por xtol xna' mbi'. Ndxe'leque', mbi' ba' ngóol sieu par ryo xo'f con' ndxác Diox li Diox loo mèn loo xnaa loo mbi'. ");
INSERT INTO zamNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ndxàalque' lin zin' co' nac rsin' xa' co' mtel' daa láth be' ngue tee'en loo izlyo' ndxè' xal ndli mèn zin' ndxáal ze co'se' ntenìi xnìi huiz. Tac yé' huize' gàca loon xal co'se' nde yál' loo izlyo' no yende chó mèn gác li zin' hora. ");
INSERT INTO zamNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Cona, niin loo gu': Láth be' nzon loo izlyo' ndxè' nac daa xa' co' ndli par ndyub xnìi yéc mèn no par ndyub xnìi lezo' mèn co' nziri' loo izlyo' ndxè' loo cón che'n Diox. ");
INSERT INTO zamNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ngolo gunii Jesús di'sa loo myen' xin' mté'th Jesús, msuc Jesús loo yòo. No mcos Jesús chu'th ben loo yòo con rsuc Jesús. Ngoloa, mtà Jesús bena ngudloo mbi' sieua. ");
INSERT INTO zamNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ngoloa, ndxab Jesús loo mbi'a: ―Huàa tech ngudlool ro tanc co' lèe Siloé ba'. Di's Siloé nee di's ntel' mèn mèn. Sya, xex xex nda mbi' sieua ro tanc. Ngua tech mbi' ngudloo mbi'. Co'se' mbere mbi', ndye'th mbi' loo Jesús, ndxe'sleque' ngüi' mbi'. ");
INSERT INTO zamNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Sya, rye mèn co' nzi'f liz gax co'te' ndub liz xud mbi' no rye mèn co' gunèe mbi' ndoore' xyal' ngudloo mbi', mèna ndxab loo xtàa mèn: ―¿Ché' inacte mbi' ba' mbi' sieu co' ndyub ña'b gòn, cà'? ");
INSERT INTO zamNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sya, mbez ndxep mèn loo xtàa mèn: ―Aa. Mbi' ba'i. Per taandxep mèn mbez: ―Tyè'. Inacte mbi' ba' mbi'a, yey. ¿Ché' indyacte gu' te' ñaa mbi'a ñaa mbi' ba', ¿lé'? Per yub mbi' sieu mbez loo mèna: ―Daaai. ¿Ché' ngue li gu' cuent inacte daa mbi'a, cà'? ");
INSERT INTO zamNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Sya, mnibdi's mèna loo mbi' sieua. Ndxab mèna loo mbi': ―¿Xá mod ngòca lool? ¿Chonon ngüi'lel nalle', sya? ");
INSERT INTO zamNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mbi' mcàb loo mèna. Ndxab mbi': ―Mbi' co' lèe Jesús mcos chu'th ben loo yòo. Ngoloa, mtà mbi' ben ngudloon. No gunee mbi' loon: Huàa tech ngudlool ro tanc che'n Siloé ba'. Ngua techen ngudloon. No co'se' ngolo mtechen ngudloon, chàa, ndxe'sleque' mbui'en. ");
INSERT INTO zamNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Sya, mnibdi's mèna loo mbi'. Ndxab mèna: ―¿Pá nzo mbi' co' lèe Jesús nalle', à'? Mbi' sieua mcàb: ―Ne no. Ne'needen pá nzo mbi'. ");
INSERT INTO zamNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Sya, mbe' mèna mbi' co' ngóol sieua loo mèn xley' farise. ");
INSERT INTO zamNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Huiz co'se' mcos Jesús ben no mxal' Jesús ngudloo mbi' sieua, huiza ngòc huiz sabd co' ngòc huiz descans tiempa. ");
INSERT INTO zamNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Sya, mbere mèn xley' farise, mnibdi's mèna loo mbi'a tedib vez: ―¿Xá mod ngòc mxyal' ngudlool par ngüi'l nalle', à'? Ndxab mbi' loo mèna: ―Mbi' co' lèe Jesús mtà chu'th ben ngudloon. Ngoloa, ngua techen ngudloon. Cona, ndxe'selque' ngüi'en nalle'. ");
INSERT INTO zamNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Sya, ndxab ndxep mèn xley' farisea loo mbi' co' ngóol sieu: ―Mbi' co' mbli con'a con lùu, mbi'a inacte mèn che'n Diox tac indlide mbi' cas huiz sabd co' nac huiz descans. Per taamas mèn mbez: ―Per ¿xá ngobe' gu' xá mod gác thìb mbi' co' ndxàp xtol li mbi' yalguzye' co' ngòc loo mbi' ba', yey? No ale leque mèn xley' farise ngro yoo di's làth xtàa mèn. ");
INSERT INTO zamNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Per indryo'de lezo' mèn xley' farise ngòc con'a loo mbi'a. Mbere mèn, mnibdi's mèn loo mbi' co' ngóol sieu tedib vez: ―Lùua, ¿cón tolo ñeel loo nu' cón che'n mbi' co' mbli mdyub xnìi ngudlool, à'? Mbi' co' ngòc sieu ndxab: ―Pues part cón chenen, ndyaquen mbi' nac xa' co' nde'th di's co' ndxab Diox, xàa. ");
INSERT INTO zamNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nde nxon', thidteneque' ne'ndalte mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel ngala's mèna le' mbi'a ngòc sieu no hora ngüi'le' mbi'. Ne'ngro'de lezo' mèn con'a. Mbli mèna par ngua rez mèn xud mbi' no xna' mbi' co' ngüi'le'. ");
INSERT INTO zamNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Sya, mnibdi's mèna loo xud mbi' no loo xna' mbi'. Ndxab mèna: ―¿Ché', lìcque', nac mbi' ndxè' xgan' gu' co' mbez gu' ngóol sieu, cà'? Chele'i tataa nac, ¿xá mod ngòca loo mbi' ngüi' mbi nalle', sya? ");
INSERT INTO zamNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mcàb xud mbi' no xna' mbi' loo mèna. Ndxab ryop xa': ―Nu' nanee le' mbyòo ba' nac xgan' nu'. No, lìca, anon ngóol mbyòo sieu mbyòo. ");
INSERT INTO zamNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Per nalle' nu' ne'ñeede no ne'ta'de nu' cuent xá mod mdyub xnìi ngudloo mbyòo par ngüi' mbyòo. Ne' ne' ñee nu' no ne' ne' ta' nu' cuent chó mbli par mdyub xnìi ngudloo mbyòo par ngüi' mbyòo. Mbyòo ngoxle'. Bnibdi's gu' loo mbyòo. Leque mbyòo ta' cuent cón che'n mbyòo loo gu'. ");
INSERT INTO zamNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ale tataa ndxab xud mbi' no xna' mbi' loo mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel tac nzyeb ryop sa'l xa' ñee xa' mèn co' ñibe', no co' ndyoo ner, no co' ndyoo naa loo mèn nación Israel. Tac mèna mbli mandad no mdoodi'sle' mèna chele' chol mèn co ro le' Jesús nacque' Crist, ale co' chug mèn co' ñibe', no co' ndyoo