﻿USE sofia;
DROP TABLE IF EXISTS sofia.zajp_vpl;
CREATE TABLE zajp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zajp_vpl WRITE;
INSERT INTO zajp_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Haichanduso Mulungu kalumba ulanga na isi. ");
INSERT INTO zajp_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Isi ikala mzanyamzanya na ikala bule kinhu, na ziza dikala digubike vilindi va mazi, na Loho wa Mulungu kakala yaituzile uchana ya igamazi. ");
INSERT INTO zajp_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Abaho Mulungu kalonga, “Ulawilile mulangaza,” na mulangaza ulawilila. ");
INSERT INTO zajp_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Mulungu kanogelwa na uja umulangaza. Avo kaugola umulangaza kulawa mdiziza. ");
INSERT INTO zajp_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Mulungu kaukema mulangaza “Imisi,” na ziza kadikema “Ikilo.” Iwa ichungulo, iwa imitondo, zua da ichanduso. ");
INSERT INTO zajp_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Abaho Mulungu kalonga, “Na kuwe na ubenhu hagatigati ya igamazi, ugagole mazi ga kuulanga na mazi ga muisi.” ");
INSERT INTO zajp_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Avo Mulungu katenda ubenhu, na kugagola igamazi, gayagwe hasi na gayagwe uchana. Na ilawilila kamba viyalongile. ");
INSERT INTO zajp_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Mulungu kaukema uja uubenhu “Ulanga.” Iwa ichungulo, iwa imitondo, zua da ikabili. ");
INSERT INTO zajp_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Abaho Mulungu kalonga, “Mazi gali hasi ya ulanga gaiting'hane hanhu hamwe, giladi hanhu hanyalile honeke.” Na ilawilila kamba viyalongile. ");
INSERT INTO zajp_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mulungu kahakema hanhu hanyalile “Isi,” na kahakema hanhu hali na igamazi “Bahali.” Mulungu kanogelwa na kija kiyatendile. ");
INSERT INTO zajp_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Abaho Mulungu kalonga, “Isi na yoteze mijani ya namna zose, miche ilela mbeyu na mibiki ilela mijo ili na mbeyu mgati yake.” Na ilawilila kamba viyalongile. ");
INSERT INTO zajp_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Avo isi yoteza mijani ya namna zose, miche ilela mbeyu na mibiki ilela mijo ili na mbeyu mgati yake. Na Mulungu kanogelwa na kija kiyatendile. ");
INSERT INTO zajp_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Iwa ichungulo, iwa imitondo, zua da ikadatu. ");
INSERT INTO zajp_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Abaho Mulungu kalonga, “Na iwe milangaza kuulanga iigole imisi na ikilo, iwe kamba vilaguso vondavilaguse vipigiti, mazua, na milao, ");
INSERT INTO zajp_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","imwemwese kuulanga ilave mulangaza muisi.” Na ilawilila kamba viyalongile. ");
INSERT INTO zajp_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Avo Mulungu kaitenda milangaza mikulu mibili, mulangaza mkulu ng'hani umwemwese imisi na umulangaza mdodo umwemwese ikilo. Vivija kazitenda na nhondo. ");
INSERT INTO zajp_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Mulungu kaika kuulanga ija imilangaza giladi ilave mulangaza muisi, ");
INSERT INTO zajp_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","imwemwese imisi na ikilo, na uugole mulangaza kulawa mdiziza. Na Mulungu kanogelwa na kija kiyatendile. ");
INSERT INTO zajp_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Iwa ichungulo, iwa imitondo, zua da ikane. ");
INSERT INTO zajp_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Abaho Mulungu kalonga, “Mazi na gameme vinhu vili na ugima. Na ndege waguluke kuulanga.” ");
INSERT INTO zajp_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Avo Mulungu kawalumba wang'onyo wakulu wa m'bahali na kila kinhu kili na ugima kitembela mmazi na ndege wa kila namna. Na Mulungu kanogelwa na kija kiyatendile. ");
INSERT INTO zajp_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Mulungu kawamoteza na kulonga, “Leleni mkongezeke muimemeze bahali, na ndege wongezeke muisi.” ");
INSERT INTO zajp_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Iwa ichungulo, iwa imitondo, zua da tano. ");
INSERT INTO zajp_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Abaho Mulungu kalonga, “Wang'onyo wa kila namna wene ugima nawalawilile muisi, wang'onyo wofugigwa na wang'onyo wa kumuhulo, wakulu na wadodo.” Ilawilila kamba viyalongile. ");
INSERT INTO zajp_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Avo Mulungu kawatenda wang'onyo hiwo wose, na kanogelwa na kija kiyatendile. ");
INSERT INTO zajp_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Abaho Mulungu kalonga, “Na tuwatende wanhu wawe kamba tweye na walinge na tweye. Wakatawale somba, ndege, na wang'onyo wose wofugigwa na ulumwengu wose, wakatawale vinhu vose vilumbigwe na Mulungu vitembela muisi.” ");
INSERT INTO zajp_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Avo Mulungu kamulumba munhu yalingile na heyo mwenyego. Kawalumba mtwanzi na mbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Mulungu kawamoteza, na kawalongela, “Leleni mkongezeke, giladi muimemeze isi na muitawale. Muwatawale somba, ndege, na kila kinhu kili na ugima kitembela muisi.” ");
INSERT INTO zajp_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Abaho Mulungu kalonga, “Lola, niwagwelela miche ilela mbeyu muisi yose, na mibiki ilele mujo uli na mbeyu mgati yake. Vinhu hivo vowa mandia genu. ");
INSERT INTO zajp_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Wang'onyo wose wa mmuhulo, na ndege wose, na kila kinhu kili na ugima, niwagwelela usoti na mibiki ili na mijani viwe mandia gao.” Na ilawilila kamba viyalongile. ");
INSERT INTO zajp_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Mulungu kavilola vinhu vose viyavitendile, na kanogelwa navo ng'hani. Iwa ichungulo, iwa imitondo, zua da sita. ");
INSERT INTO zajp_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Avo ulanga na isi na vinhu vose vili mgati yake vimambukizwa kulumbigwa. ");
INSERT INTO zajp_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Na mdizua da saba Mulungu kakala yamambukize sang'hano yake iyakalile yoisang'hana, na mdizua hijo kahumula. ");
INSERT INTO zajp_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Avo Mulungu kadimoteza zua da saba na kaditenda diwe zua ding'alile, kwavija mdizua hijo Mulungu kakala yamambukize sang'hano yake ya kulumba, na kahumula. ");
INSERT INTO zajp_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Avo vino vivo ulanga na isi vuvilumbigwe. MNDEWA Mulungu viyalumbile ulanga na isi, ");
INSERT INTO zajp_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","hakukalile na mche muna iisi na hakukalile na mbeyu zotile, kwavija MNDEWA Mulungu kakala hanaitenda mvula itoe, na hakukalile na munhu yoyose yailimile iisi. ");
INSERT INTO zajp_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ila nzokwe za mazi zilawa hasi na kuitapagiza isi yose. ");
INSERT INTO zajp_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Abaho MNDEWA Mulungu kamulumba munhu kulawa mditimbwisi da isi, na kumuhumulila mmhula yake mhumuzi igela ugima, na ija imunhu kawa na ugima. ");
INSERT INTO zajp_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Abaho MNDEWA Mulungu kahanda kihati ng'ambu ya ulawilo wa zua, hanhu hokemigwa Edeni. Na himo kamwika ija imunhu iyamulumbile. ");
INSERT INTO zajp_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Na MNDEWA Mulungu kaitenda mibiki ya namna zose ikule kulawa muisi, mibiki inogeza meso na inogile sama ya mandia. Hagatigati ya ikihati kukala na m'biki ulava ugima na m'biki uwatenda wanhu wagatange ganogile na gehile. ");
INSERT INTO zajp_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Lwanda lukuluma kulawa Edeni, lukitapagiza ikihati, abaho lukiigola mianza mine. ");
INSERT INTO zajp_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Lwanda lwa ichanduso lokemigwa Pishoni, alo lukuluma muisi yose ya Havila, ako kuli na zahabu. ");
INSERT INTO zajp_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Na zahabu ya isi ija ing'ala. Ako vivija kukalile na mavuta ga kunung'hila na namna za mabwe gokemigwa shohamu. ");
INSERT INTO zajp_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Lwanda lwa ikabili lokemigwa Gihoni, alo lukuluma muisi yose ya Kushi. ");
INSERT INTO zajp_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Lwanda lwa ikadatu lokemigwa Tigilisi, alo lukuluma mwambu wa ulawilo wa zua wa wambo da Ashulu. Na lwanda lwa ikane lokemigwa Yuflati. ");
INSERT INTO zajp_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","MNDEWA Mulungu kamwika ija imunhu mgati ya kija Ikihati cha Edeni yakihalile na kukilola goya. ");
INSERT INTO zajp_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Na MNDEWA Mulungu kamulongela ija imunhu, “Dia mujo kulawa mum'biki wowose uli mkihati, ");
INSERT INTO zajp_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ila mujo wa m'biki uwatenda wanhu wagatange ganogile na gehile sambiuje, kwavija kipigiti vondauje mujo hiwo, kodanganhika.” ");
INSERT INTO zajp_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Abaho MNDEWA Mulungu kalonga, “Havilumbile munhu ino kukala yeiyeka. Nomtendela wa kumtaza yalumbile kumwake heyo.” ");
INSERT INTO zajp_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Avo MNDEWA Mulungu kasola ulongo kulawa muisi na kawatenda wang'onyo wose na ndege wose. Abaho kawagala ha ija imunhu giladi yawagwelele matwaga. Twaga jojose ija imunhu diyamgwelele kila mwene ugima dikala dijo twaga jake. ");
INSERT INTO zajp_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Avo ija imunhu kawagwelela matwaga ndege wose na wang'onyo wose. Ila hakukalile na wa kumtaza yalumbile kumwake heyo. ");
INSERT INTO zajp_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Abaho MNDEWA Mulungu kamtenda ija imunhu yakuluze, na kipigiti viyakalile yokuluza, kalubabazula lubavu lumwe lwa ija imunhu na kuhagubika hanhu haja na nyama. ");
INSERT INTO zajp_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Abaho MNDEWA Mulungu kamtenda mtwanzi kulawa mulubavu luja na kumgala ha ija imunhu. ");
INSERT INTO zajp_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Na ija imunhu kalonga, “Ino iyo zege mmizege yangu na lukuli mulukuli lwangu. Avo kokemigwa mtwanzi kwavija kababazuligwa kulawa mwa mbigalo.” ");
INSERT INTO zajp_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Sama ya kilamso kino mbigalo kowaleka tataake na mamaake na kuilumba na mtwanzi wake, na hewo wowa lukuli lumwe. ");
INSERT INTO zajp_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ija imbigalo na mtwanzi wake wose wakala mwazi, na hawonile kinyala. ");
INSERT INTO zajp_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nyoka kakala m'bala ng'hani kubanza wang'onyo wose wa kumuhulo yaawalumbile MNDEWA Mulungu. Nyoka kamuuza ija imtwanzi, “Kweli Mulungu kawalongela kamba sambimuje mujo wa m'biki wowose uli mkihati?” ");
INSERT INTO zajp_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ija imtwanzi kamwidika, “Todaha kuja mujo wa m'biki wowose uli mkihati, ");
INSERT INTO zajp_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ila Mulungu kalonga, ‘Sambimuje mujo wa m'biki uli hagatigati ya ikihati ama kuukwasa. Kamba muhatenda avo, modanganhika.’ ” ");
INSERT INTO zajp_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Nyoka kamulongela ija imtwanzi, “Hamdanganhika, ");
INSERT INTO zajp_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","kwavija Mulungu kovitanga kamba kipigiti vondamje mujo uno, meso genu gogubuligwa, na mowa kamba Mulungu, mogatanga ganogile na gehile.” ");
INSERT INTO zajp_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ija imtwanzi viyawene kamba mujo wa m'biki uja unoga kudigwa, na wonogeza meso, na vivija wosulukilwa mkongeza ng'hungwe, kasola mujo wake kauja. Kamgwelela mbigalo wake, na heyo vivija kaja. ");
INSERT INTO zajp_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Kipigiti kikija viweshile kuja, meso gao gagubuligwa, na wavitanga kamba wakala mwazi. Avo washona mijani ya m'biki wa mtini wakiivaza. ");
INSERT INTO zajp_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Abaho ija imbigalo na mtwanzi wake wadihulika dizwi da MNDEWA Mulungu viyakalile yotembela mkihati mkipigiti cha zua kuhonga, wakiifisa mmibiki ili mkihati giladi MNDEWA Mulungu sambiyawone. ");
INSERT INTO zajp_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ila MNDEWA Mulungu kamkema ija imunhu, na kumuuza, “Kwa kwahi?” ");
INSERT INTO zajp_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ija imunhu kedika, “Nikuhulika vuutembela mkihati, nidumba, kwavija nie nikala mwazi, avo nikiifisa.” ");
INSERT INTO zajp_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","MNDEWA Mulungu kamulongela, “Yalihi yakulongele kamba gweye kwa mwazi? Kuja mujo uja unikulagize sambiuje?” ");
INSERT INTO zajp_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ija imunhu kedika, “Ija imtwanzi yuunigwelele yawe hamoja na nie, iyo yanigwelele mujo uja, na nie nija.” ");
INSERT INTO zajp_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","MNDEWA Mulungu kamuuza ija imtwanzi, “Habali utendile vino?” Kedika kalonga, “Nyoka kanibulunya, na nie nija.” ");
INSERT INTO zajp_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Abaho MNDEWA Mulungu kamulongela nyoka, “Kwavija kutenda vino, gweye wiyeka kudukumizwa mmwanza wa wang'onyo wose, wofugigwa na wa kumuhulo. Kotambala na inda yako, na koja timbwisi mazua gose ga ugima wako. ");
INSERT INTO zajp_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nokwika udumuka hagatigati yako na ija imtwanzi, hagatigati ya wanago na wanage. Heyo kokuhonda ditwi jako, na gweye komulumiza kisiginho chake.” ");
INSERT INTO zajp_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Abaho kamulongela ija imtwanzi, “Nowongeza usungu wako wa kulela, na gweye kolela na usungu, hata avo sulukila yako yowa ha mbigalo wako, na heyo kokutawala.” ");
INSERT INTO zajp_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Abaho kamulongela ija imbigalo, “Kwavija gweye kumtegeleza mtwanzi wako, na kuja mujo uja unikulongele sambiuje, isi yodukumizwa. Kopata mandia gako mkugaya ng'hani mkuilima isi mmazua gose ga ugima wako. ");
INSERT INTO zajp_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Isi yokulelela miba na mijani, na mandia gako gowa mijani ya kumgunda. ");
INSERT INTO zajp_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Koja mandia gako mkusang'hanika ng'hani mbaka vondauibwelele isi ija iulumbigwe nayo. Kwavija kulumbigwa na timbwisi, na kobweleganya kuwa timbwisi kabili.” ");
INSERT INTO zajp_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamu kamkema mtwanzi wake Hawa, kwavija kowa mama wa wanhu wose. ");
INSERT INTO zajp_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Abaho MNDEWA Mulungu kawatendela Adamu na mtwanzi wake vivalo va ng'hwembe za wang'onyo na kawavaza. ");
INSERT INTO zajp_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Abaho MNDEWA Mulungu kalonga, “Lola, munhu ino sambi kalinga na tweye, kogatanga ganogile na gehile. Vivija sambiyagolose mkono wake na kubawa mujo kulawa mum'biki ulava ugima, na kuuja, na kuwa mgima mazua gose.” ");
INSERT INTO zajp_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Avo MNDEWA Mulungu kamuwinga kulawa Mkihati cha Edeni na kumtenda yakailime isi ija iyalumbigwe nayo. ");
INSERT INTO zajp_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Viyeshile kuwawinga waja iwanhu, keka Makelubi ng'ambu ya ulawilo wa zua wa Ikihati cha Edeni na kwika zele dili na moto dimeluka dihindukahinduka kuno na kuno kwiimiliza nzila ya kuchola hana um'biki ulava ugima. ");
INSERT INTO zajp_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu kawasa na mtwanzi wake Hawa, na Hawa kapata inda. Kamulela mwana mbigalo, kalonga, “MNDEWA kanitaza, nilela mwana mbigalo.” Avo kamgwelela twaga dikemigwa Kaini. ");
INSERT INTO zajp_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Abaho kamulela mwana iyagwe mbigalo kamkema Abeli. Abeli kakala mchunga ng'hondolo, na Kaini kakala mulimi. ");
INSERT INTO zajp_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kipigiti cha kuhuna vikivikile, Kaini kagala fungu da vakuja vake na kudilava nhosa ha MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abeli nayo kagala wana ng'hondolo wa udele kulawa mdidale jake, kawachinja, na kulava fungu da nyama zinonile ha MNDEWA. MNDEWA kanogelwa na Abeli na nhosa yake, ");
INSERT INTO zajp_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ila kamulema Kaini hamoja na nhosa yake. Kaini kona lusango ng'hani, na kihanga chake kikala kisifukila. ");
INSERT INTO zajp_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Abaho MNDEWA kamulongela Kaini, “Habali wona lusango? Habali kihanga chako kisifukila? ");
INSERT INTO zajp_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kamba uhatenda ganogile, hutogoligwa? Ila kamba uhatenda gehile, vilozo vokubeta hana ulwivi lwako, vokusulukila gweye, ila kolondigwa uvihume.” ");
INSERT INTO zajp_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Abaho Kaini kamulongela mdodo wake Abeli, “Tuchole kumgunda.” Kipigiti viwakalile kumgunda, Kaini kamvamhila mdodo wake na kumkoma. ");
INSERT INTO zajp_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Abaho MNDEWA kamuuza Kaini, “Kakwahi mdodo wako Abeli?” Na heyo kamwidika, “Sivimanya. Nie iyo mwimilizi wa mdodo wangu?” ");
INSERT INTO zajp_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","MNDEWA kamulongela, “Kutenda choni? Tegeleza! Mulopa wa mdodo wako wonililila kulawa muna iisi. ");
INSERT INTO zajp_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Gweye kudukumizwa na kuwingigwa kulawa muisi, isi ayo igubule mulomo wake na kubokela mulopa wa mdodo wako yuumkomile na makono gako. ");
INSERT INTO zajp_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kipigiti uhailima, isi haikulelela vakuja. Kowa munhu yalibule kae na kwanga muisi.” ");
INSERT INTO zajp_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaini kamulongela MNDEWA, “Nhaguso ino iwa ng'hulu ng'hani kumwangu kubanza vinidaha kuyazaganya. ");
INSERT INTO zajp_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Gweye kuniwinga nie kulawa muisi, na kunika kutali kulawa haulongozi wako. Nowa munhu nilibule kae na kwanga muisi, na munhu yoyose yondayanyone nie kong'homa.” ");
INSERT INTO zajp_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ila Mulungu kamulongela, “Bule. Kamba munhu yoyose yokukoma gweye, kobwelezeligwa mianza saba.” Avo MNDEWA kamwika utango Kaini giladi kumzuma kila munhu sambiyamkome. ");
INSERT INTO zajp_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Avo Kaini kasegela haulongozi wa MNDEWA na kukala muisi ya Nodi, ili ng'ambu ya ulawilo wa zua wa Edeni. ");
INSERT INTO zajp_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini kawasa na mtwanzi wake, na ija imtwanzi kapata inda na kamulela Henoko. Kaini kadizenga wambo na kudikema twaga da mwanage Henoko. ");
INSERT INTO zajp_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henoko kakala na mwana twaga jake Iladi, ayo yakalile tata wa Mehuyaeli, na Mehuyaeli kakala na mwana twaga jake Metushaeli, ayo yakalile tata wa Lameki. ");
INSERT INTO zajp_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki kasola watwanzi wabili, imwe twaga jake Ada na iyagwe Zila. ");
INSERT INTO zajp_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada kamulela Yabali, ayo yakalile muhenga wa awo wakalile wofuga wang'onyo na kukala mmahema. ");
INSERT INTO zajp_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Mdodo wake kakala Yubali, ayo yakalile muhenga wa awo wose wakalile wotoa bango na filimbi. ");
INSERT INTO zajp_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila kamulela Tubali-Kaini, ayo yatendile via va namna zose kulawa muna ishaba na chuma. Lumbu ja Tubali-Kaini kakala yokemigwa Naama. ");
INSERT INTO zajp_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki kawalongela watwanzi zake, “Tegelezeni mweye Ada na Zila, tegelezeni mbuli zangu mweye watwanzi wa Lameki. Nimkoma munhu kwavija heyo kanigela milonda, mmhale sama ya kunitoa. ");
INSERT INTO zajp_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kamba munhu yondayamkome Kaini kotagusigwa mianza saba, na munhu yondayanikome nie kotagusigwa mianza malongo saba na saba.” ");
INSERT INTO zajp_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu kawasa na mtwanzi wake kabili na wapata mwana iyagwe mbigalo. Hawa kamgwelela twaga dikemigwa Seti. Kwavija Hawa kalonga, “Mulungu kanigwelela nie mwana mbigalo kusola hanhu ha Abeli, ayo Kaini yamkomile.” ");
INSERT INTO zajp_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti kapata mwana kamgwelela twaga Enoshi. Mkipigiti hicho wanhu baho wasongile kumtambikila MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Uno uwo msululu wa lukolo lwa Adamu. Kipigiti Mulungu viyamulumbile munhu, kamulumba kamba viyali heyo mwenyego. ");
INSERT INTO zajp_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Kawalumba mtwanzi na mbigalo, kawamoteza, na kawakema “Munhu.” ");
INSERT INTO zajp_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu viyakalile na milao mia na malongo madatu, kapata mwana mbigalo yalingile kamba heyo mwenyego, na heyo kamgwelela twaga dikemigwa Seti. ");
INSERT INTO zajp_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Viyeshile kumulela Seti, Adamu kakala milao mia nane. Kapata wana wayagwe wakitwanzi na wakimbigalo ");
INSERT INTO zajp_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","na kadanganhika kipigiti viyakalile na milao mia tisa na malongo madatu. ");
INSERT INTO zajp_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seti viyakalile na milao mia na mitano, kamulela Enoshi. ");
INSERT INTO zajp_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Viyeshile kumulela Enoshi, Seti kakala milao mia nane na saba. Kapata wana wayagwe wakitwanzi na wakimbigalo ");
INSERT INTO zajp_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","na kadanganhika kipigiti viyakalile na milao mia tisa na longo dimwe na mibili. ");
INSERT INTO zajp_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoshi viyakalile na milao malongo tisa, kamulela Kenani. ");
INSERT INTO zajp_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Viyeshile kumulela Kenani, Enoshi kakala milao mia nane na longo dimwe na mitano. Kapata wana wayagwe wakitwanzi na wakimbigalo ");
INSERT INTO zajp_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","na kadanganhika kipigiti viyakalile na milao mia tisa na mitano. ");
INSERT INTO zajp_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani viyakalile na milao malongo saba, kamulela Mahalaleli. ");
INSERT INTO zajp_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Viyeshile kumulela Mahalaleli, Kenani kakala milao mia nane na malongo mane. Kapata wana wayagwe wakitwanzi na wakimbigalo ");
INSERT INTO zajp_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","na kadanganhika kipigiti viyakalile na milao mia tisa na longo dimwe. ");
INSERT INTO zajp_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleli viyakalile na milao malongo sita na matano, kamulela Yaledi. ");
INSERT INTO zajp_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Viyeshile kumulela Yaledi, Mahalaleli kakala milao mia nane na malongo madatu. Kapata wana wayagwe wakitwanzi na wakimbigalo ");
INSERT INTO zajp_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","na kadanganhika kipigiti viyakalile na milao mia nane na malongo tisa na matano. ");
INSERT INTO zajp_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaledi viyakalile na milao mia na malongo sita na mabili, kamulela Henoko. ");
INSERT INTO zajp_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Viyeshile kumulela Henoko, Yaledi kakala milao mia nane. Kapata wana wayagwe wakitwanzi na wakimbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yaledi kadanganhika kipigiti viyakalile na milao mia tisa na malongo sita na mabili. ");
INSERT INTO zajp_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henoko viyakalile na milao malongo sita na matano, kamulela Metusela. ");
INSERT INTO zajp_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Viyeshile kumulela Metusela, Henoko kakala mwende wa Mulungu mkipigiti cha milao mia ndatu na kapata wana wayagwe wakitwanzi na wakimbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Henoko kakala milao mia ndatu na malongo sita na matano. ");
INSERT INTO zajp_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henoko kakala mwende wa Mulungu, abaho kayangayuka, kwavija Mulungu kamsola. ");
INSERT INTO zajp_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela viyakalile na milao mia na malongo manane na saba, kamulela Lameki. ");
INSERT INTO zajp_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Viyeshile kumulela Lameki, Metusela kakala milao mia saba na malongo manane na mabili. Kapata wana wayagwe wakitwanzi na wakimbigalo ");
INSERT INTO zajp_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","na kadanganhika kipigiti viyakalile na milao mia tisa na malongo sita na tisa. ");
INSERT INTO zajp_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameki viyakalile na milao mia na malongo manane na mabili, kamulela mwana mbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Kamgwelela twaga dikemigwa Nuhu, yolonga, “Mwana ino iyo yondayatuhoze imioyo muna isang'hano yetu ngaga ituisang'hana na makono getu muna iisi idukumizwe na MNDEWA.” ");
INSERT INTO zajp_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lameki viyeshile kumulela Nuhu, kakala milao mia tano na malongo tisa na matano. Kapata wana wayagwe wakitwanzi na wakimbigalo ");
INSERT INTO zajp_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","na kadanganhika kipigiti viyakalile na milao mia saba na malongo saba na saba. ");
INSERT INTO zajp_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuhu viyeshile kuwa na milao mia tano, kawalela wana wadatu, waichanduso kakala Shemu, abaho Hamu, na hakimambukizo Yafeti. ");
INSERT INTO zajp_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Wanhu viwasongile kongezeka muna iisi na kulela wandele, ");
INSERT INTO zajp_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","wana wa Mulungu wawona waja iwandele wa wanhu kamba wanoga, avo wamsola yoyose iwamsagule. ");
INSERT INTO zajp_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","MNDEWA kalonga, “Loho yangu haikala mzing'huli zidanganhika kipigiti kitali kamba kino, kwavija hewo walumbigwa na nyama, Avo kipigiti chao cha kukala muisi hakibanza milao mia na malongo mabili.” ");
INSERT INTO zajp_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mkipigiti hicho, na mkipigiti kidodo hamwande, Wanefili wakala muisi, kipigiti wana wa Mulungu viwacholile ha wandele wa wanhu na kulela nao wana. Wakala wanhu magalu na wali na matwaga makulu mkipigiti cha umwaka. ");
INSERT INTO zajp_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","MNDEWA kona kamba wiho wa wanhu ukala ubanzile muisi, na kamba mazua gose mbuli ziwakalile wogelegeza na kuzigesa mmioyo yao zikala zihile. ");
INSERT INTO zajp_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","MNDEWA kona giogio sama ya kuwalumba wanhu muisi, na moyo wake umema usungu. ");
INSERT INTO zajp_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Avo MNDEWA kalonga, “Nowabananga wanhu iniwalumbile, wahalawe muisi hamoja na wang'onyo wose, na vinhu inivilumbile vili muisi, na ndege wa kuulanga. Kwavija nie nokona giogio sama ya kuwalumba hewo.” ");
INSERT INTO zajp_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ila Nuhu kanogelwa na MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Luno lulo lukolo lwa Nuhu. Nuhu kakala munhu yalibule uzenzeleganye, kakala bule mbuli na munhu mmwanza wa wanhu wa kipigiti chake, na heyo kakala mwende wa Mulungu. ");
INSERT INTO zajp_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhu kakala na wana wa kimbigalo wadatu, Shemu, Hamu, na Yafeti. ");
INSERT INTO zajp_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Mulungu kona kamba isi ibanangika na imema na ukaini. ");
INSERT INTO zajp_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Mulungu kalola na kona vija ulumwengu vuubanangike, kwavija wanhu wose muulumwengu wakala ukazi wa kutenda mbuli zihile. ");
INSERT INTO zajp_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Mulungu kamulongela Nuhu, “Nowabananga wanhu wose walumbigwe, kwavija ulumwengu umemezwa na ukaini sama yao, avo nowabananga hewo hamoja na ulumwengu. ");
INSERT INTO zajp_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Itendele mwenyego safina ya mbamha za m'vinje, tenda magati mgati yake na uibakaze lami mgati na hanze giladi mazi sambigengile mgati. ");
INSERT INTO zajp_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Vino vivo vondauizenge, utali wake meta 133, na ugazi wake meta 22, na wimo wake kuchola uchana meta 13. ");
INSERT INTO zajp_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Itendele kiswili na uleke nafasi ya utali wa sentimeta 44 hagatigati ya ikiswili na iviwambaza. Izenge iwe na golofa ndatu, na uikile na lwivi mkiwambaza. ");
INSERT INTO zajp_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nogala mmemelo wa mazi muisi kukibananga kila kinhu kili na mhumuzi ya ugima. Kila kinhu muisi chodanganhika, ");
INSERT INTO zajp_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ila nokwika lagano na gweye. Kokwingila muisafina gweye na mtwanzi wako, na wanago, na watwanzi zao. ");
INSERT INTO zajp_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Uvingize muisafina vinhu vose inivilumbile vili na ugima, uvingize vibilivibili, mtwanzi na mbigalo, giladi gweye na hewo muwe na ugima. ");
INSERT INTO zajp_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Wengize muisafina wabiliwabili, mtwanzi na mbigalo, namna zose za ndege, namna zose za wang'onyo, na vinhu vose vili na ugima vitembela muisi, weze kumwako uwemilize sambiwadanganhike. ");
INSERT INTO zajp_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kosola vakuja va namna zose vija vidigwa na kuvika ngama viwe vakuja venu na vakuja va wang'onyo hiwo.” ");
INSERT INTO zajp_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhu katenda kila kinhu kamba Mulungu viyamulagize. ");
INSERT INTO zajp_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Abaho MNDEWA kamulongela Nuhu, “Ingila muisafina hamoja na mulango wako wose, kwavija nyona kamba gweye wiyeka iyo munhu ulibule uzenzeleganye haulongozi wangu mmwanza wa wanhu wa mulelo uno. ");
INSERT INTO zajp_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Wengize wang'onyo wa namna zose, wang'onyo walumbile kulavigwa nhosa sabasaba, mtwanzi na mbigalo, na wang'onyo hawalumbile kulavigwa nhosa wabiliwabili, mtwanzi na mbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Vivija wengize ndege sabasaba wa namna zose, mtwanzi na mbigalo. Tenda vino giladi wang'onyo wa namna zose na ndege wawe wagima na walele kabili muisi. ");
INSERT INTO zajp_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Mazua saba songela sambi noitenda mvula itoe mkipigiti cha mazua malongo mane imisi na ikilo, giladi nivibanange vinhu vose vili na ugima vija inivitendile.” ");
INSERT INTO zajp_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Na Nuhu katenda kila kinhu kamba MNDEWA viyamulagize. ");
INSERT INTO zajp_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuhu kakala na milao mia sita mmemelo wa mazi vuwizile muisi. ");
INSERT INTO zajp_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Heyo na mtwanzi wake na wanage na watwanzi zao wengila muisafina, kuukimbila ummemelo wa mazi. ");
INSERT INTO zajp_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Kila namna ya wang'onyo waja hawalumbile kulavigwa nhosa na waja walumbile kulavigwa nhosa, ndege, na wang'onyo wotambala muisi, ");
INSERT INTO zajp_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","wengila muisafina wabiliwabili mtwanzi na mbigalo hamoja na Nuhu, kamba Mulungu viyalagize. ");
INSERT INTO zajp_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Vigabitile mazua saba mmemelo wa mazi wiza muisi. ");
INSERT INTO zajp_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Mmulao wa mia sita wa ugima wa Nuhu, mdizua da longo dimwe na saba da mulenge wa ikabili, mdizua dija nzokwe zose za mazi bwando zili muisi zitulika, na imizonzo ya mazi ya kuulanga ifunguligwa, ");
INSERT INTO zajp_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","na mvula itoa muisi mmazua malongo mane imisi na ikilo. ");
INSERT INTO zajp_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Mdizua didija mvula viisongile kutoa, Nuhu na mtwanzi wake, hamoja na wana zao wadatu, Shemu, Hamu, na Yafeti, na watwanzi zao, wengila muisafina. ");
INSERT INTO zajp_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Wengila hamoja na wang'onyo wa kumuhulo wa namna zose, wang'onyo wofugigwa wa namna zose, kila kilumbigwe kitambala muisi, na ndege wa namna zose, kila kinhu kili na mabawa. ");
INSERT INTO zajp_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Wose wali na ugima weza ha Nuhu na kwingila muisafina wabiliwabili, ");
INSERT INTO zajp_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","mtwanzi na mbigalo, kamba Mulungu viyamulagize. Abaho MNDEWA kawahindila ulwivi. ");
INSERT INTO zajp_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ummemelo wa igamazi ugendelela mmazua malongo mane, na igamazi vigongezeke gaiinula isafina uchana ng'hani ya iisi. ");
INSERT INTO zajp_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Mazi gamema na kongezeka ng'hani muisi, na ija isafina iengeluka uchana ya igamazi. ");
INSERT INTO zajp_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mazi gakala gongezeke ng'hani muisi na kuigubikiza imigongo yose mitali, ");
INSERT INTO zajp_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","gakala gamemile mbaka gakala gavikile utali wa meta saba kulawa uchana ya imigongo. ");
INSERT INTO zajp_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Kila kinhu kili na ugima kili muisi kidanganhika, ndege wa namna zose, wang'onyo wofugigwa wa namna zose, wang'onyo wa kumuhulo wa namna zose, kila kinhu kilumbigwe kitembela muisi, na wanhu wose. ");
INSERT INTO zajp_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Vinhu vose vili na mhumuzi vikala muisi vidanganhika. ");
INSERT INTO zajp_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Mulungu kavikoma vinhu vose vili na ugima vikalile muisi. Wanhu wose wadanganhika hamoja na wang'onyo, ndege, na kila kinhu kilumbigwe kitembela muisi. Nuhu hamoja na waja wakalile muisafina wao wasigale. ");
INSERT INTO zajp_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Mazi gakala gamemile muisi mkipigiti cha mazua mia na malongo matano. ");
INSERT INTO zajp_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ila Mulungu kamgelegeza Nuhu na wang'onyo wose wa kumuhulo na wofugigwa waja wakalile hamoja na heyo muna isafina. Mulungu kadigala beho muisi yose, na igamazi gasonga kuhunguka. ");
INSERT INTO zajp_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Nzokwe za mazi zili muisi na imizonzo ya mazi ya kuulanga vihindigwa, na mvula ileka kutoa. ");
INSERT INTO zajp_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Vigabitile mazua mia na malongo matano mazi gakala gahunguka lugaluga muisi, ");
INSERT INTO zajp_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","na mdizua da longo dimwe na saba da mulenge wa saba isafina ima hachana ya imigongo ya Alalati. ");
INSERT INTO zajp_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Igamazi gahunguka, na mdizua da ichanduso da umulenge wa longo dimwe, sota za imigongo zoneka. ");
INSERT INTO zajp_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Vigeshile mazua malongo mane Nuhu kadivugula idizonzo diyatendile muisafina ");
INSERT INTO zajp_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","na kumulava hanze bondwa, nayo habwelile, ila kaguluka kuno na kuno mbaka igamazi viganyalile. ");
INSERT INTO zajp_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Abaho Nuhu kamulava hanze hua yalole kamba igamazi gahungula muisi. ");
INSERT INTO zajp_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ila ija ihua hapatile hanhu ha kwima kwavija kukala na mazi muisi yose, avo kabwela ha Nuhu muisafina. Nuhu kaugolosa mkono wake kamsola ija ihua na kum'bweza kumwake muisafina. ");
INSERT INTO zajp_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Kabeta mbaka mazua saba gayagwe, abaho kamulava ihua kabili. ");
INSERT INTO zajp_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ija ihua viyabweleganye mkipigiti cha ichungulo, mmulomo wake kakala na jani bisi da mzaituni, avo Nuhu kavitanga kamba mazi gahunguka muisi. ");
INSERT INTO zajp_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Abaho kabeta mazua saba gayagwe, kamulava hanze ija ihua. Kipigiti kino habwelile kabili kumwake. ");
INSERT INTO zajp_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuhu viyakalile na milao mia sita na umwe, mdizua da mwanduso da umulenge wa mwanduso, igamazi ganyala. Nuhu kakisegeza ikigubiko cha isafina, kasungulila, na kona kamba isi ikala inyalile. ");
INSERT INTO zajp_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Vuuvikile mulenge wa ikabili na mazua malongo mabili na saba, isi ikala inyalile kabisa. ");
INSERT INTO zajp_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Abaho Mulungu kamulongela Nuhu, ");
INSERT INTO zajp_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Lawa hanze ya isafina, gweye na mtwanzi wako, na wanago na watwanzi zao. ");
INSERT INTO zajp_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Walave hanze kila kinhu kilumbigwe kili na ugima kili hamoja na gweye, ndege, wang'onyo, na kila kinhu kilumbigwe kitembela muisi giladi wenele muisi na kulela na kongezeka.” ");
INSERT INTO zajp_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Avo Nuhu kalawa muisafina hamoja na mtwanzi wake, na wanage, na watwanzi zao. ");
INSERT INTO zajp_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Wang'onyo wose, kila kinhu kilumbigwe kitembela muisi, na ndege wose walawa muisafina, kulingana na namna zao. ");
INSERT INTO zajp_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nuhu kamzengela MNDEWA kilingo cha kulavila nhosa. Kamsola mng'onyo imwe na ndege imwe kulawa ha wang'onyo na ndege wa namna zose walumbile kulavigwa nhosa, kawalava nhosa mkuwasoma na moto hana ikilingo cha kulavila nhosa. ");
INSERT INTO zajp_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mnung'ho wa inhosa umnogela MNDEWA, na heyo kailongela mwenyego mmoyo wake, “Siidukumiza isi kabili sama ya gaja gawatendile wanhu, hata kamba ngelegeza zao zikala zihile songela haudodo wao. Na sivibananga kabili vinhu vose vilumbigwe vili na ugima kamba vinitendile. ");
INSERT INTO zajp_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Milao yose isi vondaikale, vipigiti vino haviziga, kipigiti cha kuhanda na kuhuna, kipigiti cha kihuhe na keakea, kipigiti cha zua na mvula, na kipigiti cha imisi na ikilo.” ");
INSERT INTO zajp_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Mulungu kawamoteza Nuhu na wanage, mkuwalongela, “Leleni mkongezeke, mkaimemeze isi. ");
INSERT INTO zajp_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Wang'onyo wose, ndege wose, somba wose, na kila kilumbigwe kitembela muisi wowadumba mweye. Wose wekigwa mmakono genu. ");
INSERT INTO zajp_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kila kinhu kili na ugima kitembela muisi chowa mandia genu. Kamba viniwagwelele mboga, sambi nowagwelela kila kinhu. ");
INSERT INTO zajp_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Nyama ili na mulopa mgati yake hamulondigwa kuija, kwavija ugima wa mmulopa. ");
INSERT INTO zajp_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Nomkoma munhu yoyose yomkoma munhu iyagwe. Kamba mng'onyo yahamkoma munhu, na heyo kolondigwa yakomigwe, na munhu yoyose yomkoma miyage, na heyo kolondigwa yakomigwe. ");
INSERT INTO zajp_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Munhu kalumbigwa muiningo ya Mulungu, avo munhu yoyose yomkoma munhu, na heyo kokomigwa na wanhu. ");
INSERT INTO zajp_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Leleni mkongezeke, mwenele muisi.” ");
INSERT INTO zajp_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Abaho Mulungu kawalongela Nuhu na wanage, ");
INSERT INTO zajp_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Sambi nokwika lagano jangu na gweye na lukolo lwako, ");
INSERT INTO zajp_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na vinhu vose vili na ugima vikalile hamoja na gweye, ndege wose, wang'onyo wose wofugigwa, wang'onyo wose wa kumuhulo, na kila kinhu chuulawilenacho muisafina, kila kinhu kili na ugima kilumbigwe muisi. ");
INSERT INTO zajp_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nokwika lagano jangu na gweye, kamba vinhu vose vili na ugima havibanangigwa kabili na ummemelo wa mazi. Na ummemelo wa mazi hauubananga kabili iisi.” ");
INSERT INTO zajp_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Abaho Mulungu kalonga, “Kino kicho kilaguso cha lagano dinitenda na gweye na kila kilumbigwe kili na ugima, lagano sama ya milelo yose ikwiza, ");
INSERT INTO zajp_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","nokwika pindamulungu jangu muna gamawingu. Dowa kilaguso cha lagano jangu na ulumwengu. ");
INSERT INTO zajp_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kipigiti nihaugubika ulanga na mawingu, pindamulungu dolawila mmawingu, ");
INSERT INTO zajp_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","donitenda nikikumbukile kilagano changu kinitendile na gweye na vinhu vose vilumbigwe vili na ugima va namna zose. Mmemelo wa mazi hauvibananga kabili vinhu vose vili na ugima. ");
INSERT INTO zajp_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kipigiti pindamulungu dihakoneka muna gamawingu, nojona na kukumbukila lagano jangu da digunge hagatigati yangu na vinhu vose vili na ugima vili muisi. ");
INSERT INTO zajp_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kino kicho kilaguso cha lagano dinitendile hagatigati yangu na vinhu vose vili na ugima.” ");
INSERT INTO zajp_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Wanage Nuhu walawile hanze ya isafina wakala Shemu, Hamu, na Yafeti. Hamu kakala tata wa Kanaani. ");
INSERT INTO zajp_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Wana wano wadatu wa Nuhu wakala wahenga wa wanhu wose wali muisi. ");
INSERT INTO zajp_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhu, ayo yakalile mulimi, kakala munhu wa ichanduso kuhanda mizabibu. ");
INSERT INTO zajp_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Nuhu kang'wa ugimbi, kakoligwa, kawasa mwazi mdihema jake. ");
INSERT INTO zajp_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu, tata wa Kanaani, viyonile kamba tataake kakala mwazi, kalawa hanze kawalongela wakulu zake. ");
INSERT INTO zajp_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Abaho Shemu na Yafeti wasola kivalo na kukibasika mmaega gao. Abaho wabwela kisengelenyuma na kumgubika tataao. Wakala wavihinduse vihanga vao giladi sambiwone mwazi wa tataao. ");
INSERT INTO zajp_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ugimbi vuumsegele, Nuhu kalamuka na kukitanga kija mwanage mdodo kiyamtendele, ");
INSERT INTO zajp_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","kalonga, “Yadukumizwe Kanaani! Kowa nyakadala wa nyakadala ha ndugu zake. ");
INSERT INTO zajp_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Yatogolwe MNDEWA, Mulungu wa Shemu! Kanaani yawe nyakadala wa Shemu. ");
INSERT INTO zajp_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Mulungu yautanule undewa wa Yafeti! Yafeti yakale mdihema da Shemu! Kanaani yawe nyakadala wa Yafeti.” ");
INSERT INTO zajp_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Vuwishile ummemelo wa igamazi, Nuhu kakala milao mia ndatu na malongo matano ");
INSERT INTO zajp_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","abaho kadanganhika kuno yali na milao mia tisa na malongo matano. ");
INSERT INTO zajp_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Uno uwo msululu wa wana wa Nuhu, wakala Shemu, Hamu, na Yafeti, wanhu wano wadatu walela wana vuwishile ummemelo wa mazi. ");
INSERT INTO zajp_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Wana wa Yafeti wakala Gomeli, Magogu, Madai, Yavani, Tubali, Meshaki, na Tilasi. ");
INSERT INTO zajp_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Wana wa Gomeli wakala Ashikenazi, Lifati, na Togama. ");
INSERT INTO zajp_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Wana wa Yavani wakala Elisha, Talishishi, Kitimu, na Lodanimu. ");
INSERT INTO zajp_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Wana wa Yavani wakala wahenga wa wanhu awo wakalile wokala mhwani na m'visiwa. Wano wao wana wa Yafeti, wakalile wapwililike muisi mmadale na kuigola mmitala na mzindewa, na kila dale dikala na ulonzi wake. ");
INSERT INTO zajp_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Wana wa Hamu wakala Kushi, Misili, Puti, na Kanaani. ");
INSERT INTO zajp_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Wana wa Kushi wakala Seba, Havila, Sabita, Laama, na Sabiteka. Wana wa Laama wakala Sheba na Dedani. ");
INSERT INTO zajp_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushi kakala na mwana iyagwe yakemigwe Nimlodi, ayo yakalile munhu wa ichanduso muulumwengu kuwa galu wa ng'hondo. ");
INSERT INTO zajp_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Heyo kakala galu wa kusaka wang'onyo mkutazigwa na MNDEWA, na kija kicho kilamso cha wanhu kulonga, “MNDEWA yakutende kuwa galu wa kusaka wang'onyo kamba Nimlodi!” ");
INSERT INTO zajp_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Miwambo ya ichanduso ya undewa wake ikala Babeli, Eleki, Akadi na Kaline, miwambo ino yose ikala muisi ya Shinali. ");
INSERT INTO zajp_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Kalawa muisi ija kachola mbaka Ashulu na kuizenga miwambo ya Ninawi, Lehoboti-Ili, Kala, ");
INSERT INTO zajp_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Leseni, ili hagatigati ya Ninawi na wambo kulu da Kala. ");
INSERT INTO zajp_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Wana wa Misili wakala Waludi, Waanamu, Walehabi, Wanafutuhi, ");
INSERT INTO zajp_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Wapatilusi, Wakasiluhi awo wakalile sina da Wafilisti, na Wakafitoli. ");
INSERT INTO zajp_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Mwana mkulu wa Kanaani kakala Sidoni, muhenga wa Wasidoni. Kanaani vivija kakala muhenga wa Wahiti, ");
INSERT INTO zajp_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Wayebusi, Waamoli, Wagiligashi, ");
INSERT INTO zajp_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Wahivi, Waaliki, Wasini, ");
INSERT INTO zajp_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Waalivadi, Wasemali, na Wahamati. Abaho madale ga Wakanaani gapwililika, ");
INSERT INTO zajp_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","mbaka muna izimbaka za Wakanaani kulawa mwambu wa kusi wa Sidoni mbaka Gelali behi na Gaza, na mwambu wa ulawilo wa zua mbaka Sodoma, Gomola, Adima, na Seboimu behi na Lasha. ");
INSERT INTO zajp_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Wano wao wana wa Hamu, wakalile wapwililike mmadale gakalile na ulonzi wao wenyego, isi zao wenyego, na ndewa zao wenyego. ");
INSERT INTO zajp_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shemu, mkulu wake Yafeti, yakalile muhenga wa lukolo lose lwa Ebeli, kakala na wana. ");
INSERT INTO zajp_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Wana wa Shemu wakala Elamu, Ashulu, Alufaksadi, Ludi, na Alamu. ");
INSERT INTO zajp_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Wana wa Alamu wakala Uzi, Huli, Geteli, na Mashi. ");
INSERT INTO zajp_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Alufaksadi kamulela Shela, Shela kamulela Ebeli. ");
INSERT INTO zajp_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebeli kakala na wana wabili, waichanduso kakemigwa Pelegi, kwavija kipigiti cha ugima wake wanhu wa ulumwengu wakala waigolile. Mdodo wake kakemigwa Yokitani. ");
INSERT INTO zajp_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Wana wa Yokitani wakala Alimodadi, Shelefu, Hazamaweti, Yela, ");
INSERT INTO zajp_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadolamu, Uzali, Dikila, ");
INSERT INTO zajp_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obali, Abimaeli, Sheba, ");
INSERT INTO zajp_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofili, Havila, na Yobabu. Wano wose wakala wana wa Yokitani. ");
INSERT INTO zajp_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Isi iwakalile wokala ikala yolawa Mesha mbaka Sefali, muisi ya vigongovigongo ili ng'ambu ya ulawilo wa zua. ");
INSERT INTO zajp_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Wano wao wana wa Shemu, wakalile wapwililike mmadale gakalile na ulonzi wao wenyego, isi zao wenyego, na ndewa zao wenyego. ");
INSERT INTO zajp_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Gano gago madale ga wanage Nuhu, kulingana na ng'holo zao mgati ya ndewa zao. Ndewa zose za ulumwengu zilawa muno kipigiti vuumalile ummemelo wa igamazi. ");
INSERT INTO zajp_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Haichanduso, wanhu wose muulumwengu wakala na ulonzi umwe na nongelo imwe. ");
INSERT INTO zajp_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Wanhu viwacholile ng'ambu ya ulawilo wa zua, wona hanhu tambalale muisi ya Shinali, wakala hiko. ");
INSERT INTO zajp_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Wailongela, “Izoni tutende matofali, abaho tugoke gawe madala.” Avo wakala na matofali na lami ya kuzengela. ");
INSERT INTO zajp_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Abaho walonga, “Izoni tukiizengele wambo na ulingo wondauvike kuulanga, giladi tukiitendele twaga tweye wenyego, giladi sambitupwililike muisi yose.” ");
INSERT INTO zajp_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","MNDEWA kahumuluka hasi giladi yalole idiwambo na uulingo uzengigwe na wanhu. ");
INSERT INTO zajp_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","MNDEWA kalonga, “Wanhu wano wailumba hamoja kamba munhu imwe na kulonga ulonzi umwe, wasonga kutenda vino, avo haduhu mbuli yondawalonde kutenda yondaileke kudahika kumwao. ");
INSERT INTO zajp_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Izoni, tuhumuluke hasi na kuutibula ulonzi wao giladi sambiwaitegeleze wenyego kwa wenyego.” ");
INSERT INTO zajp_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Avo kulawa haja MNDEWA kawapwililisa muisi yose, na hewo waleka kudizenga idiwambo. ");
INSERT INTO zajp_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kija kicho kilamso cha wambo dija kukemigwa Babeli, kwavija haja MNDEWA kautibula ulonzi wa ulumwengu wose. Kulawa haja MNDEWA kawapwililisa muisi yose. ");
INSERT INTO zajp_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Wano wao wana wa Shemu. Milao mibili songela vuwishile ummemelo wa igamazi, kipigiti Shemu viyakalile na milao mia, kamulela Alufaksadi. ");
INSERT INTO zajp_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Na viyeshile kumulela Alufaksadi, Shemu kakala milao mia tano, kapata wana wayagwe wakitwanzi na wakimbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Alufaksadi viyakalile na milao malongo madatu na mitano, kamulela Shela. ");
INSERT INTO zajp_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Viyeshile kumulela Shela, Alufaksadi kakala milao mia nne na midatu, kapata wana wayagwe wakitwanzi na wakimbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shela viyakalile na milao malongo madatu, kamulela Ebeli. ");
INSERT INTO zajp_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Viyeshile kumulela Ebeli, Shela kakala milao mia nne na midatu, kapata wana wayagwe wakitwanzi na wakimbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebeli viyakalile na milao malongo madatu na mine, kamulela Pelegi. ");
INSERT INTO zajp_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Viyeshile kumulela Pelegi, Ebeli kakala milao mia nne na malongo madatu, kapata wana wayagwe wakitwanzi na wakimbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegi viyakalile na milao malongo madatu, kamulela Leu. ");
INSERT INTO zajp_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Viyeshile kumulela Leu, Pelegi kakala milao mia mbili na tisa kapata wana wayagwe wakitwanzi na wakimbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Leu viyakalile na milao malongo madatu na mibili, kamulela Selugi. ");
INSERT INTO zajp_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Viyeshile kumulela Selugi, Leu kakala milao mia mbili na saba, kapata wana wayagwe wakitwanzi na wakimbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Selugi viyakalile na milao malongo madatu, kamulela Naholi. ");
INSERT INTO zajp_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Viyeshile kumulela Naholi, Selugi kakala milao mia mbili, kapata wana wayagwe wakitwanzi na wakimbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naholi viyakalile na milao malongo mabili na tisa, kamulela Tela. ");
INSERT INTO zajp_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Viyeshile kumulela Tela, Naholi kakala milao mia na longo dimwe na tisa, kapata wana wayagwe wakitwanzi na wakimbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tela viyavikize milao malongo saba, kawalela Ablam, Naholi, na Halani. ");
INSERT INTO zajp_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Wano wao wana wa Tela. Tela kawalela Ablam, Naholi, na Halani. Na Halani kamulela Loti. ");
INSERT INTO zajp_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Halani kadanganhika kipigiti Tela tataake viyakalile yang'hali mgima, kadanganhikila muisi ya Ulu, ikalile isi ya Wakaldayo, isi yaavumbukile. ");
INSERT INTO zajp_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ablam na Naholi wasola watwanzi. Mtwanzi wa Ablam kakemigwa Salai, na mtwanzi wa Naholi kakemigwa Milka. Milka kakala mndele wa Halani, ayo yakalile tata wa Milka na Isika. ");
INSERT INTO zajp_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Salai kakala bule sambo, avo kakala bule wana. ");
INSERT INTO zajp_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tela kamsola Ablam mwanage, Loti mzukulu wake, ayo yakalile mwanage Halani, na Salai mkwe yake, mtwanzi wa mwanage Ablam, wose hamoja wahalawa muisi ya Ulu, ikalile isi ya Wakaldayo, wachola Kanaani. Ila viwavikile muisi ya Halani, wakala haja. ");
INSERT INTO zajp_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tela kakala milao mia mbili na mitano, abaho kadanganhika muisi ya Halani. ");
INSERT INTO zajp_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","MNDEWA kamulongela Ablam, “Uhalawe kulawa muisi yako mwenyego, uwaleke ndugu zako na wanhu wa mng'anda ya tataako, uchole muisi yondanikulagusile. ");
INSERT INTO zajp_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nokutenda gweye uwe undewa mkulu. Nokumoteza na kuditenda twaga jako diwe kulu, avo kowa motelo ha wanhu wayagwe. ");
INSERT INTO zajp_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nowamoteza awo wokumoteza gweye, Ila nowadukumiza awo wokudukumiza gweye. Na kubitila gweye nowamoteza wanhu wa isi zose.” ");
INSERT INTO zajp_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Avo Ablam kachola kamba MNDEWA viyamulongele, na Loti kachola hamoja na heyo. Ablam kakala na milao malongo saba na mitano kipigiti viyasegele kulawa Halani. ");
INSERT INTO zajp_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Kamsola Salai mtwanzi wake, Loti mwana wa ndugu yake, na vinhu vose viyakalile navo na wanhu wose iyakalile nao ako Halani, wahalawa wachola Kanaani. Kipigiti viwavikile Kanaani, ");
INSERT INTO zajp_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ablam kabita hagatigati ya isi mbaka Shekemu. Ako kuyekile ng'hambi yake hamgwazo wa biki kulu da mwaloni wa Mole. Kipigiti kija Wakanaani wakala wokala muisi ija. ");
INSERT INTO zajp_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Viyakalile Shekemu, MNDEWA kamulawilila Ablam kamulongela, “Ino iyo isi yondanilugwelele lukolo lwako.” Avo hanhu haja Ablam kamzengela MNDEWA kilingo cha kulavila nhosa, MNDEWA ayo yamulawilile. ");
INSERT INTO zajp_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kulawa haja kagendelela na mwanza wake mbaka isi ya vigongovigongo ng'ambu ya ulawilo wa zua wa Beteli na kwika ng'hambi yake hagatigati ya Beteli na Ai. Beteli ikala ng'ambu ya uswelo wa zua, na Ai ikala ng'ambu ya ulawilo wa zua. Hanhu haja kamzengela MNDEWA kilingo cha kulavila nhosa na kumtambikila. ");
INSERT INTO zajp_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abaho Ablam kahalawa, kagendelela na mwanza wake, kachola Negebu. ");
INSERT INTO zajp_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kipigiti hicho kukala na nzala muisi, Ablam kachola Misili na kukala mkipigiti kiguhi kamba muhenza, kwavija nzala ikala mpamanho. ");
INSERT INTO zajp_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Viwakalile behi kwingila Misili, Ablam kamulongela Salai mtwanzi wake, “Nivitanga kamba gweye kwa mtwanzi unogile ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Wamisili wahakona gweye, wolonga, ‘Ino mtwanzi wake.’ Abaho nie wong'homa, ila gweye wokuleka uwe mgima. ");
INSERT INTO zajp_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Walongele kamba gweye kwa lumbu jangu, avo sama yako gweye wondeka niwe mgima na kunhendele ganogile.” ");
INSERT INTO zajp_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ablam viyavikile Misili, Wamisili wamona Salai kamba kakala mtwanzi yanogile ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Na salange wa Falao viwamuwene, wamtogola haulongozi wake. Avo Falao kamsola kamgala kuding'anda jake da kindewa giladi yawe imwe wa watwanzi zake. ");
INSERT INTO zajp_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sama yake, Falao kamtendela Ablam ganogile, kamgwelela madale ga ng'hondolo, menhe, ng'ombe, mhunda, nyakadala, na ngamia. ");
INSERT INTO zajp_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ila MNDEWA kamtoa Falao na mitamu ihile ng'hani, heyo hamoja na wanhu wa ng'anda yake, sama ya Falao kumsola Salai mtwanzi wa Ablam. ");
INSERT INTO zajp_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Avo Falao kamkema Ablam, kamulongela, “Choni kino chuunitendele? Habali hunilongele kamba heyo kakala mtwanzi wako? ");
INSERT INTO zajp_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Habali ulongile kamba kakala lumbu jako, na kunileka nie nimsole yawe mtwanzi wangu? Mtwanzi wako ino hano, msole uchole!” ");
INSERT INTO zajp_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Abaho Falao kawalagiza wanhu zake wamsegeze Ablam na kumulava hanze ya isi ija, heyo hamoja na mtwanzi wake na kila kinhu kiyakalilenacho. ");
INSERT INTO zajp_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Avo Ablam kahalawa Misili kachola Negebu, heyo hamoja na mtwanzi wake na kila kinhu kiyakalilenacho, na Loti kachola hamoja na heyo. ");
INSERT INTO zajp_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ablam kakala munhu mgoli ng'hani, kakala na ng'hondolo, menhe, ng'ombe, na madini ga feza na zahabu. ");
INSERT INTO zajp_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kulawa Negebu kabita hanhu hamwe mbaka hayagwe na kuvika Beteli, hagatigati mwa Beteli na Ai ako kuikalile hema yake kipigiti kibitile, ");
INSERT INTO zajp_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","hanhu hayazengile kilingo cha kulavila nhosa haichanduso. Ablam kamtambikila MNDEWA haja. ");
INSERT INTO zajp_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Loti, ayo yacholile hamoja na Ablam, vivija kakala na madale ga ng'hondolo, menhe, ng'ombe na mahema. ");
INSERT INTO zajp_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Avo isi haiwatoshile hewo wabili kukala hamoja, kwavija wakala na madale makulu ng'hani ga wang'onyo. ");
INSERT INTO zajp_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Na ngomba izuka hagatigati ya wachunga wang'onyo wa Ablam na wachunga wang'onyo wa Loti. Kipigiti hicho Wakanaani na Wapelizi vivija wakala wokala muisi ija. ");
INSERT INTO zajp_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Avo Ablam kamulongela Loti, “Sambikuwe na ngomba hagatigati yangu nie na gweye, ama hagatigati ya wachunga wako na wangu, kwavija tweye twa ndugu. ");
INSERT INTO zajp_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Isi ino yose ya haulongozi wako. Natuinege. Kamba uhachola mkono wa ukumoso, nie nochola mkono wa ukulume. Na kamba uhachola mkono wa ukulume, nie nochola mkono wa ukumoso.” ");
INSERT INTO zajp_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Loti kalola na kujona bawe da Yolodani dikala na mazi bwando kila hanhu, mnzila ya kuchola mkiwambo cha Soali, dikala kamba kihati cha MNDEWA, ama kamba isi ya Misili. Mbuli ino ilawilila kipigiti MNDEWA viyakalile yang'hali hanavibananga viwambo va Sodoma na Gomola. ");
INSERT INTO zajp_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Avo Loti kasagula bawe jose da Yolodani, avo kachola ng'ambu ya ulawilo wa zua. Vino vivo wanhu wano wabili viwaigolile. ");
INSERT INTO zajp_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ablam kakala muisi ya Kanaani, na Loti kakala hagatigati ya miwambo ya idibawe na kwika ng'hambi yake behi na Sodoma. ");
INSERT INTO zajp_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Wanhu wa Sodoma wakala wehile ng'hani na wakala womtendela MNDEWA vilozo vikulu ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Loti viyasegele, MNDEWA kamulongela Ablam, “Lola kulawa aho hauli, ulole ng'ambu zose. ");
INSERT INTO zajp_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Isi ino yose iuyona nokugwelela gweye na lukolo lwako, na yowa yako mazua gose. ");
INSERT INTO zajp_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nolutenda lukolo lwako luwe kamba timbwisi da isi, avo kamba munhu yoyose yodaha kudipeta timbwisi, vivija lukolo lwako lodahika kupetigwa. ");
INSERT INTO zajp_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Genda, ubite muisi yose ulole utali wake na ugazi wake, kwavija nie nokugwelela isi ino yose.” ");
INSERT INTO zajp_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Avo Ablam kaikunza hema yake kachola kukala behi na mibiki mikulu ya mwaloni ya munhu imwe yakemigwe Mamle ako mkiwambo cha Hebloni, ako kuyamzengele MNDEWA kilingo cha kulavila nhosa. ");
INSERT INTO zajp_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Mkipigiti cha mndewa Amlafeli wa Shinali, mndewa Alioki wa Elasali, mndewa Kedolaomeli wa Elamu, na mndewa Tidali wa Goimu, ");
INSERT INTO zajp_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","wandewa wano watenda ng'hondo na mndewa Bela wa Sodoma, mndewa Bilisha wa Gomola, mndewa Shinabi wa Adima, mndewa Shemeba wa Seboimu, na mndewa wa Bela ama mtwaga diyagwe Soali. ");
INSERT INTO zajp_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Wandewa wano watano wawaduganya hamoja asikali zao Mdibonde da Sidimu, ajo dikemigwe Bahali ya Munyu. ");
INSERT INTO zajp_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Wakala hasi ya utawala wa mndewa Kedolaomeli mkipigiti cha milao longo dimwe na mibili, ila mmulao wa longo dimwe na midatu, wainega na heyo. ");
INSERT INTO zajp_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mmulao wa longo dimwe na mine, mndewa Kedolaomeli na wandewa wakalile hamoja na heyo weza na kuwahuma Walefai ako Ashitelosi-Kalinaimu, Wazuzi ako Hamu, Waemi ako Shawe-Kiliasaimu, ");
INSERT INTO zajp_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","na Waholi muisi ya vigongovigongo ya Seili mbaka Eli-Palani behi na luwala. ");
INSERT INTO zajp_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Abaho wahinduka kukisogo na kuchola Kadeshi, itangigwe mtwaga diyagwe Eni-Mishipati. Waisola isi yose ya Waamaleki, na kuwahuma Waamoli wakalile wokala mkiwambo cha Hasasoni-Tamali. ");
INSERT INTO zajp_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Abaho wandewa wa Sodoma, Gomola, Adima, Seboimu, na Bela wawaduganya asikali zao sama ya kutenda ng'hondo Mdibonde da Sidimu na kugomba na ");
INSERT INTO zajp_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kedolaomeli mndewa wa Elamu, Tidali mndewa wa Goimu, Amlafeli mndewa wa Shinali, na Alioki mndewa wa Elasali. Wandewa wane wagomba na wandewa watano. ");
INSERT INTO zajp_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Bonde da Sidimu dikala dimemile mikolongo ya lami, na iwandewa wa Sodoma na Gomola hamoja na asikali zao viwakimbile kulawa hana ing'hondo, wanhu wayagwe walagalila mmikolongo hiyo, na wanhu wasigale wakimbilila kuvigongo. ");
INSERT INTO zajp_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Waja iwandewa wane wasola kila kinhu kulawa Sodoma na Gomola, wasola na vakuja, abaho wachola. ");
INSERT INTO zajp_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Loti, mwana wa ndugu yake Ablam, kakala yokala Sodoma, avo wamsola heyo na vinhu vake vose. ");
INSERT INTO zajp_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Abaho munhu imwe yakalile yahonyokwe, keza na kumulongela Ablam Mueblania. Ablam kakala yokala behi na mibiki mikulu ya mwaloni ya munhu imwe yakemigwe Mamle Mwamoli, ndugu wa Eshikoli na Aneli, awo wose wakalile hamoja na Ablam. ");
INSERT INTO zajp_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ablam viyahulike kamba ndugu yake kagogigwa, kawakema wanhu wa ng'hondo mia ndatu na longo dimwe na wanane hang'hambi yake, wanhu waleligwe mng'anda yake, kawakoleleza waja iwandewa wane mbaka mkiwambo cha Dani. ");
INSERT INTO zajp_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Viwavikile haja Ablam kawagola wanhu zake mmadalemadale. Viivikile ikilo, wawavamhila waja iwandewa wane na kuwahuma. Kawawinga mbaka kiwambo cha Hoba, kasikazi ya wambo da Damaski. ");
INSERT INTO zajp_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Avo kavibweza vinhu vose vikalile visoligwe, na kum'bweza Loti ndugu yake na vinhu vake, hamoja na watwanzi na wanhu wayagwe. ");
INSERT INTO zajp_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ablam viyabwelile kipigiti viyeshile kumuhuma Kedolaomeli na wandewa wayagwe wakalile na heyo, mndewa wa Sodoma keza kuiting'hana na heyo Mdibonde da Shawe, ajo vivija dikemigwe Bonde da Mndewa. ");
INSERT INTO zajp_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Na Melikizedeki, mndewa wa Salemu na mkulu wa nhambiko wa Mulungu Mkulu Ng'hani, kamgalila Ablam mkate na divai, ");
INSERT INTO zajp_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","kammoteza, na kumulongela, “Mulungu Mkulu Ng'hani, heyo yalumbile ulanga na isi, yammoteze Ablam! ");
INSERT INTO zajp_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Yayenzigwe Mulungu Mkulu Ng'hani, ayo yakutendile gweye uwahume wadumuka zako!” Na Ablam kamgwelela Melikizedeki zaka ya vinhu vose viyabwelile navo. ");
INSERT INTO zajp_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mndewa wa Sodoma kamulongela Ablam, “Nigwelele wanhu zangu, ila vinhu vuupatile hiko sigala navo.” ");
INSERT INTO zajp_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ila Ablam kamulongela mndewa wa Sodoma, “Nimduilila MNDEWA, Mulungu Mkulu Ng'hani, yalumbile ulanga na isi, ");
INSERT INTO zajp_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","kamba sisola kinhu chako chochose, luzi ama luzabi lwa kilatu, giladi sambiulonge, ‘Nie iyo nimtendile Ablam yawe mgoli.’ ");
INSERT INTO zajp_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nie mwenyego sisola kinhu chochose, ila notogola kija kiwadile wanhu zangu, na dija idifungu da wanhu wacholile kung'hondo hamoja na nie, kina Aneli, Eshikoli, na Mamle.” ");
INSERT INTO zajp_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Abaho usenga wa MNDEWA umwizila Ablam muinzozi, wolonga, “Sambiudumbe, Ablam! Nie nokwimiliza, nhunza yako yowa ng'hulu ng'hani.” ");
INSERT INTO zajp_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ila Ablam kalonga, “MNDEWA Mulungu, nhunza yaki inogile yondaunigwelele? Kwavija nie nabule mwana, na muhazi wa ng'anda yangu iyo Eliezeli munhu wa Damaski. ");
INSERT INTO zajp_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Kwavija hunigwelele wana, avo nyakadala imwe yali mng'anda yangu iyo yondayawe muhazi wangu.” ");
INSERT INTO zajp_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Abaho usenga wa MNDEWA umwizila mwanza wa ikabili, ulonga, “Nyakadala ino Eliezeli hawa muhazi wa mali gako, ila mwanago mwenyego iyo yondayawe muhazi wako.” ");
INSERT INTO zajp_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","MNDEWA kamsola kamulava hanze, kamulongela, “Lola uchana kuulanga, uzipete zinhondo kamba uhadaha. Avo, vino vivo lukolo lwako vondaluwe.” ");
INSERT INTO zajp_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ablam kamtamanila MNDEWA, na sama ya nhamanila yake, MNDEWA kampeta heyo kamba kabule uzenzeleganye. ");
INSERT INTO zajp_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Abaho kamulongela, “Nie iyo MNDEWA nikulavile kulawa isi ya Ulu, ikalile isi ya Wakaldayo, nikugwelele isi ino iwe yako.” ");
INSERT INTO zajp_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ila Ablam kalonga, “Gweye, MNDEWA Mulungu, novitangaze kamba isi ino yowa yangu?” ");
INSERT INTO zajp_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Avo MNDEWA kamulongela, “Nigalile bogwa wa ng'ombe yali na milao midatu, bogwa wa menhe yali na milao midatu, na songolomi wa ng'hondolo yali na milao midatu, hamoja na hua na nziwa.” ");
INSERT INTO zajp_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ablam kawagala wang'onyo wano wose ha Mulungu, kawakanha nyenza mbilimbili na kuzika mminhongo mibili, na kila lwenza lukiilola na miyage. Ila ndege kawachinja ila hawakanhile mzinyenza. ");
INSERT INTO zajp_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Vimhungu waihumulukila imitufi, ila Ablam kawawinga. ");
INSERT INTO zajp_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Zua vidiswile, Ablam kawasa utulo kakuluza, ziza na bwembe vimgubika. ");
INSERT INTO zajp_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","MNDEWA kamulongela, “Uvitange kamba lukolo lwako lowa wahenza muisi ya wanhu wayagwe. Ako wowa nyakadala na wotendeligwa gehile mkipigiti cha milao mia nne. ");
INSERT INTO zajp_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ila nousuna undewa uja wondauwatende hewo wawe nyakadala, abaho wolawa na mali bwando. ");
INSERT INTO zajp_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ila gweye koilumba hamoja na wahenga zako mditindiwalo kuno uli na milao bwando. ");
INSERT INTO zajp_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Mulelo wa ikane wa lukolo lwako wobwela hano na kutawala isi ino, kwavija kipigiti kino Waamoli bado hawanatenda vilozo vivikile hanhu ha hewo kutagusigwa.” ");
INSERT INTO zajp_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Zua vidiswile na kilo vikingile, nongo dilava yosi na wenge da moto ukwaka vibita hagatigati ya izinyenza za izinyama. ");
INSERT INTO zajp_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mdizua dija MNDEWA katenda lagano na Ablam, kamulongela, “Nowagwelela lukolo lwako isi ino, kulawa lwanda lwa Misili mbaka Lwanda lwa Yuflati, ");
INSERT INTO zajp_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","isi ya Wakeni, Wakenizi, Wakadimoni, ");
INSERT INTO zajp_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Wahiti, Wapelizi, Walefai, ");
INSERT INTO zajp_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Waamoli, Wakanaani, Wagiligashi, na Wayebusi.” ");
INSERT INTO zajp_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Salai, mtwanzi wa Ablam, hamulelele wana. Ila Salai kakala na nyakadala wa kitwanzi Mmisili yakemigwe Hajili. ");
INSERT INTO zajp_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Avo kamulongela Ablam, “MNDEWA kanizuila nie sambiniwe na wana. Genda ukawase na nyakadala wangu, siku nopata wana kubitila heyo.” Ablam kakitogola kija kiyamulongele Salai. ");
INSERT INTO zajp_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Avo Ablam viyeshile kukala milao longo dimwe muisi ya Kanaani, Salai mtwanzi wa Ablam kamsola Hajili Mmisili nyakadala wake wa kitwanzi, kamgwelela Ablam yawe mtwanzi wake. ");
INSERT INTO zajp_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ablam kamwingilila Hajili, na kapata inda. Ila viyavitangile kamba kana inda, Hajili kasonga kumzabuza Salai. ");
INSERT INTO zajp_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Abaho Salai kamulongela Ablam, “Gweye iyo kilamso cha gaja gehile gonigaya. Nikugwelela nyakadala wangu, sambi kovitanga kamba kana inda, avo kosonga kunizabuza. MNDEWA yawe mulamula hagatigati yako gweye na nie.” ");
INSERT INTO zajp_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ablam kamulongela Salai, “Nyakadala wako ka mmakono gako, tenda chochose chuugelegeza kamba kinoga kumtendela.” Abaho Salai kamtendela gehile Hajili, avo Hajili kamkimbila Salai. ");
INSERT INTO zajp_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Msenga wa MNDEWA wa kuulanga kam'vika Hajili behi na nzokwe ya mazi mkiwala ikalile hamgwazo wa inzila ya kuchola Shuli. ");
INSERT INTO zajp_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ija imsenga wa MNDEWA wa kuulanga kamuuza, “Hajili, nyakadala wa Salai, kolawa kwahi na kochola kwahi?” Hajili kamwidika, kamulongela, “Nomkimbila bibi yangu Salai.” ");
INSERT INTO zajp_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ija imsenga wa MNDEWA wa kuulanga kamulongela Hajili, “Bwela ha Salai, uwe nyakadala wake.” ");
INSERT INTO zajp_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Abaho kamulongela, “Nokugwelela ng'holo bwando, haduhu munhu yondayadahe kuzipeta. ");
INSERT INTO zajp_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Kopata mwana, komkema Sumaili, kwavija MNDEWA kakihulika kililo cha mgayo wako. ");
INSERT INTO zajp_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ila mwanago kowa kamba mhunda wa kumuhulo, kwavija haduhu munhu yondayadahe kumulongoza. Kowa mdumuka wa kila munhu, na kila munhu kowa mdumuka wake. Heyo kokala kutali na ndugu zake wose.” ");
INSERT INTO zajp_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hajili kamgwelela twaga MNDEWA, ayo yalongile na heyo twaga dikemigwa, “Gweye iyo Mulungu unyona nie.” Kwavija kalonga, “Nimona Mulungu yonyona nie” ");
INSERT INTO zajp_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Kino kicho kilamso cha sima dija kukemigwa Beeli-Lahai-Loi, sima hijo da hagatigati ya Kadeshi na Beledi. ");
INSERT INTO zajp_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hajili kamulelela mwana Ablam, na Ablam kamgwelela twaga dikemigwa Sumaili. ");
INSERT INTO zajp_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ablam kakala na milao malongo manane na sita kipigiti Hajili viyamulelile Sumaili. ");
INSERT INTO zajp_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ablam viyakalile na milao malongo tisa na tisa, MNDEWA kamulawilila, kamulongela, “Nie iyo Mulungu Mwene Mhiko. Nitegeleze nie na sambiuwe na mbuli na munhu. ");
INSERT INTO zajp_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Noditenda lagano jangu hagatigati yangu nie na gweye, na nie nolongeza lukolo lwako.” ");
INSERT INTO zajp_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ablam kagwa kingubanguba. Abaho Mulungu kamulongela, ");
INSERT INTO zajp_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Noditenda lagano dino na gweye. Nokwika kilagano kamba gweye kowa tata wa ndewa bwando. ");
INSERT INTO zajp_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Twaga jako hadikemigwa Ablam, ila Ablaham, kwavija nokutenda gweye kuwa tata wa ndewa bwando. ");
INSERT INTO zajp_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nokutenda wongezeke ng'hani. Lukolo lwako lokwiza kuwa ndewa bwando, na wandewa wolawa kumwako. ");
INSERT INTO zajp_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Nodigoga lagano jangu diniilagane na gweye hamoja na lukolo lwako londalwize kulawa mulelo umwe mbaka mulelo uyagwe, na kino chowa kilagano cha gunge na gunge. Mazua gose nie nowa Mulungu wako gweye na Mulungu wa lukolo lwako londalwize. ");
INSERT INTO zajp_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nokugwelela gweye na lukolo lwako isi ino yuukala sambi kamba muhenza. Isi yose ya Kanaani yowa ya lukolo lwako milongo yose, na nie nowa Mulungu wao.” ");
INSERT INTO zajp_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Mulungu kamulongela Ablaham, “Gweye vivija kolondigwa udigoge lagano jangu, wose gweye na lukolo lwako londalwize. ");
INSERT INTO zajp_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Dino dijo lagano jangu na gweye na lukolo lwako londalwize. Kila mbigalo mmwanza wenu kolondigwa yengile kumbi. ");
INSERT INTO zajp_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Molondigwa mwingizigwe kumbi, na chowa kilaguso cha lagano hagatigati yangu nie na mweye. ");
INSERT INTO zajp_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kulawa sambi kolondigwa umwingize kumbi kila mwana mbigalo kipigiti yahavikiza mazua manane, nyakadala yaleligwe mng'anda yako na nyakadala yaguligwe kulawa ha wahenza awo walekile kulawa mulukolo lwako. ");
INSERT INTO zajp_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Kila mbigalo kolondigwa yengizigwe kumbi, na mbuli ino yowa kilaguso cha lukuli kulagusa kamba lagano jangu diniilagane na gweye dowa lagano da digunge. ");
INSERT INTO zajp_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mbigalo yalekile kwingila kumbi, heyo hapetigwa kuwa munhu wangu, kwavija hadigogile lagano jangu.” ");
INSERT INTO zajp_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Vivija Mulungu kamulongela Ablaham, “Kulawa sambi sambiumkeme mtwanzi wako twaga dikemigwa Salai, ila twaga jake dowa Sala. ");
INSERT INTO zajp_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nommoteza, na nokugwelela mwana kubitila heyo. Nommoteza, na heyo kowa mama wa ndewa bwando, na wandewa wa wanhu wolawa kumwake.” ");
INSERT INTO zajp_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ablaham kagwa kingubanguba, kaseka, na kuilongela mwenyego, “Munhu yali na milao mia kodaha kulela mwana? Sala yali na milao malongo tisa kodaha kulela mwana?” ");
INSERT INTO zajp_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ablaham kamulongela Mulungu, “Habali sambiumuleke Sumaili yawe muhazi wangu?” ");
INSERT INTO zajp_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ila Mulungu kamulongela, “Bule, mtwanzi wako Sala kokulelela mwana, na gweye komgwelela twaga Isaka. Lagano jangu noditenda na heyo hamoja na lukolo lwake londalwize. Dino dowa lagano da digunge. ");
INSERT INTO zajp_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Mmbuli ya Sumaili, nigahulika gaja gaulondile, avo nommoteza na kumgwelela wana bwando na lukolo bwando. Heyo kowa tata wa wana wa mndewa longo dimwe na wabili, na lukolo lwake lowa undewa mkulu. ");
INSERT INTO zajp_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ila lagano jangu noditenda na Isaka, ayo Sala yondayakulelele gweye mkipigiti kamba kino cha mulao ukwiza.” ");
INSERT INTO zajp_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Viyeshile kulonga na heyo, Mulungu kachola uchana kulawa ha Ablaham. ");
INSERT INTO zajp_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Mdizua didija Ablaham kamsola mwanage Sumaili na wambigalo wose waleligwe mng'anda yake na waja waguligwe, kawengiza kumbi, kamba Mulungu viyamulongele. ");
INSERT INTO zajp_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ablaham kakala na milao malongo tisa na tisa kipigiti viyengizigwe kumbi, ");
INSERT INTO zajp_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","na mwanage Sumaili kakala na milao longo dimwe na midatu. ");
INSERT INTO zajp_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ablaham na mwanage Sumaili, wose wabili wengizigwa kumbi mdizua dimwe. ");
INSERT INTO zajp_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Na kila mbigalo yali mmulango wa Ablaham, nyakadala yaleligwe mng'anda yake na nyakadala yaguligwe kulawa ha wahenza, wengila kumbi hamoja na heyo. ");
INSERT INTO zajp_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","MNDEWA kamulawilila Ablaham behi na mibiki mikulu ya mwaloni ya munhu imwe yakemigwe Mamle kipigiti viyakalile hanhu ha kwingilila muihema yake mkipigiti cha keakea da imisi. ");
INSERT INTO zajp_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ablaham kenula meso gake, kawona wanhu wadatu wema behi na heyo. Viyawawene, hima kalawa hanhu ha kwingilila muihema yake kawakimbilila na kuwafugamila mavindi kainamila mbaka hasi haulongozi wao. ");
INSERT INTO zajp_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Kalonga, “Mndewa wangu, kamba nipata ngekewa hameso gako, sambiunibite mtumigwa wako. ");
INSERT INTO zajp_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Beta niwalagizile mazi mnave magulu genu, na muhumule hasi ya m'biki uno, ");
INSERT INTO zajp_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","niwagwelele kinhu cha kuja mpate mhiko abaho mgendelele na mwanza wenu, kwavija mmwizila mtumigwa wenu.” Na hewo walonga, “Tenda kamba vuulongile.” ");
INSERT INTO zajp_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ablaham hima kengila mdihema kamulongela Sala, “Hima, sola gunia da usage wako unogile woke mikate.” ");
INSERT INTO zajp_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abaho Ablaham kakimbila kuchola mdidale da ng'ombe, kasola mwanang'ombe yanonile na kumgwelela mtumigwa, na heyo kamchinja himahima na kumsasala. ");
INSERT INTO zajp_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ablaham kasola mtindi, matombo ga ng'ombe, na nyama ya mwanang'ombe iyamsasale, kawekila haulongozi wao. Kipigiti viwakalile woja, Ablaham kema behi nao, hasi ya um'biki. ");
INSERT INTO zajp_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Abaho wamuuza, “Kakwahi mtwanzi wako Sala?” Na heyo kawedika, “Ka haja mgati ya idihema.” ");
INSERT INTO zajp_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Imwe mmwanza wao kamulongela Ablaham, “Kweli nokubwelela mkipigiti kamba kino cha mulao ukwiza, na mtwanzi wako Sala kowa na mwana.” Sala kakala hachugu chake yotegeleza, hanhu ha kwingilila mdihema. ");
INSERT INTO zajp_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ablaham na Sala wakala wavyele ng'hani, na kipigiti cha Sala kupata wana kikala kimalile. ");
INSERT INTO zajp_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Avo Sala kaseka munda kwa munda, yolonga, “Vodahikaze kikongwe kamba nie mhate ndeng'ha ino, ihawa na mbigalo wangu vivija m'vyele ng'hani?” ");
INSERT INTO zajp_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Abaho MNDEWA kamuuza Ablaham, “Habali Sala yoseka na kulonga, ‘Kweli nie nodaha kupata mwana kipigiti kino cha uvyele?’ ");
INSERT INTO zajp_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Hana mbuli ileka kudahika ha MNDEWA? Nokubwelela mkipigiti kamba kino cha mulao ukwiza, na Sala kowa na mwana.” ");
INSERT INTO zajp_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sala kadumba, avo kabela na kulonga, “Nie sisekile.” Ila heyo kamulongela, “Ona, kuseka.” ");
INSERT INTO zajp_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Abaho waja iwanhu wenuka haja hawakalile, walongoza nzila ya Sodoma, na Ablaham kachola hamoja na hewo giladi yawasindikize. ");
INSERT INTO zajp_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Abaho MNDEWA kalonga mngelegeza, “Nimfise Ablaham kija kinilonda kutenda? ");
INSERT INTO zajp_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Kwavija lukolo lwake lowa undewa wene mhiko, na kubitila heyo ndewa zose zili muisi zomotezwa. ");
INSERT INTO zajp_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nie nimsagula heyo giladi yawafundize wanage na wanhu wali mng'anda yake na waja wondawavumbuke hamwande kuigoga nzila yangu mkugatenda ganogile na galibule uzenzeleganye, giladi nie, MNDEWA, nizitende mbuli zose ziniilagane nayo.” ");
INSERT INTO zajp_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Abaho MNDEWA kamulongela Ablaham, “Mbuli zihile za Sodoma na Gomola zibanza ng'hani na vilozo vao viwa vikulu ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nohumuluka hasi nilole kamba sang'hano zao zowotenda ziha kamba vija vinihulike. Kamba ihawa sio, novitanga.” ");
INSERT INTO zajp_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Abaho waja iwanhu wabili wahalawa wachola Sodoma, ila MNDEWA kasigala na Ablaham. ");
INSERT INTO zajp_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ablaham kamkwenhukila MNDEWA kamuuza, “Kweli kom'bananga munhu yalibule uzenzeleganye hamoja na munhu yali na uzenzeleganye? ");
INSERT INTO zajp_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kamba hana wanhu malongo matano mdiwambo walibule uzenzeleganye, kodibananga wambo jose? Huleka kudibananga idiwambo giladi wanhu waja malongo matano wakomboligwe? ");
INSERT INTO zajp_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Sambiutende kamba avo, kumkoma munhu yalibule uzenzeleganye hamoja na munhu yali na uzenzeleganye, ama kumtendela munhu yalibule uzenzeleganye galingile na gaja ga munhu yali na uzenzeleganye. Sambiutende avo, Mulamula wa ulumwengu wose halondigwa yawebule uzenzeleganye?” ");
INSERT INTO zajp_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","MNDEWA kalonga, “Kamba nihawavika wanhu malongo matano walibule uzenzeleganye mdiwambo da Sodoma, wambo jose nodileka kudibananga sama yao.” ");
INSERT INTO zajp_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ablaham kamuuza mwanza uyagwe, “Chonde, Mndewa, nigele kumgongo avija vinigendelela kukuuza, nie si kinhu, ila timbwisi na mitozi. ");
INSERT INTO zajp_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ila kamba uhawavika wanhu malongo mane na watano walibule uzenzeleganye, kodibananga idiwambo kwavija viwahunguke wanhu watano?” MNDEWA kamwidika, “Kamba nihawavika wanhu malongo mane na watano walibule uzenzeleganye, sidibananga.” ");
INSERT INTO zajp_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ablaham kamuuza mwanza uyagwe, “Vilihi kamba uhawavika wanhu malongo mane?” MNDEWA kamwidika, “Sidibananga idiwambo kamba nihawavika wanhu malongo mane.” ");
INSERT INTO zajp_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ablaham kalonga, “Chonde, sambiwone lusango, Mndewa, ila leka nikuuze mwanza uyagwe. Vilihi kamba uhawavika wanhu malongo madatu weiyeka walibule uzenzeleganye?” MNDEWA kamwidika, “Sidibananga idiwambo kamba nihawavika wanhu malongo madatu.” ");
INSERT INTO zajp_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ablaham kalonga, “Chonde, Mndewa, nigele kumgongo avija vunigendelela kukuuza. Vilihi kamba uhawavika wanhu malongo mabili walibule uzenzeleganye?” MNDEWA kamwidika, “Sidibananga idiwambo kamba nihawavika wanhu malongo mabili walibule uzenzeleganye.” ");
INSERT INTO zajp_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ablaham kalonga, “Chonde, sambiwone lusango, Mndewa, nokuuza mwanza uno tu. Vilihi kamba uhawavika wanhu longo dimwe weiyeka walibule uzenzeleganye?” MNDEWA kamwidika, “Sidibananga idiwambo kamba nihawavika wanhu longo dimwe walibule uzenzeleganye.” ");
INSERT INTO zajp_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Viyeshile kulonga na Ablaham, MNDEWA kachola, na Ablaham kabwela ukae. ");
INSERT INTO zajp_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Wasenga wabili wa Mulungu wa kuulanga wavika Sodoma mkipigiti cha ichungulo, na Loti kakala yakalile hana ulwivi lwa idiwambo. Loti viyawawene, kenuka kachola kuwabokela, kafugama mavindi kainamila mbaka hasi. ");
INSERT INTO zajp_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Kalonga, “Chonde, wandewa zangu, bagukeni kuing'anda ya mtumigwa wenu mganave magulu genu abaho muwase, na ihavika imitondo mogendelela na mwanza wenu.” Na hewo wamwidika, “Bule, towasa bahano hana ulubuga.” ");
INSERT INTO zajp_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ila kawagong'ondeza ng'hani, hakimambukizo, wachola hamoja na heyo na kwingila mng'anda yake. Loti kawalongela watumigwa zake wawatendele mandia iwahenza, avo wawokela mikate ilibule mela, na hewo waja. ");
INSERT INTO zajp_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Kipigiti iwahenza hawanachola kuwasa, wanhu wose kulawa ng'ambu zose za idiwambo da Sodoma waizunguluka ing'anda, wadodo na wakulu. ");
INSERT INTO zajp_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Wamkema Loti na kumuuza, “Wakwahi wanhu wezile kumwako ichungulo ino? Walave hanze kumwetu giladi tuwawase.” ");
INSERT INTO zajp_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loti kalawa hanze, kahinda ulwivi hachugu chake. ");
INSERT INTO zajp_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Kawalongela, “Viha hivo, wambwiga zangu, sambimtende mbuli zino zihile! ");
INSERT INTO zajp_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Loleni, nna wandele zangu wabili wang'hali hawanawasa na mbigalo. Beteni niwalavile hanze muwatendele vumulonda. Ila sambimuwatende mbuli wanhu wano. Kwavija weza mng'anda yangu.” ");
INSERT INTO zajp_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ila hewo wamulongela Loti, “Segele hano.” Abaho wailongela, “Munhu ino keza hano kamba muhenza na sambi kolonda kuwa mulamula!” Abaho wamulongela Loti kabili, “Tokutenda gweye gehile kubanza hewo.” Wamkunhiza Loti na kum'bweza kisengelenyuma wakala behi na kulubomola ulwivi. ");
INSERT INTO zajp_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ila waja iwanhu wabili wakalile mng'anda wauvugula ulwivi wagolosa makono gao na kumkwenhela Loti mng'anda abaho wahinda ulwivi. ");
INSERT INTO zajp_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Waja iwanhu wakalile hanze ya ulwivi lwa ing'anda wageligwa umbugumbugu giladi sambiwadahe kulona ulwivi, wose wadodo na wakulu. ");
INSERT INTO zajp_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Waja iwanhu wabili wamulongela Loti, “Hana ndugu yako hano mdiwambo? Wakwe zako, wanago wakitwanzi na wakimbigalo, ama munhu yoyose yali ndugu yako? Walave kunze ya idiwambo, ");
INSERT INTO zajp_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","kwavija tohabananga hanhu hano. MNDEWA kahulika mbuli zihile ng'hani zowotenda wanhu wa wambo dino, avo katulagiza tweye tudibanange.” ");
INSERT INTO zajp_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Avo Loti kachola na kuwalongela wakwe zake, awo wakalile wakasono wa wandele zake, kawalongela, “Hima, laweni hanhu hano, kwavija MNDEWA ka mmabehi kudibananga wambo dino.” Ila wakwe zake wagiza kotenda uponela. ");
INSERT INTO zajp_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Mkipigiti cha nzogolo zikwika, wasenga wa Mulungu wa kuulanga wamulopoza Loti, walonga, “Lopola, msole mtwanzi wako na wandele zako wabili wali hano, ama kokwangama kipigiti idiwambo dihabanangigwa.” ");
INSERT INTO zajp_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Loti kasinhasinha. Ila waja iwanhu wabili wamgoga mkono wake, na mkono wa mtwanzi wake, na wandele zake wabili na kuwalava hanze ya idiwambo, kwavija MNDEWA kakala yowonela bazi. ");
INSERT INTO zajp_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Abaho imwe wa wasenga wa Mulungu wa kuulanga kamulongela, “Kimbila uuhonye ugima wako! Sambiulole kukisogo ama sambiwime hanhu hohose kubonde. Kimbilila kumigongo, giladi sambiukomigwe.” ");
INSERT INTO zajp_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ila Loti kawalongela, “Bule, chonde, wandewa zangu! ");
INSERT INTO zajp_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Mtumigwa wenu kapata ngekewa hameso genu. Mweye mundagusila nie unozi mkulu mkuukombola ugima wangu. Ila migongo ya kutali ng'hani, mwangalo uno wonivika na nodanganhika kipigiti sinavika kuja. ");
INSERT INTO zajp_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Lola, hana kiwambo hano kili behibehi. Beta nikimbilile hiko. Kiwambo kidodo ng'hani, nihonye ugima wangu!” ");
INSERT INTO zajp_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Kamulongela, “Vinoga ng'hani, nikuhulika. Sikibananga ikiwambo chuulonga. ");
INSERT INTO zajp_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Hima! Kimbilila! Kwavija sitenda kinhu chochose mbaka vondauvike hiko.” Kwavija Loti kakikema kidodo, avo kiwambo kija kikemigwa Soali. ");
INSERT INTO zajp_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Zua dikala disimbuke kipigiti Loti viyavikile mkiwambo cha Soali. ");
INSERT INTO zajp_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Abaho MNDEWA kauhumulusa moto na baluti kulawa kuulanga mmiwambo ya Sodoma na Gomola. ");
INSERT INTO zajp_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kaibananga imiwambo na idibawe jose, hamoja na wanhu wose wakalile muja mmiwambo na miche yose ikalile muja mdibawe. ");
INSERT INTO zajp_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ila mtwanzi wa Loti kahinduka kukisogo, avo kagaluka nguzo ya munyu. ");
INSERT INTO zajp_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Imitondo iyagwe Ablaham hima kachola hanhu hayakalile yemile haulongozi wa MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Kalola ng'ambu ya Sodoma na Gomola na idibawe jose, kona yosi dofuka kulawa muisi, kamba yosi da tanuli. ");
INSERT INTO zajp_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ila Mulungu viyaibanange imiwambo ya kudibawe ako kuyakalile yokala Loti, kazigelegeza nhambiko za Ablaham, na kumkombola Loti kulawa mdihekaheka da ubananzi. ");
INSERT INTO zajp_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loti na wandele zake wabili wahalawa mkiwambo cha Soali na kukala muisi ya migongo, kwavija kadumba kukala Soali. Heyo na wandele zake wabili wakala mmhango. ");
INSERT INTO zajp_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ija imndele mkulu kamulongela mdodo wake, “Tata wetu m'vyele, na haduhu munhu muulumwengu wose wa kutusola tweye giladi tupate wana kamba viili ha wanhu wose. ");
INSERT INTO zajp_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Avo izo tumng'weze ugimbi tata wetu, abaho tuwase nayo, giladi tupate wana kubitila heyo, na lukolo lwetu lugendelele.” ");
INSERT INTO zajp_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Avo wamng'weza tataao ugimbi ikilo ija, na ija imndele mkulu kengila mmhango na kuwasa na tataake. Ila tataake havitangile kipigiti mndele wake viyatambalale ama viyenuke. ");
INSERT INTO zajp_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Zua diyagwe ija imndele mkulu kamulongela mdodo wake, “Ikilo ibitile niwasa na tataangu. Beta tumng'weze ugimbi kabili tataetu ikilo ya lelo, na gweye uwase nayo, giladi tupate wana kubitila heyo.” ");
INSERT INTO zajp_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Avo vivija wamng'weza ugimbi tataao ikilo ija, na ija imndele mdodo kengila mmhango na kuwasa na tataake. Vivija tataake havitangile kipigiti mndele wake viyatambalale ama viyenuke. ");
INSERT INTO zajp_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Avo wandele wose wabili wa Loti wapata inda kubitila tataao. ");
INSERT INTO zajp_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ija imndele mkulu kapata mwana mbigalo, kamgwelela twaga dikemigwa Moabu. Heyo iyo muhenga wa Wamoabu wa lelo. ");
INSERT INTO zajp_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Vivija na ija imndele mdodo kapata mwana mbigalo, kamgwelela twaga dikemigwa Ben-Ami. Heyo iyo muhenga wa Waamoni wa lelo. ");
INSERT INTO zajp_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ablaham kasegela kulawa Mamle kachola muisi ya Negebu na kukala hagatigati ya isi za Kadeshi na Shuli. Abaho kasegela kachola kukala mdiwambo da Gelali mkipigiti kidodo, ");
INSERT INTO zajp_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","hanhu haja Ablaham kuyamulongile Sala mtwanzi wake, “Ino iyo lumbu jangu.” Abaho Abimeleki mndewa wa Gelali kamsola Sala na kumtenda kuwa mtwanzi wake. ");
INSERT INTO zajp_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ila ikilo imwe Mulungu kamulawilila Abimeleki muinzozi, kamulongela, “Kodanganhika sama ya imtwanzi yuumsolile, kwavija kumsola mtwanzi wa munhu.” ");
INSERT INTO zajp_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimeleki hamkwenhukile ija imtwanzi, avo kalonga, “Mndewa, kolonda kuwabananga wanhu walibule uzenzeleganye? ");
INSERT INTO zajp_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ablaham mwenyego kalonga kamba heyo kakala lumbu jake, na imtwanzi kalonga vivija. Nitenda vino na nia inogile, na sitendile mbuli ihile.” ");
INSERT INTO zajp_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Abaho Mulungu kamulongela muinzozi, “Ona, nivitanga kamba kutenda vino na nia inogile, avo nikwimiliza giladi sambiunitende vilozo. Kino kicho kilamso kamba sikulekile umkwase. ");
INSERT INTO zajp_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","M'bweze mtwanzi wa munhu, kwavija mbigalo wake muhokozi, na heyo kokutambikila na gweye kowa mgima. Ila kamba hum'bwezile, uvitange kamba gweye na wanhu zako wose modanganhika.” ");
INSERT INTO zajp_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Imitondo ng'hani ya zua diyagwe, Abimeleki kawakema wakulu zake wose na kuwalongela gaja galawilile, na hewo wadumba ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abaho Abimeleki kamkema Ablaham, kamulongela, “Kututendela choni? Mbuli yaki ihile inikutendile mbaka kugala nhaguso ng'hulu kumwangu nie na muundewa wangu? Kunitendela vinhu havilondigwe kutendeka. ");
INSERT INTO zajp_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Habali utendile gano?” ");
INSERT INTO zajp_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ablaham kamwidika, kamulongela, “Nitenda vino kwavija nigelegeza kamba wanhu wa isi ino wabule kidumbo cha Mulungu, avo wodaha kung'homa sama ya mtwanzi wangu. ");
INSERT INTO zajp_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Kweli heyo lumbu jangu, kwavija tweye twa wana wa tata imwe, ila kila munhu kana mamaake. Na nie nimsola heyo yawe mtwanzi wangu. ");
INSERT INTO zajp_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Mulungu viyanikemile kulawa mng'anda ya tataangu, nimulongela mtwanzi wangu, ‘Kamba uhaninogela nie, kila hanhu hatuchola, mulongele kila munhu kamba nie iyo lumbu jako.’ ” ");
INSERT INTO zajp_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abaho Abimeleki kasola ng'hondolo na ng'ombe, na nyakadala wakitwanzi na wakimbigalo kamgwelela Ablaham, na kum'bwezela Sala mtwanzi wake. ");
INSERT INTO zajp_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki kamulongela Ablaham, “Isi ino yose yangu nie, kala hanhu hohose haulonda.” ");
INSERT INTO zajp_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abaho kamulongela Sala, “Nimgwelela lumbu jako vidanga alufu imwe va feza haulongozi wa wanhu wose wali hamoja na gweye, giladi kugubika mbuli zihile zinikutendele, na kila munhu kovitanga kamba hutendile mbuli ihile.” ");
INSERT INTO zajp_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abaho Ablaham katambika ha Mulungu. Mulungu kamuhonya Abimeleki na mtwanzi wake na nyakadala zake wa kitwanzi giladi wadahe kupata wana kabili. ");
INSERT INTO zajp_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Kwavija MNDEWA kakala yazifungile inda za wanhu wose wali mng'anda ya Abimeleki sama ya Sala, mtwanzi wa Ablaham. ");
INSERT INTO zajp_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","MNDEWA kamgwelela Sala ngekewa kamba viyalongile, na kamtendela Sala kija kiyamwikile kilagano. ");
INSERT INTO zajp_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sala kapata inda na kumulelela Ablaham mwana mbigalo muuvyele wake, mkipigiti kikija Mulungu kiyamwikile kilagano. ");
INSERT INTO zajp_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ablaham kamgwelela imwana twaga dikemigwa Isaka, ");
INSERT INTO zajp_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","na Isaka viyakalile na mazua manane, Ablaham kamwingiza kumbi, kamba Mulungu viyamulagize. ");
INSERT INTO zajp_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ablaham kakala na milao mia kipigiti Isaka viyavumbuke. ");
INSERT INTO zajp_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sala kalonga, “Mulungu kanigalila kiseko, na kila munhu yohulika mbuli ino koseka hamoja na nie. ");
INSERT INTO zajp_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Yalihi yahadahile kumulongela Ablaham kamba Sala yahakong'heze wana? Ila nimulelela mwana muuvyele wake.” ");
INSERT INTO zajp_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mwana kakula, na kulekezwa kong'ha, na mdizua diyalekezwe kong'ha, Ablaham katenda lusona lukulu. ");
INSERT INTO zajp_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ila Sala kamona mwanage Ablaham, yalelile na Hajili Mmisili, yotenda uponela. ");
INSERT INTO zajp_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Avo kamulongela Ablaham, “Muwinge nyakadala ino hamoja na mwanage, kwavija mwana wa nyakadala ino halondigwa kuhala hamoja na mwanangu Isaka.” ");
INSERT INTO zajp_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Mbuli ino ikala ihile ng'hani hameso ga Ablaham, kwavija Sumaili vivija kakala mwanage. ");
INSERT INTO zajp_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ila Mulungu kamulongela Ablaham, “Sambiwone giogio sama ya imwana na nyakadala wako Hajili. Tegeleza kila chondayakulongele Sala mtwanzi wako, kwavija lukolo lwako unikile kilagano nagwe lolawilila kubitila Isaka. ");
INSERT INTO zajp_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Vivija nomtenda mwana wa nyakadala wako yawe undewa. Kwavija heyo vivija mwanago.” ");
INSERT INTO zajp_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Imitondo iyagwe, Ablaham kasola mandia na kibuyu cha mazi kitendigwe na kwembe, kamgwelela Hajili. Kavibasika mmaega gake na kumuleka yachole hamoja na imwana. Kachola na kuzungulukazunguluka mkiwala cha Beeli-Sheba. ");
INSERT INTO zajp_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mazi vugamalile, kamwika imwana mkitutua ");
INSERT INTO zajp_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","na kukala hasi utali wa kwasa msale kulawa haja hayakalile imwana. Kalonga munda kwa munda, “Silonda kumona mwanangu viyodanganhika.” Kipigiti viyakalile haja, kasonga kulila na dizwi kulu. ");
INSERT INTO zajp_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Na Mulungu kadihulika dizwi da immhale, na msenga wa Mulungu wa kuulanga kamkema Hajili kamulongela, “Hajili, kolilila choni? Sambiudumbe kwavija Mulungu kadihulika dizwi da immhale haja hayali. ");
INSERT INTO zajp_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Mwinule imwana, umgoge mkono kwavija kulawa kumwake wolawa wanhu bwando wondawawe undewa mkulu.” ");
INSERT INTO zajp_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Abaho Mulungu kagagubula meso gake, kachona kisima cha mazi. Avo kachola na kukimemeza mazi ikibuyu na kumgwelela imwana yang'we. ");
INSERT INTO zajp_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Mulungu kakala hamoja na ija imwana, kipigiti cha makuzi gake. Kakala mkiwala na kakala galu wa kusaka wang'onyo na mhinde na misale. ");
INSERT INTO zajp_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Viyakalile yokala mkiwala cha Palani, mamaake kamsolela mtwanzi kulawa muisi yake ya Misili. ");
INSERT INTO zajp_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Kipigiti kija Abimeleki na Fikoli, mkulu wa asikali zake, wamulongela Ablaham, “Mulungu ka hamoja na gweye mmbuli zose zuutenda. ");
INSERT INTO zajp_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Avo niduilile hano haulongozi wa Mulungu, kamba hunivwizila nie, ama wanangu, ama lukolo lwangu. Nilagusile nie na wanhu wose wa isi yuukala kamba muhenza unhu uuja unikulagusile gweye.” ");
INSERT INTO zajp_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ablaham kalonga, “Noiduila.” ");
INSERT INTO zajp_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abaho Ablaham kamtwanganikila Abimeleki mmbuli ya sima da mazi diwadibokonye watumigwa wa Abimeleki. ");
INSERT INTO zajp_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki kalonga, “Simtangile yatendile mbuli ino, gweye hunilongele, uno uwo mwanza wangu wa ichanduso kuihulika mbuli ino.” ");
INSERT INTO zajp_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abaho Ablaham kamgwelela Abimeleki ng'hondolo, menhe, na ng'ombe, na wanhu wano wabili watenda lagano. ");
INSERT INTO zajp_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ablaham kabagula mabogwa saba ga ng'hondolo kulawa mdidale jake da wang'onyo. ");
INSERT INTO zajp_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki kamuuza Ablaham, “Nhegulo yake choni mabogwa gano saba ga ng'hondolo yuuwabagule?” ");
INSERT INTO zajp_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ablaham kamwidika Abimeleki, kamulongela, “Wabokele ng'hondolo wano saba kulawa mumkono wangu, wawe usindila kamba sima dino nidihimba nie.” ");
INSERT INTO zajp_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Avo hanhu haja hakemigwa Beeli-Sheba, kwavija wanhu wabili watenda kiduilo. ");
INSERT INTO zajp_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Viweshile kutenda lagano haja Beeli-Sheba, Abimeleki na Fikoli, mkulu wa asikali zake, wabwela kuisi ya Wafilisti. ");
INSERT INTO zajp_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abaho Ablaham kahanda mdai ako Beeli-Sheba na kumtambikila MNDEWA, Mulungu wa digunge. ");
INSERT INTO zajp_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Na Ablaham kakala kamba muhenza muisi ya Wafilisti mkipigiti kitali. ");
INSERT INTO zajp_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Vuzimalile mbuli zino, Mulungu kamgeza Ablaham, kamulongela, “Ablaham!” Na heyo kedika, “Nie hano.” ");
INSERT INTO zajp_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Mulungu kamulongela, “Msole mwanago Isaka, ayo yaleligwe yeiyeka, ayo yuumnogele ng'hani, uchole kuna iisi ya Molia, ukamulave nhosa ya kulukuza kuna idigongo dondanikulagusile.” ");
INSERT INTO zajp_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Avo Ablaham kalamuka imitondo ng'hani, kakanha ngodi za kulukuzila ija inhosa. Katandika mhunda wake, na kuwasola watumigwa zake wabili hamoja na mwanage Isaka. Kahalawa na kuchola hanhu hayamulongele Mulungu. ");
INSERT INTO zajp_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Zua da ikadatu Ablaham kalola na kuhona haja ihanhu kutalitali. ");
INSERT INTO zajp_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abaho Ablaham kawalongela waja iwatumigwa zake, “Kaleni hano na iwamhunda. Nie na immhale tochola haja, totambika abaho towabwelela.” ");
INSERT INTO zajp_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ablaham kasola ngodi za inhosa ya kulukuza na kumdikwa mwanage Isaka, na heyo mwenyego kasola moto na zele. Viwakalile wochola, ");
INSERT INTO zajp_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaka kamuuza tataake, yolonga, “Tata.” Ablaham kamwidika, “Nie hano, mwanangu.” Isaka kalonga, “Moto tunao na ngodi tunazo, ila kakwahi ing'hondolo wa kumulava nhosa ya kulukuza?” ");
INSERT INTO zajp_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ablaham kamulongela, “Mwanangu, Mulungu mwenyego komulava ng'hondolo wa nhosa ya kulukuza.” Avo wabili waja wagendelela na mwanza hamoja. ");
INSERT INTO zajp_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Viwavikile hanhu Mulungu hayamulagusile, Ablaham kazenga kilingo cha kulavila nhosa, na kuziwandika zingodi, kamfunga Isaka mwanage na kumtambalika mkilingo cha kulavila nhosa uchana ya izingodi. ");
INSERT INTO zajp_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abaho kagolosa mkono wake kasola zele jake giladi yamchinje mwanage. ");
INSERT INTO zajp_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ila msenga wa MNDEWA wa kuulanga kamkema na kumulongela, “Ablaham, Ablaham!” Na heyo kedika, “Nie hano.” ");
INSERT INTO zajp_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kalonga, “Sambiumgolosele mkono wako imwana ama kumtendela kinhu chochose kihile, kwavija sambi novimanya kamba komdumba Mulungu, avija vuulekile hata kunizuilila mwanago, mwanago yeiyeka.” ");
INSERT INTO zajp_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ablaham kahinduka kamona ng'hondolo mhembe zake zinamate mkitutua. Ablaham kachola na kumsola ija ing'hondolo na kumulava yawe nhosa ya kulukuza na kumuleka mwanage. ");
INSERT INTO zajp_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Avo Ablaham kahakema hanhu haja Yahweh-Yileh, nhegulo yake “MNDEWA iyo yalavaga.” Na wanhu woulonga ulonzi uno mbaka lelo, kamba, “Hakigongo cha MNDEWA, kalavaga.” ");
INSERT INTO zajp_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Msenga wa MNDEWA wa kuulanga, kamkema Ablaham mwanza wa ikabili kulawa kuulanga, ");
INSERT INTO zajp_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","na kulonga, “Noiduila mditwaga jangu mwenyego kwavija kuitenda mbuli ino, na hunizuilile hata mwanago, mwanago yeiyeka, ");
INSERT INTO zajp_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","kweli nokumoteza na kulutenda lukolo lwako longezeke luwe kamba nhondo za kuulanga na kamba misenga ya kumgwazo wa ibahali. Lukolo lwako loibokonya miwambo ya wadumuka zao, ");
INSERT INTO zajp_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","na kubitila lukolo lwako gweye ndewa zose muisi zomotezwa, kwavija kunitegeleza nie.” ");
INSERT INTO zajp_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Avo Ablaham kabweleganya ha watumigwa zake, na wose hamoja wabweleganya Beeli-Sheba, na Ablaham kagendelela kukala Beeli-Sheba. ");
INSERT INTO zajp_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Kipigiti kidodo hamwande Ablaham kalongeligwa kamba Milka vivija kamulelela mdodo wako Naholi wana wanane. ");
INSERT INTO zajp_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Waichanduso kokemigwa Uzi, iyagwe Buzi, abaho Kemueli tata wa Alamu, ");
INSERT INTO zajp_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedi, Hazo, Pilidashi, Jidilafi, na Betueli. ");
INSERT INTO zajp_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betueli iyo tata wa Lebeka. Wana wano wanane iwo Milka iyamulelele Naholi, mdodo wake Ablaham. ");
INSERT INTO zajp_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Vivija Naholi kakala na wana wane iyawalelile na mtwanzi wa kunze yakalile yokemigwa Leuma. Na gano gago matwaga gao, Teba, Gaham, Tahashi, na Maka. ");
INSERT INTO zajp_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sala kakala milao mia na malongo mabili na saba. ");
INSERT INTO zajp_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sala kadanganhikila hanhu hokemigwa Kiliasi-Aliba, sambi hokemigwa Hebloni, muisi ya Kanaani, na Ablaham kachola kumulilila. ");
INSERT INTO zajp_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ablaham kenuka kulawa hamgwazo wa mwehe wake yadanganhike na kuchola kuwalongela waja Iwahiti, ");
INSERT INTO zajp_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Nie na muhenza nikala hano mmwanza wenu. Niguzileni hanhu ha kumzikila mwehe wangu.” ");
INSERT INTO zajp_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Wahiti wamulongela Ablaham, ");
INSERT INTO zajp_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Tutegeleze mndewa, kumwetu tweye gweye kwa munhu mkulu ng'hani. Mzike mtwanzi wako hana gamapanga gogose gondausagule kulawa mgamapanga getu, haduhu munhu yoyose mmwanza wetu yondayakugomese gweye sambiumzike mwehe wako mdipanga jake.” ");
INSERT INTO zajp_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abaho Ablaham kenuka na kainamila haulongozi wa waja Iwahiti. ");
INSERT INTO zajp_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Kawalongela, “Kamba mtogola nie nimzike mwehe wangu hano avo nitegelezeni na muyalalileni Efloni mwanage Zohali sama yangu nie, ");
INSERT INTO zajp_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","yaniguzile mhango ili ako Makipela mumgwazo wa umgunda wake. Mulongeleni yaniguzile dimwe kwa dimwe hano haulongozi wenu iwe hanhu hangu ha kuzikila.” ");
INSERT INTO zajp_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efloni mwenyego kakala yakalile haja hamting'hano hamoja na Wahiti wayagwe, hana idizivi da kwingilila mdiwambo, kamwidika Ablaham haulongozi wa Wahiti wose. ");
INSERT INTO zajp_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Kalonga, “Si vivo, mndewa, nitegeleze, nokugwelela uja umgunda, na nokugwelela ija imhango ili mumgunda uja, nokugwelela haulongozi wa wanhu zangu, kazike mwehe wako.” ");
INSERT INTO zajp_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ablaham kainamila kabili haulongozi wa Wahiti, ");
INSERT INTO zajp_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","kamulongela Efloni haulongozi wa Wahiti wose, yolonga, “Nitegeleze, nokuliha hela ya umgunda wose, nokuyalalila uibokele giladi nikamzike mwehe wangu.” ");
INSERT INTO zajp_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efloni kamwidika Ablaham, yolonga, ");
INSERT INTO zajp_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Nitegeleze, mndewa, mgunda uja woguzigwa vidanga mia nne va feza. Kino kinhu kidodo ng'hani kumwangu nie na gweye! Mzike mwehe wako.” ");
INSERT INTO zajp_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ablaham kazitogola mbuli za Efloni, avo kampimila Efloni vidanga va feza viyalondile, haulongozi wa Wahiti, vidanga mia nne va feza zipimigwe kulingana na vipimilo va soko da kipigiti kija. ");
INSERT INTO zajp_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Avo mgunda wa Efloni uli Makipela ukalile ng'ambu ya ulawilo wa zua wa Mamle, na ija imhango ikalile mumgunda, na mibiki yose ikalile muja, kaguziligwa Ablaham. ");
INSERT INTO zajp_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Viwa vake dimwe kwa dimwe haulongozi wa Wahiti wose wezile haja hadizivi da idiwambo. ");
INSERT INTO zajp_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Abaho Ablaham kamzika Sala mwehe wake muimhango ikalile mumgunda wa Makipela behi na Mamle, ukalile Hebloni muisi ya Kanaani. ");
INSERT INTO zajp_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Avo Wahiti wamguzila Ablaham uja umgunda na imhango ikalile mumgunda, hawe hanhu hake ha kuzikila. ");
INSERT INTO zajp_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ablaham kakala m'vyele ng'hani, na MNDEWA kakala yammoteze Ablaham m'vinhu vose viyatendile. ");
INSERT INTO zajp_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ablaham kamulongela mtumigwa wake ayo yakalile mvyele kuwabanza watumigwa zake wose wayagwe, ayo yakalile mkulu wa vinhu vake vose viyakalile navo, “Tenda kiduilo mkwika mkono wako hasi ya haza jangu. ");
INSERT INTO zajp_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Nokulonda gweye uiduile mditwaga da MNDEWA, Mulungu wa isi na ulanga, kamba humsagulila mwehe mwanangu kulawa mwa wandele wa Kikanaani muisi ino inikala, ");
INSERT INTO zajp_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ila genda kuisi yangu ha ndugu zangu, ukamsagulile mwehe mwanangu Isaka.” ");
INSERT INTO zajp_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ija imtumigwa kamulongela, “Yowaze kamba ija imndele yahalema kwiza na nie hano? Nimsole mwanago nichole nayo kuja kuna iisi yuulawile?” ");
INSERT INTO zajp_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ablaham kamulongela, “Lola Sambiumsole mwanangu umgale kuja, ");
INSERT INTO zajp_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","MNDEWA, Mulungu yali kuulanga, yanilavile nie kulawa mng'anda ya tataangu na kulawa muisi inivumbuke ayo yalongile na nie na ayo yaniduilile yolonga, ‘Isi ino nowagwelela lukolo lwako,’ komtuma msenga wake wa kuulanga yakulongole giladi ukamgalile mwanangu mwehe kulawa kuja. ");
INSERT INTO zajp_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ila kamba ija imndele yahalema kukukoleleza, basi kozuluhuka kulawa mkiduilo kino, kinhu kimwe kinikugong'ondeza, sambiumsole mwanangu uchole nayo kuja.” ");
INSERT INTO zajp_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Avo ija imtumigwa keka mkono wake hasi ya haza da Ablaham mndewa wake, na kumduilila kugatenda gaja gayamulongele. ");
INSERT INTO zajp_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Abaho ija imtumigwa kasola ngamia longo dimwe wa mndewa wake na kuchola, kuno yosola namna zose za vinhu vinogilenogile kulawa ha mndewa wake. Kalawa kachola Alamu-Nahalaimu kudiwambo da Naholi. ");
INSERT INTO zajp_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Viyavikile, kawafugamiza mavindi waja iwangamia hanze ya idiwambo hamgwazo wa idisima da mazi, ikala ichungulo kipigiti chowocholaga watwanzi kudeha mazi. ");
INSERT INTO zajp_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Katambika yolonga, “MNDEWA, Mulungu wa mndewa wangu Ablaham, lelo ungwelele kija kiniwinzile, ulaguse unozi wako ha mndewa wangu Ablaham. ");
INSERT INTO zajp_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Lola, nokwima hano behi ya idisima da igamazi, na wandele wa wanhu wa mkiwambo wokwiza hano kudeha mazi. ");
INSERT INTO zajp_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ija imndele yondanimulongele, ‘Humulusa nongo yako ning'we,’ yondayalonge, ‘Ing'wa na vivija nowang'weza na ngamia zako,’ hiyo iyo yuumsagulile mtumigwa wako Isaka. Mkutenda vino novitanga kamba kuulagusa unozi wako ha mndewa wangu.” ");
INSERT INTO zajp_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Viyakalile hanamambukiza kutambika, Lebeka keza na nongo yake mdiega. Kakala mwana wa Betueli, Betueli kakala mwana wa Naholi, mdodo wake Ablaham, na mtwanzi wake kakemigwa Milka. ");
INSERT INTO zajp_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Lebeka kakala yanogile ng'hani, mhambe, haduhu mbigalo yakalile yawasile nayo. Kahumuluka hadisima, kamemeza nongo yake, na kubweleganya. ");
INSERT INTO zajp_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Abaho ija imtumigwa kamkimbilila na kumulongela, “Ngwaa mazi kidogo kulawa mnongo yako.” ");
INSERT INTO zajp_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Kamulongela, “Ing'wa, mndewa wangu,” hima kanenula nongo yake na kumgwelela mazi ga kung'wa. ");
INSERT INTO zajp_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Viyamambukize kumgwaa mazi ija imtumigwa, kalonga, “Vivija nowadehela na ngamia zako mbaka wose vondawamambukize kung'wa.” ");
INSERT INTO zajp_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Hima kagela mazi mkia cha kung'wila wang'onyo na kukimbilila kabili kusima kudeha mazi mwanza uyagwe na kuwang'weza ngamia wose wasigale. ");
INSERT INTO zajp_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Bila kulonga kinhu, ija imtumigwa kamulola ng'hani ija imndele, yone kamba MNDEWA iyo yamtendile mndele ija yawe mtwanzi wa mwana wa mndewa wake ama sio. ");
INSERT INTO zajp_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Waja iwangamia viwamambukize kung'wa, ija imunhu kasola kipini cha zahabu cha hela bwando, kakigela mmhula yake na bangili mbili za zahabu za hela bwando mmakono gake. ");
INSERT INTO zajp_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Abaho kalonga, “Nilongele gweye kwa mwana wa munhu yalihi? Nilongele kuna gati mng'anda ya tataako ditulumba nie na wanhu zangu kuwasa ikilo ya lelo?” ");
INSERT INTO zajp_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Kamulongela, “Nie na mwana wa Betueli mwanage Naholi, iyalelile na Milka, mtwanzi wake. ");
INSERT INTO zajp_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Kuna mibelege bwando na mijani ya kuja ngamia zenu, vivija hana gati da kuwasa wahenza.” ");
INSERT INTO zajp_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Abaho ija imtumigwa kafugama mavindi kainamila na kumtambikila MNDEWA, ");
INSERT INTO zajp_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","na kulonga, “Yayenzigwe MNDEWA, Mulungu wa Ablaham mndewa wangu, ayo yadigendeleze noge jake na vija viyagendelele kukigoga kilagano chake ha mndewa wangu Ablaham. MNDEWA kanilongoza dimwe kwa dimwe mbaka kung'anda ya ndugu wa mndewa wangu.” ");
INSERT INTO zajp_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Abaho ija imndele kakimbila kachola kuwalongela wanhu wa ng'anda ya mamaake mbuli zose zilawilile. ");
INSERT INTO zajp_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Lebeka kakala na lumbu yakalile yokemigwa Labani. Labani kamuhulika Lebeka yolonga gaja gayalongile ija imtumigwa, na kuchona ikipini na izibangili ziyavalile. Avo Labani kakimbila kachola ha mtumigwa wa Ablaham, ayo yakalile yemile hamgwazo wa iwangamia behi na idisima. ");
INSERT INTO zajp_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Kalonga, “Izo ukae kumwetu, gweye umotezwe na MNDEWA, habali wimile hano hanze ya ikiwambo? Ng'anda isasaligwa na hanhu ha kukala ngamia hasasaligwa.” ");
INSERT INTO zajp_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Avo ija imtumigwa kachola kuna ing'anda na waja iwangamia wanenuligwa. Mibelege na mijani igaligwa na kugweleligwa iwangamia waje, na mazi gagaligwa sama yake na waja wakalile hamoja na heyo wagele magulu gao. ");
INSERT INTO zajp_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Mandia vigepile, ija imtumigwa kalonga, “Sija mbaka nilonge gaja ganilonda kulonga.” Labani kamulongela, “Longa.” ");
INSERT INTO zajp_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kalonga, “Nie na mtumigwa wa Ablaham. ");
INSERT INTO zajp_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","MNDEWA kammoteza mndewa wangu ng'hani na kumtenda yawe mgoli, kamgwaa heyo ng'hondolo na ng'ombe, feza na zahabu, nyakadala wakitwanzi na wakimbigalo, na ngamia na mhunda. ");
INSERT INTO zajp_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Na Sala, mwehe wa mndewa wangu, kamulelela mndewa wangu mwana mbigalo kipigiti cha uvyele wake na kamgwelela kila kinhu kiyalinacho. ");
INSERT INTO zajp_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Na mndewa wangu kaniduiza na kiduilo, yolonga, ‘Sambiumsolele mtwanzi mwanangu kulawa mwa wandele wa Kikanaani, hano muisi inikala, ");
INSERT INTO zajp_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ila uchole kung'anda ya tataangu, ha ndugu zangu, ukamsolele mwehe mwanangu,’ ");
INSERT INTO zajp_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Nimuuza mndewa wangu, ‘Yowaze kamba yahalema kwiza hamoja na nie?’ ");
INSERT INTO zajp_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ila heyo kalonga, ‘MNDEWA initembela haulongozi wake komulagiza msenga wake wa kuulanga yachole hamoja nagwe na kutenda sambiubwele bule mmwanza wako. Ukamsolele mwanangu mtwanzi kulawa ha ndugu zangu kung'anda ya tataangu. ");
INSERT INTO zajp_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kozuluhuka kulawa mkifungo cha kiduilo changu, ahaja vondauchole ha ndugu zangu. Hata kamba hawakugwelele mndele sama ya mwanangu, kozuluhuka kulawa mkiduilo changu.’ ");
INSERT INTO zajp_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Lelo vunivikile hadisima, nitambika nilonga, ‘MNDEWA, Mulungu wa mndewa wangu Ablaham, kamba vihakunogela, uutende mwanza wangu uno univikize hano sambimbwele bule. ");
INSERT INTO zajp_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nokwima hano hamgwazo wa idisima, na mndele yondayeze kudeha mazi, nompula yanigwelele mazi kidogo kulawa mnongo yake ning'we, ");
INSERT INTO zajp_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","na yondayanilongele ning'we, na vivija kowadehela na ngamia zangu. Ino iyo yawe mtwanzi iyamsagule MNDEWA wangu yawe mwehe wa mwana wa mndewa wangu.’ ");
INSERT INTO zajp_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Kipigiti sinamambukiza kutambika mmoyo wangu, Lebeka keza na nongo yake ya mazi mdiega jake, kahumuluka hadisima na kudeha mazi. Nimulongela, ‘Ngwelela mazi ning'we.’ ");
INSERT INTO zajp_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Hima kanenula nongo yake kulawa mdiega jake, na kulonga, ‘Ing'wa na vivija nowang'weza na ngamia zako.’ Avo ning'wa na vivija kawang'weza iwangamia. ");
INSERT INTO zajp_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Abaho nimuuza, ‘Gweye kwa mndele wa munhu yalihi?’ Kalonga, ‘Nie na mndele wa Betueli, mwana wa Naholi iyalelile na Milka mtwanzi wake.’ Avo nim'vaza kipini mmhula yake, na bangili mmakono gake. ");
INSERT INTO zajp_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Abaho nifugama mavindi niinamila nimtambikila MNDEWA, na nimuyenzi MNDEWA, Mulungu wa mndewa wangu Ablaham, yanilongoze nie mnzila ilondigwe kumpata mndele kulawa ndugu za mndewa wangu sama ya mwanage. ");
INSERT INTO zajp_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Avo kamba vihawanogela kulagusa noge na unozi ha mndewa wangu, nilongeleni, na kamba haviwanogele, vivija nilongeleni giladi nivitange nihindukile nzila ilihi.” ");
INSERT INTO zajp_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Abaho Labani na Betueli wamulongela, “Mbuli zino zilawa ha MNDEWA, avo tweye twabule kinhu cha kulonga. ");
INSERT INTO zajp_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Lola, Lebeka ka haulongozi wako, msole uchole nayo, yakawe mwehe wa mwana wa Mndewa wako kamba MNDEWA viyalongile.” ");
INSERT INTO zajp_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ija imtumigwa wa Ablaham viyahulike gaja gawalongile, kafugama mavindi kainamila mbaka hasi, haulongozi wa MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ija imtumigwa kalava vinhu va feza na zahabu na vivalo, na kumgwelela Lebeka. Vivija kamgwelela lumbu na mamaake Lebeka nhunza za hela bwando. ");
INSERT INTO zajp_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Abaho heyo na wanhu iyakalile nao waja na kung'wa na wawasa haja. Imitondo viwalamuke ija imtumigwa wa Ablaham kalonga, “Nilekeni nichole ha mndewa wangu.” ");
INSERT INTO zajp_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mamaake na lumbu jake Lebeka walonga, “Muleke tanhu ino imndele yakale hamoja na tweye walau mazua longo dimwe, abaho kochola hamoja na gweye.” ");
INSERT INTO zajp_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ila ija imtumigwa kalonga, “Sambimng'hawize kwavija MNDEWA hanibwezile bule mmwanza wangu, nilekeni nichole, nibweleganye ha mndewa wangu.” ");
INSERT INTO zajp_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Walonga, “Natumkeme imndele tumuuze.” ");
INSERT INTO zajp_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Wamkema Lebeka, na kumuuza, “Kochola na munhu ino?” Na heyo kalonga, “Nochola.” ");
INSERT INTO zajp_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Avo wamuleka lumbu jao Lebeka hamoja na yaya yamulelile Lebeka kipigiti viyakalile mdodo yachole na ija imtumigwa wa Ablaham hamoja na wanhu iwezile nao. ");
INSERT INTO zajp_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Wammoteza Lebeka na kumulongela, “Gweye, lumbu jetu, uwe mama wa wanhu bwando, maalufu kwa maalufu! Wanago wawe na mhiko na wabokonye miwambo ya wadumuka zao.” ");
INSERT INTO zajp_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Abaho Lebeka na watumigwa zake wa kitwanzi wenuka wakwela mngamia na kumkoleleza ija imtumigwa, avo ija imtumigwa kamsola Lebeka na kuchola. ");
INSERT INTO zajp_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Kipigiti kija Isaka kakala yasegele Beeli-Lahai-Loi na kachola kukala muisi ya Negebu. ");
INSERT INTO zajp_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isaka kakala yotembela mmigunda, na kipigiti cha ichungulo, viyenule gameso, kona ngamia wokwiza. ");
INSERT INTO zajp_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Na Lebeka kenula meso gake, na viyamonile Isaka, kahumuluka kulawa mngamia, ");
INSERT INTO zajp_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","kamuuza ija imtumigwa wa Ablaham, “Ija iyo munhu yalihi, yotembele mumgunda yokwiza kutuli tweye?” Ija imtumigwa kamulongela, “Ija iyo mndewa wangu.” Avo kasola kiziweziwe chake na kuigubika. ");
INSERT INTO zajp_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Avo ija imtumigwa kamulongela Isaka gose gayatendile. ");
INSERT INTO zajp_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaka kamwingiza Lebeka mdihema da Sala, mamaake. Kamsola Lebeka na kuwa mwehe wake, na kamnogela ng'hani. Avo Isaka kahozigwa umoyo sama ya ifa ya mamaake. ");
INSERT INTO zajp_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ablaham kasola mtwanzi iyagwe, twaga jake dikala dikemigwa Ketula. ");
INSERT INTO zajp_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketula kamulelela wana Ablaham, wakalile wokemigwa Zimulani, Yokshan, Medani, Midiani, Ishibaki, na Shua. ");
INSERT INTO zajp_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokshan kawalela Sheba na Dedani, na lukolo lwa Dedani lukala Waashulu, Waletushi, na Waleumi. ");
INSERT INTO zajp_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Na wanage Midiani wakala Efa, Efeli, Hanoki, Abida, na Elida. Wana wose wano wakala lukolo lwa Ketula. ");
INSERT INTO zajp_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ablaham kalonga kamba yahadanganhika, Isaka iyo yondayahale vinhu vose viyalinavo. ");
INSERT INTO zajp_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ila kipigiti Ablaham viyakalile hanadanganhika, kawagwelela nhunza wana iyawalelile na watwanzi zake wa kunze na kuwasegeza wachole kuulawilo wa zua kutali na mwanage Isaka. ");
INSERT INTO zajp_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ablaham kakala muulumwengu milao mia na malongo saba na tano. ");
INSERT INTO zajp_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ablaham kadanganhika kipigiti viyakalile m'vyele ng'hani, kakala na ulazi wa milao bwando. Kadanganhika na kuilumba hamoja na wahenga zake. ");
INSERT INTO zajp_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaka na Sumaili, wanage Ablaham, wamzika tataao muimhango ya Makipela, ili mwambu wa ulawilo wa zua wa Mamle mumgunda wa Efloni mwanage Zohali Muhiti, ");
INSERT INTO zajp_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","mgunda awo Ablaham uyaugulile kulawa ha Muhiti, baho hawazikigwe Ablaham na Sala mtwanzi wake. ");
INSERT INTO zajp_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ablaham viyadanganhike, Mulungu kammoteza Isaka mwanage, ayo yacholile kukala behi na sima da Beeli-Lahai-Loi. ");
INSERT INTO zajp_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Luno lulo lukolo lwa Sumaili, mwanage Ablaham, ayo Hajili, nyakadala wa Sala kulawa Misili, iyamulelele Ablaham. ");
INSERT INTO zajp_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Gano gago matwaga ga wana wa Sumaili, gandikigwe songela waichanduso kuvumbuka mbaka waikimambukizo. Nebayoti kakala waichanduso kuvumbuka ha Sumaili, abaho kavumbuka Kedali, Abidieli, na Mibusamu, ");
INSERT INTO zajp_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishima, Duma, Masa, ");
INSERT INTO zajp_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadi, Tema, Yetuli, Nafishi, na Kedema. ");
INSERT INTO zajp_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Wano wao wana longo dimwe na wabili wa Sumaili, viwambo vao na ng'hambi zao vitangigwa na matwaga gao. ");
INSERT INTO zajp_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Sumaili kakala muulumwengu milao mia na malongo madatu na saba. Kadanganhika na kuilumba hamoja na wahenga zake ");
INSERT INTO zajp_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Lukolo lwa Sumaili lukala lukalile hagatigati ya isi za Havila na Shuli, behibehi na mbaka ya Misili nzila ya kuchola Ashulu. Wakala wainegile na wana wayagwe wa Ablaham. ");
INSERT INTO zajp_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Luno lulo lukolo lwa Isaka mwanage Ablaham. ");
INSERT INTO zajp_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaka viyakalile na milao malongo mane, kamsola Lebeka mwanage Betueli, Mwalamu kulawa isi ya Padani-Alamu, lumbu jake Labani. ");
INSERT INTO zajp_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaka kamtambikila MNDEWA sama ya mtwanzi wake, kwavija Lebeka kakala bule sambo. Na MNDEWA kazibokela nhambiko zake, na mtwanzi wake kapata inda. ");
INSERT INTO zajp_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Kakala na ubasa muinda yake na kipigiti hawanavumbuka wakala wogomba muinda yake, avo kalonga, “Habali vinhu kamba vino vindawilile nie?” Avo kachola kumuuza MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","MNDEWA kamulongela, “Ndewa mbili za muinda yako, na wanhu wabili kulawa muinda yako woihasanya. Imwe kowa na mhiko kum'banza iyagwe, na ija imkulu komsang'hanikila ija imdodo.” ");
INSERT INTO zajp_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Kipigiti cha Lebeka kulela vikivikile, kalela wana ubasa wa kimbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Waichanduso kuvumbuka kakala mdung'hu, na lukuli lwake lose lukala na mvili, na wamgwelela twaga dikemigwa Esau. ");
INSERT INTO zajp_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Hakimambukizo, mdodo wake kavumbuka kuno mkono wake ugogile kisiginho cha Esau, avo wamgwelela twaga dikemigwa Yakobo. Isaka kakala na milao malongo sita kipigiti Lebeka viyawalelile. ");
INSERT INTO zajp_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Waja iwana wakula, Esau kawa msakaji galu wa wang'onyo, munhu yanogelwe kukala kumuhulo, ila Yakobo kakala munhu yaholile yanogelwe kukala hakae. ");
INSERT INTO zajp_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaka kamnogela Esau kwavija kakala yoja nyama zayakomile, ila Lebeka kanogelwa na Yakobo. ");
INSERT INTO zajp_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Zua dimwe Yakobo viyakalile yoteleka dengu, Esau kengila kulawa kusaka kuno yali na nzala ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esau kamulongela Yakobo, “Hima, nigwelele mandia higo madung'hu ndie, nie nofa nzala.” Kino kicho kilamso cha Esau kukemigwa Edomu, nhegulo yake ndung'hu. ");
INSERT INTO zajp_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobo kamulongela, “Tanhu uniguzile nie vija viulondigwa kwing'higwa gweye sama ya kuvumbuka wa ichanduso.” ");
INSERT INTO zajp_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau kalonga, “Lola, nie na mmabehi kudanganhika, vija vinilondigwa kwing'higwa sama ya kuvumbuka wa ichanduso novitendela choni?” ");
INSERT INTO zajp_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakobo kamulongela, “Tanhu niduilile kamba konigwelela vija viulondigwa kwing'higwa sama ya kuvumbuka wa ichanduso.” Esau kaiduila na kumgwelela Yakobo vija voyolondigwa kwing'higwa sama ya kuvumbuka wa ichanduso. ");
INSERT INTO zajp_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yakobo kamgwelela Esau mkate na dengu, kaja na kung'wa, abaho kenuka kasegela. Vino vivo Esau viyazabuze vija viyalondigwe kwing'higwa sama ya kuvumbuka wa ichanduso. ");
INSERT INTO zajp_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Abaho kulawilila nzala iyagwe muisi ija, mbali na ija ikalile kipigiti cha Ablaham. Na Isaka kachola ha Abimeleki mndewa wa Wafilisti ako Gelali. ");
INSERT INTO zajp_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","MNDEWA kamulawilila Isaka na kamulongela, “Sambiuchole Misili, kala muisi yondanikulongele. ");
INSERT INTO zajp_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kala hano kamba muhenza, nie nowa hamoja na gweye na kukumoteza. Isi zino nokugwelela gweye na lukolo lwako. Nokigoga kilagano kiniilagane na tataako Ablaham. ");
INSERT INTO zajp_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Kweli nokumoteza na kulutenda lukolo lwako longezeke luwe kamba nhondo za kuulanga. Na isi zino zose nolugwelela lukolo lwako. Na kubitila lukolo lwako ndewa zose za ulumwengu zomotezwa. ");
INSERT INTO zajp_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nokumoteza kwavija Ablaham kanitegeleza nie na kugagoga malagizo gangu gose na kuzigoga ndagizi zangu zose.” ");
INSERT INTO zajp_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Avo Isaka kakala ako Gelali. ");
INSERT INTO zajp_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Wambigalo wa isi ija viwamuuzile mbuli za mtwanzi wake, heyo kalonga, “Ino lumbu jangu.” Kwavija kadumba kulonga “Ino mtwanzi wangu,” kwavija kagiza kamba wanhu wa isi ija womkoma na kumsola Lebeka, kwavija Lebeka kakala yanogile ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaka viyakalile kuja mkipigiti kitali, Abimeleki mndewa wa Wafilisti kasungulila hasi hadizonzo, kamona Isaka yomkumbatila Lebeka. ");
INSERT INTO zajp_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimeleki kamgalila usenga Isaka na kulonga, “Kweli ino mtwanzi wako, habali kulonga ino lumbu jako?” Isaka kamwidika kalonga, “Kwavija nigelegeza kamba nihadanganhike kamba nihalongile ino mtwanzi wangu.” ");
INSERT INTO zajp_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleki kalonga, “Mbuli yaki ino yuututendele? Munhu imwe yahawasile na mtwanzi wako, na gweye uhatubakile tweye tose kilozo kino.” ");
INSERT INTO zajp_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Avo Abimeleki kawazuma wanhu wose, yolonga, “Munhu yoyose yondayamtendele gehile munhu ino ama mtwanzi wake, kokomigwa.” ");
INSERT INTO zajp_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaka kahanda mbeyu muisi ija, na mulao uja kahuna mianza mia ya mbeyu zayahandile, kwavija MNDEWA kammoteza. ");
INSERT INTO zajp_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isaka kawa mgoli, na ugoli wake ugendelela kukula, na kawa mgoli mkulu ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Kakala na madale bwando ga ng'hondolo na ng'ombe, kakala na watumigwa bwando, avo Wafilisti wamonela migongo. ");
INSERT INTO zajp_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Avo Wafilisti wagasila gamasima gose gawahimbile watumigwa wa Ablaham tataake Isaka, kipigiti viyakalile mgima. ");
INSERT INTO zajp_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimeleki kamulongela Isaka, “Uhalawe muisi yetu, kwavija gweye sambi kuna mhiko kubanza tweye.” ");
INSERT INTO zajp_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Avo Isaka kasegela hiko, na kwika ng'hambi Mdibonde da Gelali, na kakala hiko. ");
INSERT INTO zajp_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaka kagahimbula kabili gaja igamasima ga mazi gakalile gahimbigwe mkipigiti cha tataake Ablahamu, kwavija Wafilisti wakala wagasile Ablahamu viyeshile kudanganhika, na kagagwelela matwaga gagaja gayagagwelele tataake. ");
INSERT INTO zajp_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Watumigwa wa Isaka wahimba sima mdibonde na wapata mazi gaholile. ");
INSERT INTO zajp_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Wachunga ng'hondolo wa haja Gelali wagomba na wachunga ng'hondolo wa Isaka walonga, “Mazi gano getu tweye.” Avo Isaka kadikema sima dija twaga dikemigwa “Ezeki.” ");
INSERT INTO zajp_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Abaho watumigwa wa Isaka wahimba sima da ikabili, na dino vivija wadigombela, Isaka kadikema twaga jake “Sitna.” ");
INSERT INTO zajp_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Abaho Isaka kachola hanhu hayagwe na kuhimba sima da ikadatu. Sima dino dikala bule ngomba, avo kadigwaa twaga dikemigwa “Lehoboti.” Isaka kalonga, “MNDEWA sambi katugwelela ulegeho wa kukala muisi ino, na tweye tokongezeka.” ");
INSERT INTO zajp_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kulawa haja Isaka kachola Beeli-Sheba. ");
INSERT INTO zajp_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ikilo iija MNDEWA kamulawila Isaka na kumulongela, “Nie iyo Mulungu wa tataako Ablaham. Sambiudumbe, kwavija nie na hamoja na gweye. Nokumoteza na kulutenda lukolo lwako longezeke, sama ya Ablaham mtumigwa wangu.” ");
INSERT INTO zajp_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Avo Isaka kazenga kilingo cha kulavila nhosa na kamtambikila MNDEWA haja. Kaiwamba hema yake, na watumigwa wake wahimba sima diyagwe. ");
INSERT INTO zajp_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Zua dimwe Mndewa Abimeleki kulawa Gelali hamoja na Ahuzati mulonga masala wake na Fikoli, mkulu wa asikali zake, wamcholela Isaka. ");
INSERT INTO zajp_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Avo Isaka kawauza, “Habali mwiza hano hamwangu kuno mnihila nie, na kumwenu mniwinga?” ");
INSERT INTO zajp_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Wamwidika walonga, “Tona kamba MNDEWA ka hamoja na gweye, avo togelegeza twike kiduilo na gweye. Tutende lagano na gweye, ");
INSERT INTO zajp_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","giladi sambiututende tweye gehile, kamba tweye vitulekile kukutendela gehile. Hatukutendile kinhu kihile. Ila tukutendela ganogile. Nakukuleka uchole mmulegeho, lola sambi MNDEWA viyakumoteze.” ");
INSERT INTO zajp_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Avo Isaka kawatendela lusona, na hewo waja na kung'wa hamoja. ");
INSERT INTO zajp_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Imitondo ng'hani zua da ikabili waiduilila. Abaho Isaka kawaleka wachole, na hewo wamuleka mmulegeho. ");
INSERT INTO zajp_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Zua didija watumigwa wa Isaka weza na kumulongela mbuli za sima diwahimbile, walonga, “Tupata mazi.” ");
INSERT INTO zajp_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Avo Isaka kadikema sima dija “Shiba.” Vino vivo wambo da Beeli-Sheba vidipatile twaga jake. ");
INSERT INTO zajp_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau viyavikize milao malongo mane, kasola watwanzi wabili Wahiti, Yudisi mwanage Beeli, na Basemati mwanage Eloni. ");
INSERT INTO zajp_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ila watwanzi wano wa Esau waitenda mioyo ya Isaka na Lebeka kuwa na giogio. ");
INSERT INTO zajp_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaka viyakalile m'vyele na meso gake vigasongile kuvulala, kamkema Esau, mwanage mkulu, kamulongela, “Mwanangu.” Na heyo kedika. “Ona, tata.” ");
INSERT INTO zajp_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaka kalonga, “Lola, nie na m'vyele, na zua jangu da kudanganhika siditanga. ");
INSERT INTO zajp_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Avo sola via vako va kusakila, mhinde zako na misale yako, genda kumuhulo ukanisakile mng'onyo. ");
INSERT INTO zajp_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Abaho unitelekele mandia galimwilile gaja ganilondaga, na ungalile. Nihesha kuja, nikumoteze ning'hali sinadanganhika.” ");
INSERT INTO zajp_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Kipigiti Isaka viyakalile yomulongela Esau, Lebeka kakala yotegeleza. Avo Esau viyacholile kumuhulo kusaka, ");
INSERT INTO zajp_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Lebeka kamulongela Yakobo mwanage, “Tegeleza, nimuhulika tataako yomulongela Esau, ");
INSERT INTO zajp_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Nigalile mng'onyo unitelekele. Nihesha kuja nikumoteze haulongozi wa MNDEWA ning'hali sinadanganhika.’ ");
INSERT INTO zajp_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Avo mwanangu, nitegeleze, tenda kija kinikulongela. ");
INSERT INTO zajp_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Genda mdidale da menhe ungalile wana menhe wabili wanonile, avo nomtendela tataako mandia galimwilile ng'hani gaja goyolondaga. ");
INSERT INTO zajp_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Abaho umgalile tataako yaje, giladi yakumoteze yang'hali hanadanganhika.” ");
INSERT INTO zajp_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Avo Yakobo kamulongela Lebeka mamaake, “Lola, mkulu wangu Esau lukuli lwake luna mvili, na lukuli lwangu lwabule mvili. ");
INSERT INTO zajp_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kamba tataangu yahanikwasa na kuvitanga kamba nom'vwizila, choni chondakilawilile? Nokona noigalila mwenyego ndukumiza na sio motelo.” ");
INSERT INTO zajp_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mamaake kamulongela, “Mwanangu, leka ndukumiza imhate nie. Tenda vinikulongela, genda ungalile.” ");
INSERT INTO zajp_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Avo Yakobo kachola, kasola iwana menhe wabili kamgalila mamaake, na mamaake kateleka mandia galimwilile kamba viyolondaga tataake. ");
INSERT INTO zajp_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Abaho Lebeka kasola vivalo vinogile va Esau, mwanage mkulu, vivalo viyakalile navo mng'anda, na kam'vaza Yakobo, mwanage mdodo. ");
INSERT INTO zajp_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Vivija Lebeka kamfunga Yakobo mikwembe ya menhe mmakono gake na hanhu halibule mvili msingo yake. ");
INSERT INTO zajp_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Abaho kamgwelela mandia galimwilile, hamoja na mkate yautendile. ");
INSERT INTO zajp_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Avo Yakobo kamcholela tataake na kumulongela, “Tataangu!” Na heyo kamwidika, “Ona nie hano. Gweye iyo mwanangu yalihi?” ");
INSERT INTO zajp_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo kamulongela, “Nie iyo mwanago mkulu Esau, nitenda kamba vuundagize. Avo gandamuka ukale uje mandia ganikugalile, abaho unimoteze.” ");
INSERT INTO zajp_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ila Isaka kamulongela mwanage, “Mwanangu, vilihi kupata himahima vino?” Yakobo kalonga, “Kwavija MNDEWA Mulungu wako iyo yanhazile kupata himahima.” ");
INSERT INTO zajp_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Avo Isaka kamulongela Yakobo, “Kwenhuka behi nikubabase mwanangu, nivitange kamba kweli iyo mwanangu Esau ama sio.” ");
INSERT INTO zajp_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobo kamkwenhukila tataake Isaka, Isaka kam'babasa na kalonga, “Dizwi da Yakobo, ila makono ga Esau.” ");
INSERT INTO zajp_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Hamtangile kamba kakala Yakobo, kwavija makono gake gakala na mvili kamba za Esau. Avo Isaka kammoteza Yakobo. ");
INSERT INTO zajp_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isaka kamuuza kabili, “Gweye iyo kweli mwanangu Esau?” Kamwidika “Ona.” ");
INSERT INTO zajp_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Avo Isaka kalonga, “Mwanangu, nigalile nyama yuupatile. Nihesha kuja, nikumoteze.” Avo Yakobo kamgalila tataake mandia, na heyo kaja. Vivija kamgalila divai kaing'wa. ");
INSERT INTO zajp_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Abaho Isaka kamulongela Yakobo, “Kwenhuka behi uninonele, mwanangu.” ");
INSERT INTO zajp_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Avo kamkwenhukila na kumnonela, Isaka viyahulike mnung'ho wa vivalo vake, kammoteza, na kulonga, “Mnung'ho wa mwanangu ulinga kamba mnung'ho wa mgunda yaaumoteze MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mulungu yakugwelele tungwe kulawa kuulanga na ugoli wose wa isi, Mulungu yakugwelele vakuja bwando na divai bwando. ");
INSERT INTO zajp_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ndewa zose ziwe watumigwa zako, na wanhu wa namna zose wainamile haulongozi wako. Uwe mtawala wa ndugu zako wose, na ndugu zako wainamile haulongozi wako. Munhu yondayakudukumize yadukumizwe heyo, na yondayakumoteze yamotezwe.” ");
INSERT INTO zajp_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaka viyeshile kummoteza Yakobo, na Yakobo viyakalile yolawa haulongozi wa tataake, Esau kabwela kulawa kusaka. ");
INSERT INTO zajp_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Na heyo vivija kasasala mandia galimwilile na kumgalila tataake. Abaho kalonga, “Tataangu, gandamuka ukale uje mandia ganikugalile, giladi unimoteze.” ");
INSERT INTO zajp_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tataake kamuuza, “Gweye iyo yalihi?” Esau kalonga “Nie iyo mwanago imkulu, Esau.” ");
INSERT INTO zajp_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaka kagudema ng'hani, na kalonga, “Ija iyo yalihi yangalile mandia nie? Na nie nija nisha kipigiti gweye hunakwiza. Nimgwelela heyo motelo, na kweli kamotezwa.” ");
INSERT INTO zajp_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau viyazihulike mbuli za tataake, kalila mdizwi kulu kuno yamemile usungu, na kumulongela tataake, “Nimoteze na nie, tataangu!” ");
INSERT INTO zajp_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ila Isaka kalonga, “Mdodo wako katenda uzenzeleganye na kasola motelo zako.” ");
INSERT INTO zajp_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau kalonga, “Kanibulunya mianza mibili ino. Kileka mana twaga jake dikemigwa Yakobo. Kasola hanhu hangu ha kuvumbuka wa ichanduso, na sambi kasola motelo zangu?” Abaho kamuuza tataake, “Hunikile motelo yoyose?” ");
INSERT INTO zajp_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaka kamulongela Esau, “Nimtenda Yakobo yawe mndewa wako, na nimgwelela ndugu zake kuwa watumigwa zake. Nimgwelela ngano na divai, nikugwelele choni, mwanangu?” ");
INSERT INTO zajp_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau kamulongela tataake, “Tata, kuna motelo imwe iiyeka? Nimoteze na nie, tata!” Abaho Esau kasonga kulila na dizwi kulu. ");
INSERT INTO zajp_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Abaho, tataake kamulongela, “Lola, ukazi wako wowa kutali na ugoli wa isi, Kutali na tungwe dilawa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kokala mkutamanila zele jako, Kowa mtumigwa wa mdodo wako. Uhamdulukila, Koisegeza kulawa muutawala wake.” ");
INSERT INTO zajp_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau kamwihila Yakobo kwavija tataake kammoteza. Esau kasonga kugelegeza mmoyo wake, yolonga, “Kipigiti cha kumulilila tataangu kikwenhuka abaho nomkoma mdodo wangu Yakobo.” ");
INSERT INTO zajp_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Lebeka viyalongeligwe gaja gayalongile mwanage mkulu Esau, katuma usenga ha mwanage mdodo Yakobo, yomulongela, “Mkulu wako Esau kouhoza moyo wake mkugelegeza kukukoma. ");
INSERT INTO zajp_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Avo mwanangu, tenda gano ganikulongela, hima kimbilila ha mjombaako Labani ako Halani. ");
INSERT INTO zajp_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Kala kumwake mkipigiti kidodo, mbaka lusango lwa ndugu yako vondalumale, ");
INSERT INTO zajp_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","na kaisemwa kija chuumtendile. Abaho nomtuma munhu yakubweze. Habali niwagize wanangu wose wabili mdizua dimwe?” ");
INSERT INTO zajp_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Lebeka kamulongela Isaka, nidonhezwa ng'hani na watwanzi wano Wahiti wa Esau. Kamba Yakobo yahasola mtwanzi imwe kulawa mwa watwanzi wa isi ino wa Kihiti kamba wano, vinoga nie nidanganhike. ");
INSERT INTO zajp_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Avo Isaka kamkema Yakobo, kammoteza, na kumulagiza, yolonga, “Sambiusole mtwanzi yoyose Mkanaani. ");
INSERT INTO zajp_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Hima genda Padani-Alamu, mng'anda ya Betueli tata wa mamaako, ukasole mtwanzi kulawa kwa wana wa Labani mjombaako. ");
INSERT INTO zajp_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Mulungu Mwene Mhiko yakumoteze giladi yakugwelele wana bwando. Lukolo lwako longezeke giladi uwe tata wa wanhu bwando. ");
INSERT INTO zajp_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Mulungu yakugwelele gweye na lukolo lwako motelo ziyagweleligwe Ablaham, giladi upate kuitawala isi yuukala sambi kamba muhenza, isi Mulungu iyamgwelele Ablaham.” ");
INSERT INTO zajp_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Abaho, Isaka kamtuma Yakobo yachole Padani-Alamu ha Labani mwanage Betueli Mwalamu, lumbu ja Lebeka, ayo yakalile mamaao Yakobo na Esau. ");
INSERT INTO zajp_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau kavitanga kamba Isaka kammoteza Yakobo na kamtuma yachole Padani-Alamu yakasole mtwanzi kuja. Na viyakalile yommoteza kamulagiza yolonga, “Sambiusole mtwanzi kulawa muisi ya Kanaani.” ");
INSERT INTO zajp_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Na vivija kavitanga kamba, Yakobo kawatogolela tataake na mamaake na kachola Padani-Alamu. ");
INSERT INTO zajp_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Avo Esau kavitanga kamba tataake Isaka hanogelwe na watwanzi wa Kanaani. ");
INSERT INTO zajp_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Esau kachola ha Sumaili mwanage Ablaham, na kamsola Mahalati mwanage Sumaili, ayo yakalile lumbu ja Nebayoti, na kongeza hamoja na iwatwanzi iyakalile nao. ");
INSERT INTO zajp_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakobo kasegela Beeli-Sheba kachola Halani. ");
INSERT INTO zajp_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Viivikile ichungulo kavika hanhu hanogile ha kwika ng'hambi na kuhumula, kwavija zua dikala diswile na kilo kingila. Kasola dibwe dimwe dikalile haja na kudika hasi ya ditwi jake na kawasa. ");
INSERT INTO zajp_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Kalota nzozi, kona ngwandala imile kulawa muisi mbaka kuulanga, na wasenga wa Mulungu wa kuulanga wokwela na kuhumuluka mngwandala ija. ");
INSERT INTO zajp_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","MNDEWA kema hamgwazo wake, na kulonga, “Nie iyo MNDEWA, Mulungu wa muhenga wako Ablaham, na Mulungu wa Isaka. Isi ino yuuiwasile, nokugwelela gweye na lukolo lwako. ");
INSERT INTO zajp_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Lukolo lwako lowa kamba timbwisi da isi, na mokwenela kulawa ng'ambu ya ulawilo wa zua na uswelo wa zua, kaskazi na kusi. Wanhu wose muisi womotezwa kubitila gweye na lukolo lwako. ");
INSERT INTO zajp_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nie na hamoja na gweye na nokwimiliza kokose kondauchole, na nokubweza kabili muisi ino. Sikuleka mbaka vondanikitende kilagano kiniilagane na gweye.” ");
INSERT INTO zajp_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Abaho, Yakobo kalamuka kulawa muutulo na kulonga, “Kweli MNDEWA ka hanhu hano, na nie nikala sivimanyile!” ");
INSERT INTO zajp_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yakobo kadumba na kulonga, “Hanhu hano hodumbiza ng'hani, hano baho hana ing'anda ya Mulungu, na luno lulo lwivi lwa kuulanga.” ");
INSERT INTO zajp_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Imitondo ng'hani zua da ikabili Yakobo viyalamuke, kasola dibwe dikalile hasi ya ditwi jake, kadisimika kamba nguzo ya lukumbuso na uchana yake kadigidila mavuta ga mzaituni na kudibagula sama ya Mulungu. ");
INSERT INTO zajp_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Hanhu haja kahakema Beteli. ila twaga da wambo dija haichanduso dikala dikemigwa Luzi. ");
INSERT INTO zajp_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Abaho Yakobo katenda kiduilo, yolonga, “Kamba Mulungu uhawa hamoja na nie na kunimiliza nie mmwanza wangu, na kamba uhanigwelela mandia na vivalo, ");
INSERT INTO zajp_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","na kamba nahabwela ukae ha tataangu nili na upile, avo kowa MNDEWA Mulungu wangu. ");
INSERT INTO zajp_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Na dibwe dino dinisimike kamba nguzo, dowa ng'anda ya Mulungu, na vinhu vose vondaunigwelele nie nokulavila gweye zaka.” ");
INSERT INTO zajp_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakobo kagendelela na mwanza wake na kavika muisi ya wanhu wa ulawilo wa zua. ");
INSERT INTO zajp_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Hiko kona sima mumgunda, na madale madatu ga ng'hondolo gahumula hamgwazo wa idisima, kwavija madale gakala gong'wezigwa mazi kulawa mdisima dija. Na dibwe dikalile digubike idisima dija dikala kulu. ");
INSERT INTO zajp_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ikala nzoela ya wachunga kuibeta mbaka kipigiti madale gose ga ng'hondolo vondagaiduganye, avo wachunga ng'hondolo wadibimbilisa idibwe kulawa hamulomo wa idisima, na kuwang'weza iwang'hondolo. Abaho wadibweza idibwe haja hadikalile hana umulomo wa idisima. ");
INSERT INTO zajp_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakobo kawauza iwachunga ng'hondolo, “Ndugu zangu, mweye molawa kwahi?” Wedika, “Tweye tolawa Halani.” ");
INSERT INTO zajp_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Kawauza, “Mumtanga Labani mzukulu wa Naholi?” Wedika, “Tumtanga.” ");
INSERT INTO zajp_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakobo kawauza, yolonga, “Mpile?” Wedika, “Mpile.” Walonga, “Lola, mwanage ija haja kokwiza na dale jake da ng'hondolo.” ");
INSERT INTO zajp_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakobo kawalongela, “Loleni, zua hadinahonga, kipigiti cha ng'hondolo kuwasa hakinavika, wang'wezeni mazi iwang'hondolo na muwagale wakaje.” ");
INSERT INTO zajp_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Avo hewo walonga, “Hatudaha kutenda avo, mbaka madale gose vondagaiduganye hamoja, na idibwe vondadibimbiliswe kulawa haumulomo wa idisima, abaho towang'weza mazi iwang'hondolo.” ");
INSERT INTO zajp_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Kipigiti Yakobo viyakalile yogendelela kuwalongela iwachunga, Laheli keza na ng'hondolo wa tataake, kwavija heyo kakala yowachunga. ");
INSERT INTO zajp_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakobo viyamonile Laheli mwanage Labani lumbu ja mamaake, na viyadiwene dale da ng'hondolo wa Labani, kachola kudibimbilisa idibwe kulawa haumulomo wa idisima, na kuwang'weza ng'hondolo wa mjombaake. ");
INSERT INTO zajp_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Abaho, Yakobo kamnonela Laheli, na kusonga kulila na dizwi kulu, ");
INSERT INTO zajp_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","na kumpetela kamba, heyo kakala ndugu wa tataake, mwanage Lebeka. Avo Laheli kakimbilila ukae kachola kumpetela tataake. ");
INSERT INTO zajp_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labani viyahulike mbuli za Yakobo mwana wa lumbu jake, kamkimbilila kam'bokela, kamkumbatila na kumnonela, abaho wachola ukae yake. Yakobo kampetela Labani mbuli zose zimulawilile. ");
INSERT INTO zajp_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Abaho Labani kamulongela, “Kweli gweye nyama yangu na mulopa wangu.” Yakobo kakala na heyo mulenge umwe. ");
INSERT INTO zajp_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labani kamulongela Yakobo, “Kwavija gweye kwa ndugu yangu, havilumbile unisang'hanikile bule. Nongela choni chuulonda kiwe kitumetume chako.” ");
INSERT INTO zajp_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labani kakala na wana wakitwanzi wabili, mkulu kokemigwa Lea na mdodo kokemigwa Laheli. ");
INSERT INTO zajp_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea kakala na meso gavulale, ila Laheli kakala yanogile mkiwiliwili na mkihanga. ");
INSERT INTO zajp_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo kanogelwa na Laheli, avo kamulongela Labani, “Nokusang'hanikila milao saba, sama ya kumsola mwanago mdodo Laheli.” ");
INSERT INTO zajp_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani kamulongela, “Vinoga nikugwelele gweye umsole sio munhu iyagwe yoyose. Kala hano hamoja na nie.” ");
INSERT INTO zajp_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Avo Yakobo kamsang'hanikila milao saba sama ya kumpata Laheli, Yakobo kachona kipigiti kija kiguhi kwavija viyanogelwe na Laheli. ");
INSERT INTO zajp_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Abaho Yakobo kamulongela Labani, “Nigwelele mtwanzi wangu, kipigiti changu kimala, na nolonda niwase nayo.” ");
INSERT INTO zajp_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Avo Labani kawakema hamoja wanhu wose wa hanhu haja na kutenda lusona lwa zengele. ");
INSERT INTO zajp_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Viivikile ikilo, Labani kamsola Lea mwanage na kumgwelela Yakobo, na heyo kawasa nayo. ");
INSERT INTO zajp_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Labani kamulava Zilpa nyakadala wake yamsang'hanikile Lea. ");
INSERT INTO zajp_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Viivikile imitondo, kumbe kakala Lea! Avo Yakobo kamulongela Labani, “Choni kino kiunitendele?” Yakobo kamuuza Labani. “Nikusang'hanikila milao saba sama ya Laheli. Habali univwizile?” ");
INSERT INTO zajp_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani kamulongela, “Ino sio nzoela yetu muisi yetu, yalongole kusoligwa mdodo abaho mkulu. ");
INSERT INTO zajp_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mambukiza mazua gano saba ga lusona lwa zengele lwa ino imkulu, abaho nokugwelela Laheli kamba uhanisang'hanikila milao saba iyagwe.” ");
INSERT INTO zajp_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakobo katogola, kamambukiza mazua saba ga Lea, abaho Labani kamgwelela Laheli yawe mtwanzi wake. ");
INSERT INTO zajp_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labani kamulava Bilha nyakadala wake yamsang'hanikile Laheli. ");
INSERT INTO zajp_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Avo vivija Yakobo kawasa na Laheli, na kamnogela ng'hani Laheli kubanza Lea. Yakobo kamsang'hanikila Labani milao saba iyagwe. ");
INSERT INTO zajp_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","MNDEWA viyawene kamba Lea hanogeligwe ng'hani, kamfungula inda yake kamgwelela wana, ila Laheli kakala bule sambo. ");
INSERT INTO zajp_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea kapata inda na kamulela mwana mbigalo, kamgwaa twaga dikemigwa Lubeni, kwavija kalonga, “MNDEWA kawona mgayo wangu. Kweli mbigalo wangu sambi konogelwa na nie.” ");
INSERT INTO zajp_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lea kapata inda kabili na kamulela mwana mbigalo, kamgwaa twaga dikemigwa Simioni, kwavija kalonga, “MNDEWA kahulika kamba nie sinogelwe, avo kanigwelela mwana iyagwe.” ");
INSERT INTO zajp_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lea kapata inda iyagwe na kumulela mwana mbigalo, kamgwaa twaga dikemigwa Lawi, kwavija kalonga, “Sambi mbigalo wangu kowa behi ng'hani na nie, kwavija nimulelela wana mbigalo wadatu.” ");
INSERT INTO zajp_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lea kapata inda iyagwe na kumulela mwana mbigalo, kamgwaa twaga dikemigwa Yuda, kwavija kalonga, “Mwanza uno nomuyenzi MNDEWA.” Abaho Lea kema kulela. ");
INSERT INTO zajp_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Laheli viyonile kamba hanamulelela wana Yakobo, kamonela migongo lumbu jake, na kumulongela Yakobo. “Nigwelele wana, kamba si hivo, nodanganhika!” ");
INSERT INTO zajp_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakobo kamonela lusango Laheli, kamulongela, “Nie iyo Mulungu, yakutendile gweye uwebule wana?” ");
INSERT INTO zajp_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Laheli kamulongela, “Msole nyakadala wangu Bilha, uwase nayo yanilelele wana. Kubitila heyo na nie vivija nowa mama.” ");
INSERT INTO zajp_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Avo Laheli kamgwelela Yakobo Bilha nyakadala wake yawe mtwanzi wake, na heyo kawasa nayo. ");
INSERT INTO zajp_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Na Bilha kapata inda na kumulelela Yakobo mwana mbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Abaho Laheli kalonga, “Mulungu kalamula na kunyonela nie bazi, kazihulika nhambiko zangu na kunigwelela nie mwana mbigalo.” Avo kamkema twaga jake Dani. ");
INSERT INTO zajp_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha nyakadala wa Laheli kapata inda kabili na kamulelela Yakobo mwana mbigalo wa ikabili. ");
INSERT INTO zajp_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Abaho Laheli kalonga, “Nigomba ng'hani na lumbu jangu, mbaka nihuma.” Avo kamgwaa twaga dikemigwa Naftali. ");
INSERT INTO zajp_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea viyonile kamba kema kulela, kamsola Zilpa nyakadala wake na kumgwelela Yakobo yawe mtwanzi wake. ");
INSERT INTO zajp_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpa nyakadala wa Lea kamulelela Yakobo mwana mbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Abaho, Lea kalonga, “Mhata mhome.” Avo kamkema twaga jake Gadi. ");
INSERT INTO zajp_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpa nyakadala wa Lea kamulelela Yakobo mwana mbigalo wa ikabili. ");
INSERT INTO zajp_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea kalonga, “Nodeng'ha ng'hani, watwanzi wong'hema nie ndeng'ha.” Avo kamkema twaga jake Asheli. ");
INSERT INTO zajp_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Kipigiti cha kuhuna ngano, Lubeni kachola kumgunda na kubawa dudai, kamgalila mamaake Lea. Laheli kamulongela Lea, “Ngwelela dudai kidogo za mwanago.” ");
INSERT INTO zajp_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ila Lea kamulongela, “Kokwagiza mbuli ndodo kunisolela mbigalo wangu? Sambi kolonda kusola dudai za mwanangu.” Laheli kalonga, “Kamba uhanigwelela dudai za mwanago, ikilo ya lelo Yakobo kowasa na gweye.” ");
INSERT INTO zajp_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Avo ichungulo ija Yakobo viyabwelile kulawa kumgunda, Lea kalawa kachola kum'bokela abaho kamulongela, “Kolondigwa wize kuwasa na nie ikilo ya lelo, kwavija nikulihila dudai za mwanangu.” Avo ikilo ija kawasa na Lea. ");
INSERT INTO zajp_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Mulungu kahulika nhambiko ya Lea, na Lea kapata inda na kamulelela Yakobo mwana mbigalo wa tano. ");
INSERT INTO zajp_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea kalonga, “Mulungu kanigwelela nhunza kwavija nimgwelela mbigalo wangu nyakadala wangu.” Avo Lea kamgwelela imwana twaga dikemigwa Isakali. ");
INSERT INTO zajp_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea kapata inda kabili na kamulelela Yakobo mwana mbigalo wa sita. ");
INSERT INTO zajp_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Abaho Lea kalonga, “Mulungu kanigwelela nhunza inogile. Sambi mbigalo wangu konihishimila, kwavija nimulelela mwana mbigalo wa sita.” Avo kamgwelela twaga dikemigwa Zabuloni. ");
INSERT INTO zajp_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Abaho kamulela mwana mtwanzi, na kamkema twaga jake Dina. ");
INSERT INTO zajp_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Abaho Mulungu kamgelegeza Laheli, kazihulika nhambiko zake na kuifungula inda yake. ");
INSERT INTO zajp_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Laheli kapata inda na kalela mwana mbigalo, na kulonga, “Mulungu kanisegezela kinyala changu.” ");
INSERT INTO zajp_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Kamgwelela twaga dikemigwa Usufu, na kulonga, “MNDEWA kanigwelela mwana iyagwe mbigalo.” ");
INSERT INTO zajp_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Laheli viyamulelile Usufu, Yakobo kamulongela Labani, “Nileke nibwele ukae muisi yangu mwenyego. ");
INSERT INTO zajp_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Nigwelele watwanzi zangu na wanangu iniwapatile mkukusang'hanikila, nichole nao, kuvitanga vinikusang'hanikile ng'hani.” ");
INSERT INTO zajp_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labani kamulongela, “Nitegeleze, nie nilagula na kuvitanga kamba MNDEWA kanimoteza nie sama yako gweye. ");
INSERT INTO zajp_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Longa kitumetume chako nikulihe.” ");
INSERT INTO zajp_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobo kalonga, “Gweye mwenyego kuvitanga vija vinikusang'hanikile, na vija madale gako vugakalile hasi yangu. ");
INSERT INTO zajp_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kukala na mali kidogo kipigiti sinakwiza, ila sambi mali gako gongezeka ng'hani. MNDEWA kakumoteza gweye kubitila vinhu vose vinitendile nie. Ila sambi kicho kipigiti changu cha kutenda mbuli zangu mwenyego.” ");
INSERT INTO zajp_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labani kamuuza, “Nikugwelele choni?” Yakobo kalonga, “Sambiunigwelele kinhu chochose, ila kamba uhanitendela nie mbuli ino, nogendelela kukuchungila madale ga ng'hondolo zako. ");
INSERT INTO zajp_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Lelo leka nibite mmadale gako na kusegeza wana ng'hondolo wali na midewa ama minyela, wana menhe wali na midewa ama minyela, na wana ng'hondolo wose watitu. Unigwelele nie kamba kitumetume changu. ");
INSERT INTO zajp_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Mazua ga hamwande kovitanga kamba nie nabule uzenzeleganye, ahaja vondawize kulola kitumetume changu chuunilihile. Kamba uhavika menhe yalibule minyela ama midewa ama kamba hana ng'hondolo yalibule utitu mdidale jangu basi hiyo kebigwa.” ");
INSERT INTO zajp_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani kalonga, “Vinoga, na iwe kamba vuulongile.” ");
INSERT INTO zajp_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Avo zua didija Labani kawasegeza waja iwamenhe songolomi na mabogwa wali na minyela na midewa, na wose wali na uzelu na wana ng'hondolo wose wali watitu, na kuwagwelela wanage. ");
INSERT INTO zajp_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Labani kachola mwanza wa mazua madatu kulawa hayakalile Yakobo, kipigiti Yakobo viyakalile yogendelela kuchunga ng'hondolo wa Labani wasigale. ");
INSERT INTO zajp_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Abaho Yakobo kasola mango mbisi kulawa mmibiki ya mulubuna, mulozi, na mwalamoni, kaziyua na kutenda mindandu mzimango zija mkuziyua vigome vake na katenda uzelu ukalile mgati ya izimango woneke. ");
INSERT INTO zajp_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Abaho kazisimika zija zimango ziyaziyuile kila hanhu ha kung'wela mazi ng'hondolo na menhe, giladi zoneke dimwe kwa dimwe haulongozi wa iwang'hondolo waheza kung'wa mazi, kipigiti ng'hondolo wahawa mkipigiti cha kukweligwa. ");
INSERT INTO zajp_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Na viwaikwelile haulongozi wa zija izimango, walela wana wali na minhongo mizelu, minyela, na midewa. ");
INSERT INTO zajp_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakobo kawabagula waja iwana ng'hondolo kulawa mdidale da Labani, ila mkipigiti cha kukweligwa kawatenda ng'hondolo wasigale wawalole ng'hondolo wa Labani awo wakalile watitu na wali na minhongo. Vino vivo Yakobo viyatendile dale jake jongezeke. ");
INSERT INTO zajp_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kipigiti wang'onyo walibule nyondenyonde viwavikile kipigiti cha kukweligwa, Yakobo kazika zija zimango kila hanhu ha kung'wela mazi haulongozi wa iwang'onyo, giladi waikwele haulongozi wa izimango. ");
INSERT INTO zajp_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ila kamba waja iwang'onyo wakala nyondenyonde, kazisegeza zija izimango haja. Avo wang'onyo wali nyondenyonde wakala wa Labani, na waja walibule nyondenyonde wakala wa Yakobo. ");
INSERT INTO zajp_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mkilamso kino Yakobo keza kuwa mgoli ng'hani. Kakala na madale makulu ga ng'hondolo, na menhe, nyakadala, ngamia, na mhunda. ");
INSERT INTO zajp_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakobo kawahulika walamu zake wana wa Labani wolonga, “Yakobo kasola vinhu vose vikalile va tataetu. Ugoli wake wose ulawa m'vinhu vayakalile navo tataetu.” ");
INSERT INTO zajp_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakobo kavitanga kamba Labani hanogelwe na heyo kamba viikalile haichanduso. ");
INSERT INTO zajp_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Abaho MNDEWA kamulongela Yakobo, “Bwela muisi ya wahenga zako na ndugu zako, nie nowa hamoja na gweye.” ");
INSERT INTO zajp_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Avo Yakobo katuma usenga kuwakema Laheli na Lea, weze kumgunda kuyakalile yochunga ng'hondolo zake. ");
INSERT INTO zajp_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Yakobo kawalongela, “Nokona kamba tataenu hanogelwa na nie kamba viikalile haichanduso, ila Mulungu wa tataangu ka hamoja na nie. ");
INSERT INTO zajp_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Movitanga kamba nimsang'hanikila tataenu na mhiko zangu zose. ");
INSERT INTO zajp_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Hata avo tataenu kanitendela uzenzeleganye mkugalula kitumetume changu mianza bwando. Ila Mulungu hamulekile yanhendele nie kinhu kihile. ");
INSERT INTO zajp_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Labani viyalongile, ‘Ng'hondolo wondawaleligwe wali na minyela wowa kitumetume chako,’ wose wasonga kulela wana wali na minyela. Na viyagalule na kulonga, ‘Wang'onyo wali na minhongo wowa kitumetume chako,’ ng'hondolo wose walela wana wali na minhongo. ");
INSERT INTO zajp_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Vino vivo Mulungu viyasolile wang'onyo wa tataenu na kunigwelela nie. ");
INSERT INTO zajp_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Kipigiti cha wang'onyo kuikwela, nilota nyona songolomi wa menhe wakalile wokwela wose wakala na minhongo, minyela, na midewa. ");
INSERT INTO zajp_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Msenga wa Mulungu wa kuulanga kanikema nie muinzozi yolonga, ‘Yakobo,’ na nie nidika, ‘Nabaha.’ ");
INSERT INTO zajp_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Na heyo kanongela, ‘Lola songolomi wose wa menhe waja wokwela wana minhongo, minyela, na midewa. Nigatenda gano kwavija nyona vija Labani viyakutendele. ");
INSERT INTO zajp_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nie iyo Mulungu nikulawilile kuja Beteli, hanhu haja haudigidile dibwe mavuta na haja haunitendele kiduilo. Avo segela hima muisi ino uchole muisi yako yuuleligwe.’ ” ");
INSERT INTO zajp_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Laheli na Lea wamulongela Yakobo, “Tweye twabule kinhu ama uhazi wowose kulawa ha tataetu. ");
INSERT INTO zajp_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Avo katutenda tweye kamba wahenza. Katuguza na sambi kaja hela zose ziyatuguzile tweye. ");
INSERT INTO zajp_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ugoli wose Mulungu uyam'bokile tataetu wetu tweye na wanetu. Avo sang'hana gaja Mulungu gondayakulongele.” ");
INSERT INTO zajp_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Avo Yakobo kawakweleza watwanzi zake na wanage muna iwangamia, ");
INSERT INTO zajp_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","na kugaswagiza madale gake gose galongole haulongozi wake hamoja na vinhu vose viyapatile Padani-Alamu na kuchola ha tataake Isaka muisi ya Kanaani. ");
INSERT INTO zajp_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Kipigiti hicho Labani kakala yacholile kuwakanha mijusu ng'hondolo zake, avija viyakalile haduhu Laheli kapata nafasi ya kwiba vinyago avo vikalile miungu ya tataake. ");
INSERT INTO zajp_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakobo kam'vwizila Labani na hamulongele kamba kohalawa. ");
INSERT INTO zajp_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yakobo kasola vinhu vake vose na kusegela hima. Kaloka Lwanda lwa Yuflati, kagalukila kuili isi ya Gileadi ili na vigongovigongo. ");
INSERT INTO zajp_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Mazua madatu vigabitile, Labani kalongeligwa kamba Yakobo kakimbila. ");
INSERT INTO zajp_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Avo Labani kawasola ndugu zake, wasonga kumkweleleza Yakobo kipigiti cha mazua saba, na wam'vika muisi ya vigongovigongo ya Gileadi. ");
INSERT INTO zajp_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Avo Mulungu kamulawilila Labani ikilo mnzozi na kumulongela, “Uteganye, sambiumulonge Yakobo mbuli yoyose ihile.” ");
INSERT INTO zajp_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yakobo keka ng'hambi muisi ya vigongovigongo ya Gileadi, vivija Labani na ndugu zake weka ng'hambi yao behi na heyo. ");
INSERT INTO zajp_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Abaho Labani kamulongela Yakobo, “Choni chuutendile? Kunivwizila na kusola wanangu kamba vija wagogigwe kung'hondo. ");
INSERT INTO zajp_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Habali usegele mkuifisa na kunivwizila? Habali hunongele giladi nikulage na ndeng'ha na nyila, na ngoma na bango? ");
INSERT INTO zajp_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Hata hunilekile niwanonela wanangu na wazukulu zangu na kuwalaga? Kweli kutenda ubozi. ");
INSERT INTO zajp_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nodaha kukulumiza, ila Mulungu wa tataako kandawilila kilo ya lelo na kanongela, ‘Uteganye, sambiumulonge Yakobo mbuli yoyose ihile.’ ");
INSERT INTO zajp_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Novitanga kamba kosulukila kubwela mng'anda ya tataako, ila habali wibile miungu yangu?” ");
INSERT INTO zajp_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobo kalonga, “Nidumba kwavija nigelegeza kamba uhanibokile wanago. ");
INSERT INTO zajp_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ila kamba uham'vika munhu yoyose mmwanza wetu yali na miungu yako, nayadanganhike. Lolesa bahano haulongozi wa ndugu zetu, kamba nna kinhu chako chochose, kisole.” Yakobo havitangile kamba Laheli kakala yebile miungu ya Labani. ");
INSERT INTO zajp_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Avo Labani kengila mdihema da Yakobo na kasonga kuzahila, abaho mdihema da Lea, na mdihema da waja nyakadala wabili wakitwanzi, ila hayonile miungu yake. Abaho kengila mdihema da Laheli. ");
INSERT INTO zajp_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Laheli kaisola ija imiungu na kuifisa mdisogi da kugwasikila mumgongo wa ngamia wake na kuikalila. Labani kazahila kila hanhu mdihema ila hayonile. ");
INSERT INTO zajp_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Laheli kamulongela tataake, “Tataangu, sambiunyonele lusango avija vinihila kwinuka haulongozi wako, kwavija notumika.” Avo Labani kazahila ila hayonile miungu yake. ");
INSERT INTO zajp_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakobo kehilwa ng'hani na kumuuza Labani, “Halihi hanihonyele? Choni kihile kinitendile kikutendile gweye unikoleleze?” ");
INSERT INTO zajp_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kusakula m'vinhu vangu vose. Kinhu chaki chako kiupatile? Vike hano haulongozi wa wandugu zako na wandugu zangu, giladi watulamule. ");
INSERT INTO zajp_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nikala hamoja na gweye milao malongo mabili sambi. Kipigiti chose ng'hondolo zako na menhe zako hawanatengula inda, na sinakuja songolomi wa ng'hondolo kulawa mdale jako. ");
INSERT INTO zajp_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Sikugalile ng'hondolo wako yakomigwe na wang'onyo wa kumuhulo. Hasala zose nizisola nie. Gweye kulonda nikulihe wang'onyo wose webigwe imisi ama ikilo. ");
INSERT INTO zajp_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Kipigiti kitali nigaya, imisi nilukuzwa na zua, na ikilo nibunhigwa na beho. Sipatile utulo. ");
INSERT INTO zajp_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Milao malongo mabili nikala mng'anda yako, nikusang'hanikila milao longo dimwe na mine sama ya Laheli na Lea, na milao sita sama ya madale ga wang'onyo. Kugalula kitumetume changu mianza longo dimwe. ");
INSERT INTO zajp_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kamba Mulungu wa muhenga zangu, Mulungu wa Ablaham na Isaka, yahalekile kuwa hamoja na nie, uhaniwingile bila kinhu. Ila Mulungu kayona migayo yangu na sang'hano initendile, kileka mana kakukomhokela ikilo ibitile. ");
INSERT INTO zajp_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani kamwidika Yakobo na kumulongela, “Watwanzi wano wanangu nie, na wana zao wangu nie, wang'onyo wano wangu nie, na vose vuuvona vangu nie. Avo choni kinidaha kuwatendela wanangu, ama wana zao wawalelile? ");
INSERT INTO zajp_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Avo tutende lagano gweye na nie, diwe usindila wetu.” ");
INSERT INTO zajp_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yakobo kasola dibwe, na kudisimika kamba nguzo giladi diwe lukumbuso. ");
INSERT INTO zajp_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Abaho Yakobo kawalongela wandugu zake, “Lundizeni mibwe.” Avo wadondola mabwe na kugalundiza kamba kisugulu. Abaho wakala hasi hamgwazo wa kija ikisugulu, waja mandia. ");
INSERT INTO zajp_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labani kahakema hanhu haja Yegali-Sahadusa, na Yakobo kahakema Galedi. ");
INSERT INTO zajp_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Avo Labani kamulongela Yakobo, “Kisugulu kino cha mibwe chowa usindila hagatigati yetu tweye.” Kino kicho kilamso cha hanhu haja kukemigwa Galedi. ");
INSERT INTO zajp_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Labani vivija kahakema hanhu haja Mizpa, kwavija kalonga, “MNDEWA yatulole, giladi tudigoge lagano dino kipigiti gweye na nie tuhawa kutali na miage. ");
INSERT INTO zajp_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kamba uhawagaza wanangu ama uhasola watwanzi wayagwe mbali na wanangu, hata kamba sivimanyile, ukumbukile kamba Mulungu kotulola.” ");
INSERT INTO zajp_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Abaho Labani kamulongela Yakobo, “Lola kisugulu kino cha mibwe, lola nguzo ino iniisimike hagatigati yako na yangu. ");
INSERT INTO zajp_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Kisugulu kino cha mibwe na nguzo ino zizo usindila, nie sikibanza kisugulu kino cha mibwe kwiza ng'ambu yako kukulumiza, na gweye sambiubanze kisugulu kino cha mibwe na nguzo ino wize ng'ambu yangu kunilumiza. ");
INSERT INTO zajp_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Mulungu wa Ablaham na mulungu wa Naholi wotulamula gweye na nie.” Avo Yakobo kaiduila mditwaga da Mulungu yakalile yotambikilwa na Isaka tataake kukigoga kilagano kija. ");
INSERT INTO zajp_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Abaho Yakobo kalava nhosa muisi ija ya vigongovigongo na kuwakema ndugu zake weze kuja mandia. Na viweshile kuja mandia wakala bahaja ikilo ngima. ");
INSERT INTO zajp_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Na imitondo ng'hani zua da ikabili Labani kawanonela wazukulu zake na wanage na kuwamoteza. Na abaho kabwela ukae yake. ");
INSERT INTO zajp_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakobo kagendelela na mwanza wake, na wasenga wa Mulungu wa kuulanga waiting'hana nayo. ");
INSERT INTO zajp_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakobo viyawawene kalonga, “Ino iyo ng'hambi ya asikali wa Mulungu.” Avo kahakema hanhu haja Mahanaimu. ");
INSERT INTO zajp_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Avo Yakobo kawatuma wasenga wamulongole wachole ha Esau, mkulu wake, ako Seili muisi ya Edomu. ");
INSERT INTO zajp_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Kawagwelela ndagizi, yolonga, “Mulongeleni mndewa wangu Esau mbuli zino, ‘Mtumigwa wako Yakobo kolonga, “Nikala na Labani na kusigala haja mbaka lelo. ");
INSERT INTO zajp_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Nna ng'ombe, mhunda, madale ga ng'hondolo na menhe, nyakadala wakitwanzi na wakimbigalo. Nokugalila usenga uno, mndewa wangu, mhate ngekewa haulongozi wako.” ’ ” ");
INSERT INTO zajp_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Abaho waja iwasenga viwabwelile wamulongela Yakobo, “Tuchola ha mkulu wako Esau, na heyo kokwiza kukubokela yali hamoja na wambigalo mia nne.” ");
INSERT INTO zajp_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakobo kadumba ng'hani na kudungwadungwa. Avo kawagola wanhu iyali nao, ng'hondolo, menhe, na ngamia mmadale mabili. ");
INSERT INTO zajp_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yakobo kagelegeza, yolonga, “Kamba Esau yeheza na kudivamhila dale dimwe, dale diyagwe dosigala.” ");
INSERT INTO zajp_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Abaho Yakobo katambika, yolonga, “Mulungu wa muhenga wangu Ablaham na Mulungu wa tataangu Isaka, MNDEWA, gweye unilongele nie nibwele muisi yangu na ha ndugu zangu, na kunongela konhendela ganogile. ");
INSERT INTO zajp_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Nie silumbile kutendeligwa unhu wose na kuwabule uzenzeleganye kuundagusile nie mtumigwa wako. Niloka Lwanda lwa Yolodani bila kinhu ila fimbo iiyeka na sambi nobwela na madale gano mabili. ");
INSERT INTO zajp_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nokutambikila, nikombole kulawa mmakono ga mkulu wangu Esau, nodumba siku kokwiza kunivamhila nie na watwanzi zangu hamoja na wanangu. ");
INSERT INTO zajp_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ila gweye kunongela kamba, konhendela ganogile mmbuli zangu zose, na kulongeza lukolo lwangu mbaka vondaluwe bwando kamba misenga ya mumgwazo wa ibahali vuileka kudahika kupetigwa.” ");
INSERT INTO zajp_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ikilo ija Yakobo kawasa haja, na kasagula nhunza ya kumgwelela Esau mkulu wake kulawa m'vinhu vayakalile navo, ");
INSERT INTO zajp_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","bogwa wa menhe mia mbili (200) na songolomi wa menhe malongo mabili (20), bogwa wa ng'hondolo mia mbili (200) na songolomi wa ng'hondolo malongo mabili (20), ");
INSERT INTO zajp_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ngamia malongo madatu (30) wokong'heza hamoja na wana zao, bogwa wa ng'ombe malongo mane (40) na songolomi longo dimwe (10), na bogwa wa mhunda malongo mabili (20) na songolomi longo dimwe (10). ");
INSERT INTO zajp_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Kawagola waja iwang'onyo mmadale na kila dale kamwika mtumigwa wake imwe kuwa kilangizi wa ididale. Abaho kawalongela waja iwatumigwa, “Longoleni na wano iwang'onyo ila ikeni nafasi kulawa dale dimwe mbaka dale diyagwe.” ");
INSERT INTO zajp_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Kamulagiza ija yalongole, yolonga, “Uhaiting'hana na mkulu wangu Esau na yahakuuza, ‘Gweye kwa mtumigwa wa munhu yalihi? Kwahi kuuchola? Na wang'onyo wano walongole wa munhu yalihi?’ ");
INSERT INTO zajp_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Gweye mulongele, ‘Wang'onyo wano wa mtumigwa wako Yakobo, wano iwo nhunza iyomgalila mndewa wake Esau, na heyo ka kuchugu kokwiza.’ ” ");
INSERT INTO zajp_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Vivija kamulagiza imtumigwa wa ikabili na wa ikadatu na wose wakalile vilangizi wa igamadale. “Vino vivo vondammulongele Esau kipigiti vondamuiting'hane nayo. ");
INSERT INTO zajp_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Na mmulongele, ‘Mtumigwa wako Yakobo kokwiza kuchugu chetu.’ ” Yakobo kagelegeza, kalonga, “Nomuhoza na nhunza zino zinimulongozela, siku nahaiting'hana nayo, konibokela.” ");
INSERT INTO zajp_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Yakobo kazilongoza izinhunza, na heyo mwenyego kasigala haja hang'hambi ikilo ija. ");
INSERT INTO zajp_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ikilo iija Yakobo kalamuka na kawasola watwanzi zake wabili, watwanzi zake wabili wa kunze, na wanage longo dimwe na imwe, abaho kaloka Lwanda lwa Yaboki. ");
INSERT INTO zajp_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Viyeshile kuwalosa, kalosa na vinhu vose viyakalile navo. ");
INSERT INTO zajp_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Avo Yakobo kasigala yeiyeka. Abaho keza munhu, kasonga kuifida nayo mbaka imitondo. ");
INSERT INTO zajp_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ija imunhu viyonile kolemelwa kumuhuma Yakobo, kamkwasa mdipengene viwakalile wokiifida, na idipengene disiguka. ");
INSERT INTO zajp_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Abaho ija imunhu kamulongela Yakobo, “Ndekesa nyhole, kwavija usiku ocha.” Ila Yakobo kamulongela, “Sikulekesa mbaka vondaunimoteze.” ");
INSERT INTO zajp_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ija imunhu kamuuza, “Twaga jako dijo dilihi?” Kamwidika, “Twaga jangu Yakobo.” ");
INSERT INTO zajp_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Abaho ija imunhu kamulongela, “Songela sambi hukemigwa kabili Yakobo, ila kokemigwa Islaeli, kwavija kuifida na Mulungu hamoja na wanhu, na kuhuma.” ");
INSERT INTO zajp_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakobo kamulongela, “Nongela twaga jako.” Ila heyo kamuuza, “Habali uniuza twaga jangu?” Abaho kammoteza. ");
INSERT INTO zajp_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Avo Yakobo kahakema hanhu haja Penueli, kalonga, “Kwavija nimona Mulungu kihanga kwa kihanga, na ning'hali mgima.” ");
INSERT INTO zajp_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Zua vidisongile kulawa, Yakobo kasegela Penueli kuno yodendegulila sama ya pengene jake. ");
INSERT INTO zajp_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Avo mbaka lelo, Waislaeli hawaja nyama ya pengene, kwavija pengene da Yakobo dikwasigwa behi na kigudi chake. ");
INSERT INTO zajp_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakobo kalola na kumona Esau yokwiza na wambigalo mia nne, avo kawagola wana wa Lea, wana wa Laheli, na wana wa waja watwanzi zake wabili wa kunze. ");
INSERT INTO zajp_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Kaweka haulongozi waja iwatwanzi zake wabili wa kunze hamoja na wana zao, abaho Lea na wanage, abaho Laheli na Usufu kuchugu chao. ");
INSERT INTO zajp_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Heyo mwenyego kalongola haulongozi wao, kafugama mavindi, kainamila mbaka hasi mianza saba mbaka viyavikile behi na mkulu wake. ");
INSERT INTO zajp_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ila Esau kamkimbilila Yakobo, kamkumbatila na kumnonela. Abaho wose wabili walila. ");
INSERT INTO zajp_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau kawalola waja iwatwanzi na iwana, kauza, “Wano uulinao iwo wanhu walihi?” Yakobo kedika, “Wano wao wana Mulungu iyanigwelele nie, mtumigwa wako.” ");
INSERT INTO zajp_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Abaho waja iwatwanzi zake wa kunze na wana zao wawakwenhukila behi na wamfugamila mavindi na kumwinamila mbaka hasi. ");
INSERT INTO zajp_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Vivija weza Lea na wanage wamfugamila mavindi na kumwinamila mbaka hasi. Hakimambukizo, weza Usufu na Laheli, na hewo wamfugamila mavindi na kumwinamila mbaka hasi. ");
INSERT INTO zajp_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau kauza, “Madale gano ganiiting'hanile nago nhegulo yake choni?” Yakobo kamwidika, “Madale gano gago nhunza ha mndewa wangu giladi mhate ngekewa hameso gako.” ");
INSERT INTO zajp_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ila Esau kalonga, “Nna vinhu bwando, mdodo wangu, vino vuulinavo viwe vako mwenyego.” ");
INSERT INTO zajp_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakobo kalonga, “Si vivo, kamba nitogoligwa hameso gako, bokela nhunza ino kulawa kumwangu. Kwavija kona kihanga chako kumwangu nie ilinga na kona kihanga cha Mulungu, avija viunibokele na noge. ");
INSERT INTO zajp_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nokuyalalila, bokela nhunza ino inikugalile. Mulungu kanyonela bazi kangwelela kila kinhu kinilonda.” Vino vivo Yakobo viyamgong'ondeze Esau, na Esau katogola. ");
INSERT INTO zajp_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Abaho Esau kalonga, “Tuchole, nie nolongola haulongozi.” ");
INSERT INTO zajp_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ila Yakobo kamulongela, “Uvimanye, mndewa wangu, wana wano wang'hali wadodo na vivija nolondigwa niwaseseze ng'hondolo na ng'ombe awo wokong'heza. Kamba wahasosozigwa mdizua dimwe, wang'onyo wose wofa. ");
INSERT INTO zajp_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Avo nokuyalalila, mndewa wangu, longola haulongozi wa mtumigwa wako, nie nokwiza mholemhole hamoja na iwang'onyo na iwana mbaka vondatuvike Seili.” ");
INSERT INTO zajp_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau kalonga, “Beta nikulekele wanhu zangu kidogo.” Yakobo kamulongela, “Sambiutende hivo, mndewa wangu, kinilonda nie mhate ngekewa hameso gako.” ");
INSERT INTO zajp_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Avo zua didija Esau kafunga mwanza wa kubwela Seili. ");
INSERT INTO zajp_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ila Yakobo kachola Sukuti ako kuyazengile ng'anda yake na banda da wang'onyo zake. Kino kicho kilamso hanhu haja hakemigwa Sukuti. ");
INSERT INTO zajp_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakobo kasegela Padani-Alamu, na kuvika na upile mdiwambo da Shekemu muiisi ya Kanaani, na keka ng'hambi yake behi na idiwambo. ");
INSERT INTO zajp_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Hanhu kuyekile ng'hambi kahagula kulawa ha wana wa Hamoli, tataake Shekemu, kwa vidanga mia va feza. ");
INSERT INTO zajp_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Haja kazenga kilingo cha kulavila nhosa na kukikema Mulungu iyo Mulungu wa Islaeli. ");
INSERT INTO zajp_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Zua dimwe Dina, mwana wa Yakobo iyalelile na Lea, kachola kuwatembelela watwanzi Wakikanaani. ");
INSERT INTO zajp_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ila Shekemu, yakalile mwana wa mkulu wa isi yakalile yokemigwa Hamoli Muhivi, viyamuwene Dina, kamkwida na kumuwasa kwa shuluti. ");
INSERT INTO zajp_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Moyo wa Shekemu unogelwa na Dina mndele wa Yakobo, na kamnogela ija imndele, na kalonga nayo mbuli zinogile. ");
INSERT INTO zajp_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shekemu kamulongela Hamoli tataake, yolonga, “Nigwelele mndele ino yawe mtwanzi wangu.” ");
INSERT INTO zajp_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakobo viyahulike kamba Dina mndele wake katendeligwa mbuli zigela kinyala, wanage wakala kumgunda wochunga, avo kanyamala mbaka viwabwelile. ");
INSERT INTO zajp_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Na Hamoli tataake Shekemu kachola ha Yakobo giladi walongelele. ");
INSERT INTO zajp_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Wana wa Yakobo viwakalile wobwela kulawa kuchunga, wahulika gaja galawilile, wehilwa ng'hani na wona lusango, kwavija Shekemu kakala yatendile kinhu kihile ha Waislaeli kumuwasa kwa shuluti mndele wa Yakobo. ");
INSERT INTO zajp_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ila Hamoli kawalongela Yakobo na wanage, “Mwanangu Shekemu kanogelwa ng'hani na mndele wenu, avo nowayalalila mmuleke yamsole mndele wenu. ");
INSERT INTO zajp_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Natuisole. Tugweleleni wandele zenu, na mweye wasoleni wandele zetu. ");
INSERT INTO zajp_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Avo mkale hano muisi yetu hamoja na tweye, mkale hanhu hohose hamulonda, tendeni uchuluzi mkuilegeha, na muwe na hanhu henu wenyego.” ");
INSERT INTO zajp_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Abaho Shekemu kamulongela tataake Dina na ndugu zake, “Munitogolele, na nowagweleleni chochose chumulonda. ");
INSERT INTO zajp_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mnongele nhunza yaki yumulonda, na maliho gogose ga zengele gomulonda, nowagwelela kiasi chochose chumulonda, kamba muhanitogoza nie nimsole.” ");
INSERT INTO zajp_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Avo wanage Yakobo wamulongela Shekemu na Hamoli tataake mkuwavwizila, kwavija Shekemu kamtendela mbuli zigela kinyala lumbu jao Dina. ");
INSERT INTO zajp_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Wawalongela, “Hatudaha kutenda kinhu kino, kumgwelela lumbu jetu munhu hanakwingila kumbi, kumwetu tweye yowa kinyala. ");
INSERT INTO zajp_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Todaha kutogola kamba muhatenda kinhu kino, kamba kila mbigalo mmwanza wenu yehengizigwa kumbi kamba vituli tweye. ");
INSERT INTO zajp_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Abaho tweye towagwelela wandele zetu na tweye towasola wandele zenu, na tweye tokala hamoja na mweye na kugaluka wanhu wamwe. ");
INSERT INTO zajp_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ila kamba hamtutogolela mweye kwingila kumbi, tomsola lumbu jetu, tochola nayo.” ");
INSERT INTO zajp_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Mbuli zija ziwanogela Hamoli na Shekemu mwanage. ");
INSERT INTO zajp_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Mmhale ija ayo yakalile yohishimilwa ng'hani kubanza wose mng'anda ya tataake, kalopola kugatenda gaja gawalongile kwavija kanogelwa na mndele wa Yakobo. ");
INSERT INTO zajp_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Avo Hamoli na mwanage Shekemu wachola ha ulwivi lwa idiwambo jao na kulonga na vilangizi wa idiwambo. ");
INSERT INTO zajp_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Walonga, “Wanhu wano wanoga, na tuwaleke wakale muisi yetu, na kutenda uchuluzi, isi ino ina hanhu bwando hakukala hewo. Tuwasole wandele zao na wasole wandele zetu. ");
INSERT INTO zajp_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ila wanhu wano wotogola kukala hamoja na tweye, na kuwa hamoja na tweye, kamba tuhatogola wambigalo zetu wengizigwe kumbi kamba viwali hewo. ");
INSERT INTO zajp_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kamba twahatenda vino, wang'onyo zao na vinhu vose viwalinavo vowa vetu. Na tuwatogolele mbuli zao, tuwaleke wakale hamoja na tweye.” ");
INSERT INTO zajp_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Wambigalo wose waiting'hane hana ulwivi lwa idiwambo waitogolela na Hamoli na Shekemu mwanage, na kila mbigalo muja mdiwambo kengizigwa kumbi. ");
INSERT INTO zajp_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Mazua madatu vigabitile, waja wengizigwe kumbi viwakalile wang'hali na usungu, wana wabili wa Yakobo, Simioni na Lawi lumbu zake Dina, wasola mizele yao, wadivamhila idiwambo mkwidukiza na kuwakoma wambigalo wose, ");
INSERT INTO zajp_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","wawakoma Hamoli na Shekemu mwanage na zele, wamsola Dina lumbu jao kulawa mng'anda ya Shekemu, wachola nayo. ");
INSERT INTO zajp_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Viweshile kuwakoma, wana wayagwe wa Yakobo wengila mdiwambo na kusamha kila kinhu, kwavija lumbu jao kakala yatendeligwe mbuli zigela kinyala. ");
INSERT INTO zajp_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Wasola ng'hondolo, ng'ombe, mhunda, na kila kinhu kikalile mdiwambo dija na mmigunda. ");
INSERT INTO zajp_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Wasola mali gao gose, watwanzi zao wose, na wana zao, na wasola kila kinhu kikalile mng'anda zao. ");
INSERT INTO zajp_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakobo kawalongela Simioni na Lawi, “Mungalila mbuli, munitenda nie nihilwe na Wakanaani na Wapelizi na kila munhu yokala muisi ino. Nie nabule wanhu bwando, na kamba wahaiduganya hamoja na kunivamhila nie na wanhu wa ng'anda yangu, tobanangigwa.” ");
INSERT INTO zajp_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Wamwidika na lusango wolonga, “Habali tumuleke heyo yamtende lumbu jetu kamba mtenda ugoni ndwanga?” ");
INSERT INTO zajp_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Mulungu kamulongela Yakobo, “Genda Beteli na ukakale hiko, na ukanizengele nie kilingo cha kulavila nhosa, nie iyo Mulungu nikulawilile gweye kipigiti vuukalile umkimbila mkulu wako Esau.” ");
INSERT INTO zajp_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Avo Yakobo kawalongela wanhu wa mulango wake na wanhu wose wakalile hamoja na heyo, “Segezeni miungu yose ya Wamhazi imulinayo, yogeni, na m'vale vivalo ving'alile, ");
INSERT INTO zajp_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","abaho mwize tuchole Beteli, nikazenge kilingo cha kulavila nhosa ha Mulungu yanhazile mmazua ga migayo yangu na yakalile na nie kokose kunicholile.” ");
INSERT INTO zajp_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Avo wamgwelela Yakobo miungu yose ya Wamhazi iwakalile nayo, na heleni ziwakalile wavalile, na Yakobo kavihimbilila hasi ya m'biki ukemigwa mwaloni haja Shekemu. ");
INSERT INTO zajp_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yakobo na wanage viwasongile kusegela, Mulungu kawatenda wanhu wose wa miwambo ija ikalile behi wone bwembwe ng'hani, na haduhu munhu yawakoleleze. ");
INSERT INTO zajp_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakobo hamoja na wanhu wose iyakalile nao wavika hanhu hakemigwe Luzi ama mtwaga diyagwe Beteli muisi ya Kanaani. ");
INSERT INTO zajp_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yakobo kazenga kilingo cha kulavila nhosa, na kuhakema hanhu haja Eli-Beteli, kwavija haja baho Mulungu hayaigubule kumwake kipigiti viyakalile yomkimbila Esau mkulu wake. ");
INSERT INTO zajp_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debola, yaya wa Lebeka, kadanganhika, na kazikigwa hasi ya m'biki ukemigwa mwaloni muisi ya Beteli. Avo Yakobo kaukema m'biki uja Aloni-Bakusi nhegulo yake “Mwaloni wa Mahozi.” ");
INSERT INTO zajp_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakobo viyabwelile kulawa Padani-Alamu, Mulungu kamulawilila kabili na kummoteza. ");
INSERT INTO zajp_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Mulungu kamulongela, “Twaga jako Yakobo, ila hukemigwa kabili Yakobo, ila kokemigwa Islaeli.” Avo kakemigwa Islaeli. ");
INSERT INTO zajp_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Abaho Mulungu kamulongela, “Nie iyo Mulungu Mwene Mhiko. Ukalele wongezeke, ndewa bwando zolawa kumwako, na wandewa wolawa mulukuli lwako gweye. ");
INSERT INTO zajp_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Isi inimgwelele Ablaham na Isaka, isi ino nokugwelela gweye na lukolo lwako londalwize.” ");
INSERT INTO zajp_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Abaho Mulungu kamuleka, kachola uchana kulawa hanhu haja kuyalongile na Yakobo. ");
INSERT INTO zajp_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakobo kasimika nguzo hanhu haja Mulungu hayalongile nayo, kasimika nguzo ya dibwe, kaigidila nhosa ya divai, abaho kaigidila mavuta. ");
INSERT INTO zajp_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakobo kahakema hanhu haja Mulungu hayalongile nayo, “Beteli.” ");
INSERT INTO zajp_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakobo na mulango wake wasegela Beteli, na viwakalile wang'hali kutali na wambo da Eflati, kipigiti cha Laheli kulela kivika, avo kasonga kona usungu ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Na usungu wa kulela vuubanzile, ija yakalile imng'hunga kamulongela, “Sambiudumbe, kulela mwana mbigalo iyagwe.” ");
INSERT INTO zajp_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Laheli viyakalile behi na kudanganhika, kamgwelela twaga imwana, kamkema Beni-Oni, ila tataake kamkema Benjamini. ");
INSERT INTO zajp_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Avo Laheli kadanganhika, kazikigwa hamgwazo wa inzila ichola Eflati, wambo dikalile na twaga diyagwe dikemigwa Betelehemu. ");
INSERT INTO zajp_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakobo keka nguzo hadipanga da Laheli kamba ng'humbukila, nguzo ija ya baho mbaka lelo. ");
INSERT INTO zajp_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Yakobo, ayo vivija yakemigwe Islaeli, kagendelela na mwanza wake na kwika ng'hambi ng'ambu ya ikabili ya ulingo wa Edeli. ");
INSERT INTO zajp_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Yakobo viyakalile yokala muisi ija, Lubeni kachola kuwasa na Bilha mtwanzi wa kunze wa tataake, na Yakobo kahulika. Yakobo kakala na wana mbigalo longo dimwe na wabili. ");
INSERT INTO zajp_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Wana wa Lea wakala Lubeni, yakalile chaudele wa Yakobo, Simioni, Lawi, Yuda, Isakali, na Zabuloni. ");
INSERT INTO zajp_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Wana wa Laheli wakala Usufu na Benjamini. ");
INSERT INTO zajp_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Wana wa Bilha nyakadala wa Laheli wakala Dani na Naftali. ");
INSERT INTO zajp_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Wana wa Zilpa nyakadala wa Lea wakala Gadi na Asheli. Wano wao wana wa kimbigalo wa Yakobo iyawalelile viyakalile Padani-Alamu. ");
INSERT INTO zajp_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobo kachola ha tataake Isaka ako Mamle behi Kiliasi-Aliba, sambi hokemigwa Hebloni, ako Ablaham na Isaka kuwakalile wokala kamba wahenza. ");
INSERT INTO zajp_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaka kakala na uvyele wa milao mia na malongo manane. ");
INSERT INTO zajp_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaka kadanganhika kuno yali na milao bwando na kuilumba hamoja na wahenga zake. Wanage Esau na Yakobo wamzika tataao. ");
INSERT INTO zajp_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Luno lulo lukolo lwa Esau, ayo vivija yakemigwe Edomu. ");
INSERT INTO zajp_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau kawasola watwanzi zake kulawa muisi ya Kanaani, Ada mndele wa Eloni Muhiti, na Oholibama, ayo yakalile mndele wa Ana na mzukulu wa Zibeoni Muhivi, ");
INSERT INTO zajp_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","na Basemati mwanage Sumaili na lumbu ja Nebayoti. ");
INSERT INTO zajp_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada kamulelela Esau mwana yokemigwa Elifazi, Basemati kamulelela Esau mwana yokemigwa Leueli, ");
INSERT INTO zajp_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","na Oholibama kawalela Yeushi, Yalamu, na Kola. Wano wose iwo wana iyawalelile Esau kipigiti viyakalile Kanaani. ");
INSERT INTO zajp_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Abaho Esau kawasola watwanzi zake, wanage wakitwanzi na wakimbigalo, na wanhu wose wakalile mng'anda yake, hamoja na wang'onyo zake wose na vinhu vose viyakalile navo haja Kanaani. Kasegela, kachola kuisi ikalile kutali na mdodo wake Yakobo. ");
INSERT INTO zajp_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Katenda avo kwavija isi iwakalile wokala heyo na mdodo wake Yakobo ikala ndodo, avo havidahike kukala hamoja, kwavija wakala na wang'onyo bwando. ");
INSERT INTO zajp_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Avo Esau ayo yakalile na twaga diyagwe dikemigwa Edomu kachola kukala muisi ya vigongovigongo ya Seili. ");
INSERT INTO zajp_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Luno lulo lukolo lwa Esau, muhenga wa Waedomu muisi ya vigongovigongo ya Seili. ");
INSERT INTO zajp_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Matwaga ga wana wa Esau gakala Elifazi, mwana wa mtwanzi wa Esau yokemigwa Ada, na Leueli, mwana wa mtwanzi wa Esau yokemigwa Basemati. ");
INSERT INTO zajp_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Wana wa Elifazi wakala Temani, Omali, Zefo, Gatamu, na Kenazi. ");
INSERT INTO zajp_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Mwana wa Esau yokemigwa Elifazi kakala na mtwanzi wa kunze twaga jake dikemigwa Timna, iyalelile nayo mwana yokemigwa Amaleki. Wana wano sita wambigalo wakala wazukulu wa mtwanzi wa Esau yokemigwa Ada. ");
INSERT INTO zajp_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Wana wa Leueli wakala Nahati, Zela, Shama, na Miza. Wano wakala wazukulu wa Basemati, mtwanzi wa Esau. ");
INSERT INTO zajp_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Oholibama, ayo yakalile mndele wa Ana na mzukulu wa Zibeoni, kamulelela Esau wana wadatu wakemigwe Yeushi, Yalamu, na Kola. ");
INSERT INTO zajp_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Wano wao wakulu wa mitala ilawile mulukolo lwa Esau. Elifazi kakala chaudele wa Esau na heyo kakala na wana wakemigwe Temani, Omali, Zefo, Kenazi, ");
INSERT INTO zajp_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kola, Gatamu, na Amaleki. Wano wao wakulu kulawa mulukolo lwa Elifazi muisi ya Edomu, wakala wazukulu wa mtwanzi wa Esau yokemigwa Ada. ");
INSERT INTO zajp_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Leueli, mwanage Esau, kawalela Nahati, Zela, Shama, na Miza. Wano wao wakulu wa lukolo lwa Leueli muisi ya Edomu, wakala wazukulu wa mtwanzi wa Esau yokemigwa Basemati. ");
INSERT INTO zajp_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Wana wa mtwanzi wa Esau yokemigwa Oholibama wakala Yeushi, Yalamu, na Kola. Wano wao wakulu wa lukolo lwa mtwanzi wa Esau yokemigwa Oholibama mwanage Ana. ");
INSERT INTO zajp_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Wano wao wana wa Esau, vivija yakemigwe Edomu, na kila munhu kakala mkulu muisi yake. ");
INSERT INTO zajp_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Wano wao wana wa Seili Mholi. Wakalile wokala muisi ija, matwaga gao gakala Lotani, Shobali, Zibeoni, Ana, ");
INSERT INTO zajp_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishoni, Ezeli, na Dishani. Wana wano wa Seili wakalile wokala Edomu wakala wakulu wa Waholi. ");
INSERT INTO zajp_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Wana wa Lotani wakala Holi na Hemani. Timna kakala lumbu jake Lotani. ");
INSERT INTO zajp_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Wana wa Shobali wakala Alvani, Manahati, Ebali, Shefo, na Onamu. ");
INSERT INTO zajp_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Wana wa Sibeoni wakala Aya na Ana. Ana iyo yavumbule nzokwe za mazi ga moto kuluwala, kipigiti viyakalile yochunga mhunda za Zibeoni tataake. ");
INSERT INTO zajp_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Wana wa Ana wakala Dishoni na Oholibama lumbu jake. ");
INSERT INTO zajp_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Wana wa Dishoni wakala Hemdani, Eshibani, Itilani, na Kelani. ");
INSERT INTO zajp_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Wana wa Ezeli wakala Bilhani, Zaavani, na Akani. ");
INSERT INTO zajp_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Wana wa Dishani wakala Uzi na Alani. ");
INSERT INTO zajp_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Wakulu wa Waholi wakala Lotani, Shobali, Zibeoni, Ana, ");
INSERT INTO zajp_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishoni, Ezeli, na Dishani. Wano wakala wakulu wa Waholi muisi ya Seili. ");
INSERT INTO zajp_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Wano wao wandewa wakalile watawale isi ya Edomu kipigiti hanatawala mndewa yoyose muisi ya Islaeli. ");
INSERT INTO zajp_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela mwanage Beoli kawa mndewa wa isi ya Edomu, wambo jake dikala dikemigwa Dinihaba. ");
INSERT INTO zajp_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela viyadanganhike, Yobabu mwanage Zela wa wambo da Bozla kawa mndewa, kusola nafasi yake. ");
INSERT INTO zajp_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabu viyadanganhike, Hushamu wa isi ya Watemani kawa mndewa, kusola nafasi yake. ");
INSERT INTO zajp_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushamu viyadanganhike, Hadadi mwana wa Bedadi kawa mndewa, kusola nafasi yake, na kutawala songela mdiwambo da Avita. Heyo kakala yawahumile Wamidiani muisi ya Moabu. ");
INSERT INTO zajp_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi viyadanganhike, Samla kulawa mdiwambo da Masleka kawa mndewa, kusola nafasi yake. ");
INSERT INTO zajp_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla viyadanganhike, Shauli kulawa mdiwambo da Lehoboti behi na ulwanda kawa mndewa, kusola nafasi yake. ");
INSERT INTO zajp_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shauli viyadanganhike, Baali-Hanani mwanage Akiboli kawa mndewa, kusola nafasi yake. ");
INSERT INTO zajp_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baali-Hanani mwanage Akiboli viyadanganhike, Hadadi kawa mndewa, kusola nafasi yake, na kutawala songela mdiwambo da Pau. Mtwanzi wake kakemigwa Mehetabeli, mndele wa Matiledi na mzukulu wa kitwanzi wa Me-Zahabu. ");
INSERT INTO zajp_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Gano gago matwaga ga wakulu wa lukolo lwa Esau, hanhu hawakalile wokala hakemigwe matwaga ga madale gao, Timna, Alva, Yeteti, ");
INSERT INTO zajp_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinoni, ");
INSERT INTO zajp_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenazi, Temani, Mibizali, ");
INSERT INTO zajp_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magidieli, na Ilamu. Wano wakala wakulu wa isi zao kulawa mulukolo lwa Esau, muhenga wa Waedomu. Hanhu hawakalile wokala hakemigwa matwaga ga mitala yao. ");
INSERT INTO zajp_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo kakala muisi yaakalile tataake kamba muhenza, isi ya Kanaani. ");
INSERT INTO zajp_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ino iyo simulizi ya mulango wa Yakobo. Usufu viyakalile na milao longo dimwe na saba, kakala yochunga ng'hondolo na wakulu zake, wana wa Bilha na wana wa Zilpa watwanzi wa tataake. Usufu kamgalila tataake mbuli zihile ziwatendile wakulu zake. ");
INSERT INTO zajp_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Islaeli, ayo vivija yakemigwe Yakobo, kamnogela ng'hani Usufu kubanza wanage wasigale kwavija kamulela kipigiti cha uvyele wake, na kamtendela kanzu nhali ihambigwe. ");
INSERT INTO zajp_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Wakulu zake viwonile kamba tataao kamnogela heyo ng'hani kubanza hewo wose wasigale, wamwihila, na hawalongelele nayo goya. ");
INSERT INTO zajp_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Usufu kalota nzozi, na viyawalongele wakulu zake, wabanza kumwihila. ");
INSERT INTO zajp_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Kawalongela, “Tegelezeni nzozi ino inilotile. ");
INSERT INTO zajp_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Tweye tose tukala kumgunda tufunga makinza ga ngano, nidukila kinza jangu dinuka na kwima wima na mikinza yenu izunguluka kinza jangu na kudinamilila mbaka hasi.” ");
INSERT INTO zajp_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Wakulu zake wamuuza, “Kokwagiza gweye kowa mndewa wetu, kokwagiza gweye kotutawala tweye?” Avo wamwihila ng'hani kabisa sama ya nzozi yake na mbuli zake. ");
INSERT INTO zajp_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Abaho Usufu kalota nzozi iyagwe na kuwalongela wakulu zake, “Nilota nzozi iyagwe. Zua na mulenge na nhondo longo dimwe na imwe zininamilila nie mbaka hasi.” ");
INSERT INTO zajp_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ila viyamulongele tataake kamba viyawalongele wandugu zake, tataake kamkomhokela na kumulongela, “Nzozi yaki ino yuulotile! Mamaako na nie na wakulu zako tokwiza na kukunamilila gweye mbaka hasi?” ");
INSERT INTO zajp_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Avo wakulu zake wamonela migongo, ila tataake kazika mbuli zija mmoyo. ");
INSERT INTO zajp_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Vuzimalile mbuli zino, wakulu zake wachola kuchunga ng'hondolo za tataao behi na Shekemu. ");
INSERT INTO zajp_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Na Yakobo kamulongela Usufu, “Wakulu zako wachola Shekemu kuchunga ng'hondolo, isasale nolonda kukutuma kumwao.” Usufu kalonga, “Nhogola.” ");
INSERT INTO zajp_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tataake kamulongela, “Genda ukawalole wakulu zako hamoja na iwang'hondolo kamba wana ugima, abaho ubwele unongele.” Avo tataake kamtuma Usufu kulawa Kudibonde da Hebloni. Viyavikile Shekemu, ");
INSERT INTO zajp_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","munhu imwe kam'vika yozungulukazunguluka muluwala, kamuuza, “Kozahila choni hano?” ");
INSERT INTO zajp_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Kalonga, “Nowazahila wakulu zangu. Nilongele kwahi kowachungila ng'hondolo zao.” ");
INSERT INTO zajp_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ija imunhu kalonga, “Wasegela hano kwavija niwahulika wolonga, ‘Tucholeni Dotani.’ ” Avo Usufu kawakoleleza wakulu zake, kawavika Dotani. ");
INSERT INTO zajp_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Wamona songela viyakalile kutali, na kipigiti hanawakwenhukila, wamwikila zundo da kumkoma. ");
INSERT INTO zajp_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Wailongela, “Ayo mulota nzozi kokwiza. ");
INSERT INTO zajp_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Izoni tumkome abaho tumwase mdikolongo dimwe mmwanza wa mikolongo ino. Tulonge mng'onyo wa kumuhulo kamkoma. Abaho tulole malawililo ga nzozi zake.” ");
INSERT INTO zajp_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Lubeni viyagahulike gano, kalonda kumkombola kulawa mmakono gao. Kalonga, “Sambitumkome.” ");
INSERT INTO zajp_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Lubeni kawalongela, “Sambitwite mulopa wake, ila tumwase mdikolongo dino dili hano mmuhulo, ila sambimmulumize.” Lubeni kalonga vino giladi yamwihule kulawa mmakono gao yam'bweze ha tataake. ");
INSERT INTO zajp_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Usufu viyavikile ha wakulu zake, wam'vula kanzu yake nhali ihambigwe iyavalile. ");
INSERT INTO zajp_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Wamsola wamwasila mdikolongo dikalile bule kinhu, dikala bule mazi mgati yake. ");
INSERT INTO zajp_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Viwakalile hasi waje mandia, walola wona dale da Wasumaili wokwiza kulawa Gileadi, hamoja na ngamia zao wapapile ubane, zeli, na manemane, na wakala mnzila wovigala Misili. ");
INSERT INTO zajp_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda kawalongela wandugu zake, “Kamba tuhamkoma mdodo wetu na kuufisa mulopa wake, topata choni? ");
INSERT INTO zajp_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Izoni tumguze ha Wasumaili na sambitumulumize kwavija ino mdodo wetu, lukuli lwetu, na mulopa wetu.” Na ndugu zake watogola. ");
INSERT INTO zajp_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Avo waja iwachuuzi kulawa Midiani viwakwenhuke, wakulu zake wamulava Usufu hanze ya idikolongo na kumguza ha Wasumaili kwa vidanga malongo mabili va feza, na wamsola na kumgala Misili. ");
INSERT INTO zajp_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Lubeni viyabwelile kudikolongo na kona kamba Usufu kahaduhu muja mdikolongo, kadega vivalo vake mkona giogio. ");
INSERT INTO zajp_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Kabwela ha wandugu zake na kuwalongela, “Immhale kahaduhu muja mdikolongo, nitendeze?” ");
INSERT INTO zajp_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Avo wasola kanzu ya Usufu, wamchinja menhe, waivubika ija ikanzu mmulopa. ");
INSERT INTO zajp_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Waisola ija ikanzu ihambigwe waigala ha tataao na kulonga, “Tuidondola kanzu ino. Ilole goya, siku yowa kanzu ya mwanago.” ");
INSERT INTO zajp_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Tataao kaitanga na kulonga, “Ino iyo kanzu ya mwanangu, mng'onyo mkali kamja. Mwanangu Usufu kadegigwa vidangavidanga.” ");
INSERT INTO zajp_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Abaho Yakobo kadega vivalo vake mkona giogio, kavala migunia, na kumulilila mwanage mmazua bwando. ");
INSERT INTO zajp_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Wanage wose wakimbigalo na wakitwanzi weza kumuhembekeza, ila kalema kuhembekezwa. Kalonga, “Nomulilila mwanangu mbaka vondaningile kuzimu.” Avo tataake kagendelela kumulilila. ");
INSERT INTO zajp_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Kipigiti kikija, viwavikile Misili, waja Iwamidiani wamguza Usufu ha Potifa, ayo yakalile imwe wa wakulu wa silikali, ayo vivija yakalile kilangizi wa wemilizi wa ng'anda ya Falao, mndewa wa Misili. ");
INSERT INTO zajp_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Kipigiti kija Yuda kawaleka wandugu zake na kuchola kukala na munhu wa kiwambo cha Adulamu yokemigwa Hila. ");
INSERT INTO zajp_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yuda kipigiti viyakalile haja kamona mndele kulawa isi ya Kanaani, ayo tataake yakalile yokemigwa Shua. Kamsola na kuwasa nayo. ");
INSERT INTO zajp_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Kapata inda, kalela mwana mbigalo, na kumgwelela twaga dikemigwa Eli. ");
INSERT INTO zajp_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Kapata inda iyagwe, kalela mwana mbigalo, na kumgwelela twaga dikemigwa Onani. ");
INSERT INTO zajp_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Abaho kapata inda mwanza uyagwe, kalela mwana mbigalo, na kumgwelela twaga dikemigwa Shela. Yuda kakala mkiwambo kikemigwe Kezibu kipigiti viyavumbuke Shela. ");
INSERT INTO zajp_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yuda kamsolela mtwanzi mwanage wa udele yokemigwa Eli, twaga jake mtwanzi ija kakala yokemigwa Tamali. ");
INSERT INTO zajp_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ila Eli mwana wa udele wa Yuda kakala yehile hameso ga MNDEWA, avo MNDEWA kamkoma. ");
INSERT INTO zajp_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Avo Yuda kamulongela Onani, “Genda kawase na mtwanzi wa mkulu wako, utende gaja goulondigwa kutenda kumwake giladi umulelele wana mkulu wako.” ");
INSERT INTO zajp_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ila Onani kavimanya kamba wana wondawavumbuke si wake heyo, avo kila yahachola kuwasa nayo ketila hasi zimbeyu giladi sambiyamulele wana mkulu wake. ");
INSERT INTO zajp_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Mbuli ija imgevuza MNDEWA, avo na heyo kamkoma. ");
INSERT INTO zajp_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Abaho Yuda kamulongela mkwe yake Tamali, “Ukale kamba kizuka muing'anda ya tataako mbaka mwanangu Shela yakule.” Kalonga vino kwavija kadumba siku na heyo kodanganhika kamba wakulu zake. Avo Tamali kachola kukala mng'anda ya tataake. ");
INSERT INTO zajp_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Viibitile milao bwando, mwehe wa Yuda, ija imwana wa Shua, kadanganhika. Yuda viyamambukize kumulilila mwehe wake, heyo na mbwigaake Hila munhu wa Adulamu wachola Timna ako ng'hondolo zake kuwakalile wokanhigwa mijusu. ");
INSERT INTO zajp_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Munhu imwe kamulongela Tamali kamba mkwe yake kakala yochola Timna kuwakanha mijusu ng'hondolo zake. ");
INSERT INTO zajp_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Avo kavula vivalo vake va ukizuka viyakalile yavalile, kaitanda kiziweziwe na kuigalula, abaho kakala hasi hana ulwivi lwa ikiwambo cha Enaimu mnzila ya kuchola Timna, kwavija kona kamba Shela kakula ila halavigwe yawe mtwanzi wake. ");
INSERT INTO zajp_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda viyamuwene, kagiza mtenda ugoni ndwanga, kwavija kaigubika mkihanga. ");
INSERT INTO zajp_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Kamcholela kuja kumgwazo wa inzila na kumulongela, “Izo niwase nagwe,” kwavija Yuda kakala hanavitanga kamba heyo kakala mkwe yake. Na heyo kamuuza, “Niheza kuwasa na gweye kongwelela choni?” ");
INSERT INTO zajp_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Kamulongela, “Nokulagizila mwanamenhe kulawa mkikwama changu.” Na heyo kamulongela, “Nigwelele kinhu kiwe zamana mbaka kipigiti vondaumgale.” ");
INSERT INTO zajp_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Kamulongela, “Zamana ilihi yondanikugwelele?” Kalonga, “Luzabi lwako luli na kitindi kili na utango wako hamoja na fimbo yako.” Avo kamgwelela abaho kawasa nayo, avo kapata inda. ");
INSERT INTO zajp_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Abaho kachola ukae yake, kakisegeza kiziweziwe chake na kuvala kabili vivalo vake va ukizuka. ");
INSERT INTO zajp_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Mkipigiti kidodo hamwande, Yuda kamtuma mbwigaake Hila yamsole ija imenhe yakamgwelele ija imtwanzi na kuvisola vija ivinhu viyamgwelele ija imtwanzi kamba zamana, ila Hila ham'vikile ija imtwanzi. ");
INSERT INTO zajp_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Kawauza wanhu wakalile wokala haja Enaimu, “Kakwahi ija imtenda ugoni ndwanga yakalile hano hamgwazo wa inzila?” Wamulongela, “Hano hakukalile na mtenda ugoni ndwanga.” ");
INSERT INTO zajp_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Avo kabweleganya ha Yuda na kulonga, “Sim'vikile. Wanhu wa haja walonga kamba haja hakukalile na mtenda ugoni ndwanga.” ");
INSERT INTO zajp_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda kamwidika, “Natumulekele vija ivinhu viwe vake, kamba hatutendile hivo wanhu wokwiza kutuseka. Nimgalila menhe ino, ila hum'vikile.” ");
INSERT INTO zajp_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Viibitile milenge midatu, Yuda kalongeligwa, “Mkwe yako Tamali katenda ugoni ndwanga, na sambi kana inda.” Yuda kalonga, “Mulaveni hanze mumsome moto mbaka yadanganhike.” ");
INSERT INTO zajp_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Viwakalile womulava hanze, katuma usenga ha mkwe yake kalonga, “Munhu mwene vinhu vino iyo yangwelele inda ino,” abaho kongeza, “Lola, kokitambula kitindi kino na luzabi luno na fimbo ino va munhu yalihi.” ");
INSERT INTO zajp_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda kavitambula na kulonga, “Heyo katenda galumbile kunibanza nie, kwavija nie simgwelele mwanangu Shela yamsole.” Avo Yuda hawasile nayo kabili. ");
INSERT INTO zajp_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kipigiti cha kulela vikivikile, kakala na wana ubasa wa kimbigalo muinda yake. ");
INSERT INTO zajp_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Viyakalile yolela mwana, imwe kalava hanze mkono wake, ija imng'hunga kasola luzi ludung'hu na kulufunga mumkono wake na kulonga, “Ino iyo yasongile kulawa.” ");
INSERT INTO zajp_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ila viyaubwezile mgati mkono wake, miyage kavumbuka, ija imng'hunga kalonga, “Vino vivo vuuitulile nzila mwenyego.” Avo kakemigwa twaga da Pelezi. ");
INSERT INTO zajp_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Abaho ija imwana yakalile yafungigwe luzi ludung'hu mumkono wake kavumbuka na kagweleligwa twaga dikemigwa Zela. ");
INSERT INTO zajp_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Usufu kasoligwa mbaka Misili. Potifa Mmisili, ayo yakalile imwe wa wakulu wa silikali, ayo vivija yakalile kilangizi wa wemilizi wa ng'anda ya Falao, mndewa wa Misili, kamgula kulawa ha Wasumaili, awo wakalile wamgalile haja. ");
INSERT INTO zajp_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","MNDEWA kakala na Usufu na kakala yammoteze m'vinhu vose viyatendile, kakala yokala mng'anda ya Potifa. ");
INSERT INTO zajp_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifa viyonile kamba MNDEWA ka hamoja na Usufu na kamba MNDEWA kammoteza mkila kinhu kiyatendile, ");
INSERT INTO zajp_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","mbuli ino imnogela ng'hani Potifa avo kamtenda yawe mtumigwa wake heyo mwenyego. Potifa kamtenda Usufu kuwa mkulu wa ng'anda yake yose na kavika vinhu vake vose hasi yake heyo. ");
INSERT INTO zajp_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Songela kipigiti kiyamtendile heyo kuwa mkulu wa ng'anda yake yose na vinhu vake vose, MNDEWA kaimoteza ng'anda yose ya Potifa sama ya Usufu. Motelo za MNDEWA zikala uchana ya vinhu vose viyakalile navo Potifa, vinhu vikalile mng'anda na vikalile mmigunda. ");
INSERT INTO zajp_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Avo kila kinhu kiyakalilenacho Potifa kakika hasi ya wimilizi wa Usufu. Potifa hasang'hanike na kinhu chochose ila mandia gayadile. Usufu kakala yalumbigwe vinogile na kakala yanogile mmeso ga wanhu. ");
INSERT INTO zajp_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Vikibitile kipigiti kidodo, mtwanzi wa Potifa kamulola Usufu na kulonga, “Izo uwase na nie!” ");
INSERT INTO zajp_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ila heyo kalema na kumulongela, “Mndewa wangu hasang'hanika na kinhu chochose mng'anda ino, ila nie, kwavija nie kanika niwe mkulu wa vinhu vose viyalinavo. ");
INSERT INTO zajp_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Haduhu munhu yali mkulu mng'anda ino kunibanza nie. Na hanizuilile kinhu chochose ila gweye, kwavija gweye kwa mwehe wake, nitendeze mbuli ino ihile, nimtendele vilozo Mulungu?” ");
INSERT INTO zajp_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Kamnanahila Usufu mianza bwando, ila heyo kalema kuwasa nayo na hata kumkwenhukila. ");
INSERT INTO zajp_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Zua dimwe Usufu kengila mng'anda kutenda sang'hano zake, na haduhu mtumigwa yoyose wa mng'anda yakalile muja mng'anda. ");
INSERT INTO zajp_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Mtwanzi wa Potifa kamgoga mkivalo chake na kulonga, “Izo uwase na nie!” Ila kakileka kivalo chake mumkono wake na kukimbila hanze. ");
INSERT INTO zajp_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Viyonile kamba kaleka kivalo chake mumkono wake na kukimbila hanze, ");
INSERT INTO zajp_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","kawakema watumigwa zake wa mng'anda na kuwalongela, “Loleni, mbigalo wangu kamgala Mueblania ino yeze kutugela kinyala! Kaningilila mng'anda giladi yawase na nie, avo nitoa nyangi, ");
INSERT INTO zajp_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","na viyanihulike notoa nyangi, kakileka kivalo chake hamgwazo wangu, kakimbila na kulawa hanze.” ");
INSERT INTO zajp_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Avo ija imtwanzi kakileka kivalo cha Usufu hamgwazo wake mbaka mbigalo wake viyabwelile. ");
INSERT INTO zajp_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Abaho kamulongela vino, “Ija inyakadala wa Kieblania yuutugalile keza kumwangu nie kunigela kinyala. ");
INSERT INTO zajp_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ila vunitoile nyangi, kaleka kivalo chake hamgwazo wangu, kakimbila na kulawa hanze.” ");
INSERT INTO zajp_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potifa viyahulike gaja gayamsimulile mtwanzi wake, vija Usufu viyamtendele mtwanzi wake, kona lusango ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Potifa kamsola Usufu na kumwasa mkifungo, hanhu hawakalile wafungigwa wa mndewa wofungigwa, kakala himo mkifungo. ");
INSERT INTO zajp_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ila MNDEWA kakala na Usufu na kumulagusila noge dilekile kuhungula, kamgwelela mhome ya kunogelwa na mkulu wa ikifungo. ");
INSERT INTO zajp_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ija imkulu wa ikifungo kamtenda Usufu kuwa mkulu wa wafungigwa wose na kilangizi wa mbuli zose zitendeke muja mkifungo. ");
INSERT INTO zajp_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ija imkulu wa ikifungo hasang'hanike na kinhu chochose kikigwe mmakono ga Usufu, kwavija MNDEWA kakala hamoja na heyo, na kutenda kila kinhu kiyatendile Usufu kinoge. ");
INSERT INTO zajp_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Vugabitile mazua madodo hamwande, munhu yakalile mkulu wa waja womgomela ung'waji Falao, mndewa wa Misili, na ija yakalile mkulu wa waja womokela mikate, wamgevuza mkulu wao, Falao. ");
INSERT INTO zajp_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Falao kagevuzigwa ng'hani na wakulu wano wabili, mkulu wa waja womgomela ung'waji na mkulu wa waja womokela mikate, ");
INSERT INTO zajp_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","na kawagela mkifungo muing'anda ya mkulu wa wemilizi amo mwayakalile yafungigwe Usufu. ");
INSERT INTO zajp_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Wakala muja mkifungo mkipigiti kitali, ija imkulu wa wemilizi kamsagula Usufu yawe mtumigwa wao. ");
INSERT INTO zajp_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Kilo imwe ija imkulu wa waja womgomela ung'waji mndewa na ija imkulu wa waja womokela mikate mndewa walota nzozi muja mkifungo, na kila nzozi ikala na nhegulo yake. ");
INSERT INTO zajp_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Imitondo iyagwe Usufu viyawakwenhukile, kawona wanyunguala. ");
INSERT INTO zajp_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Kawauza, “Habali lelo mnyunguale?” ");
INSERT INTO zajp_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Wamwidika walonga, “Tweye tose tulota nzozi, na haduhu hata munhu imwe yadahile kutapita nhegulo ya nzozi zetu.” Usufu kawalongela, “Si Mulungu yolava udaho wa kutapita nhegulo ya nzozi? Nilongeleni nzozi zenu.” ");
INSERT INTO zajp_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Avo ija imkulu wa waja womgomela ung'waji mndewa kamulongela Usufu nzozi yake, kamulongela, “Mnzozi yangu, nyona mzabibu haulongozi wangu, ");
INSERT INTO zajp_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Na muja mumzabibu kukala na matambi madatu. Kipigiti kikija vuusongile kuzuka, malua gake galika na kulela vikungwi vili na zabibu zipile. ");
INSERT INTO zajp_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kikasi cha Falao kikala mumkono wangu, avo nisola zija zizabibu nizikamulila mkikasi cha Falao na kumgwaa Falao.” ");
INSERT INTO zajp_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Usufu kalonga, “Nhegulo ya nzozi ino iyo ino, matambi madatu gago mazua madatu. ");
INSERT INTO zajp_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mkipigiti cha mazua madatu, Falao kokufungula, na kokubweza hana isang'hano yako, na komgomela mndewa ung'waji kamba vuukalile utenda kipigiti vuukalile mkulu wa waja womgomela ung'waji mndewa. ");
INSERT INTO zajp_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ila mbuli zose zihakucholela goya sambiunisemwe, undagusile unhu, ukanhambule ha Falao siku konilava kulawa mkifungo kino. ");
INSERT INTO zajp_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nie ninyamuligwa bila kulonda kulawa muisi ya Waeblania, na hata hano Misili sitendile kinhu chochose kilumbile nie kugeligwa mkifungo.” ");
INSERT INTO zajp_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ija imkulu wa waja womokela mikate mndewa viyonile kamba Usufu kamulongela mbuli zinogile za nzozi yake, ija imkulu wa waja womgomela ung'waji mndewa kamulongela, “Na nie vivija nilota nzozi, mditwi jangu kukala na vigelo vidatu va mikate. ");
INSERT INTO zajp_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Mkigelo kikalile uchana kukala na namna zose za mandia gokigwe sama ya Falao, ila ndege wagaja gamandia kipigiti vigakalile gang'hali mditwi jangu.” ");
INSERT INTO zajp_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Usufu kalonga, “Ino iyo nhegulo yake, vigelo vidatu vima sama ya mazua madatu. ");
INSERT INTO zajp_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mkipigiti cha mazua madatu, Falao kokufungula, ila kukukanha ditwi jako na kulutungika lukuli lwako mum'biki. Na ndege woija nyama yako.” ");
INSERT INTO zajp_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Zua da ikadatu dikala zua da ng'humbukila ya mvumbuka ya Falao, avo Falao kawatendela lusona watumigwa zake wose, kamfungula mkulu wa waja womgomela ung'waji mndewa na ija imkulu wa waja womokela mikate mndewa na kuwagala haulongozi wa waja iwatumigwa. ");
INSERT INTO zajp_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Kam'bweza msang'hano yake ija mkulu wa waja womgomela ung'waji mndewa, giladi yagendelele kumgwelela Falao kikasi, ");
INSERT INTO zajp_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ila ija imkulu wa waja womokela mikate mndewa kakanhigwa ditwi jake, na lukuli lwake lutungikigwa kamba Usufu viyawatapitile. ");
INSERT INTO zajp_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ila ija imkulu wa waja womgomela ung'waji mndewa kamwisemwa Usufu, hamkumbuke mmbuli yoyose. ");
INSERT INTO zajp_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Viibitile milao mibili, Falao kalota nzozi. Kema hamgwazo wa Lwanda lwa Naili, ");
INSERT INTO zajp_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ng'ombe saba wanenehe tena wanyilibuke wakwela kulawa Mulwanda lwa Naili, wasonga kuja mijani. ");
INSERT INTO zajp_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Abaho ng'ombe wayagwe saba wasokile tena wapunyukile wakwela kulawa Mulwanda lwa Naili hachugu cha waja wa ichanduso, wema behi na waja iwang'ombe wanenehe haja mumgwazo wa Ulwanda lwa Naili, ");
INSERT INTO zajp_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","na waja iwang'ombe wasokile wawaja waja iwang'ombe wanenehe abaho Falao kalamuka. ");
INSERT INTO zajp_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Kawasa kabili na kalota nzozi iyagwe. Masukwe saba ga ngano gakangale tena gazamile gakala mdibelege dimwe. ");
INSERT INTO zajp_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Abaho masukwe gayagwe saba ga ngano gapalatile tena gali fuya gasokezwe na ubeho wa muluwala gazuka. ");
INSERT INTO zajp_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Gaja gamasukwe ga ngano gapalatile gagameza gaja gamasukwe ga ngano gazamile. Falao kalamuka na kavitanga kamba kumbe zikala nzozi. ");
INSERT INTO zajp_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Imitondo yake kagaya ng'hani mmoyo, avo kawakema waja wose wali na nzewele na wahawi wose wa muisi ya Misili. Falao kawalongela nzozi zake, ila haduhu hata imwe yadahile kumulongela nhegulo ya nzozi zake. ");
INSERT INTO zajp_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Abaho ija imkulu wa waja womgomela ung'waji mndewa kamulongela Falao, “Lelo ng'humbuswa gaja ganihonyele. ");
INSERT INTO zajp_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Falao viyakalile na lusango na watumigwa zake, kanigela mkifungo nie hamoja na mkulu wa waja womokela mikate mndewa muing'anda ya mkulu wa wemilizi. ");
INSERT INTO zajp_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kilo imwe tulota nzozi heyo na nie, kila nzozi ikala na nhegulo yake. ");
INSERT INTO zajp_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Mmhale wa Kieblania kakala haja hamoja na tweye, mtumigwa wa mkulu wa wemilizi. Tumulongela nzozi zetu, na heyo katulongela nhegulo zake, kila munhu kamulongela nhegulo ya nzozi yake. ");
INSERT INTO zajp_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Na ilawilila vivija kamba viyatulongele. Nie nibwezigwa kuisang'hano yangu, na ija miyangu katungikigwa.” ");
INSERT INTO zajp_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Avo Falao kawatuma wanhu wamgale Usufu hima, na hima wamgala kulawa mkifungo. Viyamalile kubea na kuvala vivalo viyagwe, keza haulongozi wa Falao. ");
INSERT INTO zajp_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Falao kamulongela Usufu, “Nilota nzozi na haduhu munhu yadahile kunongela nhegulo yake. Ila nihulika kamba gweye uhaihulika nzozi, kodaha kuitapita nhegulo yake.” ");
INSERT INTO zajp_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Usufu kamulongela Falao, “Nie sidaha kuitapita nhegulo ya nzozi yako, ila Mulungu kokugwelela nhegulo yondaikutende upate mulegeho.” ");
INSERT INTO zajp_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Abaho Falao kamulongela Usufu, “Nilota nikala nimile hamgwazo wa Ulwanda lwa Naili, ");
INSERT INTO zajp_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ng'ombe saba wanenehe tena wanyilibuke wakwela kulawa Mulwanda lwa Naili, wasonga kuja mijani. ");
INSERT INTO zajp_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Abaho ng'ombe wayagwe saba wakwela kulawa mulwanda hachugu cha waja wa ichanduso, wasokile, tena wapunyukile. Sinawona ng'ombe wehile kamba wano muisi yose ya Misili. ");
INSERT INTO zajp_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Waja iwang'ombe wasokile tena wapunyukile wawaja waja iwang'ombe saba wanenehe wa ichanduso, ");
INSERT INTO zajp_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ila viwawadile, haduhu munhu yahadahile kuvitanga kamba wawaja kwavija wakala wang'hali wasokile na kupunyukila kamba viwakalile ha ichanduso. Abaho nilamuka. ");
INSERT INTO zajp_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Niwasa kabili abaho nilota masukwe saba ga ngano gakangale tena gazamile gakalile mdibelege dimwe. ");
INSERT INTO zajp_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Na masukwe gayagwe saba gapalatile tena gali fuya gasokezwe na ubeho unyalile kulawa ulawilo wa zua gazuka hachugu cha gaja ga ichanduso, ");
INSERT INTO zajp_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","na gaja gamasukwe gapalatile gagameza gaja gamasukwe gazamile. Ila viniwalongele wahawi, haduhu hata imwe yadahile kunongela nhegulo yake.” ");
INSERT INTO zajp_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Abaho Usufu kamulongela Falao, “Nzozi zino mbili zolonga kinhu kimwe, na zose ziilinga. Mulungu kakugubulila gweye kija choyolonda kukitenda mkipigiti kiguhi hamwande. ");
INSERT INTO zajp_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Waja iwang'ombe saba wanenehe iwo milao saba, na gaja gamasukwe saba gakangale tena gazamile gago milao saba, nzozi zino zolonga kinhu kimwe na zose ziilinga. ");
INSERT INTO zajp_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Waja iwang'ombe saba wasokile na wapunyukile walawilile hachugu cha waja wa ichanduso, na gaja gamasukwe saba gapalatile gasokezwe na ubeho wa ulawilo wa zua, gago milao saba ya nzala. ");
INSERT INTO zajp_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kamba vinikulongele, Mulungu kakulagusila kija choyolonda kukitenda mkipigiti kiguhi hamwande. ");
INSERT INTO zajp_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Kowa na milao saba ya mandia bwando muisi yose ya Misili. ");
INSERT INTO zajp_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ihabita milao ija saba ya mwanduso, kowa na milao saba ya nzala, na milao ija ya mandia bwando yosemwigwa kwavija nzala yogubika isi yose. ");
INSERT INTO zajp_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kipigiti cha mandia bwando chosemwigwa kwavija nzala yondaize yowa mpamanho. ");
INSERT INTO zajp_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nzozi zino mbili zuulotile nhegulo zake mbuli ino isha kusasaligwa na Mulungu na ya mmabehi kulawilila. ");
INSERT INTO zajp_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Avo mina Falao yamsagule munhu mwene ng'hungwe na nzewele ya kwimila isi yose ya Misili. ");
INSERT INTO zajp_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Vivija uwasagule wanhu wayagwe wasole imwe ya tano ya vakuja vose kipigiti cha milao saba ya vakuja bwando. ");
INSERT INTO zajp_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Walagize wakunzanye vakuja vose mkipigiti cha milao ikwiza ya vakuja bwando na wagwelele udaho wa kuvika vakuja mmakano ga mmiwambo na kuvimiliza. ");
INSERT INTO zajp_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Vakuja vino volondigwa vikigwe ngama sama ya isi ino, giladi vidigwe mkipigiti cha milao saba ya nzala chondakize muisi ya Misili, giladi isi sambiigubikwe na nzala.” ");
INSERT INTO zajp_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Falao na salange zake wanogelwa ng'hani na gaja gayalongile Usufu, ");
INSERT INTO zajp_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","avo Falao kawauza wayage, “Tupate kwahi munhu kamba ino, munhu yali na Loho wa Mulungu mgati yake?” ");
INSERT INTO zajp_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Avo Falao kamulongela Usufu, “Kwavija Mulungu kakulagusila gweye gano gose, haduhu munhu iyagwe yali na ng'hungwe na nzewele kamba gweye. ");
INSERT INTO zajp_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Gweye kowa mkulu wa ng'anda yangu, na wanhu zangu wose wotenda gaja gondauwalongele gweye, ila kwavija nie na mndewa, nie niiyeka nowa mkulu kubanza gweye.” ");
INSERT INTO zajp_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Falao kamulongela Usufu, “Lola, nikugwaa ukulu muisi yose ya Misili.” ");
INSERT INTO zajp_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Falao kavula kitindi chake kili na utango kulawa mkidole chake na kukigela mkidole cha Usufu. Kam'vaza kivalo kinogile cha kitani na kumgela mkufu wa zahabu msingo yake. ");
INSERT INTO zajp_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Abaho kamgela mdikwama da mkulu wa isi yali hasi ya Falao, na wanhu watoa nyangi haulongozi wake wolonga, “Fugameni mavindi.” Avo Falao kamtenda Usufu kuwa mkulu wa isi yose ya Misili. ");
INSERT INTO zajp_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Falao kamulongela Usufu, “Nie iyo Falao, muisi yose ya Misili munhu sambiyenule mgulu wake ama mkono wake bila gweye kumulongela.” ");
INSERT INTO zajp_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Falao kamgwaa Usufu twaga da Kimisili dikemigwa Zafenati-Panea, na kamgwaa mwehe yokemigwa Asinati mwanage Potifela, mkulu wa nhambiko wa wambo da Heliopoli. Avo Usufu kapata ukulu muisi yose ya Misili. ");
INSERT INTO zajp_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Usufu kakala na milao malongo madatu kipigiti viyengile msang'hano ya Falao mndewa wa Misili. Usufu kalawa haulongozi wa Falao na kutembela muisi yose ya Misili. ");
INSERT INTO zajp_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Kipigiti cha milao saba ya vakuja bwando, isi ilela vakuja bwando. ");
INSERT INTO zajp_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Usufu kakunzanya vakuja vose vilelile mmilao ija saba ya vakuja bwando muisi ya Misili na kuvika mmakano ga mmiwambo. Kila wambo keka vakuja vihunigwe mmigunda izunguluke wambo dija. ");
INSERT INTO zajp_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Usufu kakunzanya vakuja bwando kamba misenga ya mumgwazo wa bahali, vikala bwando mbaka mheta yake impotela kwavija vikala vibanzile mhima. ");
INSERT INTO zajp_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kipigiti cha milao ya nzala vikikalile hakinalawilila, Usufu kakala na wana wabili iwamulelele Asinati mwanage Potifela mkulu wa nhambiko wa wambo da Heliopoli. ");
INSERT INTO zajp_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Usufu kamgwaa mwanage wa ichanduso twaga dikemigwa Manase, kalonga, “Mulungu kanitenda nie niisemwe migayo yangu yose na wanhu wa ng'anda ya tataangu.” ");
INSERT INTO zajp_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mwanage wa ikabili kamgwaa twaga dikemigwa Eflaim, kwavija kalonga, “Mulungu kangwelela wana muisi ya migayo yangu.” ");
INSERT INTO zajp_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Milao saba ya mandia bwando muisi ya Misili imala, ");
INSERT INTO zajp_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","na milao saba ya nzala isonga kamba Usufu viyalongile. Kukala na nzala muisi ziyagwe zose, ila muisi yose ya Misili kukala na mandia. ");
INSERT INTO zajp_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Nzala viisongile kwingila mwa Wamisili, wanhu wamulilila Falao yawagwelele mandia. Abaho Falao kawalongela Wamisili wose, “Gendeni ha Usufu na mtende gaja gondayawalongele.” ");
INSERT INTO zajp_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nzala vuyenele muisi yose, Usufu kagavugula gamakano na kuwaguzila Wamisili vakuja kwavija nzala ikala mpamanho muisi yose ya Misili. ");
INSERT INTO zajp_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Na wanhu wa isi zose weza Misili kugula mandia ha Usufu, kwavija nzala ikala mpamanho muulumwengu wose. ");
INSERT INTO zajp_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakobo viyahulike kamba kuna mandia Misili, kawalongela wanage, “Habali mgendelela kuilola? ");
INSERT INTO zajp_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nihulika kamba kuna mandia muisi ya Misili, gendeni mkagule giladi sambitudanganhike.” ");
INSERT INTO zajp_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Avo waja iwakulu zake Usufu longo dimwe wachola Misili kugula mandia. ");
INSERT INTO zajp_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ila Yakobo halondile Benjamini mdodo wake Usufu yachole na wayage, kwavija kadumba mbuli zihile zodaha kumvika. ");
INSERT INTO zajp_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Avo wana wa Yakobo wakala mmwanza wa awo wacholile kugula vakuja kwavija vivija nzala ingila muisi ya Kanaani. ");
INSERT INTO zajp_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Usufu kakala mkulu wa isi ya Misili, na heyo iyo yakalile yoguza vakuja ha wanhu wose wa isi ija. Avo wakulu zake Usufu viwavikile, wafugama mavindi wainamila mbaka hasi. ");
INSERT INTO zajp_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Usufu viyawawene wakulu zake, kawatanga ila kaitenda kamba hawatangile, kawauza mkukalika, yowalongela, “Mweye molawa kwahi?” Wamwidika, “Tweye tolawa Kanaani, twiza kugula mandia.” ");
INSERT INTO zajp_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Usufu kawatanga wakulu zake, ila hewo hawamtangile. ");
INSERT INTO zajp_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Abaho kaikumbukila nzozi yake iyawalotile hewo na kuwalongela, “Mweye mwa visepi, mwiza hano kulola hanhu halekile kwimilizwa muisi yetu.” ");
INSERT INTO zajp_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Wamulongela, “Si vivo, mndewa wangu, watumigwa zako twiza hano kugula mandia. ");
INSERT INTO zajp_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tweye tose twa wana wa munhu imwe, watumigwa zako hatuli wavwizi. Tweye hatuli visepi.” ");
INSERT INTO zajp_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Usufu kawalongela, “Si vivo, mwiza hano kulola hanhu halekile kwimilizwa muisi yetu.” ");
INSERT INTO zajp_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Wamulongela, “Watumigwa zako tukala longo dimwe na wabili, wana wa munhu imwe yokala muisi ya Kanaani, ija ikizuwanda kasigala na tataetu, na imwe kadanganhika.” ");
INSERT INTO zajp_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Usufu kawalongela, “Kamba viniwalongele, mweye mwa visepi! ");
INSERT INTO zajp_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Vino vivo vondatuwanamate, noiduila ha Falao, hamchola kumwenu mbaka kizuwanda wenu yavike hano. ");
INSERT INTO zajp_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mtumeni imwe mmwanza wenu yachole kumuwinza kizuwanda wenu. Mweye msigale towagela mkifungo giladi mbuli zenu zumulonga tuzigeze tone kamba molonga kweli ama sio. Kamba si kweli avo noiduila mditwaga da Falao kamba, kweli mweye mwa visepi.” ");
INSERT INTO zajp_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Na kawagela mkifungo wose hamoja mmazua madatu. ");
INSERT INTO zajp_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Mdizua da ikadatu, Usufu kawalongela, “Muhatenda gondaniwalongele, mowa na ugima kwavija nie nomdumba Mulungu. ");
INSERT INTO zajp_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kamba mweye hamuli wavwizi, imwe mmwanza wenu nayakale mkifungo muja mumkalile mweye, na mweye msigale gendeni mkasole vakuja mkawagalile wanhu wa mng'anda yenu awo wene nzala, ");
INSERT INTO zajp_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","na nigalileni kizuwanda wenu hano, giladi yoneke kamba hamnivwizile, na mkutenda avo hamdanganhika.” Watogola kutenda avo. ");
INSERT INTO zajp_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Wakiilongela, “Kweli tolanhigwa sama ya mdodo wetu. Tumona viyakalile yogela bazi, viyakalile yotuyalalila tumonele bazi, ila tweye hatumtegeleze, kino kicho kilamso mgayo uno wiza kumwetu.” ");
INSERT INTO zajp_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Lubeni kawalongela, “Nie siwalongele kamba sambimumtendele gehile imwana? Ila hamunitegeleze! Sambi topata maliho ga mulopa wake.” ");
INSERT INTO zajp_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Hawavitangile kamba Usufu kakala yowahulika avija viyakalile yolonga nao kubitila mtapita. ");
INSERT INTO zajp_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Usufu kainega na hewo na kusonga kulila, abaho kabweleganya na kulonga nao kabili. Kamsola Simioni na kumfunga hameso gao. ");
INSERT INTO zajp_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Usufu kawalagiza watumigwa zake wagamemeze vakuja magunia gao, na wawabwezele hela zao mmagunia gao, na wawagwelele mhamba. Na gano gose watendeligwa. ");
INSERT INTO zajp_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Avo waja iwakulu zake Usufu wakweleza vakuja vao mmhunda zao na kuchola. ");
INSERT INTO zajp_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Kilo viingile wema, imwe mmwanza wao kafungula gunia jake yasole mandia yamgwelele mhunda wake, kona hela zake hamulomo wa gunia jake. ");
INSERT INTO zajp_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Kawalongela wandugu zake, “Hela zangu zibwela azino hano mdigunia jangu.” Mioyo yao ibogoyoka wakiihindukila kuno wogudema, wolonga, “Kinhu chaki kino Mulungu kiyatutendele?” ");
INSERT INTO zajp_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Viwavikile ha Yakobo tataao muisi ya Kanaani, wamulongela gose gawalawilile. Wamulongela, ");
INSERT INTO zajp_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Munhu imwe yali mkulu wa isi yose ya Misili katulonga mkutukalikila na katutenda kamba vija tweye tukala tucholile kuisepa isi yao. ");
INSERT INTO zajp_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ila tweye tumulongela, ‘Tweye hatuli wavwizi, tweye sio visepi. ");
INSERT INTO zajp_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tweye tukala wanhu longo dimwe na wabili wana wa tata imwe, imwe mmwanza wetu kadanganhika na ikizuwanda kasigala na tataetu ako Kanaani.’ ");
INSERT INTO zajp_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Abaho ija imkulu wa isi katulongela, ‘Vino vivo vondanimtangeni kamba mweye mwa wanhu mulibule wavwizi. Nilekeleni imwe wa ndugu zenu hano na msole mandia mchole mkawagalile wanhu wa mng'anda yenu awo wene nzala. ");
INSERT INTO zajp_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ila nigalileni kizuwanda wenu giladi nivitange kamba mweye sio visepi ila mwa wanhu mulibule uvwizi. Abaho nowabwezela ndugu yenu, na mweye modaha kutenda uchuluzi muisi ino.’ ” ");
INSERT INTO zajp_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Viwakalile wobakula magunia gao, kila munhu kavika kibweta chake cha hela. Hewo na tataao viwaviwene ivibweta va hela, wadumba. ");
INSERT INTO zajp_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yakobo tataao kawalongela, “Molonda niwagize wanangu wose? Usufu kapotela, Simioni kapotela, na sambi molonda kumsola Benjamini. Kila kinhu chochola mbali na vija vinilonda nie!” ");
INSERT INTO zajp_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Abaho Lubeni kamulongela tataake, “Kamba sim'bwezile Benjamini kumwako, basi wakome wanangu wano wabili, mwike mmakono gangu nie na nie nom'bweza kumwako.” ");
INSERT INTO zajp_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ila Yakobo kalonga, “Mwanangu hadaha kuchola na mweye, mkulu wake kadanganhika na heyo iyo yeiyeka yasigale. Kamba gaham'vika gehile mnzila, na uvyele uno unilinao, mong'homa na giogio.” ");
INSERT INTO zajp_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Nzala muisi ya Kanaani ikala mpamanho. ");
INSERT INTO zajp_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Avo viwamambukize kuja mandia gose gawagalile kulawa Misili, tataao kawalongela, “Bweleganyeni Misili mkatugulile kabili mandia.” ");
INSERT INTO zajp_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ila Yuda kamulongela, “Ija imunhu katulongela mkuiduila yolonga, ‘Kamba hamwizile na mdodo wenu, hamchona kihanga changu kabili.’ ");
INSERT INTO zajp_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kamba uhamuleka Benjamini yachole na tweye Misili, tochola kukugulila mandia, ");
INSERT INTO zajp_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ila kamba uhamgomesa, na tweye hatuchola kwavija ija imunhu katulongela, kamba hatucholile na mdodo wetu, hatuchona kihanga chake kabili.” ");
INSERT INTO zajp_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yakobo kalonga, “Habali mngalile mgayo uno mkumulongela ayo imunhu kamba muna mdodo iyagwe?” ");
INSERT INTO zajp_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Wamulongela, “Ija imunhu kakala yotuuzagiza ng'hani, tweye wenyego na mulango wetu, yolonga, ‘Tata wenu yang'hali mgima? Mweye muna mdodo iyagwe?’ Na tweye tumwidika gaja gayakalile youza. Tuhavimanyileze kamba kokwiza kulonga, ‘Mgaleni mdodo wenu hano’?” ");
INSERT INTO zajp_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Abaho Yuda kamulongela Yakobo tataake, “Muleke imwana hamoja na nie tuchole hima, giladi gweye na tweye na wanetu sambitufe nzala. ");
INSERT INTO zajp_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nie mwenyego iyo zamana wa ugima wake. Kamba habwelile, unigoge nie. Kamba sim'bwezile kumwako na kumwika haulongozi wako, mbuli ino noipapa nie milongo yose. ");
INSERT INTO zajp_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kamba tuhalekile kukawa, mkipigiti kino tuhabweleganye Misili mianza mibili.” ");
INSERT INTO zajp_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Yakobo tataao kawalongela, “Kamba mbuli zenyego vivo zili, basi tendeni vino, soleni vinhu vinogile va muisi ino vigeleni m'bahasha zenu mumgalile ija imunhu kamba nhunza, soleni zeli kidogo, uki kidogo, ubane, manemane, jozi, na kungu. ");
INSERT INTO zajp_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Vivija soleni hela mianza mibili ya zija zimcholile nazo haichanduso, kwavija molondigwa m'bweze zija zihela zim'bwezeligwe na kwikigwa mmilomo ya magunia genu, siku wakala wahonyele. ");
INSERT INTO zajp_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Msoleni na ndugu yenu mchole nayo hima ha ija imunhu. ");
INSERT INTO zajp_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Na Mulungu Mwene Mhiko yamtende ija imunhu yawonele mweye bazi, giladi yamulekese ndugu yenu Simioni na Benjamini wabwele hamoja na mweye. Ila kamba nihawagiza wanangu, basi.” ");
INSERT INTO zajp_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Avo waja iwandugu wasola zinhunza na mianza mibili ya zihela za ichanduso wachola Misili hamoja na Benjamini. Wavika Misili na kwima haulongozi wa Usufu. ");
INSERT INTO zajp_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Usufu viyamonile Benjamini ka hamoja na hewo, kamulongela mtumigwa wa ng'anda yake, “Wasole wanhu wano uwagale kung'anda yangu, chinja mng'onyo na uteleke mandia, kwavija wolondigwa kuja mandia hamoja na nie imisi ya lelo.” ");
INSERT INTO zajp_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ija imtumigwa katenda kamba Usufu viyamulongele, kawasola waja iwanhu na kuwagala kung'anda ya Usufu. ");
INSERT INTO zajp_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Viwakalile wogaligwa kung'anda ya Usufu, wakala wodumba ng'hani, wakala wogelegeza wolonga, “Tugaligwa kuno sama ya zija zihela zibwezigwe mmagunia getu mwanza wa ichanduso. Wolonda watuvamhile, na kutuhuma na kututenda tuwe nyakadala na kuwasola mhunda zetu.” ");
INSERT INTO zajp_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Viwavikile halwivi lwa ing'anda ya Usufu, wamcholela ija imtumigwa wa ng'anda ya Usufu, ");
INSERT INTO zajp_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","wamulongela, “Chonde, mndewa, tweye tukala twizile hano mwanza wa ichanduso kugula mandia. ");
INSERT INTO zajp_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ila kilo vikingile twima na vitufungule magunia getu, kila munhu kavika hela yake kiasi kikija hamulomo wa gunia jake. Avo tuzibweza. ");
INSERT INTO zajp_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Vivija twiza na hela ziyagwe za kugula mandia. Hatummanyile yekile hela zetu mmagunia getu.” ");
INSERT INTO zajp_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ija imtumigwa kawalongela, “Sambimdumbe, Mulungu wenu, Mulungu wa tataenu, kawagwelela hela mmagunia genu. Ila zija zihela zimgulile mandia haichanduso nie nizibokela.” Abaho kamulava Simioni na kumgala kuwakalile hewo. ");
INSERT INTO zajp_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ija imtumigwa kawasola waja iwanhu na kuwengiza mng'anda ya Usufu, kawagwaa mazi ga kugela magulu gao na kuwagwelela mandia mhunda zao. ");
INSERT INTO zajp_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Wasasala nhunza zao sama ya Usufu vondayavike kipigiti cha imisi, kwavija wahulika kamba kokwiza kuja na hewo. ");
INSERT INTO zajp_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Usufu viyabwelile ukae, wamgwaa zija zinhunza ziwezile nazo mng'anda, wafugama mavindi, wainamila haulongozi wake mbaka hasi. ");
INSERT INTO zajp_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Kawalamsa abaho kawauza, “Tataenu im'vyele ng'hani imunilongele mpile? Yang'hali mgima?” ");
INSERT INTO zajp_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Wamulongela, “Tata wetu ayo yali mtumigwa wako yang'hali mgima na mpile.” Wafugama mavindi wainamila mbaka hasi haulongozi wake. ");
INSERT INTO zajp_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Abaho Usufu kamulola mdodo wake Benjamini, mwana wa mamaake, kauza, “Ino iyo mdodo wenu ikizuwanda imunilongele? Mulungu yakumoteze, mwanangu.” ");
INSERT INTO zajp_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Abaho Usufu kasegela hima kulawa haja kuno yokona chuhila, Usufu kalawa hanze na kuzahila hanhu ha kulilila. Kachola kugati dilibule munhu na kulila. ");
INSERT INTO zajp_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Viyamalile kunava kihanga chake, kalawa hanze na kaizuila sambiyalile, abaho kalonga, “Goleni gamandia.” ");
INSERT INTO zajp_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Waja wakalile wogola wamgolela Usufu yeiyeka hameza yake, na waja iwandugu zake wawagolela weiyeka hameza yao. Waja Iwamisili wakalile woja na Usufu wakala weiyeka hameza yao, kwavija Wamisili wakala hawaja hamoja na Waeblania sama ya ndagizi za nhamanila yao. ");
INSERT INTO zajp_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Waja iwandugu zake Usufu wakala wakalile mumnhongo kulingana na vija viwavumbuke, songela waichanduso kuvumbuka mbaka waikimambukizo, wokiilola na Usufu. Wakiilola wenyego kwa wenyego kuno wokanganya. ");
INSERT INTO zajp_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Mandia gakala gogoligwa kulawa hameza ya Usufu, ila Benjamini kakala yagoleligwe mianza mitano ya vija viwagoleligwe wayagwe. Avo watenda lusona, wang'wa hamoja na heyo kamba viwalondile wenyego. ");
INSERT INTO zajp_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Usufu kamulagiza mtumigwa mkulu wa ng'anda yake, yomulongela, “Memeza magunia ga wanhu wano vakuja bwando kamba vowodaha kupapa na ika hela ya kila munhu hamulomo wa gunia jake. ");
INSERT INTO zajp_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ika kikasi changu cha feza mdigunia da ija ikizuwanda wao hamoja na hela zake ziyezile nazo kugula vakuja.” Na heyo katenda kamba Usufu viyamulagize. ");
INSERT INTO zajp_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Imitondo ng'hani wandugu zake Usufu walekigwa wachole na zao hamoja na mhunda zao. ");
INSERT INTO zajp_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Viwakalile hawanavika kutali na idiwambo, Usufu kamulongela mtumigwa wake, “Genda ukawakweleleze waja iwanhu na uhawavika walongele, ‘Habali mulihile gehile kwa ganogile? ");
INSERT INTO zajp_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Habali mwibile kikasi cha feza cha mndewa wangu? Kino sio kikasi chayang'wilaga mndewa wangu na kutendela uhokozi? Mtenda mbuli ihile ng'hani.’ ” ");
INSERT INTO zajp_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ija imtumigwa viyawavikile, kawalongela vivija viyamulongele Usufu. ");
INSERT INTO zajp_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Wamulongela, “Habali mndewa wangu yolonga mbuli kamba ino? Mbuli ino na iwe kutali na tweye watumigwa zako, sambitutende mbuli kamba ino! ");
INSERT INTO zajp_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Hata hela zituvikile mmilomo ya magunia getu kuja Kanaani tukubwezela, avo habali twibe madini ga feza ama zahabu kulawa mng'anda ya mndewa wako? ");
INSERT INTO zajp_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kamba imwe wa watumigwa zako yahavikwa nacho nayadanganhike, na tweye wose na tuwe nyakadala wa mndewa wangu.” ");
INSERT INTO zajp_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Na heyo kawalongela, “Vinoga, na iwe kamba vuulongile. Ila ija yondayavikigwe nacho kowa nyakadala wangu, na mweye mose msigale mochola na zenu.” ");
INSERT INTO zajp_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Avo kila munhu mmwanza wao hima kahumulusa gunia jake hasi na kudifungula. ");
INSERT INTO zajp_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Abaho ija imtumigwa wa Usufu kasonga kusakula, kasonga gunia da imkulu wao na kumambukizila da imdodo. Na kija ikakasi kivikigwa mdigunia da Benjamini. ");
INSERT INTO zajp_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Waja iwakulu zake wasigale viwonile vija, wadega vivalo vao mkona bwembwe, abaho wakweleza magunia gao mmhunda zao na kubweleganya mdiwambo. ");
INSERT INTO zajp_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Usufu kakala yang'hali mng'anda kipigiti Yuda na wandugu zake viwakalile wobweleganya, waibwanha hasi haulongozi wake, ");
INSERT INTO zajp_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Usufu kawalongela, “Habali mtendile vino? Ham'vitangile kamba munhu kamba nie nodaha kuvumbula vinhu mkulolesa?” ");
INSERT INTO zajp_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda kalonga, “Tulonge choni kumwako, mndewa, todahaze kuwatenda wanhu watutogole kamba tweye sio wavwizi? Mulungu kavigubula vilozo vetu. Tweye tose twa nyakadala zako, sio ija tu yavikigwe na ikikasi.” ");
INSERT INTO zajp_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Usufu kalonga, “Si vivo! Mbuli ino na iwe kutali na nie, sambinitende mbuli kamba ino. Ija tu yavikigwe na ikikasi iyo yondayawe nyakadala wangu. Mweye msigale gendeni ukae ha tataenu mditindiwalo.” ");
INSERT INTO zajp_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuda kamcholela Usufu na kulonga, “Chonde, mndewa wangu, nileke nie mtumigwa wako nikulongele mbuli imwe gweye mndewa wangu, sambiunyonele lusango kwavija gweye kwa kamba Falao mwenyego. ");
INSERT INTO zajp_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mndewa, gweye kukala utuuzile ulonga, ‘Mweye muna tata ama ndugu iyagwe?’ ");
INSERT INTO zajp_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Na tweye tukwidika, tulonga, ‘Tweye tuna tata m'vyele ng'hani na mdodo wetu mzuwanda yavumbuke muuvyele wake. Mkulu wake kadanganhika, na heyo iyo mwana yeiyeka yasigale mmwanza wa wana wa mamaake, na tataake kamnogela ng'hani.’ ");
INSERT INTO zajp_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Abaho kutulongela tumgale hano kumwako umone na meso gako, ");
INSERT INTO zajp_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","na tweye tukulongela, ‘Havidahika mwana ija kusegela ha tataake, kamba yahasegela, tataake kodanganhika.’ ");
INSERT INTO zajp_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Na gweye kulonga, ‘Kamba hamwizile na mdodo wenu hano, hamuchona kabili kihanga changu.’ ");
INSERT INTO zajp_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Vitubwelile ha mtumigwa wako, ayo yali tataangu, tumulongela gaja gaulongele, mndewa wangu. ");
INSERT INTO zajp_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Na tataetu viyatulongele, ‘Gendeni kabili mkatugulile mandia,’ ");
INSERT INTO zajp_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","tumulongela, ‘Hatuchola, ila kamba mdodo wetu imzuwanda yahachola hamoja na tweye basi tochola, kwavija hatuchona kihanga cha ija imunhu mbaka mdodo wetu imzuwanda yachole hamoja na tweye.’ ");
INSERT INTO zajp_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Abaho mtumigwa wako ayo yali tataangu katulongela, ‘M'vitanga kamba mwehe wangu kandelela nie wana wabili wa kimbigalo. ");
INSERT INTO zajp_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Imwe kapotela, na nie nilonga, “Kadegigwa vidangavidanga na mng'onyo.” Na sinamona songela kipigiti kija. ");
INSERT INTO zajp_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Na kamba muhamsola na ino, gaham'vika gehile na uvyele uno unilinao, mong'homa na giogio.’ ");
INSERT INTO zajp_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Avo kamba tuhabwela ukae ha mtumigwa wako ayo yali tataangu bila mwana ino kuwa hamoja na tweye, na avija ugima wake vuuifungile hamoja na ugima wa mwana ino, ");
INSERT INTO zajp_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","yahona kamba imwana hali hamoja na tweye, kodanganhika, avo tweye watumigwa zako tomkoma na giogio tataetu m'vyele. ");
INSERT INTO zajp_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Kwavija nie mtumigwa wako iyo nisolile zamana ha tataangu nilonga, ‘kamba sim'bwezile kumwako, nie iyo yondaniipape mbuli ino muugima wangu wose.’ ");
INSERT INTO zajp_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Avo nileke nie mtumigwa wako nisigale hano kamba nyakadala wako nisole hanhu ha mwana ino, giladi umuleke ino imwana yabwele ukae na wakulu zake. ");
INSERT INTO zajp_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kwavija nodahaze kubwela ukae ha tataangu kamba ino imwana hali hamoja na nie? Nodumba kona mgayo wondaumpate tataangu.” ");
INSERT INTO zajp_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Usufu hadahile kuizuila haulongozi wa waja wose wemile haulongozi wake, avo kenula dizwi kawalongela watumigwa zake wawasegeze Wamisili wakalile muja mdigati, kalonga, “Wasegezeni hano hamwangu.” Avo haduhu Mmisili yakalile behi na heyo kipigiti viyaitambule ha wandugu zake. ");
INSERT INTO zajp_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Avo kalila na dizwi kulu mbaka Wamisili wahulika, na kuchola kuwalongela wanhu wa ng'anda ya Falao. ");
INSERT INTO zajp_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Usufu kawalongela wandugu zake, “Nie iyo Usufu! Tataangu yang'hali mgima?” Ila wandugu zake hawamwidike, kwavija wadumba. ");
INSERT INTO zajp_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Abaho Usufu kawalongela wandugu zake, “Nikwenhukileni.” Viwakwenhuke, kalonga, “Nie iyo ndugu yenu Usufu, ayo imumguzile hano Misili! ");
INSERT INTO zajp_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Avo sambimdungwedungwe ama kuiyonela lusango sama ya kuniguza nie hano, kwavija Mulungu kanituma nie nilongole kwiza hano sama ya kukombola ugima wa wanhu. ");
INSERT INTO zajp_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kwavija sambi milao mibili ibita songela nzala viingile muisi, na milao mitano ikwiza hakuwa na kulima ama kuhuna. ");
INSERT INTO zajp_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ila Mulungu kanituma niwalongole giladi niwakombole mweye na ukombola mkulu, mweye hamoja na wanenu na kuwatenda wanhu bwando wawe na ugima muisi. ");
INSERT INTO zajp_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Avo sio mweye mungalile nie hano ila Mulungu. Mulungu kanhenda nie niwe tata ha Falao, mkulu wa ng'anda yake yose, na mtawala wa isi yose ya Misili. ");
INSERT INTO zajp_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Avo lopoleni m'bweleganye ha tataangu mkamulongele vino, ‘Vino vivo mwanago Usufu viyolonga, “Mulungu kanitenda nie kuwa mkulu wa isi yose ya Misili, izo sambiukawe. ");
INSERT INTO zajp_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kokwiza kukala hanhu hokemigwa Gosheni behi na nie, gweye, wanago, wazukulu zako, ng'ombe na menhe zako, na vose vuulinavo. ");
INSERT INTO zajp_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Uhavika haja, nie nokugwelela kila kinhu kwavija kuna milao mitano ya nzala ikwiza. Kamba si hivo, gweye na wanhu wa ng'anda yako na waja wose wali hamoja na gweye mofa nzala.” ’ ");
INSERT INTO zajp_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Na sambi meso genu na meso ga mdodo wangu Benjamini gonyona kamba nie iyo Usufu mwenyego. ");
INSERT INTO zajp_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mulongeleni tataangu vija vinihishimilwa ng'hani muisi ya Misili na gose gaja gamonile. Hima mgaleni tataangu hano.” ");
INSERT INTO zajp_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Abaho Usufu kamkumbatila mdodo wake Benjamini msingo na kusonga kulila, na Benjamini vivija kamkumbatila Usufu na kusonga kulila. ");
INSERT INTO zajp_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Usufu kawanonela wandugu zake wose kuno yolila. Viyeshile kutenda vija, wandugu zake wasonga kulongelela nayo. ");
INSERT INTO zajp_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Mbuli zija vuzivikile mng'anda da Falao kamba ndugu zake Usufu weza, Falao na wakulu zake wose wa silikali wanogelwa ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Falao kamulongela Usufu, “Walongele wandugu zako, ‘Tendeni vino, wafungasheni wang'onyo zenu, m'bwele muisi ya Kanaani, ");
INSERT INTO zajp_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","msoleni tataenu hamoja na wanhu wose wali mng'anda yenu mwize kumwangu, nie nowagwelela hanhu hanogile ng'hani muisi ya Misili na monogelwa na udekedeke wa muisi.’ ");
INSERT INTO zajp_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Vivija walongele, ‘Tendeni vino, soleni mikwama kulawa Misili ya kuwapapila wanenu na watwanzi zenu na mumsole tataenu mwize nayo hano. ");
INSERT INTO zajp_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Sambimgese ng'hani mmbuli ya kuvileka vinhu venu, ila kinhu cha kukigesa ng'hani icho kino, Misili yowa yenu mweye.’ ” ");
INSERT INTO zajp_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Wana wa Yakobo, ayo vivija yakemigwe Islaeli, watenda kamba viwalongeligwe na Falao, Usufu kawagwelela mikwama kamba viyalagize Falao abaho kawagwelela mhamba. ");
INSERT INTO zajp_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Vivija kawagwelela kila imwe vivalo va sambi, ila Benjamini kamgwelela vidanga mia ndatu va feza hamoja na vivalo vitano va kusaula. ");
INSERT INTO zajp_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Na kamulagizila tataake mhunda longo dimwe wapapile vinhu vinogile va Kimisili na mhunda longo dimwe wa kitwanzi wapapile vakuja na mikate na mhamba. ");
INSERT INTO zajp_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Abaho kawaleka ndugu zake wachole, viwakalile wochola, kawalongela, “Sambimgombe mnzila.” ");
INSERT INTO zajp_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Wahalawa muisi ya Misili na kuchola ha tataao Yakobo muisi ya Kanaani. ");
INSERT INTO zajp_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Wamulongela tataao, “Usufu yang'hali mgima! Tena heyo iyo mtawala wa isi yose ya Misili.” Yakobo kasinhuka, hatogole gaja gayalongeligwe. ");
INSERT INTO zajp_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ila viwamulongele mbuli zose Usufu ziyawalongele, na viyonile ija imikwama Usufu iyaitumile impape heyo yachole Misili, moyo wa Yakobo usamhuka. ");
INSERT INTO zajp_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Na Yakobo kalonga, “Nokona, kweli mwanangu Usufu mgima. Nochola nikamone kipigiti sinadanganhika.” ");
INSERT INTO zajp_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yakobo kafungasha vinhu vose viyakalile navo na kuchola Beeli-Sheba kulava nhosa ha Mulungu wa tataake Isaka. ");
INSERT INTO zajp_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mulungu kalonga na Yakobo mnzozi kamkema na kulonga, “Yakobo, Yakobo!” Yakobo kedika, “Nie hano.” ");
INSERT INTO zajp_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Mulungu kalonga, “Nie iyo Mulungu wa tataako, sambiudumbe kuchola Misili, kwavija ako nokutenda gweye kuwa undewa mkulu. ");
INSERT INTO zajp_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nie nochola na gweye Misili na nolubweza lukolo lwako kabili muisi ino. Na gweye kodanganhikila mmakono ga Usufu.” ");
INSERT INTO zajp_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Avo Yakobo kasegela Beeli-Sheba. Wanage wamsola Yakobo tataao na wana zao na watwanzi zao wawagela mmikwama iyawagalile Falao. ");
INSERT INTO zajp_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Wasola fugo zao, na vinhu viwakalile navo haja Kanaani. Yakobo na lukolo lwake lose wachola Misili. ");
INSERT INTO zajp_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Kachola hamoja na wanage wa kitwanzi na wa kimbigalo na wazukulu zake wa kitwanzi na wa kimbigalo. Lukolo lwake lose kalugala Misili. ");
INSERT INTO zajp_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Gano gago matwaga ga wana wa Yakobo wacholile Misili. Mwana wa ichanduso wa Yakobo kakala Lubeni. ");
INSERT INTO zajp_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Wana wa Lubeni wakala Hanoki, Palu, Heziloni, na Kami. ");
INSERT INTO zajp_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Mwana iyagwe wa Yakobo kakala Simioni. Wana wa Simioni wakala Yemueli, Yamini, Ohadi, Yakini, Zohali, na Shauli. Shauli kakala mwana iyamulelile na mtwanzi wa Kanaani. ");
INSERT INTO zajp_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Mwana iyagwe wa Yakobo kakala Lawi. Wana wa Lawi wakala Gelishoni, Kohasi, na Melali. ");
INSERT INTO zajp_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Mwana iyagwe wa Yakobo kakala Yuda. Wana wa Yuda wakala Eli, Onani, Shela, Pelezi, na Zela. Ila Eli na Onani wadanganhikila muisi ya Kanaani. Wana wa Pelezi wakala Heziloni na Hamulu. ");
INSERT INTO zajp_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Mwana iyagwe wa Yakobo kakala Isakali. Wana wa Isakali wakala Tola, Puva, Jashubu, na Shimloni. ");
INSERT INTO zajp_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Mwana iyagwe wa Yakobo kakala Zabuloni. Wana wa Zabuloni wakala Seledi, Eloni, na Jaleeli. ");
INSERT INTO zajp_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Wano wao wana wa Lea iyamulelele Yakobo ako Padani-Alamu uhasegeza mndele wake Dina. Mheta ya wanhu wa lukolo lwa Yakobo watwanzi na wambigalo kubitila Lea, wose kwa wose wakala malongo madatu na wadatu. ");
INSERT INTO zajp_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Mwana iyagwe wa Yakobo kakala Gadi. Wana wa Gadi wakala Zifoni, Hagi, Shuni, Eziboni, Eli, Alodi, na Aleli. ");
INSERT INTO zajp_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Mwana iyagwe wa Yakobo kakala Asheli. Wana wa Asheli wakala Imna, Ishiva, Ishivi, Belia, na lumbu jao Sela. Wana wa Belia wakala Hebeli na Malikieli. ");
INSERT INTO zajp_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ino iyo mheta ya wanhu wa lukolo lwa Yakobo kubitila Zilpa, ayo Labani iyamgwelele mwanage Lea yawe mtumigwa wake, wose kwa wose wakala longo dimwe na sita. ");
INSERT INTO zajp_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Usufu na Benjamini wano wao wana wa Yakobo waleligwe na mtwanzi wake yokemigwa Laheli. ");
INSERT INTO zajp_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Manase na Eflaim wakala wana wa Usufu iyamulelele Asinati mwanage Potifela, mkulu wa nhambiko wa wambo da Heliopoli, muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Wana wa Benjamini wakala Bela, Becha, Ashibeli, Gela, Naamani, Ehi, Loshi, Mupim, Hupim, na Adi. ");
INSERT INTO zajp_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ino iyo mheta ya wanhu wa lukolo lwa Yakobo kubitila Laheli, wose kwa wose wakala longo dimwe na wane. ");
INSERT INTO zajp_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mwana iyagwe wa Yakobo kakala Dani. Mwana wa Dani kakala Hushim. ");
INSERT INTO zajp_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Mwana iyagwe wa Yakobo kakala Naftali. Wana wa Naftali wakala Jazeeli, Guni, Jezeli, na Shilem. ");
INSERT INTO zajp_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ino iyo mheta ya wanhu wa lukolo lwa Yakobo kubitila Bilha, ayo Labani iyamgwelele mwanage Laheli yawe mtumigwa wake, wose kwa wose wakala saba. ");
INSERT INTO zajp_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Wanhu wacholile Misili hamoja na Yakobo, awo wakalile wa lukolo lwake Yakobo, uhawalava watwanzi wa wanage, wakala wanhu malongo sita na sita. ");
INSERT INTO zajp_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Uhongeza wana wabili wa Usufu iyawalelile Misili, wanhu wakalile wolawa mulukolo lwa Yakobo wakalile wacholile Misili wakala malongo saba. ");
INSERT INTO zajp_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Viwakalile wokwenhukila kuvika, Yakobo kamtuma Yuda yalongole yachole ha Usufu yakamulagile inzila icholile Gosheni. Viwavikile muisi ya Gosheni, ");
INSERT INTO zajp_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Usufu kengila mdikwama jake na kuchola Gosheni kuiting'hana na tataake Yakobo, viwaiting'hane Usufu kamkumbatila tataake msingo na kulila ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yakobo kamulongela Usufu, “Sambi nihadanganhika, haduhu mbuli kwavija nikona nene mwenyego kamba ung'hali mgima.” ");
INSERT INTO zajp_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Abaho Usufu kawalongela wandugu zake na wanhu wa mulango wa tataake, kalonga, “Nochola nikamulongele Falao kamba ndugu zangu na wose wali mng'anda ya tataangu weza kumwangu kulawa Kanaani. ");
INSERT INTO zajp_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nomulongela kamba wanhu wano wafugaga wang'onyo avo weza na madale gao ga ng'hondolo, menhe, na ng'ombe na kila kinhu kiwalinacho. ");
INSERT INTO zajp_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Avo Falao yahawakema na kuwauza mna sang'hano yaki imtendaga, ");
INSERT INTO zajp_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","mulongeleni kamba, ‘Mazua gose tweye watumigwa zako tochunga wang'onyo, kamba wahenga zetu viwakalile wotenda.’ Mkulonga vino kowaleka mkale muisi ya Gosheni.” Usufu kalonga vino kwavija wanhu wa Misili wakala wawehile ng'hani wachunga wang'onyo sama ya ndagizi za nhamanila yao. ");
INSERT INTO zajp_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Avo Usufu kachola na kumulongela Falao, kalonga, “Tataangu na wandugu zangu hamoja na madale gao ga ng'hondolo na ng'ombe na vinhu vao vose viwali navo weza kulawa Kanaani na sambi wa muisi ya Gosheni hano Misili.” ");
INSERT INTO zajp_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Kawasola wanhu watano mmwanza wa wandugu zake na kuwagala haulongozi wa Falao. ");
INSERT INTO zajp_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Falao kawauza, “Mna sang'hano yaki imtendaga?” Walonga, “Mndewa, tweye twa wachunga wang'onyo kamba viwakalile wotenda wahenga zetu. ");
INSERT INTO zajp_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Twiza kukala muisi ino kwavija kuna iisi ya Kanaani kuna nzala mpamanho, na wang'onyo wa watumigwa zako wabule mijani. Avo tokuyalalila, utuleke watumigwa zako tukale hano Gosheni.” ");
INSERT INTO zajp_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Falao kamulongela Usufu, “Tataako na wandugu zako weza kumwako, ");
INSERT INTO zajp_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","avo sagula hanhu hohose muisi ya Misili hawanogele hewo kukala, mwike tataako na wandugu zako hanhu hanogile ng'hani muna iisi, wagale wakakale muisi ya Gosheni, na kamba kuna wanhu mmwanza wao wali na udaho, watende kuwa wemilizi wa wang'onyo wangu.” ");
INSERT INTO zajp_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Abaho Usufu kamwingiza mng'anda tataake Yakobo, na kumwika haulongozi wa Falao, na Yakobo kammoteza Falao. ");
INSERT INTO zajp_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Falao kamulongela Yakobo, “Kuna milao mingahi songela hauvumbuke?” ");
INSERT INTO zajp_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobo kamulongela Falao, “Milao yangu ya kutembela muisi ivika mia na malongo madatu, milao yangu ikala midodo, imemile migayo, hailingile na milao ya wahenga zangu kipigiti viwakalile wotembela muisi.” ");
INSERT INTO zajp_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Abaho Yakobo kammoteza Falao mwanza wa ikabili na kusegela. ");
INSERT INTO zajp_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Avo Usufu kaweka tataake na ndugu zake muisi ya Misili na kuwagwelela hanhu hanogile muisi ija behi na kiwambo kikemigwa Lamesesi kamba Falao viyalagize. ");
INSERT INTO zajp_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Usufu kawagwelela mandia tataake, ndugu zake, na wose wakalile mng'anda ya tataake, kulingana na mheta ya wana zao. ");
INSERT INTO zajp_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Nzala ikala mpamanho, kukala haduhu mandia muisi yose ya Misili na isi ya Kanaani, na wanhu wasonga kunyolila sama ya nzala. ");
INSERT INTO zajp_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Wanhu kulawa Misili na kulawa Kanaani viwakalile wogula vakuja, Usufu kazikunzanya hela zose na kuzigala kung'anda ya Falao. ");
INSERT INTO zajp_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Hela za wanhu wa Misili na za wanhu wa Kanaani vuzimalile, wanhu wose wa Misili weza ha Usufu na kumulongela, “Tugwelele mandia. Habali tudanganhike hameso gako? Kwavija hela zetu zose zimala.” ");
INSERT INTO zajp_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Usufu kawedika, “Kamba hela zenu zimala, basi natuibadilishe, ngweleleni wang'onyo zenu wa kufuga, na nie nowagwelela mandia.” ");
INSERT INTO zajp_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Avo wagala wang'onyo zao wa kufuga ha Usufu, na heyo kawagwelela mandia mkuibadilisha na falasi, ng'hondolo, menhe, ng'ombe, na mhunda. Avo mulao uja kawagwelela wanhu mandia mkuibadilisha na wang'onyo zao wose wa kufuga. ");
INSERT INTO zajp_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mulao uja umala, vuusongile mulao uyagwe, wamwizila na kulonga, “Hatudaha kumfisa mndewa wetu kweli ino, kamba, hela zetu zimala, na wang'onyo zetu wa mmakono gako, twabule kinhu kisigale ila ng'huli zetu na migunda yetu. ");
INSERT INTO zajp_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Habali tweye tudanganhike hameso gako na migunda yetu ibanangike? Tugule tweye hamoja na migunda yetu mkutubadilisha na mandia. Tweye hamoja na migunda yetu towa nyakadala wa Falao. Tugwelele mbeyu giladi sambitudanganhike, na migunda yetu sambiigaluke luwala.” ");
INSERT INTO zajp_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Avo Usufu kamgulila Falao migunda yose ya Misili. Wamisili wose waguza migunda yao, kwavija nzala ikala mpamanho na migunda yose ikala ya Falao. ");
INSERT INTO zajp_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Na wanhu wose kulawa ng'ambu imwe ya isi mbaka ng'ambu iyagwe ya isi kawatenda kuwa nyakadala. ");
INSERT INTO zajp_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Migunda ilekile kuguligwa ikala migunda ya wakulu wa nhambiko kwavija wakulu wa nhambiko wakala wobokela mandia kulawa ha Falao, avo wakala bule kilamso cha kuguzila migunda yao ");
INSERT INTO zajp_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Usufu kawalongela wanhu, “Loleni, lelo niwagula mweye hamoja na migunda yenu muwe wa Falao, zino hano mbeyu, soleni mkahande mmigunda. ");
INSERT INTO zajp_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Kipigiti cha kuhuna kihavika, molondigwa mumgwelele Falao fungu dimwe kulawa mmafungu matano ga vakuja na mafungu mane gasigale msole mweye mkeke mbeyu na gawe mandia genu mweye na wanhu wose wali nzing'anda zenu hamoja na wanenu.” ");
INSERT INTO zajp_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Wamulongela, “Mndewa, gweye kuukombola ugima wetu na kututendela ganogile, na tweye towa nyakadala wa Falao.” ");
INSERT INTO zajp_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Avo Usufu kaditenda dija diwe lagizo da isi muisi yose ya Misili, na lagizo dino dosang'hanika mbaka lelo, kamba fungu dimwe kulawa mmafungu matano dochola ha Falao, na migunda ya wakulu wa nhambiko iyo iiyeka ilekile kuwa migunda ya Falao. ");
INSERT INTO zajp_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Waislaeli wakala muisi ya Misili hanhu hokemigwa Gosheni, aho kuwapatile ugoli na kuwa na wana bwando na kongezeka ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobo kakala muisi ya Misili milao longo dimwe na saba, avo milao ya Yakobo yose kwa yose ikala mia na malongo mane na saba. ");
INSERT INTO zajp_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kipigiti cha Yakobo kudanganhika vukikwenhuke, kamkema mwanage Usufu na kumulongela, “Kamba kweli nie ningila mmoyo wako, ika mkono wako hasi ya haza jangu uniduilile kamba konitendela galibule uzenzeleganye na gali kweli kamba hunizika muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Nihadanganhika, unisegeze hano muisi ya Misili ukanizike kuwazikigwe wahenga zangu.” Usufu kamwidika, yolonga, “Notenda kamba vowolonga.” ");
INSERT INTO zajp_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakobo kamulongela Usufu, “Niduilile kamba kotenda avo.” Avo Usufu kamduilila Yakobo. Abaho Yakobo kainamila mulusazi lwake. ");
INSERT INTO zajp_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Mazua madodo hamwande, Usufu kalongeligwa kamba tataake kolumwa, avo Usufu kawasola wanage wabili Manase na Eflaim na kuchola nao ha tataake. ");
INSERT INTO zajp_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yakobo viyalongeligwe kamba, “Mwanago Usufu kabaha,” kaigagahiza, kenuka, kakala mulusazi. ");
INSERT INTO zajp_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakobo kamulongela Usufu, “Mulungu Mwene Mhiko kandawilila nie hanhu hokemigwa Luzi, kuna iisi ya Kanaani, na kunimoteza, ");
INSERT INTO zajp_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","na kunilongela, ‘Nokugwelela wana bwando na kulongeza lukolo lwako. Nowatenda mweye kuwa wanhu bwando, na isi ino nolugwelela lukolo lwako iwe yao milongo yose.’ ” ");
INSERT INTO zajp_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakobo kagendelela, “Avo wanago wabili wavumbuke muisi ino kipigiti sinakwiza hano wowa wangu nie, Eflaim na Manase wowa wangu nie kamba viwali Lubeni na Simioni. ");
INSERT INTO zajp_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Wana wondawavumbuke hachugu chao wowa wako gweye, na wopata uhazi kubitila wakulu zao, Eflaim na Manase. ");
INSERT INTO zajp_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kipigiti vunikalile nibwela kulawa Padani, Laheli kadanganhika muisi ya Kanaani kipigiti vutukalile tung'hali mnzila behibehi na Eflati. Avo nimzika mumgwazo wa inzila ichola Eflati.” Eflati dijo wambo da Betelehemu. ");
INSERT INTO zajp_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Yakobo viyawonile wana wa Usufu, kalonga, “Kina nani wano?” ");
INSERT INTO zajp_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Usufu kamulongela tataake, “Wano iwo wanangu Mulungu iyanigwelele hano, muisi ya Misili.” Yakobo kalonga, “Wagale hano hamwangu niwamoteze.” ");
INSERT INTO zajp_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Meso ga Yakobo gakala gavulale sama ya ulazi, na hadahile kulola goya. Avo Usufu kawagala wanage behi na heyo, na tataake kawanonela na kuwakumbatila. ");
INSERT INTO zajp_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Yakobo kamulongela Usufu, “Sitamanile kona kihanga chako kabili, ila sambi Mulungu kanhenda niwone na wanago.” ");
INSERT INTO zajp_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Abaho Usufu kawasegeza wanage kulawa hana gamahaza ga tataake, kafugama mavindi kainamila mbaka hasi. ");
INSERT INTO zajp_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Usufu kawasola wanage wabili, na kumwika Eflaim kumkono wa ukumoso wa Yakobo na Manase kumkono wa ukulume. ");
INSERT INTO zajp_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ila Yakobo kagagombekeza makono gake kawika mkono wake wa ukulume mditwi da Eflaim ayo yakalile imdodo, na mkono wake wa ukumoso mditwi da Manase ayo yakalile imkulu. ");
INSERT INTO zajp_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Abaho kammoteza Usufu na kulonga, “Mulungu yakalile yotambikilwa na Ablaham na Isaka, wahenga zangu, Mulungu yakalile mchunga wangu mkipigiti chose mbaka lelo, ");
INSERT INTO zajp_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","msenga wa Mulungu wa kuulanga yanikombole nie mmigayo yose, yawamoteze wamhale wano. Watende twaga jangu na matwaga ga wahenga zangu Ablaham na Isaka gagendelele kutangigwa. Wapate wana bwando wongezeke ng'hani muisi.” ");
INSERT INTO zajp_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Usufu viyonile kamba tataake keka mkono wake wa ukulume mditwi da Eflaim, hanogelwe, avo kageza kuusegeza mkono wa tataake mditwi da Eflaim yawike mditwi da Manase, ");
INSERT INTO zajp_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Usufu kamulongela tataake, “Sio hivo, tataangu, kwavija ino iyo imkulu, ika mkono wako wa ukulume mditwi da ino.” ");
INSERT INTO zajp_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ila tataake kalema na kulonga, “Novimanya, mwanangu, novimanya. Manase vivija kowa munhu wa wanhu bwando, na heyo vivija kowa munhu mkulu. Ila mdodo wake kowa mkulu ng'hani kum'banza heyo, na lukolo lwake lowa madale ga ndewa.” ");
INSERT INTO zajp_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Avo zua dija kawamoteza, yolonga, “Waislaeli wogatambula matwaga genu kipigiti cha kumoteza, wolonga, ‘Mulungu yawatende mweye kamba Eflaim na Manase.’ ” Mkutenda vino, Yakobo kamwika Eflaim haulongozi wa Manase. ");
INSERT INTO zajp_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Abaho Yakobo kamulongela Usufu, “Nie na mmabehi kudanganhika, ila Mulungu kowa hamoja na mweye na kowabweza kabili kuna iisi ya wahenga zenu. ");
INSERT INTO zajp_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Hamgwazo wa gaja ganiwagwelele ndugu zako, nokugwelela gweye isi ya Shekemu kamba nyongeza, isi ili na udeke iniisolile na mhinde na zele jangu kulawa ha Waamoli.” ");
INSERT INTO zajp_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Abaho Yakobo kawakema wanage na kulonga, “Nikwenhukileni niwalongele gaja gondagawalawilile mmazua ga hamwande. ");
INSERT INTO zajp_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Iduganyeni hamoja mtegeleze, mweye wana wa Yakobo. Mtegelezeni tataenu, Islaeli. ");
INSERT INTO zajp_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Lubeni, gweye iyo mwanangu wa udele, gweye iyo mhiko yangu na mwana wa ichanduso wa umhale wangu. Gweye iyo mkulu kubanza wose, na kuna mhiko kuwabanza wose. ");
INSERT INTO zajp_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Gweye kwa kamba mmemo wa mazi, ila hauwa wa ichanduso tena, kwavija gweye kuwasa na mtwanzi wangu wa kunze, na kulunyolodosa lusazi lwa tataako. ");
INSERT INTO zajp_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simioni na Lawi hewo iwo ndugu, mizele yao iyo via va kutendela ukaini. ");
INSERT INTO zajp_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Siilumba hamoja nao kipigiti wahanyong'onya, ama kuwa hamoja nao mmiting'hano yao, kwavija sama ya lusango lwao, wawakoma wanhu, na kuwagela ulemale ng'ombe sama ya mchezo. ");
INSERT INTO zajp_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ndukumiza na iwe mulusango lwao, kwavija lukali ng'hani, ndukumiza na iwe mng'hasilika zao, kwavija wana ng'hasilika ya kikaini. Ng'holo zao nozipwililisila mwa wanhu wa lukolo lwangu, nozipwililisila muisi yose ya Islaeli. ");
INSERT INTO zajp_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yuda, wandugu zako wokuyenzi, mkono wako wowa msingo ya wadumuka zako. Wandugu zako wokufugamila mavindi na kukwinamilila. ");
INSERT INTO zajp_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, mwanangu, ka kamba mwana simba, kovikoma vija voyopelemba na kuvibweza ukae yake, kokiigolosa na kutambalala. Haduhu munhu yogeza kumgaza. ");
INSERT INTO zajp_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Fimbo ya kindewa haisegela mumkono wa Yuda, na fimbo ya kindewa haisegela hana gamagulu gake, mbaka vondayeze ayo mwene fimbo yake, ayo yondayahishimilwe na ndewa zose. ");
INSERT INTO zajp_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Komfunga mwana mhunda wake mmizabibu, hana imizabibu inogile ng'hani, kosuluza vivalo vake mdivai ndung'hu ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Meso gake madung'hu kubanza divai, meno gake mazelu kubanza matombo. ");
INSERT INTO zajp_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zabuloni kokala behi na mgwazo wa bahali, na hanhu hoyokala heyo howa bandali, undewa wake wovika kutali mbaka wambo da Sidoni. ");
INSERT INTO zajp_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakali kowa kamba mhunda mwene mhiko, yatambalale hagatigati ya misogi yake, ");
INSERT INTO zajp_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","kuno yohalola haja hayatambalale vihanogile, na vija ija iisi viinogile. Avo koganamiza maega gake yaipape imisogi, na koigagahiza kusang'hanika kamba nyakadala. ");
INSERT INTO zajp_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dani kowa mtawala wa wanhu zake. Wowa kamba mitala iyagwe ya Islaeli. ");
INSERT INTO zajp_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani kowa kamba nyoka hamgwazo wa idigwang'wando, nyoka yali na sumu hamgwazo wa inzila, yomulumiza falasi mkisiginho, avo ija yali uchana ya ifalasi kolagalila kukisogo. ");
INSERT INTO zajp_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Noubeta ukombola wako, MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gadi kovamhilwa na mibokonyi, ila heyo kowavamhila m'visiginho vao. ");
INSERT INTO zajp_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Migunda ya Asheli yolava vakuja bwando, kowa na mandia ga kuimemeza ng'anda ya mndewa. ");
INSERT INTO zajp_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftali iyo mnokela yailegehe, yolela wana wanogile. ");
INSERT INTO zajp_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Usufu ka kamba m'biki ulelile mujo, uli behi na nzokwe, matambi gake gokwela hata kukibanza kiwambaza. ");
INSERT INTO zajp_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Wadumuka zake wam'vamhila na lusango, wamwasila misale na kumgaza ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ila mhinde yake igendelela kuwa na mhiko, na makono gake gagangamala, sama ya Mulungu wa Yakobo Mwene Mhiko, ayo vivija yokemigwa Mchunga, Dibwe da Islaeli. ");
INSERT INTO zajp_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Mulungu wa tataako inimtambikila nie yakutaze, Mulungu Mwene Mhiko yakumoteze, kokumoteza motelo za mvula kulawa uchana, na mazi bwando kulawa hasi ya isi, motelo za wang'onyo wofugigwa na wana. ");
INSERT INTO zajp_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Motelo za tataako ng'hulu, kubanza motelo za migongo ya umwaka, zovika kuna zisota za ivigongo va gunge na gunge. Motelo zino zose nazikale mditwi da Usufu, ayo yali mndewa hagatigati ya ndugu zake. ");
INSERT INTO zajp_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamini ka kamba mbwizi mkali, imitondo na ichungulo kogoga na kuja.” ");
INSERT INTO zajp_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ino iyo mitala longo dimwe na mibili ya Islaeli, na gano gago gayalongile tataao kipigiti viyakalile yowalaga. Kammoteza kila imwe na motelo ziwalingile. ");
INSERT INTO zajp_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Abaho Yakobo kawalongela wanage, “Nie na mmabehi kudanganhika. Mnizike hamoja na wahenga zangu muimhango, mumgunda wa Efloni ija Imuhiti, ");
INSERT INTO zajp_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","mhango ili mumgunda wa Makipela, behi na Mamle kuja Kanaani. Mhango iyagulile Ablaham kulawa ha Efloni Muhiti, hamoja na umgunda hawe hanhu ha kuzikila. ");
INSERT INTO zajp_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Kuja kuyazikigwe Ablaham hamoja na mtwanzi wake Sala, haja kuwazikigwe Isaka na mtwanzi wake Lebeka, na haja baho hanimzikile Lea. ");
INSERT INTO zajp_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Mgunda uja, uli na mhango mgati yake, uguligwa kulawa ha Muhiti.” ");
INSERT INTO zajp_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakobo viyamambukize kulava ndagizi zino ha wanage, kakunza magulu gake mkisazi, kadanganhika na kuilumba hamoja na wahenga zake. ");
INSERT INTO zajp_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Usufu kainamilila kukihanga cha tataake na kumkumbatila, kamulilila na kumnonela. ");
INSERT INTO zajp_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Abaho Usufu kawalagiza waganga wake wam'bake tataake dawa giladi sambiyole, avo waja iwaganga wam'baka Yakobo dawa ya kuzuila kola. ");
INSERT INTO zajp_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Wam'baka dawa ija mmazua malongo mane, kwavija kino kicho kipigiti kilondigwa kubakigwa dawa munhu yadanganhike. Wamisili wamulilila Yakobo mmazua malongo saba. ");
INSERT INTO zajp_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Mazua ga kumulilila Yakobo vugamalile, Usufu kawalongela wakulu wa ng'anda ya Falao, “Nowayalalila, soleni usenga uno mumgalile Falao, ");
INSERT INTO zajp_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Tataangu viyakalile behi na kudanganhika, kanilongela nimduilile kamba nomzika mdipanga diyahimbile muisi ya Kanaani. Avo nileke nichole nikamzike tataangu abaho nobwela.’ ” ");
INSERT INTO zajp_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Falao kamulongela, “Genda ukamzike tataako kamba vuumduilile kamba kotenda avo.” ");
INSERT INTO zajp_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Avo Usufu kachola kumzika tataake. Kasindikizigwa na watumigwa wose wa Falao hamoja na wakulu wose wa ng'anda ya Falao na wakulu wose wa isi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Vivija Usufu kawasola watumigwa wose wa ng'anda yake na wandugu zake na wanhu wose wakalile mng'anda ya tataake. Ila wana zao, madale gao ga ng'hondolo, na madale ga ng'ombe zao wao wasigale Gosheni. ");
INSERT INTO zajp_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Waja wogala mikwama na wakwela falasi vivija wachola hamoja na heyo. Dikala dale kulu ng'hani da wanhu. ");
INSERT INTO zajp_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Viwavikile hana ulubuga lwa kwanikila ngano lukemigwa Atadi, lukalile ng'ambu ya ulawilo wa zua wa Lwanda lwa Yolodani, wagegemeza na dizwi kulu na usungu mkulu ng'hani umemile giogio, Usufu kakala haja mkipigiti cha mazua saba yomulilila tataake. ");
INSERT INTO zajp_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Wenekae wa Kanaani viwonile kililo kija haja halubuga lwa kwanikila ngano lukemigwa Atadi, walonga, “Wamisili wana mting'hano wa kililo.” Kino kicho kilamso hanhu haja behi na Yolodani hokemigwa Abeli-Misili. ");
INSERT INTO zajp_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Wana wa Yakobo watenda kamba viyawalagize, ");
INSERT INTO zajp_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","wampapa Yakobo mbaka kuisi ya Kanaani na kumzika muimhango, mumgunda wa Makipela behi na Mamle, awo Ablaham uyaugulile kulawa ha Efloni Muhiti, hawe hanhu ha kuzikila. ");
INSERT INTO zajp_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Usufu viyeshile kumzika tataake, kabweleganya Misili hamoja na wandugu zake na waja wose wacholile na heyo kumzika tataake. ");
INSERT INTO zajp_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Wakulu zake Usufu viwonile kamba tataao kadanganhika, walonga, “Yowaze ihawa Usufu yang'hali na lusango na tweye, na yahagelegeza kutubwelezela mbuli zose zihile zitumtendele?” ");
INSERT INTO zajp_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Avo wamgalila usenga Usufu, wolonga, “Kipigiti tataetu hanadanganhika katulongela, ");
INSERT INTO zajp_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","tukugalile usenga uno, ‘Wagele kumgongo wakulu zako gehile gose gawakutendele.’ Avo tugele kumgongo sama ya gehile gose gatukutendele tweye, watumigwa wa Mulungu wa tataako.” Usufu viyahulike gano kalila ng'hani. ");
INSERT INTO zajp_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Abaho wakulu zake weza waibwanha hasi haulongozi wake, na kulonga, “Tweye twa nyakadala zako.” ");
INSERT INTO zajp_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ila Usufu kawalongela, “Sambimdumbe, nie na Mulungu mbaka niwataguse? ");
INSERT INTO zajp_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Hata kamba mweye mgesa gehile, ila Mulungu kagesa ganogile, giladi ugima wa wanhu bwando sambiubanangike kamba voyotenda sambi. ");
INSERT INTO zajp_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Avo sambimdumbe, nie nowagwelela mandia mweye hamoja na wanenu.” Mkulonga mbuli zino zilimwilile, kawahoza imioyo. ");
INSERT INTO zajp_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Avo Usufu kagendelela kukala muisi ya Misili, heyo hamoja na wanhu wa ng'anda ya tataake. Usufu kakala milao mia na longo dimwe. ");
INSERT INTO zajp_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Usufu kawona wana na wazukulu wa Eflaim. Vivija kawona wana wa Makili mwana wa Manase awo iyawalongile kamba wanage. ");
INSERT INTO zajp_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Abaho Usufu kawalongela wandugu zake, “Nie na mmabehi kudanganhika, ila Mulungu kokwiza kuwemiliza na kuwalava mweye muisi ino na kuwagala kuisi iyawaduilile Ablaham, Isaka, na Yakobo.” ");
INSERT INTO zajp_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Abaho Usufu kawalongela Waislaeli wamduilile, kalonga, “Mulungu yeheza kuwataza kuwalava muisi ino, muipape mizege yangu kulawa hano.” ");
INSERT INTO zajp_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Avo Usufu kadanganhika kipigiti viyakalile na milao mia na longo dimwe. Wam'baka dawa ya kuzuila kola, na kumwingiza mdijanaenza kuja Misili.");
INSERT INTO zajp_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Gano gago matwaga ga wana wa kimbigalo wa Islaeli, ayo vivija yakemigwe Yakobo, wacholile Misili hamoja na heyo, kila imwe na wanage. ");
INSERT INTO zajp_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Wakala Lubeni, Simioni, Lawi, Yuda, ");
INSERT INTO zajp_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakali, Zabuloni, Benjamini, ");
INSERT INTO zajp_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani, Naftali, Gadi, na Asheli. ");
INSERT INTO zajp_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Wanhu wose wavumbuke mulukolo lwa Yakobo wakala malongo saba hamoja na Usufu yakalile yeshile kuwa muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Vukibitile kipigiti kitali, Usufu hamoja na wandugu zake wose na mulelo uja wose wadanganhika, ");
INSERT INTO zajp_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ila Waislaeli wakala walelile na kongezeka ng'hani na kuwa na mhiko, avo isi yose ikala imemile hewo. ");
INSERT INTO zajp_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Milao bwando hamwande kalawilila mndewa iyagwe muisi ya Misili yakalile hatangile chochose kiyatendile Usufu. ");
INSERT INTO zajp_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Kawalongela wanhu zake, “Loleni, Waislaeli wongezeka ng'hani na wana mhiko kutubanza tweye. ");
INSERT INTO zajp_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Natutende nzila ya kuwatenda sambiwongezeke kubanza vino viwali. Na kamba hatutenda avo, ihalawilila ng'hondo, woilumba na wadumuka zetu na kugomba na tweye na kusegela kulawa muisi yetu.” ");
INSERT INTO zajp_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Avo Wamisili wawekila Waislaeli wanhu wa kuwagaza giladi wawagaze mkuwasang'hanikiza sang'hano ndala. Waislaeli wazenga miwambo ya Pitomu na Lamesesi iwe makano ga Falao. ");
INSERT INTO zajp_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ila vija Wamisili viwakalile woiyoha kuwagaza ng'hani, vivo Waislaeli viwakalile wokongezeka na kwenela, avo Wamisili wawadumba ng'hani Waislaeli. ");
INSERT INTO zajp_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Avo Wamisili wawasang'hanikiza Waislaeli bila kuwonela bazi, ");
INSERT INTO zajp_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","na kuwatenda mazua gose wawe na usungu sama ya sang'hano ndala za matofali na chokaa ya kuzengela na sang'hano zose za mmigunda. Wamisili wawasang'hanikiza bila kuwonela bazi msang'hano zose ziwatendile. ");
INSERT INTO zajp_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Falao kawalagiza Shifla na Pua, wang'hunga wakalile wowataza watwanzi wa Kieblania kulela, yolonga, ");
INSERT INTO zajp_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Muhawataza watwanzi wa Kieblania mkipigiti cha kulela haja mkigoda cha kulelela, muhona mwana yovumbuka mbigalo, mkomeni, ila kamba yahawa mtwanzi, mulekeni.” ");
INSERT INTO zajp_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ila waja iwang'hunga wakala womdumba Mulungu, avo hawatendile kija Falao kiyawalagize, na waja iwana wa kimbigalo hawawakomile. ");
INSERT INTO zajp_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Abaho Falao kawakema waja iwang'hunga kawauza, yolonga, “Muwaleka wana wa kimbigalo wawe wagima. Habali mtenda vino?” ");
INSERT INTO zajp_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Wamwidika Falao, wolonga, “Watwanzi wa Kieblania si kamba viwali watwanzi wa Kimisili, hewo wana mhiko. Wolela kipigiti tweye wang'hunga hatunavika.” ");
INSERT INTO zajp_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Avo Mulungu kawatendela ganogile waja iwang'hunga, na Waislaeli wongezeka na kuwa na mhiko. ");
INSERT INTO zajp_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Na kwavija waja iwang'hunga wakala womdumba Mulungu, kawagwelela wana zao wenyego. ");
INSERT INTO zajp_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Abaho Falao kalagiza wanhu zake wose, yolonga, “Kila mwana mbigalo yondayaleligwe mwa Waeblania, mwaseni Mulwanda lwa Naili, ila yahaleligwa mwana wa kitwanzi, mulekeni.” ");
INSERT INTO zajp_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Mkipigiti kino, munhu imwe kulawa mumtala wa Lawi kamsola mtwanzi kulawa mumtala wa Lawi. ");
INSERT INTO zajp_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Viyeshile kulela wana wabili, ija imtwanzi kapata inda iyagwe na kulela mwana mbigalo. Viyamonile kamba kakala mwana yanogile, kamfisa milenge midatu. ");
INSERT INTO zajp_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ila viyalemelwe kumfisa, kasola kigelo kitendigwe na midete na kukibaka lami. Abaho kamwika imwana mgati yake na kukika ikigelo hagatigati ya imidete mumgwazo wa Ulwanda lwa Naili. ");
INSERT INTO zajp_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Lumbu jake ija imwana kakala hatalitali yone kija chondakimulawilile imwana. ");
INSERT INTO zajp_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Mndele wa Falao kahumuluka Kulwanda lwa Naili yoge, na watumigwa zake wakala wotembela mumgwazo wa ulwanda. Kachona ikigelo hagatigati ya imidete avo kamulagiza nyakadala wake wa kitwanzi yakakisole. ");
INSERT INTO zajp_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ija imndele wa Falao viyakigubule, kamona mwana. Ija imwana kakala yolila, na ija imndele kamonela bazi, kalonga, “Ino kowa imwe wa wana wa Waeblania.” ");
INSERT INTO zajp_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Abaho lumbu jake ija imwana kamuuza mndele wa Falao, “Nichole nikamkeme imwe wa watwanzi wa Kieblania yakukong'hezele imwana?” ");
INSERT INTO zajp_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ija imndele wa Falao kamwidika, yolonga, “Ona, genda.” Avo ija ilumbu jake ija imwana kachola na kumkema mama wa imwana. ");
INSERT INTO zajp_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ija imndele wa Falao kamulongela ija imama wa imwana, “Msole ino imwana ukanikong'hezele, abaho nokugwaa kitumetume chako.” Avo ija imtwanzi kamsola ija imwana na kumkong'heza. ");
INSERT INTO zajp_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ija imwana viyakulile na kuleka kong'ha, ija imama wa imwana kamsola na kumbwezela mndele wa Falao, na ija imndele wa Falao kamtenda kuwa mwanage. Kamgwaa twaga dikemigwa Musa, kwavija kalonga, “Nimpata mgamazi.” ");
INSERT INTO zajp_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Musa viyakulile, zua dimwe kachola kuwakalile wanhu zake, kawalola vija viwakalile wosang'hanizwa sang'hano ndala. Kamona Mmisili yomtoa Mueblania, imwe wa wanhu zake mwenyego. ");
INSERT INTO zajp_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Kalola kuno na kuno na kona haduhu munhu, kamkoma ija Immisili, na kumfisa mmisenga. ");
INSERT INTO zajp_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Imitondo iyagwe kachola na kuwona Waeblania wabili wogomba. Kamuuza ija imwavu, “Habali umtoa Mueblania miyago?” ");
INSERT INTO zajp_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ija imunhu kalonga, “Yalihi yakutendile gweye kuwa mtawala na mulamula wetu? Kolonda kunikoma nie kamba vuumkomile ija Immisili?” Musa kadumba na kugelegeza mmoyo, yolonga, “Yokoneka kija kinhendile kitangigwa na wanhu.” ");
INSERT INTO zajp_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Falao viyahulike mbuli zino, kalonda kumkoma Musa, ila Musa kakimbila kachola kukala muisi ya Midiani. Musa viyavikile Midiani, kakala hamgwazo wa sima da mazi. ");
INSERT INTO zajp_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Yeslo mkulu wa nhambiko wa Midiani kakala na wandele saba. Weza kudeha mazi na kumemeza via vao va kung'wila wang'onyo, giladi wawang'weze ng'hondolo wa tataao. ");
INSERT INTO zajp_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ila wachunga wang'onyo wayagwe weza na kuwawinga waja iwandele, ila Musa keza kuwakombola, na kuwang'weza wang'onyo zao. ");
INSERT INTO zajp_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Viwabwelile ha Leueli, tataao, kawauza, “Vilihi, mbona lelo m'bwela hima?” ");
INSERT INTO zajp_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Wamulongela, “Mmisili imwe katukombola kulawa mwa wachunga ng'hondolo wayagwe, katudehela mazi, na kuwang'weza wang'onyo zetu.” ");
INSERT INTO zajp_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Kawauza wandele zake, “Kakwahi? Habali mmulekile? Mulongeleni yeze kuja mandia hamoja na tweye.” ");
INSERT INTO zajp_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa katogola kukala na Yeslo, na Yeslo kamgwaa Musa mndele wake yokemigwa Sipola yawe mtwanzi wake. ");
INSERT INTO zajp_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sipola kalela mwana, na Musa kamgwaa twaga dikemigwa Gelishom, kalonga, “Nie nikala muhenza muisi ya uhenza.” ");
INSERT INTO zajp_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Vukibitile kipigiti kitali, mndewa wa Misili kadanganhika, ila Waislaeli wagendelela kugulila hasi ya zigo da unyakadala wao. Walila wozahila ija wa kuwataza, na kililo chao kim'vikila Mulungu. ");
INSERT INTO zajp_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Mulungu kahulika kugulila kumwao na kakumbukila kilagano chake na Ablaham, Isaka, na Yakobo. ");
INSERT INTO zajp_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Avo Mulungu kawalola Waislaeli na kuyona migayo yao, na kuwonela bazi. ");
INSERT INTO zajp_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Musa kakala yowachunga menhe na ng'hondolo wa mkwe yake yakemigwe Yeslo, mkulu wa nhambiko wa isi ya Midiani, kadilongoza dale jake kachola kutali ng'hani kuluwala mbaka Holebu, kuna idigongo da Mulungu. ");
INSERT INTO zajp_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Viyavikile haja, msenga wa MNDEWA wa kuulanga kamulawilila mmoto ukwaka mkitutua. Musa kalola mkukanganya avija kija ikitutua vukikalile kikwaka moto ila hakilukule. ");
INSERT INTO zajp_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Abaho Musa kalonga, “Beta nikwenhuke, nikalole mbuli ino ya mkanganyo, habali kino ikitutua hakilukula.” ");
INSERT INTO zajp_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","MNDEWA viyonile kamba kachola haja kulola, Mulungu kamkema kulawa haja mkitutua, “Musa! Musa!” Na Musa kedika, “Nie hano.” ");
INSERT INTO zajp_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Mulungu kamulongela, “Sambiukwenhuke, vula ng'hwabasa zako, kwavija hanhu aho hawimile hang'ala. ");
INSERT INTO zajp_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Nie iyo Mulungu wa wahenga zako, Mulungu wa Ablaham, na Isaka, na Yakobo.” Musa viyahulike vino, kagubika kihanga chake, kwavija kadumba kumulola Mulungu. ");
INSERT INTO zajp_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Abaho MNDEWA kalonga, “Niyona migayo iwopata wanhu zangu muisi ya Misili, niwahulika vowolila sama ya waja wowagaza. Niimanya migayo yao yose, ");
INSERT INTO zajp_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","avo nihumuluka hasi kuwakombola kulawa mmakono ga Wamisili, na kuwalava muisi ija, na kuwagala kuisi inogile ili na ugazi, isi ili na lutuba na ugoli, isi ya Wakanaani, Wahiti, Waamoli, Wapelizi, Wahivi, na Wayebusi. ");
INSERT INTO zajp_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Kililo cha Waislaeli kinivikila, vivija nyona vija Wamisili vowowagaza. ");
INSERT INTO zajp_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Avo izo, nikutume ha Falao, ukawalave wanhu zangu, Waislaeli, wasegele muisi ya Misili.” ");
INSERT INTO zajp_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ila Musa kamulongela Mulungu, “Nie iyo yalihi, mbaka nichole ha Falao nikawalave Waislaeli wasegele muisi ya Misili?” ");
INSERT INTO zajp_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Mulungu kalonga, “Nie nowa hamoja na gweye, na uhawalava wanhu kulawa muisi ya Misili, monitambikila nie hana idigongo dino. Kino chowa kilaguso kamba nie iyo nikutumile.” ");
INSERT INTO zajp_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ila Musa kamulongela Mulungu, “Kamba nihachola ha Waislaeli na kuwalongela, ‘Mulungu wa wahenga zenu kanhuma kumwenu,’ na kamba wahaniuza, ‘Twaga jake dijo dilihi?’ Niwalongeleze?” ");
INSERT INTO zajp_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Mulungu kamulongela Musa, “NIE IYO NIE. Vino vivo vondauwalongele Waislaeli, ‘NIE kanhuma kumwenu.’ ");
INSERT INTO zajp_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Vino vivo vondauchole kuwalongela Waislaeli, ‘MNDEWA, Mulungu wa wahenga zako, ayo yali Mulungu wa Ablaham, na Isaka, na Yakobo, kanhuma nie kumwenu. “Dino dijo twaga jangu mazua gose, twaga dondanitambulwe kulawa mulelo umwe mbaka mulelo uyagwe.” ’ ");
INSERT INTO zajp_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Genda ukaiting'hane na wakulu wa Islaeli uwalongele kamba MNDEWA, Mulungu wa wahenga zao, ayo yali Mulungu wa Ablaham, na Isaka, na Yakobo, kakulawilila na kukulongela, ‘Niwalola na nigona gaja gomtendeligwa muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Na nie nika kilagano cha kuwasegeza mweye kulawa mmigayo yenu muisi ya Misili na kuwagala muisi ya Wakanaani, Wahiti, Waamoli, Wapelizi, Wahivi, na Wayebusi, isi ili na lutuba na ugoli.’ ");
INSERT INTO zajp_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Wakulu wa Islaeli wokutegeleza. Abaho gweye hamoja na iwakulu molondigwa mchole ha mndewa wa Misili, na kumulongela, ‘MNDEWA, Mulungu wa Waeblania, katulawilila. Avo tuleke tuchole mwanza wa mazua madatu muluwala, tukalave nhosa ha MNDEWA Mulungu wetu.’ ");
INSERT INTO zajp_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ila nivimanya kamba mndewa wa Misili hadaha kuwaleka mweye mchole kamba mkono wangu wene mhiko haumshulutize kutenda avo. ");
INSERT INTO zajp_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Avo nougolosa mkono wangu na kuwatoa Wamisili na vinhu bwando va mikanganyo vondanivitende mmwao. Abaho kowaleka mweye mchole. ");
INSERT INTO zajp_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Na nie nowatenda Waislaeli watogoligwe na Wamisili, wowagwelela vinhu kipigiti vondamsegele, avo hamsegela bila kinhu. ");
INSERT INTO zajp_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Kila mtwanzi wa Kiislaeli yapule vinhu va kuihamba va madini ga feza na zahabu na vivalo vinogile kulawa mwa Wamisili wokala behi nao, na kulawa mwa watwanzi wokala mzing'anda za wanhu wa habehi yao, vinhu vino vondamuwapule Wamisili mowavaza wanenu wa kimbigalo na wa kitwanzi na mowabokonya Wamisili ugoli wao.” ");
INSERT INTO zajp_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Abaho Musa kamwidika MNDEWA, “Yowaze kamba wanhu waja hawanitogole ama hawanitegeleze na kulonga, ‘MNDEWA hakulawilile’?” ");
INSERT INTO zajp_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","MNDEWA kamuuza, “Kugoga choni mumkono wako?” Kalonga, “Fimbo.” ");
INSERT INTO zajp_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","MNDEWA kamulongela, “Ibwanhe hasi.” Musa viyaibwanhile hasi ija ifimbo, igaluka nyoka, na Musa kazumha kuchugu. ");
INSERT INTO zajp_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Abaho MNDEWA kamulongela Musa, “Golosa mkono wako, umgoge umkila.” Avo Musa kagolosa mkono wake na kumgoga, na ija inyoka kagaluka kuwa fimbo kabili. ");
INSERT INTO zajp_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","MNDEWA kalonga, “Vino vivo vondawatogole kamba, MNDEWA, Mulungu wa wahenga zao, Mulungu wa Ablaham, Isaka, na Yakobo, kakulawilila gweye.” ");
INSERT INTO zajp_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Kabili MNDEWA kamulongela Musa, “Gela mkono wako mdiguo hana imhambaga yako.” Avo Musa kagela mkono wake mdiguo hana imhambaga yake, na viyaulavile, mkono wake ukala na dikulu, ugaluka mnzelu kamba usage. ");
INSERT INTO zajp_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Abaho MNDEWA kamulongela, “Gela kabili mkono wako mdiguo hana imhambaga.” Avo kaugela kabili mkono wake mdiguo hana imhambaga, na viyaulavile, uwa mgima kamba vulukalile lukuli lwake lusigale. ");
INSERT INTO zajp_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","MNDEWA kamulongela Musa, “Kamba hawakutogole ama kukutegeleza mumzonza wa ichanduso, basi wokutogola mumzonza wa ikabili. ");
INSERT INTO zajp_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Na kamba hawaitogole mizonza ino mibili, ama kukutegeleza, deha mazi kidogo kulawa Mulwanda lwa Naili, ukagetile muisi inyalile. Mazi gondaudehe kulawa mulwanda gogaluka mulopa muisi inyalile.” ");
INSERT INTO zajp_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa kamulongela MNDEWA, “Mndewa wangu, nie sidaha kulonga goya songela umwaka, mbaka kipigiti kino vuulonga na nie. Nie nna kigagaziko, na lulimi lwangu luzalama.” ");
INSERT INTO zajp_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","MNDEWA kamulongela, “Yalihi yamgwelele munhu mulomo? Yalihi yomtenda munhu kuwa kinziwi ama bubui? Yalihi yomgwelela meso ama yomtenda yawe kimbugumbugu? Sio nie, MNDEWA? ");
INSERT INTO zajp_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Avo genda, nokugwelela udaho wa kulonga, na nokufundiza mbuli za kulonga.” ");
INSERT INTO zajp_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ila Musa kalonga, “MNDEWA, mtume munhu iyagwe.” ");
INSERT INTO zajp_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Abaho MNDEWA kamonela lusango Musa, na kulonga, “Komonaze mkulu wako Haloni Mulawi? Nivimanya kamba kodaha kulonga goya. Heyo ka mnzila kokwiza kuiting'hana na gweye, na moyo wake wodeng'ha ng'hani yahakona gweye. ");
INSERT INTO zajp_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Longelela nayo, na umulongele mbuli za kulonga, na nie nowa hamoja na mulomo wako na mulomo wake, na nie nowafundiza mweye gaja gondamtende. ");
INSERT INTO zajp_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Heyo iyo yondayawalongele wanhu sama yako gweye, yowa kamba vija heyo iyo yali na mulomo wako gweye na kamba vija gweye iyo Mulungu kumwake. ");
INSERT INTO zajp_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Sola fimbo ino igoge mumkono wako kwavija kotenda mizonza kubitila fimbo ino.” ");
INSERT INTO zajp_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Abaho Musa kabwela ha mkwe yake Yeslo na kumulongela, “Beta nibweleganye ha wandugu zangu ako Misili, nyone kamba wang'hali wagima ama vilihi.” Yeslo kalonga, “Genda, na nie nokulondela upile mmwanza wako.” ");
INSERT INTO zajp_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","MNDEWA kamulongela Musa kuna iisi ya Midiani, “Bwela muisi ya Misili, kwavija waja wose wakalile wozahila ugima wako wadanganhika.” ");
INSERT INTO zajp_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Avo Musa kawasola wanage na mtwanzi wake, na kuwakweleza mmhunda na kubweleganya muisi ya Misili, na Musa kaigoga ija ifimbo ya Mulungu mumkono wake. ");
INSERT INTO zajp_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","MNDEWA kamulongela Musa, “Uhabweleganya muisi ya Misili, ukaitende mizonza yose ija inikugwelele udaho wa kuitenda, ukaitende haulongozi wa Falao. Ila nie nougela udala moyo wake giladi sambiyawaleke wanhu wachole. ");
INSERT INTO zajp_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Abaho mulongele Falao kamba MNDEWA kalonga vino, ‘Islaeli iyo chaudele wangu, ");
INSERT INTO zajp_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","na nie nikulongela, “Muleke mwanangu yachole, giladi yakanitambikile.” Ila kulema kumuleka yachole, avo nomkoma chaudele wako.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Viwakalile mnzila wochola Misili, MNDEWA kaiting'hana na Musa hanhu hawekile ng'hambi na kulonda kumkoma. ");
INSERT INTO zajp_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ila Sipola, mtwanzi wake, kasola dibwe dibita na kumwingiza kumbi mwanage na kumkwasa Musa mmagulu gake na idigovi, na kumulongela, “Kweli gweye iyo mbigalo wa mulopa kumwangu nie!” ");
INSERT INTO zajp_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Avo MNDEWA kaleka kumkoma Musa. Abaho Sipola kalonga, “Gweye kwa mulawilamhambe wa mulopa kubitila kumbi.” ");
INSERT INTO zajp_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","MNDEWA kamulongela Haloni, “Genda muluwala koiting'hana na Musa.” Avo kachola na kum'vika hana idigongo da Mulungu, kamnonela. ");
INSERT INTO zajp_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa kamulongela Haloni mbuli zose MNDEWA ziyamtumile heyo yeze kulonga na mizonza yose iyamulagize kuitenda. ");
INSERT INTO zajp_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Abaho Musa na Haloni wawakema hamoja wakulu wose wa Islaeli, ");
INSERT INTO zajp_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","na Haloni kawalongela mbuli zose MNDEWA ziyamulongele Musa. Vivija Haloni katenda ija imizonza haulongozi wao, ");
INSERT INTO zajp_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","na hewo watogola. Na viwahulike kamba MNDEWA kayona migayo yao na konda kuwataza, wafugama mavindi wainamila mbaka hasi, watambika. ");
INSERT INTO zajp_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Musa na Haloni viweshile kulonga na vilangizi wa Islaeli, wachola ha Falao na kumulongela, “MNDEWA, Mulungu wa Islaeli, kolonga vino, ‘Waleke wanhu zangu wachole, giladi wakanitendele lusona kuluwala.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ila Falao kalonga, “MNDEWA iyo yalihi, kileka nimtegeleze na kuwaleka Waislaeli wachole? Nie simtangile MNDEWA, na siwaleka Waislaeli wachole.” ");
INSERT INTO zajp_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Abaho wamulongela, “Mulungu wa Waeblania katulawilila tweye. Avo tuleke tuchole mwanza wa mazua madatu muluwala, tukamulavile nhosa MNDEWA Mulungu wetu. Kamba hatutendile avo, kotutoa na mitamu ama na zele.” ");
INSERT INTO zajp_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ila Falao kawalongela, “Musa na Haloni, habali muwasegeza wanhu kulawa msang'hano zao? Bweleganyeni msang'hano zenu. ");
INSERT INTO zajp_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Lola, wanhu zenu wongezeka kubanza wanhu wa isi, na mowalonda waleke kusang'hanika!” ");
INSERT INTO zajp_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Zua didija Falao kawalagiza Wamisili wakalile wowagaza iwanyakadala hamoja na Waislaeli wakalile vilangizi wa iwanyakadala, yolonga, ");
INSERT INTO zajp_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Sambimuwagwelele mibelege ya kutendela matofali kamba vumkalile mtenda haichanduso, walekeni wenyego wachole kukunzanya mibelege, ");
INSERT INTO zajp_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ila wolondigwa watende matofali kiasi kikija chowokala wotenda haichanduso na sambidihungule hata tofali dimwe. Wakoka wano! Kileka mana wolila, wolonga, ‘Tuleke tuchole tukamulavile Mulungu wetu nhosa.’ ");
INSERT INTO zajp_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Muwasang'hanikize wanhu wano sang'hano ndala, na sambiwawe na kipigiti cha kuhumula giladi sambiwategeleze mbuli za uvwizi.” ");
INSERT INTO zajp_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Abaho, waja wakalile wowagaza iwanyakadala hamoja na Waislaeli wakalile vilangizi wa iwanyakadala walawa na kuwalongela Waislaeli, “Falao kolonga vino, ‘Siwagwelela mibelege tena. ");
INSERT INTO zajp_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Gendeni wenyego mkazahile mibelege kokose kondamuipate, ila kiasi cha matofali sambikihungule.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Avo wanhu wachola muisi yose ya Misili kuzahila misanze kusola hanhu ha mibelege. ");
INSERT INTO zajp_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Waja wakalile wowagaza iwanyakadala wagendelela kuwashulutiza, wolonga, “Mambukizeni sang'hano yenu, kiasi kikija cha matofali kamba vija vumkalile mgweleligwa mibelege.” ");
INSERT INTO zajp_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Wamisili wakalile wowagaza iwanyakadala wawalanha vilangizi wa Waislaeli awo wakalile iwawasagule na kuwauza, “Habali mweye mayo na lelo ham'vikize kiasi kikija cha matofali kimkalile mtenda mazua gabitile?” ");
INSERT INTO zajp_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Abaho waja Waislaeli wakalile vilangizi wa iwanyakadala wachola ha Falao wolila na kumulongela, “Habali ututenda tweye watumigwa zako kamba vino? ");
INSERT INTO zajp_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Hatugweleligwe mibelege, hata avo wotushulutiza kutenda matofali. Lola vija tweye watumigwa zako tolanhigwa bila kuhonyela hanhu, ila wanhu zako iwo wahonyele.” ");
INSERT INTO zajp_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Falao kawalongela, “Mweye mwa wakoka! Mwa wakoka! Kileka mana mulonga, ‘Tuleke tuchole tukamulavile nhosa MNDEWA.’ ");
INSERT INTO zajp_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Gobokeni mchole mkasang'hanike, kwavija haduhu hata belege dimwe dondamgweleligwe, na mtende kiasi kikija cha matofali kamba kimkalile mtenda.” ");
INSERT INTO zajp_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Waja Iwaislaeli wakalile vilangizi wa iwanyakadala wakiiyona wa mmwangalo ahaja viwalongeligwe, “Sambimuhunguze kiasi cha matofali kimulondigwa kugatenda kila zua.” ");
INSERT INTO zajp_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Viwalawile ha Falao, wawavika Musa na Haloni, wakalile wowabeta hewo. ");
INSERT INTO zajp_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Wawalongela Musa na Haloni, “MNDEWA yawataguse na kuwasuna, mtutenda tweye twihilwe na Falao hamoja na salange zake, tena muwagwelela kilamso cha kutukomela.” ");
INSERT INTO zajp_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Abaho Musa kawaleka na kubweleganya ha MNDEWA na kutambika, yolonga, “Mndewa, habali uwagalile wanhu zako migayo ino yose? Kino kicho kilamso cha gweye kunhuma nie? ");
INSERT INTO zajp_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Songela nie vunicholile ha Falao kuzilonga mbuli zako, Falao kawagalila wanhu wano migayo, na gweye huwakombole wanhu zako hata kidogo.” ");
INSERT INTO zajp_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Abaho MNDEWA kamulongela Musa, “Sambisambi kochona kija chondanimtende Falao. Sama ya mkono wangu wene mhiko, kowaleka wanhu zangu wachole. Kowawinga walawe muisi yake.” ");
INSERT INTO zajp_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Mulungu kamkema Musa na kumulongela, “Nie iyo MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nyoneke ha Ablaham, ha Isaka, na ha Yakobo kamba Mulungu Mwene Mhiko. Ila sidifunule kumwao twaga jangu dikemigwa Yahweh. ");
INSERT INTO zajp_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Vivija niditenda lagano jangu na hewo, kilagano cha kuwagwaa isi ya Kanaani, isi iwakalile wokala kamba wahenza. ");
INSERT INTO zajp_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Vivija nihulika kugulila kuwokugulila Waislaeli awo watendigwe na Wamisili kuwa nyakadala wao, na nie nikumbukila lagano jangu. ");
INSERT INTO zajp_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Avo walongele Waislaeli, kamba, ‘Nie iyo Yahweh, na nowakombola kulawa mkusang'hanikizwa sang'hano ndala za Wamisili. Nowafungula sambimuwe nyakadala zao. Nougolosa mkono wangu wene mhiko na kuwasuna ng'hani hewo na kuwakombola mweye. ");
INSERT INTO zajp_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nowatenda mweye muwe wanhu zangu mwenyego, na nie nowa Mulungu wenu. Na mweye movitanga kamba nie iyo MNDEWA Mulungu wenu, ahaja vondaniwafungule kulawa muunyakadala muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nowagala kuisi ija iniwaduilile kuwagwaa Ablaham, Isaka, na Yakobo, nowagwelela mweye iwe yenu. Nie iyo MNDEWA.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa kawalongela mbuli zino Waislaeli, ila hawamtegeleze, sama ya mioyo yao ibogoyoke na unyakadala umemile mbuli za ukaini. ");
INSERT INTO zajp_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Abaho MNDEWA kamulongela Musa, ");
INSERT INTO zajp_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Genda ukamulongele Falao, mndewa wa Misili, yawaleke Waislaeli wasegele muisi yake.” ");
INSERT INTO zajp_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ila Musa kamulongela MNDEWA, “Kamba Waislaeli hawanitegeleze nie, vodahikaze Falao kunitegeleza? Kwavija nie nna kigagaziko.” ");
INSERT INTO zajp_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","MNDEWA kawalongela Musa na Haloni, “Walongeleni Waislaeli hamoja na Falao, mndewa wa Misili, kamba nie iyo niwalagize mweye kuwalava Waislaeli muisi ya Misili.” ");
INSERT INTO zajp_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Wano wawo vilangizi wali mmwanza wa vilangizi wa lukolo lwa Islaeli. Wana wa Lubeni, mwana wa udele wa Islaeli, wakala Hanoki, Palu, Heziloni, na Kami. Ino iyo milango ya Lubeni. ");
INSERT INTO zajp_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Wana wa Simioni wakala Yemueli, Yamini, Ohadi, Yakini, Zohali, na Shauli. Mamaake Shauli kakala Mkanaani. Ino iyo milango ya Simioni. ");
INSERT INTO zajp_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Gano gago matwaga ga wana wa Lawi kulingana na vija viwaleligwe, Gelishom, Kohasi, na Melali. Lawi kakala milao mia imwe na malongo madatu na saba (137) abaho kadanganhika. ");
INSERT INTO zajp_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Wana wa Gelishom wakala Libini na Shimei. Wano wakala vilangizi kulingana na milango yao. ");
INSERT INTO zajp_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Wana wa Kohasi wakala Amulam, Ishali, Hebloni, na Uzieli. Kohasi kakala milao mia imwe na malongo madatu na ndatu (133) abaho kadanganhika. ");
INSERT INTO zajp_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Wana wa Melali wakala Mahili na Mushi. Ino iyo milango ya Walawi kulingana na vija viwaleligwe. ");
INSERT INTO zajp_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amulam kamsola lumbu ja tataake yokemigwa Yokebedi na kuwalela Musa na Haloni. Amulam kakala milao mia imwe na malongo madatu na saba (137) abaho kadanganhika. ");
INSERT INTO zajp_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Wana wa Ishali wakala Kola, Nefegi, na Zikli. ");
INSERT INTO zajp_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Wana wa Uzieli wakala Mishaeli, Elizafani, na Sisili. ");
INSERT INTO zajp_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haloni kamsola Elisheba, mndele wa Aminadabu, lumbu ja Nashoni na kulela wana wane na matwaga gao wakemigwa Nadabu, Abihu, Eliazali, na Isamali. ");
INSERT INTO zajp_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Wana wa Kola wakala Asili, Elikana, na Abiasafu. Wano wawo wezile kuwa milango ya Kola. ");
INSERT INTO zajp_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eliazali mwana wa Haloni kamsola imwe wa wandele wa Putieli, na kamulela Finehasi. Wano wakala vilangizi wa wahenga wa Lawi kulingana na milango yao. ");
INSERT INTO zajp_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Haloni iino hamoja na Musa wawo MNDEWA iyawalongele, “Walaveni Waislaeli muisi ya Misili kulingana na milango yao.” ");
INSERT INTO zajp_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Hewo iwo walongile na Falao, mndewa wa Misili, mmbuli ya kuwalava Waislaeli muisi ya Misili. Wakala Musa iino na Haloni. ");
INSERT INTO zajp_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","MNDEWA viyalongile na Musa muisi ya Misili, ");
INSERT INTO zajp_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","kamulongela, “Nie iyo MNDEWA. Mulongele Falao, mndewa wa Misili, kila kinhu kinikulongela.” ");
INSERT INTO zajp_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ila Musa kamulongela MNDEWA, “Kwavija nie nna kigagaziko, Falao kodahaze kunhegeleza?” ");
INSERT INTO zajp_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","MNDEWA kamulongela Musa, “Lola, nikutenda gweye uwe kamba Mulungu hameso ga Falao, na mkulu wako Haloni kowa muhokozi wako. ");
INSERT INTO zajp_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Mulongele Haloni kila kinhu kinikulagize, na heyo komulongela Falao yawaleke Waislaeli wasegele muisi ino. ");
INSERT INTO zajp_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ila nie noutenda moyo wa Falao kuwa mdala, na nokongeza mizonza na mikanganyo yangu muisi ya Misili, ");
INSERT INTO zajp_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","hata avo Falao hawategeleza. Abaho nowasuna wanhu wa Misili na kuwalava Waislaeli, wanhu zangu, hanze ya isi ya Misili, mtala kwa mtala, nowalava na sang'hano ng'hulu za nhaguso yondaiwe muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Wamisili wovitanga kamba nie iyo MNDEWA, ahaja vondaniugolose mkono wangu muisi ya Misili na kuwalava Waislaeli hanze ya isi ija.” ");
INSERT INTO zajp_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa na Haloni watenda kamba MNDEWA viyawalagize. ");
INSERT INTO zajp_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Kipigiti viwacholile kulonga na Falao, Musa kakala na milao malongo manane na Haloni kakala na milao malongo manane na midatu. ");
INSERT INTO zajp_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Abaho MNDEWA kalonga na Musa na Haloni, ");
INSERT INTO zajp_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Falao yahawalongela, ‘Tendeni mzonza,’ mulongele Haloni, ‘Sola fimbo yako uibwanhe hasi haulongozi wa Falao,’ na yogaluka nyoka.” ");
INSERT INTO zajp_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Avo Musa na Haloni wachola ha Falao na kutenda vija MNDEWA viyawalagize. Haloni kaibwanha hasi fimbo yake haulongozi wa Falao na salange zake, na ifimbo igaluka nyoka. ");
INSERT INTO zajp_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Abaho Falao kawakema wanhu wali na nzewele na wahawi. Na wahawi wano watenda kamba viyatendile heyo kubitila uhawi wao. ");
INSERT INTO zajp_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Kila munhu kaibwanha hasi fimbo yake, na zija izifimbo zigaluka nyoka, ila nyoka wa Haloni kawameza nyoka wose wa iwahawi. ");
INSERT INTO zajp_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ila moyo wa Falao ugendelela kuwa mdala, kamba viyalongile MNDEWA, kalema kuwategeleza. ");
INSERT INTO zajp_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Abaho MNDEWA kamulongela Musa, “Moyo wa Falao uwa mdala, kolema kuwaleka wanhu wachole. ");
INSERT INTO zajp_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Imitondo genda ha Falao, kipigiti vondayalawe kuchola Kulwanda lwa Naili. Ima hamgwazo wa ulwanda uiting'hane nayo, na uigoge fimbo ija mmakono gako, fimbo ija igaluke kuwa nyoka. ");
INSERT INTO zajp_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Mulongele vino, ‘MNDEWA, Mulungu wa Waeblania, kanituma nie kumwako nikulongele, “Waleke wanhu zangu wachole, giladi wakanitambikile nie kuluwala.” Ila mbaka sambi hunitegeleze. ");
INSERT INTO zajp_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Avo, vino vivo MNDEWA viyanongele, “Mkutenda vino, gweye kovitanga kamba nie iyo MNDEWA.” Lola, nogalanha mazi ga Lwanda lwa Naili na fimbo ili mumkono wangu, na gogaluka mulopa. ");
INSERT INTO zajp_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Na somba wali Mulwanda lwa Naili wofa, na ulwanda lwonung'ha mbaka Wamisili hawadaha kung'wa mazi gake.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","MNDEWA kamulongela Musa, “Mulongele Haloni yasole fimbo yake mumkono abaho yaugolose mkono wake kuna gamazi gose ga Misili, mazi ga mzinyanda, mazi gali m'vizanda, mazi ga m'vilamba, na milamba yose ya mazi giladi gagaluke mulopa. Na kila hanhu muisi ya Misili kowa na mulopa, mulopa wowa m'via visongoligwe kulawa mmibiki na mmibwe.” ");
INSERT INTO zajp_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa na Haloni watenda kamba MNDEWA viyawalagize. Haloni kenula fimbo yake haulongozi wa Falao na salange zake na kugalanha gamazi ga Lwanda lwa Naili, na mazi gose gagaluka kuwa mulopa. ");
INSERT INTO zajp_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Somba wakalile Mulwanda lwa Naili wafa, na ulwanda lulava bundo mbaka Wamisili hawadahile kung'wa mazi gake. Mulopa ukala kila hanhu muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ila wahawi wa Misili watenda vivija viwatendile hewo kubitila uhawi wao, avo moyo wa Falao ugendelela kuwa mdala, kamba viyalongile MNDEWA, hawategeleze Musa na Haloni. ");
INSERT INTO zajp_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Falao kahinduka na kubweleganya kuding'anda jake, bila kuigesa mbuli ija itendeke. ");
INSERT INTO zajp_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Avo Wamisili wose wahimba mumgwazogwazo wa Ulwanda lwa Naili giladi wapate mazi ga kung'wa, kwavija hawadahile kung'wa mazi ga mulwanda. ");
INSERT INTO zajp_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Gabita mazua saba songela kipigiti MNDEWA viyalulanhile Ulwanda lwa Naili. ");
INSERT INTO zajp_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Abaho MNDEWA kamulongela Musa, “Genda ha Falao, ukamulongele kamba MNDEWA kolonga vino, ‘Waleke wanhu zangu wachole, giladi wakanitambikile nie. ");
INSERT INTO zajp_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kamba uhalema kuwaleka wachole, noitila vibula isi yako yose. ");
INSERT INTO zajp_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Lwanda lwa Naili lomema vibula, wokwenela mbaka kuding'anda jako, mdigati jako na mulusazi lwako, mzing'anda za salange zako, mzing'anda za wanhu zako, na hata mkivu chako na m'vikalango vako va kukandila. ");
INSERT INTO zajp_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ivibula vokuzumhila gweye na wanhu zako na salange zako wose.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","MNDEWA kamulongela Musa, “Mulongele Haloni yenule mkono wake uli na fimbo yaugolosele kuna zinyanda, m'vizanda, na m'vilamba, na kuvitenda vibula vilawe mmazi na kuigubika isi yose ya Misili.” ");
INSERT INTO zajp_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Avo Haloni kaugolosa mkono wake kuna gamazi gose ga Misili, na vibula vilawa mmazi na kuigubika isi yose ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ila wahawi na hewo watenda vivija kamba viyatendile heyo kubitila uhawi wao, na hewo vivija wavitenda vibula vilawe mmazi na kwingila muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Falao kawakema Musa na Haloni, na kulonga, “Tambikeni ha MNDEWA, yavisegeze vibula kulawa kumwangu na kulawa ha wanhu zangu, na nie nowaleka wanhu zenu wachole kumulavila nhosa MNDEWA.” ");
INSERT INTO zajp_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa kamwidika Falao, “Nilongele zua jaki duulonda nie nikutambikile gweye na salange zako hamoja na wanhu zako, giladi vibula vino visegele kumwako gweye na mzing'anda zako, ila visigale tu vija vili Mulwanda lwa Naili.” ");
INSERT INTO zajp_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Falao kalonga, “Nitambikile mayo.” Musa kalonga, “Notenda kamba vuulongile. Abaho kovitanga kamba haduhu mulungu yalingile na MNDEWA Mulungu wetu, ");
INSERT INTO zajp_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","vibula vosegela kumwako gweye na mng'anda zako zose na salange zako na wanhu zako, ila vosigala muna Ulwanda lwa Naili.” ");
INSERT INTO zajp_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Abaho Musa na Haloni wasegela haulongozi wa Falao, avo Musa kamulilila MNDEWA mmbuli ya vibula MNDEWA viyavigalile ha Falao. ");
INSERT INTO zajp_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Na MNDEWA katenda kamba Musa viyapulile, waja ivibula wakalile mzing'anda na mmikonhi ya izing'anda na mmigunda, wafa. ");
INSERT INTO zajp_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Avo Wamisili wavilundika ivibula hamoja na kutenda masugulu, na isi yose inung'ha bundo. ");
INSERT INTO zajp_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ila Falao viyonile kamba ivibula vifa, kautenda moyo wake kuwa mdala, kamba viyalongile MNDEWA. Avo hawategeleze Musa na Haloni, kamba viyalongile MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","MNDEWA kamulongela Musa, “Mulongele Haloni, yadilanhe timbwisi da isi na fimbo yake, na timbwisi da isi yose ya Misili dogaluka kuwa usubi.” ");
INSERT INTO zajp_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Avo Haloni kadilanha timbwisi da isi na fimbo yake, na timbwisi da isi yose ya Misili digaluka kuwa usubi, na uwezila wanhu na wang'onyo. ");
INSERT INTO zajp_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Wahawi wageza kuwatenda usubi walawilile kubitila uhawi wao, ila hawadahile. Usubi uwezila wanhu na wang'onyo. ");
INSERT INTO zajp_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Na waja iwahawi wamulongela Falao, “Kino kidole cha Mulungu.” Ila moyo wa Falao ugendelela kuwa mdala, kamba MNDEWA viyalongile, hawategeleze Musa na Haloni. ");
INSERT INTO zajp_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Abaho MNDEWA kamulongela Musa, “Mayo winuke imitondo ng'hani uchole ha Falao, kipigiti vondayachole kulwanda, umulongele kamba Mndewa kolonga vino, ‘Waleke wanhu zangu wachole, giladi wakanitambikile nie. ");
INSERT INTO zajp_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kwavija kamba huwalekile wanhu zangu wachole, nogala madale ga ng'honzi kumwako gweye na salange zako, ha wanhu zako na mng'anda zako. Ng'anda za Wamisili zomema madale ga ng'honzi, vivija muna iisi iwokala. ");
INSERT INTO zajp_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ila muisi ya Gosheni ako wanhu zangu kuwokala, hakuwa na madale ga ng'honzi, giladi uvitange kamba nie, MNDEWA, nokala muisi ija. ");
INSERT INTO zajp_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nokwika mbaka hagatigati ya wanhu zangu na wanhu zako, na mzonza uno wokoneka mayo.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","MNDEWA katenda kamba viyalongile. Madale makulu ga ng'honzi gengila mding'anda da Falao na mzing'anda za salange zake. Isi yose ya Misili ibanangigwa na ng'honzi. ");
INSERT INTO zajp_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Abaho Falao kawakema Musa na Haloni, na kulonga, “Gendeni mkamulavile nhosa Mulungu wenu mumuno muisi.” ");
INSERT INTO zajp_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ila Musa kalonga, “Havinoga kumulavila nhosa Mulungu wetu muisi ino, kwavija nhosa yondatulave ha MNDEWA Mulungu wetu yowagevuza Wamisili. Avo kamba tuhalava nhosa iwagevuza haulongozi wao, haweza kututoa na mibwe? ");
INSERT INTO zajp_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Tolondigwa tuchole mwanza wa mazua madatu kuluwala tukamulavile nhosa MNDEWA Mulungu wetu, kamba viyatulagize.” ");
INSERT INTO zajp_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Avo Falao kalonga, “Nowaleka mchole kumulavila nhosa, MNDEWA Mulungu wenu kuluwala, ila sambimchole kutali ng'hani. Na mnitambikile na nie.” ");
INSERT INTO zajp_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Abaho Musa kalonga, “Kipigiti kikino nie vunisegela hano, nokutambikila ha MNDEWA, na mayo madale gose ga ng'honzi gosegela kulawa kumwako na salange zako na wanhu zako. Ila gweye kolondigwa sambiutuvwizile kabili mkuwagomesa wanhu kuchola kumulavila MNDEWA nhosa.” ");
INSERT INTO zajp_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Avo Musa kasegela haulongozi wa Falao na kutambika ha MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Na MNDEWA katenda kamba Musa viyampulile. Kagasegeza gamadale ga ng'honzi kulawa ha Falao, kulawa ha salange zake, na kulawa ha wanhu zake, haduhu hata ng'honzi imwe yasigale. ");
INSERT INTO zajp_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ila mwanza uno vivija, Falao kautenda moyo wake kuwa mdala, na hawalekile wanhu wachole. ");
INSERT INTO zajp_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Abaho MNDEWA kamulongela Musa, “Genda ha Falao ukamulongele kamba MNDEWA Mulungu wa Waeblania kolonga vino, ‘Waleke wanhu zangu wachole kunitambikila nie. ");
INSERT INTO zajp_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Kamba uhalema kuwaleka wachole, na kugendelela kuwananahila, ");
INSERT INTO zajp_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","nie nokusuna na utamu wihile ng'hani mwa wang'onyo zako wa kufuga, kamba vija falasi zako, mhunda zako, ngamia zako, ng'ombe zako, na ng'hondolo zako. ");
INSERT INTO zajp_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ila nie, MNDEWA, nokwika mbaka hagatigati ya wang'onyo wa Islaeli na wang'onyo wa Misili, giladi wang'onyo wa Waislaeli sambiwadanganhike. ");
INSERT INTO zajp_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Nie, MNDEWA, nika kipigiti cha mbuli ino kulawilila. Mayo noitenda mbuli ino muisi ya Misili.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Na imitondo iyagwe MNDEWA kakitenda kija chayalongile. Wang'onyo wose wa Wamisili wadanganhika, ila wang'onyo wa Waislaeli haduhu hata imwe yadanganhike. ");
INSERT INTO zajp_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Falao katuma visepi wakalolese, na hewo wona kamba haduhu hata mng'onyo imwe wa Waislaeli yadanganhike. Hata avo moyo wa Falao ugendelela kuwa mdala na hawalekile wanhu wachole. ");
INSERT INTO zajp_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Abaho MNDEWA kawalongela Musa na Haloni, “Soleni maganza ga mitozi kulawa muitanuli, abaho Musa yayase uchana haulongozi wa Falao. ");
INSERT INTO zajp_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ija imitozi yokwenela muisi yose ya Misili na kuwa kamba timbwisi dondadisongeze mapute mwa wanhu na wang'onyo muisi yose ya Misili.” ");
INSERT INTO zajp_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Avo wasola mitozi kulawa muitanuli na kwima haulongozi wa Falao, abaho Musa kayasa imitozi uchana, na imitozi isongeza mapute mwa wanhu na wang'onyo. ");
INSERT INTO zajp_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Waja iwahawi wa Misili hawadahile kwiza kwima haulongozi wa Musa sama ya mapute gawakalile nago, kwavija mapute gawapata waja iwahawi hamoja na Wamisili wayagwe. ");
INSERT INTO zajp_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","MNDEWA kautenda moyo wa Falao kuwa mdala, na hawawategeleze Musa na Haloni kamba MNDEWA viyamulongele Musa. ");
INSERT INTO zajp_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Abaho MNDEWA kamulongela Musa, “Ulamuke imitondo ng'hani, uchole ha Falao ukamulongele kamba MNDEWA Mulungu wa Waeblania kolonga vino, ‘Waleke wanhu zangu wachole, giladi wakanitambikile nie. ");
INSERT INTO zajp_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ila kamba uhalema kuwalekesa, mwanza uno nokutoa na mitamu ihile ng'hani gweye mwenyego na salange zako hamoja na wanhu zako, giladi uvitange kamba haduhu yalingile na nie muulumwengu wose. ");
INSERT INTO zajp_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Kwavija mbaka kipigiti kino niheshile kuugolosa mkono wangu na kukutoa na mitamu gweye hamoja na wanhu zako, na muhawile mwishile kusegezigwa muulumwengu. ");
INSERT INTO zajp_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ila nie nikuleka gweye ugendelele kuwa mgima, giladi nilaguse mhiko zangu, na twaga jangu ditangigwe muulumwengu wose. ");
INSERT INTO zajp_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Hata avo ung'hali ugendelela kukiinula mwenyego mkulema kuwaleka wanhu zangu wachole. ");
INSERT INTO zajp_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Mayo kipigiti kamba kino noigala mvula ng'hulu ya mabwe itoe, mvula ya mabwe yondaitoe hainatoa muisi ya Misili songela vuilumbigwe mbaka sambi. ");
INSERT INTO zajp_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Avo lagiza kamba wang'onyo zako na watumigwa zako walawe mmigunda wengile mzing'anda, kwavija munhu ama mng'onyo yoyose yondayakale hanze ya ing'anda kipigiti imvula ya mabwe vondaitoe, kodanganhika.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Waja iwasalange wa Falao wakalile wozidumba mbuli za MNDEWA walopola kuwengiza nyakadala zao na wang'onyo zao mzing'anda. ");
INSERT INTO zajp_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ila waja iwasalange wakalile wozizabuza mbuli za MNDEWA wawaleka nyakadala zao na wang'onyo zao hanze mmigunda. ");
INSERT INTO zajp_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Abaho MNDEWA kamulongela Musa, “Golosa mkono wako uchana kuulanga giladi mvula ya mabwe itoe muisi yose ya Misili, itoe mwa wanhu na wang'onyo na mmiche yose ya muisi ya Misili.” ");
INSERT INTO zajp_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Avo Musa kainula fimbo yake kuulanga, MNDEWA kagala miladu na mvula ya mabwe, na mimwemwe imweka mbaka hasi muisi. Avo MNDEWA kaitenda mvula ya mabwe itoe muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Mvula ya mabwe itoa na mimwemwe imweka kila hanhu. Ukala mnyukwamnyukwa wihile ng'hani wa mvula ya mabwe ukalile haunalawilila muisi yose ya Misili songela viigaluke undewa. ");
INSERT INTO zajp_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ija imvula ya mabwe ibananga kila kinhu kikalile hanze muisi yose ya Misili, wanhu na wang'onyo, vivija mvula ija ya mabwe iibena miche yose ya mmigunda na kuibena mibiki yose ya mmigunda. ");
INSERT INTO zajp_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ila muisi ya Gosheni, kuwakalile Waislaeli, kukala bule mvula ya mabwe. ");
INSERT INTO zajp_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Abaho Falao kawakema Musa na Haloni, na kuwalongela, “Mwanza uno nie niloza, MNDEWA katenda galumbile, na nie na wanhu zangu tuhonyela. ");
INSERT INTO zajp_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Miladu na mvula ino ya mabwe ibanza, tambikeni ha MNDEWA yaisegeze. Nowaleka mchole, hailondigwa mkale hano tena.” ");
INSERT INTO zajp_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa kamulongela, “Kipigiti kikino nihalawa mdiwambo dino, nogagolosa makono gangu ha MNDEWA, na imiladu yonyamala, na hakuwa tena na mvula ya mabwe, giladi uvitange kamba MNDEWA iyo mwene ulumwengu uno. ");
INSERT INTO zajp_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ila nivimanya gweye na salange zako hamumdumba MNDEWA Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Shaili na miche ya kitani vose vibanangigwa, kwavija shaili ikala ipile, na kitani ikala ilava malua. ");
INSERT INTO zajp_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ila ngano na ngano senhambo hazibanangigwe kwavija vikala vikawile kwipa. ");
INSERT INTO zajp_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Avo Musa kasegela haulongozi wa Falao na kuchola hanze ya idiwambo. Kenula makono gake uchana ha MNDEWA, na ija imiladu inyamala na imvula ya mabwe igagula, na mvula haitoile muisi. ");
INSERT INTO zajp_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ila Falao viyonile mvula na mvula ya mabwe na ija imiladu inyamala, kaloza kabili, heyo hamoja na salange zake waitenda mioyo yao kuwa midala. ");
INSERT INTO zajp_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Avo moyo wa Falao uwa mdala, hawalekile Waislaeli wachole, kamba MNDEWA viyalongile kubitila Musa. ");
INSERT INTO zajp_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Abaho MNDEWA kamulongela Musa, “Genda ha Falao, kwavija nie niutenda moyo wake hamoja na mioyo ya salange zake kuwa midala, giladi nilaguse mizonza yangu ino kumwao, ");
INSERT INTO zajp_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","na muwalongele wanenu na wazukulu zenu vija vuniwatendile Wamisili kuwa wabozi na vija vunitendile mizonza hagatigati yao giladi mweye m'vitange kamba nie iyo MNDEWA.” ");
INSERT INTO zajp_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Avo Musa na Haloni wachola ha Falao na kumulongela, “MNDEWA Mulungu wa Waeblania kolonga vino, ‘Kolema kuihumulusa mwenyego haulongozi wangu mbaka zua jaki? Waleke wanhu zangu wachole giladi wakanitambikile nie. ");
INSERT INTO zajp_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Kwavija kamba uhalema kuwaleka wanhu zangu wachole, mayo nowagala nzige muisi yako. ");
INSERT INTO zajp_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Woigubika isi yose, avo haduhu munhu yondayadahe kona isi. Woja vinhu visigale vilekigwe na mvula ya mabwe, na woja mibiki yenu yose ili mmigunda. ");
INSERT INTO zajp_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Womema mzing'anda zako, mzing'anda za salange zako, na mzing'anda za Wamisili wose, kinhu hakinakoneka na watata zako ama wahenga zako, songela viwaleligwe mbaka sambi.’ ” Abaho kahinduka na kulawa ha Falao. ");
INSERT INTO zajp_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Salange wa Falao wamulongela, “Munhu ino kowa mtego kumwetu mbaka zua jaki? Waleke wanhu wano wachole, giladi wakamtambikile MNDEWA Mulungu wao. Mbaka sambi hunavitanga kamba isi ya Misili ibanangigwa?” ");
INSERT INTO zajp_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Avo Musa na Haloni wabwezigwa ha Falao, na Falao kawalongela, “Gendeni mkamtambikile MNDEWA Mulungu wenu. Ila wanhu walihi hasa wondawachole?” ");
INSERT INTO zajp_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa kamwidika, “Tochola na wamhale zetu na wavyele zetu, tochola na wanetu wa kimbigalo na wa kitwanzi, na tochola na ng'ombe zetu na ng'hondolo zetu, kwavija tolondigwa tutende lusona ha MNDEWA.” ");
INSERT INTO zajp_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Falao kalonga, “Noiduila ha MNDEWA, siwaleka muwasole watwanzi zenu na wanenu! Kweli yolagusa kamba mna ngelegeza zihile mmioyo yenu. ");
INSERT INTO zajp_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Havidahika! Wambigalo weiyeka wawo wondawachole kumtambikila MNDEWA, kwavija kino kicho chumkalile mpula.” Abaho Musa na Haloni wawingigwa kulawa haulongozi wa Falao. ");
INSERT INTO zajp_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Abaho MNDEWA kamulongela Musa, “Golosela mkono wako muisi ya Misili giladi nzige weze muisi waje kila mche wotile muisi, miche yose ilekigwe na ija imvula ya mabwe.” ");
INSERT INTO zajp_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Avo Musa kenula fimbo yake uchana muisi ya Misili, na MNDEWA kaugala ubeho muisi kulawa ulawilo wa zua imisi yose na kilo yose. Viivikile imitondo, uja uubeho kulawa ulawilo wa zua ukala ugalile nzige. ");
INSERT INTO zajp_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Nzige wengila muisi ya Misili na kukala muisi yose. Dikala dale kulu ng'hani da nzige dikalile hadinakoneka na hadidaha koneka kabili. ");
INSERT INTO zajp_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Waigubika isi yose, na isi yose igaluka kuwa nhitu. Waija miche yose ya muisi na mijo yose ya mmibiki isigale kipigiti cha mvula ya mabwe, haduhu hata tepo dimwe disigale, haduhu m'biki ama mche muisi yose ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Hima Falao kawakema Musa na Haloni na kulonga, “Niloza ha MNDEWA Mulungu wenu na kumwenu mweye. ");
INSERT INTO zajp_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Avo vigeleni kumgongo vilozo vangu mwanza uno tu! Na mnitambikile ha MNDEWA Mulungu wenu yawasegeze nzige wano wondawatende kila kinhu kidanganhike.” ");
INSERT INTO zajp_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Abaho Musa kasegela haulongozi wa Falao na kutambika ha MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Na MNDEWA kauhindula ubeho wa ulawilo wa zua na kuugala ubeho wa uswelo wa zua uli na mhiko, na uwahembelusa iwanzige na kuwagala kuna Ibahali Ndung'hu. Haduhu hata nzige imwe yasigale muisi yose ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ila MNDEWA kautenda moyo wa Falao kuwa mdala, avo hawalekile Waislaeli wachole. ");
INSERT INTO zajp_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Abaho MNDEWA kamulongela Musa, “Golosa mkono wako uchana kuulanga, giladi kuwe na ziza kulu muisi yose ya Misili, ziza ajo dondadiwatende wanhu wababasile.” ");
INSERT INTO zajp_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Avo Musa kagolosa mkono wake uchana kuulanga na ziza tititi diigubika isi yose ya Misili mmazua madatu. ");
INSERT INTO zajp_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Wanhu hawakiiyonile, na mmazua madatu hawadahile kusegela haja hawakalile, ila haja hawakalile Waislaeli kukala na mulangaza. ");
INSERT INTO zajp_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Falao kamkema Musa na kulonga, “Gendeni mkamtambikile MNDEWA, mweye hamoja na watwanzi zenu na wanenu, ila ng'hondolo, menhe, na ng'ombe zenu wasigale bahano.” ");
INSERT INTO zajp_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ila Musa kalonga, “Utuleke tuchole na wang'onyo zetu sama ya kulava nhosa za kuchinja na nhosa za kulukuza ha MNDEWA Mulungu wetu. ");
INSERT INTO zajp_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Wang'onyo zetu wose tochola nao, haduhu hata imwe yondayalekigwe kuchugu. Kwavija tolondigwa tusagule kulawa mwa wang'onyo wano, waja wondatuwalave nhosa ha MNDEWA Mulungu wetu. Hata avo hatuvitanga vija vondatumtambikile MNDEWA mbaka vondatuvike haja.” ");
INSERT INTO zajp_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","MNDEWA kautenda moyo wa Falao kuwa mdala, na hawalekile wachole. ");
INSERT INTO zajp_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Falao kamulongela Musa, “Segela hameso gangu! Sambinikone kabili haulongozi wangu! Zua dondauchone kihanga changu, kodanganhika.” ");
INSERT INTO zajp_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa kalonga, “Kamba vija vuulongile! Hunyona kabili nie nize hano haulongozi wako.” ");
INSERT INTO zajp_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Abaho MNDEWA kamulongela Musa, “Nogala utamu umwe uyagwe wihile ng'hani ha Falao na isi yose ya Misili. Uhesha utamu uno, kowaleka mulawe kulawa muisi ino. Yahawaleka mchole, kowaleka dimwe kwa dimwe. ");
INSERT INTO zajp_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Walongele wanhu wa Islaeli watwanzi na wambigalo kamba, wapule vinhu va zahabu na madini ga feza kulawa ha Wamisili wokala behi nao.” ");
INSERT INTO zajp_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","MNDEWA kawatenda Waislaeli watogoligwe na Wamisili. Na Musa kakala munhu yoneke kuwa munhu mkulu ng'hani muisi ya Misili, yahishimilwe na salange za Falao hamoja na wanhu wa Misili. ");
INSERT INTO zajp_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Abaho Musa kamulongela Falao, “MNDEWA kolonga vino, ‘Lelo kilo kikulu nobita muisi ya Misili, ");
INSERT INTO zajp_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","na kila mwana mbigalo wa udele muisi ya Misili kodanganhika, songela mwana mbigalo wa udele wako gweye, ayo yokala mkigoda chako cha undewa, mbaka mwana mbigalo wa udele wa nyakadala wa kitwanzi yali ha dibwe jake da kusiginhila, na wana wa udele wa wang'onyo wose vivija wodanganhika. ");
INSERT INTO zajp_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Abaho kowa na kililo kikulu muisi yose ya Misili, kihile ng'hani acho hakinalawilila mazua ga kuchugu na hakiza kulawilila kabili. ");
INSERT INTO zajp_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ila hanhu hondawakale Waislaeli hopozika, haduhu umbwa yondayawabwakile Waislaeli, haduhu umbwa yondayawabwakile wanhu ama wang'onyo zao, giladi mvitange kamba MNDEWA keka mbaka hagatigati ya Waislaeli na Wamisili. ");
INSERT INTO zajp_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Abaho salange zako wano wose wokwiza kumwangu nie na kufugama mavindi wokiinamila wolonga, “Gweye na wanhu wokukoleleza gweye segeleni.” Abaho nosegela.’ ” Abaho Musa kasegela na lusango kulawa ha Falao. ");
INSERT INTO zajp_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","MNDEWA kamulongela Musa, “Falao hakutegeleza, giladi mizonza yangu yongezeke muisi ya Misili.” ");
INSERT INTO zajp_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa na Haloni waitenda mizonza ino yose haulongozi wa Falao. Ila MNDEWA kautenda moyo wa Falao kuwa mdala, na hawalekile wanhu wa Islaeli kulawa hanze ya isi yake. ");
INSERT INTO zajp_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","MNDEWA kawalongela Musa na Haloni muisi ya Misili, ");
INSERT INTO zajp_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mulenge uno wowa mulenge wa ichanduso wa mulao kumwenu. ");
INSERT INTO zajp_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Walongele wanhu wose wa Islaeli kamba mdizua da longo dimwe da mulenge uno, kila mbigalo yamsole mwanang'hondolo ama mwanamenhe sama ya wanhu wa ng'anda yake. ");
INSERT INTO zajp_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kamba wanhu wa ng'anda yake wadodo mmheta na hawadaha kumja mwanang'hondolo mgima, basi na waiduganye na wanhu wa ng'anda ya behi yao wamje hamoja. Ija imwanang'hondolo kolondigwa yagoligwe vidanga viilingile na wanhu wondawamje. ");
INSERT INTO zajp_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Mng'onyo yondamumsagule kolondigwa yawe songolomi wa mulao umwe, sambiyawe na ulemale, umsole kulawa mkikwama cha ng'hondolo ama menhe. ");
INSERT INTO zajp_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Abaho mdizua da longo dimwe na nne da mulenge uno, wanhu wose wa Islaeli wolondigwa wawachinje iwang'onyo mkipigiti cha ichungulo. ");
INSERT INTO zajp_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Wasole mulopa kidogo wa iwang'onyo na kuubaka mmihimili mibili ya zinyivi zao na mkizingiti cha uchana cha izing'anda zondawadile iwang'onyo. ");
INSERT INTO zajp_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Wolondigwa wazije zinyama ikilo iija, wolondigwa wazije zikokigwe mmoto, hamoja na mikate ilibule mela hamoja na mboga zili usungu. ");
INSERT INTO zajp_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Sambizidigwe zili mbisi ama zitogoswe mmazi, ila mzikoke mmoto hamoja na ditwi jake, migulu yake, na vinhu vake va mgati. ");
INSERT INTO zajp_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Sambimsigaze kinhu chochose mbaka imitondo. Kamba kuna kinhu chochose kisigale mbaka imitondo, molondigwa mkisome. ");
INSERT INTO zajp_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Vino vivo vondamuije. Muje kuno kila munhu yafungile mkwiji mchuno chake, na kuvala ng'hwabasa zake mmagulu gake, na kuigoga fimbo yake mumkono wake, na molondigwa mumje himahima. Kwavija luno lulo Lusona lwa Pasaka lutendigwa sama ya kunihishimila nie, MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Kwavija ikilo ija nobita muisi yose ya Misili na kumtoa kila mwana wa udele wa kimbigalo wa munhu na mng'onyo, na noigala nhaguso ha miungu yose ya Misili. Nie iyo MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Uja umulopa mmihimili wowa kilaguso kumwenu mzing'anda zondamkale, na nihawona umulopa, nobita uchana yenu, na haduhu utamu wihile ng'hani wondauwabanange mweye kipigiti vondaniitoe isi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Zua dino dowa zua da ng'humbukila ya gaja ganitendile kumwenu. Molondigwa mdideng'hele diwe lusona ha nie, MNDEWA, mzing'holo zenu zose, na iwe ndagizi ya milao yose ikwiza.” ");
INSERT INTO zajp_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","MNDEWA kalonga, “Mmazua saba dieni mikate ilibule mela. Mdizua da ichanduso molondigwa msegeze mela jose mzing'anda zenu, kwavija munhu yoyose yoja mkate uli na mela songela zua da ichanduso mbaka zua da saba kolondigwa yasegezigwe kulawa mmwanza wa wanhu wa Islaeli. ");
INSERT INTO zajp_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Zua da ichanduso muwe na mting'hano ung'alile, vivija na zua da saba muwe na mting'hano ung'alile. Sambimsang'hanike sang'hano yoyose mmazua gano mabili, ila ino iyo sang'hano yondamuitende, telekeni mandia giladi kila munhu yaje. ");
INSERT INTO zajp_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Tendeni Lusona lwa Mikate Ilibule Mela, kwavija lowakumbusa kamba, dino dijo zua nie diniilavile mitala yenu kulawa muisi ya Misili. Mulutende lusona luno mmilelo yenu yose. ");
INSERT INTO zajp_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Dieni mikate ilibule mela, songela ichungulo ya zua da longo dimwe na nne, mbaka ichungulo ya zua da malongo mabili na imwe da mulenge wa ichanduso. ");
INSERT INTO zajp_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Mmazua saba sambikuwe na mela mzing'anda zenu, kwavija munhu yoyose yondayaje mandia gali na mela kolondigwa yasegezigwe kulawa mmwanza wa wanhu wa Islaeli, kamba yahawa muhenza ama mwenekae. ");
INSERT INTO zajp_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Sambimuje kinhu chochose kili na mela mgati yake. Kokose kondamuwe, dieni mikate ilibule mela.” ");
INSERT INTO zajp_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musa kawakema wavyele wose wa Islaeli na kuwalongela, “Gendeni hima mkawasagule wanang'hondolo ama wanamenhe muwachinje, giladi milango yenu itende Lusona lwa Pasaka. ");
INSERT INTO zajp_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ukingeni umulopa mumkungu, abaho soleni vitambi va m'biki ukemigwa hisopo, vizabikeni mmulopa, abaho bakeni m'vizingiti va uchana va izinyivi na mmihimili ya mumgwazo ya izinyivi za ng'anda zenu. Na munhu yoyose sambiyalawe hanze kubitila mulwivi mbaka imitondo. ");
INSERT INTO zajp_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Kwavija MNDEWA yahabita muisi kuwakoma Wamisili, kowona umulopa muna ivizingiti va uchana ya izinyivi na mmihimili mibili ya izinyivi, kobita uchana ya izing'anda zija na hamuleka im'bananzi yengile mzing'anda zenu na kuwakoma. ");
INSERT INTO zajp_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Molondigwa mzigoge ndagizi zino ziwe ndagizi za digunge, kumwenu mweye hamoja na wanenu. ");
INSERT INTO zajp_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Muhengila muna iisi ija MNDEWA iyekile kilagano na mweye kamba kowagwelela, mkalutende lusona luno. ");
INSERT INTO zajp_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Na wanenu wahawauza, ‘Lusona luno nhegulo yake choni?’ ");
INSERT INTO zajp_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","walongeleni, ‘Ino iyo nhosa ya kuchinja wang'onyo ha MNDEWA ikemigwa Pasaka, MNDEWA ayo yabitile uchana ya izing'anda za Waislaeli muisi ya Misili na kuzileka ng'anda zetu kipigiti viyawakomile wana wa udele wa Wamisili.’ ” Abaho Waislaeli wose wafugama mavindi wainamila mbaka hasi na kutambika. ");
INSERT INTO zajp_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Waislaeli wachola na kutenda kamba MNDEWA viyawalagize Musa na Haloni. ");
INSERT INTO zajp_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Kilo kikulu MNDEWA kawakoma wana wa udele wose wali muisi ya Misili, songela mwana mbigalo wa udele wa Falao, ayo yakalile mkigoda chake cha undewa, mbaka mwana mbigalo wa udele wa mfungigwa yakalile mdigati da hasi diliziza, na wana wa udele wa wang'onyo. ");
INSERT INTO zajp_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Falao na salange zake na wanhu wose wa Misili wenuka ikilo ija, na kukala na kililo kikulu ng'hani muisi yose ya Misili, kwavija hakukalile na ng'anda ikalile bule munhu yadanganhike. ");
INSERT INTO zajp_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Abaho ikilo iija Falao kawakema Musa na Haloni na kuwalongela, “Halaweni! Segeleni kulawa mwa wanhu zangu, mweye hamoja na Waislaeli wose! Gobokeni, gendeni mkamtambikile MNDEWA kamba vumpulile. ");
INSERT INTO zajp_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Soleni vikwama venu va ng'hondolo na ng'ombe kamba vumulongile na muhalawe. Vivija munimoteze na nie.” ");
INSERT INTO zajp_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Wamisili wose wawayalalila Waislaeli walopole kulawa muisi yao, kwavija walonga, “Kamba muhasigala hano, tweye tose todanganhika.” ");
INSERT INTO zajp_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Avo wanhu wasola mitonge ya ngano ikandigwe bila mela, waimemeza m'vikalango vao va kukandila, waizingiliza m'vivalo vao, na kuipapa mmaega gao. ");
INSERT INTO zajp_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Waislaeli wakala weshile kutenda kamba Musa viyawalongele. Wakala wawapulile Wamisili vinhu va zahabu na madini ga feza, hamoja na vivalo. ");
INSERT INTO zajp_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","MNDEWA kawatenda Waislaeli watogoligwe na Wamisili, avo wawagwelela chochose chawalondile. Avo wawabokonya Wamisili vinhu vao. ");
INSERT INTO zajp_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Waislaeli wasonga mwanza kulawa wambo da Lamesesi mbaka kiwambo cha Sukuti, wotembela na magulu. Wakala wambigalo laki sita, uhaleka watwanzi na wana wadodo. ");
INSERT INTO zajp_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Na wanhu wayagwe bwando wakalile si Waislaeli wachola hamoja na hewo hamoja na madale makulu ga ng'hondolo, menhe, na ng'ombe. ");
INSERT INTO zajp_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Woka mikate ilibule mela kulawa mmitonge ya ngano iwalawile nayo kulawa Misili, ija imitonge ya ngano ikala bule mela kwavija wawingigwa kulawa muisi ya Misili avo hawapatile kipigiti cha kusasala mandia gao. ");
INSERT INTO zajp_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Waislaeli wakala muisi ya Misili mkipigiti cha milao mia nne na malongo madatu (430). ");
INSERT INTO zajp_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Vuimalile milao mia nne na malongo madatu, zua didija mitala yose ya MNDEWA isegela kulawa muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ikilo ija MNDEWA kagonelela mkuwemiliza kipigiti viyakalile yowalava Waislaeli kulawa muisi ya Misili. Na ikilo ya zua kamba didija Waislaeli wose hamoja na milelo yao ikwiza wolondigwa wagonelele mkumuhishimila MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","MNDEWA kawalongela Musa na Haloni, yolonga, “Zino zizo ndagizi za Pasaka. Muhenza sambiyaje mandia ga Pasaka, ");
INSERT INTO zajp_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ila nyakadala uyumgulile na wishile kumwingiza kumbi kodaha kuja mandia ga Pasaka. ");
INSERT INTO zajp_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ila haduhu muhenza ama kibalua yalekile kuwa Muislaeli yondayaje mandia ga Pasaka. ");
INSERT INTO zajp_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Yolondigwa idigwe muna ing'anda imwe, na kinhu chochose kulawa muna imng'onyo hiyo sambikilavigwe hanze ya ng'anda ija, na luzege lwa ija ing'hondolo wa Pasaka sambiulubene. ");
INSERT INTO zajp_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Wanhu wose wa Islaeli wolondigwa walutende lusona luno. ");
INSERT INTO zajp_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Muhenza yokala hamoja na mweye yahalonda kulutenda Lusona lwa Pasaka ya MNDEWA, kolondigwa yawengize kumbi wambigalo wose wali mng'anda yake, abaho kolinga kamba Muislaeli wa kuvumbuka. Ila munhu hanakwingila kumbi sambiyaje mandia gano. ");
INSERT INTO zajp_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ndagizi zino zima sama ya Waislaeli wa kuvumbuka hamoja na wahenza wokala mmwanza wenu.” ");
INSERT INTO zajp_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Waislaeli wose watogola na kugatenda gaja MNDEWA gayawalagize Musa na Haloni. ");
INSERT INTO zajp_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Mdizua didija MNDEWA kailava mitala ya Waislaeli hanze ya isi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","MNDEWA kamulongela Musa, ");
INSERT INTO zajp_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Wana wose wa udele wa kimbigalo muwabagule sama yangu nie, kwavija kila mwana mbigalo wa udele wa Muislaeli wangu nie, mwana mbigalo wa munhu ama mng'onyo.” ");
INSERT INTO zajp_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa kawalongela wanhu, “Kumbukileni zua dino dimulawile muisi ya Misili, ako kumkalile nyakadala, kwavija MNDEWA kawalava mweye kulawa haja na mkono wene mhiko, avo sambimje mikate ili na mela. ");
INSERT INTO zajp_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Lelo muna umulenge uno wa Habibu, mosegela. ");
INSERT INTO zajp_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","MNDEWA kawagala muisi ya Wakanaani, Wahiti, Waamoli, Wahivi, na Wayebusi, isi iyawaduilile wahenga zenu kamba kowagwelela mweye, isi ili na lutuba na ugoli, avo molondigwa mtende lusona mmulenge uno mmilao yose ikwiza. ");
INSERT INTO zajp_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Mazua saba molondigwa kuja mikate ilibule mela, na mdizua da saba kowa na lusona sama ya MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Mikate ilibule mela yolondigwa idigwe mmazua saba, sambiwoneke mkate uli na mela mmwenu na sambijoneke mela mmwanza wenu na muisi yenu yose. ");
INSERT INTO zajp_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Mdizua dija vondamsonge ulusona, wasimulile wanago kamba, ‘Notenda mbuli zino zose sama ya gaja gayatendile MNDEWA kipigiti vunilawile muisi ya Misili.’ ");
INSERT INTO zajp_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Lusona luno londalutendeke kila mulao lowa kamba kilaguso mumkono wenu na lukumbuso m'vihanga venu kamba Malagizo ga MNDEWA golondigwa mgalonge na kuifunza, kwavija MNDEWA kawalava muisi ya Misili na mkono wake wene mhiko. ");
INSERT INTO zajp_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Mdigoge lagano dino mkipigiti kikigwe kulawa mulao umwe mbaka mulao uyagwe. ");
INSERT INTO zajp_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“MNDEWA yahawengiza muisi ya Wakanaani na kuwagwelela mweye isi ija kamba viyawaduilile mweye na wahenga zenu, ");
INSERT INTO zajp_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","molondigwa mmulavile MNDEWA wana wenu wose wa udele wa kimbigalo na wana wa udele wose wa kimbigalo wa wang'onyo zenu kwavija wano wose wake heyo. ");
INSERT INTO zajp_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ila kila chaudele wa mhunda kolondigwa umkombole na mwanang'hondolo, na kamba humkombole, kolondigwa um'bene singo yake. Kila mwana mbigalo wa udele mmwanza wa wanago kolondigwa umkombole. ");
INSERT INTO zajp_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Mazua ga hamwande mwanago yahakuuza, ‘Mbuli ino nhegulo yake choni?’ gweye umulongele, ‘MNDEWA katulava kulawa muisi ya Misili na mkono wene mhiko, ako kutukalile nyakadala. ");
INSERT INTO zajp_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ahaja Falao viyakalile na moyo mdala na kulema kutuleka tusegele, MNDEWA kawakoma wana wose wa udele wa kimbigalo muisi yose ya Misili, wana mbigalo wa udele wa wanhu na wa wang'onyo. Avo, kino kicho kilamso cha nie kumulava nhosa ha MNDEWA kila mwana mbigalo wa udele wa mng'onyo wangu na kumkombola na hela kila mwanangu wa udele wa kimbigalo.’ ");
INSERT INTO zajp_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Lusona luno lowa kamba kilaguso mmakono genu na lowa kamba utango m'vihanga venu kamba MNDEWA katulava muisi ya Misili na mkono wake wene mhiko.” ");
INSERT INTO zajp_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Falao viyawalekile Waislaeli wachole, Mulungu hawalongozele kunzila ilongoze kuna iisi ya Wafilisti hata kamba nzila ija ikala nguhi, kwavija Mulungu kalonga, “Kamba wanhu wano wahaiting'hana na ng'hondo, wogalula ngelegeza zao na kubweleganya muisi ya Misili.” ");
INSERT INTO zajp_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Avo Mulungu kawalongoza kubitila nzila ya mzunguluko ya muluwala ng'ambu ya Bahali Ndung'hu. Waislaeli wakwela na kulawa hanze ya isi ya Misili kuno waisasale na ng'hondo. ");
INSERT INTO zajp_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa kaisola mizege ya Usufu, kwavija Usufu kawalonda Waislaeli waiduile avija viyalongile, “Mulungu kokwiza kuwakombola, yeheza kuwakombola, muisole na mizege yangu kulawa hano mchole hamoja nayo.” ");
INSERT INTO zajp_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Viwasegele mkiwambo cha Sukuti, wachola kwika ng'hambi hanhu hokemigwa Esamu, halumambukizile uluwala. ");
INSERT INTO zajp_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Kipigiti cha imisi MNDEWA kawalongola haulongozi wao mdiwingu dilingile na nguzo giladi yawalagusile nzila, na kipigiti cha ikilo kawalongola haulongozi wao mmoto ulingile na nguzo giladi yawagwelele mulangaza giladi watembele misi na kilo. ");
INSERT INTO zajp_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Dija diwingu dilingile na nguzo mazua gose diwalongola kipigiti cha imisi, na uja umoto ulingile na nguzo uwalongola kipigiti cha ikilo. ");
INSERT INTO zajp_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Abaho MNDEWA kamulongela Musa, ");
INSERT INTO zajp_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Walongele Waislaeli wabwele kuchugu na kwika ng'hambi haulongozi wa kiwambo cha Pi-Hahiloti, hagatigati ya kiwambo cha Migidoli na Bahali Ndung'hu, behi na kiwambo cha Baali-Zefoni. ");
INSERT INTO zajp_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Falao kokwagiza, ‘Waislaeli wozunguluka muisi mkwazanywa, kuno wazungulukwe na luwala.’ ");
INSERT INTO zajp_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Na nie nougela udala moyo wa Falao, na heyo kowakweleleza. Ila nie noigwelela mwenyego yenzi kubitila Falao na asikali zake wose. Na Wamisili wovitanga kamba nie iyo MNDEWA.” Avo Waislaeli watenda kamba viwalongeligwe. ");
INSERT INTO zajp_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Falao viyalongeligwe kamba Waislaeli wachola, ngelegeza zake na za salange zake zigaluka, avo kalonga, “Tutenda choni? Tuwaleka Waislaeli wachola na kuwatenda sambiwawe nyakadala zetu!” ");
INSERT INTO zajp_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Avo kawalagiza salange zake wadisasale kwama jake abaho kawasola asikali zake. ");
INSERT INTO zajp_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Kaisola mikwama mia sita inogile hamoja na mikwama yose iyagwe ya isi ya Misili, na kila kwama dikala na maaskali mgati yake. ");
INSERT INTO zajp_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","MNDEWA kautenda moyo wa Falao kuwa mdala, avo kawakoleleza Waislaeli wakalile wasegele kuno wokiidandaya. ");
INSERT INTO zajp_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Wamisili wawakoleleza. Falasi wose wa Falao, mikwama yake, wagala mikwama zake, na asikali zake wawakoleleza na kuwavika hamgwazo wa Bahali Ndung'hu, haulongozi wa kiwambo cha Pi-Hahiloti behi na kiwambo cha Baali-Zefoni hawekile ng'hambi yao. ");
INSERT INTO zajp_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Falao viyawakwenhukile Waislaeli, Waislaeli walola kukisogo, na kuwona Wamisili wowakweleleza. Waislaeli wadumba ng'hani na kumulilila MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Wamulongela Musa, “Kwavija kuduhu mapanga kuisi ya Misili, kileka mana utulavile na kutugala kutali giladi tudanganhikile muluwala? Habali ututendele gano, kutulava muisi ya Misili? ");
INSERT INTO zajp_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Kipigiti vitukalile Misili hatukulongele kamba, ‘Tuleke tuwasang'hanikile Wamisili’? Vihanogile tuwasang'hanikile Wamisili kubanza kudanganhikila muluwala.” ");
INSERT INTO zajp_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ila Musa kawalongela wanhu, “Sambimdumbe. Mweye mtamanileni Mulungu, mwone ukombola MNDEWA wondayawalagusile mweye lelo. Wamisili muwona lelo, hamwiza kuwona kabili. ");
INSERT INTO zajp_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","MNDEWA kowagombela mweye, na mweye monyamala tulu.” ");
INSERT INTO zajp_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Abaho MNDEWA kamulongela Musa, “Habali ugendelela kunililila nie? Walongele Waislaeli wagendelele na mwanza. ");
INSERT INTO zajp_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Inula fimbo yako na uugolose mkono wako kuna ibahali, na mazi goigola na Waislaeli woikanhiza ibahali mkubita muisi inyalile. ");
INSERT INTO zajp_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Abaho noitenda mioyo ya Wamisili kuwa midala avo na hewo wowasondolela hachugu chenu, avo nopata yenzi mkum'bananga Falao na asikali zake wose, mikwama yake, na wagala mikwama zake. ");
INSERT INTO zajp_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Na Wamisili wovitanga kamba nie iyo MNDEWA ahaja vondanipate yenzi kubitila Falao na mikwama yake na wagala mikwama zake.” ");
INSERT INTO zajp_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Msenga wa Mulungu wa kuulanga yakalile haulongozi wa Waislaeli kasegela na kubwela kuchugu cha Waislaeli, na dija idiwingu dilingile na inguzo vivija disegela haulongozi na kubwela kuchugu chao, ");
INSERT INTO zajp_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","dija idiwingu dilingile na inguzo dikala hagatigati ya ididale da asikali wa Misili na Waislaeli. Dija idiwingu dilingile na nguzo digela ziza kudidale da asikali wa Misili, na kugala mulangaza mwa wanhu wa Islaeli. Avo dale da asikali wa Misili hadidahile kuwakwenhukila Waislaeli ikilo ngima. ");
INSERT INTO zajp_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Abaho Musa kaugolosela mkono wake kuna ibahali, na MNDEWA katenda nzila mmazi na ubeho wene mhiko kulawa ulawilo wa zua, ubeho ukalile ubuma kilo yose, na kugatenda mazi ga ibahali gakiigole na kuwa isi inyalile. ");
INSERT INTO zajp_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Waislaeli wabita m'bahali kuno wobojaga isi inyalile, mazi gatenda viwambaza ng'ambu yao ya ukumoso na ukulume. ");
INSERT INTO zajp_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Wamisili wawakoleleza, na falasi wose wa Falao na mikwama yake yose na wagala mikwama zake wose. ");
INSERT INTO zajp_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Behi na usiku kucha, kulawa mmoto ulingile na nguzo na idiwingu dilingile na inguzo, MNDEWA kalola hasi na kuwatenda asikali wa Wamisili wazanywe. ");
INSERT INTO zajp_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Kagatenda maguludumu ga mikwama yao ganamate, avo zizunguluka na mkwekwe. Waja Iwamisili wailongela, “Natukimbile kulawa hano kwavija MNDEWA kowagombela Waislaeli na kututoa tweye.” ");
INSERT INTO zajp_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Abaho MNDEWA kamulongela Musa, “Golosela mkono wako kuibahali giladi mazi gawabwelele na kuwagubika Wamisili, mikwama yao, na wagala mikwama zao.” ");
INSERT INTO zajp_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Avo Musa kaugolosela mkono wake kuibahali, na viivikile imitondo, bahali isonga kubweleganya kamba vija viikalile. Wamisili viwakalile wogakimbila igamazi, MNDEWA kawakung'hunila m'bahali. ");
INSERT INTO zajp_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Mazi gabwela na kuigubikiza imikwama, wagala mikwama, na asikali wose wa Falao wakalile wowakweleleza Waislaeli m'bahali, hasigale hata munhu imwe. ");
INSERT INTO zajp_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ila Waislaeli wakala wobita muisi inyalile hagatigati ya ibahali kuno viwambaza va mazi vimile kumoso na ukulume. ");
INSERT INTO zajp_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Zua dija MNDEWA kawakombola Waislaeli kulawa mmakono ga Wamisili, na Waislaeli wawona Wamisili wadanganhike mumgwazo wa ibahali. ");
INSERT INTO zajp_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Na Waislaeli viwawene mhiko ng'hulu iyalaguse MNDEWA ha Wamisili, wanhu wamdumba MNDEWA na kwika nhamanila yao kumwake na ha Musa mtumigwa wake. ");
INSERT INTO zajp_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Abaho Musa na Waislaeli wamwimbila MNDEWA wila uno. “Nomwimbila MNDEWA kwavija kapata yenzi ng'hulu ng'hani. Falasi na waja wawakwelile kumgongo wasigwa m'bahali. ");
INSERT INTO zajp_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","MNDEWA iyo yonitenda nie niwe na mhiko, heyo iyo kilamso cha nie kwimba wila uno. Heyo kanikombola kulawa mwa wadumuka zangu. Heyo iyo Mulungu wangu, na nie nomtogola heyo, Mulungu wa tataangu, na nie nomuyenzi heyo. ");
INSERT INTO zajp_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","MNDEWA iyo galu wa ng'hondo. Yahweh dijo twaga jake. ");
INSERT INTO zajp_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","“Mikwama hamoja na asikali zake Falao, MNDEWA kayasila M'bahali Ndung'hu, wakulu wa asikali wa Falao wadanganhikila mbahali. ");
INSERT INTO zajp_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Vilindi va bahali viwagubika, wadidimila hasi kamba dibwe. ");
INSERT INTO zajp_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“MNDEWA, mkono wako wa ukulume una mhiko zili na yenzi, MNDEWA, mkono wako wa ukulume uwahonda wadumuka. ");
INSERT INTO zajp_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Muna iyenzi yako ng'hulu, kuwasa hasi wadumuka zako, kulava lusango lwako na kuwalukuza kamba misanze inyalile. ");
INSERT INTO zajp_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Sama ya mhumuzi za mhula yako, mazi gatenda kisugulu, gema wima kamba kiwambaza, vilindi va ibahali viwa vidala. ");
INSERT INTO zajp_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Mdumuka kaitopa, kalonga, ‘Nowakoleleza na kuwagoga. Nie nougola ugoli wao na kusola chochose kinilonda. Nodisomola zele jangu, na mkono wangu wowabananga.’ ");
INSERT INTO zajp_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ila gweye kuhumula na mhumuzi yako, na bahali iwagubika. Wadidimila kamba lisasi mmawimbi makulu. ");
INSERT INTO zajp_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“MNDEWA, yalihi mmwanza wa miungu yolinga na gweye? Yalihi yali kamba gweye, gweye uli na ukulu muung'azi, udumbiza muyenzi yako, mtenda mizonza? ");
INSERT INTO zajp_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Kuugolosa mkono wako wa ukulume, na isi iwameza wadumuka zetu. ");
INSERT INTO zajp_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Kubitila noge dilekile kuhuha kowalongoza wanhu uuwakombole, na kubitila mhiko zako kowalongoza kuukazi wako ung'alile. ");
INSERT INTO zajp_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ndewa zose zohulika na kugudema, usungu owagoga wanhu wa Ufilisti. ");
INSERT INTO zajp_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Wakulu wa Edomu wodumba, vilangizi wa Moabu wogogigwa na bwembwe, wanhu wa Kanaani mioyo yao yobogoyoka. ");
INSERT INTO zajp_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Bwembwe na kingudemo vowagoga. Kubitila mhiko za mkono wako, woituza kamba dibwe, mbaka wanhu zako, MNDEWA, vondawabite, wanhu uuwakombole kulawa muunyakadala kuja Misili. ");
INSERT INTO zajp_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Kowengiza na kuwahanda uchana ya kigongo chako, hanhu hauhasagule gweye, MNDEWA, hawe kae yako, hema da kuiting'hanila diuzengile gweye mwenyego. ");
INSERT INTO zajp_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Gweye kowa MNDEWA wa gunge na gunge.” ");
INSERT INTO zajp_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Waislaeli wabita hagatigati ya ibahali kuno wobojaga isi inyalile, ila kipigiti falasi wa Falao, mikwama yake, na wagala mikwama zake viwawakoleleze, MNDEWA kagabweza kuchugu igamazi ga ibahali na kuwagubikiza. ");
INSERT INTO zajp_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Abaho Miliamu muhokozi, lumbu jake Haloni, kasola ngoma mmakono gake, na watwanzi wose wasola ngoma zao na kumuwinzilila heyo kuno wotoa ngoma zao na kuvina. ");
INSERT INTO zajp_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miliamu kemba wila uno, “Mwimbileni MNDEWA, kwavija kapata yenzi ng'hulu ng'hani. Falasi na waja wawakwelile kumgongo wasigwa m'bahali.” ");
INSERT INTO zajp_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Abaho Musa kawalongoza Waislaeli kulawa M'bahali Ndung'hu, na kuchola mbaka kuna Uluwala lwa Shuli. Wachola mwanza wa mazua madatu muluwala, bila kuvika mazi. ");
INSERT INTO zajp_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Viwavikile hanhu hokemigwa Mala, walemelwa kugang'wa mazi ga haja, kwavija gakala gausungu. Kino kicho kilamso hanhu haja hakemigwa Mala. ");
INSERT INTO zajp_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Avo wanhu wamtwanganikila Musa, walonga, “Tung'we choni?” ");
INSERT INTO zajp_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Abaho Musa kamulilila MNDEWA, na MNDEWA kamulagusila lubiki. Musa kalwasila mgamazi, na igamazi gagaluka na ganoga kung'wa. MNDEWA kawagwelela ndagizi na malagizo na hiko kawageza. ");
INSERT INTO zajp_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Kalonga, “Kamba muhaditegeleza dizwi jangu nie, MNDEWA Mulungu wenu, na kugatenda gaja ganinogele na kugagoga malagizo gangu gose na kuzigoga ndagizi zangu zose, basi nie siwagalila vitamu viniwagalile Wamisili. Kwavija nie iyo MNDEWA niwahonya mweye.” ");
INSERT INTO zajp_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Abaho Waislaeli wavika Elimu, ako kukalile nzokwe longo dimwe na mbili na mitende malongo saba. Weka ng'hambi yao haja behi na igamazi. ");
INSERT INTO zajp_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Waislaeli wose wasegela Elimu, wavika Muluwala lwa Sini, uli hagatigati ya Elimu na Gongo da Sinai. Dino dikala zua da longo dimwe na tano da mulenge wa ikabili, mulenge umwe songela viwasegele muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Haja muluwala Waislaeli wose wawatwanganikila Musa na Haloni. ");
INSERT INTO zajp_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Waislaeli wawalongela, “Vihanogile MNDEWA yahatukomile muisi ya Misili. Ako kutukalile tuzizunguluka nongo za nyama na kuja vakuja vose vitulondile. Ila mweye mtugala hano muluwala giladi kudikoma dale dino jose na nzala.” ");
INSERT INTO zajp_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","MNDEWA kamulongela Musa, “Sambi nowatoela mvula ya vikate kulawa kuulanga sama yenu mweye mose. Kila zua wanhu wolawa hanze na kudondola vikate va zua dimwe. Mnzila ino nowageza mweye giladi nyone kamba moziwinza ndagizi zangu. ");
INSERT INTO zajp_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Zua da sita wabanzilize kudondola, wadondole mianza mibili ya ivikate vija viwakalile wodondola mazua gabitile. Abaho wavisasale.” ");
INSERT INTO zajp_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Avo Musa na Haloni wawalongela Waislaeli wose, “Ichungulo movitanga kamba MNDEWA iyo yawalavile mweye muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Imitondo moyona yenzi ya MNDEWA, kwavija kahulika vumumtwanganikile. Tweye iwo walihi hata mtutwanganikile?” ");
INSERT INTO zajp_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa kagendelela kulonga, “Movitanga kamba MNDEWA iyo yawagwelele nyama muje kipigiti cha ichungulo na vikate mwigute kipigiti cha imitondo kwavija kahulika vija vumkalile mumtwanganikila. Tweye iwo walihi hata mtutwanganikile? Hamtutwanganikile tweye ila mumtwanganikila MNDEWA.” ");
INSERT INTO zajp_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Musa kamulongela Haloni, “Walongele Waislaeli wose, ‘Izoni haulongozi wa MNDEWA, kwavija kahulika kutwanganika kumwenu.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Kipigiti Haloni viyakalile yolonga na Waislaeli wose, walola kuluwala, na bahaja yenzi ya MNDEWA ilawilila mdiwingu. ");
INSERT INTO zajp_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Abaho MNDEWA kamulongela Musa, ");
INSERT INTO zajp_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nihulika kutwanganika kwa Waislaeli. Walongele, ‘Ichungulo moja nyama, na imitondo mokwigutizwa na mikate. Abaho movitanga kamba nie iyo MNDEWA Mulungu wenu.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ichungulo ija weza ng'hwale na kuigubika ing'hambi, na imitondo dilawilila tungwe kuzunguluka ing'hambi. ");
INSERT INTO zajp_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Dija iditungwe vidisegele muluwala, voneka vidanga vibanhibanhi vizelu vili kamba balafu visigale muisi. ");
INSERT INTO zajp_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Waislaeli viwonile gano, wakiuza, “Kinhu chaki kino?” Kwavija hawavitangile kikala kinhu chaki. Musa kawalongela, “Uno uwo mkate MNDEWA uyawagwelele muje. ");
INSERT INTO zajp_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Vino vivo MNDEWA viyalagize, ‘Kila munhu yadondole kiasi choyolonda kuja. Kila munhu imwe mdihema jako kolondigwa yapate pishi mbili.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Waislaeli watenda kamba viwalagizigwe, wayagwe wadondola bwando, na wayagwe wadondola kidogo. ");
INSERT INTO zajp_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ila viwapimile, ija yadondole bwando hawile na bwando, na ija yadondole kidogo hawile na kidogo. Kila munhu kadondola kiasi chayalondile kuja. ");
INSERT INTO zajp_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Abaho Musa kawalongela, “Munhu yoyose sambiyasigaze vikate hivo mbaka imitondo.” ");
INSERT INTO zajp_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ila wanhu wayagwe hawamtegeleze Musa. Wasigaza mbaka imitondo, ila bundo na mhembele walawa mvikate vija. Avo Musa kawonela lusango. ");
INSERT INTO zajp_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kila imitondo kila munhu kadondola kiasi chayalondile kuja, na zua vidikalike dikwaka, vija ivikate visigale hasi viyangayuka. ");
INSERT INTO zajp_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Zua da sita Waislaeli wadondola ivikate mianza mibili, kila munhu pishi nne. Wakulu wose wa Waislaeli wamcholela Musa na wamulongela mbuli zija, ");
INSERT INTO zajp_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa kawalongela, “Vino vivo MNDEWA viyalagize, ‘Mayo yowa Zua da Mhumulo ding'alile, Sabato ing'alile ha MNDEWA.’ Avo lelo moke kija kimulonda kukoka na mtogose kija kimulonda kutogosa, na kija kisigale mkike mbaka imitondo.” ");
INSERT INTO zajp_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Avo wageka mbaka imitondo kamba Musa viyalagize, na imitondo iyagwe mandia gaja gasigale hagalavile bundo ama kulava mhembele. ");
INSERT INTO zajp_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa kawalongela, “Lelo dieni ivikate hivo, kwavija lelo dijo Zua da Mhumulo dikigwe sama ya MNDEWA. Lelo hakuwa na mana muisi. ");
INSERT INTO zajp_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Dondoleni ivikate mmazua sita, ila zua da saba dowa Zua da Mhumulo, mdizua hijo hakuwa na vikate muisi.” ");
INSERT INTO zajp_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Mdizua da saba wanhu wayagwe walawa hanze kudondola ivikate, ila hawapatile kinhu chochose. ");
INSERT INTO zajp_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","MNDEWA kamulongela Musa, “Mbaka kipigiti chaki mweye wanhu molema kugagoga malagizo gangu na ndagizi zangu? ");
INSERT INTO zajp_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kumbukileni kamba nie, MNDEWA, niwagwelela mweye Zua da Mhumulo, kileka mana mdizua da sita niwagwelela mandia ga kuwegutiza mmazua mabili, mdizua da saba kila munhu kolondigwa yakale hanhu hayali sambiyalawe kunze.” ");
INSERT INTO zajp_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Avo wanhu wahumula zua da saba. ");
INSERT INTO zajp_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Waislaeli wagakema mandia gaja mana. Gakala galingile kamba mbeyu ndodo nzelu, na uhagalanza, galinga kamba vikate vibanhibanhi vitendigwe na uki. ");
INSERT INTO zajp_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa kawalongela, “Vino vivo MNDEWA viyalagize, kalonga, ‘Soleni pishi mbili za mana mzike sama ya milelo yondaize, giladi wawone mkate uniwagwelele mweye muje kipigiti vumkalile muluwala, kipigiti vuniwalavile mweye kulawa muisi ya Misili.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa kamulongela Haloni, “Sola kombe, ika pishi mbili za mana mgati yake, na udike haulongozi wa MNDEWA, ikigwe sama ya milelo yenu yondaize.” ");
INSERT INTO zajp_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Milenge bwando hamwande, Haloni kaika ija imana mgati ya Idisanduku da Lagano, kamba MNDEWA viyamulagize Musa, giladi sambiibanangike. ");
INSERT INTO zajp_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Waislaeli waja mana mkipigiti cha milao malongo mane, mbaka viwavikile muisi ya Kanaani, ako kuwalondigwe kukala. ");
INSERT INTO zajp_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Pishi malongo mabili galinga na efa imwe. ");
INSERT INTO zajp_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Waislaeli wose wahalawa Muluwala lwa Sini wotembela kulawa hanhu hamwe mbaka hayagwe kamba MNDEWA viyawalagize, wachola kwika ng'hambi Lefidimu, ila hanhu haja hakalabule mazi ga kung'wa. ");
INSERT INTO zajp_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Avo Waislaeli waibamilila na Musa, wolonga, “Tugwelele mazi tung'we.” Musa kawalongela, “Habali muibamilila na nie? Habali mumgeza MNDEWA?” ");
INSERT INTO zajp_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ila wanhu wakala na ng'hilu ng'hani na wagendelela kuibamilila na Musa. Walonga, “Habali utulavile muisi ya Misili, giladi utukome na ng'hilu, tweye na wanetu na wang'onyo zetu?” ");
INSERT INTO zajp_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Avo Musa kamulilila MNDEWA, yolonga, “Niwatendeze wanhu wano? Wa mmabehi kunitoa na mibwe giladi wang'home.” ");
INSERT INTO zajp_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","MNDEWA kamulongela Musa, “Genda haulongozi wa wanhu. Wasole wavyele kidogo wa Islaeli wachole hamoja na gweye, na uisole ija ifimbo yuutoele mazi ga Lwanda lwa Naili. ");
INSERT INTO zajp_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nie nokwima haulongozi wako behi na idibwe haja Holebu. Ditoe idibwe, na mazi golawa mdibwe hijo, na wanhu wong'wa.” Musa katenda avo haulongozi wa wavyele wa Waislaeli. ");
INSERT INTO zajp_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Musa kahakema hanhu haja Masa kwavija Waislaeli waibamilila na MNDEWA, na kahakema hanhu haja Meliba kwavija wamgeza MNDEWA. Walonga, “MNDEWA ka hamoja na tweye ama vilihi?” ");
INSERT INTO zajp_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Waamaleki wachola kuwavamhila Waislaeli ako Lefidimu. ");
INSERT INTO zajp_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa kamulongela Yoshua, “Sagula wambigalo mchole mkagombe na Waamaleki, na mayo nokwima uchana hainhembeti ya ikigongo na fimbo ya Mulungu mumkono wangu.” ");
INSERT INTO zajp_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Avo Yoshua katenda kamba Musa viyamulongele, kachola kugomba na Waamaleki, kuno Musa, Haloni, na Huli wachola uchana hainhembeti ya ikigongo. ");
INSERT INTO zajp_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Kipigiti Musa viyagenule uchana makono gake, Waislaeli wahuma, ila viyagabwezile hasi makono gake, Waamaleki wahuma. ");
INSERT INTO zajp_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Makono ga Musa vugadonhile, Haloni na Huli wasola dibwe na kudika hasi yake yadikalile. Wagenuliza makono ga Musa, imwe ng'ambu ino na iyagwe ng'ambu iyagwe. Avo makono gake gagangamala mbaka ichungulo. ");
INSERT INTO zajp_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Avo Yoshua kawahuma Waamaleki. ");
INSERT INTO zajp_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Abaho MNDEWA kamulongela Musa, “Zandike mbuli zino mkitabu ziwe ng'humbukila. Mulongele Yoshua kamba nowabananga Waamaleki muisi.” ");
INSERT INTO zajp_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Avo Musa kazenga kilingo cha kulavila nhosa na kukikema, “MNDEWA iyo Bendela Yangu.” ");
INSERT INTO zajp_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Musa kalonga, “Mkono winula bendela ya Mulungu, MNDEWA kotenda ng'hondo na Amaleki kulawa mulelo umwe mbaka uyagwe.” ");
INSERT INTO zajp_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yeslo, mkulu wa nhambiko wa isi ya Midiani, tata mkwe wa Musa, kahulika kila kinhu MNDEWA Mulungu kiyawatendele Musa na wanhu zake Waislaeli kipigiti viyawalavile muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Avo Yeslo kachola ha Musa hamoja na Sipola mtwanzi wa Musa, ayo Musa yakalile yam'bwezile kumwake Yeslo, ");
INSERT INTO zajp_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","hamoja na wanage wabili wambigalo. Mwana imwe kakala yokemigwa Gelishom, kwavija mkipigiti Musa viyakalile Midiani kakala yalongile, “Nie nikala muhenza muisi ya uhenza.” ");
INSERT INTO zajp_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Mwanage wa ikabili kakala yokemigwa Eliezeli, kwavija Musa kalonga, “Mulungu wa tataangu iyo yanitazile, kanikombola kulawa mdizele da Falao.” ");
INSERT INTO zajp_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yeslo hamoja na wanage Musa na mtwanzi wake Musa, wamcholela Musa kuluwala kuyakalile yekile ng'hambi yake behi na idigongo da Mulungu. ");
INSERT INTO zajp_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Kamgalila usenga Musa, kamulongela, “Nie, Yeslo, nokwiza kumwako, hamoja na mtwanzi wako na wanago wabili.” ");
INSERT INTO zajp_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Avo Musa kachola kum'bokela tata mkwe yake, kafugama mavindi na kamnonela. Wailamsa abaho wachola mdihema da Musa. ");
INSERT INTO zajp_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa kamulongela Yeslo kila kinhu MNDEWA kiyatendile ha Falao na ha Wamisili sama ya Waislaeli, mbuli zose ndala ziwaiting'hanile mnzila, na vija MNDEWA viyawakombole. ");
INSERT INTO zajp_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yeslo viyahulike vinhu vose vinogile MNDEWA viyawatendele Waislaeli avija viyawakombole kulawa mmakono ga Wamisili, kanogelwa ng'hani, ");
INSERT INTO zajp_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","kalonga, “Yayenzigwe MNDEWA, yawakombole mweye kulawa mmakono ga Wamisili na ga Falao. Yayenzigwe MNDEWA, yawakombole wanhu zake kulawa muunyakadala. ");
INSERT INTO zajp_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Sambi novitanga kamba, MNDEWA iyo mkulu kubanza miungu yose, kwavija kawakombola Waislaeli kulawa ha Wamisili wene matopa.” ");
INSERT INTO zajp_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Abaho Yeslo kamulavila Mulungu nhosa ya kulukuza na nhosa ziyagwe, na Haloni keza hamoja na wavyele wose wa Islaeli kuja mandia hamoja na Yeslo haulongozi wa Mulungu. ");
INSERT INTO zajp_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Zua da ikabili Musa kasola nafasi yake kamba mulamula wa wanhu, na wanhu wamzunguluka songela imitondo mbaka ichungulo. ");
INSERT INTO zajp_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Kipigiti Yeslo viyagawene gaja gose Musa gayawatendele wanhu, kalonga, “Choni kino chuuwatendela wanhu? Habali utenda gano gose gweye wiyeka, na wanhu wano wose wokuzunguluka gweye songela imitondo mbaka ichungulo?” ");
INSERT INTO zajp_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa kamulongela Yeslo, “Kwavija wanhu wokwiza kumwangu na kuuza gaja goyolonda Mulungu. ");
INSERT INTO zajp_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Wanhu wahawa na ngomba yoyose, woigala kumwangu, na nie nowalamula wanhu hiwo, na nowalongela ndagizi na malagizo ga Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Yeslo kamulongela Musa, “Kinhu chuutenda hakinogile. ");
INSERT INTO zajp_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Kweli koidonheza mwenyego, moidonheza mose, gweye na wanhu wano wali hamoja na gweye. Sang'hano ino ng'hulu ng'hani kumwako, hudaha kuisang'hana gweye wiyeka. ");
INSERT INTO zajp_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Nitegeleze nie. Nie nokugwelela masala, na Mulungu kowa hamoja na gweye. Wime haulongozi wa Mulungu sama ya wanhu wose, na gweye kozigala mbuli zao kumwake. ");
INSERT INTO zajp_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Gweye uwafundize ndagizi za Mulungu, kowapetela vija vowolondigwa kukala, na kija chowolondigwa kutenda. ");
INSERT INTO zajp_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Sagula wanhu wali na udaho kulawa mmwanza wa wanhu wose, wanhu womdumba Mulungu, wanhu walibule uzenzeleganye, na awo wokwihilwa kulava ama kubokela hela za uzenzeleganye. Uwasagule wawe vilangizi wa wanhu alufu, wanhu mia, wanhu malongo matano, na wanhu longo dimwe. ");
INSERT INTO zajp_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Hewo wosang'hanika kamba walamula wa wanhu mkipigiti chose, kila mbuli ngaga woigala kumwako, ila mbuli ibuhile woilamula hewo wenyego. Avo vobuha kumwako kwavija wosangila kulamula mbuli hamoja na gweye. ");
INSERT INTO zajp_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Kamba uhatenda vino, kamba viyalagize Mulungu, huidonheza, na wanhu wano wose wochola mzikae zao kuno mbuli zao zimalile.” ");
INSERT INTO zajp_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa kamtegeleza Yeslo na kutenda gose gayalongile. ");
INSERT INTO zajp_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musa kasagula wanhu wali na udaho kulawa mwa Waislaeli wose, na kuwatenda kuwa vilangizi, wawe wakulu wa madale ga wanhu alufu, wanhu mia, wanhu malongo matano, na wanhu longo dimwe. ");
INSERT INTO zajp_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Na hewo wasang'hanika kamba walamula wa wanhu m'vipigiti vose, mbuli ngaga wazigala ha Musa, ila mbuli zibuhile wazilamula hewo wenyego. ");
INSERT INTO zajp_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Abaho Musa kamulaga Yeslo, na Yeslo kabwela muisi yake mwenyego. ");
INSERT INTO zajp_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Wanhu wa Islaeli walawa Lefidimu, na mdizua da ichanduso da mulenge wa ikadatu songela viwalawile muisi ya Misili, wavika Muluwala lwa Sinai. Hanhu haja weka ng'hambi hasi ya Idigongo da Sinai. ");
INSERT INTO zajp_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musa kakwela uchana kuiting'hana na Mulungu. MNDEWA kamkema kulawa mdigongo na kulonga, “Kino kicho chondauwalongele Waislaeli, lukolo lwa Yakobo, ");
INSERT INTO zajp_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Mweye wenyego muchona kija kiniwatendele Wamisili, na vija viniwapapile mweye kamba kimhungu viyowapapa wanage mzimbawa, na kuwagala kumwangu. ");
INSERT INTO zajp_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Kamba muhanitegeleza na kudigoga lagano jangu, mweye mowa wanhu zangu mwenyego mmwanza wa wanhu wose wali muisi. Kwavija isi yose yangu nie, ");
INSERT INTO zajp_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","mweye mowa wanhu zangu, undewa wa wakulu wa nhambiko, na undewa ung'alile.’ Zino zizo mbuli zondauwalongele Waislaeli.” ");
INSERT INTO zajp_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Avo Musa kabwela, kawakema wavyele wa wanhu, na kuwalongela mbuli zose MNDEWA ziyamulagize. ");
INSERT INTO zajp_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Wanhu wose wedika, walonga, “Totenda kila kinhu MNDEWA kiyalongile.” Avo Musa kamulongela MNDEWA mbuli ziwalongile waja iwanhu. ");
INSERT INTO zajp_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","MNDEWA kamulongela Musa, “Nokwiza kumwako mdiwingu titu, giladi wanhu wahulike vondanilonge na gweye, na kusongela sambi na kugendelela, wakutogole.” Abaho Musa kamulongela MNDEWA mbuli ziwalongile iwanhu, ");
INSERT INTO zajp_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","na MNDEWA kamulongela Musa, “Genda ha wanhu ukawalongele lelo na mayo waing'alize, na wasuluze vivalo vao. ");
INSERT INTO zajp_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Waisasale sama ya zua da ikadatu, kwavija mdizua hijo nie, MNDEWA, nohumuluka Mdigongo da Sinai hameso ga wanhu wose. ");
INSERT INTO zajp_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ika mbaka kuzunguluka idigongo, na uwalongele, ‘Teganyeni sambimkwele uchana ya idigongo ama kukwasa haja hajotele. Munhu yoyose yondayadikwase idigongo kolondigwa yakomigwe. ");
INSERT INTO zajp_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Kotoigwa na mabwe ama kuhomigwa na misale, haduhu mkono wondaumkwase. Munhu ama mng'onyo yondayadikwase idigongo kokomigwa.’ Ila mhalati ihatoigwa, wanhu wose wolekigwa wadikwenhukile idigongo.” ");
INSERT INTO zajp_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Avo Musa kahumuluka kulawa mdigongo na kuwalongela wanhu waing'alize, na hewo watenda kamba Musa viyawalongele. Na vivija wavisuluza vivalo vao. ");
INSERT INTO zajp_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Abaho kawalongela, “Isasaleni sama ya zua da ikadatu, na sambimuwase na watwanzi.” ");
INSERT INTO zajp_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Imitondo zua da ikadatu kukala na midumo na mimwemwe, wingu titu uchana ya idigongo, na dizwi kulu da mhalati. Wanhu wose wakalile haja hana ing'hambi wagudema. ");
INSERT INTO zajp_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Abaho Musa kawalava iwanhu kulawa mng'hambi giladi waiting'hane na Mulungu. Wema hasi ya idigongo. ");
INSERT INTO zajp_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Gongo da Sinai digubikwa na yosi, kwavija MNDEWA kahumuluka uchana ya idigongo kuno yali mgati ya umoto. Yosi dikwela uchana kulawa Mdigongo kamba yosi da tanuli, na gongo jose ditigisika ng'hani. ");
INSERT INTO zajp_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Dizwi da imhalati vudibanzile kongezeka ng'hani, Musa kalonga, na Mulungu kamwidika mkuduma. ");
INSERT INTO zajp_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","MNDEWA viyahumuluke uchana ya Idigongo da Sinai, kamkema Musa uchana ya dija idigongo, na Musa kakwela uchana ya idigongo. ");
INSERT INTO zajp_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Abaho MNDEWA kamulongela Musa, “Humuluka hasi ukawazume wanhu, sambiwaloke imbaka giladi weze kunyona nie. Kamba wahatenda avo, wanhu bwando wodanganhika. ");
INSERT INTO zajp_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hata wakulu wa nhambiko, awo wonikwenhukilaga, waibagule sama yangu nie, ama sio, nowabananga.” ");
INSERT INTO zajp_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa kamulongela MNDEWA, “Wanhu wano hawadaha kukwela na kwiza kuno uchana ya Idigongo da Sinai kwavija gweye mwenyego kutuzuma ulonga, ‘Ikeni mbaka kuzunguluka idigongo giladi mditende ding'ale.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","MNDEWA kamulongela, “Humuluka hasi ukamsole Haloni wize nayo. Ila wakulu wa nhambiko na wanhu wayagwe sambiuwaleke weze uchana kunili nie, ama sio, nowabananga.” ");
INSERT INTO zajp_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Avo Musa kahumuluka hasi hawakalile iwanhu na kawalongela gose gayalongeligwe na MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Mulungu kazipeta mbuli zino zose, kalonga, ");
INSERT INTO zajp_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Nie iyo MNDEWA Mulungu wako, nikulavile muisi ya Misili, ako kuukalile nyakadala. ");
INSERT INTO zajp_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Sambiuwe na miungu iyagwe ila nie. ");
INSERT INTO zajp_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Sambiuitendele wegu dilingile na kinhu chochose cha uchana kuulanga ama kili hasi muisi, ama kili mmazi hasi ya isi. ");
INSERT INTO zajp_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Sambiuvifugamile mavindi ama kuvitambikila, kwavija nie, MNDEWA Mulungu wako, nna wivu, nowatagusa wana sama ya vilozo va watata zao mbaka mulelo wa ikadatu na mulelo wa ikane wa awo wanihile nie. ");
INSERT INTO zajp_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ila nodilagusa noge jangu dilekile kuhuha ha maalufu ga milelo ya awo woninogela nie na kugagoga malagizo gangu. ");
INSERT INTO zajp_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Sambiudikeme twaga da MNDEWA Mulungu wako mmbuli zihile, kwavija MNDEWA haleka kumtagusa munhu yoyose yodikema twaga jake mmbuli zihile. ");
INSERT INTO zajp_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Dikumbukile Zua da Mhumulo na udibagule sama yangu nie. ");
INSERT INTO zajp_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Tenda sang'hano zako zose mmazua sita. ");
INSERT INTO zajp_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ila mdizua da saba sambiutende sang'hano yoyose kwavija dino dijo Zua da Mhumulo da nie, MNDEWA Mulungu wako. Mdizua dino munhu yoyose sambiyasang'hanike, gweye mwenyego, mwanago wa kimbigalo ama wa kitwanzi, nyakadala wako wa kimbigalo ama wa kitwanzi, wang'onyo zako, ama wahenza wali muisi yako. ");
INSERT INTO zajp_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kwavija mkipigiti cha mazua sita, nie nilumba isi, ulanga, bahali, na vinhu vose vikala himo, ila mdizua da saba nihumula. Avo nidimoteza Zua da Mhumulo na nidibagula sama yangu nie. ");
INSERT INTO zajp_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Wahishimile tataako na mamaako, giladi ukale kipigiti kitali muisi inikugwelela nie, MNDEWA, Mulungu wako. ");
INSERT INTO zajp_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Sambiukome. ");
INSERT INTO zajp_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Sambiutende ugoni. ");
INSERT INTO zajp_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Sambiwibe. ");
INSERT INTO zajp_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Sambiumulavile usindila wa uvwizi munhu yali behi nagwe. ");
INSERT INTO zajp_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Sambiusulukile ng'anda ya munhu yali behi nagwe, ama mtwanzi wake, ama nyakadala wake wa kitwanzi ama wa kimbigalo, ng'ombe wake ama mhunda wake, ama kinhu chochose kiyalinacho.” ");
INSERT INTO zajp_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Wanhu viwahulike mdumo na dizwi da imhalati na kuwona ulumwemwe na yosi dilawa mdigongo, wagudema na kona bwembwe, wema kutali. ");
INSERT INTO zajp_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Wamulongela Musa, “Longa na tweye gweye mwenyego, na tweye tokutegeleza. Ila Mulungu sambiyalonge na tweye, bule todanganhika.” ");
INSERT INTO zajp_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa kawalongela, “Sambimdumbe, kwavija Mulungu keza kuwageza mweye giladi mweye mumdumbe heyo na sambimtende vilozo.” ");
INSERT INTO zajp_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ila wanhu wagendelela kukala kutali kipigiti Musa viyakalile yodikwenhukila idiziza, kuja kuyakalile Mulungu. ");
INSERT INTO zajp_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","MNDEWA kamulongela Musa, “Walongele Waislaeli mbuli zino, ‘M'vona wenyego nie vinilongile na mweye kulawa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Sambimtende minyago ya madini ga feza ama zahabu na kuitambikila kamba vumunitambikila nie. ");
INSERT INTO zajp_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Munitendele kilingo cha kulavila nhosa, mkitende na ulongo. Munilavile ng'hondolo zenu na ng'ombe zenu na menhe zenu kamba nhosa za kulukuza na nhosa za tindiwalo. Zengeni kilingo changu cha kulavila nhosa hanhu hohose haniwasagulile mweye munitambikile nie, na nie nokwiza na kuwamoteza. ");
INSERT INTO zajp_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kamba muhanizengela kilingo cha kulavila nhosa cha mabwe, sambimzenge na mabwe gasongoligwe, kwavija vija ivinhu va kusongolela vokinyolodosa ikilingo cha kulavila nhosa. ");
INSERT INTO zajp_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Sambiwike ngwandala kipigiti uhazenga kilingo cha kunilavila nhosa, giladi mwazi wako sambiwoneke kipigiti vondaukikwenhukile ikilingo.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","MNDEWA kamulongela Musa, “Gano gago malagizo gondauwagwelele wanhu zangu. ");
INSERT INTO zajp_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Kamba uhamgula nyakadala mbigalo wa Kieblania, yakusang'hanikile mkipigiti cha milao sita. Ila mmulao wa saba yalekesigwe yachole, bila kuliha kinhu chochose. ");
INSERT INTO zajp_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kamba kakala yezile yeiyeka, kolondigwa yachole yeiyeka. Ila kamba kipigiti viyezile kakala na mtwanzi, kolondigwa yachole na mtwanzi wake. ");
INSERT INTO zajp_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Na kamba mndewa wake yahamsolela mtwanzi, na ija imtwanzi yahamulelela wana wa kitwanzi na wa kimbigalo, avo ija imtwanzi na waja iwana wowa wa ija imndewa, na ija inyakadala yachole yeiyeka. ");
INSERT INTO zajp_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ila kamba ija inyakadala yahalonga, ‘Nimnogela mndewa wangu, mtwanzi wangu, na wanangu, silonda kusegela na kuwa munhu yailegehe,’ ");
INSERT INTO zajp_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","avo mndewa wake yamsole yamgale haulongozi wa Mulungu. Abaho yamgale hana ulwivi ama hana umuhimili wa ulwivi, na mndewa wake yamtoge gwiti jake na shindano. Abaho komsang'hanikila mndewa wake mkipigiti chose cha ugima wake. ");
INSERT INTO zajp_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Munhu yahamguza mndele wake yawe nyakadala, heyo hasegela na kuwa munhu yailegehe kamba viili ha nyakadala wa kimbigalo. ");
INSERT INTO zajp_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kamba mndele ija hamnogela mndewa wake, ayo iyamsagule yawe mtwanzi wake wa kunze, kolondigwa yaguzigwe ha tata wa ija imndele. Ila mndewa wake kabule udaho wa kumguza ha munhu muhenza, kwavija mndewa iyo yamtendele uzenzeleganye. ");
INSERT INTO zajp_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ila kamba komsagula yawe mwehe wa mwanage, kolondigwa yamtende kamba mndele wake mwenyego. ");
INSERT INTO zajp_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Kamba munhu yamsolile nyakadala kuwa mtwanzi wake wa kunze, yahalonda kusola mtwanzi iyagwe, kolondigwa kugendelela kumgwelela ija imtwanzi wake wa kunze wa ichanduso ija inyakadala, kiasi kikija cha mandia, vivalo, na uwaso. ");
INSERT INTO zajp_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Na kamba hamtendela vinhu vino vidatu, ija imtwanzi kodaha kusegela bila maliho gogose.” ");
INSERT INTO zajp_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Mulungu kagendelela kulonga, “Munhu yoyose yondayamtoe na kumkoma miyage, na heyo yakomigwe. ");
INSERT INTO zajp_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ila kamba hatendile giladi, ila galawilila sama ya manogelwa ga Mulungu, kolondigwa yakimbilile hanhu hondanikulongele. ");
INSERT INTO zajp_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ila kamba munhu yoyose yahamkoma miyage giladi, hata kamba yahakimbilila hana ikilingo cha kulavila nhosa, yakwekwesigwe yalavigwe hana ikilingo cha kulavila nhosa abaho yakomigwe. ");
INSERT INTO zajp_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Munhu yoyose yondayamtoe tataake ama mamaake, yakomigwe. ");
INSERT INTO zajp_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Munhu yoyose yondayam'vamhile miyage, na kumgala hanhu bila kulonda, ihawa kamguza ama kang'hali mmakono gake, kolondigwa yakomigwe. ");
INSERT INTO zajp_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Munhu yoyose yondayamdukumize tataake ama mamaake, kolondigwa yakomigwe. ");
INSERT INTO zajp_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Wanhu wabili wahagomba na imwe yahamtoa miyage na dibwe ama ng'honde na hadanganhike, ila kamtenda ija yatoigwe yalumwe na kuwasa mulusazi, ");
INSERT INTO zajp_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","na abaho kona vinogile na kulawa hanze kabili kuno yotembelela fimbo, ija yamtoile hatagusigwa ila kolondigwa yamulihe ija yalumile sama ya kipigiti kija kipotele kipigiti viyakalile mulusazi, na yamuguze mbaka vondayahone. ");
INSERT INTO zajp_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Kamba munhu yahamtoa na lubiki nyakadala wake wakitwanzi ama wakimbigalo, na ija inyakadala bahaja kadanganhika, ija imunhu kolondigwa yatagusigwe. ");
INSERT INTO zajp_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ila kamba ija inyakadala hadanganhike mdizua dimwe ama mabili, ija mwene inyakadala hatagusigwa, kwavija kamtoa nyakadala wake mwenyego. ");
INSERT INTO zajp_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Kamba wambigalo wabili wogomba na kumkunhiza mtwanzi yali na inda na kutenda inda yake ilawe bila kumulumiza, ija yamkunhize kolondigwa yatozigwe kiasi chochose choyolonda mbigalo wa ija imtwanzi, sambiibanze vija mulamula vondayalonge. ");
INSERT INTO zajp_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ila kamba ihalawilila ija imtwanzi kalumizwa na mkunhizo uja, avo ija yamulumize kolondigwa yamulihe ija imtwanzi ugima kwa ugima, ");
INSERT INTO zajp_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","siso kwa siso, zino kwa zino, mgulu kwa mgulu, mkono kwa mkono, ");
INSERT INTO zajp_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","kulukuza kwa kulukuza, kilonda kwa kilonda, na mkubulo kwa mkubulo. ");
INSERT INTO zajp_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Kamba munhu yahamtoa msiso nyakadala wake wa kitwanzi ama wa kimbigalo na kuditula, avo ija imunhu kolondigwa yamuleke ija inyakadala yachole, na kuwa munhu yailegehe, kudilihila siso jake. ");
INSERT INTO zajp_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Na kamba munhu yahamtoa na kuding'ola zino da nyakadala wake wakitwanzi ama wakimbigalo, avo ija imunhu kolondigwa yamuleke ija inyakadala yachole na kuwa munhu yailegehe kudilihila zino jake. ");
INSERT INTO zajp_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Kamba ng'ombe yahamuhoma munhu mbigalo ama mtwanzi na mhembe zake na kumkoma, ija ing'ombe kolondigwa yatoigwe na mibwe mbaka yadanganhike, na nyama yake sambiidigwe, ila ija imwene ng'ombe sambiyatagusigwe. ");
INSERT INTO zajp_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ila kamba ng'ombe ija kakala na nzoela ya kuwahoma wanhu na mhembe zake, na mwene ng'ombe kakala yalongeligwe ila hamfungile ng'ombe wake, abaho ija ing'ombe kamkoma munhu mtwanzi ama mbigalo, ija ing'ombe kolondigwa yatoigwe na mibwe mbaka yadanganhike. Na ija mwene ng'ombe vivija yakomigwe. ");
INSERT INTO zajp_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ila mwene ng'ombe yahalondigwa kuliha hela giladi yaukombole ugima wake, kolondigwa yalihe kiasi chochose kilondigwa. ");
INSERT INTO zajp_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","“Ndagizi ino vivija yosang'hanika ihawa ng'ombe yahamkoma mmhale ama mndele. ");
INSERT INTO zajp_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kamba ng'ombe yahamuhoma na mhembe nyakadala wakimbigalo ama wakitwanzi, ija mwene ng'ombe kolondigwa yamulihe mwene nyakadala vidanga malongo madatu va madini ga feza, na ija ing'ombe yatoigwe na mabwe mbaka yadanganhike. ");
INSERT INTO zajp_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Kamba munhu yahaleka kudigubika kolongo, ama yahahimba kolongo na kuleka kudigubika, na ng'ombe ama mhunda yahalagalila mgati yake, ");
INSERT INTO zajp_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ija mwene idikolongo kolondigwa yamulihe mwene imhunda ama mwene ing'ombe, na ija imng'onyo yadanganhike kowa wa munhu ija mwene idikolongo. ");
INSERT INTO zajp_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Kamba ng'ombe wa munhu imwe yahamulumiza ng'ombe wa munhu iyagwe na kudanganhika, wanhu wano wabili wolondigwa kumguza ing'ombe yali mgima na kuigolela zihela, na vivija ija ing'ombe yadanganhike waigolele nyama yake. ");
INSERT INTO zajp_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ila kamba ija ing'ombe kakala na nzoela ya kuwahoma wayage na mhembe, ila ija mwene ng'ombe hamfungile, basi ija mwene ng'ombe yamkomile miyage kolondigwa yalihe ng'ombe mgima sama ya ng'ombe ija yadanganhike, na ija ing'ombe yadanganhike kowa wake heyo.” ");
INSERT INTO zajp_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Kamba munhu yeheba ng'ombe ama ng'hondolo na kumchinja ama kumguza, ija im'bavi kolondigwa yalihe ng'ombe watano sama ya ng'ombe imwe, na ng'hondolo wane sama ya ng'hondolo imwe. ");
INSERT INTO zajp_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Kamba m'bavi yahagogigwa ikilo yobomola giladi yengile mng'anda, abaho katoigwa na kudanganhika, ija yamtoile hatendile kilozo cha kukoma. ");
INSERT INTO zajp_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ila yahakala mbaka zua disonga kulawa kileka yamkome, munhu hiyo kana kilozo cha kukoma. “M'bavi yagogigwe kolondigwa yalihe vinhu vose viyebile. Kamba hadahile kuliha, kolondigwa yaguzwe kamba nyakadala kulihila ubavi wake. ");
INSERT INTO zajp_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ila ija imng'onyo ihawa ng'ombe ama mhunda ama ng'hondolo yahavikigwa yali mgima mdidale da ija im'bavi, kolondigwa yalihe wang'onyo wabili sama ya mng'onyo imwe iyebile. ");
INSERT INTO zajp_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Kamba munhu yahawachunga wang'onyo zake mumgunda ama mumgunda wake wa zabibu, abaho ija imunhu kawaleka wakaje vakuja mumgunda wa munhu iyagwe, avo ija mwene wang'onyo kolondigwa yalihe vakuja vinogile kulawa mumgunda wake ama kulawa mumgunda wake wa mizabibu. ");
INSERT INTO zajp_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Kamba munhu yahasoma moto mumgunda wake na uja umoto ulokela mmijani na kwingila mumgunda wa munhu iyagwe na kulukuza vakuja havinasengigwa ama visengigwe, ama mgunda wose, ija yasomile umoto kolondigwa yalihe vinhu vose vilukule. ");
INSERT INTO zajp_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Kamba munhu yahamgwelela miyage hela ama vinhu giladi yamwikile, abaho vibigwa kulawa muing'anda ya ija yekile, kamba ija im'bavi yahagogigwa, kolondigwa yalihe mianza mibili. ");
INSERT INTO zajp_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ila kamba ija im'bavi hagogigwe, avo mwene ng'anda kolondigwa yagaligwe haulongozi wa Mulungu yakaloleswe kamba heyo iyo yasolile vinhu va miyage ama sio. ");
INSERT INTO zajp_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Mbuli yoyose ya mbamila ihalawilila hagatigati ya wanhu wabili wogombela ng'ombe, mhunda, ng'hondolo, vivalo, ama vinhu vovose viyagwe vipotele, kila munhu yahalonga, ‘Kinhu kino changu nie.’ Mbuli ya wabili wano yogaligwa haulongozi wa Mulungu. Munhu yondayoneke na Mulungu kamba kahonyela komuliha miyage mianza mibili. ");
INSERT INTO zajp_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Kamba munhu imwe yahamgwelela miyage mhunda, ng'ombe, ng'hondolo, ama mng'onyo yoyose iyagwe yamfugile, na ija imng'onyo yahadanganhika, kalumila, ama kebigwa, bila koneka na munhu, ");
INSERT INTO zajp_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","wanhu wano wabili wokiiduila haulongozi wa MNDEWA, giladi yoneke kamba ija imunhu yagweleligwe imng'onyo hasolile mng'onyo wa miyage. Ija mwene imng'onyo kolondigwa yatogole ulamuzi uno, na haduhu maliho golondigwa galihigwe. ");
INSERT INTO zajp_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ila kamba ija imng'onyo kebigwa kulawa mmakono ga ija imunhu yagweleligwe imng'onyo, avo ija yagweleligwe imng'onyo kolondigwa yamulihe ija mwene imng'onyo. ");
INSERT INTO zajp_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kamba ija imng'onyo kagogigwa na mng'onyo wa kumuhulo, avo vija visigale kulawa ha ija imng'onyo yagogigwe, vigaligwe viwe kamba usindila. Na haduhu maliho gondagatendeke sama ya mng'onyo yagogigwe na mng'onyo wa kumuhulo. ");
INSERT INTO zajp_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Kamba munhu yahapula mng'onyo kulawa ha miyage abaho ija imng'onyo kalumila ama kadanganhika kipigiti mwene mng'onyo yali haduhu, ija imunhu yampulile kolondigwa yalihe. ");
INSERT INTO zajp_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ila kamba mwene mng'onyo kakala baho kipigiti gano vugalawilile, haduhu maliho gondagatendeke. Kamba ija imng'onyo kakodigwa, basi ija ihela yaakodiligwe yolihila ija imng'onyo yalumile ama yadanganhike. ");
INSERT INTO zajp_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Kamba munhu yahamulonda mhambe yalibule mkasano na kuwasa nayo, kolondigwa yalave hela, yafunge pamvu giladi yawe mwehe wake. ");
INSERT INTO zajp_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ila kamba tata wa ija imhambe yahalema mwanage sambiyasoligwe na heyo, avo ija imunhu kolondigwa yalihe kiasi kikija cha hela za kufunga pamvu. ");
INSERT INTO zajp_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Sambiumuleke mtwanzi muhawi yawe mgima. ");
INSERT INTO zajp_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Munhu yoyose yondayamuwase mng'onyo, yakomigwe. ");
INSERT INTO zajp_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Munhu yoyose yolava nhosa ha miungu yoyose iyagwe na si ha MNDEWA yadanganhike. ");
INSERT INTO zajp_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Sambiumtendele gehile ama kumonela muhenza, kwavija gweye vivija kukala muhenza muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Sambiumtendele gehile kizuka yoyose ama mkiwa. ");
INSERT INTO zajp_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kamba uhawatendela gehile, wahanililila nie, nokitegeleza kililo chao. ");
INSERT INTO zajp_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Lusango lwangu lokwinuka, na nie nowakoma mweye na zele, na watwanzi zenu wowa vizuka na wana zenu wowa wakiwa. ");
INSERT INTO zajp_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Kamba uhamkalizi hela imwe wa wanhu zangu ayo yali mkumbulu, sambiutende kamba vowotendaga wakalizi hela, sambiulonde hela ibanzile kumwake. ");
INSERT INTO zajp_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kamba uhasola kivalo cha munhu wako wa habehi kiwe kamba zamana, kolondigwa um'bwezele kipigiti zua hadinakuswa, ");
INSERT INTO zajp_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","kwavija siku miyago kicho kivalo chake choyotamanila kuigubika ikilo. Kamba humbwezele, miyago koigubika choni? Kamba humbwezele na heyo yahanililila nie, nokitegeleza kililo chake kwavija nie nna bazi. ");
INSERT INTO zajp_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Sambiumulonge vihile Mulungu, ama kumdukumiza mkulu wa wanhu zako. ");
INSERT INTO zajp_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Sambiukawe kulava malimbuko kulawa mdivai, mavuta, na vinhu vako vose vuuhunile. “Wana zenu wa kimbigalo wa udele, ungwelele nie. ");
INSERT INTO zajp_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Vivija ungwelele nie wana mbigalo wa udele wa ng'ombe zako, ng'hondolo zako, na menhe zako. Uwaleke wakale na wamama zao mmazua saba, abaho ungwelele nie mdizua da nane. ");
INSERT INTO zajp_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Mweye mowa wanhu zangu mng'alile, avo sambimje nyama ya mng'onyo yakomigwe na mng'onyo wa kumuhulo. Wasileni umbwa. ");
INSERT INTO zajp_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Sambiubwililise mbuli za uvwizi. Sambiuilumbe na munhu mwene vilozo kulava usindila wa uvwizi. ");
INSERT INTO zajp_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Sambiuilumbe na dale da wanhu mkutenda gehile. Uhalava usindila hana ibalaza, sambiugolowanye na kuilumba na dale da wanhu bwando giladi kuigubikiza ikweli. ");
INSERT INTO zajp_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Sambiulaguse bazi ha munhu sama ya ukumbulu wake kipigiti yahagaligwa muibalaza. ");
INSERT INTO zajp_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Kamba uhamona ng'ombe ama mhunda wa mdumuka wako kaga, m'bweze ha mwenyego. ");
INSERT INTO zajp_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Kamba uhamona mhunda wa munhu yokwihila gweye kagwa hasi na bahasha jake kumgongo, sambium'bite, ila wime umtaze kumwinula mhunda wake. ");
INSERT INTO zajp_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Sambiuigolowanye ikweli ihawa mkumbulu yali mmwanza wa wanhu zako yahagaligwa kuna ibalaza. ");
INSERT INTO zajp_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Sambiuwagale wanhu kukitala mmbuli za uvwizi, na sambiuwakome wanhu walibule vilozo na walibule uzenzeleganye, kwavija nie simgela kumgongo munhu yoyose yotenda mbuli zihile. ");
INSERT INTO zajp_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Sambiubokele hongo, kwavija hongo dowagela umbugumbugu awo wolola na kuzigolowanya mbuli za wanhu walibule uzenzeleganye. ");
INSERT INTO zajp_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Sambiumgaze muhenza, kwavija mweye wenyego movitanga vija voyogelegeza muhenza, kwavija na mweye mkala wahenza muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Mkipigiti cha milao sita kohanda mgunda wako na kohuna vakuja vako. ");
INSERT INTO zajp_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ila mmulao wa saba uuleke umgunda uhumule sambiuulime. Avo wakumbulu kulawa mmwanza wa wanhu zako wapate vakuja kulawa himo, na vija visigale wang'onyo wa kumuhulo waje. Utende vivo mumgunda wako wa mizabibu na mumgunda wako wa mizaituni. ");
INSERT INTO zajp_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Mazua sita, sang'hana sang'hano zako, ila mdizua da saba sambiusang'hanike, giladi ng'ombe wako na mhunda wako wahumule, na nyakadala wavumbuke mng'anda yako hamoja na wahenza wahumule. ");
INSERT INTO zajp_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Gategeleze goya gano gose ganikulongele, sambiuitambikile miungu iyagwe, hata matwaga gao sambiugatambule. ");
INSERT INTO zajp_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Mianza midatu mkila mulao konitendela lusona. ");
INSERT INTO zajp_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Utende Lusona lwa Mikate Ilibule Mela, mmazua saba uje mikate ilibule mela kamba vunikulagize. Zitende mbuli zino mkipigiti kikigwe, muna umulenge wa Abibu, kwavija uno uwo umulenge umulawile muisi ya Misili. Munhu sambiyeze haulongozi wangu bila kinhu. ");
INSERT INTO zajp_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Tenda lusona lwa kuhuna malimbuko ga vakuja vuuhandile mumgunda wako. “Abaho tenda lusona lwa vizewe kipigiti uhagela kukano vakuja vako kulawa mumgunda wako kipigiti cha msimu wa kumambukiza kuhuna vakuja venu. ");
INSERT INTO zajp_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Wambigalo wose weze haulongozi wa MNDEWA Mulungu mianza midatu mkila mulao kutambika. ");
INSERT INTO zajp_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Sambimunilavile nhosa ya mulopa wa wang'onyo wachinjigwe hamoja na mikate igeligwe mela. Mavuta ga wang'onyo galavigwe nhosa kipigiti cha lusona lwangu sambigasigale mbaka imitondo iyagwe. ");
INSERT INTO zajp_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Vakuja vinogile ng'hani va malimbuko va mgunda wako uvigale kung'anda yangu nie, MNDEWA Mulungu wako. “Sambiumtogose mwanamenhe mmatombo ga mamaake. ");
INSERT INTO zajp_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Nomtuma msenga wangu wa kuulanga yakulongole, giladi yakwimilize mnzila na yawagale hanhu hanisasale. ");
INSERT INTO zajp_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Mtegelezeni na mgagoge gaja goyowalongela. Sambimumdulukile, heyo haugela kumgongo udulu wenu kwavija nie iyo nimtumile heyo. ");
INSERT INTO zajp_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ila kamba muhamtegeleza goya na kugatenda gose gonilonga, nie nowa mdumuka ha wadumuka zenu, na nowabamilila awo wokubamilila gweye. ");
INSERT INTO zajp_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Msenga wangu wa kuulanga kowalongola na kuwagala muisi ya Waamoli, Wahiti, Wapelizi, Wakanaani, Wahivi, na Wayebusi, na nie nowabananga. ");
INSERT INTO zajp_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Sambiufugame mavindi na kuinamila mbaka hasi haulongozi wa miungu yao ama kuitambikila ama kutenda viilonda miungu yao, ila uibanange na kuitula vidangavidanga miguzo yao ya mibwe yowoitambikila. ");
INSERT INTO zajp_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Nitambikileni nie, MNDEWA Mulungu wenu, na motelo zangu zowa mmandia genu na mmazi. Nowasegezela vitamu kulawa kumwenu, ");
INSERT INTO zajp_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","na haduhu hata mtwanzi imwe inda yake yondailawe ama yondayawe mgumba. Nokutenda ukale milao bwando. ");
INSERT INTO zajp_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Nogala bwembwe haulongozi wenu, na kuwatenda wadumuka zenu wondawawezile wazanywe ng'hani. Abaho nowatenda hewo wahinduke kuchugu na kuwakimbila mweye. ");
INSERT INTO zajp_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nogala midondola haulongozi wenu yondaiwawinge Wahivi, Wakanaani, na Wahiti wasegele mnzila yako. ");
INSERT INTO zajp_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Siwawinga mkipigiti cha mulao umwe kwavija kamba nihatenda avo, isi yowa bule munhu na wang'onyo wa kumuhulo wokongezeka ng'hani na kuwavamhila. ");
INSERT INTO zajp_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nowawinga kidogokidogo, mbaka mweye vondamongezeke abaho nowagwelela isi yenu. ");
INSERT INTO zajp_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Nokwikila mbaka zako kulawa Kuibahali Ndung'hu mbaka kuibahali ya Wafilisti na kulawa muluwala mbaka Kulwanda lwa Yuflati. Kwavija nokugwelela mhiko za kuwahuma wenekae wa isi ino na kuwawinga. ");
INSERT INTO zajp_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Sambimtende lagano na hewo ama na miungu yao. ");
INSERT INTO zajp_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Sambimuwaleke wakale muisi yenu bule wowatenda mweye munitendele nie vilozo, kwavija nhambiko ya miungu yao yowa mtego kumwenu mweye.” ");
INSERT INTO zajp_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","MNDEWA kamulongela Musa, “Izo hano uchana kumwangu. Wize na Haloni, hamoja na wanage wabili Nadabu na Abihu, na wavyele malongo saba wa Islaeli. Munitambikile nie kipigiti muli kutali. ");
INSERT INTO zajp_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ila gweye, Musa, wiyeka iyo wondaunikwenhukile. Wasigale sambiwanikwenhukile. Na mmwanza wa wanhu wasigale, haduhu hata munhu imwe yatogozigwe kukwela uchana hamoja na gweye.” ");
INSERT INTO zajp_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa viyacholile kuwalongela wanhu malagizo gose na ndagizi zose ziyagweleligwe na MNDEWA, wanhu wose wedika na dizwi dimwe, wolonga, “Kila kinhu kiyalongile MNDEWA tokitenda.” ");
INSERT INTO zajp_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Avo Musa kazandika mbuli zose zayalongile MNDEWA. Imitondo ng'hani zua da ikabili kalamuka na kuzenga kilingo cha kulavila nhosa hasi ya idigongo na kusimika nguzo za mibwe longo dimwe na mbili zilingile na mheta ya mitala longo dimwe na mibili ya Islaeli. ");
INSERT INTO zajp_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Abaho kawatuma wamhale kulawa mmwanza wa wanhu wa Islaeli, walave nhosa za kulukuza na nhosa za kuchinja ndama za ng'ombe ziwe nhosa za tindiwalo ha MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa kadeha hindi da mulopa wa wang'onyo na kuwika mmikungu, na hindi da mulopa usigale kaumizila mkilingo cha kulavila nhosa. ");
INSERT INTO zajp_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Abaho kasola kitabu cha lagano, na kuwasomela wanhu. Na hewo watogola, walonga, “Gose gayalongile MNDEWA togatenda, na kugagoga.” ");
INSERT INTO zajp_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Avo Musa kasola mulopa kawamizila wanhu na kulonga, “Uno uwo mulopa wa lagano dija MNDEWA diyatendile na mweye kipigiti viyawagwelele Malagizo gano.” ");
INSERT INTO zajp_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Abaho Musa, Haloni, Nadabu na Abihu, na waja iwavyele malongo saba wa Islaeli wakwela uchana kukigongo, ");
INSERT INTO zajp_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","na wamona Mulungu wa Islaeli. Hasi ya magulu gake kukala na kinhu kilingile kamba sakafu ya mabwe itendigwe na yakuti samawi, ikala buluu inang'hazika kamba ulanga. ");
INSERT INTO zajp_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Mulungu hawatoile wano iwavyele wa wanhu wa Islaeli. Wamona Mulungu, na waja na kung'wa haulongozi wake. ");
INSERT INTO zajp_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","MNDEWA kamulongela Musa, “Kwela uchana hakigongo kunili nie, unibete, na nie nokugwelela mbamha mbili za mabwe zili na malagizo na ndagizi zinyandike sama ya kuwafundiza wanhu.” ");
INSERT INTO zajp_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Avo Musa kachola hamoja na mwandakana wake Yoshua, abaho kakwela uchana hakigongo cha Mulungu. ");
INSERT INTO zajp_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Musa kakala yawalongele waja iwavyele, “Tubeteni hano mbaka vondatuwabwelele, Haloni na Huli wa hano hamoja na mweye, na munhu yoyose yali na mbuli yachole kumwao hewo.” ");
INSERT INTO zajp_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Musa viyakwelile uchana kudigongo, wingu didigubikiza idigongo. ");
INSERT INTO zajp_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Yenzi ya MNDEWA ikala uchana ya Idigongo da Sinai. Wingu digubikiza idigongo mkipigiti cha mazua sita, na mdizua da saba MNDEWA kamkema Musa kulawa muja mdiwingu. ");
INSERT INTO zajp_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Yenzi ya MNDEWA yoneka ha Waislaeli kamba moto usakaza uchana ya idigongo. ");
INSERT INTO zajp_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa viyakalile yokwela uchana ya idigongo, kengila mdiwingu, na kakala kuja uchana hakigongo mazua malongo mane imisi na ikilo. ");
INSERT INTO zajp_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Musa viyakalile uchana kudigongo da Sinai, MNDEWA kamulongela, ");
INSERT INTO zajp_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Walongele Waislaeli wanilavile nhosa. Unibokelele nhosa kulawa ha munhu yoyose yali na moyo wa kulava. ");
INSERT INTO zajp_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Zino zizo nhosa zondaubokele kulawa kumwao, zahabu, madini ga feza, na shaba, ");
INSERT INTO zajp_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","nyuzi za buluu, zambalau, na ndung'hu, kitani inogile, na mijusu ya menhe. ");
INSERT INTO zajp_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Ng'hwembe za songolomi wa ng'hondolo zisindikigwe na langi ndung'hu, ng'hwembe zinogile, mbamha za m'biki wa mjoholo, ");
INSERT INTO zajp_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mavuta ga mzaituni ga kwika m'viwenge, vilungilo sama ya kulungila mavuta ga mzaituni ga kubakala na sama ya ubane unung'hila goya, ");
INSERT INTO zajp_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","mabwe gakemigwe shohamu, na mabwe gayagwe ga hela bwando ga kuhambila mkizibao cha Mkulu wa Wakulu wose wa Nhambiko na mkifuko cha mmhambaga. ");
INSERT INTO zajp_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Abaho wanitendele hema da kuiting'hanila, giladi nipate kukala hamoja na mweye. ");
INSERT INTO zajp_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ditende hema dino na vinhu vake vose kamba vondanikulagusile. ");
INSERT INTO zajp_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Walongele wanhu watende Sanduku da Lagano na mbamha za mjoholo, diwe na utali wa sentimeta 110, ugazi wa sentimeta 66, na wimo wa sentimeta 66. ");
INSERT INTO zajp_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Digubikize na zahabu ing'alile mgati na kunze, na uditendele lugigo lwa zahabu uchana kuzunguluka idisanduku. ");
INSERT INTO zajp_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ditendele vitindi vine va zahabu, na uvigwasike muna imigulu yake mine, vitindi vibili ng'ambu imwe na vitindi vibili ng'ambu iyagwe. ");
INSERT INTO zajp_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Abaho utende fimbo za m'biki wa mjoholo, uzigubikize na zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Zigele izifimbo m'vitindi vili mzimbavu za idisanduku, sama ya kudipapila idisanduku. ");
INSERT INTO zajp_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Izifimbo zikale m'vitindi va idisanduku, sambizisegezigwe. ");
INSERT INTO zajp_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Abaho uzingize Mdisanduku da Lagano zimbamha mbili za mabwe zondanikugwelele, mbamha zandikigwe ndagizi za Mulungu. ");
INSERT INTO zajp_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Abaho utende ngubiko ya idisanduku na zahabu ing'alile. Iwe na utali wa sentimeta 110 na ugazi wa sentimeta 66. ");
INSERT INTO zajp_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Abaho watende vinyago vilingile na Makelubi wabili wa zahabu mkuwasana na nyundo, uweke kuzingwazo mbili za ingubiko ya idisanduku. ");
INSERT INTO zajp_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Mtende Kelubi imwe kuingwazo imwe na Kelubi iyagwe kuingwazo iyagwe, wawe mkidanga kimwe na ingubiko ya idisanduku, watende iwamakelubi muna izingwazo zake mbili. ");
INSERT INTO zajp_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Makelubi wogolosa mbawa zao uchana, na kuikikiwiza ingubiko ya idisanduku na izimbawa zao. Makelubi woilola, na vihanga vao voinamilila ingubiko ya idisanduku. ");
INSERT INTO zajp_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Uzike mgati ya idisanduku zimbamha mbili za mabwe, zondanikugwelele. Abaho wike ingubiko uchana ya idisanduku. ");
INSERT INTO zajp_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Haja hachana ya ingubiko hagatigati ya Makelubi wabili wali uchana ya Idisanduku da Lagano, noiting'hana na gweye na kukugwelela ndagizi zangu zose sama ya Waislaeli.” ");
INSERT INTO zajp_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Abaho kamulongela, “Tenda meza ya mbamha za mjoholo. Iwe na utali wa sentimeta 88, ugazi wa sentimeta 44, na wimo wa sentimeta 66. ");
INSERT INTO zajp_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Igubikize na zahabu ing'alile na uitendele lugigo lwa zahabu ing'alile uchana kuizunguluka imeza. ");
INSERT INTO zajp_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Uizungulusile mkungo uli na ugazi wa milimeta 75, abaho wike lugigo lwa zahabu kuzunguluka umkungo. ");
INSERT INTO zajp_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Tenda vitindi vine va zahabu, uvigwasike muna zimhembe nne za imeza, mmigulu yake mine. ");
INSERT INTO zajp_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Vija ivitindi vondavigoge zifimbo za kupapila imeza volondigwa viwe behi na umkungo. ");
INSERT INTO zajp_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Utende fimbo za m'biki wa mjoholo za kupapila imeza, na uzigubikize na zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Utende vyano na vikasi sama ya kufushila ubane, na utende majagi na mikungu sama ya nhosa ya divai. Via vino vose vitendigwe na zahabu ing'alile. ");
INSERT INTO zajp_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Wike mikate ilavigwe nhosa kumwangu uchana ya meza ino ili haulongozi wangu mazua gose. ");
INSERT INTO zajp_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Tenda kiguzo cha kwikila viwenge cha zahabu ing'alile. Kikalilo chake na kiguzo chake uvitende na zahabu isanigwe na nyundo. Vikasi vake, vifundo vake, na malua gake viwe kinhu kimwe na ikiguzo. ");
INSERT INTO zajp_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Matambi sita gowa kuzing'ambu mbili za ikiguzo, matambi madatu ng'ambu imwe na matambi madatu ng'ambu iyagwe. ");
INSERT INTO zajp_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Vikasi vilingile kamba malua ga mulozi, kila kikasi kimwe na kifundo chake na malua gake, vidatu vikale mditambi dimwe na vidatu vikale mditambi diyagwe. Na matambi gose sita gowa mkiguzo cha kwikila viwenge. ");
INSERT INTO zajp_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Na uchana ya ikiguzo cha kwikila viwenge kuwe na vikasi vine vilingile kamba malua ga mulozi, kila kikasi na vifundo vake na malua gake. ");
INSERT INTO zajp_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Kifundo cha ichanduso kiwe hasi ya igamatambi mabili ga ichanduso gali mkiguzo cha kwikila viwenge, kifundo cha ikabili kiwe hasi ya igamatambi mabili ga ikabili, na kifundo cha ikadatu kiwe hasi ya igamatambi mabili ga ikadatu. Mheta ya matambi gose gawe sita. ");
INSERT INTO zajp_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ivifundo, igamatambi, na ikiguzo cha kwikila viwenge visanigwe kulawa mkidanga kimwe cha zahabu ing'alile. ");
INSERT INTO zajp_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Abaho uvitende viwenge vake saba, viwenge sita uvike uchana ya igamatambi sita na kiwenge kimwe ukike uchana ya ikiguzo, giladi vimwemwese haulongozi wake. ");
INSERT INTO zajp_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Utende visahani vake na mibato yake sama ya kusegezela utambi ulukule. Na vinhu vino vose viwe va zahabu ing'alile. ");
INSERT INTO zajp_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ikiguzo cha kwikila iviwenge na via vandakane navo volondigwa vitendigwe na zahabu ing'alile ili na kilo 35. ");
INSERT INTO zajp_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Tenda kila kinhu kamba vija vinikulagusile kukigongo kino. ");
INSERT INTO zajp_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Ditende hema da kuiting'hanila na miguo longo dimwe ya kitani inogile isokotigwe na nyuzi za buluu, zambalau, na ndung'hu, dihambigwe na muhambaji na ulembo wa vinhu vilingile na Makelubi. ");
INSERT INTO zajp_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Utali wa kila guo uwe meta 12, na ugazi wa kila guo uwe meta 2. Miguo yose iwe na utali umwe na ugazi umwe. ");
INSERT INTO zajp_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Miguo mitano uilumbe hamoja, na miguo mitano iyagwe uilumbe hamoja. ");
INSERT INTO zajp_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Utende matanzi ga buluu mulugigo lwa guo da kunze mmwanza wa ija imiguo ya ichanduso yuuilumbile hamoja, na vivija utende matanzi mulugigo lwa guo da kunze mmwanza wa ija imiguo iyagwe yuuilumbile hamoja. ");
INSERT INTO zajp_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Utende matanzi malongo matano mulugigo lwa idiguo da ichanduso dili mmiguo mitano ya ichanduso, na utende matanzi malongo matano mulugigo lwa idiguo dili mmiguo mitano iyagwe. Gamatanzi gakihindukile kila tanzi dimwe na miage. ");
INSERT INTO zajp_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Utende ving'hwangwazi malongo matano va zahabu, na uilumbe hamoja imiguo na iving'hwangwazi, giladi idihema da kuiting'hanila diwe kinhu kimwe. ");
INSERT INTO zajp_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Vivija utende miguo longo dimwe na imwe itendigwe na mijusu ya menhe sama ya kugubikila idihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Utali wa kila guo dimwe uwe meta 13, na ugazi wa kila guo uwe meta 2. Miguo yose longo dimwe na imwe iwe na utali umwe na ugazi umwe. ");
INSERT INTO zajp_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Uilumbe miguo mitano hamoja, na uilumbe miguo sita iyagwe hamoja. Dija idiguo da sita dikunze hagatigati mwanza umwe haulongozi wa idihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Utende matanzi malongo matano mulugigo lwa idiguo da ikimambukizo da imiguo mitano ya ichanduso na matanzi malongo matano mulugigo lwa idiguo da ichanduso da imiguo sita iyagwe. ");
INSERT INTO zajp_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Utende ving'hwangwazi malongo matano va shaba abaho uvigele muna gamatanzi na uilumbe hamoja imiguo ya idihema da kuiting'hanila giladi iwe ngubiko imwe. ");
INSERT INTO zajp_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Lwenza lwa ikidanga kisigale kitungike kuchugu cha idihema da kuiting'hanila mbaka kibululuke hasi sentimeta 50. ");
INSERT INTO zajp_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Utali wa sentimeta 50 usigale wa imiguo uitungike ng'ambu mbili za mzimbavu za idihema da kuiting'hanila mbaka ibululuke hasi, giladi udikikiwize idihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Utende ngubiko sama ya kugubikila idihema da kuiting'hanila, ngubiko ya ng'hwembe za songolomi wa ng'hondolo isindikigwe na langi ndung'hu, na ngubiko ya kunze ya ng'hwembe zinogile. ");
INSERT INTO zajp_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Utende felemu za wima za m'biki wa mjoholo sama ya idihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kila felemu iwe na wimo wa meta 4 na ugazi wa sentimeta 66. ");
INSERT INTO zajp_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Kila felemu iwe na vizingiti uchana na hasi giladi viitende imihimili mibili iwe kinhu kimwe, hamoja na migulu mibili yondaingizigwe mvikalilo vondaviwe hasi ya izifelemu, na utende vino mzifelemu zose za idihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Utende felemu za idihema da kuiting'hanila, felemu malongo mabili ng'ambu ya kusi ya idihema da kuiting'hanila, ");
INSERT INTO zajp_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","na utende vikalilo malongo mane va madini ga feza hasi ya izifelemu malongo mabili, vikalilo vibili hasi ya ifelemu ya ichanduso mmigulu yake mibili, na vikalilo vibili hasi ya felemu iyagwe mmigulu yake mibili. ");
INSERT INTO zajp_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ng'ambu ya kaskazi ya idihema da kuiting'hanila, tenda felemu malongo mabili ");
INSERT INTO zajp_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","na vikalilo malongo mane va madini ga feza, vikalilo vibili hasi ya kila felemu. ");
INSERT INTO zajp_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Kuchugu cha idihema da kuiting'hanila, ng'ambu ya uswelo wa zua, tenda felemu sita. ");
INSERT INTO zajp_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Utende felemu mbili ziyagwe mzimhembe za idihema da kuiting'hanila zili ng'ambu ya kuchugu. ");
INSERT INTO zajp_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Felemu zino za mzimhembe zolondigwa ziibande songela hasi mbaka uchana, na uchana zifungigwe na kitindi kimwe, zose mbili zolondigwa ziilinge. ");
INSERT INTO zajp_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Avo kiwambaza kino cha kuchugu chowa na felemu nane hamoja na vikalilo va madini ga feza, vikalilo longo dimwe na sita, vikalilo vibili hasi ya kila felemu. ");
INSERT INTO zajp_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Utende boliti za m'biki wa mjoholo, boliti tano sama ya izifelemu za ng'ambu imwe ya idihema da kuiting'hanila, ");
INSERT INTO zajp_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","na boliti tano sama ya izifelemu za ng'ambu iyagwe ya idihema da kuiting'hanila, na boliti tano sama ya izifelemu za ng'ambu ya kuchugu ya idihema da kuiting'hanila, ng'ambu ya uswelo wa zua. ");
INSERT INTO zajp_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Boliti ya hagatigati, yobita hagatigati ya izifelemu kulawa ng'ambu imwe mbaka ng'ambu iyagwe. ");
INSERT INTO zajp_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Uzigubikize zifelemu na zahabu, na uzitendele vitindi va zahabu vigoge iziboliti. Na uzigubikize iziboliti na zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Udisimike idihema da kuiting'hanila kamba vija vinikulagusile kukigongo kino. ");
INSERT INTO zajp_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Utende guo na nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe, dihambigwe na ulembo wa vinhu vilingile na Makelubi. ");
INSERT INTO zajp_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ditungike uchana mzinguzo nne za m'biki wa mjoholo zigubikizwe na zahabu zili na ving'hwangwalingo va zahabu, na uzisimike zinguzo uchana ya vikalilo vine va madini ga feza. ");
INSERT INTO zajp_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ng'ambu ya uchana ya idiguo, ditungike mving'hwangwazi vili mgati ya ikiswili cha idihema, na idiguo dohabagula Hanhu Hang'alile kulawa Hanhu Hang'alile Ng'hani. Avo udingize Idisanduku da Lagano Hanhu Hang'alile Ng'hani. ");
INSERT INTO zajp_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Uike ingubiko uchana ya Idisanduku da Lagano mgati ya Hanhu Hang'alile Ng'hani. ");
INSERT INTO zajp_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Uike imeza Hanhu Hang'alile ng'ambu ya kaskazi, hanze ya Hanhu Hang'alile Ng'hani, na ikiguzo cha kwikila viwenge kike ng'ambu ya kusi ya idihema da kuiting'hanila, kikiilole na imeza. ");
INSERT INTO zajp_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Utende guo da kutungika hanhu ha kwingilila mdihema da kuiting'hanila na nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe, na dihambigwe na muhambaji. ");
INSERT INTO zajp_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Uditendele idiguo nguzo tano za m'biki wa mjoholo, na uzigubikize na zahabu. Ving'hwangwalingo vake viwe va zahabu, na uzikile vikalilo vitano va shaba. ");
INSERT INTO zajp_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Utende kilingo cha kulukuzila nhosa cha m'biki wa mjoholo, utali na ugazi wake viilinge. Utali wake uwe meta 2.2 na ugazi wake uwe meta 2.2 na wimo wake uwe meta 1.3. ");
INSERT INTO zajp_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Utende mhembe kuna zimhembe nne za ikilingo cha kulukuzila nhosa. Zimhembe zisongoligwe kulawa mkigogo cha idibiki ditendile ikilingo cha kulukuzila nhosa, na uzigubikize na shaba. ");
INSERT INTO zajp_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Utende nongo za kwikila mitozi, makulega, mikungu, uma, na vizolelo va kuzolela moto. Via vino vose viwe va shaba. ");
INSERT INTO zajp_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Kitendele lwavu lwa shaba, na uchana ya ulwavu uvigwasike vitindi vine va shaba mzimhembe zake nne. ");
INSERT INTO zajp_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Lwike lwavu luno lwa shaba hasi ya ulugigo luzunguluka ikilingo cha kulukuzila nhosa giladi luvike lwenza lwa ikilingo cha kulukuzila nhosa kulawa hasi. ");
INSERT INTO zajp_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Utende fimbo za m'biki wa mjoholo sama ya ikilingo cha kulukuzila nhosa, abaho uzigubikize na shaba. ");
INSERT INTO zajp_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Uzisomeke izifimbo m'vitindi vili mumgwazo wa ikilingo cha kulukuzila nhosa, giladi izifimbo zilawile ng'ambu zose mbili za ikilingo, na ziwe vipapilo va ikilingo. ");
INSERT INTO zajp_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ukitende ikilingo na mbamha za m'biki wa mjoholo, na kiwe kamba sanduku dipongole. Ukitende kamba vija vuulagusiligwe hano hakigongo. ");
INSERT INTO zajp_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Utende konhi da idihema da kuiting'hanila. Ng'ambu ya kusi ya idikonhi utungike miguo itendigwe na kitani inogile isokotigwe, ili na utali wa meta 44, ");
INSERT INTO zajp_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","nguzo zake malongo mabili na vikalilo vake malongo mabili viwe va shaba, ila iving'hwangwalingo va izinguzo na kabali zake ziwe za madini ga feza. ");
INSERT INTO zajp_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Vivija ng'ambu ya kaskazi ya idikonhi utungike miguo ili na utali wa meta 44, nguzo zake malongo mabili na vikalilo vake va shaba viwe malongo mabili, ila iving'hwangwalingo va izinguzo na kabali zake ziwe za madini ga feza. ");
INSERT INTO zajp_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ng'ambu ya uswelo wa zua ya idikonhi kowa na miguo ili na utali wa meta 22, hamoja na nguzo longo dimwe na vikalilo longo dimwe. ");
INSERT INTO zajp_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Vivija idikonhi dolondigwa diwe na ugazi wa meta 22 ng'ambu ya ulawilo wa zua kuli na hanhu ha kwingilila. ");
INSERT INTO zajp_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Miguo ili na utali wa meta 6.6 yolondigwa iwe ng'ambu imwe, hamoja na nguzo ndatu na vikalilo vidatu. ");
INSERT INTO zajp_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Na miguo ili na utali wa meta 6.6 yolondigwa iwe ng'ambu iyagwe, hamoja na nguzo ndatu na vikalilo vidatu. ");
INSERT INTO zajp_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Hanhu ha kwingilila mdikonhi utungike guo dili na utali wa meta 9, ditendigwe na nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe, dihambigwe na muhambaji. Guo dino dolondigwa ditungikwe mzinguzo nne na vikalilo vine. ");
INSERT INTO zajp_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Nguzo zose kuzunguluka idikonhi zolondigwa zifungigwe na kabali za madini ga feza. Ving'hwangwalingo vake vowa va madini ga feza, na vikalilo vake vowa va shaba. ");
INSERT INTO zajp_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Idikonhi diwe na utali wa meta 44, ugazi wa meta 22, na wimo wa meta 2.2. Miguo yake itendigwe na nyuzi za kitani inogile isokotigwe, na vikalilo vitendigwe na shaba. ");
INSERT INTO zajp_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Via vose visigale va idihema da kuiting'hanila va kila sang'hano hamoja na vigingi vose va idihema da kuiting'hanila na vigingi vose vizunguluke idikonhi, vitendigwe na shaba. ");
INSERT INTO zajp_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Walongele wanhu wa Islaeli wakugalile mavuta ganogile ga mzaituni gakamuligwe ga kugela m'viwenge, giladi iviwenge vigendelele kwaka. ");
INSERT INTO zajp_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ikiguzo cha kwikila viwenge cholondigwa kime mdihema da kuiting'hanila, haulongozi wa idiguo da mgati dikikiwiza Idisanduku da Lagano. Haloni na wanage wa kimbigalo wolondigwa wavibwinhe iviwenge na kuvileka vake kilo ngima haulongozi wa MNDEWA. Sang'hano ino iwe ya digunge mwa wanhu wa Islaeli na milelo yao yondaize. ");
INSERT INTO zajp_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Mgale kumwangu mkulu wako Haloni na wanage wa kimbigalo, Nadabu, Abihu, Eliazali, na Isamali, wanage kulawa mwa wanhu wa Islaeli, giladi wanisang'hanikile kamba wakulu wa nhambiko. ");
INSERT INTO zajp_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Mtendele mkulu wako Haloni kivalo king'alile, giladi umgwelele yenzi na unozi. ");
INSERT INTO zajp_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Wakeme magalu wose, awo iniwagwelele udaho, walongele watende vivalo va Haloni, giladi um'bagule sama yangu nie kamba mkulu wa nhambiko msang'hano yangu. ");
INSERT INTO zajp_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Vino vivo ivivalo vondawavitende, kifuko cha mmhambaga, kizibao, kanzu, shati dihambigwe goya, kilemba, na lukumbulu. Wotenda vivalo vino ving'alile sama ya mkulu wako Haloni hamoja na wanage, giladi wanisang'hanikile nie kamba wakulu wa nhambiko. ");
INSERT INTO zajp_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Vivalo vino wavitende na nyuzi za zahabu, nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile. ");
INSERT INTO zajp_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Utende kizibao na nyuzi za zahabu, nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe dihambigwe na muhambaji. ");
INSERT INTO zajp_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kiwe na mikandala mibili ya mmaega ya kukilumbila ikizibao ng'ambu ya kuulongozi na ng'ambu ya kuchugu, giladi ikizibao kiilumbe hamoja. ");
INSERT INTO zajp_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Lukambala luhambigwe lwa ikizibao lutendigwe na vinhu vivija vitendile ikizibao, nyuzi za zahabu, nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe lolondigwa lushonelwe mkizibao. ");
INSERT INTO zajp_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Sola mabwe mabili gakemigwe shohamu, na uchana yake ugasongole matwaga ga wana longo dimwe na wabili wa Islaeli, ");
INSERT INTO zajp_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","kulingana na vija viwavumbuke, matwaga sita mdibwe dimwe, na matwaga sita mdibwe diyagwe. ");
INSERT INTO zajp_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ugasongole matwaga ga wana wa Islaeli uchana ya igamabwe mabili kamba vija msongola dibwe da hela bwando viyosongola utango. Abaho ugagele mzifelemu zilukigwe na nyuzi za zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Mabwe gano mabili ugabandikize mmikandala ya mmaega ya ikizibao, gawe mabwe ga ng'humbukila sama ya wana wa Islaeli. Haloni yagapape matwaga gao mmaega gake giladi mazua gose nie, MNDEWA, niwakumbukile wanhu zangu. ");
INSERT INTO zajp_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Tenda felemu mbili zilukigwe na nyuzi za zahabu ");
INSERT INTO zajp_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","na mikufu mibili ya zahabu ing'alile, isokotigwe kamba nzabi, na uibandikize imikufu muna izifelemu zilukigwe na nyuzi za zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Utende kifuko cha mmhambaga chondakimtaze mkulu wa wakulu wose wa nhambiko kugelegeza gaja gonilonda nie, MNDEWA. Ukitende na ufundi mkulu na vinhu vivija vitendile ikizibao, ukitende na nyuzi za zahabu, nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe. ");
INSERT INTO zajp_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ukikunze mwanza umwe, na utende utali wake na ugazi wake uilinge, utali wake uwe sentimeta 22 na ugazi wake uwe sentimeta 22. ");
INSERT INTO zajp_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Abaho uchana yake ika minhongo mine ya mabwe ga hela bwando. Mumnhongo wa ichanduso, wike mabwe ga akiki, yakuti manjano, na bahalamani. ");
INSERT INTO zajp_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Mumnhongo wa ikabili, wike mabwe ga zumalidi, yakuti samawi, na alimasi. ");
INSERT INTO zajp_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Mumnhongo wa ikadatu, wike mabwe ga yasinto, akiki ndung'hu, na ametisto. ");
INSERT INTO zajp_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Mumnhongo wa ikane, wike mabwe ga zabalajadi, shohamu, na yasipi. Mabwe gano gose gageligwe mzifelemu za nyuzi za zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Kuwe na mabwe longo dimwe na mabili kamba vigali matwaga ga wana wa Islaeli. Mabwe gano gawe kamba utango wao, kila dibwe dimwe disongoligwe mtala umwe wa wana wa Islaeli. ");
INSERT INTO zajp_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Ukitendele ikifuko cha mmhambaga mikufu ya zahabu ing'alile, isokotigwe kamba nzabi, ");
INSERT INTO zajp_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","na ukitendele ikifuko cha mmhambaga vitindi vibili va zahabu, abaho uvigwasike ivitindi vibili mzimhembe mbili za uchana za ikifuko cha mmhambaga. ");
INSERT INTO zajp_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Uigwasike imikufu mibili ya zahabu m'vitindi vibili vili mzimhembe za uchana ya ikifuko cha mmhambaga, ");
INSERT INTO zajp_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","sota mbili ziyagwe za imikufu ya zahabu uzifudike mzifelemu mbili za nyuzi za zahabu, uzifudike mmikandala ya mmaega ya ikizibao ng'ambu ya kuulongozi. ");
INSERT INTO zajp_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Utende vitindi vibili va zahabu, na uvigwasike mzimhembe mbili za hasi ya ikifuko cha mmhambaga, mulugigo lwake lwa mgati behi na ikizibao. ");
INSERT INTO zajp_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Utende vitindi vibili viyagwe va zahabu, uvigwasike hasi ya imikandala mibili ya mmaega kuulongozi wa ikizibao, behi na ulugigo uchana ya ulukambala luhambigwe lwa ikizibao. ");
INSERT INTO zajp_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Uvifudike ivitindi va ikifuko cha mmhambaga kuna ivitindi va ikizibao na nzabi za buluu, giladi ikifuko cha mmhambaga kikale uchana ya ulukambala luhambigwe lwa ikizibao, na kija ikifuko cha mmhambaga hakilondigwa kilegele kulawa mkizibao. ");
INSERT INTO zajp_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Kipigiti Haloni vondayengile Hanhu Hang'alile, yagapape matwaga ga wana wa Islaeli hana umoyo wake mkifuko cha mmhambaga chondakimtaze kugelegeza gaja gonilonda nie, MNDEWA, giladi nigendelele kuwakumbuka wanhu zangu mazua gose. ");
INSERT INTO zajp_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Vivija gela Ulimu na Tumimu mkifuko cha mmhambaga vikale hana umoyo wa Haloni kipigiti vondayengile haulongozi wangu nie. Mnzila ino, Haloni kolondigwa yakivale kifuko kino cha mmhambaga giladi yagagelegeze gaja gonilonda nie sama ya Waislaeli. ");
INSERT INTO zajp_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Utende kanzu ya langi ya buluu ya kuvalila mgati ya ikizibao. ");
INSERT INTO zajp_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Utende zonzo hagatigati, sama ya kwingizila ditwi. Wike lugigo lulukigwe kuzunguluka idizonzo, giladi ikanzu sambiidegeke. ");
INSERT INTO zajp_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Kuzunguluka ulugigo lose lwa hasi ya ikanzu kuhambigwe vinhu vilingile na makomamanga, vihambigwe na nyuzi za buluu, zambalau, na ndung'hu. Hagatigati ya makomamanga gano kuwe na mbugi za zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Zimbugi za zahabu na igamakomamanga voisondolele, komamanga kuchugu mbugi haulongozi kuzunguluka ulugigo lwa ikanzu. ");
INSERT INTO zajp_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Haloni kolondigwa yaivale ikanzu kipigiti cha kunisang'hanikila nie, MNDEWA. Dizwi da izimbugi nodihulika kipigiti viyokwingila Hanhu Hang'alile haulongozi wangu na kipigiti voyolawa hanze, giladi sambinimkome. ");
INSERT INTO zajp_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Utende kidiwala kibanhibanhi cha zahabu ing'alile, uchana yake ukisongole nyandiko kamba viwasongolaga utango na uchandike mbuli zino, ‘YANG'ALILE HA MNDEWA’ mkukisongola kamba vawasongolaga utango. ");
INSERT INTO zajp_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ukifudike ikidiwala kibanhibanhi na nzabi ya langi ya buluu haulongozi wa ikilemba. ");
INSERT INTO zajp_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Mazua gose Haloni kokivala mkihanga chake, giladi nie, MNDEWA, nizibokele nhosa zose azo Waislaeli wondawazibagule sama yangu nie, hata kamba wanhu wahahonyela mkipigiti cha kuzilava. ");
INSERT INTO zajp_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Uluke shati ya kitani inogile, na utende kilemba cha kitani inogile. Abaho tenda lukumbulu luhambigwe na muhambaji. ");
INSERT INTO zajp_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Watendele wana wa kimbigalo wa Haloni mashati, ng'humbulu, na kofia, sama ya kuwagwelela yenzi na unozi. ");
INSERT INTO zajp_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Vivalo vino kowavaza Haloni hamoja na wanage, uwabake mavuta, uwasimike, na uwabagule sama yangu nie, giladi wanisang'hanikile kamba wakulu wa nhambiko. ");
INSERT INTO zajp_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Watendele kaputula za kitani za kuvaza ng'huli zao zondazigubike songela mchuno mbaka mmahaza. ");
INSERT INTO zajp_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Haloni na wanage wolondigwa wavale kaputula zino kipigiti vondawengile mdihema da kuiting'hanila, ama wahakikwenhukila ikilingo cha kulavila nhosa kipigiti cha kulava nhosa za kulukuza. Ila kamba hawazivalile kaputula zino, wokiigalila vilozo wenyego na wodanganhika. Haloni na lukolo lwake wose wakimbigalo wolondigwa wazigoge ndagizi zino milongo yose. ");
INSERT INTO zajp_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Vino vivo vondauwabagule Haloni na wanage sama yangu nie, giladi wanisang'hanikile kamba wakulu wa nhambiko. Sola songolomi imwe wa ng'ombe na songolomi wabili wa ng'hondolo walibule ulemale. ");
INSERT INTO zajp_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Sola usage unogile wa ngano, tenda mikate ilibule mela yokigwe bila mavuta, abaho tenda mikate iyagwe ilibule mela yokigwe na mavuta, na utende vikate vilibule mela uvibake mavuta. ");
INSERT INTO zajp_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Uigele mumgelo na uilave nhosa kumwangu kipigiti vondaulave nhosa ya songolomi wa ng'ombe na iwang'hondolo wabili songolomi. ");
INSERT INTO zajp_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Abaho wagale Haloni na wanage hanhu ha kwingilila mdihema da kuiting'hanila na uwanave na mazi. ");
INSERT INTO zajp_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Abaho m'vaze Haloni vivalo va mkulu wa nhambiko, shati, kanzu, kizibao, kifuko cha mmhambaga, na umfunge mchuno na lukambala luhambigwe lwa ikizibao. ");
INSERT INTO zajp_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","M'vaze kilemba mditwi jake, na ukibandikize ikidiwala kibanhibanhi king'alile cha zahabu uchana ya ikilemba. ");
INSERT INTO zajp_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Usole mavuta ga kubakala, umwitile mditwi jake, kulagusa kamba kum'bagula sama yangu nie. ");
INSERT INTO zajp_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Abaho uwagale wanage, na uwavaze mashati, ");
INSERT INTO zajp_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","na uwafunge ng'humbulu mchuno na kuwavaza kofia mmatwi gao. Sang'hano ya ukulu wa nhambiko iwe yao milongo yose. Abaho uwasimike Haloni na wanage. ");
INSERT INTO zajp_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Umgale songolomi wa ing'ombe haulongozi wa idihema da kuiting'hanila, abaho uwalongele Haloni na wanage weke makono gao mditwi jake. ");
INSERT INTO zajp_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Abaho umchinje isongolomi wa ng'ombe haulongozi wangu nie, MNDEWA, hanhu ha kwingilila mdihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Usole mulopa kidogo wa ing'ombe na kidole chako uugele mzimhembe za ikilingo cha kulukuzila nhosa, na umulopa wondausigale uwitile hasi ya ikilingo cha kulukuzila nhosa. ");
INSERT INTO zajp_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Abaho usole mavuta gose gali mgati muinda na ng'ambu ya hasi ya ini, na usole figo zose mbili na gamavuta gali uchana yake, uvilukuze uchana ya ikilingo cha kulukuzila nhosa. ");
INSERT INTO zajp_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ila inyama ya ng'ombe, kwembe jake, na mavi gake uvisome hanze ya ing'hambi, viwe nhosa ya upatanizo. ");
INSERT INTO zajp_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Abaho sola imwe wa songolomi wa ng'hondolo, na Haloni na wanage weke makono gao mditwi jake. ");
INSERT INTO zajp_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Mchinje abaho usole mulopa wake uumize mzing'ambu zake zose nne za ikilingo cha kulukuzila nhosa. ");
INSERT INTO zajp_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Mkanhe ing'hondolo vidangavidanga, na uvisuluze vinhu va mgati na migulu, na uvike hamoja na iditwi na ividanga viyagwe. ");
INSERT INTO zajp_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Abaho mulukuze ing'hondolo wose uchana ya ikilingo cha kulukuzila nhosa. Ino iyo nhosa ya kulukuza ha nie, MNDEWA, nhosa inung'hila goya, ilavigwa kumwangu nie. ");
INSERT INTO zajp_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Msole songolomi wa ng'hondolo iyagwe, na Haloni na wanage weke makono gao mditwi jake. ");
INSERT INTO zajp_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Mchinje songolomi wa ing'hondolo na usole kiasi cha mulopa wake uugele mzindewe za magwiti ga ng'ambu ya ukulume ga Haloni na wanage, m'vidole gumba va magulu gao ga ukulume, na m'vidole gumba va makono gao ga ukulume. Mulopa usigale umize mzing'ambu zose nne za ikilingo cha kulukuzila nhosa. ");
INSERT INTO zajp_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Abaho usole kiasi cha mulopa uli mkilingo cha kulukuzila nhosa na kiasi cha gamavuta ga kubakala, na uwamizile Haloni na vivalo vake na wanage na vivalo vao. Mkutenda avo, kowasimika hewo na vivalo vao sama yangu nie. ");
INSERT INTO zajp_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Vivija kolondigwa usole mavuta ga songolomi wa ng'hondolo, mavuta ga mumkila, mavuta gali mgati muinda na ng'ambu ya hasi ya idiini, figo zose mbili na mavuta gali uchana yake, na mgulu wa kuchugu wa ukulume kwavija ng'hondolo ino ka mmwanza wa vilokotelo va kusimikila. ");
INSERT INTO zajp_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Kulawa mumgelo wa mikate yondailavigwe kumwangu, sola mkate umwe ulibule mela wokigwe bila mavuta na mkate umwe ulibule mela wokigwe na mavuta na kikate kimwe kibanhibanhi kilibule mela. ");
INSERT INTO zajp_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Vakuja vino vose uwagwelele Haloni na wanage na uwalongele wavinule kumwangu kamba nhosa kisinyo. ");
INSERT INTO zajp_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Abaho uvisole ivakuja kulawa mmakono gao na uvilukuze uchana ya ikilingo cha kulukuzila nhosa hamoja na nhosa ya kulukuza, iwe nhosa ya vakuja ilavigwa kumwangu nie. Mnung'ho wa nhosa ino woninogela nie. ");
INSERT INTO zajp_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Sola nyama ya mmhambaga ya ng'hondolo wa kumsimikila Haloni, na uinule uchana haulongozi wangu iwe kamba nhosa kisinyo kumwangu nie, abaho uisole iwe mandia gako gweye. ");
INSERT INTO zajp_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Zibagule izinyama sama yangu nie, nyama ya imhambaga inuligwe na nyama ya idihaza ikigwe hamgwazo ziwe nhosa kisinyo kumwangu nie kulawa ha songolomi wa ng'hondolo wa kumsimika Haloni, na nyama hizo zowa za Haloni na lukolo lwake. ");
INSERT INTO zajp_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Gano gago magao gondawabokele Haloni na wanage kulawa ha Waislaeli mazua gose. Ino iyo nhosa ya Waislaeli yondawalave kulawa mnhosa zao za tindiwalo, nhosa yao kumwangu nie. ");
INSERT INTO zajp_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Haloni yehesha kudanganhika, vivalo vake ving'alile wagweleligwe wanage, wavivale kipigiti wahabakigwa mavuta na kusimikwa. ");
INSERT INTO zajp_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Mwana wa Haloni yondayamuhale tataake muisang'hano ya ukulu wa nhambiko na yondayengile mdihema da kuiting'hanila kusang'hanika Hanhu Hang'alile kolondigwa yavale vivalo vino mmazua saba. ");
INSERT INTO zajp_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Sola nyama ya songolomi wa ng'hondolo wa kuwasimikila Haloni na wanage na uitogosele mgati ya idikonhi da idihema. ");
INSERT INTO zajp_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Hanhu ha kwingilila mdihema da kuiting'hanila, Haloni na wanage waje inyama ya ing'hondolo na imikate isigale mumgelo. ");
INSERT INTO zajp_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Hewo weiyeka wao wolondigwa kuija inyama na imikate yondailavigwe nhosa sama ya kugeligwa kumgongo vilozo vao mkipigiti cha kusimikwa na kubagulwa sama yangu nie. Haduhu munhu iyagwe yolondigwa kuija, kwavija vinhu vino ving'ala. ");
INSERT INTO zajp_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kamba kiasi cha inyama ama kiasi cha umkate visigala mbaka imitondo, visomigwe. Sambividigwe, kwavija ving'ala. ");
INSERT INTO zajp_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Watendele Haloni na wanage kila kinhu kinikulagize, watendele lusona lwa kuwasimika mkipigiti cha mazua saba. ");
INSERT INTO zajp_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Kila zua ulave nhosa ya songolomi wa ng'ombe iwe nhosa ya upatanizo. Vivija ulave nhosa ya upatanizo sama ya ikilingo cha kulukuzila nhosa, kipigiti uhakitendela upatanizo ikilingo cha kulukuzila nhosa, na ukibake mavuta, na kukibagula sama yangu nie. ");
INSERT INTO zajp_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Mkipigiti cha mazua saba tenda ung'alizo sama ya ikilingo cha kulukuzila nhosa na ukibagule sama yangu nie. Abaho ikilingo cha kulukuzila nhosa chong'ala kabisa, na munhu yoyose yondayakikwase ikilingo cha kulukuzila nhosa kong'ala. ");
INSERT INTO zajp_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Zino zizo nhosa zondaunilavile nie kila zua mkilingo cha kulukuzila nhosa. Kila zua ulave ng'hondolo wabili wa mulao umwe. ");
INSERT INTO zajp_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ng'hondolo imwe mulave imitondo na ng'hondolo iyagwe mulave ichungulo. ");
INSERT INTO zajp_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ng'hondolo wa ichanduso umulave hamoja na kilo imwe ya usage unogile wa ngano utibulizwe na lita imwe ya mavuta ganogile ga mzaituni. Gida lita imwe ya divai iwe kamba nhosa. ");
INSERT INTO zajp_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Mulave ng'hondolo wa ikabili mkipigiti cha ichungulo, mulave hamoja na kiasi kikija cha usage wa ngano, mavuta ga mzaituni, na divai kamba vuutendile imitondo, iwe nhosa inung'hila goya, nhosa ya kulukuza ha nie, MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Mkipigiti chose kikwiza, nhosa ino ya kulukuza ilavigwe haulongozi wangu hanhu ha kwingilila mdihema da kuiting'hanila, aho hondaniiting'hane na wanhu zangu na kulonga na gweye. ");
INSERT INTO zajp_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ako vivija noiting'hana na Waislaeli, na hanhu aho hong'alizwa na yenzi yangu. ");
INSERT INTO zajp_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Novibagula sama yangu nie idihema da kuiting'hanila na ikilingo cha kulukuzila nhosa. Na vivija nowabagula Haloni na wanage sama yangu nie giladi wanisang'hanikile nie kamba wakulu wa nhambiko. ");
INSERT INTO zajp_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Nokala hamoja na Waislaeli, na nie nowa Mulungu wao. ");
INSERT INTO zajp_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Na hewo wovitanga kamba nie iyo MNDEWA Mulungu wao, niwalavile muisi ya Misili giladi nikale hamoja na hewo. Nie iyo MNDEWA Mulungu wao. ");
INSERT INTO zajp_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Usole m'biki wa mjoholo utende kilingo cha kufushila ubane. ");
INSERT INTO zajp_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ng'ambu zose ziilinge, kiwe na utali wa sentimeta 45 na ugazi wa sentimeta 45 na wimo wa sentimeta 90. Mhembe zake zili mzimhembe zake nne zisongoligwe kulawa mdibiki dimwe ditendile ikilingo cha kufushila ubane. ");
INSERT INTO zajp_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Uchana ya ikilingo cha kufushila ubane, ng'ambu zake zose, na izimhembe zake zose uzigubikize na zahabu ing'alile. Na ukitendele lugigo lwa zahabu uchana kuzunguluka ikilingo cha kufushila ubane. ");
INSERT INTO zajp_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ukitendele vitindi vibili va zahabu va kugogela izifimbo za kukipapila, hasi ya ulugigo lwake, mzing'ambu zake mbili. ");
INSERT INTO zajp_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Utende fimbo za m'biki wa mjoholo, na uzigubikize na zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Kilingo kino cha kufushila ubane cholondigwa ukike haulongozi wa idiguo ditungikigwe haulongozi wa idisanduku na ingubiko yake. Uchana ya ingubiko baho hanhu hondanilonge na gweye. ");
INSERT INTO zajp_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Kila imitondo kipigiti Haloni yeheza kuvigongomanya iviwenge, yafushe ubane unung'hila goya uchana ya ikilingo cha kufushila ubane. ");
INSERT INTO zajp_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Na kila ichungulo kipigiti yahabwinha iviwenge, vivija kolondigwa yafushe ubane haulongozi wangu nie, MNDEWA. Mbuli ino yolondigwa itendeke mmilelo yako yose yondaize. ");
INSERT INTO zajp_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Sambiufushe ubane wowose ugomesigwe uchana ya ikilingo cha kufushila ubane, ama nhosa yoyose ya kulukuza, ama nhosa yoyose ya usage, na sambiugide nhosa yoyose ya divai uchana yake. ");
INSERT INTO zajp_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Mwanza umwe mmulao umwe Haloni kolondigwa yatende mpatano sama ya ikilingo cha kufushila ubane mkuzibaka zimhembe za ikilingo na mulopa wa mng'onyo yalavigwe nhosa ya kuwapataniza wanhu watendile vilozo. Sang'hano ino yolondigwa itendeke na Haloni na milelo yake yose yondaize, kwavija kino kicho kilingo cha kufushila ubane king'alile ha MNDEWA.” ");
INSERT INTO zajp_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Abaho MNDEWA kamulongela Musa, ");
INSERT INTO zajp_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Kipigiti vondauwapete Waislaeli, kila munhu yalihe hela kumwangu sama ya kuukombola ugima wake, giladi sambiyavikigwe na utamu wihile ng'hani mkipigiti cha wanhu kupetigwa. ");
INSERT INTO zajp_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Kila munhu yopetigwa kolondigwa yalihe lwenza lwa kidanga cha madini ga feza kulingana na kipimilo kili mdihema da kuiting'hanila. Lwenza luno lwa ikidanga cha madini ga feza lowa nhosa kumwangu nie, MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Kila munhu yopetigwa, songela munhu yali na milao malongo mabili na kugendelela, kolondigwa yanilavile nhosa nie, MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Munhu yali mgoli sambiyabanzilize kulava, na mkumbulu sambiyahunguze kulava kipigiti cha kulava nhosa ya mpatano na MNDEWA sama ya ugima wenu. ");
INSERT INTO zajp_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Zibokele hela hizo za mpatano kulawa ha Waislaeli zitende sang'hano ya kudigongomanya idihema da kuiting'hanila. Hela hizo zowatenda Waislaeli wakumbukigwe haulongozi wangu nie, MNDEWA, na kutenda mpatano sama ya ugima wenu.” ");
INSERT INTO zajp_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Abaho MNDEWA kamulongela Musa, ");
INSERT INTO zajp_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Tenda teleko da shaba na kikalilo chake kiwe cha shaba sama ya kunavila magulu na makono. Dike hagatigati ya idihema da kuiting'hanila na ikilingo cha kulukuzila nhosa, abaho dimemeze mazi. ");
INSERT INTO zajp_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Haloni na wanage wolondigwa wanave magulu gao na makono gao na mazi gali mditeleko dino. ");
INSERT INTO zajp_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Kipigiti wehengila mdihema da kuiting'hanila, ama kipigiti cha kukwenhukila ikilingo cha kulukuzila nhosa muisang'hano ya kulava nhosa ya kulukuza ha MNDEWA, wolondigwa wainave na mazi gano, giladi sambiwadanganhike. ");
INSERT INTO zajp_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Wolondigwa wainave magulu gao na makono gao, giladi sambiwadanganhike. Haloni na lukolo lwake wolondigwa waigoge ndagizi ino milongo yose.” ");
INSERT INTO zajp_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Abaho MNDEWA kamulongela Musa, ");
INSERT INTO zajp_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Sola vilungilo vino vinogile, kilo sita za manemane ga ululu, kilo ndatu za mdalasini unung'hila goya, kilo ndatu za migua inung'hila goya, ");
INSERT INTO zajp_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","na kilo sita za namna iyagwe ya mdalasini zipimigwe kulingana na kipimilo kili mdihema da kuiting'hanila. Yongeza na lita nne za mavuta ga mzaituni, ");
INSERT INTO zajp_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","na ugatende mavuta gano gang'alile ga kubakala kamba viyatendaga galu wa kutenda mavuta ga kunung'hila. Gowa mavuta gang'alile ga kubakala. ");
INSERT INTO zajp_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Abaho ugasole na ubakaze mdihema da kuiting'hanila, Mdisanduku da Lagano, ");
INSERT INTO zajp_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","muimeza na via vake vose, mkiguzo cha kwikila viwenge na via vake vose, mkilingo cha kufushila ubane, ");
INSERT INTO zajp_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","mkilingo cha kulukuzila nhosa hamoja na via vake vose, na mditeleko hamoja na kikalilo chake. ");
INSERT INTO zajp_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Uvibagule sama yangu nie giladi ving'ale ng'hani, na munhu yoyose yondayavikwase kong'ala, na kinhu chochose chondakivikwase chong'ala. ");
INSERT INTO zajp_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Uwabake mavuta Haloni na wanage na uwabagule sama yangu nie giladi wanisang'hanikile nie wawe wakulu wa nhambiko. ");
INSERT INTO zajp_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Walongele Waislaeli, ‘Gano gowa mavuta gang'alile gangu nie, MNDEWA, ga kubakala mmilelo yenu yondaize. ");
INSERT INTO zajp_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Sambim'bakale mavuta gano kamba vum'bakala mavuta gayagwe mzing'huli zenu na sambimtende mavuta gayagwe na vilokotelo vilingile na vino. Mavuta gano gang'ala, na golondigwa gang'ale kumwenu mweye. ");
INSERT INTO zajp_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Munhu yoyose yotenda mavuta galingile na gano, ama kum'baka munhu yoyose yalekile kuwa mkulu wa nhambiko, munhu hiyo kolondigwa yasegezigwe kulawa mmwanza wa wanhu zake.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Abaho MNDEWA kamulongela Musa, “Deha kiasi kiilingile kulawa m'vilungilo vose vilimwilile vili hano hasi, ululu wa natafi, ululu wa shekeleti, ululu wa kelibena, na ubane unung'hila goya ung'alile. ");
INSERT INTO zajp_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Sola vilungilo uvike hamoja, na uvitibulize kamba galu wa kutenda mavuta ga kunung'hila viyatendaga, abaho uvimizile munyu giladi upate ubane unung'hila goya unogile na ung'alile. ");
INSERT INTO zajp_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Sola vilungilo kidogo uvisiginhe viwe usage, na uvike haulongozi wa Idisanduku da Lagano mdihema da kuiting'hanila, ako kondaniiting'hane na gweye. Uno wowa ubane ung'alile ng'hani kumwenu. ");
INSERT INTO zajp_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Sambimkiitendele ubane wowose mnzila ino, uvitange kamba uno uwo ubane ung'alile kumwangu nie, MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Munhu yoyose yotenda ubane kamba uno sama ya kuitenda yanung'hile kolondigwa yasegezigwe kulawa mmwanza wa wanhu zangu.” ");
INSERT INTO zajp_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Abaho MNDEWA kamulongela Musa, ");
INSERT INTO zajp_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Loleni, nimsagula Bezaleli, mwana wa Uli, mzukulu wa Huli, kulawa mumtala wa Yuda. ");
INSERT INTO zajp_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Nimmemeza Loho yangu na kumgwelela udaho, nzewele, na ilimu ya ufundi wa namna zose, ");
INSERT INTO zajp_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","wa kusongola ulembo muna zizahabu, madini ga feza, na shaba, na ufundi mkulu ng'hani, ");
INSERT INTO zajp_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","mkugakanha mabwe ga hela bwando na kugeka mvifelemu, na mkusongola mibiki hamoja na namna zose za ufundi ");
INSERT INTO zajp_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Vivija nimsagula Oholiabu, mwana wa Ahisamaki, kulawa mumtala wa Dani, yamtaze Bezaleli. Vivija niwagwelela udaho magalu wose watende kila kinhu kinikulagize gweye, ");
INSERT INTO zajp_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","hema da kuiting'hanila, Sanduku da Lagano hamoja na ngubiko yake, na vinhu vose viyagwe vili mgati ya idihema da kuiting'hanila, ");
INSERT INTO zajp_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","meza na via vake, kiguzo cha zahabu ing'alile cha kwikila viwenge na via vake vose, kilingo cha kufushila ubane, ");
INSERT INTO zajp_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","kilingo cha kulukuzila nhosa na via vake vose, teleko da shaba na kikalilo chake, ");
INSERT INTO zajp_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","na vivalo vinogile, vivalo ving'alile sama ya Haloni, mkulu wa nhambiko, na vivalo va wanage wa kimbigalo, sama ya kutendela sang'hano zao za ukulu wa nhambiko, ");
INSERT INTO zajp_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","na mavuta ga kubakala na ubane unung'hila goya sama ya Hanhu Hang'alile. Mafundi wolondigwa watende kila kinhu kamba vinikulagize gweye.” ");
INSERT INTO zajp_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Abaho MNDEWA kamulongela Musa, ");
INSERT INTO zajp_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Walongele Waislaeli, ‘Molondigwa mgagoge mazua gangu ga mhumulo. Mbuli ino yowa kilaguso hagatigati yangu nie na mweye sama ya milelo yenu yondaize, giladi m'vitange kamba nie iyo MNDEWA, niwatendile mweye kuwa wanhu zangu. ");
INSERT INTO zajp_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Mdigoge Zua da Mhumulo, kwavija zua dino ding'ala kumwenu. Munhu yoyose yodizabuza zua dino mkutenda sang'hano yoyose mdizua dino kolondigwa yakomigwe na kusegezigwa kulawa mmwanza wa wanhu zangu. ");
INSERT INTO zajp_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Msang'hanike mmazua sita, ila zua da saba dijo Zua da Mhumulo, zua ding'alile kumwangu nie. Munhu yoyose yosang'hanika Mdizua da Mhumulo kolondigwa yakomigwe. ");
INSERT INTO zajp_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Avo Waislaeli wadigoge Zua da Mhumulo, hewo na milelo yao yondaize, kamba lagano da digunge. ");
INSERT INTO zajp_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Kino chowa kilaguso cha digunge hagatigati yangu nie na hewo, kwavija mmazua sita nie, MNDEWA, nitenda ulanga na isi, na mdizua da saba nileka kusang'hanika, nihumula.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","MNDEWA viyeshile kulonga na Musa Mdigongo da Sinai, kamgwelela Musa mbamha mbili za mabwe za Lagano, zandikigwe na kidole chake mwenyego. ");
INSERT INTO zajp_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Wanhu viwonile kamba Musa kakawa kuhumuluka kulawa hakigongo, wamzunguluka Haloni, na kumulongela, “Izo, ututendele miungu, ayo yondaitulongole, kwavija Musa ija, yatulavile tweye kulawa muisi ya Misili, hatukitanga kinhu kimulawilile.” ");
INSERT INTO zajp_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Haloni kawalongela, “Soleni heleni za zahabu zili mmagwiti ga watwanzi zenu, wamhale zenu, na wandele zenu, na mzigale kumwangu.” ");
INSERT INTO zajp_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Avo wanhu wose wazivula ziheleni za zahabu kulawa mmagwiti gao, na kumgwelela Haloni. ");
INSERT INTO zajp_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Kazisola zija ziheleni, kazilumbula, na kutenda nyago da songolomi wa mwanang'ombe. Abaho walonga, “Ino iyo miungu yetu tweye Waislaeli itulavile muisi ya Misili!” ");
INSERT INTO zajp_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Abaho Haloni kazenga kilingo cha kulavila nhosa haulongozi wa imwanang'ombe wa zahabu na kulonga, “Mayo kowa na lusona ha MNDEWA.” ");
INSERT INTO zajp_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Walamuka imitondo ng'hani zua da ikabili, walava nhosa za kulukuza na kugala nhosa za tindiwalo, abaho wakala hasi waja na kung'wa, wenuka na kuvina. ");
INSERT INTO zajp_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","MNDEWA kamulongela Musa, “Humuluka hasi, kwavija wanhu zako, awo uuwalavile muisi ya Misili, watenda vilozo na kunilema nie. ");
INSERT INTO zajp_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Hima wazileka mbuli zose ziniwalondile hewo wazitende. Wakiitendela nyago da zahabu dilumbile kamba mwanang'ombe, wakitambikila na kukilavila nhosa, abaho walonga kamba ino iyo miungu yao iwalavile kulawa muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Niwona wanhu wano, vija viwali na singo ndala. ");
INSERT INTO zajp_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Nileke niwonele lusango, niwabanange. Abaho nokutenda gweye na lukolo lwako kuwa undewa mkulu.” ");
INSERT INTO zajp_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ila Musa kamuyalalila MNDEWA Mulungu wake. Kalonga, “MNDEWA, habali uwonela lusango wanhu zako, awo uuwalavile muisi ya Misili na udaho mkulu na mkono wene mhiko? ");
INSERT INTO zajp_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Habali uwatenda Wamisili walonge kamba Mulungu wao kawalava muisi ya Misili kuno yali na nia ihile ya kuwakomela mmigongo na kuwabananga? Luhindule lusango lwako, hindula ngelegeza zako, na sambiugale mwangalo mwa wanhu zako. ");
INSERT INTO zajp_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Wakumbukile watumigwa zako Ablaham, Isaka, na Yakobo, awo yuuwaduilile gweye mwenyego, ulonga, ‘Nozitenda ng'holo zenu zongezeke kamba nhondo za kuulanga, na kuwagwelela isi inikile kilagano na mweye kamba, ng'holo zenu ziihale gunge na gunge.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Avo MNDEWA kazihindula ngelegeza zake na kugimbula kuwatendela wanhu zake mbuli ihile iyalondile kuwatendela. ");
INSERT INTO zajp_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Abaho Musa kahinduka na kuhumuluka hasi kulawa mkigongo, kuno yapapile mbamha mbili za mabwe za Lagano mmakono gake, mbamha zikalile zandikigwe ng'ambu zose, kuulongozi na kuchugu. ");
INSERT INTO zajp_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Mbamha zino zikala zitendigwe na Mulungu mwenyego, na izinyandiko zikala nyandiko za Mulungu, zisongoligwe uchana ya izimbamha. ");
INSERT INTO zajp_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yoshua viyahulike nyangi za wanhu woguta, kamulongela Musa, “Hana dizwi da ng'hondo mgati ya ing'hambi.” ");
INSERT INTO zajp_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ila Musa kalonga, “Sio dizwi da mhuma ama kililo cha kuhumwa, ila dinihulika nie dizwi da wanhu wokwimba.” ");
INSERT INTO zajp_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Musa viyaikwenhukile ing'hambi na kona imwanang'ombe wa zahabu na wanhu wovina, kona lusango ng'hani na kwasa izimbamha kulawa mmakono gake, kazibena vidangavidanga hasi ya idigongo. ");
INSERT INTO zajp_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Kamsola imwanang'ombe ija iwamtendile na kumsoma muna umoto. Abaho kamsiginha na ija imwanang'ombe kawa kamba usage, abaho Musa kausola uusage na kuumizila mmazi na kuwashulutiza Waislaeli wang'we. ");
INSERT INTO zajp_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musa kamulongela Haloni, “Choni chawakutendele wanhu wano mbaka kuwalongoza mkilozo kikulu kamba kino?” ");
INSERT INTO zajp_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Haloni kalonga, “Sambiwone lusango, mndewa wangu, gweye mwenyego kovitanga vija wanhu wano viwehile. ");
INSERT INTO zajp_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Wanilongela, ‘Tutendele miungu yondaitulongoze, kwavija Musa ija, ayo yatulavile tweye kulawa muisi ya Misili, hatukitanga kinhu kimulawilile.’ ");
INSERT INTO zajp_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Avo niwalongela, ‘Munhu yoyose yali na zahabu, yaivule.’ Abaho wanigwelela zizahabu, na nie nizigela muna umoto, na kalawilila mwanang'ombe ino.” ");
INSERT INTO zajp_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa kona kamba wanhu watenda mbuli za ubozi, na Haloni iyo yawalekile watende mbuli za ubozi na kuwatenda wasekigwe na wadumuka zao. ");
INSERT INTO zajp_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Avo Musa kema hanhu ha kwingilila muna ing'hambi na kulonga, “Munhu yoyose yali ng'ambu ya Mulungu, yeze kumwangu!” Na Walawi wose wamcholela na kumzunguluka. ");
INSERT INTO zajp_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Abaho kawalongela, “Vino vivo MNDEWA, Mulungu wa Islaeli, voyolonga, ‘Kila munhu mmwanza wenu yadifunge mchuno zele jake na kuchola kuchugu cha ing'hambi na kuulongozi wa ing'hambi kulawa ng'ambu ino mbaka ng'ambu iyagwe yakamkome ndugu yake, mbwigaake, na munhu wa habehi yake.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Walawi watenda kamba Musa viyawalagize, na mdizua hijo wanhu alufu ndatu (3,000) wadanganhika. ");
INSERT INTO zajp_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Abaho Musa kalonga, “Lelo muisimika wenyego sama ya sang'hano ya MNDEWA, kwavija mtogola kuwakoma wanenu na wandugu zenu, na MNDEWA lelo kowamoteza.” ");
INSERT INTO zajp_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Imitondo iyagwe Musa kawalongela waja iwanhu, “Mtenda vilozo vikulu ng'hani. Ila sambi nochola ha MNDEWA, siku nodaha kutenda mpatano sama ya vilozo venu.” ");
INSERT INTO zajp_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Avo Musa kabweleganya ha MNDEWA na kulonga, “Wanhu wano watenda vilozo vikulu ng'hani. Wakitendela wenyego miungu ya zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ila sambi, nokuyalalila uvigele kumgongo vilozo vao. Ila kamba huwagela kumgongo, disegeze twaga jangu mkitabu chuuwandike matwaga ga wanhu zako.” ");
INSERT INTO zajp_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","MNDEWA kamulongela Musa, “Munhu yoyose yanitendile vilozo iyo yondanidisegeze twaga jake mkitabu changu. ");
INSERT INTO zajp_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Sambi genda, walongoze wanhu mbaka hanhu hanikulongele, na msenga wangu wa kuulanga kokulongola, ila kipigiti chokwiza aho hondaniwasune wanhu wano sama ya vilozo vao.” ");
INSERT INTO zajp_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Avo MNDEWA kaugala utamu wihile ng'hani mwa wanhu, kwavija viwamswagize Haloni yatende nyago da mwanang'ombe. ");
INSERT INTO zajp_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","MNDEWA kamulongela Musa, “Segela hanhu hano, gweye hamoja na wanhu yuuwalavile muisi ya Misili, na uchole kuisi iniwaduilile kuwagwaa Ablaham, Isaka, na Yakobo, ahaja viniwalongele kamba nowagwelela ng'holo zao isi ino. ");
INSERT INTO zajp_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nomulagiza msenga wangu wa kuulanga yawalongole, na nie nowawinga Wakanaani, Waamoli, Wahiti, Wapelizi, Wahivi, na Wayebusi. ");
INSERT INTO zajp_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Gendeni muisi ili na lutuba na ugoli. Ila nie sichola hamoja na mweye, kwavija nihachola na mweye, nowabananga mnzila, mana mweye mwa wanhu muli na singo ndala.” ");
INSERT INTO zajp_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Wanhu viwahulike mbuli zino zihile, wasonga kona giogio na haduhu munhu yaihambile. ");
INSERT INTO zajp_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Kwavija MNDEWA kakala yamulongele Musa, “Walongele Waislaeli, ‘Mweye mwa wanhu muli na singo ndala. Kamba nihacholile na mweye, mkipigiti kiguhi nihawabanange. Avo segezeni mahamba genu, giladi nilamule kija chondaniwatende.’ ” ");
INSERT INTO zajp_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Avo Waislaeli wavula mahamba gao haja Hadigongo da Holebu. ");
INSERT INTO zajp_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa kaisola ihema na kuiwamba kutali kidogo hanze ya ing'hambi na kaikema hema ya kuiting'hanila. Na munhu yoyose yalondile kutambika kalondigwa yalawe yachole kuihema ya kuiting'hanila, ikalile hanze ya ing'hambi. ");
INSERT INTO zajp_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Na mazua gose Musa viyakalile yochola kuihema ya kuiting'hanila, wanhu wose wenuka na kwima hanhu ha kwingilila mzihema zao. Wamulola Musa mbaka viyengile muihema ya kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musa viyeshile kwingila muihema ya kuiting'hanila, wingu dilingile na nguzo dihumuluka na kukala hanhu ha kwingilila muihema ya kuiting'hanila kipigiti MNDEWA viyakalile yolonga na Musa. ");
INSERT INTO zajp_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Mazua gose wanhu viwajonile idiwingu dilingile na nguzo dimile hanhu ha kwingilila muihema ya kuiting'hanila, wanhu wose wenuka na kuinamila, kila munhu hanhu hake ha kwingilila muihema yake. ");
INSERT INTO zajp_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","MNDEWA kalonga na Musa kihanga kwa kihanga, kamba vija munhu na mbwigaake. Abaho Musa kabwela mng'hambi. Ila mmhale yakalile yomtaza Musa, yokemigwa Yoshua mwana wa Nuni, kasigala muihema ya kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa kamulongela MNDEWA, “Lola, gweye kunilongela niwalongoze wanhu wano, na kunilongela kamba kunitanga nie mkunitambula na twaga. Kunogelwa na nie, ila hunilongele ija yondaumtume yachole hamoja na nie. ");
INSERT INTO zajp_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kamba kweli gweye kunogelwa na nie, nifundize nzila zako, giladi nie nikutange goya na nigendelele kukunogeza. Na sambiuisemwe kamba wano wanhu zako.” ");
INSERT INTO zajp_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","MNDEWA kalonga, “Nie mwenyego nochola hamoja na gweye, na nie nokugwelela gweye mhumulo.” ");
INSERT INTO zajp_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa kamulongela MNDEWA, “Kamba gweye huchola na tweye, sambiutulave hanhu hano. ");
INSERT INTO zajp_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Wanhu wovitangaze kamba gweye kunogelwa na nie hamoja na wanhu zako kamba hucholile hamoja na tweye? Kinhu chaki kiyagwe chondakitutende nie hamoja na wanhu zako sambituilinge na wanhu wayagwe muisi?” ");
INSERT INTO zajp_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","MNDEWA kamulongela Musa, “Nokitenda kila kinhu chuunipulile, kwavija ninogelwa na gweye na nikutanga mkukutambula na twaga jako.” ");
INSERT INTO zajp_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa kalonga, “Nokuyalalila, nilagusile yenzi yako.” ");
INSERT INTO zajp_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","MNDEWA kalonga, “Nokutenda wone unozi wangu, na nokulongela kinaganaga kamba YEHOVA dijo twaga jangu, na nomtendela ganogile na kumonela bazi munhu yoyose inimsagule. ");
INSERT INTO zajp_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ila hudaha kuchona kihanga changu, kwavija haduhu munhu yondayanyone nie abaho yawe mgima. ");
INSERT INTO zajp_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Lola, kuna hanhu behi na nie aho baho haulondigwa kwima uchana ya idibwe. ");
INSERT INTO zajp_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Na yenzi yangu vondaibite, gweye nokwika mmhango ya idibwe na kukugubika na mkono wangu mbaka vondanibite. ");
INSERT INTO zajp_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Abaho nousegeza mkono wangu, na gweye kowona mgongo wangu, ila huchona kihanga changu.” ");
INSERT INTO zajp_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","MNDEWA kamulongela Musa, “Songola mbamha mbili za mabwe kamba zija za ichanduso, na nie nokwandika mbuli zikalile mzimbamha za ichanduso zuuzibenile. ");
INSERT INTO zajp_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Mayo imitondo uisasale, ukwele uchana hainhembeti ya Idigongo da Sinai uiting'hane na nie. ");
INSERT INTO zajp_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Sambiukwele na munhu yoyose, na sambiyoneke munhu yoyose hanhu hohose mdigongo, na haduhu ng'hondolo ama ng'ombe yondayachungigwe hasi ya idigongo.” ");
INSERT INTO zajp_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Musa kasongola mbamha mbili za mabwe kamba zija za ichanduso, na imitondo ng'hani kakwela Idigongo da Sinai, kamba MNDEWA viyamulagize, kuno yazipapile zimbamha mbili za mabwe mmakono gake. ");
INSERT INTO zajp_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","MNDEWA kahumuluka hasi mdiwingu na kwima hamoja na Musa, na kudipeta twaga jake dikemigwa YEHOVA. ");
INSERT INTO zajp_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Abaho MNDEWA kabita haulongozi wa Musa, kalonga, “Nie iyo YEHOVA! MNDEWA! Mulungu mwene bazi na mwene ngekewa, nilibule lusango lwa himahima, nimemile noge dilekile kuhuha, na kuwabule uzenzeleganye. ");
INSERT INTO zajp_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Nogendelela kudilagusa noge jangu dilekile kuhuha ha maalufu ga milelo, nowagela kumgongo waja wali wavu na waja wahonyele na watendile vilozo, ila nowasuna awo woneke kuwa wavu na siwatagusa hewo weiyeka ila hamoja na wana zao na wana wa wana zao, mbaka mulelo wa ikadatu na mulelo wa ikane.” ");
INSERT INTO zajp_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Hima Musa kafugama mavindi kainamila mbaka hasi, na kutambika. ");
INSERT INTO zajp_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Musa kalonga, “Mndewa, kamba kweli kunogelwa na nie, nokuyalalila uchole hamoja na tweye. Wanhu wano wana singo ndala, ila tugele kumgongo wiho wetu na vilozo vetu utubokele, tweye twa wanhu zako mwenyego.” ");
INSERT INTO zajp_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Abaho MNDEWA kamulongela Musa, “Notenda lagano jangu hamoja na Waislaeli. Haulongozi wao notenda mizonza hainatendeka hanhu hohose muulumwengu na muundewa wowose. Wanhu wose awo uukala hagatigati yao wozona sang'hano ng'hulu zondanitende, kwavija notenda mbuli ya mkanganyo sama yako.” ");
INSERT INTO zajp_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Gagogeni gaja ganiwalagiza lelo. Lola, nowawinga haulongozi wenu Waamoli, Wakanaani, Wahiti, Wapelizi, Wahivi, na Wayebusi. ");
INSERT INTO zajp_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Mteganye, sambimtende lagano hamoja na wanhu wa isi imuicholela, kamba muhatenda avo, yowa mtego kumwenu. ");
INSERT INTO zajp_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ila uvibomole vilingo vao va kulavila nhosa, uibene miguzo yao ya mibwe yowoitambikila, na uzikanhe nguzo zao zowomtambikila mulungu wao wa kitwanzi yokemigwa Ashela. ");
INSERT INTO zajp_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Sambiumtambikile mulungu iyagwe yoyose, kwavija nie, MNDEWA, nikemigwa wivu, nie iyo Mulungu mwene wivu. ");
INSERT INTO zajp_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Mteganye sambimtende lagano jojose hamoja na wanhu wokala muisi hiyo, kwavija kipigiti wahaitambikila miungu yao ya kimhazi na kuilavila nhosa, wowagoneka na mweye muilumbe na hewo na kuja mandia gowowalavila nhosa miungu yao. ");
INSERT INTO zajp_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Wanenu wa kimbigalo wowasola wandele zao, na wandele wano woitambikila miungu yao ya kimhazi, vivija wowaswagiza na wanenu waitambikile miungu ya kimhazi ya watwanzi zao. ");
INSERT INTO zajp_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Sambiutende minyago ya chuma na kuitambikila. ");
INSERT INTO zajp_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Tendeni Lusona lwa Mikate Ilibule Mela. Mmazua saba dieni mikate ilibule mela, kamba vija viniwalagize. Tenda lusona luno mkipigiti cha mulenge wa Abibu, kwavija hiwo uwo mulenge umulawile muisi ya Misili. ");
INSERT INTO zajp_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Wanenu wose waudele wa kimbigalo na wana wose waudele wa kimbigalo wa wang'onyo zenu wa kufuga wowa wangu nie. ");
INSERT INTO zajp_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Mkombole mwana wa udele wa mhunda mkumulihila mwanang'hondolo, ila kamba humkombole, m'bene singo yake. Wakombole wana wenu wose wa udele wa kimbigalo. “Munhu sambiyeze haulongozi wangu bila kinhu. ");
INSERT INTO zajp_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Mazua sita sang'hanikeni, ila zua da saba humuleni, hata mkipigiti cha kulima ama mkipigiti cha kuhuna, humuleni. ");
INSERT INTO zajp_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Tendeni Lusona lwa Kuhuna kipigiti cha kusonga kuhuna vakuja va ichanduso va ngano zenu, na tendeni Lusona lwa Vizewe kipigiti cha msimu wa kumambukiza kuhuna vakuja venu. ");
INSERT INTO zajp_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Mianza midatu kila mulao wambigalo wose weze kunitambikila nie, MNDEWA, Mulungu wa Islaeli. ");
INSERT INTO zajp_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Nie nogawinga madale ga wanhu gasegele muisi yenu na kuzongeza mbaka zenu. Haduhu munhu yondayaisulukile isi yenu kipigiti vondamchole kunitambikila nie, MNDEWA, Mulungu wenu, mianza ino midatu ya kila mulao. ");
INSERT INTO zajp_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Sambimunilavile nhosa ya mulopa wa wang'onyo wachinjigwe hamoja na mikate igeligwe mela. Sambimsigaze nyama ya nhosa Mulusona lwa Pasaka mbaka imitondo. ");
INSERT INTO zajp_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Vakuja vinogile ng'hani va malimbuko va mgunda wako uvigale kung'anda yangu nie, MNDEWA Mulungu wako. “Sambiumtogose mwanamenhe mmatombo ga mamaake.” ");
INSERT INTO zajp_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","MNDEWA kamulongela Musa, “Wandike mbuli zino zose zinikulongele, mzimbuli zino notenda lagano na gweye hamoja na Waislaeli wose.” ");
INSERT INTO zajp_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa kakala hakigongo hamoja na MNDEWA mazua malongo mane misi na kilo, kipigiti chose hadile mandia na hang'wile mazi. Kakala yokwandika mbuli za lagano mzimbamha, azo zikalile ndagizi longo dimwe. ");
INSERT INTO zajp_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa viyakalile yohumuluka Mdigongo da Sinai kuno yapapile zija zimbamha mbili za lagano mmakono gake, havitangile kamba kihanga chake kikala kinang'hazika kwavija kakala yalongile na MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Haloni na Waislaeli wose viwakiwene kihanga cha Musa kinang'hazika, wadumba kumkwenhukila. ");
INSERT INTO zajp_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ila Musa kawakema, avo Haloni na vilangizi wose wa wanhu wamkwenhukila, na Musa kalonga na hewo. ");
INSERT INTO zajp_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Abaho Waislaeli wose wamkwenhukila, na heyo kawagwelela malagizo gose gayamgwelele MNDEWA kipigiti viyakalile Mdigongo da Sinai. ");
INSERT INTO zajp_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa viyamambukize kulonga na hewo, kakigubika kihanga chake na kiziweziwe. ");
INSERT INTO zajp_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Kila kipigiti Musa viyakalile yokwingila mdihema da kuiting'hanila kulonga na MNDEWA, kakivula ikiziweziwe mbaka viyalawile hanze. Na kipigiti viyalawile hanze, kawalongela Waislaeli kila kinhu MNDEWA kiyamulongele yakilonge. ");
INSERT INTO zajp_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Waislaeli wachona kihanga chake vukikalile kinang'hazika. Abaho Musa kakivala kabili ikiziweziwe mkihanga chake mbaka viyengile kabili kulonga na MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa kawakema Waislaeli wose hamoja na kuwalongela, “Zino zizo ndagizi MNDEWA ziyawalagize mzitende. ");
INSERT INTO zajp_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Sang'hanikeni mmazua sita, ila zua da saba diwe zua ding'alile kumwenu, Zua da Mhumulo dikigwe na MNDEWA. Munhu yoyose yosang'hanika sang'hano yoyose mdizua dino kolondigwa yakomigwe. ");
INSERT INTO zajp_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Hata moto sambiubwinhigwe mkae zenu Mdizua da Mhumulo.” ");
INSERT INTO zajp_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa kawalongela wanhu wose wa Islaeli, kalonga, “Kino kicho MNDEWA kiyalagize. ");
INSERT INTO zajp_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Soleni nhosa mkamulavile MNDEWA kulawa m'vinhu vumulinavo. Kila munhu yali na moyo wa kulava, yamulavile MNDEWA nhosa ya zahabu, madini ga feza, na shaba, ");
INSERT INTO zajp_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","nyuzi za buluu, zambalau, na ndung'hu, kitani inogile, na mijusu ya menhe, ");
INSERT INTO zajp_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ng'hwembe za songolomi wa ng'hondolo zisindikigwe na langi ndung'hu, ng'hwembe zinogile, mbamha za m'biki wa mjoholo, ");
INSERT INTO zajp_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","mavuta ga mzaituni ga kwika m'viwenge, vilungilo sama ya kulungila mavuta ga mzaituni ga kubakala na sama ya ubane unung'hila goya, ");
INSERT INTO zajp_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","mabwe gakemigwe shohamu, na mabwe gayagwe ga hela bwando ga kuhambila mkizibao cha Mkulu wa Wakulu Wose wa Nhambiko na mkifuko cha mmhambaga. ");
INSERT INTO zajp_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Magalu wose wali mmwanza wenu wolondigwa weze kutenda kila kinhu kiyalagize MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Watende hema da kuiting'hanila hamoja na ngubiko yake na ngubiko yake ya kunze, ving'hwangwazi vake, felemu zake, boliti zake, nguzo zake, vikalilo vake, ");
INSERT INTO zajp_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Sanduku da Lagano hamoja na fimbo zake za kudipapila, ngubiko yake, guo da kudikikiwizila, ");
INSERT INTO zajp_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","meza hamoja na fimbo zake za kuipapila na via vake vose, na imikate ilavigwe nhosa ha Mulungu, ");
INSERT INTO zajp_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","kiguzo cha kwikila viwenge sama ya mulangaza hamoja na via vake, viwenge vake, na mavuta sama ya mulangaza, ");
INSERT INTO zajp_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","kilingo cha kufushila ubane hamoja na fimbo zake, mavuta ga kubakala, ubane unung'hila goya, na guo da kutungika hanhu ha kwingilila mdihema, ");
INSERT INTO zajp_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","kilingo cha kulukuzila nhosa hamoja na lwavu lwake lwa shaba, fimbo zake na via vake vose, teleko da shaba hamoja na kikalilo chake, ");
INSERT INTO zajp_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","miguo ya kutungika mviwambaza va idikonhi da idihema da kuiting'hanila, nguzo zake, na vikalilo vake, guo sama ya kutungika hanhu ha kwingilila mdikonhi, ");
INSERT INTO zajp_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","vigingi va idihema, na vigingi va idikonhi hamoja na nzabi zake, ");
INSERT INTO zajp_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","vivalo vilukigwe goya sama ya kusang'hanikila mdihema da kuiting'hanila, vivalo ving'alile sama ya Haloni, mkulu wa nhambiko, na vivalo sama ya wanage, vondawavale kipigiti wahasang'hana sang'hano ya ukulu wa nhambiko.” ");
INSERT INTO zajp_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Avo Waislaeli wose wasegela haulongozi wa Musa, ");
INSERT INTO zajp_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","na wanhu wose wanogelwe mmoyo na wanhu wose wanogelwe mziloho weza na kugala nhosa zao ha MNDEWA sama ya kudizenga idihema da kuiting'hanila, sama ya sang'hano yake yose, na sama ya vivalo ving'alile. ");
INSERT INTO zajp_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Wanhu wanogelwe kulava, watwanzi na wambigalo wose, weza na kugala nhosa zao za zahabu ha MNDEWA, vipini, heleni, vitindi, na mikufu na kuvinula haulongozi wa MNDEWA. ");
INSERT INTO zajp_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Kila munhu yakalile na nyuzi za buluu, zambalau, ama ndung'hu, ama kitani inogile, ama mijusu ya menhe, ama ng'hwembe za songolomi wa ng'hondolo zisindikigwe na langi ndung'hu, ama ng'hwembe zinogile, kavigala. ");
INSERT INTO zajp_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Na wose wakalile na madini ga feza ama shaba wavilava nhosa ha MNDEWA, na awo wose wakalile na mbamha za m'biki wa mjoholo wazigala giladi wazitendele muisang'hano ija. ");
INSERT INTO zajp_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Watwanzi wose wakalile magalu wa kushona na kogosa na makono gao wagala vija viwakalile wokogosa. Wagala nyuzi za buluu, zambalau, na ndung'hu hamoja na kitani inogile. ");
INSERT INTO zajp_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Watwanzi wose wanogelwe na wakalile magalu kogosa, wogosa mijusu ya menhe. ");
INSERT INTO zajp_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Wakulu wa wanhu wagala mabwe gakemigwe shohamu na mabwe ga hela bwando ga kugela mkizibao cha Mkulu wa Wakulu Wose wa Nhambiko na mkifuko cha mmhambaga. ");
INSERT INTO zajp_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Vivija wagala vilungilo na mavuta ga mzaituni sama ya kwika m'viwenge, na vilungilo sama ya kulungila mmavuta ga kubakala na sama ya ubane unung'hila goya. ");
INSERT INTO zajp_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Avo Waislaeli wose watwanzi kwa wambigalo wakalile wosulukila kusang'hana sang'hano iyawagwelele MNDEWA kubitila Musa wagala nhosa zao ha MNDEWA kulawa mmioyo yao. ");
INSERT INTO zajp_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Abaho Musa kawalongela Waislaeli, “Loleni, MNDEWA kamsagula Bezaleli, mwana wa Uli, mzukulu wa Huli, kulawa mumtala wa Yuda. ");
INSERT INTO zajp_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Kammemeza Loho wa Mulungu na kumgwelela udaho, nzewele, na ilimu ya ufundi wa namna zose, ");
INSERT INTO zajp_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","wa kusongola ulembo muna zizahabu, madini ga feza, na shaba na ufundi mkulu ng'hani, ");
INSERT INTO zajp_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","mkugakanha mabwe ga hela bwando na kugeka mvifelemu na mkusongola mibiki hamoja na namna zose za ufundi. ");
INSERT INTO zajp_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","MNDEWA kawagwelela Bezaleli na Oholiabu, mwana wa Ahisamaki, kulawa mumtala wa Dani, udaho wa kuwafundiza wayagwe. ");
INSERT INTO zajp_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Kawatenda kuwa magalu wa kutenda sang'hano zose za kila namna ya ufundi, wavumbula vinhu, wahambaji wa nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile, na walukaji wakalile magalu wa kuluka namna zose za vinhu.” ");
INSERT INTO zajp_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Abaho Musa kagendelela kulonga “Avo Bezaleli, Oholiabu, na magalu wose Mulungu iyawagwelele udaho na ujuzi wa kutanga kila kinhu kilondigwa msang'hano ya kudizenga idihema da kuiting'hanila wolondigwa watende kila kinhu kamba MNDEWA viyalagize.” ");
INSERT INTO zajp_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Abaho Musa kawakema Bezaleli na Oholiabu na magalu wose MNDEWA iyawagwelele udaho, awo wanogelwe kwiza kusang'hanika. ");
INSERT INTO zajp_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Musa kawagwelela vinhu vose vilavigwe nhosa na Waislaeli sama ya kudizenga idihema da kuiting'hanila. Na kulawa mmioyo yao, wanhu wagendelela kugala nhosa kila imitondo. ");
INSERT INTO zajp_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Abaho magalu wose wakalile wosang'hana sang'hano zose za kudizenga idihema da kuiting'hanila waleka sang'hano zao weza ha Musa ");
INSERT INTO zajp_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","na kumulongela, “Wanhu walava vinhu kubanza vinhu vilondigwa muisang'hano yaatulagize MNDEWA tuitende.” ");
INSERT INTO zajp_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Abaho Musa kalagiza na kuzeneza mbuli zino mng'hambi, yolonga, “Haduhu mbigalo ama mtwanzi yolondigwa kugendelela kulava sama ya idihema da kuiting'hanila.” Avo wanhu waleka kulava vinhu sama ya uzenzi wa idihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Kwavija vija visangigwe vikala vibanzilize kumambukiza sang'hano yose. ");
INSERT INTO zajp_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Magalu wose, wakalile mmwanza wa wanhu wakalile wosang'hanika, waditenda idihema da kuiting'hanila na miguo longo dimwe ya kitani inogile isokotigwe, na nyuzi za buluu, zambalau, na ndung'hu, na dihambigwa na muhambaji na ulembo wa vinhu vilingile na Makelubi. ");
INSERT INTO zajp_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Utali wa kila guo ukala meta 12, na ugazi wa kila guo ukala meta 2. Miguo yose ikala na utali umwe na ugazi umwe. ");
INSERT INTO zajp_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Miguo mitano kailumba hamoja, na miguo mitano iyagwe kailumba hamoja. ");
INSERT INTO zajp_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Katenda matanzi ga buluu mulugigo lwa guo da kunze mmwanza wa ija imiguo ya ichanduso iyailumbile hamoja, na vivija katenda matanzi mulugigo lwa guo da kunze mmwanza wa ija imiguo iyagwe iyailumbile hamoja. ");
INSERT INTO zajp_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Katenda matanzi malongo matano mulugigo lwa idiguo da ichanduso, na katenda matanzi malongo matano mulugigo lwa idiguo dikalile mmiguo mitano iyagwe. Gamatanzi gakala gakihindukile kila tanzi dimwe na miage. ");
INSERT INTO zajp_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Katenda ving'hwangwazi malongo matano va zahabu, abaho kailumba imiguo hamoja na iving'hwangwazi giladi idihema da kuiting'hanila diwe kinhu kimwe. ");
INSERT INTO zajp_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Vivija katenda miguo longo dimwe na imwe itendigwe na mijusu ya menhe sama ya kugubikila idihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Utali wa kila guo dimwe ukala meta 13, na ugazi wa kila guo dimwe ukala meta 2. Miguo yose longo dimwe na imwe ikala na utali umwe na ugazi umwe. ");
INSERT INTO zajp_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Kailumba miguo mitano hamoja, na kailumba miguo sita iyagwe hamoja ");
INSERT INTO zajp_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Katenda matanzi malongo matano mulugigo lwa idiguo da ikimambukizo da imiguo mitano ya ichanduso na matanzi malongo matano mulugigo lwa idiguo da ichanduso da imiguo sita iyagwe. ");
INSERT INTO zajp_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Vivija katenda ving'hwangwazi malongo matano va shaba va kuvigela muna gamatanzi giladi yailumbe hamoja imiguo ya idihema da kuiting'hanila giladi iwe ngubiko imwe. ");
INSERT INTO zajp_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Katenda ngubiko sama ya kugubikila idihema da kuiting'hanila, ngubiko ya ng'hwembe za songolomi wa ng'hondolo isindikigwe na langi ndung'hu, na ngubiko ya kunze ya ng'hwembe zinogile. ");
INSERT INTO zajp_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Abaho katenda felemu za wima za m'biki wa mjoholo sama ya idihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Kila felemu ikala na wimo wa meta 4 na ugazi wa sentimeta 66. ");
INSERT INTO zajp_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Kila felemu ikala na vizingiti uchana na hasi na kuitenda imihimili mibili kuwa kinhu kimwe, na kila felemu ikala na migulu mibili ingizigwe mvikalilo vikalile hasi ya izifelemu, katenda vino mzifelemu zose za idihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Katenda felemu za idihema da kuiting'hanila, felemu malongo mabili ng'ambu ya kusi ya idihema da kuiting'hanila ");
INSERT INTO zajp_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","na katenda vikalilo malongo mane va madini ga feza hasi ya izifelemu malongo mabili, vikalilo vibili hasi ya ifelemu ya ichanduso mmigulu yake mibili, na vikalilo vibili hasi ya felemu iyagwe mmigulu yake mibili. ");
INSERT INTO zajp_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ng'ambu ya kaskazi ya idihema da kuiting'hanila, katenda felemu malongo mabili, ");
INSERT INTO zajp_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","na vikalilo malongo mane va madini ga feza, vikalilo vibili hasi ya kila felemu ");
INSERT INTO zajp_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Kuchugu cha idihema da kuiting'hanila, ng'ambu ya uswelo wa zua, katenda felemu sita. ");
INSERT INTO zajp_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Katenda felemu mbili mzimhembe za idihema da kuiting'hanila zili ng'ambu ya kuchugu. ");
INSERT INTO zajp_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Felemu zino za mzimhembe zolondigwa ziibande songela hasi mbaka uchana, na uchana zifungigwe na kitindi kimwe, zose mbili zolondigwa ziilinge. ");
INSERT INTO zajp_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Avo kiwambaza cha kuchugu kikala na felemu nane hamoja na vikalilo va madini ga feza, vikalilo longo dimwe na sita, vikalilo vibili hasi ya kila felemu. ");
INSERT INTO zajp_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Katenda boliti za m'biki wa mjoholo, boliti tano sama ya izifelemu za ng'ambu imwe ya idihema da kuiting'hanila, ");
INSERT INTO zajp_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","na boliti tano sama ya izifelemu za ng'ambu iyagwe ya idihema da kuiting'hanila, na boliti tano sama ya izifelemu za ng'ambu ya kuchugu ya idihema da kuiting'hanila, ng'ambu ya uswelo wa zua. ");
INSERT INTO zajp_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Katenda boliti ya hagatigati, kaibitiza hagatigati ya izifelemu kulawa ng'ambu imwe mbaka ng'ambu iyagwe. ");
INSERT INTO zajp_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Kazigubikiza izifelemu na zahabu, na kazitendela vitindi va zahabu vigoge iziboliti, na kazigubikiza iziboliti na zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Katenda guo na nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe, na dihambigwa na ulembo wa vinhu vilingile na Makelubi. ");
INSERT INTO zajp_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Katenda nguzo nne za m'biki wa mjoholo sama ya idiguo na kuzigubikiza na zahabu, ving'hwangwalingo vake vikala va zahabu, na kazisimika m'vikalilo vine va madini ga feza. ");
INSERT INTO zajp_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Katenda guo da kutungika hanhu ha kwingilila mdihema da kuiting'hanila na nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe, na dihambigwa na muhambaji, ");
INSERT INTO zajp_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","na katenda nguzo tano hamoja na ving'hwangwalingo vake, kazigubikiza sota zake na kabali zake na zahabu, ila vikalilo vake vitano vikala va shaba. ");
INSERT INTO zajp_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaleli katenda Sanduku da Lagano na mbamha za mjoholo dili na utali wa sentimeta 110, ugazi wa sentimeta 66, na wimo wa sentimeta 66. ");
INSERT INTO zajp_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Kadigubikiza na zahabu ing'alile mgati na kunze, na katenda lugigo lwa zahabu uchana kuzunguluka idisanduku. ");
INSERT INTO zajp_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Kaditendela vitindi vine va zahabu, na kuvigwasika mmigulu yake mine, vitindi vibili ng'ambu imwe na vitindi vibili ng'ambu iyagwe. ");
INSERT INTO zajp_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Abaho katenda fimbo za m'biki wa mjoholo, na kuzigubikiza na zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Kazigela izifimbo m'vitindi vili mzimbavu za idisanduku, sama ya kudipapila idisanduku. ");
INSERT INTO zajp_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Abaho katenda ngubiko ya idisanduku na zahabu ing'alile. Ikala na utali wa sentimeta 110 na ugazi wa sentimeta 66. ");
INSERT INTO zajp_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Abaho kavitenda vinyago vilingile na Makelubi wabili wa zahabu mkusana na nyundo, kaweka kuzingwazo mbili za ingubiko ya idisanduku. ");
INSERT INTO zajp_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Kamtenda Kelubi imwe kuingwazo imwe na Kelubi iyagwe kuingwazo iyagwe, wawa mkidanga kimwe na ingubiko ya idisanduku, kawatenda iwamakelubi muna izingwazo zake mbili. ");
INSERT INTO zajp_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Makelubi wazigolosa mbawa zao uchana, na kuikikiwiza ingubiko ya idisanduku na izimbawa zao. Makelubi wailola, na vihanga vao viinamilila ingubiko ya idisanduku. ");
INSERT INTO zajp_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Katenda meza ya mbamha za mjoholo. Ikala na utali wa sentimeta 88, ugazi wa sentimeta 44, na wimo wa sentimeta 66. ");
INSERT INTO zajp_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Kaigubikiza na zahabu ing'alile na kaitendela lugigo lwa zahabu ing'alile uchana kuizunguluka imeza. ");
INSERT INTO zajp_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Kaizungulusila mkungo uli na ugazi wa milimeta 75, abaho keka lugigo lwa zahabu kuzunguluka umkungo. ");
INSERT INTO zajp_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Katenda vitindi vine va zahabu kavigwasika muna zimhembe nne za imeza, mmigulu yake mine. ");
INSERT INTO zajp_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Vija ivitindi vigogile zifimbo za kupapila imeza vikala behi na umkungo. ");
INSERT INTO zajp_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Katenda fimbo za m'biki wa mjoholo za kupapila imeza, na kazigubikiza na zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Katenda via va zahabu ing'alile va kwika muna imeza, vyano na vikasi sama ya kufushila ubane na majagi na mikungu sama ya nhosa ya divai. ");
INSERT INTO zajp_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Katenda kiguzo cha zahabu ing'alile cha kwikila viwenge. Kikalilo chake na kiguzo chake wavitenda na zahabu isanigwe na nyundo. Vikasi vake, vifundo vake, na malua gake vikala kinhu kimwe na ikiguzo. ");
INSERT INTO zajp_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Matambi sita gakala kuzing'ambu mbili za ikiguzo, matambi madatu ng'ambu imwe na matambi madatu ng'ambu iyagwe. ");
INSERT INTO zajp_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Vikasi vilingile kamba malua ga mulozi, kila kikasi kimwe na kifundo chake na malua gake, vidatu vikala mditambi dimwe, na vidatu vikala mditambi diyagwe. Na matambi gose sita gakala mkiguzo cha kwikila viwenge. ");
INSERT INTO zajp_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Uchana ya ikiguzo cha kwikila viwenge kukala na vikasi vine vilingile kamba malua ga mulozi, kila kikasi na vifundo vake na malua gake. ");
INSERT INTO zajp_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Kifundo cha ichanduso kikala hasi ya igamatambi mabili ga ichanduso gali mkiguzo cha kwikila viwenge, kifundo cha ikabili kikala hasi ya igamatambi mabili ga ikabili, na kifundo cha ikadatu kikala hasi ya igamatambi mabili ga ikadatu. Mheta ya matambi gose gakala sita. ");
INSERT INTO zajp_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ivifundo, igamatambi na ikiguzo cha kwikila viwenge visanigwa kulawa mkidanga kimwe cha zahabu ing'alile. ");
INSERT INTO zajp_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Katenda viwenge saba, mibato yake, na visahani vake, vose vikala va zahabu ing'alile. ");
INSERT INTO zajp_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ikiguzo cha kwikila iviwenge na via vandakane navo vikala vitendigwe na zahabu ing'alile ikalile na kilo 35. ");
INSERT INTO zajp_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Kasola m'biki wa mjoholo katenda kilingo cha kufushila ubane, ng'ambu zose zikala zikiilinga, kikala na utali wa sentimeta 45, ugazi wa sentimeta 45, na wimo wa sentimeta 90. Mhembe zake zikalile mzimhembe zake nne zisongoligwa kulawa mdibiki dimwe ditendile ikilingo cha kufushila ubane. ");
INSERT INTO zajp_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Uchana ya ikilingo cha kufushila ubane, ng'ambu zake zose, na izimhembe zake zose kazigubikiza na zahabu ing'alile, na katenda lugigo lwa zahabu mkukizunguluka. ");
INSERT INTO zajp_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Kakitendela vitindi vibili va zahabu va kugogela izifimbo za kukipapila, hasi ya ulugigo lwake, mzing'ambu zake mbili. ");
INSERT INTO zajp_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Katenda fimbo za m'biki wa mjoholo, na kuzigubikiza na zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Vivija katenda mavuta gang'alile ga kubakala na ubane ung'alile unung'hila goya, kamba galu wa kutenda mavuta ga kunung'hila viyatendaga. ");
INSERT INTO zajp_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bezaleli kazenga kilingo cha kulukuzila nhosa cha m'biki wa mjoholo, utali wake na ugazi wake ukala ukiilinga. Utali wake ukala meta 2.2, ugazi wake ukala meta 2.2, na wimo wake ukala meta 1.3. ");
INSERT INTO zajp_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Katenda mhembe kuna zimhembe nne za ikilingo cha kulukuzila nhosa. Zimhembe zisongoligwa kulawa mkigogo cha idibiki ditendile ikilingo cha kulukuzila nhosa, na kazigubikiza na shaba. ");
INSERT INTO zajp_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Kavitenda via vose va ikilingo cha kulukuzila nhosa, nongo za kwikila mitozi, makulega, mikungu, uma, na vizolelo va kuzolela moto. Via vino vose vikala vitendigwe na shaba. ");
INSERT INTO zajp_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Katenda lwavu lwa shaba na kulwika hasi ya ulugigo lwake, lwenza lwa ikilingo cha kulukuzila nhosa kulawa hasi. ");
INSERT INTO zajp_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Katenda vitindi vine na kuvigwasika hana izimhembe nne za ulwavu lwa shaba sama ya kwingizila izifimbo za kupapila ikilingo cha kulukuzila nhosa. ");
INSERT INTO zajp_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Katenda fimbo za m'biki wa mjoholo, na kuzigubikiza na shaba. ");
INSERT INTO zajp_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Kazisomeka izifimbo m'vitindi vili mumgwazo wa ikilingo cha kulukuzila nhosa, na izifimbo zilawila ng'ambu zose mbili za ikilingo, na izifimbo ziwa vipapilo va ikilingo. Kakitenda ikilingo na mbamha za m'biki wa mjoholo, na kikala kamba sanduku dipongole. ");
INSERT INTO zajp_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Katenda teleko da shaba na kikalilo chake cha shaba kulawa m'viwowo vikalile va watwanzi wakalile wosang'hanika hanhu ha kwingilila mdihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Abaho katenda konhi da idihema da kuiting'hanila. Ng'ambu ya kusi ya idikonhi katungika miguo itendigwe na kitani inogile isokotigwe, ikalile na utali wa meta 44, ");
INSERT INTO zajp_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","nguzo zake malongo mabili na vikalilo vake malongo mabili vikala va shaba, ila iving'hwangwalingo va izinguzo na kabali zake zikala za madini ga feza. ");
INSERT INTO zajp_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Vivija ng'ambu ya kaskazi ya idikonhi katungika miguo ikalile na utali wa meta 44, nguzo zake malongo mabili na vikalilo vake malongo mabili vikala va shaba, ila iving'hwangwalingo va izinguzo na kabali zake zikala za madini ga feza. ");
INSERT INTO zajp_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ng'ambu ya uswelo wa zua kukala na miguo ikalile na utali wa meta 22, hamoja na nguzo longo dimwe na vikalilo longo dimwe. Ving'hwangwalingo na kabali zake zikala za madini ga feza. ");
INSERT INTO zajp_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ng'ambu ya ulawilo wa zua, kukalile na hanhu ha kwingilila, vivija kukala na ugazi wa meta 22. ");
INSERT INTO zajp_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Miguo ili na utali wa meta 6.6 ikala ng'ambu imwe, hamoja na nguzo ndatu na vikalilo vidatu, ");
INSERT INTO zajp_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","na miguo ili na utali wa meta 6.6 ikala ng'ambu iyagwe, hamoja na nguzo ndatu na vikalilo vidatu. ");
INSERT INTO zajp_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Miguo yose izunguluke idikonhi ikala ya kitani inogile isokotigwe. ");
INSERT INTO zajp_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ivikalilo va izinguzo vikala va shaba, ila iving'hwangwalingo na izikabali za izinguzo zikala za madini ga feza, na izisota za izinguzo zigubikizwa na madini ga feza. Avo nguzo zose za idikonhi zifungigwa na kabali za madini ga feza. ");
INSERT INTO zajp_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Watenda guo da kutungika hanhu ha kwingilila mdikonhi na nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe, na kuhambigwa na muhambaji. Dikala na utali wa meta 9 na wimo wa meta 7.5, na dilinga na miguo iyagwe izunguluke idikonhi. ");
INSERT INTO zajp_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Dikala ditungikwe mzinguzo nne zikalile m'vikalilo vine va shaba, ving'hwangwalingo vake na kabali zake zikala za madini ga feza, na izisota za izinguzo zigubikizwa na madini ga feza. ");
INSERT INTO zajp_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Vigingi vose va idihema da kuiting'hanila na vigingi vose vizunguluke idikonhi vikala va shaba. ");
INSERT INTO zajp_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Kino kicho kiasi cha vinhu vizengile hema da kuiting'hanila, hema ajo mgati yake kukalile na mbamha mbili za mabwe zikalile zandikigwe Ndagizi Longo Dimwe. Vinhu vino vilagizwa na Musa, na Walawi wavitenda wolongozwa na Isamali, mwana wa mkulu wa nhambiko Haloni. ");
INSERT INTO zajp_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaleli, mwana wa Uli, mzukulu wa Huli, wa mtala wa Yuda, katenda gaja gose MNDEWA gayamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Kakala yotazigwa na Oholiabu, mwana wa Ahisamaki, kulawa mtala wa Dani, yakalile galu wa kusongola, kuvumbula namna ya kutenda vinhu, na kufuma na nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile. ");
INSERT INTO zajp_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Zahabu zose zizengele hema da kuiting'hanila, kulawa mzizahabu zilavigwe nhosa mkwinuligwa ha MNDEWA, zikala na tani 1, ipimigwe kulingana na kipimilo kili mdihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Madini ga feza gasangigwe na ididale da wanhu wakalile wapetigwe gakala na uzami wa tani 3.43, kulingana na kipimilo kili mdihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Kiasi kino kilinga na mheta ya wanhu wose wapetigwe, kila munhu kaliha kiasi kilingile, kulingana na kipimilo kili mdihema da kuiting'hanila. Kukala na wambigalo alufu mia sita na ndatu na mia tano na malongo matano (603,550) wali na milao malongo mabili na kugendelela wakalile wapetigwe mkipigiti cha kupetigwa. ");
INSERT INTO zajp_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Tani 3.4 za madini ga feza zizenga vikalilo mia va idihema da kuiting'hanila na vikalilo va idiguo da kudikikiwizila Idisanduku da Lagano, kila kikalilo kimwe kizengigwa na kilo malongo madatu na nne za madini ga feza. ");
INSERT INTO zajp_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Na kilo malongo madatu za madini ga feza zisigale, katenda ving'hwangwalingo va izinguzo, kazigubikiza sota zake, na kuzitendela kabali. ");
INSERT INTO zajp_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Vivija wanhu walava nhosa ya shaba kilo alufu mbili na mia nne malongo mabili na tano (2,425), ");
INSERT INTO zajp_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","na shaba ino watenda vikalilo va nguzo za hanhu ha kwingilila mdihema da kuiting'hanila, na ikilingo cha kulukuzila nhosa, hamoja na lwavu lwake lwa shaba, na via vose va ikilingo cha kulukuzila nhosa, ");
INSERT INTO zajp_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","vivija watenda vikalilo va nguzo zinulize imiguo dizunguluke idikonhi, vikalilo va nguzo zinulize imiguo ya hanhu ha kwingilila mdikonhi, hamoja na ivigingi vose va idihema da kuiting'hanila na idikonhi. ");
INSERT INTO zajp_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Watenda vivalo vilukigwe na nyuzi za buluu, zambalau, na ndung'hu sama ya kusang'hanikila mdihema da kuiting'hanila. Vivija watenda vivalo ving'alile sama ya Haloni, kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Bezaleli katenda kizibao na nyuzi za zahabu, nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe. ");
INSERT INTO zajp_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Waisana izahabu na nyundo na kuwa vibamha vibanhibanhi abaho waitenda kuwa nyuzi na kuzibandikiza na nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe. ");
INSERT INTO zajp_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Wakitendela ikizibao mikandala mibili ya mmaega na kuifunga mzing'ambu mbili za ikizibao ng'ambu ya kuulongozi na ng'ambu ya kuchugu. ");
INSERT INTO zajp_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Lukambala luhambigwe lutendigwe na vinhu vivija vitendile ikizibao, nyuzi za zahabu, nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe, lolondigwa lushonelwe mkizibao kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Wandika matwaga ga wana wa Islaeli longo dimwe na wabili uchana ya igamabwe mabili gakemigwe shohamu kamba vija msongola dibwe da hela bwando viyosongola utango. Abaho kagagela mzifelemu zilukigwe na nyuzi za zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Kagabandikiza mmikandala ya mmaega ya ikizibao, kuwa mabwe ga ng'humbukila ha Mulungu sama ya wana wa Islaeli, kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Katenda kifuko cha mmhambaga cha kuvala Mkulu wa Wakulu Wose wa Nhambiko na ufundi mkulu. Kakitenda na vinhu vivija vitendile ikizibao, nyuzi za zahabu, nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe. ");
INSERT INTO zajp_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kakikunza mwanza umwe, na katenda utali wake na ugazi wake uilinge, utali wake ukala sentimeta 22 na ugazi wake ukala sentimeta 22. ");
INSERT INTO zajp_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Abaho uchana yake keka minhongo mine ya mabwe ga hela bwando. Mumnhongo wa ichanduso, keka mabwe ga akiki, yakuti manjano, na bahalamani. ");
INSERT INTO zajp_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Mumnhongo wa ikabili, keka mabwe ga zumalidi, yakuti samawi, na alimasi. ");
INSERT INTO zajp_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Mumnhongo wa ikadatu, keka mabwe ga yasinto, akiki ndung'hu, na ametisto. ");
INSERT INTO zajp_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Mumnhongo wa ikane, keka mabwe ga zabalajadi, shohamu, na yasipi. Mabwe gano gose gageligwa mzifelemu za nyuzi za zahabu. ");
INSERT INTO zajp_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Kukala na mabwe longo dimwe na mabili kamba vigali matwaga ga wana wa Islaeli. Mabwe gano gakala kamba utango wao, kila dibwe dimwe disongoligwa mtala umwe wa wana wa Islaeli. ");
INSERT INTO zajp_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Wakitendela ikifuko cha mmhambaga mikufu ya zahabu ing'alile, isokotigwe kamba nzabi. ");
INSERT INTO zajp_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Watenda felemu mbili zilukigwe na nyuzi za zahabu na vitindi vibili va zahabu, na kuvigwasika ivitindi vibili mzimhembe mbili za uchana za ikifuko cha mmhambaga. ");
INSERT INTO zajp_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Waigwasika imikufu mibili ya zahabu m'vitindi vibili vili mzimhembe za uchana ya ikifuko cha mmhambaga, ");
INSERT INTO zajp_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","sota mbili ziyagwe za imikufu ya zahabu zikalile zifudikwe mzifelemu mbili za nyuzi za zahabu, zifudikwa mmikandala ya mmaega ya ikizibao ng'ambu ya kuulongozi. ");
INSERT INTO zajp_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Abaho watenda vitindi vibili va zahabu, na kuvigwasika mzimhembe mbili za hasi ya ikifuko cha mmhambaga, mulugigo lwake lwa mgati behi na ikizibao. ");
INSERT INTO zajp_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Watenda vitindi vibili viyagwe va zahabu, wavigwasika hasi ya imikandala mibili ya mmaega kuulongozi wa ikizibao, behi na ulugigo uchana ya ulukambala luhambigwe lwa ikizibao. ");
INSERT INTO zajp_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Wavifudika ivitindi va ikifuko cha mmhambaga kuna ivitindi va ikizibao na nzabi za buluu, giladi ikifuko cha mmhambaga kikale uchana ya ulukambala luhambigwe lwa ikizibao, na kija ikifuko cha mmhambaga hakilondigwa kilegele kulawa mkizibao, kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Bezaleli katenda kanzu ilukigwe na nyuzi za langi ya buluu ya kuvalila mgati ya ikizibao, ");
INSERT INTO zajp_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","na watenda zonzo hagatigati sama ya kwingizila ditwi. Weka lugigo lulukigwe kuzunguluka idizonzo, giladi ikanzu sambiidegeke. ");
INSERT INTO zajp_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Mulugigo lwa hasi ya idikanzu watenda makomamanga ga langi ya buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe. ");
INSERT INTO zajp_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Watenda mbugi za zahabu ing'alile, na kuzika hagatigati ya igamakomamanga kuzunguluka ulugigo lwa hasi lwa idikanzu. ");
INSERT INTO zajp_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Zimbugi na igamakomamanga vizunguluka ulugigo lwa hasi ya ikanzu yondaivaligwe na mkulu wa nhambiko kipigiti cha kumsang'hanikila MNDEWA, kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Watenda mashati galukigwe na nyuzi za kitani inogile sama ya Haloni na wanage, ");
INSERT INTO zajp_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","kilemba cha kitani inogile, kofia ya kitani inogile, kaputula za kitani inogile isokotigwe, ");
INSERT INTO zajp_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","na lukumbulu lwa nyuzi za buluu, zambalau, na ndung'hu, na kitani inogile isokotigwe, luhambigwe na muhambaji, kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Watenda kidiwala kibanhibanhi king'alile cha zahabu ing'alile, uchana yake wakisongola nyandiko kamba viwasongolaga utango na kuchandika mbuli zino, “YANG'ALILE HA MNDEWA.” ");
INSERT INTO zajp_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Wakifudika ikidiwala kibanhibanhi na nzabi ya langi ya buluu kuulongozi wa ikilemba, kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Avo sang'hano zose za idihema da kuiting'hanila zikala zimalile. Waislaeli watenda kila kinhu kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Abaho wamgalila Musa idihema da kuiting'hanila hamoja na via vake vose, ving'hwangwazi vake, felemu zake, boliti zake, nguzo zake, vikalilo vake, ");
INSERT INTO zajp_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ngubiko ya ng'hwembe za songolomi wa ng'hondolo zisindikigwe na langi ndung'hu, ngubiko ya ng'hwembe zinogile, guo da kukikiwizila Hanhu Hang'alile Ng'hani kulawa Hanhu Hang'alile, ");
INSERT INTO zajp_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Sanduku da Lagano hamoja na fimbo zake za kudipapila, ngubiko yake, ");
INSERT INTO zajp_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","meza hamoja na via vake vose, imikate ilavigwe nhosa ha Mulungu, ");
INSERT INTO zajp_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","kiguzo cha zahabu ing'alile cha kwikila viwenge hamoja na viwenge vake, via vake vose, na mavuta ga iviwenge, ");
INSERT INTO zajp_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","kilingo cha zahabu cha kufushila ubane, mavuta ga kubakala, ubane unung'hila goya, na guo da kutungika hanhu ha kwingilila mdihema, ");
INSERT INTO zajp_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","kilingo cha shaba cha kulukuzila nhosa hamoja na lwavu lwake lwa shaba, fimbo zake, via vake vose, teleko da shaba hamoja na kikalilo chake, ");
INSERT INTO zajp_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","miguo sama ya viwambaza va idikonhi da idihema da kuiting'hanila hamoja na nguzo zake na vikalilo vake, guo sama ya kutungika hanhu ha kwingilila mdikonhi, nzabi zake, vigingi va idikonhi da idihema, via vose va sang'hano za mdihema da kuiting'hanila, ");
INSERT INTO zajp_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","na vivalo vilukigwe goya sama ya kusang'hanikila mdihema da kuiting'hanila, vivalo ving'alile sama ya Haloni, mkulu wa nhambiko, na vivalo sama ya wanage, vondawavale kipigiti wahasang'hana sang'hano ya ukulu wa nhambiko. ");
INSERT INTO zajp_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Waislaeli watenda sang'hano zose kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa viyaikagule ija isang'hano na kona kamba watenda kamba vija MNDEWA viyalagize, kawamoteza. ");
INSERT INTO zajp_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Abaho MNDEWA kamulongela Musa, ");
INSERT INTO zajp_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Udisimike idihema da kuiting'hanila mdizua da ichanduso da mulenge wa ichanduso. ");
INSERT INTO zajp_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Udingize mgati Idisanduku da Lagano na udikikiwize idisanduku na idiguo. ");
INSERT INTO zajp_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Wingize mgati imeza na uvike via vake uchana yake. Vivija wingize mgati ikiguzo cha kwikila viwenge, na uvike iviwenge uchana yake. ");
INSERT INTO zajp_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Wingize ikilingo cha zahabu cha kufushila ubane haulongozi wa Idisanduku da Lagano, na utungike guo hanhu ha kwingilila mdihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Kike ikilingo cha kulukuzila nhosa haulongozi wa hanhu ha kwingilila mdihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Wike teleko hagatigati ya idihema da kuiting'hanila na ikilingo cha kulukuzila nhosa, abaho udimemekeze mazi. ");
INSERT INTO zajp_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Utende konhi kuzunguluka idihema da kuiting'hanila, abaho utungike guo hanhu ha kwingilila mdikonhi. ");
INSERT INTO zajp_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Usole mavuta ga kubakala ugabakaze mdihema da kuiting'hanila na vinhu vose vili mgati yake, giladi uvibagule sama yangu nie. ");
INSERT INTO zajp_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Usole mavuta ga kubakala ugabakaze mkilingo cha kulukuzila nhosa na via vake vose, giladi ukibagule sama yangu nie avo ikilingo chong'ala ng'hani. ");
INSERT INTO zajp_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Usole mavuta ga kubakala ugabakaze mditeleko na kikalilo chake, giladi udibagule sama yangu nie. ");
INSERT INTO zajp_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Wagale Haloni na wanage hanhu ha kwingilila mdihema da kuiting'hanila, abaho uwanave na mazi. ");
INSERT INTO zajp_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Abaho m'vaze Haloni vivalo ving'alile, m'bake mavuta na um'bagule sama yangu nie, giladi yanisang'hanikile nie kamba mkulu wa nhambiko. ");
INSERT INTO zajp_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Vivija uwagale wanage na uwavaze mashati gao. ");
INSERT INTO zajp_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Abaho uwabake mavuta kamba vondaum'bake tataao, giladi wanisang'hanikile nie kamba wakulu wa nhambiko. Kubakigwa mavuta kumwao kowatenda wawe wakulu wa nhambiko hewo na milelo yao yondaize.” ");
INSERT INTO zajp_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa katenda kila kinhu kamba MNDEWA viyamulagize. ");
INSERT INTO zajp_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Avo, mdizua da ichanduso da mulenge wa ichanduso wa mulao wa ikabili songela viwalawile Misili, wadisimika idihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa kadisimika idihema da kuiting'hanila mkwika vikalilo vake, mkuzinula felemu zake, mkuzigela boliti zake, na kuzisimika nguzo zake. ");
INSERT INTO zajp_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Abaho kaikunzula imiguo ya kitani inogile isokotigwe na kudigubikiza idihema da kuiting'hanila uchana, na kwika ngubiko iyagwe itendigwe na ng'hwembe za songolomi wa ng'hondolo zisindikigwe na langi ndung'hu uchana yake na ngubiko ya kunze ya ng'hwembe zinogile, kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Abaho kasola mbamha mbili za mabwe na kuzigela muna Idisanduku da Lagano. Kazigela izifimbo za kupapila muna ivitindi va idisanduku na kuika ingubiko ya idisanduku uchana yake. ");
INSERT INTO zajp_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Abaho kadika Idisanduku da Lagano mgati ya idihema da kuiting'hanila na kutungika guo hagatigati ya Hanhu Hang'alile na Hanhu Hang'alile Ng'hani giladi yadikikiwize idisanduku, kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Keka meza mgati ya idihema da kuiting'hanila Hanhu Hang'alile, ng'ambu ya kaskazi, hanze ya idiguo, ");
INSERT INTO zajp_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","na kwandika imikate uchana yake haulongozi wa MNDEWA, kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Keka ikiguzo cha kwikila viwenge mgati ya idihema da kuiting'hanila kikiilole na imeza ng'ambu ya kusi ya idihema da kuiting'hanila, ");
INSERT INTO zajp_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","na kavika iviwenge haulongozi wa MNDEWA, kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Musa keka ikilingo cha zahabu cha kufushila ubane mgati ya idihema da kuiting'hanila haulongozi wa idiguo, ");
INSERT INTO zajp_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","na kufusha ubane unung'hila goya uchana yake, kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Abaho katungika guo hanhu ha kwingilila mdihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Keka ikilingo cha kulukuzila nhosa hanhu ha kwingilila mdihema da kuiting'hanila, na kulava nhosa ya kulukuza na nhosa za usage uchana yake, kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Keka teleko hagatigati ya idihema da kuiting'hanila na ikilingo cha kulukuzila nhosa na kudimemeza mazi mgati yake sama ya kuinavila. ");
INSERT INTO zajp_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa, Haloni, na wanage wanava magulu na makono gao na mazi gakalile mditeleko dija ");
INSERT INTO zajp_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","kipigiti chochose viwengile mdihema da kuiting'hanila ama viwalondile kukikwenhukila ikilingo cha kulukuzila nhosa, kamba MNDEWA viyamulagize Musa. ");
INSERT INTO zajp_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Abaho Musa katenda konhi kuzunguluka idihema da kuiting'hanila na ikilingo cha kulukuzila nhosa na kutungika guo hanhu ha kwingilila mdikonhi. Avo Musa kamambukiza sang'hano zose. ");
INSERT INTO zajp_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Abaho wingu didigubika idihema da kuiting'hanila, na yenzi ya MNDEWA idimemeza idihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa hadahile kwingila mdihema da kuiting'hanila kwavija idiwingu dikala uchana yake, na yenzi ya MNDEWA idimemeza idihema da kuiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Kipigiti dija idiwingu vudinuligwe uchana kulawa mdihema da kuiting'hanila, Waislaeli wagendelela na mwanza wodikweleleza idiwingu, ");
INSERT INTO zajp_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ila kamba idiwingu hadinuligwe uchana, wasigala bahaja hawakalile mbaka idiwingu vudinuligwe uchana. ");
INSERT INTO zajp_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Idiwingu da MNDEWA dikala uchana ya idihema da kuiting'hanila mkipigiti cha imisi, na moto ukala mdiwingu mkipigiti cha ikilo, hameso ga wanhu wose wa ng'anda ya Islaeli mkipigiti chose cha mwanza wao.");
INSERT INTO zajp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Uno uwo msululu wa wahenga wa Yesu Kilisto, mwana wa Daudi, mwana wa Ablaham. ");
INSERT INTO zajp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ablaham kamulela Isaka, Isaka kamulela Yakobo, Yakobo kamulela Yuda na ndugu zake. ");
INSERT INTO zajp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda kamulela Pelesi na Zela, mamaao kakala Tamali, Pelesi kamulela Heziloni, Heziloni kamulela Alamu, ");
INSERT INTO zajp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamu kamulela Aminadabu, Aminadabu kamulela Nashoni, Nashoni kamulela Salimoni, ");
INSERT INTO zajp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni kamulela Boazi, mamaake kakala Lahabu, Boazi kamulela Obedi, mamaake kakala Lusi, Obedi kamulela Yese, ");
INSERT INTO zajp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese kamulela Mndewa Daudi. Daudi kamulela Selemani na mtwanzi yakalile mwehe wa Ulia, ");
INSERT INTO zajp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Selemani kamulela Lehoboamu, Lehoboamu kamulela Abiya, Abiya kamulela Asafu, ");
INSERT INTO zajp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asafu kamulela Yehoshafati, Yehoshafati kamulela Yolamu, Yolamu kamulela Uzia, ");
INSERT INTO zajp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia kamulela Yotamu, Yotamu kamulela Ahazi, Ahazi kamulela Hezekia, ");
INSERT INTO zajp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia kamulela Manase, Manase kamulela Amoni, Amoni kamulela Yosia, ");
INSERT INTO zajp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia kamulela Yekonia na ndugu zake, kipigiti kija viwahamizigwe kuchola Babeli. ");
INSERT INTO zajp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kulawa kipigiti cha kuhamizigwa kuchola Babeli, Yekonia kamulela Shelitieli, Shelitieli kamulela Zelubabeli, ");
INSERT INTO zajp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabeli kamulela Abiudi, Abiudi kamulela Eliakimu, Eliakimu kamulela Azoli, ");
INSERT INTO zajp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoli kamulela Sadoki, Sadoki kamulela Akimu, Akimu kamulela Eliudi, ");
INSERT INTO zajp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi kamulela Eliazali, Eliazali kamulela Matani, Matani kamulela Yakobo, ");
INSERT INTO zajp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo kamulela Usufu, yakalile mbigalo wa Maliamu mamaake Yesu yakemigwe Kilisto. ");
INSERT INTO zajp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Avo kukala na milelo longo dimwe na mine kulawa Ablaham mbaka Daudi, na milelo longo dimwe na mine kulawa Daudi mbaka kipigiti viwahamizigwe kuchola Babeli, na milelo longo dimwe na mine kulawa uhamizo wa kuchola Babeli mbaka mvumbuka ya Kilisto. ");
INSERT INTO zajp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Vino vivo mvumbuka ya Yesu Kilisto viikalile. Mamaake, yakemigwe Maliamu, kakala mkasano wa Usufu, ila viwakalile hawanakala hamoja, kaiyona kana inda mkubitila mhiko za Loho wa Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kwavija Usufu, mkasano wake, kakala munhu yalibule uzenzeleganye, na halondile kumgela kinyala hameso ga wanhu, avo kagelegeza kumuleka kinyele. ");
INSERT INTO zajp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ila viyakalile yogelegeza gano, msenga wa Mndewa wa kuulanga kamulawila muna inzozi na kulonga, “Usufu, Mwana wa Daudi, sambiudumbe kumsola Maliamu yawe mtwanzi wako. Kwavija kapata inda mkubitila mhiko za Loho wa Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kolela mwana mbigalo, na gweye komkema twaga jake Yesu, kwavija kowakombola wanhu zake kulawa m'vilozo vao.” ");
INSERT INTO zajp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gano gose galawilila giladi gavikile gaja gayalongile Mndewa kubitila muhokozi, ");
INSERT INTO zajp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mhambe kopata inda na kolela mwana mbigalo, na twaga jake kokemigwa Imanueli.” Nhegulo yake “Mulungu ka hamoja na tweye.” ");
INSERT INTO zajp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Usufu viyalamuke kulawa muutulo, katenda kamba msenga wa Mndewa wa kuulanga viyamulagize, avo kamsola mkasano wake Maliamu. ");
INSERT INTO zajp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ila hamkwenhukile mbaka viyamulelile mwana mbigalo. Na heyo kamkema twaga jake Yesu. ");
INSERT INTO zajp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu kavumbuka mkiwambo cha Betelehemu muisi ya Yudea, mkipigiti cha Mndewa Helode Mkulu. Na wanhu wali na ilimu ya nhondo kulawa haulawilo wa zua weza Yelusalemu, ");
INSERT INTO zajp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","wauza, “Kahalihi ayo yavumbuke giladi yawe mndewa wa Wayahudi? Kwavija tuyona nhondo yake haulawilo wa zua, avo twiza kumtambikila.” ");
INSERT INTO zajp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mndewa Helode viyahulike vino, kagaya ng'hani mmoyo, heyo hamoja na wanhu wose wa Yelusalemu. ");
INSERT INTO zajp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kawakema wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa, kawauza, “Halihi hondayaleligwe Kilisto?” ");
INSERT INTO zajp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wamwidika, “Mkiwambo cha Betelehemu muisi ya Yudea, kwavija vino vivo yandikigwe na muhokozi, ");
INSERT INTO zajp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Na gweye, Betelehemu, uli muisi ya Yuda, huli mdodo hagatigati ya watawala wa isi ya Yuda, kwavija kulawa kumwako kolawilila mtawala yondayawalongoze wanhu zangu wa Islaeli.’ ” ");
INSERT INTO zajp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Abaho, Helode kawakema kinyele waja iwanhu wali na ilimu ya nhondo wamulongele kipigiti kija inhondo viyoneke. ");
INSERT INTO zajp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kawatuma wachole Betelehemu, yolonga, “Gendeni mkaziuzagize goya mbuli za mwana hiyo, na muhamona mnongele, giladi na nie nichole kumtambikila.” ");
INSERT INTO zajp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Viwamambukize kumtegeleza mndewa, wachola, na ija inhondo iwakalile wayonile haulawilo wa dizua, iwalongola mbaka viimile hanhu hayakalile imwana. ");
INSERT INTO zajp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Viwaiwene inhondo, wadeng'helela ng'hani. ");
INSERT INTO zajp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Viwengile mng'anda, wamona imwana hamoja na mamaake Maliamu, wafugama mavindi na kumtambikila. Abaho, wafungula masanduku gao na kumgwelela nhunza za zahabu, ubane, na manemane. ");
INSERT INTO zajp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mulungu kawazuma mnzozi kamba sambiwambwelele Helode. Avo wabweleganya muisi yao mkubitila nzila iyagwe. ");
INSERT INTO zajp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Viwacholile, msenga wa Mndewa wa kuulanga kamulawila Usufu mnzozi kalonga, “Lamuka, msole imwana na mamaake mkimbilile Misili. Kaleni hiko mbaka vondanikulongele, kwavija Helode kokwiza kumzahila imwana giladi yamkome.” ");
INSERT INTO zajp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Avo Usufu kenuka, kamsola imwana na mamaake ikilo iija, kachola Misili, ");
INSERT INTO zajp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ako kuyakalile mbaka Helode viyadanganhike. Giladi kamba gavikile gaja galongigwe na Mndewa kubitila muhokozi, “Nimkema Mwanangu kulawa Misili.” ");
INSERT INTO zajp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helode viyawene kamba kavwiziligwa na iwanhu wali na ilimu ya nhondo, kagevuzika ng'hani. Kalagiza kamba wana wose wa kimbigalo wa kiwambo cha Betelehemu na ng'ambu zake zose, wali na milao mibili kwiza hasi wakomigwe, songela viyalongeligwe na waja iwanhu wali na ilimu ya nhondo mmbuli za ija inhondo kipigiti viilawilile. ");
INSERT INTO zajp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Abaho, gavikila gaja galongigwe na muhokozi Yelemia, ");
INSERT INTO zajp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Dizwi dihulikwa ako Lama, kililo na giogio kulu. Laheli kowalilila wanage, halonda kuhembekezwa, kwavija wahaduhu.” ");
INSERT INTO zajp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mndewa Helode viyadanganhike, msenga wa Mndewa wa kuulanga kamulawila Usufu mnzozi ako Misili ");
INSERT INTO zajp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","kalonga, “Lamuka, msole imwana na mamaake, uchole muisi ya Islaeli, kwavija wose walondile kumkoma imwana wadanganhika.” ");
INSERT INTO zajp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Avo Usufu kenuka, kamsola imwana na mamaake, na kubwela muisi ya Islaeli. ");
INSERT INTO zajp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ila Usufu viyahulike kamba Alikelao iyo mtawala wa Yudea kasola hanhu ha tataake Mndewa Helode Mkulu, kadumba kuchola hiko. Na heyo viyazumigwe mnzozi, kanyelenhukila kuisi ya Galilaya. ");
INSERT INTO zajp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kachola, kakala mkiwambo kikemigwe Nazaleti, giladi gavikile gaja galongigwe na wahokozi, “Kokemigwa Mnazaleti.” ");
INSERT INTO zajp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mazua higo Yohana M'batiza keza, yowapetela wanhu mkiwala cha Yudea, ");
INSERT INTO zajp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","kalonga, “Lekeni vilozo venu, kwavija Undewa wa Kuulanga ukwenhuka!” ");
INSERT INTO zajp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kwavija Yohana iyo yalongigwe na muhokozi Isaya, viyalongile, “Munhu kenula dizwi muluwala, yolonga, ‘Itandeni nzila ya Mndewa, Mgoloseleni nzila zake!’ ” ");
INSERT INTO zajp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohana kavala guo ditendigwe na mijusu ya ngamia na lukumbulu lwa kwembe mchuno chake, na mandia gake gakala nzige na uki. ");
INSERT INTO zajp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Wanhu kulawa Yelusalemu, kulawa muisi yose ya Yudea na ng'ambu zose za Mdibonde da Yolodani, wamcholela. ");
INSERT INTO zajp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wavilonga vilozo vao haulongozi wa wanhu, na heyo kawabatiza muna Ulwanda lwa Yolodani. ");
INSERT INTO zajp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yohana viyawawene Mafalisayo na Masadukayo bwando womwizila giladi wabatizigwe, kawalongela, “Mweye wana wa nyoka! Yalihi yawazumile kulukimbila lusango lwa Mulungu londalwize? ");
INSERT INTO zajp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tendeni mbuli zilagusa kamba muleka vilozo venu. ");
INSERT INTO zajp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Sambimgelegeze kamba modaha kuikimbila nhaguso ya Mulungu mkulonga, ‘Ablaham iyo muhenga wetu.’ Nowalongela, Mulungu kodaha kusola mabwe gano na kumtendela lukolo Ablaham! ");
INSERT INTO zajp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nhemo ya hana gamasina ga imibiki, na kila m'biki uleka kulela mujo unogile wokanhigwa na kwasigwa muna umoto. ");
INSERT INTO zajp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nie nowabatiza mweye na mazi kulagusa kamba muleka vilozo venu, ila hachugu changu kokwiza yali na mhiko kubanza nie, nie silumbile hata kupapa ng'hwabasa zake. Heyo kowabatiza na Loho wa Mulungu na moto. ");
INSERT INTO zajp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Heyo kana kia chake mmakono cha kubetela, giladi yaikunzanye ngano yake kukano na mikumvi yaisome na moto hauzimikaga.” ");
INSERT INTO zajp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Abaho, Yesu keza kulawa Galilaya, kachola hana Ulwanda lwa Yolodani giladi yabatizigwe na Yohana. ");
INSERT INTO zajp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ila Yohana kageza kumgomesa, kalonga, “Nie nolondigwa kubatizigwa na gweye, na gweye kokwiza kumwangu?” ");
INSERT INTO zajp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ila Yesu kamwidika, “Leka iwe vino sambi, kwavija tolondigwa kutenda vino giladi kugavikiza gaja gose gayalagize Mulungu.” Avo Yohana katogola. ");
INSERT INTO zajp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bahaja Yesu viyabatizigwe, kalawa muna gamazi. Baho ulanga uvuguka, kamona Loho wa Mulungu yomuhumulukila yalingile kamba hua na kukala uchana yake. ");
INSERT INTO zajp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na dizwi kulawa kuulanga dilonga, “Ino iyo Mwanangu mnogelwa, ninogelwe nayo.” ");
INSERT INTO zajp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Abaho, Yesu kalongozwa na Loho wa Mulungu mbaka muluwala giladi yagezigwe na Mwenembago. ");
INSERT INTO zajp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Viyamambukize funga ya mazua malongo mane ikilo na imisi, Yesu kona nzala. ");
INSERT INTO zajp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Abaho, Mwenembago kamcholela kamgeza yomulongela, “Uhawa gweye iyo Mwana wa Mulungu, galongele mabwe gano gagaluke mikate.” ");
INSERT INTO zajp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ila Yesu kedika kalonga, “Yandikigwa Mzinyandiko Zing'alile, ‘Munhu hawa mgima sama ya mkate wiyeka, ila mkila mbuli ilawa mmulomo wa Mulungu.’ ” ");
INSERT INTO zajp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Abaho, Mwenembago kamsola Yesu mbaka Yelusalemu, Wambo Ding'alile, na kumwika hachana hana inhomboti ya Ing'anda ya Mulungu, ");
INSERT INTO zajp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","kamulongela, “Uhawa gweye iyo Mwana wa Mulungu, ibwanhe hasi, kwavija yandikigwa Mzinyandiko Zing'alile, ‘Mulungu kokulagizila wasenga zake wa kuulanga, wakudang'he mmakono gao, giladi mgulu wako sambiuikwale mdibwe.’ ” ");
INSERT INTO zajp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu kamwidika, “Vivija yandikigwa Mzinyandiko Zing'alile, ‘Sambiumgeze Mndewa Mulungu wako.’ ” ");
INSERT INTO zajp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Abaho, Mwenembago kamsola Yesu mbaka hana ikigongo kitali, kamulagusila ndewa zose za ulumwengu na yenzi zake. ");
INSERT INTO zajp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kamulongela, “Gano gose nokugwelela uhanifugamila mavindi na kunitambikila.” ");
INSERT INTO zajp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Abaho, Yesu kamulongela, “Goboka, Mwenembago! Kwavija yandikigwa Mzinyandiko Zing'alile, ‘Mtambikile Mndewa Mulungu wako na umsang'hanikile heyo yeiyeka!’ ” ");
INSERT INTO zajp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Abaho, Mwenembago kamuleka, na wasenga wa Mulungu wa kuulanga weza na kumsang'hanikila. ");
INSERT INTO zajp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Yesu viyahulike kamba Yohana kageligwa mkifungo, kachola kukiwambo cha Nazaleti muisi ya Galilaya. Kasegela Nazaleti, kachola kukala Kapenaumu, kiwambo kikalile behi na Dilamba da Galilaya, muisi za mitala ya Wazabuloni na Wanaftali, ");
INSERT INTO zajp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","giladi gavikile gaja galongigwe na muhokozi Isaya, ");
INSERT INTO zajp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Isi ya Zabuloni na isi ya Naftali, nzila ya kuchola m'bahali, mwambu uyagwe wa Ulwanda lwa Yolodani, Galilaya, isi ya Wamhazi! ");
INSERT INTO zajp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wanhu wokala mdiziza wona mulangaza mkulu. Na waja wose wokala muisi ya ziza da ifa, mulangaza uwamwemwesa.” ");
INSERT INTO zajp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Songela kipigiti kija Yesu kasonga kuwapetela wanhu yolonga, “Lekeni vilozo venu, kwavija Undewa wa Kuulanga ukwenhuka!” ");
INSERT INTO zajp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu viyakalile yotembela mumgwazo wa Idilamba da Galilaya, kawona wandugu wabili, Simoni yakemigwe Petulo na mdodo wake Endelea. Wakala wotanda nhando zao mdilamba, kwavija wakala waloa somba. ");
INSERT INTO zajp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu kawalongela, “Ng'holelezeni, na nie nowatenda muwe waloa wanhu.” ");
INSERT INTO zajp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bahaja wazileka nhando zao, wamkoleleza. ");
INSERT INTO zajp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Viyacholile haulongozi kidogo, kawona wandugu wabili wayagwe, Yakobo na mdodo wake Yohana, wanage Zebedayo, wakalile muna ingalawa hamoja na tataao Zebedayo, wozigongomanya nhando zao. Yesu kawakema, ");
INSERT INTO zajp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","na baho waileka ingalawa na tataao, wamkoleleza. ");
INSERT INTO zajp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu kachola kila hanhu m'viwambo va Galilaya, yofundiza muna zing'anda zao za nhambiko na kuupeta Usenga Unogile wa Undewa wa Mulungu, na kuwahonya wanhu wakalile na kila utamu na unyondenyonde. ");
INSERT INTO zajp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mbuli zake zenela muisi yose ya Silia. Wamgalila wanhu wose wakalile wokugula kila utamu, wakalile wokona vihile, wakalile na vinyamkela, wakalile na kisango, na wakalile waholole, na heyo kawahonya. ");
INSERT INTO zajp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dale kulu da wanhu dimkoleleza, wanhu kulawa Galilaya, kulawa kuviwambo longo dimwe vikemigwa Dekapoli, kulawa Yelusalemu, Yudea, na mwambu uyagwe wa Ulwanda lwa Yolodani. ");
INSERT INTO zajp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu viyadiwene didale da wanhu, kakwela hakigongo, kakala hasi. Wanahina zake wamcholela, ");
INSERT INTO zajp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","na heyo kasonga kuwafundiza. ");
INSERT INTO zajp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Wamota waja wakumbulu wa loho, kwavija Undewa wa Kuulanga uli wao! ");
INSERT INTO zajp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Wamota waja wose wali na giogio, kwavija wobwezigwa imioyo! ");
INSERT INTO zajp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wamota waja wali na mioyo iholile, kwavija woihala isi! ");
INSERT INTO zajp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wamota waja wose wali na nzala na ng'hilu ya kutenda ganogile, kwavija wokwigutizwa! ");
INSERT INTO zajp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wamota wali na bazi, kwavija wokonelwa bazi! ");
INSERT INTO zajp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wamota wali na mioyo ing'alile, kwavija womona Mulungu! ");
INSERT INTO zajp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wamota wagombelezi, kwavija wokemigwa wana wa Mulungu! ");
INSERT INTO zajp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Wamota awo wogazigwa sama ya kutenda ganogile, kwavija Undewa wa Kuulanga uli wao! ");
INSERT INTO zajp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mmota mweye haja wanhu wahawaliga, na kuwagaza, na kuwavwizila mbuli zose zihile sama yangu. ");
INSERT INTO zajp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Deng'heleleni na kutoa ng'henze, kwavija nhunza yenu yowa ng'hulu kuulanga. Kwavija vino vivo wagazigwe wahokozi wawalongole. ");
INSERT INTO zajp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mweye iwo munyu wa isi. Ila munyu uhagiza kilandu chake, vodahikaze kuutenda unoge kabili? Haunoga mkinhu chochose, ila wokwasigwa hanze na kubojagwa na wanhu. ");
INSERT INTO zajp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mweye iwo mulangaza wa ulumwengu mokoneka na wanhu wose, kamba viwodaha kuwona mulangaza wa wambo dizengigwe hakigongo. ");
INSERT INTO zajp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Haduhu munhu yobwinha kiwenge na kukigubika na kinongo. Ila kokika uchana hakingolobweda, giladi kimmwemwesele kila munhu yali mng'anda. ");
INSERT INTO zajp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Vivo na mweye, mulangaza wenu umwemwese haulongozi wa wanhu, giladi wone sang'hano zenu zinogile, na hewo wamuyenzi Tata wenu wa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Sambimgelegeze kamba niza kugatengula Malagizo ga Musa na mafundo ga wahokozi, ila kugavikiza. ");
INSERT INTO zajp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nowalongela ikweli, mbaka ulanga na isi vondavisegele, haduhu hata helufi imwe ndodo kulawa Mmalagizo ga Musa yondaisegezigwe mbaka mbuli zose zivikile. ");
INSERT INTO zajp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Avo, munhu yoyose yoleka kutenda ndagizi imwe ili ndodo, na kuwafundiza wanhu sambiwaitende, munhu iyo kokemigwa mdodo muna Undewa wa Kuulanga. Ila munhu yoyose yondayazitende ndagizi zino na kuzifundiza, munhu iyo kokemigwa mkulu muna Undewa wa Kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kwavija nowalongela, mbuli zenu zilibule uzenzeleganye zihaleka kuzibanza zija za Mafalisayo na wafundiza Malagizo ga Musa, hamdaha kwingila Muundewa wa Kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Muhulika kamba wanhu wa umwaka viwalongeligwe, ‘Sambiukome, na yoyose yondayatende avo kotagusigwa.’ ");
INSERT INTO zajp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ila nie nowalongela, munhu yoyose yomonela lusango ndugu yake kotagusigwa, na munhu yoyose yomuliga ndugu yake kolondigwa yagaligwe Kukitala Kikulu cha Isi ya Wayahudi, na munhu yoyose yolonga, ‘Gweye kwa m'bozi’ ka mdihekaheka da kwingila hana umoto wa kuzimu. ");
INSERT INTO zajp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Avo, kamba uhalonda kulava nhunza yako hana ikilingo cha kulavila nhosa, na kukumbukila kamba kuna mbuli na ndugu yako, ");
INSERT INTO zajp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ileke nhunza yako haulongozi wa ikilingo cha kulavila nhosa, tanhu genda mkailumbe na ndugu yako, abaho, leka ubwele uilave nhunza yako. ");
INSERT INTO zajp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ilumbe hima na munhu yokutagusa, kipigiti mng'hali mnzila mchola kukitala, giladi sambiyakugale ha mulamula, na mulamula yakugele mmakono ga wemilizi, na wemilizi wakugele mkifungo. ");
INSERT INTO zajp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nokulongela ikweli, hulawa himo mbaka ulihe deni jako jose. ");
INSERT INTO zajp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Muhulika kamba ilongwa, ‘Sambiutende ugoni.’ ");
INSERT INTO zajp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ila nie nowalongela, munhu yoyose yomulola mtwanzi mkumsulukila, kesha kutenda nayo ugoni mmoyo wake. ");
INSERT INTO zajp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Avo kamba siso jako da ukulume dokutenda utende vilozo, ding'ole ujase kutali nagwe! Vinoga kumwako kwagiza kipindi kimwe cha lukuli lwako kubanza lukuli lwako lose lwasigwe kuzimu. ");
INSERT INTO zajp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na kamba mkono wako wa ukulume wokutenda utende vilozo, ukanhe uwase kutali nagwe! Vinoga kumwako kwagiza kipindi kimwe cha lukuli lwako kubanza lukuli lwako lose luchole kuzimu. ");
INSERT INTO zajp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Vivija ilongigwa, ‘Munhu yoyose yomwasa mtwanzi wake, kolondigwa yamwandikile lupwilili lwa nyasa.’ ");
INSERT INTO zajp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ila nie nowalongela kamba, munhu yoyose yomwasa mtwanzi wake, ila tu sama ya kilamso cha ugoni, komtenda mtwanzi hiyo yawe mgoni, na munhu yoyose yomsola mtwanzi hiyo kotenda ugoni. ");
INSERT INTO zajp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Vivija muhulika kamba wanhu wa umwaka viwalongeligwe, ‘Sambiuiduile uvwizi ila ugoge kiduilo chako chuuiduile ha Mndewa.’ ");
INSERT INTO zajp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ila nie nowalongela, sambimuiduile kabisa. Sambimuiduilile ulanga, kwavija kicho kigoda cha undewa cha Mulungu, ");
INSERT INTO zajp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ama sambimuiduilile isi, kwavija kicho kigoda chake cha kwikila magulu gake, ama sambimuiduilile Yelusalemu, kwavija dijo wambo da Mndewa Mkulu. ");
INSERT INTO zajp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Vivija sambiuiduilile pala jako, kwavija hudaha kutenda hata luvili lwako lumwe kuwa luzelu ama lutitu. ");
INSERT INTO zajp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mbuli zenu ziwe ‘Ona’ kamba ihawa ‘Ona’ ama ‘Sio’ kamba ihawa ‘Sio.’ Chochose chondakibanze mbuli zino cholawa ha Mwenembago. ");
INSERT INTO zajp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Muhulika ilongigwa kamba, ‘Siso kwa siso, na zino kwa zino.’ ");
INSERT INTO zajp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ila nie nowalongela, sambium'bwelezele mtenda gehile. Munhu yahakutoa kanza da ukulume, muhindusile na diyagwe. ");
INSERT INTO zajp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na munhu yahakugala kukitala na kukusolela shati jako, vivija mulekele na koti jako. ");
INSERT INTO zajp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kamba munhu yahakushulutiza umpapile bahasha yake kilometa imwe, mpapile kilometa mbili. ");
INSERT INTO zajp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Munhu yondayakupule, mgwelele, na munhu yoyose yolonda umkalizi, sambiumuhindukile kisogo. ");
INSERT INTO zajp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Muhulika kamba ilongigwa, ‘Mnogele munhu wa habehi nagwe, na umwihile mdumuka wako.’ ");
INSERT INTO zajp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ila nie nowalongela, wanogele wadumuka zako na muwatambikile waja wose wowagaza, ");
INSERT INTO zajp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","giladi muwe wana wa Tata wenu wa kuulanga. Heyo yowamwemwesela zua jake wanhu wehile na wanogile, na yowatoela mvula wazenzeleganye na wanhu walibule uzenzeleganye. ");
INSERT INTO zajp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ihawa mowanogela wanhu wose waja wowonogela mweye, mopata nhunza yaki? Kwavija hata wawila kodi wotenda vivo! ");
INSERT INTO zajp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na kamba mowalamsa ndugu zenu weiyeka, kinhu chaki kikulu kimtenda kubanza wayagwe? Hata Wamhazi wotenda vivo! ");
INSERT INTO zajp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Avo, sambimuhungule hanhu kamba Tata wenu wa kuulanga viyalekile kuhungula hanhu! ");
INSERT INTO zajp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Iteganyeni, sambimtende mbuli zenu zinogile haulongozi wa wanhu giladi mwoneke na hewo, kwavija muhatenda hivo ham'bokela nhunza kulawa ha Tata wenu wa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Uhamwing'ha mkumbulu, sambiumulongele munhu yoyose mkutoa mhalati, kamba viwotenda videlenya muna zing'anda za nhambiko na mzinzila, giladi watogoligwe na wanhu. Nowalongela ikweli, wanhu hiwo wesha kubokela nhunza yao. ");
INSERT INTO zajp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ila uhamwing'ha mkumbulu, hata mkono wako wa ukumoso sambiuvitange kitendigwa na mkono wako wa ukulume, ");
INSERT INTO zajp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","avo nhunza yako yowa mkifiso. Abaho, Tataako, yolola kija kitendeke mkifiso, kokugwelela nhunza. ");
INSERT INTO zajp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Muhatambika, sambimuwe kamba videlenya! Kwavija hewo wonogelwa kutambika kuno wemile wima muna zing'anda za nhambiko na mzinzilamhanda, giladi woneke na wanhu. Nowalongela ikweli, wesha kubokela nhunza yao. ");
INSERT INTO zajp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ila uhatambika, ingila mdigati jako, hinda ulwivi, na tambika ha Tataako yali mkifiso. Abaho, Tataako, yolola kija kitendeke mkifiso, kokugwelela nhunza. ");
INSERT INTO zajp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Muhatambika, sambimulonge mbuli bwando zilibule nhegulo ha Mulungu, kamba viwotenda Wamhazi, kwavija wogelegeza kamba wohulikwa sama ya mbuli zao kuwa bwando. ");
INSERT INTO zajp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sambimuilinge nao, kwavija Tata wenu kovitanga chumulonda hata mng'hali hamunampula. ");
INSERT INTO zajp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Avo tambikeni kamba vino, ‘Tata wetu wa kuulanga, twaga jako diyenzigwe, ");
INSERT INTO zajp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Undewa wako wize, chuulonda kitendeke muisi kamba viili kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utugwelele mandia getu ga kila zua. ");
INSERT INTO zajp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Vigele kumgongo vilozo vetu, kamba tweye vituwagela kumgongo wanhu watutendile mbuli zihile. ");
INSERT INTO zajp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sambiutugele mkugezigwa, ila utukombole kulawa ha Mwenembago. Kwavija Undewa, na mhiko, na yenzi vako gweye gunge na gunge. Amina.’ ");
INSERT INTO zajp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kwavija kamba muhawagela kumgongo wanhu wawatendile mbuli zihile, vivija na Tata wenu wa kuulanga kovigela kumgongo vilozo venu. ");
INSERT INTO zajp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ila kamba hamuwagela kumgongo wanhu wawatendile mbuli zihile, vivija na Tata wenu wa kuulanga havigela kumgongo vilozo venu. ");
INSERT INTO zajp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Muhafunga, sambimnyunguale kamba viwotenda videlenya, kwavija wosinalika giladi watogolwe na wanhu kamba wafunga. Nowalongela ikweli, wesha kubokela nhunza yao. ");
INSERT INTO zajp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Uhafunga, suluza kihanga chako abaho bakaza mavuta pala jako, ");
INSERT INTO zajp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","giladi wanhu sambiwavitange kamba kufunga. Ila Tataako yoleka koneka, kovitanga. Na Tataako, yolola kija kitendeke mkifiso, kokugwelela nhunza. ");
INSERT INTO zajp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Sambimwiikile ngama muisi, aho hana ivimhungu na ng'hangaga hondawabanange, na wabavi wobena wokwingila na kwiba. ");
INSERT INTO zajp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ila ikeni ngama kuulanga, kulibule vimhungu na ng'hangaga wondawabanange, na wabavi hawabena na kwingila na kwiba. ");
INSERT INTO zajp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kwavija hanhu haili ngama yako, vivija na moyo wako baho hondaukale. ");
INSERT INTO zajp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Siso dijo kiwenge cha lukuli. Ihawa siso jako gima, lukuli lwako lose lomema mulangaza. ");
INSERT INTO zajp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ila siso jako dihabanangika, lukuli lwako lose lomema ziza. Na kamba mulangaza uli mgati yako wowa ziza, avo ziza hijo dowa kulu! ");
INSERT INTO zajp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Haduhu munhu yodaha kuwasang'hanikila wandewa wabili, kwavija komwihila imwe na kumnogela iyagwe, ama komnanahila imwe na kum'beza iyagwe. Hudaha kumsang'hanikila Mulungu kuno usang'hanikila mali. ");
INSERT INTO zajp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Avo nowalongela, sambimuigazile ugima wenu, kamba mje choni ama mung'we choni, ama ng'huli zenu, kamba m'vale choni. Ugima hauzamile kubanza mandia? Na lukuli haluzamile kubanza vivalo? ");
INSERT INTO zajp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Waloleni ndege wa kuulanga, hawahanda, hawahuna, na hawakunzanya mmakano, na Tata wenu wa kuulanga kowagwelela mandia. Avo, mweye mzama ng'hani kubanza ndege. ");
INSERT INTO zajp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yalihi mmwanza wenu mkuigaza yodaha kuiyongezela saa dimwe da ugima wake? ");
INSERT INTO zajp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Habali muigazila vivalo? Loleni malua ga kumgunda vigokula, hagasang'hana ama kuitendela vivalo. ");
INSERT INTO zajp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nowalongela kamba hata Selemani na yenzi yake yose havazigwe vinogile kamba dimwe da malua gano. ");
INSERT INTO zajp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ihawa kamba Mulungu kodivaza jani da kumgunda, dija lelo dabaho na mayo dokwasigwa muna umoto, vino heyo haleka kuwavaza vinogile mweye wanhu muli na nhamanila ndodo? ");
INSERT INTO zajp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Avo sambimuigaze mkulonga, ‘Toja choni?’ ama ‘Tong'wa choni?’ ama ‘Tovala choni?’ ");
INSERT INTO zajp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kwavija Wamhazi wovizahila vinhu vino vose, na Tata wenu wa kuulanga kovitanga kamba movilonda vinhu vino vose. ");
INSERT INTO zajp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ila uzahileni tanhu Undewa wa Mulungu na ndagizi zake, na vinhu vino vose mogweleligwa. ");
INSERT INTO zajp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Avo sambimuigazile mayo, kwavija mayo yowa na migayo yake yenyego. Mgayo wa zua dimwe wotosha kwa zua dimwe.” ");
INSERT INTO zajp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Sambimuwataguse wayagwe, na Mulungu hawatagusa mweye, ");
INSERT INTO zajp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","kwavija kamba vimuwatagusa wayagwe, vivo na Mulungu vondayawataguse mweye, na mhima iija yondamuwapimile wayagwe, iyo mhima yondampimilwe mweye. ");
INSERT INTO zajp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Habali ukilola kikupi msiso da ndugu yako, na huchona kibanzi kili msiso jako mwenyego? ");
INSERT INTO zajp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kodaha vilihi kumulongela ndugu yako, ‘Beta nikulave kikupi mdisiso jako,’ kuno gweye kuna kibanzi mdisiso jako? ");
INSERT INTO zajp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Gweye kidelenya! Songa tanhu kulava kibanzi msiso jako mwenyego, giladi udahe kulola goya, abaho, leka ulave kikupi msiso da ndugu yako. ");
INSERT INTO zajp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Sambimuwagwelele umbwa vinhu ving'alile, kamba muhatenda avo, wowahindukila na kuwadega, na sambimuwasile mitumbi lulu zenu, kamba muhatenda avo, wozibojaga. ");
INSERT INTO zajp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Puleni, mogweleligwa. Zahileni, movumbula. Toeni hodi, movugulilwa. ");
INSERT INTO zajp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kwavija yoyose yopula kogweleligwa, na yoyose yozahila kovumbula, na yoyose yotoa hodi kovugulilwa. ");
INSERT INTO zajp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ama yalihi mmwanza wenu, kamba mwanage yahampula mkate, komgwelela dibwe? ");
INSERT INTO zajp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ama yahampula somba, komgwelela nyoka? ");
INSERT INTO zajp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ihawa mweye mtenda mbuli zihile, movitanga kuwagwelela wanenu vinhu vinogile, avo, Tata wenu wa kuulanga kabanza ng'hani kuwagwelela vinhu vinogile waja wose wompula! ");
INSERT INTO zajp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Avo, chochose chumulonda mtendeligwe na wanhu, na mweye muwatendele vivo, kwavija gano gago mafundo ga Malagizo ga Musa na wahokozi. ");
INSERT INTO zajp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ingileni mkubitila lwivi lusisili, kwavija lwivi lugazi na zila gazi dilongoza kuubananzi, na wondawengile kubitila zila hijo wowa bwando. ");
INSERT INTO zajp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ila lwivi lusisili na inzila yakibabani ilongoza kuugima, na wanhu wondawayone wowa wadodo. ");
INSERT INTO zajp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Iteganyeni na wahokozi wa uvwizi, womwizileni kunze walingile kamba ng'hondolo, ila mgati mbwizi wodumbiza. ");
INSERT INTO zajp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mowatambula kubitila sang'hano zao. Vino wanhu wobawa zabibu muna imizomola, ama tini muna imingemba? ");
INSERT INTO zajp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Avo, m'biki unogile wolela mujo unogile, ila m'biki wihile wolela mujo wihile. ");
INSERT INTO zajp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","M'biki unogile haudaha kulela mujo wihile, na m'biki wihile haudaha kulela mujo unogile. ");
INSERT INTO zajp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na m'biki wowose uleka kulela mujo unogile wokanhigwa na kwasigwa muna umoto. ");
INSERT INTO zajp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Avo, mowatambula kubitila sang'hano zao. ");
INSERT INTO zajp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Sio kila munhu yonikema, ‘Mndewa, Mndewa’ yondayengile muna Uundewa wa Kuulanga, ila heyo yogatenda gaja goyolonda Tataangu wa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mdizua da nhaguso wanhu bwando wonilongela, ‘Mndewa, Mndewa! Hatuhokole mditwaga jako, na mditwaga jako tuwinga vinyamkela, na kutenda mizonza bwando?’ ");
INSERT INTO zajp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Abaho, nowalongela, ‘Siwatangile mweye. Segeleni hamwangu, mweye watenda gehile!’ ");
INSERT INTO zajp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Avo munhu yoyose yohulika mbuli zangu na kuzisang'hana kolinga na munhu yali na nzewele yozenga ng'anda yake uchana ya dibwe. ");
INSERT INTO zajp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mvula itoa, nyanda zitula, na beho dibuma na kuitoa ng'anda hiyo, ila haitulike, kwavija msingi wake uzengigwa mdidibwe. ");
INSERT INTO zajp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ila munhu yoyose yohulika mbuli zangu na kuleka kuzisang'hana kolinga na munhu m'bozi yozenga ng'anda yake mmisenga. ");
INSERT INTO zajp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mvula itoa, nyanda zitula, na beho dibuma na kuitoa ng'anda hiyo, nayo itulika, na nhulika yake ikala ihile ng'hani!” ");
INSERT INTO zajp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu viyamambukize kulonga gano, didale da wanhu dikanganya mafundo gake, ");
INSERT INTO zajp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kwavija hafundize kamba wafundiza zao wa Malagizo ga Musa, ila kafundiza kamba munhu yali na udaho. ");
INSERT INTO zajp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu viyahumuluke kulawa mkigongo, madale makulu ga wanhu gamkoleleza. ");
INSERT INTO zajp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na munhu yakalile na dikulu kamwizila na kamfugamila mavindi, kalonga, “Mndewa, uhalonda, kodaha kunihonya.” ");
INSERT INTO zajp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu kagolosa mkono wake, kamkwasa, kamulongela, “Nolonda, uhonyigwe!” Bahaja kahonyigwa utamu wake. ");
INSERT INTO zajp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Abaho, Yesu kamulongela, “Tegeleza, sambiumulongele munhu, ila genda ukailaguse ha mkulu wa nhambiko, abaho ukalave nhosa kamba viyalagize Musa, giladi wanhu wose watogole kamba kuhona.” ");
INSERT INTO zajp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu viyengile Kapenaumu, mkulu wa asikali mia wa Loma kamwizila, kamuyalalila ");
INSERT INTO zajp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","na kulonga, “Mndewa, mtumigwa wangu katambalala ukae, kaholola, mtamu ng'hani.” ");
INSERT INTO zajp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu kamulongela, “Nokwiza kumuhonya.” ");
INSERT INTO zajp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ija imkulu wa asikali mia wa Loma kamwidika, “Mndewa, nie silumbile gweye wingile mng'anda yangu, ila longa mbuli tu, na mtumigwa wangu kohona. ");
INSERT INTO zajp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kwavija nie mwenyego na munhu nikigwe hasi ya udaho, nna asikali hasi yangu. Nomulongela imwe, ‘Genda!’ na heyo kochola, na nomulongela iyagwe, ‘Izo!’ na heyo kokwiza. Na nomulongela mtumigwa wangu, ‘Tenda vino!’ na heyo kotenda.” ");
INSERT INTO zajp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu viyahulike vino, kakanganya na kuwalongela waja wakalile womkoleleza, “Nowalongela ikweli, sinamona munhu yoyose muisi ya Islaeli yali na nhamanila ng'hulu kamba ino. ");
INSERT INTO zajp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nowalongela kamba wanhu bwando wokwiza kulawa haulawilo wa zua na hauswelo wa zua na wokala hana ulusona hamoja na Ablaham, Isaka, na Yakobo Muundewa wa Kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ila Wana wa Undewa wokwasigwa hanze mdiziza, ako kondawalile na kugegedula meno.” ");
INSERT INTO zajp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Abaho, Yesu kalonga na ija imkulu wa asikali mia wa Loma, “Genda, yotendeka kamba vija vuutamanile.” Na kipigiti kikija mtumigwa wake kahona. ");
INSERT INTO zajp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu viyavikile hakae ha Petulo, kam'vika mama mkwe yake Petulo kawasa mulusazi mtamu wa homa. ");
INSERT INTO zajp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kamkwasa mkono wake, na homa imulawa, abaho kenuka na kusonga kumsang'hanikila. ");
INSERT INTO zajp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Viivikile ichungulo, wamgalila wanhu bwando wakalile na vinyamkela, na heyo kawawinga ivinyamkela mkuwakomhokela, na kawahonya wanhu wose wakalile watamu. ");
INSERT INTO zajp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Giladi gavikile gaja galongigwe na muhokozi Isaya, “Heyo mwenyego kausola unyondenyonde wetu na kavipapa vitamu vetu.” ");
INSERT INTO zajp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu viyadiwene didale da wanhu domzunguluka, kawalagiza wanahina zake wachole mwambu uyagwe wa dilamba. ");
INSERT INTO zajp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mfundiza Malagizo ga Musa kamcholela, kamulongela, “Mkulufunzi, nokuwinza kokose kuuchola.” ");
INSERT INTO zajp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu kamulongela, “Mbwizi wana mhango, na ndege wa kuulanga wana mvulu, ila nie, Mwana wa Munhu, kabule hanhu ha kutambalika pala jake.” ");
INSERT INTO zajp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mwanahina iyagwe kamulongela, “Mndewa, nileke tanhu nyhole hazike tataangu.” ");
INSERT INTO zajp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu kamulongela, “Ng'hweleleza nie, waleke wadanganhike wazike wadanganhike wayao.” ");
INSERT INTO zajp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Abaho, Yesu kakwela muingalawa hamoja na wanahina zake. ");
INSERT INTO zajp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bahaja dilawila kukuzumbi kulu mdilamba, avo mawimbi gaimemeza mazi ingalawa. Ila Yesu kakala yawasile. ");
INSERT INTO zajp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wanahina zake wamcholela wamulamusa, walonga, “Mndewa, tukombole! Todanganhika!” ");
INSERT INTO zajp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu kawedika, “Mweye wanhu muli na nhamanila ndodo, habali mkona bwembwe?” Abaho, kenuka na kudikomhokela dibeho na gamawimbi, na kukala hapozike. ");
INSERT INTO zajp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Wanahina zake wakanganya, walonga, “Ino iyo munhu wa vilihi? Hata beho na mawimbi vomuhulika!” ");
INSERT INTO zajp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu viyavikile mwambu uyagwe wa idilamba hana iisi ya Gadala, kaiting'hana na wanhu wabili wali na vinyamkela wakalile wolawa mmapanga. Wakala wodumbiza ng'hani mbaka hakukalile na munhu yadahile kubita nzila iyo. ");
INSERT INTO zajp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Waguta nyangi, walonga, “Kotulonda choni, Mwana wa Mulungu? Kwiza kutugaza kipigiti king'hali hakinavika?” ");
INSERT INTO zajp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Behi na aho kukala na dale kulu da mitumbi wodila. ");
INSERT INTO zajp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Vinyamkela wamuyalalila Yesu, walonga, “Uhatuwinga, tuleke tuchole tukengile mdidale dija da mitumbi.” ");
INSERT INTO zajp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu kawalongela, “Gendeni!” Avo walawa, wachola kuwengila mitumbi. Baho dale jose da imitumbi dihumulukila kubonde mdigema, dingila mdilamba na kudanganhika mmazi. ");
INSERT INTO zajp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Waja iwanhu wakalile wowachunga imitumbi wakimbila, wachola hana ikiwambo na kuwalongela wanhu mbuli zose, hamoja na gaja gawalawilile waja wanhu wakalile na vinyamkela. ");
INSERT INTO zajp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Avo, wanhu wose wa ikiwambo kija walawa, wamcholela Yesu, na viwamuwene, wamuyalalila yahalawe muisi yao. ");
INSERT INTO zajp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu kakwela muingalawa, kaloka na kuvika mkiwambo chake. ");
INSERT INTO zajp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wanhu wayagwe wamgalila munhu yaholole, yatambalale mulusazi. Yesu viyaiwene nhamanila yao, kamulongela ija imunhu yaholole, “Gangamala, mwanangu! Vilozo vako vigeligwa kumgongo.” ");
INSERT INTO zajp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Abaho, wafundiza Malagizo ga Musa wakalile baho wailongela wenyego kwa wenyego, “Munhu ino kofukula!” ");
INSERT INTO zajp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu kavitanga vija viwakalile wogelegeza, kalonga, “Habali mgelegeza vihile mmioyo yenu? ");
INSERT INTO zajp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Dilihi dibuhile ng'hani, kulonga, ‘Vilozo vako vigeligwa kumgongo,’ ama kulonga, ‘Ima wima utembele?’ ");
INSERT INTO zajp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nolonda m'vitange kamba, nie, Mwana wa Munhu, nna udaho wa kuvigela kumgongo vilozo va wanhu muisi.” Abaho, kamulongela ija imunhu yaholole, “Ima wima, papa lusazi lwako, uchole ukae yako!” ");
INSERT INTO zajp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ija imunhu kema wima, na kuchola ukae. ");
INSERT INTO zajp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wanhu viwonile gano, wakanganya na kudumba, na kumuyenzi Mulungu yawagwelele wanhu udaho kamba uja. ");
INSERT INTO zajp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu viyakalile yochola kulawa haja, kamona munhu yokemigwa Matayo yakalile muna ing'anda yake ya kulihila kodi, na heyo kamulongela, “Ng'holeleza.” Matayo kenuka, kamkoleleza. ");
INSERT INTO zajp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu na wanahina zake wakala woja mandia ga ichungulo hakae ya Matayo. Wawila kodi bwando na wene vilozo wayagwe weza na kuja hamoja na hewo. ");
INSERT INTO zajp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafalisayo viwonile gano, wawauza wanahina zake, “Habali mkulufunzi wenu yoja na wawila kodi na wene vilozo wayagwe?” ");
INSERT INTO zajp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu viyahulike vino, kalonga, “Wanhu wagima hawamulonda mganga, ila waja wali watamu wawo womulonda. ");
INSERT INTO zajp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gendeni mkaifundize nhegulo ya ulonzi uno, ‘Nolonda bazi na sio nhosa.’ Kwavija sizile kuwakema wanhu walibule vilozo, ila wanhu wali na vilozo.” ");
INSERT INTO zajp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Abaho, wanahina wa Yohana M'batiza wamcholela Yesu, wamuuza, “Habali tweye na Mafalisayo tofunga, ila wanahina zako hawafunga?” ");
INSERT INTO zajp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu kawedika, “Wahenza wa mulawilamhambe wodaha vilihi kulila kipigiti viwali hamoja na heyo? Ila kipigiti chokwiza, mulawilamhambe vondayasegezigwe kulawa kumwao, leka na hewo wafunge. ");
INSERT INTO zajp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Haduhu munhu yogela kidanga cha kivalo cha sambi muna ikivalo cha umwaka, kwavija ikidanga choikunza na kuchongeza ikizonzo cha ikivalo cha umwaka. ");
INSERT INTO zajp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na wanhu hawagela divai ya sambi muna ivibuyu vitendigwe na kwembe va umwaka. Kamba wahatenda avo, ivibuyu vitendigwe na kwembe votulika, na idivai yokwitika, na ivibuyu vitendigwe na kwembe vobanangika. Ila divai ya sambi yogeligwa muna ivibuyu vitendigwe na kwembe va sambi, na vose vowa vigima.” ");
INSERT INTO zajp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu viyakalile yolonga vino, mkulu imwe wa ng'anda ya nhambiko kamcholela, kamfugamila mavindi, kamulongela, “Mndele wangu sambisambi kadanganhika, ila izo umwikile mkono wako na heyo kowa mgima.” ");
INSERT INTO zajp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Avo Yesu hamoja na wanahina zake, wenuka, wamkoleleza. ");
INSERT INTO zajp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Baho mtwanzi yakalile na utamu wa kutumika mkipigiti cha milao longo dimwe na mibili kamwizila Yesu kukisogo, abaho, kalukwasa lugigo lwa kivalo chake. ");
INSERT INTO zajp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kwavija kakala yoilongela mwenyego, “Ihawa nihagoga tu valo jake, nohona.” ");
INSERT INTO zajp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu kahinduka kamona, kamulongela, “Mndele, gangamala! Nhamanila yako ikuhonya.” Kipigiti kikija mtwanzi ija kahona. ");
INSERT INTO zajp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu viyavikile hakae ya ija imkulu wa ng'anda ya nhambiko, na viyawawene wotoa mhalati, na wanhu bwando wolila ng'hani, ");
INSERT INTO zajp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","kalonga, “Segeleni! Mndele ino hadanganhike, ila kawasa!” Abaho, wanhu wose wamseka. ");
INSERT INTO zajp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Didale da wanhu vidilavigwe kunze, Yesu kengila mng'anda, kamgoga mkono ija imndele, na heyo kenuka. ");
INSERT INTO zajp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mbuli zino zenela hanhu hose muisi ija. ");
INSERT INTO zajp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu viyakalile yochola kulawa haja, vimbugumbugu wabili wamkweleleza, woguta nyangi, “Tonele bazi, Mwana wa Daudi!” ");
INSERT INTO zajp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu viyengile mng'anda, waja vimbugumbugu wamcholela, na Yesu kawauza, “Motogola kamba nie nodaha kuwahonya mweye?” Wedika, “Ona, Mndewa!” ");
INSERT INTO zajp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Abaho, kagakwasa meso gao, kalonga, “Mtendeligwe kamba vija vumtamanila!” ");
INSERT INTO zajp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na meso gao gagubuligwa. Yesu kawazuma ng'hani, kawalongela, “Sambimmulongele munhu yoyose mbuli ino!” ");
INSERT INTO zajp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ila hewo wachola na kubwililisa mbuli za Yesu kila hanhu muisi ija. ");
INSERT INTO zajp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wanhu viwakalile wosegela, wamgalila munhu yakalile bubui yali na kinyamkela. ");
INSERT INTO zajp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kinyamkela viyawingigwe, ija imunhu kasonga kulonga, na wanhu wose wakanganya, walonga, “Hatunachona kinhu kamba kino muisi ya Islaeli!” ");
INSERT INTO zajp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ila Mafalisayo walonga, “Kowinga vinyamkela na mhiko za mkulu wa vinyamkela.” ");
INSERT INTO zajp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu kachola mmiwambo na m'viwambo vose, yofundiza mzing'anda zao za nhambiko, youpeta Usenga Unogile wa Undewa wa Mulungu, na kuhonya kila utamu na unyondenyonde. ");
INSERT INTO zajp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Viyadiwene didale da wanhu, kawonela bazi, kwavija wakala wogaya na wabule munhu wa kuwataza, kamba ng'hondolo walibule mchunga. ");
INSERT INTO zajp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Abaho, kawalongela wanahina zake, “Va kuhuna vimema ila wahunaji wadodo.” ");
INSERT INTO zajp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Avo mpuleni mwene mgunda, yawagale wahunaji wahune vakuja vake. ");
INSERT INTO zajp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu kawakema wanahina zake longo dimwe na wabili na kuwagwelela udaho wa kuwinga vinyamkela na kuhonya kila utamu na unyondenyonde. ");
INSERT INTO zajp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Gano gago matwaga ga watumigwa wa Kilisto longo dimwe na wabili, wa mwanduso Simoni, yakalile yokemigwa Petulo, na ndugu yake Endelea, Yakobo na ndugu yake Yohana wanage Zebedayo, ");
INSERT INTO zajp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo na Batolomayo, Tomaso na Matayo muwila kodi, Yakobo mwanage Alufayo, Tadayo, ");
INSERT INTO zajp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni, yakalile yokemigwa Mgombeleza Isi ya Islaeli, na Yuda Isikalioti, yamuhonzile Yesu. ");
INSERT INTO zajp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu kawalagiza wano longo dimwe na wabili, kawalongela, “Sambimchole muisi ya Wamhazi ama kwingila mkiwambo cha Wasamalia, ");
INSERT INTO zajp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ila gendeni ha ng'hondolo wapotele, awo wali wanhu wa Islaeli. ");
INSERT INTO zajp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ako kumchola, peteni mulonga, ‘Undewa wa Kuulanga ukwenhuka!’ ");
INSERT INTO zajp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Honyeni watamu, zuseni wadanganhike, wahonyeni watamu wa dikulu, wingeni vinyamkela. Mgweleligwa bule, laveni bule. ");
INSERT INTO zajp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Sambimsole hela yoyose mmikwiji yenu, ");
INSERT INTO zajp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","sambimsole mkoba wa mwanza, ama koti da ikabili, ama ng'hwabasa, ama fimbo. Kwavija msang'hana kolondigwa yagweleligwe kitumetume chake. ");
INSERT INTO zajp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Vondamwingile mdiwambo ama mkiwambo, zahileni munhu yowatogola, giladi mkale hamwake mbaka vondamsegele. ");
INSERT INTO zajp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Vondamwingile muna ing'anda ija walamseni wanhu wa ng'anda ija. ");
INSERT INTO zajp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na kamba wanhu wa ng'anda hiyo wahawabokela, walekeleni tindiwalo jenu, ila kamba hawawabokela, tindiwalo jenu diwabwelele mweye. ");
INSERT INTO zajp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ihawa munhu yoyose hawabokela mweye ama kuzitegeleza mbuli zenu, muhalawa muna ing'anda hiyo ama mkiwambo hicho, kung'unheni timbwisi dinanahile mmagulu genu, kamba usindila ulagusa kamba hewo wenyego waulema Usenga wa Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nowalongela ikweli, yodahika wanhu wa viwambo va Sodoma na Gomola koneligwa bazi mdizua da nhaguso kubanza wanhu wa kiwambo hicho! ");
INSERT INTO zajp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Tegelezeni! Nie nowatuma kamba ng'hondolo mdidale da mbwizi, muwe na nzewele kamba nyoka na muwe na moyo uholile kamba hua. ");
INSERT INTO zajp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Iteganyeni na wanhu, kwavija wowagala mweye kukitala, na wowalanha mbalati muna zing'anda zao za nhambiko. ");
INSERT INTO zajp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mogaligwa ha wakulu wa isi na wandewa sama yangu nie, giladi munilavile usindila kumwao na ha Wamhazi. ");
INSERT INTO zajp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Vondamgaligwe mkitala, sambimgelegeze kamba mulonge choni ama mulonge vilihi, kwavija kipigiti kicho mogweleligwa mbuli ya kulonga. ");
INSERT INTO zajp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kwavija sio mweye wondamulonge, ila Loho wa Tata wenu iyo yondayalonge kubitila mweye. ");
INSERT INTO zajp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ndugu komuhonza ndugu yake giladi yakomigwe, na tata komuhonza mwanage, na wana wowahonza watata zao na wamama zao, na kuwatenda wakomigwe. ");
INSERT INTO zajp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mokwihilwa na wanhu wose sama ya twaga jangu. Ila yondayazaganye mbaka hakimambukizo, iyo yondayakomboligwa. ");
INSERT INTO zajp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wahawagaza mkiwambo kimwe, kimbilileni mkiwambo kiyagwe. Nowalongela ikweli, nie, Mwana wa Munhu, nokwiza kipigiti hamnamambukiza kubita m'viwambo vose va Islaeli. ");
INSERT INTO zajp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mwanahina ham'banza mkulufunzi wake, na nyakadala ham'banza mndewa wake. ");
INSERT INTO zajp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yotosha mwanahina kuwa kamba mkulufunzi wake, na nyakadala kuwa kamba mndewa wake. Ihawa mkulu wa ng'anda kokemigwa Belizebuli, haibanza ng'hani wanhu wa ng'anda yake kukemigwa matwaga gehile ng'hani! ");
INSERT INTO zajp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Avo sambimuwadumbe wanhu wano, kwavija haduhu kinhu kigubikigwe chondakileke kugubuligwa, ama kifisigwe chondakileke kutangigwa. ");
INSERT INTO zajp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kiniwalongela mdiziza, kipeteni hamulangaza, na kimuhulika kinyong'onywa, kipeteni mwa wanhu wose. ");
INSERT INTO zajp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Sambimuwadumbe waja wose wokoma lukuli, ila hawadaha kukoma loho, mdumbeni Mulungu yodaha kubananga vose lukuli na loho na kuvasa kuzimu. ");
INSERT INTO zajp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Vitongwa vibili haviuzigwa na hela ndodo? Ila hata kitongwa kimwe hakilagala hasi kamba Tata wenu halondile. ");
INSERT INTO zajp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na hata mvili zose zili mmapala genu zipetwa. ");
INSERT INTO zajp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Avo sambimdumbe, mweye mnogeligwa ng'hani na Mulungu kubanza vitongwa bwando! ");
INSERT INTO zajp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Munhu yoyose yonitogola haulongozi wa wanhu, vivija na nie nomtogola haulongozi wa Tataangu yali kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ila munhu yoyose yonilema haulongozi wa wanhu, vivija na nie nomulema haulongozi wa Tataangu yali kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Sambimgelegeze kamba niza kugala tindiwalo muisi. Bule, sizile kugala tindiwalo, ila zele. ");
INSERT INTO zajp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kwavija niza kugala uhasama ha munhu na tataake, mndele na mamaake, mkemwana na mama mkwe yake, ");
INSERT INTO zajp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","na wadumuka wa munhu iwo waja wali mng'anda yake. ");
INSERT INTO zajp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Munhu yoyose yomnogela tataake ama mamaake kubanza nie, hadaha kuwa mwanahina wangu, vivija yomnogela mmhale wake ama mndele wake kubanza nie, hadaha kuwa mwanahina wangu. ");
INSERT INTO zajp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na munhu yoleka kusola msalaba wake na kunikoleleza, hadaha kuwa mwanahina wangu. ");
INSERT INTO zajp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Munhu yogeza kuukombola ugima wake kowagiza, ila munhu yowagiza ugima wake sama yangu koukombola. ");
INSERT INTO zajp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Munhu yowabokela mweye konibokela nie, na munhu yonibokela nie kom'bokela ija yanhumile nie. ");
INSERT INTO zajp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Munhu yoyose yom'bokela muhokozi kwavija viyali muhokozi, kobokela nhunza kamba iija iyobokela muhokozi. Na munhu yoyose yom'bokela munhu yanogile kwavija viyali munhu yanogile, kobokela nhunza kamba iija iyobokela munhu yanogile. ");
INSERT INTO zajp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nowalongela ikweli, munhu yoyose yolava hata kikasi cha mazi ga uzizimi ha munhu imwe wa wano wadodo kwavija viyali mwanahina wangu, haleka bule kubokela nhunza yake.” ");
INSERT INTO zajp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu viyamambukize kuwagwelela malagizo wanahina zake longo dimwe na wabili, kahalawa haja, kachola kufundiza na kuwapetela wanhu mmiwambo ya isi ya Galilaya. ");
INSERT INTO zajp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohana M'batiza viyakalile mkifungo, kazihulika sang'hano za Kilisto, avo kawalagiza wanahina zake wachole kumwake, ");
INSERT INTO zajp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","wakamuuze, “Gweye iyo ija yokwiza, ama tumulolele iyagwe?” ");
INSERT INTO zajp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu kawedika, “Gendeni mkamulongele Yohana mbuli zimuhulika na kuzona, ");
INSERT INTO zajp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","vimbugumbugu wolola, mbetembete wotembela, wene dikulu wohonywa, vinziwi wohulika, wadanganhike wozuka, na wakumbulu wopeteligwa Usenga Unogile. ");
INSERT INTO zajp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kamota munhu ija nie nilekile kuwa king'hwaso kumwake!” ");
INSERT INTO zajp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wanahina wa Yohana viwacholile, Yesu kasonga kudilongela didale da wanhu mbuli ya Yohana, yolonga, “Mchola kulola choni mkiwala? Ludete vulutigiswa na beho? ");
INSERT INTO zajp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mchola kulola choni? Mchola kumulola munhu yavalile vivalo vinogile? Wanhu wovala vivalo vinogile wokala mming'anda ya kindewa! ");
INSERT INTO zajp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mchola kulola choni? Muhokozi? Ona, nowalongela, yummuwene kana ukulu kubanza muhokozi. ");
INSERT INTO zajp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yohana iyo munhu Nyandiko Zing'alile zimulonga, ‘Nomulagiza msenga wangu yakulongole, yondayaitande nzila yako.’ ");
INSERT INTO zajp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nowalongela ikweli, mmwanza wa wanhu wose waleligwe na watwanzi, haduhu yali mkulu kubanza Yohana M'batiza. Ila munhu yali mdodo kubanza wose muna Undewa wa Kuulanga iyo mkulu kubanza heyo. ");
INSERT INTO zajp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Songela kipigiti cha Yohana M'batiza mbaka sambi, Undewa wa Kuulanga wokwingilwa na mhiko, na wanhu wali na mhiko wogeza kuusamha. ");
INSERT INTO zajp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kwavija wahokozi wose wahokola na Malagizo ga Musa gahokola mbaka kipigiti cha Yohana. ");
INSERT INTO zajp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na kamba motogola, Yohana iyo yalongigwe na wahokozi kamba iyo Eliya yondayeze. ");
INSERT INTO zajp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yali na magwiti na yahulike. ");
INSERT INTO zajp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Vino niwalinganyize na choni wanhu wa mazua gano? Walinga na wana wakalile hadibugano da soko na kuwakema wayagwe, ");
INSERT INTO zajp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tuwatoela ngoma ya lusona lwa zengele, ila mweye ham'vinile! Twimba vawembaga hauzisi, ila mweye hamulilile!’ ");
INSERT INTO zajp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kwavija Yohana viyezile halulukile kuja na kung'wa na hewo walonga, ‘Kana kinyamkela!’ ");
INSERT INTO zajp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana wa Munhu keza yoja na kung'wa, na hewo wolonga, ‘Munhu ino mmelo na mng'waji, mbwiga wa wawila kodi na wene vilozo wayagwe!’ Ila munhu kokoneka kana nzewele sama ya sang'hano zake.” ");
INSERT INTO zajp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Abaho, Yesu kasonga kuwakomhokela wanhu wa miwambo ija mgati yake iyatendile mizonza yake bwando kwavija wanhu zao hawalondile kuleka vilozo vao. ");
INSERT INTO zajp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kojona Kolazini! Kojona Betisaida! Ihawa mizonza itendeke kumwenu kamba ihatendeke Tilo na Sidoni, wanhu zao wahalekile vilozo vao umwaka mkuvala magunia na kukiibakaza mitozi! ");
INSERT INTO zajp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ila nowalongela, yodahika Tilo na Sidoni koneligwa bazi mdizua da nhaguso kubanza mweye! ");
INSERT INTO zajp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na gweye Kapenaumu! Kokiinula mwenyego mbaka kuulanga? Kohumuluswa mbaka kuzimu! Ihawa mizonza itendeke kumwako kamba ihatendeke Sodoma, kiwambo hicho kihakalile baho mbaka lelo! ");
INSERT INTO zajp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ila nowalongela, yodahika Sodoma koneligwa bazi mdizua da nhaguso kubanza mweye!” ");
INSERT INTO zajp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kipigiti kija Yesu kalonga, “Nokugwaa hewela, Tata, Mndewa wa kuulanga na isi, kwavija kuwafisa mbuli zino wanhu wali na nzewele na wasomile, ila kuwagubulila wana wadodo. ");
INSERT INTO zajp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ona, Tata, kwavija vino vivo vuulondile vitendeke. ");
INSERT INTO zajp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Vinhu vose nigweleligwa na Tataangu. Haduhu munhu yomtanga Mwana ila Tata, na haduhu munhu yomtanga Tata ila Mwana na munhu yoyose Mwana yolonda kumgubulila. ");
INSERT INTO zajp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Izoni kumwangu mweye mose mdonhile na mpapa mibahasha mikulu, na nie nowagwelela mhumulo. ");
INSERT INTO zajp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ifungeni nila yangu, na mwiifunze kumwangu, kwavija nie nihola mmoyo na nikiihumulusa, na mweye mopata mhumulo mmioyo yenu. ");
INSERT INTO zajp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwavija nila yangu hailumiza na bahasha yangu ibuha.” ");
INSERT INTO zajp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kipigiti kija Yesu kakala yobita mmigunda ya ngano Mdizua da Mhumulo. Wanahina zake wona nzala, avo wasonga kufyola zisota za gamakungwi ga ngano na kudafuna. ");
INSERT INTO zajp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafalisayo viwawawene, wamulongela Yesu, “Lola, wanahina zako wotenda gagomeswe kutendigwa Mdizua da Mhumulo!” ");
INSERT INTO zajp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu kawedika, “Hamsomile kija chayatendile Daudi kipigiti heyo na wayage viwakalile na nzala? ");
INSERT INTO zajp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kengila mdihema da Mulungu, na heyo na wayage waija imikate ilavigwe nhosa, mbuli igomeswe na Malagizo ga Musa heyo ama wayage kuija, ila wakulu wa nhambiko weiyeka. ");
INSERT INTO zajp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ama, hamsomile muna Gamalagizo ga Musa kamba wakulu wa nhambiko wotenda mbuli zigomesigwe kutendigwa Mdizua da Mhumulo muna Ing'anda ya Mulungu, na hawoneka na Mulungu kamba wotenda mbuli ihile? ");
INSERT INTO zajp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nowalongela, hano hana mkulu kubanza Ng'anda ya Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ila kamba muhaitangile nhegulo ya ulonzi uno, ulonga, ‘Nolonda bazi na sio nhosa,’ sambimuwataguse wanhu walibule vilozo. ");
INSERT INTO zajp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kwavija, nie, Mwana wa Munhu, nene Mndewa hata Mdizua da Mhumulo.” ");
INSERT INTO zajp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu kahalawa hanhu haja, kengila muna ing'anda yao ya nhambiko, ");
INSERT INTO zajp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","na muja kukala na munhu yaholole mkono. Kuno wozahila kilamso cha kumtagusa, wamuuza, “Malagizo ga Musa gotogoza kumuhonya munhu Mdizua da Mhumulo?” ");
INSERT INTO zajp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu kawalongela, “Munhu yalihi mmwanza wenu yali na ng'hondolo imwe yengile mdikolongo Mdizua da Mhumulo, yondayaleke kumgoga na kumulava hanze? ");
INSERT INTO zajp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Munhu kazama mianza mingahi kubanza ng'hondolo! Avo, Malagizo ga Musa gotogoza kutenda ganogile Mdizua da Mhumulo.” ");
INSERT INTO zajp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Abaho, kamulongela ija imunhu yaholole umkono, “Golosa mkono wako.” Avo kaugolosa, na uwa mgima, kamba uja uyagwe. ");
INSERT INTO zajp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ila, Mafalisayo walawa kunze na kwika zundo wone vija vondawamkome Yesu. ");
INSERT INTO zajp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu viyavitangile kamba wamwikila zundo da kumkoma, kahalawa hanhu haja, na wanhu bwando wamkweleleza. Na heyo kawahonya wanhu wose wakalile watamu, ");
INSERT INTO zajp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","na kuwalagiza sambiwamulonge heyo iyo yalihi. ");
INSERT INTO zajp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mbuli zino zivikiza kija kilongigwe na muhokozi Isaya, ");
INSERT INTO zajp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ino iyo mtumigwa wangu inimsagule, inimnogele, moyo wangu unogelwa nayo. Nomgwelela Loho wangu, na heyo koipeta nhaguso yangu ha Wamhazi. ");
INSERT INTO zajp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hagomba na munhu ama kuguta nyangi, haduhu munhu yondayadihulike dizwi jake mzinzila za m'viwambo. ");
INSERT INTO zajp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Halubena ludete luveduke, ama kuuzima utambi ulava yosi. Mbaka vondayagatende gaja galibule uzenzeleganye gahume, ");
INSERT INTO zajp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","na Wamhazi woditamanila twaga jake.” ");
INSERT INTO zajp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Abaho, wamgalila munhu yali na kinyamkela yakalile kimbugumbugu na bubui, na Yesu kamuwinga ikinyamkela, avo ija imunhu kadaha kulonga na kulola. ");
INSERT INTO zajp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wanhu wose wakanganya na kulonga, “Vodahika ino kuwa Kilisto, Mwana wa Daudi?” ");
INSERT INTO zajp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mafalisayo viwahulike vino, walonga, “Munhu ino kowinga vinyamkela na udaho wa Belizebuli tu, mkulu wa vinyamkela.” ");
INSERT INTO zajp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu kazitanga ngelegeza zao, kawalongela, “Undewa wowose uhaigola mmadalemadale, gogomba genyego kwa genyego, undewa hiwo haugendelela. Na wambo jojose ama mulango uhaigola mmadalemadale, gogomba genyego kwa genyego, mulango hiwo hawima. ");
INSERT INTO zajp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ihawa Mwenembago kowinga vinyamkela, kokiigola mwenyego, avo, undewa wake wodahaze kwima? ");
INSERT INTO zajp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na kamba nowinga vinyamkela na udaho wa Belizebuli, wanhu zenu wowinga vinyamkela na udaho waki? Avo, hewo wao wondawawataguse! ");
INSERT INTO zajp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ila kamba nowinga vinyamkela na Loho wa Mulungu, avo, Undewa wa Mulungu uwezila. ");
INSERT INTO zajp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ama kodahaze munhu kwingila muna ing'anda ya munhu yali na mhiko na kum'bokonya vinhu vake, kamba hamfungile tanhu, leka yadahe kum'bokonya vinhu vili mng'anda yake? ");
INSERT INTO zajp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Munhu yoyose yalekile kuwa hamoja na nie, konibeza, na munhu yoyose yalekile kukunzanya na nie, kopwililisa. ");
INSERT INTO zajp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nowalongela, vilozo vose na ufukuzi wose wogeligwa kumgongo, ila ufukuzi wa kumfukulila Loho wa Mulungu haugeligwa kumgongo. ");
INSERT INTO zajp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Munhu yoyose yonilonga vihile nie, Mwana wa Munhu, vodahika kugeligwa kumgongo, ila munhu yoyose yomulonga vihile Loho wa Mulungu havidahika kugeligwa kumgongo, muulumwengu uno ama kuulumwengu ukwiza. ");
INSERT INTO zajp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“M'biki uhanoga na mujo wake wonoga, na m'biki uheha vivija na mujo wake wokwiha. Kwavija m'biki wotangigwa sama ya mujo wake. ");
INSERT INTO zajp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mweye wana wa nyoka! Modahaze kulonga kinhu kinogile na ihawa mweye wenyego mwiha? Kwavija munhu kolonga gaja gaumemeze moyo wake. ");
INSERT INTO zajp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Munhu yanogile kolava ganogile kulawa muna ingama ya moyo wake unogile, na munhu yehile kolava gehile kulawa muna ingama ya moyo wake wihile. ");
INSERT INTO zajp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nowalongela kamba, mdizua da nhaguso wanhu wolava mheta ya kila mbuli ihile iwailongile. ");
INSERT INTO zajp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kwavija kubitila mbuli zako kopeteligwa ganogile, na kubitila mbuli zako kotagusigwa.” ");
INSERT INTO zajp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Abaho, wafundiza Malagizo ga Musa na Mafalisayo wamulongela, “Mkulufunzi, tolonda tone mizonza kulawa kumwako.” ");
INSERT INTO zajp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu kedika kalonga, “Wanhu wa mulelo wihile na uleka kumtamanila Mulungu wolonda kilaguso! Ila hawagweleligwa kilaguso, ila kilaguso cha muhokozi Yona. ");
INSERT INTO zajp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kamba vija Yona viyakalile muna iinda ya isomba mkulu ng'hani mazua madatu, vivija nie, Mwana wa Munhu, nokala muna umoyo wa iisi mazua madatu. ");
INSERT INTO zajp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mdizua da nhaguso wanhu wa Ninawi wokwima na wanhu wa mulelo uno na kuwatagusa mweye, kwavija hewo waleka vilozo vao viwamuhulike Yona viyakalile yopeta. Na hano hana mkulu kubanza Yona! ");
INSERT INTO zajp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mdizua da nhaguso Malikia wa Kusi kokwima na wanhu wa mulelo uno na kuwatagusa mweye, kwavija heyo keza kulawa kuzisota za iisi giladi yategeleze ng'hungwe ya Selemani. Na hano hana mkulu kubanza Selemani! ");
INSERT INTO zajp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kinyamkela yahamulawa munhu, kochola kubitila hanhu hanyalile yozahila hanhu ha kuhumula, ila hahapata. ");
INSERT INTO zajp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Abaho, kolonga, ‘Nobweleganya kung'anda yangu kunilawile.’ Yahabwela na kuivika ing'anda yabule kinhu, ifagiligwa, na kuhambigwa, ");
INSERT INTO zajp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","kochola kuwasola vinyamkela wayagwe saba wehile kubanza heyo mwenyego, wokwingila na kukala himo. Na hali ya munhu hiyo yokwiha ng'hani kubanza ija ya haichanduso. Vino vivo vondaiwe ha wanhu wa mulelo uno wihile.” ");
INSERT INTO zajp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu viyakalile yang'hali yolonga na dale da wanhu, mamaake na ndugu zake wema hanze, walonda kulonga nayo. ");
INSERT INTO zajp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Munhu imwe kamulongela, “Mamaako na ndugu zako wema hanze, wolonda kulonga nagwe.” ");
INSERT INTO zajp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu kamwidika ija imunhu yamulongele, “Mamaangu iyo yalihi? Na ndugu zangu wawo walihi?” ");
INSERT INTO zajp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kuno yowalinga kidole wanahina zake kalonga, “Wano wao mamaangu na ndugu zangu! ");
INSERT INTO zajp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kwavija munhu yoyose yogatenda goyolonda Tataangu wa kuulanga iyo ndugu yangu, lumbu jangu na mamaangu.” ");
INSERT INTO zajp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Zua didija Yesu kalawa muna ing'anda, kakala hamgwazo wa idilamba. ");
INSERT INTO zajp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Dale kulu da wanhu dimzunguluka, avo kakwela na kukala muna ingalawa. Na didale da wanhu dima mumgwazo wa idilamba. ");
INSERT INTO zajp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kawalongela vinhu bwando mmahala. “Mulimi kachola kuhanda mbeyu. ");
INSERT INTO zajp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Viyakalile yozihanda, ziyagwe zilagalila mnzila, na ndege weza wazija. ");
INSERT INTO zajp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mbeyu ziyagwe zilagalila mmabwe kukalile na ulongo mdodo. Avo zota himahima kwavija ulongo ukala mdodo. ");
INSERT INTO zajp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ila zua vidilawile diilukuza imiche na kwavija mizizi yake haingile hasi ng'hani imiche inyala. ");
INSERT INTO zajp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbeyu ziyagwe zilagalila mmizomola, imizomola ikula na kuizingiliza imiche. ");
INSERT INTO zajp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ila mbeyu ziyagwe zilagalila muulongo unogile, ziyagwe zilela mia, ziyagwe zilela malongo sita, na ziyagwe zilela malongo madatu. ");
INSERT INTO zajp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yali na magwiti na yahulike.” ");
INSERT INTO zajp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Abaho, wanahina wamcholela Yesu wamuuza, “Habali ulonga na wanhu mmahala?” ");
INSERT INTO zajp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu kawalongela, “Mweye mgweleligwa nzewele za kuzitanga nyong'onyo za Undewa wa Kuulanga, ila hewo hawagweleligwe. ");
INSERT INTO zajp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Munhu yali na kinhu kokongezelwa na kowa navo bwando, ila munhu yalibule kinhu hata kija ikidodo chayalinacho kobokigwa. ");
INSERT INTO zajp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kilamso cha kulonga nao mmahala kicho kino, kamba wolola ila hawona kinhu, na wotegeleza ila hawahulika ama hawavitanga. ");
INSERT INTO zajp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Uhokozi wa Isaya uvikila kumwao, ‘Kuhulika mohulika, ila ham'vitanga, kulola molola, ila ham'vimanya, ");
INSERT INTO zajp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","kwavija wanhu wano wana mioyo midala, magwiti gao wagatenda sambigahulike, na meso gao wafing'hiliza. Ila kamba meso gao gahalolile, na magwiti gao gahahulike, wahavitangile mmioyo yao, na kunihindukila nie, nihawahonyile.’ ");
INSERT INTO zajp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ila gamota meso genu, kwavija golola, na magwiti genu, gohulika. ");
INSERT INTO zajp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nowalongela ikweli, wahokozi na wanhu bwando walibule uzenzeleganye wasulukila kugona gano gomgona mweye, ila hawagonile, na wasulukila kugahulika gano gomuhulika mweye, ila hawagahulike. ");
INSERT INTO zajp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Tegelezeni nhegulo ya dihala da mulimi. ");
INSERT INTO zajp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Munhu yoyose yohulika Usenga wa Undewa wa Kuulanga ila hautanga, Mwenembago kokwiza na kuusamha uja Usenga uhandigwe mmoyo wake, zino zizo mbeyu zilagalile mnzila. ");
INSERT INTO zajp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbeyu zilagalile mmabwe zizo Usenga uyahulike munhu, na baho koubokela mkudeng'ha. ");
INSERT INTO zajp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ila kwavija ukala na mizizi midodo, avo wokala mkipigiti kiguhi. Na kiheza kipigiti cha mgayo ama kugazigwa sama ya Usenga wa Mulungu, baho kobwela kukisogo. ");
INSERT INTO zajp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mbeyu zilagalile mmizomola, zizo zimbuli ziyahulike munhu, ila bwembwe da ulumwengu uno na unogelo wa mali wozizingiliza na kuzitenda sambizilele. ");
INSERT INTO zajp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ila mbeyu ilagalile muulongo unogile iyo munhu yaihulike imbuli na kuitanga, abaho, kalela mijo bwando, imwe kalela mia, iyagwe malongo sita, na iyagwe malongo madatu.” ");
INSERT INTO zajp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu kawalongela hala diyagwe, “Undewa wa Kuulanga ulinga na munhu yahandile mbeyu inogile mumgunda wake. ");
INSERT INTO zajp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ila wanhu wose viwakalile wawasile, mdumuka wake keza kahanda lolo muingano, abaho, kachola. ");
INSERT INTO zajp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ija ingano viyotile na kusonga kufumula, idilolo disonga koneka. ");
INSERT INTO zajp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nyakadala wa ija mwene mgunda keza kamulongela, ‘Mndewa, huhandile mbeyu zinogile mumgunda wako? Dilolo dilawa kwahi?’ ");
INSERT INTO zajp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kamwidika, kamulongela, ‘Mdumuka iyo yatendile vino.’ Abaho, ija inyakadala kamuuza, ‘Kolonda tweye tuchole tukading'ole dilolo?’ ");
INSERT INTO zajp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kamulongela, ‘Bule, kwavija kipigiti vondamding'ole dilolo, moding'ola hamoja na ingano. ");
INSERT INTO zajp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Leka ingano na idilolo vose vikule hamoja mbaka kipigiti cha kuhuna. Na kipigiti hicho nowalongela wahunaji, tanhu dilundizeni idilolo, mdifunge makinzamakinza mkadisome moto, abaho, ilundizeni ingano mkaike kukano jangu.’ ” ");
INSERT INTO zajp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu kawalongela hala diyagwe, “Undewa wa Kuulanga ulinga na mbeyu ya haladali yaaisolile munhu na kuihanda mumgunda wake. ");
INSERT INTO zajp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mbeyu ndodo kubanza zose, ila ihakula yowa mche mkulu kubanza miche yose mkihati na hata kuwa biki kulu. Avo ndege wa kuulanga wokwiza na kuzenga mvulu mmatambi gake.” ");
INSERT INTO zajp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu kawalongela hala diyagwe, “Undewa wa Kuulanga ulinga na mela dodo diyasolile mtwanzi na kuditibuliza muna ivibaba vidatu va usage mbaka tonge jose dilulumuka.” ");
INSERT INTO zajp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu kawalongela wanhu bwando mbuli zino zose mmahala, hawalongele kinhu chochose bila mahala. ");
INSERT INTO zajp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Giladi gaja galongigwe na muhokozi gavikile, “Nounanula mulomo wangu nilonge mmahala, Nilonge gaja gafisike songela ulumwengu vuulumbigwe.” ");
INSERT INTO zajp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Abaho, Yesu kadileka didale da wanhu, kengila mng'anda. Wanahina zake wamkwenhukila wamulongela, “Tulongele nhegulo ya dihala da idilolo da kumgunda.” ");
INSERT INTO zajp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu kawalongela, “Imunhu yahandile imbeyu inogile iyo nie, Mwana wa Munhu, ");
INSERT INTO zajp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","umgunda uwo ulumwengu, na imbeyu inogile iyo wana wa Undewa wa Kuulanga, na idilolo dijo wanhu wa Mwenembago, ");
INSERT INTO zajp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","na imdumuka yahandile idilolo iyo Mwenembago. Gakuhuna gago zua da kimambukizo, na iwahunaji wao wasenga wa Mulungu wa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kamba vija idilolo vidilundizwe na kusomigwa moto, vivo vondaiwe muna dizua da kimambukizo. ");
INSERT INTO zajp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nie, Mwana wa Munhu, nowalagiza wasenga zangu wa kuulanga wavikunzanye na kuvilava hanze ya Undewa wake vija vose viwatenda wanhu watende vilozo, na waja wose watenda vilozo ");
INSERT INTO zajp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na kuwasa mditanuli da moto. Ako kowa na kililo na kugegedula meno. ");
INSERT INTO zajp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Abaho, wanhu wamnogele Mulungu wonang'hazika kamba zua Muundewa wa Tataao. Munhu yali na magwiti na yahulike! ");
INSERT INTO zajp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Undewa wa Kuulanga ulinga na ngama ifisigwe mumgunda. Na munhu imwe viyaiwene, kaifisa kabili, mkudeng'ha kachola kuguza vinhu vake vose viyalinavo, na kuugula mgunda uja. ");
INSERT INTO zajp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Vivija, Undewa wa Kuulanga ulinga na mchuluzi yozahila lulu zinogile, ");
INSERT INTO zajp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","na viyaiwene lulu imwe ya hela bwando, kachola na kuguza vinhu vake vose viyalinavo, na kuigula. ");
INSERT INTO zajp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Vivija, Undewa wa Kuulanga ulinga na nhando itandigwe m'bahali na kunamata somba wa namna zose. ");
INSERT INTO zajp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Inhando viimemile, waikwekwesa waigala mhwani, abaho, wakala hasi na kuwabagula iwasomba, wanogile waweka muna imigelo na wehila wawasa. ");
INSERT INTO zajp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Vivo vondaiwe mdizua da kimambukizo, wasenga wa Mulungu wa kuulanga wokwiza na kuwabagula wanhu wehile kulawa mwa wanhu watendile ganogile, ");
INSERT INTO zajp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na kuwasa wanhu wehile mditanuli da moto. Ako kowa na kililo na kugegedula meno.” ");
INSERT INTO zajp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu kawauza, “Movitanga vinhu vino vose?” Wamwidika, “Ona.” ");
INSERT INTO zajp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesu kawalongela, “Avo mfundiza yoyose wa Malagizo ga Musa yafundizigwe mbuli za Undewa wa Kuulanga kalinga na mwene ng'anda yolava vinhu va sambi na va umwaka kulawa muna ingama yake.” ");
INSERT INTO zajp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu viyamambukize kulonga mahala gano, kahalawa hanhu haja, ");
INSERT INTO zajp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","kabwela hana ikiwambo chake kikemigwa Nazaleti. Kasonga kuwafundiza wanhu muna zing'anda zao za nhambiko, avo, wakanganya na kulonga, “Kaipata kwahi ng'hungwe ino na mhiko za kutenda mizonza? ");
INSERT INTO zajp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ino sio mwana wa salamala? Na mamaake hakemigwa Maliamu? Na ndugu zake sio kina Yakobo, Usufu, Simoni, na Yuda? ");
INSERT INTO zajp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na lumbu zake wose hawali hano hamoja na tweye? Avo munhu ino kazipata kwahi mhiko na nzewele zino zose?” ");
INSERT INTO zajp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Avo hawanogelwe nayo. Ila Yesu kawalongela, “Muhokozi kohishimilwa kila hanhu, ila mkiwambo chake mwenyego na mng'anda yake mwenyego.” ");
INSERT INTO zajp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Avo hatendile mizonza bwando hanhu haja kwavija wakala wabule nhamanila. ");
INSERT INTO zajp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kipigiti kija Helode Antipa, mtawala wa Galilaya, kahulika mbuli za Yesu, ");
INSERT INTO zajp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","avo kawalongela watumigwa zake, “Ino iyo Yohana M'batiza, kazuka kulawa mwa wanhu wadanganhike, kileka mana mhiko za kutenda mizonza zosang'hanika mgati yake.” ");
INSERT INTO zajp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kwavija Helode kakala yamgogile Yohana, kamfunga nzabi na kumgela mkifungo sama ya Helodia, mtwanzi wa mkulu wake yokemigwa Filipo. ");
INSERT INTO zajp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kwavija Yohana kakala yomulongela Helode, “Kutenda gagomeswe na Malagizo ga Musa kumsola Helodia!” ");
INSERT INTO zajp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helode kalonda kumkoma Yohana, ila kawadumba wanhu kwavija wakala wampetile kamba Yohana kakala muhokozi. ");
INSERT INTO zajp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Muna dizua da lusona lwa ng'humbukila ya mvumbuka ya Helode, mndele wa Helodia kavina haulongozi wa iwahenza. Helode kanogelwa, ");
INSERT INTO zajp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kamduilila na kamulongela kamba komgwelela kinhu chochose chondayapule. ");
INSERT INTO zajp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kuno yoswagizwa na mamaake, kalonga, “Nigwelele pala da Yohana M'batiza bahano muna ulungo!” ");
INSERT INTO zajp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mndewa kona giogio ng'hani, ila sama ya kiduilo chayaiduile na sama ya iwahenza wakalile haja, kalagiza yagweleligwe, ");
INSERT INTO zajp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","avo kalagiza pala da Yohana dikanhigwe muja mkifungo. ");
INSERT INTO zajp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pala jake digaligwa mulungo na kugweleligwa imndele, na heyo kamgalila mamaake. ");
INSERT INTO zajp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wanahina wa Yohana weza na kulusola lukuli lwake na kuluzika. Abaho, wachola kumulongela Yesu gaja galawilile. ");
INSERT INTO zajp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu viyahulike mbuli za Yohana, kanyelenhuka kulawa hanhu haja kakwela mngalawa kachola hanhu halibule wanhu. Ila wanhu viwahulike, walawa m'viwambo wamkoleleza na magulu. ");
INSERT INTO zajp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu viyahumuluke muna ingalawa, kawonela bazi na kuwahonya wanhu zao wakalile watamu. ");
INSERT INTO zajp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Viivikile ichungulo wanahina wamcholela wamulongela, “Zua diswa na hano twa mkiwala, avo walongele iwanhu wachole m'viwambo wakaigulile mandia.” ");
INSERT INTO zajp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu kawedika, “Hawalondigwa wachole, wagweleleni mweye kinhu cha kuja!” ");
INSERT INTO zajp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Na hewo wamulongela, “Hano twabule kinhu ila mikate mitano na somba wabili viiyeka.” ");
INSERT INTO zajp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu kawalongela, “Vigaleni hano hamwangu.” ");
INSERT INTO zajp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kawalagiza wanhu wakale hasi muluzondo, abaho, kaisola imikate mitano na iwasomba wabili, kalola kuulanga, na kumuheweza Mulungu. Abaho kaimogola imikate, kawagwelela wanahina, na wanahina wawagwelela iwanhu. ");
INSERT INTO zajp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wose waja na kwiguta. Abaho wanahina wadondola vidanga va imikate na iwasomba visigale, wamemeza vigelo longo dimwe na vibili. ");
INSERT INTO zajp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mheta ya wanhu wadile imikate wakala wambigalo alufu tano, uhaleka watwanzi na wana. ");
INSERT INTO zajp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Abaho, Yesu kawalagiza wanahina wakwele muna ingalawa wamulongole mwambu uyagwe wa idilamba, kipigiti heyo vayakalile yowalaga wanhu. ");
INSERT INTO zajp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Viyamambukize kuwalaga, kakwela hakigongo yeiyeka kutambika. Na zua vidiswele, Yesu kakala hiko yeiyeka. ");
INSERT INTO zajp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ila kipigiti kino ingalawa ikala kutali na iisi inyalile, ikunhizwa na mawimbi kwavija beho dikala dolawa kuulongozi wa ingalawa. ");
INSERT INTO zajp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mkipigiti cha nzogolo zikwika Yesu kawacholela wanahina zake, yotembela uchana ya igamazi. ");
INSERT INTO zajp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wanahina viwamuwene yotembela uchana ya igamazi, wona bwembwe, walonga, “Mzimu!” Waguta nyangi kuno wogudema. ");
INSERT INTO zajp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bahaja Yesu kawalongela, “Gangamaleni! Iyo nene, sambimdumbe!” ");
INSERT INTO zajp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petulo kamulongela, “Mndewa, kamba iyo gweye, nilagize nitembele uchana ya gamazi nize kumwako.” ");
INSERT INTO zajp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu kamwidika, “Izo!” Avo Petulo kahumuluka muna ingalawa, na kutembela uchana ya gamazi, na kumcholela Yesu. ");
INSERT INTO zajp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ila viyadiwene dibeho, kadumba, na kusonga kudidimila muna gamazi, kaguta nyangi yolonga, “Mndewa, nikombole!” ");
INSERT INTO zajp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Bahaja Yesu kagolosa mkono wake, kamgoga kamulongela, “Gweye uli na nhamanila ndodo! Habali usinha?” ");
INSERT INTO zajp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na viwakwelile muna ingalawa, dibeho dinyamala. ");
INSERT INTO zajp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wose wakalile muna ingalawa wamtambikila walonga, “Kweli gweye iyo Mwana wa Mulungu!” ");
INSERT INTO zajp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Viweshile kuloka idilamba, wavika kuna iisi ya Genesaleti. ");
INSERT INTO zajp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wanhu wa hiko viwamtangile Yesu, wabwililisa mbuli zake m'viwambo vose vili mmambwegambwega, na wamgalila wanhu wose wakalile watamu. ");
INSERT INTO zajp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wamuyalalila kamba yawaleke wanhu wakalile watamu wakwase lugigo lwa guo jake, na wose walukwasile wahona. ");
INSERT INTO zajp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Abaho, Mafalisayo na wafundiza Malagizo ga Musa kulawa Yelusalemu wamcholela Yesu, wamuuza, ");
INSERT INTO zajp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Habali wanahina zako hawaziwinza nzoela za wahenga zetu? Kwavija wahalonda kuja hawasuluza makono gao!” ");
INSERT INTO zajp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu kawedika, “Na mweye habali muileka ndagizi ya Mulungu sama ya nzoela yenu? ");
INSERT INTO zajp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kwavija Mulungu kalonga, ‘Wahishimile tataako na mamaako,’ na ‘Munhu yoyose yomulonga vihile tataake ama mamaake, yakomigwe.’ ");
INSERT INTO zajp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ila mweye molonga kamba, mduhu mbuli munhu yahamulongela tataake ama mamaake kamba, ‘Sidaha kuwagwelela kinhu chochose kwavija niiduila kamba vinhu vinilondile kuwagwelela mweye nivilave ha Mulungu,’ ");
INSERT INTO zajp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Avo, mmbuli zino mowalongela wanhu sambiwawahishimile watata na wamama zao. Avo muizabuza mbuli ya Mulungu sama ya kuiwinza nzoela yenu. ");
INSERT INTO zajp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Videlenya mweye, muhokozi Isaya kahokola goya yowalonga mweye haja viyalongile, ");
INSERT INTO zajp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Mulungu kalonga, “Wanhu wano wonihishimila nie mmilomo yao, ila mioyo yao yakutali na nie. ");
INSERT INTO zajp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wonitambikila nie bule, kwavija wofundiza mafundo ga wanhu kamba Malagizo gangu!” ’ ” ");
INSERT INTO zajp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Abaho, Yesu kadikema didale da wanhu na kudilongela, “Tegelezeni na kuvitanga! ");
INSERT INTO zajp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Haduhu kinhu chondakingile mmulomo wa munhu chondakimtende yanyolodoke, ila munhu konyolodoswa na mbuli zilawa mmulomo wake.” ");
INSERT INTO zajp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Abaho, wanahina wamcholela wamulongela, “Kuvitanga kamba Mafalisayo wehilwa viwazihulike mbuli zuulongile?” ");
INSERT INTO zajp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu kawalongela, “M'biki wowose hauhandigwe na Tataangu wa kuulanga wong'oligwa. ");
INSERT INTO zajp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Walekeni! Hewo wawo vilangizi vimbugumbugu wowalongoza vimbugumbugu wayao. Na kamba kimbugumbugu yahamulongoza kimbugumbugu miyage, wose wolagalila mdikolongo.” ");
INSERT INTO zajp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petulo kamulongela, “Tulongele nhegulo ya hala dino.” ");
INSERT INTO zajp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu kawalongela, “Vivija na mweye mng'hali hamnavitanga? ");
INSERT INTO zajp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ham'vitanga kamba kinhu chochose kingila mmulomo, chokwingila mmunda, abaho, cholawa hanze ya ulukuli? ");
INSERT INTO zajp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ila mbuli zilawa mmulomo, zolawa muna umoyo, na mbuli zino zizo zimtenda munhu yanyolodoke. ");
INSERT INTO zajp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kwavija kulawa mmoyo zolawa ngelegeza zihile, kukoma, ugoni, ushalati, ubavi, usindila wa uvwizi, na kuilonga vihile. ");
INSERT INTO zajp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gano gago gomtenda munhu yanyolodoke, ila kuja bila kusuluza makono, hakumtenda munhu yanyolodoke.” ");
INSERT INTO zajp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu kahalawa hanhu haja, kachola kuziisi za Tilo na Sidoni. ");
INSERT INTO zajp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na mtwanzi imwe Mkanaani, kulawa muisi ija, kamcholela. Kenula dizwi, kamulongela, “Mndewa, Mwana wa Daudi, nyonela bazi! Mndele wangu kogazigwa ng'hani na kinyamkela.” ");
INSERT INTO zajp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ila Yesu hamwidike. Wanahina zake wamcholela wamuyalalila, wolonga, “Muleke yachole! Kwavija kotutoela nyangi kuchugu chetu!” ");
INSERT INTO zajp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu kalonga, “Nie nitumigwa sama ya ng'hondolo wapotele wa isi ya Islaeli.” ");
INSERT INTO zajp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ija mtwanzi kamcholela Yesu na kumfugamila mavindi kamulongela, “Mndewa, nhaza!” ");
INSERT INTO zajp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu kedika, “Havilumbile kusola mandia ga wana na kuwasila umbwa.” ");
INSERT INTO zajp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ija mtwanzi kamulongela, “Ona, Mndewa, ila hata umbwa woja mandia gasigale galagale hasi kulawa haimeza ya mndewa wao.” ");
INSERT INTO zajp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Abaho, Yesu kamulongela, “Gweye mtwanzi, nhamanila yako ng'hulu! Na iwe kumwako kamba vuulonda.” Na kipigiti kikija mndele wake kahona. ");
INSERT INTO zajp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu kahalawa haja, kabita mumgwazo wa Idilamba da Galilaya. Kakwela hakigongo, kakala hasi. ");
INSERT INTO zajp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Wanhu bwando wamcholela, wamgalila walemale, vimbugumbugu, mbetembete, bubui, na wayagwe bwando, na kuweka haulongozi wa Yesu, na heyo kawahonya. ");
INSERT INTO zajp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wanhu wakanganya viwawawene mabubui wolonga, walemale wahonyigwa, mbetembete wotembela, na vimbugumbugu wolola. Wamuyenzi Mulungu wa Islaeli. ");
INSERT INTO zajp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu kawakema wanahina zake kawalongela, “Nowonela bazi wanhu wano, kwavija wakala na nie mazua madatu na sambi wabule kinhu cha kuja kisigale. Na nie silonda niwaleke wachole na nzala, sambiweze kusinduka mnzila.” ");
INSERT INTO zajp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wanahina zake wamulongela, “Kwahi kondatupate mandia ga kuwegutiza wanhu bwando kamba wano mkiwala kino?” ");
INSERT INTO zajp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu kawauza, “Mikate mingahi imulinayo?” Wamulongela, “Mikate saba na visomba vidogodogo.” ");
INSERT INTO zajp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Avo Yesu kawalagiza waja iwanhu wakale hasi. ");
INSERT INTO zajp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kaisola imikate saba na ivisomba, kamuheweza Mulungu, abaho, kaimogola na kuwagwelela wanahina, na wanahina wadigwelela didale da wanhu. ");
INSERT INTO zajp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wose waja na kwiguta. Abaho, wanahina wadondola vidanga va imikate na ivisomba visigale, wamemeza migelo saba. ");
INSERT INTO zajp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wanhu wose wadile wakala wambigalo alufu nne uhaleka watwanzi na wana. ");
INSERT INTO zajp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu viyeshile kudilaga didale da wanhu, kakwela muna ingalawa, kachola kuisi ya Magadani. ");
INSERT INTO zajp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafalisayo na Masadukayo wamcholela Yesu, wamgeza mkumulonda yawalagusile kilaguso kulawa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu kawedika, “Ihavika ichungulo, molonga, ‘Kowa na mchesa, kwavija ulanga mdung'hu.’ ");
INSERT INTO zajp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na imitondo molonga, ‘Lelo kowa na mvula, kwavija ulanga una udung'hu na utitu.’ Mweye movitanga kuzuza vinhu vikoneka kuulanga, ila hamudahile kuzuza vilaguso va vipigiti vino! ");
INSERT INTO zajp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mulelo wihile na uleka kumtamanila Mulungu! Wolonda kilaguso! Ila hawagweleligwa kilaguso, ila kilaguso cha muhokozi Yona.” Abaho, Yesu kawaleka, kachola. ");
INSERT INTO zajp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wanahina viwavikile mwambu uyagwe wa idilamba, wavitanga kamba waisemwa kusola mikate. ");
INSERT INTO zajp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu kawalongela, “Loleni na muiteganye na mela da Mafalisayo na Masadukayo.” ");
INSERT INTO zajp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wailongela wenyego kwa wenyego, wolonga, “Kalonga vino kwavija tuleka kusola mikate.” ");
INSERT INTO zajp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu kagatanga gaja gawakalile wolonga, na heyo kawalongela, “Mweye wanhu muli na nhamanila ndodo, habali mulongelela mbuli za kuwa bule mikate? ");
INSERT INTO zajp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mng'hali hamnavitanga? Muisemwa ija imikate mitano iwadile wambigalo alufu tano, na mkunzanya vigelo vingahi vimemile? ");
INSERT INTO zajp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ama ija imikate saba iwadile wambigalo alufu nne, na mkunzanya migelo mingahi imemile? ");
INSERT INTO zajp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Vilihi ham'vitanga kamba sikalile nilonga na mweye mmbuli ya mikate? Iteganyeni na mela da Mafalisayo na Masadukayo!” ");
INSERT INTO zajp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Abaho, wavitanga kamba Yesu hakalile yowazuma waiteganye na mela da kugela mmikate, ila waiteganye na mafundo ga Mafalisayo na Masadukayo. ");
INSERT INTO zajp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu kachola kuisi ili behi na wambo da Kaisalia Filipi, kawauza wanahina zake, “Wanhu wolonga kamba Mwana wa Munhu iyo yalihi?” ");
INSERT INTO zajp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wamwidika wamulongela, “Wayagwe wolonga Yohana M'batiza, wayagwe wolonga Eliya, na wayagwe wolonga Yelemia ama imwe wa wahokozi.” ");
INSERT INTO zajp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu kawauza, “Ila na mweye molonga nie iyo yalihi?” ");
INSERT INTO zajp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petulo kamwidika, “Gweye iyo Kilisto, Mwana wa Mulungu yali na ugima.” ");
INSERT INTO zajp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu kamulongela, “Kumota Simoni, mwana wa Yohana! Kwavija haduhu munhu yakugubulile gano, ila Tataangu wa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nokulongela kamba gweye iyo Petulo, na mdibwe dino nodizenga kanisa jangu, na mhiko za kuzimu hazidaha kudihuma. ");
INSERT INTO zajp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nokugwelela vivugulilo va Undewa wa Kuulanga, chochose chondaukifunge muna iisi, chofungigwa kuulanga. Na chochose chondaukifungule muna iisi, chofunguligwa kuulanga.” ");
INSERT INTO zajp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Abaho, Yesu kawazuma wanahina zake kamba sambiwamulongele munhu yoyose kamba heyo iyo Kilisto. ");
INSERT INTO zajp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Songela kipigiti kija Yesu kasonga kuwalongela wanahina zake, “Nolondigwa nichole Yelusalemu, na hiko nogazigwa na wavyele, na wakulu wa wakulu wa nhambiko, na wafundiza Malagizo ga Musa. Nokomigwa, ila gahabita mazua madatu nozuka kulawa mkudanganhika.” ");
INSERT INTO zajp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petulo kamsola kamgala hamgwazo na kusonga kumkomhokela yolonga, “Sambiiwe vino, Mndewa! Mbuli hiyo haikulawila gweye!” ");
INSERT INTO zajp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu kahinduka kamulongela Petulo, “Bwela kuchugu changu, Mwenembago! Gweye kwa king'hwaso kumwangu nie, kwavija hugelegeza ga Mulungu, ila kogelegeza ga wanhu.” ");
INSERT INTO zajp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Abaho, Yesu kawalongela wanahina zake, “Kamba munhu yahalonda kuwa mwanahina wangu, yaibele mwenyego, yaidikwe msalaba wake yanikoleleze. ");
INSERT INTO zajp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Munhu yoyose yahalonda kuukombola ugima wake, kowagiza, na munhu yoyose yowagiza ugima wake sama yangu nie, koukombola. ");
INSERT INTO zajp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kinhu chaki kinogile munhu chondayakipate kamba yahaupata ulumwengu wose, na kuwagiza ugima wake uli muloho? Ama kinhu chaki chondayalave giladi yabwezelwe ugima wake uli muloho? ");
INSERT INTO zajp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kwavija nie, Mwana wa Munhu, nokwiza na wasenga zangu wa Mulungu wa kuulanga muna iyenzi ya Tataangu, abaho, nomuliha kila munhu kamba vija viyasang'hane. ");
INSERT INTO zajp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nowalongela ikweli, hana wanhu wayagwe wemile hano hawadanganhika mbaka vondawanyone nie Mwana wa Munhu, nikwiza muna Uundewa wangu.” ");
INSERT INTO zajp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Vigabitile mazua sita Yesu kawasola Petulo, Yakobo, na Yohana ndugu yake Yakobo kakwela nao kukigongo kitali weiyeka. ");
INSERT INTO zajp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yesu kagaluka haulongozi wao, na kihanga chake kinang'hazika kamba zua, na vivalo vake vikala vizelu kamba mulangaza. ");
INSERT INTO zajp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Bahaja, walawililwa na Musa na Eliya, wolonga na Yesu. ");
INSERT INTO zajp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petulo kamulongela Yesu, “Mndewa, vinoga tweye tukale hano! Na uhalonda nozenga vizewe vidatu, kimwe chako, kimwe cha Musa, na kiyagwe cha Eliya.” ");
INSERT INTO zajp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Viyakalile yang'hali yolonga, wingu zelu diwagubika, na dihulikwa dizwi kulawa mdiwingu dilonga, “Ino iyo Mwanangu yanogele, mtegelezeni heyo!” ");
INSERT INTO zajp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wanahina viwahulike vino, wagwa kingubanguba, wona bwembwe ng'hani. ");
INSERT INTO zajp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu kawacholela, abaho, kawakwasa kawalongela, “Gandamukeni, sambimdumbe!” ");
INSERT INTO zajp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Na viwalolile uchana, hawamuwene munhu yoyose ila Yesu yeiyeka. ");
INSERT INTO zajp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Viwahumuluke haikigongo, Yesu kawalagiza yolonga, “Sambimmulongele munhu yoyose gaja gamgawene, mbaka nie, Mwana wa Munhu, vondanizuke kulawa mkudanganhika.” ");
INSERT INTO zajp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Abaho, wanahina wamuuza Yesu, “Habali wafundiza Malagizo ga Musa wolonga kamba tanhu Eliya yeze?” ");
INSERT INTO zajp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu kawalongela, “Kweli, Eliya kokwiza kwika goya vinhu vose. ");
INSERT INTO zajp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ila nowalongela, Eliya keza kesha, na hewo hawamtambule, ila wamtendela vija viwalondile. Vivija na heyo Mwana wa Munhu kogazigwa mmakono gao.” ");
INSERT INTO zajp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Abaho, wanahina wavitanga kamba kakala yowalongela mbuli za Yohana M'batiza. ");
INSERT INTO zajp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Viwavikile hana ididale da wanhu, munhu imwe kamcholela Yesu kamfugamila mavindi, ");
INSERT INTO zajp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","kamulongela, “Mndewa, monele bazi mmhale wangu, kwavija kana kisango na kugazika ng'hani. Mianza bwando kalagalila hamoto ama mgamazi. ");
INSERT INTO zajp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nimgala ha wanahina zako, ila walemelwa kumuhonya.” ");
INSERT INTO zajp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu kawalongela, “Mweye wanhu mwihile, mulibule nhamanila, nokala na mweye mbaka zua jaki? Nowazaganya mbaka zua jaki? Mgaleni hano hamwangu!” ");
INSERT INTO zajp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu kamkomhokela ija ikinyamkela, na ikinyamkela kamulawa immhale, na heyo kipigiti kikija kahona. ");
INSERT INTO zajp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Abaho, wanahina wamwizila Yesu kinyele, wamuuza, “Habali tweye tulemelwa kumuwinga?” ");
INSERT INTO zajp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu kawalongela, “Kwavija muhungukilwa na nhamanila! Nowalongela ikweli, kamba muhawa na nhamanila ndodo kamba mbeyu ya haladali, modaha kukilongela kigongo kino, ‘Segela hano uchole haja!’ Na ikigongo chosegela. Haduhu kinhu chochose chondamulemelwe kutenda!” ");
INSERT INTO zajp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ila kinyamkela kamba ino havidahika kulawa, ila mkutambika na kufunga. ");
INSERT INTO zajp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wanahina viwaiting'hane hamoja ako Galilaya, Yesu kawalongela, “nie, Mwana wa Munhu, nogeligwa mmakono ga wanhu, ");
INSERT INTO zajp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","wonikoma, ila gahabita mazua madatu nozuka.” Wanahina wanyunguala ng'hani. ");
INSERT INTO zajp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu na wanahina zake viwavikile Kapenaumu, wawila kodi wa Ng'anda ya Mulungu wamcholela Petulo wamuuza, “Mkulufunzi wako kalihaga kodi ya Ng'anda ya Mulungu?” ");
INSERT INTO zajp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petulo kawedika, “Ona, kalihaga.” Petulo viyengile mng'anda, Yesu kakala waichanduso kulonga nayo, “Simoni, gweye kokonaze? Wandewa wa isi wowila kodi kulawa ha wanhu walihi? Kulawa ha wenekae ama kulawa ha wahenza?” ");
INSERT INTO zajp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petulo kamulongela, “Kulawa ha wahenza.” Abaho, Yesu kamulongela, “Kulonga goya, kwavija wenekae hawalondigwa kuliha kodi. ");
INSERT INTO zajp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Giladi sambituwagevuze, avo genda hana dilamba ukase nduwano, abaho, msole somba yondayalongole kunamata, na uhaunanazula mulomo wake, kovika hela, abaho, isole ukanilihile nie na gweye mwenyego.” ");
INSERT INTO zajp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kipigiti kija wanahina wamcholela Yesu wamuuza, “Yalihi yali mkulu kubanza wose muna Uundewa wa Kuulanga?” ");
INSERT INTO zajp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu kamkema mwana mdodo, abaho, kamwika haulongozi wao, ");
INSERT INTO zajp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","kalonga, “Nowalongela ikweli, ihawa hamulonda kugaluka na kulinga kamba wana wadodo, hamdaha kwingila muna Uundewa wa Kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Munhu yoyose yokiihumulusa kamba mwana ino, iyo mkulu kubanza wose muna Uundewa wa Kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na munhu yoyose yom'bokela mwana mdodo kamba ino mtwaga jangu, konibokela nie. ");
INSERT INTO zajp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ihawa munhu yoyose yahamtenda imwe wa wanhu wano wadodo yatende vilozo, vihanogile munhu hiyo yafungigwe msingo yake dibwe kulu da kusiginhila na kwasigwa mkilindi cha bahali. ");
INSERT INTO zajp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ulumwengu wojona sama ya ving'hwaso viwatenda wanhu wengile m'vilozo! Kwavija ving'hwaso havidahika kuleka kulawilila, ila kojona munhu ija yotenda ving'hwaso vilawilile! ");
INSERT INTO zajp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ihawa mkono wako ama mgulu wako wokutenda utende vilozo, ukanhe, uwase kutali na gweye! Vinoga wingile muna ugima wa digunge kuno ulemale ama uli mbetembete, kubanza kuwa na makono mabili ama magulu mabili, abaho, wasigwe muna umoto wa digunge. ");
INSERT INTO zajp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na kamba siso jako dokutenda utende vilozo, ding'ole, ujase! Vinoga wingile muna uugima wa digunge na siso dimwe, kubanza kuwa na meso mabili, abaho, wasigwe muna umoto wa kuzimu. ");
INSERT INTO zajp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Teganyeni! Sambimumzabuze imwe wa wanhu wano wadodo. Nowalongela kamba, wasenga wa Mulungu wa kuulanga wali hamoja nao mazua gose wa behi na Tataangu wa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kwavija Mwana wa Munhu keza kuwakombola waja wapotele. ");
INSERT INTO zajp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mokonaze, kamba munhu yahawa na ng'hondolo mia, abaho, ng'hondolo imwe yahapotela, vino hawaleka waja ng'hondolo malongo tisa na tisa wasigale mkigongo na kuchola kumzahila ija ng'hondolo imwe yapotele? ");
INSERT INTO zajp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nowalongela ikweli, kamba yahamona, komdeng'hela ng'hani kubanza waja ng'hondolo malongo tisa na tisa walekile kupotela. ");
INSERT INTO zajp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Vivija na Tata wenu wa kuulanga halonda hata munhu imwe wa wano wadodo yapotele. ");
INSERT INTO zajp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ihawa ndugu yako kakutenda gehile, genda ukamulongele kija kinhu kihile chayakutendile muli wabili mwiyeka. Na kamba kokutegeleza, kumpata kabili ndugu yako. ");
INSERT INTO zajp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ila kamba hakutegeleze, msole munhu imwe ama wabili wayagwe hamoja na gweye, giladi mmbuli za wasindila wabili ama wadatu kila kinhu kitangigwe. ");
INSERT INTO zajp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na kamba hawategeleze, walongele wanhu wamtogole Kilisto, na vivija yahalema kuwategeleza, avo umone kamba Mmhazi na muwila kodi. ");
INSERT INTO zajp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nowalongela ikweli, chochose chondamkifunge muna iisi, chofungigwa kuulanga. Na chochose chondamkifungule muna iisi, chofunguligwa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Vivija, nowalongela ikweli, kamba wabili mmwanza wenu muna iisi wahaitogolela mmbuli ya kinhu chochose chowopula, wotendeligwa na Tataangu wa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwavija hawali wabili ama wadatu waiting'hane mtwaga jangu, na nie na hamoja nao.” ");
INSERT INTO zajp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Abaho, Petulo kamcholela Yesu kamuuza, “Mndewa, kamba ndugu yangu yahanitenda vilozo, nimgele kumgongo mianza mingahi? Hata mianza saba?” ");
INSERT INTO zajp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu kamulongela, “Sikulongela mianza saba, ila mianza malongo saba mala saba. ");
INSERT INTO zajp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwavija Undewa wa Kuulanga ulinga na mndewa imwe yalondile kuwakagula watumigwa zake wakalile wamkopile hela. ");
INSERT INTO zajp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Viyasongile kukagula, kagaliligwa munhu yakalile yowilwa talanta alufu longo dimwe. ");
INSERT INTO zajp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ija imtumigwa hakalile na cha kuliha, avo mndewa kalagiza kamba yaguzwe heyo na mtwanzi wake na wanage na kila kinhu kiyali nacho, giladi yalihe hela ziyakalile yowilwa. ");
INSERT INTO zajp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Avo ija imtumigwa kamfugamila mavindi kamuyalalila kamulongela, ‘Mndewa, nyalize, nokuliha hela zako zose!’ ");
INSERT INTO zajp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mndewa wa imtumigwa ija kamonela bazi, avo kamgela kumgongo deni jake jose, abaho, kamuleka yachole. ");
INSERT INTO zajp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Abaho, ija imunhu viyacholile, kaiting'hana na mtumigwa miyage yakalile yomuwila dinali mia. Kamgoga na kusonga kumfida msingo, kalonga, ‘Nilihe deni jangu!’ ");
INSERT INTO zajp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ija imtumigwa miyage kamfugamila mavindi kamuyalalila kamulongela, ‘Nyalize, nokuliha deni jako jose!’ ");
INSERT INTO zajp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ila heyo kalema, avo kachola, kamgela mkifungo mbaka vondayalihe hela zose ziyakalile yowilwa. ");
INSERT INTO zajp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Watumigwa wayage viwawene gaja galawilile, wona giogio, avo wachola, wamulongela mndewa wao mbuli zose zilawilile. ");
INSERT INTO zajp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Abaho, ija imndewa kamkema kamulongela, ‘Gweye kwa mtumigwa wihile! Nie nikugela kumgongo deni jako jose kwavija vuuniyalalile. ");
INSERT INTO zajp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Vino hulondigwe na gweye kumonela bazi mtumigwa miyago kamba nie vinikonele bazi?’ ");
INSERT INTO zajp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mndewa wake kona lusango, avo kamgoga, kamgela mkifungo mbaka vondayalihe dideni. ");
INSERT INTO zajp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Vino vivo Tataangu wa kuulanga vondayawatende mweye ahaja munhu mmwanza wenu yahalema kumgela kumgongo ndugu yake, kulawa mmoyo wake.” ");
INSERT INTO zajp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu viyamambukize kulonga mbuli zino, kalawa Galilaya kachola kuna iisi ya Yudea mwambu uyagwe wa Ulwanda lwa Yolodani. ");
INSERT INTO zajp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Wanhu bwando wamkweleleza, na heyo kawahonya hiko. ");
INSERT INTO zajp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafalisayo wamcholela na kumgeza mkumuuza, “Malagizo ga Musa gomtogoza munhu kumwasa mtwanzi wake mmbuli yoyose?” ");
INSERT INTO zajp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu kawedika, “Vino, hamsomile Mzinyandiko Zing'alile? Ahaja hazilonga kamba haichanduso Mulungu kawalumba mtwanzi na mbigalo. ");
INSERT INTO zajp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na heyo kalonga, ‘Mkilamso kino mbigalo kowaleka tataake na mamaake na kuilumba na mwehe wake, na wabili wano wowa lukuli lumwe.’ ");
INSERT INTO zajp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Avo sio wabili, ila lukuli lumwe. Kwavija kiyalumbile Mulungu, haduhu munhu yondayakimamazule.” ");
INSERT INTO zajp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mafalisayo wamuuza, “Habali Musa kalonga Mmalagizo gake kamba munhu kodaha kumgwelela mtwanzi wake lupwilili lwa nyasa na kumwasa?” ");
INSERT INTO zajp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu kawalongela, “Musa kawatogoza muwase watwanzi zenu sama ya udala wa mioyo yenu. Ila haikalile vino songela haichanduso. ");
INSERT INTO zajp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nowalongela kamba, mbigalo yoyose yomwasa mtwanzi wake na kumsola mtwanzi iyagwe kotenda ugoni. Ila munhu yahamwasa mtwanzi wake sama ya kutenda ugoni kodaha kusola mtwanzi iyagwe.” ");
INSERT INTO zajp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wanahina zake wamulongela, “Ihawa vino vivo ili ha mbigalo na mtwanzi wake, vinoga kuleka kusola.” ");
INSERT INTO zajp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu kawedika kawalongela, “Sio wanhu wose wodaha kuitogola mbuli ino, ila ha waja wose wagweleligwe motelo ino na Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kwavija hana vibohola wali hivo songela viwavumbuke, na hana vibohola watendigwe na wanhu, na wayagwe woleka kusola sama ya Undewa wa Kuulanga. Munhu yodaha kugabokela gano, yagabokele.” ");
INSERT INTO zajp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Abaho, wana wadodo wagaligwa ha Yesu giladi yawekile makono na kuwatambikila, ila wanahina wawakomhokela waja wawagalile. ");
INSERT INTO zajp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu kalonga, “Walekeni wana wadodo weze kumwangu, sambimuwagomese, kwavija Undewa wa Kuulanga uli wa wanhu wali kamba wano.” ");
INSERT INTO zajp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Avo, kawekila makono gake kuwamoteza, abaho, kachola. ");
INSERT INTO zajp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Baho mmhale imwe kamcholela Yesu kamuuza, “Mkulufunzi, nitende kinhu chaki kinogile giladi ningile muugima wa digunge?” ");
INSERT INTO zajp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu kamwidika, “Habali uniuza mbuli ya kinhu kinogile? Hana imwe yeiyeka iyo yanogile. Uhalonda kwingila muugima wa digunge, zigoge ndagizi za Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ija immhale kauza, “Ndagizi zaki?” Yesu kamwidika, “Sambiukome, sambiutende ugoni, sambiwibe, sambiulave usindila wa uvwizi, ");
INSERT INTO zajp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","wahishimile tataako na mamaako, na mnogele munhu wa habehi nagwe kamba vuukinogela mwenyego.” ");
INSERT INTO zajp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ija immhale kedika, kamulongela, “Gano gose nigagoga, nisigaza kinhu chaki?” ");
INSERT INTO zajp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu kamwidika, “Uhalonda sambiuhungule hanhu, genda kaguze vinhu vako, abaho, zihela uwagwelele wakumbulu, avo kowa na ngama kuulanga, abaho, izo unikoleleze.” ");
INSERT INTO zajp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ija immhale viyahulike vino, kachola kuno yokona giogio, kwavija kakala mgoli. ");
INSERT INTO zajp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Abaho, Yesu kawalongela wanahina zake, “Nowalongela ikweli, yowa vidala mgoli kwingila muna Undewa wa Kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nowalongela mwanza uyagwe, vibuha ngamia kubita mkizonzo cha shindano, kubanza mgoli kwingila Muundewa wa Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wanahina viwahulike vino, wakanganya ng'hani na kuuza, “Avo, yalihi yodaha kukomboligwa?” ");
INSERT INTO zajp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu kawalola kalonga, “Mwa wanhu mbuli ino haidahika, ila ha Mulungu mbuli zose zodahika.” ");
INSERT INTO zajp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Abaho, Petulo kedika, kalonga, “Tweye tuleka kila kinhu tukukoleleza gweye, avo, kwiza topata choni?” ");
INSERT INTO zajp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu kawalongela, “Nowalongela ikweli, mweye mose mung'holeleze nie, muna uulumwengu wa sambi, Mwana wa Munhu vondayakale mkigoda chake cha undewa kili na yenzi, vivija na mweye mokala m'vigoda va undewa longo dimwe na vibili, muitagusa mitala longo dimwe na mibili ya Islaeli. ");
INSERT INTO zajp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na munhu yoyose yoleka ng'anda ama ndugu ama lumbu ama tata ama mama ama wana ama migunda sama yangu, kobokela mianza mia na kuuhala ugima wa digunge. ");
INSERT INTO zajp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ila wanhu bwando wali wa haichanduso, wowa wa haikimambukizo, na wanhu bwando wali wa haikimambukizo, wowa wa haichanduso. ");
INSERT INTO zajp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Kwavija Undewa wa Kuulanga ulinga na munhu yalawile ulukwili kuchola kuzahila wanhu wa kusang'hanika mumgunda wake wa mizabibu. ");
INSERT INTO zajp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Waitogolela yawalihe dinali mdizua dimwe, abaho, kawatuma kusang'hanika mumgunda wake wa mizabibu. ");
INSERT INTO zajp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mkipigiti cha saa ndatu kachola kabili, kawona wanhu wayagwe wemile hadisoko walibule sang'hano ya kutenda, ");
INSERT INTO zajp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","avo kawalongela, ‘Na mweye gendeni mkasang'hanike mumgunda wa mizabibu, nowaliha kilondigwa kulihigwa.’ ");
INSERT INTO zajp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Avo wachola. Mkipigiti cha saa sita na saa tisa kachola kabili, katenda vivija. ");
INSERT INTO zajp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na mkipigiti cha saa longo dimwe na imwe, kachola na kuwavika wanhu wayagwe wema, avo kawauza, ‘Habali mwimile hano songela imitondo bila kutenda sang'hano yoyose?’ ");
INSERT INTO zajp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Waja wanhu wamulongela, ‘Kwavija haduhu munhu yatugwelele sang'hano ya kutenda.’ Ija imunhu kawalongela, ‘Gendeni na mweye mkasang'hanike mumgunda wa mizabibu.’ ");
INSERT INTO zajp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Viivikile ichungulo, mwene mgunda kamulongela salange wake, ‘Wakeme wasang'hana, abaho, walihe maliho gao, songa na waja wasongile kusang'hanika ichungulo, abaho, umambukizile na waja wasongile kusang'hanika imitondo.’ ");
INSERT INTO zajp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Na waja wose wasongile kusang'hanika ichungulo, kila munhu kalihigwa dinali. ");
INSERT INTO zajp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Viwezile waja wasongile kusang'hanika imitondo, wagiza kamba wolihigwa dinali bwando, ila vivija na hewo walihigwa dinali imwe kila munhu. ");
INSERT INTO zajp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wabokela dinali zao, abaho, wasonga kumtwanganikila mwene mgunda, ");
INSERT INTO zajp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","walonga, ‘Wanhu wano wa ikimambukizo wasang'hanika saa dimwe diiyeka, ila kuwaliha kamba vuutulihile tweye tusang'hanike mdizua kali na kugaya misi yose!’ ");
INSERT INTO zajp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mwene mgunda kamwidika munhu imwe mmwanza wao, kalonga, ‘Mbwiga, sikutendele kinhu chochose kihile! Hatuitogolele kusang'hanika mdizua dimwe kwa dinali imwe? ");
INSERT INTO zajp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Sola maliho gako uchole. Nisagula kumgwelela ino waikimambukizo kamba vinikugwelele gweye. ");
INSERT INTO zajp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Vino sidaha kutenda vija vinilonda na hela zangu mwenyego? Ama kokona migongo kwavija vinili na moyo unogile?’ ");
INSERT INTO zajp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Avo, wali wa haikimambukizo wowa wa haichanduso, na wali wa haichanduso wowa wa haikimambukizo.” ");
INSERT INTO zajp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu viyakalile yochola Yelusalemu, mnzila kawasola wanahina longo dimwe na wabili hamgwazo weiyeka, na kuwalongela, ");
INSERT INTO zajp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tochola Yelusalemu, na Mwana wa Munhu kogeligwa mmakono ga wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa. Womtagusa kudanganhika, ");
INSERT INTO zajp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","abaho, kogeligwa mmakono ga Wamhazi, womtendela uponela, womulanha mbalati, na womuwamba mumsalaba, ila mdizua da ikadatu kozuka.” ");
INSERT INTO zajp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Abaho, mama wa wana wa Zebedayo kamcholela Yesu hamoja na wanage, kamfugamila mavindi giladi yapule kinhu. ");
INSERT INTO zajp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu kamulongela, “Kolonda choni?” Ija imtwanzi kamwidika yolonga, “Lagiza kamba wanangu wano wabili, imwe yakale mkono wako wa ukulume na iyagwe yakale mkono wako wa ukumoso muna Undewa wako.” ");
INSERT INTO zajp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu kawalongela, “Hammanyile kinhu chumpula. Modaha kuking'wela kikasi cha mgayo kinilondigwa kuking'wela nie?” Wamwidika walonga, “Todaha.” ");
INSERT INTO zajp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu kawalongela, “Moking'wela kikasi cha migayo kining'wela nie, ila kukala kumkono wangu wa ukulume na wa ukumoso sio sang'hano yangu. Ila hanhu aho wekiligwa waja wose watandiligwe na Tataangu.” ");
INSERT INTO zajp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wanahina wayagwe longo dimwe viwahulike vino, wawonela lusango Yakobo na Yohana. ");
INSERT INTO zajp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ila Yesu kawakema hamoja kawalongela, “Movitanga kamba wandewa wa Wamhazi wowatawala na mhiko, na wakulu zao wana udaho mwa wanhu zao. ");
INSERT INTO zajp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sambiiwe vino kumwenu. Ila munhu yoyose mmwanza wenu yahalonda kuwa mkulu, kolondigwa yawe mtumigwa wenu. ");
INSERT INTO zajp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na munhu yoyose mmwanza wenu yahalonda kuwa waichanduso, kolondigwa yawe nyakadala wenu. ");
INSERT INTO zajp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kwavija Mwana wa Munhu hezile kusang'hanikilwa, ila kusang'hanikila wayagwe, na kulava ugima wake giladi yawakombole wanhu bwando.” ");
INSERT INTO zajp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu na wanahina zake viwasegele Yeliko, wanhu bwando wamkweleleza. ");
INSERT INTO zajp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Haja kukala na vimbugumbugu wabili wakalile hamgwazo wa inzila, na viwahulike kamba Yesu kobita, wenula dizwi, walonga, “Mndewa, Mwana wa Daudi, tonele bazi!” ");
INSERT INTO zajp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Didale da wanhu diwakomhokela na kuwalongela wanyamale. Ila wagendelela kwinula dizwi, wolonga, “Mndewa, Mwana wa Daudi, tonele bazi!” ");
INSERT INTO zajp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu kema, abaho, kawakema kawauza, “Molonda niwatendele choni?” ");
INSERT INTO zajp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wamulongela, “Mndewa, tolonda tulole!” ");
INSERT INTO zajp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu kawonela bazi, kagakwasa meso gao. Bahaja wadaha kulola, abaho, wamkweleleza. ");
INSERT INTO zajp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na wanahina zake viwakalile behi na kuvika Yelusalemu, wavika mkiwambo cha Betifage hana Ikigongo cha Mizaituni, Yesu kawatuma wanahina zake wabili, ");
INSERT INTO zajp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kawalongela, “Gendeni hana ikiwambo kili haulongozi wenu, baho mom'vika mhunda yafungigwe hamoja na mwanage. Wafunguleni, abaho, munigalile. ");
INSERT INTO zajp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na kamba munhu yoyose yahawauza, mulongeleni kamba, ‘Mndewa kowalonda.’ Na himahima kowagwelela.” ");
INSERT INTO zajp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Gano galawilila giladi gavikile gaja galongigwe na muhokozi, yolonga, ");
INSERT INTO zajp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mulongele mndele wa Sayuni, ‘Lola, Mndewa wako kokwizila! Kahola moyo na kapapigwa na mhunda, mwana wa mhunda.’ ” ");
INSERT INTO zajp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Avo, wanahina wachola na watenda kamba Yesu viyawalongele. ");
INSERT INTO zajp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wamgala imhunda na mwana wa mhunda, watandika vivalo vao uchana yao, abaho, Yesu kakala uchana ya imwana mhunda. ");
INSERT INTO zajp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dale kulu ng'hani da wanhu janzanza vivalo vao mnzila, na wayagwe wakanha mikuti ya mitende na kuyanzanza mnzila. ");
INSERT INTO zajp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dale da wanhu dikalile dimulongole na wose wakalile wamsondolele wenula dizwi walonga, “Yatogolwe Mwana wa Daudi! Kamota ayo yokwiza mditwaga da Mndewa! Nhogolwa uchana kuulanga!” ");
INSERT INTO zajp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu viyengile Yelusalemu, wambo jose dikala mumzahimzahi, na wanhu wauza, “Ino iyo munhu yalihi?” ");
INSERT INTO zajp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Didale da wanhu diwalongela, “Ino iyo Yesu, muhokozi kulawa Nazaleti mkiwambo cha Galilaya.” ");
INSERT INTO zajp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu kengila mdikonhi da Ing'anda ya Mulungu na kuwawinga wanhu wose wakalile muja woguza na kugula. Kazihindula meza za wavunja hela na vigoda va wose wakalile woguza njiwa, ");
INSERT INTO zajp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","kawalongela, “Yandikigwa Mzinyandiko Zing'alile, ‘Ng'anda yangu yokemigwa ng'anda ya nhambiko.’ Ila mweye moitenda fisilo da wabavi!” ");
INSERT INTO zajp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Vimbugumbugu na walemale wamcholela kuna Ing'anda ya Mulungu, na heyo kawahonya. ");
INSERT INTO zajp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ila wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa viwonile vinhu va mkanganyo viyatendile, na wana wotoa nyangi kuna Ing'anda ya Mulungu wolonga, “Yatogolwe Mwana wa Daudi!” wona lusango. ");
INSERT INTO zajp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Wamulongela, “Kowahulika wano vowolonga?” Yesu kawalongela, “Ona! Hamsomile gaja gandikigwe Mzinyandko Zing'alile, golonga, ‘Wana wadodo na ving'hele, wokwimba nyila za nhogolwa’?” ");
INSERT INTO zajp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kawaleka, kachola hanze ya idiwambo mbaka Betania, kawasa hiko. ");
INSERT INTO zajp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Imitondo ng'hani Yesu viyakalile mnzila yobwela mdiwambo, kona nzala. ");
INSERT INTO zajp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kawona mtini hamgwazo wa inzila, kaukwenhukila, ila honile chochose uchana yake ila mijani iiyeka. Abaho, kaulongela, “Sambiulele mujo milao yose!” Bahaja umtini unyala. ");
INSERT INTO zajp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wanahina viwawene vino wakanganya, wauza, “Habali umtini unyala himahima?” ");
INSERT INTO zajp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu kawedika, yolonga, “Nowalongela ikweli, kamba muhawa na nhamanila bila kusinha mmioyo yenu, sio kamba modaha kutenda kija kitendigwe mumtini uno, ila vivija modaha kukilongela kigongo kino, ‘Goboka, uiyase m'bahali,’ na yotendeka. ");
INSERT INTO zajp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kamba muhawa na nhamanila, chochose chondampule mkutambika, mogweleligwa.” ");
INSERT INTO zajp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu viyengile muna Ing'anda ya Mulungu, wakulu wa wakulu wa nhambiko na wavyele wa wanhu wamcholela kipigiti viyakalile yofundiza, wamuuza, “Kotenda mbuli zino na udaho ulihi? Na yalihi yakugwelele udaho uno?” ");
INSERT INTO zajp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu kawalongela, “Vivija na nie nowauza mbuli, na kamba muhanilongela nhegulo yake, na nie nowalongela kamba notenda mbuli zino na udaho ulihi. ");
INSERT INTO zajp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mbatiza ya Yohana ilawa kwahi? Ilawa ha Mulungu ama ilawa ha wanhu?” Wakiiuza wenyego kwa wenyego, walonga, “Tuhalonga, ‘Ulawa ha Mulungu,’ kotuuza, ‘Habali hamumtogole?’ ");
INSERT INTO zajp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ila tuhalonga, ‘Ulawa ha wanhu,’ towadumba wanhu kwavija wanhu wose wotogola kamba Yohana kakala muhokozi.” ");
INSERT INTO zajp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Avo wamwidika Yesu, “Hatuvitanga.” Abaho, na heyo kawalongela, “Na nie siwalongela kamba notenda mbuli zino na udaho ulihi. ");
INSERT INTO zajp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mweye mokonaze? Kukala na munhu imwe yakalile na wana wabili. Kamcholela ija imkulu kamulongela, ‘Mwanangu, lelo genda ukasang'hanike mumgunda wa mizabibu.’ ");
INSERT INTO zajp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ija imwana kamwidika kamulongela, ‘Sichola,’ ila mkipigiti kidodo kagelegeza mmoyo wake, abaho, kachola. ");
INSERT INTO zajp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Abaho, kamcholela imdodo kamulongela vivija. Na heyo kamwidika kalonga, ‘Ona, nochola, tata,’ ila hacholile. ");
INSERT INTO zajp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yalihi mmwanza wa wano wabili yatendile gamnogele tataake?” Wamwidika wamulongela, “Ija imkulu.” Yesu kawalongela, “Nowalongela ikweli, wawila kodi na watenda ugoni ndwanga wowalongola kwingila muna Undewa wa Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kwavija Yohana M'batiza keza kumwenu mnzila ilibule uzenzeleganye, na mweye hamumtogole, ila wawila kodi na watenda ugoni ndwanga wamtogola. Na hata vimgawene gano, hamulekile vilozo venu na kumtogola. ");
INSERT INTO zajp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Tegelezeni hala diyagwe, kukala na munhu yakalile na mgunda wa mizabibu, kauzengela konhi na kuhimba lwingila lwa kukamulila zabibu na kuzenga ulingo. Abaho, kawapangiza walimi, kachola isi ya kutali. ");
INSERT INTO zajp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kipigiti cha kuhuna zizabibu vikivikile, kawatuma nyakadala zake ha iwalimi wakamsolele fungu jake da izizabibu. ");
INSERT INTO zajp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Iwalimi wawanwang'hula waja iwanyakadala, imwe wamtoa, iyagwe wamkoma, na iyagwe wamtoa na mabwe mbaka kadanganhika. ");
INSERT INTO zajp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Abaho, ija imunhu kawatuma mwanza uyagwe nyakadala wayagwe bwando kubanza waja wa ichanduso, na iwalimi wawatendela vivija kamba viwawatendele waja wa ichanduso. ");
INSERT INTO zajp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hakimambukizo, kamulagiza mwanage ha iwalimi, yolonga, ‘Kwa vovose womuhishimila mwanangu.’ ");
INSERT INTO zajp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ila iwalimi viwamuwene imwana, wailongela wenyego kwa wenyego, ‘Ino iyo muhazi. Izoni tumkome, abaho, tusole uhazi wake!’ ");
INSERT INTO zajp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Avo wamsola na kumwasa hanze ya umgunda wa mizabibu na kumkoma. ");
INSERT INTO zajp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Avo mwene mgunda yeheza, kowatenda choni iwalimi?” ");
INSERT INTO zajp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wamulongela, “Kowakoma wanhu waja wehile, na kuwagwelela umgunda walimi wayagwe wondawamgwelele zabibu mkipigiti cha kuhuna.” ");
INSERT INTO zajp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu kawalongela, “Hamsomile Zinyandiko Zing'alile? ‘Dibwe dilemigwe na wazenzi digaluka dibwe da kutamanilwa ng'hani kubanza mabwe gose. Mndewa iyo yatendile mbuli ino, nayo iwa mkanganyo mmeso getu!’ ");
INSERT INTO zajp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Avo nowalongela, Undewa wa Mulungu wosegezigwa kumwenu na kugweleligwa wanhu wayagwe wondawatende gamnogele Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Munhu yodilagalila dibwe dino kobeneka vidangavidanga, na munhu yoyose yondadimulagalile domsiginha lipilipi.” ");
INSERT INTO zajp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wakulu wa wakulu wa nhambiko na Mafalisayo viwahulike hala da Yesu, wavitanga kamba kowalonga hewo, ");
INSERT INTO zajp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","avo wazahila nzila ya kumgoga. Ila wadumba didale da wanhu kwavija wakala womtogola Yesu kamba muhokozi. ");
INSERT INTO zajp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu kawalongela mmahala mwanza uyagwe, yolonga, ");
INSERT INTO zajp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Undewa wa Kuulanga ulinga na mndewa yatandile lusona lwa zengele lwa mwanage. ");
INSERT INTO zajp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kawatuma nyakadala zake wakawakeme waja wagonekigwe mulusona lwa zengele, ila walema kwiza. ");
INSERT INTO zajp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Abaho, kawatuma nyakadala wayagwe, kawalongela, ‘Walongeleni wanhu wose wagonekigwe kamba nitanda mandia gangu. Ng'ombe zangu iwakulu na iwadodo wanonile wesha kuchinjigwa, na kila kinhu kisasaligwa. Izoni hana ulusona lwa zengele!’ ");
INSERT INTO zajp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ila hawasinhuke. Wachola na zao, imwe kachola kumgunda, na iyagwe kachola kuuchuluzi wake. ");
INSERT INTO zajp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Wayagwe wawagoga nyakadala zake, wawaliga na kuwakoma. ");
INSERT INTO zajp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ija imndewa kona lusango, avo kawatuma asikali zake wawabanange waja wakomaji na kudisoma wambo jao. ");
INSERT INTO zajp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Abaho, kawalongela nyakadala zake, ‘Lusona lwa zengele lusasaligwa, ila wanhu wagonekigwe hawalumbile kuvika. ");
INSERT INTO zajp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Avo gendeni mzinzilamhanda za mkiwambo mkawagoneke wanhu wondamuwawene weze kulusona lwa zengele.’ ");
INSERT INTO zajp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Avo waja iwanyakadala wachola muna zinzila za mkiwambo na kuwalundiza wanhu wose wawavikile, wanogile na wehile, na dibugano da lusona lwa zengele dimema wahenza. ");
INSERT INTO zajp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ila ija imndewa viyengile kuwalola iwahenza, kamona munhu haja yalekile kuvala vivalo va lusona lwa zengele. ");
INSERT INTO zajp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kamuuza, ‘Mbwiga, kwingilaze hano bila vivalo va lusona lwa zengele?’ Ija imunhu kanyamala. ");
INSERT INTO zajp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Abaho, imndewa kawalongela watumigwa, ‘Mfungeni makono na magulu, abaho, mmwase kunze mdiziza. Ako kowa na kililo na kugegedula meno.’ ");
INSERT INTO zajp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Kwavija wanhu bwando wagonekigwe, ila wasaguligwe wadodo.” ");
INSERT INTO zajp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mafalisayo waiting'hana hamoja na kumwikila zundo Yesu giladi wamnamate mzimbuli zake. ");
INSERT INTO zajp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Avo, wawatuma wanahina zao hamoja na wanhu wa Helode, wolonga, “Mkulufunzi! Tuvitanga kamba gweye kwa munhu ulibule uzenzeleganye na kowafundiza wanhu ikweli ya gaja goyolonda Mulungu, bila kudumba gowogelegeza wanhu wayagwe, kwavija hulola ukulu wa munhu yoyose. ");
INSERT INTO zajp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tulongele, gweye kogesaze? Malagizo ga Musa gotogoza kuliha kodi ha Kaisali ama gogomesa?” ");
INSERT INTO zajp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ila Yesu kazitanga ngelegeza zao zihile, kalonga, “Videlenya mweye! Habali mgeza kunikila vitega? ");
INSERT INTO zajp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nilagusileni ihela ya kuliha kodi!” Na hewo wamgalila ihela, ");
INSERT INTO zajp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","abaho, kawauza, “Kihanga kino na twaga dino va munhu yalihi?” ");
INSERT INTO zajp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wamwidika, “Va Kaisali.” Avo Yesu kawalongela, “Mulonga goya, avo ga Kaisali mgweleleni Kaisali, na ga Mulungu mgweleleni Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Viwahulike vino, wakanganya, avo wamuleka, wachola na zao. ");
INSERT INTO zajp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Zua didija Masadukayo, awo wolonga kamba haduhu mzuso, wamcholela Yesu, wamuuza, ");
INSERT INTO zajp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mkulufunzi! Musa katulongela kamba, kamba munhu yahadanganhika bila kuleka mwana, ndugu yake kolondigwa yamsole ija ikizuka giladi yamulelele mwana ndugu yake yadanganhike. ");
INSERT INTO zajp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Avo kukala na ndugu saba mmwanza wetu, waichanduso kasola mtwanzi, abaho, kadanganhika bila kulela nayo mwana, abaho, ikizuka kamulekela ndugu yake. ");
INSERT INTO zajp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na ija waikabili gamulawilila gagaja, na waikadatu, na waja wose saba. ");
INSERT INTO zajp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Hakimambukizo, na ija imtwanzi kadanganhika. ");
INSERT INTO zajp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Avo mdizua da mzuso, imtwanzi ija kowa mtwanzi wa munhu yalihi? Kwavija wanhu wose saba wakala wamsolile.” ");
INSERT INTO zajp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu kawedika kawalongela, “Mweye muhonyela! Kwavija hamzitangile Zinyandiko Zing'alile ama mhiko za Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kwavija mdizua da mzuso, wanhu hawasola ama kusoligwa, ila wolinga kamba wasenga wa Mulungu wa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mmbuli ya mzuso wa wanhu wadanganhike, hamsomile Mzinyandiko Zing'alile kija kimulongeligwe na Mulungu? ");
INSERT INTO zajp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nie iyo Mulungu wa Ablaham, na Isaka, na Yakobo.’ Heyo iyo Mulungu wa wanhu wagima na sio Mulungu wa wanhu wadanganhike.” ");
INSERT INTO zajp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Didale da wanhu vidihulike gano, wakanganya mafundo gake. ");
INSERT INTO zajp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ila Mafalisayo viwahulike kamba Yesu kawavudaliza Masadukayo, waiting'hana hamoja. ");
INSERT INTO zajp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na munhu imwe mmwanza wao, yakalile mfundiza Malagizo ga Musa, kamgeza mkumuuza, ");
INSERT INTO zajp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mkulufunzi, ndagizi ilihi ili ng'hulu Mmalagizo ga Musa?” ");
INSERT INTO zajp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu kamwidika kamulongela, “ ‘Mnogele Mndewa Mulungu wako na moyo wako wose, na loho yako yose, na nzonzi zako zose.’ ");
INSERT INTO zajp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ino iyo ndagizi ili ng'hulu na iyo ya ichanduso. ");
INSERT INTO zajp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na ino iyo ndagizi ya ikabili, ‘Mnogele munhu wa habehi nagwe kamba vuukiinogela mwenyego.’ ");
INSERT INTO zajp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Malagizo gose ga Musa na mafundo ga wahokozi gotamanila ndagizi zino mbili.” ");
INSERT INTO zajp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mafalisayo viwaiting'hane hamoja, Yesu kawauza, ");
INSERT INTO zajp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mweye moigelegezaze mbuli ya Kilisto? Iyo mwana wa munhu yalihi?” Wamwidika wamulongela, “Iyo Mwana wa Daudi.” ");
INSERT INTO zajp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu kawauza, “Avo, vilihi Daudi kubitila mhiko za Loho wa Mulungu komkema Kilisto, ‘Mndewa’? ");
INSERT INTO zajp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Kwavija kalonga, ‘Mndewa kamulongela Mndewa wangu, “Kala kumkono wangu wa ukulume mbaka vondaniweke wadumuka zako hasi ya magulu gako.” ’ ");
INSERT INTO zajp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ihawa Daudi komkema Kilisto, ‘Mndewa,’ yodahikaze kuwa mwanage?” ");
INSERT INTO zajp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Haduhu munhu yadahile kumwidika mbuli yoyose, na kulawa zua dija haduhu munhu yagezile kumuuza mbuli yoyose. ");
INSERT INTO zajp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Abaho, Yesu kalonga na didale da wanhu na wanahina zake, ");
INSERT INTO zajp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Wafundiza Malagizo ga Musa na Mafalisayo wana udaho wa kugatapita Malagizo ga Musa. ");
INSERT INTO zajp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Avo, gatendeni na kugagoga gaja gose gowowafundiza mweye, ila sambimtende vija vowotenda hewo, kwavija hewo hawagatenda gaja gowofundiza. ");
INSERT INTO zajp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wowafungila wanhu mibahasha mikulu na kuwadikwa mmaega, ila hewo wenyego hawalonda hata kugolosa kidole waipape. ");
INSERT INTO zajp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Wotenda mbuli zao zose giladi woneke na wanhu. Avo, wofudika mifundo mikulu mgati yandikigwe Nyandiko za Malagizo ga Musa uchana mwa ikihanga na mmakono! Na wokwika minyemvule mitali ng'hani mmikanzu yao! ");
INSERT INTO zajp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Wonogelwa kukala m'vigoda va haulongozi mulusona na kukala m'vigoda va haulongozi mzing'anda za nhambiko, ");
INSERT INTO zajp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","na kulamsigwa na hishima mmasoko na kukemigwa, ‘Mkulufunzi.’ ");
INSERT INTO zajp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ila mweye sambimkemigwe ‘Mkulufunzi,’ kwavija muna mkulufunzi imwe, na mweye mose mwa kinhu kimwe kamba ndugu. ");
INSERT INTO zajp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na sambimumkeme munhu yoyose ‘tata’ muisi, kwavija Tataenu iyo imwe yali kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ama sambimkemigwe ‘Vilangizi,’ kwavija muna kilangizi imwe, iyo Kilisto. ");
INSERT INTO zajp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yali mkulu mmwanza wenu yawe mtumigwa wenu. ");
INSERT INTO zajp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ila yoyose yokiinula kohumuluswa, na yoyose yokiihumulusa kokwinuligwa. ");
INSERT INTO zajp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mojona, wafundiza Malagizo ga Musa na Mafalisayo, mweye videlenya! Moluhinda lwivi lwa Undewa wa Kuulanga haulongozi wa wanhu, na mweye wenyego hamwingila ama hamuwatogoza kwingila waja wolonda kwingila! ");
INSERT INTO zajp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mojona, wafundiza Malagizo ga Musa na Mafalisayo, mweye videlenya! Mowabulunya vizuka na kutenda nhambiko nhali za uzenzeleganye. Avo nhaguso yenu yowa ng'hulu ng'hani! ");
INSERT INTO zajp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mojona, wafundiza Malagizo ga Musa na Mafalisayo, videlenya! Mofunga mwanza kuchola muisi inyalile na m'bahali giladi kumzahila munhu imwe yawinze nhamanila yenu. Na muhampata, momtenda yawe mwana wa kuzimu mianza mibili kubanza mweye wenyego. ");
INSERT INTO zajp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mojona, vilangizi vimbugumbugu! Mweye mulonga, ‘Ihawa munhu yahaiduilila Ng'anda ya Mulungu, jaga bule. Ila munhu yahaiduilila zahabu ya muna Ing'anda ya Mulungu, kakiifunga na ikiduilo chake.’ ");
INSERT INTO zajp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mweye vimbugumbugu wabozi! Kilihi kili kikulu, izahabu ama Ing'anda ya Mulungu iitenda izahabu ing'ale? ");
INSERT INTO zajp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Vivija mulonga, ‘Ihawa munhu yahaiduilila kilingo cha kulavila nhosa, jaga bule. Ila munhu yahaiduilila nhunza ili hachana ya ikilingo hicho, kakiifunga na ikiduilo chake.’ ");
INSERT INTO zajp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mweye vimbugumbugu! Kilihi kili kikulu, inhunza ama ikilingo cha kulavila nhosa kiitenda inhunza ing'ale? ");
INSERT INTO zajp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Avo, heyo yoiduilila ikilingo cha kulavila nhosa, kaiduilila ikilingo hicho hamoja na kila kinhu kili hachana yake. ");
INSERT INTO zajp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na heyo yoiduilila Ng'anda ya Mulungu, kaiduilila Ing'anda hiyo hamoja na Mulungu yokala himo. ");
INSERT INTO zajp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na heyo yoiduilila ulanga, kakiiduilila kigoda cha undewa cha Mulungu hamoja na ija yakikalile. ");
INSERT INTO zajp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mojona, wafundiza Malagizo ga Musa na Mafalisayo, videlenya! Kwavija molava zaka za vinhu va kulungila mandia na mboga kamba vija matepo ga kunung'hila, binzali, na jila. Ila muleka mafundo makulu ga Malagizo ga Musa, kamba vija bazi, nhamanila, na kuwa bule uzenzeleganye. Gano gago mulondigwa kutenda, na bila kuleka gaja gayagwe. ");
INSERT INTO zajp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mweye vilangizi vimbugumbugu! Molenguza nzuguni, ila momeza ngamia! ");
INSERT INTO zajp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mojona, wafundiza Malagizo ga Musa na Mafalisayo, videlenya! Mweye mwa kamba munhu yosuluza hanze ya kikasi na sahani, ila mgati vimema vinhu m'vipatile muubavi na ugila. ");
INSERT INTO zajp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Gweye Mfalisayo kimbugumbugu! Tanhu suluza mgati mwa ikikasi, abaho, vivija na hanze chong'ala! ");
INSERT INTO zajp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mojona, wafundiza Malagizo ga Musa na Mafalisayo, videlenya! Kwavija mulinga na mapanga gabakazigwe chokaa, hanze gokoneka mazelu ila mgati gamema mizege na vinhu vose vihile. ");
INSERT INTO zajp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Vivo na mweye, kunze mokoneka na wanhu kamba mnoga, ila mgati mmema udelenya na mbuli zihile. ");
INSERT INTO zajp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mojona, wafundiza Malagizo ga Musa na Mafalisayo, videlenya! Mozenga mapanga ga wahokozi na kugahamba mapanga ga wanhu wanogile. ");
INSERT INTO zajp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Abaho, molonga, ‘Kamba tuhawile baho mkipigiti hicho cha wahenga zetu, sambituilumbe nao mkuwakoma wahokozi.’ ");
INSERT INTO zajp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Avo, mweye wenyego mosindila kamba mweye mwa lukolo lwa wanhu waja wawakomile wahokozi! ");
INSERT INTO zajp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Avo, mambukizileni gaja gawasongile wahenga zenu! ");
INSERT INTO zajp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mweye nyoka, wana wa nyoka! Moikimbila vilihi nhaguso ya kuzimu? ");
INSERT INTO zajp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Avo, nowalagizila wahokozi, wanhu wali na nzewele, na wafundiza Malagizo ga Musa. Ila wayagwe mowakoma na kuwawamba mumsalaba, na wayagwe mowalanha mbalati mzing'anda zenu za nhambiko na kuwawinga kulawa kiwambo kimwe mbaka kiwambo kiyagwe. ");
INSERT INTO zajp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nhaguso ya mulopa wa wanhu wose watendile ganogile muisi iwapate mweye, kulawa mulopa wa Abeli mbaka mulopa wa Zakalia, mwanage Balakia, mumkomile hagatigati ya Ing'anda ya Mulungu na ikilingo cha kulavila nhosa. ");
INSERT INTO zajp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nowalongela ikweli, nhaguso ya wakomaji wano wose yowapata wanhu wa mulelo uno! ");
INSERT INTO zajp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yelusalemu, Yelusalemu! Gweye uwakoma wahokozi na kuwatoa na mabwe waja watumigwe kumwako! Mianza mingahi nilonda kuwakunzanya hamoja wanago kamba nguku viyowafagatila wanage hasi ya mbawa zake, ila hutogole! ");
INSERT INTO zajp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na ng'anda yako yolekigwa na yowa ukiwa. ");
INSERT INTO zajp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nokulongela, hunyona nie kabili mbaka vondaulonge, ‘Kamota ayo yokwiza mditwaga da Mndewa.’ ” ");
INSERT INTO zajp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu kalawa Kung'anda ya Mulungu, na viyakalile yochola wanahina zake wamcholela giladi wamulagusile ng'anda zizunguluke Ing'anda ya Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu kalonga, “Mozona ng'anda zino zose? Nowalongela ikweli, haduhu hata dibwe dimwe dondadisigale uchana ya diyagwe, dondadileke kubomoligwa.” ");
INSERT INTO zajp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu viyakalile yakalile Hakigongo cha Mizaituni, wanahina wamcholela weiyeka, wamulongela, “Tulongele, zua jaki vondagalawilile gano, na choni chondakiwe kilaguso cha wizilo wako na idizua da kimambukizo?” ");
INSERT INTO zajp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu kawalongela, “Teganyeni, munhu sambiyawagize. ");
INSERT INTO zajp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwavija wanhu bwando wokwiza mtwaga jangu, wolonga, ‘Nie iyo Kilisto!’ Na wowagiza wanhu bwando. ");
INSERT INTO zajp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mohulika ng'hondo na singilimo za ng'hondo, ila sambimdumbe. Kwavija vinhu kamba vino volondigwa vilawilile, ila ikimambukizo hakinavika. ");
INSERT INTO zajp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Isi yogomba na isi iyagwe, na undewa wouvamhila undewa uyagwe. Yolawila nzala na mgudemo wa isi kila hanhu. ");
INSERT INTO zajp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gano gose gowa kamba mwanduso wa usungu wa kulela mwana. ");
INSERT INTO zajp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Abaho, mogogigwa giladi mgazigwe na kukomigwa. Na wanhu wose wa isi zose wowehila sama yangu nie. ");
INSERT INTO zajp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kipigiti kija wanhu bwando woileka nhamanila yao, na kukiihonza na kukiihila wenyego kwa wenyego. ");
INSERT INTO zajp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Abaho, wahokozi bwando wa uvwizi wolawilila, na kuwagiza wanhu bwando. ");
INSERT INTO zajp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sama ya kongezeka mbuli zihile, noge da wanhu bwando dohuha. ");
INSERT INTO zajp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ila yondayananahile mbaka hakimambukizo, iyo yondayakomboligwe. ");
INSERT INTO zajp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na Usenga uno Unogile wa Undewa wa Mulungu wopetigwa kila hanhu muulumwengu wose giladi uwe usindila ha wanhu wa isi zose, abaho, ikimambukizo cha isi leka kize.” ");
INSERT INTO zajp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Munhu yondayasome yaitange nhegulo yake! Yesu kagendelela kulonga, “Muhachona ‘Kinhu Kinyolodoke Kigala Ubananzi’ kilongigwe na muhokozi Danieli kima Hanhu Hang'alile Ng'hani Muing'anda ya Mulungu, ");
INSERT INTO zajp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","avo, awo wali Yudea wakimbilile m'vigongo. ");
INSERT INTO zajp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Munhu yoyose yali mkiswili cha ng'anda yake sambiyahumuluke hasi na kusola kinhu chochose kulawa mng'anda yake. ");
INSERT INTO zajp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Munhu yoyose yali kumgunda sambiyabwele kusola kivalo chake. ");
INSERT INTO zajp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wojona watwanzi wali na inda na watwanzi wali na ving'hele mmazua higo! ");
INSERT INTO zajp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tambikeni giladi ng'himbila yenu sambiiwe mkipigiti cha kihuhe ama mkipigiti cha Zua da Mhumulo! ");
INSERT INTO zajp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwavija wowa mgayo mkulu, haunapata kulawilila songela kulumbigwa kwa ulumwengu mbaka sambi, na haulawila kabili mgayo kamba hiwo. ");
INSERT INTO zajp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Na kamba kipigiti kija sambikihunguzwe na Mulungu, haduhu munhu yahadahile kukombolwa, ila sama ya wanhu wasaguligwe na Mulungu, kipigiti hicho kihunguzwa. ");
INSERT INTO zajp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Abaho, kamba munhu yoyose yahawalongela, ‘Lola! Kilisto kahano,’ ama ‘Kahaja!’ Sambimtogole. ");
INSERT INTO zajp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwavija makilisto wa uvwizi na wahokozi wa uvwizi wolawila, wotenda vilaguso na mizonza mikulu giladi kamba vihadahika wawagize hata wanhu wasaguligwe na Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tegelezeni! Niwalongela nisha mbuli zino kipigiti king'hali hakinavika. ");
INSERT INTO zajp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Avo kamba wanhu wahawalongela, ‘Kamkiwala!’ Sambimchole, ama wahalonga, ‘Kakugati!’ Sambimtogole. ");
INSERT INTO zajp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kwavija kamba lumwemwe vulumwemwesa kulawa haulawilo wa zua na koneka mbaka kuuswelo wa zua, na Mwana wa Munhu vivo vondayoneke kipigiti vondayeze. ");
INSERT INTO zajp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Hohose hali na mtufi baho hondawaiting'hane vimhungu. ");
INSERT INTO zajp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Bahaja ikipigiti cha mazua ga mgayo vondakimale, zua doziziwala, mulenge haulava mulangaza wake, nhondo zolagala kulawa kuulanga, na mhiko za kuulanga zokwekwesigwa kulawa hazikalile. ");
INSERT INTO zajp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Abaho, kilaguso cha Mwana wa Munhu chokoneka kuulanga, na wanhu wa isi zose wolila ahaja vondawanyone nie Mwana wa Munhu nikwiza muna gamawingu ga kuulanga na mhiko na yenzi ng'hulu. ");
INSERT INTO zajp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kowalagiza wasenga zake wa kuulanga wali na mhalati ilava dizwi kulu, na wowakunzanya wanhu zake wasaguligwe na Mulungu kulawa ng'ambu zose za ulumwengu. ");
INSERT INTO zajp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Muifundize mum'biki wa mtini. Matambi gake gahasonga udeke wa kuzuka na kulava matepo, movitanga kamba vuli da mmabehi. ");
INSERT INTO zajp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Vivija na mweye, muhazona mbuli zino zose, m'vitange kamba ka mmabehi kwiza. ");
INSERT INTO zajp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nowalongela ikweli, wanhu wa mulelo uno hawadanganhika mbaka mbuli zino zose zilawilile. ");
INSERT INTO zajp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ulanga na isi vose vobita, ila mbuli zangu hazibita. ");
INSERT INTO zajp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Haduhu munhu yoditanga zua ama saa, si wasenga wa Mulungu wa kuulanga, ama Mwana, ila Tata yeiyeka. ");
INSERT INTO zajp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kwiza kwa Mwana wa Munhu kowa kamba mkipigiti cha Nuhu. ");
INSERT INTO zajp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kwavija mmemelo wa mazi vuukalile haunalawila, wanhu wakala woja na kung'wa, wasola na kusoligwa, mbaka zua dija Nuhu viyengile muisafina, ");
INSERT INTO zajp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","hawakitangile kija kilondile kulawilila, mbaka mmemelo wa mazi vuwizile na kuwakoma wanhu wose. Na vino vivo vondayeze Mwana wa Munhu. ");
INSERT INTO zajp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mkipigiti hicho, wambigalo wabili wolima mumgunda, imwe kosoligwa na iyagwe kolekigwa. ");
INSERT INTO zajp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Watwanzi wabili wotwanga, imwe kosoligwa na iyagwe kolekigwa. ");
INSERT INTO zajp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Avo goneleleni, kwavija hamuditanga zua dondayeze Mndewa wenu. ");
INSERT INTO zajp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ila m'vitange kamba, kamba mwene ng'anda yahakitangile kipigiti chondayeze m'bavi, yahagonelele na sambiyaileke ng'anda yake ibomoligwe. ");
INSERT INTO zajp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Avo, na mweye muisasale, kwavija Mwana wa Munhu kokwiza mkipigiti hamkitangile. ");
INSERT INTO zajp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Yalihi mtumigwa mwende na m'bala, mndewa wake yamtendile salange wa watumigwa wali mng'anda yake yondayawagwelele mandia gao mkipigiti kilondigwa? ");
INSERT INTO zajp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kamota mtumigwa ija mndewa wake yahabwela yom'vika yotenda vino! ");
INSERT INTO zajp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nowalongela ikweli, komtenda yawe mkulu wa vinhu vake vose. ");
INSERT INTO zajp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ila kamba ija imtumigwa yehile koilongela mwenyego, ‘Mndewa wangu kokawa kubwela,’ ");
INSERT INTO zajp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na kusonga kuwatoa watumigwa wayage na kuja na kung'wa na wang'wa ugimbi. ");
INSERT INTO zajp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Abaho, mndewa wa imtumigwa ija kokwiza mdizua yalekile kudigelegeza na saa yalekile kuitanga. ");
INSERT INTO zajp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Abaho, komkanha vidangavidanga imtumigwa ija na kumwika mdidale dimwe na videlenya. Ako kowa na kililo na kugegedula meno. ");
INSERT INTO zajp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Kipigiti kija Undewa wa Kuulanga wolinga na wandele longo dimwe wasolile viwenge vao na kuchola kum'bokela mulawilamhambe. ");
INSERT INTO zajp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Wandele watano wakala wabozi na watano wakala wabala. ");
INSERT INTO zajp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Waja iwabozi wasola viwenge vao, bila kugela mavuta mgati yake. ");
INSERT INTO zajp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ila waja iwabala wasola viwenge vao hamoja na via va mavuta. ");
INSERT INTO zajp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kwavija mulawilamhambe kakawa kwiza, wose wakukila na kuwasa. ");
INSERT INTO zajp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kilo kikulu kukala na nyangi, ‘Mulawilamhambe kavika! Laweni mkam'bokele!’ ");
INSERT INTO zajp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Abaho, waja iwandele wose walamuka na kuvigongomanya viwenge vao. ");
INSERT INTO zajp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Abaho, waja iwabozi wawalongela waja iwabala, ‘Tugweleleni mavuta genu, kwavija viwenge vetu vofa.’ ");
INSERT INTO zajp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Waja iwabala wawalongela, ‘Hagatutosha tweye na mweye. Ila gendeni ha wachuluzi mkagule.’ ");
INSERT INTO zajp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Viwakalile mnzila wochola kugula mavuta, mulawilamhambe kavika. Na waja watano wakalile waisasale wengila hamoja nayo mulusona lwa zengele, abaho, lwivi luhindigwa. ");
INSERT INTO zajp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kipigiti waja iwandele wabozi viwezile, wakemelela, walonga, ‘Mndewa, Mndewa! Tuvugulile!’ ");
INSERT INTO zajp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mulawilamhambe kawalongela, ‘Nowalongela ikweli! Siwatanga mweye.’ ");
INSERT INTO zajp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Avo, goneleleni, kwavija hamditanga zua ama saa yondanibweleganye. ");
INSERT INTO zajp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Kipigiti kija Undewa wa Kuulanga wolinga na munhu yochola mwanza, kawakema watumigwa zake na kuwatenda wemilizi wa vinhu vake. ");
INSERT INTO zajp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kila munhu kagweleligwa kulingana na vija viyadahile, imwe kagweleligwa talanta tano na iyagwe talanta mbili na iyagwe talanta imwe. Abaho, ija imunhu kachola mwanza wake. ");
INSERT INTO zajp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ija imtumigwa yagweleligwe talanta tano, baho kachola kuzitendela uchuluzi talanta zake, na kapata talanta tano ziyagwe. ");
INSERT INTO zajp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Vivija na ija yagweleligwe talanta mbili, kapata talanta mbili ziyagwe. ");
INSERT INTO zajp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ila ija imtumigwa yagweleligwe talanta imwe, kachola kuhimba lwingila, abaho, kaifisa italanta ya mndewa wake. ");
INSERT INTO zajp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Vikibitile kipigiti kitali, ija imndewa wa waja iwatumigwa kabwela na kutenda mheta ya talanta zao. ");
INSERT INTO zajp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ija imtumigwa yagweleligwe talanta tano, kagala talanta tano ziyagwe, kalonga, ‘Mndewa, kunigwela talanta tano, hano hana talanta tano ziyagwe zinipatile!’ ");
INSERT INTO zajp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mndewa wake kamulongela, ‘Kutenda goya mtumigwa unogile na ulibule uzenzeleganye! Na kwavija hutendile uzenzeleganye m'vinhu vidodo, avo nokutenda uwe mwimilizi wa vinhu bwando. Izo udeng'he hamoja na nie, mndewa wako!’ ");
INSERT INTO zajp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Vivija na ija imtumigwa yagweleligwe talanta mbili keza kalonga, ‘Mndewa, kunigwelela talanta mbili, hano hana talanta mbili ziyagwe zinipatile.’ ");
INSERT INTO zajp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mndewa wake kamulongela, ‘Kutenda goya mtumigwa unogile na ulibule uzenzeleganye! Na kwavija hutendile uzenzeleganye m'vinhu vidodo, avo nokutenda uwe mwimilizi wa vinhu bwando. Izo udeng'he hamoja na nie, mndewa wako!’ ");
INSERT INTO zajp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Abaho, ija imtumigwa yagweleligwe talanta imwe keza kalonga, ‘Mndewa, nivitanga kamba gweye kwa munhu mdala, kohuna vija huvihandile, na kokunzanya haja haulekile kumiza mbeyu. ");
INSERT INTO zajp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Avo nidumba, nichola kuifisa talanta yako hasi muisi. Avo talanta yako ino hano.’ ");
INSERT INTO zajp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mndewa wake kamulongela, ‘Gweye mtumigwa mwavu na mkoka! Kuvitanga kamba nie nohuna vija sivihandile na nokunzanya haja hanilekile kumiza? ");
INSERT INTO zajp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kulondigwa talanta yangu ukaike benki, vinibwelile nihaivikile talanta yangu na kija chongezeke. ");
INSERT INTO zajp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Avo, m'bokeni italanta, abaho, mumgwelele ija imtumigwa yali na talanta longo dimwe. ");
INSERT INTO zajp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kwavija munhu yali na kinhu kokongezelwa, na kowa navo bwando. Ila munhu yalibule kinhu, hata kija ikidodo chayalinacho kobokigwa. ");
INSERT INTO zajp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ino mtumigwa mwavu, mwaseni hanze hana diziza. Ako kowa na kililo na kugegedula meno.’ ");
INSERT INTO zajp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mwana wa Munhu vondayeze muna iyenzi yake, hamoja na wasenga wose wa Mulungu wa kuulanga, kokala mkigoda chake cha undewa. ");
INSERT INTO zajp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na wanhu wa isi zose woilundiza haulongozi wake. Abaho, kowabagula kamba mchunga voyowabagula ng'hondolo na menhe. ");
INSERT INTO zajp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ng'hondolo koweka ng'ambu yake ya ukulume, na menhe ng'ambu yake ya ukumoso. ");
INSERT INTO zajp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Abaho, Mndewa kowalongela waja wali ng'ambu yake ya ukulume, ‘Izoni, mweye mmotezwe na Tataangu! Muuhale Undewa mtandiligwe songela vuulumbigwe ulumwengu. ");
INSERT INTO zajp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kwavija nikala na nzala munigwelela mandia, nikala na ng'hilu muning'weza, nikala muhenza munibokela, ");
INSERT INTO zajp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nikala bule vivalo munivaza, nikala mtamu mwiza kunyuguza, na nikala mkifungo mwiza kunitembelela.’ ");
INSERT INTO zajp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Abaho, waja wanhu walibule uzenzeleganye womwidika, ‘Mndewa, zua jaki vitukuwene kukala na nzala tukugwelela mandia, ama kukala na ng'hilu tukung'weza? ");
INSERT INTO zajp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Zua jaki vitukuwene kukala muhenza tukubokela, ama kukala kwabule vivalo tukuvaza? ");
INSERT INTO zajp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Zua jaki vitukuwene kukala mtamu ama kukala mkifungo, twiza kukutembelela?’ ");
INSERT INTO zajp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Abaho, Mndewa kowalongela, ‘Nowalongela ikweli, kinhu chochose kimumtendele munhu imwe wa wano ndugu zangu wadodo, munitendela nie!’ ");
INSERT INTO zajp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Abaho, kowalongela waja wanhu wali ng'ambu yake ya ukumoso, ‘Segeleni hamwangu, mweye mdukumizwe na Mulungu! Gendeni hana umoto wa digunge yekiligwe Mwenembago na vinyamkela zake! ");
INSERT INTO zajp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kwavija nikala na nzala hamunigwelele mandia, na nikala na ng'hilu hamuning'weze, ");
INSERT INTO zajp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","nikala muhenza hamunibokele, nikala bule vivalo hamunivazile, nikala mtamu na nikala mkifungo hamwizile kunitembelela.’ ");
INSERT INTO zajp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Vivija na hewo womwidika, ‘Mndewa, zua jaki vitukuwene kukala na nzala, ama kukala na ng'hilu, ama kukala muhenza, ama kukala bule vivalo, ama kukala mtamu, ama kukala mkifungo, na tweye hatukutazile?’ ");
INSERT INTO zajp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Abaho, Mndewa kowalongela, ‘Nowalongela ikweli, vumulekile kumtendela mbuli zino imwe wa wano ndugu zangu wadodo, hamunitendele nie.’ ");
INSERT INTO zajp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Avo wanhu wano wokwingila muinhaguso ya digunge, ila waja walibule uzenzeleganye wokwingila muugima wa digunge.” ");
INSERT INTO zajp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu viyamambukize kufundiza mbuli zino zose, kawalongela wanahina zake, ");
INSERT INTO zajp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Movitanga kamba gahabita mazua mabili lowa Lusona lwa Pasaka, na Mwana wa Munhu kogogigwa giladi yawambigwe mumsalaba.” ");
INSERT INTO zajp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Abaho, wakulu wa wakulu wa nhambiko na wavyele wa wanhu waiting'hana mding'anda da kindewa da Mkulu wa Wakulu wose wa Nhambiko, yokemigwa Kayafa. ");
INSERT INTO zajp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Weka zundo mkuzahila nzila ya uzenzeleganye ya kumgoga Yesu giladi wamkome. ");
INSERT INTO zajp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Walonga, “Sambitutende mbuli ino mkipigiti cha lusona giladi sambikilawilile kiyahiyahi mwa wanhu.” ");
INSERT INTO zajp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu kakala Betania kung'anda ya Simoni ayo yakalile na utamu wa dikulu. ");
INSERT INTO zajp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kipigiti Yesu viyakalile yoja hana imeza, keza mtwanzi imwe, yakalile na nyhupa ya alabasta ili na mavuta ga kunung'hila ga hela bwando, kamcholela Yesu kamwitila mpala jake. ");
INSERT INTO zajp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wanahina viwawene gano, wona lusango, walonga, “Ubananzi uno wa choni? ");
INSERT INTO zajp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mavuta gano gahaguzigwe na hela bwando, abaho, zihela wahagweleligwe wakumbulu!” ");
INSERT INTO zajp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ila Yesu viyazitangile ngelegeza zao, kawalongela, “Habali mumgaza mtwanzi ino? Kanhendela kinhu kinogile ng'hani. ");
INSERT INTO zajp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wakumbulu mokala nao mazua gose, ila nie sikala na mweye mazua gose. ");
INSERT INTO zajp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Viyanitile mavuta gano mulukuli lwangu, kanisasala na mazisi. ");
INSERT INTO zajp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nowalongela ikweli, hanhu hohose hondaupetigwe Usenga uno Unogile muulumwengu wose, kija chayatendile mtwanzi ino cholongwa mkumkumbukila heyo.” ");
INSERT INTO zajp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Abaho, imwe wa wanahina longo dimwe na wabili, yakemigwe Yuda Isikalioti, kachola ha wakulu wa wakulu wa nhambiko ");
INSERT INTO zajp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kawauza, “Monigwelela choni kamba nihamgela Yesu mmakono genu?” Avo wamgwelela vidanga malongo madatu va hela. ");
INSERT INTO zajp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kulawa haja Yuda kasonga kuzahila nzila ya kumgela mmakono gao. ");
INSERT INTO zajp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Muna dizua da mwanduso wa Lusona lwa Mikate Ilibule Mela, wanahina wamcholela Yesu wamuuza, “Kwahi kuulonda tukakutandile mandia ga Pasaka?” ");
INSERT INTO zajp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu kawalongela, “Gendeni mdiwambo, mom'vika munhu, abaho, mulongeleni, ‘Mkulufunzi kolonga, “Kipigiti kiyakisagule Mulungu sama yangu nie kikwenhuka. Nie na wanahina zangu toja mandia ga Pasaka mng'anda yako.” ’ ” ");
INSERT INTO zajp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wanahina watenda kamba Yesu viyawalagize, abaho, wagatanda mandia ga Pasaka. ");
INSERT INTO zajp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Viivikile ichungulo, Yesu kakala hana imeza hamoja na wanahina zake longo dimwe na wabili. ");
INSERT INTO zajp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Viwakalile woja, Yesu kalonga, “Nowalongela ikweli, imwe mmwanza wenu konihonza.” ");
INSERT INTO zajp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wanahina wona giogio, na wasonga kumuuza imweimwe, “Nie, Mndewa?” ");
INSERT INTO zajp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu kawedika, “Ayo yozanhika mkate mkia hamoja na nie iyo yondayanihonze. ");
INSERT INTO zajp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana wa Munhu kodanganhika kamba Nyandiko Zing'alile vuzimulonga. Ila kojona munhu ija yondayamuhonze Mwana wa Munhu! Vihanogile munhu hiyo sambiyaleligwe!” ");
INSERT INTO zajp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda, yakalile yolonda kumuhonza, kamuuza, “Nie, Mkulufunzi?” Yesu kamwidika, “Gweye kulonga vino.” ");
INSERT INTO zajp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Viwakalile woja, Yesu kasola mkate, kaumoteza, abaho, kaumogola, kawagwelela wanahina zake, kalonga, “Soleni mje, kwavija uno uwo lukuli lwangu.” ");
INSERT INTO zajp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Abaho kasola kikasi, kalonga hewela, kawagwelela wanahina zake, kalonga, “Ing'weni, mose, ");
INSERT INTO zajp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kwavija uno uwo mulopa wangu uli usindila wa lagano da Mulungu na wanhu zake, witike sama ya wanhu bwando giladi wageligwe kumgongo vilozo vao. ");
INSERT INTO zajp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nowalongela, sing'wa kabili mulelo uno wa zabibu mbaka zua dija vondaniung'we wa sambi hamoja na mweye Muundewa wa Tataangu.” ");
INSERT INTO zajp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Viweshile kwimba, wachola hana Ikigongo cha Mizaituni. ");
INSERT INTO zajp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Abaho, Yesu kawalongela, “Kilo ya lelo, mweye mose mong'himbila, kamba viyandikigwe Mnyandiko Zing'alile, ‘Nomtoa imchunga, na didale da ng'hondolo dopwililika.’ ");
INSERT INTO zajp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ila nihazuka, nowalongola kuchola Galilaya.” ");
INSERT INTO zajp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petulo kalonga, “Hata kamba wose wahakukimbila, nie sikukimbila bule!” ");
INSERT INTO zajp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu kamulongela Petulo, “Nokulongela ikweli, kilo ya lelo, nzogolo yang'hali hanakwika, konibela mianza midatu.” ");
INSERT INTO zajp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petulo kamulongela, “Hata kamba kudanganhika, nidanganhike hamoja na gweye! Sikubela bule!” Na wanahina wose wasigale walonga vivo. ");
INSERT INTO zajp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Abaho, Yesu kachola hamoja na wanahina zake hanhu hakemigwe Getisemane, kawalongela, “Kaleni hano, nie nichole haja kutambika.” ");
INSERT INTO zajp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kawasola Petulo na waja iwana wabili wa Zebedayo, kasonga kona giogio na kugazika. ");
INSERT INTO zajp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Abaho, kawalongela, “Moyo wangu una giogio ng'hani behi na kudanganhika. Kaleni hano mgonelele hamoja na nie.” ");
INSERT INTO zajp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kachola hamwande kidogo, katambalala kingubanguba, katambika, yolonga, “Tataangu, vihadahika, kikasi kino cha migayo kinisegele! Ila sio kamba vinilonda nie, ila kamba vuulonda gweye.” ");
INSERT INTO zajp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Abaho, kawabwelela waja iwanahina, kawavika wawasa. Kamuuza Petulo, “Mulemelwa kugonelela hamoja na nie hata saa dimwe? ");
INSERT INTO zajp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Goneleleni, mtambike, giladi sambimwingile mkugezigwa. Kwavija loho yolonda, ila lukuli lutepweta.” ");
INSERT INTO zajp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu kachola mwanza wa ikabili, katambika, yolonga, “Tataangu, kamba havidahika kikasi kino cha migayo kinisegele ila mbaka niking'wele, gaja guulonda gatendeke.” ");
INSERT INTO zajp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Viyabweleganye mwanza uyagwe, kawavika wawasa, kwavija meso gao gakala na utulo. ");
INSERT INTO zajp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Avo kawaleka, kachola kutambika mwanza wa ikadatu, yolonga mbuli zizija. ");
INSERT INTO zajp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Abaho, kawabwelela wanahina kawalongela, “Mng'hali wasa na kuhumula? Saa ivika ya Mwana wa Munhu kugeligwa mmakono ga wanhu wene vilozo. ");
INSERT INTO zajp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Lamukeni, tuchole! Loleni, munhu yonihonza ka habehi!” ");
INSERT INTO zajp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu viyakalile yang'hali yolonga, Yuda, imwe wa iwanahina longo dimwe na wabili, keza. Kailongoza hamoja na dale kulu da wanhu wapapile mizele na mimbwego. Wakala watumigwe na wakulu wa wakulu wa nhambiko na wavyele wa wanhu. ");
INSERT INTO zajp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Imunhu yomuhonza kawagwelela utango, kawalongela, “Ija yondanimnonele, iyo heyo. Mgogeni!” ");
INSERT INTO zajp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Baho Yuda kamcholela Yesu, kalonga, “Nokulamsa, Mkulufunzi!” Abaho, kamnonela. ");
INSERT INTO zajp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu kamulongela, “Mbwiga, tenda chuuwinzile!” Abaho, waja iwanhu weza, wamgoga Yesu na kumfunga. ");
INSERT INTO zajp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Imwe wa waja wakalile na Yesu kasomola zele jake na kumkanha gwiti nyakadala wa Mkulu wa Wakulu wose wa Nhambiko. ");
INSERT INTO zajp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu kamulongela, “Bweza zele jako muna iyala yake, kwavija wose wotamanila zele wodanganhika na zele. ");
INSERT INTO zajp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mokwagiza kamba sidaha kumulongela Tataangu yanigalile sambisambi madale gabanza longo dimwe na mabili ga wasenga zake wa kuulanga? ");
INSERT INTO zajp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ila zovikila vilihi Nyandiko Zing'alile zilonga kamba vino vivo vilondigwa ilawilile?” ");
INSERT INTO zajp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kipigiti kikija Yesu kadilongela didale da wanhu, “Mwiza na mizele na mimbwego kunigoga kamba nie na m'bokonyi? Mazua gose nikala nifundiza kuna Ing'anda ya Mulungu, na mweye hamunigogile. ");
INSERT INTO zajp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ila gano gose galawilila, giladi Nyandiko Zing'alile za wahokozi zivikile.” Abaho, wanahina wose wamuleka, wakimbila. ");
INSERT INTO zajp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Waja wamgogile Yesu wamsola wamgala ha Kayafa, Mkulu wa Wakulu wose wa Nhambiko, kuwaiting'hane wafundiza Malagizo ga Musa na wavyele wa wanhu. ");
INSERT INTO zajp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petulo kamkoleleza kutalitali mbaka kudikonhi da ing'anda ya Mkulu wa Wakulu wose wa Nhambiko. Kengila na kukala hasi hamoja na wemilizi giladi yachone chondakilawilile. ");
INSERT INTO zajp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wakulu wa wakulu wa nhambiko hamoja na Ikitala chose Kikulu cha Isi ya Wayahudi wazahila usindila wa uvwizi giladi wamkome Yesu. ");
INSERT INTO zajp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Walawilila wasindila bwando wa uvwizi, ila hawapatile mbuli yoyose. Hakimambukizo, walawilila wanhu wabili ");
INSERT INTO zajp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","walonga, “Munhu ino kalonga, ‘Nie nodaha kuibomola Ng'anda ya Mulungu na kuizenga mmazua madatu.’ ” ");
INSERT INTO zajp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mkulu wa Wakulu wose wa Nhambiko kenuka kamulongela Yesu, “Kwabule kinhu cha kwidika? Usindila waki uno woolava wanhu wano wokutagusa gweye?” ");
INSERT INTO zajp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ila Yesu kanyamala. Abaho Mkulu wa Wakulu wose wa Nhambiko kamuuza, “Nokuduiza ha Mulungu yali mgima, tulongele kamba gweye iyo Kilisto, Mwana wa Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu kamwidika kalonga, “Gweye kulonga vino. Ila nowalongela, kulawa kipigiti kino monyona nie Mwana wa Munhu nikalile ng'ambu ya ukulume ya Ukulu, nikwiza muna gamawingu ga kuulanga!” ");
INSERT INTO zajp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Abaho, Mkulu wa Wakulu wose wa Nhambiko kadega vivalo vake kalonga, “Kafukula! Habali tulonda wasindila wayagwe? Avo muhulika ufukuzi wake! ");
INSERT INTO zajp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mogelegeza vilihi?” Wamwidika, “Kolondigwa yakomigwe!” ");
INSERT INTO zajp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Abaho, wamtemela mate mkihanga chake, wamtoa, na wayagwe wamtoa makofi, ");
INSERT INTO zajp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","walonga, “Gweye Kilisto, zuza! Yalihi yakutoile?” ");
INSERT INTO zajp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petulo viyakalile yakalile hasi hanze ya idikonhi, mtumigwa imwe wa kitwanzi wa Mkulu wa Wakulu wose wa Nhambiko kamcholela kamulongela, “Na gweye kwa hamwe na Yesu wa Galilaya.” ");
INSERT INTO zajp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ila Petulo kabela haulongozi wa wanhu wose, kamulongela, “Sikitanga chuulonga.” ");
INSERT INTO zajp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Viyakalile yolawa hanze ya idikonhi, mtumigwa iyagwe wa kitwanzi kamona na kuwalongela wanhu wakalile haja, “Munhu ino kakala hamwe na Yesu wa Nazaleti.” ");
INSERT INTO zajp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petulo kabela mwanza uyagwe mkuiduila, kalonga, “Simtanga munhu ino!” ");
INSERT INTO zajp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kipigiti kidodo hamwande, wanhu wemile haja wamcholela Petulo wamulongela, “Tokona na gweye kwa mmwanza wao, kwavija hata ulonzi wako ulinga na hewo!” ");
INSERT INTO zajp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Abaho, Petulo kasonga kuidukumiza na kuiduila, yolonga, “Simtanga munhu ija!” Kipigiti kikija nzogolo keka. ");
INSERT INTO zajp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petulo kakumbukila vija Yesu viyamulongele, “Nzogolo yang'hali hanakwika, konibela mianza midatu.” Kalawa hanze kalila ng'hani. ");
INSERT INTO zajp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Imitondo ng'hani, wakulu wa wakulu wa nhambiko wose na wavyele wa wanhu wamwikila zundo Yesu giladi wazahile nzila ya kumkoma. ");
INSERT INTO zajp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wamfunga, wamsola, na kumgala ha Pilato, mndewa wa Yudea kulawa Loma. ");
INSERT INTO zajp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Abaho, Yuda, ija yamuhonzile Yesu, viyawene kamba Yesu katagusigwa kudanganhika, kona giogio na kuvibweza vija vidanga malongo madatu va hela ha wakulu wa wakulu wa nhambiko na wavyele wa wanhu. ");
INSERT INTO zajp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kalonga, “Nitenda vilozo mkumuhonza munhu yakalile bule mbuli yoyose ihile!” Na hewo wamulongela, “Avo tweye tutendeze? Na lwako mwenyego!” ");
INSERT INTO zajp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Avo Yuda kazibwanha zihela muna Ing'anda ya Mulungu, abaho, kalawa hanze ya idikonhi da Ing'anda ya Mulungu, kachola kuibota. ");
INSERT INTO zajp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Wakulu wa wakulu wa nhambiko wazidondola zihela, walonga, “Hela zino za mulopa zigomesigwa na Malagizo ga Musa kwikigwa muna ingama ya Ng'anda ya Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Avo, walamula kamba hela zija wagule mgunda wa munhu imwe yakalile muumbi giladi hawe hanhu ha kuzikila wahenza. ");
INSERT INTO zajp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Avo mbaka lelo mgunda uja wokemigwa, “Mgunda wa Mulopa.” ");
INSERT INTO zajp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Abaho, gavikila gaja galongigwe na muhokozi Yelemia, “Wasola vidanga malongo madatu va hela, kiasi kikigwe na wanhu wa Islaeli sama yake, ");
INSERT INTO zajp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na zihela wazigulila mgunda wa munhu imwe yakalile muumbi, kamba Mndewa viyanilagize.” ");
INSERT INTO zajp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu kema haulongozi wa Pilato, mndewa wa Yudea kulawa Loma, na Pilato kamuuza, “Gweye iyo mndewa wa Wayahudi?” Yesu kamulongela, “Gweye iyo ulonga avo.” ");
INSERT INTO zajp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ila wakulu wa wakulu wa nhambiko na wavyele wa wanhu viwakalile womtagusa, halongile kinhu chochose. ");
INSERT INTO zajp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Abaho, Pilato kamuuza, “Huhulika mbuli bwando zowokutagusa?” ");
INSERT INTO zajp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ila Yesu hedike hata mbuli imwe, avo Pilato kakanganya ng'hani. ");
INSERT INTO zajp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mkipigiti cha Lusona lwa Pasaka, mndewa wa Yudea kulawa Loma kakala na nzoela ya kumfungulila mfungigwa imwe ija wanhu iwamulondile. ");
INSERT INTO zajp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kipigiti kija kukala na mfungigwa imwe yatangigwe ng'hani na wanhu sama ya kutenda gehile yokemigwa Balaba. ");
INSERT INTO zajp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Avo, dale da wanhu vidiiting'hane, Pilato kawauza, “Yalihi yummulonda niwafungulile? Balaba, ama Yesu yokemigwa Kilisto?” ");
INSERT INTO zajp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kwavija Pilato kavitanga kamba wakulu wa wakulu wa nhambiko na wavyele wa wanhu wamgala Yesu kumwake sama ya migongo. ");
INSERT INTO zajp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato viyakalile mkigoda cha nhaguso, mtwanzi wake kamtumila usenga, kamulongela, “Sambiumtende kinhu chochose munhu hiyo yalibule vilozo, kwavija lelo nigaya ng'hani mnzozi sama yake.” ");
INSERT INTO zajp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ila wakulu wa wakulu wa nhambiko na wavyele wa wanhu wadiswagiza didale da wanhu dimpule Pilato yawafungulile Balaba na Yesu yakomigwe. ");
INSERT INTO zajp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato kadiuza didale da wanhu, “Yalihi mwa wanhu wano wabili yummulonda niwafungulile?” Wamwidika, “Balaba.” ");
INSERT INTO zajp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato kawauza, “Nimtendeze Yesu yokemigwa Kilisto?” Wose wamwidika, “Yawambigwe mumsalaba!” ");
INSERT INTO zajp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato kawauza, “Habali, mbuli yaki ihile yaatendile?” Ila wose wongeza kuguta nyangi wolonga, “Yawambigwe mumsalaba!” ");
INSERT INTO zajp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato viyawene kamba hawamtegeleza, ila kizuka kiyahiyahi, kasola mazi na kusuluza makono gake haulongozi wa didale da wanhu, kalonga, “Nie nabule mbuli na ifa ya munhu ino! Iloleni mwemwe wenyego!” ");
INSERT INTO zajp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Didale da wanhu dimulongela, “Nhaguso ya ifa yake toisola tweye na wanetu!” ");
INSERT INTO zajp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Abaho, Pilato kawafungulila Balaba, na kuwalagiza asikali wamulanhe Yesu mbalati, na kumgela mmakono gao giladi yawambigwe mumsalaba. ");
INSERT INTO zajp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Abaho, asikali wa mndewa wa Yudea kulawa Loma wamsola Yesu wamwingiza mding'anda da ija imndewa, abaho, dale jose da asikali dimzunguluka. ");
INSERT INTO zajp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wam'vula vivalo vake na kum'vaza kanzu da zambalau. ");
INSERT INTO zajp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Abaho, waluka mkungo wa mizomola wamwikila mpala jake na kumwikila ludete mumkono wake wa ukulume. Abaho, wamfugamila mavindi na kumtendela uponela, wamulongela, “Kwa mpile, Mndewa wa Wayahudi!” ");
INSERT INTO zajp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wamtemela mate, wasola ludete na kumulanha nao mpala. ");
INSERT INTO zajp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Viwamambukize kumtendela uponela, wam'vula dija dikanzu, wam'vaza vivalo vake. Abaho, wamgala kumuwamba mumsalaba. ");
INSERT INTO zajp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Viwakalile wochola, waiting'hana na munhu kulawa isi ya Kilene, yakemigwe Simoni, wemilizi wamshulutiza giladi yaupape msalaba wa Yesu. ");
INSERT INTO zajp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wavika hanhu hakemigwe, Goligota, nhegulo yake “Hanhu ha Fulu da Pala.” ");
INSERT INTO zajp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wamgwelela Yesu divai igeligwe vinhu va usungu, ila viyailanzile, haing'wile. ");
INSERT INTO zajp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wamuwamba mumsalaba, abaho, wakiigolela vivalo vake mkuvitoela kula. ");
INSERT INTO zajp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Abaho, wakala hasi, wamwimiliza. ");
INSERT INTO zajp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Uchana ya pala jake wandika lupwilili lwa nhaguso yake lulonga, “ino iyo yesu, mndewa wa wayahudi.” ");
INSERT INTO zajp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wamuwamba Yesu mumsalaba hamoja na mibokonyi mibili, dimwe ng'ambu yake ya ukulume, na diyagwe ng'ambu yake ya ukumoso. ");
INSERT INTO zajp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wanhu wakalile wobita wamuliga, watigisa mapala gao ");
INSERT INTO zajp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","walonga, “Gweye iyo ulondile kuibomola Ng'anda ya Mulungu na kuizenga mmazua madatu, ikombole mwenyego! Ihawa gweye iyo Mwana wa Mulungu, humuluka kulawa mumsalaba!” ");
INSERT INTO zajp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Vivija na wakulu wa wakulu wa nhambiko, wafundiza Malagizo ga Musa na wavyele wa wanhu wamtendela uponela, walonga, ");
INSERT INTO zajp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Kawakombola wayagwe, ila hadahile kuikombola mwenyego! Heyo iyo Mndewa wa Islaeli! Avo na yahumuluke kulawa mumsalaba, na tweye tomtogola! ");
INSERT INTO zajp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Komtamanila Mulungu, avo tulole vija Mulungu vondayamkombole, kwavija kalonga, ‘Nie iyo Mwana wa Mulungu.’ ” ");
INSERT INTO zajp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Vivija na ija imibokonyi iwambigwe hamoja na heyo imuliga. ");
INSERT INTO zajp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Songela kipigiti cha saa sita, kukala na ziza muisi yose mbaka kipigiti cha saa tisa. ");
INSERT INTO zajp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mkipigiti cha saa tisa, Yesu kenula dizwi kalila, “Eloi, Eloi, lama sabakitani?” Nhegulo yake, “Mulungu wangu, Mulungu wangu, habali kundeka?” ");
INSERT INTO zajp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wanhu wemile haja viwahulike, walonga, “Munhu ino komkema Eliya!” ");
INSERT INTO zajp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Bahaja munhu imwe kakimbila na kusola siponji, kaizabika muna idivai igwaduke na kuifunga kuisota ya lumango na kumng'weza Yesu. ");
INSERT INTO zajp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ila wayagwe walonga, “Muleke! Tulole kamba Eliya kokwiza kumkombola!” ");
INSERT INTO zajp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu kenula dizwi kalila kabili, abaho, kadanganhika. ");
INSERT INTO zajp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kipigiti kikija, diguo ditungikwe Muing'anda ya Mulungu didegeka vidanga vibili, kulawa uchana mbaka hasi. Isi igudema, na mibwe itulika, ");
INSERT INTO zajp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mapanga gatulika, na ng'huli za wanhu bwando wang'alile wadanganhike wazuka. ");
INSERT INTO zajp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesu viyazukile, na hewo walawa hana gamapanga wachola hana diwambo ding'alile da Yelusalemu, na koneka na wanhu bwando. ");
INSERT INTO zajp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mkulu wa asikali mia wa Loma, hamoja na waja wakalile womwimiliza Yesu, viwawene mgudemo wa isi na gaja galawilile, wadumba na kulonga, “Kweli munhu ino kakala Mwana wa Mulungu!” ");
INSERT INTO zajp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hanhu haja kukala na watwanzi bwando wolola kutalitali, wakalile womkweleleza Yesu kulawa Galilaya na wakala womsang'hanikila. ");
INSERT INTO zajp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Watwanzi hiwo wakala Maliamu wa kiwambo cha Magidala, Maliamu mamaake Yakobo na Usufu, na mama wa wanage Zebedayo. ");
INSERT INTO zajp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Viivikile ichungulo, keza mgoli imwe kulawa wambo da Alimataya, yakemigwe Usufu, vivija kakala mwanahina wa Yesu. ");
INSERT INTO zajp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kachola ha Pilato na kumpula lukuli lwa Yesu, na Pilato kalagiza kamba yagweleligwe. ");
INSERT INTO zajp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Usufu kalusola ulukuli, kaluzinga sanda, ");
INSERT INTO zajp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","na kulutambalika mdipanga jake mwenyego da sambi dipukigwe mdidibwe. Kadibimbilisa dibwe kulu na kudika hana umulomo wa idipanga, abaho, kachola. ");
INSERT INTO zajp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliamu wa kiwambo cha Magidala na Maliamu iyagwe wakala hamgwazo wa idipanga. ");
INSERT INTO zajp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Imitondo yake, ikala Zua da Mhumulo, wakulu wa wakulu wa nhambiko na Mafalisayo wamcholela Pilato ");
INSERT INTO zajp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","na kulonga, “Mndewa, tokumbuka kamba viyakalile mgima, m'vwizi ija kalonga, ‘Gahabita mazua madatu nozuka.’ ");
INSERT INTO zajp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Avo lagiza kamba panga jake diimilizwe mbaka zua da ikadatu, giladi wanahina zake sambiwachole kulusola ulukuli, na kuwalongela wanhu kamba kazuka. Uvwizi uno wa kimambukizo wokwiha ng'hani kubanza uja wa ichanduso.” ");
INSERT INTO zajp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato kawalongela, “Soleni iwaasikali, gendeni mkadiimilize kamba vumdaha.” ");
INSERT INTO zajp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Avo wachola kudimiliza dipanga mkuweka asikali na kwika utango mumgwazo wa idibwe giladi kamba munhu yahadisegeza wavitange. ");
INSERT INTO zajp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Vidimalile Zua da Mhumulo, imitondo iyagwe, zua vidikalile disimbuka, Maliamu wa ikiwambo cha Magidala na Maliamu iyagwe wachola kudilola dipanga. ");
INSERT INTO zajp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bahaja kulawilila na mgudemo mkulu wa isi, kwavija msenga wa Mndewa wa kuulanga kahumuluka kulawa kuulanga, kadibimbilisa idibwe kumgwazo, abaho, kadikalila. ");
INSERT INTO zajp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Lukuli lwake lunang'hazika kamba lumwemwe, na vivalo vake vikala vizelu ng'hani. ");
INSERT INTO zajp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Waja iwaasikali wadumba na kugudema ng'hani, walinga kamba wanhu wadanganhike. ");
INSERT INTO zajp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Msenga wa Mndewa wa kuulanga kawalongela waja iwatwanzi, “Sambimdumbe, kwavija novitanga kamba momzahila Yesu, yawambigwe mumsalaba. ");
INSERT INTO zajp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kahaduhu hano, kazuka, kamba viyalongile. Izoni mulole hanhu hayakalile yatambalale. ");
INSERT INTO zajp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tendeni mbwisa mchole mkawalongele wanahina zake kamba kazuka, kowalongola kuchola Galilaya ako kondammone. Uno uwo usenga wangu kumwenu.” ");
INSERT INTO zajp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hima walawa hana dipanga, kuno wogudema na kudeng'ha ng'hani, abaho, wakimbila, wachola kuwalongela wanahina zake. ");
INSERT INTO zajp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bahaja Yesu kawating'hanila, kalonga, “Nowalamsa!” Wamcholela, wamgoga magulu gake na kumtambikila. ");
INSERT INTO zajp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu kawalongela, “Sambimdumbe, gendeni mkawalongele wanahina zangu wachole Galilaya, ako wonyona.” ");
INSERT INTO zajp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Waja iwatwanzi viwakalile mnzila, asikali wayagwe wakalile wodimiliza idipanga wachola mdiwambo kuwalongela wakulu wa wakulu wa nhambiko mbuli zose zilawilile. ");
INSERT INTO zajp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wakulu wa wakulu wa nhambiko waiting'hana hamoja na wavyele wa wanhu, na viweshile kuitogolela, wawagwelela hela bwando iwaasikali, ");
INSERT INTO zajp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","wawalongela, “Longeni, ‘Vitukalile tuwasile, wanahina zake weza ikilo na kulwiba lukuli lwake.’ ");
INSERT INTO zajp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kamba mbuli ino iham'vikila mndewa wa Yudea kulawa Loma, tolonga nayo mkuwagombeleza giladi sambimgazigwe.” ");
INSERT INTO zajp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Avo iwaasikali wasola zihela na kutenda kamba viwalongeligwe. Na mbuli zino zibwililika mwa Wayahudi mbaka lelo. ");
INSERT INTO zajp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Wanahina longo dimwe na imwe, wachola Galilaya hana ikigongo chayawalongele Yesu wachole. ");
INSERT INTO zajp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Viwamuwene, wamtambikila, ila wanahina wayagwe wadungwadungwa mmoyo. ");
INSERT INTO zajp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu kawakwenhukila kawalongela, “Nigweleligwa udaho wose kuulanga na muisi. ");
INSERT INTO zajp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Avo gendeni mkawatende wanhu wa isi zose wawe wanahina, na kuwabatiza mtwaga da Tata, na Mwana, na Loho wa Mulungu, ");
INSERT INTO zajp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","na kuwafundiza kugagoga gaja gose ganiwalongele mweye. Na nie na hamoja na mweye mazua gose, mbaka hakimambukizo cha iisi.”");
INSERT INTO zajp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Uno uwo mwanduso wa Usenga Unogile wa Yesu Kilisto, Mwana wa Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kamba viwandikigwe na muhokozi Isaya, “Mulungu kalonga, ‘Nomulagiza msenga wangu yakulongole, Yondayaitande nzila yako.’ ");
INSERT INTO zajp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Munhu kenula dizwi muluwala, yolonga, ‘Itandeni nzila ya Mndewa, Mgoloseleni nzila zake!’ ” ");
INSERT INTO zajp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohana M'batiza kakala muluwala, youpeta ubatizo wa kuleka vilozo, giladi vilozo vao vigeligwe kumgongo. ");
INSERT INTO zajp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wanhu bwando kulawa muisi ya Yudea na mkiwambo cha Yelusalemu wachola kumtegeleza Yohana. Wavilonga vilozo vao haulongozi wa wanhu, na heyo kawabatiza muna Ulwanda lwa Yolodani. ");
INSERT INTO zajp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana kavala guo ditendigwe na mijusu ya ngamia na lukumbulu lwa kwembe mchuno chake, kakala yoja nzige na uki. ");
INSERT INTO zajp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohana kawapetela wanhu, yolonga, “Munhu yokwiza hachugu changu kana mhiko kunibanza nie. Nie silondigwa hata kuinamila na kufungula nzabi za ng'hwabasa zake. ");
INSERT INTO zajp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nie niwabatiza mweye mmazi, ila heyo yeheza kowabatiza na Loho wa Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mazua gaja, Yesu kalawa mkiwambo cha Nazaleti muisi ya Galilaya, keza kubatizigwa na Yohana M'batiza Mulwanda lwa Yolodani. ");
INSERT INTO zajp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kipigiti kikija Yesu viyalawile mmazi, kawona ulanga uvuguka na Loho wa Mulungu kamuhumulukila yalumbile kamba hua. ");
INSERT INTO zajp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Dizwi dihulikwa kulawa kuulanga dilonga, “Gweye iyo Mwanangu unogele. Nogelwa nagwe.” ");
INSERT INTO zajp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Baho Loho wa Mulungu kamsung'hiza yachole muluwala, ");
INSERT INTO zajp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","kakala hiko mazua malongo mane, yogezigwa na Mwenembago. Hiko kakala na wang'onyo wa kumuhulo, na wasenga wa Mulungu wa kuulanga wakala womsang'hanikila. ");
INSERT INTO zajp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohana M'batiza viyageligwe mkifungo, Yesu kachola Galilaya, kawapetela wanhu Usenga Unogile wa Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kalonga, “Kipigiti kivika, na Undewa wa Mulungu ukwenhuka! Muleke vilozo venu na muutogole Usenga Unogile.” ");
INSERT INTO zajp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu viyakalile yobita mumgwazo wa Idilamba da Galilaya, kawona Simoni na Endelea ndugu yake, wotanda nhando zao mdilamba, kwavija wakala waloa somba. ");
INSERT INTO zajp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu kawalongela, “Ng'hwelelezeni, na nie nowatenda muwe waloa wanhu.” ");
INSERT INTO zajp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Baho wazileka nhando zao wamkweleleza. ");
INSERT INTO zajp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kachola haulongozi kidogo, kawona Yakobo na Yohana, wanage Zebedayo. Wakala mngalawa zao wozigongomanya goya nhando zao. ");
INSERT INTO zajp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu viyawawene, bahaja kawakema, wamuleka tataao Zebedayo muingalawa na wasang'hana, wamkweleleza Yesu. ");
INSERT INTO zajp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na wanahina zake wengila mkiwambo cha Kapenaumu. Vidivikile Zua da Mhumulo, Yesu kengila muna ing'anda ya nhambiko, kasonga kufundiza. ");
INSERT INTO zajp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wanhu wamuhulike wakanganya vija voyokala yofundiza, kwavija hafundize kamba wafundiza Malagizo ga Musa, ila kafundiza kamba munhu yali na udaho. ");
INSERT INTO zajp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kipigiti kikija munhu yali na kinyamkela kengila mng'anda yao ya nhambiko, kaguta lwangi, yolonga, ");
INSERT INTO zajp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Kotulonda choni, Yesu wa Nazaleti? Kwiza kutubananga? Nokutanga gweye iyo mtumigwa wa Mulungu ung'alile!” ");
INSERT INTO zajp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu kamkomhokela ikinyamkela yolonga, “Nyamala! Mulawe munhu ino!” ");
INSERT INTO zajp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kinyamkela kamtigisatigisa ng'hani ija imunhu, kaguta lwangi na kumulawa. ");
INSERT INTO zajp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wanhu wose wakanganya, wasonga kuilongela, “Mbuli yaki ino? Dino fundo da sambi? Munhu ino kana udaho wa kuwakomhokela vinyamkela, na hewo womuhulika!” ");
INSERT INTO zajp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Avo mbuli za Yesu zenela himahima kila hanhu muiisi ya Galilaya. ");
INSERT INTO zajp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu na wanahina zake hamoja na Yakobo na Yohana walawa mng'anda ya nhambiko wachola hakae ya Simoni na Endelea. ");
INSERT INTO zajp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mama mkwe yake Simoni kakala mtamu wa homa, kipigiti kikija Yesu viyavikile wamulongela. ");
INSERT INTO zajp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu kamcholela, kamgoga mkono kamwinula. Homa imulawa, na heyo kasonga kuwasang'hanikila. ");
INSERT INTO zajp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ichungulo zua vidiswile, wanhu wamgalila Yesu watamu wose na awo wakalile na vinyamkela. ");
INSERT INTO zajp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wanhu wose wa mkiwambo waiting'hana haulongozi wa ing'anda. ");
INSERT INTO zajp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu kawahonya wanhu bwando wakalile na vitamu va namna zose na kuwinga vinyamkela bwando. Hawalekile vinyamkela walonge kinu chochose, kwavija wamtanga heyo iyo yalihi. ");
INSERT INTO zajp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Imitondo iyagwe ulukwili, zua hadinalawa, Yesu kenuka, kalawa mng'anda. Kachola kutali na ikiwambo hanhu halibule wanhu kutambika. ");
INSERT INTO zajp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na wayage wachola kumzahila. ");
INSERT INTO zajp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Viwamuwene wamulongela, “Wanhu wose wokuzahila gweye.” ");
INSERT INTO zajp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ila Yesu kawalongela, “Tucholeni hana iviwambo viyagwe vituzunguluke. Nolondigwa nikaupete Usenga Unogile hiko nako, kwavija ino iyo sang'hano iminzile.” ");
INSERT INTO zajp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Avo kachola kila hanhu muisi ya Galilaya yowapetela wanhu muna zing'anda za nhambiko na kuwinga vinyamkela. ");
INSERT INTO zajp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Munhu imwe yakalile na dikulu keza ha Yesu, kafugama mavindi kaiyalala yolonga, “Uhalonda, kodaha kunihonya.” ");
INSERT INTO zajp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu kamwonela bazi, kagolosa mkono wake kamkwasa, kalonga, “Nolonda, hona!” ");
INSERT INTO zajp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Baho utamu umulawa, kahona. ");
INSERT INTO zajp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Abaho, Yesu kamulongela yachole na zake kuno yomzuma yolonga, ");
INSERT INTO zajp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Tegeleza, sambiumulongele munhu yoyose mbuli ino, ila genda dimwe kwa dimwe ha mkulu wa nhambiko yakulole goya. Abaho, ukalave nhosa kamba viyalagize Musa, giladi wanhu wose watogole kamba kuhona.” ");
INSERT INTO zajp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ila munhu ija kachola na kasonga kubwililisa mbuli ija kila hanhu. Kweli kailonga ng'hani mbuli ija mbaka Yesu hadahile kwingila mkiwambo kimwagaia. Avo kakala hanhu halibule wanhu, na wanhu wamwizila kulawa kila hanhu. ");
INSERT INTO zajp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mazua madodo hamwande, Yesu kabweleganya Kapenaumu, mbuli zija zibwililika kamba kaukae. ");
INSERT INTO zajp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Avo, wanhu bwando waiting'hana hamoja mbaka kukala haduhu hanhu hasigale, wakala wamemile mbaka haluhelengo. Na heyo kawapetela Usenga Unogile. ");
INSERT INTO zajp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Abaho, weza wanhu, wamgalila munhu yaholole, yakalile yapapigwe na wanhu wane wakalile mmwanza wao. ");
INSERT INTO zajp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Avija wanhu viwamemile, hawadahile kumgala ija imunhu ha Yesu. Avo watenda zonzo mkiswili walinga hayali Yesu. Viwatendile idizonzo, wamuhumulusa hasi ija imunhu, yawasile mulusazi. ");
INSERT INTO zajp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Viyaiwene nhamanila yao, Yesu kamulongela ija imunhu yaholole, “Mwanangu, vilozo vako vigeligwa kumgongo.” ");
INSERT INTO zajp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wafundiza wayagwe wa Malagizo ga Musa wakalile baho, wasonga kugelegeza munda kwa munda. ");
INSERT INTO zajp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Habali munhu ino yolonga kamba vino? Uno ufukuzi! Mulungu yeiyeka yodaha kugela kumgongo vilozo va wanhu!” ");
INSERT INTO zajp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Bahaja Yesu kagatanga gaja gawakalile wogelegeza, avo kawalongela, “Habali mgelegeza vinhu kamba avo? ");
INSERT INTO zajp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Dilihi dibuhile ng'hani, kumulongela munhu yaholole ‘Vilozo vako vigeligwa kumgongo,’ ama kulonga, ‘Ima wima upape lusazi lwako, utembele?’ ");
INSERT INTO zajp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nolonda m'vitange kamba, nie, Mwana wa Munhu, nna udaho wa kuvigela kumgongo vilozo va wanhu muisi.” Abaho kamulongela ija imunhu yaholole, ");
INSERT INTO zajp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ima wima, papa lusazi lwako, uchole ukae yako!” ");
INSERT INTO zajp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hameso gao ija imunhu kenuka kapapa lusazi lwake himahima kachola. Wanhu wose wakanganya ng'hani wamuyenzi Mulungu wolonga, “Hatunayona mbuli kamba ino!” ");
INSERT INTO zajp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu kabweleganya kabili mumgwazo wa Idilamba da Galilaya. Wanhu bwando wamwizila, na heyo kasonga kuwafundiza. ");
INSERT INTO zajp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Viyakalile yobita, kamona muwila kodi yokemigwa Lawi, mwana wa Alufayo, yakalile muna ing'anda yake ya kulihila kodi. Yesu kamulongela, “Ng'holeleza.” Lawi kenuka kamkoleleza. ");
INSERT INTO zajp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu viyakalile yoja mng'anda ya Lawi, wawila kodi bwando na wene vilozo wayagwe wakala woja na heyo hamoja na wanahina zake, kwavija kukala na wanhu bwando wakalile womkweleleza. ");
INSERT INTO zajp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wafundiza Malagizo ga Musa, wakalile Mafalisayo, viwamuwene Yesu yoja na wawila kodi na wene vilozo wayagwe, wawauza wanahina zake, “Habali yoja na wanhu kamba wano?” ");
INSERT INTO zajp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu kawahulika na kawalongela, “Wanhu wagima hawamulonda mganga, ila waja wali watamu wawo womulonda. Sizile kuwakema wanhu walibule vilozo ila wanhu wali na vilozo.” ");
INSERT INTO zajp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wanahina wa Yohana M'batiza na wanahina wa Mafalisayo wakala wofunga. Wanhu wayagwe wamwizila Yesu wamuuza, “Habali wanahina wa Yohana M'batiza na wanahina wa Mafalisayo wofunga, ila wanahina zako hawafunga?” ");
INSERT INTO zajp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu kawedika, “Mokwagiza wahenza halusona lwa zengele wacholaga bila kuja? Nokona havilumba! Kipigiti chose chondawakale na mulawilamhambe havidahika kufunga. ");
INSERT INTO zajp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ila kipigiti chovika mulawilamhambe vondayasegezigwe kumwao, baho hondawasonge kufunga. ");
INSERT INTO zajp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Haduhu munhu yokanha kidanga muna ikivalo cha sambi na kukigela muna ikivalo cha umwaka, kwavija yahatenda avo ikidanga cha sambi chobananga ikivalo cha umwaka, na hanhu hadegeke hokongezeka. ");
INSERT INTO zajp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Haduhu munhu yogela divai ya sambi muna ivibuyu va umwaka vitendigwe na kwembe. Kwavija yahatenda avo idivai ya sambi yovitula ivibuyu, idivai yokwitika na ivibuyu vobanangika. Ila divai ya sambi yogeligwa muna ivibuyu va sambi vitendigwe na kwembe.” ");
INSERT INTO zajp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yesu kakala yobita muna imigunda ya ngano Mdizua da Mhumulo na wanahina zake. Viwakalile wotembela mnzila, wanahina zake wasonga kufyola zisota za gamakungwi ga ngano. ");
INSERT INTO zajp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Avo Mafalisayo wamuuza Yesu, “Lola! Wanahina zako wotenda gagomeswe kutendigwa Mdizua da Mhumulo!” ");
INSERT INTO zajp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu kawedika, “Hamsomile kija chayatendile Daudi kipigiti heyo na wayage viwakalile na nzala? ");
INSERT INTO zajp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kengila mdihema da Mulungu kaija imikate ilavigwe nhosa ha Mulungu, na iyagwe kawagwelela wayage. Vinhu vikalile vigomeswe Mmalagizo getu kudigwa na munhu yoyose ila wakulu wa nhambiko weiyeka. Gano galawilila kipigiti kija Abiatali viyakalile Mkulu wa Wakulu wose wa Nhambiko.” ");
INSERT INTO zajp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Abaho, Yesu kamambukiza, “Zua da Mhumulo dikiligwa wanhu na si wanhu wekiligwe Zua da Mhumulo.” ");
INSERT INTO zajp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Avo nie, Mwana wa Munhu, nene Mndewa wa Zua da Mhumulo. ");
INSERT INTO zajp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Abaho, Yesu kabweleganya kabili muing'anda ya nhambiko. Amo kukala na munhu yali na mkono uholole. ");
INSERT INTO zajp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wanhu wayagwe wakalile haja wakala wozahila kilamso cha kumtagusila Yesu, avo wamulola ng'hani wone kamba kohonya Mdizua da Mhumulo. ");
INSERT INTO zajp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu kamulongela ija imunhu yali na mkono uholole, “Ima hano haulongozi wa wanhu wose.” ");
INSERT INTO zajp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Abaho, Yesu kawauza waja iwanhu, “Malagizo getu gotulongela tutende kinhu chaki Mdizua da Mhumulo? Kutenda ganogile ama gehile? Kuukombola ugima wa munhu ama kuubananga?” Ila hawalongile kinhu chochose. ");
INSERT INTO zajp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu kawalola wanhu wose na lusango, ila kipigiti kikija kona bazi na giogio sama yao, kwavija wakala na mioyo midala na wapotela. Abaho, kamulongela ija imunhu, “Golosa mkono wako.” Na heyo kaugolosa, na mkono wake uhona. ");
INSERT INTO zajp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Avo Mafalisayo walawa hanze ya ing'anda ya nhambiko na waiting'hana na wanhu wa Helode, na wasonga kuzahila nzila ya kumkoma Yesu. ");
INSERT INTO zajp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu na wanahina zake wachola kuna Idilamba da Galilaya na dale kulu da wanhu dimkweleleza. ");
INSERT INTO zajp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Viwahulike gaja gose goyokala yotenda, wanhu bwando wamwizila kulawa Yudea, Yelusalemu, Idumea, na isi za mwambu wa ikabili wa Ulwanda lwa Yolodani, na isi zose zizunguluke Tilo na Sidoni. ");
INSERT INTO zajp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kwavija kukala na dale kulu da wanhu, Yesu kawalongela wanahina zake wamwikile goya ngalawa, giladi wanhu sambiwamkukusule. ");
INSERT INTO zajp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesu kawahonya wanhu bwando, na wanhu wose wakalile watamu wakiibabanika womcholela giladi wamgoge. ");
INSERT INTO zajp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na vinyamkela viwamuwene Yesu, wawagwisa hasi wanhu iwawavagale haulongozi wake, waguta nyangi, walonga, “Gweye iyo Mwana wa Mulungu!” ");
INSERT INTO zajp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ila Yesu kawalagiza vinyamkela sambiwamulongele munhu yoyose kamba heyo iyo yalihi. ");
INSERT INTO zajp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu kakwela mkigongo na kuwakema wanhu yaawalondile, na hewo wamuwinza. ");
INSERT INTO zajp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kawasagula wanhu longo dimwe na wabili awo vivija yaawakemile watumigwa wa Kilisto, wondawakale na heyo na yondayawatume wachole kuupeta Usenga Unogile, ");
INSERT INTO zajp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na kawagwelela udaho wa kuwinga vinyamkela. ");
INSERT INTO zajp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na wano iwo wanhu longo dimwe na wabili yaawasagule Yesu. Simoni, Yesu yamgwelele twaga da Petulo, ");
INSERT INTO zajp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo na ndugu yake Yohana, wana wa Zebedayo, Yesu yaawakemile Boaneji, nhegulo yake, “Wana wa Mdumo,” ");
INSERT INTO zajp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Endelea, Filipo, Batolomayo, Matayo, Tomaso, Yakobo mwana wa Alufayo, Tadayo, Simoni yakalile yokemigwa Mgombeleza Isi ya Islaeli, ");
INSERT INTO zajp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuda Isikalioti yamuhonzile Yesu. ");
INSERT INTO zajp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu kachola ukae. Dale kulu da wanhu waiting'hana mwanza uyagwe mbaka Yesu na wanahina zake hawapatile kipigiti cha kuja. ");
INSERT INTO zajp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mulango wake viwahulike, wachola kumsola kwavija wanhu wakala wolonga, “Kana luwege!” ");
INSERT INTO zajp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wafundiza wayagwe wa Malagizo ga Musa walawile Yelusalemu walonga, “Kana Belizebuli, mkulu wa vinyamkela iyo yomgwelela mhiko za kuwinga vinyamkela.” ");
INSERT INTO zajp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Avo Yesu kawakema na kawalongela mmahala, “Mwenembago kodahaze kukiiwinga mwenyego? ");
INSERT INTO zajp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kamba undewa uhaigola mmadalemadale, gogomba genyego kwa genyego, undewa hiwo wopwililika.” ");
INSERT INTO zajp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kamba mulango uhaigola mmadalemadale, gogomba genyego kwa genyego, mulango hiwo wopwililika. ");
INSERT INTO zajp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Avo kamba undewa wa Mwenembago uhaigola mmadalemadale haugendelela, ila wopwililika na kupotela. ");
INSERT INTO zajp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Haduhu munhu yodaha kwingila mng'anda ya munhu yali na mhiko na kumsolela vinhu vake, mbaka yanduse kumfunga munhu iyo yali na mhiko. Abaho, leka yadahe kum'boka vinhu vake. ");
INSERT INTO zajp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nowalongela ikweli, vilozo vose na mbuli zose za ufukuzi za wanhu vogeligwa kumgongo. ");
INSERT INTO zajp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ila munhu yoyose yondayamfukulile Loho wa Mulungu, havidahika kugeligwa kumgongo, kwavija katenda vilozo va digunge.” ");
INSERT INTO zajp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu kalonga vino kwavija wakala wolonga, “Kana kinyamkela.” ");
INSERT INTO zajp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Abaho, mamaake na wadodo zake Yesu weza. Wema hanze, wamulagiza munhu yengile mng'anda yakamkeme. ");
INSERT INTO zajp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dale da wanhu wakalile wamzunguluke, wamulongela, “Mamaako na wadodo zako na lumbu zako wakunze wokuzahila.” ");
INSERT INTO zajp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu kawedika, “Mamaangu yalihi? Na wadodo zangu walihi?” ");
INSERT INTO zajp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Abaho, kawalola wanhu wamzunguluke na kulonga, “Wano iwo mamaangu na wadodo zangu! ");
INSERT INTO zajp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Munhu yoyose yogatenda gaja goyolonda Mulungu, heyo iyo mdodo wangu, lumbu jangu, na mamaangu.” ");
INSERT INTO zajp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu kasonga kufundiza mumgwazo wa Idilamba da Galilaya. Wanhu kombenakombena wammemela womzunguluka wakala dale kulu, avo kengila mngalawa na kakala himo. Ija ingalawa ikala mumgwazo wa idilamba, na ididale da wanhu wakala wemile mhwani, mulugigo lwa igamazi. ");
INSERT INTO zajp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kawafundiza vinhu bwando mmahala. ");
INSERT INTO zajp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Yolonga, “Tegelezeni! Mulimi kachola kuhanda mbeyu. ");
INSERT INTO zajp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Viyakalile yomiza, ziyagwe zilagalila mnzila, ndege weza wazija. ");
INSERT INTO zajp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ziyagwe zilagalila muna uulongo uli na mabwe, hakalile na ulongo mdodo. Hima zimbeyu zota, kwavija ulongo ukala mdodo. ");
INSERT INTO zajp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Zua vidilawile diilukuza imiche, na kwavija ikala na mizizi midodo imiche inyala. ");
INSERT INTO zajp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbeyu ziyagwe zilagalila mmizomola, imizomola ikula na kuizingiliza imiche, avo hailelile. ");
INSERT INTO zajp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ila ziyagwe zilagalila hana ulongo unogile, zota, zikula na kulela, ziyagwe zilela malongo madatu, ziyagwe zilela malongo sita, na ziyagwe zilela mia.” ");
INSERT INTO zajp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu kamambukiza, “Munhu yali na magwiti na yahulike!” ");
INSERT INTO zajp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu viyakalile yeiyeka, wanahina zake longo dimwe na wabili na wanhu wakalile womtegeleza, wamcholela wamulongela yawalongele nhegulo ya mahala gaja. ");
INSERT INTO zajp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu kawedika, “Mweye mgweleligwa nyong'onyo za Undewa wa Mulungu, ila wanhu wali kunze wohulika vinhu vose mmahala, ");
INSERT INTO zajp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","giladi, ‘Walole, Ila sambiwone, Wahulike, Ila sambiwavitange, Kwavija wahavitanga, womuhindukila Mulungu, Na heyo kovigela kumgongo vilozo vao.’ ” ");
INSERT INTO zajp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Abaho, Yesu kawauza, “Avo kamba hamditanga hala dino, mogatangaze mahala gayagwe? ");
INSERT INTO zajp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Imunhu yohanda kohanda imbuli ya Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wanhu wayagwe walinga kamba mbeyu zilagalile mnzila, haja imbuli ya Mulungu viihandigwe. Kipigiti kikija viwoihulika, Mwenembago kokwiza na kuisola imbuli ya Mulungu ihandigwe mgati yao. ");
INSERT INTO zajp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wanhu wayagwe walinga kamba mbeyu zilagalile muulongo uli na mabwe. Woihulika imbuli ya Mulungu, na kipigiti kikija woibokela mkudeng'ha. ");
INSERT INTO zajp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ila haiwengila mgati ng'hani avo haikala kipigiti kitali. Uhalawila mgayo ama kugazigwa sama ya imbuli ya Mulungu, woileka hima. ");
INSERT INTO zajp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wanhu wayagwe walinga kamba mbeyu zilagalile mmizomola. Wanhu wano iwo waihulike imbuli ya Mulungu, ");
INSERT INTO zajp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ila mzahimzahi wa ulumwengu uno, kunogela mali na msulukilo wa vinhu bwando viyagwe mmioyo yao voizingiliza imbuli ya Mulungu, avo hawalela mujo. ");
INSERT INTO zajp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ila wanhu wayagwe walinga kamba mbeyu zilagalile muna ulongo unogile. Waihulika imbuli ya Mulungu na waitogola na kulela mujo, wayagwe malongo madatu, wayagwe malongo sita na wayagwe mia.” ");
INSERT INTO zajp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu kagendelela kulonga, “Vino kuna munhu yogala mng'anda kiwenge na kukigubika na kinongo ama kukika hauvungu wa lusazi? Nokona si vivo! Kokika mkingolobweda. ");
INSERT INTO zajp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kinhu chochose kifisigwe chovumbuligwa, na kinhu chochose kigubikigwe chogubuligwa. ");
INSERT INTO zajp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Munhu yali na magwiti na yahulike.” ");
INSERT INTO zajp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Vivija kawalongela, “Gagelegezeni ng'hani gaja gomuhulika! Mhima iija yondamuwapimile wayagwe, iyo mhima yondampimilwe mweye, tena yobanziliza. ");
INSERT INTO zajp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Waja wali na kinhu wokongezeligwa, na waja walibule kinhu, wobokigwa hata kija ikinhu kidodo kiwalinacho.” ");
INSERT INTO zajp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu kagendelela kulonga, “Undewa wa Mulungu ulinga na munhu yomiza mbeyu mumgunda wake. ");
INSERT INTO zajp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ikilo kowasa na imisi kameso, kipigiti kino chose zimbeyu zozuka na kukula. Ila mwenyego havimanya mbuli zino vuzitendeka. ");
INSERT INTO zajp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ulongo wenyego woutenda umche ukule na kulela. Wosonga koneka umche, abaho matepo, abaho ngano muna imikungwi. ");
INSERT INTO zajp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ngano ihakangala, iyo imunhu kosonga kusenga na zele jake, kwavija kipigiti cha kusenga kivika.” ");
INSERT INTO zajp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu kalonga, “Undewa wa Mulungu tuulinge na choni? Tuulonge mdihala jaki? ");
INSERT INTO zajp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ulinga kamba munhu yasolile mbeyu ya haladali, mbeyu ndodo kubita mbeyu zose muulumwengu, na kuzihanda muisi. ");
INSERT INTO zajp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mkipigiti kiguhi yokula yowa biki kulu ng'hani kubanza mibiki yose na kulava mitambi mikulu mbaka ndege wokwiza na kuzenga mvulu zao muna imbeho yake.” ");
INSERT INTO zajp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu kawapetela wanhu mbuli zake mmahala bwando galingile na gano. Kawalongela kamba viwadahile kuvitanga. ");
INSERT INTO zajp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Halongile nao chochose bila mahala. Ila viyakalile yeiyeka na wanahina zake, kawalongela kila kinhu. ");
INSERT INTO zajp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ichungulo ya zua didija, Yesu kawalongela wanahina zake, “Tuloke mwambu wa ikabili wa idilamba.” ");
INSERT INTO zajp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Avo wadileka dale da wanhu, wanahina wengila mngalawa ija Yesu yaakalile yeshile kukala, wamsola wachola hamoja nayo. Ngalawa ziyagwe vivija zikala bahaja. ");
INSERT INTO zajp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Baho dilawilila kukuzumbi, na mawimbi gasonga kuikunhiza ingalawa, avo isonga kumema mazi. ");
INSERT INTO zajp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu kakala kukisogo mwa ingalawa kawasa kuno pala jake kasagamila muna umto. Wanahina wamulamusa wamulongela, “Mkulufunzi! Hukona vihile vitulonda kudanganhika?” ");
INSERT INTO zajp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu kema wima kadikomhokela dibeho, yolonga, “Nyamala!” Na kagalongela ga mawimbi, “Ituze!” Beho dinyamala, na kukala hapozike. ");
INSERT INTO zajp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Abaho, Yesu kawalongela wanahina zake, “Habali mkona bwembwe? Mng'hali mwabule nhamanila?” ");
INSERT INTO zajp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ila wakala wodumba ng'hani na wakala wokiilongela, “Munhu waki ino? Hata beho na mawimbi vomuhulika!” ");
INSERT INTO zajp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na wanahina zake wavika mwambu uyagwe wa Idilamba da Galilaya muisi ya Gelasi. ");
INSERT INTO zajp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kipigiti kikija Yesu viyahumuluke muna ingalawa, munhu yali na vinyamkela kulawa kuna gamapanga hima kamwizila. ");
INSERT INTO zajp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Munhu ino kakala yokala kuna gamapanga, haduhu munhu yadahile kumfungiliza hata na mnyolo. ");
INSERT INTO zajp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mianza bwando wamdaza gamagulu na makono gake na mhikwi na minyolo, ila kaitola iminyolo na kuzibena zimhikwi ziwamdazile mmagulu gake. Haduhu munhu yakalile na mbavu za kumgoga. ");
INSERT INTO zajp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Imisi na ikilo kakala yoembea mmapanga na m'vigongo yoguta nyangi na kuikanhakanha na mabwe. ");
INSERT INTO zajp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Viyamuwene Yesu yang'hali kutali, kamkimbilila, kamfugamila mavindi, ");
INSERT INTO zajp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","kaguta lwangi, kalonga, “Yesu, Mwana wa Mulungu Mkulu Ng'hani! Konilonda choni? Mtwaga da Mulungu, nokuyalalila, sambiungaze!” ");
INSERT INTO zajp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kalonga vino kwavija Yesu kakala yomulongela, “Kinyamkela, mulawe munhu ino!” ");
INSERT INTO zajp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Avo Yesu kamuuza, “Twaga jako dijo dilihi?” Ija imunhu kamwidika, “Twaga jangu ‘Dale’ kwavija twa bwando!” ");
INSERT INTO zajp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kagendelela kumuyalalila Yesu sambiyawawinge walawe muisi ija. ");
INSERT INTO zajp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kukala na dale kulu da mitumbi behi na haja, woja hana ikigongo. ");
INSERT INTO zajp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Avo ivinyamkela wamuyalalila Yesu wolonga, “Tugale ha imitumbi, na utuleke tukaiingile.” ");
INSERT INTO zajp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu kawaleka wachole, na ivinyamkela wamulawa munhu ija na kuiingila imitumbi. Dale jose da imitumbi divikila alufu mbili, dihumuluka mdigema, dingila mdilamba na kudanganhikila mmazi. ");
INSERT INTO zajp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wachunga wa imitumbi wakimbila, wabwililisa mbuli zija mkiwambo na mmigunda. Wanhu wachola kulola kija kilawilile. ");
INSERT INTO zajp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Viwavikile ha Yesu, wamona munhu ija yakalile na dale da vinyamkela, kakala hasi, kavala na yali na nzonzi zake, na wanhu wose wona bwembwe. ");
INSERT INTO zajp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Waja wagonile gaja wawalongela wanhu gaja gamulawilile ija imunhu yali na vinyamkela na mbuli za ija imitumbi. ");
INSERT INTO zajp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Avo wanhu wamulongela Yesu yasegele muundewa wao. ");
INSERT INTO zajp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu viyakwelile mngalawa, ija imunhu yakalile na vinyamkela kaiyalala yomulongela, “Nolonda tuchole tose.” ");
INSERT INTO zajp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ila Yesu kamgomesa, kamulongela, “Genda hakae yako mmulango wako na uwalongele mbuli zose zayakutendele Mndewa na vija viyakonele bazi.” ");
INSERT INTO zajp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Avo munhu ija kasegela kachola muna iviwambo longo dimwe vikemigwa Dekapoli, yopeta gaja Yesu gayamtendele. Na wanhu wose wahulike wakanganya ng'hani. ");
INSERT INTO zajp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu kakwela kabili muingalawa, kabweleganya mwambu uyagwe wa idilamba, ako dale kulu da wanhu kudiilundize muimhwani dimzunguluka heyo. ");
INSERT INTO zajp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mkulu imwe wa ing'anda ya nhambiko, yokemigwa Yailo, kavika. Viyamonile Yesu, kaibwanha hasi ha magulu gake, ");
INSERT INTO zajp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kaiyalala kamulongela yomgong'ondeza, “Mndele wangu imdodo mtamu ng'hani. Avo izo umwikile makono gako yahone!” ");
INSERT INTO zajp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Avo Yesu kachola nayo. Wanhu bwando wamkoleleza wakala wokiibabana nayo ng'ambu zose. ");
INSERT INTO zajp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bahaja kukala na mtwanzi yakalile na utamu wa kutumika mkipigiti cha milao longo dimwe na mibili. ");
INSERT INTO zajp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kakala yagangigwe na mafundi bwando, kasa hela zake zose, na utamu wake ugendelela kongezeka ng'hani. ");
INSERT INTO zajp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Viyahulike singilimo za Yesu, kengila mdidale da wanhu hachugu cha Yesu na kudikwasa valo jake. ");
INSERT INTO zajp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kwavija kalonga munda kwa munda, “Nihakwasa vivalo vake, nohona.” ");
INSERT INTO zajp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Bahaja kutumika kuleka, na kakiihulika mulukuli lwake kamba kahonyigwa utamu wake. ");
INSERT INTO zajp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Bahaja Yesu kavitanga kamba mhiko zimulawa, avo kawahindukila didale da wanhu kawauza, “Yalihi yakwasile vivalo vangu?” ");
INSERT INTO zajp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wanahina zake wamwidika, “Kowona wanhu viwakumemele, habali uuza yalihi yakukwasile?” ");
INSERT INTO zajp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ila Yesu kagendelela kulolesa, yamone yatendile vija. ");
INSERT INTO zajp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mtwanzi ija kagatanga gaja gamulawilile, avo keza yogudema kuno yokona bwembwe, kaibwanha hasi ha magulu gake, kamulongela ikweli yose. ");
INSERT INTO zajp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu kamulongela, “Mndele wangu, nhamanila yako ikuhonya. Genda mditindiwalo na utamu wako uhone.” ");
INSERT INTO zajp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu viyakalile yolonga vija, weza wasenga kulawa kung'anda ya Yailo wamulongela, “Mndele wako kadanganhika. Habali ugendelela kumgaza mkulufunzi?” ");
INSERT INTO zajp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu hagategeleze gaja iwasenga gawalongile, ila kamulongela Yailo, “Sambiudumbe, tamanila tu.” ");
INSERT INTO zajp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Abaho, Yesu hamtogoze munhu yoyose yachole nayo ila Petulo, Yakobo, na Yohana ndugu yake Yakobo. ");
INSERT INTO zajp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wavika hang'anda ya Yailo, Yesu kona kiyahiyahi na wanhu wolila na kulombokeza. ");
INSERT INTO zajp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kengila mng'anda na kuwalongela, “Kiyahiyahi chose kino cha choni? Habali mulila? Mwana hadanganhike ino, ila kawasa!” ");
INSERT INTO zajp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wamseka, avo kawalava kunze wose, kawasola tata na mama wa imwana na wanahina zake wadatu, abaho, wengila kugati kuyatambalikigwe imwana. ");
INSERT INTO zajp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kamgoga mkono na kumulongela, “Talita komu!” Nhegulo yake, “Mndele, nokulongela, lamuka!” ");
INSERT INTO zajp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kipigiti kikija ija imndele kenuka, kasonga kutembela, kwavija kakala na milao longo dimwe na mibili. Vigalawilile gano wanhu wakanganya ng'hani. ");
INSERT INTO zajp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ila Yesu kawagomesa yowagong'ondeza, sambiwamulongele munhu yoyose, abaho, kawalongela, “Mgweleleni kinhu cha kuja.” ");
INSERT INTO zajp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu kahalawa haja kabwela hakiwambo cha hakae yake, na wanahina zake wamkweleleza. ");
INSERT INTO zajp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Muna Dizua da Mhumulo Yesu kasonga kufundiza muna ing'anda ya nhambiko, kukala na wanhu bwando, na viwamuhulike, wanhu wose wakanganya, walonga, “Kagapata kwahi mafundizo gano gose? Na ng'hungwe yaki ino yagweleligwe, na kodahaze kutenda mizonza? ");
INSERT INTO zajp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ino sio salamala, mwanage Maliamu, na mkulu wao kina Yakobo, Usufu, Yuda, na Simoni? Na walumbu zake si wano wokala bahano?” Avo wamulema. ");
INSERT INTO zajp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu kawalongela, “Wahokozi wohishimilwa kila hanhu, ila hawahishimilwa m'viwambo vao wenyego na mwa wandugu zao na mmilango yao wenyego.” ");
INSERT INTO zajp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hadahile kutenda mizonza yoyose haja, ila kawekila makono gake watamu wabili wadatu kawahonya. ");
INSERT INTO zajp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kakanganya ng'hani, avija wanhu wa haja viwalibule nhamanila. Abaho, Yesu kachola kuna iviwambo vizunguluke haja, yowafundiza wanhu. ");
INSERT INTO zajp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu kawakema wanahina longo dimwe na wabili hamoja, na kawatuma wabiliwabili. Kawagwelela udaho wa kuwinga vinyamkela ");
INSERT INTO zajp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","na kawalagiza, yowalongela, “Sambimsole kinhu chochose mmwanza wenu, ila fimbo iiyeka. Sambimsole mkate, mkoba, ama hela. ");
INSERT INTO zajp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Valeni ng'hwabasa, ila sambimpape kivalo kiyagwe.” ");
INSERT INTO zajp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Vivija kawalongela, “Hanhu hohose hondam'bokeligwe, kaleni baho mbaka vondamsegele. ");
INSERT INTO zajp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kamba muhengila mkiwambo na wanhu wahalema kuwabokela ama wahalema kuwategeleza, segeleni na kung'unheni timbwisi dili mmagulu genu. Iyo yowa nzuma yao!” ");
INSERT INTO zajp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Avo wachola na kuwapetela wanhu waleke vilozo vao. ");
INSERT INTO zajp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wawinga vinyamkela bwando, na kuwabakaza mavuta ga mizaituni watamu na kuwahonya. ");
INSERT INTO zajp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mndewa Helode Antipa, mtawala wa Galilaya, kazihulika mbuli zino, kwavija sang'hano za Yesu zenela kila hanhu. Wanhu wayagwe walonga, “Yohana M'batiza kazuka. Kino kicho kilamso kana mhiko zino za kutenda mizonza.” ");
INSERT INTO zajp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wayagwe walonga, “Ino iyo Eliya.” Na wayagwe walonga, “Ino iyo muhokozi yalingile kamba imwe wa wahokozi wa umwaka.” ");
INSERT INTO zajp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Helode viyahulike, kalonga, “Ino iyo Yohana M'batiza! Nimkanhile pala jake, kawa mgima kabili!” ");
INSERT INTO zajp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kwavija Helode mwenyego kakala yalagize Yohana yagogigwe, abaho, yageligwe mkifungo. Katenda vino sama ya Helodia mtwanzi wa Filipo mkulu wake, ayo yakalile yamsolile. ");
INSERT INTO zajp_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kwavija Yohana kakala yananahile kumulongela Helode, “Havilumbile gweye kumsola mtwanzi wa mkulu wako Filipo.” ");
INSERT INTO zajp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Avo Helodia kamwihila Yohana, kalonda kumkoma, ila hadahile. ");
INSERT INTO zajp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helode kamdumba Yohana kwavija kavitanga kamba Yohana hakalile munhu kizenzeleganye na kakala munhu wa Mulungu, avo kamwimiliza. Kanogelwa kumtegeleza, ila yehesha kumtegeleza kakala yogaya ng'hani mkugelegeza, ila kipigiti chose kakala yomtegeleza. ");
INSERT INTO zajp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hakimambukizo, Helodia kapata nzila. Dikala zua da ng'humbukila ya mvumbuka ya Helode, kipigiti Helode vayawatendele lusona wakulu wose wa silikali, wakulu wa asikali, na wakulu wa wenekae wa Galilaya. ");
INSERT INTO zajp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mndele wa Helodia kengila na kuvina, Helode na iwahenza wakalile baho wanogelwa ng'hani. Avo mndewa kamulongela ija imndele, “Nipule kinhu chochose chuulonda, nokugwelela.” ");
INSERT INTO zajp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mkuiduila kamulongela, “Nokugwelela kinhu chochose chondaunipule, hata lwenza lwa undewa wangu.” ");
INSERT INTO zajp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Avo ija imndele kalawa kunze kumuuza mamaake, “Nikapule choni?” Na heyo kamulongela, “Pala da Yohana M'batiza.” ");
INSERT INTO zajp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ija imndele kabwela hima ha mndewa na kupula, “Nolonda unigwelele sambisambi pala da Yohana M'batiza muna ulungo!” ");
INSERT INTO zajp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mndewa kona giogio ng'hani, ila sama ya kiduilo chayaiduile na sama ya iwahenza wakalile haja hameza, hadahile kulema. ");
INSERT INTO zajp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Avo kamulagiza asikali yomkomhokela yagale pala da Yohana. Asikali kachola mding'anda da kufungila wanhu, na kukanha pala da Yohana. ");
INSERT INTO zajp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Abaho, kadigala mulungo na kumgwelela imndele, na heyo kamgwelela mamaake. ");
INSERT INTO zajp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wanahina wa Yohana viwahulike gano, weza kulusola lukuli lwake na kuluzika. ");
INSERT INTO zajp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iwatumigwa wa Kilisto wabwela waiting'hana na Yesu wamulongela gose gawatendile na kufundiza. ");
INSERT INTO zajp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kukala na wanhu bwando wayagwe wokwiza na wayagwe wochola mbaka Yesu na wanahina zake hawapatile hata kipigiti cha kuja. Avo Yesu kawalongela, “Tusegeleni tuchole hanhu ha kifiso, muhumule kidogo.” ");
INSERT INTO zajp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Avo wakwela mngalawa wasonga kusegela weiyeka, wachola hanhu ha kifiso. ");
INSERT INTO zajp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Wanhu bwando wawona vowosegela, mkipigiti kiguhi wawatanga, avo wanhu kulawa m'viwambo vose wakimbila na magulu na walongola kuvika hanhu hayakalile yochola Yesu na wanahina zake. ");
INSERT INTO zajp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu viyahumuluke muna ingalawa, kajona dale kulu da wanhu, kawonela bazi mmoyo kwavija wakala kamba ng'hondolo walibule mchunga. Avo kasonga kuwafundiza vinhu bwando. ");
INSERT INTO zajp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Zua vidiswile, wanahina zake wamcholela wamulongela, “Zua diswa na hano hatuli twa muluwala, ");
INSERT INTO zajp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","walongele wanhu wachole mmigunda na m'viwambo va mmabehi giladi wakagule vinhu vakuja.” ");
INSERT INTO zajp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu kawedika, “Wagweleleni mwenye vinhu vakuja.” Na hewo wamuuza, “Kolonda tuchole tukawagulile mikate ya kitumetume cha munhu cha milenge minane tuwagwelele waje?” ");
INSERT INTO zajp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Avo Yesu kawauza, “Mikate mingahi imulinayo? Gendeni mkalole.” Viwayonile, wamulongela, “Ilibaho mikate mitano na somba wabili.” ");
INSERT INTO zajp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Abaho, Yesu kawalongela wanahina zake wawagole wanhu wose muna gamadale na kuwalongela wakale hasi muluzondo. ");
INSERT INTO zajp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Avo wanhu wakala hasi mmadale ga wanhu miamia na wanhu malongo matanomatano. ");
INSERT INTO zajp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Abaho, Yesu kaisola ija imikate mitano na iwasomba wabili, kalola uchana kuulanga, na kamgwelela hewela Mulungu. Kaimogola imikate na kuwagwelela wanahina zake wawagolele wanhu. Vivija kawagolela iwasomba wabili wanhu wose. ");
INSERT INTO zajp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wanhu wose waja na kwiguta. ");
INSERT INTO zajp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Abaho, wanahina wadondola migelo longo dimwe na mibili ya imikate na iwasomba wasigale. ");
INSERT INTO zajp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mheta ya wambigalo wadile wakala alufu tano. ");
INSERT INTO zajp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bahaja Yesu kawalongela wanahina zake wakwele muingalawa walongole kuchola Betisaida, mwambu uyagwe wa idilamba, kipigiti heyo vayakalile yowalaga wanhu. ");
INSERT INTO zajp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Viyeshile kuwalaga iwanhu, kachola hakigongo kutambika. ");
INSERT INTO zajp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Viivikile ichungulo, ngalawa ikala hadidindi da idilamba, kipigiti Yesu viyakalile yeiyeka mulusanga. ");
INSERT INTO zajp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kawona wanahina zake wogaya kuzikunhiza zinyiko kwavija wakala wochola kudilawa beho, avo mkipigiti cha hagatigati ya nzogolo zikwika na imitondo, kawacholela yotembela uchana ya igamazi. Kalonda kuwabita, ");
INSERT INTO zajp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ila wamona yotembela uchana ya igamazi. Watoa nyangi wagiza wona mzimu. ");
INSERT INTO zajp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Wose viwamuwene wona bwembwe. Bahaja Yesu kawalongela, “Iyo nie, sambimdumbe.” ");
INSERT INTO zajp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Abaho, kakwela mngalawa hamoja nao, na dibeho dinyamala. Wanahina zake wakanganya ng'hani. ");
INSERT INTO zajp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kwavija hawakitangile kilamso cha kuwagwelela mandia wanhu alufu tano, nzonzi zao hazigogile gaja. ");
INSERT INTO zajp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Waloka idilamba na wavika muisi ya Genesaleti, aho hawaitatilize ngalawa yao. ");
INSERT INTO zajp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Viwahumuluke mngalawa bahaja wanhu wamtanga Yesu. ");
INSERT INTO zajp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Avo wanhu wakimbila muna iisi yose, wasonga kuwagala watamu mmachela kokose kuwamuhulike. ");
INSERT INTO zajp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na kila hanhu Yesu kuyacholile m'viwambo, mmiwambo, ama mmigunda, wanhu wawasola watamu wawagala hadisoko na wamuyalalila womulongela yawaleke wakwase hata lugigo lwa kivalo chake, na wose wakwasile wahona. ");
INSERT INTO zajp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafalisayo wayagwe na wafundiza Malagizo ga Musa walawile Yelusalemu weza wailundiza haulongozi wa Yesu. ");
INSERT INTO zajp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wona wanahina wayagwe wa Yesu woja vakuja kuno makono gao ganyolodoke, kwavija gakala hagananavigwa. ");
INSERT INTO zajp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kwavija Mafalisayo na Wayahudi wose, hawaja mbaka wasunguse ng'hani makono gao kamba viilondigwa, sama ya kuwinza mafundo ga wahenga zao. ");
INSERT INTO zajp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hawaja kinhu chochose kilawa hadisoko mbaka wakisuluze. Na wawinza mafundo bwando gawabokele kulawa mwa wahenga zao, kamba vija, kusuluza vikasi, viteleko, na via va shaba. ");
INSERT INTO zajp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Avo, Mafalisayo na wafundiza Malagizo ga Musa wamuuza Yesu, “Habali wanahina zako hawagawinza mafundo gatufundizigwe na wahenga, ila woja na makono ganyolodoke?” ");
INSERT INTO zajp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu kawedika yolonga, “Muhokozi Isaya kahokola goya viyahokole yowalonga mweye! Mweye videlenya, kamba vija viyandike, ‘Wanhu wano wonihishimila mmilomo yao, ila mioyo yao yakutali na nie. ");
INSERT INTO zajp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wonitambikila nie bule, kwavija wofundiza mafundo ga wanhu kamba Malagizo gangu!’ ");
INSERT INTO zajp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mzika hamgwazo ndagizi za Mulungu, na mgawinza mafundo ga wanhu.” ");
INSERT INTO zajp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu kagendelela kulonga, “Muna ubala wa kuzilema ndagizi za Mulungu giladi mgatunize mafundo genu wenyego. ");
INSERT INTO zajp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa kalagiza, ‘Wahishimile tataako na mamaako,’ na ‘Munhu yoyose yomulonga vihile tataake ama mamaake, yakomigwe.’ ");
INSERT INTO zajp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ila mweye mofundiza kamba, kamba munhu kana kinhu cha kumgwelela tata ama mamaake, ila yahalonga, ‘Kinhu kino kicho Kolubani,’ nhegulo yake, ‘Nhosa ya Mulungu,’ ");
INSERT INTO zajp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","avo halondigwa kuwataza mkuwagwelela vinhu tata na mamaake. ");
INSERT INTO zajp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Vino vivo mafundo gamuwafundiza wanhu vigobeza mbuli za Mulungu. Na kuna vinhu viyagwe bwando kamba vino vimtenda.” ");
INSERT INTO zajp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Abaho, Yesu kadikema kabili didale da wanhu, kawalongela, “Nitegelezeni na m'vitange. ");
INSERT INTO zajp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Haduhu kinhu kimwingila munhu kulawa kunze chondakimtende munhu yanyolodoke. Ila kija kimulawa munhu, kicho kimtenda munhu yanyolodoke.” ");
INSERT INTO zajp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Munhu yali na magwiti ga kuhulika, na yahulike! ");
INSERT INTO zajp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Viyadilekile didale da wanhu na kwingila mng'anda, wanahina zake wamulonda yawalongele goya hala dino. ");
INSERT INTO zajp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu kawalongela, “Na mweye vivija hamnavitanga? Ham'vimanya kamba kinhu chochose kingila mgati mwa munhu kulawa kunze hakidaha kumnyolodosa, ");
INSERT INTO zajp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kwavija hakimwingila mmoyo, ila mmunda, abaho, chochola kucholo?” Viyalongile vino, Yesu kavilonga vakuja vose vidigwe. ");
INSERT INTO zajp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesu kagendelela kulonga, “Kija kimulawa munhu kicho kimtenda yanyolodoke. ");
INSERT INTO zajp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwavija kulawa mgati ya umoyo wa munhu, molawa ngelegeza zihile, ugoni, ubavi, kukoma, ");
INSERT INTO zajp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ugoni, ugila, kutenda gehile, sulukila ya ugoni, uzenzeleganye, sulukila za kulonda vinhu bwando, migongo, kuilonga vihile, magoda, na ubozi. ");
INSERT INTO zajp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mbuli zose zino zihile zilawa mgati mwa munhu na zizo zimtenda yanyolodoke.” ");
INSERT INTO zajp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu kalawa kachola muisi ili behi na wambo da Tilo. Kengila muna ing'anda imwe na halondile munhu yoyose yavitange kamba kahaja, ila hadahile kuifisa. ");
INSERT INTO zajp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mtwanzi imwe, mndele wake yakalile na kinyamkela, kahulika mbuli za Yesu, hima kamwizila kamfugamila mavindi haulongozi wake. ");
INSERT INTO zajp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mtwanzi ija kakala Mmhazi, yaleligwe ng'ambu ya Foinike muisi ya Silia. Kaiyalala yomulongela Yesu yamuwinge ikinyamkela yam'vamhile mndele wake. ");
INSERT INTO zajp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ila Yesu kamwidika, “Beta tanhu iwana wegute. Havinogile kusola mandia ga wana na kuwagwelela umbwa.” ");
INSERT INTO zajp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ija mtwanzi kamwidika, “Mndewa! Hata umbwa woja vakuja viwasigaze iwana hasi ya imeza.” ");
INSERT INTO zajp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Avo Yesu kamulongela, “Sama ya mbuli zako zino, genda ukae kom'vika kinyamkela kamulawa mndele wako!” ");
INSERT INTO zajp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kachola ukae kam'vika mwanage yawasile mulusazi, na kweli kinyamkela kamulawa. ");
INSERT INTO zajp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Abaho, Yesu kasegela muna iisi ya Tilo, kachola Lamba da Galilaya kubitila Sidoni mbaka muisi ya viwambo longo dimwe vikemigwa Dekapoli. ");
INSERT INTO zajp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Wanhu wamgalila munhu yakalile kinziwi na bubui, wamuyalalila Yesu yamwikile makono gake. ");
INSERT INTO zajp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu kamsola yeiyeka, kamgala kutali na ididale da wanhu, kagela vidole vake mmagwiti ga ija imunhu, kazenha vizite, abaho, kalukwasa lulimi lwake. ");
INSERT INTO zajp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Abaho, Yesu kalola uchana kuulanga, kabweza mhumuzi, na kumulongela ija imunhu, “Efata!” Nhegulo yake, “Vuguka!” ");
INSERT INTO zajp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bahaja munhu ija magwiti gake gahulika, kigagaziko chake kisegezigwa, avo kasonga kulongelela bila kugaya. ");
INSERT INTO zajp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Abaho, Yesu kawagong'ondeza wanhu sambiwamulongele munhu yoyose mbuli ija. Ila avija viyakalile yowagong'ondeza ng'hani vivo vowokala wobwililisa ng'hani. ");
INSERT INTO zajp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wanhu wose wahulike wakanganya ng'hani na walonga, “Kila kinhu kotenda goya! Kawatenda hata vinziwi wahulike na mabubui walonge!” ");
INSERT INTO zajp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mazua madodo hamwande, dale kulu diyagwe da wanhu waiting'hana hamoja. Wanhu wakala wabule kinhu chochose cha kuja, Yesu kawakema wanahina zake kawalongela, ");
INSERT INTO zajp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nowonela bazi wanhu wano, kwavija wakala na nie mazua madatu, na kipigiti kino wabule kinhu cha kuja. ");
INSERT INTO zajp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nihawalongela wachole mkae zao na nzala, wosinduka mnzila, kwavija wayagwe walawa kutali.” ");
INSERT INTO zajp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wanahina zake wamuuza, “Muluwala luno kwahi munhu kondayazahile mandia ga kuwagwelela wanhu wose wano?” ");
INSERT INTO zajp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu kawauza, “Mikate mingahi imulinayo?” Wamulongela, “Mikate saba.” ");
INSERT INTO zajp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu kadilongela didale da wanhu dikale hasi. Abaho, kaisola ija imikate saba, kalonga hewela ha Mulungu, kaimogola na kuwagwelela wanahina zake wawagolele iwanhu, na wanahina watenda kamba viwalagizwe. ");
INSERT INTO zajp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Vivija wakala na visomba vidogodogo. Yesu kalonga hewela ha Mulungu, vivija kawalongela wanahina zake wawagolele iwanhu. ");
INSERT INTO zajp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wanhu wose waja weguta, wanahina zake wadondola, wamemeza migelo saba ya vakuja visigale! ");
INSERT INTO zajp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wakala wanhu alufu nne. Yesu kawalaga iwanhu wachole kumwao. ");
INSERT INTO zajp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kipigiti kikija kakwela mngalawa hamoja na wanahina zake wachola muisi ya Dalumanuta. ");
INSERT INTO zajp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mafalisayo wamcholela Yesu wasonga kuibamilila nayo. Wamwikila vitega wamulonda yatende mzonza wone kamba Mulungu kamtogola. ");
INSERT INTO zajp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ila Yesu kabweza mhumuzi, kalonga, “Habali wanhu wa mazua gano wolonda mzonza? Haduhu, nowalongela! Haduhu ikweli yondamgweleligwe!” ");
INSERT INTO zajp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Abaho, kawaleka, kakwela muna ingalawa na kasonga kuloka mwambu uyagwe wa idilamba. ");
INSERT INTO zajp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Wanahina wakala waisemwile kusola mikate na wakala na mkate umwe mngalawa. ");
INSERT INTO zajp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu kawazuma, kawalongela, “Iteganyeni na mela da Mafalisayo na mela da Helode.” ");
INSERT INTO zajp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wasonga kuilongela wenyego kwa wenyego, “Kolonga vino kwavija twabule mikate.” ");
INSERT INTO zajp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu kagatanga gaja gawakalile wolonga, avo kawauza, “Habali mulongelela avija vimulibule mikate? Ham'vimanya ama hamnavitanga? Mwabule nzonzi? ");
INSERT INTO zajp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Muna meso ila hamulola? Muna magwiti ila hamuhulika? Muisemwa ");
INSERT INTO zajp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","avija viniimogole imikate mitano na kuwagwelela wanhu alufu tano, migelo mingahi ya imikate isigale imdondole?” Wamwidika, “Longo dimwe na mibili.” ");
INSERT INTO zajp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu kawauza kabili “Na vinimogole imikate saba na kuwagwelela wanhu alufu nne, migelo mingahi imemile ya imikate isigale imdondole?” Wamwidika, “Saba.” ");
INSERT INTO zajp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesu kawauza, “Mng'hali hamnavitanga?” ");
INSERT INTO zajp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wavika Betisaida, wanhu wamgala munhu kimbugumbugu ha Yesu, wamuyalalila yamkwase. ");
INSERT INTO zajp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu kamgoga mkono ija imunhu kimbugumbugu, kamgala kutali na ikiwambo. Kamtemela visite mmeso, abaho, kamwikila makono gake, kamuuza, “Kodaha kulola kinhu chochose?” ");
INSERT INTO zajp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ija imunhu kalola uchana kalonga, “Nowona wanhu, ila wokoneka kamba mibiki itembela.” ");
INSERT INTO zajp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu kamwikila makono mwanza uyagwe mmeso, mwanza uno kaiyoha kubunhula, na meso gake gananazuka, kadaha kulola goya kila kinhu. ");
INSERT INTO zajp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Abaho, Yesu kamulagiza yachole ukae yomgong'ondeza, yolonga, “Sambiubweleganye muna ikiwambo.” ");
INSERT INTO zajp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Abaho, Yesu na wanahina zake wachola kuna iviwambo behi na Kaisalia Filipi. Viwakalile mnzila kawauza, “Nongeleni, wanhu wolonga nie iyo munhu yalihi?” ");
INSERT INTO zajp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wamwidika wolonga, “Wayagwe wolonga gweye iyo Yohana M'batiza, wayagwe wolonga gweye iyo Eliya, wayagwe wolonga gweye iyo imwe wa wahokozi.” ");
INSERT INTO zajp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu kawauza, “Na mweye molonga nie iyo munhu yalihi?” Petulo kamwidika, “Gweye iyo Kilisto yasaguligwe na Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Abaho, Yesu kawalagiza, “Sambimmulongele munhu yoyose mbuli zino.” ");
INSERT INTO zajp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Abaho, Yesu kasonga kuwafundiza wanahina zake kawalongela, “Nie, Mwana wa Munhu, nolondigwa nigazigwe ng'hani na kulemigwa na wakulu, wakulu wa wakulu wa nhambiko, na wafundiza Malagizo ga Musa. Nokomigwa, ila mazua madatu hamwande nozuka nowa mgima kabili.” ");
INSERT INTO zajp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kawalongela kinaganaga. Avo Petulo kamsola kamgala hamgwazo kasonga kumkomhokela. ");
INSERT INTO zajp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ila Yesu kahinduka kukisogo, kawalola wanahina zake na kumkomhokela Petulo, yolonga, “Segela hamwangu, Mwenembago! Ngelegeza zako hazilawa ha Mulungu ila zolawa mwa wanhu.” ");
INSERT INTO zajp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Abaho, Yesu kadikema ididale da wanhu hamoja na wanahina zake kawalongela, “Kamba munhu yahalonda kuwa mwanahina wangu, yaibele mwenyego, yaidikwe msalaba wake yanikoleleze. ");
INSERT INTO zajp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kwavija munhu yoyose yahalonda kuukombola ugima wake kowagiza, ila munhu yoyose yowagiza ugima wake, sama yangu nie na sama ya Usenga Unogile, koukombola. ");
INSERT INTO zajp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Vino wanhu wokwing'higwa choni kamba wahagweleligwa vinhu vose vili muisi, abaho, wawagize ugima wao? Nokona haduhu! ");
INSERT INTO zajp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Haduhu kinhu chondawalave wabweze ugima wao. ");
INSERT INTO zajp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ihawa munhu yahanyonela kinyala nie na mafundo gangu mwa wanhu wano walibule bwembwe da Mulungu na mmazua gano gehile, avo nie, Mwana wa Munhu, nomonela kinyala munhu hiyo vondanize muna iyenzi ya Tata wangu hamoja na wasenga wa Mulungu wa kuulanga wang'alile.” ");
INSERT INTO zajp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu kagendelela kulonga, “Nowalongela ikweli, hana wanhu hano hawadanganhika mbaka wawone Undewa wa Mulungu ukwiza na mhiko.” ");
INSERT INTO zajp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Vigabitile mazua sita, Yesu kawasola Petulo, Yakobo, na Yohana, kakwela nao kukigongo kitali weiyeka. Yesu kagaluka haulongozi wao. ");
INSERT INTO zajp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Vivalo vake vinang'hazika! Vikala vizelu, haduhu munhu yoyose muulumwengu yahadahile kuvisuluza kamba vija. ");
INSERT INTO zajp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Abaho, waja wanahina wadatu wamona Eliya na Musa wolongelela na Yesu. ");
INSERT INTO zajp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petulo kamulongela Yesu, “Mkulufunzi, vinoga tweye tukale hano, tuzenge vizewe vidatu, kimwe chako, kiyagwe cha Musa, na kiyagwe cha Eliya.” ");
INSERT INTO zajp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petulo haditangile da kulonga kwavija heyo na wayage wakala wokona bwembwe. ");
INSERT INTO zajp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Abaho, dilawilila wingu diwagubika, na dihulikwa dizwi kulawa mdiwingu, dilonga, “Ino iyo Mwanangu yanogele, mtegelezeni heyo!” ");
INSERT INTO zajp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Himahima walola kuno na kuno, hawamuwene munhu yoyose, ila Yesu yeiyeka hamoja na hewo. ");
INSERT INTO zajp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Viwakalile wohumuluka mkigongo, Yesu kawalagiza, yowalongela, “Sambimmulongele munhu yoyose gaja gamonile, mbaka nie, Mwana wa Munhu, vondanizuke kulawa mkudanganhika.” ");
INSERT INTO zajp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wagatogola malagizo gake, ila wenyego kwa wenyego wasonga kuigela msego mbuli ija, wokiiuza, “Kuzuka kulawa mkudanganhika ndo choni?” ");
INSERT INTO zajp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na hewo wamuuza Yesu, “Habali wafundiza Malagizo ga Musa wolonga tanhu yeze Eliya?” ");
INSERT INTO zajp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu kawalongela, “Vivo! Eliya kolongola kwiza, giladi yeke goya kila kinhu. Habali Nyandiko Zing'alile zolonga kamba Mwana wa Munhu kogazigwa ng'hani na kulemigwa? ");
INSERT INTO zajp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ila nowalongela kwa vovose, Eliya keza kesha, na wanhu wamtendela kamba viwalondile, kamba Nyandiko Zing'alile vuzimulonga.” ");
INSERT INTO zajp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Viwaiting'hanile na iwanahina wayagwe, wajona dale kulu da wanhu diwazunguluka wanahina zake na wafundiza wayagwe wa Malagizo ga Musa wokiibamilila. ");
INSERT INTO zajp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Waja iwanhu viwamuwene Yesu, wakanganya ng'hani na wamkimbilila wamulamsa. ");
INSERT INTO zajp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu kawauza wanahina zake, “Moibamilila choni?” ");
INSERT INTO zajp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Munhu imwe muna ididale da wanhu kamulongela, “Mkulufunzi, nimgala mmhale wangu kumwako, kwavija kana kinyamkela na hadaha kulonga. ");
INSERT INTO zajp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yaham'vamhila, kom'bwanha hasi na kolawa holovu mmulomo na kugegedula meno gake na kugangamala lukuli lwake lose. Niwalongela wanahina zako wamuwinge ikinyamkela, ila walemelwa.” ");
INSERT INTO zajp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu kawalongela, “Mweye wanhu mulibule nhamanila! Nokala namwe mbaka zua jaki? Nowazaganya mbaka zua jaki? Nigalile hano immhale!” ");
INSERT INTO zajp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wamgala ha Yesu. Kinyamkela viyamonile Yesu, bahaja kamgela kisango, kabwanhika hasi yobimbilika kuno holovu dimulawa mmulomo. ");
INSERT INTO zajp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu kamuuza tata wa imwana ija, “Kitamu kino kimsonga mazua gaki?” Na heyo kamwidika, “Songela udodo wake. ");
INSERT INTO zajp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mianza bwando kinyamkela kalonda kumkoma mkumulagazila hamoto na mmazi. Kamba vihadahika, utonele bazi na ututaze!” ");
INSERT INTO zajp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu kalonga, “Vihadahika! Gose godahika mwa imunhu yali na nhamanila.” ");
INSERT INTO zajp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hima tata wa imwana kenula dizwi yolonga, “Notogola, nhaza niuhume ubezi wa nhamanila unilinayo!” ");
INSERT INTO zajp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu viyonile dale da wanhu dowakwenhukila, avo kamkomhokela ikinyamkela kalonga, “Gweye kinyamkela kinziwi na bubui, nokulongela umulawe mmhale ino na sambiumwingile kabili!” ");
INSERT INTO zajp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kinyamkela kaguta lwangi, abaho, kamgela kisango na kumulawa. Mmhale iyo koneka konga munhu yadanganhike, na wanhu wose walonga, “Kadanganhika!” ");
INSERT INTO zajp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ila Yesu kamgoga mkono na kamtaza kwinuka, na heyo kema wima. ");
INSERT INTO zajp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu viyengile mng'anda, wanahina zake wamuuza kinyele, “Habali tweye hatudahile kumuwinga kinyamkela ija?” ");
INSERT INTO zajp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu kawedika, “Kinyamkela kamba ino kodaha kulawa kubitila nhambiko iiyeka, haduhu nzila iyagwe.” ");
INSERT INTO zajp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na wanahina zake wasegela hanhu haja wagendelela na mwanza wobitila muisi ya Galilaya. Yesu halondile munhu yoyose yavitange hanhu hayali, ");
INSERT INTO zajp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kwavija kakala yowafundiza wanahina zake, yowalongela, “Nie, Mwana wa Munhu, nogeligwa mmakono ga awo wondawanikome. Ila gahabita mazua madatu nozuka nowa mgima.” ");
INSERT INTO zajp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wanahina zake hawavitangile nhegulo ya fundo dino, na wadumba kumuuza. ");
INSERT INTO zajp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Wavika Kapenaumu, viwengile mng'anda Yesu kawauza wanahina zake, “Mkala mkiibamilila choni mnzila?” ");
INSERT INTO zajp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ila hawamwidike, kwavija mnzila wakala wokiibamilila wenyego kwa wenyego yalihi yali mkulu. ");
INSERT INTO zajp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu kakala hasi, kawakema wanahina zake longo dimwe na wabili, kawalongela, “Munhu yahalonda kuwa wa mwanduso kolondigwa yaibweze mwenyego hachugu cha wanhu wose na yawe mtumigwa wa wose.” ");
INSERT INTO zajp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Abaho, kamsola mwana, kamwimiza haulongozi wao. Kamkumbatila, abaho, kawalongela, ");
INSERT INTO zajp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Munhu yoyose yom'bokela imwe wa wana wano wadodo mtwaga jangu konibokela nie, na munhu yoyose yonibokela nie hanibokela nie niiyeka ila kom'bokela ayo yanhumile.” ");
INSERT INTO zajp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana kamulongela, “Mkulufunzi, tumona munhu yowinga vinyamkela na twaga jako, tumgomesa, kwavija halawa mdidale jetu.” ");
INSERT INTO zajp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu kawalongela, “Sambimumgomese, kwavija haduhu munhu yotenda mzonza mtwaga jangu, abaho, yanonge vihile. ");
INSERT INTO zajp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Munhu yoyose yalekile kuihasanya na tweye ka hamoja na tweye. ");
INSERT INTO zajp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nowalongela ikweli, kamba munhu yoyose yahawagwelela mweye kikasi cha mazi ga kung'wa, kwavija mweye mwa wanhu wa Kilisto, kobokela maliho gake. ");
INSERT INTO zajp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Munhu yoyose yondayamtende imwe wa wanhu wano wadodo yasegeze nhamanila yake kumwangu, vihanogile munhu ija yafungigwe msingo dibwe kulu da kusiginhila na kwasigwa m'bahali. ");
INSERT INTO zajp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Avo kamba mkono wako wokutenda gweye utenda vilozo, ukanhe! Vinoga kumwako kwingila muugima kuno ulibule mkono, kubanza kuwa na makono gose mabili, abaho, wasigwe kuzimu, ");
INSERT INTO zajp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ako ‘kuna iwamhembele hawafaga wondawawaje, na moto haufaga wondauwalukuze.’ ");
INSERT INTO zajp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na kamba mgulu wako wokutenda gweye utende vilozo, ukanhe! Vinoga kumwako kwingila muugima kuno ulibule mgulu, kubanza kuwa na magulu gose mabili, abaho, wasigwe kuzimu, ");
INSERT INTO zajp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ako ‘kuna iwamhembele hawafaga wondawawaje, na moto haufaga wondauwalukuze.’ ");
INSERT INTO zajp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na kamba siso jako dokutenda gweye utende vilozo, dilave! Vinoga kumwako kwingila Muundewa wa Mulungu na siso dimwe, kubanza kuwa na meso gose mabili, abaho, wasigwe kuzimu, ");
INSERT INTO zajp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ako ‘kuna iwamhembele hawafaga wondawawaje, na moto haufaga wondauwalukuze.’ ");
INSERT INTO zajp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kila munhu kong'alizwa na moto kamba vija nhosa viing'alizwa na munyu. ");
INSERT INTO zajp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Munyu unoga, ila uhagiza kilandu chake, kodahaze kuutenda unoge kabili? “Muwe kamba munyu, mkale mditindiwalo wenyego kwa wenyego.” ");
INSERT INTO zajp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu kahalawa hanhu haja, kachola muisi ya Yudea na kuloka mwambu wa ikabili wa Ulwanda lwa Yolodani. Dale da wanhu bwando dimcholela kabili, na heyo kawafundiza kamba viyatendaga. ");
INSERT INTO zajp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mafalisayo wamcholela na wageza kumwikila vitega wamulongela, “Tulongele, Malagizo getu gomtogoza munhu kumwasa mtwanzi wake?” ");
INSERT INTO zajp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu kawedika, kuwauza, “Musa kawalagiza choni?” ");
INSERT INTO zajp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wamwidika wamulongela, “Musa katogoza munhu yamwandikile lupwilili lwa nyasa mtwanzi wake, abaho, yamwase.” ");
INSERT INTO zajp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu kawalongela, “Sama ya udala wa mioyo yenu Musa kawandikila ndagizi ino. ");
INSERT INTO zajp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ila songela haichanduso, ‘Mulungu viyasongile kulumba, kalumba mtwanzi na mbigalo.’ ");
INSERT INTO zajp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Mkilamso kino mbigalo kowaleka tataake na mamaake na kuilumba na mwehe wake, ");
INSERT INTO zajp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na wabili wano wowa lukuli lumwe.’ Avo si wabili tena ila lukuli lumwe. ");
INSERT INTO zajp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Avo kiyalumbile hamoja Mulungu, munhu sambiyakimamazule.” ");
INSERT INTO zajp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Viwengile mng'anda mwanza wa ikabili, wanahina zake wamuuza Yesu mbuli ija. ");
INSERT INTO zajp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu kawalongela, “Munhu yoyose yomwasa mtwanzi wake na kusola mtwanzi iyagwe, komtendela ugoni mtwanzi wake. ");
INSERT INTO zajp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Vivija mtwanzi yomwasa mbigalo wake na kusoligwa na mbigalo iyagwe, kotenda ugoni.” ");
INSERT INTO zajp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wanhu wamgalila Yesu wana wadodo yawekile makono gake, ila wanahina zake wawakomhokela. ");
INSERT INTO zajp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu viyawawene, kona lusango kawalongela, “Walekeni wana wadodo weze kumwangu, sambimuwagomese kwavija Undewa wa Mulungu wa sama ya wanhu kamba wano. ");
INSERT INTO zajp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nowalongela ikweli, munhu yoyose yondayaleke kuubokela Undewa wa Mulungu kamba mwana mdodo hengila himo.” ");
INSERT INTO zajp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Abaho, kawakumbatila waja iwana na makono gake, kawekila makono gake, na kuwamoteza. ");
INSERT INTO zajp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu viyagendelele na mwanza wake, munhu imwe kamkimbilila, kamfugamila mavindi haulongozi wake, kamuuza, “Mkulufunzi Unogile, nhendeze giladi niubokele ugima wa digunge?” ");
INSERT INTO zajp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu kamuuza, “Habali ung'hema nie ninogile? Haduhu munhu yanogile ila Mulungu yeiyeka. ");
INSERT INTO zajp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kuzitanga ndagizi. ‘Sambiukome, sambiutende ugoni, sambiwibe, sambiulave usindila wa uvwizi, sambium'vwizile munhu yoyose, wahishimile tataako na mamaako.’ ” ");
INSERT INTO zajp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Munhu ija kamulongela, “Mkulufunzi, higo gose nigatenda songela haudodo wangu.” ");
INSERT INTO zajp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu kamulola kamnogela, kamulongela, “Kuhungukilwa na kinhu kimwe. Genda ukaguze vinhu vose vuulinavo, abaho, zihela uwagwelele wakumbulu, avo kowa na ngama kuulanga, abaho, unikoleleze.” ");
INSERT INTO zajp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Munhu ija viyahulike vija, kakunza kihanga kasegela kuno yokona giogio, kwavija kakala na mali bwando. ");
INSERT INTO zajp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu kazunguluka yowalola wanahina zake wose, kawalongela, “Vidala munhu mgoli kwingila muna Undewa wa Mulungu!” ");
INSERT INTO zajp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wanahina zake wasinhuka viwahulike mbuli zino, ila Yesu kagendelela kulonga, “Wanangu, vidala kwingila muna Uundewa wa Mulungu! ");
INSERT INTO zajp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Vibuha ngamia kubita mkizonzo cha shindano, kubanza mgoli kwingila Muundewa wa Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wanahina zake wakanganya ng'hani na kukiiuza wenyego kwa wenyego, “Munhu yalihi yondayadahe kukomboligwa?” ");
INSERT INTO zajp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu kawalola, kawalongela, “Mwa wanhu mbuli ino haidahika ila sio ha Mulungu, kwavija ha Mulungu vinhu vose vodahika.” ");
INSERT INTO zajp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Abaho, Petulo kalonga, “Lola, tweye tuleka vinhu vose na kukukweleleza gweye.” ");
INSERT INTO zajp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu kawalongela, “Nowalongela ikweli, munhu yoyose yalekile ng'anda ama ndugu zake ama lumbu zake ama mamaake ama tataake ama wanage ama migunda sama yangu nie na sama ya Usenga Unogile, ");
INSERT INTO zajp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kobokela mkipigiti kino mianza mia ya ng'anda, wandugu, walumbu, mama, wana, na migunda, na vivija mgayo, na mkipigiti kikwiza kobokela ugima wa digunge. ");
INSERT INTO zajp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ila wanhu bwando wali sambi haulongozi wowa kuchugu, na wanhu bwando wali sambi kuchugu wowa haulongozi.” ");
INSERT INTO zajp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu na wanahina zake wakala mnzila wokwela wochola Yelusalemu, Yesu kalongola haulongozi wao. Wanahina zake wakala wokanganya ng'hani, na wanhu wakalile womkweleleza hachugu wakala wodumba. Mwanza uyagwe viyawasolile wanahina zake kawagala hamgwazo na kuwalongela mbuli zondazimulawilile. ");
INSERT INTO zajp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kawalongela “Tegelezeni, tokwela tochola Yelusalemu ako nie, Mwana wa Munhu, kondanigeligwe mmakono ga wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa. Wonitagusa kudanganhika na kunigela mmakono ga wanhu hawali Wayahudi, ");
INSERT INTO zajp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","na hewo wonitendela mzihaka, wonitemela vizite, wonilanha mbalati na kunikoma, ila gahabita mazua madatu nozuka.” ");
INSERT INTO zajp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Abaho Yakobo na Yohana, wanage Zebedayo, wamcholela Yesu wamulongela, “Mkulufunzi, tolonda ututendele mbuli.” ");
INSERT INTO zajp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu kawauza, “Mbuli yaki?” ");
INSERT INTO zajp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wamwidika, “Tutogoze imwe yakale kumkono wako wa ukulume na iyagwe yakale kumkono wako wa ukumoso kuna iyenzi yako.” ");
INSERT INTO zajp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu kawalongela, “Hammanyile kinhu chumpula. Modaha kuking'wela kikasi cha mgayo kinilondigwa kung'wela nie? Ama modaha kubatizigwa kamba vinilondigwa kubatizigwa nie?” ");
INSERT INTO zajp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wamulongela, “Todaha.” Yesu kawalongela, “Moking'wela kikasi cha mgayo kinilondigwa kuking'wela nie na mobatizigwa kamba vinilondigwa kubatizigwa. ");
INSERT INTO zajp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ila kusagula yalihi yakale kumkono wangu wa ukulume ama kumkono wangu wa ukumoso haili sang'hano yangu. Mulungu iyo yondayawagwelele awo watandiligwe ukazi uno.” ");
INSERT INTO zajp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wanahina wayagwe longo dimwe viwahulike mbuli zija, wawonela lusango Yakobo na Yohana. ");
INSERT INTO zajp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Avo Yesu kawakema wose hamoja kawalongela, “M'vimanya waja wogesigwa kamba wandewa wa wanhu hawali Wayahudi wana udaho mwa wanhu zao, na wakulu zao wotenda vovose vowolonda. ");
INSERT INTO zajp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sambiiwe vino kumwenu. Kamba munhu imwe mdidale jenu yahalonda kuwa mkulu, kolondigwa yawe mtumigwa wa wayage, ");
INSERT INTO zajp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","na munhu imwe mdidale jenu yahalonda kuwa haulongozi, kolondigwa yawe nyakadala wa wose. ");
INSERT INTO zajp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kwavija hata nie, Mwana wa Munhu, sizile kusang'hanikiligwa, ila niza kusang'hanika na kulava ugima wangu giladi niwakombole wanhu bwando.” ");
INSERT INTO zajp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Wavika kudiwambo dikemigwa Yeliko, Yesu viyakalile yolawa mkiwambo na wanahina zake na dale kulu da wanhu, kimbugumbugu imwe yakalile yopula vinhu yokemigwa Batimayo mwanage Timayo kakala yakalile hasi behi na inzila. ");
INSERT INTO zajp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Viyahulike kamba Yesu wa Nazaleti kobita, kasonga kwinula dizwi yolonga, “Yesu! Mwana wa Daudi! Nyonela bazi!” ");
INSERT INTO zajp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wanhu bwando wamkomhokela na wamulongela yavudale. Ila kagendelela ng'hani kutoa nyangi, yolonga, “Mwana wa Daudi! Nyonela bazi!” ");
INSERT INTO zajp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu kema, kalonga, “Mkemeni.” Avo wamkema ija imunhu kimbugumbugu wamulongela, “Deng'helela! Inuka kokukema.” ");
INSERT INTO zajp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kajasa guo jake, kazumha kachola ha Yesu. ");
INSERT INTO zajp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu kamuuza, “Kolonda nikutendele choni?” Ija imunhu kamwidika, “Mkulufunzi, nolonda kulola.” ");
INSERT INTO zajp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu kamulongela, “Genda, nhamanila yako ikuhonya.” Bahaja kadaha kulola na kamkweleleza Yesu mnzila. ");
INSERT INTO zajp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Viwavikile behi na wambo da Yelusalemu, wavika Betifage hana Ikigongo cha Mizaituni, behi na ikiwambo cha Betania. Yesu kawatuma wanahina zake wabili walongole haulongozi. ");
INSERT INTO zajp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kawalongela, “Gendeni hana ikiwambo kili haulongozi wenu. Muhavika, mom'vika mwana mhunda yafungigwe hanapapa munhu yoyose. Mfunguleni munigalile. ");
INSERT INTO zajp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na kamba munhu yahawauza habali motenda avo, mulongeleni Mndewa komulonda, na sambi baha kom'bweza.” ");
INSERT INTO zajp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Avo wachola wam'vika mwana mhunda mulubuga, yafungigwe muna ulwivi lwa ng'anda imwe. Viwakalile womfungula, ");
INSERT INTO zajp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","wanhu wakalile wemile behi nawo wawauza, “Habali mumfungula imwana mhunda?” ");
INSERT INTO zajp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wawedika kamba Yesu viyawalongele, na hewo wawaleka wachole nayo. ");
INSERT INTO zajp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wamgala imwana mhunda ha Yesu, watandika vivalo vao mumgongo wake, na Yesu kakwela mumgongo wake. ");
INSERT INTO zajp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wanhu bwando wanzanza vivalo vao mnzila, wayagwe wakanha mitambi mmigunda waiyanzanza mnzila. ");
INSERT INTO zajp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wanhu walongole na wose wawawinzile kukisogo wasonga kwinula dizwi wolonga, “Yatogolwe Mulungu! Mulungu ummoteze ayo yokwiza mtwaga da Mndewa! ");
INSERT INTO zajp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mulungu uumoteze undewa ukwiza wa Mndewa Daudi, tata wetu! Yatogolwe Mulungu!” ");
INSERT INTO zajp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu kengila Yelusalemu, kachola na kwingila muna Ing'anda ya Mulungu, kalola kila hanhu. Ila kwavija zua dikala diswile, kachola Betania na wanahina zake longo dimwe na wabili. ");
INSERT INTO zajp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Imitondo iyagwe, viwakalile wosegela kulawa Betania, Yesu kakala na nzala. ");
INSERT INTO zajp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kawona hatalitali m'biki ukemigwa mtini utimile mitepo, avo kachola kuulola siku kovika tini. Ila viyaukwenhukile, kavika mitepo yeka, kwavija haukalile msimu wa tini. ");
INSERT INTO zajp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu kaulongela uja umtini, “Haduhu munhu yoyose yondayaje tini kulawa kumwako milongo yose!” Na wanahina zake wamuhulika. ");
INSERT INTO zajp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Viwavikile Yelusalemu, Yesu kachola Kung'anda ya Mulungu, kasonga kuwalava hanze wanhu wose wakalile wogula na kuguza. Kazihindula izimeza za wavunja hela na ivigoda va waguza njiwa, ");
INSERT INTO zajp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","na hamulekile munhu yoyose yapape kinhu chochose yakanhize muna idikonhi da Ng'anda ya Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Abaho, kawafundiza, “Yandikigwa Mzinyandiko Zing'alile, Mulungu kalonga, ‘Ng'anda yangu yokemigwa ng'anda ya nhambiko za isi zose.’ Ila mweye muigalula kuwa fiso da wabavi!” ");
INSERT INTO zajp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa wahulika, avo wasonga kuzahila nzila ya kumkoma Yesu. Ila wamdumba kwavija dale jose da wanhu dikala dokanganya mafundo gake. ");
INSERT INTO zajp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Viivikile ichungulo, Yesu na wanahina zake wasegela hakiwambo kija. ");
INSERT INTO zajp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Imitondo iyagwe, viwakalile wobita mnzila, wawona umtini unyala kusongela kunhembeti mbaka mmizizi. ");
INSERT INTO zajp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petulo kakumbukila mbuli zija Yesu zayaulongele umtini, kamulongela Yesu, “Lola, mkulufunzi, uja umtini uwikile kinyulu uholola!” ");
INSERT INTO zajp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu kawedika, “Mtamanileni Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nowalongela ikweli, munhu yoyose yahakilongela kigongo kino, ‘Goboka ukalagalile m'bahali,’ bila kudungwadungwa mmoyo wake ila kotamanila gaja gayalongile, kotendeligwa. ");
INSERT INTO zajp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Avo nowalongela, avija vumtambika na kupula kinhu kulawa ha Mulungu, tamanileni kamba m'bokela, na mogweleligwa kinhu chochose chumpula. ");
INSERT INTO zajp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na muhawa muna inhambiko, geleni kumgongo kinhu chochose chumuihasanye na munhu yoyose, avo Tata wenu wa kuulanga kovigela kumgongo vilozo venu vumtendile.” ");
INSERT INTO zajp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Avo kamba hamuwagela waenu kumgongo, na Tata wenu havigela kumgongo vilozo venu vimtendile. ");
INSERT INTO zajp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wavika Yelusalemu mwanza uyagwe. Yesu viyakalile yotembela kuna Ing'anda ya Mulungu, wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa na iwakulu wamcholela, ");
INSERT INTO zajp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","wamuuza, “Kotenda mbuli zino na udaho ulihi? Yalihi yakugwelela udaho wa kutenda mbuli zino?” ");
INSERT INTO zajp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu kawedika kawalongela, “Nowauza mbuli imwe na muhanidika, nowalongela notenda mbuli zino na udaho ulihi. ");
INSERT INTO zajp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nilongeleni, Yohana kapata kwahi udaho wa kubatiza, kapata kulawa ha Mulungu ama ulawa ha wanhu?” ");
INSERT INTO zajp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wasonga kuibamilila wenyego kwa wenyego, “Tulongeze? Tuhalonga, ‘Ulawa ha Mulungu,’ kolonga, ‘Habali hamumtegeleze Yohana?’ ");
INSERT INTO zajp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ila sambitulonge, ‘Ulawa ha wanhu.’ ” Wawadumba wanhu, kwavija wanhu wose watogola kamba Yohana kakala muhokozi. ");
INSERT INTO zajp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Avo wamulongela Yesu, “Hatuvimanyile.” Yesu kawalongela, “Na nie siwalongela kamba notenda mbuli zino na udaho ulihi.” ");
INSERT INTO zajp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Abaho, Yesu kalonga nao mmahala, “Munhu imwe kakala na mgunda wa mizabibu, kauzengela konhi na kuhimba lwingila lwa kukamulila zabibu na kuzenga ulingo. Abaho, kawapangiza walimi, kachola isi ya kutali. ");
INSERT INTO zajp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kipigiti cha kuhuna zizabibu vikivikile, kamtuma nyakadala wake ha iwalimi yakamsolele fungu jake da izizabibu. ");
INSERT INTO zajp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Iwalimi wamnwang'hula ija inyakadala, wamtoa, na wam'bweza bila kinhu. ");
INSERT INTO zajp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Abaho, mwene mgunda kamulongela nyakadala iyagwe yachole ha iwalimi yakamsolele zabibu zake, waja iwalimi wamtoa mdipala na kumtendela mbuli za kumgela kinyala. ");
INSERT INTO zajp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mwene mgunda kamulagiza nyakadala iyagwe, na heyo wamkoma. Na kawalagiza nyakadala wayagwe bwando, wayagwe wawatoa na wayagwe wawakoma. ");
INSERT INTO zajp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Munhu yasigale wa kumulagiza kakala mwanage mnogelwa ng'hani wa mwene mgunda. Avo hakimambukizo, kamulagiza mwanage ha iwalimi, kalonga, ‘Kwa vovose ino womuhishimila, kwavija mwanangu.’ ");
INSERT INTO zajp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ila waja iwalimi wakiilongela, ‘Ino iyo mwana wa mwene mgunda. Haya izoni tumkome, na uhazi wake wowa wetu!’ ");
INSERT INTO zajp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Avo wamnwang'hula imwana wa mwene umgunda wamkoma na kumwasa hanze ya umgunda wa imizabibu.” ");
INSERT INTO zajp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu kauza, “Abaho, kotenda choni ija imunhu yali na umgunda? Kokwiza na kowakoma iwalimi waja na kuwagwelela walimi wayagwe. ");
INSERT INTO zajp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Hamzisomile Nyandiko zino Zing'alile? ‘Dibwe dilemigwe na wazenzi digaluka kuwa dibwe da kutamanilwa ng'hani kubanza mabwe gose. ");
INSERT INTO zajp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mndewa iyo yatendile mbuli ino, nayo iwa mkanganyo mmeso getu!’ ” ");
INSERT INTO zajp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Wakulu wa Wayahudi wageza kumgoga Yesu, kwavija wavitanga kamba kalonga hala dino yowalonga hewo. Ila wakala wowadumba wanhu, avo wamuleka wachola na zao. ");
INSERT INTO zajp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mafalisayo na wanhu wa Helode walagizwa na wakulu wa Wayahudi ha Yesu wamwikile vitega mkumuuza. ");
INSERT INTO zajp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wamcholela wamulongela, “Mkulufunzi, tuvitanga kamba gweye kolonga mbuli zili kweli, bila kudumba ngelegeza za wanhu. Humdumba munhu yoyose, ila kofundiza ikweli ya Mulungu mwa wanhu. Tulongele, totenda galemigwe na Malagizo getu vituliha kodi ha Kaisali?” ");
INSERT INTO zajp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ila Yesu kavitanga vitega vao kawalongela, “Habali mgeza kunikila vitega? Nigalileni ihela niilole.” ");
INSERT INTO zajp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wamgalila hela imwe, kawauza, “Kihanga na ditwaga dino va munhu yalihi?” Wamwidika, “Va Kaisali.” ");
INSERT INTO zajp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Avo Yesu kawalongela, “Mulonga goya, avo ga Kaisali mgweleleni Kaisali, na ga Mulungu mgweleleni Mulungu.” Na hewo wakanganya ng'hani vija viyawedike. ");
INSERT INTO zajp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Abaho, Masadukayo, awo wolonga kamba wanhu hawazuka kulawa mkudanganhika, wamcholela Yesu wamuuza, ");
INSERT INTO zajp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mkulufunzi, Musa katwandikila, ‘Ihawa munhu kadanganhika na kuleka mtwanzi halelile nayo mwana, mkulu wake ama mdodo wake ija yadanganhike kolondigwa yamsole ija ikizuka, yamulelele wana indugu yake yadanganhike.’ ");
INSERT INTO zajp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Avo kukala na wanhu saba wambigalo wa mulango umwe, mkulu wao kasola mtwanzi, kadanganhika bila kulela nayo wana. ");
INSERT INTO zajp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Abaho, waikabili kamsola ija imtwanzi, vivija kadanganhika bila kulela nayo wana. Na waikadatu gam'vika gagaja, ");
INSERT INTO zajp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","na wasigale wose saba, wanhu wose saba wamsola mtwanzi ija na wadanganhika bila kulela nayo wana. Hakimambukizo, ija imtwanzi na heyo kadanganhika. ");
INSERT INTO zajp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Avo wanhu wose wadanganhike wahazuka wawe wagima muna idizua da kuzuka kwa wanhu wose, mtwanzi ija kowa mtwanzi wa munhu yalihi? Kwavija wanhu wose saba wakala wamsolile.” ");
INSERT INTO zajp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu kawedika, “Muhonyela ng'hani! Kwavija hamzimanyile Nyandiko Zing'alile ama mhiko za Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wanhu wadanganhike wahazuka hawasola ama kusoligwa, wowa kamba wasenga wa Mulungu wa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Avo tuilole mbuli ya kuzuka kwa wanhu wadanganhike, hamsomile mkitabu cha Musa hanhu handikigwe kitutua kikwaka? Mulungu kalongaze? Kalonga, ‘Nie iyo Mulungu wa Ablaham, na Isaka, na Yakobo.’ ");
INSERT INTO zajp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Heyo si Mulungu wa wanhu wadanganhike ila Mulungu wa wanhu wagima. Mweye muhonyela ng'hani!” ");
INSERT INTO zajp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mfundiza Malagizo ga Musa yakalile haja, kahulika viwakalile wokiibamilila. Kona kamba Yesu kamsambulila vinogile, avo kamcholela na mbuza, kamuuza, “Ndagizi ilihi ili ng'hulu kubanza zose?” ");
INSERT INTO zajp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu kamwidika, “Ndagizi ili ng'hulu kubanza zose iyo ino. ‘Tegeleza Islaeli! Mndewa Mulungu wetu iyo Mndewa yeiyeka. ");
INSERT INTO zajp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mnogele Mndewa Mulungu wako na moyo wako wose, na loho yako yose, na nzonzi zako zose, na mhiko zako zose.’ ");
INSERT INTO zajp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ndagizi ya ikabili iyo ino, ‘Mnogele munhu wa habehi nagwe kamba vukiinogela mwenyego.’ Haduhu ndagizi ziyagwe zili ng'hulu kubanza zino mbili.” ");
INSERT INTO zajp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ija mfundiza Malagizo ga Musa kamulongela Yesu, “Mkulufunzi, kulonga goya! Kulonga ili kweli, vuulongile kamba Mndewa yeiyeka iyo Mulungu na haduhu mulungu iyagwe ila heyo. ");
INSERT INTO zajp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kumnogela Mulungu na moyo wako wose, na nzonzi zako zose, na mhiko zako zose, na mnogele munhu wa habehi nagwe kamba vukiinogela mwenyego, vinoga ng'hani kubanza kumulavila Mulungu nhosa zose za kulukuza na zija zili si za kulukuza.” ");
INSERT INTO zajp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu viyonile ija imunhu kalonga galawile mmoyo, kamulongela, “Huli kutali na Undewa wa Mulungu.” Kulawila haja haduhu munhu yamuuzile Yesu mbuli yoyose. ");
INSERT INTO zajp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu viyakalile yofundiza Kuing'anda ya Mulungu, kawauza, “Habali wafundiza Malagizo ga Musa wolonga kamba Kilisto iyo mwana wa Daudi? ");
INSERT INTO zajp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi mwenyego kalongozigwa na Loho wa Mulungu, kalonga, ‘Mndewa kamulongela Mndewa wangu. Kala kumkono wangu wa ukulume mbaka vondaniweke wadumuka zako hasi ya magulu gako.’ ");
INSERT INTO zajp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Daudi mwenyego komkema Kilisto ‘Mndewa.’ Avo kodahaze Kilisto kulawa mulukolo lwake?” Dale kulu da wanhu dikala dimtegeleza Yesu mkudeng'ha. ");
INSERT INTO zajp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Viyakalile yofundiza kalonga, “Iteganyeni na wafundiza Malagizo ga Musa. Wonogelwa kuzungulukazunguluka kuno wavalile mikanzu mitali na wonogelwa kulamsigwa na hishima mmasoko, ");
INSERT INTO zajp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","na kusagula vigoda va haulongozi mzing'anda za nhambiko na hanhu hanogile kuna izisona. ");
INSERT INTO zajp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wowabulunya vizuka na kutenda nhambiko nhali za uzenzeleganye hameso ga wanhu. Nhaguso yao yowa ng'hulu ng'hani!” ");
INSERT INTO zajp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu kakala habehi na ikia cha kulavila nhosa, kakala yowalola wanhu volava hela zao muna ikia cha kulavila nhosa. Wanhu wagoli walava hela bwando, ");
INSERT INTO zajp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","abaho, keza kizuka mkumbulu kalava hela mbili ndodo ng'hani. ");
INSERT INTO zajp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu kawakema wanahina zake hamoja kawalongela, “Nowalongela ikweli, kizuka ino mkumbulu kalava hela bwando kubanza wanhu wose. ");
INSERT INTO zajp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kwavija wayagwe walava vinhu viwabanzile, ila kizuka ino hamoja na ukumbulu wake, kalava vose vayalinavo.” ");
INSERT INTO zajp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu viyakalile yolawa Kuing'anda ya Mulungu, mwanahina wake imwe kamulongela, “Mkulufunzi! Lola mabwe gaja vigali makulu na zing'anda vuzinogile ng'hani!” ");
INSERT INTO zajp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu kamulongela, “Kuzona ng'anda zino ng'hulu? Haduhu dibwe hano dondadisigale hadili, gose gobomoligwa na kwasigwa hasi.” ");
INSERT INTO zajp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu kakala yakalile Hakigongo cha Mizaituni, kikalile kigongo kwa kigongo na Ing'anda ya Mulungu. Petulo, Yakobo, Yohana, na Endelea wamuuza kinyele, ");
INSERT INTO zajp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tulongele, mbuli zino zolawila zua jaki? Na tulongele, choni chondakilawile kutulagusila kamba kipigiti kivika cha mbuli zino zose kulawilila?” ");
INSERT INTO zajp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu kawalongela, “Teganyeni, munhu yoyose sambiyawavwizile. ");
INSERT INTO zajp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wanhu bwando wokwiza mtwaga jangu, wolonga ‘Nie iyo Kilisto!’ na kuwavwizila wanhu bwando. ");
INSERT INTO zajp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Muhahulika ng'hondo na singilimo za ng'hondo, sambimdumbe. Vinhu kamba avo volondigwa vilawile, ila ikimambukizo hakinavika. ");
INSERT INTO zajp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Isi yogomba na isi iyagwe, na undewa wogomba na undewa uyagwe, kowa na mgudemo wa isi hanhu na hanhu na nzala. Gano gose gowa kamba usungu wa mwanduso wa kulela mwana. ");
INSERT INTO zajp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Teganyeni, kwavija mogogigwa na kugaligwa m'vitala, molanhigwa mzing'anda za nhambiko. Mogaligwa haulongozi wa iwakulu wa isi na wandewa sama yangu kamba usindila kumwao. ");
INSERT INTO zajp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na Usenga Unogile wolondigwa tanhu upetigwe muisi zose kipigiti king'hali ikimambukizo hakinavika. ");
INSERT INTO zajp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Muhagogigwa na kugaligwa m'vitala, sambimgelegeze kija chondamulonge. Kipigiti kihavika, longeni gogose gondamgweleligwe. Kwavija mbuli zondamulonge haziwa zenu mweye, ila zolawa ha Loho wa Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ndugu komuhonza ndugu yake giladi yakomigwe, na tata komuhonza mwanage. Wana wowahonza watata na wamama zao na kuwatenda wadanganhike. ");
INSERT INTO zajp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Wanhu wose wowehila mweye sama yangu, ila yondayananahile mbaka hakimambukizo kokomboligwa. ");
INSERT INTO zajp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kipigiti chokwiza vondamone ‘Kinhu Kinyolodoke Kigala Ubananzi’ kima hanhu hakilondigwe kukala.” Munhu yosoma na yaitange nhegulo yake! Yesu kagendelela kulonga, “Avo, awo wali Yudea wakimbilile m'vigongo. ");
INSERT INTO zajp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Munhu yali mkiswili cha ng'anda yake sambiyahumuluke hasi ama yengile mng'anda yakasole kinhu chochose. ");
INSERT INTO zajp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yali kumgunda sambiyabwele ukae kusola kivalo chake. ");
INSERT INTO zajp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wogaya ng'hani watwanzi wali na inda na wokong'heza mmazua higo! ");
INSERT INTO zajp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tambikeni giladi Mulungu yazitende mbuli zino sambizilawile mkipigiti cha kihuhe! ");
INSERT INTO zajp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kwavija mgayo wa mazua higo wowa mkulu kubanza mgayo wowose woneke songela haichanduso Mulungu vayalumbile iisi mbaka vino. Na haulawila mgayo kamba hiwo milongo yose ikwiza. ");
INSERT INTO zajp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kamba Mndewa yahalekile kugahunguza mazua higo, haduhu munhu yahahonile. Ila sama ya awo wamnogele Mulungu, awo yaawasagule, kagahunguza mazua higo. ");
INSERT INTO zajp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Abaho, kamba munhu yoyose yahawalongela, ‘Lola, Kilisto kahano!’ ama ‘Kakuja!’ sambimumtegeleze. ");
INSERT INTO zajp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kwavija wolawila makilisto wa uvwizi na wahokozi wa uvwizi. Wotenda vilaguso na mikanganyo giladi vihadahika wawakonge hata wanhu wasaguligwe na Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Teganyeni! Niwalongela mbuli zose kipigiti king'hali hakinavika. ");
INSERT INTO zajp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Avo muna gamazua higo kipigiti cha mgayo vondakimale, zua doziziwala, mulenge haulava mulangaza wake, ");
INSERT INTO zajp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","nhondo zolagala kulawa kuulanga, na mhiko za kuulanga zokwekwesigwa kulawa hazikalile. ");
INSERT INTO zajp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Abaho, wonyona nie, Mwana wa Munhu, nikwiza na mawingu na mhiko na yenzi ng'hulu. ");
INSERT INTO zajp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Abaho, nowatuma wasenga wa Mulungu wa kuulanga kuna zing'ambu nne za ulumwengu wawaduganye wanhu wasaguligwe na Mulungu kulawa ng'ambu imwe ya ulumwengu mbaka ng'ambu iyagwe ya ulumwengu. ");
INSERT INTO zajp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Muifundize mum'biki wa mtini. Matambi gake gahasonga udeke wa kuzuka na kulava matepo, movitanga kamba vuli da mmabehi. ");
INSERT INTO zajp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Vivija na mweye, muhazona mbuli zino zolawila, m'vitange kamba mbuli zino za mmabehi kusonga. ");
INSERT INTO zajp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nowalongela ikweli, mbuli zino zose zolawilila ing'hali wanhu wa mulelo uno hawanadanganhika. ");
INSERT INTO zajp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ulanga na isi vose vobita, ila mbuli zangu hazibita. ");
INSERT INTO zajp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kwa vovose haduhu munhu yoitanga saa ama zua dilihi mbuli zino vondazilawile, sio wasenga wa Mulungu wa kuulanga ama nie, Mwana, ila Tata yeiyeka iyo yoitanga. ");
INSERT INTO zajp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Goneleleni na teganyeni, kwavija ham'vitanga kipigiti kilihi mbuli zino vondazilawile. ");
INSERT INTO zajp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Volinga kamba munhu yawagwelele nyakadala zake kila munhu na sang'hano yake ya kutenda na kumulongela mwimiliza ulwivi yagonelele, abaho, kachola mwanza na kuwaleka nyakadala zake wosang'hanika. ");
INSERT INTO zajp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Avo goneleleni kwavija hamkimanyile kipigiti mwene ng'anda vondayeze, siku ichungulo ama ikilo kikulu ama nzogolo zikwika ama imitondo. ");
INSERT INTO zajp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ihawa yeheza mkuwasinhukiza, sambiyawavike muwasile. ");
INSERT INTO zajp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Avo kinilonda kuwagong'ondeza, nowalongela wose kamba, goneleleni!” ");
INSERT INTO zajp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gakala gasigale mazua mabili kuvikila Pasaka na Lusona lwa Imikate Ilibule Mela. Wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa wakala wozahila nzila ya kumgoga Yesu kinyele wamkome. ");
INSERT INTO zajp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Walonga, “Sambitutende gano mkipigiti cha ulusona, ama wanhu wosongeza mzahimzahi.” ");
INSERT INTO zajp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu viyakalile Betania, yoja hameza mng'anda ya munhu imwe yokemigwa Simoni yakalile na utamu wa dikulu, mtwanzi imwe keza na nyhupa ya alabasta ili na mavuta ga kunung'hila ga hela bwando, gatendigwe na nado inogile. Kaifungula inyhupa na kumwitila Yesu gamavuta mmwiti. ");
INSERT INTO zajp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wanhu wayagwe wakalile haja wehilwa, wailongela, “Habali mavuta gano ga kunung'hila gobanangwa kamba vino? ");
INSERT INTO zajp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Gahaguzigwe zihapatikane hela zidaha kuliha kitumetume cha mulao umwe, na zihela wahagweleligwe wakumbulu!” Wamkomhokela ng'hani mtwanzi ija. ");
INSERT INTO zajp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ila Yesu kawalongela, “Mulekeni, habali mumgaza? Kanhendela kinhu kinogile ng'hani. ");
INSERT INTO zajp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wakumbulu mokala nao mazua gose, na muhalonda kuwagwelela vinhu kipigiti chochose mowagwelela. Ila nie sikala na mweye mazua gose. ");
INSERT INTO zajp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Katenda chayadahile, kalubaka mavuta lukuli lwangu kulutanda na mazisi mazua ga hamwande. ");
INSERT INTO zajp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nowalongela ikweli, kila hanhu hondaupetigwe Usenga Unogile muulumwengu wose, kino chayatendile mtwanzi ino cholongwa mkumkumbukila heyo.” ");
INSERT INTO zajp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Abaho, Yuda Isikalioti, imwe wa wanahina longo dimwe na wabili, kachola ha wakulu wa wakulu wa nhambiko giladi yamuhonze Yesu kumwao. ");
INSERT INTO zajp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wadeng'helela ng'hani viwahulike gaja gayalongile, wailagana kumgwelela hela. Avo kasonga kuzahila nzila ya kumgela mmakono gao. ");
INSERT INTO zajp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Muna dizua da mwanduso wa Ulusona lwa Imikate Ilibule Mela, idizua ajo wana ng'hondolo wa Pasaka vowochinjigwa, wanahina zake wamuuza, “Kwahi kuulonda tuchole tukakutandile mandia ga Pasaka?” ");
INSERT INTO zajp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesu kawalagiza wanahina zake wabili kawalongela, “Gendeni mkiwambo, mom'vika mbigalo yapapile nongo ya mazi. Mkwelelezeni ");
INSERT INTO zajp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mbaka hana ing'anda yondayengile, mulongeleni mwene ng'anda, ‘Mkulufunzi kouza, Dakwahi digati da wahenza kondanidile mandia ga Pasaka na wanahina zangu?’ ");
INSERT INTO zajp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kowalagusila gati kulu da uchana, difagiligwe na kuhambigwa. Tutandileni mandia himo.” ");
INSERT INTO zajp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wanahina walawa, wachola hakiwambo, wavika kila kinhu kamba viyawalongele. Avo wagatanda gamandia ga Pasaka. ");
INSERT INTO zajp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Viivikile ichungulo, Yesu keza na wanahina zake longo dimwe na wabili. ");
INSERT INTO zajp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Viwakalile hameza woja, Yesu kalonga, “Nowalongela ikweli, munhu imwe mmwanza wenu yoja hamoja na nie, konihonza.” ");
INSERT INTO zajp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wanahina wona giogio, na wasonga kumuuza imweimwe, “Nie, Mndewa?” ");
INSERT INTO zajp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kawalongela, “Imwe mmwanza wenu mweye longo dimwe na wabili yozanhika mkate mkia hamoja na nie. ");
INSERT INTO zajp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nie, Mwana wa Munhu, nodanganhika kamba Nyandiko Zing'alile vuzimulonga, ila kogaya ng'hani munhu ija yondayanihonze nie, Mwana wa Munhu! Vihanogile munhu ija sambiyaleligwe!” ");
INSERT INTO zajp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Viwakalile woja, Yesu kasola mkate, kalonga hewela ha Mulungu, kaumogola kawagwelela wanahina zake, kawalongela, “Usoleni, uno uwo lukuli lwangu.” ");
INSERT INTO zajp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Abaho, kasola kikasi, kalonga hewela ha Mulungu, abaho, kawagwelela wanahina zake, na wose wang'wa. ");
INSERT INTO zajp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kawalongela, “Uno uwo mulopa wangu wa lagano witika sama ya wanhu bwando. ");
INSERT INTO zajp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nowalongela ikweli, sing'wa kabili mulelo uno wa zabibu mbaka zua dija vondaniung'we wa sambi muna Undewa wa Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Viwamambukize kwimba wila, wachola kuna Ikigongo cha Mizaituni. ");
INSERT INTO zajp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu kawalongela wanahina zake, “Mweye mose, mong'himbila na kundeka, kamba Zinyandiko Zing'alile vuzilonga, ‘Nomtoa imchunga, na iwang'hondolo wopwililika.’ ");
INSERT INTO zajp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ila nihazuka kulawa mkudanganhika, nowalongola nochola Galilaya.” ");
INSERT INTO zajp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petulo kamulongela, “Kamba wose wahakuleka ila nie sikuleka!” ");
INSERT INTO zajp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu kamulongela, “Nokulongela ikweli, ikilo ya lelo, nzogolo hanakwika mianza mibili, konibela mianza midatu.” ");
INSERT INTO zajp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ila Petulo kagangamiza yolonga, “Hata kamba nihadanganhika hamoja na gweye, nidanganhike, ila nie sidaha kukubela gweye!” Na wanahina wose wasigale walonga vivo. ");
INSERT INTO zajp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wavika hanhu hakemigwe Getisemane, Yesu kalonga na wanahina zake, “Kaleni hano, nitambike.” ");
INSERT INTO zajp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kawasola Petulo, Yakobo, na Yohana na heyo mwenyego. Kasonga kudungwadungwa na kugaya mmoyo, ");
INSERT INTO zajp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","kawalongela, “Moyo wangu una giogio ng'hani behi na kudanganhika, kaleni hano mgonelele.” ");
INSERT INTO zajp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kachola hamwande kidogo, kafugama mavindi, katambika kalonga, vihadahika sambiyabitile muna ikipigiti cha mgayo. ");
INSERT INTO zajp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Katambika yolonga, “Tataangu! Gose godahika kumwako. Nisegezele kikasi kino cha mgayo. Ila sio kamba vinilonda nie, ila kamba vuulonda gweye.” ");
INSERT INTO zajp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Abaho, kabwela ha wanahina zake kawavika wawasile. Kamulongela Petulo, “Simoni, kuwasa? Hudahile kugonelela hata saa dimwe?” ");
INSERT INTO zajp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kawalongela, “Goneleleni, na mtambike giladi sambimwingile mkugezigwa. Kwavija loho yolonda, ila lukuli lutepweta.” ");
INSERT INTO zajp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kachola mwanza uyagwe, katambika yolonga mbuli zizija. ");
INSERT INTO zajp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Viyabwelile kawavika wawasile kabili, kwavija meso gao gakala gamemile utulo. Wakala wabule da kumulongela. ");
INSERT INTO zajp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Viyawabwelele mwanza wa ikadatu, kawalongela, “Mng'hali wasa na kuhumula? Yotosha! Kwavija kipigiti kivika! Lola, nie, Mwana wa Munhu, nohonzigwa, mkugeligwa mmakono ga wanhu wali na vilozo. ");
INSERT INTO zajp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Lamukeni tuchole. Lola, munhu yonihonza ka mmabehi!” ");
INSERT INTO zajp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu viyakalile yogendelela kulonga, Yuda, imwe wa waja wanahina longo dimwe na wabili, kavika. Keza na dale da wanhu wapapile mizele na mimbwego, wakala watumigwe na wakulu wa wakulu wa nhambiko, wafundiza Malagizo ga Musa, na wakulu. ");
INSERT INTO zajp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ija imunhu yamuhonzile kakala yawagwelele kilaguso kawalongela, “Munhu yondanimnonele iyo immulonda. Mgogeni mumsole mchole nayo kuno mmwimiliza ng'hani.” ");
INSERT INTO zajp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda viyavikile, hima kachola ha Yesu na kulonga, “Mkulufunzi!” Abaho, kamnonela. ");
INSERT INTO zajp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Avo wagolosa makono gao na kumgoga. ");
INSERT INTO zajp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ila munhu imwe yakalile yemile hamoja na Yesu, kasomola zele jake na kumuyenza nyakadala wa Mkulu wa Wakulu wose wa Nhambiko na kumkanha gwiti jake. ");
INSERT INTO zajp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu kawauza, “Mwiza na mizele na mimbwego kunigoga nie kamba vija nie na m'bavi? ");
INSERT INTO zajp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mazua gose nikala hamoja na mweye nifundiza kuna Ing'anda ya Mulungu, hamunigogile. Ila Nyandiko Zing'alile zolondigwa zivikile kamba vuzandikigwe.” ");
INSERT INTO zajp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Abaho, wanahina zake wose wamuleka, wakimbila. ");
INSERT INTO zajp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mmhale imwe yakalile yavalile guo da kuigubika kakala yomkweleleza Yesu. Wageza kumgoga, ");
INSERT INTO zajp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ila kadileka idiguo da kuigubika kuchugu na kukimbila mwazi. ");
INSERT INTO zajp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Abaho, wamsola Yesu na kumgala ha Mkulu wa Wakulu wose wa Nhambiko, na wakulu wa wakulu wa nhambiko, na iwakulu na wafundiza Malagizo ga Musa, wose waiting'hanila. ");
INSERT INTO zajp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petulo kamkoleleza Yesu kutalitali mbaka kengila mdikonhi da ing'anda ya Mkulu wa Wakulu wose wa Nhambiko. Kakala hasi hamoja na wemilizi, yokota moto. ");
INSERT INTO zajp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wakulu wa wakulu wa nhambiko na Ikitala chose Kikulu cha Isi ya Wayahudi wageza kuzahila mbuli ya kumgela m'vilozo Yesu giladi wamkome, ila hawapatile. ");
INSERT INTO zajp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wanhu bwando walava usindila wa uvwizi, ila usindila wao hauiduganye. ");
INSERT INTO zajp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Abaho, wanhu wenuka na kumulonga Yesu mbuli za uvwizi, walonga, ");
INSERT INTO zajp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tumuhulika yolonga, ‘Noibomola Ng'anda ino ya Mulungu izengigwe na wanhu. Na gahabita mazua madatu noizenga iyagwe ayo haizengigwe na wanhu.’ ” ");
INSERT INTO zajp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Vivija usindila wao hauiduganye. ");
INSERT INTO zajp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Abaho, Mkulu wa Wakulu wose wa Nhambiko kenuka haulongozi wao wose kamuuza Yesu, “Kwabule cha kwidika mnhaguso zino zose zowokutagusa?” ");
INSERT INTO zajp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ila Yesu kanyamala na halongile chochose. Mkulu wa Wakulu wose wa Nhambiko kamuuza Yesu mwanza uyagwe, “Gweye iyo Kilisto, Mwana wa Mulungu Mwene Yenzi?” ");
INSERT INTO zajp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu kalonga, “Iyo nene. Na monyona nie, Mwana wa Munhu, nikalile ng'ambu ya ukulume ya Ukulu, nikwiza na mawingu ga kuulanga!” ");
INSERT INTO zajp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mkulu wa Wakulu wose wa Nhambiko kasinhuka, kadega guo jake, kalonga, “Hatulonda wasindila wayagwe! ");
INSERT INTO zajp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Muuhulika ufukuzi wake! Mweye molongaze?” Wose walamula walonga, “Kaloza, kolondigwa yakomigwe.” ");
INSERT INTO zajp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Wanhu wayagwe wasonga kumtemela mate, wamgubika ikihanga, abaho, wamtoa, walonga, “Zuza, yalihi yakutoile!” Na wemilizi wamsola wamtoa makofi. ");
INSERT INTO zajp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petulo viyakalile yakalile hasi mdikonhi, mtwanzi imwe mtumigwa wa Mkulu wa Wakulu wose wa Nhambiko keza behi nayo. ");
INSERT INTO zajp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Viyamuwene Petulo yokota moto, kamulola ng'hani, abaho, kamulongela, “Gweye nagwe kukala hamoja na Yesu wa Nazaleti?” ");
INSERT INTO zajp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ila Petulo kabela, kamulongela, “Sikimanya, ama sikitanga chuulonga.” Abaho, kalawa kunze mkubitila mulwivi lwa haulongozi, kipigiti kikija nzogolo keka. ");
INSERT INTO zajp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ija imtumigwa wa kitwanzi kamona Petulo mwanza uyagwe, kasonga kubwelela kulonga mbuli iija ha wanhu wemile behi nayo, “Ino ka mmwanza wao!” ");
INSERT INTO zajp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ila Petulo kabela mwanza uyagwe. Kipigiti kidodo hamwande, wanhu wakalile wemile behi wamulongela Petulo mwanza uyagwe, “Sambiubele, gweye kwa mmwanza wao, kwavija na gweye kwa Mgalilaya.” ");
INSERT INTO zajp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kasonga kudukumiza na kuiduila, “Simtangile munhu ino yummulonga mbuli zake!” ");
INSERT INTO zajp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Abaho, bahaja nzogolo keka mwanza uyagwe, abaho, Petulo kakumbukila avija vayamulongele Yesu, “Nzogolo hanakwika mianza mibili, konibela mianza midatu.” Kabemendeka kakala hasi kasonga kulila. ");
INSERT INTO zajp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ulukwili, wakulu wa wakulu wa nhambiko waiting'hana hima na iwakulu, wafundiza Malagizo ga Musa, na Ikitala chose Kikulu cha Isi ya Wayahudi, na kugelegeza vondawatende. Wamdaza Yesu minyolo, wamgala na kumgwelela Pilato. ");
INSERT INTO zajp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato kamuuza, “Gweye iyo Mndewa wa Wayahudi?” Yesu kamwidika, “Gweye iyo ulonga avo.” ");
INSERT INTO zajp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wakulu wa wakulu wa nhambiko wamtagusa Yesu vinhu bwando, ");
INSERT INTO zajp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","avo, Pilato kamuuza mwanza uyagwe, “Hulonda kwidika? Tegeleza mbuli zao zose zowokutagusa!” ");
INSERT INTO zajp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mwanza uyagwe Yesu halongile mbuli, na Pilato kakanganya. ");
INSERT INTO zajp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kila Lusona lwa Pasaka Pilato kakala yazoele kumfungulila mfungigwa imwe, ija wanhu iwamulondile. ");
INSERT INTO zajp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kipigiti kija munhu yakemigwe Balaba kakala mkifungo sama ya kuwadulukila wanhu wa silikali, na kukoma mkipigiti cha umzahimzahi wa kuilema silikali. ");
INSERT INTO zajp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dale da wanhu dimwizila Pilato, wasonga kumuuza yawatendele kamba viyawatendelaga. ");
INSERT INTO zajp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kawauza, “Molonda niwalekesele Mndewa wa Wayahudi?” ");
INSERT INTO zajp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kwavija heyo kavitanga kamba, wakulu wa wakulu wa nhambiko wakala wamgalile Yesu kumwake sama ya migongo. ");
INSERT INTO zajp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ila wakulu wa wakulu wa nhambiko wawaswagiza didale da wanhu dimulongele Pilato yawafungulile Balaba. ");
INSERT INTO zajp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato kalonga mwanza uyagwe, “Molonda nimtende choni munhu ino imumkema Mndewa wa Wayahudi?” ");
INSERT INTO zajp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Watoa nyangi walonga, “Muwambe mumsalaba!” ");
INSERT INTO zajp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato kauza, “Ila choni chayatendile munhu ino?” Wose wongeza kutoa nyangi, “Muwambe mumsalaba!” ");
INSERT INTO zajp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato kalonda yawanogeze ididale da wanhu, avo, kawalekesela Balaba. Abaho, kalagiza Yesu yalanhigwe abaho kamgela mmakono ga asikali wakamuwambe mumsalaba. ");
INSERT INTO zajp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Asikali wamsola Yesu wamwingiza mdikonhi da iding'anda da kindewa na kuwakema hamoja asikali wasigale. ");
INSERT INTO zajp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wam'vaza Yesu guo da zambalau, waluka mkungo wa mizomola, wam'vaza mditwi jake. ");
INSERT INTO zajp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Abaho, wasonga kumulamsa mumzihaka, “Kwa mpile, Mndewa wa Wayahudi!” ");
INSERT INTO zajp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wamtoatoa na ludete mditwi, wamtemela mate, wamfugamila mavindi na kumwinamila. ");
INSERT INTO zajp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Viwamambukize kumtendela uponela, wam'vula idiguo da zambalau, abaho, wam'vaza vivalo vake. Abaho, wamulava hanze ya idiwambo wakamuwambe mumsalaba. ");
INSERT INTO zajp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Munhu imwe kulawa isi ya Kilene yokemigwa Simoni, tata wa Alekizanda na Lufo, kakala yokwingila mdiwambo kulawa kumigunda, asikali wamshulutiza yaupape msalaba wa Yesu. ");
INSERT INTO zajp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wamsola Yesu wamgala hanhu hakemigwe Goligota, nhegulo yake, “Hanhu ha Fulu da Pala.” ");
INSERT INTO zajp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wageza kumgwelela divai igeligwe manemane, ila Yesu haing'wile. ");
INSERT INTO zajp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Abaho, wamuwamba mumsalaba na kuigolela vivalo vake wenyego kwa wenyego, watoa kula walamule yalihi yapate kivalo kilihi. ");
INSERT INTO zajp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ikala saa ndatu ya imitondo viwamuwambile mumsalaba. ");
INSERT INTO zajp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lupwilili lwa nhaguso yake lwandikigwa vino, “mndewa wa wayahudi.” ");
INSERT INTO zajp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na vivija wabavi wabili wawawamba mumsalaba hamoja na Yesu, imwe ng'ambu yake ya ukulume na iyagwe ng'ambu yake ya ukumoso. ");
INSERT INTO zajp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na Nyandiko Zing'alile zolonga, “Kapetigwa hamoja na watenda gehile,” zivikila. ");
INSERT INTO zajp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wanhu wabitile behi na haja wamwasila maligo watigisa mapala gao na kulonga, “Aha! Gweye ulondile kuibananga Ng'anda ya Mulungu na kuizenga mmazua madatu, ");
INSERT INTO zajp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","uikombole mwenyego, uhumuluke mumsalaba!” ");
INSERT INTO zajp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Vivija wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa wamtendela uponela, wenyego kwa wenyego wolonga, “Kawakombola wayagwe, ila hadahile kukiikombola mwenyego! ");
INSERT INTO zajp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tumulole Kilisto Mkombola, Mndewa wa Islaeli, yahumuluke kulawa mumsalaba, na tweye tumtogole!” Vivija na waja wabili wawambigwe hamoja nayo wamuliga Yesu. ");
INSERT INTO zajp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Viivikile saa sita imisi, isi yose ikala igubikwe na ziza mbaka saa tisa ichungulo. ");
INSERT INTO zajp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Viivikile saa tisa, Yesu kenula dizwi kalila yolonga, “Eloi, Eloi, lama sabakitani?” nhegulo yake “Mulungu wangu, Mulungu wangu, habali undekile?” ");
INSERT INTO zajp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wanhu wakalile behi wahulika mbuli zija, walonga, “Tegeleza, komkema Eliya!” ");
INSERT INTO zajp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Munhu imwe kakimbila, kazabika siponji mdivai igwaduke kaika kuisota ya lumango, na kumgwelela Yesu yang'we, yolonga, “Beta tulole kamba Eliya kokwiza kumuhumulusa kulawa mumsalaba!” ");
INSERT INTO zajp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu kenula dizwi kaguta ng'hani, abaho, kadanganhika. ");
INSERT INTO zajp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Guo ditungikwe Mng'anda ya Mulungu didegeka vidanga vibili, kulawa uchana mbaka hasi. ");
INSERT INTO zajp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mkulu wa asikali mia wa Loma yakalile yemile haja haulongozi wa Yesu, kahulika avija viyakalile yolila na kumona vija viyodanganhika, kalonga, “Kweli munhu ino kakala Mwana wa Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kukala na watwanzi wolola kutalitali. Mmwanza wao wakala Maliamu wa kiwambo cha Magidala, Salome, Maliamu mamaake Usufu na Yakobo mdodo. ");
INSERT INTO zajp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Watwanzi wano wakala womkweleleza Yesu na kumsang'hanikila viyakalile Galilaya. Vivija watwanzi bwando wayagwe wakalile wokwela hamoja na heyo kwiza Yelusalemu, wakala bahaja. ");
INSERT INTO zajp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Dikala disigale zua dimwe kuvikila Zua da Mhumulo ajo dikemigwa zua da msasalo. Avo ichungulo vuikwenhuke, ");
INSERT INTO zajp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Usufu kulawa mdiwambo da Alimataya, yakalile imwe wa wanhu wa Ikitala Kikulu cha Isi ya Wayahudi, yakalile yobeta kwiza kwa Undewa wa Mulungu, bila kudumba kachola ha Pilato kulupula lukuli lwa Yesu. ");
INSERT INTO zajp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato kakanganya kuhulika kamba Yesu kesha kudanganhika. Kamkema mkulu wa asikali mia wa Loma, kamuuza kamba Yesu kadanganhika kamala. ");
INSERT INTO zajp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Viyahulike kulawa ha ija imkulu wa asikali mia wa Loma kamba Yesu kadanganhika, Pilato kamulongela Usufu yakalusole ulukuli. ");
INSERT INTO zajp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Abaho, Usufu kagula sanda, kaluhumulusa ulukuli, kaluzingiliza sanda na kulutambalika mdipanga dipukigwe mdibwe, abaho, kadibimbilisa dibwe kadika hamulomo wa idipanga. ");
INSERT INTO zajp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliamu wa kiwambo cha Magidala na Maliamu mamaake Usufu wahona halwikigwe lukuli lwa Yesu. ");
INSERT INTO zajp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Vidibitile Zua da Mhumulo, Maliamu wa kiwambo cha Magidala, Salome, na Maliamu mamaake Yakobo wagula mavuta ga kunung'hila giladi wakalubake lukuli lwa Yesu. ");
INSERT INTO zajp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ndamuka ya zua da mwanduso wa wiki, zua vudisongile kusimbuka, wachola kudipanga. ");
INSERT INTO zajp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Wakala wokiilongela wenyego kwa wenyego, “Yalihi yondayatubimbilisile idibwe hana umulomo wa idipanga?” ");
INSERT INTO zajp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ila viwalolile uchana, wajona dija idibwe dikalile kulu ng'hani dibimbilisigwa kumgwazo. ");
INSERT INTO zajp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Viwakalile wokwingila mdipanga, wamona mmhale imwe yavalile ng'hanzu nzelu yakalile kumkono wa ukulume wa idipanga, wasinhuka. ");
INSERT INTO zajp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ila kawalongela, “Sambimsinhuke, novimanya kamba momzahila Yesu wa Nazaleti, yawambwigwe mumsalaba. Kahaduhu hano, kazuka! Loleni, hanhu hawamtambalike. ");
INSERT INTO zajp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ila gendeni mkawalongele wanahina zake na Petulo, ‘Kowalongola kuchola Galilaya, ako momona kamba viyawalongele.’ ” ");
INSERT INTO zajp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wahalawa na kukimbila kulawa mdipanga, kwavija wagogigwa na bwembwe na mkanganyo, na hawamulongele munhu yoyose, kwavija wona bwembwe. ");
INSERT INTO zajp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu viyazukile kulawa mkudanganhika mdizua da mwanduso wa wiki, kasonga kumulawilila Maliamu wa kiwambo cha Magidala ayo yakalile na vinyamkela saba wawingigwe. ");
INSERT INTO zajp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maliamu kachola kuwalongela waja wakalile hamoja na heyo, viwakalile wokiiyalala na kulila. ");
INSERT INTO zajp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ila viwahulike kamba Yesu mgima na heyo mwenyego kamona, hawatogole. ");
INSERT INTO zajp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Vuzibitile mbuli zino, Yesu koneka mwa wanhu wabili wakalile wamtogole kuno yagaluke ikihanga, wakalile mnzila wolawa mkiwambo wochola kumigunda. ");
INSERT INTO zajp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wabwela na kuwalongela wayao, ila hawawatogole. ");
INSERT INTO zajp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hakimambukizo, Yesu kawalawilila wanahina longo dimwe na imwe viwakalile woja. Kawakomhokela, kwavija viwakalile bule nhamanila na vija viwakalile wadala mmioyo yao, kwavija hawawatogole waja wamonile kipigiti viyazukile kulawa mkudanganhika. ");
INSERT INTO zajp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kawalongela, “Gendeni muulumwengu wose mkaupete Usenga Unogile ha wanhu wose. ");
INSERT INTO zajp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Munhu yoyose yondayatogole na kubatizigwa kokomboligwa, ila munhu yoyose yoleka kutogola kotagusigwa. ");
INSERT INTO zajp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na vilaguso vino vokwandakana na awo wondawatogole. Mtwaga jangu wowinga vinyamkela, na wolonga ulonzi wa mkanganyo. ");
INSERT INTO zajp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wogoga nyoka na makono gao, na kamba wahang'wa kinhu chochose cha kukoma, hakiwagaza. Wokwika makono gao mwa watamu, na wohona.” ");
INSERT INTO zajp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Viyeshile kulonga nao, Mndewa Yesu kasoligwa uchana kuulanga kakala kumkono wa ukulume wa Mulungu. ");
INSERT INTO zajp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wanahina wachola kuupeta Usenga Unogile kila hanhu, na Mndewa kasang'hanika nao na kuzigangamiza mbuli zake na vilaguso vandakane nazo.");
INSERT INTO zajp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mkulu Teofilo, wanhu bwando waiyoha kwandika mumnhongo mbuli zija zivikizwe mmwetu. ");
INSERT INTO zajp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Wandika kamba vija vuzikalile zisimulilwa na waja wazonile na meso gao songela haichanduso, awo wakalile wozipeta. ");
INSERT INTO zajp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Avo na nie, Mkulu, avija vunizilolile goya mbuli zino zose songela ichanduso chake, nivigesa vinoga nikwandikile vinogile. ");
INSERT INTO zajp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Notenda vino giladi na gweye uitange ikweli ya mbuli zija zuufundizigwe. ");
INSERT INTO zajp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kipigiti Helode Mkulu vayakalile mndewa wa Yudea, kukala na mkulu wa nhambiko imwe twaga jake Zakalia, yakalile wa dale da watambika dikemigwa Abiya. Mtwanzi wake kakala yokemigwa Elizabeti, na heyo kakala wa lukolo lwa mtambika Haloni. ");
INSERT INTO zajp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wose wabili wakala womnogela Mulungu na wawinza ndagizi zose za Mndewa bila kusigaza. ");
INSERT INTO zajp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Zakalia na Elizabeti wakala wabule wana, kwavija Elizabeti kakala bule sambo, na hewo wose wabili wakala wavyele ng'hani. ");
INSERT INTO zajp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zua dimwe Zakalia kakala yosang'hana sang'hano za watambika Mng'anda ya Mulungu, kwavija dale jake da watambika dikala mzamu. ");
INSERT INTO zajp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kamba viwazoele kutenda watambika, kula imgwila Zakalia yachole kufusha ubane kuna ikilingo cha kulavila nhosa. Avo kengila Mng'anda ya Mndewa, ");
INSERT INTO zajp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","wanhu wose wakala wakiilundize hanze wotambika kipigiti hicho cha kufusha ubane. ");
INSERT INTO zajp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Msenga wa Mndewa wa kuulanga kamulawilila, kema ng'ambu ya ukulume ya ikilingo cha kufushila ubane. ");
INSERT INTO zajp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakalia viyamuwene, kasinhuka, bwembwe dimwingila. ");
INSERT INTO zajp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Msenga wa Mulungu wa kuulanga kamulongela, “Zakalia, sambiudumbe kwavija Mulungu kazihulika nhambiko zako, avo Elizabeti mtwanzi wako kokulelela mwana mbigalo, na gweye umgwelele twaga dikemigwa Yohana. ");
INSERT INTO zajp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kosekelela na kudeng'ha ng'hani, na wanhu bwando woitoela ng'henze mvumbuka yake! ");
INSERT INTO zajp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kowa mkulu hameso ga Mndewa. Hang'wa ugimbi ama kinhu chochose cha kukola. Komemezigwa Loho wa Mulungu songela mmunda mwa mamaake. ");
INSERT INTO zajp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kowabweza wanhu bwando wa Islaeli kuli Mndewa Mulungu wao. ");
INSERT INTO zajp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kochola haulongozi wa Mndewa na mhiko na loho ya Eliya, kowaduganyiza tena watata na wana zao, kowatenda wanhu wadulu wawe wende avo yamtandile Mndewa wanhu zake.” ");
INSERT INTO zajp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakalia kamuuza msenga wa Mulungu wa kuulanga, “Novitangaze kamba mbuli zino zowa avo? Kwavija nie na mtwanzi wangu tose twa wavyele.” ");
INSERT INTO zajp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Msenga wa Mulungu wa kuulanga kamwidika, “Nie iyo Gabulieli, mtumigwa nimaga haulongozi wa Mulungu, nitumigwa nikugalile usenga uno unogile. ");
INSERT INTO zajp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ila kwavija huzitogole mbuli zangu zondazivikile mumsimu wake, kowa bubui, hudaha kulonga mbaka zua dija gano gose ganikulongele vondagalawilile.” ");
INSERT INTO zajp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kipigiti hicho wanhu wakala wom'beta Zakalia kuno wokanganya habali kokawa muja Mng'anda ya Mulungu. ");
INSERT INTO zajp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Viyalawile hanze, kakala hadaha kulonga nao, avo wavitanga kamba kakala yonile nzozi Mng'anda ya Mulungu. Kakala hadaha kulonga, kakala yolonga mkulagusa na makono. ");
INSERT INTO zajp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kipigiti chake cha kusang'hanika Muing'anda ya Mulungu vukimalile, kabwela ukae. ");
INSERT INTO zajp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mkipigiti kiguhi mtwanzi wake kapata inda, avo kakala hakae yake milenge mitano. ");
INSERT INTO zajp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kalonga, “Hakimambukizo, Mndewa kanyonela bazi, kanisegezela kinyala changu mwa wanhu.” ");
INSERT INTO zajp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Muna umulenge wa sita wa inda ya Elizabeti, Mulungu kamulagiza msenga wake wa kuulanga, yokemigwa Gabulieli, hakiwambo cha Galilaya, kikemigwa Nazaleti. ");
INSERT INTO zajp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kakala na usenga wa mndele imwe mhambe, mkasano wa munhu imwe twaga jake Usufu kulawa mulukolo lwa Mndewa Daudi. Twaga jake Maliamu. ");
INSERT INTO zajp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Msenga wa Mulungu wa kuulanga kamcholela kamulongela, “Nokulamsa! Mndewa ka hamoja nagwe na kakumoteza ng'hani!” ");
INSERT INTO zajp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliamu kazanywa ng'hani sama ya mbuli zija za msenga wa Mulungu wa kuulanga na kugelegeza choni nhegulo ya mbuli zija. ");
INSERT INTO zajp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Msenga wa Mulungu wa kuulanga kamulongela, “Sambiudumbe, Maliamu, kwavija Mulungu kanogelwa nagwe. ");
INSERT INTO zajp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kopata inda, komulela mwana mbigalo, na gweye kolondigwa umgwelele twaga dikemigwa Yesu. ");
INSERT INTO zajp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Heyo kowa mkulu na kokemigwa Mwana wa Mulungu Mkulu Ng'hani. Mndewa Mulungu komgwelela kigoda cha undewa kamba tataake Daudi. ");
INSERT INTO zajp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Avo kowa Mndewa wa lukolo lwa Yakobo milongo yose, Undewa wake hauziga!” ");
INSERT INTO zajp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maliamu kedika kalonga, “Nie na mhambe. Yodahikaze mbuli ino?” ");
INSERT INTO zajp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Msenga wa Mulungu wa kuulanga kedika kalonga, “Loho wa Mulungu kokuhumulukila, na mhiko za Mulungu Mkulu Ng'hani zokugubika. Avo mwana yondayavumbuke kowa mwana yang'alile, kokemigwa Mwana wa Mulungu. ");
INSERT INTO zajp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mgelegeze lumbu jako Elizabeti wamulongile kabule sambo, ila sambi kana inda ya milenge sita hamoja na uvyele wake. ");
INSERT INTO zajp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwavija haduhu mbuli haidahika ha Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maliamu kedika kalonga, “Nie na mtumigwa wa Mndewa, na nhendelwe kamba vuulongile.” Abaho, ija msenga wa Mulungu wa kuulanga kahalawa. ");
INSERT INTO zajp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kipigiti kidodo hamwande Maliamu kaisasala, hima kachola kuna ikiwambo kili muisi ya vigongovigongo ya Yudea. ");
INSERT INTO zajp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kengila muna ing'anda ya Zakalia, kamulamsa Elizabeti. ");
INSERT INTO zajp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeti viyahulike ndamsa ya Maliamu, chana king'hele kizumha mkudeng'ha muinda ya Elizabeti. Na Elizabeti kamemezigwa Loho wa Mulungu, ");
INSERT INTO zajp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","na kenula dizwi kalonga, “Kumota gweye kubanza watwanzi wose, na imwana yondaumulele kamota! ");
INSERT INTO zajp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Vilihi mbuli zino ng'hulu zindawilile nie, hata mama wa Mndewa wangu yeze kumwangu? ");
INSERT INTO zajp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mhunde vinihulike ndamsa yako, chana king'hele muinda yangu kizumha mkudeng'ha. ");
INSERT INTO zajp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kumota gweye utogole kamba gaja gayalongile Mndewa kumwako golawilila!” ");
INSERT INTO zajp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Na Maliamu kalonga, “Moyo wangu womuyenzi Mulungu. ");
INSERT INTO zajp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Loho yangu yomdeng'helela Mulungu Mkombola wangu. ");
INSERT INTO zajp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kwavija kamgelegeza nyakadala wake imwende! Avo kusongela lelo wanhu wa milelo yose wong'hema yamotile, ");
INSERT INTO zajp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mmbuli zija ng'hulu Mulungu Mkulu zayanitendele. Twaga jake ding'ala. ");
INSERT INTO zajp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kulawa wanhu wa mulelo umwe mbaka mulelo uyagwe kowonela bazi awo womdumba heyo. ");
INSERT INTO zajp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kaugolosa mkono wake mkulu na kawapwililisa awo woitopela ngelegeza zao. ");
INSERT INTO zajp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kawahumulusa wandewa wali na mhiko walawe muna ivigoda vao va undewa, na kawenula iwakumbulu. ");
INSERT INTO zajp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wali nzala kawegutiza vinhu vinogile, na wagoli kawaleka wachole bila kinhu. ");
INSERT INTO zajp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kakigoga kilagano chayailagane na wahenga zetu, avo keza kumtaza mtumigwa wake Islaeli. ");
INSERT INTO zajp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kakumbukila kumonela bazi Ablaham na lukolo lake lose milongo yose kamba viwailagane na wahenga zetu!” ");
INSERT INTO zajp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliamu kakala na Elizabeti kamba milenge midatu vino, abaho, kabwela ukae yake. ");
INSERT INTO zajp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kipigiti cha Elizabeti kulela kivika, kamulela mwana mbigalo. ");
INSERT INTO zajp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wanhu wa mmambwegambwega na walawile mulukolo lwake viwahulike mbuli zija zinogile za mkanganyo Mndewa ziyamtendele, wose wadeng'helela hamoja na heyo. ");
INSERT INTO zajp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Zua da nane weza kumwingiza kumbi imwana, walonda kumgwaa twaga da tataake, Zakalia. ");
INSERT INTO zajp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mamaake kalonga, “Ndema! Twaga jake dokemigwa Yohana.” ");
INSERT INTO zajp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wanhu wamulongela, “Ila mulukolo lwenu haduhu munhu yali na twaga hijo.” ");
INSERT INTO zajp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Abaho, wamuuza tataake mkumulagusila na makono, womuuza kamba twaga dilihi doyolonda yagweleligwe mwanage. ");
INSERT INTO zajp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kawapula kibanzi cha kwandikila, kandika vino, “Twaga jake Yohana.” Wanhu wose wakanganya. ");
INSERT INTO zajp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Baho mulomo na lulimi lwake Zakalia vifunguligwa, kasonga kulonga, kamuyenzi Mulungu. ");
INSERT INTO zajp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bwembwe diwengila wanhu wose wa mmambwegambwega na mbuli hizo zisimulilwa ng'ambu zose za isi ya vigongovigongo ya Yudea. ");
INSERT INTO zajp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Wose wahulike mbuli hizo wagelegeza mmioyo yao, wolonga, “Mwana ino kowa munhu wa vilihi? Kwavija mhiko za Mndewa za hamoja na heyo.” ");
INSERT INTO zajp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakalia tataake imwana kamemezwa Loho wa Mulungu, na kulonga usenga uno wa Mulungu, ");
INSERT INTO zajp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Yayenzigwe Mndewa, Mulungu wa Islaeli! Kwavija keza kuwataza wanhu zake na kuwakombola. ");
INSERT INTO zajp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Katugwelela Mkombola mkulu, wa lukolo lwa mtumigwa wake Daudi, ");
INSERT INTO zajp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kamba vija vayailagane na wahokozi zake wang'alile umwaka, ");
INSERT INTO zajp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kamba kotukombola tulawe mmakono ga wadumuka, na kulawa mmakono ga wose watwihile. ");
INSERT INTO zajp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kalonga kowonela bazi wahenga zetu na kudikumbukila lagano jake ding'alile. ");
INSERT INTO zajp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kamduilila Ablaham tata wetu, ");
INSERT INTO zajp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kailagana na heyo kamba kotukombola kulawa mmakono ga wadumuka, na kututenda tweye tumsang'hanikile heyo bila bwembwe, ");
INSERT INTO zajp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","giladi tuwe wanhu wang'alile na tulibule uzenzeleganye haulongozi wake, mazua gose ga ugima wetu. ");
INSERT INTO zajp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Na gweye, mwanangu, kokwiza kukemigwa muhokozi wa Mulungu Mkulu Ng'hani. Kolongola haulongozi wa Mndewa kumtandila nzila yake, ");
INSERT INTO zajp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kowalongela wanhu zake avija vondawakomboligwe mkusegezelwa vilozo vao. ");
INSERT INTO zajp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mulungu wetu kogatenda higo sama ya bazi jake kulu, na ukombola wake kulawa kuulanga wotuhumulukila kamba zua da imitondo ");
INSERT INTO zajp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na kuwamulikila wose wokala mdiziza na awo wakala mdisisila da kudanganhika, na kugalongoza magulu getu muna inzila ya tindiwalo.” ");
INSERT INTO zajp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwana ija kakula na kuwa na mhiko muloho. Kakala muluwala mbaka zua dija viyalawilile mwa wanhu wose wa Islaeli. ");
INSERT INTO zajp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mazua gaja mkulu wa undewa wa Loma, yakalile yokemigwa Augusto, kalagiza wanhu wakalile muundewa wose wa Loma matwaga gao gandikigwe mkitabu. ");
INSERT INTO zajp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nyandikisha ino ikala ya ichanduso, kipigiti kija Kulenio viyakalile mkulu wa isi ya Silia. ");
INSERT INTO zajp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Avo wose wachola kwandikigwa kila munhu mkiwambo chake mwenyego. ");
INSERT INTO zajp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Usufu na heyo kasegela kulawa hakiwambo cha Nazaleti muisi ya Galilaya, kakwela kachola kukiwambo cha Betelehemu muisi ya Yudea, kwaaleligwe Mndewa Daudi kwavija kakala yolawa mulukolo lwa Daudi. ");
INSERT INTO zajp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kachola kwandikigwa hamoja na mkasano wake Maliamu, ayo yakalile na inda. ");
INSERT INTO zajp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Viwakalile hiko, kipigiti chake cha kulela kivika. ");
INSERT INTO zajp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kamulela chaudele mbigalo, kam'vaza vivalo vowowavazaga wana ving'hele, kamtambalika mkia kiwadilaga ng'ombe, kwavija hawapatile gati muna ing'anda ya wahenza. ");
INSERT INTO zajp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ng'ambu ija kukala na wachunga wokwimiliza madale gao ga ng'hondolo ikilo mmigunda. ");
INSERT INTO zajp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Msenga wa Mndewa wa kuulanga kawalawilila, na yenzi ya Mndewa Mulungu iwamulika ng'ambu zose, wadumba ng'hani. ");
INSERT INTO zajp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Msenga wa Mulungu wa kuulanga kawalongela, “Sambimdumbe! Niwagalila mbuli inogile yondaiwatende wanhu wose wadeng'he ng'hani. ");
INSERT INTO zajp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kwavija lelo ino muna ikiwambo cha Daudi kavumbuka Mkombola wenu, iyo Kilisto Mndewa. ");
INSERT INTO zajp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na vino vivo vondamumtambule, mom'vika mwana king'hele yavazigwe vivalo vowowavazaga wana ving'hele katambalikwa mkia kiwadilaga ng'ombe.” ");
INSERT INTO zajp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Baho dale kulu da wasenga wa Mulungu wa kuulanga diza kuilumba hamoja na miyao wa ichanduso, womuyenzi Mulungu, wolonga, ");
INSERT INTO zajp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Yenzi ha Mulungu yali uchana ng'hani kuulanga, na tindiwalo muisi, ha wanhu wanogelwe na heyo!” ");
INSERT INTO zajp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Waja iwasenga wa Mulungu wa kuulanga viwabweleganye kuulanga, waja iwachunga wakiilongela, “Tucholeni Betelehemu tukalole mbuli ino ilawilile, Mndewa yaatulongele.” ");
INSERT INTO zajp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Avo wachola hima wam'vika Maliamu na Usufu na wamona ija imwana king'hele katambalikwa mkia kiwadilaga ng'ombe. ");
INSERT INTO zajp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wachunga viwamonile ija imwana, wawalongela wanhu mbuli za mwana ija ziwahulike kulawa ha msenga wa Mulungu wa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wanhu wose wakanganya viwahulike mbuli ziwalongeligwe na wachunga. ");
INSERT INTO zajp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maliamu kazika mbuli zija zose mmoyo wake kuno yozigelegeza. ");
INSERT INTO zajp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Waja iwachunga wabwela kuno womuyenzi na kumtogola Mulungu, kwavija gaja gawahulike na kugona gawa kamba vija msenga wa Mulungu wa kuulanga viyawalongele. ");
INSERT INTO zajp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Vigabitile mazua manane, kipigiti cha kumwingiza kumbi vikivikile, wamgwaa twaga Yesu, twaga dayagweleligwe na msenga wa Mulungu wa kuulanga kipigiti mamaake hanapata inda. ");
INSERT INTO zajp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kipigiti cha Usufu na Maliamu kutaulwa vikivikile kamba Malagizo ga Musa vigalagize, Usufu na Maliamu wamsola imwana wachola na heyo Yelusalemu wamwike mmakono ga Mndewa. ");
INSERT INTO zajp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Muna Gamalagizo ga Mndewa yandikigwa, “Wana mbigalo wose wa udele wobagulwa na kwikigwa sama ya Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Vivija wachola kulava nhosa kamba viilagizwe Mmalagizo ga Mndewa, hua wabili ama makinda mabili ga njiwa. ");
INSERT INTO zajp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kipigiti kija kukala na munhu imwe twaga jake Simioni yakalile yokala Yelusalemu. Kakala yomdumba Mulungu, yotenda gamnogele Mulungu na kakala yololela kukombolwa kwa Islaeli. Na Loho wa Mulungu kakala na heyo. ");
INSERT INTO zajp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Loho wa Mulungu kamgubulila kamba heza kudanganhika mbaka yamone Kilisto Mndewa. ");
INSERT INTO zajp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kuno yolongozwa na Loho wa Mulungu, Simioni kachola Kuing'anda ya Mulungu. Usufu na Maliamu viwamgalile Yesu Kung'anda ya Mulungu wamtendele kamba viilagizigwe muna Gamalagizo ga Musa, ");
INSERT INTO zajp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simioni kamsola Yesu mmakono gake kuno yomuyenzi Mulungu yolonga, ");
INSERT INTO zajp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Avino, Mndewa, kugavikiza gaja gautulongele, avo muleke nyakadala wako yachole mditindiwalo. ");
INSERT INTO zajp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwavija nyona ukombola wako na meso gangu mwenyego, ");
INSERT INTO zajp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","awo uugalile sama ya wanhu wa isi zose. ");
INSERT INTO zajp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mulenge wondauwagubulile Wamhazi gaja gaulonda, na kugala yenzi mwa wanhu zako wa Islaeli.” ");
INSERT INTO zajp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tata na mama wa imwana wakala wokanganya mbuli ziyalongile Simioni yomulonga Yesu. ");
INSERT INTO zajp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simioni kawamoteza, kamulongela Maliamu mamaake imwana, “Tegeleza, mwana ino kavumbuka giladi yawe kilamso cha kuhumuluswa kwa wanhu bwando na kwinuligwa kwa wanhu bwando muna iisi ya Islaeli. Kowa kilaguso kilawa ha Mulungu chondakilemigwe na wanhu, ");
INSERT INTO zajp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","avo ngelegeza za wanhu bwando zili mgati zokoneka. Na gweye mwenyego usungu uli kamba zele wokuhoma mmoyo wako.” ");
INSERT INTO zajp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Vivija kukala na muhokozi imwe mtwanzi m'vyele ng'hani twaga jake Ana, mndele wa Fanueli wa mtala wa Asheli. Kakala yakalile na mbigalo milao saba songela viyasoligwe, ");
INSERT INTO zajp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","songela aho kakala kizuka mbaka viyakalile m'vyele wa milao malongo manane na mine. Kipigiti hicho chose kakala Kung'anda ya Mulungu yomtambikila Mulungu misi na kilo, yofunga na kutambika. ");
INSERT INTO zajp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kipigiti kikija keza, na kusonga kamuyenzi Mulungu na kulonga mbuli za ija imwana mmagwiti ga wanhu wose wakalile wololela kukomboligwa kwa Yelusalemu. ");
INSERT INTO zajp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Usufu na Maliamu viweshile kutenda gose galagizwe muna Gamalagizo ga Mndewa, wabwela ukae yao kukiwambo cha Nazaleti muisi ya Galilaya. ");
INSERT INTO zajp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana ija kakula, kongezeka mhiko na ng'hungwe, na Mulungu kammoteza. ");
INSERT INTO zajp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Milao yose Usufu na Maliamu wokwelaga wochola Yelusalemu mkipigiti cha lusona lwa Wayahudi lukemigwa Pasaka. ");
INSERT INTO zajp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu viyakalile mmhale wa milao longo dimwe na mibili, wachola kuna ulusona kamba vowotendaga milao yose. ");
INSERT INTO zajp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ulusona vulwishile, wasonga mwanza wa kubwela kumwao, ila Yesu kasigala Yelusalemu. Usufu na Maliamu hawavitangile. ");
INSERT INTO zajp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wagiza kakala mdale da wanhu mnzila, wachola mwanza wa zua dimwe, abaho, wasonga kumzahila mwa wandugu na wambwiga zao. ");
INSERT INTO zajp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hawamonile, avo wabwela Yelusalemu kumzahila. ");
INSERT INTO zajp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Zua da ikadatu wam'vika Kung'anda ya Mulungu, kakala na wafundiza Malagizo ga Musa, yowategeleza na kuwauza. ");
INSERT INTO zajp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wose wahulike mbuli zake wakanganya ubala na nyidikilo zake. ");
INSERT INTO zajp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Usufu na Maliamu viwamonile wakanganya ng'hani, Maliamu mamaake kamuuza, “Habali ututendele vino, mwanangu? Tataako na nie tugaya tukuzahila kuno tugudema.” ");
INSERT INTO zajp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ila heyo kawedika yolonga, “Habali munizahila? Ham'vitangile avija vinilondigwa nikale mng'anda ya Tataangu?” ");
INSERT INTO zajp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tataake na mamaake hawaitangile nhegulo ya mbuli ino. ");
INSERT INTO zajp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Avo Yesu kahumuluka kabwela Nazaleti na hewo, kakala mwende ha tataake na mamaake. Mamaake kazika mbuli zija zose mmoyo wake. ");
INSERT INTO zajp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu kakula mulukuli na mng'hungwe. Kadeng'helwa na Mulungu na wanhu. ");
INSERT INTO zajp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mulongo umwe na milao mitano ya undewa wa Mndewa Tibelio, Pontio Pilato kakala mtawala wa isi ya Yudea. Helode Antipa kakala mtawala wa isi ya Galilaya, na mkulu wake Filipo kakala mndewa wa isi ya Itulea na Tulakoniti. Lisania kakala mndewa wa isi ya Abilene, ");
INSERT INTO zajp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","na Anasi na Kayafa wakala wakulu wa wakulu wose wa nhambiko. Kipigiti kikija mbuli za Mulungu zim'vikila Yohana, mwanage Zakalia, kuja kuluwala. ");
INSERT INTO zajp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Avo Yohana kachola muisi zose zizunguluke Ulwanda lwa Yolodani, kawapetela, yolonga, “Lekeni vilozo venu mkabatizigwe, na Mulungu kovigela kumgongo vilozo venu.” ");
INSERT INTO zajp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kamba vija viyandikigwe muna ikitabu cha muhokozi Isaya, “Munhu kenula dizwi muluwala, yolonga, ‘Itandeni nzila ya Mndewa, mgoloseleni nzila zake. ");
INSERT INTO zajp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Migea yose yokusiligwa, vigongo na visugulu vose vohimbuligwa. Nzila ziveduke zogolosigwa, hali na mikolongokolongo hatelebuswe. ");
INSERT INTO zajp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na wanhu wose wowona ukombola kulawa ha Mulungu.’ ” ");
INSERT INTO zajp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yohana kawalongela wanhu bwando wamwizile wabatizigwe, “Mweye wana wa nyoka! Iyo yalihi yawazumile kulukimbila lusango lwa Mulungu londalwize? ");
INSERT INTO zajp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tendeni mbuli zilagusa kamba muleka vilozo venu. Sambimsonge kuilongela kamba ‘Ablaham iyo tata wetu.’ Kwavija nie nowalongela Mulungu kodaha kumwinulila Ablaham wana kulawa mgamabwe gano. ");
INSERT INTO zajp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Avo nhemo ikigwa goya kuikanha mibiki mmisina, avo biki jojose dondadileke kulela mujo unogile dokanhigwa na kwasigwa hamoto.” ");
INSERT INTO zajp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dale da wanhu dimuuza, “Avo, tutendeze?” ");
INSERT INTO zajp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kawalongela, “Yali na vivalo vibili yam'bagulile yalibule, na yali na mandia yatende vivo.” ");
INSERT INTO zajp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wawila kodi na hewo weza kubatizigwa, wamuuza, “Mkulufunzi, na tweye tutendeze?” ");
INSERT INTO zajp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Na heyo kawalongela, “Sambimuwile kodi ng'hulu kubanza vumulagizwe.” ");
INSERT INTO zajp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Asikali na hewo weza kumuuza, “Na tweye tutende choni?” Na heyo kawalongela, “Sambim'bokonye hela za munhu yoyose ama sambimum'vwizile mbuli munhu yoyose, mwenelwe na maliho genu.” ");
INSERT INTO zajp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Wanhu wose wakala wamemile nhamanila ha Yohana, wakala wokiiuza mmioyo yao kamba siku Yohana iyo Kilisto. ");
INSERT INTO zajp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Avo Yohana kawalongela wanhu wose, “Nie nowabatiza mweye na mazi, ila kokwiza yali na mhiko kubanza nie, nie sidaha hata kufungula nzabi za ng'hwabasa zake. Heyo kowabatiza na Loho wa Mulungu na moto. ");
INSERT INTO zajp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Heyo kana kia chake cha kubetela ngano yake, yakunzanye ingano kukano, na imikumvi yaisome na moto hauzimikaga.” ");
INSERT INTO zajp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohana kaupeta Usenga Unogile mwa wanhu yowazuma mkuwagong'ondeza na mbuli bwando waleke gehile. ");
INSERT INTO zajp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ila Yohana kamkomhokela Helode Antipa, mndewa, kwavija kakala yamsolile Helodia, mtwanzi wa ndugu yake, na gehile gose goyokala yotenda. ");
INSERT INTO zajp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Avo Helode kabanziliza udumuka wake ha Yohana, na kamgela mkifungo. ");
INSERT INTO zajp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wanhu wose viweshile kubatizigwa, Yesu na heyo kabatizigwa. Na viyakalile yotambika, ulanga uvuguka, ");
INSERT INTO zajp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Loho wa Mulungu kamuhumulukila yalumbile kamba hua. Dizwi dihulikwa kulawa kuulanga, “Gweye iyo Mwanangu uninogele, ninogelwa nagwe.” ");
INSERT INTO zajp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu viyasongile sang'hano yake, kakala na milao malongo madatu. Na wanhu wamgesa iyo mwana wa Usufu, mwanage Heli. ");
INSERT INTO zajp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli kakala mwanage Matati, Matati kakala mwanage Lawi, Lawi kakala mwanage Meliki, Meliki kakala mwanage Yanai, na Yanai kakala mwanage Usufu, ");
INSERT INTO zajp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Usufu kakala mwanage Matatia, Matatia kakala mwanage Amosi, Amosi kakala mwanage Nahumu, Nahumu kakala mwanage Hesili, Hesili kakala mwanage Nagai, ");
INSERT INTO zajp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai kakala mwanage Maati, Maati kakala mwanage Matatia, Matatia kakala mwanage Shemeni, Shemeni kakala mwanage Yoseki, Yoseki kakala mwanage Yoda, ");
INSERT INTO zajp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda kakala mwanage Yohanani, Yohanani kakala mwanage Lesa, Lesa kakala mwanage Zelubabeli, Zelubabeli kakala mwanage Shelitieli, Shelitieli kakala mwanage Neli, ");
INSERT INTO zajp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli kakala mwanage Meliki, Meliki kakala mwanage Adi, Adi kakala mwanage Kosamu, Kosamu kakala mwanage Elimadamu, Elimadamu kakala mwanage Eli, ");
INSERT INTO zajp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eli kakala mwanage Yoshua, Yoshua kakala mwanage Eliezeli, Eliezeli kakala mwanage Yolimu, Yolimu kakala mwanage Matati, Matati kakala mwanage Lawi, ");
INSERT INTO zajp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawi kakala mwanage Simioni, Simioni kakala mwanage Yuda, Yuda kakala mwanage Usufu, Usufu kakala mwanage Yonamu, Yonamu kakala mwanage Eliakimu, ");
INSERT INTO zajp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimu kakala mwanage Melea, Melea kakala mwanage Mena, Mena kakala mwanage Matata, Matata kakala mwanage Natani, Natani kakala mwanage Daudi, ");
INSERT INTO zajp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daudi kakala mwanage Yese, Yese kakala mwanage Obedi, Obedi kakala mwanage Boazi, Boazi kakala mwanage Salimoni, Salimoni kakala mwanage Nashoni, ");
INSERT INTO zajp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashoni kakala mwanage Aminadabu, Aminadabu kakala mwanage Adimini, Adimini kakala mwanage Ani, Ani kakala mwanage Heziloni, Heziloni kakala mwanage Pelesi, Pelesi kakala mwanage Yuda, ");
INSERT INTO zajp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda kakala mwanage Yakobo, Yakobo kakala mwanage Isaka, Isaka kakala mwanage Ablaham, Ablaham kakala mwanage Tela, Tela kakala mwanage Naholi, ");
INSERT INTO zajp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naholi kakala mwanage Selugi, Selugi kakala mwanage Leu, Leu kakala mwanage Pelegi, Pelegi kakala mwanage Ebeli, Ebeli kakala mwanage Shela, ");
INSERT INTO zajp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shela kakala mwanage Kainamu, Kainamu kakala mwanage Alufaksadi, Alufaksadi kakala mwanage Shemu, Shemu kakala mwanage Nuhu, Nuhu kakala mwanage Lameki, ");
INSERT INTO zajp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameki kakala mwanage Metusela, Metusela kakala mwanage Henoko, Henoko kakala mwanage Yaledi, Yaledi kakala mwanage Mahalaleli, Mahalaleli kakala mwanage Kainamu, ");
INSERT INTO zajp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainamu kakala mwanage Enoshi, Enoshi kakala mwanage Seti, Seti kakala mwanage Adamu, Adamu kakala mwanage Mulungu. ");
INSERT INTO zajp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu kalawa Mulwanda lwa Yolodani kuno yamemile Loho wa Mulungu, kalongozwa na Loho wa Mulungu mbaka muluwala. ");
INSERT INTO zajp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ako kagezigwa na Mwenembago mkipigiti cha mazua malongo mane. Kipigiti hicho chose hadile kinhu chochose, kipigiti hicho vikimalile, kona nzala. ");
INSERT INTO zajp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mwenembago kamulongela, “Uhawa gweye iyo Mwana wa Mulungu, dilongele dibwe dino digaluke mkate.” ");
INSERT INTO zajp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu kedika kalonga, “Yandikigwa Mzinyandiko Zing'alile, ‘Munhu hawa mgima sama ya mkate wiyeka.’ ” ");
INSERT INTO zajp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mwenembago kamsola kamgala uchana ng'hani, mkipigiti kiguhi kamulagusila ndewa zose za ulumwengu. ");
INSERT INTO zajp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mwenembago kamulongela, “Nokugwelela mhiko zino zose na mali gano gose, kwavija nigweleligwa na nodaha kumgwaa yoyose inimulonda. ");
INSERT INTO zajp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Uhanitambikila, vino vose vowa vako gweye.” ");
INSERT INTO zajp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu kamwidika, “Yandikigwa Mzinyandiko Zing'alile, ‘Mtambikile Mndewa Mulungu wako na umsang'hanikile heyo yeiyeka!’ ” ");
INSERT INTO zajp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mwenembago kamsola kamgala Yelusalemu kuna inhembeti ya Ing'anda ya Mulungu, kamulongela, “Uhawa gweye iyo Mwana wa Mulungu, ibwanhe hasi kulawa hano. ");
INSERT INTO zajp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kwavija yandikigwa Mzinyandiko Zing'alile, ‘Mulungu kokulagizila wasenga zake wa kuulanga wakwimilize.’ ");
INSERT INTO zajp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kabili yandikigwa, ‘Wokudang'ha mmakono gao, sambiuikwale mgulu wako muna idibwe.’ ” ");
INSERT INTO zajp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ila Yesu kamwidika, “Yandikigwa Mzinyandiko Zing'alile, ‘Sambiumgeze Mndewa Mulungu wako.’ ” ");
INSERT INTO zajp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mwenembago viyeshile kumgeza mmbuli zose, kamuleka mkipigiti kidodo. ");
INSERT INTO zajp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu kabwela muisi ya Galilaya yamemile mhiko za Loho wa Mulungu, na singilimo zake zenela isi zose za mmambwegambwega. ");
INSERT INTO zajp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Na heyo kakala yowafundiza wanhu muna zing'anda zao za nhambiko, na wanhu wose wamtogola. ");
INSERT INTO zajp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Abaho, Yesu kachola Nazaleti kiwambo chayakulile, na muna Idizua da Mhumulo, kengila mng'anda ya nhambiko kamba vayazoele. Kema giladi yasome Nyandiko Zing'alile. ");
INSERT INTO zajp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kagweleligwa ikitabu cha muhokozi Isaya. Kakigubula kavika hanhu handikigwe vino, ");
INSERT INTO zajp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Loho wa Mndewa ka hamoja na nie, kwavija kanisagula niwagalile wakumbulu Usenga Unogile. Kanilagiza niipete ndekesa mwa awo wagogigwe, na vimbugumbugu wadahe kulola, niwadohole waja wogazigwa. ");
INSERT INTO zajp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na kupeta kamba kipigiti kivika cha mndewa kuwakombola wanhu zake.” ");
INSERT INTO zajp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Abaho, Yesu kakigubika ikitabu kam'bwezela mwimilizi wa ing'anda ya nhambiko, abaho, kakala hasi. Wanhu wose wakalile muja mng'anda ya nhambiko wamulola ng'hani. ");
INSERT INTO zajp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na heyo kawalongela “Lelo Nyandiko zino Zing'alile zivikila, kamba vumuhulike.” ");
INSERT INTO zajp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wanhu wose wanogelwa ng'hani, wakanganya mbuli zinogile zayalongile. Walonga, “Ino sio mwanage Usufu?” ");
INSERT INTO zajp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu kawalongela, “Nivitanga kamba monilongela ulonzi uno, ‘Mganga, ihonye mwenyego! Gaja gatuhulike ugatendile Kapenaumu ugatende hano hakiwambo chako mwenyego.’ ” ");
INSERT INTO zajp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kagendelela kulonga, “Nowalongeleni ikweli, muhokozi hatogoligwa hakae yake mwenyego. ");
INSERT INTO zajp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Kweli, kukala na vizuka bwando muna iisi ya Islaeli kipigiti chayakalile Eliya, kipigiti mvula vuilekile kutoa milao midatu na milenge sita, nzala ikala mpamanho muna iisi yose. ");
INSERT INTO zajp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ila Eliya hatumigwe ha kizuka yoyose, ila ha kizuka imwe yakalile Salepta muna iisi ya Sidoni. ");
INSERT INTO zajp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na kukala wanhu bwando wakalile na dikulu muna iisi ya Islaeli kipigiti chayakalile muhokozi Elisha, na haduhu mtamu yoyose wa dikulu yahonyigwe, ila Naamani yeiyeka yakalile yokala muisi ya Silia.” ");
INSERT INTO zajp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wanhu wose wakalile muja mng'anda ya nhambiko viwahulike mbuli zija wona lusango. ");
INSERT INTO zajp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wema, wamkwekwesa Yesu, wamulava hanze ya ikiwambo. Wamsola wamgala uchana ya ikigongo, haja idiwambo jao hadizengigwe, walonda kumsung'hizila mdigema. ");
INSERT INTO zajp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ila Yesu kabita hagatigati yao, kachola na zake. ");
INSERT INTO zajp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Abaho, Yesu kachola kukiwambo cha Kapenaumu muisi ya Galilaya, kawafundiza wanhu muna Dizua da Mhumulo. ");
INSERT INTO zajp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wakanganya avija voyokala yofundiza kwavija mbuli zake zikala na udaho. ");
INSERT INTO zajp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Muja muna ing'anda ya nhambiko kukala na munhu yakalile na kinyamkela, katoa nyangi yolonga, ");
INSERT INTO zajp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ka! Kotulonda choni gweye, Yesu wa Nazaleti? Kwiza kutubananga? Nokutanga, gweye iyo Ung'alile wa Mulungu!” ");
INSERT INTO zajp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu kamkomhokela ija kinyamkela, yolonga, “Nyamala, mulawe munhu ino.” Kinyamkela kam'bwanha hasi ija imunhu hameso gao, kamulawa bila kumulumiza hanhu. ");
INSERT INTO zajp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wanhu wose wakanganya, wailongela, “Mbuli zaki zino? Munhu ino kana mhiko na udaho wa kuwakomhokela vinyamkela, nao wolawa!” ");
INSERT INTO zajp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mbuli za Yesu zenela ng'ambu zose za isi ija. ");
INSERT INTO zajp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu kalawa muna ing'anda ya nhambiko, kachola hakae ya Simoni. Mama mkwe yake Simoni kakala yolumwa homa ng'hali, avo wamulongela Yesu yamuhonye. ");
INSERT INTO zajp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu keza kema behi na heyo, kaikomhokela ija ihoma, imulawa, kenuka na kuwasang'hanikila. ");
INSERT INTO zajp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Viivikile ichungulo, wanhu wose wawagala ha Yesu wanhu zao wakalile wolumwa vitamu va namna zose, kawekila makono gake kawahonya. ");
INSERT INTO zajp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Vinyamkela wawalawa wanhu bwando, watoa nyangi wolonga, “Gweye iyo Mwana wa Mulungu.” Yesu kawakomhokela hawalekile walonge, kwavija wamtanga heyo iyo Kilisto. ");
INSERT INTO zajp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ulukwili, Yesu kasegela kachola hanhu halibule wanhu. Wanhu wasonga kumzahila, viwamonile, wageza kumzuila sambiyasegele hamwao. ");
INSERT INTO zajp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ila heyo kawalongela, “Nolondigwa niupete Usenga Unogile wa Undewa wa Mulungu m'viwambo viyagwe, kwavija nhumigwa nhende vino.” ");
INSERT INTO zajp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kakala yowapetela wanhu Usenga Unogile wa Undewa wa Mulungu muna zing'anda za nhambiko muisi yose ya Yudea. ");
INSERT INTO zajp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Zua dimwe Yesu kakala yemile hamgwazo wa Idilamba da Genesaleti. Wanhu wakala wokiibabanika wokwenhuka behi na heyo kutegeleza mbuli za Mulungu. ");
INSERT INTO zajp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kazona ngalawa mbili mulugigo lwa idilamba, zikigwe haja na waloa somba, wakalile wosuluza nhando zao. ");
INSERT INTO zajp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu kengila mngalawa imwe ikalile ya Simoni, kamulongela Simoni yaikwenhuse hamwande, hatalitali na ulugigo lwa idilamba. Yesu kakala mngalawa yowafundiza wanhu bwando. ");
INSERT INTO zajp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Viyeshile kulonga kamulongela Simoni, “Kwenhusa ingalawa hamwande hana ididindi da idilamba, na gweye na wayago tandeni nhando zenu muloe somba.” ");
INSERT INTO zajp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni kamulongela, “Mndewa, tugonelela tuloa somba hatupatile kinhu, ila kwavija gweye kulonga, nozitanda nhando.” ");
INSERT INTO zajp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Viwazitandile izinhando, wonza somba bwando, na nhando zao zisonga kukanhika. ");
INSERT INTO zajp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wawakema wayao wakalile mngalawa iyagwe weze kuwataza. Weza wamemeza somba ngalawa zose mbili, avo ngalawa zikala mmabehi kudidimila mmazi. ");
INSERT INTO zajp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petulo viyagonile gaja, kafugama mavindi haulongozi wa Yesu, yolonga, “Mndewa, sambiung'hwenhukile kwavija nie nna vilozo!” ");
INSERT INTO zajp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni na wayage wose wakanganya avija viwonzile somba bwando kamba vija. ");
INSERT INTO zajp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yakobo na Yohana wanage Zebedayo, wakalile waloa somba wayage Simoni, vivija wakanganya. Yesu kamulongela Simoni, “Sambiudumbe, kusongela lelo kowa muloa wanhu.” ");
INSERT INTO zajp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wazikwekwesa zingalawa wazika mumgwazo wa idilamba, waleka gose wamkweleleza Yesu. ");
INSERT INTO zajp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu viyakalile mdiwambo dimwe da hiko, kaiting'hana na mbigalo imwe yakalile na dikulu lukuli lugima. Viyamonile Yesu, kafugama mavindi, kamulongela mkuiyalala, “Mndewa, uhalonda, kodaha kunihonya.” ");
INSERT INTO zajp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu kagolosa mkono wake kamkwasa yolonga, “Nolonda, hona!” Kipigiti kikija kahona utamu wa dikulu. ");
INSERT INTO zajp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Abaho, Yesu kamulagiza yolonga, “Sambiumulongele munhu yoyose, ila genda dimwe kwa dimwe ha mkulu wa nhambiko yakulole goya, abaho, ukalave nhosa kamba Musa vayalagize, giladi iwe usindila mwa wanhu wose kamba kuhona.” ");
INSERT INTO zajp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ila mbuli za Yesu zibanza kwenela muisi yose, wanhu bwando weza kumtegeleza na kuhonyigwa vitamu vao. ");
INSERT INTO zajp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ila Yesu mianza bwando kakala yonyelenhuka yochola hanhu halibule wanhu kutambika. ");
INSERT INTO zajp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Zua dimwe Yesu kakala yofundiza. Mafalisayo na wafundiza Malagizo ga Musa, walawile m'viwambo vose va Galilaya, Yudea na kulawa Yelusalemu, wakala baho. Mhiko za Mndewa zikala na heyo, avo kawahonya watamu. ");
INSERT INTO zajp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Baho weza wanhu wampapile munhu yaholole mulusazi, wageza kumwingiza mng'anda wamwike haulongozi wa Yesu. ");
INSERT INTO zajp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Avija wanhu viwakalile wamemile hawadahile kumwingiza mng'anda. Avo wampapa, wamgala uchana mkiswili, wafumula usoti, wamuhumulusa hamoja na lusazi lwake, na kumwika hagatigati ya ididale da wanhu haulongozi wa Yesu. ");
INSERT INTO zajp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu viyonile avija viwakalile na nhamanila ng'hulu, kamulongela ija imunhu, “Mbwiga, vilozo vako vigeligwa kumgongo.” ");
INSERT INTO zajp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wafundiza Malagizo ga Musa na Mafalisayo wasonga kukiiuza, “Iyo yalihi yofukula? Mulungu yeiyeka yodaha kugela kumgongo vilozo va wanhu!” ");
INSERT INTO zajp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ila Yesu kazitanga ngelegeza zao, kawauza, “Habali mgelegeza mbuli kamba azo? ");
INSERT INTO zajp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Dilihi dibuhile ng'hani, kulonga, ‘Vilozo vako vigeligwa kumgongo,’ ama kulonga, ‘Ima wima utembele’? ");
INSERT INTO zajp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nolonda m'vitange kamba, nie, Mwana wa Munhu, nna udaho wa kuvigela kumgongo vilozo va wanhu muisi.” Abaho kamulongela ija imunhu yaholole, “Ima wima, papa lusazi lwako, uchole ukae yako.” ");
INSERT INTO zajp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Baho ija imunhu kema wima hameso gao wose, kasola lusazi lwake lwayakalile yaluwasile, kachola ukae yake kuno yomuyenzi Mulungu. ");
INSERT INTO zajp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wanhu wose wakanganya, kuno wona bwembwe, wamuyenzi Mulungu, wolonga, “Lelo tona mbuli za mkanganyo!” ");
INSERT INTO zajp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Viyeshile kutenda higo, Yesu kalawa hanze, kamona muwila kodi imwe yokemigwa Lawi, yakalile muna ing'anda yake ya kulihila kodi. Yesu kamulongela, “Ng'holeleza.” ");
INSERT INTO zajp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Na heyo kenuka, kaleka gose, kamkoleleza. ");
INSERT INTO zajp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Abaho, Lawi kamtendela lusona lukulu ng'hani Yesu mng'anda yake, na dale kulu da wawila kodi na wanhu wayagwe wakala woja na heyo. ");
INSERT INTO zajp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mafalisayo na wafundiza Malagizo ga Musa wakalile mdidale jao wawatwanganikila wanahina wa Yesu, wouza, “Habali moja na kung'wa na wawila kodi na watenda vilozo wayagwe?” ");
INSERT INTO zajp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu kedika kalonga, “Wanhu wagima hawamulonda mganga, ila waja wali watamu wawo womulonda. ");
INSERT INTO zajp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sizile kuwakema wanhu walibule vilozo, ila wanhu wali na vilozo waleke vilozo vao.” ");
INSERT INTO zajp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wanhu wamulongela Yesu, “Wanahina wa Yohana M'batiza wofunga mianza bwando na kutambika, na wanahina wa Mafalisayo wotenda vivo. Ila wanahina zako woja na kung'wa.” ");
INSERT INTO zajp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu kawalongela, “Mokwagiza modaha kuwatenda wambwiga za mulawilamhambe wafunge kipigiti mulawilamhambe yang'hali hamoja nawo? ");
INSERT INTO zajp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ila kipigiti chovika avija mulawilamhambe vondayasegezigwe hamwao, aho baho vondawafunge.” ");
INSERT INTO zajp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Vivija Yesu kawalongela hala dino. “Haduhu munhu yokanha kidanga cha kivalo cha sambi na kukigela mkivalo cha mwaka. Kamba yahatenda avo, kokidega ikivalo cha sambi, na acho ikidanga cha ikivalo cha sambi hakilumba mkivalo cha mwaka. ");
INSERT INTO zajp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Vivija wanhu hawagela divai ya sambi muna vibuyu va umwaka vitendigwe na kwembe, kwavija ija idivai ya sambi yovitula ivibuyu vitendigwe na kwembe, avo idivai yokwitika na vibuyu vitendigwe na kwembe vobanangika. ");
INSERT INTO zajp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Vilumbaga, divai ya sambi igeligwe muna vibuyu va sambi vitendigwe na kwembe. ");
INSERT INTO zajp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na haduhu munhu yolondaga divai ya sambi kuno yeshile kung'wa divai ya mwaka, mana kolonga, ‘Ya mwaka ibanza kunoga.’ ” ");
INSERT INTO zajp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yesu kakala yotembela muna imigunda ya ngano Mdizua dimwe da Mhumulo. Wanahina zake wasonga kufyola zisota za gamakungwi ga ngano, wagafigisa mmakono gao, ikwisha waja zinzele. ");
INSERT INTO zajp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mafalisayo wayagwe wamuuza, “Habali motenda gagomeswe kutendigwa Mdizua da Mhumulo?” ");
INSERT INTO zajp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu kawedika kawalongela, “Hamsomile kija chayatendile Daudi kipigiti heyo na wayage viwakalile na nzala? ");
INSERT INTO zajp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kengila mdihema da Mulungu, kaija imikate ilavigwe nhosa ha Mulungu, na iyagwe kawagwelela wayage. Vinhu vikalile vigomeswe Mmalagizo getu kudigwa na munhu yoyose ila wakulu wa nhambiko weiyeka.” ");
INSERT INTO zajp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu kamambukiza mkulonga, “Nie, Mwana wa Munhu, nene Mndewa wa Zua da Mhumulo.” ");
INSERT INTO zajp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Zua diyagwe da Mhumulo Yesu kengila mng'anda ya nhambiko na kufundiza. Kukala na munhu yaholole mkono wake wa ukulume. ");
INSERT INTO zajp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mafalisayo na wafundiza Malagizo ga Musa wakala wozahila kilamso cha kumtagusila Yesu, avo wamulola ng'hani wone kamba kohonya Mdizua da Mhumulo. ");
INSERT INTO zajp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesu kazitanga ngelegeza zao avo kamulongela ija imunhu, “Ima wima, wize hano haulongozi.” Ija imunhu kema wima, abaho, kachola haulongozi. ");
INSERT INTO zajp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Abaho, Yesu kawalongela, “Nowauza, Malagizo getu golonga tutende choni Mdizua da Mhumulo? Tutende ganogile ama gehile? Kumuhonya munhu ama kumkoma?” ");
INSERT INTO zajp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kawalola wanhu wose, abaho, kamulongela ija imunhu, “Golosa mkono wako.” Na heyo kaugolosa, na mkono wake ubwela goya. ");
INSERT INTO zajp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wona lusango wasonga kuiuza vija vondawamtende Yesu. ");
INSERT INTO zajp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Zua dimwe mkipigiti kija, Yesu kachola kukigongo kutambika, kagonelela yomtambikila Mulungu. ");
INSERT INTO zajp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Viivikile imitondo, kawakema wanahina zake na kawasagula longo dimwe na wabili, awo yawakemile watumigwa zake, ");
INSERT INTO zajp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni, yagweleligwe twaga da Petulo, na ndugu yake Endelea, na Yakobo na Yohana, na Filipo na Batolomayo, ");
INSERT INTO zajp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","na Matayo na Tomaso, na Yakobo mwanage Alufayo, na Simoni yakalile yokemigwa Mgombeleza Isi ya Islaeli, ");
INSERT INTO zajp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na Yuda mwanage Yakobo, na Yuda Isikalioti, yamuhonzile Yesu. ");
INSERT INTO zajp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu viyahumuluke kulawa hakigongo na watumigwa zake, kema hanhu hatambalale na wanahina zake bwando. Na wanhu bwando weza kulawa isi yose ya Yudea na kulawa Yelusalemu na kulawa viwambo vose va mhwani ya Tilo na Sidoni. ");
INSERT INTO zajp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Weza kumtegeleza na kuhonyigwa vitamu vao. Waja wakalile wogazigwa na vinyamkela vivija na hewo weza na wahonyigwa. ");
INSERT INTO zajp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wanhu wose walonda kumkwasa kwavija mhiko za uhonya zikala zimulawa na kuwahonya wanhu wose. ");
INSERT INTO zajp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu kawalola wanahina zake na kulonga, “Mmota mweye iwakumbulu wa gamali, kwavija Undewa wa Mulungu uli wenu! ");
INSERT INTO zajp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mmota mweye muli nzala sambi, kwavija kwiza mokwiguta! Mmota mweye mulila sambi, kwavija kwiza moseka! ");
INSERT INTO zajp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mmota mweye avija wanhu wahawehila, na kuwalema, na kuwaliga, na kuwabanangila matwaga genu sama ya nie, Mwana wa Munhu! ");
INSERT INTO zajp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Deng'heni mmazua higo na zumheni mkudeng'ha kwavija maliho genu makulu mwikiligwa kuulanga. Kwavija wahenga zao wawatendela wahokozi gano gowotenda. ");
INSERT INTO zajp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ila mojona mweye muli wagoli sambi, kwavija mwisha kubokela uhondo wenu. ");
INSERT INTO zajp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mojona mweye mwigute sambi, kwavija mochola na nzala. Mojona mweye mseka sambi, kwavija mokwiza kuiyalala na kulila. ");
INSERT INTO zajp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mojona, avija wanhu wose vondawawatogole, kwavija wahenga zao wakala wowatogola kamba avo wahokozi wa uvwizi. ");
INSERT INTO zajp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ila nowalongeleni mweye munitegeleza, wanogeleni wadumuka zenu, watendeleni ganogile awo wawehile. ");
INSERT INTO zajp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wamotezeni awo wowadukumiza, na watambikileni awo wowatendela gehile. ");
INSERT INTO zajp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Munhu yahakutoa mkanza dimwe, muhindusile na diyagwe, na munhu yahakuboka koti jako, muleke yasole na kanzu yako. ");
INSERT INTO zajp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Munhu yoyose yondayakupule kinhu mgwelele, na munhu yahasola kinhu chako, sambiumulongele yakubwezele. ");
INSERT INTO zajp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Watendeleni wanhu kamba vija vumulonda wanhu wawatendele mweye. ");
INSERT INTO zajp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kamba muhawanogela wanhu wowanogela mweye, maliho galihi gondam'bokele? Kwavija hata wali na vilozo na hewo wowanogela awo wawanogele! ");
INSERT INTO zajp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Muhawatendela ganogile awo wowatendela mweye ganogile, maliho galihi gondam'bokele? Kwavija wali na vilozo nawo wotenda vivo. ");
INSERT INTO zajp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Avo muhawakalizi mali genu ha awo mtamanila wodaha kuliha, maliho galihi gondam'bokele? Kwavija wali na vilozo wowakalizi wali na vilozo wayao wabwezeligwe kikija chawakalizigwe. ");
INSERT INTO zajp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Viha! Ila wanogeleni wadumuka zenu na watendeleni ganogile, wakalizini wanhu mali genu, sambimtamanile kubwezelwa na kinhu. Avo kwiza mogweleligwa maliho makulu, avo mowa wana wa Mulungu Mkulu Ng'hani, kwavija heyo kotenda ganogile mwa wanhu wabezi na wotenda gehile. ");
INSERT INTO zajp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Muwe na bazi kamba Tata wenu viyali na bazi. ");
INSERT INTO zajp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Sambimuwataguse wayagwe, na Mulungu hawatagusa mweye. Sambimuwadununze wayagwe, na Mulungu hawadununza mweye. Geleni kumgongo vilozo va wanhu wayagwe, na Mulungu kovigela kumgongo vilozo venu. ");
INSERT INTO zajp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wagweleleni wanhu vinhu, na Mulungu kowagwelela mweye. Mhima imemile, isindiligwe na kutigiswa na kwitika iyo yondamgweleligwe m'vipepelo venu. Kwavija mhima yondamuwapimile wayagwe iyo mhima yondampimilwe mweye.” ");
INSERT INTO zajp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Avo Yesu kawalongela hala dino, “Kimbugumbugu hadaha kumulongoza kimbugumbugu miyage, kamba yahatenda avo, wose wabili wogwila mdikolongo. ");
INSERT INTO zajp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mwanahina hamuhuma mkulufunzi wake, ila mwanahina yeheshiliza kufundizigwa kowa kamba mkulufunzi wake. ");
INSERT INTO zajp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Habali ukilola kikupi msiso da ndugu yako, na huchona kibanzi kili msiso jako mwenyego? ");
INSERT INTO zajp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kodahaze kumulongela ndugu yako, ‘Ndugu yangu, beta nikilave kikupi mdisiso jako,’ kuno hudaha hata kuchona kibanzi kili msiso jako mwenyego? Kidelenya gweye! Tanhu kilave ikibanzi kili msiso jako mwenyego, abaho, kodaha kulola goya kukilava kikupi kili mdisiso da ndugu yako. ");
INSERT INTO zajp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“M'biki unogile haulela mujo wihile, vivija m'biki wihile haulela mujo unogile. ");
INSERT INTO zajp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kila m'biki wotambulwa sama ya mujo wake uulela. Hudaha kubawa tini muna imizomola, ama zabibu muna zimbigili. ");
INSERT INTO zajp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Munhu yanogile kolava ganogile kulawa mngama ya vinhu vinogile vili mmoyo wake. Munhu yehile kolava gehile kulawa mngama ya vinhu vihile. Kwavija mulomo wolonga kimemile mmoyo. ");
INSERT INTO zajp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Habali mong'hema, ‘Mndewa, Mndewa,’ abaho, hamtenda gaja ganiwalongela? ");
INSERT INTO zajp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kila munhu yokwiza kumwangu na kutegeleza mbuli zangu na kuzitogola, nowalagusila kilihi kilingile na heyo. ");
INSERT INTO zajp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kalinga na munhu yozenga ng'anda, kahimba lukwambaza hasi ng'hani mbaka kavika dibwe, avo kazenga msingi mdibwe. Lwanda lutula na kugeza kuikulula ng'anda ija, ila haludahile kuitigisa kwavija izengigwa goya. ");
INSERT INTO zajp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ila munhu yoyose yohulika mbuli zangu na kuzileka baho, ayo kalinga na munhu yazengile ng'anda yake bila kuhimba ng'hani lukwambaza na kwika msingi. Mkipigiti kidodo lwanda lutula na kuikulula ng'anda ija, igwa mkipigiti kiguhi. Na igwa yake ikala ihile ng'hani.” ");
INSERT INTO zajp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu viyeshile kulonga mbuli zino zose mwa wanhu, kachola kukiwambo cha Kapenaumu. ");
INSERT INTO zajp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mkulu wa asikali mia wa Loma kakala na nyakadala yakalile yamnogele ng'hani, ija inyakadala kakala mtamu ng'hani behi na kudanganhika. ");
INSERT INTO zajp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ija imkulu wa iwaasikali mia wa Loma viyahulike singilimo za Yesu, kawatuma wakulu wa Wayahudi wakamulongele yeze yamuhonye nyakadala wake. ");
INSERT INTO zajp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Viwavikile ha Yesu, wamuyalalila, wolonga, “Munhu ino kalumba kutendeligwa mbuli ino, ");
INSERT INTO zajp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kwavija kawanogela wanhu zetu, na heyo iyo yatuzengele ng'anda yetu ya nhambiko.” ");
INSERT INTO zajp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Avo Yesu kachola na hewo, viwavikile behi na ing'anda, ija imkulu wa iwaasikali mia wa Loma kawalagiza wambwiga zake wamulongele Yesu vino, “Mndewa, sambiugaye, nie silumbile gweye wize wingile mng'anda yangu, ");
INSERT INTO zajp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","kileka nivigesile kamba silumbile kwiza hamwako nene mwenyego, ila longa mbuli! Na nyakadala wangu kohona. ");
INSERT INTO zajp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nie vivija na munhu nikigwe hasi ya udaho wa wakulu zangu wa uchana yangu, na nna asikali hasi yangu. Nihamulongela ino, ‘Genda!’ kochola, nihamulongela ija, ‘Izo!’ kokwiza, na nihamulongela nyakadala wangu, ‘Tenda vino!’ kotenda.” ");
INSERT INTO zajp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu viyahulike gano, kamkanganya munhu ija, kahinduka kuchugu na kudilongela dale da wanhu dikalile dimsondolela, “Nowalongela, sinakona nhamanila ng'hulu kamba ino, hata mwa wanhu wa Islaeli!” ");
INSERT INTO zajp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Waja watumigwe wabwela kung'anda ya ija imkulu, wam'vika nyakadala wake kahona. ");
INSERT INTO zajp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mkipigiti kiguhi Yesu kachola hakiwambo kikemigwa Naini, kailongoza na wanahina zake na dale kulu da wanhu. ");
INSERT INTO zajp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Viwavikile halwivi lwa ikiwambo, wanhu wakalile wapapile munhu yadanganhike wakala wolawa hanze ya ikiwambo. Mmhale yakalile yaleligwe yeiyeka na mtwanzi imwe yakalile kizuka, na dale kulu da wanhu kulawa mkiwambo dikala hamoja na ija imtwanzi. ");
INSERT INTO zajp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mndewa Yesu viyamuwene, kamonela bazi, kamulongela, “Sambiulile.” ");
INSERT INTO zajp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Abaho, kachola haulongozi na kulukwasa ulusazi, avo wanhu waupapile wema. Yesu kalonga, “Mmhale, nokulongela, lamuka!” ");
INSERT INTO zajp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ija immhale yadanganhike kenuka, kakala ukala, kasonga kulonga. Yesu kamgwelela mamaake. ");
INSERT INTO zajp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wanhu wose wona bwembwe wamuyenzi Mulungu, walonga, “Muhokozi mkulu koneka hamwetu, Mulungu keza kuwakombola wanhu zake.” ");
INSERT INTO zajp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mbuli zino za Yesu zenela muisi yose ya Yudea na isi za mmambwegambwega. ");
INSERT INTO zajp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wanahina wa Yohana viwamulongele mbuli zino zose, kawakema wabili mmwanza wao, ");
INSERT INTO zajp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na kuwalagiza wachole ha Mndewa wakamuuze vino, “Yohana kalonga, gweye iyo mkombola yondayeze? Ama tumtamanile iyagwe?” ");
INSERT INTO zajp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wanhu waja viwavikile ha Yesu, walonga, “Yohana M'batiza katulagiza yolonga tukuuze, ‘Gweye iyo yondayeze, ama tumtamanile iyagwe?’ ” ");
INSERT INTO zajp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kipigiti kikija Yesu kawahonya wanhu bwando wakalile na vitamu na utamu, na awo wakalile na vinyamkela, na kuwatenda vimbugumbugu bwando wadahe kulola. ");
INSERT INTO zajp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kawalongela waja wasenga wa Yohana, “Gendeni mkamulongele Yohana gaja gamonile na kugahulika, vimbugumbugu wolola, mbetembete wotembela, wali na dikulu wohonyigwa, vinziwi wohulika, wadanganhike wowa wagima kabili, na Usenga Unogile wopetigwa mwa wakumbulu. ");
INSERT INTO zajp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wamota wanhu awo walibule ving'hwaso na sang'hano zangu.” ");
INSERT INTO zajp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wasenga wa Yohana viwacholile, Yesu kasonga kumulonga Yohana haulongozi wa dale da wanhu, yolonga, “Vumcholile ha Yohana kuluwala, mtamanila kona choni? Ludete lutigiswa na beho? ");
INSERT INTO zajp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mchola kulola choni? Munhu yavalile vivalo vinogile ng'hani? Wanhu wovala kamba avo na kukala vinogile wa mming'anda ya kindewa! ");
INSERT INTO zajp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nongeleni, mchola kulola choni? Muhokozi? Ona, ila nowalongela, yummonile kana ukulu kubanza muhokozi. ");
INSERT INTO zajp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yohana iyo munhu Nyandiko Zing'alile zimulonga, ‘Mulungu kalonga, nomulagiza msenga wangu yakulongole, yondayaitande nzila yako.’ ” ");
INSERT INTO zajp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu kongeza kulonga “Nowalongela, wanhu wose waleligwe na watwanzi, haduhu yali mkulu kum'banza Yohana. Ila yali mdodo ng'hani muna Uundewa wa Mulungu iyo mkulu kum'banza Yohana.” ");
INSERT INTO zajp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wanhu wose, hata wawila kodi, viwazihulike mbuli za Yesu, watogola kamba nzila ya Mulungu igoloka, kwavija wakala wabatizigwe na Yohana. ");
INSERT INTO zajp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ila Mafalisayo na wafundiza Malagizo ga Musa wagalema gaja gayalondile kutenda Mulungu kumwao kwavija walema kubatizigwa na Yohana. ");
INSERT INTO zajp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu kagendelela kulonga, “Vino niwalinganyize na choni wanhu wa mazua gano? Walinga na wanhu walihi? ");
INSERT INTO zajp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Walinga na wana wakalile hadibugano da soko. Dale dimwe dowalongela dale diyagwe, ‘Tuwatoela ngoma ya lusona lwa zengele, ila mweye ham'vinile! Twimba vawembaga hauzisi, ila mweye hamulilile!’ ");
INSERT INTO zajp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohana M'batiza keza kafunga na hang'wile divai, na mulonga, ‘Kana kinyamkela!’ ");
INSERT INTO zajp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nie, Mwana wa Munhu, niza, noja na kung'wa, mulonga, ‘Loleni munhu ino, mmelo na mng'waji, mbwiga wa wawila kodi na wene vilozo wayagwe!’ ");
INSERT INTO zajp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kwa vovose vija ng'hungwe ya Mulungu yonekaga mmeso ga awo wose waitogole.” ");
INSERT INTO zajp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfalisayo imwe kamulonda Yesu yeze kuja na heyo mandia ga ikilo, avo Yesu kachola hang'anda ya ija Mfalisayo, kakala hasi yaje. ");
INSERT INTO zajp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mkiwambo kija kukala na mtwanzi imwe yakalile yotenda vilozo mazua gose. Kahulika Yesu kakala yoja mng'anda ya Mfalisayo, avo kagala nyhupa ya alabasta ikalile na mavuta ga kunung'hila. ");
INSERT INTO zajp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kema hachugu cha Yesu, behi na magulu gake, yolila na kumdodeza magulu gake na mahozi gake. Abaho, kamuhangusa magulu gake na mvili zake, kaganonela na kugetila mavuta ga kunung'hila. ");
INSERT INTO zajp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ija Imfalisayo yamgoneke viyonile gaja, kalonga munda kwa munda, “Kamba munhu ino yahawile muhokozi, yahamtangile mtwanzi ino yomkwasa yali munhu wa vilihi, yahavitangile vija voyokala ukazi wa vilozo.” ");
INSERT INTO zajp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu kamulongela ija Imfalisayo, “Simoni, nna mbuli nolonda kukulongela.” Kalonga “Ona, mkulufunzi, nongela.” ");
INSERT INTO zajp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu kasonga kulonga, “Kukala na wanhu wabili wowilwa hela na mkalizi hela imwe. Imwe kakala yowilwa hela zilinganye maliho ga milenge longo dimwe, na iyagwe kakala yowilwa hela zilinganye maliho ga mulenge umwe. ");
INSERT INTO zajp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wose wabili hawadahile kuliha, avo kawagela kumgongo wose wabili. Vino yalihi hana iwanhu wano wabili yondayamnogele heyo ng'hani?” ");
INSERT INTO zajp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni kamulongela, “Nokona ija imunhu yageligwe kumgongo hela bwando.” Yesu kalonga, “Kulonga goya.” ");
INSERT INTO zajp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Abaho, kamuhindukila ija imtwanzi, kamulongela Simoni, “Komona mtwanzi ino? Ningila mng'anda yako, hungwelele mazi ngele magulu gangu, ila heyo kagadodeza magulu gangu na mahozi gake na kugahangusa na mvili zake. ");
INSERT INTO zajp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Hunibokele mkuninonela, ila mtwanzi ino songela hanizile halekile kuganonela magulu gangu. ");
INSERT INTO zajp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gweye hunibakile mavuta mpala jangu, ila mtwanzi ino kagetila mavuta ga kunung'hila magulu gangu. ");
INSERT INTO zajp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Avo nokulongela, noge kulu diyalaguse mtwanzi ino dolagusa avija vilozo vake bwando vuvigeligwe kumgongo. Ila munhu yoyose yageligwe kumgongo hadodo kolagusa noge dodo.” ");
INSERT INTO zajp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Abaho, Yesu kamulongela ija mtwanzi, “Vilozo vako vigeligwa kumgongo.” ");
INSERT INTO zajp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wanhu wayagwe wakalile hameza wasonga kulonga hasihasi, “Iyo yalihi munhu ino, yogela kumgongo hata vilozo?” ");
INSERT INTO zajp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ila Yesu kamulongela ija imtwanzi, “Nhamanila yako ikukombola, genda mditindiwalo.” ");
INSERT INTO zajp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kipigiti kiguhi hamwande, Yesu kagendelela kuupeta Usenga Unogile wa Undewa wa Mulungu mmiwambo na m'viwambo. Wanahina zake longo dimwe na wabili wachola hamoja na heyo, ");
INSERT INTO zajp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","hamoja na watwanzi wakalile wahonyigwe vinyamkela na vitamu viyagwe, Maliamu yakalile yokemigwa munhu wa Magidala ayo wamulavile vinyamkela saba, ");
INSERT INTO zajp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoana, mwehe wa Kuza yakalile mkulu wa ng'anda ya Helode Antipa, Suzana, na watwanzi wayagwe bwando wasolile vinhu vao na kumgwaa Yesu na wanahina zake. ");
INSERT INTO zajp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wanhu wakala wogendelela kwiza ha Yesu kulawa m'viwambo vose, na viwamemile, Yesu kawalongela hala dino. ");
INSERT INTO zajp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mulimi kachola kuhanda mbeyu. Viyakalile yozihanda, ziyagwe zilagalila mnzila, wanhu wazibojaga na ndege weza wazija. ");
INSERT INTO zajp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ziyagwe zigwila muisi ili na mabwe, avo viisongile kukula inyala, kwavija kukala haduhu mnyefu muisi. ");
INSERT INTO zajp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ziyagwe zigwila mmizomola, imizomola ikula hamoja na umche na kuuzingiliza. ");
INSERT INTO zajp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na mbeyu ziyagwe zigwila haulongo unogile, zikula na zilela masuke gali na nzele mia kila dimwe.” Yesu kamambukiza mkwinula dizwi, yolonga, “Yali na magwiti na yahulike.” ");
INSERT INTO zajp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wanahina zake wamuuza Yesu nhegulo ya hala dino. ");
INSERT INTO zajp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Na heyo kawalongela, “Mweye mgweleligwa mhome ya kuzitanga nyong'onyo za Undewa wa Mulungu, ila wayagwe wolongelwa muna gamahala, giladi walole ila sambiwone, na wategeleze ila sambiwahulike.” ");
INSERT INTO zajp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ino iyo nhegulo ya hala dino. Zimbeyu zizo mbuli ya Mulungu. ");
INSERT INTO zajp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mbeyu zigwile mnzila zizo wanhu wahulike imbuli ya Mulungu, abaho, Mwenembago keza kaisegeza kulawa mmioyo yao, giladi sambiwaitogole, abaho, wakomboligwe. ");
INSERT INTO zajp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mbeyu zigwile muisi ili na mabwe zizo wanhu wahulike mbuli ya Mulungu na kuibokela mkudeng'ha. Ila hawakalile na mizizi, woitogola mkipigiti kiguhi, wahabitilwa na kipigiti kidala, wobweleganya kuchugu. ");
INSERT INTO zajp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mbeyu zigwile mmizomola zizo wanhu wahulike mbuli ya Mulungu, ila viwakalile wogendelela kuitogola, mholemhole wazingilizwa na bwembwe da ugima, usu da kuwa na mali bwando, na usu da kuwa na vinhu vinogile, avo mujo wao hawipa. ");
INSERT INTO zajp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mbeyu zija zigwile haulongo unogile zizo wanhu wahulike mbuli ya Mulungu waika mmioyo, avo waitogola, wazaganya, hakimambukizo walela mujo unogile. ");
INSERT INTO zajp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Haduhu munhu yobwinha kiwenge, abaho, yakigubike na kiteleko ama yakike haluvungu. Ila kokika uchana hakingolobweda avo wanhu wehengila mng'anda wone mulangaza. ");
INSERT INTO zajp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Kwavija haduhu kinhu chochose kifisigwe chondakileke kuvumbulwa na kwikigwa hakimwagaia, na haduhu kinhu chochose kigubikwe chondakileke kugubulwa na kwikigwa hamulangaza. ");
INSERT INTO zajp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Avo teganyeni vija vumtegeleza, kwavija awo wali na kinhu wogweleligwa na viyagwe, ila awo walibule kinhu, na vidodo vija vowogesa wanavo wobokonywa.” ");
INSERT INTO zajp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mamaake Yesu na wandugu zake wamwizila, ila hawadahile kumkwenhukila avija wanhu viwakalile bwando. ");
INSERT INTO zajp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Munhu imwe kamulongela, “Mamaako na wandugu zako wahanze wonda wakone.” ");
INSERT INTO zajp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ila Yesu kawalongela, “Mamaangu na ndugu zangu iwo wano wotegeleza mbuli ya Mulungu na kuitenda.” ");
INSERT INTO zajp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Zua dimwe Yesu kawalongela wanahina zake, “Natuloke mwambu wa ikabili wa idilamba.” Avo wengila mngalawa wasonga kuloka. ");
INSERT INTO zajp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Viwakalile woloka, Yesu kawasa utulo. Wedukila kukuzumbi dikwiza mdilamba, na ingalawa isonga kumema mazi, avo wose wakala mmwangalo. ");
INSERT INTO zajp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wanahina wachola ha Yesu wamulamusa, wolonga, “Mndewa, Mndewa! Todanganhika!” Yesu kalamuka kadikomhokela dikukuzumbi na umnyukwamnyukwa wa igamazi, vose vihola, hakala hapozike. ");
INSERT INTO zajp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Abaho, kawalongela wanahina zake, “Nhamanila yenu ili kwahi?” Wakanganya ng'hani, kuno wona bwembwe, wakiilongela, “Ino munhu waki? Kodikomhokela beho na igamawimbi, na vose vomtegeleza!” ");
INSERT INTO zajp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu na wanahina zake wagendelela kuloka, wavika mhwani ya isi ya Gelasi ili mwambu wa ikabili wa Idilamba da Galilaya. ");
INSERT INTO zajp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu viyahumuluke muingalawa, munhu imwe wa kiwambo kija yakalile na vinyamkela kamwizila. Mazua bwando munhu ija kakala yotembela bila mvaza na kakala hakala muna ing'anda, ila kakala yokala muna zimhango ziwazikilaga wanhu. ");
INSERT INTO zajp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Viyamuwene Yesu, kaguta lwangi, kafugama mavindi hamagulu ga Yesu, kenula dizwi yolonga, “Yesu, Mwana wa Mulungu Mkulu Ng'hani, konilonda choni? Nokuyalalila, sambiungaze!” ");
INSERT INTO zajp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kalonga vino kwavija Yesu kamkomhokela ikinyamkela yamulawe. Mianza bwando kakala yovagaligwa na ikinyamkela, hata kamba kakala yafungigwe makono na magulu na minyolo na kwimilizwa, ila kaikanha iminyolo na kakala yowingigwa na ikinyamkela muluwala. ");
INSERT INTO zajp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu kamuuza, “Twaga jako dijo dilihi?” Kedika kalonga, “Twaga jangu ‘Dale,’ ” kwavija kakala yavagaligwe na vinyamkela bwando. ");
INSERT INTO zajp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Vinyamkela wamuyalalila Yesu sambiyawagale mdikolongo dilibule nziga. ");
INSERT INTO zajp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kukala na dale kulu da mitumbi behi na hewo, wakala woja hakigongo. Avo vinyamkela wamuyalalila Yesu yawaleke wachole wakaingile ija imitumbi, Yesu kawaleka wachole kuiingila. ");
INSERT INTO zajp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Vinyamkela viwamulawile ija imunhu, waiingila ija imitumbi, na dale jose dihumuluka kubonde mdigema, dingila mdilamba na kufa mazi. ");
INSERT INTO zajp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wanhu wakalile woichunga imitumbi wagona gaja galawilile, avo wakimbila na wabwililisa mbuli zija mkiwambo na mmigunda. ");
INSERT INTO zajp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wanhu wachola kulola gaja galawilile, na viwavikile ha Yesu, wam'vika ija imunhu yalavigwe vinyamkela kakala hamagulu ga Yesu, kavala vivalo, yali na nzonzi zake. Wanhu wose wona bwembwe. ");
INSERT INTO zajp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Waja wagonile gaja wawalongela wanhu avija munhu ija vayahonyigwe. ");
INSERT INTO zajp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Abaho, wanhu wose wa isi ya Gelasi wamulongela Yesu yasegele hamwao, kwavija wadumba ng'hani. Avo kengila mngalawa kasegela. ");
INSERT INTO zajp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Munhu ija yalavigwe vinyamkela kamuyalalila Yesu yachole na heyo. Ila Yesu kamtuma, yolonga, ");
INSERT INTO zajp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bwela ukae yako ukapete gaja Mulungu gayakutendele.” Ija imunhu kabitabita kila hanhu mkiwambo, yolonga gaja Yesu gayamtendele. ");
INSERT INTO zajp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu viyabwelile mwambu wa ikabili wa idilamba, wanhu wam'bokela, kwavija wanhu wose wakala wom'beta. ");
INSERT INTO zajp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Abaho, keza munhu yokemigwa Yailo, kakala munhu mkulu muing'anda ya nhambiko. Kafugama mavindi haulongozi wa Yesu, kamuyalalila yachole kung'anda yake, ");
INSERT INTO zajp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kwavija mndele wake yavumbuke yeiyeka, yakalile wa ukulu wa milao longo dimwe na mibili, kakala mtamu, behi na kudanganhika. Yesu viyakalile mnzila, wanhu wammemela ng'ambu zose. ");
INSERT INTO zajp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mdidale dija da wanhu kukala na mtwanzi imwe yakalile na utamu wa kutumika mkipigiti cha milao longo dimwe na mibili, kasa vinhu vake vose ha mafundi, ila haduhu yadahile kumuhonya. ");
INSERT INTO zajp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kaibabanika mdidale da wanhu hachugu cha Yesu na kukwasa ulugigo lwa guo da Yesu, na bahaja kahona. ");
INSERT INTO zajp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu kauza, “Yalihi yang'hwasile?” Wanhu wose wabela, Petulo kalonga, “Mndewa, wanhu wamema woikunhizila kumwako.” ");
INSERT INTO zajp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ila Yesu kalonga, “Hana munhu kang'hwasa kwavija nokona mhiko zinilawa.” ");
INSERT INTO zajp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ija mtwanzi viyawene gayatendile gatangigwa, keza yogudema, kafugama mavindi haulongozi wa Yesu. Bahaja hameso ga wanhu wose, kamulongela kimtendile yamkwase na vija vayahonyigwe mkipigiti kiguhi. ");
INSERT INTO zajp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu kamulongela, “Mwanangu, nhamanila yako ikuhonya. Genda mditindiwalo.” ");
INSERT INTO zajp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu viyakalile yang'hali yolonga gano, keza munhu imwe kulawa kung'anda ya Yailo. Kamulongela Yailo, “Mndele wako kadanganhika, sambiumgaze Mkulufunzi.” ");
INSERT INTO zajp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu kahulika kamulongela Yailo, “Sambiudumbe, tamanila, na mndele wako kohona.” ");
INSERT INTO zajp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Viyavikile hang'anda ya Yailo, hamulondile munhu yoyose kwingila na heyo mng'anda, ila Petulo, Yohana, Yakobo, na tata na mama wa imndele. ");
INSERT INTO zajp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wanhu wose walila na kona giogio sama ya ija imndele, Yesu kawalongela, “Sambimulile, mwana mgima, kawasa tu!” ");
INSERT INTO zajp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wanhu wose wamseka, kwavija wavitanga kamba kakala yeshile kudanganhika. ");
INSERT INTO zajp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ila Yesu kamgoga mkono na kwinula dizwi yolonga, “Mwanangu, lamuka.” ");
INSERT INTO zajp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Loho yake ibwela, kipigiti kikija kalamuka, Yesu kalagiza wamgwelele kinhu yaje. ");
INSERT INTO zajp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tataake na mamaake wakanganya ng'hani, ila Yesu kawagong'ondeza sambiwamulongele munhu yoyose gaja galawilile. ");
INSERT INTO zajp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu kawakema watumigwa zake longo dimwe na wabili hamoja, kawagwelela mhiko na udaho wa kuwinga vinyamkela wose na kuhonya vitamu. ");
INSERT INTO zajp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Abaho, kawalagiza wachole kuupeta Undewa wa Mulungu na kuwahonya watamu. ");
INSERT INTO zajp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kawalongela, “Sambimsole kinhu chochose mmwanza wenu, fimbo ama mkoba ama mandia ama hela ama kanzu ya ikabili. ");
INSERT INTO zajp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ng'anda yoyose yondamwingile, kaleni baho mbaka vondamsegele hakiwambo hicho. ");
INSERT INTO zajp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Wanhu wahalema kuwabokela, segeleni hakiwambo kija, kung'unheni timbwisi dili mmagulu genu kamba usindila ulagusa hewo wenyego waulema Undewa wa Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Avo wasegela, wabita m'viwambo vose wopeta Usenga Unogile na kuhonya wanhu kila hanhu. ");
INSERT INTO zajp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Helode Antipa, mtawala wa Galilaya, kagahulika gose gakalile gotendeka. Avo kadungwadungwa ng'hani, kwavija wanhu wayagwe wakala wolonga, “Yohana M'batiza kazuka.” ");
INSERT INTO zajp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wayagwe walonga, “Eliya kalawilila,” na wayagwe walonga, “Imwe wa wahokozi wa umwaka kazuka.” ");
INSERT INTO zajp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Helode kalonga, “Yohana nimdumula pala jake, avo yalihi munhu ino inihulika mbuli zake?” Avo mazua gose kakala yozahila kumona Yesu. ");
INSERT INTO zajp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Watumigwa wa Kilisto viwabwelile, wamulongela Yesu vinhu vose vawatendile. Kawasola, wasegela wachola kukiwambo kikemigwa Betisaida. ");
INSERT INTO zajp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Dale da wanhu diitanga mbuli ija, wamsondolela. Kawabokela, kawalongela mbuli za Undewa wa Mulungu, na kawahonya waja walondigwe kuhonyigwa. ");
INSERT INTO zajp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Zua vidisongile kuhonga, wanahina longo dimwe na wabili wamwizila wolonga, “Walongele wanhu wachole kuviwambo na kumigunda ili behi wakazahile mandia na uwaso, kwavija hano hatuli twa muluwala.” ");
INSERT INTO zajp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ila Yesu kawalongela, “Wagweleleni mweye wenyego kinhu cha kuja.” Wamulongela, “Vitulinavo tweye mikate mitano na somba wabili. Kolonda tuchole kuwagulila mandia wanhu wano wose?” ");
INSERT INTO zajp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Haja wakala wanhu wambigalo kamba alufu tano vino. Yesu kawalongela wanahina zake, “Walongeleni wanhu wakale hasi mmadale ga wanhu malongo matanomatano.” ");
INSERT INTO zajp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wanahina watenda vija, na wanhu wose wakala hasi. ");
INSERT INTO zajp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu kasola imikate mitano na iwasomba wabili, kalola uchana kuulanga, kamgwaa hewela Mulungu, kavimogola kawagwelela wanahina zake wawagolele iwanhu. ");
INSERT INTO zajp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wanhu wose waja weguta, wanahina wadondola vidanga va vakuja visigale migelo longo dimwe na mibili. ");
INSERT INTO zajp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Zua dimwe Yesu kakala yotambika yeiyeka. Wanahina zake wakala hamoja na heyo, kawauza, “Wanhu wolonga nie iyo yalihi?” ");
INSERT INTO zajp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wamulongela, “Wayagwe wolonga gweye iyo Yohana M'batiza, wayagwe wolonga gweye iyo Eliya, na wayagwe wolonga gweye iyo imwe wa wahokozi wa umwaka kuzuka kabili.” ");
INSERT INTO zajp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesu kawauza, “Na mweye, molonga nie iyo yalihi?” Petulo kalonga, “Gweye iyo Kilisto Mkombola ulawile ha Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Abaho, Yesu kawazuma na kuwagomesa ng'hani sambiwamulongele munhu yoyose mbuli ino. ");
INSERT INTO zajp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Vivija kawalongela, “Nie, Mwana wa Munhu, nolondigwa nigaye ng'hani, na nilemigwe na wakulu hamoja na wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa. Nokomigwa, ila mdizua da ikadatu nozuka, nowa mgima kabili.” ");
INSERT INTO zajp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Avo kawalongela wanhu wose, “Kamba munhu yahalonda kuwa mwanahina wangu, yaibele mwenyego, yaidikwe msalaba wake mazua gose, yanikoleleze. ");
INSERT INTO zajp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Munhu yoyose yahalonda kuukombola ugima wake, kowagiza, na munhu yoyose yowagiza ugima wake sama yangu nie, koukombola. ");
INSERT INTO zajp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wanhu kamba wahapata vinhu vose va muisi na hewo wenyego wopotela ama wokwangama, kuna unozi waki? Nokona haduhu! ");
INSERT INTO zajp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kwavija munhu yoyose yahanyonela kinyala nie na mafundo gangu, nie, Mwana wa Munhu, nomonela kinyala heyo vondanize muyenzi yangu na muyenzi ya Tata na muyenzi ya wasenga wa Mulungu wang'alile wa kuulanga. ");
INSERT INTO zajp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nowalongeleni ikweli, hana wanhu wayagwe hano hawadanganhika mbaka wawone Undewa wa Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mazua manane songela hayalongile mbuli zija, Yesu kawasola Petulo, Yohana, na Yakobo wachola kukigongo kutambika. ");
INSERT INTO zajp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesu viyakalile yotambika, kihanga chake kigaluka, na vivalo vake vigaluka vizelu nang'hanang'ha. ");
INSERT INTO zajp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bahaja wanhu wabili wakala wolongelela na heyo. Wakala Musa na Eliya. ");
INSERT INTO zajp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Wakalile woneke muyenzi ya kuulanga na walongelela na Yesu avija ndagizi za Mulungu vondazivikile hima na vija vondayadanganhikile Yelusalemu. ");
INSERT INTO zajp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petulo na wayage wakala wawasile, ila viwalamuke, wayona yenzi ya Yesu na wanhu wabili wakalile wemile na heyo. ");
INSERT INTO zajp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Waja iwanhu wabili viwakalile wosonga kuchola, Petulo kamulongela Yesu, “Mndewa, vinoga tweye tukale hano, tuzenge vizewe vidatu, kimwe chako, kimwe cha Musa, na kimwe cha Eliya.” Kalonga avo kuno hakitangile choyolonga. ");
INSERT INTO zajp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petulo viyakalile hanamambukiza kulonga, wingu dilawilila diwagubika, wanahina zake wadumba ng'hani avija diwingu vidiwagubike. ");
INSERT INTO zajp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dihulikwa dizwi kulawa mdiwingu, dilonga, “Ino iyo Mwanangu inimsagule, mtegelezeni heyo!” ");
INSERT INTO zajp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Dizwi dija vudipozike, kasigala Yesu yeiyeka. Wanahina zake wanyamala tulu mmbuli zose zino na hawamulongele munhu yoyose mmazua gaja gose mbuli ziwonile. ");
INSERT INTO zajp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Imitondo iyagwe Yesu na waja wanahina zake wadatu wahumuluka hakigongo, na dale da wanhu dimwizila Yesu. ");
INSERT INTO zajp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Munhu imwe kulawa muja mdidale da wanhu kenula dizwi yolonga, “Mkulufunzi, chonde, chonde, mulole mmhale wangu, iyo mwanangu yeiyeka! ");
INSERT INTO zajp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kinyamkela kam'vagalaga mkumsinhukiza na kumtenda yatoe nyangi chaka, komgela kisango baho holovu domulawa mmulomo, kogendelela kumulumiza, hamulekesa hima. ");
INSERT INTO zajp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Niwayalalila wanahina zako wamuwinge ikinyamkela, ila hawadahile.” ");
INSERT INTO zajp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu kawalongela, “Mweye wanhu mpotele, mulibule nhamanila, nokala na mweye mbaka zua jaki? Nowapapa mbaka kwahi?” Abaho, kamulongela ija imunhu, “Mgale hano mwanago.” ");
INSERT INTO zajp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ija mmhale vayakalile yomkwenhukila Yesu, kinyamkela kam'bwanha hasi na kumgela kisango. Yesu kamkomhokela ija kinyamkela, kamuhonya ija immhale, kam'bweza ha tataake. ");
INSERT INTO zajp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wanhu wose wakanganya mhiko ng'hulu za Mulungu. Wanhu vawakalile wogendelela kukanganya mbuli zose zayatendile Yesu, kawalongela wanahina zake, ");
INSERT INTO zajp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tegelezeni goya kinhu kinilonda kuwalongela! Nie, Mwana wa Munhu, nochola kugeligwa mmakono ga wanhu.” ");
INSERT INTO zajp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ila wanahina zake hawaitangile nhegulo ya mbuli ija. Mbuli ija ikala ifisigwe kumwao, avo hawaitangile nhegulo yake, na wadumba kumuuza. ");
INSERT INTO zajp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wanahina wa Yesu wasonga kuibamilila wolonga yalihi yondayawe mkulu kubanza wose. ");
INSERT INTO zajp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu kazitanga ngelegeza zao, avo kamsola mwana mdodo kamwika behi na heyo, ");
INSERT INTO zajp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","kawalongela, “Munhu yoyose yondayam'bokele mwana ino sama ya twaga jangu, konibokela nie, na munhu yoyose yondayanibokele nie, kom'bokela ayo yanhumile nie. Avo yali mdodo kubanza mweye mose iyo mkulu kubanza wose.” ");
INSERT INTO zajp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana kalonga, “Mndewa, tumona munhu yowinga vinyamkela mtwaga jako, tumgomesa, kwavija hali hamoja na tweye.” ");
INSERT INTO zajp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu kawalongela, “Sambimumgomese, kwavija munhu yoyose yoleka kuibamilila namwe, ka hamoja namwe.” ");
INSERT INTO zajp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kipigiti chake vikikwenhuke cha kusoligwa uchana kuulanga, Yesu kalamula yagoge nzila yachole Yelusalemu. ");
INSERT INTO zajp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kawagala wasenga wamulongole, avo wengila mkiwambo kimwe cha Samalia kumsasalila. ");
INSERT INTO zajp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ila wanhu wa haja hawam'bokele, kwavija kakala mnzila yochola Yelusalemu. ");
INSERT INTO zajp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wanahina zake wokemigwa Yakobo na Yohana viwawene vino, wamuuza, “Mndewa, kolonda tweye tuukeme moto uhumuluke kulawa kuulanga wize kuwalukuza kabisa?” ");
INSERT INTO zajp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu kawahindukila na kuwakomhokela yolonga, “Hamuimanyile loho imulinayo, kwavija nie, Mwana wa Munhu, sizile kubananga ugima wa wanhu, ila kuukombola.” ");
INSERT INTO zajp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Abaho, Yesu na wanahina zake wachola hakiwambo kiyagwe. ");
INSERT INTO zajp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Viwakalile wochola mnzila, munhu imwe kamulongela Yesu, “Nokusondolela kokose kondauchole.” ");
INSERT INTO zajp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu kamulongela, “Mbweha wana mhango, ndege wana mvulu, ila nie, Mwana wa Munhu, nabule hanhu ha kutambalika pala jangu.” ");
INSERT INTO zajp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu kamulongela munhu iyagwe, “Nisondolele.” Ija munhu kamwidika, “Mndewa, nileke tanhu nyhole hazike tataangu.” ");
INSERT INTO zajp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu kamulongela, “Waleke wanhu wadanganhike wazike wadanganhike wayao. Ila gweye genda ukaupete Undewa wa Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Munhu iyagwe kamulongela, “Mndewa, nokusondolela, ila tanhu beta nyhole nikalage wanhu wa hakae yangu.” ");
INSERT INTO zajp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ila Yesu kamwidika, “Munhu yoyose yosonga kulima, abaho, kolola kuchugu, halumba Muundewa wa Mulungu.” ");
INSERT INTO zajp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Abaho, Mndewa kawasagula wanhu wayagwe malongo saba na wabili, kawatuma wabiliwabili, wamulongole wachole m'viwambo vose na kila hanhu hayalondile kuchola mwenyego. ");
INSERT INTO zajp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kawalongela, “Va kuhuna vimema, ila wahunaji wadodo. Avo mpuleni mwene mgunda yawagale wahunaji wahune vakuja vake. ");
INSERT INTO zajp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Gendeni! Nowalagiza mweye kamba wana ng'hondolo mdidale da mbwizi. ");
INSERT INTO zajp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sambimsole mkwiji ama mkoba ama ng'hwabasa, sambimmulamse munhu yoyose mnzila. ");
INSERT INTO zajp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Muhengila mng'anda yoyose, longeni, ‘Tindiwalo dingile mng'anda ino.’ ");
INSERT INTO zajp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kamba munhu yokala mng'anda ija yahawa mnogela tindiwalo, tindiwalo dosigala na heyo, na kamba sio, tindiwalo jenu dowabwelela. ");
INSERT INTO zajp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kaleni mng'anda hiyo muja na kung'wa chochose chondamgweleligwe, kwavija wasang'hana wolondigwa wagweleligwe kitumetume chao. Sambimuhamehame mulawa ng'anda ino mwingila ng'anda iyagwe. ");
INSERT INTO zajp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Muhengila mkiwambo chochose na wanhu wa kiwambo kija wahawabokela, dieni chochose chondawawagweleleni. ");
INSERT INTO zajp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wahonyeni watamu wa mkiwambo kija na muwalongele wanhu wa kiwambo kija, ‘Undewa wa Mulungu uwakwenhukila.’ ");
INSERT INTO zajp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ila muhengila mkiwambo, na wanhu wa kiwambo kija hawawabokele, laweni gendeni mnzila za mkiwambo kija mulonge, ");
INSERT INTO zajp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Timbwisi da kiwambo chenu dinanahile mmagulu getu todihangusa diwabwelele. Ila vimanyeni Undewa wa Mulungu uwakwenhukila.’ ");
INSERT INTO zajp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nowalongela, mdizua da inhaguso vobuha wanhu wa kiwambo cha Sodoma kwazaganya nhaguso yake kubanza wanhu wa kiwambo kij