﻿USE sofia;
DROP TABLE IF EXISTS sofia.zaj_vpl;
CREATE TABLE zaj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zaj_vpl WRITE;
INSERT INTO zaj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Uno uwo msululu wa wahenga wa Yesu Kilisto, mwana wa Daudi, mwana wa Ablaham. ");
INSERT INTO zaj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ablaham kamulela Isaka, Isaka kamulela Yakobo, Yakobo kamulela Yuda na ndugu zake. ");
INSERT INTO zaj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda kamulela Pelesi na Zela, mamaao kakala Tamali, Pelesi kamulela Heziloni, Heziloni kamulela Alamu, ");
INSERT INTO zaj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamu kamulela Aminadabu, Aminadabu kamulela Nashoni, Nashoni kamulela Salimoni, ");
INSERT INTO zaj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni kamulela Boazi, mamaake kakala Lahabu, Boazi kamulela Obedi, mamaake kakala Lusi, Obedi kamulela Yese, ");
INSERT INTO zaj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese kamulela Mndewa Daudi. Daudi kamulela Selemani na mtwanzi yakalile mwehe wa Ulia, ");
INSERT INTO zaj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Selemani kamulela Lehoboamu, Lehoboamu kamulela Abiya, Abiya kamulela Asafu, ");
INSERT INTO zaj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asafu kamulela Yehoshafati, Yehoshafati kamulela Yolamu, Yolamu kamulela Uzia, ");
INSERT INTO zaj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia kamulela Yotamu, Yotamu kamulela Ahazi, Ahazi kamulela Hezekia, ");
INSERT INTO zaj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia kamulela Manase, Manase kamulela Amoni, Amoni kamulela Yosia, ");
INSERT INTO zaj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia kamulela Yekonia na ndugu zake, kipigiti kija viwahamizigwe kuchola Babeli. ");
INSERT INTO zaj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kulawa kipigiti cha kuhamizigwa kuchola Babeli, Yekonia kamulela Shelitieli, Shelitieli kamulela Zelubabeli, ");
INSERT INTO zaj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabeli kamulela Abiudi, Abiudi kamulela Eliakimu, Eliakimu kamulela Azoli, ");
INSERT INTO zaj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoli kamulela Sadoki, Sadoki kamulela Akimu, Akimu kamulela Eliudi, ");
INSERT INTO zaj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi kamulela Eliazali, Eliazali kamulela Matani, Matani kamulela Yakobo, ");
INSERT INTO zaj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo kamulela Usufu, yakalile mbigalo wa Maliamu mamaake Yesu yakemigwe Kilisto. ");
INSERT INTO zaj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Avo kukala na milelo longo dimwe na mine kulawa Ablaham mbaka Daudi, na milelo longo dimwe na mine kulawa Daudi mbaka kipigiti viwahamizigwe kuchola Babeli, na milelo longo dimwe na mine kulawa uhamizo wa kuchola Babeli mbaka mvumbuka ya Kilisto. ");
INSERT INTO zaj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Vino vivo mvumbuka ya Yesu Kilisto viikalile. Mamaake, yakemigwe Maliamu, kakala mkasano wa Usufu, ila viwakalile hawanakala hamoja, kaiyona kana inda mkubitila mhiko za Loho wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kwavija Usufu, mkasano wake, kakala munhu yalibule uzenzeleganye, na halondile kumgela kinyala hameso ga wanhu, avo kagelegeza kumuleka kinyele. ");
INSERT INTO zaj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ila viyakalile yogelegeza gano, msenga wa Mndewa wa kuulanga kamulawila muna inzozi na kulonga, “Usufu, Mwana wa Daudi, sambiudumbe kumsola Maliamu yawe mtwanzi wako. Kwavija kapata inda mkubitila mhiko za Loho wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kolela mwana mbigalo, na gweye komkema twaga jake Yesu, kwavija kowakombola wanhu zake kulawa m'vilozo vao.” ");
INSERT INTO zaj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gano gose galawilila giladi gavikile gaja gayalongile Mndewa kubitila muhokozi, ");
INSERT INTO zaj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mhambe kopata inda na kolela mwana mbigalo, na twaga jake kokemigwa Imanueli.” Nhegulo yake “Mulungu ka hamoja na tweye.” ");
INSERT INTO zaj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Usufu viyalamuke kulawa muutulo, katenda kamba msenga wa Mndewa wa kuulanga viyamulagize, avo kamsola mkasano wake Maliamu. ");
INSERT INTO zaj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ila hamkwenhukile mbaka viyamulelile mwana mbigalo. Na heyo kamkema twaga jake Yesu. ");
INSERT INTO zaj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu kavumbuka mkiwambo cha Betelehemu muisi ya Yudea, mkipigiti cha Mndewa Helode Mkulu. Na wanhu wali na ilimu ya nhondo kulawa haulawilo wa zua weza Yelusalemu, ");
INSERT INTO zaj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","wauza, “Kahalihi ayo yavumbuke giladi yawe mndewa wa Wayahudi? Kwavija tuyona nhondo yake haulawilo wa zua, avo twiza kumtambikila.” ");
INSERT INTO zaj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mndewa Helode viyahulike vino, kagaya ng'hani mmoyo, heyo hamoja na wanhu wose wa Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kawakema wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa, kawauza, “Halihi hondayaleligwe Kilisto?” ");
INSERT INTO zaj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wamwidika, “Mkiwambo cha Betelehemu muisi ya Yudea, kwavija vino vivo yandikigwe na muhokozi, ");
INSERT INTO zaj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Na gweye, Betelehemu, uli muisi ya Yuda, huli mdodo hagatigati ya watawala wa isi ya Yuda, kwavija kulawa kumwako kolawilila mtawala yondayawalongoze wanhu zangu wa Islaeli.’ ” ");
INSERT INTO zaj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Abaho, Helode kawakema kinyele waja iwanhu wali na ilimu ya nhondo wamulongele kipigiti kija inhondo viyoneke. ");
INSERT INTO zaj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kawatuma wachole Betelehemu, yolonga, “Gendeni mkaziuzagize goya mbuli za mwana hiyo, na muhamona mnongele, giladi na nie nichole kumtambikila.” ");
INSERT INTO zaj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Viwamambukize kumtegeleza mndewa, wachola, na ija inhondo iwakalile wayonile haulawilo wa dizua, iwalongola mbaka viimile hanhu hayakalile imwana. ");
INSERT INTO zaj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Viwaiwene inhondo, wadeng'helela ng'hani. ");
INSERT INTO zaj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Viwengile mng'anda, wamona imwana hamoja na mamaake Maliamu, wafugama mavindi na kumtambikila. Abaho, wafungula masanduku gao na kumgwelela nhunza za zahabu, ubane, na manemane. ");
INSERT INTO zaj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mulungu kawazuma mnzozi kamba sambiwambwelele Helode. Avo wabweleganya muisi yao mkubitila nzila iyagwe. ");
INSERT INTO zaj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Viwacholile, msenga wa Mndewa wa kuulanga kamulawila Usufu mnzozi kalonga, “Lamuka, msole imwana na mamaake mkimbilile Misili. Kaleni hiko mbaka vondanikulongele, kwavija Helode kokwiza kumzahila imwana giladi yamkome.” ");
INSERT INTO zaj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Avo Usufu kenuka, kamsola imwana na mamaake ikilo iija, kachola Misili, ");
INSERT INTO zaj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ako kuyakalile mbaka Helode viyadanganhike. Giladi kamba gavikile gaja galongigwe na Mndewa kubitila muhokozi, “Nimkema Mwanangu kulawa Misili.” ");
INSERT INTO zaj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helode viyawene kamba kavwiziligwa na iwanhu wali na ilimu ya nhondo, kagevuzika ng'hani. Kalagiza kamba wana wose wa kimbigalo wa kiwambo cha Betelehemu na ng'ambu zake zose, wali na milao mibili kwiza hasi wakomigwe, songela viyalongeligwe na waja iwanhu wali na ilimu ya nhondo mmbuli za ija inhondo kipigiti viilawilile. ");
INSERT INTO zaj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Abaho, gavikila gaja galongigwe na muhokozi Yelemia, ");
INSERT INTO zaj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Dizwi dihulikwa ako Lama, kililo na giogio kulu. Laheli kowalilila wanage, halonda kuhembekezwa, kwavija wahaduhu.” ");
INSERT INTO zaj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mndewa Helode viyadanganhike, msenga wa Mndewa wa kuulanga kamulawila Usufu mnzozi ako Misili ");
INSERT INTO zaj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","kalonga, “Lamuka, msole imwana na mamaake, uchole muisi ya Islaeli, kwavija wose walondile kumkoma imwana wadanganhika.” ");
INSERT INTO zaj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Avo Usufu kenuka, kamsola imwana na mamaake, na kubwela muisi ya Islaeli. ");
INSERT INTO zaj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ila Usufu viyahulike kamba Alikelao iyo mtawala wa Yudea kasola hanhu ha tataake Mndewa Helode Mkulu, kadumba kuchola hiko. Na heyo viyazumigwe mnzozi, kanyelenhukila kuisi ya Galilaya. ");
INSERT INTO zaj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kachola, kakala mkiwambo kikemigwe Nazaleti, giladi gavikile gaja galongigwe na wahokozi, “Kokemigwa Mnazaleti.” ");
INSERT INTO zaj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mazua higo Yohana M'batiza keza, yowapetela wanhu mkiwala cha Yudea, ");
INSERT INTO zaj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","kalonga, “Lekeni vilozo venu, kwavija Undewa wa Kuulanga ukwenhuka!” ");
INSERT INTO zaj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kwavija Yohana iyo yalongigwe na muhokozi Isaya, viyalongile, “Munhu kenula dizwi muluwala, yolonga, ‘Itandeni nzila ya Mndewa, Mgoloseleni nzila zake!’ ” ");
INSERT INTO zaj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohana kavala guo ditendigwe na mijusu ya ngamia na lukumbulu lwa kwembe mchuno chake, na mandia gake gakala nzige na uki. ");
INSERT INTO zaj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Wanhu kulawa Yelusalemu, kulawa muisi yose ya Yudea na ng'ambu zose za Mdibonde da Yolodani, wamcholela. ");
INSERT INTO zaj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wavilonga vilozo vao haulongozi wa wanhu, na heyo kawabatiza muna Ulwanda lwa Yolodani. ");
INSERT INTO zaj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yohana viyawawene Mafalisayo na Masadukayo bwando womwizila giladi wabatizigwe, kawalongela, “Mweye wana wa nyoka! Yalihi yawazumile kulukimbila lusango lwa Mulungu londalwize? ");
INSERT INTO zaj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tendeni mbuli zilagusa kamba muleka vilozo venu. ");
INSERT INTO zaj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Sambimgelegeze kamba modaha kuikimbila nhaguso ya Mulungu mkulonga, ‘Ablaham iyo muhenga wetu.’ Nowalongela, Mulungu kodaha kusola mabwe gano na kumtendela lukolo Ablaham! ");
INSERT INTO zaj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nhemo ya hana gamasina ga imibiki, na kila m'biki uleka kulela mujo unogile wokanhigwa na kwasigwa muna umoto. ");
INSERT INTO zaj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nie nowabatiza mweye na mazi kulagusa kamba muleka vilozo venu, ila hachugu changu kokwiza yali na mhiko kubanza nie, nie silumbile hata kupapa ng'hwabasa zake. Heyo kowabatiza na Loho wa Mulungu na moto. ");
INSERT INTO zaj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Heyo kana kia chake mmakono cha kubetela, giladi yaikunzanye ngano yake kukano na mikumvi yaisome na moto hauzimikaga.” ");
INSERT INTO zaj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Abaho, Yesu keza kulawa Galilaya, kachola hana Ulwanda lwa Yolodani giladi yabatizigwe na Yohana. ");
INSERT INTO zaj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ila Yohana kageza kumgomesa, kalonga, “Nie nolondigwa kubatizigwa na gweye, na gweye kokwiza kumwangu?” ");
INSERT INTO zaj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ila Yesu kamwidika, “Leka iwe vino sambi, kwavija tulondigwa kutenda vino giladi kugavikiza gaja gose gayalagize Mulungu.” Avo Yohana katogola. ");
INSERT INTO zaj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Bahaja Yesu viyabatizigwe, kalawa muna gamazi. Baho ulanga uvuguka, kamona Loho wa Mulungu yomuhumulukila yalingile kamba hua na kukala uchana yake. ");
INSERT INTO zaj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na dizwi kulawa kuulanga dilonga, “Ino iyo Mwanangu mnogelwa, ninogelwe nayo.” ");
INSERT INTO zaj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Abaho, Yesu kalongozwa na Loho wa Mulungu mbaka muluwala giladi yagezigwe na Mwenembago. ");
INSERT INTO zaj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Viyamambukize funga ya mazua malongo mane ikilo na imisi, Yesu kona nzala. ");
INSERT INTO zaj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Abaho, Mwenembago kamcholela kamgeza yomulongela, “Uhawa gweye iyo Mwana wa Mulungu, galongele mabwe gano gagaluke mikate.” ");
INSERT INTO zaj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ila Yesu kedika kalonga, “Yandikigwa Mzinyandiko Zing'alile, ‘Munhu hawa mgima sama ya mkate wiyeka, ila mkila mbuli ilawa mmulomo wa Mulungu.’ ” ");
INSERT INTO zaj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Abaho, Mwenembago kamsola Yesu mbaka Yelusalemu, Wambo Ding'alile, na kumwika hachana hana inhomboti ya Ing'anda ya Mulungu, ");
INSERT INTO zaj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","kamulongela, “Uhawa gweye iyo Mwana wa Mulungu, ibwanhe hasi, kwavija yandikigwa Mzinyandiko Zing'alile, ‘Mulungu kokulagizila wasenga zake wa kuulanga, wakudang'he mmakono gao, giladi mgulu wako sambiuikwale mdibwe.’ ” ");
INSERT INTO zaj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu kamwidika, “Vivija yandikigwa Mzinyandiko Zing'alile, ‘Sambiumgeze Mndewa Mulungu wako.’ ” ");
INSERT INTO zaj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Abaho, Mwenembago kamsola Yesu mbaka hana ikigongo kitali, kamulagusila ndewa zose za ulumwengu na yenzi zake. ");
INSERT INTO zaj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kamulongela, “Gano gose nokugwelela uhanifugamila mavindi na kunitambikila.” ");
INSERT INTO zaj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Abaho, Yesu kamulongela, “Goboka, Mwenembago! Kwavija yandikigwa Mzinyandiko Zing'alile, ‘Mtambikile Mndewa Mulungu wako na umsang'hanikile heyo yeiyeka!’ ” ");
INSERT INTO zaj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Abaho, Mwenembago kamuleka, na wasenga wa Mulungu wa kuulanga weza na kumsang'hanikila. ");
INSERT INTO zaj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Yesu viyahulike kamba Yohana kageligwa mkifungo, kachola kukiwambo cha Nazaleti muisi ya Galilaya. Kasegela Nazaleti, kachola kukala Kapenaumu, kiwambo kikalile behi na Dilamba da Galilaya, muisi za mitala ya Wazabuloni na Wanaftali, ");
INSERT INTO zaj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","giladi gavikile gaja galongigwe na muhokozi Isaya, ");
INSERT INTO zaj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Isi ya Zabuloni na isi ya Naftali, nzila ya kuchola m'bahali, mwambu uyagwe wa Ulwanda lwa Yolodani, Galilaya, isi ya Wamhazi! ");
INSERT INTO zaj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wanhu wokala mdiziza wona mulangaza mkulu. Na waja wose wokala muisi ya ziza da ifa, mulangaza uwamwemwesa.” ");
INSERT INTO zaj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Songela kipigiti kija Yesu kasonga kuwapetela wanhu yolonga, “Lekeni vilozo venu, kwavija Undewa wa Kuulanga ukwenhuka!” ");
INSERT INTO zaj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu viyakalile yotembela mumgwazo wa Idilamba da Galilaya, kawona wandugu wabili, Simoni yakemigwe Petulo na mdodo wake Endelea. Wakala wotanda nhando zao mdilamba, kwavija wakala waloa somba. ");
INSERT INTO zaj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu kawalongela, “Ng'holelezeni, na nie nowatenda muwe waloa wanhu.” ");
INSERT INTO zaj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bahaja wazileka nhando zao, wamkoleleza. ");
INSERT INTO zaj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Viyacholile haulongozi kidogo, kawona wandugu wabili wayagwe, Yakobo na mdodo wake Yohana, wanage Zebedayo, wakalile muna ingalawa hamoja na tataao Zebedayo, wozigongomanya nhando zao. Yesu kawakema, ");
INSERT INTO zaj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","na baho waileka ingalawa na tataao, wamkoleleza. ");
INSERT INTO zaj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu kachola kila hanhu m'viwambo va Galilaya, yofundiza muna zing'anda zao za nhambiko na kuupeta Usenga Unogile wa Undewa wa Mulungu, na kuwahonya wanhu wakalile na kila utamu na unyondenyonde. ");
INSERT INTO zaj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mbuli zake zenela muisi yose ya Silia. Wamgalila wanhu wose wakalile wokugula kila utamu, wakalile wokona vihile, wakalile na vinyamkela, wakalile na kisango, na wakalile waholole, na heyo kawahonya. ");
INSERT INTO zaj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dale kulu da wanhu dimkoleleza, wanhu kulawa Galilaya, kulawa kuviwambo longo dimwe vikemigwa Dekapoli, kulawa Yelusalemu, Yudea, na mwambu uyagwe wa Ulwanda lwa Yolodani. ");
INSERT INTO zaj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu viyadiwene didale da wanhu, kakwela hakigongo, kakala hasi. Wanahina zake wamcholela, ");
INSERT INTO zaj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","na heyo kasonga kuwafundiza. ");
INSERT INTO zaj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Wamota waja wakumbulu wa loho, kwavija Undewa wa Kuulanga uli wao! ");
INSERT INTO zaj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Wamota waja wose wali na giogio, kwavija wobwezigwa imioyo! ");
INSERT INTO zaj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wamota waja wali na mioyo iholile, kwavija woihala isi! ");
INSERT INTO zaj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wamota waja wose wali na nzala na ng'hilu ya kutenda ganogile, kwavija wokwigutizwa! ");
INSERT INTO zaj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wamota wali na bazi, kwavija wokonelwa bazi! ");
INSERT INTO zaj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wamota wali na mioyo ing'alile, kwavija womona Mulungu! ");
INSERT INTO zaj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wamota wagombelezi, kwavija wokemigwa wana wa Mulungu! ");
INSERT INTO zaj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Wamota awo wogazigwa sama ya kutenda ganogile, kwavija Undewa wa Kuulanga uli wao! ");
INSERT INTO zaj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mmota mweye haja wanhu wahawaliga, na kuwagaza, na kuwavwizila mbuli zose zihile sama yangu. ");
INSERT INTO zaj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Deng'heleleni na kutoa ng'henze, kwavija nhunza yenu yowa ng'hulu kuulanga. Kwavija vino vivo wagazigwe wahokozi wawalongole. ");
INSERT INTO zaj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mweye iwo munyu wa isi. Ila munyu uhagiza kilandu chake, vodahikaze kuutenda unoge kabili? Haunoga mkinhu chochose, ila wokwasigwa hanze na kubojagwa na wanhu. ");
INSERT INTO zaj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mweye iwo mulangaza wa ulumwengu mokoneka na wanhu wose, kamba viwodaha kuwona mulangaza wa wambo dizengigwe hakigongo. ");
INSERT INTO zaj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Haduhu munhu yobwinha kiwenge na kukigubika na kinongo. Ila kokika uchana hakingolobweda, giladi kimmwemwesele kila munhu yali mng'anda. ");
INSERT INTO zaj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Vivo na mweye, mulangaza wenu umwemwese haulongozi wa wanhu, giladi wone sang'hano zenu zinogile, na hewo wamuyenzi Tata wenu wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Sambimgelegeze kamba niza kugatengula Malagizo ga Musa na mafundo ga wahokozi, ila kugavikiza. ");
INSERT INTO zaj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nowalongela ikweli, mbaka ulanga na isi vondavisegele, haduhu hata helufi imwe ndodo kulawa Mmalagizo ga Musa yondaisegezigwe mbaka mbuli zose zivikile. ");
INSERT INTO zaj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Avo, munhu yoyose yoleka kutenda ndagizi imwe ili ndodo, na kuwafundiza wanhu sambiwaitende, munhu iyo kokemigwa mdodo muna Undewa wa Kuulanga. Ila munhu yoyose yondayazitende ndagizi zino na kuzifundiza, munhu iyo kokemigwa mkulu muna Undewa wa Kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kwavija nowalongela, mbuli zenu zilibule uzenzeleganye zihaleka kuzibanza zija za Mafalisayo na wafundiza Malagizo ga Musa, hamdaha kwingila Muundewa wa Kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Muhulika kamba wanhu wa umwaka viwalongeligwe, ‘Sambiukome, na yoyose yondayatende avo kotagusigwa.’ ");
INSERT INTO zaj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ila nie nowalongela, munhu yoyose yomonela lusango ndugu yake kotagusigwa, na munhu yoyose yomuliga ndugu yake kolondigwa yagaligwe Kukitala Kikulu cha Isi ya Wayahudi, na munhu yoyose yolonga, ‘Gweye kwa m'bozi’ ka mdihekaheka da kwingila hana umoto wa kuzimu. ");
INSERT INTO zaj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Avo, kamba uhalonda kulava nhunza yako hana ikilingo cha kulavila nhosa, na kukumbukila kamba kuna mbuli na ndugu yako, ");
INSERT INTO zaj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ileke nhunza yako haulongozi wa ikilingo cha kulavila nhosa, tanhu genda mkailumbe na ndugu yako, abaho, leka ubwele uilave nhunza yako. ");
INSERT INTO zaj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ilumbe hima na munhu yokutagusa, kipigiti mng'hali mnzila mchola kukitala, giladi sambiyakugale ha mulamula, na mulamula yakugele mmakono ga wemilizi, na wemilizi wakugele mkifungo. ");
INSERT INTO zaj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nokulongela ikweli, hulawa himo mbaka ulihe deni jako jose. ");
INSERT INTO zaj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Muhulika kamba ilongwa, ‘Sambiutende ugoni.’ ");
INSERT INTO zaj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ila nie nowalongela, munhu yoyose yomulola mtwanzi mkumsulukila, kesha kutenda nayo ugoni mmoyo wake. ");
INSERT INTO zaj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Avo kamba siso jako da ukulume dokutenda utende vilozo, ding'ole ujase kutali nagwe! Vinoga kumwako kwagiza kipindi kimwe cha lukuli lwako kubanza lukuli lwako lose lwasigwe kuzimu. ");
INSERT INTO zaj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na kamba mkono wako wa ukulume wokutenda utende vilozo, ukanhe uwase kutali nagwe! Vinoga kumwako kwagiza kipindi kimwe cha lukuli lwako kubanza lukuli lwako lose luchole kuzimu. ");
INSERT INTO zaj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Vivija ilongigwa, ‘Munhu yoyose yomwasa mtwanzi wake, kolondigwa yamwandikile lupwilili lwa nyasa.’ ");
INSERT INTO zaj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ila nie nowalongela kamba, munhu yoyose yomwasa mtwanzi wake, ila tu sama ya kilamso cha ugoni, komtenda mtwanzi hiyo yawe mgoni, na munhu yoyose yomsola mtwanzi hiyo kotenda ugoni. ");
INSERT INTO zaj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Vivija muhulika kamba wanhu wa umwaka viwalongeligwe, ‘Sambiuiduile uvwizi ila ugoge kiduilo chako chuuiduile ha Mndewa.’ ");
INSERT INTO zaj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ila nie nowalongela, sambimuiduile kabisa. Sambimuiduilile ulanga, kwavija kicho kigoda cha undewa cha Mulungu, ");
INSERT INTO zaj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ama sambimuiduilile isi, kwavija kicho kigoda chake cha kwikila magulu gake, ama sambimuiduilile Yelusalemu, kwavija dijo wambo da Mndewa Mkulu. ");
INSERT INTO zaj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Vivija sambiuiduilile pala jako, kwavija hudaha kutenda hata luvili lwako lumwe kuwa luzelu ama lutitu. ");
INSERT INTO zaj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mbuli zenu ziwe ‘Ona’ kamba ihawa ‘Ona’ ama ‘Sio’ kamba ihawa ‘Sio.’ Chochose chondakibanze mbuli zino cholawa ha Mwenembago. ");
INSERT INTO zaj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Muhulika ilongigwa kamba, ‘Siso kwa siso, na zino kwa zino.’ ");
INSERT INTO zaj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ila nie nowalongela, sambium'bwelezele mtenda gehile. Munhu yahakutoa kanza da ukulume, muhindusile na diyagwe. ");
INSERT INTO zaj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na munhu yahakugala kukitala na kukusolela shati jako, vivija mulekele na koti jako. ");
INSERT INTO zaj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kamba munhu yahakushulutiza umpapile bahasha yake kilometa imwe, mpapile kilometa mbili. ");
INSERT INTO zaj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Munhu yondayakupule, mgwelele, na munhu yoyose yolonda umkalizi, sambiumuhindukile kisogo. ");
INSERT INTO zaj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Muhulika kamba ilongigwa, ‘Mnogele munhu wa habehi nagwe, na umwihile mdumuka wako.’ ");
INSERT INTO zaj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ila nie nowalongela, wanogele wadumuka zako na muwatambikile waja wose wowagaza, ");
INSERT INTO zaj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","giladi muwe wana wa Tata wenu wa kuulanga. Heyo yowamwemwesela zua jake wanhu wehile na wanogile, na yowatoela mvula wazenzeleganye na wanhu walibule uzenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ihawa mowanogela wanhu wose waja wowonogela mweye, mopata nhunza yaki? Kwavija hata wawila kodi wotenda vivo! ");
INSERT INTO zaj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na kamba mowalamsa ndugu zenu weiyeka, kinhu chaki kikulu kimtenda kubanza wayagwe? Hata Wamhazi wotenda vivo! ");
INSERT INTO zaj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Avo, sambimuhungule hanhu kamba Tata wenu wa kuulanga viyalekile kuhungula hanhu! ");
INSERT INTO zaj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Iteganyeni, sambimtende mbuli zenu zinogile haulongozi wa wanhu giladi mwoneke na hewo, kwavija muhatenda hivo ham'bokela nhunza kulawa ha Tata wenu wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Uhamwing'ha mkumbulu, sambiumulongele munhu yoyose mkutoa mhalati, kamba viwotenda videlenya muna zing'anda za nhambiko na mzinzila, giladi watogoligwe na wanhu. Nowalongela ikweli, wanhu hiwo wesha kubokela nhunza yao. ");
INSERT INTO zaj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ila uhamwing'ha mkumbulu, hata mkono wako wa ukumoso sambiuvitange kitendigwa na mkono wako wa ukulume, ");
INSERT INTO zaj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","avo nhunza yako yowa mkifiso. Abaho, Tataako, yolola kija kitendeke mkifiso, kokugwelela nhunza. ");
INSERT INTO zaj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Muhatambika, sambimuwe kamba videlenya! Kwavija hewo wonogelwa kutambika kuno wemile wima muna zing'anda za nhambiko na mzinzilamhanda, giladi woneke na wanhu. Nowalongela ikweli, wesha kubokela nhunza yao. ");
INSERT INTO zaj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ila uhatambika, ingila mdigati jako, hinda ulwivi, na tambika ha Tataako yali mkifiso. Abaho, Tataako, yolola kija kitendeke mkifiso, kokugwelela nhunza. ");
INSERT INTO zaj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Muhatambika, sambimulonge mbuli bwando zilibule nhegulo ha Mulungu, kamba viwotenda Wamhazi, kwavija wogelegeza kamba wohulikwa sama ya mbuli zao kuwa bwando. ");
INSERT INTO zaj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sambimuilinge nao, kwavija Tata wenu kovitanga chumulonda hata mng'hali hamunampula. ");
INSERT INTO zaj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Avo tambikeni kamba vino, ‘Tata wetu wa kuulanga, twaga jako diyenzigwe, ");
INSERT INTO zaj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Undewa wako wize, chuulonda kitendeke muisi kamba viili kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utugwelele mandia getu ga kila zua. ");
INSERT INTO zaj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Vigele kumgongo vilozo vetu, kamba tweye vituwagela kumgongo wanhu watutendile mbuli zihile. ");
INSERT INTO zaj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sambiutugele mkugezigwa, ila utukombole kulawa ha Mwenembago. Kwavija Undewa, na mhiko, na yenzi vako gweye gunge na gunge. Amina.’ ");
INSERT INTO zaj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kwavija kamba muhawagela kumgongo wanhu wawatendile mbuli zihile, vivija na Tata wenu wa kuulanga kovigela kumgongo vilozo venu. ");
INSERT INTO zaj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ila kamba hamuwagela kumgongo wanhu wawatendile mbuli zihile, vivija na Tata wenu wa kuulanga havigela kumgongo vilozo venu. ");
INSERT INTO zaj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Muhafunga, sambimnyunguale kamba viwotenda videlenya, kwavija wosinalika giladi watogolwe na wanhu kamba wafunga. Nowalongela ikweli, wesha kubokela nhunza yao. ");
INSERT INTO zaj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Uhafunga, suluza kihanga chako abaho bakaza mavuta pala jako, ");
INSERT INTO zaj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","giladi wanhu sambiwavitange kamba kufunga. Ila Tataako yoleka koneka, kovitanga. Na Tataako, yolola kija kitendeke mkifiso, kokugwelela nhunza. ");
INSERT INTO zaj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Sambimwiikile ngama muisi, aho hana ivimhungu na ng'hangaga hondawabanange, na wabavi wobena wokwingila na kwiba. ");
INSERT INTO zaj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ila ikeni ngama kuulanga, kulibule vimhungu na ng'hangaga wondawabanange, na wabavi hawabena na kwingila na kwiba. ");
INSERT INTO zaj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kwavija hanhu haili ngama yako, vivija na moyo wako baho hondaukale. ");
INSERT INTO zaj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Siso dijo kiwenge cha lukuli. Ihawa siso jako gima, lukuli lwako lose lomema mulangaza. ");
INSERT INTO zaj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ila siso jako dihabanangika, lukuli lwako lose lomema ziza. Na kamba mulangaza uli mgati yako wowa ziza, avo ziza hijo dowa kulu! ");
INSERT INTO zaj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Haduhu munhu yodaha kuwasang'hanikila wandewa wabili, kwavija komwihila imwe na kumnogela iyagwe, ama komnanahila imwe na kum'beza iyagwe. Hudaha kumsang'hanikila Mulungu kuno usang'hanikila mali. ");
INSERT INTO zaj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Avo nowalongela, sambimuigazile ugima wenu, kamba mje choni ama mung'we choni, ama ng'huli zenu, kamba m'vale choni. Ugima hauzamile kubanza mandia? Na lukuli haluzamile kubanza vivalo? ");
INSERT INTO zaj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Waloleni ndege wa kuulanga, hawahanda, hawahuna, na hawakunzanya mmakano, na Tata wenu wa kuulanga kowagwelela mandia. Avo, mweye mzama ng'hani kubanza ndege. ");
INSERT INTO zaj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yalihi mmwanza wenu mkuigaza yodaha kuiyongezela saa dimwe da ugima wake? ");
INSERT INTO zaj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Habali muigazila vivalo? Loleni malua ga kumgunda vigokula, hagasang'hana ama kuitendela vivalo. ");
INSERT INTO zaj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nowalongela kamba hata Selemani na yenzi yake yose havazigwe vinogile kamba dimwe da malua gano. ");
INSERT INTO zaj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ihawa kamba Mulungu kodivaza jani da kumgunda, dija lelo dabaho na mayo dokwasigwa muna umoto, vino heyo haleka kuwavaza vinogile mweye wanhu muli na nhamanila ndodo? ");
INSERT INTO zaj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Avo sambimuigaze mkulonga, ‘Toja choni?’ ama ‘Tong'wa choni?’ ama ‘Tovala choni?’ ");
INSERT INTO zaj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kwavija Wamhazi wovizahila vinhu vino vose, na Tata wenu wa kuulanga kovitanga kamba movilonda vinhu vino vose. ");
INSERT INTO zaj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ila uzahileni tanhu Undewa wa Mulungu na ndagizi zake, na vinhu vino vose mogweleligwa. ");
INSERT INTO zaj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Avo sambimuigazile mayo, kwavija mayo yowa na migayo yake yenyego. Mgayo wa zua dimwe wotosha kwa zua dimwe.” ");
INSERT INTO zaj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Sambimuwataguse wayagwe, na Mulungu hawatagusa mweye, ");
INSERT INTO zaj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","kwavija kamba vimuwatagusa wayagwe, vivo na Mulungu vondayawataguse mweye, na mhima iija yondamuwapimile wayagwe, iyo mhima yondampimilwe mweye. ");
INSERT INTO zaj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Habali ukilola kikupi msiso da ndugu yako, na huchona kibanzi kili msiso jako mwenyego? ");
INSERT INTO zaj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kodaha vilihi kumulongela ndugu yako, ‘Beta nikulave kikupi mdisiso jako,’ kuno gweye kuna kibanzi mdisiso jako? ");
INSERT INTO zaj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Gweye kidelenya! Songa tanhu kulava kibanzi msiso jako mwenyego, giladi udahe kulola goya, abaho, leka ulave kikupi msiso da ndugu yako. ");
INSERT INTO zaj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Sambimuwagwelele umbwa vinhu ving'alile, kamba muhatenda avo, wowahindukila na kuwadega, na sambimuwasile mitumbi lulu zenu, kamba muhatenda avo, wozibojaga. ");
INSERT INTO zaj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Puleni, mogweleligwa. Zahileni, movumbula. Toeni hodi, movugulilwa. ");
INSERT INTO zaj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kwavija yoyose yopula kogweleligwa, na yoyose yozahila kovumbula, na yoyose yotoa hodi kovugulilwa. ");
INSERT INTO zaj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ama yalihi mmwanza wenu, kamba mwanage yahampula mkate, komgwelela dibwe? ");
INSERT INTO zaj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ama yahampula somba, komgwelela nyoka? ");
INSERT INTO zaj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ihawa mweye mtenda mbuli zihile, movitanga kuwagwelela wanenu vinhu vinogile, avo, Tata wenu wa kuulanga kabanza ng'hani kuwagwelela vinhu vinogile waja wose wompula! ");
INSERT INTO zaj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Avo, chochose chumulonda mtendeligwe na wanhu, na mweye muwatendele vivo, kwavija gano gago mafundo ga Malagizo ga Musa na wahokozi. ");
INSERT INTO zaj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ingileni mkubitila lwivi lusisili, kwavija lwivi lugazi na zila gazi dilongoza kuubananzi, na wondawengile kubitila zila hijo wowa bwando. ");
INSERT INTO zaj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ila lwivi lusisili na inzila yakibabani ilongoza kuugima, na wanhu wondawayone wowa wadodo. ");
INSERT INTO zaj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Iteganyeni na wahokozi wa uvwizi, womwizileni kunze walingile kamba ng'hondolo, ila mgati mbwizi wodumbiza. ");
INSERT INTO zaj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mowatambula kubitila sang'hano zao. Vino wanhu wobawa zabibu muna imizomola, ama tini muna imingemba? ");
INSERT INTO zaj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Avo, m'biki unogile wolela mujo unogile, ila m'biki wihile wolela mujo wihile. ");
INSERT INTO zaj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","M'biki unogile haudaha kulela mujo wihile, na m'biki wihile haudaha kulela mujo unogile. ");
INSERT INTO zaj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na m'biki wowose uleka kulela mujo unogile wokanhigwa na kwasigwa muna umoto. ");
INSERT INTO zaj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Avo, mowatambula kubitila sang'hano zao. ");
INSERT INTO zaj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Sio kila munhu yonikema, ‘Mndewa, Mndewa’ yondayengile muna Uundewa wa Kuulanga, ila heyo yogatenda gaja goyolonda Tataangu wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mdizua da nhaguso wanhu bwando wonilongela, ‘Mndewa, Mndewa! Hatuhokole mditwaga jako, na mditwaga jako tuwinga vinyamkela, na kutenda mizonza bwando?’ ");
INSERT INTO zaj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Abaho, nowalongela, ‘Siwatangile mweye. Segeleni hamwangu, mweye watenda gehile!’ ");
INSERT INTO zaj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Avo munhu yoyose yohulika mbuli zangu na kuzisang'hana kolinga na munhu yali na nzewele yozenga ng'anda yake uchana ya dibwe. ");
INSERT INTO zaj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mvula itoa, nyanda zitula, na beho dibuma na kuitoa ng'anda hiyo, ila haitulike, kwavija msingi wake uzengigwa mdidibwe. ");
INSERT INTO zaj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ila munhu yoyose yohulika mbuli zangu na kuleka kuzisang'hana kolinga na munhu m'bozi yozenga ng'anda yake mmisenga. ");
INSERT INTO zaj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mvula itoa, nyanda zitula, na beho dibuma na kuitoa ng'anda hiyo, nayo itulika, na nhulika yake ikala ihile ng'hani!” ");
INSERT INTO zaj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu viyamambukize kulonga gano, didale da wanhu dikanganya mafundo gake, ");
INSERT INTO zaj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kwavija hafundize kamba wafundiza zao wa Malagizo ga Musa, ila kafundiza kamba munhu yali na udaho. ");
INSERT INTO zaj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu viyahumuluke kulawa mkigongo, madale makulu ga wanhu gamkoleleza. ");
INSERT INTO zaj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na munhu yakalile na dikulu kamwizila na kamfugamila mavindi, kalonga, “Mndewa, uhalonda, kodaha kunihonya.” ");
INSERT INTO zaj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu kagolosa mkono wake, kamkwasa, kamulongela, “Nolonda, uhonyigwe!” Bahaja kahonyigwa utamu wake. ");
INSERT INTO zaj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Abaho, Yesu kamulongela, “Tegeleza, sambiumulongele munhu, ila genda ukailaguse ha mkulu wa nhambiko, abaho ukalave nhosa kamba viyalagize Musa, giladi wanhu wose watogole kamba kuhona.” ");
INSERT INTO zaj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu viyengile Kapenaumu, mkulu wa asikali mia wa Loma kamwizila, kamuyalalila ");
INSERT INTO zaj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","na kulonga, “Mndewa, mtumigwa wangu katambalala ukae, kaholola, mtamu ng'hani.” ");
INSERT INTO zaj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu kamulongela, “Nokwiza kumuhonya.” ");
INSERT INTO zaj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ija imkulu wa asikali mia wa Loma kamwidika, “Mndewa, nie silumbile gweye wingile mng'anda yangu, ila longa mbuli tu, na mtumigwa wangu kohona. ");
INSERT INTO zaj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kwavija nie mwenyego na munhu nikigwe hasi ya udaho, nna asikali hasi yangu. Nomulongela imwe, ‘Genda!’ na heyo kochola, na nomulongela iyagwe, ‘Izo!’ na heyo kokwiza. Na nomulongela mtumigwa wangu, ‘Tenda vino!’ na heyo kotenda.” ");
INSERT INTO zaj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu viyahulike vino, kakanganya na kuwalongela waja wakalile womkoleleza, “Nowalongela ikweli, sinamona munhu yoyose muisi ya Islaeli yali na nhamanila ng'hulu kamba ino. ");
INSERT INTO zaj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nowalongela kamba wanhu bwando wokwiza kulawa haulawilo wa zua na hauswelo wa zua na wokala hana ulusona hamoja na Ablaham, Isaka, na Yakobo Muundewa wa Kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ila Wana wa Undewa wokwasigwa hanze mdiziza, ako kondawalile na kugegedula meno.” ");
INSERT INTO zaj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Abaho, Yesu kalonga na ija imkulu wa asikali mia wa Loma, “Genda, yotendeka kamba vija vuutamanile.” Na kipigiti kikija mtumigwa wake kahona. ");
INSERT INTO zaj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu viyavikile hakae ha Petulo, kam'vika mama mkwe yake Petulo kawasa mulusazi mtamu wa homa. ");
INSERT INTO zaj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kamkwasa mkono wake, na homa imulawa, abaho kenuka na kusonga kumsang'hanikila. ");
INSERT INTO zaj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Viivikile ichungulo, wamgalila wanhu bwando wakalile na vinyamkela, na heyo kawawinga ivinyamkela mkuwakomhokela, na kawahonya wanhu wose wakalile watamu. ");
INSERT INTO zaj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Giladi gavikile gaja galongigwe na muhokozi Isaya, “Heyo mwenyego kausola unyondenyonde wetu na kavipapa vitamu vetu.” ");
INSERT INTO zaj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu viyadiwene didale da wanhu domzunguluka, kawalagiza wanahina zake wachole mwambu uyagwe wa dilamba. ");
INSERT INTO zaj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mfundiza Malagizo ga Musa kamcholela, kamulongela, “Mkulufunzi, nokuwinza kokose kuuchola.” ");
INSERT INTO zaj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu kamulongela, “Mbwizi wana mhango, na ndege wa kuulanga wana mvulu, ila nie, Mwana wa Munhu, kabule hanhu ha kutambalika pala jake.” ");
INSERT INTO zaj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mwanahina iyagwe kamulongela, “Mndewa, nileke tanhu nyhole hazike tataangu.” ");
INSERT INTO zaj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu kamulongela, “Ng'hweleleza nie, waleke wadanganhike wazike wadanganhike wayao.” ");
INSERT INTO zaj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Abaho, Yesu kakwela muingalawa hamoja na wanahina zake. ");
INSERT INTO zaj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bahaja dilawila kukuzumbi kulu mdilamba, avo mawimbi gaimemeza mazi ingalawa. Ila Yesu kakala yawasile. ");
INSERT INTO zaj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wanahina zake wamcholela wamulamusa, walonga, “Mndewa, tukombole! Todanganhika!” ");
INSERT INTO zaj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu kawedika, “Mweye wanhu muli na nhamanila ndodo, habali mkona bwembwe?” Abaho, kenuka na kudikomhokela dibeho na gamawimbi, na kukala hapozike. ");
INSERT INTO zaj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Wanahina zake wakanganya, walonga, “Ino iyo munhu wa vilihi? Hata beho na mawimbi vomuhulika!” ");
INSERT INTO zaj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu viyavikile mwambu uyagwe wa idilamba hana iisi ya Gadala, kaiting'hana na wanhu wabili wali na vinyamkela wakalile wolawa mmapanga. Wakala wodumbiza ng'hani mbaka hakukalile na munhu yadahile kubita nzila iyo. ");
INSERT INTO zaj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Waguta nyangi, walonga, “Kotulonda choni, Mwana wa Mulungu? Kwiza kutugaza kipigiti king'hali hakinavika?” ");
INSERT INTO zaj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Behi na aho kukala na dale kulu da mitumbi wodila. ");
INSERT INTO zaj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Vinyamkela wamuyalalila Yesu, walonga, “Uhatuwinga, tuleke tuchole tukengile mdidale dija da mitumbi.” ");
INSERT INTO zaj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu kawalongela, “Gendeni!” Avo walawa, wachola kuwengila mitumbi. Baho dale jose da imitumbi dihumulukila kubonde mdigema, dingila mdilamba na kudanganhika mmazi. ");
INSERT INTO zaj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Waja iwanhu wakalile wowachunga imitumbi wakimbila, wachola hana ikiwambo na kuwalongela wanhu mbuli zose, hamoja na gaja gawalawilile waja wanhu wakalile na vinyamkela. ");
INSERT INTO zaj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Avo, wanhu wose wa ikiwambo kija walawa, wamcholela Yesu, na viwamuwene, wamuyalalila yahalawe muisi yao. ");
INSERT INTO zaj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu kakwela muingalawa, kaloka na kuvika mkiwambo chake. ");
INSERT INTO zaj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wanhu wayagwe wamgalila munhu yaholole, yatambalale mulusazi. Yesu viyaiwene nhamanila yao, kamulongela ija imunhu yaholole, “Gangamala, mwanangu! Vilozo vako vigeligwa kumgongo.” ");
INSERT INTO zaj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Abaho, wafundiza Malagizo ga Musa wakalile baho wailongela wenyego kwa wenyego, “Munhu ino kofukula!” ");
INSERT INTO zaj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu kavitanga vija viwakalile wogelegeza, kalonga, “Habali mgelegeza vihile mmioyo yenu? ");
INSERT INTO zaj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Dilihi dibuhile ng'hani, kulonga, ‘Vilozo vako vigeligwa kumgongo,’ ama kulonga, ‘Ima wima utembele?’ ");
INSERT INTO zaj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nolonda m'vitange kamba, nie, Mwana wa Munhu, nna udaho wa kuvigela kumgongo vilozo va wanhu muisi.” Abaho, kamulongela ija imunhu yaholole, “Ima wima, papa lusazi lwako, uchole ukae yako!” ");
INSERT INTO zaj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ija imunhu kema wima, na kuchola ukae. ");
INSERT INTO zaj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wanhu viwonile gano, wakanganya na kudumba, na kumuyenzi Mulungu yawagwelele wanhu udaho kamba uja. ");
INSERT INTO zaj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu viyakalile yochola kulawa haja, kamona munhu yokemigwa Matayo yakalile muna ing'anda yake ya kulihila kodi, na heyo kamulongela, “Ng'holeleza.” Matayo kenuka, kamkoleleza. ");
INSERT INTO zaj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu na wanahina zake wakala woja mandia ga ichungulo hakae ya Matayo. Wawila kodi bwando na wene vilozo wayagwe weza na kuja hamoja na hewo. ");
INSERT INTO zaj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafalisayo viwonile gano, wawauza wanahina zake, “Habali mkulufunzi wenu yoja na wawila kodi na wene vilozo wayagwe?” ");
INSERT INTO zaj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu viyahulike vino, kalonga, “Wanhu wagima hawamulonda mganga, ila waja wali watamu wawo womulonda. ");
INSERT INTO zaj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gendeni mkaifundize nhegulo ya ulonzi uno, ‘Nolonda bazi na sio nhosa.’ Kwavija sizile kuwakema wanhu walibule vilozo, ila wanhu wali na vilozo.” ");
INSERT INTO zaj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Abaho, wanahina wa Yohana M'batiza wamcholela Yesu, wamuuza, “Habali tweye na Mafalisayo tofunga, ila wanahina zako hawafunga?” ");
INSERT INTO zaj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu kawedika, “Wahenza wa mulawilamhambe wodaha vilihi kulila kipigiti viwali hamoja na heyo? Ila kipigiti chokwiza, mulawilamhambe vondayasegezigwe kulawa kumwao, leka na hewo wafunge. ");
INSERT INTO zaj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Haduhu munhu yogela kidanga cha kivalo cha sambi muna ikivalo cha umwaka, kwavija ikidanga choikunza na kuchongeza ikizonzo cha ikivalo cha umwaka. ");
INSERT INTO zaj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na wanhu hawagela divai ya sambi muna ivibuyu vitendigwe na kwembe va umwaka. Kamba wahatenda avo, ivibuyu vitendigwe na kwembe votulika, na idivai yokwitika, na ivibuyu vitendigwe na kwembe vobanangika. Ila divai ya sambi yogeligwa muna ivibuyu vitendigwe na kwembe va sambi, na vose vowa vigima.” ");
INSERT INTO zaj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu viyakalile yolonga vino, mkulu imwe wa ng'anda ya nhambiko kamcholela, kamfugamila mavindi, kamulongela, “Mndele wangu sambisambi kadanganhika, ila izo umwikile mkono wako na heyo kowa mgima.” ");
INSERT INTO zaj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Avo Yesu hamoja na wanahina zake, wenuka, wamkoleleza. ");
INSERT INTO zaj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Baho mtwanzi yakalile na utamu wa kutumika mkipigiti cha milao longo dimwe na mibili kamwizila Yesu kukisogo, abaho, kalukwasa lugigo lwa kivalo chake. ");
INSERT INTO zaj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kwavija kakala yoilongela mwenyego, “Ihawa nihagoga tu valo jake, nohona.” ");
INSERT INTO zaj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu kahinduka kamona, kamulongela, “Mndele, gangamala! Nhamanila yako ikuhonya.” Kipigiti kikija mtwanzi ija kahona. ");
INSERT INTO zaj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu viyavikile hakae ya ija imkulu wa ng'anda ya nhambiko, na viyawawene wotoa mhalati, na wanhu bwando wolila ng'hani, ");
INSERT INTO zaj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","kalonga, “Segeleni! Mndele ino hadanganhike, ila kawasa!” Abaho, wanhu wose wamseka. ");
INSERT INTO zaj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Didale da wanhu vidilavigwe kunze, Yesu kengila mng'anda, kamgoga mkono ija imndele, na heyo kenuka. ");
INSERT INTO zaj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mbuli zino zenela hanhu hose muisi ija. ");
INSERT INTO zaj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu viyakalile yochola kulawa haja, vimbugumbugu wabili wamkweleleza, woguta nyangi, “Tonele bazi, Mwana wa Daudi!” ");
INSERT INTO zaj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu viyengile mng'anda, waja vimbugumbugu wamcholela, na Yesu kawauza, “Motogola kamba nie nodaha kuwahonya mweye?” Wedika, “Ona, Mndewa!” ");
INSERT INTO zaj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Abaho, kagakwasa meso gao, kalonga, “Mtendeligwe kamba vija vumtamanila!” ");
INSERT INTO zaj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na meso gao gagubuligwa. Yesu kawazuma ng'hani, kawalongela, “Sambimmulongele munhu yoyose mbuli ino!” ");
INSERT INTO zaj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ila hewo wachola na kubwililisa mbuli za Yesu kila hanhu muisi ija. ");
INSERT INTO zaj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wanhu viwakalile wosegela, wamgalila munhu yakalile bubui yali na kinyamkela. ");
INSERT INTO zaj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kinyamkela viyawingigwe, ija imunhu kasonga kulonga, na wanhu wose wakanganya, walonga, “Hatunachona kinhu kamba kino muisi ya Islaeli!” ");
INSERT INTO zaj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ila Mafalisayo walonga, “Kowinga vinyamkela na mhiko za mkulu wa vinyamkela.” ");
INSERT INTO zaj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu kachola mmiwambo na m'viwambo vose, yofundiza mzing'anda zao za nhambiko, youpeta Usenga Unogile wa Undewa wa Mulungu, na kuhonya kila utamu na unyondenyonde. ");
INSERT INTO zaj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Viyadiwene didale da wanhu, kawonela bazi, kwavija wakala wogaya na wabule munhu wa kuwataza, kamba ng'hondolo walibule mchunga. ");
INSERT INTO zaj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Abaho, kawalongela wanahina zake, “Va kuhuna vimema ila wahunaji wadodo.” ");
INSERT INTO zaj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Avo mpuleni mwene mgunda, yawagale wahunaji wahune vakuja vake. ");
INSERT INTO zaj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu kawakema wanahina zake longo dimwe na wabili na kuwagwelela udaho wa kuwinga vinyamkela na kuhonya kila utamu na unyondenyonde. ");
INSERT INTO zaj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Gano gago matwaga ga watumigwa wa Kilisto longo dimwe na wabili, wa mwanduso Simoni, yakalile yokemigwa Petulo, na ndugu yake Endelea, Yakobo na ndugu yake Yohana wanage Zebedayo, ");
INSERT INTO zaj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo na Batolomayo, Tomaso na Matayo muwila kodi, Yakobo mwanage Alufayo, Tadayo, ");
INSERT INTO zaj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni, yakalile yokemigwa Mgombeleza Isi ya Islaeli, na Yuda Isikalioti, yamuhonzile Yesu. ");
INSERT INTO zaj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu kawalagiza wano longo dimwe na wabili, kawalongela, “Sambimchole muisi ya Wamhazi ama kwingila mkiwambo cha Wasamalia, ");
INSERT INTO zaj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ila gendeni ha ng'hondolo wapotele, awo wali wanhu wa Islaeli. ");
INSERT INTO zaj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ako kumchola, peteni mulonga, ‘Undewa wa Kuulanga ukwenhuka!’ ");
INSERT INTO zaj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Honyeni watamu, zuseni wadanganhike, wahonyeni watamu wa dikulu, wingeni vinyamkela. Mgweleligwa bule, laveni bule. ");
INSERT INTO zaj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Sambimsole hela yoyose mmikwiji yenu, ");
INSERT INTO zaj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","sambimsole mkoba wa mwanza, ama koti da ikabili, ama ng'hwabasa, ama fimbo. Kwavija msang'hana kolondigwa yagweleligwe kitumetume chake. ");
INSERT INTO zaj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Vondamwingile mdiwambo ama mkiwambo, zahileni munhu yowatogola, giladi mkale hamwake mbaka vondamsegele. ");
INSERT INTO zaj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Vondamwingile muna ing'anda ija walamseni wanhu wa ng'anda ija. ");
INSERT INTO zaj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na kamba wanhu wa ng'anda hiyo wahawabokela, walekeleni tindiwalo jenu, ila kamba hawawabokela, tindiwalo jenu diwabwelele mweye. ");
INSERT INTO zaj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ihawa munhu yoyose hawabokela mweye ama kuzitegeleza mbuli zenu, muhalawa muna ing'anda hiyo ama mkiwambo hicho, kung'unheni timbwisi dinanahile mmagulu genu, kamba usindila ulagusa kamba hewo wenyego waulema Usenga wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nowalongela ikweli, yodahika wanhu wa viwambo va Sodoma na Gomola koneligwa bazi mdizua da nhaguso kubanza wanhu wa kiwambo hicho! ");
INSERT INTO zaj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Tegelezeni! Nie nowatuma kamba ng'hondolo mdidale da mbwizi, muwe na nzewele kamba nyoka na muwe na moyo uholile kamba hua. ");
INSERT INTO zaj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Iteganyeni na wanhu, kwavija wowagala mweye kukitala, na wowalanha mbalati muna zing'anda zao za nhambiko. ");
INSERT INTO zaj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mogaligwa ha wakulu wa isi na wandewa sama yangu nie, giladi munilavile usindila kumwao na ha Wamhazi. ");
INSERT INTO zaj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Vondamgaligwe mkitala, sambimgelegeze kamba mulonge choni ama mulonge vilihi, kwavija kipigiti kicho mogweleligwa mbuli ya kulonga. ");
INSERT INTO zaj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kwavija sio mweye wondamulonge, ila Loho wa Tata wenu iyo yondayalonge kubitila mweye. ");
INSERT INTO zaj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ndugu komuhonza ndugu yake giladi yakomigwe, na tata komuhonza mwanage, na wana wowahonza watata zao na wamama zao, na kuwatenda wakomigwe. ");
INSERT INTO zaj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mokwihilwa na wanhu wose sama ya twaga jangu. Ila yondayazaganye mbaka hakimambukizo, iyo yondayakomboligwa. ");
INSERT INTO zaj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wahawagaza mkiwambo kimwe, kimbilileni mkiwambo kiyagwe. Nowalongela ikweli, nie, Mwana wa Munhu, nokwiza kipigiti hamnamambukiza kubita m'viwambo vose va Islaeli. ");
INSERT INTO zaj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mwanahina ham'banza mkulufunzi wake, na nyakadala ham'banza mndewa wake. ");
INSERT INTO zaj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yotosha mwanahina kuwa kamba mkulufunzi wake, na nyakadala kuwa kamba mndewa wake. Ihawa mkulu wa ng'anda kokemigwa Belizebuli, haibanza ng'hani wanhu wa ng'anda yake kukemigwa matwaga gehile ng'hani! ");
INSERT INTO zaj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Avo sambimuwadumbe wanhu wano, kwavija haduhu kinhu kigubikigwe chondakileke kugubuligwa, ama kifisigwe chondakileke kutangigwa. ");
INSERT INTO zaj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kiniwalongela mdiziza, kipeteni hamulangaza, na kimuhulika kinyong'onywa, kipeteni mwa wanhu wose. ");
INSERT INTO zaj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Sambimuwadumbe waja wose wokoma lukuli, ila hawadaha kukoma loho, mdumbeni Mulungu yodaha kubananga vose lukuli na loho na kuvasa kuzimu. ");
INSERT INTO zaj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Vitongwa vibili haviuzigwa na hela ndodo? Ila hata kitongwa kimwe hakilagala hasi kamba Tata wenu halondile. ");
INSERT INTO zaj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na hata mvili zose zili mmapala genu zipetwa. ");
INSERT INTO zaj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Avo sambimdumbe, mweye mnogeligwa ng'hani na Mulungu kubanza vitongwa bwando! ");
INSERT INTO zaj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Munhu yoyose yonitogola haulongozi wa wanhu, vivija na nie nomtogola haulongozi wa Tataangu yali kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ila munhu yoyose yonilema haulongozi wa wanhu, vivija na nie nomulema haulongozi wa Tataangu yali kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Sambimgelegeze kamba niza kugala tindiwalo muisi. Bule, sizile kugala tindiwalo, ila zele. ");
INSERT INTO zaj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kwavija niza kugala uhasama ha munhu na tataake, mndele na mamaake, mkemwana na mama mkwe yake, ");
INSERT INTO zaj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","na wadumuka wa munhu iwo waja wali mng'anda yake. ");
INSERT INTO zaj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Munhu yoyose yomnogela tataake ama mamaake kubanza nie, hadaha kuwa mwanahina wangu, vivija yomnogela mmhale wake ama mndele wake kubanza nie, hadaha kuwa mwanahina wangu. ");
INSERT INTO zaj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na munhu yoleka kusola msalaba wake na kunikoleleza, hadaha kuwa mwanahina wangu. ");
INSERT INTO zaj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Munhu yogeza kuukombola ugima wake kowagiza, ila munhu yowagiza ugima wake sama yangu koukombola. ");
INSERT INTO zaj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Munhu yowabokela mweye konibokela nie, na munhu yonibokela nie kom'bokela ija yanhumile nie. ");
INSERT INTO zaj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Munhu yoyose yom'bokela muhokozi kwavija viyali muhokozi, kobokela nhunza kamba iija iyobokela muhokozi. Na munhu yoyose yom'bokela munhu yanogile kwavija viyali munhu yanogile, kobokela nhunza kamba iija iyobokela munhu yanogile. ");
INSERT INTO zaj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nowalongela ikweli, munhu yoyose yolava hata kikasi cha mazi ga uzizimi ha munhu imwe wa wano wadodo kwavija viyali mwanahina wangu, haleka bule kubokela nhunza yake.” ");
INSERT INTO zaj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu viyamambukize kuwagwelela malagizo wanahina zake longo dimwe na wabili, kahalawa haja, kachola kufundiza na kuwapetela wanhu mmiwambo ya isi ya Galilaya. ");
INSERT INTO zaj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohana M'batiza viyakalile mkifungo, kazihulika sang'hano za Kilisto, avo kawalagiza wanahina zake wachole kumwake, ");
INSERT INTO zaj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","wakamuuze, “Gweye iyo ija yokwiza, ama tumulolele iyagwe?” ");
INSERT INTO zaj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu kawedika, “Gendeni mkamulongele Yohana mbuli zimuhulika na kuzona, ");
INSERT INTO zaj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","vimbugumbugu wolola, mbetembete wotembela, wene dikulu wohonywa, vinziwi wohulika, wadanganhike wozuka, na wakumbulu wopeteligwa Usenga Unogile. ");
INSERT INTO zaj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kamota munhu ija nie nilekile kuwa king'hwaso kumwake!” ");
INSERT INTO zaj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wanahina wa Yohana viwacholile, Yesu kasonga kudilongela didale da wanhu mbuli ya Yohana, yolonga, “Mchola kulola choni mkiwala? Ludete vulutigiswa na beho? ");
INSERT INTO zaj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mchola kulola choni? Mchola kumulola munhu yavalile vivalo vinogile? Wanhu wovala vivalo vinogile wokala mming'anda ya kindewa! ");
INSERT INTO zaj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mchola kulola choni? Muhokozi? Ona, nowalongela, yummuwene kana ukulu kubanza muhokozi. ");
INSERT INTO zaj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yohana iyo munhu Nyandiko Zing'alile zimulonga, ‘Nomulagiza msenga wangu yakulongole, yondayaitande nzila yako.’ ");
INSERT INTO zaj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nowalongela ikweli, mmwanza wa wanhu wose waleligwe na watwanzi, haduhu yali mkulu kubanza Yohana M'batiza. Ila munhu yali mdodo kubanza wose muna Undewa wa Kuulanga iyo mkulu kubanza heyo. ");
INSERT INTO zaj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Songela kipigiti cha Yohana M'batiza mbaka sambi, Undewa wa Kuulanga wokwingilwa na mhiko, na wanhu wali na mhiko wogeza kuusamha. ");
INSERT INTO zaj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kwavija wahokozi wose wahokola na Malagizo ga Musa gahokola mbaka kipigiti cha Yohana. ");
INSERT INTO zaj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na kamba motogola, Yohana iyo yalongigwe na wahokozi kamba iyo Eliya yondayeze. ");
INSERT INTO zaj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yali na magwiti na yahulike. ");
INSERT INTO zaj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Vino niwalinganyize na choni wanhu wa mazua gano? Walinga na wana wakalile hadibugano da soko na kuwakema wayagwe, ");
INSERT INTO zaj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tuwatoela ngoma ya lusona lwa zengele, ila mweye ham'vinile! Twimba vawembaga hauzisi, ila mweye hamulilile!’ ");
INSERT INTO zaj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kwavija Yohana viyezile halulukile kuja na kung'wa na hewo walonga, ‘Kana kinyamkela!’ ");
INSERT INTO zaj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana wa Munhu keza yoja na kung'wa, na hewo wolonga, ‘Munhu ino mmelo na mng'waji, mbwiga wa wawila kodi na wene vilozo wayagwe!’ Ila munhu kokoneka kana nzewele sama ya sang'hano zake.” ");
INSERT INTO zaj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Abaho, Yesu kasonga kuwakomhokela wanhu wa miwambo ija mgati yake iyatendile mizonza yake bwando kwavija wanhu zao hawalondile kuleka vilozo vao. ");
INSERT INTO zaj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kojona Kolazini! Kojona Betisaida! Ihawa mizonza itendeke kumwenu kamba ihatendeke Tilo na Sidoni, wanhu zao wahalekile vilozo vao umwaka mkuvala magunia na kukiibakaza mitozi! ");
INSERT INTO zaj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ila nowalongela, yodahika Tilo na Sidoni koneligwa bazi mdizua da nhaguso kubanza mweye! ");
INSERT INTO zaj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na gweye Kapenaumu! Kokiinula mwenyego mbaka kuulanga? Kohumuluswa mbaka kuzimu! Ihawa mizonza itendeke kumwako kamba ihatendeke Sodoma, kiwambo hicho kihakalile baho mbaka lelo! ");
INSERT INTO zaj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ila nowalongela, yodahika Sodoma koneligwa bazi mdizua da nhaguso kubanza mweye!” ");
INSERT INTO zaj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kipigiti kija Yesu kalonga, “Nokugwaa hewela, Tata, Mndewa wa kuulanga na isi, kwavija kuwafisa mbuli zino wanhu wali na nzewele na wasomile, ila kuwagubulila wana wadodo. ");
INSERT INTO zaj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ona, Tata, kwavija vino vivo vuulondile vitendeke. ");
INSERT INTO zaj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Vinhu vose nigweleligwa na Tataangu. Haduhu munhu yomtanga Mwana ila Tata, na haduhu munhu yomtanga Tata ila Mwana na munhu yoyose Mwana yolonda kumgubulila. ");
INSERT INTO zaj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Izoni kumwangu mweye mose mdonhile na mpapa mibahasha mikulu, na nie nowagwelela mhumulo. ");
INSERT INTO zaj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ifungeni nila yangu, na mwiifunze kumwangu, kwavija nie nihola mmoyo na nikiihumulusa, na mweye mopata mhumulo mmioyo yenu. ");
INSERT INTO zaj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwavija nila yangu hailumiza na bahasha yangu ibuha.” ");
INSERT INTO zaj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kipigiti kija Yesu kakala yobita mmigunda ya ngano Mdizua da Mhumulo. Wanahina zake wona nzala, avo wasonga kufyola zisota za gamakungwi ga ngano na kudafuna. ");
INSERT INTO zaj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafalisayo viwawawene, wamulongela Yesu, “Lola, wanahina zako wotenda gagomeswe kutendigwa Mdizua da Mhumulo!” ");
INSERT INTO zaj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu kawedika, “Hamsomile kija chayatendile Daudi kipigiti heyo na wayage viwakalile na nzala? ");
INSERT INTO zaj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kengila mdihema da Mulungu, na heyo na wayage waija imikate ilavigwe nhosa, mbuli igomeswe na Malagizo ga Musa heyo ama wayage kuija, ila wakulu wa nhambiko weiyeka. ");
INSERT INTO zaj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ama, hamsomile muna Gamalagizo ga Musa kamba wakulu wa nhambiko wotenda mbuli zigomesigwe kutendigwa Mdizua da Mhumulo muna Ing'anda ya Mulungu, na hawoneka na Mulungu kamba wotenda mbuli ihile? ");
INSERT INTO zaj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nowalongela, hano hana mkulu kubanza Ng'anda ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ila kamba muhaitangile nhegulo ya ulonzi uno, ulonga, ‘Nolonda bazi na sio nhosa,’ sambimuwataguse wanhu walibule vilozo. ");
INSERT INTO zaj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kwavija, nie, Mwana wa Munhu, nene Mndewa hata Mdizua da Mhumulo.” ");
INSERT INTO zaj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu kahalawa hanhu haja, kengila muna ing'anda yao ya nhambiko, ");
INSERT INTO zaj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","na muja kukala na munhu yaholole mkono. Kuno wozahila kilamso cha kumtagusa, wamuuza, “Malagizo ga Musa gotogoza kumuhonya munhu Mdizua da Mhumulo?” ");
INSERT INTO zaj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu kawalongela, “Munhu yalihi mmwanza wenu yali na ng'hondolo imwe yengile mdikolongo Mdizua da Mhumulo, yondayaleke kumgoga na kumulava hanze? ");
INSERT INTO zaj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Munhu kazama mianza mingahi kubanza ng'hondolo! Avo, Malagizo ga Musa gotogoza kutenda ganogile Mdizua da Mhumulo.” ");
INSERT INTO zaj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Abaho, kamulongela ija imunhu yaholole umkono, “Golosa mkono wako.” Avo kaugolosa, na uwa mgima, kamba uja uyagwe. ");
INSERT INTO zaj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ila, Mafalisayo walawa kunze na kwika zundo wone vija vondawamkome Yesu. ");
INSERT INTO zaj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu viyavitangile kamba wamwikila zundo da kumkoma, kahalawa hanhu haja, na wanhu bwando wamkweleleza. Na heyo kawahonya wanhu wose wakalile watamu, ");
INSERT INTO zaj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","na kuwalagiza sambiwamulonge heyo iyo yalihi. ");
INSERT INTO zaj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mbuli zino zivikiza kija kilongigwe na muhokozi Isaya, ");
INSERT INTO zaj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ino iyo mtumigwa wangu inimsagule, inimnogele, moyo wangu unogelwa nayo. Nomgwelela Loho wangu, na heyo koipeta nhaguso yangu ha Wamhazi. ");
INSERT INTO zaj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hagomba na munhu ama kuguta nyangi, haduhu munhu yondayadihulike dizwi jake mzinzila za m'viwambo. ");
INSERT INTO zaj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Halubena ludete luveduke, ama kuuzima utambi ulava yosi. Mbaka vondayagatende gaja galibule uzenzeleganye gahume, ");
INSERT INTO zaj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","na Wamhazi woditamanila twaga jake.” ");
INSERT INTO zaj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Abaho, wamgalila munhu yali na kinyamkela yakalile kimbugumbugu na bubui, na Yesu kamuwinga ikinyamkela, avo ija imunhu kadaha kulonga na kulola. ");
INSERT INTO zaj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wanhu wose wakanganya na kulonga, “Vodahika ino kuwa Kilisto, Mwana wa Daudi?” ");
INSERT INTO zaj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mafalisayo viwahulike vino, walonga, “Munhu ino kowinga vinyamkela na udaho wa Belizebuli tu, mkulu wa vinyamkela.” ");
INSERT INTO zaj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu kazitanga ngelegeza zao, kawalongela, “Undewa wowose uhaigola mmadalemadale, gogomba genyego kwa genyego, undewa hiwo haugendelela. Na wambo jojose ama mulango uhaigola mmadalemadale, gogomba genyego kwa genyego, mulango hiwo hawima. ");
INSERT INTO zaj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ihawa Mwenembago kowinga vinyamkela, kokiigola mwenyego, avo, undewa wake wodahaze kwima? ");
INSERT INTO zaj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na kamba nowinga vinyamkela na udaho wa Belizebuli, wanhu zenu wowinga vinyamkela na udaho waki? Avo, hewo wao wondawawataguse! ");
INSERT INTO zaj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ila kamba nowinga vinyamkela na Loho wa Mulungu, avo, Undewa wa Mulungu uwezila. ");
INSERT INTO zaj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ama kodahaze munhu kwingila muna ing'anda ya munhu yali na mhiko na kum'bokonya vinhu vake, kamba hamfungile tanhu, leka yadahe kum'bokonya vinhu vili mng'anda yake? ");
INSERT INTO zaj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Munhu yoyose yalekile kuwa hamoja na nie, konibeza, na munhu yoyose yalekile kukunzanya na nie, kopwililisa. ");
INSERT INTO zaj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nowalongela, vilozo vose na ufukuzi wose wogeligwa kumgongo, ila ufukuzi wa kumfukulila Loho wa Mulungu haugeligwa kumgongo. ");
INSERT INTO zaj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Munhu yoyose yonilonga vihile nie, Mwana wa Munhu, vodahika kugeligwa kumgongo, ila munhu yoyose yomulonga vihile Loho wa Mulungu havidahika kugeligwa kumgongo, muulumwengu uno ama kuulumwengu ukwiza. ");
INSERT INTO zaj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“M'biki uhanoga na mujo wake wonoga, na m'biki uheha vivija na mujo wake wokwiha. Kwavija m'biki wotangigwa sama ya mujo wake. ");
INSERT INTO zaj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mweye wana wa nyoka! Modahaze kulonga kinhu kinogile na ihawa mweye wenyego mwiha? Kwavija munhu kolonga gaja gaumemeze moyo wake. ");
INSERT INTO zaj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Munhu yanogile kolava ganogile kulawa muna ingama ya moyo wake unogile, na munhu yehile kolava gehile kulawa muna ingama ya moyo wake wihile. ");
INSERT INTO zaj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nowalongela kamba, mdizua da nhaguso wanhu wolava mheta ya kila mbuli ihile iwailongile. ");
INSERT INTO zaj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kwavija kubitila mbuli zako kopeteligwa ganogile, na kubitila mbuli zako kotagusigwa.” ");
INSERT INTO zaj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Abaho, wafundiza Malagizo ga Musa na Mafalisayo wamulongela, “Mkulufunzi, tolonda tone mizonza kulawa kumwako.” ");
INSERT INTO zaj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu kedika kalonga, “Wanhu wa mulelo wihile na uleka kumtamanila Mulungu wolonda kilaguso! Ila hawagweleligwa kilaguso, ila kilaguso cha muhokozi Yona. ");
INSERT INTO zaj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kamba vija Yona viyakalile muna iinda ya isomba mkulu ng'hani mazua madatu, vivija nie, Mwana wa Munhu, nokala muna umoyo wa iisi mazua madatu. ");
INSERT INTO zaj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mdizua da nhaguso wanhu wa Ninawi wokwima na wanhu wa mulelo uno na kuwatagusa mweye, kwavija hewo waleka vilozo vao viwamuhulike Yona viyakalile yopeta. Na hano hana mkulu kubanza Yona! ");
INSERT INTO zaj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mdizua da nhaguso Malikia wa Kusi kokwima na wanhu wa mulelo uno na kuwatagusa mweye, kwavija heyo keza kulawa kuzisota za iisi giladi yategeleze ng'hungwe ya Selemani. Na hano hana mkulu kubanza Selemani! ");
INSERT INTO zaj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kinyamkela yahamulawa munhu, kochola kubitila hanhu hanyalile yozahila hanhu ha kuhumula, ila hahapata. ");
INSERT INTO zaj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Abaho, kolonga, ‘Nobweleganya kung'anda yangu kunilawile.’ Yahabwela na kuivika ing'anda yabule kinhu, ifagiligwa, na kuhambigwa, ");
INSERT INTO zaj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","kochola kuwasola vinyamkela wayagwe saba wehile kubanza heyo mwenyego, wokwingila na kukala himo. Na hali ya munhu hiyo yokwiha ng'hani kubanza ija ya haichanduso. Vino vivo vondaiwe ha wanhu wa mulelo uno wihile.” ");
INSERT INTO zaj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu viyakalile yang'hali yolonga na dale da wanhu, mamaake na ndugu zake wema hanze, walonda kulonga nayo. ");
INSERT INTO zaj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Munhu imwe kamulongela, “Mamaako na ndugu zako wema hanze, wolonda kulonga nagwe.” ");
INSERT INTO zaj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu kamwidika ija imunhu yamulongele, “Mamaangu iyo yalihi? Na ndugu zangu wawo walihi?” ");
INSERT INTO zaj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kuno yowalinga kidole wanahina zake kalonga, “Wano wao mamaangu na ndugu zangu! ");
INSERT INTO zaj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kwavija munhu yoyose yogatenda goyolonda Tataangu wa kuulanga iyo ndugu yangu, lumbu jangu na mamaangu.” ");
INSERT INTO zaj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Zua didija Yesu kalawa muna ing'anda, kakala hamgwazo wa idilamba. ");
INSERT INTO zaj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Dale kulu da wanhu dimzunguluka, avo kakwela na kukala muna ingalawa. Na didale da wanhu dima mumgwazo wa idilamba. ");
INSERT INTO zaj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kawalongela vinhu bwando mmahala. “Mulimi kachola kuhanda mbeyu. ");
INSERT INTO zaj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Viyakalile yozihanda, ziyagwe zilagalila mnzila, na ndege weza wazija. ");
INSERT INTO zaj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mbeyu ziyagwe zilagalila mmabwe kukalile na ulongo mdodo. Avo zota himahima kwavija ulongo ukala mdodo. ");
INSERT INTO zaj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ila zua vidilawile diilukuza imiche na kwavija mizizi yake haingile hasi ng'hani imiche inyala. ");
INSERT INTO zaj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbeyu ziyagwe zilagalila mmizomola, imizomola ikula na kuizingiliza imiche. ");
INSERT INTO zaj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ila mbeyu ziyagwe zilagalila muulongo unogile, ziyagwe zilela mia, ziyagwe zilela malongo sita, na ziyagwe zilela malongo madatu. ");
INSERT INTO zaj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yali na magwiti na yahulike.” ");
INSERT INTO zaj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Abaho, wanahina wamcholela Yesu wamuuza, “Habali ulonga na wanhu mmahala?” ");
INSERT INTO zaj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu kawalongela, “Mweye mgweleligwa nzewele za kuzitanga nyong'onyo za Undewa wa Kuulanga, ila hewo hawagweleligwe. ");
INSERT INTO zaj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Munhu yali na kinhu kokongezelwa na kowa navo bwando, ila munhu yalibule kinhu hata kija ikidodo chayalinacho kobokigwa. ");
INSERT INTO zaj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kilamso cha kulonga nao mmahala kicho kino, kamba wolola ila hawona kinhu, na wotegeleza ila hawahulika ama hawavitanga. ");
INSERT INTO zaj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Uhokozi wa Isaya uvikila kumwao, ‘Kuhulika mohulika, ila ham'vitanga, kulola molola, ila ham'vimanya, ");
INSERT INTO zaj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","kwavija wanhu wano wana mioyo midala, magwiti gao wagatenda sambigahulike, na meso gao wafing'hiliza. Ila kamba meso gao gahalolile, na magwiti gao gahahulike, wahavitangile mmioyo yao, na kunihindukila nie, nihawahonyile.’ ");
INSERT INTO zaj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ila gamota meso genu, kwavija golola, na magwiti genu, gohulika. ");
INSERT INTO zaj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nowalongela ikweli, wahokozi na wanhu bwando walibule uzenzeleganye wasulukila kugona gano gomgona mweye, ila hawagonile, na wasulukila kugahulika gano gomuhulika mweye, ila hawagahulike. ");
INSERT INTO zaj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Tegelezeni nhegulo ya dihala da mulimi. ");
INSERT INTO zaj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Munhu yoyose yohulika Usenga wa Undewa wa Kuulanga ila hautanga, Mwenembago kokwiza na kuusamha uja Usenga uhandigwe mmoyo wake, zino zizo mbeyu zilagalile mnzila. ");
INSERT INTO zaj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbeyu zilagalile mmabwe zizo Usenga uyahulike munhu, na baho koubokela mkudeng'ha. ");
INSERT INTO zaj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ila kwavija ukala na mizizi midodo, avo wokala mkipigiti kiguhi. Na kiheza kipigiti cha mgayo ama kugazigwa sama ya Usenga wa Mulungu, baho kobwela kukisogo. ");
INSERT INTO zaj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mbeyu zilagalile mmizomola, zizo zimbuli ziyahulike munhu, ila bwembwe da ulumwengu uno na unogelo wa mali wozizingiliza na kuzitenda sambizilele. ");
INSERT INTO zaj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ila mbeyu ilagalile muulongo unogile iyo munhu yaihulike imbuli na kuitanga, abaho, kalela mijo bwando, imwe kalela mia, iyagwe malongo sita, na iyagwe malongo madatu.” ");
INSERT INTO zaj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu kawalongela hala diyagwe, “Undewa wa Kuulanga ulinga na munhu yahandile mbeyu inogile mumgunda wake. ");
INSERT INTO zaj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ila wanhu wose viwakalile wawasile, mdumuka wake keza kahanda lolo muingano, abaho, kachola. ");
INSERT INTO zaj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ija ingano viyotile na kusonga kufumula, idilolo disonga koneka. ");
INSERT INTO zaj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nyakadala wa ija mwene mgunda keza kamulongela, ‘Mndewa, huhandile mbeyu zinogile mumgunda wako? Dilolo dilawa kwahi?’ ");
INSERT INTO zaj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kamwidika, kamulongela, ‘Mdumuka iyo yatendile vino.’ Abaho, ija inyakadala kamuuza, ‘Kolonda tweye tuchole tukading'ole dilolo?’ ");
INSERT INTO zaj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kamulongela, ‘Bule, kwavija kipigiti vondamding'ole dilolo, moding'ola hamoja na ingano. ");
INSERT INTO zaj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Leka ingano na idilolo vose vikule hamoja mbaka kipigiti cha kuhuna. Na kipigiti hicho nowalongela wahunaji, tanhu dilundizeni idilolo, mdifunge makinzamakinza mkadisome moto, abaho, ilundizeni ingano mkaike kukano jangu.’ ” ");
INSERT INTO zaj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu kawalongela hala diyagwe, “Undewa wa Kuulanga ulinga na mbeyu ya haladali yaaisolile munhu na kuihanda mumgunda wake. ");
INSERT INTO zaj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mbeyu ndodo kubanza zose, ila ihakula yowa mche mkulu kubanza miche yose mkihati na hata kuwa biki kulu. Avo ndege wa kuulanga wokwiza na kuzenga mvulu mmatambi gake.” ");
INSERT INTO zaj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu kawalongela hala diyagwe, “Undewa wa Kuulanga ulinga na mela dodo diyasolile mtwanzi na kuditibuliza muna ivibaba vidatu va usage mbaka tonge jose dilulumuka.” ");
INSERT INTO zaj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu kawalongela wanhu bwando mbuli zino zose mmahala, hawalongele kinhu chochose bila mahala. ");
INSERT INTO zaj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Giladi gaja galongigwe na muhokozi gavikile, “Nounanula mulomo wangu nilonge mmahala, Nilonge gaja gafisike songela ulumwengu vuulumbigwe.” ");
INSERT INTO zaj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Abaho, Yesu kadileka didale da wanhu, kengila mng'anda. Wanahina zake wamkwenhukila wamulongela, “Tulongele nhegulo ya dihala da idilolo da kumgunda.” ");
INSERT INTO zaj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu kawalongela, “Imunhu yahandile imbeyu inogile iyo nie, Mwana wa Munhu, ");
INSERT INTO zaj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","umgunda uwo ulumwengu, na imbeyu inogile iyo wana wa Undewa wa Kuulanga, na idilolo dijo wanhu wa Mwenembago, ");
INSERT INTO zaj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","na imdumuka yahandile idilolo iyo Mwenembago. Gakuhuna gago zua da kimambukizo, na iwahunaji wao wasenga wa Mulungu wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kamba vija idilolo vidilundizwe na kusomigwa moto, vivo vondaiwe muna dizua da kimambukizo. ");
INSERT INTO zaj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nie, Mwana wa Munhu, nowalagiza wasenga zangu wa kuulanga wavikunzanye na kuvilava hanze ya Undewa wake vija vose viwatenda wanhu watende vilozo, na waja wose watenda vilozo ");
INSERT INTO zaj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na kuwasa mditanuli da moto. Ako kowa na kililo na kugegedula meno. ");
INSERT INTO zaj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Abaho, wanhu wamnogele Mulungu wonang'hazika kamba zua Muundewa wa Tataao. Munhu yali na magwiti na yahulike! ");
INSERT INTO zaj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Undewa wa Kuulanga ulinga na ngama ifisigwe mumgunda. Na munhu imwe viyaiwene, kaifisa kabili, mkudeng'ha kachola kuguza vinhu vake vose viyalinavo, na kuugula mgunda uja. ");
INSERT INTO zaj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Vivija, Undewa wa Kuulanga ulinga na mchuluzi yozahila lulu zinogile, ");
INSERT INTO zaj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","na viyaiwene lulu imwe ya hela bwando, kachola na kuguza vinhu vake vose viyalinavo, na kuigula. ");
INSERT INTO zaj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Vivija, Undewa wa Kuulanga ulinga na nhando itandigwe m'bahali na kunamata somba wa namna zose. ");
INSERT INTO zaj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Inhando viimemile, waikwekwesa waigala mhwani, abaho, wakala hasi na kuwabagula iwasomba, wanogile waweka muna imigelo na wehila wawasa. ");
INSERT INTO zaj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Vivo vondaiwe mdizua da kimambukizo, wasenga wa Mulungu wa kuulanga wokwiza na kuwabagula wanhu wehile kulawa mwa wanhu watendile ganogile, ");
INSERT INTO zaj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na kuwasa wanhu wehile mditanuli da moto. Ako kowa na kililo na kugegedula meno.” ");
INSERT INTO zaj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu kawauza, “Movitanga vinhu vino vose?” Wamwidika, “Ona.” ");
INSERT INTO zaj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesu kawalongela, “Avo mfundiza yoyose wa Malagizo ga Musa yafundizigwe mbuli za Undewa wa Kuulanga kalinga na mwene ng'anda yolava vinhu va sambi na va umwaka kulawa muna ingama yake.” ");
INSERT INTO zaj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu viyamambukize kulonga mahala gano, kahalawa hanhu haja, ");
INSERT INTO zaj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","kabwela hana ikiwambo chake kikemigwa Nazaleti. Kasonga kuwafundiza wanhu muna zing'anda zao za nhambiko, avo, wakanganya na kulonga, “Kaipata kwahi ng'hungwe ino na mhiko za kutenda mizonza? ");
INSERT INTO zaj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ino sio mwana wa salamala? Na mamaake hakemigwa Maliamu? Na ndugu zake sio kina Yakobo, Usufu, Simoni, na Yuda? ");
INSERT INTO zaj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na lumbu zake wose hawali hano hamoja na tweye? Avo munhu ino kazipata kwahi mhiko na nzewele zino zose?” ");
INSERT INTO zaj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Avo hawanogelwe nayo. Ila Yesu kawalongela, “Muhokozi kohishimilwa kila hanhu, ila mkiwambo chake mwenyego na mng'anda yake mwenyego.” ");
INSERT INTO zaj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Avo hatendile mizonza bwando hanhu haja kwavija wakala wabule nhamanila. ");
INSERT INTO zaj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kipigiti kija Helode Antipa, mtawala wa Galilaya, kahulika mbuli za Yesu, ");
INSERT INTO zaj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","avo kawalongela watumigwa zake, “Ino iyo Yohana M'batiza, kazuka kulawa mwa wanhu wadanganhike, kileka mana mhiko za kutenda mizonza zosang'hanika mgati yake.” ");
INSERT INTO zaj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kwavija Helode kakala yamgogile Yohana, kamfunga nzabi na kumgela mkifungo sama ya Helodia, mtwanzi wa mkulu wake yokemigwa Filipo. ");
INSERT INTO zaj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kwavija Yohana kakala yomulongela Helode, “Kutenda gagomeswe na Malagizo ga Musa kumsola Helodia!” ");
INSERT INTO zaj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helode kalonda kumkoma Yohana, ila kawadumba wanhu kwavija wakala wampetile kamba Yohana kakala muhokozi. ");
INSERT INTO zaj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Muna dizua da lusona lwa ng'humbukila ya mvumbuka ya Helode, mndele wa Helodia kavina haulongozi wa iwahenza. Helode kanogelwa, ");
INSERT INTO zaj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kamduilila na kamulongela kamba komgwelela kinhu chochose chondayapule. ");
INSERT INTO zaj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kuno yoswagizwa na mamaake, kalonga, “Nigwelele pala da Yohana M'batiza bahano muna ulungo!” ");
INSERT INTO zaj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mndewa kona giogio ng'hani, ila sama ya kiduilo chayaiduile na sama ya iwahenza wakalile haja, kalagiza yagweleligwe, ");
INSERT INTO zaj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","avo kalagiza pala da Yohana dikanhigwe muja mkifungo. ");
INSERT INTO zaj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pala jake digaligwa mulungo na kugweleligwa imndele, na heyo kamgalila mamaake. ");
INSERT INTO zaj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wanahina wa Yohana weza na kulusola lukuli lwake na kuluzika. Abaho, wachola kumulongela Yesu gaja galawilile. ");
INSERT INTO zaj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu viyahulike mbuli za Yohana, kanyelenhuka kulawa hanhu haja kakwela mngalawa kachola hanhu halibule wanhu. Ila wanhu viwahulike, walawa m'viwambo wamkoleleza na magulu. ");
INSERT INTO zaj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu viyahumuluke muna ingalawa, kawonela bazi na kuwahonya wanhu zao wakalile watamu. ");
INSERT INTO zaj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Viivikile ichungulo wanahina wamcholela wamulongela, “Zua diswa na hano twa mkiwala, avo walongele iwanhu wachole m'viwambo wakaigulile mandia.” ");
INSERT INTO zaj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu kawedika, “Hawalondigwa wachole, wagweleleni mweye kinhu cha kuja!” ");
INSERT INTO zaj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Na hewo wamulongela, “Hano twabule kinhu ila mikate mitano na somba wabili viiyeka.” ");
INSERT INTO zaj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu kawalongela, “Vigaleni hano hamwangu.” ");
INSERT INTO zaj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kawalagiza wanhu wakale hasi muluzondo, abaho, kaisola imikate mitano na iwasomba wabili, kalola kuulanga, na kumuheweza Mulungu. Abaho kaimogola imikate, kawagwelela wanahina, na wanahina wawagwelela iwanhu. ");
INSERT INTO zaj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wose waja na kwiguta. Abaho wanahina wadondola vidanga va imikate na iwasomba visigale, wamemeza vigelo longo dimwe na vibili. ");
INSERT INTO zaj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mheta ya wanhu wadile imikate wakala wambigalo alufu tano, uhaleka watwanzi na wana. ");
INSERT INTO zaj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Abaho, Yesu kawalagiza wanahina wakwele muna ingalawa wamulongole mwambu uyagwe wa idilamba, kipigiti heyo vayakalile yowalaga wanhu. ");
INSERT INTO zaj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Viyamambukize kuwalaga, kakwela hakigongo yeiyeka kutambika. Na zua vidiswele, Yesu kakala hiko yeiyeka. ");
INSERT INTO zaj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ila kipigiti kino ingalawa ikala kutali na iisi inyalile, ikunhizwa na mawimbi kwavija beho dikala dolawa kuulongozi wa ingalawa. ");
INSERT INTO zaj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mkipigiti cha nzogolo zikwika Yesu kawacholela wanahina zake, yotembela uchana ya igamazi. ");
INSERT INTO zaj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wanahina viwamuwene yotembela uchana ya igamazi, wona bwembwe, walonga, “Mzimu!” Waguta nyangi kuno wogudema. ");
INSERT INTO zaj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bahaja Yesu kawalongela, “Gangamaleni! Iyo nene, sambimdumbe!” ");
INSERT INTO zaj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petulo kamulongela, “Mndewa, kamba iyo gweye, nilagize nitembele uchana ya gamazi nize kumwako.” ");
INSERT INTO zaj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu kamwidika, “Izo!” Avo Petulo kahumuluka muna ingalawa, na kutembela uchana ya gamazi, na kumcholela Yesu. ");
INSERT INTO zaj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ila viyadiwene dibeho, kadumba, na kusonga kudidimila muna gamazi, kaguta nyangi yolonga, “Mndewa, nikombole!” ");
INSERT INTO zaj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Bahaja Yesu kagolosa mkono wake, kamgoga kamulongela, “Gweye uli na nhamanila ndodo! Habali usinha?” ");
INSERT INTO zaj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na viwakwelile muna ingalawa, dibeho dinyamala. ");
INSERT INTO zaj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wose wakalile muna ingalawa wamtambikila walonga, “Kweli gweye iyo Mwana wa Mulungu!” ");
INSERT INTO zaj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Viweshile kuloka idilamba, wavika kuna iisi ya Genesaleti. ");
INSERT INTO zaj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wanhu wa hiko viwamtangile Yesu, wabwililisa mbuli zake m'viwambo vose vili mmambwegambwega, na wamgalila wanhu wose wakalile watamu. ");
INSERT INTO zaj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wamuyalalila kamba yawaleke wanhu wakalile watamu wakwase lugigo lwa guo jake, na wose walukwasile wahona. ");
INSERT INTO zaj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Abaho, Mafalisayo na wafundiza Malagizo ga Musa kulawa Yelusalemu wamcholela Yesu, wamuuza, ");
INSERT INTO zaj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Habali wanahina zako hawaziwinza nzoela za wahenga zetu? Kwavija wahalonda kuja hawasuluza makono gao!” ");
INSERT INTO zaj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu kawedika, “Na mweye habali muileka ndagizi ya Mulungu sama ya nzoela yenu? ");
INSERT INTO zaj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kwavija Mulungu kalonga, ‘Wahishimile tataako na mamaako,’ na ‘Munhu yoyose yomulonga vihile tataake ama mamaake, yakomigwe.’ ");
INSERT INTO zaj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ila mweye molonga kamba, mduhu mbuli munhu yahamulongela tataake ama mamaake kamba, ‘Sidaha kuwagwelela kinhu chochose kwavija niiduila kamba vinhu vinilondile kuwagwelela mweye nivilave ha Mulungu,’ ");
INSERT INTO zaj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Avo, mmbuli zino mowalongela wanhu sambiwawahishimile watata na wamama zao. Avo muizabuza mbuli ya Mulungu sama ya kuiwinza nzoela yenu. ");
INSERT INTO zaj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Videlenya mweye, muhokozi Isaya kahokola goya yowalonga mweye haja viyalongile, ");
INSERT INTO zaj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Mulungu kalonga, “Wanhu wano wonihishimila nie mmilomo yao, ila mioyo yao yakutali na nie. ");
INSERT INTO zaj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wonitambikila nie bule, kwavija wofundiza mafundo ga wanhu kamba Malagizo gangu!” ’ ” ");
INSERT INTO zaj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Abaho, Yesu kadikema didale da wanhu na kudilongela, “Tegelezeni na kuvitanga! ");
INSERT INTO zaj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Haduhu kinhu chondakingile mmulomo wa munhu chondakimtende yanyolodoke, ila munhu konyolodoswa na mbuli zilawa mmulomo wake.” ");
INSERT INTO zaj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Abaho, wanahina wamcholela wamulongela, “Kuvitanga kamba Mafalisayo wehilwa viwazihulike mbuli zuulongile?” ");
INSERT INTO zaj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu kawalongela, “M'biki wowose hauhandigwe na Tataangu wa kuulanga wong'oligwa. ");
INSERT INTO zaj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Walekeni! Hewo wawo vilangizi vimbugumbugu wowalongoza vimbugumbugu wayao. Na kamba kimbugumbugu yahamulongoza kimbugumbugu miyage, wose wolagalila mdikolongo.” ");
INSERT INTO zaj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petulo kamulongela, “Tulongele nhegulo ya hala dino.” ");
INSERT INTO zaj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu kawalongela, “Vivija na mweye mng'hali hamnavitanga? ");
INSERT INTO zaj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ham'vitanga kamba kinhu chochose kingila mmulomo, chokwingila mmunda, abaho, cholawa hanze ya ulukuli? ");
INSERT INTO zaj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ila mbuli zilawa mmulomo, zolawa muna umoyo, na mbuli zino zizo zimtenda munhu yanyolodoke. ");
INSERT INTO zaj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kwavija kulawa mmoyo zolawa ngelegeza zihile, kukoma, ugoni, ushalati, ubavi, usindila wa uvwizi, na kuilonga vihile. ");
INSERT INTO zaj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gano gago gomtenda munhu yanyolodoke, ila kuja bila kusuluza makono, hakumtenda munhu yanyolodoke.” ");
INSERT INTO zaj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu kahalawa hanhu haja, kachola kuziisi za Tilo na Sidoni. ");
INSERT INTO zaj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na mtwanzi imwe Mkanaani, kulawa muisi ija, kamcholela. Kenula dizwi, kamulongela, “Mndewa, Mwana wa Daudi, nyonela bazi! Mndele wangu kogazigwa ng'hani na kinyamkela.” ");
INSERT INTO zaj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ila Yesu hamwidike. Wanahina zake wamcholela wamuyalalila, wolonga, “Muleke yachole! Kwavija kotutoela nyangi kuchugu chetu!” ");
INSERT INTO zaj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu kalonga, “Nie nitumigwa sama ya ng'hondolo wapotele wa isi ya Islaeli.” ");
INSERT INTO zaj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ija mtwanzi kamcholela Yesu na kumfugamila mavindi kamulongela, “Mndewa, nhaza!” ");
INSERT INTO zaj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu kedika, “Havilumbile kusola mandia ga wana na kuwasila umbwa.” ");
INSERT INTO zaj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ija mtwanzi kamulongela, “Ona, Mndewa, ila hata umbwa woja mandia gasigale galagale hasi kulawa haimeza ya mndewa wao.” ");
INSERT INTO zaj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Abaho, Yesu kamulongela, “Gweye mtwanzi, nhamanila yako ng'hulu! Na iwe kumwako kamba vuulonda.” Na kipigiti kikija mndele wake kahona. ");
INSERT INTO zaj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu kahalawa haja, kabita mumgwazo wa Idilamba da Galilaya. Kakwela hakigongo, kakala hasi. ");
INSERT INTO zaj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Wanhu bwando wamcholela, wamgalila walemale, vimbugumbugu, mbetembete, bubui, na wayagwe bwando, na kuweka haulongozi wa Yesu, na heyo kawahonya. ");
INSERT INTO zaj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wanhu wakanganya viwawawene mabubui wolonga, walemale wahonyigwa, mbetembete wotembela, na vimbugumbugu wolola. Wamuyenzi Mulungu wa Islaeli. ");
INSERT INTO zaj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu kawakema wanahina zake kawalongela, “Nowonela bazi wanhu wano, kwavija wakala na nie mazua madatu na sambi wabule kinhu cha kuja kisigale. Na nie silonda niwaleke wachole na nzala, sambiweze kusinduka mnzila.” ");
INSERT INTO zaj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wanahina zake wamulongela, “Kwahi kondatupate mandia ga kuwegutiza wanhu bwando kamba wano mkiwala kino?” ");
INSERT INTO zaj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu kawauza, “Mikate mingahi imulinayo?” Wamulongela, “Mikate saba na visomba vidogodogo.” ");
INSERT INTO zaj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Avo Yesu kawalagiza waja iwanhu wakale hasi. ");
INSERT INTO zaj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kaisola imikate saba na ivisomba, kamuheweza Mulungu, abaho, kaimogola na kuwagwelela wanahina, na wanahina wadigwelela didale da wanhu. ");
INSERT INTO zaj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wose waja na kwiguta. Abaho, wanahina wadondola vidanga va imikate na ivisomba visigale, wamemeza migelo saba. ");
INSERT INTO zaj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wanhu wose wadile wakala wambigalo alufu nne uhaleka watwanzi na wana. ");
INSERT INTO zaj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu viyeshile kudilaga didale da wanhu, kakwela muna ingalawa, kachola kuisi ya Magadani. ");
INSERT INTO zaj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafalisayo na Masadukayo wamcholela Yesu, wamgeza mkumulonda yawalagusile kilaguso kulawa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu kawedika, “Ihavika ichungulo, molonga, ‘Kowa na mchesa, kwavija ulanga mdung'hu.’ ");
INSERT INTO zaj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na imitondo molonga, ‘Lelo kowa na mvula, kwavija ulanga una udung'hu na utitu.’ Mweye movitanga kuzuza vinhu vikoneka kuulanga, ila hamudahile kuzuza vilaguso va vipigiti vino! ");
INSERT INTO zaj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mulelo wihile na uleka kumtamanila Mulungu! Wolonda kilaguso! Ila hawagweleligwa kilaguso, ila kilaguso cha muhokozi Yona.” Abaho, Yesu kawaleka, kachola. ");
INSERT INTO zaj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wanahina viwavikile mwambu uyagwe wa idilamba, wavitanga kamba waisemwa kusola mikate. ");
INSERT INTO zaj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu kawalongela, “Loleni na muiteganye na mela da Mafalisayo na Masadukayo.” ");
INSERT INTO zaj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wailongela wenyego kwa wenyego, wolonga, “Kalonga vino kwavija tuleka kusola mikate.” ");
INSERT INTO zaj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu kagatanga gaja gawakalile wolonga, na heyo kawalongela, “Mweye wanhu muli na nhamanila ndodo, habali mulongelela mbuli za kuwa bule mikate? ");
INSERT INTO zaj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mng'hali hamnavitanga? Muisemwa ija imikate mitano iwadile wambigalo alufu tano, na mkunzanya vigelo vingahi vimemile? ");
INSERT INTO zaj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ama ija imikate saba iwadile wambigalo alufu nne, na mkunzanya migelo mingahi imemile? ");
INSERT INTO zaj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Vilihi ham'vitanga kamba sikalile nilonga na mweye mmbuli ya mikate? Iteganyeni na mela da Mafalisayo na Masadukayo!” ");
INSERT INTO zaj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Abaho, wavitanga kamba Yesu hakalile yowazuma waiteganye na mela da kugela mmikate, ila waiteganye na mafundo ga Mafalisayo na Masadukayo. ");
INSERT INTO zaj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu kachola kuisi ili behi na wambo da Kaisalia Filipi, kawauza wanahina zake, “Wanhu wolonga kamba Mwana wa Munhu iyo yalihi?” ");
INSERT INTO zaj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wamwidika wamulongela, “Wayagwe wolonga Yohana M'batiza, wayagwe wolonga Eliya, na wayagwe wolonga Yelemia ama imwe wa wahokozi.” ");
INSERT INTO zaj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu kawauza, “Ila na mweye molonga nie iyo yalihi?” ");
INSERT INTO zaj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petulo kamwidika, “Gweye iyo Kilisto, Mwana wa Mulungu yali na ugima.” ");
INSERT INTO zaj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu kamulongela, “Kumota Simoni, mwana wa Yohana! Kwavija haduhu munhu yakugubulile gano, ila Tataangu wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nokulongela kamba gweye iyo Petulo, na mdibwe dino nodizenga kanisa jangu, na mhiko za kuzimu hazidaha kudihuma. ");
INSERT INTO zaj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nokugwelela vivugulilo va Undewa wa Kuulanga, chochose chondaukifunge muna iisi, chofungigwa kuulanga. Na chochose chondaukifungule muna iisi, chofunguligwa kuulanga.” ");
INSERT INTO zaj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Abaho, Yesu kawazuma wanahina zake kamba sambiwamulongele munhu yoyose kamba heyo iyo Kilisto. ");
INSERT INTO zaj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Songela kipigiti kija Yesu kasonga kuwalongela wanahina zake, “Nolondigwa nichole Yelusalemu, na hiko nogazigwa na wavyele, na wakulu wa wakulu wa nhambiko, na wafundiza Malagizo ga Musa. Nokomigwa, ila gahabita mazua madatu nozuka kulawa mkudanganhika.” ");
INSERT INTO zaj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petulo kamsola kamgala hamgwazo na kusonga kumkomhokela yolonga, “Sambiiwe vino, Mndewa! Mbuli hiyo haikulawila gweye!” ");
INSERT INTO zaj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu kahinduka kamulongela Petulo, “Bwela kuchugu changu, Mwenembago! Gweye kwa king'hwaso kumwangu nie, kwavija hugelegeza ga Mulungu, ila kogelegeza ga wanhu.” ");
INSERT INTO zaj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Abaho, Yesu kawalongela wanahina zake, “Kamba munhu yahalonda kuwa mwanahina wangu, yaibele mwenyego, yaidikwe msalaba wake yanikoleleze. ");
INSERT INTO zaj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Munhu yoyose yahalonda kuukombola ugima wake, kowagiza, na munhu yoyose yowagiza ugima wake sama yangu nie, koukombola. ");
INSERT INTO zaj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kinhu chaki kinogile munhu chondayakipate kamba yahaupata ulumwengu wose, na kuwagiza ugima wake uli muloho? Ama kinhu chaki chondayalave giladi yabwezelwe ugima wake uli muloho? ");
INSERT INTO zaj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kwavija nie, Mwana wa Munhu, nokwiza na wasenga zangu wa Mulungu wa kuulanga muna iyenzi ya Tataangu, abaho, nomuliha kila munhu kamba vija viyasang'hane. ");
INSERT INTO zaj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nowalongela ikweli, hana wanhu wayagwe wemile hano hawadanganhika mbaka vondawanyone nie Mwana wa Munhu, nikwiza muna Uundewa wangu.” ");
INSERT INTO zaj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Vigabitile mazua sita Yesu kawasola Petulo, Yakobo, na Yohana ndugu yake Yakobo kakwela nao kukigongo kitali weiyeka. ");
INSERT INTO zaj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yesu kagaluka haulongozi wao, na kihanga chake kinang'hazika kamba zua, na vivalo vake vikala vizelu kamba mulangaza. ");
INSERT INTO zaj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Bahaja, walawililwa na Musa na Eliya, wolonga na Yesu. ");
INSERT INTO zaj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petulo kamulongela Yesu, “Mndewa, vinoga tweye tukale hano! Na uhalonda nozenga vizewe vidatu, kimwe chako, kimwe cha Musa, na kiyagwe cha Eliya.” ");
INSERT INTO zaj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Viyakalile yang'hali yolonga, wingu zelu diwagubika, na dihulikwa dizwi kulawa mdiwingu dilonga, “Ino iyo Mwanangu yanogele, mtegelezeni heyo!” ");
INSERT INTO zaj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wanahina viwahulike vino, wagwa kingubanguba, wona bwembwe ng'hani. ");
INSERT INTO zaj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu kawacholela, abaho, kawakwasa kawalongela, “Gandamukeni, sambimdumbe!” ");
INSERT INTO zaj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Na viwalolile uchana, hawamuwene munhu yoyose ila Yesu yeiyeka. ");
INSERT INTO zaj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Viwahumuluke haikigongo, Yesu kawalagiza yolonga, “Sambimmulongele munhu yoyose gaja gamgawene, mbaka nie, Mwana wa Munhu, vondanizuke kulawa mkudanganhika.” ");
INSERT INTO zaj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Abaho, wanahina wamuuza Yesu, “Habali wafundiza Malagizo ga Musa wolonga kamba tanhu Eliya yeze?” ");
INSERT INTO zaj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu kawalongela, “Kweli, Eliya kokwiza kwika goya vinhu vose. ");
INSERT INTO zaj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ila nowalongela, Eliya keza kesha, na hewo hawamtambule, ila wamtendela vija viwalondile. Vivija na heyo Mwana wa Munhu kogazigwa mmakono gao.” ");
INSERT INTO zaj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Abaho, wanahina wavitanga kamba kakala yowalongela mbuli za Yohana M'batiza. ");
INSERT INTO zaj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Viwavikile hana ididale da wanhu, munhu imwe kamcholela Yesu kamfugamila mavindi, ");
INSERT INTO zaj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","kamulongela, “Mndewa, monele bazi mmhale wangu, kwavija kana kisango na kugazika ng'hani. Mianza bwando kalagalila hamoto ama mgamazi. ");
INSERT INTO zaj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nimgala ha wanahina zako, ila walemelwa kumuhonya.” ");
INSERT INTO zaj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu kawalongela, “Mweye wanhu mwihile, mulibule nhamanila, nokala na mweye mbaka zua jaki? Nowazaganya mbaka zua jaki? Mgaleni hano hamwangu!” ");
INSERT INTO zaj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu kamkomhokela ija ikinyamkela, na ikinyamkela kamulawa immhale, na heyo kipigiti kikija kahona. ");
INSERT INTO zaj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Abaho, wanahina wamwizila Yesu kinyele, wamuuza, “Habali tweye tulemelwa kumuwinga?” ");
INSERT INTO zaj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu kawalongela, “Kwavija muhungukilwa na nhamanila! Nowalongela ikweli, kamba muhawa na nhamanila ndodo kamba mbeyu ya haladali, modaha kukilongela kigongo kino, ‘Segela hano uchole haja!’ Na ikigongo chosegela. Haduhu kinhu chochose chondamulemelwe kutenda!” ");
INSERT INTO zaj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ila kinyamkela kamba ino havidahika kulawa, ila mkutambika na kufunga. ");
INSERT INTO zaj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wanahina viwaiting'hane hamoja ako Galilaya, Yesu kawalongela, “nie, Mwana wa Munhu, nogeligwa mmakono ga wanhu, ");
INSERT INTO zaj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","wonikoma, ila gahabita mazua madatu nozuka.” Wanahina wanyunguala ng'hani. ");
INSERT INTO zaj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu na wanahina zake viwavikile Kapenaumu, wawila kodi wa Ng'anda ya Mulungu wamcholela Petulo wamuuza, “Mkulufunzi wako kalihaga kodi ya Ng'anda ya Mulungu?” ");
INSERT INTO zaj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petulo kawedika, “Ona, kalihaga.” Petulo viyengile mng'anda, Yesu kakala waichanduso kulonga nayo, “Simoni, gweye kokonaze? Wandewa wa isi wowila kodi kulawa ha wanhu walihi? Kulawa ha wenekae ama kulawa ha wahenza?” ");
INSERT INTO zaj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petulo kamulongela, “Kulawa ha wahenza.” Abaho, Yesu kamulongela, “Kulonga goya, kwavija wenekae hawalondigwa kuliha kodi. ");
INSERT INTO zaj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Giladi sambituwagevuze, avo genda hana dilamba ukase nduwano, abaho, msole somba yondayalongole kunamata, na uhaunanazula mulomo wake, kovika hela, abaho, isole ukanilihile nie na gweye mwenyego.” ");
INSERT INTO zaj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kipigiti kija wanahina wamcholela Yesu wamuuza, “Yalihi yali mkulu kubanza wose muna Uundewa wa Kuulanga?” ");
INSERT INTO zaj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu kamkema mwana mdodo, abaho, kamwika haulongozi wao, ");
INSERT INTO zaj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","kalonga, “Nowalongela ikweli, ihawa hamulonda kugaluka na kulinga kamba wana wadodo, hamdaha kwingila muna Uundewa wa Kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Munhu yoyose yokiihumulusa kamba mwana ino, iyo mkulu kubanza wose muna Uundewa wa Kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na munhu yoyose yom'bokela mwana mdodo kamba ino mtwaga jangu, konibokela nie. ");
INSERT INTO zaj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ihawa munhu yoyose yahamtenda imwe wa wanhu wano wadodo yatende vilozo, vihanogile munhu hiyo yafungigwe msingo yake dibwe kulu da kusiginhila na kwasigwa mkilindi cha bahali. ");
INSERT INTO zaj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ulumwengu wojona sama ya ving'hwaso viwatenda wanhu wengile m'vilozo! Kwavija ving'hwaso havidahika kuleka kulawilila, ila kojona munhu ija yotenda ving'hwaso vilawilile! ");
INSERT INTO zaj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ihawa mkono wako ama mgulu wako wokutenda utende vilozo, ukanhe, uwase kutali na gweye! Vinoga wingile muna ugima wa digunge kuno ulemale ama uli mbetembete, kubanza kuwa na makono mabili ama magulu mabili, abaho, wasigwe muna umoto wa digunge. ");
INSERT INTO zaj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na kamba siso jako dokutenda utende vilozo, ding'ole, ujase! Vinoga wingile muna uugima wa digunge na siso dimwe, kubanza kuwa na meso mabili, abaho, wasigwe muna umoto wa kuzimu. ");
INSERT INTO zaj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Teganyeni! Sambimumzabuze imwe wa wanhu wano wadodo. Nowalongela kamba, wasenga wa Mulungu wa kuulanga wali hamoja nao mazua gose wa behi na Tataangu wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kwavija Mwana wa Munhu keza kuwakombola waja wapotele. ");
INSERT INTO zaj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mokonaze, kamba munhu yahawa na ng'hondolo mia, abaho, ng'hondolo imwe yahapotela, vino hawaleka waja ng'hondolo malongo tisa na tisa wasigale mkigongo na kuchola kumzahila ija ng'hondolo imwe yapotele? ");
INSERT INTO zaj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nowalongela ikweli, kamba yahamona, komdeng'hela ng'hani kubanza waja ng'hondolo malongo tisa na tisa walekile kupotela. ");
INSERT INTO zaj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Vivija na Tata wenu wa kuulanga halonda hata munhu imwe wa wano wadodo yapotele. ");
INSERT INTO zaj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ihawa ndugu yako kakutenda gehile, genda ukamulongele kija kinhu kihile chayakutendile muli wabili mwiyeka. Na kamba kokutegeleza, kumpata kabili ndugu yako. ");
INSERT INTO zaj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ila kamba hakutegeleze, msole munhu imwe ama wabili wayagwe hamoja na gweye, giladi mmbuli za wasindila wabili ama wadatu kila kinhu kitangigwe. ");
INSERT INTO zaj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na kamba hawategeleze, walongele wanhu wamtogole Kilisto, na vivija yahalema kuwategeleza, avo umone kamba Mmhazi na muwila kodi. ");
INSERT INTO zaj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nowalongela ikweli, chochose chondamkifunge muna iisi, chofungigwa kuulanga. Na chochose chondamkifungule muna iisi, chofunguligwa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Vivija, nowalongela ikweli, kamba wabili mmwanza wenu muna iisi wahaitogolela mmbuli ya kinhu chochose chowopula, wotendeligwa na Tataangu wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwavija hawali wabili ama wadatu waiting'hane mtwaga jangu, na nie na hamoja nao.” ");
INSERT INTO zaj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Abaho, Petulo kamcholela Yesu kamuuza, “Mndewa, kamba ndugu yangu yahanitenda vilozo, nimgele kumgongo mianza mingahi? Hata mianza saba?” ");
INSERT INTO zaj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu kamulongela, “Sikulongela mianza saba, ila mianza malongo saba mala saba. ");
INSERT INTO zaj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwavija Undewa wa Kuulanga ulinga na mndewa imwe yalondile kuwakagula watumigwa zake wakalile wamkopile hela. ");
INSERT INTO zaj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Viyasongile kukagula, kagaliligwa munhu yakalile yowilwa talanta alufu longo dimwe. ");
INSERT INTO zaj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ija imtumigwa hakalile na cha kuliha, avo mndewa kalagiza kamba yaguzwe heyo na mtwanzi wake na wanage na kila kinhu kiyali nacho, giladi yalihe hela ziyakalile yowilwa. ");
INSERT INTO zaj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Avo ija imtumigwa kamfugamila mavindi kamuyalalila kamulongela, ‘Mndewa, nyalize, nokuliha hela zako zose!’ ");
INSERT INTO zaj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mndewa wa imtumigwa ija kamonela bazi, avo kamgela kumgongo deni jake jose, abaho, kamuleka yachole. ");
INSERT INTO zaj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Abaho, ija imunhu viyacholile, kaiting'hana na mtumigwa miyage yakalile yomuwila dinali mia. Kamgoga na kusonga kumfida msingo, kalonga, ‘Nilihe deni jangu!’ ");
INSERT INTO zaj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ija imtumigwa miyage kamfugamila mavindi kamuyalalila kamulongela, ‘Nyalize, nokuliha deni jako jose!’ ");
INSERT INTO zaj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ila heyo kalema, avo kachola, kamgela mkifungo mbaka vondayalihe hela zose ziyakalile yowilwa. ");
INSERT INTO zaj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Watumigwa wayage viwawene gaja galawilile, wona giogio, avo wachola, wamulongela mndewa wao mbuli zose zilawilile. ");
INSERT INTO zaj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Abaho, ija imndewa kamkema kamulongela, ‘Gweye kwa mtumigwa wihile! Nie nikugela kumgongo deni jako jose kwavija vuuniyalalile. ");
INSERT INTO zaj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Vino hulondigwe na gweye kumonela bazi mtumigwa miyago kamba nie vinikonele bazi?’ ");
INSERT INTO zaj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mndewa wake kona lusango, avo kamgoga, kamgela mkifungo mbaka vondayalihe dideni. ");
INSERT INTO zaj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Vino vivo Tataangu wa kuulanga vondayawatende mweye ahaja munhu mmwanza wenu yahalema kumgela kumgongo ndugu yake, kulawa mmoyo wake.” ");
INSERT INTO zaj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu viyamambukize kulonga mbuli zino, kalawa Galilaya kachola kuna iisi ya Yudea mwambu uyagwe wa Ulwanda lwa Yolodani. ");
INSERT INTO zaj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Wanhu bwando wamkweleleza, na heyo kawahonya hiko. ");
INSERT INTO zaj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafalisayo wamcholela na kumgeza mkumuuza, “Malagizo ga Musa gomtogoza munhu kumwasa mtwanzi wake mmbuli yoyose?” ");
INSERT INTO zaj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu kawedika, “Vino, hamsomile Mzinyandiko Zing'alile? Ahaja hazilonga kamba haichanduso Mulungu kawalumba mtwanzi na mbigalo. ");
INSERT INTO zaj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na heyo kalonga, ‘Mkilamso kino mbigalo kowaleka tataake na mamaake na kuilumba na mwehe wake, na wabili wano wowa lukuli lumwe.’ ");
INSERT INTO zaj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Avo sio wabili, ila lukuli lumwe. Kwavija kiyalumbile Mulungu, haduhu munhu yondayakimamazule.” ");
INSERT INTO zaj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mafalisayo wamuuza, “Habali Musa kalonga Mmalagizo gake kamba munhu kodaha kumgwelela mtwanzi wake lupwilili lwa nyasa na kumwasa?” ");
INSERT INTO zaj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu kawalongela, “Musa kawatogoza muwase watwanzi zenu sama ya udala wa mioyo yenu. Ila haikalile vino songela haichanduso. ");
INSERT INTO zaj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nowalongela kamba, mbigalo yoyose yomwasa mtwanzi wake na kumsola mtwanzi iyagwe, kotenda ugoni. Ila munhu yahamwasa mtwanzi wake sama ya kutenda ugoni kodaha kusola mtwanzi iyagwe.” ");
INSERT INTO zaj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wanahina zake wamulongela, “Ihawa vino vivo ili ha mbigalo na mtwanzi wake, vinoga kuleka kusola.” ");
INSERT INTO zaj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu kawedika kawalongela, “Sio wanhu wose wodaha kuitogola mbuli ino, ila ha waja wose wagweleligwe motelo ino na Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kwavija hana vibohola wali hivo songela viwavumbuke, na hana vibohola watendigwe na wanhu, na wayagwe woleka kusola sama ya Undewa wa Kuulanga. Munhu yodaha kugabokela gano, yagabokele.” ");
INSERT INTO zaj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Abaho, wana wadodo wagaligwa ha Yesu giladi yawekile makono na kuwatambikila, ila wanahina wawakomhokela waja wawagalile. ");
INSERT INTO zaj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu kalonga, “Walekeni wana wadodo weze kumwangu, sambimuwagomese, kwavija Undewa wa Kuulanga uli wa wanhu wali kamba wano.” ");
INSERT INTO zaj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Avo, kawekila makono gake kuwamoteza, abaho, kachola. ");
INSERT INTO zaj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Baho mmhale imwe kamcholela Yesu kamuuza, “Mkulufunzi, nitende kinhu chaki kinogile giladi ningile muugima wa digunge?” ");
INSERT INTO zaj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu kamwidika, “Habali uniuza mbuli ya kinhu kinogile? Hana imwe yeiyeka iyo yanogile. Uhalonda kwingila muugima wa digunge, zigoge ndagizi za Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ija immhale kauza, “Ndagizi zaki?” Yesu kamwidika, “Sambiukome, sambiutende ugoni, sambiwibe, sambiulave usindila wa uvwizi, ");
INSERT INTO zaj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","wahishimile tataako na mamaako, na mnogele munhu wa habehi nagwe kamba vuukinogela mwenyego.” ");
INSERT INTO zaj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ija immhale kedika, kamulongela, “Gano gose nigagoga, nisigaza kinhu chaki?” ");
INSERT INTO zaj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu kamwidika, “Uhalonda sambiuhungule hanhu, genda kaguze vinhu vako, abaho, zihela uwagwelele wakumbulu, avo kowa na ngama kuulanga, abaho, izo unikoleleze.” ");
INSERT INTO zaj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ija immhale viyahulike vino, kachola kuno yokona giogio, kwavija kakala mgoli. ");
INSERT INTO zaj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Abaho, Yesu kawalongela wanahina zake, “Nowalongela ikweli, yowa vidala mgoli kwingila muna Undewa wa Kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nowalongela mwanza uyagwe, vibuha ngamia kubita mkizonzo cha shindano, kubanza mgoli kwingila Muundewa wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wanahina viwahulike vino, wakanganya ng'hani na kuuza, “Avo, yalihi yodaha kukomboligwa?” ");
INSERT INTO zaj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu kawalola kalonga, “Mwa wanhu mbuli ino haidahika, ila ha Mulungu mbuli zose zodahika.” ");
INSERT INTO zaj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Abaho, Petulo kedika, kalonga, “Tweye tuleka kila kinhu tukukoleleza gweye, avo, kwiza topata choni?” ");
INSERT INTO zaj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu kawalongela, “Nowalongela ikweli, mweye mose mung'holeleze nie, muna uulumwengu wa sambi, Mwana wa Munhu vondayakale mkigoda chake cha undewa kili na yenzi, vivija na mweye mokala m'vigoda va undewa longo dimwe na vibili, muitagusa mitala longo dimwe na mibili ya Islaeli. ");
INSERT INTO zaj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na munhu yoyose yoleka ng'anda ama ndugu ama lumbu ama tata ama mama ama wana ama migunda sama yangu, kobokela mianza mia na kuuhala ugima wa digunge. ");
INSERT INTO zaj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ila wanhu bwando wali wa haichanduso, wowa wa haikimambukizo, na wanhu bwando wali wa haikimambukizo, wowa wa haichanduso. ");
INSERT INTO zaj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Kwavija Undewa wa Kuulanga ulinga na munhu yalawile ulukwili kuchola kuzahila wanhu wa kusang'hanika mumgunda wake wa mizabibu. ");
INSERT INTO zaj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Waitogolela yawalihe dinali mdizua dimwe, abaho, kawatuma kusang'hanika mumgunda wake wa mizabibu. ");
INSERT INTO zaj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mkipigiti cha saa ndatu kachola kabili, kawona wanhu wayagwe wemile hadisoko walibule sang'hano ya kutenda, ");
INSERT INTO zaj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","avo kawalongela, ‘Na mweye gendeni mkasang'hanike mumgunda wa mizabibu, nowaliha kilondigwa kulihigwa.’ ");
INSERT INTO zaj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Avo wachola. Mkipigiti cha saa sita na saa tisa kachola kabili, katenda vivija. ");
INSERT INTO zaj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na mkipigiti cha saa longo dimwe na imwe, kachola na kuwavika wanhu wayagwe wema, avo kawauza, ‘Habali mwimile hano songela imitondo bila kutenda sang'hano yoyose?’ ");
INSERT INTO zaj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Waja wanhu wamulongela, ‘Kwavija haduhu munhu yatugwelele sang'hano ya kutenda.’ Ija imunhu kawalongela, ‘Gendeni na mweye mkasang'hanike mumgunda wa mizabibu.’ ");
INSERT INTO zaj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Viivikile ichungulo, mwene mgunda kamulongela salange wake, ‘Wakeme wasang'hana, abaho, walihe maliho gao, songa na waja wasongile kusang'hanika ichungulo, abaho, umambukizile na waja wasongile kusang'hanika imitondo.’ ");
INSERT INTO zaj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Na waja wose wasongile kusang'hanika ichungulo, kila munhu kalihigwa dinali. ");
INSERT INTO zaj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Viwezile waja wasongile kusang'hanika imitondo, wagiza kamba wolihigwa dinali bwando, ila vivija na hewo walihigwa dinali imwe kila munhu. ");
INSERT INTO zaj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wabokela dinali zao, abaho, wasonga kumtwanganikila mwene mgunda, ");
INSERT INTO zaj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","walonga, ‘Wanhu wano wa ikimambukizo wasang'hanika saa dimwe diiyeka, ila kuwaliha kamba vuutulihile tweye tusang'hanike mdizua kali na kugaya misi yose!’ ");
INSERT INTO zaj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mwene mgunda kamwidika munhu imwe mmwanza wao, kalonga, ‘Mbwiga, sikutendele kinhu chochose kihile! Hatuitogolele kusang'hanika mdizua dimwe kwa dinali imwe? ");
INSERT INTO zaj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Sola maliho gako uchole. Nisagula kumgwelela ino waikimambukizo kamba vinikugwelele gweye. ");
INSERT INTO zaj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Vino sidaha kutenda vija vinilonda na hela zangu mwenyego? Ama kokona migongo kwavija vinili na moyo unogile?’ ");
INSERT INTO zaj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Avo, wali wa haikimambukizo wowa wa haichanduso, na wali wa haichanduso wowa wa haikimambukizo.” ");
INSERT INTO zaj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu viyakalile yochola Yelusalemu, mnzila kawasola wanahina longo dimwe na wabili hamgwazo weiyeka, na kuwalongela, ");
INSERT INTO zaj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tochola Yelusalemu, na Mwana wa Munhu kogeligwa mmakono ga wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa. Womtagusa kudanganhika, ");
INSERT INTO zaj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","abaho, kogeligwa mmakono ga Wamhazi, womtendela uponela, womulanha mbalati, na womuwamba mumsalaba, ila mdizua da ikadatu kozuka.” ");
INSERT INTO zaj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Abaho, mama wa wana wa Zebedayo kamcholela Yesu hamoja na wanage, kamfugamila mavindi giladi yapule kinhu. ");
INSERT INTO zaj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu kamulongela, “Kolonda choni?” Ija imtwanzi kamwidika yolonga, “Lagiza kamba wanangu wano wabili, imwe yakale mkono wako wa ukulume na iyagwe yakale mkono wako wa ukumoso muna Undewa wako.” ");
INSERT INTO zaj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu kawalongela, “Hammanyile kinhu chumpula. Modaha kuking'wela kikasi cha mgayo kinilondigwa kuking'wela nie?” Wamwidika walonga, “Todaha.” ");
INSERT INTO zaj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu kawalongela, “Moking'wela kikasi cha migayo kining'wela nie, ila kukala kumkono wangu wa ukulume na wa ukumoso sio sang'hano yangu. Ila hanhu aho wekiligwa waja wose watandiligwe na Tataangu.” ");
INSERT INTO zaj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wanahina wayagwe longo dimwe viwahulike vino, wawonela lusango Yakobo na Yohana. ");
INSERT INTO zaj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ila Yesu kawakema hamoja kawalongela, “Movitanga kamba wandewa wa Wamhazi wowatawala na mhiko, na wakulu zao wana udaho mwa wanhu zao. ");
INSERT INTO zaj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sambiiwe vino kumwenu. Ila munhu yoyose mmwanza wenu yahalonda kuwa mkulu, kolondigwa yawe mtumigwa wenu. ");
INSERT INTO zaj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na munhu yoyose mmwanza wenu yahalonda kuwa waichanduso, kolondigwa yawe nyakadala wenu. ");
INSERT INTO zaj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kwavija Mwana wa Munhu hezile kusang'hanikilwa, ila kusang'hanikila wayagwe, na kulava ugima wake giladi yawakombole wanhu bwando.” ");
INSERT INTO zaj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu na wanahina zake viwasegele Yeliko, wanhu bwando wamkweleleza. ");
INSERT INTO zaj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Haja kukala na vimbugumbugu wabili wakalile hamgwazo wa inzila, na viwahulike kamba Yesu kobita, wenula dizwi, walonga, “Mndewa, Mwana wa Daudi, tonele bazi!” ");
INSERT INTO zaj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Didale da wanhu diwakomhokela na kuwalongela wanyamale. Ila wagendelela kwinula dizwi, wolonga, “Mndewa, Mwana wa Daudi, tonele bazi!” ");
INSERT INTO zaj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu kema, abaho, kawakema kawauza, “Molonda niwatendele choni?” ");
INSERT INTO zaj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wamulongela, “Mndewa, tolonda tulole!” ");
INSERT INTO zaj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu kawonela bazi, kagakwasa meso gao. Bahaja wadaha kulola, abaho, wamkweleleza. ");
INSERT INTO zaj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na wanahina zake viwakalile behi na kuvika Yelusalemu, wavika mkiwambo cha Betifage hana Ikigongo cha Mizaituni, Yesu kawatuma wanahina zake wabili, ");
INSERT INTO zaj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kawalongela, “Gendeni hana ikiwambo kili haulongozi wenu, baho mom'vika mhunda yafungigwe hamoja na mwanage. Wafunguleni, abaho, munigalile. ");
INSERT INTO zaj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na kamba munhu yoyose yahawauza, mulongeleni kamba, ‘Mndewa kowalonda.’ Na himahima kowagwelela.” ");
INSERT INTO zaj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Gano galawilila giladi gavikile gaja galongigwe na muhokozi, yolonga, ");
INSERT INTO zaj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mulongele mndele wa Sayuni, ‘Lola, Mndewa wako kokwizila! Kahola moyo na kapapigwa na mhunda, mwana wa mhunda.’ ” ");
INSERT INTO zaj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Avo, wanahina wachola na watenda kamba Yesu viyawalongele. ");
INSERT INTO zaj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wamgala imhunda na mwana wa mhunda, watandika vivalo vao uchana yao, abaho, Yesu kakala uchana ya imwana mhunda. ");
INSERT INTO zaj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dale kulu ng'hani da wanhu janzanza vivalo vao mnzila, na wayagwe wakanha mikuti ya mitende na kuyanzanza mnzila. ");
INSERT INTO zaj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dale da wanhu dikalile dimulongole na wose wakalile wamsondolele wenula dizwi walonga, “Yatogolwe Mwana wa Daudi! Kamota ayo yokwiza mditwaga da Mndewa! Nhogolwa uchana kuulanga!” ");
INSERT INTO zaj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu viyengile Yelusalemu, wambo jose dikala mumzahimzahi, na wanhu wauza, “Ino iyo munhu yalihi?” ");
INSERT INTO zaj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Didale da wanhu diwalongela, “Ino iyo Yesu, muhokozi kulawa Nazaleti mkiwambo cha Galilaya.” ");
INSERT INTO zaj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu kengila mdikonhi da Ing'anda ya Mulungu na kuwawinga wanhu wose wakalile muja woguza na kugula. Kazihindula meza za wavunja hela na vigoda va wose wakalile woguza njiwa, ");
INSERT INTO zaj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","kawalongela, “Yandikigwa Mzinyandiko Zing'alile, ‘Ng'anda yangu yokemigwa ng'anda ya nhambiko.’ Ila mweye moitenda fisilo da wabavi!” ");
INSERT INTO zaj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Vimbugumbugu na walemale wamcholela kuna Ing'anda ya Mulungu, na heyo kawahonya. ");
INSERT INTO zaj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ila wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa viwonile vinhu va mkanganyo viyatendile, na wana wotoa nyangi kuna Ing'anda ya Mulungu wolonga, “Yatogolwe Mwana wa Daudi!” wona lusango. ");
INSERT INTO zaj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Wamulongela, “Kowahulika wano vowolonga?” Yesu kawalongela, “Ona! Hamsomile gaja gandikigwe Mzinyandko Zing'alile, golonga, ‘Wana wadodo na ving'hele, wokwimba nyila za nhogolwa’?” ");
INSERT INTO zaj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kawaleka, kachola hanze ya idiwambo mbaka Betania, kawasa hiko. ");
INSERT INTO zaj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Imitondo ng'hani Yesu viyakalile mnzila yobwela mdiwambo, kona nzala. ");
INSERT INTO zaj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kawona mtini hamgwazo wa inzila, kaukwenhukila, ila honile chochose uchana yake ila mijani iiyeka. Abaho, kaulongela, “Sambiulele mujo milao yose!” Bahaja umtini unyala. ");
INSERT INTO zaj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wanahina viwawene vino wakanganya, wauza, “Habali umtini unyala himahima?” ");
INSERT INTO zaj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu kawedika, yolonga, “Nowalongela ikweli, kamba muhawa na nhamanila bila kusinha mmioyo yenu, sio kamba modaha kutenda kija kitendigwe mumtini uno, ila vivija modaha kukilongela kigongo kino, ‘Goboka, uiyase m'bahali,’ na yotendeka. ");
INSERT INTO zaj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kamba muhawa na nhamanila, chochose chondampule mkutambika, mogweleligwa.” ");
INSERT INTO zaj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu viyengile muna Ing'anda ya Mulungu, wakulu wa wakulu wa nhambiko na wavyele wa wanhu wamcholela kipigiti viyakalile yofundiza, wamuuza, “Kotenda mbuli zino na udaho ulihi? Na yalihi yakugwelele udaho uno?” ");
INSERT INTO zaj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu kawalongela, “Vivija na nie nowauza mbuli, na kamba muhanilongela nhegulo yake, na nie nowalongela kamba notenda mbuli zino na udaho ulihi. ");
INSERT INTO zaj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mbatiza ya Yohana ilawa kwahi? Ilawa ha Mulungu ama ilawa ha wanhu?” Wakiiuza wenyego kwa wenyego, walonga, “Tuhalonga, ‘Ulawa ha Mulungu,’ kotuuza, ‘Habali hamumtogole?’ ");
INSERT INTO zaj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ila tuhalonga, ‘Ulawa ha wanhu,’ towadumba wanhu kwavija wanhu wose wotogola kamba Yohana kakala muhokozi.” ");
INSERT INTO zaj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Avo wamwidika Yesu, “Hatuvitanga.” Abaho, na heyo kawalongela, “Na nie siwalongela kamba notenda mbuli zino na udaho ulihi. ");
INSERT INTO zaj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mweye mokonaze? Kukala na munhu imwe yakalile na wana wabili. Kamcholela ija imkulu kamulongela, ‘Mwanangu, lelo genda ukasang'hanike mumgunda wa mizabibu.’ ");
INSERT INTO zaj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ija imwana kamwidika kamulongela, ‘Sichola,’ ila mkipigiti kidodo kagelegeza mmoyo wake, abaho, kachola. ");
INSERT INTO zaj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Abaho, kamcholela imdodo kamulongela vivija. Na heyo kamwidika kalonga, ‘Ona, nochola, tata,’ ila hacholile. ");
INSERT INTO zaj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yalihi mmwanza wa wano wabili yatendile gamnogele tataake?” Wamwidika wamulongela, “Ija imkulu.” Yesu kawalongela, “Nowalongela ikweli, wawila kodi na watenda ugoni ndwanga wowalongola kwingila muna Undewa wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kwavija Yohana M'batiza keza kumwenu mnzila ilibule uzenzeleganye, na mweye hamumtogole, ila wawila kodi na watenda ugoni ndwanga wamtogola. Na hata vimgawene gano, hamulekile vilozo venu na kumtogola. ");
INSERT INTO zaj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Tegelezeni hala diyagwe, kukala na munhu yakalile na mgunda wa mizabibu, kauzengela konhi na kuhimba lwingila lwa kukamulila zabibu na kuzenga ulingo. Abaho, kawapangiza walimi, kachola isi ya kutali. ");
INSERT INTO zaj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kipigiti cha kuhuna zizabibu vikivikile, kawatuma nyakadala zake ha iwalimi wakamsolele fungu jake da izizabibu. ");
INSERT INTO zaj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Iwalimi wawanwang'hula waja iwanyakadala, imwe wamtoa, iyagwe wamkoma, na iyagwe wamtoa na mabwe mbaka kadanganhika. ");
INSERT INTO zaj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Abaho, ija imunhu kawatuma mwanza uyagwe nyakadala wayagwe bwando kubanza waja wa ichanduso, na iwalimi wawatendela vivija kamba viwawatendele waja wa ichanduso. ");
INSERT INTO zaj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hakimambukizo, kamulagiza mwanage ha iwalimi, yolonga, ‘Kwa vovose womuhishimila mwanangu.’ ");
INSERT INTO zaj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ila iwalimi viwamuwene imwana, wailongela wenyego kwa wenyego, ‘Ino iyo muhazi. Izoni tumkome, abaho, tusole uhazi wake!’ ");
INSERT INTO zaj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Avo wamsola na kumwasa hanze ya umgunda wa mizabibu na kumkoma. ");
INSERT INTO zaj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Avo mwene mgunda yeheza, kowatenda choni iwalimi?” ");
INSERT INTO zaj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wamulongela, “Kowakoma wanhu waja wehile, na kuwagwelela umgunda walimi wayagwe wondawamgwelele zabibu mkipigiti cha kuhuna.” ");
INSERT INTO zaj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu kawalongela, “Hamsomile Zinyandiko Zing'alile? ‘Dibwe dilemigwe na wazenzi digaluka dibwe da kutamanilwa ng'hani kubanza mabwe gose. Mndewa iyo yatendile mbuli ino, nayo iwa mkanganyo mmeso getu!’ ");
INSERT INTO zaj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Avo nowalongela, Undewa wa Mulungu wosegezigwa kumwenu na kugweleligwa wanhu wayagwe wondawatende gamnogele Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Munhu yodilagalila dibwe dino kobeneka vidangavidanga, na munhu yoyose yondadimulagalile domsiginha lipilipi.” ");
INSERT INTO zaj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wakulu wa wakulu wa nhambiko na Mafalisayo viwahulike hala da Yesu, wavitanga kamba kowalonga hewo, ");
INSERT INTO zaj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","avo wazahila nzila ya kumgoga. Ila wadumba didale da wanhu kwavija wakala womtogola Yesu kamba muhokozi. ");
INSERT INTO zaj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu kawalongela mmahala mwanza uyagwe, yolonga, ");
INSERT INTO zaj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Undewa wa Kuulanga ulinga na mndewa yatandile lusona lwa zengele lwa mwanage. ");
INSERT INTO zaj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kawatuma nyakadala zake wakawakeme waja wagonekigwe mulusona lwa zengele, ila walema kwiza. ");
INSERT INTO zaj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Abaho, kawatuma nyakadala wayagwe, kawalongela, ‘Walongeleni wanhu wose wagonekigwe kamba nitanda mandia gangu. Ng'ombe zangu iwakulu na iwadodo wanonile wesha kuchinjigwa, na kila kinhu kisasaligwa. Izoni hana ulusona lwa zengele!’ ");
INSERT INTO zaj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ila hawasinhuke. Wachola na zao, imwe kachola kumgunda, na iyagwe kachola kuuchuluzi wake. ");
INSERT INTO zaj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Wayagwe wawagoga nyakadala zake, wawaliga na kuwakoma. ");
INSERT INTO zaj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ija imndewa kona lusango, avo kawatuma asikali zake wawabanange waja wakomaji na kudisoma wambo jao. ");
INSERT INTO zaj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Abaho, kawalongela nyakadala zake, ‘Lusona lwa zengele lusasaligwa, ila wanhu wagonekigwe hawalumbile kuvika. ");
INSERT INTO zaj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Avo gendeni mzinzilamhanda za mkiwambo mkawagoneke wanhu wondamuwawene weze kulusona lwa zengele.’ ");
INSERT INTO zaj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Avo waja iwanyakadala wachola muna zinzila za mkiwambo na kuwalundiza wanhu wose wawavikile, wanogile na wehile, na dibugano da lusona lwa zengele dimema wahenza. ");
INSERT INTO zaj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ila ija imndewa viyengile kuwalola iwahenza, kamona munhu haja yalekile kuvala vivalo va lusona lwa zengele. ");
INSERT INTO zaj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kamuuza, ‘Mbwiga, kwingilaze hano bila vivalo va lusona lwa zengele?’ Ija imunhu kanyamala. ");
INSERT INTO zaj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Abaho, imndewa kawalongela watumigwa, ‘Mfungeni makono na magulu, abaho, mmwase kunze mdiziza. Ako kowa na kililo na kugegedula meno.’ ");
INSERT INTO zaj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Kwavija wanhu bwando wagonekigwe, ila wasaguligwe wadodo.” ");
INSERT INTO zaj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mafalisayo waiting'hana hamoja na kumwikila zundo Yesu giladi wamnamate mzimbuli zake. ");
INSERT INTO zaj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Avo, wawatuma wanahina zao hamoja na wanhu wa Helode, wolonga, “Mkulufunzi! Tuvitanga kamba gweye kwa munhu ulibule uzenzeleganye na kowafundiza wanhu ikweli ya gaja goyolonda Mulungu, bila kudumba gowogelegeza wanhu wayagwe, kwavija hulola ukulu wa munhu yoyose. ");
INSERT INTO zaj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tulongele, gweye kogesaze? Malagizo ga Musa gotogoza kuliha kodi ha Kaisali ama gogomesa?” ");
INSERT INTO zaj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ila Yesu kazitanga ngelegeza zao zihile, kalonga, “Videlenya mweye! Habali mgeza kunikila vitega? ");
INSERT INTO zaj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nilagusileni ihela ya kuliha kodi!” Na hewo wamgalila ihela, ");
INSERT INTO zaj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","abaho, kawauza, “Kihanga kino na twaga dino va munhu yalihi?” ");
INSERT INTO zaj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wamwidika, “Va Kaisali.” Avo Yesu kawalongela, “Mulonga goya, avo ga Kaisali mgweleleni Kaisali, na ga Mulungu mgweleleni Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Viwahulike vino, wakanganya, avo wamuleka, wachola na zao. ");
INSERT INTO zaj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Zua didija Masadukayo, awo wolonga kamba haduhu mzuso, wamcholela Yesu, wamuuza, ");
INSERT INTO zaj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mkulufunzi! Musa katulongela kamba, kamba munhu yahadanganhika bila kuleka mwana, ndugu yake kolondigwa yamsole ija ikizuka giladi yamulelele mwana ndugu yake yadanganhike. ");
INSERT INTO zaj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Avo kukala na ndugu saba mmwanza wetu, waichanduso kasola mtwanzi, abaho, kadanganhika bila kulela nayo mwana, abaho, ikizuka kamulekela ndugu yake. ");
INSERT INTO zaj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na ija waikabili gamulawilila gagaja, na waikadatu, na waja wose saba. ");
INSERT INTO zaj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Hakimambukizo, na ija imtwanzi kadanganhika. ");
INSERT INTO zaj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Avo mdizua da mzuso, imtwanzi ija kowa mtwanzi wa munhu yalihi? Kwavija wanhu wose saba wakala wamsolile.” ");
INSERT INTO zaj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu kawedika kawalongela, “Mweye muhonyela! Kwavija hamzitangile Zinyandiko Zing'alile ama mhiko za Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kwavija mdizua da mzuso, wanhu hawasola ama kusoligwa, ila wolinga kamba wasenga wa Mulungu wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mmbuli ya mzuso wa wanhu wadanganhike, hamsomile Mzinyandiko Zing'alile kija kimulongeligwe na Mulungu? ");
INSERT INTO zaj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nie iyo Mulungu wa Ablaham, na Isaka, na Yakobo.’ Heyo iyo Mulungu wa wanhu wagima na sio Mulungu wa wanhu wadanganhike.” ");
INSERT INTO zaj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Didale da wanhu vidihulike gano, wakanganya mafundo gake. ");
INSERT INTO zaj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ila Mafalisayo viwahulike kamba Yesu kawavudaliza Masadukayo, waiting'hana hamoja. ");
INSERT INTO zaj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na munhu imwe mmwanza wao, yakalile mfundiza Malagizo ga Musa, kamgeza mkumuuza, ");
INSERT INTO zaj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mkulufunzi, ndagizi ilihi ili ng'hulu Mmalagizo ga Musa?” ");
INSERT INTO zaj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu kamwidika kamulongela, “ ‘Mnogele Mndewa Mulungu wako na moyo wako wose, na loho yako yose, na nzonzi zako zose.’ ");
INSERT INTO zaj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ino iyo ndagizi ili ng'hulu na iyo ya ichanduso. ");
INSERT INTO zaj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na ino iyo ndagizi ya ikabili, ‘Mnogele munhu wa habehi nagwe kamba vuukiinogela mwenyego.’ ");
INSERT INTO zaj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Malagizo gose ga Musa na mafundo ga wahokozi gotamanila ndagizi zino mbili.” ");
INSERT INTO zaj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mafalisayo viwaiting'hane hamoja, Yesu kawauza, ");
INSERT INTO zaj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mweye moigelegezaze mbuli ya Kilisto? Iyo mwana wa munhu yalihi?” Wamwidika wamulongela, “Iyo Mwana wa Daudi.” ");
INSERT INTO zaj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu kawauza, “Avo, vilihi Daudi kubitila mhiko za Loho wa Mulungu komkema Kilisto, ‘Mndewa’? ");
INSERT INTO zaj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Kwavija kalonga, ‘Mndewa kamulongela Mndewa wangu, “Kala kumkono wangu wa ukulume mbaka vondaniweke wadumuka zako hasi ya magulu gako.” ’ ");
INSERT INTO zaj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ihawa Daudi komkema Kilisto, ‘Mndewa,’ yodahikaze kuwa mwanage?” ");
INSERT INTO zaj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Haduhu munhu yadahile kumwidika mbuli yoyose, na kulawa zua dija haduhu munhu yagezile kumuuza mbuli yoyose. ");
INSERT INTO zaj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Abaho, Yesu kalonga na didale da wanhu na wanahina zake, ");
INSERT INTO zaj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Wafundiza Malagizo ga Musa na Mafalisayo wana udaho wa kugatapita Malagizo ga Musa. ");
INSERT INTO zaj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Avo, gatendeni na kugagoga gaja gose gowowafundiza mweye, ila sambimtende vija vowotenda hewo, kwavija hewo hawagatenda gaja gowofundiza. ");
INSERT INTO zaj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wowafungila wanhu mibahasha mikulu na kuwadikwa mmaega, ila hewo wenyego hawalonda hata kugolosa kidole waipape. ");
INSERT INTO zaj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Wotenda mbuli zao zose giladi woneke na wanhu. Avo, wofudika mifundo mikulu mgati yandikigwe Nyandiko za Malagizo ga Musa uchana mwa ikihanga na mmakono! Na wokwika minyemvule mitali ng'hani mmikanzu yao! ");
INSERT INTO zaj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Wonogelwa kukala m'vigoda va haulongozi mulusona na kukala m'vigoda va haulongozi mzing'anda za nhambiko, ");
INSERT INTO zaj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","na kulamsigwa na hishima mmasoko na kukemigwa, ‘Mkulufunzi.’ ");
INSERT INTO zaj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ila mweye sambimkemigwe ‘Mkulufunzi,’ kwavija muna mkulufunzi imwe, na mweye mose mwa kinhu kimwe kamba ndugu. ");
INSERT INTO zaj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na sambimumkeme munhu yoyose ‘tata’ muisi, kwavija Tataenu iyo imwe yali kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ama sambimkemigwe ‘Vilangizi,’ kwavija muna kilangizi imwe, iyo Kilisto. ");
INSERT INTO zaj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yali mkulu mmwanza wenu yawe mtumigwa wenu. ");
INSERT INTO zaj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ila yoyose yokiinula kohumuluswa, na yoyose yokiihumulusa kokwinuligwa. ");
INSERT INTO zaj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mojona, wafundiza Malagizo ga Musa na Mafalisayo, mweye videlenya! Moluhinda lwivi lwa Undewa wa Kuulanga haulongozi wa wanhu, na mweye wenyego hamwingila ama hamuwatogoza kwingila waja wolonda kwingila! ");
INSERT INTO zaj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mojona, wafundiza Malagizo ga Musa na Mafalisayo, mweye videlenya! Mowabulunya vizuka na kutenda nhambiko nhali za uzenzeleganye. Avo nhaguso yenu yowa ng'hulu ng'hani! ");
INSERT INTO zaj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mojona, wafundiza Malagizo ga Musa na Mafalisayo, videlenya! Mofunga mwanza kuchola muisi inyalile na m'bahali giladi kumzahila munhu imwe yawinze nhamanila yenu. Na muhampata, momtenda yawe mwana wa kuzimu mianza mibili kubanza mweye wenyego. ");
INSERT INTO zaj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mojona, vilangizi vimbugumbugu! Mweye mulonga, ‘Ihawa munhu yahaiduilila Ng'anda ya Mulungu, jaga bule. Ila munhu yahaiduilila zahabu ya muna Ing'anda ya Mulungu, kakiifunga na ikiduilo chake.’ ");
INSERT INTO zaj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mweye vimbugumbugu wabozi! Kilihi kili kikulu, izahabu ama Ing'anda ya Mulungu iitenda izahabu ing'ale? ");
INSERT INTO zaj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Vivija mulonga, ‘Ihawa munhu yahaiduilila kilingo cha kulavila nhosa, jaga bule. Ila munhu yahaiduilila nhunza ili hachana ya ikilingo hicho, kakiifunga na ikiduilo chake.’ ");
INSERT INTO zaj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mweye vimbugumbugu! Kilihi kili kikulu, inhunza ama ikilingo cha kulavila nhosa kiitenda inhunza ing'ale? ");
INSERT INTO zaj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Avo, heyo yoiduilila ikilingo cha kulavila nhosa, kaiduilila ikilingo hicho hamoja na kila kinhu kili hachana yake. ");
INSERT INTO zaj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na heyo yoiduilila Ng'anda ya Mulungu, kaiduilila Ing'anda hiyo hamoja na Mulungu yokala himo. ");
INSERT INTO zaj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na heyo yoiduilila ulanga, kakiiduilila kigoda cha undewa cha Mulungu hamoja na ija yakikalile. ");
INSERT INTO zaj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mojona, wafundiza Malagizo ga Musa na Mafalisayo, videlenya! Kwavija molava zaka za vinhu va kulungila mandia na mboga kamba vija matepo ga kunung'hila, binzali, na jila. Ila muleka mafundo makulu ga Malagizo ga Musa, kamba vija bazi, nhamanila, na kuwa bule uzenzeleganye. Gano gago mulondigwa kutenda, na bila kuleka gaja gayagwe. ");
INSERT INTO zaj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mweye vilangizi vimbugumbugu! Molenguza nzuguni, ila momeza ngamia! ");
INSERT INTO zaj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mojona, wafundiza Malagizo ga Musa na Mafalisayo, videlenya! Mweye mwa kamba munhu yosuluza hanze ya kikasi na sahani, ila mgati vimema vinhu m'vipatile muubavi na ugila. ");
INSERT INTO zaj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Gweye Mfalisayo kimbugumbugu! Tanhu suluza mgati mwa ikikasi, abaho, vivija na hanze chong'ala! ");
INSERT INTO zaj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mojona, wafundiza Malagizo ga Musa na Mafalisayo, videlenya! Kwavija mulinga na mapanga gabakazigwe chokaa, hanze gokoneka mazelu ila mgati gamema mizege na vinhu vose vihile. ");
INSERT INTO zaj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Vivo na mweye, kunze mokoneka na wanhu kamba mnoga, ila mgati mmema udelenya na mbuli zihile. ");
INSERT INTO zaj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mojona, wafundiza Malagizo ga Musa na Mafalisayo, videlenya! Mozenga mapanga ga wahokozi na kugahamba mapanga ga wanhu wanogile. ");
INSERT INTO zaj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Abaho, molonga, ‘Kamba tuhawile baho mkipigiti hicho cha wahenga zetu, sambituilumbe nao mkuwakoma wahokozi.’ ");
INSERT INTO zaj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Avo, mweye wenyego mosindila kamba mweye mwa lukolo lwa wanhu waja wawakomile wahokozi! ");
INSERT INTO zaj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Avo, mambukizileni gaja gawasongile wahenga zenu! ");
INSERT INTO zaj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mweye nyoka, wana wa nyoka! Moikimbila vilihi nhaguso ya kuzimu? ");
INSERT INTO zaj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Avo, nowalagizila wahokozi, wanhu wali na nzewele, na wafundiza Malagizo ga Musa. Ila wayagwe mowakoma na kuwawamba mumsalaba, na wayagwe mowalanha mbalati mzing'anda zenu za nhambiko na kuwawinga kulawa kiwambo kimwe mbaka kiwambo kiyagwe. ");
INSERT INTO zaj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nhaguso ya mulopa wa wanhu wose watendile ganogile muisi iwapate mweye, kulawa mulopa wa Abeli mbaka mulopa wa Zakalia, mwanage Balakia, mumkomile hagatigati ya Ing'anda ya Mulungu na ikilingo cha kulavila nhosa. ");
INSERT INTO zaj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nowalongela ikweli, nhaguso ya wakomaji wano wose yowapata wanhu wa mulelo uno! ");
INSERT INTO zaj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yelusalemu, Yelusalemu! Gweye uwakoma wahokozi na kuwatoa na mabwe waja watumigwe kumwako! Mianza mingahi nilonda kuwakunzanya hamoja wanago kamba nguku viyowafagatila wanage hasi ya mbawa zake, ila hutogole! ");
INSERT INTO zaj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na ng'anda yako yolekigwa na yowa ukiwa. ");
INSERT INTO zaj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nokulongela, hunyona nie kabili mbaka vondaulonge, ‘Kamota ayo yokwiza mditwaga da Mndewa.’ ” ");
INSERT INTO zaj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu kalawa Kung'anda ya Mulungu, na viyakalile yochola wanahina zake wamcholela giladi wamulagusile ng'anda zizunguluke Ing'anda ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu kalonga, “Mozona ng'anda zino zose? Nowalongela ikweli, haduhu hata dibwe dimwe dondadisigale uchana ya diyagwe, dondadileke kubomoligwa.” ");
INSERT INTO zaj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu viyakalile yakalile Hakigongo cha Mizaituni, wanahina wamcholela weiyeka, wamulongela, “Tulongele, zua jaki vondagalawilile gano, na choni chondakiwe kilaguso cha wizilo wako na idizua da kimambukizo?” ");
INSERT INTO zaj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu kawalongela, “Teganyeni, munhu sambiyawagize. ");
INSERT INTO zaj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwavija wanhu bwando wokwiza mtwaga jangu, wolonga, ‘Nie iyo Kilisto!’ Na wowagiza wanhu bwando. ");
INSERT INTO zaj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mohulika ng'hondo na singilimo za ng'hondo, ila sambimdumbe. Kwavija vinhu kamba vino volondigwa vilawilile, ila ikimambukizo hakinavika. ");
INSERT INTO zaj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Isi yogomba na isi iyagwe, na undewa wouvamhila undewa uyagwe. Yolawila nzala na mgudemo wa isi kila hanhu. ");
INSERT INTO zaj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gano gose gowa kamba mwanduso wa usungu wa kulela mwana. ");
INSERT INTO zaj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Abaho, mogogigwa giladi mgazigwe na kukomigwa. Na wanhu wose wa isi zose wowehila sama yangu nie. ");
INSERT INTO zaj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kipigiti kija wanhu bwando woileka nhamanila yao, na kukiihonza na kukiihila wenyego kwa wenyego. ");
INSERT INTO zaj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Abaho, wahokozi bwando wa uvwizi wolawilila, na kuwagiza wanhu bwando. ");
INSERT INTO zaj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sama ya kongezeka mbuli zihile, noge da wanhu bwando dohuha. ");
INSERT INTO zaj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ila yondayananahile mbaka hakimambukizo, iyo yondayakomboligwe. ");
INSERT INTO zaj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na Usenga uno Unogile wa Undewa wa Mulungu wopetigwa kila hanhu muulumwengu wose giladi uwe usindila ha wanhu wa isi zose, abaho, ikimambukizo cha isi leka kize.” ");
INSERT INTO zaj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Munhu yondayasome yaitange nhegulo yake! Yesu kagendelela kulonga, “Muhachona ‘Kinhu Kinyolodoke Kigala Ubananzi’ kilongigwe na muhokozi Danieli kima Hanhu Hang'alile Ng'hani Muing'anda ya Mulungu, ");
INSERT INTO zaj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","avo, awo wali Yudea wakimbilile m'vigongo. ");
INSERT INTO zaj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Munhu yoyose yali mkiswili cha ng'anda yake sambiyahumuluke hasi na kusola kinhu chochose kulawa mng'anda yake. ");
INSERT INTO zaj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Munhu yoyose yali kumgunda sambiyabwele kusola kivalo chake. ");
INSERT INTO zaj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wojona watwanzi wali na inda na watwanzi wali na ving'hele mmazua higo! ");
INSERT INTO zaj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tambikeni giladi ng'himbila yenu sambiiwe mkipigiti cha kihuhe ama mkipigiti cha Zua da Mhumulo! ");
INSERT INTO zaj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwavija wowa mgayo mkulu, haunapata kulawilila songela kulumbigwa kwa ulumwengu mbaka sambi, na haulawila kabili mgayo kamba hiwo. ");
INSERT INTO zaj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Na kamba kipigiti kija sambikihunguzwe na Mulungu, haduhu munhu yahadahile kukombolwa, ila sama ya wanhu wasaguligwe na Mulungu, kipigiti hicho kihunguzwa. ");
INSERT INTO zaj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Abaho, kamba munhu yoyose yahawalongela, ‘Lola! Kilisto kahano,’ ama ‘Kahaja!’ Sambimtogole. ");
INSERT INTO zaj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwavija makilisto wa uvwizi na wahokozi wa uvwizi wolawila, wotenda vilaguso na mizonza mikulu giladi kamba vihadahika wawagize hata wanhu wasaguligwe na Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tegelezeni! Niwalongela nisha mbuli zino kipigiti king'hali hakinavika. ");
INSERT INTO zaj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Avo kamba wanhu wahawalongela, ‘Kamkiwala!’ Sambimchole, ama wahalonga, ‘Kakugati!’ Sambimtogole. ");
INSERT INTO zaj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kwavija kamba lumwemwe vulumwemwesa kulawa haulawilo wa zua na koneka mbaka kuuswelo wa zua, na Mwana wa Munhu vivo vondayoneke kipigiti vondayeze. ");
INSERT INTO zaj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Hohose hali na mtufi baho hondawaiting'hane vimhungu. ");
INSERT INTO zaj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Bahaja ikipigiti cha mazua ga mgayo vondakimale, zua doziziwala, mulenge haulava mulangaza wake, nhondo zolagala kulawa kuulanga, na mhiko za kuulanga zokwekwesigwa kulawa hazikalile. ");
INSERT INTO zaj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Abaho, kilaguso cha Mwana wa Munhu chokoneka kuulanga, na wanhu wa isi zose wolila ahaja vondawanyone nie Mwana wa Munhu nikwiza muna gamawingu ga kuulanga na mhiko na yenzi ng'hulu. ");
INSERT INTO zaj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kowalagiza wasenga zake wa kuulanga wali na mhalati ilava dizwi kulu, na wowakunzanya wanhu zake wasaguligwe na Mulungu kulawa ng'ambu zose za ulumwengu. ");
INSERT INTO zaj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Muifundize mum'biki wa mtini. Matambi gake gahasonga udeke wa kuzuka na kulava matepo, movitanga kamba vuli da mmabehi. ");
INSERT INTO zaj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Vivija na mweye, muhazona mbuli zino zose, m'vitange kamba ka mmabehi kwiza. ");
INSERT INTO zaj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nowalongela ikweli, wanhu wa mulelo uno hawadanganhika mbaka mbuli zino zose zilawilile. ");
INSERT INTO zaj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ulanga na isi vose vobita, ila mbuli zangu hazibita. ");
INSERT INTO zaj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Haduhu munhu yoditanga zua ama saa, si wasenga wa Mulungu wa kuulanga, ama Mwana, ila Tata yeiyeka. ");
INSERT INTO zaj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kwiza kwa Mwana wa Munhu kowa kamba mkipigiti cha Nuhu. ");
INSERT INTO zaj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kwavija mmemelo wa mazi vuukalile haunalawila, wanhu wakala woja na kung'wa, wasola na kusoligwa, mbaka zua dija Nuhu viyengile muisafina, ");
INSERT INTO zaj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","hawakitangile kija kilondile kulawilila, mbaka mmemelo wa mazi vuwizile na kuwakoma wanhu wose. Na vino vivo vondayeze Mwana wa Munhu. ");
INSERT INTO zaj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mkipigiti hicho, wambigalo wabili wolima mumgunda, imwe kosoligwa na iyagwe kolekigwa. ");
INSERT INTO zaj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Watwanzi wabili wotwanga, imwe kosoligwa na iyagwe kolekigwa. ");
INSERT INTO zaj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Avo goneleleni, kwavija hamuditanga zua dondayeze Mndewa wenu. ");
INSERT INTO zaj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ila m'vitange kamba, kamba mwene ng'anda yahakitangile kipigiti chondayeze m'bavi, yahagonelele na sambiyaileke ng'anda yake ibomoligwe. ");
INSERT INTO zaj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Avo, na mweye muisasale, kwavija Mwana wa Munhu kokwiza mkipigiti hamkitangile. ");
INSERT INTO zaj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Yalihi mtumigwa mwende na m'bala, mndewa wake yamtendile salange wa watumigwa wali mng'anda yake yondayawagwelele mandia gao mkipigiti kilondigwa? ");
INSERT INTO zaj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kamota mtumigwa ija mndewa wake yahabwela yom'vika yotenda vino! ");
INSERT INTO zaj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nowalongela ikweli, komtenda yawe mkulu wa vinhu vake vose. ");
INSERT INTO zaj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ila kamba ija imtumigwa yehile koilongela mwenyego, ‘Mndewa wangu kokawa kubwela,’ ");
INSERT INTO zaj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na kusonga kuwatoa watumigwa wayage na kuja na kung'wa na wang'wa ugimbi. ");
INSERT INTO zaj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Abaho, mndewa wa imtumigwa ija kokwiza mdizua yalekile kudigelegeza na saa yalekile kuitanga. ");
INSERT INTO zaj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Abaho, komkanha vidangavidanga imtumigwa ija na kumwika mdidale dimwe na videlenya. Ako kowa na kililo na kugegedula meno. ");
INSERT INTO zaj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Kipigiti kija Undewa wa Kuulanga wolinga na wandele longo dimwe wasolile viwenge vao na kuchola kum'bokela mulawilamhambe. ");
INSERT INTO zaj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Wandele watano wakala wabozi na watano wakala wabala. ");
INSERT INTO zaj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Waja iwabozi wasola viwenge vao, bila kugela mavuta mgati yake. ");
INSERT INTO zaj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ila waja iwabala wasola viwenge vao hamoja na via va mavuta. ");
INSERT INTO zaj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kwavija mulawilamhambe kakawa kwiza, wose wakukila na kuwasa. ");
INSERT INTO zaj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kilo kikulu kukala na nyangi, ‘Mulawilamhambe kavika! Laweni mkam'bokele!’ ");
INSERT INTO zaj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Abaho, waja iwandele wose walamuka na kuvigongomanya viwenge vao. ");
INSERT INTO zaj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Abaho, waja iwabozi wawalongela waja iwabala, ‘Tugweleleni mavuta genu, kwavija viwenge vetu vofa.’ ");
INSERT INTO zaj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Waja iwabala wawalongela, ‘Hagatutosha tweye na mweye. Ila gendeni ha wachuluzi mkagule.’ ");
INSERT INTO zaj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Viwakalile mnzila wochola kugula mavuta, mulawilamhambe kavika. Na waja watano wakalile waisasale wengila hamoja nayo mulusona lwa zengele, abaho, lwivi luhindigwa. ");
INSERT INTO zaj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kipigiti waja iwandele wabozi viwezile, wakemelela, walonga, ‘Mndewa, Mndewa! Tuvugulile!’ ");
INSERT INTO zaj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mulawilamhambe kawalongela, ‘Nowalongela ikweli! Siwatanga mweye.’ ");
INSERT INTO zaj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Avo, goneleleni, kwavija hamditanga zua ama saa yondanibweleganye. ");
INSERT INTO zaj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Kipigiti kija Undewa wa Kuulanga wolinga na munhu yochola mwanza, kawakema watumigwa zake na kuwatenda wemilizi wa vinhu vake. ");
INSERT INTO zaj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kila munhu kagweleligwa kulingana na vija viyadahile, imwe kagweleligwa talanta tano na iyagwe talanta mbili na iyagwe talanta imwe. Abaho, ija imunhu kachola mwanza wake. ");
INSERT INTO zaj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ija imtumigwa yagweleligwe talanta tano, baho kachola kuzitendela uchuluzi talanta zake, na kapata talanta tano ziyagwe. ");
INSERT INTO zaj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Vivija na ija yagweleligwe talanta mbili, kapata talanta mbili ziyagwe. ");
INSERT INTO zaj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ila ija imtumigwa yagweleligwe talanta imwe, kachola kuhimba lwingila, abaho, kaifisa italanta ya mndewa wake. ");
INSERT INTO zaj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Vikibitile kipigiti kitali, ija imndewa wa waja iwatumigwa kabwela na kutenda mheta ya talanta zao. ");
INSERT INTO zaj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ija imtumigwa yagweleligwe talanta tano, kagala talanta tano ziyagwe, kalonga, ‘Mndewa, kunigwela talanta tano, hano hana talanta tano ziyagwe zinipatile!’ ");
INSERT INTO zaj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mndewa wake kamulongela, ‘Kutenda goya mtumigwa unogile na ulibule uzenzeleganye! Na kwavija hutendile uzenzeleganye m'vinhu vidodo, avo nokutenda uwe mwimilizi wa vinhu bwando. Izo udeng'he hamoja na nie, mndewa wako!’ ");
INSERT INTO zaj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Vivija na ija imtumigwa yagweleligwe talanta mbili keza kalonga, ‘Mndewa, kunigwelela talanta mbili, hano hana talanta mbili ziyagwe zinipatile.’ ");
INSERT INTO zaj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mndewa wake kamulongela, ‘Kutenda goya mtumigwa unogile na ulibule uzenzeleganye! Na kwavija hutendile uzenzeleganye m'vinhu vidodo, avo nokutenda uwe mwimilizi wa vinhu bwando. Izo udeng'he hamoja na nie, mndewa wako!’ ");
INSERT INTO zaj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Abaho, ija imtumigwa yagweleligwe talanta imwe keza kalonga, ‘Mndewa, nivitanga kamba gweye kwa munhu mdala, kohuna vija huvihandile, na kokunzanya haja haulekile kumiza mbeyu. ");
INSERT INTO zaj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Avo nidumba, nichola kuifisa talanta yako hasi muisi. Avo talanta yako ino hano.’ ");
INSERT INTO zaj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mndewa wake kamulongela, ‘Gweye mtumigwa mwavu na mkoka! Kuvitanga kamba nie nohuna vija sivihandile na nokunzanya haja hanilekile kumiza? ");
INSERT INTO zaj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kulondigwa talanta yangu ukaike benki, vinibwelile nihaivikile talanta yangu na kija chongezeke. ");
INSERT INTO zaj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Avo, m'bokeni italanta, abaho, mumgwelele ija imtumigwa yali na talanta longo dimwe. ");
INSERT INTO zaj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kwavija munhu yali na kinhu kokongezelwa, na kowa navo bwando. Ila munhu yalibule kinhu, hata kija ikidodo chayalinacho kobokigwa. ");
INSERT INTO zaj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ino mtumigwa mwavu, mwaseni hanze hana diziza. Ako kowa na kililo na kugegedula meno.’ ");
INSERT INTO zaj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mwana wa Munhu vondayeze muna iyenzi yake, hamoja na wasenga wose wa Mulungu wa kuulanga, kokala mkigoda chake cha undewa. ");
INSERT INTO zaj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na wanhu wa isi zose woilundiza haulongozi wake. Abaho, kowabagula kamba mchunga voyowabagula ng'hondolo na menhe. ");
INSERT INTO zaj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ng'hondolo koweka ng'ambu yake ya ukulume, na menhe ng'ambu yake ya ukumoso. ");
INSERT INTO zaj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Abaho, Mndewa kowalongela waja wali ng'ambu yake ya ukulume, ‘Izoni, mweye mmotezwe na Tataangu! Muuhale Undewa mtandiligwe songela vuulumbigwe ulumwengu. ");
INSERT INTO zaj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kwavija nikala na nzala munigwelela mandia, nikala na ng'hilu muning'weza, nikala muhenza munibokela, ");
INSERT INTO zaj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nikala bule vivalo munivaza, nikala mtamu mwiza kunyuguza, na nikala mkifungo mwiza kunitembelela.’ ");
INSERT INTO zaj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Abaho, waja wanhu walibule uzenzeleganye womwidika, ‘Mndewa, zua jaki vitukuwene kukala na nzala tukugwelela mandia, ama kukala na ng'hilu tukung'weza? ");
INSERT INTO zaj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Zua jaki vitukuwene kukala muhenza tukubokela, ama kukala kwabule vivalo tukuvaza? ");
INSERT INTO zaj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Zua jaki vitukuwene kukala mtamu ama kukala mkifungo, twiza kukutembelela?’ ");
INSERT INTO zaj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Abaho, Mndewa kowalongela, ‘Nowalongela ikweli, kinhu chochose kimumtendele munhu imwe wa wano ndugu zangu wadodo, munitendela nie!’ ");
INSERT INTO zaj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Abaho, kowalongela waja wanhu wali ng'ambu yake ya ukumoso, ‘Segeleni hamwangu, mweye mdukumizwe na Mulungu! Gendeni hana umoto wa digunge yekiligwe Mwenembago na vinyamkela zake! ");
INSERT INTO zaj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kwavija nikala na nzala hamunigwelele mandia, na nikala na ng'hilu hamuning'weze, ");
INSERT INTO zaj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","nikala muhenza hamunibokele, nikala bule vivalo hamunivazile, nikala mtamu na nikala mkifungo hamwizile kunitembelela.’ ");
INSERT INTO zaj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Vivija na hewo womwidika, ‘Mndewa, zua jaki vitukuwene kukala na nzala, ama kukala na ng'hilu, ama kukala muhenza, ama kukala bule vivalo, ama kukala mtamu, ama kukala mkifungo, na tweye hatukutazile?’ ");
INSERT INTO zaj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Abaho, Mndewa kowalongela, ‘Nowalongela ikweli, vumulekile kumtendela mbuli zino imwe wa wano ndugu zangu wadodo, hamunitendele nie.’ ");
INSERT INTO zaj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Avo wanhu wano wokwingila muinhaguso ya digunge, ila waja walibule uzenzeleganye wokwingila muugima wa digunge.” ");
INSERT INTO zaj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu viyamambukize kufundiza mbuli zino zose, kawalongela wanahina zake, ");
INSERT INTO zaj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Movitanga kamba gahabita mazua mabili lowa Lusona lwa Pasaka, na Mwana wa Munhu kogogigwa giladi yawambigwe mumsalaba.” ");
INSERT INTO zaj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Abaho, wakulu wa wakulu wa nhambiko na wavyele wa wanhu waiting'hana mding'anda da kindewa da Mkulu wa Wakulu wose wa Nhambiko, yokemigwa Kayafa. ");
INSERT INTO zaj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Weka zundo mkuzahila nzila ya uzenzeleganye ya kumgoga Yesu giladi wamkome. ");
INSERT INTO zaj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Walonga, “Sambitutende mbuli ino mkipigiti cha lusona giladi sambikilawilile kiyahiyahi mwa wanhu.” ");
INSERT INTO zaj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu kakala Betania kung'anda ya Simoni ayo yakalile na utamu wa dikulu. ");
INSERT INTO zaj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kipigiti Yesu viyakalile yoja hana imeza, keza mtwanzi imwe, yakalile na nyhupa ya alabasta ili na mavuta ga kunung'hila ga hela bwando, kamcholela Yesu kamwitila mpala jake. ");
INSERT INTO zaj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wanahina viwawene gano, wona lusango, walonga, “Ubananzi uno wa choni? ");
INSERT INTO zaj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mavuta gano gahaguzigwe na hela bwando, abaho, zihela wahagweleligwe wakumbulu!” ");
INSERT INTO zaj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ila Yesu viyazitangile ngelegeza zao, kawalongela, “Habali mumgaza mtwanzi ino? Kanhendela kinhu kinogile ng'hani. ");
INSERT INTO zaj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wakumbulu mokala nao mazua gose, ila nie sikala na mweye mazua gose. ");
INSERT INTO zaj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Viyanitile mavuta gano mulukuli lwangu, kanisasala na mazisi. ");
INSERT INTO zaj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nowalongela ikweli, hanhu hohose hondaupetigwe Usenga uno Unogile muulumwengu wose, kija chayatendile mtwanzi ino cholongwa mkumkumbukila heyo.” ");
INSERT INTO zaj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Abaho, imwe wa wanahina longo dimwe na wabili, yakemigwe Yuda Isikalioti, kachola ha wakulu wa wakulu wa nhambiko ");
INSERT INTO zaj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kawauza, “Monigwelela choni kamba nihamgela Yesu mmakono genu?” Avo wamgwelela vidanga malongo madatu va hela. ");
INSERT INTO zaj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kulawa haja Yuda kasonga kuzahila nzila ya kumgela mmakono gao. ");
INSERT INTO zaj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Muna dizua da mwanduso wa Lusona lwa Mikate Ilibule Mela, wanahina wamcholela Yesu wamuuza, “Kwahi kuulonda tukakutandile mandia ga Pasaka?” ");
INSERT INTO zaj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu kawalongela, “Gendeni mdiwambo, mom'vika munhu, abaho, mulongeleni, ‘Mkulufunzi kolonga, “Kipigiti kiyakisagule Mulungu sama yangu nie kikwenhuka. Nie na wanahina zangu toja mandia ga Pasaka mng'anda yako.” ’ ” ");
INSERT INTO zaj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wanahina watenda kamba Yesu viyawalagize, abaho, wagatanda mandia ga Pasaka. ");
INSERT INTO zaj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Viivikile ichungulo, Yesu kakala hana imeza hamoja na wanahina zake longo dimwe na wabili. ");
INSERT INTO zaj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Viwakalile woja, Yesu kalonga, “Nowalongela ikweli, imwe mmwanza wenu konihonza.” ");
INSERT INTO zaj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wanahina wona giogio, na wasonga kumuuza imweimwe, “Nie, Mndewa?” ");
INSERT INTO zaj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu kawedika, “Ayo yozanhika mkate mkia hamoja na nie iyo yondayanihonze. ");
INSERT INTO zaj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana wa Munhu kodanganhika kamba Nyandiko Zing'alile vuzimulonga. Ila kojona munhu ija yondayamuhonze Mwana wa Munhu! Vihanogile munhu hiyo sambiyaleligwe!” ");
INSERT INTO zaj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda, yakalile yolonda kumuhonza, kamuuza, “Nie, Mkulufunzi?” Yesu kamwidika, “Gweye kulonga vino.” ");
INSERT INTO zaj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Viwakalile woja, Yesu kasola mkate, kaumoteza, abaho, kaumogola, kawagwelela wanahina zake, kalonga, “Soleni mje, kwavija uno uwo lukuli lwangu.” ");
INSERT INTO zaj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Abaho kasola kikasi, kalonga hewela, kawagwelela wanahina zake, kalonga, “Ing'weni, mose, ");
INSERT INTO zaj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kwavija uno uwo mulopa wangu uli usindila wa lagano da Mulungu na wanhu zake, witike sama ya wanhu bwando giladi wageligwe kumgongo vilozo vao. ");
INSERT INTO zaj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nowalongela, sing'wa kabili mulelo uno wa zabibu mbaka zua dija vondaniung'we wa sambi hamoja na mweye Muundewa wa Tataangu.” ");
INSERT INTO zaj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Viweshile kwimba, wachola hana Ikigongo cha Mizaituni. ");
INSERT INTO zaj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Abaho, Yesu kawalongela, “Kilo ya lelo, mweye mose mong'himbila, kamba viyandikigwe Mnyandiko Zing'alile, ‘Nomtoa imchunga, na didale da ng'hondolo dopwililika.’ ");
INSERT INTO zaj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ila nihazuka, nowalongola kuchola Galilaya.” ");
INSERT INTO zaj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petulo kalonga, “Hata kamba wose wahakukimbila, nie sikukimbila bule!” ");
INSERT INTO zaj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu kamulongela Petulo, “Nokulongela ikweli, kilo ya lelo, nzogolo yang'hali hanakwika, konibela mianza midatu.” ");
INSERT INTO zaj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petulo kamulongela, “Hata kamba kudanganhika, nidanganhike hamoja na gweye! Sikubela bule!” Na wanahina wose wasigale walonga vivo. ");
INSERT INTO zaj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Abaho, Yesu kachola hamoja na wanahina zake hanhu hakemigwe Getisemane, kawalongela, “Kaleni hano, nie nichole haja kutambika.” ");
INSERT INTO zaj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kawasola Petulo na waja iwana wabili wa Zebedayo, kasonga kona giogio na kugazika. ");
INSERT INTO zaj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Abaho, kawalongela, “Moyo wangu una giogio ng'hani behi na kudanganhika. Kaleni hano mgonelele hamoja na nie.” ");
INSERT INTO zaj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kachola hamwande kidogo, katambalala kingubanguba, katambika, yolonga, “Tataangu, vihadahika, kikasi kino cha migayo kinisegele! Ila sio kamba vinilonda nie, ila kamba vuulonda gweye.” ");
INSERT INTO zaj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Abaho, kawabwelela waja iwanahina, kawavika wawasa. Kamuuza Petulo, “Mulemelwa kugonelela hamoja na nie hata saa dimwe? ");
INSERT INTO zaj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Goneleleni, mtambike, giladi sambimwingile mkugezigwa. Kwavija loho yolonda, ila lukuli lutepweta.” ");
INSERT INTO zaj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu kachola mwanza wa ikabili, katambika, yolonga, “Tataangu, kamba havidahika kikasi kino cha migayo kinisegele ila mbaka niking'wele, gaja guulonda gatendeke.” ");
INSERT INTO zaj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Viyabweleganye mwanza uyagwe, kawavika wawasa, kwavija meso gao gakala na utulo. ");
INSERT INTO zaj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Avo kawaleka, kachola kutambika mwanza wa ikadatu, yolonga mbuli zizija. ");
INSERT INTO zaj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Abaho, kawabwelela wanahina kawalongela, “Mng'hali wasa na kuhumula? Saa ivika ya Mwana wa Munhu kugeligwa mmakono ga wanhu wene vilozo. ");
INSERT INTO zaj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Lamukeni, tuchole! Loleni, munhu yonihonza ka habehi!” ");
INSERT INTO zaj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu viyakalile yang'hali yolonga, Yuda, imwe wa iwanahina longo dimwe na wabili, keza. Kailongoza hamoja na dale kulu da wanhu wapapile mizele na mimbwego. Wakala watumigwe na wakulu wa wakulu wa nhambiko na wavyele wa wanhu. ");
INSERT INTO zaj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Imunhu yomuhonza kawagwelela utango, kawalongela, “Ija yondanimnonele, iyo heyo. Mgogeni!” ");
INSERT INTO zaj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Baho Yuda kamcholela Yesu, kalonga, “Nokulamsa, Mkulufunzi!” Abaho, kamnonela. ");
INSERT INTO zaj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu kamulongela, “Mbwiga, tenda chuuwinzile!” Abaho, waja iwanhu weza, wamgoga Yesu na kumfunga. ");
INSERT INTO zaj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Imwe wa waja wakalile na Yesu kasomola zele jake na kumkanha gwiti nyakadala wa Mkulu wa Wakulu wose wa Nhambiko. ");
INSERT INTO zaj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu kamulongela, “Bweza zele jako muna iyala yake, kwavija wose wotamanila zele wodanganhika na zele. ");
INSERT INTO zaj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mokwagiza kamba sidaha kumulongela Tataangu yanigalile sambisambi madale gabanza longo dimwe na mabili ga wasenga zake wa kuulanga? ");
INSERT INTO zaj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ila zovikila vilihi Nyandiko Zing'alile zilonga kamba vino vivo vilondigwa ilawilile?” ");
INSERT INTO zaj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kipigiti kikija Yesu kadilongela didale da wanhu, “Mwiza na mizele na mimbwego kunigoga kamba nie na m'bokonyi? Mazua gose nikala nifundiza kuna Ing'anda ya Mulungu, na mweye hamunigogile. ");
INSERT INTO zaj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ila gano gose galawilila, giladi Nyandiko Zing'alile za wahokozi zivikile.” Abaho, wanahina wose wamuleka, wakimbila. ");
INSERT INTO zaj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Waja wamgogile Yesu wamsola wamgala ha Kayafa, Mkulu wa Wakulu wose wa Nhambiko, kuwaiting'hane wafundiza Malagizo ga Musa na wavyele wa wanhu. ");
INSERT INTO zaj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petulo kamkoleleza kutalitali mbaka kudikonhi da ing'anda ya Mkulu wa Wakulu wose wa Nhambiko. Kengila na kukala hasi hamoja na wemilizi giladi yachone chondakilawilile. ");
INSERT INTO zaj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wakulu wa wakulu wa nhambiko hamoja na Ikitala chose Kikulu cha Isi ya Wayahudi wazahila usindila wa uvwizi giladi wamkome Yesu. ");
INSERT INTO zaj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Walawilila wasindila bwando wa uvwizi, ila hawapatile mbuli yoyose. Hakimambukizo, walawilila wanhu wabili ");
INSERT INTO zaj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","walonga, “Munhu ino kalonga, ‘Nie nodaha kuibomola Ng'anda ya Mulungu na kuizenga mmazua madatu.’ ” ");
INSERT INTO zaj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mkulu wa Wakulu wose wa Nhambiko kenuka kamulongela Yesu, “Kwabule kinhu cha kwidika? Usindila waki uno woolava wanhu wano wokutagusa gweye?” ");
INSERT INTO zaj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ila Yesu kanyamala. Abaho Mkulu wa Wakulu wose wa Nhambiko kamuuza, “Nokuduiza ha Mulungu yali mgima, tulongele kamba gweye iyo Kilisto, Mwana wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu kamwidika kalonga, “Gweye kulonga vino. Ila nowalongela, kulawa kipigiti kino monyona nie Mwana wa Munhu nikalile ng'ambu ya ukulume ya Ukulu, nikwiza muna gamawingu ga kuulanga!” ");
INSERT INTO zaj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Abaho, Mkulu wa Wakulu wose wa Nhambiko kadega vivalo vake kalonga, “Kafukula! Habali tulonda wasindila wayagwe? Avo muhulika ufukuzi wake! ");
INSERT INTO zaj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mogelegeza vilihi?” Wamwidika, “Kolondigwa yakomigwe!” ");
INSERT INTO zaj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Abaho, wamtemela mate mkihanga chake, wamtoa, na wayagwe wamtoa makofi, ");
INSERT INTO zaj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","walonga, “Gweye Kilisto, zuza! Yalihi yakutoile?” ");
INSERT INTO zaj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petulo viyakalile yakalile hasi hanze ya idikonhi, mtumigwa imwe wa kitwanzi wa Mkulu wa Wakulu wose wa Nhambiko kamcholela kamulongela, “Na gweye kwa hamwe na Yesu wa Galilaya.” ");
INSERT INTO zaj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ila Petulo kabela haulongozi wa wanhu wose, kamulongela, “Sikitanga chuulonga.” ");
INSERT INTO zaj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Viyakalile yolawa hanze ya idikonhi, mtumigwa iyagwe wa kitwanzi kamona na kuwalongela wanhu wakalile haja, “Munhu ino kakala hamwe na Yesu wa Nazaleti.” ");
INSERT INTO zaj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petulo kabela mwanza uyagwe mkuiduila, kalonga, “Simtanga munhu ino!” ");
INSERT INTO zaj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kipigiti kidodo hamwande, wanhu wemile haja wamcholela Petulo wamulongela, “Tokona na gweye kwa mmwanza wao, kwavija hata ulonzi wako ulinga na hewo!” ");
INSERT INTO zaj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Abaho, Petulo kasonga kuidukumiza na kuiduila, yolonga, “Simtanga munhu ija!” Kipigiti kikija nzogolo keka. ");
INSERT INTO zaj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petulo kakumbukila vija Yesu viyamulongele, “Nzogolo yang'hali hanakwika, konibela mianza midatu.” Kalawa hanze kalila ng'hani. ");
INSERT INTO zaj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Imitondo ng'hani, wakulu wa wakulu wa nhambiko wose na wavyele wa wanhu wamwikila zundo Yesu giladi wazahile nzila ya kumkoma. ");
INSERT INTO zaj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wamfunga, wamsola, na kumgala ha Pilato, mndewa wa Yudea kulawa Loma. ");
INSERT INTO zaj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Abaho, Yuda, ija yamuhonzile Yesu, viyawene kamba Yesu katagusigwa kudanganhika, kona giogio na kuvibweza vija vidanga malongo madatu va hela ha wakulu wa wakulu wa nhambiko na wavyele wa wanhu. ");
INSERT INTO zaj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kalonga, “Nitenda vilozo mkumuhonza munhu yakalile bule mbuli yoyose ihile!” Na hewo wamulongela, “Avo tweye tutendeze? Na lwako mwenyego!” ");
INSERT INTO zaj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Avo Yuda kazibwanha zihela muna Ing'anda ya Mulungu, abaho, kalawa hanze ya idikonhi da Ing'anda ya Mulungu, kachola kuibota. ");
INSERT INTO zaj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Wakulu wa wakulu wa nhambiko wazidondola zihela, walonga, “Hela zino za mulopa zigomesigwa na Malagizo ga Musa kwikigwa muna ingama ya Ng'anda ya Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Avo, walamula kamba hela zija wagule mgunda wa munhu imwe yakalile muumbi giladi hawe hanhu ha kuzikila wahenza. ");
INSERT INTO zaj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Avo mbaka lelo mgunda uja wokemigwa, “Mgunda wa Mulopa.” ");
INSERT INTO zaj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Abaho, gavikila gaja galongigwe na muhokozi Yelemia, “Wasola vidanga malongo madatu va hela, kiasi kikigwe na wanhu wa Islaeli sama yake, ");
INSERT INTO zaj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na zihela wazigulila mgunda wa munhu imwe yakalile muumbi, kamba Mndewa viyanilagize.” ");
INSERT INTO zaj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu kema haulongozi wa Pilato, mndewa wa Yudea kulawa Loma, na Pilato kamuuza, “Gweye iyo mndewa wa Wayahudi?” Yesu kamulongela, “Gweye iyo ulonga avo.” ");
INSERT INTO zaj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ila wakulu wa wakulu wa nhambiko na wavyele wa wanhu viwakalile womtagusa, halongile kinhu chochose. ");
INSERT INTO zaj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Abaho, Pilato kamuuza, “Huhulika mbuli bwando zowokutagusa?” ");
INSERT INTO zaj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ila Yesu hedike hata mbuli imwe, avo Pilato kakanganya ng'hani. ");
INSERT INTO zaj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mkipigiti cha Lusona lwa Pasaka, mndewa wa Yudea kulawa Loma kakala na nzoela ya kumfungulila mfungigwa imwe ija wanhu iwamulondile. ");
INSERT INTO zaj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kipigiti kija kukala na mfungigwa imwe yatangigwe ng'hani na wanhu sama ya kutenda gehile yokemigwa Balaba. ");
INSERT INTO zaj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Avo, dale da wanhu vidiiting'hane, Pilato kawauza, “Yalihi yummulonda niwafungulile? Balaba, ama Yesu yokemigwa Kilisto?” ");
INSERT INTO zaj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kwavija Pilato kavitanga kamba wakulu wa wakulu wa nhambiko na wavyele wa wanhu wamgala Yesu kumwake sama ya migongo. ");
INSERT INTO zaj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato viyakalile mkigoda cha nhaguso, mtwanzi wake kamtumila usenga, kamulongela, “Sambiumtende kinhu chochose munhu hiyo yalibule vilozo, kwavija lelo nigaya ng'hani mnzozi sama yake.” ");
INSERT INTO zaj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ila wakulu wa wakulu wa nhambiko na wavyele wa wanhu wadiswagiza didale da wanhu dimpule Pilato yawafungulile Balaba na Yesu yakomigwe. ");
INSERT INTO zaj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato kadiuza didale da wanhu, “Yalihi mwa wanhu wano wabili yummulonda niwafungulile?” Wamwidika, “Balaba.” ");
INSERT INTO zaj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato kawauza, “Nimtendeze Yesu yokemigwa Kilisto?” Wose wamwidika, “Yawambigwe mumsalaba!” ");
INSERT INTO zaj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato kawauza, “Habali, mbuli yaki ihile yaatendile?” Ila wose wongeza kuguta nyangi wolonga, “Yawambigwe mumsalaba!” ");
INSERT INTO zaj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato viyawene kamba hawamtegeleza, ila kizuka kiyahiyahi, kasola mazi na kusuluza makono gake haulongozi wa didale da wanhu, kalonga, “Nie nabule mbuli na ifa ya munhu ino! Iloleni mwemwe wenyego!” ");
INSERT INTO zaj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Didale da wanhu dimulongela, “Nhaguso ya ifa yake toisola tweye na wanetu!” ");
INSERT INTO zaj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Abaho, Pilato kawafungulila Balaba, na kuwalagiza asikali wamulanhe Yesu mbalati, na kumgela mmakono gao giladi yawambigwe mumsalaba. ");
INSERT INTO zaj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Abaho, asikali wa mndewa wa Yudea kulawa Loma wamsola Yesu wamwingiza mding'anda da ija imndewa, abaho, dale jose da asikali dimzunguluka. ");
INSERT INTO zaj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wam'vula vivalo vake na kum'vaza kanzu da zambalau. ");
INSERT INTO zaj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Abaho, waluka mkungo wa mizomola wamwikila mpala jake na kumwikila ludete mumkono wake wa ukulume. Abaho, wamfugamila mavindi na kumtendela uponela, wamulongela, “Kwa mpile, Mndewa wa Wayahudi!” ");
INSERT INTO zaj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wamtemela mate, wasola ludete na kumulanha nao mpala. ");
INSERT INTO zaj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Viwamambukize kumtendela uponela, wam'vula dija dikanzu, wam'vaza vivalo vake. Abaho, wamgala kumuwamba mumsalaba. ");
INSERT INTO zaj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Viwakalile wochola, waiting'hana na munhu kulawa isi ya Kilene, yakemigwe Simoni, wemilizi wamshulutiza giladi yaupape msalaba wa Yesu. ");
INSERT INTO zaj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wavika hanhu hakemigwe, Goligota, nhegulo yake “Hanhu ha Fulu da Pala.” ");
INSERT INTO zaj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wamgwelela Yesu divai igeligwe vinhu va usungu, ila viyailanzile, haing'wile. ");
INSERT INTO zaj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wamuwamba mumsalaba, abaho, wakiigolela vivalo vake mkuvitoela kula. ");
INSERT INTO zaj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Abaho, wakala hasi, wamwimiliza. ");
INSERT INTO zaj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Uchana ya pala jake wandika lupwilili lwa nhaguso yake lulonga, “ino iyo yesu, mndewa wa wayahudi.” ");
INSERT INTO zaj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wamuwamba Yesu mumsalaba hamoja na mibokonyi mibili, dimwe ng'ambu yake ya ukulume, na diyagwe ng'ambu yake ya ukumoso. ");
INSERT INTO zaj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wanhu wakalile wobita wamuliga, watigisa mapala gao ");
INSERT INTO zaj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","walonga, “Gweye iyo ulondile kuibomola Ng'anda ya Mulungu na kuizenga mmazua madatu, ikombole mwenyego! Ihawa gweye iyo Mwana wa Mulungu, humuluka kulawa mumsalaba!” ");
INSERT INTO zaj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Vivija na wakulu wa wakulu wa nhambiko, wafundiza Malagizo ga Musa na wavyele wa wanhu wamtendela uponela, walonga, ");
INSERT INTO zaj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Kawakombola wayagwe, ila hadahile kuikombola mwenyego! Heyo iyo Mndewa wa Islaeli! Avo na yahumuluke kulawa mumsalaba, na tweye tomtogola! ");
INSERT INTO zaj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Komtamanila Mulungu, avo tulole vija Mulungu vondayamkombole, kwavija kalonga, ‘Nie iyo Mwana wa Mulungu.’ ” ");
INSERT INTO zaj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Vivija na ija imibokonyi iwambigwe hamoja na heyo imuliga. ");
INSERT INTO zaj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Songela kipigiti cha saa sita, kukala na ziza muisi yose mbaka kipigiti cha saa tisa. ");
INSERT INTO zaj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mkipigiti cha saa tisa, Yesu kenula dizwi kalila, “Eloi, Eloi, lama sabakitani?” Nhegulo yake, “Mulungu wangu, Mulungu wangu, habali kundeka?” ");
INSERT INTO zaj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wanhu wemile haja viwahulike, walonga, “Munhu ino komkema Eliya!” ");
INSERT INTO zaj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Bahaja munhu imwe kakimbila na kusola siponji, kaizabika muna idivai igwaduke na kuifunga kuisota ya lumango na kumng'weza Yesu. ");
INSERT INTO zaj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ila wayagwe walonga, “Muleke! Tulole kamba Eliya kokwiza kumkombola!” ");
INSERT INTO zaj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu kenula dizwi kalila kabili, abaho, kadanganhika. ");
INSERT INTO zaj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kipigiti kikija, diguo ditungikwe Muing'anda ya Mulungu didegeka vidanga vibili, kulawa uchana mbaka hasi. Isi igudema, na mibwe itulika, ");
INSERT INTO zaj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mapanga gatulika, na ng'huli za wanhu bwando wang'alile wadanganhike wazuka. ");
INSERT INTO zaj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesu viyazukile, na hewo walawa hana gamapanga wachola hana diwambo ding'alile da Yelusalemu, na koneka na wanhu bwando. ");
INSERT INTO zaj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mkulu wa asikali mia wa Loma, hamoja na waja wakalile womwimiliza Yesu, viwawene mgudemo wa isi na gaja galawilile, wadumba na kulonga, “Kweli munhu ino kakala Mwana wa Mulungu!” ");
INSERT INTO zaj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hanhu haja kukala na watwanzi bwando wolola kutalitali, wakalile womkweleleza Yesu kulawa Galilaya na wakala womsang'hanikila. ");
INSERT INTO zaj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Watwanzi hiwo wakala Maliamu wa kiwambo cha Magidala, Maliamu mamaake Yakobo na Usufu, na mama wa wanage Zebedayo. ");
INSERT INTO zaj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Viivikile ichungulo, keza mgoli imwe kulawa wambo da Alimataya, yakemigwe Usufu, vivija kakala mwanahina wa Yesu. ");
INSERT INTO zaj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kachola ha Pilato na kumpula lukuli lwa Yesu, na Pilato kalagiza kamba yagweleligwe. ");
INSERT INTO zaj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Usufu kalusola ulukuli, kaluzinga sanda, ");
INSERT INTO zaj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","na kulutambalika mdipanga jake mwenyego da sambi dipukigwe mdidibwe. Kadibimbilisa dibwe kulu na kudika hana umulomo wa idipanga, abaho, kachola. ");
INSERT INTO zaj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maliamu wa kiwambo cha Magidala na Maliamu iyagwe wakala hamgwazo wa idipanga. ");
INSERT INTO zaj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Imitondo yake, ikala Zua da Mhumulo, wakulu wa wakulu wa nhambiko na Mafalisayo wamcholela Pilato ");
INSERT INTO zaj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","na kulonga, “Mndewa, tokumbuka kamba viyakalile mgima, m'vwizi ija kalonga, ‘Gahabita mazua madatu nozuka.’ ");
INSERT INTO zaj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Avo lagiza kamba panga jake diimilizwe mbaka zua da ikadatu, giladi wanahina zake sambiwachole kulusola ulukuli, na kuwalongela wanhu kamba kazuka. Uvwizi uno wa kimambukizo wokwiha ng'hani kubanza uja wa ichanduso.” ");
INSERT INTO zaj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato kawalongela, “Soleni iwaasikali, gendeni mkadiimilize kamba vumdaha.” ");
INSERT INTO zaj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Avo wachola kudimiliza dipanga mkuweka asikali na kwika utango mumgwazo wa idibwe giladi kamba munhu yahadisegeza wavitange. ");
INSERT INTO zaj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Vidimalile Zua da Mhumulo, imitondo iyagwe, zua vidikalile disimbuka, Maliamu wa ikiwambo cha Magidala na Maliamu iyagwe wachola kudilola dipanga. ");
INSERT INTO zaj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bahaja kulawilila na mgudemo mkulu wa isi, kwavija msenga wa Mndewa wa kuulanga kahumuluka kulawa kuulanga, kadibimbilisa idibwe kumgwazo, abaho, kadikalila. ");
INSERT INTO zaj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Lukuli lwake lunang'hazika kamba lumwemwe, na vivalo vake vikala vizelu ng'hani. ");
INSERT INTO zaj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Waja iwaasikali wadumba na kugudema ng'hani, walinga kamba wanhu wadanganhike. ");
INSERT INTO zaj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Msenga wa Mndewa wa kuulanga kawalongela waja iwatwanzi, “Sambimdumbe, kwavija novitanga kamba momzahila Yesu, yawambigwe mumsalaba. ");
INSERT INTO zaj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kahaduhu hano, kazuka, kamba viyalongile. Izoni mulole hanhu hayakalile yatambalale. ");
INSERT INTO zaj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tendeni mbwisa mchole mkawalongele wanahina zake kamba kazuka, kowalongola kuchola Galilaya ako kondammone. Uno uwo usenga wangu kumwenu.” ");
INSERT INTO zaj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hima walawa hana dipanga, kuno wogudema na kudeng'ha ng'hani, abaho, wakimbila, wachola kuwalongela wanahina zake. ");
INSERT INTO zaj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bahaja Yesu kawating'hanila, kalonga, “Nowalamsa!” Wamcholela, wamgoga magulu gake na kumtambikila. ");
INSERT INTO zaj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu kawalongela, “Sambimdumbe, gendeni mkawalongele wanahina zangu wachole Galilaya, ako wonyona.” ");
INSERT INTO zaj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Waja iwatwanzi viwakalile mnzila, asikali wayagwe wakalile wodimiliza idipanga wachola mdiwambo kuwalongela wakulu wa wakulu wa nhambiko mbuli zose zilawilile. ");
INSERT INTO zaj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wakulu wa wakulu wa nhambiko waiting'hana hamoja na wavyele wa wanhu, na viweshile kuitogolela, wawagwelela hela bwando iwaasikali, ");
INSERT INTO zaj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","wawalongela, “Longeni, ‘Vitukalile tuwasile, wanahina zake weza ikilo na kulwiba lukuli lwake.’ ");
INSERT INTO zaj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kamba mbuli ino iham'vikila mndewa wa Yudea kulawa Loma, tolonga nayo mkuwagombeleza giladi sambimgazigwe.” ");
INSERT INTO zaj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Avo iwaasikali wasola zihela na kutenda kamba viwalongeligwe. Na mbuli zino zibwililika mwa Wayahudi mbaka lelo. ");
INSERT INTO zaj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Wanahina longo dimwe na imwe, wachola Galilaya hana ikigongo chayawalongele Yesu wachole. ");
INSERT INTO zaj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Viwamuwene, wamtambikila, ila wanahina wayagwe wadungwadungwa mmoyo. ");
INSERT INTO zaj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu kawakwenhukila kawalongela, “Nigweleligwa udaho wose kuulanga na muisi. ");
INSERT INTO zaj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Avo gendeni mkawatende wanhu wa isi zose wawe wanahina, na kuwabatiza mtwaga da Tata, na Mwana, na Loho wa Mulungu, ");
INSERT INTO zaj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","na kuwafundiza kugagoga gaja gose ganiwalongele mweye. Na nie na hamoja na mweye mazua gose, mbaka hakimambukizo cha iisi.”");
INSERT INTO zaj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Uno uwo mwanduso wa Usenga Unogile wa Yesu Kilisto, Mwana wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kamba viwandikigwe na muhokozi Isaya, “Mulungu kalonga, ‘Nomulagiza msenga wangu yakulongole, Yondayaitande nzila yako.’ ");
INSERT INTO zaj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Munhu kenula dizwi muluwala, yolonga, ‘Itandeni nzila ya Mndewa, Mgoloseleni nzila zake!’ ” ");
INSERT INTO zaj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohana M'batiza kakala muluwala, youpeta ubatizo wa kuleka vilozo, giladi vilozo vao vigeligwe kumgongo. ");
INSERT INTO zaj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wanhu bwando kulawa muisi ya Yudea na mkiwambo cha Yelusalemu wachola kumtegeleza Yohana. Wavilonga vilozo vao haulongozi wa wanhu, na heyo kawabatiza muna Ulwanda lwa Yolodani. ");
INSERT INTO zaj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana kavala guo ditendigwe na mijusu ya ngamia na lukumbulu lwa kwembe mchuno chake, kakala yoja nzige na uki. ");
INSERT INTO zaj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohana kawapetela wanhu, yolonga, “Munhu yokwiza hachugu changu kana mhiko kunibanza nie. Nie silondigwa hata kuinamila na kufungula nzabi za ng'hwabasa zake. ");
INSERT INTO zaj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nie niwabatiza mweye mmazi, ila heyo yeheza kowabatiza na Loho wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mazua gaja, Yesu kalawa mkiwambo cha Nazaleti muisi ya Galilaya, keza kubatizigwa na Yohana M'batiza Mulwanda lwa Yolodani. ");
INSERT INTO zaj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kipigiti kikija Yesu viyalawile mmazi, kawona ulanga uvuguka na Loho wa Mulungu kamuhumulukila yalumbile kamba hua. ");
INSERT INTO zaj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Dizwi dihulikwa kulawa kuulanga dilonga, “Gweye iyo Mwanangu unogele. Nogelwa nagwe.” ");
INSERT INTO zaj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Baho Loho wa Mulungu kamsung'hiza yachole muluwala, ");
INSERT INTO zaj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","kakala hiko mazua malongo mane, yogezigwa na Mwenembago. Hiko kakala na wang'onyo wa kumuhulo, na wasenga wa Mulungu wa kuulanga wakala womsang'hanikila. ");
INSERT INTO zaj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohana M'batiza viyageligwe mkifungo, Yesu kachola Galilaya, kawapetela wanhu Usenga Unogile wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kalonga, “Kipigiti kivika, na Undewa wa Mulungu ukwenhuka! Muleke vilozo venu na muutogole Usenga Unogile.” ");
INSERT INTO zaj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu viyakalile yobita mumgwazo wa Idilamba da Galilaya, kawona Simoni na Endelea ndugu yake, wotanda nhando zao mdilamba, kwavija wakala waloa somba. ");
INSERT INTO zaj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu kawalongela, “Ng'hwelelezeni, na nie nowatenda muwe waloa wanhu.” ");
INSERT INTO zaj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Baho wazileka nhando zao wamkweleleza. ");
INSERT INTO zaj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kachola haulongozi kidogo, kawona Yakobo na Yohana, wanage Zebedayo. Wakala mngalawa zao wozigongomanya goya nhando zao. ");
INSERT INTO zaj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu viyawawene, bahaja kawakema, wamuleka tataao Zebedayo muingalawa na wasang'hana, wamkweleleza Yesu. ");
INSERT INTO zaj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na wanahina zake wengila mkiwambo cha Kapenaumu. Vidivikile Zua da Mhumulo, Yesu kengila muna ing'anda ya nhambiko, kasonga kufundiza. ");
INSERT INTO zaj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wanhu wamuhulike wakanganya vija voyokala yofundiza, kwavija hafundize kamba wafundiza Malagizo ga Musa, ila kafundiza kamba munhu yali na udaho. ");
INSERT INTO zaj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kipigiti kikija munhu yali na kinyamkela kengila mng'anda yao ya nhambiko, kaguta lwangi, yolonga, ");
INSERT INTO zaj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Kotulonda choni, Yesu wa Nazaleti? Kwiza kutubananga? Nokutanga gweye iyo mtumigwa wa Mulungu ung'alile!” ");
INSERT INTO zaj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu kamkomhokela ikinyamkela yolonga, “Nyamala! Mulawe munhu ino!” ");
INSERT INTO zaj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kinyamkela kamtigisatigisa ng'hani ija imunhu, kaguta lwangi na kumulawa. ");
INSERT INTO zaj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wanhu wose wakanganya, wasonga kuilongela, “Mbuli yaki ino? Dino fundo da sambi? Munhu ino kana udaho wa kuwakomhokela vinyamkela, na hewo womuhulika!” ");
INSERT INTO zaj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Avo mbuli za Yesu zenela himahima kila hanhu muiisi ya Galilaya. ");
INSERT INTO zaj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu na wanahina zake hamoja na Yakobo na Yohana walawa mng'anda ya nhambiko wachola hakae ya Simoni na Endelea. ");
INSERT INTO zaj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mama mkwe yake Simoni kakala mtamu wa homa, kipigiti kikija Yesu viyavikile wamulongela. ");
INSERT INTO zaj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu kamcholela, kamgoga mkono kamwinula. Homa imulawa, na heyo kasonga kuwasang'hanikila. ");
INSERT INTO zaj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ichungulo zua vidiswile, wanhu wamgalila Yesu watamu wose na awo wakalile na vinyamkela. ");
INSERT INTO zaj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wanhu wose wa mkiwambo waiting'hana haulongozi wa ing'anda. ");
INSERT INTO zaj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu kawahonya wanhu bwando wakalile na vitamu va namna zose na kuwinga vinyamkela bwando. Hawalekile vinyamkela walonge kinu chochose, kwavija wamtanga heyo iyo yalihi. ");
INSERT INTO zaj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Imitondo iyagwe ulukwili, zua hadinalawa, Yesu kenuka, kalawa mng'anda. Kachola kutali na ikiwambo hanhu halibule wanhu kutambika. ");
INSERT INTO zaj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na wayage wachola kumzahila. ");
INSERT INTO zaj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Viwamuwene wamulongela, “Wanhu wose wokuzahila gweye.” ");
INSERT INTO zaj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ila Yesu kawalongela, “Tucholeni hana iviwambo viyagwe vituzunguluke. Nolondigwa nikaupete Usenga Unogile hiko nako, kwavija ino iyo sang'hano iminzile.” ");
INSERT INTO zaj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Avo kachola kila hanhu muisi ya Galilaya yowapetela wanhu muna zing'anda za nhambiko na kuwinga vinyamkela. ");
INSERT INTO zaj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Munhu imwe yakalile na dikulu keza ha Yesu, kafugama mavindi kaiyalala yolonga, “Uhalonda, kodaha kunihonya.” ");
INSERT INTO zaj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu kamwonela bazi, kagolosa mkono wake kamkwasa, kalonga, “Nolonda, hona!” ");
INSERT INTO zaj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Baho utamu umulawa, kahona. ");
INSERT INTO zaj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Abaho, Yesu kamulongela yachole na zake kuno yomzuma yolonga, ");
INSERT INTO zaj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Tegeleza, sambiumulongele munhu yoyose mbuli ino, ila genda dimwe kwa dimwe ha mkulu wa nhambiko yakulole goya. Abaho, ukalave nhosa kamba viyalagize Musa, giladi wanhu wose watogole kamba kuhona.” ");
INSERT INTO zaj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ila munhu ija kachola na kasonga kubwililisa mbuli ija kila hanhu. Kweli kailonga ng'hani mbuli ija mbaka Yesu hadahile kwingila mkiwambo kimwagaia. Avo kakala hanhu halibule wanhu, na wanhu wamwizila kulawa kila hanhu. ");
INSERT INTO zaj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mazua madodo hamwande, Yesu kabweleganya Kapenaumu, mbuli zija zibwililika kamba kaukae. ");
INSERT INTO zaj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Avo, wanhu bwando waiting'hana hamoja mbaka kukala haduhu hanhu hasigale, wakala wamemile mbaka haluhelengo. Na heyo kawapetela Usenga Unogile. ");
INSERT INTO zaj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Abaho, weza wanhu, wamgalila munhu yaholole, yakalile yapapigwe na wanhu wane wakalile mmwanza wao. ");
INSERT INTO zaj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Avija wanhu viwamemile, hawadahile kumgala ija imunhu ha Yesu. Avo watenda zonzo mkiswili walinga hayali Yesu. Viwatendile idizonzo, wamuhumulusa hasi ija imunhu, yawasile mulusazi. ");
INSERT INTO zaj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Viyaiwene nhamanila yao, Yesu kamulongela ija imunhu yaholole, “Mwanangu, vilozo vako vigeligwa kumgongo.” ");
INSERT INTO zaj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wafundiza wayagwe wa Malagizo ga Musa wakalile baho, wasonga kugelegeza munda kwa munda. ");
INSERT INTO zaj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Habali munhu ino yolonga kamba vino? Uno ufukuzi! Mulungu yeiyeka yodaha kugela kumgongo vilozo va wanhu!” ");
INSERT INTO zaj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Bahaja Yesu kagatanga gaja gawakalile wogelegeza, avo kawalongela, “Habali mgelegeza vinhu kamba avo? ");
INSERT INTO zaj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Dilihi dibuhile ng'hani, kumulongela munhu yaholole ‘Vilozo vako vigeligwa kumgongo,’ ama kulonga, ‘Ima wima upape lusazi lwako, utembele?’ ");
INSERT INTO zaj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nolonda m'vitange kamba, nie, Mwana wa Munhu, nna udaho wa kuvigela kumgongo vilozo va wanhu muisi.” Abaho kamulongela ija imunhu yaholole, ");
INSERT INTO zaj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ima wima, papa lusazi lwako, uchole ukae yako!” ");
INSERT INTO zaj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hameso gao ija imunhu kenuka kapapa lusazi lwake himahima kachola. Wanhu wose wakanganya ng'hani wamuyenzi Mulungu wolonga, “Hatunayona mbuli kamba ino!” ");
INSERT INTO zaj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu kabweleganya kabili mumgwazo wa Idilamba da Galilaya. Wanhu bwando wamwizila, na heyo kasonga kuwafundiza. ");
INSERT INTO zaj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Viyakalile yobita, kamona muwila kodi yokemigwa Lawi, mwana wa Alufayo, yakalile muna ing'anda yake ya kulihila kodi. Yesu kamulongela, “Ng'holeleza.” Lawi kenuka kamkoleleza. ");
INSERT INTO zaj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu viyakalile yoja mng'anda ya Lawi, wawila kodi bwando na wene vilozo wayagwe wakala woja na heyo hamoja na wanahina zake, kwavija kukala na wanhu bwando wakalile womkweleleza. ");
INSERT INTO zaj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wafundiza Malagizo ga Musa, wakalile Mafalisayo, viwamuwene Yesu yoja na wawila kodi na wene vilozo wayagwe, wawauza wanahina zake, “Habali yoja na wanhu kamba wano?” ");
INSERT INTO zaj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu kawahulika na kawalongela, “Wanhu wagima hawamulonda mganga, ila waja wali watamu wawo womulonda. Sizile kuwakema wanhu walibule vilozo ila wanhu wali na vilozo.” ");
INSERT INTO zaj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wanahina wa Yohana M'batiza na wanahina wa Mafalisayo wakala wofunga. Wanhu wayagwe wamwizila Yesu wamuuza, “Habali wanahina wa Yohana M'batiza na wanahina wa Mafalisayo wofunga, ila wanahina zako hawafunga?” ");
INSERT INTO zaj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu kawedika, “Mokwagiza wahenza halusona lwa zengele wacholaga bila kuja? Nokona havilumba! Kipigiti chose chondawakale na mulawilamhambe havidahika kufunga. ");
INSERT INTO zaj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ila kipigiti chovika mulawilamhambe vondayasegezigwe kumwao, baho hondawasonge kufunga. ");
INSERT INTO zaj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Haduhu munhu yokanha kidanga muna ikivalo cha sambi na kukigela muna ikivalo cha umwaka, kwavija yahatenda avo ikidanga cha sambi chobananga ikivalo cha umwaka, na hanhu hadegeke hokongezeka. ");
INSERT INTO zaj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Haduhu munhu yogela divai ya sambi muna ivibuyu va umwaka vitendigwe na kwembe. Kwavija yahatenda avo idivai ya sambi yovitula ivibuyu, idivai yokwitika na ivibuyu vobanangika. Ila divai ya sambi yogeligwa muna ivibuyu va sambi vitendigwe na kwembe.” ");
INSERT INTO zaj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yesu kakala yobita muna imigunda ya ngano Mdizua da Mhumulo na wanahina zake. Viwakalile wotembela mnzila, wanahina zake wasonga kufyola zisota za gamakungwi ga ngano. ");
INSERT INTO zaj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Avo Mafalisayo wamuuza Yesu, “Lola! Wanahina zako wotenda gagomeswe kutendigwa Mdizua da Mhumulo!” ");
INSERT INTO zaj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu kawedika, “Hamsomile kija chayatendile Daudi kipigiti heyo na wayage viwakalile na nzala? ");
INSERT INTO zaj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kengila mdihema da Mulungu kaija imikate ilavigwe nhosa ha Mulungu, na iyagwe kawagwelela wayage. Vinhu vikalile vigomeswe Mmalagizo getu kudigwa na munhu yoyose ila wakulu wa nhambiko weiyeka. Gano galawilila kipigiti kija Abiatali viyakalile Mkulu wa Wakulu wose wa Nhambiko.” ");
INSERT INTO zaj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Abaho, Yesu kamambukiza, “Zua da Mhumulo dikiligwa wanhu na si wanhu wekiligwe Zua da Mhumulo.” ");
INSERT INTO zaj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Avo nie, Mwana wa Munhu, nene Mndewa wa Zua da Mhumulo. ");
INSERT INTO zaj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Abaho, Yesu kabweleganya kabili muing'anda ya nhambiko. Amo kukala na munhu yali na mkono uholole. ");
INSERT INTO zaj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wanhu wayagwe wakalile haja wakala wozahila kilamso cha kumtagusila Yesu, avo wamulola ng'hani wone kamba kohonya Mdizua da Mhumulo. ");
INSERT INTO zaj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu kamulongela ija imunhu yali na mkono uholole, “Ima hano haulongozi wa wanhu wose.” ");
INSERT INTO zaj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Abaho, Yesu kawauza waja iwanhu, “Malagizo getu gotulongela tutende kinhu chaki Mdizua da Mhumulo? Kutenda ganogile ama gehile? Kuukombola ugima wa munhu ama kuubananga?” Ila hawalongile kinhu chochose. ");
INSERT INTO zaj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu kawalola wanhu wose na lusango, ila kipigiti kikija kona bazi na giogio sama yao, kwavija wakala na mioyo midala na wapotela. Abaho, kamulongela ija imunhu, “Golosa mkono wako.” Na heyo kaugolosa, na mkono wake uhona. ");
INSERT INTO zaj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Avo Mafalisayo walawa hanze ya ing'anda ya nhambiko na waiting'hana na wanhu wa Helode, na wasonga kuzahila nzila ya kumkoma Yesu. ");
INSERT INTO zaj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu na wanahina zake wachola kuna Idilamba da Galilaya na dale kulu da wanhu dimkweleleza. ");
INSERT INTO zaj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Viwahulike gaja gose goyokala yotenda, wanhu bwando wamwizila kulawa Yudea, Yelusalemu, Idumea, na isi za mwambu wa ikabili wa Ulwanda lwa Yolodani, na isi zose zizunguluke Tilo na Sidoni. ");
INSERT INTO zaj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kwavija kukala na dale kulu da wanhu, Yesu kawalongela wanahina zake wamwikile goya ngalawa, giladi wanhu sambiwamkukusule. ");
INSERT INTO zaj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesu kawahonya wanhu bwando, na wanhu wose wakalile watamu wakiibabanika womcholela giladi wamgoge. ");
INSERT INTO zaj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na vinyamkela viwamuwene Yesu, wawagwisa hasi wanhu iwawavagale haulongozi wake, waguta nyangi, walonga, “Gweye iyo Mwana wa Mulungu!” ");
INSERT INTO zaj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ila Yesu kawalagiza vinyamkela sambiwamulongele munhu yoyose kamba heyo iyo yalihi. ");
INSERT INTO zaj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu kakwela mkigongo na kuwakema wanhu yaawalondile, na hewo wamuwinza. ");
INSERT INTO zaj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kawasagula wanhu longo dimwe na wabili awo vivija yaawakemile watumigwa wa Kilisto, wondawakale na heyo na yondayawatume wachole kuupeta Usenga Unogile, ");
INSERT INTO zaj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na kawagwelela udaho wa kuwinga vinyamkela. ");
INSERT INTO zaj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na wano iwo wanhu longo dimwe na wabili yaawasagule Yesu. Simoni, Yesu yamgwelele twaga da Petulo, ");
INSERT INTO zaj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo na ndugu yake Yohana, wana wa Zebedayo, Yesu yaawakemile Boaneji, nhegulo yake, “Wana wa Mdumo,” ");
INSERT INTO zaj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Endelea, Filipo, Batolomayo, Matayo, Tomaso, Yakobo mwana wa Alufayo, Tadayo, Simoni yakalile yokemigwa Mgombeleza Isi ya Islaeli, ");
INSERT INTO zaj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuda Isikalioti yamuhonzile Yesu. ");
INSERT INTO zaj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu kachola ukae. Dale kulu da wanhu waiting'hana mwanza uyagwe mbaka Yesu na wanahina zake hawapatile kipigiti cha kuja. ");
INSERT INTO zaj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mulango wake viwahulike, wachola kumsola kwavija wanhu wakala wolonga, “Kana luwege!” ");
INSERT INTO zaj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wafundiza wayagwe wa Malagizo ga Musa walawile Yelusalemu walonga, “Kana Belizebuli, mkulu wa vinyamkela iyo yomgwelela mhiko za kuwinga vinyamkela.” ");
INSERT INTO zaj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Avo Yesu kawakema na kawalongela mmahala, “Mwenembago kodahaze kukiiwinga mwenyego? ");
INSERT INTO zaj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kamba undewa uhaigola mmadalemadale, gogomba genyego kwa genyego, undewa hiwo wopwililika.” ");
INSERT INTO zaj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kamba mulango uhaigola mmadalemadale, gogomba genyego kwa genyego, mulango hiwo wopwililika. ");
INSERT INTO zaj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Avo kamba undewa wa Mwenembago uhaigola mmadalemadale haugendelela, ila wopwililika na kupotela. ");
INSERT INTO zaj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Haduhu munhu yodaha kwingila mng'anda ya munhu yali na mhiko na kumsolela vinhu vake, mbaka yanduse kumfunga munhu iyo yali na mhiko. Abaho, leka yadahe kum'boka vinhu vake. ");
INSERT INTO zaj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nowalongela ikweli, vilozo vose na mbuli zose za ufukuzi za wanhu vogeligwa kumgongo. ");
INSERT INTO zaj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ila munhu yoyose yondayamfukulile Loho wa Mulungu, havidahika kugeligwa kumgongo, kwavija katenda vilozo va digunge.” ");
INSERT INTO zaj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu kalonga vino kwavija wakala wolonga, “Kana kinyamkela.” ");
INSERT INTO zaj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Abaho, mamaake na wadodo zake Yesu weza. Wema hanze, wamulagiza munhu yengile mng'anda yakamkeme. ");
INSERT INTO zaj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dale da wanhu wakalile wamzunguluke, wamulongela, “Mamaako na wadodo zako na lumbu zako wakunze wokuzahila.” ");
INSERT INTO zaj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu kawedika, “Mamaangu yalihi? Na wadodo zangu walihi?” ");
INSERT INTO zaj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Abaho, kawalola wanhu wamzunguluke na kulonga, “Wano iwo mamaangu na wadodo zangu! ");
INSERT INTO zaj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Munhu yoyose yogatenda gaja goyolonda Mulungu, heyo iyo mdodo wangu, lumbu jangu, na mamaangu.” ");
INSERT INTO zaj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu kasonga kufundiza mumgwazo wa Idilamba da Galilaya. Wanhu kombenakombena wammemela womzunguluka wakala dale kulu, avo kengila mngalawa na kakala himo. Ija ingalawa ikala mumgwazo wa idilamba, na ididale da wanhu wakala wemile mhwani, mulugigo lwa igamazi. ");
INSERT INTO zaj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kawafundiza vinhu bwando mmahala. ");
INSERT INTO zaj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Yolonga, “Tegelezeni! Mulimi kachola kuhanda mbeyu. ");
INSERT INTO zaj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Viyakalile yomiza, ziyagwe zilagalila mnzila, ndege weza wazija. ");
INSERT INTO zaj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ziyagwe zilagalila muna uulongo uli na mabwe, hakalile na ulongo mdodo. Hima zimbeyu zota, kwavija ulongo ukala mdodo. ");
INSERT INTO zaj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Zua vidilawile diilukuza imiche, na kwavija ikala na mizizi midodo imiche inyala. ");
INSERT INTO zaj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mbeyu ziyagwe zilagalila mmizomola, imizomola ikula na kuizingiliza imiche, avo hailelile. ");
INSERT INTO zaj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ila ziyagwe zilagalila hana ulongo unogile, zota, zikula na kulela, ziyagwe zilela malongo madatu, ziyagwe zilela malongo sita, na ziyagwe zilela mia.” ");
INSERT INTO zaj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu kamambukiza, “Munhu yali na magwiti na yahulike!” ");
INSERT INTO zaj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu viyakalile yeiyeka, wanahina zake longo dimwe na wabili na wanhu wakalile womtegeleza, wamcholela wamulongela yawalongele nhegulo ya mahala gaja. ");
INSERT INTO zaj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu kawedika, “Mweye mgweleligwa nyong'onyo za Undewa wa Mulungu, ila wanhu wali kunze wohulika vinhu vose mmahala, ");
INSERT INTO zaj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","giladi, ‘Walole, Ila sambiwone, Wahulike, Ila sambiwavitange, Kwavija wahavitanga, womuhindukila Mulungu, Na heyo kovigela kumgongo vilozo vao.’ ” ");
INSERT INTO zaj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Abaho, Yesu kawauza, “Avo kamba hamditanga hala dino, mogatangaze mahala gayagwe? ");
INSERT INTO zaj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Imunhu yohanda kohanda imbuli ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wanhu wayagwe walinga kamba mbeyu zilagalile mnzila, haja imbuli ya Mulungu viihandigwe. Kipigiti kikija viwoihulika, Mwenembago kokwiza na kuisola imbuli ya Mulungu ihandigwe mgati yao. ");
INSERT INTO zaj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wanhu wayagwe walinga kamba mbeyu zilagalile muulongo uli na mabwe. Woihulika imbuli ya Mulungu, na kipigiti kikija woibokela mkudeng'ha. ");
INSERT INTO zaj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ila haiwengila mgati ng'hani avo haikala kipigiti kitali. Uhalawila mgayo ama kugazigwa sama ya imbuli ya Mulungu, woileka hima. ");
INSERT INTO zaj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wanhu wayagwe walinga kamba mbeyu zilagalile mmizomola. Wanhu wano iwo waihulike imbuli ya Mulungu, ");
INSERT INTO zaj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ila mzahimzahi wa ulumwengu uno, kunogela mali na msulukilo wa vinhu bwando viyagwe mmioyo yao voizingiliza imbuli ya Mulungu, avo hawalela mujo. ");
INSERT INTO zaj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ila wanhu wayagwe walinga kamba mbeyu zilagalile muna ulongo unogile. Waihulika imbuli ya Mulungu na waitogola na kulela mujo, wayagwe malongo madatu, wayagwe malongo sita na wayagwe mia.” ");
INSERT INTO zaj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu kagendelela kulonga, “Vino kuna munhu yogala mng'anda kiwenge na kukigubika na kinongo ama kukika hauvungu wa lusazi? Nokona si vivo! Kokika mkingolobweda. ");
INSERT INTO zaj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kinhu chochose kifisigwe chovumbuligwa, na kinhu chochose kigubikigwe chogubuligwa. ");
INSERT INTO zaj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Munhu yali na magwiti na yahulike.” ");
INSERT INTO zaj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Vivija kawalongela, “Gagelegezeni ng'hani gaja gomuhulika! Mhima iija yondamuwapimile wayagwe, iyo mhima yondampimilwe mweye, tena yobanziliza. ");
INSERT INTO zaj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Waja wali na kinhu wokongezeligwa, na waja walibule kinhu, wobokigwa hata kija ikinhu kidodo kiwalinacho.” ");
INSERT INTO zaj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu kagendelela kulonga, “Undewa wa Mulungu ulinga na munhu yomiza mbeyu mumgunda wake. ");
INSERT INTO zaj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ikilo kowasa na imisi kameso, kipigiti kino chose zimbeyu zozuka na kukula. Ila mwenyego havimanya mbuli zino vuzitendeka. ");
INSERT INTO zaj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ulongo wenyego woutenda umche ukule na kulela. Wosonga koneka umche, abaho matepo, abaho ngano muna imikungwi. ");
INSERT INTO zaj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ngano ihakangala, iyo imunhu kosonga kusenga na zele jake, kwavija kipigiti cha kusenga kivika.” ");
INSERT INTO zaj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu kalonga, “Undewa wa Mulungu tuulinge na choni? Tuulonge mdihala jaki? ");
INSERT INTO zaj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ulinga kamba munhu yasolile mbeyu ya haladali, mbeyu ndodo kubita mbeyu zose muulumwengu, na kuzihanda muisi. ");
INSERT INTO zaj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mkipigiti kiguhi yokula yowa biki kulu ng'hani kubanza mibiki yose na kulava mitambi mikulu mbaka ndege wokwiza na kuzenga mvulu zao muna imbeho yake.” ");
INSERT INTO zaj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu kawapetela wanhu mbuli zake mmahala bwando galingile na gano. Kawalongela kamba viwadahile kuvitanga. ");
INSERT INTO zaj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Halongile nao chochose bila mahala. Ila viyakalile yeiyeka na wanahina zake, kawalongela kila kinhu. ");
INSERT INTO zaj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ichungulo ya zua didija, Yesu kawalongela wanahina zake, “Tuloke mwambu wa ikabili wa idilamba.” ");
INSERT INTO zaj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Avo wadileka dale da wanhu, wanahina wengila mngalawa ija Yesu yaakalile yeshile kukala, wamsola wachola hamoja nayo. Ngalawa ziyagwe vivija zikala bahaja. ");
INSERT INTO zaj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Baho dilawilila kukuzumbi, na mawimbi gasonga kuikunhiza ingalawa, avo isonga kumema mazi. ");
INSERT INTO zaj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu kakala kukisogo mwa ingalawa kawasa kuno pala jake kasagamila muna umto. Wanahina wamulamusa wamulongela, “Mkulufunzi! Hukona vihile vitulonda kudanganhika?” ");
INSERT INTO zaj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu kema wima kadikomhokela dibeho, yolonga, “Nyamala!” Na kagalongela ga mawimbi, “Ituze!” Beho dinyamala, na kukala hapozike. ");
INSERT INTO zaj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Abaho, Yesu kawalongela wanahina zake, “Habali mkona bwembwe? Mng'hali mwabule nhamanila?” ");
INSERT INTO zaj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ila wakala wodumba ng'hani na wakala wokiilongela, “Munhu waki ino? Hata beho na mawimbi vomuhulika!” ");
INSERT INTO zaj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na wanahina zake wavika mwambu uyagwe wa Idilamba da Galilaya muisi ya Gelasi. ");
INSERT INTO zaj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kipigiti kikija Yesu viyahumuluke muna ingalawa, munhu yali na vinyamkela kulawa kuna gamapanga hima kamwizila. ");
INSERT INTO zaj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Munhu ino kakala yokala kuna gamapanga, haduhu munhu yadahile kumfungiliza hata na mnyolo. ");
INSERT INTO zaj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mianza bwando wamdaza gamagulu na makono gake na mhikwi na minyolo, ila kaitola iminyolo na kuzibena zimhikwi ziwamdazile mmagulu gake. Haduhu munhu yakalile na mbavu za kumgoga. ");
INSERT INTO zaj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Imisi na ikilo kakala yoembea mmapanga na m'vigongo yoguta nyangi na kuikanhakanha na mabwe. ");
INSERT INTO zaj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Viyamuwene Yesu yang'hali kutali, kamkimbilila, kamfugamila mavindi, ");
INSERT INTO zaj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","kaguta lwangi, kalonga, “Yesu, Mwana wa Mulungu Mkulu Ng'hani! Konilonda choni? Mtwaga da Mulungu, nokuyalalila, sambiungaze!” ");
INSERT INTO zaj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kalonga vino kwavija Yesu kakala yomulongela, “Kinyamkela, mulawe munhu ino!” ");
INSERT INTO zaj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Avo Yesu kamuuza, “Twaga jako dijo dilihi?” Ija imunhu kamwidika, “Twaga jangu ‘Dale’ kwavija twa bwando!” ");
INSERT INTO zaj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kagendelela kumuyalalila Yesu sambiyawawinge walawe muisi ija. ");
INSERT INTO zaj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kukala na dale kulu da mitumbi behi na haja, woja hana ikigongo. ");
INSERT INTO zaj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Avo ivinyamkela wamuyalalila Yesu wolonga, “Tugale ha imitumbi, na utuleke tukaiingile.” ");
INSERT INTO zaj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu kawaleka wachole, na ivinyamkela wamulawa munhu ija na kuiingila imitumbi. Dale jose da imitumbi divikila alufu mbili, dihumuluka mdigema, dingila mdilamba na kudanganhikila mmazi. ");
INSERT INTO zaj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wachunga wa imitumbi wakimbila, wabwililisa mbuli zija mkiwambo na mmigunda. Wanhu wachola kulola kija kilawilile. ");
INSERT INTO zaj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Viwavikile ha Yesu, wamona munhu ija yakalile na dale da vinyamkela, kakala hasi, kavala na yali na nzonzi zake, na wanhu wose wona bwembwe. ");
INSERT INTO zaj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Waja wagonile gaja wawalongela wanhu gaja gamulawilile ija imunhu yali na vinyamkela na mbuli za ija imitumbi. ");
INSERT INTO zaj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Avo wanhu wamulongela Yesu yasegele muundewa wao. ");
INSERT INTO zaj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu viyakwelile mngalawa, ija imunhu yakalile na vinyamkela kaiyalala yomulongela, “Nolonda tuchole tose.” ");
INSERT INTO zaj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ila Yesu kamgomesa, kamulongela, “Genda hakae yako mmulango wako na uwalongele mbuli zose zayakutendele Mndewa na vija viyakonele bazi.” ");
INSERT INTO zaj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Avo munhu ija kasegela kachola muna iviwambo longo dimwe vikemigwa Dekapoli, yopeta gaja Yesu gayamtendele. Na wanhu wose wahulike wakanganya ng'hani. ");
INSERT INTO zaj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu kakwela kabili muingalawa, kabweleganya mwambu uyagwe wa idilamba, ako dale kulu da wanhu kudiilundize muimhwani dimzunguluka heyo. ");
INSERT INTO zaj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mkulu imwe wa ing'anda ya nhambiko, yokemigwa Yailo, kavika. Viyamonile Yesu, kaibwanha hasi ha magulu gake, ");
INSERT INTO zaj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kaiyalala kamulongela yomgong'ondeza, “Mndele wangu imdodo mtamu ng'hani. Avo izo umwikile makono gako yahone!” ");
INSERT INTO zaj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Avo Yesu kachola nayo. Wanhu bwando wamkoleleza wakala wokiibabana nayo ng'ambu zose. ");
INSERT INTO zaj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bahaja kukala na mtwanzi yakalile na utamu wa kutumika mkipigiti cha milao longo dimwe na mibili. ");
INSERT INTO zaj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kakala yagangigwe na mafundi bwando, kasa hela zake zose, na utamu wake ugendelela kongezeka ng'hani. ");
INSERT INTO zaj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Viyahulike singilimo za Yesu, kengila mdidale da wanhu hachugu cha Yesu na kudikwasa valo jake. ");
INSERT INTO zaj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kwavija kalonga munda kwa munda, “Nihakwasa vivalo vake, nohona.” ");
INSERT INTO zaj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Bahaja kutumika kuleka, na kakiihulika mulukuli lwake kamba kahonyigwa utamu wake. ");
INSERT INTO zaj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Bahaja Yesu kavitanga kamba mhiko zimulawa, avo kawahindukila didale da wanhu kawauza, “Yalihi yakwasile vivalo vangu?” ");
INSERT INTO zaj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wanahina zake wamwidika, “Kowona wanhu viwakumemele, habali uuza yalihi yakukwasile?” ");
INSERT INTO zaj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ila Yesu kagendelela kulolesa, yamone yatendile vija. ");
INSERT INTO zaj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mtwanzi ija kagatanga gaja gamulawilile, avo keza yogudema kuno yokona bwembwe, kaibwanha hasi ha magulu gake, kamulongela ikweli yose. ");
INSERT INTO zaj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu kamulongela, “Mndele wangu, nhamanila yako ikuhonya. Genda mditindiwalo na utamu wako uhone.” ");
INSERT INTO zaj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu viyakalile yolonga vija, weza wasenga kulawa kung'anda ya Yailo wamulongela, “Mndele wako kadanganhika. Habali ugendelela kumgaza mkulufunzi?” ");
INSERT INTO zaj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu hagategeleze gaja iwasenga gawalongile, ila kamulongela Yailo, “Sambiudumbe, tamanila tu.” ");
INSERT INTO zaj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Abaho, Yesu hamtogoze munhu yoyose yachole nayo ila Petulo, Yakobo, na Yohana ndugu yake Yakobo. ");
INSERT INTO zaj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wavika hang'anda ya Yailo, Yesu kona kiyahiyahi na wanhu wolila na kulombokeza. ");
INSERT INTO zaj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kengila mng'anda na kuwalongela, “Kiyahiyahi chose kino cha choni? Habali mulila? Mwana hadanganhike ino, ila kawasa!” ");
INSERT INTO zaj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wamseka, avo kawalava kunze wose, kawasola tata na mama wa imwana na wanahina zake wadatu, abaho, wengila kugati kuyatambalikigwe imwana. ");
INSERT INTO zaj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kamgoga mkono na kumulongela, “Talita komu!” Nhegulo yake, “Mndele, nokulongela, lamuka!” ");
INSERT INTO zaj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kipigiti kikija ija imndele kenuka, kasonga kutembela, kwavija kakala na milao longo dimwe na mibili. Vigalawilile gano wanhu wakanganya ng'hani. ");
INSERT INTO zaj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ila Yesu kawagomesa yowagong'ondeza, sambiwamulongele munhu yoyose, abaho, kawalongela, “Mgweleleni kinhu cha kuja.” ");
INSERT INTO zaj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu kahalawa haja kabwela hakiwambo cha hakae yake, na wanahina zake wamkweleleza. ");
INSERT INTO zaj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Muna Dizua da Mhumulo Yesu kasonga kufundiza muna ing'anda ya nhambiko, kukala na wanhu bwando, na viwamuhulike, wanhu wose wakanganya, walonga, “Kagapata kwahi mafundizo gano gose? Na ng'hungwe yaki ino yagweleligwe, na kodahaze kutenda mizonza? ");
INSERT INTO zaj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ino sio salamala, mwanage Maliamu, na mkulu wao kina Yakobo, Usufu, Yuda, na Simoni? Na walumbu zake si wano wokala bahano?” Avo wamulema. ");
INSERT INTO zaj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu kawalongela, “Wahokozi wohishimilwa kila hanhu, ila hawahishimilwa m'viwambo vao wenyego na mwa wandugu zao na mmilango yao wenyego.” ");
INSERT INTO zaj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hadahile kutenda mizonza yoyose haja, ila kawekila makono gake watamu wabili wadatu kawahonya. ");
INSERT INTO zaj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kakanganya ng'hani, avija wanhu wa haja viwalibule nhamanila. Abaho, Yesu kachola kuna iviwambo vizunguluke haja, yowafundiza wanhu. ");
INSERT INTO zaj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu kawakema wanahina longo dimwe na wabili hamoja, na kawatuma wabiliwabili. Kawagwelela udaho wa kuwinga vinyamkela ");
INSERT INTO zaj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","na kawalagiza, yowalongela, “Sambimsole kinhu chochose mmwanza wenu, ila fimbo iiyeka. Sambimsole mkate, mkoba, ama hela. ");
INSERT INTO zaj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Valeni ng'hwabasa, ila sambimpape kivalo kiyagwe.” ");
INSERT INTO zaj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Vivija kawalongela, “Hanhu hohose hondam'bokeligwe, kaleni baho mbaka vondamsegele. ");
INSERT INTO zaj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kamba muhengila mkiwambo na wanhu wahalema kuwabokela ama wahalema kuwategeleza, segeleni na kung'unheni timbwisi dili mmagulu genu. Iyo yowa nzuma yao!” ");
INSERT INTO zaj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Avo wachola na kuwapetela wanhu waleke vilozo vao. ");
INSERT INTO zaj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wawinga vinyamkela bwando, na kuwabakaza mavuta ga mizaituni watamu na kuwahonya. ");
INSERT INTO zaj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mndewa Helode Antipa, mtawala wa Galilaya, kazihulika mbuli zino, kwavija sang'hano za Yesu zenela kila hanhu. Wanhu wayagwe walonga, “Yohana M'batiza kazuka. Kino kicho kilamso kana mhiko zino za kutenda mizonza.” ");
INSERT INTO zaj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wayagwe walonga, “Ino iyo Eliya.” Na wayagwe walonga, “Ino iyo muhokozi yalingile kamba imwe wa wahokozi wa umwaka.” ");
INSERT INTO zaj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Helode viyahulike, kalonga, “Ino iyo Yohana M'batiza! Nimkanhile pala jake, kawa mgima kabili!” ");
INSERT INTO zaj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kwavija Helode mwenyego kakala yalagize Yohana yagogigwe, abaho, yageligwe mkifungo. Katenda vino sama ya Helodia mtwanzi wa Filipo mkulu wake, ayo yakalile yamsolile. ");
INSERT INTO zaj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kwavija Yohana kakala yananahile kumulongela Helode, “Havilumbile gweye kumsola mtwanzi wa mkulu wako Filipo.” ");
INSERT INTO zaj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Avo Helodia kamwihila Yohana, kalonda kumkoma, ila hadahile. ");
INSERT INTO zaj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helode kamdumba Yohana kwavija kavitanga kamba Yohana hakalile munhu kizenzeleganye na kakala munhu wa Mulungu, avo kamwimiliza. Kanogelwa kumtegeleza, ila yehesha kumtegeleza kakala yogaya ng'hani mkugelegeza, ila kipigiti chose kakala yomtegeleza. ");
INSERT INTO zaj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hakimambukizo, Helodia kapata nzila. Dikala zua da ng'humbukila ya mvumbuka ya Helode, kipigiti Helode vayawatendele lusona wakulu wose wa silikali, wakulu wa asikali, na wakulu wa wenekae wa Galilaya. ");
INSERT INTO zaj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mndele wa Helodia kengila na kuvina, Helode na iwahenza wakalile baho wanogelwa ng'hani. Avo mndewa kamulongela ija imndele, “Nipule kinhu chochose chuulonda, nokugwelela.” ");
INSERT INTO zaj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mkuiduila kamulongela, “Nokugwelela kinhu chochose chondaunipule, hata lwenza lwa undewa wangu.” ");
INSERT INTO zaj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Avo ija imndele kalawa kunze kumuuza mamaake, “Nikapule choni?” Na heyo kamulongela, “Pala da Yohana M'batiza.” ");
INSERT INTO zaj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ija imndele kabwela hima ha mndewa na kupula, “Nolonda unigwelele sambisambi pala da Yohana M'batiza muna ulungo!” ");
INSERT INTO zaj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mndewa kona giogio ng'hani, ila sama ya kiduilo chayaiduile na sama ya iwahenza wakalile haja hameza, hadahile kulema. ");
INSERT INTO zaj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Avo kamulagiza asikali yomkomhokela yagale pala da Yohana. Asikali kachola mding'anda da kufungila wanhu, na kukanha pala da Yohana. ");
INSERT INTO zaj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Abaho, kadigala mulungo na kumgwelela imndele, na heyo kamgwelela mamaake. ");
INSERT INTO zaj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wanahina wa Yohana viwahulike gano, weza kulusola lukuli lwake na kuluzika. ");
INSERT INTO zaj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iwatumigwa wa Kilisto wabwela waiting'hana na Yesu wamulongela gose gawatendile na kufundiza. ");
INSERT INTO zaj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kukala na wanhu bwando wayagwe wokwiza na wayagwe wochola mbaka Yesu na wanahina zake hawapatile hata kipigiti cha kuja. Avo Yesu kawalongela, “Tusegeleni tuchole hanhu ha kifiso, muhumule kidogo.” ");
INSERT INTO zaj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Avo wakwela mngalawa wasonga kusegela weiyeka, wachola hanhu ha kifiso. ");
INSERT INTO zaj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Wanhu bwando wawona vowosegela, mkipigiti kiguhi wawatanga, avo wanhu kulawa m'viwambo vose wakimbila na magulu na walongola kuvika hanhu hayakalile yochola Yesu na wanahina zake. ");
INSERT INTO zaj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu viyahumuluke muna ingalawa, kajona dale kulu da wanhu, kawonela bazi mmoyo kwavija wakala kamba ng'hondolo walibule mchunga. Avo kasonga kuwafundiza vinhu bwando. ");
INSERT INTO zaj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Zua vidiswile, wanahina zake wamcholela wamulongela, “Zua diswa na hano hatuli twa muluwala, ");
INSERT INTO zaj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","walongele wanhu wachole mmigunda na m'viwambo va mmabehi giladi wakagule vinhu vakuja.” ");
INSERT INTO zaj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu kawedika, “Wagweleleni mwenye vinhu vakuja.” Na hewo wamuuza, “Kolonda tuchole tukawagulile mikate ya kitumetume cha munhu cha milenge minane tuwagwelele waje?” ");
INSERT INTO zaj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Avo Yesu kawauza, “Mikate mingahi imulinayo? Gendeni mkalole.” Viwayonile, wamulongela, “Ilibaho mikate mitano na somba wabili.” ");
INSERT INTO zaj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Abaho, Yesu kawalongela wanahina zake wawagole wanhu wose muna gamadale na kuwalongela wakale hasi muluzondo. ");
INSERT INTO zaj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Avo wanhu wakala hasi mmadale ga wanhu miamia na wanhu malongo matanomatano. ");
INSERT INTO zaj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Abaho, Yesu kaisola ija imikate mitano na iwasomba wabili, kalola uchana kuulanga, na kamgwelela hewela Mulungu. Kaimogola imikate na kuwagwelela wanahina zake wawagolele wanhu. Vivija kawagolela iwasomba wabili wanhu wose. ");
INSERT INTO zaj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wanhu wose waja na kwiguta. ");
INSERT INTO zaj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Abaho, wanahina wadondola migelo longo dimwe na mibili ya imikate na iwasomba wasigale. ");
INSERT INTO zaj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mheta ya wambigalo wadile wakala alufu tano. ");
INSERT INTO zaj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bahaja Yesu kawalongela wanahina zake wakwele muingalawa walongole kuchola Betisaida, mwambu uyagwe wa idilamba, kipigiti heyo vayakalile yowalaga wanhu. ");
INSERT INTO zaj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Viyeshile kuwalaga iwanhu, kachola hakigongo kutambika. ");
INSERT INTO zaj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Viivikile ichungulo, ngalawa ikala hadidindi da idilamba, kipigiti Yesu viyakalile yeiyeka mulusanga. ");
INSERT INTO zaj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kawona wanahina zake wogaya kuzikunhiza zinyiko kwavija wakala wochola kudilawa beho, avo mkipigiti cha hagatigati ya nzogolo zikwika na imitondo, kawacholela yotembela uchana ya igamazi. Kalonda kuwabita, ");
INSERT INTO zaj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ila wamona yotembela uchana ya igamazi. Watoa nyangi wagiza wona mzimu. ");
INSERT INTO zaj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Wose viwamuwene wona bwembwe. Bahaja Yesu kawalongela, “Iyo nie, sambimdumbe.” ");
INSERT INTO zaj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Abaho, kakwela mngalawa hamoja nao, na dibeho dinyamala. Wanahina zake wakanganya ng'hani. ");
INSERT INTO zaj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kwavija hawakitangile kilamso cha kuwagwelela mandia wanhu alufu tano, nzonzi zao hazigogile gaja. ");
INSERT INTO zaj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Waloka idilamba na wavika muisi ya Genesaleti, aho hawaitatilize ngalawa yao. ");
INSERT INTO zaj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Viwahumuluke mngalawa bahaja wanhu wamtanga Yesu. ");
INSERT INTO zaj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Avo wanhu wakimbila muna iisi yose, wasonga kuwagala watamu mmachela kokose kuwamuhulike. ");
INSERT INTO zaj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na kila hanhu Yesu kuyacholile m'viwambo, mmiwambo, ama mmigunda, wanhu wawasola watamu wawagala hadisoko na wamuyalalila womulongela yawaleke wakwase hata lugigo lwa kivalo chake, na wose wakwasile wahona. ");
INSERT INTO zaj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafalisayo wayagwe na wafundiza Malagizo ga Musa walawile Yelusalemu weza wailundiza haulongozi wa Yesu. ");
INSERT INTO zaj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wona wanahina wayagwe wa Yesu woja vakuja kuno makono gao ganyolodoke, kwavija gakala hagananavigwa. ");
INSERT INTO zaj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kwavija Mafalisayo na Wayahudi wose, hawaja mbaka wasunguse ng'hani makono gao kamba viilondigwa, sama ya kuwinza mafundo ga wahenga zao. ");
INSERT INTO zaj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hawaja kinhu chochose kilawa hadisoko mbaka wakisuluze. Na wawinza mafundo bwando gawabokele kulawa mwa wahenga zao, kamba vija, kusuluza vikasi, viteleko, na via va shaba. ");
INSERT INTO zaj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Avo, Mafalisayo na wafundiza Malagizo ga Musa wamuuza Yesu, “Habali wanahina zako hawagawinza mafundo gatufundizigwe na wahenga, ila woja na makono ganyolodoke?” ");
INSERT INTO zaj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu kawedika yolonga, “Muhokozi Isaya kahokola goya viyahokole yowalonga mweye! Mweye videlenya, kamba vija viyandike, ‘Wanhu wano wonihishimila mmilomo yao, ila mioyo yao yakutali na nie. ");
INSERT INTO zaj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wonitambikila nie bule, kwavija wofundiza mafundo ga wanhu kamba Malagizo gangu!’ ");
INSERT INTO zaj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mzika hamgwazo ndagizi za Mulungu, na mgawinza mafundo ga wanhu.” ");
INSERT INTO zaj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu kagendelela kulonga, “Muna ubala wa kuzilema ndagizi za Mulungu giladi mgatunize mafundo genu wenyego. ");
INSERT INTO zaj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa kalagiza, ‘Wahishimile tataako na mamaako,’ na ‘Munhu yoyose yomulonga vihile tataake ama mamaake, yakomigwe.’ ");
INSERT INTO zaj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ila mweye mofundiza kamba, kamba munhu kana kinhu cha kumgwelela tata ama mamaake, ila yahalonga, ‘Kinhu kino kicho Kolubani,’ nhegulo yake, ‘Nhosa ya Mulungu,’ ");
INSERT INTO zaj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","avo halondigwa kuwataza mkuwagwelela vinhu tata na mamaake. ");
INSERT INTO zaj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Vino vivo mafundo gamuwafundiza wanhu vigobeza mbuli za Mulungu. Na kuna vinhu viyagwe bwando kamba vino vimtenda.” ");
INSERT INTO zaj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Abaho, Yesu kadikema kabili didale da wanhu, kawalongela, “Nitegelezeni na m'vitange. ");
INSERT INTO zaj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Haduhu kinhu kimwingila munhu kulawa kunze chondakimtende munhu yanyolodoke. Ila kija kimulawa munhu, kicho kimtenda munhu yanyolodoke.” ");
INSERT INTO zaj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Munhu yali na magwiti ga kuhulika, na yahulike! ");
INSERT INTO zaj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Viyadilekile didale da wanhu na kwingila mng'anda, wanahina zake wamulonda yawalongele goya hala dino. ");
INSERT INTO zaj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu kawalongela, “Na mweye vivija hamnavitanga? Ham'vimanya kamba kinhu chochose kingila mgati mwa munhu kulawa kunze hakidaha kumnyolodosa, ");
INSERT INTO zaj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kwavija hakimwingila mmoyo, ila mmunda, abaho, chochola kucholo?” Viyalongile vino, Yesu kavilonga vakuja vose vidigwe. ");
INSERT INTO zaj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesu kagendelela kulonga, “Kija kimulawa munhu kicho kimtenda yanyolodoke. ");
INSERT INTO zaj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwavija kulawa mgati ya umoyo wa munhu, molawa ngelegeza zihile, ugoni, ubavi, kukoma, ");
INSERT INTO zaj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ugoni, ugila, kutenda gehile, sulukila ya ugoni, uzenzeleganye, sulukila za kulonda vinhu bwando, migongo, kuilonga vihile, magoda, na ubozi. ");
INSERT INTO zaj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mbuli zose zino zihile zilawa mgati mwa munhu na zizo zimtenda yanyolodoke.” ");
INSERT INTO zaj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu kalawa kachola muisi ili behi na wambo da Tilo. Kengila muna ing'anda imwe na halondile munhu yoyose yavitange kamba kahaja, ila hadahile kuifisa. ");
INSERT INTO zaj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mtwanzi imwe, mndele wake yakalile na kinyamkela, kahulika mbuli za Yesu, hima kamwizila kamfugamila mavindi haulongozi wake. ");
INSERT INTO zaj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mtwanzi ija kakala Mmhazi, yaleligwe ng'ambu ya Foinike muisi ya Silia. Kaiyalala yomulongela Yesu yamuwinge ikinyamkela yam'vamhile mndele wake. ");
INSERT INTO zaj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ila Yesu kamwidika, “Beta tanhu iwana wegute. Havinogile kusola mandia ga wana na kuwagwelela umbwa.” ");
INSERT INTO zaj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ija mtwanzi kamwidika, “Mndewa! Hata umbwa woja vakuja viwasigaze iwana hasi ya imeza.” ");
INSERT INTO zaj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Avo Yesu kamulongela, “Sama ya mbuli zako zino, genda ukae kom'vika kinyamkela kamulawa mndele wako!” ");
INSERT INTO zaj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kachola ukae kam'vika mwanage yawasile mulusazi, na kweli kinyamkela kamulawa. ");
INSERT INTO zaj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Abaho, Yesu kasegela muna iisi ya Tilo, kachola Lamba da Galilaya kubitila Sidoni mbaka muisi ya viwambo longo dimwe vikemigwa Dekapoli. ");
INSERT INTO zaj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Wanhu wamgalila munhu yakalile kinziwi na bubui, wamuyalalila Yesu yamwikile makono gake. ");
INSERT INTO zaj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu kamsola yeiyeka, kamgala kutali na ididale da wanhu, kagela vidole vake mmagwiti ga ija imunhu, kazenha vizite, abaho, kalukwasa lulimi lwake. ");
INSERT INTO zaj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Abaho, Yesu kalola uchana kuulanga, kabweza mhumuzi, na kumulongela ija imunhu, “Efata!” Nhegulo yake, “Vuguka!” ");
INSERT INTO zaj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bahaja munhu ija magwiti gake gahulika, kigagaziko chake kisegezigwa, avo kasonga kulongelela bila kugaya. ");
INSERT INTO zaj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Abaho, Yesu kawagong'ondeza wanhu sambiwamulongele munhu yoyose mbuli ija. Ila avija viyakalile yowagong'ondeza ng'hani vivo vowokala wobwililisa ng'hani. ");
INSERT INTO zaj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wanhu wose wahulike wakanganya ng'hani na walonga, “Kila kinhu kotenda goya! Kawatenda hata vinziwi wahulike na mabubui walonge!” ");
INSERT INTO zaj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mazua madodo hamwande, dale kulu diyagwe da wanhu waiting'hana hamoja. Wanhu wakala wabule kinhu chochose cha kuja, Yesu kawakema wanahina zake kawalongela, ");
INSERT INTO zaj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nowonela bazi wanhu wano, kwavija wakala na nie mazua madatu, na kipigiti kino wabule kinhu cha kuja. ");
INSERT INTO zaj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nihawalongela wachole mkae zao na nzala, wosinduka mnzila, kwavija wayagwe walawa kutali.” ");
INSERT INTO zaj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Wanahina zake wamuuza, “Muluwala luno kwahi munhu kondayazahile mandia ga kuwagwelela wanhu wose wano?” ");
INSERT INTO zaj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu kawauza, “Mikate mingahi imulinayo?” Wamulongela, “Mikate saba.” ");
INSERT INTO zaj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu kadilongela didale da wanhu dikale hasi. Abaho, kaisola ija imikate saba, kalonga hewela ha Mulungu, kaimogola na kuwagwelela wanahina zake wawagolele iwanhu, na wanahina watenda kamba viwalagizwe. ");
INSERT INTO zaj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Vivija wakala na visomba vidogodogo. Yesu kalonga hewela ha Mulungu, vivija kawalongela wanahina zake wawagolele iwanhu. ");
INSERT INTO zaj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wanhu wose waja weguta, wanahina zake wadondola, wamemeza migelo saba ya vakuja visigale! ");
INSERT INTO zaj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wakala wanhu alufu nne. Yesu kawalaga iwanhu wachole kumwao. ");
INSERT INTO zaj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kipigiti kikija kakwela mngalawa hamoja na wanahina zake wachola muisi ya Dalumanuta. ");
INSERT INTO zaj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mafalisayo wamcholela Yesu wasonga kuibamilila nayo. Wamwikila vitega wamulonda yatende mzonza wone kamba Mulungu kamtogola. ");
INSERT INTO zaj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ila Yesu kabweza mhumuzi, kalonga, “Habali wanhu wa mazua gano wolonda mzonza? Haduhu, nowalongela! Haduhu ikweli yondamgweleligwe!” ");
INSERT INTO zaj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Abaho, kawaleka, kakwela muna ingalawa na kasonga kuloka mwambu uyagwe wa idilamba. ");
INSERT INTO zaj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Wanahina wakala waisemwile kusola mikate na wakala na mkate umwe mngalawa. ");
INSERT INTO zaj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu kawazuma, kawalongela, “Iteganyeni na mela da Mafalisayo na mela da Helode.” ");
INSERT INTO zaj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wasonga kuilongela wenyego kwa wenyego, “Kolonga vino kwavija twabule mikate.” ");
INSERT INTO zaj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu kagatanga gaja gawakalile wolonga, avo kawauza, “Habali mulongelela avija vimulibule mikate? Ham'vimanya ama hamnavitanga? Mwabule nzonzi? ");
INSERT INTO zaj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Muna meso ila hamulola? Muna magwiti ila hamuhulika? Muisemwa ");
INSERT INTO zaj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","avija viniimogole imikate mitano na kuwagwelela wanhu alufu tano, migelo mingahi ya imikate isigale imdondole?” Wamwidika, “Longo dimwe na mibili.” ");
INSERT INTO zaj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu kawauza kabili “Na vinimogole imikate saba na kuwagwelela wanhu alufu nne, migelo mingahi imemile ya imikate isigale imdondole?” Wamwidika, “Saba.” ");
INSERT INTO zaj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesu kawauza, “Mng'hali hamnavitanga?” ");
INSERT INTO zaj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wavika Betisaida, wanhu wamgala munhu kimbugumbugu ha Yesu, wamuyalalila yamkwase. ");
INSERT INTO zaj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu kamgoga mkono ija imunhu kimbugumbugu, kamgala kutali na ikiwambo. Kamtemela visite mmeso, abaho, kamwikila makono gake, kamuuza, “Kodaha kulola kinhu chochose?” ");
INSERT INTO zaj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ija imunhu kalola uchana kalonga, “Nowona wanhu, ila wokoneka kamba mibiki itembela.” ");
INSERT INTO zaj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu kamwikila makono mwanza uyagwe mmeso, mwanza uno kaiyoha kubunhula, na meso gake gananazuka, kadaha kulola goya kila kinhu. ");
INSERT INTO zaj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Abaho, Yesu kamulagiza yachole ukae yomgong'ondeza, yolonga, “Sambiubweleganye muna ikiwambo.” ");
INSERT INTO zaj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Abaho, Yesu na wanahina zake wachola kuna iviwambo behi na Kaisalia Filipi. Viwakalile mnzila kawauza, “Nongeleni, wanhu wolonga nie iyo munhu yalihi?” ");
INSERT INTO zaj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wamwidika wolonga, “Wayagwe wolonga gweye iyo Yohana M'batiza, wayagwe wolonga gweye iyo Eliya, wayagwe wolonga gweye iyo imwe wa wahokozi.” ");
INSERT INTO zaj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu kawauza, “Na mweye molonga nie iyo munhu yalihi?” Petulo kamwidika, “Gweye iyo Kilisto yasaguligwe na Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Abaho, Yesu kawalagiza, “Sambimmulongele munhu yoyose mbuli zino.” ");
INSERT INTO zaj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Abaho, Yesu kasonga kuwafundiza wanahina zake kawalongela, “Nie, Mwana wa Munhu, nolondigwa nigazigwe ng'hani na kulemigwa na wakulu, wakulu wa wakulu wa nhambiko, na wafundiza Malagizo ga Musa. Nokomigwa, ila mazua madatu hamwande nozuka nowa mgima kabili.” ");
INSERT INTO zaj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kawalongela kinaganaga. Avo Petulo kamsola kamgala hamgwazo kasonga kumkomhokela. ");
INSERT INTO zaj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ila Yesu kahinduka kukisogo, kawalola wanahina zake na kumkomhokela Petulo, yolonga, “Segela hamwangu, Mwenembago! Ngelegeza zako hazilawa ha Mulungu ila zolawa mwa wanhu.” ");
INSERT INTO zaj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Abaho, Yesu kadikema ididale da wanhu hamoja na wanahina zake kawalongela, “Kamba munhu yahalonda kuwa mwanahina wangu, yaibele mwenyego, yaidikwe msalaba wake yanikoleleze. ");
INSERT INTO zaj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kwavija munhu yoyose yahalonda kuukombola ugima wake kowagiza, ila munhu yoyose yowagiza ugima wake, sama yangu nie na sama ya Usenga Unogile, koukombola. ");
INSERT INTO zaj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Vino wanhu wokwing'higwa choni kamba wahagweleligwa vinhu vose vili muisi, abaho, wawagize ugima wao? Nokona haduhu! ");
INSERT INTO zaj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Haduhu kinhu chondawalave wabweze ugima wao. ");
INSERT INTO zaj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ihawa munhu yahanyonela kinyala nie na mafundo gangu mwa wanhu wano walibule bwembwe da Mulungu na mmazua gano gehile, avo nie, Mwana wa Munhu, nomonela kinyala munhu hiyo vondanize muna iyenzi ya Tata wangu hamoja na wasenga wa Mulungu wa kuulanga wang'alile.” ");
INSERT INTO zaj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu kagendelela kulonga, “Nowalongela ikweli, hana wanhu hano hawadanganhika mbaka wawone Undewa wa Mulungu ukwiza na mhiko.” ");
INSERT INTO zaj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Vigabitile mazua sita, Yesu kawasola Petulo, Yakobo, na Yohana, kakwela nao kukigongo kitali weiyeka. Yesu kagaluka haulongozi wao. ");
INSERT INTO zaj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Vivalo vake vinang'hazika! Vikala vizelu, haduhu munhu yoyose muulumwengu yahadahile kuvisuluza kamba vija. ");
INSERT INTO zaj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Abaho, waja wanahina wadatu wamona Eliya na Musa wolongelela na Yesu. ");
INSERT INTO zaj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petulo kamulongela Yesu, “Mkulufunzi, vinoga tweye tukale hano, tuzenge vizewe vidatu, kimwe chako, kiyagwe cha Musa, na kiyagwe cha Eliya.” ");
INSERT INTO zaj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petulo haditangile da kulonga kwavija heyo na wayage wakala wokona bwembwe. ");
INSERT INTO zaj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Abaho, dilawilila wingu diwagubika, na dihulikwa dizwi kulawa mdiwingu, dilonga, “Ino iyo Mwanangu yanogele, mtegelezeni heyo!” ");
INSERT INTO zaj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Himahima walola kuno na kuno, hawamuwene munhu yoyose, ila Yesu yeiyeka hamoja na hewo. ");
INSERT INTO zaj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Viwakalile wohumuluka mkigongo, Yesu kawalagiza, yowalongela, “Sambimmulongele munhu yoyose gaja gamonile, mbaka nie, Mwana wa Munhu, vondanizuke kulawa mkudanganhika.” ");
INSERT INTO zaj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wagatogola malagizo gake, ila wenyego kwa wenyego wasonga kuigela msego mbuli ija, wokiiuza, “Kuzuka kulawa mkudanganhika ndo choni?” ");
INSERT INTO zaj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na hewo wamuuza Yesu, “Habali wafundiza Malagizo ga Musa wolonga tanhu yeze Eliya?” ");
INSERT INTO zaj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu kawalongela, “Vivo! Eliya kolongola kwiza, giladi yeke goya kila kinhu. Habali Nyandiko Zing'alile zolonga kamba Mwana wa Munhu kogazigwa ng'hani na kulemigwa? ");
INSERT INTO zaj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ila nowalongela kwa vovose, Eliya keza kesha, na wanhu wamtendela kamba viwalondile, kamba Nyandiko Zing'alile vuzimulonga.” ");
INSERT INTO zaj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Viwaiting'hanile na iwanahina wayagwe, wajona dale kulu da wanhu diwazunguluka wanahina zake na wafundiza wayagwe wa Malagizo ga Musa wokiibamilila. ");
INSERT INTO zaj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Waja iwanhu viwamuwene Yesu, wakanganya ng'hani na wamkimbilila wamulamsa. ");
INSERT INTO zaj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu kawauza wanahina zake, “Moibamilila choni?” ");
INSERT INTO zaj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Munhu imwe muna ididale da wanhu kamulongela, “Mkulufunzi, nimgala mmhale wangu kumwako, kwavija kana kinyamkela na hadaha kulonga. ");
INSERT INTO zaj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yaham'vamhila, kom'bwanha hasi na kolawa holovu mmulomo na kugegedula meno gake na kugangamala lukuli lwake lose. Niwalongela wanahina zako wamuwinge ikinyamkela, ila walemelwa.” ");
INSERT INTO zaj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu kawalongela, “Mweye wanhu mulibule nhamanila! Nokala namwe mbaka zua jaki? Nowazaganya mbaka zua jaki? Nigalile hano immhale!” ");
INSERT INTO zaj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wamgala ha Yesu. Kinyamkela viyamonile Yesu, bahaja kamgela kisango, kabwanhika hasi yobimbilika kuno holovu dimulawa mmulomo. ");
INSERT INTO zaj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu kamuuza tata wa imwana ija, “Kitamu kino kimsonga mazua gaki?” Na heyo kamwidika, “Songela udodo wake. ");
INSERT INTO zaj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mianza bwando kinyamkela kalonda kumkoma mkumulagazila hamoto na mmazi. Kamba vihadahika, utonele bazi na ututaze!” ");
INSERT INTO zaj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu kalonga, “Vihadahika! Gose godahika mwa imunhu yali na nhamanila.” ");
INSERT INTO zaj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hima tata wa imwana kenula dizwi yolonga, “Notogola, nhaza niuhume ubezi wa nhamanila unilinayo!” ");
INSERT INTO zaj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu viyonile dale da wanhu dowakwenhukila, avo kamkomhokela ikinyamkela kalonga, “Gweye kinyamkela kinziwi na bubui, nokulongela umulawe mmhale ino na sambiumwingile kabili!” ");
INSERT INTO zaj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kinyamkela kaguta lwangi, abaho, kamgela kisango na kumulawa. Mmhale iyo koneka konga munhu yadanganhike, na wanhu wose walonga, “Kadanganhika!” ");
INSERT INTO zaj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ila Yesu kamgoga mkono na kamtaza kwinuka, na heyo kema wima. ");
INSERT INTO zaj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu viyengile mng'anda, wanahina zake wamuuza kinyele, “Habali tweye hatudahile kumuwinga kinyamkela ija?” ");
INSERT INTO zaj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu kawedika, “Kinyamkela kamba ino kodaha kulawa kubitila nhambiko iiyeka, haduhu nzila iyagwe.” ");
INSERT INTO zaj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na wanahina zake wasegela hanhu haja wagendelela na mwanza wobitila muisi ya Galilaya. Yesu halondile munhu yoyose yavitange hanhu hayali, ");
INSERT INTO zaj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kwavija kakala yowafundiza wanahina zake, yowalongela, “Nie, Mwana wa Munhu, nogeligwa mmakono ga awo wondawanikome. Ila gahabita mazua madatu nozuka nowa mgima.” ");
INSERT INTO zaj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wanahina zake hawavitangile nhegulo ya fundo dino, na wadumba kumuuza. ");
INSERT INTO zaj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Wavika Kapenaumu, viwengile mng'anda Yesu kawauza wanahina zake, “Mkala mkiibamilila choni mnzila?” ");
INSERT INTO zaj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ila hawamwidike, kwavija mnzila wakala wokiibamilila wenyego kwa wenyego yalihi yali mkulu. ");
INSERT INTO zaj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu kakala hasi, kawakema wanahina zake longo dimwe na wabili, kawalongela, “Munhu yahalonda kuwa wa mwanduso kolondigwa yaibweze mwenyego hachugu cha wanhu wose na yawe mtumigwa wa wose.” ");
INSERT INTO zaj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Abaho, kamsola mwana, kamwimiza haulongozi wao. Kamkumbatila, abaho, kawalongela, ");
INSERT INTO zaj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Munhu yoyose yom'bokela imwe wa wana wano wadodo mtwaga jangu konibokela nie, na munhu yoyose yonibokela nie hanibokela nie niiyeka ila kom'bokela ayo yanhumile.” ");
INSERT INTO zaj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana kamulongela, “Mkulufunzi, tumona munhu yowinga vinyamkela na twaga jako, tumgomesa, kwavija halawa mdidale jetu.” ");
INSERT INTO zaj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu kawalongela, “Sambimumgomese, kwavija haduhu munhu yotenda mzonza mtwaga jangu, abaho, yanonge vihile. ");
INSERT INTO zaj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Munhu yoyose yalekile kuihasanya na tweye ka hamoja na tweye. ");
INSERT INTO zaj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nowalongela ikweli, kamba munhu yoyose yahawagwelela mweye kikasi cha mazi ga kung'wa, kwavija mweye mwa wanhu wa Kilisto, kobokela maliho gake. ");
INSERT INTO zaj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Munhu yoyose yondayamtende imwe wa wanhu wano wadodo yasegeze nhamanila yake kumwangu, vihanogile munhu ija yafungigwe msingo dibwe kulu da kusiginhila na kwasigwa m'bahali. ");
INSERT INTO zaj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Avo kamba mkono wako wokutenda gweye utenda vilozo, ukanhe! Vinoga kumwako kwingila muugima kuno ulibule mkono, kubanza kuwa na makono gose mabili, abaho, wasigwe kuzimu, ");
INSERT INTO zaj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ako ‘kuna iwamhembele hawafaga wondawawaje, na moto haufaga wondauwalukuze.’ ");
INSERT INTO zaj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na kamba mgulu wako wokutenda gweye utende vilozo, ukanhe! Vinoga kumwako kwingila muugima kuno ulibule mgulu, kubanza kuwa na magulu gose mabili, abaho, wasigwe kuzimu, ");
INSERT INTO zaj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ako ‘kuna iwamhembele hawafaga wondawawaje, na moto haufaga wondauwalukuze.’ ");
INSERT INTO zaj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na kamba siso jako dokutenda gweye utende vilozo, dilave! Vinoga kumwako kwingila Muundewa wa Mulungu na siso dimwe, kubanza kuwa na meso gose mabili, abaho, wasigwe kuzimu, ");
INSERT INTO zaj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ako ‘kuna iwamhembele hawafaga wondawawaje, na moto haufaga wondauwalukuze.’ ");
INSERT INTO zaj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kila munhu kong'alizwa na moto kamba vija nhosa viing'alizwa na munyu. ");
INSERT INTO zaj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Munyu unoga, ila uhagiza kilandu chake, kodahaze kuutenda unoge kabili? “Muwe kamba munyu, mkale mditindiwalo wenyego kwa wenyego.” ");
INSERT INTO zaj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu kahalawa hanhu haja, kachola muisi ya Yudea na kuloka mwambu wa ikabili wa Ulwanda lwa Yolodani. Dale da wanhu bwando dimcholela kabili, na heyo kawafundiza kamba viyatendaga. ");
INSERT INTO zaj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mafalisayo wamcholela na wageza kumwikila vitega wamulongela, “Tulongele, Malagizo getu gomtogoza munhu kumwasa mtwanzi wake?” ");
INSERT INTO zaj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu kawedika, kuwauza, “Musa kawalagiza choni?” ");
INSERT INTO zaj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wamwidika wamulongela, “Musa katogoza munhu yamwandikile lupwilili lwa nyasa mtwanzi wake, abaho, yamwase.” ");
INSERT INTO zaj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu kawalongela, “Sama ya udala wa mioyo yenu Musa kawandikila ndagizi ino. ");
INSERT INTO zaj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ila songela haichanduso, ‘Mulungu viyasongile kulumba, kalumba mtwanzi na mbigalo.’ ");
INSERT INTO zaj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Mkilamso kino mbigalo kowaleka tataake na mamaake na kuilumba na mwehe wake, ");
INSERT INTO zaj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na wabili wano wowa lukuli lumwe.’ Avo si wabili tena ila lukuli lumwe. ");
INSERT INTO zaj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Avo kiyalumbile hamoja Mulungu, munhu sambiyakimamazule.” ");
INSERT INTO zaj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Viwengile mng'anda mwanza wa ikabili, wanahina zake wamuuza Yesu mbuli ija. ");
INSERT INTO zaj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu kawalongela, “Munhu yoyose yomwasa mtwanzi wake na kusola mtwanzi iyagwe, komtendela ugoni mtwanzi wake. ");
INSERT INTO zaj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Vivija mtwanzi yomwasa mbigalo wake na kusoligwa na mbigalo iyagwe, kotenda ugoni.” ");
INSERT INTO zaj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wanhu wamgalila Yesu wana wadodo yawekile makono gake, ila wanahina zake wawakomhokela. ");
INSERT INTO zaj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu viyawawene, kona lusango kawalongela, “Walekeni wana wadodo weze kumwangu, sambimuwagomese kwavija Undewa wa Mulungu wa sama ya wanhu kamba wano. ");
INSERT INTO zaj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nowalongela ikweli, munhu yoyose yondayaleke kuubokela Undewa wa Mulungu kamba mwana mdodo hengila himo.” ");
INSERT INTO zaj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Abaho, kawakumbatila waja iwana na makono gake, kawekila makono gake, na kuwamoteza. ");
INSERT INTO zaj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu viyagendelele na mwanza wake, munhu imwe kamkimbilila, kamfugamila mavindi haulongozi wake, kamuuza, “Mkulufunzi Unogile, nhendeze giladi niubokele ugima wa digunge?” ");
INSERT INTO zaj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu kamuuza, “Habali ung'hema nie ninogile? Haduhu munhu yanogile ila Mulungu yeiyeka. ");
INSERT INTO zaj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kuzitanga ndagizi. ‘Sambiukome, sambiutende ugoni, sambiwibe, sambiulave usindila wa uvwizi, sambium'vwizile munhu yoyose, wahishimile tataako na mamaako.’ ” ");
INSERT INTO zaj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Munhu ija kamulongela, “Mkulufunzi, higo gose nigatenda songela haudodo wangu.” ");
INSERT INTO zaj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu kamulola kamnogela, kamulongela, “Kuhungukilwa na kinhu kimwe. Genda ukaguze vinhu vose vuulinavo, abaho, zihela uwagwelele wakumbulu, avo kowa na ngama kuulanga, abaho, unikoleleze.” ");
INSERT INTO zaj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Munhu ija viyahulike vija, kakunza kihanga kasegela kuno yokona giogio, kwavija kakala na mali bwando. ");
INSERT INTO zaj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu kazunguluka yowalola wanahina zake wose, kawalongela, “Vidala munhu mgoli kwingila muna Undewa wa Mulungu!” ");
INSERT INTO zaj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wanahina zake wasinhuka viwahulike mbuli zino, ila Yesu kagendelela kulonga, “Wanangu, vidala kwingila muna Uundewa wa Mulungu! ");
INSERT INTO zaj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Vibuha ngamia kubita mkizonzo cha shindano, kubanza mgoli kwingila Muundewa wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wanahina zake wakanganya ng'hani na kukiiuza wenyego kwa wenyego, “Munhu yalihi yondayadahe kukomboligwa?” ");
INSERT INTO zaj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu kawalola, kawalongela, “Mwa wanhu mbuli ino haidahika ila sio ha Mulungu, kwavija ha Mulungu vinhu vose vodahika.” ");
INSERT INTO zaj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Abaho, Petulo kalonga, “Lola, tweye tuleka vinhu vose na kukukweleleza gweye.” ");
INSERT INTO zaj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu kawalongela, “Nowalongela ikweli, munhu yoyose yalekile ng'anda ama ndugu zake ama lumbu zake ama mamaake ama tataake ama wanage ama migunda sama yangu nie na sama ya Usenga Unogile, ");
INSERT INTO zaj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kobokela mkipigiti kino mianza mia ya ng'anda, wandugu, walumbu, mama, wana, na migunda, na vivija mgayo, na mkipigiti kikwiza kobokela ugima wa digunge. ");
INSERT INTO zaj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ila wanhu bwando wali sambi haulongozi wowa kuchugu, na wanhu bwando wali sambi kuchugu wowa haulongozi.” ");
INSERT INTO zaj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu na wanahina zake wakala mnzila wokwela wochola Yelusalemu, Yesu kalongola haulongozi wao. Wanahina zake wakala wokanganya ng'hani, na wanhu wakalile womkweleleza hachugu wakala wodumba. Mwanza uyagwe viyawasolile wanahina zake kawagala hamgwazo na kuwalongela mbuli zondazimulawilile. ");
INSERT INTO zaj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kawalongela “Tegelezeni, tokwela tochola Yelusalemu ako nie, Mwana wa Munhu, kondanigeligwe mmakono ga wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa. Wonitagusa kudanganhika na kunigela mmakono ga wanhu hawali Wayahudi, ");
INSERT INTO zaj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","na hewo wonitendela mzihaka, wonitemela vizite, wonilanha mbalati na kunikoma, ila gahabita mazua madatu nozuka.” ");
INSERT INTO zaj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Abaho Yakobo na Yohana, wanage Zebedayo, wamcholela Yesu wamulongela, “Mkulufunzi, tolonda ututendele mbuli.” ");
INSERT INTO zaj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu kawauza, “Mbuli yaki?” ");
INSERT INTO zaj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wamwidika, “Tutogoze imwe yakale kumkono wako wa ukulume na iyagwe yakale kumkono wako wa ukumoso kuna iyenzi yako.” ");
INSERT INTO zaj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu kawalongela, “Hammanyile kinhu chumpula. Modaha kuking'wela kikasi cha mgayo kinilondigwa kung'wela nie? Ama modaha kubatizigwa kamba vinilondigwa kubatizigwa nie?” ");
INSERT INTO zaj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wamulongela, “Todaha.” Yesu kawalongela, “Moking'wela kikasi cha mgayo kinilondigwa kuking'wela nie na mobatizigwa kamba vinilondigwa kubatizigwa. ");
INSERT INTO zaj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ila kusagula yalihi yakale kumkono wangu wa ukulume ama kumkono wangu wa ukumoso haili sang'hano yangu. Mulungu iyo yondayawagwelele awo watandiligwe ukazi uno.” ");
INSERT INTO zaj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wanahina wayagwe longo dimwe viwahulike mbuli zija, wawonela lusango Yakobo na Yohana. ");
INSERT INTO zaj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Avo Yesu kawakema wose hamoja kawalongela, “M'vimanya waja wogesigwa kamba wandewa wa wanhu hawali Wayahudi wana udaho mwa wanhu zao, na wakulu zao wotenda vovose vowolonda. ");
INSERT INTO zaj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sambiiwe vino kumwenu. Kamba munhu imwe mdidale jenu yahalonda kuwa mkulu, kolondigwa yawe mtumigwa wa wayage, ");
INSERT INTO zaj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","na munhu imwe mdidale jenu yahalonda kuwa haulongozi, kolondigwa yawe nyakadala wa wose. ");
INSERT INTO zaj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kwavija hata nie, Mwana wa Munhu, sizile kusang'hanikiligwa, ila niza kusang'hanika na kulava ugima wangu giladi niwakombole wanhu bwando.” ");
INSERT INTO zaj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Wavika kudiwambo dikemigwa Yeliko, Yesu viyakalile yolawa mkiwambo na wanahina zake na dale kulu da wanhu, kimbugumbugu imwe yakalile yopula vinhu yokemigwa Batimayo mwanage Timayo kakala yakalile hasi behi na inzila. ");
INSERT INTO zaj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Viyahulike kamba Yesu wa Nazaleti kobita, kasonga kwinula dizwi yolonga, “Yesu! Mwana wa Daudi! Nyonela bazi!” ");
INSERT INTO zaj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wanhu bwando wamkomhokela na wamulongela yavudale. Ila kagendelela ng'hani kutoa nyangi, yolonga, “Mwana wa Daudi! Nyonela bazi!” ");
INSERT INTO zaj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu kema, kalonga, “Mkemeni.” Avo wamkema ija imunhu kimbugumbugu wamulongela, “Deng'helela! Inuka kokukema.” ");
INSERT INTO zaj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kajasa guo jake, kazumha kachola ha Yesu. ");
INSERT INTO zaj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu kamuuza, “Kolonda nikutendele choni?” Ija imunhu kamwidika, “Mkulufunzi, nolonda kulola.” ");
INSERT INTO zaj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu kamulongela, “Genda, nhamanila yako ikuhonya.” Bahaja kadaha kulola na kamkweleleza Yesu mnzila. ");
INSERT INTO zaj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Viwavikile behi na wambo da Yelusalemu, wavika Betifage hana Ikigongo cha Mizaituni, behi na ikiwambo cha Betania. Yesu kawatuma wanahina zake wabili walongole haulongozi. ");
INSERT INTO zaj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kawalongela, “Gendeni hana ikiwambo kili haulongozi wenu. Muhavika, mom'vika mwana mhunda yafungigwe hanapapa munhu yoyose. Mfunguleni munigalile. ");
INSERT INTO zaj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na kamba munhu yahawauza habali motenda avo, mulongeleni Mndewa komulonda, na sambi baha kom'bweza.” ");
INSERT INTO zaj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Avo wachola wam'vika mwana mhunda mulubuga, yafungigwe muna ulwivi lwa ng'anda imwe. Viwakalile womfungula, ");
INSERT INTO zaj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","wanhu wakalile wemile behi nawo wawauza, “Habali mumfungula imwana mhunda?” ");
INSERT INTO zaj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wawedika kamba Yesu viyawalongele, na hewo wawaleka wachole nayo. ");
INSERT INTO zaj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wamgala imwana mhunda ha Yesu, watandika vivalo vao mumgongo wake, na Yesu kakwela mumgongo wake. ");
INSERT INTO zaj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wanhu bwando wanzanza vivalo vao mnzila, wayagwe wakanha mitambi mmigunda waiyanzanza mnzila. ");
INSERT INTO zaj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wanhu walongole na wose wawawinzile kukisogo wasonga kwinula dizwi wolonga, “Yatogolwe Mulungu! Mulungu ummoteze ayo yokwiza mtwaga da Mndewa! ");
INSERT INTO zaj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mulungu uumoteze undewa ukwiza wa Mndewa Daudi, tata wetu! Yatogolwe Mulungu!” ");
INSERT INTO zaj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu kengila Yelusalemu, kachola na kwingila muna Ing'anda ya Mulungu, kalola kila hanhu. Ila kwavija zua dikala diswile, kachola Betania na wanahina zake longo dimwe na wabili. ");
INSERT INTO zaj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Imitondo iyagwe, viwakalile wosegela kulawa Betania, Yesu kakala na nzala. ");
INSERT INTO zaj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kawona hatalitali m'biki ukemigwa mtini utimile mitepo, avo kachola kuulola siku kovika tini. Ila viyaukwenhukile, kavika mitepo yeka, kwavija haukalile msimu wa tini. ");
INSERT INTO zaj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu kaulongela uja umtini, “Haduhu munhu yoyose yondayaje tini kulawa kumwako milongo yose!” Na wanahina zake wamuhulika. ");
INSERT INTO zaj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Viwavikile Yelusalemu, Yesu kachola Kung'anda ya Mulungu, kasonga kuwalava hanze wanhu wose wakalile wogula na kuguza. Kazihindula izimeza za wavunja hela na ivigoda va waguza njiwa, ");
INSERT INTO zaj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","na hamulekile munhu yoyose yapape kinhu chochose yakanhize muna idikonhi da Ng'anda ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Abaho, kawafundiza, “Yandikigwa Mzinyandiko Zing'alile, Mulungu kalonga, ‘Ng'anda yangu yokemigwa ng'anda ya nhambiko za isi zose.’ Ila mweye muigalula kuwa fiso da wabavi!” ");
INSERT INTO zaj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa wahulika, avo wasonga kuzahila nzila ya kumkoma Yesu. Ila wamdumba kwavija dale jose da wanhu dikala dokanganya mafundo gake. ");
INSERT INTO zaj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Viivikile ichungulo, Yesu na wanahina zake wasegela hakiwambo kija. ");
INSERT INTO zaj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Imitondo iyagwe, viwakalile wobita mnzila, wawona umtini unyala kusongela kunhembeti mbaka mmizizi. ");
INSERT INTO zaj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petulo kakumbukila mbuli zija Yesu zayaulongele umtini, kamulongela Yesu, “Lola, mkulufunzi, uja umtini uwikile kinyulu uholola!” ");
INSERT INTO zaj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu kawedika, “Mtamanileni Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nowalongela ikweli, munhu yoyose yahakilongela kigongo kino, ‘Goboka ukalagalile m'bahali,’ bila kudungwadungwa mmoyo wake ila kotamanila gaja gayalongile, kotendeligwa. ");
INSERT INTO zaj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Avo nowalongela, avija vumtambika na kupula kinhu kulawa ha Mulungu, tamanileni kamba m'bokela, na mogweleligwa kinhu chochose chumpula. ");
INSERT INTO zaj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na muhawa muna inhambiko, geleni kumgongo kinhu chochose chumuihasanye na munhu yoyose, avo Tata wenu wa kuulanga kovigela kumgongo vilozo venu vumtendile.” ");
INSERT INTO zaj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Avo kamba hamuwagela waenu kumgongo, na Tata wenu havigela kumgongo vilozo venu vimtendile. ");
INSERT INTO zaj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wavika Yelusalemu mwanza uyagwe. Yesu viyakalile yotembela kuna Ing'anda ya Mulungu, wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa na iwakulu wamcholela, ");
INSERT INTO zaj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","wamuuza, “Kotenda mbuli zino na udaho ulihi? Yalihi yakugwelela udaho wa kutenda mbuli zino?” ");
INSERT INTO zaj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu kawedika kawalongela, “Nowauza mbuli imwe na muhanidika, nowalongela notenda mbuli zino na udaho ulihi. ");
INSERT INTO zaj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nilongeleni, Yohana kapata kwahi udaho wa kubatiza, kapata kulawa ha Mulungu ama ulawa ha wanhu?” ");
INSERT INTO zaj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wasonga kuibamilila wenyego kwa wenyego, “Tulongeze? Tuhalonga, ‘Ulawa ha Mulungu,’ kolonga, ‘Habali hamumtegeleze Yohana?’ ");
INSERT INTO zaj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ila sambitulonge, ‘Ulawa ha wanhu.’ ” Wawadumba wanhu, kwavija wanhu wose watogola kamba Yohana kakala muhokozi. ");
INSERT INTO zaj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Avo wamulongela Yesu, “Hatuvimanyile.” Yesu kawalongela, “Na nie siwalongela kamba notenda mbuli zino na udaho ulihi.” ");
INSERT INTO zaj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Abaho, Yesu kalonga nao mmahala, “Munhu imwe kakala na mgunda wa mizabibu, kauzengela konhi na kuhimba lwingila lwa kukamulila zabibu na kuzenga ulingo. Abaho, kawapangiza walimi, kachola isi ya kutali. ");
INSERT INTO zaj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kipigiti cha kuhuna zizabibu vikivikile, kamtuma nyakadala wake ha iwalimi yakamsolele fungu jake da izizabibu. ");
INSERT INTO zaj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Iwalimi wamnwang'hula ija inyakadala, wamtoa, na wam'bweza bila kinhu. ");
INSERT INTO zaj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Abaho, mwene mgunda kamulongela nyakadala iyagwe yachole ha iwalimi yakamsolele zabibu zake, waja iwalimi wamtoa mdipala na kumtendela mbuli za kumgela kinyala. ");
INSERT INTO zaj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mwene mgunda kamulagiza nyakadala iyagwe, na heyo wamkoma. Na kawalagiza nyakadala wayagwe bwando, wayagwe wawatoa na wayagwe wawakoma. ");
INSERT INTO zaj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Munhu yasigale wa kumulagiza kakala mwanage mnogelwa ng'hani wa mwene mgunda. Avo hakimambukizo, kamulagiza mwanage ha iwalimi, kalonga, ‘Kwa vovose ino womuhishimila, kwavija mwanangu.’ ");
INSERT INTO zaj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ila waja iwalimi wakiilongela, ‘Ino iyo mwana wa mwene mgunda. Haya izoni tumkome, na uhazi wake wowa wetu!’ ");
INSERT INTO zaj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Avo wamnwang'hula imwana wa mwene umgunda wamkoma na kumwasa hanze ya umgunda wa imizabibu.” ");
INSERT INTO zaj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu kauza, “Abaho, kotenda choni ija imunhu yali na umgunda? Kokwiza na kowakoma iwalimi waja na kuwagwelela walimi wayagwe. ");
INSERT INTO zaj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Hamzisomile Nyandiko zino Zing'alile? ‘Dibwe dilemigwe na wazenzi digaluka kuwa dibwe da kutamanilwa ng'hani kubanza mabwe gose. ");
INSERT INTO zaj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mndewa iyo yatendile mbuli ino, nayo iwa mkanganyo mmeso getu!’ ” ");
INSERT INTO zaj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Wakulu wa Wayahudi wageza kumgoga Yesu, kwavija wavitanga kamba kalonga hala dino yowalonga hewo. Ila wakala wowadumba wanhu, avo wamuleka wachola na zao. ");
INSERT INTO zaj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mafalisayo na wanhu wa Helode walagizwa na wakulu wa Wayahudi ha Yesu wamwikile vitega mkumuuza. ");
INSERT INTO zaj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wamcholela wamulongela, “Mkulufunzi, tuvitanga kamba gweye kolonga mbuli zili kweli, bila kudumba ngelegeza za wanhu. Humdumba munhu yoyose, ila kofundiza ikweli ya Mulungu mwa wanhu. Tulongele, totenda galemigwe na Malagizo getu vituliha kodi ha Kaisali?” ");
INSERT INTO zaj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ila Yesu kavitanga vitega vao kawalongela, “Habali mgeza kunikila vitega? Nigalileni ihela niilole.” ");
INSERT INTO zaj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wamgalila hela imwe, kawauza, “Kihanga na ditwaga dino va munhu yalihi?” Wamwidika, “Va Kaisali.” ");
INSERT INTO zaj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Avo Yesu kawalongela, “Mulonga goya, avo ga Kaisali mgweleleni Kaisali, na ga Mulungu mgweleleni Mulungu.” Na hewo wakanganya ng'hani vija viyawedike. ");
INSERT INTO zaj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Abaho, Masadukayo, awo wolonga kamba wanhu hawazuka kulawa mkudanganhika, wamcholela Yesu wamuuza, ");
INSERT INTO zaj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mkulufunzi, Musa katwandikila, ‘Ihawa munhu kadanganhika na kuleka mtwanzi halelile nayo mwana, mkulu wake ama mdodo wake ija yadanganhike kolondigwa yamsole ija ikizuka, yamulelele wana indugu yake yadanganhike.’ ");
INSERT INTO zaj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Avo kukala na wanhu saba wambigalo wa mulango umwe, mkulu wao kasola mtwanzi, kadanganhika bila kulela nayo wana. ");
INSERT INTO zaj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Abaho, waikabili kamsola ija imtwanzi, vivija kadanganhika bila kulela nayo wana. Na waikadatu gam'vika gagaja, ");
INSERT INTO zaj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","na wasigale wose saba, wanhu wose saba wamsola mtwanzi ija na wadanganhika bila kulela nayo wana. Hakimambukizo, ija imtwanzi na heyo kadanganhika. ");
INSERT INTO zaj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Avo wanhu wose wadanganhike wahazuka wawe wagima muna idizua da kuzuka kwa wanhu wose, mtwanzi ija kowa mtwanzi wa munhu yalihi? Kwavija wanhu wose saba wakala wamsolile.” ");
INSERT INTO zaj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu kawedika, “Muhonyela ng'hani! Kwavija hamzimanyile Nyandiko Zing'alile ama mhiko za Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wanhu wadanganhike wahazuka hawasola ama kusoligwa, wowa kamba wasenga wa Mulungu wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Avo tuilole mbuli ya kuzuka kwa wanhu wadanganhike, hamsomile mkitabu cha Musa hanhu handikigwe kitutua kikwaka? Mulungu kalongaze? Kalonga, ‘Nie iyo Mulungu wa Ablaham, na Isaka, na Yakobo.’ ");
INSERT INTO zaj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Heyo si Mulungu wa wanhu wadanganhike ila Mulungu wa wanhu wagima. Mweye muhonyela ng'hani!” ");
INSERT INTO zaj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mfundiza Malagizo ga Musa yakalile haja, kahulika viwakalile wokiibamilila. Kona kamba Yesu kamsambulila vinogile, avo kamcholela na mbuza, kamuuza, “Ndagizi ilihi ili ng'hulu kubanza zose?” ");
INSERT INTO zaj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu kamwidika, “Ndagizi ili ng'hulu kubanza zose iyo ino. ‘Tegeleza Islaeli! Mndewa Mulungu wetu iyo Mndewa yeiyeka. ");
INSERT INTO zaj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mnogele Mndewa Mulungu wako na moyo wako wose, na loho yako yose, na nzonzi zako zose, na mhiko zako zose.’ ");
INSERT INTO zaj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ndagizi ya ikabili iyo ino, ‘Mnogele munhu wa habehi nagwe kamba vukiinogela mwenyego.’ Haduhu ndagizi ziyagwe zili ng'hulu kubanza zino mbili.” ");
INSERT INTO zaj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ija mfundiza Malagizo ga Musa kamulongela Yesu, “Mkulufunzi, kulonga goya! Kulonga ili kweli, vuulongile kamba Mndewa yeiyeka iyo Mulungu na haduhu mulungu iyagwe ila heyo. ");
INSERT INTO zaj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kumnogela Mulungu na moyo wako wose, na nzonzi zako zose, na mhiko zako zose, na mnogele munhu wa habehi nagwe kamba vukiinogela mwenyego, vinoga ng'hani kubanza kumulavila Mulungu nhosa zose za kulukuza na zija zili si za kulukuza.” ");
INSERT INTO zaj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu viyonile ija imunhu kalonga galawile mmoyo, kamulongela, “Huli kutali na Undewa wa Mulungu.” Kulawila haja haduhu munhu yamuuzile Yesu mbuli yoyose. ");
INSERT INTO zaj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu viyakalile yofundiza Kuing'anda ya Mulungu, kawauza, “Habali wafundiza Malagizo ga Musa wolonga kamba Kilisto iyo mwana wa Daudi? ");
INSERT INTO zaj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi mwenyego kalongozigwa na Loho wa Mulungu, kalonga, ‘Mndewa kamulongela Mndewa wangu. Kala kumkono wangu wa ukulume mbaka vondaniweke wadumuka zako hasi ya magulu gako.’ ");
INSERT INTO zaj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Daudi mwenyego komkema Kilisto ‘Mndewa.’ Avo kodahaze Kilisto kulawa mulukolo lwake?” Dale kulu da wanhu dikala dimtegeleza Yesu mkudeng'ha. ");
INSERT INTO zaj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Viyakalile yofundiza kalonga, “Iteganyeni na wafundiza Malagizo ga Musa. Wonogelwa kuzungulukazunguluka kuno wavalile mikanzu mitali na wonogelwa kulamsigwa na hishima mmasoko, ");
INSERT INTO zaj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","na kusagula vigoda va haulongozi mzing'anda za nhambiko na hanhu hanogile kuna izisona. ");
INSERT INTO zaj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wowabulunya vizuka na kutenda nhambiko nhali za uzenzeleganye hameso ga wanhu. Nhaguso yao yowa ng'hulu ng'hani!” ");
INSERT INTO zaj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu kakala habehi na ikia cha kulavila nhosa, kakala yowalola wanhu volava hela zao muna ikia cha kulavila nhosa. Wanhu wagoli walava hela bwando, ");
INSERT INTO zaj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","abaho, keza kizuka mkumbulu kalava hela mbili ndodo ng'hani. ");
INSERT INTO zaj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu kawakema wanahina zake hamoja kawalongela, “Nowalongela ikweli, kizuka ino mkumbulu kalava hela bwando kubanza wanhu wose. ");
INSERT INTO zaj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kwavija wayagwe walava vinhu viwabanzile, ila kizuka ino hamoja na ukumbulu wake, kalava vose vayalinavo.” ");
INSERT INTO zaj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu viyakalile yolawa Kuing'anda ya Mulungu, mwanahina wake imwe kamulongela, “Mkulufunzi! Lola mabwe gaja vigali makulu na zing'anda vuzinogile ng'hani!” ");
INSERT INTO zaj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu kamulongela, “Kuzona ng'anda zino ng'hulu? Haduhu dibwe hano dondadisigale hadili, gose gobomoligwa na kwasigwa hasi.” ");
INSERT INTO zaj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu kakala yakalile Hakigongo cha Mizaituni, kikalile kigongo kwa kigongo na Ing'anda ya Mulungu. Petulo, Yakobo, Yohana, na Endelea wamuuza kinyele, ");
INSERT INTO zaj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tulongele, mbuli zino zolawila zua jaki? Na tulongele, choni chondakilawile kutulagusila kamba kipigiti kivika cha mbuli zino zose kulawilila?” ");
INSERT INTO zaj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu kawalongela, “Teganyeni, munhu yoyose sambiyawavwizile. ");
INSERT INTO zaj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wanhu bwando wokwiza mtwaga jangu, wolonga ‘Nie iyo Kilisto!’ na kuwavwizila wanhu bwando. ");
INSERT INTO zaj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Muhahulika ng'hondo na singilimo za ng'hondo, sambimdumbe. Vinhu kamba avo volondigwa vilawile, ila ikimambukizo hakinavika. ");
INSERT INTO zaj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Isi yogomba na isi iyagwe, na undewa wogomba na undewa uyagwe, kowa na mgudemo wa isi hanhu na hanhu na nzala. Gano gose gowa kamba usungu wa mwanduso wa kulela mwana. ");
INSERT INTO zaj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Teganyeni, kwavija mogogigwa na kugaligwa m'vitala, molanhigwa mzing'anda za nhambiko. Mogaligwa haulongozi wa iwakulu wa isi na wandewa sama yangu kamba usindila kumwao. ");
INSERT INTO zaj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na Usenga Unogile wolondigwa tanhu upetigwe muisi zose kipigiti king'hali ikimambukizo hakinavika. ");
INSERT INTO zaj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Muhagogigwa na kugaligwa m'vitala, sambimgelegeze kija chondamulonge. Kipigiti kihavika, longeni gogose gondamgweleligwe. Kwavija mbuli zondamulonge haziwa zenu mweye, ila zolawa ha Loho wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ndugu komuhonza ndugu yake giladi yakomigwe, na tata komuhonza mwanage. Wana wowahonza watata na wamama zao na kuwatenda wadanganhike. ");
INSERT INTO zaj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Wanhu wose wowehila mweye sama yangu, ila yondayananahile mbaka hakimambukizo kokomboligwa. ");
INSERT INTO zaj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kipigiti chokwiza vondamone ‘Kinhu Kinyolodoke Kigala Ubananzi’ kima hanhu hakilondigwe kukala.” Munhu yosoma na yaitange nhegulo yake! Yesu kagendelela kulonga, “Avo, awo wali Yudea wakimbilile m'vigongo. ");
INSERT INTO zaj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Munhu yali mkiswili cha ng'anda yake sambiyahumuluke hasi ama yengile mng'anda yakasole kinhu chochose. ");
INSERT INTO zaj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yali kumgunda sambiyabwele ukae kusola kivalo chake. ");
INSERT INTO zaj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Wogaya ng'hani watwanzi wali na inda na wokong'heza mmazua higo! ");
INSERT INTO zaj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tambikeni giladi Mulungu yazitende mbuli zino sambizilawile mkipigiti cha kihuhe! ");
INSERT INTO zaj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kwavija mgayo wa mazua higo wowa mkulu kubanza mgayo wowose woneke songela haichanduso Mulungu vayalumbile iisi mbaka vino. Na haulawila mgayo kamba hiwo milongo yose ikwiza. ");
INSERT INTO zaj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kamba Mndewa yahalekile kugahunguza mazua higo, haduhu munhu yahahonile. Ila sama ya awo wamnogele Mulungu, awo yaawasagule, kagahunguza mazua higo. ");
INSERT INTO zaj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Abaho, kamba munhu yoyose yahawalongela, ‘Lola, Kilisto kahano!’ ama ‘Kakuja!’ sambimumtegeleze. ");
INSERT INTO zaj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kwavija wolawila makilisto wa uvwizi na wahokozi wa uvwizi. Wotenda vilaguso na mikanganyo giladi vihadahika wawakonge hata wanhu wasaguligwe na Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Teganyeni! Niwalongela mbuli zose kipigiti king'hali hakinavika. ");
INSERT INTO zaj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Avo muna gamazua higo kipigiti cha mgayo vondakimale, zua doziziwala, mulenge haulava mulangaza wake, ");
INSERT INTO zaj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","nhondo zolagala kulawa kuulanga, na mhiko za kuulanga zokwekwesigwa kulawa hazikalile. ");
INSERT INTO zaj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Abaho, wonyona nie, Mwana wa Munhu, nikwiza na mawingu na mhiko na yenzi ng'hulu. ");
INSERT INTO zaj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Abaho, nowatuma wasenga wa Mulungu wa kuulanga kuna zing'ambu nne za ulumwengu wawaduganye wanhu wasaguligwe na Mulungu kulawa ng'ambu imwe ya ulumwengu mbaka ng'ambu iyagwe ya ulumwengu. ");
INSERT INTO zaj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Muifundize mum'biki wa mtini. Matambi gake gahasonga udeke wa kuzuka na kulava matepo, movitanga kamba vuli da mmabehi. ");
INSERT INTO zaj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Vivija na mweye, muhazona mbuli zino zolawila, m'vitange kamba mbuli zino za mmabehi kusonga. ");
INSERT INTO zaj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nowalongela ikweli, mbuli zino zose zolawilila ing'hali wanhu wa mulelo uno hawanadanganhika. ");
INSERT INTO zaj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ulanga na isi vose vobita, ila mbuli zangu hazibita. ");
INSERT INTO zaj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kwa vovose haduhu munhu yoitanga saa ama zua dilihi mbuli zino vondazilawile, sio wasenga wa Mulungu wa kuulanga ama nie, Mwana, ila Tata yeiyeka iyo yoitanga. ");
INSERT INTO zaj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Goneleleni na teganyeni, kwavija ham'vitanga kipigiti kilihi mbuli zino vondazilawile. ");
INSERT INTO zaj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Volinga kamba munhu yawagwelele nyakadala zake kila munhu na sang'hano yake ya kutenda na kumulongela mwimiliza ulwivi yagonelele, abaho, kachola mwanza na kuwaleka nyakadala zake wosang'hanika. ");
INSERT INTO zaj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Avo goneleleni kwavija hamkimanyile kipigiti mwene ng'anda vondayeze, siku ichungulo ama ikilo kikulu ama nzogolo zikwika ama imitondo. ");
INSERT INTO zaj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ihawa yeheza mkuwasinhukiza, sambiyawavike muwasile. ");
INSERT INTO zaj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Avo kinilonda kuwagong'ondeza, nowalongela wose kamba, goneleleni!” ");
INSERT INTO zaj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gakala gasigale mazua mabili kuvikila Pasaka na Lusona lwa Imikate Ilibule Mela. Wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa wakala wozahila nzila ya kumgoga Yesu kinyele wamkome. ");
INSERT INTO zaj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Walonga, “Sambitutende gano mkipigiti cha ulusona, ama wanhu wosongeza mzahimzahi.” ");
INSERT INTO zaj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu viyakalile Betania, yoja hameza mng'anda ya munhu imwe yokemigwa Simoni yakalile na utamu wa dikulu, mtwanzi imwe keza na nyhupa ya alabasta ili na mavuta ga kunung'hila ga hela bwando, gatendigwe na nado inogile. Kaifungula inyhupa na kumwitila Yesu gamavuta mmwiti. ");
INSERT INTO zaj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wanhu wayagwe wakalile haja wehilwa, wailongela, “Habali mavuta gano ga kunung'hila gobanangwa kamba vino? ");
INSERT INTO zaj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Gahaguzigwe zihapatikane hela zidaha kuliha kitumetume cha mulao umwe, na zihela wahagweleligwe wakumbulu!” Wamkomhokela ng'hani mtwanzi ija. ");
INSERT INTO zaj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ila Yesu kawalongela, “Mulekeni, habali mumgaza? Kanhendela kinhu kinogile ng'hani. ");
INSERT INTO zaj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wakumbulu mokala nao mazua gose, na muhalonda kuwagwelela vinhu kipigiti chochose mowagwelela. Ila nie sikala na mweye mazua gose. ");
INSERT INTO zaj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Katenda chayadahile, kalubaka mavuta lukuli lwangu kulutanda na mazisi mazua ga hamwande. ");
INSERT INTO zaj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nowalongela ikweli, kila hanhu hondaupetigwe Usenga Unogile muulumwengu wose, kino chayatendile mtwanzi ino cholongwa mkumkumbukila heyo.” ");
INSERT INTO zaj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Abaho, Yuda Isikalioti, imwe wa wanahina longo dimwe na wabili, kachola ha wakulu wa wakulu wa nhambiko giladi yamuhonze Yesu kumwao. ");
INSERT INTO zaj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wadeng'helela ng'hani viwahulike gaja gayalongile, wailagana kumgwelela hela. Avo kasonga kuzahila nzila ya kumgela mmakono gao. ");
INSERT INTO zaj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Muna dizua da mwanduso wa Ulusona lwa Imikate Ilibule Mela, idizua ajo wana ng'hondolo wa Pasaka vowochinjigwa, wanahina zake wamuuza, “Kwahi kuulonda tuchole tukakutandile mandia ga Pasaka?” ");
INSERT INTO zaj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesu kawalagiza wanahina zake wabili kawalongela, “Gendeni mkiwambo, mom'vika mbigalo yapapile nongo ya mazi. Mkwelelezeni ");
INSERT INTO zaj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mbaka hana ing'anda yondayengile, mulongeleni mwene ng'anda, ‘Mkulufunzi kouza, Dakwahi digati da wahenza kondanidile mandia ga Pasaka na wanahina zangu?’ ");
INSERT INTO zaj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kowalagusila gati kulu da uchana, difagiligwe na kuhambigwa. Tutandileni mandia himo.” ");
INSERT INTO zaj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wanahina walawa, wachola hakiwambo, wavika kila kinhu kamba viyawalongele. Avo wagatanda gamandia ga Pasaka. ");
INSERT INTO zaj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Viivikile ichungulo, Yesu keza na wanahina zake longo dimwe na wabili. ");
INSERT INTO zaj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Viwakalile hameza woja, Yesu kalonga, “Nowalongela ikweli, munhu imwe mmwanza wenu yoja hamoja na nie, konihonza.” ");
INSERT INTO zaj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wanahina wona giogio, na wasonga kumuuza imweimwe, “Nie, Mndewa?” ");
INSERT INTO zaj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kawalongela, “Imwe mmwanza wenu mweye longo dimwe na wabili yozanhika mkate mkia hamoja na nie. ");
INSERT INTO zaj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nie, Mwana wa Munhu, nodanganhika kamba Nyandiko Zing'alile vuzimulonga, ila kogaya ng'hani munhu ija yondayanihonze nie, Mwana wa Munhu! Vihanogile munhu ija sambiyaleligwe!” ");
INSERT INTO zaj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Viwakalile woja, Yesu kasola mkate, kalonga hewela ha Mulungu, kaumogola kawagwelela wanahina zake, kawalongela, “Usoleni, uno uwo lukuli lwangu.” ");
INSERT INTO zaj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Abaho, kasola kikasi, kalonga hewela ha Mulungu, abaho, kawagwelela wanahina zake, na wose wang'wa. ");
INSERT INTO zaj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kawalongela, “Uno uwo mulopa wangu wa lagano witika sama ya wanhu bwando. ");
INSERT INTO zaj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nowalongela ikweli, sing'wa kabili mulelo uno wa zabibu mbaka zua dija vondaniung'we wa sambi muna Undewa wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Viwamambukize kwimba wila, wachola kuna Ikigongo cha Mizaituni. ");
INSERT INTO zaj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu kawalongela wanahina zake, “Mweye mose, mong'himbila na kundeka, kamba Zinyandiko Zing'alile vuzilonga, ‘Nomtoa imchunga, na iwang'hondolo wopwililika.’ ");
INSERT INTO zaj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ila nihazuka kulawa mkudanganhika, nowalongola nochola Galilaya.” ");
INSERT INTO zaj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petulo kamulongela, “Kamba wose wahakuleka ila nie sikuleka!” ");
INSERT INTO zaj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu kamulongela, “Nokulongela ikweli, ikilo ya lelo, nzogolo hanakwika mianza mibili, konibela mianza midatu.” ");
INSERT INTO zaj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ila Petulo kagangamiza yolonga, “Hata kamba nihadanganhika hamoja na gweye, nidanganhike, ila nie sidaha kukubela gweye!” Na wanahina wose wasigale walonga vivo. ");
INSERT INTO zaj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wavika hanhu hakemigwe Getisemane, Yesu kalonga na wanahina zake, “Kaleni hano, nitambike.” ");
INSERT INTO zaj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kawasola Petulo, Yakobo, na Yohana na heyo mwenyego. Kasonga kudungwadungwa na kugaya mmoyo, ");
INSERT INTO zaj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","kawalongela, “Moyo wangu una giogio ng'hani behi na kudanganhika, kaleni hano mgonelele.” ");
INSERT INTO zaj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kachola hamwande kidogo, kafugama mavindi, katambika kalonga, vihadahika sambiyabitile muna ikipigiti cha mgayo. ");
INSERT INTO zaj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Katambika yolonga, “Tataangu! Gose godahika kumwako. Nisegezele kikasi kino cha mgayo. Ila sio kamba vinilonda nie, ila kamba vuulonda gweye.” ");
INSERT INTO zaj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Abaho, kabwela ha wanahina zake kawavika wawasile. Kamulongela Petulo, “Simoni, kuwasa? Hudahile kugonelela hata saa dimwe?” ");
INSERT INTO zaj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kawalongela, “Goneleleni, na mtambike giladi sambimwingile mkugezigwa. Kwavija loho yolonda, ila lukuli lutepweta.” ");
INSERT INTO zaj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kachola mwanza uyagwe, katambika yolonga mbuli zizija. ");
INSERT INTO zaj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Viyabwelile kawavika wawasile kabili, kwavija meso gao gakala gamemile utulo. Wakala wabule da kumulongela. ");
INSERT INTO zaj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Viyawabwelele mwanza wa ikadatu, kawalongela, “Mng'hali wasa na kuhumula? Yotosha! Kwavija kipigiti kivika! Lola, nie, Mwana wa Munhu, nohonzigwa, mkugeligwa mmakono ga wanhu wali na vilozo. ");
INSERT INTO zaj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Lamukeni tuchole. Lola, munhu yonihonza ka mmabehi!” ");
INSERT INTO zaj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu viyakalile yogendelela kulonga, Yuda, imwe wa waja wanahina longo dimwe na wabili, kavika. Keza na dale da wanhu wapapile mizele na mimbwego, wakala watumigwe na wakulu wa wakulu wa nhambiko, wafundiza Malagizo ga Musa, na wakulu. ");
INSERT INTO zaj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ija imunhu yamuhonzile kakala yawagwelele kilaguso kawalongela, “Munhu yondanimnonele iyo immulonda. Mgogeni mumsole mchole nayo kuno mmwimiliza ng'hani.” ");
INSERT INTO zaj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yuda viyavikile, hima kachola ha Yesu na kulonga, “Mkulufunzi!” Abaho, kamnonela. ");
INSERT INTO zaj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Avo wagolosa makono gao na kumgoga. ");
INSERT INTO zaj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ila munhu imwe yakalile yemile hamoja na Yesu, kasomola zele jake na kumuyenza nyakadala wa Mkulu wa Wakulu wose wa Nhambiko na kumkanha gwiti jake. ");
INSERT INTO zaj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu kawauza, “Mwiza na mizele na mimbwego kunigoga nie kamba vija nie na m'bavi? ");
INSERT INTO zaj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mazua gose nikala hamoja na mweye nifundiza kuna Ing'anda ya Mulungu, hamunigogile. Ila Nyandiko Zing'alile zolondigwa zivikile kamba vuzandikigwe.” ");
INSERT INTO zaj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Abaho, wanahina zake wose wamuleka, wakimbila. ");
INSERT INTO zaj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mmhale imwe yakalile yavalile guo da kuigubika kakala yomkweleleza Yesu. Wageza kumgoga, ");
INSERT INTO zaj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ila kadileka idiguo da kuigubika kuchugu na kukimbila mwazi. ");
INSERT INTO zaj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Abaho, wamsola Yesu na kumgala ha Mkulu wa Wakulu wose wa Nhambiko, na wakulu wa wakulu wa nhambiko, na iwakulu na wafundiza Malagizo ga Musa, wose waiting'hanila. ");
INSERT INTO zaj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petulo kamkoleleza Yesu kutalitali mbaka kengila mdikonhi da ing'anda ya Mkulu wa Wakulu wose wa Nhambiko. Kakala hasi hamoja na wemilizi, yokota moto. ");
INSERT INTO zaj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wakulu wa wakulu wa nhambiko na Ikitala chose Kikulu cha Isi ya Wayahudi wageza kuzahila mbuli ya kumgela m'vilozo Yesu giladi wamkome, ila hawapatile. ");
INSERT INTO zaj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wanhu bwando walava usindila wa uvwizi, ila usindila wao hauiduganye. ");
INSERT INTO zaj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Abaho, wanhu wenuka na kumulonga Yesu mbuli za uvwizi, walonga, ");
INSERT INTO zaj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tumuhulika yolonga, ‘Noibomola Ng'anda ino ya Mulungu izengigwe na wanhu. Na gahabita mazua madatu noizenga iyagwe ayo haizengigwe na wanhu.’ ” ");
INSERT INTO zaj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Vivija usindila wao hauiduganye. ");
INSERT INTO zaj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Abaho, Mkulu wa Wakulu wose wa Nhambiko kenuka haulongozi wao wose kamuuza Yesu, “Kwabule cha kwidika mnhaguso zino zose zowokutagusa?” ");
INSERT INTO zaj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ila Yesu kanyamala na halongile chochose. Mkulu wa Wakulu wose wa Nhambiko kamuuza Yesu mwanza uyagwe, “Gweye iyo Kilisto, Mwana wa Mulungu Mwene Yenzi?” ");
INSERT INTO zaj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu kalonga, “Iyo nene. Na monyona nie, Mwana wa Munhu, nikalile ng'ambu ya ukulume ya Ukulu, nikwiza na mawingu ga kuulanga!” ");
INSERT INTO zaj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mkulu wa Wakulu wose wa Nhambiko kasinhuka, kadega guo jake, kalonga, “Hatulonda wasindila wayagwe! ");
INSERT INTO zaj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Muuhulika ufukuzi wake! Mweye molongaze?” Wose walamula walonga, “Kaloza, kolondigwa yakomigwe.” ");
INSERT INTO zaj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Wanhu wayagwe wasonga kumtemela mate, wamgubika ikihanga, abaho, wamtoa, walonga, “Zuza, yalihi yakutoile!” Na wemilizi wamsola wamtoa makofi. ");
INSERT INTO zaj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petulo viyakalile yakalile hasi mdikonhi, mtwanzi imwe mtumigwa wa Mkulu wa Wakulu wose wa Nhambiko keza behi nayo. ");
INSERT INTO zaj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Viyamuwene Petulo yokota moto, kamulola ng'hani, abaho, kamulongela, “Gweye nagwe kukala hamoja na Yesu wa Nazaleti?” ");
INSERT INTO zaj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ila Petulo kabela, kamulongela, “Sikimanya, ama sikitanga chuulonga.” Abaho, kalawa kunze mkubitila mulwivi lwa haulongozi, kipigiti kikija nzogolo keka. ");
INSERT INTO zaj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ija imtumigwa wa kitwanzi kamona Petulo mwanza uyagwe, kasonga kubwelela kulonga mbuli iija ha wanhu wemile behi nayo, “Ino ka mmwanza wao!” ");
INSERT INTO zaj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ila Petulo kabela mwanza uyagwe. Kipigiti kidodo hamwande, wanhu wakalile wemile behi wamulongela Petulo mwanza uyagwe, “Sambiubele, gweye kwa mmwanza wao, kwavija na gweye kwa Mgalilaya.” ");
INSERT INTO zaj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kasonga kudukumiza na kuiduila, “Simtangile munhu ino yummulonga mbuli zake!” ");
INSERT INTO zaj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Abaho, bahaja nzogolo keka mwanza uyagwe, abaho, Petulo kakumbukila avija vayamulongele Yesu, “Nzogolo hanakwika mianza mibili, konibela mianza midatu.” Kabemendeka kakala hasi kasonga kulila. ");
INSERT INTO zaj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ulukwili, wakulu wa wakulu wa nhambiko waiting'hana hima na iwakulu, wafundiza Malagizo ga Musa, na Ikitala chose Kikulu cha Isi ya Wayahudi, na kugelegeza vondawatende. Wamdaza Yesu minyolo, wamgala na kumgwelela Pilato. ");
INSERT INTO zaj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato kamuuza, “Gweye iyo Mndewa wa Wayahudi?” Yesu kamwidika, “Gweye iyo ulonga avo.” ");
INSERT INTO zaj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wakulu wa wakulu wa nhambiko wamtagusa Yesu vinhu bwando, ");
INSERT INTO zaj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","avo, Pilato kamuuza mwanza uyagwe, “Hulonda kwidika? Tegeleza mbuli zao zose zowokutagusa!” ");
INSERT INTO zaj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mwanza uyagwe Yesu halongile mbuli, na Pilato kakanganya. ");
INSERT INTO zaj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kila Lusona lwa Pasaka Pilato kakala yazoele kumfungulila mfungigwa imwe, ija wanhu iwamulondile. ");
INSERT INTO zaj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kipigiti kija munhu yakemigwe Balaba kakala mkifungo sama ya kuwadulukila wanhu wa silikali, na kukoma mkipigiti cha umzahimzahi wa kuilema silikali. ");
INSERT INTO zaj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dale da wanhu dimwizila Pilato, wasonga kumuuza yawatendele kamba viyawatendelaga. ");
INSERT INTO zaj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kawauza, “Molonda niwalekesele Mndewa wa Wayahudi?” ");
INSERT INTO zaj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kwavija heyo kavitanga kamba, wakulu wa wakulu wa nhambiko wakala wamgalile Yesu kumwake sama ya migongo. ");
INSERT INTO zaj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ila wakulu wa wakulu wa nhambiko wawaswagiza didale da wanhu dimulongele Pilato yawafungulile Balaba. ");
INSERT INTO zaj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato kalonga mwanza uyagwe, “Molonda nimtende choni munhu ino imumkema Mndewa wa Wayahudi?” ");
INSERT INTO zaj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Watoa nyangi walonga, “Muwambe mumsalaba!” ");
INSERT INTO zaj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato kauza, “Ila choni chayatendile munhu ino?” Wose wongeza kutoa nyangi, “Muwambe mumsalaba!” ");
INSERT INTO zaj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato kalonda yawanogeze ididale da wanhu, avo, kawalekesela Balaba. Abaho, kalagiza Yesu yalanhigwe abaho kamgela mmakono ga asikali wakamuwambe mumsalaba. ");
INSERT INTO zaj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Asikali wamsola Yesu wamwingiza mdikonhi da iding'anda da kindewa na kuwakema hamoja asikali wasigale. ");
INSERT INTO zaj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wam'vaza Yesu guo da zambalau, waluka mkungo wa mizomola, wam'vaza mditwi jake. ");
INSERT INTO zaj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Abaho, wasonga kumulamsa mumzihaka, “Kwa mpile, Mndewa wa Wayahudi!” ");
INSERT INTO zaj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wamtoatoa na ludete mditwi, wamtemela mate, wamfugamila mavindi na kumwinamila. ");
INSERT INTO zaj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Viwamambukize kumtendela uponela, wam'vula idiguo da zambalau, abaho, wam'vaza vivalo vake. Abaho, wamulava hanze ya idiwambo wakamuwambe mumsalaba. ");
INSERT INTO zaj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Munhu imwe kulawa isi ya Kilene yokemigwa Simoni, tata wa Alekizanda na Lufo, kakala yokwingila mdiwambo kulawa kumigunda, asikali wamshulutiza yaupape msalaba wa Yesu. ");
INSERT INTO zaj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wamsola Yesu wamgala hanhu hakemigwe Goligota, nhegulo yake, “Hanhu ha Fulu da Pala.” ");
INSERT INTO zaj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wageza kumgwelela divai igeligwe manemane, ila Yesu haing'wile. ");
INSERT INTO zaj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Abaho, wamuwamba mumsalaba na kuigolela vivalo vake wenyego kwa wenyego, watoa kula walamule yalihi yapate kivalo kilihi. ");
INSERT INTO zaj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ikala saa ndatu ya imitondo viwamuwambile mumsalaba. ");
INSERT INTO zaj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lupwilili lwa nhaguso yake lwandikigwa vino, “mndewa wa wayahudi.” ");
INSERT INTO zaj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na vivija wabavi wabili wawawamba mumsalaba hamoja na Yesu, imwe ng'ambu yake ya ukulume na iyagwe ng'ambu yake ya ukumoso. ");
INSERT INTO zaj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na Nyandiko Zing'alile zolonga, “Kapetigwa hamoja na watenda gehile,” zivikila. ");
INSERT INTO zaj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wanhu wabitile behi na haja wamwasila maligo watigisa mapala gao na kulonga, “Aha! Gweye ulondile kuibananga Ng'anda ya Mulungu na kuizenga mmazua madatu, ");
INSERT INTO zaj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","uikombole mwenyego, uhumuluke mumsalaba!” ");
INSERT INTO zaj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Vivija wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa wamtendela uponela, wenyego kwa wenyego wolonga, “Kawakombola wayagwe, ila hadahile kukiikombola mwenyego! ");
INSERT INTO zaj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tumulole Kilisto Mkombola, Mndewa wa Islaeli, yahumuluke kulawa mumsalaba, na tweye tumtogole!” Vivija na waja wabili wawambigwe hamoja nayo wamuliga Yesu. ");
INSERT INTO zaj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Viivikile saa sita imisi, isi yose ikala igubikwe na ziza mbaka saa tisa ichungulo. ");
INSERT INTO zaj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Viivikile saa tisa, Yesu kenula dizwi kalila yolonga, “Eloi, Eloi, lama sabakitani?” nhegulo yake “Mulungu wangu, Mulungu wangu, habali undekile?” ");
INSERT INTO zaj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wanhu wakalile behi wahulika mbuli zija, walonga, “Tegeleza, komkema Eliya!” ");
INSERT INTO zaj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Munhu imwe kakimbila, kazabika siponji mdivai igwaduke kaika kuisota ya lumango, na kumgwelela Yesu yang'we, yolonga, “Beta tulole kamba Eliya kokwiza kumuhumulusa kulawa mumsalaba!” ");
INSERT INTO zaj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu kenula dizwi kaguta ng'hani, abaho, kadanganhika. ");
INSERT INTO zaj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Guo ditungikwe Mng'anda ya Mulungu didegeka vidanga vibili, kulawa uchana mbaka hasi. ");
INSERT INTO zaj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mkulu wa asikali mia wa Loma yakalile yemile haja haulongozi wa Yesu, kahulika avija viyakalile yolila na kumona vija viyodanganhika, kalonga, “Kweli munhu ino kakala Mwana wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kukala na watwanzi wolola kutalitali. Mmwanza wao wakala Maliamu wa kiwambo cha Magidala, Salome, Maliamu mamaake Usufu na Yakobo mdodo. ");
INSERT INTO zaj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Watwanzi wano wakala womkweleleza Yesu na kumsang'hanikila viyakalile Galilaya. Vivija watwanzi bwando wayagwe wakalile wokwela hamoja na heyo kwiza Yelusalemu, wakala bahaja. ");
INSERT INTO zaj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Dikala disigale zua dimwe kuvikila Zua da Mhumulo ajo dikemigwa zua da msasalo. Avo ichungulo vuikwenhuke, ");
INSERT INTO zaj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Usufu kulawa mdiwambo da Alimataya, yakalile imwe wa wanhu wa Ikitala Kikulu cha Isi ya Wayahudi, yakalile yobeta kwiza kwa Undewa wa Mulungu, bila kudumba kachola ha Pilato kulupula lukuli lwa Yesu. ");
INSERT INTO zaj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato kakanganya kuhulika kamba Yesu kesha kudanganhika. Kamkema mkulu wa asikali mia wa Loma, kamuuza kamba Yesu kadanganhika kamala. ");
INSERT INTO zaj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Viyahulike kulawa ha ija imkulu wa asikali mia wa Loma kamba Yesu kadanganhika, Pilato kamulongela Usufu yakalusole ulukuli. ");
INSERT INTO zaj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Abaho, Usufu kagula sanda, kaluhumulusa ulukuli, kaluzingiliza sanda na kulutambalika mdipanga dipukigwe mdibwe, abaho, kadibimbilisa dibwe kadika hamulomo wa idipanga. ");
INSERT INTO zaj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliamu wa kiwambo cha Magidala na Maliamu mamaake Usufu wahona halwikigwe lukuli lwa Yesu. ");
INSERT INTO zaj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Vidibitile Zua da Mhumulo, Maliamu wa kiwambo cha Magidala, Salome, na Maliamu mamaake Yakobo wagula mavuta ga kunung'hila giladi wakalubake lukuli lwa Yesu. ");
INSERT INTO zaj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ndamuka ya zua da mwanduso wa wiki, zua vudisongile kusimbuka, wachola kudipanga. ");
INSERT INTO zaj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Wakala wokiilongela wenyego kwa wenyego, “Yalihi yondayatubimbilisile idibwe hana umulomo wa idipanga?” ");
INSERT INTO zaj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ila viwalolile uchana, wajona dija idibwe dikalile kulu ng'hani dibimbilisigwa kumgwazo. ");
INSERT INTO zaj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Viwakalile wokwingila mdipanga, wamona mmhale imwe yavalile ng'hanzu nzelu yakalile kumkono wa ukulume wa idipanga, wasinhuka. ");
INSERT INTO zaj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ila kawalongela, “Sambimsinhuke, novimanya kamba momzahila Yesu wa Nazaleti, yawambwigwe mumsalaba. Kahaduhu hano, kazuka! Loleni, hanhu hawamtambalike. ");
INSERT INTO zaj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ila gendeni mkawalongele wanahina zake na Petulo, ‘Kowalongola kuchola Galilaya, ako momona kamba viyawalongele.’ ” ");
INSERT INTO zaj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wahalawa na kukimbila kulawa mdipanga, kwavija wagogigwa na bwembwe na mkanganyo, na hawamulongele munhu yoyose, kwavija wona bwembwe. ");
INSERT INTO zaj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu viyazukile kulawa mkudanganhika mdizua da mwanduso wa wiki, kasonga kumulawilila Maliamu wa kiwambo cha Magidala ayo yakalile na vinyamkela saba wawingigwe. ");
INSERT INTO zaj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maliamu kachola kuwalongela waja wakalile hamoja na heyo, viwakalile wokiiyalala na kulila. ");
INSERT INTO zaj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ila viwahulike kamba Yesu mgima na heyo mwenyego kamona, hawatogole. ");
INSERT INTO zaj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Vuzibitile mbuli zino, Yesu koneka mwa wanhu wabili wakalile wamtogole kuno yagaluke ikihanga, wakalile mnzila wolawa mkiwambo wochola kumigunda. ");
INSERT INTO zaj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wabwela na kuwalongela wayao, ila hawawatogole. ");
INSERT INTO zaj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hakimambukizo, Yesu kawalawilila wanahina longo dimwe na imwe viwakalile woja. Kawakomhokela, kwavija viwakalile bule nhamanila na vija viwakalile wadala mmioyo yao, kwavija hawawatogole waja wamonile kipigiti viyazukile kulawa mkudanganhika. ");
INSERT INTO zaj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kawalongela, “Gendeni muulumwengu wose mkaupete Usenga Unogile ha wanhu wose. ");
INSERT INTO zaj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Munhu yoyose yondayatogole na kubatizigwa kokomboligwa, ila munhu yoyose yoleka kutogola kotagusigwa. ");
INSERT INTO zaj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na vilaguso vino vokwandakana na awo wondawatogole. Mtwaga jangu wowinga vinyamkela, na wolonga ulonzi wa mkanganyo. ");
INSERT INTO zaj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wogoga nyoka na makono gao, na kamba wahang'wa kinhu chochose cha kukoma, hakiwagaza. Wokwika makono gao mwa watamu, na wohona.” ");
INSERT INTO zaj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Viyeshile kulonga nao, Mndewa Yesu kasoligwa uchana kuulanga kakala kumkono wa ukulume wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wanahina wachola kuupeta Usenga Unogile kila hanhu, na Mndewa kasang'hanika nao na kuzigangamiza mbuli zake na vilaguso vandakane nazo.");
INSERT INTO zaj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mkulu Teofilo, wanhu bwando waiyoha kwandika mumnhongo mbuli zija zivikizwe mmwetu. ");
INSERT INTO zaj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Wandika kamba vija vuzikalile zisimulilwa na waja wazonile na meso gao songela haichanduso, awo wakalile wozipeta. ");
INSERT INTO zaj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Avo na nie, Mkulu, avija vunizilolile goya mbuli zino zose songela ichanduso chake, nivigesa vinoga nikwandikile vinogile. ");
INSERT INTO zaj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Notenda vino giladi na gweye uitange ikweli ya mbuli zija zuufundizigwe. ");
INSERT INTO zaj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kipigiti Helode Mkulu vayakalile mndewa wa Yudea, kukala na mkulu wa nhambiko imwe twaga jake Zakalia, yakalile wa dale da watambika dikemigwa Abiya. Mtwanzi wake kakala yokemigwa Elizabeti, na heyo kakala wa lukolo lwa mtambika Haloni. ");
INSERT INTO zaj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wose wabili wakala womnogela Mulungu na wawinza ndagizi zose za Mndewa bila kusigaza. ");
INSERT INTO zaj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Zakalia na Elizabeti wakala wabule wana, kwavija Elizabeti kakala bule sambo, na hewo wose wabili wakala wavyele ng'hani. ");
INSERT INTO zaj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zua dimwe Zakalia kakala yosang'hana sang'hano za watambika Mng'anda ya Mulungu, kwavija dale jake da watambika dikala mzamu. ");
INSERT INTO zaj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kamba viwazoele kutenda watambika, kula imgwila Zakalia yachole kufusha ubane kuna ikilingo cha kulavila nhosa. Avo kengila Mng'anda ya Mndewa, ");
INSERT INTO zaj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","wanhu wose wakala wakiilundize hanze wotambika kipigiti hicho cha kufusha ubane. ");
INSERT INTO zaj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Msenga wa Mndewa wa kuulanga kamulawilila, kema ng'ambu ya ukulume ya ikilingo cha kufushila ubane. ");
INSERT INTO zaj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakalia viyamuwene, kasinhuka, bwembwe dimwingila. ");
INSERT INTO zaj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Msenga wa Mulungu wa kuulanga kamulongela, “Zakalia, sambiudumbe kwavija Mulungu kazihulika nhambiko zako, avo Elizabeti mtwanzi wako kokulelela mwana mbigalo, na gweye umgwelele twaga dikemigwa Yohana. ");
INSERT INTO zaj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kosekelela na kudeng'ha ng'hani, na wanhu bwando woitoela ng'henze mvumbuka yake! ");
INSERT INTO zaj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kowa mkulu hameso ga Mndewa. Hang'wa ugimbi ama kinhu chochose cha kukola. Komemezigwa Loho wa Mulungu songela mmunda mwa mamaake. ");
INSERT INTO zaj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kowabweza wanhu bwando wa Islaeli kuli Mndewa Mulungu wao. ");
INSERT INTO zaj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kochola haulongozi wa Mndewa na mhiko na loho ya Eliya, kowaduganyiza tena watata na wana zao, kowatenda wanhu wadulu wawe wende avo yamtandile Mndewa wanhu zake.” ");
INSERT INTO zaj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakalia kamuuza msenga wa Mulungu wa kuulanga, “Novitangaze kamba mbuli zino zowa avo? Kwavija nie na mtwanzi wangu tose twa wavyele.” ");
INSERT INTO zaj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Msenga wa Mulungu wa kuulanga kamwidika, “Nie iyo Gabulieli, mtumigwa nimaga haulongozi wa Mulungu, nitumigwa nikugalile usenga uno unogile. ");
INSERT INTO zaj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ila kwavija huzitogole mbuli zangu zondazivikile mumsimu wake, kowa bubui, hudaha kulonga mbaka zua dija gano gose ganikulongele vondagalawilile.” ");
INSERT INTO zaj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kipigiti hicho wanhu wakala wom'beta Zakalia kuno wokanganya habali kokawa muja Mng'anda ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Viyalawile hanze, kakala hadaha kulonga nao, avo wavitanga kamba kakala yonile nzozi Mng'anda ya Mulungu. Kakala hadaha kulonga, kakala yolonga mkulagusa na makono. ");
INSERT INTO zaj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kipigiti chake cha kusang'hanika Muing'anda ya Mulungu vukimalile, kabwela ukae. ");
INSERT INTO zaj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mkipigiti kiguhi mtwanzi wake kapata inda, avo kakala hakae yake milenge mitano. ");
INSERT INTO zaj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kalonga, “Hakimambukizo, Mndewa kanyonela bazi, kanisegezela kinyala changu mwa wanhu.” ");
INSERT INTO zaj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Muna umulenge wa sita wa inda ya Elizabeti, Mulungu kamulagiza msenga wake wa kuulanga, yokemigwa Gabulieli, hakiwambo cha Galilaya, kikemigwa Nazaleti. ");
INSERT INTO zaj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kakala na usenga wa mndele imwe mhambe, mkasano wa munhu imwe twaga jake Usufu kulawa mulukolo lwa Mndewa Daudi. Twaga jake Maliamu. ");
INSERT INTO zaj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Msenga wa Mulungu wa kuulanga kamcholela kamulongela, “Nokulamsa! Mndewa ka hamoja nagwe na kakumoteza ng'hani!” ");
INSERT INTO zaj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliamu kazanywa ng'hani sama ya mbuli zija za msenga wa Mulungu wa kuulanga na kugelegeza choni nhegulo ya mbuli zija. ");
INSERT INTO zaj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Msenga wa Mulungu wa kuulanga kamulongela, “Sambiudumbe, Maliamu, kwavija Mulungu kanogelwa nagwe. ");
INSERT INTO zaj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kopata inda, komulela mwana mbigalo, na gweye kolondigwa umgwelele twaga dikemigwa Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Heyo kowa mkulu na kokemigwa Mwana wa Mulungu Mkulu Ng'hani. Mndewa Mulungu komgwelela kigoda cha undewa kamba tataake Daudi. ");
INSERT INTO zaj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Avo kowa Mndewa wa lukolo lwa Yakobo milongo yose, Undewa wake hauziga!” ");
INSERT INTO zaj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maliamu kedika kalonga, “Nie na mhambe. Yodahikaze mbuli ino?” ");
INSERT INTO zaj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Msenga wa Mulungu wa kuulanga kedika kalonga, “Loho wa Mulungu kokuhumulukila, na mhiko za Mulungu Mkulu Ng'hani zokugubika. Avo mwana yondayavumbuke kowa mwana yang'alile, kokemigwa Mwana wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mgelegeze lumbu jako Elizabeti wamulongile kabule sambo, ila sambi kana inda ya milenge sita hamoja na uvyele wake. ");
INSERT INTO zaj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwavija haduhu mbuli haidahika ha Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maliamu kedika kalonga, “Nie na mtumigwa wa Mndewa, na nhendelwe kamba vuulongile.” Abaho, ija msenga wa Mulungu wa kuulanga kahalawa. ");
INSERT INTO zaj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kipigiti kidodo hamwande Maliamu kaisasala, hima kachola kuna ikiwambo kili muisi ya vigongovigongo ya Yudea. ");
INSERT INTO zaj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kengila muna ing'anda ya Zakalia, kamulamsa Elizabeti. ");
INSERT INTO zaj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeti viyahulike ndamsa ya Maliamu, chana king'hele kizumha mkudeng'ha muinda ya Elizabeti. Na Elizabeti kamemezigwa Loho wa Mulungu, ");
INSERT INTO zaj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","na kenula dizwi kalonga, “Kumota gweye kubanza watwanzi wose, na imwana yondaumulele kamota! ");
INSERT INTO zaj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Vilihi mbuli zino ng'hulu zindawilile nie, hata mama wa Mndewa wangu yeze kumwangu? ");
INSERT INTO zaj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mhunde vinihulike ndamsa yako, chana king'hele muinda yangu kizumha mkudeng'ha. ");
INSERT INTO zaj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kumota gweye utogole kamba gaja gayalongile Mndewa kumwako golawilila!” ");
INSERT INTO zaj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Na Maliamu kalonga, “Moyo wangu womuyenzi Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Loho yangu yomdeng'helela Mulungu Mkombola wangu. ");
INSERT INTO zaj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kwavija kamgelegeza nyakadala wake imwende! Avo kusongela lelo wanhu wa milelo yose wong'hema yamotile, ");
INSERT INTO zaj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mmbuli zija ng'hulu Mulungu Mkulu zayanitendele. Twaga jake ding'ala. ");
INSERT INTO zaj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kulawa wanhu wa mulelo umwe mbaka mulelo uyagwe kowonela bazi awo womdumba heyo. ");
INSERT INTO zaj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kaugolosa mkono wake mkulu na kawapwililisa awo woitopela ngelegeza zao. ");
INSERT INTO zaj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kawahumulusa wandewa wali na mhiko walawe muna ivigoda vao va undewa, na kawenula iwakumbulu. ");
INSERT INTO zaj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wali nzala kawegutiza vinhu vinogile, na wagoli kawaleka wachole bila kinhu. ");
INSERT INTO zaj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kakigoga kilagano chayailagane na wahenga zetu, avo keza kumtaza mtumigwa wake Islaeli. ");
INSERT INTO zaj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kakumbukila kumonela bazi Ablaham na lukolo lake lose milongo yose kamba viwailagane na wahenga zetu!” ");
INSERT INTO zaj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliamu kakala na Elizabeti kamba milenge midatu vino, abaho, kabwela ukae yake. ");
INSERT INTO zaj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kipigiti cha Elizabeti kulela kivika, kamulela mwana mbigalo. ");
INSERT INTO zaj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wanhu wa mmambwegambwega na walawile mulukolo lwake viwahulike mbuli zija zinogile za mkanganyo Mndewa ziyamtendele, wose wadeng'helela hamoja na heyo. ");
INSERT INTO zaj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Zua da nane weza kumwingiza kumbi imwana, walonda kumgwaa twaga da tataake, Zakalia. ");
INSERT INTO zaj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mamaake kalonga, “Ndema! Twaga jake dokemigwa Yohana.” ");
INSERT INTO zaj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wanhu wamulongela, “Ila mulukolo lwenu haduhu munhu yali na twaga hijo.” ");
INSERT INTO zaj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Abaho, wamuuza tataake mkumulagusila na makono, womuuza kamba twaga dilihi doyolonda yagweleligwe mwanage. ");
INSERT INTO zaj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kawapula kibanzi cha kwandikila, kandika vino, “Twaga jake Yohana.” Wanhu wose wakanganya. ");
INSERT INTO zaj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Baho mulomo na lulimi lwake Zakalia vifunguligwa, kasonga kulonga, kamuyenzi Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bwembwe diwengila wanhu wose wa mmambwegambwega na mbuli hizo zisimulilwa ng'ambu zose za isi ya vigongovigongo ya Yudea. ");
INSERT INTO zaj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Wose wahulike mbuli hizo wagelegeza mmioyo yao, wolonga, “Mwana ino kowa munhu wa vilihi? Kwavija mhiko za Mndewa za hamoja na heyo.” ");
INSERT INTO zaj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakalia tataake imwana kamemezwa Loho wa Mulungu, na kulonga usenga uno wa Mulungu, ");
INSERT INTO zaj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Yayenzigwe Mndewa, Mulungu wa Islaeli! Kwavija keza kuwataza wanhu zake na kuwakombola. ");
INSERT INTO zaj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Katugwelela Mkombola mkulu, wa lukolo lwa mtumigwa wake Daudi, ");
INSERT INTO zaj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kamba vija vayailagane na wahokozi zake wang'alile umwaka, ");
INSERT INTO zaj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kamba kotukombola tulawe mmakono ga wadumuka, na kulawa mmakono ga wose watwihile. ");
INSERT INTO zaj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kalonga kowonela bazi wahenga zetu na kudikumbukila lagano jake ding'alile. ");
INSERT INTO zaj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kamduilila Ablaham tata wetu, ");
INSERT INTO zaj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kailagana na heyo kamba kotukombola kulawa mmakono ga wadumuka, na kututenda tweye tumsang'hanikile heyo bila bwembwe, ");
INSERT INTO zaj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","giladi tuwe wanhu wang'alile na tulibule uzenzeleganye haulongozi wake, mazua gose ga ugima wetu. ");
INSERT INTO zaj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Na gweye, mwanangu, kokwiza kukemigwa muhokozi wa Mulungu Mkulu Ng'hani. Kolongola haulongozi wa Mndewa kumtandila nzila yake, ");
INSERT INTO zaj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kowalongela wanhu zake avija vondawakomboligwe mkusegezelwa vilozo vao. ");
INSERT INTO zaj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mulungu wetu kogatenda higo sama ya bazi jake kulu, na ukombola wake kulawa kuulanga wotuhumulukila kamba zua da imitondo ");
INSERT INTO zaj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na kuwamulikila wose wokala mdiziza na awo wakala mdisisila da kudanganhika, na kugalongoza magulu getu muna inzila ya tindiwalo.” ");
INSERT INTO zaj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwana ija kakula na kuwa na mhiko muloho. Kakala muluwala mbaka zua dija viyalawilile mwa wanhu wose wa Islaeli. ");
INSERT INTO zaj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mazua gaja mkulu wa undewa wa Loma, yakalile yokemigwa Augusto, kalagiza wanhu wakalile muundewa wose wa Loma matwaga gao gandikigwe mkitabu. ");
INSERT INTO zaj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nyandikisha ino ikala ya ichanduso, kipigiti kija Kulenio viyakalile mkulu wa isi ya Silia. ");
INSERT INTO zaj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Avo wose wachola kwandikigwa kila munhu mkiwambo chake mwenyego. ");
INSERT INTO zaj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Usufu na heyo kasegela kulawa hakiwambo cha Nazaleti muisi ya Galilaya, kakwela kachola kukiwambo cha Betelehemu muisi ya Yudea, kwaaleligwe Mndewa Daudi kwavija kakala yolawa mulukolo lwa Daudi. ");
INSERT INTO zaj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kachola kwandikigwa hamoja na mkasano wake Maliamu, ayo yakalile na inda. ");
INSERT INTO zaj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Viwakalile hiko, kipigiti chake cha kulela kivika. ");
INSERT INTO zaj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kamulela chaudele mbigalo, kam'vaza vivalo vowowavazaga wana ving'hele, kamtambalika mkia kiwadilaga ng'ombe, kwavija hawapatile gati muna ing'anda ya wahenza. ");
INSERT INTO zaj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ng'ambu ija kukala na wachunga wokwimiliza madale gao ga ng'hondolo ikilo mmigunda. ");
INSERT INTO zaj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Msenga wa Mndewa wa kuulanga kawalawilila, na yenzi ya Mndewa Mulungu iwamulika ng'ambu zose, wadumba ng'hani. ");
INSERT INTO zaj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Msenga wa Mulungu wa kuulanga kawalongela, “Sambimdumbe! Niwagalila mbuli inogile yondaiwatende wanhu wose wadeng'he ng'hani. ");
INSERT INTO zaj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kwavija lelo ino muna ikiwambo cha Daudi kavumbuka Mkombola wenu, iyo Kilisto Mndewa. ");
INSERT INTO zaj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na vino vivo vondamumtambule, mom'vika mwana king'hele yavazigwe vivalo vowowavazaga wana ving'hele katambalikwa mkia kiwadilaga ng'ombe.” ");
INSERT INTO zaj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Baho dale kulu da wasenga wa Mulungu wa kuulanga diza kuilumba hamoja na miyao wa ichanduso, womuyenzi Mulungu, wolonga, ");
INSERT INTO zaj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Yenzi ha Mulungu yali uchana ng'hani kuulanga, na tindiwalo muisi, ha wanhu wanogelwe na heyo!” ");
INSERT INTO zaj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Waja iwasenga wa Mulungu wa kuulanga viwabweleganye kuulanga, waja iwachunga wakiilongela, “Tucholeni Betelehemu tukalole mbuli ino ilawilile, Mndewa yaatulongele.” ");
INSERT INTO zaj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Avo wachola hima wam'vika Maliamu na Usufu na wamona ija imwana king'hele katambalikwa mkia kiwadilaga ng'ombe. ");
INSERT INTO zaj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wachunga viwamonile ija imwana, wawalongela wanhu mbuli za mwana ija ziwahulike kulawa ha msenga wa Mulungu wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wanhu wose wakanganya viwahulike mbuli ziwalongeligwe na wachunga. ");
INSERT INTO zaj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maliamu kazika mbuli zija zose mmoyo wake kuno yozigelegeza. ");
INSERT INTO zaj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Waja iwachunga wabwela kuno womuyenzi na kumtogola Mulungu, kwavija gaja gawahulike na kugona gawa kamba vija msenga wa Mulungu wa kuulanga viyawalongele. ");
INSERT INTO zaj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Vigabitile mazua manane, kipigiti cha kumwingiza kumbi vikivikile, wamgwaa twaga Yesu, twaga dayagweleligwe na msenga wa Mulungu wa kuulanga kipigiti mamaake hanapata inda. ");
INSERT INTO zaj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kipigiti cha Usufu na Maliamu kutaulwa vikivikile kamba Malagizo ga Musa vigalagize, Usufu na Maliamu wamsola imwana wachola na heyo Yelusalemu wamwike mmakono ga Mndewa. ");
INSERT INTO zaj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Muna Gamalagizo ga Mndewa yandikigwa, “Wana mbigalo wose wa udele wobagulwa na kwikigwa sama ya Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Vivija wachola kulava nhosa kamba viilagizwe Mmalagizo ga Mndewa, hua wabili ama makinda mabili ga njiwa. ");
INSERT INTO zaj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kipigiti kija kukala na munhu imwe twaga jake Simioni yakalile yokala Yelusalemu. Kakala yomdumba Mulungu, yotenda gamnogele Mulungu na kakala yololela kukombolwa kwa Islaeli. Na Loho wa Mulungu kakala na heyo. ");
INSERT INTO zaj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Loho wa Mulungu kamgubulila kamba heza kudanganhika mbaka yamone Kilisto Mndewa. ");
INSERT INTO zaj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kuno yolongozwa na Loho wa Mulungu, Simioni kachola Kuing'anda ya Mulungu. Usufu na Maliamu viwamgalile Yesu Kung'anda ya Mulungu wamtendele kamba viilagizigwe muna Gamalagizo ga Musa, ");
INSERT INTO zaj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simioni kamsola Yesu mmakono gake kuno yomuyenzi Mulungu yolonga, ");
INSERT INTO zaj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Avino, Mndewa, kugavikiza gaja gautulongele, avo muleke nyakadala wako yachole mditindiwalo. ");
INSERT INTO zaj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwavija nyona ukombola wako na meso gangu mwenyego, ");
INSERT INTO zaj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","awo uugalile sama ya wanhu wa isi zose. ");
INSERT INTO zaj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mulenge wondauwagubulile Wamhazi gaja gaulonda, na kugala yenzi mwa wanhu zako wa Islaeli.” ");
INSERT INTO zaj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tata na mama wa imwana wakala wokanganya mbuli ziyalongile Simioni yomulonga Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simioni kawamoteza, kamulongela Maliamu mamaake imwana, “Tegeleza, mwana ino kavumbuka giladi yawe kilamso cha kuhumuluswa kwa wanhu bwando na kwinuligwa kwa wanhu bwando muna iisi ya Islaeli. Kowa kilaguso kilawa ha Mulungu chondakilemigwe na wanhu, ");
INSERT INTO zaj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","avo ngelegeza za wanhu bwando zili mgati zokoneka. Na gweye mwenyego usungu uli kamba zele wokuhoma mmoyo wako.” ");
INSERT INTO zaj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Vivija kukala na muhokozi imwe mtwanzi m'vyele ng'hani twaga jake Ana, mndele wa Fanueli wa mtala wa Asheli. Kakala yakalile na mbigalo milao saba songela viyasoligwe, ");
INSERT INTO zaj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","songela aho kakala kizuka mbaka viyakalile m'vyele wa milao malongo manane na mine. Kipigiti hicho chose kakala Kung'anda ya Mulungu yomtambikila Mulungu misi na kilo, yofunga na kutambika. ");
INSERT INTO zaj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kipigiti kikija keza, na kusonga kamuyenzi Mulungu na kulonga mbuli za ija imwana mmagwiti ga wanhu wose wakalile wololela kukomboligwa kwa Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Usufu na Maliamu viweshile kutenda gose galagizwe muna Gamalagizo ga Mndewa, wabwela ukae yao kukiwambo cha Nazaleti muisi ya Galilaya. ");
INSERT INTO zaj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana ija kakula, kongezeka mhiko na ng'hungwe, na Mulungu kammoteza. ");
INSERT INTO zaj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Milao yose Usufu na Maliamu wokwelaga wochola Yelusalemu mkipigiti cha lusona lwa Wayahudi lukemigwa Pasaka. ");
INSERT INTO zaj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu viyakalile mmhale wa milao longo dimwe na mibili, wachola kuna ulusona kamba vowotendaga milao yose. ");
INSERT INTO zaj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ulusona vulwishile, wasonga mwanza wa kubwela kumwao, ila Yesu kasigala Yelusalemu. Usufu na Maliamu hawavitangile. ");
INSERT INTO zaj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wagiza kakala mdale da wanhu mnzila, wachola mwanza wa zua dimwe, abaho, wasonga kumzahila mwa wandugu na wambwiga zao. ");
INSERT INTO zaj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hawamonile, avo wabwela Yelusalemu kumzahila. ");
INSERT INTO zaj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Zua da ikadatu wam'vika Kung'anda ya Mulungu, kakala na wafundiza Malagizo ga Musa, yowategeleza na kuwauza. ");
INSERT INTO zaj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wose wahulike mbuli zake wakanganya ubala na nyidikilo zake. ");
INSERT INTO zaj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Usufu na Maliamu viwamonile wakanganya ng'hani, Maliamu mamaake kamuuza, “Habali ututendele vino, mwanangu? Tataako na nie tugaya tukuzahila kuno tugudema.” ");
INSERT INTO zaj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ila heyo kawedika yolonga, “Habali munizahila? Ham'vitangile avija vinilondigwa nikale mng'anda ya Tataangu?” ");
INSERT INTO zaj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tataake na mamaake hawaitangile nhegulo ya mbuli ino. ");
INSERT INTO zaj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Avo Yesu kahumuluka kabwela Nazaleti na hewo, kakala mwende ha tataake na mamaake. Mamaake kazika mbuli zija zose mmoyo wake. ");
INSERT INTO zaj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu kakula mulukuli na mng'hungwe. Kadeng'helwa na Mulungu na wanhu. ");
INSERT INTO zaj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mulongo umwe na milao mitano ya undewa wa Mndewa Tibelio, Pontio Pilato kakala mtawala wa isi ya Yudea. Helode Antipa kakala mtawala wa isi ya Galilaya, na mkulu wake Filipo kakala mndewa wa isi ya Itulea na Tulakoniti. Lisania kakala mndewa wa isi ya Abilene, ");
INSERT INTO zaj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","na Anasi na Kayafa wakala wakulu wa wakulu wose wa nhambiko. Kipigiti kikija mbuli za Mulungu zim'vikila Yohana, mwanage Zakalia, kuja kuluwala. ");
INSERT INTO zaj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Avo Yohana kachola muisi zose zizunguluke Ulwanda lwa Yolodani, kawapetela, yolonga, “Lekeni vilozo venu mkabatizigwe, na Mulungu kovigela kumgongo vilozo venu.” ");
INSERT INTO zaj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kamba vija viyandikigwe muna ikitabu cha muhokozi Isaya, “Munhu kenula dizwi muluwala, yolonga, ‘Itandeni nzila ya Mndewa, mgoloseleni nzila zake. ");
INSERT INTO zaj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Migea yose yokusiligwa, vigongo na visugulu vose vohimbuligwa. Nzila ziveduke zogolosigwa, hali na mikolongokolongo hatelebuswe. ");
INSERT INTO zaj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na wanhu wose wowona ukombola kulawa ha Mulungu.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yohana kawalongela wanhu bwando wamwizile wabatizigwe, “Mweye wana wa nyoka! Iyo yalihi yawazumile kulukimbila lusango lwa Mulungu londalwize? ");
INSERT INTO zaj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tendeni mbuli zilagusa kamba muleka vilozo venu. Sambimsonge kuilongela kamba ‘Ablaham iyo tata wetu.’ Kwavija nie nowalongela Mulungu kodaha kumwinulila Ablaham wana kulawa mgamabwe gano. ");
INSERT INTO zaj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Avo nhemo ikigwa goya kuikanha mibiki mmisina, avo biki jojose dondadileke kulela mujo unogile dokanhigwa na kwasigwa hamoto.” ");
INSERT INTO zaj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dale da wanhu dimuuza, “Avo, tutendeze?” ");
INSERT INTO zaj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kawalongela, “Yali na vivalo vibili yam'bagulile yalibule, na yali na mandia yatende vivo.” ");
INSERT INTO zaj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wawila kodi na hewo weza kubatizigwa, wamuuza, “Mkulufunzi, na tweye tutendeze?” ");
INSERT INTO zaj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Na heyo kawalongela, “Sambimuwile kodi ng'hulu kubanza vumulagizwe.” ");
INSERT INTO zaj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Asikali na hewo weza kumuuza, “Na tweye tutende choni?” Na heyo kawalongela, “Sambim'bokonye hela za munhu yoyose ama sambimum'vwizile mbuli munhu yoyose, mwenelwe na maliho genu.” ");
INSERT INTO zaj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Wanhu wose wakala wamemile nhamanila ha Yohana, wakala wokiiuza mmioyo yao kamba siku Yohana iyo Kilisto. ");
INSERT INTO zaj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Avo Yohana kawalongela wanhu wose, “Nie nowabatiza mweye na mazi, ila kokwiza yali na mhiko kubanza nie, nie sidaha hata kufungula nzabi za ng'hwabasa zake. Heyo kowabatiza na Loho wa Mulungu na moto. ");
INSERT INTO zaj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Heyo kana kia chake cha kubetela ngano yake, yakunzanye ingano kukano, na imikumvi yaisome na moto hauzimikaga.” ");
INSERT INTO zaj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohana kaupeta Usenga Unogile mwa wanhu yowazuma mkuwagong'ondeza na mbuli bwando waleke gehile. ");
INSERT INTO zaj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ila Yohana kamkomhokela Helode Antipa, mndewa, kwavija kakala yamsolile Helodia, mtwanzi wa ndugu yake, na gehile gose goyokala yotenda. ");
INSERT INTO zaj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Avo Helode kabanziliza udumuka wake ha Yohana, na kamgela mkifungo. ");
INSERT INTO zaj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wanhu wose viweshile kubatizigwa, Yesu na heyo kabatizigwa. Na viyakalile yotambika, ulanga uvuguka, ");
INSERT INTO zaj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Loho wa Mulungu kamuhumulukila yalumbile kamba hua. Dizwi dihulikwa kulawa kuulanga, “Gweye iyo Mwanangu uninogele, ninogelwa nagwe.” ");
INSERT INTO zaj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu viyasongile sang'hano yake, kakala na milao malongo madatu. Na wanhu wamgesa iyo mwana wa Usufu, mwanage Heli. ");
INSERT INTO zaj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli kakala mwanage Matati, Matati kakala mwanage Lawi, Lawi kakala mwanage Meliki, Meliki kakala mwanage Yanai, na Yanai kakala mwanage Usufu, ");
INSERT INTO zaj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Usufu kakala mwanage Matatia, Matatia kakala mwanage Amosi, Amosi kakala mwanage Nahumu, Nahumu kakala mwanage Hesili, Hesili kakala mwanage Nagai, ");
INSERT INTO zaj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai kakala mwanage Maati, Maati kakala mwanage Matatia, Matatia kakala mwanage Shemeni, Shemeni kakala mwanage Yoseki, Yoseki kakala mwanage Yoda, ");
INSERT INTO zaj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda kakala mwanage Yohanani, Yohanani kakala mwanage Lesa, Lesa kakala mwanage Zelubabeli, Zelubabeli kakala mwanage Shelitieli, Shelitieli kakala mwanage Neli, ");
INSERT INTO zaj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli kakala mwanage Meliki, Meliki kakala mwanage Adi, Adi kakala mwanage Kosamu, Kosamu kakala mwanage Elimadamu, Elimadamu kakala mwanage Eli, ");
INSERT INTO zaj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eli kakala mwanage Yoshua, Yoshua kakala mwanage Eliezeli, Eliezeli kakala mwanage Yolimu, Yolimu kakala mwanage Matati, Matati kakala mwanage Lawi, ");
INSERT INTO zaj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawi kakala mwanage Simioni, Simioni kakala mwanage Yuda, Yuda kakala mwanage Usufu, Usufu kakala mwanage Yonamu, Yonamu kakala mwanage Eliakimu, ");
INSERT INTO zaj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimu kakala mwanage Melea, Melea kakala mwanage Mena, Mena kakala mwanage Matata, Matata kakala mwanage Natani, Natani kakala mwanage Daudi, ");
INSERT INTO zaj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daudi kakala mwanage Yese, Yese kakala mwanage Obedi, Obedi kakala mwanage Boazi, Boazi kakala mwanage Salimoni, Salimoni kakala mwanage Nashoni, ");
INSERT INTO zaj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashoni kakala mwanage Aminadabu, Aminadabu kakala mwanage Adimini, Adimini kakala mwanage Ani, Ani kakala mwanage Heziloni, Heziloni kakala mwanage Pelesi, Pelesi kakala mwanage Yuda, ");
INSERT INTO zaj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda kakala mwanage Yakobo, Yakobo kakala mwanage Isaka, Isaka kakala mwanage Ablaham, Ablaham kakala mwanage Tela, Tela kakala mwanage Naholi, ");
INSERT INTO zaj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naholi kakala mwanage Selugi, Selugi kakala mwanage Leu, Leu kakala mwanage Pelegi, Pelegi kakala mwanage Ebeli, Ebeli kakala mwanage Shela, ");
INSERT INTO zaj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shela kakala mwanage Kainamu, Kainamu kakala mwanage Alufaksadi, Alufaksadi kakala mwanage Shemu, Shemu kakala mwanage Nuhu, Nuhu kakala mwanage Lameki, ");
INSERT INTO zaj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameki kakala mwanage Metusela, Metusela kakala mwanage Henoko, Henoko kakala mwanage Yaledi, Yaledi kakala mwanage Mahalaleli, Mahalaleli kakala mwanage Kainamu, ");
INSERT INTO zaj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainamu kakala mwanage Enoshi, Enoshi kakala mwanage Seti, Seti kakala mwanage Adamu, Adamu kakala mwanage Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu kalawa Mulwanda lwa Yolodani kuno yamemile Loho wa Mulungu, kalongozwa na Loho wa Mulungu mbaka muluwala. ");
INSERT INTO zaj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ako kagezigwa na Mwenembago mkipigiti cha mazua malongo mane. Kipigiti hicho chose hadile kinhu chochose, kipigiti hicho vikimalile, kona nzala. ");
INSERT INTO zaj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Mwenembago kamulongela, “Uhawa gweye iyo Mwana wa Mulungu, dilongele dibwe dino digaluke mkate.” ");
INSERT INTO zaj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu kedika kalonga, “Yandikigwa Mzinyandiko Zing'alile, ‘Munhu hawa mgima sama ya mkate wiyeka.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mwenembago kamsola kamgala uchana ng'hani, mkipigiti kiguhi kamulagusila ndewa zose za ulumwengu. ");
INSERT INTO zaj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mwenembago kamulongela, “Nokugwelela mhiko zino zose na mali gano gose, kwavija nigweleligwa na nodaha kumgwaa yoyose inimulonda. ");
INSERT INTO zaj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Uhanitambikila, vino vose vowa vako gweye.” ");
INSERT INTO zaj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu kamwidika, “Yandikigwa Mzinyandiko Zing'alile, ‘Mtambikile Mndewa Mulungu wako na umsang'hanikile heyo yeiyeka!’ ” ");
INSERT INTO zaj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mwenembago kamsola kamgala Yelusalemu kuna inhembeti ya Ing'anda ya Mulungu, kamulongela, “Uhawa gweye iyo Mwana wa Mulungu, ibwanhe hasi kulawa hano. ");
INSERT INTO zaj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kwavija yandikigwa Mzinyandiko Zing'alile, ‘Mulungu kokulagizila wasenga zake wa kuulanga wakwimilize.’ ");
INSERT INTO zaj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kabili yandikigwa, ‘Wokudang'ha mmakono gao, sambiuikwale mgulu wako muna idibwe.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ila Yesu kamwidika, “Yandikigwa Mzinyandiko Zing'alile, ‘Sambiumgeze Mndewa Mulungu wako.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mwenembago viyeshile kumgeza mmbuli zose, kamuleka mkipigiti kidodo. ");
INSERT INTO zaj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu kabwela muisi ya Galilaya yamemile mhiko za Loho wa Mulungu, na singilimo zake zenela isi zose za mmambwegambwega. ");
INSERT INTO zaj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Na heyo kakala yowafundiza wanhu muna zing'anda zao za nhambiko, na wanhu wose wamtogola. ");
INSERT INTO zaj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Abaho, Yesu kachola Nazaleti kiwambo chayakulile, na muna Idizua da Mhumulo, kengila mng'anda ya nhambiko kamba vayazoele. Kema giladi yasome Nyandiko Zing'alile. ");
INSERT INTO zaj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kagweleligwa ikitabu cha muhokozi Isaya. Kakigubula kavika hanhu handikigwe vino, ");
INSERT INTO zaj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Loho wa Mndewa ka hamoja na nie, kwavija kanisagula niwagalile wakumbulu Usenga Unogile. Kanilagiza niipete ndekesa mwa awo wagogigwe, na vimbugumbugu wadahe kulola, niwadohole waja wogazigwa. ");
INSERT INTO zaj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na kupeta kamba kipigiti kivika cha mndewa kuwakombola wanhu zake.” ");
INSERT INTO zaj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Abaho, Yesu kakigubika ikitabu kam'bwezela mwimilizi wa ing'anda ya nhambiko, abaho, kakala hasi. Wanhu wose wakalile muja mng'anda ya nhambiko wamulola ng'hani. ");
INSERT INTO zaj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na heyo kawalongela “Lelo Nyandiko zino Zing'alile zivikila, kamba vumuhulike.” ");
INSERT INTO zaj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wanhu wose wanogelwa ng'hani, wakanganya mbuli zinogile zayalongile. Walonga, “Ino sio mwanage Usufu?” ");
INSERT INTO zaj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu kawalongela, “Nivitanga kamba monilongela ulonzi uno, ‘Mganga, ihonye mwenyego! Gaja gatuhulike ugatendile Kapenaumu ugatende hano hakiwambo chako mwenyego.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kagendelela kulonga, “Nowalongeleni ikweli, muhokozi hatogoligwa hakae yake mwenyego. ");
INSERT INTO zaj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Kweli, kukala na vizuka bwando muna iisi ya Islaeli kipigiti chayakalile Eliya, kipigiti mvula vuilekile kutoa milao midatu na milenge sita, nzala ikala mpamanho muna iisi yose. ");
INSERT INTO zaj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ila Eliya hatumigwe ha kizuka yoyose, ila ha kizuka imwe yakalile Salepta muna iisi ya Sidoni. ");
INSERT INTO zaj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na kukala wanhu bwando wakalile na dikulu muna iisi ya Islaeli kipigiti chayakalile muhokozi Elisha, na haduhu mtamu yoyose wa dikulu yahonyigwe, ila Naamani yeiyeka yakalile yokala muisi ya Silia.” ");
INSERT INTO zaj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wanhu wose wakalile muja mng'anda ya nhambiko viwahulike mbuli zija wona lusango. ");
INSERT INTO zaj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wema, wamkwekwesa Yesu, wamulava hanze ya ikiwambo. Wamsola wamgala uchana ya ikigongo, haja idiwambo jao hadizengigwe, walonda kumsung'hizila mdigema. ");
INSERT INTO zaj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ila Yesu kabita hagatigati yao, kachola na zake. ");
INSERT INTO zaj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Abaho, Yesu kachola kukiwambo cha Kapenaumu muisi ya Galilaya, kawafundiza wanhu muna Dizua da Mhumulo. ");
INSERT INTO zaj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wakanganya avija voyokala yofundiza kwavija mbuli zake zikala na udaho. ");
INSERT INTO zaj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Muja muna ing'anda ya nhambiko kukala na munhu yakalile na kinyamkela, katoa nyangi yolonga, ");
INSERT INTO zaj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ka! Kotulonda choni gweye, Yesu wa Nazaleti? Kwiza kutubananga? Nokutanga, gweye iyo Ung'alile wa Mulungu!” ");
INSERT INTO zaj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu kamkomhokela ija kinyamkela, yolonga, “Nyamala, mulawe munhu ino.” Kinyamkela kam'bwanha hasi ija imunhu hameso gao, kamulawa bila kumulumiza hanhu. ");
INSERT INTO zaj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wanhu wose wakanganya, wailongela, “Mbuli zaki zino? Munhu ino kana mhiko na udaho wa kuwakomhokela vinyamkela, nao wolawa!” ");
INSERT INTO zaj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mbuli za Yesu zenela ng'ambu zose za isi ija. ");
INSERT INTO zaj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu kalawa muna ing'anda ya nhambiko, kachola hakae ya Simoni. Mama mkwe yake Simoni kakala yolumwa homa ng'hali, avo wamulongela Yesu yamuhonye. ");
INSERT INTO zaj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu keza kema behi na heyo, kaikomhokela ija ihoma, imulawa, kenuka na kuwasang'hanikila. ");
INSERT INTO zaj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Viivikile ichungulo, wanhu wose wawagala ha Yesu wanhu zao wakalile wolumwa vitamu va namna zose, kawekila makono gake kawahonya. ");
INSERT INTO zaj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Vinyamkela wawalawa wanhu bwando, watoa nyangi wolonga, “Gweye iyo Mwana wa Mulungu.” Yesu kawakomhokela hawalekile walonge, kwavija wamtanga heyo iyo Kilisto. ");
INSERT INTO zaj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ulukwili, Yesu kasegela kachola hanhu halibule wanhu. Wanhu wasonga kumzahila, viwamonile, wageza kumzuila sambiyasegele hamwao. ");
INSERT INTO zaj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ila heyo kawalongela, “Nolondigwa niupete Usenga Unogile wa Undewa wa Mulungu m'viwambo viyagwe, kwavija nhumigwa nhende vino.” ");
INSERT INTO zaj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kakala yowapetela wanhu Usenga Unogile wa Undewa wa Mulungu muna zing'anda za nhambiko muisi yose ya Yudea. ");
INSERT INTO zaj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Zua dimwe Yesu kakala yemile hamgwazo wa Idilamba da Genesaleti. Wanhu wakala wokiibabanika wokwenhuka behi na heyo kutegeleza mbuli za Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kazona ngalawa mbili mulugigo lwa idilamba, zikigwe haja na waloa somba, wakalile wosuluza nhando zao. ");
INSERT INTO zaj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu kengila mngalawa imwe ikalile ya Simoni, kamulongela Simoni yaikwenhuse hamwande, hatalitali na ulugigo lwa idilamba. Yesu kakala mngalawa yowafundiza wanhu bwando. ");
INSERT INTO zaj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Viyeshile kulonga kamulongela Simoni, “Kwenhusa ingalawa hamwande hana ididindi da idilamba, na gweye na wayago tandeni nhando zenu muloe somba.” ");
INSERT INTO zaj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni kamulongela, “Mndewa, tugonelela tuloa somba hatupatile kinhu, ila kwavija gweye kulonga, nozitanda nhando.” ");
INSERT INTO zaj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Viwazitandile izinhando, wonza somba bwando, na nhando zao zisonga kukanhika. ");
INSERT INTO zaj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wawakema wayao wakalile mngalawa iyagwe weze kuwataza. Weza wamemeza somba ngalawa zose mbili, avo ngalawa zikala mmabehi kudidimila mmazi. ");
INSERT INTO zaj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petulo viyagonile gaja, kafugama mavindi haulongozi wa Yesu, yolonga, “Mndewa, sambiung'hwenhukile kwavija nie nna vilozo!” ");
INSERT INTO zaj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni na wayage wose wakanganya avija viwonzile somba bwando kamba vija. ");
INSERT INTO zaj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yakobo na Yohana wanage Zebedayo, wakalile waloa somba wayage Simoni, vivija wakanganya. Yesu kamulongela Simoni, “Sambiudumbe, kusongela lelo kowa muloa wanhu.” ");
INSERT INTO zaj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wazikwekwesa zingalawa wazika mumgwazo wa idilamba, waleka gose wamkweleleza Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu viyakalile mdiwambo dimwe da hiko, kaiting'hana na mbigalo imwe yakalile na dikulu lukuli lugima. Viyamonile Yesu, kafugama mavindi, kamulongela mkuiyalala, “Mndewa, uhalonda, kodaha kunihonya.” ");
INSERT INTO zaj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu kagolosa mkono wake kamkwasa yolonga, “Nolonda, hona!” Kipigiti kikija kahona utamu wa dikulu. ");
INSERT INTO zaj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Abaho, Yesu kamulagiza yolonga, “Sambiumulongele munhu yoyose, ila genda dimwe kwa dimwe ha mkulu wa nhambiko yakulole goya, abaho, ukalave nhosa kamba Musa vayalagize, giladi iwe usindila mwa wanhu wose kamba kuhona.” ");
INSERT INTO zaj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ila mbuli za Yesu zibanza kwenela muisi yose, wanhu bwando weza kumtegeleza na kuhonyigwa vitamu vao. ");
INSERT INTO zaj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ila Yesu mianza bwando kakala yonyelenhuka yochola hanhu halibule wanhu kutambika. ");
INSERT INTO zaj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Zua dimwe Yesu kakala yofundiza. Mafalisayo na wafundiza Malagizo ga Musa, walawile m'viwambo vose va Galilaya, Yudea na kulawa Yelusalemu, wakala baho. Mhiko za Mndewa zikala na heyo, avo kawahonya watamu. ");
INSERT INTO zaj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Baho weza wanhu wampapile munhu yaholole mulusazi, wageza kumwingiza mng'anda wamwike haulongozi wa Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Avija wanhu viwakalile wamemile hawadahile kumwingiza mng'anda. Avo wampapa, wamgala uchana mkiswili, wafumula usoti, wamuhumulusa hamoja na lusazi lwake, na kumwika hagatigati ya ididale da wanhu haulongozi wa Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu viyonile avija viwakalile na nhamanila ng'hulu, kamulongela ija imunhu, “Mbwiga, vilozo vako vigeligwa kumgongo.” ");
INSERT INTO zaj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wafundiza Malagizo ga Musa na Mafalisayo wasonga kukiiuza, “Iyo yalihi yofukula? Mulungu yeiyeka yodaha kugela kumgongo vilozo va wanhu!” ");
INSERT INTO zaj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ila Yesu kazitanga ngelegeza zao, kawauza, “Habali mgelegeza mbuli kamba azo? ");
INSERT INTO zaj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Dilihi dibuhile ng'hani, kulonga, ‘Vilozo vako vigeligwa kumgongo,’ ama kulonga, ‘Ima wima utembele’? ");
INSERT INTO zaj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nolonda m'vitange kamba, nie, Mwana wa Munhu, nna udaho wa kuvigela kumgongo vilozo va wanhu muisi.” Abaho kamulongela ija imunhu yaholole, “Ima wima, papa lusazi lwako, uchole ukae yako.” ");
INSERT INTO zaj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Baho ija imunhu kema wima hameso gao wose, kasola lusazi lwake lwayakalile yaluwasile, kachola ukae yake kuno yomuyenzi Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Wanhu wose wakanganya, kuno wona bwembwe, wamuyenzi Mulungu, wolonga, “Lelo tona mbuli za mkanganyo!” ");
INSERT INTO zaj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Viyeshile kutenda higo, Yesu kalawa hanze, kamona muwila kodi imwe yokemigwa Lawi, yakalile muna ing'anda yake ya kulihila kodi. Yesu kamulongela, “Ng'holeleza.” ");
INSERT INTO zaj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Na heyo kenuka, kaleka gose, kamkoleleza. ");
INSERT INTO zaj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Abaho, Lawi kamtendela lusona lukulu ng'hani Yesu mng'anda yake, na dale kulu da wawila kodi na wanhu wayagwe wakala woja na heyo. ");
INSERT INTO zaj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mafalisayo na wafundiza Malagizo ga Musa wakalile mdidale jao wawatwanganikila wanahina wa Yesu, wouza, “Habali moja na kung'wa na wawila kodi na watenda vilozo wayagwe?” ");
INSERT INTO zaj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu kedika kalonga, “Wanhu wagima hawamulonda mganga, ila waja wali watamu wawo womulonda. ");
INSERT INTO zaj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sizile kuwakema wanhu walibule vilozo, ila wanhu wali na vilozo waleke vilozo vao.” ");
INSERT INTO zaj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wanhu wamulongela Yesu, “Wanahina wa Yohana M'batiza wofunga mianza bwando na kutambika, na wanahina wa Mafalisayo wotenda vivo. Ila wanahina zako woja na kung'wa.” ");
INSERT INTO zaj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu kawalongela, “Mokwagiza modaha kuwatenda wambwiga za mulawilamhambe wafunge kipigiti mulawilamhambe yang'hali hamoja nawo? ");
INSERT INTO zaj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ila kipigiti chovika avija mulawilamhambe vondayasegezigwe hamwao, aho baho vondawafunge.” ");
INSERT INTO zaj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Vivija Yesu kawalongela hala dino. “Haduhu munhu yokanha kidanga cha kivalo cha sambi na kukigela mkivalo cha mwaka. Kamba yahatenda avo, kokidega ikivalo cha sambi, na acho ikidanga cha ikivalo cha sambi hakilumba mkivalo cha mwaka. ");
INSERT INTO zaj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Vivija wanhu hawagela divai ya sambi muna vibuyu va umwaka vitendigwe na kwembe, kwavija ija idivai ya sambi yovitula ivibuyu vitendigwe na kwembe, avo idivai yokwitika na vibuyu vitendigwe na kwembe vobanangika. ");
INSERT INTO zaj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Vilumbaga, divai ya sambi igeligwe muna vibuyu va sambi vitendigwe na kwembe. ");
INSERT INTO zaj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na haduhu munhu yolondaga divai ya sambi kuno yeshile kung'wa divai ya mwaka, mana kolonga, ‘Ya mwaka ibanza kunoga.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yesu kakala yotembela muna imigunda ya ngano Mdizua dimwe da Mhumulo. Wanahina zake wasonga kufyola zisota za gamakungwi ga ngano, wagafigisa mmakono gao, ikwisha waja zinzele. ");
INSERT INTO zaj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mafalisayo wayagwe wamuuza, “Habali motenda gagomeswe kutendigwa Mdizua da Mhumulo?” ");
INSERT INTO zaj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu kawedika kawalongela, “Hamsomile kija chayatendile Daudi kipigiti heyo na wayage viwakalile na nzala? ");
INSERT INTO zaj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kengila mdihema da Mulungu, kaija imikate ilavigwe nhosa ha Mulungu, na iyagwe kawagwelela wayage. Vinhu vikalile vigomeswe Mmalagizo getu kudigwa na munhu yoyose ila wakulu wa nhambiko weiyeka.” ");
INSERT INTO zaj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu kamambukiza mkulonga, “Nie, Mwana wa Munhu, nene Mndewa wa Zua da Mhumulo.” ");
INSERT INTO zaj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Zua diyagwe da Mhumulo Yesu kengila mng'anda ya nhambiko na kufundiza. Kukala na munhu yaholole mkono wake wa ukulume. ");
INSERT INTO zaj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mafalisayo na wafundiza Malagizo ga Musa wakala wozahila kilamso cha kumtagusila Yesu, avo wamulola ng'hani wone kamba kohonya Mdizua da Mhumulo. ");
INSERT INTO zaj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesu kazitanga ngelegeza zao avo kamulongela ija imunhu, “Ima wima, wize hano haulongozi.” Ija imunhu kema wima, abaho, kachola haulongozi. ");
INSERT INTO zaj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Abaho, Yesu kawalongela, “Nowauza, Malagizo getu golonga tutende choni Mdizua da Mhumulo? Tutende ganogile ama gehile? Kumuhonya munhu ama kumkoma?” ");
INSERT INTO zaj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kawalola wanhu wose, abaho, kamulongela ija imunhu, “Golosa mkono wako.” Na heyo kaugolosa, na mkono wake ubwela goya. ");
INSERT INTO zaj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wona lusango wasonga kuiuza vija vondawamtende Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Zua dimwe mkipigiti kija, Yesu kachola kukigongo kutambika, kagonelela yomtambikila Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Viivikile imitondo, kawakema wanahina zake na kawasagula longo dimwe na wabili, awo yawakemile watumigwa zake, ");
INSERT INTO zaj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni, yagweleligwe twaga da Petulo, na ndugu yake Endelea, na Yakobo na Yohana, na Filipo na Batolomayo, ");
INSERT INTO zaj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","na Matayo na Tomaso, na Yakobo mwanage Alufayo, na Simoni yakalile yokemigwa Mgombeleza Isi ya Islaeli, ");
INSERT INTO zaj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na Yuda mwanage Yakobo, na Yuda Isikalioti, yamuhonzile Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu viyahumuluke kulawa hakigongo na watumigwa zake, kema hanhu hatambalale na wanahina zake bwando. Na wanhu bwando weza kulawa isi yose ya Yudea na kulawa Yelusalemu na kulawa viwambo vose va mhwani ya Tilo na Sidoni. ");
INSERT INTO zaj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Weza kumtegeleza na kuhonyigwa vitamu vao. Waja wakalile wogazigwa na vinyamkela vivija na hewo weza na wahonyigwa. ");
INSERT INTO zaj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wanhu wose walonda kumkwasa kwavija mhiko za uhonya zikala zimulawa na kuwahonya wanhu wose. ");
INSERT INTO zaj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu kawalola wanahina zake na kulonga, “Mmota mweye iwakumbulu wa gamali, kwavija Undewa wa Mulungu uli wenu! ");
INSERT INTO zaj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mmota mweye muli nzala sambi, kwavija kwiza mokwiguta! Mmota mweye mulila sambi, kwavija kwiza moseka! ");
INSERT INTO zaj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mmota mweye avija wanhu wahawehila, na kuwalema, na kuwaliga, na kuwabanangila matwaga genu sama ya nie, Mwana wa Munhu! ");
INSERT INTO zaj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Deng'heni mmazua higo na zumheni mkudeng'ha kwavija maliho genu makulu mwikiligwa kuulanga. Kwavija wahenga zao wawatendela wahokozi gano gowotenda. ");
INSERT INTO zaj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ila mojona mweye muli wagoli sambi, kwavija mwisha kubokela uhondo wenu. ");
INSERT INTO zaj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mojona mweye mwigute sambi, kwavija mochola na nzala. Mojona mweye mseka sambi, kwavija mokwiza kuiyalala na kulila. ");
INSERT INTO zaj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mojona, avija wanhu wose vondawawatogole, kwavija wahenga zao wakala wowatogola kamba avo wahokozi wa uvwizi. ");
INSERT INTO zaj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ila nowalongeleni mweye munitegeleza, wanogeleni wadumuka zenu, watendeleni ganogile awo wawehile. ");
INSERT INTO zaj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wamotezeni awo wowadukumiza, na watambikileni awo wowatendela gehile. ");
INSERT INTO zaj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Munhu yahakutoa mkanza dimwe, muhindusile na diyagwe, na munhu yahakuboka koti jako, muleke yasole na kanzu yako. ");
INSERT INTO zaj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Munhu yoyose yondayakupule kinhu mgwelele, na munhu yahasola kinhu chako, sambiumulongele yakubwezele. ");
INSERT INTO zaj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Watendeleni wanhu kamba vija vumulonda wanhu wawatendele mweye. ");
INSERT INTO zaj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kamba muhawanogela wanhu wowanogela mweye, maliho galihi gondam'bokele? Kwavija hata wali na vilozo na hewo wowanogela awo wawanogele! ");
INSERT INTO zaj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Muhawatendela ganogile awo wowatendela mweye ganogile, maliho galihi gondam'bokele? Kwavija wali na vilozo nawo wotenda vivo. ");
INSERT INTO zaj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Avo muhawakalizi mali genu ha awo mtamanila wodaha kuliha, maliho galihi gondam'bokele? Kwavija wali na vilozo wowakalizi wali na vilozo wayao wabwezeligwe kikija chawakalizigwe. ");
INSERT INTO zaj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Viha! Ila wanogeleni wadumuka zenu na watendeleni ganogile, wakalizini wanhu mali genu, sambimtamanile kubwezelwa na kinhu. Avo kwiza mogweleligwa maliho makulu, avo mowa wana wa Mulungu Mkulu Ng'hani, kwavija heyo kotenda ganogile mwa wanhu wabezi na wotenda gehile. ");
INSERT INTO zaj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Muwe na bazi kamba Tata wenu viyali na bazi. ");
INSERT INTO zaj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Sambimuwataguse wayagwe, na Mulungu hawatagusa mweye. Sambimuwadununze wayagwe, na Mulungu hawadununza mweye. Geleni kumgongo vilozo va wanhu wayagwe, na Mulungu kovigela kumgongo vilozo venu. ");
INSERT INTO zaj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wagweleleni wanhu vinhu, na Mulungu kowagwelela mweye. Mhima imemile, isindiligwe na kutigiswa na kwitika iyo yondamgweleligwe m'vipepelo venu. Kwavija mhima yondamuwapimile wayagwe iyo mhima yondampimilwe mweye.” ");
INSERT INTO zaj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Avo Yesu kawalongela hala dino, “Kimbugumbugu hadaha kumulongoza kimbugumbugu miyage, kamba yahatenda avo, wose wabili wogwila mdikolongo. ");
INSERT INTO zaj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mwanahina hamuhuma mkulufunzi wake, ila mwanahina yeheshiliza kufundizigwa kowa kamba mkulufunzi wake. ");
INSERT INTO zaj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Habali ukilola kikupi msiso da ndugu yako, na huchona kibanzi kili msiso jako mwenyego? ");
INSERT INTO zaj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kodahaze kumulongela ndugu yako, ‘Ndugu yangu, beta nikilave kikupi mdisiso jako,’ kuno hudaha hata kuchona kibanzi kili msiso jako mwenyego? Kidelenya gweye! Tanhu kilave ikibanzi kili msiso jako mwenyego, abaho, kodaha kulola goya kukilava kikupi kili mdisiso da ndugu yako. ");
INSERT INTO zaj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“M'biki unogile haulela mujo wihile, vivija m'biki wihile haulela mujo unogile. ");
INSERT INTO zaj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kila m'biki wotambulwa sama ya mujo wake uulela. Hudaha kubawa tini muna imizomola, ama zabibu muna zimbigili. ");
INSERT INTO zaj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Munhu yanogile kolava ganogile kulawa mngama ya vinhu vinogile vili mmoyo wake. Munhu yehile kolava gehile kulawa mngama ya vinhu vihile. Kwavija mulomo wolonga kimemile mmoyo. ");
INSERT INTO zaj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Habali mong'hema, ‘Mndewa, Mndewa,’ abaho, hamtenda gaja ganiwalongela? ");
INSERT INTO zaj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kila munhu yokwiza kumwangu na kutegeleza mbuli zangu na kuzitogola, nowalagusila kilihi kilingile na heyo. ");
INSERT INTO zaj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kalinga na munhu yozenga ng'anda, kahimba lukwambaza hasi ng'hani mbaka kavika dibwe, avo kazenga msingi mdibwe. Lwanda lutula na kugeza kuikulula ng'anda ija, ila haludahile kuitigisa kwavija izengigwa goya. ");
INSERT INTO zaj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ila munhu yoyose yohulika mbuli zangu na kuzileka baho, ayo kalinga na munhu yazengile ng'anda yake bila kuhimba ng'hani lukwambaza na kwika msingi. Mkipigiti kidodo lwanda lutula na kuikulula ng'anda ija, igwa mkipigiti kiguhi. Na igwa yake ikala ihile ng'hani.” ");
INSERT INTO zaj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu viyeshile kulonga mbuli zino zose mwa wanhu, kachola kukiwambo cha Kapenaumu. ");
INSERT INTO zaj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mkulu wa asikali mia wa Loma kakala na nyakadala yakalile yamnogele ng'hani, ija inyakadala kakala mtamu ng'hani behi na kudanganhika. ");
INSERT INTO zaj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ija imkulu wa iwaasikali mia wa Loma viyahulike singilimo za Yesu, kawatuma wakulu wa Wayahudi wakamulongele yeze yamuhonye nyakadala wake. ");
INSERT INTO zaj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Viwavikile ha Yesu, wamuyalalila, wolonga, “Munhu ino kalumba kutendeligwa mbuli ino, ");
INSERT INTO zaj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kwavija kawanogela wanhu zetu, na heyo iyo yatuzengele ng'anda yetu ya nhambiko.” ");
INSERT INTO zaj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Avo Yesu kachola na hewo, viwavikile behi na ing'anda, ija imkulu wa iwaasikali mia wa Loma kawalagiza wambwiga zake wamulongele Yesu vino, “Mndewa, sambiugaye, nie silumbile gweye wize wingile mng'anda yangu, ");
INSERT INTO zaj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","kileka nivigesile kamba silumbile kwiza hamwako nene mwenyego, ila longa mbuli! Na nyakadala wangu kohona. ");
INSERT INTO zaj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nie vivija na munhu nikigwe hasi ya udaho wa wakulu zangu wa uchana yangu, na nna asikali hasi yangu. Nihamulongela ino, ‘Genda!’ kochola, nihamulongela ija, ‘Izo!’ kokwiza, na nihamulongela nyakadala wangu, ‘Tenda vino!’ kotenda.” ");
INSERT INTO zaj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu viyahulike gano, kamkanganya munhu ija, kahinduka kuchugu na kudilongela dale da wanhu dikalile dimsondolela, “Nowalongela, sinakona nhamanila ng'hulu kamba ino, hata mwa wanhu wa Islaeli!” ");
INSERT INTO zaj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Waja watumigwe wabwela kung'anda ya ija imkulu, wam'vika nyakadala wake kahona. ");
INSERT INTO zaj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mkipigiti kiguhi Yesu kachola hakiwambo kikemigwa Naini, kailongoza na wanahina zake na dale kulu da wanhu. ");
INSERT INTO zaj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Viwavikile halwivi lwa ikiwambo, wanhu wakalile wapapile munhu yadanganhike wakala wolawa hanze ya ikiwambo. Mmhale yakalile yaleligwe yeiyeka na mtwanzi imwe yakalile kizuka, na dale kulu da wanhu kulawa mkiwambo dikala hamoja na ija imtwanzi. ");
INSERT INTO zaj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mndewa Yesu viyamuwene, kamonela bazi, kamulongela, “Sambiulile.” ");
INSERT INTO zaj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Abaho, kachola haulongozi na kulukwasa ulusazi, avo wanhu waupapile wema. Yesu kalonga, “Mmhale, nokulongela, lamuka!” ");
INSERT INTO zaj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ija immhale yadanganhike kenuka, kakala ukala, kasonga kulonga. Yesu kamgwelela mamaake. ");
INSERT INTO zaj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Wanhu wose wona bwembwe wamuyenzi Mulungu, walonga, “Muhokozi mkulu koneka hamwetu, Mulungu keza kuwakombola wanhu zake.” ");
INSERT INTO zaj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mbuli zino za Yesu zenela muisi yose ya Yudea na isi za mmambwegambwega. ");
INSERT INTO zaj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wanahina wa Yohana viwamulongele mbuli zino zose, kawakema wabili mmwanza wao, ");
INSERT INTO zaj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na kuwalagiza wachole ha Mndewa wakamuuze vino, “Yohana kalonga, gweye iyo mkombola yondayeze? Ama tumtamanile iyagwe?” ");
INSERT INTO zaj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wanhu waja viwavikile ha Yesu, walonga, “Yohana M'batiza katulagiza yolonga tukuuze, ‘Gweye iyo yondayeze, ama tumtamanile iyagwe?’ ” ");
INSERT INTO zaj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kipigiti kikija Yesu kawahonya wanhu bwando wakalile na vitamu na utamu, na awo wakalile na vinyamkela, na kuwatenda vimbugumbugu bwando wadahe kulola. ");
INSERT INTO zaj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kawalongela waja wasenga wa Yohana, “Gendeni mkamulongele Yohana gaja gamonile na kugahulika, vimbugumbugu wolola, mbetembete wotembela, wali na dikulu wohonyigwa, vinziwi wohulika, wadanganhike wowa wagima kabili, na Usenga Unogile wopetigwa mwa wakumbulu. ");
INSERT INTO zaj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wamota wanhu awo walibule ving'hwaso na sang'hano zangu.” ");
INSERT INTO zaj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wasenga wa Yohana viwacholile, Yesu kasonga kumulonga Yohana haulongozi wa dale da wanhu, yolonga, “Vumcholile ha Yohana kuluwala, mtamanila kona choni? Ludete lutigiswa na beho? ");
INSERT INTO zaj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mchola kulola choni? Munhu yavalile vivalo vinogile ng'hani? Wanhu wovala kamba avo na kukala vinogile wa mming'anda ya kindewa! ");
INSERT INTO zaj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nongeleni, mchola kulola choni? Muhokozi? Ona, ila nowalongela, yummonile kana ukulu kubanza muhokozi. ");
INSERT INTO zaj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yohana iyo munhu Nyandiko Zing'alile zimulonga, ‘Mulungu kalonga, nomulagiza msenga wangu yakulongole, yondayaitande nzila yako.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu kongeza kulonga “Nowalongela, wanhu wose waleligwe na watwanzi, haduhu yali mkulu kum'banza Yohana. Ila yali mdodo ng'hani muna Uundewa wa Mulungu iyo mkulu kum'banza Yohana.” ");
INSERT INTO zaj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wanhu wose, hata wawila kodi, viwazihulike mbuli za Yesu, watogola kamba nzila ya Mulungu igoloka, kwavija wakala wabatizigwe na Yohana. ");
INSERT INTO zaj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ila Mafalisayo na wafundiza Malagizo ga Musa wagalema gaja gayalondile kutenda Mulungu kumwao kwavija walema kubatizigwa na Yohana. ");
INSERT INTO zaj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu kagendelela kulonga, “Vino niwalinganyize na choni wanhu wa mazua gano? Walinga na wanhu walihi? ");
INSERT INTO zaj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Walinga na wana wakalile hadibugano da soko. Dale dimwe dowalongela dale diyagwe, ‘Tuwatoela ngoma ya lusona lwa zengele, ila mweye ham'vinile! Twimba vawembaga hauzisi, ila mweye hamulilile!’ ");
INSERT INTO zaj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohana M'batiza keza kafunga na hang'wile divai, na mulonga, ‘Kana kinyamkela!’ ");
INSERT INTO zaj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nie, Mwana wa Munhu, niza, noja na kung'wa, mulonga, ‘Loleni munhu ino, mmelo na mng'waji, mbwiga wa wawila kodi na wene vilozo wayagwe!’ ");
INSERT INTO zaj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kwa vovose vija ng'hungwe ya Mulungu yonekaga mmeso ga awo wose waitogole.” ");
INSERT INTO zaj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfalisayo imwe kamulonda Yesu yeze kuja na heyo mandia ga ikilo, avo Yesu kachola hang'anda ya ija Mfalisayo, kakala hasi yaje. ");
INSERT INTO zaj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mkiwambo kija kukala na mtwanzi imwe yakalile yotenda vilozo mazua gose. Kahulika Yesu kakala yoja mng'anda ya Mfalisayo, avo kagala nyhupa ya alabasta ikalile na mavuta ga kunung'hila. ");
INSERT INTO zaj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kema hachugu cha Yesu, behi na magulu gake, yolila na kumdodeza magulu gake na mahozi gake. Abaho, kamuhangusa magulu gake na mvili zake, kaganonela na kugetila mavuta ga kunung'hila. ");
INSERT INTO zaj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ija Imfalisayo yamgoneke viyonile gaja, kalonga munda kwa munda, “Kamba munhu ino yahawile muhokozi, yahamtangile mtwanzi ino yomkwasa yali munhu wa vilihi, yahavitangile vija voyokala ukazi wa vilozo.” ");
INSERT INTO zaj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu kamulongela ija Imfalisayo, “Simoni, nna mbuli nolonda kukulongela.” Kalonga “Ona, mkulufunzi, nongela.” ");
INSERT INTO zaj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu kasonga kulonga, “Kukala na wanhu wabili wowilwa hela na mkalizi hela imwe. Imwe kakala yowilwa hela zilinganye maliho ga milenge longo dimwe, na iyagwe kakala yowilwa hela zilinganye maliho ga mulenge umwe. ");
INSERT INTO zaj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wose wabili hawadahile kuliha, avo kawagela kumgongo wose wabili. Vino yalihi hana iwanhu wano wabili yondayamnogele heyo ng'hani?” ");
INSERT INTO zaj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni kamulongela, “Nokona ija imunhu yageligwe kumgongo hela bwando.” Yesu kalonga, “Kulonga goya.” ");
INSERT INTO zaj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Abaho, kamuhindukila ija imtwanzi, kamulongela Simoni, “Komona mtwanzi ino? Ningila mng'anda yako, hungwelele mazi ngele magulu gangu, ila heyo kagadodeza magulu gangu na mahozi gake na kugahangusa na mvili zake. ");
INSERT INTO zaj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Hunibokele mkuninonela, ila mtwanzi ino songela hanizile halekile kuganonela magulu gangu. ");
INSERT INTO zaj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gweye hunibakile mavuta mpala jangu, ila mtwanzi ino kagetila mavuta ga kunung'hila magulu gangu. ");
INSERT INTO zaj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Avo nokulongela, noge kulu diyalaguse mtwanzi ino dolagusa avija vilozo vake bwando vuvigeligwe kumgongo. Ila munhu yoyose yageligwe kumgongo hadodo kolagusa noge dodo.” ");
INSERT INTO zaj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Abaho, Yesu kamulongela ija mtwanzi, “Vilozo vako vigeligwa kumgongo.” ");
INSERT INTO zaj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wanhu wayagwe wakalile hameza wasonga kulonga hasihasi, “Iyo yalihi munhu ino, yogela kumgongo hata vilozo?” ");
INSERT INTO zaj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ila Yesu kamulongela ija imtwanzi, “Nhamanila yako ikukombola, genda mditindiwalo.” ");
INSERT INTO zaj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kipigiti kiguhi hamwande, Yesu kagendelela kuupeta Usenga Unogile wa Undewa wa Mulungu mmiwambo na m'viwambo. Wanahina zake longo dimwe na wabili wachola hamoja na heyo, ");
INSERT INTO zaj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","hamoja na watwanzi wakalile wahonyigwe vinyamkela na vitamu viyagwe, Maliamu yakalile yokemigwa munhu wa Magidala ayo wamulavile vinyamkela saba, ");
INSERT INTO zaj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoana, mwehe wa Kuza yakalile mkulu wa ng'anda ya Helode Antipa, Suzana, na watwanzi wayagwe bwando wasolile vinhu vao na kumgwaa Yesu na wanahina zake. ");
INSERT INTO zaj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wanhu wakala wogendelela kwiza ha Yesu kulawa m'viwambo vose, na viwamemile, Yesu kawalongela hala dino. ");
INSERT INTO zaj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mulimi kachola kuhanda mbeyu. Viyakalile yozihanda, ziyagwe zilagalila mnzila, wanhu wazibojaga na ndege weza wazija. ");
INSERT INTO zaj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ziyagwe zigwila muisi ili na mabwe, avo viisongile kukula inyala, kwavija kukala haduhu mnyefu muisi. ");
INSERT INTO zaj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ziyagwe zigwila mmizomola, imizomola ikula hamoja na umche na kuuzingiliza. ");
INSERT INTO zaj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na mbeyu ziyagwe zigwila haulongo unogile, zikula na zilela masuke gali na nzele mia kila dimwe.” Yesu kamambukiza mkwinula dizwi, yolonga, “Yali na magwiti na yahulike.” ");
INSERT INTO zaj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wanahina zake wamuuza Yesu nhegulo ya hala dino. ");
INSERT INTO zaj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Na heyo kawalongela, “Mweye mgweleligwa mhome ya kuzitanga nyong'onyo za Undewa wa Mulungu, ila wayagwe wolongelwa muna gamahala, giladi walole ila sambiwone, na wategeleze ila sambiwahulike.” ");
INSERT INTO zaj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ino iyo nhegulo ya hala dino. Zimbeyu zizo mbuli ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mbeyu zigwile mnzila zizo wanhu wahulike imbuli ya Mulungu, abaho, Mwenembago keza kaisegeza kulawa mmioyo yao, giladi sambiwaitogole, abaho, wakomboligwe. ");
INSERT INTO zaj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mbeyu zigwile muisi ili na mabwe zizo wanhu wahulike mbuli ya Mulungu na kuibokela mkudeng'ha. Ila hawakalile na mizizi, woitogola mkipigiti kiguhi, wahabitilwa na kipigiti kidala, wobweleganya kuchugu. ");
INSERT INTO zaj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mbeyu zigwile mmizomola zizo wanhu wahulike mbuli ya Mulungu, ila viwakalile wogendelela kuitogola, mholemhole wazingilizwa na bwembwe da ugima, usu da kuwa na mali bwando, na usu da kuwa na vinhu vinogile, avo mujo wao hawipa. ");
INSERT INTO zaj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mbeyu zija zigwile haulongo unogile zizo wanhu wahulike mbuli ya Mulungu waika mmioyo, avo waitogola, wazaganya, hakimambukizo walela mujo unogile. ");
INSERT INTO zaj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Haduhu munhu yobwinha kiwenge, abaho, yakigubike na kiteleko ama yakike haluvungu. Ila kokika uchana hakingolobweda avo wanhu wehengila mng'anda wone mulangaza. ");
INSERT INTO zaj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Kwavija haduhu kinhu chochose kifisigwe chondakileke kuvumbulwa na kwikigwa hakimwagaia, na haduhu kinhu chochose kigubikwe chondakileke kugubulwa na kwikigwa hamulangaza. ");
INSERT INTO zaj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Avo teganyeni vija vumtegeleza, kwavija awo wali na kinhu wogweleligwa na viyagwe, ila awo walibule kinhu, na vidodo vija vowogesa wanavo wobokonywa.” ");
INSERT INTO zaj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mamaake Yesu na wandugu zake wamwizila, ila hawadahile kumkwenhukila avija wanhu viwakalile bwando. ");
INSERT INTO zaj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Munhu imwe kamulongela, “Mamaako na wandugu zako wahanze wonda wakone.” ");
INSERT INTO zaj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ila Yesu kawalongela, “Mamaangu na ndugu zangu iwo wano wotegeleza mbuli ya Mulungu na kuitenda.” ");
INSERT INTO zaj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Zua dimwe Yesu kawalongela wanahina zake, “Natuloke mwambu wa ikabili wa idilamba.” Avo wengila mngalawa wasonga kuloka. ");
INSERT INTO zaj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Viwakalile woloka, Yesu kawasa utulo. Wedukila kukuzumbi dikwiza mdilamba, na ingalawa isonga kumema mazi, avo wose wakala mmwangalo. ");
INSERT INTO zaj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wanahina wachola ha Yesu wamulamusa, wolonga, “Mndewa, Mndewa! Todanganhika!” Yesu kalamuka kadikomhokela dikukuzumbi na umnyukwamnyukwa wa igamazi, vose vihola, hakala hapozike. ");
INSERT INTO zaj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Abaho, kawalongela wanahina zake, “Nhamanila yenu ili kwahi?” Wakanganya ng'hani, kuno wona bwembwe, wakiilongela, “Ino munhu waki? Kodikomhokela beho na igamawimbi, na vose vomtegeleza!” ");
INSERT INTO zaj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu na wanahina zake wagendelela kuloka, wavika mhwani ya isi ya Gelasi ili mwambu wa ikabili wa Idilamba da Galilaya. ");
INSERT INTO zaj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu viyahumuluke muingalawa, munhu imwe wa kiwambo kija yakalile na vinyamkela kamwizila. Mazua bwando munhu ija kakala yotembela bila mvaza na kakala hakala muna ing'anda, ila kakala yokala muna zimhango ziwazikilaga wanhu. ");
INSERT INTO zaj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Viyamuwene Yesu, kaguta lwangi, kafugama mavindi hamagulu ga Yesu, kenula dizwi yolonga, “Yesu, Mwana wa Mulungu Mkulu Ng'hani, konilonda choni? Nokuyalalila, sambiungaze!” ");
INSERT INTO zaj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kalonga vino kwavija Yesu kamkomhokela ikinyamkela yamulawe. Mianza bwando kakala yovagaligwa na ikinyamkela, hata kamba kakala yafungigwe makono na magulu na minyolo na kwimilizwa, ila kaikanha iminyolo na kakala yowingigwa na ikinyamkela muluwala. ");
INSERT INTO zaj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu kamuuza, “Twaga jako dijo dilihi?” Kedika kalonga, “Twaga jangu ‘Dale,’ ” kwavija kakala yavagaligwe na vinyamkela bwando. ");
INSERT INTO zaj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Vinyamkela wamuyalalila Yesu sambiyawagale mdikolongo dilibule nziga. ");
INSERT INTO zaj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kukala na dale kulu da mitumbi behi na hewo, wakala woja hakigongo. Avo vinyamkela wamuyalalila Yesu yawaleke wachole wakaingile ija imitumbi, Yesu kawaleka wachole kuiingila. ");
INSERT INTO zaj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Vinyamkela viwamulawile ija imunhu, waiingila ija imitumbi, na dale jose dihumuluka kubonde mdigema, dingila mdilamba na kufa mazi. ");
INSERT INTO zaj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wanhu wakalile woichunga imitumbi wagona gaja galawilile, avo wakimbila na wabwililisa mbuli zija mkiwambo na mmigunda. ");
INSERT INTO zaj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wanhu wachola kulola gaja galawilile, na viwavikile ha Yesu, wam'vika ija imunhu yalavigwe vinyamkela kakala hamagulu ga Yesu, kavala vivalo, yali na nzonzi zake. Wanhu wose wona bwembwe. ");
INSERT INTO zaj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Waja wagonile gaja wawalongela wanhu avija munhu ija vayahonyigwe. ");
INSERT INTO zaj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Abaho, wanhu wose wa isi ya Gelasi wamulongela Yesu yasegele hamwao, kwavija wadumba ng'hani. Avo kengila mngalawa kasegela. ");
INSERT INTO zaj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Munhu ija yalavigwe vinyamkela kamuyalalila Yesu yachole na heyo. Ila Yesu kamtuma, yolonga, ");
INSERT INTO zaj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bwela ukae yako ukapete gaja Mulungu gayakutendele.” Ija imunhu kabitabita kila hanhu mkiwambo, yolonga gaja Yesu gayamtendele. ");
INSERT INTO zaj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu viyabwelile mwambu wa ikabili wa idilamba, wanhu wam'bokela, kwavija wanhu wose wakala wom'beta. ");
INSERT INTO zaj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Abaho, keza munhu yokemigwa Yailo, kakala munhu mkulu muing'anda ya nhambiko. Kafugama mavindi haulongozi wa Yesu, kamuyalalila yachole kung'anda yake, ");
INSERT INTO zaj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kwavija mndele wake yavumbuke yeiyeka, yakalile wa ukulu wa milao longo dimwe na mibili, kakala mtamu, behi na kudanganhika. Yesu viyakalile mnzila, wanhu wammemela ng'ambu zose. ");
INSERT INTO zaj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mdidale dija da wanhu kukala na mtwanzi imwe yakalile na utamu wa kutumika mkipigiti cha milao longo dimwe na mibili, kasa vinhu vake vose ha mafundi, ila haduhu yadahile kumuhonya. ");
INSERT INTO zaj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kaibabanika mdidale da wanhu hachugu cha Yesu na kukwasa ulugigo lwa guo da Yesu, na bahaja kahona. ");
INSERT INTO zaj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu kauza, “Yalihi yang'hwasile?” Wanhu wose wabela, Petulo kalonga, “Mndewa, wanhu wamema woikunhizila kumwako.” ");
INSERT INTO zaj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ila Yesu kalonga, “Hana munhu kang'hwasa kwavija nokona mhiko zinilawa.” ");
INSERT INTO zaj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ija mtwanzi viyawene gayatendile gatangigwa, keza yogudema, kafugama mavindi haulongozi wa Yesu. Bahaja hameso ga wanhu wose, kamulongela kimtendile yamkwase na vija vayahonyigwe mkipigiti kiguhi. ");
INSERT INTO zaj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu kamulongela, “Mwanangu, nhamanila yako ikuhonya. Genda mditindiwalo.” ");
INSERT INTO zaj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu viyakalile yang'hali yolonga gano, keza munhu imwe kulawa kung'anda ya Yailo. Kamulongela Yailo, “Mndele wako kadanganhika, sambiumgaze Mkulufunzi.” ");
INSERT INTO zaj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu kahulika kamulongela Yailo, “Sambiudumbe, tamanila, na mndele wako kohona.” ");
INSERT INTO zaj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Viyavikile hang'anda ya Yailo, hamulondile munhu yoyose kwingila na heyo mng'anda, ila Petulo, Yohana, Yakobo, na tata na mama wa imndele. ");
INSERT INTO zaj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wanhu wose walila na kona giogio sama ya ija imndele, Yesu kawalongela, “Sambimulile, mwana mgima, kawasa tu!” ");
INSERT INTO zaj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wanhu wose wamseka, kwavija wavitanga kamba kakala yeshile kudanganhika. ");
INSERT INTO zaj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ila Yesu kamgoga mkono na kwinula dizwi yolonga, “Mwanangu, lamuka.” ");
INSERT INTO zaj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Loho yake ibwela, kipigiti kikija kalamuka, Yesu kalagiza wamgwelele kinhu yaje. ");
INSERT INTO zaj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tataake na mamaake wakanganya ng'hani, ila Yesu kawagong'ondeza sambiwamulongele munhu yoyose gaja galawilile. ");
INSERT INTO zaj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu kawakema watumigwa zake longo dimwe na wabili hamoja, kawagwelela mhiko na udaho wa kuwinga vinyamkela wose na kuhonya vitamu. ");
INSERT INTO zaj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Abaho, kawalagiza wachole kuupeta Undewa wa Mulungu na kuwahonya watamu. ");
INSERT INTO zaj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kawalongela, “Sambimsole kinhu chochose mmwanza wenu, fimbo ama mkoba ama mandia ama hela ama kanzu ya ikabili. ");
INSERT INTO zaj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ng'anda yoyose yondamwingile, kaleni baho mbaka vondamsegele hakiwambo hicho. ");
INSERT INTO zaj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Wanhu wahalema kuwabokela, segeleni hakiwambo kija, kung'unheni timbwisi dili mmagulu genu kamba usindila ulagusa hewo wenyego waulema Undewa wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Avo wasegela, wabita m'viwambo vose wopeta Usenga Unogile na kuhonya wanhu kila hanhu. ");
INSERT INTO zaj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Helode Antipa, mtawala wa Galilaya, kagahulika gose gakalile gotendeka. Avo kadungwadungwa ng'hani, kwavija wanhu wayagwe wakala wolonga, “Yohana M'batiza kazuka.” ");
INSERT INTO zaj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wayagwe walonga, “Eliya kalawilila,” na wayagwe walonga, “Imwe wa wahokozi wa umwaka kazuka.” ");
INSERT INTO zaj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Helode kalonga, “Yohana nimdumula pala jake, avo yalihi munhu ino inihulika mbuli zake?” Avo mazua gose kakala yozahila kumona Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Watumigwa wa Kilisto viwabwelile, wamulongela Yesu vinhu vose vawatendile. Kawasola, wasegela wachola kukiwambo kikemigwa Betisaida. ");
INSERT INTO zaj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Dale da wanhu diitanga mbuli ija, wamsondolela. Kawabokela, kawalongela mbuli za Undewa wa Mulungu, na kawahonya waja walondigwe kuhonyigwa. ");
INSERT INTO zaj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Zua vidisongile kuhonga, wanahina longo dimwe na wabili wamwizila wolonga, “Walongele wanhu wachole kuviwambo na kumigunda ili behi wakazahile mandia na uwaso, kwavija hano hatuli twa muluwala.” ");
INSERT INTO zaj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ila Yesu kawalongela, “Wagweleleni mweye wenyego kinhu cha kuja.” Wamulongela, “Vitulinavo tweye mikate mitano na somba wabili. Kolonda tuchole kuwagulila mandia wanhu wano wose?” ");
INSERT INTO zaj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Haja wakala wanhu wambigalo kamba alufu tano vino. Yesu kawalongela wanahina zake, “Walongeleni wanhu wakale hasi mmadale ga wanhu malongo matanomatano.” ");
INSERT INTO zaj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wanahina watenda vija, na wanhu wose wakala hasi. ");
INSERT INTO zaj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu kasola imikate mitano na iwasomba wabili, kalola uchana kuulanga, kamgwaa hewela Mulungu, kavimogola kawagwelela wanahina zake wawagolele iwanhu. ");
INSERT INTO zaj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Wanhu wose waja weguta, wanahina wadondola vidanga va vakuja visigale migelo longo dimwe na mibili. ");
INSERT INTO zaj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Zua dimwe Yesu kakala yotambika yeiyeka. Wanahina zake wakala hamoja na heyo, kawauza, “Wanhu wolonga nie iyo yalihi?” ");
INSERT INTO zaj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wamulongela, “Wayagwe wolonga gweye iyo Yohana M'batiza, wayagwe wolonga gweye iyo Eliya, na wayagwe wolonga gweye iyo imwe wa wahokozi wa umwaka kuzuka kabili.” ");
INSERT INTO zaj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesu kawauza, “Na mweye, molonga nie iyo yalihi?” Petulo kalonga, “Gweye iyo Kilisto Mkombola ulawile ha Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Abaho, Yesu kawazuma na kuwagomesa ng'hani sambiwamulongele munhu yoyose mbuli ino. ");
INSERT INTO zaj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Vivija kawalongela, “Nie, Mwana wa Munhu, nolondigwa nigaye ng'hani, na nilemigwe na wakulu hamoja na wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa. Nokomigwa, ila mdizua da ikadatu nozuka, nowa mgima kabili.” ");
INSERT INTO zaj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Avo kawalongela wanhu wose, “Kamba munhu yahalonda kuwa mwanahina wangu, yaibele mwenyego, yaidikwe msalaba wake mazua gose, yanikoleleze. ");
INSERT INTO zaj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Munhu yoyose yahalonda kuukombola ugima wake, kowagiza, na munhu yoyose yowagiza ugima wake sama yangu nie, koukombola. ");
INSERT INTO zaj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wanhu kamba wahapata vinhu vose va muisi na hewo wenyego wopotela ama wokwangama, kuna unozi waki? Nokona haduhu! ");
INSERT INTO zaj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kwavija munhu yoyose yahanyonela kinyala nie na mafundo gangu, nie, Mwana wa Munhu, nomonela kinyala heyo vondanize muyenzi yangu na muyenzi ya Tata na muyenzi ya wasenga wa Mulungu wang'alile wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nowalongeleni ikweli, hana wanhu wayagwe hano hawadanganhika mbaka wawone Undewa wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mazua manane songela hayalongile mbuli zija, Yesu kawasola Petulo, Yohana, na Yakobo wachola kukigongo kutambika. ");
INSERT INTO zaj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesu viyakalile yotambika, kihanga chake kigaluka, na vivalo vake vigaluka vizelu nang'hanang'ha. ");
INSERT INTO zaj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bahaja wanhu wabili wakala wolongelela na heyo. Wakala Musa na Eliya. ");
INSERT INTO zaj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Wakalile woneke muyenzi ya kuulanga na walongelela na Yesu avija ndagizi za Mulungu vondazivikile hima na vija vondayadanganhikile Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petulo na wayage wakala wawasile, ila viwalamuke, wayona yenzi ya Yesu na wanhu wabili wakalile wemile na heyo. ");
INSERT INTO zaj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Waja iwanhu wabili viwakalile wosonga kuchola, Petulo kamulongela Yesu, “Mndewa, vinoga tweye tukale hano, tuzenge vizewe vidatu, kimwe chako, kimwe cha Musa, na kimwe cha Eliya.” Kalonga avo kuno hakitangile choyolonga. ");
INSERT INTO zaj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petulo viyakalile hanamambukiza kulonga, wingu dilawilila diwagubika, wanahina zake wadumba ng'hani avija diwingu vidiwagubike. ");
INSERT INTO zaj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dihulikwa dizwi kulawa mdiwingu, dilonga, “Ino iyo Mwanangu inimsagule, mtegelezeni heyo!” ");
INSERT INTO zaj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Dizwi dija vudipozike, kasigala Yesu yeiyeka. Wanahina zake wanyamala tulu mmbuli zose zino na hawamulongele munhu yoyose mmazua gaja gose mbuli ziwonile. ");
INSERT INTO zaj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Imitondo iyagwe Yesu na waja wanahina zake wadatu wahumuluka hakigongo, na dale da wanhu dimwizila Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Munhu imwe kulawa muja mdidale da wanhu kenula dizwi yolonga, “Mkulufunzi, chonde, chonde, mulole mmhale wangu, iyo mwanangu yeiyeka! ");
INSERT INTO zaj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kinyamkela kam'vagalaga mkumsinhukiza na kumtenda yatoe nyangi chaka, komgela kisango baho holovu domulawa mmulomo, kogendelela kumulumiza, hamulekesa hima. ");
INSERT INTO zaj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Niwayalalila wanahina zako wamuwinge ikinyamkela, ila hawadahile.” ");
INSERT INTO zaj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu kawalongela, “Mweye wanhu mpotele, mulibule nhamanila, nokala na mweye mbaka zua jaki? Nowapapa mbaka kwahi?” Abaho, kamulongela ija imunhu, “Mgale hano mwanago.” ");
INSERT INTO zaj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ija mmhale vayakalile yomkwenhukila Yesu, kinyamkela kam'bwanha hasi na kumgela kisango. Yesu kamkomhokela ija kinyamkela, kamuhonya ija immhale, kam'bweza ha tataake. ");
INSERT INTO zaj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wanhu wose wakanganya mhiko ng'hulu za Mulungu. Wanhu vawakalile wogendelela kukanganya mbuli zose zayatendile Yesu, kawalongela wanahina zake, ");
INSERT INTO zaj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tegelezeni goya kinhu kinilonda kuwalongela! Nie, Mwana wa Munhu, nochola kugeligwa mmakono ga wanhu.” ");
INSERT INTO zaj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ila wanahina zake hawaitangile nhegulo ya mbuli ija. Mbuli ija ikala ifisigwe kumwao, avo hawaitangile nhegulo yake, na wadumba kumuuza. ");
INSERT INTO zaj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wanahina wa Yesu wasonga kuibamilila wolonga yalihi yondayawe mkulu kubanza wose. ");
INSERT INTO zaj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu kazitanga ngelegeza zao, avo kamsola mwana mdodo kamwika behi na heyo, ");
INSERT INTO zaj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","kawalongela, “Munhu yoyose yondayam'bokele mwana ino sama ya twaga jangu, konibokela nie, na munhu yoyose yondayanibokele nie, kom'bokela ayo yanhumile nie. Avo yali mdodo kubanza mweye mose iyo mkulu kubanza wose.” ");
INSERT INTO zaj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana kalonga, “Mndewa, tumona munhu yowinga vinyamkela mtwaga jako, tumgomesa, kwavija hali hamoja na tweye.” ");
INSERT INTO zaj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu kawalongela, “Sambimumgomese, kwavija munhu yoyose yoleka kuibamilila namwe, ka hamoja namwe.” ");
INSERT INTO zaj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kipigiti chake vikikwenhuke cha kusoligwa uchana kuulanga, Yesu kalamula yagoge nzila yachole Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kawagala wasenga wamulongole, avo wengila mkiwambo kimwe cha Samalia kumsasalila. ");
INSERT INTO zaj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ila wanhu wa haja hawam'bokele, kwavija kakala mnzila yochola Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wanahina zake wokemigwa Yakobo na Yohana viwawene vino, wamuuza, “Mndewa, kolonda tweye tuukeme moto uhumuluke kulawa kuulanga wize kuwalukuza kabisa?” ");
INSERT INTO zaj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu kawahindukila na kuwakomhokela yolonga, “Hamuimanyile loho imulinayo, kwavija nie, Mwana wa Munhu, sizile kubananga ugima wa wanhu, ila kuukombola.” ");
INSERT INTO zaj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Abaho, Yesu na wanahina zake wachola hakiwambo kiyagwe. ");
INSERT INTO zaj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Viwakalile wochola mnzila, munhu imwe kamulongela Yesu, “Nokusondolela kokose kondauchole.” ");
INSERT INTO zaj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu kamulongela, “Mbweha wana mhango, ndege wana mvulu, ila nie, Mwana wa Munhu, nabule hanhu ha kutambalika pala jangu.” ");
INSERT INTO zaj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu kamulongela munhu iyagwe, “Nisondolele.” Ija munhu kamwidika, “Mndewa, nileke tanhu nyhole hazike tataangu.” ");
INSERT INTO zaj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu kamulongela, “Waleke wanhu wadanganhike wazike wadanganhike wayao. Ila gweye genda ukaupete Undewa wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Munhu iyagwe kamulongela, “Mndewa, nokusondolela, ila tanhu beta nyhole nikalage wanhu wa hakae yangu.” ");
INSERT INTO zaj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ila Yesu kamwidika, “Munhu yoyose yosonga kulima, abaho, kolola kuchugu, halumba Muundewa wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Abaho, Mndewa kawasagula wanhu wayagwe malongo saba na wabili, kawatuma wabiliwabili, wamulongole wachole m'viwambo vose na kila hanhu hayalondile kuchola mwenyego. ");
INSERT INTO zaj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kawalongela, “Va kuhuna vimema, ila wahunaji wadodo. Avo mpuleni mwene mgunda yawagale wahunaji wahune vakuja vake. ");
INSERT INTO zaj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Gendeni! Nowalagiza mweye kamba wana ng'hondolo mdidale da mbwizi. ");
INSERT INTO zaj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sambimsole mkwiji ama mkoba ama ng'hwabasa, sambimmulamse munhu yoyose mnzila. ");
INSERT INTO zaj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Muhengila mng'anda yoyose, longeni, ‘Tindiwalo dingile mng'anda ino.’ ");
INSERT INTO zaj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kamba munhu yokala mng'anda ija yahawa mnogela tindiwalo, tindiwalo dosigala na heyo, na kamba sio, tindiwalo jenu dowabwelela. ");
INSERT INTO zaj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kaleni mng'anda hiyo muja na kung'wa chochose chondamgweleligwe, kwavija wasang'hana wolondigwa wagweleligwe kitumetume chao. Sambimuhamehame mulawa ng'anda ino mwingila ng'anda iyagwe. ");
INSERT INTO zaj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Muhengila mkiwambo chochose na wanhu wa kiwambo kija wahawabokela, dieni chochose chondawawagweleleni. ");
INSERT INTO zaj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wahonyeni watamu wa mkiwambo kija na muwalongele wanhu wa kiwambo kija, ‘Undewa wa Mulungu uwakwenhukila.’ ");
INSERT INTO zaj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ila muhengila mkiwambo, na wanhu wa kiwambo kija hawawabokele, laweni gendeni mnzila za mkiwambo kija mulonge, ");
INSERT INTO zaj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Timbwisi da kiwambo chenu dinanahile mmagulu getu todihangusa diwabwelele. Ila vimanyeni Undewa wa Mulungu uwakwenhukila.’ ");
INSERT INTO zaj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nowalongela, mdizua da inhaguso vobuha wanhu wa kiwambo cha Sodoma kwazaganya nhaguso yake kubanza wanhu wa kiwambo kija.” ");
INSERT INTO zaj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kojona, Kolazini! Kojona, Betisaida! Mizonza itendigwe kumwenu ihatendigwe Tilo na Sidoni, wanhu wa haja mwaka wahakalile hasi na kuvala magunia na kuitila mitozi kulagusa kamba waleka vilozo vao. ");
INSERT INTO zaj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mdizua da inhaguso, Mulungu kozonela bazi isi za Tilo na Sidoni kubanza mweye. ");
INSERT INTO zaj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na gweye, Kapenaumu! Kolonda kukiinula mwenyego uchana kuulanga? Kokwasigwa hasi kuzimu!” ");
INSERT INTO zaj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Abaho, Yesu kawalongela wanahina zake, “Munhu yoyose yahawategeleza mweye konitegeleza nie. Na munhu yoyose yahawalema mweye konilema nie. Na munhu yoyose yahanilema nie komulema ija yanhumile.” ");
INSERT INTO zaj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Waja iwanahina malongo saba na wabili wabwela wodeng'ha ng'hani, wolonga, “Mndewa, hata vinyamkela wotuhulika vituwakomhokele mditwaga jako!” ");
INSERT INTO zaj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu kawalongela, “Nimona Mwenembago yolagala kamba mwemwe kulawa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tegelezeni! Niwagweleleni udaho wa kuwabojaga nyoka na inge na kuzihuma mhiko zose za Mwenembago, na haduhu kinhu chochose chondakiwalumize. ");
INSERT INTO zaj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ila sambimdeng'he kwavija vinyamkela vowowafugamila mavindi, ila mdeng'he kwavija matwaga genu gandikwa kuulanga.” ");
INSERT INTO zaj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kipigiti kija Yesu kuno yamemile deng'ho da Loho wa Mulungu kalonga, “Nokuheweza, Tata, Mndewa wa kuulanga na muisi! Kwavija mbuli zino kuwafisa wabala na wasomile na kuwagubulila wana wadodo. Ona, Tata, vino vivo vikunogele.” ");
INSERT INTO zaj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Abaho, kalonga, “Tataangu kangwelela nie vinhu vose. Haduhu munhu yomtanga Mwana, ila Tata, na haduhu munhu yomtanga Tata, ila Mwana, na ayo Mwana yaasagule kumgubula Tata kumwake.” ");
INSERT INTO zaj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Abaho, Yesu kawahindukila wanahina zake na kuwalongela kinyele, “Muna mhome ng'hani mweye kuzona mbuli zino zimzona! ");
INSERT INTO zaj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nowalongeleni, wahokozi bwando na wandewa wasulukila kugona gano gomgona mweye, ila hawagonile, na wasulukila kugahulika gano gomuhulika mweye, ila hawagahulike.” ");
INSERT INTO zaj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Abaho, mfundiza Malagizo ga Musa kakwenhuka behi na Yesu, kageza kumwikila kitega, kamuuza, “Mkulufunzi, nhende choni kileka ningile muugima wa digunge?” ");
INSERT INTO zaj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu kamulongela, “Nyandiko Zing'alile zolongaze? Gweye kozisomaze?” ");
INSERT INTO zaj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ija imunhu kedika, “Mnogele Mndewa Mulungu wako na moyo wako wose, na loho yako yose, na mhiko zako zose, na nzonzi zako zose, na mnogele munhu wa habehi nagwe kamba vuukiinogela mwenyego.” ");
INSERT INTO zaj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu kamulongela, “Kulonga goya, tenda vino avo kokwingila muugima wa digunge.” ");
INSERT INTO zaj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ila ija imfundiza Malagizo ga Musa kalonda kuilagusa kamba kakimanya kija chayakalile youza, kamuuza Yesu, “Munhu wa habehi yangu iyo yalihi?” ");
INSERT INTO zaj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu kamulongela, “Munhu imwe kakala yohumuluka kulawa Yelusalemu kachola Yeliko, mibokonyi im'vamhila, im'bokonya vinhu vake vose, abaho, wamtoa ng'hani, wamuleka behi na kudanganhika. ");
INSERT INTO zaj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Baho kalawila mkulu wa nhambiko imwe kahumuluka mnzila ija, viyamuwene ija imunhu, kakuluguta, kagendelela na mwanza wake. ");
INSERT INTO zaj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Vivija mnzila ija kabita Mulawi, kamkwenhukila, kamulola, abaho, kakuluguta, kagendelela na mwanza wake. ");
INSERT INTO zaj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ila Msamalia yakalile yobita nzila ija kavika hayali munhu ija, viyamuwene, kamonela bazi. ");
INSERT INTO zaj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kamkwenhukila, kamgela mavuta na divai m'vilonda vake, na kumfungiliza ivilonda, abaho, kamkweleza mkihongwe wake kamgala kung'anda ya wahenza kumuguza. ");
INSERT INTO zaj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Imitondo iyagwe kalava vidanga vibili va hela, kamgwelela ija imwimilizi wa ing'anda ya wahenza. Kamulongela, ‘Muguze, nihabwela, nokuliha kinhu chochose chuulavile sama yake.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Baho Yesu kalonga, “Kokonaze, yalihi muwanhu wano wadatu yali munhu wa habehi wa munhu ija yavamhilwe na mibokonyi?” ");
INSERT INTO zaj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ija imfundiza Malagizo ga Musa kamwidika, “Ija yamonele bazi.” Yesu kalonga, “Genda ukatende kamba avo.” ");
INSERT INTO zaj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu na wanahina zake viwakalile wochola mnzila, wavika hakiwambo kimwe. Mtwanzi imwe yokemigwa Mata kam'bokela hakae yake. ");
INSERT INTO zaj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Kakala na lumbu jake yokemigwa Maliamu yakalile hamagulu ga Mndewa, yotegeleza gaja goyolonga. ");
INSERT INTO zaj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Avo Mata kakala yogaya na sang'hano zose, avo keza ha Yesu kamulongela, “Mndewa, huvona vino lumbu jangu voyonilekela nitende sang'hano zose nene niiyeka? Mulongele yeze kunitaza.” ");
INSERT INTO zaj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ila Mndewa kamwidika, yolonga, “Gweye Mata, gweye Mata! Kohunganika na kugaya m'vinhu bwando, ");
INSERT INTO zaj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ila kinhu kimwe kilondigwa. Maliamu kasagula kinhu hicho, na havidahika kusegezwa kumwake.” ");
INSERT INTO zaj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Zua dimwe Yesu kakala yotambika hanhu hamwe. Viyeshile kutambika, mwanahina wake imwe kamulongela, “Mndewa, tufundize kutambika kamba Yohana viyawafundize wanahina zake.” ");
INSERT INTO zaj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu kawalongela, “Muhatambika, longeni vino, ‘Tata, twaga jako diyenzigwe, undewa wako wize, ");
INSERT INTO zaj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","utugwelele mandia getu ga kila zua, ");
INSERT INTO zaj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ugele kumgongo vilozo vetu, kwavija na tweye towagela kumgongo awo wotutendela gehile, na sambiutugele mkugezigwa.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu kawalongela wanahina zake, “Tutende munhu imwe mmwanza wenu yachole hang'anda ya mbwigaake ikilo kikulu yolonga, ‘Mbwigaangu, ng'halizi mikate midatu, ");
INSERT INTO zaj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kwavija mbwigaangu ka mmwanza kabitila hang'anda yangu, na nabule mandia ga kumgwaa!’ ");
INSERT INTO zaj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na mbwigaako yakwidike yali mng'anda, ‘Sambiungaze! Lwivi luhindigwa lwisha, nie na wanangu twa mulusazi. Sidaha kwinuka nikugwelele kinhu chochose.’ ");
INSERT INTO zaj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nowalongela, hata kamba henuka yakugwelele umkate, kwavija gweye kwa mbwigaake, kokwinuka na kokugwelela kila kinhu kwavija hukonile kinyala kupula ubwelela. ");
INSERT INTO zaj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Avo nowalongeleni puleni, mogweleligwa. Zahileni, movumbula. Toeni hodi, movugulilwa. ");
INSERT INTO zaj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kwavija yoyose yopula kogweleligwa, na yoyose yozahila kovumbula, na yoyose yotoa hodi kovugulilwa. ");
INSERT INTO zaj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Vino hana tata yalihi kumwenu, mwanage yahampula somba yomgwaa nyoka? ");
INSERT INTO zaj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ama yahampula finga yomgwaa inge? ");
INSERT INTO zaj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ihawa mweye mtenda mbuli zihile, movitanga kuwagwelela wanenu vinhu vinogile, avo, Tata wenu wa kuulanga kabanza ng'hani kuwagwelela Loho wa Mulungu waja wose wompula!” ");
INSERT INTO zaj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu kakala yomuwinga kinyamkela yamtendile munhu yawe bubui, na ikinyamkela viyalawile, munhu ija kasonga kulonga, dale da wanhu dikanganya. ");
INSERT INTO zaj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ila wanhu wayagwe walonga, “Kowinga vinyamkela na udaho wa Belizebuli, mkulu wa vinyamkela.” ");
INSERT INTO zaj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wayagwe walonda kumwikila vitega Yesu, avo wamulonda yatende mzonza yoneke kamba udaho wake ulawa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ila Yesu kagatanga gaja gowokala wogelegeza, avo kawalongela, “Undewa wowose uhaigola wenyego kwa wenyego wopwililika, na kamba mulango uhaigola wenyego wogwa. ");
INSERT INTO zaj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kamba Mwenembago yahaigola mwenyego, undewa wake wokwimaze? Nolonga gano kwavija molonga kamba nowinga vinyamkela na udaho wa Belizebuli. ");
INSERT INTO zaj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kamba nie nowinga vinyamkela na udaho wa Belizebuli, wanenu wowinga vinyamkela na udaho ulihi? Avo wanenu wowa watagusa wenu. ");
INSERT INTO zaj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ila kamba nowinga vinyamkela na mhiko za Mulungu, togoleni kamba Undewa wa Mulungu uwavikila.” ");
INSERT INTO zaj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Munhu yali na mhiko, yehemiliza ng'anda yake na via vake va kuiimilizila, vinhu vake vose havibigwa. ");
INSERT INTO zaj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ila munhu yali na mhiko kubanza heyo yaham'vamhila na kumuhuma, kom'bokonya via vake vose va kuiimilizila voyokala yotamanila na kupwililisa vinhu vayebile. ");
INSERT INTO zaj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Munhu yoyose yalekile kuwa hamoja na nie, konibeza, na munhu yoyose yalekile kukunzanya na nie, kopwililisa. ");
INSERT INTO zaj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kinyamkela yahamulawa munhu, kochola hanhu halibule mazi yozahila hanhu ha kuhumula. Kamba honile hanhu, kokiilongela mwenyego, ‘Nobwela hang'anda yangu.’ ");
INSERT INTO zaj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Avo kobwela koivika ng'anda ifagiligwe na kuhambigwa. ");
INSERT INTO zaj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Abaho, kochola kuwasola vinyamkela wayagwe saba wehile kubanza heyo mwenyego, wokwiza na kumwingila. Avo hali ya munhu ija yokwiha ng'hani kubanza viyakalile haichanduso.” ");
INSERT INTO zaj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu viyalongile gano, mtwanzi imwe kenula dizwi kalonga, “Kamota ng'hani mtwanzi ija yakulelile na yakukong'heze.” ");
INSERT INTO zaj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesu kamulongela, “Wamota ng'haning'hani wanhu waja wotegeleza mbuli za Mulungu na kuzitogola.” ");
INSERT INTO zaj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wanhu viwammemele womzunguluka Yesu, kasonga kulonga, “Wanhu wa mulelo wihile wozahila kilaguso! Hawagweleligwa kilaguso, ila kilaguso cha Yona. ");
INSERT INTO zaj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kamba vija Yona viyakalile kilaguso cha wanhu wa Ninawi, avo nie, Mwana wa Munhu, nowa kilaguso cha wanhu wa mazua gano. ");
INSERT INTO zaj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Hana dizua da nhaguso Malikia wa Sheba kokwima na kuwatagusa wanhu wa mulelo uno, kwavija kachola mwanza mtali kulawa muisi yake keza kutegeleza mafundo gali na ng'hungwe ga Mndewa Selemani, avo nowalongeleni hano hana munhu mkulu kubanza Selemani. ");
INSERT INTO zaj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Hana idizua da nhaguso wanhu wa Ninawi vivija wokwima haja hamoja na mweye na wowatagusa mweye, kwavija viwahulike Yona yopeta mbuli za Mulungu, waleka vilozo vao, avo nowalongeleni hano hana munhu mkulu kubanza Yona! ");
INSERT INTO zaj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Haduhu munhu yobwinha kiwenge, abaho, yakifise ama yakigubike na kiteleko, ila kokika uchana hakingolobweda wanhu wehengila mng'anda wone mulangaza. ");
INSERT INTO zaj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kiwenge cha lukuli lwako meso gako. Kamba meso gako gahawa magima, lukuli lwako lose lowa na mulangaza, ila meso gako gahabanangika, lukuli lwako lose lowa mziza. ");
INSERT INTO zaj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Teganyeni, mulangaza uli mmwenu sambiuwe ziza. ");
INSERT INTO zaj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ihawa lukuli lwako lose luna mulangaza, bila kuleka hanhu mziza, avo lukuli lose lomulika, kamba vija kiwenge vikikumulikila na mulangaza wake.” ");
INSERT INTO zaj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu viyeshile kulonga, Mfalisayo imwe kamgoneka yachole kumwake yakaje hamoja na heyo, avo kachola, kengila mng'anda kakala hasi yaje. ");
INSERT INTO zaj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ija Imfalisayo kakanganya viyawene kamba Yesu hasonga kusungusa makono kipigiti yahalonda kuja mandia. ");
INSERT INTO zaj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Avo Mndewa kamulongela, “Mweye Mafalisayo mosungusa hanze ya ikikasi na ichano, ila mgati yenu mmema ubokonyi na wiho. ");
INSERT INTO zaj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Wabozi mweye! Avino si heyo Mulungu yatendile hanze vivija katenda na mgati? ");
INSERT INTO zaj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Avo wagweleleni wakumbulu vinhu vili mchano na mkikasi, avo kila kinhu chong'ala kumwenu. ");
INSERT INTO zaj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mojona Mafalisayo! Molava zaka ya matepo ga kulungila mandia na mboga ziyagwe, ila muleka kutenda ganogile mwa wanhu na kumnogela Mulungu. Molondigwa mtende gano tanhu, na sambimuleke gayagwe. ");
INSERT INTO zaj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mojona Mafalisayo! Kwavija molonda kukala m'vigoda va haulongozi muna izing'anda za nhambiko na kulamswa m'vigenge va wanhu. ");
INSERT INTO zaj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mojona! Kwavija mweye mwa kamba mapanga galibule viguzo wanhu wogabojaga bila kuvimanya.” ");
INSERT INTO zaj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mfundiza imwe wa Malagizo ga Musa kamulongela Yesu, “Mkulufunzi, uhalonga avo, kotuliga na tweye!” ");
INSERT INTO zaj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu kamulongela, “Vivija na mweye wafundiza Malagizo ga Musa, mojona! Kwavija mowadikwa wanhu mibahasha haidahika kupapika, kuno mweye wenyego hamgolosa hata kidole kuwataza. ");
INSERT INTO zaj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mojona! Kwavija mogazengela goya mapanga ga wahokozi, wawaja wakomigwe na wahenga zenu. ");
INSERT INTO zaj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Avo mwemwe wenyego motogola gaja gawatendile wahenga zenu. Wawakoma wahokozi, na mweye mogazengela mapanga gao. ");
INSERT INTO zaj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Avo sama ya mbuli ino, Ng'hungwe ya Mulungu ilonga, ‘Nowagalila wahokozi na watumigwa, wayagwe wowakoma na wayagwe wowagaza ng'hani.’ ");
INSERT INTO zaj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Avo wanhu wa mulelo uno wotaguswa sama ya wahokozi wose wakomigwe songela isi viilumbigwe, ");
INSERT INTO zaj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","songela kukomigwa kwa Abeli mbaka kukomigwa kwa Zakalia, yakomigwe hagatigati ya ikilingo cha kulavila nhosa na Hanhu Hang'alile. Ona, nowalongela, wanhu wa mulelo uno wotaguswa sama ya kuwakoma wanhu wano wose! ");
INSERT INTO zaj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mojona mweye wafundiza Malagizo ga Musa! Kwavija mkisola kivugulilo cha ulwivi lwa ilimu ya kuzimanyila mbuli, mweye wenyego hamwingila, na waja wolonda kwingila mowazuila!” ");
INSERT INTO zaj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu viyalawile muja, wafundiza Malagizo ga Musa na Mafalisayo wasonga kum'beza na lusango na kumuuza mbuli bwando, ");
INSERT INTO zaj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","wompelemba giladi kamba yahalonga gehile, wamnamate. ");
INSERT INTO zaj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wanhu bwando walibule mheta viwakiilundize hamoja, mbaka wakala wokiibojaga, tanhu Yesu kasonga kulonga na wanahina zake, “Iteganyeni na mela da Mafalisayo, nolonga udelenya wao. ");
INSERT INTO zaj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Haduhu kinhu chochose kigubikwe chondakileke kugubulwa, ama kifisigwe chondakileke kutangigwa. ");
INSERT INTO zaj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Avo mina, chochose chumulongile mziza, chohulikwa mmulangaza, na chochose chumnyong'onye mwiyeka mgati dihindigwe, chopetigwa mwa wanhu wose. ");
INSERT INTO zaj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nowalongeleni, mweye wambwiga zangu, sambimuwadumbe awo wokoma ulukuli, abaho, hawadaha kutenda kinhu chochose kiyagwe. ");
INSERT INTO zaj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ila nowalagusila wa kumdumba, mdumbeni Mulungu kwavija Mulungu yehesha kulukoma ulukuli, kana udaho wa kuwasa mweye kuzimu. Avo, nowalongeleni, ino iyo wa kumdumba! ");
INSERT INTO zaj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Vitongwa vitano haviuzigwa na hela ndodo? Ila haduhu hata kitongwa kimwe kiisemwigwa na Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ila mweye, hata mheta ya mvili za mmapala genu zitangigwa na Mulungu. Avo sambimdumbe, mweye mzama ng'hani kubanza vitongwa bwando! ");
INSERT INTO zaj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nowalongela, munhu yoyose yondayanitogole nie hameso ga wanhu kamba ka ng'ambu yangu, nie, Mwana wa Munhu, nomtogola munhu ija hameso ga wasenga wa Mulungu wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ila munhu yoyose yahanilema nie hameso ga wanhu, nie, Mwana wa Munhu, nomulema munhu ija hameso ga wasenga wa Mulungu wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Munhu yoyose yolonga mbuli za kunibeza nie, Mwana wa Munhu, vodahika kugeligwa kumgongo, ila munhu yoyose yahalonga mbuli za ufukuzi ha Loho wa Mulungu, havidahika kugeligwa kumgongo. ");
INSERT INTO zaj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Wahawagala mzing'anda za nhambiko ama ha wandewa ama ha wakulu kuwatagusa, sambimgelegeze avija vondamuigombeleze ama avija vondamulonge. ");
INSERT INTO zaj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kwavija Loho wa Mulungu kowafundiza kimulondigwa kulonga mkipigiti hicho.” ");
INSERT INTO zaj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Munhu imwe yakalile mdidale dija kamulongela Yesu, “Mkulufunzi, mulongele mkulu wangu yanigolele uhazi uyatulekele tata wetu.” ");
INSERT INTO zaj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu kamulongela, “Mbwigaangu, yalihi yangwelele nie sang'hano ya kulamula ama kuwagolela vinhu mweye wabili?” ");
INSERT INTO zaj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Abaho, kawalongela, “Teganyeni, inegeni na sulukila ya namna zose, kwavija ugima wa munhu hauli m'vinhu bwando vayalinavo.” ");
INSERT INTO zaj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Abaho, Yesu kawalongela hala dino, “Kukala na munhu imwe mgoli, yakalile na mgunda ugwisile vakuja bwando. ");
INSERT INTO zaj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kasonga kugelegeza munda kwa munda, yolonga, ‘Nabule hanhu ha kwika vakuja vangu. Nhendeze?’ ");
INSERT INTO zaj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Abaho, kalonga, ‘Nhende vino, nogabomola makano gangu, nizenge makano makulu, avo nokwika vakuja vangu na vinhu vangu vose visigale. ");
INSERT INTO zaj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Abaho, nokiilongela, “Gweye munhu mwene mhome! Kuna vinhu bwando vinogile vuwikile ngama ya milao bwando, avo uhumule, uje, ung'we, na udeng'he!” ’ ");
INSERT INTO zaj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ila Mulungu kamulongela, ‘M'bozi gweye! Ikilo ya lelo ugima wako wolondigwa, avo vinhu vino vose vuuilundikizile vowa va yalihi!’ ” ");
INSERT INTO zaj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu kamambukiza yolonga, “Vino vivo vondaiwe mwa munhu yoyose yokiilundikizila mwenyego vinhu, ila hameso ga Mulungu kabule kinhu.” ");
INSERT INTO zaj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Abaho, Yesu kawalongela wanahina zake, “Avo, nowalongela, sambimuigazile ugima wenu, muje choni, ama ng'huli zenu, m'vale choni. ");
INSERT INTO zaj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kwavija ugima uzama kubanza mandia, na lukuli luzama kubanza vivalo. ");
INSERT INTO zaj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Waloleni mabondwa, hawahanda mbeyu ama kuhuna vakuja, wabule makano gogose, ila Mulungu kowagwelela mandia! Mweye mzama ng'hani kubanza ndege. ");
INSERT INTO zaj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yalihi kumwenu mkuigaza ng'hani mmoyo, yodaha kongeza hata zua dimwe muugima wake? ");
INSERT INTO zaj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kamba hamdaha kutenda kinhu kidodo kamba kino, habali muigazila vinhu viyagwe? ");
INSERT INTO zaj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Loleni malua ga mmuhulo vigokula, hagasang'hanika ama kuitendela vivalo. Ila nowalongela, hata Selemani na mali gake gose hawile na vivalo vinogile kamba malua gano. ");
INSERT INTO zaj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kamba Mulungu koivaza mijani ya mmuhulo ikoneka lelo na mayo yokwasigwa na kusomigwa, habanza ng'hani kuwavaza mweye? Mweye wanhu muli na nhamanila ndodo! ");
INSERT INTO zaj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Avo sambimgaye mmioyo yenu, kamba moja choni, ama mong'wa choni, na sambimdungwedungwe sama ya mbuli zino. ");
INSERT INTO zaj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kwavija Wamhazi wa ulumwengu uno wawo wozigelegeza ng'hani mbuli kamba zino, ila mweye, Tata wenu kovitanga kamba movilonda vinhu vino. ");
INSERT INTO zaj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ila uzahileni Undewa wa Mulungu, na gano gose mogweleligwa. ");
INSERT INTO zaj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Sambimdumbe, mweye dale dodo, kwavija Tata wenu kanogelwa kuwagwelela mweye Undewa wake. ");
INSERT INTO zaj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Guzeni vimulinavo zihela muwagwelele wakumbulu. Itendeleni wenyego mkwiji wa hela haulalaga, mwike mali genu kuulanga, aho mali genu hagahunguka, kwavija haduhu wabavi wondawakwenhukile ama vimhungu vondavibanange. ");
INSERT INTO zaj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kwavija mali gako hagali na moyo wako baho hondaukale. ");
INSERT INTO zaj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Kaleni meso na jojose dondadize, toeni lupati, na kubwinha viwenge venu, ");
INSERT INTO zaj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","kamba watumigwa wom'beta mndewa wao yobwela kulawa kulusona lwa zengele. Avija yobwela na kubwenga ulwivi, hima wom'vugulila. ");
INSERT INTO zaj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wodeng'ha ng'hani watumigwa waja mndewa wao vondayabwele yahawavika wameso, waisasale! Nowalongela ikweli, koisasala, na kuwalongela wakale hasi na kuwasang'hanikila. ");
INSERT INTO zaj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wodeng'ha ng'hani watumigwa waja kamba yahawavika waisasale, hata kamba yeheza ikilo kikulu ama nzogolo zikwika. ");
INSERT INTO zaj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Muitange goya mbuli ino, kamba mwene ng'anda yahakimanyile kipigiti m'bavi chondayeze, sambiyaileke ng'anda yake ituligwe. ");
INSERT INTO zaj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Vivija na mweye muisasale, kwavija nie, Mwana wa Munhu, nokwiza mkipigiti hamkitamanile.” ");
INSERT INTO zaj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petulo kalonga, “Mndewa, hala dino kotulongela tweye twiyeka, ama kowalongela na wanhu wose?” ");
INSERT INTO zaj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mndewa kamulongela, “Yalihi mtumigwa ija yalibule uzenzeleganye, yali m'bala, mkulu wake yondayamwike yawe mkulu wa watumigwa zake wayagwe, giladi yawagwelele mandia mkipigiti kilondigwa? ");
INSERT INTO zaj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kodeng'ha ng'hani mtumigwa ija mkulu wake yahabwela ukae, yaham'vika yotenda vino. ");
INSERT INTO zaj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nowalongela ikweli, mkulu ija komtenda mtumigwa ija yawe mkulu wa mali gake gose. ");
INSERT INTO zaj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ila kamba mtumigwa ija yahalonga mmoyo wake, ‘Mkulu wangu kokawa ng'hani kubwela,’ na kusonga kuwatoa watumigwa wayage wakitwanzi na wakimbigalo na kuja na kung'wa na kukoligwa, ");
INSERT INTO zaj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mkulu ija kobwela mdizua mtumigwa ija haditamanile na kipigiti hakitangile. Mkulu ija komkanha mtumigwa ija vidangavidanga na kumwika hamoja na walibule nhamanila. ");
INSERT INTO zaj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Mtumigwa ija yovimanya vija voyolondigwa yatende na mkulu wake ila hakiisasala, ama hatenda gaja goyolonda mkulu wake, mtumigwa ija kolimbwa ng'hani. ");
INSERT INTO zaj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ila kamba mtumigwa ija hagatangile gaja mkulu wake goyolonda, na kutenda kinhu kimulumbile kulimbwa, kolimbwa hadodo. Munhu yagweleligwe vinhu bwando, kumwake volondigwa vinhu bwando. Na munhu yagweleligwe vinhu bwando ng'hani, kumwake volondigwa vinhu bwando ng'hani. ");
INSERT INTO zaj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Niza kubwinha moto muisi, vinilondile wakile umalile! ");
INSERT INTO zaj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nna ubatizo nolondigwa niubokele, nogaya ng'hani mbaka vondaumale! ");
INSERT INTO zaj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mwagiza niza kugala tindiwalo muisi? Si vivo, sigalile tindiwalo ila uhasanyi. ");
INSERT INTO zaj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Songela lelo na kugendelela, mulango wa wanhu watano wokiihasanya, wadatu kwa wabili na wabili kwa wadatu. ");
INSERT INTO zaj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Watata wokiihasanya na wana zao, na wana wokiihasanya na watata zao, wakinamama wokiihasanya na wandele zao, na wandele wokiihasanya na wamama zao, wamama mkwe wokiihasanya na wakemwana zao, na wakemwana wokiihasanya na wamama mkwe zao.” ");
INSERT INTO zaj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kabili Yesu kawalongela wanhu, “Muhajona wingu dilawilila ng'ambu ya uswelo wa zua, molonga mvula konda kutoa, na kweli kotoa. ");
INSERT INTO zaj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na muhajona beho dilawilila kusi, molonga zua dobatuka lelo, na kweli dobatuka. ");
INSERT INTO zaj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Videlenya mweye! Modaha kutapita gaja gokoneka kuulanga na muisi. Habali hamtanga kukitapita kipigiti kino? ");
INSERT INTO zaj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Habali hamdaha kuilamula wenyego mtende mbuli zinogile? ");
INSERT INTO zaj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Iyohe ng'hani kuilumba na munhu yokugala ha mulamula kipigiti mng'hali mnzila, kamba hutendile avo kokukwekwesa yakuvikize ha mulamula, na mulamula yakugele mmakono ga wemilizi, na wemilizi wakugele mkifungo. ");
INSERT INTO zaj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nokulongela hulawa himo mbaka ulihe shilingi ya ikimambukizo.” ");
INSERT INTO zaj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kipigiti kija wanhu wayagwe wakalile haja wamulongela Yesu mbuli ya Wagalilaya wakomigwe na Pilato viwakalile womulavila Mulungu nhosa zao. ");
INSERT INTO zaj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu kawauza, “Kwavija Wagalilaya waja wakomigwa kamba vija, mokwagiza wakala walozile ng'hani kubanza Wagalilaya wose? ");
INSERT INTO zaj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Si vivo! Na nowalongela, kamba hamulekile vilozo venu, mweye mose modanganhika kamba viwadanganhike wano. ");
INSERT INTO zaj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ama mowagesaze waja wanhu longo dimwe na wanane walagalilwe na ulingo kuja Siloamu? Mokwagiza kamba wakala walozile ng'hani kubanza wanhu wose wokala Yelusalemu? ");
INSERT INTO zaj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Si vivo! Na nowalongela, kamba hamulekile vilozo venu, mweye mose modanganhika kamba viwadanganhike wano.” ");
INSERT INTO zaj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Abaho, Yesu kawalongela hala dino, “Kukala na munhu imwe yakalile na mtini uhandigwe muna umgunda wake wa mizabibu. Kachola kuzahila mujo muja mumtini ila havikile kinhu. ");
INSERT INTO zaj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Avo kamulongela imulimi wa umgunda, ‘Lola! Mulao wa ikadatu uno nikwiza kuzahila mujo mumtini uno na sipata kinhu. Uukanhe! Habali uibananga isi bule?’ ");
INSERT INTO zaj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ija imulimi kamulongela, ‘Mndewa, uleke tanhu mulao umwe, niutifulile nizunguluka disina, abaho, niwikile mboji. ");
INSERT INTO zaj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Abaho, mulao uyagwe kamba uhalela, vonoga. Ila kamba haulelile, leka uukanhe.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Zua dimwe da Mhumulo, Yesu kakala yofundiza mng'anda ya nhambiko. ");
INSERT INTO zaj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na haja kukala na mtwanzi yalemazwe na kinyamkela mmilao longo dimwe na minane. Kakala yabongomale na hadahile kugoloka hata kidogo. ");
INSERT INTO zaj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu viyamonile, kamkema haulongozi, kamulongela, “Mama, utamu wako uhona!” ");
INSERT INTO zaj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kamwikila makono gake, na bahaja kagoloka na kusonga kumuyenzi Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ila mkulu wa ing'anda ya nhambiko kona lusango kwavija Yesu kahonya Mdizua da Mhumulo, avo kenula dizwi yowalongela wanhu, “Hana mazua sita gamulondigwa kusang'hanika, izoni kuhonyigwa mmazua higo, ila sambimwize kuhonyigwa Mdizua da Mhumulo!” ");
INSERT INTO zaj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mndewa kamwidika yolonga, “Mweye videlenya! Hana munhu yoyose mmwanza wenu yoleka kumfungula ng'ombe wake ama mhunda wake yalawe mdikonhi yamgale kung'wa mazi Mdizua da Mhumulo? ");
INSERT INTO zaj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Avo mtwanzi ino yali wa lukolo lwa Ablaham, Mwenembago yambongomaze mmilao longo dimwe na minane, sambiyahonyigwe Mdizua da Mhumulo?” ");
INSERT INTO zaj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mbuli zake ziwatenda wadumuka zake wone kinyala, ila wanhu wayagwe wadeng'helela mbuli zose za mkanganyo zayatendile. ");
INSERT INTO zaj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu kauza, “Undewa wa Mulungu ulinga na kinhu kilihi? Niulinge na kinhu chaki? ");
INSERT INTO zaj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ulinga kamba mbeyu ya haladali, yaaisolile munhu na kuihanda mkihati chake. Ikula na kugaluka kamba m'biki, na ndege wazenga mvulu zao mmatambi gake.” ");
INSERT INTO zaj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kabili Yesu kauza, “Undewa wa Mulungu niulinge na kinhu chaki? ");
INSERT INTO zaj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ulinga na mela diyasolile mtwanzi na kuditibuliza muna ivibaba vidatu va usage mbaka tonge jose dilulumuka.” ");
INSERT INTO zaj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu kagendelela na mwanza wake yochola Yelusalemu, yobitila mmiwambo na m'viwambo yowafundiza wanhu. ");
INSERT INTO zaj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Munhu imwe kamuuza, “Mndewa, wanhu wadodo iwo wondawakomboligwe?” Yesu kawalongela, ");
INSERT INTO zaj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Iyoheni kwingila mkubitila mulwivi luli lusisili, kwavija nowalongela, wanhu bwando wogeza kwingila, ila hawadaha. ");
INSERT INTO zaj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mwene ng'anda vondayenuke na kuhinda ulwivi, abaho, mweye mokwima hanze na kusonga kubwenga ulwivi na kulonga, ‘Mndewa, tuvugulile ulwivi!’ Na heyo kowalongela, ‘Siwatangile mweye na sikutangile kumulawa!’ ");
INSERT INTO zaj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Abaho, momulongela, ‘Tuja na kung'wa nagwe, na kutufundiza m'viwambo vetu!’ ");
INSERT INTO zaj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ila heyo kowalongela, ‘Siwatangile mweye na sikutangile kumulawa, segeleni hano hamwangu, mweye mose watenda gehile!’ ");
INSERT INTO zaj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Aho hondahawe na kililo na kugegedula meno vondamuwone Ablaham na Isaka na Yakobo na wahokozi wose wa Kuundewa wa Mulungu, ila mweye mokwasigwa hanze. ");
INSERT INTO zaj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wanhu wokwiza kulawa ng'ambu zose za ulumwengu na kukala hasi waje kulusona lwa Kuundewa wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kweli, wanhu wayagwe wali kuchugu wowa haulongozi, na wanhu wayagwe wali haulongozi wowa kuchugu.” ");
INSERT INTO zaj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kipigiti kikija Mafalisayo wamcholela Yesu wamulongela, “Segela hano uchole hanhu hayagwe, kwavija Helode Antipa konda kukukoma.” ");
INSERT INTO zaj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu kawalongela, “Gendeni mkamulongele mbweha ija, ‘Lelo na mayo nowinga vinyamkela na kuhonya wanhu, na zua da ikadatu nokwishiliza sang'hano yangu.’ ");
INSERT INTO zaj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nolondigwa nigendelele na mwanza wangu, lelo, mayo, na kisindo. Havidahika muhokozi kudanganhikila hanze ya Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yelusalemu! Yelusalemu! Gweye uwakoma wahokozi na kuwatoa na mibwe waja watumigwe kumwako! Mianza mingahi nilonda kuwakunzanya hamoja wanago kamba nguku viyowafagatila wanage hasi ya mbawa zake, ila hutogole! ");
INSERT INTO zaj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Avo lola ng'anda yako yolekigwa. Nokulongela, hunyona nie kabili mbaka vondaulonge, ‘Kamota ayo yokwiza mditwaga da Mndewa.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Zua dimwe da Mhumulo Yesu kachola kuja mandia kung'anda ya mkulu imwe wa Mafalisayo, wanhu wakala womulola goya. ");
INSERT INTO zaj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Haulongozi wake kukala na munhu yali na utamu wa kuvuha lukuli. ");
INSERT INTO zaj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu kawauza wafundiza Malagizo ga Musa na Mafalisayo, yolonga, “Malagizo getu gotutogoza kuhonya Mdizua da Mhumulo, ama gotugomesa?” ");
INSERT INTO zaj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ila hewo hawalongile kinhu chochose. Yesu kamgoga ija imunhu kamuhonya, abaho, kamuleka yachole na zake. ");
INSERT INTO zaj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Abaho, kawalongela, “Yalihi mmwanza wenu mwanage ama ng'ombe wake yehengila mdisima, yondayaleke kumulava mbwisa Mdizua da Mhumulo?” ");
INSERT INTO zaj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ila hewo wanyamala. ");
INSERT INTO zaj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu kawona avija wahenza wayagwe viwokala wosagula ivigoda va haulongozi, avo kawalongela wanhu wose hala dino, ");
INSERT INTO zaj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Munhu yahakugoneka halusona lwa zengele, sambiukale m'vigoda va haulongozi. Ihalawila kagonekigwa munhu yali na twaga kubanza gweye yeheza, ");
INSERT INTO zaj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","na mwenekae wenu, yawagoneke gweye na heyo, kokwiza na kukulongela, ‘Mnegele ino yakale hano.’ Avo vivo vondausegele kuno ukona kinyala uikunyate uchola kukala kuchugu. ");
INSERT INTO zaj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ila uhagonekigwa hanhu, genda ukakale kigoda cha kuchugu, avo mwenekae wenu kokwiza hauli na kulonga, ‘Izo kuno kuulongozi, mbwigaangu, ukale hanhu hanogile.’ Dino dokugwaa kituno hameso ga wahenza wose. ");
INSERT INTO zaj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kwavija munhu yoyose yokiituniza mwenyego kobwezwa hasi, na ayo yoibweza hasi mwenyego kotunizwa.” ");
INSERT INTO zaj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Abaho, Yesu kamulongela mwenekae wake, “Mana uwagomela wanhu mandia ga imisi ama mandia ga ichungulo, sambiuwagoneke wambwiga zako ama wandugu zako ama wanhu wa lukolo lwako ama wanhu wa habehi yako wali wagoli, kwavija na hewo kwiza wokugoneka, mkutenda vino kolihigwa gaja gautendile. ");
INSERT INTO zaj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Uhatenda mandia ga lusona, wagoneke wakumbulu, mbetembete, walemale ivipindi, na vimbugumbugu, ");
INSERT INTO zaj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","na gweye komotezwa kwavija hewo hawadaha kukuliha. Ila Mulungu kokuliha kuna idizua da kuzusigwa kwa wanhu walibule uzenzeleganye.” ");
INSERT INTO zaj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Imwe wa wanhu wakalile na heyo hameza, kagahulika gaja, kamulongela Yesu, “Kamota ng'hani munhu ayo yondayaje kulusona Muundewa wa Mulungu!” ");
INSERT INTO zaj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu kamulongela, “Kukala na munhu imwe yatendile lusona lukulu ng'hani, abaho, kawagoneka wanhu bwando. ");
INSERT INTO zaj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kipigiti cha kuja vikivikile, kamulagiza nyakadala wake yakawalongele wahenza zake, ‘Izoni, vinhu vose visasaligwa vimala!’ ");
INSERT INTO zaj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ila kila munhu kasonga kulava uyalazi wake, waichanduso kamulongela ija inyakadala, ‘Nigula mgunda avo nolondigwa nikaulole, chonde togola uyalazi wangu.’ ");
INSERT INTO zaj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Waikabili kalonga, ‘Nigula ng'ombe longo dimwe wa kulimila, avo nochola kuwageza, chonde ndeka nyhole.’ ");
INSERT INTO zaj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Iyagwe kalonga, ‘Nisola mtwanzi sambi baha, avo sidaha kwiza.’ ");
INSERT INTO zaj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ija inyakadala kabwela, kamsimulila mbuli zose mkulu wake. Ija imkulu kagevuzika ng'hani avo kamulongela nyakadala wake, ‘Hima, genda mzinzila ng'hulu na ndodo za mkiwambo, ukawagale wakumbulu, mbetembete, vimbugumbugu, na walemale.’ ");
INSERT INTO zaj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ija inyakadala kamulongela, ‘Mkulu, gaja gose gaulagize gatendigwa, ila hana nafasi isigala.’ ");
INSERT INTO zaj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Avo mkulu ija kamulongela nyakadala wake, ‘Genda m'balabala ng'hulu na ndodo za muisi ukawashulutize wanhu wose weze kwingila giladi ng'anda yangu imeme.’ ");
INSERT INTO zaj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nowalongela mweye mose kamba, ‘Waja wagonekigwe haichanduso, haduhu hata imwe yondayalanze vakuja vangu!’ ” ");
INSERT INTO zaj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Zua dimwe dale kulu da wanhu dikala diilongoza na Yesu, kahinduka kawalongela, ");
INSERT INTO zaj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Munhu yoyose yokwiza kumwangu, na kuno koleka kuninogela nie kubanza tataake na mamaake, na mtwanzi wake, na wanage, na wandugu zake na lumbu zake na hata ugima wake mwenyego, hadaha kuwa mwanahina wangu. ");
INSERT INTO zaj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Munhu yoyose yoleka kupapa msalaba wake na kung'holeleza hadaha kuwa mwanahina wangu. ");
INSERT INTO zaj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Vino yalihi mmwanza wenu yahalonda kuzenga ulingo, yondayaleke kukala hasi tanhu, yalole kamba kana hela za kwishilizila sang'hano ija? ");
INSERT INTO zaj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kamba hatendile vino, yahamambukiza umsingi na kuhumwa kumambukiza, wanhu wondawone gaja galawilile womseka, ");
INSERT INTO zaj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","wolonga, ‘Munhu ino kasonga kuzenga ila hadahile kwishilizila isang'hano.’ ");
INSERT INTO zaj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ama mndewa yalihi yochola kugomba na mndewa iyagwe, yoleka tanhu kukala na kugelegeza kamba heyo na asikali zake alufu longo dimwe kodaha kugomba na mndewa ija yokwiza kugomba na heyo yali na asikali alufu malongo mabili? ");
INSERT INTO zaj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kamba ihawa hadaha, kowagala wasenga wakaiting'hane na ija imndewa iyagwe, wakamgwile mavindi kulonda tindiwalo kipigiti yang'hali kutali.” ");
INSERT INTO zaj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesu kamambukiza, “Vivija haduhu yoyose mmwanza wenu yodaha kuwa mwanahina wangu kamba halekile vinhu vake vose vayalinavo. ");
INSERT INTO zaj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Munyu unoga, ila uhagiza kilandu chake, haduhu nzila iyagwe ya kuutenda unoge kabili. ");
INSERT INTO zaj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Haunoga kinhu, kwikigwa mmigunda ama kutibulizwa na mhugutu, ila wanhu wowasa kunze. Yali na magwiti na yahulike!” ");
INSERT INTO zaj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Zua dimwe wawila kodi bwando na wanhu wayagwe wene vilozo weza kumtegeleza Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mafalisayo na wafundiza Malagizo ga Musa wasonga kutwanganika, wolonga, “Munhu ino kowabokela wanhu wali na vilozo na hata kuja nao!” ");
INSERT INTO zaj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Avo Yesu kawalongela hala dino. ");
INSERT INTO zaj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tutende munhu imwe mmwanza wenu kana ng'hondolo mia, abaho, ng'hondolo imwe kapotela, kotendaze? Kowaleka waja iwang'hondolo malongo tisa na tisa muluwala na kuchola kumzahila ija yapotele mbaka yamone. ");
INSERT INTO zaj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yahamona, kodeng'helela ng'hani avo kompapa mmaega ");
INSERT INTO zaj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","na kum'bweza ukae. Abaho, kowakema hamoja wambwiga zake na wanhu wa mzing'anda za habehi na kuwalongela, ‘Nodeng'ha ng'hani kwavija nimona ng'hondolo wangu yapotele, avo izoni tudeng'he chose!’ ");
INSERT INTO zaj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Avo nowalongela, kowa na ndeng'helelo ng'hulu kuulanga avija munhu imwe yali na vilozo yahaleka vilozo vake, kubanza wanhu malongo tisa na tisa walibule vilozo na hawalonda kuleka vilozo vao. ");
INSERT INTO zaj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ama tulonge mtwanzi imwe kana hela longo dimwe, abaho, kasa hela imwe, kotendaze? Kobwinha kiwenge na kufagila ng'anda yake na kulolesa kila hanhu mbaka yayone. ");
INSERT INTO zaj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yahayona, kowakema hamoja wambwiga zake na wanhu wa mzing'anda za habehi na kuwalongela, ‘Nodeng'helela ng'hani kwavija niyona ihela inyasile. Izoni tudeng'he tose!’ ");
INSERT INTO zaj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Avo nowalongela, vivija wasenga wa Mulungu wa kuulanga wodeng'ha avija munhu imwe yali na vilozo yahaleka vilozo vake.” ");
INSERT INTO zaj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu kagendelela kulonga, “Kukala na munhu imwe yakalile na wana wabili wambigalo. ");
INSERT INTO zaj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Imdodo kamulongela tataake, ‘Tata, ngwelela uhazi wangu sambisambi.’ Avo ija imunhu kawagolela mali gake wanage wose wabili. ");
INSERT INTO zaj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mkipigiti kiguhi ija imwanage imdodo kaguza vinhu vake vose, kasegela hakae na izihela. Kachola isi ya kutali, ako kwayasile hela zake mmbuli za mzanyamzanya. ");
INSERT INTO zaj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Viyamambukize vinhu vose, ingila nzala mpamanho muisi ija yose, avo kasonga kuzahila vinhu vakuja. ");
INSERT INTO zaj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Avo kachola kusang'hanika ha munhu imwe mwenekae wa isi ija, na heyo kamgala kumgunda wake yakemilize mitumbi. ");
INSERT INTO zaj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kasulukila kuigutiza na mikamhi iidile imitumbi, na haduhu munhu yamgwelele kinhu chochose. ");
INSERT INTO zaj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ngelegeza zinogile vuzimwizile, kalonga mmoyo wake, ‘Wasang'hana wangahi wa tataangu woja na kusigaza, ila nie hano nofa nzala! ");
INSERT INTO zaj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nosegela nibweleganye ha tataangu nikamulongele, “Tata, niloza ha Mulungu na hamwako gweye. ");
INSERT INTO zaj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Silumbile kukemigwa mwanago, nitende kamba vija imwe wa wasang'hana zako.” ’ ");
INSERT INTO zaj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Avo kenuka na kusonga kubwela ha tataake. “Viyakalile yang'hali kutali, tataake kamona, kamonela bazi, avo kamkimbilila, abaho, kamkumbatila na kumnonela. ");
INSERT INTO zaj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ija imwana kalonga, ‘Tata, niloza ha Mulungu na hamwako gweye. Silumbile kukemigwa mwanago.’ ");
INSERT INTO zaj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ila tataake kawakema nyakadala zake, kalonga, ‘Hima mgalileni ng'hanzu inogile mum'vaze. M'vazeni kitindi mkidole chake na vilatu mmagulu gake. ");
INSERT INTO zaj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Abaho, gendeni mkamsole mwanang'ombe yanonile mumchinje, na tutende lusona, tudeng'he! ");
INSERT INTO zaj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kwavija mwanangu ino kakala kamba yadanganhike, ila sambi mgima, kakala yapotele, ila sambi koneka!’ Avo lusona lusonga. ");
INSERT INTO zaj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Kipigiti kikija mwanage imkulu kakala yobwela kulawa kumgunda, mnzila viyakalile behi na ing'anda, kahulika ngoma na sing'hino za mvina. ");
INSERT INTO zaj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Avo kamkema imwe wa nyakadala, kamuuza, ‘Kuna choni?’ ");
INSERT INTO zaj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ija inyakadala kamulongela, ‘Mdodo wako kabwela, na tataako kachinja mwanang'ombe yanonile kwavija kabwela yali mpile.’ ");
INSERT INTO zaj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ija imwana imkulu kagevuzika ng'hani mbaka kalema kwingila mng'anda. Avo tataake kalawa hanze kamuyalalila yomulonda yengile mng'anda. ");
INSERT INTO zaj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ila heyo kamulongela tataake, ‘Lola! Milao ino yose nikusang'hanikila sang'hano zako kamba nyakadala, na siduluke ndagizi zako zozose. Kungwelela choni? Hungwelele hata menhe mdodo nhende lusona na wambwiga zangu! ");
INSERT INTO zaj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ila mwanago ino kasa mali gako gose mkutenda ugoni ndwanga, abaho, kabwela ukae, komchinjila mwanang'ombe yanonile!’ ");
INSERT INTO zaj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tataake kamulongela, ‘Mwanangu, gweye kokala hano na nie mazua gose, na vinhu vose vinilinavo nie vako gweye. ");
INSERT INTO zaj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Avo vinoga tweye tuvine na kudeng'ha kwavija mdodo wako kakala kamba yadanganhike, ila sambi mgima. Kakala yapotele, ila sambi koneka!’ ” ");
INSERT INTO zaj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu kawalongela wanahina zake, “Kukala na munhu imwe mgoli yakalile na mwimilizi wa vinhu vake. Ija imgoli kalongeligwa kamba ija imwimilizi kakala yomung'hunya hela zake, ");
INSERT INTO zaj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","avo kamkema, kamuuza, ‘Mbuli zaki zino zinihulika zikulonga gweye? Ngwelela mheta ya mali gangu gose gaukalile wimiliza, kwavija hudaha tena gweye kuwa mwimilizi wangu.’ ");
INSERT INTO zaj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ija imwimilizi kalonga munda kwa munda, ‘Mkulu wangu kolonda kunisegeza msang'hano yangu. Nhendeze? Kulima sidaha, na kupula nokona kinyala. ");
INSERT INTO zaj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nikitanga chondanhende! Nihawingigwa kulawa msang'hano yangu, nopata wambwiga wondawanibokele mkae zao.’ ");
INSERT INTO zaj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Avo kawakema wanhu wose wakalile wowilwa na ija imgoli wake, kamuuza waichanduso, ‘Kowilwa aki na mkulu wangu?’ ");
INSERT INTO zaj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Na heyo kalonga, ‘Madebe mia mbili ga mavuta ga mizaituni.’ Ija imwimilizi kamulongela, ‘Sola cheti chako, ukale hasi hima wandike madebe mia.’ ");
INSERT INTO zaj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Abaho, kamuuza iyagwe, ‘Na gweye kowilwa aki?’ Kalonga, ‘Vipeto mia sita va ngano.’ Ija imwimilizi kamulongela, ‘Sola cheti chako, wandike vipeto mia nne na malongo manane.’ ");
INSERT INTO zaj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Avo mkulu wa mwimilizi ija kizenzeleganye kamtogola avija vayatendile ubala kamba uja, kwavija wanhu wa ulumwengu uno wabala ng'hani mkuzigongomanya mbuli zao na wayao kubanza wanhu wali mmulangaza.” ");
INSERT INTO zaj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu kagendelela kulonga, “Nowalongela, izahilileni wambwiga mkubitila mali ga muulumwengu, avo kamba gehesha, mobokelwa muna uukazi wa milongo yose. ");
INSERT INTO zaj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Munhu yoyose yalibule uzenzeleganye m'vinhu vidodo, vivija kowa bule uzenzeleganye m'vinhu bwando. Na munhu yoyose yali na uzenzeleganye m'vinhu vidodo, vivija kowa na uzenzeleganye m'vinhu bwando. ");
INSERT INTO zaj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Avo kamba muhawa vizenzeleganye mkwimiliza mali ga muulumwengu, yalihi yondayawatogole kwimiliza mali ga kweli? ");
INSERT INTO zaj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na kamba muhawa vizenzeleganye m'vinhu va munhu iyagwe, yalihi yondayaweng'he vinhu venu wenyego? ");
INSERT INTO zaj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Haduhu mtumigwa yodaha kuwasang'hanikila wakulu wabili, kwavija komwihila ino na kumnogela iyagwe, ama koigoga na imwe na kum'buhiza iyagwe. Hamdaha kumsang'hanikila Mulungu hamoja na hela.” ");
INSERT INTO zaj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mafalisayo viwahulike gano, wam'beza Yesu kwavija wanogelwa na hela. ");
INSERT INTO zaj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu kawalongela, “Mweye iwo wanhu mkiitenda muna mioyo inogile mmeso ga wanhu, ila Mulungu koitanga mioyo yenu, kwavija vinhu vigesigwa na wanhu kamba vinoga ng'hani vabule unozi hameso ga Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Malagizo ga Musa na Nyandiko Zing'alile za wahokozi zikala zipetigwa mbaka kipigiti cha Yohana M'batiza, songela aho Usenga Unogile wa Undewa wa Mulungu wopetigwa, na kila munhu kokwingila na mhiko. ");
INSERT INTO zaj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ila vibuha ulanga na isi kuyangayuka kubanza kidanga kidodo cha Malagizo ga Musa kusegezwa. ");
INSERT INTO zaj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mbigalo yoyose yahamwasa mtwanzi wake na kusola mtwanzi iyagwe, kotenda ugoni, na munhu yahamsola mtwanzi yasigwe, kotenda ugoni. ");
INSERT INTO zaj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Kukala na munhu imwe mgoli yakalile yovala vivalo va zambalau vene hela bwando na kakala yoja goya mazua gose. ");
INSERT INTO zaj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Vivija kukala na munhu imwe mkumbulu yokemigwa Lazalo, yakalile na vilonda lukuli lugima, yakalile yogaligwa halwivi lwa ija imgoli, ");
INSERT INTO zaj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","yosulukila kuja vakuja vilagale kulawa hameza ya ija imgoli. Hata mibwa iza kumulambita vilonda vake. ");
INSERT INTO zaj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Hakimambukizo, ija imkumbulu kadanganhika, kapapigwa na wasenga wa Mulungu wa kuulanga kekigwa behibehi na Ablaham. Vivija ija imgoli na heyo kadanganhika na kazikigwa. ");
INSERT INTO zaj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Avo akuja kuzimu ija imgoli kakala mumgayo mkulu ng'hani, kenula meso gake hatalitali kamona Ablaham na Lazalo hamgwazo wake. ");
INSERT INTO zaj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Avo kenula dizwi yolonga, ‘Tata Ablaham! Nyonela bazi, mulongele Lazalo yazabike kidole chake mmazi yaluhoze lulimi lwangu, kwavija nie na mumgayo mkulu mmoto uno!’ ");
INSERT INTO zaj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ila Ablaham kamulongela, ‘Kumbukila tanhu, mwanangu, vuukalile muulumwengu kugweleligwa vinhu vose vinogile, ila Lazalo kagweleligwa vinhu vose vihile. Ila sambi kohozigwa moyo na gweye kogaya. ");
INSERT INTO zaj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Uhaleka gose gano, hana kolongo kulu dikigwe hagatigati yetu mweye na tweye, giladi waja wolonda kuloka kulawa hano kwiza hamwenu sambiwadahe, na munhu yoyose yolonda kuloka kulawa hiko kwiza kuno sambiyadahe.’ ");
INSERT INTO zaj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ija imgoli kalonga, ‘Basi, tata Ablaham, nokuyalalila, mulagize Lazalo yachole kung'anda ya tataangu, ");
INSERT INTO zaj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","hiko kuna ndugu zangu watano, yakawazume, giladi sambiweze kuno kuli na mgayo!’ ");
INSERT INTO zaj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ila Ablaham kamulongela, ‘Wandugu zako wana Malagizo ga Musa na Nyandiko Zing'alile za wahokozi, waleke wazitegeleze hizo vuzilonga.’ ");
INSERT INTO zaj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ija imgoli kalonga, ‘Hivo havitosha, tata Ablaham! Ila munhu yahazuka na kuwacholela, woleka vilozo vao.’ ");
INSERT INTO zaj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ila Ablaham kalonga, ‘Kamba hawazitegeleze Nyandiko za Musa na wahokozi, hawatogola hata kamba munhu yahazuka.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu kawalongela wanahina zake, “Mbuli ziwatendaga wanhu watende vilozo hazilekaga kulawilila, ila kojona ng'hani munhu ija yondayazitende zilawile! ");
INSERT INTO zaj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vihamnogele munhu ija yafungigwe msingo dibwe kulu da kusiginhila, abaho, yakasigwe m'bahali kubanza kumtenda imwe wa wanhu wano wadodo kuloza. ");
INSERT INTO zaj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Avo teganyeni! “Kamba ndugu yako yahaloza, mkomhokele, yahaleka kuloza, mgele kumgongo. ");
INSERT INTO zaj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kamba yahakutendela vilozo mianza saba mdizua dimwe, na mianza yose saba keza kumwako yolonga, ‘Nileka,’ mgele kumgongo.” ");
INSERT INTO zaj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Watumigwa wa Kilisto wamulongela Mndewa Yesu, “Tongezele nhamanila yetu.” ");
INSERT INTO zaj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mndewa kawalongela, “Kamba muhawile na nhamanila ndodo kamba mbeyu ya haladali, muhadahile kuulongela mkuyu uno, ‘Ng'ozoka ukaihande m'bahali!’ Na uhawahulike. ");
INSERT INTO zaj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tulonge munhu imwe mmwanza wenu kana nyakadala wa kumulimila ama kumchungila ng'hondolo. Yahabwela kulawa kumgunda, komulongela nyakadala wake yatende hima yeze kuja mandia? ");
INSERT INTO zaj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nokona si vivo! Ila komulongela, ‘Nhelekela mandia gangu hima, uisasale unisang'hanikile mbaka niheshiliza kuja na kung'wa, kileka na gweye uje mandia gako.’ ");
INSERT INTO zaj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Avo, komuheweza nyakadala ija avija viyagatendile gaja gayalagizwe? ");
INSERT INTO zaj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Vivija na mweye! Muhatenda kila kinhu kimulongeligwe mkitende, longeni, ‘Tweye twa nyakadala tulibule maliho, tutenda gaja gatulondigwe kutenda tu.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu viyakalile yochola Yelusalemu, kabitila muimbaka ya isi za Samalia na Galilaya. ");
INSERT INTO zaj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Viyakalile yokwingila muna ikiwambo kimwe, wanhu longo dimwe wolumwa dikulu wamwizila, wema kutalitali, ");
INSERT INTO zaj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","wenula dizwi wolonga, “Mndewa, Yesu, utonele bazi!” ");
INSERT INTO zaj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu viyawawene kawalongela, “Gendeni ha iwakulu wa nhambiko wakawalole goya.” Viwakalile wochola mnzila wahona. ");
INSERT INTO zaj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Munhu imwe mmwanza wao viyonile kahona, kabwela, kenula dizwi yomuyenzi Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kamfugamila mavindi Yesu na kumgwaa hewela. Na munhu ija kakala Msamalia. ");
INSERT INTO zaj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ila Yesu kauza, “Hawakalile wanhu longo dimwe wahonyigwe? Wakwahi wayagwe tisa? ");
INSERT INTO zaj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Haduhu hata munhu imwe yabwelile kumuheweza Mulungu ila muhenza ino yeiyeka?” ");
INSERT INTO zaj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu kamulongela, “Ima wima uchole, nhamanila yako ikuhonya.” ");
INSERT INTO zaj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mafalisayo wayagwe wamuuza Yesu, wolonga, “Zua dilihi Undewa wa Mulungu vondawize?” Heyo kawalongela, “Undewa wa Mulungu hawiza mkoneka na meso. ");
INSERT INTO zaj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Haduhu munhu yondayalonge, ‘Loleni wa hano!’ Ama ‘Wa haja!’ Kwavija Undewa wa Mulungu wa mmwenu.” ");
INSERT INTO zaj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Abaho, kawalongela wanahina zake, “Kipigiti chokwiza vondamusulukile kona zua dondanibwele, nie, Mwana wa Munhu, ila hamujona. ");
INSERT INTO zaj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Na wanhu wowalongela, ‘Loleni kahaja!’ ama, ‘Loleni kahano!’ Ila sambimuwakweleleze. ");
INSERT INTO zaj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kamba vija lumwemwe vulumweka kulawa kuulanga na kumwemwesa kulawa ng'ambu ino mbaka ng'ambu ija, avo vivo vondaiwe mdizua dondanize, nie, Mwana wa Munhu. ");
INSERT INTO zaj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ila tanhu nolondigwa nigaye ng'hani na kulemigwa na wanhu wa mulelo uno. ");
INSERT INTO zaj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kamba viikalile mkipigiti cha Nuhu vivo vondaiwe mdizua dondanibwele, nie, Mwana wa Munhu. ");
INSERT INTO zaj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Wanhu wose wakala woja na kung'wa, wosola na kusoligwa, mbaka zua dija Nuhu viyengile muisafina, na mvula ng'hulu ng'hani itoa na kumemeza mazi na kuwakoma wanhu wose. ");
INSERT INTO zaj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yowa kamba viikalile kipigiti cha Loti. Wanhu wose wakala woja na kung'wa, wogula na kuguza, wohanda na kuzenga, ");
INSERT INTO zaj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","mbaka zua dija Loti viyasegele wambo da Sodoma, moto na baluti vihumuluka hasi kulawa kuulanga na kuwakoma wanhu wose. ");
INSERT INTO zaj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Vino vivo vondaiwe mdizua dondanigubuligwe, nie, Mwana wa Munhu. ");
INSERT INTO zaj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Mdizua dija munhu yali kukiswili cha ng'anda yake sambiyahumuluke hasi yengile mng'anda yakasole vinhu vake, na munhu yali kumgunda sambiyabwele ukae. ");
INSERT INTO zaj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kumbukileni gam'vikile mtwanzi wa Loti! ");
INSERT INTO zaj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Munhu yoyose yogeza kuukombola ugima wake, kowagiza, na munhu yoyose yowagiza ugima wake, koukombola. ");
INSERT INTO zaj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nowalongela, ikilo ija wanhu wabili wowasa mulusazi lumwe, imwe kosoligwa na imwe kolekigwa. ");
INSERT INTO zaj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Watwanzi wabili wokomola ngano hamoja, imwe kosoligwa na imwe kolekigwa. ");
INSERT INTO zaj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wanhu wabili wolima mumgunda, imwe kosoligwa na imwe kolekigwa.” ");
INSERT INTO zaj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wanahina zake wamuuza, “Mndewa, kwahi?” Yesu kawalongela, “Hohose hauli mtufi, baho hondawaiting'hanile vimhungu.” ");
INSERT INTO zaj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Abaho, Yesu kawalongela hala wanahina zake yowafundiza kamba wolondigwa kutambika bila kudonha. ");
INSERT INTO zaj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kalonga, “Kukala na mulamula mkiwambo kimwe, yakalile hamdumba Mulungu, na vivija hawagesa wanhu. ");
INSERT INTO zaj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mkiwambo kija kukala na kizuka yakalile yomwizila mulamula ija mianza bwando, yolonga, ‘Nhaza mhate kwing'higwa gaja golondigwa mhate kulawa ha ija yolonda kunizulunza!’ ");
INSERT INTO zaj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mazua bwando ija imulamula kalema, ila hakimambukizo kalonga munda kwa munda, ‘Nie simdumba Mulungu vivija siwagesa wanhu, ");
INSERT INTO zaj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ila kwavija kizuka ino kongaza ng'hani, noilola nhaguso yake yeng'higwe choyolonda. Kamba sitendile vino, kogendelela kwiza, hakimambukizo kondonheza ng'hani!’ ” ");
INSERT INTO zaj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Abaho Mndewa kagendelela kulonga, “Tegelezeni viyolonga ija imulamula yalibule unhu. ");
INSERT INTO zaj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Avo mokwagiza Mulungu hondayawedike hima wanhu zake mwenyego womulilila misi na kilo? Mokwagiza kotenda mholemhole kuwataza? ");
INSERT INTO zaj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nowalongela, kowataza hima. Ila vondanize nie, Mwana wa Munhu, noivika nhamanila muisi?” ");
INSERT INTO zaj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Vivija Yesu kawalongela hala dino wanhu wokiiyona kamba hewo iwo iwende na kuwabeza wayagwe. ");
INSERT INTO zaj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Wanhu wabili wakwela wachola Kung'anda ya Mulungu kutambika, imwe kakala Mfalisayo na imwe muwila kodi. ");
INSERT INTO zaj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Ija Mfalisayo kaibagula kema yeiyeka katambika yolonga, ‘Nokuheweza, Mulungu, kwavija nie sili kamba wanhu wayagwe, mibokonyi ama vizenzeleganye ama wagoni ama kamba ino muwila kodi. ");
INSERT INTO zaj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nofunga mianza mibili mmazua saba, nolava zaka m'vinhu vangu vose vinipata.’ ");
INSERT INTO zaj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ila ija imuwila kodi kema kutali na hadahile hata kwinula kihanga chake kuulanga, kaitoatoa mmhambaga kulagusa giogio na kulonga, ‘Go Mulungu, nyonela bazi, nie nili na vilozo.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu kawalongela, “Ija imuwila kodi kabwela ukae yopetigwa kutenda gamnogele Mulungu kubanza ija Imfalisayo. Kwavija munhu yoyose yokiinula mwenyego kohumuluswa, na ija yoihumulusa mwenyego kokwinuligwa.” ");
INSERT INTO zaj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wanhu wamgalila Yesu wana zao wadodo yawekile makono yawamoteze. Wanahina zake viwawawene wotenda vija, wawakomhokela. ");
INSERT INTO zaj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ila Yesu kawakema iwana kumwake kalonga, “Walekeni wana wadodo weze kumwangu, sambimuwagomese. Kwavija Undewa wa Mulungu una wanhu wali kamba wano. ");
INSERT INTO zaj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nowalongeleni ikweli! Munhu yoyose yahaleka kuubokela Undewa wa Mulungu kamba viyali mwana mdodo havidahika kuwingila.” ");
INSERT INTO zaj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mkulu imwe wa Wayahudi kamuuza Yesu, “Mkulufunzi Unogile, nhende choni kileka mana niuhale ugima wa digunge?” ");
INSERT INTO zaj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu kamuuza, “Habali ung'hema nie ninogile? Haduhu munhu yanogile ila Mulungu yeiyeka. ");
INSERT INTO zaj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kuzitanga ndagizi? ‘Sambiutende ugoni, sambiukome, sambiwibe, sambiulave usindila wa uvwizi, wahishimile tataako na mamaako.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ija imunhu kalonga, “Gano gose nigatenda songela ning'hali mdodo.” ");
INSERT INTO zaj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu viyahulike gano kamulongela, “Kusigaza kinhu kimwe chuulondigwa kutenda. Guza vinhu vose vuulinavo na zihela uwagwelele wakumbulu, avo kowa na ngama kuulanga, abaho, wize ung'holeleze.” ");
INSERT INTO zaj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ila munhu ija viyahulike gaja, kanyunguala ng'hani kwavija kakala na mali bwando. ");
INSERT INTO zaj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu kamulola, abaho kalonga, “Vino vivo vondaviwe vidala wagoli kwingila Muundewa wa Mulungu! ");
INSERT INTO zaj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Vibuha ngamia kubita mkizonzo cha shindano kubanza mgoli kwingila Muundewa wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wanhu wagahulike gano wamuuza, “Avo yalihi basi yondayadahe kukomboligwa?” ");
INSERT INTO zaj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu kawalongela, “Gaja hagadahika mwa wanhu ha Mulungu godahika.” ");
INSERT INTO zaj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Abaho, Petulo kamulongela, “Lola! Tweye tuleka vinhu vetu vose, tukukweleleza gweye.” ");
INSERT INTO zaj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu kawalongela, “Nowalongela ikweli, munhu yoyose yalekile kae ama mtwanzi wake ama wandugu ama watata na wamama ama wana sama ya Undewa wa Mulungu, ");
INSERT INTO zaj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kobokela vinhu bwando ng'hani mkipigiti kino, na kubokela ugima wa digunge mkipigiti kikwiza.” ");
INSERT INTO zaj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu kawagala wanahina zake longo dimwe na wabili hamgwazo, kawalongela, “Tegelezeni! Tokwela Yelusalemu, aho kila kinhu chawandike wahokozi kinilonga nie, Mwana wa Munhu, chovikila. ");
INSERT INTO zaj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nogeligwa mmakono ga Wamhazi awo wondawanitendele uponela, woniliga na kunitemela mate. ");
INSERT INTO zaj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Wonilanha, abaho, wonikoma, ila mdizua da ikadatu nozuka.” ");
INSERT INTO zaj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ila wanahina zake hawazimanyile mbuli zija. Nhegulo ya mbuli zija ikala ifisigwa kumwao, na hawagamanyile gaja gayawalongele. ");
INSERT INTO zaj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu viyakalile behi na wambo da Yeliko, kukala na kimbugumbugu imwe yakalile mumgwazo wa inzila yopula. ");
INSERT INTO zaj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Viyahulike dale da wanhu dobita, kauza, “Kuna choni?” ");
INSERT INTO zaj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wamulongela, “Yesu wa Nazaleti kobita.” ");
INSERT INTO zaj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kenula dizwi yolonga, “Yesu, Mwana wa Daudi, nyonela bazi!” ");
INSERT INTO zaj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wanhu walongole wamkomhokela wamulongela yanyamale. Ila heyo kagendelela kwinula dizwi kulu ng'hani, yolonga, “Mwana wa Daudi, nyonela bazi!” ");
INSERT INTO zaj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Avo Yesu kema, kawalagiza wamgale hamwake ija imunhu kimbugumbugu. Viyavikile behi, Yesu kamuuza, ");
INSERT INTO zaj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Kolonda nikutendele choni?” Na heyo kamwidika, “Mndewa, nolonda kulola kabili.” ");
INSERT INTO zaj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu kamulongela, “Lola! Nhamanila yako ikuhonya.” ");
INSERT INTO zaj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Bahaja munhu ija kadaha kulola kabili, kamkweleleza Yesu, kuno yomuyenzi Mulungu. Wanhu viwonile gaja, wose wamuheweza Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu kengila mdiwambo da Yeliko kakala yobita mnzila za idiwambo dija. ");
INSERT INTO zaj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Haja kukala na mkulu imwe wa wawila kodi twaga jake Zakayo, yakalile mgoli ng'hani. ");
INSERT INTO zaj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kakala yolonda kumona Yesu iyo munhu wa vilihi, ila kakala mguhi avo hadahile kumona Yesu kwavija wanhu wakala bwando. ");
INSERT INTO zaj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Avo kakimbilila haulongozi mwa ididale da wanhu na kukwela mumkuyu giladi yamone Yesu, kwavija kakala yobita mnzila ija. ");
INSERT INTO zaj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu viyavikile haja, kalola uchana kamulongela Zakayo, “Zakayo, humuluka mbwisa, kwavija lelo nolondigwa nikale mng'anda yako.” ");
INSERT INTO zaj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakayo kahumuluka himahima, kam'bokela na ndeng'helelo ng'hulu. ");
INSERT INTO zaj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wanhu wose wagawene gaja wasonga kutwanganika, walonga, “Munhu ino kachola kukala kung'anda ya munhu mwene vilozo!” ");
INSERT INTO zaj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakayo kema wima kamulongela Yesu, “Tegeleza, Mndewa! Nie nolava lwenza lwa vinhu vangu niwagwelele wakumbulu, na kamba nihasola kinhu cha munhu yoyose mkum'bulunya, nom'bwezela mianza mine.” ");
INSERT INTO zaj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu kamulongela, “Lelo ukombola wingila mng'anda ino, kwavija ino vivija munhu wa lukolo lwa Ablaham. ");
INSERT INTO zaj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwavija nie, Mwana wa Munhu, niza kuzahila na kuwakombola waja wapotele.” ");
INSERT INTO zaj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wanhu wakala womtegeleza Yesu, avo kawalongela hala diyagwe, katenda vino kwavija kakala behi na Yelusalemu, na wanhu wakala wogelegeza kamba Undewa wa Mulungu wa mmabehi kulawilila. ");
INSERT INTO zaj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Avo kalonga, “Kukala na munhu imwe wa lukolo lwa kindewa kachola isi ya kutali kutendigwa mndewa wa isi yake, ikwisha yabweleganye ukae. ");
INSERT INTO zaj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Viyakalile behi na kuchola, kawakema nyakadala zake longo dimwe, kamgwelela kila imwe hela imwe. Kawalongela, ‘Tendeni uchuluzi mbaka vondanibwele.’ ");
INSERT INTO zaj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ila wanhu wa muisi yake wamwihila, avo wawagala wasenga hachugu chake wakalonge, ‘Hatumulonda munhu ino yawe mndewa wetu.’ ");
INSERT INTO zaj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ija munhu kagweleligwa undewa na kubwela ukae. Viyavikile, hima kalagiza wakemigwe nyakadala zake wachole kumwake giladi yavimanye hela nyingahi ziwapatile. ");
INSERT INTO zaj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nyakadala wa ichanduso keza kalonga, ‘Mndewa, mhata hela ziyagwe longo dimwe kulawa muhela imwe yuungwelele.’ ");
INSERT INTO zaj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kalonga, ‘Vinoga, nyakadala mwende! Kwavija hutendile uzenzeleganye mmbuli ndodo, nokwika uwe mkulu m'viwambo longo dimwe.’ ");
INSERT INTO zaj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Keza nyakadala wa ikabili, kalonga, ‘Mndewa, mhata hela tano kulawa muhela imwe yuungwelele.’ ");
INSERT INTO zaj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Na heyo kamulongela, ‘Kowa mkulu m'viwambo vitano.’ ");
INSERT INTO zaj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Nyakadala iyagwe keza, kalonga, ‘Mndewa, hela yako ino hano, niifunga mkitambala niifisa. ");
INSERT INTO zaj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nikudumba, kwavija gweye kwa munhu mgaga. Kosola vinhu si vako, na kohuna vija huvihandile.’ ");
INSERT INTO zaj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ija imndewa kamulongela, ‘Nokutagusa kulawa mmbuli zako mwenyego! Gweye nyakadala mwavu, kuvitanga kamba nie na munhu mgaga, nosola vinhu si vangu, na nohuna vija sivihandile. ");
INSERT INTO zaj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Habali hwikile hela yangu benki vinibwelile niivike ilelile?’ ");
INSERT INTO zaj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Abaho, kawalongela waja wakalile wemile haja, ‘M'bokeni ihela yaali nayo, mumgwelele nyakadala ija yapatile hela longo dimwe!’ ");
INSERT INTO zaj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ila hewo wamulongela, ‘Mndewa, heyo kana hela longo dimwe!’ ");
INSERT INTO zaj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ija imndewa kawedika, ‘Nowalongela, munhu yoyose yali na kinhu kokongezelwa, ila ija yalibule kinhu, hata kija ikidodo chayalinacho kobokonywa. ");
INSERT INTO zaj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na waja wadumuka zangu wanilemile nie sambiniwe mndewa wao, wagaleni hano muwakome hameso gangu!’ ” ");
INSERT INTO zaj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu viyeshile kulonga gano, kagendelela na mwanza yowalongola wanhu, yochola Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Viyavikile mkiwambo cha Betifage hana Ikigongo cha Mizaituni behi na kiwambo cha Betania, kawatuma wabili mmwanza wa wanahina zake, ");
INSERT INTO zaj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kawalongela mbuli zino, “Gendeni hakiwambo kili haulongozi wenu, muhavika, mom'vika mwana mhunda hanapapa munhu yoyose, yafungigwe. Mfunguleni, munigalile. ");
INSERT INTO zaj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kamba munhu yahawauza habali mumfungula, mulongeleni, ‘Mndewa komulonda.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wanahina waja wachola, wavika kamba vija Yesu viyawalongele. ");
INSERT INTO zaj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Viwakalile womfungula imwana mhunda, wenyego wawauza, “Habali mumfungula?” ");
INSERT INTO zaj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wawalongela, “Mndewa komulonda.” ");
INSERT INTO zaj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Wamsola imwana mhunda, wamgala ha Yesu. Abaho, watandika vivalo vao mumgongo wa imwana mhunda, abaho, wampapa Yesu wamwika mumgongo wa imwana mhunda. ");
INSERT INTO zaj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu viyakalile yochola, wanhu wanzanza vivalo vao mnzila. ");
INSERT INTO zaj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Viyakalile behi na kuvika Yelusalemu, ahaja hana inhelemuko Hakigongo cha Mizaituni, dale kulu da wanahina zake disonga kwinula nyangi kuno wotoa ng'henze na kumuheweza Mulungu, sama ya mbuli zose ng'hulu ziwonile. ");
INSERT INTO zaj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Wolonga, “Kamota Mtawala yokwiza mtwaga da Mndewa! Tindiwalo kuulanga na yenzi ha Mulungu!” ");
INSERT INTO zaj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mafalisayo wayagwe wakalile mdidale dija wamulongela Yesu, “Mkulufunzi, walongele wanahina zako wanyamale!” ");
INSERT INTO zaj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu kawedika, “Nowalongela! Kamba wano wahanyamala, mabwe gosonga kwinula dizwi.” ");
INSERT INTO zaj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Viyakwenhuke behi na Yelusalemu na viyadiwene idiwambo, kadililila, ");
INSERT INTO zaj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","yolonga, “Kamba uhakitangile lelo kija kilondigwa kugala tindiwalo! Ila kifisigwa hameso gako! ");
INSERT INTO zaj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kwavija kipigiti chokwiza wadumuka zako vondawakuzungulusile lwigo, na kukuzunguluka kukubaniza ng'ambu zose. ");
INSERT INTO zaj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wokuhondahonda kabisa na kuwakoma wanhu wali mgati mwa iviwambaza vako, haduhu dibwe dondadilekigwe hachana ya diyagwe, kwavija hukitangile kipigiti Mulungu viyezile kukukombola!” ");
INSERT INTO zaj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Abaho, Yesu kachola Kung'anda ya Mulungu, kasonga kuwawinga wanhu wakalile woguza vinhu, ");
INSERT INTO zaj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","yowalongela, “Yandikigwa Mzinyandiko Zing'alile kamba, ‘Ng'anda yangu yowa ng'anda ya nhambiko.’ Ila mweye muitenda kifiso cha wabavi!” ");
INSERT INTO zaj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mazua gose viyakalile Yelusalemu, Yesu kakala yofundiza Kung'anda ya Mulungu. Wakulu wa wakulu wa nhambiko, wafundiza Malagizo ga Musa, na wakulu wa wanhu wakala wozahila nzila ya kumkoma. ");
INSERT INTO zaj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ila hawapatile nzila ya kumkomela, kwavija wanhu wose wakala womtegeleza goya mazua gose, hawalondile kuihonya hata mbuli imwe. ");
INSERT INTO zaj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Zua dimwe Yesu viyakalile Kung'anda ya Mulungu yowafundiza wanhu na kuwapetela Usenga Unogile, wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa hamoja na wavyele wa wanhu weza, ");
INSERT INTO zaj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","wamuuza, “Tulongele, kotenda mbuli zino na udaho ulihi? Yalihi yakugwelele udaho uno?” ");
INSERT INTO zaj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu kawedika, “Beta niuze mbuli. Nilongeleni, ");
INSERT INTO zaj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","vino udaho wa Yohana wa kubatiza ulawa ha Mulungu ama ulawa mwa wanhu?” ");
INSERT INTO zaj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wasonga kuibamilila wenyego kwa wenyego, “Tulongeze? Kamba tuhalonga ‘Ulawa ha Mulungu,’ kwiza kotulongela, ‘Habali hamumtogole Yohana?’ ");
INSERT INTO zaj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na tuhalonga, ‘Ulawa mwa wanhu,’ wanhu wose hano wotukoma mkututoa na mabwe, kwavija wamtogola kamba Yohana kakala muhokozi.” ");
INSERT INTO zaj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Avo wamulongela, “Hatukutangile kuulawile.” ");
INSERT INTO zaj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu kawalongela, “Na nie siwalongela na udaho ulihi notenda mbuli zino.” ");
INSERT INTO zaj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Abaho, Yesu kawalongela wanhu hala dino, “Kukala na munhu imwe yakalile na mgunda wa mizabibu, kawapangiza walimi, abaho, kachola isi ya kutali, kakala kuja kipigiti kitali. ");
INSERT INTO zaj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kipigiti cha kuhuna zizabibu vikivikile, kamtuma nyakadala wake ha iwalimi yakamsolele fungu jake da izizabibu. Ila waja iwalimi wamtoa ija inyakadala na kum'bweza bila kinhu. ");
INSERT INTO zaj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Avo kamgala nyakadala iyagwe, ila waja iwalimi vivija wamtoa, wamtendela mbuli za kumgela kinyala, abaho, wam'bweza bila kinhu. ");
INSERT INTO zaj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Abaho, kamgala nyakadala wa ikadatu, na heyo vivija waja iwalimi wamgela milonda, abaho, wamwasa hanze ya umgunda. ");
INSERT INTO zaj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Avo mwene umgunda wa zabibu kalonga, ‘Nhendeze? Nomgala mwanangu mwenyego yaninogele, kwa vovose ino womuhishimila!’ ");
INSERT INTO zaj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ila waja iwalimi viwamonile, wailongela, ‘Ino iyo muhazi wake mwene mgunda. Natumkome, na uhazi wake wowa wetu!’ ");
INSERT INTO zaj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Avo wamwasa hanze ya umgunda, abaho, wamkoma.” Yesu kawauza, “Ija mwene umgunda wa izizabibu kowatenda choni waja iwalimi? ");
INSERT INTO zaj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kokwiza kuwakoma wanhu waja, na umgunda wa izizabibu kowagwaa walimi wayagwe.” Wanhu viwahulike gano, walonga, “Sambigatulawilile gano!” ");
INSERT INTO zaj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ila Yesu kawalola, abaho, kawauza. “Nyandiko zino Zing'alile nhegulo yake choni? ‘Dibwe dilemigwe na wazenzi digaluka kuwa dibwe da kutamanilwa ng'hani kubanza mabwe gose.’ ");
INSERT INTO zaj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Munhu yoyose yondayadigwile dibwe dija kokanhika vidangavidanga, na kamba dibwe dija dihamgwila munhu, domsiginha lipilipi.” ");
INSERT INTO zaj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wafundiza Malagizo ga Musa na wakulu wa wakulu wa nhambiko bahaja walonda kumgoga Yesu, kwavija wavitanga kamba kadilonga hala dino yowalonga hewo, ila wawadumba wanhu. ");
INSERT INTO zaj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Wakala womuhembula ng'hani, abaho, wawatuma visepi waitendile kamba wanhu wanogile. Watamanila kumnamata Yesu mmbuli zayalongile, giladi wamgoge wamgele mmakono ga mkulu wa undewa wa Loma. ");
INSERT INTO zaj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wanhu waja wamulongela Yesu, “Mkulufunzi, tuvitanga kamba kolonga na kufundiza mbuli za kweli, na kamba hudumba kihanga cha munhu yoyose, ila kofundiza ikweli vija Mulungu voyowalonda wanhu watende. ");
INSERT INTO zaj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tulongele, vino vinoga tweye kuliha kodi ha mkulu wa undewa wa Loma ama havinogile?” ");
INSERT INTO zaj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ila Yesu kaumanya ubala wao, kawalongela, ");
INSERT INTO zaj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ndagusileni ihela. Twaga na kihanga kino kili muno cha munhu yalihi?” Walonga, “Va mkulu wa undewa wa Loma.” ");
INSERT INTO zaj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Avo Yesu kalonga, “Vinoga. Avo muliheni mkulu wa undewa wa Loma vija vili va mkulu wa undewa wa Loma, na muliheni Mulungu vija vili va Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hawadahile kumnamata mmbuli ziyalongile haja hameso ga wanhu, avo wanyamala, wakanganya nyidikilo yake. ");
INSERT INTO zaj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Abaho, Masadukayo wayagwe, waja wolonga kamba wanhu hawazuka, weza ha Yesu na mbuza, ");
INSERT INTO zaj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","walonga, “Mkulufunzi, Musa katwandikila tweye lagizo dino, ‘Kamba munhu yahadanganhika na kaleka mwehe ila halelile nayo mwana, mdodo ama mkulu wa munhu hiyo kolondigwa yamsole ija ikizuka yamulelele wana ndugu yake yadanganhike.’ ");
INSERT INTO zaj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Avo kukala na wandugu saba. Imkulu kasola mtwanzi, kadanganhika halekile mwana. ");
INSERT INTO zaj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Abaho, waikabili kamsola ija imtwanzi, na heyo kadanganhika bila kuleka mwana, ");
INSERT INTO zaj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","na waikadatu kamsola. Galawilila gagaja mbaka wose saba wadanganhika bila kuleka wana. ");
INSERT INTO zaj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hakimambukizo, ija imtwanzi vivija kadanganhika. ");
INSERT INTO zaj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Avo kuna dizua da kuzuka kwa wanhu wadanganhike, kowa mtwanzi wa yalihi? Kwavija wose saba wakala wamsolile.” ");
INSERT INTO zaj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu kawalongela, “Wanhu wa kipigiti kino wosola na kusoligwa, ");
INSERT INTO zaj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ila wanhu waja walumbile kwingila muulumwengu uja, na kuna umzuso wa kulawa mkudanganhika, hawasola ama kusoligwa, ");
INSERT INTO zaj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","na hawadanganhika, wowa kamba wasenga wa Mulungu wa kuulanga. Wao wowa wana wa Mulungu, kwavija wazusigwa. ");
INSERT INTO zaj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ila mmbuli ya kuzuka kwa wanhu, hata Musa kalagusa mbuli hiyo Mzinyandiko Zing'alile muna imbuli ya kitutua kikwaka, aho komulonga Mndewa kamba ‘Mulungu wa Ablaham, na Isaka, na Yakobo.’ ");
INSERT INTO zaj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Heyo hali Mulungu wa wadanganhike, ila Mulungu wa wagima, kwavija kumwake heyo wose wana ugima.” ");
INSERT INTO zaj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wafundiza wayagwe wa Malagizo ga Musa walonga, “Kulonga goya, Mkulufunzi!” ");
INSERT INTO zaj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na haduhu munhu yagezile kumuuza tena mbuli iyagwe! ");
INSERT INTO zaj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu kawauza, “Vodahikaze wanhu kulonga kamba Kilisto Mkombola kowa mwana wa Daudi? ");
INSERT INTO zaj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kwavija Daudi mwenyego kolonga mkitabu cha Zabuli, ‘Mndewa kamulongela Mndewa wangu, Kala kumkono wangu wa ukulume ");
INSERT INTO zaj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mbaka vondaniweke wadumuka zako wawe kamba kigoda cha kwikila magulu gako.’ ");
INSERT INTO zaj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kamba Daudi kamkema heyo Mndewa, abaho, Kilisto Mkombola kowaze mwana wa Daudi?” ");
INSERT INTO zaj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wanhu wose viwakalile wotegeleza, Yesu kawalongela wanahina zake, ");
INSERT INTO zaj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Iteganyeni na wafundiza Malagizo ga Musa, awo wonogelwa kuzungulukazunguluka kuno wavalile mikanzu yao, na wonogelwa kulamsigwa na hishima mmasoko, na kusagula vigoda va haulongozi mzing'anda za nhambiko na mulusona. ");
INSERT INTO zaj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wowabulunya vizuka na kutenda nhambiko nhali za uzenzeleganye hameso ga wanhu! Nhaguso yao yowa ng'hulu ng'hani!” ");
INSERT INTO zaj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu kawalola wanhu wose, kawona wagoli vowogela nhosa zao mkia cha kulavila nhosa, ");
INSERT INTO zaj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","abaho, kamona kizuka imwe mkumbulu ng'hani kagela senti mbili. ");
INSERT INTO zaj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu kalonga, “Nowalongela kizuka ino imkumbulu kagela nhosa ng'hulu kubanza wayagwe wose, ");
INSERT INTO zaj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","kwavija wayagwe walava nhosa zao kulawa m'vinhu vibanzile mmali gao gali bwando, ila heyo, hamoja na ukumbulu wake, kalava vose vayatamanile.” ");
INSERT INTO zaj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wanhu wayagwe wakala wolongelela woilonga Ing'anda ya Mulungu viihambigwe na mabwe ganogile na nhosa zilavigwa ha Mulungu. Yesu kalonga, ");
INSERT INTO zaj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Gano gomkona hano, kipigiti chokwiza haduhu hata dibwe dimwe dondadilekigwe hachana ya diyagwe, gose golagazwa hasi.” ");
INSERT INTO zaj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wamuuza, “Mkulufunzi, mbuli zino zolawila zua jaki? Na choni chondakilawilile kutulagusila kamba kipigiti kivika cha mbuli ino kulawilila?” ");
INSERT INTO zaj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu kalonga, “Tegelezeni munhu sambiyawavwizile. Wanhu bwando wokwiza mtwaga jangu, wolonga, ‘Nie iyo Kilisto!’ na, ‘Kipigiti kivika!’ Ila sambimuwakoleleze. ");
INSERT INTO zaj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Sambimdumbe muhahulika ng'hondo na muhindumuhindu, kwavija vinhu kamba avo volondigwa visonge kulawila, ila ikimambukizo hakiza hima.” ");
INSERT INTO zaj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kagendelela kulonga, “Isi yogomba na isi iyagwe, na undewa wouvamhila undewa uyagwe. ");
INSERT INTO zaj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kowa na mgudemo mkulu ng'hani wa isi, nzala na utamu hauhonaga hanhu na hanhu, kowa na vinhu va mkanganyo na va kudumbiza vilagala kulawa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ila mbuli zino zose kipigiti hazinalawila, tanhu, mogogigwa na kugazigwa, mogaligwa mzing'anda za nhambiko na kugeligwa mkifungo, mogaligwa mwa wandewa na mwa watawala sama yangu. ");
INSERT INTO zaj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kino chowa kipigiti cha mweye kuzipeta mbuli zangu kumwao. ");
INSERT INTO zaj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Lamuleni mmioyo yenu kamba hamwiza kugelegeza avija vondamuigombeleze, ");
INSERT INTO zaj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kwavija nowagwelela ng'hungwe na mbuli za kulonga azo zondaziwatende wadumuka zenu wose sambiwadahe kuzilema ama kubamila. ");
INSERT INTO zaj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mohonzigwa na watata zenu na wamama zenu na wakulu na wadodo zenu na wandugu zenu na wambwiga zenu, na wayagwe mmwanza wenu wokomigwa. ");
INSERT INTO zaj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Wanhu wose wowehila sama yangu. ");
INSERT INTO zaj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ila haduhu hata luvili lumwe kulawa mmatwi genu londalupotele. ");
INSERT INTO zaj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nanahileni, moikombola wenyego. ");
INSERT INTO zaj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Muhajona wambo da Yelusalemu dizungulukwe na madale ga asikali, m'vitange kamba mkipigiti kiguhi dokwiza kubanangwa. ");
INSERT INTO zaj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Avo, awo wali Yudea wakimbilile m'vigongo, awo wali mdiwambo wasegele, na awo wali kumigunda sambiwabwele mdiwambo. ");
INSERT INTO zaj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kwavija kino kicho kipigiti cha nhaguso, kugatenda gaja gose galongigwe Mzinyandiko Zing'alile galawile. ");
INSERT INTO zaj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wogaya ng'hani watwanzi wali na inda mmazua higo na watwanzi wali na wana ving'hele! Mgayo mkulu wokwiza muisi ino, na lusango lukulu lwa Mulungu lowagwila wanhu wano. ");
INSERT INTO zaj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wanhu wayagwe wokomigwa na mapanga, na wanhu wayagwe wosoligwa kamba wafungigwa na kupwililiswa muisi zose. Na wambo da Yelusalemu dobojagwa na Wamhazi, mbaka kipigiti chao vondakimale. ");
INSERT INTO zaj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kowa na vinhu va mkanganyo vondavilawile mdizua, mmulenge, na mnhondo. Muulumwengu, wanhu wa muisi zose wowa bule nhamanila, wodumba kisindo cha bahali na nyangi za kumema na kuhungula kwa ibahali. ");
INSERT INTO zaj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wanhu wosinduka mkona bwembwe, wobeta wone chondakilawilile muulumwengu wose, kwavija mhiko za kuulanga zotigiswa. ");
INSERT INTO zaj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aho baho hondawanyone nie, Mwana wa Munhu, nikwiza na mawingu na mhiko na yenzi ng'hulu. ");
INSERT INTO zaj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mbuli zino zihasonga kulawila, imeni wima, mgangamale, kwavija ukombola wenu wa mmabehi.” ");
INSERT INTO zaj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Abaho, Yesu kawalongela hala dino, “Ugelegezeni mtini na mibiki yose. ");
INSERT INTO zaj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Muhagona matepo gake gosonga kuzuka, movitanga kamba vuli da mmabehi. ");
INSERT INTO zaj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Vivija, muhazona mbuli zino zolawila, m'vitange kamba Undewa wa Mulungu wa mmabehi. ");
INSERT INTO zaj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Kweli nowalongela, wanhu wa mulelo uno hawesha wose mbaka mbuli zino zose zilawilile. ");
INSERT INTO zaj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ulanga na isi vose vobita, ila mbuli zangu hazibita. ");
INSERT INTO zaj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Teganyeni, mioyo yenu sambiibasakanywe na ngelegeza za kubukanya na kung'wa ugimbi na mbuli za ulumwengu uno, kwavija zua dija da ikimambukizo dowezila mkuwasinhukiza ");
INSERT INTO zaj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","kamba mtego. Kwavija vivo vondadiwezile wanhu wose wokala kila hanhu muulumwengu. ");
INSERT INTO zaj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kaleni meso mazua gose, na mtambike kipigiti chose giladi mwing'higwe mhiko za kubita muilegehe mmbuli hizo zose azo zondazilawile na kwima haulongozi wa nie, Mwana wa Munhu.” ");
INSERT INTO zaj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mazua gaja Yesu kakala yofundiza Kung'anda ya Mulungu, na ichungulo kakala yochola kuwasa kuna Ikigongo cha Mizaituni. ");
INSERT INTO zaj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ndamuka ya kila imitondo wanhu wose wachola Kung'anda ya Mulungu kumtegeleza. ");
INSERT INTO zaj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kipigiti cha Lusona lwa Imikate Ilibule Mela, lukemigwa Pasaka, kikwenhuka. ");
INSERT INTO zaj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa wakala wozahila nzila ya kumkoma Yesu, ila wawadumba wanhu. ");
INSERT INTO zaj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Abaho, Mwenembago kamwingila Yuda, yokemigwa Isikalioti, yakalile mmwanza wa wanahina longo dimwe na wabili. ");
INSERT INTO zaj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Avo Yuda kachola kulonga na wakulu wa wakulu wa nhambiko na wakulu wa asikali wemilizi wa Ing'anda ya Mulungu avija vondayamgele mmakono gao. ");
INSERT INTO zaj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Wadeng'helela ng'hani, wailagana kumgwaa hela. ");
INSERT INTO zaj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda katogola, kasonga kuzahila hanhu ha kumgela Yesu mmakono gao kipigiti halibule wanhu. ");
INSERT INTO zaj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Zua da Ulusona lwa Imikate Ilibule Mela divika, lusona lwawachinjaga wana ng'hondolo wa Pasaka. ");
INSERT INTO zaj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu kawatuma Petulo na Yohana yowalongela, “Gendeni mkatutandile mandia ga Pasaka tuje.” ");
INSERT INTO zaj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Wamuuza, “Kwahi kuulonda tukaitande?” ");
INSERT INTO zaj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kawalongela, “Muhengila mdiwambo, moiting'hana na munhu yapapile nongo ya mazi. Mkwelelezeni mbaka kuna ing'anda yondayengile, ");
INSERT INTO zaj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","mulongeleni mwene ng'anda, ‘Mkulufunzi kokuuza, dakwahi digati dondawadile Pasaka heyo na wanahina zake?’ ");
INSERT INTO zaj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kowalagusila gati kulu da uchana dili na vinhu vose. Aho baho hondamsasale kila kinhu.” ");
INSERT INTO zaj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wachola wavika kila kinhu kamba viwalongeligwe na Yesu, avo wasasala mandia ga Pasaka. ");
INSERT INTO zaj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kipigiti vikivikile, Yesu kakala hameza na watumigwa zake. ");
INSERT INTO zaj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kawalongela, “Nisulukila ng'hani kuja na mweye mandia gano ga Pasaka ning'hali sinagazigwa. ");
INSERT INTO zaj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kwavija nowalongela sigaja kabili mandia gano mbaka vondagavikile Muundewa wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Abaho, Yesu kasola kikasi, kamuheweza Mulungu, kalonga, “Soleni kino muigolele mwemwe kwa mwemwe. ");
INSERT INTO zaj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nowalongela, songela kipigiti kino na kugendelela, sing'wa viyagwe divai mbaka Undewa wa Mulungu vondawize.” ");
INSERT INTO zaj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Abaho, kasola mkate, kamuheweza Mulungu, kaumogola, kawagwelela yolonga, “Uno uwo lukuli lwangu lulavigwe sama yenu, tendeni vino mkung'humbukila nie.” ");
INSERT INTO zaj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Viyeshile kuwagwelela gamandia, vivija kawagwelela kikasi yolonga, “Kikasi kino kicho lagano da isambi dili mmulopa wangu, ukwitika sama yenu. ");
INSERT INTO zaj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ila lola! Mkono wa munhu yondayanihonze wa bahano na nie hameza! ");
INSERT INTO zaj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nie, Mwana wa Munhu, nodanganhika kamba vayalamule Mulungu, ila kogaya ng'hani munhu ija yondayanihonze!” ");
INSERT INTO zaj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Avo wasonga kuiuza wenyego kwa wenyego yalihi mmwanza wao yondayazitende mbuli zija. ");
INSERT INTO zaj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bamila dizuka mwa wanahina, kamba yalihi mmwanza wao yogelegezwa kuwa mkulu kubanza wayagwe. ");
INSERT INTO zaj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu kawalongela, “Wandewa wa Wamhazi wowatawala wanhu zao na mhiko, na watawala wolonda kukemigwa, ‘Wambwiga za Wanhu.’ ");
INSERT INTO zaj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ila vino sio vumulondigwa mweye muwe. Ila yali mkulu kubanza wose mmwanza wenu kolondigwa kuwa kamba mdodo kubanza wose, na ayo yali kilangizi kolondigwa kuwa kamba mtumigwa. ");
INSERT INTO zaj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yalihi yali mkulu, ija yokala hasi kuja ama ija imtumigwa? Nokwagiza ija yokala hasi kuja. Ila nie na mmwanza wenu kamba mtumigwa. ");
INSERT INTO zaj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Mweye mkala na nie kipigiti chose kinikalile nigazigwa, ");
INSERT INTO zaj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","na kamba Tataangu viyangwelele nie Undewa, vivija na nie nowagwelela mweye Undewa. ");
INSERT INTO zaj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Moja na kung'wa hameza yangu Muundewa wangu, na mokala muna ivigoda va undewa, muitagusa mitala longo dimwe na mibili ya Islaeli. ");
INSERT INTO zaj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simoni, Simoni! Tegeleza! Mwenembago kampula Mulungu giladi yeze kuwageza mweye, yone kamba nhamanila yenu yogendelela. ");
INSERT INTO zaj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ila nikutambikila gweye, Simoni, nhamanila yako sambiihunguke. Na uhabwela kumwangu, uwagangamaze wandugu zako.” ");
INSERT INTO zaj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ila Petulo kalonga, “Mndewa, nie nitogola kugeligwa mkifungo hamoja nagwe ama kudanganhika hamoja nagwe!” ");
INSERT INTO zaj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu kamulongela, “Nokulongela, Petulo, kilo cha lelo nzogolo hanakwika, konibela mianza midatu kamba hunimanyile.” ");
INSERT INTO zaj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Abaho, Yesu kawauza wanahina zake yolonga, “Viniwatumile kipigiti kija bila mkwiji wa hela na bila mkoba na bila vilatu viyagwe, mkala muhungukilwe na kinhu?” Wamulongela, “Hatuhungukilwe na kinhu.” ");
INSERT INTO zaj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu kawalongela, “Ila kipigiti kino yoyose yali na mkwiji wa hela ama mkoba, nayavisole, na munhu yalibule zele yaguze koti jake yakagule zele. ");
INSERT INTO zaj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Avo, nowalongela, Nyandiko Zing'alile zolonga, ‘Kapetigwa hamoja na watenda gehile,’ Zolondigwa zivikile kumwangu, kwavija ugima wangu wokwenhuka kuisota.” ");
INSERT INTO zaj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wanahina zake walonga, “Lola, Mndewa! Hano hana mizele mibili!” Na heyo kalonga, “Yotosha.” ");
INSERT INTO zaj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu kasegela haja hakiwambo kachola Hakigongo cha Mizaituni na wanahina zake kamba vayatendaga. ");
INSERT INTO zaj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Viwavikile haja hakigongo, kawalongela wanahina zake, “Tambikeni, giladi sambimwingile muna ivitega.” ");
INSERT INTO zaj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Abaho, kachola hamwande mwanza wa kwasa dibwe, kafugama mavindi, katambika, ");
INSERT INTO zaj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","kalonga, “Tata, kamba vihakunogela, nisegezele kikasi kino cha mgayo. Ila sio kamba vinilonda nie, ila kamba vuulonda gweye.” ");
INSERT INTO zaj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Msenga wa Mulungu wa kuulanga kamulawilila na kumgangamaza. ");
INSERT INTO zaj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Muusungu mkulu kaiyoha kutambika, mhome yake ikala kamba madwendwe ga mulopa godwendweka hasi. ");
INSERT INTO zaj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Viyamambukize kutambika, kema, kabweleganya ha wanahina zake, kawavika wawasile kwavija wakala na giogio. ");
INSERT INTO zaj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kawalongela, “Habali mweye muwasa? Lamukeni mtambike, giladi sambimwingile muna ivitega.” ");
INSERT INTO zaj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu viyakalile yang'hali yolonga, dale da wanhu divika dilongozwa na Yuda yakalile mmwanza wa wanahina zake longo dimwe na wabili. Kamkwenhukila Yesu na kumnonela. ");
INSERT INTO zaj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ila Yesu kamulongela, “Yuda, konihonza nie, Mwana wa Munhu, mkuninonela?” ");
INSERT INTO zaj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wanahina wakalile na Yesu viwagawene gaja galondile kulawila, wamuuza, “Mndewa, tuwakanhe na mizele yetu?” ");
INSERT INTO zaj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mwanahina imwe kadikanha gwiti da ukulume da nyakadala wa Mkulu wa Wakulu wose wa Nhambiko. ");
INSERT INTO zaj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ila Yesu kalonga, “Lekeni.” Kadikwasa gwiti da ija imunhu na kumuhonya. ");
INSERT INTO zaj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Abaho, Yesu kawalongela wakulu wa wakulu wa nhambiko na waja wemilizi wa Ing'anda ya Mulungu na wakulu wa ikitala wezile haja kumgoga, “Munizila na mizele na mimbwego kamba vija nie na m'bavi? ");
INSERT INTO zaj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nikala na mweye Kung'anda ya Mulungu mazua gose, hamunigogile. Ila kino kicho kipigiti chenu cha kutenda gano, kipigiti cha mhiko za ziza zotawala.” ");
INSERT INTO zaj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Wamgoga Yesu, wamsola wamgala kung'anda ya Mkulu wa Wakulu wose wa Nhambiko, na Petulo kakala yowakoleleza kutalitali. ");
INSERT INTO zaj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ubwinhigwa moto hagatigati ya idikonhi da ing'anda, wakala hamoja wokota moto, na Petulo kakala hamoja nawo. ");
INSERT INTO zaj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nyakadala imwe wa kitwanzi viyamonile yakalile haja hamoto, kamulola ng'hani, kalonga, “Munhu ino vivija kakala na Yesu!” ");
INSERT INTO zaj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Petulo kabela, kalonga, “Gweye mtwanzi, simtangile munhu hiyo!” ");
INSERT INTO zaj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mkipigiti kiguhi, munhu imwe kamona, kalonga, “Vivija na gweye kwa mmwanza wao!” Petulo kalonga, “Gweye munhu, sio nie!” ");
INSERT INTO zaj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Na kipigiti cha kamba saa dimwe, munhu iyagwe kagong'ondeza, yolonga, “Kabisa! Munhu ino kakala na Yesu kwavija heyo nayo kolawa Galilaya!” ");
INSERT INTO zaj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petulo kalonga, “Gweye munhu, sikitanga chuulonga.” Bahaja viyakalile hanamambukiza kulonga, nzogolo keka. ");
INSERT INTO zaj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mndewa kahinduka kamulola Petulo, na Petulo kakumbukila kamba Mndewa kakala yamulongele kamba, “Kipigiti nzogolo hanakwika kilo ya lelo, kom'bela mianza midatu.” ");
INSERT INTO zaj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Abaho, Petulo kalawa hanze, kalila ng'hani. ");
INSERT INTO zaj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Wanhu wakalile womwimiliza Yesu wasonga kumtendela mzihaka na kumtoa. ");
INSERT INTO zaj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Wamfunga na kitambala mmeso, abaho, wamuuza, “Zuza! Yalihi yakutoile?” ");
INSERT INTO zaj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na wamulongela vinhu viyagwe bwando va maligo. ");
INSERT INTO zaj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Vuuchile, wavyele na wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa waiting'hanila hamoja, na Yesu kagaligwa haulongozi wa Ikitala Kikulu cha Isi ya Wayahudi. ");
INSERT INTO zaj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Walonga, “Tulongele, gweye iyo Kilisto Mkombola?” Kawalongela, “Kamba nihawalongela, hamunitogola, ");
INSERT INTO zaj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na kamba nihawauza mbuli, hamwidika. ");
INSERT INTO zaj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ila songela kipigiti kino, nie, Mwana wa Munhu, nokala kumkono wa ukulume wa Mulungu Mkulu.” ");
INSERT INTO zaj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wose walonga, “Avo gweye iyo Mwana wa Mulungu?” Kawalongela, “Mweye iwo mulonga nie iyo nene.” ");
INSERT INTO zaj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Walonga, “Hatulonda usindila uyagwe! Tweye wenyego tuhulika kulawa mmulomo wake mwenyego!” ");
INSERT INTO zaj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Dale jose dinuka, wamsola Yesu wamgala ha Pilato. ");
INSERT INTO zaj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wasonga kumtagusa wolonga, “Tum'vika munhu ino yowagiza wanhu zetu, yowagomesa sambiwamulihe kodi Kaisali, na mwenyego koikema kamba heyo iyo Kilisto, Mndewa.” ");
INSERT INTO zaj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato kamuuza, “Gweye iyo mndewa wa Wayahudi?” Yesu kamwidika, “Gweye iyo ulonga avo.” ");
INSERT INTO zaj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Abaho, Pilato kawalongela wakulu wa wakulu wa nhambiko na dija didale da wanhu, “Siyona mbuli ya kumtagusila munhu ino.” ");
INSERT INTO zaj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ila hewo wananahila ng'hani wolonga, “Mafundo gake genula mzahimzahi mwa wanhu wose wa Yudea, kasonga Galilaya na sambi kahano.” ");
INSERT INTO zaj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato viyahulike gano, kawauza, “Munhu ino kolawa Galilaya?” ");
INSERT INTO zaj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Viyavitangile goya kamba Yesu kokala yolawa isi yootawala Helode Antipa, kamgala ha Helode, yakalile Yelusalemu kipigiti kija. ");
INSERT INTO zaj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helode kadeng'helela ng'hani viyamuwene Yesu, kwavija kakala yohulika mbuli zake, avo kipigiti kitali kakala yolonda kumona. Kakala yotamanila kumona Yesu viyotenda mzonza. ");
INSERT INTO zaj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Avo Helode kamuuza Yesu mbuli bwando, ila Yesu kamnyamalila. ");
INSERT INTO zaj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wakulu wa wakulu wa nhambiko na wafundiza Malagizo ga Musa wakwenhuka, wamtagusa Yesu na lusango. ");
INSERT INTO zaj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Helode na asikali zake wamtendela mzihaka Yesu na kumgela kinyala, abaho, wam'vaza guo da undewa, ikwisha wam'bweza kabili ha Pilato. ");
INSERT INTO zaj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilato na Helode wakala waihile, ila songela zua dija wakala wambwiga. ");
INSERT INTO zaj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato kawakema hamoja wakulu wa wakulu wa nhambiko, wakulu wa isi, na wanhu. ");
INSERT INTO zaj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kawalongela, “Mumgala munhu ino kumwangu mulonga kowagiza wanhu. Avo nimpelemba hano hameso genu, sonile mbuli yoyose ihile imumtagusila. ");
INSERT INTO zaj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Helode na heyo honile mbuli ihile, kileka mana yam'bwezile kumwetu. Haduhu kinhu chochose kihile chayatendile munhu ino kilumbile munhu ino kudanganhika. ");
INSERT INTO zaj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Avo nolagiza yalanhigwe, abaho, nomuleka yagende na zake.” ");
INSERT INTO zaj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kila kipigiti cha Lusona lwa Pasaka Pilato kawafungulilaga mfungigwa imwe. ");
INSERT INTO zaj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Dale jose diguta nyangi walonga, “Mkome hiyo! Tufungulile Balaba!” ");
INSERT INTO zaj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba kakala yafungigwe sama ya mzahimzahi wa kuilema silikali ulawilile mdiwambo na kukoma. ");
INSERT INTO zaj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato kalonda kumfungula Yesu, avo kalawilila kabili haulongozi wa ididale da wanhu. ");
INSERT INTO zaj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ila wagendelela kutoa nyangi, wolonga, “Yawambigwe mumsalaba, yawambigwe mumsalaba!” ");
INSERT INTO zaj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato kawalongela mwanza wa ikadatu, yolonga, “Mbuli ilihi ihile yaatendile? Nie siyona mbuli yoyose ihile yaatendile ilumbile heyo kudanganhika! Kolanhigwa, abaho, kolekesigwa.” ");
INSERT INTO zaj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ila wagendelela kutoa nyangi ng'hani wolonga Yesu kolondigwa yawambigwe mumsalaba. Hakimambukizo, nyangi zao zihuma. ");
INSERT INTO zaj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Avo Pilato kawatogolela waja iwanhu vija vowokala womulonda Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Avo kawafungulila Balaba iwamulondile, munhu yakalile mkifungo sama ya kugala mzahimzahi wa kuilema silikali na kukoma, na kumgela Yesu mmakono ga asikali, wamtende kamba vowolonda Wayahudi. ");
INSERT INTO zaj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Viwakalile womgala, wamgoga munhu imwe yokemigwa Simoni, munhu wa isi ya Kilene, yakalile yokwingila mdiwambo yolawa kumgunda. Wamdikwa msalaba, kaupapa hachugu cha Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Dale kulu da wanhu dimkweleleza, mmwanza wao kukala na watwanzi wokala womulilila na kumuyalalila. ");
INSERT INTO zaj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu kawahindukila kawalongela, “Mweye watwanzi wa Yelusalemu! Sambimunililile nie, ila ililileni wenyego na wanenu, ");
INSERT INTO zaj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","kwavija mazua gokwiza wanhu wokwiza kulonga, ‘Wana mhome watwanzi walibule wana, na waja hawalelile na waja hawakong'heze.’ ");
INSERT INTO zaj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kipigiti hicho wanhu wosonga kuilongela migongo, ‘Tulagalile!’ Na vigongo, ‘Tufise!’ ");
INSERT INTO zaj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kwavija kamba vinhu kamba vino votendeka mum'biki mbisi, vowaze mum'biki unyalile?” ");
INSERT INTO zaj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wanhu wayagwe wabili, wakalile watendaga gehile, vivija na hewo walongozwa wachola kukomigwa hamoja na Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Viwavikile hanhu hokemigwa, “Fulu da Pala,” wamuwamba Yesu mumsalaba hamoja na watenda gehile wabili, imwe kumkono wake wa ukulume na iyagwe kumkono wake wa ukumoso. ");
INSERT INTO zaj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu kalonga, “Tata, wagele kumgongo kwavija hawagatangile gaja gowotenda.” Waigolela vivalo vake mkutoa kula. ");
INSERT INTO zaj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wanhu wema haja wolola kipigiti wakulu wa Wayahudi viwakalile womtendela uponela, wolonga, “Kawakombola wayagwe, na yaikombole mwenyego kamba heyo iyo Kilisto yasaguligwe na Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Asikali vivija wamtendela uponela, wamkwenhukila wamgwelela divai ya ugwadu, ");
INSERT INTO zaj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","wolonga, “Kamba gweye iyo Mndewa wa Wayahudi, ikombole mwenyego!” ");
INSERT INTO zaj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Hachana ya umsalaba wake wandika vino, “ino iyo mndewa wa wayahudi.” ");
INSERT INTO zaj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mtenda gehile imwe yatungikigwe haja kamuliga Yesu yolonga, “Kamba gweye iyo Kilisto, ikombole mwenyego, abaho, utukombole na tweye.” ");
INSERT INTO zaj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ila ija mtenda gehile iyagwe kamkomhokela miyage yolonga, “Gweye humdumba Mulungu? Gweye kwa mumgayo kamba heyo. ");
INSERT INTO zaj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kumwetu tweye vilumba kwavija tugweleligwa gaja galumbile na gaja gatutendile, ila ino hatendile mbuli yoyose ihile.” ");
INSERT INTO zaj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Abaho, kamulongela Yesu, “Yesu, ung'humbuke vondawize Muundewa wako.” ");
INSERT INTO zaj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu kamulongela, “Nokulongela ikweli, lelo kowa hamoja na nie Paladiso.” ");
INSERT INTO zaj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Viivikile kamba saa sita, ziza diigubika isi yose mbaka saa tisa ");
INSERT INTO zaj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kwavija zua diziziwala, na idiguo ditungikwe Muing'anda ya Mulungu didegeka vidanga vibili. ");
INSERT INTO zaj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu kenula dizwi, kalila yolonga, “Tata, mmakono gako noika loho yangu!” Viyeshile kulonga vino, kadanganhika. ");
INSERT INTO zaj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ija imkulu wa iwaasikali mia wa Loma kagona gaja galawilile, kamuyenzi Mulungu yolonga, “Kweli, munhu ino kakala mwende!” ");
INSERT INTO zaj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wanhu wakalile waiting'hane haja kulola mbuli ija wagona gaja galawilile, wose wabwela ukae yao wokiitoatoa zimhambaga wokiiyalala ng'hani. ");
INSERT INTO zaj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Wose wakalile wambwiga zake Yesu, hamoja na watwanzi wakalile womkweleleza kulawa Galilaya, wema hatalitali wolola. ");
INSERT INTO zaj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kukala na munhu imwe yokemigwa Usufu, yakalile imwe wa wanhu wa Ikitala Kikulu cha Isi ya Wayahudi, kakala mwende wa Mulungu, ");
INSERT INTO zaj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","na hatogole gaja gawalamule. Kakala yolawa kukiwambo cha Wayahudi kikemigwa Alimataya, na kakala youbeta Undewa wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Munhu hiyo kachola ha Pilato kulupula lukuli lwa Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Abaho, kaluhumulusa hasi ulukuli, kaluvaza sanda, abaho, kalugela mdipanga dipukigwe mdibwe, dikalile hadinazikilwa munhu yoyose. ");
INSERT INTO zaj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Dikala zua da kuisasala na Zua da Mhumulo kwavija Zua da Mhumulo dikala behi kusonga. ");
INSERT INTO zaj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Waja iwatwanzi, wakalile womkweleleza Yesu kulawa Galilaya, wamkweleleza Usufu. Avo wajona dipanga na avija lukuli lwa Yesu vulwikigwe. ");
INSERT INTO zaj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Abaho, wabwela mkae zao kusasala vinung'hanung'ha na mavuta ga kunung'hila ga kulubaka lukuli lwa Yesu. Muna Idizua da Mhumulo, wahumula kamba ndagizi vuzilagize. ");
INSERT INTO zaj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Zua da mwanduso wa wiki, imitondo ng'hani, watwanzi wachola kuna dipanga wapapile vinung'hanung'ha vawatendile. ");
INSERT INTO zaj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Wadivika dibwe dikigwe hamulomo wa idipanga dibimbiliswe dikigwe hamgwazo, ");
INSERT INTO zaj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ila viwengile mdipanga, hawaluvikile lukuli lwa Mndewa Yesu. ");
INSERT INTO zaj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Viwakalile wang'hali wokanganya mbuli ija, bahaja walawilila wanhu wabili wavalile mikanzu inang'hazika, wema behi nao. ");
INSERT INTO zaj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Waja iwatwanzi wafugama mavindi wokona bwembwe ng'hani, ila waja wanhu wawalongela, “Habali mumzahila munhu mgima mwa wanhu wadanganhike? ");
INSERT INTO zaj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kahaduhu hano, kazuka. Kumbukileni chayawalongele vayakalile yang'hali Galilaya. ");
INSERT INTO zaj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mwana wa Munhu kolondigwa yageligwe mmakono ga wanhu wene vilozo, na womuwamba mumsalaba, na zua da ikadatu kozuka.’ ” ");
INSERT INTO zaj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aho waja iwatwanzi wakumbukila mbuli zake, ");
INSERT INTO zaj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","wabwela kulawa kudipanga, na kuzilonga mbuli zija zose mwa wanahina longo dimwe na imwe na mwa wanhu wose wasigale. ");
INSERT INTO zaj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Watwanzi waja wakala Maliamu kulawa kiwambo cha Magidala, Yoana, na Maliamu mamaake Yakobo. Wao hamoja na watwanzi wayagwe wazilonga mbuli zino mwa watumigwa wa Kilisto. ");
INSERT INTO zaj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ila watumigwa wa Kilisto wagiza gaja gawalongile waja iwatwanzi ukala uponela, avo hawawategeleze. ");
INSERT INTO zaj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ila Petulo kenuka kakimbila kachola kudipanga, kainamila kasungulila, kona isanda iiyeka. Abaho, kasegela haja hana dipanga kabwela ukae, kuno yokanganya gaja galawilile. ");
INSERT INTO zaj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Zua didija wanahina zake Yesu wabili wakala wochola kukiwambo kimwe kikemigwa Emau mwanza wa masaa mabili kulawa Yelusalemu, ");
INSERT INTO zaj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","wakala wolongelela, wogalonga gaja gose galawilile. ");
INSERT INTO zaj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Viwakalile wolongelela kuno wokiiuzagiza, Yesu mwenyego kawakwenhukila kailongoza nao. ");
INSERT INTO zaj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Wamona, ila meso gao gazuilwa sambiwamtange. ");
INSERT INTO zaj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu kawauza, “Mbuli zaki hizo zimuisimulila mnzila?” Wema wanyamala tulu. Kuno vihanga visifukile. ");
INSERT INTO zaj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Munhu imwe mmwanza wao yokemigwa Kileopa kamuuza, “Gweye wiyeka iyo muhenza huzitangile mbuli zija zilawilile haja Yelusalemu mazua madodo gabitile?” ");
INSERT INTO zaj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kawauza, “Mbuli zaki?” Na hewo wamulongela, “Mbuli zimulawilile Yesu wa Nazaleti. Heyo kakala muhokozi mwene mhiko mmbuli ziyalongile na zija ziyatendile hameso ga Mulungu na hameso ga wanhu. ");
INSERT INTO zaj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wakulu wa wakulu wa nhambiko na wakulu zetu wa isi wamgela mnhaguso ya ifa, avo kawambigwa mumsalaba. ");
INSERT INTO zaj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ila tweye tutamanila kamba heyo iyo yondayaikombole isi ya Islaeli! Tuhagaleka higo gose, lelo zua da ikadatu songela vigalawilile gano. ");
INSERT INTO zaj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Vivija watwanzi wayagwe wa mdidale jetu watusinhusa, waidamuka wachola kudipanga, ");
INSERT INTO zaj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ila hawaluvikile lukuli lwake. Wabwela walonga wawona wasenga wa Mulungu wa kuulanga, wawalongela kamba Yesu mgima. ");
INSERT INTO zaj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wanhu wayagwe wakalile mdale jetu wachola kudipanga wavika vivija kamba viwalongile watwanzi waja, ila hawamonile.” ");
INSERT INTO zaj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Abaho, Yesu kawalongela, “Habali muli wabozi kamba avo, na habali muli na mioyo izalame kuzitogola mbuli zose zawalongile wahokozi? ");
INSERT INTO zaj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Vino Kilisto Mkombola halondigwa yagaye m'vinhu kamba avo, abaho, yengile muyenzi yake?” ");
INSERT INTO zaj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Avo Yesu kawasimulila mbuli zimulonga heyo mwenyego muna Zinyandiko Zing'alile, songela vitabu va Musa na Nyandiko Zing'alile za wahokozi wose wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Viwakwenhukile ikiwambo chawakalile wochola, Yesu kaitenda kamba vija kogendelela na mwanza, ");
INSERT INTO zaj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ila wamuyalalila ng'hani, wolonga, “Kala hano na tweye, kwavija zua diswa na ziza dingila.” Avo kengila mng'anda kakala na hewo. ");
INSERT INTO zaj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kakala hasi yaje nao mandia, kasola mkate, kamuheweza Mulungu, abaho, kaumogola kawagwelela. ");
INSERT INTO zaj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Baho meso gao gagubuka, wamtanga, ila heyo kayangayuka havihanga vao. ");
INSERT INTO zaj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wakiilongela, “Mioyo yetu haiding'huke ng'hani na ndeng'helelo, kipigiti viyakalile yolonga na tweye mnzila na kutugubulila Zinyandiko Zing'alile?” ");
INSERT INTO zaj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bahaja wenuka wabweleganya Yelusalemu, wawavika waja wanahina longo dimwe na imwe waiting'hana hamoja na wanhu wayagwe, ");
INSERT INTO zaj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","na kulonga, “Kweli Mndewa kazuka na kamulawilila Simoni!” ");
INSERT INTO zaj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Baho waja wanhu wabili wasimulila gaja gawalawilile mnzila na avija viwamtambule Mndewa kipigiti viyakalile youmogola umkate. ");
INSERT INTO zaj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kipigiti waja iwanahina wabili hawanamambukiza kuwapetela gano, bahaja Mndewa mwenyego kema mdidale jao, kawalongela, “Tindiwalo diwe hamoja namwe.” ");
INSERT INTO zaj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wasinhuka na kona bwembwe wagiza wakala wokona mzimu. ");
INSERT INTO zaj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ila heyo kawauza, “Habali mkona bwembwe? Habali mdungwadungwa mmioyo yenu? ");
INSERT INTO zaj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Loleni makono gangu na magulu gangu. Mwone kamba iyo nene. Nibabaseni mwone kamba nie sio mzimu, kwavija mzimu wabule lukuli na mizege kamba vumnyona nie vinili.” ");
INSERT INTO zaj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kagalonga gano na kuno yowalagusila makono na magulu gake. ");
INSERT INTO zaj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Wakala wamemile ndeng'helelo ng'hulu ng'hani na mkanganyo kuno wang'hali hawanatogola kamba iyo heyo, avo kawauza, “Mna kinhu chochose hano cha kuja?” ");
INSERT INTO zaj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wamgwelela kidanga cha somba kibanikigwe, ");
INSERT INTO zaj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","kakisola kakija hameso gao. ");
INSERT INTO zaj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Abaho, kawalongela, “Iyo inhegulo ya zimbuli ziniwalongele kipigiti vinikalile ning'hali na mweye, ilondigwa gatendeke gose ganyandikiligwe muna Gamalagizo ga Musa na muna ivitabu va wahokozi na muna ikitabu cha Zabuli.” ");
INSERT INTO zaj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Abaho, kawavugula zinzonzi zao wazimanye Zinyandiko Zing'alile, ");
INSERT INTO zaj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","kawalongela, “Yandikigwa vino, Kilisto kolondigwa yagazigwe, abaho, yadanganhike na mdizua da ikadatu yazuke, ");
INSERT INTO zaj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","na mtwaga jake, usenga wa kuwazuma wanhu waleke vilozo na kugeligwa kumgongo vilozo vao wopetigwa muisi zose kusongela Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mweye iwo wasindila wa mbuli zino. ");
INSERT INTO zaj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na nie mwenyego nowalagizila gaja gamuilagane na Tataangu. Ila kaleni himo mdiwambo mbaka vondamgweleligwe mhiko kulawa kuulanga.” ");
INSERT INTO zaj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Abaho, kawalongoza kawagala hanze ya idiwambo mbaka Betania, aho kenula makono gake kawamoteza. ");
INSERT INTO zaj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Viyakalile yowamoteza, kainega na hewo, abaho, kasoligwa kachola kuulanga. ");
INSERT INTO zaj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wamfugamila mavindi wamtambikila, abaho, wabweleganya Yelusalemu, kuno wodeng'helela ng'hani, ");
INSERT INTO zaj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","na kipigiti chose wakala Kuing'anda ya Mulungu womuheweza Mulungu.");
INSERT INTO zaj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Haichanduso kukala na Mbuli, Mbuli ija kakala na Mulungu, na Mbuli ija kakala Mulungu. ");
INSERT INTO zaj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Songela haichanduso Mbuli kakala na Mulungu. ");
INSERT INTO zaj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mulungu kavilumba vinhu vose kubitila heyo, haduhu kinhu chochose kilumbigwe na Mulungu bila heyo. ");
INSERT INTO zaj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mbuli ija kakala iyo ichanduso cha ugima, na ugima uno uwo ugala mulangaza mwa wanhu wose. ");
INSERT INTO zaj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mulangaza uno womulika mdiziza, na ziza hadidaha kuuhuma. ");
INSERT INTO zaj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mulungu kamtuma munhu imwe yokemigwa Yohana, ");
INSERT INTO zaj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","keza kamba msindila, giladi yalave usindila wa mulangaza uja, avo wanhu wose watogole kubitila heyo. ");
INSERT INTO zaj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Heyo mwenyego hakalile mulangaza, ila keza kamba msindila wa mulangaza. ");
INSERT INTO zaj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Uno uwo mulangaza wa kweli, uwamwemwesa wanhu wose, ukalile ukwiza muulumwengu. ");
INSERT INTO zaj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Heyo iyo mulangaza ukalile muulumwengu, avo Mulungu kaulumba ulumwengu mkubitila heyo, ila ulumwengu haumtangile. ");
INSERT INTO zaj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Keza mwa wanhu zake mwenyego, ila wanhu zake mwenyego hawam'bokele. ");
INSERT INTO zaj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ila wanhu wose wam'bokele na kumtogola, kawagwelela udaho wa kuwa wana wa Mulungu, ");
INSERT INTO zaj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","awo watendigwe wawe wana wa Mulungu si sama ya mulopa ama sama ya manogelwa ga lukuli ama sama ya manogelwa ga munhu, ila sama ya manogelwa ga Mulungu. ");
INSERT INTO zaj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mbuli kagaluka munhu, kakala hamoja na tweye. Tuyona yenzi yake, yenzi ya kamba mwana imwe yeiyeka wa Tata, yamemile ngekewa na kweli. ");
INSERT INTO zaj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana kazipeta mbuli zake Yesu. Kenula dizwi yolonga, “Ino iyo munhu inikalile nimulonga, avija vinilongile, ‘Kokwiza hachugu changu, ila heyo iyo mkulu kubanza nie, kwavija kipigiti nie sinavumbuka heyo kakala baho.’ ” ");
INSERT INTO zaj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Avija viyamemile ngekewa tweye tose tubokela motelo zose. ");
INSERT INTO zaj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mulungu katugwelela Malagizo kubitila Musa, ila ngekewa na kweli viza kubitila Yesu Kilisto. ");
INSERT INTO zaj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Haduhu munhu yoyose yamonile Mulungu, ila Mwana yeiyeka, ayo yali hamgwazo wa Tata, iyo yamtendile Tata yatangigwe. ");
INSERT INTO zaj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Uno uwo usindila uyalavile Yohana kipigiti wakulu wa Wayahudi viwawatumile wakulu wa nhambiko na Walawi kulawa Yelusalemu wakamuuze, “Gweye iyo yalihi?” ");
INSERT INTO zaj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohana kawedika kawalongela kinaganaga, “Nie sili Kilisto.” ");
INSERT INTO zaj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Wamuuza, “Kumbe gweye iyo yalihi? Gweye kwa Eliya?” Yohana kawalongela, “Nie sili Eliya.” Wamuuza, “Gweye kwa Muhokozi ija?” Kawalongela, “Nie sili Muhokozi ija.” ");
INSERT INTO zaj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wamulongela, “Basi tulongele gweye iyo yalihi? Giladi tukawalongele waja watutumile. Mzingelegeza zako gweye mwenyego koilongaze?” ");
INSERT INTO zaj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohana kalonga, kuno yokwiga mbuli za Muhokozi Isaya, yolonga, “Nie dijo ‘Dizwi da munhu yoguta muluwala, Igoloseni nzila yondayabite Mndewa.’ ” ");
INSERT INTO zaj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Waja iwasenga, watumigwe na Mafalisayo, ");
INSERT INTO zaj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","wamuuza Yohana, “Kamba gweye huli Kilisto ama Eliya ama Muhokozi ija, habali ubatiza?” ");
INSERT INTO zaj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana kawalongela, “Nie nobatiza na mazi, ila mmwanza wenu mweye mwimile aho kema munhu hamumtangile. ");
INSERT INTO zaj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ayo yondayeze hachugu changu, nie silumba hata kudohola nzabi za ng'hwabasa zake.” ");
INSERT INTO zaj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mbuli zino zose zilawilila mkiwambo cha Betania ng'ambu ya ulawilo wa zua ya Lwanda lwa Yolodani, aho Yohana hayakalile yobatiza. ");
INSERT INTO zaj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Zua da ikabili Yohana kamona Yesu yokwiza, kalonga, “Lola! Mwana Ng'hondolo wa Mulungu yosola vilozo va ulumwengu! ");
INSERT INTO zaj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ino iyo munhu inikalile nimulonga, ‘Kokwiza munhu hachugu changu, yali mkulu kubanza nie, kwavija kakala baho kipigiti nie sinavumbuka.’ ");
INSERT INTO zaj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nie mwenyego simtangile kamba heyo iyo Kilisto, ila nie niza kubatiza na mazi sama ya kilamso kino, siku kogubuligwa mwa wanhu wa Islaeli.” ");
INSERT INTO zaj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Na Yohana kalava usindila uno, yolonga, “Nimona Loho wa Mulungu yohumuluka kulawa kuulanga kamba hua na kukala uchana yake. ");
INSERT INTO zaj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nie sambinimtange, ila ayo yandagize nie kubatiza na mazi, kanongela, ‘Uhamona Loho wa Mulungu yohumuluka na kukala uchana ya munhu, iyo, iyo munhu yondayabatize na Loho wa Mulungu.’ ");
INSERT INTO zaj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na nie nigona gano, na nilava usindila kamba, ino iyo Mwana wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Zua da ikabili Yohana kakala yemile kabili bahaja na wanahina zake wabili, ");
INSERT INTO zaj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","viyamuwene Yesu yobita behi na hewo, kalonga, “Loleni! Mwana Ng'hondolo wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Waja iwanahina wabili viwamuhulike yolonga gano, wamkweleleza Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu viyahinduke kawona womkweleleza, kawauza, “Mozahila choni?” Wamuuza, “Labi, kwahi kuukala?” “Labi,” nhegulo yake “Mkulufunzi.” ");
INSERT INTO zaj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu kawalongela, “Izoni mulole.” Avo wachola wahone haja hayakalile yokala, na wakala na heyo zua dija jose. Ikala kamba saa longo dimwe ichungulo. ");
INSERT INTO zaj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Imwe wa wanahina waja wabili yamuhulike Yohana yolonga na kumkweleleza Yesu kakala Endelea mkulu wake Simoni Petulo. ");
INSERT INTO zaj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kinhu cha ichanduso kiyatendile Endelea kikala kumzahila ndugu yake Simoni na kumulongela, “Tumona Masihi.” Mbuli ino nhegulo yake iyo, “Kilisto.” ");
INSERT INTO zaj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Abaho, kamsola kamgala ha Yesu. Yesu kamulola kalonga, “Twaga jako kokemigwa Simoni, mwana wa Yohana, ila songela lelo kokemigwa Kefa.” Twaga dino nhegulo yake iyo “Dibwe.” ");
INSERT INTO zaj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Zua da ikabili Yesu kalonda kuchola Galilaya, kam'vika Filipo kamulongela, “Nikoleleze.” ");
INSERT INTO zaj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo kakala yolawa Betisaida, kiwambo chawakalile wokala Endelea na Petulo. ");
INSERT INTO zaj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo kamzahila Natanieli kamulongela, “Tumona munhu ayo Musa yandike mbuli zake mkitabu cha Malagizo na ayo vivija wahokozi wandike mbuli zake, Yesu, mwana wa Usufu, kulawa Nazaleti.” ");
INSERT INTO zaj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanieli kauza, “Vodahika kinhu kinogile kilawe Nazaleti?” Filipo kalonga, “Izo ulole.” ");
INSERT INTO zaj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu viyamuwene Natanieli yokwiza, kalonga, “Lola! Ino iyo Muislaeli mwenyego kabisa, mduhu uzenzeleganye mmoyo wake!” ");
INSERT INTO zaj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanieli kamuuza, “Kunitangaze?” Yesu kalonga, “Nikona vuukalile hasi ya umtini kipigiti Filipo hanakukema.” ");
INSERT INTO zaj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanieli kalonga, “Mkulufunzi, gweye kwa Mwana wa Mulungu! Gweye kwa Mndewa wa Islaeli!” ");
INSERT INTO zaj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu kamulongela, “Kutogola kwavija nikulongela nikona vuukalile hasi ya umtini? Avo kovona vinhu vikulu kubanza vino!” ");
INSERT INTO zaj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Abaho, kawalongela, “Nowalongela ikweli, mowona ulanga uvuguka na wasenga wa Mulungu wa kuulanga wokwela na kunihumulukila nie Mwana wa Munhu.” ");
INSERT INTO zaj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Zua da ikadatu kukala na lusona lwa zengele mkiwambo kikemigwa Kana muisi ya Galilaya. Mamaake Yesu kakala bahaja. ");
INSERT INTO zaj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu na wanahina zake vivija wagonekigwa hana ulusona luja lwa zengele. ");
INSERT INTO zaj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Divai viimalile, mamaake Yesu kamulongela, “Wabule divai.” ");
INSERT INTO zaj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu kamulongela, “Mama, gano gavikaze kumwetu? Kipigiti changu hakinavika.” ");
INSERT INTO zaj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Abaho, mamaake Yesu kawalongela waja wakalile wosang'hanika na vakuja, “Tendeni chochose chondayawalongele.” ");
INSERT INTO zaj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Haja kukala na minongo sita ya mazi itendigwe na mabwe, na kila nongo dimwe dikala na ukulu wa nongo mbili ama ndatu kwavija Wayahudi wakala na nzoela ya kuinava makono na magulu. ");
INSERT INTO zaj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu kawalongela waja wakalile wosang'hanika, “Memezeni mazi minongo ino.” Avo wamemeza minongo yose mbaka hamulomo. ");
INSERT INTO zaj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Abaho, kawalongela, “Haya, deheni vimazi vidodo mkamgwelele mkulu wa ulusona.” Wasola gamazi wamgalila mkulu wa ulusona. ");
INSERT INTO zaj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mkulu wa ulusona viyagalanzile gamazi gakalile gagaluke divai, kakanganya kwahi kuilawile divai ija. Ila waja wakalile wosang'hanika na ulusona wadehile gamazi wavitanga, avo kamkema imulawilamhambe, ");
INSERT INTO zaj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","kamulongela, “Wanhu wose wagomelaga divai inogile haichanduso, na iwahenza wehesha kung'wa ng'hani kowagomela divai igwaduke, ila gweye kwika divai inogile mbaka vino!” ");
INSERT INTO zaj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu katenda mzonza uno wa mwanduso mkiwambo cha Kana muisi ya Galilaya, aho hayailaguse yenzi yake, na wanahina zake wamtogola. ");
INSERT INTO zaj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Abaho Yesu na mamaake, wandugu zake, na wanahina zake wachola Kapenaumu, wakala haja mazua madodo. ");
INSERT INTO zaj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Lusona lwa Pasaka lwa Wayahudi lukala lukwenhuke, avo Yesu kachola Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Akuja kung'anda ya Mulungu kawavika wanhu woguza ng'ombe, ng'hondolo, na nziwa, na wavunja hela wakala wakalile mzimeza zao. ");
INSERT INTO zaj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Avo kasola nzabi kogosa lukumbulu, kasonga kuwawinga waja iwang'onyo wose yowalava hanze ya Ing'anda ya Mulungu, ng'hondolo hamoja na ng'ombe. Kazihindula zimeza za wavunja hela na kuzipwililisa zihela zao, ");
INSERT INTO zaj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","na kawalongela awo wakalile woguza nziwa, yolonga, “Wasegezeni nziwa zenu hano! Lekeni kutenda Ng'anda ya Tataangu kuwa gulilo!” ");
INSERT INTO zaj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wanahina zake wakumbukila avija Zinyandiko Zing'alile vuzilonga, “Nogelwa iniinogele ng'anda yako, Mulungu, yondukuza kamba moto.” ");
INSERT INTO zaj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Wakulu wa Wayahudi wamwidika mkumuuza, “Mzonza ulihi wondautulagusile tuvitange kamba kuna udaho wa kutenda mbuli zino?” ");
INSERT INTO zaj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu kawalongela, “Bomoleni Ng'anda ino ya Mulungu, na nie noizenga kabili mmazua madatu.” ");
INSERT INTO zaj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Wamuuza, “Kodahaze gweye kuizenga kabili mmazua madatu? Ng'anda ino ya Mulungu isola milao malongo mane na sita kumambukiza kuizenga!” ");
INSERT INTO zaj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ila ng'anda ya Mulungu iyailongile Yesu ikala lukuli lwake. ");
INSERT INTO zaj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Viyazukile kulawa mkudanganhika, wanahina zake wakumbukila kamba kakala yalongile gano, na wazitogola Zinyandiko Zing'alile na gaja Yesu gayalongile. ");
INSERT INTO zaj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kipigiti cha Lusona lwa Pasaka Yesu kakala Yelusalemu, wanhu bwando viwonile mizonza iyaitendile wamtogola. ");
INSERT INTO zaj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ila Yesu haitogole nhogola yao, kwavija kautanga uzenzeleganye wa wanhu. ");
INSERT INTO zaj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Halondile munhu yoyose yamulongele mbuli za wanhu waja, kwavija heyo mwenyego kagatanga gaja gakalile mmioyo yao. ");
INSERT INTO zaj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kukala na munhu yokemigwa Nikodemo, imwe wa wakulu wa Ikitala Kikulu cha Isi ya Wayahudi, yakalile Mfalisayo. ");
INSERT INTO zaj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kachola ha Yesu ikilo, kamulongela, “Mkulufunzi, tuvimanya kamba gweye kwa mkulufunzi ugaligwe na Mulungu. Kwavija haduhu munhu yondayadahe kutenda mizonza yuutenda kamba Mulungu hali hamoja na heyo.” ");
INSERT INTO zaj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu kamulongela, “Nokulongela ikweli, munhu kamba havumbuke mwanza wa ikabili hadaha kuwona Undewa wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo kamuuza, “Vodahikaze munhu m'vyele kuleligwa kabili? Havidahika kwingila muinda ya mamaake na kuvumbuka mwanza wa ikabili!” ");
INSERT INTO zaj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu kamulongela, “Nokulongela ikweli, haduhu munhu yondayengile Muundewa wa Mulungu kamba havumbuke na mazi na Loho. ");
INSERT INTO zaj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kivumbuke na lukuli chowa lukuli, na kivumbuke na Loho wa Mulungu chowa loho. ");
INSERT INTO zaj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Sambiukanganye kwavija nikulongela kamba mose molondigwa m'vumbuke kabili. ");
INSERT INTO zaj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ubeho ucholaga kuulonda, na mweye mohulika kisindo chake, ila mweye hamuutanga kuulawa ama kuuchola. Vivo ili na waja wose wavumbuke Muloho wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo kauza, “Yowaze mbuli ino?” ");
INSERT INTO zaj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu kamulongela, “Gweye kwa mkulufunzi muisi ya Islaeli, hugatangile gano? ");
INSERT INTO zaj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nokulongela ikweli, tolonga gaja tugamanyile na tosimulila gaja gatonile, ila haduhu munhu yoyose mmwanza wenu youtogola usenga wetu. ");
INSERT INTO zaj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Niwalongela mbuli za muulumwengu na hamzitogola, motogolaze kamba nihawalongela mbuli za kuulanga? ");
INSERT INTO zaj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Haduhu munhu yoyose yakwelile kuulanga ila ayo yahumuluke kulawa kuulanga, nie, Mwana wa Munhu. ");
INSERT INTO zaj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Kamba Musa viyamwinule nyoka kuluwala, vivija na Mwana wa Munhu kolondigwa yenuligwe, ");
INSERT INTO zaj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","giladi yoyose yondayamtogole yeng'higwe ugima wa digunge. ");
INSERT INTO zaj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kwavija Mulungu kaunogela ulumwengu avo kamulava Mwanage imwe yeiyeka, giladi yoyose yondayamtogole sambiyadanganhike, ila yawe na ugima wa digunge. ");
INSERT INTO zaj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kwavija Mulungu hamgalile Mwanage muulumwengu yeze kuutagusa ulumwengu, ila ulumwengu ukomboligwe kubitila heyo. ");
INSERT INTO zaj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Awo womtogola Mwana hawatagusigwa. Ila awo woleka kumtogola wesha kutagusigwa, kwavija hawamtogole Mwana yeiyeka wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na ino iyo nhaguso, mulangaza wiza muulumwengu, ila wanhu wanogelwa na ziza na kuwihila umulangaza, kwavija sang'hano zao ziha. ");
INSERT INTO zaj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Awo wose wotenda mbuli zihile wowihila mulangaza, na haweza kuna umulangaza kwavija hawalonda mbuli zao zihile zoneke. ");
INSERT INTO zaj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Waja wotenda mbuli zinogile wokwiza kuna umulangaza, giladi yoneke kamba sang'hano zao zitendeka kubitila Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Abaho Yesu na wanahina zake wachola ng'ambu ya Yudea, kakala hiko mkipigiti kidodo na kubatiza. ");
INSERT INTO zaj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohana na heyo kakala yobatiza ako Ainoni behi na Salimu, kwavija hanhu haja kukala na mazi bwando. Wanhu wamgendela na heyo kawabatiza. ");
INSERT INTO zaj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mbuli zino zilawilila kipigiti Yohana hanageligwa mkifungo. ");
INSERT INTO zaj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Wanahina wa Yohana wasonga kuibamilila na Muyahudi imwe muimbuli ya nzoela ya kusuluza magulu na makono. ");
INSERT INTO zaj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Avo wachola ha Yohana wamulongela, “Mkulufunzi, munhu ija yakalile na gweye mwambu wa ikabili wa Ulwanda lwa Yolodani, ija iumulongile kamba iyo Kilisto, na heyo kobatiza, na wanhu wose womgendela.” ");
INSERT INTO zaj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohana kawalongela, “Haduhu munhu yodaha kupata kinhu chochose kamba hagweleligwe na Mulungu. ");
INSERT INTO zaj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mweye wenyego iwo wasindila zangu haja hanilongile, ‘Nie sili Kilisto, ila nitumigwa nimulongole.’ ");
INSERT INTO zaj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mhambe mwenyego mulawilamhambe, mbwigaake mulawilamhambe kokwima na kumtegeleza mulawilamhambe, yahadihulika dizwi da mulawilamhambe kodeng'ha ng'hani. Avo sama ya kilamso kino ndeng'ha yangu ivikila. ");
INSERT INTO zaj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Vinoga heyo yabanze na nie nihungule.” ");
INSERT INTO zaj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ayo yezile kulawa uchana kawabanza wose. Ayo yezile kulawa muisi ka munhu wa muisi, na kolonga mbuli za muisi. Ila ayo yezile kulawa kuulanga kawabanza wose. ");
INSERT INTO zaj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kolonga gaja gayonile na kugahulika, ila haduhu munhu yozitogola mbuli zake. ");
INSERT INTO zaj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ila munhu yondayatogole mbuli zake kosindila kamba Mulungu iyo ikweli. ");
INSERT INTO zaj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Munhu yatumigwe na Mulungu kopeta mbuli za Mulungu, kwavija Mulungu komgwelela Loho wake bila mhima. ");
INSERT INTO zaj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tata komnogela Mwana avo keka vinhu vose mmakono gake. ");
INSERT INTO zaj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Munhu yoyose yomtogola Mwana kana ugima wa digunge, ila yoyose yomulema Mwana hawona ugima kwavija lusango lwa Mulungu lowa hamoja na heyo. ");
INSERT INTO zaj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mafalisayo wahulika kamba Yesu kowapata na kuwabatiza wanahina bwando kum'banza Yohana. ");
INSERT INTO zaj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ila Yesu mwenyego ham'batize munhu yoyose, ila wanahina zake wawo wabatize. ");
INSERT INTO zaj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu viyahulike gano, kasegela muisi ya Yudea kabwela muisi ya Galilaya, ");
INSERT INTO zaj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","kabita nzila ibitile muisi ya Samalia. ");
INSERT INTO zaj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kavika mkiwambo kimwe muisi ya Samalia kikemigwa Sikali, behi na mgunda wa Yakobo uyakalile yaamgwelele mwanage, Usufu. ");
INSERT INTO zaj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Haja kukala na sima da Yakobo, na Yesu, avija viyadonhile na umwanza, kakala hasi hamgwazo wa idisima. Ikala saa sita imisi. ");
INSERT INTO zaj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mtwanzi wa Kisamalia keza kudeha mazi, na Yesu kamulongela, “Nigwelele mazi ning'we.” ");
INSERT INTO zaj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Wanahina zake wakala wacholile kukiwambo kugula mandia. ");
INSERT INTO zaj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ija imtwanzi kamulongela, “Gweye kwa Muyahudi na nie na mtwanzi wa Kisamalia, konipulaze nie mazi ga kung'wa?” Kwavija Wayahudi hawasangilaga vinhu na Wasamalia. ");
INSERT INTO zaj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu kedika, “Kamba uhaimanyile nhunza ya Mulungu na uhammanyile ayo yokupula mazi ga kung'wa, uhampulile heyo na yahakugwelele mazi golava ugima.” ");
INSERT INTO zaj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ija imtwanzi kalonga, “Mndewa, kia cha kudehela kwabule na sima digidila, kwahi kondaugapate mazi higo gali na ugima? ");
INSERT INTO zaj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Gweye kwa mkulu kum'banza muhenga wetu Yakobo yatugwelele sima dino, na heyo mwenyego na wanage na madale gake ga ng'hondolo wose wang'wa mazi ga sima dino?” ");
INSERT INTO zaj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu kamulongela, “Wanhu wose wong'wa mazi gano wokona ng'hilu kabili, ");
INSERT INTO zaj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ila munhu yoyose yondayang'we mazi gondanimgwelele nie honda yone ng'hilu kabili. Mazi gondanimgwelele nie gogaluka nzokwe mgati yake, gondagamgwelele ugima wa digunge.” ");
INSERT INTO zaj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ija imtwanzi kalonga, “Mndewa, ngwelela mazi higo! Giladi sambinyone ng'hilu kabili, na sambinize hano kudeha mazi.” ");
INSERT INTO zaj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu kamulongela, “Genda kamkeme mbigalo wako, abaho, ubwele.” ");
INSERT INTO zaj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ija imtwanzi kedika, “Nabule mbigalo.” Yesu kamulongela, “Kulonga goya avija vuulonga kwabule mbigalo. ");
INSERT INTO zaj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kwavija kusoligwa na wambigalo watano, na mbigalo yuukala nayo sambi sio mbigalo wako. Kunongela ikweli.” ");
INSERT INTO zaj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ija imtwanzi kalonga, “Mndewa, nokona gweye kwa muhokozi. ");
INSERT INTO zaj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wahenga zetu wakala wotambika mkigongo kino, ila mweye mogong'ondeza kamba Yelusalemu baho hanhu ha kutambikila.” ");
INSERT INTO zaj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu kamulongela ija imtwanzi, “Nhegeleza nie, go mtwanzi, kipigiti chokwiza wanhu hawamtambikila Tata mkigongo kino ama kuja Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mweye motambikila kija hamkitangile, ila tweye tukitanga kija itukitambikila, kwavija ukombola wolawa mwa Wayahudi. ");
INSERT INTO zaj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ila kipigiti chokwiza na tena kipigiti kivika, watambika wa ikweli womtambikila Tata muloho na muikweli, kwavija Tata kowazahila wanhu wondawamtambikile kamba vino. ");
INSERT INTO zaj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mulungu iyo Loho, avo awo womtambikila wolondigwa wamtambikile muloho na muikweli.” ");
INSERT INTO zaj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ija imtwanzi kamulongela, “Nivitanga kamba Kilisto kokwiza, na yeheza, kotulongela kila kinhu.” ");
INSERT INTO zaj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu kamulongela, “Nie, inilonga nagwe, iyo Kilisto.” ");
INSERT INTO zaj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kipigiti kikija wanahina zake wabwela, wakanganya ng'hani viwam'vikile yolongelela na mtwanzi. Ila haduhu hata imwe mmwanza wao yamulongele, “Kolonda choni?” ama kumuuza Yesu, “Habali ulonga na mtwanzi ino?” ");
INSERT INTO zaj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Abaho, ija imtwanzi kaleka nongo yake ya mazi, kabweleganya kukiwambo na kuwalongela wanhu wakalile haja. ");
INSERT INTO zaj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Yolonga, “Izoni mmulole munhu yanongele kila kinhu kinhendile. Havidahika munhu ino kuwa iyo Kilisto?” ");
INSERT INTO zaj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Avo wasegela haja hakiwambo wachola kuyali Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kipigiti kikija wanahina zake wamuyalalila Yesu wolonga, “Mkulufunzi, uje mandia.” ");
INSERT INTO zaj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ila heyo kawalongela, “Nie nnago mandia ago mweye hamgamanyile.” ");
INSERT INTO zaj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Avo waja wanahina wasonga kukiiuza wenyego kwa wenyego, “Hana munhu yamgalile mandia?” ");
INSERT INTO zaj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu kawalongela, “Mandia gangu nie gago gano, kugatenda gaja gamnogele ayo yanhumile na kuimambukiza sang'hano yake. ");
INSERT INTO zaj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mnawo ulonzi ulonga, ‘Isigala milenge mine mulao ulawe.’ Ila nie nowalongela, loleni mmigunda, vakuja vipa visha avo volondigwa kuhunigwa. ");
INSERT INTO zaj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Muhuna vakuja kogendelela kulihigwa hata sambi, na heyo kokunzanya ivakuja yavike muugima wa digunge, avo yahandile na ayo yohuna wodeng'ha hamoja. ");
INSERT INTO zaj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kamba ulonzi uno vuulonga, ‘Imwe kohanda, iyagwe kohuna.’ ");
INSERT INTO zaj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Niwagala kuhuna vakuja mumgunda hamuulimile. Wanhu wayagwe iwo wasang'hanike, na mweye mpata fong'ha kulawa msang'hano yao.” ");
INSERT INTO zaj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wasamalia bwando kulawa mkiwambo kija wamtogola Yesu, sama ya gaja gayalongile ija imtwanzi, “Kanongela kila kinhu kinhendile.” ");
INSERT INTO zaj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Avo waja Wasamalia viwamwizile, wamuyalalila yakale na hewo, avo Yesu kakala haja mazua mabili. ");
INSERT INTO zaj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Wanhu wayagwe bwando wamtogola sama ya mbuli zake, ");
INSERT INTO zaj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","na wamulongela ija imtwanzi, “Tutogola si kwavija gweye kutulongela, ila kwavija tumuhulika tweye wenyego, na tuvitanga kamba heyo iyo Mkombola wa ulumwengu.” ");
INSERT INTO zaj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Vigabitile mazua mabili, Yesu kasegela haja kachola kuisi ya Galilaya. ");
INSERT INTO zaj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kwavija heyo mwenyego kalonga, “Muhokozi hahishimilwa muisi yake mwenyego.” ");
INSERT INTO zaj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Viyavikile Galilaya wanhu wa haja wam'bokela, kwavija wavona vinhu vose viyatendile Yelusalemu, kipigiti cha Ulusona lwa Pasaka, kwavija na hewo wakala wacholile kuna ulusona. ");
INSERT INTO zaj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Abaho, Yesu kabweleganya kuna ikiwambo cha Kana muisi ya Galilaya, ako kuyagalule mazi kuwa divai. Haja kukala na mkulu imwe wa silikali yakalile na mwanage mtamu ako Kapenaumu. ");
INSERT INTO zaj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Viyahulike kamba Yesu keza kulawa Yudea kwiza Galilaya, kamgendela na kumuyalalila yachole Kapenaumu yakamuhonye mwanage yakalile behi na kudanganhika. ");
INSERT INTO zaj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu kamulongela, “Kamba hamonile vilaguso na mikanganyo, hamtogola.” ");
INSERT INTO zaj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ija imkulu wa silikali kamulongela, “Mndewa, izo kipigiti mwanangu hanadanganhika.” ");
INSERT INTO zaj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu kamulongela, “Genda ukae yako, na mwanago kohona.” Ija imkulu wa silikali kazitogola mbuli za Yesu, avo kachola. ");
INSERT INTO zaj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Viyakalile yobwela ukae, mnzila kaiting'hana na nyakadala zake, wamulongela, “Mwanago kahona.” ");
INSERT INTO zaj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kawauza kipigiti kilihi mwanage chayahonile, wamulongela, “Ikala saa saba imisi mayo homa imsegela.” ");
INSERT INTO zaj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Avo ija tata wa imwana kakumbukila kamba kikala kipigiti kikija Yesu chayamulongele, “Mwanago kohona.” Avo heyo na mulango wake wose wamtogola Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Uno ukala mzonza wa ikabili waatendile Yesu viyalawile Yudea kuchola Galilaya. ");
INSERT INTO zaj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Abaho, Yesu kachola Yelusalemu kuna ulusona lwa Wayahudi. ");
INSERT INTO zaj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kuja Yelusalemu, behi na Lwivi lwa Ng'hondolo, kukala na bwawa dikemigwa Mkieblania “Betizata,” dikalile na mhelengo tano. ");
INSERT INTO zaj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Wanhu bwando wakalile watamu wakala wowasa mmhelengo zija, vimbugumbugu, mbetembete, na wanhu waholole wakala wobeta mazi gatibuke. ");
INSERT INTO zaj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kwavija watogola kamba kuna kipigiti msenga wa Mndewa wa kuulanga kohumuluka mdibwawa na kugatibula gamazi. Na mtamu wa ichanduso kwingila mdibwawa kipigiti msenga wa Mulungu yehesha kugatibula, kohonyigwa utamu wose uyalinao. ");
INSERT INTO zaj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Haja kukala na munhu yakalile mtamu mmilao malongo madatu na minane. ");
INSERT INTO zaj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu viyamonile munhu ija kawasa haja na viyavitangile kamba munhu ija kakala mtamu mkipigiti kitali, kamuuza, “Kolonda kuwa mgima?” ");
INSERT INTO zaj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ija imtamu kamwidika, “Mndewa, nie nabule munhu hano wa kunigela mdibwawa kipigiti mazi gahatibuligwa. Nihalonda kwingila, munhu iyagwe konilongola.” ");
INSERT INTO zaj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu kamulongela, “Ima wima, papa lusazi lwako utembele.” ");
INSERT INTO zaj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Bahaja ija imunhu kahona, kapapa lusazi lwake, kasonga kuchola. Mbuli ino ilawilila Mdizua da Mhumulo. ");
INSERT INTO zaj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Avo wakulu wa Wayahudi wamulongela ija imunhu yahonyigwe, “Lelo Zua da Mhumulo, malagizo getu gokugomesa gweye kupapa lusazi lwako.” ");
INSERT INTO zaj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Na heyo kawalongela, “Ija munhu yanihonyile kanilongela, ‘Papa lusazi lwako uchole.’ ” ");
INSERT INTO zaj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Wamuuza, “Iyo munhu yalihi yakulongele upape lusazi lwako uchole?” ");
INSERT INTO zaj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ila ija imunhu yahonyigwe kakala hamtangile kakala munhu yalihi, kwavija Yesu kakala yengile mdidale da wanhu dikalile haja. ");
INSERT INTO zaj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mkipigiti kiguhi hamwande, Yesu kam'vika ija imunhu Kuing'anda ya Mulungu, kamulongela, “Tegeleza, sambi kuhona, avo sambiutende vilozo kabili, ama vokulawilila vinhu viyagwe vihile ng'hani kubanza vino.” ");
INSERT INTO zaj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Abaho, ija imunhu kachola kuwalongela wakulu wa Wayahudi kamba Yesu iyo yamuhonyile. ");
INSERT INTO zaj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Avo wasonga kumgaza Yesu kwavija kahonya Mdizua da Mhumulo. ");
INSERT INTO zaj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu kawalongela, “Tataangu kosang'hanika mazua gose, na nie vivija nosang'hanika.” ");
INSERT INTO zaj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sama ya kilamso kino wakulu wa Wayahudi wazahila ng'hani nzila ya kumkomela, sio kwavija katenda gagomeswe Mdizua da Mhumulo, ila vivija kamkema Mulungu Tataake, avo kaitenda heyo kalinga na Mulungu. ");
INSERT INTO zaj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Avo Yesu kawedika yolonga, “Nowalongela ikweli, Mwana hadaha kutenda chochose heyo mwenyego, ila kotenda kija choyomona Tataake yotenda. Kija choyotenda Tata, kicho vivija Mwana choyotenda. ");
INSERT INTO zaj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kwavija Tata komnogela Mwanage na kamulagusila vinhu vose voyotenda heyo. Komulagusila vinhu vikulu ng'hani kubanza vino, na mweye mose mokwiza kukanganya. ");
INSERT INTO zaj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kamba vija Tata viyozusa wadanganhike na kuwabwezela ugima, vivija na Mwana kowabwezela ugima waja yoolonda kuwabwezela. ");
INSERT INTO zaj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tata hamtagusa munhu yoyose. Ila kamgwelela Mwanage udaho wose wa kutagusa, ");
INSERT INTO zaj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","giladi wanhu wose wamuhishimile Mwana kamba vija viwomuhishimila Tata. Munhu yoyose yondayaleke kumuhishimila Mwana, vivija hamuhishimila Tata yamtumile. ");
INSERT INTO zaj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nowalongela ikweli, munhu yoyose yondayazihulike mbuli zangu na kumtogola ayo yanhumile nie kana ugima wa digunge. Hatagusigwa, ila kabita kulawa mkudanganhika kengila muugima. ");
INSERT INTO zaj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nowalongela ikweli, kipigiti chokwiza na kipigiti kivika aho wanhu wadanganhike wodihulika dizwi da nie, Mwana wa Mulungu, na awo wondawadihulike wowa wagima. ");
INSERT INTO zaj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kamba vija Tata viyali na ugima mgati yake mwenyego, vivija kamtenda Mwanage yawe na ugima mgati yake mwenyego. ");
INSERT INTO zaj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na kanigwelela udaho wa kutagusa kwavija nie iyo Mwana wa Munhu. ");
INSERT INTO zaj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Sambimkanganye mbuli ino, kipigiti chokwiza aho wanhu wali mgamapanga vondawahulike dizwi jangu, ");
INSERT INTO zaj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na kulawa hanze ya igamapanga, awo watendile ganogile wozuka giladi wagweleligwe ugima wa digunge, na awo watendile gehile wozuka giladi wakehigwe. ");
INSERT INTO zaj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Nie sidaha kutenda kinhu chochose nene mwenyego, notagusa kamba vinihulika. Nhaguso yangu yabule uzenzeleganye, kwavija sizahila kuinogeza mwenyego ila kumnogeza ayo yanhumile. ");
INSERT INTO zaj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Kamba nihaisindila mwenyego, usindila wangu hautogoligwa kamba kweli. ");
INSERT INTO zaj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ila hana munhu iyagwe yonisindila nie, na munhu hiyo iyo Yohana, na nie nivitanga kamba gaja goyolonga gotogoligwa kamba kweli. ");
INSERT INTO zaj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Muwatuma wasenga zenu ha Yohana, na heyo kawalongela ikweli yose. ");
INSERT INTO zaj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nie silonda usindila kulawa mwa wanhu, ila nilonga gano giladi mkomboligwe. ");
INSERT INTO zaj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana kakala kamba kiwenge kilukula na kulava mulangaza, na mweye mulonda kudeng'helela mulangaza wake mkipigiti kiguhi. ");
INSERT INTO zaj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ila nie nna usindila mkulu ng'hani kubanza usindila yaawagwelele Yohana. Kwavija sang'hano ino initenda yaangwelele Tata niimambukize, ino inigendelela kuitenda, yolagusa kamba Tata iyo yanhumile. ");
INSERT INTO zaj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tataangu yanhumile vivija mwenyego kasindila sama yangu. Hamdihulike dizwi jake ama kuchona kiwiliwili chake, ");
INSERT INTO zaj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","na hamzikile mbuli zake mmioyo yenu, kwavija hamumtogole ayo iyamtumile. ");
INSERT INTO zaj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mozihimbula ng'hani Nyandiko Zing'alile, kwavija mokwagiza kamba mkutenda vino mokwing'higwa ugima wa digunge. Na Nyandiko Zing'alile zimuhimbula zizo zinilonga nie! ");
INSERT INTO zaj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Hata avo hamulonda kwiza kumwangu giladi mpate ugima. ");
INSERT INTO zaj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nie sizizahila nhogolwa kulawa mwa wanhu. ");
INSERT INTO zaj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ila niwamanya mweye mwa wanhu wa vilihi. Nivitanga kamba mweye mwabule noge da Mulungu mmioyo yenu. ");
INSERT INTO zaj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nie niza mtwaga da Tataangu, ila mweye hamunibokele. Ila kamba munhu yeheza mtwaga jake mwenyego, mom'bokela. ");
INSERT INTO zaj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kamba mweye mobokela nhogolwa zilawa mmwenu mwemwe wenyego, ila hamuiyoha mpate nhogolwa zilawa ha Mulungu yeiyeka, avo modahaze kutogola? ");
INSERT INTO zaj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Sambimgelegeze kamba nie niza kuwatagusa ha Tata. Musa, imumtamanila, iyo yondayawataguse mweye. ");
INSERT INTO zaj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kamba mweye mumtogola Musa, muhanitogole nie, kwavija kandika mbuli zangu. ");
INSERT INTO zaj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ila kamba hamgatogole gaja gayandike, mogatogolaze gonilonga?” ");
INSERT INTO zaj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Abaho Yesu kaloka Lamba da Galilaya, ama vivija vowodikemaga Lamba da Tibelia. ");
INSERT INTO zaj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Dale kulu da wanhu dimkweleleza, kwavija wayona mizonza iyatendile mwa watamu. ");
INSERT INTO zaj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu kakwela hakigongo, kakala hasi na wanahina zake. ");
INSERT INTO zaj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kipigiti cha Lusona lwa Wayahudi lukemigwa Pasaka kikwenhuka. ");
INSERT INTO zaj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu kalola uchana kona dale kulu da wanhu domwizila, kamulongela Filipo, “Tukagule kwahi mikate ya kuwegutiza wanhu wose wano?” ");
INSERT INTO zaj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kalonga gano giladi yamgeze, kwavija mwenyego kavimanya vija vondayatende. ");
INSERT INTO zaj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo kamwidika kalonga, “Kitumetume cha milenge minane hakidaha kugula mikate ya kumtenda kila imwe yapate kikate kidodo.” ");
INSERT INTO zaj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mwanahina wake iyagwe yokemigwa Endelea, mkulu wake Simoni, ayo vivija yokemigwa Petulo, kalonga, ");
INSERT INTO zaj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Hana mmhale hano kana mikate mitano ya mpunga na visomba vibili. Ila wangahi wondawaje mdidale dino jose?” ");
INSERT INTO zaj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu kalonga, “Walongeleni wanhu wakale hasi.” Haja kukala na visoti bwando. Avo wanhu wose wakala hasi, na wanhu wakalile haja wakala kamba wambigalo alufu tano vino. ");
INSERT INTO zaj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Abaho Yesu kaisola ija imikate, kamgwaa Mulungu hewela, kawagolela wanhu wakalile haja kamba viwalondile. Katenda vivija na ivisomba. ");
INSERT INTO zaj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wanhu wose viweigute, kawalongela wanahina zake, “Dondoleni ividanga va imikate isigale, sambikipotele chochose.” ");
INSERT INTO zaj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Avo wavidondola na kumemeza migelo longo dimwe na mibili imemile vidanga va imikate ya mpunga isigale iwadile iwanhu. ");
INSERT INTO zaj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Wanhu viwonile mzonza uno waatendile Yesu, walonga, “Kweli ino iyo Muhokozi yalongigwe kokwiza muulumwengu.” ");
INSERT INTO zaj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu kavitanga kamba wakala mmabehi kwiza kumgoga wamtende mndewa wao kwa shuluti, avo kasegela kabweleganya kukigongo yeiyeka. ");
INSERT INTO zaj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Viivikile ichungulo, wanahina zake Yesu wahumuluka kudilamba, ");
INSERT INTO zaj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","kilo vukisongile kwingila na Yesu kakala yang'hali hanabwela, wakwela mngalawa na kusonga kuloka idilamba wochola Kapenaumu. ");
INSERT INTO zaj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kukuzumbi dilawilila, na gamazi gasonga kutibuka. ");
INSERT INTO zaj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wanahina viwakalile wogela ng'hafi mwanza wa kilometa tano ama sita, wamona yesu yotembela uchana ya igamazi, yokwiza behi na ingalawa. Avo, wadumba ng'hani. ");
INSERT INTO zaj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesu kawalongela, “Sambimdumbe, nie iyo.” ");
INSERT INTO zaj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Avo wam'bokela mkudeng'ha, kengila mngalawa, na kipigiti kikija ingalawa ivika mulusanga, bahaja hawakalile wochola. ");
INSERT INTO zaj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Zua da ikabili wanhu bwando wakalile mwambu wa ikabili wa idilamba wakumbukila kamba haja kukala na ngalawa imwe, na Yesu hacholile na wanahina zake mngalawa ija, ila wachola weiyeka. ");
INSERT INTO zaj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ngalawa ziyagwe zikalile zizile kulawa kiwambo cha Tibelia zivika behi na hanhu haja wanhu hawadile imikate, Mndewa viyeshile kumgwaa hewela Mulungu. ");
INSERT INTO zaj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Wanhu viwonile kamba Yesu na wanahina zake wahaduhu, wengila mzingalawa zija, wachola Kapenaumu kumzahila Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wanhu viwam'vikile Yesu mwambu wa ikabili wa idilamba, wamulongela, “Mkulufunzi, kwiza zua jaki hano?” ");
INSERT INTO zaj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu kawalongela, “Nowalongela ikweli, monizahila si kwavija vumuyonile imizonza, ila kwavija muja imikate na kupata gaja gamulondile. ");
INSERT INTO zaj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Sambimsang'hanikile ng'hani mandia gaja gobanangika, ila sang'hanikileni mandia gondagakale mbaka kuugima wa digunge, ago nie, Mwana wa Munhu gondaniwagwelele. Mwa heyo Mulungu Tata keka kilagilo chake.” ");
INSERT INTO zaj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Abaho wamuuza, “Tutendeze giladi tugatende gaja Mulungu goyolonda tweye tugatende?” ");
INSERT INTO zaj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu kawalongela, “Kino kicho Mulungu choyolonda mumsang'hanikile, mumtogole ayo iyamtumile.” ");
INSERT INTO zaj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wamulongela, “Mzonza ulihi wondauutende tuwone, giladi tukutogole? Kotenda kinhu kilihi? ");
INSERT INTO zaj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wahenga zetu waja mana muluwala, kamba Zinyandiko Zing'alile vuzilonga, ‘Kawagwelela mkate kulawa kuulanga waje.’ ” ");
INSERT INTO zaj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu kawalongela, “Nowalongela ikweli, sio Musa yawagwelele mkate kulawa kuulanga, ila Tataangu iyo yowagwelela mkate wa ikweli kulawa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kwavija mkate wa Mulungu uwo heyo yohumuluka kulawa kuulanga, yolava ugima muulumwengu.” ");
INSERT INTO zaj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wamulongela, “Mndewa, tugwelele mkate uno mazua gose.” ");
INSERT INTO zaj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu kawalongela, “Nie iyo mkate wa ugima. Yoyose yondayeze kumwangu heza kona nzala, na yoyose yondayanitogole heza kona ng'hilu. ");
INSERT INTO zaj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ila kamba viniwalongele, munyona ila hamunitogola. ");
INSERT INTO zaj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wose waangwelele Tataangu wokwiza kumwangu, na yoyose yondayeze kumwangu simuwinga. ");
INSERT INTO zaj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kwavija nihumuluka kulawa kuulanga kutenda gaja goyolonda ayo yanhumile, na sio kutenda gaja ganilonda nie. ");
INSERT INTO zaj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na gano gago goyolonda ija yanhumile, sambinimwase munhu yoyose mmwanza wa waja waanigwelele, ila nolondigwa niwazuse wose wawe wagima mdizua da ikimambukizo. ");
INSERT INTO zaj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kwavija choyolonda Tataangu icho kino, wose wondawamone Mwana na kumtogola wopata ugima wa digunge. Na nowazusa wawe wagima mdizua da ikimambukizo.” ");
INSERT INTO zaj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Wayahudi wasonga kumtwanganikila, kwavija kalonga, “Nie iyo mkate uhumuluke kulawa kuulanga.” ");
INSERT INTO zaj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Walonga, “Munhu ino hali Yesu, mwanage Usufu? Tumtanga tataake na mamaake. Avo kolongaze kahumuluka kulawa kuulanga?” ");
INSERT INTO zaj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu kawedika, “Sambimtwanganike wenyego kwa wenyego. ");
INSERT INTO zaj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Haduhu munhu yodaha kwiza kumwangu kamba hakwegigwe na Tataangu yanhumile nie, na nie nomzusa yawe mgima mdizua da ikimambukizo. ");
INSERT INTO zaj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wahokozi wandika, ‘Wanhu wose wofundizigwa na Mulungu.’ Munhu yoyose yomuhulika Tata na kuifundiza kumwake kokwiza kumwangu. ");
INSERT INTO zaj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Haduhu munhu yamonile Tata, ila ayo yalawile ha Mulungu iyo yeiyeka yamonile Tata. ");
INSERT INTO zaj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nowalongela ikweli, ayo yondayatogole kana ugima wa digunge. ");
INSERT INTO zaj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nie iyo umkate wa ugima. ");
INSERT INTO zaj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wahenga zenu waja mana muluwala, ila wadanganhika. ");
INSERT INTO zaj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ila uno uwo mkate uhumuluka kulawa kuulanga, awo munhu youja hadanganhika. ");
INSERT INTO zaj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nie iyo mkate uli na ugima uhumuluke kulawa kuulanga. Kamba munhu yoyose yahauja mkate uno, kowa na ugima wa digunge. Mkate wondanimgwelele uwo lukuli lwangu nilulava giladi ulumwengu uwe na ugima.” ");
INSERT INTO zaj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Wayahudi wasonga kuibamilila ng'hani wenyego kwa wenyego wolonga, “Vodahikaze munhu ino yatugwelele lukuli lwake tuluje?” ");
INSERT INTO zaj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu kawalongela, “Nowalongela ikweli, kamba hamuludile lukuli lwa nie, Mwana wa Munhu, na kuung'wa mulopa wangu, mowa bule ugima mgati yenu. ");
INSERT INTO zaj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Awo woja lukuli lwangu na kuung'wa mulopa wangu wana ugima wa digunge, na nowazusa wawe wagima mdizua da hakimambukizo. ");
INSERT INTO zaj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwavija lukuli lwangu lulo mandia ga ikweli, na mulopa wangu uwo ung'waji wa ikweli. ");
INSERT INTO zaj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yoyose yondayaluje lukuli lwangu na kuung'wa mulopa wangu kokala mgati yangu, na nie nokala mgati yake. ");
INSERT INTO zaj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tata mwene ugima iyo yanhumile, na sama yake na nie nnao ugima. Vivija munhu yoyose yondayanije kowa na ugima sama yangu nie. ");
INSERT INTO zaj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Uno uwo mkate uhumuluke kulawa kuulanga. Wahenga zenu waja mana na viwadanganhike hawapatile ugima wa digunge. Ila awo wondawaje mkate uno wowa na ugima wa digunge.” ");
INSERT INTO zaj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu kagalonga gano viyakalile yofundiza mng'anda ya nhambiko ako Kapenaumu. ");
INSERT INTO zaj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Wanahina zake bwando viwahulike gano walonga, “Mafundo gano magaga. Yalihi yondayadahe kugabokela?” ");
INSERT INTO zaj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu kavitanga kamba wakala woitwanganikila mbuli ino, kawalongela, “Mbuli ino iwagevuza? ");
INSERT INTO zaj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yowaze kamba muhanyona nie, Mwana wa Munhu, nikwinuligwa kubweleganya kunikalile haichanduso? ");
INSERT INTO zaj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yagelaga ugima iyo Loho, mhiko za wanhu hazidaha chochose. Mbuli iniwalongele iyo Loho wa Mulungu yolava ugima. ");
INSERT INTO zaj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Hata avo hana wanhu mmwanza wenu hawagatogola.” Songela haichanduso Yesu kavitanga wanhu walihi wakalile hawamtogola na munhu yalihi yondayamuhonze. ");
INSERT INTO zaj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Abaho, kongeza kulonga, “Kino kicho kilamso cha kuwalongela kamba haduhu munhu yondayeze kumwangu kamba hagaligwe na Tata.” ");
INSERT INTO zaj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sama ya mbuli zino, wanahina zake bwando wabweleganya kuchugu, avo waleka kumkweleleza. ");
INSERT INTO zaj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Avo Yesu kawauza waja wanahina zake longo dimwe na wabili, “Na mweye vivija molonda kusegela?” ");
INSERT INTO zaj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petulo kamulongela, “Mndewa, tuchole ha munhu yalihi? Gweye kuna mbuli zili na ugima wa digunge. ");
INSERT INTO zaj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Na sambi tutogola na kuvitanga kamba gweye iyo Ung'alile wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu kamwidika yolonga, “Siwasagule mweye longo dimwe na wabili? Hata avo imwe mmwanza wenu Mwenembago!” ");
INSERT INTO zaj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kakala yagalongile gano yomulonga Yuda mwanage Simoni Isikalioti, ayo yakalile mmwanza wa wanahina longo dimwe na wabili, ayo hamwande yamuhonzile Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Abaho Yesu kakala yotembela muiisi ya Galilaya. Halondile kutembela muiisi ya Yudea kwavija wakulu wa Wayahudi wakala wolonda kumkoma. ");
INSERT INTO zaj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lusona lwa Vizewe lwa Wayahudi lukala lukwenhuke, ");
INSERT INTO zaj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","avo wandugu zake Yesu wamulongela, “Segela hano uchole Yudea, giladi wanahina zako wazone sang'hano zuutenda. ");
INSERT INTO zaj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Haduhu munhu yofisa mbuli zoyotenda kamba yahalonda kutangigwa na wanhu. Kamba kotenda mbuli zino, uilaguse muulumwengu.” ");
INSERT INTO zaj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kwavija hata wandugu zake hawamtogole. ");
INSERT INTO zaj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu kawalongela, “Kipigiti changu kinogile hakinavika, ila vipigiti vose kumwenu mweye vinoga. ");
INSERT INTO zaj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ulumwengu haudaha kuwehila mweye, ila wonihila nie, kwavija mazua gose noulongela kamba sang'hano zake ziha. ");
INSERT INTO zaj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mweye gendeni kulusona. Nie sichola kuna ulusona, kwavija kipigiti changu kinogile hakinavikila.” ");
INSERT INTO zaj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Viyamambukize kugalonga gano, kagendelela kukala muiisi ya Galilaya. ");
INSERT INTO zaj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wadodo zake viwacholile kulusona, Yesu na heyo kachola, ila hacholile mkuilagusa, ila mkuifisa. ");
INSERT INTO zaj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Wakulu wa Wayahudi wakala womzahila kuja kulusona, wauza, “Kakwahi?” ");
INSERT INTO zaj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kukala na nyong'onyo bwando mwa wanhu womnyong'onya heyo. Wanhu wayagwe walonga, “Munhu ino kanoga,” wayagwe walonga, “Hanogile, kowagiza wanhu.” ");
INSERT INTO zaj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ila haduhu yamulongile kinaganaga kwavija wakala wowadumba wakulu wa Wayahudi. ");
INSERT INTO zaj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Lusona vuluvikile mkindibwindibwi, Yesu kachola Kung'anda ya Mulungu na kusonga kufundiza. ");
INSERT INTO zaj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Wakulu wa Wayahudi wakanganya ng'hani walonga, “Munhu ino kozitangaze mbuli zino zose na kuno hafundizigwe na munhu yoyose?” ");
INSERT INTO zaj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu kalonga, “Kinifundiza nie sio mafundo gangu mwenyego, ila galawa ha Mulungu yanhumile. ");
INSERT INTO zaj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Munhu yoyose yosagula kugatenda gaja goyolonda Mulungu kovitanga kamba gano gonifundiza nie golawa ha Mulungu ama nolonga mbuli zangu mwenyego. ");
INSERT INTO zaj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Munhu yolonga mbuli zake mwenyego kozahila nhogolwa yake mwenyego. Ila munhu yosang'hanika sama ya nhogolwa ya ayo yamtumile iyo mwene ikweli, na mduhu dihile mgati yake. ");
INSERT INTO zaj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa hawagwelele Malagizo? Na haduhu hata munhu imwe mmwanza wenu yogazindilila Malagizo. Habali mulonda kunikoma?” ");
INSERT INTO zaj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Waja wanhu walonga, “Gweye kuna Mwenembago! Yalihi yondakukukoma?” ");
INSERT INTO zaj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu kawalongela, “Nitenda mzonza umwe, na mose msinhuka. ");
INSERT INTO zaj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa kawalagiza mweye muwengize kumbi wanenu. Hata avo sio Musa yasongile mbuli ino ila wahenga zenu. Avo mumwingiza kumbi mwana Mdizua da Mhumulo. ");
INSERT INTO zaj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kamba mwana kengizigwa kumbi Mdizua da Mhumulo giladi Malagizo ga Musa sambigadulukwe, habali basi munyonela lusango nie kwavija nimuhonya munhu utamu wake wose Mdizua da Mhumulo? ");
INSERT INTO zaj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Sambimumtaguse munhu kwavija voyoneka, ila mtaguseni muikweli.” ");
INSERT INTO zaj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Wanhu wayagwe wa Yelusalemu walonga, “Ino hali munhu ija woyolonda kumkoma? ");
INSERT INTO zaj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lola, kolongelela hakimwagaia, na wakulu hawalonga kinhu chochose cha kumtagusa. Yokoneka wavitanga kamba heyo iyo Kilisto? ");
INSERT INTO zaj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ila Kilisto vondayeze haduhu munhu yondayavitange koyolawa. Ila tweye tose tukutanga koyolawa munhu ino.” ");
INSERT INTO zaj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu viyakalile yofundiza Kung'anda ya Mulungu, kenula dizwi yolonga, “Nie munitanga na mkutanga kuja kunilawa. Sizile na udaho wangu mwenyego. Ayo yanhumile kabule uzenzeleganye, na mweye hamumtangile. ");
INSERT INTO zaj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ila nie nimtanga, kwavija niza kulawa kumwake, na heyo iyo yanhumile nie.” ");
INSERT INTO zaj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Avo, walonda kumgoga, ila haduhu munhu yamgolosele mkono wake, kwavija kipigiti chake kikala hakinavika. ");
INSERT INTO zaj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wanhu bwando wakalile mdidale dija wamtogola, walonga, “Kipigiti chondayeze Kilisto, kotenda mizonza kubanza ino yootenda munhu ino?” ");
INSERT INTO zaj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafalisayo wawahulika wanhu wonyong'onya mbuli zija womulonga Yesu, avo hewo na wakulu wa wakulu wa nhambiko wawatuma wemilizi wa Ng'anda ya Mulungu wakamgoge. ");
INSERT INTO zaj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu kalonga, “Nokala na mweye mkipigiti kidodo, abaho, nobwela ha ayo yanhumile. ");
INSERT INTO zaj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Monizahila ila hamunyona, na kondaniwe hamdaha kwiza.” ");
INSERT INTO zaj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wakulu wa Wayahudi wakiilongela wenyego kwa wenyego, wolonga, “Kwahi koyolonda kuchola kondatuleke kumona? Konda kuchola kuwapwililikile wanhu zetu muisi ya Ugiliki na kuwafundiza Wagiliki? ");
INSERT INTO zaj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mbuli ino nhegulo yake choni ahaja hayolongile, ‘Monizahila, ila hamunyona’ na ‘Kondaniwe, hamdaha kwiza’?” ");
INSERT INTO zaj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Zua da mgotoko wa ulusona dikala zua dinogelwe ng'hani na wanhu. Yesu kema kenula dizwi kalonga, “Munhu yoyose yali na ng'hilu na yeze kumwangu yang'we, ");
INSERT INTO zaj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","munhu yoyose yonitogola, kamba Nyandiko Zing'alile vuzilongile, ‘Lwanda lwa mazi golava ugima gotililika kulawa mmoyo wake.’ ” ");
INSERT INTO zaj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mazi gayalongile Yesu gakala Loho wa Mulungu, ayo waja wamtogole heyo wom'bokela. Kipigiti kija Loho wa Mulungu kakala yang'hali hanavika, kwavija Yesu kakala yang'hali hanayenzigwa. ");
INSERT INTO zaj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wanhu wayagwe wakalile mdidale dija wamuhulike Yesu yolonga gano walonga, “Munhu ino kweli iyo Muhokozi ija.” ");
INSERT INTO zaj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Wayagwe walonga, “Ino iyo Kilisto.” Ila wayagwe walonga, “Vodahikaze Kilisto yalawe muisi ya Galilaya? ");
INSERT INTO zaj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nyandiko Zing'alile hazilonga kamba Kilisto kokwiza kulawa mulukolo lwa Daudi, na kovumbuka muisi ya Betelehemu, kiwambo chayakalile yokala Daudi?” ");
INSERT INTO zaj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Avo wanhu wakiigola sama ya Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Wayagwe walonda kumgoga, ila haduhu yamgolosele mkono. ");
INSERT INTO zaj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wemilizi wabwela ha wakulu wa wakulu wa nhambiko na Mafalisayo, na hewo wawauza, “Habali hamumgogile?” ");
INSERT INTO zaj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wemilizi walonga, “Hatunamona munhu yolonga kamba viyolonga munhu ino!” ");
INSERT INTO zaj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mafalisayo wawauza, “Na mweye vivija kawavwizila? ");
INSERT INTO zaj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mmona munhu yoyose mmwanza wa wakulu wa wanhu ama Mfalisayo imwe yomtogola ino? ");
INSERT INTO zaj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Wanhu wano womuwinza ino hawagatangile Malagizo ga Musa, avo wokiigela mulusango lwa Mulungu!” ");
INSERT INTO zaj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Imwe wa Mafalisayo wakalile haja kakala Nikodemo, munhu yacholile kumona Yesu mazua ga kuchugu, kauza, ");
INSERT INTO zaj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Malagizo hagalonga kamba havidahika kumtagusa munhu yoyose kamba hatunamuhulika na kugatanga gaja gayatendile?” ");
INSERT INTO zaj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Walonga, “Gweye vivija kolawa Galilaya? Pelesa Zinyandiko Zing'alile na kokwiza kona kamba haduhu muhokozi yondayeze kulawa Galilaya.” ");
INSERT INTO zaj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Abaho, kila munhu kachola ukae yake. ");
INSERT INTO zaj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ila Yesu kachola Kukigongo cha Mizaituni. ");
INSERT INTO zaj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Imitondo ng'hani zua da ikabili kabweleganya Kung'anda ya Mulungu. Wanhu wose waiting'hana womzunguluka, na heyo kakala hasi kasonga kuwafundiza. ");
INSERT INTO zaj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wafundiza Malagizo ga Musa na Mafalisayo wamgalila mtwanzi yagogigwe muugoni. Wamwika haulongozi wao, ");
INSERT INTO zaj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","wamulongela, “Mkulufunzi, mtwanzi ino kagogigwa hadibugo yotenda ugoni. ");
INSERT INTO zaj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muna Gamalagizo, Musa katulagiza kamba, watwanzi kamba wano watoigwe na mabwe mbaka wadanganhike. Avo gweye kolongaze?” ");
INSERT INTO zaj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Wagalonga gano womwikila vitega Yesu giladi weze kumtagusa. Ila heyo kainamila yokwandika muisi na kidole chake. ");
INSERT INTO zaj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Waja wanhu wemile haja viwabanzilize kumuuzagiza, Yesu kenuka kawalongela, “Munhu yoyose mmwanza wenu yalibule vilozo yawe waichanduso kumwasila dibwe.” ");
INSERT INTO zaj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Abaho, kainamila kabili yokwandika muna iisi. ");
INSERT INTO zaj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Viwahulike gano, wose wasegela imweimwe, kusongela iwakulu mbaka iwadodo, kasigala Yesu yeiyeka na ija imtwanzi yemile bahaja. ");
INSERT INTO zaj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kenuka kamulongela ija imtwanzi, “Wakwahi? Haduhu hata imwe yakutaguse?” ");
INSERT INTO zaj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ija imtwanzi kalonga, “Haduhu hata imwe, Mndewa.” Yesu kalonga, “Vinoga, hata nie sikutagusa. Genda na zako ila sambiutende vilozo kabili.” ");
INSERT INTO zaj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu kawalongela wanhu kabili, “Nie iyo mulangaza wa ulumwengu. Munhu yoyose yong'hweleleza kowa na mulangaza ugala ugima na hatembela mdiziza kabisa.” ");
INSERT INTO zaj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mafalisayo wamulongela, “Gweye koisindila mwenyego, avo gano gaulonga hagatogoligwa kamba kweli.” ");
INSERT INTO zaj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu kawalongela, “Hata nihaisindila mwenyego, usindila wangu wotogoligwa kamba kweli, kwavija nikutanga kunilawa na kunichola, ila mweye hamkutangile kunilawa ama kunichola. ");
INSERT INTO zaj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mweye motenda nhaguso ya kiunhu, ila nie simtagusa munhu yoyose. ");
INSERT INTO zaj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Na kamba nihamtagusa munhu, nhaguso yangu ina kweli mgati yake, kwavija nie sili niiyeka muinhaguso ino, ila Tata yanhumile ka hamoja na nie. ");
INSERT INTO zaj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yandikigwa Mmalagizo genu kamba usindila wa wanhu wabili wotogoligwa kamba kweli. ");
INSERT INTO zaj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Niisindila mwenyego, na Tata yanhumile vivija konisindila.” ");
INSERT INTO zaj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wamuuza, “Tataako kakwahi?” Yesu kawalongela, “Hamunimanyile nie na Tataangu hamummanyile. Kamba muhanimanyile nie, vivija muhammanyile na Tataangu.” ");
INSERT INTO zaj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu kagalonga gano gose viyakalile yofundiza Kung'anda ya Mulungu, mdigati dija mkikigwe kia cha kulavila nhosa. Na haduhu munhu yagezile kumgoga, kwavija kipigiti chake cha kugogigwa kikala hakinavika. ");
INSERT INTO zaj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kabili Yesu kawalongela, “Nochola na zangu, ila mokwiza kunizahila, na mofa na vilozo venu. Na hamdaha kuchola kunichola nie.” ");
INSERT INTO zaj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Avo wakulu wa Wayahudi walonga, “Kalonga kamba hatudaha kuchola koyochola heyo. Konda kuikoma?” ");
INSERT INTO zaj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu kawedika yolonga, “Mweye mulawa hasi, nie nilawa uchana. Mweye mwa wanhu wa ulumwengu uno, nie si munhu wa ulumwengu uno. ");
INSERT INTO zaj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Niwalongela kamba mofa na vilozo venu. Kamba hamutogole kamba nie iyo, kweli mofa na vilozo venu.” ");
INSERT INTO zaj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wamuuza, “Gweye iyo yalihi?” Yesu kawalongela, “Nie iyo ija iniwalongele songela haichanduso. ");
INSERT INTO zaj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nna mbuli bwando za kuwalonga mweye, na mbuli bwando za kuwatagusila. Ayo yanhumile kabule uvwizi, na nie noulongela ulumwengu gaja ganihulike kulawa kumwake.” ");
INSERT INTO zaj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hawavitangile kamba Yesu kakala yowalongela mbuli za Tata. ");
INSERT INTO zaj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesu kawalongela, “Muhaniinula nie, Mwana wa Munhu, movitanga kamba nie iyo, na sitenda kinhu chochose nene mwenyego, ila nolonga mbuli zino kamba viyanilongele Tata. ");
INSERT INTO zaj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na ayo yanhumile nie ka hamoja na nie, hanilekile niiyeka, kwavija mazua gose notenda gaja gamnogele heyo.” ");
INSERT INTO zaj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Viyakalile yolonga mbuli zino, wanhu bwando wamtogola. ");
INSERT INTO zaj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Avo Yesu kawalongela awo Wayahudi wamtogole, “Kamba muhagatogola mafundo gangu, mowa wanahina zangu wa ikweli. ");
INSERT INTO zaj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Moitanga ikweli, na ikweli yowatenda mkale muulegeho.” ");
INSERT INTO zaj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wamulongela, “Tweye twa lukolo lwa Ablaham, na hatunakuwa nyakadala wa munhu yoyose. Kotulongelaze tokwiza kuilegeha?” ");
INSERT INTO zaj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu kawalongela, “Nowalongela ikweli, munhu yoyose yoloza hiyo ka nyakadala wa vilozo. ");
INSERT INTO zaj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nyakadala hapetigwa kuwa munhu wa mulango wa munhu yomsang'hanikila milongo yose, ila mwana kopetigwa kuwa wa mulango uja milongo yose. ");
INSERT INTO zaj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kamba Mwana yahawakombola, mokomboligwa kwelikweli. ");
INSERT INTO zaj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Novitanga kamba mweye mwa lukolo lwa Ablaham. Hata avo molonda kunikoma kwavija hamgatogola mafundo gangu. ");
INSERT INTO zaj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nowalongela gaja ganyonile ha Tataangu, kamba mweye vumtenda gaja gamuhulike kulawa ha tata zenu.” ");
INSERT INTO zaj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wamulongela, “Tweye twa lukolo lwa Ablaham.” Yesu kawalongela, “Kamba muhawile kweli mwa lukolo lwa Ablaham, muhatendile kamba viyatendile Ablaham. ");
INSERT INTO zaj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Molonda kunikoma nie, munhu yawalongele kweli iniihulike kulawa ha Mulungu. Ablaham hatendile kinhu kamba kino! ");
INSERT INTO zaj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mweye motenda goyotenda tata wenu.” Wamulongela, “Tweye hatuli wana wa ugoni. Mulungu yeiyeka iyo Tata wetu.” ");
INSERT INTO zaj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu kawalongela, “Kamba Mulungu iyo Tata wenu, muhaninogele, kwavija nilawa ha Mulungu na sambi na hano. Siigalile mwenyego, ila Mulungu iyo yanhumile. ");
INSERT INTO zaj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Habali hamgategeleza gaja ganilonga? Kwavija hamulonda hata kuzihulika mbuli zangu. ");
INSERT INTO zaj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mweye mwa wana wa tata wenu, Mwenembago, na molonda kugawinza gaja goyolonda tata wenu. Songela haichanduso heyo kakala mkoma wanhu na hakalile muikweli hata mwanza umwe, kwavija mmwake mduhu kweli. Yahalonga uvwizi, kumwake heyo kotenda goya, kwavija heyo m'vwizi na iyo tata wa wavwizi wose. ");
INSERT INTO zaj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ila kwavija nie nowalongela ikweli, hamunitogola. ");
INSERT INTO zaj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yalihi mmwanza wenu yodaha kunongela nie kamba nna vilozo? Na kamba nowalongela ikweli, habali basi hamunitogola? ");
INSERT INTO zaj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Munhu yalawile ha Mulungu kozitegeleza mbuli za Mulungu. Kwavija mweye hamulawile ha Mulungu, kileka mana hamzitegeleza.” ");
INSERT INTO zaj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wakulu wa Wayahudi wamwidika, wolonga, “Tuhonyela vitulongile kamba gweye kwa Msamalia na kuna kinyamkela?” ");
INSERT INTO zaj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu kawedika, yolonga, “Nie nabule kinyamkela. Nie nomuhishimila Tataangu, ila mweye monizabuza nie. ");
INSERT INTO zaj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nie sizahila yenzi yangu mwenyego. Ila kuna imwe yoizahila, na heyo iyo mulamula. ");
INSERT INTO zaj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nowalongela ikweli, munhu yoyose yogatogola mafundo gangu hadanganhika.” ");
INSERT INTO zaj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Wakulu wa Wayahudi wamulongela, “Sambisambi tuvimanya kamba kuna kinyamkela! Ablaham kadanganhika na wahokozi wayagwe wadanganhika, hata avo gweye ung'hali longa kamba munhu yoyose yogatogola mafundo gako hadanganhika. ");
INSERT INTO zaj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Muhenga wetu Ablaham kadanganhika na wahokozi wayagwe vivija wadanganhika. Gweye koitenda mkulu kubanza muhenga wetu Ablaham? Vuigelegeza gweye kwa munhu yalihi hasa?” ");
INSERT INTO zaj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu kawalongela, “Kamba nihaitogola mwenyego, nhogolwa yangu si kinhu. Yonitogola nie iyo Tataangu, ayo yummulonga kamba iyo Mulungu wenu. ");
INSERT INTO zaj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mweye hamumtangile, ila nie nimtanga. Kamba nihalonga simtangile, nowa m'vwizi kamba mweye. Ila nie nimtanga na nozigoga mbuli zake. ");
INSERT INTO zaj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Muhenga wenu Ablaham kadeng'helela viyalolile haulongozi na kuwona mwizilo wangu. Kawona na kadeng'helela ng'hani.” ");
INSERT INTO zaj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wayahudi wamulongela, “Gweye hunavikila hata milao malongo matano, kumona Ablaham?” ");
INSERT INTO zaj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu kawalongela, “Nowalongela ikweli, kipigiti Ablaham hanavumbuka, ‘Nie iyo.’ ” ");
INSERT INTO zaj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Viyalongile vija, wadondola mabwe giladi wamtoe, ila Yesu kaifisa, abaho, kalawa Kung'anda ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu viyakalile yobita mnzila, kamona munhu yavumbuke kimbugumbugu. ");
INSERT INTO zaj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Wanahina zake wamuuza, “Mkulufunzi, yalihi yalozile, kileka mana munhu ino yavumbuke kimbugumbugu, heyo mwenyego ama wamulelile?” ");
INSERT INTO zaj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu kawalongela, “Sio munhu ino ama waja wamulelile watendile vilozo, gano galawilila giladi sang'hano za Mulungu zoneke mkubitila heyo. ");
INSERT INTO zaj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kipigiti chose cha imisi tolondigwa kutenda sang'hano za ayo yanhumile. Kilo chokwiza haduhu munhu yondayadahe kusang'hanika. ");
INSERT INTO zaj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kipigiti nie ning'hali muulumwengu, nie iyo mulangaza wa ulumwengu.” ");
INSERT INTO zaj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Viyeshile kulonga gano, Yesu kazenha vizite hasi muisi, abaho, katenda tope yovulugiza na ivizite, abaho, kam'baka mmeso ga ija imunhu. ");
INSERT INTO zaj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kamulongela, “Genda ukainave kihanga chako Mdibwawa da Siloamu.” Nhegulo ya twaga dino iyo, “Yatumigwe.” Avo ija imunhu kachola kaisuluza, kabwela yolola. ");
INSERT INTO zaj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wanhu wakalile wokala behi nayo na wanhu wamonile viyakalile yopula kipigiti hanahonyigwa wakiiuza, “Ino hali munhu ija yakalile yokala mnzila yopula?” ");
INSERT INTO zaj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wanhu wayagwe walonga, “Iyo heyo,” ila wayagwe walonga, “Sio heyo, ila wailinga.” Avo ija imunhu kamana kulonga mwenyego, “Iyo nene.” ");
INSERT INTO zaj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wamuuza, “Kutendaze, kileka mana sambi ulola?” ");
INSERT INTO zaj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kawalongela, “Munhu imwe yokemigwa Yesu katenda vitope, kanibaka mmeso gangu, kanilongela nichole Siloamu nikaisuluze kihanga changu. Avo nichola, vunimambukize kuisuluza, nilola.” ");
INSERT INTO zaj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wamuuza, “Kakwahi?” Kawalongela, “Mmane.” ");
INSERT INTO zaj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Abaho, wamsola ija imunhu yakalile kimbugumbugu, wamgala kuwali Mafalisayo. ");
INSERT INTO zaj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Zua dija Yesu diyatendile ditope na kumuhonya umbugumbugu wake ija imunhu dikala Zua da Mhumulo. ");
INSERT INTO zaj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Avo Mafalisayo wamuuza ija imunhu kabili vija viyadahile kulola. Kawalongela, “Kanibaka mitope mmeso gangu, abaho, niisuluza kihanga changu, na sambi nolola.” ");
INSERT INTO zaj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mafalisayo wayagwe walonga, “Munhu yatendile vino halawile ha Mulungu, kwavija hadigoga Zua da Mhumulo.” Wayagwe walonga, “Kodahaze munhu yali na vilozo kutenda mizonza kamba ino?” Avo kukala na muhasanyo wenyego kwa wenyego. ");
INSERT INTO zaj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Avo Mafalisayo wamuuza ija imunhu mwanza uyagwe, wolonga, “Kulonga kakuhonya umbugumbugu uukalile nao, avo gweye komulonga vilihi munhu ino?” Ija imunhu kalonga, “Nokona munhu ino muhokozi.” ");
INSERT INTO zaj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Wakulu wa Wayahudi hata avo hawalondile kutogola kamba kakala kimbugumbugu na sambi kolola, mbaka wawakema waja wamulelile, ");
INSERT INTO zaj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","na kuwauza, “Ino iyo mwanenu yummulonga kamba kavumbuka kimbugumbugu? Choni kitendeke mbaka sambi kodaha kulola?” ");
INSERT INTO zaj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Waja wamulelile wawalongela, “Tuvitanga kamba ino iyo mwanetu, na kakala yavumbuke kimbugumbugu. ");
INSERT INTO zaj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ila hatukitangile kija kitendeke mbaka sambi kodaha kulola, vivija hatumtangile yamuhonyile umbugumbugu uyakalile nao. Muuzeni, kwavija heyo mwenyego mkulu, heyo mwenyego kodaha kuwalongela!” ");
INSERT INTO zaj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Waja wamulelile walonga vino kwavija wakala wowadumba wakulu wa Wayahudi kwavija wakala walamule kamba munhu yoyose yamtogola Yesu kamba iyo Kilisto kowingigwa mng'anda ya nhambiko. ");
INSERT INTO zaj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kino kicho kilamso kiwatendile waja wamulelile walonge, “Heyo mwenyego mkulu, muuzeni!” ");
INSERT INTO zaj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mwanza wa ikabili wamkema ija imunhu yavumbuke kimbugumbugu, wamulongela, “Mulungu iyo yolondigwa kugweleligwa yenzi mmbuli ino, kwavija tweye tuvitanga kamba munhu ino kana vilozo.” ");
INSERT INTO zaj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ija imunhu kawalongela, “Nie sivitanga kamba kana vilozo ama kabule. Kinhu kimwe kinikitanga, nikala kimbugumbugu, na sambi nolola.” ");
INSERT INTO zaj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Wamuuza, “Kakutendela kinhu chaki? Kakuhonyaze umbugumbugu uukalile nao?” ");
INSERT INTO zaj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kawedika, “Niwalongela nisha, na hamtegeleze. Habali mulonda kuhulika kabili? Na mweye molonda kuwa wanahina zake?” ");
INSERT INTO zaj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Wamuliga, abaho, wamulongela, “Gweye iyo mwanahina wake munhu ija, ila tweye twa wanahina wa Musa. ");
INSERT INTO zaj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tukitangile tweye Mulungu kalonga na Musa, ila munhu ino hatukutangile hata koyolawa!” ");
INSERT INTO zaj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ija imunhu kawalongela, “Kino kicho kinhu cha mkanganyo! Hamumtangile koyolawa, ila nie kamhonya umbugumbugu unikalile nao! ");
INSERT INTO zaj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tuvimanya kamba Mulungu hawategeleza wanhu wali na vilozo, ila kowategeleza wanhu waja womuhulika na kutenda gaja goyolonda heyo wagatende. ");
INSERT INTO zaj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Songela vuulumbigwe ulumwengu, haduhu munhu yoyose yamuhulike munhu yoyose yamtendile munhu yavumbuke kimbugumbugu yalole. ");
INSERT INTO zaj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kamba munhu ino halawile ha Mulungu, sambiyadahe kutenda kinhu chochose.” ");
INSERT INTO zaj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wamwidika wolonga, “Gweye kuvumbuka na kukula m'vilozo, abaho, konda kutufundiza tweye?” Avo wamuwinga kulawa mng'anda ya nhambiko. ");
INSERT INTO zaj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu viyagahulike gaja galawilile, kamzahila ija imunhu, viyamuwene kamulongela, “Gweye komtogola Mwana wa Munhu?” ");
INSERT INTO zaj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ija munhu kalonga, “Mndewa, nongela, iyo yalihi giladi nimtogole!” ");
INSERT INTO zaj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu kamulongela, “Kumona kwisha, na ayo yolonga nagwe iyo heyo.” ");
INSERT INTO zaj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ija imunhu kalonga, “Notogola, Mndewa,” abaho, kafugama mavindi kamtambikila. ");
INSERT INTO zaj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu kalonga, “Niza muulumwengu uno kutagusa, avo vimbugumbugu weze kulola, na awo wolola weze kuwa vimbugumbugu.” ");
INSERT INTO zaj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mafalisayo wakalile na heyo haja wamuhulika yolonga gano, wamuuza, “Gweye kolonga tweye twa vimbugumbugu?” ");
INSERT INTO zaj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu kawalongela, “Kamba muhawile vimbugumbugu, sambimuwe na vilozo. Ila kwavija mokiiyona molola, vilozo venu mogendelela kuwa navo.” ");
INSERT INTO zaj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu kalonga, “Nowalongela ikweli, munhu yolema kwingila mulwigo lwa ng'hondolo mkubitila mulwivi, ila kozumha mkiwambaza, munhu hiyo m'bavi na m'bokonyi. ");
INSERT INTO zaj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Munhu yokwingila mkubitila mulwivi iyo mchunga wa ng'hondolo. ");
INSERT INTO zaj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mwimilizi wa ulwivi kom'vugulila, na ng'hondolo wodihulika dizwi jake. Kowakema ng'hondolo zake na matwaga gao, na kuwalava hanze. ");
INSERT INTO zaj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yahamala kuwalava hanze, kolongola haulongozi wao, na iwang'hondolo womkweleleza kwavija waditanga dizwi jake. ");
INSERT INTO zaj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Muhenza hawamkweleleza ila womkimbila, kwavija hawaditangile dizwi jake.” ");
INSERT INTO zaj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu kawalongela hala dino, ila hawaitangile nhegulo yake. ");
INSERT INTO zaj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Avo Yesu kalonga kabili, “Nowalongela ikweli, nie iyo ulwivi lwa ng'hondolo. ");
INSERT INTO zaj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Awo wayagwe wose wanilongole wabavi na mibokonyi, ila ng'hondolo hawawahulike. ");
INSERT INTO zaj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nie iyo ulwivi. Munhu yoyose yondayengile mkubitila nie kokomboligwa. Kokwingila na kulawa kuchola kuzahila mandia. ");
INSERT INTO zaj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","M'bavi kokwiza giladi yebe na kukoma na kubananga. Nie niza giladi muwe na ugima, na muwe nao bwando.” ");
INSERT INTO zaj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nie iyo mchunga yanogile. Mchunga yanogile koulava ugima wake sama ya ng'hondolo. ");
INSERT INTO zaj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Munhu wa kitumetume ayo yali sio mchunga, na ng'hondolo sio zake. Yahamona mbwizi yokwiza, kowaleka iwang'hondolo na kukimbila. Avo mbwizi kowagoga iwang'hondolo na wayagwe wopwililika. ");
INSERT INTO zaj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Munhu wa kitumetume kokimbila kwavija munhu wa kitumetume hawagelegeza ng'hondolo, kwavija si ng'hondolo zake. ");
INSERT INTO zaj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nie iyo mchunga yanogile. Nowatanga ng'hondolo zangu na hewo wonitanga, ");
INSERT INTO zaj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","kamba vija Tataangu viyonitanga nie na nie vinimtanga Tataangu. Noulava ugima wangu sama ya ng'hondolo. ");
INSERT INTO zaj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Hana ng'hondolo zangu wayagwe hawali mdikonhi dino. Vivija nolondigwa niwengize, woihulika nongelo yangu na kugaluka dale dimwe na mchunga imwe. ");
INSERT INTO zaj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tata kaninogela nie kwavija noulava ugima wangu, giladi niubokele kabili. ");
INSERT INTO zaj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Haduhu munhu yonisegezela ugima wangu. Noulava nene mwenyego. Nodaha kuulava na nodaha kuubweza kabili. Vino vivo Tataangu vayanilagize nitende.” ");
INSERT INTO zaj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Wayahudi wakiigola kabili sama ya mbuli zino. ");
INSERT INTO zaj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wayahudi bwando walonga, “Kana kinyamkela, na kana luwege! Habali mumtegeleza?” ");
INSERT INTO zaj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ila wayagwe walonga, “Munhu yali na kinyamkela hadaha kulonga kamba vino! Kodahaze kinyamkela kuwatenda wanhu vimbugumbugu walole?” ");
INSERT INTO zaj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ukala msimu wa kihuhe, na Lusona lwa Kuifumbika Ng'anda ya Mulungu Mmakono ga Mulungu lukala lugendelela ako Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu kakala yobita hanhu hokemigwa Lubuga lwa Selemani muja mgati ya idikonhi da Ing'anda ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Wakulu wa Wayahudi wammemela wamzunguluka, abaho, wamuuza, “Kotululunganya mbaka zua dilihi? Tulongele ikweli kamba gweye iyo Kilisto!” ");
INSERT INTO zaj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu kawalongela, “Niwalongela nisha, ila hamulondile kutogola. Mbuli zinitenda mtwaga da Tataangu zolonga vinili nie. ");
INSERT INTO zaj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ila hamunitogola kwavija mweye hamuli ng'hondolo zangu. ");
INSERT INTO zaj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ng'hondolo zangu wodihulika dizwi jangu. Nowatanga, na wonikweleleza nie. ");
INSERT INTO zaj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nowagwelela ugima wa digunge, na hawadanganhika, na haduhu munhu yondayadahe kuwabokonya kulawa kumwangu. ");
INSERT INTO zaj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tataangu, yangwelele wano, iyo mkulu kubanza vinhu vose. Haduhu munhu yondayadahe kuwabokonya kulawa mmakono gake Tata. ");
INSERT INTO zaj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tata na nie twa kinhu kimwe.” ");
INSERT INTO zaj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Abaho, Wayahudi wenula mabwe kabili wamtoe nago. ");
INSERT INTO zaj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu kawalongela, “Niwalagusila mizonza bwando mikulu kulawa ha Tataangu, mbuli ilihi ihile yumulondela kunitoela na mabwe?” ");
INSERT INTO zaj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wamulongela, “Hatulonda kukutoa gweye na mabwe sama ya mbuli zinogile, ila sama ya ufukuzi wako! Gweye kwa munhu, abaho, kokiitenda mwenyego kuwa Mulungu!” ");
INSERT INTO zaj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu kawedika kalonga, “Hayandikigwe Mmalagizo genu, ‘Nilonga, mweye mwa miungu’? ");
INSERT INTO zaj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kamba Mulungu kawakema ‘miungu’ awo wavikiligwe na usenga wake, na Nyandiko Zing'alile hazidahika kubezigwa, ");
INSERT INTO zaj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","kamba nie Tata kanisagula na kunhuma muulumwengu, vilihi mweye molonga nofukula kwavija nilonga nie iyo Mwana wa Mulungu? ");
INSERT INTO zaj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kamba sitendile sang'hano zoyonilonda nitende Tataangu, sambimunitogole. ");
INSERT INTO zaj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ila kamba nihazitenda, hata kamba hamunitogola, mogatogola gaja gondanitende, giladi m'vitange kamba Tata ka mgati yangu, na nie na mgati ya Tataangu.” ");
INSERT INTO zaj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Walonda kumgoga mwanza uyagwe kabili, ila kawazuluhuka mmakono gao. ");
INSERT INTO zaj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Abaho, Yesu kabweleganya mwambu wa ikabili wa Ulwanda lwa Yolodani kachola hanhu haja hayakalile yobatiza Yohana umwaka, kakala haja. ");
INSERT INTO zaj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Wanhu bwando wamcholela, walonga, “Yohana hatendile mzonza wowose, ila mbuli zose zayamulongile munhu ino zilawila kweli.” ");
INSERT INTO zaj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Avo wanhu bwando haja wamtogola Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Munhu imwe yokemigwa Lazalo, yakalile yokala Betania, kakala yolumwa. Betania kikala kiwambo chawakalile wokala Mata na lumbu jake Maliamu. ");
INSERT INTO zaj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maliamu ino iyo yamwitile mavuta ga kunung'hila Mndewa mmagulu na kumuhangusa na mvili zake. Lazalo yakalile yolumwa kakala lumbu jake. ");
INSERT INTO zaj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Walumbu wano wamgalila usenga Mndewa, wolonga, “Mndewa, mbwigaako yuumnogele kolumwa.” ");
INSERT INTO zaj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu viyahulike, kalonga, “Kimambukizo cha malawililo ga utamu uno hakigala ifa ya Lazalo, ila ulawila giladi Mulungu yayenzigwe. Na mkilamso kino, Mwana wa Mulungu koyenzigwa.” ");
INSERT INTO zaj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu kakala yamnogele Mata na lumbu jake na Lazalo. ");
INSERT INTO zaj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Viyahulike kamba Lazalo kolumwa, kakala bahaja hayakalile mazua mabili. ");
INSERT INTO zaj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Abaho, kawalongela wanahina zake, “Tubweleganye Yudea.” ");
INSERT INTO zaj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Wanahina zake wamulongela, “Mkulufunzi, kipigiti kiguhi kibitile Wayahudi wa kuja walonda kukutoa na mabwe, abaho, konda kubweleganya kukuja?” ");
INSERT INTO zaj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu kalonga, “Zua hadili na masaa longo dimwe na mabili? Avo munhu yoyose yotembela imisi hadaha kuikwala, kwavija kowona mulangaza wa ulumwengu. ");
INSERT INTO zaj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ila yahatembela ikilo kokiikwala, kwavija kabule mulangaza.” ");
INSERT INTO zaj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Viyamambukize kulonga gano, kawalongela, “Mbwiga wetu Lazalo kawasa, ila nochola nikamulamuse.” ");
INSERT INTO zaj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Wanahina zake wamulongela, “Mndewa, kamba kawasa, basi kohona.” ");
INSERT INTO zaj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu kakala yalongile ifa ya Lazalo, ila wanahina zake wagiza kawasa utulo wa mazua gose. ");
INSERT INTO zaj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Avo Yesu kawalongela bila kufisa, “Lazalo kadanganhika, ");
INSERT INTO zaj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ila sama yenu mweye, nie ninogelwa ng'hani kwavija sikalile kuja, giladi mtogole. Tucholeni kumwake.” ");
INSERT INTO zaj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomaso, yokemigwa Ubasa, kawalongela wanahina wayage, “Tucholeni hamoja na Mkulufunzi, avo yahakomigwa tukomigwe tose!” ");
INSERT INTO zaj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu viyavikile, kavika Lazalo yazikigwe mazua mane gabitile. ");
INSERT INTO zaj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania kikala kiwambo kikalile behi na Yelusalemu, kamba mwanza wa kilometa ndatu, ");
INSERT INTO zaj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","na Wayahudi bwando weza kumulola Mata na Maliamu kuwahani avija lumbu jao viyadanganhike. ");
INSERT INTO zaj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mata viyahulike kamba Yesu kokwiza, kalawa hanze yam'bokele, ila Maliamu kasigala mng'anda. ");
INSERT INTO zaj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata kamulongela Yesu, “Mndewa, kamba uhakalile baha, lumbu jangu sambiyadanganhike. ");
INSERT INTO zaj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ila nivitanga kamba hata lelo Mulungu kokugwelela chochose chondaumpule.” ");
INSERT INTO zaj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu kamulongela, “Lumbu jako kozuka.” ");
INSERT INTO zaj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Kamwidika, kalonga, “Nivitanga kamba kozuka mdizua da ikimambukizo.” ");
INSERT INTO zaj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu kamulongela, “Nie iyo mzuso na ugima. Awo wonitogola, hata kamba wahadanganhika, wowa wagima kabili. ");
INSERT INTO zaj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na awo wose wali na ugima na kunitogola nie hawadanganhika. Kozitogola mbuli zino?” ");
INSERT INTO zaj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Kamulongela, “Ona, Mndewa, notogola kamba gweye iyo Kilisto, Mwana wa Mulungu, ayo yokwiza muulumwengu.” ");
INSERT INTO zaj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata viyeshile kulonga gano, kabweleganya mng'anda kachola kumkema lumbu jake Maliamu, kamnyong'onyela, “Mkulufunzi kabaha avo kokulonda.” ");
INSERT INTO zaj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maliamu viyahulike gano, kenuka hima kalawa hanze kachola ha Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu kakala hanavika hakiwambo, ila kakala haja hawaiting'hane na Mata. ");
INSERT INTO zaj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Wayahudi wakalile na Maliamu mng'anda womuhembekeza, viwamonile yogundumuka yolawa hanze, wamkweleleza. Wagiza kakala yochola kudipanga kulila. ");
INSERT INTO zaj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maliamu viyavikile haja hayakalile Yesu, viyamonile, kagwa ha magulu gake, kalonga, “Mndewa, kamba uhakalile baha, lumbu jangu sambiyadanganhike!” ");
INSERT INTO zaj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu kamulola viyakalile yolila, abaho, kawalola waja wanhu wakalile na heyo vivija viwakalile wolila, kagaya ng'hani mmoyo na kona chuhila ng'hani. ");
INSERT INTO zaj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kawauza, “Mumzikila kwahi?” Wamulongela, “Izo ulole, Mndewa.” ");
INSERT INTO zaj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu kalila. ");
INSERT INTO zaj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Wayahudi walonga, “Loleni viyamnogele!” ");
INSERT INTO zaj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ila wanhu wayagwe walonga, “Ayo yamtendile munhu kimbugumbugu yalole, hadahile kumtenda Lazalo sambiyadanganhike?” ");
INSERT INTO zaj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu kona chuhila ng'hani mwanza wa ikabili, kachola kudipanga. Dikala kamba mhango, na dibwe kulu dikigwa hamulomo. ");
INSERT INTO zaj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu kalonga, “Segezeni didibwe!” Mata, lumbu ja ija imunhu yadanganhike, kamulongela, “Mndewa, kuna bundo, kwavija kazikigwa mazua mane gabitile!” ");
INSERT INTO zaj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu kamulongela, “Sikulongele kamba uhatogola, koyona yenzi ya Mulungu?” ");
INSERT INTO zaj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wadisegeza didibwe. Yesu kalola uchana, kalonga, “Nokuheweza, Tata, kwavija konhegeleza nie. ");
INSERT INTO zaj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nivitanga kamba mazua gose konhegeleza, ila nolonga gano sama ya wanhu wali hano, giladi kwiza watogole kamba gweye iyo unhumile.” ");
INSERT INTO zaj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Viyeshile kulonga gano, kenula dizwi yolonga, “Lazalo, lawa hanze!” ");
INSERT INTO zaj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ija imunhu yakalile yadanganhike kalawa hanze, kuno makono gake na magulu gake gazingilizwe na sanda, na kihanga chake kizingilizwa kitambala. Yesu kawalongela, “Mfunguleni, mmuleke yachole na zake.” ");
INSERT INTO zaj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Wayahudi bwando wezile kumulola Maliamu wagona gaja gayatendile Yesu, na wamtogola. ");
INSERT INTO zaj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ila wayagwe mmwanza wao wachola ha Mafalisayo na kuwalongela gaja Yesu gayatendile. ");
INSERT INTO zaj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Avo Mafalisayo na wakulu wa wakulu wa nhambiko waiting'hana na Ikitala Kikulu cha Isi ya Wayahudi, walonga, “Tutendeze? Loleni mizonza yose yootenda munhu ino. ");
INSERT INTO zaj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kamba tuhamuleka yagendelele kamba vino, wanhu wose womtogola, na Wakulu wa Loma wokwinuka na kuibananga isi yetu na Ing'anda ya Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Imwe mmwanza wao, yokemigwa Kayafa, yakalile Mkulu wa Wakulu wose wa Nhambiko mulao uja, kalonga, “Mweye mwa mipulaputi kabisa. ");
INSERT INTO zaj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ham'vitangile kamba vinoga munhu imwe yadanganhike sama ya wanhu bwando, kubanza kuileka isi yose ibanangike?” ");
INSERT INTO zaj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Halongile gano kulawa mmoyo wake mwenyego, ila avija viyakalile Mkulu wa Wakulu wose wa Nhambiko mulao uja, kakala yalongozwe na Mulungu yahokole kamba Yesu kodanganhika sama ya Wayahudi wose, ");
INSERT INTO zaj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","na sio hewo weiyeka, ila vivija kaweka hamoja kamba lukuli lumwe wana wa Mulungu wapwililike. ");
INSERT INTO zaj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Songela zua dija wakulu wa Wayahudi weka mizundo ya kumkoma Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Avo Yesu kakala yotembela mkuifisa muiisi ya Yudea, na kasegela kachola hana ikiwambo kikemigwa Eflaim, kikalile behi na luwala, kakala haja na wanahina zake. ");
INSERT INTO zaj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Lusona lwa Pasaka lwa Wayahudi lukala behi, na wanhu bwando walawa muisi zao wachola Yelusalemu kutaulwa kipigiti lusona halunasonga. ");
INSERT INTO zaj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Wakala womzahila Yesu, na viwakalile wemile Kung'anda ya Mulungu, waiuza, “Mogelegeza vilihi? Heza hana ulusona, ama vilihi?” ");
INSERT INTO zaj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wakulu wa wakulu wa nhambiko na Mafalisayo walava ndagizi kamba, munhu yoyose yahakutanga kuyali Yesu kolondigwa yakawalongele, giladi wamgoge. ");
INSERT INTO zaj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Vigasigale mazua sita kuvikila Pasaka, Yesu kachola Betania hakae ya Lazalo, munhu ija yazusigwe kulawa mkudanganhika. ");
INSERT INTO zaj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Wamtelekela mandia ga ichungulo, Mata kakala yowataza kugomela. Lazalo kakala imwe wa wanhu wakalile hameza na Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Abaho, Maliamu kasola nyhupa ya mavuta ga kunung'hila ga hela bwando gatendigwe na nado, kamwitila Yesu mmagulu, abaho, kamuhangusa na mvili zake. Mnung'ho unogile wa gamavuta gaja ga kunung'hila wenela mng'anda yose. ");
INSERT INTO zaj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mwanahina imwe wa Yesu, yokemigwa Yuda Isikalioti ayo yamuhonzile Yesu, kalonga, ");
INSERT INTO zaj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Habali mavuta gano ga kunung'hila sambigaguzigwe zipatikane hela za kuliha kitumetume cha mulao umwe giladi wagweleligwe wakumbulu?” ");
INSERT INTO zaj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kalonga vino si kamba kowonela bazi wakumbulu, ila kwavija kakala m'bavi. Heyo iyo yakalile yopapa umkoba wa izihela na kakala yokwiba kulawa himo. ");
INSERT INTO zaj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ila Yesu kalonga, “Mulekeni! Lekeni yageke mavuta higo mbaka zua da mazisi gangu. ");
INSERT INTO zaj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Wakumbulu munao mazua gose, ila nie sikala namwe mazua gose.” ");
INSERT INTO zaj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Wayahudi bwando wahulika kamba Yesu kakala mkiwambo cha Betania, avo wachola kuja sio tu kumulola Yesu ila vivija kumulola Lazalo, ayo Yesu yamzusile kulawa mkudanganhika. ");
INSERT INTO zaj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Avo wakulu wa wakulu wa nhambiko weka zundo da kumkoma Lazalo vivija, ");
INSERT INTO zaj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kwavija sama ya gaja gatendigwe kumwake, Wayahudi bwando wawalema hewo na kumtogola Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Zua da ikabili, wanhu bwando wezile Kulusona lwa Pasaka wahulika kamba Yesu kokwiza Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Avo wasola mitambi ya mitende walawa wachola kum'bokela, kuno wenula dizwi, wolonga, “Yatogolwe Mulungu! Mulungu mmoteze ayo yokwiza mtwaga da Mndewa! Mulungu mmoteze Mndewa wa Islaeli!” ");
INSERT INTO zaj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu kam'vika mwana mhunda, na kukwela uchana yake, kamba Nyandiko Zing'alile vuzilonga, ");
INSERT INTO zaj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sambiudumbe, gweye kiwambo cha Sayuni! Mndewa wako kokwiza, yapapigwe mumgongo wa mhunda mdodo.” ");
INSERT INTO zaj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wanahina zake hawagatangile gano kipigiti kija, ila Yesu viyayenzigwe, wakumbukila kamba Nyandiko Zing'alile zilonga gano na avo gatendigwa gano sama yake. ");
INSERT INTO zaj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Wanhu wakalile na Yesu kipigiti viyamkemile Lazalo kulawa mdipanga na kumzusa kulawa mkudanganhika wagendelela kugapeta gaja galawilile. ");
INSERT INTO zaj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Wanhu bwando wachola kum'bokela, kwavija wakala wahulike kamba katenda mzonza uno. ");
INSERT INTO zaj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Abaho, Mafalisayo wakiilongela, “M'vona, tuhumwa! Lola, ulumwengu wose womkweleleza heyo!” ");
INSERT INTO zaj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mmwanza wa wanhu waja wacholile Yelusalemu kutambika kipigiti cha Ulusona lwa Pasaka wakala Wagiliki. ");
INSERT INTO zaj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Wachola ha Filipo, yakalile mwenekae wa Betisaida ako Galilaya, wamulongela, “Mndewa, tolonda kumona Yesu.” ");
INSERT INTO zaj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo kachola kumulongela Endelea, na awo wabili wachola kumulongela Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu kawalongela, “Kipigiti cha nie, Mwana wa Munhu, kuyenzigwa kivika. ");
INSERT INTO zaj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nowalongela ikweli, kamba nzele ya ngano hailagale hasi na kudanganhika, yosigala kuwa imwe. Ila ihadanganhika, yolela nzele bwando. ");
INSERT INTO zaj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Awo wounogela ugima wao wowagiza, na awo wowihila ugima wao muulumwengu uno wowika kuugima wa digunge. ");
INSERT INTO zaj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Munhu yoyose yolonda kunisang'hanikila kolondigwa yang'holeleze nie, kuja kunili na mtumigwa wangu vivija kowa hiko. Tataangu komuhishimila munhu yoyose yonisang'hanikila nie. ");
INSERT INTO zaj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Moyo wangu una giogio, nongeze? Nilonge, ‘Tata, sambiuleke mbuli zino zinivikile?’ Bule, kwavija niza sama ya mbuli zino. ");
INSERT INTO zaj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata, udiyenzi twaga jako!” Abaho, dihulikwa dizwi kulawa kuulanga, “Nidiyenzi, na nodiyenzi kabili.” ");
INSERT INTO zaj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Wanhu bwando wakalile haja wadihulika dizwi dija, na wanhu wayagwe walonga ukala mdumo. Wayagwe walonga, “Msenga wa Mulungu wa kuulanga kalonga nayo!” ");
INSERT INTO zaj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ila Yesu kawalongela, “Dizwi dino dihulikwe si sama yangu nie, ila sama yenu mweye. ");
INSERT INTO zaj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kino hicho kipigiti cha kutaguswa kwa ulumwengu, na kipigiti kino mtawala wa ulumwengu uno kowingigwa. ");
INSERT INTO zaj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nihenuligwa uchana kulawa muisi, nomkwega kila munhu kumwangu.” ");
INSERT INTO zaj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Mkulonga gano kalagusa ifa ilihi yondayadanganhikile. ");
INSERT INTO zaj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Adija ididale da wanhu dimulongela, “Malagizo getu gotulongela kamba Kilisto kokala milongo yose. Avo gweye kolongaze kamba Mwana wa Munhu kolondigwa yenuligwe uchana? Mwana ino wa Munhu iyo yalihi?” ");
INSERT INTO zaj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu kawalongela, “Mulangaza wowa namwe mkipigiti kidodo. Gendeleleni kutembela mnzila imulinayo kipigiti mulangaza ung'hali namwe, giladi ziza sambidiwavike. Kwavija munhu yotembela mziza hakutanga koyochola. ");
INSERT INTO zaj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Utogoleni mulangaza kipigiti u hamoja namwe, giladi muwe wana wa mulangaza.” Yesu viyeshile kulonga gano, kasegela kachola kuifisa. ");
INSERT INTO zaj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hamoja na kutenda mizonza ino yose hameso gao, hawamtogole, ");
INSERT INTO zaj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","avo gaja gayalongile Muhokozi Isaya galawilila kweli, yolonga, “Mndewa, yalihi yautogole usenga wetu? Mhiko ya Mndewa igubuligwa ha munhu yalihi?” ");
INSERT INTO zaj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Hawatogole, kwavija vivija Isaya kalonga, ");
INSERT INTO zaj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Mulungu kagagubika meso gao, na kuzibumbuwaza nzewele zao, avo meso gao sambigalole, na sambiwavitange mnzewele zao, giladi sambiwanihindukile, niwahonye.” ");
INSERT INTO zaj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya kagalonga gano kwavija kayona yenzi ya Yesu na kumulonga heyo. ");
INSERT INTO zaj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Avo wanhu bwando mmwanza wa wakulu wa Wayahudi wamtogola. Ila sama ya kuwadumba Mafalisayo hawamtogole hakimwagaia, kwavija wadumba sambiwawawinge kulawa mng'anda ya nhambiko. ");
INSERT INTO zaj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Wanogelwa na nhogolwa za wanhu kubanza nhogolwa za Mulungu. ");
INSERT INTO zaj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu kenula dizwi kalonga, “Munhu yoyose yonitogola nie hanitogola nie niiyeka, ila vivija komtogola ayo yanhumile. ");
INSERT INTO zaj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Munhu yoyose yonyona nie vivija komona ayo yanhumile. ");
INSERT INTO zaj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nie niza muulumwengu kamba mulangaza, avo munhu yoyose yonitogola sambiyasigale mdiziza. ");
INSERT INTO zaj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kamba munhu yoyose yahahulika usenga wangu na kuuleka baho, simtagusa. Kwavija nie sizile kuutagusa ulumwengu ila kuukombola. ");
INSERT INTO zaj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kwavija awo wonilema nie na kuulema usenga wangu, kabaho yondayawataguse. Mbuli zinilongile zowa mulamula hana idizua da ikimambukizo. ");
INSERT INTO zaj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kwavija silongile kamba vinilondile nie mwenyego, ila Tata yanhumile iyo yandagize gaja ga kulonga na vija vondanigalonge. ");
INSERT INTO zaj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na nivitanga kamba ndagizi zake zogala ugima wa digunge. Avo kinilonga nie kicho Tata chayanongele nilonge.” ");
INSERT INTO zaj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ikala behi na Lusona lwa Pasaka. Yesu kavitanga kamba kipigiti kivika cha heyo kuuleka ulumwengu uno na kuchola ha Tataake. Mazua gose kakala yawanogele awo wakalile wanhu zake muulumwengu, na kawanogela mbaka hakimambukizo cha ugima wake. ");
INSERT INTO zaj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu na wanahina zake wakala woja mandia ga ichungulo. Mwenembago kakala yeshile kwika mmoyo wa Yuda, mwana wa Simoni Isikalioti, ngelegeza za kumuhonza Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu kavitanga kamba Tata kamgwaa vinhu vose, na kamba keza kulawa ha Mulungu na kakala yochola ha Mulungu, ");
INSERT INTO zaj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","avo kenuka kulawa haja hameza, kasegeza kitambi chake cha kuigubika mmaega, kaifunga na kitambala mkigudi chake. ");
INSERT INTO zaj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Abaho, kagela mazi mkiteleko, kasonga kuwanava magulu ga wanahina zake na kuwahangusa na ikitambala kikalile mkigudi chake. ");
INSERT INTO zaj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Keza ha Simoni Petulo, Simoni Petulo kamulongela, “Mndewa, gweye konda kuganava magulu gangu?” ");
INSERT INTO zaj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu kamwidika, kalonga, “Kinitenda nie hukimanya sambi baha, ila kokimanya kumwande.” ");
INSERT INTO zaj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petulo kamulongela, “Bule, gweye huninava nie magulu gangu!” Yesu kamwidika, kalonga, “Kamba sikunavile gweye, hauli hamoja na nie.” ");
INSERT INTO zaj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petulo kamwidika, kalonga, “Mndewa, sio magulu gangu geiyeka, vivija ninave na makono na pala jangu!” ");
INSERT INTO zaj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu kalonga, “Munhu yogile kang'ala lukuli lose, ila magulu gake gago golondigwa kunavigwa. Mweye mung'ala, ila si mose.” ");
INSERT INTO zaj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu kakala yammanyile munhu yalihi yondayamuhonze, kileka mana yalongile, “Si mose mung'alile.” ");
INSERT INTO zaj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu viyamambukize kuwanava magulu gao, kaigubika kabili kitambi chake, abaho, kabwela haja hameza hayakalile, abaho, kawauza, “Mkimanya kija kiniwatendele sambisambi? ");
INSERT INTO zaj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Monikema nie Mkulufunzi na Mndewa, motenda goya, kwavija avo vivo nili. ");
INSERT INTO zaj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kamba nie na Mndewa wenu na Mkulufunzi wenu niwanava magulu genu, vivija na mweye molondigwa mkiinave magulu mwemwe kwa mwemwe. ");
INSERT INTO zaj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Niwalagusila vija vondamtende, avo kwiza mtende kamba vija nie viniwatendele mweye. ");
INSERT INTO zaj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nowalongela ikweli, nyakadala hali mkulu kum'banza mndewa wake, na mtumigwa hali mkulu kum'banza ija yamtumile. ");
INSERT INTO zaj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sambi mzitanga mbuli zino, momota ng'hani kamba muhazisang'hana. ");
INSERT INTO zaj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Siwalonga mweye mose, niwatanga awo iniwasagule. Ila Nyandiko Zing'alile zilonga, ‘Munhu yadile mandia gangu kagaluka kuwa mdumuka wangu,’ zivikile. ");
INSERT INTO zaj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nowalongela gano sambisambi kipigiti haganalawila, avo vondagalawile motogola kamba, ‘Nie iyo heyo yokwiza.’ ");
INSERT INTO zaj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nowalongela ikweli, munhu yoyose yom'bokela munhu yoyose inimtumile konibokela nie, na munhu yoyose yonibokela nie kom'bokela ayo yanhumile nie.” ");
INSERT INTO zaj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu viyeshile kulonga gano, kona giogio ng'hani mmoyo wake, kalonga, “Nowalongela ikweli, munhu imwe mmwanza wenu konihonza.” ");
INSERT INTO zaj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Waja iwanahina wakiilola, wakanganya ng'hani wogelegeza yalihi Yesu iyamulongile. ");
INSERT INTO zaj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mwanahina imwe, ayo Yesu yaamnogele ng'hani, kakala yakalile behi na Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Petulo kamfunyiza yomulongela, “Muuze, yalihi yoomulonga mdidale jetu?” ");
INSERT INTO zaj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Avo ija imwanahina kuno yomsagamila Yesu, kamuuza, “Mndewa, yalihi?” ");
INSERT INTO zaj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu kalonga, “Ayo yondanimgwelele kidanga kino cha mkate nihesha kukizanhika mkikalango.” Avo kasola ikidanga kakizanhika na kumgwaa Yuda, mwana wa Simoni Isikalioti. ");
INSERT INTO zaj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kipigiti kikija Yuda viyasolile ikidanga cha umkate, Mwenembago kamwingila. Yesu kamulongela, “Chuugenda kutenda, kitende mbwisa!” ");
INSERT INTO zaj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Haduhu munhu yoyose iyagwe haja hameza yavimanyile kamba habali Yesu kamulongela Yuda mbuli zino. ");
INSERT INTO zaj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kwavija Yuda kakala iyo mgoga umkoba wa izihela, wanahina wayagwe wagiza Yesu kamulongela yachole kugula vinhu vilondigwa mulusona, ama kuwagwelela kinhu wakumbulu. ");
INSERT INTO zaj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yuda kakibokela ikidanga cha umkate, abaho, kalawa hanze hima. Na ikala ikilo. ");
INSERT INTO zaj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda viyasegele, Yesu kalonga, “Sambisambi nie, Mwana wa Munhu, noyenzigwa, na Mulungu koyenzigwa mkubitila nie. ");
INSERT INTO zaj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kamba Mulungu kayenzigwa mkubitila Mwanage, na vivija Mulungu komuyenzi Mwanage mkubitila heyo mwenyego, na kotenda avo hima. ");
INSERT INTO zaj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wanangu, sikala namwe kipigiti kitali. Kwiza monizahila, ila nowalongela kamba viniwalongele Wayahudi, sambi vivija nowalongela na mweye, ‘Kunichola nie mweye hamdaha kwiza.’ ");
INSERT INTO zaj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Na sambisambi nowagwelela ndagizi ya isambi, ‘Muinogele.’ Kamba viniwanogele mweye, avo molondigwa muinogele. ");
INSERT INTO zaj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kamba muhainogela, wanhu wose wovitanga kamba mweye mwa wanahina zangu.” ");
INSERT INTO zaj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petulo kamuuza, “Kochola kwahi, Mndewa?” Yesu kamwidika, yolonga, “Hudaha kunikweleleza kunichola nie sambisambi, ila koniwinza mazua ga hamwande.” ");
INSERT INTO zaj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petulo kamuuza, “Mndewa, habali sidaha kukukweleleza sambisambi? Nie nhogola kudanganhika sama yako!” ");
INSERT INTO zaj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu kamwidika, yolonga, “Kolonga kweli kamba kutogola kudanganhika sama yangu? Nokulongela ikweli, behi na nzogolo zikwika, konibela mianza midatu kamba hunimanyile.” ");
INSERT INTO zaj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu kawalongela, “Sambimnyunguale mmioyo yenu. Mtogoleni Mulungu, munitogole na nie. ");
INSERT INTO zaj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kuna magati bwando mng'anda ya Tataangu, nochola kuwatandila hanhu. Kamba sambiiwe avo, sambiniwalongele mweye gano. ");
INSERT INTO zaj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na nihachola kuwatandileni hanhu, nobwela niwasole niwagale kumwangu, avo mowa haja hanili nie. ");
INSERT INTO zaj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Moitanga nzila ilongoze hanhu kunichola.” ");
INSERT INTO zaj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaso kamulongela, “Mndewa, hatukutangile kuuchola, avo toitangaze inzila?” ");
INSERT INTO zaj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu kamwidika, yolonga, “Nie iyo nzila, kweli, na ugima. Haduhu munhu yondayachole ha Tata kamba habitile kumwangu.” ");
INSERT INTO zaj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yesu kawalongela, “Avija vumunitanga nie sambisambi, vivija momtanga na Tataangu. Na songela kipigiti kino na kugendelela, mumtanga na mumona.” ");
INSERT INTO zaj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo kamulongela, “Mndewa, tulagusile Tata, kino kicho kinhu kitulonda.” ");
INSERT INTO zaj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu kamwidika, yolonga, “Nikala na mweye mkipigiti kino chose, ung'hali hunanitanga, Filipo? Munhu yoyose yanyonile nie kamona Tata. Habali ulonga, ‘Tulagusile Tata’?” ");
INSERT INTO zaj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yesu kawalongela wanahina zake, “Hamtogola kamba nie na mgati ya Tata na Tata ka mgati yangu? Mbuli ziniwalongele sizilongile na udaho wangu mwenyego. Ila Tata yokala mgati yangu kotenda sang'hano yake. ");
INSERT INTO zaj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nihalonga nie na mgati ya Tata, na Tata ka mgati yangu, nitogoleni. Kamba hamulonda kutogola gano, zitogoleni sang'hano zinitenda. ");
INSERT INTO zaj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nowalongela ikweli, awo wonitogola nie vivija wozitenda sang'hano zinitenda nie, na wozitenda sang'hano ng'hulu kubanza zino, kwavija nochola ha Tata. ");
INSERT INTO zaj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na chochose chondampule mtwaga jangu, nokitenda, avo Tata yayenzigwe kubitila Mwana. ");
INSERT INTO zaj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kamba muhanipula kinhu chochose mtwaga jangu, nokitenda. ");
INSERT INTO zaj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kamba muhaninogela nie, mozigoga ndagizi zangu. ");
INSERT INTO zaj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nompula Tata, na heyo kowagwelela Ija iyagwe wa Kuwataza, yondayakale na mweye milongo yose. ");
INSERT INTO zaj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ino iyo Loho wa ikweli. Ulumwengu haudaha kum'bokela, kwavija haumona ama kumtanga. Ila mweye momtanga, kwavija kokala na mweye na kowa mgati yenu. ");
INSERT INTO zaj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nihachola, siwaleka ukiwa, nowabwelela. ");
INSERT INTO zaj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kisigala kipigiti kiguhi ulumwengu haunyona, ila mweye monyona. Kwavija nowa na ugima, na mweye mowa na ugima. ");
INSERT INTO zaj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Zua dija vondadivike movitanga kamba nie na mgati ya Tata, na mweye mwa mgati yangu, na nie na mgati yenu. ");
INSERT INTO zaj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Awo wozitogola ndagizi zangu na kuzigoga, wawo wanogelwe na nie. Na awo woninogela nie wonogelwa na Tataangu, na nie nowanogela na kuigubula kumwao.” ");
INSERT INTO zaj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda, sio Yuda Isikalioti, kalonga, “Mndewa, vilihi uigubule kumwetu na sio kuulumwengu?” ");
INSERT INTO zaj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu kamulongela, “Munhu yoyose yoninogela nie kogagoga mafundo gangu. Tataangu komnogela, na nie na Tataangu tokwiza kumwake na kukala na heyo. ");
INSERT INTO zaj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Munhu yoyose yoleka kuninogela nie hagagoga mafundo gangu. Na mbuli zino zimuhulika sio mbuli zangu nie ila za Tata yanhumile. ");
INSERT INTO zaj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Niwalongela gano kipigiti ning'hali na mweye. ");
INSERT INTO zaj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ila Ija wa Kuwataza, ayo Loho wa Mulungu, Tata yondayamgale mtwaga jangu, kowafundiza kila kinhu na kuwakumbusa mbuli zose ziniwalongele. ");
INSERT INTO zaj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Tindiwalo nowalekela, tindiwalo kulawa kumwangu nowagwelela. Sidilava kamba ulumwengu vuulava. Sambimdumbe ama kudungwadungwa mmioyo yenu. ");
INSERT INTO zaj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Munihulika nie vunilongile, ‘Nosegela, ila nobwela kumwenu.’ Kamba muhaninogele, muhadeng'helele kwavija nochola ha Tata, kwavija Tata mkulu kubanza nie. ");
INSERT INTO zaj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Niwalongela gano kipigiti kino mbuli zino hazinalawila, giladi zihalawila, mtogole. ");
INSERT INTO zaj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Silongelela ng'hani namwe kwavija mtawala wa ulumwengu uno kokwiza. Heyo kabule mhiko za kunihuma nie, ");
INSERT INTO zaj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ila ulumwengu wolondigwa uvitange kamba nomnogela Tata. Kino kicho kilamso notenda vinhu vose voyonilonda nie nitende. “Inukeni, tuchole.” ");
INSERT INTO zaj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu kawalongela wanahina zake, “Nie iyo mzabibu wa ikweli, na Tataangu iyo imulimi. ");
INSERT INTO zaj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kila tambi dili mgati yangu dilekile kulela, kodikanha. Na kila tambi dilela, kodifagilila giladi ding'ale na kulela ng'hani. ");
INSERT INTO zaj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mweye mwisha kung'alizwa na mafundo ganiwafundize. ");
INSERT INTO zaj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kaleni mgati yangu, na nie nokala mgati yenu. Kamba vija tambi vidileka kulela dihakala diiyeka, kamba hadikalile mumzabibu, vivija na mweye hamdaha kulela kamba hamkalile mgati yangu. ");
INSERT INTO zaj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nie iyo mzabibu, na mweye mwa matambi. Awo wokala mgati yangu, na nie nihakala mgati yao, wolela ng'hani. Kwavija mweye hamdaha kutenda mbuli yoyose kamba hamkalile mgati yangu nie. ");
INSERT INTO zaj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Munhu yoyose yoleka kukala mgati yangu kokwasigwa hanze kamba tambi na kuholola. Matambi kamba gano gokunzanywa na kwasigwa hamoto na kusomigwa. ");
INSERT INTO zaj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kamba muhakala mgati yangu na mbuli zangu zihakala mgati yenu, puleni kinhu chochose kimulonda, mogweleligwa. ");
INSERT INTO zaj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tataangu koyenzigwa mmbuli ino, avija mweye muhalela mujo bwando, na mowa wanahina zangu. ");
INSERT INTO zaj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nie niwanogela mweye kamba Tata viyaninogele nie. Kaleni mdinoge jangu. ");
INSERT INTO zaj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kamba muhazigoga ndagizi zangu, mokala mdinoge jangu, kamba nie vinizigogile ndagizi za Tataangu na kukala mdinoge jake. ");
INSERT INTO zaj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Niwalongela mweye gano giladi deng'ho jangu dikale mgati yenu na deng'ho jenu divikizwe. ");
INSERT INTO zaj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ndagizi yangu iyo ino, ‘Muinogele kamba nie viniwanogele mweye.’ ");
INSERT INTO zaj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Haduhu munhu yali na noge kulu kubanza dino, da munhu kuulava ugima wake sama ya wambwiga zake. ");
INSERT INTO zaj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Na mweye mowa wambwiga zangu muhatenda gaja ganiwalagiza. ");
INSERT INTO zaj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Siwakema mweye watumigwa, kwavija watumigwa hawagatanga gaja goyotenda mkulu wao. Ila nowakema mweye wambwiga, kwavija niwalongela vinhu vose vinivihulike kulawa ha Tata. ");
INSERT INTO zaj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mweye hamunisagule nie, ila nie iyo niwasagule mweye na kuwalagiza mchole mkalele mujo bwando, mujo uja wondaukale milongo yose. Avo Tata kowagwelela chochose chondampule mtwaga jangu. ");
INSERT INTO zaj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Avo nowalagiza vino, ‘Muinogele.’ ” ");
INSERT INTO zaj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesu kalonga, “Kamba ulumwengu uhawehila, m'vimanye kamba usonga kunihila nie tanhu. ");
INSERT INTO zaj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kamba mweye muhawile wa ulumwengu uno, ulumwengu uhawanogele kamba wanhu zake. Ila niwasagula mweye kulawa muulumwengu, na mweye vumuli si wa ulumwengu uno, kino kicho kilamso ulumwengu uwehila. ");
INSERT INTO zaj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kumbukileni gaja ganiwalongele, ‘Nyakadala hali mkulu kum'banza mtawala wake.’ Kamba wanhu wahanigaza nie, vivija wowagaza na mweye. Kamba wahagagoga mafundo gangu, vivija wogagoga mafundo genu. ");
INSERT INTO zaj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ila wowatendela gano gose sama ya twaga jangu, kwavija hawamtanga ayo yanhumile nie. ");
INSERT INTO zaj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Maza sizile kulonga nao, sambiwawe na vilozo. Ila sambisambi wabule cha kuiyalalila m'vilozo vao. ");
INSERT INTO zaj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Munhu yoyose yonihila nie vivija komwihila na Tataangu. ");
INSERT INTO zaj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Maza sitendile sang'hano zija hazinatendigwa na munhu yoyose mmwao, sambiwawe na vilozo. Ila sambisambi wazona na tose watwihila, nie na Tataangu. ");
INSERT INTO zaj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Gano galawilila giladi gavikizwe gaja gandikigwe Mmalagizo gao, golonga, ‘Wanihila bila kilamso.’ ");
INSERT INTO zaj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Vondayeze Ija wa Kuwataza, ayo yondaniwagalile kulawa ha Tata, Loho wa ikweli yolawa ha Tata, kozilonga mbuli zangu nie. ");
INSERT INTO zaj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na mweye vivija molondigwa mzilonge mbuli zangu, kwavija mkala na nie songela haichanduso. ");
INSERT INTO zaj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Niwalongela mweye gano giladi sambimwage. ");
INSERT INTO zaj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mowingigwa kulawa mzing'anda za nhambiko, na kipigiti chokwiza munhu yahawakoma mweye kogelegeza kamba kotenda gamnogele Mulungu. ");
INSERT INTO zaj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wowatendela mweye mbuli zino kwavija hawamtangile Tata ama nie. ");
INSERT INTO zaj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ila niwalongela gano mweye, giladi kipigiti hicho kihavika cha hewo kuzitenda mbuli zino mokumbukila kamba nisha kuwalongela. “Siwalongele mbuli zino haichanduso, kwavija nikala namwe. ");
INSERT INTO zaj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ila sambisambi nochola ha heyo yanhumile, hata avo haduhu munhu yoyose mmwanza wenu yambuzile, ‘Kwahi kuuchola?’ ");
INSERT INTO zaj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ila kwavija niwalongela mbuli zino, mioyo yenu ina giogio. ");
INSERT INTO zaj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ila nowalongela ikweli, vinoga ng'hani kumwenu vija vinichola, kwavija kamba sicholile, Ija wa Kuwataza heza kumwenu. Ila kamba nihachola, nomgala kumwenu. ");
INSERT INTO zaj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na yeheza, koulagusila ulumwengu kamba uhonyela mmbuli ya vilozo, uhonyela mgaja goyolonda Mulungu, na uhonyela mnhaguso ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Uhonyela mkutenda vilozo, kwavija uleka kunitogola nie, ");
INSERT INTO zaj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","uhonyela mkuleka kugagoga gaja goyolonda Mulungu, kwavija nochola ha Tata, ako kondamuleke kunyona kabili, ");
INSERT INTO zaj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","na uhonyela mnhaguso, kwavija mtawala wa ulumwengu uno kataguswa kamala. ");
INSERT INTO zaj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nna mbuli bwando za kuwalongela, ila mkipigiti kino hamdaha kugagoga gose. ");
INSERT INTO zaj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ila ayo Loho wa ikweli yeheza, kowalongoza muikweli yose. Kwavija halonga gaja goyolonda heyo mwenyego, ila kolonga gaja gose goyohulika, na kowalongela mbuli zose zikwiza. ");
INSERT INTO zaj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Koniyenzi nie, kwavija kozisola mbuli zangu na kuwapetela mweye. ");
INSERT INTO zaj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Gose gayalinago Tataangu, gangu nie, kino kicho kilamso cha nie kulonga Loho kosola mbuli zangu nie na kuwapetela mweye. ");
INSERT INTO zaj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kisigala kipigiti kidodo hamunyona, na kipigiti kidodo hamwande monyona.” ");
INSERT INTO zaj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Wanahina zake wayagwe wakiiuza, “Mbuli ino nhegulo yake choni, ahaja hayatulongele, ‘Kisigala kipigiti kidodo hamunyona, na kipigiti kidodo hamwande monyona,’ na ‘Kwavija nochola ha Tata’?” ");
INSERT INTO zaj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Walonga, “Mbuli ino nhegulo yake choni ahaja hayalongile, ‘Kipigiti kidodo’? Hatukitanga choyolonga!” ");
INSERT INTO zaj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu kavitanga kamba walonda kumuuza mbuli ino, avo kawalongela, “Mokiiuza nhegulo ya mbuli zija avija vinilongile, ‘Mkipigiti kidodo hamunyona, na abaho, mkipigiti kidodo monyona’? ");
INSERT INTO zaj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nowalongela ikweli, molila na kugegemeza, ila ulumwengu wodeng'helela. Mweye mokona giogio, ila giogio jenu dogaluka ndeng'helelo. ");
INSERT INTO zaj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mtwanzi yahawa mumgayo wa kulela kokona usungu, kwavija kipigiti chake kivika. Ila mwana yahavumbuka, koisemwa mgayo wake sama ya deng'ho da kuvumbuka mwana muulumwengu. ");
INSERT INTO zaj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Vino vivo ili kumwenu, sambisambi muna giogio, ila nobwela kabili kumwenu na mioyo yenu yomema ndeng'helelo, haduhu munhu yondayaisegeze. ");
INSERT INTO zaj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Zua dija dihavika, hamuniuza kinhu chochose. Nowalongela ikweli, Tata kowagwelela chochose chondamumpule mtwaga jangu. ");
INSERT INTO zaj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mbaka sambisambi hamunapula kinhu chochose mtwaga jangu, puleni na mobokela giladi ndeng'helelo yenu ivikizwe. ");
INSERT INTO zaj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Niwalongela mbuli zino mmahala. Ila kipigiti chokwiza siwalongela mmahala, ila nomulonga Tata hakimwagaia. ");
INSERT INTO zaj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kuna dizua dija, mompula Tata mtwaga jangu. Silonga kamba nie nompula Tata sama yenu. ");
INSERT INTO zaj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tata mwenyego kowanogela mweye, kwavija mweye muninogela nie na mtogola kamba nilawa ha Mulungu. ");
INSERT INTO zaj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nie nilawa ha Tata, niza muulumwengu. Na sambisambi nouleka ulumwengu, nobweleganya ha Tata.” ");
INSERT INTO zaj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Abaho, wanahina zake wamulongela, “Sambisambi kolonga utobola, bila kwika mahala. ");
INSERT INTO zaj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sambisambi tuvitanga kamba kila kinhu kukitanga, na hulonda munhu yoyose yakuuze mbuli. Gano gatutenda tweye tutogole kamba kulawa ha Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu kawalongela, “Sambisambi mtogola? ");
INSERT INTO zaj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kipigiti chokwiza na kipigiti kivika, mweye mose vondampwililike, kila munhu na kumwake, na monileka nie niiyeka. Ila sikala niiyeka, kwavija Tata ka hamoja na nie. ");
INSERT INTO zaj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Niwalongela gano giladi muwe na tindiwalo mkukala mgati yangu. Ulumwengu wowagaza, ila funyeni umoyo! Nie niuhuma ulumwengu!” ");
INSERT INTO zaj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu viyamambukize kulonga gano, kalola uchana kuulanga, kalonga, “Tata, kipigiti kivika. Umuyenzi Mwanago, giladi Mwana yakuyenzi gweye. ");
INSERT INTO zaj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kwavija kumgwelela udaho mwa wanhu wose, awo yondayawagwelele ugima wa digunge, wanhu awo yuumgwelele. ");
INSERT INTO zaj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na ugima wa digunge uwo uno, wakutange gweye Mulungu wiyeka uli wa ikweli, na wamtange Yesu Kilisto yuumtumile. ");
INSERT INTO zaj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nikugalila yenzi muulumwengu mkuimambukiza sang'hano yuungwelele niitende. ");
INSERT INTO zaj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Avo, Tata, uniyenzi haulongozi wako na yenzi kamba iija inikalile nayo kipigiti vinikalile nagwe kipigiti ulumwengu haunalumbigwa. ");
INSERT INTO zaj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nikutenda gweye twaga jako ditangigwe na awo yuungwelele kulawa muulumwengu. Wakala wanhu zako, kungwelela nie, na waigoga mbuli yako. ");
INSERT INTO zaj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sambisambi wavitanga kamba vinhu vose vuungwelele vilawa kumwako. ");
INSERT INTO zaj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Niwagwelela mbuli zuungwelele nie, na wazibokela. Wavitanga kamba nie nilawa kumwako, na watogola kamba gweye iyo unhumile. ");
INSERT INTO zaj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nowatambikila. Siutambikila ulumwengu, ila awo yuungwelele, kwavija wano wanhu zako. ");
INSERT INTO zaj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Wose inilinao nie, wako gweye, na wose uulinao gweye, wangu nie. Na nie mhata yenzi kubitila hewo. ");
INSERT INTO zaj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na sambisambi sili muulumwengu tena, ila hewo wa muulumwengu. Nie nokwiza kumwako. Tata Ung'alile! Wemilize na twaga jako, twaga diungwelele nie, giladi wawe kinhu kimwe kamba nie na gweye vituli kinhu kimwe. ");
INSERT INTO zaj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kipigiti vinikalile na hewo, niwemiliza na mhiko za twaga jako, twaga diungwelele nie. Niwakikiwiza, na haduhu hata imwe yapotele, ila ija imwe yalumbiligwe kupotela, giladi Nyandiko Zing'alile zivikile. ");
INSERT INTO zaj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na sambisambi nokwiza kumwako, ila nozilonga mbuli zino kipigiti ning'hali muulumwengu, giladi ndeng'helelo yangu imeme mgati yao. ");
INSERT INTO zaj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Niwagwelela mbuli yako, na ulumwengu uwehila, kwavija hewo sio wa ulumwengu, kamba vija nie vinili sio wa ulumwengu. ");
INSERT INTO zaj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Sikupula gweye uwalave muulumwengu, ila kinilonda kumwako uwemilize kulawa ha Mwenembago. ");
INSERT INTO zaj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Hewo sio wa ulumwengu, kamba vija nie vinili sio wa ulumwengu. ");
INSERT INTO zaj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Wang'alize na kweli yako. Mbuli yako iyo kweli. ");
INSERT INTO zaj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kamba gweye vuunhumile nie muulumwengu, na nie niwatuma hewo muulumwengu. ");
INSERT INTO zaj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Noing'aliza sama yao, giladi na hewo vivija wang'alizwe kwelikweli. ");
INSERT INTO zaj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Siwatambikila wano weiyeka, ila vivija awo wondawanitogole kubitila usenga kulawa mwa wano. ");
INSERT INTO zaj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nowatambikila giladi wose wawe kinhu kimwe. Tata! Kamba gweye vuuli mgati yangu nie na nie vinili mgati yako gweye, na hewo vivija wawe mgati yetu tweye, giladi ulumwengu utogole kamba gweye iyo unhumile. ");
INSERT INTO zaj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Niwagwelela yenzi kamba iija yuungwelele nie, giladi wawe kinhu kimwe kamba vija gweye na nie vituli kinhu kimwe. ");
INSERT INTO zaj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nie na mgati yao na gweye kwa mgati yangu, giladi wawe kinhu kimwe kabisa, na ulumwengu uvitange kamba gweye iyo unhumile, na kuwanogela kamba vuuninogele nie. ");
INSERT INTO zaj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tata! Nolonda wano yuungwelele wakale hamoja na nie haja hondanikale, giladi wayone yenzi yangu yuungwelele, kwavija gweye kuninogela nie songela ulumwengu haunalumbigwa. ");
INSERT INTO zaj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata Ulibule Uzenzeleganye! Ulumwengu haukutanga, ila nie nikutanga, na wano wakutanga kamba gweye iyo unhumile. ");
INSERT INTO zaj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nie iyo niditendile waditange twaga jako, na nogendelela kutenda avo, giladi vija vuuninogele nie uwanogele na hewo, avo na nie vivija niwe mgati yao.” ");
INSERT INTO zaj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu viyeshile kulonga mbuli zino, kasegela heyo na wanahina zake na kuloka bonde dikemigwa Kiduloni. Haja hakala na hanhu ha kuhumulila, avo Yesu na wanahina zake wengila haja. ");
INSERT INTO zaj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda, ija yomuhonza Yesu, kahatanga hanhu haja kwavija mianza bwando Yesu kakala yoiting'hanila na wanahina zake haja. ");
INSERT INTO zaj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Avo Yuda kachola hanhu haja ha kuhumulila hamoja na asikali wa Kiloma na wemilizi wa Ing'anda ya Mulungu, watumigwe na wakulu wa wakulu wa nhambiko na Mafalisayo. Wakala na mizele kuno wagogile taa na miwenge. ");
INSERT INTO zaj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu kuno yovitanga vinhu vose vikalile vilonda kumulawilila heyo, kakwenhuka haulongozi kawauza, “Yalihi imumzahila?” ");
INSERT INTO zaj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wamwidika, “Yesu wa Nazaleti.” Kalonga, “Nie iyo.” Yuda, ija yomuhonza Yesu, kakala bahaja yemile nao. ");
INSERT INTO zaj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu viyawalongele, “Nie iyo,” wabwela kuchugu, wagwa hasi. ");
INSERT INTO zaj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Abaho, Yesu kawauza kabili, “Yalihi imumzahila?” Wamulongela, “Yesu wa Nazaleti.” ");
INSERT INTO zaj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu kawalongela, “Nisha kuwalongela, ‘Nie iyo.’ Kamba mweye monizahila nie, walekeni wano wayagwe wachole na zao.” ");
INSERT INTO zaj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kalonga vino giladi gaja gayalongile gavikile, “Tata, waja ungwelele haduhu hata imwe inimwagize.” ");
INSERT INTO zaj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoni Petulo, yakalile na zele, kadisomola na kumkanha gwiti da ukulume Maliko, nyakadala wa Mkulu wa Wakulu wose wa Nhambiko. ");
INSERT INTO zaj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu kamulongela Petulo, “Bweza zele jako haja hadikalile! Kokwagiza nie sing'wela kikasi cha mgayo chayangwelele Tataangu?” ");
INSERT INTO zaj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Abaho, asikali wa Waloma na mkulu wao na wemilizi wa Ng'anda ya Mulungu wamgoga Yesu wamfunga, ");
INSERT INTO zaj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","tanhu wamgala ha Anasi, yakalile tata mkwe yake Kayafa, yakalile Mkulu wa Wakulu wose wa Nhambiko mulao uja. ");
INSERT INTO zaj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa iyo yakalile yawalongele wakulu wa Wayahudi kamba vinoga munhu imwe yadanganhike sama ya wanhu wose. ");
INSERT INTO zaj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petulo na mwanahina iyagwe wamkweleleza Yesu. Kwavija ija imwanahina iyagwe kakala yatangigwe goya na Mkulu wa Wakulu wose wa Nhambiko, avo kengila na Yesu mulubuga lwa mgati ya idikonhi da ing'anda ya Mkulu wa Wakulu wose wa Nhambiko, ");
INSERT INTO zaj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","na Petulo kasigala hanze behi na ulwivi lwa idikonhi. Abaho, ija imwanahina iyagwe, yakalile yatangigwe goya na Mkulu wa Wakulu wose wa Nhambiko, kabweleganya hanze kulonga na mndele yakalile mwimilizi wa ulwivi, na kumwingiza Petulo mgati ya idikonhi. ");
INSERT INTO zaj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ija imndele yokwimiliza ulwivi kamulongela Petulo, “Na gweye vivija kwa mwanahina wa munhu ija?” Petulo kamwidika, “Nie sili mwanahina wake.” ");
INSERT INTO zaj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kwavija kukala na beho waja iwanyakadala na iwemilizi wabwinha moto wa misizi, wakala wokota. Petulo na heyo vivija kakala yemile na hewo, yokota. ");
INSERT INTO zaj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mkulu wa Wakulu wose wa Nhambiko kamuuza Yesu mbuli ya wanahina zake na mafundo gake. ");
INSERT INTO zaj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu kamwidika, “Mazua gose nikala nilonga na wanhu wose hakimwagaia, mafundo gangu gose nifundiza mzing'anda za nhambiko na Kung'anda ya Mulungu amuja Wayahudi wose mowaiting'hana. Silongile kinhu chochose mkuifisa. ");
INSERT INTO zaj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Avo habali uniuzagiza nie? Wauze awo wakalile wonhegeleza, wagatanga ganilongile.” ");
INSERT INTO zaj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu viyalongile gano, mwimilizi imwe yakalile haja kamtoa kofi na kumulongela, “Kodahaze kumulongela kamba avo Mkulu wa Wakulu wose wa Nhambiko!” ");
INSERT INTO zaj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu kamwidika, yolonga, “Kamba nilonga kinhu chochose kihile, kilonge kinhu hicho. Ila kamba silongile kinhu kihile mmbuli zinilongile, habali unhoa?” ");
INSERT INTO zaj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Abaho, Anasi kamgala ha Kayafa Mkulu wa Wakulu wose wa Nhambiko, kuno Yesu yang'hali yadazigwe nzabi. ");
INSERT INTO zaj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kipigiti Petulo yang'hali yemile haja yokota moto, wanhu wayagwe wamulongela, “Gweye huli imwe wa wanahina zake munhu ija?” Petulo kabela, kalonga, “Nie sio.” ");
INSERT INTO zaj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nyakadala imwe wa Mkulu wa Wakulu wose wa Nhambiko, ndugu yake munhu ija yakanhigwe gwiti jake na Petulo, kamuuza, “Nie sikonile gweye na heyo haja hanhu ha kuhumulila?” ");
INSERT INTO zaj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kabili Petulo kabela, yolonga, “Sio nie.” Na bahaja nzogolo keka. ");
INSERT INTO zaj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Imitondo ng'hani Yesu kasoligwa kulawa kung'anda ya Kayafa wamgala kuding'anda da kindewa da Pilato, mndewa wa Yudea kulawa Loma. Wakulu wa Wayahudi hawengile mding'anda da kindewa, kwavija wadumba kuinyolodosa, kamba viili nzoela yao, giladi waije Pasaka. ");
INSERT INTO zaj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Avo Pilato, mkulu wa isi ya Loma, kalawa hanze, kawauza, “Choni chumumtagusila munhu ino?” ");
INSERT INTO zaj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wamwidika, “Kamba yahakalile bule mbuli ihile, sambitumgale kumwako.” ");
INSERT INTO zaj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato kawalongela, “Msoleni mwemwe wenyego, mkamtaguse kamba malagizo genu vigalonga.” Wamulongela, “Tweye hatulongeligwe kumtagusa munhu yoyose kudanganhika.” ");
INSERT INTO zaj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Gano galawilila giladi kuzitenda mbuli za Yesu zilawilile, haja hayailongile ifa yondayafe. ");
INSERT INTO zaj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato kabweleganya mding'anda da kindewa na kumkema Yesu, kamuuza, “Gweye iyo Mndewa wa Wayahudi?” ");
INSERT INTO zaj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu kamwidika, “Mbuli ino yuuniuza yolawa kumwako, ama wanhu wayagwe wakulongela mbuli zangu nie?” ");
INSERT INTO zaj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato kamwidika, “Kokwagiza nie na Muyahudi? Wanhu zako mwenyego na wakulu wa wakulu wa nhambiko wakugalile kumwangu. Kutenda choni?” ");
INSERT INTO zaj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu kalonga, “Undewa wangu si wa ulumwengu uno. Kamba undewa wangu uhawile wa ulumwengu uno, wemilizi zangu wahagombile kunigombeleza sambinigogigwe na wakulu wa Wayahudi. Ila undewa wangu sio wa hano!” ");
INSERT INTO zaj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Avo Pilato kamuuza, “Avo, gweye kwa mndewa?” Yesu kamwidika, “Gweye iyo ulonga kamba nie iyo mndewa. Nivumbuka sama ya mbuli ino, na sama ya mbuli ino niza muulumwengu kuilonga ikweli. Munhu yoyose yali muikweli konhegeleza.” ");
INSERT INTO zaj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato kamuuza, “Ikweli iyo ilihi?” Abaho, Pilato kabweleganya hanze ha Wayahudi, na kuwalongela, “Nie sonile mbuli yoyose ya kumtagusila. ");
INSERT INTO zaj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ila kwavija muna nzoela ya nie kuwafungulila mfungigwa imwe kipigiti cha Pasaka, avo molonda niwafungulile Mndewa wa Wayahudi?” ");
INSERT INTO zaj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wamwidika mkuguta nyangi, “Sambiutufungulile heyo! Tufungulile Balaba!” Balaba kakala m'bokonyi. ");
INSERT INTO zaj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Abaho, Pilato kalagiza Yesu yagogigwe na kulanhigwa. ");
INSERT INTO zaj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Asikali watenda mkungo wa mizomola na kumwikila mditwi jake. Abaho wam'vaza kanzu da zambalau, ");
INSERT INTO zaj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","na wamwizila mianza bwando womtendela mzihaka, wolonga, “Kwa mpile, Mndewa wa Wayahudi!” na kumtoa makofi mkihanga. ");
INSERT INTO zaj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato kalawa hanze mwanza uyagwe, na kuwalongela waja iwanhu, “Loleni, nowalavileni hanze munhu ino m'vitange kamba sonile mbuli yoyose ya kumtagusila.” ");
INSERT INTO zaj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Avo Yesu kalawa hanze yavalile kanzu da zambalau na mkungo wa mizomola mditwi. Pilato kawalongela, “Loleni, munhu mwenyego ino hano!” ");
INSERT INTO zaj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Wakulu wa wakulu wa nhambiko na iwemilizi wa Ing'anda ya Mulungu viwamonile, waguta, wolonga, “Muwambe mumsalaba! Muwambe mumsalaba!” Pilato kawalongela, “Nie sonile mbuli ya kumtagusila, avo msoleni mwemwe mkamuwambe mumsalaba.” ");
INSERT INTO zaj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Wayahudi wamulongela, “Tweye tuna lagizo, na sama ya lagizo hijo kolondigwa yadanganhike, kwavija kailonga heyo ka Mwana wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato viyahulike gano, kagendelela kona bwembwe. ");
INSERT INTO zaj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kabweleganya mgati ya iding'anda da kindewa na kumuuza Yesu, “Kwahi kuulawa gweye?” Ila Yesu hamwidike. ");
INSERT INTO zaj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato kamulongela, “Hunilongela? Huvitanga kamba nie nna udaho wa kukufungula na vivija nna udaho wa kukuwamba mumsalaba?” ");
INSERT INTO zaj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu kamwidika, “Gweye sambiuwe na udaho kumwangu nie kamba sambiugweleligwe na Mulungu. Avo munhu yangelile nie mmakono gako kana vilozo vikulu ng'hani.” ");
INSERT INTO zaj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Songela kipigiti kija, Pilato kageza kumfungula Yesu, ila Wayahudi wagendelela kutoa nyangi, wolonga, “Kamba uhamfungula munhu ino, gweye huli mbwiga wa Kaisali. Munhu yoyose yokiikema mndewa kom'beza Kaisali!” ");
INSERT INTO zaj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato viyahulike mbuli zino, kamulava Yesu kunze, abaho, heyo kakala mkigoda cha nhaguso, hanhu hokemigwa, “Bugano da Mabwe,” ama Mkieblania wohakema, “Gabbata.” ");
INSERT INTO zaj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Dikala zua da msasalo wa wiki ya Pasaka, kamba saa sita imisi. Pilato kawalongela Wayahudi, “Mndewa wenu ino hano!” ");
INSERT INTO zaj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Wenula lwangi, womulongela, “Mkome! Mkome! Muwambe mumsalaba!” Pilato kawauza, “Molonda nie nimuwambe mumsalaba mndewa wenu?” Wakulu wa wakulu wa nhambiko wamwidika, “Tweye twabule mndewa iyagwe ila Kaisali.” ");
INSERT INTO zaj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Abaho, Pilato kamgela Yesu mmakono gao wakamuwambe mumsalaba. Avo wamsola Yesu, ");
INSERT INTO zaj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","kuno yapapile msalaba wake heyo mwenyego, kachola “Hanhu ha Fulu da Pala” aho hakemigwe Mkieblania, “Goligota.” ");
INSERT INTO zaj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Haja baho wamuwambile, na vivija wawawamba wanhu wayagwe wabili, imwe mkono wake wa ukumoso na imwe mkono wake wa ukulume, na Yesu hagatigati yao. ");
INSERT INTO zaj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato kalagiza chandikwe kibao kikigwe uchana ya umsalaba, kilonga, “yesu wa nazaleti, mndewa wa wayahudi.” ");
INSERT INTO zaj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wayahudi bwando wakisoma, kwavija hanhu hayawambigwe Yesu hakala si kutali kulawa hakiwambo. Kija ikibao kikala chandikigwe Mkieblania, Mkilatini, na Mkigiliki. ");
INSERT INTO zaj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Wakulu wa wakulu wa nhambiko wa Wayahudi wamulongela Pilato, “Sambiwandike ‘Mndewa wa Wayahudi,’ ila uhandike, ‘Munhu ino kalonga, nie iyo Mndewa wa Wayahudi.’ ” ");
INSERT INTO zaj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato kawedika, yolonga, “Kinyandike, nyandika.” ");
INSERT INTO zaj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Asikali viweshile kumuwamba Yesu mumsalaba, wasola vivalo vake na kuvigola m'vifumvugulu vine, kila imwe na kifumvugulu chake. Vivija wasola ikanzu ilukigwe dimwe kwa dimwe bila lusilili lwa kushonigwa koneka. ");
INSERT INTO zaj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Waja iwaasikali wakiilongela, “Sambituidege, na tuitoele kula tulole yalihi yondayaipate.” Galawilila gano giladi kuzitenda Zinyandiko Zing'alile zivikile, zilonga, “Waigolela vivalo vangu wenyego kwa wenyego na kuitoela kula kanzu yangu.” Vino vivo iwaasikali viwatendile. ");
INSERT INTO zaj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Behi na umsalaba wa Yesu wakala wemile mamaake Yesu, na lumbu ja mamaake Yesu, na Maliamu mtwanzi wa Kiliopa, na Maliamu wa kiwambo cha Magidala. ");
INSERT INTO zaj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu viyamonile mamaake na ija imwanahina yamnogele yemile hamgwazo wake, kamulongela mamaake, “Mama, ino iyo mwanago.” ");
INSERT INTO zaj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Abaho, kamulongela ija imwanahina, “Ino iyo mamaako.” Songela kipigiti kija, ija imwanahina kamsola kachola kukala nayo ukae yake. ");
INSERT INTO zaj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu kavitanga kamba kipigiti kino kila kinhu kimala, na giladi yazitende Zinyandiko Zing'alile zilawilile kweli, kalonga, “Nokona ng'hilu.” ");
INSERT INTO zaj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na haja kukala na kikonha kimemile divai ya ugwadu, avo wazabika siponji mkikonha cha idivai, waika isiponji mulumango lwa hisopo, wawinula mbaka hamulomo wake. ");
INSERT INTO zaj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu kaing'wa idivai na kulonga, “Imala!” Abaho, kaidulika na kudanganhika. ");
INSERT INTO zaj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Avija vidikalile zua da msasalo wa Pasaka, na zua da ikabili dikala Zua kulu da Mhumulo, wakulu wa Wayahudi hawalondile waja iwanhu walekigwe mmisalaba kipigiti cha Zua da Mhumulo. Avo wampula Pilato yalagize gabenigwe magulu ga wanhu wawambigwe mumsalaba. Abaho wawahumuluse hasi. ");
INSERT INTO zaj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Avo asikali weza na kubena magulu ga munhu wa ichanduso, yakalile yawambigwe mumsalaba hamoja na Yesu, abaho ija wa ikabili. ");
INSERT INTO zaj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ila viwavikile ha Yesu, wam'vika yeshile kudanganhika, avo magulu gake hawagabenile. ");
INSERT INTO zaj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ila asikali imwe kamuhoma Yesu mulubavu na mgoha wake, na bahaja ulawa mulopa na mazi. ");
INSERT INTO zaj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Munhu yonile gano galawilile kagalonga, giladi na mweye vivija mtogole. Na gaja gayalongile kalonga kweli, na heyo kavimanya kamba kalonga kweli. ");
INSERT INTO zaj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mbuli zino zilawilila giladi Zinyandiko Zing'alile zivikile, “Haduhu hata luzege lwake lumwe londalubenigwe.” ");
INSERT INTO zaj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na kuna Nyandiko ziyagwe Zing'alile zilonga, “Womulola ayo iwamtobole.” ");
INSERT INTO zaj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Abaho, Usufu, yakalile yolawa kukiwambo cha Alimataya, kampula Pilato yalusole lukuli lwa Yesu. Usufu kakala mwanahina wa Yesu, ila kakala yoifisa, kwavija kakala yowadumba wakulu wa Wayahudi. Pilato kamulongela yakalusole, avo Usufu kachola kulusegeza. ");
INSERT INTO zaj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo, ayo haichanduso yakalile yacholile ikilo kumulola Yesu, kachola na Usufu na kibweta cha vinung'hanung'ha va manemane na ubane vikalile na nzamo ya kilo malongo madatu. ");
INSERT INTO zaj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Wanhu wano wabili walusola lukuli lwa Yesu, na kulugela msanda na ivinung'hanung'ha, kamba viwatendaga Wayahudi mkusasala lukuli na mazisi. ");
INSERT INTO zaj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Haja Yesu hayakomigwe kukala na hanhu ha kuhumulila, hanhu haja hakala na panga da sambi hadinazikigwa munhu yoyose. ");
INSERT INTO zaj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kwavija dikala zua da Wayahudi da msasalo wa Zua da Mhumulo, na kwavija dija idipanga dikala behi, walwika lukuli lwa Yesu haja. ");
INSERT INTO zaj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ndamuka ya zua da mwanduso wa wiki, usiku haunakucha goya, Maliamu wa kiwambo cha Magidala kachola kudipanga, kavika idibwe dikalile hamulomo wa idipanga disegezigwa. ");
INSERT INTO zaj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kakimbila kachola ha Simoni Petulo na ha ija imwanahina iyagwe ayo Yesu yamnogele na kuwalongela, “Wamsegeza Mndewa haja hadipanga, na hatukutangile kuwamwikile!” ");
INSERT INTO zaj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Abaho, Petulo na ija imwanahina iyagwe wachola kudipanga. ");
INSERT INTO zaj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wose wabili wakimbila, ila ija imwanahina iyagwe kakimbila ng'hani kum'banza Petulo na kumulongola kuvika kudipanga. ");
INSERT INTO zaj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kainamila na kusungulila mgati, kayona isanda, ila hengile mgati. ");
INSERT INTO zaj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoni Petulo yakalile kuchugu chake, kavika na kengila dimwe kwa dimwe mdipanga. Kavona ivitambala va isanda viwasile haja, ");
INSERT INTO zaj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","vivija na ikitambala kikalile kizingilizwe mdipala da Yesu. Hakikalile hamoja na isanda ila kikunzigwa na kiinega kutali na isanda. ");
INSERT INTO zaj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Abaho, ija imwanahina iyagwe yavikile haichanduso kudipanga na heyo kengila mgati, kalola na kutogola. ");
INSERT INTO zaj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Wakala hawanazimanya Zinyandiko Zing'alile zilonga kamba kolondigwa yazuke kulawa mkudanganhika. ");
INSERT INTO zaj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Abaho, waja iwanahina wabweleganya mkae zao. ");
INSERT INTO zaj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maliamu kema hanze ya idipanga yolila. Kuno yang'hali yolila, kainamila kalola mgati mwa idipanga, ");
INSERT INTO zaj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","na kawona wasenga wabili wa Mulungu wa kuulanga wavalile miguo mizelu, wakala haja halukalile lukuli lwa Yesu, imwe kuna iditwi na imwe kuna gamagulu. ");
INSERT INTO zaj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Wamuuza, “Gweye mtwanzi, habali ulila?” Kedika, yolonga, “Wamsegeza Mndewa wangu, na sikutangile kuwamwikile!” ");
INSERT INTO zaj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Abaho, kahinduka, kamona Yesu yemile bahaja, ila havimanyile kamba kakala Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu kamuuza, “Gweye mtwanzi, habali ulila? Yalihi yuumzahila?” Kuno yokwagiza kakala msang'hanika wa haja ihanhu ha kuhumulila, avo kamulongela, “Mndewa, kamba gweye iyo umsegeze, nongela kwahi kuumwikile nichole nikamsole.” ");
INSERT INTO zaj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu kamulongela, “Maliamu!” Kamuhindukila na kulonga Mkieblania, “Labboni!” Nhegulo yake, “Mkulufunzi.” ");
INSERT INTO zaj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu kamulongela, “Sambiuninanahile kwavija sinachola uchana ha Tata. Ila genda ha wanahina zangu uwalongele kamba nie nobweleganya ha Tataangu na Tata wenu, Mulungu wangu na Mulungu wenu.” ");
INSERT INTO zaj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Avo Maliamu wa kiwambo cha Magidala kachola kuwalongela wanahina kamba kamona Mndewa, na kuwalongela gaja gose gayamulongele. ");
INSERT INTO zaj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ikala ichungulo ya zua da mwanduso wa wiki, na wanahina wakala waiting'hane hamoja na kuno nyivi za ing'anda zikala zihindigwe, kwavija wakala wowadumba wakulu wa Wayahudi. Abaho, Yesu keza na kwima hamoja na hewo, kalonga, “Tindiwalo diwe hamoja namwe.” ");
INSERT INTO zaj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Viyeshile kulonga gano, kawalagusila makono gake na lubavu lwake. Waja iwanahina wakala wamemile ndeng'helelo viwamonile Mndewa. ");
INSERT INTO zaj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu kawalongela kabili, “Tindiwalo diwe hamoja namwe. Kamba vija Tata viyanhumile nie, avo na nie nowatuma.” ");
INSERT INTO zaj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Abaho, kawahuzila na mhumuzi yake, kawalongela, “Bokeleni Loho wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kamba muhavigela kumgongo vilozo va wanhu, vogeligwa kumgongo. Na kamba hamuvigelile kumgongo, havigeligwa kumgongo.” ");
INSERT INTO zaj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Imwe wa waja wanahina longo dimwe na wabili yokemigwa Tomaso, twaga diyagwe Ubasa, kakala haduhu viyezile Yesu. ");
INSERT INTO zaj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Avo waja iwanahina wayagwe wamulongela, “Tumona Mndewa!” Tomaso kawalongela, “Kamba sonile ng'hovu za misumali mmakono gake na kwika kidole changu mzing'hovu zake na mkono wangu mulubavu lwake, sitogola kamba kazuka!” ");
INSERT INTO zaj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Vigabitile mazua saba wanahina zake waiting'hana kabili mng'anda, na Tomaso kakala baho. Nyivi zikala zihindigwe, ila Yesu keza na kwima na hewo, kalonga, “Tindiwalo diwe hamoja namwe.” ");
INSERT INTO zaj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Abaho, kamulongela Tomaso, “Ika kidole chako na ugalole makono gangu, abaho, golosa mkono wako uwike mulubavu lwangu. Sambiudungwedungwe mmoyo, ila utogole.” ");
INSERT INTO zaj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaso kamulongela, “Mndewa wangu na Mulungu wangu.” ");
INSERT INTO zaj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu kamulongela, “Gweye kutogola kamba nizuka kwavija kunyona. Wamota ng'hani awo wondawatogole bila kunyona.” ");
INSERT INTO zaj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Mizonza yaatendile Yesu hameso ga wanahina zake ilekile kwandikigwa mkitabu kino ikala bwando. ");
INSERT INTO zaj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ila gano gandikigwa giladi mtogole kamba Yesu iyo Kilisto, Mwana wa Mulungu, na mkutogola gano muupate ugima mtwaga jake. ");
INSERT INTO zaj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Abaho, Yesu kawalawilila wanahina zake mwanza uyagwe Kudilamba da Tibelia. Vino vivo viyawalawilile. ");
INSERT INTO zaj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petulo, na Tomaso yakemigwe Ubasa, na Natanieli ayo yakalile yolawa Kana ako Galilaya, na wana wa Zebedayo, na wanahina wayagwe wabili wa Yesu wakala hamoja. ");
INSERT INTO zaj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petulo kawalongela wayage, “Nie nochola kuloa somba.” Wamulongela, “Na tweye tokwiza.” Avo walawa wachola kwingila mngalawa, ila ikilo ija hawapatile kinhu. ");
INSERT INTO zaj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Imitondo ng'hani, Yesu kema mulugigo lwa igamazi, ila wanahina zake hawamtangile kamba kakala heyo. ");
INSERT INTO zaj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kawauza, “wambwiga zangu, muna somba?” Walonga, “Twabule.” ");
INSERT INTO zaj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kawalongela, “Tandeni nhando yenu ng'ambu ya ukulume ya ingalawa, na mokonza.” Avo waitanda inhando na hawadahile kuikwega waibweze mngalawa, kwavija wawonza somba bwando. ");
INSERT INTO zaj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ija imwanahina Yesu iyamnogele kamulongela Petulo, “Kumbe Mndewa!” Petulo viyahulike kumbe Mndewa, kaizinga mkigudi kivalo chake cha kuigubika, na kuzumha mmazi, kwavija kakala yavulile vivalo vake. ");
INSERT INTO zaj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Wanahina wayagwe weza kuingalawa na kuikwekwesa inhando imemile somba, kwavija hawakalile kutali kulawa muisi inyalile, ikala kamba meta mia. ");
INSERT INTO zaj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Viwavikile muisi inyalile, wona moto wa misizi, uchana yake kukala somba na mkate. ");
INSERT INTO zaj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Abaho, Yesu kawalongela, “Ngalileni somba kidogo wumonzile sambisambi.” ");
INSERT INTO zaj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoni Petulo kachola mngalawa na kuibululila kunyalile inhando imemile somba wakulu mia imwe na malongo matano na wadatu. Wakala somba bwando hata avo inhando haidegeke. ");
INSERT INTO zaj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu kawalongela, “Izoni mje.” Haduhu hata mwanahina imwe yagezile kumuuza, “Gweye iyo yalihi?” kwavija wavitanga kamba kakala Mndewa. ");
INSERT INTO zaj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Avo Yesu kachola kasola umkate na kuwagwelela, abaho, katenda vivija na isomba. ");
INSERT INTO zaj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Uno ukala mwanza wa ikadatu Yesu kuwalawilila wanahina zake songela hayazukile. ");
INSERT INTO zaj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Viweshile kuja, Yesu kamulongela Simoni Petulo, “Simoni, mwana wa Yohana, koninogela nie kubanza wano wayagwe viwoninogela?” Kamwidika, “Ona, Mndewa, gweye kuvitanga kamba nokunogela.” Yesu kamulongela, “Wagwelele mandia ng'hondolo zangu.” ");
INSERT INTO zaj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu kamulongela mwanza wa ikabili, “Simoni, mwana wa Yohana, koninogela nie?” Kamwidika, “Ona, Mndewa, gweye kuvitanga kamba nie nokunogela.” Yesu kamulongela, “Imiliza ng'hondolo zangu.” ");
INSERT INTO zaj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu kalonga mwanza wa ikadatu, “Simoni, mwana wa Yohana, koninogela?” Petulo kona giogio avija Yesu viyamuuzile mwanza wa ikadatu, “Koninogela?” Avo kamulongela Yesu, “Mndewa, gweye kugamanya gose. Na kuvimanya kamba nokunogela!” Yesu kamulongela, “Wagwelele mandia ng'hondolo zangu. ");
INSERT INTO zaj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nokulongela ikweli, vuukalile mmhale, kukala ukiifunga mkwiji na kuchola kokose kuulondile kuchola. Ila uhalala, kogogolosa makono gako na munhu iyagwe kokufunga na kukusola yakugale hanhu hukulondile kuchola.” ");
INSERT INTO zaj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Mkulonga gano, Yesu kalagusa ifa ilihi Petulo yondayafe na yondaimgalile yenzi Mulungu. Abaho, kamulongela, “Nikweleleze.” ");
INSERT INTO zaj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petulo kahinduka kuchugu kamona ija imwanahina Yesu iyamnogele kowakweleleza. Ino iyo munhu ija yakalile behi na Yesu viwakalile woja mkate wa ugima na iyo yalongile, “Mndewa, yalihi yondayakuhonze?” ");
INSERT INTO zaj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petulo viyamuwene, kamuuza Yesu, “Mndewa, vilihi na ino?” ");
INSERT INTO zaj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu kamwidika, “Kamba nihalonda yakale mbaka niheza, ikudwanzaze? Nikweleleze!” ");
INSERT INTO zaj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Avo mbuli zenela mwa wanahina wa Yesu kamba mwanahina ino hadanganhika. Ila Yesu halongile vija kamba hadanganhika, ila kalonga, “Kamba nihalonda yakale mbaka niheza, ikudwanzaze?” ");
INSERT INTO zaj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Heyo iyo ija imwanahina yazilongile mbuli zino, na vivija iyo yazandike, na tuvimanya kamba gaja gayalongile kalonga kweli. ");
INSERT INTO zaj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Na kuna mbuli bwando ziyagwe zayatendile Yesu. Kamba zose zihandikwe, nokwagiza kamba ulumwengu wose sambiudahe kuvipapa ivitabu vandikigwe.");
INSERT INTO zaj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mkulu Teofilo, muna ikitabu changu cha ichanduso, nyandika mbuli zose ziyatendile Yesu na kufundiza songela mwanduso wa sang'hano yake ");
INSERT INTO zaj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mbaka zua dija diyasoligwe kuchola kuulanga, viyeshile kulava malagizo kubitila Loho wa Mulungu ha iwatumigwa iyawasagule. ");
INSERT INTO zaj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mkipigiti cha mazua malongo mane songela viyadanganhike, Yesu kawalawilila watumigwa zake mianza bwando giladi yawatende watogole kamba kakala mgima. Wamona, na heyo kawalongela mbuli za Undewa wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na viyaiting'hane nao, kawalagiza yolonga vino, “Sambimsegele Yelusalemu, ila beteni ija inhunza iniwalongele, nhunza iyekile kilagano Tataangu. ");
INSERT INTO zaj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohana kabatiza na mazi, ila mazua madodo hamwande, mweye mobatizigwa na Loho wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Watumigwa wa Kilisto viwaiting'hane hamoja, wamuuza Yesu, “Mndewa, kino kicho kipigiti chondauwabwezele undewa Waislaeli?” ");
INSERT INTO zaj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ila Yesu kawalongela, “Kipigiti na msimu wa mbuli hizo va mmakono ga Tataangu. Mweye, sio sang'hano yenu kukitanga kipigiti na msimu wa mbuli hizo vondazilawilile. ");
INSERT INTO zaj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ila Loho wa Mulungu vondayawezile, mobokela mhiko, na mowapetela wanhu mbuli zangu zimziwene mkiwambo cha Yelusalemu, muisi yose ya Yudea na Samalia, na hata hakimambukizo cha ulumwengu.” ");
INSERT INTO zaj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Viyamambukize kulonga avo, kasoligwa uchana kuulanga, na wose wamulola mbaka mawingu vigamfisile. ");
INSERT INTO zaj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Viwakalile wang'hali wolola kuulanga kipigiti Yesu viyakalile yochola, wedukila wanhu wabili wavalile vivalo vizelu wema behi na hewo. ");
INSERT INTO zaj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Walonga, “Mweye wanhu wa Galilaya, habali mwimile hano na kulola kuulanga? Yesu ino yasoligwe kulawa hamwenu kuchola kuulanga, kobweleganya mwanza uyagwe kamba vivija vimmuwene yochola kuulanga.” ");
INSERT INTO zaj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Abaho, watumigwa wa Kilisto wabwela Yelusalemu kulawa Hakigongo cha Mizaituni, kukalile na utali wa kilometa imwe kulawa mkiwambo hicho. ");
INSERT INTO zaj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Viwavikile mkiwambo, wengila mdigati da uchana, kuwakalile wokala Petulo, Yohana, Yakobo, Endelea, Filipo, Tomaso, Batolomayo, Matayo, Yakobo mwana wa Alufayo, Simoni yakalile yokemigwa Mgombeleza isi ya Islaeli, na Yuda mwana wa Yakobo. ");
INSERT INTO zaj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wano wose wakala wogendelela kuiting'hana hamoja kutambika, hamoja na watwanzi wayagwe, na Maliamu mamaake Yesu, na ndugu zake Yesu. ");
INSERT INTO zaj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mazua madodo hamwande, Petulo kema ha wanhu wamtogole Kilisto wakalile waiting'hane, dale jose dikala wanhu mia na malongo mabili, ");
INSERT INTO zaj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","kalonga, “Ndugu zangu, Nyandiko Zing'alile zilongigwe umwaka na Loho wa Mulungu kubitila mulomo wa Daudi zimulonga Yuda, yawalongoze awo wamgogile Yesu, zolondigwa zivikile. ");
INSERT INTO zaj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda kakala mmwanza wetu, kwavija kasaguligwa yasang'hanike msang'hano ino.” ");
INSERT INTO zaj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kagula mgunda kulawa mzihela ziyapatile mzisang'hano zake zihile, kagwa hasi, katulika, na utumbo wake ukutuka hanze. ");
INSERT INTO zaj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Wanhu wose wa Yelusalemu waihulika mbuli hiyo, avo muulonzi wa kumwao waukema mgunda uwo Akelidama, nhegulo yake “Mgunda wa Mulopa.” ");
INSERT INTO zaj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petulo kagendelela kulonga, “Kwavija yandikigwa muna ikitabu cha Zabuli, ‘Ng'anda yake ikale bila kinhu, na mgati yake sambiyakale munhu yoyose.’ Vivija yandikigwa, ‘Munhu iyagwe yasole hanhu ha sang'hano yake.’ ");
INSERT INTO zaj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Avo kolondigwa yasaguligwe munhu imwe kulawa mmwanza wa wanhu wakalile hamoja na tweye mkipigiti chose vitukalile na Mndewa Yesu, ");
INSERT INTO zaj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","songela Yesu viyabatizigwe na Yohana, mbaka zua dija Yesu viyasoligwe kulawa kumwetu kuchola uchana kuulanga. Na munhu imwe mdidale jao kowa msindila wa mzuso wake hamoja na tweye.” ");
INSERT INTO zaj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Avo wasagula matwaga ga wanhu wabili, Usufu, yakemigwe Balisaba yakalile na twaga diyagwe dikemigwa Yusto, na Matia. ");
INSERT INTO zaj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Abaho, watambika, walonga, “Mndewa, gweye koitanga mioyo ya wanhu wose, avo tulagusile yalihi muna iwanhu wano wabili yuumsagule ");
INSERT INTO zaj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","giladi yasole sang'hano ino ya kitumigwa ayo iyailekile Yuda na kunhu kuyailumbile nako.” ");
INSERT INTO zaj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Na viwasagule, kula imulagalila Matia, avo na heyo kongezigwa muna ididale da watumigwa wa Kilisto longo dimwe na imwe. ");
INSERT INTO zaj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Vidivikile zua da Pentekoste, wanhu wose wamtogole Kilisto wakala waiting'hane hanhu hamwe. ");
INSERT INTO zaj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Baho kiza kidinhilo kulawa kuulanga kilingile na m'bumo wa kukuzumbi, na kumemeza ng'anda yose iwakalile wakalile. ");
INSERT INTO zaj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Abaho, wona vinhu vilingile kamba ndimi za moto ziigolile na kukala hachana ya kila munhu yakalile haja. ");
INSERT INTO zaj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wose wamemezwa Loho wa Mulungu, wasonga kulonga lonzi za wanhu wayagwe kamba Loho viyawadahize kulonga. ");
INSERT INTO zaj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na ako Yelusalemu kukala na Wayahudi wakalile womtogola Mulungu, wakalile wolawa muisi zose za ulumwengu. ");
INSERT INTO zaj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Viwahulike mbuli zino, dale kulu da wanhu diiting'hana. Wose wakanganya, kwavija kila munhu kawahulika wolonga muulonzi wake mwenyego. ");
INSERT INTO zaj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Wakanganya ng'hani na kulonga, “Wanhu wose wano wolonga si wanhu wa Galilaya? ");
INSERT INTO zaj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Avo, vilihi tweye kila munhu mmwanza wetu kowahulika wolonga muulonzi wake mwenyego? ");
INSERT INTO zaj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wayagwe wenekae wa Palitia, Media, na Elamu, na wayagwe wenekae wa Mesopotamia, Yudea, Kapadokia, na wayagwe wolawa Ponto na Asia, ");
INSERT INTO zaj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Fligia na Pamfilia, Misili na ng'ambu za Libia behi na Kilene, na wahenza wayagwe kulawa mdiwambo da Loma, ");
INSERT INTO zaj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","na Wayahudi wose na waja waitogole dini ya Kiyahudi, na wayagwe wanhu kulawa Kilete na Alabu. Na tweye towahulika vowolonga sang'hano ng'hulu ziyatendile Mulungu muulonzi wetu wenyego!” ");
INSERT INTO zaj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wose wakanganya na kwazanywa, wakiiuza, “Mbuli ino nhegulo yake choni?” ");
INSERT INTO zaj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ila wanhu wayagwe wawaponeza wolonga, “Wanhu wano wakoligwa!” ");
INSERT INTO zaj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Baho Petulo kema hamoja na watumigwa wa Kilisto longo dimwe na imwe, kenula dizwi kalonga, “Wayahudi wayangu na wanhu wose mkala Yelusalemu, tegelezeni goya, giladi muitange mbuli ino. ");
INSERT INTO zaj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wanhu wano hawakoligwe kamba vimgelegeza mweye, kwavija sambi saa ndatu imitondo. ");
INSERT INTO zaj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ila, mbuli ino iyo ilongigwe na muhokozi Yoeli, ");
INSERT INTO zaj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mulungu kalonga, muna gamazua ga kimambukizo, kila munhu nomwitila Loho wangu. Wanenu wa kimbigalo na wa kitwanzi wohokola, wasongolo zenu wokona nzozi, na wavyele zenu wolota. ");
INSERT INTO zaj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ona, vivija na watumigwa zangu wose, wakimbigalo na wakitwanzi, nowetila Loho wangu mmazua higo, na hewo wohokola. ");
INSERT INTO zaj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Notenda mizonza uchana kuulanga, na vilaguso hasi muisi, kowa na mulopa, moto, na yosi kulu. ");
INSERT INTO zaj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Zua dogaluka kuwa ziza, na mulenge wowa mdung'hu kamba mulopa, kipigiti hadinalawila zua dija kulu dili na yenzi da kwiza kwa Mndewa. ");
INSERT INTO zaj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Abaho, munhu yoyose yondayatambike mtwaga da Mndewa, kokomboligwa.’ ");
INSERT INTO zaj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Mweye wanhu wa Islaeli, tegelezeni mbuli zino. Yesu wa Nazaleti iyo munhu yakalile na udaho wa kiungu ugubuligwe kumwenu na mizonza, mbuli za mkanganyo, na vilaguso viyatendile Mulungu kumwenu kubitila heyo, kamba vumtanga. ");
INSERT INTO zaj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Munhu ino kalavigwa kamba viyalondile Mulungu na viyatangile songela mwaka, na mweye mumkoma mkuwalekela wanhu wehile wamuwambe mumsalaba. ");
INSERT INTO zaj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ila Mulungu kamzusa, kamkombola kulawa muna gamasungu ga kudanganhika, kwavija havidahike ifa imgoge. ");
INSERT INTO zaj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kwavija Daudi kalonga yomulonga heyo, ‘Nimona Mndewa haulongozi wangu mazua gose, kwavija kokala ng'ambu ya mkono wangu wa ukulume giladi sambinigudemezwe. ");
INSERT INTO zaj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Avo, moyo wangu wodeng'helela, na lulimi lwangu lotoa lukenze lwa ndeng'ha. Na lukuli lwangu lose lokala mditamanilo, ");
INSERT INTO zaj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kwavija huileka loho yangu kuzimu, na humuleka Munhu wako Yang'alile yole mdipanga. ");
INSERT INTO zaj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kundagusila nzila za ugima, konitenda nideng'he mkukala hamoja na nie.’ ");
INSERT INTO zaj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Ndugu zangu Waislaeli, ndekeni niwalongele bila kudumba mbuli zimpatile tata wetu Daudi. Heyo kadanganhika na kuzikigwa, na panga jake da bahano kumwetu mbaka lelo. ");
INSERT INTO zaj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ila kwavija Daudi kakala muhokozi, kavitanga kamba Mulungu kamduilila kamba munhu imwe kulawa mulukolo lwake Daudi komwika mkigoda chake cha undewa. ");
INSERT INTO zaj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi kagatanga gaja gose Mulungu gayalondile kutenda, avo kalonga mbuli ya kuzuka kwa Kilisto, ‘Halekigwe kuzimu, na lukuli lwake halolile mdipanga.’ ");
INSERT INTO zaj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu ino kazusigwa na Mulungu, na tweye tose tukala wasindila wa mbuli ino. ");
INSERT INTO zaj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kenuligwa uchana na kwikigwa mkono wa ukulume wa Mulungu, na kum'bokela Loho wa Mulungu yalalikigwe na Tata, na kutwitila gano gomgona na kugahulika. ");
INSERT INTO zaj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kwavija Daudi hakwelile kuulanga, ila kalonga, ‘Mndewa kamulongela Mndewa wangu, “Kala kumkono wangu wa ukulume ");
INSERT INTO zaj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mbaka vondaniweke wadumuka zako wawe kamba kigoda cha kwikila magulu gako.” ’ ");
INSERT INTO zaj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Wanhu wose wa Islaeli wolondigwa kuvitanga kamba Yesu ino immuwambile mumsalaba, Mulungu kamtenda kamba Mndewa na Kilisto!” ");
INSERT INTO zaj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Abaho, wanhu viwahulike vino, wahomigwa mmioyo yao, wamuuza Petulo na waja watumigwa wa Kilisto wayagwe, “Ndugu zetu, tutende choni?” ");
INSERT INTO zaj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petulo kawalongela, “Kila munhu mmwanza wenu yaleke vilozo vake na kubatizigwa mditwaga da Yesu Kilisto giladi msegezeligwe vilozo venu, na kubokela nhunza ya Loho wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kwavija kilagano kino kiza sama yenu mweye, na sama ya wanenu, na sama ya wanhu wose wokala kutali, nhegulo yake sama ya kila munhu yakemigwe na Mndewa Mulungu wetu.” ");
INSERT INTO zaj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petulo kawalongela mbuli ziyagwe bwando na kuwagong'ondeza, yolonga, “Ikomboleni kulawa muna inhaguso yondaize ya wanhu wa mulelo uno wihile!” ");
INSERT INTO zaj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Wanhu wautogole usenga wake wabatizigwa, na zua dija wongezeka kamba wanhu alufu ndatu. ");
INSERT INTO zaj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kipigiti chose wakala wobokela mafundo kulawa ha watumigwa wa Kilisto, wakala hamoja, waumogola mkate, na kutambika. ");
INSERT INTO zaj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mizonza na mbuli bwando za mkanganyo zitendigwa kubitila watumigwa wa Kilisto, na wanhu wose wona bwembwe. ");
INSERT INTO zaj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Wanhu wose wamtogole Kilisto wagendelela kukala hamoja na kuigolela vinhu vao. ");
INSERT INTO zaj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Wakala woguza mali na vinhu vao, abaho, wamgolela hela munhu yoyose yakalile bule kinhu. ");
INSERT INTO zaj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mazua gose wagendelela kuiting'hana hamoja muna Ing'anda ya Mulungu, na kipigiti cha kumogola mkate, waiting'hana mzikae zao na waja mandia mkudeng'ha na mioyo ing'alile. ");
INSERT INTO zaj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Wamuyenzi Mulungu, na kunogelwa na wanhu wose. Mazua gose Mndewa kongeza mheta ya ididale da wanhu wakalile wokomboligwa. ");
INSERT INTO zaj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Zua dimwe, saa tisa ichungulo, mkipigiti cha kutambika, Petulo na Yohana wakala wochola Kuing'anda ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na kukala na munhu imwe yakalile mbetembete songela viyavumbuke. Munhu iyo kakala yopapigwa na wanhu mazua gose na kwikigwa hana ulwivi lwa Ing'anda ya Mulungu lukemigwe “Lwivi Lunogile,” giladi yapule hela ha wanhu wakalile wokwingila Muing'anda ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Viyawawene Petulo na Yohana wokwingila muna Ing'anda ya Mulungu, kawapula wamgwelele kinhu chochose. ");
INSERT INTO zaj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petulo kamulola ng'hani na Yohana katenda vivija, abaho, Petulo kamulongela, “Tulole tweye!” ");
INSERT INTO zaj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Avo kawalola, kuno yotamanila kupata kinhu kulawa kumwao. ");
INSERT INTO zaj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ila Petulo kamulongela, “Nie nabule feza ama zahabu, ila nokugwaa kija nilinacho. Mtwaga da Yesu Kilisto wa Nazaleti, wime utembele!” ");
INSERT INTO zaj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Abaho, kamgoga na mkono wake wa ukulume, kamwinula. Na bahaja magulu na ng'ongo zake zigangamala. ");
INSERT INTO zaj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kazumhazumha na magulu gake na kasonga kutembela. Abaho, kengila muna Ing'anda ya Mulungu hamoja na hewo, kuno yotembela na kuzumhazumha na kumuyenzi Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wanhu wose viwamuwene yotembela na kumuyenzi Mulungu, ");
INSERT INTO zaj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","wamtanga kamba munhu ija iyo yakalile yopula behi na Ulwivi Lunogile lwa Ing'anda ya Mulungu, wakanganya ng'hani na wazanywa na gaja gamulawilile. ");
INSERT INTO zaj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Munhu ija viyakalile yowananahila Petulo na Yohana, wanhu wose wakimbila na kuilundiza hanhu hakemigwe “Lubuga lwa Selemani,” na kukanganya ng'hani. ");
INSERT INTO zaj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petulo viyagawene gano, kawalongela, “Mweye Waislaeli, habali mkanganya mbuli ino? Habali mtulola ng'hani tweye kamba vija udaho wetu wenyego ama sang'hano zetu zinogile zizo zimtendile munhu ino yatembele? ");
INSERT INTO zaj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mulungu wa wahenga zetu Ablaham, Isaka, na Yakobo kamuyenzi mtumigwa wake Yesu. Ila mweye mumgela mmakono ga wanhu wali na udaho, na mmulema hameso ga Pilato, hata haja Pilato viyalondile kumulekesa. ");
INSERT INTO zaj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mweye mmulema Munhu Yang'alile na Yalibule Uzenzeleganye, na mulonda mulekeseligwe munhu iyagwe yakalile yokoma wanhu. ");
INSERT INTO zaj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mumkoma ija yakalile chanduso cha ugima, ila Mulungu kamzusa kulawa mkudanganhika, na tweye twa wasindila wa mbuli ino. ");
INSERT INTO zaj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Munhu ino yummona na kumtanga, katendigwa kuwa mgima na nhamanila ili mtwaga da Yesu. Nhamanila ili mditwaga da Yesu iyo imuhonyile kamba vummona. ");
INSERT INTO zaj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Sambi, ndugu zangu, nivitanga kamba mweye mtenda ubozi uno, kamba viwatendile wakulu zenu. ");
INSERT INTO zaj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ila vino Mulungu vivo viyagavikize gaja gayahokole kubitila wahokozi zake wose, yolonga kamba Kilisto wake kokwiza kugaya. ");
INSERT INTO zaj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Avo, lekeni vilozo venu, mumgalukile Mulungu, giladi vilozo venu visegezigwe, ");
INSERT INTO zaj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","giladi kize kipigiti cha kuhumula kulawa ha Mndewa, na kuwagalila Kilisto iyawasagulile yokemigwa Yesu. ");
INSERT INTO zaj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Heyo kolondigwa yasigale kuulanga mbaka vondakivike kipigiti cha vinhu vose kutendigwa kuwa vinhu va sambi, kamba Mulungu viyalongile umwaka kubitila wahokozi zake wang'alile. ");
INSERT INTO zaj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kwavija Musa kalonga, ‘Mndewa Mulungu wenu kowenulila muhokozi kamba nie, kulawa imwe wa wanhu zenu wenyego. Molondigwa kutegeleza kinhu chochose chondayawalongele. ");
INSERT INTO zaj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Munhu yoyose yondayaleme kumtegeleza muhokozi hiyo kobaguligwa kulawa mwa wanhu zake mwenyego na kubanangigwa.’ ");
INSERT INTO zaj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Na wahokozi wose, songela Samweli mbaka waja wezile kuchugu chake, wazihokola mbuli zilawilila mmazua gano. ");
INSERT INTO zaj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mweye mwa wana wa wahokozi waja na mgeligwa mdilagano dija Mulungu diyailagane na wahenga zenu, kamba viyamulongele Ablaham, ‘Kubitila mulelo wako, wanhu wose wali muisi womotezwa.’ ");
INSERT INTO zaj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Avo, Mulungu viyamzusile mtumigwa wake, tanhu kamgala kumwenu, giladi yawamoteze mkuwatenda mweye muleke mbuli zenu zihile.” ");
INSERT INTO zaj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petulo na Yohana viwakalile wang'hali wolonga na wanhu, wakulu wa nhambiko na mkulu wa wemilizi wa Ing'anda ya Mulungu hamoja na Masadukayo wayagwe wavika. ");
INSERT INTO zaj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wagevuzika ng'hani kwavija Petulo na Yohana wakala wowafundiza wanhu kamba Yesu kazuka, kinhu kilagusa kamba wanhu wadanganhike wozuka kulawa mkudanganhika. ");
INSERT INTO zaj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Avo wawagoga Petulo na Yohana, na kwavija ikala ichungulo, wawagela mkifungo mbaka imitondo iyagwe. ");
INSERT INTO zaj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ila wanhu bwando wauhulike usenga uja wamtogola Mulungu, na mheta ya wambigalo yongezeka wavika wanhu alufu tano. ");
INSERT INTO zaj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Zua diyagwe wakulu wa Wayahudi, wavyele, na wafundiza Malagizo ga Musa waiting'hana Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mkulu wa Wakulu wose wa Nhambiko yokemigwa Anasi kakala haja, na Kayafa, na Yohana, na Alekizanda, na wanhu wayagwe wakalile wa mulango wa Mkulu wa Wakulu wose wa Nhambiko. ");
INSERT INTO zaj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Wawasola Petulo na Yohana waweka haulongozi wao, wasonga kuwauza, “Mweye mtenda mbuli zino na mhiko zilihi na mditwaga da munhu yalihi?” ");
INSERT INTO zaj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petulo, kuno yamemile Loho wa Mulungu, kawedika, “Mweye wakulu na wavyele wa Islaeli! ");
INSERT INTO zaj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Kamba tuhauzigwa lelo mmbuli ija inogile yaatendeligwe munhu ija yakalile mbetembete na vija viyahonyigwe, ");
INSERT INTO zaj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","na vitangike kumwenu mweye na wanhu wose wa Islaeli kamba munhu ino yemile haulongozi wenu kuno yali mgima, kahonyigwa na mhiko za twaga da Yesu Kilisto wa Nazaleti immuwambile mumsalaba, ayo Mulungu iyamzusile kulawa mwa wanhu wadanganhike. ");
INSERT INTO zaj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu hiyo yolongigwa muna Zinyandiko Zing'alile, ‘Dibwe dilemigwe na wazenzi digaluka kuwa dibwe da kutamanilwa ng'hani kubanza mabwe gose.’ ");
INSERT INTO zaj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ukombola haulawa ha munhu yoyose iyagwe, kwavija haduhu twaga diyagwe muisi yose wagweleligwe wanhu giladi tukomboligwe kubitila twaga hijo.” ");
INSERT INTO zaj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wakulu wa Ikitala Kikulu cha Isi ya Wayahudi viwawawene Petulo na Yohana wolonga bila kudumba na kuno hawasomile na hawakalile na ubala wowose, wakanganya ng'hani, na kuvitanga kamba wakala hamoja na Yesu. ");
INSERT INTO zaj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ila viwamuwene ija imunhu yahonyigwe kema hamoja na hewo, wakala wabule da kulonga. ");
INSERT INTO zaj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Avo, wawalongela walawe hanze ya Ikitala Kikulu cha Isi ya Wayahudi, na hewo wasigala weiyeka wasonga kuilongela wenyego. ");
INSERT INTO zaj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Wakiiuza, “Tuwatende choni wanhu wano? Kwavija kila munhu yokala Yelusalemu kovitanga kamba mzonza uno wa kukanganya utendeka, na tweye hatudaha kuibela mbuli ino. ");
INSERT INTO zaj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ila, giladi mbuli ino sambiyenele ng'hani mwa wanhu, tuwagomese sambiwalonge na munhu yoyose mditwaga dino.” ");
INSERT INTO zaj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Avo wawakema mng'anda mwanza uyagwe, wawazuma sambiwalonge ama kufundiza mditwaga da Yesu. ");
INSERT INTO zaj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ila Petulo na Yohana wawedika, “Lamuleni mwemwe wenyego kamba kilihi kinogile hameso ga Mulungu, kamba kuwategeleza mweye ama kumtegeleza Mulungu? ");
INSERT INTO zaj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kwavija tweye hatudaha kuleka kulonga mbuli zija zituziwene na kuzihulika.” ");
INSERT INTO zaj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Viwamambukize kuwalongela mbuli za kuwadumbiza, wawalekesa wachole. Hawayonile mbuli ya kuwasunila kwavija wanhu wose wakala womuyenzi Mulungu sama ya mbuli ija ilawilile. ");
INSERT INTO zaj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Na munhu ija yahonyigwe kakala mkulu wa milao kubanza malongo mane. ");
INSERT INTO zaj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Viwalekesigwe, Petulo na Yohana wabwela ha wanhu zao, wawasimulila mbuli zose ziwalongeligwe na wakulu wa wakulu wa nhambiko na wavyele. ");
INSERT INTO zaj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Na hewo viwahulike mbuli hiyo, wailumba mkumtambikila Mulungu, walonga, “Mndewa, gweye iyo ulumbile isi, ulanga, bahali, na vinhu vose vili mgati mwao. ");
INSERT INTO zaj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kulonga na Loho wa Mulungu kubitila mulomo wa muhenga wetu Daudi mtumigwa wako, ‘Habali Wamhazi wagevuzika? Habali wanhu wokwika mizundo ya bule? ");
INSERT INTO zaj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wandewa wa muisi waitanda na ng'hondo, na wakulu waiting'hana hamoja giladi wamuleme Mndewa na Kilisto wake.’ ");
INSERT INTO zaj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kwavija Helode Antipa na Pontio Pilato waiting'hana na Wamhazi hamoja na Waislaeli mkiwambo kino wouzahila ugima wa Mtumigwa wako Yang'alile Yesu, yuumsagule. ");
INSERT INTO zaj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Watenda gaja gaulamule na mhiko na moyo wako umwaka, kamba golondigwa galawilile. ");
INSERT INTO zaj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Avo, Mndewa, zilole mbuli zao zigela bwembwe, uwatende watumigwa zako wazipete mbuli zako bila kudumba. ");
INSERT INTO zaj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Golosa mkono wako uwahonye wanhu, na utende mizonza, vilaguso, na mikanganyo mditwaga da Mtumigwa wako Yang'alile Yesu.” ");
INSERT INTO zaj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Viwamambukize kutambika, hanhu haja hawakalile waiting'hane hatigisika, na wose wamemezigwa Loho wa Mulungu. Wose wasonga kuzipeta mbuli za Mulungu bila kudumba. ");
INSERT INTO zaj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Wanhu wose wamtogole Kilisto wakala na moyo umwe na loho imwe. Hakukalile na munhu yalongile kamba kinhu chochose yali nacho kamba kinhu chake mwenyego, ila wanhu wose waigolela vinhu viwakalile navo. ");
INSERT INTO zaj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Watumigwa wa Kilisto wawapetela wanhu mmhiko ng'hulu mbuli ya kuzuka kwa Mndewa Yesu, na Mulungu kawamoteza motelo bwando. ");
INSERT INTO zaj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Hakukalile na munhu yoyose hana ididale jao yakalile bule kinhu. Kwavija wanhu wose wakalile na migunda ama ng'anda waviguza, abaho, wagala zihela ziwapatile, ");
INSERT INTO zaj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","na kuwagwelela watumigwa wa Kilisto, abaho, waigolela kila munhu kamba viyalondigwe kupata. ");
INSERT INTO zaj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kukala na Mulawi imwe, mwenekae wa Sipulo, twaga jake Usufu, ayo watumigwa wa Kilisto wamkemile Banaba, nhegulo yake, “Munhu yowasegezela wanhu giogio.” ");
INSERT INTO zaj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Na heyo kakala na mgunda wake, kauguza, abaho, kazisola zihela na kuwagwelela watumigwa wa Kilisto. ");
INSERT INTO zaj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kukala na munhu imwe yakemigwe Anania, hamwe na mtwanzi wake Safila, na hewo vivija waguza mgunda. ");
INSERT INTO zaj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Kuno mtwanzi wake yovitanga, Anania kabagula hela ziyagwe kazifisa, abaho, zisigale kawagwelela watumigwa wa Kilisto. ");
INSERT INTO zaj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Abaho, Petulo kamulongela, “Anania, habali umulekile Mwenembago yawingile moyo wako, na kum'vwizila Loho wa Mulungu mkufisa zihela ziyagwe ziupatile mkuguza mgunda? ");
INSERT INTO zaj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Vuukalile ung'hali haunaguzwa, haukalile wako? Na vuukalile uguzigwe, zihela ziupatile hazikalile zako? Habali kugelegeza vihile mmoyo wako na kutenda mbuli ino? Hum'vwizile munhu, ila kum'vwizila Mulungu!” ");
INSERT INTO zaj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania viyahulike hivo, kagwa hasi, kadanganhika. Wanhu wose waihulike mbuli ino wadumba ng'hani. ");
INSERT INTO zaj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wamhale weza, waluzingiliza lukuli lwake muna isanda, abaho, walulava hanze, na kuluzika. ");
INSERT INTO zaj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Vigabitile kamba masaa madatu, mtwanzi wake kengila, kuno hatangile gaja galawilile. ");
INSERT INTO zaj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petulo kamuuza, “Nilongele, zino zizo zihela zimpatile mkuguza mgunda wenu?” Na heyo kamwidika, “Ona, zizo zino.” ");
INSERT INTO zaj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petulo kamulongela, “Vino habali gweye na mbigalo wako mwitogolela kumgeza Loho wa Mndewa? Tegeleza, wanhu wacholile kumzika mbigalo wako wa hana ulwivi, na gweye vivija wokusola.” ");
INSERT INTO zaj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Bahaja Safila kagwa hasi ha magulu ga Petulo, kadanganhika. Waja iwamhale viwengile wam'vika yeshile kudanganhika, wamulava kunze, abaho, wamzika habehi na mbigalo wake. ");
INSERT INTO zaj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Wanhu wose wamtogole Kilisto na wanhu wose wayagwe waihulike mbuli hiyo wadumba ng'hani. ");
INSERT INTO zaj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Watumigwa wa Kilisto watenda vilaguso na mikanganyo bwando mwa wanhu. Na wanhu wose wamtogole Kilisto wakala woiting'hana hamoja Muing'anda ya Mulungu hana Ulubuga lwa Selemani. ");
INSERT INTO zaj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Wanhu walekile kumtogola Kilisto wadumba kuilumba na hewo, hata avo wanhu wawagwaa nhogolwa ng'hulu. ");
INSERT INTO zaj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ila mheta ya watwanzi na wambigalo wamtogole Mndewa yongezeka ng'hani. ");
INSERT INTO zaj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na wanhu wakala wowagala watamu mnzila na kuwatambalika mzisazi na mmikeka giladi Petulo yahabita, walau sisila jake diwakwase watamu. ");
INSERT INTO zaj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wanhu bwando weza kulawa m'viwambo vizunguluke Yelusalemu, wawagala watamu zao na wanhu wavagaligwe na vinyamkela, na wose wahonyigwa. ");
INSERT INTO zaj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Abaho, Mkulu wa Wakulu wose wa Nhambiko na wayage, awo wakalile wanhu wa dale da Masadukayo, wakala wokona migongo. ");
INSERT INTO zaj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Wawagoga watumigwa wa Kilisto, na kuwagela mkifungo. ");
INSERT INTO zaj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ila mkipigiti cha ikilo, msenga wa Mndewa wa kuulanga kazivugula zinyivi za ing'anda ya kifungo, abaho, kawalava hanze kawalongela, ");
INSERT INTO zaj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Gendeni mkeme muna Ing'anda ya Mulungu mkawalongele wanhu mbuli zose za Ugima uno.” ");
INSERT INTO zaj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Watumigwa wa Kilisto viwahulike gano, imitondo ng'hani wengila muna Ing'anda ya Mulungu, wasonga kufundiza. Mkulu wa Wakulu wose wa Nhambiko na wayage viwavikile, wakema mting'hano wa Ikitala Kikulu cha Isi yose ya Wayahudi, abaho, wawalagiza wanhu wachole kuing'anda ya kifungo wawagale waja iwatumigwa. ");
INSERT INTO zaj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ila waja iwemilizi wa Ing'anda ya Mulungu viwavikile muna ing'anda ya kifungo, hawawawene, avo, wabwela na kuwalongela gaja galawilile, ");
INSERT INTO zaj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","walonga, “Tuivika ng'anda ya kifungo ihindigwa goya, na wemilizi wema haulongozi wa zinyivi, ila vituvugule zinyivi, hatum'vikile munhu yoyose mng'anda!” ");
INSERT INTO zaj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Mkulu wa wemilizi wa Ing'anda ya Mulungu na wakulu wa wakulu wa nhambiko viwahulike mbuli ino, wazanywa ng'hani wogelegeza choni chondakilawilile hamwande. ");
INSERT INTO zaj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Abaho, munhu imwe keza kawalongela, “Tegelezeni, waja iwanhu imuwekile mkifungo, sambi wa muna Ing'anda ya Mulungu wofundiza wanhu.” ");
INSERT INTO zaj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Avo imkulu wa wemilizi hamoja na watumigwa zake wachola muna Ing'anda ya Mulungu, wawasola, wawagala lugaluga, kwavija wadumba wanhu sambiwawatoe na mabwe. ");
INSERT INTO zaj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wawagala waja iwatumigwa wa Kilisto, waweka haulongozi wa Ikitala Kikulu cha Isi ya Wayahudi. Abaho, Mkulu wa Wakulu wose wa Nhambiko kawauza, ");
INSERT INTO zaj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Hatuwagomese mweye kamba sambimfundize mditwaga dino? Loleni, Yelusalemu muimemeza mafundo genu, na sambi molonda kutugalila nhaguso ya ifa ya munhu ija.” ");
INSERT INTO zaj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petulo na waja watumigwa wa Kilisto wayagwe wedika, walonga, “Tolondigwa kumtegeleza Mulungu, na sio wanhu. ");
INSERT INTO zaj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mulungu wa tata zetu kamzusa Yesu, ija mweye imumkomile mkumuwamba mumsalaba. ");
INSERT INTO zaj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mulungu kamwinula na kumwika kumkono wake wa ukulume, kawa Kilangizi na Mkombola, giladi yawatende wanhu wa Islaeli waleke vilozo vao, na vilozo vao vigeligwe kumgongo. ");
INSERT INTO zaj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tweye twa wasindila wa mbuli zino, hamoja na Loho wa Mulungu wagweleligwe wanhu wose wamtogole Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wanhu wose wa Ikitala Kikulu cha Isi ya Wayahudi viwahulike hivo, wona lusango ng'hani, na walonda kuwakoma. ");
INSERT INTO zaj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ila Mfalisayo imwe twaga jake Gamalieli, mfundiza Malagizo ga Musa yakalile yohishimilwa na wanhu wose, kema haulongozi wa Ikitala Kikulu cha Isi ya Wayahudi, kalagiza kamba waja watumigwa wa Kilisto wekigwe hanze mkipigiti kidodo. ");
INSERT INTO zaj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Abaho, kawalongela, “Mweye Waislaeli wayangu, iteganyeni ng'hani na kija kimulonda kuwatenda wanhu wano! ");
INSERT INTO zaj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kwavija kipigiti kija kukala na munhu imwe twaga jake Teuda, heyo kakiitenda kamba munhu mkulu na kubanza wanhu mia nne wakiilumba hamoja na heyo. Ila kakomigwa, na wanhu zake wose wapwililika, na mbuli zake hazigendelele. ");
INSERT INTO zaj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kulawa ino, kalawilila Yuda munhu wa Galilaya mkipigiti cha kupetigwa wanhu, na munhu ino na heyo kawalundiza wanhu, abaho, wamkweleleza. Ila na heyo vivija kakomigwa, na wanhu zake wapwililika. ");
INSERT INTO zaj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Avo, nowalongela, sambimuwatende kinhu chochose wanhu wano, walekeseni wachole! Kwavija, kamba mbuli ino ama sang'hano ino iwoitenda ilawa ha wanhu, haigendelela, ");
INSERT INTO zaj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ila kamba ilawa ha Mulungu, hamdaha kuibananga. Sambimwoneke kamba mogomba na Mulungu!” Avo watogola mbuli zake. ");
INSERT INTO zaj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Avo wawakema mng'anda waja watumigwa wa Kilisto, wawalanha mbalati, na wawagomesa sambiwafundize mwanza uyagwe mditwaga da Yesu, abaho, wawalekesa wachole. ");
INSERT INTO zaj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na hewo wasegela kulawa haulongozi wa Ikitala Kikulu cha Isi ya Wayahudi kuno wodeng'ha kwavija Mulungu kona kamba walumba kugeligwa kinyala sama ya twaga da Yesu. ");
INSERT INTO zaj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mazua gose hawalekile kufundiza mzikae zao na Kung'anda ya Mulungu, na kuwapetela wanhu Usenga Unogile kamba Yesu iyo Kilisto. ");
INSERT INTO zaj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mkipigiti hicho, wanhu wamtogole Kilisto viwakalile wokongezeka, Wayahudi wa Kigiliki wakala wowatwanganikila Wayahudi wa Kieblania kwavija vizuka wao waisemwigwa mkugoleligwa mandia gawaigolelaga kila zua. ");
INSERT INTO zaj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Avo watumigwa wa Kilisto longo dimwe na wabili wawakema hamoja wanhu wose wamtogole Kilisto, wawalongela, “Havilumbile tweye tuleke kuwapetela wanhu Usenga wa Mulungu tululukile sang'hano ya kugola mandia. ");
INSERT INTO zaj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Avo, ndugu zetu, saguleni wanhu saba kulawa kumwenu wotangigwa kamba sang'hano zao zinoga, wanhu wamemile Loho wa Mulungu, na wanhu wali na ng'hungwe, giladi tuwagwelele sang'hano ino. ");
INSERT INTO zaj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ila, tweye tosang'hanikila kutambika na kuupeta Usenga wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mbuli ino iwanogeza wanhu wose wakalile waiting'hane, avo wamsagula Stefano, munhu yali na nhamanila na yamemezigwe Loho wa Mulungu, na Filipo, Polokolo, Nikanoli, Timoni, Palimena, na Nikolao munhu wa wambo da Antiokia yakalile yengile muna idini ya Kiyahudi. ");
INSERT INTO zaj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wanhu wano wagaligwa haulongozi wa watumigwa wa Kilisto, na hewo watambika na kuwekila makono wowamoteza. ");
INSERT INTO zaj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Avo Usenga wa Mulungu ugendelela kwenela mdiwambo da Yelusalemu. Mheta ya wanhu wautogole igendelela ng'hani kongezeka, na wakulu wa nhambiko bwando waitogola nhamanila ino. ");
INSERT INTO zaj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Mulungu kamnogela Stefano, kamgwelela bazi na mhiko za kutenda mbuli za mkanganyo na mizonza mikulu mwa wanhu. ");
INSERT INTO zaj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ila wanhu wayagwe wa ng'anda ya nhambiko ikemigwe Ng'anda ya Nhambiko ya Wanhu Wailegehe, wakalile walawile Kilene na Alekizandalia, na wayagwe kulawa Kilikia na Asia, wanhu wano wasonga kuibamilila na Stefano. ");
INSERT INTO zaj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ila walemelwa kumuhuma sama ya ng'hungwe yaali nayo na kwavija viyalongozigwe na Loho wa Mulungu viyakalile yolonga. ");
INSERT INTO zaj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Abaho, wawaswagiza wanhu wayagwe walonge, “Tumuhulika Stefano yolonga mbuli za kumuliga Musa na kumuliga Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Avo wawadinhiza wanhu, wavyele, na wafundiza Malagizo ga Musa, na hewo wamcholela Stefano, wamgoga na kumgala haulongozi wa Ikitala Kikulu cha Isi ya Wayahudi. ");
INSERT INTO zaj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Wawagala wasindila wa uvwizi walonga, “Munhu ino haleka kuhalonga vihile Hanhu Hang'alile ha Mulungu na Malagizo ga Musa. ");
INSERT INTO zaj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kwavija tumuhulika yolonga kamba Yesu wa Nazaleti kohabananga hanhu hano, na kugalema Malagizo gatugweleligwe na Musa.” ");
INSERT INTO zaj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Wanhu wose wakalile Mkitala Kikulu cha Isi ya Wayahudi wam'bunhulila meso Stefano, wachona kihanga chake kikala kamba kihanga cha msenga wa Mulungu wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mkulu wa Wakulu wose wa Nhambiko kamuuza, “Mbuli ino kweli?” ");
INSERT INTO zaj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefano kalonga, “Ndugu zangu na tata zangu, nhegelezeni nie, Mulungu wa yenzi kamulawila muhenga wetu Ablaham viyakalile Mesopotamia yang'hali hanahamila muisi ya Halani. ");
INSERT INTO zaj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Mulungu kamulongela, ‘Ilawe isi yako na lukolo lwako, uchole hana iisi yondanikulagusile.’ ");
INSERT INTO zaj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Avo Ablaham kasegela kulawa muisi ya Kaldayo na kuchola kukala Halani. Tataake viyadanganhike, Mulungu kamsegeza na kumgala kuna iisi ino yumkala mweye sambi. ");
INSERT INTO zaj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Hano Mulungu hamgwelele Ablaham uhazi hata mgulu umwe wa isi. Ila Mulungu keka kilagano na heyo kamba heyo na lukolo lwake lose londalwize wogweleligwa isi ija hata kamba kipigiti kija Ablaham kakala kabule mwana. ");
INSERT INTO zaj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mulungu kamulongela vino, ‘Lukolo lwako lokala ukazi wa uhenza kuisi ya wanhu wayagwe, na wotendigwa kuwa nyakadala na kugazwa milao mia nne.’ ");
INSERT INTO zaj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mulungu kalonga, ‘Noisuna isi ija yondaiwasang'hanize hewo kamba nyakadala, na ikwisha wosegela kulawa muisi ija na kunitambikila nie hano.’ ");
INSERT INTO zaj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Abaho, Mulungu kamgwaa Ablaham lagano da kumbi. Avo Ablaham kamulela Isaka, abaho, kamwingiza kumbi mdizua da nane, na Isaka kamulela Yakobo, na Yakobo kawalela waja longo dimwe na wabili, wahenga zetu. ");
INSERT INTO zaj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Kwavija wana wa Yakobo wakala wamonela migongo Usufu, avo wamguza kamba nyakadala kuna iisi ya Misili. Ila Mulungu kakala na heyo, ");
INSERT INTO zaj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","avo kamkombola kulawa mmigayo yake yose. Kamgwelela ng'hungwe na kumtenda yawe munhu yatogoligwe hameso ga Falao, mndewa wa Misili, avo kamtenda yawe mkulu wa Misili na ng'anda yose ya Falao. ");
INSERT INTO zaj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Abaho, nzala mpamanho iigubika isi yose ya Misili na Kanaani, nzala igalile mgayo mkulu, na tata zetu hawadahile kupata vakuja. ");
INSERT INTO zaj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobo viyahulike kamba kukala na vakuja kuna iisi ya Misili, kawatuma wanage, tata zetu, wachole Misili mmwanza wao wa ichanduso. ");
INSERT INTO zaj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mmwanza wao wa ikabili, Usufu kaitambula ha wandugu zake, na Falao kalutanga mulango wa Usufu. ");
INSERT INTO zaj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Abaho, Usufu kawatuma wasenga wachole kumkema tataake Yakobo na lukolo lwake lose, na mheta yao ikala malongo saba na watano. ");
INSERT INTO zaj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Abaho, Yakobo kachola Misili, ako heyo na tata zetu kuwadanganhikile. ");
INSERT INTO zaj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ng'huli zao zibwezigwa Shekemu na kwikigwa muna dipanga diyagulile Ablaham kulawa mwa wana wa Hamoli muisi ya Shekemu na mheta ya hela. ");
INSERT INTO zaj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Kipigiti cha Mulungu kukivikiza kilagano chake ha Ablaham vikikwenhuke, mheta ya wanhu zetu muisi ya Misili yongezeka ng'hani. ");
INSERT INTO zaj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Abaho, mndewa iyagwe yakalile hamtangile Usufu kawa mtawala wa isi ya Misili. ");
INSERT INTO zaj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kawekila mizundo na kuwatendela gehile wahenga zetu na kawashulutiza wavase ving'hele vao giladi vidanganhike. ");
INSERT INTO zaj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kino kicho kipigiti chayavumbuke Musa, heyo kakala mwana yanogile ng'hani. Mkipigiti cha milenge midatu kaleligwa mng'anda ya tataake. ");
INSERT INTO zaj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Viyalavigwe hanze, mndele wa Falao kamsola na kumulela kamba mwanage. ");
INSERT INTO zaj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa kakala yafundizwe ng'hungwe zose za Wamisili, na kakala na udaho mkulonga na mzisang'hano. ");
INSERT INTO zaj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Musa viyakalile na milao malongo mane, kalamula yachole kuwatembelela wandugu zake Waislaeli yone vija viwakalile wotendigwa. ");
INSERT INTO zaj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kamona imwe wa Waislaeli kotendeligwa ukengemeno na Mmisili, avo kamgombela ija yakalile yotendeligwa ukengemeno, abaho, kam'bwelezela ija Mmisili na kumkoma. ");
INSERT INTO zaj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa kagiza ndugu zake wovitanga kamba Mulungu kamgala heyo kwiza kuwakombola hewo, ila hawavitangile. ");
INSERT INTO zaj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Zua da ikabili keza ha Waislaeli wayagwe wakalile wogomba, kageza kuwalumba, yolonga, ‘Mweye mwa wandugu, habali mulonda kuilumiza wenyego kwa wenyego?’ ");
INSERT INTO zaj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ila ija yakalile yomtendela ukaini miyage kamkunhiza Musa kumgwazo na kulonga, ‘Yalihi yakutendile gweye uwe mndewa na mulamula wetu? ");
INSERT INTO zaj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kolonda kung'homa nie kamba vuumkomile ija Mmisili mayo?’ ");
INSERT INTO zaj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa viyahulike vija, kakimbilila muisi ya Midiani, ako kuyakalile ukazi wa uhenza, na ako kapata wana wabili wakimbigalo. ");
INSERT INTO zaj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Viibitile milao malongo mane, msenga wa Mulungu wa kuulanga kamulawilila Musa mkitutua kikwaka mkiwala behi na Gongo da Sinai. ");
INSERT INTO zaj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Viyagawene gano kakanganya ng'hani mmeso gake, kakwenhuka behi yalole goya, kahulika dizwi da Mndewa, ");
INSERT INTO zaj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nie iyo Mulungu wa watata zako, Mulungu wa Ablaham, Isaka, na Yakobo.’ Musa kagudema kuno yokona bwembwe na hagendelele kulola mwanza uyagwe. ");
INSERT INTO zaj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Abaho, Mndewa kamulongela, ‘Vula ng'hwabasa zako, kwavija hanhu aho hawimile ha hanhu hang'alile. ");
INSERT INTO zaj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kweli niwona ukaini uwotendelwa wanhu zangu muisi ya Misili. Niwahulika vija vowogugumila, avo nihumuluka giladi niwakombole. Avo niza nikutume ubweleganye Misili.’ ");
INSERT INTO zaj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ino iyo Musa iija wamulemile mkulonga mbuli zino, ‘Yalihi yakutendile gweye kuwa mndewa na mulamula?’ Katumigwa na Mulungu mwenyego yawe mndewa na mkombola wao kubitila msenga wa Mulungu wa kuulanga yamulawilile mkitutua. ");
INSERT INTO zaj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Kawalava Waislaeli muisi ya Misili, na mmilao malongo mane kotenda mbuli za mkanganyo na vilaguso muisi ya Misili na kuna Ibahali Indung'hu na muluwala. ");
INSERT INTO zaj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ino iyo Musa ayo yawalongele Waislaeli, ‘Mulungu kowenulila muhokozi kulawa mwa wanhu zenu kamba viyeninule nie.’ ");
INSERT INTO zaj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Heyo iyo yakalile na mting'hano wa wanhu wa Islaeli muluwala. Kakala na wahenga zetu kipigiti msenga wa Mulungu wa kuulanga viyalongile nayo hana Idigongo da Sinai, kazibokela mbuli zili na ugima na kutugwelela tweye. ");
INSERT INTO zaj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Wahenga zetu walema kumtegeleza, avo wamsung'hiza kumgwazo, na mmioyo yao wakala wabweleganye Misili. ");
INSERT INTO zaj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Avo wamulongela Haloni, ‘Tutendele mizimu yondaitulongoze kwavija Musa yatulongoze kulawa muisi ya Misili hatuvitanga gamulawilile.’ ");
INSERT INTO zaj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kipigiti kija watenda wegu dilingile na mwanang'ombe. Wamulavila nhosa na kutenda lusona wokidumba kija kitendigwe na makono gao. ");
INSERT INTO zaj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ila Mulungu kawaleka na kuwatenda wachole kutambikila zua, mulenge, na nhondo kamba vija viyandikigwe muna ikitabu cha wahokozi, ‘Mweye wanhu wa Islaeli! Hana zua mweye mundavile nhosa na kunyhinjila wang'onyo milao malongo mane vumkalile kuluwala? Bule! Hamtendile hivo. ");
INSERT INTO zaj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mkala mtembela kuno mpapile hema ya mulungu wenu Moleki, na nhondo ya mulungu wenu Lefani, miwegu imuitendile giladi muitambikile. Avo nowahamizila mchole kuisi ya kutali kubanza Babeli.’ ");
INSERT INTO zaj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Wahenga zetu wakala na hema da usindila muluwala. Itendigwa kamba Mulungu viyamulongele Musa kamba vija viyalagusiligwe. ");
INSERT INTO zaj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Viwadibokele hema dija kulawa ha watata zao, watata zetu kuno wolongozwa na Yoshua, wengila nayo kipigiti viwaisolile iisi ya Wamhazi Mulungu yaawawingile haulongozi wao. Isigala muisi mbaka kipigiti cha Daudi, ");
INSERT INTO zaj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ayo yageligwe bazi da Mulungu na kupula yamzengele ng'anda Mulungu wa Yakobo. ");
INSERT INTO zaj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ila Selemani iyo yaizengile ng'anda ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ila Mulungu Mkulu Ng'hani hakala mng'anda izengigwe na wanhu, kamba muhokozi viyolonga, ");
INSERT INTO zaj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Mndewa kolonga, Ulanga kicho kigoda changu cha undewa, na isi kicho kigoda cha kwikila magulu gangu. Ng'anda ya vilihi yondamunizengele nie? Ama kwahi hondauwe ukazi wangu? ");
INSERT INTO zaj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Sio mkono wangu utendile vinhu vino vose?’ ");
INSERT INTO zaj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Mweye wanhu muli na singo ndala, mulekile kwingila kumbi mmioyo yenu na mmagwiti genu, mazua gose mom'bamilila Loho wa Mulungu kamba wahenga zenu viwatendile! ");
INSERT INTO zaj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Muhokozi yalihi hagazigwe na wahenga zenu? Wawakoma hata waja wahokole kwiza kwa Munhu Yalibule Uzenzeleganye. Na mweye mmuhonza na kumkoma. ");
INSERT INTO zaj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mweye wenyego iwo m'bokele lagizo kulawa ha wasenga wa Mulungu wa kuulanga, na hata ivo hamdigogile!” ");
INSERT INTO zaj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Viwahulike mbuli zino, wona lusango ng'hani na kumgegedulila meno gao Stefano. ");
INSERT INTO zaj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ila Stefano, kuno yamemile Loho wa Mulungu, kalola uchana kuulanga kayona yenzi ya Mulungu na Yesu yemile kumkono wa ukulume wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kalonga, “Lola, nokona ulanga uvuguka na Mwana wa Munhu kema kumkono wa ukulume wa Mulungu!” ");
INSERT INTO zaj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Viwahulike gano, waziwa magwiti gao na kuguta nyangi ng'hani, na wose hamoja wam'vamhila, ");
INSERT INTO zaj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","wamkwekwesa wamulava hanze ya idiwambo na kusonga kumtoa na mabwe. Kipigiti kikija, wasindila weka vivalo vao hamagulu ga mmhale imwe yakemigwe Sauli. ");
INSERT INTO zaj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Viwakalile womtoa, Stefano katambika yolonga, “Mndewa Yesu, ibokele loho yangu.” ");
INSERT INTO zaj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Abaho, kafugama mavindi na kwinula dizwi yolonga, “Mndewa, sambiuwapetele kilozo kino.” Viyalongile vino, kadanganhika. ");
INSERT INTO zaj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Na Sauli kona goya kukomigwa kwa Stefano. Kipigiti hicho mgayo mkulu ulawilila mwa wanhu wamtogole Kilisto ako Yelusalemu, na wanhu wose wapwililika wakimbilila ng'ambu za Yudea na Samalia. Ila watumigwa wa Kilisto weiyeka iwo wasigale. ");
INSERT INTO zaj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Wanhu wa Mulungu wamzika Stefano na kumulilila ng'hani. ");
INSERT INTO zaj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ila Sauli kasonga kuwagaza wanhu wamtogole Kilisto, kengila ng'anda kwa ng'anda, yowalava wose, watwanzi na wambigalo, na kuwagela mkifungo. ");
INSERT INTO zaj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Waja wapwililike wachola kila hanhu waupeta Usenga Unogile. ");
INSERT INTO zaj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo kahumulukila mdiwambo dili muisi ya Samalia na kuwapetela wanhu mbuli za Kilisto. ");
INSERT INTO zaj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Dale da wanhu vidimuhulike Filipo na vija viwonile mizonza iyatendile, wagategeleza goya gaja gayatendile. ");
INSERT INTO zaj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Na vinyamkela wakalile wawavagale wanhu bwando wawalawa kuno woguta nyangi ng'hani, na wanhu bwando wakalile waholole na walemale wahonyigwa. ");
INSERT INTO zaj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Avo kukala na ndeng'ha ng'hulu mdiwambo dija. ");
INSERT INTO zaj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kukala na munhu imwe yakemigwe Simoni yakalile yotenda uhawi mdiwambo hijo, na kuwazanya wanhu wa isi ya Samalia, na kuitenda kamba heyo iyo munhu mkulu. ");
INSERT INTO zaj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Wanhu wose, wadodo na wakulu, wamtegeleza goya walonga, “Munhu ino iyo mhiko ya Mulungu ikemigwa, ‘Mhiko Ng'hulu.’ ” ");
INSERT INTO zaj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Na hewo wamtegeleza goya, kwavija mkipigiti kitali kakala yowazanya ng'hani. ");
INSERT INTO zaj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ila viwamtogole Filipo viyakalile youpeta Usenga Unogile wa Undewa wa Mulungu na twaga da Yesu Kilisto, wose wabatizigwa, wambigalo na watwanzi. ");
INSERT INTO zaj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na Simoni mwenyego katogola, kabatizigwa, na kakala yokiilongoza na Filipo. Abaho, kakanganya mizonza na mbuli za mkanganyo zikalile zotendeka. ");
INSERT INTO zaj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na watumigwa wa Kilisto wakalile Yelusalemu, viwahulike kamba wanhu wa Samalia wautogola Usenga wa Mulungu, wawatuma Petulo na Yohana. ");
INSERT INTO zaj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Viwavikile, wawatambikila ha Mulungu giladi wabokele Loho wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kwavija Loho wa Mulungu kakala hanamuhumulukila munhu yoyose mdidale jao, ila wakala wabatizigwe mditwaga da Mndewa Yesu diiyeka. ");
INSERT INTO zaj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Abaho, Petulo na Yohana wawekila makono gao, na hewo wabokela Loho wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni viyawene kamba wanhu wabokela Loho wa Mulungu mkwikilwa makono na watumigwa wa Kilisto, avo, kageza kuwagwelela hela Petulo na Yohana yolonga, ");
INSERT INTO zaj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Nigweleleni na nie udaho uno, giladi munhu yoyose yondanimwikile makono gangu, yabokele Loho wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ila Petulo kamwidika, “Udanganhike gweye hamoja na hela zako, kwagiza nhunza ya Mulungu yoguligwa na hela! ");
INSERT INTO zaj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kwabule hanhu hohose muisang'hano ino, kwavija moyo wako haumnogeze Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Avo, ukileke kilozo kino na umtambikile Mndewa, siku kokugela kumgongo mkukala na ngelegeza kamba ino mmoyo wako. ");
INSERT INTO zaj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kwavija nokona kumema migongo na kwa mkifungo cha mbuli zihile.” ");
INSERT INTO zaj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni kedika, kalonga, “Nitambikileni ha Mndewa, giladi mbuli zose zimulongile sambizinivike.” ");
INSERT INTO zaj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petulo na Yohana viwamambukize kulonga gaja gawonile na kuwapetela wanhu Usenga Unogile, wabwela Yelusalemu, na kuupeta Usenga Unogile muna iviwambo bwando va Samalia. ");
INSERT INTO zaj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Msenga wa Mndewa wa kuulanga kamulongela Filipo, “Isasale, uchole ng'ambu ya kusi kubitila nzila ya kiwala, ihumuluka kulawa Yelusalemu mbaka Gaza.” ");
INSERT INTO zaj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Avo, Filipo kaisasala kuchola, na viyakalile mnzila, kaiting'hana na kibohola wa Etiopia, yakalile mkulu wa ngama yose ya Kandake, Malikia wa Etiopia. Munhu ino kakala yacholile Yelusalemu kutambika. ");
INSERT INTO zaj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Viyakalile yakalile mdikwama yobwela ukae, kakala yosoma kitabu cha muhokozi Isaya. ");
INSERT INTO zaj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Loho wa Mulungu kamulongela Filipo, “Dikwenhukile kwama dija uilongoze najo.” ");
INSERT INTO zaj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Abaho, Filipo kadikimbilila dikwama, na kamuhulika munhu yosoma kitabu chandikigwe na muhokozi Isaya. Filipo kamuuza, “Vino kugatanga ago guusoma?” ");
INSERT INTO zaj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Na heyo kedika, “Nodahaze kuvitanga, bila munhu kunilongoza?” Avo kamgoneka Filipo yakwele uchana yakale hamoja na heyo. ");
INSERT INTO zaj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na hanhu hayakalile yosoma handikigwa vino, “Kalongozigwa kamba ng'hondolo yochola kuchinjigwa, na kamba vija mwana ng'hondolo yanyamale haulongozi wa imunhu yomkanha mijusu, na heyo halongile mbuli yoyose. ");
INSERT INTO zaj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kageligwa kinyala na kakala bule munhu wa kumgombela. Yalihi yodaha kulusima lukolo lwake? Kwavija ugima wake usegezigwa muisi.” ");
INSERT INTO zaj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mkulu ija kamuuza Filipo, “Nilongele, muhokozi ino kolonga mbuli za munhu yalihi? Kolonga mbuli zake mwenyego ama za munhu iyagwe?” ");
INSERT INTO zaj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Abaho, Filipo kasongela Mzinyandiko zizija Zing'alile, kumpetela Usenga Unogile wa Yesu. ");
INSERT INTO zaj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Viwakalile mnzila wochola, wavika hanhu hakalile na mazi, na ija imkulu kalonga, “Hano hana mazi, avo kinhu chaki kinigomesa ndeke kubatizigwa?” ");
INSERT INTO zaj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo kamulongela, “Kamba kotogola mmoyo wako wose, kodaha kubatizigwa.” Na heyo kedika, kalonga, “Ona, notogola kamba Yesu iyo Mwana wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mkulu hiyo kalagiza dikwama dime, abaho, wose wabili wahumuluka wengila mgamazi, na heyo Filipo kam'batiza. ");
INSERT INTO zaj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Abaho, viwalawile mmazi, baho Loho wa Mndewa kamnyamula Filipo, na ija imkulu hamuwene mwanza uyagwe, avo kagendelela na mwanza wake kuno yodeng'ha. ");
INSERT INTO zaj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo kedukila ka Azoto, na viyakalile mnzila kakala youpeta Usenga Unogile m'viwambo vose mbaka viyavikile Kaisalia. ");
INSERT INTO zaj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kipigiti kikija, Sauli yang'hali yowadumbiza na kugelegeza kuwakoma wanahina wa Mndewa. Kachola ha Mkulu wa Wakulu wose wa Nhambiko, na ");
INSERT INTO zaj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kupula lupwilili lwa kumtenda yatambulwe muna zing'anda zose za nhambiko ako kudiwambo da Damaski, giladi yahawavika, wambigalo ama watwanzi woiwinza Nzila hiyo ya Mulungu, yawagoge na kuwabweza Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sauli viyakalile mnzila behi na kuvika Damaski, kedukila mulangaza kulawa kuulanga ummwemwesa ng'ambu zose. ");
INSERT INTO zaj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kagwa hasi, kahulika dizwi dilonga, “Sauli, Sauli! Habali ungaza?” ");
INSERT INTO zaj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauli kauza, “Gweye kwa munhu waki, Mndewa?” Na heyo kedika, “Nie iyo Yesu, ija gweye umgaza. ");
INSERT INTO zaj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ila wime, wingile mdiwambo, ako kolongeligwa chuulondigwa kutenda.” ");
INSERT INTO zaj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wanhu wakalile mmwanza umwe na Sauli wema haja bila kulonga mbuli kuno wokanganya, wadihulika dija didizwi, ila hawamuwene munhu. ");
INSERT INTO zaj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli kenuka, ila viyananule meso gake, honile kinhu. Avo wamgoga mkono wamulongoza mbaka mdiwambo da Damaski. ");
INSERT INTO zaj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kakala hadahile kulola mmazua madatu, na kakala hadahile kuja ama kung'wa kinhu chochose. ");
INSERT INTO zaj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ako Damaski kukala na mwanahina imwe yakemigwe Anania. Mndewa kamulongela kinhu mnzozi, kamkema, “Anania!” Anania kedika, “Iyo nie, Mndewa.” ");
INSERT INTO zaj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mndewa kamulongela, “Winuke uchole kung'anda ya Yuda kubitila nzila ikemigwa Nzila Igoloke, ukamuuze munhu yokemigwa Sauli, mwenekae wa Taliso, kwavija heyo kotambika. ");
INSERT INTO zaj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Na heyo muna inzozi kamona munhu, yokemigwa Anania, keza kamwikila makono gake uchana yake, giladi yadahe kulola mwanza uyagwe.” ");
INSERT INTO zaj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ila Anania kedika, “Mndewa, nizihulika mbuli za munhu ino mwa wanhu bwando na mbuli zose zihile ziyawatendele wanhu zako wang'alile muisi ya Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na heyo keza hano yali na udaho kulawa ha wakulu wa wakulu wa nhambiko kuwagoga wanhu wose wotambika mditwaga jako.” ");
INSERT INTO zaj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ila Mndewa kamulongela, “Genda, kwavija munhu ino iyo kia changu kinisagule giladi yadipape twaga jangu ha Wamhazi, wandewa zao, na ha wanhu wa Islaeli. ");
INSERT INTO zaj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na nie nomulagusila vija voyolondigwa kugaya ng'hani sama ya twaga jangu.” ");
INSERT INTO zaj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Avo, Anania kachola kengila muna ing'anda. Abaho, kamwikila makono gake Sauli, kamulongela, “Ndugu yangu Sauli, Mndewa Yesu mwenyego, yakulawilile mnzila yuubitile, kanilagiza giladi udahe kulola mwanza uyagwe na umemezwe Loho wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Bahaja vinhu kamba vigome vilagala kulawa mmeso ga Sauli, na kadaha kulola kabili. Kema, abaho, kabatizigwa. ");
INSERT INTO zaj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Na viyamambukize kuja mandia, mhiko zimbwelela. Sauli kakala mazua madodo hamoja na wanahina ako Damaski. ");
INSERT INTO zaj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Baho kasonga kuwapetela wanhu muna zing'anda za nhambiko kamba Yesu iyo Mwana wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Wanhu wose wamuhulike wakanganya, na kuuza, “Munhu ino si ija yakalile yowagaza waja wakalile wodikema twaga dino hiko Yelusalemu? Na hezile hano giladi yawagoge na kuwagala ha iwakulu wa wakulu wa nhambiko?” ");
INSERT INTO zaj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sauli kagendelela kuwa na mhiko, na kuwazanya Wayahudi wa Damaski mkulonga kamba Yesu iyo Kilisto. ");
INSERT INTO zaj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Vigabitile mazua bwando, Wayahudi watenda zundo giladi wamkome Sauli. ");
INSERT INTO zaj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ila Sauli kazitanga sang'hano zao. Imisi na ikilo wemiliza zinyivi za idiwambo giladi wamkome. ");
INSERT INTO zaj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ila kipigiti cha ikilo wanahina zake wamsola mumgelo na kumuhumulusa hasi kubitila hanhu hakalile na zonzo mkiwambaza cha idiwambo. ");
INSERT INTO zaj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauli viyavikile Yelusalemu, kageza kuilumba na wanahina, ila wose wamdumba, hawatogole kamba kweli heyo kakala mwanahina. ");
INSERT INTO zaj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ila Banaba kamsola na kumgala ha watumigwa wa Kilisto. Kawalongela vija Sauli viyamuwene Mndewa, na Mndewa viyalongile na Sauli viyakalile mmwanza wake, na vija Sauli viyakalile yowapetela wanhu Usenga Unogile mtwaga da Yesu ako Damaski bila kudumba. ");
INSERT INTO zaj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Avo Sauli kakala hamoja na hewo na kuzunguluka Yelusalemu yose kuno youpeta Usenga Unogile mditwaga da Mndewa bila kudumba. ");
INSERT INTO zaj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kalonga na kuibamilila na Wayahudi wa Kigiliki, ila wageza kumkoma. ");
INSERT INTO zaj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wanhu wamtogole Kilisto viwahulike mbuli zino, wamsola Sauli wamgala Kaisalia, abaho, wamuleka yachole Taliso. ");
INSERT INTO zaj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Abaho, kipigiti hicho wanhu wamtogole Kilisto wakala mditindiwalo muisi zose za Yudea, Galilaya, na Samalia. Na kubitila Loho wa Mulungu, wageligwa mhiko na kukula mkumnogela Mndewa, na mheta yao yongezeka. ");
INSERT INTO zaj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petulo viyakalile yozunguluka kila hanhu, kachola kuwatembelela na wanhu wa Mulungu wakalile wokala Lida. ");
INSERT INTO zaj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ako kamona munhu imwe twaga jake Enea yakalile yaholole, munhu hiyo kakala yatambalale mulusazi mkipigiti cha milao minane. ");
INSERT INTO zaj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petulo kamulongela, “Enea, Yesu Kilisto kokuhonya. Winuke, utandike lusazi lwako.” Baho Enea kenuka. ");
INSERT INTO zaj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wanhu wose wakalile Lida na Shaloni wamuwene Enea, wamtogola Mndewa. ");
INSERT INTO zaj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kukala na mwanahina imwe mkiwambo cha Yopa twaga jake Tabita, nhegulo yake Mkigiliki Dolikasi, munhu yakalile na sang'hano zinogile na kuwagwelela vinhu wakumbulu. ");
INSERT INTO zaj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kipigiti hicho kakala yolumwa, abaho, kadanganhika, na lukuli lwake vilukoshigwe, lwikigwa mdigati da uchana. ");
INSERT INTO zaj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kiwambo cha Lida kikala behi na kiwambo cha Yopa, avo wanahina viwahulike kamba Petulo ka mkiwambo cha Lida, wamulagizila wanhu wabili na kumulongela, “Wize mbwisa kumwetu.” ");
INSERT INTO zaj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petulo kachola hamoja na hewo, na viyavikile, kagaligwa gati da uchana. Vizuka wose wema behi nayo kuno wolila na kumulagusila ng'hanzu na vivalo viyagwe viyavitendile Dolikasi viyakalile hamoja na hewo. ");
INSERT INTO zaj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petulo kawalava kunze wanhu wose, kafugama mavindi, katambika. Abaho, kalugalukila luja ulukuli kalonga, “Tabita, lamuka.” Na heyo kananula meso gake, na viyamuwene Petulo, kenuka kakala. ");
INSERT INTO zaj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kamgoga mkono na kumwinula. Abaho, kawakema wanhu wamtogole Kilisto na vizuka, kamwika haulongozi wao kuno yali mgima. ");
INSERT INTO zaj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mbuli ino ibwililika muisi yose ya Yopa, na wanhu bwando wamtogola Mndewa. ");
INSERT INTO zaj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petulo kagendelela kukala Yopa mazua bwando hakae ha munhu imwe twaga jake Simoni, yakalile msindika mikwembe. ");
INSERT INTO zaj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ako kudiwambo da Kaisalia kukala na munhu imwe twaga jake Kolinelio, mkulu wa dale da asikali mia wa Loma dikemigwa “Dale da Italia.” ");
INSERT INTO zaj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Heyo hamoja na wanhu wose wa ng'anda yake wakala wanhu wa nhambiko, na wakala womdumba Mulungu. Kakala yowagwelela vinhu awo wakalile bule vinhu na kumtambikila Mulungu mazua gose. ");
INSERT INTO zaj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Zua dimwe kamba saa tisa ichungulo kona kinhu mnzozi. Kamona na meso gake msenga wa Mulungu wa kuulanga yomwizila na kulonga, “Kolinelio!” ");
INSERT INTO zaj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kolinelio kamulola kuno yokona bwembwe, abaho, kamuuza, “Kuna choni, Mndewa?” Msenga wa Mulungu wa kuulanga kamwidika, “Nhambiko zako na nhosa zako zuuwagwelele wakumbulu zivika uchana na kuwa ukumbuso ha Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Avo uwatume wanhu wachole Yopa wakamkeme munhu imwe twaga jake Simoni yakalile yokemigwa Petulo. ");
INSERT INTO zaj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kokala hamoja na Simoni msindika mikwembe, ng'anda yake ya behi na ibahali.” ");
INSERT INTO zaj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ija imsenga wa Mulungu wa kuulanga viyasegele, Kolinelio kawakema nyakadala zake wabili na asikali imwe yakalile yamnogele Mulungu yakalile yomsang'hanikila heyo. ");
INSERT INTO zaj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kawalongela mbuli zose zilawilile, abaho, kawalagiza wachole Yopa. ");
INSERT INTO zaj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Zua da ikabili mkipigiti cha kamba saa sita viwakalile mmwanza wao, wakwenhukila ikiwambo, Petulo kakwela mkiswili kutambika. ");
INSERT INTO zaj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kona nzala ng'hani, kasulukila kinhu cha kuja. Na mandia vigakalile gosasaligwa kapata kigumbizi. ");
INSERT INTO zaj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kawona ulanga uvuguka, na kinhu kilingile kamba guo kulu dikala dihumuluswa hasi digogigwe mng'ambu zake nne. ");
INSERT INTO zaj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mgati yake kukala na wang'onyo wose wali na migulu mine, waja wotambala na ndege wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Abaho, kahulika dizwi domulongela, “Petulo, lamuka uchinje, uje!” ");
INSERT INTO zaj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ila Petulo kalonga, “Bule, Mndewa, nie sinakuja ng'hone ama kinhu chochose kinyolodoke.” ");
INSERT INTO zaj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dizwi dimulongela mwanza wa ikabili, “Sambiuvikeme ng'hone vinhu vinogezwe na Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mbuli ino ilawilila mianza midatu, na baho kija ikinhu kilingile kamba guo kulu kisoligwa kubwela kuulanga. ");
INSERT INTO zaj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petulo viyakalile yogelegeza nhegulo ya inzozi ija, waja wanhu watumigwe na Kolinelio walawilila. Wakala wouza kuili ng'anda ya Simoni kuno wemile haulongozi wa ulwivi. ");
INSERT INTO zaj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Wakemelela, wauza, “Hana muhenza hano yokemigwa Simoni Petulo?” ");
INSERT INTO zaj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petulo viyakalile yang'hali yogelegeza nhegulo ya inzozi ija, Loho wa Mulungu kamulongela, “Simoni, hana wanhu wadatu wokuzahila. ");
INSERT INTO zaj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Avo wime na uhumuluke hasi. Sambiusinhe kuchola hamoja na hewo, kwavija nie iyo niwalagize.” ");
INSERT INTO zaj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petulo kahumuluka hasi kawalongela, “Nie iyo munhu yumumzahila. Mwiza kuwinza choni?” ");
INSERT INTO zaj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Waja wanhu walonga, “Kolinelio, mkulu wa dale da asikali mia wa Loma, katulagiza. Ino iyo munhu yalibule uzenzeleganye, munhu yomdumba Mulungu, na yodumbigwa na Wayahudi wose. Msenga wa Mulungu wa kuulanga kamulongela kamba, gweye uchole kung'anda yake giladi yahulike kija chondaulonge.” ");
INSERT INTO zaj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Abaho, Petulo kawabokela na kuwengiza mng'anda na kuwagwelela uwaso haja. Zua diyagwe Petulo kasonga mwanza hamoja na hewo, na ndugu wayagwe kulawa Yopa wailongoza hamoja na heyo. ");
INSERT INTO zaj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Zua da ikabili wavika mdiwambo da Kaisalia, ako Kolinelio kuyakalile yowabeta hamoja na ndugu zake na wambwiga zake yaakalile yawagoneke. ");
INSERT INTO zaj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petulo viyakalile behi kwingila mng'anda, Kolinelio kam'bokela na kumfugamila mavindi yomtambikila. ");
INSERT INTO zaj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ila Petulo kamwinula, kalonga, “Inuka, nie mwenyego na munhu tu.” ");
INSERT INTO zaj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petulo kagendelela kulonga na Kolinelio, na viyengile mng'anda kajona dale kulu da wanhu wailundiza. ");
INSERT INTO zaj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kawalongela, “Mweye movitanga kamba Muyahudi yoyose kagomesigwa na Malagizo ga Musa kuilumba na Mmhazi ama kumtembelela. Ila Mulungu kanizuma kamba sambinimkeme munhu yoyose keha ama kanyolodoka. ");
INSERT INTO zaj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Vumunikemile, silemile kwiza. Avo nouza, mbuli ilihi yumunikemele?” ");
INSERT INTO zaj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kolinelio kedika, “Mazua mane gabitile mkipigiti kamba kikino cha saa tisa, nikala mng'anda yangu nitambika. Baho munhu yakalile yavalile vivalo vinang'hazika kema haulongozi wangu ");
INSERT INTO zaj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","na kulonga, ‘Kolinelio! Mulungu kaihulika nhambiko yako na kuzikumbuka nhunza zako ziuwagwelele wakumbulu. ");
INSERT INTO zaj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mulagize munhu yachole Yopa ha munhu yokemigwa Simoni yokemigwa Petulo. Heyo kokala muing'anda ya Simoni msindika mikwembe, yokala behi na bahali.’ ");
INSERT INTO zaj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Avo, hima niwalagiza wanhu kumwako, na gweye kutenda goya vuwizile. Avo wose twabaha haulongozi wa Mulungu kutegeleza mbuli yoyose yaakulagize Mndewa utulongele tweye.” ");
INSERT INTO zaj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Abaho, Petulo kasonga kulonga, “Sambi nivitanga kamba Mulungu halola kihanga cha munhu. ");
INSERT INTO zaj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ila wanhu wa isi yoyose womdumba heyo na kutenda ganogile, kowatogola. ");
INSERT INTO zaj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Moitanga imbuli yaigalile Mulungu ha wanhu wa Islaeli, kuno youpeta Usenga Unogile ugala tindiwalo kubitila Yesu Kilisto, yali Mndewa wa wanhu wose. ");
INSERT INTO zaj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mkitanga kija kilawile muisi yose ya Yudea, kusongela Galilaya, Yohana viyeshile kuwapetela wanhu usenga wake wa ubatizo. ");
INSERT INTO zaj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mumtanga Yesu wa Nazaleti, vija Mulungu viyamsagule kubitila Loho wa Mulungu na mhiko. Kachola kila hanhu, yotenda mbuli zinogile na kuwahonya wanhu wose wakalile wagogigwe na mhiko za Mwenembago, kwavija Mulungu kakala hamoja na heyo. ");
INSERT INTO zaj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tweye twa wasindila wa mbuli zose ziyatendile muisi ya Wayahudi na Yelusalemu. Na hewo wamkoma mkumuwamba mumsalaba. ");
INSERT INTO zaj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ila Mulungu kamzusa zua da ikadatu na kumtenda yoneke. ");
INSERT INTO zaj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Honeke na wanhu wose, ila na wasindila wakalile wasaguligwe na Mulungu. Wasindila awo iwo tweye tukalile tudile na kung'wa hamoja na heyo, viyeshile kuzuka kulawa mkudanganhika. ");
INSERT INTO zaj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Katulagiza tuwapetele wanhu Usenga Unogile na kusindila kamba Yesu iyo yasaguligwe na Mulungu yawe mulamula wa wanhu wagima na wadanganhike. ");
INSERT INTO zaj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Wahokozi wose wolava usindila wa mbuli zake, kamba kila munhu yamtogole heyo, vilozo vake vogeligwa kumgongo kubitila twaga jake.” ");
INSERT INTO zaj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petulo viyakalile yang'hali yolonga mbuli zino, Loho wa Mulungu kawahumulukila wanhu wose wakalile woutegeleza uusenga. ");
INSERT INTO zaj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Wayahudi wamtogole Kilisto wezile hamoja na Petulo wakanganya, avija Wamhazi vivija viwetiligwe nhunza ya Loho wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kwavija wawahulika wolonga ulonzi wa mkanganyo na kumuyenzi Mulungu. Abaho, Petulo kalonga, ");
INSERT INTO zaj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Wanhu wano wabokela Loho wa Mulungu kamba tweye vitubokele. Vino hana munhu yoyose yodaha kuwagomesa sambiwabatizigwe na mazi?” ");
INSERT INTO zaj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Avo kalagiza kamba wabatizigwe mditwaga da Yesu Kilisto. Abaho, wamuyalalila Petulo yakale na hewo mmazua madodo. ");
INSERT INTO zaj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Watumigwa wa Kilisto na wanhu wamtogole Kilisto wakalile muisi yose ya Yudea wahulika kamba Wamhazi na hewo waubokela Usenga wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Avo, Petulo viyacholile Yelusalemu, wanhu wamtogole Kilisto wakalile wengile kumbi wam'bamilila, ");
INSERT INTO zaj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","walonga, “Habali gweye wingile mng'anda ya wanhu walekile kwingila kumbi na kuja na hewo?” ");
INSERT INTO zaj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Avo, Petulo kasonga kuwasimulila vinhu vose lumosilumosi. ");
INSERT INTO zaj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nikala mdiwambo da Yopa notambika, mhata kigumbizi nyona nzozi. Nyona kinhu kilingile kamba guo kulu dikalile dihumuluswa hasi kulawa kuulanga digogigwe mng'ambu zake nne na dikala dihumulukila hanhu hanikalile. ");
INSERT INTO zaj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nidilola goya mgati yake, nyona wang'onyo wa muisi wali na migulu mine, wang'onyo wa kumuhulo, wang'onyo wotambala, na ndege wa kuulanga. ");
INSERT INTO zaj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Abaho, nihulika dizwi dinilongela, ‘Petulo, gandamuka uchinje, uje!’ ");
INSERT INTO zaj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ila nie nilonga, ‘Bule, Mndewa, nie sinakuja ng'hone ama kinhu chochose kinyolodoke.’ ");
INSERT INTO zaj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ila dizwi kulawa kuulanga dinidika mwanza wa ikabili, ‘Sambiukikeme ng'hone ama kinyolodoka kinhu chochose chayakinogeze Mulungu.’ ");
INSERT INTO zaj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mbuli ino ilawilila mianza midatu, abaho, vinhu vose vikwenhigwa kabili kubwela kuulanga. ");
INSERT INTO zaj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kipigiti kikija wanhu wadatu, wakalile watumigwe kumwangu kulawa Kaisalia, wema kuna ing'anda inikalile nikala. ");
INSERT INTO zaj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Loho wa Mulungu kanilongela nichole na hewo sambinisinhe. Wandugu wano sita vivija wachola hamoja na nie, twingila muna ing'anda ya ija imunhu yatulagize. ");
INSERT INTO zaj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Katulongela vija viyamonile msenga wa Mulungu wa kuulanga yemile mng'anda yake na kulonga, ‘Mtume munhu yachole Yopa yamgale hano Simoni yokemigwa Petulo, ");
INSERT INTO zaj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","kokugwelela usenga, na kubitila usenga hiwo, gweye hamoja na wanhu wa ng'anda yako yose wokomboligwa.’ ");
INSERT INTO zaj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Na vunisongile kulonga, Loho wa Mulungu kawahumulukila na kukala uchana yao kamba viyatuhumulukile uchana yetu tweye haichanduso. ");
INSERT INTO zaj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Avo ng'humbuka gaja gayalongile Mndewa kamba, ‘Yohana kakala yobatiza na mazi, ila mweye mobatizigwa na Loho wa Mulungu.’ ");
INSERT INTO zaj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Avo kamba Mulungu kaweng'ha nhunza iija iyatugwelele tweye kipigiti vitumtogole Mndewa Yesu Kilisto, nie iyo munhu waki hata nim'bamilile Mulungu?” ");
INSERT INTO zaj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Viwahulike gano, wanyamala wamuyenzi Mulungu wolonga, “Avo Mulungu kawagwelela hata Wamhazi bazi da kuleka vilozo digala ugima.” ");
INSERT INTO zaj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Avo waja wakalile wapwililike kipigiti cha mgayo ulawilile kipigiti chayakomigwe Stefano wachola isi za kutali za Foinike, Sipulo, na Antiokia woupeta Usenga mwa Wayahudi weiyeka. ");
INSERT INTO zaj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ila mmwanza wao wakala wanhu wayagwe kulawa Sipulo na Kilene wachola kudiwambo da Antiokia na kusonga kulongelela na Wagiliki, wowapetela Usenga Unogile wa Mndewa Yesu. ");
INSERT INTO zaj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mkono wa Mndewa ukala hamoja na hewo, na wanhu bwando watogola na kugalukila kuyali Mndewa. ");
INSERT INTO zaj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mbuli zino zihulikwa na wanhu wamtogole Kilisto wakalile Yelusalemu, avo wamtuma Banaba yachole kudiwambo da Antiokia. ");
INSERT INTO zaj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Viyavikile na kona vija Mulungu viyawamoteze wanhu, kadeng'ha na kuwagong'ondeza wose wagendelele kukala muikweli ya Mndewa na mioyo yao yose, ");
INSERT INTO zaj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","kwavija heyo kakala munhu yali na moyo unogile yamemile Loho wa Mulungu na nhamanila. Na wanhu bwando wamtogola Mndewa. ");
INSERT INTO zaj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Abaho, Banaba kachola Taliso kumzahila Sauli, ");
INSERT INTO zaj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","na viyamuwene, kamgala kudiwambo da Antiokia. Avo mmulao wose Banaba na Sauli wakala wokiiting'hanila na wanhu wamtogole Kilisto na kufundiza wanhu bwando ako kudiwambo da Antiokia. Na wanahina baho wasongile kukemigwa Wakilisto haja Antiokia. ");
INSERT INTO zaj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Muna ikipigiti kino wahokozi kulawa Yelusalemu weza Antiokia. ");
INSERT INTO zaj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Imwe mmwanza wao yokemigwa Agabo kema na kuhokola kubitila Loho wa Mulungu yolonga kamba nzala mpamanho yogubika ulumwengu wose, na gano galawilila kipigiti Klaudio viyakalile Mndewa. ");
INSERT INTO zaj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Wanahina waitogolela kulava vinhu kila munhu viyadahile na kuwagwelela wanhu wamtogole Kilisto wakalile wokala Yudea. ");
INSERT INTO zaj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Wagatenda gano, abaho, wawagwaa Banaba na Sauli wavigale vija viwasangile ha wavyele. ");
INSERT INTO zaj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mkipigiti kiguhi Mndewa Helode Agilipa wa ichanduso kawagoga wanhu wayagwe wamtogole Kilisto giladi yawagaze. ");
INSERT INTO zaj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Kamsola Yakobo, ndugu yake Yohana, na kumkoma na zele. ");
INSERT INTO zaj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Viyawene kamba mbuli ino iwanogela Wayahudi, kagendelela kumgoga na Petulo. Mbuli zino zilawilila mkipigiti cha Lusona lwa Mikate Ilibule Mela. ");
INSERT INTO zaj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Viyeshile kumgoga Petulo kamgela mkifungo, kamwika mmakono ga madale mane ga asikali, na kila dale dikala na asikali wane, wamwimilize. Helode kakala yogelegeza kumulava hanze mwa wanhu kipigiti Ulusona lwa Pasaka luhamala. ");
INSERT INTO zaj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Avo Petulo kemilizwa mding'anda da kufungila wanhu, ila wanhu wamtogole Kilisto wagangamala kumtambikila Mulungu sama yake. ");
INSERT INTO zaj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ikilo ya kuchela imitondo ya zua diyalondile Helode kumulava hanze mwa wanhu, Petulo kakala yawasile hagatigati ya asikali wabili kuno yafungigwe minyolo mibili, na wemilizi wakala wogonelela wokwimiliza ulwivi lwa iding'anda da kufungila wanhu. ");
INSERT INTO zaj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Bahaja msenga wa Mndewa wa kuulanga kalawilila na mulangaza umwemwesa muja mdigati, kamkwasa mulubavu na kumulamusa, abaho, kamulongela, “Inuka mbwisa!” Na bahaja iminyolo imulagala kulawa mmakono gake. ");
INSERT INTO zaj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Abaho, msenga wa Mndewa wa kuulanga kamulongela, “Vala vivalo vako na ng'hwabasa zako.” Na Petulo katenda vija vayalongeligwe. Abaho, msenga wa Mndewa wa kuulanga kamulongela, “Izinge guo jako unikweleleze.” ");
INSERT INTO zaj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petulo kamkweleleza mbaka hanze ya iding'anda da kufungila wanhu, ila kakala bule nzonzi kamba gaja msenga wa Mndewa wa kuulanga gayatendile gakala kweli galawilila, kagiza kakala yokona nzozi. ");
INSERT INTO zaj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wadibita dale da asikali da ichanduso na dale da asikali wemilizi da ikabili na kuvika kuna ulwivi lutendigwe na mizuma lukalile lulola kudiwambo, luwavugukila lwenyego na hewo wabita. Na viwakalile wotembela mnzila ya mdiwambo, kedukila ija imsenga wa Mndewa wa kuulanga kamuleka Petulo. ");
INSERT INTO zaj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Abaho, Petulo nzonzi zim'bwelela, kailongela mwenyego, “Sambi nivitanga kamba Mndewa kamtuma msenga wake wa kuulanga yanikombole kulawa mmakono ga Helode na kulawa mgaja gose gowokala wotamanila Wayahudi galawilile.” ");
INSERT INTO zaj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kipigiti kikija zinzonzi vuzim'bwelele, kachola kung'anda ya Maliamu, mamaake Yohana, ayo yakalile na twaga da ikabili dikemigwa Maluko, ako wanhu bwando kuwakalile waiting'hane wotambika. ");
INSERT INTO zaj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petulo kalubwenga ulwivi lwa kunze, na mndele yokemigwa Loda keza kumulola munhu yobwenga ulwivi. ");
INSERT INTO zaj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Viyategeleze na kudihulika dizwi da Petulo, kadeng'ha ng'hani kakimbila kabweleganya bila kuvugula ulwivi na kuguta yolonga, “Petulo ka halwivi.” ");
INSERT INTO zaj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wamulongela, “Gweye kuna luwege.” Viyagendelele kugangamiza kamba kweli Petulo ka halwivi, walonga, “Siku kowa msenga wa Mulungu wa kuulanga yali hamoja nayo.” ");
INSERT INTO zaj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ila Petulo kagendelela kubwenga ulwivi, na viwavugule ulwivi na kumona heyo, wakanganya ng'hani. ");
INSERT INTO zaj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petulo kawahungila na mkono wake giladi wanyamale na kuwagondela avija Mndewa viyamulawilile kulawa mding'anda da kufungila wanhu, kalonga, “Mulongeleni mbuli zino Yakobo na wanhu wayagwe wamtogole Kilisto.” Abaho, kasegela kachola hanhu hayagwe. ");
INSERT INTO zaj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Viivikile imitondo, kukala na mkomemkome mmwanza wa asikali, wolonga, “Kinhu chaki kimulawilile Petulo?” ");
INSERT INTO zaj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helode kalagiza wanhu wamzahilile Petulo kila hanhu ila hawamonile. Avo kawatuma wanhu wawauze goya waja iwaasikali, abaho, kalagiza wakomigwe. Abaho, Helode kasegela Yudea kachola kukala Kaisalia. ");
INSERT INTO zaj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helode Agilipa wa ichanduso kawonela lusango wanhu wa miwambo ya Tilo na Sidoni, avo wanhu wa Tilo na Sidoni waiduganya hamoja wachole kuiting'hana nayo. Avo wamuyalalila Blasto, mkulu wa ng'anda da kindewa da Helode, wachole na heyo ha Helode Agilipa wa ichanduso kumgwila mavindi kwavija isi yao yopata mandia kulawa muisi ya Helode. ");
INSERT INTO zaj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Zua diwasagule kuiting'hana vidivikile, Helode kavala miguo yake ya kindewa, kakala mkigoda chake cha undewa na kuwapetela wanhu. ");
INSERT INTO zaj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Wanhu wakala woguta, wolonga, “Dizwi dino da mulungu, na sio dizwi da munhu.” ");
INSERT INTO zaj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kwavija Helode hamuyenzile Mulungu, bahaja msenga wa Mndewa wa kuulanga kamtoa, kagwa hasi, kadigwa na masango, na kudanganhika. ");
INSERT INTO zaj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ila Usenga wa Mulungu ugendelela kwenela na kukula. ");
INSERT INTO zaj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Abaho, Banaba na Sauli viwamambukize sang'hano yao, wasegela Yelusalemu, wamsola na Yohana ayo vivija yakalile yokemigwa Maluko. ");
INSERT INTO zaj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mdidale da wanhu wamtogole Kilisto ako kudiwambo da Antiokia kukala na wahokozi na wakulufunzi wakalile wokemigwa Banaba, Simioni yakalile na twaga diyagwe dikemigwa Munhu Mtitu, Lukio munhu wa Kilene, Manaeni yakalile yakulile mding'anda da Mndewa Helode Antipa, na Sauli. ");
INSERT INTO zaj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Viwakalile womtambikila Mndewa na kufunga, Loho wa Mulungu kalonga, “Nibagulileni Banaba na Sauli sama ya sang'hano iniwakemele.” ");
INSERT INTO zaj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Avo viwamambukize kufunga na kutambika, wawekila makono gao na kuwatuma. ");
INSERT INTO zaj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Wabili waja watumigwa na Loho wa Mulungu wabita mkiwambo cha Seleusia, kulawa haja wakwela mmeli wachola kukisiwa cha Sipulo. ");
INSERT INTO zaj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Viwavikile mdiwambo da Salamisi, waupeta Usenga wa Mulungu mzing'anda za nhambiko za Wayahudi. Yohana, ayo vivija yakemigwe Maluko, kakala na hewo yowataza. ");
INSERT INTO zaj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Watembela wabita mkisiwa chose mbaka walawilila Pafosi. Haja wam'vika muhawi wa Kiyahudi na muhokozi wa uvwizi yokemigwa Bali Yesu. ");
INSERT INTO zaj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Yakalile munhu wa behi ng'hani na mkulu wa kisiwa kija yokemigwa Seligio Paulo, yakalile munhu m'bala ng'hani, ayo yagalile usenga ha Banaba na Sauli yolonda kuhulika Usenga wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ila Elima ija imuhawi, kwavija ino iyo nhegulo ya twaga jake dikemigwa Bali Yesu muulonzi wa Kigiliki, kawabamilila na kugeza kumtenda ija imkulu wa kisiwa yaileme nhamanila ija. ");
INSERT INTO zaj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ila Sauli, ayo vivija yakalile yokemigwa Paulo, kamemezwa Loho wa Mulungu kamulola ng'hani Elima ");
INSERT INTO zaj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","na kulonga, “Gweye kwa mwana wa Mwenembago na kwa mdumuka wa vinhu vose vilibule uzenzeleganye. Huleka kuzibulunya mbuli za Mndewa zilibule uzenzeleganye? ");
INSERT INTO zaj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Avo lusango lwa Mndewa lwa hamoja nagwe, kowa kimbugumbugu, na mkipigiti kidodo hudaha kuwona mulangaza wa zua.” Bahaja vinyunyu na ziza vimwizila, na kasonga kubabasila yozahila munhu yamgoge mkono yamulongoze. ");
INSERT INTO zaj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ija imkulu wa ikisiwa viyagonile gaja galawilile, katogola kwavija kakala yokanganya mafundo ga mbuli za Mndewa. ");
INSERT INTO zaj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Abaho, Paulo na wayage wakwela mmeli kulawa Pafosi wachola Pega ili muisi ya Pamfilia, na viwavikile haja, Yohana, ayo vivija yakalile yokemigwa Maluko, kawaleka kabwela Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kulawa Pega, Paulo na Banaba wagendelela wachola kudiwambo da Antiokia muisi ya Pisidia. Mdizua da Mhumulo wengila mng'anda ya nhambiko wakala hasi. ");
INSERT INTO zaj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Viwamambukize kusoma Malagizo ga Musa na wahokozi, mkulu wa ing'anda ya nhambiko katuma munhu kumwao yolonga, “Ndugu zetu, kamba muna mbuli ya kuwagangamiza wanhu, mulonge.” ");
INSERT INTO zaj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulo kenuka na kuwahungila mkono na kulonga, “Mweye wanhu wa Islaeli na mweye wanhu hamuli Wayahudi mumtambikila Mulungu, nhegelezeni! ");
INSERT INTO zaj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Mulungu wa wanhu wa Islaeli kawasagula wahenga zetu na kawatenda wongezeke kipigiti viwakalile Misili na kuwalava muisi ija na mhiko ng'hulu. ");
INSERT INTO zaj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kawazaganya mmilao malongo mane muluwala, ");
INSERT INTO zaj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","na kaibananga mitala saba ya Kanaani na kuwagwelela wanhu zake isi zao kamba uhazi wao. ");
INSERT INTO zaj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mbuli zino zose zisola kamba milao mia nne na malongo matano. “Vugabitile gano, Mulungu kawagwelela walamula mbaka kipigiti cha muhokozi Samweli. ");
INSERT INTO zaj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Abaho, wanhu walonda mndewa, na Mulungu kawagwelela Sauli mwanage Kishi, wa mtala wa Benjamini, yakalile yatawale milao malongo mane. ");
INSERT INTO zaj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Viyamsegeze Sauli, kamtenda Daudi yawe mndewa wao. Mulungu kalonga vino yomulonga Daudi, ‘Nimpata Daudi mwana wa Yese, munhu inimnogele, yondayagatende gose ganimulonda heyo yagatende.’ ");
INSERT INTO zaj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kulawa mulukolo lwa munhu ino Mulungu kamgala Mkombola, Yesu, muisi ya Islaeli, kamba viyekile kilagano. ");
INSERT INTO zaj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesu viyakalile hanasonga sang'hano yake, Yohana kaupeta usenga wa kuleka vilozo na kubatizigwa mwa wanhu wose wa Islaeli. ");
INSERT INTO zaj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohana viyamambukize sang'hano yake, kalonga, ‘Mweye mokwagiza nie iyo munhu yalihi? Nie sio munhu ija imumtamanila kwiza, ila heyo kokwiza hachugu changu, ayo ng'hwabasa zake nie silondigwa kuzifungula.’ ");
INSERT INTO zaj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ndugu zangu, wana wa Ablaham, na mweye wanhu mumtambikila Mulungu mulekile kuwa Wayahudi, usenga uno wa ukombola tugaliligwa tweye! ");
INSERT INTO zaj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Wanhu wa Yelusalemu na wakulu zao wa isi hawamtangile Yesu ama kuzitanga mbuli za wahokozi. Hata avo mkumtagusa Yesu kudanganhika, wazitenda mbuli zino za wahokozi ziwosoma Mazua gose ga Mhumulo zivikile. ");
INSERT INTO zaj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Hata kamba hawonile kilamso kimulumbile heyo kudanganhika, wamulongela Pilato yamtaguse ifa. ");
INSERT INTO zaj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Viwamambukize kutenda mbuli zose zayandikiligwe heyo, wamuhumulusa hasi kulawa mumsalaba na kumtambalika mdipanga. ");
INSERT INTO zaj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ila Mulungu kamzusa kulawa mkudanganhika, ");
INSERT INTO zaj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","na mazua bwando kakala yokoneka na awo wakalile wotembela nayo kulawa Galilaya mbaka Yelusalemu. Awo sambi iwo wasindila mwa wanhu wa Islaeli. ");
INSERT INTO zaj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Tuwagalila Usenga Unogile awo Mulungu uwailagane na wahenga zetu, ");
INSERT INTO zaj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","katuvikizila tweye, wana zao, mkumzusa Yesu. Vivija, kamba vija viyandikigwe mzabuli ya ikabili ilonga, ‘Gweye iyo Mwanangu, lelo nigaluka Tataako.’ ");
INSERT INTO zaj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ikweli ya kamba, Mulungu kamzusa Yesu kulawa mkudanganhika, sambiyadanganhike kabili, ilongwa muna zimbuli zino, ‘Nowagwelela motelo zing'alile na za kweli ziniilagane na Daudi.’ ");
INSERT INTO zaj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Avo vivija kalonga mzabuli iyagwe, ‘Humuleka Munhu wako Yang'alile yolele mdipanga.’ ");
INSERT INTO zaj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kwavija Daudi viyamalile kusang'hanikila mbuli za Mulungu mwa wanhu wa mulelo wake mwenyego, kadanganhika, kazikigwa hamoja na wahenga zake, na lukuli lwake lolela mdipanga. ");
INSERT INTO zaj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ila munhu ija Mulungu iyamzusile holile. ");
INSERT INTO zaj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Avo, ndugu zangu, mbuli ino na itangike kumwenu kamba mkubitila Yesu mpeteligwa kugeligwa kumgongo kwa vilozo. ");
INSERT INTO zaj_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mkubitila Yesu iino, kila munhu yotogola kosegezelwa vilozo vose, vija havidahike kusegezigwa na Malagizo ga Musa. ");
INSERT INTO zaj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Avo teganyeni, gaja gandikigwe mkitabu cha wahokozi sambigawalawilile mweye. ");
INSERT INTO zaj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Loleni mweye mtenda mzihaka, kanganyeni na mdanganhike! Kwavija mmazua genu, nosang'hana sang'hano, sang'hano ayo yondamuleke kuitogola, hata kamba munhu yahawalongela!’” ");
INSERT INTO zaj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo na Banaba viwakalile wolawa hanze, wanhu wawayalalila wazilonge mbuli zino kabili Mdizua diyagwe da Mhumulo. ");
INSERT INTO zaj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mting'hano wa ing'anda ya nhambiko vuuigolile, Wayahudi bwando na waja Iwamhazi watogole kuwa Wayahudi wawakoleleza Paulo na Banaba. Paulo na Banaba wawayalalila wagendelele kukala mngekewa ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Zua diyagwe da Mhumulo, wanhu behi na wose wa mdiwambo dija waiting'hana kutegeleza Usenga wa Mndewa. ");
INSERT INTO zaj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ila Wayahudi viwawene bwando da wanhu, wona migongo, wasonga kulonga mbuli za ufukuzi, kuno wozibeza mbuli zoyokala yolonga Paulo. ");
INSERT INTO zaj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Abaho, Paulo na Banaba wose wabili wenula dizwi walonga bila kidumbo wolonga, “Ilondigwa kamba, Usenga wa Mulungu ulondigwa tanhu upetigwe kumwenu. Ila muulema na kulamula mwemwe wenyego kukala kutali na ugima wa digunge, avo tweye sambi towahindukila Wamhazi. ");
INSERT INTO zaj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kwavija Mndewa katushulutiza tweye yolonga, ‘Niwatenda mweye muwe mulangaza wa Wamhazi, avo muugale ukombola mbaka kuuwishilile ulumwengu.’ ” ");
INSERT INTO zaj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Wamhazi viwahulike mbuli zino, wadeng'ha na kuuyenzi Usenga wa Mndewa, na wose wasaguligwe sama ya ugima wa digunge wamtogola Kilisto. ");
INSERT INTO zaj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Avo Usenga wa Mndewa wenela muisi ija yose. ");
INSERT INTO zaj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ila Wayahudi wawaswagiza watwanzi wali na matwaga wakalile womdumba Mulungu na wakulu wa idiwambo. Na hewo kawagaza Paulo na Banaba na kuwawinga, wawalava hanze ya isi ija. ");
INSERT INTO zaj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Avo wakung'unha timbwisi dikalile mmagulu gao mkuwadukumiza na kuchola Ikonio. ");
INSERT INTO zaj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na wanahina wa mdiwambo da Antiokia wakala wamemile deng'ho na Loho wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Mbuli zizija zilawilila ako kudiwambo da Ikonio. Paulo na Banaba wengila muna ing'anda ya nhambiko ya Wayahudi na kulonga bila kudumba, na Wayahudi bwando na Wamhazi wamtogola Mndewa. ");
INSERT INTO zaj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ila waja Wayahudi walemile kumtogola Mndewa wawaswagiza Wamhazi na kuzigela usungu ngelegeza zao giladi wawaleme Paulo na Banaba. ");
INSERT INTO zaj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Avo wakala haja kipigiti kitali woupeta Usenga wa Mndewa bila kudumba, na Mndewa kailagusa mmbuli ya ngekewa yake mkulava bule vilaguso na mikanganyo itendeke kubitila hewo. ");
INSERT INTO zaj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ila wanhu wa idiwambo dija wakala waigolile. Wayagwe wakala ng'ambu ya Wayahudi, na wayagwe ng'ambu ya watumigwa wa Kilisto. ");
INSERT INTO zaj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kukala na zundo, ditendigwe na Wamhazi na Wayahudi na wakulu zao, da kuwatendela ukaini na kuwatoa na mabwe. ");
INSERT INTO zaj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ila watumigwa wa Kilisto wazimanya mbuli zija, avo wakimbilila Listila na Delibe, miwambo ya Likaonia, na isi ziwazunguluke, ");
INSERT INTO zaj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","na haja wagendelela kuupeta Usenga Unogile. ");
INSERT INTO zaj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kuja Listila kukala na munhu imwe yakalile mbetembete songela hayavumbuke, na kakala hadahile kutembela hata mwanza umwe. ");
INSERT INTO zaj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Kamtegeleza Paulo viyakalile yolonga. Paulo kamulola ng'hani, kona kamba kakala na nhamanila ya kuhonyigwa, ");
INSERT INTO zaj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","avo Paulo kenula dizwi yolonga, “Ima na magulu gako!” Bahaja ija imunhu kazumha na kusonga kutembela. ");
INSERT INTO zaj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Wanhu viwonile gaja gayatendile Paulo, waguta muulonzi wa Kilikaonia, “Miungu ilumbile kamba wanhu ituhumulukila!” ");
INSERT INTO zaj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banaba wamkema Zeu, na Paulo wamkema Helime, kwavija kakala iyo yolonga mbuli zose. ");
INSERT INTO zaj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mkulu wa nhambiko wa mzimu ukemigwa Zeu, ayo ng'anda yake ikalile hanze ya idiwambo, kagala ng'ombe na mkungo wa malua halwivi lwa idiwambo, heyo na ididale da wanhu walonda kuwalavila nhosa watumigwa wa Kilisto. ");
INSERT INTO zaj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ila watumigwa wa Kilisto Banaba na Paulo viwahulike gano, wadega vivalo vao na hima walopola walawa hanze na kukimbilila hagatigati ya didale da wanhu, abaho, wenula dizwi walonga, ");
INSERT INTO zaj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Mweye wanhu, habali mtenda mbuli zino? Tweye vivija twa wanhu tu kamba mweye! Tuwagalila mweye Usenga Unogile, tuwalongela mweye mgaluke kulawa mmbuli zino zilibule kinhu na mmuhindukile Mulungu yali na ugima, yalumbile ulanga na isi na bahali na vinhu vose vili himo. ");
INSERT INTO zaj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Umwaka Mulungu kawaleka wanhu wose wachole mnzila zao wenyego. ");
INSERT INTO zaj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Hata avo kalagusa usindila wa kulagusa vija viyakalile baho. Kawalagusila mweye unozi wake mkuwagwaa mvula kulawa kuulanga na ndigwa mmisimu yake, kawagwaa mandia bwando na kuwamemeza ndeng'ha mmioyo yenu.” ");
INSERT INTO zaj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hamoja na mbuli zino ikala vidala kudizuila ididale da wanhu sambidiwalavile nhosa. ");
INSERT INTO zaj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ila Wayahudi kulawa mdiwambo da Antiokia na Ikonio weza haja na kudiswagiza ididale da wanhu. Abaho, wamtoa na mabwe Paulo, wam'bulula, wamulava hanze ya idiwambo, wagiza kadanganhika. ");
INSERT INTO zaj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ila wanahina viwamzunguluke, kenuka na kubweleganya mgati ya idiwambo. Imitondo iyagwe heyo na Banaba wasegela wachola Delibe. ");
INSERT INTO zaj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Waupeta Usenga Unogile mdiwambo dija na kuwapata wanahina bwando, abaho, wabweleganya wachola Listila, Ikonio, na kudiwambo da Antiokia. ");
INSERT INTO zaj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Haja wawagangamiza imioyo wanahina na kuwagong'ondeza kamba wagendelele kukala muinhamanila, wolonga, “Tolondigwa tubitile migayo bwando kileka mana twingile Muundewa wa Mulungu.” ");
INSERT INTO zaj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paulo na Banaba wawasagulila wavyele mmadale gose ga wanhu wamtogole Kilisto. Na mkutambika na kufunga waweka mmakono ga Mndewa mwa ayo nhamanila yao muikalile. ");
INSERT INTO zaj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Abaho, wabitila Pisidia wengila Pamfilia, ");
INSERT INTO zaj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","na viwaupetile Usenga Unogile kuja Pega, wachola Atalia, ");
INSERT INTO zaj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","kulawa Atalia wabweleganya mdiwambo da Antiokia, ahaja hawawekile mngekewa ya Mulungu sama ya sang'hano ija iwamambukize. ");
INSERT INTO zaj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Viwavikile wawakema hamoja wanhu wamtogole Kilisto na kuwalongela mbuli zose Mulungu ziyatendile kubitila hewo na vija viyawavugulile Wamhazi lwivi lwa nhamanila. ");
INSERT INTO zaj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Wakala haja mazua bwando na wanahina. ");
INSERT INTO zaj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Weza wanhu kulawa Yudea wakala wowafundiza wanhu wamtogole Kilisto, wolonga, “Kamba hamwingile kumbi kamba viyafundize Musa, havidahika mweye kukomboligwa.” ");
INSERT INTO zaj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Mbuli ino iwatenda Paulo na Banaba waibamilile nao na kuiuzagiza nao ng'hani. Avo Paulo na Banaba wasaguligwa, hamoja na wanhu wayagwe wamtogole Kilisto, wachole Yelusalemu ha watumigwa wa Kilisto na wavyele wakawauze mbuli ino. ");
INSERT INTO zaj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Wanhu wamtogole Kilisto wawatuma, na viwakalile wochola kubitila Foinike na Samalia, wawalongela avija Wamhazi viwautogole Usenga wa Mndewa. Mbuli zino ziwatenda wanhu wose wamtogole Kilisto wadeng'he ng'hani. ");
INSERT INTO zaj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Viwavikile Yelusalemu, wabokelwa na wanhu wamtogole Kilisto, watumigwa wa Kilisto, na wavyele. Wawasimulila gose gayatendile Mulungu kubitila hewo. ");
INSERT INTO zaj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Abaho, wanhu wayagwe wamtogole Kilisto wakalile ng'ambu ya Mafalisayo wema na kulonga, “Wamhazi wolondigwa wengizigwe kumbi na wagawinze Malagizo ga Musa.” ");
INSERT INTO zaj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Watumigwa wa Kilisto na wavyele waiting'hana wailole goya mbuli ino. ");
INSERT INTO zaj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Viwagendelele ng'hani kulongelela, Petulo kenuka na kuwalongela, “Ndugu zangu, movitanga kamba mazua gabitile Mulungu kanisagula nie kulawa mmwanza wenu niwapetele Wamhazi Usenga Unogile giladi wahulike na watogole. ");
INSERT INTO zaj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na Mulungu, yoitanga mioyo ya wanhu, kalagusa kamba kawatogola mkuwagwelela Loho wake, kamba viyatendile kumwetu. ");
INSERT INTO zaj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Mkuing'aliza mioyo yao na nhamanila, katutenda tweye na hewo tuilinge. ");
INSERT INTO zaj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Avo habali mulonda kumgeza Mulungu mkuwekila wanahina nila msingo ayo wahenga zetu ama tweye hatuidaha kuipapa? ");
INSERT INTO zaj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Si vivo! Totogola kamba tokomboligwa kubitila ngekewa ya Mndewa wetu Yesu, kamba vija hewo viwokomboligwa.” ");
INSERT INTO zaj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Wanhu wose waiting'hane haja wanyamala, wawategeleza Paulo na Banaba viwakalile wowalongela vilaguso na mikanganyo Mulungu iyatendile mwa Wamhazi kubitila hewo. ");
INSERT INTO zaj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Viwamambukize kulonga, Yakobo kalonga, “Ndugu zangu, nhegelezeni! ");
INSERT INTO zaj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni Petulo katusimulila avija tanhu Mulungu viimnogele kuwasola wanhu kulawa mwa Wamhazi sama ya twaga jake. ");
INSERT INTO zaj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Mbuli za wahokozi zoigondanya na mbuli ino kamba vizandikwe, ");
INSERT INTO zaj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Zihamala mbuli zino, nobweleganya, na kudizenga kabili hema da Daudi dikalile digwile. Nodizenga chusa haja hadibanangigwe, na kudinula. ");
INSERT INTO zaj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Avo wanhu wose wasigale wamzahile Mndewa, hamoja na Wamhazi wose, awo wakemigwe mtwaga jangu, kolonga Mndewa yatendile mbuli zino,’ ");
INSERT INTO zaj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","zitangigwe songela mwaka. ");
INSERT INTO zaj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Avo, vino vivo nilamule kamba, sambituwagaze Wamhazi wamtogole Mulungu, ");
INSERT INTO zaj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ila tuwandikile kamba wakale kutali na vakuja vilavigwe nhosa ha miwegu, ugoni, kuja nyama ifile mkubotigwa, na kuja na kung'wa mulopa. ");
INSERT INTO zaj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kwavija Musa kapetwa m'viwambo vose songela mwaka na mwaka, na mbuli zake zisomigwa mzing'anda za nhambiko Mmazua gose ga Mhumulo.” ");
INSERT INTO zaj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Abaho, watumigwa wa Kilisto na wavyele na wanhu wose wamtogole Kilisto walamula kuwasagula wanhu kulawa mmwanza wao, wawatume wachole kudiwambo da Antiokia hamoja na Paulo na Banaba. Avo wawasagula wanhu wabili, Yuda, yakalile na twaga da ikabili dikemigwa Balisaba, na Sila, wakalile vilangizi wa wanhu wamtogole Kilisto. ");
INSERT INTO zaj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Wawagwelela na lupwilili luno lwandikigwe vino, “Tweye watumigwa wa Kilisto na wavyele, wandugu zenu, ha Wamhazi wamtogole Kilisto ako kudiwambo da Antiokia, na muisi za Silia na Kilikia. Towalamsa. ");
INSERT INTO zaj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tuhulika kamba kuna wanhu walawa kunze ya gaja gatufundize bila kulongeligwa na tweye walonga mbuli za kuwagaza na kuzizungulusa ngelegeza zenu, ");
INSERT INTO zaj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","avo wose tuitogolela kuwasagula wanhu tuwatume kumwenu na wambwiga zetu wanogelwa Banaba na Paulo, ");
INSERT INTO zaj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","wauhonzile ugima wao sama ya Mndewa wetu Yesu Kilisto. ");
INSERT INTO zaj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Avo tuwatuma Yuda na Sila awo wenyego wowalongela na mulomo wao mbuli zino zitwandike. ");
INSERT INTO zaj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Imnogela Loho wa Mulungu na tweye sambituwadikwe kinhu kiyagwe chochose hanze ya malagizo gano, ");
INSERT INTO zaj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","kamba muleke kuja vakuja vilavigwe nhosa ha miwegu, muleke kuja na kung'wa mulopa, muleke kuja nyama ibotigwe, na muleke ugoni. Kamba muhainega na vinhu vino, motenda goya. Tokiibona.” ");
INSERT INTO zaj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Waja wanhu watumigwa wachola kudiwambo da Antiokia, viwavikile wawakema hamoja wanhu wamtogole Kilisto na kuwagwelela ulupwilili. ");
INSERT INTO zaj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Wanhu viwalusomile, wadeng'helela sama ya Usenga uja wa kugangamiza. ");
INSERT INTO zaj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila wakala wahokozi walonga mbuli bwando za kuwagangamiza na kuwagela mhiko wanhu wamtogole Kilisto. ");
INSERT INTO zaj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Wakala haja kipigiti kiguhi, abaho, wanhu wamtogole Kilisto wawabweza na tindiwalo ha awo wawatumile. ");
INSERT INTO zaj_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ila Sila kanogelwa kukala haja. ");
INSERT INTO zaj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ila Paulo na Banaba wasigala mdiwambo da Antiokia, hamoja na wanhu wayagwe bwando wafundiza na kuupeta Usenga wa Mndewa. ");
INSERT INTO zaj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mazua madodo hamwande Paulo kamulongela Banaba, “Na tubweleganye kuchugu tuwatembelele wanhu wose wamtogole Kilisto m'viwambo vose kutuupetile Usenga wa Mndewa tukawalole vija vowogendelela.” ");
INSERT INTO zaj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banaba kalonda kumsola Yohana, yakalile na twaga diyagwe dikemigwa Maluko, wachole wose, ");
INSERT INTO zaj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ila Paulo kalema kwavija Yohana vivija yokemigwa Maluko kakala yawalekile Pamfilia na kulema kugendelela na hewo msang'hano. ");
INSERT INTO zaj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Avo wakala wokiibamilila ng'hani mbaka waigola. Banaba kamsola Maluko wengila mmeli na kuchola Sipulo. ");
INSERT INTO zaj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ila Paulo kasagula kuchola na Sila, na wanhu wamtogole Kilisto wawatambikila wachole na ngekewa ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Kachola kubitila isi za Silia na Kilikia yowagangamiza wanhu wamtogole Kilisto. ");
INSERT INTO zaj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo kavika Delibe na Listila, kuyakalile yokala mwanahina imwe yakemigwe Timoteo. Kakala mwana wa mtwanzi wa Kiyahudi Yamtogole Kilisto, ila tataake kakala Mgiliki. ");
INSERT INTO zaj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Wanhu wamtogole Kilisto wa Listila na Ikonio wanogezwa ng'hani na Timoteo. ");
INSERT INTO zaj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo kamulonda Timoteo yachole nayo mmwanza wake, kamsola kamwingiza kumbi sama ya Wayahudi wakalile wokala hiko, kwavija wose wavitanga kamba tataake kakala Mgiliki. ");
INSERT INTO zaj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Viwakalile wobita mmiwambo ija, wawagwaa wanhu malagizo galavigwe na watumigwa wa Kilisto na wavyele wa hiko Yelusalemu, giladi wagagoge. ");
INSERT INTO zaj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Avo wanhu wamtogole Kilisto wagendelela kugangamala muna inhamanila, na kila zua mheta yao yongezeka. ");
INSERT INTO zaj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulo na wayage wabitila muisi ya Fligia na Galatia, kwavija Loho wa Mulungu kawagomesa sambiwaupete Usenga wa Mulungu muisi ya Asia. ");
INSERT INTO zaj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Viwavikile muimbaka ya isi ya Misia, wageza kuchola isi ya Bitinia, ila Loho wa Yesu kawagomesa. ");
INSERT INTO zaj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Avo, wabitila Misia, wahumuluka mbaka mdiwambo da Toloa. ");
INSERT INTO zaj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mkipigiti cha ikilo Paulo kona nzozi. Kamona munhu wa isi ya Makedonia kema na kumuyalalila yomulongela, “Wize Makedonia ukatutaze!” ");
INSERT INTO zaj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulo viyaiwene nzozi hiyo, kipigiti kikija tuisasala kuchola Makedonia, kwavija Mulungu katukema tuwapetele Usenga Unogile. ");
INSERT INTO zaj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kulawa Toloa tuloka na meli dimwe kwa dimwe mbaka Samotilake, imitondo yake tuvika Neapoli. ");
INSERT INTO zaj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kulawa haja tuchola mbaka Filipi, wambo kulu muisi ya Makedonia, dikalile koloni da Waloma. Tukala haja mazua madodo. ");
INSERT INTO zaj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mdizua da Mhumulo tulawa hanze ya ulwivi lwa idiwambo tuchola kumgwazo wa ulwanda, kutugelegeze kamba ako kukala na hanhu ha kutambikila. Tukala hasi na kulongelela na watwanzi wakalile wailundize haja. ");
INSERT INTO zaj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mtwanzi imwe yakemigwe Lidia, yakalile yochuluza vivalo va hela bwando kulawa mdiwambo da Tiatila, yakalile yomtambikila Mulungu, katutegeleza. Mndewa kauvugula moyo wake, kagabokela gaja gakalile golongigwa na Paulo. ");
INSERT INTO zaj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Heyo na wanhu wa kung'anda yake viwabatizigwe, katugoneka yotuyalalila yolonga, “Ihawa munyona kamba nie nimtogola Mndewa, izoni mkale mng'anda yangu.” Abaho, katunanahila tuchole. ");
INSERT INTO zaj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Zua dimwe vitukalile tochola hanhu ha kutambikila, tumting'hana nyakadala wa kitwanzi yakalile na kinyamkela wa ulaguzi. Nyakadala hiyo kakala yowagwelela hela bwando wakulu zake kulawa mzisang'hano zake za ulaguzi. ");
INSERT INTO zaj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mndele ino kamuwinza Paulo na tweye, kenula lwangi kalonga, “Wanhu wano wawo watumigwa wa Mulungu Mkulu Ng'hani! Wowapeteleni nzila ya kukomboligwa!” ");
INSERT INTO zaj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Na katenda vino mmazua bwando, ila Paulo kona lusango, kahinduka na kumulongela ikinyamkela, “Mtwaga da Yesu Kilisto, nokulonda umulawe mndele ino!” Na kipigiti kikija ija ikinyamkela kamulawa. ");
INSERT INTO zaj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Iwakulu zake viwawene kamba tamanilo jao da kupata hela dimala, wawagoga Paulo na Sila na kuwakwekwesa mbaka kuna disoko haulongozi wa wanhu wali na udaho. ");
INSERT INTO zaj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Wawagala ha walamula walonga, “Wambo jetu dibanangigwa sama ya Wayahudi wano. ");
INSERT INTO zaj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wozipeta nzoela zigomesigwe na malagizo getu kuzibokela ama kuziwinza, kwavija tweye twa wenekae wa Loma.” ");
INSERT INTO zaj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Dale da wanhu dikiilumba na kuwavamhila, na iwalamula walagiza wavuligwe vivalo vao, abaho, walanhigwe mbalati. ");
INSERT INTO zaj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Viweshile kuwalanha ng'hani, wawagela mkifungo, na mwimilizi wa ing'anda ya kifungo kalagizigwa yawemilize goya. ");
INSERT INTO zaj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Na heyo viyabokele ndagizi ino, kawagela mdigati da mng'anda, na kuwadaza gamagulu na mhikwi. ");
INSERT INTO zaj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Viivikile kilo kikulu Paulo na Sila wakala wotambika na kumwimbila Mulungu nyila za kumtogola, na wanhu wayagwe wakalile wafungigwe na hewo wakala wowategeleza. ");
INSERT INTO zaj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Bahaja ulawilila mgudemo mkulu wa isi, hata msingi wa ing'anda ya kifungo utigisika. Baho nyivi zose za ing'anda ya kifungo zivuguka, na minyolo ikalile iwafungile ikongoloka. ");
INSERT INTO zaj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ija imwimilizi wa ing'anda ya kifungo kalamuka, na viyawene zinyivi za ing'anda ya kifungo zivuguka, kasomola zele jake na kulonda kukiikoma kwavija kagelegeza kamba wanhu wakalile mkifungo wakimbila. ");
INSERT INTO zaj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ila Paulo kenula dizwi kalonga, “sambiuikome mwenyego! Tweye tose twa bahano!” ");
INSERT INTO zaj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Viyamkemile munhu yagale viwenge, ija imwimilizi wa ing'anda ya ikifungo kakimbilila mng'anda, kailagaza haulongozi wa gamagulu ga Paulo na Sila kuno yogudema. ");
INSERT INTO zaj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Abaho, kawalava hanze kawauza, “Wandewa, nhendeze giladi nikomboligwe?” ");
INSERT INTO zaj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Wamwidika, “Mtogole Mndewa Yesu, kokomboligwa gweye na wanhu wali mng'anda yako.” ");
INSERT INTO zaj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Abaho, wampetela Usenga wa Mndewa, heyo na wanhu wose wali mng'anda yake. ");
INSERT INTO zaj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kipigiti kikija cha ikilo ija imwimilizi kawasola Paulo na Sila kawasuluza vilonda vao, baho heyo na wanhu wose wali mng'anda yake wabatizigwa. ");
INSERT INTO zaj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kawasola, kawagala kung'anda yake, na kuwagwelela mandia. Heyo na wanhu wose wali mng'anda yake wadeng'ha ng'hani, kwavija wamtogola Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Imitondo iyagwe, walamula wawalagiza wakulu wa asikali wa Loma, walonga, “Walekeseni waja wanhu wachole.” ");
INSERT INTO zaj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ija imwimilizi wa ing'anda ya kifungo kamulongela Paulo, “Walamula walagiza kamba mulekesigwe. Avo, laweni hanze, mchole mditindiwalo.” ");
INSERT INTO zaj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ila Paulo kawalongela iwakulu wa asikali, “Hatutendile mbuli yoyose ihile, ila watutoa haulongozi wa wanhu, na kutugela mkifungo kamba tweye twa wenekae wa wambo da Loma. Na sambi wolonda kutulava mkifiso. Bule! Leka weze watulekese wenyego.” ");
INSERT INTO zaj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Wakulu wa asikali wawalongela walamula mbuli zino, na hewo viwahulike kamba Paulo na Sila wakala wenekae wa Loma, wadumba. ");
INSERT INTO zaj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Weza wawayalalila, na viweshile kuwalava hanze, wawalongela wahalawe mdiwambo dija. ");
INSERT INTO zaj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulo na Sila viwalawile mkifungo, wachola hakae ya Lidia, viweshile kuiyona na wanhu wamtogole Kilisto, wawagangamiza, abaho, wachola. ");
INSERT INTO zaj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo na Sila viwabitile m'viwambo va Amfipolia na Apolonia, wavika Tesalonike, kukalile na ng'anda ya nhambiko ya Wayahudi. ");
INSERT INTO zaj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulo, kamba viyatendaga, kengila mng'anda ya nhambiko, mkipigiti cha Mazua madatu ga Mhumulo kalongelela na Wayahudi kulawa Mzinyandiko Zing'alile, ");
INSERT INTO zaj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","kawapetela na kuwalagusila kamba Kilisto kagazigwa na kuzuka kulawa mkudanganhika. Paulo kalonga, “Yesu, ino iniwapetele mweye mbuli zake, iyo Kilisto.” ");
INSERT INTO zaj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wayahudi wayagwe watogola na kuilumba na Paulo na Sila, watenda mheta ya Wagiliki wamdumbile Mulungu iwa ng'hulu, na watwanzi bwando wali na udaho. ");
INSERT INTO zaj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ila Wayahudi wona migongo, wawasola wanhu wehile kulawa mdisoko, watenda dale na kusonga kutenda mbuli zihile mdiwambo. Waivamhila ng'anda ya Yasoni, kuno wowazahila Paulo na Sila giladi wawagale haulongozi wa didale da wanhu. ");
INSERT INTO zaj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ila viwawahonyile, wamkwekwesa Yasoni na wanhu wayagwe wamtogole Kilisto haulongozi wa iwakulu wa idiwambo, walonga, “Wanhu wano wagala ndwagi muulumwengu wose na sambi wa hano, ");
INSERT INTO zaj_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","na Yasoni kawagoneka hakae yake. Wose watenda mbuli zilemigwe na malagizo ga Kaisali, wolonga kamba hana mndewa iyagwe, yokemigwa Yesu.” ");
INSERT INTO zaj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Viwahulike vino, wakulu wa idiwambo na ididale da wanhu wenula hebohebo kulu. ");
INSERT INTO zaj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Wawatoza hela Yasoni na wayage, abaho, wawalekesa wachole. ");
INSERT INTO zaj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Viivikile ikilo, wanhu wamtogole Kilisto wawatuma Paulo na Sila ako Beloya. Viwavikile hiko, wengila muna ing'anda ya nhambiko. ");
INSERT INTO zaj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Wanhu wa hiko wakala wana sulukila za kuifundiza kubanza wanhu wa Tesalonike. Waubokela goya uja usenga mmioyo yao, na mazua gose wakala wozigelegeza ng'hani Zinyandiko Zing'alile, giladi wone kamba zija zilongigwe na Paulo na Sila zikala mbuli za kweli. ");
INSERT INTO zaj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Wanhu bwando mmwanza wao watogola, ng'haning'hani watwanzi wali na matwaga na wambigalo bwando wa Kigiliki. ");
INSERT INTO zaj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Wayahudi wa Tesalonike viwahulike kamba Paulo koupeta Usenga wa Mulungu ako Beloya, wachola hiko na kusonga kutenda kiyahiyahi na kudivuluga didale da wanhu. ");
INSERT INTO zaj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Bahaja wanhu wamtogole Kilisto wamtuma Paulo yachole mhwani, ila Sila na Timoteo wasigala Beloya. ");
INSERT INTO zaj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Waja iwanhu wakalile womsindikiza Paulo wamgala mbaka Atene, abaho, wabwela na ndagizi kulawa ha Paulo kamba Sila na Timoteo wamuwinze mbwisa. ");
INSERT INTO zaj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulo viyakalile Atene yowabeta Sila na Timoteo, moyo wake ugevuzika ng'hani, viyonile wambo hijo vidimemile miwegu. ");
INSERT INTO zaj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kakala yokiibamilila na Wayahudi na wanhu wayagwe wakalile womnogela Mulungu muna ing'anda ya nhambiko, na mazua gose kakala yokiibamilila hadisoko hamoja na wanhu wose wakalile hano. ");
INSERT INTO zaj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Vivija wanhu wayagwe wawinzile mafundo ga Waepikulio na Wastoiki wambamilila. Wayagwe walonga, “M'bozi ino kolonda kulonga choni?” Na wayagwe walonga, “Kokoneka kamba munhu yozipeta mbuli za mizimu ya wahenza.” Walonga vino kwavija Paulo kakala youpeta Usenga Unogile wa Yesu na mbuli ya mzuso wa wanhu. ");
INSERT INTO zaj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Abaho, wamsola Paulo wamgala ha wakulu wa ikitala cha Aleopago, walonga, “Tolonda kuitanga mbuli ino ya mafundo ga sambi guulonga. ");
INSERT INTO zaj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kwavija mbuli ziyagwe zituhulike zigala mkanganyo mmagwiti getu, avo tolonda kuzitanga nhegulo za mbuli zino.” ");
INSERT INTO zaj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Wenekae wose wa Atene na wahenza wakalile hiko waleka sang'hano zao zose ila wakala wosimulila na kutegeleza mbuli za sambi. ");
INSERT INTO zaj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulo kema haulongozi wa ikitala cha Aleopago kalonga, “Wanhu wa Atene, nokona kamba mweye mwa wanhu muigogile dini ng'hani. ");
INSERT INTO zaj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Vinikalile nizunguluka mdiwambo jenu na kulola goya hanhu hamtambikila, nyona kilingo kimwe cha kulavila nhosa chandikigwa, ‘Ha Mulungu yalekile kutangigwa.’ Avo, heyo yumumtambikila bila kumtanga, iyo niwapetela mbuli zake. ");
INSERT INTO zaj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Mulungu yautendile ulumwengu na vinhu vose vili mgati yake, iyo Mndewa wa ulanga na isi, heyo hakala mzing'anda zizengigwe na makono ga wanhu. ");
INSERT INTO zaj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Heyo hasang'hanikiligwa na makono ga wanhu kamba vija kolonda kinhu kulawa kumwao, kwavija heyo mwenyego iyo yowagwelela wanhu ugima, yowatenda wahumule na kuwagwelela vinhu vose. ");
INSERT INTO zaj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kulawa munhu imwe kazitenda ng'holo zose za wanhu giladi wakakale isi yose, vivija kalamula kipigiti kikigwe sama yao na hanhu hondawakale. ");
INSERT INTO zaj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Mulungu katenda vino giladi wanhu wamzahile, hata mkum'babasababasa, giladi wamone, ila Mulungu halikutali na munhu yoyose mmwanza wetu. ");
INSERT INTO zaj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kamba viyalongile munhu imwe, ‘Mgati mmwake tweye tokala, totembela, na towa wagima.’ Kamba watunga nyila zenu wayagwe viwalongile, ‘Tweye twa wanage.’ ");
INSERT INTO zaj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kwavija tweye twa wana wa Mulungu, havilumbile kugelegeza kamba Mulungu yali kuulanga ka kamba zahabu ama zuma ama dibwe, vinhu visongoligwe na kuhambigwa na wanhu. ");
INSERT INTO zaj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Umwaka Mulungu kakala kamba vija hawonile ubozi uno uwatendile wanhu. Ila sambi kowalagiza wanhu wose wa kila hanhu waleke vilozo vao. ");
INSERT INTO zaj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kwavija keka zua dondayawalamule wanhu wose wali muulumwengu bila kulola kihanga cha munhu kubitila munhu imwe yamsagule. Mulungu kawagubulila wanhu wose mbuli ino mkumzusa munhu iyo kulawa mkudanganhika!” ");
INSERT INTO zaj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Avo viwahulike Paulo yolonga mbuli ya kuzuka, wayagwe wasonga kutenda zihaka, ila wayagwe walonga, “Tolonda tukuhulike mwanza uyagwe mmbuli ino.” ");
INSERT INTO zaj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Avo Paulo kawaleka mkitala, kachola. ");
INSERT INTO zaj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Wanhu wayagwe wailumba na Paulo, watogola. Mmwanza wao kakala Dionisio yakalile munhu wa kitala cha Aleopago, na mtwanzi imwe yakemigwe Damali, na wanhu wayagwe. ");
INSERT INTO zaj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Vigamalile gano, Paulo kasegela Atene kachola kudiwambo da Kolinto. ");
INSERT INTO zaj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ako kam'vika Muyahudi imwe twaga jake Akuila, mwenekae wa isi ya Ponto, yakalile na kipigiti kiguhi songela viyavikile kulawa isi ya Italia hamoja na mtwanzi wake yakemigwe Pilisila, kwavija Mndewa Klaudio kakala yalagize kamba Wayahudi wose wasegele wambo da Loma. Paulo kachola kuwalola, ");
INSERT INTO zaj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na kwavija hewo wakala wogongomanya mahema ga kuguza kamba heyo, avo Paulo kakala nao, yosang'hanika hamoja na hewo. ");
INSERT INTO zaj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Mazua gose ga Mhumulo kakala yoibamilila na Wayahudi na Wagiliki mzing'anda za nhambiko, yogeza kuwatenda wamtogolele gaja goyowalongela. ");
INSERT INTO zaj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila na Timoteo viwavikile kulawa isi ya Makedonia, Paulo kasonga kuupeta Usenga Unogile kipigiti chose yolava usindila ha Wayahudi kamba Yesu iyo Kilisto. ");
INSERT INTO zaj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Viwam'bezile na kumuliga, kakung'unha vivalo vake, kawalongela, “Mulopa wenu na uwe mmapala genu wenyego! Nie nabule mbuli haulongozi wa Mulungu. Songela sambi nowacholela Wamhazi.” ");
INSERT INTO zaj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Abaho, kahalawa hanhu haja, kachola hakae ya munhu imwe Mmhazi, twaga jake Tito Yusto, munhu mwende wa Mulungu. Ng'anda yake ikala ibakane na ing'anda ya nhambiko. ");
INSERT INTO zaj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilisipo, yakalile mkulu wa ng'anda ya nhambiko, kamtogola Mndewa hamoja na wanhu wose wali mng'anda yake, na wanhu bwando kulawa Kolinto wamuhulike Paulo wamtogola Mulungu na wabatizigwa. ");
INSERT INTO zaj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ikilo imwe Mndewa kamulongela Paulo mnzozi, kalonga, “sambiudumbe, ila gendelela kupeta, sambiunyamale, ");
INSERT INTO zaj_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kwavija nie mwenyego na hamoja na gweye, na haduhu munhu yondayadahe kukuvamhila na kukulumiza, kwavija mdiwambo dino nnao wanhu bwando.” ");
INSERT INTO zaj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Avo Paulo kakala hiko mulao umwe na milenge sita, yowafundiza wanhu Usenga wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galio viyakalile mkulu wa isi ya Akaya, Wayahudi waifunga hamoja, wamgoga Paulo na kumgala kukitala. ");
INSERT INTO zaj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Walonga, “Munhu ino kowatenda wanhu wamtambikile Mulungu muinzila hailagizwe na malagizo.” ");
INSERT INTO zaj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulo viyakalile behi na kulonga, Galio kawalongela Wayahudi, “Kamba mweye Wayahudi muhamtaguse munhu ino na mbuli ihile ama ya uzenzeleganye, nihatogole kuwategeleza. ");
INSERT INTO zaj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ila avija mbuli ino vuili mbuli ya mbuza za mbuli na matwaga na malagizo genu wenyego, galoleni mwemwe wenyego. Nie sidaha kuwa mulamula wa mbuli zino!” ");
INSERT INTO zaj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Avo kawawinga walawe mkitala. ");
INSERT INTO zaj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Abaho, wose wamgoga Sositene, yakalile mkulu wa ing'anda ya nhambiko na kumtoa haulongozi wa ikitala. Ila Galio hasang'hanike na chochose mmbuli ino. ");
INSERT INTO zaj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo kagendelela kukala mdiwambo da Kolinto mazua bwando, abaho, kawalaga wanhu wamtogole Kilisto, kachola kuisi ya Silia hamoja na Pilisila na Akuila. Kipigiti hanasegela mdiwambo da Kenikilea, kabea mvili zake sama ya kiduilo kiyaiduile. ");
INSERT INTO zaj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Viwavikile mdiwambo da Efeso, Paulo kawaleka hiko, heyo kengila muna ing'anda ya nhambiko, kaibamilila na Wayahudi. ");
INSERT INTO zaj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Viwamulondile yakale na hewo mkipigiti kitali, heyo hanogelwe. ");
INSERT INTO zaj_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ila viyakalile yowalaga kalonga, “Ihamnogela Mulungu, nobwela kabili kumwenu.” Kakwela mmeli kasegela mdiwambo da Efeso. ");
INSERT INTO zaj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Viyavikile mdiwambo da Kaisalia, kachola kudiwambo da Yelusalemu kuwalamsa wanhu wamtogole Kilisto, abaho, kachola kudiwambo da Antiokia. ");
INSERT INTO zaj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kakala hiko mazua madodo, abaho, kasegela kachola yobita kiwambo kimwe mbaka kiyagwe yobitila isi za Galatia na Fligia, yowagangamiza wanahina wose. ");
INSERT INTO zaj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Kipigiti hicho kukala na Muyahudi imwe twaga jake Apolo, munhu wa wambo da Alekizandalia, keza mdiwambo da Efeso. Kakala munhu yali na udaho wa kulonga, na kakala yozitanga goya Nyandiko Zing'alile. ");
INSERT INTO zaj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kakala yafundizigwe Nzila ya Mndewa, na kakala yolonga kuno yogangamiza gaja goyolonga, na kuwafundiza wanhu mbuli za Yesu vija vuzilondigwa, ila kaitanga mbatiza ya Yohana iiyeka. ");
INSERT INTO zaj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Kasonga kulonga bila kudumba muna ing'anda ya nhambiko. Ila Pilisila na Akuila viwamuhulike, wamsola wamgala hakae yao wamsambulila goya Nzila ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo viyalondile kuchola kuisi ya Akaya, wanhu wamtogole Kilisto wamgangamiza, wawandikila lupwilili giladi wanhu wa Akaya wam'bokele. Viyavikile hiko, kawataza ng'hani waja watogole kubitila ngekewa ya Mulungu, ");
INSERT INTO zaj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","kwavija kawahuma Wayahudi haulongozi wa wanhu, kuno yogangamiza kubitila Mzinyandiko Zing'alile kamba Yesu iyo Kilisto. ");
INSERT INTO zaj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo viyakalile mdiwambo da Kolinto, Paulo kabitila mziisi za mgati kachola kudiwambo da Efeso. Haja kawavika wanhu wamtogole Kilisto, ");
INSERT INTO zaj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","kawauza, “Vumumtogole Kilisto, mum'bokela na Loho wa Mulungu?” Wamwidika, “Bule, hata kuhulika kamba hana Loho wa Mulungu hatunahulika.” ");
INSERT INTO zaj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paulo kawauza, “Vino m'batizigwa ubatizo ulihi?” Wamwidika, “Ubatizo wa Yohana.” ");
INSERT INTO zaj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo kalonga, “Ubatizo wa Yohana ukala ubatizo wa kuleka vilozo, yowalongela wanhu wamtogole ija yondayeze hachugu chake, na heyo iyo Yesu.” ");
INSERT INTO zaj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Viwahulike gano, wabatizigwa mditwaga da Mndewa Yesu. ");
INSERT INTO zaj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Abaho, Paulo kawekila makono gake, na Loho wa Mulungu kawahumulukila, wasonga kulonga ulonzi wa sambi na kupeta Usenga ulawile ha Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Mheta yao ikala kamba wambigalo longo dimwe na wabili. ");
INSERT INTO zaj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo kengila muna ing'anda ya nhambiko na kulonga bila kudumba mkipigiti cha milenge midatu. Kaibamilila na wanhu na kuwatenda wazitogole mbuli za Undewa wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ila wanhu wayagwe wakala wadala, walema kutogola, na kuilonga vihile Inzila ija haulongozi wa wanhu. Avo Paulo kawaleka, kawasola wanahina na kuibamilila nawo kila imitondo muna dibugano da kufundizila da Tilano. ");
INSERT INTO zaj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Mbuli zino zigendelela mkipigiti cha milao mibili, avo wanhu wose wa isi ya Asia, Wayahudi na Wagiliki, wauhulika Usenga wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Mulungu katenda mizonza ya kukanganya kubitila makono ga Paulo, ");
INSERT INTO zaj_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","hata vidanga va vivalo va kuihangusila mhome na vivalo viyagwe va sang'hano vilawile mulukuli lwake, wagaliligwa watamu na hewo wahonyigwa, na waja wakalile na vinyamkela viwalawa. ");
INSERT INTO zaj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wayahudi wayagwe wakalile wozunguluka kuno na kuno wowinga vinyamkela, wageza kudikema twaga da Yesu mwa awo wavagalwe na vinyamkela, wolonga, “Mtwaga da Yesu, ija yopetigwa na Paulo, nowalagiza mulawe.” ");
INSERT INTO zaj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Watendile gano wakala wana saba wa Muyahudi imwe, yakalile Mkulu wa Wakulu wose wa Nhambiko, yakalile yokemigwa Skeva. ");
INSERT INTO zaj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ila ija ikinyamkela kawedika, kawalongela, “Yesu nomtanga na Paulo nomtanga, ila mweye mwa wanhu waki?” ");
INSERT INTO zaj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Abaho, munhu ija yavagaligwe na kinyamkela kawavamhila na kawahuma wose. Na hewo wana wa Skeva wakimbila kulawa muna ing'anda ija kuno wali mwazi na kulumizigwa. ");
INSERT INTO zaj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Mbuli ino vuitangike na Wayahudi na Wagiliki wakalile wokala mdiwambo da Efeso, wose wona bwembwe, na twaga da Mndewa Yesu diyenzigwa. ");
INSERT INTO zaj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Na wanhu bwando wamtogole Kilisto weza haulongozi wa wanhu na kuyalalila mbuli zao zihile ziwatendile, ");
INSERT INTO zaj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Wanhu bwando, wakalile wahawi, wagala vitabu vao na kuvisoma moto haulongozi wa wanhu. Viwapetile mheta ya zihela zigulile ivitabu vija ivikila kamba vidanga alufu malongo matano (50,000) va hela. ");
INSERT INTO zaj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Avo Usenga wa Mndewa ubwililika na ukala na mhiko ng'hani. ");
INSERT INTO zaj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Vigamalile gano, Paulo kalamula kuchola kudiwambo da Yelusalemu mkubitila isi za Makedonia na Akaya. Kalonga, “Nihavika hiko, vivija nolondigwa nichole kudiwambo da Loma.” ");
INSERT INTO zaj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Avo, kawatuma Timoteo na Elasto, wakalile womtaza, wachole Makedonia, kipigiti heyo viyakalile muisi ya Asia, mkipigiti kitali kidogo. ");
INSERT INTO zaj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kipigiti hicho kulawilila hebohebo kulu mdiwambo da Efeso sama ya Nzila ya Mndewa. ");
INSERT INTO zaj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kukala na munhu imwe muhunzi yokemigwa Demetilio, yakalile yotenda miwegu ya ng'anda ya mulungu wa kitwanzi yakemigwe Atemi kulawa mmadini ga feza. Sang'hano iwatendile wasang'hana zake wapate hela bwando. ");
INSERT INTO zaj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Heyo kawakema hamoja wasang'hana wose, hamoja na wanhu wayagwe wakalile wosang'hana sang'hano kamba hiyo, kawalongela, “Mweye wanhu, movitanga kamba tweye topata hela bwando sama ya sang'hano ino. ");
INSERT INTO zaj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Na molola na kuhulika avija Paulo viyawaswagize na kuwagiza wanhu bwando hano Efeso. Na sio tu hano Efeso ila muisi yose ya Asia. Kolonga kamba miungu ija itendigwe na makono ga wanhu si miungu. ");
INSERT INTO zaj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Sio tu kamba sang'hano yetu ino yobanangika, ila vivija ng'anda ya mulungu wa kitwanzi yokemigwa Atemi yozabuzwa, na mulungu heyo mwenyego yotambikilwa muisi yose ya Asia na ulumwengu mgima, kosegezeligwa ukulu wake.” ");
INSERT INTO zaj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Viwahulike vino, wagevuzika, wasonga kuguta nyangi, wolonga, “Atemi wa Waefeso iyo mkulu!” ");
INSERT INTO zaj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Wambo jose dikala mkiyahiyahi. Wawagoga Gayo na Alistaliko, wenekae wa Makedonia wakalile mmwanza umwe na Paulo, na wakimbila nao hamoja wengila hanhu ha kuchezela. ");
INSERT INTO zaj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo kalonda kwingila mdidale, ila wanahina wamgomesa. ");
INSERT INTO zaj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Wakulu wayagwe wa isi ya Asia, wakalile wambwiga zake, wamgalila usenga wamuyalalila kamba sambiyailaguse mwenyego mkwingila hanhu ha kuchezela. ");
INSERT INTO zaj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Kipigiti hicho wayagwe wakala wobwatila kino na wayagwe wakala wobwatila kija, kwavija mting'hano uja ukala utibuke, hata wanhu behi na wose mmwanza wao hawakitangile kilamso cha hewo kuiting'hana hamoja. ");
INSERT INTO zaj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Wayahudi wamsung'hiza Alekizanda haulongozi wa ididale, na wanhu wayagwe wa mdidale wakala wom'bwatiza heyo. Avo Alekizanda kawahungila mkono giladi yaigombele haulongozi wa ididale da iwanhu. ");
INSERT INTO zaj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ila vuwamtangile kamba heyo kakala Muyahudi, wose hamoja waguta nyangi mkipigiti cha kamba masaa mabili, wolonga, “Atemi wa Waefeso iyo mkulu!” ");
INSERT INTO zaj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Na mkulu wa ikiwambo viyawanyamaze wanhu, kalonga, “Mweye wanhu wa Efeso, munhu yalihi hano yalekile kuvitanga kamba wambo da Efeso dijo mwimilizi wa ng'anda ya Atemi mkulu na wegu jake dilagale kulawa kuulanga? ");
INSERT INTO zaj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Avija mbuli zino vuzili hazidahika kubeligwa, molondigwa munyamale, sambimulopole kutenda kinhu chochose. ");
INSERT INTO zaj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Wanhu wano imuwagalile hano hawebile kinhu chochose kulawa mng'anda ya mulungu ama kumulonga mulungu wetu mbuli za ufukuzi. ");
INSERT INTO zaj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Avo, kamba Demetilio na wasang'hana zake wana mbuli na munhu yoyose, vitala vabaho, na wakulu wa viwambo wabaho, na wagale mbuli zao hiko wakataguse. ");
INSERT INTO zaj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kamba muna mbuli iyagwe imulonda kuigala, yolamulwa hana ikitala. ");
INSERT INTO zaj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kwavija todaha kutagusigwa sama ya mzahimzahi ulawilile lelo, avija vukili haduhu kilamso kiloleka chondatukilonge kisongeze mzahimzahi uno.” ");
INSERT INTO zaj_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Viyamambukize kulonga gano, kaulaga umting'hano. ");
INSERT INTO zaj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Mzahimzahi vuumalile, Paulo kawakema wanahina, na viyamalile kuwagangamiza na kuwalaga, kasegela kachola isi ya Makedonia. ");
INSERT INTO zaj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kachola kubitila isi zija, kalonga mbuli bwando yowagangamiza wanhu, hakimambukizo, kavika Ugiliki, ");
INSERT INTO zaj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ako kakala milenge midatu. Viyakalile yoifunganya kuchola isi ya Silia, kavitanga kamba Wayahudi wakala wamwikile zundo, avo kalamula kubwela mkubitila isi ya Makedonia. ");
INSERT INTO zaj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Kailongoza na Sopata, mwanage Pilo, kulawa mdiwambo da Beloya, na Alistaliko na Sekundo kulawa mdiwambo da Tesalonike, na Gayo kulawa mdiwambo da Delibe, na Tikiko na Tulofimo kulawa muisi ya Asia, na Timoteo. ");
INSERT INTO zaj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Wanhu wano walongola na wotubeta kudiwambo da Toloa. ");
INSERT INTO zaj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Vikimalile kipigiti cha Lusona lwa Mikate Ilibule Mela, tukwela meli kulawa Filipi, na vigabitile mazua matano, tuvika Toloa. Ako tukala mazua saba. ");
INSERT INTO zaj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mdizua da mwanduso wa wiki, tuiting'hana hamoja giladi tuumogole mkate. Kwavija Paulo kalonda kuchola imitondo iyagwe, avo kawapetela wanhu na kugendelela kulongelela nao mbaka kilo kikulu. ");
INSERT INTO zaj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kukala na viwenge bwando vokwaka mdigati da uchana haja hatukalile tuiting'hane. ");
INSERT INTO zaj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mmhale imwe yakemigwe Yutiko kakala yakalile mdizonzo da ing'anda kipigiti Paulo viyakalile yogendelela kulongelela. Yutiko kakala yasongile kukukila mbaka kawasa utulo, avo kalagala hasi kulawa muigolofa ya ikadatu uchana, abaho, wamdondola kuno yeshile kudanganhika. ");
INSERT INTO zaj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulo kahumuluka hasi, kamwinamila na kamkumbatila, kalonga, “Sambimgaye, mgima!” ");
INSERT INTO zaj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Abaho, Paulo kakwela kabili kudigati uchana, kaumogola mkate kaja, abaho, kagendelela kulongelela nawo mbaka ulukwili, abaho, kachola. ");
INSERT INTO zaj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Wanhu wamsola ija immhale wamgala hakae yake yali mgima, na mioyo yao ihozigwa. ");
INSERT INTO zaj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paulo kasegela haja kachola kudiwambo da Aso na magulu, kwavija kuko yalondile heyo mwenyego tum'bitile tukamsole, avo tweye tulongola kukwela meli, tuchola Aso. ");
INSERT INTO zaj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Viyatuvikile ako Aso, kakwela muna imeli itukalile, abaho, tuchola mdiwambo da Mitilene. ");
INSERT INTO zaj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kulawa hiko tusonga mwanza, na zua da ikabili tuvika behi na kisiwa cha Kio. Na zua da ikadatu tuvika kisiwa cha Samo, na zua da ikane tuvika Mileto. ");
INSERT INTO zaj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo kalamula kugendelela na mwanza wake bila kubitila mdiwambo da Efeso, giladi sambiyakawilile muisi ya Asia. Kwavija kakala yosulukila kuvika Yelusalemu mdizua da Pentekoste kamba vihadahike. ");
INSERT INTO zaj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kulawa Mileto, Paulo katuma usenga uchole kudiwambo da Efeso yowakema wavyele wa wanhu wamtogole Kilisto giladi waiting'hane na heyo. ");
INSERT INTO zaj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Viwavikile kawalongela, “Mwemwe wenyego movitanga vija ving'halile na mweye songela zua da mwanduso vinivikile muisi ya Asia. ");
INSERT INTO zaj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nimsang'hanikila Mndewa na wende mkulu, na mahozi, na migayo iniiting'hane nayo kubitila mizundo ya Wayahudi. ");
INSERT INTO zaj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Movitanga kamba silekile kuwapetela mweye kinhu chochose kinogile, ila nifundiza haulongozi wa wanhu na kulawa ng'anda imwe mbaka ng'anda iyagwe, ");
INSERT INTO zaj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","niwapetela Wayahudi hamoja na Wagiliki kamba wamuhindukile Mulungu mkuleka vilozo na kumtogola Mndewa wetu Yesu. ");
INSERT INTO zaj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Na sambi, nochola Yelusalemu, nilongozwa na Loho wa Mulungu, sikitanga chondakinilawilile hiko. ");
INSERT INTO zaj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ila Loho wa Mulungu kangwelela usindila mmiwambo yose kamba kifungo na migayo vonibeta. ");
INSERT INTO zaj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ila siugesa ugima wangu kamba kinhu cha kuigodela ng'hani, ila nogesa kumambukiza mkimbilo wangu na kumambukiza sang'hano Mndewa Yesu iyanigwelele nie, sang'hano ya kuupeta Usenga Unogile uli na ngekewa ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Na sambi nivitanga kamba, haduhu munhu yoyose wa kumwenu mmwanza wa awo inibitile kumwao niupeta Undewa wa Mulungu, yondayanyone nie kabili. ");
INSERT INTO zaj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Avo, lelo nowalongela kamba, nie nabule mbuli mnhaguso ya munhu yoyose. ");
INSERT INTO zaj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kwavija silekile kuwapetela gaja gose yogalonda Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Iloleni wenyego kwa wenyego na mdilole na ididale jose Loho wa Mulungu yawekile mweye mdilole goya. Muwemilize wanhu wa Mulungu wamtogole Kilisto, yawapatile na mulopa wa Mwanage. ");
INSERT INTO zaj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Novitanga kamba nie nihasegela, mbwizi womwizileni na kuleka kujonela bazi didale. ");
INSERT INTO zaj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hata kulawa mmwanza wenu, wolawila wanhu wondawalonge mbuli za uvwizi giladi wawagize wanahina na kuwatenda wawawinze hewo. ");
INSERT INTO zaj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Avo muiteganye, mkumbukile kamba mkipigiti cha milao midatu imisi na ikilo, silekile kumzuma kila munhu mmwanza wenu na mahozi. ");
INSERT INTO zaj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Na sambi noweka mmakono ga Mulungu na mmbuli ya ngekewa yake, yondaiwagangamize na kuwagwelela uhazi wose awo wang'alizwe. ");
INSERT INTO zaj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nie silondile kusola hela ama zahabu ama vivalo va munhu yoyose. ");
INSERT INTO zaj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mweye wenyego movitanga kamba nisang'hana na makono gangu mwenyego, giladi mhate vinhu vinilonda nie hamoja na wayangu inilinao. ");
INSERT INTO zaj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mzimbuli zose zino zinitendile niwalagusila kamba mkusang'hanika sang'hano ngaga kamba zino, tolondigwa kuwagwelela vinhu wakumbulu, tukumbukile mbuli za Mndewa Yesu mwenyego, yolonga, ‘Vinoga ng'hani kulava, kubanza kubokela.’ ” ");
INSERT INTO zaj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulo viyamambukize kulonga gano, kafugama mavindi hamoja na hewo wose, katambika. ");
INSERT INTO zaj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Wanhu wose wamulilila Paulo, na kumkumbatila na kumnonela. ");
INSERT INTO zaj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kiwagelile giogio ng'hani kikala mbuli zake ziyalongile kamba hawachona kabili kihanga chake. Abaho, wamsindikiza mbaka hana imeli. ");
INSERT INTO zaj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Vituwalagile na kwingila mmeli, tuchola dimwe kwa dimwe tuvika kukisiwa cha Kosi, na imitondo iyagwe tuchola kisiwa cha Lode, na kulawa haja tuchola kukisiwa cha Patala. ");
INSERT INTO zaj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Hiko tuvika meli ichola isi ya Foinike, twingila na kuchola. ");
INSERT INTO zaj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Vituchonile kisiwa cha Sipulo na kubita ng'ambu ya kusi, tugendelela na mwanza wetu mbaka isi ya Silia. Twiza kwima mdiwambo da Tilo, aho meli yetu ikala ihumulusa mizigo. ");
INSERT INTO zaj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Haja tuwavika wanahina, tukala nao mazua saba. Mkubitila Loho wa Mulungu wamuyalalila Paulo sambiyachole kudiwambo da Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ila kipigiti chetu chose cha kukala haja vukimalile, tusegela na kugendelela na mwanza wetu. Wanahina wose na watwanzi zao na wana zao watusindikiza mbaka hanze ya idiwambo kuna imhwani, tufugama mavindi tutambika. ");
INSERT INTO zaj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Vitumambukize kuilaga, tukwela muimeli, na hewo wabwela ukae yao. ");
INSERT INTO zaj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tugendelela na mwanza wetu m'bahali kulawa Tilo na kugela nanga mdiwambo da Tolemai, ako tuwalamsa wanhu wamtogole Kilisto na kukala na hewo zua dimwe. ");
INSERT INTO zaj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Imitondo iyagwe tusegela tuchola kudiwambo da Kaisalia twingila mng'anda ya Filipo yakalile mpeta Usenga Unogile yakalile mmwanza wa wanhu saba wasaguligwe kugola mandia. ");
INSERT INTO zaj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Kakala na wandele wane wakalile wagane wakalile na nhunza ya uhokozi. ");
INSERT INTO zaj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Vitukalile haja mazua bwando, muhokozi imwe yokemigwa Agabo keza kulawa isi ya Yudea. ");
INSERT INTO zaj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Keza hatuli tweye kausola mkwiji wa Paulo kaifunga mwenyego mmakono na mmagulu gake na umkwiji, na kulonga, “Loho wa Mulungu kolonga vino, ‘Vino vivo Wayahudi wa Yelusalemu vondawamfunge munhu mwene mkwiji uno na kuwagwelela Wamhazi.’ ” ");
INSERT INTO zaj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Vituhulike mbuli zino tweye na wanhu wakalile haja, tumuyalalila Paulo sambiyachole Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Abaho, Paulo kedika kalonga, “Kinhu chaki kimtenda, molila na kunibogoyola umoyo? Kwavija nie niitanda sio kufungigwa tu ila hata kudanganhikila Yelusalemu sama ya twaga da Mndewa Yesu.” ");
INSERT INTO zaj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Avija viyalemile kututegeleza, tunyamala, ila tulonga, “Gaja goyolonda Mndewa gatendeke.” ");
INSERT INTO zaj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Vugamalile mazua gano, tuisasala na kusonga kuchola Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Wanahina wayagwe kulawa Kaisalia vivija wachola hamoja na tweye, watugala kung'anda ya Mnasoni ako kutukalile. Mnasoni kakala munhu kulawa Sipulo na kakala mmwanza wa wanahina wa ichanduso. ");
INSERT INTO zaj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Vituvikile Yelusalemu, wandugu zetu wamtogole Kilisto watubokela na ndeng'helelo. ");
INSERT INTO zaj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Imitondo iyagwe Paulo kachola hamoja na tweye kumtembelela Yakobo, na wavyele wose wakala baho. ");
INSERT INTO zaj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Vuyamambukize kuwalamsa, Paulo kasonga kuwasimulila lumosilumosi mbuli ziyatendile Mulungu mwa Wamhazi kubitila sang'hano yake. ");
INSERT INTO zaj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Viwahulike mbuli zino wamuyenzi Mulungu, abaho, wamulongela, “Kuvona, ndugu yetu, maalufu mangahi ga Wayahudi watogole na wose waja wagagogile ng'hani Malagizo ga Musa. ");
INSERT INTO zaj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Walongeligwa mbuli zako kamba kofundiza Wayahudi wose wokala hamoja na Wamhazi, wamuleme Musa uwalongela sambiwawengize kumbi wana zao na sambiwawinze nzoela zetu. ");
INSERT INTO zaj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tutendeze? Kwa vovose wohulika kamba kwiza. ");
INSERT INTO zaj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Avo tenda kino chondatukulongele, hana wambigalo wane hano waiduile. ");
INSERT INTO zaj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Wasole wanhu wano uilumbe nao mnzoela zao za kuing'aliza, na ulihe hela za kubea mvili zao. Avo wanhu wose wovimanya kamba gaja gawalongeligwe gokulonga gweye gakala uvwizi, na gweye mwenyego kogawinza Malagizo ga Musa. ");
INSERT INTO zaj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ila awo Wamhazi wamtogole Kilisto tuwandikila vija vitulamule kamba wolondigwa waleke kuja vakuja vilavigwe nhosa ha miwegu, waleke kuja mulopa, waleke kuja nyama ilawile mwa mng'onyo yabotigwe, na waleke ugoni.” ");
INSERT INTO zaj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Imitondo iyagwe Paulo kawasola waja iwanhu na kuing'aliza heyo mwenyego hamoja na hewo. Abaho, kachola nao Kung'anda ya Mulungu na kulonga vija kipigiti cha ung'alizo wao vondakimale na nhosa yondaitendeke mwa kila munhu mmwanza wao. ");
INSERT INTO zaj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Kipigiti cha gaja ga mazua saba ga ung'alizo vikikalile behi kwisha, Wayahudi kulawa Asia wamona Paulo Muing'anda ya Mulungu. Wadiswagiza idale jose da wanhu na kumgoga. ");
INSERT INTO zaj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Watoa nyangi wolonga, “Mweye wambigalo wa Islaeli! Tutazeni! Ino iyo munhu yowafundiza wanhu wose kila hanhu sambiwatende nzoela za wanhu zetu na sambiwagawinze Malagizo getu ga Musa na sambiweze hanhu hano. Sio gano tu, ila kawagala Wagiliki Kung'anda ya Mulungu na kunyolodosa Hanhu hano Hang'alile.” ");
INSERT INTO zaj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kwavija haichanduso wamona Tulofimo munhu kulawa mdiwambo da Efeso hamoja na heyo mdiwambo, avo wagiza kamba Paulo kamgala Kung'anda ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Avo wanhu wose wa mdiwambo wenuka, wose hamoja wakimbilila Kung'anda ya Mulungu kulawa ng'ambu zose. Wamgoga Paulo wamkwekwesa na kumulava hanze ya Ing'anda ya Mulungu, na kipigiti kikija mizivi ya Ing'anda ya Mulungu ihindigwa. ");
INSERT INTO zaj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Viwalondile kumkoma, mbuli zija zim'vikila mkulu wa madale gose ga asikali wa Loma kamba wanhu wose wa mdiwambo da Yelusalemu wakala mumzahimzahi. ");
INSERT INTO zaj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kipigiti kikija kawasola asikali na wakulu wa madale ga asikali mia na kukimbilila kudikalile didale da wanhu. Waja iwanhu wakalile mumzahimzahi viwamonile ija imkulu na asikali zake, waleka kumtoa Paulo. ");
INSERT INTO zaj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ija imkulu kamcholela na kumgoga Paulo na kulagiza yafungigwe na minyolo mibili. Abaho, kauza kamba ija kakala munhu yalihi na choni chayatendile. ");
INSERT INTO zaj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wanhu wayagwe walonga vino na wayagwe walonga vija. Avo avija ija imkulu viyaihonyile ikweli ya mbuli ija sama ya umzahimzahi, kalagiza kamba Paulo yageligwe muingome. ");
INSERT INTO zaj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paulo viyavikile mzingwandala, mzahimzahi ukala mkulu ng'hani avo kapapigwa na asikali. ");
INSERT INTO zaj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Dija ididale da wanhu dikalile dimkweleleza digendelela kutoa nyangi dilonga, “Yakomigwe!” ");
INSERT INTO zaj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Paulo viyakalile behi na kwingizwa muingome, kamuuza ija imkulu, yolonga, “Nikulongele kinhu?” Ija imkulu kamuuza, “Gweye kodaha kulonga Kigiliki? ");
INSERT INTO zaj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Gweye sio Mmisili ija yasongeze muhindumuhindu na kuwalongoza wanhu makaini alufu nne kuluwala?” ");
INSERT INTO zaj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo kamwidika yolonga, “Nie na Muyahudi kulawa Taliso muisi ya Kilikia, nie na mwenekae wa wambo dimwe kulu ng'hani. Nokuyalalila unileke nilonge na wanhu wano.” ");
INSERT INTO zaj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ija imkulu viyamulekile yalonge, Paulo kema mzingwandala na kudihungila mkono ididale da wanhu, wose viwanyamale kawalongela muulonzi wa Kieblania. ");
INSERT INTO zaj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ndugu zangu na watata zangu, tegelezeni uyalazi wangu unilonga sambisambi haulongozi wenu!” ");
INSERT INTO zaj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Viwamuhulike vija voyolonga na hewo Mkieblania, wagendelela kunyamala. Abaho, Paulo kalonga. ");
INSERT INTO zaj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nie na Muyahudi nivumbukile Taliso muisi ya Kilikia. Ila nikulila mdiwambo dino da Yelusalemu, nikala mwanahina wa Gamalieli. Nifundizigwa Malagizo gose ga watata zetu, na nikala nigagogile ng'hani Malagizo sama ya Mulungu kamba vumuli mweye lelo. ");
INSERT INTO zaj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Niwagaza wanhu waitogole Nzila ino na hata kuwakoma. Niwagoga watwanzi na wambigalo na kuwagela mkifungo. ");
INSERT INTO zaj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mkulu wa Wakulu wose wa Nhambiko na Kitala chose cha wavyele wodaha kusindila mbuli zino. Na vivija kulawa kumwao nibokela lupwilili niwagalile wandugu zao wali Damaski, avo nichola ako kuwagoga wanhu wamtogole Kilisto kamba wafungigwa niwagale Yelusalemu wakasunigwe. ");
INSERT INTO zaj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Vunikalile mnzila behi na Damaski ikala kamba saa sita imisi, nidukila mwemwe kulawa kuulanga dimwemwesa kunizunguluka nie. ");
INSERT INTO zaj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nigwa hasi, abaho, nihulika dizwi donilongela, ‘Sauli, Sauli! Habali unigaza?’ ");
INSERT INTO zaj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Niuza, ‘Kwa nani gweye, Mndewa?’ Kedika kalonga, ‘Nie iyo Yesu wa Nazaleti ayo uyumgaza.’ ");
INSERT INTO zaj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Waja wayangu inikalile nao wajona idimwemwe, ila hawaditangile idizwi dikalile dilonga na nie dilawa ha munhu yalihi. ");
INSERT INTO zaj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Niuza, ‘Nitendeze, Mndewa?’ Na Mndewa kanilongela, ‘Gandamuka uchole Damaski, na haja kolongeligwa gaja gose gaulondigwa kutenda.’ ");
INSERT INTO zaj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Wayangu inikalile nao wanigoga mkono wanilongoza mbaka Damaski, kwavija unang'hazi wa idimwemwe unikoma gameso. ");
INSERT INTO zaj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Munhu imwe yokemigwa Anania keza kunilola. Kakala munhu wa Mulungu, yakalile yokala kamba vugalonda Malagizo, yakalile yohishimilwa ng'hani na Wayahudi wose wakalile wokala haja. ");
INSERT INTO zaj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Kema hamgwazo wangu na kulonga, ‘Ndugu yangu Sauli, ulole kabili!’ Na kipigiti kikija nilola kabili na nimona heyo. ");
INSERT INTO zaj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Abaho, kalonga, ‘Mulungu wa watata zetu kakusagula gweye ugatange goya goyolonda, na kumona Munhu Yalibule Uzenzeleganye, na kuhulika mbuli kulawa mmulomo wake. ");
INSERT INTO zaj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Gweye kowa msindila wake mwa wanhu wose mmbuli zino ziwonile na kuzihulika. ");
INSERT INTO zaj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Avo habali ukawa? Gandamuka ubatizigwe na uleke kutali vilozo vako. Mkutenda vino kodikema twaga da Mndewa.’ ");
INSERT INTO zaj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Vunibwelile Yelusalemu na kipigiti vunikalile nitambika Kung'anda ya Mulungu, mhata kigumbizi, ");
INSERT INTO zaj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","nimona Mndewa yolonga, ‘Hima, segela Yelusalemu mbwisa, kwavija hawautogole usindila wako wondaunilonge nie.’ ");
INSERT INTO zaj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nidika, nilonga, ‘Mndewa, wanhu wano wavimanya kamba nichola mzing'anda zose za nhambiko niwagela mkifungo na kuwasuna awo wakutogole gweye. ");
INSERT INTO zaj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na kipigiti mulopa wa msindila wako Stefano vuwitike, nikala bahaja nimile, kuno nideng'hela kija kitendeke na kugoga vivalo va awo wakalile womkoma.’ ");
INSERT INTO zaj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Abaho, Mndewa kanilongela, ‘Genda, kwavija nokugala kutali kuisi ya Wamhazi.’ ” ");
INSERT INTO zaj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Dija ididale da wanhu dimtegeleza Paulo mbaka viyalongile mbuli ino. Abaho, waguta nyangi wolonga “Yakomigwe! Halondigwa kugendelela kuwa mgima!” ");
INSERT INTO zaj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Na viwakalile woguta nyangi na kwasa vivalo vao na kwasa timbwisi uchana, ");
INSERT INTO zaj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ija imkulu wa madale gose ga asikali kalagiza Paulo yasoligwe, yengizigwe muingome. Kawalongela wamulanhe, abaho, wamuuze goya giladi wavimanye habali wanhu wakala wobwata kamba vino sama yake. ");
INSERT INTO zaj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Viwakalile womgolosa giladi wamulanhe, Paulo kamulongela ija imkulu wa asikali mia wa Loma yemile haja, “Vivo vilagizwe mweye mmulanhe mwenekae wa Loma hata kamba vilozo havoneke kumwake?” ");
INSERT INTO zaj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ija imkulu wa asikali mia wa Loma viyahulike vino, kachola ha ija imkulu wa madale gose ga asikali na kumulongela mbuli ino. Kamuuza, “Kotendaze? Kwavija munhu ino mwenekae wa Loma!” ");
INSERT INTO zaj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ija imkulu wa madale gose ga asikali kachola ha Paulo na kumuuza, “Nilongele, gweye kwa mwenekae wa Loma?” Paulo kedika, “Ona, nie na mwenekae wa Loma.” ");
INSERT INTO zaj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Abaho, ija imkulu kalonga, “Nie niliha hela bwando giladi nhogoligwe kuwa mwenekae wa Loma.” Paulo kedika, kalonga, “Ila nie mhata wenekae wa kuvumbuka Loma.” ");
INSERT INTO zaj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Waja wakalile wolonda kumuuzagiza, himahima wanyelenhuka. Ija imkulu, vivija kadumba, kwavija kavitanga kamba Paulo kakala mwenekae wa Loma na heyo kakala yamdazile na minyolo. ");
INSERT INTO zaj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Imitondo iyagwe, avija ija imkulu wa madale gose ga asikali viyalondile kukimanya kilamso cha Paulo kutagusigwa na Wayahudi, kamfungula na kulagiza wakulu wa wakulu wa nhambiko na wanhu wose wa Ikitala Kikulu cha Isi ya Wayahudi kuiting'hana. Abaho, kamgala Paulo hasi na kumwimiza haulongozi wao. ");
INSERT INTO zaj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo kawalola ng'hani wanhu wa Ikitala Kikulu cha Isi ya Wayahudi na kulonga, “Ndugu zangu, mazua gose nikala na udaho ung'alile wa kusambula gehile na ganogile haulongozi wa Mulungu mbaka zua da lelo.” ");
INSERT INTO zaj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Abaho, Mkulu wa Wakulu wose wa Nhambiko yokemigwa Anania kawashulutiza waja wakalile behi na Paulo, wamtoe kofi mmulomo. ");
INSERT INTO zaj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paulo kamulongela, “Mulungu kokusuna gweye, gweye ulingile kamba kiwambaza kibakigwe chokaa! Kukala aho unilamule nie kamba Malagizo ga Musa vugalonga, ila gweye mwenyego kogabemenda Malagizo ga Musa mkuwashulutiza wanhu wanitoe nie!” ");
INSERT INTO zaj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Awo wakalile wemile behi na Paulo walonga, “Komuliga Mkulu wa Wakulu wose wa Nhambiko yasaguligwe na Mulungu?” ");
INSERT INTO zaj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo kedika, kalonga, “Ndugu zangu, sivimanyile kamba heyo kakala Mkulu wa Wakulu wose wa Nhambiko, kwavija yandikigwa, ‘Sambiumulonge vihile mtawala wa wanhu zako.’ ” ");
INSERT INTO zaj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulo viyawene kamba wayagwe wakala Masadukayo na wayagwe wakala Mafalisayo, kenula dizwi muja Mkitala Kikulu cha Isi ya Wayahudi, yolonga, “Ndugu zangu, nie na Mfalisayo mwana wa Mafalisayo. Ningila mumgayo sama ya tamanilo jangu da kuzusigwa kwa wanhu wadanganhike.” ");
INSERT INTO zaj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Viyalongile gano, mbamila izuka hagatigati ya Mafalisayo na Masadukayo, avo mting'hano uigola. ");
INSERT INTO zaj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Masadukayo wolonga kamba haduhu kuzuka kwa wanhu wadanganhike na haduhu wasenga wa Mulungu wa kuulanga na haduhu loho, ila Mafalisayo wotogola gano gose. ");
INSERT INTO zaj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Kulawilila bwato kulu, na wafundiza Malagizo ga Musa wayagwe wakalile Mafalisayo wema na kubamila ng'hani, wolonga, “Hatonile mbuli yoyose ihile yaatendile munhu ino! Siku loho ama msenga wa Mulungu wa kuulanga kalonga na heyo!” ");
INSERT INTO zaj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Bwato dija dikula mbaka ija imkulu wa madale gose ga asikali kakala yodumba siku Paulo womdega vidangavidanga. Avo kawalagiza asikali zake wachole kudidale kumsola na mhiko kulawa hagatigati yao na kumwingiza mgati ya ingome. ");
INSERT INTO zaj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ikilo ija Mndewa kema behi yake na kumulongela, “Sambiudumbe! Kamba vuulavile usindila wangu kuja Yelusalemu, avo kolondigwa vivija uulave usindila mdiwambo da Loma.” ");
INSERT INTO zaj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Imitondo iyagwe Wayahudi wayagwe waiting'hana, na kwika zundo da kuifunga wenyego mkuiduila kamba hawaja ama kung'wa mbaka wamkome Paulo. ");
INSERT INTO zaj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Kukala na wanhu wabanzile malongo mane wekile zundo dino. ");
INSERT INTO zaj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Wachola ha wakulu wa wakulu wa nhambiko na wavyele na kulonga, “Tweye tuifunga wenyego mkuiduila sambituje ama kung'wa kinhu chochose mbaka tumkome Paulo. ");
INSERT INTO zaj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Avo mweye hamoja na Ikitala chose Kikulu cha Isi ya Wayahudi molondigwa mmulongele ija imkulu wa madale gose ga asikali yamgale Paulo haulongozi wenu, mkiitenda kamba molonda mkitange goya kilamso cha mbuli yake. Na tweye toisasala kumkoma kipigiti hanavika hano.” ");
INSERT INTO zaj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ila mwana wa lumbu jake Paulo viyahulike zundo dija, kengila muingome na kumulongela Paulo. ");
INSERT INTO zaj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Abaho, Paulo kamkema imwe wa iwakulu wa asikali mia wa Loma na kumulongela, “Msole mmhale ino umgale ha imkulu wa madale gose ga asikali, kana kinhu cha kumulongela.” ");
INSERT INTO zaj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ija imkulu wa asikali mia wa Loma kamsola kamgala ha ija imkulu wa madale gose ga asikali, kalonga, “Paulo, ija yageligwe mng'anda, kanikema na kunilongela nimgale mmhale ino kumwako, kana kinhu cha kukulongela.” ");
INSERT INTO zaj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ija imkulu wa madale gose ga asikali kamsola ija immhale mkumgoga mkono kamgala hamgwazo na kumuuza, “Kolonda kunilongela choni?” ");
INSERT INTO zaj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ija immhale kalonga, “Wakulu wa Wayahudi wailongela kamba, wakulongele gweye umgale Paulo haulongozi wa Ikitala Kikulu cha Isi ya Wayahudi mayo, na hewo wokiitenda kamba wolonda wakitange goya kilamso cha mbuli yake. ");
INSERT INTO zaj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ila sambiumgale kumwao kwavija wanhu kubanza malongo mane wom'beta mnzila wamkome mkumsinhukiza. Waiduila kamba hawaja, hawang'wa mbaka wamkome Paulo. Sambisambi woisasala wokubeta gweye uwatogolele gaja gawakupulile.” ");
INSERT INTO zaj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Avo ija imkulu wa madale gose ga asikali kamulongela, “sambiumulongele munhu yoyose kamba kunilongela mbuli ino.” Abaho, kamuleka yachole. ");
INSERT INTO zaj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Abaho, ija imkulu wa madale gose ga asikali, kawakema asikali zake wabili wakalile wakulu wa asikali mia wa Loma, kawalongela, “Ifunganyeni msegele saa ndatu ikilo mchole Kaisalia na asikali mia mbili, hamoja na asikali sabini wa falasi na asikali mia mbili wayagwe wa migoha. ");
INSERT INTO zaj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Vivija kalava falasi sama ya Paulo, giladi yasoligwe mditindiwalo yachole ha Feliksi, mtawala wa isi ya Yudea.” ");
INSERT INTO zaj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Kandika lupwilili luno, ");
INSERT INTO zaj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Nie Klaudio Lisiasi, ha mtawala wa Yudea Feliksi, nokulamsa. ");
INSERT INTO zaj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Munhu ino kakala yagogigwe na Wayahudi na wakala wolonda kumkoma. Ila niza na asikali zangu na kumkombola, kwavija nivimanya kamba munhu ino mwenekae wa Loma. ");
INSERT INTO zaj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nilonda kuvitanga kamba habali womtagusa, avo nimgala kuna Ikitala chao Kikulu cha Isi ya Wayahudi. ");
INSERT INTO zaj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nyona kamba kakala yataguswe sama ya Malagizo gao, ila hatendile kinhu chochose kilumbile heyo kudanganhika ama kugeligwa mkifungo. ");
INSERT INTO zaj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Vunilongeligwe kamba kowa na zundo da kumkoma munhu ino, nimgala kumwako himahima. Na niwashulutiza waja womtagusa vivija weze kusimulila hameso gako kija chowomtagusila.” ");
INSERT INTO zaj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Avo waja iwaasikali wamsola Paulo na kumgala Antipatili ikilo, kamba vija viwalongeligwe. ");
INSERT INTO zaj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Imitondo iyagwe wawaleka waja iwaasikali wa falasi wagendelele na Paulo, ila asikali wa magulu wabweleganya kuingome. ");
INSERT INTO zaj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Viwavikile Kaisalia, wamgwelela mndewa ulupwilili, na vivija wamwika Paulo mmakono gake. ");
INSERT INTO zaj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ija imndewa viyalusomile ulupwilili, kauza ng'ambu ilihi kuyakalile yolawa Paulo, na viyavimanyile kamba kakala yolawa Kilikia, ");
INSERT INTO zaj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","kalonga, “Noitegeleza mbuli yako kipigiti waja wokutagusa wahavika hano.” Abaho, kalagiza kamba Paulo yemilizwe mding'anda da Helode. ");
INSERT INTO zaj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Vugabitile mazua matano, Mkulu wa Wakulu wose wa Nhambiko yokemigwa Anania, keza Kaisalia hamoja na wavyele wayagwe na munhu yagatangile goya malagizo yokemigwa Tatulo. Wagala mbuli yao womtagusa Paulo ha mndewa. ");
INSERT INTO zaj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Paulo viyakemigwe, Tatulo kasonga kumtagusa. “Mkulu Feliksi, tukala tudeng'hela tindiwalo mkipigiti kitali muundewa wako na udaho wako wa kulola kutali kugala ugaluko muisi ino. ");
INSERT INTO zaj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Toibokela mbuli ino kila hanhu na mkipigiti chose na tokuheweza ng'hani. ");
INSERT INTO zaj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ila giladi sambinikudonheze ng'hani, nokuyalalila kamba utwazaganye, ututegeleze goya. ");
INSERT INTO zaj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Munhu ino koneka iyo msongeza ndwagi, kosongeza mzahimzahi mwa Wayahudi muulumwengu wose. Heyo iyo kilangizi wa mbaguko ya Wanazaleti. ");
INSERT INTO zaj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Na vivija kainyolodosa Ing'anda ya Mulungu, avo tumgoga. ");
INSERT INTO zaj_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ila Lisiasi, ija imkulu wa madale gose ga asikali, keza na mhiko ng'hulu, kamsola kulawa mmakono getu, kuno yowashulutiza waja womtagusa, weze kumwako gweye. ");
INSERT INTO zaj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Uhamuuzagiza goya, gweye mwenyego kozimanya mbuli zose zitumtagusile kulawa kumwake.” ");
INSERT INTO zaj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Na Wayahudi vivija wailumba hamoja mnhaguso ija, wosindila kamba mbuli zino zose za kweli. ");
INSERT INTO zaj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Mndewa viyamulingile kidole Paulo giladi yalonge, Paulo kalonga, “Novimanya kamba gweye kwa mulamula muisi ino mmilao bwando, avo mkudeng'ha noigombeleza. ");
INSERT INTO zaj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Gweye kuvitanga kamba mazua longo dimwe na mabili gabitile, nichola Yelusalemu kutambika. ");
INSERT INTO zaj_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Wanhu wonitagusa hawanivikile nie niibamilila na munhu yoyose Kung'anda ya Mulungu ama niwading'hula wanhu mng'anda ya nhambiko ama hanhu hohose mdiwambo. ");
INSERT INTO zaj_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Na hawadaha kulagusa kamba mbuli zowonitagusila nie kumwako sambisambi kamba za kweli. ");
INSERT INTO zaj_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ila nie notogola kamba nomtambikila Mulungu wa tata zetu kamba imwe wa wanhu wa Nzila ija hewo iwoikema mbaguko. Notogola vinhu vose vitogolwa na Malagizo na vija vandikwe na wahokozi. ");
INSERT INTO zaj_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nhamanila inilinayo ha Mulungu ilinga na nhamanila iwalinayo hewo wenyego, notogola kamba kuna mzuso wa wanhu wa namna mbili, walekile kuwa vizenzeleganye na awo wali vizenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Avo mazua gose noiyoha kutenda udaho wangu wa kusambula gehile na ganogile ung'ale haulongozi wa Mulungu na haulongozi wa wanhu. ");
INSERT INTO zaj_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Vunikalile haduhu mkipigiti cha milao bwando, nichola Yelusalemu kuwagwelela nhunza wanhu zangu na kulava nhosa. ");
INSERT INTO zaj_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kipigiti vunikalile nitenda gano, wanivika Kung'anda ya Mulungu nimambukiza nzoela ya kuing'aliza. Hakukalile na dale da wanhu ama hebohebo. ");
INSERT INTO zaj_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ila kukala na Wayahudi kulawa muisi ya Asia awo wolondigwa kwiza hano haulongozi wako wagale nhaguso zao kamba wana mbuli yoyose ya kunitagusila. ");
INSERT INTO zaj_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ama wano wali hano wenyego na walonge mbuli ilihi ihile iwayonile kumwangu, kipigiti vunikalile nimile haulongozi wa Ikitala Kikulu cha Isi ya Wayahudi. ");
INSERT INTO zaj_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ila kinhu kimwe kinilongile na dizwi kulu vunikalile haulongozi wao, ‘na kinhu hicho kikala mbuli ya kuzuka kwa wanhu wadanganhike ayo inigwelele mbuli mbaka nima haulongozi wako lelo.’ ” ");
INSERT INTO zaj_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Abaho, Feliksi yakalile yalongeligwe goya mbuli za Nzila ija, kaukomeleza umting'hano uja mkulonga, “Kipigiti Lisiasi mkulu wa madale gose ga asikali yeheza, noilamula mbuli yenu.” ");
INSERT INTO zaj_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Abaho, kamulagiza asikali, mkulu wa asikali mia wa Loma, yamwike Paulo hasi ya wimilizi, ila yagweleligwe ulegeho kidogo na kuwaleka wambwiga zake wamgwelele vinhu voyolonda. ");
INSERT INTO zaj_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Mazua madodo hamwande Feliksi keza na mtwanzi wake yokemigwa Dulusila, yakalile Muyahudi. Kamkema Paulo, wamtegeleza viyakalile yoilonga vija vowolondigwa kumtogola Kilisto Yesu. ");
INSERT INTO zaj_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Paulo viyalongelele nawo yopeta kuleka uzenzeleganye, na kuinega na vinhu viyagomese Mulungu, na nhaguso yondaize, Feliksi kadumba na kulonga, “Basi segela sambiugendelele, nihapata nafasi nokukema.” ");
INSERT INTO zaj_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ila munda kwa munda kakala yotamanila kamba, siku Paulo komgwelela hongo. Avo kamkema mianza bwando na kulongelela nayo. ");
INSERT INTO zaj_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Vuibitile milao mibili, Polikio Festo kasaguligwa kusola hanhu ha Feliksi na kuwa mtawala wa Yudea. Ila kwavija Feliksi kalonda yanogelwe na Wayahudi, kamuleka Paulo mkifungo. ");
INSERT INTO zaj_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Vigabitile mazua madatu songela Festo viyavikile muisi ya Kaisalia, kafunga mwanza kulawa haja kachola Yelusalemu, ");
INSERT INTO zaj_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ako wakulu wa wakulu wa nhambiko na wakulu wa Wayahudi wamcholela na kumtagusa Paulo kumwake. ");
INSERT INTO zaj_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Wamuyalalila Festo yawataze kumgala Paulo Yelusalemu, kwavija hewo waisasala kum'vamhila na kumkoma Paulo kipigiti yang'hali mnzila. ");
INSERT INTO zaj_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Avo Festo kedika, “Paulo kokwimilizwa ako Kaisalia, na nie mkipigiti kiguhi nochola hiko. ");
INSERT INTO zaj_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Walekeni wakulu zenu wayagwe wachole na nie Kaisalia, na kamba katenda kinhu chochose kihile, wamtaguse.” ");
INSERT INTO zaj_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festo kakala hamoja na hewo kamba mmazua manane ama longo dimwe, abaho, kachola Kaisalia. Zua diyagwe kakala mkigoda cha nhaguso mkitala, abaho, kalagiza Paulo yagaligwe. ");
INSERT INTO zaj_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paulo viyavikile, Wayahudi walawile Yelusalemu wamzunguluka, wasonga kumtagusa nhaguso bwando ng'hulung'hulu azo zilekile kulagusa kweli mgati yake. ");
INSERT INTO zaj_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulo mkuigombela, kalonga, “Nie sitendile chochose kihile Mmalagizo ga Wayahudi, ama Kung'anda ya Mulungu, ama ha Kaisali.” ");
INSERT INTO zaj_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ila Festo kuno yolonda kuwataza Wayahudi, kamulongela Paulo, “Kolonda kuchola Yelusalemu, ako ukataguswe mzimbuli zino haulongozi wangu?” ");
INSERT INTO zaj_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo kedika, kalonga, “Nie nokwima hano haulongozi wa ikitala cha Kaisali, hano hanilondigwa kutaguswa. Kamba vija mweye wenyego vumuvitangile goya kamba siwatendele Wayahudi mbuli yoyose ihile. ");
INSERT INTO zaj_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Avo kamba nyoneka kamba nitenda mbuli ihile ilumbile nie kudanganhika, sidaha kuikimbila ifa. Ila, kamba nhaguso iwanitaguse Wayahudi wano ihawa ya uvwizi, haduhu munhu yondayanigele mmakono gao. Noigala kumwande mbuli ino ha Kaisali.” ");
INSERT INTO zaj_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Avo Festo, viyeshile kulongelela na wanhu wa ikitala, kamwidika Paulo, kalonga, “Kuigala kumwande mbuli yako ha Kaisali, avo uchole ha Kaisali.” ");
INSERT INTO zaj_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Vigabitile mazua madodo, Mndewa Agilipa na Benike wavika Kaisalia kumulamsa Festo. ");
INSERT INTO zaj_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Na viwakalile hiko mazua bwando, Festo kamsimulila Mndewa Agilipa mbuli ya nhaguso ya Paulo, kalonga, “Hano hana munhu yalekigwe mkifungo na Feliksi. ");
INSERT INTO zaj_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Vinyholile Yelusalemu, wakulu wa wakulu wa nhambiko na wavyele wa Wayahudi wamtagusa kumwangu, na waniyalalila nimtaguse na kusunigwa. ");
INSERT INTO zaj_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ila nie niwalongela kamba, vino sio viwatendaga Waloma, kumgela mmakono ga wanhu munhu yatagusigwe ihawa yang'hali hanaiting'hana na wanhu wamtaguse meso kwa meso, na kulondigwa yaigombele mzimbuli zoyotagusigwa. ");
INSERT INTO zaj_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Avo viwaiting'hane hano, nie siikawize imbuli, ila imitondo iyagwe nikala mkigoda cha nhaguso na kulagiza munhu hiyo yagaligwe. ");
INSERT INTO zaj_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Wanhu wamtaguse viwemile, hawalavile nhaguso yoyose ihile kamba vinigesile. ");
INSERT INTO zaj_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ila mbuli iwakalile nayo ikala kuibamilila mmbuli za nhamanila yao wenyego, na mmbuli ya munhu imwe yadanganhike yokemigwa Yesu ayo Paulo yaamulongile mgima. ");
INSERT INTO zaj_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Sivitangile vija vondaniipate ikweli ya mbuli ino, avo nimulongela Paulo kamba kotogola kuchola Yelusalemu yakatagusiligwe kuja mmbuli ino. ");
INSERT INTO zaj_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ila Paulo kaigala kumwande mbuli ino, kapula yekigwe mkifungo na mbuli yake ilamuligwe na Kaisali. Avo nilagiza yakale mkifungo mbaka vondanimgale ha Kaisali.” ");
INSERT INTO zaj_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agilipa kamulongela Festo, “Nolonda nimuhulike munhu ino nene mwenyego.” Festo kamwidika, kalonga, “Mayo, komuhulika.” ");
INSERT INTO zaj_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Imitondo iyagwe Agilipa na Benike weza na ndeng'ho ng'hulu, wengila mdigati da mting'hano kuno wailongoze na wakulu wa wemilizi na wakulu wa idiwambo. Abaho, Festo kalagiza Paulo yagaligwe. ");
INSERT INTO zaj_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festo kalonga, “Mndewa Agilipa na wanhu wose muli hano hamoja na tweye, mmona munhu ino. Wayahudi wose wa ako Yelusalemu na Wayahudi wa hano waniyalalila na kuguta nyangi kamba munhu ino halondigwa kuwa mgima. ");
INSERT INTO zaj_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ila nie siyonile mbuli yoyose ihile yaatendile ilumbile heyo kukomigwa. Ila kwavija heyo mwenyego kalonda nhaguso yake igaligwe hamwande itegelezwe na Kaisali, na nie nilamula kumgala. ");
INSERT INTO zaj_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ila mmbuli ya munhu ino, nie nabule cha kumwandikila Kaisali. Avo nimgala hano haulongozi wenu mweye mose na ng'haning'hani haulongozi wako gweye Mndewa Agilipa, avo tuhesha kumuuzagiza, nipate mbuli ya kwandika. ");
INSERT INTO zaj_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kwavija havilumbile kumgala mfungigwa bila kulagusa nhaguso yake yootagusigwa.” ");
INSERT INTO zaj_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agilipa kamulongela Paulo, “Kotogozigwa kuigombela.” Avo Paulo kagolosa mkono wake na kusonga kuigombela yolonga vino. ");
INSERT INTO zaj_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Mndewa Agilipa! Nokiyona munhu yali na mhome inogile mdizua da lelo kwima haulongozi wako na kuigombela sama ya mbuli zose zinitagusigwe na Wayahudi. ");
INSERT INTO zaj_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Hasa kwavija gweye kozitanga goya nzoela za Wayahudi na mbamila zao, avo nokuyalalila unhegeleze mkunyazaganya. ");
INSERT INTO zaj_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Wayahudi wose wautanga ukazi wangu songela ving'halile mmhale, songela ha umwanduso wa ugima wangu muisi yangu mwenyego na vivija kuja Yelusalemu. ");
INSERT INTO zaj_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Wonitanga mkipigiti kitali, na kamba wahalonda wodaha kulava usindila, kamba songela haichanduso nikala imwe wa wanhu waigogile ng'hani nhamanila yetu, nikala Mfalisayo. ");
INSERT INTO zaj_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Na sambi nima hano lelo notaguswa sama ya nhamanila yangu Mulungu yaailagane na wahenga zetu. ");
INSERT INTO zaj_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Kino kicho kilagano kitamanilwe koneka na mitala yetu longo dimwe na mibili kivikile, kileka mana womtambikila Mulungu misi na kilo na nhamanila ng'hulu. Avo mndewa, Wayahudi wonhagusa sama ya nhamanila ino. ");
INSERT INTO zaj_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Habali mweye hamdaha kutogola kamba Mulungu kowazusa wanhu wadanganhike? ");
INSERT INTO zaj_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Vivija na nie niswagizigwa mmoyo wangu kamba nolondigwa kutenda gose kamba vunidahile kudilema twaga da Yesu wa Nazaleti. ");
INSERT INTO zaj_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Vino vivo nitendile kuja Yelusalemu. Nibokela udaho kulawa ha wakulu wa wakulu wa nhambiko, na niwagela mkifungo wanhu bwando wa Mulungu. Na viwatagusigwe kudanganhika, nie vivija nigongomela. ");
INSERT INTO zaj_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mianza bwando nichola kuna zing'anda za nhambiko kuwagaza, na niwashulutiza wailonge nhamanila ino mbuli za ufukuzi. Nikala niwehile ng'hani, hata nichola kuna imiwambo ya isi ziyagwe kuwagaza. ");
INSERT INTO zaj_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Sama ya mbuli ino nichola Damaski, kuno nili na udaho na ndagizi kulawa ha wakulu wa wakulu wa nhambiko. ");
INSERT INTO zaj_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mndewa, mkipigiti cha imisi vinikalile mnzila, nyona mulangaza kulawa kuulanga, umwemwesa kubanza mulangaza wa zua, unizunguluka nie hamoja na waja wakalile mmwanza umwe na nie. ");
INSERT INTO zaj_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tweye tose tulagala hasi, na nihulika dizwi dinilongela muulonzi wa Kieblania, ‘Sauli, Sauli, habali unigaza? Koilumiza mwenyego kuzibweza kuchugu mbuli zangu kamba ng'ombe yoibwelezela kuitoa teke fimbo ya munhu yomchunga.’ ");
INSERT INTO zaj_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Na nie nimuuza, ‘Mndewa, gweye iyo yalihi?’ Na Mndewa kedika, ‘Nie iyo Yesu, gweye umgaza. ");
INSERT INTO zaj_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ila gandamuka wime na magulu gako, kwavija nikulawilila gweye nikusagule uwe mtumigwa wangu na msindila wa mbuli zangu ziuwene na zija zondanikulagusile. ");
INSERT INTO zaj_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nokukombola kulawa mmakono ga wanhu wa Islaeli na mmakono ga Wamhazi ha awo kondanikugale. ");
INSERT INTO zaj_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ukawavugule meso gao giladi wahinduke kulawa mdiziza, wagalukile kuna umulangaza na kulawa mmhiko za Mwenembago na kumgalukila Mulungu, giladi vilozo vao vigeligwe kumgongo na wagweleligwe hanhu hawali awo wang'alizwe mkunitamanila nie.’ ");
INSERT INTO zaj_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Avo, Mndewa Agilipa, nie siidulukile bule nzozi ija ilawile kuulanga. ");
INSERT INTO zaj_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ila tanhu nisonga kuwapetela wanhu wa Damaski, abaho, wanhu wa Yelusalemu na muisi yose ya Yudea, vivija na ha Wamhazi. Niwapetela kamba waleke vilozo vao na wam'bwelele Mulungu, na sang'hano zao zizo zondazilaguse kamba waleka vilozo vao. ");
INSERT INTO zaj_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Sama ya mbuli ino, Wayahudi wangoga Kung'anda ya Mulungu, na walonda kung'homa. ");
INSERT INTO zaj_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ila Mulungu kangombeleza kileka mana nili mgima mbaka zua da lelo, na avo nima hano kuulava usindila wangu ha wanhu wadodo na wakulu. Kinhu kinilonga kilinga na kija kiyalongile Musa na wahokozi kamba chokwiza kulawilila, ");
INSERT INTO zaj_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","kamba Kilisto kolondigwa tanhu yagaye na yawe wa mwanduso kuzuka kulawa mkudanganhika, giladi yaupete mulangaza wa ukombola ha wanhu zake mwenyego na ha Wamhazi.” ");
INSERT INTO zaj_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulo viyakalile yogendelela kuigombela, Festo kadang'hila, kabwata yolonga, “Paulo, kuna moyo! Kusoma ng'hani kuusomile kukugela kibozi!” ");
INSERT INTO zaj_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ila Paulo kedika, “Nabule kibozi, Mndewa! Ila nolonga kinhu cha kweli, kuno nili na nzonzi zangu. ");
INSERT INTO zaj_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kwavija Mndewa Agilipa, kuzitanga mbuli zino, na nie nodaha kulonga bila kudumba, kwavija novitanga kamba haduhu hata mbuli imwe mzimbuli hizo iulekile kuitanga, kwavija mbuli ino haitendeke mkifiso. ");
INSERT INTO zaj_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mndewa Agilipa, vino, kowatogola wahokozi wa umwaka? Novitanga kamba kowatogola.” ");
INSERT INTO zaj_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agilipa kamulongela Paulo, “Kokwagiza kamba mkipigiti kino kiguhi kodaha kunitenda nie nimtogole Kilisto?” ");
INSERT INTO zaj_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulo kamwidika, “Kiwe kipigiti kiguhi ama kitali, ila nomtambikila Mulungu kamba sio gweye wiyeka, ila hata waja wose wonitegeleza nie lelo wagaluke wawe kamba vunili nie, ila sambiwafungilizwe minyolo ino.” ");
INSERT INTO zaj_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Abaho, Mndewa Agilipa, mkulu wa ikiwambo, Benike, na waja wose wakalile hamoja nao wema. ");
INSERT INTO zaj_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Viwacholile, wailongela, “Munhu ino hatendile mbuli yoyose ihile ya kumtenda yatagusigwe ifa ama kugeligwa mkifungo.” ");
INSERT INTO zaj_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agilipa kamulongela Festo, “Munhu ino yahalekesigwe kamba yahalekile kuigala hamwande mbuli yake ha Kaisali.” ");
INSERT INTO zaj_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Viwalamule kamba tukwele meli tuchole mbaka Italia, Paulo hamoja na wafungigwa wayage wageligwa mmakono ga Yulio yakalile mkulu wa asikali mia wa Loma, yakalile yalawile mdidale da Asikali wa Mndewa wa Loma. ");
INSERT INTO zaj_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tukwela muimeli kulawa Adulamiti, ikalile ichola kuna zibandali za isi ya Asia, tuchola. Alistaliko, munhu wa isi ya Makedonia kulawa Tesalonike, kakala hamoja na tweye. ");
INSERT INTO zaj_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Imitondo iyagwe tuvika Sidoni. Yulio kamtendela ganogile Paulo, kamtogolela yachole kuwalola wambwiga zake, wakamgwelele vinhu viyalondile. ");
INSERT INTO zaj_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kulawa hiko tugendelela na mwanza, na kwavija beho dikala dobuma diisung'hiza imeli kuchugu, avo tubita ng'ambu iyagwe ya ikisiwa cha Sipulo ikalile bule beho. ");
INSERT INTO zaj_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Na vituikanhize ibahali ya isi za Kilikia na Pamfilia, tuvika mkiwambo cha Mila, muisi ya Likia. ");
INSERT INTO zaj_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Na ako mkulu ija wa asikali mia wa Loma kaivika meli ya Alekizandalia ikalile ichola Italia, avo katukweleza himo. ");
INSERT INTO zaj_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tugendelela na mwanza mholemhole mmazua bwando na mkuigagahiza ng'hani, tuvika mkiwambo cha Nido, na kwavija beho dituzuila sambitugendelele na mwanza kuna ing'ambu ija, avo tuchola kubitila ng'ambu ya kisiwa cha Kilete behi na Lasi ya Salimone, kukalile bule beho. ");
INSERT INTO zaj_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Tuigagahiza kubita muimhwani ya Kilete tuvika hanhu hokemigwa Bandali Iholile behi na kiwambo cha Lasea. ");
INSERT INTO zaj_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kipigiti kitali kibita, na mwanza ukala wodumbiza ng'hani kwavija Mazua ga Kufunga gakala gabitile, avo Paulo kawalongela vino, ");
INSERT INTO zaj_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Ndugu, nokona mwanza uno wodumbiza na wokwagiza vinhu bwando. Na si kwagiza mizigo na imeli iiyeka, ila vivija hata kwagiza ugima wetu.” ");
INSERT INTO zaj_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ila mkulu ija wa asikali mia wa Loma, hagategeleze gaja gayamulongele Paulo, ila kagategeleza gaja gayakalile yolonga ija yakalile yoilongoza imeli na ija mwene imeli. ");
INSERT INTO zaj_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Avija bandali ija viikalile hainogile mkipigiti cha kihuhe, wanhu bwando mmwanza wao walamula kugendelela na mwanza wavike Foinike giladi wakale haja mkipigiti cha kihuhe. Ino ikala bandali ya Kilete, ilola hagatigati ya kusi na uswelo wa zua, na hagatigati ya kasikazi na uswelo wa zua. ");
INSERT INTO zaj_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Beho da ng'ambu ya kusi vudisongile kubuma mholemhole, waja wanhu wagiza kamba wamhisa kiwalondile. Avo waing'ola inanga na kuchola wobitila mumgwazogwazo wa ibahali ya Kilete. ");
INSERT INTO zaj_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ila vikikalile hakinabita kipigiti kitali, kukuzumbi dikemigwa “Kukuzumbi da Hagatigati ya Kasikazi na Ulawilo wa Zua” diza kulawa mkisiwa. ");
INSERT INTO zaj_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Meli isoligwa na dikukuzumbi na havidahike kuilongoza kudikalile dilawa dikukuzumbi, avo tuileka na kukwekwesigwa na dikukuzumbi. ");
INSERT INTO zaj_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Vitubitile ng'ambu ilibule kukuzumbi ya kisiwa kidodo kikemigwa Kauda, tugaya ng'hani kudaha kuileweleza ingalawa ikalile ifungigwe na kukwenhigwa na imeli kuchugu. ");
INSERT INTO zaj_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Viwaingize ingalawa muna imeli, wazibitiza nzabi hasi ya imeli na kuifunga imeli hamoja nganganga. Wodumba sambiwanamate mdifumvugulu da misenga kuna imhwani ya isi ya Libia, avo wagahumulusa matanga, na kuileka imeli isoligwe na ubeho. ");
INSERT INTO zaj_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kukuzumbi dija digendelela, avo imitondo iyagwe, wasonga kwasa mmazi imizigo ibanzile mmeli. ");
INSERT INTO zaj_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Na zua da ikadatu wasonga kwasa via va imeli vibanzile na makono gao wenyego. ");
INSERT INTO zaj_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Mkipigiti cha mazua bwando, hatonile zua ama nhondo, na kukuzumbi digendelela kubuma ng'hani. Hakimambukizo, nhamanila ya tweye kukomboligwa ipotela. ");
INSERT INTO zaj_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Avija wanhu viwakalile kipigiti kitali bila kuja kinhu, Paulo kema haulongozi wao kalonga, “Mweye wanhu, muhagategeleze gaja ganongile, kamba sambitusegele kulawa haja Kilete, ubananzi uno na hasala ino sambivituvike. ");
INSERT INTO zaj_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ila sambi nowayalalila, gangamaleni! Kwavija haduhu hata munhu imwe mmwanza wenu yondayadanganhike, ila meli iiyeka iyo yondaibanangike. ");
INSERT INTO zaj_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kwavija ikilo ya lelo msenga wa Mulungu wa kuulanga, ayo nie nili munhu wake, na ayo inimtambikila na kumsang'hanikila, kakala yemile behi na nie, ");
INSERT INTO zaj_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","kalonga, ‘Paulo, sambiudumbe, kolondigwa wime haulongozi wa Kaisali. Mulungu muunozi wake kowimiliza ugima wako gweye na awo wose uuchola nao.’ ");
INSERT INTO zaj_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Avo, ndugu zangu, mgangamale! Kwavija nie nna nhamanila ha Mulungu kamba gano gayanilongele golawilila kamba viyanilongele. ");
INSERT INTO zaj_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ila tochola kunamata kuna imhwani ya ikisiwa kimwe.” ");
INSERT INTO zaj_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Muikilo ya longo dimwe na nne, tukala tung'hali tukwekwesigwa muna Ibahali ya Meditelania. Behi na kilo kikulu walosaji wavimanya kamba wakala wali behi na isi inyalile. ");
INSERT INTO zaj_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Wahumulusa luzabi hasi lufungigwe kinhu kizamile na kona kamba mazi gakala na utali wa meta malongo mane. Mkipigiti kidodo wabwelela mwanza uyagwe na kona kamba mazi gakala na utali wa meta malongo madatu. ");
INSERT INTO zaj_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kwavija wadumba meli sambiikibwengeze mgamabwe, avo wahumulusa nanga nne kukisogo cha imeli, abaho, watambika giladi imitondo ivike. ");
INSERT INTO zaj_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Na walosaji viwalondile kunyelenhuka kulawa muimeli, waihumulusa ingalawa m'bahali, wokiitenda wozihumulusa zinanga kulawa kuulongozi wa imeli, ");
INSERT INTO zaj_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Paulo kamulongela ija imkulu wa asikali mia wa Loma na asikali zake, “Kamba wanhu wano hawakalile muna imeli, hamkomboligwa.” ");
INSERT INTO zaj_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Avo waja iwaasikali wazikanha zinzabi za ingalawa, abaho, waileka ichole. ");
INSERT INTO zaj_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Viikalile behi na imitondo, Paulo kawagong'ondeza wose waje mandia. Kalonga, “Lelo zua da longo dimwe na nne mkala mkiyahiyahi na mkala bila mandia, hamdile kinhu chochose. ");
INSERT INTO zaj_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Avo nowalongela, mje mandia giladi mgendelele kuwa wagima, kwavija haduhu hata munhu imwe mmwanza wenu yondayagize luvili lwake kulawa mpala jake.” ");
INSERT INTO zaj_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Viyamambukize kulonga gano, Paulo kausola mkate, kamgwelela Mulungu hewela haulongozi wao wose, kaumogola, na kasonga kuja. ");
INSERT INTO zaj_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Wose wagangamizwa, na waja mandia wawo wenyego. ");
INSERT INTO zaj_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Mheta ya wanhu wose tukalile mmeli ikala wanhu mia mbili na malongo saba na sita. ");
INSERT INTO zaj_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Viweshile kuja na kwiguta, wasonga kuhunguza mibahasha ya ngano kulawa muna imeli na kuyasa m'bahali. ");
INSERT INTO zaj_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Viivikile imitondo, hawaitangile isi ija, ila wona mhwani ili na msanga unogile, aho hawalamule kuigala imeli, kamba vihadahike. ");
INSERT INTO zaj_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Avo wazikanha zinanga na kuzileka m'bahali, na kuzifungula zinzabi zikalile zitatilizwe muna uusukani, na kwika tanga dimwe haulongozi giladi beho diikwekwese imeli kuulongozi, wachole kuna iisi inyalile. ");
INSERT INTO zaj_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ila ija imeli ingila mdifumvugulu da misenga na kudidimila mmisenga. Ng'ambu ya kuulongozi wa imeli inamata na haidahile kukwenhuka, na ng'ambu ya kuchugu ikala ibeneke vidangavidanga sama ya kisindo cha mawimbi. ");
INSERT INTO zaj_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Waja iwaasikali walonda kuwakoma wafungigwa wose, giladi sambiwakogelele na kukimbila. ");
INSERT INTO zaj_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ila kwavija ija imkulu wa asikali mia wa Loma kalonda kumuhonya Paulo, kawagomesa sambiwatende hivo. Avo kawalagiza waja wose wadahile kogelela wazumhe kulawa muna imeli, wachole kuisi inyalile. ");
INSERT INTO zaj_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Na wose wayagwe wasigale, wachole kuja m'vidanga va mbao ama vidanga vibeneke va imeli. Mkutenda vino wanhu wose tuvika goya muisi inyalile. ");
INSERT INTO zaj_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Vituvikile mhwani tuli wagima, tuvimanya kamba kija ikisiwa kikala kikemigwa Malita. ");
INSERT INTO zaj_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Tukanganya kwavija wanhu wa haja watutendela ganogile ng'hani. Wabwinha moto na kutulongela tweye tose twote, kwavija kukala na beho na mvula ikala isonga kutoa. ");
INSERT INTO zaj_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulo kakala yodondola ngodi na kuzigela hamoto, nyoka yali na sumu viyapatile zimbumoto kakimbila kulawa mzingodi na kamulumiza na kuninila mumkono wake. ");
INSERT INTO zaj_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Wanhu wa ikisiwa kija viwamonile nyoka yoninila mumkono wake, wailongela, “Kwa vovose munhu ino kowa mkoma wanhu. Hata kamba kakomboligwa kulawa m'bahali, mulungu wetu wa kitwanzi yokemigwa Haki haumuleka yawe mgima.” ");
INSERT INTO zaj_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ila Paulo kamkung'unhila hamoto ija inyoka na hamulumize hanhu. ");
INSERT INTO zaj_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Wanhu wagelegeza kamba kolulumuka ama yahalagale hasi chanyoya na kudanganhika. Ila viwabetile mkipigiti kitali na kuleka kona kinhu chochose kimulawilile, avo wagaluka na kulonga kamba heyo kakala mulungu. ");
INSERT INTO zaj_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Behi na haja kukala na mgunda wa mkulu imwe wa kisiwa kija yakemigwe Publio. Katubokela goya na kutugala kumwake, na mkipigiti cha mazua madatu, katutendela ganogile ng'hani. ");
INSERT INTO zaj_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tataake Publio kakala mtamu wa homa na kuhala, avo kawasa mulusazi. Paulo kachola kumulola, kamtambikila, kamwikila makono gake na kamuhonya. ");
INSERT INTO zaj_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Vugalawilile gano, vivija watamu wose wasigale mkisiwa kija weza na kuhonyigwa. ");
INSERT INTO zaj_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Watugwelela vinhu bwando, na vitulondile kuchola, wengiza mmeli vinhu vose vitulondile mmwanza. ");
INSERT INTO zaj_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Viibitile milenge midatu, tusonga mwanza na meli ya wambo da Alekizandalia ikemigwe, “Miungu Ubasa.” Meli ikalile hakisiwa kija mkipigiti chose cha kihuhe. ");
INSERT INTO zaj_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Tuvika mdiwambo da Salakusa, tukala haja mazua madatu. ");
INSERT INTO zaj_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Na kulawa haja, tugendelela na mwanza na kuvika mdiwambo da Lejimu. Na imitondo iyagwe beho disonga kubuma kulawa kusi, na mmazua mabili tuvika mkiwambo kikemigwa Puteoli. ");
INSERT INTO zaj_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Haja tuwavika wanhu wamtogole Kilisto, awo watulondile tukale na hewo mazua saba, na, abaho, tuvika Loma. ");
INSERT INTO zaj_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Na wanhu wamtogole Kilisto wakalile haja viwahulike kamba tokwiza, wafunga mwanza mtali, wavika Kudisoko da Apio na Ng'anda Ndatu za Kuwasa Wahenza. Paulo viyawawene, kamgwaa Mulungu hewela na kagangamizwa. ");
INSERT INTO zaj_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Vituvikile mdiwambo da Loma, Paulo katogolelwa kukala yeiyeka na asikali yakalile yomwimiliza. ");
INSERT INTO zaj_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Vigabitile mazua madatu, Paulo kawakema hamoja wakulu wa Wayahudi. Viwaiting'hane hamoja, kawalongela, “Ndugu zangu, hata kamba sitendile kinhu chochose kihile mwa wanhu ama mnzoela za wahenga zetu, nigogigwa kuja Yelusalemu na kugeligwa mmakono ga Waloma. ");
INSERT INTO zaj_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Viweshile kuniuzagiza, walonda kunilekesa, kwavija hayoneke mbuli yoyose ihile ilumbile nie kutagusigwa ifa. ");
INSERT INTO zaj_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ila Wayahudi viwailemile mbuli ino, nishulutizwa kuigala mbuli yangu ha Kaisali. Hata kamba nikala bule nhaguso ya kuwatagusa wanhu wa isi yangu. ");
INSERT INTO zaj_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Mkilamso kino, niwakema mweye giladi niwalongele mweye ikweli ya mbuli ino kamba, nifungigwa na mnyolo kamba vino, sama ya acho wanhu wa Islaeli chowokitamanila.” ");
INSERT INTO zaj_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Na hewo wamulongela, “Tweye hatubokele lupwilili lolose kulawa Yudea lulonga mbuli zako, na haduhu hata munhu imwe kulawa mwa wandugu zetu Wayahudi yezile hano kulonga mbuli yako yoyose, ama kukulonga gweye vihile. ");
INSERT INTO zaj_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ila tolonda kuhulika kulawa kumwako vija vuugelegeza, kwavija tweye tovitanga kamba kila hanhu, wanhu woilonga vihile nhamanila ino.” ");
INSERT INTO zaj_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Viwasagule zua da kuiting'hana nayo, wanhu bwando wamwizila hana ing'anda yaakalile yokala. Kusongela imitondo mbaka ichungulo, Paulo kawalongela na kuwapetela mbuli za Undewa wa Mulungu na kuwagong'ondeza mbuli za Yesu Kilisto muna Gamalagizo ga Musa na kulawa mmbuli za wahokozi. ");
INSERT INTO zaj_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Wanhu wayagwe wagatogola gaja gayakalile yolonga, ila wayagwe hawagatogole. ");
INSERT INTO zaj_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Avo waibamilila wenyego kwa wenyego, na viwakalile wosegela, Paulo kakomeleza mkulonga ulonzi uno, “Loho wa Mulungu kawalongela ikweli ahaja hayawalongele wahenga zenu kubitila muhokozi Isaya, ");
INSERT INTO zaj_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","kalonga, ‘Genda ukawalongele wanhu wano, kuhulika mohulika, ila ham'vitanga, kulola molola, ila ham'vimanya. ");
INSERT INTO zaj_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kwavija wanhu wano wana mioyo midala, magwiti gao wagatenda sambigahulike, na meso gao wafing'hiliza. Ila kamba meso gao gahalolile, na magwiti gao gahahulike, wahavitangile mmioyo yao, na kunihindukila nie, nihawahonyile.’ ” ");
INSERT INTO zaj_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Avo nolonda m'vitange kamba, ukombola wa Mulungu ugaligwa ha Wamhazi. Na hewo wohulika!” ");
INSERT INTO zaj_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Paulo viyeshile kulonga gano, Wayahudi wachola kuno wokiiuza mbuli bwando wenyego kwa wenyego. ");
INSERT INTO zaj_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Mkipigiti cha milao mibili yose, Paulo kakala muna ing'anda yaapangile mwenyego, na kawabokela wanhu wose wezile kumulola. ");
INSERT INTO zaj_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Kazipeta mbuli za Undewa wa Mulungu na kufundiza mbuli za Mndewa Yesu Kilisto bila kudumba, na hagomesigwe na munhu yoyose.");
INSERT INTO zaj_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Lupwilili luno lolawa ha Paulo, mtumigwa wa Yesu Kilisto, yasaguligwe na Mulungu kuwa mtumigwa wa Kilisto na kutumigwa yakaupete Usenga Unogile wa Mulungu, ");
INSERT INTO zaj_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","uyekile kilagano umwaka kubitila wahokozi zake Mzinyandiko Zing'alile. ");
INSERT INTO zaj_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Usenga uja umulonga Mwanage, Yesu Kilisto, ayo mmbuli ya kiunhu yakalile yolawa mulukolo lwa Daudi, ");
INSERT INTO zaj_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","na vija viyali na ung'azi ulawa ha Mulungu kalagusigwa na mhiko ng'hulu kuwa Mwana wa Mulungu kipigiti viyazusigwe kulawa mkudanganhika. ");
INSERT INTO zaj_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kubitila heyo, Mulungu kanigwelela ngekewa na utumigwa wa Kilisto giladi niwapetele wanhu wa isi zose giladi watogole na kumtogola heyo, giladi twaga jake diyenzigwe. ");
INSERT INTO zaj_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Vivija na mweye mwa mmwanza wa waja wakemigwe kuwa wanhu wa Yesu Kilisto. ");
INSERT INTO zaj_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Nowandikila mweye wanhu wose wa wambo da Loma, mnogelwe na Mulungu na mkemigwe kuwa wanhu zake mwenyego. Ngekewa na tindiwalo kulawa ha Mulungu Tata wetu na kulawa ha Mndewa Yesu Kilisto viwe hamoja namwe. ");
INSERT INTO zaj_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Tanhu, nomuheweza Mulungu wangu kubitila Yesu Kilisto sama yenu mweye mose, kwavija nhamanila yenu yopetigwa muulumwengu wose. ");
INSERT INTO zaj_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Mulungu, inimsang'hanikila na moyo wangu wose mkuupeta Usenga Unogile wa Mwanage, iyo msindila wangu vija viniwakumbukila mweye mazua gose ");
INSERT INTO zaj_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","muna zinhambiko zangu. Kipigiti chose notambika ha Mulungu, vihamnogela, yanidahize kwiza kumwenu sambisambi. ");
INSERT INTO zaj_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kwavija nosulukila ng'hani niwone, giladi niwagwelele nhunza ya muloho giladi mgangamizwe. ");
INSERT INTO zaj_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Nie nolonda tuigangamize, nhamanila yenu inigangamize nie, na nhamanila yangu iwagangamize mweye. ");
INSERT INTO zaj_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ndugu zangu, nolonda m'vitange kamba mianza bwando nilonda kwiza kumwenu, ila nizuiligwa. Nilonda mmwanza wenu niwatende wanhu wamtogole Kilisto, kamba viniwatendile mmwanza wa Wamhazi wayagwe. ");
INSERT INTO zaj_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Kwavija nolondigwa kuwasang'hanikila wanhu wose, Wagiliki na wanhu hawali Wagiliki, wanhu wali na nzewele na walibule nzewele. ");
INSERT INTO zaj_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Avo, vivija nolonda kuupeta Usenga Unogile kumwenu mweye mkala hiko Loma. ");
INSERT INTO zaj_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Siwonela kinyala Usenga Unogile, kwavija uwo mhiko ya Mulungu iwakombola wanhu wose woutogola, tanhu ha Wayahudi, na vivija ha Wamhazi. ");
INSERT INTO zaj_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kwavija Usenga Unogile wogubula vija Mulungu viyowatenda wanhu kuwa bule uzenzeleganye kubitila nhamanila songela haichanduso mbaka hakimambukizo, kamba viyandikigwe Mzinyandiko Zing'alile, “Munhu ayo yalibule uzenzeleganye kokala muinhamanila.” ");
INSERT INTO zaj_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Lusango lwa Mulungu lugubuligwa kulawa kuulanga ha wanhu walekile kumtanga Mulungu na ha wanhu wehile, awo woigubika ikweli na wiho wao. ");
INSERT INTO zaj_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kwavija gaja godahika kutangigwa muna zimbuli za Mulungu wafunuliligwa, kwavija Mulungu kagalagusa kumwao. ");
INSERT INTO zaj_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Songela vuulumbigwe ulumwengu, mbuli za Mulungu ziifisile, nhegulo yake mhiko zake za digunge na uungu wake, zigubuligwa, zimanyika kulawa m'vinhu viyavilumbile. Avo wanhu wabule mbuli ya kuigombela. ");
INSERT INTO zaj_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Womtanga Mulungu, ila hawamuhishimila kamba Mulungu ama kumgwelela hewela, ila ngelegeza zao zigaluka ubozi, na nzonzi zao za ubozi zigeligwa kiziza. ");
INSERT INTO zaj_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Wokiiyona wabala, ila wabule nzewele, ");
INSERT INTO zaj_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","na waleka kumtambikila Mulungu yokala digunge na kusonga kuitambikila miwegu ilingile kamba munhu ama ndege ama wang'onyo wali na magulu mane ama nyoka. ");
INSERT INTO zaj_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Avo Mulungu kawaleka wawinze mbuli zihile zisulukilwa na mioyo yao na kuitendela wenyego kwa wenyego mbuli za kinyala mzing'huli zao. ");
INSERT INTO zaj_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Waigalula ikweli ya Mulungu kuwa uvwizi, wavitambikila na kuvisang'hanikila vinhu vilumbigwe na Mulungu, na kuleka kumtambikila Mulungu yavilumbile, yolondigwa kuyenzigwa mazua gose! Amina. ");
INSERT INTO zaj_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Sama ya kilamso kino, Mulungu kawaleka wawinze sulukila zao zigela kinyala. Hata watwanzi zao wazihindula nzila za kuilumba zilumbigwe na Mulungu na kuilumba vija Mulungu havilumbile. ");
INSERT INTO zaj_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Vivija wambigalo na hewo waleka kuilumba na watwanzi na kuisulukila wenyego kwa wenyego. Wambigalo watenda mbuli zigela kinyala na wambigalo wayao na kubokela nhaguso ilumbile na gaja gawatendile. ");
INSERT INTO zaj_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kwavija wanhu walema kumtanga Mulungu, Mulungu kawaleka mzinzonzi zao zihile, giladi watende mbuli hazilondigwe kutendigwa. ");
INSERT INTO zaj_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Wamema mbuli zose zihile, wiho, sulukila ya vinhu va wanhu, na kunogelwa na gehile. Wamema migongo, ukomaji, ngomba, uvwizi, na kuilondela gehile. Wodeta, ");
INSERT INTO zaj_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","wowalonga wanhu vihile, womwihila Mulungu, wamema maligo, magoda, na matopa. Wamema mbuli zihile na hawawahishimila waja wawalelile. ");
INSERT INTO zaj_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Wabozi, vizenzeleganye, wabule noge, na wabule bazi. ");
INSERT INTO zaj_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Wovitanga kamba lagizo da Mulungu dolonga kamba wanhu wotenda mbuli kamba zino wolondigwa wadanganhike. Hata avo, si kamba wazitenda mbuli hizo tu, ila hata kuwatogola wanhu wayagwe wozitenda mbuli hizo. ");
INSERT INTO zaj_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Avo haduhu kuigombela hata uhawile munhu yalihi ihawa komtagusa uvwizi miyago, kwavija vuubitiza nhaguso ha miyago, kokiitagusa mwenyego, kwavija na gweye kotenda gagaja gayatendile heyo. ");
INSERT INTO zaj_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tovitanga kamba nhaguso ya Mulungu mwa awo wotenda vinhu kamba avo ikala muikweli. ");
INSERT INTO zaj_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ila gweye, munhu, uwatagusa waja wotenda mbuli kamba zino ihawa na gweye mwenyego kotenda mbuli zizo, kogelegeza kodaha kuikimbila nhaguso ya Mulungu? ");
INSERT INTO zaj_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ama kodizabuza bwando da ugoli wa unozi wake na mwazaganyo wake? Huvimanya kamba unozi wa Mulungu wokulongoza gweye uleke vilozo? ");
INSERT INTO zaj_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ila sama ya udala wa moyo wako na vija vuuli na moyo wa kulema kuleka vilozo, kokiimemekezela lusango gwegwe mwenyego kuna dizua da lusango aho nhaguso ya Mulungu ilibule uzenzeleganye vondaigubuligwe. ");
INSERT INTO zaj_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Kwavija Mulungu komuliha kila munhu kamba vija viyasang'hanike. ");
INSERT INTO zaj_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Awo wokwazaganya mkutenda ganogile wozahila yenzi, hishima, na ugima, Mulungu kowagwelela ugima wa digunge. ");
INSERT INTO zaj_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Wanhu wayagwe wozahila mbuli zao wenyego na awo woilema ikweli na kuzikweleleza mbuli zihile, Mulungu kowonela lusango na ng'hasilika. ");
INSERT INTO zaj_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kuja kowa na mgayo na kugazika ha wanhu wose wotenda gehile, tanhu Wayahudi, abaho Wamhazi. ");
INSERT INTO zaj_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ila Mulungu kowagwaa yenzi na hishima na tindiwalo wanhu wose wotenda ganogile, tanhu Wayahudi, abaho Wamhazi. ");
INSERT INTO zaj_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kwavija Mulungu hasagula wa kumnogela. ");
INSERT INTO zaj_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Wanhu wose walozile bila kugatanga Malagizo ga Musa wokwangama hata kamba hawagatangile Gamalagizo, na wose walozile mkugatanga Malagizo wotagusigwa na Gamalagizo. ");
INSERT INTO zaj_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kwavija si kamba awo wogahulika Malagizo wawo walibule uzenzeleganye hameso ga Mulungu, ila waja wagagogile Malagizo wawo wapetigwe kamba wabule uzenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Hata Wamhazi, awo walibule Malagizo ga Musa, yokoneka kamba wagatanga Malagizo ahaja vowagawinza bila kufundizwa na munhu, hata kamba hawanagahulika. ");
INSERT INTO zaj_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Yolagusa kamba gaja golondigwa na Malagizo gandikwa mmioyo yao, na udaho wao wa kusambula gehile na ganogile vivija wolava usindila, na ngelegeza zao kipigiti kiyagwe zowatagusa na kipigiti kiyagwe zowakikiwiza. ");
INSERT INTO zaj_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Mbuli zino zolawilila mdizua dija Mulungu vondayazitaguse ngelegeza zifisike za wanhu kubitila Yesu Kilisto kamba Usenga wangu Unogile vuulonga. ");
INSERT INTO zaj_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Gweye ukiikema mwenyego Muyahudi, na kogatamanila Malagizo ga Musa na kuigodela uhamoja na Mulungu, ");
INSERT INTO zaj_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","kamba vija kugatanga gaja goyolonda, na kugatogola gaja ganogile, kwavija kulagizigwa na Gamalagizo ga Musa. ");
INSERT INTO zaj_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Kokwagiza kamba gweye kwa kilangizi wa vimbugumbugu, mulangaza mwa awo wali mdiziza, ");
INSERT INTO zaj_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","mkulufunzi wa wabozi, na mfundiza wana. Kokwagiza kamba kunago Malagizo gali na ilimu na kweli. ");
INSERT INTO zaj_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Gweye uwafundiza wanhu wayagwe, habali hukiifundiza gweye mwenyego? Gweye uwapetela wanhu sambiwebe, habali gweye kokwiba? ");
INSERT INTO zaj_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Gweye ulonga kamba wanhu sambiwatende ugoni, habali gweye kotenda ugoni? Gweye uihila miwegu, habali gweye kokwiba kulawa mzing'anda zao? ");
INSERT INTO zaj_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Gweye ukiitopela Malagizo ga Musa, habali gweye komzabuza Mulungu mkugakeng'enha Malagizo? ");
INSERT INTO zaj_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kamba viyandikigwe Mzinyandiko Zing'alile, “Twaga da Mulungu dofukuligwa hagatigati ya Wamhazi sama yenu mweye.” ");
INSERT INTO zaj_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kwingila kumbi kololwa kamba muhagagoga Malagizo ga Musa, ila kamba muhagakeng'enha Gamalagizo ga Musa, kwingila kumbi kumwenu kogaluka kuleka kwingila kumbi kamba Wamhazi. ");
INSERT INTO zaj_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Kamba awo walekile kwingila kumbi wahagagoga Malagizo ga Musa, kuleka kwingila kumbi hakupetigwa kamba kwingila kumbi kamba viwali wanhu wa Mulungu? ");
INSERT INTO zaj_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Awo walekile kwingila kumbi da lukuli ila wogagoga Malagizo ga Musa wokutagusa gweye hata kamba kunago Gamalagizo gandikigwe na kwingila kumbi, kwavija kogakeng'enha Gamalagizo ga Musa. ");
INSERT INTO zaj_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Munhu hapetigwa kuwa Muyahudi mkuvumbuka ama mkwingila kumbi kwiyeka. ");
INSERT INTO zaj_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Munhu kowa Muyahudi wa kweli kamba yahawa Muyahudi kulawa mgati, ihawa moyo wake wingizigwa kumbi, na sang'hano ino yotendigwa na Loho wa Mulungu, na sio na Malagizo gandikigwe. Munhu kamba ino kobokela nhogolwa kulawa ha Mulungu, na sio kulawa ha wanhu. ");
INSERT INTO zaj_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Muyahudi kana kinhu chaki kibanzile? Ama kuna kinhu chaki cha kuigodela mwa munhu yengizigwe kumbi? ");
INSERT INTO zaj_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Kuna vinhu bwando va kuigodela! Tanhu, Mulungu kawagwelela Wayahudi usenga wake. ");
INSERT INTO zaj_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Yowaze kamba wayagwe mmwanza wao wabule nhamanila? Kuwa bule nhamanila kuwali nako komtenda Mulungu yawe kizenzeleganye? ");
INSERT INTO zaj_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Bule! Hata kamba kila munhu yahawa m'vwizi, Mulungu havwiza. Kamba Nyandiko Zing'alile vuzilonga, “Giladi upetigwe kamba kwabule uzenzeleganye mzimbuli zako, na kuhuma muinhaguso yako.” ");
INSERT INTO zaj_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Kamba mbuli zetu zihile zosimulila lumosilumosi vija Mulungu viyalibule uzenzeleganye, tulongeze? Tulonge Mulungu kotenda vihile voyotugalila tweye lusango lwake? Hano nolonga kiunhu. ");
INSERT INTO zaj_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Bule! Ihawile hivo, Mulungu yahadahile vilihi kuutagusa ulumwengu? ");
INSERT INTO zaj_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ila ihawa uvwizi wangu woisang'hanikila yenzi ya Mulungu mkuitenda ikweli yake itangigwe ng'hani, habali ning'hali nidukumizwa kamba mtenda vilozo? ");
INSERT INTO zaj_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Habali hatulonga, kamba wanhu wayagwe vowotulonga vihile mkutulonga kamba tweye tulonga, “Leka tutende gehile giladi geze ganogile”? Walumba kutagusigwa. ");
INSERT INTO zaj_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Avo tulongeze? Tweye Wayahudi tunoga kubanza wanhu wayagwe? Bule! Kwavija tweye tose twisha kutagusigwa, wose, Wayahudi na Wamhazi twa hasi ya mhiko za vilozo. ");
INSERT INTO zaj_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Kamba Nyandiko Zing'alile vuzilonga, “Haduhu munhu yalibule uzenzeleganye, haduhu hata munhu imwe, ");
INSERT INTO zaj_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","haduhu munhu yomtanga Mulungu, haduhu munhu yomzahila Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Wose wamuleka Mulungu, wose hamoja wagaluka miwewela, haduhu munhu yotenda ganogile, haduhu hata munhu imwe. ");
INSERT INTO zaj_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Mikolomelo yao ya kamba panga digubuligwe, ndimi zao zolonga uvwizi, sumu ya nyoka ya mmilomo yao. ");
INSERT INTO zaj_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Milomo yao imema ndukumiza na usungu. ");
INSERT INTO zaj_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Magulu gao gowalongoza walopole kwita mulopa, ");
INSERT INTO zaj_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ubananzi na migayo va mzinzila zao, ");
INSERT INTO zaj_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","na nzila ya tindiwalo hawaitanga. ");
INSERT INTO zaj_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Haduhu bwembwe da Mulungu haulongozi wa meso gao.” ");
INSERT INTO zaj_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Sambi tovitanga kamba Malagizo ga Musa gowalonga waja wali hasi ya Gamalagizo higo, giladi munhu yoyose sambiyawe na mbuli ya kuigombela, na ulumwengu wose ulamulwe na Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Kwavija haduhu munhu yondayapetigwe kamba kabule uzenzeleganye hameso gake mkugagoga Malagizo, kwavija kubitila Malagizo higo topata udaho wa kuvitanga vilozo tu. ");
INSERT INTO zaj_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ila sambi nzila ya Mulungu ya kuwatenda wanhu wawe bule uzenzeleganye igubuligwa bila kutamanila Malagizo ga Musa, hata kamba Malagizo ga Musa na Nyandiko Zing'alile za wahokozi woilavila usindila. ");
INSERT INTO zaj_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Kuwa bule uzenzeleganye kokwiza kubitila kumtamanila Yesu Kilisto mwa awo wose wotogola. Haduhu yam'banzile miyage, ");
INSERT INTO zaj_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","kwavija wose watenda vilozo na kuhungukilwa na yenzi ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Wapetigwa kuwa wanhu walibule uzenzeleganye bila kuliha kinhu chochose, kubitila ukombola kulawa ha Yesu Kilisto. ");
INSERT INTO zaj_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Mulungu kamulava Yesu yawe kamba nhosa ya kuwalumba wanhu na heyo mwenyego kubitila nhamanila mmulopa wake. Kagatenda gano kulagusa kamba kabule uzenzeleganye, kwavija mkwazaganya kumwake Mulungu hawataguse awo watendile vilozo umwaka. ");
INSERT INTO zaj_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Kagatenda gano giladi yalaguse kamba kabule uzenzeleganye mkipigiti kino na kamba voyomtenda munhu yoyose yomtamanila Yesu yawe bule uzenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Avo, choni chondatuigodele? Hahudu! Tuigode kwavija tugagoga Malagizo ga Musa? Si vivo, ila kwavija tutogola kamba Yesu kotukombola. ");
INSERT INTO zaj_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Kwavija tuvimanya kamba munhu kopetigwa kamba kabule uzenzeleganye kubitila nhamanila na sio mkugagoga Gamalagizo ga Musa. ");
INSERT INTO zaj_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ama Mulungu ka Mulungu wa Wayahudi weiyeka? Heyo vivija hali Mulungu wa Wamhazi? Ona, heyo vivija ka Mulungu wa Wamhazi. ");
INSERT INTO zaj_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Mulungu ka imwe, yowatenda wawe bule uzenzeleganye waja wengile kumbi kubitila nhamanila na waja walekile kwingila kumbi kubitila nhamanila iija. ");
INSERT INTO zaj_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Avo, tugase Gamalagizo ga Musa sama ya nhamanila ino? Si vivo, ila togavikiza Gamalagizo ga Musa. ");
INSERT INTO zaj_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Tulonge choni mmbuli zija ziyapatile Ablaham, muhenga wetu mmbuli ya kiunhu? ");
INSERT INTO zaj_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kamba Ablaham koneka kabule uzenzeleganye hameso ga Mulungu kubitila sang'hano zake za lukuli, avo kana kinhu cha kuigodela, ila sio haulongozi wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Nyandiko Zing'alile zolongaze? “Ablaham kamtogola Mulungu, na Mulungu kampeta heyo kamba munhu yalibule uzenzeleganye.” ");
INSERT INTO zaj_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Munhu yosang'hanika, kitumetume chake hakiwa kamba nhunza, ila chowa kamba maliho gake. ");
INSERT INTO zaj_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ila wanhu wopetigwa kamba wabule uzenzeleganye, sio sama ya sang'hano zao, ila sama ya nhamanila yao ha Mulungu, ayo yowagela kumgongo wanhu wali na vilozo. ");
INSERT INTO zaj_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Avo, vivija Daudi kozilonga motelo za munhu ayo Mulungu yampetile kamba kabule uzenzeleganye kutali na sang'hano. ");
INSERT INTO zaj_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Wamota waja udulu wao ugeligwe kumgongo, na awo wasegezelwe vilozo vao! ");
INSERT INTO zaj_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Kamota munhu ija Mndewa yoleka kumpetela vilozo!” ");
INSERT INTO zaj_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Motelo zino ha wanhu wengile kumbi weiyeka, ama vivija ha wanhu walekile kwingila kumbi? Tweye tulonga, “Nhamanila ya Ablaham iyo imtendile yawe bule uzenzeleganye.” ");
INSERT INTO zaj_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Kipigiti chaki mbuli ino imulawila Ablaham? Viyakalile yang'hali hanakwingila kumbi ama viyeshile kwingila kumbi? Imulawila kipigiti hanakwingila kumbi, na sio kipigiti viyeshile kwingila kumbi. ");
INSERT INTO zaj_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Heyo kabokela kilaguso cha kwingila kumbi kamba utango wa kuwa bule uzenzeleganye kuyakalile nao kubitila nhamanila kipigiti viyakalile yang'hali hanakwingila kumbi. Avo heyo iyo tata wa waja wose wotogola bila kwingila kumbi, giladi wapetigwe kamba wabule uzenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Na heyo vivija iyo tata wa awo wengile kumbi, sio awo wengile kumbi tu, ila awo vivija wotembela mkuiwinza nhamanila ija yaakalile nayo tata wetu Ablaham kipigiti viyakalile hanakwingila kumbi. ");
INSERT INTO zaj_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Kwavija kilagano Mulungu chayailagane na Ablaham na lukolo lwake, kamba hewo wouhala ulumwengu, hakizile ha Ablaham ama ha lukolo lwake kubitila Malagizo ga Musa, ila sama ya kuwa bule uzenzeleganye kwizile kubitila nhamanila. ");
INSERT INTO zaj_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Kwavija kamba waja wogatamanila Malagizo ga Musa wao wahazi, nhamanila izabuka na ikilagano si kinhu. ");
INSERT INTO zaj_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Kwavija Malagizo ga Musa gago gogala lusango lwa Mulungu. Ila hanhu halibule Malagizo ga Musa, haduhu udulu wa Malagizo. ");
INSERT INTO zaj_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Avo, kilagano chokwiza kubitila nhamanila, giladi kilavigwe bule kamba nhunza ya Mulungu mwa lukolo lose lwa Ablaham. Sio tu ha awo wogagoga Malagizo ga Musa, ila vivija ha awo wali na nhamanila kamba ya Ablaham. Kwavija heyo iyo tata wa tweye tose. ");
INSERT INTO zaj_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Kamba viyandikigwe Mzinyandiko Zing'alile, “Nikutenda gweye uwe tata wa isi bwando.” Kilagano hicho kinoga haulongozi wa Mulungu yaamtamanile, ayo yowagwelela ugima wanhu wadanganhike na kuvikema vinhu vilihaduhu viwe baho. ");
INSERT INTO zaj_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ablaham katamanila mbuli hazidahike kutamanilwa, katogola kokwiza kugaluka tata wa isi bwando, na kawa avo, kamba viyalongeligwe, “Avo kowa na wana bwando.” ");
INSERT INTO zaj_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Nhamanila yake haihungule hata haja viyalugelegeze lukuli lwake mwenyego, lukalile behi na kudanganhika kwavija kakala na milao kamba mia, na vija viyamgelegeze Sala ayo yakalile bule sambo. ");
INSERT INTO zaj_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Haduhu kinhu chochose kimtendile yasinhe kukitogola kilagano cha Mulungu, ila kagendelela kuwa na mhiko mnhamanila yake kuno yomuyenzi Mulungu, ");
INSERT INTO zaj_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","yotogola kamba Mulungu kodaha kugatenda gaja gayailagane. ");
INSERT INTO zaj_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Avo, sama ya nhamanila yake, “Kapetigwa kuwa munhu yalibule uzenzeleganye.” ");
INSERT INTO zaj_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ila mbuli ilonga, “Kapetigwa,” handikiligwe heyo yeiyeka, ");
INSERT INTO zaj_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ila vivija sama yetu tweye, tondatupetigwe kuwa wanhu walibule uzenzeleganye, tweye tumtogole heyo yamzusile Yesu Mndewa wetu kulawa mkudanganhika. ");
INSERT INTO zaj_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Heyo kalavigwa giladi yadanganhike sama ya vilozo vetu, na kuzuswa kulawa mkudanganhika giladi tutendigwe wanhu walibule uzenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Avo, avija vitupetigwe kamba twabule uzenzeleganye hameso ga Mulungu kubitila nhamanila, tuna tindiwalo na Mulungu kubitila Mndewa wetu Yesu Kilisto, ");
INSERT INTO zaj_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ayo yatutendile tupate nzila kubitila nhamanila mbaka kwingila mngekewa ino itwimile nayo sambi. Na todeng'ha mditamanilo da yenzi ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Sio higo geiyeka, ila vivija toideng'hela migayo yetu kwavija tuvitanga kamba mgayo wogala mwazaganyo, ");
INSERT INTO zaj_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","na mwazaganyo woigangamiza nhogolwa inogile, na nhogolwa inogile yodigangamiza tamanilo da ukombola wetu. ");
INSERT INTO zaj_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Tamanilo dino haditutenda tunyunguale, kwavija Mulungu katwitila noge jake mmioyo yetu kubitila Loho wa Mulungu yaatugwelele tweye. ");
INSERT INTO zaj_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Vitukalile twabule mhiko, Kilisto keza mkipigiti kitogoligwe na kadanganhika sama ya tweye Wamhazi. ");
INSERT INTO zaj_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Vidala munhu kudanganhika sama ya munhu yalibule uzenzeleganye. Ila vodahika munhu kudanganhika sama ya munhu yanogile. ");
INSERT INTO zaj_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ila Mulungu kotulagusila tweye noge jake, avija Kilisto viyadanganhike sama yetu tweye, kipigiti vitukalile tung'hali na vilozo! ");
INSERT INTO zaj_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Avo, avija vitupetigwe kuwa bule uzenzeleganye kubitila mulopa wake, yolagusa kotukombola ng'hani kulawa mulusango lwa Mulungu kubitila heyo! ");
INSERT INTO zaj_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Tukala wadumuka wa Mulungu, ila katutenda kuwa wambwiga zake kubitila ifa ya Mwanage. Avija vitupetigwe kuwa wambwiga zake Mulungu, yolagusa kotukombola ng'hani kubitila ugima wake Kilisto! ");
INSERT INTO zaj_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ila sio higo geiyeka, ila vivija todeng'ha mgati mwa Mulungu kubitila Mndewa wetu Yesu Kilisto, na kubitila heyo tuilumba na Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Avo, kamba vilozo vingila muulumwengu kubitila munhu imwe, na ifa iza kubitila vilozo, avo ifa yenela mwa wanhu wose, kwavija wanhu wose watenda vilozo. ");
INSERT INTO zaj_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Vilozo vikala baho muulumwengu songela Malagizo ga Musa haganalavigwa, ila vilozo havipetigwe kipigiti vikukalile haduhu Malagizo. ");
INSERT INTO zaj_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ifa itawala songela kipigiti cha Adamu mbaka kipigiti cha Musa, ifa iwatawala hata waja wakalile hawatendile vilozo va kugadulukila Malagizo, kamba viyatendile Adamu, ayo yalingile na Kilisto yondayeze. ");
INSERT INTO zaj_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ila nhunza ya Mulungu hailingile kamba kilozo cha Adamu, kwavija kamba wanhu bwando wadanganhika kubitila kilozo cha munhu imwe, avo chowa kiasi kikulu ng'hani cha ngekewa ya Mulungu yondaize sama ya ngekewa ya munhu imwe yokemigwa Yesu Kilisto, iwetikila wanhu bwando! ");
INSERT INTO zaj_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Nhunza ya Mulungu hailingile na malawililo ga kilozo cha munhu imwe. Kwavija nhaguso iwinza kilozo kimwe na igala msuno. Ila nhunza ya Mulungu iwinza vilozo bwando na iwatenda wanhu kuwa bule uzenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Kwavija sama ya kilozo cha munhu imwe Adamu, ifa itawala wanhu bwando. Avo chowa kipigiti kikulu ng'hani chondawatawale awo wabokele ngekewa ya Mulungu na nhunza ya kuwa bule uzenzeleganye awo wokala mkuvihuma vilozo, kubitila ifa ya munhu ino, Yesu Kilisto. ");
INSERT INTO zaj_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Avo, malawililo ga kilozo cha munhu imwe gakala nhaguso mwa wanhu wose, avo vivija malawililo ga sang'hano ya munhu imwe yalibule uzenzeleganye yowatenda wanhu wose wapetigwe kamba wanhu walibule uzenzeleganye, ija igala ugima mwa wanhu wose. ");
INSERT INTO zaj_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Kwavija kubitila udulu wa munhu imwe, wanhu bwando watendigwa wawe na vilozo, avo vivija kubitila wende wa munhu imwe, wanhu bwando watendigwa wawe bule uzenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Malagizo ga Musa vugezile, vilozo vongezeka. Ila hanhu vilozo havongezeke, ngekewa ya Mulungu yokongezeka ng'hani. ");
INSERT INTO zaj_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Avo, kamba vija vilozo vuvitawale na kugala ifa, avo vivija na ngekewa ya Mulungu yotawala kubitila kuwa bule uzenzeleganye, ako kutulongoza tweye kuugima wa digunge kubitila Mndewa wetu Yesu Kilisto. ");
INSERT INTO zaj_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Avo, tulongeze? Tugendelele kutenda vilozo giladi Mulungu yongeze ng'hani ngekewa yake? ");
INSERT INTO zaj_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Mmbuli ya vilozo tweye tudanganhika, todahaze kugendelela kukala m'vilozo? ");
INSERT INTO zaj_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ham'vitanga kamba tweye tose tubatizigwa mkuilumba na Yesu Kilisto tubatizigwa mkuilumba muifa yake? ");
INSERT INTO zaj_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Avo, tuzikigwa hamoja nayo kubitila mbatiza ya kuilumba muifa yake, giladi kamba Kilisto viyazukile kulawa mkudanganhika kubitila mhiko ya yenzi ya Tata, vivija na tweye tukale ukazi wa sambi. ");
INSERT INTO zaj_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kwavija ihawa tuilumba hamoja na heyo muifa iyadanganhike heyo, vivija toilumba hamoja na heyo mumzuso uwazukile heyo. ");
INSERT INTO zaj_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Tovitanga kamba unhu wetu wa umwaka uwambigwa mumsalaba hamoja na heyo, giladi vilozo sambiviwe na mhiko, sambituwe nyakadala wa vilozo. ");
INSERT INTO zaj_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kwavija munhu yadanganhike mkuilumba na Kilisto kafunguligwa kulawa mmhiko za vilozo. ");
INSERT INTO zaj_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ihawa tudanganhika hamoja na Kilisto, vivija totogola kamba tokwiza kukala hamoja na heyo. ");
INSERT INTO zaj_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kwavija tovitanga kamba Kilisto kazuka kulawa mkudanganhika, avo hadanganhika mwanza uyagwe, na ifa haimtawala. ");
INSERT INTO zaj_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Ifa iyadanganhike, kadanganhika mwanza umwe sama ya vilozo va wanhu wose, ila ugima uyalinao, kokala sama ya yenzi ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Vivija na mweye wenyego mgelegeze kamba mmbuli ya vilozo mdanganhika, ila ha Mulungu muna ugima mkuilumba na Yesu Kilisto. ");
INSERT INTO zaj_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Avo, sambimuleke vilozo vitawale mzing'huli zenu, mkuziwinza sulukila zihile za ng'huli zenu. ");
INSERT INTO zaj_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Sambim'vilave vipindi va ng'huli zenu viwe via va kutendela gehile, visang'hanike mkutenda vilozo. Ila vihanogile muilave wenyego ha Mulungu kamba awo wabwezigwe kulawa mkudanganhika na kuwa wagima, na m'vilave vipindi va ng'huli zenu ha Mulungu kamba via vilibule uzenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Vilozo haviwatawala, kwavija hamuli hasi ya Malagizo ga Musa, ila mwa hasi ya ngekewa ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Avo tulongeze? Tutende vilozo kwavija hatuli hasi ya malagizo ila twa hasi ya ngekewa ya Mulungu? Si vivo! ");
INSERT INTO zaj_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ham'vitanga kamba muhailava wenyego ha munhu yoyose kuwa nyakadala, mweye mwa nyakadala wa munhu ija imuilavile kumwake? Mdaha kuwa nyakadala wa vilozo viwalongoza kuna iifa, ama mdaha kuwa wende wa Mulungu kuwalongoza kulibule uzenzeleganye? ");
INSERT INTO zaj_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ila Mulungu yahewezigwe, kwavija mkala nyakadala wa vilozo, ila mgaluka wende kulawa mmioyo na kugawinza mafundo gamfundizigwe. ");
INSERT INTO zaj_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Mkomboligwa kulawa m'vilozo, na mgaluka nyakadala wa mbuli zilibule uzenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Nolonga ulonzi wa kiunhu sama ya udaho mdodo umulinao. Kamba vija vum'vilavile vipindi venu viwe nyakadala wa vilozo na kuutenda wiho ubanze, avo sambi vilaveni viwe nyakadala wa mbuli zilibule uzenzeleganye zondaziwatende mng'ale. ");
INSERT INTO zaj_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Vumkalile nyakadala wa vilozo, mkala muilegehe kulawa mzimbuli zilibule uzenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Avo, kinhu chaki chumpatile mkipigiti kija kulawa mzimbuli zumzonela kinyala sambi? Kwavija malawililo ga mbuli zija gakala ifa. ");
INSERT INTO zaj_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ila sambi mkomboligwa kulawa m'vilozo na mgaluka nyakadala wa Mulungu. Kinhu chumpatile kicho ung'azi, na malawililo gake, ugima wa digunge. ");
INSERT INTO zaj_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kwavija kitumetume cha vilozo kicho ifa, ila nhunza ya Mulungu iyo ugima wa digunge kubitila Yesu Kilisto Mndewa wetu. ");
INSERT INTO zaj_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ndugu zangu, nolonga na wanhu wogatanga goya Malagizo ga Musa. Ham'vitanga kamba Malagizo gomfunga munhu kipigiti cha ugima wake tu? ");
INSERT INTO zaj_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Kamba vija mtwanzi yasoligwe kofungigwa na malagizo kipigiti mbigalo wake yang'hali mgima. Ila mbigalo wake yahadanganhika, kafunguligwa kulawa mmalagizo ga kusola na kusoligwa. ");
INSERT INTO zaj_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Kokemigwa mgoni kamba yahasoligwa na mbigalo iyagwe kipigiti mbigalo wake yali mgima. Ila kamba mbigalo wake yahadanganhika, kafunguligwa kulawa mdilagizo dija, na heyo hakemigwa mgoni, hata kamba yahasoligwa na mbigalo iyagwe. ");
INSERT INTO zaj_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Vivija na mweye, ndugu zangu, mdanganhika mmbuli ya Malagizo ga Musa kubitila lukuli lwa Kilisto, giladi muwe wanhu wa munhu iyagwe, heyo yazukile kulawa mkudanganhika giladi tumulelele mujo Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Vitukalile tukala ukazi wa kulongozigwa na ng'huli zetu, sulukila zetu za vilozo ziswagizwe na Malagizo ga Musa, zisang'hanika na vipindi vetu zilela mujo ugala ifa. ");
INSERT INTO zaj_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ila sambi tufunguligwa kulawa Mmalagizo ga Musa, tudanganhika mmbuli zija zitufungile, giladi tweye sambituwe nyakadala wa Malagizo ga umwaka gandikigwe, ila tuwe nyakadala muukazi wa sambi wa Loho wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Avo tulongeze? Kamba Malagizo ga Musa gago vilozo? Si vivo! Kamba kuhakalile haduhu Malagizo ga Musa, sambinivitange vilozo. Sambinivitange kamba kusulukila vinhu va wanhu kukala vilozo kamba Gamalagizo ga Musa sambigalonge, “Sambiusulukile vinhu va wanhu.” ");
INSERT INTO zaj_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ila vilozo vipata nzila muindagizi ino kwinula sulukila zose zihile mgati yangu. Kwavija kamba kuhawile haduhu Malagizo ga Musa, vilozo vihadanganhike. ");
INSERT INTO zaj_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Kipigiti kimwe nikala bila kugatanga Malagizo ga Musa. Ila indagizi viizile, vilozo vipata ugima, ");
INSERT INTO zaj_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","na nie nidanganhika. Na ndagizi iija ilongigwe yogala ugima, kumwangu nie igala ifa. ");
INSERT INTO zaj_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Kwavija vilozo vipata hanhu muindagizi ija, vinivwizila, na kubitila ndagizi hiyo ving'homa. ");
INSERT INTO zaj_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Avo, Malagizo ga Musa gang'ala, na indagizi ija ing'ala na yabule uzenzeleganye na inoga. ");
INSERT INTO zaj_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Kija kinogile kinigalila nie ifa? Si vivo! Vikala vilozo vigalile ifa mgati yangu kubitila kija kinogile, giladi vilozo voneke kuwa vilozo. Na kubitila indagizi ija, vilozo voneke kuwa viha ng'hani. ");
INSERT INTO zaj_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Tuvitanga kamba Malagizo ga Musa simbuko jake loho, ila nie si munhu wa muloho, niguzigwa na kuwa nyakadala hasi ya vilozo. ");
INSERT INTO zaj_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Sigatanga gaja gonitenda. Kwavija gaja gonilonda kugatenda, sigatenda. Ila gaja gonigehila kugatenda, nogatenda. ");
INSERT INTO zaj_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Na ihawa nogatenda gaja gonilema kugatenda, notogola kamba Gamalagizo ga Musa ganoga. ");
INSERT INTO zaj_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Avo, sio nie mwenyego nigatenda gano, ila kilozo kili mgati yangu. ");
INSERT INTO zaj_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Novitanga kamba haduhu kinhu kinogile kikala mgati yangu, mulukuli lwangu. Kwavija nolonda kugatenda ganogile, ila sidaha kugatenda. ");
INSERT INTO zaj_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Kwavija sigatenda ganogile gonilonda kugatenda, ila gehile gonilema kugatenda, gago nigatenda. ");
INSERT INTO zaj_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ihawa nogatenda gaja gonilema kugatenda, sio nie nigatenda higo, ila vilozo vikala mgati yangu. ");
INSERT INTO zaj_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Avo, nivitanga kamba nzoela ino yosang'hanika, nihalonda kugatenda ganogile, gehile gokwima haulongozi wangu. ");
INSERT INTO zaj_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Kwavija mgati yangu nogadeng'helela malagizo ga Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ila nokona nzoela ziyagwe zosang'hanika m'vipindi va lukuli lwangu. Nzoela hizo zogomba na nzoela za nzonzi zangu na zonitenda nie niwe mfungigwa wa malagizo ga vilozo gosang'hanika m'vipindi vangu. ");
INSERT INTO zaj_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Nie munhu mkiwa! Yalihi yondayanikombole kulawa mulukuli luno lwa kudanganhika? ");
INSERT INTO zaj_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Mulungu yahewezigwe yogatenda gano kubitila Yesu Kilisto Mndewa wetu! Avo, nie mwenyego mzinzonzi zangu na nyakadala wa malagizo ga Mulungu, ila mulukuli na nyakadala wa malagizo ga vilozo. ");
INSERT INTO zaj_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Avo, sambi haduhu nhaguso mwa wanhu waja wailumbile hamoja na Yesu Kilisto. ");
INSERT INTO zaj_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kwavija kubitila Yesu Kilisto, mhiko za Loho wa Mulungu zili na ugima zinikombola kulawa mmhiko za vilozo na ifa. ");
INSERT INTO zaj_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Malagizo ga Musa galemelwa kutukombola tweye sama ya udonhi wa ng'huli zetu. Avo Mulungu kagatenda gaja galemelwe kutendigwa na Malagizo ga Musa. Kamtuma Mwanage mwenyego mulukuli kamba ng'huli zitulinazo tweye watenda vilozo. Na mulukuli luja Mulungu kakipeta kimambukizo cha vilozo vitutawale tweye mkumulava Mwanage kamba nhosa sama ya vilozo vetu, ");
INSERT INTO zaj_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","giladi mbuli zilibule uzenzeleganye zilondeka na Gamalagizo ga Musa zivikile mgati yetu tweye tulekile kutamanila lukuli, ila tumtamanile Loho wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Wanhu waja wose wokala mkuluwinza lukuli, nzonzi zao zogelegeza gaja golulonda lukuli. Na waja wose wokala mkumuwinza Loho wa Mulungu, nzonzi zao zogelegeza gaja goyolonda Loho ija. ");
INSERT INTO zaj_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kuzitenda ngelegeza zenu zigelegeze mbuli za lukuli, kogala ifa. Ila kuzitenda ngelegeza zenu zigelegeze mbuli za Loho wa Mulungu, kogala ugima na tindiwalo. ");
INSERT INTO zaj_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Sama ya kilamso kino, nzonzi zitamanila lukuli zoibamilila na Mulungu, kwavija zogadulukila malagizo ga Mulungu, na hazidaha kugatogola. ");
INSERT INTO zaj_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Wanhu wolongozwa na sulukila za lukuli hawadaha kugatenda gaja gomnogela Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ila mweye hamulongozigwa na lukuli, ila molongozigwa na Loho wa Mulungu, kwavija Loho wake kokala mgati yenu. Na munhu yoyose yalibule Loho wa Kilisto, heyo si munhu wa Kilisto. ");
INSERT INTO zaj_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Ila kamba Kilisto yahakala mgati yenu, hata kamba ng'huli zenu zihadanganhika sama ya vilozo, Loho wa Mulungu kowagwelela mweye ugima kwavija mtendigwa wanhu walibule uzenzeleganye na Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ihawa Loho wake ayo yamzusile Yesu kulawa mkudanganhika kokala mgati yenu, heyo yamzusile Yesu Kilisto kulawa mkudanganhika vivija kozigwelela ugima ng'huli zenu zibanangika kubitila Loho wake, ayo yokala mgati yenu. ");
INSERT INTO zaj_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Avo, ndugu zangu, towilwa, ila si mkukala mkulongozwa na gaja golulonda lukuli. ");
INSERT INTO zaj_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Kwavija kamba mokala mkulongozigwa na lukuli, modanganhika. Ila kamba mokala mkulongozigwa na Loho wa Mulungu, mozikoma sang'hano za lukuli, na mowa wagima. ");
INSERT INTO zaj_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kwavija wose awo wolongozigwa na Loho wa Mulungu, wao wana wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Kwavija Loho ija Mulungu iyawagwelele mweye hawatenda mweye muwe nyakadala na kuwagela bwembwe, ila mum'bokela Loho wake yowatenda muwe wana wa Mulungu. Na kubitila heyo tomkema, “Aba,” nhegulo yake “Tata.” ");
INSERT INTO zaj_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Loho wa Mulungu kosindila hamoja na loho zetu kamba tweye twa wana wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Na kamba tweye twa wana, twa wahazi, twa wahazi wa Mulungu, na tohala hamoja na Kilisto, kamba tugazika hamoja nayo giladi vivija tuyenzigwe hamoja nayo. ");
INSERT INTO zaj_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Vinigesa nie migayo ya kipigiti kino haihile ng'hani uhailinga na yenzi yondatugubuliligwe tweye. ");
INSERT INTO zaj_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Kwavija vinhu vose vilumbigwe vobeta mkusulukila ng'hani kuno vitamanila wana wa Mulungu kufunuligwa. ");
INSERT INTO zaj_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kwavija vinhu vilumbigwe viwa si kinhu, si mkulonda venyego, ila kamba vija viyalondile ayo yavilumbile. Ila kuna tamanilo, ");
INSERT INTO zaj_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","vinhu vilumbigwe venyego vokwiza kukomboligwa kulawa m'vifungo vake va kubanangika na kugaligwa kuna iyenzi ya ulegeho wa wana wa Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Kwavija tovitanga kamba mbaka kipigiti kino vinhu vose vilumbigwe vogugumila na usungu kamba uja wa kulela mwana. ");
INSERT INTO zaj_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Na si vinhu vilumbigwe viiyeka vigugumila, ila na tweye wenyego, tuli na malimbuko ga Loho wa Mulungu, togugumila munda kwa munda kipigiti tubeta kutendigwa wana wa Mulungu, ukombola wa ng'huli zetu. ");
INSERT INTO zaj_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Kwavija tukomboligwa mditamanilo dino. Ila tamanilo dija dikoneka si tamanilo. Kwavija yalihi yotamanila kija ikinhu yeshile kuwa nacho? ");
INSERT INTO zaj_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ila ihawa totamanila kinhu tuleka kuchona, tokibeta na mwazaganyo. ");
INSERT INTO zaj_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Vivija Loho wa Mulungu kotutaza muudonhi utulinao, kwavija hatuvitanga kutambika kamba vija vitulondigwa kutambika, ila Loho wa Mulungu kotambika sama yetu tweye mkugugumila mmbuli hazidahika kulongeka. ");
INSERT INTO zaj_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Na Mulungu, yogalola gali mmioyo ya wanhu, kozitanga ngelegeza za Loho wake, kwavija Loho wake kotambika sama ya wanhu wa Mulungu kamba vija voyolonda Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Tovitanga kamba Mulungu kowatendela ganogile awo iwamnogele mzimbuli zose, awo iyawakemile sama ya gaja goyolonda. ");
INSERT INTO zaj_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Kwavija waja Mulungu yawatangile songela mwaka, vivija kawasagula walinge kamba Mwanage, giladi Mwanage yawe chaudele wa mulango mkulu. ");
INSERT INTO zaj_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Na waja yawasagule, kawakema. Na waja yawakemile, kawapeta kamba wabule uzenzeleganye. Na waja yawapetile kamba wabule uzenzeleganye, kawayenzi. ");
INSERT INTO zaj_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Avo, tulongeze mmbuli zino? Kamba Mulungu ka ng'ambu yetu, yalihi yondayadahe kuibamilila na tweye? ");
INSERT INTO zaj_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Heyo yalekile kumfisa Mwanage, ila kamulava sama yetu tweye tose. Avo, vivija kolekaze kutugwelela vinhu vose hamoja na Mwanage? ");
INSERT INTO zaj_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Yalihi yondayagale nhaguso yoyose mwa awo yawasagule Mulungu? Mulungu mwenyego iyo yawatendile wawe bule uzenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Yalihi yondayatutaguse? Haduhu, kwavija Yesu Kilisto kadanganhika sama yetu na kazusigwa kawa mgima sama yetu, na kakala kumkono wa ukulume wa Mulungu, yotutambikila tweye! ");
INSERT INTO zaj_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Yalihi yondayatubagule na noge da Kilisto? Mgayo, ama ukumbulu, ama kugazigwa, ama nzala, ama kuwa bule vivalo, ama mmwangalo, ama zele? ");
INSERT INTO zaj_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Kamba viyandikigwe Mzinyandiko Zing'alile, “Sama yako gweye, todanganhika misi ngima, tupetigwa kamba ng'hondolo yolondigwa kuchinjigwa.” ");
INSERT INTO zaj_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Bule, mzimbuli zino zose, tweye tubanziliza kuhuma kubitila heyo yatunogele. ");
INSERT INTO zaj_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Kwavija notogola kamba si ifa, ama ugima, ama wasenga wa Mulungu wa kuulanga, ama vinyamkela, ama vinhu vili sambi, ama vinhu vondavize, ama mhiko zozose, ");
INSERT INTO zaj_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ama ulumwengu wa uchana, ama ulumwengu wa hasi, ama kinhu chochose muna ivinhu vose vilumbigwe chondakidahe kutubagula na noge da Mulungu ha Yesu Kilisto Mndewa wetu. ");
INSERT INTO zaj_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Nolonga ikweli na silonga uvwizi kwavija nie na hamoja na Kilisto, na udaho wangu wa kusambula gehile na ganogile hamoja na Loho wa Mulungu vosindila mbuli zino. ");
INSERT INTO zaj_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Moyo wangu umema usungu mkulu na giogio dilibule nziga ");
INSERT INTO zaj_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","sama ya wanhu zangu, wandugu zangu wa Kiyahudi kwavija kamba nihadahile, nilonda nie mwenyego nihadukumizwe na kusegezigwa kulawa ha Kilisto kamba mkutenda vino wahakomboligwe. ");
INSERT INTO zaj_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Wanhu wa Islaeli, watendigwe wana, wagweleligwe yenzi ya Mulungu, wagweleligwe malagano, wagweleligwe Malagizo ga Musa, wagweleligwe mhome ya kumtambikila Mulungu, na wagweleligwe vilagano. ");
INSERT INTO zaj_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Hewo wao vilangizi, na kulawa kumwao kalawilila Kilisto mmbuli ya lukuli. Na Mulungu, ayo yotawala vinhu vose, yayenzigwe milongo yose! Amina. ");
INSERT INTO zaj_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Si kamba Usenga wa Mulungu uhumwa. Kwavija si wanhu wose wolawa mulukolo lwa Waislaeli wao Waislaeli kweli. ");
INSERT INTO zaj_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Sio wose wolawa mulukolo lwa Ablaham wanage Ablaham kwavija Nyandiko Zing'alile zolonga, “Kubitila Isaka, lukolo lwako lokemigwa.” ");
INSERT INTO zaj_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Nhegulo yake iyo ino, sio wana wa lukuli wa Ablaham wali wana wa Mulungu, ila wana wa kilagano wao wopetigwa kamba lulo lukolo lwa Ablaham. ");
INSERT INTO zaj_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kwavija vino vivo ikilagano vikilonga, “Kamba kipigiti kikino mulao ukwiza nobweleganya, na Sala kowa na mwana mbigalo.” ");
INSERT INTO zaj_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Sio gano geiyeka, kinhu kilingile na kino kimulawilila Lebeka ahaja viyapatile inda ya wana wabili kulawa ha mbigalo imwe, yokemigwa Isaka tata wetu. ");
INSERT INTO zaj_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Hata viwakalile hawanavumbuka, ama hawanatenda kinhu chochose kinogile ama kihile, giladi ija iyamulondile Mulungu kumsagula yapatikane, ");
INSERT INTO zaj_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","sio sama ya gaja gayatendile, ila kubitila lukemo lwake, Lebeka kalongeligwa, “Mkulu komsang'hanikila mdodo.” ");
INSERT INTO zaj_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Kamba viyandikigwe Mzinyandiko Zing'alile, “Yakobo nimnogela, ila Esau nimwihila.” ");
INSERT INTO zaj_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Avo, tulongeze? Kuna uzenzeleganye ha Mulungu? Si vivo! ");
INSERT INTO zaj_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Kwavija kamulongela Musa, “Nomgela kumgongo ayo inimulonda kumgela kumgongo, na nomonela bazi ayo inimulonda kumonela bazi.” ");
INSERT INTO zaj_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Avo, haitamanila vija viyosulukila munhu ama vija viyokiiyoha, ila yotamanila bazi da Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Kwavija Nyandiko Zing'alile zomulonga Falao, “Nikwinula sama ya kulagusa mhiko zangu mgati yako, giladi twaga jangu dipetigwe kila hanhu muisi.” ");
INSERT INTO zaj_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Avo, Mulungu komonela bazi, munhu yoyose yoolonda kumonela bazi, na komgela moyo udala, munhu yoyose yoolonda kumgela moyo udala. ");
INSERT INTO zaj_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Abaho moniuza, “Habali Mulungu yang'hali yotulonga? Yalihi yodaha kugadulukila gaja goyolonda?” ");
INSERT INTO zaj_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ila gweye iyo munhu yalihi hata um'bamilile Mulungu? Kinhu kitendigwe kimulongele ayo yakitendile, “Habali kunitenda nie kamba vino?” ");
INSERT INTO zaj_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Vino muumbi hadaha kulamula kuumba kulawa mditonge dimwe da ulongo kia kimwe kisinyo, na kia kiyagwe cha sang'hano za mazua gose? ");
INSERT INTO zaj_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Vivija hata kamba Mulungu kana udaho wa kulagusa lusango lwake na mhiko zake, ila heyo kowazaganya ng'hani awo yoowonela lusango, awo walumbile kubanangigwa. ");
INSERT INTO zaj_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Na ihawile vilihi kamba katenda gano giladi yatende ugoli wa yenzi yake utangigwe mwa awo wapatile bazi jake, awo yawatandile yenzi yake, ");
INSERT INTO zaj_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","na hata tweye yatukemile, sio kulawa ha Wayahudi weiyeka, ila vivija kulawa ha Wamhazi? ");
INSERT INTO zaj_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Kamba viyalongile muna ikitabu cha Hosea, “Waja wakalile si wanhu zangu nowakema, ‘Wanhu zangu.’ Na ayo nilekile kumnogela nomkema, ‘Mnogelwa wangu.’ ");
INSERT INTO zaj_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Na hanhu hahaja hawalongeligwe, ‘Mweye sio wanhu zangu,’ bahaja wokemigwa, ‘wana wa Mulungu yali na ugima.’ ” ");
INSERT INTO zaj_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Na Isaya kenula dizwi yoilonga Islaeli, kalonga, “Hata kamba mheta ya wana wa Waislaeli yowa kamba misenga ya mumgwazo wa ibahali, ila wondawakomboligwe wowa wadodo, ");
INSERT INTO zaj_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","kwavija Mndewa koitenda nhaguso yake muisi mbwisa na kuimambukiza.” ");
INSERT INTO zaj_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Kamba Isaya viyahokole, yolonga, “Kamba Mndewa Mwene Udaho sambiyatulekele wana, tuhawile kamba Sodoma, na tuhalingile na Gomola.” ");
INSERT INTO zaj_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Avo, tulongeze? Wamhazi, awo walekile kuzahila kuwa bule uzenzeleganye, wasegezeligwa uzenzeleganye kubitila nhamanila. ");
INSERT INTO zaj_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ila Waislaeli, wakalile woiyoha mkuzahila kuwa bule uzenzeleganye mkugawinza Malagizo ga Musa, hawapatile kuwa bule uzenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Habali hawapatile? Kwavija hawakuzahile kubitila nhamanila, ila kubitila kugagoga Malagizo ga Musa. Waikwangwala hana didibwe da kuikwala. ");
INSERT INTO zaj_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Kamba viyandikigwe Mzinyandiko Zing'alile, “Lola! Ako Sayuni nokwika dibwe dondadiwatende wanhu waikwale, dibwe dondadiwatende walagale. Ila munhu yoyose yondayamtogole hageligwa kinyala.” ");
INSERT INTO zaj_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Ndugu zangu, sulukila ya moyo wangu na nhambiko yangu ha Mulungu nolonda wanhu wa Islaeli wakomboligwe! ");
INSERT INTO zaj_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Kinidaha kulonga mmbuli ya wanhu wano icho kino, kamba wokiiyoha ng'hani kumzahila Mulungu. Ila vija viwomzahila, hawamzahila na nzewele. ");
INSERT INTO zaj_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Kwavija hawaitangile nzila ya kuwa bule uzenzeleganye ilawa ha Mulungu, ila wozahila kutenda mbuli zao wenyego, avo hawatogole kulongozigwa na nzila ya Mulungu ya kuwatenda wawe bule uzenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kwavija Kilisto kakigala ikimambukizo cha Malagizo ga Musa, giladi wanhu wose wotogola wapetigwe kuwa bule uzenzeleganye. ");
INSERT INTO zaj_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mmbuli ya nzila ya kuwa bule uzenzeleganye ilawa mkugagoga Malagizo ga Musa, Musa kandika vino, “Munhu yoyose yogagoga malagizo gali Mmalagizo ga Musa kowa mgima kubitila Malagizo higo.” ");
INSERT INTO zaj_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Ila mbuli ya kuwa bule uzenzeleganye, ikwiza kulawa mnhamanila, yolonga, “sambiulonge mmoyo wako, ‘Yalihi yondayakwele mbaka kuulanga?’ nhegulo yake, kumuhumulusa hasi Kilisto. ");
INSERT INTO zaj_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Ama sambiulonge, ‘Yalihi yondayahumuluke mbaka kuzimu?’ nhegulo yake, kumwinula Kilisto kulawa mkudanganhika.” ");
INSERT INTO zaj_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Ila Nyandiko Zing'alile zolongaze? “Usenga wa Mulungu wa habehi nagwe, mmulomo wako na mmoyo wako.” Uno uwo usenga wa nhamanila utuwapetela wanhu. ");
INSERT INTO zaj_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Kwavija kamba uhatogola na mulomo wako kamba Yesu iyo Mndewa na kutogola mmoyo wako kamba Mulungu kamzusa kulawa mkudanganhika, kokomboligwa. ");
INSERT INTO zaj_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Kwavija munhu yahatamanila mmoyo wake kopetigwa kamba kabule uzenzeleganye, na munhu yahatogola na mulomo wake kokomboligwa. ");
INSERT INTO zaj_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Nyandiko Zing'alile zolonga, “Munhu yoyose yomtamanila hageligwa kinyala.” ");
INSERT INTO zaj_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Kwavija Muyahudi na Mmhazi haduhu yam'banzile miyage. Wana Mndewa imwe, na iyo Mndewa wa wose, yowamemeza motelo wose awo womkema. ");
INSERT INTO zaj_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Kwavija, “Munhu yoyose yodikema twaga da Mndewa kokomboligwa.” ");
INSERT INTO zaj_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Avo wodahaze kumkema ayo walekile kumtogola? Na wodahaze kumtogola ayo walekile kumuhulika? Na wodahaze kumuhulika bila munhu kuwapetela? ");
INSERT INTO zaj_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Na wodahaze kuupeta Usenga Unogile kamba hawatumigwe? Kamba viyandikigwe Mzinyandiko Zing'alile, “Ganoga ng'hani magulu ga awo wougala Usenga Unogile!” ");
INSERT INTO zaj_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ila sio wose wautogole Usenga Unogile. Kwavija Isaya kalonga, “Mndewa, yalihi yautogole usenga wetu?” ");
INSERT INTO zaj_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Avo, nhamanila mwanduso wake kuhulika, kuuhulika Usenga Unogile wa Kilisto. ");
INSERT INTO zaj_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Ila nouza, hewo hawahulike? Si vivo, wahulika, “Dizwi jao jenela muisi yose, na mbuli zao zenela mbaka hana zisota za ulumwengu.” ");
INSERT INTO zaj_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Nouza kabili, Waislaeli hawavitangile? Tanhu Musa kolonga, “Nowatenda mweye mwone migongo mwa awo wali si isi, na nowatenda mweye muwe na lusango na isi ija ilibule nzewele.” ");
INSERT INTO zaj_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Isaya kagangamiza kulonga, “Nyoneka na awo walekile kunizahila, na nikiifunula mwenyego mwa awo walekile kunipula.” ");
INSERT INTO zaj_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Ila mmbuli ya Islaeli kolonga, “Imisi ngima nigolosa makono gangu kuwabokela wanhu awo walekile kutogola na wadulu.” ");
INSERT INTO zaj_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Avo nouza, Mulungu kawalema wanhu zake? Si vivo! Nie mwenyego na Muislaeli, lukolo lwa Ablaham, kulawa mtala wa Benjamini. ");
INSERT INTO zaj_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Mulungu hawalemile wanhu zake, awo yaawasagule songela mwaka. Ham'vitanga vija Nyandiko Zing'alile vuzilonga mmbuli ya Eliya, vija viyawataguse Waislaeli ha Mulungu? ");
INSERT INTO zaj_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Mndewa, wawakoma wahokozi zako na kuvibomola vilingo vako va kulavila nhosa. Ila nie niiyeka nisigale, na hewo wouzahila ugima wangu.” ");
INSERT INTO zaj_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ila Mulungu kamwidika vilihi? “Nikiikila mwenyego wanhu alufu saba walekile kumfugamila mavindi Baali, mulungu wa uvwizi.” ");
INSERT INTO zaj_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Vivija mkipigiti kino hana wanhu wadodo wasaguligwe kubitila ngekewa ya Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Usaguzi wake utamanila ngekewa yake, na sio kija kiwasang'hane. Kwavija kamba usaguzi wa Mulungu uhatamanile kija kiwasang'hane wanhu, avo ngekewa yake sambiiwe ngekewa ya kweli. ");
INSERT INTO zaj_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Avo, Waislaeli walemelwa kukipata kija kiwakalile wokizahila? Waja wasaguligwe wakipata, ila wasigale wakala na mioyo midala. ");
INSERT INTO zaj_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Kamba viyandikigwe Mzinyandiko Zing'alile, “Mulungu kawagwelela moyo wa ubozi, giladi meso gao sambigadahe kulola na magwiti gao sambigadahe kuhulika, mbaka zua dino.” ");
INSERT INTO zaj_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Na Daudi kolonga, “Sona zao zigaluke tanzi na mtego, lwingila na msuno ulingile na gaja gawatendile! ");
INSERT INTO zaj_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Meso gao gageligwe ziza giladi sambiwadahe kulola, na migongo yao iveduke milongo yose!” ");
INSERT INTO zaj_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Avo nowauza, Wayahudi waikwala na kugwa hasi kabisa? Si vivo! Ila sama ya vilozo viwatendile, ukombola uchola ha Wamhazi, avo kuwatenda Waislaeli wone migongo. ");
INSERT INTO zaj_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Vilozo va Wayahudi vigala ugoli muulumwengu, na ukumbulu wao wa muloho ugala ugoli ha Wamhazi. Avo, Wayahudi wahaibokela nhunza ya ukombola wa Mulungu, wogala ugoli mkulu ng'hani muulumwengu! ");
INSERT INTO zaj_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Nowalongela mweye Wamhazi, kwavija nie na mtumigwa wa Kilisto ha Wamhazi, noiyenzi sang'hano yangu ");
INSERT INTO zaj_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","giladi niwatende wanhu wa isi yangu mwenyego wone migongo, na niwakombole wayagwe mmwanza wao. ");
INSERT INTO zaj_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Ihawa kulemigwa kumwao kutenda ulumwengu uilumbe na Mulungu, avo yowaze aho vondawatogoligwe? Yowa ugima ha awo wadanganhike. ");
INSERT INTO zaj_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Kamba kidanga cha ichanduso cha mkate kilavigwe ha Mulungu king'ala, avo mkate wose usigale ung'ala. Na kamba mizizi ing'ala, na gamatambi gang'ala. ");
INSERT INTO zaj_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Ila kamba matambi gayagwe ga mzaituni gakanhigwa, na mweye, muli matambi ga mzaituni muhulo, muombekigwe hanhu hagakalile matambi gaja gakanhigwe na sambi moja ugoli wa mzizi wa mzaituni, ");
INSERT INTO zaj_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","avo sambimgazabuze matambi ago gakalile gakanhigwe. Kamba muhagazabuza, mgelegeze kamba sio mweye muugogile umzizi, ila umzizi uwo uwagogile mweye. ");
INSERT INTO zaj_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Gweye kolonga, “Matambi gakanhigwa giladi nie niombekigwe.” ");
INSERT INTO zaj_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Ona, vivo ili! Ila wakanhigwa sama ya kuleka kutogola kumwao, ila gweye kwima kubitila nhamanila. Avo sambiuitope, ila udumbe. ");
INSERT INTO zaj_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Kwavija kamba Mulungu hagalekile matambi gali si ga kuombeka, siku na gweye hakuleka. ");
INSERT INTO zaj_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Avo, mgelegeze unovu na ukali wa Mulungu. Ukali wa Mulungu mwa awo watendile vilozo, ila unovu wa Mulungu kumwenu ulavigwa ihawa mogendelela kukala muunovu wake. Ila kamba si hivo, vivija na mweye mokanhigwa. ");
INSERT INTO zaj_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Na hata Wayahudi, kamba wahagaluka na kutogola, woombekigwa, kwavija Mulungu kana udaho wa kuwaombeka kabili. ");
INSERT INTO zaj_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Kwavija kamba mkanhigwa kulawa mumzaituni muhulo, na muombekigwa mumzaituni kae uli na simbuko diyagwe, vobuha ng'hani matambi gano ga mzaituni kae kuombekigwa kabili kumzaituni kugakalile. ");
INSERT INTO zaj_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ndugu zangu, nolonda muitange nyong'onyo ino giladi sambimgelegeze kamba muna nzewele ng'hani kubanza vimuli. Udala wa mioyo ya wanhu wa Waislaeli haugendelela, ila womalila haja mheta yose ya Wamhazi vondaize ha Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Avo Waislaeli wose wokomboligwa, kamba viyandikigwe Mzinyandiko Zing'alile, “Mkombola kokwiza kulawa Sayuni, na kuusegeza umhazi kulawa mulukolo lwa Yakobo. ");
INSERT INTO zaj_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Na dino dijo lagano jangu dondaniilagane nawo, kipigiti vondaniwasegezele vilozo vao.” ");
INSERT INTO zaj_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Kwavija waulema Usenga Unogile, Wayahudi wawa wadumuka wa Mulungu sama yenu mweye Wamhazi. Ila kwavija Mulungu kawasagula Wayahudi, wawa mbwiga zake sama ya wahenga zao. ");
INSERT INTO zaj_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Kwavija nhunza ya Mulungu na lukemo lwake havigaluka. ");
INSERT INTO zaj_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Umwaka, mweye Wamhazi, mkala mumdulukile Mulungu, ila sambi m'bokela bazi jake sama ya udulu wa Wayahudi. ");
INSERT INTO zaj_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Avo na hewo Wayahudi sambi womdulukila Mulungu, giladi kubitila bazi da Mulungu dim'bokele mweye Wamhazi, na hewo Wayahudi vivija wadibokele. ");
INSERT INTO zaj_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Kwavija Mulungu kawafunga wanhu wose mkifungo cha udulu, giladi yawonele bazi wanhu wose. ");
INSERT INTO zaj_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Lola Mulungu viyali na bwando da ugoli, ng'hungwe na ilimu! Yalihi yodaha kupeta ulamuzi wake? Na yalihi yodaha kuzitanga nzila zake? ");
INSERT INTO zaj_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Kamba Nyandiko Zing'alile vuzilonga, “Kwavija yalihi yozitanga ngelegeza za Mndewa? Ama yalihi yondayawe mulangulizi wake? ");
INSERT INTO zaj_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Yalihi yamgwelele kinhu chochose Mulungu, giladi Mulungu yam'bwezele?” ");
INSERT INTO zaj_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kwavija vinhu vose vilawa kumwake, na vinhu vose vabaha sama yake, na vinhu vose vabaha sama ya kumuyenzi Mulungu. Mulungu yayenzigwe milongo yose. Amina. ");
INSERT INTO zaj_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Avo, ndugu zangu, kubitila bazi da Mulungu, nowayalalila zilaveni ng'huli zenu kamba nhosa ili na ugima, ing'alile na imnogela Mulungu, kwavija ino iyo nhambiko yenu ya ikweli. ");
INSERT INTO zaj_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Sambimuukweleleze ulumwengu uno, ila muhindulwe mkutendigwa wa sambi mnzewele, avo mdahe kulanza na kugatanga gaja goyolonda Mulungu, gaja ganogile, gomnogela na vija viyalekile kuhungula hanhu. ");
INSERT INTO zaj_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Kwavija kubitila bazi dinigweleligwe, nomulongela kila munhu mmwanza wenu, kamba sambimuigelegeze wenyego kamba mweye mwa uchana ng'hani kubanza vija vimuli, ila muwe bule uzenzeleganye mkuigelegeza wenyego, mkuipima wenyego na nhamanila iyawagwelele Mulungu. ");
INSERT INTO zaj_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Kamba vituli tweye tuna lukuli lumwe luli na vipindi bwando, na vipindi vino vose havitenda sang'hano imwe, ");
INSERT INTO zaj_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","na vivija, tweye tuli bwando, twa lukuli lumwe kubitila Kilisto, na kila kipindi choilumba na miyage. ");
INSERT INTO zaj_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Tusang'hanike na nhunza zetu zilekile kuilinga, kulingana na ngekewa ya Mulungu iyatugwelele kila munhu mmwanza wetu. Kamba munhu kana nhunza ya kuhokola, basi yahokole kulingana na nhamanila iyalinayo, ");
INSERT INTO zaj_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","kamba kusang'hanika, basi yasang'hanike, kamba kufundiza, basi yafundize, ");
INSERT INTO zaj_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","kamba kuwagangamiza wanhu, basi yawagangamize, kamba kuwasangila vinhu wanhu wayagwe, basi yawasangile na moyo unogile, kamba kuwalongoza wanhu, basi yawalongoze mkuiyoha, na kamba kuwonela bazi wanhu, basi yawonele bazi na moyo usamhuke. ");
INSERT INTO zaj_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Noge sambidiwe da uzenzeleganye. Mkihile kija kihile, ila mkigoge kija kinogile. ");
INSERT INTO zaj_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Muinogele wenyego kwa wenyego kubitila noge da udugu. Na mkiihishimile wenyego kwa wenyego. ");
INSERT INTO zaj_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Sambimdonhe kuinanahila nhamanila yenu, ila muiyohe muloho mkumsang'hanikila Mndewa. ");
INSERT INTO zaj_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Deng'heni mditamanilo, mwazagany