﻿USE sofia;
DROP TABLE IF EXISTS sofia.zaiNT_vpl;
CREATE TABLE zaiNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zaiNT_vpl WRITE;
INSERT INTO zaiNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Lu gui'chi ri zeeda irá lá xfamilia Jesucristu, xiiñi David ni za de Abraham. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham gupa Isaac, ne Isaac gupa Jacob, ne Jacob gupa Judá ne ca bi'chi'. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ne Judá ne Tamar gupa ca Fares ne Zara, ne Fares gupa Esrom, ne Esrom gupa Aram. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ne de Aram ma zeeda Aminadab, ne Aminadab gupa Naasón ne Naasón gupa Salmón. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ne Salmón ne Rahab gupa ca Booz, ne Booz ne Rut gupa ca Obed, ne Obed gupa Isaí. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ne de Isaí ma zeeda rey David, ne David gupa Salomón, xiiñi ni guca xheela Urías. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ne Salomón gupa Roboam, ne Roboam gupa Abías, ne Abías gupa Asa. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ne de Asa ma zeeda Josafat, ne Josafat gupa Joram, ne Joram gupa Uzías. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ne de Uzías ma zeeda Jotam, ne Jotam gupa Acaz, ne Acaz gupa Ezequías. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ne de Ezequías ma zeeda Manasés, ne Manasés gupa Amón, ne Amón gupa Josías. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ne de Josías ma zeeda Jeconías ne ca bi'chi', ne bibani cabe ca dxi yené ca binni Babilonia laacabe xquidxi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ne dxi ma nuu cabe Babilonia la? gupa Jeconías Salatiel, ne Salatiel gupa Zorobabel. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ne de Zorobabel ma zeeda Abiud, ne Abiud gupa Eliaquim, ne Eliaquim gupa Azor. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ne de Azor ma zeeda Sadoc, ne Sadoc gupa Aquim, ne Aquim gupa Eliud. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ne de Eliud ma zeeda Eleazar, ne Eleazar gupa Matán, ne Matán gupa Jacob. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ne de Jacob ma zeeda José xheela María ne de María gule Jesús ni rabi cabe Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Rarí ridu'ya nu modo za Cristu de Abraham. Gupa Abraham xiiñi', de xiiñi Abraham la? gupa xiiñi', de xiiñi xiiñi be gupa xiiñi ne zacá zeeda ni. De dxi bibani Abraham para dxi sti rey David la? ma bizaa catorce familia. Ne dede dxi sti David para dxi yené ca binni Babilonia ca binni Judá xquidxi ca la? nga sti catorce familia. Ne dede dxi que para dxi sti Cristu, laca sti catorce. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sicarí nga gule Jesucristu: Ma chi iluxe enda xheela sti José ne María peru ca'ru idxiña be laa, bihuinni ma naca xiiñi María xiiñi Espíritu Santu. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ne ora gunna José ma naca xiiñi be la? na nusaana laabe naga'chi purti nacha'hui ne qué ná ireeche ni guidxi. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ngue cá ique José guni, mala uní' né ti ángel sti Dios laa lu bacaanda', na rabi laa: ―José xiiñi David, gucuaa María xheela lu' ne ma cadi ucaa ique lu usaana lu laabe, purti xiiñi Espíritu Santu naca xiiñi be. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ne zapa be ti badu huiini ne zabee lá lu laa Jesús, purti zulá ca xpinni de irá ni huachee ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ne cayaca ni sicarí ti iree ni modo uní' Dios de ruaa dxa profeta ni uní' chiqué: ");
INSERT INTO zaiNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Laguuya ni chi gaca ri': Ti binni dxaapa zaca xiiñi ne zapa ti badu huiini', ne zabee lá cabe laa Emanuel. Ni riní' Emanuel la? nuu né Dios laanu. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ne ora bibani José bi'ni ni gudxi ángel que laa, ne biluxe enda xheela que. ");
INSERT INTO zaiNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Peru qué ñuu be cue' María dede dxi ma gule badu huiini que ne ulee lá be laa Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Gule Jesús ndaani guidxi Belén de Judea dxi zuba rey Herodes. Ne ca dxi que bedandá caadxi hombre nuu xpiaani ne riene de luceru, ndaani guidxi Jerusalén, beeda ca de neza rindani gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ne cananaba diidxa ca paraa gule rey sti ca judíu, purti na cabe biiya cabe ra biree luceru stibe neza rindani gubidxa ne ngue runi zeda ganna cabe laabe para usisaca cabe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ne ora gunna rey Herodes xi zeeda cabe la? bidxibi, laa ne irá ca binni Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Para bisenda caa be ca judíu, cani jma riene de ni cá lu Xqui'chi Dios ne ca xaíque sti ca sacerdote, ne gunaba diidxa be laaca paraa nexhe gale ni rabi cabe Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Para na ca rabi ca laabe: ―Ndaani guidxi Belén de Judea, purti sicarí bicaa ti profeta sti Dios chiqué: ");
INSERT INTO zaiNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Lii Belén, neca jma nahuiini lu lade ca guidxi de Judá, peru nabé risaca lu' purti de lii zaree tobi ni guni mandar ne gapa ca xpinne ni za de Israel. Nga nga ni uní' profeta que. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Oraque bisenda caa be ca hombre ni riene de luceru que naga'chi', ne gunaba diidxa be laaca padxí ti biiya ca luceru que. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ne gudxi be laaca che ca Belén, ne raqué inaba diidxa ca', ne ora ma bidxela ca badu huiini que la? gueda tidxi ca laabe, para che be chi usisaca be laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ngue si gudxi rey que laacabe, biree cabe ze cabe, ne mala biiya cabe za niru dxa luceru que lú cabe, luceru ni bi'ya cabe neza rindani gubidxa que. Para yenanda cabe ni dede ra biaana dxí ni ra nuu badu huiini que. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nabé bieche cabe ora bi'ya cabe luceru que. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ne ora biuu cabe ndaani yoo, biiya cabe badu huiini que ne María jñaa. Para bizuxibi cabe, bisisaca cabe laa ne óraque ulee cabe irá ni bedané cabe, bisiga'de cabe laa oro, gu'xhu' ne nisa rindá' naxhi. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ne ora ma chi ibigueta cabe xquidxi cabe, uní' né Dios laacabe lu bacaanda ma cadi ibigueta cabe neza ra nuu Herodes. Para bigueta cabe adxé neza. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Biree si ca hombre ni riene de luceru que ze', uní' né ti ángel sti Dios José lu bacaanda', na rabi laabe: ―Biasa gucuaa badu huiini ca ne jñaa, laché Egipto ne laguiaana raqué, ne naa gabe laatu padxí ma zanda iree tu de raqué, purti zuyubi Herodes badu huiini ca para guuti. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Huaxhinni queca biasa José gucuaa badu huiini que ne jñaa ne ze ca Egipto. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Biaana cabe raqué dede dxi guti Herodes ti iree ni modo pe uní' Dios de ruaa dxa profeta que ra na Dios: “De ndaani guidxi Egipto bisenda caa Xiiñe'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Biiya si Herodes gudxite ca hombre ni riene de luceru que laa la? gudó dí laa ne bisenda guuti irá ba'du ni chi usaa ru chupa iza, irá ni nabeza ndaani guidxi Belén ne idubi neza que, purti ulee be cuenta mayaca izaa chupa iza dede dxi bi'ya ca hombre nuu xpiaani que luceru que. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ne ra guti irá ca badu huiini que la? biree ni modo pe uní' Dios de ruaa profeta Jeremías chiqué ra na: ");
INSERT INTO zaiNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Bina diaga cabe ucuá ti ridxi ndaani guidxi Ramá, Cayuuna caadxi gunaa de Judá, cani za de Raquel. Bizulú biina ca dede uyuu yuuba ladxidó' ca', ne qué na ca igani ca purti ma guti xiiñi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Peru dxi ma guti rey Herodes la? uní' né ti ángel sti Dios José lu bacaanda ndaani guidxi Egipto, na rabi laabe: ");
INSERT INTO zaiNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Biasa gucuaa badu huiini ca ne jñaa ne laibigueta xquidxi tu, purti ma guti cani gucala'dxi ñuuti badu huiini ca. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Para biasa be gucuaa be badu huiini que ne jñaa ne bigueta cabe Israel, xquidxi cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Peru ora gunna be ma Arquelao zuba jlugar bixhoze ndaani guidxi Judea la? bidxibi be ñe be raqué, ne laca uní' xcaanda be cadi che be. Ngue runi biyubi be Galilea. ");
INSERT INTO zaiNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ne beda ndeza be Nazaret ti iree ni modo pe bizeete ca profeta que de Jesús, na ca': “Zabi cabe laabe binni Nazaret.” ");
INSERT INTO zaiNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ca dxi que beeda Juan Bautista, canayuí' stiidxa Dios ndaani gui'xhi Judea. ");
INSERT INTO zaiNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ne na rabi ca binni que: ―Lainaba perdón Dios, purti ma zeda dxiña dxi guni mandar. ");
INSERT INTO zaiNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sicarí nga uní' Dios de ruaa profeta Isaías chiqué, na: Zuna diaga cabe cucaa tuuxa ridxi ndaani gui'xhi cayabi binni: “Lausiá neza tidi Señor; lauxhele ladxidó' to casi ñaca cuxhele tu ti neza para laabe.” ");
INSERT INTO zaiNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ne irá ni uní' profeta que la? guca ni dxi beeda Juan Bautista. Riaana be ndaani gui'xhi', ne de guicha ladi camellu xhaba be, ne xi' ti cinturón de guidi ndaani be, ne endaró stibe nga usú ne dxiña yaga. ");
INSERT INTO zaiNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ne idubi naca guidxi Jerusalén uyé ra nuu be, ne irá xixé binni de Judea ne de irá ca guidxi ni dxaaga guiigu Jordán. ");
INSERT INTO zaiNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ne ulee ruaa ca diidxa de irá ni huachee ca', ne guluu nisa be laaca ndaani guiigu Jordán que. ");
INSERT INTO zaiNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Peru ora bi'ya be cayeeda stale fariseu ne saduceu ra nuu be para chu' nisa ca la? na be rabi be laaca': ―Binni nexhená ca', ma runebia'ya laatu, zeeda tu ra nuaa purti zácaxa tu tisi chu' nisa tu, ma qué zusaba ná Dios laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yanna lasá jneza ti ihuinni ma unaba tu perdón Dios de idubi ladxidó' to. ");
INSERT INTO zaiNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ne cadi ma iree né tu na tu: “Xiiñi Abraham laadu.” Gabe ca' laatu, pa qué guni tu jneza casi bi'ni be la? dede lade guie ri zanda indisa Dios xiiñi be. ");
INSERT INTO zaiNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ti yaga ni qué ricá cuananaxhi lú, rugá cabe laa ne ruzaaqui cabe laa. Zacaca nga ma zeda dxiña dxi sti irá cani qué runi jneza, laca maca zilá ca lu bele. ");
INSERT INTO zaiNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Naa caguaa ni'sa laatu casi ti seña ma unaba tu perdón Dios, peru nuu stobi ni gueeda ru', ne ngue jma risaca que naa. Naa qué risaca dia' nin para indade xquela guidi be ñee be. Laabe zudii be Espíritu Santu cani guni cre, ne zulaa be cani qué runi cre lu bele. ");
INSERT INTO zaiNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Zeda guni be casi runi tobi ni riguibi semiá, zutopa be ca semiá para uchá be ndaani sacu ne zundaa be ca guixi que lu ti gui ni qué ziuu dxi gyui'. ");
INSERT INTO zaiNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ca dxi que biree Jesús de Galilea, beeda ra nuu Juan ra guiigu Jordán para cu' nisa Juan laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Peru qué na gá Juan cu' nisa laabe, sínuque na rabi laabe: ―Jma naquiiñe cu' nisa lu naa, yanna nou' cuaa ni'sa lii la? ");
INSERT INTO zaiNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Para rabi be laa: ―Zaa, peru bi'ni ni yanna, purti jma naquiiñe guni nu irá ni gudixhe Dios gaca'. Oraque ru guná Juan guluu nisa laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ne casi biluxe uyuu nisa be, biree be de ndaani nisa que, ne mala bixale ibá' ne biiya be zeeda yete Espíritu Santu de ibá', casi ti paloma, biaana dxí luguiá be. ");
INSERT INTO zaiNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Oraque ucuá ti ridxi de ibá': ―Ndi nga Xiiñe ni nadxiee ne ni rusieche naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ne óraque yené Espíritu Santu laabe ndaani gui'xhi ti gu'ya binidxaba pa zuni be ni na. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ne biaana be raqué cuarenta dia sin ño be ne ma candaana dxita be. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Oraque beeda binidxaba ra nuu be, na rabi laabe: ―Pa dxandí Xiiñi Dios lii la? gudxi ca guie ca gaca ca pan. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Para na be rabi be laa: ―Maca cá lu Xqui'chi Dios, cadi pan si nga ibani né binni sínuque irá ca diidxa ni iree de ruaa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Oraque yené binidxaba que laabe ndaani guidxi Jerusalén ni rabi cabe Guidxi sti Dios, ne bidxiiba laabe ique yu'du ro' ra jma nasoo ");
INSERT INTO zaiNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ne na rabi laabe: ―Yanna, pa dxandí Xiiñi Dios lii la? uyuu bi de racá, purti cá lu Xqui'chi Dios zuseenda ca ángel sti para cu' ná xi'que lu ti cadi gacaná lu lu guie. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Para rabi be laa: ―Peru laca cá lu Xqui'chi Dios, cadi inaba cabe xiixa Dios para quite si cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Peru ucuaa ru binidxaba que laabe, yené laabe lu ti dani ni jma nasoo, ne biluí' laabe irá xixé guidxi de idubi naca guidxilayú para gu'ya be pabiá' sicarú cani. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ne na rabi laabe: ―Zudiee lii irá ni pa guzuxibi lu xañee' usisaca lu naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Oraque na be rabi be laa: ―Biree de ra nuaa binidxaba', purti cá lu Xqui'chi Dios, Dios si nga naquiiñe usisaca cabe ne guni cabe ni na. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Oraque ru bixale binidxaba que de laabe, para beeda caadxi ángel bidii ni gudó be. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Dxi gunna be ma yeguyoo Juan Bautista la? bigueta be neza Galilea, ");
INSERT INTO zaiNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","peru qué ñaana be Nazaret xquidxi be sínuque yendeza be sti guidxi lá Capernaum ni nuu uriá ti nisa ro' lá Galilea lade ca layú sti Zabulón ne Neftalí. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ne ra yendeza be ti guidxi de Galilea, guca ni casi uní' Dios de ruaa profeta Isaías chiqué, ra na: ");
INSERT INTO zaiNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Galilea nga xquidxi Zabulón ne Neftalí ni nuu neza ze cabe nisadó', cherica guiigu Jordán, xquidxi cani qué ñunibiá' gá Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bibani ca binni que ndaani guelacahui, peru yanna ma biiya ca ti biaani ro'. Chiqué uyuu ca lu ná enda guti, peru yanna ma biiya ca ximodo zanda iree ca de laani, casi ñaca para laaca ma birá gueela ne ma nuu biaani guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yendá si be guidxi que la? bizulú byuí' né be binni stiidxa Dios, rabi be laaca': ―Lainaba perdón Dios purti ma zeda dxiña dxi guni mandar. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ti dxi canazá be uriá nisa ro' que, biiya be chupa hombre iropa bi'chi ca', cusaba ca ti tarraya ro' ndaani nisa, canaaze ca benda purti nga xhiiña ca'. Tobi que la? lá Andrés, ne stobi que la? Simón ni rabi cabe Pedru. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Para rabi be laaca': ―Lata nanda naa ne laca zune laatu guuze peru para chi yubi tu binni guedané tu ra nuaa'. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ne oraqueca bisaana ca tarraya stica zinanda ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ra ze be que biiya be xhupa hombre, ne laca iropa bi'chi ca', Jacobo xiiñi Zebedeu, ne Juan bi'chi'. Nuu né ca bixhoze ca ndaani ti canuá, cayuni chaahui ca ca tarraya stica'. Para na Jesús rabi laacabe: ―Lata nanda naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ne oraqueca bisaana cabe bixhoze cabe ne bisaana cabe canuá que, zinanda cabe Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Uzá Jesús irá guidxi sti Galilea, bisiidi ndaani ca yu'du sti ca judíu, ne byui' né laacabe ximodo runi mandar Dios ca xpinni. Ne irá ra uyé be bisianda be irá enda huará ne irá yuuba sti ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ne zaqué bireeche stiidxa be de yendá ni irá guidxi sti Siria, ne bedané ca binni que irá binni lidxi ca ni huará, cani napa yuuba', ne cani caguite binidxaba ique, ne cani rudii ataque laa, ne cani ma guti galaa. Bisianda be de irá ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Stale binni uzá nanda laabe, cásica binni Galilea, zaqueca binni de Decápolis, ne de Jerusalén, ne de Judea, ne de cherica guiigu Jordán. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Biiya si Jesús ma rí binni laa, gudxi'ba lu ti dani ne gurí raqué. Oraque bidxiña irá cani jma riuu nú laabe para iziidi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Para bizulú be bisiidi be laaca', na be: ");
INSERT INTO zaiNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Dichoso ni nanna gasti nga laa nezalú Dios, purti stica irá ni napa Dios ladxi ná'. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Dichoso ni nuu triste yanna, purti zaguixhe dxí Dios ladxidó' ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Dichoso ni nadó' purti zudii Dios laaca guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Dichoso ni rinaba ladxidó' guni ni na Dios, ne qué ganda chu' dxí dede qué guni ni, purti zacané Dios laa guni ni, ne zieche'. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Dichoso ni riá stobi, purti laca ziá Dios laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Dichoso ni nayá ladxidó' purti zuuya Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Dichoso ni riguixhe dxí enda ridinde, purti runi xiiñi Dios laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Dichoso ni riladxi binni laa, ti cayuni ni na Dios, purti sti irá ni napa Dios ladxi ná'. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ne dichoso laatu ora rulaa binni diidxa laatu, ne riladxi ca laatu ne ribee ca falsu luguiá tu purti xpinne laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Laguieche' neca cazaaca tu irá nga, purti nabé sicarú ni chi gudii Dios laatu ibá', ne nanna ca tu zacaca bi'ni cabe ca profeta sti Dios chiqué. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Riuu zidi beela para cadi guiu'dxu', ne laatu zeda gaca tu casi zidi, ne nuu tu ndaani guidxilayú para cadi initilú pe ni. Peru pa nidi'di enda naxí sti zidi que la? ma qué niquiiñe ni para gasti sínuque para ixii ni layú ne ñutu ñee cabe ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ra usihuinni tu enda nacha'hui sti Dios lade binni la? casi ñaca cuzaani tu. Laudii lugar ihuinni biaani stitu casi rihuinni biaani sti ti guidxi zuba ique dani. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Purti qué rucaa gui cabe lámpara ne cu' cabe laa xa'na dxumi, sínuque ruzuhuaa cabe ni lu ti mexa' para gudii ni biaani irá binni ni nuu ndaani yoo que. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yanna laatu, lagaca casi biaani que ti gu'ya binni pabiá' jneza runi tu ne usisaca ca Bixhoze tu ni nuu ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Cadi zácaxa tu zeda uchiaya ley ni bidii Dios Moisés, ne ni bicaa ca profeta lu Xqui'chi Dios, purti cadi nga zeda gune' sínuque zeda gune' cumplir irá xixé ni bicaa cabe que. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Peru gabe ca' laatu, laga nuu ru ibá' ne guidxilayú, qué ziaana nin tindaa lu ley sin gaca cumplir, nin ti letra ne nin ti puntu. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nga runi tutiica uchiá neca ti guisi si lu tobi de ca mandamientu ne zacá gusiidi ni binni la? huaxié' zasaca lade ca xpinni Dios. Peru ni guni irá ni na mandamientu, ne usiidi ni binni la? laa huaxa zasaca lade ca xpinni Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Purti gabe ca' laatu, pa qué guni tu jneza jma que modo runi ca maistru de ley ne ca fariseu ni nuu yanna la? qué ziuu tu lade ca xpinni Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Huayuna diaga tu xi gudxi Dios ca bixhoze gola tu chiqué, cadi guuti ca', ne pa guuti ca ziaba ná ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Peru naa rabe laatu, tutiica gapa né stobi xiana la? laca ma bichee ne ziaba ná'. Ne tutiica gabi stobi binni guidxa la? zusaba ná justicia sti yu'du laa. Ne tutiica gabi stobi didxa guidxa la? cuyubi che gabiá. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ne pa zeda saanu ti ofrenda lu altar para Dios ne guietenala'dxu bichee neu tuuxa la? ");
INSERT INTO zaiNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bisaana gá ofrenda stiu' raqué, uyé biene né ni bichee neu que, ne óraque bigueta yetixhe ofrenda stiu' lu altar. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Pa chiné tuuxa lii ra nuu justicia la? biyubi gaca neu laabe tobi si laga ze ru tu neza, ti cadi uchiña be lii lu juez, pacaa zutiidi juez lii lu ná ca gendarme ne zaguu ca lii lidxi guiiba'. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gabe ca' lii, qué zaree lu raqué dede qué qui'xu irá ni nuzaabu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Laatu nanna tu xi na ley: “Iruti chu' né ni cadi xheela'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Peru naa rabe laatu, neca chu'la'dxi si tuuxa ti gunaa ni cadi xheela', ne icá ique chu' né laabe la? ma bichee, neca qué ñuu né pe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Pa nuu xiixa ruuya lu ne ruquiinde ni lii gu'nu ni cadi jneza la? bixele de laani, purti jma huaxié' naná zaca para lii ixele lu de laani bia' naná zaca para lii pa cheu' gabiá, purti qué ziuu dxi ireeu de raqué. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ne pa nuu xiixa ni racala'dxu tidi lu ná lu', ne pur laani chi uchee lu la? bixele de ra nuu ni, purti jma huaxié' naná zaca para lii uniti lu ni, que initilú lu' pa cheu' gabiá. Nga runi pa nuu xiixa ni runi pur gu'nu ni cadi jneza la? bisaana ni nagueenda, pacaa zuchee lu', ne ora ma bichee lu la? zusaba ná Dios lii. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Laatu huayuna diaga tu na lu ley: “Tutiica gacala'dxi gusaana xheela la? gaca divorciar ne laabe.” ");
INSERT INTO zaiNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Peru naa rabe', ni usaana xheela', neca qué nuchee né xheela laa la? cuchee, purti cayuni pur gapa xheela jnadxii. Ne zaqueca tutiica ichaganá ti gunaa ni ma bisaana xheela la? cuchee, purti ma nuu né xheela binni. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Laca huayuna diaga tu xi gudxi Dios ca bixhoze gola tu chiqué: “Tutiica guni jurar chi guni xiixa para Dios la? naquiiñe guni cumplir ni ma uní'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Peru naa rabe laatu, cadi lica pe guni jurar tu, nin pur ibá', purti racá nga zuba Dios, ");
INSERT INTO zaiNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nin pur guidxilayú purti racá zuhuaa ñee be, ne nin pur Jerusalén, purti nga nga xquidxi Rey ni nandxó' ne nga nga Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ne zaqueca cadi guni jurar tu pur ique tu, purti qué zanda guni tu pur indani guicha ique tu adxé color, gaca ni naquichi o nayaase'. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ora riní' tu la? lainí' “ya” pa huandí zuni tu ni, o pa qué zuni tu ni la? lainí' “co'”, peru cadi usiguii tu ne cadi cu' ru tu jma juramentu lú ni, purti cadi de Dios zeeda irá nga. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Huayuna diaga tu xi cá lu ley: “Pa gaxha cabe ti chu lú lu la? guxha ti chu lú cabe. Ne pa gaxha cabe ti laya lu la? guxha ti laya cabe.” ");
INSERT INTO zaiNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Peru naa cayabe laatu, pa ucaa lú cabe laatu la? cadi ucaa lú tu laacabe. Ne pa chu' tu capa ti ladu xhaga tu la? laudii ca né sti ladu. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ne tu gacala'dxi tinde né laatu para gaxha xcamixa tu la? lausaana né ca laa xhamarra tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ne pa chu' tobi de cani runi mandar uguá' laatu bultu sti' ti kilómetru la? laguá' ni chupa kilómetru. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ni inaba xiixa laatu, laudii ni laa, ne ni qui'ñe laatu, lautiiñe laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Laca na ley ganaxhii tu cani nadxii laatu, ne gaca nanala'dxi tu cani nanala'dxi laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Peru naa rabe': Laganaxhii cani nanala'dxi laatu, ne lainí' né Dios pur cani riguu dí laatu. Lagacané cani runi pur uchiichi laatu, ne lainaba lu Dios pur cani riladxi laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Laguni zacá ti chi ndee tu Bixhoze tu ni nuu ibá', purti laa rudii lugar guzaani gubidxa sti ra nuu cani nacha'hui ne ra nuu cani nadxaba', ne rusaba nisa guie ra nuu cani runi ni na, ne ra nuu cani qué runi ni na. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Purti pa ganaxhii tu cani nadxii si laatu la? ñee na tu zacaa tu xiixa de Dios pur nga la? Cadi xa laca nga ca runi cani ruquixe impuestu, ne napa tu laaca de malu. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ne pa gulabi tu cani ridxaaga si laatu la? xi caguu tu lú ni ya'. Cadi xa laca nga ca runi cani qué runibiá' Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nga runi lagaca nacha'hui ne irá binni, cásica nacha'hui Bixhoze tu ni nuu ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Laguuya gá qué chi guni tu ni nacha'hui nezalú si binni para si gudxiiba ca laatu. Purti pa guni tu ni para si gu'ya binni la? qué zacaa tu gasti de Bixhoze tu ni nuu ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nga runi cadi guni tu casi runi cani na nacha'hui peru cadi dxandí ni laa, purti ora chi gudii ca guna ndaani yu'du o lu calle, rucaa ca ridxi para ganna binni xi bidii ca', peru ngue si nga laani. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Peru laatu ora gudii tu guna la? laguni ni pa ganda nin cadi ganna ti chu ná tu xi cayuni sti chu, ");
INSERT INTO zaiNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ne zacá qué zanna iruti pa cudii tu guna sínuque Bixhoze si tu ni ruuya ni runi binni ra naga'chi', ne laa nga quixe ni bi'ni tu que. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ne ora iní' né tu Dios la? cadi guni tu casi ca binni ni na nacha'hui peru cadi dxandí ni laa. Riula'dxi ca uzuhuaa ca ndaani yu'du para ini' né ca Dios. O pacaa la? runi ca ni lu calle para gu'ya binni. Gabe ca' laatu, zaa usisaca binni laacabe peru ngue si nga laani. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Peru laatu, ora chi iní' né tu Dios la? lachuu ndaani lidxi tu, lauseegu ra puerta ne lainí' né Bixhoze tu ni qué rihuinni, ti laa ruuya ni runi binni ra naga'chi', ne zaguixe laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ne ora ma caní' né tu laabe la? cadi utale tu diidxa casi runi ca binni ni qué runibiá' Dios, purti zácaxa ca tisi iní' ca stale diidxa zucaa diaga be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nga runi cayabe laatu, cadi gaca tu casi laacabe, purti maca nanna Bixhoze tu xii nga caquiiñe tu ante inaba tu ni laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Peru laatu la? sicarí nga lainí' né Dios: Bixhoze du ni nuu ibá', rinaba du gusisaca irá binni lii. Ne idxiña dxi guni mandar lu' ");
INSERT INTO zaiNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ne gaca ni na lu'. Cásica raca ni ibá', zaqueca gaca ni ndaani guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Dané laadu endaró tidi né du dxi. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bisiaanda ni ruché' né du lii, casi rusia'nda du ni ruchee né cabe laadu. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ne cadi udiiu lugar cuba yu binidxaba laadu, sínuque bilá laadu de lu ná be. Purti lii nga jma nandxó' lo' ne jma risaca lu que irá xixé, ne qué ziuu dxi guiaana dxí lu de guni mandar lu'. Amén. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Pa guni perdonar tu ni guni binni laatu la? laca zuni perdonar Bixhoze tu ni nuu ibá' laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Peru pa qué guni perdonar tu ni guni binni laatu la? laca qué zuni perdonar Bixhoze tu ni nuu ibá' laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ne ora gusaana tu de go to para iní' né tu Dios la? cadi guni tu lú tu nayati casi runi cani riula'dxi udxiiba binni laa, purti runi ca lú ca nayati para si gu'ya binni biaana ca sin ño ca'. Gabe ca' laatu zaa usisaca binni laacabe peru ngue si nga laani. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Peru pa guiaana tu sin go to la? lauzaa begu ique tu, ne laquiibi lú tu, ");
INSERT INTO zaiNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ti qué ganna iruti pa biaana tu sin ño to sínuque Bixhoze si tu ni qué rihuinni, ti laa nga nanna ne ruuya ni runi binni ra naga'chi ne laa nga quixe ni laatu nezalú binni. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Cadi guyubi tu gapa tu stale ni risaca ndaani guidxilayú ri', purti zanda go bandaa ni ne icá tini ni ne chu' gubaana cuana ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sínuque laguyubi gapa tu ni risaca ibá' purti ngue qué zo bandaa laa ne qué zacá tini ne qué ziuu gubaana cuana laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Purti ra nuu ni risaca para laatu la? raqueca nuu ladxidó' to. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Guielú tu nga zeda gaca casi biaani sti cuerpu stitu. Nga runi pa ruyubi tu gu'ya tu ni jneza la? ziaani xquenda biaani tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Peru pa ruyubi tu gu'ya tu ni cadi jneza la? zacahui xquenda biaani tu. Ne pa ñui' ni napa tu de biaani ca la? pabiá' nacahui ñaana tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Iruti zanda gapa chupa xpixuaana ne guni ni na iropa cabe tobi si tiru, purti jma zanaxhii be tobi ne zaca nanala'dxi be stobi, o pacaa jma zacá nú be ngue ne qué zazaala'dxi be stobi que. Zaqueca qué zanda di ganaxhii tu Dios ne ganaxhii ca tu bidxichi. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nga runi cayabe laatu cadi cu' xa ique tu ximodo ibani tu, xi go to o xi gue tu, nin cu' xa ique tu xi cuaqui tu. Purti cadi para go si tu napa tu enda nabani, ne cadi para cuaqui si tu lari nuu tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Laguuya ca mani huiini ni ripapa. Qué riguu ca biní ne qué ribee ca guela, ne qué ruchá ca troja, peru rudii Bixhoze tu ni nuu ibá' ni go ca'. Ñee cadi jma risaca tu que laacame la? ");
INSERT INTO zaiNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Neca ñuu tu xizaa ne nuyubi tu modo nibani tu xcaadxi, ñee ñanda nibani tu jma que bia' dxi nexhe ibani tu la? ");
INSERT INTO zaiNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ne xiñee riuu tu xizaa pur ni gacu tu ya'. Laguuya modo rigaa ca liriu ni nuu ndaani gui'xhi', neca qué runi ca dxiiña ne qué riguiba ca', ");
INSERT INTO zaiNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","peru nin rey Salomón qué ñanda nuzuchaahui casi laacani neca nabé bisaca. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ne pa ruzuchaahui Dios ca guie' gui'xhi neca yanadxí si nagá' ca' ne ixí ma bibidxi ca para icá gui ca la? ñee qué runi cre tu pa zudii be ni cuaqui tu la? ");
INSERT INTO zaiNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nga runi cadi chu' tu xizaa ne cadi na tu: “Xi idó' no, o xi idé' nu, o xi gacu nu ya'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Purti nga nga ni ruyubi ca binni ni qué runibiá' Dios, peru ma nanna Bixhoze tu ni nuu ibá' xi irá cayaadxa laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Peru nirudó' laguyubi guni mandar Dios ndaani ladxidó' to ne sa tu modo na, ne óraque zudii laatu cani riuu tu xizaa pur laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nga runi cadi chu' tu xizaa de ni chi gaca ixí', purti ixí ru nga gu'ya tu xi gaca'. Lagucaa ique si de ni naquiiñe tu yanadxí. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Cadi gudxiiba lu donda ique stobi, ti qué quiba donda ique lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Purti donda ca gudxiiba lu ique stobi que, ngue ca guiaana luguiá lu'. Purti cásica gu'nu stobi la? zaqueca gaca lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Pa nuu tindaa bandadi ndaani lú lu la? ximodo zanda gu'ya lu tindaa guixi nuu lú stobi ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ñee za'bu stobi que: “Dané cuee guixi nuu lú lu ca”, ne lii zaa nuu bandadi que lú lu la? ");
INSERT INTO zaiNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Cadi quite lu binni, gulee ca bandadi nuu lú lu ca, ti ganda gu'ya chaahui lu para cueeu guixi ni nuu lú stobi. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Cadi gudii tu xiixa ni zeeda de Dios cani qué iquiiñe para laani, casi ñaca nudii tu ni bi'cu'. Zanda ca guni cabe casi runi bi'cu', ucaa lú cabe laatu ne guxuuxe cabe laatu. Risaca stiidxa Dios casi ti perla, ne qué ñuu dxi nundoou perla lu bihui para guxhaata ñee si ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Lainaba lu Dios, zudii laatu. Lauyubi, zadxela tu. Lauxhidxi ná', zaxele chu' tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Purti tutiica inaba zacaa, ne ni uyubi zadxela, ne ni uxhidxi ná zaxele chu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Lácaxa nuu tuuxa lade tu, pa ninaba xiiñi laa ti gueta, nudii ti guie. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O pa ninaba be laa ti benda, ñee nudii laabe ti beenda la? ");
INSERT INTO zaiNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pa laatu cadi nacha'hui tu casi Dios ne nanna tu gudii tu ni galán xiiñi tu la? lágaxa Bixhoze tu ni nuu ibá' qué gudii ni galán cani inaba laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nga runi, irá ni racala'dxi tu guni binni laatu la? ngue ca laguni laaca', purti zacá nga na ley ne nga ca bicaa ca profeta. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Laguiuu neza ni napa puerta nabé', purti neza ni xilaga puerta sti la? nga neza ladu rinitilú binni, purti ruluí' jma galán neza que, ne stale tu riuu ladu que. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Peru neza enda nabani la? jma nabé puerta ne nagana neza sti', ne huaxié' tu ridxela ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Laguuya gá laatu ne ca profeta ni na zeeda de Dios peru cadi dxandí ni, purti casi guiuu cabe laatu ruluí' nadó' cabe casi dendxu', peru ndaani ladxidó' cabe naduxhu cabe casi gueu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Peru zahuinni lu xhiiña cabe tu laacabe ne pa dxandí zeeda cabe de Dios. Ñee na tu zanda icá uva lu yaga guichi biruba', o icá du'ga lu yaga bii la? ");
INSERT INTO zaiNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ndi nga laani: ti yaga ni nazaaca, zudii cuananaxhi galán, peru ti yaga yuudxu la? zudii cuananaxhi ni qué zaquiiñe'. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ti yaga ni nazaaca la? qué zacá bi'xhu cuananaxhi sti', ne zaqueca ti yaga qué iquiiñe la? puru bi'xhu ricá lú. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Irá yaga ni qué rudii cuananaxhi cha'hui la? rugá cabe laa para icá gui. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nga runi rabe laatu, pur ni guni cabe zacabiá' tu tu laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Cadi irá ni gabi naa, Señor, Señor, ziuu ra runi mandar Dios, sínuque cani guni si ni na be. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Stale tu zabi naa dxi que: “Señor, ñee cadi byuí du stiidxa lu la? ne cadi pur lá lu gulee du binidxaba de binni la? ne cadi laca pur lá lu bini du stale milagru la?” ");
INSERT INTO zaiNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Oraque zabe laaca': “Qué runebia'ya laatu. Laguiree de ra nuaa', purti qué ñuu dxi ñuni tu jneza.” ");
INSERT INTO zaiNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nga runi tutiica gucaa diaga ca diidxa ri' ne guni ni na cani la? zeda gune laa casi ti hombre ni nuu xpiaani', bicuí lidxi lu guie. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Biaba nisa guie bidxá guiigu', biete bi yooxho', ne irá nga bidxela saa yoo que, peru qué ñaba ni purti zuba ni lu guie. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Peru tutiica gucaa diaga ca diidxa ri' ne qué guni ni na cani la? zeda gune laa casi ti hombre huati ni bicuí lidxi lu yuxi. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Biaba nisa guie, bidxá guiigu', biete bi yooxho' bidxela saa yoo que, ne dede uxidxi ra bixá ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ne ora biluxe uní' Jesús irá nga, nabé bidxagayaa ca binni que modo bisiidi be, ");
INSERT INTO zaiNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","purti bisiidi be casi rusiidi tobi ni zanda guni mandar, ne cadi casi rusiidi ca maistru de ley. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ne ora biete Jesús de lu dani que, yenanda stale binni laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Lade ca binni que zeeda ti hombre huará, napa lepra. Bidxiña be bizuxibi be xañee Jesús ne na be rabi be laa: ―Señor, nanna zanda gusianda lu naa, pa na lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Para gudixhe ná Jesús luguiá be ne rabi laabe: ―Zusianda lii. Ne oraqueca bianda be ne nayá biaana ladi be. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Para na Jesús rabi laabe: ―Biiya gá qué chi tidxu ni iruti', sínuque uyé ra nuu sacerdote ne bidii ti ofrenda casi bicaa Moisés guni binni ora ma bianda, para uluí' lu binni ma bianda lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ne ora ziyuu Jesús ndaani guidxi Capernaum, bidxiña ti capitán ne na rabi laa: ");
INSERT INTO zaiNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","―Señor, rinaba lii gusianda lu ti mozo stinne'. Nexhe be ralidxe', ma guti galaa be, ne cayudu yuuba laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Para rabi be laa: ―Ziaa' ne zusianda laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Oraque na capitán que rabi laabe: ―Iruti nga naa para cheu' ralidxe'. Uní' si, ne zacá zianda mozo stinne'. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Purti nuu tu runi mandar naa ne laca nuu ca soldadu ne rune mandar laaca'. Pa gabe tobi che la? zie, ne pa gabe stobi gueeda la? zeeda, ne pa gabe mozo stinne', bi'ni ndi la? zuni. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ora bina diaga be xi uní' xaíque que la? bidxagayaa be ne na be rabi be cani nanda laabe que: ―Laguuya', nin lade cani za de Israel qué huadxela nin tobi ni napa fe bia' napa hombre ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ne gabe ca' laatu ziuu dxi gueeda stale binni de idubi naca guidxilayú ne ziuu né ca Abraham ne Isaac ne Jacob ra runi mandar Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Laga cani nexhe ñuu, ca ngue pe qué ziuu, sínuque zalá ca lu guelacahui purti qué ñuni cre ca', ne raqué gu'na ca' dede go yaa ca guidi ruaa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ne óraque rabi be capitán que: ―Guyé yanna, ne cásica bini cre lu ca, zacá zaca ni. Ne dxandí oraqueca bianda mozo que. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Oraque guyé Jesús ralidxi Pedru, ne biiya nexhe né suegra be xindxá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Para guda'na Jesús ná suegra be ne biree xindxá' que de laa. Ne oraqueca biasa gunaa que bidii ni gudó cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Huaxhinni que bedané cabe stale binni ni caguite binidxaba ique, ra nuu Jesús. Ne ti diidxa si uní' be biree ca binidxaba que. Ne laca bisianda be stale binni huará. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ne guca ni zaqué ti iree ni modo pe uní' Dios de ruaa profeta Isaías chiqué: ―Gucuaa be irá yuuba stinu ne ziné be ca enda huará. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ti tiru biiya Jesús ma rí binni laa, para gunaba tidi sti ladu nisa Galilea que. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Peru nuu ru be raqué beeda ti maistru de ley ra nuu be, na rabi laabe: ―Maistru, racaladxe chi nanda lii ratiica che lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Para rabi be laa: ―Ca mistu gui'xhi napa ca ra guiaana ca', ne ca mani huiini laca napa ca lidxi ca', peru naa nga Hombre Biseenda Dios ne qué gapa nin ra quixhe ique'. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ne laca beeda tobi de ca discípulu stibe ra nuu be, na rabi laabe: ―Señor, bidii lugar ucaache sia' bixhoze ti chi nanda lii. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Peru na be rabi be laa: ―Dananda naa. Bisaana nga guni cani qué na gueda nanda naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Biuu be ndaani canuá que ne laca biuu ca discípulu stibe. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ne mala biete ti bi yooxho', ne biasa ola dede biuu nisa ndaani canuá que, peru ma nisiaasi be óraque. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Para bicuaani ca laabe, ne na ca rabi ca laabe: ―Gucané laadu, pacaa zati nu. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Para rabi be laaca': ―Xiñee cadxibi tu. Aque huaxié' napa tu fe xa, hombre ca'. Oraque biasa be ne gudxi be bi yooxho que guiaana dxí, ne zaqueca gudxi be ca ola que, ne oraqueca guta dxí cani. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nabé bidxagayaa ca hombre que ne na ca': ―Tu naca hombre ri pue, dede bi ne nisa runi ni na. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ra yendá cabe cherica nisa que, biuu cabe neza Gadara. Ne raqué bidxaga lú be chupa hombre ni riguite binidxaba ique, biree ca de lade ba'. Iruti randa ridi'di neza ra nuu ca' purti ricá ca luguiá binni. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ne bicaa ca ridxi laabe, na ca': ―Xi napa né du lii, Jesús, Xiiñi Dios. Ñee zeda guniná lu laadu ante ganda dxi la? ");
INSERT INTO zaiNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Zitu huiini de ra nuu cabe que, canayó jma bihui. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Para na ca binidxaba que rabi laabe: ―Pa chi ndeeu laadu de ca hombre ri la? bidii lugar chu' du luguiá ca bihui rica'. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Oraque rabi be laaca': ―Laché. Ne oraqueca biree ca yechuu ca luguiá ca bihui que, ne mala biete ti ca bihui que de ra dxi'ba ca', yeguiaba ca ndaani nisa ne raqué guti ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Oraque bixooñe cani cayapa laacame, de yendá ca ndaani guidxi que, ne byui' né ca irá binni xi guca', ne ni bizaaca ca hombre ni udxite binidxaba que. ");
INSERT INTO zaiNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Para biree idubi guidxi que yechaga lú ca Jesús ne gudxi ca laabe iree be de xquidxi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Oraque biuu Jesús ndaani ti canuá ne udi'di sti ladu nisa que, para biuu xquidxi. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Raqué nuu be bedané cabe ti hombre nexhe lu ti luuna', ma guti galaa. Ora bi'ya be pabiá' napa cani bedané binni huará que fe la? na be rabi be laa: ―Bieche, xiiñe', purti ma bine perdonar xpecadu lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nuu caadxi maistru de ley raqué ne caní' ca ndaani ladxidó' ca', na ca': “Cayuni ndi laa Dios.” ");
INSERT INTO zaiNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Peru ma nanna Jesús xi caní' ique cabe, para na rabi laacabe: ―Xiñee caní' tu ni cadi jneza ndaani ladxidó' to. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yanna lagabi naa, uná nga jma qué igana ya', gabe laabe ma uca perdonar xpecadu be la? o gabe laabe guiasa be ne sa be. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Naa nga Hombre Biseenda Dios ne para ganna tu zanda gune perdonar pecadu ndaani guidxilayú ri la? laguuya ni chi gune ri'. Oraque na be rabi be ni huará que: ―Biasa, undisa jluuna lu' ne uyé rali'dxu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Oraqueca biasa hombre que, zibí'. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ora bi'ya ca binni rí raqué ni bi'ni be que la? bidxibi ca ne bisisaca ca Dios pur enda nandxó' ni gudixhe lu ná binni guni. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","De raqué biree Jesús ze', ne neza ze be que biiya be ti hombre lá Mateu zuba ruaa ti mexa ra ritixe binni impuestu. Para rabi be laa: ―Dananda naa. Ne oraqueca biasa, zinanda laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ti dxi zuba be ruaa mexa ndaani ti yoo. Raqué zuba be beeda caadxi de cani ruquixe impuestu ne cani qué rulabi ley, gurí né ca laabe ne ca discípulu stibe. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ne ora bi'ya ca fariseu zuba né Jesús laacabe la? na ca rabi ca ca discípulu que: ―Xiñee zuba né jmaistru tu ca malu ni ruquixe impuestu ne cani qué rulabi ley pue. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ngue bina diaga Jesús, para na rabi laacabe: ―Cadi caquiiñe cani nazaaca doctor sínuque cani huará. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ndi nga ni gudxi Dios binni chiqué: “Jma racaladxe guiá tu binni, que guedané tu ni gusiga'de tu naa.” Yanna cayabe laatu laché ne laiziidi xi na ca diidxa ca, purti cadi zeda yube cani nacha'hui sínuque cani cuchee. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Oraque beeda ca discípulu sti Juan Bautista ra nuu be, ne na ca rabi ca laabe: ―Xiñee laadu ne ca fariseu, stale tiru riaana du sin idó' do, peru ca discípulu stiu' qué runi ca zacá. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Para rabi be laaca': ―Ziuu xa cani nuu ra enda xheela triste laga nuu novio lade ca'. Peru ora ma biaaxha cabe novio que la? óraque huaxa ziaana cabe triste. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Iruti ruquiidi tindaa lari cubi ra ma gureza ti lari yooxho', purti ora guia'ri lari que, zadopa lari cubi que ne zareza ra bidiiba que, ne jma rusi qué zaquiiñe ni óraque. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Laca qué rigaa cabe vinu cubi ndaani guidi yooxho' purti nireza guidi que, ne nixii vinu ne niniti guidi que. Peru ni runi cabe la? rigaa cabe vinu cubi ndaani guidi cubi ne óraque nin tobi nin stobi qué zaniti. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Caní' ru Jesús ora biuu ti hombre naca xaíque sti yu'du', bizuxibi xañee be ne na: ―Nagasi du' guti xiiñe', peru pa che lu quixhe ná lu luguiá be la? zabani be. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Para biasa né be ca discípulu stibe, zinanda cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ne ra zidi'di be que biree ti gunaa ma napa doce añu de caxii rini, bidxiña neza deche be ne guda'na ñee lari ni nacu be, ");
INSERT INTO zaiNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","purti na neca xhaba si be cana, zianda. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ne ora guda'na gunaa que xhaba be la? bidxigueta lú be, biiya dxí be laa ne na be: ―Cadi idxibi lu, xiiñe'. Bianda lu purti bini cre lu'. Ne oraqueca bianda gunaa que. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ora bedandá be ralidxi xaíque que, biiya be ma nuu músicu cuxhidxi son gue'tu ne rí jma binni raqué cayuni ruidu. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Para na be rabi be laaca': ―Laguiree, purti cadi guti di dxapa huiini ri', sínuque nisiaasi si. Ne óraque bixidxi ca binni que laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Biree si ca binni que fuera biuu be ndaani yoo, ne gunaaze be ná dxapa huiini que para biasa. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ne bireeche ni bi'ni be que idubi naca guidxi que ne xcaadxi guidxi ni nuu gaxha de raqué. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","De raqué biree be ze be, ne yenanda chupa ni nacheepa lú laabe, bicaa ca ridxi na ca': ―Xiiñi David, biá laadu. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Oraque biuu be ndaani ti yoo ne beeda cani nacheepa lú que ra nuu be. Para rabi be laaca': ―Ñee runi cre tu zanda gusianda laatu la? ―Runi cre du, Señor, na ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Oraque guda'na be lú ca ne na be: ―Pa dxandí runi cre tu zanda gune ni la? zusianda laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ne oraqueca bixele lú ca', ne biinda ca be lú ca cadi gabi ca ni iruti'. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Peru laaca laga bicheeche ca stiidxa be idubi naca guidxi que. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nécati ziree cani bianda que, biuu xcaadxi binni, né ca ti hombre ni qué randa riní' purti riguite binidxaba ique. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Peru casi gulee Jesús binidxaba que la? uní' be. Ne nabé bidxagayaa irá binni ni nuu raqué ne na ca': ―Qué huayuu dxi ihuinni cosa sicarí lade ca xpinni Israel, pa cadi yanna ru'. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Peru ca fariseu na ca': ―Nuu né be xaíque sti binidxaba', nga runi randa ribee be ca binidxaba ni riguite ique binni. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ne guzá Jesús irá guidxi ro' ne irá guidxi huiini', canausiidi ndaani ca yu'du', ne canayuí' né laacabe ximodo runi mandar Dios ca xpinni, ne canausianda irá enda huará ne irá yuuba ni napa ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ora bi'ya be irá ca binni que la? biá be laaca', purti qué ganna ca xi guni ca ne iruti cayaca né laaca'. Nuu ca casi dendxu ni qué gapa pastor. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Para rabi be ca discípulu stibe: ―Ma stale binni cabeza si ucaa diaga stiidxa Dios. Tu güi ni nga huaxié'. ");
INSERT INTO zaiNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yanna lainaba lu Dios useenda stale tu guni dxiiña ca, ti laabe nga xpixuaana ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Oraque guridxi be doce discípulu stibe que ne gudixhe be irá ndi ladxi ná ca': cuee ca binidxaba ni riguite ique binni, ne gusianda ca intiica enda huará ne yuuba'. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ndi nga lá doce apóstol que: primé ca Simón, ni rabi cabe Pedru, ne Andrés bi'chi', raqué ma nanda Jacobo xiiñi Zebedeu, ne Juan bi'chi'. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Raqué ma nanda Felipe, ne Bartolomé, ne Tomás ne Mateu ni biquixe impuestu chiqué, ne Jacobo xiiñi Alfeu, ne Lebeu ni rabi cabe Tadeu, ");
INSERT INTO zaiNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ne Simón ni guyuu lade ca cananista chiqué, ne Judas Iscariote ni bitoo Jesús que. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Biseenda be idubi doce que, peru ora ma chi iree ca', na be rabi be laaca': ―Cadi che tu ra nuu cani cadi judíu, ne cadi guiuu tu xquidxi ca samaritanu. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Laché ra nuu cani za de Israel, cani ruluí' dendxu ni cananiti. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ne lagabi laaca ma zeda dxiña dxi guni mandar Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Lausianda cani napa lepra ne xcaadxi enda huará, ne lausibani cani ma guti, ne lacuee ca binidxaba ni riguite binni. Qué niguixe tu saca gudixhe irá ndi lu ná tu guni tu. Yanna laguni cani sin guiaxa tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Cadi chiné tu oro, nin plata, nin cobre, ");
INSERT INTO zaiNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ne cadi chiné tu ra idxá ni iquiiñe tu ladu ze tu, nin chiné tu chupa muda lari, nin chupa par guela guidi, nin bastón, purti naquiiñe udii cabe ni go ni canayuni dxiiña'. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ne guidxi tiica chu' tu, pa guidxi huiini o pa guidxi ro', lainaba diidxa ralidxi tuuxa ni nacha'hui', ne laguiaana ralidxi be de ora ma ixele tu de guidxi que. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ne ora guiuu tu ralidxi cabe, laugapa diuxi. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ne ora ma nuu tu raqué, lacuu ndaaya yoo que, ne pa aca cabe nacha'hui ne laatu la? ziaana ndaaya stitu ndaani yoo que, peru pa co' la? zabigueta ni luguiá tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pa nuu paxaraa qué na cabe guiaana tu, ne qué na cabe gucaa diaga cabe laatu la? laguiree de ra yoo que, o de guidxi que, ne ora ma chi iree tu de raqué la? laquibi ñee tu, ti cadi chiné tu nin yu stícabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ne gabe ca' laatu, dxi cuidxi Dios cuenta binni guidxilayú la? jma pe zusaba ná be ca binni guidxi que, que ca binni Sodoma ne Gomorra. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Cuseenda laatu casi ñaca nuseenda dendxu lade gueu'. Nga runi lagataná casi nexhená beenda'. Peru laca lagaca nadó' casi nadó' paloma. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Laguuya gá laatu ne ca binni que purti ziné ca laatu ra nuu ca justicia stica ni nuu ndaani yu'du ne zaguiñe ca laatu raqué. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Zuchiña cabe laatu ra nuu ca gobernador ne ra nuu rey purti xpinne laatu, ne zacá laca zanda güi tu stiidxa nezalú cani cadi za de Israel. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ne ora uchiña cabe laatu raqué la? cadi chu' tu xizaa xi iní' tu nezalú cabe o xi gabi tu laacabe. Purti ora ma zuhuaa tu nezalú cabe la? zadxela tu xi iní' tu, ");
INSERT INTO zaiNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","purti cadi laadi tu chi iní' tu sínuque Espíritu sti Bixhoze tu ni nuu ibá' nga che de ruaa tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Zadxiña dxi neca bi'chi cabe zuluí' cabe para gati', ne zaqueca zuluí' bixhoze cabe laacabe, ne laca ziuu tu guiasa luguiá bixhoze ne guluí' bixhoze para gati'. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Zaca nanala'dxi cabe laatu purti xpinne laatu. Peru cani qué ixhacala'dxi dede dxi iluxe irá ni la? zalá. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pa iladxi cabe laatu ndaani ti guidxi la? laché sti guidxi purti gabe ca' laatu neca guni tu zacá, ca'ru iluxe tidi tu irá guidxi sti Israel dxi ibigueta Hombre Biseenda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Qué risaca ni caziidi jma que maistru sti', ne zaqueca qué risaca mozo jma que xpixuaana'. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nga runi cadi quiche ruaa ni caziidi pa guni cabe laa ni runi ca cabe maistru sti'. Pa gabi cabe xpixuaana ti yoo binidxaba la? irá cani nuu né laa ndaani yoo que laca zabi cabe ni laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Nga runi cadi idxibi tu laacabe, purti ziuu dxi ihuinni irá ni ye'gu lú yanna, ne zaqueca ziuu dxi ganna binni irá ni ga'chi'. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ni gabe laatu naga'chi', laatu lainí' ni nezalú binni, ne ni usiide laatu xa diaga si tu la? laqui'ba ique yoo ne lainí' ni reciu. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ne cadi idxibi tu cani ruuti cuerpu si, purti qué zanda guuti cabe alma, sínuque laidxibi ni zanda unitilú alma ne cuerpu ndaani gabiá. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Laaca tu nanna tu ridoo chupa mani huiini pur chupa domi', peru neca qué risaca came, qué ziaba si tobi de laacame layú pa qué na Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Zaqueca ma bigaba be irá xixé guicha ique tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nga runi cadi idxibi tu, purti jma risaca tu que ca mani huiini'. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Tutiica iní' xpinne laa nezalú binni la? laca zanié xpinne laa nezalú Bixhoze ni nuu ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Peru ni qué ná iní' pa xpinne laa nezalú binni la? laca qué zanié pa xpinne laa nezalú Bixhoze ni nuu ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Cadi zácaxa tu zeda gune binni guidxilayú tobi si, purti cadi nga zeda gune sínuque casi ñaca zedaniá ti espada. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Purti zeda ndaa saa hombre ne bixhoze, ne badu dxaapa ne jñaa, ne gunaa ne suegra. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ne ca binni lidxi pe hombre zaca nanala'dxi laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Tu jma nadxii bixhoze o jñaa que naa la? qué zaquiiñe para xpinne', ne zaqueca tu jma nadxii xiiñi que naa la? qué zaquiiñe para xpinne'. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ne tu qué na gacaná ra gueda nanda naa la? qué zaquiiñe para xpinne'. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ni guyubi ilá xpida ndaani guidxilayú la? zuniti ni ibá', peru ni guniti xpida pur naa guidxilayú la? zadxela ni ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Tu uchagalú laatu la? casi ñaca nicaa naa, ne tu icaa naa la? casi ñaca nicaa ni biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pa nuu tuuxa uchagalú ni canayuí' stiidxa Dios purti Dios biseenda laa la? bia'ca quixe Dios ni canayuí' stiidxa que la? bia' queca quixe laabe. Ne pa nuu tobi ni ruchagalú tutiica ni nacha'hui la? bia'ca quixe Dios ni nacha'hui que la? bia' queca quixe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tutiica uchagalú tobi de ca xpinne ni jma nahuiini ri' ne gudii laabe neca ti vasu nisa purti xpinne laabe la? qué ziaana sin qué quixe Dios laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ne biluxe gudxi si Jesús ca discípulu que xi naquiiñe guni ca la? biree de raqué ze', ziusiidi ne zigüí stiidxa Dios ndaani xquidxi irá cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","De ra yeguyoo Juan Bautista gunna de irá ni cayuni Cristu, para biseenda chupa discípulu sti ra nuu be. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ne ora yendá ca ra nuu be, na ca rabi ca laabe: ―Na Juan pa lii nga ni nexhe gueeda o pa zabeza du stobi. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Para rabi be laaca': ―Lachitidxi Juan irá ni cayuuya tu ne ni cayuna diaga tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Lagüí' né laabe ma riná cani nacheepa lú, ma rizá cani nachiita ñee, ma bianda cani gupa lepra, ma runa diaga ca diaga cuaata', ne ma bibani cani ma guti, ne ma cayuna diaga ca pobre stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Dichoso cani guni cre Dios biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Biree si cani biseenda Juan que, bizulú Jesús bizeete laabe lú ca binni que, ne na rabi laacabe: ―Tuu nga yeguuya tu ndaani gui'xhi chiqué. Ñee yeguuya tu tobi ni ruluí' ti gueere lase ni runiibi bi laa ladu na la? ");
INSERT INTO zaiNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Pa cadi nga la? tuu nga yeguuya tu. Ñee yeguuya tu ti hombre zuchaahui la? Co' nja', purti ni zuchaahui zadxela tu laa ndaani lidxi rey. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tu pe nga yeguuya tu ya'. Ti profeta la? Nga nga laani, ne jma que ti profeta. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","De laabe nga ruzeete Xqui'chi Dios ra na: Zuseenda ti xpinne sa niru lú lu' para guni chaahui neza tidi lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","De lade irá binni, qué huaree tobi jma nandxó' que Juan Bautista, peru nuu tu jma nandxó' que laabe ne nga nga tutiica guiuu lade ca xpinni Dios, neca huaxié' laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Dede dxi beeda Juan ma cadale xpinni Dios ndaani guidxilayú, ne cayuuya ca stale enda nandxó' stibe, peru laca stale tu racala'dxi gaca xpinni be peru modo na, cadi modo na be. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ma xadxí uní' ca profeta ne laca cá ni lu ley sti Moisés zadxiña dxi gu'ya binni gaca irá ni cayaca yanna ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ne pa na tu guiene tu ca diidxa ri la? ziene tu Juan nga Elías ni uní' ca profeta que gueeda. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tu racala'dxi guiene la? gucaa diaga. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Tu zanda gusaca ca binni nuu yanna ri'. Rusaca laacabe casi xcuidi ni ribí luguiaa ne rucaa ridxi xcompañeru: ");
INSERT INTO zaiNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Bixhidxi du saa peru qué niná tu nuyaa tu, ne bixhidxi du son gue'tu ne laca qué niná tu ñuuna tu.” ");
INSERT INTO zaiNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Zacá ca runi ca binni ri', purti beeda Juan, ne biiya cabe qué ño ne qué ñe', para na cabe nuu né be binidxaba'. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yanna ma benda lade cabe. Naa nga Hombre Biseenda Dios, ne ruuya cabe rahua ne ree', ne ma na cabe nalaya ne binigüé' naa, ne ridxaaga ca malu ni ruquixe impuestu ne cani qué rulabi ley. Peru casi na dichu que: “Pur ni runi binni rihuinni tu laa.” ");
INSERT INTO zaiNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Oraque bizulú Jesús gudinde né ca binni de ca guidxi ra jma uzá, purti qué niná ca ninaba ca perdón Dios neca biiya ca irá milagru ni bi'ni be. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Na be rabi be laaca': ―Laguuya gá laatu, binni Corazín ne binni Betsaida, purti nabé huahuinni enda nandxó' sti Dios lade tu, peru naguidxi ru ladxidó' to. Pa ñaca nizaya ñune milagru ndaani guidxi Tiro ne ndaani guidxi Sidón bia' ma bine ndaani xquidxi tu ca la? biaa padxí ma ninaba ca perdón ne ñuu ca triste pur irá ni huachee ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Gabe ca' laatu, dxi cuidxi Dios cuenta binni guidxilayú la? jma zusaba ná laatu que ca binni de Tiro ne de Sidón. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ne laatu, binni Capernaum ca', laatu cabeza tu usisaca Dios laatu, peru jma pe nagueenda guseenda be laatu ra nuu binidxaba'. Purti pa ñaca ñuuya binni Sodoma ca milagru ni ma biiya tu ca la? ma nusaana ca de nuchee ca' ne ma qué nunitilú Dios laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Peru gabe ca' laatu, dxi cuidxi Dios cuenta binni guidxilayú la? jma zusaba ná laatu que ca binni de Sodoma. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Oraque uní' né Jesús Dios, na: ―Bixhoze', lii nga runi mandar lu ibá' ne guidxilayú. Rudiee diuxquixe lii purti cucaachi lu ni cayuni lu ri' para cadi guiene cani nuu xpiaani ne cani na riene, peru culuí' lu ni cani zeda gaca casi ba'du'. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ne zacá cayuni lu ni purti zacá guyuula'dxi lu gaca ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Oraque rabi be ca binni que: ―Ma gudixhe Bixhoze irá xixé cosa ladxi naya'. Naa nga Xiiñi be ne iruti runibiá' naa jma que laabe, ne zaqueca iruti runibiá' laabe jma que naa ne cani racaladxe gunibiá' laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Latá' ra nuaa irá ni ma bidxaga de cuyubi modo guia ladxidó', cani ma qué ganda guni irá ni rucaa cabe laa guni, purti para laa ruluí' naguixhe cabe ti ayubu xa yanni. Latá' ra nuaa', zaziila'dxi ladxidó' to. ");
INSERT INTO zaiNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Laudxiiba ayubu stinne xa yanni tu purti nasisi ni, cadi nanaa ni casi ni nua tu ca. Laudii lugar usiide laatu purti qué zaca nia laatu naduxhu' ne qué zadinde nia laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Qué nindaa de ngue, ti dxi enda riziila'dxi zidi'di Jesús ne ca discípulu sti ndaani ti ñaa. Nabé ma candaana ca discípulu que para bizulú undadi ca zee gudó ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ora bi'ya caadxi fariseu ni cayuni ca discípulu que la? na ca rabi ca Jesús: ―Biaa ca xpinni lu', cayuni ca ni cadi jneza guni binni dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Para na Jesús rabi laaca': ―Ñee qué huayuunda tu ra cá xi bi'ni David dxi candaana, laa né ca xpinni la? ");
INSERT INTO zaiNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Biuu be ndaani yu'du sti Dios ne gudó be ca pan ni ma uyuu ndaaya' ni nexhe cadi go cabe, nin laabe nin cani nuu né laabe que, sínuque ca sacerdote si. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","O laca qué huayuunda tu ra cá lu ley sti Moisés xi runi ca sacerdote ni nuu ndaani yu'du ro' la? laca qué rapa ca dxi enda riziila'dxi peru qué rigui'ba donda ique ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Gabe ca' laatu, ma nuaa lade tu ne jma risaca que yu'du que né cani nuu ndaani ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nuu ra cá lu Xqui'chi Dios ra na: “Jma racaladxe guiá tu binni que guedané tu ni usiga'de tu naa.” Yanna rabe laatu, pa ñene tu xi na ca diidxa ca la? ma qué nudxiiba tu donda ique ca discípulu stinne, purti cadi cuchee ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Naa nga Hombre Biseenda Dios ne zanda gabe binni xii nga jneza guni dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Biree Jesús de raqué biuu ndaani yu'du stícabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ne nuu ti hombre raqué nabidxi ti chu ná'. Para gunaba diidxa caadxi binni ni nuu ra yu'du que Jesús pa jneza gusianda cabe binni dxi enda riziila'dxi'. Uní' ca zaqué peru para gapa si ca xi pur cu' ca xqueja be. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Para rabi be laaca': ―Pa ñapa tobi de laatu ti dendxu' ne ñaba me ndaani ti barranca dxi enda riziila'dxi', ñee qué niguu ná laame ne nibee laame la? ");
INSERT INTO zaiNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ñee cadi jma risaca hombre que dendxu la? Jma pue, ne zacá rihuinni cadi cuchee né cabe ley pa gacané cabe binni dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Para rabi be hombre ni nabidxi ti chu ná que: ―Bisigaa nou'. Ne ora bisigaa ná hombre que la? bianda ni ne guca ni casi sti chu que. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Para biree ca fariseu yení' stiidxa ca ximodo zanda guuti ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Peru ma nanna be xi chi guni ca', para bixele be de raqué, ne yenanda stale binni laabe para bisianda be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ne biinda be lú ca' cadi uzeete ca tu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ne zacá guca ni ti iree ni modo uní' profeta Isaías dxi bizeete de laabe, na: ");
INSERT INTO zaiNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ndi nga ni gulié para guni xhiiña' ne laabe nga nadxiee' ne ni rusieche ladxiduá'. Zudiee Espíritu stinne laabe ne zusiidi be dede cani cadi za de Israel ximodo rune mandar. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Qué zucaa lú be ne qué zucaa be ridxi, ne iruti zuna diaga caní' xhaata be lu calle. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Qué zusaba chaahui be cani ziyaba, cani ruluí' ti gueere ni ma caluuza, ne qué zadinde né be cani ruluí' ti mecha ni ma qué ganda gudii biaani'. Peru qué ziaana dxí xhiiña be dede gu'ya be gaca ni jneza ndaani guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ne zacá lú ca binni ni cadi za de Israel ulá be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Oraque bedané cabe ti hombre ra nuu be udxite binidxaba ique ne ma nacheepa lú ne qué randa riní'. Para bisianda be laa, ne óraque ma gunda biiya ne uní'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bidxagayaa irá binni ni nuu raqué, ne na ca': ―Nagana pa cadi ndi nga ni na cabe gueeda de lade familia sti rey David que. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Peru ora bina diaga ca fariseu ni caní' cabe la? na ca': ―Randa ribee be binidxaba purti nuu né be Beelzebú, xaíque sti ca binidxaba'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Peru nanna be xi caní' ique ca', para rabi be laaca': ―Intiica gobiernu ni tinde saa la? zanitilú. Ne zaqueca intiica guidxi o intiica familia ni tinde saa la? laca zanitilú. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nga runi pa ma cadinde saa ca xpinni binidxaba la? qué zandaa initilú. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Pa naa ribee ca binidxaba purti nuaa nia Beelzebú casi na tu ca la? laga ca xiiñi tu ya', tu pur ribee ca ca binidxaba'. Lagabi laacabe iní' cabe ximodo nga laani. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Peru naa la? ribee ca binidxaba purti napa Espíritu sti Dios ne zacá rihuinni ma cayuni mandar Dios lade tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Zanda xa chi ndana cabe ralidxi ti hombre ni nadipa' pa ca'ru iliibi. Peru ora ma liibi be la? óraque huaxa zanda cuana cabe ni napa be. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Tu cadi nuu pur naa la? cucaa lú naa, ne tu cadi cayacané naa gapa xpinne la? cabee laacabe de naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ne gabe ca' laatu, zuni perdonar Dios cani ruchee, ne cani riguu dí, peru qué ziuu dxi guni perdonar be cani gusaca Espíritu Santu binidxaba'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Naa nga Hombre Biseenda Dios ne zuni perdonar be cani gucaa lú naa, peru cani gucaa lú Espíritu Santu la? qué zuni perdonar be laaca', nin ora nabani ca nin ora ma guti ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Laaca tu nanna tu qué zanda udii ti yaga cuananaxhi pa cadi nazaaca, peru pa nazaaca ni la? zudii ni cuananaxhi ni iquiiñe' purti pur cuananaxhi sti yaga rihuinni ximodo laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ne laatu, binni malu ca', ximodo zanda iní' tu jneza pa cadi nayá ladxidó' to ya'. Purti de ndaani ladxidó' cabe nga riree diidxa ni riní' cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Binni nayá ladxidó' la? zaní' ni jneza purti dxandí nayá ladxidó'. Peru binni cadi nayá ladxidó' la? zaní' ni cadi jneza purti zacá laa de ndaani ladxidó'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Peru naa rabe laatu, dxi cuidxi Dios cuenta irá binni guidxilayú la? zabi be laaca xi pur bindaa ruaa ca ca diidxa ni cadi jneza ca. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Purti stiidxa piou' nga usihuinni pa dxi'ba donda ique lu o pa nayá ladxidó' lo'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Oraque na caadxi maistru de ley ne caadxi fariseu, rabi laabe: ―Maistru, xiñee qué uluí' lu laadu ti seña xaibá' para ganna du dxandí nandxó' lo'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Para rabi be laaca': ―Laatu qué na tu guni tu ni na Dios, sínuque ni na tu, ne yanna ma canaba tu gu'ya tu seña. Peru qué zudiee rua' seña laatu sínuque gabe sia' laatu guietenala'dxi tu de profeta Jonás. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Purti cásica uyuu Jonás ndaani benda ro' que chonna gubidxa ne chonna gueela la? zaqueca ziaana Hombre Biseenda Dios ndaani yu chonna gubidxa ne chonna gueela'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ne dxi uzuhuaa irá binni nezalú Dios, ziasa ca binni Nínive ne zuseegu ca ruaa ca binni nuu yanna ri', purti laaca ucuaa ca stiidxa Jonás ne unaba ca perdón Dios, peru yanna ma nuaa lade tu ne jma risaca que Jonás ne qué na tu icaa tu stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Chiqué beeda ti reina de neza guete' de ti guidxi lá Sabá. Beeda be ra nuu Salomón purti bina diaga be pabiá' riene ne nuu né Dios laa. Ne dxi cuidxi Dios cuenta binni la? zuseegu be ruaa ca binni nuu yanna ri' purti laabe beeda be de zitu, beda guna diaga be Salomón, ne naa jma risaca que Salomón ne nuaa ca' lade tu ne qué na tu icaa tu stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ora iree ti binidxaba de ndaani ladxidó' binni la? riree, ma canazá ndaani gui'xhi', canayubi ra iziila'dxi'. Gu'ya si qué idxela, óraque na': “Zabigueta ralidxe ra biree'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ne ora guedandá gu'ya ma nayá ladxidó' ngue, casi ñaca ti yoo ma iruti nabeza, ma biluuba, ma zuchaahui'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ibigueta, chi caa xcadxe jma rusi nadxaba que laa, riuu ca ndaani ladxidó' binni que, ne riaana ca raqué. Ne pa huaxié' malu binni que ora nuu stubi si ti binidxaba la? jma rusi yanna. Zacaca zazaaca ca binni qué runa ni nuu yanna ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Cayuí' né ru be ca binni que diidxa', bedandá jñaa be ne ca bi'chi be, bizuhuaa ca ra puerta', ne racala'dxi ca iní' né ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Para na tobi de cani nuu raqué rabi laabe: ―Rarica zuhuaa jñoou' ne ca bi'chi lu', caquiiñe ca lii. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Para rabi be ni gudxi ni laabe que: ―Tuu nga jñaa', ne tuu nga ca biche'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Oraque biluí' ná be ca discípulu stibe, ne na be: ―Ca ndi nga jñaa ne biche'. ");
INSERT INTO zaiNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Purti irá tu guni ni na Bixhoze ni nuu ibá', ca ngue nga biche ne bizana ne jñaa'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dxi queca biree Jesús de ndaani yoo que, yetí uriá dxa nisa ro' que. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ne biiya si be ma rí binni laabe, yetí be ndaani ti canuá. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ne idubi zuba be ndaani canuá que, bizulú bisiidi be laaca stale cosa peru puru ne ejemplu, na be: ");
INSERT INTO zaiNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","―Sicarí bizaaca lú ti hombre biree zinduu biní. Ne ra cusaba be xuba que, biaba caadxi ni uriá neza ne beeda mani huiini gudó cani. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ne biaba xcaadxi ni lade guie, ne ca ngue gundani nagueenda, purti luguiá si napa ni caadxi yu. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Peru casi biree gubidxa bizaaqui ni ne bibidxi ni purti qué ñapa ni xcu ni guete'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ne biaba xcaadxi ni lade guichi ne gundani, peru jma bisoo guichi que para laacani ne biiti ca guichi que cani. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Peru biaba xcaadxi ni ra nayá, ne ca ngue huaxa ucuá lú. Nuu ra bidii dede ti gayuaa carreta niza, ne nuu ra bidii sesenta, ne nuu ra bidii treinta. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Irá ni racala'dxi guiene la? ucaa diaga. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Biree si ca binni que ze', bidxiña ca discípulu que ra nuu be ne na ca rabi ca laabe: ―Xiñee puru si ejemplu caguixhe lu para laacabe pue. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Para rabi be laaca': ―Purti laatu la? cudii Dios lugar guiene tu modo runi mandar, dede ni naga'chi', peru ca xcaadxi la? co'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tu ma riene caadxi la? ziene xcaadxi ne ziene ru jma stale. Peru tu qué riene nin caadxi la? dede ni ma biene zusiaanda'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nga runi riguixhe ejemplu para laacabe, purti neca zuxele lú cabe, qué ruuya cabe, ne neca zuxele diaga cabe, qué runa diaga cabe, ne qué riene cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","De laacabe nga bizeete profeta Isaías ra na: Zuna diaga ca peru qué ziene ca', ne zuyubi lú ca peru qué zuuya ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Purti ma biguidxi ladxidó' ca', ne ma biseegu ca diaga ca'. Ne biseegu ca lú ca ti cadi gu'ya ca' ne guna diaga ca' ti cadi guiene ca', uyubi ca naa para ula'ya laaca, na Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Peru laatu la? na Jesús rabi ca discípulu sti', dichoso laatu purti nanna tu xi cayuuya tu ne riene tu xi cayuna diaga tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Purti gabe ca' laatu, uyuu stale profeta ne hombre cha'hui ni gucala'dxi ñuuya ni cayuuya tu ri' peru qué ñuuya ca', ne gucala'dxi ca ñuna diaga ca ni cayuna diaga tu ri' peru qué ñuna diaga ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yanna laucaa diaga xi riní' ejemplu sti hombre ni uluu biní que. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ni biaba uriá neza que la? zeda gaca casi tobi ni rui' né cabe laa ximodo runi mandar Dios, peru qué riene ni, ne reeda binidxaba raxha ni ma biaba ndaani ladxidó' be que. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ne ni biaba lade guie que, ngue zeda gaca casi tobi ni runa diaga stiidxa Dios ne oraqueca ricaa ni ne enda nayeche'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Peru qué gapa ni xcu ni guete' sínuque luguiá si, ngue runi casi gueeda xiixa naná, o sa nanda cabe laa pur ca diidxa que la? maca ziyaba. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ne ni biaba lade guichi que la? ngue zeda gaca casi tobi ni guna diaga stiidxa Dios peru jma cá ique ximodo ibani ndaani guidxilayú ri', ne rudii lugar quite bidxichi ique, ne irá nga ruuti stiidxa Dios ni nuu ndaani ladxidó' be que. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Peru ni biaba ra nayá que la? ngue nga zeda gaca casi cani runa diaga stiidxa Dios ne riene xi riní' ni purti riree ndu ca'. Nuu de laaca ni zeda gaca casi layú ni bidii ti gayuaa que, ne nuu de laaca casi ni bidii sesenta que, ne nuu de laaca casi ni bidii treinta, peru irá ca bidii ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Bigueta bisiidi be ca binni que, gudixhe be xcaadxi ejemplu, na be: ―Modo runi mandar Dios zeda gaca casi ti hombre bisaba semiá ndaani ñaa sti', ");
INSERT INTO zaiNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","peru laga nisiaasi binni, beeda tuuxa nanala'dxi laabe ne bidxiiba baladxi lade semiá que ne ze'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dxi ma biniisi semiá que, ma cabee guie' bihuinni nuu baladxi que lade. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Oraque beeda ca mozo que ra nuu xpixuaana ni, ne na ca': “Señor, cadi ladxa semiá si bidxiiba lu la? Xi guca xa yanna, nucha ni baladxi'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Para na xpixuaana ni: “Laca tu laa nanala'dxi naa, beda guni ni.” Oraque na ca mozo que: “Racala'dxu chi gaxha du cani la?” ");
INSERT INTO zaiNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Para na be: “Co', zaa nuu cani, pacaa ra cayaxha tu cani, zanda ca gaxha tu ne semiá. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lausaana cani, zaa iniisi cani tobi si ne ora ma gula semiá ca, naa ma gabe cani chi chuugu semiá, utopa ca ca baladxi que gundiibi ca para chaqui'. Ne óraque ru gutopa ca ca semiá idxá sacu.” ");
INSERT INTO zaiNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ne bigueta gudixhe be sti ejemplu, na be: ―Modo idale ca xpinni Dios zeda gaca casi guca ti biidxi mostaza ni gucuaa ti hombre ne yeusaba rañaa sti'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Laani jma nahuiini ni lade irá xixé biidxi', peru undani si ni la? biniisi ni ne guca ni yaga ro', dede beeda mani huiini bizá' lidxi lu rama stini. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Gudixhe ru be sti ejemplu para laaca', na be: ―Modo idale ca xpinni Dios zeda gaca casi guca levadura ni gucuaa ti gunaa ne biguucha chonna kilu harina, ne irá ni biasa ni. Zacaca nga idale ca xpinni Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Puru ne ejemplu bisiidi be ca binni que. Qué nusiidi di be laaca sin ejemplu. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bi'ni be zacá ti iree ni modo pe uní' Dios de ruaa ti profeta chiqué, ra na: Zaguixhe stale ejemplu ra güe nia laacabe diidxa'. Zabe laacabe ni ga'chi dede dxi bizá' Dios guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Biluxe si bisiidi be ca binni que, biuu be ndaani yoo, ne bidxiña ca discípulu stibe ra nuu be, gunaba ca laabe gusiene be laaca xi riní' ejemplu sti baladxi biaba rañaa que. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Para rabi be laaca': ―Ni bisaba semiá pe que la? nga Hombre Biseenda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Layú que nga guidxilayú. Semiá que zeda gaca ca xpinni Dios, ne baladxi que, xpinni binidxaba'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ne ni bisaba baladxi que nga binidxaba'. Dxi iruugu semiá que nga iluxe guidxilayú, ne cani chi uchuugu ca semiá que nga ca ángel. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ne cásica idopa baladxi que chaqui la? zaqueca zaca ni dxi iluxe guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Naa nga Hombre Biseenda Dios ne zuseenda ca ángel stinne para gueda ndee irá ni cuchiiña ca xpinne' ne irá cani qué runi jneza. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Zundaa cabe laaca lu bele ne raqué nga gu'na ca dede go yaa ca guidi ruaa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ne dxi ca nga guzaani cani nacha'hui ra runi mandar Dios, casi ruzaani gubidxa. Cani racala'dxi guiene la? gucaa diaga. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ne laca rabi be laaca': ―Enda runi mandar sti Dios zeda gaca casi ti tesoro ni bidxela tobi hombre ga'chi ndaani yu. Biiya be ni ne bicaachi be ni sti tiru, ne ziyeche be yeutoo be irá ni napa be para sí be layú que ne icaa be tesoro que. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Laca rabi be laaca': ―Enda runi mandar sti Dios zeda gaca casi ti perla ni bidxela ti hombre ra canayubi perla cha'hui para sí'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ora bi'ya jma risaca ni que irá xixé perla la? yeutoo irá ni napa para uzí' ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ne gudixhe ru be stobi, na be: ―Enda runi mandar sti Dios zeda gaca casi tarraya ni rusaba cani rie guuze ndaani nisadó'. Rutopa tarraya que irá clase benda ");
INSERT INTO zaiNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","peru ora ma bidxá ni, rití né cabe ni uriá para ribí cabe ique ni. Rusa'bi cabe ni qué zaquiiñe', ne ruchá cabe cani zaquiiñe que ndaani dxumi. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Zacaca zaca ni ra gueeda iluxe guidxilayú ri', zeda ndee ca ángel cani qué iquiiñe lade cani nacha'hui'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ne zundaa ca laacabe lu bele, ne raqué nga gu'na cabe dede go yaa cabe guidi ruaa cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Oraque unaba diidxa be ca discípulu stibe pa biene ca ni gudxi be laaca que. Para na ca': ―Biene du, Señor. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Para rabi be laaca': ―Tobi ni ma riene chaahui ley sti Moisés ne óraque gueda iziidi ni rusiide de modo runi mandar Dios la? zeda gaca casi ti ricu ni ribee de lu irá ni napa, caadxi nacubi ne caadxi nayooxho'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Biluxe si byui' né Jesús laacabe irá nga, biree de raqué, ");
INSERT INTO zaiNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","uyé xquidxi ne biuu ndaani yu'du', bisiidi ca binni xquidxi. Nabé bidxagayaa ca laabe ne na ca': ―Paraa ulee be irá enda biaani ni napa be ri pue, ne irá enda nandxó' ni runi be. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ñee cadi laabe nga xiiñi carpinteru que la? ne María lá jñaa be, ne bi'chi be nga Jacobo ne José ne Simón ne Judas. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Lácaxa cadi rarí nabeza ca biza'na be. Paraa ulee be cani cayuni be ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ne pur ni caní' ique cabe que, ma qué ñanda ñuni cre cabe laabe. Para na be rabi be laaca': ―Stobi stobi lugar risaca profeta, peru ra qué risaca be nga ndaani xquidxi pe be ne lade binni lidxi be. ");
INSERT INTO zaiNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ne huaxié' bisihuinni be enda nandxó' stibe raqué purti qué ñuni cre ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Bireeche stiidxa Jesús ca dxi que, ne ora gunna Herodes, gobernador de Galilea, irá ni la? ");
INSERT INTO zaiNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","na rabi ca xpinni: ―Laguuya irá ni cayuni hombre ca. Nanna pa cadi laabe nga Juan Bautista ma bibani, ne nga runi cayanda cayuni be irá nga. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Uní' Herodes zacá purti nanna xi ma bi'ni Juan Bautista. Gunaaze be laa ne bindiibi be laa ne biseguyoo be laa, runi Herodías xheela Felipe bi'chi be. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Bidxiichi be purti gudxi Juan laabe cadi jneza chu' né be xheela bi'chi be. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Gucala'dxi be ñuuti be Juan oraqueca, peru bidxibi be purti nabé nadxii ca binni que laa ne napa cabe laa de profeta. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Peru dxi guca lani xpidó' be la? beda uyaa xiñi dxaapa Herodías nezalú be ne nabé uyuula'dxi be modo biyaa. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Para na be rabi be laa: Intiica inabu naa, zudiee lii. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Oraque gudxi jñaa badu dxaapa que laa xi inaba'. Para uyé ra nuu be ne rabi laabe: Racaladxe udiiu naa ique Juan Bautista ndaani ti bladu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ne ora gudxi badu dxaapa que nga laabe la? ucaná ladxidó' be, pa ñanda si qué nudii be ni canaba badu dxaapa que, peru pur ma bidii stiidxa be laa nezalú irá cani zuba né laabe ruaa mexa que la? uní' be icaa badu dxaapa que ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Para bisenda tidxi be ugá ca xpinni be yanni Juan ndaani lidxi guiiba que. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ne bedané cabe ique que ndaani ti bladu', bidii cabe ni badu dxaapa que, de laa ma bidii ni jñaa. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Oraque uyé ca discípulu sti Juan, yecaa ca cuerpu que ne yeucaachi ca ni, para yetidxi ca Jesús xi guca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Casi gunna Jesús ni, bixele ca de raqué, uyuu ndaani ti canuá, uyé ndaani ti gui'xhi ra iruti guinni. Peru casi gunna binni paraa ze be la? biree ca de ndaani guidxi que, zizá ca dede yendá ca ra nuu be. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ne ora ziyete be de lu canuá que, biiya be mápeca rí binni raqué ne biá be laaca'. Para bisianda be cani huará ni nuu lade ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ne biaana ca binni que raqué dede ma huadxí. Biiya si ca discípulu stibe ma huadxí ngue la? bidxiña ca ra nuu be, ne na ca': ―Ndaani gui'xhi ndi nuu nu, ne ma caxhinni, xiñee qué ga'bu ca binni ca che ca yanna, ti ganda che ca ndaani ca guidxi huiini ca, chi sí ca ni go xhi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Para na be rabi be laaca': ―Cadi naquiiñe che cabe. Laudii ni go cabe laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Oraque na ca': ―Qué gapa di du gasti rarí jma que gaayu pan ne chupa benda. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Para rabi be laaca': ―Latané cani naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Oraque bicuí be ca binni que lú ca guixi huiini nuu raqué ne ucuaa be gaayu pan ne chupa benda que ne undisa lú be ibá' bidii be diuxquixe Dios. Para gundaa be cani ne bidii be cani ca discípulu que para gudiizi cani lú ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Irá xixé binni que gudó dede bidxá ndaani ne biaana ru nandahui. Para bitopa cabe ni biaana que dede bidxá doce dxumi de ca nandahui ni biaana que. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ne irá ni gudó que bia'si gaayu mil hombre sin igaba gunaa ne ba'du'. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Oraque ru gudxi be ca discípulu stibe chu' ca ndaani canuá que, che gá ca sti ladu nisa que, laga gabi si be ca binni que ma che be. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ne gudxi si be ca binni que ma che be la? udxi'ba be lú ti dani yení' né be Dios, dede bixhinni be raqué, stubi lucha be. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Peru ma bixele canuá ra ze ca discípulu que zitu de uriá, ne nabé canaaze ola ni purti cudxigueta bi ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ne nuxcanda que bidxiña Jesús ra nuu canuá que, zeda za lu nisa. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ne ora bi'ya ca discípulu que zeda za be lu nisa la? bidxibi ca' ne bicaa ca ti ridxi muxe', na ca': Zeeda ti bultu racá. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Peru óraque na be rabi be laaca': ―Lachuu dxí. Cadi idxibi tu, naa ndi'. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Para na Pedru rabi laabe: ―Señor, pa lii nga la? guridxi naa guenda ra nuu lu', saya lu nisa. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Para na be rabi be laa: ―Gudá'. Oraque biete Pedru de ndaani canuá que zizá lu nisa, ze ra nuu be. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Peru biiya si Pedru pabiá' reciu nuu bi que la? bidxibi ne bizulú biaazi', ne bicaa ti ridxi: ―Bilá naa, Señor. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Oraqueca bisigaa ná Jesús gundisa laabe ne na rabi laabe: ―Aque huaxié' fe napu xa. Xiñee bidxibi lu, hombre. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ne casi udxi'ba cabe ndaani canuá que, biaana dxi bi que. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Oraque bizuxibi ca xcaadxi ni nuu ndaani canuá que xañee be ne na ca': ―Dxandí pe Xiiñi Dios lii. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ne ora yendá cabe sti ladu que, biuu cabe ti lugar lá Genesaret. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ne casi gunna ca binni ni nuu raqué tu laabe la? bicheeche ca stiidxa be irá guidxi ni nuu neza que, ne bedané cabe irá binni huará ra nuu be. ");
INSERT INTO zaiNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dede gunaba cabe udii be lugar neca ñee xhaba si be cana ca', ne irá ni uda'na xhaba be que bianda. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ti dxi biree caadxi fariseu ne caadxi maistru de ley Jerusalén, uyé ca ra nuu Jesús, ne na ca rabi ca laabe: ");
INSERT INTO zaiNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Xiñee cuchaa ca discípulu stiu' ca costumbre stinu pue, purti qué riguiibi ná ca ora go ca' casi bisaana ca bixhoze gola nu. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Para rabi be laaca': ―Laatu ya', xiñee cuchaa tu mandamientu sti Dios pur ca costumbre ni napa tu ca. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Purti ndi nga ni na Dios guni tu: ganaxhii tu bixhoze tu ne jñaa tu. Ne laca na, tutiica cu' dí bixhoze o jñaa la? naquiiñe gati'. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Peru laatu rabi tu bixhoze tu ne jñaa tu: “Ni ñacaniá laatu ca, ma bidiee Dios.” ");
INSERT INTO zaiNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ne ma qué rulabi ru tu laaca', ne zacá pur ca costumbre ni zeda za lade tu la? napa tu stiidxa Dios casi xiixa de enda riguite. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nanaxhi ruaa tu peru rusiguii si tu. Para laape tu nga ni uní' Dios de ruaa profeta Isaías, ra na: ");
INSERT INTO zaiNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ca binni ri', nanaxhi ruaa ca ne naa, peru ladxidó' ca nuu zitu de naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pur gana si rusisaca cabe naa, purti de laasi cabe riale ni rusiidi cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Oraque guridxi Jesús irá binni nuu raqué ne na rabi laaca': ―Laucaa diaga ne laguiene chaahui ndi': ");
INSERT INTO zaiNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Cadi pur ni chu' ndaani ruaa binni nga guni pur uchee né Dios, sínuque pur ni riree de ndaani ruaa cabe nga runi pur uchee né cabe Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ratu si que bidxiña ca discípulu ra nuu be ne na ca rabi ca laabe: ―Ñee biiyu pabiá' naná biaba ni uníu' ca ca fariseu la? ");
INSERT INTO zaiNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Para na be rabi be laaca': ―Irá yaga ni cadi Bixhoze bizuhuaa la? ziaaxha dede xcu. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Zaa nuu cabe nacheepa lú cabe, peru racala'dxi cabe inaaze cabe ná stobi. Ne pa inaaze ti lú cheepa ná sti lú cheepa la? iropa ca ziaba ca ndaani barranca. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Para na Pedru rabi laabe: ―Bisiidi laadu ni uníu' numbá que. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Oraque na be: ―Ñee nin laatu ca'ru guiene tu la? ");
INSERT INTO zaiNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Qué ganna tu pa irá ni chu' ndaani ruaa binni riaba ndaani', ne de raqué ridi'di ni la? ");
INSERT INTO zaiNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Peru irá ni riree de ruaa cabe, zeeda ni de ladxidó' cabe ne nga ni runi pur uchee né cabe Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Purti de ndaani ladxidó' cabe reeda ni cadi jneza ni cá ique cabe guni cabe: guuti cabe binni, o chu' né cabe ni cadi xheela cabe, gapa cabe jnadxii cabe, cuana cabe, indisa cabe falsu luguiá stobi, cu' dí cabe binni. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Zacá huaxa ruchee né cabe Dios, peru pa go cabe gueta sin qui'bi ná cabe la? nga cadi cuchee cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","De raqué biree be uyé be neza Tiro ne Sidón. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Raqué nuu be beda nanda ti gunaa de Canaán laabe, zeda yuni ridxi: ―Biá naa, Señor, xiiñi David, purti naaze binidxaba xiñe dxaapa ne cayuuti laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Peru qué niní' be gasti'. Para biree ca discípulu, na rabi laabe: ―Gudxi laabe che be, purti zeda yuni be ridxi nanda be laanu. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Para na be rabi be laaca': ―Ra nuu si cani za de Israel biseenda Bixhoze naa, purti cananiti ca casi dendxu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Peru óraque bidxiña gunaa que ra nuu be bizuxibi xañee be na rabi laabe: ―Señor, ucané naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Para na be rabi be laa: ―Cadi jneza gaxha cabe pan xiiñi cabe para gudii cabe bi'cu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Oraque na: ―Nanna, Señor, peru laca ro bi'cu bigú ni riaba xa mexa sti xpixuaana'. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Para na be rabi be laa: ―Rihuinni dxichi runi cre lu', zune ni canaba lu ca. Ne oraqueca bianda xiiñi gunaa que. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Biree Jesús de raqué, uzá uriá nisa Galilea que, ne de raqué udxi'ba lu ti dani ne gurí. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Raqué zuba be bidxiña jma binni laabe, bedané ca cani nachiita ñee, ne cani nacheepa lú, ne cani qué riní', ne cani nachanga ná' o ñee, ne stale ru binni huará. Gudixhe ca binni que laaca xañee be ne bisianda be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nabé bidxagayaa ca binni que ora bi'ya ca ma bianda irá ni bedané ca que. Cani qué ñanda niní' ma riní', ne cani qué ñanda nusigaa ná', ma rusigaa ná'. Cani qué ñanda nizá ma rizá, cani qué ñanda niná ma riná, ne irá xixé ca cusisaca ca Dios sti Israel. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Oraque guridxi be ca discípulu stibe ne rabi be laaca': Caya'ya ca binni ri purti ma chonna gubidxa nuu né cabe naa ne qué gapa cabe ni go cabe. Qué na'ya guseenda laacabe sin go cabe, paxa ora gueda guiaba cabe neza. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Para na ca discípulu que rabi laabe: Peru ndaani gui'xhi ndi nuu nu. Paraa ndi chi ndee nu ni go irá binni ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Oraque rabi be laaca': Panda ga pan napa tu ya'. Para na ca': Gadxe, ne chupa chonna benda huiini'. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Oraque gudxi be ca binni que cui ca layú. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ne gucuaa be gadxe pan ne ca benda que, bidii be diuxquixe Dios ne gundaa be ni lú ca discípulu que, de laaca ma bidii ca ni ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Gudó ca binni que dede bidxá ca', ne biaana ru jma nandahui dede bidxá gadxe dxumi de ni biaana que. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bigaba bia' tapa mil hombre ni gudó dxi que, sin nigaba gunaa ne ba'du'. ");
INSERT INTO zaiNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ne óraque gudxi be ca binni que ma zanda che ca', para udxi'ba be ndaani ti canuá dede yendá be neza Magdala. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nuu be raqué bidxiña caadxi fariseu ne saduceu laabe, beda guuya si ca pa ñanda nusaba ca laabe. Para unaba ca laabe uluí' be laaca ti seña xaibá' ti ganna ca pa dxandí nandxó' be. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Peru laabe laga rabi be laaca': ―Ora ma chi guiaazi gubidxa ne gu'ya tu naxiñá ibá', óraque na tu: “Qué ziaba nisa guie ixí' purti naxiñá ibá'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ne zaqueca pa gu'ya tu naxiñá ibá' siadó' la? óraque na tu: “Yanadxí ziaba nisa guie purti naxiñá ibá' ne nachuundu nuu.” Laatu riene tu xi na ca seña ni rihuinni ibá', peru ca seña ni cayuuya tu yanna ri', nga qué riene tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Qué na tu guni tu ni na Dios sínuque ni na tu, ne yanna ma canaba tu udiee laatu ti seña, peru qué zacaa tu sti seña sínuque seña si sti profeta Jonás. Ne óraque biree be ze be. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ne ora yendá ca discípulu que cherica nisa, bedasilú laaca qué niné ca pan. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ne óraque pe rabi be laaca': ―Lagataná ne laguuya gá laatu ne ca levadura sti ca fariseu ne sti ca saduceu. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Oraque na ca': ―Cayabi be ndi laanu tisi qué ñedané nu pan. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Peru nanna be xi caní' ca', para na be rabi be laaca': ―Hombre ca', xiñee nabé huaxié' napa tu fe naa. Xiñee nuu tu xizaa qué ñedané tu pan. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ñee de yanna ca'ru guiene tu la? Ñee ma biaanda laatu de gaayu pan ni gudó gaayu mil que la? ne panda dxumi bitopa tu de ni biaana. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ñee laca ma biaanda laatu de gadxe pan ni gudó tapa mil que la? ne panda dxumi bitopa tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Xiñee qué ñanda ñene tu cadi cuzeete dia' de levadura sti pan pe' ora gudxe laatu lagapa laatu ne levadura sti ca fariseu ne sti ca saduceu. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ne óraque ru biene ca xi cayabi be laaca', purti cadi cuzeete be levadura sti pan pe' sínuque cuzeete be ni rusiidi ca fariseu ne ca saduceu, ne nga nga levadura ni cayabi be laaca guuya gá ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Dxi ma bedandá Jesús neza Cesarea de Filipo, na rabi ca discípulu sti': ―Tu na binni naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Para na ca rabi ca laabe: ―Nuu tu na Juan Bautista lii, ne nuu tu na Elías, ne xcaadxi na Jeremías o tobi de ca profeta. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Para rabi be laaca': ―Laatu ya'. Tu rabi tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Oraque na Simón Pedru rabi laabe: ―Lii nga Cristu, Xiiñi Dios ni nabani. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Para na be: ―Dichoso lii, Simón, xiiñi Jonás, purti cadi binni guidxilayú bisiene nga lii, sínuque Bixhoze ni nuu ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ne ma gulee la'ya lii Pedru, ne ni riní' lá lu ca la? “guie”. Ne lu guie ca chi ucué ti yu'du', ne yu'du ca nga, ca xpinne'. Ne gasti qué zanda uxhá ni, gueeda ni gueeda, neca enda guti. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Zusaana ca llave sti ibá' ladxi ná lu', ne intiica cuee lu de gaca ndaani guidxilayú la? laca qué zaca ni ibá'. Ne intiica na lu gaca ndaani guidxilayú la? laca zaca ni ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ne óraque gudxi be ca discípulu stibe cadi gabi ca iruti pa laabe nga Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dede óraque bizulú be bisiá be stiidxa be, rabi be ca discípulu stibe: ―Naquiiñe chaa Jerusalén ne zuniná ca xaíque sti guidxi naa raqué, laaca né ca maistru de ley ne ca xaíque sti ca sacerdote, dede zuuti ca naa, peru zabane ra guionna gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Oraque guridxi Pedru laabe ti ladu ne bizulú cayabi laabe: ―Dios gu'ya qué izaaca lu ni nou' ca. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Peru óraque biiya dxí be Pedru ne na be: ―Biree de ra nuaa, binidxaba'. Qué gueda uchenda lu naa purti cadi de Dios di zeeda ni cá ique lu ca sínuque de binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ne na be rabi be irá ca discípulu stibe: ―Tu gacala'dxi gaca xpinne la? gusiaanda laca laa, cadi lica guiá xpida, ne sa nanda naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Purti tu gacala'dxi ulá xpida zuniti ni, peru tu guniti xpida pur naa la? zalá. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Paraa iquiiñe ni binni pa guni ganar idubi guidxilayú peru guniti xhialma. O pagala zanda quixe binni saca ulá xhialma. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Naa nga Hombre Biseenda Dios ne zadxiña dxi ibigueta nia enda nandxó' sti Bixhoze'. Zedaniá ca ángel stinne ne dxi ca nga quixe cada tobi bia' ni bi'ni'. ");
INSERT INTO zaiNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Gabe ca' laatu, caadxi de cani nuu rarí' qué zati dede qué gu'ya guenda guidxilayú sti tiru, peru ma para gune ganar. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Gudi'di xhoopa gubidxa de ngue, yené Jesús Pedru ne Jacobo ne Juan bi'chi Jacobo, ne idapa si cabe uyé cabe lu ti dani soo. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ne raqué mala biiya cabe ma adxé modo bihuinni Jesús purti bizaani lú casi ruzaani gubidxa, ne bihuinni xhaba be casi biaani'. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ne mala bihuinni caní' né Moisés ne Elías laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Oraque na Pedru rabi laabe: Aque galán nuu nu rarí nja'. Pa racala'dxu la? zucui du chonna ranchu huiini', tobi para lii, ne stobi para Moisés ne stobi para Elías. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Caní' ru Pedru, mala biseegu ti za laacabe. Nabé ruzaani za que, ne ucuá ti ridxi lade ni: ―Ndi nga Xiiñe ni nadxiee ne ni rusieche naa. Laucaa diaga laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Casi bina diaga ca discípulu ridxi que, biaba rilú ca layú ne nabé bidxibi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Oraque bidxiña Jesús ne uda'na laacabe, na: ―Laguiasa, cadi idxibi tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Para gundisa lú cabe ne ma qué ñuuya ru cabe iruti sínuque Jesús si. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ne ora ziyete cabe de lu dani que, gudxi Jesús laacabe cueza cabe guiasa si Hombre Biseenda Dios de lade gue'tu ti iní' cabe ni biiya cabe que. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Oraque unaba diidxa ca discípulu stibe laabe, na ca': ―Xiñee na ca maistru de ley zeeda Elías ante gueeda ni nexhe guseenda Dios que ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Para rabi be laaca': ―Dxandí nexhe gueeda Elías primeru para quixhe chaahui irá cosa. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Peru cayabe laatu, ma beeda Elías ne qué ñacabiá' cabe laa sínuque bi'ni cabe laa ni ucala'dxi cabe. Ne zacaca zuni cabe Hombre Biseenda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Oraque ru biene ca discípulu cuzeete be Juan Bautista nga Elías. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ora yendá cabe ra nuu binni la? bidxiña ti hombre ra nuu be, bizuxibi xañee be, na rabi laabe: ");
INSERT INTO zaiNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Señor, rinaba lii guiá lu xiiñe ri', purti rudii ataque laabe ne nabé racaná be. Stale tiru riaba be lu gui, o pacaa ndaani nisa. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma bedaniá laabe ra nuu ca discípulu stiu' peru qué ñanda nusianda ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Oraque na Jesús: ―Aque qué runi cre tu xa, binni ca', ne naguidxi ladxidó' to. Dede padxí naquiiñe guiaana nia laatu ne gune huantar laatu ya'. Latané laabe rarí yanna. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Casi bidxiña hombre huiini que, udinde né Jesús binidxaba ni napa be que, para biree de laabe, ne oraqueca bianda be. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Birá si binni que bireeche, beeda ca discípulu sti Jesús ra nuu, ne na ca rabi ca laa: ―Xiñee laadu qué ñanda nibee du binidxaba que pue. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Para rabi be laaca': ―Ti huaxié' napa tu fe xa. Laucaa diaga chaahui ni chi tidxe laatu ri': Pa ñapa tu fe, neca bia' ti biidxi mostaza la? ñanda ñabi tu dani ri iree de ra nuu, che sti ladu, ne ñe ni, ne gasti qué ñaca nagana para laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Peru binidxaba zacá la? qué riree ca pa qué iní' né binni Dios ne guiaana sin go. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dxi canazá cabe neza Galilea, na Jesús rabi laacabe: ―Naa nga Hombre Biseenda Dios. Zutoo cabe naa lu binni guidxilayú, ");
INSERT INTO zaiNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ne zuuti ca naa, peru zabane raguionna gubidxa. Ne ora bina diaga ca discípulu ni uní' be que la? nabé ucaná ladxidó' ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ora yendá cabe ndaani guidxi Capernaum, beeda caadxi hombre ni ruquixe impuestu sti yu'du ro' ra nuu Pedru, ne unaba diidxa ca laabe pa riguixe xpixuaana cabe impuestu. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Para na be: ―Riguixe pue. Ne ora biuu be ndaani yoo ra ñabi be ni Jesús la? laga Jesús gudxi ni laabe. Na Jesús rabi laabe: ―Xi na lu ya', Simón. Tu ruquixe ti rey impuestu, ca xpinni la? o cani zeeda de sti guidxi. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Para na be: ―Binni si ni zeeda de sti ladu. Para na Jesús rabi laabe: Entonce qué riguixe ca xpinni be pue. ");
INSERT INTO zaiNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Peru neca cadi naquiiñe quixe xpinni rey la? zaguixe nu ni ti qué gapa cabe xi pur iní' cabe laanu. Yanna uyé uriá nisa ne bisaba anzuelu stiu'. Primé ca benda inaaze lu ulee, ne bixhele ruaa me. Zadxela lu ti moneda. Ucuaa ni, ne uyé ra nuu cabe, gudixe stiu' ne stinne'. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ca dxi queca bidxiña ca discípulu sti Jesús ra nuu, ne unaba diidxa ca laabe: ―Tuu nga jma risaca lade ca xpinni Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Para guridxi be ti ba'du, bizuhuaa be galahui de laaca ");
INSERT INTO zaiNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ne na be: Gabe ca' laatu, pa qué gaca tu casi ba'du la? qué zanda chu' tu lade ca xpinni Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nga runi tu qué udxiiba laca laa sínuque gaca casi ba'du ri la? laa jma risaca lade ca xpinni Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ne tutiica gacané tobi de cani nahuiini ru lu neza stinne', ne guni ni pur naa la? cásica ñaca ñacané naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Peru tutiica guni pur uchee tobi de cani deru zeda yuni cre naa la? gapa gá si laa, purti cadi tan naná ñaca para laa pa nundiibi cabe ti guiiche ro' yanni, ne nundaa cabe laa galaa nisadó', bia' nga naná ni gueeda luguiá pa guni pur uchee cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Gapa gá si binni guidxilayú laa, purti pur ni runi ca' ruchee stobi. Qué ziaadxa tu guni zacá, peru gapa gá si ni guni ni que laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Pa nuu xiixa cuchiiña nou' lii guni lu ni cadi jneza, o ra cuchiiña ñeeu lii cheu' para chi ucheeu siou' la? bixele de laacani purti jma huaxié' naná zaca para lii ibani lu sin laacani, bia' naná gaca para lii gu'nu irá nga ne cheu' gabiá. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ne zaqueca pa nuu xiixa cayuuya lu' cuchiiña lii gu'nu ni cadi jneza la? bixele zitu de laani, purti cadi tan naná zaca para lii ixele lu de laani ne gapu enda nabani, bia' naná ñaca ni pa nicoou ni cayuuya lu ca, ne nilá lu lu bele. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Laguuya gá cadi udxii deche tu ca nahuiini ni runi cre naa ri', purti zuhuaa ca ángel ni rapa laacabe nezalú Bixhoze ni nuu ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Naa nga Hombre Biseenda Dios, ne benda para gula'ya cani cananiti. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Xi na tu de ndi ya': pa ñapa ti hombre ti gayuaa dendxu ne niniti tobi, ñee qué nusaana be noventa y nueve que ne ñaazi be gui'xhi niyubi be ni biniti que la? ");
INSERT INTO zaiNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ne ora ma bidxela be laame, ñee cadi jma ñeche né be laame que ca xcaadxi dendxu ni qué niniti que la? ");
INSERT INTO zaiNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Zacaca qué racala'dxi Bixhoze tu ni nuu ibá' initi nin tobi de ca nahuiini ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Pa uchee né ti hermanu lii la? yetidxi laabe xi bi'ni be, peru lii siou' ne laabe. Ne pa icaa be stiidxa lu la? ma guca neu laabe ngue. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Peru pa qué na be icaa be stiidxa lu la? biyubi tobi o chupa chinéu ra nuu be ti guna diaga ca ngue xi bi'ni be. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ne pa qué na be chu' be razón la? gudxi ni irá ca hermanu. Ne pa nin zaqué qué na be icaa be stiidxa tu la? óraque ma cadi gapa tu laabe casi hermanu sínuque casi tobi ni qué runi cre Dios o casi cani ruquixe impuestu. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Gabe ca' laatu, tutiica guni perdonar irá ca hermanu rarí la? laca zaca perdonar ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ne laca pa chu' chupa hermanu tobi si ndaani guidxilayú ne inaba ca xiixa lu Bixhoze ni nuu ibá' la? zudii ni laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Purti ra nuu chupa chonna ni cusisaca naa la? galaa de laaca nuaa'. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Oraque bidxiña Pedru ra nuu be ne na rabi laabe: ―Señor, panda tiru gune perdonar ti hermanu ni uchee ne naa. Ñee bia' gadxe la? ");
INSERT INTO zaiNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Para rabi be laa: ―Cadi gadxe si, sínuque setenta de gadxe. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nga runi modo runi mandar Dios xpinni zeda gaca casi ti rey ni gucala'dxi niguixe ca xpinni irá ni nuzaabi laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ne casi bizulú be bisenda caa be laaca', bidxiña tobi ni nuzaabi laabe stale mil. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Peru qué gapa ngue ni quixe ni, para na rey que idoo cabe, laabe ne xheela be ne ca xiiñi be, ne irá ni napa be, para quixe be ni nuzaabi be laa que. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Oraque bizuxibi be xa ñee rey que, ne na be rabi be laa: “Señor, biá naa, uleza naa caadxi, ti quixe ni.” ");
INSERT INTO zaiNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ne biá rey que laabe, bindaa laabe, ne ma qué nuquixe laabe ni nuzaabi be laa que. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Peru casi pe biree be de raqué, bidxaaga be sti xpinni rey que, ne ngue nuzaabi laabe bia' ti gayuaa bexu, para biruuxha be ndaani yanni, rabi be laa: “Gudixe ni nuzaabu naa.” ");
INSERT INTO zaiNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Oraque bizuxibi ngue xañee be ne na: “Biá naa, uleza naa caadxi, ti quixe ni.” ");
INSERT INTO zaiNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Peru qué niná be, laga bidxiga be laa ndaani lidxi guiiba ne na be quixe si irá ni ti iree. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ngue bi'ya ca xcaadxi xpinni rey que, biá ca hombre que ne yetidxi ca ni rey que. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Para guridxi rey que laabe sti tiru, na rabi laabe: “Hombre ni qué iquiiñe'. Xiñee naa bine ni unaba lu naa, bine perdonar lii irá ni nuzaabi lu naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yanna lii, qué ñanda ñá lu stobi ca casi bia'ya lii la?” ");
INSERT INTO zaiNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ne pur ni bi'ni be que, bidxiichi né rey que laabe ne bitiidi laabe lu ná cani rapa ralidxi guiiba', ne na guiaana be raqué dede ora ma gudixe be irá ni nuzaabi be que. ");
INSERT INTO zaiNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Zacaca zuni Bixhoze ni nuu ibá' laatu pa qué guni perdonar tu ca hermanu stitu ni uchee né laatu, de idubi ladxidó' to. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Biluxe si uní' Jesús ca diidxa ca, biree de Galilea uyé neza Judea cherica guiigu Jordán. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yenanda jma binni laabe ne raqué bisianda be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Oraque beeda caadxi fariseu ra nuu be, cuyubi ca modo usaba ca laabe pur ni iní' be. Para na ca rabi ca laabe: ―Ñee nou' jneza ilaa né cabe xheela cabe pur intiica cosa la? ");
INSERT INTO zaiNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Oraque rabi be laaca': ―Qué xa huayuunda tu ra cá xi bi'ni Dios dxi bizulú bizá' binni. Bizá' be hombre ne gunaa, ");
INSERT INTO zaiNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ne na be: “Pur nga runi zusaana hombre bixhoze ne jñaa, ne zadxaaga xheela ne zaca ca tobi si.” ");
INSERT INTO zaiNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ne zacá ma cadi chupa cabe sínuque tobi si laacabe. Pur nga runi ni ma bichaaga Dios la? ma cadi indaa binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Para na ca fariseu rabi laabe: ―Peru xiñee bisiidi Moisés laadu naquiiñe indisa du acta de divorcio ne óraque ma zaa ilaa né du xheela du ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Para na be rabi be laaca': ―Purti naguidxi ladxidó' to, nga runi gudxi be laatu zaa ilaa né tu xheela tu, peru cadi zacá guca ni dxi bizulú ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Peru naa rabe laatu, tutiica gaca divorciar né xheela ne ichaganá stobi, neca qué nuchee xheela la? ma enda rapa jnadxii ngue. Ne tu ichaganá ti gunaa ma guca divorciar né xheela la? laca zaqueca cayuni. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Para na ca discípulu stibe rabi laabe: ―Pa zacá nou' guni hombre ne xheela la? jma nagueenda guiaana cabe sin ichaganá cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Oraque na be rabi be laaca': ―Cadi irá zanda guiaana sin ichaganá', sínuque cani ma nexhe ni para laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Purti nuu hombre riale maca para cadi ichaganá', ne nuu xcaadxi ni nuu pe tu runi ni laa para cadi ichaganá'. Peru laca nuu ni riale ni de laa si guiaana sin ichaganá', purti jma cá ique guni xhiiña Dios ni nuu ibá'. Cani zanda guiaana sin ichaganá la? cadi ichaganá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Oraque bedané cabe caadxi ba'du ra nuu Jesús para quixhe ná luguiá ca' ne iní' né Dios pur laaca'. Ne ora bi'ya ca discípulu que zeeda cabe la? udinde né ca laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Peru óraque na Jesús rabi laaca': ―Cadi ucueeza tu ca ba'du ca, zaa gueeda cabe ra nuaa', purti stícabe irá ni napa Dios ladxi ná', laacabe ne irá casi laacabe ca. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ne óraque gudixhe ná Jesús ique ca ba'du que, ne biree ze'. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Bidxiña ti hombre ra nuu Jesús ne na: ―Maistru cha'hui', xi enda nacha'hui naquiiñe gune para gapa enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Para na Jesús rabi laabe: ―Xiñee gudxi lu naa zacá. Iruti ru nacha'hui jma que tobi lucha Dios. Pa racala'dxu gapu enda nabani la? bi'ni ni na ca mandamientu. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Oraque na be: ―Uná mandamientu. Para na Jesús rabi laabe: ―Cadi guuti lu binni, cadi chu' neu ni cadi xheelu', cadi cuana lu', cadi cueeu falsu luguiá stobi. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gunaxhii bixho'zo ne jñoou', ne gunaxhii stobi cásica nadxii lu lii. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Para na be: ―Irá nga huayune dede dxi nahuiine'. Yanna xi ru riaadxa'. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Para na Jesús rabi laabe: ―Pa qué racala'dxu usiaadxa lu nin caadxi la? yeutoo ni napu', ne bidii ni ca pobre ne zapu stale ni risaca ibá'. Oraque dananda naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ne ora bina diaga be xi na Jesús la? uyuu yuuba ladxidó' be ne biree be ze be purti nabé ricu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Oraque na Jesús rabi ca discípulu: ―Gabe ca' laatu, nabé nagana zaca para ricu chu' lade ca xpinni Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ne chi tidxe ni laatu sti tiru. Jma qué igana chu' ti camellu xa'na ti aguxa' que chu' ti ricu lade ca xpinni Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nabé bidxagayaa ca discípulu ni uní' Jesús que, ne na ca': ―Tu zanda ilá pue. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Biiya dxí Jesús laacabe ne na rabi laacabe: ―Nabé nagana ndi para binni guidxilayú peru para Dios gasti ni nagana. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Oraque na Pedru rabi laabe: ―Laadu ya', xi zacaa du, ma bisaana du irá xixé ne ma beda nanda du lii. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Para na be rabi be laaca': ―Chi tidxe ca' ndi laatu: dxi guzulú guidxilayú cubi ne guseenda Dios naa cue casi rey la? dxi que laca zudiee laatu ra cui tu para guni mandar tu cani za de idubi doce xiiñi Israel, purti uzá né tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ne tutiica gusaana lidxi o bi'chi o biza'na o bixhoze o jñaa o xheela o xiiñi o xquidxi pur naa la? zacaa ti gayuaa tantu de ni bisaana que, ne zapa enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Peru stale de cani za niru ziaana atrá ne zaqueca stale de cani za atrá, zazá niru. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Modo runi mandar Dios xpinni zeda gaca casi ti hombre, xpixuaana ti layú. Siadó' ro' biree ziyubi tu guni dxiiña lu jlayú. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ne biaana né be caadxi ni bidxela be óraque quixe be laaca ti denariu ti dxi. Para biree ca ziguni ca dxiiña que. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Dxi queca biree be uyé be galahui bia' las nueve, biiya be zuhuaa caadxi, gasti cayuni. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Para rabi be laaca': “Napa dxiiña guni tu ne zaguixe laatu bia' jneza guiaxa tu.” Para biree ca ze ca' ziguni ca xhiiña be. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Biree be sti tiru bia' galaa dxi ne sti tiru bia' las tres, ne casi bi'ni be primé que zaqueca bi'ni be óraque. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Biree ru be sti tiru bia' las cincu ne bidxela be xcaadxi zuhuaa, gasti cayuni. Para na be rabi be laaca': “Xiñee idubi dxi nuu si tu.” ");
INSERT INTO zaiNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Para na ca': “Purti iruti nudii dxiiña laadu.” Para na be: “Lachiguni dxiiña lu layú stinne', ne zaguixe laatu bia' jneza guiaxa tu.” ");
INSERT INTO zaiNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Huaxhinni que na be rabi be ni rapa xpidxichi be: “Guridxi cani cayuni dxiiña ca ne gudixe laaca'. Bizulú né cani biuu últimu ne biluxe né cani biuu primé.” ");
INSERT INTO zaiNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ne ora bidxiña cani uyé bia' las cincu que, ucuaa ca ti denariu cada tobi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ne ora beeda cani uyé siadó' que, zácaxa ca nicaa ca jma stale, peru laca bia' queca ucuaa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ne ora bi'ya ca bia' queca ucuaa ca la? bidxiichi né ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ne na ca': “Ca ndi ti hora si bi'ni ca dxiiña ne gudixe lu laaca bia' ca gudixe lu laadu, laa nda du bidxuí du idubi dxi.” ");
INSERT INTO zaiNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Para na be rabi be tobi de laaca': “Xhamigua', qué niguite dia' lii. Ñee cadi biaana nia lii icoou ti denariu la? ");
INSERT INTO zaiNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ucuaa stiu' ne uyé. De naa pia' beeda ni bidiee laacabe bia' bidiee lii. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ñee qué zanda gune nia stinne ni racaladxe la? o cadxiichi tu tisi guca nacha'hui ne laacabe la?” ");
INSERT INTO zaiNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Zacá nga laani, stale de cani biaana atrá zazá niru, ne zaqueca stale de cani za niru, ziaana atrá. Ne stale tu raca invitar, peru huaxié' tu zanda guiuu. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ti dxi ze Jesús neza Jerusalén, ucuaa idubi doce discípulu sti' ne biree chu ne laacabe ti ladu, ne na rabi laacabe: ");
INSERT INTO zaiNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Laguuya', mayaca guiu' nu Jerusalén, ne raqué inaaze ca xaíque sti ca sacerdote ne ca maistru de ley naa, ne zanaba ca gate'. Naa nga Hombre Biseenda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Zutiidi ca naa lu ná cani cadi judíu para guxidxi ca ngue de naa ne quiñe ca naa ne ucaa ca naa lu cruz, peru raguionna gubidxa ziasa de lade gue'tu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Oraque bidxiña né xheela Zebedeu iropa xiiñi ra nuu Jesús, ne bizuxibi xañee Jesús ne na rabi laabe pa zuni be xiixa para laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Para na be rabi be laa: ―Xi racala'dxu gune'. Oraque na gunaa que: ―Xiñee qué cueeu ti orde cui iropa xiiñe ri cue' lu dxi guni mandar lu', tobi ladu derechu ne stobi ladu biga'. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Peru na be rabi be ca xiiñi gunaa que: ―Qué ganna tu xi canaba tu. Ñee zanda gacaná tu casi chi gaca na'ya', ne tidi tu ni chi tide ri la? ―Zanda, na ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Oraque na be: ―Dxandí zacaná tu ne zadi'di tu casi chi tide', peru para cui tu cuee ladu derechu ne ladu biga la? cadi nexhe ni lu naya para gudiee', purti maca gudixhe Bixhoze tuu nga icaa ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ne ora bina diaga xhii discípulu que de ni guca que la? bidxiichi né ca xhupa que. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Peru guridxi Jesús laacabe ne na rabi laacabe: ―Nanna tu modo sti cani runi mandar ndaani guidxilayú, runi stica irá binni ni runi mandar ca'. Ne zaqueca ca hombre ni risaca, riula'dxi ca guni binni ni na ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Peru laatu cadi guni tu zacá lade tu, sínuque tu gacala'dxi isaca jma la? napa xidé gaca casi jmozo ca xcaadxi. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ne zaqueca guni tutiica gacala'dxi sa niru, ");
INSERT INTO zaiNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","casi huayune lade tu. Naa nga Hombre Biseenda Dios ne benda cadi para gacané cabe naa, sínuque para gacaniá laacabe ne para udiee xpida para ilá stale binni. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ora biree cabe de Jericó, yenanda jma binni laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ne ruaa neza ra zidi'di cabe que zuba chupa hombre nacheepa lú. Ne ora gunna ca zidi'di be raqué la? bicaa ca ridxi ne na ca': ―Señor, Xiiñi David, biá laadu. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Oraque udinde né ca binni que laaca para nigani ca', peru laga jma rusi reciu bicaa ca ridxi ne na ca': ―Señor, Xiiñi David, biá laadu. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Para bizuhuaa dxí Jesús ne guridxi laaca', ne na rabi laaca': ―Xi racaladxi tu gune para laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Para na ca': ―Señor, racala'dxi du ixele lú du. ");
INSERT INTO zaiNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Oraque biá Jesús laaca ne uda'na lú ca'. Ne oraqueca bixele lú ca' ne yenanda ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ma zeda dxiña cabe Jerusalén, bedandá cabe Betfagé, cue' dani lá Olivo. Ne de raqué na Jesús rabi chupa discípulu sti': ");
INSERT INTO zaiNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","―Laché ndaani guidxi huiini ni nuu checá ca, ne casi chindá tu raqué zadxela tu ti burra cá yaga ne cá ti burru huiini cue' me. Lauxhedxe laacame ne latané laacame ra nuaa'. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ne pa chu' tu gabi laatu xiñee cuxhedxe tu laacame la? lagabi laaca caquiiñe Señor laacame, ne óraque zudii ca lugar guedané tu laacame. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Irá nga guca ti iree ni modo pe uní' Dios de ruaa profeta que, ra na: ");
INSERT INTO zaiNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Lagabi ca binni guidxi Sion gu'ya ca', zeeda rey stica ra nuu ca'. Nadó' zeeda be ne dxi'ba be deche ti burru huiini', xiiñi ti mani ni rigu'ba carga. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Para biree ca discípulu que ze ca' ne bi'ni ca casi gudxi Jesús laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bedané ca burra ne burru huiini que, ne gudixhe ca xhaba ca deche came, para udxi'ba Jesús deche nahuiini que. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Stale binni ni rí raqué bichiaa ca xhaba ca lu neza ra zidi'di be, ne xcaadxi bichuugu rama ne gudixhe ni lu neza que. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ne ca binni ni za niru, ne cani nanda atrá, cucaa ca ridxi, na ca': ―¡Lacuu viva sti xiiñi rey David! ¡Lausisaca laabe ti Dios biseenda laabe ne lausisaca Dios ni dxi'ba ibá'! ");
INSERT INTO zaiNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ne ora ziyuu be ndaani guidxi Jerusalén, bi'ni ca binni guidxi que bulla ne na ca': ―Tu hombre ri pue. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Para na ca xcaadxi binni que: ―Ndi nga Jesús profeta ni biree de Nazaret de Galilea que. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Oraque biuu be ndaani yu'du ro' sti Dios, ne guladxi be irá cani cutoo ne ni cazí' ndaani yu'du que, ne bitiixhi be jmexa cani cuchaa bidxichi ne xpangu cani cutoo paloma. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ne na be rabi be laaca': ―Maca cá ni lu Xqui'chi Dios ra na: “Lidxe nuu para iní' né cabe naa ndaani'.” Peru laatu laga ma bi'ni tu ni lidxi gubaana'. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nuu ru be ndaani yu'du ro' beeda caadxi ni nacheepa lú ne caadxi ni nachiita ñee ra nuu be, para bisianda be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Peru cayuuya ca xaíque sti ca sacerdote ne ca maistru de ley irá ca milagru ni cayuni be que. Ne laca cayuna diaga ca modo cucaa ca ba'du ni nuu ndaani yu'du que ridxi: “Lausisaca xiiñi rey David.” Ngue runi bidxiichi né ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ne na ca rabi ca laabe: ―Ñee cadi cayuna diaga lu ni caní' ca ba'du ca la? Para na be: ―Cayuna dia'ga pue. Qué xa huayuunda tu lu Xqui'chi Dios ra cá: Gudixhe lu usihuinni ca xcuidi huiini ne ca badu huiini enda nandxó' stiu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ngue si uní' be, bisaana be laaca' bixele be de guidxi que, uyé be Betania ne raqué biaana be huaxhinni que. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Siadó' que biree be ze be Jerusalén sti tiru. Ze be neza, bindaana be. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ne biiya be zuhuaa ti yaga du'ga uriá neza que, para bidxiña be ra nuu. Peru qué nidxela be nin ti du'ga', nisi bandaga cá lu ni. Para na be rabi be yaga que: ―Qué ziuu dxi ru icá nin sti du'ga lú lu'. Ne oraqueca bibidxi yaga que. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ora bi'ya ca discípulu ni, nabé bidxagayaa ca ne na ca': ―Ximodo gunda bibidxi yaga ca casi ze'. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Para na be rabi be laaca': ―Gabe ca' laatu, pa gapa tu fe ne qué ichaacha tu de laani la? cadi ni bine sia' ri' zanda guni tu, sínuque zanda gabi tu dani ca iree de racá guiaba ndaani nisadó', ne ziaba ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Irá ni inaba tu ora iní' né tu Dios, pa inaba tu ni ne fe la? zacaa tu ni canaba tu que. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Bigueta ru be ndaani yu'du ro', ne laga cusiidi be bidxiña ca xaíque sti ca sacerdote ne ca xaíque sti guidxi que ra nuu be, na ca rabi ca laabe: ―Tu naca lu para cayu'nu irá ndi', o tu gudxi lii gu'nu cani. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Para rabi be laaca': ―Naa laca napa xiixa inaba diidxa laatu, ne pa gabi tu naa ni chi inaba diidxa laatu ri la? laca zabe laatu tu naca para cayune cani. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Xi na tu de ni bi'ni Juan ra beda nduu nisa binni ya'. De Dios zeeda ni la? o de binni guidxilayú. Oraque ucuaa yu né ca ni ne na ca': ―Pa gabi nu laabe zeeda ni de Dios la? zabi be laanu xiñee qué ñuni cre nu ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","O pa gabi nu laabe zeeda ni de binni guidxilayú la? gapa gá si nu laanu ne idubi guidxi ri' purti napa cabe Juan de profeta sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Para na ca rabi ca laabe: ―Qué ganna di du. Oraque rabi be laaca': ―Nin naa qué zabe laatu tu gudxi naa gune ni rayune ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Xi na tu de ndi ya'. Ti hombre gupa chupa xiini', ne ti dxi rabi be ni jma huaniisi que: “Uyé rañaa yanadxí, xiiñe'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Para na rabi laabe: “Qué ziaa dia'.” Peru ratu si que uca arrepentir, ne biree uyé. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Oraque bidxiña be ra nuu stobi que, ne zaqueca gudxi be laa. Para na rabi laabe: “Nagasi ma chaa', apá.” Peru qué ñe. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yanna xi na tu. Uná de lade iropa cabe bi'ni ni na bixhoze. Para na ca': ―Primé que. Oraque na be rabi be laaca': ―Gabe ca' laatu, jma nagueenda ziuu cani ruquixe impuestu ne ca gunaa dxaba ra runi mandar Dios que laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Purti beda usiidi Juan Bautista ximodo sa tu jneza ne qué ñuni cre tu laa. Peru cani ruquixe impuestu ne ca gunaa dxaba la? bini cre ca'. Laatu neca biiya tu irá, qué nuchaa tu xpia' tu ne qué nuni cre tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Lauca diaga sti ejemplu chi tixhe ri'. Sicarí bizaaca lú xpixuaana ti layú. Bizuhuaa be yaga uvas lu layú que, ne guluu be le' ni, ne bi'ni be pila para ixii uvas ndaani', ne bicui be ti torre ra guiaana ni gapa ni. Biluxe bi'ni si be ni, bisaana né be ni caadxi hombre gapa ni, ti ora udii ni la? icaa né be ni laaca'. Ne biree be yendeza be zitu de raqué. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Dxi ma gunda dxi iruugu uvas que, biseenda be caadxi xpinni be, chi caa ni raca caber laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Peru cani bisaana né be ni que, laga udiñe ca ti xpinni be que ne biiti ca stobi ne bichá ca guie stobi. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ne óraque biseenda be jma stale que cani uyé que, peru laca zaqueca bi'ni ca hombre que laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ultimu na be: “Chi guseenda xiiñe', zanda ca gapa xpia' cabe ne laa.” ");
INSERT INTO zaiNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Peru ora bi'ya cani cayapa layú que xiiñi be la? uní' stiidxa ca na ca': “Ndi nga ni icaa irá ni. Laguuti laa ti guiaana né nu irá sti'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ne ulee ca laabe de ndaani le' que para biiti ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yanna xi na tu, xi gaca xa de cani biaana né layú que dxi gueeda xpixuaana ni ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Para na ca xaíque sti ca sacerdote ne ca xaíque sti ca judíu: ―Qué lica ziá be laaca para guuti be laaca'. Ne zusaana né be layú que xcaadxi ni zaná gudii laabe cuananaxhi ni iree ndaani le' que. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Oraque na be rabi be laaca': ―Qué huayuu dxi gu'nda tu lu Xqui'chi Dios ra cá ca diidxa ri la? Guie ni bisa'bi cani cucuí yoo que, guie que pe naaze yoo que yanna. Nga nga ni bi'ni Dios, ne para laanu ma enda ridxagayaa ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Pur nga runi cayabe laatu ziaaxha tu de lade ca xpinni Dios ne ma adxé tu guiuu jlugar tu, tobi ni zanda iquiiñe para laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ne tu guiaba lu guie ni bisa'bi cabe que zacadé, ne zaqueca tu guiaba guie que luguiá laca zacadé. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ne biluxe si bicaa diaga ca xaíque sti ca sacerdote ne ca fariseu ca ejemplu gudixhe be que la? biene ca cuzeete be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ne óraque ucala'dxi ca ninaaze ca laabe peru bidxibi ca ca binni guidxi que purti napa ca laabe de profeta. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Bigueta gudixhe ru Jesús xcaadxi ejemplu para laacabe, na: ");
INSERT INTO zaiNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Enda runi mandar sti Dios zeda gaca casi ti rey ni guluu saa ra biluxe xquenda xheela xiiñi'. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bisenda tidxi be cani maca bini invitar be ñeeda, peru qué niná ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Bigueta rabi be xcaadxi xpinni be: “Laché lachitidxi cani bine invitar gueeda ra enda xheela ri' purti ma nuu irá ni, ma biite yuze ro' ne yuze huiini ni bisiruaa, ne ma nuu endaró.” ");
INSERT INTO zaiNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Peru nin óraque qué nulabi ca stiidxa be, lágala biree tobi ze rañaa ne stobi ziutoo, ");
INSERT INTO zaiNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ne xcaadxi de laaca gunaaze ca cani biseenda be que, udiñe ca dede biiti ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ne ora gunna be xi bi'ni ca la? nabé bidxiichi be ne biseenda be ca soldadu stibe, yeguuti cani biiti xpinni be que ne bicaa gui be xquidxi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Oraque na be rabi be ca xpinni be: “Dxandí ma nuu enda xheela ri para gaca', peru qué iquiiñe cani bine invitar para laani. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yanna, laché lu calle ne tutiica idxaaga tu lacuidxi laa para enda xheela ri'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Para biree ca xpinni be que lu calle ne bitopa ca irá ni bidxaaga ca', cásica ni nacha'hui zaqueca ni nadxaba', ne zaqué de bidxá ra chi gaca enda xheela que de binni. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Oraque biuu be cayuuya be irá ca' ne biiya be nuu ti hombre cadi nacu lari para enda xheela'. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Para na be rabi be laa: “Amigu, ximodo biuu lu rarí pa cadi nacu lu lari para enda xheela'.” Peru qué nidxela hombre que xi niní'. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Oraque rabi be cani canaguiizi': “Laundiibi ná be ne ñee be, ne laundaa laabe lu guelacahui ne raqué nga gu'na be dede go yaa be guidi ruaa be.” ");
INSERT INTO zaiNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ne óraque na Jesús: ―Stale tu raca invitar peru huaxié' tu zanda guiuu. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Oraque biree ca fariseu yení' stiidxa ca ximodo zanda usaba ca Jesús lu stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ne biseenda ca ca discípulu stica ne caadxi de ca judíu ni nuu pur Herodes ra nuu be, ne na ca rabi ca laabe: ―Maistru, nanna du jneza runi lu' ne dxandí neza sti Dios rusiidi lu', ne qué rugá lu iruti tutiica naca. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gudxi laadu xi na lu de ndi': Ñee jneza quixe nu ca impuestu sti César la? o co'. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Peru ma nanna be cuyubi si ca usaba ca laabe, para rabi be laaca': ―Xiñee cuyubi tu usaba tu naa, binni rusiguii ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Latané ti moneda ni riguixe tu impuestu ca, guuya'. Para bidii ca laabe ti denariu. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Oraque rabi be laaca': ―Tu cá lú ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Para na ca': ―César. Oraque na be: ―Laudii César sti César, ne laudii Dios sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ne ora bina diaga ca xi na be la? nabé bidxagayaa ca ne biree ca ze ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dxi queca beeda caadxi saduceu, cani na qué riasa binni de lade gue'tu', ne unaba diidxa ca laabe, ");
INSERT INTO zaiNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","na ca': ―Maistru, uní' Moisés pa chu' ti hombre ichaganá', ne gueda gati qué ñapa xiiñi la? naquiiñe ichaganá bi'chi be xheela be ne gapa xiiñi casi ñaca xiiñi be. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Guyuu gadxe hombre lade du, irá ca bi'chi ca'. Bichaganá lugola que, ne guti qué ñapa xiiñi'. Para biaana né bi'chi be xheela be. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ne zaqueca bizaaca rabiropa que ne rabionna, dede ra birá cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ne ra birá cabe que raqué guti gunaa que. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yanna, xi na lu'. Dxi ibani gue'tu ya'. Uná de lade gadxe que xheela gunaa que, purti irá cabe bichaganá cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Oraque na Jesús rabi laacabe: ―Cuchee tu purti qué ganna tu xi na Xqui'chi Dios nin pabiá' nandxó' be. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Purti dxi ibani gue'tu la? qué zachaganá cabe ne qué zucheela cabe sínuque zaca cabe casi ca ángel sti Dios ni nuu ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Laatu canaba diidxa tu de enda ribani de lade gue'tu'. Qué xa huayuunda tu ra cá xi gudxi Dios laatu ra na: ");
INSERT INTO zaiNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Naa nga Dios sti Abraham, ne sti Isaac ne sti Jacob.” Ne dxi uní' Dios nga la? ma guti cabe para binni, peru para Dios nabani ru cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ne ora bina diaga irá binni ni nuu raqué ni la? bidxagayaa ca modo cusiidi be que. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ora gunna ca fariseu ma biseegu Jesús ruaa ca saduceu la? uyuu ca tobi si ne uní' stiidxa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nuu ti maistru de ley lade ca' ne uyé ngue ra nuu be para gu'ya pa ganda usaba laabe. Ne na rabi laabe: ");
INSERT INTO zaiNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maistru, uná nga mandamientu ni jma risaca lade idubi ley. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Para na be rabi be laa: ―“Gunaxhii Dios stiu' de idubi ladxidó' lo' ne idubi xhialma lu' ne idubi xquenda biaani lu'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nga nga primé mandamientu ne ni jma risaca. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ne rairopa ri zeda gaca casi primé ca: “Gunaxhii stobi cásica nadxii lu lii.” ");
INSERT INTO zaiNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Iropa ca mandamientu ca nga xcu idubi naca ley ne ni bicaa ca profeta. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ne laga rí ru ca fariseu raqué ");
INSERT INTO zaiNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","rabi be laaca': ―Yanna xi na tu de Cristu, tu dé za be. Para na ca': ―Lade ca xiiñi David. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Para na be rabi be laaca': ―Pa zacá nga laani la? xiñee dxi bisiní' Espíritu Santu David, na Señor sti laabe ya'. Purti ndi nga ni uní' David óraque: ");
INSERT INTO zaiNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Na Dios rabi Señor stinne': “Gurí cuee dede ora ma gudixhe dxie cani nanala'dxi lii xañee lu'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Pa rabi David laabe Señor sti la? ximodo zanda gaca be xiiñi David ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Peru nin tobi de laaca qué nidxela xi niní', ne dede dxi que bidxibi ca ninaba diidxa ca laabe xiixa. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Bizulú uní' né Jesús ca binni que ne ca discípulu sti', ");
INSERT INTO zaiNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","na rabi laacabe: ―Nuu ca maistru de ley ne ca fariseu para gusiidi ca ley sti Moisés. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nga runi cayabe laatu guni tu ni na cabe. Pa gabi cabe laatu chi nanda tu xiixa la? lachinanda ni, ne laguni ni. Peru qué chi guni tu casi runi cabe, purti riní' cabe peru qué runi cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Modo runi cabe ca zeda gaca casi ñaca nundiibi cabe xiixa nanaa ne nudxiiba cabe ni yanni stobi, peru laacabe qué racala'dxi cabe cana cabe ni, nin ne ti bicuini ná cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Riula'dxi cabe gu'ya binni pabiá' zinanda cabe ley sti Moisés, dede ricaa cabe ca gui'chi ra cá ni, rundiibi cabe ni lu ná cabe ne lucuá cabe, ne ruzigueda cabe jluxu lu xhaba cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ne zaqueca runi cabe ra chi tó cabe, riula'dxi cabe cui cabe lugar ni nuu para binni ni jma risaca. Ne zaqueca cui cabe lu ca banca ni jma galán ndaani yu'du'. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Riula'dxi cabe ugapa diuxi binni laacabe lu calle ne irá binni gabi laacabe maistru, maistru. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Peru laatu cadi chu'la'dxi tu gabi cabe laatu maistru, purti tobi si maistru nga nuu, ne laa nga Cristu. Laatu la? bi'chi irá tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ne cadi guni bixhoze tu nin tobi de cani nuu ndaani guidxilayú purti tobi si nga Bixhoze tu ni nuu ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Zaqueca cadi chu'la'dxi tu guni cabe laatu xaíque purti tobi si nga xaíque stitu, ne laa nga Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ni jma risaca lade tu la? napa xidé gaca casi jmozo ca xcaadxi. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ni gudxiiba laca laa la? jma huaxié' zasaca, peru ni qué gudxiiba laca laa la? ngue zusisaca Dios laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Lagapa gá laatu, maistru de ley ne fariseu ca', purti nisi rusiguii tu. Ne pur laatu qué ganda chu' binni lade ca xpinni Dios. Qué na tu chu' tu, ne nin qué na tu chu' cani racala'dxi chu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Lagapa gá laatu, maistru de ley ne fariseu, binni rusiguii ca', purti raxha tu lidxi cani ma guti xheela' ne para cadi uluí' pa laatu cayuni tu ni, runi tu resá xadxí. Nga runi jma ziaba ná tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Lagapa gá laatu, maistru de ley ne fariseu, binni rusiguii ca', purti ridi'di tu nisadó' ne rizá tu zitu para idxela tu tu chu' lade tu. Ne ora ma nuu be lade tu la? runi tu laabe xiiñi binidxaba chupa de bia' naca tu ca. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Lagapa gá si laatu purti nin laatu qué ganna tu, peru racala'dxi tu usiidi tu stobi, ne rabi tu laaca': “Tu guni jurar pur yu'du ro' la? gasti naca pa qué guni ni ma uní'. Peru tu guni jurar pur ca oro ni nuu ndaani ni la? laa huaxa naquiiñe guni ni iní'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Binni huati ca', qué riene tu nja'. Ñee cadi jma risaca yu'du que, que oro ni nuu ndaani ni la? purti pur yu'du que nga guca ndaaya oro que. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ne laca na tu: “Tu guni jurar pur altar la? gasti naca pa qué guni ni ma uní', peru tu guni jurar pur ni nexhe lu altar que la? laa huaxa naquiiñe guni ni iní'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Binni huati ca', qué riene tu nja'. Lácaxa cadi jma risaca altar que, que ni nexhe lú, purti pur altar que nga raca ndaaya ni nexhe lú. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ndi nga laani: tu guni jurar pur altar la? cayuni jurar pur laani ne pur ni nexhe lú ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ne zaqueca tu guni jurar pur yu'du ro' la? cayuni jurar pur Dios purti Dios nga nuu ndaani ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ne tu guni jurar pur ibá' la? cayuni jurar pur ra zuba Dios ne pur Dios purti laa nga zuba raqué. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Lagapa gá si laatu, maistru de ley ne fariseu, binni rusiguii ca', purti dede ca guixi rindá' naxhi casi menta ne anís ne cominu runi tu cani chii ndaa, ne rudii tu tindaa Dios, peru qué rulabi tu ni jma naquiiñe guni tu ni zeeda lu ley. Ruchee né tu binni ne qué riá tu laaca', ne qué runi cre tu Dios. Ca nga nga ni jma naquiiñe guni tu, peru laca cadi gusaana tu de guni tu ca xcaadxi ca. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Binni lú cheepa ca', racala'dxi tu uluí' tu stobi peru nin laatu qué ruuya tu. Zeda gaca ni casi ñaca nibee tu biuxi lu endaró peru ñabi tu idubi ti camellu. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Lagapa gá si laatu, maistru de ley ne fariseu, binni rusiguii ca', purti zeda gaca tu casi vasu ne bladu ni ria'ri ladi si, peru ndaani cani nabiidi'. Zacaca laatu, de luguiá si ruluí' nacha'hui tu, peru ndaani ladxidó' to nabiidi purti riba'na tu sti binni ne nalá tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseu lú cheepa ca', lagaca nacha'hui de ladxidó' to ne cadi de luguiá si. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Lagapa gá si laatu, maistru de ley ne fariseu, binni rusiguii ca', purti zeda gaca tu casi ba', naquichi bé idubi ladi ne sicarú, peru ndaani dxá dxita gue'tu', ne irá ni nayuudxu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Zacaca laatu. Para binni la? ruluí' nacha'hui tu purti ruuya ca de luguiá si, peru ndaani ladxidó' to dxá de enda rusiguii ne de enda nadxaba'. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Lagapa gá si laatu, maistru de ley ne fariseu, binni rusiguii ca'. Runi tu xpa' ca profeta ne ruzuchaahui tu xhiu'du ca xpinni Dios ni ma guti, ");
INSERT INTO zaiNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ne na tu: “Pa nibani nu dxi bibani ca bixhoze gola nu la? qué ñacané nu ra biiti cabe ca profeta.” ");
INSERT INTO zaiNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ne racá rihuinni laca laatu cabee ruaa tu diidxa tu xiiñi laatu purti laatu nga xiiñi cani biiti ca profeta que. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yanna laatu lausaa chaahui ni biaadxa ñuni ca bixhoze gola tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Binni malu ca', ruluí' pe tu beenda gubizi. Zácaxa tu zanda ilá tu de che tu gabiá xa. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nga runi zuseenda profeta ne hombre nuu xpiaani ne maistru ra nuu tu. Peru zuuti tu caadxi de laaca', ne nuu dede zucaa tu laa lu cruz, ne xcaadxi zaguiñe tu laaca ndaani xhiu'du tu ne zaladxi tu laaca de ti guidxi para sti guidxi. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ne luguiá tu guiaana donda pur ca rini bixii sti irá hombre cha'hui ni huayuuti cabe dede dxi guti Abel para dxi guti Zacarías xiiñi Berequías, ni biiti cabe lade yu'du ro' ne altar ni nuu lu patiu. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Gabe ca' laatu, irá nga ziaba luguiá ca binni nuu yanna ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ne óraque na Jesús: ―Ah binni Jerusalén, Jerusalén, xiñee ndi ruuti tu ca profeta ne ruchá tu guie cani ruseenda Dios ra nuu tu. Panda que tiru gucaladxe ñapa laatu ndaani naya casi runi bere ne ca xiiñi xa'na xhiaa, peru qué niná tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Para si yanna ma biaana stubi lidxi tu ne iruti culabi laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ne gabe ca' laatu, dede yanadxí ma qué zuuya ru tu naa, dede ganda dxi gu'ya tu naa ne na tu: “Lausisaca ni biseenda Dios.” ");
INSERT INTO zaiNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Biree Jesús de ndaani yu'du ro' ne ma che be sti ladu, beeda ca discípulu stibe ne biluí' ná ca laabe ca yoo sti yu'du que. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Para rabi be laaca': ―Ruuya tu irá ndi la? Gabe ca' laatu ziuu tu guxhá ni ne qué ziaana nin ti guie luguiá sti guie, de irá ni zanitilú. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Biree cabe raqué uyé cabe lu dani Olivo ne raqué gurí be, para bidxiña ca discípulu ra nuu be ne na ca rabi ca laabe: ―Laga nuu nu laasi nu, racala'dxi du ganna du padxí nga nou' gaca irá ni gu'dxu laadu que. Ne xi seña ihuinni dxi mayaca gueedu ne iluxe guidxlayú ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Para na be rabi be laaca': ―Laguuya gá qué chu' tu quite laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Purti zeeda stale ni usiguii, zaná ca laaca nga Cristu, ne zabee chu ca stale binni. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ne zanna tu cayaca guerra ti ladu ne nuu de gaca ni sti ladu, peru cadi idxibi tu purti naquiiñe gaca irá nga. Peru neca ne nga la? ca'ru idxiña dxi iluxe pe guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Purti zucaa lú ti gobiernu sti gobiernu ne zucaa lú ti guidxi sti guidxi, ne ziuu enda huará zaguixhe idubi naca ti guidxi, ne zaca gubiña ne xu stale lugar. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ne neca ma cayaca irá nga la? laganna raqué ru nga bizulú enda naná que. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Zutiidi cabe laatu lu ná cani guniná laatu ne zuuti cabe laatu, ne zaca nanala'dxi binni de irá ladu laatu purti xpinne laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ne stale tu zaxele de naa ne zuluí' saa ca laaca' ne zaca nanala'dxi saa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Laca ziasa stale profeta ma na ca de Dios zeeda ca', para usiguii si ca ne zabee chu ca stale binni. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ne ora ma bidale enda ruchee ndaani guidxilayú la? casi irá binni zusaana de ganaxhii saa. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Peru tu qué ixhacala'dxi dede dxi iluxe irá ni la? zalá. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ne zui' cabe stiidxa Dios de idubi naca guidxilayú para ganna irá xixé guidxi modo runi mandar, ne dxi que ru nga iluxe guidxilayú ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Bizeete profeta Daniel de dxa ni runi yuudxu ne ni runitilú que, ne ora gu'ya tu ma zuhuaa ni ndaani yu'du ro' lugar ra jma risaca la? laguxooñe'. (Tu gu'nda gui'chi ri la? guiene.) ");
INSERT INTO zaiNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Cani nuu Judea, che lade dani. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ne ni dxi'ba ique yoo la? cadi guiete chi caa xiixa ralidxi. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ne ni nuu rañaa cadi ibigueta yoo para chi topa xhaba. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Peru naná zaca para ca gunaa ni naca xiiñi' ne cani cugadxi ca dxi que. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lainaba lu Dios cadi dxi pe guxooñe tu ca guiaba nanda, nin gaca ni dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nabé naná zaca ni ca dxi que. Qué huayuu dxi gaca ni naná bia' qué, dede dxi bizá' Dios guidxilayú, ne ma qué ziuu ru dxi aca ni sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pa qué ucueeza dxí Dios lú ni la? irá xixé binni zati, peru pur ca xpinni be la? zucueeza be ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Pa chu' tu gabi laatu ca dxi que: “Laguuya', rarí nuu Cristu” o “Rarica nuu be” la? cadi guni cre tu laaca', ");
INSERT INTO zaiNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","purti ziasa stale iní' Cristu laa o profeta laa ne zuluí' ca laatu seña nandxó' ne milagru, pa ñanda si nusiguii ca nécaca cani ma ulí Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Cayabe ca' ni laatu de ca yanna. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nga runi pa gabi cabe laatu nuu Cristu ndaani gui'xhi la? cadi chi guuya tu. O pa na cabe nuu be ndaani yoo la? cadi guni cre tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Purti dxi ibigueta Hombre Biseenda Dios la? zaca ni casi ora riuu xpiaani rayu, riguu ni biaani dede ladu rindani gubidxa hasta ladu riaazi', ");
INSERT INTO zaiNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ne laca zaca casi ora ribí zisi so'pe ratiica nuu mani ni ma guti. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Casi pe tidi enda naná ni gaca ca dxi que la? zacahui lu gubidxa ne ma qué zuzaani beeu, ne ziaba ca luceru de ibá', ne zaniibi dxacha irá ni nuu ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Oraque zahuinni seña ibá' ma chi ibigueta Hombre Biseenda Dios sti tiru, ne dxi que nga gu'na irá binni guidxilayú ne zuuya ca zeda yete be de ibá' lade za, ne stale enda nandxó' dede riaqui biaani'. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Oraque zaxidxi trompeta reciu ne zuseenda be ca ángel stibe gueda topa irá ni ma ulí be de idubi naca guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Laicaa ejemplu sti yaga du'ga'. Ora ma gulee ni rama ri'ni ne ma cayapa ni bandaga la? nanna tu ma zeda dxiña tiempu nandá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Zacaca ora gu'ya tu cayaca irá ni ma gudxe laatu ca la? nanna tu ma bidxiña dxi iluxe irá ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Peru gabe ca' laatu zaca irá nga ante gati ca binni nuu yanna ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ziuu dxi initilú ibá' ne guidxilayú peru stiidxa qué ziaana sin gaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Peru padxí ne pora la? iruti ganna, nin ca ángel ni nuu ibá', dede nin naa qué ganna' sínuque Bixhoze sia' nga nanna. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ne dxi ibigueta Hombre Biseenda Dios la? zaca ni casi dxi bibani Noé. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Purti ante gaca fisiu que la? cayó ca binni que ne cayé' ca', cachaganá ca' ne cucheela ca', dede dxi biuu Noé ndaani arca que. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ne ca'ru guiene ca xi chi gaca dede ora beeda nisa que, ziné irá ca'. Zacaca nga zaca ni dxi gueeda Hombre Biseenda Dios que. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dxi gueeda be que la? zándaca nuu chupa rañaa, zie tobi ziaana stobi. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","O ra nuu chupa gunaa tobi si ra cayuutu ca', laca zie tobi ziaana stobi. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nga runi lagataná purti qué ganna tu pora gueeda Señor stitu. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Peru ganna ca tu pa ñanna xpixuaana ti yoo pora gueeda gubaana ralidxi la? ñapa, ne qué nudii lugar niba'na cabe ralidxi. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Zacaca naquiiñe gataná tu. Pacaa mala zuhuaa Hombre Biseenda Dios gu'ya tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Uná nga mozo ni zanda gusaana xpixuaana laa gu'ya irá xpinni ne gudii ni iquiiñe cabe ya'. Ti mozo ni nuu xpiaani ne ni runi jneza. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Dichoso de mozo que pa cayuni zacá ora gueeda xpixuaana'. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Gabe ca' laatu zusaana né xpixuaana be laabe irá ni napa. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Peru pa qué iquiiñe be ne na be zandaa ru gueeda xpixuaana be, ");
INSERT INTO zaiNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ne uzulú be quiñe be xcaadxi xpinni xpixuaana be, ne iree be chi to né be ne chi gue né be binigüé' la? ");
INSERT INTO zaiNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","nin ganna be mala zuhuaa xpixuaana be ne cadi cabeza be laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Zuniná laabe de bia' ganda ti' sin guiá laabe, ne zuseenda laabe lade ca xcaadxi ni qué iquiiñe casi laabe. Raqué nga gu'na be dede go yaa be guidi ruaa be. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Bigueta gudixhe Jesús sti ejemplu de modo runi mandar Dios, na rabi laacabe: ―Sicarí bizaaca lú chii binni dxaapa', ucuaa ca lámpara stica', biree ca zindeza ca ti novio para chiné ca ra xquenda xheela'. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gaayu de laacabe guyuu xpiaani', peru xcaayu que co', ");
INSERT INTO zaiNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","purti ucuaa ca lámpara stica peru qué ñuuya ca pabiá' aceite napa cani. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Peru xcaayu que bichá ca lámpara stica ne yené ru ca xcaadxi ndaani botella. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Qué ñeeda gá novio que ne ucuá bacaanda laacabe, gusi cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Bia' galaa gueela ucuá ridxi: “Ma zeeda novio. Lairee, lachichagalú laabe.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Oraque biasa irá ca badu dxaapa que ne bini chaahui ca lámpara stica'. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Para na cani nahuati que rabi cani nuu xpiaani que: “Lacuee la' caadxi aceite lu stitu latané laadu, purti mayaca gyui' lámpara stidu.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Peru cani nuu xpiaani que, laga na ca rabi ca laacabe: “Para cadi irá stitu ne stidu la? laché lachisí para laatu.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Peru laga zesí cabe que beeda novio, biuu né cani cabeza laa que ra chi gaca enda xheela que, ne bieegu ra puerta'. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ratu si que beeda xcaayu badu dxaapa que ne na ca': “Señor, Señor, bixhele guiu' du.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Para na be rabi be laaca': “Tu laatu ya'. Qué runebia'ya laatu.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nga runi, na Jesús rabi laaca', naquiiñe gataná tu purti qué ganna tu padxí nin pora ibigueta Hombre Biseenda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ne gudixhe ru be sti ejemplu para laaca', na be: ―Enda runi mandar sti Dios zeda gaca casi ti hombre che viaje, peru ante iree be de xquidxi be la? guridxi be ca xpinni be, bisaana né be laaca xpidxichi be. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tobi bidii be laa bia' gaayu mil moneda, ne stobi bidii be laa chupa mil, ne stobi bidii be laa ti mil si. Cada tobi ucuaa bia' laa. Oraque biree be ze be. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ni ucuaa gaayu mil que la? bi'ni né ni dxiiña de bisaa ni chii mil. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Zaqueca ni ucuaa chupa mil que, laca bini ganar xhupa, bisaa ni tapa. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Peru ni ucuaa tobi que la? undaa ndaani yu ne raqué bicaachi bidxichi sti xpixuaana'. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Bindaa para beeda xpixuaana cabe que, beda guuya xi bini né cabe xpidxichi. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Para bidxiña ni ucuaa gaayu mil que, ne bedané xcaayu ne na rabi laabe: “Señor, gaayu mil bidiiu naa, peru bine nia ni dxiiña dede bisaa ni chii.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Para na xpixuaana be rabi laabe: “Galán, jneza bi'ni lu xhiiña'. Pa nga caadxi si bisaana nia lii ne bi'nu jneza la? yanna jma rusi stale zudiee lii. Biuu, guieche nia lii.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Oraque bidxiña ni ucuaa chupa mil que, na rabi laabe: “Señor, chupa mil bidiiu naa, ne bine nia ni dxiiña dede bisaa ni tapa.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Para rabi be laa: “Galán, jneza bi'ni lu xhiiña'. Pa nga caadxi si bisaana nia lii ne jneza bi'nu la? yanna jma rusi stale zudiee lii. Biuu, guieche nia lii.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Oraque bidxiña ni ucuaa ti mil que, ne na rabi laabe: “Señor, runebia'ya lii, ne nanna pabiá' naduxhu né lu xpinni lu', ne ribeeu guela neca cadi lii guluu lu biní, ne rutopa lu ra cadi lii bidxiiba lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nga runi bidxibe', ne bicaache xpidxichi lu ndaani yu.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Para rabi be laa: “Aque qué iquiiñe lu xa hombre, ne nachaaba lu'. Pa nannu ximodo naa, ribee guela neca cadi naa uluaa biní ne rutopa ra cadi naa bidxiiba la? ");
INSERT INTO zaiNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","xiñee qué niguu lu bidxichi stinne lu bancu, ne ora ñenda la? ma ñaca ni jma stale.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ne na be rabi be ca xpinni be: “Lagaxha laabe ni né be ca, ne lagudii ni ni napa chii mil que. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Purti cani napa, zacaa ca xcaadxi ti idale stica', peru cani qué gapa la? laga ziaaxha ca dede ni napa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ne hombre qué iquiiñe ri la? laundaa laa lu guelacahui. Raqué nga gu'na be dede go yaa be guidi ruaa be.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Dxi ibigueta Hombre Biseenda Dios la? zeeda casi rey, zedané irá ca ángel sti', ne zabí para guni mandar. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ne zadxiña binni de irá guidxi ra nuu be. Zabee chu be caadxi lade xcaadxi, casi ribee chu pastor chiba lade dendxu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ne zuzuhuaa be ca dendxu ladu derechu stibe ne ca chiba ladu biga'. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Oraque zabi be cani zuhuaa ladu derechu que: “Ma guluu Bixhoze ndaaya laatu, yanna latá' laicaa ra ma nexhe chaahui para laatu dede ante cha guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Purti bidii tu ni gudahua dxi candaana', ne bidii tu ni güee dxi cayate nisa, ne bichagalú tu naa dxi canazaya xquidxi binni. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Bigacu tu naa lari dxi nuaa xie lade', ne yeganna tu naa dxi huara'ya', ne uyé tu ra nuaa dxi yeguayuaa.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Oraque zaní' cani nacha'hui que: “Señor, padxí bidu'ya du lii candaanu', bidí' du ni gudó lo', ne cayati lu nisa bidí' du nisa güe' lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ne padxí bichagalú du lii dxi canazá lu xquidxi binni ne bigacu du lii lari dxi xie ladi lu ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","O padxí yeganna du lii huará lu' o yedu'ya du lii ra yeguyoo lo'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ne óraque zabi be laaca': “Ndi nga laani: ora bi'ni tu ni ti hermanu stinne neca huaxié' laa la? casi ñaca bi'ni tu ni naa.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ne dxi queca zabi be cani nuu ladu biga que: “Lairee de ra nuaa', ni dxiba dí ca'. Lachiguiaba lu gui ni qué ziuu dxi gyui', ni nexhe para binidxaba ne ca xpinni. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Purti qué nudii tu ni ñahua dxi candaana', ne qué nudii tu nisa ñee dxi cayate nisa. ");
INSERT INTO zaiNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ne qué nuchagalú tu naa dxi canazaya xquidxi binni, ne qué nugacu tu naa lari dxi nuaa xie lade', ne qué niganna tu naa dxi huara'ya' nin dxi yeguayuaa.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Oraque laca zaní' ca ngue: “Señor, padxí bidu'ya du lii candaanu' o canazá lu xquidxi binni, o xie ladi lu', o huará lu' o yeguyoo lo', ne qué ñacané du lii ya'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ne zabi be laaca': “Ndi nga laani: purti qué ñuni tu ni cani caquiiñe ni la? casi ñaca qué ñuni tu ni naa.” ");
INSERT INTO zaiNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ne cani gudxi be laa chi guiaba lu bele que la? qué ziuu dxi iree ca de raqué, peru cani nacha'hui que la? zapa ca enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Biluxe si uní' Jesús ca diidxa ca, na rabi ca discípulu sti': ");
INSERT INTO zaiNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Ma nanna tu xhupa si gubidxa riaadxa para saa pascua, ne lade ca dxi que zanaaze cabe Hombre Biseenda Dios para icá lu cruz. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ne zaqué guca ni, bidxiña ca xaíque sti ca sacerdote ne ca maistru de ley ne ca xaíque sti ca judíu ndaani patiu ralidxi sacerdote gola Caifás. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ne raqué uní' stiidxa ca inaaze ca Jesús sin ganna binni, ne guuti ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Peru na ca cadi gaca ni ndaani pe saa que, ti qué cui zisi binni. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ca dxi que uyé Jesús Betania, ralidxi Simón ni gupa lepra que. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Raqué nuu be bedané ti gunaa ti frascu dxá de aceite rindá' naxhi ni nabé risaca, ne bichá ni ique be ra zuba be ruaa mexa'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ora bi'ya ca discípulu ni bi'ni gunaa que, bidxiichi ca ne na ca': ―Xiñee gudxite si be aceite que. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Purti ñanda nidoo ni ne niree stale vueltu para ñaazi lu ca pobre. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Peru ma nanna Jesús xi caní' cabe, para na rabi laacabe: ―Lachuu dxí, cadi guchiiña tu gunaa ri' purti nabé sicarú ni bi'ni be naa ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ca pobre la? qué ziaadxa ca lade tu, peru naa zadxiña dxi guiaadxa lade tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ra bichá be aceite ri lade la? cayuni chaahui be naa para igaache'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ne gabe ca' laatu, ratiica güi cabe stiidxa Dios ndaani idubi naca guidxilayú ri', zuzeete cabe ni bi'ni be, ti cadi guiaanda be. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Oraque uyé Judas Iscariote, tobi de ca discípulu sti Jesús que, ra nuu ca xaíque sti ca sacerdote. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ne na rabi laaca': ―Pagala udii tu naa saca gulué laabe laatu. Ne óraque bidii ca laabe treinta moneda de plata. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ne dede dxi que nisi cuyubi be modo guluí' be Jesús laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Primé ca dxi bizulú saa ra ro cabe pan sin levadura, beeda ca discípulu sti Jesús ra nuu, ne na ca rabi ca laabe: ―Paraa racala'dxu guni chaahui du para gó xhi lu pascua ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Para na be rabi be laaca': ―Laché ndaani guidxi ra nuu tobi hombre ne lagabi laa: “Na maistru ma bidxiña dxi sti' ne racala'dxi utiidi pascua ri rali'dxu', laa ne ca discípulu sti'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ne óraque uyé ca discípulu que casi gudxi Jesús laaca', ne gudixhe chaahui ca endaró xhi para pascua que. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Casi bixhinni, gurí né be idubi doce discípulu stibe ruaa mexa que. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ne ora cayó xhi cabe na be rabi be laaca': ―Gabe ca' ndi laatu, tobi de laatu zutoo naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nabé triste biaana cabe óraque, ne bizulú cayabi cabe laabe: ―Naa la? Señor. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Para na be rabi be laaca': ―Ni naguu ná ndaani bladu ra naguaa naya ri' nga ni chi utoo naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Huandí maca cá lu gui'chi naquiiñe gati Hombre Biseenda Dios, peru ni chi guluí' laabe la? gapa gá si laa. Jma galán ñaca para laa pa qué ñuu dxi ñale. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ne óraque na Judas ni yeutoo laabe que, rabi laabe: ―Ñee naa la? Maistru. Para rabi be laa: ―Lii caníu' ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ra cayó xhi cabe que, ucuaa be pan guluu be ndaaya', ne gundaa be ni lú ca discípulu stibe ne rabi be laaca': ―Laicaa ne lagó. Ndi nga cuerpu stinne'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Oraque ucuaa be ti copa ne bidii si be diuxquixe Dios bidii be ni laaca', ne rabi be laaca': ―Lagué' ni, irá xixé tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Purti ndi nga rini stinne ni chi ixii para ixá stonda stale binni. Ne ra ixii ni la? zaguixhe Bixhoze ti modo cubi chu' né binni laa tobi si. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Gabe ca' laatu, ma qué zee rua' nisa uvas dede dxi ibigueta guee nia ni laatu sti tiru ra runi mandar Bixhoze'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Biluxe biinda si cabe ti cantu, biree cabe ze cabe lu dani Olivo. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Oraque na Jesús rabi laacabe: ―Irá tu zaxele tu de naa yanna gueela', purti maca cá ni lu Xqui'chi Dios: “Zunena'ya pastor sti ca dendxu' ne zareeche ndase ca'.” ");
INSERT INTO zaiNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Peru dxi guiasa de lade gue'tu la? ziaa Galilea ne raqué cueza laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Oraque na Pedru rabi laabe: ―Neca ixele irá cabe de lii, peru naa qué ziuu dxi ixele de lii. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Para rabi be laa: ―Gabe ca' lii, yanna gueela ca, ante gu'nda gallu, zaníu' chonna tiru qué runibiá' lu naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Para na Pedru rabi laabe: ―Neca gate nia lii, peru qué ziuu dxi inié qué runebia'ya lii. Ne ngue ca na irá discípulu que. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Oraque yené be laaca ti lugar lá Getsemaní, para na be rabi be laaca': ―Lacuí rarí laga chaa rarica', chi inié nia Dios Bixhoze'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ne uzá né be Pedru ne iropa xiiñi Zebedeu stindaa, ne óraque uyuu be triste ne uyuu yuuba ladxidó' be. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Para na be rabi be cani né be que: ―Nabé naná yuuba ni nuu ndaani ladxiduá' ri', yuuba para guuti. Laguiaana gá rarí ne cadi gasi tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ne óraque bixele huiini be caadxi de laaca', ne raqué bizuxibi be gudixhe ique be layú, ne uní' né be Bixhoze be ni nuu ibá', na be: ―Padre stinne', pa zanda la? ulee enda naná ri de naa, peru cadi aca ni rabe sínuque ni na lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ne bigueta be ra nuu ca discípulu stibe. Bedandá be laaca nisiaasi ca'. Para na be rabi be Pedru: ―Ñee qué zanda gataná né tu naa neca ti hora la? ");
INSERT INTO zaiNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Lagataná ne lainí' né Dios ti qué uquiinde binidxaba laatu. Neca ndaani ladxidó' to racala'dxi tu guni tu jneza peru cuerpu stitu nagueenda riguudxi. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bigueta uyé be yení' né be Dios rairopa tiru, na be: ―Padre stinne', pa qué zanda tidi enda naná ri luguia'ya sin qué aca ni la? bi'ni ni na lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ne óraque beeda be ra nuu ca discípulu stibe sti tiru. Ne laca bedandá be laaca nisiaasi ca' purti nabé nuu bacaanda lú ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Para bisaana be laaca yení' né be Dios raguionna tiru ne laca zaqueca uní' be. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Oraque ru bigueta be ra nuu ca discípulu stibe ne na be rabi be laaca': ―Lagasi yanna ne laiziila'dxi'. Ma bidxiña ora tidi Hombre Biseenda Dios lu ná cani qué runi jneza. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Laguiasa, ma chuu nu. Laguuya mápeca zeda dxiña ni chi uluí' naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Caní' ru be, mala zeeda Judas, tobi de lade doce discípulu stibe que. Zedané stale binni ni biseenda ca xaíque sti ca sacerdote ne ca xaíque sti ca judíu, ne naaze ca espada ne palu. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ne maca gudxi Judas laaca': ―Ni gu'ya tu gahua ti bixidu lucuá la? ngue nga laabe, ne zanda inaaze tu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ne casi yendá be ra nuu Jesús, bigapa diuxi be laa, ne na be rabi be laa: ―Maistru. Ne gudó be ti bixidu lucuá. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Para na Jesús rabi laabe: ―Xhamigua' xi zeda gunu'. Oraque bidxiña irá cabe guluu ná cabe Jesús para chiné cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Peru mala bisigaa ná tobi de cani nuu né Jesús raqué, guxha espada sti', bigá diaga ti xpinni sacerdote gola. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Oraque na Jesús rabi laabe: ―Guluu espada stiu' jlugar, purti irá ni cu' ná espada la? zati né espada. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ñee na tu qué ñanda ninié nia Bixhoze nagasi ne nuseenda stale mil ángel para ñacané naa la? ");
INSERT INTO zaiNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Peru pa ñune nga la? ximodo ñanda ñaca casi cá lu Xqui'chi Dios ra na naquiiñe gaca ni sicarí ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Oraque na Jesús rabi ca binni que: ―Casi rie cabe luguiá gubaana zeeda tu luguia'ya', né tu espada ne palu. Inqué ti dxi gurié ndaani yu'du ro', bisiide' ne qué ninaaze tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Peru cayaca irá ndi ti iree ni casi cá ni lu ca gui'chi ni bicaa ca profeta. Ne óraque bixooñe irá ca discípulu bisaana ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yené ca binni que laabe ra nuu sacerdote gola Caifás ne ma nuu ca maistru de ley ne ca xaíque sti guidxi raqué. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Zinanda Pedru laabe zitu zitu dede biuu ndaani patiu sti sacerdote gola que, ne raqué gurí né ca gendarme para gu'ya xi gaca be. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ne óraque bizulú biyubi ca xaíque sti ca sacerdote ne irá ni naca justicia sti ca judíu tuuxa iní' paraa pe bichee Jesús, neca cadi dxandí ni, ti chu' xi pur gati be. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Peru neca stale tu ulee falsu luguiá be, qué nidxela ca paraa bichee be. Ultimu beeda xhupa zeda ndee falsu luguiá be. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Na ca rabi ca ca binni que: ―Bina diaga du uní' be ñanda nuxhá be yu'du ro' sti Dios ne lu chonna gubidxa nucuí be ni sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Oraque bizuhuaa sacerdote gola, na rabi laabe: ―Xi na lu de ni cugaani cabe luguiá lu ri ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Peru qué niní' be gasti'. Para na sacerdote gola que rabi laabe: ―Pur Dios ni nabani nga cayabe lii ga'bu laadu pa lii nga Cristu Xiiñi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Para rabi be laa: ―Naa, casi nou' ca. Ne gabe ca' laatu dede yanna zuuya tu Hombre Biseenda Dios zuba cue' Dios ni nandxó', ne zuuya tu zeda yete be de ibá' lade za. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Oraque ucheza sacerdote gola que xhaba ne na: ―Yanna huaxa ma uní' be, cayuni be laabe Xiiñi Dios. Ma cadi naquiiñe uyubi nu tu iní' paraa bichee be purti ma bina diaga tu biree ni de ruaa be, cayuni be laabe Xiiñi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yanna ya', xi na tu. Para na cabe: ―Gati be xa. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ne óraque bichá xhinni cabe lú be ne gudiñe cabe laabe ne udapa cabe ruaa be. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ne na cabe rabi cabe laabe: ―Pa nou' lii nga Cristu la? gudxi laadu tu cagapa lii ti idu'ya du pa nannu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Zuba Pedru ndaani patiu que ora bidxiña ti criada laa, na rabi laa: ―Lii laca xpinni Jesús de Galilea lii nja'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Peru qué niná Pedru niní' pa xpinni be laa sínuque na rabi badu dxaapa que nezalú irá binni rí raqué: ―Qué ganna xii nga caní' lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ma ziree Pedru ra puerta', biiya sti badu dxaapa laa, para na rabi ca binni que: ―Ndi laca xpinni Jesús de Nazaret laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bigueta uní' Pedru sti tiru dede bini jurar: ―Qué runebia'ya dia' hombre ca. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Qué nindaa de ngue bidxiña caadxi de cani zuhuaa raqué, na rabi laabe: ―Dxandí de laacabe lii, purti de modo riníu' ca rihuinni. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Oraque bizulú be caguu dí be ne cayuni jurar be: ―Gunidé Dios naa pa cusiguiee', ma gudxe laatu qué racabia'ya laabe. Ne casi pe biluxe uní' be, biinda gallu. ");
INSERT INTO zaiNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Oraque bietenala'dxi be ca diidxa ni gudxi Jesús laabe que, ante gu'nda gallu zaní' be chonna tiru qué runibiá' be laa. Para biree be de raqué yeguuna be, dede guyuu yuuba ladxidó' be. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Casi birá gueela', uní' stiidxa ca xaíque sti ca sacerdote ne ca xaíque sti guidxi que guuti ca Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ne bindiibi ca laabe yené ca laabe ra nuu gobernador Poncio Pilatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Biiya si Judas ni yeutoo laabe que ma chi gati be la? beeda malaya laa, para yeudxii treinta moneda que ca xaíque sti ca sacerdote ne ca xaíque sti guidxi. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ne na rabi laaca': ―Naa bichee purti bituaa tobi ni nayá ladxidó'. Para na cabe rabi cabe laa: ―Xi runi importar laadu ya'. Lii gu'yu xi gu'nu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ne óraque bizu'nda be ni ndaani yu'du ro' que, ne biree be yenduu be doo yanni be. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Gundisa ca xaíque sti ca sacerdote ca moneda que, peru na ca': ―Qué zanda cu' nu moneda ri lade ofrenda sti yu'du', purti bixuí' né ni rini sti ti hombre. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ne óraque uní' stiidxa cabe xi guni né cabe bidxichi que. Para uzí' cabe ti layú lu ni ruzá' guisu ne na cabe iquiiñe ni para igaachi judíu ni gueeda de sti ladu. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nga runi gulee lá cabe layú que Layú de Rini ne nga lá ni dede yanna. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ne zacá guca ni modo uní' Dios de ruaa profeta Jeremías dxi na: ");
INSERT INTO zaiNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ca xiiñi Israel gudixhe idoo be treinta moneda de plata, ne dxi bigueta moneda que lu ná cabe, ucuaa cabe ni, uzí' né cabe ni ti layú lu ni ruzá' guisu. Zacá nga gudxi Dios naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ne ora zuhuaa Jesús nezalú gobernador, na gobernador que rabi laabe: ―Ñee lii nga rey sti ca judíu la? Para na be: ―Casi na lu ca, nga laani. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Peru óraque neca gudixhe irá ca xaíque sti ca sacerdote ne ca xaíque sti guidxi xqueja be, ma qué niní' ru be gasti'. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Para na Pilatu, rabi laabe: ―Cadi cayuna diaga lu irá ni cugaani cabe luguiá lu ri la? ");
INSERT INTO zaiNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Peru qué nicabi be laa nin ti diidxa'. Ne nabé bidxagayaa gobernador que. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Chiqué, cada iza ra cayaca saa, rundaa gobernador que ti presu para ca binni que, tutiisi gapa ca gana. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ne iza que nuu ti presu ni za'bi stiidxa irá ladu, lá Barrabás. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ngue runi, ora bidxiña cabe, na Pilatu rabi laacabe: ―Tu racala'dxi tu undaa para laatu ya', Barrabás la? o Jesús ni rabi cabe Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nanna ca Pilatu bedané cabe Jesús ra nuu purti si qué na cabe chi nanda binni laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma zuba Pilatu ra juzgadu sti', bisenda tidxi xheela laa, na xheela rabi laa: ―Cadi gu'nu hombre cha'hui ca gasti', purti pur laabe nabé bine sufrir lu bacaanda nuchi'. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Peru ucuá ca xaíque sti ca sacerdote ne ca xaíque sti guidxi tema lú ca binni que para inaba ca ilaa Barrabás ne gati Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Oraque na gobernador que rabi laacabe sti tiru: ―Tu pe de laacabe racala'dxi tu undaa para laatu pue. Para na cabe: ―Barrabás. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Oraque na Pilatu rabi laacabe: ―Yanna xi gune nia Jesús ni rabi cabe Cristu ri ya'. Para bicabi irá cabe: ―¡Icá be lu cruz! ");
INSERT INTO zaiNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Para na gobernador que: ―Xiñee, xi huayuni be. Peru laacabe jma rusi bicaa cabe ridxi, na cabe: ―¡Icá be lu cruz! ");
INSERT INTO zaiNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Biiya si Pilatu pur gana si caní' ne mayaca uzulú ti bulla la? gucuaa nisa ne gudiibi ná nezalú ca binni que, para na rabi laacabe: ―Cadi luguia'ya dia' nuu donda purti chi ixii rini sti hombre cha'hui ri'. Laatu laguuya xi iree xa ni laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Para na ca binni que: ―Zaa guiaana donda ca luguiá du ne luguiá ca xiiñi du. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Oraque bindaa be Barrabás para laaca', ne bini mandar be quiñe cabe Jesús para bidii be laa icá lu cruz. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Oraque gucuaa ca soldadu sti gobernador que Jesús, yenduu ca laabe ndaani palaciu para bidxiña idubi batallón ra nuu be. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Gulee ca xhaba be ne bicua'qui ca laabe ti lari xhiñá'. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ne bizá' ca ti la'pa de guichi uluu ca ique be ne bigaasa ca tindaa gueere ná be ladu derechu. Oraque bizuxibi ca xañee be ne bini burla ca laabe, na ca': ―¡Viva rey sti ca judíu! ");
INSERT INTO zaiNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ne bichá xhinni ca lú be ne guxha ca gueere que ná be, bichenda ca ni ique be. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Biluxe si bini burla ca laabe zaqué la? gulee ca lari que ne bigacu ca laabe xhaba be, ne ziné ca laabe para icá be lu cruz. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ra ze cabe que bidxaaga cabe ti hombre de Cirene lá Simón ne bicaa cabe laa gua cruz sti Jesús ");
INSERT INTO zaiNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","dede yendá cabe ti lugar lá Gólgota. Ni riní' diidxa Gólgota ca la? Lugar sti Calavera. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Raqué bidii cabe laabe vinagre nucha nisa xculá'. Peru ora bi'ya be xi naca ni la? qué niná be ñe' be ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bicaa si cabe laabe lu cruz guluu cabe xhaba be lu rifa, ne cada tobi ucuaa ni gulee. Guca ni zaqué ti iree ni modo pe uní' Dios de ruaa ti profeta de laabe, ra na: “Gudiizi cabe xhaba', ne uluu cabe laa lu rifa.” ");
INSERT INTO zaiNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Para gurí cabe cayapa cabe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ne bicaa cabe ca diidxa ri xaíque be: “Ndi nga Jesús Rey sti ca judíu.” Purti na cabe pur laani cá be lu cruz. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Oraque bicaa né cabe laabe chupa gubaana', tobi ladu derechu ne stobi ladu biga'. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ne cayuni burla ca binni zidi'di raqué laabe, cuniibi ique ca lú be, ");
INSERT INTO zaiNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","na ca': ―Lii nou' zuxhá lu yu'du ro' ne zucuí lu ni lu chonna gubidxa. Yanna bilá laca lii. Pa dxandí Xiiñi Dios lii la? biete de lu cruz ca. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ne zaqueca na ca xaíque sti ca sacerdote ne ca maistru de ley ne ca fariseu ne ca xaíque sti guidxi, cuchá ca ni lú be: ");
INSERT INTO zaiNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Stobi bilá be peru laca laabe qué zanda ulá be. Na be rey sti Israel laabe, ne pa dxandí ni la? guiete be de lu cruz ca yanna, ne zuni cre nu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ucuá lú be Dios, yanna cueza be ulá Dios laabe, pa nadxii laabe, purti na be Xiiñi Dios laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ne zaqueca cayuni burla ca gubaana ni cá né be que laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Bia' galaa dxi bicahui xaibá' dede bia' las tres. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mayaca ganda las tres bicaa Jesús ridxi: ―¡Elí, Elí, lama sabactani! Didxazá la? niní' be: Dios stinne', Dios stinne', xiñee ma bisaanu naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ne ora bina diaga cani zuhuaa raqué ni uní' be que la? na ca': ―Cucaa ridxi be Elías. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Oraqueca biree tobi de laaca yecaa ti esponja bigadxe de vinagre ne bidxiiba ni ique ti gueere', ne bigué' ni laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Peru na xcaadxi que rabi laa: ―Zaa nuu be, idu'ya nu pa zeda ulá Elías laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Bigueta bicaa be sti ridxi ne raqué guti be. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ne mala guca cortina sti yu'du ro' chupa ndaa de punta punta, ne guca xu, gulaa stale guie. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ne bixale caadxi ba', biasa stale de ca xpinni Dios ni ma guti. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ne dxi ma biasa Jesús de lade gue'tu que la? biree cabe de ndaani ca ba' que, uyé cabe ndaani guidxi Jerusalén ne biiya stale binni laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nabé bidxagayaa capitán ni cayapa Jesús que, laa ne ca soldadu sti', purti bini sentir ca guca xu ne biiya ca irá cosa ni guca que, para na: ―Dxandí Xiiñi Dios ndi'. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Zitu huiini de raqué zuhuaa caadxi gunaa ni beda nanda Jesús de Galilea, beeda ca para gacané ca laabe. Zuhuaa ca cayuuya ca ni cayaca que. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lade cabe nuu María Magdalena ne María jñaa Jacobo ne José, ne jñaa ca xiiñi Zebedeu. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Huaxhinni que beeda ti hombre ricu de Arimatea lá José, tobi de cani uzá né Jesús chiqué. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ne uyé be ra nuu Pilatu, yenaba be cuerpu sti Jesús laa, para bisenda tidxi ca xpinni gudii cuerpu que laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ne ucuaa si be cuerpu que, bichenda be laa ti lari gueela nayá, ");
INSERT INTO zaiNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ne gudixhe be laa ndaani ti ba' cubi ni maca gundaa be para laabe lu ti guie, ne biseegu be sti guie ngola ra puerta ba' que, para biree be ze be. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ne zuba María Magdalena ne sti María gaxha ra puerta ba' que. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Udi'di si viernes que, bidxiña ca xaíque sti ca sacerdote ne ca fariseu ra nuu Pilatu, ");
INSERT INTO zaiNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","na ca rabi ca laabe: ―Señor, cayetenala'dxi du ni uní' hombre rusiguii que dxi nabani, na raguionna gubidxa ziasa de lade gue'tu'. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nga runi canaba du lii guseendu tu chi gapa ra ba' que dede ganda chonna gubidxa quenquita gueeda ca discípulu stibe cuana ca xcuerpu be ne gabi ca binni biasa be de lade gue'tu'. Ne zacá jma rusi zusiguii cabe, que dxi bizulú ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Para na Pilatu rabi laacabe: ―Racá laicaa caadxi soldadu, lachiné, ne lauseegu chaahui ruaa ba' que, bia' ganda ti'. ");
INSERT INTO zaiNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Oraque biree cabe uyé cabe ne biseegu dxiichi cabe ruaa ba' que ne bisaana cabe ca soldadu que gapa ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Udi'di si dxi enda riziila'dxi que, ma para irá gueela domingu, dxi ruzulú semana, beeda María de Magdala ne sti María que, beda guuya ca ra ba' que. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ne ma guca ti xu ro' raqué, purti biete ti ángel sti Dios de ibá', beda ndee guie que, ne gurí lú ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Rihuinni ángel que casi biaani sti rayu, ne naquichi bé xhaba be casi nieve. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ne de tantu bidxibi ca soldadu que laabe la? guca diti ca ne biaana ca casi ni ma guti. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Peru na ángel que rabi ca gunaa que: ―Cadi idxibi tu. Nanna cuyubi tu Jesús ni ucuá lu cruz. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Qué guinni di be rarí purti ma bibani be casi uní' be. Latá' gu'ya tu lugar ra guta be, ");
INSERT INTO zaiNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ti che tu nagueenda chi tidxi tu ca discípulu stibe ma biasa be de lade gue'tu', ne ma chi sa niru be lú ca', che be Galilea. Ne zuuya ca laabe raqué. Nga nga ni napa gabe laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Oraque biree guxooñe ca gunaa que de ra ba' que, zidxibi ca' ne ziyeche ca', zitidxi ca ca discípulu stibe ni gudxi ángel que laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ze ru cabe neza, mala biree Jesús lú cabe, bigapa diuxi laacabe. Para bidxiña cabe laa gudiidxi cabe ñee, bisisaca cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Oraque na Jesús rabi laacabe: ―Cadi idxibi tu. Laché, lachitidxi ca biche che ca Galilea ne raqué gu'ya ca naa. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Laga ze cabe biree caadxi de cani cayapa ra ba' que, uyé ndaani guidxi yetidxi ca xaíque sti ca sacerdote xi irá guca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Oraque bisenda caa ca sacerdote que irá ca xaíque sti guidxi, guyuu ca tobi si ne bidii ca stale bidxichi ca soldadu que. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ne gudxi ca laacabe: ―Pa inaba diidxa cabe laatu la? lagabi nisiaasi tu beeda ca discípulu stibe lu gueela' gula'na ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ne pa ganna gobernador ni la? laadu guiene né du laa, ti qué gudxiiba donda ique tu. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Para gucuaa ca soldadu que bidxichi que, ne bi'ni ca modo gudxi cabe laaca'. Ne ni uní' cabe que nga bireeche lade ca judíu, ne runi cre ca ni dede yanna. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Uyé idubi once discípulu sti Jesús Galilea, lu dani ni gudxi Jesús laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Casi bi'ya ca laabe, bisisaca ca laabe, peru nuu caadxi de laaca qué ñuni cre gá. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Para bidxiña be ra nuu ca ne na be rabi be laaca': ―Irá xixé ni nuu ibá' ne ni nuu guidxilayú ma nexhe ladxi naya'. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nga runi laché irá xixé guidxi, lachiusiidi irá xixé binni sa nanda naa, ne lacuu nisa laaca casi ñaca Dios Padre ne Xiiñi ne Espíritu Santu ñuni ni. ");
INSERT INTO zaiNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Lausiidi laaca guni ca irá ni ma gudxe laatu, ne ganna ca tu qué ziuu dxi ixele de laatu dede dxi iluxe guidxilayú. Amén.");
INSERT INTO zaiNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Sicarí nga bizulú evangeliu sti Jesucristu Xiiñi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Chiqué bicaa profeta Isaías ni gudxi Dios laa ucaa, ne ndi nga laani: Zuseenda ti xpinne sa niru lú lu' para guni chaahui neza tidi lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Zuna diaga cabe cucaa tuuxa ridxi ndaani gui'xhi', cayabi binni: “Lausiá neza tidi Señor; lauxhele ladxidó' to, casi ñaca cuxhele tu ti neza para laabe.” ");
INSERT INTO zaiNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Zacá nga laani, beeda Juan Bautista, beda nduu nisa binni ndaani gui'xhi', ne gudxi laaca naquiiñe inaba ca perdón Dios ti aca perdonar ca', ne chu' nisa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ne biree irá binni Judea ne binni guidxi Jerusalén, yeucaa diaga laabe, ne gulee ruaa ca diidxa de irá ni huachee ca', para uluu nisa be laaca ndaani guiigu Jordán. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Xhaba be la? de guicha ladi camellu ne xi' ti cinturón de guidi ndaani be, ne ro be usú ne dxiña yaga. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Rusiidi be binni ne rabi be laaca': ―Nanda tobi atrá de naa jma risaca que naa. Naa la? dede nin para ñata udaa nibee xquela guidi be qué risaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Naa caguaa ni'sa sia' laatu, peru laabe zudii be Espíritu Santu laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ca dxi que pe' biree Jesús Nazaret, ti guidxi sti Galilea, ne uluu nisa Juan laabe ndaani guiigu Jordán. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Casi biree be ndaani nisa biiya be bixele ibá' ne zeda yete Espíritu Santu luguiá be casi ti paloma, ");
INSERT INTO zaiNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ne ucuá ti ridxi de ibá': ―Lii nga Xiiñe ni nadxiee ne ni rusieche naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Oraque yené Espíritu Santu laabe ndaani gui'xhi', ");
INSERT INTO zaiNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ne biaana be raqué cuarenta dia lade mani duxhu'. Laga nuu be raqué ucala'dxi binidxaba nusaba laabe. Ne udi'di si irá nga beeda ca ángel, beda saana ca ni gudó be raqué. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bieguyoo si Juan la? uyé be Galilea yegüí né be ca binni que stiidxa Dios, ");
INSERT INTO zaiNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","na be rabi be laaca': ―Ma bidxiña dxi gudixhe Dios guni mandar, ne ma chi aca ni. Yanna la? lainaba perdón laabe ne laguni cre stiidxa be. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ra zidi'di be uriá ti nisa ro' lá Galilea biiya be Simón ne Andrés bi'chi', cusaba ca ti tarraya ro' ndaani nisa, canaaze ca benda purti nga xhiiña ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Para rabi be laaca': ―Lata nanda naa ne laca zune laatu guuze', peru para chi yubi tu binni gueda né tu ra nuaa'. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Oraqueca bisaana ca tarraya stica' ne zinanda ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Guzá ru be stindaa ne biiya be iropa xiiñi Zebedeu, Jacobo ne Juan, nuu ca ndaani ti canuá cayuni chaahui ca tarraya stica'. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Para gudxi be laaca chi nanda ca laabe. Ne óraque bisaana ca bixhoze ca ndaani canuá que ne cani runi né laa dxiiña', ne biree ca zinanda ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yendá cabe ndaani guidxi Capernaum ne yeusiidi Jesús ndaani yu'du dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nabé bidxagayaa ca binni que ni caní' be purti cusiidi be casi tobi ni zanda guni mandar ne cadi casi ca maistru de ley. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ndaani yu'du que nuu ti hombre riguite binidxaba ique. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ne bicaa ridxi: ―Xi napa neu laadu, Jesús de Nazaret. Ñee zeda unitilú lu laadu la? Runebia'ya lii. Lii nga hombre cha'hui sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Oraque gudinde né Jesús binidxaba que, na rabi laa: ―Bigani ne biree de hombre ca. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ne ora ziree binidxaba que de hombre que, bidii ataque laa, ne bicaa binidxaba que ti ridxi reciu, ne biree ze'. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bidxagayaa ca binni nuu raqué ne gunaba diidxa saa ca', na ca': ―Xii ndi pue. Xi nacubi ri canausiidi hombre ri'. Nandxó' be dede runi mandar be binidxaba ne ruzuuba ca stiidxa be. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ne qué nindaa bireeche stiidxa Jesús idubi Galilea. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ora biree cabe de ndaani yu'du que, yené Jesús Jacobo ne Juan ralidxi Simón ne Andrés. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ne ora yendá ca raqué gudxi cabe Jesús huará suegra Simón nexhe né xindxá'. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Oraque bidxiña Jesús ra nuu be ne unaaze ná be, undisa laabe ne oraqueca biree xindxá' que, ne bidii be ni gudó ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Huadxí que casi biaazi gubidxa, bedané cabe stale binni huará ne ni riguite binidxaba ique ra nuu Jesús, ");
INSERT INTO zaiNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","dede bidxiña idubi naca guidxi que ra puerta yoo que. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ne bisianda be stale binni ni napa adxé adxé enda huará, ne ulee be stale binidxaba de laaca'. Peru qué nudii be lugar niní' ca binidxaba que pa runibiá' ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nuxcanda ru biasa be biree be de ndaani guidxi que, uyé be ndaani gui'xhi', ne raqué uní' né be Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Para uyé Pedru ne ca xcompañeru yeyubi ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ne ora bidxela ca laabe, na ca rabi ca laabe: ―Irá binni canayubi lii. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Peru óraque, na be rabi be laaca': ―Chuu ca xcaadxi guidxi huiini ni nuu gaxha ca, para güe stiidxa Dios, purti para nga nga zenda'. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ne uzá be idubi naca Galilea canayuí' be stiidxa Dios ndaani ca yu'du que ne canabee be binidxaba de binni. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ti dxi bidxiña ti hombre huará napa lepra ra nuu be, bizuxibi xañee be ne rabi laabe: ―Pa na lu la? zanda usianda lu naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Oraque biá be laa, udixhe ná be luguiá' ne rabi be laa: ―Zusianda lii ne zia ladi lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ne casi biluxe uní' be, oraqueca binitilú ca gui'dxu que ladi ne bianda. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Para na be rabi be laa: ―Uyé yanna. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Peru biiya gá qué chi tidxi lu ni iruti'. Uyé ra nuu sacerdote, ne bidii ti ofrenda casi bicaa Moisés guni binni ora ma bianda, para ganna binni ma bianda lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Para biree ze', ne bizulú byui' de irá ni uca que. Ngue runi ma qué ñanda ñuu Jesús ndaani guidxi, sínuque biaana ndaani gui'xhi'. Peru uyé binni de irá ladu ra nuu. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gudi'di si xhupa xhonna gubidxa, bigueta biuu Jesús ndaani guidxi Capernaum sti tiru. Ne ora gunna cabe ma nuu be yoo la? ");
INSERT INTO zaiNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","oraqueca bidopa stale binni ra nuu be que, dede bidxii ra puerta yoo que, ne bizulú byui' né be laaca stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Oraque beeda tapa hombre, nua ca ti hombre nexhe lu ti luuna, ma guti galaa. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Peru qué ñanda ñuu né cabe laabe ra nuu Jesús pur irá binni que. Para gudxi'ba cabe ique yoo ne ulee cabe caadxi teja ique yoo que, neza ra nuu Jesús, ne raqué undete cabe luuna ra nexhe hombre que. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ora bi'ya Jesús pabiá' napa cabe fe laa la? na rabi binni huará que: ―Ma bine perdonar xpecadu lu, xiiñe'. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Zuba caadxi maistru de ley raqué, ne caní' ique ca': ");
INSERT INTO zaiNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","―Xiñee caní' hombre ri sicarí pue. Cayuni be laabe Dios, purti iruti ru zanda guni perdonar pecadu jma que tobi lucha Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Peru maca nanna Jesús xi caní' ique cabe para na rabi laacabe: ―Xiñee caní' ique tu zacá. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Xii nga jma qué igana gabe laabe, ma bine perdonar xpecadu be la? o gabe laabe guiasa be, indisa be jluuna be ne sa be. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Peru para ganna tu naa nga Hombre Biseenda Dios ne zanda gune perdonar pecadu ndaani guidxilayú la? laguuya ni chi gune ri'. Ne óraque rabi be ni huará que: ");
INSERT INTO zaiNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Biasa, undisa jluuna lu', ma zanda chibí' lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Oraque biasa hombre huará que, undisa jluuna', ne biree de raqué nezalú irá binni que. Nabé bidxagayaa ca binni que ne bisisaca ca Dios ne na ca': ―Qué huayuu dxi idu'ya du xiixa sicarí'. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Bigueta uyé Jesús uriá nisa ro' que sti tiru ne uyé irá binni ra nuu be para bisiidi be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","De raqué biree be ze be, ne biiya be zuba Leví xiiñi Alfeu ruaa mexa ra ritixe binni impuestu, para rabi be laa: ―Dananda naa. Oraqueca biasa zinanda laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ne bini invitar Leví laabe chi to né be laa ralidxi ne laca uyé stale de cani ruquixe impuestu ne xcaadxi ni qué rulabi ley. Gurí né ca laabe ne ca discípulu stibe ruaa mexa', purti nabé stale de laaca nanda ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Peru ora bi'ya ca fariseu ne cani naca maistru de ley, cayó né be ca binni que tobi si la? na ca rabi ca ca discípulu stibe: ―Xiñee zuba né jmaistru tu ca malu ni ruquixe impuestu ne cani qué rulabi ley. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ne bina diaga Jesús ni uní' cabe que para na rabi laacabe: ―Cadi caquiiñe cani nazaaca doctor sínuque cani huará. Cadi zeda yube cani nacha'hui, sínuque cani cuchee. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ti dxi biaana ca discípulu sti Juan Bautista ne sti ca fariseu sin go, casi runi ca stale tiru. Ne dxi que uyé caadxi binni ra nuu Jesús, ne na ca rabi ca laabe: ―Xiñee ca discípulu sti Juan ne sti ca fariseu riaana ca sin go ca' peru ca discípulu stiu' co'. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Oraque na be rabi be laaca': ―Lácaxa ziaana cani nuu ra ti enda xheela sin go laga nuu novio lade ca'. Laga nuu né novio que laacabe la? qué zanda guiaana cabe sin go cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Peru ora ma biaaxha cabe novio que la? óraque huaxa ziaana cabe sin go cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Iruti rucaa remiendu tindaa lari cubi lu ti lari yooxho'. Purti pa ñuni cabe zacá la? casi ña'ri ni nidopa lari cubi que ne jma rusi xirooba nireza ni óraque. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ne zaqueca iruti rigaa vinu cubi ndaani ti guidi yooxho'. Purti pa ñuni cabe ni la? nicheza vinu cubi que guidi yooxho que. Ne óraque ninitilú vinu que ne laca ninitilú guidi que. Nga runi naquiiñe cá' cabe vinu cubi ndaani ti guidi cubi. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ti dxi enda riziila'dxi zididi né Jesús ca discípulu sti ndaani ti ñaa. Ne óraque bizulú ca discípulu que undadi ca zee ra zidi'di ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Para na caadxi fariseu rabi laabe: ―Xiñee cayuni ca discípulu stiu' ni cadi jneza guni binni dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Peru rabi be laaca': ―Ñee qué huayuunda tu xi bi'ni David dxi gasti ni go né ca xpinni, ne ma candaana ca la? ");
INSERT INTO zaiNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Biuu be ndaani yu'du sti Dios dxi naca Abiatar sacerdote gola, ne ucuaa be ca pan ni ma uyuu ndaaya'. Gudó be ne bidii be cani canazá né be que, gudó ca' neca na ley ca sacerdote si zanda go cani, peru laacabe gudó cabe ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ne laca na Jesús rabi laaca': ―Uca dxi enda riziila'dxi para binni, cadi binni uca para laani. ");
INSERT INTO zaiNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Naa nga Hombre Biseenda Dios ne zanda gabe binni xii nga jneza guni dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ti dxi biuu Jesús ndaani ti yu'du ne raqué nuu ti hombre nabidxi ti chu ná'. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Cundaachi ca binni ni nuu raqué pa zusianda be ná hombre que dxi enda riziila'dxi, ti gapa ca xi pur cu' ca xqueja be. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Oraque rabi be hombre ni nabidxi ti chu ná que. ―Biasa bizuhuaa galahui ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ne rabi be cani nuu raqué: ―Xii nga nexhe aca dxi enda riziila'dxi', gacané nu binni la? o guniná nu laa; ulá nu xpida binni la? o guuti nu laa. Peru iruti nicabi. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Oraque biiya tuxhu be laaca ne triste biaana be purti naguidxi ladxidó' ca'. Ne rabi be hombre que: ―Bisigaa nou'. Para bisigaa ná hombre que ne bianda. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Oraqueca biree ca fariseu ne uní' né ca ca xpinni Herodes para uyubi ca ximodo guuti ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Peru óraque ucuaa be ca discípulu stibe yené be laaca uriá nisa que, ne yenanda stale binni laabe, binni Galilea, ne binni Judea, ");
INSERT INTO zaiNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ne binni de Jerusalén ne de Idumea ne de sti ladu guiigu Jordán, ne binni de Tiro ne de Sidón. Ma bina diaga ca irá ni bi'ni be, nga runi uyé ca ra nuu be. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ne gudxi be ca discípulu stibe guni chaahui ca ti canuá para laabe ti cadi uquiichi ca binni que laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Purti nabé stale binni huará ma bisianda be ne rí ru jma ni ca'ru guianda dede cayaba ca luguiá be para ganda cana ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ne casi gu'ya ca binidxaba ni riguite ique binni laabe la? ruzuxibi ca xa ñee be ne rucaa ca ridxi: ―Lii nga Xiiñi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Peru udinde né be laaca cadi uzeete ca tu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Lade ca dxi que uyé Jesús lu ti dani, ne raqué guridxi cani racala'dxi che ra nuu. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ne ulí doce para sá né laa ne para chi güi stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ne bidii poder laaca para usianda ca cani huará ne cuee ca binidxaba ni riguite ique binni. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ndi nga lá doce ni ulí be que: Simón, ni na be iree lá Pedru; ");
INSERT INTO zaiNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo ne Juan xiiñi Zebedeu, iropa bi'chi ca'. Ulee lá be laaca Boanerges. Pa niní' be ni didxazá la? ñabi be laaca Xiiñi Rayu. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ne laca lade cabe zeeda Andrés, Felipe, Bartolomé, Mateu, Tomás, Jacobo xiiñi Alfeu, Tadeu, Simón ni uyuu lade ca cananista, ");
INSERT INTO zaiNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ne Judas Iscariote ni bitoo laabe que. Biete si cabe de raqué biuu cabe ndaani ti yoo. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ne bigueta gurí zisi binni laacabe sti tiru, de qué ñanda ño cabe gueta. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ora gunna xfamilia be ni la? beeda ca para niné ca laabe purti na ca ma cayaca ique be. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ne na ca maistru de ley, cani beeda de Jerusalén: ―Nuu né hombre ri Beelzebú, xaíque sti ca binidxaba', ne laa racané laabe para cuee be ca binidxaba ni riguite ique binni. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Oraque guridxi Jesús laacabe ne gudixhe ti ejemplu, na: ―Ximodo zanda cuee binidxaba laca laa ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Pa tinde saa ca binni de ti guidxi la? nagueenda zanitilú guidxi que. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ne pa tinde saa ti familia la? laca nagueenda zanitilú familia que. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Zacá nga laani, pa cucaa lú saa ca xpinni binidxaba la? laca nagueenda zanitilú. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Iruti zanda chi ndana ralidxi ti hombre ni nadipa pa qué undiibi laabe primeru. Peru pa undiibi laabe la? óraque huaxa ma zanda cuana ni napa be. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Gabe ca' laatu, zuni perdonar Dios binni de irá enda ruchee ne irá enda riguu di, ");
INSERT INTO zaiNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","peru pa chu' tu usaca Espíritu Santu binidxaba la? ngue qué ziuu dxi guni perdonar Dios laa, sínuque ziaana donda luguiá'. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Gudxi be laaca zacá purti na ca nuu né be binidxaba'. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ratu si que beeda jñaa be ne ca bi'chi be, ne biaana ca fuera peru bisenda tidxi ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Para na cani zuba né laabe raqué: ―Racá nuu jñoou ne ca bi'chi lu', zeda yubi ca lii. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Peru óraque rabi be laaca': ―Tuu nga jñaa ne tuu nga ca biche'. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ne óraque biiya dxí be cani zuba né laabe raqué ne na be: ―Ca ndi nga jñaa ne biche'. ");
INSERT INTO zaiNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Purti irá tu guni ni na Dios la? ca ngue nga biche ne bizana ne jñaa'. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Bigueta bizulú Jesús bisiidi uriá nisa que sti tiru, ne bidopa stale binni laabe. Biiya si be nabé stale binni la? biuu be ndaani canuá ni nuu ndaani nisa que, gurí be. Ca binni que la? biaana ca lu yuxi, ");
INSERT INTO zaiNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ne byuí' né be laaca stale cosa peru puru ne ejemplu. Ra cusiidi be laaca que, na be: ");
INSERT INTO zaiNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Laucaa diaga ndi': Ti hombre biree zinduu biní. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ra caguu be biní que biaba caadxi ni uriá neza ne beeda mani huiini gudó cani. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Xcaadxi de ca xuba que biaba lade guie ne undani cani nagueenda purti luguiá si napa ni caadxi yu. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Peru casi biree gubidxa bizaaqui cani ne bibidxi cani purti qué gapa cani xcu cani guete'. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Xcaadxi de laacani biaba lade guichi ne laca undani ca', peru jma bisoo guichi que para laacani ne biiti guichi que cani ne qué nudii cani gasti'. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nuu xcaadxi de laacani biaba lu layú ra nayá, ne ca ngue huaxa gundani ne bisoo. Nuu layú ra bidii treinta carreta niza ne nuu ra bidii sesenta ne nuu ra bidii dede ti gayuaa. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Oraque rabi be laaca': ―Irá ni racala'dxi guiene la? ucaa diaga. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Biree si irá binni que biaana Jesús stubi. Oraque bidxiña cani nuu gaxha de laabe ne doce discípulu stibe que, gunaba diidxa ca laabe xi riní' ejemplu que. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Para rabi be laaca': ―Laatu la? cudii Dios lugar guiene tu modo runi mandar, dede ni naga'chi', peru cani cadi xpinni be la? puru ejemplu si riguixhe be lú ca', ");
INSERT INTO zaiNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ti cadi gu'ya ca neca cayuuya dxí ca', ne cadi guiene ca neca cayuna diaga ca'. Pacaa nuyubi ca naa ne ñaca perdonar ca xpecadu ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ne laca rabi be laaca': ―Pa qué ñene tu ejemplu ri la? ximodo ga ganda guiene tu pa udiee laatu xcaadxi ejemplu ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ni guluu biní que la? ngue nga zeda gaca casi ni rui' stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ne xuba ni bisaba be que nga zeda gaca casi binni ni runa diaga stiidxa Dios. Nuu de laaca zeda gaca casi xuba ni biaba uriá neza que, purti nécati guna diaga ca stiidxa Dios, reeda binidxaba raxha ni de ndaani ladxidó' ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ne nuu xcaadxi binni zeda gaca casi xuba ni biaba lade guie que. Purti casi guna diaga ca stiidxa Dios, ricaa ca ni ne enda nayeche'. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Peru qué riaazi pe ni ndaani ladxidó' ca', sínuque luguiá si. Ngue runi casi pe gueeda xiixa ni naná, o iladxi cabe laaca pur stiidxa Dios que, maca zixale ca de laani. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ne nuu xcaadxi zeda gaca casi xuba ni biaba lade guichi que. Runa diaga ca stiidxa Dios, ");
INSERT INTO zaiNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","peru jma rucaa ique ca irá ni nuu ndaani guidxilayú, ne rudii ca lugar quite bidxichi ique ca ne riula'dxi ca gapa ca stale cosa. Irá nga ruuti stiidxa Dios ni nuu ndaani ladxidó' cabe que. Nga runi qué zanda iquiiñe cabe para Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Peru nuu xcaadxi binni zeda gaca casi xuba ni biaba ra nayá que, purti runa diaga ca stiidxa Dios ne ricaa ca ni, ne rudii ca lugar iniisi ni ndaani ladxidó' ca', ne óraque zanda iquiiñe ca para Dios. Nuu de laaca zeda gaca casi ni bidii treinta carreta niza que, ne nuu de laaca casi ni bidii sesenta que, ne nuu de laaca casi ni bidii dede ti gayuaa que. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Laca rabi be laaca': ―Lácaxa rucaa gui cabe ti linterna ne cu' cabe laa xa'na cajón o xa'na luuna'. Iruti qué runi zacá, sínuque rugaanda cabe ni luguiá para uzaani ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Zacaca irá ni ye'gu lú yanna, napa xidé ixele'. Ne zaqueca irá ni naga'chi yanna, laca qué ziaana sin qué ganna binni. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Irá ni racala'dxi guiene la? ucaa diaga. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ne laca rabi be laaca': ―Laucaa diaga chaahui ni cayabe laatu, purti bia' rucaa diaga tu, bia' cá nga gusiene Dios laatu. Ne zusiene ru be laatu jma pa ucaa diaga chaahui tu. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ni ma biene caadxi la? ziene jma, ne ni qué riene la? dede ni ma biene zusiaanda'. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ne laca rabi be laaca': ―Enda runi mandar sti Dios zeda gaca casi ora riguu binni biní. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Purti inque bisaba cabe xuba que la? ma zasi cabe huaxhinni ne ziasa cabe ridxí', ne zaqué ridi'di dxi, ne xuba que candani ne caniisi, peru qué ganna cabe ximodo raca ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Stubi layú que rusiniisi ni. Primeru riree bandaga, ne óraque dú, ne de raqué ma zee. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ne ora ma niza ni la? rindadi cabe ni purti ma bizaa dxi stini. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ne laca rabi be laaca': ―Xi zanda usaca nu enda runi mandar sti Dios, ne xi ejemplu zanda quixhe nu de modo chi dale xpinni be. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Zeda gaca ni casi ti biidxi mostaza ni rudxiiba cabe. Jma nahuiini ni que irá biidxi ni nuu ndaani guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Peru ora ma udxi'ba ni la? rirooba ni, dede raca ni yaga ro'. Ribee ni stale rama dede reeda mani huiini ruzá' lidxi lu rama stini ne riziila'dxi lu xpandá ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Puru ejemplu gudixhe be ra bisiidi be laaca', dede bia' ra gunda biene ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Qué ñui' né be laaca gasti sin qué niguixhe be ejemplu, peru ca discípulu stibe la? bisiene be laaca xi riní' cani. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dxi queca casi bixhinni, na be rabi be ca discípulu stibe: ―Chuu cherica nisa ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Para bisaana ca ca binni que, biuu ca ndaani canuá ra zuba be que, ne biree cabe ze cabe, ne yenanda xcaadxi canuá laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Peru laga ze cabe ndaani nisa que biete ti bi yooxho ne nabé naro'ba biasa ola stini de bilá nidxá canuá que de nisa. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Laga cayaca irá nga, nisiaasi Jesús atrá naguu xa ique ti almohada. Para bicuaani cabe laabe na cabe: ―Maistru, ñee cadi cazaala'dxu gati nu la? ");
INSERT INTO zaiNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Oraque biasa be gudinde né be bi yooxho que ne rabi be nisa que: ―Guta dxí. Ne biaana dxí bi que ne ma qué ñasa ru ola. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Oraque rabi be ca discípulu que: ―Xiñee cadxibi tu. Xiñee ca'ru gapa tu fe naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nabé bidxibi ca óraque, ne unaba diidxa saa ca': ―Tu laabe pue, dede bi ne nisa ruzuuba stiidxa be. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Udi'di cabe nisa que, biuu cabe xquidxi ca gadareno. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ne casi pe biete Jesús de ndaani canuá que, bidxiña ti hombre riguite binidxaba ique ra nuu be, ");
INSERT INTO zaiNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","biree de lade ba' purti raqué nabeza, ne iruti randa rundiibi laa, nin ne cadena. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Stale tiru bindiibi cabe cadena ná be ne ñee be, peru cada tiru la? ruxuuxe be cani ne iruti randa rucueeza laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Idubi dxi ne idubi gueela ma canazá be lu dani ne lade ba', canaucaa be ridxi ne ma cayuniná be laca laabe ne guie. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Peru de zitu ru biiya be Jesús, bixooñe be ne bizuxibi be xañee, ");
INSERT INTO zaiNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ne bicaa binidxaba ni napa be que ridxi: ―Xi napa nia lii, Jesús Xiiñi Dios ni nandxó'. Rinaba lii cadi guniná lu naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Uní' be zaqué purti cayabi Jesús laabe iree be de hombre que. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ne unaba diidxa Jesús laabe tu lá be. Para na be: ―La'ya Legión purti stale du. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ne ucuá be lú Jesús cadi cuee laacabe de lugar que. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bia'si canazá jma bihui cue' ti dani canayó. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Para na ca binidxaba que, rabi ca Jesús: ―Biseenda laadu ra nuu ca bihui ca, bidii lugar chu' du luguiá came. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ne óraque biree ca de hombre que ne bidii Jesús lugar yechuu ca luguiá ca bihui que. Nuu bia' chupa mil bihui raqué. Ne casi biuu ca luguiá ca bihui que biete tí came de ra dxi'ba came. Bia'si pe ndaani nisa biaba came, ne raqué guti came. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ne bixooñe cani cayapa ca bihui que, uyé ca ndaani guidxi ne irá ca ranchu ni nuu neza que, yegüí ca ni uca que. Beeda stale binni, beda guuya ca xi uca raqué. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ne ora bidxiña ca ra nuu Jesús, biiya ca zuba dxa hombre ni gudxite binidxaba ique que, ma nacu lari ne ma bigueta xpiaani', ne bidxibi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Cani bi'ya ora uca ni la? byuí' né ca binni modo bizaaca dxa hombre que ne modo uca ca bihui que. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Oraque bizulú ca binni que ucuá ca lú Jesús ixele de xquidxi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ne ma zichuu Jesús ndaani canuá que bidxiña hombre que ne na gudii be lugar chiné laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Peru qué niná di be, sínuque rabi be laa: ―Guyé rali'dxu', yegüí né ca binni li'dxu pabiá' naro'ba ni bi'ni Dios lii ne pabiá' biá lii. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Para biree hombre que ze' ne bizulú byuí' né ca binni de ca guidxi sti Decápolis pabiá' naro'ba ni bi'ni Jesús laa. Nabé bidxagayaa irá binni que. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ora bigueta Jesús sti ladu nisa que beeda stale binni ra nuu ne biaana uriá nisa que. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Oraque beeda ti hombre lá Jairu naca xaíque sti ti yu'du', ne casi bi'ya laabe bizuxibi xañee be, ");
INSERT INTO zaiNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ne na rabi laabe: ―Ma cayati xiiñe'. Chuu, quixhe ná lu luguiá be ti guianda be ne cadi gati be. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Para biree be ziné be laa. Peru nabé stale binni zinanda laabe dede cuquiichi ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ne lade irá binni que nuu ti gunaa ma raca doce añu de caxii rini. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ma birá doctor uyé be ra nuu, ne ma biniti be irá ni napa be. Ne lugar de ñanda be, laga jma rusi zirooba enda huará que. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ma huayuna diaga be de Jesús, nga runi biuu be atrá lade ca binni que ne guda'na be xhaba Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Purti na be neca xhaba si Jesús cana be, zianda be. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ne casi pe uda'na be xhaba Jesús biaana dxí ca enda rixii rini que ne bini sentir be ma bianda be. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Oraque bidii Jesús cuenta bisianda tuuxa ne biiya dxí atrá, biyubi lú lade ca binni que ne na: ―Tu guda'na xhaba'. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Para na ca discípulu stibe rabi laabe: ―Cayuuyu pabiá' cuquiichi binni lii peru nou': “Tu guda'na xhaba'.” ");
INSERT INTO zaiNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Peru biyubi lú be irá ladu para gu'ya be tu uda'na xhaba be. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Oraque bidxiña gunaa que, cayaca diti de tantu cadxibi purti nanna xi uca', ne bizuxibi xañee be ne ulee ruaa diidxa de irá ni uca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Para rabi be laa: ―Bianda lu, xiiñe', purti bini cre lu'. Yanna, sicarú uyé, ma bianda lu ne ma qué zabigueta ru ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Caní' ru be biuu tu beda tidxi xaíque sti yu'du que, na rabi laa: ―Ma guti xiiñi lu', xi para cuchiiña rou' maistru. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Peru ora bina diaga Jesús xi na cabe la? na rabi xaíque que: ―Cadi idxibi lu', bini cre si naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ne qué niná Jesús ninanda stale binni laa, sínuque Pedru ne Jacobo ne Juan bi'chi Jacobo si. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ora yendá be ralidxi xaíque que, biiya be rí binni, cayuuna ca ne cucaa ca ridxi. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Para biuu be ne rabi be laaca': ―Xiñee cayuni tu irá ruidu ri', ne xiñee cayuuna tu, purti cadi guti di badu dxapa huiini ri'; nisiaasi si be nga. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Peru laga bini burla ca laabe, para gulee be irá ca ne ucuaa be bixhoze ba'du que ne jñaa ne cani ziné be que ne biuu cabe ra nuu badu dxapa huiini que. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ne gunaaze be ná ba'du que rabi be laa: ―Talita, cumi. Ni riní' ni la? “Biasa, badu dxapa huiini'.” ");
INSERT INTO zaiNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Oraqueca biasa badu dxapa huiini que ne gunda uzá. Ma napa badu dxapa huiini que doce añu. Nabé bidxibi ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Peru biinda ca Jesús lú ca' qué chi tidxi ca ni iruti', ne gudxi be laaca udii ca ni go ba'du que. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Biree Jesús de raqué bigueta xquidxi, laa ne ca discípulu sti'. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ne dxi gunda dxi enda riziila'dxi que la? bizulú be bisiidi be ndaani yu'du'. Nabé bidxagayaa cani cucaa diaga laabe que ne na ca': ―Paraa biziidi hombre ri irá ndi pue, ne paraa ulee irá enda biaani ni napa, ne irá milagru cayuni ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Lácaxa cadi dxa carpinteru xiiñi María que ndi', bi'chi Jacobo ne José ne Judas ne Simón. Ca biza'na be laca rarí nabeza ca'. Ne pur nga runi qué ñuni cre cabe Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Peru óraque na Jesús rabi laacabe: ―Stobi stobi lugar risaca profeta, peru ra qué risaca be nga ndaani xquidxi pe be ne ralidxi be ne lade binni lidxi be. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ne qué ñanda ñuni be nin ti milagru raqué jma que gudixhe ná si be luguiá caadxi binni huará ne bianda ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ne bidxagayaa be purti qué ñuni cre ca binni que. De raqué uzá be irá ca guidxi huiini ni nuu gaxha neza que, canausiidi be. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ne guridxi be doce discípulu stibe que. Bizulú biseenda be laaca chupa chupa, ne gudixhe be ladxi ná ca cuee ca binidxaba de binni. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ne gudxi be laaca cadi chiné ca gasti ni iquiiñe ca neza sínuque bastón si, ne cadi naquiiñe chiné ca pan, nin ixhiapa, nin vueltu. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ne ucaa ñee ca guela guidi ne chiné ca ti muda lari si. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ne rabi be laaca': ―Ora guiete tu ti ra yoo la? laguiaana raqué dede ora iree tu de guidxi que. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ne pa chu' paxaraa qué na cabe icaa cabe laatu nin ucaa diaga cabe laatu la? lairee de raqué ne laquibi ñee tu casi ti seña bichee cabe ra qué niná cabe nucaa diaga cabe laatu. Ne gabe ca' laatu, jma naná ziaba ná cabe para ca binni Sodoma ne Gomorra, dxi cuidxi Dios cuenta binni. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Para biree ca discípulu que ze ca', yeusiidi ca binni naquiiñe usaana xpecadu. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ne laca ulee cabe stale binidxaba de binni, ne uxubi cabe aceite ladi binni ne bisianda cabe laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Gunna rey Herodes irá ni, purti ma za'bi stiidxa Jesús idubi naca guidxi que, ne na: ―Ma bibani Juan Bautista ne laabe nga Jesús ni cayanda cayuni irá enda nandxó' ca. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Peru xcaadxi na: ―Elías nga. Ne xcaadxi na: ―Ti profeta casi cani uyuu chiqué nga. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Peru ora bina diaga Herodes ni na cabe que la? na: ―Juan nga, dxa ni bine mandar ugá cabe yanni que. Laabe nga ma bibani be. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Uní' be zacá purti nanna be xi ma bi'ni be Juan. Gunaaze be laa ne bindiibi be laa ne biseguyoo be laa, runi Herodías xheela Felipe bi'chi be, purti ucuaa be Herodías casi xheela be. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Bidxiichi be purti gudxi Juan laabe cadi jneza chu' né be xheela bi'chi be. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ne pur nga nabé uca nanala'dxi Herodías Juan ne ucala'dxi ñuuti laa peru qué ñanda. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Qué nudii Herodes lugar ñuniná be Juan purti nanna nayá ladxidó' Juan ne nacha'hui', ne ridxibi Herodes Juan. Neca qué ñene be stale de ni uní' Juan, peru bicaa diaga be laa ne stale gana. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Peru bidxiña dxi gunda bi'ni Herodías ni ucala'dxi que. Dxi lani xpidó' Herodes uca saa ne bi'ni Herodes ti endaró para ca xaíque ne ca capitán sti' ne para ca binni ni jma risaca de Galilea. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ne guyuu xiñi dxaapa Herodías ra cayó xhi cabe que, biyaa. Nabé uyuula'dxi Herodes ne cani cayó xhi ne laa que modo biyaa badu dxaapa que. Para na rabi laabe: ―Unaba naa intiica acala'dxu ne zudiee ni lii. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ne bini jurar rey que udii laabe intiica inaba be, neca galaa de ra runi mandar. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Oraque biree be uyé be ra nuu jñaa be ne rabi be laa: ―Xi inaba laabe. Para na jñaa be: ―Unaba laabe ique Juan Bautista. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Oraqueca biuu be ra nuu rey que ne rabi be laa: ―Racaladxe udiiu naa ique Juan Bautista ndaani ti bladu nagasi du'. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ucaná ladxidó' Herodes óraque peru qué ñanda ñabi be badu dxaapa que co' purti bina diaga cani zuba né be que bini jurar be zudii be badu dxaapa que intiisi acala'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Oraqueca biseenda be ti soldadu zicaa ique Juan. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Para uyé soldadu que biuu ndaani lidxi guiiba', guxha ique Juan ne gudixhe ni ndaani bladu'. Bidii ni badu dxaapa que, de badu dxaapa que ma bidii ni jñaa. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ora gunna ca discípulu sti Juan ni uca que la? yecaa ca xcuerpu be para bicaachi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bigueta si ca apóstol sti Jesús ra nuu, ne byui' né si ca laabe xi irá bi'ni ca ne bisiidi ca la? ");
INSERT INTO zaiNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","rabi be laaca': ―Yanna, chuu nu zitu huiini ra gasti binni para iziila'dxi nu caadxi. Purti ze zeeda binni ra nuu cabe, nin para go cabe gueta. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Oraque biree Jesús ne ca discípulu que, biuu ca ndaani ti canuá ziyubi ca ti lugar ra qué guinni binni. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Peru stale binni biiya ora ze cabe ne binibiá' ca Jesús. Para biree binni de irá guidxi neza que ziuxooñe ca ti uriá nisa que, ne yendá ca primeru para laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Casi biete Jesús lu canuá que biiya ma rí stale binni raqué ne biá laacabe purti nuu cabe casi dendxu sin pastor. Para bizulú bisiidi laacabe stale cosa. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ora bi'ya ca discípulu stibe ma huadxí la? bidxiña ca ra nuu be ne rabi ca laabe: ―Ma huadxí ndi' ne iruti binni nabeza cherí'. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gudxi ca binni ca ma bidxiña ora che ca', ti ganda che cabe ca guidxi huiini ne ca ranchu nuu gaxha ca, para sí cabe pan, purti qué gapa cabe ni go cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Peru na Jesús rabi laaca': ―Laudii ni go cabe laatu. Para na ca': ―Zanda xa chi sí du chupa gayuaa denariu pan para go cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Oraque na Jesús rabi laaca': ―Panda ga pan napa tu ya'. Lachiguuya panda. Para yeguuya cabe ne óraque beeda cabe ne na cabe: ―Gaayu pan ne chupa benda. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Para gudxi Jesús ca binni que cui ca lu ca guixi nagá' ni nuu raqué, caadxi caadxi. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ne zaqué gurí cabe. Nuu ra zuba ti gayuaa ne nuu ra zuba cincuenta, dede birá cabe gurí cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Oraque ucuaa Jesús gaayu pan ne chupa benda que. Gundisa lú ibá' ne bidii diuxquixe Dios, para gundaa ca pan que bidii ca discípulu sti' qui'zi ca lú ca binni que. Ne zaqueca bi'ni be iropa benda que. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ne gudó irá binni que dede ra bidxá ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ne bidxá doce dxumi de nandahui ni biaana lu pan ne lu benda que. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bia'si gaayu mil hombre gudó raqué. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Biluxe si ngue la? uluu Jesús ca discípulu sti ndaani canuá que, sa niru gá ca lú be tidi ca nisa que che ca Betsaida, laga gabi be ca binni que ma che be. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Biluxe si uní' né be ca binni que la? biree be ziní' né be Dios lu dani. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ne ora bixhinni ma nuu canuá sti ca discípulu que zitu de uriá nisa que, ma stubi si Jesús nuu ra nabidxi. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ne biiya nagana cayaca para laacabe chiné cabe canuá que purti cudxigueta bi laacabe. Nuxcanda que bidxiña Jesús laacabe, zeda za lu nisa ne ucala'dxi nidi'di lú cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Peru ora bi'ya cabe zizá be lu nisa la? zácaxa cabe cayuuya cabe tentación ne bicaa cabe ridxi. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Purti irá cabe biiya cabe laabe ne bidxibi cabe. Peru óraque uní' né be laaca': ―Naa ndi', cadi idxibi tu. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Para udxi'ba be ndaani canuá ra nuu cabe que ne oraqueca biaana dxí bi que. Nabé bidxagayaa cabe, ");
INSERT INTO zaiNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","purti ca'ru guiene cabe tu laabe, nin ne ma biiya cabe milagru ra bitale be ca pan que, purti nada'gu ru xquenda biaani cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Gudi'di cabe nisa que, yendá cabe Genesaret ne bindiibi cabe canuá que uriá nisa. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Casi pe biete cabe lu canuá que binibiá' ca binni que Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Para yetidxi ca irá binni neza que ma beeda be, ne bizulú bedané ca binni que stale binni huará lu luuna' ra nuu be. ");
INSERT INTO zaiNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ne ratiica guiiu be ndaani guidxi ro' o guidxi huiini' o ndaani ranchería, riguixhe cabe ca binni huará que lu calle ne rinaba cabe laabe udii be lugar neca ñee xhaba si be cana cani huará que. Ne bianda irá ni guda'na xhaba be que. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Raqué nuu be bidxiña caadxi fariseu ne caadxi maistru de ley ni beeda de Jerusalén ra nuu be. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ne biiya ca cayó caadxi discípulu stibe sin niguiibi ná', ne bizulú uní' ca ca discípulu que. ( ");
INSERT INTO zaiNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ca fariseu la? zinanda ru ca costumbre sti ca bixhoze gola ca', qué ro ca gueta sin qué qui'bi chaahui ca ná ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ne ora ibigueta cabe de luguiaa la? napa pe cabe ti modo riguiibi ná cabe para go cabe. Ne nuu ru stale costumbre ni zinanda cabe, casi modo qui'bi cabe vasu, ne jarra ne traste de guiiba', ne luuna'.) ");
INSERT INTO zaiNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Oraque na ca fariseu ne ca maistru de ley que rabi ca Jesús: ―Xiñee cadi zinanda ca discípulu stiu' costumbre sti ca binigola, purti ridu'ya du ro ca sin qui'bi ná ca casi naquiiñe ñuni ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Para na Jesús rabi laacabe: ―Jneza ni uní' Dios de ruaa profeta Isaías chiqué ra bizeete pabiá' rusiguii tu, na: Ca binni ri nanaxhi ruaa ca ne naa, peru ladxidó' ca nuu zitu de naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pur gana si rusisaca ca naa, purti de laasi ca riale ni rusiidi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ne dxandí ni purti zacá pe runi tu. Rusaana tu mandamientu sti Dios para chi nanda tu costumbre sti binni, casi enda ria'ri jarra ne vasu, ne xcaadxi costumbre casi ca nga. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ne laca rabi be laaca': ―Galán xa ni runi tu, rusaana tu ni gudixhe Dios para chi nanda tu ca costumbre stitu. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Gudxi Moisés laatu ganaxhii tu bixhoze tu ne jñaa tu, ne laca gudxi be laatu, tu cu' dí bixhoze o jñaa naquiiñe gati'. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Peru laatu na tu, zaa gabi ti hombre bixhoze o jñaa: “Qué zanda di acaniá lii purti ni nudiee lii ca, ma bine ni Corbán.” (Corbán rabi cabe xiixa cuee chu cabe para Dios.) ");
INSERT INTO zaiNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ne inque ma uní' be zacá la? neca cadi dxandí ni, peru rabi tu laabe gasti naca pa qué acané be bixhoze be o jñaa be. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ne zacá pur ca costumbre stitu ni zeda za lade tu la? napa tu stiidxa Dios casi xiixa de enda riguite. Ne nuu ru stale runi tu ni cadi jneza. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Bigueta guridxi Jesús irá ca binni que sti tiru ne na rabi laaca': ―Laucaa diaga naa irá tu, ne laguiene. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Cadi ni riuu ndaani ruaa binni, nga runi pur uchee ca', sínuque ni iree de ndaani ladxidó' ca', nga runi ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Laucaa diaga chaahui ti guiene tu. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Oraque biree Jesús de ra nuu ca binni que, biuu ndaani yoo. Ne raqué nuu be beeda ca discípulu ra nuu be ne unaba diidxa ca laabe xii ngue gudxi be ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Para rabi be laaca': ―Ñee nin laatu qué riene tu la? Ñee qué ganna tu pa cadi ni ro binni nga runi pur uchee né ca Dios la? ");
INSERT INTO zaiNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Purti qué riuu di ni ndaani ladxidó' cabe sínuque riaba ni ndaani cabe ne óraque riree ni de cuerpu stícabe. Zacá gudxi be laaca zanda go ca intiisi endaró. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ne rabi be laaca': ―Ni riree ndaani ladxidó' binni, nga ni runi pur uchee né ca Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Purti de ndaani ladxidó' cabe riree irá ni riní' ique cabe guni cabe: chu' né cabe ni cadi xheela cabe, gapa cabe jnadxii cabe, guuti cabe binni, ");
INSERT INTO zaiNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","cuana cabe, acala'dxi cabe gapa cabe jma que stobi, guni cabe ni nadxabá', usiguii cabe, gapa cabe irá clase viciu, gache lú cabe sti stobi, cuee cabe falsu luguiá binni, uchá cabe enda naró' stícabe, guni cabe enda huati. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Irá enda nadxaba ca riree de ndaani ladxidó' binni ne pur irá nga ruchee né cabe Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","De raqué biree be uyé be gaxha de Tiro, ne biuu be ndaani ti yoo. Gucala'dxi be qué ñanna binni pa nuu be raqué peru qué ñanda nucaachi lú be. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Qué nindaa de biuu be raqué gunna ti gunaa de laabe, ne beeda ra nuu be purti napa ti xiñi dxaapa riguite binidxaba ique. Casi biuu bizuxibi xañee be. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Binni Fenicia gunaa que, cadi judíu laa. Gunaba laabe cuee be binidxaba que de xiiñi'. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Peru rabi be laa: ―Bidii lugar go ca ba'du primeru, purti cadi jneza gaxha cabe pan xiiñi cabe para udii cabe bi'cu'. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Oraque na gunaa que: ―Nanna, Señor, peru laca ro bi'cu bigú ni riaba xa mexa sti xpixuaana'. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Para na Jesús rabi laabe: ―Jneza uní' lu'. Ma zanda che lu', ma biree binidxaba que de xiiñi lu'. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ne dxandí ora yendá be ralidxi be biiya be nexhe badu dxapa huiini que lu luuna', ma bisaana binidxaba que laa. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Qué nindaa de ngue biree Jesús de Tiro, uzá neza Sidón ne irá ca guidxi ni rabi cabe Decápolis, ne bigueta ra nisa Galilea. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Raqué nuu be bedané cabe ti hombre nacuaata diaga ne napaapa ruaa ra nuu be, ne gunaba cabe laabe cuaqui ná be luguiá hombre que. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Para ucuaa be hombre que yené be laa ti ladu ne guluu be bicuini ná be ndaani diaga ne bichá xhinni be ne guda'na be ludxi. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Oraque biiya dxí be ibá' gucuaala'dxi be ne na be: ―Efata. Ni riní' ni la? “Bixale'.” ");
INSERT INTO zaiNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ne oraqueca bixale diaga hombre que ne bianda ludxi ne ma gunda uní' jneza. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ne gudxi be laaca cadi gabi di ca ni iruti'. Peru laga jma cayabi be laaca cadi güi cani la? jma rusi byui' né ca ni binni. ");
INSERT INTO zaiNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ne nabé bidxagayaa stale binni, ne na ca': ―Jneza irá ni runi be dede ruxhele be diaga cani nacuaata diaga ne rusiní' chaahui be cani napaapa ruaa. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nabé stale binni bidxiña ra nuu Jesús ca dxi que, ne qué gapa ca ni go ca'. Para guridxi be ca discípulu stibe, ne na be rabi be laaca': ");
INSERT INTO zaiNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Caya'ya ca binni ri' purti ma chonna gubidxa nuu né cabe naa rarí' ne qué gapa cabe ni go cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Pa useenda laacabe chibí' cabe sin go cabe la? qué zapa cabe stipa para sa cabe purti nuu caadxi de laacabe beeda de zitu. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Oraque na ca discípulu que rabi laabe: ―Peru paraa idxela ni go cabe rarí ya'. Iruti nabeza rarí'. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Para rabi be laaca': ―Panda ga pan napa tu ya'. Oraque na ca': ―Gadxe. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Para gudxi be ca binni que cui ca layú, ne ucuaa be ca pan que, bidii be diuxquixe Dios ne gundaa be cani, bidii be cani ca discípulu stibe que qui'zi ca cani lú ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Laca napa cabe chupa chonna benda. Para bidii Jesús diuxquixe Dios ne gudxi laacabe qui'zi cabe cani. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Irá binni que gudó dede ra bidxá, ne bidopa ru xcadxe dxumi de nandahui ni biaana. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bia' tapa mil gudó dxi que. Ne óraque gudxi Jesús laacabe ma zanda che cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ne laa biuu né ca discípulu sti ndaani canuá para ze ca neza Dalmanuta. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ne raqué bidxiña ca fariseu ra nuu be ne bizulú cacaa yu né ca laabe. Gunaba ca laabe guluí' be laaca ti seña xaibá' ti gu'ya ca pa dxandí nandxó' be. Uní' ca zaqué purti cuyubi ca usaba ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Oraque ucuala'dxi be tobi ne na be: ―Xiñee canaba ca binni ri gu'ya ca seña. Gabe ca' laatu, nin ru sti seña qué zudiee laatu, rabi be laaca' ne biree be ze be, ");
INSERT INTO zaiNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","bisaana be laaca'. Biuu be ndaani canuá que sti tiru para ze be cherica nisa que. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Biaanda niné ca discípulu endaró, ti pan si ziné ca ndaani canuá que. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Oraque na Jesús rabi laaca': ―Laguuya gá qué chi cá sti ca fariseu ne sti Herodes laatu. Ricá ni runi cabe casi riaazi levadura cuba pan. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Oraque na ca discípulu: ―Cayabi be ndi laanu tisi qué ñedané nu pan. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Peru nanna Jesús xi caní' cabe, para rabi laacabe: ―Xiñee na tu qué gapa tu pan. De yanna ca'ru guiene tu ne ca'ru ganna tu la? Ñee tan nada'gu xquenda biaani tu la? ");
INSERT INTO zaiNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Ñee qué ruuya tu ne lú tu ne qué runa diaga tu ne diaga tu la? Ñee qué rietenala'dxi tu dxi udiize gaayu pan lu gaayu mil que la? Panda dxumi de nandahui bitopa tu. Para na ca': ―Doce. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Oraque rabi be laaca': ―Laga dxi udiize gadxe pan lu tapa mil que ya'. Panda dxumi bitopa tu. Para na ca': ―Gadxe. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Oraque rabi be laaca': ―De yanna ca'ru guiene tu la? ");
INSERT INTO zaiNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","De raqué yendá cabe Betsaida. Ne bedané ca binni de raqué ti hombre nacheepa lú, ra nuu Jesús ne gunaba ca quixhe ná Jesús luguiá be. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Para unaaze Jesús ná be biree né laabe de ndaani guidxi huiini que. Ne guxubi nisa xhinni lú be ne gudixhe ná luguiá be ne gunaba diidxa laabe pa ruuya be xiixa. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Oraque biiya dxí be ne na be: ―Ruuya binni peru ruuya laaca casi yaga zizá. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Bigueta gudixhe ná Jesús lú be ne óraque ma biiya chaahui be ne bianda be. Ma ruuya be irá cosa naya'ni'. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Para biseenda Jesús laabe chibí' be ne na rabi laabe: ―Cadi guiuu lu ndaani guidxi ne cadi gabi lu ni iruti de raqué. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sti dxi biree Jesús ne ca discípulu sti' ze ca ca guidxi ni nuu neza Cesarea de Filipo. Ne neza ze cabe na Jesús rabi laacabe: ―Tu na binni naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Oraque na cabe: ―Caadxi na lii nga Juan Bautista ne xcaadxi na Elías ne xcaadxi na tobi de ca profeta. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Para rabi be laaca': ―Laatu ya' tu na tu naa. Para na Pedru: ―Lii nga Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Peru gudxi be laaca cadi gabi ca ni iruti'. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Oraque bizulú be bisiidi be laaca de ni chi aca ru be, na be rabi be laaca': ―Naa nga Hombre Biseenda Dios. Zuniná cabe naa, ne zaree nanda ca xaíque sti guidxi ne ca xaíque sti ca sacerdote ne ca maistru de ley naa, ne zuuti ca naa. Peru zabane ra guionna gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Bisiá be diidxa xi irá chi aca be. Peru yené Pedru laabe ti ladu ne gudxi laabe cadi iní' be zaqué. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Oraque bidxigueta lú be ne biiya dxí be ca discípulu stibe ne udinde né be Pedru, na be rabi be laa: ―Bixele de naa, binidxaba', purti cadi de Dios zeeda ni cá ique lu ca sínuque de binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Oraque guridxi be ca discípulu stibe ne ca binni que ne rabi be laaca': ―Tu gacala'dxi gaca xpinne la? usiaanda laca laa, cadi lica guiá xpida, ne sa nanda naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Purti tu gacala'dxi ulá xpida, zuniti ni. Peru tu uniti xpida pur naa ne pur stiidxa Dios la? zalá. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Paraa iquiiñe ni binni pa guni ganar idubi naca guidxilayú peru guniti xhialma. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","O pagala zanda quixe binni saca ulá xhialma. ");
INSERT INTO zaiNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Naa nga Hombre Biseenda Dios. Tu ituí lú iní' pa xpinne laa o ituí lú pur stiidxa' nezalú cani qué runi cre ne cani qué runi jneza la? naa laaca zatuí lua inié xpinne laa, dxi guendaniá enda nandxó' sti Bixhoze', ne ca ángel cha'hui'. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ne laca na Jesús rabi laacabe: ―Gabe ca' laatu, nuu caadxi de cani nuu rarí qué zati dede qué guzulú guni mandar Dios ne enda nandxó' sti'. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Gudi'di xhoopa gubidxa de ngue yené Jesús Pedru ne Jacobo ne Juan, ne idapa si cabe uyé cabe lu ti dani soo, ne raqué mala biiya cabe ma adxé modo bihuinni Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Bizaani xhaba be ne uca ni naquichi bé, dede iruti binni guidxilayú nusiquichi lari bia' qué. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ne biiya ca cayuí' né Elías ne Moisés laabe diidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Oraque na Pedru rabi laabe: ―Maistru, aque galán nuu nu rarí nja'. Ñee zaa ucuí du chonna ranchu huiini la? tobi para lii, tobi para Moisés ne stobi para Elías. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tantu cadxibi cabe dede nin qué ganna Pedru xi caní'. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ne óraque biseegu ti za laacabe ne ucuá ti ridxi lade za que: ―Ndi nga xiiñe' ni nadxiee'. Laucaa diaga laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Oraqueca biiya dxí cabe peru ma qué ñuuya ru cabe iruti' sínuque Jesús si stubi. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ora ziyete cabe lu dani que, gudxi Jesús laacabe cadi güi né di cabe iruti de ni bi'ya cabe, sínuque cueza cabe guiasa si Hombre Biseenda Dios de lade gue'tu'. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ne nga runi gupa cabe ni lade si cabe, peru gunaba diidxa saa cabe ximodo nga na be guiasa be de lade gue'tu'. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Oraque rabi cabe Jesús: ―Xiñee na ca maistru de ley zeeda Elías ante gueeda ni nexhe guseenda Dios que ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Para na Jesús rabi laacabe: ―Dxandí nexhe gueeda Elías primeru para quixhe chaahui irá cosa. Laga xi na lu Xqui'chi Dios de dxa Hombre ni nexhe guseenda Dios que ya'. Ñee cadi na ni zadi'di be ra naná ne zudxii deche binni laabe la? ");
INSERT INTO zaiNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Peru naa rabe laatu ma beeda Elías ne bi'ni cabe laabe ni ucala'dxi cabe, casi cá lu Xqui'chi Dios guni cabe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Oraque bigueta cabe ra nuu ca xcaadxi discípulu que ne biiya cabe rí binni laaca'. Ne laca nuu caadxi maistru de ley raqué cacaa yu né ca ca discípulu. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Oraque pe ulee lú Jesús zeeda, ne nabé bidxagayaa ca binni que ora bi'ya ca laabe, ne yeuxooñe ca' yeugapa diuxi ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Para rabi be laaca': ―Xi cayaca tu. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Oraque na tobi de ca binni nuu raqué: ―Maistru, zedaniá xiiñe ra nuu lu' purti riguite binidxaba laabe ne ma bisaana laabe mudu. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ratiica nuu be rugaze binidxaba ca laabe layú ne riree bupu ruaa be ne rixidxi laya be. Ne zacá jma rusi cará stipa stibe. Ma gunaba ca discípulu stiu' nibee ca binidxaba ca de laabe peru qué ñanda. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Para na Jesús rabi laacabe: ―¡Aque qué runi cre tu xa, binni ca'! Dede padxí naquiiñe guiaana nia laatu ne gune huantar laatu ya'. Latané hombre huiini ca rarí'. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Para bedané cabe hombre huiini que. Casi bi'ya binidxaba que Jesús, bi'ni pur bidii ataque laabe ne biaba be layú, canatubi be ne caree bupu ruaa be. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Oraque na Jesús rabi bixhoze be: ―Padxí ti raca be sicarí ya'. Para na bixhoze be: ―Dede dxi nahuiini be. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Stale tiru riguu binidxaba ca laabe lu gui ne ndaani nisa para guuti laabe. Nga runi pa zanda gu'nu xiixa la? biá laadu ne ucané laadu. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Para na Jesús rabi laabe: ―Naa la? zanda. Lii si nga pa zanda guni cre lu', purti gasti ni nagana para cani runi cre. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Oraque bicaa be ridxi: ―Rune cre, Señor. Ucané naa gune cre jma. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ne ora bi'ya Jesús nabé ma cabí zisi binni la? udinde né binidxaba que, na: ―Biree, binidxaba mudu ne diaga cuaata'. Naa cayabe lii iree lu'. Bisaana hombre huiini ri' ne ma cadi ibigueta rou' luguiá be. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Oraque bicaa binidxaba que ridxi ne bi'ni pur bidii sti ataque laabe ne biree ze', bisaana laabe casi gue'tu'. Ne stale de ca binni nuu raqué na ma guti be. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Peru guluu ná Jesús ná be, undisa laabe ne bizuhuaa be. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Oraque biuu Jesús ndaani ti yoo, laa si ne ca discípulu sti', ne raqué na ca rabi ca laabe: ―Xiñee laadu qué ñanda nibee du binidxaba ca pue. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Para rabi be laaca': ―Purti para ganda cuee cabe binidxaba casi nga la? naquiiñe guiaana cabe sin go cabe ne ini' né cabe Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Biree si cabe de raqué udi'di cabe Galilea ne qué na Jesús ganna iruti pa nuu raqué. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Purti cusiidi be ca discípulu stibe, ne cayabi be laaca': ―Naa nga Hombre Biseenda Dios. Zutoo cabe naa lu binni guidxilayú, ne zuuti ca naa, peru lu chonna gubidxa de biiti ca naa la? zabane'. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Peru qué ñene ca laabe ne bidxibi ca ninaba diidxa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yendá cabe ndaani guidxi Capernaum ne biuu si cabe ndaani yoo, unaba diidxa Jesús laacabe xi diidxa zeda yui' cabe neza. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Peru nin tobi cabe qué niní' cabe, purti ora zeeda cabe neza la? cacaa yu cabe tuu nga jma risaca lade cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Oraque gurí Jesús ne guridxi ca discípulu sti', ne na rabi laaca': ―Pa nuu tu racala'dxi isaca jma la? cadi guyubi usisaca cabe laa, sínuque usisaca laacabe, ne gaca casi jmozo cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Oraque ucuaa Jesús ti ba'du', bizuhuaa galahui de laacabe ne ucuaa ba'du que guluu ndaani ná' ne na rabi laacabe: ");
INSERT INTO zaiNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Tutiica gacané ti ba'du casi ba'du ri' pur naa la? casi ñaca cayuni ni naa, ne tu guni ni naa la? cayuni ni, ni biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Oraque na Juan rabi laabe: ―Maistru, bidu'ya du ti hombre cuzeete lá lu ra cabee binidxaba de binni, peru bicueeza du laabe purti cadi canazá né be laanu. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Para na Jesús rabi laacabe: ―Xiñee canaucueeza tu laabe, purti ni cayuni milagru ra uzeete la'ya la? qué zanda ucaa lú naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ne tu cadi cucaa lú laanu la? nuu pur laanu. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tutiica udii laatu neca ti vasu nisa si purti xpinni Cristu laatu la? gabe ca' laatu, qué ziaana ngue sin guiaxa. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Tutiica guni pur uchee tobi de cani nahuiini ni runi cre naa la? jma galán ñaca para laa nugaanda cabe ti guie dani ro' yanni ne nundaa cabe laa ndaani nisadó'. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Pa nuu xiixa ni cuchiiña ná lu lii icoou', ne pur laani chi uchee lu la? bixele ca de laani, purti cadi tan naná zaca para lii uniti lu ni peru gapu enda nabani ni qué zaluxe, bia' nga naná zaca para lii gapu ni racala'dxu que ne cheu' gabiá ra cayaca bele ni qué zanda gyui'. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Raqué qué zará enda nayuudxu' ne qué zyui' gui. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ne zaqueca pa nuu ra cuchiiña ñeeu lii cheu', peru zucheeu pa cheu' raqué la? cadi cheu' diou' purti cadi tan naná zaca para lii guiaanu sin cheu' raqué peru gapu enda nabani ni qué zaluxe, bia' nga naná zaca para lii cheu' ra racala'dxu cheu' que, ne cheu' gabiá ra cayaca bele ni qué zanda gyui'. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Raqué qué zará enda nayuudxu' ne qué zyui' gui. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Zaqueca pa nuu xiixa ni ruuya lu' ne ruquiinde ni lii gu'nu ni cadi jneza la? bixele de laani purti cadi tan naná zaca para lii ixele lu de laani peru chu' lu ra runi mandar Dios, bia' nga naná zaca para lii pa uchee lu pur laani ne cheu' gabiá ra cayaca bele ni qué zanda gyui'. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Raqué qué zará enda nayuudxu' ne qué ziuu dxi gyui' gui. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Purti ziaba enda naná luguiá binni casi riaba zidi endaró. ");
INSERT INTO zaiNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Zidi la? riquiiñe ora naxí, peru pa niniti enda naxí stini la? ximodo nixí ni sti tiru. Zacaca laatu, lagaca casi zidi ni naxí, ti ganda iquiiñe tu ndaani guidxilayú. Ne laibani sin enda ridinde. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Biree Jesús Capernaum uyé neza Judea ne laca uyé cherica guiigu Jordán. Raqué nuu be gurí zisi binni laabe sti tiru, ne bizulú bisiidi be laaca casi runi be. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ne óraque bidxiña caadxi fariseu ra nuu be, cuyubi ca modo usaba ca laabe pur ni iní' be. Gunaba diidxa ca laabe pa jneza ilaa né ti hombre xheela'. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Para rabi be laaca': ―Xi bisaana Moisés guni tu. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Oraque na ca': ―Na Moisés zaa usaana cabe xheela cabe peru gaca divorciar né cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Oraque na Jesús rabi laacabe: ―Gudxi Moisés laatu guni tu zacá purti naguidxi ladxidó' to. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Peru dxi bizulú bizá' Dios irá xixé cosa la? “bizá' be hombre ne gunaa”. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Pur nga runi zusaana hombre bixhoze ne jñaa ne zadxaaga xheela'.” ");
INSERT INTO zaiNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ne zacá zeda gaca cabe tobi si, ma cadi chupa cabe sínuque tobi si laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nga runi cadi indaa binni ni ma bichaaga Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Biuu si cabe yoo, gunaba ca discípulu laabe gusiene be laaca xii ngue gudxi be ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Para rabi be laaca': ―Ora ilaa né ti hombre xheela' ne ichaganá adxé gunaa la? cuchee né xheela'. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ne pa usaana ti gunaa xheela' ne ichaganá stobi la? laca cuchee ne xheela'. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ti dxi bedané cabe caadxi ba'du ra nuu Jesús para quixhe ná luguiá ca'. Peru udinde né ca discípulu que cani bedané laacabe que. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ne ora bi'ya Jesús xi cayaca la? bidxiichi, ne na: ―Cadi ucueeza tu ca ba'du ca. Zaa gueeda cabe ra nuaa' purti stícabe irá ni napa Dios ladxi ná', laacabe ne irá casi laacabe ca. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ne iruti qué ziuu ra runi mandar Dios pa qué guni cre Dios casi runi cre ti ba'du'. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Oraque ucuaa be ca ba'du que, uluu be laaca ndaani ná be ne udixhe ná be luguiá ca', uluu be ndaaya laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ma chi iree Jesús che sti guidxi ora zeda uxooñe ti hombre ne bizuxibi xañee be na rabi laabe: ―Maistru cha'hui', xi naquiiñe gune para gapa enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Para rabi be laa: ―Xiñee ra'bu naa maistru cha'hui'. Iruti ru nacha'hui jma que tobi lucha Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ma nannu xi na ca mandamientu: “Cadi chu' neu ni cadi xheelu', cadi guuti lu binni, cadi cuana lu', cadi cueeu falsu luguiá stobi, cadi usiguii lu', gunaxhii bixho'zo ne jñoou'.” ");
INSERT INTO zaiNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Para na hombre que: ―Irá nga huayune dede dxi nahuiine, Maistru. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Biiya dxí Jesús laabe ne gunaxhii laabe ne rabi laabe: ―Tobi si riaadxa lii. Guyé bitoo irá ni napu', bidii ca pobre, ne zapu stale ni risaca ibá'. Ne ma cadi lica guiá lu xpida lu', ne dananda naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Peru ora bina diaga be xi na Jesús la? ucaná ladxidó' be purti nabé napa be bidxichi, ne triste biree be ze be. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Oraque biiya dxí Jesús irá ladu ne na rabi ca discípulu: ―Aque nagana raca para ca ricu udii ca lugar guni mandar Dios laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Bidxagayaa ca discípulu ni uní' be que. Peru bigueta rabi be laaca': ―Xiiñe ca', aque nagana na tobi ni nadxii bidxichi guni mandar Dios laa xa. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jma qué igana tidi ti camellu xa'na ti aguxa' para gudii ti ricu lugar guni mandar Dios laa. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jma rusi bidxagayaa ca discípulu óraque, ne unaba diidxa saa ca': ―Tu zanda ilá pue. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Para biiya dxí be laaca' ne rabi be laaca': ―Binni la? qué zanda guni ni peru Dios zanda, purti gasti ni nagana para Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Oraque bizulú Pedru na rabi laabe: ―Laadu ya', bisaana du irá ni napa du ne canananda du lii. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Para na be: ―Ma nanna'. Ne tutiica usaana lidxi o bi'chi o biza'na o bixhoze o jñaa o xheela o xiiñi o layú sti pur naa ne pur stiidxa Dios la? ");
INSERT INTO zaiNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","zacaa ti gayuaa tantu de ni bisaana que: yoo, bi'chi', biza'na', jñaa, xiiñi' ne layú, neca zadi'di stale ni nagana. Ne dxi usulú guidxilayú cubi la? zapa ti enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Peru stale de cani za niru ziaana atrá, ne stale de cani za atrá zazá niru. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ti dxi ze Jesús Jerusalén, laa ne cani rizá né laa. Peru za niru be lú ca'. Bidxagayaa ca discípulu ze be Jerusalén, ne zaqueca nanda xcaadxi binni atrá, zeda dxibi ca'. Oraque guridxi be idubi doce discípulu stibe que ti ladu, ne bizulú byui' né be laaca xi chi aca be. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Rabi be laaca': ―Laguuya mayaca guiu' nu Jerusalén, ne ma chi naaze cabe naa. Naa nga Hombre Biseenda Dios. Zutoo cabe naa lu xaíque sti ca sacerdote ne ca maistru de ley, ne zaguixhe ca gate' ne zutiidi ca naa lu ná cani cadi judíu, ");
INSERT INTO zaiNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ne zuni burla ca ngue naa. Zuniná ca naa ne zuchá xhinni ca lade' ne zuuti ca naa. Peru lu chonna gubidxa de biiti cabe naa zabane'. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Oraque bidxiña Jacobo ne Juan xiiñi Zebedeu ra nuu Jesús ne na ca rabi ca laabe: ―Maistru, rinaba du gu'nu ni chi naba du lii ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Para rabi be laaca': ―Xi racala'dxi tu gune para laatu ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Oraque rabi ca laabe: ―Ora ma zuba lu de rey ne ma cayuni mandar lu irá la? udiiu lugar cui du cue' lu', tobi ladu derechu, stobi ladu biga'. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Para rabi be laaca': ―Nin qué ganna tu xi canaba tu. Ñee zanda gacaná tu casi chi gacana'ya', ne tidi tu ni chi tide ri la? ");
INSERT INTO zaiNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Para na ca': ―Zanda. Oraque rabi be laaca': ―Dxandí zacaná tu ne zadi'di tu casi ni chi tide ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","peru para cui tu cuee', ladu derechu ne ladu biga la? cadi nexhe di nga ladxi naya para gudiee tuuxa, sínuque maca nexhe tuu nga icaa ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ora bina diaga xhii discípulu que xi na cabe la? bidxiichi né ca laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Peru guridxi Jesús irá cabe ne rabi laacabe: ―Laatu nanna tu ximodo runi cani runi mandar ndaani guidxilayú, runi stica irá binni ni runi mandar ca'. Ne cani risaca lade cabe la? laca racala'dxi ca guni mandar ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Peru laatu, cadi guni tu zacá lade tu, sínuque tu gacala'dxi isaca jma la? napa xidé gaca casi jmozo ca xcaadxi. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ne zaqueca guni tutiica gacala'dxi sa niru, ");
INSERT INTO zaiNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","casi huayune lade tu. Naa nga Hombre Biseenda Dios ne benda cadi para gacané cabe naa sínuque para gacaniá laacabe ne para gudiee xpida ti ganda ilá stale binni. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Oraque yendá cabe ndaani guidxi Jericó ne ra biree Jesús de ndaani guidxi que biree né ca discípulu sti', ne nanda stale binni laaca'. Ne uriá neza ra zidi'di cabe que zuba ti hombre nacheepa lú, lá Bartimeu, xiiñi Timeu, canaba guna. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ne ora bina diaga be Jesús de Nazaret ngue zidi'di raqué la? bizulú be bicaa be ridxi: ―¡Jesús, Xiiñi David, biá la' naa! ");
INSERT INTO zaiNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Stale binni udinde né laabe para nigani be, peru laga jma rusi bicaa be ridxi: ―¡Biá naa, Xiiñi David! ");
INSERT INTO zaiNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Oraque bizuhuaa dxí Jesús ne na: ―Lacuidxi laabe. Para uyé tobi na rabi laabe: ―Cadi idxibi lu', bizuhuaa, cabidxi be lii. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Oraque bilaa be xhaba be layú ne biasa guxooñe be bidxiña be ra nuu Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Para na Jesús rabi laabe: ―Xi racala'dxu gune para lii. Para na be: ―Maistru, racaladxe inaya'. ");
INSERT INTO zaiNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Oraque na Jesús rabi laabe: ―Ma zanda che lu'. Ma bianda lu' purti bini cre lu'. Ne oraqueca ma gunda uná be, ne yenanda be Jesús neza ze'. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ora bidxiña cabe gaxha de Jerusalén zidi'di cabe Betfagé ne Betania. Nuu cabe nezalú dani Olivo, biseenda Jesús chupa de ca discípulu sti', ");
INSERT INTO zaiNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","na rabi laaca': ―Laché guidxi huiini ni nuu gaxha ca, ne ora chindá tu raqué la? zadxela tu ti burru huiini cá yaga ne iruti huagui'ba laame. Lauxhegue laame ne latané laame rarí'. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ne pa chu' tu inaba diidxa laatu xiñee cuxhegue tu laame la? lagabi laaca caquiiñe Señor laame. Ne casi iluxe me maca chi saana tu laame. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Biree ca discípulu que ze ca', ne bidxela ca burru huiini que cá yaga ra puerta uriá neza, ne bixhegue ca laame. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Peru óraque na caadxi de cani nuu raqué rabi laacabe: ―Xi cayuni tu. Xiñee cuxhegue tu burru huiini ca. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Para gudxi cabe laaca ni gudxi Jesús laacabe que. Ne ma qué niní' ru ca gasti'. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Oraque yené cabe burru huiini que ra nuu Jesús ne gudixhe cabe xhaba cabe deche me para gudxi'ba Jesús laame. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ne stale binni bichiaa xhaba lu neza ra zidi'di Jesús, ne nuu tu bichuugu rama ne udixhe ni lu neza ra zidi'di be. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ne cásica cucaa ca binni ni za niru ridxi la? zaqueca cucaa cani nanda atrá que ridxi, na ca': ―¡Viva! Lausisaca ni biseenda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Lausisaca ni zeda guni mandar casi bini mandar rey David, bixhoze gola canu. Lausisaca Dios ni dxi'ba ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ora yendá Jesús ndaani guidxi Jerusalén, biuu ndaani yu'du ro'. Biiya dxí irá ladu raqué, ne óraque biree ze Betania, laa ne ca discípulu sti', purti ma huadxí ngue. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sti dxi que ora biree cabe de Betania ma candaana Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ne óraque biiya be zuhuaa ti yaga du'ga' zitu huiini de raqué, naze bandaga lú, para yeguuya be pa cá du'ga lú ni. Peru cadi cá di du'ga', puru si bandaga napa ni purti cadi xhi ni ngue. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Para uní' né be du'ga que rabi be laa: ―Qué ziuu dxi ru go tuuxa cuananaxhi stiu'. Ne bina diaga ca discípulu ni uní' be que. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Oraque yendá cabe Jerusalén. Ne casi biuu Jesús ndaani yu'du ro' bizulú uladxi cani cutoo raqué ne cani cazí', ne bitiixhi jmexa cani cuchaa bidxichi, ne xpangu cani cutoo paloma. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ne qué nudii be lugar nidi'di né ca xiixa ndaani yu'du que. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ne bisiidi be laaca na be rabi be laaca': ―Lu Xqui'chi Dios cá: “Lidxe nuu para iní' né irá binni naa ndaani'”; peru laatu ma bi'ni tu ni lidxi gubaana'. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ora bina diaga ca xaíque sti ca sacerdote ne ca maistru de ley ni uní' be que la? bizulú ca biyubi ca modo gati be. Cadxibi ca laabe purti cadxagayaa irá binni ni cusiidi be. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Peru casi bixhinni biree be ndaani guidxi que. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sti dxi que siadó' ro' udi'di cabe ra nuu dxa yaga du'ga que ne ma bibidxi dede xcu ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ne óraque bietenala'dxi Pedru, para na rabi laabe: ―Maistru, biaa gu'yu ma bibidxi dxa yaga du'ga ni nou' ma cadi icá ru du'ga lú que. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Para na be rabi be laaca': ―Lagapa fe ne Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Purti gabe ca' laatu, tutiica gabi dani ri iree de ra nuu, chi guiaba ndaani nisadó', ne qué gapa duda ndaani ladxidó', sínuque guni cre zaca ni ma uní' que la? zaca ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nga runi cayabe laatu, irá ni inaba tu ora iní' né tu Dios zacaa tu, peru pa guni cre tu zaca ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ne ora caní' né tu Dios, pa guietenala'dxi tu nuu tu bichee né laatu la? laguni perdonar laa, ti guni perdonar Bixhoze tu ni nuu ibá' laatu ni huachee né tu laa. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Purti pa qué guni perdonar tu stobi la? nin Bixhoze tu ni nuu ibá' qué zuni perdonar laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Oraque yendá cabe Jerusalén, biuu Jesús ndaani yu'du ro', ne raqué canazá be beeda ca xaíque sti ca sacerdote ne ca maistru de ley ne ca xaíque sti guidxi ra nuu be ");
INSERT INTO zaiNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ne rabi ca laabe: ―Tu naca lu para cayu'nu irá ni cayu'nu ri' o tu gudxi lii gu'nu cani. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Para rabi be laaca': ―Naa laca napa tobi ni inaba diidxa laatu ne pa gabi tu ni naa la? óraque zabe laatu tu naca' para cayune cani cayune ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Lagabi naa, tu biseenda Juan beda nduu nisa, Dios la? o binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Oraque bizulú ucuaa yu né cabe ni lade cabe, na cabe: ―Xi gabi nu laabe. Pa iní nu Dios biseenda Juan la? zabi be laanu xiñee qué ñuni cre nu. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","O zabi nu laabe binni guidxilayú biseenda Juan la? Peru nin ngue qué na cabe iní' cabe purti nanna cabe napa ca binni que Juan de profeta sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ni bi'ni ti cabe la? rabi cabe Jesús: ―Qué ganna du. Para na Jesús rabi laacabe: ―Nin naa qué zabe laatu tu gudxi naa gune ni cayune ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Oraque bizulú Jesús byui' né laacabe diidxa peru puru ne ejemplu, na rabi laacabe: ―Guyuu ti hombre bizuhuaa stale yaga uvas lu layú sti' ne guluu le' ni ne bi'ni ti pila para ixii uvas que ndaani'. Ne laca bicuí be ti torre ra guiaana ni gapa layú que. Biluxe bi'ni si be ni, bisaana né be ni caadxi hombre gapa ni, ne biree be ze be zitu. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ne dxi ma gunda dxi iruugu uvas que la? biseenda be ti jmozo be ra nuu ca hombre ni cayapa jlayú be que para chi caa ni raca caber laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Peru casi bi'ya ca hombre que jmozo be la? ucuaa ca laa udiñe ca' ne biseenda ca laa nisi ná'. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Bigueta biseenda be sti mozo stibe, ne ngue ma ucuaa ca hombre que laa bichá ca guie laa ne undaa ca ique ne uluu dí ca laa. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bigueta biseenda ru be stobi ne ngue ma biiti cabe laa. Bigueta biseenda be xcaadxi, peru udiñe ca hombre que caadxi ne biiti ca xcaadxi. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","De raqué ma xiiñi si be biaana, ne nabé nadxii be laa. Peru últimu na be: “Chi useenda xiiñe ri', zanda ca gapa xpia' cabe ne laa.” ");
INSERT INTO zaiNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Peru ora bi'ya cani cayapa layú stibe que xiiñi be la? na ca': “Ndi nga ni guiaana né irá ni. Laguuti laa ti guiaana né nu ni laanu.” ");
INSERT INTO zaiNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Oraque ucuaa ca hombre que xiiñi be que biiti ca' ne ulee ca laa de ndaani ñaa que, yesa'bi ca laa. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yanna ya', xi na tu guni xpixuaana layú que. Zeeda ne zunitilú ca hombre que ne zudii layú que adxé binni. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ñee cadi ma biinda tu lu Xqui'chi Dios ra cá ca diidxa ri la? Guie ni bisa'bi cani cucuí yoo que, guie que pe naaze yoo que yanna. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dios bi'ni ni, ne para laanu ma enda ridxagayaa ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Oraque ucala'dxi cabe ninaaze cabe Jesús purti nanna cabe gudixhe ejemplu que para laacabe. Peru qué ñuni cabe ni purti ridxibi cabe ca binni que. Para biree cabe ze cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ratu si que la? biseenda cabe caadxi fariseu ne caadxi xpinni Herodes para inaaze ca laabe ra iní' be xiixa. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Para beeda ca ngue ra nuu be ne na ca': ―Maistru, nanna du riní' lu ni dxandí' ne qué rulabi lu ni iní' binni purti qué ruuya lu xi naca binni, sínuque jneza rusiidi lu neza sti Dios. Ñee jneza quixe cabe impuestu lu ná rey César la? o co'. Zaguixe nu la? o qué zaguixe nu. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Peru maca nanna be cuyubi si ca gusaba ca laabe. Para rabi be laaca': ―Xiñee racala'dxi tu usaba tu naa ndaani trampa stitu. Latané ti moneda ca naa guuya'. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Oraque bedané ca ni ra nuu be ne ora bi'ya be ni la? rabi be laaca': ―Tu cá lú ni. Para na ca': ―César. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Oraque rabi be laaca': ―Laudii César sti César, ne laudii Dios sti Dios. Bidxagayaa ca modo bicabi be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Oraque beeda caadxi saduceu ra nuu Jesús. (Ca saduceu qué runi cre ca pa ribani gue'tu'.) Ne na ca rabi ca laabe: ");
INSERT INTO zaiNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maistru, bicaa Moisés lu gui'chi': “Pa chu' ti hombre ichaganá' ne gueda gati qué ñapa xiiñi la? naquiiñe ichaganá bi'chi be xheela be, ne gapa xiiñi casi ñaca xiiñi be.” ");
INSERT INTO zaiNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Guyuu gadxe bi'chi'. Bichaganá lugola que ne guti, qué ñapa xiiñi'. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Oraque bichaganá rairopa que xheela ni guti que, ne laca guti ngue ne qué ñapa xiiñi'. Ne zaqueca bizaaca raguionna que. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ne idubi gadxe cabe bichaganá cabe gunaa que ne guti cabe, peru nin tobi cabe qué ñapa cabe xiiñi cabe. Ne óraque guti gunaa que. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Yanna, dxi ibani gue'tu ya', uná de laacabe xheela gunaa que, purti idubi gadxe cabe bichaganá cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Oraque na Jesús rabi laacabe: ―Cuchee tu, ne cayuni tu zacá purti qué runibiá' tu Xqui'chi Dios ne qué runibiá' tu enda nandxó' stibe. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Purti dxi ibani binni sti tiru la? nin hombre nin gunaa qué zachaganá', sínuque zaca cabe casi ca ángel ni nuu ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ne de enda ribani gue'tu la? ñee qué huayuunda tu gui'chi ni bicaa Moisés, modo uní' né Dios laa de lu ti yaga caya'qui la? Na Dios rabi laabe: “Naa nga Dios sti Abraham ne sti Isaac ne sti Jacob.” Ne dxi uní' Dios nga la? ma guti cabe para binni, peru para Dios nabani ru cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Purti Dios cadi Dios sti cani ma guti laa, sínuque Dios sti cani nabani ne zacá rihuinni dxichi ca cuchee tu. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Guyuu diaga tobi de ca maistru de ley modo byui' né be ca saduceu diidxa ne nanna jneza bicabi be. Para beeda ra nuu be ne gunaba diidxa laabe: ―Uná nga mandamientu ni jma risaca. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Para rabi be laa: ―Ndi nga mandamientu ni jma risaca lade irá', ne sicarí nga gudxi Moisés ni ca binni Israel chiqué: “Binni Israel ca', laucaa diaga, Señor Dios si stinu nga tobi lucha Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nga runi gunaxhii Dios stiu' de idubi ladxidó' lo' ne de idubi xhialma lu' ne de idubi xquenda biaani lu' ne de irá stipa stiu'.” Nga nga mandamientu ni jma risaca. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ne rairopa ri zeda gaca casi laani: “Gunaxhii stobi cásica nadxii lu lii.” Gasti ru mandamientu jma risaca que iropa mandamientu ca. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Oraque na maistru de ley que rabi Jesús: ―Maistru, jneza uní' lu'. Ti Dios si nuu ne gasti ru stobi jma que laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ne de enda ranaxhii Dios de idubi ladxidó' ne idubi xquenda biaani ne de idubi xhialma ne de irá stipa sti', ne ganaxhii stobi cásica nadxii laa la? nga nga ni jma risaca que irá mani ni ruuti cabe ne ruzaaqui cabe para Dios ne irá ofrenda ni rudii cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ne ora bi'ya Jesús jneza bicabi be laa la? na rabi laabe: ―Ma nuu lu gaxha para udiiu lugar guni mandar Dios ndaani ladxidó' lo'. Ne dede dxi que de irá bidxibi ninaba diidxa ru Jesús xiixa. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ra cusiidi Jesús ndaani yu'du ro' na: ―Ximodo na ca maistru de ley xiiñi David Cristu ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Purti dede David dxi bisiní' Espíritu Santu laa, na: Na Dios rabi Señor stinne' “Gurí cuee dede ora ma gudixhe dxie cani nanala'dxi lii xañee lu'.” ");
INSERT INTO zaiNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yanna ximodo zanda aca Cristu xiiñi David pa dede David rabi laa Señor sti ya'. Ne nabé bicaa diaga irá binni que Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Lu ra cusiidi Jesús que na: ―Laguuya gá laatu ne ca maistru de ley purti riula'dxi ca acu ca lari de yanni ñee ca' ne chu' tu ugapa diuxi laaca lu calle. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ne ora che ca ndaani yu'du', ruyubi ca banca ni jma galán cui ca', ne zaqueca ra chitó ca', riula'dxi ca cui ca lugar ni nuu para ca binni risaca. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Raxha ca lidxi cani ma guti xheela' ne óraque para cadi uluí' pa laaca bi'ni ca ni, riní' né ca Dios xadxí. Nabé naná zusaba ná Dios laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ti tiru zuba Jesús ndaani yu'du ro', gaxha de ra nuu caja ra rusaba cabe vueltu. Cayuuya modo cusaba irá binni vueltu ndaani caja que ne pabiá' stale bidxichi cusaba ca ricu. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ne óraque biuu ti gunaa pobre, ma guti xheela', ne bisaba chupa de gaayu huiini ndaani caja que. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Oraque guridxi Jesús ca discípulu sti' ne na rabi laaca': ―Jma stale bidii viuda ri' que irá ni caguu bidxichi ndaani caja ca. ");
INSERT INTO zaiNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Purti ca xcaadxi ca la? cudii ni riaana lu stica'. Peru laabe, bidii be de irá ni napa be para tidi né be dxi. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ora ziree Jesús ndaani yu'du ro' na tobi de ca discípulu sti rabi laa: ―Maistru, biiya pabiá' ca guie ca ne pabiá' ca yoo ca. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Peru na Jesús rabi laabe: ―Ruuyu ca yoo ro' ca la? nin ti guie qué ziaana luguiá sti guie rarí'. Irá ni zaxá. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ne uyé cabe lu dani Olivo ni nuu ladu nudxii lú yu'du ro' que. Raqué zuba be bidxiña Pedru, Jacobo, Juan ne Andrés ra nuu be, laasi ca' ne laabe, na ca rabi ca laabe: ");
INSERT INTO zaiNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Racala'dxi du ga'bu laadu padxí aca irá nga ni bizeete lu que, o xi seña udiiu laadu para ganna du ma chi aca irá cani. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Para rabi be laaca': ―Laguuya gá cadi chu' tu usiguii laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Purti zeeda stale ni usiguii, zaná ca laaca nga Cristu. Ne zabee chu ca stale binni. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ora guna diaga tu uzeete cabe cayaca guerra o nabé naxoo nuu guerra la? cadi idxibi tu, purti napa ni xidé aca ni zacá peru cadi ma chi iluxe di ni ngue. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Purti zucaa lú ti guidxi sti guidxi ne ti gobiernu sti gobiernu, ne zaca xu stale lugar ne zaca gubiña ne bulla, ne ora aca irá nga la? deru cuzulú yuuba que nga. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Peru lagapa laatu, purti ziné cabe laatu ra nuu ca justicia stícabe ni nuu ndaani yu'du', ne zaguiñe cabe laatu raqué. Ne pur naa napa tu xidé uzuhuaa tu nezalú gobernador ne rey ne zacá zanda güi né tu laaca stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Purti napa xidé ireeche stiidxa Dios irá guidxi ante initilú guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ne ora chiné cabe laatu ra nuu justicia la? cadi chu' tu xizaa ne cadi indaa ique né tu xi iní' tu, purti cadi laadi tu nga chi iní' tu sínuque Espíritu Santu. Lainí' ni gabi Espíritu Santu laatu óraque. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ziuu tu guluí' laca bi'chi para gati', ne ziuu tu guluí' xiiñi para gati', ne ziuu tu ucaa lú bixhoze ne jñaa ne zudii laacabe para gati cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Irá binni zaca nanala'dxi laatu ti xpinne laatu; peru tu qué ixhacala'dxi dede dxi iluxe irá ni la? zalá. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Chiqué bicaa profeta Daniel de dxa ni runi yuudxu ne ni runitilú que. Ora gu'ya tu chu' ngue ra cadi nexhe chu' la? óraque naquiiñe iree cani nuu Judea, uxooñe ca', quiba ca lu dani. (Tu guunda ndi la? guiene.) ");
INSERT INTO zaiNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pa nuu tuuxa dxi'ba ique yoo dxi aca ni que la? cadi guiete chu' ndaani yoo chi caa xiixa, ");
INSERT INTO zaiNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ne pa nuu tuuxa rañaa la? cadi ibigueta yoo para chi topa xhaba. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pobre de ca gunaa ni naca xiiñi ne ni napa ba'du cayadxi ca dxi que. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lainaba lu Dios, cadi gaca ni ca dxi nananda ti qué gapa tu xidé uxooñe tu lu nanda. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Purti nabé naná zaca ni ca dxi que. Qué huayuu dxi aca ni naná bia' qué, dede dxi bizá' Dios guidxilayú, ne ma qué ziuu ru dxi aca ni sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Pa qué nucueeza Dios lu ni la? iruti nilá, peru zucueeza be lú ni pur ca xpinni be, cani gulí be. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Pa chu' tu gabi laatu ca dxi que: “Laguuya', rarí nuu Cristu” o “Rarica nuu be” la? cadi guni cre tu laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Purti zeeda stale tu na Cristu laa peru cadi dxandí', ne stale tu na profeta laa, peru cadi dxandí'. Ne zuni ca seña ne milagru para quite ca binni ne pa ñanda si dede ne cani ma ulí Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Peru laatu, lagataná purti maca gudxe ni laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Peru tidi si ca dxi de enda naná que la? zacahui lú gubidxa ne qué zuzaani beeu. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ne ziaba ca luceru de ibá', ne zaniibi dxacha irá ni nuu ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Oraque zuuya cabe Hombre Biseenda Dios zeeda lade za ne stale poder ne enda nandxó'. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ne zuseenda ca ángel sti para utopa ca xpinni ni nuu idubi naca guidxilayú, cásica cani nuu gaxha zaqueca cani nuu zitu. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Laucaa diaga ejemplu sti du'ga ri': ora ihuinni rama ri'ni', ne ma cabee ni bandaga la? ma nanna cabe ma zeeda tiempu nandá'. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Zacaca nga ora gu'ya tu aca irá ni gudxe laatu ca la? ganna tu ma zeda dxiña dxi que, ma nuu ni gaxha. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Gabe ca' laatu, zaca irá nga ante gati ca binni nuu yanna ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ziuu dxi initilú ibá' ne guidxilayú peru stiidxa qué ziaana sin gaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Peru padxí ne pora la? iruti ganna, nin ca ángel ni nuu ibá', dede nin naa qué ganna', sínuque Bixhoze sia' nga nanna. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nga runi lachuu listu ne lagataná. Lainí' né Dios purti qué ganna tu padxí ganda ora guenda'. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Zeda aca ni casi ti hombre ni che viaje zitu. Ante iree be de ralidxi be la? rusaana be xhiiña be lu ná ca jmozo be, rabi be cada tobi xi guni, ne rabi be ni rapa raqué gataná, cadi guedandá be laa nisiaasi'. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nga ca laatu, lagataná purti qué ganna tu pora guenda', pa casi guiaazi gubidxa o galaa gueela o telayú o siadó'. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Cadi mala guedandaya laatu nisiaasi tu. ");
INSERT INTO zaiNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ni cayabe laatu ri la? cayabe irá binni: chu' listu. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ma xhupa si gubidxa cayaadxa para ganda laní pascua, ne saa ra ro cabe pan sin levadura. Ne ma cuyubi si ca xaíque sti ca sacerdote ne ca maistru de ley quixhe ca trampa Jesús para inaaze ca laabe ne guuti ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Peru na ca pa ganda cadi gaca ni ndaani pe saa que, ti cadi cui zisi binni. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nuu Jesús Betania ralidxi Simón ni gupa lepra que. Ne laga zuba be ruaa mexa', beeda ti gunaa bedané ti frascu dxa de aceite rindá' naxhi ni nabé risaca. Ne gundaa frascu que bichá aceite que ique be. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ne bidxiichi caadxi de cani nuu raqué ne uní' saa ca', na ca': ―Xiñee biniti si aceite rindá' naxhi ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Purti ñanda nidoo ni chonna gayuaa denariu para ñaazi lú ca pobre. Para gudinde né cabe gunaa que. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Peru na Jesús rabi laacabe: ―Zaa nuu be. Xiñee cuchiiña tu laabe. Jneza ni bi'ni be ri para naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ca pobre la? qué ziuu dxi guiaadxa ca lade tu, ne ora tiica gapa tu gana zanda acané tu laaca', peru naa la? zadxiña dxi ma qué ziuaa nia laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ne laabe ma bi'ni be biá' gunda. Neca ca'ru ganda ora igaache', ma bichá be aceite rindá' naxhi ri lade'. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Gabe ca' laatu, ratiica güi cabe stiidxa Dios ndaani idubi naca guidxilayú ri', zuzeete cabe ni bi'ni be, ti cadi guiaanda be. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Oraque uyé Judas Iscariote, tobi de lade doce discípulu stibe que, ra nuu ca xaíque sti ca sacerdote, yeutoo Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ne ora bina diaga cabe xi na Judas la? bieche cabe ne bidii stiidxa cabe laa icaa bidxichi. Ne dede dxi que, ma cuyubi si Judas ximodo ganda uluí' laacabe Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ne primé ca dxi bizulú saa ra ro cabe pan sin levadura, dxi ruuti cabe dendxu para pascua que, na ca discípulu rabi laabe: ―Paraa racala'dxu chi guni chaahui du para go xhi lu pascua ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Para na be rabi be chupa de ca discípulu que: ―Laché ndaani guidxi. Raqué zadxaaga tu tobi hombre ziné ti rii nisa, ne lachinanda laa. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Laguiuu ra guiuu be, lagabi xpixuaana yoo que: “Na Maistru uná nga cuartu ra go xhi né ca discípulu pascua ri'.” ");
INSERT INTO zaiNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ne zuluí' be laatu ti cuartu xilaga ni nuu luguiá' ne maca nuu ni listu. Raqué laguni chaahui para laanu. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Para biree ca discípulu que ze', ne yendá ca ndaani guidxi, ne casi gudxi Jesús laaca que, zaqué biree ni. Bidxela ca ni, ne gudixhe chaahui ca endaró xhi para pascua que. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ne huaxhinni que la? bedané be ca discípulu stibe. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Gurí cabe ruaa mexa' ne bizulú cayó cabe. Para rabi be laaca': ―Gabe ca' laatu, tobi de laatu ni cayó né naa rarí', zutoo naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Oraque ucaná ladxidó' cabe ne cada tobi na rabi laabe: ―Ñee naa la? Ne stobi na: ―O naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Para rabi be laaca': ―Laabe nga tobi de lade cani cugadxe né naa pan ndaani bladu ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Naa nga Hombre Biseenda Dios, ne napa xidé gate' casi cá lu Xqui'chi Dios de naa. Peru gapa gá si ni utoo naa que laa. Jma galán ñaca para laa pa qué ñale. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ne ra cayó cabe que, gucuaa Jesús ti pan, guluu ndaaya ni, para gundaa ni ne bidii ni laacabe. Ne na rabi laacabe: ―Laicaa. Ndi nga cuerpu stinne'. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Oraque ucuaa be ti copa, ne bidii be diuxquixe Dios, para bitiidi be ni lu ná cabe ne irá cabe güe' cabe ruaa copa que. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ne laca gudxi be laaca': ―Ndi nga rini stinne ni chi ixii pur stale binni, ne ra ixii ni zaguixhe Bixhoze ti modo cubi chu' né binni laa tobi si. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ne gabe ca' laatu, ma qué zee rua' nisa uvas dede ora ganda dxi guee ni sti tiru ra runi mandar Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Biluxe biinda si cabe ti cantu, para biree cabe ze cabe lu dani Olivo. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Oraque na Jesús rabi laacabe: ―Pur irá ni chi gaca yanna gueela la? zusaana tu naa. Purti sicarí cá lu Xqui'chi Dios: “Zunena'ya pastor sti ca dendxu' ne zareche ndase ca'.” ");
INSERT INTO zaiNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Peru dxi guiasa de lade gue'tu la? ziaa Galilea ne raqué cueza laatu. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Oraque na Pedru: ―Neca irá cabe usaana cabe lii peru naa qué zusaana dia' lii. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Para na Jesús rabi laabe: ―Gabe ca' lii, yanna gueela ca, ante gu'nda gallu chupa tiru la? chonna tiru zaníu' qué runibióu' naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peru qué ñaana dxi be na be: ―Neca napa xidé gate nia lii peru qué ziuu dxi inié qué runebia'ya lii. Ngue ca na irá cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yendá Jesús ne ca discípulu sti' ti lugar lá Getsemaní. Para rabi be ca discípulu que: ―Lacuí rarí', laga chi inié nia Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Para ucuaa be Pedru ne Jacobo ne Juan, bixele né be laaca ti ladu, ne bizulú uyuu be triste ne ucaná ladxidó' be. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Para rabi be laaca': ―Nabé cayacaná ladxiduá' ne enda naná para guuti. Laguiaana rarí' ne lagataná. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ne bixele be zitu huiini de laaca ne bizuxibi be layú, gunaba be lu Dios pa ganda cadi tidi be enda naná ni chi tidi be que. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ne ra caní' né be Dios que na be: ―Bixhoze', para lii gasti ni nagana, bilá naa de enda naná ri', peru cadi aca ni rabe', sínuque ni na lu' nga gaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Oraque uyé be ra nuu ca discípulu. Yendá be laaca nisiaasi ca', para rabi be Pedru: ―Simón, nisiaasi lu la? Ñee qué ñanda ñataná lu neca ti hora la? ");
INSERT INTO zaiNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Lagataná ne lainí' né Dios ti cadi uquiinde binidxaba laatu. Neca ndaani ladxidó' to racala'dxi tu guni tu jneza, peru cuerpu stitu, nagueenda riguudxi. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Bigueta yení' né be Dios sti tiru, ne laca ngue ca uní' be. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ne bigueta be ra nuu ca discípulu ne laca bedandá be laaca nisiaasi ca', purti nabé nuu bacaanda lú ca'. Ne qué idxela ca xi gabi ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bigueta be raguionna tiru de yení' né be Dios ne rabi be laaca': ―Yanna huaxa lagasi ne laiziila'dxi, ma bia'cati, purti naa nga Hombre Biseenda Dios ne ma bidxiña hora utoo cabe naa lu ca binni malu. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Laguiasa, chuu nu. Ma zeda dxiña ni chi uluí' naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Caní' ru be ora bedandá Judas, tobi de lade doce discípulu stibe que, bedané stale binni ni biseenda ca xaíque sti ca sacerdote ne ca maistru de ley ne ca xaíque sti guidxi, naaze ca espada ne palu. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ne maca bidii Judas ti seña laacabe, na rabi laacabe: ―Ni gahua ti bixidu lucuá la? ngue nga laabe. Lainaaze laabe ne lachiné laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ne casi yendá Judas ra nuu be bidxiña laabe ne rabi laabe: ―Maistru. Ne gudó ti bixidu lucuá be. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Oraque uluu ná cabe laabe para chiné cabe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Peru óraque guxha tobi de cani nuu né laabe raqué espada, ne bigá ti chu diaga ti jmozo sacerdote gola. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Oraque rabi be ca xcaadxi que: ―Ñee gubaana zeda naaze tu la? Né pe tu espada ne palu. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Irá ca dxi uyuaa lade tu ndaani yu'du ro', qué ñuni tu pur ninaaze tu naa. Peru cayaca ni sicarí ti iree ni modo cá lu Xqui'chi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ne óraque bixooñe irá discípulu que, bisaana ca laabe stubi be. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Peru yenanda ti hombre huiini laabe, renda ti lari gueela si, ne gunaaze ca binni que laa. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Peru óraque bixooñe xie ladi, bisaana lari que. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yené cabe Jesús ra nuu sacerdote gola ne bidxiña irá ca xaíque sti ca sacerdote ne ca xaíque sti guidxi ne ca maistru de ley raqué. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ne yenanda Pedru laabe zitu zitu dede lu patiu sti sacerdote gola ne gurí ra nuu ca gendarme cadxaa cue' gui. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ne cuyubi ca xaíque sti ca sacerdote ne irá ni naca justicia sti ca judíu tuuxa iní' paraa pe bichee Jesús ti gapa ca xi pur gati be. Peru qué nidxela ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nuu stale ni cabee falsu luguiá be, peru adxé adxé ni na ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Oraque biasa xcaadxi na: ");
INSERT INTO zaiNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Laadu bina diaga du uní' be zuxhá be yu'du ro' ni bicuí binni, ne lu chonna gubidxa zucuí be stobi peru ma cadi binni ucuí ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Peru nin ne zaqué qué ñanda ñuu cabe tobi si de ni caní' cabe que. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Oraque bizuhuaa sacerdote gola lade cabe ne na rabi Jesús: ―Qué gapu xiixa iníu' la? Xi ra'bu de ni cugaani cabe luguiá lu ri ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Peru qué niní' Jesús gasti'. Bigueta na sacerdote gola que rabi laabe: ―Ñee lii nga Cristu Xiiñi Dios la? ");
INSERT INTO zaiNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Para rabi be laa: ―Naa pue. Ne zuuya tu Hombre Biseenda Dios zuba cue' Dios ni nandxó', ne zuuya tu laa zeda yete de xaibá' lade za. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Oraque gucheza sacerdote gola que xhaba ne na: ―Xi jma ru caquiiñe ganna nu, ");
INSERT INTO zaiNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","purti ma bina diaga nu ni de ruaa pe be. Yanna ya', xi na tu. Para na irá cabe napa be xidé gati be. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ne bizulú caadxi de laaca bichá xhinni ca ladi be. Biseegu ca lú be ne gudiñe ca laabe ne na ca iní' be tu bi'ni ni, ne laca udapa ca gendarme que laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nuu Pedru ndaani patiu que ora beeda ti criada sti sacerdote gola, ");
INSERT INTO zaiNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ne ora bi'ya zuba be cue' gui que cadxaa be la? biiya dxí laabe ne rabi laabe: ―Lii laca uzá neu Jesús de Nazaret. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peru qué niná niní' pa xpinni be laa, sínuque na rabi badu dxaapa que: ―Nin qué runebia'ya laabe ne qué ganna xii nga nou'. Ne biree yeuzuhuaa ra puerta'. Oraque biinda gallu. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Bigueta biiya dxí criada que laabe sti tiru ne na rabi cani nuu raqué: ―Hombre ri', laca tobi de laacabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Peru laca bini negar Pedru sti tiru. Ne qué nindaa de ngue na cani zuba raqué rabi laabe: ―Dxandí laca de laacabe lii purti binni Galilea lii ne riníu' modo riní' cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Oraque bizulú Pedru bini jurar ne na: ―Gunidé Dios naa pa cusiguiee'. Qué runebia'ya dia' hombre ni na tu ca. ");
INSERT INTO zaiNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ne óraque biinda gallu rairopa tiru ne bietenala'dxi be ca diidxa ni gudxi Jesús laabe que: ante gu'nda gallu chupa tiru, zaní' be chonna tiru qué runibiá' be laa. Ne ora bedasilú nga laabe la? biina be. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ora birá gueela bidxiña ca xaíque sti ca sacerdote ne ca xaíque sti guidxi ne ca maistru de ley ne irá ni naca justicia sti ca judíu, ne gupa ca ti junta. Ne biluxe si junta que, ucuaa ca Jesús bindiibi ca ne yesaana ca laabe ra nuu Pilatu. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Para na Pilatu rabi laabe: ―Ñee lii nga rey sti ca judíu la? Para rabi be laa: ―Lii caníu' ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ne óraque guluu ca xaíque sti ca sacerdote xqueja be de irá modo. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bigueta unaba diidxa Pilatu laabe sti tiru, na rabi laabe: ―Ñee qué zaníu' gasti de irá ni cugaani cabe luguiá lu ri la? ");
INSERT INTO zaiNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Peru nin ti diidxa qué niní' be ne nabé bidxagayaa Pilatu. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cada iza saa que rundaa Pilatu ti presu para ca binni que, tutiica inaba ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ne yeguyoo ti hombre ca dxi que lá Barrabás, laa ne ca xpinni, purti bicaa lú ca gobiernu ne biiti ca stale binni. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Oraque beeda ca binni que ra nuu Pilatu ne gudxi ca laabe guni be casi runi be irá iza. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Para na Pilatu rabi laacabe: ―Ñee racala'dxi tu undaa Rey sti ca judíu ri para laatu la? ");
INSERT INTO zaiNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Uní' Pilatu zaqué purti nanna bedané ca xaíque sti ca sacerdote Jesús ra nuu purti si cadxiichi ca xiñee rinanda binni laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Peru maca bisiene ca ca binni que inaba ilaa Barrabás. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Oraque na Pilatu rabi laacabe: ―Xi racala'dxi tu gune nia ni na tu Rey sti ca judíu ri ya'. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Para bicaa cabe ridxi: ―¡Icá be lu cruz! ");
INSERT INTO zaiNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Oraque na Pilatu: ―Xiñee, xi huayuni be. Peru bigueta bicaa cabe ridxi sti tiru: ―¡Icá be lu cruz! ");
INSERT INTO zaiNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Peru Pilatu racala'dxi guiaana bien ne ca binni que; ngue runi bindaa Barrabás, para bini mandar idiiñe Jesús ne bidii laabe icá be lu cruz. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Oraque gucuaa ca soldadu que Jesús, yené ca laabe lu patiu sti palaciu ne bidxiña idubi naca batallón laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bigacu ca laabe ti lari moradu ne bizá' ca ti la'pa de guichi guluu ca ique be. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ne bizulú bicaa ca ridxi: ―¡Viva Rey sti ca judíu! ");
INSERT INTO zaiNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ne bigaze ca ti gueere ique be ne bichá xhinni ca ladi be ne bizuxibi ca xañee be. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Biluxe bini burla si ca laabe zaqué la? gulee ca lari moradu que ladi be ne bigacu ca laabe xhaba be. Para biree ca ziné ca laabe icá be lu cruz. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Neza ze cabe que bidxaaga cabe ti hombre de Cirene lá Simón, bixhoze Alejandru ne Rufo, zeeda de gui'xhi', ne biguá' cabe laa cruz sti Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ne yené cabe Jesús ti lugar lá Gólgota. Ne diidxa Gólgota la? riní' “Lugar sti Calavera”. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ne bidii cabe laabe vinu nucha ti nisa lá mirra peru qué ñe' be ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Oraque bicaa cabe laabe lu cruz ne gucuaa ca soldadu que xhaba be ne uluu cabe xhaba be lu rifa ne cada tobi ucuaa ni gulee. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Siadó' bia' las nueve bicaa cabe laabe lu cruz. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ne bicaa cabe caadxi diidxa xa ique be ni riní' xiñee cayuu xqueja be ne ndi nga ni na ni: “Rey sti ca judíu.” ");
INSERT INTO zaiNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Laca bicaa cabe chupa gubaana cue' be, tobi ladu derechu ne stobi ladu biga'. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ne zaqué biree ni casi cá lu Xqui'chi Dios ra na: “Bitiidi cabe laabe de malu.” ");
INSERT INTO zaiNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ne irá binni cadi'di ra nuu be cayuni burla ca laabe ne cuniibi ique ca lú be ne na ca': ―Cadi lii nga nou' zuxhá lu yu'du ro' ne lu chonna gubidxa zandisa lu laa sti tiru la? ");
INSERT INTO zaiNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Yanna bilá laca lii ne biete de lu cruz ca. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ne zaqueca bini burla ca xaíque sti ca sacerdote ne maistru de ley laabe, na ca': ―Stobi bilá be peru qué ganda ulá be laca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Pa idu'ya nu guiete Cristu Rey sti Israel de lu cruz ca la? óraque huaxa zuni cre nu laa. Ne dede cani cá né laabe lu cruz que bini burla ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ne bia' galaa dxi, mala bicahui ibá' ne zaqué biaana ni dede gunda huadxí bia' las tres. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ne bia' las tres que bicaa Jesús ridxi: ―¡Eloi, Eloi, lama sabactani! Didxazá la? niní' be: Dios stinne', Dios stinne', xiñee ma bisaanu naa. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bina diaga caadxi de cani nuu raqué cucaa be ridxi para na ca': ―Laucaa diaga, cucaa ridxi be Elías. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ne beda uxooñe tobi gucuaa ti esponja bigadxe de vinagre ne gudixhe ni ique ti gueere', ne bidii ni gue be, ne na: ―Lacueza, idu'ya nu pa gueda ndete Elías laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Oraque bicaa Jesús ti ridxi ne guti. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ne gureza cortina ni nuu ra yu'du ro' chupa ndaa de punta punta. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ne ora bi'ya capitán ni zuhuaa lú be que modo bicaa be ridxi ne modo guti be la? na: ―Dxandí Xiiñi Dios hombre ri'. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Laca nuu caadxi gunaa raqué cayuuya ca de zitu. Ne lade ca gunaa que nuu María Magdalena ne Salomé ne María jñaa Jacobo huiini ne José. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Uzá nanda cabe Jesús ne ucané cabe laa dxi uzá Galilea. Cadi laasi cabe sínuque nuu ru stale ni yenanda Jesús Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ma huadxí uyé José de Arimatea ra nuu Pilatu. Naca José tobi ni risaca lade ca justicia sti ca judíu, ne laca cabeza idxiña dxi guni mandar Dios. Viernes huadxí cayaca irá ndi', ma para uzulú dxi enda riziila'dxi'. Nga runi oraqueca uyé José, yenaba cuerpu sti Jesús, ne qué nutuí lú yenaba ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bidxagayaa Pilatu pabiá' nagueenda guti Jesús, ne bisenda caa be capitán que ne unaba diidxa be laa pa dxandí ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Oraque na capitán que dxandí ni, para bidii Pilatu lugar ucuaa José cuerpu sti Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Oraque uzí' José ti lari gueela cha'hui', gundete be cuerpu que ne bichenda be lari gueela que. Ne óraque uluu be ni ndaani ti ba' ni gudaañe cabe cue' guie ne biseegu be ti guie ruaa ba' que. ");
INSERT INTO zaiNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ne biiya María Magdalena ne María jñaa José ra bicaachi cabe Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Udi'di si dxi enda riziila'dxi', para uzí' María Magdalena ne Salomé ne María jñaa Jacobo nisa rindá' naxhi para chi uchá ca ladi Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingo siadó' ro' biree cabe ze cabe ra ba' que ne yendá cabe raqué ma gundani gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ne nuu cabe xizaa tu cuee guie ni ye'gu ruaa ba' que. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Peru ora yendá cabe biiya cabe ma adxé ladu nexhe ni. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ne ora biuu cabe ndaani ba' que biiya cabe zuba ti hombre huiini ladu derechu naba'qui ti lari quichi de yanni ñee, ne bidxibi cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Peru óraque na hombre que rabi laacabe: ―Cadi idxibi tu, nanna cuyubi tu Jesús de Nazaret ni ucuá lu cruz que, peru ma bibani be. Ma qué guinni be rarí'. Laidxiña gu'ya tu ra guta be, ");
INSERT INTO zaiNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ti che tu chi tidxi tu ca discípulu stibe ne Pedru ma che be Galilea ne raqué gu'ya ca laabe, casi gudxi be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ne biree uxooñe cabe de ra ba' que purti cayaca diti cabe tantu cadxibi cabe ne qué ñabi di cabe ni iruti purti cadxibi cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Bibani Jesús de lade gue'tu domingo siadó' ro', dxi ruzulú semana, ne nirudó' María Magdalena biiya laabe. María nga dxa gunaa ni ulee be gadxe binidxaba luguiá que. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ne yetidxi María ni cani uzá né Jesús tobi si. Nuu ca triste ne cayuuna ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ne gudxi be laaca nabani Jesús ne ma biiya be laa, peru qué ñuni cre ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Udi'di si ngue bidxiña Jesús ra nuu xhupa de laaca neza ze ca gui'xhi', peru qué nuluí' pa laabe ngue. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Para bigueta ca ngue yetidxi ca ca xcaadxi que, peru laca qué ñuni cre ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ultimu bidxiña Jesús ra nuu once discípulu sti', ra zuba irá ca ruaa mexa' ne udinde né be laaca xiñee qué ñuni cre ca cani biiya laabe ma nabani be, ne xiñee tan naguidxi ladxidó' ca'. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ne óraque rabi be laaca': ―Yanna, laché idubi guidxilayú. Lachigüí né irá binni stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tu guni cre ne chu' nisa la? zalá. Peru tu qué guni cre la? ziaana donda sti luguiá'. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ne zudiee ca seña ri cani guni cre: zabee cabe binidxaba ni riguite ique binni ne zaní' cabe idioma ni qué niziidi cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Zanaaze cabe beenda lu ná cabe, ne pa gue cabe xiixa ni napa venenu la? gasti qué zaca cabe, ne zaguixhe ná cabe luguiá binni huará ne zianda ca'. Naa nga quixhe irá nga lu ná cabe para guni cabe. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Biluxe si gudxi Señor Jesús laacabe irá nga, biasa ze ibá' ne gurí cue' Dios. ");
INSERT INTO zaiNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ne laacabe la? biree cabe yegüí cabe stiidxa Dios irá ladu. Ne laca Señor ucané laacabe bisihuinni dxandí ni cayuí' cabe que pur ca milagru ni bi'ni cabe. Amén.");
INSERT INTO zaiNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Stale tu huacaa irá ni uca lade du, irá ni bi'ni Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Laadu qué nidu'ya du ni, peru cani byui' né ni laadu la? biiya ca dede dxi bizulú Jesús xhiiña', ne ucané ca bireeche stiidxa be. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Naa laca huanaba diidxa chaahue dede ra bizulú ni, ne zuluá' galán ucaa ni lú lu, Teófilo xhamigua', ");
INSERT INTO zaiNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ti guiene chaahui lu ni ma bisiidi cabe lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dxi naca Herodes rey de Judea nuu ti sacerdote lá Zacarías, nuu be lade grupu sti Abías. Elisabet lá xheela be, ne laa laca za de xfamilia sacerdote Aarón. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Iropa cabe nacha'hui cabe nezalú Dios, ne ruzuuba pe cabe stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ma nagola cabe ne qué gapa cabe nin ti xiiñi cabe, purti qué ñanda ñapa Elisabet ba'du'. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ti dxi guca caber grupu sti Zacarías guni dxiiña nezalú Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Costumbre sti ca sacerdote la? tu guiaba suerte luguiá ngue nga cu' gu'xhu ndaani yu'du ro'. Bia'si pe luguiá Zacarías biaba ni dxi que. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ne laga caguu be gu'xhu ndaani yu'du que, rí jma binni fuera, caní' né Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ndaani yu'du que nuu be, mala bizuhuaa ti ángel sti Dios ladu derechu sti altar ra riuu gu'xhu que. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nabé bidxibi be ora bi'ya be ángel que dede qué idxela be xi guni be. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Peru na ángel que, rabi laabe: ―Zacarías, cadi idxibi lu', purti ma bigaanda stiidxa lu lu Dios. Yanna chi gapa Elisabet xheela lu ti xiiñi', ne cuee lá lu badu huiini que Juan. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Zadxá tipa ladxidó' lo de enda nayeche', ne stale tu zieche ora gale be. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nabé nandxó' zaca be nezalú Dios, ne qué zagaa ruaa be vinu ne nin ti clase nisa dxu'ni'. Dede ante gale be maca dxá ladxidó' be de Espíritu Santu. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Zudxigueta be stale judíu ra nuu Señor Dios sti ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Zazá niru be lú Señor, ne laabe zeda aca be casi Elías purti zapa be Espíritu sti Dios casi gupa Elías ne laca zaca be nandxó' casi uca Elías. Zaguu né be binni xiiñi tobi si, ne zucuudxi be ladxidó' cani naguidxi ladxidó' para uzuuba ca diidxa'. Zacá nga quixhe chaahui be binni para dxi gueeda Señor. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Oraque na Zacarías rabi ángel que: ―Ximodo ganna dxandí zaca ni caya'bu naa ri ya', purti ma nayooxhua' ne xheela laca ma nayooxho'. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Para na ángel que: ―Naa nga Gabriel, rune xhiiña Dios. Laa biseenda naa gueda tidxe lii ca diidxa sicarú ri'. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yanna zieegu ruaa lu', ne qué zanda iní' lu dede ora ma gule badu huiini que, purti qué ñuni cre lu ni gudxe lii ca. Peru zaca ni, ganda si xhi ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Cadxagayaa ca binni rí fuera que xiñee nabé candaa Zacarías ndaani yu'du'. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ora biree be bidxiña be ra nuu ca binni que, qué ñanda niní' né be laaca', sínuque puru seña bi'ni be lú ca' purti ma biaana be mudu. Oraque bidii ca cuenta biluí' Dios laabe xiixa ndaani yu'du que. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bizaa si dxi nexhe guni be dxiiña ndaani yu'du', biree be zibí' be. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Qué nindaa de ngue uca xiiñi Elisabet ne biaana ndaani yoo gaayu beeu, ne na: ");
INSERT INTO zaiNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","―Bi'ni Dios ndi naa ti ma cadi iní' binni naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Lu xhoopa beeu de naca xiiñi Elisabet biseenda Dios ángel Gabriel ndaani ti guidxi lá Nazaret de Galilea, ");
INSERT INTO zaiNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ra nuu ti badu dxaapa lá María ni ma yenaba ti hombre lá José laa para ichaganá'. Za José de lade xfamilia David. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ora biuu ángel que ra nuu be bigapa diuxi laabe ne na: ―Ma ulí Dios lii, María. Dichosa lii lade irá xixé gunaa. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nabé bidxagayaa be ni gudxi ángel que laabe, ne candaa ique né be xiñee bigapa diuxi laabe zaqué. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Para na ángel que: ―Cadi idxibi lu, María. Ma uluu Dios ndaaya lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Chi aca xiiñi lu' ne zapu ti badu huiini'. Cuee lá lu laabe Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Zaca be nandxó' ne zabí cabe laabe Xiiñi Dios ni nuu ibá'. Ne zucuí Dios laabe de rey ra gurí bixhoze gola be David. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Zaca be rey sti irá cani za de Israel, ne qué ziuu dxi guiasa be. Qué ziuu dxi guiaana dxí be de guni mandar be. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Para na María rabi ángel que: ―Ximodo zanda gaca ndi ya', purti binni dxaapa naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Oraque na ángel que rabi laabe: ―Zeeda Espíritu Santu luguiá lu' ne zutaagu enda nandxó' sti Dios lii. Nga runi zaree chu badu huiini ca para Dios, ne zabi cabe laa Xiiñi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Laca ma naca xiiñi Elisabet lisaa lu', neca ma nagola. Na nda cabe qué zanda gapa be ba'du', peru ma ze be xhoopa beeu de naca xiiñi be. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Purti para Dios gasti ni nagana. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Oraque na María: ―Rarí nuaa para gune ni na Dios. Zaa gaca casi nou' ca. Nga si bina diaga ángel que, biree ze'. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ca dxi queca nagueenda biree María uyé ti guidxi huiini de Judea, nuu lade dani. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ora yendá be ralidxi Zacarías biuu be, bigapa diuxi be Elisabet. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Casi bina diaga Elisabet stiuxi be biniibi dxacha badu huiini que ndaani', ne bidxá ladxidó' Elisabet de Espíritu Santu. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ne bicaa ridxi: ―Dichosa lii lade irá xixé gunaa ne dichoso badu huiini naca xiiñi lu ca. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Paraa biree razón gueda ganna jñaa Señor stinne naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Purti casi bina dia'ga stiuxi lu' biniibi badu huiini ri ndaane de enda nayeche'. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dichosa lii ti bini cre lu', purti zaca ni gudxi Dios lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Oraque na María: De idubi xhialma rusisaca Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ne rieche né ladxiduá' Dios ni beda ulá naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nuaa para gune xhiiña be, ne qué risaca dia', peru bilabi be naa. Dede yanadxí irá xixé binni ibani ndaani guidxilayú zabi naa dichosa. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Purti cadi ni guiete chupa chonna gubidxa si ndi ni bi'ni be luguia'ya'. Nandxó' Dios, ne iruti ru casi laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Qué ziuu dxi guiaana dxí be de ilasela'dxi be cani ridxibi laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Biiya pabiá' nandxó' ni bi'ni be: Bicheche ndase be cani rudxiiba laca laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Undisa be cani ma naca tuuxa de ra zuba, ne bidxiiba be cani qué rudxiiba laca laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bichá tipa be ná cani candaana. Bidxigueta be cani napa bidxichi nisi ná'. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ucané be cani za de Israel, ca xpinni be, ne bilasela'dxi be laaca', ");
INSERT INTO zaiNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","casi bidii stiidxa be ca bixhoze gola canu, Abraham ne ca xiiñi', ne irá xixé ni za de laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Zacá nga bisisaca María Dios, ne biaana né Elisabet bia' chonna beeu. Oraque ru bigueta ralidxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bizaa si xpeeu Elisabet beda gapa ti ba'du'. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ora gunna ca xpecinu be ne ca lisaa be modo bilasela'dxi Dios laabe la? yeizaca ca laabe, ne bieche né ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lu xhono gubidxa guluu cabe seña sti Dios badu huiini que, ne ucala'dxi cabe nibee lá cabe laa Zacarías, lá bixhoze. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Peru na jñaa be co', iree lá be Juan. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Para rabi cabe laa: ―Xiñee, purti iruti lá Juan lade ca lisaa lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Oraque bi'ni cabe seña bixhoze be tu racala'dxi cuee lá laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Para unaba bixhoze be ti tabla ne bicaa: “Iree lá be Juan.” Bidxagayaa ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ne casi pe biluxe bicaa Zacarías nga, ma gunda uní' sti tiru ne bizulú bidii diuxquixe Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nabé bidxibi ca xpecinu cabe ora bi'ya ca ni uca que. Ne yendá diidxa que irá ca guidxi nuu lade dani de Judea. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ne irá ni gunna ni, undaa ique né ni, na: ―Tu nda gueda aca badu huiini ri ya'. Purti rihuinni dxichi nuu né Dios laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Oraque bidxá ladxidó' Zacarías bixhoze be de Espíritu Santu ne uní' ni gudxi Dios laa, ");
INSERT INTO zaiNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","na: Diuxquixe Señor, Dios sti ca binni Israel saca beda ulá ca xpinni. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","De lade cani za de David ni bi'ni xhiiña be, ulee be tobi ni nandxó' para ulá laanu. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ma xadxí bidii stiidxa be guseenda be laa. Uní' be ni de ruaa ca profeta stibe ni uyuu chiqué. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Na be zulá be laanu de lu ná cani nanala'dxi laanu ne cani cuxhii laanu. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ne ziá be ca bixhoze gola nu, ne zietenala'dxi be ni gudxi be laaca zuni be. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nga nga ni gudxi be bixhoze gola nu Abraham zuni be. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ne laca gudxi be laa zulá be laanu lu ná cani nanala'dxi laanu ti ganda guni nu ni na be sin idxibi nu laaca', ");
INSERT INTO zaiNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ne ti ganda ibani nu nayá, ne guiaana nu para laasi be bia' tiica dxi ibani nu. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ne lii la? xiiñe huiine', zaree lá lu profeta sti Dios ni nandxó', purti zazá niru lu lu Señor, ne zuni chaahui lu neza tidi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Zusiidi lu binni Israel ximodo ilá ca' ne modo aca perdonar irá ni huachee ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Purti nabé nadxii Dios laanu, riá laanu. Nga runi zuseenda Xiiñi casi ñaca nindani gubidxa para laanu, ");
INSERT INTO zaiNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","para uzaani irá ni canazá lu guelacahui ne ni nuu lu ná enda guti, ne para udxii lú nu neza ra gata dxí ladxidó' no. Nga nga ni bisiní' Espíritu Santu Zacarías. ");
INSERT INTO zaiNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ze dxi jma ziniisi ba'du que ne jma zihuiini napa Espíritu sti Dios. Ndaani gui'xhi uleza be dede bidxiña dxi guni be xhiiña be lade ca binni Israel. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ca dxi que uní' rey Augusto César idopa lá irá xixé binni de irá guidxi ra runi mandar. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nga nga primé tiru bitopa cabe lá binni dxi cayuni mandar Cirenio ndaani guidxi Siria. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Irá binni napa xidé che xquidxi para icá lá. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ngue runi biree José de ndaani guidxi Nazaret de Galilea uyé Belén ti guidxi de Judea ra gule David. Ne uyé be raqué purti za be de xfamilia David. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yené be María Belén para icá lá cabe raqué. Ca'ru iluxe xquenda xheela cabe peru ma uyuu stiidxa cabe, ne ma naca xiiñi María. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Raqué nuu cabe beda ganda dxi gapa María ba'du'. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Gupa be primé xiiñi be ne bichenda be laa lari, gudixhe be laa ndaani ti cajón ra ro mani guixi, purti qué nidxela cabe ra ñaana cabe ndaani yoo. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gaxha de guidxi Belén nuu caadxi pastor cayapa ca dendxu huaxhinni. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mala biiya cabe ti ángel sti Dios, ne bizaani biaani sti Dios laacabe. Bidxibi cabe dede uca diti cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Peru na ángel que rabi laacabe: ―Cadi idxibi tu. Nia caadxi diidxa cubi gabe laatu, ni gusieche de irá xixé binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yanadxí gule tobi ni ulá laatu ndaani xquidxi David, ne laabe nga Cristu Señor. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ne ora idxela tu ti badu huiini renda lari nexhe ndaani ti cajón ra ro mani guixi la? ngue nga laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ne mala bihuinni jma ángel ra nuu ángel que, cayuunda ca', cusisaca ca Dios, na ca': ");
INSERT INTO zaiNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Diuxquixe Dios ni nuu ibá', ne ndaani guidxilayú gata dxí ladxidó' cani guni ni na be. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Biree si ca ángel que ra nuu ca pastor que, bigueta ca ibá'. Oraque na ca pastor que: ―Chuu Belén, chu du'ya ni guca raqué, ni bisenda tidxi Dios laanu ri'. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Biree guxooñe cabe, ziguuya cabe ni guca que. Ne bidxela cabe José ne María ne badu huiini que nexhe ndaani ti cajón ra ro mani guixi. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ne ora bi'ya cabe badu huiini que, byuí' né cabe laaca irá ni gudxi ángel que laacabe de badu huiini que. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bidxagayaa irá ni bina diaga ni uní' cabe que. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Peru María cayapa irá ni ndaani ladxidó' ne candaa ique né ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bigueta ca pastor que, cusisaca ca Dios ne cudii ca diuxquixe laa, pur irá ni bina diaga ca ne ni bi'ya ca', purti uca ni casi pe gudxi ángel que ni laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Dxi bisaa badu huiini que xhono gubidxa guluu cabe seña sti Dios laa, ne ulee lá cabe laa Jesús, lá ni gudxi ángel que María ante gaca xiiñi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Gupa si María dxi casi cá lu ley ni bidii Dios Moisés guni ca gunaa ni gapa ba'du la? yené ca badu huiini que Jerusalén, yeuchiña ca laabe nezalú Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bi'ni cabe zaqué purti cá lu ley sti Dios: “Irá hombre lugola iree chu para Dios.” ");
INSERT INTO zaiNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ne yené cabe ofrenda casi cá lu ley que, chupa gugu huiini o chupa paloma. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chiqué uyuu ti hombre ndaani guidxi Jerusalén, lá Simeón. Nacha'hui be ne nabé rusisaca be Dios. Dxá ladxidó' be de Espíritu Santu, ne cabeza be gu'ya be gueeda ni gueda ulá ca binni Israel. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Purti ma gudxi Espíritu Santu laabe qué zati be dede qué gu'ya be gueeda Cristu ni chi useenda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ne dxi que biluí' Espíritu Santu laabe che be ndaani yu'du ro'. Bia'si pe raqué nuu be ora bedané cabe Jesús. Zeda guni cabe casi cá lu ley guni né cabe ba'du'. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ucuaa be badu huiini que undisa be lu ná be ne bidii be diuxquixe Dios, ");
INSERT INTO zaiNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","na be: Señor, huayune xhiiña lu', ne yanna ma nexhe dxí ladxiduá', purti ma uca ni bidii stiidxa lu naa. Ma zanda chi neu naa yanna. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Ma biiya dxi'che pia' ni gudixhe lu gueda ulá irá binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Laabe chi udxiiba be ca binni Israel, ca xpinni lu', ne chi aca be biaani para cani cadi za de Israel. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Bidxagayaa José ne María irá ni uní' Simeón de badu huiini que. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Oraque uluu Simeón ndaaya laacabe ne na rabi María jñaa Jesús: ―Pur ni zeda guni badu huiini ri' ziaba stale binni Israel, ne zaqueca pur laabe ziasa stale de laaca'. Zeda uluí' be binni xii nga racala'dxi Dios peru stale tu qué zaná ulabi laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ne zacá zahuinni xi nuu ndaani ladxidó' cada tobi. Peru para lii la? María, zeda gaca irá nga casi ñaca nudxiga cabe ti gudxíu xhialma lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Laca nuu ti gunaa raqué lá Ana, xiiñi Fanuel de xfamilia Aser. Rui' né be binni ni gabi Dios laabe. Nahuiini ru be bichaganá be, peru lu gadxe iza de bichaganá be guti xheela be. Yanna ma nagola be, ma napa be ochenta y cuatro añu. Qué riree be ndaani yu'du ro'. Rusisaca be Dios ridxí ne huaxhinni, ne stale tiru riaana be sin go be para iní' né be Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Oraque pe bidxiña be ra nuu badu huiini que, ne bidii be diuxquixe Dios, ne dede óraque bizulú cayabi be binni badu huiini que nga ni cabeza ca gueda ulá Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bi'ni si cabe irá ni cá lu ley sti Dios guni cabe, bigueta cabe Nazaret de Galilea, xquidxi cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ze dxi jma ziniisi badu huiini que, jma ziyapa stipa, jma ziyuu xpiaani ne nabé uluu Dios ndaaya laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Irá iza rie José ne María Jerusalén rigapa pascua, saa ro' sti ca judíu. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Dxi ma bisaa Jesús doce añu yené cabe laa, yegapa cabe saa Jerusalén, casi runi cabe irá iza. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Biluxe si saa que bigueta José ne María, peru qué ñanna ca pa biaana Jesús Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Zácaxa ca zeeda be lade irá binni que. Uzá ca idubi ti dxi, ne óraque ru biyubi ca laabe lade ca lisaa ca', ne lade cani runibiá' ca', ");
INSERT INTO zaiNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","peru qué nidxela ca laabe. Para bigueta ca Jerusalén, yeyubi ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Lu chona gubidxa beda idxela ca laabe ndaani yu'du ro'. Zuba be galahui de cani rusiidi ley sti Dios, cucaa diaga be laaca' ne canaba diidxa be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nabé bidxagayaa cani cayuna diaga pabiá' riene be ne modo ricabi be. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ora bidxela cabe laabe, bidxagayaa cabe, ne na jñaa be rabi laabe: ―Xiiñe', xiñee ndi canayu'nu laadu sicarí'. Naa ne bixho'zo lugu canazá du canayubi du lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Oraque rabi be laaca': ―Xiñee ndi canayubi tu naa. Ñee qué ganna tu pa naquiiñe gune xhiiña Bixhoze la? ");
INSERT INTO zaiNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Peru qué ñene ca xi cayabi be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bigueta né be laaca Nazaret ne bizuuba be stiidxa ca'. Peru María cayapa irá ni ndaani ladxidó'. ");
INSERT INTO zaiNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ze dxi jma ziyuu xpiaani be ne ziniisi be ne cayeche né Dios laabe ne zaqueca cayeche né binni laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Lu quince añu de cayuni mandar Tiberiu irá guidxi sti ca romanu, naca Poncio Pilatu gobernador de Judea, naca Herodes gobernador de Galilea, ne Felipe, bi'chi', naca gobernador de Iturea ne de Traconite, ne Lisanias naca gobernador de Abilinia, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás ne Caifás naca sacerdote gola. Ca dxi que pe' nuu Juan, xiiñi Zacarías ndaani gui'xhi'. Ne raqué uní' né Dios laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Oraque uzá be irá ca guidxi ni nuu uriá guiigu Jordán. Canayabi be binni naquiiñe inaba ca perdón Dios ti aca perdonar ni huachee ca' ne chu' nisa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Guca ni casi bicaa profeta Isaías chiqué, ra na: Zuna diaga cabe cucaa tuuxa ridxi ndaani gui'xhi', cayabi binni: “Lausiá neza tidi Señor, lauxhele ladxidó' to casi ñaca cuxhele tu ti neza para laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Zadxii irá barranca, ziete irá dani, zaca chaahui neza pandu, ne zaca chaahui neza rangu. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ne irá binni zuuya modo ulá Dios laaca'.” Irá nga bicaa Isaías. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ora bi'ya Juan cadxiña ca binni que para chu' nisa ca', na: ―Binni nexhená ca', zeeda tu ra nuaa para chu' nisa tu, purti ruzulú tu zacá zalá tu de xiana sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yanna lasá jneza ti ihuinni ma unaba tu perdón Dios de idubi ladxidó' to ne cadi ma iree né tu, na tu: “Xiiñi Abraham laadu.” Gabe ca' laatu pa qué guni tu jneza casi bi'ni be la? dede lade guie ri zanda indisa Dios xiiñi be. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ora qué ricá cuananaxhi lu ti yaga, rugá cabe laa ne ruzaaqui cabe laa. Zacaca nga ma zeda dxiña dxi sti irá binni ni qué runi jneza. Laca maca zilá ca lu bele. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Oraque na ca binni que rabi laabe: ―Pa zacá ni la? xi zanda guni du ya'. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Para rabi be laaca': ―Tu napa chupa gamixa la? gudii tobi ni qué gapa ni gacu', ne ni napa ni go la? ucheeche ná ni lade cani cayaadxa ni laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Laca beeda caadxi ni ruquixe impuestu ra nuu be para chu' nisa ca' ne na ca rabi ca laabe: ―Maistru, laadu ya', xi guni du. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Para rabi be laaca': ―Cadi uquixe tu jma que bia' cá lu ley. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","―Laga laadu ya', xi guni du, na caadxi gendarme. Para rabi be laaca': ―Cadi cu' tu doo iruti para gaxha tu laa xiixa, nin udxiiba tu donda ique ca neca qué ñuni ca gasti'. Laguiaana conforme ne ni riaxa si tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nuu ca binni que guiuba ganna ca pa laabe nga Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Peru rabi be irá ca': ―Naa caguaa ni'sa sia' laatu, peru nanda stobi naa jma nandxó' que naa. Laa zudii Espíritu Santu cani guni cre, ne zulaa cani qué runi cre lu bele. Nin para cuee xquela guidi be ñee be qué risaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Zeda guni be casi runi tobi ni riguibi semiá, zutopa be ca semiá para uchá be ndaani sacu, ne zundaa be ca guixi que lu gui, peru gui ni qué ziuu dxi gyui'. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zacá ne stale ru modo bilidxe be ca binni que, ne byuí' né be laaca ca diidxa cubi ni sicarú para laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ne udinde né be Herodes purti nabeza né Herodías xheela Felipe bi'chi', ne cadi pur nga si sínuque ne pur irá enda qué iquiiñe ni huayuni. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Lugar de nucaa diaga Herodes laabe, laga jma rusi bichee, biseguyoo laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Laga caguu nisa ru Juan binni, ye chuu nisa Jesús ra nuu. Ne ra caní' né Jesús Dios, bixele ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Biete Espíritu Santu luguiá', bihuinni casi ti paloma, ne ucuá ti ridxi de ibá': ―Lii nga Xiiñe ni nadxiee' ne ni rusieche naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Bia' treinta añu napa Jesús dxi bizulú bi'ni xhiiña'. Na binni xiiñi José laabe. José xiiñi Elí, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí xiiñi Matat, Matat xiiñi Leví, Leví xiiñi Melqui, Melqui xiiñi Jana, Jana xiiñi José, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José xiiñi Matatías, Matatías xiiñi Amós, Amós xiiñi Nahum, Nahum xiiñi Esli, Esli xiiñi Nagai, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai xiiñi Maat, Maat xiiñi Matatías, Matatías xiiñi Semei, Semei xiiñi José, José xiiñi Judá, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá xiiñi Joana, Joana xiiñi Resa, Resa xiiñi Zorobabel, Zorobabel xiiñi Salatiel, Salatiel xiiñi Neri, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri xiiñi Melqui, Melqui xiiñi Adi, Adi xiiñi Cosam, Cosam xiiñi Elmodam, Elmodam xiiñi Er, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er xiiñi Josué, Josué xiiñi Eliezer, Eliezer xiiñi Jorim, Jorim xiiñi Matat, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat xiiñi Leví, Leví xiiñi Simeón, Simeón xiiñi Judá, Judá xiiñi José, José xiiñi Jonán, Jonán xiiñi Eliaquim, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim xiiñi Melea, Melea xiiñi Mainán, Mainán xiiñi Matata, Matata xiiñi Natán, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán xiiñi David, David xiiñi Isaí, Isaí xiiñi Obed, Obed xiiñi Booz, Booz xiiñi Salmón, Salmón xiiñi Naasón, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón xiiñi Aminadab, Aminadab xiiñi Aram, Aram xiiñi Esrom, Esrom xiiñi Fares, Fares xiiñi Judá, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá xiiñi Jacob, Jacob xiiñi Isaac, Isaac xiiñi Abraham, Abraham xiiñi Taré, Taré xiiñi Nacor, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor xiiñi Serug, Serug xiiñi Ragau, Ragau xiiñi Peleg, Peleg xiiñi Heber, Heber xiiñi Sala, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala xiiñi Cainán, Cainán xiiñi Arfaxad, Arfaxad xiiñi Sem, Sem xiiñi Noé, Noé xiiñi Lamec, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec xiiñi Matusalén, Matusalén xiiñi Enoc, Enoc xiiñi Jared, Jared xiiñi Mahalaleel, Mahalaleel xiiñi Cainán, ");
INSERT INTO zaiNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán xiiñi Enós, Enós xiiñi Set, Set xiiñi Adán, Adán xiiñi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ora bigueta Jesús de ra guiigu Jordán dxá ladxidó' de Espíritu Santu, ne yené Espíritu que laabe ndaani gui'xhi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Biaana be raqué cuarenta dia ne ira ca dxi que ucala'dxi binidxaba nuquiinde laabe. Qué ño be idubi naca cuarenta dia que, ne ora bi'ya binidxaba ma candaana dxita be, ");
INSERT INTO zaiNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","na rabi laabe: ―Pa dxandí Xiiñi Dios lii la? gudxi guie ri gaca pan. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Oraque rabi be laa: ―Cá lu Xqui'chi Dios: “Cadi pan si nga ibani né binni, sínuque ne stiidxa Dios.” ");
INSERT INTO zaiNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Oraque yené binidxaba laabe lu ti dani soo, ne tobi biluí' si laabe idubi naca guidxilayú, ");
INSERT INTO zaiNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ne na rabi laabe: ―Zudiee lii irá ca guidxi sicarú ca, purti stinne cani, ne zanda udiee cani tutiica acaladxe'. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yanna stiu' cani pa uzuxibi lu xañee' usisaca lu naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Peru óraque rabi be laa: ―Bixele de naa, binidxaba', purti cá lu Xqui'chi Dios: “Dios si nga naquiiñe usisaca cabe, ne guni cabe ni na.” ");
INSERT INTO zaiNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Bigueta ucuaa binidxaba laabe, yené laabe Jerusalén, bidxiiba laabe ique yu'du ro' ne na rabi laabe: ―Pa dxandí Xiiñi Dios lii la? uyuu bí de racá. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Purti cá lu Xqui'chi Dios, zuseenda ca ángel sti' gapa lii, ");
INSERT INTO zaiNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","cu' ná xi'que lu' ti cadi gacaná lu lu guie. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Para rabi be laa: ―Laca cá lu Xqui'chi Dios: “Cadi inaba cabe xiixa Dios para quite si cabe laa.” ");
INSERT INTO zaiNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Biiya si binidxaba ma qué idxela ximodo usaba laabe, bisaana laabe caadxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Uca si irá nga bigueta be neza Galilea ne stale enda nandxó' purti dxá ladxidó' be de Espíritu Santu. Irá xixé guidxi neza que ma cayuí' cabe stiidxa be. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ne bisiidi be ndaani ca yu'du sti ca judíu ne irá ca bisisaca ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ne zaqué canazá be dede yendá be Nazaret guidxi ra biniisi be. Raqué nuu be beda ganda dxi enda riziila'dxi', para biuu be ndaani yu'du casi runi be irá dxi enda riziila'dxi', ne bizuhuaa be para gu'nda be Xqui'chi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bidii cabe laabe gui'chi ni bicaa profeta Isaías ne bixhele be ni biyubi be ra cá ca diidxa ri': ");
INSERT INTO zaiNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nuu né Espíritu sti Dios naa, purti ma ulí naa güe nia ca pobre diidxa ni usieche laaca'. Biseenda be naa gueda ndee yuuba ladxidó' binni, ne gabe cani nundiibi pecadu laa ximodo zanda iree ca de laani, ne usinaya cani nacheepa lú, ne ula'ya cani cuxhii cabe laa, ");
INSERT INTO zaiNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ne gabe binni ma bidxiña dxi gudixhe Dios para ilá ca'. Irá nga cá ra biinda be que. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Biluxe si biinda be ni, bizeechu be ni, bidii be ni ni runi dxiiña ndaani yu'du que ne gurí be. Peru biiya si be cayuuya dxí irá ni nuu ndaani yu'du que laabe la? ");
INSERT INTO zaiNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","bizulú be byui' né be laaca diidxa', rabi be laaca': ―Yanadxí pe cayaca ni cá lu Xqui'chi Dios ni bina diaga tu nagasi ca. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nabé biaba be ca binni que ne bidxagayaa ca pabiá' galán riní' be ne na ca': ―Ñee cadi ndi nga dxa xiiñi José que la? ");
INSERT INTO zaiNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Para rabi be laaca': ―Nuu ti dichu na: “Doctor, bisianda laca lii.” Yanna seguru nga ca cayabi tu naa, gune irá ni bine Capernaum ndaani xquidxe'. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Peru gabe ca' laatu, qué rulabi cabe ti profeta ndaani xquidxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Casi uca chiqué dxi nabani profeta Elías, chonna iza aronda qué ñaba nisa guie ne uca ti gubiña ca guidxi que. Stale viuda uyuu lade ca judíu, ");
INSERT INTO zaiNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ne qué nuseenda Dios Elías ra nuu nin tobi de laacabe, sínuque ra nuu ti viuda ndaani guidxi Sarepta de Sidón. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ne zaqueca dxi nabani profeta Eliseo, stale judíu gupa lepra, peru nin tobi qué ñanda sínuque Naamán, binni Siria. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ora bina diaga cani nuu ndaani yu'du que xi na be, gudó dí laaca', ");
INSERT INTO zaiNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ne biasa ca', ulee ca laabe de ndaani guidxi que, yené ca laabe punta dani ra dxi'ba guidxi que para nibee yaande ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Peru udi'di be galahui de laaca', ze be. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Uyé be sti guidxi de Galilea, lá Capernaum. Ne bisiidi be ca binni que dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nabé bidxagayaa ca binni que modo rusiidi be, purti riní' be casi tobi ni zanda guni mandar. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ndaani yu'du que nuu ti hombre riguite binidxaba ique, ne bicaa ridxi: ");
INSERT INTO zaiNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Biree de laadu. Xi napa neu laadu, Jesús de Nazaret. Ñee zeda unitilú lu laadu la? Runebia'ya lii. Lii nga hombre cha'hui sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Oraque udinde né be binidxaba que, na be rabi be laa: ―Bigani, ne biree de hombre ca. Oraque bigaze binidxaba que hombre que layú, ne biree ze', sin ñuniná hombre que. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nabé bidxagayaa irá binni que, ne na ca': ―Ximodo ndi caní' hombre ri'. Ne stale enda nandxó' runi mandar be ca binidxaba' ne riree ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ne nisi stiidxa be cayuí' irá binni de ca guidxi neza que. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Biree be de ra yu'du que, uyé be ralidxi Simón. Nexhe né suegra Simón xhindxá' ne unaba cabe Jesús usianda laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Para bidxiña Jesús ra nuu be, ne udinde né xhindxá' que, biree. Oraqueca biasa be ne bidii be ni gudó ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bia' ziyaazi gubidxa yené cabe stale binni huará de irá clase enda huará ra nuu Jesús, para gudixhe ná Jesús luguiá ca' ne bianda ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ne laca stale binni ulee be binidxaba de laa, ne laga caree ca binidxaba que cucaa ca ridxi: ―Lii nga Xiiñi Dios. Peru udinde né be laaca', qué nudii be lugar niní' ca', purti nanna ca laabe nga Cristu ni ulí Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ma zeda yaba biaani biree be de ndaani guidxi que, uyé be ti lugar ra iruti guinni. Peru stale binni canayubi laabe ne yendá ca ra nuu be. Ucala'dxi ca nucueeza ca laabe para cadi ñe be. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Peru rabi be laaca': ―Napa xidé chaa xcaadxi guidxi. Chi güe nia binni modo runi mandar Dios, purti para nga bendá'. ");
INSERT INTO zaiNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ne zacá uzá be Galilea, yeusiidi be irá ra yu'du'. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ti tiru nuu Jesús uriá ti nisa ro' rabi cabe Genesaret, bidxiña stale binni ra nuu be dede calaa saa ca'. Irá ca racaladxi ca guna diaga ca stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Biiya be zuhuaa chupa canuá uriá nisa que, iruti nuu ndaani purti biree ca guuze que caguiibi ca starraya ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Para biuu be ndaani tobi de laani bia'si pe ndaani canuá sti Simón. Ne gudxi be laa utuuba huiini ni de ruaa nisa, ne guri be ndaani canuá que. Dede raqué bisiidi be ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Biluxe bisiidi si be ca binni que, rabi be Simón: ―Yené canuá stiu' ra zia', ne lausaba starraya tu para inaaze tu benda. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Oraque na Simón: ―Maistru, idubi gueela bini du dxiiña ne gasti qué nina'ze du, peru yáquexa lii caya'bu laadu guni du ni la? chi usaba du starraya du. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ora bisaba cabe starraya cabe bidxá tipa ni de benda dede careza ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Para guridxi cabe xcaadxi xcompañeru cabe ni nuu ndaani sti canuá, gueda acané ca laacabe. Oraque beeda ca ngue ne bichá tipa cabe iropa canuá que de bilá ñaazi cani. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ora bi'ya Simón Pedru ni, bizuxibi xañee Jesús ne na: ―Bixele de naa, Señor, purti naca tobi hombre nabé ruchee. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Uní' be zacá purti cadxagayaa be de cayaca diti be pur irá benda que, ne cadi laasi be, sinuque ne ca xcaadxi ni nuu né laabe raqué. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Lade cabe zeeda Jacobo ne Juan, ca xiiñi Zebedeu, tobi si runi né ca Simón dxiiña'. Peru na Jesús rabi Simón: ―Cadi idxibi lu'. Dede yanadxí cásica rinaaze lu benda, zacaca zeda neu stale binni ra nuaa'. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ulee si cabe ca canuá que lu yuxi, bisaana cabe irá ni raqué, zinanda cabe Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ra canazá Jesús ndaani tobi de ca guidxi que, bidxiña ti hombre huará napa lepra laabe, bizuxibi xañee be dede gudixhe ique layú ne na rabi laabe: ―Señor, pa na lu la? zanda usianda lu naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Oraque udixhe ná be luguiá' ne rabi be laa: ―Zusianda lii, ne mápeca bianda lu'. Nisi pe binitilú lepra que óraque. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ne rabi be laa: ―Qué chi tidxi lu ni iruti'. Xi si ni rabe lii la? uyé ra yu'du ti gu'ya sacerdote lii ne bidii ofrenda ni na Moisés udii cani guianda para ganna binni ma bianda lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Peru ze dxi jma rusi zireeche stiidxa Jesús, ne reeda stale binni, reeda ucaa diaga ca laabe, ne para usianda be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Peru gatigá rixele be de laaca' rie be ndaani gui'xhi' riní' né be Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ti dxi ra cusiidi Jesús zuba caadxi fariseu ne caadxi maistru de ley ni beeda de idubi Galilea ne de Judea ne de Jerusalén. Ne cahuinni enda nandxó' sti Dios luguiá be ra cusianda be binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Raqué nuu be bedané cabe ti hombre nexhe lu luuna', ma guti galaa, ne ucala'dxi cabe niguu cabe laa ndaani yoo ra nuu be que, ");
INSERT INTO zaiNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","peru qué nidxela cabe paraa ñuu cabe purti dxá binni raqué. Para udxi'ba cabe ique yoo, ulee cabe caadxi teja, ne undete cabe laabe, idubi ne luuna que. Gudixhe cabe laabe galahui ca binni que, ra lú Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ora bi'ya Jesús pabiá' napa cabe fe laa, na rabi ni huará que: ―Ma bine perdonar ca xpecadu lu, xiiñe'. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dede óraque bizulú ca fariseu ne maistru de ley candaa ique né ca': ―Tu hombre ri cayuni laa Dios pue. Dios si nga zanda guni perdonar binni, ne iruti ru'. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Peru nanna dxichi Jesús xi cani' ique cabe, para na rabi laacabe: ―Xiñee cani' ique tu zacá. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Xii nga jma qué igana, gabe hombre ri ma uca perdonar la? o gabe laabe: “Biasa, uzá.” ");
INSERT INTO zaiNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Naa nga Hombre Biseenda Dios ne para ganna tu zanda gune perdonar xpecadu binni ndaani guidxilayú ri la? laguuya ni chi gune ri'. Ne óraque rabi be ni huará que: ―Biasa, bitopa jluuna lu', ma zanda chibí' lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Oraqueca biasa hombre que nezalú irá cabe bitopa jluuna', zibi'. Ne idubi neza ziudii diuxquixe Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","De irá cabe bidxagayaa cabe ne bisisaca cabe Dios. Dede cayaca diti cabe, na cabe: ―Enda ridxagayaa nga ni bidu'ya nu yanadxí ri'. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Uca si irá nga biree Jesús, ze'. Ra zidi'di be biiya be zuba Leví ra ruquixe impuestu. Para rabi be laa: ―Dananda naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Oraqueca biasa, bisaana irá ngue, zinanda laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ne bidii Leví ti endaró laabe. Uyé stale ni ruquixe impuestu ne stale binni guri né laacabe ruaa mexa que. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Oraque bizulú ca fariseu ne ca jmaistru ca' caní' ca Jesús ne ca discípulu sti', na ca rabi ca ca discípulu que: ―Xiñee ro né tu ca malu ni ruquixe impuestu ne cani qué rulabi ley. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Para na Jesús rabi laaca': ―Cadi caquiiñe cani nazaaca doctor, sínuque cani huará. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Cadi zeda yube cani nacha'hui sínuque cani cuchee, para inaba ca perdón Dios ne uchaa ca xpia' ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Oraque na ca rabi ca laabe: ―Xiñee ca discípulu sti Juan ne sti ca fariseu stale tiru riaana ca sin go ca' ne nabé riní' né ca Dios, peru ca stiu' la? qué lica ruchuugu ca lu endaró. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Para rabi be laaca': ―Lácaxa ñaana cani nuu ra enda xheela sin ño laga nuu novio lade ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Peru zadxiña dxi guiaaxha cabe novio. Oraque huaxa ziaana cabe sin go cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ne laca gudixhe be ti ejemplu para laaca, na: ―Lácaxa ñuu tu nicheza tindaa vestidu cubi, nucaa lu ti vestidu yooxho'. Purti pa ñuni cabe ni, nunitilú cabe vestidu cubi ne laca qué nidxaaga ni ucheza cabe que vestidu yooxho'. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ne zaqueca iruti rigaa vinu cubi ndaani guidi yooxho', purti pa ñuni cabe ni la? nicheza ni guidi que. Cásica ninitilú vinu que, zaqueca ninitilú guidi que. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nga runi naquiiñe idaa vinu cubi ndaani guidi cubi ti iropa ni guiaana ni bia'si. ");
INSERT INTO zaiNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ne zaqueca cani ma biaa gue vinu yooxho', qué zaná gue vinu cubi, purti zaná jma galán vinu yooxho'. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ti dxi enda riziila'dxi zidi'di Jesús ne ca discípulu sti ndaani ti ñaa, ne bizulú ca discípulu undadi ca zee gudó ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Oraque na caadxi fariseu: ―Xiñee cayuni tu ni cadi jneza guni binni dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Para na Jesús rabi laaca': ―Ñee qué huayuunda tu xi bi'ni David, laa ne cani canazá né, dxi candaana ca la? ");
INSERT INTO zaiNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Biuu be ndaani yu'du sti Dios, ucuaa be ca pan ni ma uyuu ndaaya'. Gudó be, ne bidii be cani canazá né be que, gudó ca', neca na ley ca sacerdote si zanda go cani, peru laacabe gudó cabe ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Naa nga Hombre Biseenda Dios, ne naa zanda gabe binni xii nga jneza guni dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Bigueta sti dxi enda riziila'dxi biuu Jesús ndaani yu'du' ne bizulú cusiidi'. Nuu ti hombre raqué nabidxi ti chu ná ladu derechu. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nuu ca maistru de ley ne ca fariseu raqué para si undaachi ca pa zusianda be binni huará dxi enda riziila'dxi' ti gapa ca xi pur cu' ca xqueja be. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Peru laabe nanna be xi cá ique ca', para rabi be dxa hombre nabidxi ti chu ná que: ―Biasa, bizuhuaa galahui ca. Oraqueca biasa hombre que, bizuhuaa. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Oraque rabi be xcaadxi que: ―Chi naba diidxa laatu xiixa. Xii nga nexhe aca dxi enda riziila'dxi', acané nu binni la? o guniná nu laa; ulá nu xpida binni la? o guuti nu laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Oraque biiya dxi be irá cani ri laabe ne rabi be dxa hombre que: ―Bisigaa nou'. Ne bisigaa ná hombre que ne bianda. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Peru nabé bidxiichi ca binni que ne cani' stiidxa ca xi zanda guni ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ca dxi que biree Jesús uyé lu ti dani, yení' né Dios. Ne idubi gueela que gutaná be uni' né be Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Birá si gueela guridxi be cani canananda laabe ne guli be doce de laaca' ne ulee lá be laaca apóstol. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Lade cabe zeeda Simón ni na be iree lá Pedru, ne Andrés bi'chi', ne Jacobo ne Juan, ne Felipe, ne Bartolomé, ");
INSERT INTO zaiNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ne Mateu ne Tomás, ne Jacobo xiiñi Alfeu, ne Simón ni guyuu lade ca cananista chiqué, ");
INSERT INTO zaiNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ne Judas bi'chi Jacobo, ne Judas Iscariote, dxa ni bitoo laabe que. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ne óraque biete irá cabe de lu dani que dede ra bedandá cabe ra napampa. Ora bedandá cabe biiya cabe ri binni raqué ni beeda de idubi Judea ne de Jerusalén ne de ca guidxi nuu uriá nisadó', Tiro ne Sidón. Beda ucaa diaga ca laabe, ne para usianda be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ne laca bisianda be cani riguite binidxaba ique. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Irá binni racala'dxi cana laabe purti nuu enda nandxó' sti Dios luguiá be ne nanna ca neca cana si ca laabe zianda ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Oraque biiya dxi be ca discípulu stibe ne na be: ―Dichoso de laatu, cani qué gapa gasti', purti stitu ni napa Dios ladxi ná'. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Dichoso de laatu, cani candaana purti ziuu dxi idxá tu. Dichoso de laatu, cani cayuuna yanna, purti ziuu dxi uxidxi tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Dichoso de laatu ora aca nanala'dxi cabe laatu, ne qué na cabe idxaaga cabe laatu, ne ulaa cabe diidxa laatu, ne qué lica racala'dxi cabe guna diaga cabe lá tu purti xpinni Hombre Biseenda Dios laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Laguieche dxi que, dede idxá ladxidó' to de enda nayeche', purti nabé sicarú ni cabeza laatu ibá', purti zacaca bi'ni ca bixhoze gola cabe ca profeta ni uyuu chiqué. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Peru lagapa gá si laatu, cani napa bidxichi, purti enda nayeche stitu nga. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Lagapa gá si laatu, cani dxá dxá ca ndaani yanna, purti ziuu dxi indaana tu. Lagapa gá si laatu, cani cuxidxi yanna, purti ziuu dxi gacaná ladxidó' to dede gu'na tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Lagapa gá si laatu ora udxiiba binni laatu, purti zacaca bi'ni ca bixhoze gola cabe. Bidxiiba ca ni cadi dxandí profeta. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Peru ndi nga ni racaladxe gabe laatu, cani cucaa diaga naa. Laganaxhii cani qué na chu' né laatu tobi si, ne lagacané cani nanala'dxi laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Lacuu ndaaya cani riguu dí laatu, lainí' né Dios pur cani riní' laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pa chu' tu capa xa diaga tu la? laudii ca né sti ladu. Pa chu' tu gaxha laatu chamarra stitu, laudii ca laa ne xcamixa tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tutiica inaba laatu laudii, ne tu gaxha laatu stitu la? cadi inaba tu ni laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Laguni laacabe ni racala'dxi tu guni cabe laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Pa ganaxhii tu cani nadxii si laatu la? ñee na tu ma xiixa nga cayuni tu la? Purti dede ca binni qué rulabi ley sti Dios runi zacá. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ne zaqueca pa gacané tu cani racané si laatu la? cadi caguu tu gasti lú ni, purti zacaca runi cani qué rulabi ley sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ne pa utiiñe tu cani rutiiñe si laatu la? cadi caguu tu gasti lú ni purti zacaca runi cani qué rulabi ley sti Dios. Rutiiñe ca' cani nanna ca zutiiñe laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Peru laatu la? laganaxhii cani cadi nadxii laatu ne lagacané laaca', ne lautiiñe sin cueza tu utiiñe cabe laatu. Pa guni tu zacá la? nabé naro'ba ziaxa tu, ne zahuinni dxandí xiiñi Dios laatu. Purti laabe nacha'hui be ne cani qué rudii diuxquixe laabe ne cani cuchee né laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Laguiá binni casi riá Dios stitu binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Cadi udxiiba tu donda ique binni ti cadi quiba donda ique tu, ne laguni perdonar stobi ti guni perdonar Dios laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Lagacané stobi de ni caquiiñe', ne laca zacané Dios laatu de ni caquiiñe tu. Zuchá tipa be ná tu dede zaxii. Purti bia' ca udii tu stobi bia' queca icaa tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Oraque gudixhe be ti ejemplu para laaca rabi be laaca': ―Qué zanda inaaze ti lú cheepa ná sti lú cheepa', purti pa ñuni cabe ni la? iropa cabe ñaba cabe ndaani barranca. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tobi ni caziidi la? qué ziuu dxi tidi lú jmaistru, sinuque ora ma binduuxe, ma nanna bia' nanna jmaistru. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ximodo zanda gu'ya lu guixi nuu lú stobi ne qué gu'ya lu bandadi nuu lú lu ya'. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","O ximodo zanda gabi lu stobi: “Dané cuee guixi nuu lú lu ca, xhamigua'.” Ne lii zaa nuu bandadi ca lú lu la? Cadi quitu binni. Gulee ca bandadi nuu lú lu ca, ti ganda guuya chaahui lu cuee lu guixi nuu lú stobi. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Pa nazaaca ti yaga cuananaxhi la? qué zacá cuananaxhi ni cadi galán lú. Ne zaqueca pa qué iquiiñe ti yaga la? qué zacá cuananaxhi galán lú. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Irá yaga rihuinni xi yaga laa pur ca cuananaxhi sti'. Qué zanda uchuugu lu du'ga lu yaga guichi yaa, ne qué zanda uchuugu lu uvas lu yaga guichi gueda. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pa nacha'hui ti binni la? zuni enda nacha'hui purti nga nga ni nuu ndaani ladxidó', ne binni ni nadxaba la? runi enda nadxaba', purti nga nga ni nuu ndaani ladxidó'. Purti de ndaani ladxidó' cabe riaaxha ni riní' cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Xiñee rabi tu naa, “Señor, Señor”, peru qué runi tu ni rabe'. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Chi tidxe laatu ximodo zeda gaca cani gueda ucaa diaga stiidxa' ne guni ni na ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Zeda gaca ca casi ti hombre bicuí lidxi. Gudaañe guete dede yendá guie ne lu guie que undaa cimientu. Biree guiigu bidiñe ntaa nisa cue' yoo que. Qué lica niniibi ni purti zuba ni lu guie. ");
INSERT INTO zaiNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Peru cani ucaa diaga naa ne qué guni ni gabe la? zeda gune laaca casi stobi hombre bicuí lidxi lu yuxi sin nindaa cimientu. Casi pe bidxá guiigu bidxela saa nisa cue' ni, bixá ca ni. Nin stindaa huiini ni qué ñaana. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Biluxe byui' né si Jesús ca binni que diidxa', biree uyé Capernaum. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ne raqué nabeza ti capitán romanu, napa ti mozo nabé nadxii. Peru huará mozo que dede mayaca gati'. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ora bina diaga capitán que cayuí' cabe stiidxa Jesús, biseenda chupa chonna xaíque sti ca judíu chi naba Jesús gueeda usianda mozo que. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ora yendá cabe ra nuu Jesús bizulú cabe cayabi cabe laa: ―Biá la' capitán ca, Señor. Ucané laabe purti nacha'hui be. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nadxii be binni laanu. Laape be bisenda ucuí be xhyu'du du ndaani guidxi ri'. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Para biree Jesús ziné laacabe. Nécati mayaca chindá cabe ra yoo que, biseenda capitán que chupa xhamigu chi tidxi Jesús: ―Señor, cadi gapu dxiiña gueda ndou de ralidxe', purti iruti naca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nga runi nin qué ñune pur niree naa pia' niyube lii. Uní' si, ne zacá zianda mozo stinne'. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Purti naa ca' nanna ximodo ni. Napa tu runi mandar naa ne napa tu rune mandar. Pa gabe tobi: “Uyé rarica'”, zie. Gabe stobi: “Gudá' rarí'”, zeeda. Ne pa useenda mozo stinne chi guni xiixa la? zuni. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nabé bidxagayaa Jesús de ni uni' capitán que, ne biiya dxi irá binni nanda laa, ne na: ―Laguuya si pabiá' fe napa hombre ri', nin lade cani za de Israel qué huadxela tu napa fe bia' napa be. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ne ora yendá cani yeyubi Jesús yoo, ma bianda binni huará que. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Qué nindaa de ngue biree Jesús, ze ti guidxi huiini lá Naín, nanda ca discípulu ne xcaadxi binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ora yendá uriá guidxi que, biiya ziucaachi cabe ti gue'tu', tobi lucha xiiñi ti viuda. Ne stale binni guidxi que ziucaachi gue'tu que. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ora bi'ya be gunaa que biá be laa ne rabi be laa: ―Cadi gu'na lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ne bidxiña be uda'na be cajón que, para biaana dxi cani nua ni que. Oraque rabi be gue'tu que: ―Biasa, xiiñe'. Canié nia lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Oraque biasa hombre huiini que ne bizulú cani'. Para bidii be laa jñaa. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ora bi'ya irá binni que ni guca', nabé bidxibi ca' ne bizulú ca cudii ca diuxquixe Dios, ne na ca': ―Ma biree ti profeta nandxó' lade nu. Ma zeda gacané Dios ca xpinni. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Idubi naca Judea ne ca guidxi huiini nuu gaxha bireeche stiidxa Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Gudxi ca discípulu sti Juan laa irá ni guca que. Para guridxi chupa de laacabe, ");
INSERT INTO zaiNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","biseenda chi naba diidxa Jesús pa laa nga Cristu ni nexhe gueeda o pa zabeza cabe stobi. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Casi yendá cabe ra nuu Jesús bidxiña cabe laa ne rabi cabe laa: ―Biseenda Juan Bautista laadu, zeda naba diidxa du lii pa lii nga Cristu ni nexhe gueeda o pa zabeza du stobi. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ora pe yendá cabe raqué cusianda Jesús stale binni huará ne binni ni napa yuuba', ne cabee binidxaba de binni, ne cusiná cani nacheepa lú. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Para na rabi laacabe: ―Lachitidxi Juan irá ni biiya tu ne ni bina diaga tu. Lagüi' né laabe ma riná cani nacheepa lú, ma rizá cani nachiita ñee, ma bianda cani gupa lepra, ma runa diaga ca diaga cuaata', ne bibani ni ma guti, ne ma cayuna diaga ca pobre stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Dichoso cani guni cre Dios biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Biree si cani biseenda Juan que ze', byui' né Jesús ca binni que de Juan, na rabi laaca': ―Tu yeguuya tu ndaani gui'xhi'. Ñee yeguuya tu tobi ni ruluí' ti gueere lase ni uniibi bi laa ladu na la? ");
INSERT INTO zaiNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pa cadi nga la? tu yeguuya tu ya'. Ñee yeguuya tu ti hombre zuchaahui la? Peru laatu nanna tu cani zuchaahui ne cadi cayaadxa laa gasti la? cadi nabeza ndaani gui'xhi sinuque ndaani lidxi rey. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lagabi naa tuu nga yeguuya tu. Ti profeta la? Nga nga laani, ne jma pe que ti profeta. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","De Juan nga ruzeete Xqui'chi Dios ra na: Zuseenda ti xpinne sa niru lú lu', guni chaahui neza tidi lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Laucaa diaga ni chi tidxe laatu ri'. De lade irá binni, qué huaree ti profeta jma nandxó' que Juan, peru dede ni jma huaxié' risaca lade ca xpinni Dios, jma nandxó' que laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ora bina diaga ca binni que ni na Jesús, na ca jneza runi Dios. Cani uni' ni la? nga cani unaba cu' nisa Juan laaca', ne lade cabe zeeda caadxi ni ruquixe impuestu. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Peru ca fariseu ne ca maistru de ley qué nizaala'dxi ca ni ma gudixhe Dios para laaca', ne qué ninaba ca niguu nisa Juan laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","―Tu zanda usaca nu ca binni nuu yanna ri', na Jesús. ―Tu ruluí' cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Zeda gune laacabe casi ca xcuidi riguite luguiaa. Ma cucaa ridxi ca ni caguite né ca': “Bixhidxi du saa peru qué niná tu nuyaa tu, ne bixhidxi du son gue'tu' peru qué niná tu ñuuna tu.” ");
INSERT INTO zaiNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Zacá nga laatu. Beeda Juan Bautista, qué ro, qué re' vinu ne na tu nuu né binidxaba'. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yanna ma benda lade tu, naa nga Hombre Biseenda Dios. Rahua' ne ree', ne na tu nalaya' ne binigüé' naa ne ridxaaga ca malu ni ruquixe impuestu ne cani qué rulabi ley. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nga na tu laatu peru cani riene la? rusihuinni jneza runi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Bini invitar tobi de ca fariseu que Jesús chi to né gueta ralidxi. Para guyé Jesús ne gurí ruaa mexa'. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ndaani guidxi que nabeza ti gunaa canazá si. Ora gunna be cayó Jesús gueta ralidxi fariseu que, yené be ti frascu dxá aceite rindá' naxhi. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Casi biuu be guri be xa ñee Jesús ne bizulú be cayuuna be. Gudiibi be ñee Jesús irá nisa biete lú be ne bicuiidxi né be ni guicha ique be. Gudó be bixidu ni, ne bichá be aceite rindá' naxhi que ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ora bi'ya fariseu que xi cayuni be, na: ―Pa ñaca dxandí profeta ndi la? ñanna gunaa canazá si caga'na laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Oraque na Jesús, rabi fariseu que: ―Simón, napa xiixa gabe lii. ―Xi laa, Maistru, na. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Para rabi be laa: ―Uyuu chupa hombre bizaabi ni ruquixe vueltu. Tobi que bizaabi gaayu gayuaa denariu, stobi que cincuenta si. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Peru qué gapa cabe ni quixe cabe ni, para bixhá hombre que lá cabe ti ihuinni ma cadi naquiiñe quixe cabe ni. Yanna gudxi naa uná de laacabe jma nadxii laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Para na Simón: ―Para naa la? ruluí' ni jma bizaabi stale que. ―Jneza, rabi be laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ne biiya dxi be gunaa que, ne bigueta rabi be Simón: ―Biuaa rali'dxu ne qué nudiiu nisa ña'ri ñee', peru biiya gunaa ri gu'yu', gudiibi ñee ne nisa biete lú ne bicuiidxi né ni guicha ique. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Qué ño lo bixidu deche naya', peru laabe dede biuaa qué huayaana dxi be de go be bixidu ñee'. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ne qué niguu lu aceite ique', peru laabe bichá be aceite rindá' naxhi ñee'. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nabé huachee be peru ma bixhaya stonda be, nga runi nadxii be naa de idubi ladxidó' be. Peru cani huaxié' stonda rixá la? huaxié' ranaxhii ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ne óraque na Jesús, rabi gunaa que: ―Ma bine perdonar lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bizulú nda cani zuba né Jesús ruaa mexa que uní' saa ca na ca': ―Tu hombre ri' zanda guni perdonar binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Peru na Jesús rabi gunaa que: ―Bilá lu purti bini cre lu'. Sicarú uyé. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Qué nindaa de ngue biree Jesús, canazá ca guidxi ro' ne guidxi huiini', canayuí' né binni modo runi mandar Dios. Ne doce apóstol stibe que canazá né laabe, ");
INSERT INTO zaiNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ne cadi laasi ca' sínuque ne caadxi gunaa ni bisianda be ne ni ulee be binidxaba de laa que. Lade cabe zeeda María ni rabi cabe Magdalena, ni ulee be gadxe binidxaba de laa, ");
INSERT INTO zaiNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ne Juana xheela Chuza, ni rapa cani runi xhiiña Herodes, ne Susana ne xcaadxi. Irá cabe ruchaaga cabe, racané cabe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Stale binni biree de ca guidxi que yeguuya laabe. Biiya si be ma rí binni laabe, gudixhe be ti ejemplu para laaca', ");
INSERT INTO zaiNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","na be: ―Sicari bizaaca lú ti hombre, biree zinduu biní. Ra cusaba be xuba que biaba caadxi ni uriá neza. Biitu ñee cabe laa ne biete mani huiini gudó laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Xcaadxi biaba lade guie. Undani ni peru nagueenda bibidxi ni, purti qué gapa ni gudxa. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Xcaadxi biaba lade guichi ne undani, peru jma bisoo guichi que para laacani ne biiti ca guichi que cani. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Peru biaba xcaadxi ni ra nayá ne ca ngue huaxa ucuá lú dede nuu ra bidii ti gayuaa carreta niza. Biluxe uní' si be nga bicaa be ridxi, rabi be laaca': ―Irá ni racala'dxi guiene la? ucaa diaga. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Oraque unaba diidxa ca discípulu stibe laabe xi riní' ejemplu que. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Para rabi be laaca': ―Laatu la? cudii Dios lugar guiene tu modo runi mandar, dede ni naga'chi'. Peru ca xcaadxi la? puru si ne ejemplu rue nia laaca', ti cadi gu'ya ca neca cayuuya dxí ca', ne cadi guiene ca neca cayuna diaga ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ndi nga ni riní' ejemplu ca. Ca xuba ca la? zeda gaca casi stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ni biaba uriá neza que, ngue nga ca binni rucaa diaga stiidxa Dios, peru raxha binidxaba ni ndaani ladxidó' ca ti qué guni cre ca ne qué ilá ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ne cani biaba lade guie que, ngue nga ca binni rucaa diaga stiidxa Dios ne ricaa ca ni ne enda nayeche'. Riaana né ca ni caadxi, peru casi pe gueeda xiixa naná maca zixele ca', purti qué nicaa xcu chaahui ni ndaani ladxidó' ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ne cani biaba lade guichi que, ngue nga ca binni rucaa diaga stiidxa Dios, peru jma cá ique ca dxiiña ne gapa ca bidxichi ne guiaca ca', ne irá nga ruuti stiidxa Dios ne ma qué riree ndu. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ne cani biaba layú ra nayá que, ngue nga ca binni naguudxi ladxidó'. Ora guna diaga ca stiidxa Dios ricaa ca ni de idubi ladxidó' ca'. Qué riuu dxi ixele ca' ne zacá riree ndu ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Bigueta gudixhe be sti ejemplu, na be: ―Iruti rucaa gui linterna ne ruseegu xiixa lú ni o cu' ni xa'na luuna', sínuque rugaanda ni luguiá' ti tutiica guiuu gu'ya biaani'. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Zaqueca irá ni ye'gu lú yanna napa xidé ixele ti gu'ya binni xi laa, ne irá ni naga'chi yanna napa xidé ihuinni ti ganna binni ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nga runi laucaa diaga chaahui', purti cani napa la? zacaa jma, peru cani qué gapa, dede ni na napa ziaaxha. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Raqué nuu be beeda jñaa be ne ca bi'chi be, peru qué ñanda nidxiña ca laabe purti ri binni laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Para biree tobi, na rabi laabe: ―Racá fuera ca zuhuaa jñoou ne ca bi'chi lu'. Racala'dxi ca iní' né ca lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Peru laga na be rabi be laaca': ―Cani ucaa diaga stiidxa Dios ne guni ni na ni, ngue nga jñaa ne biche'. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ti dxi biuu né Jesús ca discípulu sti ndaani ti canuá ne na rabi laaca': ―Latidi nisa ri'. Para biaaxha cabe ze cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ne ra zidi'di cabe nisa que gu'ta Jesús, gusi. Lu nisa que ze cabe gunaaze ti bi yooxho laacabe. Ne biguu ni nisa ndaani canuá que, dede ruluí' ma chi guiaazi cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Para yeucuaani cabe Jesús, rabi cabe laa: ―¡Maistru, Maistru! ¡Ma chi gati nu! Oraque biasa be, ne gudxi be bi yooxho que guiaana dxi, ne zaqueca gudxi be ola que, ne oraqueca guta dxí cani. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Oraque rabi be laaca': ―Cadi ladxa runi cre tu naa la? Xi uca xa tu yanna. Peru laaca nabé bidxibi ca' ne unaba diidxa saa ca': ―Tu laabe pue. Riní' né be bi ne nisa, ne ruzuuba cani stiidxa be. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Zaqué ze cabe lu nisa que dede yendá cabe Gadara cherica de Galilea. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Casi bizuhuaa ñee Jesús yu, bidxiña ti hombre de guidxi que ra nuu. Ma xadxí riguite binidxaba ique be. Qué racu be lari ne qué riaana be yoo. Nisi lade ba' canazá be. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Stale tiru riguite binidxaba ique be ne rundiibi ca binni que cadena ná be ne ñee be. Peru ruchuugu be ni, ne riné binidxaba que laabe ndaani gui'xhi'. Casi bi'ya be Jesús bizuxibi be xañee ne bicaa be ridxi: ―Xi napa neu naa, Jesús Xiiñi Dios ni nandxó'. Rinaba lii cadi guniná lu naa. Uní' be zaqué purti cayabi Jesús binidxaba que usaana laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ne na Jesús, rabi laabe: ―Tu lá lu'. ―Legión, na be. Ngue na be lá be purti stale binidxaba nuu luguiá be. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ne unaba ca binidxaba que Jesús cadi useenda laaca gabiá. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Bia'si canayó jma bihui cue' ti dani neza ra nuu cabe que. Para unaba ca binidxaba que Jesús udii lugar chu' ca luguiá ca bihui que. Ne bidii Jesús lugar. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Para biree ca de hombre que, yechuu ca luguiá ca bihui que, ne biete tí ca bihuí que de ra dxi'ba ca'. Bia'si pe ndaani nisa biaba ca', ne raqué guti ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ora bi'ya cani cayapa ca bihuí que ni uca que la? biaaxha ca yeuxooñe ca'. Ne bizulú ca byui' ca ni ndaani guidxi que ne irá ca ranchu ni nuu neza que. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Para biree ca binni que ziguuya xi uca raqué. Ne ora yendá ca ra nuu Jesús biiya ca dxa hombre ni riguite binidxaba laa que, ma nacu lari, ma bigueta xpiaani', zuba xañee Jesús. Ne bidxibi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Byuí' né cani bi'ya ra uca ni laaca ximodo bianda hombre que. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Oraque gudxi ca binni que Jesús iree de ndaani guidxi que, purti cadxibi ca'. Para biuu Jesús ndaani canuá que ne ze'. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Peru ante iree be ucala'dxi dxa hombre ni bianda que niné laabe, para rabi be laa: ");
INSERT INTO zaiNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Bigueta rali'dxu ne byui' né laacabe pabiá' nandxó' ni bi'ni Dios luguiá lu'. Para biree hombre que ze', ne bizulú uzá idubi naca guidxi que. Byui' xi bi'ni Jesús laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ora yendá Jesús cherica nisa que, bichagalú ca binni que laa ne stale enda nayeche', purti irá ca cabeza ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Oraque bidxiña ti hombre lá Jairu naca xaíque sti yu'du'. Bizuxibi xañee be ne na chiné be laa ralidxi, ");
INSERT INTO zaiNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","purti cayati tobi lucha xiiñi', ti badu dxaapa de doce añu. Para biree be ze be, peru stale binni zinanda laabe, dede calá saa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lade ca binni que zeeda ti gunaa ma raca doce añu de caxii rini. Ma birá ni napa, biniti luguiá doctor, ne iruti ñanda nusianda laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Bidxiña neza deche be, guda'na ñee xhaba be ne oraqueca bianda. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Para na be: ―Tu guda'na naa. Ne irá binni na cadi laa. Para na Pedru ne ca xcaadxi que, rabi laabe: ―Maistru, cayuuyu modo cuquiichi binni lii ne nou' tu guda'na lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Peru na be: ―Uyuu tu guda'na naa, purti nanna bisianda tuuxa ne enda nandxó' sti Dios ni nuu luguia'ya'. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Biiya si gunaa que ma bigaa la? cayaca diti bizuxibi xañee be ne ulee ruaa diidxa xiñee guda'na laabe, ne casi guda'na laabe bianda ca. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Para rabi be laa: ―Bianda lu, xiiñe', purti bini cre lu'. Yanna sicarú uyé. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Caní' ru be biuu ti xpinni Jairu, na rabi laa: ―Ma guti xiiñi lu'. Ma cadi uchiiña rou' Maistru. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Peru ora bina diaga be ni, rabi be Jairu: ―Cadi idxibi lu'. Bini cre, ne zianda xiiñi lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ne ora yendá cabe ralidxi Jairu biuu né be laa ne xheela' ne Juan ne Jacobo ne Pedru, ne ma qué niná ru be ñuu iruti'. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Rí stale binni raqué, cayuuna cucaa ridxi peru rabi be laaca': ―Cadi gu'na tu purti cadi guti badu dxapa huiini ca, sinuque nisiaasi si. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Laga bixidxi ca laabe, purti nanna dxichi ca' ma guti ba'du que. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Oraque unaaze be ná ba'du que ne rabi be laa: ―Biasa xiiñe'. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Oraqueca bibani ba'du que ne biasa. Para gudxi be laaca udii ca ni go ba'du que. ");
INSERT INTO zaiNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nabé bidxagayaa bixhoze ba'du que ne jñaa. Peru biinda be lú ca qué chi tidxi ca iruti'. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Guridxi Jesús doce discípulu sti que, ne gudixhe ladxi ná cabe cuee cabe binidxaba de binni, ne usianda cabe binni huará. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Biseenda laacabe chi güi cabe modo runi mandar Dios ne usianda cabe binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Na rabi laacabe: ―Cadi chiné tu gasti ni iquiiñe tu neza, nin bastón, nin ixhiapa, nin pan, nin vueltu. Lachiné lari ni nacu si tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ne ra guiete tu la? laguiaana ndaani yoo que dede dxi ma iree tu de guidxi que. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ne ra qué na cabe icaa cabe laatu, lairee de guidxi que, ne laquibi yu cá ñee tu casi ti seña bichee cabe ra qué niná cabe nucaa diaga cabe laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Para biree ca ze ca', uzá ca guidxi pur guidxi. Yegüí né ca binni stiidxa Dios, ne bisianda ca cani huará. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ora bina diaga gobernador Herodes xi irá cayuni Jesús, bichenda ni laa, purti nuu tu na Juan Bautista bibani, ");
INSERT INTO zaiNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ne nuu tu na Elías bigueta'. Xcaadxi na tobi de ca profeta ni uyuu chiqué nga ma nabani sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Para na Herodes: ―Juan la? naa biseenda gaxha yanni. Peru tuu ndi na cabe cayuni irá ndi ya'. Ne biyubi gu'ya laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ora bigueta ca apóstol de ra biseenda Jesús laaca', biyubi ca ra nuu Jesús ne byui' né ca laabe xi irá bi'ni ca'. Para ucuaa be laaca' yené be laaca uriá guidxi Betsaida. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Peru ora gunna binni paraa nuu be, yenanda ca laabe. Bichagalú be laaca ne byuí' né be laaca modo runi mandar Dios. Ne bisianda be cani caquiiñe guianda. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ne raqué nuu cabe bidxí layú para bidxiña ca apóstol ra nuu be, na ca rabi ca laabe: ―Ñee cadi ma ñanda ña'bu ca binni ca ñe ca la? tila nidxela ca ra ñaana ca ne ni ño ca ndaani ca guidxi huiini ne ca ranchu nuu gaxha ca, purti ndaani gui'xhi ndi nuu nu. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Para rabi be laaca': ―Laudii ni go cabe laatu. Oraque na ca': ―Peru xi pe ndi napa du, gaayu pan ne chupa benda. O racala'dxu chi sí du ni go irá binni ri la? ");
INSERT INTO zaiNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ne nuu bia' gaayu mil hombre raqué. Oraque rabi be ca discípulu stibe: ―Laucuí ca binni ca neza cincuenta cincuenta. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ne zaqué bicuí cabe irá ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ne ucuaa be gaayu pan ne chupa benda que, undisa lú be ibá', bidii be diuxquixe Dios. Para undaa be cani, bidii be cani ca discípulu qui'zi lu ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Gudó irá ca binni que dede bidxá ca', ne biaana ru jma nandahui. Bitopa cabe bia' sti doce dxumi. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ti dxi yení' né Jesús Dios, yené ca discípulu sti' ne ra nuu cabe que rabi be laaca': ―Tu na binni naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Para na ca': ―Nuu tu na Juan Bautista lii, nuu tu na Elías, ne nuu tu na tobi de ca profeta ni uyuu chiqué, ma bibani. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","―Laga laatu ya', rabi be laaca'. ―Tu rabi tu naa. Oraque na Pedru: ―Lii nga Cristu ni ulí Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Peru biinda ca be lú ca' qué chi tidxi ca ni iruti'. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Rabi be laaca': ―Naa nga Hombre Biseenda Dios. Naquiiñe tide stale enda naná. Zudxii deche ca xaíque sti guidxi ne ca xaíque sti ca sacerdote ne ca maistru de ley naa, ne zuuti ca naa, peru zabane raguionna gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ne rabi be irá ca': ―Tu gacala'dxi gaca xpinne la? gusiaanda laca laa, ne cadi lica guiá xpida sínuque usaana ni lu naya irá dxi ne gueda nanda naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Purti tu gacala'dxi ulá xpida la? zuniti ni, peru tu uniti xpida pur naa la? zalá. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Paraa iquiiñe ni binni pa guni ganar idubi naca guidxilayú peru uniti xhialma. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Purti tutiica ituí lú chi nanda naa ne stiidxa la? naa laca zatuí lua inié xpinne laa dxi useenda Dios naa guenda casi ti rey ne enda nandxó' sti Bixhoze' ne sti ca ángel cha'hui'. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Peru gabe ca' laatu, nuu caadxi rarí qué zati dede qué guuya ora ma cayuni mandar Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Udi'di bia' xhono gubidxa de uní' Jesús ca nga, ucuaa Pedru ne Juan ne Jacobo, udxi'ba né lu dani, yení' né Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ne laga nuu be caní' né be Dios mala biiya cabe ma adxé laabe. Naquichi bé bihuinni xhaba be dede ria'qui biaani'. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ne cayuí' né be chupa hombre diidxa', Moisés ne Elías. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Guionna cabe nuu cabe galahui xtuxhu ti biaani ro'. Cuzeete cabe modo chi gati be Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ma nuu bacaanda lú Pedru ne xhupa que, peru qué niná ca ñasi ca'. Ne zacá gunda biiya ca cuzaani ladi Jesús ne xhupa zuhuaa né laa que. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ma chi ixele ca hombre que de Jesús para na Pedru: ―Maistru, aque galán nuu nu rarí nja'. Zanda guni du chonna ranchu huiini', tobi para lii, tobi para Moisés, ne stobi para Elías. Peru nin ganna Pedru xi caní'. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Caní' ru be mala biseegu ti za laacabe. Nabé bidxibi cabe ora bi'ya cabe nuu cabe lade za. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ne ucuá ti ridxi lade za que: ―Ndi nga Xiiñe' ni nadxiee'. Laucaa diaga laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Biaana dxí si ridxi que, biiya cabe ma stubi Jesús nuu. Dxí dó' uyuu cabe ca dxi que. Iruti ñabi cabe ni bi'ya cabe que. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sti dxi que ra ziyete cabe lu dani beda chagalú stale binni Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mala biree tobi hombre lade ca binni que, bicaa ridxi na rabi Jesús: ―Maistru, biiya la' xiiñe'. Tobi lucha laabe napa'. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ne riguite binidxaba ique be rucaa be ridxi, rinaaze laabe, ruchuche laabe layú dede riree bupu ruaa be, ruxuuxe laabe dede yaca ti' guuti laabe. Oraque ru rundaa laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ma unaba ca discípulu stiu' ñaxha ca binidxaba ca de laabe, peru qué ñanda. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Oraque na Jesús: ―Aque qué runi cre tu xa, binni ca', ne naguidxi ladxidó' to. Dede padxí naquiiñe guiaana nia laatu ne gune huantar laatu ya'. Oraque rabi be hombre que: ―Dané xiiñu ca rarí'. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ma zidxiña hombre huiini que Jesús, unaaze binidxaba que laa, bitubi laa yu. Peru óraque udinde né Jesús binidxaba que ne oraqueca bianda hombre huiini que, para bidii be laa bixhoze. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nabé bidxagayaa irá ca binni que pabiá' nandxó' Dios. Ne laga cadxagayaa ca binni que irá ni cayuni be, rabi be ca discípulu stibe: ");
INSERT INTO zaiNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Laucaa diaga chaahui ni chi tidxe laatu ri', qué chi guiaanda ni laatu. Naa nga Hombre Biseenda Dios ne ma chi utoo cabe naa lu binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Peru qué ñene ca xi cayabi be laaca', purti ma nexhe cadi guiene ca ni. Ne bidxibi ca ninaba diidxa ca laabe xi riní' ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Oraque bizulú ca discípulu cacaa yu ca uná de laaca jma risaca. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Peru nanna Jesús xi caní' cabe, para ucuaa ti ba'du bizuhuaa cue'. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ne na rabi laacabe: ―Tutiica acané ba'du ri pur naa la? casi ñaca cayuni ni naa. Ne tu guni ni naa la? cayuni ni ni biseenda naa. Purti ni jma huaxié' risaca lade tu la? nga nga ni jma risaca. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Biluxe si uní' Jesús, na Juan: ―Maistru, bidu'ya du ti hombre cuzeete lá lu ra cabee binidxaba de binni, peru bicueeza du laa purti cadi canazá né laanu. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Para rabi be laa: ―Xiñee canaucueeza tu laabe, purti cani cadi cucaa lú laanu la? nuu né laanu tobi si. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dxi ma cazaa dxi ibigueta be ibá' udixhe ique be che be Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bisá niru be ca xpinni be ndaani ti guidxi sti Samaria para chi yubi ca ra guiaana be. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Peru qué niná ca binni Samaria ñaana be raqué purti ze be Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ngue bi'ya Jacobo ne Juan para na ca rabi ca laabe: ―Señor, ñee racala'dxu inaba du guiaba gui de ibá' para initilú cabe casi bi'ni Elías chiqué la? ");
INSERT INTO zaiNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Oraque biiya dxí be laaca ne udinde né be laaca', rabi be laaca': ―Nin qué ganna tu tu cayabi laatu iní' tu zacá. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Purti biseenda Dios naa ndaani guidxilayú ri cadi para uniteluá' binni sínuque para ula'ya laaca'. Ne biree cabe ze cabe sti guidxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Neza ze cabe na ti hombre rabi Jesús: ―Señor, racaladxe chi nanda lii ratiica cheu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Para rabi be laa: ―Ca mistu gui'xhi la? napa ca cueva ra riaana ca', ne zaqueca ca mani huiini napa ca lidxi ca'. Peru naa nga Hombre Biseenda Dios, ne qué gapa nin ra quixhe ique'. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ne rabi be stobi: ―Dananda naa. Para na ngue: ―Señor, bidii lugar ucaache sia' bixhoze'. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Oraque rabi be laa: ―Bisaana nga guni ni qué na gueda nanda naa. Lii la? yegüí né binni modo runi mandar Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Oraque biree stobi na rabi laabe: ―Zinanda lii, Señor, peru chi tidxe sia' ca binni lidxe ma chaa'. ");
INSERT INTO zaiNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Para na be: ―Ni quixhe ná lu aradu ne udxigueta lú atrá la? qué zaquiiñe para guni dxiiña'. Zaqueca ni gueda nanda naa ne ibigueta atrá la? qué zaquiiñe lade ca xpinni Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Uca si irá nga, ulí Señor sti setenta, ne biseenda laaca chupa chupa. Bisá niru be laaca lú be irá guidxi ne irá lugar ra che be. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ne rabi be laaca': ―Ma stale binni cabeza si ucaa diaga stiidxa Dios. Tu güi ni nga huaxié'. Yanna lainaba lu Dios guseenda stale tu guni dxiiña ca, ti laa nga xpixuaana ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yanna laché ne laguuya', cuseenda laatu casi nuseenda dendxu huiini lade gueu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Laché xie ñee tu. Cadi chiné tu ixhiapa, nin vueltu. Ne cadi ma ziyaana tu neza güi né tu binni diidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Irá ra yoo ra chu' tu, nirudó' lainaba lu Dios cu' ndaaya ca binni nuu raqué. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ne pa gaca cabe nacha'hui ne laatu la? zaguu Dios ndaaya laacabe. Peru pa co' la? ma laatu nga cu' Dios ndaaya ne cadi laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Laguiaana ndaani yoo ra na cabe icaa cabe laatu, cadi ma canazá tu yoo pur yoo. Ne lagó intiica udii cabe laatu, purti ni cayuni dxiiña la? naquiiñe guiaxa. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Intiica guidxi chu' tu ne uchagalú cabe laatu, lagó intiisi quixhe cabe lú tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Lausianda binni huará de guidxi que ne lagabi laacabe ma zeda dxiña dxi guni mandar Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Peru pa chindá tu ti guidxi qué na cabe uchagalú cabe laatu, lairee de raqué. Ne ora ma chi iree tu lagabi laacabe: ");
INSERT INTO zaiNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Laguuya gá laatu. Dede yu ni ucuá ñee du ndaani xquidxi tu chi ndadi du. Ne laganna dxichi biseenda Dios ni ñeeda tí de rey ndaani ladxidó' to.” ");
INSERT INTO zaiNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ne gabe ca' laatu, jma naná zaca para guidxi que, dxi cuidxi Dios cuenta binni, que para guidxi Sodoma. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Lagapa gá si laatu, binni guidxi Corazín. Lagapa gá si laatu, binni Betsaida. Purti pa ñaca irá milagru ni uca nezalú tu ca ndaani guidxi Tiro ne Sidón la? biaa padxí ma ninaba ca perdón ne ñuu ca triste pur irá ni huachee ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nga runi jma naná ziaba ná tu dxi cuidxi Dios cuenta binni, que para binni Tiro ne Sidón. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ne laatu, binni Capernaum ca', ruluí' ma dxi'ba tu dede ibá' peru ziete ti tu ndaani gabiá. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Oraque rabi be cani cuseenda be que: ―Tu ucaa diaga laatu la? cucaa diaga naa. Ne tu udxii deche laatu la? laca cudxii deche naa. Ne tu udxii deche naa la? cudxii deche ni biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nabé nayeche bigueta setenta biseenda be que, na ca rabi ca laabe: ―Señor, dede ca binidxaba ruzuuba ca stiidxa du ora uze'te du lá lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","―Nanna', na Jesús rabi laacabe. ―Biiya zeda yaba binidxaba de ibá' casi ti rayu. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ma bine laatu nandxó' para ganda gutu ñee tu beenda ne meuxubi, ne para quixhe dxí tu binidxaba sin gacaná tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Peru cadi guieche tu purti ruzuuba binidxaba stiidxa tu, sínuque laguieche purti cá lá tu lu gui'chi ni napa Dios ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ne óraque pe bichá Espíritu Santu ladxidó' Jesús de enda nayeche', ne na: ―Diuxquixe lii, Bixhoze'. Lii nga xpixuaana ibá' ne guidxilayú. Rudiee diuxquixe lii purti qué nudiiu lugar ñene cani riene ne cani nuu xpiaani irá ndi', sínuque bicaachi lu ni para biluí' lu ni cani zeda gaca casi ba'du'. Ne zacá bi'nu ni purti zacá racala'dxu gaca ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Oraque rabi be ca binni que: ―Ma gudixhe Bixhoze irá xixé cosa ladxi naya'. Naa nga Xiiñi be ne iruti runibiá' naa jma que laabe, ne zaqueca iruti runibiá' laabe, jma que naa ne cani racaladxe gunibiá' laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Biluxe uní' si be nga la? biiya dxí be ca discípulu stibe ne uní' né be laasi ca', rabi be laaca': ―Dichoso laatu pur irá ni cayuuya tu ri'. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Purti stale profeta ne stale rey ucala'dxi ñuuya ni cayuuya tu ri', ne qué ñuuya'. Ne ucala'dxi ca ñuna diaga ca ni cayuna diaga tu ri', peru qué ñuu dxi ñuna diaga ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Oraque bidxiña ti maistru de ley ra nuu be ne na rabi laabe: ―Maistru, xi gune para gapa enda nabani ni qué zaluxe. Uní' zacá para gu'ya si pa zusaba laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Para rabi be laa: ―Xi cá lu ley sti Moisés o ximodo riene lu ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Oraque na: ―“Gunaxhii Señor Dios stiu' de idubi naca ladxidó' lo', idubi xhialma lu', idubi xquenda biaani lu', ne irá stipa stiu'. Ne gunaxhii stobi casi nadxii lu lii.” ");
INSERT INTO zaiNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","―Jneza uníu', rabi be laa. ―Yanna bi'ni zacá ti gapu enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Peru ucala'dxi hombre que nusihuinni jneza caní', para na rabi laabe: ―Tuu nga stobi ni riete lu ley ca naquiiñe ganaxhiee ya'. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Oraque rabi be laa: ―Sicarí bizaaca lú ti hombre. Zeda yete be de Jerusalén, ze be Jericó. Neza ze be que biree caadxi gubaana lú be, guxha irá ni ziné be, bisaana laabe xie ladi be, biti nati laabe. Oraque ru biree ca ze ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Raqué nexhe be zeda di'di ti sacerdote. Ora bi'ya nexhe be raqué, udi'di zitu de laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Zaqueca bi'ni ti levita. Ora bidxiña ra nexhe be, biiya laabe ne bixele de laabe, ze'. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Peru ratu huiini si que, za ti samaritanu. Ora bi'ya laabe biá laabe, ");
INSERT INTO zaiNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","bidxiña ra nuu be, ucuaa aceite ne alcohol bichá ra ucaná be ne bindiibi ni. Oraque bidxiiba laabe deche mani sti'. Yené laabe ti ra yoo ra riete binni, ne raqué gupa laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sti dxi que, ma para iree, ulee chupa moneda bidii xpixuaana yoo que, ne na: “Gupa laabe. Ne pa uniti rou' xiixa luguiá be la? ora ibigueta quixe ni.” ");
INSERT INTO zaiNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yanna xi ra'bu', na Jesús rabi maistru de ley que, ―uná de guionna hombre ni udi'di ra nuu ni biree gubaana lú que, gunaxhii stobi casi nadxii laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Para na: ―Ni biá laabe que. ―Nga nga laani, rabi be laa. ―Yanna uyé ne bi'ni zacaca. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","De raqué biree Jesús ze', yendá ti guidxi huiini', xquidxi ti gunaa lá Marta. Ne bini invitar Marta laabe che be ralidxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Napa Marta ti benda lá María, ne gurí María xañee be cucaa diaga. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Peru Marta la? nisi canaree xieque raqué, tantu cá ique xhiiña'. Para bidxiña ra nuu be ne na rabi laabe: ―Señor, ñee nou' jneza cayuni benda', cudii lugar cayune irá ndi stube la? Gudxi laabe gueda acané be naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","―Ah Marta, Marta, rabi be laa. ―Aque stale ni naguu xaíque lu', ne nuu lu xizaa pur laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Peru tobi si nga ni naquiiñe uyubi binni ne María ma ulí ni jma risaca. Ne iruti zaxha ni laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ti dxi nuu Jesús ti lugar, caní' né Dios. Biluxe si be, na tobi de ca discípulu stibe rabi laabe: ―Señor, bisiidi laadu iní né du Dios, casi bisiidi Juan ca discípulu sti'. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Para rabi be laaca': ―Ora iní' né tu Dios la? sicarí nga iní' tu: Bixhoze du ni nuu ibá', rinaba du gusisaca irá binni lii. Ne idxiña dxi guni mandar lu' ne gaca ni na lu'. Cásica raca ni ibá', zaqueca gaca ni ndaani guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dané laadu endaró tidi né du dxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bisiaanda ni ruché' né du lii, casi rusia'nda du ni ruchee né cabe laadu. Ne cadi udiiu lugar cuba yú binidxaba laadu, sínuque bilá laadu de lu ná be. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ne laca rabi be laaca': ―Pa ñapa tobi de laatu ti xhamigu, ne ñe ralidxi xhamigu que bia' galaa gueela ne ñabi laabe: “Xhamigua', bitiiñe la' naa chonna xqueta lu', ");
INSERT INTO zaiNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","purti beeda biuuza ralidxe', peru qué gapa ni quixhe lú.” ");
INSERT INTO zaiNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ne nicabi ngue de ndaani yoo, niná: “Cadi uchiiña lu naa. Ma biseegua ra puerta' ne irá du ma nexhe du. Qué zanda guiasa udiee ni lii.” ");
INSERT INTO zaiNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Zaa naca ñasa be nudii be ni lii pur xhamigu be lii, peru rabe ñasa be nudii be lii irá ni caquiiñu para ma cadi niziñe rou' laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nga runi cayabe laatu: Lainaba lu Dios, zudii laatu. Lauyubi, zadxela tu. Lauxhidxi ná', zaxele chu' tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Purti tutiica inaba zacaa, ne ni uyubi zadxela, ne ni uxhidxi ná' zaxele chu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Tu tobi de laatu ninaba xiiñi laa ti gueta, nudii ti guie, o ninaba laa ti benda, nudii ti beenda', ");
INSERT INTO zaiNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","o ninaba laa ti dxita, nudii ti meuxubi. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pa laatu cadi nacha'hui tu ne nanna tu gudii tu ni galán xiiñi tu la? lágaxa Bixhoze tu ni nuu ibá' qué udii Espíritu Santu ni inaba laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ti dxi nuu tobi hombre ra nuu Jesús riguite binidxaba ique ne bisaana binidxaba que laa mudu. Peru ulee si Jesús binidxaba que de laabe gunda uni' be. Nabé bidxagayaa ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Peru caadxi de laaca na: ―Randa ribee be binidxaba purti nuu né be Beelzebú, xaíque sti ca binidxaba'. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ne xcaadxi, para inaaze si laabe, na usuhuinni be ti seña xaibá' para ganna ca pa dxandí nuu né Dios laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Peru nanna be xi caní' ique ca', para rabi be laaca': ―Pa ñasa caadxi binni de ti guidxi nucaa lú laca xquidxi la? qué nindaa guidxi que. Ne zaqueca pa nindaa saa ti familia nucaa lú saa ca la? laca qué nindaa familia que. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ne pa ma cucaa lú saa ca xpinni binidxaba' qué zandaa initilú. Cayabe nga laatu purti laatu na tu randa ribee binidxaba purti nua nia xaíque stica'. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Yanna pa naa randa ribee binidxaba purti nua nia Beelzebú la? laga ca xiiñi tu ya'. Tu nuu né ca para ribee ca binidxaba'. Laca laaca rusihuinni ca cuchee tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Peru ribee binidxaba purti nuu né Dios naa, ne laganna dxichi ma nuu ni biseenda Dios gueda tí de rey lade tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ora tobi hombre napa stipa ne naaze ni ucaa lú né la? iruti zaxha laa ni nuu ralidxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Peru ora gueeda stobi ni jma nadipa que laabe zaguixhe dxí laabe ne zaxha laabe xquiiba be ni cá lú be ulá laabe, ne óraque ziaana ne irá stibe. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Cani cadi nuu né naa tobi si la? ze luguia'ya', ne cani cadi cutopa né naa la? cucheeche. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ora iree binidxaba ndaani ladxidó' binni, riree ma canazá ndaani gui'xhi', canayubi ra iziila'dxi'. Gu'ya si qué idxela, óraque na': “Zabigueta ralidxe ra biree'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Peru ora guedandá gu'ya ma nayá ladxidó' ngue casi ñaca ti yoo ma biluuba', ma zuchaahui', ");
INSERT INTO zaiNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","zabigueta chi caa xcadxe jma rusi nadxaba que laa. Riuu ca ndaani ladxidó' binni que ne riaana ca raqué. Ne pa huaxié' malu binni que ora nuu stubi si ti binidxaba la? jma rusi yanna. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Caní' ru Jesús nga bicaa ti gunaa ridxi: ―Dichosa de ni uxana lii ne bigadxi lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Peru rabi be laa: ―Jma dichoso cani ucaa diaga stiidxa Dios ne guni ni na ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Cadi cayaana dxí binni de cabí zisi laabe ne bizulú be rabi be laaca': ―Aque malu laatu xa binni ca'. Racala'dxi tu gu'ya tu xiixa seña, peru ti seña si zudiee laatu. Zusietenala'dxe laatu Jonás. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Purti casi uca Jonás seña para ca binni Nínive la? zacaca zaca Hombre Biseenda Dios casi ti seña para laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ne dxi cuidxi Dios cuenta ca binni nuu yanna ri la? zuzuhuaa dxa reina de guete que guseegu ruaa tu, purti neca nabé zitu xquidxi Salomón para xquidxi be peru yeucaa diaga be laa purti nabé riene. Peru laatu nuu tobi lade tu ni jma risaca que Salomón. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ne laca zuzuhuaa ca binni Nínive guseegu ruaa tu, purti laaca dxi yegüí né Jonás laaca stiidxa Dios, unaba ca perdón ne bichaa xpia' ca'. Ne laatu la? ma nuu tobi lade tu jma risaca que Jonás. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Qué rucaa gui cabe linterna ne ucaachi cabe, nin cu' cabe xa'na ti cajón, sínuque rugaanda cabe ni luguiá', ti tutiica guiuu gu'ya biaani'. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ne guielú binni nga biaani sti'. Pa ruyubi guielú cabe gu'ya ni jneza la? zia xquenda biaani cabe. Peru pa ruyubi guielú cabe gu'ya ni nadxaba la? zacahui xquenda biaani cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Biiya gá qué chi gyui' biaani ni napu ca para gaca ni guelacahui. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Purti pa nuu tu ra naya'ni', nin tindaa ra nacahui la? naya'ni dxindxi zuuya tu irá cosa, casi ora ruzaani ti biaani laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Casi biluxe uní' be, bini invitar ti fariseu laabe chi to né be laa gueta ralidxi. Uyé be ne gurí be ruaa mexa'. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nabé bidxagayaa fariseu que ora bi'ya qué niguiibi ná be para ño be casi runi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Peru rabi be laa: ―Laatu, ca fariseu, zeda gaca tu casi vasu ne bladu ni ria'ri ladi si peru ndaani cani nabiidi'. Zacaca laatu, de luguiá si ruluí' nacha'hui tu, peru ndaani ladxidó' to nabiidi', purti riba'na tu sti binni ne ruchee né tu Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Binni huati ca', ñee cadi tobi si ni bizá' cuerpu stitu ne ladxidó' to la? ");
INSERT INTO zaiNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Lagacané cani qué gapa, ti ihuinni ma bia idubi naca tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Lagapa gá si laatu, fariseu ca'. Purti na tu zinanda tu ley, peru cadi dxandí ni. Ni runi tu la? rudii tu Dios bia' nexhe icaa dede lu ca guixi huiini rudii layú' stitu casi menta ne ruda ne xcaadxi, peru qué rulabi tu pa naquiiñe sa binni jneza ne ganaxhii Dios. Nga nga ni jma naquiiñe guni tu, peru laca cadi guiaana ca xcaadxi ca. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Lagapa gá si laatu, fariseu ca'. Purti riula'dxi tu cui tu lu ca bangu ndaani yu'du ra ribí cani jma risaca, ne riula'dxi tu ugapa diuxi binni laatu ladu tiica che tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Lagapa gá si laatu. Purti zeda gaca tu casi ba' ni qué rihuinni. Ridi'di cabe luguiá sin ganna cabe. Zacaca riguite tu binni sin ganna ca tu pe laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Oraque na ti maistru de ley rabi laabe: ―Maistru, ora riníu' zacá la? dede ne laadu rucoou ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Para rabi be laa: ―Laca lagapa gá si laatu, maistru de ley ca'. Purti ruguá' tu binni ni iruti randa rua', peru laatu nin bicuini ná tu qué na tu indisa né tu ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Lagapa gá si laatu. Purti cayuni chaahui tu xpa' ca profeta ni biiti ca bixhoze gola tu, ");
INSERT INTO zaiNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ne zacá rihuinni cayuula'dxi tu ni bi'ni cabe. Laacabe bizulú cabe ni, ne laatu cunduuxe chaahui tu ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Peru nanna Dios ximodo laatu, nga runi na: “Zuseenda profeta ne apóstol ra nuu cabe. Zuuti cabe caadxi ne zazabi nanda cabe xcaadxi.” ");
INSERT INTO zaiNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ne zuquixe Dios ca binni de yanna ri' rini sti ca profeta ni huayuuti cabe dede dxi bizulú guidxilayú, ");
INSERT INTO zaiNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","dede rini sti Abel hasta rini sti Zacarías ni biiti cabe lade yu'du ro' ne altar ni nuu lu patiu. Irá nga zaguixe ca binni nuu yanna ri'. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Lagapa gá si laatu, maistru de ley ca'. Purti casi ñaca naaze tu llave para guiene tu stiidxa Dios, peru qué na tu guiene tu, ne nin qué na tu udii tu lugar guiene xcaadxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bidxiichi ca maistru de ley ne ca fariseu ora gudxi be nga laaca', ne bizulú ca canaba diidxa ca laabe jma. ");
INSERT INTO zaiNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Pa ñanda si nuchenda ca laabe para ñapa ca xi pur niguu ca xqueja be. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bizulú cabí zisi binni Jesús dede calá saa ca'. Para na rabi ca discípulu sti': ―Laguuya gá qué chi icá sti ca fariseu laatu. Nabé ricá enda rusiguii stícabe binni casi riaazi levadura cuba pan. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Peru napa xidé ihuinni irá ni ye'gu lú, ne zaqueca zanna binni irá ni naga'chi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Zacá nga laani. Irá ni huaní' tu ra nacahui, ziuu tu iní' ni ra naya'ni'. Zaqueca irá ni huaní' tu xa diaga binni ndaani yoo, ziuu tu quiba ique yoo ucheeche ni guidxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Xhamigua ca', racaladxe ganna tu tuu nga idxibi tu. Cadi idxibi tu ni zanda guuti cuerpu si stitu ne ma qué zanda ru guni gasti'. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Sínuque laidxibi Dios purti laa zándala guuti cuerpu stitu la? ne zanda cu' laatu gabiá. Nga runi cayabe laatu, laidxibi laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Laaca tu nanna tu ridoo chupa mani huiini pur chupa domi', peru neca qué risaca came, qué ziaba si tobi de laacame layú pa qué na Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ne laatu la? jma risaca tu que stale mani huiini'. Nga runi cadi idxibi tu, purti dede guicha ique tu ma bigaba Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Cayabe laatu, tutiica iní' xpinne laa nezalú binni la? laca zanié xpinne laa nezalú ca ángel sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Peru tu iní' nezalú binni cadi xpinne laa la? laca zanié nezalú ca ángel sti Dios cadi xpinne laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Naa nga Hombre Biseenda Dios. Pa chu' tu cu' dí naa la? zuni perdonar Dios laa. Peru pa chu' tu usaca Espíritu Santu binidxaba la? qué zuni perdonar Dios laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ora chi nduu cabe xqueja tu ndaani yu'du sti ca judíu o chiné cabe laatu ra nuu justicia la? cadi chu' tu xizaa xi iní' tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Purti ora ma nuu tu raqué zusiidi Espíritu Santu laatu xi iní' tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","De lade ca binni que biree tobi na rabi laabe: ―Maistru, gudxi biche icaa nia laa bia'ca ni bisaana né bixhoze laadu. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Peru rabi be laa: ―Tu gudxi lii juez naa para quiize sti binni ya'. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ne óraque rabi be irá ca binni que: ―Laguuya gá laatu ne enda ruyubi gapa bidxichi, purti cadi nga si nga enda nabani sti binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Oraque byuí' né be laaca ti cuentu rabi be laaca': ―Sicarí bizaaca tobi hombre ricu. Nabé guca xquela. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ne bizulú caní' ique: “Xi gune', ma qué gapa paraa uchaya irá niza ri'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Peru óraque na: “Ma nanna xi gune'. Zuxhaya ca troja stinne'. Zucué cani jma naro'ba para idxá irá niza ri' ne irá stinne'. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ne óraque zanda inié': Yanna huaxa ma chi iziiladxe' ne ma chi guieche', purti ma napa stale ni gahua ne ni guee', ne ma naguaa chaahue ni iquiiñe stale iza.” ");
INSERT INTO zaiNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Peru na Dios rabi laabe: “Binni huati. Yanna gueela ca zati lu'. Ne tu guiaana né irá ni naguu chaahui lu ca ya'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Zacá nga cani rutopa lú para laca laa, peru qué gapa gasti ni risaca nezalú Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Oraque rabi be ca discípulu stibe: ―Nga runi cayabe laatu, cadi chu' tu xizaa paraa iree ni go to para ibani tu, o paraa iree lari cuaqui tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Purti jma risaca xpida tu que endaró, ne jma risaca cuerpu stitu que lari. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Laguuya ca bia'qui gu'ya tu. Qué riguu ca bini, que ribee ca guela, qué gapa ca troja, qué gapa ca lidxi ca ra nuchá ca ni ño ca', peru rudii Dios ni go ca'. Ñee cadi jma risaca tu que ca mani huiini la? ");
INSERT INTO zaiNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Uná de laatu, pa niguu xaíque nisoo xcaadxi, ñee nisoo la? ");
INSERT INTO zaiNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pa nin nga qué zanda guni tu la? xiñee riuu tu xizaa pur ni iquiiñe tu ya'. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Laguuya modo rigaa ca guie' gui'xhi'. Qué runi ca dxiiña', qué riguiba ca', peru nin Salomón, neca nabé bizuchaahui', qué ñacu lari sicarú bia' sicarú cani. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ne pa zacá ruzuchaahui Dios ca guie' gui'xhi', neca yanadxí nagá' ca', ixí ma chaqui ca la? lágaxa laatu, qué udii be ni gacu tu, binni qué runi cre ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nga runi cayabe laatu, cadi ma canazá tu ma nuu tu xizaa xi go to, xi gue tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Purti zacá runi ca binni ni qué runi cre Dios, peru laatu la? ma nanna Bixhoze tu ni nuu ibá' xi irá caquiiñe tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lauyubi guni mandar Dios ndaani ladxidó' to, ne xcaadxi ca zacá si lú ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Cadi idxibi tu, dendxu huiini stinne ca', purti neca huaxié' tu peru rieche Bixhoze tu gudii laatu irá ni napa ladxi ná'. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Lautoo ni napa tu. Lagacané cani caquiiñe'. Ne zacá casi ñaca caguu chaahui tu xpueltu tu ra qué zaniti. Caguu chaahui tu ni ibá' ra qué ziuu gubaana' ne qué zacá bandaa ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Zacá nga laguni, purti ra nuu ni risaca para laatu la? raqué nuu ladxidó' to. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ne laca rabi be laaca': ―Lagataná, zaa nacu tu xhaba tu ne zaa cá guí xpiaani tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Lagaca casi ni cabeza ibigueta xpixuaana de enda xheela' ti casi guiuu xpixuaana uxhidxi ná', maca ziuxhele'. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Dichoso de ni nexhená guedandá xpixuaana'. Ziuu xpixuaana be, ne cuee si lari, zucuí laabe ruaa mexa', udii ni go xhi be. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dichoso laabe pa nexhená be guedandá xpixuaana be, neca guedandá galaa gueela o télayu. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Sicarí nga laani, pa ñanna xpixuaana ti yoo pora ñe gubaana ralidxi la? ñataná para cadi ñuu cabe ralidxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Laatu laca lagataná, purti nin ganna tu mala ibigueta Hombre Biseenda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Oraque na Pedru rabi laabe: ―Señor, ñee byuí' lu nga para laasi du la? o para irá binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Para na be: ―Byue ni para tutiisi gacala'dxi chu' xpiaani', guni xhiiña xpixuaana jneza. Zuni xpixuaana be laabe xaíque sti ca xcaadxi xpinni, gu'ya be go ca bia' nexhe go ca', ne go ca xhiora ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Dichoso de laabe pa jneza cayuni be ora guedandá xpixuaana be. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Purti óraque ma dede irá ni napa zusaana ladxi ná be. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Peru pa niná be: “Zandaa ru gueeda xpixuaana'.” Ne óraque nuzulú niguiñe be ca xcaadxi mozo ne ca criada, ño be ne ñe' be de ra nixudxi be, ");
INSERT INTO zaiNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nin ganna be mala ñedandá xpixuaana be. Ninaaze laabe, ñunidé laabe, niree nanda laabe casi tobi ni qué iquiiñe'. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ni nanna xi racala'dxi xpixuaana ne qué gataná guni ni la? jma naná ziaba ná'. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Peru ni qué ganna xi na xpixuaana ne gueda uchee la? huaxié' ziaba ná'. Ni napa stale gracia jma stale naquiiñe guni, ne ni usaana cabe stale ladxi ná la? jma stale zanaba cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Naná ni zeda gune ndaani guidxilayú. Casi ñaca zeda usaba gui ndaani ni, ne para naa pa ñanda si ma ñaca ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Napa xidé tide ti enda naná naro'ba', ne qué zanda chu' dxí ladxiduá' dede ora ma udide ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ñee zácaxa tu beda gune binni tobi si la? Co', cadi nga beda gune', sínuque beda utinde binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Purti de ca yanna ra nuu gaayu binni ndaani ti yoo, ziasa chonna zucaa lú xhupa que, ne zucaa lú xhupa que laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ziuu hombre zucaa lú bixhoze, ne zucaa lú bixhoze laa. Ziuu gunaa zucaa lú jñaa, ne zucaa lú jñaa laa. Zucaa lú gunaa xualidxi, ne zucaa lú xualidxi laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ne laca rabi be ca binni que: ―Ora gu'ya tu guiasa ti guelacahui na tu chi guiaba nisa guie, ne dxandí riaba nisa guie. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ne ora gu'ya tu cundubi bi nisa na tu enda nandá', ne dxandí raca nandá'. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Xiñee riene tu ni rihuinni ibá' ne guidxilayú peru qué riene tu ni cayaca yanna ri'. Racala'dxi si tu quite tu binni, nga laani. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Xiñee qué uyubi tu lade si tu uná nga ni jneza guni tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pa chiné tuuxa lii ra nuu justicia biyubi ca chu' neu laabe tobi si laga ze tu neza, para cadi chiné be lii ra nuu juez. Pacaa zutidi juez lii lu ná gendarme para useguyoo lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ne gabe ca' lii qué zareeu de raqué dede qué qui'xu irá ni nuza'bu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ca dxi queca uyé caadxi binni ra nuu Jesús ne byui' né ca laabe xi bi'ni Pilatu, modo biiti caadxi binni Galilea ra cayuuti ca binni que mani para usiga'de ca Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Para na be rabi be laaca': ―Ñee na tu bidii Dios lugar bizaaca ca binni Galilea zaqué purti jma malu laaca que ca xcaadxi binni xquidxi ca la? ");
INSERT INTO zaiNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Cadi pur nga di'. Laatu laca zanitilú tu casi binitilú cabe pa qué inaba tu perdon Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O na tu jma malu dieciocho ni guti ra biaba torre Siloé que, que ca xcaadxi binni nabeza Jerusalén la? ");
INSERT INTO zaiNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Cadi pur nga di nga laani. Laatu laca zanitilú tu pa qué inaba tu perdón Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ne laca byui' né be laaca ti cuentu, rabi be laaca': ―Uyuu tobi hombre gupa ti yaga du'ga ndaani ñaa sti'. Ti dxi yeguuya be pa cá du'ga lú ni, peru qué nidxela be. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Para rabi be ni cayapa raqué: “Biaa gu'yu'. Ma raca chonna iza huayeda yube du'ga lu yaga ri', peru qué huadxela'. Yanna bisaba ni. Xi para zuhuaa si ni racá cuchiiña ni layú.” ");
INSERT INTO zaiNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Para na ngue rabi laabe: “Señor, bisaana ni iza ri si, idu'ya nu. Chi taañe ñee ni ne uchaya abono ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ne pa icá lú ni la? riaana ni, peru pa co' la? ma riaba ni.” ");
INSERT INTO zaiNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ti dxi enda riziila'dxi cusiidi Jesús ndaani ti yu'du'. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Raqué nuu ti gunaa natigu deche. Ma raca dieciocho añu naguni huará binidxaba laa. Qué lica randa ruzuhuaa be jneza. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ora bi'ya Jesús laabe, na: ―Señora, ma bianda lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ne udixhe ná luguiá be. Oraqueca bizuhuaa be jneza, ne bidii be diuxquixe Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Peru bidxiichi xaique sti yu'du que, xiñee bisianda Jesús laabe dxi que para na rabi ca binni que: ―Xhoopa gubidxa nuu para guni nu dxiiña'. Latá' tobi de ca dxi ca para guianda tu ne cadi dxi enda riziila'dxi pe'. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Para na Señor rabi laa: ―Adxé ni riní' tu, adxé ni runi tu. Lácaxa qué riné tu xpuey tu ne xpurru tu gue nisa dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yanna gunaa ri' za de Abraham, ne ma raca dieciocho añu naaze binidxaba laabe. Ñee cadi jneza ilaa be de lu ná binidxaba dxi enda riziila'dxi la? ");
INSERT INTO zaiNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ora uni' be nga bituí lú irá ni cayaani ná laabe, peru irá ca binni que cayeche né ca irá enda nandxó' ni cayuni be. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ne laca rabi be laaca': ―Chi güe nia laatu ximodo ridale ca xpinni Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Zeda gaca ni casi ti biidxi mostaza ni ucuaa ti hombre bidxiiba lu layú sti'. Birooba ni, uca ni ti yaga ro', dede biete mani huiini bi'ni lidxi lú ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Bigueta rabi be laaca': ―Nuu stobi zanda usaca nu enda runi mandar sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Zeda gaca ni casi levadura biguucha ti gunaa chonna kilu harina, ne biasa idubi naca cuba que. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Idubi neza ze Jesús Jerusalén, riaana irá guidxi ro' ne guidxi huiini', rusiidi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ra canazá be que biree tobi na, rabi laabe: ―Señor, ñee huaxié' binni zalá la? Para rabi be laaca': ");
INSERT INTO zaiNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Lauyubi guiuu tu neza ra puerta ni nabé', purti gabe ca' laatu, stale tu zacala'dxi guiuu peru qué zanda chu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Purti ora ma biasa xpixuaana yoo biseegu ra puerta' ne laatu biaana tu sin ñuu tu, zuxhidxi ná tu ne zaná tu: “Señor, Señor, bixhele guiu' du.” Oraque zacabi be laatu: “Qué ganna dia' padé laatu.” ");
INSERT INTO zaiNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Zuzulú tu gabi tu laabe: “Lácaxa cadi bidó' né du lii ne bidé' né du lii, ne bisiidi lu ndaani xquidxi du.” ");
INSERT INTO zaiNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Peru zabi be laatu: “Cadi ma gudxe laatu qué runebia'ya laatu la? Laixele de naa, binni qué iquiiñe'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Raqué nga uzulú tu gu'na tu dede xhidxi laya tu ora gu'ya tu nuu Abraham ne Isaac ne Jacob ne ca profeta ra runi mandar Dios, ne laatu ma biaana tu sin ñuu tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Purti zeeda binni de neza guete', de neza guia', de neza rindani gubidxa ne de neza riaazi gubidxa para cui ca ruaa mexa ra runi mandar Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Purti nuu caadxi ni qué risaca nezalú binni, zasaca raqué. Ne nuu ni risaca nezalú binni, qué zasaca raqué. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Dxi queca uyé caadxi fariseu ra nuu be, rabi laabe: ―Uyé, biree de ndaani guidxi ri' purti racala'dxi Herodes guuti lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Para rabi be laaca': ―Laché, lachitidxi mañoso ca de huidxe iluxe xhiiña'. Yanadxí ne ixí' zabee rua' binidxaba de binni ne zusianda laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Naquiiñe saya yanadxí ne ixí ne huidxe ti chindaya Jerusalén, purti qué rati di profeta sti guidxi jma que Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Ah Jerusalén, Jerusalén, ruuti lu ca profeta ne ruchá lu guie cani ruseenda Dios ra nuu lu'! ¡Panda que tiru huayacaladxe nutopa ca xiiñi lu' casi rutopa bere ca bere huiini sti xa xhiaa, peru qué niná lu'! ");
INSERT INTO zaiNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yanna laguuya ma chi guiaana stubi lidxi tu, ne ma qué zuuya ru tu naa dede dxi ganda dxi usisaca tu ni useenda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sicarí uca ti dxi enda riziila'dxi'. Yetó Jesús gueta ralidxi ti hombre ni risaca lade ca fariseu. Ne laca nuu xcaadxi fariseu raqué, nisi cundaachi laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nuu tobi hombre raqué huará, dxá tipa gui. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Para rabi be ca maistru de ley ne ca fariseu: ―Ñee jneza usianda cabe binni dxi enda riziila'dxi la? ");
INSERT INTO zaiNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Peru qué niná ca niní' ca'. Para ucuaa be hombre que, bisianda be laa, ne rabi be laa ma zanda chibí'. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ne óraque rabi be laaca': ―Pa ñaba ti buey o ti burru sti tobi de laatu ndaani bizé, lácaxa qué ñe nindee laame, neca dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nin qué nidxela ca xi niní' ca óraque. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ora bi'ya be cuyubi ca ra jma galán cui ca la? bilidxe be laaca', rabi be laaca': ");
INSERT INTO zaiNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ora che tu ti ra enda xheela la? cadí nirudó' laatu chi tí tu ruaa mexa', quenquita nuu stobi jma risaca chi tí raqué. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ne óraque ñeeda ni bini invitar lii que, nindisa lii nucuí stobi que. Nabé nituí lú lu óraque, ñasa lu', nibeza lu ño si ca xcaadxi que. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nga runi ora guni invitar cabe lii la? uleza de ora gueeda ni bini invitar lii, gabi lii: “Gudá', xhamigua', cherí nuu ti lugar jma galán para lii.” Zacá zasaca lu nezalú ca xcaadxi nuu raqué. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Purti tutiica uyubi isaca la? qué zusisaca iruti laa, ne tu na qué risaca la? zusisaca binni laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Oraque rabi be ni bini invitar laabe que: ―Ora gu'nu ti endaró o ti endaró xhi la? cadi cuidxi lu ca xhamigu lu', ca bi'chi lu', ca lisaa lu', ca xpecinu lu ni napa, gueda to né lii, purti zaqueca zuni cabe lii. Zaguixe cabe ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sínuque ora gu'nu endaró la? guridxi cani qué gapa gasti', cani nachangu ná', cani nachangu ñee, cani nacheepa lú. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ne nabé zieche lu', ti laacabe qué gapa cabe ni quixe cabe lii, peru zaguixe Dios lii dxi ibani cani nayá ladxidó'. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ora bina diaga tobi de cani zuba né be ruaa mexa que ni uní' be, na rabi laabe: ―Dichoso cani cui ruaa mexa ra runi mandar Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Oraque na be rabi be laa: ―Bini invitar tobi hombre stale binni chi to gueta ralidxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ora ma nuu endaró que biseenda be mozo stibe chi tidxi laaca gueda to ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Peru irá ca adxé adxé ni biree né ca'. Tobi que na: “Uzié ti layú ne naquiiñe chi guuya ni. Gudxi laabe guni perdonar be naa.” ");
INSERT INTO zaiNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Stobi na: “Nagasi uzié gaayu yunta buey. Chi guuya xi tal xa nuu came. Gudxi laabe guni perdonar be naa.” ");
INSERT INTO zaiNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Stobi na: “Nacubi bichaganaya'. Nga runi qué zanda chaa'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ora bigueta jmozo be que gudxi laabe xi irá na ca binni que. Nabé bidxiichi be ne rabi be laa: “Yeuxooñe luguiaa ne irá ca calle ndaani guidxi ri'. Yetopa cani qué gapa gasti', cani nachangu ná', cani nachangu ñee, cani nacheepa lú, dané rarí'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ora bigueta mozo que na rabi laabe: “Señor, ma bine irá ni gu'dxu naa, peru nuu ru lugar.” ");
INSERT INTO zaiNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Para rabi be laa: “Yanna, biree de guidxi, uyé lu ca neza ro' ne ca neza huiini', ne pa idxaagu tuuxa la? udubayú laaca' dané laaca para idxá lidxe de binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ne gannu cou', nin tobi de cani bine invitar que, qué zo di ca ralidxe'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nabé stale binni nanda Jesús ra ze Jerusalén, ne bitiixhi lú be rabi be laaca': ");
INSERT INTO zaiNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Pa chu' tu gueda nanda naa peru jma nadxii bixhoze ne jñaa ne xheela' ne ca xiiñi' ne bi'chi' ne biza'na', ne jma nadxii laca laa la? qué zanda gaca xpinne'. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ne tu qué na gacaná ra gueda nanda naa la? qué zaquiiñe para xpinne'. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Lácaxa nuzulú tobi hombre ti yoo sin que nirudó' nibí ñuuya chaahui pa zugaanda xpidxichi para iluxe ni. Oraque ru nuzulú ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pacaa nindaa si be cimientu ma qué ñanda nunduuxe be ni la? irá binni ñuni burla laabe, ");
INSERT INTO zaiNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","niná ca': “Hombre ca bizulú si ti yoo. Yanna ma qué ganda unduuxe'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ne zaqueca ti rey ra chi tinde né sti rey. Lácaxa cadí nirudó' nibí ñuuya chaahui pa zanda ucaa lú né chii mil si soldadu sti', stobi ni napa gande mil. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ne pa ñuuya qué zanda la? nusenda tidxi sti rey que laga nuu ru zitu, ñabi laabe racala'dxi gaca cabe tobi si ti cadi nucaa lú be laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Zacá nga laani. Tutiica de laatu qué usaana irá ni napa la? qué zanda di gaca xpinne'. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nabé riquiiñe zidi, peru pa nidi'di enda naxí sti ni la? ximodo niquiiñe ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma qué niquiiñe ni nin para ñu'cha ni yu ñaca ni abono, sínuque nusa'bi si cabe ni. Ni racala'dxi guiene la? ucaa diaga. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bidxiña irá cani ruquixe impuestu ne cani qué rulabi ley ra nuu Jesús para ucaa diaga ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ne bizulú ca fariseu ne ca maistru de ley caní' ca laabe, na ca': ―Nga puru si cani cuchee ridxaaga, ne ro né laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Para gudixhe be ti ejemplu para laaca', rabi be laaca': ");
INSERT INTO zaiNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Pa ñapa tobi de laatu ti gayuaa dendxu', ne niniti tobi me, xi ñuni be. Ñee cadi nusaana be noventa y nueve que, niyubi be laame dede ra nidxela be laame la? ");
INSERT INTO zaiNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ne ora nidxela be laame nayeche nudxiiba be laame xi'que be. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nindá né be laame ralidxi be, nibidxi be ca xhamigu be ne ca xpecinu be, ñabi be laaca': “Latá', guieche né tu naa, purti bidxela dendxu stinne ni biniti.” ");
INSERT INTO zaiNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Zacaca jma zieche né cani nuu ibá' tobi ni huachee ora inaba perdón Dios, que noventa y nueve nacha'hui ni cadi caquiiñe inaba perdón. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Chi tixhe stobi. Laga pa ñapa ti gunaa chii moneda ne niniti tobi ya'. Nee cadi nucaa gui biaani', nunduuba ndaani yoo, nuyubi chaahui dede ra nidxela ni la? ");
INSERT INTO zaiNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ne ora ma bidxela ni, ñabi ca xhamiga ne ca xpecina: “Latá' guieche né tu naa. Ma bidxela moneda stinne ni binite'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Zacaca nga rabe laatu. Nabé rieche ca ángel sti Dios ora gueda naba tobi ni cuchee perdón Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Bigueta byuí' né be laaca sti cuentu, na be: ―Uyuu tobi hombre gupa chupa xiiñi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ti dxi na ni jma nahuiini que rabi bixhoze: “Apá, dané naa bidxichi ni raca caber udiiu naa.” Para ucuaa bixhoze be ni, undaa ni lú iropa bi'chi cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Qué nindaa de ngue bitopa be irá stibe, biree be uyé be zitu. Raqué udxite be irá ni. Bibani be modo na ique be. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ne bia'si pe dxi ma birá irá stibe, guca ti gubiña ndaani guidxi ra nuu be que, ne bizulú biaadxa endaró laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Para uyé be yeyubi be dxiiña ra nuu ti hombre de guidxi que. Ne biseenda laabe chi gapa be bihui ra ranchu sti'. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Dede uyuu tiru ucala'dxi be ño be ca vaina ni cayó ca bihui que, peru iruti nudii ni laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Raqué nuu be uyuu xpiaani be, na be: “Biaa panda mozo napa bixhoze' dede riaana si ni ro ca', ne naa nuaa rarí', cayate zie'. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Zabigueta ra nuu bixhoze', ne zabe laa: Apá, bichee nia Dios ne bichee nia lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ma qué iquiiñe dia' para gapu naa casi xiiñi lu', sinuque gupa naa casi ti mozo stiu'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Para biasa be, biree be zibí' be. De zitu ru zeeda be biiya bixhoze be laabe, biá laabe. Bixooñe yechagalú laabe, gudidxi dxiichi laabe, gudó ti bixidu lucuá be. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Oraque na be: “Apá, bichee nia Dios ne bichee nia lii. Ma qué iquiiñe dia' para gapu naa casi xiiñi lu'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Peru na bixhoze be rabi ca jmozo: “Guiuba latané lari ni jma galán gacu be, ne lacuu aníu ná be ne laucaa zapatu ñee be. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ne latané yuze huiini ni jma naró' guuti nu, guni nu saa, ne guieche nu. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Purti para naa casi ñaca guti xiiñe ri' peru ma bibani, ne binite laabe peru ma bidxela be.” Ne irá cabe bieche cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Laga cayaca irá nga nuu bi'chi be lugola rañaa. Ne ora bigueta bidxiña gaxha bina diaga caxidxi saa, cuyaa cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Para guridxi tobi de ca mozo que, unaba diidxa xi cayaca raqué. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Para na mozo que rabi laa: “Ma bigueta bi'chi lu' ne biiti bixho'zo ti yuze huiini naró' purti nazaaca bigueta be.” ");
INSERT INTO zaiNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Peru nabé bidxiichi ni jma huaniisi que ne qué niná ñuu. Para biree bixhoze na rabi laa: “Biuu, xiiñe'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Oraque na rabi bixhoze: “Biaa panda iza cayune xhiiña lu' ne cuzuuba stiidxa lu', ne qué huadiiu naa nin ti chiva huiini para ñahua nia ca xhamigua'. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Peru yanna casi beeda xiiñi lu ca, ma biitu yuze huiini ni jma naró' para laa, laa nda yechite xpidxichi lu luguiá gunaa.” ");
INSERT INTO zaiNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Para na bixhoze rabi laa: “Hiju, lii la? qué hualadi lu de naa, ne irá ni napa stiu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Peru naquiiñe guni nu saa ne guieche nu, purti casi ñaca guti bi'chi lu ri' ne bibani. O casi ñaca biniti nu laabe ne bidxela be.” ");
INSERT INTO zaiNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ne laca na Jesús rabi ca discípulu sti': ―Uyuu tobi hombre ricu bisaana xpidxichi lu ná ti xpinni para guni né dxiiña'. Peru uyuu tu gudxi laabe caguite xpinni be que xpueltu be. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Para guridxi be laa ne rabi be laa: “Xii nga na cabe cayu'nu'. Yanna ulee cuenta xi bi'ni neu bidxichi bidiee lii, purti ma chi ndee lii de dxiiña'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Oraque bizulú caní' ique xpinni be que: “Xi gune yanna. Ma chi gaxha xpixuaana naa dxiiña'. Qué gapa stipa gune dxiiña naná, ne rituí lua chi naba guna. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah, ma nanna xi gune', ti ora gaxha be naa dxiiña ca la? ma nuu tu icaa naa ralidxi.” ");
INSERT INTO zaiNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Oraque guridxi be tobi tobi cani nuzaabi xpixuaana be, rabi be tobi que: “Pabiá' nuzaabi lu xpixuaana'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ti gayuaa barril aceite”, na ngue. Para rabi be laa: “Ucuaa nota stiu', guiuba gurí, bi'ni stobi de cincuenta si.” ");
INSERT INTO zaiNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Oraque rabi be stobi: “Laga lii ya'. Pabiá' nuzaabi lu xpixuaana'.” “Ti gayuaa sacu trigu”, na ngue. Para rabi be laa: “Ucuaa nota stiu'. Bi'ni stobi de ochenta si.” ");
INSERT INTO zaiNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ora gunna xpixuaana be modo udxite be laa la? bidii cuenta pabiá' nexhená be ne bichá enda naró' stibe. Zacaca nga jma nexhená ca binni zinanda guidxilayú que ca xpinni Dios, modo riguite ca binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Zacaca nga cayabe laatu guni tu. Laiquiiñe irá ni napa tu ndaani guidxilayú ri' para gapa tu stale xhamigu tu, ti ora ma qué gapa tu gasti', nuu ni cabeza laatu ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ni guni jneza ne caadxi huiini la? laca zuni jneza ne stale. Ne ni qué guni jneza ne caadxi la? laca qué zuni jneza ne stale. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nga runi pa qué zanda guni tu jneza ne bidxichi sti binni la? laca qué zuni tu jneza ne ni risaca para Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ne pa qué guni tu jneza ne ni sti binni la? iruti zudii laatu ni sti pe tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Iruti zanda gapa chupa xpixuaana', purti zaca nanala'dxi be tobi que ne zanaxhii be stobi. Pacaa jma zuni be ni na tobi que ni na stobi. Qué zanda ganaxhii tu Dios ne ganaxhii ca tu bidxichi. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Laca bina diaga ca fariseu ni uní' be que ne bi'ni ca burla laabe, purti nadxii ca bidxichi. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Peru rabi be laaca': ―Laatu ruyubi tu tidi tu pur nacha'hui nezalú binni, peru runibiá' Dios ladxidó' to. Purti ni risaca para binni la? nanala'dxi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Dxi ca'ru gueeda Juan Bautista la? ley sti Moisés ne ni uní' ca profeta nga nexhe chi nanda tu, peru dede dxi beeda Juan ma bizulú careeche diidxa ximodo runi mandar Dios, ne irá binni cuyubi chu' lú ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Peru jma qué igana ninitilú ibá' ne guidxilayú que ñaana ti puntu huiini sti ley sin ñaca. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tutiica gaca divorciar né xheela ne ichaganá stobi la? cuchee ne Dios purti casi ñaca jnadxii rairopa que. Ne tu ichaganá ti gunaa ni guca divorciar, laca cuchee né Dios purti casi ñaca nuu né xheela stobi. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Uyuu tobi hombre nabé napa bidxichi, racu puru si lari risaca ne irá dxi cayuni saa. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ne uyuu stobi hombre lá Lázaro ribí ra puerta lidxi be, rinaba guna, dxá guidxu yuudxu ladi, ");
INSERT INTO zaiNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","dede reeda bi'cu rixupi ladi. Ne neca bigú si riaba xa mexa stibe ñacala'dxi nutopa ño. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Bidxiña dxi guti Lázaro ne yené ca ángel laa ibá' ra nuu Abraham. Ne laca guti ricu que. Bicaachi cabe laabe; ");
INSERT INTO zaiNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ne laabe gabiá uyé be, ne de raqué undisa lú be, de zitu biiya be Lázaro nayeche nuu ra nuu Abraham, ne laabe cayacaná be. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Para bicaa be ridxi: “Tata Abraham, biá naa. Biseenda Lázaro ugadxe bicuini ná ne gueda usigaanda ludxe purti nabé cayuniná gui ri naa.” ");
INSERT INTO zaiNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Peru na Abraham, rabi laabe: “Hiju, bietenala'dxi gupu irá ni bieche neu dxi nabani lu', ne Lázaro nabé ucaná. Peru yanna ma cayeche be rarí', ne lii cayacaná lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ne cadi nga si nga laani, sínuque didi xiixa galahui de laanu. Qué zanda che cani nuu rarí ra nuu tu, ne qué zanda gueeda cani nuu ra nuu tu rarí'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Para na be: “Pa zacá ni la? Tata, rinaba lii useendu Lázaro ralidxi bixhoze', ");
INSERT INTO zaiNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","purti napa rua' xcaayu biche', güi né be laaca ximodo ni, ti cadi né ru sica laaca gueda gacaná ca rarí'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Oraque na Abraham: “Para nga runi napa cabe ni bicaa Moisés ne ni bicaa ca profeta. Ucaa diaga cabe xi na ca'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Co', Tata Abraham”, na be, “sínuque pa ibani tuuxa ni ma guti la? jma nagueenda zanaba cabe perdón Dios ne uchaa cabe xpia' cabe.” ");
INSERT INTO zaiNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Peru na Abraham: “Pa qué ucaa diaga cabe ni na Moisés ne ni na ca profeta la? laca qué zucaa diaga cabe neca ibani tuuxa ni ma guti.” ");
INSERT INTO zaiNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Na Jesús rabi ca discípulu sti': ―Qué ziaadxa ni uquiinde binni para uchee, peru gapa gá si ni guni ni que laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Jma galán ñaca para laa pa nugaanda cabe ti guie ngola yanni, nundaa cabe laa ndaani nisadó', que ñuni pur nuchee tobi de ca nahuiini'. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Laguuya gá qué chi guni tu zacá. Pa uchee né hermanu stiu' lii la? bilidxe laa, ne pa inaba be perdón lii la? bini perdonar laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ne pa gadxe tiru uchee né be lii ti dxi ne gadxe tiru que gueda naba be perdón lii la? bini perdonar laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Oraque na ca apóstol que rabi Señor: ―Bitale fe stidu. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Para rabi be laaca': ―Pa ñapa tu fe neca bia' ti biidxi mostaza la? ñanda ñabi tu yaga ca ñaaxha de xcu, niuzuhuaa ndaani nisadó', ne ñe ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Pa ñapa tu ti mozo nicheza layú o nigapa yuze, ñee casi ñeeda ñabi tu laa: “Gurí ruaa mexa” la? ");
INSERT INTO zaiNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Co' nja', sínuque ñabi tu laa: “Ulee xha'bu', bi'ni endaró xhi ne udiiu ni gahua xhie'. Iluxe sia', óraque ma cui lu lii, go xhiu'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Lácaxa rudii tu diuxquixe mozo que purti bi'ni ni gudxi tu laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Zacaca laatu ora ma bi'ni tu ni bisaana Dios lu ná tu la? sicarí nga lainí': “Gasti qué ñuni du purti bini du ni nexhe si guni du.” ");
INSERT INTO zaiNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ra ze Jesús Jerusalén udi'di galahui Samaria ne Galilea. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ra yendá be ti guidxi huiini biree chii hombre napa lepra, bizuhuaa ca zitu ");
INSERT INTO zaiNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ne bicaa ca ridxi laabe: ―Jesús, Maistru, biá laadu. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ora bi'ya be laaca rabi be laaca': ―Laché ra nuu sacerdote. Lachiuluí' laa ma bianda tu. Ne laga ze ca neza nisi pe byui' lepra que ladi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ora bi'ya tobi de laaca ma bianda, bigueta uxooñe', cucaa ridxi, cusisaca Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bizuxibi xa ñee be dede gudixhe ique layú, cudii diuxquixe. Ngue nda samaritanu laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Oraque na be: ―Ñee cadi chii cabe bianda la? Laga xca' que ya', uná laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ñee iruti ru qué nibigueta nusisaca Dios sínuque laga ni cadi binni laanu ri la? ");
INSERT INTO zaiNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ne óraque rabi be hombre que: ―Biasa, uyé. Bianda lu purti bini cre lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Oraque unaba diidxa ca fariseu laabe padxí uzulú guni mandar Dios. Para rabi be laaca': ―Dxi uzulú guni mandar Dios nga cadi ni ihuinni, ");
INSERT INTO zaiNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ne iruti qué zanda gabi laatu, “Rarí cayaca ni”, o “Rarica'”; purti ma cayuni mandar Dios lade tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Oraque rabi be ca discípulu stibe: ―Zadxiña dxi zacala'dxi tu gu'ya tu Hombre Biseenda Dios, neca ti dxi si, peru qué zuuya tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ziuu tu gabi laatu: “Rarí nuu be”, o “Rarica nuu be”, peru qué chi nanda tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Purti casi riuu xpiaani rayu de ti ladu para sti ladu, zacaca zaca ni dxi gueeda be sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Peru nirudó' naquiiñe acaná be ne udxii deche ca binni nuu yanna ri laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Cásica uca dxi bibani Noé, zacaca zaca dxi ibigueta Hombre Biseenda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Cayó cabe, cayé' cabe, cachaganá cabe ne cucheela cabe dede dxi biuu Noé ndaani arca ne biaba nisa guie, binitilú irá cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ne zaqueca guca dxi bibani Lot. Cayó cabe, cayé' cabe, cazí' cabe, cutoo cabe, caguu cabe biní, ne cucuí cabe yoo. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Peru casi guxha ñee Lot de ndaani guidxi Sodoma biaba gui ne azufre de ibá'. Binitilú irá cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Zacaca nga zaca ni dxi guenda sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ni dxi'ba ique yoo dxi que la? cadi guiete chi caa sti ndaani yoo. Ne zaqueca ni nuu rañaa cadi ibigueta gueda caa sti'. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Laguietenala'dxi xi uca xheela Lot. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tu gacala'dxi ulá xpida zuniti ni, peru tu uniti ni la? zalá. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ne gabe ca' laatu, ra nexhe chupa lu tobi si luuna', zie tobi que, stobi que ziaana. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ne zaqueca ra nuu chupa gunaa cayuutu', zie tobi, ziaana stobi. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Zaqueca ra nuu chupa hombre rañaa, zie tobi, ziaana stobi. ");
INSERT INTO zaiNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Oraque na ca rabi ca laabe: ―Paraa gaca ni ya', Señor. Para rabi be laaca': ―Ra nuu ti cuerpu ni ma guti, raqué nga cui zisi irá so'pe'. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Laca gudixhe Jesús ti ejemplu para usiidi laacabe iní' né cabe Dios sin iree cabe gana, ");
INSERT INTO zaiNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","na rabi laacabe: ―Uyuu ti juez ndaani ti guidxi, qué ridxibi Dios ne qué rizaala'dxi binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ne ndaani guidxi queca uyuu ti viuda, ne gatigá ma ze ra nuu be, zinaba acané be laa purti nuu tu cadinde né laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Xadxí qué niná be nulabi be laa, peru bidxiña dxi na be: “Neca qué ridxibe Dios ne qué rizaaladxe binni, ");
INSERT INTO zaiNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","peru modo canaziñe gunaa ri naa la? chi acaniá laa, ti ma cadi gueeda uchiichi ru naa.” ");
INSERT INTO zaiNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Para na Señor rabi laacabe: ―Laguuya si laatu xi na juez malu que. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ñee na tu qué zacané Dios ca xpinni ni cucaa ridxi laa ridxi ne huaxhiini la? Zandaa para icabi be laaca la? ");
INSERT INTO zaiNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Naa cayabe laatu, qué zandaa di', nagueenda zacané be laaca'. Peru nanna pa zadxela ru Hombre Biseenda Dios tu napa fe dxi ibigueta sti tiru ya'. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Bigueta udixhe Jesús sti ejemplu para cani runi laca laa jma nacha'hui que ca xcaadxi, ");
INSERT INTO zaiNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","na: ―Uyé chupa hombre ndaani yu'du ro', yení' né Dios. Tobi que fariseu, stobi que ruquixe impuestu. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Bizuhuaa fariseu que, caní' stubi na: “Rudiee diuxquixe lii, Dios, purti cadi naca casi ca xcaadxi binni. Qué ribana', cadi malu naa, qué riuaa nia ni cadi xheela', ne nin cadi naca casi ni ruquixe impuestu ri'. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Riaana sin gahua chupa tiru ndaani semana ne rune ni na ley: rune irá ni napa chii ndaa ne rudiee lii ti ndaa, cásica ni rune ganar zaqueca ni rudii layú stinne'.” Nga na fariseu que. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Peru stobi que zuhuaa zitu, nin para nindisa lú ibá' qué na', sínuque caguibi ná ladxidó', na: “Biá naa, Dios, purti nabé huachee'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ne zanda gabe laatu ora bigueta hombre malu que ralidxi, ma bia ladxidó', peru fariseu que la? co'. Purti tu udxiiba laca laa la? qué zasaca nezalú Dios, peru tu na qué risaca, zusisaca Dios laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Oraque bedané cabe caadxi xcuidi ra nuu Jesús para quixhe ná luguiá ca'. Peru ora bi'ya ca discípulu né cabe ca ba'du que, udinde né ca laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Peru guridxi Jesús ca ba'du que ne na: ―Laudii lugar gueeda ca ba'du ca ra nuaa'. Cadi ucueeza tu laaca purti stica irá ni napa Dios ladxi ná', laaca ne irá casi laaca ca. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Gabe ca' laatu ni qué gaca ladxidó' casi ladxidó' cabe ca la? qué zanda udii lugar guni mandar Dios laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Bidxiña tobi de ca xaíque sti ca judíu ra nuu Jesús, na: ―Maistru ni nacha'hui', xi gune para gapa enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Para na Jesús rabi laabe: ―Xiñee nou' nacha'hue'. Iruti ru nacha'hui jma que tobi lucha Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ma nannu xi na ca mandamientu: “Cadi chu' neu ni cadi xheela lu', cadi guuti lu binni, cadi cuana lu', cadi cueeu falsu luguiá stobi, gunaxhii bixho'zo ne jñoou'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Para na be: ―Irá nga huayune dede dxi nahuiine'. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ora bina diaga Jesús xi na be, na rabi laabe: ―Tobi si riaadxi lii. Bitoo irá ni napu', bidii ni ca pobre. Zacá zapu stale ni risaca ibá', ne dananda naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nabé ucaná ladxidó' be ora bina diaga be nga, purti nabé stale bidxichi napa be. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ora bi'ya Jesús pabiá' ucaná ladxidó' be, na: ―Aque nagana para ti ricu udii lugar guni mandar Dios ndaani ladxidó'. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jma pe qué igana tidi ti camellu xa'na ti aguxa' que udii ti ricu lugar guni mandar Dios ndaani ladxidó'. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Oraque na cani bina diaga ni: ―Pa zacá ni la? tuu ndi zanda ilá. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","―Ni qué zanda guni binni la? Dios zanda guni, na Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Oraque na Pedru: ―Laadu ya'. Bisaana du irá xixé ni napa du, para canananda du lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Para rabi be laaca': ―Gabe ca' laatu, irá ni usaana lidxi o bixhoze o bi'chi o xheela' o xiiñi' para chu' lade ca xpinni Dios la? ");
INSERT INTO zaiNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","zudii Dios laaca jma ru stale que bia' bisaana ca yanna ri', ne ora ma iree ca ndaani guidxilayú ri, zacaa ca enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Oraque ucuaa be doce discípulu stibe que, biree chu né be laaca' ne rabi be laaca': ―Laguuya', ma chuu nu Jerusalén, ne raqué chi aca irá ni bicaa ca profeta izaaca Hombre Biseenda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Zusaana cabe naa lu ná cani cadi judíu para quite ca naa ne guniná ca naa ne uchá xhinni ca lua'. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Zaguiñe ca naa ne zuuti ca naa peru raguionna gubidxa de biiti ca naa zabane'. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Qué lica ñene ca discípulu xi caní' be purti cadi nexhe guiene ca ne qué ganna ca xi cuzeete be. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ra ziyuu be ndaani guidxi Jericó zuba tobi hombre nacheepa lú uriá neza, canaba guna. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ne ora bina diaga zidi'di stale binni raqué, unaba diidxa xi cayaca. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Para rabi cabe laa: ―Jesús de Nazaret nga zidi'di racá. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Oraque bicaa ridxi: ―Jesús, Xiiñi David, biá la' naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Udinde né ca binni za niru que laabe para nigani be, peru jma rusi bicaa be ridxi: ―Biá naa, Xiiñi David. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Oraque biaana dxí Jesús, bisenda caa laabe gueeda be ra nuu. Casi bidxiña be na rabi laabe: ");
INSERT INTO zaiNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―Xi racala'dxu gune para lii. Para na be: ―Señor, racaladxe inaya'. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Oraque na Jesús: ―Ma zanda iná lu, ne bianda lu purti bini cre lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Oraqueca uná be ne yenanda be Jesús cusisaca be Dios. Ne zaqueca bi'ni irá binni biiya ra guca ni, bisisaca ca Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Biuu Jesús Jericó, ne ra zidi'di ndaani guidxi que ");
INSERT INTO zaiNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","nuu tobi hombre ricu lá Zaqueu, xaíque sti cani ruquixe impuestu. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ucala'dxi ñunibiá' laabe, peru qué ñanda purti nabé nachucu ne stale binni nuu raqué. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Biiya si qué ñanda ñuuya laabe, bixooñe uzá niru yechiba lu ti yaga, purti napa be xidé tidi be raqué. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ne ora zidi'di be ra dxi'ba que biiya be laa, na be: ―Zaqueu, guiuba biete de racá, purti napa xidé guiaana rali'dxu yanadxí. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Biete uxooñe Zaqueu, ne yené laabe ralidxi nayeche'. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ora bi'ya irá binni que yeguiaana be ralidxi Zaqueu, bizulú ca cani' ca laabe, na ca yeguiaana be ralidxi tobi ni qué runi ni na ley sti Moisés. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Oraque bizuhuaa Zaqueu ne na rabi laabe: ―Señor, zaguiize galaa de ni napa lú ca pobre, ne pa ulana sti tuuxa, zudxigueta ni tapa tiru lu ná'. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Para rabi be laa ne cani nuu raqué: ―Yanadxí ma beda ilá ni nabeza ndaani yoo ri'. Purti laca za hombre ri de Abraham, ");
INSERT INTO zaiNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ne biseenda Dios naa beda yube cani cananiti, ne beda ula'ya laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Laga cucaa diaga ca binni que laabe, gudixhe be ti ejemplu para laaca', purti ma nuu be gaxha de Jerusalén ne zácaxa ca casi chindá be raqué zabí be de rey. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Na be: ―Biree tobi hombre za lade ti familia risaca, ze ti guidxi zitu zicaa gui'chi sti para ibigueta cui de rey ndaani xquidxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Dxi ma chi iree be guridxi be chii jmozo be bidii be laaca chii moneda, ti moneda cada tobi ca', para guni né ca dxiiña laga ibigueta be. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Peru nanala'dxi ca binni xquidxi be laabe, ne bisenda tidxi ca ra zicaa be gui'chi que, qué racala'dxi ca guni mandar be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Biluxe ucuaa si be gui'chi para gaca be rey, bigueta be xquidxi be. Ne casi bigueta be guridxi be ca jmozo be que para gu'ya be xi bi'ni né ca xpidxichi be. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Beeda tobi que, na rabi laabe: “Señor, rarí nuu moneda stiu'. Ma bini ganar ni xhii.” ");
INSERT INTO zaiNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Para rabi be laa: “Galán, jneza bi'ni lu'. Purti bi'ni lu jneza ne caadxi la? zudiee lii guni mandar lu chii guidxi.” ");
INSERT INTO zaiNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","De raqué beeda stobi na: “Señor, rarí nuu moneda stiu'. Ma bini ganar ni xcaayu'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Zaqueca rabi be laa: “Zudiee lii guni mandar lu gaayu guidxi.” ");
INSERT INTO zaiNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Oraque beeda stobi na: “Señor, rarí nuu moneda stiu'. Gupa dxiiche ni ndaani ti bayu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bidxibe lii purti naduxhu lu'. Riula'dxu idale stiu' sin gu'nu dxiiña', ne ribeeu guela ra cadi lii uluu lu biní.” ");
INSERT INTO zaiNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Para rabi be laa: “Lii qué iquiiñe lu para gu'nu xhiiña'. Pur ruaa lu rihuinni qué ru'nu jneza. Pa nannu naduxhua' ne riuladxe idale stinne sin gune dxiiña', ne ribee guela ra cadi naa uluaa biní la? ");
INSERT INTO zaiNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","xiñee qué niguu lu xpueltua lu bancu, ti ora ñenda ma ñuni ganar ni caadxi ya'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ne rabi be cani zuhuaa raqué: “Lagaxha moneda ca laabe. Laudii ni ni napa chii moneda que.” ");
INSERT INTO zaiNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Para na ca': “Peru Señor, ma napa be chii.” ");
INSERT INTO zaiNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Zacá nga laani,” na be. “Cani napa zacaa ca jma, ne ni qué gapa la? dede caadxi huiini ni napa, ziaaxha. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yanna lachicaa cani nanala'dxi naa, cani qué na cue de rey. Laguuti laaca nezaluá'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Biluxe si gudixhe Jesús ejemplu que, biree ze Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ne ra yendá cabe gaxha de guidxi Betfagé ne Betania, gaxha dani lá Olivo, biseenda be chupa discípulu stibe, ");
INSERT INTO zaiNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ne rabi be laaca': ―Laché ndaani guidxi ni nuu delante ca, ne ora chindá tu raqué zadxela tu ti burru huiini', cá yaga, ni iruti huagui'ba'. Lauxhegue laame ne latané laame rarí'. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ne pa chu' tu inaba diidxa laatu xiñee cuxhegue tu laame la? lagabi laa: “Caquiiñe Señor laame.” ");
INSERT INTO zaiNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Para biree cani biseenda be que ze ca'. Ne bidxela ca laame casi gudxi be laaca que. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ne ora cuxhegue cabe burru huiini que na ca xpixuaana me rabi laacabe: ―Xiñee cuxhegue tu burru huiini ca. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Oraque rabi cabe laaca': ―Purti caquiiñe Señor laame. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Para yené cabe laame ra nuu Jesús ne gudixhe cabe caadxi xhaba cabe deche me, para bidxiiba cabe Jesús laame. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ne bichiaa cabe xhaba cabe lu neza zidi'di be. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ma para guiete cabe lu dani que bizulú irá xixé ca xpinni be cucaa ca ridxi de tantu cayeche ca'. Cusisaca ca Dios pur irá enda nandxó' ni ma biiya ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Na ca': ―Cu' Dios ndaaya ni biseenda gueda tí de rey. Ma nuu enda nayeche ibá' ne ma chi ihuinni enda nandxó' sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Lade ca binni que biree caadxi fariseu na: ―Maistru, udinde né ca xpinni lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Para rabi be laaca': ―Gabe ca' laatu, pa igani cabe la? dede ca guie ca zucaa ridxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ora bidxiña be gaxha de Jerusalén, bizulú biina be ra bi'ya be guidxi que, ");
INSERT INTO zaiNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ne na be: ―Binni Jerusalén ca', neca ma yanadxí ñene tu ximodo nilá xquidxi tu, peru qué ziene tu purti ma ga'chi ni para laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Zadxiña dxi gueeda cani nanala'dxi laatu gueda nduu le' laatu, ne zaguu cabe lindaa xquidxi tu, ne ladu tiica cuee lú tu zucaa lú cabe laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Zuuti cabe laatu ne zusaba cabe xquidxi tu ne qué zusaana cabe nin ti guie luguiá sti guie purti qué nulabi tu dxi beda ganna Dios laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Oraque biuu be ndaani yu'du ro', ne bizulú uladxi be irá cani cutoo ne cani cazí' ndaani yu'du que. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Rabi be laaca': ―Cá lu Xqui'chi Dios, lidxi be nuu para iní' né cabe laabe, peru laatu ma bi'ni tu ni lidxi gubaana'. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Irá dxi bisiidi be ndaani yu'du que, ne nisi cuyubi ca xaíque sti ca sacerdote ne ca maistru de ley ne ca xaíque sti guidxi que guuti ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Peru qué idxela ca modo guni ca ni, purti cadi cachaacha binni de ucaa diaga laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ti dxi cusiidi Jesús ca binni que ndaani yu'du ro'. Cayuí' né be laaca stiidxa Dios. Raqué nuu be beeda ca xaíque sti ca sacerdote ne ca maistru de ley ne ca xaíque sti guidxi, ");
INSERT INTO zaiNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","rabi ca laabe: ―Gudxi laadu tu nacu para cayu'nu irá ndi', o tu gudxi lii gu'nu cani. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Para rabi be laaca': ―Naa laca zanaba diidxa laatu tobi. Lagabi naa, ");
INSERT INTO zaiNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","tu biseenda Juan beda nduu nisa binni. De Dios zeeda ni la? o de binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Oraque na ca': ―Xi gabi nu laabe pue. Purti pa gabi nu Dios la? zabi be laanu xiñee qué ñuni cre nu laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Peru pa gabi nu binni la? zuchá ca binni ri guie laanu, purti runi cre ca Dios gudxi Juan xi iní'. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Oraque na ca qué ganna ca tu biseenda Juan. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Para rabi be laaca': ―Nin naa qué zabe laatu tu biseenda naa gune irá ndi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ne bizulú be gudixhe be ti ejemplu para ca binni que, na be: ―Uyuu ti hombre bizuhuaa yaga uvas lu layú sti', ne óraque biree ze sti guidxi. Bisaana ni lu ná caadxi binni gapa ni. Bindaa be guidxi ra ze be que. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Dxi ma gunda dxi iruugu uvas que biseenda be ti mozo stibe para chi caa bia' raca caber laabe. Peru gudiñe cani cayuni dxiiña lu layú que mozo que ne biseenda ca laa nisi ná'. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bigueta biseenda be sti jmozo be. Ne zaqueca ucuaa cabe laa gudiñe cabe laa, bi'ni cabe burla laa ne biseenda cabe laa nisi ná'. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Bigueta biseenda be raguionna jmozo be. Zaqueca udiñe cabe laa ne uladxi cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Oraque na be: “Xi gune yanna. Chi useenda xiiñe ni nadxiee'. Zandaca ora gu'ya cabe laa zapa xpia' cabe.” ");
INSERT INTO zaiNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Peru ora bi'ya cabe laa na cabe: “Ndi nga ni chi guiaana né irá sti bixhoze. Latá' guuti nu laa ti guiaana né nu ni laanu.” ");
INSERT INTO zaiNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ne ulee cabe laa de ndaani le' que, ne biiti cabe laa. Yanna xi na tu guni xpixuaana layú que laacabe ya'. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Zeeda, zuuti laacabe ne zudii layú que stobi. Ora bina diaga ca binni que xi na be, na ca': ―Nin qué ñacala'dxi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Peru óraque biiya dxi be laaca' ne na be: ―Pa cadi zacá ni la? xi riní' Xqui'chi Dios ra na: Guie ni bisa'bi cani cucuí yoo que, guie que pe naaze yoo que yanna. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tu guiaba lu guie que, zacaná, peru tu gueda guiaba guie que luguiá la? zacadé. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ucala'dxi ca xaíque sti ca sacerdote ne ca maistru de ley que, ninaaze ca laabe purti nanna ca gudixhe be ejemplu que para laaca'. Peru bidxibi ca ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Para biseenda ca caadxi tu chi undaachi laabe, inaba diidxa laabe xiixa, casi ñaca racala'dxi ca ganna ca xi na be, peru para idxela si ca modo inaaze ca laabe para utiidi ca laabe lu ná gobernador. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Na ca rabi ca laabe: ―Maistru, nanna du jneza riní' lu' ne jneza rusiidi lu'. Qué rulabi lu tutiica naca binni, sínuque rusiidi lu modo pe racala'dxi Dios sa binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gudxi laadu pa jneza quixe nu lu ná César o pa co'. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Peru maca nanna be xi cá ique ca' para rabi be laaca': ―Xiñee racala'dxi tu usaba tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Latané moneda ca guuya'. Tu cá lú ni. Para na ca': ―César. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Oraque rabi be laaca': ―Laudii César sti César, ne laudii Dios sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bidxagayaa ca modo bicabi be laaca', ne dxi do' uyuu ca' purti qué nidxela ca modo nusaba ca laabe nezalú ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ne laca beeda caadxi saduceu ra nuu be, cani qué runi cre pa dxandí zabani gue'tu'. Ne na ca rabi ca laabe: ");
INSERT INTO zaiNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maistru, bicaa Moisés lu gui'chi pa chu' ti hombre ichaganá ne gueda gati, qué ñapa xiiñi la? naquiiñe ichaganá bi'chi be xheela be ne gapa xiiñi casi ñaca xiiñi be. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Uyuu gadxe bi'chi'. Bichaganá lugola que ne beda gati, qué ñapa xiiñi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Para bichaganá rairopa que gunaa que ne laca guti, qué ñapa xiiñi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","De raqué bichaganá raguionna que gunaa que, ne zaqué bichaganá idubi gadxe que gunaa que, ne guti ca'. Nin tobi ca qué ñapa ca xiiñi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ne laca guti gunaa que. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Yanna ora ibani gue'tu ya', uná de laacabe xheela gunaa que, purti idubi gadxe cabe bichaganá cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Para rabi be laaca': ―Laga nuu binni ndaani guidxilayú ri la? richaganá ca' ne rucheela ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Peru cani ma cá lá guiasa de lade gue'tu para ibani ndaani guidxilayú cubi la? qué zachaganá ca ne qué zucheela ca'; ");
INSERT INTO zaiNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","purti ma qué zati ca', sínuque ma naca ca casi ca ángel, ne zahuinni dxandí xiiñi Dios laaca ra usibani laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Dede Moisés bisiidi zabani gue'tu'. Cá ni lu gui'chi ra biiya be dxa yaga caya'qui que. Rabi be Dios Dios sti Abraham, ne sti Isaac, ne sti Jacob. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dios la? cadi Dios sti gue'tu laa, sínuque Dios sti cani nabani, ne para laabe nabani irá binni, neca ma guti. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Oraque na caadxi de ca maistru de ley: ―Jneza uníu', Maistru. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ne ma qué ñuni ru ca pur ninaba diidxa ca laabe gasti'. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ne rabi be laaca': ―Ximodo nga na tu xiiñi David Cristu ya'. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Purti dede David bicaa lu Salmo: Na Dios rabi Señor stinne': “Gurí cuee' ");
INSERT INTO zaiNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","dede ora ma udixhe cani nanala'dxi lii xañee lu'.” ");
INSERT INTO zaiNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Pa rabi David laabe Señor sti la? ximodo xiiñi David laabe ya'. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Irá binni que bina diaga ora rabi be ca discípulu stibe: ");
INSERT INTO zaiNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Laguuya gá laatu né ca maistru de ley, purti riula'dxi ca gacu ca lari de yanni ñee ca para uluí' naca ca tuuxa, ne ugapa diuxi binni laaca luguiaa. Ne riula'dxi ca cui ca ndaani yu'du ra ribí binni ni jma risaca, ne zaqueca ra endaró. ");
INSERT INTO zaiNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Raxha ca lidxi ca viuda, ne óraque riní' né ca Dios xadxí para si uluí' nacha'hui ca'. Laaca nga jma naná ziaba ná ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Undisa lú be biiya be ra cusaba ca ricu vueltu ndaani caja ra riaba ni usiga'de cabe Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ne biiya be bisaba ti viuda pobre chupa de gaayu huiini'. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Para na be: ―Gabe ca' laatu, jma stale bisaba viuda ri' que ca xcaadxi ca. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Purti ca xcaadxi ca bidii ca Dios ni ma biaana si stica', ne laabe huaxié' napa be peru bisaba be irá ni napa be para ibani né be. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bizulú tuuxa cuzeete pabiá' sicarú yu'du ro' que modo zuchaahui ni ne ca guie ne irá ni huasiga'de cabe Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Para rabi be laaca': ―Irá ni cayuuya tu nagasi ri la? ziuu dxi initilú cani, dede qué ziaana ti guie luguiá sti guie. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Para na ca': ―Maistru, padxí gaca irá ndi ya' ne ximodo ganna du ora ma chi aca ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Oraque rabi be laaca': ―Laguuya gá qué chi chite cabe laatu, purti zeeda stale ni usiguii, zaná ca laaca nga Cristu, ne ma bidxiña hora. Peru cadi chi nanda di tu laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ne ora ganna tu cayaca guerra ne cadinde cabe rarí rarica', cadi idxibi tu, purti naquiiñe sa niru irá nga, peru ca'ru idxiña dxi iluxe ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ne laca rabi be laaca': ―Ziasa ti guidxi ucaa lú sti guidxi. Zaqueca ziasa ti gobiernu ucaa lú sti gobiernu. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Zaca stale xu ro', ne stale guidxi zaca gubiña ne enda huará. Zaree xiixa ibá' ne zadxibi binni ora gu'ya ni, ne laca zahuinni seña ro' ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Peru para gaca irá nga la? nirudó' zanaaze cabe laatu ne zazabi nanda cabe laatu ne zinduu cabe xqueja tu ra yu'du ne ra nuu rey ne gobernador, ne zuseguyoo cabe laatu. Irá nga zuni cabe laatu purti xpinne laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Peru nga zacané para güí tu stiidxa nezalú cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Cadi cu' xaíque tu naquiiñe quixhe chaahui tu xi iní' tu para usihuinni tu cadi cuchee tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Purti naa zudiee diidxa laatu ne enda biaani para useegu tu ruaa tutiica ucaa lú laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ne dede bixhoze tu ne jñaa tu zuluí' laatu. Ne zaqueca zuni ca bi'chi tu ne ca lisaa tu ne ca xhamigu tu, ne zuuti ca caadxi de laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ne irá binni zaca nanala'dxi laatu purti xpinne laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Peru nin ti guicha ique tu qué zanitilú. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pa qué ixhacala'dxi tu la? zalá tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ne ora gu'ya tu ma naguu soldadu le' Jerusalén la? lagana ma bidxiña dxi initilú ni ngue. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Oraque cani nuu Judea uxooñe lu ca dani, ne cani nuu ndaani guidxi cadi iree. Cani nuu rañaa la? cadi ibigueta ndaani guidxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Purti ca dxi que nga quixe cabe irá ni bi'ni cabe para gaca ni casi cá lu Xqui'chi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Naná zaca para ca gunaa ni naca xiiñi ne cani cugadxi ca dxi que purti nabé nagana zaca ni para irá binni guidxi que ne naná ziaba ná ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Zati caadxi lu guerra ne xcaadxi ziné cabe laa adxé adxé guidxi. Zutu ñee cani cadi judíu guidxi Jerusalén bia' dxi udii Dios lugar laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Oraque zahuinni seña ibá', adxé zahuinni gubidxa ne beeu ne ca luceru. Ne irá binni guidxilayú zadxibi dede qué zadxela xi guni ora guna diaga pabiá' reciu caxidxi cadiñe ntaa nisadó'. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Zadxibi binni dede zieegu', purti ma nuu xizaa xi chi aca ndaani guidxilayú. Zaniibi dxacha irá ni cá ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Oraque zuuya cabe Hombre Biseenda Dios, zeeda lade za de ria'qui biaani ne stale enda nandxó'. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ora gu'ya tu uzulú gaca irá nga la? lauzuhuaa chaahui', laindisa ique purti ma cadxiña dxi ilá tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ne laca udixhe be ti ejemplu para laaca', rabi be laaca': ―Laguuya ca yaga du'ga ne ca xcaadxi yaga. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ora ma cabee ni biitu la? ma nanna tu ma zeeda tiempu enda nandá'. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Zacaca nga ora gu'ya tu gaca irá nga, ma nanna tu ma bidxiña dxi guni mandar Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Dxandí cayabe laatu, irá ndi zaca ante gati ca binni nuu yanna ri'. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ziuu dxi initilú ibá' ne guidxilayú, peru stiidxa qué ziaana sin gaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Laguuya gá laatu cadi ma canazá tu canaxudxi tu ne nisi icá ique tu ni ricá ique binni ni qué runibiá' Dios. Pacaa zaguidxi ladxidó' to, ne nin ganna tu mala zanaaze dxi que laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Purti ziaba ni luguiá irá binni guidxilayú casi ti trampa. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nga runi lagataná. Cadi guiaana dxí tu de iní' né tu Dios para ganda ilá tu de irá ni chi gaca ca, ne zacá zanda uzuhuaa tu nezalú Hombre Biseenda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Irá dxi idubi dxi rusiidi be ndaani yu'du ro'. Huaxhinni riguiaana be lu dani Olivo. ");
INSERT INTO zaiNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ne siadó' ro' ma ze binni ndaani yu'du que, ziucaa diaga laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ma zeda yuba pascua, saa ro' sti ca judíu ra ro ca pan sin levadura. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ne qué idxela ca xaíque sti ca sacerdote ne ca maistru de ley modo guuti ca Jesús, purti cadxibi ca ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Oraque uyuu binidxaba ndaani ladxidó' Judas, Judas Iscariote, tobi de lade doce discípulu que, ");
INSERT INTO zaiNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","uyé ra nuu ca xaíque sti ca sacerdote ne ca xaíque sti cani rapa ra yu'du ro', yegüí né laaca ximodo guluí' Jesús laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nabé bieche ca' ne biaana né ca laabe udii ca laabe vueltu. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Bisiguenda be ne dede dxi que ma nisi cuyubi be ximodo uluí' be Jesús laaca sin ganna binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Dxi pe ro cabe pan sin levadura, dxi ruuti cabe dendxu huiini rusiga'de cabe Dios que, ");
INSERT INTO zaiNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","na Jesús rabi Pedru ne Juan: ―Laché lachiguni chaahui ra idó' xhi nu pascua ri'. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Oraque na ca': ―Paraa racala'dxu guni chaahui du. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Para rabi be laaca': ―Biaa gu'ya tu, ora chindá tu ndaani guidxi zadxaaga tu tobi hombre nua ti rii nisa, lachinanda laa dede ra guiuu. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ne lagabi xpixuaana yoo que, na Maistru paraa nga go xhi né ca discípulu sti pascua ri'. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ne óraque zuluí' laatu ti cuartu ro' rairopa pisu ma nexhe chaahui'. Raqué laguni chaahui para idó' xhi nu. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Para biree ca uyé ca ne bidxela ca casi gudxi be laaca'. Ne raqué bini chaahui ca endaró xhi para pascua que. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ora gunda hora go xhi cabe gurí né be ca apóstol stibe ruaa mexa'. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ne rabi be laaca': ―Qué ganna tu pabiá' napa gana gahua xhie nia laatu pascua ri ante gate'. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Purti gabe ca' laatu, qué zahua rua' ni dede ora ma bidxiña dxi guni mandar Dios, dxi ma bihuinni xi irá riní' pascua. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ne óraque ucuaa be ti copa. Bidii be diuxquixe Dios ne na be: ―Laicaa ndi', lagué' irá tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Purti gabe ca' laatu, ma qué zee rua' nisa uvas dede ora ma bizulú guni mandar Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ne óraque ucuaa be pan, bidii be diuxquixe Dios ne gudiizi be ni lú ca', rabi be laaca': ―Ndi nga cuerpu stinne ni chi udiee pur laatu. Laguni casi cayuni nu ri' para guietenaladxi tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ne zaqueca bi'ni né be copa que. Biluxe si gudó xhi cabe, ucuaa be ni, ne na be: ―Copa ri nga rini stinne ni chi ixii pur laatu. Ne ra ixii ni zaguixhe Bixhoze ti modo cubi chu' né binni laa tobi si. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Peru lu mexa ri tobi si nexhe naya ne ná ni chi utoo naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Dxandí naquiiñe tidi Hombre Biseenda Dios irá ni nexhe tidi', peru gapa gá si ni chi utoo laabe que laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Oraque bizulú ca discípulu canaba diidxa saa ca tu de laaca chi guni ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ne laca ucuaa yu ca' uná de laaca jma zasaca. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Peru rabi be laaca': ―Nanna tu modo runi mandar ca rey ndaani guidxilayú, runi stica irá ni runi mandar ca', ne rudxiiba cabe laaca purti na cabe cayaca né ca laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Peru laatu cadi guni tu zacá, sínuque ni jma risaca lade tu la? gaca casi tobi ni jma huaxié', ne ni sa niru la? gaca casi jmozo ca xcaadxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Uná nga ni jma risaca, ni zuba ruaa mexa la? o ni caguixhe endaró. Ni zuba ruaa mexa xa. Peru naa nuaa lade tu casi tobi ni riguixhe endaró. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Laatu huayuu né tu naa lu irá ni nagana huadide'. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nga runi zudiee guni mandar tu casi bidii Bixhoze ni naa, ");
INSERT INTO zaiNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ti gue né tu naa ne go né tu naa ruaa mexa ra gune mandar. Ne zaca tu juez sti irá ni za de idubi doce xiiñi Israel. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Oraque na be: ―Simón, Simón, biiya gá lii, ma gunaba binidxaba laatu para uniibi dxacha laatu casi ora riguibi cabe semiá. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Peru ma unaba lu Dios pur lii cadi guiaadxa fe lii. Ne ora ma biasa lu sti tiru la? ucané ca hermanu stiu' uzuhuaa chaahui ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Para na Pedru: ―Señor, ma nuaa listu cadi para guieguayuaa nia sia' lii, sínuque dede para gate nia pia' lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Oraque rabi be laa: ―Pedru, gabe ca' lii, yanna gueela ca, zaníu' qué runibióu' naa chonna tiru ante guunda gallu. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ne rabi be laaca': ―Dxi biseenda laatu xie ñee tu ne qué niné tu ixhiapa nin vueltu, ñee biaadxa laatu xiixa la? ―Gasti qué ñaadxa laadu, na ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Para rabi be laaca': ―Yanna, tu napa ixhiapa la? icaa ni, ne tu napa vueltu la? icaa xpueltu. Ne tu qué gapa espada la? utoo xhaba sí tobi. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Purti napa xidé gaca ni cá lu Xqui'chi Dios ra ruzeete ni de naa, na ni: “Bitiidi cabe laabe de malu.” Irá ni cá lu Xqui'chi Dios de naa napa xidé gaca yanna. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Oraque na ca': ―Señor, rarí nuu chupa espada. ―Ne nga si zugaanda, rabi be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ne óraque biree be ze be lu dani Olivo casi runi be irá tiru, ne yenanda ca discípulu stibe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ora yendá cabe raqué rabi be laaca': ―Lainí' né Dios ti cadi uquiinde binidxaba laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Para bixele be de laaca bia' rilá ti guie, ne bizuxibi be uní' né be Dios, ");
INSERT INTO zaiNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","na be: ―Bixhoze', pa racala'dxu la? bilá naa de enda naná ni cabeza naa ri'. Peru cadi gaca ni rabe', sínuque ni na lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Oraque bidxiña ti ángel de ibá' ra nuu be, bidii stipa laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ne jma rusi bizulú be uní' né be Dios bia' gunda ti', purti nabé nuu yuuba ladxidó' be. Dede biasa ti nisa luna mboolo luguiá be, ruluí' rini ne biaba cani layú. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Biluxe uní' né si be Bixhoze be, biasa be uyé be ra nuu ca discípulu. Ne yendá be laaca nisiaasi ca', purti nuu ca triste. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Para rabi be laaca': ―Xiñee nisiaasi tu. Laguiasa ne lainí' né Dios ti cadi uquiinde binidxaba laatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Caní' ru be biuu jma binni ra nuu cabe. Tihua Judas, tobi de lade doce discípulu stibe que, za niru lú ca', ne casi biuu bidxiña gudó ti bixidu lucuá be. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Oraque rabi be laa: ―Judas, ñee ne bixidu guluí' lu Hombre Biseenda Dios la? ");
INSERT INTO zaiNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ne ora bi'ya cani nuu né Jesús raqué xi chi aca la? na ca': ―Señor, ñee zucá' lú nu laacabe ne espada la? ");
INSERT INTO zaiNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ne óraque bininá tobi de laacabe ti mozo sti sacerdote gola ne guxha ti diaga mozo que ladu derechu. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Para rabi be laaca': ―Lausaana nga, bia' cati'. Ne óraque guda'na be diaga hombre que para bianda. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Oraque rabi be cani beeda ra nuu be que, ca xaíque sti ca sacerdote, ne cani rapa ra yu'du ro' ne ca xaíque sti guidxi: ―Ñee gubaana zeda naaze tu la? Né pe tu espada ne palu. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Inque ti dxi uyuaa nia laatu ndaani yu'du ro' ne qué ñuni tu pur ninaaze tu naa. Peru ma bidxiña ora gaca ni na tu ne ni na binidxaba'. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Oraque unaaze ca laabe, yené ca laabe ralidxi sacerdote gola, ne yenanda Pedru laabe zitu zitu. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ne bi'ni ca binni que ti gui lu patiu que ne gurí ca idubi vuelta gui que. Laca gurí Pedru lade cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ora bi'ya ti criada zuba be raqué biiya dxí laabe ne na: ―Nguiiu ri laca uzá né laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Peru qué niná be niní' be pa xpinni Jesús laabe, para na be rabi be gunaa que: ―Qué runebia'ya dia' hombre ca. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Qué nindaa de ngue biiya stobi laabe, ne na rabi laabe: ―Lii laca de laacabe lii. Peru na be: ―Co' hombre, cadi de laa di cabe naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Udi'di bia' ti hora de ngue biree stobi cá tema: ―Dxandí ne laabe uzá né be hombre ca, purti binni Galilea laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Para bigueta na be: ―Cadi lica cayene xi caní' tu, hombre. Nin ca'ru lica iluxe iní' be ngue ora bi'nda ti gallu. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ne bidxigueta lú Señor biiya dxí laabe. Oraque bietenala'dxi be ca diidxa ni gudxi Señor laabe que, ante guunda gallu, zaní' be chonna tiru qué runibiá' be laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Para biree be de raqué, yeguuna be dede uyuu yuuba ladxidó' be. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ucuaa ca hombre ni cayapa Jesús que laa. Gudiñe ca laa ne bini burla ca laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bindiibi ca lú be ne gudapa ca laabe, ne na ca iní' be tu gudapa laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ne birá ru ni gudxi ca laabe para guni burla si ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ora birá gueela sti dxi que, bidxiña ca xaíque sti guidxi que, ne ca xaíque sti ca sacerdote ne ca maistru de ley. Ucuaa ca laabe ne bichiña ca laabe ra nuu irá justicia stica'. Ne raqué na ca': ");
INSERT INTO zaiNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Gudxi laadu pa lii nga Cristu, ni nexhe useenda Dios que. Para rabi be laaca': ―Neca pe gabe laatu qué zuni cre tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ne pa inaba diidxa laatu xiixa qué zacabi tu, ne qué zundaa tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Peru dede yanna ma chi tí Hombre Biseenda Dios cue' Dios ni nandxó'. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","―Lii nga Xiiñi Dios pue la? na irá ca'. Para rabi be laaca': ―Laatu caní' tu ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Oraque na ca': ―Xi jma ru caquiiñe ganna nu, purti ma bina diaga nu de ruaa pe be. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Para biasa irá ca ucuaa ca laabe, yené ca laabe ra nuu Pilatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ne bizulú ca uluu ca xqueja be, na ca': ―Una'ze du hombre ri caguite ca binni xquidxi du. Cayabi be laaca cadi naquiiñe quixe ca lu ná gobiernu, ne laca na be laabe nga Cristu ni zeda tí de rey. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Oraque na Pilatu rabi laabe: ―Ñee lii nga rey sti ca judíu la? ―Laca lii caníu' ni, na be. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Para na Pilatu rabi ca xaíque sti ca sacerdote ne ca binni que: ―Gasti donda qué idxela luguiá hombre ri'. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Peru jma rusi ucuá ca tema, na ca': ―Cusiidi be binni ucaa lú gobiernu. Bizulú be Galilea ne zacá uzá be idubi Judea, ne yanna ma bedandá be rarí'. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ora bina diaga Pilatu xi na cabe, unaba diidxa pa binni Galilea laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ne ora gudxi cabe laa binni Galilea laabe la? biseenda laabe ra nuu Herodes, purti laa naca gobernador de Galilea, ne bia'si pe nuu Jerusalén ca dxi que. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ma xadxí napa Herodes gana gu'ya laabe purti nabé huayuna diaga de laabe ne cabeza gu'ya guni be ti milagru. Ngue runi nabé bieche ora bi'ya laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ne birá ni unaba diidxa laabe, peru nin ti diidxa qué nicabi be laa. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nuu ca xaíque sti ca sacerdote ne ca maistru de ley raqué. Cadi cayaana dxí ca de caguu ca xqueja be. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ne óraque bizulú Herodes ne ca soldadu sti' udxite ca laabe, ne para guni burla ca laabe bigacu ca laabe ti lari sicarú ni racu rey, ne bidxigueta laabe ra nuu Pilatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dxi que ru uyuu Herodes ne Pilatu tobi si, purti nanala'dxi saa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Oraque guridxi Pilatu ca xaíque sti ca sacerdote ne ca xaíque sti guidxi que ne ca binni guidxi que, ");
INSERT INTO zaiNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ne na rabi laaca': ―Bedané tu hombre ri ra nuaa purti na tu canaguite be binni, peru ma gunaba diidxa laabe nezalú tu ne qué nidxela gasti donda luguiá be de ni na tu cayuni be ca. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nin Herodes qué nidxela gasti luguiá be, nga runi ma bidxigueta laabe ra nuu nu. Qué huayuni be gasti para gati be. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Chi usaba naya laabe ne undaa laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Irá iza saa pascua napa Pilatu xidé undaa ti presu. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Peru irá binni que bizulú ca bicaa ca ridxi: ―Biiti laabe ne bindaa Barrabás. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ne Barrabás nda yeguyoo purti udxite ique binni ucaa lú gobiernu ne laca purti biiti binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bigueta uní' Pilatu racala'dxi undaa Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Peru jma rusi reciu bicaa ca binni que ridxi: ―¡Bicaa laabe lu cruz! ¡Bicaa laabe lu cruz! ");
INSERT INTO zaiNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bigueta na Pilatu raguionna tiru: ―Xi huayuni be ni cadi jneza, purti qué idxela dia' xi bi'ni be para gati be. Zusaba naya sia' laabe ne zundaa laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Qué ñaana dxí ca binni que, sínuque jma rusi reciu bicaa ca ridxi icá be lu cruz. Raqué nuu ca cucaa ca ridxi, laaca ne ca xaíque sti ca sacerdote, dede bicuudxi ca Pilatu. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Para na Pilatu zaa gaca ni na cabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ne óraque bindaa ni unaba cabe que, ne bisaana Jesús lu ná cabe. Barrabás nda yeguyoo purti bicaa lú gobiernu ne biiti binni. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Biree né cabe Jesús, ziné cabe laa. Ne ra ze cabe que, bidxaaga cabe ti hombre de Cirene lá Simón, casi zeeda de gui'xhi'. Para biguá' cabe laa cruz que ne zinanda né ni laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Laca zinanda stale binni laabe, ne ze stale gunaa ziucaa ca ridxi ziyuuna né ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Peru bitiixhi lú be biiya dxí be laaca ne rabi be laaca': ―Gunaa de Jerusalén ca', cadi gu'na tu pur naa, sínuque laguuna pur laca laatu ne pur xiiñi tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Purti zadxiña dxi na cabe: “Dichosa cani qué ñanda ñapa ba'du', cani qué nixana, ne cani qué nugadxi.” ");
INSERT INTO zaiNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ne ca dxi que zaní' binni, pa ñanda si ñaba dani ro' ne dani huiini luguiá ca' para nuchii laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Purti pa dede naa cayuni cabe sicarí la? xi aca xa de laatu ya'. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ra ziné cabe laabe que laca ziné cabe chupa gubaana gati né laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ne casi yendá cabe ti lugar ni rabi cabe Calavera la? raqué bicaa cabe laabe lu cruz, ne bicaa cabe ca gubaana que, tobi ladu derechu ne stobi ladu biga'. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Oraque na be: ―Bixhoze', bini perdonar laacabe, purti qué ganna cabe xi cayuni cabe. Ne uluu ca soldadu que xhaba be lu rifa, ne cada tobi ucuaa ni gulee. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Zuhuaa stale binni, cayuuya'. Ne ca xaíque stica cayuni burla laabe, na ca': ―Hualá be stobi, yanna ulá be laca laabe pa huandí laabe nga Cristu ni ulí Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Laca bini asariar ca soldadu que laabe, bidxiña né ca vinagre, bidii ca laabe, ");
INSERT INTO zaiNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ne na ca': ―Pa huandí rey sti ca judíu lii la? bilá laca lii. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Cá caadxi diidxa xaíque be, cá ni diidxa griegu, latín, ne hebreu, na ni: “Ndi nga rey sti ca judíu.” ");
INSERT INTO zaiNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ne bizulú tobi de ca gubaana cá lu cruz que bini burla laabe: ―Pa huandí Cristu lii la? bilá lii ne bilá laadu. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Para gudinde né stobi que laa, na rabi laa: ―Ñee qué ridxi'bu Dios la? nin ne nuu né nu laabe lu enda guti ri'. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Para laanu la? jneza gudixhe cabe ni, purti rarí nga caguixe nu saca irá ni bini nu, peru laabe la? qué huayuni be gasti ni cadi jneza. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ne na rabi laabe: ―Jesús, bietenala'dxi naa ora gueda guni mandar lu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Para na be: ―Yanadxí ca ziuu neu naa ra nuu enda nayeche sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ne bia' galaa dxi bicahui idubi guidxilayú ne zaqué biaana ni dede bia' las tres. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bicahui lú gubidxa ne ureza cortina nanda ndaani yu'du ro', galaa, galaa. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Oraque bicaa be ridxi: ―Bixhoze' ucuaa espíritu stinne'. Ngue si uní' be, guti be. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ora bi'ya capitán sti ca soldadu que irá ni cayaca, bisisaca Dios, na: ―Dxandí nayá ladxidó' hombre ri'. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ne irá binni ni yeguuya ni uca que bigueta ca ralidxi ca', ziguibi ná ca ladxidó' ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Peru irá cani runibiá' laabe ne ca gunaa ni yenanda laabe dede Galilea zuhuaa ca zitu, cayuuya ca ni cayaca que. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Lade ca justicia sti ca judíu zeeda tobi hombre lá José, binni Arimatea de Judea. Nabé nacha'hui be ne runi be jneza. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ne laca cabeza be idxiña dxi guni mandar Dios, ne qué ñuu né be ca xcaadxi justicia ra gudixhe ca xi aca Jesús ne ra bi'ni ca ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Uyé be ra nuu Pilatu, yenaba be laa cuerpu sti Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yendete be ni lu cruz ne bichenda be ni ti lari gueela ne bicaachi be ni ndaani ti ba' ni udaañe cabe cue' ti guie, ra iruti huagaachi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Uca ni viernes bia' ziyaazi gubidxa, ma para uzulú dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Laca uyé ca gunaa ni beda nanda Jesús dede Galilea que, ne biiya ca modo guta cuerpu sti Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ne ora bigueta ca udixhe chaahui ca guixi rindá' naxhi ne nisa rindá' naxhi. Ne biziila'dxi cabe casi cá lu ley guni binni dxi que. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo siadó' ro' ucuaa cabe irá ni gudixhe chaahui cabe que, uyé cabe ra ba', ne yené xcaadxi gunaa laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ne ora yendá cabe ma biduuba guie ye'gu ruaa ba' que. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Para biuu cabe ndaani ba' que, peru ma cadi nexhe cuerpu sti Señor Jesús raqué. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Raqué nuu cabe, qué idxela cabe xi guni cabe, mala biiya cabe zuhuaa chupa hombre cue' cabe, ruzaani xhaba ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nabé bidxibi cabe ne bisaba ique cabe layú. Para na ca': ―Xiñee cuyubi tu ni nabani lade gue'tu'. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ma qué guinni di be rarí'. Ma bibani be. Laguietenala'dxi xi uní' be dxi nuu ru be Galilea, ");
INSERT INTO zaiNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","gudxi be laatu nexhe inaaze ca hombre malu Hombre Biseenda Dios para ucaa ca laa lu cruz, peru raguionna gubidxa zabani. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Oraque ru bietenala'dxi cabe dxandí uní' be ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","De ra ba' que biree cabe yetidxi cabe ni ca apóstol ne ca xcaadxi ni uzá né Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Cani yetidxi ca apóstol que nga María Magdalena ne Juana ne María jñaa Jacobo ne ca xcaadxi gunaa que. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Peru para laaca ruluí' enda huati si ni caní' cabe que, ne qué ñuni cre ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Peru biasa uxooñe Pedru uyé ra ba' que, ne ora uluu lú ndaani ba' que, biiya ma lari gueela si nexhe raqué. Qué irá idxagayaa de ni uca que, biree zibí'. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dxi queca biree chupa de ca binni ni uzá né Jesús dxi canazá ru', ze ca Emaús, bia' once kilómetru de Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ziyuí' ca irá ni uca ca dxi que. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ne laga ziyuí' ca diidxa bidxiña Jesús ra nuu ca' ne ziné laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Peru neca biiya ca laabe, casi ñaca qué ñuuya ca', purti qué ñunibiá' ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ne na be rabi be laaca': ―Ruuya nabé triste nuu tu. Xii nga zeda yuí' tu neza. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Para na tobi de laaca', lá Cleofas, rabi laabe: ―Irá binni nanna xi uca ndaani guidxi Jerusalén ca dxi ri'. Ñee lii siou' lade irá ni biete raqué qué gannu ni la? ");
INSERT INTO zaiNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","―Xi laa, rabi be laaca'. Para na ca': ―Cuze'te du ni uca Jesús de Nazaret, ti profeta nandxó' nezalú Dios ne nezalú irá binni. Rihuinni nandxó' be pur ni bi'ni be ne ni uní' be. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Cayuí du modo gudixhe ca xaíque sti ca sacerdote ne ca justicia stidu gati be, ne bicaa ca laabe lu cruz. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Laa nda du zácaxa du laabe nga chi ulá be ca binni Israel. Ne ma raca chonna gubidxa de guca irá nga, ");
INSERT INTO zaiNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","peru cadi nga si nga laani purti yanna nabé cadxagayaa du pur ni gudxi caadxi gunaa laadu, laca de laadu. Nacanda ru uyé cabe ra ba' ");
INSERT INTO zaiNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ne qué nidxela cabe cuerpu stibe. Ora bigueta cabe gudxi cabe laadu biiya cabe casi ti ángel ne gudxi laacabe ma bibani be. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Laca uyé xcaadxi de laadu, yeguuya ra ba' que. Ne dxandí', casi na ca gunaa que zaqué nuu ni. Peru qué ñuuya ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Oraque na Jesús rabi laaca': ―Aque huaxié' riene tu xa. Rindaa para guni cre tu irá ni uní' ca profeta. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ñee cadi maca nexhe tidi Cristu irá nga para chu' lu enda risaca sti la? ");
INSERT INTO zaiNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ne bisiene be laaca irá ni cá lu Xqui'chi Dios ra ruzeete ni laabe. Bizulú né be ni bicaa Moisés ne biluxe be ra birá ni bicaa ca profeta. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ora yendá cabe guidxi ra ze cabe que, bi'ni be sica ni ze be jma zitu, ");
INSERT INTO zaiNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","peru ucuá ca lú be guiaana be, na ca': ―Biaana né laadu rarí'. Ma huadxí ndi', ma chi guiaazi gubidxa. Para biuu be ralidxi ca', biaana né be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ne ra zuba cabe ruaa mexa', chi to xhi cabe, ucuaa be pan ni nexhe raqué, bidii be diuxquixe Dios para undaa be ni, bidii be ni laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Oraque ru', sica ni bixele lú ca' binibiá' ca laabe. Peru ma qué ñaana ru be lú ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ne na ca': ―Ñee cadi de biniibi dxacha ladxidó' no ra zedané be laanu neza ziupa nu, ne ra bisiene be laanu xi na Xqui'chi Dios la? ");
INSERT INTO zaiNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Oraqueca biasa cabe bigueta cabe Jerusalén, biyubi cabe ra nuu once discípulu que ne cani nuu né laaca raqué. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Oraque na ca discípulu rabi laacabe: ―Dxandí bibani Señor. Ma biiya Simón laabe. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Para byuí' né cabe laaca xi uca cabe neza, ne modo binibiá' cabe laabe ora undaa be pan. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Cayuí' ru ca de nga, mala bizuhuaa be galahui de laaca', bigapa diuxi be laaca', na be: ―Gata dxí ladxidó' to. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Laaca la? bidxibi ca dede cayaca diti ca'. Zácaxa ca tentación cayuuya ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Para rabi be laaca': ―Xiñee cadxibi tu. Xiñee cadi cayuni cre tu. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Laguuya bata naya ne bata ñee', guuya tu naa pia' ndi'. Laca'na guuya tu napa dxita lade' ne beela. Ti tentación la? qué gapa nga. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ne laga cayabi be nga laaca la? biluí' be laaca ná be ne ñee be. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Peru tantu cayeche ca ne cadxagayaa ca la? dede qué ganda guni cre ca'. Para rabi be laaca': ―Ñee napa tu xiixa go binni la? ");
INSERT INTO zaiNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Oraque bidii ca laabe tindaa benda biguii lu buu ne ti campana bizu napa miel. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ucuaa be ni, gudó be ni nezalú ca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ne rabi be laaca': ―Irá ni bizaaca ri la? nga nga ni byué nia laatu que. Gudxe laatu napa xidé gaca irá ni cá lu xqui'chi Moisés, ne ni bicaa ca profeta ne ni cá lu Salmo, irá ra ruzeete ni naa. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ne óraque bixhele be xquenda biaani ca para guiene ca ni cá lu Xqui'chi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ne rabi be laaca': ―Zacá nga cá ni, napa Cristu xidé gati' ne ibani ra guionna gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ne óraque useenda be tu chi güí né binni naquiiñe inaba ca perdón Dios para aca perdonar ca'. Zuzulú ni Jerusalén, de racá ma ze ni irá guidxi. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Laatu zanda güi tu ni purti biiya pe tu irá ni. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Laguuya'. Zuseenda ni bidii stiidxa Bixhoze gueeda guiaana né laatu. Peru cadi ixele tu de Jerusalén de ora ma ucuaa tu enda nandxó' ni gueeda de ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Oraque ucuaa be laaca biree né be laaca de ndaani guidxi que, yené be laaca Betania. Ne raqué undisa ná be, uluu be ndaaya laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Caguu ru be ndaaya laaca', biasa be ze be ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ne biluxe si bisisaca ca laabe, nabé nayeche bigueta ca Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ne qué niree ca ndaani yu'du ro', bisisaca ca Dios ne bidii ca diuxquixe laa. Amén.");
INSERT INTO zaiNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Dxi bizulú Dios bizá' guidxilayú ne ibá' maca nuu tobi ni rabi cabe Diidxa', ne uyuu Diidxa que ra nuu Dios, ne Diidxa que Dios laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Dxi bizulú guidxilayú ne ibá' maca nuu né Diidxa que Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pur laabe uca irá xixé cosa ne pa sin laabe qué ñaca gasti de ni ma uca ca. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Lu ná be nuu enda nabani, ne naca enda nabani que biaani para irá binni. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ruzaani biaani que lu guelacahui, ne qué huayanda utaagu guelacahui ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Uyuu tobi ni biseenda Dios, lá Juan. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Beda güi né binni stiidxa stobi ni nexhe gueeda, ni gueda gaca biaani para irá binni guidxilayú. Beda güi be stiidxa ngue para guni cre binni laa dxi gueeda. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Cadi laadi be nga biaani que, sínuque beda güi né si be binni stiidxa biaani que, ");
INSERT INTO zaiNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","dxa biaani nexhe gueeda ndaani guidxilayú que para uzaani irá binni. Ne biaani que nga Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Beeda be ndaani guidxilayú ni bizá' be, peru qué ñunibiá' binni guidxilayú laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Beeda be xquidxi pe be, peru qué nulabi ca binni xquidxi be laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Peru irá cani bilabi laabe ne bini cre laabe la? bi'ni be laaca xiiñi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ne para guca cabe xiiñi Dios la? qué ñale cabe de gunaa ne hombre casi rale binni guidxilayú, o nin purti uyuula'dxi hombre gaca ni, sínuque zeeda ni de Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Beda gaca dxa Diidxa que binni, ne uleza be lade du. Ne bidu'ya du enda nandxó' stibe. Nandxó' be purti laabe nga tobi lucha Xiiñi Dios Padre. Uca be nacha'hui ne binni, ne bi'ni be puru si ni jneza. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Byui' né Juan binni stiidxa be. Ne bicaa ridxi na rabi laacabe: ―Ndi nga ni huayabe laatu nanda atrá de naa que, ni gudxe laatu jma risaca que naa, purti maca nuu be ante chuaa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nacha'hui be ne binni ne qué riaana dxí be de cu' be ndaaya laanu. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Purti bidii Dios ley Moisés para udii ni binni, peru ra beeda Jesucristu uca Dios nacha'hui ne binni, ne bihuinni xii nga ni dxandí'. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Iruti binni guidxilayú qué huayuuya Dios sínuque tobi lucha si Xiiñi be ni nuu né laabe tobi si, laa beda usiene binni ximodo laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ti dxi biseenda ca judíu de Jerusalén chupa chonna sacerdote ne levita ra nuu Juan, para yenaba diidxa ca Juan tu laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ne óraque bisiá stiidxa' ne qué nucaachi gasti' sínuque gudxi laacabe cadi Cristu laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Para na ca rabi ca laabe: ―Entonce tu lii pue. Ñee lii nga Elías la? Oraque na be: ―Co', cadi Elías di naa. Bigueta na ca': ―O lii nga dxa profeta ni gueeda que la? ―Lácaca co', na be. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Oraque na ca': ―Gudxi laadu tu lii pue ti gapa du xi gabi du cani biseenda laadu. Xi zanda ga'bu laadu de lii. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Para na be: ―Naa nga ni cucaa ridxi ndaani gui'xhi': “Lauxhele ladxidó' to para Señor, casi ñaca cuxhele tu ti neza tidi be”, casi bizeete profeta Isaías ni chiqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Laca nuu caadxi fariseu lade cani yenaba diidxa que. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Para rabi ca laabe: ―Pa cadi Cristu lii nin Elías nin dxa profeta que la? xiñee caguu nisa lu ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Para rabi be laaca': ―Naa la? caguaa ni'sa', peru nuu tobi lade tu ni ca'ru gunibiá' tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Laabe nga ni gudxe laatu zeeda atrá de naa que, peru naa qué risaca dia' nin para cuee guela guidi ñee be. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Dxi uca nga la? nuu Juan ndaani guidxi Betábara, cherica guiigu Jordán ra caguu nisa. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Sti dxi que biiya Juan zeeda Jesús ra nuu, para na: ―Laguuya', ndi nga Dendxu huiini sti Dios ni ribee xpecadu binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ndi nga dxa hombre ni huayabe laatu zeeda atrá de naa ni jma risaca que naa purti ante chuaa maca nuu. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Chiqué nin naa qué ñunebia'ya laabe, peru para ulué binni Israel tu laabe la? nga runi beda nduaa ni'sa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ne gudxi Juan laacabe xi bi'ya', na: ―Biiya zeda yete Espíritu Santu de ibá' casi ti paloma ne biaana dxí luguiá be. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ca'ru gunebia'ya laabe, peru ni biseenda naa gueda nduaa ni'sa', ngue gudxi naa ora guuya guiete Espíritu Santu ne guiaana dxí luguiá ti hombre la? ngue nga ni chi udii Espíritu Santu binni. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Naa biiya laabe ne ma gudxe binni deque laabe nga Xiiñi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Bigueta sti dxi que, zuhuaa né Juan chupa de cani canazá né laa ");
INSERT INTO zaiNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ora zidi'di Jesús neza que, para biiya dxí Juan laabe ne na: ―Laguuya', ndi nga Dendxu huiini sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ne bina diaga iropa cabe ni uní' Juan, para yenanda cabe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ora bidxigueta lú be biiya be zeda nanda ca laabe, gunaba diidxa be laaca', na be: ―Xi ruyubi tu. Para na ca': ―Maistru, tu ralidxi biete lu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Para rabi be laaca': ―Latá' gu'ya tu. Oraque yeguuya ca paraa biete be. Ne biaana né ca laabe dxi que purti ma huadxí ngue, bia' las cuatro. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tobi de ca discípulu ni bina diaga ni uní' Juan ne yenanda Jesús que la? lá Andrés bi'chi Simón Pedru. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nirudó' yeyubi be Simón bi'chi be ne rabi be laa: ―Ma bidxela du Mesías ni rabi cabe Cristu ni ulí Dios que. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ne yené be laa ra nuu Jesús. Oraque biiya dxí Jesús laa ne na: ―Lii nga Simón, xiiñi Jonás nja', peru ma chi iree lá lu Cefas (didxazá la? ñabi be laa Pedru). ");
INSERT INTO zaiNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sti dxi que na Jesús che Galilea, ne ra ze be que bidxaaga be Felipe para rabi be laa: ―Dananda naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe laca binni Betsaida laa, xquidxi Andrés ne Pedru. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Yeyubi Felipe Natanael, ne ora bidxela be laa rabi be laa: ―Ma bidxela du dxa hombre de ni bicaa Moisés lu gui'chi ra cá ca ley ne ni bizeete ca profeta que, ne laabe nga Jesús xiiñi José de Nazaret. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Para na Natanael rabi laabe: ―Zanda xa iree ni iquiiñe de Nazaret. ―Gudá' gu'yu', rabi be laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ora bi'ya Jesús zidxiña Natanael laa na: ―Laguuya ndi nga tobi ni dxandí pe naca binni Israel, laabe qué rusiguii be. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Oraque na Natanael rabi Jesús: ―Paraa binibiá' lu naa ya'. Para na Jesús rabi laa: ―Ante cuidxi Felipe lii, ora nuu lu xa'na yaga du'ga que, maca biiya lii. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Oraque na Natanael rabi laabe: ―Maistru, lii nga Xiiñi Dios. Lii nga Rey sti binni Israel. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Para rabi be laa: ―Purti si gudxe lii biiya lii xa'na yaga du'ga ma bini cre lu la? Chi guuya rou' cosa ni jma nandxó' que nga. ");
INSERT INTO zaiNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ne na be: ―Gabe ca' laatu de ca yanadxí zuuya tu zuxele ibá', ne ca ángel sti Dios cagui'ba ca ne cayete ca xa ique Hombre Biseenda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Rabionna gubidxa que uca ti enda xheela ndaani guidxi Caná de Galilea, ne nuu jñaa Jesús raqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Laca bini invitar cabe Jesús ne ca discípulu sti' ra enda xheela que. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ne ora bibidxi vinu raqué la? na jñaa Jesús rabi laa: ―Ma qué gapa cabe vinu. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Para na Jesús rabi laabe: ―Cadi ga'bu naa xi gune, Amá, purti ca'ru idxiña hora stinne'. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Oraque na jñaa be rabi cani canaguiizi que: ―Laguni intiisi gabi be laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Zuhuaa xhoopa tinaja de guie ni riquiiñe lu costumbre de enda ria'ri sti ca judíu raqué. Cada tinaja que riné chupa o chonna rii nisa. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ne na Jesús rabi laacabe: ―Lauchá ca tinaja ca de nisa. Ne bichá tipa cabe cani. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Oraque rabi be laaca': ―Lacuee caadxi yanna ne lachiné ni ra nuu mayordomo. Para yené cabe ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bini prueba mayordomo vinu ni deru uca que, ne qué ganna xidé ni, peru cani udaa nisa ndaani tinaja que nanna xii ni. Oraque guridxi mayordomo que novio, ");
INSERT INTO zaiNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ne na rabi laa: ―Irá binni casi uzulú qui'zi rudii vinu cha'hui', ne ora ma güe' cabe stale la? óraque ru rudii vinu ni huaxié' galán. Peru lii deru cudiiu vinu ni jma nacha'hui'. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nga nga primé milagru ni bi'ni Jesús. Ne guca ni ndaani guidxi Caná de Galilea. Raqué biluí' be pabiá' nandxó' be, ne bini cre ca discípulu stibe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Uca si ngue uyé be Capernaum, laabe ne jñaa be ne ca bi'chi be ne ca discípulu stibe. Biaana cabe raqué chupa chonna gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ma zeda yuba pascua, saa ro' sti ca judíu, uyé Jesús Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ne ora biuu be ndaani yu'du ro' biiya be nuu cani cutoo buey ne dendxu' ne paloma, ne cani cuchaa bidxichi, zuba ca ruaa jmexa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Para bi'ni be ti chicote de doo, guladxi né be ni irá xixé ca' ne ca dendxu stica ne ca xpuey ca', ne bitiixhi be jmexa cani ruchaa xpueltu binni ne bicheeche be xpidxichi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ne rabi be cani cutoo paloma: ―Lacuee irá ndi rarí'. Cadi guni tu lidxi Bixhoze yoo guiaa. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Oraque bietenala'dxi ca discípulu stibe cá ni lu Xqui'chi Dios sicarí': “Tantu racaladxe gapa li'dxu dede runduuxe ni naa.” ");
INSERT INTO zaiNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Para na ca judíu rabi laabe: ―Yáquexa cayu'nu irá ndi la? xi seña udiiu laadu para ganna du napu derechu gu'nu cani. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Para rabi be laaca': ―Lauxhá yu'du ri', ne lu chonna gubidxa zandisa ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Oraque na ca judíu: ―Cuarenta y seis añu bicuí cabe yu'du ri' ne lii nou' lu chonna si gubidxa zandisa lu ni la? ");
INSERT INTO zaiNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Peru laabe cuchaaga be cuerpu stibe yu'du que ne nga nga ni cuzeete be. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ngue runi dxi laabe ma biasa be de lade gue'tu que bietenala'dxi ca discípulu stibe ni uní' be ca, ne óraque bini cre ca ni, ne bini cre ca Xqui'chi Dios ni ucuá chiqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ca dxi uyuu be Jerusalén dxi saa pascua que, uyuu stale tu bini cre laabe purti biiya ca ca milagru ni bi'ni be raqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Peru huaxié' gupa be confianza laaca', purti runibiá' be ladxidó' irá binni, ");
INSERT INTO zaiNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ne qué riquiiñe be tu gabi laabe xi naca binni, purti maca nanna be xi nuu ndaani ladxidó' cada tobi. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Chiqué uyuu tobi hombre de ca fariseu lá Nicodemo. Naca be tobi de ca xaíque sti ca judíu. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ti gueela uyé be ra nuu Jesús ne rabi be laa: ―Maistru, nanna du lii nga maistru ni beeda de Dios purti iruti ñanda ñuni ca milagru ni ru'nu ri pa ñaca cadi nuu né Dios laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Para na Jesús rabi laabe: ―Gabe ca' lii, tu qué gale sti tiru la? qué zanda di chu' ra runi mandar Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Oraque na be: ―Ximodo zanda gale ti hombre ora ma huaniisi ya'. Zanda xa guiuu ndaani jñaa ne gale sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Bigueta na Jesús rabi laabe: ―Gabe ca' lii, tu qué gale de nisa ne de Espíritu, qué zanda di chu' ra runi mandar Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ni gale de cuerpu la? cuerpu laa, ne ni gale de Espíritu la? espíritu laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Cadi idxagayaa lu ti rabe lii naquiiñe gale tu sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Bi rundubi ladu tiisi ne runa diaga lu rixidxi, peru qué gannu padé zeeda nin paraa che'. Zacaca nga irá tu gale de Espíritu. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Oraque na be: ―Ximodo zanda gaca ndi ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Para na Jesús rabi laabe: ―Lii naca lu ti maistru sti ca binni Israel ne qué riene lu ni la? ");
INSERT INTO zaiNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Gabe ca' lii riní du de ni nanna du, ne rui né du laatu ni bidu'ya du, peru qué runi cre tu ni rabi du laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Pa huayabe laatu cosa de guidxilayú ne qué runi cre tu la? ximodo ñanda ñuni cre tu pa ñabe laatu cosa de ibá' ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Iruti huagui'ba ibá' pa cadi ni biete de ibá' ne nga nga Hombre Biseenda Dios, ne ibá' nga jlugar be. Ne naa nga Hombre Biseenda Dios que. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Cásica gundisa Moisés beenda ndaani gui'xhi chiqué, zaqueca nga naquiiñe indisa cabe Hombre Biseenda Dios, ");
INSERT INTO zaiNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ti irá ni guni cre laabe, cadi initilú sínuque gapa enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Purti nadxii xhaata Dios binni guidxilayú ngue runi bidii tobi lucha Xiiñi', ti irá tu guni cre Xiiñi be que la? cadi initilú sínuque gapa enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Biseenda be Xiiñi be guidxilayú cadi para udxiiba donda ique binni, sínuque para ilá binni pur laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tu runi cre Xiiñi be que la? qué zagui'ba donda ique, peru tu qué runi cre Xiiñi be que la? maca dxi'ba donda ique purti qué runi cre tobi lucha Xiiñi be. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ma dxi'ba donda ique cani qué runi cre purti beeda biaani guidxilayú peru jma gunaxhii ca guelacahui que biaani, purti malu ni runi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Irá ni runi ni cadi jneza la? nanala'dxi biaani' ne qué zie ra naya'ni ti cadi ihuinni ni runi. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Peru ni runi jneza la? zie ra nuu biaani ti gu'ya irá xixé binni zeeda dxiiña sti de Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Udi'di si ngue la? yené Jesús ca discípulu sti Judea, ne biaana né be laaca raqué, ne uluu nisa be binni raqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan laca caguu nisa ti lugar lá Enón gaxha de Salim purti raqué da' zia' nisa, ne cadxiña cabe laabe ne caguu nisa be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ca'ru guieguyoo be dxi que. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ucuaa yú né ca discípulu sti Juan caadxi judíu tu jma riquiiñe enda riguu nisa sti', sti Juan la? o sti Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ne uyé ca ra nuu Juan, na ca rabi ca laabe: ―Maistru, ma caguu nisa dxa hombre ni uyuu né lii cherica Jordán, dxa ni byuí' lu stiidxa que, ne irá binni cayé ra nuu. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Para na be rabi be laaca': ―Qué zanda icaa binni gasti pa qué gueeda ni de ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Laaca tu nanna tu unié cadi naa dia' nga Cristu, sínuque bisá niru si Dios naa lú be. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ra ti enda xheela nabé rieche xhamigu novio ni zuhuaa raqué cucaa diaga ni caní' novio. Zacaca nga ma cayeche yanna. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Cada dxi naquiiñe quiba be jma ne naa guiete'. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jma risaca ni beeda de ibá' que irá xixé binni. Ni za de guidxilayú la? binni guidxilayú laa, ne rui' stiidxa guidxilayú, peru ni beeda de ibá' la? laa huaxa jma risaca que irá xixé binni. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ne rui' né be binni ni bi'ya be ne ni bina diaga be, ne iruti runi cre laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Peru ni ricaa stiidxa be la? riní' de idubi ladxidó' ni runi Dios nga jneza. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ni biseenda Dios la? rui' stiidxa Dios, purti ruchá Dios ladxidó' de Espíritu Santu. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nadxii Dios Xiiñi, ne ma gudixhe irá xixé lu ná Xiiñi'. ");
INSERT INTO zaiNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tu runi cre Xiiñi be la? napa enda nabani ni qué zaluxe, peru tu qué uzuuba stiidxa Xiiñi be, qué zapa di enda nabani, sínuque xiana stibe nuu luguiá'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Gunna Señor ma gunda diaga ca fariseu jma stale discípulu cayapa ne jma stale binni caguu nisa que Juan, ");
INSERT INTO zaiNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","neca cadi laabe caguu nisa be sínuque ca discípulu stibe. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Para biree be Judea bigueta be Galilea. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ne napa be xidé tidi be Samaria. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yendá be ti guidxi sti Samaria lá Sicar ni nuu gaxha de layú ni bisaana Jacob para José xiiñi'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ne raqué nuu bizé sti Jacob. Nabé ma bidxaga be tantu ma guzá be ne mayaca ganda galaa dxi ngue, para gurí be ruaa bizé que. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Raqué zuba be beda caa ti gunaa de Samaria nisa. Para rabi be laa: ―Bisiga'de naa caadxi nisa guee'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Qué guinni ca discípulu stibe, ze ca ndaani guidxi, zisí ca endaró. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Oraque na gunaa que: ―Ximodo ndi ya'. Lii nacu judíu ne naa naca samaritana ne canaba lu naa nisa gueu' la? Uní' gunaa que zaqué purti qué raca llevar ca judíu ca samaritanu. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Para rabi be laa: ―Pa lii ñannu xi cudii Dios binni, ne ñannu tuu nga canaba lii nisa gue la? ninaba lu laa, ne laa nudii lii nisa ni rudii enda nabani. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Oraque na gunaa que rabi laabe: ―Señor, peru cadi neu ni cuee neu ni, ne nabé guete bizé ri'. Paraa nga nou' ricoou nisa ni rudii enda nabani ca ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Lácaxa jma nandxó' lo que bixhoze du Jacob ni bidii bizé ri laadu. Laa güe' nisa stini, ne laca güe' ca xiiñi ne ca xhiuze. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Para rabi be laa: ―Tutiica gue nisa ri la? zati ru nisa. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Peru tu gue nisa ni gudiee laa la? ma qué ziuu dxi gati nisa, purti de nisa que ziale nisa ni rudii enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Oraque na gunaa que rabi laabe: ―Señor, dané naa nisa ni nou' ca para cadi gate rua' nisa ne ma cadi gueda caa nisa bizé ri'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Para rabi be laa: ―Yetidxi xheelu ti gueedu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Oraque na: ―Qué gapa dia' xheela'. ―Jneza uníu', rabi be laa, ―qué gapu xheelu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Purti ma gaayu xheelu gupu' ne ni nabeza neu yanna ri la? cadi xheelu'. Jneza uníu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","―Señor, zuluá' sia' profeta lii, na gunaa que rabi laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","―Ca bixhoze gola du la? lu dani ri bisisaca ca Dios, peru laatu na tu Jerusalén nga usisaca binni Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Para rabi be laa: ―Señora, bini cre ni chi tidxe lii ri'. Zadxiña dxi nin ca lu dani ri', nin ca Jerusalén qué zusisaca cabe Dios Padre. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Laatu rusisaca tu ni qué runibiá' tu, peru laadu rusisaca du ni runibiá' du, purti de lade ca judíu iree ni ulá. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Zadxiña dxi, ne yanna nga laani, cani dxandí racala'dxi usisaca Dios la? naquiiñe guni ni modo racala'dxi be, ne guni ni de idubi ladxidó', purti ca nga nga cuyubi Dios, cani usisaca laa zacá. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios Espíritu laa, ne tu usisaca laabe la? naquiiñe chi nanda ni jneza ne guni ni de idubi ladxidó'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Para na gunaa que rabi laabe: ―Nanna ziuu dxi gueeda Mesías ni rabi cabe Cristu que, ne ora gueeda be zusiene be laadu irá ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Oraque rabi be laa: ―Laape be nga caní' né be lii. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ra cayuí' cabe diidxa que beeda ca discípulu stibe ne bidxagayaa ca cayuí' né be gunaa que diidxa', peru nin tobi de laaca qué ninaba diidxa ca laabe xi canaba diidxa be gunaa que o xi cayabi be laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Oraque bisaana gunaa que rii sti' ne uyé ndaani guidxi. Ne biiya nuu caadxi hombre raqué para na: ");
INSERT INTO zaiNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Latá' gu'ya tu ti hombre ni gudxi naa de irá xixé ni huayune'. Nanna pa cadi ndi nga Cristu ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Para biree ca ndaani guidxi que uyé ca ra nuu Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Laga ze gunaa que na ca discípulu stibe rabi laabe: ―Gudá' gou', Maistru. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Para rabi be laaca': ―Napa ti endaró. Qué ganna tu xi laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Para na caadxi discípulu rabi xcaadxi que: ―Lácaxa nuu tu gueda saana endaró para laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Peru óraque rabi be laaca': ―Endaró stinne nga gune ni na ni biseenda naa, ne gunduuxe dxiiña sti'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Laatu na tu riaadxa ru stapa beeu para iree guela. Peru naa rabe laatu: Laindisa lú, laguuya ca ñaa ca gu'ya tu ma nuu cani para iree cani guela. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ni chi ndee guela ca la? nga nga cani uchiña binni ra nuaa para icaa ca binni ca enda nabani ni qué zaluxe. Ne laabe zapa be enda nayeche' purti nga nga chi caa be saca bi'ni be dxiiña que, laabe ne ni bizulú byuí' né ca binni que stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Rarí pe nga riaba dichu que: “Adxé tu riguu biní, ne adxé tu ribee guela.” ");
INSERT INTO zaiNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yanna naa cuseenda laatu chi ndee tu guela ra cadi laatu uluu tu biní. Adxé tu uluu biní, peru ma beda guiuu tu lú ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ne stale binni de guidxi que bini cre laabe pur ni gudxi gunaa que laaca', ra na gunaa que gudxi be laa irá ni huayuni. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ne ora yendá ca ra nuu be unaba ca laabe guiaana né be laaca'. Para biaana be raqué chupa gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ne jma rusi stale binni bini cre laabe pur ni uní' be. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ne óraque rabi cabe gunaa que: ―Ma cadi pur ni gu'dxu siou' laadu runi cre du sínuque ma de ruaa pe be bina diaga du ni, ne nanna dxichi du laabe nga ni zeda ulá binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Gudi'di si chupa gubidxa que, biree be uyé be Galilea, ");
INSERT INTO zaiNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","purti laca laabe na be, que rusisaca cabe ti profeta ndaani xquidxi. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ne ora yendá be Galilea bichagalú ca binni Galilea laabe, purti biiya ca irá ni bi'ni be Jerusalén ra yegapa ca saa que. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Bigueta uyé be Caná de Galilea ra bi'ni be nisa que vinu. Ne ndaani guidxi Capernaum nexhe xiiñi ti xpinni rey huará. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ora gunna hombre que ma bigueta be de Judea ma nuu be Galilea la? uyé ra nuu be ne gudxi laabe chiné be laa usianda be xiiñi ma cayati. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Para rabi be laa: ―Pa qué gu'ya tu seña ne milagru la? qué zuni cre tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Oraque na xpinni rey que rabi laabe: ―Chuu guiuba, Señor, ante gati xiiñe'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Para rabi be laa: ―Guyé, zianda xiiñi lu'. Ne bini cre ni gudxi be laa que, ne biree ze'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Neza ru ze hombre que, yechagalú ca xpinni laa ne na ca': ―Ma bianda xiiñi lu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Para unaba diidxa be laaca pora ti bizulú cayanda xiiñi be que. Ne óraque na ca': ―Neegue bia' la una ma qué ñuu be xindxá'. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Oraque bietenala'dxi be bia' óraque pe nga gudxi Jesús laabe zianda xiiñi be. Ne bini cre be Jesús, laabe ne irá xixé binni lidxi be. ");
INSERT INTO zaiNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ma ne ndi rairopa milagru guni Jesús Galilea dede dxi bigueta de Judea. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Biluxe si ca nga la? uyé Jesús Jerusalén ra cayaca saa sti ca judíu. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nuu ti tanque gaxha de ra puerta ra riuu ca dendxu ndaani guidxi que. Diidxa hebreu la? lá ni Betesda. Ne napa ni gaayu corredor. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nexhe stale binni huará ndaani ca corredor que. Nuu ni nacheepa lú, ni nachiita ñee ne xuta'. Cabeza ca iniibi nisa ni da' raqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Purti gatigá riete ti ángel ndaani tanque que ne runiibi nisa ni da' ndaani ni, ne tu chu' ndaani ni casi iluxe iniibi ni la? zianda de intiica cayaca. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ne nuu tobi hombre raqué ma raca treinta y ocho añu de huará. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ora bi'ya Jesús laabe ne nanna ma xadxí nexhe be raqué la? na rabi laabe: ―Ñee racala'dxu guianda lu la? ");
INSERT INTO zaiNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Para na be: ―Señor, qué gapa dia' tu cu' naa ndaani tanque ca ora caniibi nisa. Laga ziaa la? mápeca biete stobi. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Oraque na Jesús rabi laabe: ―Biasa, gundisa jluuna lu ne uzá. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ne oraqueca bianda hombre que ne ucuaa jluuna zie né. Ne uca ni dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ora bi'ya ca judíu dxa hombre bianda que la? na ca': ―Cadi jneza cayuni lu nua lu jluuna lu dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Para rabi be laaca': ―Ti hombre bisianda naa, ne laa gudxi naa indisa jluuna ne saya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Oraque na ca': ―Tu gudxi lii indisa lu jluuna lu ne sa lu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Peru qué ganna be tu bi'ni ni, purti ma qué guinni Jesús raqué. Ma biaazi lade binni. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bigueta biiya Jesús laabe ndaani yu'du ro' para na rabi laabe: ―Biaa, ma bianda lu'. Yanna ma cadi guchee rou', para cadi gueeda sti enda huará luguiá lu jma naná que ni gupu ca. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Oraque biree hombre que, yetidxi ca judíu Jesús bisianda laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ne pur ngue uzabi nanda ca judíu Jesús ne gucala'dxi ca ñuuti ca laabe, purti bi'ni be ni dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Peru na be rabi be laaca': ―Dede yanna cayuni Bixhoze dxiiña' ne naa laca cayune'. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Oraque jma rusi gucala'dxi ca judíu ñuuti ca laabe, cadi purti si qué rapa be dxi enda riziila'dxi sínuque laca purti na be Dios nga Bixhoze be ne zacá runi be laabe Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Oraque na Jesús rabi laacabe: ―Gabe ca' laatu, qué zanda di guni Xiiñi Dios gasti de laa si, pa qué gu'ya guni Bixhoze ni, purti ni runi Dios Padre la? ngue ca runi Xiiñi'. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nadxii be Xiiñi be ne ruluí' be laa irá ni runi be, ne zuluí' ru be laa ni jma nandxó' que cani bi'ya tu ca para idxagayaa tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Cásica rindisa be gue'tu para usibani be la? zacaca rudii Xiiñi be enda nabani cani racala'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Qué rudxiiba be donda ique iruti', sínuque bisaana be ni lu ná Xiiñi be ti ma laa gudxiiba donda ique binni, ");
INSERT INTO zaiNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ti usisaca irá binni Xiiñi be casi rusisaca ca laabe. Ne tu qué usisaca Xiiñi be ni biseenda be la? laca qué rusisaca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ne laca na Jesús: ―Chi tidxe ca' laatu, tu ucaa diaga stiidxa' ne guni cre ni biseenda naa la? ma napa enda nabani ni qué zaluxe. Ne ma qué zagui'ba donda ique, sínuque ma biree de lu ná enda guti, ma biuu lu ná enda nabani. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ne gabe ca' laatu, zadxiña dxi, ne yanna nga laani, zuna diaga gue'tu stidxi Xiiñi Dios, ne tu ucaa diaga ni la? zabani. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Purti cásica napa Dios poder udii enda nabani la? zacaca bidii poder Xiiñi para udii enda nabani. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ne laca gudixhe be ladxi ná Xiiñi be udxiiba donda, purti laa nga Hombre Biseenda be guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Cadi idxagayaa tu nga, purti zadxiña dxi guna diaga irá cani nuu ndaani ba' stidxi Xiiñi be, ");
INSERT INTO zaiNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ne zaree ca'. Ni bi'ni jneza la? ziasa ibani, peru ni qué ñuni jneza la? ziasa quiba donda ique. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Qué zanda gune gasti de naa sia', sínuque modo rabi Bixhoze naa udxiiba donda, zacá rune'. Ne jneza rudxiiba donda purti qué rune ni racaladxe sínuque rune ni na Bixhoze ni biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Qué nisaca ni ninié de laca naa pa naa sia' canié ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nuu stobi ni rusihuinni tu naa, ne nanna dxandí ni riní' be. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Laatu biseenda tu tu yení' né Juan, ne laabe gudxi be laatu tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Neca qué ñuu binni guidxilayú ñaca testigu stinne', nihuinni tu naca', peru cayabe ndi laatu ti ganda ilá tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Beda usiidi Juan binni ximodo naa casi ñaca beda uzaani lade tu ti ganna tu tu naa. Ne bisiguenda tu bieche né tu ni bisiidi be, peru chupa chonna si gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Peru napa rua' sti testigu ni jma rusi nandxó' que laabe ne nga nga ca milagru ni cayune ri'. Bisaana Bixhoze cani ladxi naya gune cani, ne rusihuinni cani Bixhoze biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Bixhoze biseenda naa ne laca laa rusihuinni tu naca'. Qué huayuu dxi guna diaga tu stidxi be nin gu'ya tu lú be, ");
INSERT INTO zaiNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ne qué gapa tu stiidxa be ndaani ladxidó' to, purti qué runi cre tu ni biseenda be. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ruunda chaahui tu Xqui'chi Dios, purti na tu lú ni zadxela tu enda nabani ni qué zaluxe, ne laape ni ruzeete ni tu naca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Peru qué na tu gueeda tu ra nuaa para gapa tu enda nabani. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Qué rina'ya uchá binni guidxilayú enda naró' stinne', ");
INSERT INTO zaiNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","peru nanna dxi'che cadi dxandí nadxii tu Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Benda purti biseenda Bixhoze naa, peru cadi culabi tu naa. Pa ñeeda stobi ni iruti nuseenda laa la? ngue huaxa nulabi tu laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Qué zanda guni cre tu, purti laca laatu rusisaca saa tu, ne qué lica ruyubi tu usisaca Dios laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Cadi zácaxa tu naa nga cuaa xqueja tu lu Bixhoze', sínuque Moisés nga cu' xqueja tu, neca cá lú tu laa iní' né Dios pur laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pa ñuni cre tu Moisés la? laca ñuni cre tu naa, purti de naa bicaa be lu Xqui'chi be. ");
INSERT INTO zaiNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Peru pa nin ni bicaa be qué runi cre tu la? laca qué zuni cre tu stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Gudi'di si nga la? uyé Jesús cherica ti nisa ro' lá Galilea. Laca nuu tu rabi ni Tiberia. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yenanda stale binni laabe, purti ma biiya ca ca milagru ni bi'ni be ra bisianda be binni huará. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Oraque udxi'ba be lu ti dani, ne gurí né be ca discípulu stibe raqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ma zeda yuba saa pascua. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ora undisa lú Jesús biiya nanda stale binni laa, na rabi Felipe: ―Paraa chi sí nu ni go irá binni ri'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Uní' be zaqué para gu'ya si be xi na Felipe, purti laabe maca nanna be xi chi guni be. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Para na Felipe rabi laabe: ―Nin chupa gayuaa denariu pan qué nugaanda nicaa cabe tindaa tindaa cada tobi cabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Oraque na Andrés, bi'chi Simón Pedru, tobi de ca discípulu stibe que, rabi laabe: ");
INSERT INTO zaiNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Rarí nuu ti hombre huiini napa gaayu pan de cebada ne chupa benda huiini', peru xi pe ndi para irá binni ri'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Para rabi be laaca': ―Laucuí laacabe. Ne gurí cabe lu ca guixi huiini ni nuu raqué, bia'si gaayu mil hombre. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Oraque gucuaa be ca pan que ne biluxe bidii si be diuxquixe Dios, bidii be cani ca discípulu stibe qui'zi ca lu ca binni que. Zaqueca bi'ni né be ca benda huiini que, ne ucuaa ca binni que bia' gucala'dxi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Biluxe gudó si ca binni que gudxi be ca discípulu stibe utopa ca ni biaana que ti cadi initi gasti'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ne dede bidxá tipa doce dxumi de pan ndahui ni biaana ra biluxe gudó ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ne ora bi'ya ca binni que milagru ni bi'ni be que la? na ca': ―Ndi nga dxandí dxa profeta ni gueeda guidxilayú que. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Peru ora gunna Jesús ma caní' stiidxa cabe gueda naaze cabe laa para guni cabe laa rey stícabe la? biree chu de laacabe gudxi'ba stubi lu dani que. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ma ziyaazi gubidxa biete ca discípulu stibe uriá nisa que, ");
INSERT INTO zaiNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ne biuu ca ndaani ti canuá huiini ne biaba ca nisa que para che ca Capernaum. Ma cacahui, ne ca'ru guedandá Jesús ra nuu cabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bizulú biete ti bi yooxho ne biasa ola sti nisa que. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ma uzá cabe bia' gaayu o xhoopa kilómetru lu nisa que ora bi'ya cabe zeeda za Jesús lu nisa, zeda dxiña ra nuu canuá stícabe que ne bidxibi cabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Peru na Jesús rabi laacabe: ―Naa ndi', cadi idxibi tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Oraque ru uluu cabe laabe ndaani canuá que, ne oraqueca yendá cabe ra ze cabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Sti dxi que nuu ru caadxi de ca binni que cherica nisa que. Ne nanna ca ti canuá si bizuhuaa raqué, ne laca nanna ca qué niné Jesús ca discípulu sti' sínuque stubi ca ze ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Oraque biiya cabe zuhuaa caadxi canuá de Tiberia gaxha de ra gudó cabe pan biluxe si bidii Señor diuxquixe Dios que. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ne ora bi'ya cabe qué guinni Jesús raqué nin ca discípulu sti la? biuu cabe ndaani ca canuá que, ze cabe Capernaum ziyubi cabe Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ne ora yendá cabe ra nuu be cherica nisa que la? rabi cabe laabe: ―Maistru pora beedu rarí'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Para na be: ―Nanna dxi'che cadi canayubi tu naa purti biiya tu milagru ni bine sínuque purti gudó to pan dede ra bidxá tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Cadi ucaa ique tu guni tu dxiiña para gapa tu endaró ni iquiiñe si tu ndaani guidxilayú ri', purti qué zandaa ni, sínuque laucaa ique guni tu dxiiña sti Dios para gapa tu enda nabani ni qué zaluxe. Naa nga Hombre Biseenda Dios ne naa udiee ni laatu, purti ma ulí Dios naa gune ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Oraque na ca': ―Ximodo guni du xhiiña Dios ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Para rabi be laaca': ―Ndi nga dxiiña na Dios guni tu: guni cre tu ni biseenda be. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bigueta na ca': ―Xiñee qué uluí' lu laadu ti seña xaibá' para guni cre du lii. Xi milagru ru'nu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Dxi nuu ca bixhoze gola nu ndaani gui'xhi gudó ca pan ni rabi cabe maná que casi cá lu Xqui'chi Dios ra na: “De ibá' bidii be pan gudó ca'.” ");
INSERT INTO zaiNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Oraque rabi be laaca': ―Gabe ca' laatu, cadi pan de ibá' ngue bidii Moisés laatu, sínuque Bixhoze nga cudii laatu ni dxandí pan de ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Purti pan ni cudii Dios binni la? nga ni biete de ibá', ne rudii ni enda nabani binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Para na ca': ―Cadi guiaana dxiu de udiiu pan ca laadu, Señor. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Oraque rabi be laaca': ―Naa nga pan ni rudii enda nabani. Tu gueeda ra nuaa', qué ziuu dxi indaana, ne tu guni cre naa, qué ziuu dxi gati nisa. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Peru ma gudxe laatu neca ma biiya tu naa, qué runi cre tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Irá cani udii Bixhoze naa zeeda ra nuaa', ne tutiisi gueeda ra nuaa' qué ziuu dxi iladxe laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Purti biete de ibá' cadi para gune ni racaladxe', sínuque para gune ni na ni biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ne ni racala'dxi be gune la? cadi unite nin tobi de cani rudii be naa, sínuque indisa laaca dxi iluxe guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Purti racala'dxi be gapa irá ni gu'ya naa ne guni cre naa, enda nabani ni qué zaluxe, ne zandisa laaca dxi iluxe guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Oraque bizulú ca judíu caní' ca laabe dxidxigá purti na be laabe nga pan ni biete de ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ne na ca': ―Cadi xa ndi nga Jesús xiiñi José que. Lácaxa qué runibiá' nu bixhoze be ne jñaa be. Ximodo na be de ibá' biete be ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Para rabi be laaca': ―Cadi ma cuchaaga ruaa tu racá. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Biseenda Bixhoze naa, ne iruti zanda gueeda ra nuaa', pa qué cuidxi be laa. Ne zandisa laa dxi iluxe guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Chiqué bicaa ca profeta: “Zadxiña dxi guiene irá binni ni rusiidi Dios.” Ngue runi yanna cada tobi ni guna diaga ne iziidi ni na Bixhoze la? reeda ra nuaa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Cadi purti nuu ru tu ma biiya laabe, sínuque naa sia' ma biiya laabe, purti de ra nuu be benda'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ne gabe ca' laatu, tu runi cre naa la? ma napa enda nabani ni qué zaluxe, ");
INSERT INTO zaiNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","purti naa nga pan ni rudii enda nabani. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Gudó ca bixhoze gola tu maná ndaani gui'xhi', peru guti ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Peru naa cuzeete pan ni riete de ibá' ti irá tu go ni qué zati. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naa nga pan ni biete de ibá'. Tu go ni la? qué ziuu dxi gati'. Ne pan ri nga cuerpu stinne ni chi udiee para ganda ibani binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ucuaa yu né ca judíu ni uní' be que, na ca': ―Ximodo udii hombre ri cuerpu sti idó' no. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Para rabi be laaca': ―Gabe ca' laatu, pa qué go to cuerpu sti Hombre Biseenda Dios ne qué gue tu rini sti la? qué zapa di tu enda nabani. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tu go cuerpu stinne' ne gue rini stinne la? ma napa enda nabani ni qué zaluxe, ne zandisa laa dxi iluxe guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Purti cuerpu stinne nga ni dxandí naquiiñe go binni, ne rini stinne nga ni dxandí naquiiñe gue cabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tu go cuerpu stinne ne gue rini stinne la? nuu ne naa tobi si, ne laca zaqueca nuaa nia laa tobi si. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nabani Bixhoze ni biseenda naa. Naa laca nabane pur laabe, ne zaqueca tu go cuerpu stinne laca zabani pur naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nga nga pan ni biete de ibá'. Adxé nga pan ni gudó ca bixhoze gola tu ne guti ca'. Peru tu go pan ni cuzeete ri la? zapa enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Irá nga uní' Jesús ra cusiidi ndaani yu'du Capernaum. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ora bina diaga cani canazá né laabe ni uní' be que la? na caadxi de laaca': ―Nabé naná ca diidxa cusiidi be ca. Tuu ndi zanda icaa cani. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Peru nanna be xi caní' ca discípulu stibe ra cuchaaga ruaa ca zaqué, para rabi be laaca': ―Ñee, bininá ca diidxa ca laatu la? ");
INSERT INTO zaiNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Xi niná tu pa ñuuya tu zigui'ba Hombre Biseenda Dios ra uyuu chiqué ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Pa qué gapa cuerpu stitu espíritu la? qué riquiiñe', purti espíritu nga rudii enda nabani laatu. Ca diidxa ni huayué nia laatu ca la? espíritu cani, ne zudii cani laatu enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Peru nuu caadxi de laatu qué runi cre. Uní' be zaqué, purti dede dxi bizulú uzá né ca laabe maca nanna be uná nga ni qué zuni cre laabe, ne tu chi utoo laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ne laca na be rabi be laaca': ―Nga runi ma gudxe laatu, iruti zanda gueeda ra nuaa pa qué uchiña Bixhoze laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ne dede dxi que bigueta stale de cani canazá né laabe que, ma qué ninanda ru ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Para rabi be doce discípulu stibe que: ―Laga laatu ya', laca zabigueta tu la? ");
INSERT INTO zaiNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Oraque na Simón Pedru rabi laabe: ―Tu ru ra nuu ñuu du ya', Señor. Lii siou' nga rui' neu laadu ni rudii enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ma runi cre du ne ma nanna dxichi du lii nga Cristu Xiiñi Dios ni nabani. ");
INSERT INTO zaiNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Para rabi be laaca': ―Ñee cadi naa ulié idubi doce tu, ne tobi de laatu sti binidxaba la? ");
INSERT INTO zaiNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Rarí cuzeete be Judas Iscariote, xiiñi Simón, purti laa nga chi utoo laabe, ne laa zeeda lade doce que. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Gudi'di si ca nga la? uzá Jesús Galilea, ne qué niná ñe Judea, purti canananda ca judíu guuti laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ne ma zeda yuba saa sti ca judíu, saa ra rucuí cabe ranchu huiini para guiaana cabe ndaani'. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Para na ca bi'chi be rabi laabe: ―Xiñee qué ireeu de rarí', cheu' Judea ti gu'ya cani rizá neu irá ni ru'nu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Purti qué runi cabe xiixa naga'chi pa racala'dxi cabe ganna binni tu laacabe. Pa dxandí runi lu cani la? biluí' irá binni xi ru'nu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Uní' ca zaqué purti nin laaca qué runi cre ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Para rabi be laaca': ―Ca'ru idxiña hora usihuinne tu naa. Peru laatu la? ora tiisi ñanda nusihuinni tu tu laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Purti qué raca nanala'dxi binni guidxilayú laatu, peru naa la? raca nanala'dxi cabe naa, purti rabe laacabe cadi jneza ni runi cabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Laché saa ca laatu. Qué ziaa dia' saa ca purti ca'ru ganda hora usihuinne tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ngue si gudxi be laaca', ne biaana ru be raqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Peru biree si ca bi'chi be ze la? laca uyé be saa que, cadi para gu'ya binni laabe, sínuque biuu be raqué naga'chi'. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Biyubi ca judíu laabe ndaani saa que na ca': ―Paraa nuu dxa hombre que. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Stale de ca binni nuu ra saa que nisi stiidxa be cayuí' ca', peru dxidxigá cayuí' ca ni. Nuu tu na: “Nacha'hui be.” Ne nuu tu na: “Co', canaguite si be binni.” ");
INSERT INTO zaiNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Uní' cabe ni dxidxigá purti cadxibi cabe ca judíu. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ma udi'di chupa chonna gubidxa de cayaca saa que biuu Jesús ndaani yu'du ro' ne bizulú bisiidi'. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ne nabé bidxagayaa ca judíu, ne na ca': ―Ximodo biziidi be irá ni nanna be ri sin ñuu tu nusiidi laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Para rabi be laaca': ―Cadi naa dia' gudixhe ni rusiide', sínuque rusiide ni gudixhe ni biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Cani racala'dxi guni ni na Dios la? zanna pa dxandí stiidxa Dios cusiide o pa stinne'. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ni riní' de laa si la? ruyubi usisaca binni laa, peru ni ruyubi usisaca ni biseenda laa la? ngue huaxa qué rusiguii ne qué runi ni cadi jneza. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ñee cadi bidii Moisés laatu ley para ñuni tu ni na la? peru qué runi tu ni na ni. Yanna xiñee racala'dxi tu guuti tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Oraque na ca binni que rabi laabe: ―Caguite binidxaba ique lu'. Tuu nga nou' racala'dxi guuti lii. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Para rabi be laaca': ―Tisi bine ti milagru la? irá xixé tu cadxagayaa tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Gudxi Moisés laatu cu' tu seña sti Dios ca xiiñi tu, casi bi'ni ca bixhoze gola tu. Ne runi tu ni, neca guiaba ni dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yanna pa para cadi uchee né tu ley sti Moisés runi tu ni neca dxi enda riziila'dxi la? xiñee ga bidxiichi né tu naa tisi bisianda ti hombre dxi enda riziila'dxi ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Cadi casi ze tu udxiiba tu donda ique binni, sínuque laguuya chaahui ti ganna tu uná nga ni jneza. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Oraque biree caadxi binni Jerusalén na: ―Ñee cadi laabe nga ni cuyubi cabe guuti cabe que la? ");
INSERT INTO zaiNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Laguuya', rarí nuu be caní' be nezalú irá binni ne cadi cayabi cabe laabe gasti'. Ñee na tu ma runi cre ca xaíque dxandí Cristu laabe la? ");
INSERT INTO zaiNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nagana huiini', purti nanna nu padé laabe, ne dxi gueeda Cristu la? iruti zanna padé gueeda. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Oraque jma rusi reciu uní' Jesús ra cusiidi que, na: ―Runibiá' tu naa ne nanna tu padé naa. Peru cadi stube sia' benda', sínuque nuu tu biseenda naa, ne laabe nga dxandí Dios, ne qué runibiá' tu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Peru naa runebia'ya laabe purti de laabe zenda', ne laabe biseenda be naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Oraque gucala'dxi cabe ninaaze cabe laabe, peru iruti niguu ná laabe, purti ca'ru idxiña xhiora be. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ne stale de ca binni que bini cre ca laabe ne na ca': ―Ora gueeda Cristu, lácaxa zanda guni jma milagru que ni cayuni be ri'. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bina diaga ca fariseu caní' ca binni que de Jesús zaqué para uyuu né ca ca xaíque sti ca sacerdote tobi si. Ne biseenda ca caadxi gendarme ninaaze laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Oraque na be: ―Ma nagaba si dxi nuaa nia laatu, purti ma chaa ra nuu ni biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Zuyubi tu naa peru qué zadxela tu naa, ne qué zanda di che tu ra chaa ca. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Oraque na ca judíu: ―Paraa nda nga na be che be ma qué zadxela nu laabe ya nja'. Ñee che be ra nuu ca judíu ni reeche lade cani cadi judíu para usiidi be laaca la? ");
INSERT INTO zaiNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Xiñee na be zuyubi nu laabe ne qué zadxela nu laabe ne qué zanda chuu nu ra che be ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Dxi ma para iluxe saa, o gabi nu laní que, bizuhuaa Jesús ne bicaa ridxi na: ―Pa nuu tuuxa cayati nisa la? gueda gue ra nuaa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ni guni cre naa la? zaca casi cá lu Xqui'chi Dios, de ndaani ladxidó' zandani nisa ni rudii enda nabani. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Rarí cuzeete Jesús Espíritu Santu ni icaa irá ni guni cre laa, peru dxi bizeete be ni la? ca'ru gueeda Espíritu Santu, purti ca'ru ibigueta be ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ne ora bina diaga caadxi binni de cani nuu raqué xi na be la? na ca': ―Ndi nga dxandí pe profeta que. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ne xcaadxi na: ―Laabe nga Cristu. Peru nuu xcaadxi na: ―Lácaxa de Galilea gueeda Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ñee cadi cá lu Xqui'chi Dios za be de David, ne zeeda be de Belén xquidxi David la? ");
INSERT INTO zaiNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ne zacá gudinde diidxa cabe pur laabe, adxé ni na tobi ne adxé ni na stobi. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ne ucala'dxi caadxi de laacabe ninaaze ca laabe, peru iruti niguu ná laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ne ora bigueta ca gendarme que, na ca xaíque sti ca sacerdote ne ca fariseu rabi laaca': ―Xiñee qué ñedané tu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Para na ca': ―Qué huayuu dxi chu' tuuxa iní' casi riní' hombre que. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Oraque na ca fariseu: ―Ñee dede laatu ma udxite be la? ");
INSERT INTO zaiNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Lácaxa nuu neca tobi de ca xaíque o ca fariseu ni ma bini cre laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ca binni ni rí raqué, ni qué ganna ley la? dí nuu ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Lade ca xaíque que zeeda Nicodemo ni uyé ra nuu Jesús huaxhinni que. Ne óraque na: ");
INSERT INTO zaiNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Ñee na ley stinu jneza udxi'ba nu donda ique tuuxa sin ucá' diaga nu laa, ganna nu xi bi'ni la? ");
INSERT INTO zaiNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Para rabi cabe Nicodemo: ―Ñee laca binni Galilea lii la? Biyubi gu'yu qué ziuu dxi iree ti profeta Galilea. ");
INSERT INTO zaiNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Biluxe si uní' cabe ngue la? cada tobi biree zibí'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ne biree Jesús de ndaani guidxi que, uyé lu dani Olivo. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Sti dxi que siadó' ro' bigueta be ndaani yu'du ro' ne bidxiña irá xixé binni guidxi que laabe para gurí be cusiidi be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Raqué nuu cabe bedané ca maistru de ley ne ca fariseu ti gunaa bigaa né jnadxii, ne bizuhuaa ca gunaa que galahui', ");
INSERT INTO zaiNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ne na ca rabi ca laabe: ―Maistru, biaa gu'yu gunaa ri' yendá cabe laa ne jnadxii. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lu ley bidii Moisés laadu la? na uchá du guie irá casi laabe ca. Yanna, lii ya', xi nou'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Uní' cabe zaqué para gu'ya si cabe xi na be ti ganda cu' cabe xqueja be. Peru laabe laga guta udaa be ne cucaa né be bicuini ná be layú. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Peru tantu si canaba diidxa ca laabe la? biasa be ne rabi be laaca': ―Pa nuu tuuxa qué huayuu dxi uchee la? laa uzulú cu' ná guie uchá laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ne bigueta guta udaa be cucaa be layú. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Casi bina diaga cabe ni uní' be que bizulú biree ca binni gola ne zaqué tobi tobi dede birá cabe, purti nanna cabe cadi nayá ladxidó' cabe. Ne ma laasi be ne gunaa que biaana cabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Oraque biasa be ne biiya be ma stubi si gunaa que nuu, para rabi be laa: ―Uná cani caguu xqueja lu que. Iruti nudxiiba donda ique lu la? ");
INSERT INTO zaiNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Para na gunaa que: ―Iruti, Señor. Oraque na be: ―Nin naa, qué zudxiiba donda ique lu'. Uyé ne ma cadi uchee rou'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Bigueta uní' né be ca binni nuu ndaani yu'du que, na be: ―Naa zeda gaca casi biaani ni ruzaani binni guidxilayú. Tu gueda nanda naa la? zapa biaani ni rudii enda nabani, ne qué ziuu dxi sa lu guelacahui. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Oraque na ca fariseu rabi laabe: ―Qué risaca di ni riníu' ca, purti laca lii caníu' tu naca lu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Para rabi be laaca': ―Neca laca naa rinié tu naca' peru dxandí ni rinié', purti nanna padé benda ne paraa chaa'. Peru laatu la? qué ganna tu padé benda nin paraa chaa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Rudxiiba tu donda ique binni casi runi binni guidxilayú. Peru naa qué rudxiiba donda ique iruti'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ne neca pe nudxiiba donda, ñune ni jneza purti cadi naa sia' ñune ni, sínuque naa ne Bixhoze ni biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Cá lu ley stitu, ni iní' chupa binni la? ngue nga ni dxandí'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Rusihuinne tu naca', ne laca rusihuinni Bixhoze ni biseenda naa tu naca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Oraque na ca rabi ca laabe: ―Paraa nuu Bixho'zo ya'. Para rabi be laaca': ―Qué runibiá' tu naa ne qué runibiá' tu Bixhoze'. Pa ñunibiá' tu naa la? laca ñunibiá' tu Bixhoze'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Irá nga uní' Jesús ra cusiidi ndaani yu'du que, gaxha de ra nuu caja ra riaba ofrenda. Iruti ninaaze laabe purti ca'ru idxiña xhiora be. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Bigueta rabi be laaca': ―Ma chaa'. Zuyubi tu naa peru qué zanda che tu ra chaa', sínuque zati né tu stonda tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Oraque na ca judíu: ―Ñee chi guuti be laca laabe la? purti na be qué zanda chuu nu ra che be. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Para rabi be laaca': ―Laatu za tu de guidxilayú; naa de ibá' naa. Laatu binni guidxilayú laatu; naa cadi binni guidxilayú naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nga runi gudxe laatu zati né tu stonda tu. Ne zacá zaca ni. Pa qué guni cre tu naca ni gudxe laatu que la? zati né tu stonda tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Oraque na ca rabi ca laabe: ―Tu ga lii ya'. Para rabi be laaca': ―Dede dxi bizuluá' maca gudxe laatu tu naca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Napa stale ni ñabe laatu ne nudxiiba donda ique tu, peru rue nia binni ni gudxi si ni biseenda naa inié', ne ni na be nga jneza. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Peru qué ñene ca pa cuzeete be Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Para rabi be laaca': ―Dede ora ma undisa tu Hombre Biseenda Dios luguiá', óraque ru nga ganna tu tu laa. Ne qué rune gasti de naa sia' sínuque rinié ni bisiidi Bixhoze naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Biseenda Bixhoze naa, ne nuu né naa. Qué huasaana be naa stube purti qué riaana dxie de gune ni riula'dxi be. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ne laga caní' be irá nga la? uyuu stale tu bini cre laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Oraque na be rabi be ca judíu ni ma bini cre laabe que: ―Pa qué iree chu tu de lu stiidxa la? zaca xpinne pia' laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ne zanna tu ni dxandí', ne zaladi tu ra cá tu yaga purti ma nanna tu ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Para na ca rabi ca laabe: ―Za du de Abraham, ne qué huayuu dxi icá du yaga lu ná iruti'. Ximodo ndi nou' zaladi du de ra cá du yaga ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Oraque rabi be laaca': ―Laucaa diaga ni chi tidxe laatu ri'. Irá cani ruchee né Dios la? cá ca yaga lu ná enda ruchee. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Xiiñi binni ziaana ralidxi bixhoze, peru ni runi si xhiiña cabe la? zándaca chu' dxi cuee cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nga runi pa indadi Xiiñi Dios laatu, zalaa pe tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nanna za tu de Abraham peru cuyubi tu guuti tu naa purti cadi cacaa tu ni cayabe laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Rue nia laatu ni culuí' Bixhoze naa, ne laatu runi tu ni cayabi bixhoze tu laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Oraque na ca judíu que rabi laabe: ―Abraham nga bixhoze du. Para rabi be laaca': ―Pa ñaca tu xiiñi Abraham la? ñuni tu ni bi'ni Abraham. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Gudxe sia' laatu ni gudxi Dios naa ne yanna ma racala'dxi tu guuti tu naa. Cadi zacá bi'ni Abraham. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Laatu la? runi tu xhiiña bixhoze tu. Oraque na ca': ―Cadi xiiñi guidxi laadu sínuque nanna du tu bixhoze du, ne Dios nga Bixhoze du. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Para rabi be laaca': ―Pa ñaca dxandí xiiñi Dios laatu la? ñanaxhii tu naa, purti zaya de Dios ne ma benda rarí'. Cadi stube benda', sínuque laabe biseenda be naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Xiñee qué riene tu ni rinié'. Qué riene tu purti qué rucaa diaga chaahui tu stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Binidxaba nga bixhoze tu ne racala'dxi tu guni tu ni na be. Dede dxi bizulú guidxilayú huayuuti be binni, ne qué huayuu dxi iní' be ni dxandí', purti qué lica ganna be xii nga ni dxandí'. Ora rusiguii be la? de laabe riale ni, purti nabé rusiguii be ne laabe nga bixhoze gola enda rusiguii. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Naa purti rinié ni dxandí la? qué runi cre tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tu de laatu zanda udxiiba donda ique'. Pa rabe laatu ni dxandí la? xiñee qué runi cre tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ni ma xiiñi Dios laa la? zucaa diaga stiidxa Dios. Laatu qué rucaa diaga tu stiidxa be purti cadi xiiñi be laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Oraque na ca judíu rabi laabe: ―Cayabi ca du samaritanu lii ne nuu neu binidxaba ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Para rabi be laaca': ―Cadi nuaa nia dia' binidxaba', sínuque cusisaca Bixhoze', peru laatu raani ná tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ne cadi cuyube dia' usisaca binni naa peru nuu tu cuyubi ni, ne laa nanna xii nga jneza. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Gabe ca' laatu, tu icaa stiidxa' qué ziuu dxi gati'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Oraque na ca judíu: ―Yanna huaxa ma nanna du dxandí nuu neu binidxaba', purti nou' tu icaa stiidxa lu qué ziuu dxi gati'. Xiñee ga guti Abraham ne ca profeta ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ñee jma nandxó' lo que bixhoze du Abraham la? Guti be ne laca guti ca profeta. Tuu nga ru'nu lii pue. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Para rabi be laaca': ―Pa laca naa rusisaca naa la? qué risaca dia', peru cadi nga di nga laani sínuque Bixhoze nga rusisaca naa. Laabe nga ni na tu Dios stitu ca. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Peru qué runibiá' tu laabe. Naa la? runebia'ya laabe. Pa ñaca qué ñunebia'ya laabe la? nusiguiee casi rusiguii tu. Peru runebia'ya laabe ne ricaa stiidxa be. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Bieche bixhoze tu Abraham zuuya naa dxi guenda'. Biiya be naa ne nayeche biaana ladxidó' be. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Oraque na ca judíu: ―Nin ca'ru gapu cincuenta añu ne nou' biiyu Abraham la? ");
INSERT INTO zaiNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Para rabi be laaca': ―Laucaa diaga chaahui ni chi tidxe laatu ri': Dede ante gale Abraham, naa maca nuaa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Oraque gundisa ca guie nuchá ca laabe, peru bicachi lú be ne udi'di be lade ca binni que biree be de ndaani yu'du que. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ra zidi'di Jesús biiya tobi hombre nacheepa lú de gule. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ne na ca discípulu sti' rabi laa: ―Maistru, tu bichee para gule be zacá pue, laabe la? o bixhoze be o jñaa be. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Para rabi be laaca': ―Cadi purti bichee cabe, sínuque gule be zacá para ihuinni xhiiña Dios luguiá be. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Naquiiñe gune xhiiña ni biseenda naa laga ca'ru ixhinni. Purti ma caxhinni, ne óraque ma iruti zanda guni dxiiña'. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Laga nuaa ndaani guidxilayú la? naca casi biaani para binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Biluxe uní' si be nga la? bichá xhinni be layú ne bi'ni be beñe ne nisa xhinni que, ne uxubi be ni lú ni nacheepa lú que. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ne rabi be laa: ―Yetibi lú lu' ndaani tanque lá Siloé. Ni riní' lá que la? “Ni Biseenda cabe”. Para biree hombre que, yetibi lú, ne ora bigueta ma riná. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Oraque na ca xpecinu be ne cani bi'ya laabe dxi nacheepa lú be que: ―Ñee cadi ndi nga ni ribí rinaba guna que la? ");
INSERT INTO zaiNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Caadxi binni na: ―Laabe. Ne xcaadxi na: ―Ruluí' laabe. Oraque na be: ―Naa ndi'. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Para rabi cabe laabe: ―Ximodo bixele lú lu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Oraque na be: ―Dxa hombre lá Jesús que bi'ni beñe ne uxubi ni lua' ne gudxi naa chi tibe lua ndaani tanque Siloé. Uyaa ne udibe lua' ne ma rinaya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","―Paraa nuu be ya', na ca binni que. ―Qué ganna dia', rabi be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Para yené ca laabe ra nuu ca fariseu. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Dxi bi'ni Jesús beñe ne bixhele lú be que la? uca ni ti dxi enda riziila'dxi. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bigueta unaba diidxa ca fariseu laabe ximodo bixele lú be. Para na be: ―Uxubi be beñe lua ne gudibe lua ne ma rinaya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Oraque na caadxi de ca fariseu que: ―Cadi dxandí Dios biseenda hombre ca purti qué rapa be dxi enda riziila'dxi'. Ne xcaadxi na: ―Ximodo zanda guni tobi ni cuchee né Dios milagru ni runi be ca ya'. Ne zaqué ma qué ñuu cabe tobi si. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bigueta unaba diidxa cabe ni bianda lú que: ―Lii ya', xi ra'bu de ni bixhele lú lu ca. Para na hombre que: ―Rabe profeta laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Peru qué ñuni cre ca judíu pa dxandí gule be nacheepa lú be ne yanna ma riná be. Para bisenda caa cabe bixhoze be ne jñaa be. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ne rabi cabe laaca': ―Ñee ndi nga xiiñi tu ni na tu nacheepa lú gule la? Ximodo riná be yanna. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Para na ca': ―Nanna du ndi nga xiiñi du, ne nanna du nacheepa lú be gule be, ");
INSERT INTO zaiNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","peru ximodo bianda be ne tu bixhele lú be la? nga qué ganna du. Ma huaniisi be, ma zanda iní' be. Lainaba diidxa laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Uní' bixhoze be ne jñaa be zaqué ti cadxibi ca ca judíu, purti maca uní' stiidxa ca judíu ni iní' Jesús nga Cristu la? maca zibee ca laa de lade ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ngue runi na bixhoze be ne jñaa be: “Ma huaniisi be, lainaba diidxa laabe.” ");
INSERT INTO zaiNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bigueta guridxi cabe hombre ni bianda lú que ne rabi cabe laa: ―Pa ridxibi lu Dios la? gudxi laadu ni dxandí'. Purti laadu nanna du binni ruchee hombre ca. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Para na rabi laacabe: ―Pa binni ruchee laabe la? nga qué ganna dia'. Ni nanna sia' la? chiqué nacheepa lua', yanna ma rinaya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bigueta rabi cabe laa: ―Xi bi'ni be para bixhele be lú lu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Para na rabi laacabe: ―Ma gudxe ni laatu, peru qué niná tu nucaa diaga tu. Xiñee racala'dxi ru tu guna diaga tu ni. O laca racala'dxi tu aca tu discípulu stibe la? ");
INSERT INTO zaiNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Oraque gudinde né cabe laa ne rabi cabe laa: ―Lii nga discípulu stibe. Laadu la? discípulu sti Moisés laadu. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nanna du uní' né Dios Moisés, peru nga la? nin qué ganna du padé za. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Para na hombre que rabi laacabe: ―Nga nga enda ridxagayaa ca. Laatu nin qué ganna tu padé za be peru bixhele be lua'. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nanna nu qué rucaa diaga Dios binni ruchee peru cani ridxibi laabe ne runi ni na be la? rucaa diaga be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dede dxi bizulú guidxilayú, qué huayuu tu uxhele lú tobi ni gale nacheepa lú. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ne pa ñaca cadi de Dios zeeda hombre que la? qué ñanda ñuni gasti'. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Oraque rabi cabe laa: ―Lii lade binni qué runi ni na ley gule lu' ne yanna racala'dxu usiidi lu laadu la? Para ucuaa cabe laa ulee cabe laa lade cabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Gunna Jesús guladxi ca judíu laabe de lade ca', para yeyubi laabe, ne ora bidxela laabe, na rabi laabe: ―Ñee runi cre lu Xiiñi Dios la? ");
INSERT INTO zaiNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Oraque na be: ―Tu laabe ya', Señor, para gune cre laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Para na Jesús: ―Ma biiya lu laabe, ne laabe nga caní' né be lii. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","―Rune cre, Señor, na be. Ne bizuxibi be xañee Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ne óraque na Jesús: ―Benda ndaani guidxilayú ri para usihuinne dxi'ba donda ique binni ne para ixele xquenda biaani cani qué riene, ne icahui xquenda biaani cani na riene, casi ñaca nicheepa lú ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ora bina diaga caadxi fariseu ni nuu raqué ni uní' Jesús que la? na ca': ―Ñee nou' laca nacheepa lú du la? ");
INSERT INTO zaiNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Oraque na Jesús rabi laaca': ―Pa ñaca nacheepa lú tu la? qué nigui'ba donda ique tu, peru ziaana stonda tu luguiá tu, purti na tu ruuya tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ne laca na Jesús rabi laacabe: ―Laucaa diaga chaahui ni chi tidxe laatu ri': Ni qué chu' neza ra puerta ndaani currá ra nuu ca dendxu' sínuque quiba ique ni la? gubaana laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Peru ni chu' neza ra puerta que la? ngue nga pastor sti ca dendxu que. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ne ora chindá be, ruxhele ni cayapa ra puerta que guiuu be, ne riní' be lá ca dendxu stibe. Runibiá' ca dendxu que stidxi be ne ribee be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ne ora ma ulee be irá ca dendxu stibe la? rizá niru be lú came. Rinanda came laabe purti runibiá' came stidxi be. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Peru ni cadi pastor stícame la? qué rinanda came laa, sínuque ruxooñe came de laa purti qué runibiá' came stidxi. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Gudixhe be ejemplu ca para laaca', peru qué ñene ca xi na ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ne laca rabi be laaca': ―Gabe ca' laatu, naa zeda gaca casi puerta sti currá ra riuu ca dendxu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Qué nulabi ca stendxua cani beeda ante guenda', purti gubaana laaca' ne zeda ndana si ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Naa nga puerta'. Tu chu' neza ra nuaa' zalá, ziuu ne zaree ne zadxela ni go. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Gubaana la? reda ndana', reda guuti, reda unitilú. Peru naa benda para gapa cabe enda nabani ne idxá tipa xpida cabe de enda nayeche'. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Naa nga pastor cha'hui'. Pastor ni nacha'hui la? zudii xpida pur ca dendxu sti'. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ni cayaxa para gapa dendxu la? qué rapa chaahui laacame purti cadi sti pe laacame, ne ruxooñe rusaana laacame ora gu'ya zeeda gueu'. Ne rinaaze gueu laacame, rucheeche ndase laacame. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ruxooñe be purti cayaxa si be para gapa be laacame. Qué rizaala'dxi be laacame. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Naa nga pastor cha'hui ne runebia'ya ca dendxu stinne', ne laaca laca runibiá' ca naa, ");
INSERT INTO zaiNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","casi runibiá' Bixhoze naa ne runebia'ya laa. Ne rudiee xpida pur ca dendxu stinne'. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Laca napa rua' xcaadxi dendxu ni cadi nuu ndaani currá ri'. Naquiiñe chi caa laacame. Zucaa diaga came stidxe' ne zaca came tobi si ne zapa came tobi si pastor. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nadxii Bixhoze naa purti rudiee xpida' ti ibigueta icaa ni sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Iruti cayaxha ni naa sínuque naa pia' caguixhe ni. Zanda quixhe ni ne zanda icaa ni sti tiru. Nga nga ni gudxi Bixhoze naa gune'. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Bigueta uyuu dinde ca judíu pur cani uní' be que. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Stale de laaca na: ―Nuu né be binidxaba ne cayaca ique be. Xiñee cucaa diaga tu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ne xcaadxi na: ―Lácaxa zacá riní' ni nuu né binidxaba'. Zanda xa uxhele binidxaba lú ni nacheepa lú. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Lu beeu nanda cayuni cabe saa ndaani guidxi Jerusalén, saa ni rabi cabe “Dedicación”. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Tobi de ca dxi que canazá Jesús corredor sti yu'du ro', ni rabi cabe Corredor sti Salomón. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Raqué uluu caadxi judíu le' laabe, ne na ca rabi ca laabe: ―Dede padxí udiiu lugar gata dxí xquenda biaani du. Pa lii nga Cristu la? gudxi ca ni laadu. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","―Ma gudxe ni laatu, rabi be laaca'. ―Peru qué na tu guni cre tu. Ca dxiiña rune la? rune ni purti nuu né Bixhoze naa, ne laacani rusihuinni cani tu naca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Peru qué runi cre tu purti cadi za tu lade ca dendxu stinne', casi gudxe laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Runebia'ya ca dendxu stinne' ne rucaa diaga ca naa, ne rizá nanda ca naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Rudiee laaca enda nabani ni qué zaluxe ne qué ziuu dxi initilú ca', ne iruti zanda gaxha laaca ndaani naya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bixhoze bidii laaca naa. Iruti zanda gaxha laaca ndaani ná Bixhoze', purti jma nandxó' Bixhoze que irá xixé. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Naa ne Bixhoze', tobi si laadu. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Oraque gundisa ca judíu guie sti tiru, nuchá ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Para rabi be laaca': ―Ucané Bixhoze naa bine stale cosa ni galán lade tu. Uná de laacani qué ñuula'dxi tu para uchá tu guie naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Oraque na ca': ―Cadi cuchá du guie lii purti bi'nu xiixa ni galán, sínuque cuchá du guie lii purti cadi jneza cayuni lu'. Binni guidxilayú lii peru cayu'nu lii Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Para rabi be laaca': ―Lu ley stitu cá ra na Dios: “Unié nia laatu casi ñaca tu dios, purti naa biseenda laatu.” ");
INSERT INTO zaiNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ca binni ucuaa stiidxa be chiqué gudxi be laaca dios, ne qué zanda uchiá nu Xqui'chi be. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yanna naa, ulí Dios naa ne biseenda naa ndaani guidxilayú ri', ne na tu cadi jneza cayune tisi rabe Xiiñi Dios naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Pa cadi cayune xhiiña Bixhoze la? cadi guni cre tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ne pa cayune ni la? neca qué runi cre tu ni rinié', peru laguni cre dxiiña ca ti ganna tu ne guiene tu tobi si naa ne Bixhoze'. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bigueta ucala'dxi ca judíu ninaaze ca laabe, peru biree yaande be de ndaani ná ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Uyé be cherica guiigu Jordán sti tiru, ra bizulú guluu nisa Juan binni. Ne biaana be raqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Uyé stale binni ra nuu be, ne na ca': ―Nin ti milagru qué ñuni Juan, peru irá ni bizeete be de hombre ri la? irá ni dxandí'. ");
INSERT INTO zaiNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ne stale binni bini cre Jesús raqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Chiqué huará tobi hombre lá Lázaro, biza'na María ne Marta. Nabeza ca ndaani guidxi Betania. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María, biza'na Lázaro ni huará que la? nga nga dxa gunaa ni bichá nisa rindá' naxhi ñee Señor ne bicuiidxi né ni guicha ique que. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bisenda tidxi iropa benda cabe Jesús huará Lázaro, xhamigu. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ora gunna Jesús ni la? na: ―Enda huará ni napa be ca la? cadi para guuti, sínuque para ihuinni enda nandxó' sti Dios ne sti Xiiñi'. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nadxii Jesús guionna cabe, Marta ne María ne Lázaro. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ne ora gunna be huará Lázaro, biaana be xhupa gubidxa ra nuu be que. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","De raqué rabi be ca discípulu stibe: ―Chuu Judea sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Para na ca rabi ca laabe: ―Maistru, ñee cadi cayuuya lu nase si ngue ucala'dxi ca judíu nuchá ca guie lii ne yanna nou' ibigueta lu raqué sti tiru la? ");
INSERT INTO zaiNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Oraque rabi be laaca': ―Ñee cadi doce hora napa ti dxi la? Ni rizá ridxí la? qué rirenda gasti ñee purti naya'ni ra zizá. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Peru ni rizá huaxhinni la? rirenda xiixa ñee, purti gasti biaani ra nuu. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Gudxi si be ngue laaca' para na be: ―Nisiaasi Lázaro xhamigu nu peru ma chaa', chi ucuaane laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Oraque na ca discípulu stibe: ―Pa nisiaasi be la? Señor, zianda be. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Peru qué ñene ca xi na be. Zácaxa ca cuzeete be nisiaasi si Lázaro, tihua cuzeete be ma guti. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Oraque bisiá be stiidxa be, rabi be laaca': ―Ma guti Lázaro. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Para laatu la? jma galán qué guinne raqué ti guni cre tu. Yanna chuu canu ra nuu be. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Oraque na Tomás, ni rabi cabe Cuachi que, rabi ca xcaadxi discípulu que: ―Chuu, chu né laabe ti gati né nu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ora yendá be Betania ma raca tapa gubidxa de ga'chi Lázaro. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Cadi zitu de Jerusalén riaana Betania, bia' chonna kilómetru si. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Stale judíu yeizaca Marta ne María ra guti biza'na ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Casi gunna Marta ma zidxiña be, biree yechagalú laabe, peru María biaana yoo. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ne na Marta rabi laabe: ―Pa ñuu lu rarí la? Señor, qué ñati di bizana'. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Peru laca nanna irá ni inaba lu lu Dios la? zudii lii. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Para rabi be laa: ―Zabani biza'na lu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Oraque na Marta: ―Nanna zabani be dxi iluxe guidxilayú, ra ibani irá binni. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Para na be: ―Naa nga rusibane gue'tu', ne naa nga rudiee enda nabani. Tu guni cre naa la? neca ma guti zabani, ");
INSERT INTO zaiNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ne cani nabani ru ne runi cre naa la? qué ziuu dxi gati'. Ru'nu cre nga la? ");
INSERT INTO zaiNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","―Rune cre, Señor, na Marta. ―Ma bine cre lii nga Cristu, Xiiñi Dios ni beeda ndaani guidxilayú ri'. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ngue si uní' ne biree yení' xa diaga María benda, na: ―Nuu Maistru rarica', racala'dxi iní' né lii. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Oraqueca biasa uxooñe María, uyé ra nuu Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ca'ru guiuu Jesús ndaani guidxi, nuu ru ra yechagalú Marta laa que. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ora bi'ya ca judíu ni yeganna laacabe ralidxi cabe que biree uxooñe María ze la? yenanda ca laabe, na ca ziguuna be ra ba'. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Peru casi yendá be ra nuu Jesús biiya be laa, bizuxibi be xa ñee, ne na be: ―Señor, pa ñuu lu rarí la? qué ñati di bizana'. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ora bi'ya Jesús cayuuna be, laabe ne ca judíu zinanda laabe que, uyuu yuuba ladxidó' dede uca diti, ");
INSERT INTO zaiNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ne na: ―Paraa gudixhe tu Lázaro. ―Chuu, gu'yu', Señor, na cabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Biina Jesús óraque. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Para na ca judíu: ―Laguuya pabiá' gunaxhii be Lázaro. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Peru xcaadxi de laaca na: ―Bixhele be lú ni nacheepa lú. Ñee qué ñanda ñuni be xiixa para qué ñati Lázaro la? ");
INSERT INTO zaiNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Bigueta uyuu yuuba ladxidó' be, ne uyé be ra ba' que. Casi ti cueva ni, ye'gu ti guie ruaa ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","―Lacuee guie ca ruaa ni, na be. Para na Marta, biza'na ni guti que: ―Ma rindá' yuudxu be, Señor, purti ma napa be tapa gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Oraque na Jesús rabi laa: ―Ñee cadi ma gudxe lii pa guni cre lu zuuyu pabiá' nandxó' Dios la? ");
INSERT INTO zaiNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ne óraque ulee cabe guie ye'gu ruaa ba' que. Undisa lú Jesús ibá', ne na: ―Rudiee diuxquixe lii, Bixhoze', purti bicaa dia'gu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nanna ca' qué riaana dxiu de ucaa dia'gu naa, peru unié sicarí pur ca binni ni rí rarí' ti guni cre ca lii biseenda lu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Biluxe uní' né si be Bixhoze be, bicaa be ridxi: ―¡Lázaro, gudá' rarí'! ");
INSERT INTO zaiNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Oraque biree gue'tu que, renda lari ná ne ñee, ne ye'gu ti lari lú. Para na Jesús: ―Lauxhedxe laabe, ne laudii lugar che be. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Stale de ca judíu ni yené María que, bini cre ca Jesús ra bi'ya ca ni guca que. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Peru xcaadxi de laacabe yetidxi ca fariseu xi bi'ni be. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Oraque gupa ca xaíque sti ca sacerdote ne ca fariseu ti junta, purti laaca nga justicia sti ca judíu, ne na ca': ―Xi guni nu pue. Biaa irá ni cayuni hombre ca. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Pa usaana nu laabe zacasi la? irá binni zuni cre laabe. Ne zeeda ca romanu zeda unitilú ca yu'du ro stinu ne xquidxi nu. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Lade cabe zeeda Caifás, naca sacerdote gola iza que. Ne óraque na rabi laacabe: ―Laatu qué ganna tu gasti'. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Qué riene tu pa jma galán para laanu gati tobi jlugar irá nu, ti cadi initilú irá binni xquidxi nu la? ");
INSERT INTO zaiNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Peru cadi de laasi be uní' be ni. Purti naca be sacerdote gola iza que, nga runi bisiní' Dios laabe ni nexhe gaca'. Ne ni nexhe gaca nga gati Jesús pur ca binni xquidxi. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ne cadi pur ca binni xquidxi si sínuque para guni irá xixé xiiñi Dios ni reeche ndase tobi si. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ne dede dxi que uní' stiidxa cabe guuti cabe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ngue runi ma qué ñanda nizá be lade ca judíu. Biree be de raqué uyé be ti guidxi huiini lá Efraín, dxaaga ni ti gui'xhi', ne raqué biaana né be ca discípulu stibe. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ma zeda yuba pascua. Stale binni de ca guidxi huiini que uyé Jerusalén, yeguni ca casi cá lu ley stica guni ca para guia ladxidó' ca', laga ca'ru uzulú saa que. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Biyubi cabe Jesús raqué, ne ora nuu cabe ndaani yu'du ro', na cabe: ―Xi na tu. Nagana pa gueeda be saa ri nja'. ");
INSERT INTO zaiNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Maca bizaabi ca xaíque sti ca sacerdote ne ca fariseu diidxa', tutiica gu'ya laabe la? chi tidxi laaca para inaaze ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Cayaadxa ru xhoopa gubidxa para ganda saa que, uyé Jesús Betania, ra nuu Lázaro ni bisibani que. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Raqué bidii cabe laabe ti endaró xhi. Marta cutiidi ni ne Lázaro zuba né laabe ra mexa que. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ne ucuaa María ti libra aceite rindá' naxhi ni nabé risaca, uxubi ñee be ne bichaa ni ne guicha ique, dede bidxá yoo que de xho' naxhi que. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Oraque na Judas Iscariote xiiñi Simón, tobi de ca discípulu stibe (dxa ni chi utoo laabe que): ");
INSERT INTO zaiNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Xiñee qué nidoo aceite rindá' naxhi ri chonna gayuaa denariu para ñaazi lú ca pobre. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Uní' be zaqué, cadi purti cayá be ca pobre sínuque purti gubaana laabe ne purti rapa be caja bidxichi que, ne ribee be lú ni para laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Para na Jesús rabi laabe: ―Zaa nuu be. Cayapa be ni para naa dxi igaache'. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ca pobre la? qué ziuu dxi guiaadxa lade tu, peru naa, zadxiña dxi ma qué ziuaa nia laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Stale de ca judíu ora gunna ca nuu Jesús raqué, beda guuya ca laabe, peru cadi laasi be, sínuque laca beda guuya ca Lázaro ni bisibani be que. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ngue runi uní' stiidxa ca xaíque sti ca sacerdote guuti ca nécaca Lázaro, ");
INSERT INTO zaiNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","purti pur Lázaro stale de ca judíu caxele de laaca', cayuni cre Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sti dxi que stale binni ni zigapa saa ro' que, bina diaga ma zeda yuu Jesús Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Para biree ca zichagalú ca laabe. Bichuugu ca ziña daa ne bicheeche ca cani ra zidi'di be. Ne bicaa ca ridxi: ―¡Lausisaca ni biseenda Dios! ¡Ndi nga Rey sti Israel! ");
INSERT INTO zaiNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Bidxela be ti burru huiini', udxi'ba be laa, casi cá ni ra na: ");
INSERT INTO zaiNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Cadi idxibi tu, binni Sion ca'. Laguuya', zeeda Rey stitu deche ti burru huiini'. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Qué ñene gá ca discípulu cani cayaca que. Dede dxi ru ma nuu be ibá', dxi que ru bietenala'dxi cabe maca cá irá ni lu gui'chi', ne casi cá ni que zaqué bi'ni binni laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nuu ca binni bi'ya ra bisibani be Lázaro raqué, cayuí' ca ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ne ngue runi stale binni yechagalú laabe, purti bina diaga ca de milagru bi'ni be que. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Oraque na ca fariseu: ―Biaa guuyu', ma qué zanda guni nu gasti'. Ma irá xixé binni guidxilayú zinanda laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Laca uyé caadxi ni cadi judíu lade cani yeusisaca Dios ndaani saa que. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ne uyé ca ra nuu Felipe de Betsaida, ti guidxi sti Galilea, ne rabi ca laa: ―Señor, racala'dxi du idu'ya du Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Para uyé Felipe, yetidxi ni Andrés. Oraque iropa ca yetidxi ca ni Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Para na Jesús rabi laaca': ―Naa nga Hombre Biseenda Dios ne ma bidxiña hora usisaca be naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Peru gabe ca' laatu, pa qué gati ti guie xuba ora guiaba ndaani yu la? qué zache ndu, peru pa gati ni la? zandani ni ne zacá lú ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tu ganaxhii xpida zuniti ni, peru tu qué izaala'dxi xpida ndaani guidxilayú ri la? cayapa ni para enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ni racala'dxi gaca xpinne la? sa nanda naa, ne ra chaa la? laca zie ca xpinne' ne zusisaca Bixhoze laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ma nuu yuuba ladxiduá'. Yanna xi inié'. Ñee zabe Bixhoze ulá naa de ni chi tide ri la? Co', purti para tide ni nga runi bidxiña dede rarí'. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Oraque na be: ―Bixhoze', bisisaca lá lu jma. Oraque ucuá ti ridxi de ibá', na: ―Ma bisisaca ni, ne zusisaca rua' ni sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bina diaga ca binni ni nuu raqué ridxi que, ne caadxi de laaca na rayu ni. Peru xcaadxi na ti ángel uní' né laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Para rabi be laaca': ―Cadi ucuá di ridxi ri para naa sínuque para laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yanna nga ma chi guiaba ná binni guidxilayú ne ma chi ilá ni runi mandar ndaani ni ti ladu. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ne ora ma undisa cabe naa la? zabidxe binni gueeda ra nuaa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ra uní' be zacá bisiá be diidxa xi enda guti chi caa be. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Oraque na ca binni que rabi laabe: ―Laadu huayuna diaga du xi na Xqui'chi Dios. Na ni qué ziuu dxi gati Cristu. Xi modo nga nou' lii, naquiiñe indisa cabe Hombre Biseenda Dios lu cruz. Tuu nga Hombre Biseenda Dios ca ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Para rabi be laaca': ―Ma nagaba si dxi nuu biaani lade tu. Yanna lasá laga napa tu biaani ti cadi inaaze guelacahui laatu. Purti cani rizá ra nacahui la? qué ganna ca paraa che ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Naa nga biaani ni ruzaani laatu ne laga nuaa nia laatu laguni cre naa ti chu' tu ra naya'ni'. Biluxe si uní' be ngue, biree be de ra nuu ca', yeucachi lú be. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Neca bi'ni be stale milagru nezalú ca' peru qué ñuni cre ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ne uca ni zacá para iree ni casi pe uní' profeta Isaías chiqué ra na: Señor iruti cayuni cre ni cayuí du ne iruti cayuuya pabiá' nandxó' Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Qué ñanda ñuni cre cabe, ne laca uní' Isaías xiñee qué ñanda ñuni cre cabe, ra na: ");
INSERT INTO zaiNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Bisicheepa Dios lú cabe, ne biquidxi ladxidó' cabe, ti cadi gu'ya cabe ne qué guiene cabe, uyubi cabe laa para ulá laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Uní' Isaías ca nga purti biiya pabiá' nandxó' Jesús, ne byuí' stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Neca ne irá nga guyuu stale de ca xaíque bini cre laabe, peru naga'chi' purti ridxibi ca cuee ca fariseu laaca de ndaani yu'du'. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Purti jma riula'dxi ca usisaca binni laaca que usisaca Dios laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Oraque uní' Jesús ne gana na: ―Ni runi cre naa la? runi cre ni biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ne ni ruuya naa la? ruuya ni biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Naa nga biaani ni ruzaani laatu. Yanna benda ndaani guidxilayú ti irá tu guni cre naa cadi guiaana ra nacahui. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ni ucaa diaga naa ne qué guni ni rabe la? qué zudxiiba donda ique, purti cadi beda udxiiba donda ique binni guidxilayú sínuque beda ula'ya laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Peru tu udxii naa, qué icaa stiidxa la? ma napa ni udxiiba donda ique. Ca diidxa ni unié', ca nga udxiiba donda ique cabe dxi cuidxi Dios cuenta binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Purti cadi de naa sia' unié' sínuque maca udixhe Bixhoze ni biseenda naa xi inié'. ");
INSERT INTO zaiNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nanna dxi'che ni udixhe Bixhoze inié ca la? rudii ni enda nabani ni qué zaluxe. Nga runi rinié ni casi gudxi Bixhoze ni naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ca'ru uzulú saa pascua, peru maca nanna Jesús ma bidxiña hora iree ndaani guidxilayú ri', ibigueta ra nuu Bixhoze. Ne cásica bizulú gunaxhii be ca xpinni be ni nuu ndaani guidxilayú zaqueca nadxii be laaca dede yanna ra ma chi iluxe xhiiña be. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Dede ora cayó xhi cabe, maca biuu binidxaba ndaani ladxidó' Judas Iscariote, xiiñi Simón, para utoo laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Nanna be ma gudixhe Bixhoze be irá xixé cosa lu ná be ne nanna be ra nuu Bixhoze be biree be ne ra nuu Bixhoze be che be. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Biasa be lu endaró xhi que, ulee be xhaba be ne ucuaa be ti toalla bixhii be ndaani be. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ne ucuaa be ti bandeja udaa be nisa ndaani', ne bizulú gudiibi be ñee ca discípulu stibe ne bicuiidxi né be ni toalla xi' ndaani be que. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ora bidxiña be ra nuu Simón Pedru na rabi laabe: ―Señor, lii sica qui'bi lu ñee la? ");
INSERT INTO zaiNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Para rabi be laa: ―Nagasi cadi cayene lu ni cayune ri', peru ziene lu ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","―Co', na Pedru. ―Qué ziuu dxi qui'bi lu ñee'. Bigueta rabi be laa: ―Pa qué quibe ñee lu la? cadi xpinne lii. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Oraque na Simón Pedru: ―Señor, cadi ñee sia' qui'bi lu' sínuque ne naya ne ique'. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Para rabi be laa: ―Ni ma bia'ri la? ma nayá. Ma cadi naquiiñe guia'ri ru paxaraa sínuque ñee si. Laatu la? ma nayá tu, neca cadi irá tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nanna be tu chi utoo laabe. Nga runi uní' be: “Cadi irá tu nayá tu.” ");
INSERT INTO zaiNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Biluxe udiibi si be ñee ca', ucuaa be xhaba be, bigueta be ruaa mexa que ne rabi be laaca': ―Ñee biene tu ni bine laatu ca la? ");
INSERT INTO zaiNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Laatu rabi tu naa Maistru ne Señor, ne jneza runi tu purti nga nga naca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Inque naa, naca Señor ne Maistru stitu ne gudiibe ñee tu la? lágaxa laatu qué qui'bi saa tu ñee tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Purti ma bilué laatu xi guni tu, ti casi bine laatu ca, zacaca guni tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ne gabe ca' laatu, qué risaca ti mozo jma que xpixuaana'. Zaqueca ni rie mandadu, qué risaca jma que ni biseenda laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Pa nanna tu ca nga ne guni tu cani la? dichoso de laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Cadi cuzeete irá tu, purti runebia'ya cani ulié', peru cayaca ni sicarí ti iree ni casi cá lu Xqui'chi Dios: “Ni gudó ne naa pan beda aca nanala'dxi naa.” ");
INSERT INTO zaiNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Cayabe ca' ni laatu yanna laga ca'ru aca ni, ti ora ma uca ni la? guni cre tu dxandí naca ni gudxe laatu naca ca. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Gabe ca' laatu, ni icaa stiidxa cani useenda la? cacaa stiidxa', ne ni icaa stiidxa la? cacaa stiidxa ni biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Casi biluxe uní' Jesús uyuu yuuba ladxidó' ne na: ―Gabe ca' laatu, tobi de laatu chi utoo naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Biiya dxí saa ca discípulu lú ca'. Qué ganna ca tu cuzeete be. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Bia'si pe ladxidó' be naguixhe ique dxa discípulu nadxii be que. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Oraque bi'ni Simón Pedru seña discípulu que inaba diidxa tu cuzeete be. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Para na discípulu ni naguixhe ique ladxidó' be que rabi laabe: ―Tu laabe ya', Señor. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Oraque na be: ―Ni udiee laa pan ni ugadxe ca la? nga nga laabe. Para bigadxe be pan que ne bidii be ni Judas Iscariote, xiiñi Simón. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Casi ucuaa Judas ni bidii be laa que, uyuu binidxaba ndaani ladxidó', ne óraque rabi be laa: ―Ni chi gunu ca la? bi'ni ca ni nagueenda. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Peru nin tobi de cani nuu ruaa mexa que qué ñene xiñee gudxi be Judas zaqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nuu de laaca zácaxa gudxi be Judas chi sí xiixa ni cayaadxa para saa que o udii xiixa ca pobre, purti laa naaze bolsa vueltu. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ucuaa si Judas pan que, biree ze'. Ne bia'si ma huaxhinni ngue. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Biree si be, na Jesús: ―Yanna ma bidxiña hora ihuinni pabiá' risaca Hombre Biseenda Dios ne pur laa zahuinni pabiá' risaca Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ne pa isaca Dios pur laabe la? laca zuni Dios pur isaca be de laasi be, ne mápeca chi aca ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Xiiñe huiine ca', ma sti ratu si nuaa nia laatu. Zuyubi tu naa, peru chi tidxe laatu casi gudxe ca judíu chiqué, ra chaa qué zanda che tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Chi tixhe ca' xiixa nacubi guni tu, ganaxhii saa tu cásica huayanaxhiee laatu. Zacá laganaxhii saa. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Pa ganaxhii saa tu zacá la? zanna binni xpinne laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Oraque na Simón Pedru rabi laabe: ―Paraa cheu' ya, Señor. Para rabi be laa: ―Ra chaa la? qué zanda chi nandu naa nagasi peru ziuu dxi cheu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","―Xiñee qué zanda chi nanda lii nagasi, Señor, na Pedru. ―Dede xpida zudiee pur lii. ");
INSERT INTO zaiNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","―Dede xpida lu zudiiu pur naa nou' la? na Jesús. ―Gabe ca' lii, chonna tiru zaníu' qué runibióu' naa, ante guunda gallu. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Cadi chu' yuuba ladxidó' to. Laguni cre Dios, ne laca laguni cre naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nuu stale lugar ra chu' tu ralidxi Bixhoze'. Pa ñaca cadi zacá ni la? ñabe ca' ni laatu. Yanna ma chaa', chi gune chaahue ti lugar para laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ne ora ma uyaa ne ma bine chaahue ni la? zabigueta gueda caa laatu, ti ra chuaa la? laca chu' tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ma nanna tu paraa chaa' ne nanna tu neza. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Oraque na Tomás: ―Señor, qué ganna du paraa cheu'. Ximodo nga nou' nanna du neza ca ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Para na Jesús: ―Naa nga neza ca, ne rusiide ni dxandí' ne rudiee enda nabani ni qué zaluxe. Iruti zie ra nuu Bixhoze pa cadi pur naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Pa ñunibiá' tu naa la? laca ñunibiá' tu Bixhoze'. Yanna ma biiya tu laabe ne ma runibiá' tu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Oraque na Felipe: ―Señor, biluí' laadu Bixho'zo ne ma nga si. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Para na be: ―Biaa padxí nuaa nia laatu, ne ca'ru gunibiá' lu naa la? Felipe. Ni ma biiya naa la? ma biiya Bixhoze'. Ximodo nou' ulué laatu Bixhoze ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ñee qué runi cre lu pa tobi si naa ne Bixhoze la? Cadi naa riguixhe ni rue nia laatu, sínuque de Bixhoze zeeda ni. Ne irá ni rune la? casi ñaca laabe cayuni be ni, purti tobi si laadu. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Laguni cre ni cayabe laatu, tobi si naa ne Bixhoze'. Pacaa laguni cre naa pur cani rune ca. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Gabe ca' laatu, irá cani runi cre naa zuni cani rune ca. Ne jma que nga zuni ca' purti chaa ra nuu Bixhoze'. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Irá ni inaba tu lu Bixhoze gune purti xpinne laatu la? zune ni, ti usisaca binni Bixhoze pur naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Pa inaba tu xiixa la? zune ni purti xpinne laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Pa nadxii tu naa la? zuzuuba tu stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ne naa zanaba lu Bixhoze udii laatu stobi ni guiaana né ca laatu para acané laatu ne usieche laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Cuzeete Espíritu ni riní' puru si ni dxandí', ne nga nga Espíritu Santu. Cani cadi xpinne' qué zanda icaa laabe, purti qué ruuya laabe ne qué runibiá' laabe. Peru laatu runibiá' tu laabe purti nabeza be lade tu ne ziuu be ndaani ladxidó' to. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Qué zusaana laatu casi bizabi sínuque zenda rua' ra nuu tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Xcaadxi si ma qué zuuya binni naa, peru laatu zuuya tu naa. Ne zabani tu purti nabane'. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Dxi que nga ganna tu tobi si naa ne Bixhoze', cásica naa naca nia laatu tobi si ne laatu naca né tu ni naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ni ma napa stiidxa' ne guni ni na ni la? ngue nga ni nadxii naa. Ne ni nadxii naa la? zanaxhii Bixhoze laa, ne naa laca zanaxhiee laa ne zulué laa tu pe nga naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Oraque na Judas rabi laabe (peru cadi Judas Iscariote): ―Señor, ximodo nga nou' laasi du ganna du tu nacu' ne cadi irá binni. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Para na be: ―Ni nadxii naa la? zuzuuba stiidxa' ne zanaxhii Bixhoze laa ne zeda guiaana né du laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ni cadi nadxii naa la? qué ruzuuba stiidxa'. Cadi stiidxa dia' nga ni cayuna diaga tu ri', sínuque stiidxa Bixhoze ni biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Cayabe ca' ndi laatu laga nuaa nia laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ne zuseenda Bixhoze Espíritu Santu gueda acané laatu ne usieche laatu, casi ñaca naa nuseenda laa. Ne laa zusiene laatu irá xixé cosa, ne zusietenala'dxi laatu irá ni huayué nia laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Zaguixhe dxie ladxidó' to casi nexhe dxí ladxiduá'. Ne zune ni cadi casi runi binni guidxilayú. Cadi chu' tu xizaa ne cadi idxibi tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ma bina diaga tu gudxe laatu chaa', peru zabigueta ra nuu tu sti tiru. Pa ñanaxhii tu naa la? ñeche tu ti rabe chaa ra nuu Bixhoze', purti jma nandxó' Bixhoze que naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Cayabe ca' ni laatu nagasi laga ca'ru aca ni, ti ora aca ni la? guni cre tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma huaxié' zanda güe nia laatu diidxa', purti ma zeeda xaíque sti guidxilayú ri'. Qué zanda guni mandar be naa, ");
INSERT INTO zaiNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","peru naquiiñe gaca ni zacá para ganna binni nadxiee Bixhoze', ne rune ni gudxi naa gune'. Yanna, laguiasa, chuu canu de rarí'. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Naa zeda gaca casi ti lubá' uvas, ne iruti ru stobi casi naa. Ne Bixhoze zeda gaca casi ni rapa lubá' que. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Irá rama stinne ni qué icá lú maca ziugá be, peru cani icá lú la? zusiá be laaca para jma rusi gudii ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Laatu ma nayá tu, purti ma bini cre tu ca diidxa byue nia laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Laguiaana né naa tobi si, ne naa ziaana nia laatu tobi si. Casi ti rama qué zanda icá lú pa cadi gui'di cue' yaga, zaqueca laatu qué zaree ndu ni cayuni tu pa cadi nuu né tu naa tobi si. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Naa nga lubá' ne laatu nga rama. Ni guiaana né naa tobi si la? nabé zaree ndu ni guni. Purti pa ixele tu de naa gasti qué zanda guni tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ni qué guiaana né naa, maca zilá ti ladu, ibidxi para idopa icá gui. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pa guiaana né tu naa ne guiaana stiidxa ndaani ladxidó' to la? lainaba intiica gacala'dxi tu, zacaa tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Zusisaca tu Bixhoze pa iree ndu ni cayuni tu lu xhiiña', ne zacá zahuinni xpinne laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Cásica nadxii Bixhoze naa zacaca nadxiee laatu. Cadi uyubi tu usaana de ganaxhiee laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Pa uzuuba tu stiidxa', qué zusaana de ganaxhiee laatu, casi qué huasaana Bixhoze de ganaxhii naa purti ruzuuba stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Huayué nia laatu irá ndi ti guieche tu casi nayeche nuaa' ne zacá zazaa enda nayeche stitu. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ndi nga ni rabe laatu guni tu: Ganaxhii saa tu cásica huayanaxhiee laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Iruti zanda ganaxhii jma que bia' nadxii tobi ni udii xpida pur ca xhamigu. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Laatu nga xhamigua pa guni tu ni rabe'. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ma cadi mozo stinne laatu, purti mozo qué ganna xi runi xpixuaana', sínuque ma xhamigua laatu purti ma gudxe laatu irá ni gudxi Bixhoze naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Cadi laadi tu gulí tu naa, sínuque naa gulié laatu. Ne gudixhe laatu para iree ndu ni guni tu ne cadi initilú ni, ti intiica inaba tu lu Bixhoze', zudii laatu purti xpinne laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ndi nga ni rabe laatu guni tu: Ganaxhii saa tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Pa gaca nanala'dxi binni laatu la? laguietenala'dxi nirudó' uca nanala'dxi cabe naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Pa ñaca de laacabe laatu la? ñanaxhii cabe laatu, peru ma ulee laatu de lade cabe, nga runi nanala'dxi cabe laatu, purti cadi de laacabe laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Laguietenala'dxi ni gudxe laatu: “Qué risaca ti mozo jma que xpixuaana'.” Pa huazabi nanda cabe naa, laca zazabi nanda cabe laatu. Ne laca pa ucuaa cabe stiidxa la? laca zacaa cabe stiidxa tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Irá nga zuni cabe laatu ti xpinne laatu, purti qué runibiá' cabe ni biseenda naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Pa qué ñeda güe nia laacabe diidxa la? qué ñapa cabe donda purti qué ñanna cabe pa cuchee cabe, peru ma qué gapa cabe xi cu' ruaa cabe yanna. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ni aca nanala'dxi naa la? laca cayaca nanala'dxi Bixhoze'. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Pa qué ñune milagru ni iruti huayuni lade cabe la? qué ñapa cabe donda, peru neca ma biiya cabe irá ni peru uca nanala'dxi cabe naa ne Bixhoze'. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Peru caree ni zacá para gaca ni casi cá lu Xqui'chi Dios ra na: “Guca nanala'dxi cabe naa sin nuzaabe gasti'.” ");
INSERT INTO zaiNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","De ra nuu Bixhoze zuseenda Espíritu Santu gueda acané laatu ne usieche laatu. Riní' be ni dxandí', ne ora gueeda be, zusiene be laatu tu pe nga naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Laatu laca zusiene tu binni tu naa purti uyuu né tu naa dede dxi bizuluá'. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Huayué nia ca ndi laatu ti cadi chu' xiixa uchenda laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Zabee cabe laatu ndaani yu'du', ne dede zadxiña dxi tutiica guuti laatu zaná cayuni xhiiña Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ne zuni cabe zacá purti qué runibiá' cabe Bixhoze nin naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Cayabe ca' ni laatu, ti ora aca ni, guietenala'dxi tu maca gudxe ni laatu. Qué ñabe dia' ni laatu dede dxi bizuluá' purti nuaa nia laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Peru yanna ma chaa ra nuu ni biseenda naa, ne nin tobi de laatu cadi canaba diidxa tu naa paraa chaa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Sínuque laga yuuba uyuu ladxidó' to, tisi gudxe ca nga laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Laguni cre ni cayabe laatu ri'. Jma galán zaca para laatu pa chaa', purti pa qué chaa', qué zeeda ni nexhe gueda acané laatu ne usieche laatu qué. Peru pa chaa la? zuseenda laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ne ora gueeda be zuluí' be binni cuchee ca', ne zuluí' be laaca xii nga jneza, ne laca zuluí' be laaca napa Dios xidé cuidxi cuenta binni. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Cuchee ca purti cadi cayuni cre ca naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Zuluí' be laaca xii nga jneza purti chaa ra nuu Bixhoze ne qué zuuya ru tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Laca zuluí' be laaca zabidxi Dios cuenta binni, purti ma guridxi cuenta xaíque sti guidxilayú ri'. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Napa rua' stale ni ñabe laatu, peru nagasi qué zanda guni huantar tu ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Peru ora gueeda Espíritu Santu, zusiene laatu irá ni dxandí' ne ni chi gaca ru'. Riní' be puru ni dxandí', ne cadi laabe chi tixhe be ni iní' be sínuque zabi be laatu irá ni gabi Bixhoze laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Zusisaca be naa purti zui' né be laatu stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Stinne irá ni napa Bixhoze'. Nga runi rabe laatu zui' né be laatu stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Xcaadxi si ma qué zuuya tu naa, purti chaa ra nuu Bixhoze', peru qué zandaa ibigueta guuya tu naa sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Oraque unaba diidxa saa ca discípulu, na ca': ―Xii ndi cayabi be laanu pue, na be xcaadxi huiini si ma qué zadu'ya nu laabe purti che be ra nuu Bixhoze be, ne qué zandaa ibigueta idu'ya nu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ne xii nga na be, xcaadxi huiini si pue. Qué riene nu xi caní' be. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Biene Jesús racala'dxi cabe inaba diidxa cabe laa, para na rabi laacabe: ―Ñee racala'dxi tu ganna tu xii nga rabe laatu ora unié' xcaadxi huiini si ma qué zuuya tu naa, ne qué zandaa guuya tu naa sti tiru la? ");
INSERT INTO zaiNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Gabe ca' laatu, laga cayeche binni, laatu zacaná ladxidó' to ne zuuna tu. Peru zeda iree ca enda naná stitu que enda nayeche'. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nabé stale yuuba rudii ti gunaa ora ma chi gapa ba'du', peru ora ma gule ba'du que la? ma nin ranna be pa nuu yuuba que, purti cayeche be ma biuu sti binni ndaani guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Zacaca laatu, nagasi nuu yuuba ladxidó' to, peru zabigueta guuya laatu ne óraque zieche ladxidó' to, ne iruti zaxha enda nayeche que laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Dxi que qué zanaba diidxa tu naa gasti'. Gabe ca' laatu, irá ni inaba tu Bixhoze', zacaa tu purti xpinne laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dede nagasi qué huanaba tu gasti neca xpinne laatu. Lainaba, zacaa tu, ti izaa chaahui enda nayeche stitu. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Irá ni huayué nia laatu huayué nia ni laatu ne ejemplu, peru zadxiña dxi ma qué zue nia laatu diidxa zacá, sínuque zusiene pia' laatu tu naca Bixhoze'. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Zanaba tu Bixhoze xiixa dxi que, purti xpinne laatu, ne cadi naquiiñe icaya pia' lu Bixhoze udii ni laatu, ");
INSERT INTO zaiNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","purti laa pe be nadxii be laatu ti nadxii tu naa ne bini cre tu ra nuu be biree'. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","De ra nuu be biree' benda ndaani guidxilayú ri'. Yanna ma chi usaana guidxilayú ibigueta ra nuu be sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Oraque na ca discípulu stibe rabi laabe: ―Yanna ru ma cusiá lu stiidxa lu', ma cayuí' neu ni laadu para guiene chaahui du, ne cadi ne ejemplu casi ru'nu chiqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ma nanna du nannu irá xixé cosa ne cadi naquiiñe chu' tu caañe lii. Nga runi runi cre du beedu de Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Para rabi be laaca': ―Ma runi cre tu yanna la? ");
INSERT INTO zaiNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Zadxiña hora ireeche ndase tu, ne mápeca bidxiña ni. Cada tobi tu zie tu adxé adxé ladu, zusaana tu naa stube'. Peru cadi stube nuaa', purti nuu né Bixhoze naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Cayabe irá ndi laatu ti gata dxí ladxidó' to purti nuu né tu naa tobi si. Laga nuu tu ndaani guidxilayú ri la? zadi'di tu ni nagana, peru cadi idxibi tu purti ma udixhe dxie guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Biluxe si uní' Jesús ca diidxa ca undisa lú ibá', na: ―Bixhoze', ma bidxiña hora. Bisisaca Xiiñi lu yanna, ti laca usisaca Xiiñi lu lii, ");
INSERT INTO zaiNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","purti gudixhe lu irá binni ladxi ná Xiiñi lu' ti gudii enda nabani ni qué zaluxe irá ni uchiña lu ra nuu. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ne zacaa cabe enda nabani ca ra gunibiá' cabe lii ne ra gunibiá' cabe Jesucristu ni biseenda lu'. Lii nga tobi lucha Dios ni dxandí'. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ma bisisaca lii ndaani guidxilayú ri', ne ma binduuxe ni biseendu naa beda gune'. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yanna la? Bixhoze', bisisaca naa ra nuu lu' casi bisaca raqué dxi ca'ru uzá' lu guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Cani ulee chu lu lade binni guidxilayú bidii lu naa la? ma bisiide laaca ximodo lii. Stilu laacabe, peru bidii lu laacabe naa ne ma cuzuuba cabe stiidxa lu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yanna ma nanna cabe irá ni bidiiu naa zeeda ni de lii. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Purti ma byue nia laacabe stiidxa lu' ne ma ucuaa cabe ni. Ma nanna dxichi cabe huandí de ra nuu lu benda', ne lii biseenda lu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Rinaba lii pur laacabe. Cadi canaba pur cani zinanda guidxilayú sínuque pur cani bidiiu naa, purti stiu' laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Irá ni stinne la? stiu', ne ni stiu' la? stinne', ne rusihuinni cabe pabiá' risaca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Naa ma chaa ra nuu lu', ma qué ziaana ndaani guidxilayú ri', peru laacabe ziaana cabe rarí'. Bixhoze ni nacha'hui', cani bidiiu naa ca rinaba lii gapa lu laacabe ne enda nandxó' stiu' ti gaca cabe tobi si casi laanu. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Dxi nuaa nia laacabe ndaani guidxilayú ri la? gupa laacabe ne enda nandxó' stiu'. Biiya chaahue cani bidiiu naa, ne nin tobi qué ninitilú sínuque ni maca nexhe initilú, ti iree ni casi na lu Xqui'chi lu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yanna ma chaa ra nuu lu', peru laga nuaa rua' ndaani guidxilayú ri la? canié ca diidxa ri ti idxá ladxidó' cabe de enda nayeche' casi dxá ladxiduá'. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma bidiee laacabe stiidxa lu', ne ma nanala'dxi cani zinanda guidxilayú laacabe purti cadi zinanda cabe guidxilayú, casi naa laca cadi zinanda guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Cadi canaba lii gaxhu laacabe de ndaani guidxilayú, sínuque ulá lu laacabe de binidxaba'. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Cásica naa cadi zinanda guidxilayú zaqueca laacabe, cadi zinanda cabe guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Dxandí' stiidxa lu'. Bisiene ni laacabe ti ibani cabe para lii siou'. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Cásica biseenda lu naa ndaani guidxilayú ri la? zacaca ma biseenda laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Pur laacabe rusaana idubi vida stinne lu nou' ti ora icaa cabe ni dxandí la? laca usaana cabe idubi xpida cabe lu nou'. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Peru cadi pur laasi cabe canaba lii, sínuque ne pur cani guni cre naa ra guna diaga ni iní' cabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ne rinaba lii aca cabe tobi si casi naca nu tobi si, ne zaqueca aca né cabe laanu tobi si ti ganna binni lii biseendu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Casi bisisaca lu naa la? zaqueca ma bisisaca laacabe ti aca cabe tobi si casi tobi si laanu. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Lii naca neu naa tobi si, ne naa naca nia laacabe tobi si, ti ganda gaca pe cabe tobi si, ne zacá ganna binni lii biseenda lu naa ne nadxiiu laacabe casi nadxiiu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Bixhoze', racaladxe chu' cani bidiiu naa que ra chuaa', ti gu'ya cabe enda risaca stinne'. Bisisaca lu naa purti gunaxhii lu naa dede dxi ca'ru chá guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bixhoze', lii ru'nu jneza. Neca qué runibiá' binni lii, peru naa runebia'ya lii, ne ma nanna ca xpinne lii biseenda lu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ma bisiene laacabe tu naca lu' ne zusiene rua' laacabe ti gapa cabe naa ndaani ladxidó' cabe para ganaxhii saa cabe casi nadxii lu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Biluxe si uní' Jesús ca diidxa ca, biree né ca discípulu sti' uyé ca ndaani ti le' olivo ni nuu cherica arroyo Cedrón. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ne laca nanna Judas, ni bitoo laabe que, lugar ra nuu be, purti stale tiru yené be ca discípulu stibe raqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Para biree uyé ra nuu be. Yené caadxi soldadu ne caadxi gendarme ni rapa ra yu'du', ni biseenda ca xaíque sti ca sacerdote ne ca fariseu. Ne yené ca linterna ne antorcha ne ni ucaa lú né ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Peru ma nanna be xi irá zeeda luguiá be, ngue runi laabe biree be lú ca', rabi be laaca': ―Tu ruyubi tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","―Jesús de Nazaret, na ca'. ―Rarí nuaa', rabi be laaca'. Ne laca nuu Judas ni bitoo laabe que raqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ora bina diaga ca ni na be que la? gurí sa ca atrá dede biaba ca layú. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Bigueta rabi be laaca': ―Tu ruyubi tu. ―Jesús de Nazaret, na ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Para rabi be laaca': ―Cadi ma gudxe laatu naa ndi la? Yanna pa naa cuyubi tu la? laudii lugar che ca xcaadxi ri'. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Uca ni zacá ti iree ni casi gudxi be Bixhoze be: “De irá ni bidiiu naa, nin tobi qué nunite'.” ");
INSERT INTO zaiNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Oraque guxha Simón Pedru espada sti' bigá ti chu diaga Malco ladu derechu, Malco, jmozo sacerdote gola. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Oraque na Jesús rabi Pedru: ―Uluu espada stiu'. Ñee nou' cadi naquiiñe tide irá ni gudixhe Bixhoze tide la? ");
INSERT INTO zaiNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ne óraque bidxiña ca soldadu ne ca xaíque sti ca' ne ca gendarme sti ca judíu, bichá ná ca Jesús ne bindiibi ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nirudó' ra nuu Anás yené ca laabe, purti Anás nga suegru Caifás ni naca sacerdote gola iza que. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ne laca Caifás ri ca nga gudxi ca judíu jma galán gati tobi ti qué gati idubi guidxi. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yenanda Simón Pedru ne sti discípulu Jesús. Ridxaaga sti discípulu que sacerdote gola, ngue runi gunda biuu né laa ra biuu Jesús ndaani patiu sti sacerdote. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peru Pedru biaana fuera. Para biree sti discípulu que, uní' né badu dxaapa ni rapa ra puerta que, para biguu Pedru. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ne na badu dxaapa que rabi Pedru: ―Lii laca discípulu stibe lii nja'. ―Co', na Pedru, ―cadi zaya de laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Bi'ni ca mozo ne ca gendarme que ti gui para idxaa ca', purti nananda raqué. Ne yeuzuhuaa Pedru lade cabe para idxaa. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Laga cayaca irá nga la? canaba diidxa sacerdote gola Jesús tuu nga ca discípulu sti ne xi rusiidi'. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Para rabi be laa: ―Huanié nezalú irá binni. Bisiide ndaani ca yu'du huiini ne ndaani yu'du ro' ra rie stale judíu, ne gasti qué ninié naga'chi'. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Xiñee canaba diidxa lu naa. Unaba diidxa cani huayuna diaga. Laaca nanna ca xi huayué nia laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Casi pe biluxe uní' be udapa tobi de ca gendarme que lú be ne rabi laabe: ―Ñee zacá ricabi cabe sacerdote gola la? ");
INSERT INTO zaiNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Para na be: ―Pa cadi jneza unié la? uní' nezalú irá binni ri paraa bichee', ne pa qué nuchee la? xiñee cagapa lu naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Oraque biseenda Anás laabe ra nuu Caifás sacerdote gola, idubi liibi be. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ra zuhuaa Pedru cadxaa que, unaba diidxa cabe laa: ―Ñee cadi laca tobi de ca discípulu que lii la? ―Co', cadi zaya dia' de laacabe, na Pedru. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Oraque na tobi de ca mozo sti sacerdote gola, familia dxa hombre bigá be diaga que, rabi laabe: ―Ñee cadi ne lii biiya nuu neu laabe ra le' olivo que la? ");
INSERT INTO zaiNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bigueta na Pedru: ―Co'. Ne óraque pe biinda gallu. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bia' zeda yaba biaani biree né cabe Jesús de ralidxi Caifás, yené cabe laa ra palaciu. Laacabe qué ñuu cabe, purti pa ñuu cabe la? nuchee né cabe ley stícabe, ne ma qué ñanda ño cabe ni ro ca binni que saa pascua. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ngue runi biree Pilatu yenaba diidxa laacabe, na rabi laacabe: ―Xi queja napa tu luguiá hombre ri'. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Para na cabe: ―Pa ñaca cadi cuchee be, qué ñeda saana du laabe ra nuu lu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Oraque na Pilatu: ―Lachiné laabe. Laudxiiba donda ique be casi na ley stitu. Para na cabe: ―Laadu qué gapa du derechu guuti du iruti'. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Cayaca ni zacá ti iree ni casi uní' Jesús ra bizeete modo gati'. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Bigueta biuu Pilatu ndaani palaciu ne guridxi Jesús, na rabi laa: ―Ñee lii nga rey sti ca judíu la? ");
INSERT INTO zaiNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Para na Jesús: ―De lii siou' canaba diidxa lu nga la? o uyuu tu gudxi lii xiixa de naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","―Lácaxa judíu naa, na be. ―Ca binni xquidxi lu ne ca xaíque sti ca sacerdote nga beda saana lii ra nuaa'. Xi bi'ni lu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Oraque na Jesús rabi laabe: ―Cadi beda aca dia' rey ndaani guidxilayú ri', purti pa ñaca beda aca rey rarí la? ñasa ca xpinne', nucaa lú para cadi ninaaze ca judíu naa. Peru cadi rarí di nga zeda aca rey. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Para na Pilatu rabi laabe: ―Entonce rey lii pue la? Oraque na be: ―Dxandí rey naa, casi na lu ca. Beda gale ndaani guidxilayú para güe nia binni xii nga ni dxandí'. Ne irá ni zinanda ni dxandí la? rucaa diaga naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Oraque na Pilatu: ―Xii nga ni dxandí ya'. Ne casi biluxe uní' nga biree, uyé ra nuu ca judíu sti tiru, na rabi laaca': ―Qué idxela gasti donda luguiá be. ");
INSERT INTO zaiNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Peru laatu napa tu ti costumbre ilaa ti presu para laatu irá iza ca dxi cayaca saa pascua stitu. Yanna racala'dxi tu undaa rey sti ca judíu ri la? ");
INSERT INTO zaiNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Oraque irá cabe bicaa cabe ridxi: ―Cadi undoou diou' laabe. Bindaa Barrabás. Barrabás nda naca ti gubaana'. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Oraque ucuaa Pilatu Jesús ne bicaa ca xpinni gudiñe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ne ucuaa ca soldadu que guichi, bizá' ca ti la'pa uluu ca ique be, ne bigacu ca laabe ti lari moradu. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bidxiña ca ra nuu be, na ca': ―¡Viva rey sti ca judíu! Ne cagapa ca lú be. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Bigueta biree Pilatu uyé ra nuu ca judíu ne na rabi laaca': ―Laguuya', zeda nia laabe ra nuu tu, ti ganna dxichi tu qué idxela gasti donda luguiá be. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Oraque biree be, nuu la'pa de guichi ique be ne nacu be lari moradu que. Para na Pilatu: ―Laguuya', rarí nuu hombre que. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ora bi'ya ca xaíque sti ca sacerdote ne ca gendarme laabe bicaa ca ridxi: ―¡Bicaa laabe lu cruz! ¡Bicaa laabe lu cruz! Para na Pilatu rabi laaca': ―Laicaa laabe laatu, laucaa laabe lu cruz, purti naa qué idxela gasti donda luguiá be. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Oraque ucabi cabe: ―Napa du ti ley, ne según ley stidu la? naquiiñe gati be, purti bi'ni be laabe Xiiñi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ora bina diaga Pilatu xi na cabe, jma rusi bidxibi. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ne biuu ndaani palaciu que, na rabi Jesús: ―Padé lii. Peru qué nicabi Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Para na Pilatu rabi laabe: ―Qué za'bu naa ni canaba diidxa lii ca la? Ñee qué gannu pa napa derechu ucaa lii lu cruz o undaa lii la? ");
INSERT INTO zaiNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Oraque rabi be laa: ―Qué ñuaa dia' ladxi ná lu pa qué niguixhe Dios ñaca ni zacá. Nga runi jma stale donda napa ni beda saana naa ra nuu lu' que lii. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Dede óraque nisi biyubi Pilatu nundaa laabe, peru bicaa ca judíu ridxi: ―Pa undaa lu laabe la? cadi xhamigu diou' César, purti irá ni guni laa rey cadi nuu né César tobi si. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ne ora bina diaga Pilatu nga la? biree né laabe, yetí ra ribí para udxiiba donda ique binni, ti lugar ni lá Gabata. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Bia'si pe viernes ndaani saa pascua cayaca irá ndi'. Bia' galaa dxi na Pilatu, rabi ca judíu: ―Rarí nuu rey stitu. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Oraque bicaa cabe ridxi: ―¡Yené laabe! ¡Yeucaa laabe lu cruz! ―Rey stitu ucaa lu cruz la? na Pilatu. Para bicabi ca xaíque sti ca sacerdote: ―César si nga rey stidu, ne iruti ru'. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Oraque ru bidii Pilatu Jesús laacabe, ucaa cabe lu cruz. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Para ucuaa cabe Jesús yené cabe laa nua cruz sti', zé ti lugar lá La Calavera. Diidxa hebreu rabi cabe ni Gólgota. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ne raqué bicaa cabe laabe lu cruz, laabe ne xhupa, tobi cada ladu. Laabe nuu be galahui'. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ne bicaa Pilatu caadxi letra ro' ique cruz que. Sicarí na cani: “Jesús de Nazaret, Rey sti ca judíu.” ");
INSERT INTO zaiNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Stale de ca judíu biinda ni cá ique cruz que purti uriá guidxi ucuá be lu cruz, ne ucuá ca diidxa que hebreu, latín ne griegu. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ne na ca xaíque que rabi Pilatu: ―Cadi ucaa lu “Rey sti ca judíu” sínuque bicaa “Na be Rey sti ca judíu laabe.” ");
INSERT INTO zaiNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","―Ni ma bicaa la? ma bicaa', na Pilatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Biluxe si bicaa ca soldadu que laabe lu cruz ucuaa ca xhaba be bi'ni ca ni tapa ndaa, tindaa cada tobi ca'. Peru túnica stibe que la? qué gapa ra di'ba', de ti ndaga si ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Para uní' stiidxa ca cadi icheza ca ni, sínuque cu' ca ni rifa, gu'ya ca tu cuee ni. Bi'ni cabe zaqué ti aca ni casi cá lu Xqui'chi Dios: “Gudiizi cabe xhaba', ne guluu cabe lari stinne lu rifa.” Ne nga pe nga bi'ni ca soldadu que. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Cue' cruz sti Jesús que, zuhuaa jñaa ne benda jñaa, ne María xheela Cleofas, ne María de Magdala. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ora bi'ya Jesús zuhuaa jñaa raqué, ne biiya zuhuaa dxa discípulu ni nadxii que gaxha la? na rabi jñaa: ―Amá, racá zuhuaa xiiñi lu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ne óraque rabi be discípulu que: ―Biiya, racá zuhuaa jñaa lu'. Ne dede óraque ucuaa discípulu que jñaa be zie né ralidxi. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Biluxe si irá nga, nanna be ma biluxe xhiiña be para na be: ―Cayate nisa. Uní' be zacá ti iree ni casi cá lu Xqui'chi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Bia'si pe zuhuaa ti jarra huiini da' vinagre ndaani raqué para bigadxe cabe ti esponja ne bidxiiba cabe ni ique ti bara huiini sti ti yaga lá hisopo, guluu cabe ni ruaa be. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Güe' si be vinagre que, na be: ―Ma biluxe ni. Ne bisaba ique be, guti be. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Viernes cayaca irá ndi ne qué na ca judíu guiaana ca cuerpu que lu cruz purti ma chi uzulú dxi enda riziila'dxi ne laca dxi ro' ni. Para yenaba cabe Pilatu iluuza ñee cani ucuá lu cruz que, ti ganda iree ca de raqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Oraque beeda ca soldadu, guluza ca ñee ni cá primé que, ne zaqueca ñee stobi que, de iropa hombre ni ucuá né Jesús lu cruz que. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Peru ora bidxiña ca ra nuu be, biiya ca ma guti be, ma qué niguza ca ñee be. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Peru bindizi tobi de ca soldadu que ti lanza xcustiá be, ne óraque biree rini ne nisa. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ni bi'ya ra uca ni, ngue nga cayuí' ni, ne dxandí ni caní' be. Laabe nanna be caní' be ni dxandí ti laatu laca guni cre tu. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ne zacá uca ni ti iree ni casi cá lu Xqui'chi Dios ra na: “Qué zaluuza dxita stibe.” ");
INSERT INTO zaiNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Laca nuu sti lugar ra na: “Zuuya dxí cabe ni bindizi cabe lanza.” ");
INSERT INTO zaiNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Guca si nga la? uyé José de Arimatea, yenaba permisu ra nuu Pilatu pa ziné cuerpu sti Jesús. Naca José discípulu sti Jesús peru naga'chi purti ridxibi ca judíu. Ne uná Pilatu bidii ni laabe, para yendete be ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Laca uyé Nicodemo yené bia' ti gayuaa libra mirra nucha áloes, dxa Nicodemo uyé ra nuu be lu gueela que. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ucuaa cabe xcuerpu Jesús bichenda cabe ti lari ne guluu cabe caadxi guixi ni rindá' naxhi ndaani lari que. Para bicaachi cabe laa casi rigaachi ca judíu. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nuu ti le' de yaga guie' ra ucuá Jesús lu cruz que, ne ndaani le' que nuu ti ba' cubi iruti huaya'ta ndaani'. ");
INSERT INTO zaiNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Raqué gula'qui cabe Jesús purti ma chi uzulú dxi enda riziila'dxi', ne nuu ba' que gaxha. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingu ca'ru guiaba chaahui biaani', biree María Magdalena uyé ra ba' que. Ne ora yendá be biiya be ma biree guie ye'gu ruaa ba' que. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Para biree uxooñe be uyé be ra nuu Simón ne sti discípulu ni nadxii Jesús que, ne na be rabi be laaca': ―Ma ulee cabe Señor de ndaani ba', ne qué ganna du paraa gula'qui cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Oraque biree Pedru ne sti discípulu que, ze ca ra ba'. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Iropa ca bixooñe ca', peru sti discípulu que yendá primeru. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Para guta gudaa, biiya ca lari nexhe raqué peru qué ñuu ndaani ba' que. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Bidxiña guxooñe Simón Pedru, beda nanda laabe, ne biuu ndaani ba' que, biiya nexhe ca lari que raqué. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Peru adxé ladu nexhe bayu ni birenda ique be que, cá bieque. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Oraque ru' biuu sti discípulu ni yendá primeru que, biiya ne bini cre. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ca'ru guiene cabe ni cá lu Xqui'chi Dios ra na napa xidé guiasa be de lade gue'tu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Oraque ru bigueta ca discípulu que ralidxi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Peru María biaana fuera ra ba' que, cayuuna'. Idubi cayuuna guta gudaa, biyubi lú ndaani ba' que. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Biiya chupa ángel nacu lari quichi' zuba ra uyuu xcuerpu Jesús, tobi neza ra guta ique be ne stobi neza ra guta ñee be. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Oraque na ca ángel que rabi laa: ―Gunaa, xiñee cayuuna lu'. Para rabi be laaca': ―Purti ziné cabe Señor stinne', ne qué ganna dia' paraa gula'qui cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Casi uní' be ngue, bidxigueta lú be atrá, biiya be zuhuaa Jesús, peru qué ganna be pa Jesús ngue. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Para na Jesús rabi laabe: ―Gunaa, xiñee cayuuna lu'. Tu ruyubu'. Laabe zácaxa be ni rapa raqué caní' né laabe, ne rabi be laa: ―Señor, pa lii yenéu laabe la? gudxi naa paraa gula'qui lu laabe, ti chi caa laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Para na Jesús: ―¡María! Ne óraque ru' bidxii lú be Jesús, ne na be: ―¡Maistru! ");
INSERT INTO zaiNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Oraque na Jesús rabi laabe: ―Cadi ucueeza lu naa purti ca'ru quiba ra nuu Bixhoze'. Peru uyé ra nuu ca biche', ne gudxi laaca ma chi chiba ra nuu Bixhoze ne Bixhoze tu, ra nuu Dios stinne ne Dios stitu. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Para biree María de Magdala, yetidxi ca discípulu ma biiya Señor, ne byuí' né laacabe cani gudxi Señor laa que. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Domingu huadxí que da'gu ca puerta ra nuu ca discípulu purti cadxibi ca ca judíu. Ne beeda Jesús, bizuhuaa lade ca' ne na: ―Gata dxí ladxidó' to. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Uní' si be ngue, biluí' be laaca bataná be ne xcustiá be. Oraque bieche ca ma biiya ca Señor. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Bigueta na be rabi be laaca': ―Gata dxí ladxidó' to. Cásica biseenda Bixhoze naa la? zacaca cuseenda laatu. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Biluxe si uní' be zaqué, bindubi be luguiá ca', ne na be: ―Laicaa Espíritu Santu. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ni guni perdonar tu la? zaca perdonar, peru ni qué guni perdonar tu la? ziaana stonda luguiá'. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Peru qué guinni di Tomás ni rabi cabe Cuachi, tobi de lade doce discípulu que, ra nuu cabe ora uyé Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Para na ca xcaadxi discípulu que rabi laa: ―Ma bidu'ya du Señor. Peru na: ―Pa qué guuya ndaani bataná be ra ucuá ca clavu que, ne qué cuaa bicuini naya ra ucuá ni, ne qué cuaa bata naya ti'xhi be la? qué zune cre dia'. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Gudi'di si xhono gubidxa de ngue, nuu ca discípulu sti Jesús sti tiru ndaani yoo que. Ma ne Tomás nuu né laacabe. Da'gu ra puerta que, peru beeda Jesús ne bizuhuaa lade cabe, ne na: ―Gata dxí ladxidó' to. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ne óraque rabi be Tomás: ―Bichiña bicuini nou' rarí', ne biiya bata naya'. Bisigaa nou' ne guluu ni cue' tixhe ri', ne cadi guiaana neu duda sínuque guni cre lu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Para na Tomás rabi laabe: ―¡Señor stinne' ne Dios stinne'! ");
INSERT INTO zaiNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Para rabi be laa: ―Purti si biiya lu naa, nga runi bini cre lu'. Dichoso cani guni cre naa, neca sin gu'ya'. ");
INSERT INTO zaiNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Stale ru milagru bi'ni Jesús nezalú ca discípulu para ihuinni tu laa. Cadi cá irá ni lu gui'chi ri', ");
INSERT INTO zaiNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","peru ca ndi ucuá ti guni cre tu dxandí Jesús nga ni ulí Dios, ne Xiiñi laabe, ne para gapa tu enda nabani ra guni cre tu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bigueta biiya ru ca discípulu sti Jesús laa. Nuu ca uriá ti nisa ro' rabi cabe Tiberia, ne sicarí uca ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nuu Simón Pedru, ne Tomás ni rabi cabe Cuachi, ne Natanael de Caná de Galilea, ne ca xiiñi Zebedeu, ne xhupa de ca discípulu stibe. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Biree Simón Pedru na rabi laaca': ―Chaa chi naaze benda. ―Laadu laca ziné du lii, na ca'. Ne uyuu cabe ndaani canuá, uyé cabe idubi gueela', peru gasti qué ninaaze cabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ma zeda yaba biaani bidxiña Jesús ruaa nisa que, peru qué ganna cabe pa laabe ni. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Na be rabi be laaca': ―Ma unaaze tu xiixa la? amigu ca'. ―Nin tobi, na ca'. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Para rabi be laaca': ―Lausaba starraya tu ladu derechu, zanaaze tu. Oraque bisaba ca', ne ma qué ñanda nibee ca ni, purti dxá tipa ni de benda. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Para na dxa discípulu ni nadxii be que, rabi Pedru: ―Señor nga. Cadi nacu Simón Pedru lari peru ora gunna Señor ngue la? ucuaa uxooñe xhaba, biaba nisa que. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ca xcaadxi discípulu que bichiña canuá que ruaa nisa, zeda xubi yu ca tarraya ra dxá benda que, purti cadi zitu nuu ca', bia' ti gayuaa metru si de ruaa nisa. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ora biree cabe ndaani canuá que, biiya cabe nuu ti ludé raqué nexhe ti benda lú, ne laca nuu pan. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Para na Jesús rabi laacabe: ―Latané caadxi benda ni unaaze tu nagasi ca. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Oraque udxi'ba Simón Pedru, ulee tarraya que lu yuxi, dxá tipa ni de benda ngola, bia'si ti gayuaa cincuenta y tres benda. Ne neca stale came, peru qué nireza tarraya que. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","―Latá' gue tu, na Jesús rabi laacabe. Ne nin tobi de laacabe qué ñuni cabe pur ninaba diidxa cabe tu laabe, purti nanna cabe Señor laabe. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Oraque bidxiña Jesús ucuaa pan que bidii laacabe, ne zaqueca bi'ni ne benda que. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ndi nga raguionna tiru bidxiña Jesús ra nuu ca discípulu sti' después de bibani. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Biluxe güe' si cabe, na Jesús rabi Pedru: ―Simón, xiiñi Jonás, nadxiiu naa jma que irá xixé la? ―Nadxiee lii, Señor, lii nannu nadxiee lii, na Pedru. ―Gupa ca dendxu huiini stinne', na be. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Bigueta rabi be Pedru: ―Simón, xiiñi Jonás, nadxiiu naa la? ―Nadxiee lii, Señor. Lii nannu nadxiee lii, na Pedru. ―Gupa ca dendxu stinne', na be. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Bigueta na be: ―Simón, xiiñi Jonás, nadxiiu naa la? Ucaná ladxidó' Pedru, purti ma ne nga guionna tiru inaba diidxa be laa pa nadxii laabe, para na: ―Señor, lii nannu irá'. Lii nannu nadxiee lii. Oraque na be: ―Gupa ca dendxu stinne'. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ne gabe ca' lii, dxi nahuiini lu la? stubu gucu lu xhaba lu', ne uyé lu ratiica gucala'dxu', peru ora ma bio'xho lu la? zusigaa nou', ne stobi tu ugacu lii lari ne ziné lii ra qué racala'dxu cheu'. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ra uní' be zacá, bisihuinni be xi enda guti chi usisaca né Pedru Dios. Biluxe si uní' be nga rabi be Pedru: ―Dananda naa. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ora bidxigueta lú Pedru biiya nanda dxa discípulu ni nadxii Jesús laa que, dxa ni gudixhe ique lu xi'que Jesús ra cayó xhi cabe ne unaba diidxa tu chi utoo laabe que. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Oraque biiya dxí Pedru laa ne na rabi Jesús: ―Señor, laga ndi ya'. Xi gaca xa de laa. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Para na Jesús: ―Pa acaladxe guiaana be de dxi guenda la? cadi xcuenta lu'. Dananda naa lii. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ne bireeche diidxa lade ca hermanu na Jesús qué zati discípulu que, peru cadi na di Jesús qué zati be, sínuque na pa acala'dxi guiaana be de ora gueeda la? cadi xcuenta Pedru. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ne discípulu que nga cayuí' irá ndi', ne cucaa irá ni, ne nanna du dxandí irá ni na be. ");
INSERT INTO zaiNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nuu ru stale ni bi'ni Jesús, pa nicá cada tobi ni la? rabe nin qué nugaanda guidxilayú nidxá irá gui'chi ra nicá ni.");
INSERT INTO zaiNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilu xhamigua', lu primé gui'chi bicaa lú lu que bizeete irá ni bi'ni Jesús ne ni bisiidi', dede dxi bizulú xhiiña', ");
INSERT INTO zaiNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","para dxi ze ibá'. Peru laga nuu ru be ndaani guidxilayú ulí be ca apóstol ne gudxi Espíritu Santu laabe xi gabi be laaca guni ca'. Oraque ru ze be ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Guti be peru dxi ma bibani be bidxiña be ra nuu ca apóstol. Biaana né be laaca cuarenta dia, ne biluí' be laaca dxandí nabani be, ne bisiidi be laaca de enda runi mandar sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ne laga nuu be lade ca', gudxi be laaca cadi iree ca de ndaani guidxi Jerusalén, na be: ―Lacueza gueeda ni bidii stiidxa Dios useenda', ni maca gudxe laatu que. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Purti uluu nisa Juan binni, peru ne nisa si, peru laatu zacaa tu Espíritu Santu casi ñaca ñuu nisa tu pur Espíritu que, ne ma zeda dxiña dxi aca ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tobi de ca dxi que ra nuu né ca Jesús tobi si, na ca rabi ca laabe: ―Señor, ñee yanna nga quixhu guni mandar ca binni Israel sti tiru la? ");
INSERT INTO zaiNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Para rabi be laaca': ―Bixhoze sia' nanna padxí ne pora gaca ni gudixhe gaca'. Laatu la? cadi nexhe di ganna tu ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Peru ora ma ucuaa tu Espíritu Santu la? zapa pe tu enda nandxó' sti Dios, ne óraque ma zanda iree tu, chi güi tu stiidxa ndaani guidxi Jerusalén ne idubi Judea ne Samaria ne idubi naca guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Biluxe si uní' be nga biasa be idubi cayuuya dxí ca laabe ne biseegu ti za laabe ne ma qué ñuuya ru ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Peru laaca biaana ca cayuuya dxí ca ibá' ra ze be que, mala zuhuaa chupa hombre nacu lari quichi cue' ca', ");
INSERT INTO zaiNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","na rabi laaca': ―Binni Galilea ca', xiñee ndi cayuuya dxí tu ibá'. Jesús ni bi'ya tu ze ibá' ca la? zacaca zabigueta be cásica bi'ya tu ze be ca. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Oraque ru biree cabe de lu dani Olivo, bigueta cabe Jerusalén. Cadi zitu ni, bia' ti kilómetru si. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ne ora biuu cabe ndaani guidxi que uyuu cabe ndaani ti yoo rairopa pisu. Raqué riaana cabe: Pedru, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateu, Jacobo xiiñi Alfeu, Simón ni uyuu lade ca cananista, ne Judas bi'chi Jacobo. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Irá cabe nuu cabe tobi si ne cadi cayaana dxí cabe de iní' né cabe Dios, laacabe ne caadxi gunaa ne María jñaa Jesús ne ca bi'chi Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lade ca dxi que nuu cabe irá cabe tobi si, bia' ti gayuaa gande cabe. Oraque biasa Pedru bizuhuaa lade cabe ne na: ");
INSERT INTO zaiNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Hermanu ca', chiqué uní' David ni gudxi Espíritu Santu laa de Judas, Judas ni uzá niru lú cani yenaaze Jesús que. Ne yanna ma uca irá ni uní' David que. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Guca Judas tobi de laanu ne bini né laanu dxiiña'. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Peru ra bitoo be Jesús ucuaa be vueltu, ne bixuí' né vueltu que ti layú. Ne raqué biaba rilú be, dede ureza ndaani be bireeche doo xqui' be ne guti be. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ora gunna ca binni Jerusalén ni la? ulee lá ca layú que Acéldama. Stiidxa ca la? riní' ni Layú de Rini. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Maca cá ni lu Salmo: Guiaana stubi lidxi be ne iruti cueza ndaani ni. Ne laca cá: Icaa stobi xhiiña be. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Nga runi cayabe laatu, hermanu ca', naquiiñe cui nu stobi chu' jlugar be para sa né laanu güi né binni dxandí biiya ma bibani Señor Jesús de lade gue'tu'. Gaca ni tobi ni uzá né laanu dxi nuu Jesús lade nu, de dxi guluu nisa Juan laabe para dxi biasa be lade nu ze be ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Para ulí cabe chupa: tobi lá José ni rabi cabe Barsabás ne Justu, ne stobi lá Matías. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ne óraque uní' né cabe Dios, na cabe: ―Señor, lii runibiá' lu ladxidó' irá binni. Biluí' laadu uná de iropa hombre ri ma ulí lu ");
INSERT INTO zaiNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","para gaca apóstol ne guni dxiiña bisaana Judas. Purti Judas ma ze jlugar. ");
INSERT INTO zaiNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Oraque biyubi cabe tu luguiá guiaba suerte que ne biaba ni luguiá Matías. Para biuu lade once apóstol que. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Runi ca judíu ti saa, rabi cabe ni Pentecostés. Ne dxi biaba laní que nuu ca xpinni Cristu que tobi si lugar. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mala uxidxi biete xiixa de xaibá' casi ora rundubi ti bi yooxho'. Bidxá ni ndaani yoo ra nuu cabe que. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ne biiya cabe casi ludxi bele. Bireeche ni luguiá cada tobi de laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ne bidxá ladxidó' cabe de Espíritu Santu. Bizulú uní' cabe adxé adxé idioma casi bisiní' Espíritu Santu laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Dxi uca ni la? nabeza caadxi binni Jerusalén, caadxi judíu ni beeda de adxé adxé guidxi, ne nabé rie ca yu'du'. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ora bina diaga ca ruidu que urí zisi ca ra rí ca xpinni Cristu que. Qué ganna ca xi cayaca purti cada tobi de laaca cayuna diaga diidxa gule né. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bidxagayaa ca ne unaba diidxa saa ca na ca': ―Ñee cadi binni Galilea irá binni ri la? ");
INSERT INTO zaiNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Peru cayuna diaga nu diidxa gule né pe nu. Xii ndi cayaca pue. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ne cadi tobi si xquidxi cani nuu rarí'. Nuu binni Partia, binni Media ne binni Elam ne binni Mesopotamia ne binni Judea ne binni Capadocia ne binni Ponto ne binni Asia ");
INSERT INTO zaiNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ne binni Frigia ne binni Panfilia ne binni Egipto ne binni Africa ni nabeza cherica de Cirene, ne laca nuu binni Roma. Caadxi de laaca judíu pe laaca casi laanu, ne xcaadxi la? cadi judíu peru ma rie yu'du stinu. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Laca nuu binni Creta ne binni Arabia. Peru irá nu cayene nu ni caní' cabe ri' de irá enda nandxó' ni bi'ni Dios, purti cayuna diaga nu ni diidxa gule né pe nu. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Cadxagayaa ca binni que, ne qué ganna ca xi cayaca. Canaba diidxa saa cabe, na cabe: ―Xii ndi cayaca pue. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Peru nuu tu bi'ni burla, ma na naxudxi ca xpinni Cristu que. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Oraque biasa Pedru bizuhuaa, laa ne sti once apóstol que, ne uní' ne gana, na: ―Hombre de Judea ca', ne cani nabeza Jerusalén, laucaa diaga ni chi tidxe laatu ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Cadi naxudxi di ca binni ri' casi na tu ca, purti deru las nueve ndi', ");
INSERT INTO zaiNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","sínuque cayaca ni bicaa profeta Joel chiqué ra na: ");
INSERT INTO zaiNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Na Dios: “Zadxiña dxi ucheeche Espíritu stinne luguiá stale binni. Zusinié ca xiñi gaana tu ne ca xiñi dxaapa tu, ne zuuya cani nahuiini xiixa casi ñaca lu bacaanda', ne zanié nia ca binni gola lu bacaanda'. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ca dxi que zucheeche Espíritu stinne luguiá cani runi xhiiña', hombre ne gunaa, ne zaní' ca ni gabe laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Zune stale enda nandxó' ibá', ne zahuinni seña guidxilayú de rini ne bele, ne ziasa gu'xhu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Zacahui lu gubidxa ne zaca beeu naxiñá rini dxi mayaca idxiña dxi udixhe Dios. Zaca stale cosa de enda ridxagayaa dxi que, ne zusihuinni Dios enda nandxó' sti'. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ne irá ni inaba gacané Dios laa la? zalá.” ");
INSERT INTO zaiNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Yanna laucaa diaga ni chi tidxe laatu ri', binni Israel ca'. Chi güe nia laatu stiidxa Jesús de Nazaret. Rihuinni Dios biseenda laabe purti laaca tu nanna tu ucané Dios laabe bi'ni be stale milagru ne cosa de enda ridxagayaa ne bisihuinni be seña nezalú tu. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Maca nanna Dios xi chi aca be, ne laatu bi'ni tu ni gudixhe Dios gaca que. Unaaze tu laabe, bidii tu laabe ucaa ca binni malu laabe lu cruz. Ne zacá laatu biiti tu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Peru bisibani Dios laabe, ulee laabe lu ná enda guti, purti qué ñanda ñaana né enda guti laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ndi nga ni uní' David chiqué, ne casi ñaca Jesús caní' ni: Nanna dxi'che qué rusaana Dios naa. Nuu be para gacané be naa ti cadi chuaa xizaa. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nga runi bidxá ladxiduá' de enda nayeche' ne biree diidxa sicarú de ruaa'. Neca gate peru nanna dxi'che zandisa be naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Purti qué zusaana be naa lade gue'tu', ne qué zudii be lugar guiu'dxu cuerpu sti Xiiñi be ni runi ni na be. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Biluí' be naa neza enda nabani, ne nabé rieche purti nuu né be naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Biche ca', irá nu nanna nu guti bixhoze gola nu David, ne bigaachi', ne nuu ru xpa' be rarí de yanna. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Peru guca be profeta, ne biluí' Dios laabe ni chi gaca ru' ne bidii stiidxa laabe de lade xfamilia be zaree tobi ni cui de rey casi urí be. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ne casi ñaca biiya be ra bibani Cristu ne uní' be qué ziaana di lade gue'tu' ne qué ziu'dxu cuerpu sti'. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Racá cuzeete be Jesús ni undisa Dios de lade gue'tu', ne laadu bidu'ya du guca ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Undisa Dios laabe ne bicuí laabe cue' ne bidii laabe Espíritu Santu casi gudxi laabe zuni. Ne yanna ma biseenda be Espíritu Santu que rarí'. Nga nga ni cayuuya tu ne cayuna diaga tu ca. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Purti qué nigui'ba David ibá', peru laa pe uní': Na Dios rabi Señor stinne': “Gurí cuee' ");
INSERT INTO zaiNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","dede ora ma gudixhe dxie cani nanala'dxi lii xa ñee lu'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Yanna laganna dxichi, binni Israel ca', Jesús ni bicaa tu lu cruz que nga ma bi'ni Dios xaíque sti irá', ne ma biluí' laanu laabe nga Cristu ni ulí que. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ora bina diaga cabe xi na Pedru, ucaná ladxidó' cabe ne rabi cabe Pedru ne xcaadxi apóstol que: ―Yanna xi guni du ya', bichi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Para na Pedru rabi laacabe: ―Lainaba perdón Dios ne lachuu nisa para ihuinni ma xpinni Cristu laatu. Zacá zaca perdonar ni huachee tu ne zudii Dios laatu Espíritu Santu. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Purti laatu nexhe icaa tu Espíritu Santu, laatu ne ca xiiñi tu ne irá ni nuu zitu, cani cuidxi Señor Dios stinu che ra nuu. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Byuí' né ru Pedru laacabe stale diidxa ne bilidxe laacabe, ne na rabi laacabe: ―Lauyubi ulá Dios laatu de lade ca binni nuu yanna ri', ti cadi initilú tu ra chi initilú cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ne cani ucuaa stiidxa be la? uyuu nisa, ne bia' chonna mil binni bini cre Cristu dxi que. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ne irá cabe yenanda cabe ni bisiidi ca apóstol, ne uyuu cabe tobi si, tobi si uní' né cabe Dios, ne tobi si gudó cabe pan casi bisaana Señor guni cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Irá binni guidxi que bidxagayaa ra biiya irá milagru ne seña ni bi'ni ca apóstol pur enda nandxó' sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tobi si uyuu irá cani bini cre Cristu ne tobi si gupa ca stica'. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bitoo cabe layú stícabe ne irá ni napa cabe ne biaazi ni lú irá cabe. Cada tobi gucuaa bia' caquiiñe'. ");
INSERT INTO zaiNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Irá dxi rie cabe ra yu'du ro' ne de raqué riree cabe ritó cabe gueta, caadxi caadxi ralidxi cada tobi. Tobi si nuu cabe ne nabé rieche cabe. Iruti nudxiiba laca laa, ");
INSERT INTO zaiNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","sínuque irá cabe bisisaca cabe Dios. Ne irá binni guidxi que uyuula'dxi modo cayuni cabe. Ze dxi jma rusi zidale cabe purti culá Señor stale binni ne irá ca cayuu ca lade cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ti dxi bia' las tres biree Pedru ne Juan, ze ca ra yu'du ro' purti ngue nga ora nexhe chi iní' né ca judíu Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ra puerta yu'du que ribí tobi hombre rinaba guna. Irá dxi risaana binni laabe raqué purti nachiita ñee be dede dxi gule be, ne rucuí ca laabe ra puerta lá Sicarú que. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ora bi'ya be ziyuu Pedru ne Juan ndaani yu'du', bisigaa ná be lú ca', canaba be laaca guna. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Biiya dxí ca laabe para na Pedru rabi laabe: ―Biiya dxí laadu. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Oraque biiya dxí be laaca'. Cabeza be udii ca laabe xiixa. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Para na Pedru rabi laabe: ―Qué gapa vueltu udiee lii, nin plata nin oro, peru ni zanda gune la? zune para lii. Pur enda nandxó' sti Jesucristu de Nazaret, cayabe lii guiasa lu', sa lu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ne unaaze Pedru ná be ladu derechu undisa laabe. Oraqueca uyuu stipa ñee be. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Biasa uxooñe be ne uzá be. Biuu né be laaca ndaani yu'du', canazá be, canachesa be, cusisaca be Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Irá binni nuu raqué biiya canazá be cusisaca be Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ne nabé bidxagayaa ca' ne bidxibi ca pur ni guca be que. Purti binibiá' ca laabe ne nanna ca laabe nga ni ribí ra yu'du ro', rinaba guna ra puerta lá Sicarú que. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Qué niladi be de Pedru ne Juan, ne bidxagayaa irá binni que, ne gurí zisi ca laacabe ra nuu cabe ndaani corredor ni rabi cabe Corredor sti Salomón que. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ora bi'ya Pedru rí irá binni que laaca', na: ―Binni Israel ca', xiñee cadxagayaa tu ne cayuuya dxí tu laadu, casi ñaca laadu bisianda du hombre ri' pur enda nandxó' stidu o purti jma gaxha canazá du de Dios. Cadi zacá di nga laani, ");
INSERT INTO zaiNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","sínuque uca ni pur enda nandxó' sti Jesús, dxa ni bitiidi tu lu ná Pilatu chiqué. Peru yanna ma bisisaca Dios laabe, Dios sti ca bixhoze gola nu Abraham ne Isaac ne Jacob. Dxi unaaze tu laabe que, qué niná tu nundaa Pilatu laabe, neca ucala'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Qué niná tu nilaa tobi ni nacha'hui', ni qué huayuni gasti', laga unaba tu ilaa tobi ni huayuuti binni. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ne zacá biiti tu ni rudii enda nabani, peru undisa Dios laabe de lade gue'tu'. Nanna du dxandí ni purti bidu'ya du laabe nabani be. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ne pur enda nandxó' stibe uyuu stipa ñee hombre ri', ne bianda chaahui purti runi cre du laabe. Runibiá' tu laa ne nezalú irá tu bianda. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Biche ca', nanna bi'ni tu irá nga purti qué ganna tu xi cayuni tu, laatu ne ca xaíque stitu. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Peru maca uní' Dios chi aca ni zacá, ne gudxi ni binni de ruaa irá ca profeta ni bizeete napa Cristu xidé acaná. Ne yanna ma bi'ni be ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nga runi cayabe laatu, lainaba perdón Dios, laudxii lú jneza ti ixá stonda tu ne zacá zusieche be ladxidó' to, ");
INSERT INTO zaiNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ra useenda be Jesús ra nuu tu sti tiru, ne nga nga Cristu ni ulí be gueda ulá laatu. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Peru napa Cristu xidé guiaana ibá' dede ora ma gudixhe chaahui Dios irá ni naquiiñe gaca' casi uní' de ruaa ca profeta sti dede ma xadxí. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Purti na Moisés rabi ca bixhoze gola nu chiqué: “De lade binni laanu zandisa Dios ti profeta, ne laucaa diaga laabe irá ni gabi be laatu. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Purti irá ni qué ucaa diaga laabe la? zaxá lá de lade binni Israel ne zanitilú.” ");
INSERT INTO zaiNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Irá ca profeta uyuu chiqué, de Samuel ne cani beda nanda ru', irá ca bizeete ca de ca dxi ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ne de ruaa ca profeta que, bidii stiidxa Dios ca bixhoze gola nu, ne cadi laasi ca' sínuque ne laatu purti laatu nga xiiñi ca'. Ne laca uní' né be laatu ra na be rabi be Abraham: “Pur Xiiñi lu ziuu irá binni guidxilayú ndaaya'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ne dxi ma undisa be Xiiñi be que, nirudó' ra nuu tu biseenda be laa para uxhele laatu de enda ruchee ne nga nga ndaaya que. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Cayuí' né ru Pedru ne Juan ca binni que diidxa ora biuu ca sacerdote ne xaíque sti cani rapa ra yu'du ro', ne ca saduceu. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Cadxiichi ca xiñee cusiidi cabe binni zabani gue'tu purti bibani Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ne unaaze ca laacabe biseguyoo ca laacabe. Ne biaana cabe raqué gueela que, purti ma huadxí ngue. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Peru stale de cani bicaa diaga laacabe bini cre, bia' gaayu mil hombre sin igaba gunaa. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sti dxi que guca ti junta Jerusalén. Bidxiña ca xaíque sti guidxi que ne ca xaíque sti ca sacerdote ne ca maistru de ley, ");
INSERT INTO zaiNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ne Anás sacerdote gola ne Caifás ne Juan ne Alejandru ne irá ca familia sti sacerdote gola. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Para bisenda caa cabe Pedru ne Juan, bizuhuaa cabe laaca galahui' ne rabi cabe laaca': ―Tu gudxi laatu guni tu ni cayuni tu ri' o tu biseenda laatu guni tu ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Dxá ladxidó' Pedru de Espíritu Santu para na rabi laacabe: ―Laucaa diaga, xaíque sti guidxi ne xaíque sti ca sacerdote. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Yáquexa yanadxí canaba diidxa tu laadu ximodo ucané du hombre nachita ñee ri', o ximodo bianda be la? ");
INSERT INTO zaiNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","zabi du ni laatu para ganna tu, laatu ne idubi naca guidxi Israel. Jesucristu ni bicaa tu lu cruz que, undisa Dios laa de lade gue'tu', ne laabe nga bisianda be hombre zuhuaa lú tu ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ni bi'ni tu Jesús ca zeda gaca casi ñaca nusa'bi tu ti guie ra cucuí tu yoo, ne nidxiña dxi ma guie que pe ninaaze yoo que. Purti yanna ma bidxiiba Dios laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ne laasi be zanda ulá be laanu, purti iruti ru stobi ndaani guidxilayú ni huaguixhe Dios ulá binni, sínuque laasi be. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ora bi'ya cabe cadi cadxibi Pedru ne Juan para iní', ne nanna nda cabe huaxié' napa ca scuela ne iruti naca ca la? nabé bidxagayaa cabe. Ne bietenala'dxi cabe uzá né ca Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Peru qué ñanda niní' cabe gasti' purti zuhuaa dxa hombre ni bianda que raqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Oraque gudxi cabe laaca iree ca de raqué, para uní' stiidxa cabe laasi cabe, ");
INSERT INTO zaiNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","na cabe: ―Xi guni né nu ca hombre ri pue, purti dxandí milagru ni bi'ni cabe ca, ne irá binni Jerusalén nanna ni. Qué zanda gabi nu cadi dxandí ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Peru para ma cadi ireeche ru ni lade binni la? uchibi nu laacabe ti ma cadi lica uzeete ru cabe lá Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Para uridxi cabe laaca sti tiru ne biinda cabe lú ca ma cadi usiidi ca stiidxa Jesús nin uzeete ca lá. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Para na Pedru ne Juan rabi laacabe: ―Laguuya si laatu pa jneza nezalú Dios uzu'ba du stiidxa tu ne cadi uzu'ba du stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Purti qué zanda usaana du de güi du ni bidu'ya du ne ni bina diaga du. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bichibi si cabe laaca', bindaa cabe laaca purti qué ñanda ñuniná cabe laaca pur irá binni que. Irá cabe cusisaca cabe Dios pur ni guca que, ");
INSERT INTO zaiNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","purti ma napa hombre ni bianda que jma de cuarenta añu. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Biree si Pedru ne Juan biyubi ca ra nuu ca xcaadxi de laaca que ne byuí' né cabe laaca xi na ca xaíque sti ca sacerdote ne ca xaíque sti guidxi. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ora bina diaga ca xi na cabe la? irá cabe tobi si uní' né cabe Dios na cabe: ―Dios, lii runi mandar lu irá'. Lii bizá' lu ibá' ne guidxilayú ne nisadó' ne irá ni nuu ndaani cani. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ne laca lii uní' lu ra bisiní' Espíritu Santu David ni bi'ni xhiiña lu', ra na: Xiñee cayasa cani cadi judíu, caguixhe ca guni ca ni qué zanda guni ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Uyuu ca rey de guidxilayú tobi si, laaca ne ca xaíque sti ca guidxi, para bicaa lú ca Dios ne Cristu ni ulí be. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ne dxandí zacá pe nga uca ni ndaani guidxi ri'. Herodes ne Poncio Pilatu ne cani cadi judíu ne ca judíu, irá ca uca ca tobi si uyé ca luguiá Jesús Xiiñi lu ni nayá ladxidó', ni ulí lu que. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ne zacá bi'ni cabe irá ni maca gudixhe lu gaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yanna, Señor, biiya modo racala'dxi cabe uchibi cabe laadu para guiaana dxí du, ne ucané laadu, cani cayuni xhiiña lu', para güi du stiidxa lu sin idxibi du. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ne laga cayuni du ni, lii gudixhe ná luguiá cani huará para guianda ca', ne ucané laadu guni du milagru ne seña pur enda nandxó' sti Jesús Xiiñi lu ni nayá ladxidó'. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ora biluxe uní' né cabe Dios, biniibi dxacha ra nuu cabe que ne bidxá ladxidó' cabe de Espíritu Santu ne jma rusi ma qué nidxibi cabe byuí' cabe stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Stale binni ma runi cre Dios, ne irá ca nuu ca tobi si. Tobi si ni caní' ique cabe, tobi si ni racala'dxi cabe. Ne iruti cadi caní' sti si ni napa, sínuque sti irá cabe ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Cadi cayaana dxí ca apóstol de güi né ca binni dxandí biiya ca ma bibani Señor Jesús, ne nabé cahuinni enda nandxó' sti Dios luguiá ca', ne caguu Dios ndaaya irá ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nga runi nin tobi de laacabe qué ñaadxa gasti purti irá cani napa layú ne yoo bitoo cani ne bedané ca saca ni, ");
INSERT INTO zaiNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","gudixhe ca xa ñee ca apóstol para biaazi ni lu cada tobi bia' caquiiñe'. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Lade cabe uyuu tobi lá José. Ulee lá ca apóstol laabe Bernabé. Stiidxa cabe riní' ni Tobi ni Rusieche'. Binni Chipre laabe, ne za be de Leví. ");
INSERT INTO zaiNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Gupa be tindaa layú. Bitoo be ni ne bedané be saca ni, gudixhe be xa ñee ca apóstol. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Peru uyuu stobi hombre lá Ananías. Laa ne Safira xheela bitoo ca ti layú. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ulee be tindaa lú ni ne yené be ni ra nuu ca apóstol, gudixhe be ni xa ñee ca'. Ne nanna xheela be xi bi'ni be. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Para na Pedru rabi laabe: ―Ananías, xiñee bidiiu lugar chu' binidxaba ndaani ladxidó' lo para usiguiiu Espíritu Santu ne guiaana neu tindaa lu ni bitoo lo ca. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Dxi napu ni, ñee cadi stiu' ni la? Ne dxi ma bitoo lo ni que, laca stiu' saca ni para ñuni neu ni racala'dxu'. Xiñee canatidi lu xquenda biaani lu gu'nu zacá. Cadi binni di nga ucala'dxu nusiguiiu', sínuque Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ora bina diaga Ananías ni na Pedru que, biaba guti. Nabé bidxibi irá cani gunna ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ne bidxiña caadxi hombre huiini', ucuaa ca laabe, bichenda ca laabe lari, para yeucaachi ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bia' chonna hora de ngue za xheela be, biuu. Peru qué ganna xi ma guca. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Para na Pedru rabi laa: ―Ñee bia' ri bitoo to layú stitu la? ―Bia' cá, na. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Oraque na Pedru: ―Xiñee uca tu tobi si para gu'ya tu pa zanda usiguii tu Espíritu sti Dios. Biaa gu'yu' ma zeda yuu cani yeucaachi xheelu'. Ne laca ziné ca lii. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Oraqueca biaba be xa ñee Pedru, guti be. Ora biuu ca hombre huiini que, biiya ca ma guti be, para ucuaa ca laabe yeucaachi ca laabe cue' xheela be. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nabé bidxibi ca xpinni Cristu ne irá cani bina diaga ni uca que. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Biquiiñe Dios ca apóstol para bi'ni stale milagru, ne bisihuinni enda nandxó' sti lade ca binni que. Irá cabe ridxiña cabe ra corredor ni rabi cabe sti Salomón que. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ca xcaadxi binni la? bidxibi ca ñuu ca lade cabe, peru irá binni guidxi que cudxiiba laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ne jma rusi cadale cani runi cre Cristu, cásica hombre zaqueca gunaa. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Biiya binni irá ni cayuni ca apóstol, para bizulú ca ulee ca binni huará. Nuu ni nexhe lu luuna', lu camilla. Ne udixhe ca laacabe lu calle ti ora tidi Pedru raqué, neca bandá si sti tidi luguiá cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Dede ca binni guidxi nuu gaxha Jerusalén bedané ca binni huará ne ni caguite binidxaba ique, ne irá cabe bianda cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Peru biasa sacerdote gola, laa ne ca saduceu ni nuu né laa, bidxiichi ca purti ma zinanda binni ca apóstol. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Para unaaze ca ca apóstol biseguyoo ca laacabe ndaani lidxi guiiba sti guidxi que. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Peru lu gueela beeda ti ángel sti Dios bixhele puerta sti lidxi guiiba que, ulee laacabe ne na rabi laacabe: ");
INSERT INTO zaiNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Laché lachiuzuhuaa ndaani yu'du ro'. Lagüí' né binni stiidxa enda nabani ni cudii Dios yanna ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nga si bina diaga cabe biree cabe. Ne siadó' ro' biuu cabe ndaani yu'du ro', bisiidi cabe. Laga cayaca irá nga la? gupa sacerdote gola ne cani nuu né laa ti junta, ne guridxi ca ca justicia ne irá ca binni gola sti ca judíu. Oraque biseenda cabe tu chi ndee ca apóstol ndaani lidxi guiiba', guedané laaca ra nuu cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Peru ora yendá ca gendarme que ra lidxi guiiba', qué nidxela ca ca apóstol, para bigueta ca yetidxi ca laacabe, ");
INSERT INTO zaiNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","na ca': ―Yegu chaahui lidxi guiiba que yendá du, ne zuhuaa cani cayapa ni, peru ora bixhele du ni la? iruti nuu ndaani ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ora bina diaga sacerdote gola ne xaíque sti cani rapa ra yu'du ro' ne ca xaíque sti ca sacerdote xi na ca gendarme que la? na ca': ―Nanna xi gueda iluxe irá ndi ya'. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Peru óraque beeda tobi, beda tidxi laaca xi cayaca, na: ―Ndaani yu'du ro' nuu ca hombre biseguyoo to que, cusiidi ca binni. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Para biree comandante ne ca gendarme, yecaa ca ca apóstol peru sin ñuniná ca laacabe, purti cadxibi ca uchá ca binni que guie laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bedané ca laacabe ne bizuhuaa ca laacabe nezalú ca justicia. Oraque na sacerdote gola rabi laacabe: ");
INSERT INTO zaiNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Ñee cadi bidu'nda ca du lú tu cadi usiidi ru tu stiidxa Jesús la? Yanna biaa xi ma bi'ni tu. Ma bichá tu stiidxa be idubi naca Jerusalén ne cudxiiba ru sica tu donda luguiá du, ma na tu laadu biiti du laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Oraque na Pedru ne ca xcaadxi apóstol que: ―Jma naquiiñe uzu'ba du stiidxa Dios que stiidxa binni. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Dios sti ca bixhoze gola nu undisa Jesús ni biiti tu ra bicaa tu laa lu cruz que. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ma undisa Dios laabe ne bicuí laabe cue' para aca be xaíque sti irá' ne ulá be binni, ti pur laabe ma zanda gaca perdonar ca binni Israel ra inaba ca perdón Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ne cayabi du laatu dxandí irá ndi', ne cadi laasi du sínuque ne Espíritu Santu ni rudii Dios cani ruzuuba stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nabé bidxiichi ca binni que ora bina diaga ca xi na ca apóstol, ne ucala'dxi ca ñuuti ca laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Peru óraque biasa tobi de ca justicia lá Gamaliel. Naca fariseu ne rusiidi ley, ne irá binni rucaa diaga laa. Bizuhuaa ne unaba iree ca apóstol ti ratu. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ne óraque na: ―Binni Israel ca', laguuya xii nga chi guni tu ca hombre ca. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Purti chiqué biasa ti hombre lá Teudas, na laa nga tuuxa. Ne yenanda stale binni laa, bia' tapa gayuaa hombre. Peru qué nindaa de ngue biiti cabe laa ne birá xpinni bireeche, ne raqué biluxe ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bigueta dxi cayaca censu biasa stobi lá Judas, binni Galilea. Bitopa stale binni para sa nanda laa. Peru laca guti, ne birá xpinni bireeche. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nga runi cayabe laatu cadi guni tu ca hombre ca gasti'. Laudii lugar che cabe. Purti pa binni gudixhe ni zinanda cabe ca la? qué zandaa ibiá ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Peru pa de Dios zeeda ni la? qué zanda di uchiá tu ni. Ne pa uyubi tu guni tu ni la? zacá zucaa lú tu Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ne irá cabe ucuaa cabe stiidxa Gamaliel, para guridxi cabe ca apóstol, gudiñe cabe laaca' ne gudxi cabe laaca ma cadi güi ru ca stiidxa Jesús. Oraque ru bindaa cabe laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ne biree ca apóstol de ra nuu ca justicia que, ziyeche ca purti bidii Dios lugar usituí binni lú ca purti xpinni Jesús laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ne qué ñaana dxí cabe de ñui' cabe stiidxa Cristu. Irá dxi bisiidi cabe ni ndaani yu'du ro' ne ralidxi binni. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nabé cadale ca xpinni Cristu ca dxi que. Ne uluu cani riní' griegu xqueja cani riní' hebreu, na ca jma huaxié' ricaa ca viuda ni nuu lade ca' ora riaazi ni tidi né ca dxi. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Para guridxi ca apóstol irá ca xpinni Cristu ne na ca rabi ca laacabe: ―Cadi jneza usaana du de güi du stiidxa Dios para idu'ya du guiaazi ni caquiiñe irá ca binni ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nga runi hermanu ca' lacuí gadxe hombre de lade tu ni nanna binni runi jneza, ni dxá ladxidó' de Espíritu Santu, ne ni riene, usaana nu dxiiña ri lu ná ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ne laadu qué ziaana dxí du de iní né du Dios ne de güi du stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Uyuula'dxi ca binni que modo na ca apóstol gaca ni. Para ulí ca Esteban, tobi hombre ni nabé runi cre ne dxá ladxidó' de Espíritu Santu, ne laca ulí cabe Felipe ne Prócoro ne Nicanor ne Timón ne Parmenas ne Nicolás, ti binni Antioquía ni maca zinanda religión sti ca judíu ante gaca xpinni Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bedané cabe laaca ra nuu ca apóstol, para uní' né ca apóstol Dios ne gudixhe ná ca luguiá cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ne ca dxi que jma rusi careeche stiidxa Cristu, ne cadale cani runi cre ndaani guidxi Jerusalén, dede stale sacerdote sti ca judíu bini cre. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nabé uluu Dios ndaaya Esteban ne ucané laabe para bi'ni be stale milagru, ne biquiiñe Dios laabe para bisihuinni enda nandxó' sti lade ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Oraque biasa caadxi binni ni rie xhiu'du cani uca esclavu chiqué. Lade cabe zeeda caadxi binni de Cirene ne de Alejandría ne de Cilicia ne Asia. Ucuaa yu né cabe Esteban de ni cusiidi'. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Peru biseegu Esteban ruaa cabe purti ucané Espíritu Santu laa uní' ne stale enda biaani'. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Para gudixe cabe caadxi binni iní' bina diaga caguu dí Esteban Moisés ne Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ne zacá biquiinde cabe ca binni guidxi que ne ca xaíque stica' ne ca maistru de ley, para biasa irá ca uyé ca luguiá Esteban, unaaze ca laabe ne yené ca laabe ra nuu ca justicia. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ne bedané cabe caadxi cuee falsu luguiá Esteban, na ca qué riaana dxí be de cu' dí be yu'du sti Dios ne ley stica'. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ne laca na ca': ―Bina diaga du caní' hombre ri' zuxhá Jesús de Nazaret yu'du ro' ri', ne zuchaa ca costumbre ni gudixhe Moisés guni nu. ");
INSERT INTO zaiNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ne biiya dxí irá binni zuba raqué lú Esteban ne biiya ca casi lú ángel lú be. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Oraque na sacerdote gola que rabi laabe: ―Ñee dxandí irá ni na cabe ca la? ");
INSERT INTO zaiNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Para na be: ―Biche ne bixhoze ca', laucaa diaga naa. Dios ni nandxó' uní' né bixhoze gola nu Abraham dxi nuu ru Mesopotamia ante chi ndeza Harán. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Na Dios rabi laabe: “Biree de xquidxi lu', bisaana ca lisaa lu'. Uyé, naa ma ulué lii uná guidxi guiaanu'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Para biree be xquidxi ca caldeu, yendeza be Harán. Raqué guti bixhoze be, para bedané Dios laabe guidxi ra nabeza tu yanna ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Chiqué qué nudii Dios laabe nin tindaa layú rarí', nin bia' ra nuzuhuaa ñee be. Peru bidii stiidxa laabe zudii ni laabe ne ca xiiñi be, neca ca'ru gapa be xiiñi be chiqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ne laca gudxi Dios laabe zazá renda ca xiiñi be xquidxi binni tapa gayuaa iza ne zapa ca binni que laaca de esclavu ne zuniná laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Peru na Dios rabi laabe: “Zusaba naya cani gapa laacabe de esclavu ne óraque zaree cabe para gueda usisaca cabe naa rarí'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Bidii stiidxa Dios laabe zaca be xpinni, laabe ne ca xiiñi be, ne na rabi laabe: “Guluu seña stinne irá hombre gale lade familia stiu' para ihuinni ma xpinne laatu.” nga runi dxi gule Isaac uluu be seña sti Dios laa lu xhono gubidxa. Zaqueca bini né Isaac Jacob xiiñi', ne zaqueca bini né Jacob idubi doce xiiñi', cani beda gaca bixhoze gola irá nu. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Gupa ca xcaadxi xiiñi Jacob que envidia José bi'chi ca', ne bitoo ca laabe lu binni ze Egipto, peru nuu né Dios laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Bilá laabe de irá ni beeda luguiá be. Ucané laabe para biaba be Faraón, rey de Egipto, ne para biiya Faraón pabiá' riene be. Ne bi'ni laabe gobernador de Egipto ne bisaana irá ni napa ralidxi lu ná be. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ca dxi que guca ti gubiña idubi guidxi Egipto ne Canaán. Nabé nagana guca ni para ca binni que, ne qué nidxela ca bixhoze gola nu ni ño ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Peru ora gunna Jacob nuu xuba Egipto la? biseenda laacabe yesí cabe xuba'. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ne ra iropa tiru uyé cabe gudxi José laacabe tu laa, ne gunna Faraón tu familia José. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Para bisenda caa José bixhoze ne idubi familia sti', bia' setenta y cinco ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Zacá nga yebí' Jacob Egipto ne raqué guti'. Ne raqueca guti ca bixhoze gola nu. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Udi'di ru stale iza para ulee cabe laaca yeucaachi cabe laaca Siquem ndaani ba' ni uzí' Abraham lu ca xiiñi Hamor. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Peru dxi ma cadxiña dxi gaca ni bidii stiidxa Dios Abraham gaca que la? bidale ca binni Israel ndaani guidxi Egipto, ");
INSERT INTO zaiNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","dede ra beda tí sti rey ni qué runibiá' José. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Udxite rey que ca binni laanu ne bininá laacabe ne bicaa laacabe usa'bi cabe ca xiiñi huiini cabe para gati ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ca dxi que beda gale Moisés ne uyuula'dxi Dios laa. Gupa bixhoze be ne jñaa be laabe ralidxi ca chonna beeu. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Peru dxi ma qué ñanda nucaachi ca laabe la? ulee ca laabe, ne ucuaa xiiñi Faraón laabe, bisiniisi laabe casi xiiñi'. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ne biziidi be irá ni nanna ca binni Egipto. Nabé bihuinni pabiá' nuu xpiaani be pur ni uní' be ne pur ni bi'ni be. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Dxi ma napa be cuarenta añu bilui'la'dxi be chi ganna be ca binni xquidxi be, ca israelita. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ne ra ziganna be laaca biiya be caguiñe ti egipciu tobi de laaca'. Biuu be ucané be binni xquidxi be gudiñe be egipciu que dede ra biiti be laa. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Zácaxa be ñene ca binni xquidxi be ma chi iquiiñe Dios laabe para ulá laaca', peru qué ñene di ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Sti dxi que yendá be ra cadinde chupa de ca binni xquidxi be. Ucala'dxi be nuchiá be laaca', rabi be laaca': “Hombre ca', xiñee ndi cayuniná saa tu laatu. Laca bi'chi tu.” ");
INSERT INTO zaiNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Oraque bilaa ná ni caguiñe stobi que laabe ne na: “Tu gudixhe lii gacu xaíque stidu para ga'bu laadu cadi jneza cayuni du. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","O racala'dxu guuti lu naa casi biiti lu dxa egipciu que neegue la?” ");
INSERT INTO zaiNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ora bina diaga be xi na hombre que, biree be de Egipto, yendeza be xquidxi binni. Uleza be Madián ne raqué gupa be chupa xiiñi be. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Udi'di cuarenta añu de ngue, ti dxi nuu be ndaani ti gui'xhi cue' dani Sinaí, mala biiya be cayaca bele lu ti yaga. Tihua ti ángel biete raqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Bidxagayaa be ora bi'ya be ni, ne bidxiña be para gu'ya be xii ni. Oraque uní' né Dios laabe, ");
INSERT INTO zaiNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","na rabi laabe: “Naa nga Dios sti ca bixhoze gola lu', Dios sti Abraham ne sti Isaac ne sti Jacob.” Bidxibi be dede guca diti be ne qué niná be nindisa lú be. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ne na Dios rabi laabe: “Ulee xquela guidi lu' purti zuhuaa lu nezaluá'. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ma biiya pabiá' cayacaná ca xpinne ni nuu Egipto ne bina diaga cayuuna cabe. Nga runi ma biete para ula'ya laacabe. Yanna gudá' useenda lii cheu' Egipto.” ");
INSERT INTO zaiNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Chiqué bidxii deche cabe Moisés rabi cabe laa: “Tu gudixhe lii gacu xaíque stidu para ga'bu laadu cadi jneza cayuni du.” Peru laape be gudixhe Dios de xaíque stica' para bilá be laaca', ne gucané ángel que bi'ni be ni, dxa ángel ni uní' né laabe lu yaga que. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Bi'ni be milagru ne seña ndaani guidxi Egipto ne lu Nisadó' Xiñá' para ulee be laaca de ndaani guidxi que. Ne laca laabe bi'ni be milagru ra uzá né be laaca cuarenta añu ndaani gui'xhi'. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ne laca laabe nga gudxi be ca binni Israel chiqué zandisa Dios ti profeta de lade ca casi undisa laabe, ne gudxi be laaca ucaa diaga ca profeta que. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ne dxi bidxiña irá ca binni que ndaani gui'xhi', ne laabe nuu be raqué. Ne laabe nga uní' né dxa ángel que lu dani Sinaí para uní' né be ca bixhoze gola nu. Ne laabe ucuaa be ca diidxa sti enda nabani ne bisaana be cani para laanu. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Peru nin ne irá nga, qué niná ca bixhoze gola nu nucaa diaga laabe, laga bidxii deche ca laabe, ne nisi cá ique ca ibigueta ca Egipto. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ne ti tiru bisaana Moisés laacabe caadxi, para rabi cabe Aarón: “Bizá' caadxi bidó' sa niru lú nu, purti ulee si Moisés laanu Egipto. Yanna qué ganna nu xi guca be.” ");
INSERT INTO zaiNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Oraque bi'ni cabe ti yuze huiini ne biiti cabe mani bisiga'de cabe laa. Bieche né cabe ni bizá' cabe que. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Peru bixele Dios de laacabe. Bisaana laacabe guni adorar cabe ca luceru ni nuu ibá', casi bicaa ca profeta lu gui'chi ra na Dios: Binni Israel ca', lácaxa biiti tu mani para nusiga'de tu naa idubi cuarenta añu uzá tu ndaani gui'xhi que. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Laga yené tu ca bidó' ni bizá' tu para uzuxibi tu xa ñee. Yené tu lidxi Moloc ne luceru sti Refán de dios stitu. Nga runi zabee laatu de xquidxi tu, chi ulaa laatu cherica Babilonia. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Uzá né ca bixhoze gola nu carpa ra gupa ca ca guie ra cá ca mandamientu. Bizá' cabe carpa que casi gudxi Dios Moisés cha ni. Biluí' Dios laabe ximodo. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Laca yené cabe ni dxi uzá niru Josué lú cabe para biuu cabe guidxi bidii Dios laacabe que. Peru para biuu cabe raqué uladxi Dios ca binni nabeza raqué. Ne zacá bi'ni cabe dede dxi beda tí rey David. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Gunaxhii Dios laabe ne ucala'dxi be nucuí be xhiu'du Dios sti Jacob, ");
INSERT INTO zaiNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","peru qué ñanda. Salomón ru' beda ucuí ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Peru qué ribeza Dios ni nandxó' ndaani yu'du ni ucuí binni, casi uní' ti profeta ni na Dios: ");
INSERT INTO zaiNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Rune mandar ibá' ne guidxilayú, casi ñaca zuba ibá' ne naguixhe ñee guidxilayú. Xi clase ndi yoo na tu ucuí tu para naa pue. O paraa nga na tu quixhe chaahui tu para iziiladxe'. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ñee cadi naa bine irá xixé ni la? ");
INSERT INTO zaiNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Peru laatu la? na Esteban rabi laacabe, ―naguidxi ladxidó' to, casi binni ni qué runibiá' Dios, ne qué riná tu ucaa diaga tu stiidxa Dios. Rindee tu ca bixhoze gola tu purti nisi rucaa lú tu Espíritu Santu casi bi'ni ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Uná de ca profeta ni qué nizabi nanda ca bixhoze gola tu ya'. Biiti cabe cani gudxi laacabe zuseenda Dios tobi ni nacha'hui'. Nga guca dxi ca'ru gueeda be. Yanna ma beeda be ne laatu bitoo to laabe ne biiti tu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Bidii ca ángel ley sti Dios laatu peru qué runi tu ni na ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ora bina diaga cabe ni na Esteban que, gudó dí laacabe dede gudó yaa cabe guidi ruaa cabe, tantu bidxiichi né cabe Esteban. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Peru dxá ladxidó' Esteban de Espíritu Santu biiya dxí ibá'. Biiya enda nandxó' sti Dios ne biiya zuhuaa Jesús cue' Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Para na: ―Cayuuya zuxele ibá' ne zuhuaa Hombre Biseenda Dios cue' Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Oraque irá cabe biseegu cabe diaga cabe ne bicaa cabe ridxi ne uyé cabe luguiá Esteban irá cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ulee cabe laa de ndaani guidxi que, ne bisigapa cabe xhaba cabe ti hombre lá Saulo, para bichá cabe guie Esteban. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Laga cuchá cabe guie laabe, na be: ―Señor Jesús ucuaa espíritu stinne'. ");
INSERT INTO zaiNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ne bizuxibi be, bicaa be ridxi: ―Señor cadi udxiiba lu donda ri luguiá cabe. Nga si uní' be, guti be. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Uyuula'dxi Saulo ni bi'ni cani biiti laabe que. Peru undisa caadxi hombre cha'hui laabe, bicaachi ca laabe, ne biina né ca laabe. Ne dede dxi que bizulú uzabi nanda cabe ca xpinni Cristu ndaani guidxi Jerusalén ne bireeche ndase ca', ni uyé Judea ni uyé Samaria. Ca apóstol si, qué niree. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ucala'dxi Saulo nunduuxe irá ca xpinni Cristu. Uzá yoo pur yoo ulee laacabe, hombre ne gunaa, ne biseguyoo laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Peru cani bireeche que, irá ladu ze ca', ziyuí' ca stiidxa Cristu, ");
INSERT INTO zaiNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","casi Felipe uyé ti guidxi de Samaria ne byuí' né ca binni que stiidxa Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bidxiña irá binni que bicaa diaga laabe ne biiya ca ca milagru ni bi'ni be. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Purti nuu stale binni raqué riguite binidxaba ique ne bicaa ca binidxaba que ridxi ra biree ca'. Ne bianda stale cani ma guti galaa, ne ñee chiita. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ne nabé bieche ca binni guidxi que. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Uyuu tobi hombre lá Simón ndaani guidxi que. Chiqué uca be magu, ne bidxagayaa ca binni neza que irá ni bi'ni be, ne gudxi be laaca nandxó' be. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ne irá ca bicaa diaga ca laabe, dede cani huaxié' risaca para cani jma risaca, na ca': ―Ndi nga enda nandxó' sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bicaa diaga ca laabe purti ma xadxí caguite be laaca ne irá brujería ni runi be. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Peru dxi ma bini cre ca ni byuí' né Felipe laaca de enda runi mandar sti Dios ne de Jesucristu la? uyuu nisa ca', hombre ne gunaa. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Laca bini cre Simón ne uyuu nisa. Ne ma qué niladi ru cue' Felipe. Ne nabé bidxagayaa ra bi'ya irá seña ne milagru cayaca que. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ora gunna ca apóstol ni nuu Jerusalén ma bini cre binni Samaria stiidxa Dios la? biseenda ca Pedru ne Juan ra nuu cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Casi yendá Pedru ne Juan raqué unaba ca lu Dios udii Espíritu Santu laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Purti nin tobi de laacabe ca'ru icaa cabe Espíritu Santu, nin ca'ru ganna cabe pa nuu be, sínuque uyuu nisa si cabe ra bini cre cabe Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ne udixhe ná Pedru ne Juan luguiá cabe para ucuaa cabe Espíritu Santu. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ora bi'ya Simón quixhe ná si ca apóstol luguiá ca binni que maca zicaa ca Espíritu Santu la? ucala'dxi nudii vueltu laacabe, ");
INSERT INTO zaiNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","na: ―Latané naa enda nandxó' ca, ti tutiica quixhe naya luguiá' maca zicaa Espíritu Santu. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Para na Pedru rabi laabe: ―Initilú neu vueltu stiu'. Nee nou' zanda sí cabe enda nandxó' sti Dios la? ");
INSERT INTO zaiNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Qué zanda chu' lu lade du ne qué zanda gu'nu dxiiña ni cayuni du ri' purti cadi jneza ni cá ique lu nezalú Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Bisaana ni cá ique lu ca ne unaba perdón Dios tila na guni perdonar lii de ni uní' i'cu ca. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Purti ruuya dxá envidia ndaani ladxidó' lo' ne cá lu yaga lu ná enda ruchee. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Oraque na be: ―Lainaba lu Dios pur naa ti cadi gueeda irá ni na tu ca luguia'ya'. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Biluxe byuí' né si cabe binni irá ni bi'ya cabe bi'ni Señor la? bigueta cabe Jerusalén. Ne irá guidxi sti Samaria ra zidi'di cabe, ziyuí' cabe stiidxa Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ti dxi na ti ángel sti Dios rabi Felipe: ―Biaa uyé guete', neza zeeda cabe de Jerusalén ze cabe Gaza, lu neza cá ndaani gui'xhi que. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Para biree be ze be. Neza ze be que yeugaanda be ti hombre de Etiopía, ti eunuco, tobi ni risaca lade ca xpinni reina Candace. Rapa be xpidxichi reina que. Uyé be Jerusalén, yeusisaca be Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Yanna ma zibí' be, ze be ndaani ti carretón ziyuunda be ni bicaa profeta Isaías. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ne na Espíritu Santu rabi Felipe: ―Bidxiña carretón ca. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Para bidxiña Felipe ne bina diaga cayuunda be ni bicaa profeta Isaías, para na rabi laabe: ―Rie'nu gou' ni cayuunda lu ca. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Oraque na be: ―Ximodo ndi guiene' pa iruti tu usiene naa. Ne gudxi be Felipe quiba cui né laabe raqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ndi nga ni na Xqui'chi Dios ra cayuunda be que: Yené cabe laabe casi riné cabe dendxu ra chi gati, ne casi qué ribidxiaa dendxu huiini ora ugá cabe guicha ladi, zaqueca nin ti diidxa qué niní' be. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Gupa cabe laabe casi ni qué risaca ne bidxiiba cabe donda ique be sin ñuni be gasti'. Iruti qué zuzeete cani za de laabe purti biluxe xpida be ndaani guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Para na eunuco que, rabi Felipe: ―Gudxi naa tu cuzeete profeta Isaías rarí', de laca laa la? o de stobi. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Para bizulú né Felipe ni cayuunda be que ne bisiene laabe stiidxa Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Neza ze cabe que, zidi'di cabe ti ra da' nisa. Para na be: ―Rarí' da' nisa. Ñee qué zanda chuaa ni'sa la? ");
INSERT INTO zaiNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Para na Felipe: ―Zanda, pa runi cre lu de idubi ladxidó' lo'. Oraque na be: ―Rune cre Jesucristu nga Xiiñi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Oraque bicueza dxí be carretón que ne biete iropa cabe ndaani nisa, para uluu nisa Felipe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ra biree cabe ndaani nisa ucuaa Espíritu sti Dios Felipe ziné. Ma qué ñuuya ru be laa. Oraque biree be ze be nayeche'. ");
INSERT INTO zaiNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mala biiya Felipe ma nuu ndaani guidxi Azoto ne uzá byuí' stiidxa Cristu ndaani irá guidxi dede yendá Cesarea. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Cadi cayaana dxí Saulo de cuyubi guuti ca xpinni Cristu. Ngue runi uyé ra nuu sacerdote gola, ");
INSERT INTO zaiNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","yenaba gui'chi para chiné irá yu'du ni nuu Damasco, ti pa idxela hombre o gunaa zinanda Cristu raqué, inaaze laaca', ne guedané laaca Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Peru ra zidxiña be Damasco, mala bizaani ti biaani de ibá' laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Biaba be layú ne bina diaga be caní' tuuxa: ―Saulo, Saulo, xiñee canazabi nanda lu naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Oraque na be: ―Tu lii ya', Señor. Para na ni caní' que: ―Naa nga Jesús ni canazabi nanda lu ca. Cayuniná lu laca lii casi runi buey ora riguu ñee punta puya. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Bidxibi be dede uca diti be, na be: ―Xi racala'dxu gune, Señor. Para na Señor rabi laabe: ―Biasa, uyé ndaani guidxi, ne raqué zabi cabe lii xi gu'nu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nisi biaana cá si ca hombre ziné laabe que. Cayuna diaga ca ridxi que peru cadi cayuuya ca iruti'. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Para biasa be, bixhele lú be, peru qué ñanda ñuuya be. Oraque unaaze cabe ná be yesaana cabe laabe Damasco. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ne zaqué biaana be chonna gubidxa, qué ñuuya be, qué ño be, qué ñe' be. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nuu ti hombre runi cre Cristu ndaani guidxi que lá Ananías. Ne uní' né Señor laa casi ñaca caní' xcaanda', na rabi laa: ―Ananías. ―Rarí nuaa, Señor, na be. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Para na Señor rabi laabe: ―Biasa, uyé lu calle lá Derecha, ralidxi Judas. Yeyubi tobi hombre lá Saulo de Tarso, purti caní' né be naa, ");
INSERT INTO zaiNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ne casi ñaca lu bacaanda ma biiya be tobi hombre lá Ananías. Biuu, gudixhe ná luguiá be para bigueta uná be. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Oraque na Ananías: ―Peru Señor, stale binni huayabi naa xi irá huayuni be cani runi cre lii ndaani guidxi Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ne dede rarí ma napa be xqui'chi ca xaíque sti ca sacerdote para inaaze be tutiica runi cre lii. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Peru na Señor: ―Uyé purti ma ulié laabe chi güi né be ca judíu stiidxa', ne cani cadi judíu, ne ca rey. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ne zulué laabe pabiá' naquiiñe gacaná be ti naca be xpinne'. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Para uyé Ananías, biuu ndaani yoo ra nuu be que ne udixhe ná luguiá be, na: ―Hermanu Saulo, Señor Jesús ni uní' né lii neza zeedu que biseenda naa ra nuu lu', ti ganda iná lu ne idxá ladxidó' lo de Espíritu Santu. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ne oraqueca biaba casi jlaza lú be, ne gunda uná be ne biasa be uyuu nisa be. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Oraque gudó be gueta para bigueta stipa stibe. Ne biaana né be ca xpinni Cristu raqué chupa chonna gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Qué nindaa de ngue bizulú be byuí' be stiidxa Jesús ndaani ca yu'du', cayabi be binni Jesús nga Xiiñi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nabé bidxagayaa irá cani bina diaga laabe. Na ca': ―Ñee cadi laabe nga uzabi nanda be cani runi cre Jesús ndaani guidxi Jerusalén la? Ne para nga ca beeda be rarí', para inaaze be laaca' chiné be laaca ra nuu ca xaíque sti ca sacerdote. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Peru laabe jma rusi ne gana cusiene be laaca Jesús nga Cristu, dede bichenda be ca judíu ni nuu Damasco. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ma xadxí de nuu be raqué uní' stiidxa ca judíu guuti ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ridxí ne huaxhinni ruzuhuaa ca irá ra puerta lindaa sti guidxi que ti pa iree be guuti ca laabe. Peru gunna be ni, ");
INSERT INTO zaiNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ne ucuaa ca xpinni Cristu laabe uluu ca laabe ndaani ti dxumi su, undete ca laabe ra ventana sti lindaa ni nuu guidxi que, ne zaqué gunda bixooñe be. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ne ora yendá be Jerusalén gucala'dxi be nidxaaga be ca xpinni Cristu ni nuu raqué, peru bidxibi ca purti cadi cayuni cre ca pa dxandí ma runi cre be. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Para ucuaa Bernabé laabe yené laabe ra nuu ca apóstol. Byuí' né laaca modo bi'ya be Señor neza ze be, ne uní' né laabe, ne modo qué nidxibi be para byuí' be stiidxa Jesús Damasco. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Oraque ru uná ca biaana be lade ca' ne uzá né be laaca Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Byuí' be stiidxa Jesús sin nidxibi be ne ucuaa yu né be ni ca judíu ni riní' griegu. Peru ucala'dxi ca ñuuti ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ne ora gunna ca hermanu ni, gucuaa ca laabe yené ca laabe Cesarea. De raqué biseenda ca laabe Tarso. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ca dxi ru que ma iruti nuchiiña ca xpinni Cristu, cani nuu Judea ne Galilea ne Samaria. Ne jma rusi bizuhuaa chaahui ca lu stiidxa Dios ne bidale ca'. Qué niree chu ca de laani ne ucané Espíritu Santu laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ra canaganna Pedru ca xpinni Cristu ni nuu irá ladu, laca yeganna cani nuu ndaani guidxi Lida. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Raqué bedandá be tobi hombre lá Eneas nexhe lu luuna', ma raca xhono iza de guti galaa. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Para rabi be laa: ―Eneas, ma bisianda Jesucristu lii. Biasa, bitopa jluuna lu'. Oraqueca biasa. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ora bi'ya irá ca binni Lida ne Sarón ni uca que la? bisaana ca ni runi cre ca para yenanda ca Señor. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ndaani guidxi Jope uyuu ti gunaa runi cre Cristu lá Tabita. Griegu rabi cabe laa Dorcas. Nabé ucané be binni ne ora caquiiñe ca pobre xiixa la? rudii be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ca dxi que beda aca huará be ne guti be. Ucuaa ca binni que gudiibi ca cuerpu stibe ne gudixhe ca laabe ndaani ti cuartu rairopa pisu. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Gaxha riaana Lida de Jope, ne ora gunna ca hermanu nuu Pedru raqué la? biseenda ca chupa hombre chi tidxi laa guiuba gueeda. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Oraqueca biasa Pedru yené ca hombre que, ne ora yendá cabe Jope yené cabe laabe ndaani yoo ra nexhe Tabita. Raqué nuu ca viuda cayuuna ca' ne biluí' ca laabe irá lari gudiba Dorcas dxi nabani. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Oraque ulee be ca binni que, bizuxibi be uní' né be Dios. Ne bitixhi lú be biiya dxí be gue'tu que, ne rabi be laa: ―Tabita, biasa. Para bixhele lú, ne ora bi'ya laabe biasa gurí. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Oraque unaaze be ná' undisa be laa. Ne guridxi be ca hermanu ne ca viuda biluí' be laaca ma nabani Tabita. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Irá binni Jope gunna ni, ne stale tu bini cre Señor. ");
INSERT INTO zaiNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Biaana ru Pedru ndaani guidxi Jope ralidxi ti curtidor lá Simón. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Guyuu ti hombre ndaani guidxi Cesarea lá Corneliu, naca capitán sti Batallón Italiano. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cadi judíu laabe peru ridxibi be Dios ne rusisaca be laa, laabe ne irá binni lidxi be. Nabé racané be ca pobre lade ca judíu ne qué riaana dxí be de iní' né be Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ti dxi bia' las tres casi ñaca lu bacaanda biiya dxichi be biuu ti ángel sti Dios ra nuu be ne rabi laabe: ―¡Corneliu! ");
INSERT INTO zaiNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cadxibi be dede cayaca diti be, biiya dxí be ángel que, ne na be: ―Xi laa, Señor. Para na rabi laabe: ―Ma bigaanda stiidxa lu lu Dios ne ruuya pabiá' racanéu ca pobre. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Yanna biseenda tuuxa che Jope, chi caa tobi hombre lá Simón ne laca rabi cabe laa Pedru. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nuu be ralidxi ti curtidor lá Simón, naca lidxi uriá nisadó'. Laabe zabi be lii xi gu'nu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Biree si ángel que ze', guridxi be chupa jmozo be ne ti soldadu ni runi xhiiña be, ne laa laca ridxibi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Byuí' né be laaca xi guca be. Oraque ru biseenda be laaca Jope. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Sti dxi que ma zidxiña cani biseenda Corneliu que Jope. Ma bia' galaa dxi ngue, ne óraque pe udxi'ba Pedru ique yoo ziní' né Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ma candaana be ne ucala'dxi be ño be peru ca'ru chu' endaró. Laga cabeza be cayaca ni, casi ñaca lu bacaanda ");
INSERT INTO zaiNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","biiya be zuxele ibá' ne zeda yete casi ti lari gueela liibi idapa punta. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ne nuu irá clase mani ndaani ni, mani rizá, mani rixubi ndaani' ne mani huiini ripapa. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ne bina diaga be na tuuxa: ―Pedru, biasa, biiti ne gudó. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Oraque na be: ―Qué ziuu dxi, Señor. Qué huayuu dxi gahua ni na ley stidu cadi idó' do. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Bigueta na ni caní' que rabi laabe: ―Ni cayabi Dios lii go lo la? cadi nou' qué zanda go lo'. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Chonna tiru guca ni. Oraque ru bigueta lari que ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Laga candaa ique né Pedru xi riní' ni bi'ya que la? zeda naba diidxa ca hombre biseenda Corneliu que paraa lidxi Simón, dede bedandá ca ra puerta yoo que, ");
INSERT INTO zaiNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ne unaba diidxa ca pa raqué nuu tobi hombre lá Simón, ni rabi cabe Pedru. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Candaa ique né ru Pedru ni bi'ya que, na Espíritu Santu rabi laa: ―Zeda yubi chonna hombre lii. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Yanna biasa biete. Ne yené laacabe, sin iní' i'cu pa cuchee lu', purti naa biseenda laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Oraque biete be bidxiña be ra nuu ca hombre biseenda Corneliu que, ne rabi be laaca': ―Nanna canayubi tu naa. Rarí nuaa', xi guni tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Para na ca rabi ca laabe: ―Biseenda Capitán Corneliu laadu purti gudxi ti ángel laabe usenda caa be lii para ga'bu laabe xi guni be. Ridxibi be Dios ne runi be jneza, ne irá judíu nadxii laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Oraque gudxi be laaca guiuu ca ndaani yoo, ne biaana ca raqué huaxhinni que. Sti dxi que biree né be laaca', ze cabe, ne yené caadxi hermanu de Jope laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","De lu sti dxi que yendá cabe Cesarea. Ma cabeza Corneliu laacabe. Guridxi ca lisaa ne ca xhamigu cabeza né laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ora bidxiña Pedru biree Corneliu bichagalú laabe ne bizuxibi xa ñee be. Ucala'dxi nusisaca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Peru óraque undisa be laa, rabi be laa: ―Biasa, purti naa laca hombre casi lii naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ziyuí' cabe diidxa biuu cabe ndaani yoo, ne biiya be nuu stale binni raqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Para na be: ―Laatu nanna tu judíu naa ne cá lu ley stidu cadi idxaaga du cani cadi judíu ne cadi chu' du ralidxi ca'. Peru ma biluí' Dios naa zanda idxaaga tutiisi, neca cadi judíu laa. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nga runi casi bisenda caa tu naa, benda ca'. Yanna racaladxe gabi tu naa xi para bisenda caa tu naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Para na Corneliu: ―Raca tapa gubidxa bia' hora rica canié nia Dios rarí casi runi du irá huadxí. Mala biiya zuhuaa ti hombre nezaluá' ruzaani xhaba, ");
INSERT INTO zaiNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","na rabi naa: “Corneliu, ma bigaanda stiidxa lu lu Dios ne ma bietenala'dxi rudii lu guna. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Yanna biseenda tuuxa che Jope, chi caa Simón, ni rabi cabe Pedru. Nuu be ralidxi ti curtidor lá Simón naca lidxi uriá nisadó'. Ora gueeda be zabi be lii xi gu'nu'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ngue runi oraqueca bisenda caa lii, ne diuxquixe pe lii saca beedu'. Yanna rarí nuu du irá du nezalú Dios para ucá' diaga du irá ni gudxi lii ga'bu laadu. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Oraque bizulú Pedru na rabi laacabe: ―Yanna ma nanna bia'ca risaca irá binni nezalú Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Tutiica idxibi laabe ne guni jneza, runi xiiñi be laa, gasti naca xi raza laa. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Bisenda tidxi Dios cani za de Israel ma zanda chu' né ca laa tobi si pur Jesucristu, xaíque sti irá xixé. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Laatu nanna tu despué de byuí' né Juan binni naquiiñe chu' nisa, bizulú bireeche stiidxa Jesucristu Galilea, ne uzá ni idubi naca Judea. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ne laca nanna tu uluu Dios enda nandxó' sti Espíritu Santu ndaani ladxidó' be, para uzá be ucané be binni ne bisianda be cani caguite binidxaba ique, purti nuu né Dios laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Laadu bidu'ya dxichi du irá ni bi'ni be Judea ne ndaani guidxi Jerusalén. Ne laabe nga biiti cabe bicaa cabe lu cruz. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Peru lu chonna gubidxa undisa Dios laabe de lade gue'tu', ne biluí' laabe laadu. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Cadi irá di binni biiya laabe sínuque cani maca ulí Dios, ne nga laadu, purti laadu bidó' né du laabe ne bidé' né du laabe ora ma bibani be de lade gue'tu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ne biseenda be laadu chi güi né du binni stiidxa be ne gabi du laaca laabe nga ni gudixhe Dios cuidxi cuenta irá binni, cani nabani ru dxi gaca ni ne cani ma guti. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Laca de laabe bizeete ca profeta dede ma xadxí. Na ca ni guni cre laabe zaca perdonar ni huachee, pur ni bi'ni be. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Caní' ru Pedru biete Espíritu Santu biuu ndaani ladxidó' irá ni cucaa diaga laa que. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nabé bidxagayaa ca hermanu judíu ni yené Pedru que ora bi'ya ca laca cacaa cani cadi judíu Espíritu Santu. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Gunna ca ma ucuaa cabe Espíritu Santu ora bina diaga ca caní' cabe idioma ni qué niziidi cabe, ne cusisaca cabe Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Oraque na Pedru: ―Xi cucueeza para chu' nisa ca binni ri', purti ma ucuaa ca Espíritu Santu casi ucuaa nu. ");
INSERT INTO zaiNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ne gudxi laacabe chu' nisa cabe ti ihuinni ma xpinni Cristu laacabe. Ne gunaba cabe guiaana né Pedru laacabe xhupa xhonna gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Gunna ca apóstol ne ca hermanu ni nuu Judea laca ma bini cre cani cadi judíu stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ne ora bigueta Pedru Jerusalén bidxiña ca judíu ni ma runi cre Cristu ra nuu be ne udinde né ca laabe, ");
INSERT INTO zaiNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","na ca': ―Xiñee yechuu lu ralidxi cani cadi judíu ne gudó neu laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Oraque bizulú be gudxi be laaca xi irá guca dede ra bizulú ni, na be: ");
INSERT INTO zaiNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Nuaa ndaani guidxi Jope, canié nia Dios. Mala casi ñaca lu bacaanda biiya zeda yete xiixa de ibá' casi ti lari gueela ro' liibi idapa punta. Biaana dxí ni ra nuaa'. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ora biiya dxie ni, biiya dxá mani ndaani ni, mani rizá layú, mani duxhu', beenda', ne mani ripapa. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ne bina dia'ga na tuuxa rabi naa: “Biasa Pedru. Biiti, gudó.” ");
INSERT INTO zaiNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Oraque rabe': “Co', Señor, purti qué huayuu dxi gahua ni na ley cadi idó' do.” ");
INSERT INTO zaiNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Bigueta na ni caní' de ibá' que rabi naa: “Ni cayabi Dios lii go lo la? cadi nou' qué zanda go lo'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Chonna tiru uca ni zacá para bigueta ni ibá'. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ne óraque pe biuu chonna hombre, zeda yubi naa. Biseenda tuuxa de Cesarea laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ne gudxi Espíritu Santu naa chiniá laacabe sin iní' ique pa cuchee'. Ne yené xhi xhoopa hermanu ri naa. Uyuu du ralidxi hombre bisenda caa naa que. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ne ora biu' du raqué byuí' né be laadu xi bizaaca be. Nuu be ndaani yoo, mala biiya be zuhuaa ti ángel lú be, na rabi laabe: “Biseenda tu che Jope chi caa Simón ni rabi cabe Pedru. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Laa zabi lii ximodo ilá lu', lii ne ca binni li'dxu'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ne ora bizuluá' byue nia laacabe diidxa biete Espíritu Santu biuu ndaani ladxidó' cabe casi biuu ndaani ladxidó' no chiqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ne óraque bietenaladxe ni uní' Señor ra na: “Uluu nisa Juan binni peru ne nisa si. Peru laatu zacaa tu Espíritu Santu casi ñaca ñuu nisa tu pur Espíritu que.” ");
INSERT INTO zaiNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ne pa ma bidii Dios laacabe ni bidii laanu ra bini cre nu Señor Jesucristu la? tuu ndi naa para ucueeza ni cayuni Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ora bina diaga ca xi na Pedru la? nin ru sti diidxa qué niní' ca'. Ne bisisaca ca Dios, na ca': ―Yanna ma nanna du laca ma biluí' Dios cani cadi judíu ximodo inaba ca perdón ti gapa ca enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Dxi biiti cabe Esteban, laca bizulú cabe uzá nanda cabe ca xcaadxi xpinni Cristu, ne ca dxi que bireeche ca'. Nuu ni yendá dede Fenicia, ne Chipre ne Antioquía. Ne byuí' ca stiidxa Jesús raqué, byuí' né ca ni ca judíu si. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Peru uyuu caadxi binni Chipre ne de Cirene lade cabe. Ne laaca ora yendá ca Antioquía byuí' né ca cani cadi judíu stiidxa Señor Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ucané Señor laacabe ne stale tu bini cre ne yenanda Señor. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ne ora gunna ca xpinni Cristu ni nuu Jerusalén ni la? biseenda ca Bernabé Antioquía. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nabé bieche Bernabé ora yendá ne biiya pabiá' uluu Dios ndaaya laacabe. Ne bilidxe laacabe sa nanda cabe Señor de idubi ladixdó' cabe sin iree chu cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Nacha'hui Bernabé ne dxá ladxidó' de Espíritu Santu. Nabé napa be fe, ne pur laabe bini cre stale binni Señor. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","De raqué biree be uyé be Tarso yeyubi be Saulo. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ne ora bidxela be laa yené be laa Antioquía. Biaana né cabe ca xpinni Cristu raqué tubiza ne bisiidi cabe stale binni. Ne raqué nga guta lá ca xpinni Cristu cristianu. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ca dxi que biree caadxi profeta Jerusalén, guyé Antioquía. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tobi de laacabe lá Agabo, bizuhuaa lade ca hermanu de raqué ne uní' ni gudxi Espíritu Santu laa, na chi aca ti gubiña idubi naca guidxilayú. Ne uca ni uní' be que dxi naca Claudio gobernador. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Oraque uní' stiidxa ca xpinni Cristu de raqué uchaaga ca bia' ganda udii cada tobi para acané ca ca hermanu ni nuu Judea. ");
INSERT INTO zaiNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Para bitopa cabe ni biseenda né cabe ni Bernabé ne Saulo ra nuu ca xaíque sti ca xpinni Cristu de Judea para qui'zi ca lu ca xcaadxi hermanu. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ca dxi que bizulú rey Herodes bininá caadxi de ca xpinni Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Gucuaa be Jacobo bi'chi Juan, biiti be laa ne espada. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ne ora bi'ya be uyuula'dxi ca judíu ni bi'ni be que la? laca unaaze be Pedru. Ne uca ni dxi ro cabe pan sin levadura que. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Gunaaze si be laa biseguyoo be laa ne gudixhe be tapa tanda soldadu gapa laa, de tapa tapa. Cá ique be cuee be laa nezalú irá binni guidxi que, tidi si pascua. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Zacá nga cayapa cabe Pedru ndaani lidxi guiiba'. Peru ca xpinni Cristu cadi cayaana dxí ca de iní' né ca Dios pur laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Huaxhinni ma para irá gueela cuee Herodes laabe que, nexhe be nisiaasi be lade chupa soldadu, liibi be cadena. Ne laca zuhuaa soldadu cayapa ra puerta lidxi guiiba que. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mala bizuhuaa ti ángel sti Señor ndaani lidxi guiiba que, ne bizaani ti biaani raqué. Ne guda'na ángel que cue' ti'xhi be bicuaani laabe, na: ―Biasa guiuba. Oraque biaba ca cadena liibi ná be que. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Para na ángel que rabi laabe: ―Bixhii dxiichi ndaanu ne bicaa xquela guidi lu ñee lu'. Biluxe si be, na rabi laabe: ―Birenda xhamarra lu', dananda naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Biree be zinanda be ángel que, peru qué ganna be pa dxandí ni o pa caní' xcaanda si be ngue. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Udi'di cabe chupa lugar ra cayapa soldadu ne ora yendá cabe ra puerta de guiiba' ma para iree cabe lu calle, bixele stubi puerta que para biree cabe. Udi'di cabe ti calle. Raqué bixele ángel que de laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Oraque ru sica ni bibani uca be, na be: ―Yanna ma nanna dxandí biseenda Señor ángel sti' beda ulá naa lu ná Herodes ne de irá ni ucala'dxi ca judíu ñuni naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ne ora bi'ya be ngue ni la? uyé be ralidxi María, jñaa Juan ni rabi cabe Marcu. Raqué nuu stale binni caní' né Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ora yendá be bixhidxi ná be ra zaguán. Bina diaga ti badu dxaapa lá Rode para biree ziguuya tu cuxhidxi ná'. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ne ora binibiá' stidxi be, de tantu cayeche qué nuxhele', laga bigueta uxooñe'. Yetidxi ca binni que zuhuaa be ra puerta'. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Peru na ca binni que rabi laa: ―Cayaca ique lu nga. ―Co', na, ―dxandí ni. Oraque na ca': ―Seguru xpisi be nga. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Peru laabe cadi cayaana dxí be de cuxhidxi ná be. Ne ora bixhele ca biiya ca laabe ni, bidxibi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peru bi'ni be seña lu ca igani ca'. Ne byuí' né be laaca modo ulee Señor laabe de ndaani lidxi guiiba', ne rabi be laaca': ―Lagüí' né ni Jacobo ne ca xcaadxi hermanu. Ne óraque biree be ze be sti ladu. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ora birá gueela hueru hueru uyuu ca soldadu, qué ganna ca xi uca Pedru. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Biyubi Herodes laabe irá ladu. Biiya si qué nidxela laabe unaba diidxa ca soldadu que, ne ora na ca qué ganna ca la? biseenda guuti be laaca'. Ne biree be Judea, yendeza be Cesarea. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nuu dxiichi né Herodes ca binni Tiro ne Sidón. Peru laaca uyuu ca tobi si para idxiña ca ra nuu be. Ne uní' né ca Blasto, ti xpinni be, cuee xiana laabe ti chu' né be laaca tobi si, purti de xquidxi be reeda endaró stica'. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Para gudixhe be ti dxi gu'ya be laaca'. Ne dxi gunda dxi que bizuchaahui be, gurí be ra ribí be para guni mandar be ne uluu be ti discursu. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Oraque bicaa ca binni que ridxi bidxiiba ca laabe, na ca': ―Dios nga ni caní' ca, cadi binni. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nin ca'ru iluxe iní' be, bini huará ti ángel laabe purti qué nusisaca be Dios. Biguidxi be bicuti' dede ra guti be. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Peru stiidxa Dios jma rusi careeche, ne cayuí' cabe ni irá ladu. ");
INSERT INTO zaiNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Biluxe si xhiiña Bernabé ne Saulo Jerusalén bigueta ca' ne yené ca Juan ni rabi cabe Marcu que. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Lade ca xpinni Cristu ni nuu Antioquía uyuu caadxi profeta ne maistru. Nuu Bernabé ne Simón ni rabi cabe Ya'se', ne Luciu de Cirene ne Manaén ni biniisi né gobernador Herodes tobi si, ne Saulo. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ti dxi cayaana cabe sin go cabe, ne cayuni cabe cultu, uní' né Espíritu Santu laacabe na: ―Lacuee chu Bernabé ne Saulo para guni ca dxiiña ni gudixhe guni ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ne qué ño gá cabe, uní' né cabe Dios ne gudixhe ná cabe luguiá ca' para biseenda cabe laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Zacá nga biseenda Espíritu Santu laacabe chi guni cabe dxiiña'. Uyé cabe Seleucia. De raqué uyé cabe ti nisa dede yendá cabe isla Chipre. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ne biuu cabe ndaani ti guidxi lá Salamina. Raqué bizulú cabe byuí' cabe stiidxa Dios ndaani ca yu'du sti ca judíu. Laca yené cabe Juan para gacané laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Uzá cabe idubi naca isla que dede yendá cabe Pafos. Raqué biiya cabe ti magu lá Barjesús. Ma na profeta sti Dios laa peru cadi dxandí ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tobi si laa ne gobernador Sergiu Paulo. Nabé nuu xpiaani gobernador que, ne bisenda caa Bernabé ne Saulo purti racala'dxi guna diaga stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Peru qué niná gá Elimas. (Nga rabi cabe magu que stiidxa cabe.) Qué niná purti qué racala'dxi guni cre gobernador que. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Oraque biiya dxí Saulo laabe. Saulo ca ca nga Pablu. Ne dxá ladxidó' de Espíritu Santu, ");
INSERT INTO zaiNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","na rabi laabe: ―Xpinni binidxaba', nisi rusiguii lu ne ruyubu uchee lu'. Qué riula'dxi lu gasti ni jneza. Padxí guiaana dxiu de uchaa lu stiidxa Señor. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yanna ma chi usaba ná Dios lii. Zacheepa lú lu', xadxí ziaanu sin gu'ya lu gubidxa. Ne oraqueca bicheepa lú be ne canazá be idubi raqué canayubi be tu inaaze ná be. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ora bi'ya gobernador ni guca que la? bini cre ne bidxagayaa de stiidxa Señor ni cusiidi cabe que. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Biree Pablu de Pafos, laa ne cani canazá ne laa que, uyé ca Perge ti guidxi de Panfilia. Raqué biree chu Juan de laacabe bigueta Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Peru laacabe biree cabe de Perge, uyé cabe Antioquía de Pisidia, ne ti dxi enda riziila'dxi biuu cabe ne gurí cabe ndaani yu'du sti ca judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Biluxe biuunda si ni bicaa Moisés ne ni bicaa ca profeta, bisenda tidxi ca xaíque sti yu'du que laacabe pa napa cabe xiixa diidxa gabi cabe ca binni que la? zanda iní' cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Para biasa Pablu, bi'ni seña lú cabe igani cabe, ne na: ―Binni xquidxe ca' ne irá tu, cani ridxibi Dios, laucaa diaga. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dios stinu, binni Israel ca', ulí ca bixhoze gola nu ne bitale laacabe dxi canazá cabe xquidxi binni dxi nuu cabe Egipto. Ulee laacabe de raqué ne enda nandxó' sti'. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ne uzá né laacabe ndaani gui'xhi bia' cuarenta añu sin nixhacala'dxi laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Oraque binitilú gadxe guidxi ni nuu Canaán para bidii ni laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ne gudixhe juez lade cabe. Bindaa ni bia' tapa gayuaa cincuenta añu dede xhi profeta Samuel. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","De raqué unaba cabe gapa cabe rey. Para ulí Dios Saúl xiiñi Cis ni za de Benjamín. Laa guca rey sti cabe cuarenta añu. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ra undisa Dios Saúl bicuí David. De laabe nga bizeete Dios ra na: “Ma biiya runi David, xiiñi Isaí, ni riuladxe' ne zuni irá ni gabe laa.” ");
INSERT INTO zaiNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ne de lade ca xiiñi David beeda Jesús. Biseenda Dios laabe beda ulá be ca binni Israel casi bidii stiidxa guni. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Dxi ca'ru gueeda Jesús, byuí' né Juan ca binni Israel naquiiñe inaba ca perdón Dios ne chu' nisa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ne dxi mayaca gati Juan na: “Cadi zácaxa tu naa nga ni cabeza tu que. Nanda stobi naa, ne qué risaca dia' nin para cuee xquela guidi ñee.” ");
INSERT INTO zaiNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Biche', xiiñi Abraham ca', ne irá ni ridxibi Dios lade tu, para laatu nga ca diidxa ni rabi laanu ximodo ilá nu ca. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ca binni Jerusalén ne ca xaíque stica qué ñunibiá' ca Jesús ne qué ñene ca ni bicaa ca profeta ni ruunda ca irá dxi enda riziila'dxi'. Peru bi'ni ca ni na ni ra gudixhe ca gati be. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Neca qué nidxela ca gasti donda luguiá be peru unaba ca Pilatu useenda guuti laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ne biluxe si bi'ni ca irá ni maca cá gaca be la? undete ca laabe lu cruz, bicaachi ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Peru undisa Dios laabe de lade gue'tu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ne óraque bidxiña be ra nuu cani yené laabe dxi biree be Galilea uyé be Jerusalén, bindaa be ra nuu ca'. Yanna laaca nga canayuí' ca ni biiya ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Ne laadu ma zeda tidxi du laatu ma bi'ni Dios ni gudxi ca bixhoze gola nu chiqué chi guni, ne bi'ni ni para laanu. Uca ni ra undisa be Jesús casi cá ni lu rairopa Salmo ra na Dios: “Lii nga Xiiñe'. Dede yanadxí naa nga Bixho'zo'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ne chiqué na Dios zadxiña dxi usibani Jesús ti qué guiu'dxu xcuerpu. Ndi nga ni uní' be que: “Zaguaa ndaaya lii casi bidiee stiidxa David gune'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ne laca cá lu sti Salmo ra na David: “Qué zudiiu lugar guiu'dxu cuerpu sti ni nadxii lu que.” ");
INSERT INTO zaiNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ne lu Salmo ca cadi cuzeete David de laca laa, sínuque cuzeete de Jesús. Purti bi'ni David xhiiña Dios dxi bibani, peru bidxiña dxi guti, ne bigaachi ra bigaachi irá ca bixhoze gola, ne biaana xcuerpu biu'dxu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Peru ni undisa Dios de lade gue'tu que la? qué ñu'dxu di cuerpu sti'. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Biche ca', laganna pur Jesús ni cuzeete ri ma zanda aca perdonar binni ne para nga runi cayuí né du ni laatu. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Qué ñanda nulá ley sti Moisés laatu, peru yanna irá tu guni cre Jesús zalá. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Laguuya gá cadi izaaca tu ni bicaa ca profeta ni uní' Dios ra na: ");
INSERT INTO zaiNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Laucaa diaga, laatu, cani runi burla, ne laidxagayaa. Zanitilú tu purti zune ti milagru naro'ba lade tu ni qué zuni cre tu neca güi né cabe ni laatu. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ora biree Pablu ne Bernabé de ndaani yu'du que, na ca binni que rabi laaca': ―Latá' sti sábadu ca para güi né tu laadu ni byuí' né tu laadu yanadxí ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ora biluxe cultu sti ca judíu que, yenanda stale binni Pablu ne Bernabé, cásica judíu zaqueca cani cadi judíu ni ma zinanda religión sti ca judíu. Ne gudxi cabe laaca cadi usaana ca ni ma bidii Dios laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sti sábadu que casi idubi guidxi que bidxiña para ucaa diaga stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Peru ora bi'ya ca judíu irá binni que, bidii envidia laaca', ne bizulú ca na ca cadi dxandí ni caní' Pablu que, ne udindené ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Peru qué nidxibi Pablu ne Bernabé, na ca rabi ca laacabe: ―Nirudó' laatu nexhe güi né du stiidxa Dios, peru ma bidxii tu ni. Laca laatu cusihuinni tu qué iquiiñe tu para icaa tu enda nabani ni qué zaluxe. Yanna ma chiné du ni ra nuu cani cadi judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Purti nga nga ni gudxi Señor laadu, na: Ma gudixhe lii para chinéu stiidxa ra nuu cani cadi judíu. Casi ñaca lii nga ti biaani ni chi guzaani irá binni guidxilayú para ganna ca modo ilá ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ora bina diaga cani cadi judíu ni na cabe que la? bieche ca ne na ca nabé sicarú stiidxa Dios, ne bini cre cani ma nexhe icaa enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ne bireeche stiidxa Señor idubi naca neza que. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Peru gudxite ca judíu ique caadxi gunaa nabé rie yu'du', gunaa ni risaca, ne caadxi hombre ni runi mandar ndaani guidxi que, para undisa ca ca binni de raqué uzabi nanda ca Pablu ne Bernabé dede uladxi ca laacabe. Nin idubi raqué qué nusaana ca laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ne ora biree cabe raqué udxibi ñee cabe casi ti seña bichee ca binni que ra qué nuchagalú ca laacabe. De raqué uyé cabe Iconio. ");
INSERT INTO zaiNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Peru ca xpinni Cristu ni biaana ra biree cabe que la? dxá ladxidó' ca de Espíritu Santu ne nayeche nuu ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ra yendá cabe Iconio biuu cabe ndaani yu'du sti ca judíu. Ne pur modo byuí' cabe stiidxa Dios raqué bini cre stale binni, cásica judíu zaqueca ni cadi judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Peru gudxite ca judíu ni qué ñuni cre ique cani cadi judíu, ti ma ne laaca gaca nanala'dxi ca ca hermanu. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Peru qué niree Pablu ne Bernabé raqué. Biaana ru cabe byuí' cabe stiidxa Señor sin nidxibi cabe, purti nanna cabe nuu né Señor laacabe. Cayabi cabe binni racala'dxi Dios ulá laaca'. Ne bisihuinni Señor dxandí ni caní' cabe que, purti ucané laacabe bi'ni cabe stale milagru. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ne undaa saa ca binni guidxi que. Caadxi nuu pur ca judíu ne xcaadxi nuu pur ca apóstol. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Oraque uca irá cani qué ñuni cre tobi si, ca judíu ne cani cadi judíu ne ca xaíque stica'. Uní' stiidxa ca ucaa lú ca Pablu ne Bernabé, uchá ca guie laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Peru gunna cabe ni, para biree cabe raqué uyé cabe caadxi guidxi sti Licaonia, Listra ne Derbe ne idubi neza que. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ne byuí' cabe stiidxa Cristu raqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ndaani guidxi Listra zuba tobi hombre nachiita ñee dede dxi gule, nin qué huayuu dxi sa'. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Cucaa diaga be ra cayuí' Pablu diidxa'. Ne óraque biiya dxí Pablu laabe ne biiya runi cre be zanda guianda be. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Para bicaa ti ridxi, na rabi laabe: ―Biasa, bizuhuaa jneza. Oraqueca biasa uxooñe be ne uzá be. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ora bi'ya ca binni que xi bi'ni Pablu, bicaa ca ridxi peru stiidxa ca' ni lá Licaonia, na ca': ―Zeda ganna chupa dios stinu laanu. Ruluí' si cabe binni. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ulee lá cabe Bernabé Júpiter, ne Pablu ulee lá cabe laa Mercuriu, purti laa nga caní'. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Uriá guidxi que nuu xhiu'du Júpiter. Para beeda sacerdote sti yu'du que bedané yuze ne doo guie'. Laa ne ca binni que, ucala'dxi ca ñuuti ca yuze que nezalú Pablu ne Bernabé casi runi ca nezalú ca bidó' stica'. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ora bi'ya Pablu ne Bernabé xi cayuni cabe la? ucheza ca xhaba ca para ihuinni cadi cayuula'dxi ca ni. Ne biaazi ca lade binni que cucaa ca ridxi, na ca': ");
INSERT INTO zaiNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―Xii nga chi guni tu, hombre ca'. Laca binni guidxilayú laadu casi laatu. Nga pe nga zeda tidxi du laatu, usaana tu irá ni runi tu ri', purti qué iquiiñe cani, para sa nanda tu Dios ni nabani ni bizá' ibá' ne guidxilayú ne nisadó' ne irá ni nuu ndaani cani. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Chiqué bidii be lugar bi'ni binni ni na ique. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Peru biluí' be laaca tu laabe pur ni bi'ni be, purti ucané be laaca casi racané be laanu yanna, rusaba be nisa guie para gaca xquela nu. Qué rusiaadxa be ni idó' no, ne ruchá be ladxidó' no de enda nayeche'. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Neca uní' cabe irá nga peru dxiiña bidii laacabe para bicueeza cabe ca binni que de guuti ca ca yuze que nezalú cabe casi runi ca lu xpidó' ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Oraque beeda caadxi judíu de Antioquía ne de Iconio. Udxite ca ique ca binni que uchá ca guie Pablu. Biluxe si bichá ca guie laabe, zácaxa ca ma guti be, uxubi yu ca laabe, ulee ca laabe ndaani guidxi que. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Peru ora bidxiña cani ma bini cre Cristu ndaani guidxi que ra nuu be la? biasa be ne biuu be ndaani guidxi que. Sti dxi que biree né be Bernabé raqué, uyé cabe Derbe. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Byuí' cabe stiidxa Cristu ndaani guidxi que ne stale binni bini cre. Ne óraque bigueta cabe Listra ne Iconio ne Antioquía. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Yeuzuhuaa chaahui cabe ca xpinni Cristu ne gudxi cabe laaca cadi iree chu ca de ni ma runi cre ca'. Ne laca rabi cabe laaca': ―Naquiiñe tidi nu stale ra nagana ante chu' nu ra runi mandar Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ne cada ra uyé cabe ulí cabe caadxi hermanu para sa niru lú ca xcaadxi, ne ulee lá cabe laaca hermanu gola. Biaana cabe sin ño cabe ne uní' né cabe Dios, ne óraque udixhe cabe irá ca lu ná Señor ni runi cre ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","De raqué udi'di cabe idubi Pisidia para yendá cabe Panfilia. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ne biuu cabe ndaani ti guidxi stini lá Perge. Biluxe si byuí' cabe stiidxa Dios raqué biree cabe uyé cabe Atalia. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","De raqué ucuaa cabe ti barcu bigueta cabe Antioquía, ra gudixhe ca hermanu laacabe lu ná Dios ni nadxii laacabe, para gupa laacabe lu dxiiña yeguni cabe que. Ne yanna ma binduuxe cabe ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ora yendá cabe guridxi cabe irá ca xpinni Cristu para byuí' né cabe laaca irá ni bi'ni Dios ra yeguni cabe xhiiña', ne modo ma cuxhele Dios neza para guni cre cani cadi judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Biaana né cabe ca binni que xadxí. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ca dxi que bedandá caadxi hombre Antioquía. Beeda cabe de Judea, beda usiidi cabe ca hermanu pa qué gapa ca seña sti Dios casi na Moisés gapa binni la? qué zalá ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Xadxí ucuaa yu né Pablu laacabe de laani, laa ne Bernabé. Para biaana ca xpinni Cristu che Pablu ne Bernabé ne xcaadxi hermanu Jerusalén. Chi guuya ca xi na ca apóstol ne ca hermanu gola de enda raca circuncidar. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Para ucuaa ca xpinni Cristu laacabe yeuzuhuaa ca laacabe neza. Udi'di cabe Fenicia ne Samaria. Ne irá ra udi'di cabe byuí' né cabe ca hermanu ma cayuni cre cani cadi judíu, ne nabé bieche ca ora gunna ca ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ora yendá cabe Jerusalén bichagalú ca xpinni Cristu laacabe, ne ca apóstol ne ca hermanu gola, ne byuí' né cabe laaca irá ni bi'ni Dios ra yeguni cabe xhiiña'. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Peru óraque biasa caadxi fariseu ni ma runi cre, na ca': ―Naquiiñe ucá' nu cani cadi judíu gapa seña sti Dios ne guni ca irá ni na ley sti Moisés. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Oraque gupa ca apóstol ne ca hermanu gola ti junta para gu'ya ca pa dxandí naquiiñe gaca circuncidar cani cadi judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ma xadxí de cacaa yu cabe ni, bizuhuaa Pedru ne na: ―Hermanu ca', laatu nanna tu dede dxi bizulú bireeche stiidxa Cristu ulí Dios naa chi güe nia ni cani cadi judíu para guni cre ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Runibiá' Dios ladxidó' binni, ne bisihuinni ma xpinni laacabe ra bidii laacabe Espíritu Santu casi bidii laanu. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ne qué rihuinni pa adxé laacabe para laanu nezalú Dios, purti bisiá ladxidó' cabe ra bini cre cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Yanna xiñee cadi cayuula'dxi tu ni ma bi'ni Dios. Racala'dxi tu ucaa tu cani runi cre Cristu guni xiixa nin laanu nin ca bixhoze gola nu qué ñanda ñuni. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Laanu la? runi cre nu zalá nu purti nadxii Señor Jesús laanu, ne zacaca laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Oraque ru dxí do' uyuu irá ca ne bicaa diaga ca Bernabé ne Pablu ra byuí' né laaca irá seña ne milagru ni bi'ni Dios ra uzá ca lade cani cadi judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Biluxe si uní' ca' para na Jacobo: ―Hermanu ca', laucaa diaga ni chi tidxe laatu ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ma byuí' né Simón laanu modo bizulú bilabi Dios cani cadi judíu. Laca ma cabí xpinni lade cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ne nga ca bicaa ca profeta ra na Dios: ");
INSERT INTO zaiNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Zandisa xcaadxi ni gaca xpinne jlugar ca xiiñi David ni ma biree chu de naa. Zutopa cani qué niree chu, udxigueta laaca ra uyuu ca chiqué, ");
INSERT INTO zaiNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ti uyubi irá binni naa dede cani cadi judíu ni ma ulié gaca xpinne'. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nga nga ni na Dios, ne ma xadxí gudxi be ni laanu. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Nga runi rabe cadi uchi'ña nu cani cadi judíu, cani cusaana ni runi cre para chi nanda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Sínuque ni guni nu la? ucá' nu ti gui'chi lú cabe gabi nu laacabe cadi go cabe ni ma gu'ta lu bidó' ne cadi chu' né cabe ni cadi xheela cabe ne cadi go cabe xpeela tutiica mani ni bixii yanni, nin go cabe rini. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Purti dede ma xadxí nuu tu rusiidi ley sti Moisés ndaani irá guidxi. Ruunda cabe ni ra yu'du irá dxi enda riziila'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ne biaana ca apóstol ne ca hermanu gola ne ca xcaadxi xpinni Cristu cui ca chupa de laaca para useenda né ca Pablu ne Bernabé Antioquía. Ne ulí cabe Judas ni rabi cabe Barsabás, ne Silas, chupa de cani za niru lú ca xcaadxi. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bi'ni cabe ti carta para chiné ca'. Ndi nga ni cá lu carta que: “Hermanu ca', laadu, ca apóstol ne ca hermanu gola, cugapa diuxi du laatu, ca hermanu ni cadi judíu ni nuu Antioquía ne Siria ne Cilicia. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ma gunna du uyé caadxi de rarí ra nuu tu, yeuchiiña ca laatu ne ni cusiidi ca', na ca naquiiñe gapa tu seña sti Dios ne guni tu ni na ley. Cadi laadi du bise'nda du laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nga runi gupa du ti junta ne biaana du cui du chupa hermanu use'nda né du iropa hermanu ni nadxii du ri', Pablu ne Bernabé. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Cadi cayá ca xpida ca para cayuni ca xhiiña Señor Jesucristu stinu. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Cuse'nda du Judas ne Silas. Laaca güi né ca laatu ni cuze'te du ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Purti para laadu ruluí' cadi galán uguá du laatu jma que bia' nexhe guni tu, ne nga ca gudxi Espíritu Santu laadu. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Casi cadi go to ni ma udixhe cabe lu bidó', nin rini, nin tutiica mani ni bixii yanni, ne cadi chu' né tu ni cadi xheela tu. Pa ixele tu de ca nga la? ze tu jneza. Sicarú guiaana tu.” ");
INSERT INTO zaiNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Biluxe si carta que biseenda né cabe ni laaca'. Ne ora yendá ca Antioquía guridxi ca ca xpinni Cristu de raqué ne bidii ca ni laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ne ora bi'nda cabe ni bieche né cabe ca conseju cá lú ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Nabé byuí' né Judas ne Silas ca hermanu que stiidxa Dios purti profeta laaca'. Ne zacá bisieche ca laacabe ne ucané ca laacabe bizuhuaa chaahui cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Biaana ca raqué xadxí ne óraque na ca ma chi ibigueta ca ra nuu cani biseenda laaca'. Para na ca hermanu que: ―Laché, chiné Dios laatu. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Peru óraque na Silas ziaana ru'. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablu ne Bernabé laca biaana ru ca raqué. Bisiidi ca ca hermanu ne byuí' né ca binni stiidxa Señor, laaca ne xcaadxi. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ma xadxí huiini de nuu cabe raqué na Pablu rabi Bernabé: ―Xiñee qué ibigueta nu ca guidxi, irá ra ma byuí nu stiidxa Señor. Chi ganna nu ca hermanu, idu'ya nu xi ze xa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ne gucala'dxi Bernabé niné cabe Marcu. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Peru na Pablu ruluí' cadi galán chi né cabe laabe, purti bixele be de laaca Panfilia, ne de raqué qué nizá né ru be laaca lu xhiiña Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nabé ucuaa yu cabe ni peru qué ñanda ñuu cabe tobi si, para undaa saa cabe. Ucuaa Bernabé Juan Marcu, udxi'ba né ndaani ti barcu ze ca Chipre. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablu ucuaa Silas, ne gudixhe ca hermanu laaca lu ná Dios gapa laaca'. Para biree ca ze ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Uzá ca Siria ne Cilicia, yeuzuhuaa chaahui ca ca xpinni Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ra canazá cabe que yendá cabe Derbe. Biree cabe raqué uyé cabe Listra. Raqué biiya cabe ti xpinni Cristu lá Timoteu. Jñaa be la? judíu laa ne ma runi cre Cristu, peru bixhoze be cadi judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Irá ca hermanu de Listra ne de Iconio ruzeete pabiá' nacha'hui be. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Na Pablu chiné laabe, para ucuaa laabe guluu seña sti Dios laabe ti qué gapa ca judíu ni nuu neza que xi iní', purti nanna ca cadi judíu bixhoze be. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Oraque biree cabe ze cabe. Ne irá guidxi ra udi'di cabe byuí' né cabe ca binni que ni gudixhe ca apóstol ne ca hermanu gola ni nuu Jerusalén guni ca xpinni Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Zacá jma bizuhuaa chaahui ca xpinni Cristu, ne ze dxi jma zidale ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Uzá cabe Frigia ne Galacia, ne udi'di cabe Asia peru qué niná Espíritu Santu ñui' cabe stiidxa Dios raqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ora yendá cabe ra ruzulú Misia, ucala'dxi cabe ñe cabe Bitinia, peru laca qué niná Espíritu sti Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Para udi'di cabe uriá Misia, uyé cabe Troas. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ne huaxhinni que casi ñaca lu bacaanda biiya Pablu zuhuaa tobi hombre de Macedonia canaba laa che raqué chi acané laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","(Ne naa nuaa raqué.) Ne casi bi'ya be ni biluí' Dios laabe que, gudixhe chaahui du stidu para chuu du Macedonia purti rabi du cabidxi Dios laadu chuu du raqué, chi güi né du ca binni que stiidxa Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Para biré' du de Troas. Ucuaa du ti barcu uyuu du derechu isla Samotracia. Sti dxi que yendá du Neápolis. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ne biete du raqué para uyuu du Filipos, ti guidxi ni jma dxi'ba ca xcaadxi guidxi sti Macedonia ni nuu neza que. Ca romanu naaze guidxi que. Biaana du raqué xadxí huiini'. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ti dxi enda riziila'dxi biré' du de ndaani guidxi que, uyuu du ra guiigu ra rie ca judíu riní' né Dios. Ma nuu caadxi gunaa raqué yendá du, para byuí né du laaca stiidxa Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Lade cabe nuu ti gunaa de Tiatira lá Lidia rutoo lari cha'hui color moradu. Cadi judíu laabe peru maca rusisaca be Dios, ne dxi que bicuudxi Dios ladxidó' be para gucuaa be stiidxa Pablu. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ne uyuu nisa be, laabe ne irá ca binni lidxi be. Oraque rabi be laadu: ―Pa na tu dxandí ma bine cre Señor la? latá' guiaana tu ralidxe'. Ne tantu cá be lu du la? biaana du. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ti dxi biré' du ziní né du Dios, beda nanda ti badu dxaapa laadu, nuu né binidxaba'. Nabé runi ganar para xpixuaana', purti runi sertá ni inaba diidxa binni laa. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Uzá nanda be laadu, ziyuni be ridxi, na be: ―Xhiiña Dios ni nandxó' cayuni ca hombre ri', ne zeda güi né ca laatu modo ilá tu, rabi be ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Zaqué uzá nanda be laadu stale dxi, peru bixhacala'dxi si Pablu de canananda be laa la? bidxigueta lú ne na rabi binidxaba que: ―Cayabe lii usaana lu badu dxaapa ca, casi ñabi Jesucristu ni lii. Oraqueca bisaana binidxaba que laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Peru ora bi'ya ca xpixuaana be ma qué zanda guni ganar né ru ca laabe la? unaaze ca Pablu ne Silas yené ca ra nuu justicia. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ne ora yendá ca raqué, na ca': ―Canayuni yaya ca judíu ri ndaani xquidxi nu. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Cusiidi cabe costumbre ni cadi jneza icaa nu chi nanda nu purti romanu laanu. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ne óraque biasa irá binni que luguiá Pablu ne Silas. Ne ucuaa ca justicia que laacabe ulee ca lari ladi cabe ne bini mandar ca chu' cabe palu. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Biluxe si guluu ca palu laacabe biseguyoo ca laacabe ne gudxi ca ni rapa ra lidxi guiiba que gapa chaahui laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Para ucuaa ngue laacabe uluu laacabe dede últimu cuartu sti lidxi guiiba que. Ne uluu ñee cabe lade chupa yaga rabi cabe cepu. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Bia' galaa gueela caní' né cabe Dios ne cayuunda né cabe laa. Cucaa diaga ca xcaadxi presu que laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Mala uca ti xu ro' dede biniibi dxacha raqué ne bixele irá ca puerta sti lidxi guiiba que. Ne bindaa cadena liibi irá cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ora bibani ni rapa ra lidxi guiiba que, biiya ma zuxele irá puerta stini, ulee espada ucala'dxi ñuuti laca laa. Zácaxa ma bixooñe irá presu. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Peru óraque bicaa Pablu ti ridxi, na rabi laabe: ―Cadi guniná lu laca lii, irá du nuu du rarí'. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Para unaba be ti biaani ne biuu uxooñe be ndaani lidxi guiiba que. Dede cayaca diti be gudiche xibi be xa ñee Pablu ne Silas. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ne ulee be laaca de raqué rabi be laaca': ―Biche ca', xi gune para ila'ya'. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Para na ca rabi ca laabe: ―Bini cre Señor Jesucristu ne zalá lu', lii ne ca binni li'dxu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ne byuí' né ca laabe stiidxa Señor, laabe ne irá ni nabeza ralidxi be. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Lu gueela queca ucuaa be laaca', udiibi be ra ucaná laaca', ne óraque uyuu nisa be, laabe ne ca binni lidxi be. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Oraque yené be laaca ralidxi be bidii be ni gudó xhi ca'. Nabé bieche cabe, laabe ne idubi xfamilia be, purti ma bini cre cabe Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ora birá gueela biseenda justicia gendarme, chi tidxi ni rapa lidxi guiiba que cuee Pablu ne Silas. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Oraque na hombre que rabi Pablu: ―Bisenda tidxi ca justicia cuee laatu. Yanna lairee. Laché, chiné Dios laatu. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Peru na Pablu: ―Ucuaa cabe laadu, udiñe cabe laadu nezalú irá binni sin ñuuya chaahui cabe pa dxandí cuché' du, ne uluu cabe laadu ndaani lidxi guiiba', naca nda du romanu. Ne yanna ma racala'dxi cabe cuee cabe laadu naga'chi la? Qué zaré' di du dede qué gueeda cabe, laa pe cabe, gueda ndee cabe laadu. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Para bigueta ca gendarme que, yetidxi ca ca justicia xi na cabe. Nabé bidxibi ca ora gunna ca romanu laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Para uyé ca ra nuu cabe yenaba ca perdón laacabe. Oraque ulee ca laacabe ne na ca guni cabe favor iree cabe de guidxi que. ");
INSERT INTO zaiNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ora biree cabe de lidxi guiiba que uyé cabe ralidxi Lidia guridxi cabe ca hermanu ne gudxi cabe laaca cadi cui sa ca atrá. Oraque ru biree cabe ze cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Biree cabe raqué udi'di cabe Anfípolis ne Apolonia dede yendá cabe Tesalónica. Raqué nuu ti yu'du sti ca judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Biuu Pablu ndaani yu'du que casi runi irá ra che'. Ne chonna sábadu bisiidi be ca binni que ne bisiene be laaca xi na Xqui'chi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Biluí' be laaca ra cá ni, napa Cristu xidé gati' ne ibani, ne rabi be laaca': ―Jesús ni cayué stiidxa ca la? nga nga Cristu ca. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bini cre caadxi de ca binni que ne yenanda ca Pablu ne Silas. Ne laca bini cre stale de cani cadi judíu ni ma zinanda religión sti ca judíu, ne stale gunaa ni risaca ndaani guidxi que. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Peru bidxiichi ca judíu ni qué ñuni cre, ne bitopa ca caadxi hombre qué iquiiñe canazá si, ne bi'ni ca binni. Bini yaya ca ndaani guidxi que, ne yechuu ca ralidxi Jasón. Zindee ca Pablu ne Silas para nudii ca ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Peru biiya si ca qué nidxela ca laacabe raqué la? ucuaa ca Jasón ne xcaadxi hermanu, yené ca ra nuu justicia ne bicaa ca ridxi na ca': ―Canazá chupa hombre canautiixhi irá binni guidxilayú ne ma bedandá ca rarí'. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ne uluu Jasón laacabe ralidxi. Cuchee né cabe ca ley ni gudixhe César ni runi mandar ca guidxi romanu, purti na cabe nuu sti rey lá Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ora gunna ca binni que ne ca justicia xi na cabe que la? bizulú nda ca bi'ni ca ridxi. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ne unaba ca usaana Jasón ne ca xcaadxi hermanu que vueltu casi ti seña zaree, Pablu ne Silas de ndaani guidxi que. Bisaana cabe ni, ne óraque ru bindaa ca laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Huaxhinni queca ulee ca hermanu que Pablu ne Silas, biseenda ca laacabe Berea. Casi yendá cabe Berea biuu cabe ndaani yu'du sti ca judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Jma nacha'hui ca judíu que, que cani nuu Tesalónica, purti bicaa diaga ca stiidxa Dios ne stale gana ne irá dxi ma cuyubi ca lu Xqui'chi Dios pa jneza ni caziidi ca que. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nga runi stale de laaca bini cre, ne laca bini cre stale ni cadi judíu cásica gunaa ni risaca ndaani guidxi que zaqueca hombre. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Peru ora gunna ca judíu de Tesalónica laca ma cayuí' Pablu stiidxa Dios Berea la? yechite ca ique ca binni raqué para uyé ca luguiá Pablu. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Peru oraqueca biseenda ca hermanu que tu chi saana laabe uriá nisadó'. Silas ne Timoteu biaana ru ca raqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Cani ziné laabe que, dede Atenas yesaana ca laabe, ne gudxi be laaca gabi ca Silas ne Timoteu guiuba che ra nuu be. Oraque ru bigueta ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Laga nuu be Atenas cabeza be laaca cadi nuu dxí ladxidó' be purti cayuuya be dxá bidó' ndaani guidxi que. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ngue runi uyé be ndaani yu'du yegüí né be ca judíu ne ca xcaadxi binni ni rusisaca Dios diidxa'. Ne irá dxi uyé be luguiaa, yegüí né be tutiica idxaaga be diidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Raqué bidxaaga be caadxi xpinni Epicuro ne caadxi ni rinanda ni rusiidi ca estoico. Caadxi de laaca na: ―Xi na ni caní' huaahua ca pue. Ne xcaadxi na: ―Ruluí' canaucheeche be stiidxa tuuxa dios ni qué runibiá' nu. Caní' ca zaqué purti canayuí' be stiidxa Jesús ne enda ribani de lade gue'tu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ucuaa ca laabe yené ca laabe ti lugar lá Areópago ra rapa ca junta stica'. Ne na ca rabi ca laabe: ―Zanda ga'bu laadu xi nacubi ri cusiidi lu la? ");
INSERT INTO zaiNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Purti qué huayuu dxi guna diaga du ni cayuí' lu ri'. Yanna racala'dxi du ganna du xi na ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Irá binni ni nuu guidxi que, cásica cani gule raqué zaqueca ni nabeza si, nisi ruyubi ca güi ca xiixa nacubi o ucaa diaga ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Oraque bizuhuaa Pablu galahui de laacabe, na: ―Binni Atenas ca', ruuya nabé runi cre tu ca bidó' stitu. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Purti ora canazaya canayuuya ra nuu cani la? laca biiya ti altar cá caadxi diidxa lú: “Para dios ni qué runibiá' du.” Ne dios ni rusisaca tu sin gunibiá' tu ca, nga pe nga canayué stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Laabe bizá' be guidxilayú ne irá ni nuu ndaani ni, ne qué ribeza be ndaani yoo rucuí binni purti laabe nga xpixuaana ibá' ne guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Cadi naquiiñe udí' nu laabe xiixa, purti gasti cayaadxa laabe. Laga laabe rudii be laanu enda nabani ne irá ni caqui'ñe nu. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","De ti binni si ulee be binni de irá raza ni nuu ndaani guidxilayú, ne gudixhe be pabiá' indaa cada raza ne paraa cueza ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Gudixhe be irá binni ndaani guidxilayú para uyubi laabe casi ñaca zixubi ná ca dede idxela ca laabe, purti cadi zitu nuu be, sínuque gaxha do' nuu be de cada tobi de laanu. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Laabe bizá' be laanu ne pur laabe nabani nu ne rizá nu. Casi na tobi de ca poeta stitu: “Za nu de Dios.” ");
INSERT INTO zaiNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ne pa za nu de laabe la? cadi zácaxa nu de oro laabe o de plata o de guie o intiica ni ruzá' binni modo na xquenda biaani'. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Chiqué bichee binni purti qué ñene, ne bi'ni Dios sica qué ñuuya'. Peru ma cayabi be irá binni de irá ladu inaba perdon laabe, ");
INSERT INTO zaiNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","purti ma gudixhe be ti dxi cuidxi be cuenta laaca'. Ma ulí be tobi hombre guni ni, ne zuni ni jneza. Bisihuinni be ulí be laa ra undisa be laa de lade gue'tu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ora bina diaga cabe bizeete Pablu enda ribani de lade gue'tu la? caadxi de laacabe bini burla, peru xcaadxi na: ―Sti tiru nda ucá' diaga du lii de ni cayuí' lu ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Para biree be ra nuu ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Peru bini cre caadxi, ne yenanda ca laabe. Lade cani bini cre que zeeda Dionisiu, tobi de cani runi junta ra Areópago que, ne ti gunaa lá Dámaris, ne xcaadxi. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Biree Pablu Atenas uyé Corinto. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ne raqué beda idxaaga be ti judíu de Ponto lá Aquila. Nacubi beda bi' ca raqué, laa ne Priscila xheela'. Biree ca Italia purti uladxi Claudio irá judíu ni nabeza Roma. Para uyé be ralidxi ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Biaana né be laaca', bini né be laaca dxiiña', purti tobi si dxiiña runi cabe, ruzá' cabe carpa. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ne irá dxi enda riziila'dxi yegüí be diidxa ndaani yu'du', ne bicuudxi be caadxi judíu ne caadxi ni cadi judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ne ora bedandá Silas ne Timoteu de Macedonia, jma pe qué ñaana dxí Pablu de ñui' stiidxa Dios. Idubi dxi cayabi be ca judíu Jesús nga Cristu ni cabeza ca que. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Peru qué niná ca nucaa diaga ca laabe ne uluu dí ca laabe. Oraque udxibi be xhaba be nezalú ca', ne rabi be laaca': ―Laatu napa tu donda pa initilú tu. Cadi naa dia' napa donda. Ne dede yanadxí ma chaa ra nuu cani cadi judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Biree be raqué uyé be ralidxi tobi hombre rusisaca Dios, lá Justu. Naca lidxi cue' yu'du que. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Bini cre ti hombre lá Crispu, naca xaíque sti yu'du que, laa ne ca binni lidxi. Uyuu ru stale binni Corinto bini cre ra bina diaga ni cayuí' Pablu que, ne uyuu nisa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ti gueela uní' né Señor laabe casi ñaca lu bacaanda', na rabi laabe: ―Cadi idxibi lu', ne cadi guiaana dxi lu de güi lu stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Purti napa stale binni ndaani guidxi ri', ne cayapa lii iruti zaga'na lii para guniná lii. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Para biaana be raqué tubiza aronda byuí' be stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Peru dxi naca Galión gobernador de Acaya uca ca judíu tobi si ne biasa ca luguiá Pablu yené ca laa ra justicia. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Na ca': ―Cusiidi hombre ri binni usisaca Dios, peru cadi casi na ley stidu. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ma ziní' Pablu peru óraque na Galión rabi ca judíu: ―Pa ñaca bichee be, bi'ni be xiixa naro'ba la? ñapa xidé nucaa diaga laatu, judíu ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Peru pa bedané tu laabe purti si qué riula'dxi tu ni cusiidi be ne pur ca xaíque stitu ne pur ley stitu la? racá laatu laguuya xi guni né tu ni. Qué ziuaa dia' lú ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ne ulee laacabe de raqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Peru óraque ucuaa cani cadi judíu Sóstenes, xaíque sti yu'du que, udiñe ca nezalú justicia. Peru qué nulabi Galión laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Biaana ru Pablu raqué xadxí. Oraque ru gudxi be ca hermanu ma che be, para biree né be Priscila ne Aquila uyé cabe Cencrea. Ne raqué bigá ique be pi'ru', ra biluxe udixe be ti promesa. De raqué ucuaa cabe barcu ze cabe Siria. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ne biuu cabe Efeso. Raqué biaana Aquila ne Priscila, peru Pablu na che Jerusalén. Laga nuu ru be raqué uyé be ra yu'du sti ca judíu, yegüí né be laaca diidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ucuá ca lú be ñaana né ru be laaca xcaadxi peru qué niná be. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Rabi be laaca': ―Ma chaa Jerusalén purti ma zeda yuba saa raqué ne naquiiñe chi utiide saa que raqué. Peru zabigueta rua' ra nuu tu pa na Dios. Para ucuaa be ti barcu biree be ze be. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Yendá be Cesarea. Raqué biete be, uyé be Jerusalén, yeugapa diuxi be ca xpinni Cristu. De raqué uyé be Antioquía. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Biaana be raqué xadxí huiini'. Oraque ru biree be uzá be irá ca guidxi sti Galacia ne Frigia. Yeuzuhuaa chaahui be ca xpinni Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ca dxi que yendá ti judíu de Alejandría ndaani guidxi Efeso, lá Apolo. Galán riní' be ne nabé riene be ni cá lu Xqui'chi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ma biziidi be stiidxa Señor ne cayuí' be ni ne gana. Jneza rusiidi be bia' nanna be de Jesús. Peru ni nanna si be nga ni bisiidi Juan Bautista ra uluu nisa binni. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Bizulú byuí' be ni ndaani yu'du sin nidxibi be, peru ora bina diaga Priscila ne Aquila ximodo cayuí' be ni, guridxi ca laabe para bisiene chaahui ca laabe stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ne ora bizeete be che be Acaya la? ucané ca hermanu que laabe. Bicaa ca ti gui'chi lú ca hermanu de raqué uchagalú ca laabe. Ne ora yendá be nabé ucané be cani ma bini cre raqué, cani ma uca Dios nacha'hui ne laa. ");
INSERT INTO zaiNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ne laca biseegu be ruaa ca judíu nezalú irá binni. Biluí' be laaca ra cá lu Xqui'chi Dios Jesús nga Cristu ni cabeza ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Laga canazá Apolo Corinto udi'di Pablu lade dani dede yendá Efeso. Raqué bidxela be caadxi xpinni Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ne rabi be laaca': ―Ñee ucuaa tu Espíritu Santu ra bini cre tu la? Para na ca': ―Nin qué lica huayuna diaga du pa nuu Espíritu Santu. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Oraque rabi be laaca': ―Xi biziidi tu para uyuu nisa tu ya'. Para na ca': ―Ni bisiidi Juan ra uluu nisa binni. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Oraque rabi be laaca': ―Uluu nisa Juan binni para ihuinni ma unaba ca perdón Dios, ne gudxi laacabe guni cre cabe stobi ni nanda laa. Ne nga nga Jesucristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ora bina diaga ca xi na be, uyuu nisa ca para ihuinni ma xpinni Cristu laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ne ora udixhe ná be luguiá ca', bidxá ladxidó' ca de Espíritu Santu. Ne uní' ca idioma ni qué niziidi ca', ne bizulú ca byuí' né ca binni stiidxa Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bia' doce ca nuu ca raqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bia' chonna beeu biaana Pablu raqué, bisiidi ndaani yu'du sin nidxibi. Byuí' né be laaca de enda runi mandar sti Dios. Biyubi be nucuudxi be laaca para ñuni cre ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Peru uyuu tu qué niná ñuni cre. Biguidxi ladxidó' ca', ne uluu dí ca stiidxa Cristu nezalú irá binni que, para bixele be de laaca'. Yené be cani ma runi cre ra yoo scuela sti tobi hombre lá Tiranno. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Raqué biaana be bisiidi be chupa iza. Ne zacá bina diaga irá binni Asia stiidxa Señor, cásica judíu zaqueca cani cadi judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ne biquiiñe Dios laabe para bi'ni stale milagru. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Purti neca bayu si stibe o tindaa lari ni ma biquiiñe be chiné ca binni que ra nuu cani huará, maca ziyanda. Ne zaqueca ca binidxaba ni caguite ique binni, laca ne ngue si rixele ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Uyuu caadxi judíu raqué canabee binidxaba ni caguite ique binni. Zácaxa ca tisi uzeete ca lá Señor Jesús zacané laaca iree ca binidxaba que. Na ca rabi ca ca binidxaba que: ―Cayabe laatu iree tu, casi ñaca ñabi Jesús ni rui' Pablu stiidxa que ni laatu. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Canayuni gadxe xiiñi Esceva ni, Esceva ti sacerdote gola sti ca judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Peru ora gudxi cabe ni ti binidxaba la? na rabi laacabe: ―Runebia'ya Jesús ne nanna tuu nga Pablu, peru laatu ya', tu laatu. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Oraque biaaxha dxa hombre caguite binidxaba ique que luguiá cabe, gudiñe laacabe ne gudixhe dxí irá cabe. Biiya si cabe ma gasti ganda guni cabe biree cabe ndaani yoo, ziuxooñe cabe xie ladi cabe, naze cabe rini. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Irá binni guidxi que gunna ni, cásica judíu zaqueca cani cadi judíu. Irá ca bidxibi ca' ne bisisaca ca Señor Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ne beeda stale de cani ma bini cre, beda ndee ruaa ca diidxa irá ni huayuni ca ni cadi jneza. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Zaqueca stale de cani runi brujería. Bedané ca libru stica para icá gui nezalú irá binni que. Ne ulee cabe cuenta pabiá' risaca cani. Bia'si bidii ni cincuenta mil moneda de plata. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Zaqué jma rusi bireeche stiidxa Señor ne bi'ni ni dxiiña ndaani ladxidó' stale binni. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Udi'di si irá nga gudixhe ique Pablu tidi Macedonia ne Acaya ne óraque ibigueta Jerusalén. Ne na be napa be xidé che be Roma ora ma uyé be Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Bisá niru gá be chupa de cani racané laabe che Macedonia, Timoteu ne Erastu. Laabe biaana ru be neza Asia. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ca dxi que uca yaya binni guidxi que pur stiidxa Señor. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Purti nuu ti plateru lá Demetriu ruzá' yu'du huiini sti diosa Diana, napa stale tu runi né laa dxiiña', ne nabé runi ganar cabe lú ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Uridxi be cani runi né laabe dxiiña que, ne ca xcaadxi plateru, rabi be laaca': ―Biche ca', laatu nanna tu galán rusaana dxiiña ri para laanu. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ne ma huayuna diaga tu na Pablu cadi dxandí dios ni ruzá' binni. Ne zacá cabee chu be stale binni, cadi rarí si sínuque casi idubi Asia. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Cadi xhiiña si nu nuu naxoo, sínuque ne xhiu'du Diana, purti ma iruti zazaala'dxi laa, ne ma iruti zusisaca Diana. Laa nda nga nadxii irá binni Asia ne dede irá binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ora bina diaga cabe xi na Demetriu, bidxiichi cabe ne uluu cabe Viva sti Diana, bidó' sti ca binni Efeso. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ne biasa irá binni guidxi que bi'ni ca bulla, unaaze ca hermanu Gayo ne Aristarco, binni Macedonia ni canazá né Pablu. Uxubi yu cabe laaca yené cabe laaca ra raca junta stícabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ucala'dxi Pablu nichuu lade cabe, peru qué niná ca hermanu. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ne laca bisenda tidxi caadxi de cani runi mandar Asia laabe cadi chi chuu be. Bisenda tidxi ca laabe purti xhamigu ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Zaqué nuu ca binni que, adxé ni na caadxi, adxé ni na xcaadxi. Raqué nuu ca dede ma birenda ca', purti casi irá ca qué ganna ca xi pur bidxiña ca raqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Oraque ulee ca judíu Alejandru de lade ca binni que ziulaa ná ca laabe dede yeuzuhuaa ca laabe nezalú ca binni que para iní' be pur laaca', para cadi na ca binni que tobi si laaca ne Pablu. Bi'ni be seña lu ca binni que nigani ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Peru ora bi'ya ca laca judíu laabe la? bicaa ca ridxi na ca': ―¡Viva Diana patrona sti ca binni Efeso! Zacá uyuu ca bia' chupa hora. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Oraque biree secretariu de guidxi que bicueeza laacabe, ne na: ―Binni Efeso ca', irá xixé binni nanna dxichi binni rarí nga rapa bidó' Diana ni biaba de ibá', ne xhiu'du'. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Iruti qué zanda iní' cadi dxandí ni. Nga runi laguuya chaahui xii nga cayuni tu. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ca hombre bedané tu ri la? qué huayuni ca gasti xhiu'du diosa Diana ne qué huaguu dí ca Diana. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Pa racala'dxi Demetriu ne cani runi né laa dxiiña', cu' xqueja tuuxa la? para nga runi nuu justicia, nuu juez. Raqué chi nduu saa ca xqueja ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Peru pa nuu ru ni racala'dxi tu la? lausaana ni para ora aca junta sti idubi guidxi. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Purti naxoo huiini nuu ni uca yanadxí ri'. Ma na cabe cayasa nu, cucá' lú nu gobiernu. Ne xi gabi nu óraque ya'. ");
INSERT INTO zaiNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ngue si uní' be, bicheeche be ca binni que. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Uyuu dxí si guidxi que, guridxi Pablu ca hermanu, bilidxe laacabe ne gudxi laacabe ma che', para biree ze Macedonia. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Uzá be irá guidxi ni nuu neza que, ne irá ra zidi'di be ziuzuhuaa chaahui be ca hermanu pur irá diidxa ni byuí' né be laaca' dede yendá be Grecia. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Biaana be raqué chonna beeu. Ma nuu be para icaa be barcu che be Siria gunna be cabeza ca judíu inaaze ca laabe. Ni bi'ni ti be la? bigueta be neza Macedonia sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Yené caadxi hermanu laabe, ra zeeda Sópater de Berea, ne Aristarco ne Segundu de Tesalónica, ne Gayo de Derbe, ne Tíquico ne Trófimo de Asia, ne Timoteu. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Uzá niru ca lú du, yendeza ca laadu Troas. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Laadu biaana ru du Filipos. Raqué biti'di du saa ra ro cabe pan sin levadura, ne lu gaayu gubidxa yeugaanda du laacabe Troas. Biaana du raqué gadxe gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ra gunda domingu que bidxiña irá ca xpinni Cristu para go ca pan casi bisaana Jesús guni ca', ne bisiidi Pablu laaca'. Gunda galaa gueela caní' ru Pablu, purti sti dxi que ma che'. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Cá gui jma biaani ra nuu cabe que, ndaani ti yoo raguionna pisu. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nuu ti hombre huiini raqué lá Eutico, zuba ra ventana. Ucuaa bacaanda laa purti xadxí caní' Pablu, ne biree yaande de raqué. Ma guti gundisa cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Oraque biete Pablu, guta gudaa gudiidxi laabe ne na rabi ca hermanu: ―Cadi idxibi tu. Ma bibani be. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Bigueta udxi'ba Pablu para undaa cabe pan gudó cabe. Biluxe si cabe bizulú uní' Pablu sti tiru dede birá gueela'. Oraque ru biree ze'. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Para biree cabe ziné cabe hombre huiini que, ne nabé nayeche biaana cabe purti bibani. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ucuaa du barcu uzá niru du lú Pablu, uyuu du Asón. Raqué uleza du laabe. Zacá biaana né du laabe purti laabe qué zie be lu nisa. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ora yendá be Asón udxi'ba be ndaani barcu ra nuu du para uyuu du Mitilene. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Biré' du Mitilene ziuu du. Sti dxi que udidi du Quío. De lu sti dxi que yendá du Samos ne biaana du Trogilio. Biré' du raqué sti dxi que yendá du Mileto. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Qué ñu' du Efeso, purti qué niná Pablu ñaana Asia xadxí. Cá ique be pa ganda chindá be Jerusalén para laní Pentecostés, saa sti ca judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Laga nuu du Mileto bisenda caa be ca hermanu gola lade ca xpinni Cristu de Efeso. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ora beeda ca rabi be laaca': ―Laatu nanna tu ximodo huazaya lade tu dede primé dxi bedandaya Asia. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Qué ñuu dxi nudxiiba naa ra cayune xhiiña Señor. Stale tiru biina ra biiya jmodo ca binni ri', ne udide stale ni nagana pur ni ucala'dxi ca judíu ñuni naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Qué nucaache gasti', sínuque byue nia laatu irá ni zacané laatu para uzuhuaa chaahui tu. Bisiide laatu ra nuu tu irá tu tobi si, ne zaqueca ra yeganna laatu ralidxi tu. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Gudxe ca judíu ne zaqueca cani cadi judíu inaba ca perdón Dios ne guni cre ca Señor Jesucristu stinu. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Yanna cayabi Espíritu Santu naa chaa Jerusalén, ne qué ganna xi cabeza naa raqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ni nanna sia' la? irá ra huayaa rabi Espíritu Santu naa zieguayuaa ne zadide ra nagana. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Peru nin tobi de ca nga qué rizaaladxe', neca pe guuti cabe naa. Xi si ricá ique la? unduuxe dxiiña ni bidii Señor Jesús naa gune'. Ne ndi nga dxiiña bidii be naa: güe nia binni ma zanda ilá ca pur enda nacha'hui sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ma nanna nin tobi de laatu, cani byue nia de enda runi mandar sti Dios, qué zuuya ru tu lua' ndaani guidxilayú ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nga runi cayabe ni laatu nagasi, ma cadi naa dia' napa donda pa initilú tu. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Purti qué nusaana naya de ñue nia laatu irá ni na Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Yanna lagapa laca laatu ne lagapa ca xpinni Cristu ni bisaana Espíritu Santu laatu gapa tu, casi rapa pastor dendxu sti'. Xpinni be laaca' purti bixhii be rini stibe pur laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Purti nanna dxi'che casi pe naa gaxha ñee, zeeda xcaadxi zacala'dxi uchiá ca xpinni Cristu casi ruxuuxe gueu dendxu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ne dede lade ca tu ziuu tu guiasa usiguii ca xcaadxi para chi nanda laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nga runi cayabe laatu lagataná ne laguietenala'dxi' chonna iza dede biete nisa lua bisiene cada tobi de laatu ridxí ne huaxhinni. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Yanna la? hermanu ca'. Rusaana laatu lu ná Dios. Ne ma nanna tu napa tu stiidxa be ni rabi laatu pabiá' nacha'hui be ne laatu. Zacané ni laatu para uzuhuaa chaahui tu. Ne zudii be laatu ni ma naguixhe chaahui be para icaa ca xpinni be. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Qué nicá lua' plata nin oro nin xhaba stobi. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Sínuque laatu nanna tu bine dxiiña para bibane nia cani cayacané naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ma bilué laatu de irá modo naquiiñe guni nu dxiiña para acané nu cani caquiiñe ni. Laguietenala'dxi xi na Señor Jesús: “Jma nayeche ni rudii que ni ricaa.” ");
INSERT INTO zaiNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Biluxe si uní' be nga la? bizuxibi né be irá ca', uní' né be Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ne óraque biina irá ca' ne udiidxi dxiichi ca laabe, gudó ca bixidu cue' xhaga be. ");
INSERT INTO zaiNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ucaná ladxidó' ca purti gudxi be laaca ma qué zuuya ru ca laabe. Ne óraque ucuaa ca laabe yeudxiiba ca laabe lu barcu. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Raqué undaa saa né du ca hermanu. Udxiba du lu barcu biré' du ziuu du. Dede Cos yeguiaana dxí du, ne sti dxi que uyuu du Rodas. Biré' du Rodas uyuu du Pátara. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Raqué nuu ti barcu che Fenicia, para udxiba du lú ni, biré' du ziuu du. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Neza ziuu du Siria bidu'ya du isla Chipre, biaana ni ladu biga'. Yeguiaana dxí du Tiro, ti guidxi sti Siria, purti raqué nga rundaate barcu que irá ni né. Ne raqué biete du. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Biyubi du ra nuu ca xpinni Cristu ne biaana né du laaca gadxe gubidxa. Ne pur ni gudxi Espíritu Santu laacabe, gudxi cabe Pablu cadi che Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Bizaa si gadxe gubidxa que biré' du ziuu du. Yeuzuhuaa ca hermanu que laadu neza, laaca ne xheela ca ne ca xiiñi ca', dede biré' du de ndaani guidxi que. Ne bizuxibi du lu yuxi uriá nisa, uní né du Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Oraque gudiidxi saa du, para udxiba du lu barcu. Laacabe bigueta cabe zibí' cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Biré' du Tiro uyuu du Tolemaida, ne raqué biluxe viaje stidu lu nisa. Yeganna du ca hermanu de raqué ne biaana né du laaca ti dxi. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Sti dxi que biree né Pablu laadu, uyuu du Cesarea. Yeguiete du ralidxi Felipe, tobi de gadxe diácono ni ulí cabe dxi ulí cabe Esteban que. Riree be rigüí be stiidxa Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Napa be tapa xiñi dxaapa be ca'ru ichaganá'. Rui' né ca binni ni rabi Dios laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Biaana du raqué chupa chonna gubidxa ne raqué nuu du beeda ti profeta de Judea lá Agabo. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ora beda ganna be laadu ucuaa be cinturón sti Pablu. Bindiibi be ná be ne ñee be, ne na be: ―Ndi nga ni na Espíritu Santu. Sicarí zundiibi cabe xpixuaana cinturón ri Jerusalén ne zutiidi ca judíu laa lu ná cani cadi judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ora bina diaga du xi na be la? irá du ucuá du lú Pablu cadi che Jerusalén, laadu ne ca binni raqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Peru na rabi laadu: ―Xii ndi raca tu ruuna tu, cayuniná tu ladxiduá'. Ma nuaa listu cadi para íliibe sia', sínuque ne para gate Jerusalén pur Señor Jesús. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Bidu'ya si du qué ñanda nucuudxi du laabe la? uyú' dxí du ne rabi du laabe: ―Gaca ni na Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Udi'di si nga, gudixhe chaahui du stidu para uyuu du Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Yené caadxi hermanu de Cesarea laadu. Lade cabe zeeda tobi de Chipre lá Mnasón, tobi ni ma xadxí runi cre Cristu. Ralidxi be yeguiete du. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ora yendá du Jerusalén bichagalú ca hermanu que laadu ne stale enda nayeche'. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Sti dxi que yené Pablu laadu yeganna du Jacobo. Raqué nuu irá ca hermanu gola sti ca xpinni Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Biluxe si bigapa diuxi be laaca', byuí' né be laaca irá modo biquiiñe Dios laabe lade cani cadi judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Irá ca bisisaca ca Dios ora gunna ca ni, ne na ca rabi ca laabe: ―Peru ma nannu hermanu, stale judíu nuu rarí ni ma runi cre, ne nabé rinanda ca ni na ley sti Moisés. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Huayuí' né cabe laaca de lii, na cabe ra'bu ca judíu ni nuu lade cani cadi judíu cadi chi nanda ca ley que, cadi cu' ca seña sti Dios ca xiiñi ca', ne ma cadi chi nanda ca ca costumbre sti ca judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Yanna xi guni nu. Purti zadxiña irá cabe ora ganna cabe beedu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nannu xi gu'nu la? Nuu tapa hermanu lade du mayaca iluxe quixe ca ti promesa. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Yené laacabe ra yu'du ro' ne irá tu laguni casi cá lu ley, ne gudixe irá ni iquiiñe cabe raqué. Oraque ma zanda igá ique cabe. Zacá zanna ca hermanu judíu lii laca ru'nu ni na ley, ne cadi dxandí ni caní' binni de lii ca. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ne de cani cadi judíu ni ma bini cre ca la? ma bicá' du gui'chi lú ca', gudxi du laaca cadi izaala'dxi ca irá nga. Sínuque ni naquiiñe si guni ca la? cadi go ca ni ma gu'ta lu bidó', nin rini, nin tutiica mani ixii yanni, ne cadi chu' né ca ni cadi xheela ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Para ucuaa Pablu idapa hombre que, ne sti dxi que yeguni né laacabe casi cá lu ley gaca'. Ne óraque biuu ndaani yu'du ro' yetidxi sacerdote padxí iluxe ni cayuni cabe que para chiné cada tobi ni usiga'de Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ma para izaa gadxe gubidxa de ni cayuni cabe que biiya caadxi judíu de Asia nuu be ndaani yu'du ro', para bini yaya ca ca binni que ne unaaze ca laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bicaa ca ridxi, na ca': ―Binni Israel ca', latá' acané tu igaa hombre ri'. Laabe nga canausiidi be binni cadi jneza runi ca judíu ne cadi guni ca ni na ley stinu, ne qué risaca yu'du ro' ri'. Ne cadi nga si, sínuque ma biguu be ni cadi judíu ndaani yu'du ri', ne zacá bini yuudxu be yu'du sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Uní' ca zaqué purti biiya ca canazá né be Trófimo, binni Efeso, ne zácaxa ca biuu né be laa ndaani yu'du ro'. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Biasa nda irá binni guidxi que unaaze ca laabe zixubi yu ca laabe dede ulee ca laabe ndaani yu'du que ne biseegu ca' ra puerta'. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ucala'dxi ca ñuuti ca laabe peru uyuu tu yetidxi xaíque sti ca soldadu cayaca yaya irá binni Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Para ucuaa ca soldadu stiu', ne caadxi capitán, ziuxooñe ca', yendá ca ra rí ca binni que. Peru ora bi'ya ca binni que laacabe biaana dxí ca de niguiñe ca Pablu. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Oraque bidxiña xaíque que unaaze laabe ne bicaa ca soldadu undiibi ca laabe chupa cadena. Ne unaba diidxa tu laabe ne xi bi'ni be. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Peru adxé adxé ni na ca binni que. Tobi na ndi', stobi na ndica'. Ni bi'ni ti xaíque que, biseenda laabe ra cuartel, purti qué ñanda ñene xi na ca binni que pur irá ruidu cayuni ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ora yendá cabe ñee escalera para nigui'ba cabe ñuu cabe ndaani cuartel que la? undani ca soldadu laabe purti ucala'dxi ca binni que nuruuxha laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Nanda irá binni que laacabe zeeda ucaa ridxi: ¡Gati be! ");
INSERT INTO zaiNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ma chi nduu cabe laabe ndaani cuartel que, rabi be xaíque que: ―Zanda inié xiixa la? Oraque na xaíque que: ―Riníu' griegu pue la? ");
INSERT INTO zaiNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Entonce cadi dxa egipciu bicaa lú gobiernu que lii pue la? dxa ni yené tapa mil bandidu ndaani gui'xhi que. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Oraque na Pablu: ―Judíu naa. Gule Tarso. Naa nga binni de ti guidxi ni risaca lade ca guidxi sti Cilicia. Ne rinaba lii udiiu lugar naa inié nia ca binni ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Oraque na xaíque que zaa iní' be. Para bizuhuaa be lu escalera que, bi'ni be seña lu ca binni que igani ca'. Dxí do' uyuu ca óraque para bizulú be uní' be hebreu, na be: ");
INSERT INTO zaiNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","―Biche ne bixhoze ca', laucaa diaga, chi güe nia laatu xi cayune'. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ne ora bina diaga ca caní' be hebreu, stiidxa ca la? jma rusi dxí do' uyuu ca'. Para na be: ");
INSERT INTO zaiNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","―Naa la? judíu naa. Gule Tarso, ti guidxi sti Cilicia, peru biniise ndaani guidxi ri'. Bisiidi Gamaliel naa casi pe na ley sti ca bixhoze gola nu. Biyube gune ni na Dios de idubi ladxiduá' casi cuyubi tu guni tu yanna. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Uzabe nanda cani runi cre Jesús para guute laaca'. Unaaze hombre ne gunaa, biseguayuaa. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Sacerdote gola ne ca xaíque sti guidxi, laaca ñanda ñabi ca laatu dxandí ni, purti laaca bidii ca gui'chi naa yeniá Damasco para inaaze cani nuu raqué, guenda nia laaca Jerusalén para acaná ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ne sicarí nga uca ra ziaa Damasco. Mayaca chindaya raqué, bia' galaa dxi mala bizaani ti biaani de ibá' naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Biaba layú ne bina dia'ga caní' tuuxa: “Saulo, Saulo, xiñee canazabi nanda lu naa.” ");
INSERT INTO zaiNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Oraque rabe': “Tu lii, Señor.” Para na be: “Naa nga Jesús de Nazaret ni canazabi nanda lu ca.” ");
INSERT INTO zaiNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Biiya cani ziniá que biaani que ne bidxibi ca', peru qué ñuna diaga ca xi gudxi be naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Oraque rabe': “Xi gune, Señor.” Para na Señor rabi naa: “Biasa uyé Damasco, raqué zabi cabe lii xi irá ma nexhe gu'nu'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nabé bichuundu xtuxhu biaani que lua', ma qué ñanda ñuuya'. Para unaaze cani ziniá que naya', yesaana ca naa Damasco. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Nuu tobi hombre raqué lá Ananías, nabé rinanda ni na ley sti Moisés ne irá judíu de guidxi que ruzeete pabiá' nacha'hui be. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Uyé be ra nuaa ne bidxiña be, na be: “Hermanu Saulo, ma chi iná lu sti tiru.” Oraque bixele lua', biiya laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ne na be rabi be naa: “Ma gulí Dios sti ca bixhoze gola nu lii para usiene lii xi racala'dxi' ne para gu'yu piou' Xiiñi be ni runi ni na be, ne iní' né lii. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Purti chi güi neu irá binni stiidxa Xiiñi be que. Zui' neu laaca irá ni bi'ya lu ne ni bina diaga lu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Yanna xi cabeza lu'. Biasa, uyuu nisa ne bini cre Jesús ne unaba laa cuee xpecadu lu'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ora bigueta Jerusalén uyaa ndaani yu'du ro', yenié nia Dios. Ne casi ñaca canié xcaanda', ");
INSERT INTO zaiNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","biiya Señor, na rabi naa: “Guiuba biree de Jerusalén, purti qué zuni cre cabe ra güi neu laacabe stiidxa'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Para rabe laabe: “Señor, nanna cabe uzaya irá yu'du', yendee cani runi cre lii. Biseguayuaa laaca ne gudiñe laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ne dxi biiti cabe Esteban ni canayuí' stiidxa lu que, ne naa zuhuaa raqué, rabe jneza ni cayuni cabe que. Dede gupa xhaba cani biiti laabe que.” ");
INSERT INTO zaiNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Peru na be rabi be naa: “Uyé, purti chi useenda lii zitu, ra nuu cani cadi judíu.” ");
INSERT INTO zaiNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Bia' de racá si bicaa diaga ca binni que Pablu. Bizulú ca bicaa ca ridxi: ―¡Gati be! ¡Qué iquiiñe di be para ibani be! ");
INSERT INTO zaiNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Qué ñaana dxí ca de cucaa ca ridxi ne undisa ca xhaba ca lu bi, ne bichiacha ca yu dé. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Biiya si xaíque que zaqué nuu ca binni que la? bini mandar chu' be ndaani cuartel ne idiiñe be para cuee ruaa be diidxa xiñee cucaa ca binni que ridxi zaqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Peru biluxe si bindiibi cabe laabe, na be rabi be ti capitán nuu raqué: ―Ñee cadi na gobiernu stitu cadi jneza quiñe tu ti romanu sin ihuinni xi bi'ni la? ");
INSERT INTO zaiNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ora gunna capitán que ni la? yetidxi xaíque que, na: ―Biiya gá xii nga chi gunu', purti romanu hombre ca. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Para uyé xaíque que ra nuu be, ne rabi laabe: ―Ñee dxandí romanu lii la? ―Dxandí, rabi be laa. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Oraque na xaíque que: ―Naa gudixe stale bidxichi para naca romanu. Para rabi be laa: ―Peru naa lú ni gule'. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Oraqueca bixele cani chi tiñe laabe que, bisaana ca laabe. Dede xaíque que, ora gunna romanu laabe bidxibi, bindiibi si laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Sti dxi que, racala'dxi xaíque que ganna xiñee caguu ca judíu xqueja be. Para bixhedxe laabe ne bisenda caa ca xaíque sti ca sacerdote ne irá ca justicia, ne gulee laabe, bichiña laabe ra nuu ca justicia que. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Oraque biiya dxí be ca justicia ne rabi be laaca': ―Biche ca', dede nagasi huazaya jneza, ne nayá ladxiduá' nezalú Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","―Lacapa ruaa be racá, na Ananías sacerdote gola, rabi cani nuu gaxha de laabe que. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Para rabi be laa: ―Lii ru'nu siou' lii nacha'hui peru cadi dxandí ni. Laca zusaba ná Dios lii. Zubu racá para udxiibu donda ique pa bichee nia ley. Peru laga lii cuchee neu ley purti cayuni mandar lu capa cabe ruaa'. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Oraque na cani nuu raqué rabi laabe: ―Zacá nga icabi ruaa lu sacerdote gola sti Dios la? ");
INSERT INTO zaiNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Para rabi be laaca': ―Biche ca', pa ñanna sacerdote gola laabe la? qué ninié zacá, purti cá lu Xqui'chi Dios: “Cadi cu' dí lu ni naca xaíque ndaani xquidxi lu'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ne ora bi'ya be nuu caadxi saduceu raqué ne caadxi fariseu la? uní' be reciu nezalú justicia que, na be: ―Biche ca', naa fariseu naa, xiiñi fariseu. Caguu cabe xqueja purti si rune cre zabani gue'tu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ra uní' be zaqué uyuu dinde ca fariseu ne ca saduceu ne undaa saa ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Purti ca saduceu na qué zabani gue'tu' ne cadi dxandí nuu ángel nin espíritu. Peru ca fariseu na dxandí nuu irá ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Oraque uca ti ruidu raqué ne biasa caadxi maistru de ley ni za lade ca fariseu, na ca': ―Qué ridxela du gasti ni cadi jneza luguiá hombre ri'. Laga pa huandí espíritu o ángel huaní' né laabe ya'. Cadi galán ucá' lú nu Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Biiya si xaíque que jma rusi zirooba enda ridinde que, bisenda caa soldadu para cuee laabe lu ná cabe, cu' laabe ndaani cuartel, purti cadxibi gueda uxuuxe cabe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Sti gueela que bizuhuaa Señor lú be na rabi laabe: ―Cadi idxibi lu, Pablu. Cásica byuí' lu stiidxa Jerusalén zacaca naquiiñe güi lu ni Roma. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Sti dxi que uní' stiidxa caadxi judíu na ca': ―Gunidé Dios laanu pa idó' no ne idé' nu ante guuti nu Pablu. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Jma de cuarenta cabe uní' stiidxa cabe zacá. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Uyé cabe ra nuu ca xaíque sti ca sacerdote ne ca xaíque sti guidxi, ne rabi cabe laaca': ―Ma uní stiidxa du gunidé Dios laadu pa idó' do ante guuti du Pablu. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Laatu lausenda tidxi xaíque sti ca soldadu useenda laabe ra nuu tu casi ñaca racala'dxi tu ganna tu jma de laabe. Laadu ma cabeza du laabe neza para guuti du laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Peru beda ganda diaga xiiñi ti biza'na be ni, para yetidxi ni laabe ra cuartel. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Oraque guridxi be ti capitán rabi be laa: ―Yené hombre huiini ri ra nuu xaíque, purti napa be xiixa gabi be laa. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Para ucuaa Capitán que hombre huiini que yené ra nuu xaíque, na: ―Guridxi dxa presu lá Pablu que naa. Unaba gueda nia hombre huiini ri ra nuu lu', purti napa xiixa gabi lii. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Para unaaze xaíque que ná hombre huiini que, biree né laa ti ladu, ne na: ―Xii nga napu ga'bu naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Para rabi laabe: ―Ma uní' stiidxa ca judíu inaba ca lii chinéu Pablu ra nuu justicia ixí', casi ñaca racala'dxi ca ganna ca jma de laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Peru cadi guni cre lu laacabe, purti jma de cuarenta cabe cabeza cabe laabe neza. Ma uní' stiidxa cabe gunidé Dios laacabe pa go cabe o gue cabe ante guuti cabe laabe. Ma cabeza si cabe xi na lu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Oraque na xaíque que rabi hombre huiini que: ―Uyé yanna ne qué chi tidxu iruti pa ma beda tidxu ni naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Para guridxi xaíque que chupa capitán ne bini mandar cu' cabe listu chupa gayuaa soldadu ne setenta ni dxi'ba mani' ne chupa gayuaa ni naaze lanza, para che ca Cesarea huaxhinni que bia' las nueve. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ne guni chaahui ca mani quiba Pablu. Chi saana ca laabe ra nuu gobernador Félix, ne gu'ya ca qué izaaca be gasti neza. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ne bi'ni ti carta. Sicarí na ni: ");
INSERT INTO zaiNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Estimado gobernador Félix, lu gui'chi ri cugapa diu'xe lii. Naa nga Claudio Lisias. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Unaaze ca judíu hombre ri', ucala'dxi ca ñuuti ca laabe. Peru ora gunna romanu laabe la? yeniá soldadu yegaxha laabe lu ná ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Yeniá laabe ra nuu justicia stica', purti racaladxe ganna xiñee caguu ca xqueja be. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ne biiya cayuu xqueja be pur ni na ley stícabe, peru qué huayuni be gasti para gati be, nin para guieguyoo be. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ne ora gunna naguixhe ca judíu guuti laabe la? biseenda ca' laabe ra nuu lu'. Ne ma gudxe cani caguu xqueja be ca che ca ra nuu lu' para gabi ca lii xii nga bi'ni be. Sicarú guiaanu'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Bixhinni si ucuaa ca soldadu que Pablu casi gudxi xaíque que laaca guni ca'. Yesaana ca laabe Antípatris. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Sti dxi que bigueta ca soldadu que ra cuartel. Peru cani dxi'ba mani que la? yené ca laabe dede Cesarea. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ne ora yendá cabe Cesarea bidii cabe gui'chi que gobernador ne bisaana cabe laabe lu ná'. ");
INSERT INTO zaiNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Biluxe biinda si gobernador gui'chi que, unaba diidxa padé laabe. Ne ora gunna de Cilicia laabe la? ");
INSERT INTO zaiNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","na rabi laabe: ―Zucaa dia'ga lii ora gueeda cani gueda nduu xqueja lu'. Ne óraque bini mandar guiaapa be ndaani xpalaciu Herodes. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Xcaayu gubidxa de ngue uyé Ananías sacerdote gola, laa ne xcaadxi xaíque sti ca judíu ne ti abogadu lá Tértulu. Ye tixhe ca xqueja Pablu lu gobernador que. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Para bisenda caa cabe Pablu, ne óraque bizulú Tértulu caguu xqueja be, na: ―Señor gobernador Félix, pur lii nuu dxí xquidxi du, ne stale ni galán cayu'nu ndaani xquidxi du purti nuu xpiaani lu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Diuxquixe lii, señor Félix, saca cayu'nu irá nga irá ladu. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Peru para cadi cuee du xhiiña lu la? rinaba lii gu'nu favor ucaa diaga lu laadu ti ratu huiini si. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Bidu'ya du nuu hombre ri casi ti enda huará lade ca judíu. Canazá be idubi guidxilayú canautinde be laaca'. Naca be xaíque sti ca xpinni Jesús de Nazaret que. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ne laca ucala'dxi be ñuni yuudxu be yu'du ro' stidu peru una'ze du laabe ne ucala'dxi du nudxi'ba du donda ique be casi na ley stidu. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Peru biseenda Lisias caadxi soldadu yegaxha laabe lu ná du. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ne biseenda cani caguu xqueja be gueeda ra nuu lu'. Yanna lii zanda caañe lu laabe para gannu xiñee cagú' du xqueja be. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ca judíu ni nuu raqué na ca dxandí irá ni na Tértulu que. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Oraque bi'ni gobernador que seña Pablu iní'. Para na Pablu: ―Cayeche zanda inié nezalú lu xi huayune', purti nanna ma xadxí zuba lu de xaíque sti guidxi ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Deru raca doce dia de yendaya Jerusalén ziusisaca Dios. Zanda inaba diidxu pa cadi dxandí ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Qué nindá cabe naa cadinde diidxa nia tuuxa, ne cadi cayune yaya binni, nin ndaani yu'du ro' ne nin ndaani yu'du huiini', nin ndaani guidxi que. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ne qué zanda uluí' cabe lii dxandí ni cugaani cabe luguia'ya ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Peru ndi huaxa dxandí': rusisaca Dios sti ca bixhoze gola du, peru modo gudixhe be gusisaca nu laabe yanna. Nga nga na cabe neza ni cadi dxandí ca. Peru laca rune cre irá ni bicaa Moisés ne ni bicaa ca profeta. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Naa rune cre zusibani Dios gue'tu', cásica ni nacha'hui zaqueca ni cadi nacha'hui'. Ne nga ca runi cre cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nga runi ruyube cadi uchee nia Dios ne cadi uchee nia binni. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Xadxí huiini uzaya xquidxi binni ne óraque bigueta xquidxe para udiee guna ne para udiee ofrenda Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ngue nga cayune', nuaa ndaani yu'du ro', ma biluxe bine ni cá lu ley stidu guni du. Raqué nuaa ora bi'ya caadxi judíu de Asia naa. Cadi lade stale binni nuaa', ne cadi cayune yaya binni. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Pa na cabe bine xiixa la? xiñee ca ngue qué ñeeda nduu xqueja ya'. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Peru laca zanda iní' cani nuu rarí pa bidxela ca xiixa donda luguia'ya ra zuhuaa nezalú ca justicia. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ni bine tia' la? bicaa ridxi lade cabe gudxe laacabe cudxiiba cabe donda ique purti rune cre zabani gue'tu'. Ne zándaca nga nga laani. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Maca riene Félix xii nga evangeliu, para na: ―Guiaana gá ni de ora gueeda Lisias. Oraque gabe laatu xi gaca xa de laani. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ne gudxi be caadxi soldadu gapa Pablu peru cadi cuee ca laa de guni ni racala'dxi', ne udii ca lugar guiuu ca xhamigu gu'ya laa. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Xhupa xhonna gubidxa de ngue bedané Félix Drusila xheela'. Judía xheela be que, ne guridxi be Pablu para güi né laacabe ximodo runi cre binni Jesucristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Peru ora beda uzeete Pablu naquiiñe sa binni jneza ne cadi guni ni na ique, ne ziuu dxi cuidxi Dios cuenta binni la? bidxibi be ne na be: ―Bia' cá si. Guyé yanna, naa ma cuidxe lii ora gapa sti lugar. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ne laca cabeza be pa nudii Pablu vueltu para nundaa be laa. Nga runi gatigá ma cabidxi be laa iní' né laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Peru lu chupa iza de ngue beda guiasa Félix, gurí Poncio Festo. Ne qué nundaa Félix Pablu purti racala'dxi chu' ca judíu pur laa. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Chonna gubidxa de zuba Festo biree de Cesarea, uyé Jerusalén. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ora yendá raqué bidxiña ca xaíque sti ca sacerdote ne xcaadxi ni napa diidxa lade ca judíu, yenduu ca xqueja Pablu ra nuu be. Unaba ca laabe, ");
INSERT INTO zaiNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","na ca guni be ti favor laaca', indete be Pablu Jerusalén. Peru maca gudixhe chaahui ca cueza ca Pablu neza, guuti ca laa. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Peru rabi be laaca yeguyoo Pablu Cesarea ne mayaca ibigueta be raqué, ");
INSERT INTO zaiNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ne zanda chiné caadxi de cani runi mandar lade ca laabe, ne raqué cu' ca xqueja Pablu pa bi'ni xiixa. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Biaana be raqué bia' xhono o chii gubidxa si para bigueta be Cesarea. Sti dxi que gurí be jlugar be ne guridxi be Pablu. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ora bidxiña Pablu, gurí zisi irá judíu ni beeda de Jerusalén que laa. Cugaani ca stale donda naro'ba luguiá peru qué ñanda nusihuinni ca dxandí ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Oraque bizulú Pablu gudxi laacabe cadi dxandí ni cugaani cabe luguiá que, na: ―Qué huachee nia ley sti ca judíu nin sti César ne qué huayune gasti ndaani yu'du ro'. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Peru racala'dxi Festo guieche né ca judíu laa para na rabi Pablu: ―Ñee racala'dxu cheu' Jerusalén para quixhe cabe xqueja lu raqué la? Ne raqué guuya pa napu donda o pa co'. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Peru na Pablu: ―Zuhuaa lu ná Cesár. Rarí nga gata xqueja', purti qué huachee nia ca judíu. Lii ca nannu ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Pa huayune xiixa cadi jneza ne naquiiñe gate la? zaa gate'. Peru pa cadi dxandí ni cugaani cabe luguia'ya ri la? iruti gapa xidé utiidi naa lu ná cabe. Rinaba utiidi lu naa lu ná César. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Oraque uní' né Festo ca hombre nuu xpiaani ni racané laa, para na rabi Pablu: ―Ra nuu César unaba lu cheu' la? yanna ma cheu' ra nuu César. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Udi'di xhupa xhonna gubidxa uyé rey Agripa ne Berenice, yeizaca ca Festo. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bindaa huiini cabe raqué, ngue runi gunda byuí' né Festo laacabe stiidxa Pablu, na: ―Bisaana Félix ti hombre rarí yeguyoo. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ne dxi guyaa Jerusalén bidxiña ca xaíque sti ca sacerdote ne xcaadxi xaíque sti ca judíu, byuí' né ca naa stiidxa be ne unaba ca useenda guute laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Peru rabe laaca cadi zacá di runi ca romanu, sínuque ribidxi nu ni cayuu xqueja que nezalú cani caguu xqueja para iní' pa dxandí ni na cabe que o pa co'. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Nga runi ora beeda irá cabe rarí', qué nibeza nidi'di stale dxi, sínuque sti dxi queca gurié ne guridxe Pablu. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Zaca naa nuzeete cabe bi'ni be xiixa naro'ba'. Peru cadi nga di nga laani, ");
INSERT INTO zaiNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Sínuque cadinde né cabe laabe pur ni runi cre cabe ne pur ti gue'tu lá Jesús, ti Pablu na nabani ru be. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ne cumu qué ganna xi gune nia ni la? unaba diidxa laabe pa racala'dxi be che be Jerusalén ne raqué gaca chaahui ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Peru unaba be zaa yeguyoo be laga si che be ra nuu César. Ngue runi bisaana laabe yeguyoo be laga si ganda useenda laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Oraque na Agripa: ―Naa laca racaladxe ucaa diaga laabe. Para na Festo: ―Ixí ca ucaa dia'gu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Sti dxi que bizuchaahui rey Agripa ne Berenice, biuu ca ndaani yoo ro' ra ritixhe binni queja lu Festo. Biuu né ca ca xaíque sti ca soldadu ne ca hombre napa diidxa ndaani guidxi que, ne irá binni cusisaca laaca'. Para bisenda caa Festo Pablu. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Oraque na Festo: ―Señor rey Agripa ne irá tu cani nuu rarí'. Chi güe nia laatu stiidxa hombre zuhuaa rarí'. Huaguu ca judíu xqueja be, cásica Jerusalén, zaqueca rarí'. Ne cadi cayaana dxí ca de inaba ca gati be. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Peru qué idxela dia' gasti donda luguiá be para gati be. Ne chi useenda laabe ra nuu Augustu César, purti nga unaba be. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Peru qué idxela dia' xi ucaa lu xaíque stinne'. Nga runi bedaniá laabe ra nuu tu ne jma rusi ra nuu lu', rey Agripa, ti ora ma udaañe nu laabe la? ma ganda gapa xi ucaa'. ");
INSERT INTO zaiNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Purti ruluí' enda huati si useenda tuuxa ra nuu César sin gucaa xiñee yeguyoo. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Oraque na Agripa rabi Pablu: ―Pa napu xi iní' lu de irá ni na cabe ca la? ma zanda iní' lu'. Para undisa ná Pablu ne bizulú na: ");
INSERT INTO zaiNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","―Señor rey Agripa, cayeche zuhuaa lú lu yanadxí para inié xi pe huayune de ni cugaani ca judíu luguia'ya ca, ");
INSERT INTO zaiNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","jma rusi purti lii riene lu modo nabani ca judíu ne irá ni ricaa yu cabe lade cabe. Nga runi rinaba lii cadi ixhacala'dxi lu ucaa diaga lu naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Irá ca judíu nanna ximodo uzaya ndaani xquidxe ne ndaani guidxi Jerusalén, dede dxi nahuiine'. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Laacabe nanna dxichi cabe, ne ñanda niní' cabe pa ñacala'dxi cabe, dede dxi nahuiine' fariseu naa. Ne ca fariseu nga jma rinanda ley sti ca judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ne yanna nuaa rarí cudxiiba cabe donda ique purti rune cre zadxiña dxi usibani Dios gue'tu casi bidii stiidxa ca bixhoze gola du. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Irá ni za de idubi doce xiiñi Israel cabeza idxiña dxi que. Nga runi cadi cusaana dxí ca de usisaca ca Dios ridxí ne huaxhinni. Ne pur nga ca caguu ca judíu xqueja', rey Agripa. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Laga laatu ya', xi na tu. Ñee na tu qué zanda usibani Dios gue'tu la? ");
INSERT INTO zaiNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Zacaca bine chiqué, rabe jneza cayune', cuyube gune irá ni ganda para uniteluá' stiidxa Jesús de Nazaret. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Zacá bine Jerusalén. Ne stiidxa ca xaíque sti ca sacerdote biseguayuaa stale xpinni be. Ne ora biiti cabe laaca', ne naa unié zaa gati ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Stale tiru bine na'ya laaca para nusaana ca ni runi cre ca'. Zacá bine irá ca ra yu'du', ne tantu cadxiiche nia laaca dede uzabe nanda laaca xquidxi binni. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Nga ca cá ique gune biree ziaa Damasco. Ziniá xqui'chi ca xaíque sti ca sacerdote. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Guca ni bia' galaa dxi, señor rey, ziaa neza, mala biiya ti biaani de ibá' jma ruzaani que gubidxa. Ne bizaani ni laadu, naa ne cani ziniá que. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Irá du biaba du layú, ne óraque bina dia'ga caní' tuuxa diidxa hebreu na: “Saulo, Saulo, xiñee canazabi nanda lu naa. Cayuniná lu laca lii casi runi buey ora riguu ñee punta puya.” ");
INSERT INTO zaiNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Oraque rabe': “Tu lii ya', Señor.” Para na Señor: “Naa nga Jesús ni canazabi nanda lu ca. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Biasa bizuhuaa. Unié nia lii para gu'nu xhiiña', para güi lu irá ni cayuuya lu ri', ne ni chi ulué rua' lii. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Zula'ya lii lu ná ca binni xquidxi lu' ne lu ná cani cadi judíu. Chi useenda lii ra nuu ca ");
INSERT INTO zaiNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","para güi neu laaca xii nga ni dxandí', ti ixele xquenda biaani ca ne usaana ca irá enda huati stica', uyubi ca xii nga jneza. Ne cadi chi nanda ca ni na binidxaba' sínuque ni na Dios, ne guni cre ca naa, ti gaca perdonar ni huachee ca' ne icaa ca ni ma gudixhe Dios gudii cani ma biá ladxidó'.” ");
INSERT INTO zaiNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Zacá nga laani, Señor rey Agripa, bizuuba stiidxa ni uní' né naa de ibá' que. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ne casi bizuluá' byue nia ni ca binni Damasco. Gudxe laaca inaba ca perdón Dios, udxii lú ca jneza be ne ibani ca jneza ti ihuinni ma adxé laaca'. De raqué biree yegüé ni Jerusalén ne idubi Judea ne lade cani cadi judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Pur nga unaaze ca judíu naa ndaani yu'du ro', ucala'dxi ca ñuuti ca naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Peru huayacané Dios naa, nga runi dede nagasi du' cayué stiidxa'. Ne cayué nia ni ni risaca ne ni qué risaca. Irá ni canié ri' maca bicaa ca profeta ne Moisés chi gaca cani. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ne ndi nga ni bicaa cabe que: napa Cristu xidé gacaná dede gati'. Peru nirudó' laa ibani de lade gue'tu ne zui' né binni modo ilá, cásica binni laadu zaqueca binni sti guidxi. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Zacá caní' Pablu para ihuinni gasti donda luguiá' ora uní' Festo reciu na: ―Cayaca i'cu, Pablu. Tantu huayuunda lu de ma ze xpiaani lu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Para na Pablu: ―Co', señor Festo. Cadi cayaca di ique', sínuque cayué diidxa jneza, ne dxandí ni cayabe laatu ca. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Qué ridxibe inié ni purti rarí nuu rey Agripa, nanna dxandí ni. Nanna dxi'che gunna be guca ni, purti cadi naga'chi guca ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Runi cre lu ca profeta la? rey Agripa. Nanna runi cre lu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Para na Agripa: ―Xcaadxi si ma ñu'nu naa xpinni Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Oraque na Pablu: ―Pa xcaadxi si o pa riaadxa ru', peru tila na Dios cadi lii siou' sínuque ne irá cani cucaa diaga naa ri', gueda gaca ca casi naa, casi rune cre, cadi casi caya cadena ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Casi biluxe uní' Pablu biasa rey Agripa ne Festo ne Berenice ne cani zuba né laaca raqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Ne ora biree ca na ca': ―Qué huayuni di hombre ri gasti para gati', nin para guieguyoo. ");
INSERT INTO zaiNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ne na Agripa rabi Festo: ―Ñanda niree be pa ñaca qué ninaba be ñe be ra nuu César. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ne ora ma gudixhe cabe che Pablu Italia la? bisigapa cabe laa ne xcaadxi presu ti capitán lá Juliu, ni naca xaíque sti batallón sti Augustu César. Ne naa nuaa lade cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Laca nuu Aristarco, binni Tesalónica de Macedonia. Irá du udxiba du ndaani ti barcu de Adramitio ni chi iree che irá puertu sti Asia. Biré' du ziuu du. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Sti dxi que yendá du Sidón. Nacha'hui guca Juliu ne Pablu, bidii lugar yeganna be ca xhamigu be para udii ca ni caquiiñe be. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Biré' du Sidón udidi du Isla Chipre. Tantu cudxigueta bi laadu la? biyubi du ladu que purti qué riguiñe bi. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Lu nisa que ziuu du udidi du Cilicia ne Panfilia dede yendá du Mira, ti guidxi sti Licia. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Raqué bidxela capitán que ti barcu de Alejandría ni che Italia. Para bidxiiba laadu lú ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Bindá' du ne bidii dxiiña laadu para yendá du gaxha Gnido purti cudxigueta bi laadu. Nga runi biyubi du neza huaxié' rinaaze bi ra udidi du isla Creta. Neza que riaana guidxi Salmón. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ne stale dxiiña uzá du gaxha de isla que dede yendá du ti lugar lá Buenos Puertos, gaxha ti guidxi lá Lasea. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nabé ma bindá' du neza ne ma bidxiña dxi uzulú tiempu nanda, ma naxoo sa binni lu nisa. Ngue runi na Pablu rabi laacabe: ");
INSERT INTO zaiNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","―Hombre ca', ruuya nabé naxoo viaje ri'. Zaniti barcu ri' ne irá ni dxá ndaani'. Ne cadi nga si, zándaca dede ne laanu. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Peru qué nulabi capitán ni ziné laadu que ni na Pablu, sínuque jma bicaa diaga ni na ni ziusá barcu que ne xpixuaana ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Cadi galán raqué para tidi binni tiempu nanda. Ngue runi casi irá cabe na cabe jma galán iré' du raqué idu'ya du pa ganda chindá du Fenice, ti puertu sti isla queca ra qué lica rinaaze bi. Ne raqué uti'di du ca beeu nananda que. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Casi bi'ya cabe bindubi ti bi nisa na cabe ma chuu du. Para biré' du ne udidi du gaxha isla Creta que. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Laati du biré' du biete ti bi yooxho rabi cabe “Euroclidón” unaaze barcu que. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Biyubi du ñuu du, peru bidu'ya si du qué ñanda, bidí' du lugar chiné ni laadu ladu na ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Udidi du ti isla huiini lá Clauda ra jma huaxié' rinaaze bi. Zeda xubi yu du ti canuá huiini ne dxiiña para ulú' du ni ndaani barcu que. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Undisa si du ni la? uluu cabe doo barcu que ti cadi ibiá. Ne óraque undete cabe vela purti cadxibi cabe guiaazi barcu que ndaani yuxi ni rabi cabe Sirte, ne bidii cabe lugar chiné bi ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Sti dxi que biiya si cabe cadi cayaana dxí bi que la? bisa'bi cabe irá bultu ziné barcu que. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Raguionna gubidxa que ucuaa du irá traste sti barcu que bisa'bi du ndaani nisa. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Xadxí qué nihuinni gubidxa nin luceru ne cadi cayaana dxí bi que. Mápeca rabi du qué zalá du. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ma stale gubidxa biaana du sin idó' do, bizuhuaa Pablu lade cabe, na rabi laacabe: ―Hombre ca', pa nucaa diaga tu naa la? qué niré' nu de Creta para cadi nizaaca nu irá ni cazaaca nu ri'. Ne qué nuniti nu irá ni ma biniti nu ri'. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Peru yanna cayabe laatu cadi idxibi tu. Nin tobi de laanu qué zati nu, neca barcu ri zanitilú. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Laatu nanna tu sti Dios naa ne rune xhiiña be. Nuchi biseenda be ti ángel ra nuaa', ");
INSERT INTO zaiNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","na rabi naa: “Cadi idxibi lu, Pablu, purti naquiiñe chi uzuhuaa lu lu César. Ne pur lii zulá Dios irá cani zinéu ca.” ");
INSERT INTO zaiNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nga runi cayabe laatu hombre ca', cadi idxibi tu, purti rune cre zuni Dios ni bisenda tidxi naa ca. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Peru napa nu xidé iré' cá nu lu xiixa isla. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ma raca chupa semana de canacaa bi que laadu lu nisa, ti gueela bia' galaa gueela ra zididi du nisadó' Adria bidii cani runi dxiiña lu barcu que cuenta ma cadxiña du uriá. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Para uluu bia' cabe pabiá' zia' raqué. Napa ni treinta y seis metru. Uzá si du stindaa bigueta uluu bia' cabe sti tiru. Raqué ma napa ni veintisiete metru. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","De raqué ma bidxibi cabe gueda idxela saa ni guie, para bisaba cabe tapa ancla atrá de laani, ne para laacabe pa ñanda si ma nirá gueela'. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Oraque gucala'dxi cani runi dxiiña lu barcu que nuxooñe ca'. Bi'ni ca sica ni zindete ca ca ancla nuu delante que. Abade canuá huiini que candete ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Peru na Pablu rabi capitán ne ca soldadu que: ―Pa qué guiaana ca hombre ca ndaani barcu ri la? qué zalá di tu. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Oraque bichuugu ca soldadu que stoo canuá huiini que ne bidii ca lugar ze ni. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ma zedará gueela gudxi Pablu laacabe go cabe xiixa, na: ―Ma chupa semana qué huayasi tu ne qué huayó to gasti'. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Rinaba laatu go to ti gapa tu stipa. Ne cadi chu' tu xizaa, gasti qué zazaaca tu. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Biluxe si uní' be nga ucuaa be ti pan, bidii be diuxquixe Dios nezalú irá ca'. Para undaa be ni ne bizulú be cayó be. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Oraque ru ma qué nidxibi ca', ne irá ca gudó ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Bia' chupa gayuaa setenta y seis du nuu du ndaani barcu que. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Biluxe si gudó cabe bia' ucala'dxi cabe, bisaba cabe trigu ziné cabe ndaani nisa para isisi barcu que. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ora birá chaahui gueela biiya cani runi dxiiña lu barcu que nuu ra nabidxi, peru qué runibiá' ca raqué. Peru biiya ca nuu ti manga sti nisadó' raqué, nexhe yuxi idubi uriá. Ne na ca pa ganda uchiña ca barcu que raqué. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Para bichuugu ca ca doo sti ca ancla que, bisaana ca cani ndaani nisadó', ne bisitaata ca ca doo liibi timón sti barcu que. Oraque undisa ca vela ni nuu delante que, para inaaze bi ni, ne zaqué ma zidxiña ni lu yuxi. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Peru mala yeudxiga ique ni ndaani ti loma huiini yuxi. Qué lica ñanda ru niniibi ni. Ne ma careza atrá ni ra cadxela saa ola. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ucala'dxi ca soldadu ñuuti ca ca presu ti cadi xhu'ba ca uxooñe ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Peru racala'dxi capitán que ulá Pablu. Ngue runi qué nudii lugar ñuni cabe ni, sínuque na, cani nanna xhu'ba la? guiaba gá nisa que, sa niru iree lu yuxi. ");
INSERT INTO zaiNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ne ca xcaadxi que, ni biree lu tabla, ni biree lu yaga ndahui sti barcu que. Zacá nga bilá irá cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ora ma irá du nuu du lu yuxi que, gunna du Malta lá isla que. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Nabé nacha'hui uca ca binni raqué ne laadu. Bi'ni ca ti gui purti nananda raqué ne cayaba nisa guie. Ne guridxi ca laadu idxiña du cue' gui que idxaa du. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Bitopa Pablu chupa ndaa yaga bidxi uluu lu gui que. Ne ora unaaze gui ni, biree yaande ti beenda', ucuá lu ná be. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ora bi'ya ca binni raqué nanda beenda que lu ná be, na ca': ―Señaladu huayuuti hombre ca binni. Neca bilá be ndaani nisadó' peru ma chi gati be para quixe be ni nuzaabi be. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Peru udxibi ná be, biaba beenda que lu gui, ne gasti qué ñaca be. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Irá ca cabeza si ca idxá be gui o mala guiaba be gati be. Peru xadxí uleza ca ne biiya ca gasti qué ñaca be. Oraque ma adxé ni na ca', ma na ca ti dios laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Gaxha de ra cadxaa du que nuu layú sti Publio ni runi mandar isla que. Gudxi be laadu chuu du ralidxi be. Nabé bilabi be laadu ne biaana du raqué chonna gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ca dxi que pe huará bixhoze be, nexhe né xindxá' ne yuba ndaani'. Para uyé Pablu ra nuu, ne biluxe si uní' né Dios ula'qui ná luguiá be, bisianda laabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ora gunna ca binni que ni la? bedané ca stale binni huará, ne laca bianda ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ne bisiga'de ca laadu stale cosa. Ne zaqueca ora ma chuu du, bidxiiba ca irá ni iqui'ñe du lu barcu. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ma udi'di chonna beeu de nuu du raqué, ucuaa du ti barcu de Alejandría ni bitiidi ca beeu nanda raqué. Punta barcu que cá chupa bidó', Cástor ne Pólux. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Yendá du puertu Siracusa ne biaana du raqué chonna gubidxa. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","De raqué biré' du uzá du lu nisa ti uriá ti uriá dede yendá du Regio. Sti dxi que bizulú bindubi ti bi nisa, ne lu sti dxi que yendá du Puteoli. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Raqué bidxaaga du caadxi hermanu ne unaba ca laadu guiaana né du laaca ti semana. De raqué biré' du ziuu du Roma. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Gunna ca hermanu de Roma ma zidxiña du para yendeza ca laadu. Caadxi beda ndeza laadu Apio ne xcaadxi biaana Tres Tabernas. Ora bi'ya Pablu laacabe, bidii diuxquixe Dios ne bieche ladxidó'. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ora yendá du Roma bisaana capitán ziné laadu que irá presu lu ná xaíque sti ca soldadu de raqué. Peru bisaana cabe Pablu ndaani ti yoo, laa si ne ti soldadu cayapa laa. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Lu chonna gubidxa de yendá du, guridxi Pablu ca xaíque sti ca judíu de raqué. Ne ora bidxiña ca rabi be laaca': ―Biche ca', qué huachee nia dia' ca binni xquidxi nu, nin ni bisaana ca bixhoze gola nu guni nu. Peru unaaze cabe naa Jerusalén, bitiidi cabe naa lu ná ca romanu. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ne unaba diidxa ca romanu naa ximodo ni. Ne ora bi'ya ca qué gapa donda para gate la? ucala'dxi ca nundaa ca naa. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Peru qué niná ca binni laanu. Ngue runi gupa xidé unaba tide lu ná César neca qué gapa xi pur cuaa xqueja ca binni xquidxe'. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ne guridxe laatu para guuya laatu, ne para güe nia laatu diidxa'. Liibe cadena ri purti rune cre ma beeda dxa ni cabeza irá xixé judíu. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Oraque na ca rabi ca laabe: ―Qué huacaa du gasti gui'chi de Judea ra nuzeete ca lii, nin ca binni laanu de raqué ni beeda rarí qué niní' ca pa cuchee lu'. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Peru racala'dxi du ucá' diaga du lii, xi na lu'. Purti irá ladu caní' cabe religión cubi ri. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Para gudixhe cabe ti dxi gaca ni. Ne ora gunda dxi que bidxiña stale binni ra nabeza be. Bizulú be siadó' ne dede bidxí layú cayuí' né be laaca de enda runi mandar sti Dios. Biquiiñe be ni bicaa Moisés ne ni bicaa ca profeta para ucuudxi be laaca guni cre ca Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Nuu caadxi ucuaa ni uní' be que, peru nuu xcaadxi qué ñuni cre. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ma qué ñuu ca tobi si ne bizulú ca caree ca'. Para na be rabi be laaca': ―Rarí pe nga riaba ni bisiní' Espíritu Santu profeta Isaías chiqué ra na: ");
INSERT INTO zaiNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Uyé ra nuu ca binni que ne gudxi laaca zuna diaga ca peru qué ziene ca', ne zuyubi lú ca peru qué zuuya ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Purti ma biguidxi ladxidó' ca', ne ma biseegu ca diaga ca'. Ne biseegu ca lú ca ti cadi gu'ya ca ne guna diaga ca', ti cadi guiene ca', uyubi ca naa para ula'ya laaca', na Dios. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Oraque na Pablu: ―Laganna dxichi ma cucheeche Dios stiidxa lade cani cadi judíu ti ganna ca ximodo ilá ca'. Ne laaca huaxa zucaa diaga ca'. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Ora bina diaga cabe ni uní' Pablu ca, birá cabe biree cabe zicaa yu cabe ni lade cabe. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Chupa iza biaana Pablu raqué ndaani yoo caguixe que, ne bieche né irá ni yeganna laa. ");
INSERT INTO zaiNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Tutiica byuí' né be de enda runi mandar sti Dios ne stiidxa Señor Jesucristu. Iruti nibee laabe de ñuni be ni.");
INSERT INTO zaiNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Naa nga Pablu. Rune xhiiña Jesucristu. Uní' né be naa gaca apóstol ne ulee chu be naa para canayué de evangeliu sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Cadi deru yanna cayete evangeliu ri', sínuque maca bizeete Dios ni dede chiqué lu ca gui'chi ni bicaa ca profeta sti'. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Rusiidi evangeliu ri de Xiiñi be ni gule lade ca xiiñi David ra beda aca binni guidxilayú, o gabi nu Jesucristu Señor stinu. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Pur Espíritu sti Dios ni napa be biasa be de lade gue'tu ne stale enda nandxó', ne zacá bihuinni Xiiñi Dios laabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Pur laabe uca Dios nacha'hui ne naa, ne biseenda naa gune xhiiña irá guidxi ti guni cre irá binni laabe ne guni ca ni na be. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ne lade ca binni que zeeda tu laatu, purti ma uní' né Dios laatu para aca tu xpinni be. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Cuseenda gui'chi ri ra nuu tu, hermanu ca', casi nuu tu ndaani guidxi Roma ca. Nadxii Dios laatu ne ulí laatu para aca tu xpinni. Yanna, Dios Bixhoze nu ne Señor Jesucristu cu' ndaaya laatu ne quixhe dxí ladxidó' to. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Casi uzuluá' racaladxe inié nia Jesucristu udii diuxquixe Dios pur irá tu, purti irá ladu ma cuzeete cabe pabiá' napa tu fe ne Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Rune xhiiña Dios ne rue de evangeliu sti Xiiñi be de idubi ladxiduá'. Ne laabe ñanda ñabi be laatu, qué riaana dxie de uzeete laatu lú be ora rinié nia laabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Laca rinaba lú be tílasi chu' dxi ganda chaa ra nuu tu, ne pa nga ni racala'dxi be, yanna ca ziaa'. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Purti napa stale gana guuya laatu para acaniá laatu guiene chaahui tu stiidxa Dios ti uzuhuaa chaahui tu. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ne zacá zacané saa nu pur fe stinu, purti zacané tu naa pur fe stitu, ne zacaniá laatu pur fe stinne'. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Hermanu ca', racaladxe ganna tu, stale tiru huayabe ñaa ra nuu tu, peru dede nagasi qué huayanda di'. Napa gana gune dxiiña lade ca binni xquidxi tu para ganda gune ganar caadxi de laaca para Cristu, cásica huayune ndaani xcaadxi guidxi ra nuu cani cadi judíu, cani qué ñunibiá' gá Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Naa napa xidé güe stiidxa Cristu lade irá', cásica ra nuu cani nabeza ndaani guidxi ro', zaqueca ra nuu cani nabeza gui'xhi', cásica ra nuu cani nuu xpiaani', zaqueca ra nuu cani huaxié' riene. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ngue runi para naa nagasi ca ñaa ra nuu tu, purti laca napa stale gana güe de evangeliu lade irá tu casi nuu tu Roma. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Qué rituí di lua güe stiidxa Cristu, purti laape ni nga ni riquiiñe Dios para ulá irá cani guni cre ni. Nirudó' beeda ni ra nuu ca judíu, ne óraque ra nuu cani cadi judíu. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Rusiene ni laanu ruxhá Dios stonda nu ra guni cre nu, ne gasti ru sti modo. Casi cá lu Xqui'chi Dios, ra na: “Ni ma bixá stonda ra bini cre la? zabani.” ");
INSERT INTO zaiNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Peru xiana sti Dios nuu luguiá irá cani qué rulabi laa, ne irá cani ruchee, purti pur irá ni cuchee cabe que, qué ganda ihuinni ni jneza. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Nanna ca cabe tu laabe ne ma biene cabe bia' zanda guiene binni de laabe, purti ma bisiene be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Neca qué zanda gu'ya cabe enda nandxó' stibe ni qué ziuu dxi iluxe, ne qué zanda gu'ya cabe ximodo laabe, peru dede dxi bizá' be guidxilayú rihuinni dxichi tu naca be pur irá ni bi'ni be, para cadi iní' cabe qué ganna cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ucabiá' ca cabe laabe, peru qué ñapa cabe laabe casi Dios, ne qué nudii cabe diuxquixe laabe, laga uca huati ique cabe ne bicahui xquenda biaani cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Gucala'dxi cabe ñuu xpiaani cabe peru laga uca huati cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Bisaana cabe enda nandxó' sti Dios, ne lugar de ñapa cabe Dios ni qué ziuu dxi gati', gupa cabe bidó' ni bizá' cabe chura binni guidxilayú ni rati, ne chura mani huiini', ne irá clase mani', ne chura beenda'. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ngue runi bisaana Dios laacabe guni cabe enda nayuudxu ni cá ique cabe que, ne guni cabe ni cadi jneza, ne zaqué bi'ni dxaba saa cabe xcuerpu cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Purti qué ñuni cre cabe ni dxandí ni biluí' Dios laacabe que, laga yenanda cabe enda rusiguii. Gunaxhii cabe ni uyá' ne bisisaca cabe laa, ne qué ñanaxhii cabe ni bizá' irá xixé ni. Laa nda nga qué ziaana dxí de isaca. Amén. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Nga runi bisaana Dios laacabe aca yuudxu cabe modo gapa cabe gana. Gunaa ma qué ñuni casi runi gunaa sínuque uyuu né ca laca gunaa. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ne hombre bisaana de ñacabiá' gunaa ne uca ique ne hombre casi laa. Hombre ne hombre bi'ni ca irá enda nayuudxu sin nituí lú ca'. Zacá beda iree guiaana cabe pur ni bichee cabe que. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Biiya si Dios ma qué na cabe ulabi cabe laa, bisaana laacabe guni cabe ni na xquenda biaani huati cabe, enda qué iquiiñe'. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ne jma rusi yenanda cabe irá ni cadi jneza: rapa cabe jnadxii cabe, riula'dxi cabe quite cabe ique stobi, qué ridxá cabe ne sti si cabe, runi cabe ni nadxaba', rache lú cabe sti stobi, ruuti cabe binni, ridinde cabe, rusiguii cabe, ne ni na cabe que, nga laani. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Qué rusaana dxí cabe de iní' cabe binni, riguixhe cabe mal stobi, raca nanala'dxi cabe Dios, ricabi ruaa cabe, raca cabe nayá', ruchá cabe enda naró' stícabe, ne de laacabe riale irá enda nayuudxu'. Qué ruzuuba cabe stiidxa bixhoze cabe nin stiidxa jñaa cabe, ");
INSERT INTO zaiNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","qué riene cabe ne qué runi cumplir cabe, qué ranaxhii cabe, qué runi perdonar cabe, ne qué riá cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Neca nanna cabe xi na Dios ne nanna cabe naquiiñe gati cani guni irá nga, peru cadi nga si runi cabe sínuque laca rieche cabe gu'ya cabe uchee stobi bia' cuchee cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Yanna lii, hombre, pur irá ni bina diaga lu ca, cadi ulabi lu tutiica naca lu', purti qué gapu xidé udxiiba lu donda ique stobi. Pa udxiiba lu ni luguiá stobi la? laca luguióu' guiaana ni, purti ni cudxiiba lu luguiá stobi que, ngue ca ru'nu'. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Laanu nanna dxichi nu, Dios runi jneza rudxiiba donda luguiá cani runi ca nga. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ne lii, hombre, pa rudxiibu donda luguiá stobi ni cayuni cani, ne zaqueca cayu'nu la? ñee ruzulú lu luguiá si be udxiiba Dios donda, ne cadi luguiá lu la? ");
INSERT INTO zaiNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Purti si ruuya lu nabé nacha'hui Dios ne rudii lugar uchiichi cabe laa, ne qué rixhacala'dxi', nga runi qué ridxibi lu laa la? ñee ca'ru udiiu cuenta xi pur cadi caxhacala'dxi be la? Cabeza be tílasi chu' dxi iguudxi ladixdó' lo'. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Peru lii, naguidxi ladxidó' lo ne cadi cayu'nu pur iguudxi ni. Ngue runi cutopa lú lu stonda lu para dxi cuidxi be cuenta binni, purti zabi be laaca xi huayuni ca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Zaguixe be cada tobi bia' bi'ni'. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Zudii be enda nabani ni qué zaluxe irá cani qué ixhacala'dxi de guni jneza, cani ucaa ique guni ni chu'la'dxi be, ne uyubi ni dxandí risaca ne ni qué ziuu dxi initilú. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Peru zadxiichi né be cani riula'dxi utinde binni. Zusaba ná be laaca', purti qué ninanda ca ni jneza, laga ni cadi jneza yenanda ca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Ziuu enda naná ne yuuba para ca judíu ni qué ñuni jneza, ne zaqueca para cani cadi judíu ni qué ñuni jneza. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Peru ca judíu ni guni jneza la? zusisaca be laaca', ne zieche né be laaca' ne zaguixhe dxí be ladxidó' ca', ne zaqueca cani cadi judíu ni guni jneza. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Purti nezalú be bia'ca risaca irá binni. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Irá cani bichee sin ñanna ley ni bidii Dios Moisés la? zanitilú sin ley. Ne zaqueca irá cani bichee ma nanna xi na ley la? zagui'ba donda ique pur ley. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Purti cadi nayá ladxidó' binni nezalú Dios tisi nanna ley, sínuque nayá ladxidó' ca pa guni ca ni na ni. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Laguuya cani cadi judíu. Qué gapa di cabe libru sti ley, peru pa guni cabe jneza casi na ley la? ngue ma de laasi cabe napa cabe ley neca iruti nudii ni laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Zacá rihuinni ma napa cabe ley ndaani ladxidó' cabe. Stubi stubi cabe ranna cabe uná nga jneza ne uná nga ni cadi jneza, ne xquenda biaani cabe rusiene laacabe pa nayá ladxidó' cabe o pa co'. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ne laca zacá nga chi aca ni dxi usihuinni Dios irá ni ga'chi ndaani ladxidó' binni, ne zuni né be ni Jesucristu. Zacá na stiidxa Cristu ni canayué ri'. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Peru lii nou' judíu lii, ne cá lú lu ley ni bidii Dios Moisés, ne raca lu nayá purti na lu nuu né Dios lii. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ruzulú lu ma nannu xii nga racala'dxi Dios, ne nou' riene lu xii nga jma jneza purti rusiidi ley ni lii. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Lii nou' rinaazu ná cani nacheepa lú ne rinéu biaani para cani canazá lu guelacahui. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Riula'dxu usiidi lu cani qué ganna gasti' ne usiene lu cani qué riene, purti lii nannu xi na ley sti Moisés ni rusiidi irá ni naquiiñe ganna binni ne irá ni dxandí'. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Yanna lii, rusiidi lu stobi, xiñee qué usiidi lu laca lii ya'. Ra'bu laacabe cadi cuana cabe, peru lii riba'na lu'. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Lii nou' cadi chu' né cabe ni cadi xheela cabe, peru lii ru'nu ni. Ridxiichi lu purti napa cabe bidó', peru rindana lu ra yu'du sti ca bidó' que. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Lii raca lu nayá purti nannu ley, peru qué ru'nu ni na ni, ne zacá runi lu menu Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Casi na lu Xqui'chi Dios: “Runi laatu riguu dí cani cadi judíu Dios.” ");
INSERT INTO zaiNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Laatu naca tu judíu ne lu xcuerpu tu riruugu tindaa casi ti seña huandí naca tu xpinni Dios. Seña ca nga ni rabi cabe circuncisión, ne zaquiiñe ni lii peru pa gu'nu ni na ley ni bidii Dios Moisés. Peru pa qué gu'nu ni na ley que la? zeda gaca lu casi tobi ni qué nicaa circuncisión, neca ma napu seña que lu xcuerpu lu'. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ngue runi pa chu' tobi hombre ni qué nicaa circuncisión, peru laa runi ni na ley, ñee qué zudii ni casi ñaca ma ucuaa be seña ni napa lu ca la? ");
INSERT INTO zaiNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ne ni qué nicaa circuncisión lu xcuerpu peru runi ni na ley sti Dios la? zuchá ni lú lu purti lii nannu ley ne ucuaa lu seña sti Dios, peru qué ru'nu ni na ley que. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ni naca judíu de luguiá si la? cadi dxandí ni laa. Ne zaqueca ni napa circuncisión luguiá si xcuerpu la? qué riquiiñe ni laa. ");
INSERT INTO zaiNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ndi nga laani: ni dxandí judíu la? dede ladxidó' naca ni. Ne ni dxandí ucuaa circuncisión la? ucuaa ni de idubi ladxidó', purti ucuaa ni de Espíritu sti Dios ne cadi purti si cá ni lu ley, ne cuyubi ca isaca ca nezalú Dios ne cadi nezalú binni. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Pa zacá ni la? ximodo dxi'ba ca judíu cani cadi judíu ya'. Ne paraa iquiiñe circuncisión. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","De irá modo dxi'ba cabe. Tobi la? bisaana né pe Dios laacabe stiidxa'. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ne neca uyuu de laacabe ni qué ñuni cre, ñee zusaana Dios de guni ni ma uní' pur cani bichee que la? ");
INSERT INTO zaiNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Qué ziuu dxi. Qué zusaana Dios de guni ni ma uní' neca pe nuchee irá xixé binni guidxilayú. Casi cá lu Xqui'chi Dios: Pur ni runi Dios rihuinni qué rusiguii, ne zacá ruseegu ruaa cani riguixhe xqueja. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Yanna chinié casi riní' ique binni. Pa jma rihuinni pabiá' jneza ni runi Dios ra ruché' nu la? xiñee rusaba ná be laanu ya'. Xi na tu, ñee jneza runi be la? ");
INSERT INTO zaiNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Jneza pue. Pa qué ñuni be jneza la? ximodo ñanda nibidxi be cuenta binni guidxilayú ya'. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Peru ruluí' biquiiñe irá enda rusiguii stinu para bihuinni pabiá' dxandí ni na Dios, ne pa biquiiñe ni la? xiñee ndi udxiiba be donda ique nu. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ne pa zacá ñaca ni la? xiñee qué uché' nu para ihuinni ni nacha'hui ya'. Canié zacá purti nuu tu na nga nga ni rusiide', peru cadi dxandí ni. Cuyubi si cabe ga'ni ná cabe naa. Zusaba ná Dios irá ni runi casi runi cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Yanna ya'. Laanu naca nu judíu, ñee jma nayá ladxidó' no que ca xcaadxi binni la? Co', purti casi ma gudxe laatu, irá xixé binni, cásica judíu zaqueca cani cadi judíu, dxi'ba donda ique ca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ndi nga ni cá lu Xqui'chi Dios: Iruti binni runi jneza, nin pe tobi. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Iruti riene, ne iruti ruyubi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","De irá xixé biree chu, ne de irá ma qué iquiiñe'. Iruti qué lica runi jneza, nin pe tobi. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Ndaani yanni cabe casi ti ba' ni zuxele', puru si enda rusiguii riní' cabe. Ndaani ruaa cabe ruluí' nuu venenu sti beenda' ");
INSERT INTO zaiNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","purti ruaa cabe napa cabe laa para si enda riguu dí ne diidxa naná. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Nabé nagueenda ruxooñe cabe ra chi uxhii cabe rini. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Ratiisi tidi cabe runidé cabe, ne raqué nga ma ziyaana enda naná sti stobi. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Qué idxela cabe ximodo gata dxí ladxidó' cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ne qué ridxibi cabe Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Nanna nu gu'ta ley sti Moisés para cani nabani xa'na ley, ti cadi gapa ca xi iní' ca', ne ti iruti guiaana sin uzuhuaa nezalú Dios dxi cuidxi cuenta binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Iruti zaxá stonda, neca pe ñuni ni na ley que, purti gu'ta ley para ganna si cabe cuchee cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Peru yanna ma cusihuinni Dios ximodo ruxhá stonda binni ne cadi pur guni ca ni na ley, neca laca riete ni lu ley ne laca bicaa ca profeta ni. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Irá tu guni cre Jesucristu zuxhá Dios stonda, ne zuni ni tutiica guni cre, purti nezalú bia'ca risaca tobi risaca stobi. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","De irá xixé nu biché' nu, ne qué iquiiñe nin tobi de laanu nezalú Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Peru uca nacha'hui ne laanu, bixhá stonda nu sin quixe nu laa, purti Jesucristu gudixe saca ni biché' nu que. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Gula'qui Dios gati be para quixe be irá ni huachee binni, ne tu guni cre bixhii be rini stibe pur laa la? zaca perdonar. Zacá bi'ni Dios ti ihuinni jneza bi'ni dxi ca'ru gueeda Cristu, ra qué nixhacala'dxi be binni, qué nuquixe be laaca' ni bichee ca', ");
INSERT INTO zaiNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ne laca ti ihuinni jneza cayuni be yanna, purti yáquexa ma gudixe Cristu irá pecadu la? jneza runi be, ruxhá be stonda tutiica guni cre laa. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ne pa zacá ni la? qué gapa nu xi pur uchá nu enda naró' stinu. Ma biluxe nga para laanu. Ñee zuchá nu enda naró' stinu purti runi nu ni na ley la? Co', purti cadi nga di bixhá stonda nu nezalú Dios, sínuque bixá ni ra bini cre nu Jesucristu. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ne zacá riene nu, ora guni cre binni Cristu ruxhá Dios stonda ca', ne cadi purti runi ca ni na ley. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Lácaxa para ca judíu si nuu Dios. Ñee cadi ne para cani cadi judíu la? Né pue. Laca nuu be para ca xcaadxi guidxi. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Tobi lucha si Dios nuu. Nga runi, pa nuu tobi hombre ma ucuaa circuncisión ne guni cre Cristu la? zuxhá Dios stonda. Zaqueca pa nuu tobi hombre ni cadi judíu ni qué nicaa circuncisión peru runi cre Cristu la? laca zuxhá Dios stonda. ");
INSERT INTO zaiNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Yanna ya'. Ñee zusaana nu de guni nu ni na ley la? Qué zanda di'. Yáquexa ma runi cre nu Cristu la? jma rusi zuni nu ni na ley. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Xi zanda iní nu de Abraham, bixhoze gola nu ndaani guidxilayú ri'. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Pa ñaca pur ca enda nacha'hui ni bi'ni be bixhá Dios stonda be la? ñanda ca nuchá be enda naró' stibe, peru cadi nezalú Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Purti sicarí cá lu Xqui'chi Dios: “Bini cre Abraham Dios, ne nga runi bixhá Dios stonda be.” ");
INSERT INTO zaiNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Pa guni tobi dxiiña ne quixe cabe laa, iruti zanda iní' ucuaa si be vueltu que, purti ucuaa be ni saca bi'ni be dxiiña'. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Peru cadi cayabi Dios laanu guni nu xiixa para uxhá stonda nu, sínuque na be guni cre nu ruxhá be stonda cani huachee, ne ra guni cre nu, zuxhá be stonda nu. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Rey David laca bizeete pabiá' nayeche ziaana cani uxhá Dios stonda zacá, cadi pur xiixa ni guni ca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Purti cá ni uní' David que lu Xqui'chi Dios: Tutiica bichee ne ma guca perdonar la? nayeche ziaana, purti ma ga'chi irá ni bichee ca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Nayeche ziaana cani qué uquixe Dios irá ni bichee. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Ñee na be nuu enda nayeche ca para si cani ma napa seña de circuncisión lu xcuerpu la? o laca nuu ni para cani qué nicaa seña que. Guietenala'dxi nu de Abraham. Ma nanna nu bini cre be Dios ne nga runi bixhá Dios stonda be. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Yanna xi na tu de laabe. Ñee ucuaa si be seña de circuncisión que, óraque ru' bixá stonda be la? Co', purti maca bixá stonda be dxi ca'ru icaa be seña que. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ne óraque ru' ucuaa be circuncisión casi ti seña dxandí ma bixá stonda be. Peru bixá stonda be purti bini cre be, ne guca ni dxi ca'ru icaa be seña de circuncisión. Nga runi gunda biree lá be bixhoze irá xixé cani guni cre Dios sin icaa circuncisión, purti zuxhá Dios stonda ca ra guni cre ca casi bini cre be. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ne laca biree lá be bixhoze cani ma ucuaa circuncisión, cadi purti napa ca seña que, sínuque purti laca runi cre ca casi bini cre be dxi ca'ru icaa be circuncisión. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Bidii stiidxa Dios Abraham ne ca xiiñi zacaa ca guidxilayú, casi ni rudii binni xiiñi ora ma chi gati, peru bidii be ni laaca cadi purti bi'ni ca ni na ley sti Moisés, sínuque purti bini cre ca laabe, ne nga runi bixhá be stonda ca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Pa ñaca nudii stiidxa Dios cani nabani si xa'na ley sti Moisés la? ma cadi pur guni cre binni nixá stonda, ne pur gana si nudii stiidxa Dios laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Purti ziaba ná cani ruchee né ley, peru ra gasti ley la? qué zuchee né cabe ni. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ngue runi bidii stiidxa Dios uxhá stonda cani guni cre laa, ti gaca ni de puru enda nacha'hui si stibe. Ne zacá nga bidii stiidxa be irá ca xiiñi Abraham, cásica cani nabani xa'na ley sti Moisés, zaqueca cani guni cre casi bini cre Abraham. Laa nga bixhoze irá xixé nu. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Casi cá lu Xqui'chi Dios ra na Dios rabi Abraham: “Ma bine lii bixhoze stale guidxi.” Ni na ni la? Abraham nga bixhoze irá nu purti ma runi cre nu Dios ni bini cre be. Dios ri ca nga rudii enda nabani cani ma guti, ne laa ruzeete ni ca'ru gale casi ñaca ma gule. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Neca ruluí' ma qué ñapa Abraham xiiñi', peru bini cre ni gudxi Dios laa, uleza beda aca bixhoze stale binni. Purti gudxi Dios laabe pabiá' zadale xiiñi be. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Qué ñaana dxí be de ñuni cre be ni, neca ora redasilú laabe ma nagola pe be, ma udi'di xhi be, purti ma napa be bia' ti gayuaa iza, ne nin ora ruuya be Sara ma udi'di de ñapa ba'du'. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Qué ñaana dxí be de ñuni cre be ni gudxi Dios laabe que, laga jma rusi bidale fe stibe, ne bidii be diuxquixe Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ne ucuá ique be ni, purti nanna be pabiá' nandxó' Dios, ne zuni ni ma uní'. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Nga runi bixhá Dios stonda be purti bini cre be laa. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Peru ra ruzeete Xqui'chi Dios modo bixá stonda be purti bini cre be la? cadi para laasi be ucuá ni. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Laca ucuá ni para laanu, purti laca zaxá stonda nu pa guni cre nu Dios ni undisa Jesús, Señor stinu, de lade gue'tu'. ");
INSERT INTO zaiNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Jesús nga ucuaa enda guti saca irá ni biché' nu, ne bibani para ma qué quiba donda ique nu. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ngue runi yanna ma nuu né nu Dios tobi si, purti bixhá stonda nu ra bini cre nu Jesucristu, Señor stinu. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Cristu nga bichiña laanu ra nuu be ne yanna ma nuu né nu laabe tobi si, purti bini cre nu Jesucristu. Ne ma rieche nu purti cá lú nu isaca né nu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ne cadi nga si nga laani, sínuque laca rieche nu neca rididi nu ra naná, purti nanna nu zacá zazi'di nu cadi ixhacala'dxi nu. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Ne pa qué ixhacala'dxi nu la? zieche né Dios laanu, ne zacá jma rusi zacá lú nu laabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ne cadi pur gana si cá lú nu laabe purti ma bidii be laanu Espíritu Santu ne rusiene Espíritu que laanu pabiá' nadxii be laanu. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ca dxi pe caqui'ñe nu chu' tu acané laanu, ula'qui Dios gati Cristu para ulá cani ruchee. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Nanna nu nagana chu' tu gati pur tobi hombre runi jneza, peru ñanda ca ñuu tu nidxiña de racá, ñati pur ti hombre cha'hui'. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Peru Dios huaxa rusihuinni pabiá' nadxii laanu purti neca cuché' né nu laa chiqué, biseenda Cristu guti pur laanu. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ne yáquexa ma bixá stonda nu ra guti be pur laanu la? nanna dxichi nu zulá be laanu dxi usaba ná Dios binni guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Pa gunda bicueeza enda guti sti Xiiñi Dios de nidxiichi né Dios laanu, neca cuché' né ru nu laa la? lágaxa yanna ma nuu né nu laa tobi si, jma rusi zalá nu purti nabani Xiiñi'. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ne cadi nga si nga laani, sínuque laca napa né nu Dios enda nayeche pur Jesucristu Señor stinu, purti uní' né be Dios pur laanu. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Pur tobi hombre biuu enda ruchee ndaani guidxilayú, ne guti be purti bichee be, ne zacá ucuá enda guti que irá xixé binni, purti laca bichee ca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ridu'ya nu dede dxi ca'ru udii Dios ley Moisés, maca nuu enda ruchee ndaani guidxilayú. Peru xi si la? qué nulabi Dios ra cuchee cabe dxi ca'ru gata ley que. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Peru qué ñaana dxí enda guti ni bizulú né Adán que. Nuu ru ni dxi guta ley sti Moisés. Irá xixé binni guti, dede cani qué nuchee né pe ca stiidxa Dios casi bi'ni Adán. Adán bizulú enda guti, peru gudixhe Dios stobi gueeda udii enda nabani. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Nabé adxé ni bidii Adán laanu pur enda ruchee sti' para ni cudii Dios laanu yanna pur enda nacha'hui sti'. Stale tu guti purti bichee Adán, peru uyuu stobi hombre bi'ni jneza ne pur laa biá Dios stale binni, ne hombre ca nga Jesucristu. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Ma adxé ni bi'ni Dios que para ni beda iluxe né enda ruchee sti Adán. Purti ra bichee tobi si udxi'ba donda ique irá binni guidxilayú, peru yanna pur enda nacha'hui sti Dios ruxhá stonda binni neca nabé bichee ca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ra bichee tobi hombre si, gunda bizulú bini mandar enda guti, peru yanna pur ni bi'ni stobi que, zaxá stonda irá cani icaa ni cudii Dios laa de enda nacha'hui sti'. Zapa ca enda nabani ne zuni mandar né ca Cristu. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ndi nga laani: cásica udxi'ba donda ique irá xixé binni runi ti hombre ni bichee la? zaqueca pur tobi hombre ni bi'ni jneza, zaxá stonda ca', ne zapa ca enda nabani. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Pur hombre ni qué nuzuuba diidxa que, uyuu stale tu bichee, ne zaqueca pur stobi ni bizuuba diidxa que, ziuu stale tu zaxá stonda. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Gu'ta ley para ihuinni pabiá' ruchee cabe, peru ra jma bihuinni cuchee cabe que la? jma rusi bihuinni pabiá' nacha'hui Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Enda ruchee nga bidii enda guti, peru yanna pur ni bi'ni Jesucristu Señor stinu, uca Dios nacha'hui ne laanu, ruxhá stonda nu ne rudii laanu enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Yanna ya', ñee zinanda nu enda ruchee para jma rusi gaca Dios nacha'hui ne laanu la? ");
INSERT INTO zaiNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Co'. Pa ma gue'tu laanu para enda ruchee la? ximodo zanda chi nanda ru nu ni ya'. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ra beda gaca nu xpinni Cristu ne uyú' nisa nu la? raqué nga guti né nu laa ra guti'. Ñee ca'ru guiene tu nga la? ");
INSERT INTO zaiNT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Purti ra uyú' nisa nu guti nu ne biga'chi né nu laabe, ne nga runi cásica biasa be de lade gue'tu pur enda nandxó' sti Dios Bixhoze nu la? zaqueca laanu ma biasa nu para ibani nu adxé modo. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Purti pa guca né nu Cristu tobi si ra guti la? laca zaca né nu laa tobi si ra guiasa nu casi biasa. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Cadi guiaanda laanu, ucuá né Cristu lu cruz ni guca nu ndaani guidxilayú chiqué, ne raqué binitilú ni, ti ma cadi icá nu yaga lu ná enda ruchee. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Purti ni ma guti la? ma bilá de lu ná ni. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ne pa ma guti né nu Cristu la? runi cre nu laca zabani né nu laa. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Nanna nu ma biasa Cristu de lade gue'tu', ma qué zati ru', ma qué zanda guni mandar enda guti laabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Purti ti tiru si gupa be xidé guti be para gudixe be irá ni huaché' nu, ne raqué biluxe ni, ne yanna ra ma nabani be la? nabani be para Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Zaqueca laatu, laguietenala'dxi ma gue'tu laatu para enda ruchee peru para Dios nabani tu, purti ma tobi si laatu ne Cristu Jesús Señor stinu. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ngue runi laatu laga nabani tu, cadi udii tu lugar ucaa ru pecadu laatu yaga, nin ucaa ni laatu guni tu ni na ni. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ne cadi udii tu laatu pecadu para guni tu ni cadi jneza, sínuque laudii laatu Dios purti nuu tu casi ni ma guti peru ma bibani sti tiru. Laudii laatu Dios ti iquiiñe tu para guni tu ni jneza. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ma qué zanda di guni mandar pecadu laatu, purti ma cadi nabani tu xa'na ley, sínuque ma guca Dios nacha'hui ne laatu, ne ma nabani tu pur enda nacha'hui sti'. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Yanna ya'. Ñee zuché' ru nu purti ma cadi nuu nu xa'na ley sínuque nabani nu pur enda nacha'hui sti Dios la? Co' xombre. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Pa laape tu udii tu laatu stobi para guni tu ni na la? óraque ma ni na ngue, nga guni tu. Nga runi pa udii tu laatu pecadu la? zeda iluxe né tu enda guti. Peru pa udii tu laatu Dios para guni tu ni na la? zabani tu jneza. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Chiqué ucuá tu yaga lu ná pecadu, peru uyuu tu beda usiidi laatu ximodo ilaa tu de laani, ne diuxquixe Dios ucuaa tu ca diidxa que de idubi ladxidó' to, ne ma cayuni tu ni na cani. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Ne ra bilaa tu de lu ná pecadu la? biuu tu lu ná enda nacha'hui'. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Canié casi riní' binni guidxilayú purti zacá ti zanda guiene chaahui tu ni cuzeete ri'. Chiqué uzá nanda pe tu ca viciu ne irá ni nadxaba'. Zaqueca yanna lachinanda ni nacha'hui para ganda ibani tu modo na Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ca dxi uyuu tu lu ná pecadu la? iruti nucaa laatu guni tu ni jneza. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Peru xi ulee ndu tu lu irá ni bi'ni tu chiqué ya'. Ñee cadi rusituí si ni lú tu yanna la? Xi ru beda iluxe ca ngue pa cadi enda guti. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Peru yáquexa ma bilaa tu de lu ná pecadu ne ma biuu tu lu ná Dios la? ma cayuni tu ni na, ne ra zeda iluxe ni, zapa tu enda nabani ni qué zaluxe. ");
INSERT INTO zaiNT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Purti ni riaxa pecadu nga enda guti, peru ni rudii Dios nga enda nabani ni qué zaluxe, pur Cristu Jesús Señor stinu. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Hermanu ca', ma nanna tu ley. Ñee qué ganna tu pa naquiiñe guni binni ni na ley ca dxi nabani si la? ");
INSERT INTO zaiNT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Casi ti gunaa napa xheela', qué zanda ichaganá be sti tiru laga nabani ru xheela be, purti nga ni na ley. Peru pa gati xheela be la? para ley ma qué gapa di be xheela be. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Sicarí ni: pa cueza né be sti hombre adxé nabani ru xheela be la? cuchee né be xheela be pur ni na ley. Peru ora ma guti xheela be la? ma qué zucueeza ley que laabe, ne cadi cuchee né be xheela be pa ichaganá be stobi. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Zacá ca laatu, hermanu ca'. Ra guti Cristu lu cruz raqué guti tu para ley, ti ganda icá nú tu stobi, ne ngue nga Cristu ni biasa de lade gue'tu para ganda iqui'ñe nu para Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Adxé modo bibani nu chiqué, purti yenanda nu ni na ique nu, ne biquiinde ley que laanu bini nu ni cadi jneza. Ne zacá beda gati nu para Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Peru yanna ma guti nu para ley ni bini mandar laanu que, ne ma biré' nu lu ná ni. Ma zinanda nu enda nabani cubi ni rudii Espíritu Santu laanu. Ma cadi zinanda nu ley ni cá lu gui'chi'. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Xi na tu ya', ñee napa ley que donda la? Co', sínuque ndi nga laani: pa qué ña'ta ley la? qué ñanna xii nga enda ruchee. Purti qué ñanna pa cuchee ra cayache lua sti binni, pa qué ñabi ley naa cadi gache lua'. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ra gu'ta ley la? jma rusi unaaze dxiichi pecadu naa, purti ni na ley que cadi gune', jma rusi ruchiiña naa gune'. Peru ra gasti ley la? nexhe dxí pecadu, ruluí' ma guti. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Uyuu dxi bibane sin nizaaladxe pa cuchee', purti ca'ru ganna xi na ley. Peru ora gunna xi na ley la? bicuaani ni pecadu ni nuu luguia'ya' ");
INSERT INTO zaiNT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ne zacá gute para Dios. Purti ley ni nexhe udii enda nabani la? laga enda guti beda udii ni naa. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Beda iree caya zacá, purti biquiiñe pecadu ley que para bisiguii naa ne biiti naa. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Peru cadi pecadu di ley, sínuque de Dios zeeda ni, ne mandamientu que laca de Dios zeeda. Jneza irá ni cá lu ni ne nacha'hui ni. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Zuuti xa ni nacha'hui naa. Qué ziuu dxi. Pecadu nga biiti naa, ne zacá bihuinni xi pe nga pecadu. Peru biquiiñe ni ni nacha'hui que para biiti ni naa, purti ra guta mandamientu que jma rusi birooba ni. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Nanna nu de xquenda biaani Dios zeeda ley que, peru naa rune ni na ique', ne caya yaga lu ná pecadu. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Nin naa qué riene dia' xi rune'. Qué rune ni racaladxe gune', sínuque ni qué racaladxe ngue pe rune'. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ne pa rune ni qué na'ya gune la? zacá rihuinni nanna jneza ni na ley sti Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Zacá ma cadi naa pia' cayune ni, sínuque pecadu ni nuu luguia'ya cayuni ni. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Purti naa nanna binni guidxilayú naa, ne gasti enda nacha'hui nuu luguia'ya'. Neca napa gana gune ni jneza, qué zanda gune ni. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Qué rune ni jneza casi ñuuladxe ñune', sínuque ni cadi jneza ngue rune', neca qué racaladxe'. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ngue runi pa rune ni qué racaladxe gune la? ma cadi naa cayune ni, sínuque pecadu ni nuu luguia'ya cayuni ni. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Ma biene ximodo zeeda ni. Casi naa gacaladxe gune ni jneza, rutaagu pecadu naa. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Purti lu xquenda biaane rieche nia ley sti Dios, ");
INSERT INTO zaiNT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","peru ruuya ma adxé ley nuu luguia'ya' ne nuu dinde né ni ley ni maca cá lu xquenda biaane', ne laani nga rucaa ni naa yaga lu ná pecadu ni runi mandar naa. ");
INSERT INTO zaiNT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","25","Ndi nga laani: xquenda biaane riguba yu naa gune ni na Dios, peru pecadu caguba yu naa gune ni na. Pobre de naa. Nanna xi gueda iree xa'ya'. Tuu nga cuee naa de enda guti ni naaze naa ri pue. Rudiee diuxquixe Dios purti Jesucristu zabee naa de laani. Laabe nga Señor stinu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Ngue runi ma qué zudxiiba Dios donda luguiá cani ma nuu né Cristu tobi si, cani ma cadi nabani modo na ique sínuque modo na Espíritu Santu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Purti rudii Espíritu Santu enda nabani cani ma nuu né Cristu Jesús tobi si, ne zacá ma bilá ca de lu ná pecadu ni rudii enda guti. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Qué ñanda di niquiiñe ley sti Moisés pur ni naca binni guidxilayú, peru ra biseenda Dios Xiiñi la? raqué huaxa guca ni qué ñanda ñuni ley que. Beda gapa Xiiñi be que cuerpu casi cuerpu sti binni guidxilayú, beda gati para quixe ni bichee binni. Ne pur ni bi'ni Xiiñi be que ma qué ziuu ru dxi guni mandar pecadu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Bi'ni Dios irá nga ti yanna ma guni nu jneza casi rucaa ley binni guni. Laanu ma cadi nabani nu modo na ique nu, sínuque modo na Espíritu Santu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Purti cani nabani casi na ique la? ruyubi guni ni riula'dxi si, peru cani nabani casi na Espíritu la? ruyubi guni ni na Espíritu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Cani ruyubi ni chu'la'dxi si la? rati, peru cani ruyubi guni ni chu'la'dxi Espíritu Santu la? ricaa ca enda nabani ne ra'ta dxí ladxidó' ca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Raca ni zacá purti ni rucaa ique guni ni chu'la'dxi si la? nanala'dxi Dios. Qué runi ni na ley sti Dios, ne neca pe niná ñuni ni, qué ñanda di'. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Nga runi, ni nabani casi na ique la? qué zanda ibani casi na Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Peru laatu ma cadi nabani tu casi na ique tu, sínuque casi na Espíritu, pa huandí nuu né Espíritu sti Dios laatu. Ne pa nuu tobi ni qué gapa Espíritu sti Cristu la? cadi dxandí xpinni Cristu laa. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Peru pa nuu né Cristu laatu la? neca casi ñaca ma guti xcuerpu tu runi pecadu, peru rudii Espíritu Santu enda nabani laatu purti ma bixá stonda tu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Dios nga bisibani Cristu de lade gue'tu', ne pa nuu né Espíritu stibe laatu la? laca zusibani be xcuerpu tu ni gati', casi bisibani be Cristu. Ne zuni né be ni Espíritu stibe ni nuu né laatu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ngue runi hermanu ca', nuu ni naquiiñe guni nu, peru qué gapa nu xidé guni nu ni na ique nu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Purti pa ibani tu modo na ique tu zati tu. Peru pa uyubi tu acané Espíritu Santu laatu para ma cadi ibani tu modo na ique tu la? zabani tu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Irá cani runi ni na Espíritu sti Dios, ca ngue nga xiiñi Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Cadi zácaxa tu ma bi'ni be laatu esclavu para idxibi ru tu laabe, sínuque ma bi'ni be laatu xiiñi be. Ne rabi Espíritu stibe laanu gabi nu laabe Bixhoze nu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ne zaqué rusiene Espíritu stibe espíritu stinu ma xiiñi be laanu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ne pa xiiñi be laanu la? laca zacaa nu de lú ni udii be ca xiiñi be. Ne pa chu' né nu Cristu tobi si lu enda naná sti', laca zasaca né nu laa ne zacaa né nu laa de lu ni udii Dios laa. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Ndaani guidxilayú ri racaná nu, peru naa qué rizaaladxe irá nga, purti nanna zadxiña dxi udii Dios laanu ni nabé galán. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Zaqueca de irá ni bizá' Dios, laca cabeza si idxiña dxi uluí' be uná nga ca xiiñi be. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Purti dxi bizá' be guidxilayú bizá' be ni galán, peru dxi ma biuu enda ruchee ndaani ni, beda gaca yuudxu ni, ne cadi laani biyubi ni gaca ni zacá sínuque laabe gudixhe be gaca ni, runi enda ruchee que. Peru cabeza ni dxi ");
INSERT INTO zaiNT_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ilaa né ni ca xiiñi be lu ná enda nayuudxu', ti ibigueta aca ni galán, ne ma iquiiñe pe ni para laabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Peru laga cabeza ni idxiña dxi ca la? nuu né ni ti yuuba ro', casi ti gunaa ora chi xhana, ruuna dede ricaala'dxi'. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Ne cadi laasi ni, sínuque laca ne laanu nuu né nu ti yuuba ro', neca ma ucuaa nu caadxi de ni chi udii Dios laanu, purti ma napa nu Espíritu sti'. Peru cabeza ru nu dxi icaa be laanu casi xiiñi be, ne dxi que nga ilaa ca cuerpu stinu lu ná enda nayuudxu que. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Laanu bilá nu purti ucuá lú nu ni ca'ru ihuinni. Pa cayuuya binni ni cabeza la? cadi dxandí cabeza ru ni. Ribeza xa cabe ni maca cayuuya cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Peru pa cá lú nu ni ca'ru idu'ya nu la? qué zaxhacala'dxi nu de cueza nu ni. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ne laca racané Espíritu Santu laanu iní né nu Dios, purti laanu qué ganna di nu guni nu ni jneza, peru ora qué ganda idxela nu xi iní nu la? ricaala'dxi si nu, ne Espíritu que riní' pur laanu ra nuu Dios. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Purti nanna Dios xi nuu ndaani ladxidó' irá binni, ne riene xi na Espíritu, purti modo pe na be, modo que pe rinaba Espíritu pur ca xpinni be. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Nanna dxichi nu riguixhe chaahui Dios irá cosa jneza para cani nadxii laa, cani uní' né para guni ni na. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Dede chiqué maca gucabiá' be cani guni cre laabe, ne ca ngue nga ulee chu be para chi ndee Cristu Xiiñi be, ne zaqué Cristu nga lugola lade irá bi'chi'. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ne cani maca ulee chu be dede chiqué laca uní' né be laaca'. Ne cadi nga si, laca ruxhá be stonda ca', ne ora ma bixá stonda ca rusisaca be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Xi zanda gabi nu de irá nga ya'. Pa nuu Dios pur laanu la? iruti zanda ucaa lú laanu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Laabe nin qué ña be Xiiñi be sínuque bidii be laa guti pur irá nu. Yanna, ñee na tu qué zuni be pur icaa né nu Xiiñi be irá ni udii be laa la? ");
INSERT INTO zaiNT_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Tu ru zanda cu' xqueja cani ma ulí Dios ya'. Dios pe uní' ma bixá stonda cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","O tu zanda udxiiba donda ique cabe. Cristu la? co', purti laa pe guti pur laanu, ne cadi nga si sínuque laca bibani de lade gue'tu ne ma nuu cue' Dios, caní' pur laanu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Iruti zanda cuee laanu de Cristu ni nadxii laanu. Ñee zaxele nu de laabe pur xiixa naná ni gueeda luguiá nu la? o purti cadidi nu xiixa ni nagana, o purti cayaadxa ni idó' no, o ti gasti ni gacu nu la? Ñee zaré' nu de laabe purti naxoo nuu nu la? o purti canananda cabe guuti cabe laanu la? Co'. Nanna dxi'che gasti zanda uxhele laanu de Cristu ni nadxii laanu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Casi cá ni lu Xqui'chi Dios ra na: Purti ma bini cre du lii, canayuuti cabe laadu idubi dxi. Napa cabe laadu casi dendxu ni ma chi gati. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Peru neca gueeda irá nga luguiá nu, qué zanda di usaba ni laanu, purti nadxii Cristu laanu. ");
INSERT INTO zaiNT_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Nanna dxi'che gasti zanda uxhele laanu de Dios ni nadxii laanu: nin enda guti, nin enda nabani, nin ángel, nin binidxaba', nin ni ridu'ya nu yanna ri', nin ni gueeda ru', ");
INSERT INTO zaiNT_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","nin ni nuu ibá', nin ni nuu xaguete', nin gasti ru de irá ni bizá' Dios qué zanda uxhele laanu de Dios ni nadxii laanu, purti bisihuinni be pabiá' nadxii be laanu pur ni bi'ni Jesucristu Señor stinu. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Nuu né Cristu naa, ne nga runi nanna canié ni dxandí'. Nanna dxi'che cadi cusiguiee dia', ne nga ca rabi Espíritu Santu naa. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Nuaa triste ne qué ganda iree yuuba ndaani ladxiduá'. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Tantu cá ique ca judíu, ca binni xquidxe', ñacaladxe pia' niree de Cristu ne niniteluá', tílasi zacá ma ñuu cabe laacabe, purti biche laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Za cabe de Israel, ne ulí pe Dios laacabe gaca cabe xiiñi'. Bihuinni pe Dios lade cabe casi ti za ni ruzaani', ne bidii stiidxa laacabe, ne bidii ley Moisés para udii ni laacabe. Laca bisiidi laacabe ximodo guni cabe cultu para laa, ne gudxi laacabe xi chi guni para laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Laacabe nga xiiñi ca primé bixhoze gola nu, ne de lade cabe nga beeda Cristu dxi beda gaca binni guidxilayú. Laa nga Dios de lade irá xixé, ne laa nga qué ziaana dxí de isaca. Amén. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Peru ca judíu, neca bidii Dios laacabe irá nga, ma cadi nuu né cabe Dios tobi si. Peru cadi pur nga zácaxa nu qué ñaca ni uní' Dios gaca'. Purti cadi irá cani gule de Israel dxandí naca binni Israel. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ne zaqueca cadi purti si beeda cabe de lade ca xiiñi Abraham, xiiñi Abraham irá cabe nezalú Dios. Cadi zacá di nga laani, purti casi na Dios rabi Abraham chiqué: “De Isaac si nga gueeda cani dxandí xiiñu'.” ");
INSERT INTO zaiNT_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Ndi nga ni na ni: cadi dxandí xiiñi Dios irá ni gale lade ca xiiñi Abraham, sínuque cani bidii stiidxa si Dios gale, ca ngue nga riguu Dios cuenta casi xiiñi'. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Purti sicarí gudxi be Abraham chiqué: “Stubiza dxi ri' zabigueta' ne zapa Sara ti xiiñi'.” ");
INSERT INTO zaiNT_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ne cadi nga si, laca uní' né be Rebeca, dxi ma naca xiiñi xiiñi Isaac, bixhoze gola nu. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","13","Ne biree ni modo pe uní' be, purti naquiiñe gaca ni ma gudixhe be gaca'. Laabe nga ribí be tu gacala'dxi be ne cadi pur ni ma bi'ni ca'. Dxi uní' be ni, ca'ru gale ca xiiñi Rebeca, ne ca'ru guni ca ni jneza nin ni cadi jneza, peru rabi be Rebeca: “Xiiñu ni jma huaniisi zuni ni na ni jma nahuiini'.” Ne laca cá ni lu Xqui'chi Dios: “Gunaxhiee Jacob ne guca nanaladxe Esaú.” ");
INSERT INTO zaiNT_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Xi gabi nu ya'. Ñee cadi jneza runi Dios la? Jneza pue. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Purti gudxi be Moisés: “Zalaseladxe tu gacaladxe', ne zia'ya tu gacaladxe guia'ya'.” ");
INSERT INTO zaiNT_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ne zacá cadi zeeda ni pur ni racala'dxi binni, nin pur ni runi, sínuque purti riá be laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Purti cá lu Xqui'chi be ra uní' né be Faraón, na be rabi be laa: “Bine lii rey para gu'ya binni enda nandxó' stinne luguiá lu', ne para gunibiá' idubi naca guidxilayú tu naa.” ");
INSERT INTO zaiNT_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Zacá ridu'ya nu rilasela'dxi be cani racala'dxi be ne ruquidxi be ladxidó' cani racala'dxi be iguidxi ladxidó'. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Zándaca ga'bu naa: “Xiñee rudxiiba ru Dios donda luguiá binni ya'. Zanda xa uchaa cabe ni ma uní' Dios.” ");
INSERT INTO zaiNT_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Peru hombre, tu naca lu para qué guiaanu conforme ne ni runi Dios. Niní' xa ti guisu ñabi ni bizá' laa: “Xiñee bizóu' naa sicarí'.” ");
INSERT INTO zaiNT_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Lácaxa qué gapa ni ruzá' guisu derechu guzá' ti guisu sicarú, ne óraque de yu queca guzá' stobi ni iquiiñe si para ludé. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Nga runi, xi gabi nu de Dios ya'. Purti laa gucala'dxi nusaba ná cani cuchiichi laa, cani ma nuu para initilú, ne gucala'dxi ñanna ca xii nga enda nandxó' sti'. Peru ni bi'ni be la? bicueeza be enda ridxiichi que xadxí. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Ne bicueeza be ni para ihuinni pabiá' nga naro'ba enda nacha'hui stibe para cani ilasela'dxi be, cani maca gudixhe be usisaca be. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ne zanda gabi nu nga nga laanu, purti ne laanu ulí be, ne cadi de lade ca judíu si, sínuque ne lade cani cadi judíu. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Sicarí cá lu Xqui'chi Dios ni bicaa profeta Oseas: Ca binni ni cadi xpinne zaca ca xpinne', ne cani qué ñanaxhiee ga'ya', laca zanaxhiee laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Ne ra gudxi Dios laaca chiqué cadi xpinni laaca', raqueca nga iree lá ca xiiñi Dios ni nabani. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Peru ra bizeete profeta Isaías ca binni Israel la? sicarí na: Neca idale ca xiiñi Israel casi yuxi sti nisadó', peru caadxi si de laaca zalá. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Purti zusaba ná Dios xquidxi cabe casi uní', ne zuni ni nagueenda ne qué ziá laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Ne laca na Isaías chiqué: Pa Dios ni runi mandar irá xixé qué nulá caadxi de laanu la? ma ninitilú nu casi binitilú ca binni Sodoma ne Gomorra. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Yanna ya', xi gabi nu. Ndi nga laani: cani cadi judíu, cani qué nuyubi ñaca nacha'hui chiqué, yanna ma guca ca nacha'hui', o zanda gabi nu ma bixá stonda ca nezalú Dios, purti ma bini cre ca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Peru ca judíu, ca binni Israel, yenanda ca ley ti cadi quiba donda ique ca nezalú Dios, peru qué ñanda ñuni ca ni na ley que. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Xiñee. Purti qué nuyubi cabe nuxhá Dios stonda cabe ra ñuni cre cabe laa, sínuque biyubi cabe nixá stonda cabe pur ni cayuni cabe. Nga runi beda gaca Cristu casi ti guie ni birenda ñee cabe para biaba cabe, purti qué ñuni cre cabe laa. ");
INSERT INTO zaiNT_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Sicarí cá lu Xqui'chi Dios: Ndaani guidxi Sion caguixhe tobi ni gaca casi ti guie ni irenda ñee cabe. Peru ni guni cre laabe la? qué ziuu dxi gueeda malaya laa. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Hermanu ca', ni nusieche ladxiduá' nga nilá ca binni Israel, ne rinaba lu Dios gaca ni. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Ruuya dxandí rucaa ique cabe guni cabe ni na Dios, peru cuchee cabe modo na cabe guni cabe ni. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Purti qué riene cabe ximodo na Dios uxhá stonda binni, lágala ruyubi cabe ixá stonda cabe modo na cabe, ne zacá ma qué na cabe guni Dios ni modo na. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Dede beeda Cristu ma qué riquiiñe ley, purti cadi ra guni cabe ni na ley nga ixá stonda cabe, sínuque ra guni cre cabe laabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Sicarí bicaa Moisés, na: “Cani cuyubi ilá pur guni ni na ley la? napa xidé guni irá xixé ni na ni, pacaa qué zalá.” ");
INSERT INTO zaiNT_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Iruti zanda guni irá ni na ley sin uchee, peru zalá ra guni cre Cristu. Nga runi ma cadi naquiiñe iníu' ndaani ladxidó' lo': “Zanda xa quiba binni ibá' para chi yubi modo ilá.” Purti pa nigui'ba lu ibá' la? nga casi ñaca cuyubi lu indete lu Cristu de raqué. Cadi xa ma biete be ti tiru, beda ulá be laanu. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Ne zaqueca cadi ma caní' ique lu': “Zanda xa guiete binni xaguete para chi yubi ixá stonda.” Pa ñete lu xaguete la? nga casi ñaca cuyubi lu indisa lu Cristu de lade gue'tu'. Cadi xa ma biasa be. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Ne zándaca na lu': “Paraa idxela modo ila'ya pue.” Zadxe'lu ni pa guni cre lu ca diidxa ni canayuí du ri', ne gaxha do' rigaa ca diidxa ca laatu. Nuu ca cani ndaani ruaa tu ne ndaani ladxidó' to. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Purti pa iní' lu Jesús nga xpixuaana irá xixé, ne guni cre lu de idubi ladxidó' lo dxandí undisa Dios laabe de lade gue'tu la? zalá lu'. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Purti ndaani ladxidó' cabe runi cre cabe para ixá stonda cabe, ne ra iní' cabe ni nezalú binni la? zalá cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Sicarí na lu Xqui'chi Dios: “Zuni be irá ni uní' be para tutiica guni cre laabe.” ");
INSERT INTO zaiNT_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Ti Dios si nuu para irá xixé, ne nezalú be bia'ca risaca ca judíu, bia' queca risaca cani cadi judíu. Nga runi de lu irá ni napa be zudii be tutiisi inaba laabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Purti zacá cá lu Xqui'chi be: “Tutiica inaba lu Señor ilá la? zalá.” ");
INSERT INTO zaiNT_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Peru qué zanda inaba ca ulá be laaca pa ca'ru guni cre ca laabe. Ne qué zanda guni cre cabe tobi ni qué huayuu dxi guna diaga cabe stiidxa'. Ne qué zanda guna diaga cabe ni pa qué chu' tu güi né ni laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Ne qué zanda chu' tu güi né ni laacabe pa iruti useenda laa. Casi cá ni lu Xqui'chi Dios: “Dunabé sicarú ni cayuni ni canayuí' de evangeliu ni rusieche binni. Purti diidxa galán nga canayuí' cabe.” ");
INSERT INTO zaiNT_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Peru neca guna diaga cabe ni, cadi irá cabe zacaa cabe ni. Casi na profeta Isaías: “Señor Dios, iruti ñuni cre ni byuí du.” ");
INSERT INTO zaiNT_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Peru riale fe ra guna diaga cabe stiidxa Cristu, ne zuna diaga cabe ni ora chu' tu güi né ni laacabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Peru naa rabe': Ñee cadi ma bina diaga cabe ni la? Ma pue. Purti sicarí cá lu Xqui'chi Dios: Ma yendá stidxi cabe irá guidxi, ne ma bireeche stiidxa cabe dede ra bidubi guidxilayú. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Casi cayabe laatu ca: Ñee cadi ma biene ca binni Israel ni la? Purti laca cá lu Xqui'chi Dios ra bizeete Moisés ni uní' Dios: Naa zune pur gache lú tu ora gu'ya tu ni chi gune para ca xcaadxi binni ni ca'ru gaca ti guidxi. Zune pur idxiichi tu pur ti guidxi ni qué lica riene. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ne laca cá lu Xqui'chi Dios ra bisiá chaahui Isaías stiidxa Dios: Cani qué nuyubi naa bidxela ca naa, ne cani qué ninaba diidxa naa, uyaa ra nuu ca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Peru ora ruzeete be binni Israel, na be: “Idubi dxi bixhale naya para ti guidxi ni qué nuzuuba stiidxa', ne ni bicaa lú naa.” ");
INSERT INTO zaiNT_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Lagabi naa, ñee ma bisaana Dios ca judíu, ca xpinni pe la? Qué ziuu dxi. Naa laca judíu naa, binni Israel. Zaya de Abraham, de xfamilia Benjamín. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Ne nanna cadi cusaana Dios xpinni, cani maca ulí dede chiqué. Ñee qué ganna tu xi na lu Xqui'chi Dios ra ruzeete ni Elías la? Cá ra uluu Elías xqueja ca binni Israel lu Dios, na: ");
INSERT INTO zaiNT_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Señor, ma biiti cabe ca profeta stiu' ne ma binidé cabe ca altar stiu'. Yanna ma naa sia' biaana', ne laca racala'dxi cabe guuti cabe naa.” ");
INSERT INTO zaiNT_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Nga ni uní' profeta Elías, peru xi gudxi Dios laabe óraque. Na Dios: Neca ma bi'ni cabe irá nga, peru ma ulee chua gadxe mil hombre para naa, cani ca'ru uzuxibi xañee bidó' Baal. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Nga ni guca chiqué, peru yanna ri laca riaana ru caadxi judíu ni ulí Dios pur enda nacha'hui sti'. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Ulí be laaca purti guca be nacha'hui ne laaca', ne cadi pur ni bi'ni ca'. Pa ñaca nibí be laaca pur ni bi'ni ca la? ma cadi enda rilasela'dxi di nga. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Xi riaana xa ni ya'. Cadi idubi guidxi Israel gucuaa ni biyubi, peru cani ulí Dios la? ca ngue huaxa ucuaa ca', ne ca xcaadxi que jma rusi biguidxi ladxidó'. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Casi na lu Xqui'chi Dios: Bisicahui Dios xquenda biaani ca', ne bi'ni lú ca para ma qué niná ca', ne diaga ca para ma qué ñuna diaga ca', ne zaqué nuu ca de yanna. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Ne laca uní' Dios de ruaa rey David, na: Gaca ca saa stícabe trampa para usaba laacabe. Ne gaca cani casi xiixa irenda ñee cabe, ne pur laacani guiaba ná cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Ne icheepa lú cabe para qué gu'ya cabe, ne iguude deche cabe para ma qué ganda indisa ique cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Nga ni uní' rey David chiqué, peru naa rabe sicarí': Ñee birenda ñee ca judíu para biaba ca ca la? Co', sínuque ndi nga laani: ra qué nuzuuba cabe diidxa la? gunda bilá cani cadi judíu, ti gache lú cabe ora gu'ya cabe laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ne pa gucané enda ruchee sti ca judíu irá binni guidxilayú, ne gucané ra biaba cabe para biasa cani cadi judíu la? lágaxa ora ibigueta pe cabe jlugar cabe sti tiru. Jma rusi xa. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Canié nia laatu cani cadi judíu ca', purti naa nga apóstol sti cani cadi judíu, ne rusisaca xhiiña', ");
INSERT INTO zaiNT_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ti racaladxe gache lú ca binni xquidxe', tílasi zacá ilá caadxi de laaca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Purti ra bicaa ná Dios ca judíu, uyuu né idubi guidxilayú tobi si, ne pa zacá ni la? xi gaca xa dxi uxhale ná be para ca judíu sti tiru ya'. Zeda gaca ni casi ra ibani ni ma guti. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Pa gucuaa Dios cani uzá niru la? zaqueca zacaa cani nanda atrá. Zanda quixhe nu ti yaga casi ejemplu. Pa nazaaca xcu yaga la? laca nazaaca ca rama. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Peru gabi nu bidxiña dxi bigá caadxi rama sti ti yaga olivo cha'hui', ne ra biree ca rama sti pe ni que, uluu cabe rama sti ti yaga olivo gui'xhi'. Ca rama bigá que zeda gaca casi ca judíu, ne ca rama olivo gui'xhi que nga laatu, cani cadi judíu. Ma nuu tu lu yaga olivo que, ne cacaa tu de irá ni zeeda de xcu yaga que. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Peru cadi gaca tu nayá né ca rama ni bigá que. Purti ante uchá tu enda naró' stitu la? naquiiñe guietenala'dxi tu cadi laatu naaze tu xcu que, sínuque xcu que naaze laatu. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Zándáca na tu: “Peru bigá ca rama que para uyú' du.” ");
INSERT INTO zaiNT_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Dxandí bigá cabe purti qué ñuni cre cabe, ne laatu ma uluu Dios laatu purti bini cre tu Cristu. Nga runi cadi gaca tu nayá', sínuque laguuya gá laatu. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Purti pa qué ñá Dios ca rama sti pe yaga que la? nin ca laatu qué ziá'. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Laguuya pabiá' nacha'hui Dios, peru laca naduxhu'. Purti naduxhu né be cani bichee, peru nacha'hui be para laatu pa qué ixele tu de enda nacha'hui stibe. Pacaa la? laca zagá tu. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ne ca judíu laca ziuu ca pa na ca guni cre ca', purti nandxó' Dios ne zanda cu' laacabe sti tiru. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Pa biruugu tu de lu yaga olivo gui'xhi ra undani pe tu, ne beda chuu tu lu yaga olivo cha'hui ra qué nindani tu la? lágaxa cani undani pe lú ni, jma rusi qué igana ibigueta ca lu yaga sti pe ca'. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Hermanu ca', chi güe nia laatu xiixa ni deru cusihuinni Dios, ne racaladxe guiene chaahui tu ni, para cadi udxiiba tu laca laatu. Dxandí ma biguidxi ladxidó' caadxi de ca binni Israel laga si ilá ca binni ni cadi judíu, bia' maca nexhe ilá. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Ne sicarí nga ilá idubi guidxi Israel, casi cá lu Xqui'chi Dios, ra na: De ndaani guidxi Sion zeeda tobi ni ulá, zeda ndee ni nadxaba lade cani za de Jacob. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Zacá nga bidiee stiidxa laacabe zuxhaya ca xpecadu cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Ra qué nicaa ca judíu evangeliu, bixele Dios de laaca para guyuu né laatu tobi si. Peru nadxii ru laacabe pur ca bixhoze gola cabe ni ulí dede chiqué. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Purti qué zuchaa Dios ni ma uní'. Pa ma uluu ndaaya ne ma guridxi la? qué ziuu dxi udxigueta'. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Laatu laca qué nuzuuba tu stiidxa be chiqué, peru yanna ma calasela'dxi be laatu purti ma bichee ca judíu. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Ne zaqueca yanna cuchee cabe ti laca ilasela'dxi Dios laacabe cásica bi'ni né laatu. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Purti laa pe bisaana irá xixé binni lu ná enda ruchee ti ilasela'dxi irá cabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Nabé riene Dios, iruti ru nuu xpiaani bia' nuu xpiaani be, ne iruti ru riene bia' riene be. Qué zanda di ganna nu xi na xquenda biaani be nin guiene nu xi cayuni be. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Casi cá lu Xqui'chi be, ra na: Tu laa zanda ganna xi chi guni Señor, o tu bisiene laabe. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Zanda xa udí' nu laabe xiixa ne óraque ru cueza nu quixe be laanu pur ni bidí' nu que. ");
INSERT INTO zaiNT_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Purti irá xixé zeeda de laabe, ne pur laabe nuu irá ni, ne para laabe. Ne qué ziuu dxi guiaana dxí de isaca be. Amén. ");
INSERT INTO zaiNT_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Nga runi hermanu ca', pur ma bilasela'dxi Dios laatu, rinaba udii tu xpida tu laa, casi ti ofrenda ni nabani ne nayá, ne ni chu'la'dxi icaa. Zacá ti zanda usisaca tu laa de idubi ladxidó' to. ");
INSERT INTO zaiNT_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Ne ma cadi chi nanda tu ni na binni guidxilayú, sínuque laudii lugar uchaa Dios laatu ne cuee irá ni ucuá ique tu chiqué. Zacá zanna tu xii nga racala'dxi Dios guni tu, ni nacha'hui ne ni chu'la'dxi' ne ni jneza pe'. ");
INSERT INTO zaiNT_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Pur enda nacha'hui sti Dios biseenda naa gune dxiiña sti'. Nga runi chi ulidxe cada tobi de laatu, cadi udxiiba tu laatu jma que bia' naca tu, sínuque cada tobi guiaana conforme bia' ma naca si que nga laani, bia' fe bidii Dios cada tobi. ");
INSERT INTO zaiNT_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Casi ti cuerpu napa stale ndaa, peru adxé adxé ni runi cada ndaa, ");
INSERT INTO zaiNT_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","zaqueca laanu, neca stale nu peru ma naca né nu Cristu tobi si, ne laca ma naca né nu irá hermanu tobi si. ");
INSERT INTO zaiNT_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Peru