﻿USE sofia;
DROP TABLE IF EXISTS sofia.zae_vpl;
CREATE TABLE zae_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zae_vpl WRITE;
INSERT INTO zae_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Lo yetsi‑ni rigixxi'a lá ka benne ukake xutto Jesucristuha. Labie uke benne datie David lhe Abraham lhe. ");
INSERT INTO zae_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham‑ni bije Isaac, Isaac‑ni nna bije Jacob, Jacob‑ni nna bije Judá lhe ka betsiniha lhe. ");
INSERT INTO zae_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá‑ni nna bije Fares lhe Zara lhe. Nan ge ka benneha uke Tamar. Fares‑ni nna bije Esrom, Esrom‑ni nna bije Aram. ");
INSERT INTO zae_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram‑ni nna bije Aminadab, Aminadab‑ni nna bije Naasón, Naasón‑ni nna bije Salmón. ");
INSERT INTO zae_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón‑ni nna bije Booz. Nan ge Booz‑ni nna uke Rahab. Booz‑ni nna bije Obed. Nan ge Obed nna uke Rut. Obed‑ni nna bije Isaí. ");
INSERT INTO zae_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí‑ni nna bije David benne unnabie ka benne Israel‑ni. David‑ni nna bije Salomón. Nan ge Salomón‑ni nna uke nuila ge Urías. ");
INSERT INTO zae_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón‑ni nna bije Roboam, Roboam‑ni nna bije Abías, Abías‑ni nna bije Asa. ");
INSERT INTO zae_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa‑ni nna bije Josafat, Josafat‑ni nna bije Joram, Joram‑ni nna bije Uzías. ");
INSERT INTO zae_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías‑ni nna bije Jotam, Jotam‑ni nna bije Acaz, Acaz‑ni nna bije Ezequías. ");
INSERT INTO zae_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías‑ni nna bije Manasés, Manasés‑ni nna bije Amón, Amón‑ni nna bije Josías. ");
INSERT INTO zae_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías‑ni nna bije Jeconías lhe ka betsiniha lhe. La'ania nuha bedaxxu ka nu Babilonia‑ni ka benne Israel‑ni nna dechekana ke daka lo yu gekaniha. ");
INSERT INTO zae_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Iki de chi bisinke Babilonia, Jeconías‑ni nna bije Salatiel, Salatiel‑ni nna bije Zorobabel. ");
INSERT INTO zae_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel‑ni nna bije Abiud, Abiud‑ni nna bije Eliaquim, Eliaquim‑ni nna bije Azor. ");
INSERT INTO zae_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor‑ni nna bije Sadoc, Sadoc‑ni nna bije Aquim, Aquim‑ni nna bije Eliud. ");
INSERT INTO zae_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud‑ni nna bije Eleazar, Eleazar‑ni nna bije Matán, Matán‑ni nna bije Jacob. ");
INSERT INTO zae_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob‑ni nna bije José benne uka nubiyú ge María nan ge Jesús‑ni, delába Jesús benne anke Cristuha. ");
INSERT INTO zae_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Laxkala sitá (14) libixxi chi ute iki de Abraham‑ni nna atti uli David‑ni nna a sitá (14) libixxi chi ute iki de David‑ni, nianna tti dechekana ka benne Israel‑ni daka Babilonia, nna a sitá libixxi chi bedete iki de tti dechekana ka benne Israel‑ni daka Babilonia, la'anialiba tti uli Jesús benne anke Cristuha. ");
INSERT INTO zae_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Aní uka tti uli Jesucristuha: María nan geeha chiba du José‑ni rinnabe benneha ki utsá náke. Ttaka lanila tse'e len luesikeha nna Espíritu ge Tata Do Yebáha chila benie ki bija xi'in María‑ni. ");
INSERT INTO zae_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ttaka José benne biyú dhi María‑ni ankabe ttu benne runi latsiru attiba ankaba geni, laxkala labí raka lebie ugwebie María‑ni elhittu lo benne. Aníha uka nna belaba le José‑ni sigába udhá ikie benneha. ");
INSERT INTO zae_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ttaka atti chi rulaba lebie unie aníha nna bitsianie ttu ela. Lhe'e ela geeha nna uka xxe ttu anjeli ge Tata Xisiha nna ree bie: ―José, benne datia David, bittu gasinlu dhilu María‑ni, kumu binto nuje‑na Espíritu ge Tata Do Yebáha‑ba benie ki nuje bi'in‑na, ");
INSERT INTO zae_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","nianna gali ttu nuto biyú to nna kixxalu lábi Jesús, kumu labi odilábi ka benne lhe'esi gebi lo ka tulha ruinke. ");
INSERT INTO zae_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Iyá nuní uka ki gwado tisa ge nu ra Tata Xisiha profeta Isaías‑ni ki kixxi'enna ka benne. Profetaha nna utixxi'ana nuha, rana: ");
INSERT INTO zae_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ttu nuila ribani abittu bixa chi benna, nuha uja xi'inni. Nianna gali ttu nuto biyú to. Nutoha nna kixxake lábi Emanuel. (Emanuel dienna innána: Tata Do Yebáha doe len ri'i.) ");
INSERT INTO zae_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Atti beben José‑ni nna benbe attiba raba anjeli udhelha Tata Xisiha, uxíbe María‑ni udo lenie. ");
INSERT INTO zae_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ttaka labí bixa bedhaka José‑ni benneha nna uli bintoha. Bintoha nna utixxa José‑ni lábi Jesús. ");
INSERT INTO zae_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Atti rinnabia Herodes‑ni, la'ania uli Jesús‑ni lhe'esi Belén. Belén‑ni rena daka lo yu ge Judea. La'ania bisin ttu chupa ka nu tee elha rieni gekani, dákana daka ta riria ubisa nna bisinkana lhe'esi Jerusalén‑ni, ");
INSERT INTO zae_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","rinnaba tisakana, rákana: ―¿Gon‑ni tee binto si uli, delába bi'ini akabi nu innabiabi ka benne Israel‑ni? Kumu chi bilentu ttu beli runna liina gebi, biriana dana daka ta riria ubisa‑na. De nuha nna datu kini udú xibitu arlobi. ");
INSERT INTO zae_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Atti biyienin Herodes‑ni lhe iyába ka benne ge Jerusalén‑ni nu ra ka nuha, nianna bechacha ikikani nna bedúna kana. ");
INSERT INTO zae_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nianna tti bottupa Herodes‑ni ka nu loni ge ka bixxudiha lhe ka nu rule'ekinna ka nu Israel‑ni nu ra lo bia bennabi bodha'an Moisés‑ni, nianna tti unnaba tisana ka nuha, rana kana: ―¿Gá daka gali benne anke Cristuha? ");
INSERT INTO zae_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ka nuha nna bekabikana geni, rákana: ―Daka lhe'esi Belén ge Judea‑ni, niha teeki gali benneha kumu aníha ra lo ka yetsi ben profeta ge Tata Do Yebáha, ");
INSERT INTO zae_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","tti ree: Lu, lhe'esi Belén relu daka lo yu ge Judá, delo adí ka yiesi elha se'e daka Judá‑ni abittu akinlu deki lu ankalu ttu yiesi xka'aru. Kumu lagwi gelu iria ttu benne ake nu innabia. Benneha ku'e ka benne kiaha neda, delába ka benne Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodes‑ni nna ttúbana uxina ka nu tee elha rieni gekaniha, kini bina tsena nukaxattiga biria beliha. ");
INSERT INTO zae_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nianna udhelha ttebana ka nuha diakana Belén nna rana kana: ―Gwaltsia nna gwalinnaba tisa tsitsi ge nutoha. Ganna chi gwaxxakale bi nna etetixxi'enle neti kini anágaba neti nna tsiagabaa sadú xibia arlobi. ");
INSERT INTO zae_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ka nuha nna iki de chi biyienkinna nu ra Herodes‑ni, nianna ulu'u ttebakana neda diakana nna beli bilákinna biria daka ta riria ubisaha, daneruba nuha lokani. Bisinliba nuha ttu lii iki yo'o ata tee bintoha, la'anialiba nna gwalhedana. ");
INSERT INTO zae_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tti bilákin nu tee elha rieni gekaniha beliha, nianna yalhá itta bedúna lekani ");
INSERT INTO zae_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","nna tti uta'akana lhe'e yo'oha nna bilákinna bintoha len nan gebi María‑ni. Nianna bedú xibikani arlobi nna udhali ttebakana ro'o ka nu denkanaha nna begwekana bi oru lhe yala lhe seti nu rure ixixxi nu tee láni mirra lhe. ");
INSERT INTO zae_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tti chi beyeki ka nu tee elha rieni gekaniha deyyakana nna botseaba neda gekani kumu de lhe'e ela bitsiakinnaha ra Tata Do Yebáha kana: ―Bitturu eyekile etele ata do Herodes‑ni. ");
INSERT INTO zae_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Iki de chi bedá ka nu tee elha rieni gekaniha, nianna bedetsiani José‑ni ela. Lhe'e elaha nna bela'anie ttu anjeli ge Tata Xisiha nna ree bie: ―Ugwadha nna uche binto‑na lhe nan gebi‑na lhe, bexunni lenke nna ugía lenke daka Egipto. Niha‑ba tse'ele axtaliba ganna chi utixxi'ania lu, kumu Herodes‑ni idhelhana egilakana binto‑ni ki uttikana bi. ");
INSERT INTO zae_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aníha uka nna ugwadha tteba José‑ni lo relaha, chebie bintoha lhe nan gebiha nna ulu'u ttebake neda diake daka Egipto. ");
INSERT INTO zae_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Niha‑ba use'eke axtaliba atti chi utti Herodes‑ni. Aníha uka ki gwado tisa ge nu ra Tata Xisiha, tti benie ki unne benne uke profeta geeha, ree: “Egipto re Xi'iniaha, beyaxie.” ");
INSERT INTO zae_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodes‑ni nna tti ute denna deki benba le ka nu tee elha rieni gekaniha, labí liikinna eyekikana ki sattixxi'akinna na. Nianna bisa'a xxattinna nna benna mandadu kini gwettikana iyába ka nuto biyú to se'e lhe'esi Belén‑ni lhe ka nuto se'e lhe'e ka yiesi se'e abi'iba niha: iyába ka nuto ankakinna chupa ida lhe ka nu gwexxaru lhe. Aníha benna kumu bedaxxu ni'ani nu utixxi'a ka nu tee elha rieni gekaniha. ");
INSERT INTO zae_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aníha uka ki gwado tisa ge nu unne Jeremías benne uke profeta ge Tata Do Yebáha, tti ree: ");
INSERT INTO zae_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Lhe'esi Ramá biyien tsi'i ttu benne, rinnee lhe ribesi xxatte de releninie. Raquel‑niba nuha ribesina ge ka xi'inniha, labí rebe xen leni kumu de utti ka nuha. ");
INSERT INTO zae_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Iki de tti chi utti Herodes‑ni nna bedetsien José‑ni attu ela tti doe Egipto‑ni. Lhe'e elaha nna bodola'anie ttu anjeli ge Tata Xisiha. ");
INSERT INTO zae_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Anjeliha nna ree bie: ―Beyadha nna beche nuto‑na lhe nan gebi‑na lhe, nna beyya lo yu ge ka nu Israel‑ni kumu chiba utti ka nu ruinkana uttikana nuto‑na. ");
INSERT INTO zae_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aníha uka nna beyadha ttebe nna dechebie nutoha lhe nan gebiha nna deyyake besinke lo yu ge ka benne Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ttaka tti bina José‑ni deki Arquelao‑niba redennabiana itúba Judea, kumu bedína ladi tata geni Herodes, de nuha nna usibin José‑ni eyye daka Judea‑ni. Nianna tti bedetsianie attu ela. Lhe'e elaha nna utixxi'ani Tata Do Yebáha bie bixa anka nu unie. Aníha uka nna daka Galilea‑nila deyya ka José‑ni. ");
INSERT INTO zae_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tti besinke daka niha, nna gwatse'eke lhe'esi Nazaret. Aníha uka ki gwado tisa ge nu ra ka benne ukake profeta ge Tata Do Yebáha, tti ráke: “Benne anke Cristuha gatta lábie nazareno.” ");
INSERT INTO zae_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Bisia sá tti ulea lo Juan benne rugadi indaha rekie rigixxi'e ka tisa ge Tata Do Yebáha daka lo yu bisi ge Judea, ");
INSERT INTO zae_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ree ka benne: ―Gwalodúna le nna gwalodaxxu neda ge Tata Do Yebáha kumu chiba dabigana innabie. ");
INSERT INTO zae_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ge Juan‑niba nuha unne profeta Isaías‑ni, tti ree: Lo yu bisiha ata lanú benne se'e, niha riyien tsi'i ttu benne rinnebie idisa, ree: “Gwalegixxa tse neda ge benne anke Xxanari'iha. Gwalolixxa neda kini dhabie.” ");
INSERT INTO zae_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Itsa xo camelluba uka xo Juan‑ni nna udhí lhe'eni ttu yieti, nna nu xixxi ge betsirúba lhe kutsittaba lhe utona. ");
INSERT INTO zae_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ka benne daa lhe'esi Jerusalén‑ni lhe adíru ka benne daa lhe'e ka yiesi to se'e itúba Judea‑ni lhe, anágaba ka benne se'eke gaxxaba ro'o yoo Jordán‑ni, iyábake risinke ata reki Juan‑ni. ");
INSERT INTO zae_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nianna rigixxi'ake ge ka tulha ruinkeha nna rugadi Juan‑ni ke inda lhe'e yoo Jordán‑ni. ");
INSERT INTO zae_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ttaka tti bilenna ixeru ka fariseo lhe ka saduceo lhe risinkana ata dunaha kini ugadina kana inda, nianna tti rana kana: ―¡Aalexa nu ruin satsa! ¡Lebi'i ankale ttiba ka belha‑na! ¿Nú chi rana le deki gwalábale lo elha disa tsitsi nu chi dabiga ute Tata Do Yebáha gele? ");
INSERT INTO zae_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Gwaluni nu dika ixú ganna xa. Aníha kini ula'a deki gwalí chi bodúna le ge nu ruinle nna bodaxxule neda ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Abittu tse'ele ulaba lhi'u lele, akinle: “Ri'itu gwalábatu kumu de ankatu benne datiatu Abraham‑ni.” Netiru ria, Tata Do Yebáha ganna aka lebie, gwakaba gebie eyonie ka íyya du'uya nii kini eyakakana benne datia Abraham‑ni, a laa kila iyasanie le. ");
INSERT INTO zae_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Anágaba nna chigaba du tse iyyatteha kini ichúna itupa lhu ka yaga. Laxkala iyába ka yaga ka nu abittu utekana nu xixxi tse, ka nuha chúbakana nna iru'unakana tsiakana lo giha. Aníha‑ba nuha satele ganna abíba uinle nu dika ixú. ");
INSERT INTO zae_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Neti gwalí galá leni indaruba nuní rugadia le ki ula'a deki chi bodúna le nna bodaxxule neda ge Tata Do Yebáha, ttaka benne daa kwe'aha tsitsirula ra le benneha tti neti. Laxkala labí elha ralhaa ichea ka gwaracha geeha. Benneha ugadie le Espíritu geeha lhe ugadie le gi lhe. ");
INSERT INTO zae_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Chi den tse barkilu ge benneha kini uin tsebie xuxtilaha nna ganna chi bolhube siná nna ottupe xuxtilaha nna oga'abie xuaha ata rigua tsebie benneha. Nianna tti udelhe tee ge xuaha lo gi nu satíaba rite loniha, delába nu abittu reyola loniha. Lebi'i nuha udhake aníha. ");
INSERT INTO zae_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ttu sá udá Jesús‑ni lo yu ge Galilea nna diabie bisine ata du Juan‑ni ro'o yoo Jordán‑ni kini ugadine inda. ");
INSERT INTO zae_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ttaka Juan‑ni nna ridú disabana ugadine inda, nianna rane: ―Netila dika ugadilu inda; laa netila dalu ralu: “Begadi neti inda.” ");
INSERT INTO zae_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ttaka Jesús‑ni nna bekabie, ree: ―Begwelhaba aka aní nnanna, kumu aní chi ga'anani Tata Do Yebáha uinri'i. Aníha uka nna uxielhaba Juan‑ni begadina Jesús‑ni inda. ");
INSERT INTO zae_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iki de chi udie indaha nna beria ttebe lhe'e nuha. Looraha nna biyali tteba yebáha nna bilánie Espíritu ge Tata Do Yebáha ugwadie ttiba ttu becha ata dueha. ");
INSERT INTO zae_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nianna biyien tsi'i ttu benne yebáha, unnebie ree: ―Benne‑ni nuní anke Xi'inia rakati gebie. Benne‑ni runie nu ru'u lasia. ");
INSERT INTO zae_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nianna tti che Espíritu ge Tata Do Yebáha Jesús‑ni daka lo yu bisi ata lanú benne se'e, kini uin nu xxegwiha dhi yiene. ");
INSERT INTO zae_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iki de chi bette ubina lhe'ebie abittu utoe yetta delo chua (40) ubisaha lhe chua relaha lhe, nianna tti ugwetti bitunie. ");
INSERT INTO zae_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nu xxegwiha nna ruinna dhi yiene, nianna tti ubigana, rane: ―Ganna gwalíginlu ankalu Xi'in Tata Do Yebáha, usichu ka íyya se'e‑ni kini eyakakana yettaxtila ki golu. ");
INSERT INTO zae_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ttaka lee nna bekabie geni, ree: ―Lo ka yetsi ge Tata Do Yebáha dia ra: “Laa sunruga len yettaxtila aka ben ka benne, sinuki aka bengabake len iyába ka tisa rinne Tata Do Yebáha.” ");
INSERT INTO zae_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nianna tti che nu xxegwiha bie lhe'e yiesi anka le'aha, delába Jerusalén‑ni, nna ulhapine iki yotuha gwetsáli. ");
INSERT INTO zae_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nianna rane: ―Ganna si gwalíginlu ankalu Xi'in Tata Do Yebáha, biginnichu lo yuha, kumu lo ka yetsi geeha, dia ra: Tata Do Yebáha idhelhe ka anjeli geeha ki uyúke lu. Udoni lo náke lu kini abittu tsu'u ni'alu iki ka íyya. ");
INSERT INTO zae_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús‑ni nna bekabie geni ree: ―Lo ka yetsi ge Tata Do Yebáha rágaba: “Bittu dhi yielu Tata Do Yebaa benne anke Xxanaluha.” ");
INSERT INTO zae_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nianna tti dedeche nu xxegwiha bie iki ttu i'iya yadha xxatta, niha bele'enne iyába ka yiesi ra xxeni lekani se'e yiesi lo yu‑ni lhe bele'ene iyá nu tse tee gekani lhe. ");
INSERT INTO zae_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nianna tti rane: ―Iyába nu chi bela'ania lu‑na utea gelu ganna lu udú xibilu arloa nna utsá lolu neti. ");
INSERT INTO zae_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús‑ni nna bekabie geni ree: ―Nu reha ugía xa nu xxegwi, kumu lo ka yetsi ge Tata Do Yebáha, dia ra: “Sun arlo Tata Do Yebaa benne anke Xxanaluha, sun arlo benneha‑ba udú xibilu lhe suna nu innabe uinlu lhe.” ");
INSERT INTO zae_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aníha uka nna bedhan nu xxegwiha Jesús‑ni. Nianna tti bisin ttu chupa ka anjeliha nna bete náke lenbie. ");
INSERT INTO zae_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tti chi bina Jesús‑ni tekinna Juan‑ni lisiyya, nianna tti deyye daka Galilea, ");
INSERT INTO zae_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","bedábie lhe'esi Nazaret nna ugíe gwadhoe lhe'esi Capernaum. Yiesiha gaxxaba rena ro'o indatooha daka lo yu ge Zabulón lhe Neftalí lhe. ");
INSERT INTO zae_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Aníha uka ki gwado tisa ge nu unne Isaías benne uka profeta ge Tata Do Yebáha, tti ree: ");
INSERT INTO zae_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Lebi'i, ka benne se'ele daka lo yu ge Zabulón lhe Neftalí lhe, daka attu ladu ro'o yoo Jordán‑ni, ata rite neda dia daka ro'o indatooha, lebi'i ka nu se'ele daka Galilea ata se'eru ka benne labí ankake nu Israel, ");
INSERT INTO zae_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","lebi'i nuná ankale attiba ka benne se'e ata anka chulha. Nnanna nna chi bilenle ttu xiani xeni. Xianiha nuha udanie ge ka benne se'e ata ruxunnina geke gattike. ");
INSERT INTO zae_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Debá la'ania nna udulo Jesús‑ni rigixxi'anie ka benne, rabie ke: ―Gwalodúna le nna gwalodaxxu neda ge Tata Do Yebáha, kumu chiba dabigana innabia benneha. ");
INSERT INTO zae_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tti dia Jesús‑ni ridee saro'o indatoo ge Galilea‑ni, nianna bilánie yu'u chupa betsi ka nubiyú: ttu nuha lána Simón nu tegaba láni Pedro, attuna nna lána Andrés. Ka nubiyúha yu'ukana rudelhakana yexxa ge ka belhaha lhe'e indaha, kumu ankakana benne rudaxxu belha. ");
INSERT INTO zae_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nianna tti ree kana: ―Gwaltá gwetenalha neti. Neti unia kini akale ka nu gaxile ka benne kini udaxxuke neda ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Looraha tteba nna bese'e bixxikana ka yexxa gekaniha nna dia ttebakana danalhakane. ");
INSERT INTO zae_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","A lattiruba bededee, nianna bedelánie a chupa betsi ka nubiyú: ttu nuha lána Jacobo nna attuna nna lána Juan. Lakana nuha ankakana xi'in Zebedeo. Se'ekana len tata gekaniha lo barcu gekaniha reyoinkana ka yexxa ka nu rudaxxu lenkana belhaha. Jesús‑ni nna uxie kana. ");
INSERT INTO zae_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Lakana nna bedhá bixxi ikikani barcuha lhe tata gekaniha nna dia ttebakana danalhakana Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús‑ni ugwekie itúba daka Galilea‑ni rule'enie ka benne se'e niha ka tisa ge Tata Do Yebáha, rule'enie ke lhe'e ka yo'o ata rudhetike ka tisa ge Tata Do Yebáha. Niha rigixxi'e ka tisa tse, delába rigixxi'e gasina kini akake benne innabia Tata Do Yebáha ke, lhe anágaba reyonie ka benne yu'u iyá looba isagwe latike lhe reyoingabe iyába ata rilhen latike lhe. ");
INSERT INTO zae_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Itúba daka Siria chi ugwadhi tisa ge nu runie. Nianna tti risin lenke iyába ka benne ridakake iyá looba isagwe lhe ka benne rilhen latike lhe ka benne yu'u espíritu xxegwi latike lhe anágaba ka benne rakake beora lhe ka benne daa yatti latike lhe. Labie nna gwa reyoinbe ka benneha. ");
INSERT INTO zae_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ixe juisiru ka benne danalhake bie: ka benne daba daka Galilea lhe ka benne daba lhe'esi Jerusalén lhe ka benne daba lhe'e adíru ka yiesi se'e daka Judea‑ni lhe anágaba ka benne daba daka Decápolis lhe adíru ka benne daa lhe'e ka yiesi se'e attu ladu ro'o yoo Jordán‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tti bilani Jesús‑ni ixe juisiru ka benneha, nianna ugwapie lati ttu i'iya do niha, nna udoe. Ka benne rudhetinieha nna ubigake kwe'ebie. ");
INSERT INTO zae_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Labie nna uduloe rule'enie ke, nianna tti rabie ke: ");
INSERT INTO zae_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Karubáru ka benne riyasakanie ge Tata Do Yebáha, kumu lake nuná akake ka benne innabie ke. ");
INSERT INTO zae_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Karubáru ka benne ribesike de rateke ttu bixa, kumu Tata Do Yebáha godú ittabe leke. ");
INSERT INTO zae_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Karubáru ka benne abittu ra xxeni leke, kumu ka benne‑na nuná ralhake ulhenke yiesi lo yu‑ni kini akana geke. ");
INSERT INTO zae_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Karubáru ka benne raka leke uinke nu tse raka le Tata Do Yebáha, kumu gwasiaba sá gwakaba nu raka lekeha. ");
INSERT INTO zae_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Karubáru ka benne ratua leke adí ka benne, kumu anágaba lake gwa satuagaba le Tata Do Yebáha ke. ");
INSERT INTO zae_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Karubáru ka benne itú iki itú leke rudo leke Tata Do Yebáha, kumu lake nuná gwalákanie benneha. ");
INSERT INTO zae_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Karubáru ka benne ruinke ki tse'e tse len luesi ka benne kini abittu itilhake, kumu lake nuná ralhake gatta láke xi'in Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Karubáru ka benne ridú nookana ke de ruinke nu dika ixú, kumu lake nuná akake ka benne innabia Tata Do Yebáha ke. ");
INSERT INTO zae_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Karubárule ganna ttixka delo ni'a kia nna usia le ka benne le lhe dhu nookana le lhe anágaba iyá looba gwen lasi usiakana ikile lhe. ");
INSERT INTO zae_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Gwaledeakinle lhe gwaltse'e itta lhe, kumu xxeni anka nu ralhale edíle yebáha. Lebi'i gwa yúbale anágaba udú nookana ka profeta ge Tata Do Yebáha, delába ka benne use'e itú nu reha atti lanila galileha. ");
INSERT INTO zae_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Lebi'i nuná ankale ttiba ttu deti se'ele lagwi ge ka benne se'e yiesi lo yu‑ni. Ttaka ganna detiha unnitti ixe geni, la'ania nna, ¿galasina eyo nuha ixe ganna ttixka? ¿Laaba ganna tuttíru labíru ixú nuha? A sunruba kweari'i na nna ku'unari'i na, nianna tti ulea ka benne ikini. ");
INSERT INTO zae_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Anágaba, lebi'i nuná ankale ttiba ttu xiani kini rudenna ge ka benne se'e yiesi lo yu‑ni. Ankale ttiba ttu yiesi re lo ttu lhilhi rilá saabana, labí aka igatsina. ");
INSERT INTO zae_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nigaba lanú ttu benne do rugalhe iki ttu gi nu rudani, delo nna ukatsie ikini len ttu almoti. ¿Laaba ganna udole giha gwetsá kini udenna ge iyá ka benne se'e lhe'e yo'oha? ");
INSERT INTO zae_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Anágaba lebi'i latsiru gwaluni, kini elha ruin gele akana ttiba ttu xiani, kini anáchu tti iláni ka benne nu tse ruinleha, la'ania nna innáke: “Xxeniba ra le Tata gele do yebáha.” ");
INSERT INTO zae_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Bittu akinle deki bisiaya yiesi lo yu‑ni ki kuaya bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni lhe nigaba labí daya kini kuaya ka tisa bodha'an ka benne ukake profeta ge Tata Do Yebáha. ¡Ko'o! Sinuki dalaa kini unia ki sado tisa ge nu ra lo ka tisa bodha'aneha. ");
INSERT INTO zae_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Netiru ria, laka nnanna re yiesi lo yu‑ni lhe yebáha lhe, iyába nu ra lo bia bennabi‑na teeba ki aka nuná, niruba ttu tisa chika'a to abittu aka itua loni axtaliba ganna chi uka iyá nu ra lo bia bennabiha. ");
INSERT INTO zae_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Laxkala ttu benne ganna abittu udoe tisa ge ttu ka nu ra lo bia bennabi‑na, meskiba ankana ttu tisa xka'a, lhe ganna benneha gágabe ka benne abittu udoke tisa ge nu ra loni, benne unie aníha, arlo adí ka benne rinnabia Tata Do Yebáha labí xxeni ra lebie. Ttaka benne gudobe tisa ge nu ra lo bia bennabiha lhe gule'enie adí ka benne ki uinke nu ra loni, benne uni aníha, xxeni ra le benneha arlo adí ka benne rinnabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kumu netiru ria, ganna lebi'i abíba uin tserule tti ka fariseo‑ni lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni, la'ania nna labí akale benne innabia Tata Do Yebáha le. ");
INSERT INTO zae_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Lebi'i chiba biyieninle nu rákana ka benne uka xuttori'iha, tti rákana ke: “Bittu uttile ttu benne kumu benne uni elhuttiha, ibixxi iginniba benneha.” ");
INSERT INTO zae_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ttaka neti ria le: Iyába nu rise'enna len attu betsi to geri'i, urixxi ukinnigaba Tata Do Yebáha nuha, nna nu rusia leni attu betsi to geri'iha nna iso duba nuha arlo ka nu runi elhuxtisi geri'iha nna nu rigena iki attu betsi to geri'iha, nuha ralhabana tsiana lo giha. ");
INSERT INTO zae_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Laxkala ganna lu dialu utelu úna lo bekú ge Tata Do Yebáha, ttaka tti chi dulu niha, nna tadú lelu deki ritilhaba lenlu attu betsi to geri'iha, ");
INSERT INTO zae_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","niha besia úna cheluha nna beyyaxa gwayoin le betsi to geri'iha. Iki deliba nuha nna beyeki nna bete úna geluha. ");
INSERT INTO zae_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Ganna ttixka ttu nu ritilha lenlu diana taga'ana lu lo uxtisi, laka yu'u lenlu nuha neda diale isinle arlo ka nuha, jeru beyoin leni kini ka taga'ana lu lo xuedaha. Xuedaha nna utena lu lasi ná ka gwensinaha nna ka gwensinaha nna taga'akana lu lisiyya, ");
INSERT INTO zae_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","kumu netiru ria, labí lhaalu lhe'e lisiyyaha ganna abíba kixalu iyá xea belhiu nu innaba ka nuha. Gannaliba chi utixalu iyá nuha, la'anialiba nna chi ebeakana lu. ");
INSERT INTO zae_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Lebi'i chiba biyieninle nu rákana ka benne uka xuttori'iha, tti rákana ke: “Abittu isále nu subi subi nu labí ankana latselale.” ");
INSERT INTO zae_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ttaka neti nna ria le: Ganna ttu benne dha lebie ttu nuila atti ilánie na, la'ania nna ttisidiba chiba bisábie nuha de belaba lhi'u lebie aníha. ");
INSERT INTO zae_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Laxkala ganna si iyya lo benlu‑na uinna kini iginnilu uinlu tulha, tsa ttela ulea nuná nna uru'una na, kumu tserula saríana lu unnittilu ttu ka ni'a nálu, a laa kila ankalu ida'a tsialu lo giha, ");
INSERT INTO zae_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","nna ganna si ná benlu‑na abittuba daa siina nna ukinnina lu ki uinlu tulha, tsa ttela uchú nuná nna uru'una na, kumu tserula taríana lu unnittilu ttu ka ni'a nálu, a laa kila ankalu ida'a tsialu lo giha. ");
INSERT INTO zae_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Anágaba lhe rágabakana ka benne uka xuttori'iha, tti rákana ke: “Ganna ttu nubiyú udhá ikini nuila geniha, teeki ugwena nuha ttu yetsi ata rixxi'a deki chiba besilana len nuilaha.” ");
INSERT INTO zae_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ttaka neti ria le: Ganna ttu nubiyú kwentaba udhá ikini nuila geniha, ganna abittuba de bisá nuha attu nubiyú subi, la'ania nna la nubiyúha‑ba usigana nuilaha kini iginnina uinna nu satsa, nna ganna attu nubiyú edína nuila chi bedhá ikiniha, la'ania nna axtala nubiyú edína nuilaha, satsagaba nuha chi uin nuha. ");
INSERT INTO zae_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Anágaba lebi'i chigaba biyieninle nu rákana ka benne uka xuttori'iha: “Teeki uinle nu chi rale Tata Do Yebáha, abittu kwentaba udettile benneha.” ");
INSERT INTO zae_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ttaka neti ria le: Bittugaba udettile attu nuxa tti innále deki uinle ttu bixa, nigaba udettile yebáha, kumu niha nuha do Tata Do Yebáha rinnabie. ");
INSERT INTO zae_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Bittugaba udettile yiesi lo yu‑ni, kumu yiesi lo yu‑ni ankana ata rudú ni'abie. Nigaba udettile Jerusalén‑ni, kumu niha nuha anka lasi Tata Do Yebaa benne rinnabia xeniha. ");
INSERT INTO zae_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bittugaba utesale ikile‑na tti innále deki uinle ttu bixa, kumu lebi'i niru ttú itsa ikile labí aka gele uinle kini eyakana yadhi o eyakana sitsi. ");
INSERT INTO zae_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Lebi'i, ganna ttixka gwakaba gele uinle ttu bixa, la'ania nna ukare'aba gwalinná: “Gwakaba”, nna ganna ttixka abittuba aka gele uinle ttu bixa, la'ania nna ukare'aba gwalinná: “Labí aka.” Kumu ganna bixaru tisa udienle iki nu chi unneleha, la'ania nna ge nu xxegwiha‑ba chi anka nu raleha. ");
INSERT INTO zae_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Lebi'i chiba biyieninle rákana: “Ganna nuxa utse'e loona iyya lo ttu benne, anágaba nu beniha utse'e loogabakana iyya loni; nna ganna nuxa kweana laya ttu benne, anágaba nu beniha kweagabakana layani.” ");
INSERT INTO zae_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ttaka neti ria le: Abittu edú disale lo nu udhakana le ttu bixa. Ganna nuxa kweana gi daka xxaga ben gele, gwalodekila attu lha'a xxagale kini kweana gi. ");
INSERT INTO zae_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ganna nuxa taga'ana le lo uxtisi nna uinna kuana mixa geleha, gwalugwela na itupa jabana geleha, ");
INSERT INTO zae_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","nna ganna nuxa udo doelhana le ujale yua geniha ttu kilómetru, lebi'i gwalujala nuha chupa kilómetru. ");
INSERT INTO zae_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ganna nuxa innabana le ttu bixa, gwalugwe na nu innabanaha lhe ganna nuxa innaba gannana le ttu bixa, bittu innále: “Labí tee.” Gwalugwe ganna na nu rinnabanaha. ");
INSERT INTO zae_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Lebi'i chiba biyieninle rákana: “Akinle ge ka benne geri'i nna utía di lele ka nu bittu raka uyúkana le.” ");
INSERT INTO zae_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ttaka neti ria le: Akinle ge ka nu bittu raka uyúkana le lhe innabale len Tata Do Yebáha ki aka lenie ka nu rigekana ikile lhe anágaba latsiru gwalulisa ka nu ritisikinna le lhe gwalinnabala len Tata Do Yebáha ge ka nu rulisa xiikana le, lhe ka nu ridú nookana le lhe. ");
INSERT INTO zae_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Aníha uinle ki akale xi'in Tata gele do yebáha. Kumu benneha runie kini riria tatubisa‑na rudanie ge ka nu ruin satsa lhe ge ka nu ruin tse lhe. Anágaba lhe ruingabe kini raka iyya ge ka nu runi nu dika ixú lhe ge ka nu abittu runi nu dika ixú lhe. ");
INSERT INTO zae_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kumu ganna lebi'i sunruba rakinle ge ka nu gwa rakakinna gele, la'ania nna, ¿bíla nu tse edíle ge nu ruinleha ganna? ¿Laaba ka nu rukixakana belhiu nu rigixari'i len nu rinnabia ge Roma‑ni, anágaba ruin ka nuná? ");
INSERT INTO zae_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Lhe anágaba ganna sun tteruba ka benne gele gwa rale ke padiuxi, ¿bíla nu tse nuha ruinle ganna? ¿Laaba ganna anágaba ruin ka nu abittu ankabiakinna Tata Do Yebáha? ");
INSERT INTO zae_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Laxkala de nuha nna lebi'i satía gwaluni nu anka tse, ttiba Tata gele do yebáha satíaba runie taga'a nu anka tse. ");
INSERT INTO zae_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Gwaluyú gele. Ganna edá lele uinle ttu nu tse, abittu ula'a loole nu tse uinleha arlo adí ka benne. Bittu uinle aníha kiniba ilákanie deki yalhaba tse ruinle. Kumu ganna aníha uinle, Tata gele benne do yebáha labí ute benneha nu tse ralhale edíle. ");
INSERT INTO zae_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Laxkala lebi'i ttixka edá lele ugwele ka benne riyasakanie ttu bixa, bittu tse'ele doba ro'ole ge nu ruteleha. Bittu uinle tti ruin ka nu delo tisaba rula'akana deki yalhaba tse ruinkana, ka nuha doba ro'okani ge nu ruinkana tti ritupakana lhe'e ka yo'o ata rudhetiri'i ka tisa ge Tata Do Yebáha lhe anágaba ruinkana tti rekikana lo ka neda‑na. Aníha ruinkana kini inne tse benne gekani. Netiru ria, ukare'aba nu chi innekana tsekikanaha, nuha‑ruba nu tse ralhakana edíkana. ");
INSERT INTO zae_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ttaka ganna lebi'i edá lele ugwele ka benne riyasakanie ttu bixa, anuttu nu kixxi'enle ge nu tse ruinleha, ");
INSERT INTO zae_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","kini anáchu nu uteleha akana sigá. Aníha nna Tata gele do yebáha rilánie nu ruinle gatsiha, la'ania nna gutebe nu tse ralhale dhile. ");
INSERT INTO zae_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Lebi'i tti inne lenle Tata Do Yebáha, bittu uinle tti ruin ka nu labí liikinna. Ka nuná delo tisaba rinnekana len benneha kini ilen ka benne kana. Ka nuná yalhá ru'u lekani rise'e lii rákana tti rinne lenkana Tata Do Yebáha lhe'e ka yo'o ata rudhetiri'i ka tisa geeha lhe ata reyatsa ka neda‑na lhe. Ruinkana aná kini ilákin benne kana. Netiru ria, ukare'aba nu chi rinnekana, nuha‑ruba nu tse ralhakana dhíkana. ");
INSERT INTO zae_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ttaka lebi'i ttixka innele len Tata Do Yebáha, gwaleta'ala lhe'e yo'o geleha nna gwalodhea na, nna gwalinne len Tata gele do yebáha. Benneha ttúbe doe lenle lhe'e yo'oha nna gwa rilábanie nu ruinle gatsiha nna gutebe nu tse ralhale dhile. ");
INSERT INTO zae_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Tti innele len Tata Do Yebáha nna bittu satti balhaba odekile tisa nu abí ixú. Bittu uinle tti ruin ka nu labí ankabiakinna Tata Do Yebáha, kumu ka nuná rakakinna de rinne xxattakana nna gwayienbanie gekani. ");
INSERT INTO zae_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bittu uinle tti ruin ka nuná, kumu Tata gele do yebáha attili lani innabale lenie, chila yu benneha bixa riyasinle. ");
INSERT INTO zae_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lebi'i aní innále atti innele len Tata Do Yebáha: Tata getu do yebaa, ri'itu rugwetu lidhakalu kumu ankalu Diosi. ");
INSERT INTO zae_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Utá, unnabia ri'itu. Benchi kini yiesi lo yu‑ni aka nu redá le kwinalu, beni ttiba rakaba yebáha. ");
INSERT INTO zae_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bete benne gotu ttu ttu sá ");
INSERT INTO zae_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","lhe uxí elha xen lasi ge nu satsa ruintu ttiba ri'itu gwa ridíbatu elha xen lasi ge ka nu rudhaka satsakana ri'itu. ");
INSERT INTO zae_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bittu ugwelhalu ixú yietu uintu nu satsa. Bodiláttu ri'itu kini abittu iginnitu lo ná nu xxegwiha, kumu kwinalu satíaba ankalu benne rinnabia lhe ankalu benne ra tsitsi lelu lhe ra xxeni lelu ttu dia lii lhe. Amén. ");
INSERT INTO zae_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Kumu ganna lebi'i gwadíbale elha xen lasi ge ka benne bixa udhakake le, anágaba Tata gele do yebáha gwadígaba benneha elha xen lasi gele. ");
INSERT INTO zae_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ttaka ganna lebi'i abíba dhile elha xen lasi ge ka benne bixa udhakake le, anágaba Tata gele do yebáha labígaba dhi benneha elha xen lasi ge nu ruinle. ");
INSERT INTO zae_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Lebi'i tti utte ubina lhe'ele, bittu uinle tti ruin ka nu delo tisaba rudá si'i lokani ki utte daa ka benne deki rutte ubina lhe'ekani. Netiru ria, ukare'aba nu ruinkanaha. Nuha‑ruba nu tse ralhakana dhíkana. ");
INSERT INTO zae_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ttaka lebi'i tti utte ubina lhe'ele, gwalolhí te xea ikile lhe gwalikí xú lole lhe. ");
INSERT INTO zae_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Aníha kini abittu tte dani ka benne deki rutte ubina lhe'ele. Sinuki sun Tata gele do yebáha‑ba due lenle, sun benneha‑ba rilánie nu gatsi ruinleha, la'ania nna gutebe nu tse ralhale dhíle. ");
INSERT INTO zae_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Bittu udona lele uttupa xxattale elha tse gele yiesi lo yu‑ni, kumu yiesi lo yu‑ni tse'e looba ka nu uttupaleha: ga'aba belha dilha lhe'ekani lhe e'eya chenbakana lhe anágaba axtala ga'a ubana lhanana kana. ");
INSERT INTO zae_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lebi'i tserula gwaluttupa elha tse gele yebáha ata lanú belha dilha rali lhe labí re'eya chen ttu bixa kini ka utse'e loona nu uttupaleha, nigaba lanú ubana ga'a kini lhanana ka nuha. ");
INSERT INTO zae_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kumu ata gatta elha tse geleha, niha‑gaba nuha udo lele. ");
INSERT INTO zae_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Ka iyya lolu‑na ankakana ttiba ttu xiani ge latilu. Ganna ka iyya lolu‑na ankakana tse, delába ganna tseba rilákinna, la'ania nna itúba latilu tsu'u xiani gekani. ");
INSERT INTO zae_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ttaka ganna ka iyya lolu‑na abíba anka tsekana, la'ania nna ttisidiba itúba latilu anka chulha, delába ttiba ttu nu reki lhe'e chulha, aníha‑ba ankalu. Ganna nu dika aka xianiha eyakana chulha, la'ania nna gwa re bia chulha aka latilu. ");
INSERT INTO zae_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Lanú ttu benne do aka gebie kwenbie sina lo chupa xxane, kumu itisibanie ttu nuha nna attu nuha nna akanie geni, o udo tsitsibe tisa ge ttu nuha nna attu nuha nna ku'uba ni'e nu innána. Anágaba lebi'i labí aka gele kwenle sina lo chupa xxanale, delába labí aka udona lele kini gatta xxatta belhiu gele yiesi lo yu‑ni, lhe ixúgabale lo sina ge Tata Do Yebáha lhe. ");
INSERT INTO zae_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’De nuha nna neti ria le: Bittu tse'ele uchacha ikile ge nu gole lhe ge nu i'iyale kini aka benle. Nigaba uchacha ikile bixa ukule. ¿Laaba ganna rakarula doelha gwa anka benbale attichula nu gole? Lhe, ¿laaba ganna dakarula bela latile attichula nu ukule? ");
INSERT INTO zae_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gwaluyúruga ka nu bani to sia xxilakani reki lo be. Ka nuná labí rigu'ukana yiela, nigaba relapakana, nigaba laa rosia breta yieda gekani. Ttaka laa kiga de nuha nna Tata gele do yebáha gwa rugobe kana. Lebi'i, ¿laaba ganna adírula dakale tti ka nuná? ");
INSERT INTO zae_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Anágaba nna meskiba bika ruchacha xxatta ikile, laa de nuha‑ga nna itiaruinle tse'ele attu satti. ");
INSERT INTO zae_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Anágaba lhe, ¿beaka ruchacha ikile ge nu ukule? Gwalulanniruga ka iyya to daa lhe'exxi‑na gasina riyelhakana. Ka nuná labí ribenkana sina, nigaba ribeakana tuilu. ");
INSERT INTO zae_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Neti ria le, Salomón nu unnabiaha, meskiba uka nuha nu ra xxeni leni, labí bikuna lari rula'a latsitoru tti anka ka iyya to‑na. ");
INSERT INTO zae_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ki Tata Do Yebáha aná rugukue ka ixxi daa lhe'exxiha, ka nuha nasá ankakana ya'a nna uxxe gwisá nna chiba tsiakana itekana lo gi, anágaba lebi'i, ka nu abittu ria tsitsi lele, ¿laaba ganna adírula tse ugukue le? ");
INSERT INTO zae_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Laxkala bittu uchacha ikile innále: “¿Bíla gori'i?” lhe “¿bíla i'iyari'i?” lhe, o lhe “¿bíla ukuri'i lhe?” ");
INSERT INTO zae_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kumu ka nu abittu ankabiakinna Tata Do Yebáha, ge iyá nuní ruchacha ikikani, ttaka lebi'i Tata gele do yebáha gwa yube deki riyasinle iyá nuní. ");
INSERT INTO zae_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lebi'i, nu uinlale, lade'axa gwaluin doelha ki akale ka nu innabia Tata Do Yebáha lhe gwaluin nu dika ixú arloe lhe, la'ania nna gutebe iyába nu riyasinle. ");
INSERT INTO zae_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Laxkala lebi'i bittu uchacha ikile ge nu aka uxxeha, kumu uxxeha gwa tebana uchacha ikile ge nuha. Ukare'aba elhaxchacha iki tee geri'i ttu ttu sá. ");
INSERT INTO zae_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Bittu innele ge ka benne, gale ke: “¿Beaka anála ruinle?”, kini Tata Do Yebáha nna abittugaba udhake le aná. ");
INSERT INTO zae_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kumu ttiba ruinle rinnele ge ka benne, aníha‑gaba udhaka Tata Do Yebáha le. Attiba ruinle len adí ka benne, ttu luesi nuha‑gaba odekie ottebie gele. ");
INSERT INTO zae_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Lu, ¿beaka ridolu rulannilu biste yu'u lhe'e iyya lo betsi to geri'i‑na, delo nna a ridoxalu ugíalu yaga yu'u lhe'e iyya lolu‑na? ");
INSERT INTO zae_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Gasina galu ttu betsi to geri'i: “Begwelha kweaya biste yu'u lhe'e iyya lolu‑na”? Ki lu adírula xxeni anka yaga yu'u lhe'e iyya lolu‑na. ");
INSERT INTO zae_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Aaluxa nu rigí xú loni! Lade'axa ulea yaga yu'u lhe'e iyya lolu‑na kini anáchu nna ilá tsenlu ki kwealu biste yu'u lhe'e iyya lo attu betsi to geri'i‑na. ");
INSERT INTO zae_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Bittu udelhale nu anka le'a‑na lo ka beku‑na, kini ka eyekikana go ya'akana le nna uduyakana le, lhe bittugaba udelhale ka íyya raka galha, ka nu daka xxatta‑na lo ka kuchi‑na, kini ka uleakana iki ka nuná. Delába, bittu utele nu anka ge Tata Do Yebáha len ka nu abittu ugwekana lidhakani. ");
INSERT INTO zae_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Lebi'i, gwalinnaba len Tata Do Yebáha, benneha nna gutebe nu rinnabaleha. Gwalegila nna gwataxxakabale nu regilaleha. Gwalinne ro'o yo'oha nna gwadhalibakana ki ga'ale. ");
INSERT INTO zae_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kumu nuxaba benne ganna rinnabe ttu bixa nna gwa ridíbe nu rinnabeha nna nuxaba benne ganna regilee nna gwa raxxakabe nu regileeha. Anágaba nna nuxaba benne rinnebie ro'o yo'oha nna gwa ridhalibakana kini ra'abie lhe'e yo'oha. ");
INSERT INTO zae_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Lebi'i, ¿si gugwele ttu xi'inle ttu ka íyya du'uya lo neda ganna ttixka nuha rinnabana ttu yettaxtila ki gona? ");
INSERT INTO zae_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O, si ganna nuha innabana ttu belha gona, lebi'i nna, ¿si ugwelale nuha ttu belha ra'aya lhe'eni lo yu ki gona? ");
INSERT INTO zae_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ki lebi'i ankalale nu ruin satsa nna gwa rutebale nu tse rinnaba ka xi'inleha, ¿titiala Tata gele do yebáha, guteba benneha nu tse len ka benne ganna innabake lenie? ");
INSERT INTO zae_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Laxkala lebi'i gwaluin len ka benne ttiba raka lele uinke lenle, kumu aná ra lo bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni lhe ka tisa bodha'an ka benne ukake profeta ge Tata Do Yebáha lhe. ");
INSERT INTO zae_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Lebi'i gwaliga'a ro'o puerta nu anka suni ro'oniha. Kumu puertaha lhe neda nu rechena ka benne ata tse'e lookeha, bataru lhe xxeniru anka lo ka nuha nna ixe ka benne reta'ake niha. ");
INSERT INTO zae_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ttaka puerta ata reta'a ka benne aka benke ttu dia liiha, suniba anka ro'o nuha lhe neda nu rechena ke ata aka benke ttu dia liiha, tsitsiba anka ki eyyake lo nedaha. Laxkala ttu chuparuba ka benne gwa raxxakake puertaha lhe nedaha lhe. ");
INSERT INTO zae_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Gwaluyú gele ge ka profeta gwen lasi reki naa, ka nu rula'akana deki ankakana benne tse ttiba ttu neru runi tana, ttaka lhi'u lhe'e lastokani nna ankabakana ttiba ttu sageo ruin satsa. ");
INSERT INTO zae_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ka nuná ukare'aba elha ruin gekani gwalugía, la'ania nna chiba yule gasina ankakana. Kumu ttibanka lo ka lha xubaaya‑na, labí dika edíri'i uva lokani; nigaba lo ka ya yietsi‑na, labí dika edíri'i higu lokani. ");
INSERT INTO zae_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Aníha‑gaba yaga anka tseha, tsegaba anka nu xixxi rute nuha, ttaka yaga nu abittu anka tseha, abittugaba nu xixxi tse ute nuha. ");
INSERT INTO zae_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kumu ttu yaga tse, labí dika ute nuha nu xixxi abittu anka tse, nna yaga nu abittu anka tseha nna labí dika ute nuha nu xixxi anka tse. ");
INSERT INTO zae_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Laxkala iyába ka yaga ka nu abittu rute nu xixxi tse, chuba ka nuha nna tsiakana lo giha. ");
INSERT INTO zae_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","De nuha nna ka nu gwen lasi reki naa ukare'aba elha ruin gekani ugíale, la'ania nna chiba yule gasina ankakana. ");
INSERT INTO zae_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Labí iyá ka nu rákana neti: “Tata Xisi to kia”, labí iyá ka nuná eta'a ata rinnabia Tata kia do yebáha, sunruba ka nu rudokana tisa geeha, sunruba ka nuha gwa di eta'akana niha. ");
INSERT INTO zae_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ganna chi isia sá aka elhuxtisi ge ka benne se'e yiesi lo yu‑ni, la'ania ixebakana gákana neti: “Tata xisi to kia, ri'itu atti utixxi'atu ka tisa ge Tata Do Yebáha, luba bedettitu lhe lúgaba bedettitu atti bebeatu ka espíritu xxegwi lati ka benne lhe anágaba tti bentu ixe ka milagruha lhe.” ");
INSERT INTO zae_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Neti nna lhixxa rába ekabia gekani, upeya kana: “¡Ni tsa lanúle chi ankabiati! ¡Gwalukwitta kwe'a xa nu ruin satsa!” ");
INSERT INTO zae_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Laxkala iyába ka benne iyienkanie ka tisa kia‑ni nna udoke tisa gekani, ka benneha ankake ttiba ttu nubiyú rapa elha rieni nna bedona yo'o geniha iki ttu íyya. ");
INSERT INTO zae_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tti bisia iyyaha nna bisába ka yooha inda axtaba ubixxi ro'okani inda, lhe biriagaba ttu be idí nna gwatsu'una kwe'e yo'oha, ttaka yo'oha labí ubixxi nuha kumu tsitsiba do nuha iki íyyaha. ");
INSERT INTO zae_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ttaka iyába ka nu riyienkinna nu rinnea‑ni nna ganna abíba uinkana nu ria‑ni, ka nuha ankakana ttiba ttu nubiyú akaa elha rieni ikini nna bedona yo'o geniha lo yuxiha. ");
INSERT INTO zae_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Laxkala tti bisia iyyaha nna ubixxiba inda ro'o ka yooha lhe biria ttu be idí nna gwatsu'ukana kwe'e yo'oha nna bitampa tteba yo'oha. ¡Ttu ttiru bise'e loo nuha! ");
INSERT INTO zae_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tti chi uluxani Jesús‑ni unnebie nuha, iyába ka benne se'e niha bebanabakanie ge nu rule'enie keha, ");
INSERT INTO zae_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kumu labie rinnebe ttiba rinne ttu uxtisi rapa lo neda, labí rinnebie tti rinne ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni. ");
INSERT INTO zae_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tti beyadi Jesús‑ni lati i'iyaha dedee, ixeru ka benne danalhake bie. ");
INSERT INTO zae_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nianna tti ubiga ttu benne raka yiesu latie. Yiesuha tee láni lepra. Benne raka yiesu latieha nna bedú xibie arlo Jesús‑ni nna ree benneha: ―¡Tata xisi to, ganna lu aka lelu, gwadaabalu eyoinlu neti! ");
INSERT INTO zae_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús‑ni nna belhí nábie utane lati benneha nna ree: ―Gwaka galá lasia. ¡Nnanna, chinka beyaka! Looraha tteba nna betúa yiesuha lati benneha. ");
INSERT INTO zae_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nianna ra Jesús‑nie: ―Anuttu nu galu. Sinuki ugíala nna gwatso du lo bixxudiha nna bete úna nu daa lolu utelu ge Tata Do Yebáha. Beni attiba chi ga'anna lo bia bennabi bodha'an Moisés‑ni. Aníha kini uyú lokani deki chiba betúa isagwe‑na latilu. ");
INSERT INTO zae_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tti uta'a Jesús‑ni lhe'esi Capernaum‑ni, ttu soldadu baninna ttu gayua (100) ka soldadu ge Roma‑ni, nuha bisinna nna rinnaba ditibana lo Jesús‑ni, rane: ");
INSERT INTO zae_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","―Tata xisi to, nubiyú riben lo sina kiaha ttu tsaba tena lhe'e lisiaha daa yatti latini nna juisia ratena len isagwe geniha. ");
INSERT INTO zae_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús‑ni nna bekabie geni, ree: ―Neti gwaya'abaa eyonia nuha. ");
INSERT INTO zae_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Soldaduha nna bekabina, rane: ―Tata xisi to, neti labí elha ralhaa ga'a kwinalu lhe'e lisiaha. Niiliba dulu unne nna gweyakaba nubiyú riben sina kiaha. ");
INSERT INTO zae_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kumu neti ankagabaa nu rudoa tisa ge ka nu ra xxeniru lekani tti neti lhe anágaba nna rinnabiagabaa adíru ka soldadu. Laxkala tti upeya ttu ka nuha: “Ugía niha”, nuha nna gwa riabana nna tti rodopeya attu ka nuha: “Utá nii”, nuha nna gwa ritabana nna tti odopeya benne riben lo sina kiaha: “Ben nu tee‑ni.” Benneha nna gwa ruinbe nu xpeyeha. ");
INSERT INTO zae_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tti biyienin Jesús‑ni nu ra nu banina ka soldaduha, labie nna bebanabanie. Nianna tti ree ka benne danalhake bieha: ―Netiru ria, niru ttú ka benne Israel‑ni lanú chi gwaxxakaa ria tsitsi leke tti ria le nubiyú‑ni. ");
INSERT INTO zae_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Neti ria le, ixe ka benne dittu daa daka ta riria ubisa‑na lhe daa daka ata rito ubisa‑na lhe, ka benneha isiake ata rinnabia Tata Do Yebáha, tse'eke ro'o mexa goke yetta len Abraham‑ni lhe len Isaac‑ni lhe len Jacob‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ttaka ka nu Israel, ka nu chi ga'anna deki innabia Tata Do Yebáha kana, ka nuha de abittu ugía lekani, de nuha nna irialakana iru'unakana tsiakana ata anka chulhaha. Lhe'e chulhaha‑liba tse'ekana kwesikana lhe goniba lo layakani lhe. ");
INSERT INTO zae_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nianna tti ree soldadu nu baninna adí ka soldaduha: ―Chinka beyya. Gweyakaba nu kwitiha. Gwakaba attiba chi ugía lelu. Looraha tteba nna beyaka nu kwiti riben lo sina ge soldaduha. ");
INSERT INTO zae_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús‑ni diabie bisine lisi Pedro‑ni. Tti chi bisine niha nna gwaxxake nan ge nuila geniha teba benneha yu'e xilhaa. ");
INSERT INTO zae_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nianna tti utane kwe'e ná benneha nna beria tteba xilháha lati benneha nna ugwadha ttebe, benie nu uto Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tti chi dia ralhaha nna bisin lenkana ixeru ka nu yu'u espíritu xxegwi latikani ata du Jesús‑ni. Labie nna ukare'aba ttu unnebie nna bebeabie ka espíritu xxegwi yu'u lati ka nuha nna beyonie iyába ka nu raniha. ");
INSERT INTO zae_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aníha uka ki gwado tisa ge nu unne Isaías benne uke profeta ge Tata Do Yebáha, tti ree: “Benneha bedelha kwe'ebie ka isagwe geri'iha lhe bedelha kwe'ebie iyába nu rateri'i lhe iyába nu ridakari'i lhe.” ");
INSERT INTO zae_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tti bilani Jesús‑ni ixe juisiru ka benne chi bebi'ike abi'iba kwe'ebie, nianna tti bedhane ree ka benne rudhetinieha: ―Tsiari'i ilhári'i lo indatoo‑ni ki iriari'i ro'oni daka nu reha. ");
INSERT INTO zae_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nianna tti ubiga ttu ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni nna rane: ―Maestru, neti gwetenalhabaa kwinalu gaxaba tsialu. ");
INSERT INTO zae_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús‑ni nna bekabie geni, ree: ―Ka beda‑na siaba lisi ka nuná ata reta'akana lhe anágaba ka nu sia xxilakani reki lo be‑na, siagaba lixxu'in ka nuná ata rebiakana, ttaka neti benne daya yebáha labí do gaxa kixxa ikia. ");
INSERT INTO zae_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Attu benne rudhetinieha nna redenee: ―Tata xisi to, begwelhaxa eya'aya takatsia tata kiaha. Iki deliba nuha nna tti itaa etenalhaa lu. ");
INSERT INTO zae_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ttaka Jesús‑ni nna bekabie ge benneha, ree: ―Begwelha ka nu yattiha ukatsikana ka nu yatti gekaniha. Lu nna utá betenalha neti. ");
INSERT INTO zae_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nianna ugwapi tteba Jesús‑ni lo barcuha nna aníha‑ba danalha ka benne rudhetinieha nna biriake diake. ");
INSERT INTO zae_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Lo indatooha‑ba diake, ttiruba chi biria ttu iyya be idí, nna bedhú liina lo indatooha, axtaba iki barcuha ratsu'u indaha. Ttaka Jesús‑ni nna teba benneha te'adhie. ");
INSERT INTO zae_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ka benne rudhetinieha nna gwadibenke bie, ráke bie: ―¡Tata xisi to, bodiláttu ri'itu! ¡Karubá tsapiri'i inda‑ni nna gattiri'i! ");
INSERT INTO zae_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Labie nna bekabie geke, ree: ―Aalexa benne abittu ria tsitsi leni, ¿beaka rasi xxattinle? Nianna tti ugwadhe nna bedhaka dise beha lhe indatooha lhe, nianna siiba beyaka lo indatooha. ");
INSERT INTO zae_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ka benneha nna bebanabakanie, ra luesike: ―¿Nú anka benne‑ni nna axtaba be‑ni lhe indatoo‑ni lhe rudokana tisa gebie? ");
INSERT INTO zae_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tti chi biria Jesús‑ni ro'o indatooha nna bisine daka lo yu ge ka benne Gadara. Niha biria chupa ka nubiyú ata se'e ka baa ge ka benne yattiha yu'u espíritu xxegwi latikani nna betetsákana Jesús‑ni. Ka nuha yalhá satsa ruinkana, laxkala lanú kwenta retena lo neda tee niha. ");
INSERT INTO zae_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nianna tti uresi'akana, rákana: ―Lu, Xi'in Tata Do Yebáha, ¿bí raka lelu udhakalu ri'itu? ¿Si dáchilu kini ugwelu ri'itu elha disa? Ki labí chi bisia ura dhitu elha disa ralhatu. ");
INSERT INTO zae_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Gaxxa gaaba niha yu'u ixeru ka kuchi, ka nuha yu'ukana go. ");
INSERT INTO zae_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ka espíritu xxegwi yu'u lati ka nubiyúha nna unnabakana len Jesús‑ni rákane: ―Ganna ebealu ri'itu nna bedhelha ri'itu kini eta'atu lati ka kuchi yu'u‑na. ");
INSERT INTO zae_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Labie nna ree ka espíritu xxegwiha: ―Gwaleria gwaleyya ganna. Nianna beria ttebakana lati ka nubiyúha nna gwata'akana lati ka kuchiha. Ka kuchiha nna biria resu ttebakana diakana nna bisinkana ro'o ttu íyya daa niha, nianna biginnikana lhe'e indaha nna uttibakana. ");
INSERT INTO zae_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ka nu se'e lo ka kuchiha nna boxunni ttebakana deyyakana lhe'esiha nna iyába utixxi'akana. Utixxi'agabakana nu gwate ka nubiyú uyu'u espíritu xxegwiha latikani. ");
INSERT INTO zae_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nianna iyába ka benne lhe'esiha biriake gwatsáke Jesús‑ni. Tti bilákanie bie nna unnaba ditibake lenie kini eriabie lo yu gekeha nna eyye attu ta subi. ");
INSERT INTO zae_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nianna tti beyapi Jesús‑ni lo barcuha nna deyye betebie lo indatooha nna besine lhe'esi geeha. ");
INSERT INTO zae_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Niha bisin lenkana ttu benne daa yatti latie ata du Jesús‑ni, xuakinna benneha lo ttu breta. Tti bilani Jesús‑ni deki gwa riaba lekani gebie, nianna tti ree benne raniha: ―¡Xi'ini to, bodú itta lelu! Chiba uxía elha xen lasi ge ka tulha gelu‑na. ");
INSERT INTO zae_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ttu chupa ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni nna belaba lhi'u lekani rákana: “Nubiyú du nii, Tata Do Yebáha nuná rilhida gaana tti rinnena aná.” ");
INSERT INTO zae_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ttaka kumu Jesús‑ni rite dábanie nu rulaba lhi'u lekaniha, nianna tti ree kana: ―¿Beaka rulaba lele nu anka satsa? ");
INSERT INTO zae_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Gwalinnáchu, ¿bí nuha nu sattiru innári'i? ¿Si innári'i: “Chiba bixú elha xen lasi ge ka tulha gelu‑na” ak? o ¿innári'i: “Beyadha nna bedá”? ");
INSERT INTO zae_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ttaka nnanna ule'enia le kini uyú lole deki neti benne daya yebáha, yiesi lo yu‑ni gwa teeba lo neda kia ki dhia elha xen lasi ge ka tulha ruin ka benne. Nianna tti ree benne daa yatti latieha: ―Beyadha nna bodaxxu nu xualu loin‑na nna beyya lisilu. ");
INSERT INTO zae_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Benne biyúha nna beyadha ttebe deyye lisieha. ");
INSERT INTO zae_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ka benne saa niha, nna uka tébakanie tti bilákanie nu ukaha, nianna tti ráke: ―Xxeniba ra le Tata Do Yebáha de betebie lo neda ge ka benne se'e yiesi lo yu‑ni kini reyoinke ka benne rani. ");
INSERT INTO zae_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tti chi bedá Jesús‑ni ata dueha, deyu'ube neda deyye. Nianna bilánie ttu nubiyú lána Mateo dona ata rukixana belhiu nu daa lo ka benne rigixake ge Roma‑ni. Nianna tti ree Mateo‑ni: ―Utá betenalha neti. Nianna tti udú liina nna gwanalhane. ");
INSERT INTO zae_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tti chi do Jesús‑ni go yetta lhe'e lisi Mateo‑ni, ixeba ka gwekixa lhe adíru ka nu tekinna lákani deki ankakana ka nu ruin satsa, bisinkana nna use'ekana ro'o mexaha ro lenkane yetta. Niha‑gaba se'e ka benne rudhetinieha lhe. ");
INSERT INTO zae_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tti bilákin fariseo‑ni doe len ka nuha, nianna tti rákana ka benne rudhetinieha: ―¿Beaka ro maestru gele‑na yetta len ka gwekixa‑na lhe len ka nu ruin satsa‑na lhe? ");
INSERT INTO zae_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ttaka labie tti biyieninie nu ra ka nuha, nianna tti bekabie gekani, ree: ―Ka nu bittu rani‑na, labí riyasakin nuná nu eyoinna kana, sinuki ka nu rani‑na nuná riyasakinna nu eyoinna kana. ");
INSERT INTO zae_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gwaleyya nna gwalutte daa bí diani nu ra lo ka yetsi ge Tata Do Yebáha tti ree: “Neti raka lasia satua lele ka benne, laa rakaga lasia uttile ttu nimala nna utele na úna kia.” Laxkala neti labí daya raxia ka nu runi nu dika ixú; neti dalaa raxia ka nu ruin satsa kini odúna kana nna odaxxukana neda ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ka benne rudhetini Juan benne rugadi indaha, ubigake ata du Jesús‑ni nna ráke bie: ―¿Beakala ri'itu lhe ka fariseo‑na lhe rutte xxatta ubina lhe'etu a rotu, nna ka nu rudhetinlu‑na nna labí rutte ubina lhe'e ka nuná? ");
INSERT INTO zae_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús‑ni nna bekabie gekani, ree: ―Gwalinnáruga. ¿Laaba ganna labí dikana ka nu biyaxi dha'aha, tse'ekana ku'u elhutti ikikani laka du nubiyú rutsá nániha lenkana? Ttaka ganna chi bisia sá itua nubiyúha, anúruna dhu lenkana, la'anialigaba nna chi utte ubina lhe'ekani. ");
INSERT INTO zae_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Anágaba nna lanú ttu benne do rotábie ttu ro'o lari kubi ro'o xo yaxxu geeha, kumu ganna otábie nuha, la'ania nna galhiba lari kubiha ro'o lari yaxxuha, la'ania nna adíla satsa ireda xoeha. ");
INSERT INTO zae_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nigaba labí riga'akana vinu kubi lhe'e ka yieti yaxxu, kumu ganna aníha uinkana, la'ania nna ganna chi gala vinu kubiha nna itsúbana ka yieti yaxxuha, nna ilaliba vinuha lhe tse'e loogaba ka yietiha lhe. Laxkala teeki ita'a vinu kubiha lhe'e ka yieti kubi, kini aníha nna abittu tse'e loo ixpakana. ");
INSERT INTO zae_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Laka du Jesús‑ni rigixxi'anie ka benneha iyá nuha, nianna bisin ttu nu loni ge ka nu Israel‑ni, bedú xibini arloe nna rane: ―Xi'iniunná to kiaha si utti ttebi, ttaka ganna kwinalu italu ixxua nálu ikibi, la'ania nna gweyaka benbabi. ");
INSERT INTO zae_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús‑ni nna udú lii ttebe die len nubiyúha lhe diagaba ka benne rudhetinieha lhe. ");
INSERT INTO zae_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Laka yu'uke neda diake nna ttu benne nuila chi uka tsi'inu (12) ida ridoe reni, nianna tti ubige daka kwe'e Jesús‑ni nna gwattáne ro'o lari nuku benneha, ");
INSERT INTO zae_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","kumu belaba lebie, rakanie: “Kwadiba ro'o lari nuku Jesús‑ni dhaaya sattánaa, la'ania nna gweyakabaa.” ");
INSERT INTO zae_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús‑ni nna bodeki loe nna ree benne nuilaha: ―Bodú itta lelu xa xi'ini to. De ugía lelu deki gwadaabaa eyonia lu, de nuha nna chiba beyakalu. Looraha tteba nna beyaka nuilaha. ");
INSERT INTO zae_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tti bisin Jesús‑ni lhe'e lisi nu ankana nu loni ge ka nu Israel‑ni, niha bilánie ka benne se'e gwekwesi lhe ka benne se'e ribesi xxattake lhe. ");
INSERT INTO zae_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nianna tti ree ka benneha: ―Gwaleria nii, kumu nuila to‑ni laa uttiga bi'in‑ni, suna te'adhiba bi'in‑ni. Ttaka ka benne se'e niha nna ruxisilake gebie. ");
INSERT INTO zae_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Iki de chi bebeabie ka benne saa niha, nianna tti uta'abie nna bedaxxue ná nuila toha. Nuila toha nna beyadha tteba bi'iniha. ");
INSERT INTO zae_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nianna itúba ka daka niha ugwadhi tisa ge nu benieha. ");
INSERT INTO zae_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tti chi bedá Jesús‑ni niha, chupa ka benne a raka ilákanie danalhake bie, ribesi'abake ráke: ―¡Benne datia David, gwatuachi lelu ri'itu! ");
INSERT INTO zae_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tti chi uta'abie lhe'e yo'oha nna ubiga tteba ka benne xua lokeha ata dueha, nianna tti unnaba tise ka benneha, ree ke: ―¿Si gwa ria lele deki gwadaabaa eyonia le? Ka benneha nna bekabike ráke: ―Gwadaa galálu eyoinlu ri'itu xa tata. ");
INSERT INTO zae_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nianna tti utane ka iyya lo ka benneha nna ree ke: ―Kumu de gwa riaba lele kia nna gwakaba nu rinnabale‑na. ");
INSERT INTO zae_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nianna beyali tteba lo ka benneha. Jesús‑ni nna bodha'an tsitsie len ka benneha, ree: ―Nuttu nu kixxi'enle ge nu uka‑ni. ");
INSERT INTO zae_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ttaka ka benneha nna tti bedáke niha, nna utixxi'a ttebakanie ka benne se'e itúba ka daka niha ge nu ben Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Si bedá gaaba ka benne beyali lokeha lhe'e yo'oha, nianna tti bisin lenkana ttu benne anke biría, yu'u ttu espíritu xxegwi latie. ");
INSERT INTO zae_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tti chi bebea Jesús‑ni espíritu xxegwiha lati benne anka biríaha nna udulo tteba benneha unnee. Ka benne se'e niha, nna bebanabakanie nna ráke: ―Ni tsa labí chi bilenri'i aka ttu luesi nu uka‑ni lo yu ge Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ttaka ka fariseo‑ni nna rákana: ―Xxana ka espíritu xxegwiha‑ba rixuin nuná kini rebeana ka espíritu xxegwi lati ka benne‑na. ");
INSERT INTO zae_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Lhe'e iyába ka yiesi xeni‑na lhe lhe'e iyába ka yiesi xka'a to‑na lhe, lhe'e ka nuná ata sia ka yo'o ata rudheti ka benne ka tisa ge Tata Do Yebáha reki Jesús‑ni rule'enie ka benne, lhe anágaba rigixxi'agabe ka tisa tse, delába rigixxi'e gasina innabia Tata Do Yebáha ka benne, lhe anágaba nna reyoingabe iyá looba ka isagwe lhe ata rilhen latike lhe. ");
INSERT INTO zae_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tti bilani Jesús‑ni ixe juisiru ka benne se'e niha, nianna gwatua lebie ke kumu si'iba du leke lhe sun labake se'e, lanú tee ki edí edenna ke. Ankabake attiba ka neru to anú xxanakani tee ki uyúna kana. ");
INSERT INTO zae_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nianna rabie ka benne rudhetinieha: ―Yalhá ixeni lena tee exú, ttaka ka benne edíke lena‑ni ttu chuparubake raka, kumu ixeba ka benne se'e riyasakanie iyienkanie ka tisa ge Tata Do Yebáha, ttaka ka benne rigixxi'ake ka tisa geeha, ttu chuparubake raka. ");
INSERT INTO zae_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","De nuha nna gwalinnaba len Tata Do Yebáha, delába benne anke Xxana ka benne riyasakanie iyienkanie ka tisaha, kini idhelharue ka benne kixxi'akanie ke. ");
INSERT INTO zae_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús‑ni bottupe ka benne tsi'inu (12) rudhetinieha nna begwebie ke lo neda kini ebeake ka espíritu satsa yu'u lati ka benne lhe ebeake iyá looba isagwe lhe anágaba nna eyoingabake iyába ata rilhen lati ka benne lhe. ");
INSERT INTO zae_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nii dia lá tsi'inu (12) ka benne ukake apóstol geeha: Lade'a tte Simón benne tegaba labie Pedro, lhe betsie Andrés‑ni lhe. Nianna tti dia Jacobo‑ni lhe betsie Juan‑ni lhe. Ixpa ka benne‑ni ankake xi'in Zebedeo. ");
INSERT INTO zae_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nianna tti dia Felipe‑ni lhe Bartolomé‑ni lhe. Iki de nuha nna tti dia Tomás‑ni lhe Mateo benne uka gwekixaha lhe. Nianna tti dia Jacobo xi'ini Alfeo, nianna tti dia Tadeo. ");
INSERT INTO zae_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Iki de nuha nna tti dia Simón benne rákana Zelote. Nialiba nna tti dia Judas Iscariote nu betena Jesús‑ni lasi ná ka nu bettikaneha. ");
INSERT INTO zae_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús‑ni udhelhe iyába tsi'inu (12) ka benneha, nianna tti ree ke: ―Bittu tsiale ata se'e ka benne abittu ankake benne Israel, nigaba ga'ale lhe'e ka yiesi ata se'e ka benne Samaria. ");
INSERT INTO zae_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sinuki gwaltsiala ata se'e ka benne Israel, kumu lake ankake attiba ka neru chi biganna. ");
INSERT INTO zae_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gwaltsia nna gwalikixxi'a deki chiba dabigana innabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gwaleyoin ka benne rani lhe ka benne raka latike yiesu lepra nna gwalikua yiesuha latike, lhe anágaba gwaluin kini eyaka ben ka benne chi uttiha lhe gwalebeagaba ka espíritu xxegwi yu'u lati ka benne lhe. Lebi'i bittu ukixale ge nu uinleha, kumu kwentaba betea lo neda gele kini uinle iyá nuní. De nuha nna kwentagaba gwalute nu chi uxíleha. ");
INSERT INTO zae_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Bittu ichele yieti belhiu gele. ");
INSERT INTO zae_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nigaba ichele chuba gele, nigaba ichele chupa kwe xole ki otseale o ujale attu kwe gwaracha gele. Anágaba lhe bittugaba iche garroti gele. Kumu ttu nu riben sina ralhaba nuha ugokana na. ");
INSERT INTO zae_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Gaxaba lhe'e yiesi ga'ale, gwalegila gaxa do ttu benne, ttu benne nu dika uxxen lele gebie. Lisi benneha gwaleya'ana, axtaliba ganna chi edále niha, la'anialiba nna eriale lhe'e lisi benneha. ");
INSERT INTO zae_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ganna chi ga'ale lhe'e yo'o ata isinleha, gwalinnaba ki aka len Tata Do Yebáha ka benne se'e lhe'e yo'oha. ");
INSERT INTO zae_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ganna ka benne se'e lhe'e yo'oha gulabibake le, la'ania nna gwa ralhabake aka len Tata Do Yebáha ke, ttaka ganna ka benneha abittuba ralhake dhike nu unnabale len Tata Do Yebáha, la'ania nna nu unnabaleha eyekiba nuha lenle. ");
INSERT INTO zae_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ganna se'e ka nu abittu ulabikana le o abittu udo nagakani ge nu innále, la'ania nna gwaleria lhe'e yo'o gekaniha o si lhe'e yiesiha, nna gwalukubi ni'ale biste, kini nuha unna liina deki Tata Do Yebáha labí uyu'u lebie nu benkanaha. ");
INSERT INTO zae_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Netiru ria, la sá atti uin Tata Do Yebáha elhuxtisi ge ka benne se'e yiesi lo yu‑ni, la'ania gwa xea ttela elha disa tsitsi ugwebie ka benne se'e lhe'esi Sodoma lhe Gomorra lhe attichula elha disa ugwebie ka benne se'e lhe'e ka yiesi ata abittu belabike leha. ");
INSERT INTO zae_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Neti ridhelhaa le attiba ttu nu ridhelhana ka neru to diakana lagwi ge ka sageo. De nuha nna jeru tte gwalotsi'inu lele, gwaluin tti runi ka belha‑na ankakana kedha, lhe anágaba nna bittugaba inná xxeni lele; gwaluin tana tti ruin ka becha‑na. ");
INSERT INTO zae_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gwaluyú gele len ka benne kumu udaxxukana le nna saga'akana le lo ka uxtisi. Anágaba nna ukulhakana le lhe'e ka yo'o ata rudhetiri'i ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kumu delo ni'a kia nna axtala taga'akana le arlo ka nu rinnabia xeni‑na. Aníha kini gapale lo neda kixxi'enle kana kia lhe anágaba kixxi'agabinle ka nu abittu ankakana nu Israel lhe. ");
INSERT INTO zae_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ttaka ganna chi taga'akana le lo iyá ka nuní, la'ania nna abittu uchacha ikile ge nu ekabile lhe ge nu innále lhe, kumu loora tti inneleha nna guteba Tata Do Yebáha ka tisa len lebi'i kini ekabile gekani. ");
INSERT INTO zae_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kumu laa lebi'iga nuha innele, sinuki Espíritu ge Tata gele do yebáha‑ba nuha innee. ");
INSERT INTO zae_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’La'ania ka nu raka betsikaniha utekana ka betsikaniha lasi ná ka nu uttikana ka nuha, lhe aníha‑gaba uin ka xxudiha len ka xi'inkaniha. Ka xi'inkaniha nna eyekikana ebi'i nookana ka xxudikaniha nna uinkana kini gatti ka benneha. ");
INSERT INTO zae_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Lebi'i nna iyába ka benne utía di lekani le de ria lele neti. Ttaka benne dhaabie dhu tsitsie lo neda kia‑ni axtaliba ganna chi uluxa iyá nu akaha, benneha gwalábe. ");
INSERT INTO zae_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Lebi'i tti dhu nookana le lhe'e ttu yiesi, gwaluxunni nna gwaltsia lhe'e attu yiesi. Netiru ria, lebi'i labí chi uluxinle tsekile lhe'e iyá ka yiesi se'e itúba lo yu ge Israel‑ni atti chi esiaya neti benne daya yebáha. ");
INSERT INTO zae_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ttibanka ttu benne rudhetie nu rule'e ttu maestru, labí rakarula ge benneha tti maestru geeha. Nigaba ttu benne riben lo xxane, labí xxenirula ra lebie tti benne anka xxaneha. ");
INSERT INTO zae_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Benne rudhetiha ukare'aba isine ake attiba maestru geeha nna benne riben lo xxaneha nna ukare'agaba isine ake attiba xxaneha. Ganna neti tekinna láya nu xxegwi, ¿titiala innekana gele, lebi'i ka nu ankale kia? ");
INSERT INTO zae_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Laxkala abittu gasinle gekani. Kumu labí tee ttu nu igatsi abittu eselana; nigaba ttu nu aka sigá nna abittu una benne geni. ");
INSERT INTO zae_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nu rigixxi'ania le sigáha, gwaliria gwalikixxi'a na lo benne nna nu rinnea ro'o nagaleha nna gwaliria gwalinne na idisa ki iyienkin benne. ");
INSERT INTO zae_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bittu gasinle ge ka nu uttikana le yiesi lo yu‑ni, kumu ka nuná, sunruba bela latile‑na gwadaakana uttikana, labí aka ge ka nuná uttikana alma gele. Gwaligasilinle ge benne gwaka gebie utse'e looe alma gele‑na lhe bela latile‑na lo giha ata uyú ka benne elha disa ttu dia lii, ge benneha‑la gwaligasini. ");
INSERT INTO zae_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Ttibanka ka binni to‑na, ¿laaba ganna ukare'aba len ttu latti belhiu nna chiba rito'o chupakaba? Ttaka ni ttú ka bia toha, labí iginnikaba lo yu ganna Tata gele do yebáha abíba aka lebie. ");
INSERT INTO zae_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Anágaba lebi'i axtala ka itsa ikile‑na babanie. ");
INSERT INTO zae_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Laxkala bittu gasinle kumu lebi'i dakarulale attichula ixe ka binni to‑na. ");
INSERT INTO zae_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Nuxaba benne ganna dhi ro'e arlo ka benne deki gwa riaba lebie neti, anágaba neti arlo Tata kia do yebáha gwadígaba ro'a deki gwalíbanie ria lebie neti, ");
INSERT INTO zae_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ttaka nu abittuba dhi ro'oni arlo ka benne deki ria leni neti, anágaba neti abittugaba dhi ro'a arlo Tata kia do yebáha deki ria leni neti. ");
INSERT INTO zae_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Laa rakaginle deki bisiaya yiesi lo yu‑ni ki tse'e tse len luesi ka benne. ¡Ko'o! Labí daya ki tse'e tse len luesike, sinuki dalaa kini delo ni'a kia nna ttilha len luesike. ");
INSERT INTO zae_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kumu neti dalaa yiesi lo yu‑ni kini uttilhaa ka benne. Nu kwitiha ebi'i noona tata geniha nna xi'iniunnáha nna ebi'i noona nan geniha. Xolisiha nna ebi'i noona nan ge nubiyú geniha. ");
INSERT INTO zae_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Laxkala la ka nu se'e lhe'e yo'o geleha‑ba abittu aka uyúkana le. ");
INSERT INTO zae_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Nuxaba ttu benne ganna rakarulanie ge tata geeha lhe ge nan geeha lhe attichula neti, benne uni aníha labí ralha benneha ake kia. Lhe ttixka ttu benne ganna rakarulanie ge xi'in biyúeha lhe ge xi'iniunneha attichula neti, benne uni aníha labí ralha benneha ake kia, ");
INSERT INTO zae_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","nna ganna benne abíba uje kurusi gee etenalhe neti, delába ganna abíba eria iki eria lebie, meskila bixa udhakakane de etenalhe neti, benne uni aníha labí ralhe ake benne kia; ");
INSERT INTO zae_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","nna benne labí raka lebie bixa satebie de etenalhe neti, benneha nnittilee, delába labí aka ben benneha arlo Tata Do Yebáha ttu dia lii. Ttaka benne eria iki eria lebie etenalhe neti meskila bixa satebie delo ni'a kia, benneha gwalálee arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Nu ulabina leha, neti nuha ulabina, nna nu ulabina netiha nna benne udhelhe netiha nuha ulabina, ");
INSERT INTO zae_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","nna nu ulabina ttu profeta kumu de anka benne ulabinaha profeta, de nuha nna gwadíbana luesi nu tse ralha profetaha dhie nna nu ulabina ttu benne ruin latsiru, kumu de anka benne ulabinaha benne ruin latsiru, de nuha nna gwadíbana luesi nu tse ralha benneha dhie. ");
INSERT INTO zae_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Lhe nuxaba benne ganna ttixka utebie kwadiba ttu xiga inda idilha i'iya ttu ka benne abittu ra xxeni leke se'e nii, kumu de ankake benne danalhake neti, de nuha nna netiru ria, benne uni aníha chiba ralha benneha dhie nu tse ute Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tti chi uluxani Jesús‑ni utixxi'e bixa anka nu uin ka benne tsi'inu (12) rudhetinieha, nianna tti bedábie ata dueha, nna deyye lhe'e adíru ka yiesi se'e itúba ka daka niha. Lhe'e ka yiesiha ugwekie rule'enie ka benne lhe rigixxi'anie ke ka tisa ge Tata Do Yebáha lhe. ");
INSERT INTO zae_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Atti tee Juan benne rugadi indaha lhe'e lisiyyaha, bine ge nu runi Cristuha. Nianna tti udhelhe ttu chupa ka benne rudhetinieha ");
INSERT INTO zae_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kini gwannaba tisake, ráke bie: ―¿Si lu nuní Cristu benne chi ga'anna isia, o teeki kwedatu attu benne subi ak? ");
INSERT INTO zae_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús‑ni nna bekabie gekani, ree: ―Gwaleyya nna gwalikixxi'en Juan‑ni ge nu chi riyieninle lhe ge nu chi rilenle runia lhe. ");
INSERT INTO zae_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gwaligá na: Ka nu xua lokinna chiba relákinna lhe ka nu ridá natsa‑na chiba redá tsekana, nna ka nu raka yiesu lepra latikinna nna chigaba reyakakana, lhe anágaba ka nu anka kwechu‑na chigaba reyienkinna nna ka nu chi uttiha nna gwa reyaka bengabakana. Anágaba ka benne dii abittu geke tee chigaba riyienkanie ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Karubáru benne abittu rudú chupana lebie de rilánie nu runia‑ni! ");
INSERT INTO zae_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Laka reru'una ka nu rudhetini Juan‑ni deyyakana, nianna tti udulo Jesús‑ni rigixxi'anie ka benne se'e niha, rigixxi'anie ke ge Juan‑ni, ree ke: ―¿Bí biriale gwalannile lo yu bisi ata lanú benne se'e? ¿Si gwagíale ttu yettixtila ruttá beha na ak? ");
INSERT INTO zae_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ganna abíba nna, ¿núla nuha gwagíale ganna? ¿Si ttu nubiyú nukuna xo tse raka ragalha loni ak? ¡Ko'o! Neti ria, ka nu ruku xo tsekinna, lhe'e lisi ka nu rinnabia xeni‑naliba se'e luesi ka nuná. ");
INSERT INTO zae_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ganna abíba nna, ¿núla gwagíale ganna? ¿Si ttu profeta ge Tata Do Yebáha ak? Gwalí galá, neti ria, lebi'i biriale gwagíale ttu benne xxenirula ra lebie tti ttu benne anke profeta. ");
INSERT INTO zae_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ge Juan‑ni nuha rinne Tata Do Yebáha lo ka yetsi geeha tti rulise Xi'inieha, ree benneha: Neti idhelhaa ttu benne tsie nnerue lolu kini kixxi'e ka tisa kia‑ni. Benneha idhalie neda gelu. ");
INSERT INTO zae_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Netiru ria: delo iyá ka benne chi uli yiesi lo yu‑ni, labí chi biria ttu benne ra xxeniru lebie tti Juan benne rugadi indaha. Ttaka delo iyá ka benne rinnabia Tata Do Yebáha, benne ra gwexxaru leeha, xxenirula ra lebie tti Juan‑ni. ");
INSERT INTO zae_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan‑ni, ttili uduloe rigixxi'e ka tisa ge Tata Do Yebáha nna axtaba nnanna ixeba ka benne ruinke doelha akake benne innabia Tata Do Yebáha ke meskiba ttixa rateke nna sunruba ka benne re tsitsi leke gwa ridaake rakake benne rinnabie. ");
INSERT INTO zae_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kumu iyába ka profeta ge Tata Do Yebáha lhe bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni, debá nnanna do Juan‑ni gwa rigixxi'aruke ge nu aka. ");
INSERT INTO zae_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Naba lebi'i ganna si gweyya lele ge nu ria‑ni, Juan‑niba nuní anke Elías benne chi ga'anna esie. ");
INSERT INTO zae_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Ata sia nagale, gwaludo nagale ganna gwankale nu dika iyienini! ");
INSERT INTO zae_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Bí len utsania ka benne se'e nnanna? Ka benne se'e nnanna ankake attiba ka nuto rise'ekana rittakana ata raka i'iya‑na ribesi'en luesikani, rákana: ");
INSERT INTO zae_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ri'itu gwa bekwesibatu ka iyyaxtila getu‑ni, ttaka lebi'i nna abígaba beya'ale, lhe anágaba gwa bilhagabatu le'a ge ka benne yattiha nna lebi'i nna abígaba uresile.” ");
INSERT INTO zae_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","’Aná ria, kumu Juan‑ni bisiana, labí ri'a rona, lebi'i nna rálale: “Espíritu ge nu xxegwiha‑ba yu'u lati nuná.” ");
INSERT INTO zae_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nnanna nna neti benne daya yebáha bisiaya roa lhe ri'iyaa lhe, lebi'i nna redenálale: “Nuní ankana ttu nu ro xxatta lhe ankana ttu nu ri'a lhe. Rutsálana ka gwekixa lhe ka nu ruin tulha lhe.” Ttaka atti rilenri'i elha ruin ge ka xi'in Tata Do Yebáha, la'ania nna rite denri'i deki elha rieni rapa Tata Do Yebáha nuha rapa ka benneha. ");
INSERT INTO zae_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nianna tti udulo Jesús‑ni utise ka benne se'e lhe'e ka yiesi ata chi benie ixeru ka milagru. Utise kana kumu labí chi bodúna kana nna odaxxukana neda ge Tata Do Yebáha. Nianna tti ree kana: ");
INSERT INTO zae_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Gwalíchi lele xa benne lhe'esi Corazín, lhe gwalíchi lele xa benne lhe'esi Betsaida! Kumu ganna ttixka lhe'esi Tiro‑ni lhe Sidón‑ni lhe, chi uka ka milagru ka nu chi uka lagwi gele‑ni, ka nuha la nukala chi bodúna kana nna bodaxxukana neda ge Tata Do Yebáha ganna ttixka. Nianna tti uku xo ttipa gekani lhe udelha tee ikikani kini ula'a loo deki chi bodúna kana. ");
INSERT INTO zae_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Netiru ria: La sá atti uin Tata Do Yebáha elhuxtisi ge ka benne, la'ania adírula elha disa tsitsi ugwebie le, lebi'i ka benne lhe'esi Corazín lhe ka benne Betsaida lhe, attichula elha disa tsitsi uyú ka benne se'e lhe'e ka yiesi Tiro lhe Sidón lhe. ");
INSERT INTO zae_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Lebi'i nna ka benne lhe'esi Capernaum, ¿si rakinle deki yebáha‑li eyapile? ¡Ko'o! Neti ria, lhe'e belha'a chulhaha ata uyúle elha disaha‑li iginnile. Kumu ganna lhe'esi Sodoma‑ni uka ka milagru chi uka lagwi gele‑na, la'ania nna yiesiha abittula bise'e lo nuha, sa rerula nuha axta nnanna ganna ttixka. ");
INSERT INTO zae_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Netiru ria: La sá atti uin Tata Do Yebáha elhuxtisi ge ka benne, la'ania adírula elha disa tsitsi ugwebie le, lebi'i ka benne lhe'esi Capernaum attichula elha disa uyú ka benne lhe'esi Sodoma‑ni. ");
INSERT INTO zae_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nianna tti unne Jesús‑ni ree Tata Do Yebáha: ―Tata, kwinalu ankalu Xxana yebáha lhe yiesi lo yu‑ni lhe. Xxeni ra lelu kumu chi bele'elu iyá nuní len ka benne abittu tte raka geke nna bekatsilu nuní len ka nu yuu lhe len ka nu rite dárukinna lhe. ");
INSERT INTO zae_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Gwalí galá xa Tata, kumu anába uka le kwinalu aka. ");
INSERT INTO zae_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nianna ree ka benne se'e niha: ―Tata kiaha iyába chi betebie lasi náya lhe anágaba lanú nu gwalíga ankabienna neti benne ankaa Xi'inieha, sunruba Tata kiaha gwankabianie neti, lhe anágaba Tata kiaha lanú nu ankabienna benneha, sunruba neti benne ankaa Xi'inieha gwankabiatie lhe sunrugaba ka benne raka lasia ule'enia ke Tata kiaha kini uinbiake bie. ");
INSERT INTO zae_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","’Iyá ttele, lebi'i ata abitturu ruchíale lo nu ratele‑na lhe ata ruchacha xxatta ikile lhe, gwaltá len neti kini neti nna unia ki eyaka lele ge nu ratele‑na. ");
INSERT INTO zae_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gwaludo tisa ge nu rodha'anaa uinle lhe gwaludheti tti runia‑ni kumu neti ankaa ttu benne re besi lasia lhe labí ra xxeni lasia lhe. Ganna aníha uinle, la'ania nna xen su lasiba edú lele. ");
INSERT INTO zae_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kumu iyába nu rodha'anaa uinle, labí tsitsi anka nuní, gwadaabari'i udori'i tisa ge nuní. ");
INSERT INTO zae_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","La'aniagaba nuha dia Jesús‑ni ritebie lhe'e ka xuxtila se'e itúba ka daka niha la sá tti reyaka le ka benne Israel‑ni. Ka benne rudhetinieha nna chi ugwetti bituinke, nianna uduloke richekuke iki ttu chupa ka xuxtilaha nna roke benneha. ");
INSERT INTO zae_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tti bilani ka fariseo‑ni nu ruin ka benneha, nianna tti rákana Jesús‑ni: ―¡Biyúruga! Ka nu rudhetinlu‑ni ruinlakana nu labí ga'anna uinri'i lhe'e ka sá atti reyaka leri'i. ");
INSERT INTO zae_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús‑ni nna bekabie gekani, ree: ―¿Si labí chi belabale lo ka yetsi ge Tata Do Yebáha ata rigixxi'a bí ben David‑ni itupa lenie ka benne se'e lenieha tti bituinkeha? ");
INSERT INTO zae_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Laaba ganna David‑ni gwatta'abie lhe'e yotu ge Tata Do Yebáha nna gwaxxíe ka yettaxtila sia niha, kini uto lanie ka benne se'e lenieha, delába ka yettaxtila ka nu chi riesike akake sun tteba ge Tata Do Yebáha, ka nu labí ga'anna goe lhe nigaba ka benne se'e lenieha lhe, sinuki sunruba ka bixxudiha gwa ga'anna gokana benneha. ");
INSERT INTO zae_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Si abittugaba chi belabale lo bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni ata rigixxi'a deki labí dika kwen ka benne sina tti risia ka sá eyaka leri'i? Ttaka ka bixxudiha ribenbakana lhe'e yotuha meskiba la sáha ankana la sá reyaka leri'i nna labí rujakana yua ge nu ruinkanaha. ");
INSERT INTO zae_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ttaka neti ria le, nii du ttu benne xxenirula ra lebie tti yotuha. ");
INSERT INTO zae_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ganna ttixka lebi'i rite denle bí diani nu ra Tata Do Yebáha lo ka yetsi geeha, tti ree: “Neti raka lasia satua lele ka benne, laa rakaga lasia uttile ka nimala kini utele úna kia.” Ganna ttixka lebi'i rite denle nuní, la'ania nna abittula rusiale iki ka benne abittu ruin tulha. ");
INSERT INTO zae_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kumu neti benne daya yebáha, netiba ankaa xxana ka sá reyaka leri'i. De nuha nna gwa teeba lo neda kia innía bixa dika uinri'i lhe'e ka sá reyaka leri'i. ");
INSERT INTO zae_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Bedába Jesús niha nna ute'e lhe'e yo'o ata rudheti ka benne Israel‑ni ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lhe'e yo'oha re ttu benne daa yatti ttu lha'a nábie. Nianna unnaba tisakana Jesús‑ni, rákane: ―¿Si gwa ga'anaba eyoinri'i ttu benne rani la sá reyaka leri'i? Aníha rákane kumu regila lekani bixa usiakana ikie. ");
INSERT INTO zae_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Labie nna bekabie gekani, ree: ―Ganna ttixka ttúle du ttu neru gele nna iginni nuha lhe'e ttu yiela inda la sá tti reyaka leri'i, ¿laaba ganna teeki ebeale neruha lhe'e yielaha meskiba la sáha ankana sá tti reyaka leri'i? ");
INSERT INTO zae_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Laaba ganna adírula daka ttu benne attichula ttu neru? Laxkala gwa ga'anaba uinri'i ttu nu tse lhe'e ka sá tti reyaka leri'i. ");
INSERT INTO zae_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nianna tti ree benne biyú daa yatti neeha: ―¡Belhí nálu! Benneha nna belhí tteba nábie nna beyaka tteba nuha; beyakabana atti tteba anka attu lha'a neeha. ");
INSERT INTO zae_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ttaka ka fariseo‑ni tti beriakana lhe'e yo'oha nna udulo ttebakana regila lekani gaxasina uinkana kini uttikana Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tti chi bina Jesús‑ni ge nu rulha le ka fariseo‑ni udhakakane, nianna bedá ttebe niha, nna deyye attu ta subi. Aníha‑ba danalha ixe juisiru ka benne nna reyonie iyába ka benne raniha. ");
INSERT INTO zae_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nianna bedha'an tsitsie, rabie ka benneha: ―Anuttu nu kixxi'enle kia. ");
INSERT INTO zae_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aníoka kini gwado tisa ge nu unne profeta Isaías‑ni tti utixxi'e nu ra Tata Do Yebáha, tti ree: ");
INSERT INTO zae_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nii chi du ttu benne ixúti lo sina kia. Benne‑ni nuní chi bekwea kini ixútie. Lee nuní rakati gee lhe ru'u lasia nu runie lhe. Neti ku'a Espíritu kia‑ni latie, labie nna tsekie kixxi'anie iyába ka benne se'e lhe'e ka yiesi se'e itúba yiesi lo yu‑ni, kixxi'anie ke gasina unia ki saría tsena ke. ");
INSERT INTO zae_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Benneha labí uttilha ro'e len ka benne, nigaba tsekie innebie idisa. Nuttugaba nu iyieninna tsi'e lo ka neda‑na. ");
INSERT INTO zae_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Benneha labí utse'e looe ka benne abittu ra tsitsi leke, lhe nigaba labí bixa udhake ka benne chi ratú leke. Aníha unie axtaliba kini dhaabie aka iyá nu anka tse itúba yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","La'ania nna iyá xeaba ka benne se'e yiesi lo yu‑ni uxxen leke gebie. ");
INSERT INTO zae_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ttu chupa ka benne bisinke ata du Jesús‑ni, cheke ttu benne xua loe lhe anke biría de yu'u espíritu xxegwi latie. Lee nna gwa beyoinbe benneha, laxkala gwa belábin benneha lhe gwa bennebe lhe. ");
INSERT INTO zae_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iyába ka benne bebanabakanie tti bilákanie nu benieha, nianna tti ra luesike: ―¿Si laaba nubiyú du‑niba nuha ankana nu datiana David‑ni? ");
INSERT INTO zae_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ttaka tti biyienin ka fariseo‑ni nu ra ka benneha, nianna tti rákana: ―Nubiyú‑ni, Beelzebú nu anka xxana ka espíritu xxegwiha‑ba rixuin nuní kini ridaana rebeana ka espíritu xxegwi yu'u lati ka benne. ");
INSERT INTO zae_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ttaka kumu Jesús‑ni gwa rite dábanie nu rulaba lekaniha, nianna tti ree kana: ―Ganna ka benne se'e lhe'e ttu yiesi se'e la'ake de ritilha len luesike, la'ania nna yiesiha tse'e looba nuha lhe ganna ka benne se'e lhe'e ttu yo'o se'e la'ake de ritilha len luesike, la'ania nna labíru uchía ka benneha tse'eke lhe'e yo'oha. ");
INSERT INTO zae_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Anágaba nu xxegwiha, ganna ttixka la labana ebeana ka luesi xxegwi‑niha, la'ania nna chiba tse'e la'a len luesi ka nuha. Ganna aníha uinkana, la'ania nna, ¿galasina aka ge nu xxegwiha innabiaruna ganna? ");
INSERT INTO zae_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Lebi'i rale deki neti rixúti xxana ka espíritu xxegwiha ki rebeaya ka espíritu xxegwi yu'u lati ka benne, ganna aníha runia nna ka benne rudhetinle‑na nna, ¿si nu xxegwiha‑gaba rixúkinna kini rebeakana ka espíritu xxegwi yu'u lati ka benne? Ganna ka nuná innákana labí rixúkinna nu xxegwiha, la'ania nna lebi'i ruinba lele, labí lii nu rale‑na. ");
INSERT INTO zae_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ttaka kumu neti Espíritu ge Tata Do Yebáha‑ba rixúti ki rebeaya ka espíritu xxegwi yu'u lati ka benne, nuha runna liina deki chiba bisia Tata Do Yebáha len lebi'i kini innabie le. ");
INSERT INTO zae_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Ttibanka ttu ubana, ¿gasina ga'ana lhe'e lisi ttu nubiyú ankana tipa ki lhanana ka nu se'e lhe'e lisi nuha? ¿Laaba ganna lade'axa udaxxuna nubiyú anka tipaha nna uxxikana nuha? Aníha‑ruba nna ki dhaana lhanana ka nu se'e lhe'e lisi nuha. ");
INSERT INTO zae_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Laxkala nu abittu du lenna netiha, nuha rigu'uba ni'ani neti nna nu abittu rute náni len netiha ki ottupatu ka benne lo neda ge Tata Do Yebáha, nuha urio lálana ka benneha. ");
INSERT INTO zae_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’De nuha nna ria le: Tata Do Yebáha gwadíbe elha xen lasi ge iyába tulha ruin ka benne lhe ge iyába nu satsa rinneke lhe, ttaka ganna inne satsake ge Espíritu geeha, ka benneha labí elha xen lasi geke gatta. ");
INSERT INTO zae_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nuxaba benne ganna inneke kuake bala'ana kia, neti benne daya yebáha, ka benneha gwaxúba elha xen lasi geke, ttaka ka benne inne satsake ge Espíritu ge Tata Do Yebáha, ka benneha labí elha xen lasi geke gatta, ni yiesi lo yu ata se'eri'i nnanna, nigaba ata esinri'i nu si daa. ");
INSERT INTO zae_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Ganna ttu ya xixxi anka tsena, la'ania nna tsegaba anka nu xixxi utena nna ganna ttu ya xixxi abíba anka tsena, la'ania nna abígaba tse anka nu xixxi utena. Kumu ka yaga‑na, ukare'aba nu xixxi ribia lokinna, runna liina gasina ankakana. ");
INSERT INTO zae_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Aalexa nu ruin satsa! Lebi'i ankale ttiba ka belha‑na. ¿Gasina aka gele innele nu anka tse, ki lebi'i nu ruin satsaba ankale? Kumu nu re lhe'e lastobale, nuha‑ba riria ro'ole rinnele. ");
INSERT INTO zae_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kumu benne re tse leeha rinnebe nu tse reba lhe'e lastobie, nna nu re satsa leniha nna rinnegaba nuha nu satsa reba lhe'e lastoni. ");
INSERT INTO zae_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ttaka neti ria le, ganna chi bisia sá uin Tata Do Yebáha elhuxtisi ge ka benne, la'ania ge iyába ka tisa a ixú unnekeha, kixxi'ake. ");
INSERT INTO zae_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kumu benneha‑ba unie elhuxtisi ge iyá nu unneke: ganna unneke tisa tse nna gwa saría tsegabana ke nna ganna unneke tisa satsa nna ibixxi iginnibake. ");
INSERT INTO zae_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ttu chupa ka fariseo‑ni lhe ttu chupa ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni rákana Jesús‑ni: ―Maestru, ri'itu raka letu ilentu uinlu bixa ttu milagru kini ula'a deki gwalí Tata Do Yebáha udhelhe lu. ");
INSERT INTO zae_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Lee nna bekabie gekani, ree: ―Lebi'i ka nu ruin satsa se'e nnanna lhe chi rudhá ikile Tata Do Yebáha nna riala lele attu nu subi, lebi'i rinnabale kini ula'ania le ttu bixa milagru, ttaka labíru bixa attu milagru ula'ania le, sunruba luesi nu gwate Jonás benne uke profeta ge Tata Do Yebáha, sunruba luesi nuha gula'ania le. ");
INSERT INTO zae_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kumu ttiba gwate Jonás‑ni uyu'una lhe'e belha bartoha tsunna ubisa lhe tsunna ela lhe, anágaba neti benne daya yebáha, tsunna ubisa lhe tsunna elagaba tsu'a lhi'u yuha. ");
INSERT INTO zae_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ganna chi isia sá uin Tata Do Yebáha elhuxtisi ge ka benne se'e yiesi lo yu‑ni, la'ania ka benne use'e lhe'esi Nínive‑ni eyadhake lo elhuttiha nna ukinnike ka benne se'e nnanna. Kumu ka benneha gwa bodúbana ke nna bodaxxuke neda ge Tata Do Yebáha tti biyienkanie ka tisa utixxi'a Jonás‑ni. Nnanna nna nii du ttu benne xxenirula ra lebie tti Jonás‑ni nna a ria lele gebie. ");
INSERT INTO zae_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Anágaba nuila unnabiana ka yiesi se'e daka Sabá, ganna chi isia sá uin Tata Do Yebáha elhuxtisi ge ka benne se'e yiesi lo yu‑ni, nuha eyadhagabana lo elhuttiha nna ukinnigabana ka benne se'e nnanna. Kumu lana idittuli dana nna betedo nagani ge elha rieni upa Salomón‑ni. Nnanna nna nii du ttu benne xxenirula ra lebie tti Salomón‑ni. ");
INSERT INTO zae_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Ttixka ttu espíritu satsa reriana lati ttu benne nna rekibana lo yu bisiha regilana ata eyaka leni, ttaka tti abittuba raxxakana, ");
INSERT INTO zae_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nianna rana: “Eyekichilaa eya'aya lisia ata biriayaha.” Tti besinnaha nna gwaxxakana benne beriana latieha, chi doe anke attiba ttu yo'o chi luba ra lhe'eni lhe chi yapa te xea lhe'eni lhe. ");
INSERT INTO zae_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nianna tti tsiana taxxína a gasi ka espíritu xxegwi ka nu satsarula ruinkana tti lana, nianna tti ga'akana tsu'ukana lati benneha. Benneha nna adírula satsa unie attichula tti benie sisi'a tteha. Aníha‑gaba sate ka nu ruin satsa se'e nnanna. ");
INSERT INTO zae_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Laka du Jesús‑ni rinnebie len ka benne saa lhe'e yo'oha, nan geeha lhe ka betsieha lhe se'eke lali'a ge yo'oha nna raka leke inne lenke bie. ");
INSERT INTO zae_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ttu benne du niha nna gwattixxi'anie Jesús‑ni, ree bie: ―Nan geluha lhe ka betsiluha lhe raka leke inne lenke lu. Neke se'e ro'o yo'o‑ni. ");
INSERT INTO zae_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Lee nna bekabie ge benne gwattixxi'a, ree benneha: ―¿Núnna anka nan kia lhe núnna anka ka betsia lhe? ");
INSERT INTO zae_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nianna tti bele'e Jesús‑ni ka benne rudhetinieha nna ree: ―Ka benne se'e nii nuní ankake nan kia lhe betsia lhe, ");
INSERT INTO zae_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","kumu nuxaba benne ganna runie nu ru'u le Tata kia do yebáha, benneha nuha anke betsia lhe danaa lhe nan kia lhe. ");
INSERT INTO zae_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","La sáha‑gaba biria Jesús‑ni lhe'e yo'oha nna die gwadhoe ro'o indatooha. ");
INSERT INTO zae_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nianna tti bitupa ixe juisiru ka benne. Laxkala labie teeki ugwapie lo ttu barcu daa niha ki udoe. Ka benneha nna ata daa ro'o indatooha‑liba use'eke. ");
INSERT INTO zae_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ge ixeba nu utixxi'anie ke. Aníha runie kini utte dáke bí diani nu raka lee kixxi'anie keha, nianna tti ree: ―Ttu benne ruin sina birie die gwedelha xuxtila. ");
INSERT INTO zae_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tti dabie gwedelha xuxtilaha nna adí benneha utse ro'o nedaha, nianna tti biginni ka binniha nna bediga ttebakana benneha. ");
INSERT INTO zae_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Attu chupe nna utse lo íyya atta'a ata labí gwadilo yu do. Benneha gwa be'eyu ttebe, ttaka kumu de labí rea xua yuha niha, ");
INSERT INTO zae_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","de nuha nna tti biria tatubisa nna bette ttebe benneha. Kumu de labí lhi'u dia lhue, de nuha nna ubisi ttebe. ");
INSERT INTO zae_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Attu chupe nna utse lhe'e yietsiha, ttaka yietsiha biyelhabana nna belhiubinna benneha. ");
INSERT INTO zae_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ttaka adí ka xuaha nna gwa ubinnibake ata do yu tse nna yalhá lhe'e lena bete benneha. De gayua (100) lhe de gayuna (60) lhe de rerua (30) tteba xua bekudhi iki ttu ttu ka benneha. ");
INSERT INTO zae_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Ata sia nagale, gwaludo nagale ganna gwankale nu dika iyienini! ");
INSERT INTO zae_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ka benne rudhetinieha nna ubigake unnaba tisake Jesús‑ni, ráke bie: ―¿Beaka lhixxa rába a rigixxi'enlu ka benne nu raka lelu utte dáke? ");
INSERT INTO zae_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Lee nna bekabie, ree: ―Lebi'i gwa ruinba Tata Do Yebáha ki tte denle nu labí yu adí ka benne, delába gwa ruinbe ki tte denle gasina innabie. Adí ka benne nna labí runie kini utte dáke. ");
INSERT INTO zae_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kumu benne gwa rite daniha, gwadírula benneha elha rieni ki tte da chiettirunie. Ttaka benne abí rite daniha nna axtala nu ttu latti chi ute danieha etua. ");
INSERT INTO zae_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","De nuha nna labí lhixxa rá rigixxi'ania ka benne, kumu meskiba bika rulannike nna labí rilákanie lhe meskiba bika rudo nagake nna labí riyienkanie, nigaba a rite dákanie. ");
INSERT INTO zae_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nu rate ka benne ruin aní rado tisa ge nu unne Isaías‑ni lo ka yetsi ge Tata Do Yebáha, tti ree: Meskiba bika rudo nagale nna labí tte denle; lhe meskiba bika rulannile nna labí ilenle. ");
INSERT INTO zae_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kumu ka benne‑ni tsitsiba ruin lastoke, labí raka leke tsia leke kia lhe bedheaba nagake, bittuba biyienkanie, lhe anágaba benbake ttiba ttu nu xua loni, bittuba bilákanie. Aníha benke kini abittu ilákanie lhe abittu iyienkanie nna tte dákanie, kini ka eyekike nna odaxxuke neda kia nna eyonia ke. ");
INSERT INTO zae_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ttaka lebi'i, karubárule kumu gwa rilábin le lhe gwa riyienbin nagale lhe. ");
INSERT INTO zae_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kumu netiru ria, ixeba ka profeta lhe anágaba ixegaba ka benne ben latsiru, ka benneha yalhá uka leke ilákanie nu rilenle nnanna, ttaka labí bilákanie nuha. Ukagaba leke iyienkanie ka tisa riyieninle nnanna, ttaka labí biyienkanie ka tisaha. ");
INSERT INTO zae_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Laxkala lebi'i gwaludo nagale kixxi'aya bí diani tisa utixxi'aya ge benne dia gwedelha xuxtilaha. ");
INSERT INTO zae_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ttibanka ganna ttixka ttu benne riyieninie ka tisa rigixxi'akana gasina innabia Tata Do Yebáha, nna ganna lee abíba rite danie ka tisaha, la'ania nna daa tteba nu xxegwiha rebeana ka tisaha lhe'e lastoe. Benne runi aníha benneha raxxíne len xuxtila ubinni ro'o nedaha. ");
INSERT INTO zae_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Xuxtila utsa lo íyya atta'aha nna raxxína na len benne biyieninie ka tisaha nna ittaba udú lebie lhe gwexunniba bedaxxue ka benneha. ");
INSERT INTO zae_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ttaka kumu de labí chi begwe lhu ka tisaha lhe'e lastoe, de nuha nna ttu sattiruba ugía lebie. Laxkala tti ruyúe ttu bixa elha disa o ridú nookane delo ni'a ge ka tisaha, la'ania nna reyadi gaa ttebe. ");
INSERT INTO zae_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Xuxtila utsa lhe'e yietsiha nna raxxína na len benne riyieninie ka tisaha, ttaka ka elhaxchacha iki gebie tee yiesi lo yu‑ni, lhe nu ruinna kini rudorulana lebie gatta gebie, nuha runi ki rudagana ka tisaha, labí rugwelhana ki uin ka tisaha sina lhe'e lastoe. ");
INSERT INTO zae_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ttaka xuxtila ubinni lo yu reha nna raxxína na len benne biyieninie ka tisaha lhe ute danie ke lhe. De nuha nna gwa ruinbe nu ra ka tisaha. Benneha nuha anke ttiba xuxtila betebie de gayua (100) lhe de gayuna (60) lhe de rerua (30) lhe. ");
INSERT INTO zae_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús‑ni utixxi'agabe attu tisa. Benie aníha kini utte da ka benne bí diani nu raka lee kixxi'anie keha, nianna tti ree: ―Tata Do Yebáha, tti rinnabie ka benne, elha rinnabia geeha raxxína na len nu uka tti ugía ttu benne gwedelha xuxtila lo yu geeha. ");
INSERT INTO zae_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ttaka lo relaha, laka tee ka benne te'adhike, nianna tti bisin nu abittu raka uyúna benne bedelha xuxtilaha, nna údana ixxi lhe'e xuxtila geeha, nianna deyyana. ");
INSERT INTO zae_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tti chi biyelha xuxtilaha nna ulea ikie, la'ania nna biriagaba ixxiha lhe'e benneha. ");
INSERT INTO zae_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ka nu riben sinaha nna ugíakana gweasikana xxana yuha: “Tata, ¿laaba taga'a xuxtilaba nuha bedelhalu lo yu geluha? ¿Gála biria ixxiha ganna?” ");
INSERT INTO zae_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Xxana yuha nna bekabina, rana: “Gaxa ttu nu abittu raka uyúbana neti benna nuha.” Ka nu riben sina geniha nna rákana na: “¿Si gwa raka lelu tsiatu sattupitu ixxiha?” ");
INSERT INTO zae_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Lana nna rana: “Bittu. Kumu ganna sattupile ixxiha nna itupa xuxtilaha‑ba itupile. ");
INSERT INTO zae_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Gwalugwelhaba ixxiha lhe xuxtilaha iyelhakana. Axtaliba ganna chi isia eyatsa xuaha, la'anialiba nna upeya ka nu tsu'u gwetselaha: Lade'axa gwalittupi ixxi‑na nna xxia xxiaba gwaloxxika lhe'eni kini itena. Iki de nuha‑liba nna tti egitsale xuxtila‑na nna oga'ale benneha ata rigua tsea lena kiaha.” Aníha‑ba raka tti rinnabia Tata Do Yebáha ka benne. ");
INSERT INTO zae_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Utixxi'agabin Jesús‑ni ka benne ge ttu besi ge kuana muxtasa. Aníha benie kini utte dáke bí diani nu raka lebie kixxi'anie keha, nianna tti ree: ―Tata Do Yebáha, tti rinnabie ka benne, elha rinnabia geeha raxxína na len ttu besi ge kuana muxtasa úda ttu benne biyú lo yu geeha. ");
INSERT INTO zae_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Besiha meskiba ankana ttu besi chika'a to delo iyá ka besi‑na, ttaka tti rixen yaga ge kuana muxtasaha, nuha‑la rakaruna yaga xeni delo iyá ka kuana daa lhe'e kurraliha. Laxkala axtala ka binni‑na rusia lhixxu'inkani lo ka nániha. ");
INSERT INTO zae_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Utixxi'agabanie ke ge kua dii bedelha ttu nuila iki yiediha. Aníha benie ki utte dáke bí diani nu raka lebie kixxi'anie ke, nianna tti ree: ―Tata Do Yebáha, tti rinnabie ka benne, elha rinnabia geeha raxxína na len kua dii bedaxxu ttu nuila nna bedelhana iki tsunna (3) ya yiedi xuxtila kini ilhidhana lhe'e itú kuaha. ");
INSERT INTO zae_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iyába ka tisa utixxi'ani Jesús‑ni ka benne, labí unnebie ka nuha lhixxa rá, satíaba betanie ke nu unneeha. Laxkala labí rigixxi'anie ke attu bixa tisa, ganna abíba rutanie ke. ");
INSERT INTO zae_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aníha benie ki gwado tisa ge nu unne benne uke profeta ge Tata Do Yebáha, tti ree: Iyába nu kixxi'aya teeki utania na ka benne, labí innea na lhixxa rá. Kixxi'abaa nu tee gatsiha, nu labí chi yuke attili ure yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iki de chi uchú tisa Jesús‑ni ka benne tupa niha, nianna deyye bete'e lhe'e yo'oha. Ka benne rudhetinieha nna ubigake ata due nna ráke bie: ―Utixxi'en ri'itu, ¿bí diani nu unnelu ge ixxi be'eyu lhe'e xuxtilaha? ");
INSERT INTO zae_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús‑ni nna bekabie, ree ke: ―Neti benne daya yebáha, netiba nuha ankaa benne ugía gwedelha xuxtilaha ");
INSERT INTO zae_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","nna lo yu ata ugía xuxtilaha nna ankana yiesi lo yu‑ni. Xuxtilaha nna anke ka benne rinnabia Tata Do Yebáha ke nna ixxi biria lhe'e xuxtilaha nna ankana ka nu rudokana tisa ge nu xxegwiha. ");
INSERT INTO zae_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nu abittu raka uyúna benne anka xxana yuha, lana nuha anka nu xxegwiha. Lana údana ixxiha lhe'e xuxtilaha. Gwetselaha nna ankana tti chi lhuxa yiesi lo yu‑ni. Ka benne kweni gwetselaha nna ankake ka anjeli ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Laxkala ttiba gwate ixxiha bilupina nna ugíana lo giha, aníha‑gaba sate ka benne ganna chi lhuxa yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Neti benne daya yebáha idhelhaa ka anjeli kiaha ata se'e ka benne rinnabiaya, kini kweake ka nu ridí yiekana ka benne ki ruinke tulha lhe ki kweake ka nu ruin satsa lhe. ");
INSERT INTO zae_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nianna tti udelhake kana lo giha. Niha kwesikana lhe goniba lo layakani lhe. ");
INSERT INTO zae_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","La'ania nna ka benne ruin tseha, ttiba tatubisa‑na rapi edha linníbe, aníha‑ba tsapi edha linníbake ata rinnabia Tata geke do yebáha. ¡Ata sia nagale, gwaludo nagale ganna gwankale nu dika iyienini! ");
INSERT INTO zae_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Tata Do Yebáha, tti rinnabie ka benne, elha rinnabia geeha raxxína na len ttu nu daka xxatta yu'una lhi'u yu. Ttu benne biyú tti gwaxxake nuha nna bokatsi adakabe na, nianna ritta rebaaba lebie deyye nna gwatto'e iyába nu tee gebie, nianna tti ugíe uyo'e lo yu ata gatsi nu daka xxattaha. ");
INSERT INTO zae_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Lhe anágaba tti rinnabia Tata Do Yebáha ka benne, elha rinnabia geeha raxxígabana na len ttu benne rekie gwetto'o, regile ka íyya ragalha, ka nu tse, ki utto'e kana. ");
INSERT INTO zae_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tti gwaxxake ttu íyya daka xxatta, nianna deyya ttebe gwatto'e iyába nu se'e gebie, nianna tti ugíe gwayo'e íyya ragalhaha. ");
INSERT INTO zae_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Tata Do Yebáha, tti rinnabie ka benne, elha rinnabia geeha raxxína na len ttu yexxa nu rudaxxu belha. Tti rudelha ka benne yexxaha lhe'e indaha nna iyá looba belha rudaxxuna. ");
INSERT INTO zae_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tti chi bisá yexxaha nna ka nu rudaxxu belhaha nna bebeakana yexxaha ro'o indaha. Nianna uyu'ukana bokwekana ka belha tseha nna ulu'ukana ka nuha lhe'e ka sumi, nna ka belha ka nu abittu ixúha nna uru'unabakana ka nuha. ");
INSERT INTO zae_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Aníha‑ba aka ganna chi isia sá lhuxa yiesi lo yu‑ni. Iria ka anjeli ge Tata Do Yebáha kwesike ka benne ruin satsaha lagwi ge ka benne ruin tseha ");
INSERT INTO zae_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","nianna tti udelhake ka nu ruin satsaha lo giha. Niha kwesikana lhe goniba lo layakani lhe. ");
INSERT INTO zae_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nianna tti unnaba tisa Jesús‑ni ka benne rudhetinieha, ree ke: ―¿Si gwa ute denle iyá nu ria‑ni? Lake nna bekabike, ráke: ―Gwa ute da galentu. ");
INSERT INTO zae_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Lee nna ree ke: ―Iyába ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni, delába ka nu chi yúkana gasina rinnabia Tata Do Yebáha ka benne, ka nuná ankabakana attiba xxana ttu yo'o. Xxana yo'oha, lhe'e iyá nu tua tsenna lhe'e yo'o geniha, ribeabana nu kubi lhe ribeabana nu yaxxu lhe. ");
INSERT INTO zae_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tti chi uluxani Jesús‑ni utixxi'abie ka tisa nu betanie ka benneha, nianna bedábie ata dueha nna deyye. ");
INSERT INTO zae_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tti besine lhe'esi Nazaret ata uka lasieha, nianna udulo ttebe bele'enie ka benne ge lhe'esiha ka tisa ge Tata Do Yebáha lhe'e yo'o ata rudhetike ka tisaha. Tti biyienkin benne se'e niha nu rigixxi'eha, nianna bebanabakanie nna ra luesike: ―¿Gá gwaxxí nuní elha rieni rapana lhe gá gwaxxína ka milagru ruinna‑ni lhe? ");
INSERT INTO zae_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Laaba xi'ini nu runi ka mexaha lhe ka xxilaha‑ba nuní? ¿Laaba Maríaba lá nan ge nuní, nna ka betsiniha nna tee lákani Jacobo lhe José lhe Judas lhe Simón lhe? ");
INSERT INTO zae_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Laaba iyába ka danniha se'ekana lhe'esi‑ni len ri'i? Lana nna, ¿gála gwaxxína iyá nu yuna‑ni ganna? ");
INSERT INTO zae_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nianna tti bituxxukinna ge Jesús‑ni, ttaka labie nna ree kana: ―Ttu benne anke profeta gaxaba die gwa rugwebakana lidhake, ttaka ka nu lhe'esi geeha labí rugwekana lidhake, nigaba ka benne se'e lhe'e yo'o geeha. ");
INSERT INTO zae_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","De nuha nna labí ixe ka milagru ben Jesús‑ni niha, kumu de labí ugía lekani gebie. ");
INSERT INTO zae_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","La'ania Herodes nu rinnabia lo yu ge Galilea‑ni binana ge nu ruin Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nianna tti rana ka nu riben sina geniha: ―Juan nu rugadi indaha‑ba nuná chi beyaka benna lagwi ge ka benne chi uttiha. De nuha‑ba nna raka geni ruinna ka milagru‑na. ");
INSERT INTO zae_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Aníha ra Herodes‑ni, kumu delo ni'a ge Herodías nu uka nuila ge betsini Felipe‑ni, de nuha‑ba nna udhelhana bedaxxukana Juan‑ni nna bexxigakane nna utixxakane lisiyya. ");
INSERT INTO zae_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Aníha benna kumu de bituxxuinna de ra Juan‑ni na: “Labí ga'anna edo lenlu nuila ge betsilu‑na.” ");
INSERT INTO zae_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes‑ni benna uttina Juan‑ni, ttaka usibinna ge ka benne, kumu ráke: Juan‑ni anke profeta ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ttaka la sá tti uka laní ge Herodes‑ni tti gwadoinna idaha, la'ania beya'a xi'iniunná Herodías‑ni arlo iyába ka nu se'e len Herodes‑ni. Herodes‑ni nna yalhá uyu'u leni beya'a nuila kwitiha. ");
INSERT INTO zae_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nianna tti bodha'an tsitsi tisa geni len nuilaha nna rana nuha: ―Bixaba innabalu, gutebaa na gelu. ");
INSERT INTO zae_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nuilaha nna rana Herodes‑ni: ―Raka lasia ku'ulu lhe'e ttu ye'ena bega iki Juan nu rugadi indaha nna utelu na len neti. Aníha ra nuilaha kumu de ixnániha‑ba ulu'u tisana na, kini unnabana bega iki Juan‑ni. ");
INSERT INTO zae_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nianna Herodes‑ni chi bedú si'ina leni, ttaka kumu de chila bedha'an tsitsi tisa geni len nuilaha lhe anágaba de chila unnena nuha lo ka nu se'e niha, de nuha nna benna doelha kini ugwekana nuilaha nu rinnabanaha. ");
INSERT INTO zae_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nianna tti udhelhana ki gwachúkana bega iki Juan‑ni lhe'e lisiyyaha. ");
INSERT INTO zae_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ulu'ukana iki benneha lhe'e ttu ye'ena nna gwagwekana nuila kwitiha. Nuilaha nna gwagwena nan geniha nuha. ");
INSERT INTO zae_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ka benne bedhetini Juan‑ni nna ugía ttebake gwaxíke benneha nna gwakatsike bie. Iki de nuha nna tti ugíake gwattixxi'akanie Jesús‑ni ge nu chi ukaha. ");
INSERT INTO zae_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tti chi bina Jesús‑ni nu gwate Juan‑ni, nianna beru'una ttebe deyye sun labe deyye lo ttu barcu betee lo indatooha kini isine ata lanú benne se'e. Ttaka tti chi bina ka benne niha‑la chi die, nianna biria ttebake lhe'e ka yiesi gekeha nna ni'abake diake danalhake bie. ");
INSERT INTO zae_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tti ugwadie lo barcuha nna bilánie ixe juisiru ka benne chi se'e niha. Nianna gwatua lebie ke nna beyonie ka benne rani gekeha. ");
INSERT INTO zae_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ttaka de chi galá dia ralha nuha, nianna tti ubiga ka benne rudhetinieha nna ráke bie: ―Ata se'eri'i‑ni, yu bisiba nuní, labí bixa tee nii lhe gwea chiba dia ura nuní. Bedhelhala ka benne tupa‑ni eyyake lhe'e ka yiesi to‑na kini sayo'oke nu goke. ");
INSERT INTO zae_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ttaka Jesús‑ni bekabie ree ke: ―Labí raka doelha eyya ka benne‑ni. Lebi'iba gwalugwe ke nu goke. ");
INSERT INTO zae_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ka benneha nna bekabike, ráke: ―Labí bixa nuja ri'itu. Ne sunruba gayu yettaxtila nujatu nna a chupa ka belha nna. ");
INSERT INTO zae_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús‑ni nna ree ke: ―Nii gwalute ka nu nujale‑na ganna. ");
INSERT INTO zae_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nianna benie ki bese'e ka benneha lo ixxi binniha, nna tti bedaxxue gayu ka yettaxtilaha nna ixpa ka belhaha, nianna tti belhidha loe yebáha nna begwebie ixkixaru len Tata Do Yebáha. Nianna tti ulha'abie lhe'e ka benneha nna begwebie ka benne rudhetinieha. Ka benneha nna utidhike benneha begweke ka benne se'e lo ixxi binniha. ");
INSERT INTO zae_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Iyábake utoke nna axtaba beyielakanie. Ka benne rudhetinieha nna bottuparulake a tsi'inu (12) sumi ka ro'o salha'a bexxaha. Besá tí ka sumiha. ");
INSERT INTO zae_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ttiba ttu gayu mili ka benne biyúha utoke, sunrula ka benne biyúha bibaba, bittula bibaba ka benne nuilaha lhe ka nutoha lhe. ");
INSERT INTO zae_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Iki de nuha nna ben Jesús‑ni kini beyapi ka benne rudhetinieha lo barcuha ki eneru gaake eyyake esinke daka attu ladu ro'o indatooha, laka lee nna richú tise ka benne se'e niha. ");
INSERT INTO zae_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Iki de chi uchú tise ka benneha, nianna tti die ugwapie iki i'iyaha. Ttúbe ulhapie tisa len Tata Do Yebáha nna ttúgabe due niha tti chi ulha sáha. ");
INSERT INTO zae_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Barcu ata deyya ka benneha nna aliba chi beru'una nuha lo indaha. Radha retinbana de ru'u indaha kwe'eni kumu de daka arlola barcuha retetsu'u beha. ");
INSERT INTO zae_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tti chi deoba tsaniha nna dia Jesús‑ni ridee lo indaha, die isine ata dia ka benne rudhetinieha. ");
INSERT INTO zae_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tti bilani ka benneha ridábie lo indaha, nianna usikanie ribesi'abake, ráke: ―¡Ne ttu nu du ela daa naa! ");
INSERT INTO zae_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ttaka Jesús‑ni nna unne ttebe, ree ke: ―Tsitsi gwalikweki lele; bittu gasinle. Netiba nuní. ");
INSERT INTO zae_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nianna ra Pedruha bie: ―Ganna lu nuná xa tata, ben kini dhaya lo inda‑ni kini isiaya ata dulu‑na. ");
INSERT INTO zae_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Lee nna rabie na: ―¡Utá ganna! Pedruha nna ugwadi ttebana lo barcuha nna diana ridána lo indaha kini isinna ata du Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ttaka tti ute denna yalhá idí daa beha nna usi ttebinna nna kumu de chi diana rixudina lhe'e indaha nna ttikala nuha uresi'ana, rana: ―¡Bodiláttu neti xa tata! ");
INSERT INTO zae_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jeru tteba gwadaxxu Jesús‑ni náni nna ree na: ―¡Aaluxa nu a ria tsitsi leni! ¿Beaka bedú chupana lelu? ");
INSERT INTO zae_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tti chi beyapike lo barcuha nna ure tteba beha. ");
INSERT INTO zae_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Adí ka benne sia lo barcuha nna ubiga ttebake bedú xibike arlo Jesús‑ni nna ráke bie: ―Lúligaba gwalí ankalu Xi'in Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Iki de chi beteke lo indatooha nna besinke lo yu ge Genesaret. ");
INSERT INTO zae_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tti chi beyoinbia ka nu se'e daka Genesaret‑ni Jesús‑ni, nianna utixxi'a ttebakinna ka benne se'e itúba ka daka niha. Ka benneha nna cheke iyába ka benne rani ata dueha ");
INSERT INTO zae_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","nna ka benne raniha nna unnaba ditibake lenie, ráke bie: ―Kwadiba ro'o lari nukulu‑na begwelha udaxxutu. Nianna iyába ka benne rani, ka benne bedaxxuke ro'o xoeha gwa beyakabake. ");
INSERT INTO zae_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nianna tti ubiga ttu chupa ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe attu chupa ka fariseo‑ni lhe, ubigakana ata du Jesús‑ni. Ka nuha lhe'esi Jerusalén‑nili udákana dákana nna rákane: ");
INSERT INTO zae_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Ka nu rudhetinlu‑na, ¿beakala a ruin ka nuná nu chi bodha'an ka benneola geri'iha uinri'i? Kumu ka nuná labí rigí nákani atti lanila gokana yetta. ");
INSERT INTO zae_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús‑ni nna bekabie gekani, ree: ―¿Beakala lebi'i, de rudole tisa ge nu bodha'an ka benneola geri'iha, de nuha nna rigu'ula ni'ale nu bodha'an Tata Do Yebáha uinri'i? ");
INSERT INTO zae_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kumu Tata Do Yebáha ree: “Tsia lele ka tata nan gele” nna “Nu kena iki ka tata nan geniha, nuha ralhaba nuha gattina.” ");
INSERT INTO zae_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ttaka lebi'i nna rálale: “Gwakaba geri'i gari'i ka tata nan geri'iha, labí aka utea nu tee kia len lebi'i kumu iyába nu tee kia, ge Tata Do Yebáha‑ba chi ga'anati utea nuní.” ");
INSERT INTO zae_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Lebi'i ukare'aba innále: “Labí aka utea nu tee kia len lebi'i”, la'ania nna labíru daa lole utele nu tee geleha len ka tata nan geleha. ¿Laaba ganna, de rudole tisa ge nu bodda'an ka benneola geri'iha, aníha tte nuha nna chi rigu'u ni'ale nu bodda'an Tata Do Yebáha? ");
INSERT INTO zae_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Lebi'i labí liinle. Delo tisaba ruinle deki ankale benne tse. Gwalíbani profeta Isaías‑ni atti utixxi'ana gele lo ka yetsi ge Tata Do Yebáha. Lo ka yetsiha unne Tata Do Yebáha, ree: ");
INSERT INTO zae_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ka nuní, len ro'oruba ka nuní rákana deki ria lekani neti, ttaka labí gwalíkinna rakakinna kia. ");
INSERT INTO zae_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kwentaruba nuná rudú xibikani arloa, kumu nu anka ge benne se'e yiesi lo yu‑niba nuná rule'ekinna ka benne; labí nu anka kia nuná rule'ekana. ");
INSERT INTO zae_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nianna tti uxi Jesús‑ni ka benne tupa niha nna ree ke: ―Gwaludo nagale kia nna gwalutte da nu innea‑ni. ");
INSERT INTO zae_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Labí nu rori'i rutsigana ri'i arlo Tata Do Yebáha, sinuki nu ririala ro'ori'i rinneri'i, nunála nu rutsigana ri'i arloe. ");
INSERT INTO zae_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nianna tti ubiga ka benne rudhetinieha nna ráke bie: ―¿Si gwa yulu xa tata, ka fariseo‑ni bituxxulakinna tti biyienkinna nu ralu‑na? ");
INSERT INTO zae_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Lee nna bekabie ge ka benneha, ree ke: ―Iyába ka yaga ka nu abittu beyada Tata kia do yebáha, ka nuha ilupibakana nna iru'unakana. ");
INSERT INTO zae_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","De nuha nna ka fariseo‑na naala se'e ka nuná. Ka nuná ankabakana ttiba ka nu xua lokani, rinnerukana arlo adí ka luesi lo xuakani. Kumu ganna ttu nu xua loni rineruna lo attu luesi lo xua‑ni, la'ania nna ixpabakana satsettikana lhe'e ttu yieru. ");
INSERT INTO zae_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro‑ni nna rane: ―Utixxi'en ri'itu, ¿bí diani nu ralu‑na? ");
INSERT INTO zae_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús‑ni nna bekabie, ree kana: ―¿Si nigaba lebi'i bittugaba rite denle nu ria‑ni? ");
INSERT INTO zae_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Si lagwa gwa rite denle deki iyába nu rori'i, lhe'e tu'ebari'i dia nuná? Delola nna rebeabari'i nuná. ");
INSERT INTO zae_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ttaka nu riria ro'ori'i tti rinneri'i, nuná ankana nu ririana lhe'e lastori'i, nunonna rutsigana ri'i arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kumu lhe'e lastori'i nuná riria iyába nu satsa rulaba leri'i, lhe nágaba nuná riria nu rixegwiri'i ki ruinri'i elhutti, lhe lhe'e lastogabari'i nuná riria tti risári'i nu labí anka latselari'i, lhe ruinri'i nu satsa leni nuxaba benne lhe. Anágaba lhe'e lastogabari'i riria nu reta leri'i rilanari'i, lhe rinneri'i gwen lasi lhe anágaba rinne satsa ge luesiri'i lhe. ");
INSERT INTO zae_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iyá ka nunonna runi kini reya'anri'i tsiga arlo Tata Do Yebáha. Laa de abíga kí nári'i tti gori'i yetta, laa de nuha‑ga nna eya'anri'i tsiga arlo benneha. ");
INSERT INTO zae_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Bedába Jesús‑ni ata dueha nna die daka Tiro lhe Sidón lhe. ");
INSERT INTO zae_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Niha biria ttu benne nuila anke ge Canaán nna ubige kwe'e Jesús‑ni, ribesi'abe, ree: ―¡Benne datia David, gwatuachi lelu neti xa tata! Xi'iniunnayáha yalhá elha disa ruyúbi yu'u ttu espíritu xxegwi latibi. ");
INSERT INTO zae_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ttaka Jesús‑ni nna labí bekabie ge benne nuilaha. Nianna tti ubiga ka benne rudhetinieha nna unnabake len Jesús‑ni, ráke bie: ―Bedhelha nuila‑na eyyana, kini ribesi'abana danalhana ri'i. ");
INSERT INTO zae_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Lee nna bekabie, ree: ―Tata Do Yebáha labí udhelhe neti len ka nu dittu‑na; suna len ka benne Israel ka benne chi bedhanke neda gebie, suna len ka benne‑niba udhelhe neti. ");
INSERT INTO zae_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ttaka benne nuilaha nna ubige bedú xibie arlo Jesús‑ni nna ree bie: ―¡Tata xisi to, akachi lenlu neti! ");
INSERT INTO zae_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús‑ni nna bekabie ge benneha, ree: ―Ttaka labí anka tse udaxxua yettaxtila nu dika go ka xi'inia‑ni nna udelhaa na lo ka beku to‑na. ");
INSERT INTO zae_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Benne nuilaha nna bekabie, ree: ―Gwalí galenlu xa tata; ttaka yulu axta ka beku to‑na redigakana ka yettaxtila ro'o yuya riginni xan mexa ge ka xxanakaniha. ");
INSERT INTO zae_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesús‑ni nna bekabie, ree benne nuilaha: ―¡Ga ttiparuba tsitsi ria lelu xa nuila! Gwakaba nu rinnabalu‑na. Looraha tteba nna beyaka tteba xi'iniunná benne nuilaha. ");
INSERT INTO zae_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús‑ni nna bedábe daka Tiro lhe Sidón lhe nna besine gaxxaba ro'o indatoo ge Galilea‑ni. Nianna tti ugwapie iki ttu i'iya do niha nna udoe. ");
INSERT INTO zae_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nianna tti ubiga ixe juisiru ka benne ata doeha, cheke ka benne ridá natsa lhe ka benne xua loke lhe ka benne ankake biría, lhe anágaba ka benne akaa ttu lha'a ni'ake o náke lhe ixeru ka benne rani lhe. Nianna tti bese'eke ka benneha arloe, lee nna gwa beyoinbe ka benneha. ");
INSERT INTO zae_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Laxkala ka benne tupa niha rebanabakanie tti rilákanie ka benne anka biríaha chi renneke, lhe ka benne riyasa ttu lha'a ni'ake o nákeha chi reyakake ida'a, lhe anágaba ka benne ridá natsaha chi redá tseke lhe ka benne xua lokeha chi relákanie lhe. Nianna tti ráke: ―¡Xxeniba ra le Diosi ge ka benne Israel‑ni! ");
INSERT INTO zae_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nianna tti uxi Jesús‑ni ka benne rudhetinieha nna ree ke: ―Neti ratua chiba lasia ka benne se'e‑ni, kumu chiba uka tsunna ubisa‑ni se'eke nii len neti nna birula bi tee bixa goke. Labí raka lasia edhelhaa ke abittu chi utoke, kumu ni kina satú leke lo neda. ");
INSERT INTO zae_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ka benne rudhetinieha nna ráke bie: ―¿Gála saxxíri'i nu go ttaníli ka benne‑ni? Ki lo yu bisiba nuní se'eri'i ata lanú benne se'e. ");
INSERT INTO zae_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús‑ni nna ree ke: ―¿Balha yettaxtila chele? Ka benneha nna ráke: ―Ne gasiruba ka yettaxtila chetu nna attu chupa ka belha to nna. ");
INSERT INTO zae_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nianna tti ree ka benne tupa niha: ―Gwalese'e lo yu. ");
INSERT INTO zae_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nianna tti bedaxxue gasi ka yettaxtilaha lhe ka belhaha lhe, nna iki de chi begwebie ixkixaru len Tata Do Yebáha, nianna tti ulha'abie lhe'e ka benneha nna begwebie ka benne rudhetinieha. Ka benne rudhetinieha nna begweke ka benne chi bese'e lo yuha. ");
INSERT INTO zae_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Iyábake utoke nna axtaliba beyielakanie. Iki de nuha nna bottuparula ka benne rudhetinieha a gasi sumi ka benne ro'o salha'a bexxaha. ");
INSERT INTO zae_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ttiba tu ttapa mili ka benne biyúha utoke, sunrula ka benne biyúha bibaba. Bittula bibaba ka benne nuilaha lhe ka nutoha lhe. ");
INSERT INTO zae_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Iki de chi uchú tisa Jesús‑ni ka benneha, nianna beyapie lo barcuha nna deyye daka Magdala. ");
INSERT INTO zae_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ka fariseo‑ni lhe ka saduceo‑ni lhe ubigakana ata du Jesús‑ni kini ku'ukane prueba. Nianna unnabakane unie ttu milagru kini ula'a deki gwalí Tata Do Yebáha udhelhe bie. ");
INSERT INTO zae_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ttaka lee nna bekabie gekani, ree: ―Ki lebi'i, ganna chi dia ralhana rale: “Tseba aka uxxeha kumu xinába anka gwetsáha.” ");
INSERT INTO zae_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ka dila‑na nna rale “Nasá iyya lhaba aka kumu xinába anka gwetsáha lhe beaba yu'u lhe.” Kaxa gwa rite dábinle bixa aka tti rilenle gwetsáha, delo nna a rite denle nu raka lagwi gele nnanna. ");
INSERT INTO zae_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Lebi'i ka nu runi satsa se'e nnanna lhe chi rudhá ikile Tata Do Yebáha nna ria lele attu nu subi, lebi'i rinnabale unia ttu milagru, ttaka neti labí ula'ania le attu bixa milagru, sunruba luesi nu gwate Jonás benne uke profeta ge Tata Do Yebáha, a sunruba luesi nuha gula'ania le. Nuha‑ba ree kana nna bese'e bixxibe kana nna deyye. ");
INSERT INTO zae_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tti chi uteke lo indatooha nna ka benne rudhetini Jesús‑ni gwadú leke deki bixulhabakanie icheke yettaxtila ki goke. ");
INSERT INTO zae_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nianna tti ra Jesús‑ni ke: ―Gwaluyú gele ka iyietile kua dii ge ka fariseo‑na lhe ka saduceo‑na lhe. ");
INSERT INTO zae_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ka benne rudhetinieha nna ra luesike: ―Aná rabie kumu de abittu yettaxtila cheri'i. ");
INSERT INTO zae_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ttaka Jesús‑ni nna ute dábanie nu rákeha, nianna tti rabie ke: ―¡Aalexa nu abittu ria tsitsi leni! ¿Beaka ra luesile deki labí yettaxtila tee? ");
INSERT INTO zae_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Si itua ttu a rite denle nu ria‑ni? ¿Si abittugaba rexxa lele ge gayu ka yettaxtila uto gayu mili ka benneha lhe si abígaba rexxa lele a balha ka sumi yettaxtilaha bottupale ge nu bexxaha? ");
INSERT INTO zae_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Si nigaba a rexxa lele ge gasi ka yettaxtila uto ttapa mili ka benneha? Lhe, ¿si abígaba rexxa lele a balha ka sumi yettaxtilaha bottupale ge nu bexxaha? ");
INSERT INTO zae_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Si lagwa ute denle? Laa ge yettaxtilaga nuha unnea tti ria: “Gwaluyú gele len kua dii ge ka fariseo‑na lhe ka saduceo‑na lhe.” ");
INSERT INTO zae_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","La'anialiba nna tti ute dákanie deki labí ge kua dii ria iki yiedi raka yettaxtilaha nuha rinnebie, sinuki ge nu rule'e ka fariseo‑ni lhe ka saduceo‑niba nuha rinnebie. De nuha nna ree ke: ―¡Gwaluyú gele len ka nuná! ");
INSERT INTO zae_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tti bisin Jesús‑ni daka Cesarea ge Filipo, nianna tti unnaba tise ka benne rudhetinieha, ree ke: ―Neti benne daya yebáha, ¿nú ra ka benne deki ankaa? ");
INSERT INTO zae_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ka benneha nna bekabike, ráke: ―Ttu chupa ka benne ráke deki lu ankalu Juan benne begadi indaha. Attu chupake nna ráke deki lu ankalu Elías, nna adíke nna redenáke deki lu ankalu Jeremías o nuxaba ttu ka benne ukake profeta ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesús‑ni nna ree ke: ―Lebi'i nna, ¿nú rale deki ankaa? ");
INSERT INTO zae_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedruha nna bekabina, rane: ―Lu ankalu Cristu Xi'in Tata Do Yebaa benne anka baniha. ");
INSERT INTO zae_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús‑ni nna ree na: ―Karubárulu xa Simón xi'in Jonás, kumu laa bennega utixxi'anie lu nu ralu‑na; Tata kia do yebáha, benneha‑ba utixxi'anie lu nuná. ");
INSERT INTO zae_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Lhe anágaba neti ria lu, lu ankalu Pedro. (Pedro dienna innána íyya.) Iki íyya‑ni dhuloa use'a ka benne tsia leke neti. Ni elhuttiha labí dhaana utse'e loona ke. ");
INSERT INTO zae_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Len lu utea lo neda kini ulhenlu ka benne innabia Tata Do Yebáha ke. Laxkala iyába nu innálu abittu dika uin ka benne yiesi lo yu‑ni, yebáha chigaba bodha'an Tata Do Yebáha deki abittu aka nuha, nna iyába nu innálu gwa dikaba uin ka benne yiesi lo yu‑ni, yebáha chigaba bodha'an Tata Do Yebáha deki gwakaba nuha. ");
INSERT INTO zae_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nianna tti bodha'an tsitsi Jesús‑ni len ka benne rudhetinieha, ree ke: ―Anuttu nu gale deki neti ankaa Cristu. ");
INSERT INTO zae_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Debá la'ania nna udulo Jesús‑ni rigixxi'anie ka benne rudhetinieha deki teeki tsiabie lhe'esi Jerusalén‑ni. Niha teeki sate xxatte uyúe elha disa lo ná ka benneola ge ka nu Israel‑ni lhe lo ná ka nu loni ge ka bixxudiha lhe lo ná ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe. Nianna rágabe deki teeki uttikane nna eyonna ubisaha nna eyaka benbe attu libe. ");
INSERT INTO zae_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro‑ni nna ttúbe uxina attu ta subi, nianna tti utisane, rane: ―¡Tata Do Yebáha labí ugwelhe satelu nu ralu‑na xa tata! ");
INSERT INTO zae_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús‑ni nna beyekie, ree na: ―¡Ubi'etta kwe'a xa nu xxegwi! Sunruba rattalu lo neda kia. Kumu lu suna nu anka ge ka benne se'e yiesi lo yu‑niba do ikilu, labí do ikilu nu anka ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nianna ra Jesús‑ni ka benne rudhetinieha: ―Ganna nuxa ttúle raka lele etenalhale neti, teeki eria iki eria lele, meskila bixa satele nna gwaludaxxu kurusi gele nna gwaltá gwetenalha neti. ");
INSERT INTO zae_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kumu ttu benne ganna abittuba raka lebie bixa satebie de etenalhe neti, benneha nnittilee, delába labí aka ben benneha arlo Tata Do Yebáha. Ttaka benne eria iki eria lebie, meskila bixa satebie de etenalhe neti, benneha nna gwaka benlee arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kumu, ¿bí ixú nuha ganna ttixka ttu benne dhaabie uin gebie iyá nu se'e yiesi lo yu‑ni, ttaka arlo Tata Do Yebáha nna tsia nnittilee? Nigaba labí aka geri'i go'ori'i elha nabani geri'i kini anáchu aka benri'i ttu dia lii arloe. ");
INSERT INTO zae_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kumu neti benne daya yebáha esiaya lhe'e xiani ge Tata kia do yebáha lenia ka anjeli geeha. La'ania nna kua ttu ttu ka benne ugwea ke nu ralhake dhike ge nu benke. ");
INSERT INTO zae_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Netiru ria, ttu chupale ka nu se'ele nii nnanna labí chi uttile atti esiaya innabiayaha. Sa se'e benbale axtaliba ki ilenle neti benne daya yebáha esiaya. ");
INSERT INTO zae_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Iki de chi ute xxupa ubisaha nna uche Jesús‑ni Pedruha lhe Jacobuha lhe Juan betsi Jacobuha lhe, uchebie kana sun labakana iki ttu i'iya xeni do niha. ");
INSERT INTO zae_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Niha besea lobie arlokani. Rapi edha linníba loe ttiba lo tatubisa‑na, ka xoeha nna sitsi túba beyakana ttiba xiani. ");
INSERT INTO zae_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nianna tti bela'akinna uka xxe Moisés‑ni lhe Elías‑ni lhe, rinne len ka benneha Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedro‑ni nna rana Jesús‑ni: ―Gwen tte uka se'etu nii xa tata xisi to. Ganna raka lelu, gusiabatu tsunna ka yo'o lhaga: ttu gelu nna ttu ge Moisés‑ni nna attu ge Elías‑ni nna. ");
INSERT INTO zae_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sa dúlana rinnena ttiru chi bisia ttu bea yien charába ankana urena ata se'ekeha nna lhe'e beaha nna biyien tsi'i ttu benne, rabie: ―Benne‑ni anke Xi'inia lhe rakati gebie lhe. Benne‑ni runie nu ru'u lasia. Ge benne‑ni gwaludo nagale. ");
INSERT INTO zae_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ka benne rudhetini Jesús‑ni nna tti biyienkanie unne benneha, nianna bedú xibike nna bettudhi loke lo yu de usi xxattakanie. ");
INSERT INTO zae_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús‑ni nna ubige nna gwadaxxue kwe'eke nna rabie ke: ―Gwaleyadha. Abittu gasinle. ");
INSERT INTO zae_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tti belhidha lokeha nna nurua nuxa bilákanie, a sunruba Jesús‑ni du niha. ");
INSERT INTO zae_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Laka deyyake reyadike lati i'iyaha nna ra Jesús‑ni ke: ―Bittu kixxi'enle ka benne ge nu bilenle‑ni. Axtaliba ganna neti benne daya yebáha chi beyaka bania lagwi ge ka benne chi uttiha, la'anialiba nna kixxi'ale ge nu bilenle‑ni. ");
INSERT INTO zae_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ka benne rudhetinieha nna unnaba tisake bie, ráke: ―¿Beakala ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni nna rálakana deki Elías‑ni teeki esie lade'a tte, niala nna tti isia Cristuha? ");
INSERT INTO zae_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús‑ni nna bekabie, ree: ―Gwalí galá deki Elías‑ni esiabie lade'a tte. Benneha ose'e tsebie iyá nu se'e. ");
INSERT INTO zae_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ttaka neti ria le, Elías‑ni chiba bita benneha nna ka benne labí belabike bie, nna bedhakabake bie attiba rakaba leke. Aníha‑gaba neti benne daya yebáha, aníha‑gaba satea lasi nákani. ");
INSERT INTO zae_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","La'anialiba nna tti ute dani ka benne rudhetinieha deki ge Juan benne begadi indaha‑ba nuha unnebie tti ree aníha. ");
INSERT INTO zae_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tti besin Jesús‑ni len iyunna ka benne rudhetinieha ata se'e ixe juisiru ka benne, nianna tti ubiga ttu benne biyú ata du Jesús‑ni nna bedú xibie arloe nna ree bie: ");
INSERT INTO zae_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Tata xisi to, gwatuachi lelu xi'inia‑ni, kumu rakabi beora nna yalhá elha disa ruyúbi. Gwadú ribixxibi lo giha lhe gwadú ribixxibi lhe'e indaha lhe. ");
INSERT INTO zae_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Chi bisiaya lenbi ata se'e ka benne rudhetinlu‑ni, ttaka ka benne‑ni labí udaake eyoinke bi. ");
INSERT INTO zae_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús‑ni nna ree ka benne rudhetinieha: ―¡Aalexa nu a du itá leni lhe nu a ria leni lhe! ¿Nukalila sa dhua len lebi'i? ¿Nukalila sa utto uchíaya ge nu ruinle? ¡Aní gwataxxí nu kwiti‑na! ");
INSERT INTO zae_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nianna tti bedhaka dise espíritu xxegwi yu'u lati nu kwitiha nna beria tteba nuha. Looraha tteba nna beyaka tteba nu kwitiha. ");
INSERT INTO zae_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Delola nna tti ubiga ka benne rudhetinieha ata du Jesús‑ni nna sun labe unnaba tisake, ráke bie: ―¿Beakala ri'itu nna a udaatu ebeatu espíritu xxegwi‑na? ");
INSERT INTO zae_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Lee nna ree ke: ―Kumu de lebi'i labí ria tsitsi lele. Netiru ria, ganna ria lele kwadiba ttuxka'a to ttiba ttu besi ge kuana muxtasa, nuná ttu nu chika'a toru ankana, aníha‑gaba lebi'i, ganna ria lele ttu latti to, la'ania nna labí tee ttu bixa abittu aka gele uinle nna gwakaba gele gale i'iya do naa: “Ugía, gwadho daka aná.” I'iyaha nna gweyyabana sa dhona niha. ");
INSERT INTO zae_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ttaka luesi espíritu xxegwi uyu'u lati nu kwiti‑ni labí eria nuní ganna abíba ilhapiri'i tisa len Tata Do Yebáha lhe utte ubina lhe'eri'i lhe. ");
INSERT INTO zae_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tti rekike daka Galilea‑ni nna ra Jesús‑ni ka benne rudhetinieha: ―Neti benne daya yebáha utekana neti lasi ná ka nu ");
INSERT INTO zae_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","uttikana neti, ttaka ganna chi beyonna ubisaha nna eyaka benbaa. Ka benne rudhetinieha, tti biyienkanie nu reeha nna yalhá bedú si'ina leke. ");
INSERT INTO zae_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tti bisin Jesús‑ni lenie ka benne rudhetinieha lhe'esi Capernaum‑ni, ka nu rukixakana ka benne belhiu, delába belhiu nu ruttupakana ge yotuha, nna ubigakana, rákana Pedruha: ―Maestru gele‑na, ¿si lagwa gwa rigixa benne‑na belhiu nu ruteri'i ge yotuha? ");
INSERT INTO zae_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedruha nna bekabina, rana: ―Gwa rixa galee. Tti uta'ana lhe yo'oha nna lade'axala unnaba tisa Jesús‑ni na, ree na: ―Simón, ¿bí rakinlu? Ka nu rinnabia se'e yiesi lo yu‑ni, ¿si ka benne lhe'esi gekani rukixakana belhiu‑na ak? ¿Ka benne dittu ak? ");
INSERT INTO zae_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro‑ni nna bekabina, rana: ―Ka benne dittuba xa. Nianna ra Jesús‑ni. ―Ganna aníha nna ka benne lhe'esi gekinna labí elha ralha ka nuná kixakana. ");
INSERT INTO zae_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ttaka ki abittu ituxxukinna nna, ugía ro'o indatoo‑na nna bedelha yexxa nu rudaxxu belha‑na. Belha nu udaxxulu sisi'a tteha nna ixxálu ro'oni. Ro'o belhaha saxxakalu ttu belhiu. Bedaxxu belhuha nna ugía gwatixa gelu lhe gwatixa kia lhe. ");
INSERT INTO zae_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","La'aniagaba nna ubiga ka benne rudhetini Jesús‑ni nna ráke bie: ―Delo iyá ka benne rinnabia Tata Do Yebáha, ¿núke ra xxeniru leke? ");
INSERT INTO zae_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús‑ni nna uxie ttu nuto nna bedúbie na lagwi geke, ");
INSERT INTO zae_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nianna ree: ―Netiru ria, ganna abíba otsea elha ruin gele nna uinle attiba runi ttu nuto, la'ania nna labí akale nu innabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Laxkala benne unie attiba runi nuto‑ni orexxa gaa lebie abittu unie deki ra xxeni lebie, benneha nuha ake benne inná xxeniru lebie delo adí ka benne rinnabia Tata Do Yebáha ke, ");
INSERT INTO zae_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","lhe anágaba nuxaba benne de ria lebie neti, ganna benneha ulabie ttu benne runi attiba runi nuto‑ni, neti nuha rulabi benneha. ");
INSERT INTO zae_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ttaka ganna nuxa ttu benne unie dhi yiebie ttu ka benne abittu ra xxeni leke, delába ttu ka benne chi ria leke neti, ganna benneha dhi yiebie ttu ka benne chi ria leke netiha ki uinke nu satsa, benne unie aníha tserula saríane uxxigakana yienie ttu íyya xeni ge ttu mulinu nna udelhakane lhi'u lhe'e indatooha. ");
INSERT INTO zae_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","’¡Gwalíchiru le yiesi lo yu‑ni! Satíaba tee nu ruinna ki rinitti ka benne ki ruinke nu satsa, kumu anába teeki aka. Ttaka gwalíchiru le nu unnittina ka benneha ki uinke nu satsa. ");
INSERT INTO zae_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Laxkala ganna ni'alu‑na o nálu‑na usigakana lu ki uinlu ttu bixa nu satsa, tsa ttela uchú ka nuná nna uru'una kana. Kumu tserula taríana lu esinlu ata aka benlu ttu dia liiha ganna ridá natsalu o anka choku ni'a nálu, a laa kila sia ixpa lha'a nálu lhe sia ixpa lha'a ni'alu lhe, nianna iru'unalu tsialu lo gi ata satíaba rite loniha. ");
INSERT INTO zae_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ganna iyya lolu‑na uinna ki uinlu ttu bixa nu satsa, tsa ttela ulea nuná nna uru'una na. Kumu tserula saríana lu esinlu ata aka benlu ttu dia liiha len suna ttu lha'aba iyya lolu, a laa kila esinlu len ixpa lha'a lolu ata uyúlu elha disaha nna iru'unalu tsialu lo giha. ");
INSERT INTO zae_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Gwaluyú gele bittu ku'u ni'ale ttu ka benne abittu ra xxeni leke se'e nii, kumu neti ria, ka anjeli gekeha satíaba se'e ka benneha rinnabake geke arlo Tata kia do yebáha. ");
INSERT INTO zae_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kumu neti benne daya yebáha daya ugila ka nu chi bigannakana lo neda ge Tata kia do yebáha, ki odiláya kana. ");
INSERT INTO zae_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Bí rakinle uni ttu benne ganna ttixka se'e ttu gayua (100) ka neru gebie, nianna igannanie ttu ka nuha? ¿Laaba ganna guse'e bixxibe a tta bixxi chennia (99) ka neruha lhe'exxiha nna tsie ugila nu bigannaha? ");
INSERT INTO zae_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ganna chi gwaxxake neruha, netiru ria, ittarula edú lebie ge nuha attichula ge a tta bixxi chennia ka neru ka nu abittu bigannaha. ");
INSERT INTO zae_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Anágaba Tata gele do yebáha, labí raka le benneha nnitti niru ttú ka benne abittu ra xxeni leke se'e nii. ");
INSERT INTO zae_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Ganna ttu betsi to geri'i udhakana lu ttu bixa, ttu nu abittu anka tse, ugía nna suna ttúbana unne lenna. Ganna si gokinniba ikini deki binittina, la'ania nna chiba udaalu beyaka tse lenlu na. ");
INSERT INTO zae_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ttaka ganna nuha abittuba etabinna gelu, la'ania nna uche attu o a chupa ka benne nna unne lenna. Aníha kini iyá nu inne lenlu naha, iyienin naga a chupa tsunna ka benneha. ");
INSERT INTO zae_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ganna si abittugaba iyieninna ge ka benneha, la'ania nna utixxi'a nuha len adíru ka benne chi ria leke Tata Do Yebáha. Ganna si abittugaba iyieninna ge ka benneha, la'ania nna gwaluyúba na attiba ttu nu abittu chi ria leni Tata Do Yebáha lhe gwaluyúba na attiba ttu gwekixa ruin satsa lhe. ");
INSERT INTO zae_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Netiru ria, yiesi lo yu‑ni iyába nu innále abittu dika uin ka benne, yebáha chiba bodha'an Tata Do Yebáha deki abittu aka nuha nna iyába nu innále gwa dikaba uin ka benne yiesi lo yu‑ni, yebáha chigaba bodha'an Tata Do Yebáha deki gwakaba nuha. ");
INSERT INTO zae_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Rinnea attu libe ria le, yiesi lo yu‑ni ganna chupale okinni ikile innele turo'o ttixka bixa innabale len Tata kia do yebáha, la'ania nna gutebe nu innabaleha. ");
INSERT INTO zae_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kumu ata ritupa chupa o tsunna ka benne de ria leke kia, neti niha‑gaba dua lenke. ");
INSERT INTO zae_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pedruha nna ubigana ata du Jesús‑ni nna unnaba tisane, rane: ―Tata xisi to, ¿balha lidú teeki dhia elha xen lasi ge ttu betsi to kia ttixka bixa udhake neti? ¿Si gasi (7) libeli? ");
INSERT INTO zae_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús‑ni nna bekabie ree: ―Laa rigaa lu gasi libe dhilu elha xen lasi gebie. Neti ria lu, balhaxaba libe. ");
INSERT INTO zae_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’De nuha nna Tata Do Yebáha, tti rinnabie ka benne, elha rinnabia geeha raxxína na len nu ben ttu nu rinnabia ge ttu yiesi. Nuha beyaxina ka nu riben sina geniha kini bennabana ka nuha ki kixxi'akana ttixa dia belhiu geniha. ");
INSERT INTO zae_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tti chi udulona bennabana ka nuha ki kixxi'akana ttixa chi dia belhuha, nianna tti bisin lenkana ttu nu riben sina geniha daana ixeni belhiu geni. ");
INSERT INTO zae_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ttaka nuha, kumu de labí dhaana kixana belhuha, de nuha nna udhelha nu rinnabiaha utto'okana na lhe utto'okana nuila geniha lhe ka xi'inniha lhe, anágaba utto'ogabakana iyá nu se'e geni. Aníha kini dhaana kixana belhiu daanaha. ");
INSERT INTO zae_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nu ren sina daa belhuha nna bedú xibini axtaba bettudhi loni lo yu arlo nu rinnabiaha nna unnaba ditibana len nuha, rana na: “Uledachi xa tata to. Neti gwagixabaa iyá belhiu geluha.” ");
INSERT INTO zae_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nu rinnabiaha nna gwatuaba leni nu ren sina geniha nna gwa uxíbana elha xen lasi ge belhiu daanaha. Nianna gwa bolhábana na. ");
INSERT INTO zae_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Tti beriana lisi nu rinnabiaha nna beti'ana attu ka benne riben lenna turo'o sinaha. Benneha nna suna ttu lattiba belhiu daabie geni. Nianna bedaxxu ttebana benne daa belhiu geniha nna bettupana yienie nna rane: “¡Utixa belhiu kia daaluha!” ");
INSERT INTO zae_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Benneha nna biyachu ttebe bedú xibie axtaba bettudhi loe lo yu nna unnabe loni ree na: “Uledachi xa tata to. Neti gwagixabaa iyá belhiu daya geluha.” ");
INSERT INTO zae_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ttaka lana nna labi uka leni. Ugíalana gwaga'ana benneha lisiyya axtaliba ki biri'a lenna utixa benneha iyá belhiu geniha. ");
INSERT INTO zae_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tti bina adí ka benne riben sina ge nu rinnabiaha ge nu chi ukaha nna yalhá bituxxukanie. Nianna tti diake gwattixxi'akanie nu rinnabiaha ge iyá nu chi ukaha. ");
INSERT INTO zae_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nu rinnabiaha nna uxina na, rana na: “¡Aaluxa nu re satsa leni! Neti gwa uxíbaa elha xen lasi gelu ge iyá nu daaluha kumu de unnaba ditilu loa. ");
INSERT INTO zae_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Lu nna, ¿laa a gwatuachiba lelu nu riben lenlu turo'o lo sina kia‑ni, attiba neti gwa gwatuaba lasia lu?” ");
INSERT INTO zae_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nu rinnabiaha nna bisa'a xxattinna nna betena na lasi ná ka nu uyakana na axtaliba ki utixana iyá belhiu daanaha. ");
INSERT INTO zae_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nianna tti ra Jesús‑ni: ―Anágaba udhaka Tata kia do yebáha le ganna abíba itú iki itú lele dhile elha xen lasi ge ttu betsi to geri'i. ");
INSERT INTO zae_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tti chi uluxani Jesús‑ni unnebie nu reeha, nianna beriabie Galilea‑ni nna diabie daka Judea, daka attu ladu ge yoo Jordán‑ni. ");
INSERT INTO zae_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ixe juisiru ka benne danalhake bie, niha beyonie ka benne rani. ");
INSERT INTO zae_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ttu chupa ka fariseo‑ni nna ubigakana ata dueha, ruinkana kini ku'ukane prueba. De nuha nna unnaba tisakane, rákane: ―¿Si gwakaba udhá iki ttu nubiyú nuila geniha meskiba ttu bixaru ge? ");
INSERT INTO zae_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Lee nna bekabie gekani, ree: ―¿Si lagwa chi belabale lo ka yetsi ge Tata Do Yebáha, ata dia ra deki lee, tti sisi'a tte benie ka benne, “nuila lhe nubiyúba benie ke”? ");
INSERT INTO zae_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Rágabe: “De nuha nna teeki udhan nubiyúha ka tata nan geniha nna utsá náni len nuila geniha. La'ania nna ixpabakana akakana ttisidiba ttúba benne.” ");
INSERT INTO zae_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Laxkala labíru anka ka nuha chupa benne, sinuki ttúba benne chi anka ka nuha. Laxkala ka nu chi beketi Tata Do Yebáha, labí dika etsila ttu benne ka nuha. ");
INSERT INTO zae_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nianna ra ka fariseo‑nie: ―¿Beakala lo bia bennabi bodha'an Moisés‑ni dia ra deki ttu nubiyú gwakaba ilhidhana ttu yetsi ata inná lo yetsiha deki gwakaba ela'ana len nuila geniha? ");
INSERT INTO zae_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús‑ni nna ree kana: ―Moisés‑ni begwelha galána ela'ale len ka nuila gele‑na kumu de ankale nu a riyienini. Ttaka tti sisi'a tteha, labí aná ga'anna aka. ");
INSERT INTO zae_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Neti ria le, ttu nubiyú ganna kwentaba ela'ana len nuila geniha, ganna abittuba delo ni'a ge de bisá nuilaha attu nu subi, nianna ganna nubiyúha edína attu nuila subi, la'ania nna satsaba nuha chi ruin nubiyúha. Anágaba nubiyú edína nuila chi bedhá ikikaniha, satsagaba nuha chi uin nubiyúha de edína nuilaha. ");
INSERT INTO zae_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nianna tti ra ka benne rudhetinieha: ―Ganna ralu anála rate ttu nubiyú lenna nuila geni, ganna aníha nna tserula abittu utsá ná ttu benne. ");
INSERT INTO zae_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús‑ni nna bekabie geke, ree: ―Labí iyá ka benne ankake nu dika tte dákanie nu ria‑ni, sinuki sunruba ka benne chi begwelha Tata Do Yebáha ke ki tte dákanie, ka benneha‑ruba nuha gwate dákanie nuní. ");
INSERT INTO zae_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Se'e ka nubiyú labí rutsá nákani, kumu lhe'e tata nan gelikani chi ankakana deki labí dho lenkana nuila. Se'e adí ka nubiyú nna labí rutsá nákani, kumu ka benne se'e yiesi lo yu‑niba riguake ata do ridá lekani nuila. Anágaba nna se'egaba ka benne biyú titúbake rokinni ikike ráke: “Ri'itu labí tse'etu len nuila.” Aníha ki tse'eke udo leke uinke nu raka le Tata Do Yebáha. Laxkala benne dhielhe unie nu ra ka tisa‑ni nna unie na. ");
INSERT INTO zae_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nianna bisin len ka benne ttu chupa ka nuto arlo Jesús‑ni ki ixxua nábie ikikani lhe innabe gekani len Tata Do Yebáha lhe, ttaka ka benne rudhetinieha nna rudhaka disalake ka benne cheke ka nutoha. ");
INSERT INTO zae_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nianna tti ra Jesús‑ni ke: ―Gwalugwelha ka binto‑na itakabi len neti, bittu usunale, kumu ka benne runi tti ruin ka binto‑na, luesi ka benne‑na nuná ralhake akake ka benne innabia Tata Do Yebáha ke. ");
INSERT INTO zae_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Iki de chi uxxua nábie iki ka bintoha, nna bedábie ata dueha nna deyye. ");
INSERT INTO zae_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ttu nu kwiti ubigana ata du Jesús‑ni nna unnaba tisane, rana: ―Maestru, lu ankalu benne tse. Unáchu, ¿bí nu tse unia ki satíaba aka bania arlo Tata Do Yebáha? ");
INSERT INTO zae_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús‑ni nna bekabie geni, ree na: ―¿Beaka ralu deki ankaa benne tse? Sunruba ttu benne do anke benne tse, delába Tata Do Yebáha. Ganna raka lelu aka benlu ttu dia lii, bedo tisa ge nu bodha'ane uinri'i ganna xa. ");
INSERT INTO zae_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nubiyúha nna rana: ―¿Nú ka tisa bodha'aneha udorua tisa geni? Lee nna ree: ―Bittu akalu nu runi elhutti lhe bittu dho lenlu nu abittu anka latselalu lhe bittu lhanalu lhe bittu kwentaba usialu iki ttu benne deki benie ttu bixa. ");
INSERT INTO zae_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Anágaba nna tsia lelu ka tata nan gelu, lhe akinlu ge attu benne atti tteba rakabin gelu. ");
INSERT INTO zae_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nu kwitiha nna rana: ―Attili ankaa nutoha, chi rudoa tisa ge iyába nu bodha'an benneha. ¿Bíruala riyasaa unia ganna? ");
INSERT INTO zae_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús‑ni nna ree na: ―Ganna raka lelu akalu benne runi itá su, beyya nna betto'o iyá nu tee gelu nna belhiu ge nuha nna begwe ka benne abittu geke tee. Ganna aníha uinlu, la'ania nna gwattaba elha tse gelu yebáha. La'anialigaba nna chinka utá tenalha neti. ");
INSERT INTO zae_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tti biyienin nu kwitiha nu rabie naha, nianna si'iba bedúna leni deyyana kumu de tee xxatta geni. ");
INSERT INTO zae_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesús‑ni nna ree ka benne rudhetinieha: ―Netiru ria, tsitsiba anka ki isin ttu nu tee geni akana nu innabia Tata Do Yebáha na. ");
INSERT INTO zae_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Rinnea attu libe ria: adírula satti ga'a ttu camellu lhe'e yieru do xan ttu yoxa attichula ga'a ttu nu tee geni, kini akana nu innabia Tata Do Yebáha na. ");
INSERT INTO zae_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tti biyienin ka benne rudhetinieha nu reeha, yalhá bebanakanie nna ráke: ―Ganna aníha nna, ¿nú dhaana esinna len Tata Do Yebáha? ");
INSERT INTO zae_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús‑ni nna rugíabe loke nna rabie ke: ―Len ka benne se'e yiesi lo yu‑ni, abittu galá aka, ttaka len Tata Do Yebáha iyába gwakaba. ");
INSERT INTO zae_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nianna unnaba tisa Pedruha, rane: ―Ri'itu bedhába ikitu iyá nu tee getu nna danalhatu lu. ¿Bíla ralhatu dhitu ganna? ");
INSERT INTO zae_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús‑ni nna ree ke: ―Netiru ria, atti isia sá ekubi yiesi lo yu‑ni lhe iyá nu se'e loni lhe, la'ania neti benne daya yebáha dhoa lo xxila nu rapi edha linníha ata innabiaya. Anágaba lebi'i ka nu danalhale neti ebiagabale lo tsi'inu (12) ka xxila ata tse'ele innabiale kini uinle elhuxtisi ge ka benne tsi'inu (12) dhi datiake benne tee lábie Israel. ");
INSERT INTO zae_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Lhe anágaba nuxaba benne ganna si de danalhe neti nna bedhá ikie lisieha lhe ka betsieha lhe ka daneha lhe ka xxudi ixnábie lhe ka xi'inie lhe o si ka lo yu geeha, la'ania nna gayua (100) libe tteba luesi nu bennittieha edíe. Anágaba nna ralhagabe aka benbie ttu dia lii. ");
INSERT INTO zae_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ttaka ixe ka nu ra xxeni lekani nnanna, eyakakana ka nu abittu ra xxeni lekani la'ania, nna ixe ka nu abittu ra xxeni lekani nnanna, ka nuha‑la eyakakana ka nu inná xxeni lekani la'ania. ");
INSERT INTO zae_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Tata Do Yebáha, tti rinnabie ka benne, elha rinnabia geeha raxxína na len nu ben ttu nubiyú yadinna ka ya uva lo yu geniha. Nubiyúha dila tteba udána diana ugila ka nu kwenkana lo yu geni ata yadinna ka ya uvaha. ");
INSERT INTO zae_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Unne lenna ka nu kwen sinaha kixana kana ttu denario nu anka lhiaxa ge ttu sá. Nianna tti udhelhana kana lhe'e ya uvaha. ");
INSERT INTO zae_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Atti chi ugwena retin jaa (9) dilaha nna bederiana attu libe nna bedelenna attu chupa ka nubiyú se'e nattibakana ata raka i'iyaha. ");
INSERT INTO zae_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nianna tti rana ka nuha: “Anágaba lebi'i gwaltsiagaba kini kwenle sina lhe'e ya uva kiaha. Neti gwagixabaa le attiba ankaba geni.” Aníoka nna dia tteba ka nuha. ");
INSERT INTO zae_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aníha‑gaba bedeonna tti chi begwena retin tsi'inuha (12) lhe tti begwena retin tsunnaha lhe. ");
INSERT INTO zae_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Atti chi ugwena retin gayuha nna bederiana attu libe nna bedelenna adíru ka nubiyú se'e nattibakana niha. Nianna tti redeana ka nuha: “¿Beaka kwentaba se'ele betú sába nii?” ");
INSERT INTO zae_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ka nuha nna bekabikana geni, rákana: “Kumu lanú chi bedaxxuna ri'itu ki kwentu sina.” Nubiyúha nna rana kana: “Anágaba lebi'i gwaltsiagaba lhe'e ka ya uva kiaha ki kwenle sina, neti nna gwagixabaa le attiba ankaba geni.” ");
INSERT INTO zae_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Atti chi ulha sáha nna ra xxana yuha nu baninna ka nu riben sinaha: “Beyaxi ka nu yu'u sina‑na nna begwekana lhiaxakani. Dhulolu len ka nu bisia bitoha nna ulhuxalu len ka nu bisia dila tteha.” ");
INSERT INTO zae_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tti ubiga ka nu uta'a sina retin gayuha nna kua ttu ttubakana uxíkana ida'aba nu ankaba lhiaxa ge betú sá. ");
INSERT INTO zae_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Laxkala atti ubiga ka nu uta'a sina dila tteha nna ukakinna deki gaxarukana xxeni, ttaka kua ttu ttukana uxígabakana nu ankaba lhiaxa ge ttu sá. ");
INSERT INTO zae_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tti chi uxíkana belhuha, nianna udulokana rinne lhákana ge xxana yuha, rákana: ");
INSERT INTO zae_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ki ka nu se'e nii, deloliba bisia ka nuní, suna ttu uraruba urenkana. Delo nna ttúba utixalu ka nuní len ri'itu. Ri'itu betú sába bechíatu lo sina‑ni lhe uyu'utu lhe'e ubisa lhe.” ");
INSERT INTO zae_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ttaka xxana yuha nna bekabina ge ttu ka nuha, rana na: “Biyúruga xa betsi to, neti labí runia nu abittu anka tse lenlu. ¿Laaba chiba beya'anri'i deki gwagixabaa lu nu ankaba lhiaxa ge ttu sá? ");
INSERT INTO zae_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ne belhiu gelu tee nii nna beyya. Neti rakaba lasia kixaa ka nu bisia bito‑ni ttiba utixaa lu. ");
INSERT INTO zae_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kumu neti gwakaba kia unia len belhiu kia‑ni attiba rakaba lasia. Lu nna, ¿si ritisibinlu neti de ankaa benne redá lasia rutea?” ");
INSERT INTO zae_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nianna tti ra Jesús‑ni: ―Laxkala ka nu daa lo xubanaha, ka nuha‑la akakana ka nu nnerukana nna ka nu daneruha nna akakana ka nu sanalha lo xubana. Kumu ixeba ka benne raxi Tata Do Yebáha, ttaka nna ttu chuparubake rukwebie kini akake gebie. ");
INSERT INTO zae_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Laka yu'u Jesús‑ni neda die lhe'esi Jerusalén‑ni, nianna uxie ka benne tsi'inu (12) rudhetinieha. Sun labake uxie attu ta subi, nianna rabie ke: ");
INSERT INTO zae_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Gwaluyúruga, chiba diari'i isinri'i Jerusalén‑ni nna neti benne daya yebáha chiba dabigana utekana neti lasi ná ka nu loni ge ka bixxudiha lhe lasi ná ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe. Ka nuha ukinnibakana neti ki gattia. ");
INSERT INTO zae_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nianna tti utekana neti lasi ná ka nu dittu, ka nu abittu ankakana nu Israel. Ka nuha nna uxisilakana kia lhe ukulhakana neti lhe, nianna tti utákana neti lo ya kurusi. Ttaka ganna chi beyonna ubisaha nna eyaka benbaa. ");
INSERT INTO zae_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nan ge Santiago‑ni lhe Juan‑ni lhe ubige chebie ixpabakana arlo Jesús‑ni, nna bedú xibie, unnabe len benneha, ree: ―Neti innabaa lu ttu bixa xa tata. ");
INSERT INTO zae_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús‑ni nna ree benneha: ―¿Bí raka lelu innabalu len neti? Benne nuilaha nna bekabie ree: ―Ugwelhalu kwia ixpa ka xi'inia‑ni kwe'elu ganna chi innabialuha, ttúkana dhokana daka ná benlu, attúkana nna dhokana daka ná yattilu. ");
INSERT INTO zae_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús‑ni nna ree kana: ―Lebi'i labí yule nu rinnabale. ¿Si gwadaale uyúle luesi elha disa uyúa‑ni lhe si gwadaale satele nu satea‑ni lhe? Lakana nna bekabikana, rákane: ―Ila. Gwadaa galátu. ");
INSERT INTO zae_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Lee nna ree kana: ―Gwalí galá, gwadaabale uyúle luesi elha disa uyúa‑ni lhe gwadaabale satele luesi nu satea‑ni, ttaka nu rale deki ugwelhaa le kwiale ttúle daka ná bania nna attule nna daka ná yattia, nuná labí neti ralhaa innía ganna gwaka. Kumu Tata kialiba chi ga'ananie ka benne kwiake niha. ");
INSERT INTO zae_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tti biyienin a tsii ka benne rudhetini Jesús‑ni nu rinnaba ka benneha, nianna bisa'a ttebakanie len ixpa betsiba ka benneha. ");
INSERT INTO zae_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús‑ni nna uxie iyába ka benneha nna ree ke: ―Lebi'i gwa yúbale, yiesi lo yu‑ni ka nu rinnabia‑na rinnabiabakana ka benne gekani attiba rakaba lekani. Anágaba ka nu ra xxeni lekinna, nu rábakana raka. ");
INSERT INTO zae_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ttaka lebi'i labí aná dika udhaka luesile. Lebi'i nu uinlale, ganna nuxa ttúle raka lele akale nu ra xxeni leni delo iyále, benne ra xxeni leeha, akalee benne ixúni adíle ");
INSERT INTO zae_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","nna benne raka lebie ake nu loni ge iyále, lalee nuha ake attiba ttu nu to'o lo sina, ixúbie kini ute nábie len adíle ");
INSERT INTO zae_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ttiba neti benne daya yebáha, laa dagaa yiesi lo yu‑ni kini ixúti le uinle nu innía, sinuki dalaa ki ixúa ute náya len nuxaba benne lhe anágaba daya kini gattia kixaa ge ka tulha daa ka benne, ki odiláya ixeke. ");
INSERT INTO zae_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Atti beria Jesús‑ni lenie ka benne rudhetinieha lhe'esi Jericó‑ni, ixe juisiru ka benne danalhake bie. ");
INSERT INTO zae_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Chupa ka benne lo xua se'eke ro'o nedaha. Tti biyienkanie daa Jesús‑ni ritebie ata se'ekeha, nianna uresi'a ttebake, ráke: ―¡Benne datia David, gwatuachi lelu ri'itu xa Tata Xisi to! ");
INSERT INTO zae_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ka benne danalhaha nna rudhaka disalake ka benneha kini eyaka siike, ttaka ka benneha nna adíla idisa ribesi'ake, ráke: ―¡Benne datia David, gwatuachi lelu ri'itu xa Tata Xisi to! ");
INSERT INTO zae_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nianna tti gwalheda Jesús‑ni nna uxie ka benneha nna ree ke: ―¿Bí raka lele udhakaa le? ");
INSERT INTO zae_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ka benneha nna ráke: ―Raka letu edhalilu ka iyya lotu‑ni xa tata. ");
INSERT INTO zae_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nianna gwatua tteba le Jesús‑ni ke nna utane ka iyya lokeha. Looraha tteba nna belákanie. Nianna dia ttebake danalhake bie. ");
INSERT INTO zae_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tti chi dabiga Jesús‑ni len ka benne rudhetinieha lhe'esi Jerusalén‑ni, nianna bisinke lhe'esi Betfagé ata do i'iya ata daa ka ya olivuha. Nianna tti udhelhe chupa ka benne rudhetinieha, ");
INSERT INTO zae_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nna ree ka benneha: ―Gwaltsia lhe'e yiesi to re arlori'i‑ni. Naa saxxakale ttu burru nalhana, na'aya xi'inni. Gwalidhasi na nna gwaltá lenkana. ");
INSERT INTO zae_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ganna nuxa gana le bixa, gwaligasi na: “Jesús benne anke Xxanari'iha‑ba riyasanie ka nuní nna gweteka'an ttebe kana.” ");
INSERT INTO zae_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Aníha uka ki gwado tisa ge nu unne benne uke profeta ge Tata Do Yebáha, tti ree: ");
INSERT INTO zae_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gwaligasi ka benne lhe'esi Sión‑ni: “Gwaluyúruga. Ne benne innabie leha chi daa naa. Labí ra xxeni lebie; dabie doe kwe'e ttu burru to, ttu burru kwiti to ankana xi'in ttu burru chi ruja yua.” ");
INSERT INTO zae_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ka benne rudhetinieha nna ugíake lhe'esiha nna benbake atti tteba ra Jesús‑ni ke. ");
INSERT INTO zae_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Gwaxxíbake burruha lenna xi'inniha, nianna tti uxxuake ka xokeha kwe'e ka nuha, nianna tti udoe. ");
INSERT INTO zae_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ixe juisiru ka benne ribeake ka xokeha nna ritsilake lo nedaha kini ritebie, adíke nna lo ka yaga daa niha‑ba rigitsake nna ritsilake lo nedaha. ");
INSERT INTO zae_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ka benne danalhaha lhe ka benne daneruha lhe ribesi'abake ráke: ―¡Xxeni ra lelu! ¡Lu ankalu Benne datia David! ¡Karubárulu! ¡Lu ankalu benne udhelha Tata Xisiha! ¡Xxeniba ra lelu xa Tata Do Yebaa! ");
INSERT INTO zae_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tti chi uta'a Jesús‑ni lhe'esi Jerusalén‑ni nna bisatsa tteba iyába ka benne lhe'esiha nna rinnaba tisa luesike, ráke: ―¿Nú benne nuná daa naa? ");
INSERT INTO zae_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ka benne danalhake bieha nna ráke: ―Jesús ge lhe'esi Nazaret nu rena daka Galilea‑niba benne‑ni. Benne‑ni anke profeta ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Atti uta'a Jesús‑ni lali'a yotu ge Tata Do Yebáha, bochesue ka nu se'e gwetto'o lali'a ge yotuha lhe ka nu yu'u ugo'oha lhe. Nianna berixxi loe ka mexa ge ka nu se'e gwetsea belhuha lhe ka xxila rise'e ka nu rutto'o ka bechaha lhe. ");
INSERT INTO zae_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Labie nna ree kana: ―Tata Do Yebáha lo ka yetsi geeha ree: “Yo'o kia‑ni ixúe kini ilhapi ka benne tisa len neti.” Ttaka lebi'i nna ttiba belea ata yu'u ka ubanala chi reyoinle yotu‑ni. ");
INSERT INTO zae_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ro'o yotuha ubiga ka benne xua loke lhe ka benne ridá natsa lhe, ubigake ata do Jesús‑ni. Lee nna gwa beyoinbe ke. ");
INSERT INTO zae_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ttaka ka nu loni ge ka bixxudiha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni, yalhá bisa'akinna tti bilákinna ka nu rebaninri'i geni ruin Jesús‑ni lhe tti biyienkinna ge ka nuto yu'u ro'o yotuha ribesi'akana, rákana: “¡Xxeniba ra le Benne datie David‑ni!” ");
INSERT INTO zae_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nianna tti rákane: ―¿Si gwa riyieninlu nu ra ka nuto‑na? Lee nna bekabie ree: ―Gwa rien galáti. ¿Si lagwa chi belabale lo ka yetsi ge Tata Do Yebáha ata dia ra: Ka nuto elha to‑na lhe ka nuto sa rasina lhe, ka nuná chi benlu kini ulhakana le'a gelu? ");
INSERT INTO zae_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Niha‑ba bese'e Jesús‑ni kana nna bedábie lhe'esi Jerusalén‑ni nna die bisine lhe'esi Betania. Lhe'esi Betania‑ba beya'ane loolhaha. ");
INSERT INTO zae_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ugwani dilaha tti beyeki Jesús‑ni deyu'e neda deyye lhe'esi Jerusalén‑ni, nianna tti ugwetti bitunie. ");
INSERT INTO zae_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ro'o nedaha bilánie du ttu ya higu. Nianna ubige ata du nuha, ttaka labí gwaxxake higu loni, sunruba lhaga geni sia. Nianna tti belise ya higuha, ree na: ―¡Ni tsa labíru kwia nu xixxi gelu! Looraha tteba nna ubisi tteba yagaha. ");
INSERT INTO zae_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ka benne rudhetinieha nna tti bilákanie nu ukaha nna bebanabakanie. Nianna tti ráke: ―¿Gasina nna ttu nnelaba chi bibisi ya higu‑ni? ");
INSERT INTO zae_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús‑ni nna bekabie ree: ―Netiru ria, ganna ruxxen tsitsi lele ge Tata Do Yebáha nna abittu rudú chupana lele deki gwakaba nu innabaleha, la'ania nna alaa suna luesi nu benia len ya higu‑niruga gwaka gele uinle, gwakagaba gele gale i'iya do naa: “Ubi'etta ata dolu‑na nna ugía gwaxxudi lhe'e indatooha.” La'ania nna gwakaba nu innáleha. ");
INSERT INTO zae_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Laxkala iyába nu innabale atti innele len Tata Do Yebáha, ganna gwalíga ruxxen tsitsi lele ge benneha deki gwadíbale nu rinnabaleha, la'ania nna gwadíbale nuha. ");
INSERT INTO zae_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesús‑ni bisine ro'o yotuha nna laka due rule'enie ka benne, nianna tti bisin ka nu loni ge ka bixxudiha lhe ka benneola ge ka nu Israel‑ni lhe, nianna rákane: ―¿Bí lo neda nuná rapalu ki ruinlu ka nu ruinlu‑na? ¿Núla betena lo neda gelu kini ruinlu aná? ");
INSERT INTO zae_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús‑ni nna bekabie, ree kana: ―Anágaba neti innaba tisagabaa le ttu bixa. Ganna lebi'i ekabile ge nu innaba tisaa le, la'ania nna neti gwagixxi'agabania le nú betena lo neda len neti kini runia ka nu runia‑ni. ");
INSERT INTO zae_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Gwalinná sanga, ¿nú iki biria ki begadi Juan‑ni ka benne inda? ¿Si iki Tata Do Yebáha ak? ¿Iki ka benne se'e yiesi lo yu‑ni ak? Nianna tti udulokana ra luesikani: ―Ganna gari'i na: Tata Do Yebáha‑ba betebie lo neda len benneha, la'ania nna innána: “¿Beakala nna a ugía lele ge benneha ganna?” ");
INSERT INTO zae_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nna ganna innári'i: Ka benne se'e yiesi lo yu‑niba udhelhake benneha, ttaka rasibinri'i ka ebi'i noo ka benne ri'i, kumu iyábake ráke deki Juan‑ni uke ttu profeta ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nianna tti bekabikana ge Jesús‑ni, rákana: ―Labí yutu nuxa udhelhana benneha. Jesús‑ni nna ree kana: ―Anágaba neti bittugaba kixxi'ania le nú rutena lo neda len neti ki runia aní. ");
INSERT INTO zae_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Rágaba Jesús‑ni ka nu loni ge ka bixxudiha lhe ka benneola ge ka nu Israel‑ni lhe: ―¿Bí rakinle ge nu kixxi'aya‑ni? Udo ttu nubiyú use'e chupa ka xi'in biyúni. Nianna rana xi'in biyú neru geniha: “Xi'ini to, ugía gwachen sina lhe'e ya uva kiaha nasá.” ");
INSERT INTO zae_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nu kwitiha nna bekabina rana: “Labí tsia neti.” Ttaka delola nna beleninna nna gwa ugíabana. ");
INSERT INTO zae_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nianna tti ubiga xxudiha nna nuha‑gaba redeana attu xi'in biyúniha. Nuha nna bekabina rana: “Gwaya'abaa xa tata.” Ttaka labí ugíana. ");
INSERT INTO zae_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nianna tti redea Jesús‑ni ka bixxudiha lhe ka benneolaha lhe: ―¿Nú ka nuha rakinle gwa benkana nu ra xxudikaniha ganna? Lakana nna rákana: ―Xi'in biyú neru geniha. Jesús‑ni nna redeabie kana: ―Netiru ria, ka gwekixa‑na lhe ka nuila rutto'o latikinna, nnelarula dhielha ka nuná akakana ka nu innabia Tata Do Yebáha kana attichula lebi'i. ");
INSERT INTO zae_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Aná ria, kumu Juan benne begadi indaha gwa bitaba benneha bele'enie le ttu neda tse, ttaka lebi'i nna labí ugía lele gebie. Ka gwekixa‑na lhe ka nuila rutto'o latikinna nna gwa ugíaba lekani gebie. Lebi'i nna meskiba gwa bilenle iyá nu ben benneha nna labí bodúna le ge nu ruinle kini tsia lele gebie. ");
INSERT INTO zae_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Gwaludoruga nagale kixxi'aya attu nu raka lasia unale ge ttu benne beyade ka ya uva lo yu geeha. Nianna bedheabie abi'iba ro'o yuha nna tti ulekie ttu xieru lagwi ge yuha ata idhie uvaha. Bedogabe ttu yo'o ttu nu yadha kini dho benne ulatsie ki anuttu nu salhidana uvaha. Nianna bete ganne yuha len ka nu kwenkana nuha, nna tti biriabie diabie idittu. ");
INSERT INTO zae_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tti chi bisia sá exú uvaha nna udhelha ttebe ka benne riben lo sina geeha, udhelhe ke ata se'e ka nu riben lo yu geeha kini utekana nu ralhe dhie ge yuha. ");
INSERT INTO zae_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ttaka ka nu riben lo yuha nna bedaxxulakana ka benne udhelheha: ttu ka benneha benkane gwe, attue nna tsa ttela bettikane nna benne beyonnaha nna besiakane íyya. ");
INSERT INTO zae_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Iki de nuha nna benne anka xxana yuha udhelharue adí ka benne riben lo sina geeha. Adírula ixeke udhelhe attichula ka benne udhelhe sisi'a tteha, ttaka ka nu riben lo yuha nna aníha‑gaba bododhakakana ka benneha. ");
INSERT INTO zae_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Iki deliba nuha nna tti udhelhe kwinaga xi'in biyúeha, kumu rakanie: “Xi'inia‑niligaba nna gweyya lekanie.” ");
INSERT INTO zae_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ttaka tti bilákin nu riben lo yuha xi'in biyúeha, nianna ra luesikani: “Lana nuná eya'anna lo yu‑ni. Uttiri'i na kini eya'anri'i len yu‑ni.” ");
INSERT INTO zae_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nianna tti bedaxxukana benne kwitiha, uleakane ro'o yuha nna bettikane. ");
INSERT INTO zae_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nianna tti ra Jesús‑ni ka nu loni ge ka bixxudiha lhe ka benneola ge ka nu Israel‑ni lhe: ―Ganna chi esia xxana yuha, ¿bí rakinle udhake ka nu urenkana lo yu geeha? ");
INSERT INTO zae_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Lakana nna rákana: ―Labí satua lebie ka nu runi satsaha, uttibe ka nuha. Nianna tti utebie yu geeha len ka nu subi ki kwenkana nuha, ki ugwekane nu ralhe dhie ganna chi isia sá exú nu xixxi ge ka yagaha. ");
INSERT INTO zae_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús‑ni nna ree kana: ―¿Si niba tsa abittu chi belabale lo ka yetsi ge Tata Do Yebáha ata dia ra: Íyya nu ulu'u ni'a ka nu rukuakana yo'oha, íyyaha‑la nuha chi bisinna beyakana nu rixúru. Tata Xisiha‑ba benie kini uka aní nna rebanabinri'i rilenri'i nu benie? ");
INSERT INTO zae_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","De nuha nna neti ria le, Tata Do Yebáha kuabe lo neda gele kini abitturu akale ka nu innabie. Ka benne uinke nu tsu'u lebie, ka benneha nuha gwa ralhake akake ka benne innabie. ");
INSERT INTO zae_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Laxkala nuxaba benne ganna ibixxie iki íyya nu ulu'u ni'akaniha, tuttíruba iyuya benneha lhe anágaba ganna ttixka íyyaha iginnina iki ttu benne, utsutsa tábana benneha. ");
INSERT INTO zae_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tti biyienin ka nu loni ge ka bixxudiha lhe ka fariseo‑ni lhe nu ra Jesús‑ni, nianna tti ute dákinna deki labakana nuha rutanie nu reeha. ");
INSERT INTO zae_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nianna benkana deki udaxxukane, ttaka usibakinna ge ka benne, kumu iyába ka benne rakakanie deki Jesús‑ni anke ttu profeta ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús‑ni rodolise attu libe ka nu loni ge ka bixxudiha lhe ka fariseo‑ni lhe. Benie ki utte dákana bí diani nu raka lebie kixxi'anie kanaha, nianna tti ree: ");
INSERT INTO zae_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Tata Do Yebáha, tti rinnabie ka benne, elha rinnabia geeha raxxína na len nu ben ttu nu rinnabia ge ttu yiesi tti benna dha'a ge xi'in biyúniha. ");
INSERT INTO zae_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nianna tti udhelhana ka nu riben lo sina geniha ki tsia ka nuha salisakana ka nu chi biyaxi ki tse'ekana dha'aha, ttaka ka nuha nna labí uka lekani tsiakana. ");
INSERT INTO zae_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nianna tti bededhelhana adíru ka nu riben lo sina geniha attu libe nna rana ka nuha: “Aní gwaligasi ka nu biyaxikana tse'ekana dha'aha: chiba tee tse elho lhe chiba bettia ka ku'una kia ka nu rixen xxattaha. Iyába chi tee tse. Gwaltá kini tse'eri'i dha'a.” ");
INSERT INTO zae_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ttaka ka nuha labí betabikinna ge nu rinnabiaha. Birialakana diakana: ttúna birialana diana gwelanni ka yu geniha, attuna nna birialana diana ata rutto'onaha, ");
INSERT INTO zae_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","adí ka nuha nna bedaxxulakana ka nu riben lo sina ge nu rinnabiaha nna uyalakana ka nuha nna axtaba bettikana kana. ");
INSERT INTO zae_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nu rinnabiaha nna yalhá bisa'a xxattinna. Nianna udhelha ttebana ka soldadu geniha ki gwatse'e lookana ka nu ben elhuttiha lhe gwadokana gi yiesi gekaniha lhe. ");
INSERT INTO zae_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nianna rana adí ka nu riben lo sina geniha: “Chiba tee tse elho ge dha'a‑ni, ttaka ka nu biyaxi ki tse'ekana dha'a‑ni, delo ni'a ge nu benkanaha nna labí elha ralhakana tse'ekana nii. ");
INSERT INTO zae_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nnanna nna gwaltsia ata raka kurusi ka neda‑na nna gwaligaxi iyába ka benne eti'ale, gwaligasi ke itake ki goke.” ");
INSERT INTO zae_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ka nu riben lo sina geniha nna biria ttebakana lo ka nedaha nna gwattupabakana iyába ka benne gwaxxakabakana: sila ka benne ruin tse lhe sila ka benne ruin satsa lhe. Aníha uka nna bisá tíba benne lhe'e yo'o ata raka dha'aha. ");
INSERT INTO zae_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Tti uta'a nu rinnabiaha ki ilenna ka nu chi biyaxi dha'aha, niha bilenna do ttu nubiyú labí nukuna xo ge dha'a. ");
INSERT INTO zae_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nianna tti rana nuha: “Betsi to, ¿gasina uka uta'alu nii ki labí nukulu xo ge dha'a?” Ttaka nuha nna siiba ukana, labí bekabina. ");
INSERT INTO zae_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nianna rana ka nu riben sina geniha: “Gwaluxxiga ka ni'ani lhe gwaluxxiga ka náni lhe, nna gwaludelha na ro'o yo'o‑na ata anka chulha‑na. Naa kwesina lhe goniba lo layani lhe.” ");
INSERT INTO zae_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nianna tti ra Jesús‑ni: ―Kumu ixeba ka benne raxi Tata Do Yebáha, ttaka nna ttu chuparubake rukwebie ki akake gebie. ");
INSERT INTO zae_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nianna tti deyya ka fariseo‑ni nna unne len luesikani gasina uinkana ki ibixxini Jesús‑ni bixa innábie kini aníha nna dhaakana ukinnikane. ");
INSERT INTO zae_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nianna tti udhelhakana ka nu rudhetikinnaha, itupa len ka nuha ka nu tákana Herodes nu rinnabiaha. Udhelhakana ka nuha kini gákana Jesús‑ni: ―Maestru, ri'itu yutu deki lu ankalu ttu benne rinnelu nu ankaba gwalí lhe rule'ebinlu ka benne neda ge Tata Do Yebáha attiba ankaba geni. Labí retabinlu ge nu inná ka benne, kumu labí rulannilu ttixa ankake. ");
INSERT INTO zae_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nnanna nna unáchu, ¿si gwa ga'anaba kixari'i belhiu nu daa lori'i kixari'i len César nu rinnabia xeniha, o abittuba ak? ");
INSERT INTO zae_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ttaka Jesús‑ni nna ute dábanie nu rulha lekani uinkanaha, nianna tti ree kana: ―¡Aalexa ka nu delo tisaba rinnaba tisale! ¿Beaka ruinle kini ichekua nna ibixxiti bixa innía? ");
INSERT INTO zae_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gwalule'e sanga belhiu rigixari'i‑na. Nianna bele'ekinne ttu denario. ");
INSERT INTO zae_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nianna tti unnaba tise, ree kana: ―¿Nú lo nuní du lo belhiu‑ni lhe nú lá nuní dia xani'a nuní lhe? ");
INSERT INTO zae_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Lakana nna bekabikana, rákana: ―Lá César nu rinnabiaha‑ba nuní. Nianna ree kana: ―Ganna aníha nna gwalugweba César‑ni nu anka geni nna Tata Do Yebáha nna gwalugwegabe nu ankaba gebie. ");
INSERT INTO zae_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tti biyienkinna nu rabie kanaha nna bebanabakinna nna niha‑ba bedúkane nna deyyakana. ");
INSERT INTO zae_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","La sáha‑gaba bisin ka saduceo‑ni ata du Jesús‑ni. Ka nuha rákana deki labí reyaka ben ka benne chi uttiha. Nianna rákane: ");
INSERT INTO zae_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestru, Moisés‑ni bodha'ane, ree: “Ganna ttu nubiyú chi betsá náni, nianna gattina nna anúba xi'inni aka len nuila geniha, la'ania nna teeki edí betsiniha nuila bidabiha kini ka xi'inni aka len nuilaha nna eyakakana ttisidiba xi'in benne chi uttiha.” ");
INSERT INTO zae_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ganna aníha anka nna ttibanka ri'itu udo ttu benne getu use'e gasi ka betsie. Benne xxeniha betsába nee len nuila geeha, ttaka uttibe nna lanú xi'inie bodha'ane. Nuilaha nna beya'anbana kini edína attu betsieha. ");
INSERT INTO zae_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aníha‑gaba gwate betsie nu berupaha lhe nu beyonnaha lhe. Aníha‑ba gwateke nna ni beyába iyába gasi betsike utti. ");
INSERT INTO zae_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Iki de nuha nna uttigaba nuilaha. ");
INSERT INTO zae_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nianna, ganna chi bisia sá eyaka ben ka benne chi uttiha, ¿núla nuila geke aka nuilaha, ki iyába gasike udo lenke nuha? ");
INSERT INTO zae_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús‑ni nna bekabie gekani, ree: ―Lebi'i rinittibale nu gweala rale, kumu de labí yule nu ra lo ka yetsi ge Tata Do Yebáha lhe labí yule deki tsitsiba ra lebie lhe. ");
INSERT INTO zae_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kumu tti eyaka ben ka benne chi uttiha, nuila lhe nubiyú lhe labíru dina otsá ná ka benneha, nigaba uketike ka xi'inkeha lhe. Eyakabake attiba ka anjeli se'e yebáha ");
INSERT INTO zae_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","nna ge nu rale ganna gwalí reyaka ben ka benne chi uttiha, neti upeya le, ¿si lagwa chi belabale nu ra lo ka yetsi ge Tata Do Yebáha, tti ree: ");
INSERT INTO zae_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Neti ankaa Diosi ge Abraham‑ni lhe ge Isaac‑ni lhe ge Jacob‑ni lhe”? Laxkala Tata Do Yebáha labí anke Diosi ge ka benne chi uttiha, labie ankalee Diosi ge ka benne anka bani. ");
INSERT INTO zae_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tti biyienin ka benne se'e niha nu ra Jesús‑ni, yalhá bebanakanie ge nu rule'enie keha. ");
INSERT INTO zae_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ka fariseo‑ni, tti binakana deki bose'e siiba Jesús‑ni ka saduceo‑ni, nianna bottupa tteba luesikani. ");
INSERT INTO zae_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ttu ka fariseo nu rule'enna ka benne nu ra lo bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni, de ruinna ku'una Jesús‑ni prueba, nianna rane: ");
INSERT INTO zae_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestru, ¿nú ka tisa bodha'an Tata Do Yebáha lo bia bennabi‑na rakaru doelha udori'i tisa geni? ");
INSERT INTO zae_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús‑ni nna ree na: ―“Akinlu ge Tata Do Yebaa benne anka Xxanaluha itú iki itú lelu.” ");
INSERT INTO zae_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nuní nu lade'a tte rakaru doelha uinri'i. ");
INSERT INTO zae_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nu berupaha nna ankagabana attiba nuní, rana: “Akinlu ge attu benne atti tteba rakabin gelu.” ");
INSERT INTO zae_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ge ixpa ka tisa‑ni rudaxxu ni'a iyá nu ra lo bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni lhe rudaxxu ni'a nu ra lo ka yetsi bodha'an ka profetaha lhe. ");
INSERT INTO zae_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Laka tupa ka fariseo‑ni, nna unnaba tisa Jesús‑ni kana, ree kana: ");
INSERT INTO zae_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Bí rakinle ge benne anke Cristuha? ¿Nú uka xutto benneha? Lakana nna rákana: ―David‑niba xa. ");
INSERT INTO zae_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nianna ree kana: ―Ganna David‑ni ukana xutto Cristuha nna, ¿beakala tti yu'u Espíritu ge Tata Do Yebáha latini nna rálana deki Cristuha anke Xxanani? Kumu David‑ni rana: ");
INSERT INTO zae_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Aní ra Tata Do Yebáha tti rulise Cristu benne runie neti mandaduha: “Utá udo daka ná ben kia. Niiba dholu axtaliba ganna chi bese'a ka nu abittu raka uyúkana lu, kini ulealu ikikani.” ");
INSERT INTO zae_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ki ganna David‑ni daneruna Cristuha, ¿galasina nna rálana benneha: “Lu ankalu benne ruinlu neti mandadu”? ");
INSERT INTO zae_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Niba ttú ka fariseo‑ni a uka gekani ekabikana ge nu ra Jesús‑ni nna debá la sáha nna ni ttúkana labíru beyaxakinna innaba tisakane ge attu bixa. ");
INSERT INTO zae_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Iki de nuha nna tti ra Jesús‑ni ka benne se'e niha lhe ka benne rudhetinieha lhe: ");
INSERT INTO zae_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Ka nu rule'ekinna ka benne nu ra lo bia bennabi‑ni lhe ka fariseo‑ni lhe, lakana nuná daa lokani ula'akana nu bodha'an Moisés‑ni lo bia bennabi‑na. ");
INSERT INTO zae_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Laxkala lebi'i, gwaludo tisa gekani lhe gwaluin iyá nu innákana lhe. Deba nna bittu uinle tti ruinkana, kumu lakana nu subi rákana nna nu subila ruinkana. ");
INSERT INTO zae_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ttiba ttu yua idi'i nuná rudelhakana kwe'e ka benne tti rudo doelhakana ke ki udoke tisa ge iyá nu rákana, ttaka lakana niba ttu latti a raka lekani udokana tisa ge nu rule'ekana. ");
INSERT INTO zae_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yalhá ru'u lekani rodixenkana ka yetsi ka nu ruxxika lhe'e nákani lhe rutá lo xeakani. Lo ka yetsiha dia ttu chupa ka tisa ge Tata Do Yebáha. Lhe anágaba ru'ugaba lekani ukukana ka xalho daa xxatta xuda ro'okani. Ruinkana iyá nuní uka diba ki iláni ka benne deki yalhaba tse ruinkana. ");
INSERT INTO zae_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Anágaba ruinkana ata tee ttu elha go, yalhá ru'u lekani kwiakana lo ka xxila tseru. Nuha‑gaba ruinkana lhe'e ka yo'o ata rudhetiri'i ka tisa ge Tata Do Yebáha, yalhá ladeakakana kwiakana lo ka xxila tseru. ");
INSERT INTO zae_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Lhe ru'u lekani tti eti'a benne kana lo ka neda‑na, latsiru inneke gake kana padiuxi lhe anágaba lhe ru'ugaba lekani gake kana: “Maestru.” ");
INSERT INTO zae_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Ttaka lebi'i bittu dhielhale gákana le: “Maestru”, kumu sunruba ttu benne doe anke Maestru gele, delába benne anke Cristuha. Lebi'i turo'oba ankale, lanú benne ra xxeniru lebie do. Iyábale ttisidiba betsibale raka. ");
INSERT INTO zae_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Lhe anágaba anuttu nuxa gale: “Tata” yiesi lo yu‑ni, kumu sunruba ttu Tata geri'i do, nna yebáha‑ba do benneha. ");
INSERT INTO zae_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bittugaba dhielhale gákana le: “Lebi'i ankale nu loni”, kumu sunruba ttu benne do anke nu loni gele; delába benne anke Cristuha. ");
INSERT INTO zae_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Laxkala benne raka lebie inná xxeniru lebie arlo adíle, benneha‑la nuha daa loe ixúe ute nábie len lebi'i. ");
INSERT INTO zae_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kumu ganna ttixka ttu benne titúbe unie deki ra xxeni lebie, la'ania nna elhida gaala Tata Do Yebáha le benne ruin aníha, nna benne elhida gaa le titúbe, benneha‑la nuha uin Tata Do Yebáha kini inná xxeni lebie. ");
INSERT INTO zae_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Ttaka lebi'i ka nu rule'enle ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe lebi'i ka fariseo lhe, delo tisaba ruinle deki ankale benne tse. ¡Gwalíchiru lele, kumu lebi'i rudheale lo ka benne raka leke ga'ake udaxxuke neda ge Tata Do Yebáha ata rinnabieha! Ttaka nigaba lebi'i a ra'ale lo neda geeha, lhe nigaba a rugwelhale ga'a ka benne raka leke ga'ake lhe. ");
INSERT INTO zae_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Lebi'i, ka nu rule'enle ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe lebi'i ka fariseo lhe, delo tisaba ruinle deki ankale benne tse. ¡Gwalíchiru lele, kumu riguale ka yo'o ge ka nuila bidabi‑na, nianna delo tisaba rise'ele isá rilhapile tisa len Tata Do Yebáha! De nu ruinleha nna lebi'i ralhabale dhírule elha disa tsitsi. ");
INSERT INTO zae_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Lebi'i ka nu rule'enle ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe lebi'i ka fariseo lhe, delo tisaba ruinle deki ankale benne tse! ¡Gwalíchiru lele, kumu doelha tsitsiba ruinle kini riri'a lenle raxile kwadiba ttu benne ki tsia lebie tti ria lele! Nianna ganna chi biri'a lenle uxile benneha, la'ania nna lebi'i ruinle kini raka benneha nu ruin satsaru. De nuha nna adírula elha disa tsitsi ralha benneha dhie lo giha attichula lebi'i. ");
INSERT INTO zae_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Aalexa nu lo xua! Gwealaba rinerule lo adí ka benne. Gwalíchiru lele rale: “Tti innári'i uinri'i ttu bixa, meskiba udettiri'i yotu‑na, labí teeki daa lori'i uinri'i nu chi rari'iha, ttaka ganna chi bedettiri'i ka oru sia lhe'e yotu‑na, la'anialigaba nna teeki uinri'i nu chi rari'iha.” ");
INSERT INTO zae_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Aalexa nu lo xua lhe nu akaa elha rieni ikini lhe! ¿Si lagwa gwa yule deki yotu‑nala dakaru attichula ka oru sia lhe'en‑na? Kumu yotu‑nala nuná ruinna kini ka oru sia lhe'en‑na rakakana le'a. ");
INSERT INTO zae_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Anágaba lhe, rágabale: “Ganna udettiri'i bekú daa ro'o yotu‑na, la'ania nna labí teeki daa lori'i uinri'i nu chi rari'iha. Ttaka ganna udettiri'i úna sia lo bekú‑na, la'anialigaba nna teeki uinri'i nu chi rari'iha.” ");
INSERT INTO zae_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Aalexa nu lo xua! ¿Si lagwa gwa yule deki bekú‑nala nuná dakaru attichula úna sia loin‑na? Kumu bekú‑nala nuná ruinna kini úna sia loin‑na rakana le'a. ");
INSERT INTO zae_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Laxkala benne rudettie bekú‑na tti ree unie ttu bixa, alaa sunruga bekú‑na nuná rudettie, iyágaba úna sia loin‑na nuná rudettie. ");
INSERT INTO zae_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nna benne rudettie yotu‑na tti ree unie ttu bixa, laa sunruga yotu‑na nuná rudettie, iyágaba benne do lhe'e yotu‑na nuná rudettie, delába Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nna benne rudettie yebáha tti ree deki unie ttu bixa, iyágaba xxila ata rido Tata Do Yebáha nuha rudettie lhe rudettigabe Tata Do Yebáha lhe, kumu lee nuha ridoe lo xxilaha. ");
INSERT INTO zae_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Lebi'i ka nu rule'enle ka benne nu ra lo bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni lhe lebi'i ka fariseo lhe, delo tisaba ruinle deki ankale benne tse. ¡Gwalíchiru lele, kumu ruinle doelha rutele len Tata Do Yebáha ttu tsii (10) por ciento ge ka kuana rexú gele, ttibanka rutele ttu latti ge ka gwadhi bela lhe ge ka comino lhe ge ka anís lhe! Ttaka rixulhabinle ge nu ra lo bia bennabi bodha'an Moisés‑ni, nu rakarula doelha udole tisa geni, delába akale benne ratua lasi lhe uinle latsiru attiba ankaba geni, lhe anágaba udole tisa ge Tata Do Yebáha lhe. Nunonna nu rakaru doelha uinle nna bittugaba udhanle a utele nu rutele‑na. ");
INSERT INTO zae_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Aalexa nu lo xua! Gwealaba rinerule lo adí ka benne. Lebi'i doelhaba ruinle kini rudole tisa ge nu ra ka tisa dia lo bia bennabi‑na, meskiba ankana ttu tisa chika'a to, ttaka nna rixulhabinle udole tisa ge nu rakaru doelha. Ruinbale attiba runi ttu nu ruyú tsitsibana kini abittu gabina ttu be'eya to nna labí rite denna tti rabina ttu camellu. ");
INSERT INTO zae_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Lebi'i ka nu rule'enle ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe lebi'i ka fariseo lhe, delo tisaba ruinle deki ankale benne tse. ¡Gwalíchiru lele, kumu lebi'i ankabale attiba ka xiga lhe ka ye'ena rixuinle‑na! Ka nuná rigí xúbale latikani, ttaka lhi'u lhe'ekani nna tsiga ya'aba anka. Aníha‑ba nuná ankale. Lo liaruba nuná nari xúba rule'ele, ttaka lhi'u lhe'e lastole nna saa tíba nu satsa ruinle lhe nu rilanale ge ka benne lhe. ");
INSERT INTO zae_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseo lo xua! Gwalocharixa lhi'u lhe'e xiga‑na lhe lhe'e ye'ena‑na lhe, kini anáchu nna eyarigaba latikani. ");
INSERT INTO zae_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Lebi'i ka nu rule'enle ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe lebi'i ka fariseo lhe, delo tisaba ruinle deki ankale benne tse! ¡Gwalíchiru lele, kumu lebi'i ankale ttiba ttu baa, yalhá lhe'e rula'a lo lia! Ttaka lhi'u lhe'eni nna saa tíba sitta ge ka nu yattiha lhe iyába nu yusu lhe. ");
INSERT INTO zae_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Anágaba lebi'i, lo liaruba nuná rule'ele deki ankale benne ruin tse, ttaka lhi'u lhe'e lastole nna saa tíba nu satsa ruinle lhe delo tisaba ruinle deki ankale benne tse lhe. ");
INSERT INTO zae_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Lebi'i ka nu rule'enle ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe lebi'i ka fariseo lhe, delo tisaba ruinle deki ankale benne tse. ¡Gwalíchiru lele, kumu rusiale ka baa ge ka profeta betti ka benneola geleha lhe ruingabale latsiru ka yo'o to kini rusiale iki ka baa ge ka benne benke nu dika ixú! ");
INSERT INTO zae_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nianna tti rise'ele, rale: “Ganna ttixka ri'itu chi se'etu tti use'e ka benneola geri'iha, la'ania nna labí tulapa ugíatu ka benneha bettitu ka profetaha ganna ttixka.” ");
INSERT INTO zae_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ukare'aba nu chi rale‑na chi runna liina deki gwalíba datiale ka benneola bettikana ka profetaha. ");
INSERT INTO zae_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡De nuha nna tsa ttela gwalulhuxa loo nu udulo ka benneola geleha benke! ");
INSERT INTO zae_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Aalexa nu ruin satsa! Lebi'i ankale ttiba ka belha‑na. ¿Gasina uinle ki lhaale kini abittu tsiale lo giha? ");
INSERT INTO zae_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Laxkala gwaludo nagale, neti idhelhaa ka profetaha ata se'ele‑na lhe idhelhaa ka benne yuu lhe ka benne ula'akanie le lhe. Ttaka lebi'i nna utálale ttu chupa ka benneha lo ya kurusi kini gattike, adíke nna gayalale ke lhe'e ka yo'o ata rudhetiri'i ka tisa ge Tata Do Yebáha, lhe anágaba kua suba lhe'e iyába ka yiesi‑na sanalhale ke nna urio lále ke. ");
INSERT INTO zae_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Laxkala kwe'ebale tsia reni ge iyába ka benne abittu bixa benke nna kwentaba bettikana ke yiesi lo yu‑ni. Dhulo tsia kwe'ele reni ge Abel benne benie nu dika ixú arlo Tata Do Yebáha nna axtaba reni ge Zacarías xi'in Berequías, delába Zacarías benne bettile ata daa bekú lali'a ro'o yotuha. ");
INSERT INTO zae_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Netiru ria, iyá nuní tsiana kwe'e ka benne se'e nnanna. ");
INSERT INTO zae_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Eru geni xa benne ge Jerusalén! Lebi'i ruttile ka profeta lhe rusiale íyya ka benne ridhelha Tata Do Yebáha lhe'esi gele‑ni kini rigixxi'ake ka tisa geeha. Ixe lidú benia ottupaa le ttiba runi beraha rottupana ka xi'inniha regu'u lhe'e xxilani kana, ttaka lebi'i nna labí uka lele. ");
INSERT INTO zae_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Gwaluyúruga, lhe'esi gele‑ni a suna ttúbana eya'anna, lanúru benne tse'e lhe'eni. ");
INSERT INTO zae_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Neti xpeya le, debá nnanna labíru ilenle neti axtaliba ganna chi isia sá tti innále: “¡Karubárulu dedálu kwenta ge Tata Xisiha!” La'anialiba tti elenle neti attu libe. ");
INSERT INTO zae_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús‑ni chiba berie ro'o yotuha deyye. Nianna tti ubiga ka benne rudhetinieha bele'ekanie bie adíru ka yo'o sia ata do yotuha. ");
INSERT INTO zae_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Lee nna ree ka benneha: ―¿Si gwa rilenle iyá nuní? Netiru ria: isia sá tse'e looba ka nuní. Ganna chi bise'e lookanaha, la'ania niruba ttú ka íyya kua nii a eya'anna iki luesikani. ");
INSERT INTO zae_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tti chi bisin Jesús‑ni iki i'iya ata daa ka ya olivuha, niha‑ba udoe, nianna tti ubiga ka benne rudhetinieha nna suna labe, ráke: ―Utixxi'en ri'itu, ¿nuka aka nu ralu‑na? Lhe, ¿bí aka ki unna liina deki chi dabiga esialu lhe deki chi dabigana lhuxa yiesi lo yu‑ni lhe? ");
INSERT INTO zae_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús‑ni nna bekabie ge ka benneha, ree: ―Gwaluyú gele, bittu tsia lele ge ka nu ruin lekani, ");
INSERT INTO zae_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","kumu ixe ka nu isia uinkana attisidiba netiba nuha ankakana, nianna tti innákana: “Neti ankaa Cristu.” La'ania nna ixeba ka benne dhi yiekana. ");
INSERT INTO zae_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Lebi'i unagabale deki chi yu'u ka yiesi ritilha len luesikani lhe daa tisa deki ruin ka yiesi itilha len luesikani lhe, ttaka lebi'i bittu gasinle, kumu teeki aka aníha. Ttaka labí chi bisia ura lhuxa yiesi lo yu‑ni la'ania. ");
INSERT INTO zae_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kumu ka yiesi elha‑na dhulokana ebi'i noo luesikani itilhakana, lhe anágaba ka nu rinnabia‑na ebi'i noogaba luesi ka nuná. Ga'agaba isagwe ge ka benne lhe ga'agaba ubina, lhe anágaba yiesi lo yu‑ni gattigabinna ixú. ");
INSERT INTO zae_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tti chi aka iyá nuha, la'aniaruba nuha si dhulo uyú ka benne elha disa. ");
INSERT INTO zae_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’La'ania nuha utekana le lasi ná ka nu gayakana le lhe uttikana le lhe, nna iyá xeaba ka benne labí aka uyúkana le de ria lele neti. ");
INSERT INTO zae_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","La'aniagaba nuha ixeba ka nu chi ria lekani neti udhankana abitturu tsia lekani neti lhe la labakana ukinni luesikani lhe abitturu aka uyú luesikani lhe. ");
INSERT INTO zae_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ixegaba ka nu labí gwalí ankakana profeta ge Tata Do Yebáha tsekikana la'ania, nna ixeba ka benne dhi yiekana kini tsia leke ge gwen lasi innekanaha. ");
INSERT INTO zae_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kumu de tsani xxatta nu satsa raka yiesi lo yu‑ni la'ania, de nuha nna ixeba ka benne udhanke labíru akin ge luesike. ");
INSERT INTO zae_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ttaka benne dhaabie dhu tsitsie lo neda ge Tata Do Yebáha, benneha nna godilába Tata Do Yebáha bie ganna chi ute iyá nu akaha ");
INSERT INTO zae_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","nna ka tisa tseha, delába ka tisa rigixxi'a gasina innabia Tata Do Yebáha ka benne, teeki chadhi ka nuha itúba yiesi lo yu‑ni kini una iyá xea ka benne. Iki de nuha‑liba nna tti lhuxa yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Nu ulabana nu dia lo yetsi‑ni, teeki utte dana bixa diani nu ra Jesús‑ni, tti ree: ―Tti ilenle lhe'e yotuha aka ttu nu tuttíruga anka satsa, delába ge nu satsa utixxi'a profeta Daniel‑ni, ");
INSERT INTO zae_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","la'ania nna ka benne se'e daka Judea‑ni teeki uxunnike tsapike iki ka i'iya sia niha. ");
INSERT INTO zae_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Benne doe iki yo'o geeha nna abittu eyadie saleabie nu se'e lhe'e yo'oha kini ichebie na. ");
INSERT INTO zae_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Benne dia lhe'exxiha nna bittu eyye lhe'e yo'o geeha saxíe jabana geeha. ");
INSERT INTO zae_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Gwalíchiru le ka benne nuila ata nuja xi'inke la'ania lhe denke ka nuto rasi lhe! ");
INSERT INTO zae_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","De nuha nna gwalinnaba len Tata Do Yebáha, kini tti uxunnile lo elha disa sateleha, abittu satele nuha tti raka idilhaha lhe tti anka sá reyaka leri'iha lhe, ");
INSERT INTO zae_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","kumu ttu elha disa tsitsi nuha uyú ka benne la'ania, ttu elha disa nu labí chi uka itú ure yiesi lo yu‑ni axtaliba la'ania aka nuha. Anágaba lhe labíru aka nuha nu si daa. ");
INSERT INTO zae_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ganna ttixka abíba odatsi Tata Do Yebáha ka sáha, la'ania nna ni ttu benne labí lhaabie, iyábake gattike. Ttaka de ka benne chi bekwebie kini akake geeha, de ka benneha‑ruba nna godatsie ka sáha. ");
INSERT INTO zae_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ganna nuxa gana le la'ania: “Gwalulanniruga, ne benne anka Cristuha du nii”, o si innána: “Gwalugíaruga, ne bie du naa”, abittu tsia lele ge nu inná aníha. ");
INSERT INTO zae_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kumu la'ania isia ka nu labí gwalí ankakana Cristu lhe isia ka nu labí gwalí ankakana profeta ge Tata Do Yebáha nna uinkana ka milagru lhe uinkana ttu bixa nu dika ebanani ka benne ge nu uinkanaha. Uinkana nuha ki dhi yiekana ka benne. Gaxa axtala ka benne chi bekwe Tata Do Yebáha ki akake gebie, axtala ka benneha uinkana dhi yiekana ke ki tsia leke gekani. ");
INSERT INTO zae_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nnannali chi rigixxi'ania le ge nu aka la'ania. ");
INSERT INTO zae_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Laxkala ganna gákana le: “Gwaltsáruga gwalulanni, ne Cristuha du lo yu bisiha”, lebi'i nna bittu iriale tsiale. O, si ganna innákana: “Gwaltáruga gwalulanni, ne bie do lhe'e yo'oha”, bittu tsia lele gekani. ");
INSERT INTO zae_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kumu attiba edha‑na tti ridú liina daka ata riria ubisa‑na, rilá saaba xiani geni axtaba ata radi ubisa‑na, aníha‑ba ilá saaba ganna chi esiaya, neti benne daya yebáha. ");
INSERT INTO zae_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Attiba ruin ka chettu‑na tti rilákinna ata tee nu nimala yatti, niha ritupakana. Aníha‑gaba ilenle ganna chi esiaya. ");
INSERT INTO zae_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Iki de chi ute ka sá tti uyú ka benne elha disaha, la'ania nna echulha tteba lo tatubisa‑na. Nanto beo‑na nna labíru xiani ku'u benne‑na. Ka beli sia gwetsáha nna iginnibakana lo yu lhe adíru ka nu ra xxeni lekani sia gwetsáha igubigabakana. ");
INSERT INTO zae_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yebáha aka ttu bixa nu unna liina deki neti benne daya yebáha, neti nuha chi dedáya. La'ania nna iyá xeaba ka benne se'e yiesi lo yu‑ni elenkanie tti ilákanie dedáya yebáha lhe'e bea, ra tsitsi lasia lhe raka lhalhaba xiani kia lhe. ");
INSERT INTO zae_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nianna tti kwesi trompetaha idisa, neti nna idhelha ttebaa ka anjeli kiaha itú tte yiesi lo yu‑ni, desdeba ata ridulo yebáha nna axtaliba ata riluxunaha. Idhelhaa ke kini tsiake ottupake ka benne chi bekwe Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Gwalutte dáruga ge ya higuha. Nuha ganna chi renettu ka lo náni lhe reria ka lhaga geni lhe, la'ania nna chiba yule deki chiba dabiga eta'a iyya. ");
INSERT INTO zae_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Anágaba lebi'i, ganna chi ilenle aka iyá nu chi ria‑ni, la'ania nna chiba yule deki chi tteba dabiga esiaya. ");
INSERT INTO zae_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Netiru ria, labí chi utti ka benne se'e nnanna tti aka iyá nuní. ");
INSERT INTO zae_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yebáha lhe yiesi lo yu‑ni tse'e loobakana, ttaka ka tisa chi ria‑ni tee kiba aka nu ra ka benne‑ni. ");
INSERT INTO zae_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Ttaka la sá lhe la ura aka nuha, lanú nu yuna, ni ka anjeli ge Tata Do Yebáha yuke lhe nigaba neti benne ankaa Xi'inieha abittu yua, sunruba Tataha yue. ");
INSERT INTO zae_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Akaba attiba uka tti udo Noé‑ni, aníha‑gaba aka ganna chi esiaya, neti benne daya yebáha. ");
INSERT INTO zae_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kumu atti lanila isá yiesi lo yu‑ni inda, ka benne use'e la'ania, utobake lhe u'uyabake, lhe anágaba nna betságaba náke lhe beketigabake ka xi'inkeha lhe. Aníha‑ba benke axtaliba tti bisia sá tti uta'a Noé‑ni lhe'e barcuha. ");
INSERT INTO zae_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Labí ute dákanie bixa nuha aka axtaliba tti chi rilákanie risá indaha, nianna iyábake uchena. Aníha‑gaba nuha aka ganna chi besiaya, neti benne daya yebáha. ");
INSERT INTO zae_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","La'ania ata se'e chupa ka nubiyú lhe'exxiha, ttúna echea na nna, attuna nna odha'anbaa na. ");
INSERT INTO zae_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ata yu'u chupa ka nuila gwettu, ttúna echea na nna, attuna nna odha'anbaa na. ");
INSERT INTO zae_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’De nuha nna lebi'i gwaltse'e ubeda, kumu labí yule bixa sá esiaya, neti benne ankaa Xxanaleha. ");
INSERT INTO zae_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ttaka lebi'i gwalúnaruga, ganna ttixka xxana ttu yo'o yuna bí ura lo rela isin ubanaha tachadina yo'o geniha, la'ania nna dho tennálana ki uyúna yo'o geniha kini abittu ugwelhana ubanaha ga'ana lhanana. ");
INSERT INTO zae_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Laxkala, anágaba lebi'i, gwaltse'e ubeda, kumu neti benne daya yebáha esiaya attila abí ribedale neti. ");
INSERT INTO zae_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Laaba ganna nu rudo tsitsina tisa ge xxananiha lhe ruinna attiba ankaba geni lhe, laaba ganna lana nuha rodha'an xxananiha na kini uyúna adí ka nu riben sina lisiniha ki ugona ka nuha ura geni? ");
INSERT INTO zae_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","¡Karubáru nu ren sinaha, ganna chi besia xxananiha nna etexxakana na gwa ruinbana sina nu daa loni uinnaha! ");
INSERT INTO zae_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Netiru ria: xxananiha odha'anbana lasi náni kini uyúna iyá nu se'e geniha. ");
INSERT INTO zae_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ttaka ganna nu ren sinaha satsaba re leni, nianna tti ulaba lhi'u leni, akinna: “Risába xxana sina‑ni; nu nuha resia”, ");
INSERT INTO zae_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nianna dhulo ttebana gayana adí ka nu riben sinaha nna tti dhona gona lhe i'iyana len ka nu dusi. ");
INSERT INTO zae_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ttaka la sá attila abittu ribedana lhe la ura attila abí rakinna deki esia xxananiha, la'aniala nna iyyaba leni esia nuha. ");
INSERT INTO zae_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nianna tti ugwena na ttu elha disa tsitsi nna tti kweana na udelhana na ata se'e ka nu labí liikinna delo tisaba ruinkana ttu bixa. Niha kwesina lhe goniba lo layani lhe. ");
INSERT INTO zae_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Tata Do Yebáha tti rinnabie ka benne, elha rinnabia geeha raxxína na len nu gwate tsii ka nuila ribani biriakana denkana ka kinke ge seti nna gwaledakana nubiyú utsá nániha. ");
INSERT INTO zae_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gayu ka nuilaha ankakana ka nu se'e xulha nna a gayukana nna ankakana ka nu gwa se'e dhina. ");
INSERT INTO zae_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ka nu se'e xulhaha nna gwa denbakana ka kinke gekaniha, ttaka labí seti denkana kini ega'akana ge ka nuha. ");
INSERT INTO zae_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ka nu se'e dhinaha nna gwa nujaba ka nuha bega ta'a seti lhe chegabakana ka kinke gekaniha lhe. ");
INSERT INTO zae_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ttaka kumu risába nubiyú utsá nániha anúna risina, aníoka nna bedaxxuba bisielaha iyába ka nuilaha nna bixuinba lekani. ");
INSERT INTO zae_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tti chi ugwena riluelaha nna biyien tsi'i ttu benne uresi'e, ree: “¡Ne nubiyú utsá nániha chi daha! ¡Gwaliria nna gwatatsá na!” ");
INSERT INTO zae_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nianna iyába ka nuila ribaniha bebenkana nna bose'e tse ttebakana ka kinke gekaniha. ");
INSERT INTO zae_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ka nu se'e xulhaha nna rákana ka nu se'e dhinaha: “Gwalute latti seti gele‑na ki ega'atu lhe'e ka kinke getu‑ni kini reyolaba ka nuní.” ");
INSERT INTO zae_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ka nu se'e dhinaha nna rákana: “Labí ute ri'itu, gasi ni kina ebisi seti getu‑ni, la'ania nna iyasagaba getu lhe iyasagaba gele lhe. Tserula gwaltsia ata rito'o seti gwatayo'o gele.” ");
INSERT INTO zae_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ttaka laka dia ka nuha ugo'o setiha nna bisin nubiyú utsá nániha. Ka nuila se'e dhinaha nna uta'aba lenkana nubiyú utsá nániha lo dha'aha, nianna beto tteba yo'oha. ");
INSERT INTO zae_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Deloliba nna tti besin adí ka nuila ribaniha nna rinnekana ro'o yo'oha, rákana: “¡Tata xisi to, udhalichi kini ga'atu!” ");
INSERT INTO zae_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ttaka nubiyúha nna bekabina, rana kana: “Labí idhalia gele kumu labí ankabiati le.” ");
INSERT INTO zae_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nianna tti ra Jesús‑ni: ―Laxkala lebi'i gwaltse'e ubeda, kumu labí yule bittiga ura lhe bittiga sá esiaya, neti benne daya yebáha. ");
INSERT INTO zae_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Tata Do Yebáha tti rinnabie, elha rinnabia geeha raxxína na len nu ben ttu nubiyú biriana diana idittu. Nianna tti uxina ka nu ren sina geniha nna bodha'anna len ka nuha belhiu nu tee geniha. ");
INSERT INTO zae_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ttu ka nuha begwena na gayu mili, attuna nna chupa mili, nu beyonnaha nna begwena na ttu mili. Kua ttu ttubakana begwena kana attiba bedhaka leni dhaakana udhákana belhiu geniha. Nianna tti biriana diana. ");
INSERT INTO zae_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nu uxí gayu miliha nna ugweki ttebana gwerixxi len belhuha nna gwa bedienbana iki nuha a gayu mili. ");
INSERT INTO zae_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aníha‑gaba ben nu uxí chupa miliha, gwa bediengabana a chupa mili iki nuha. ");
INSERT INTO zae_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ttaka nu uxí ttu miliha nna ugíalana gwache'enna lhi'u yu nna bekatsilana belhiu ge xxananiha. ");
INSERT INTO zae_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Isáliba uka nna tti beyeki xxanakaniha besinna. Nianna uxina kana kini kixxi'akana ttixa dia rani belhuha. ");
INSERT INTO zae_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nu uxí gayu miliha nna besia lenna a gayu mili, nianna rana: “Tata xisi to, gayu mili nuha bete kwinalu len neti. Biyúruga, ne a gayu mili tee nii chi bedienia iki nuní.” ");
INSERT INTO zae_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Xxananiha nna bekabina, rana na: “Tseba anka nu benlu. Lu ankalu ttu benne ruin tse sina lhe ttu benne rudo tsitsiba tisa lhe. Kumu ttu latti belhiu betea len luha, gwa biyú tsitsibalu na, nnanna nna uxxenrula lasia lu kini udhálu ixeniru belhiu. De nuha nna utá len neti kini tse'e ittari'i.” ");
INSERT INTO zae_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Bisingaba nu uxína chupa miliha nna rana: “Tata xisi to, kwinalu betelu chupa mili len neti. Nnanna nna, ne a chupa mili tee nii chi bedienia iki nuní.” ");
INSERT INTO zae_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Xxananiha nna bekabina, rana na: “Tseba anka nu benlu. Lu ankalu ttu benne ruin tse sina lhe ttu benne rudo tsitsiba tisa lhe. Kumu ttu latti belhiu betea len luha, gwa biyú tsitsibalu na, nnanna nna uxxenrula lasia lu udhálu ixeniru belhiu. De nuha nna utá len neti kini tse'e ittari'i.” ");
INSERT INTO zae_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ttaka tti bisin nu uxí ttu miliha, nianna rana xxananiha: “Tata xisi to, neti yubaa deki lu ankalu ttu benne labí ratua lelu, kumu lu relapalu ata labí ulu'ulu lhe redílu ata labí bedelhalu lhe. ");
INSERT INTO zae_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","De nuha nna usibati lu nna ugíalaa gwakatsia belhiu gelu‑ni lhi'u yu. Nnanna nna ne belhiu geluha tee nii.” ");
INSERT INTO zae_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Xxananiha nna bekabina geni, rana na: “¡Aaluxa nu ren sina re satsa leni lhe nu lea lhe! Ki ganna gwa yúbalu deki neti relapaa ata labí ulu'a lhe redía ata labí bedelhaa lhe, ");
INSERT INTO zae_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿beakala nna a gwattixxabalu belhiu kia‑ni lhe'e banku kini nnanna besiaya nna edía belhiu‑na itupa len xi'inni?” ");
INSERT INTO zae_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nianna tti rana ka nu se'e niha: “Gwalegua belhiu‑na lo ná nuní nna gwalute belhiu‑na len nu chi den tsii mili‑na. ");
INSERT INTO zae_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kumu benne gwa ruyú tsitsie nu ridíeha, dhi chiettirula benneha nna exxa tamarula gebie nna nu abittu ruyú tsitsina nu ridínaha, nuha axtala nu ttu latti chi tee geniha etua. ");
INSERT INTO zae_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nubiyú du nii nu abittu gwakana uinna sina‑ni, gwalikwea na nna gwaludelha na ata anka chulhaha. Niha kwesina lhe goniba lo layani lhe.” ");
INSERT INTO zae_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Atti esiaya neti benne daya yebáha, dedáya lhe'e xiani kiaha lenia ka anjeli ge Tata Do Yebáha, nianna tti dhoa lo xxila nu raka lhalha ata innabiayaha. ");
INSERT INTO zae_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","La'ania nna iyá xeaba ka benne se'e yiesi lo yu‑ni etupake arloa. Neti nna ebesia lhe'e luesike attiba runi nu reki lo ka neruha rebesina ka chivaha lhe'e ka neruha. ");
INSERT INTO zae_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Use'a ka benne ruin tseha daka ná bania nna ka nu ruin satsaha nna use'a kana daka ná yattia. ");
INSERT INTO zae_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","La'ania nna neti benne ankaa nu rinnabiaha, upeya ka benne se'e daka ná baniha: “Lebi'i chiba uka len Tata kiaha le. Gwaltáxxi kini dhile nu tse chi ga'ananie dhi ka benne rinnabie; delába nu chi ga'ananie dhile attili lani kwe yiesi lo yu‑niha. ");
INSERT INTO zae_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kumu neti tti bituniaha, lebi'i nna gwa betebale nu utoa nna tti bebisia indaha, lebi'i nna gwa betebale inda u'uyaa nna tti rekia ankaa attiba ttu benne dittu, lebi'i nna gwa beyaxibale neti lisile. ");
INSERT INTO zae_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Anágaba tti biyasati xoa, lebi'i nna gwa betebale nu bikua nna tti úniaha, lebi'i nna gwa biyúbale neti. Anágaba tti uttaa lisiyyaha, lebi'i nna gwa bitabale betegíale neti.” ");
INSERT INTO zae_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ka benne ruin tseha nna ekabike kia, innáke: “Tata Xisi to, ¿nuka bilentu lu rituinlu nna gwa bennabatu nu utolu lhe nuka bilentu lu rebisilu inda nna gwa betebatu inda u'uyalu? ");
INSERT INTO zae_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lhe anágaba, ¿nuka bilentu lu rekilu attiba ttu benne dittu nna gwa beyaxibatu lu lisitu? Lhe ¿nuka biyasinlu xolu nna gwa betebatu nu bikulu? ");
INSERT INTO zae_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Anágaba lhe ¿nuka bilentu lu ranilu o telu lisiyya nna gwa bitabatu betegíatu lu?” ");
INSERT INTO zae_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Neti benne ankaa nu rinnabiaha nna ekabia geke, upeya ke: “Netiru ria, atti bete nále len ttu ka betsi to geri'i, ka benne labí ra xxeni leke, attisidiba len netiba nuha bete nále.” ");
INSERT INTO zae_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Nianna tti upeya ka nu se'e daka ná yattiha: “¡Lebi'i ka nu ralhale urixxi ukinni Tata Do Yebáha, gwalibietta kwe'a nna gwaltsia lo gi nu satíaba rite loniha, delába gi nu chi re tse kini tsia nu xxegwiha loni itupa lenna ka anjeli geniha! ");
INSERT INTO zae_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kumu neti tti bituniaha, lebi'i nna labí betele nu goa nna tti bebisia indaha, lebi'i nna labí betele inda i'iyaa. ");
INSERT INTO zae_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Anágaba tti rekia ankaa attiba ttu benne dittu, lebi'i nna labí betele ata eya'anaa nna tti biyasati xoa, lebi'i nna labí betele nu ukua. Anágaba tti úniaha lhe tti uttaa lisiyyaha lhe, lebi'i nna labí betegíale neti.” ");
INSERT INTO zae_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","La'ania nna ekabikana kia, innákana: “Tata Xisi to, ¿nuka bilentu lu rituinlu lhe rebisilu inda lhe? ¿Nuka bilentu lu rekilu attiba ttu benne dittu o si rekilu riyasinlu xolu? Lhe anágaba, ¿nuka bilentu lu ranilu o telu lisiyya, ri'itu nna a bete nátu len kwinalu?” ");
INSERT INTO zae_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","La'ania nna ekabia gekani, upeya kana: “Netiru ria: tti abittu bete nále len ttu ka betsi to geri'i‑ni, ka benne abittu ra xxeni leke, len neti nuha abittu bete nále.” ");
INSERT INTO zae_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nianna tti ra Jesús‑ni: ―Luesi ka nu ruin satsa‑ni, tsiaba ka nuní ata uyúkana elha disa ttu dia liiha; ka nu ruin tseha nna eyyabakana ata aka benkana ttu dia liiha. ");
INSERT INTO zae_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Atti chi uluxani Jesús‑ni unnebie iyá nu reeha, nianna tti ree ka benne rudhetinieha: ");
INSERT INTO zae_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Lebi'i gwa yúbale, a chupa ubisaba nuní riyasa kini isia laní Pascua. La'ania neti benne daya yebáha, utekana neti lasi ná ka nu utákana neti lo ya kurusiha. ");
INSERT INTO zae_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ka nu loni ge ka bixxudiha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe anágaba ka benneola ge ka nu Israel‑ni bitupakana lali'a ge yo'o ata do Caifás nu anka bixxudi xeniha, ");
INSERT INTO zae_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","bitupakana nna botsi'inu lekani gasina udaxxukana Jesús‑ni nna uttikane. ");
INSERT INTO zae_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ttaka ra luesikani: ―Bittu uinri'i nuha tti raka laníha kini ka utsatsari'i ka benne. ");
INSERT INTO zae_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús‑ni doe lhe'esi Betania lhe'e lisi Simón nu uka latini yiesu nu tee láni lepra. ");
INSERT INTO zae_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nianna tti bisin ttu nuila denna ttu re'e to ankana ge íyya ragalha. Íyya ragalhaha tee láni alabastro. Lhe'e re'e toha ta'a seti nu rure ixixxi. Setiha daka xxattana. Nianna bedo ttatta nuilaha setiha iki Jesús‑ni tti doe go yettaha. ");
INSERT INTO zae_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tti bilani ka benne rudhetini Jesús‑ni nu ben nuilaha, nianna bisa'akanie nna ráke: ―¿Beaka kwentaba bedelha lattina seti‑na? ");
INSERT INTO zae_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","A betto'ochilana nuná yaxi; belhuha nna betena nuha len ka benne dii abittu geke tee. ");
INSERT INTO zae_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ttaka Jesús‑ni yube nu ra ka benneha, nianna tti ree ke: ―¿Beaka rinnele ge nuila‑ni? Nuní chi benna ttu nu tse len neti. ");
INSERT INTO zae_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kumu ka benne dii abittu geke tee satíaba tse'e ka benne‑na len lebi'i, neti nna labí satía dhoa len lebi'i. ");
INSERT INTO zae_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nuila‑ni begadina seti‑ni ikia. Benna kini odú tsena neti ki igatsia ganna chi uttiaha. ");
INSERT INTO zae_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Netiru ria: Itúba yiesi lo yu‑ni gaxaba lhe'e ka yiesi ata kixxi'a ka benne ka tisa kia‑ni, kixxi'agabake ge nuila‑ni. Aníha ki sadú le ka benne ge nu benna‑ni. ");
INSERT INTO zae_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ttu ka benne tsi'inu (12) rudhetini Jesús‑ni nu tee láni Judas Iscariote, ugíana ata se'e ka nu loni ge ka bixxudiha ");
INSERT INTO zae_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","nna rana ka nuha: ―¿Tti kixale neti ki utea Jesús‑ni lasi nále? Ka nuha nna rákana na: ―Utetu rerua (30) belhiu plata lenlu. ");
INSERT INTO zae_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Debá la'ania nna udulo Judas‑ni regila leni gasina utene lasi ná ka nu uttikaneha. ");
INSERT INTO zae_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sá neru ge laní Pascua tti ro ka benne Israel‑ni yettaxtila nu abittu kua dii dia ikiniha, la'ania ubiga ka benne rudhetini Jesús‑ni ata dueha nna ráke bie: ―¿Gá raka lelu sentu irse kini gori'i laní Pascua‑ni? ");
INSERT INTO zae_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Lee nna ree ka benneha: ―Gwaltsia lhe'e yiesi‑na nna gwaligá ttu benne biyú do naa: “Aní ra maestruha: Chiba dabiga isia ura kia. Lhe'e lisilu‑ni raka lasia goa irse ge laní Pascua len ka benne rudhetinia‑ni.” ");
INSERT INTO zae_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Aníha uka nna ka benne rudhetinieha benbake atti tteba raba Jesús‑ni, ugíabake gwenke irse ge laní Pascuaha. ");
INSERT INTO zae_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tti chi ulha sáha nna bebiga Jesús‑ni ro'o mexaha len ka benne tsi'inu (12) rudhetinieha. ");
INSERT INTO zae_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Laka yu'uke go irseha nna ree ka benneha: ―Netiru ria, nuxa ttúle nuní utele neti lasi ná ka nu uttikana neti. ");
INSERT INTO zae_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ka benneha nna yalhá bedú si'i xxattana leke tti biyienkanie nu reeha, nianna tti uduloke ttu ttubake unnaba tisake bie, ráke: ―¿Si bittuba neti nuná xa tata? ");
INSERT INTO zae_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Lee nna bekabie, ree ke: ―Nu ugutuna len neti lhe'e ttúba ye'ena‑ni, lana nuha utena neti lasi ná ka nuha. ");
INSERT INTO zae_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Neti benne daya yebáha eya'abaa attiba chi ga'anna lo ka yetsi ge Tata Do Yebáha. Ttaka nna, ¡gwalíchiru le nu utena neti lasi ná ka nu uttikana neti! Tserula saríana na ganna abittu ulina, a laa kila ulina. ");
INSERT INTO zae_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nianna ra Judas nu utene lasi ná ka nuha: ―¿Si bittuba netiba nuná xa maestru? Lee nna bekabie ree na: ―Luba chi raxa. ");
INSERT INTO zae_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Laka yu'uke goha nna tti bedaxxu Jesús‑ni yettaxtilaha nna begwebie Tata Do Yebáha ixkixaru. Nianna tti ulha'abie lhe'e benneha nna begwebie ka benne rudhetinieha nna ree ke: ―Gwaludaxxu nna gwaligo. Benne‑ni anke bela latia. ");
INSERT INTO zae_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Iki de nuha nna tti bedaxxue xiga ta'a vinuha nna begwebie ixkixaru Tata Do Yebáha, nianna tti begwebie ka benneha nna ree ke: ―Gwali'iya iyále nuní, ");
INSERT INTO zae_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kumu nuní ankana reni kia. Reni kia‑ni rugwena lidhaka tisa chi bodha'an Tata Do Yebáha len ka benne. Reni‑ni ilalina kini ixe ka benne ixú elha xen lasi ge ka tulha ruinke. ");
INSERT INTO zae_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Neti ria le: debá nnanna labíru i'iyaa vinu‑ni, gannaliba chi bisia sá i'iyaa vinu kubi len lebi'i ata rinnabia Tata kiaha. ");
INSERT INTO zae_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Iki de chi bilhake ttu le'a to, nianna tti biriake diake iki i'iya ata daa ka ya olivuha. ");
INSERT INTO zae_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tti chi se'eke iki i'iyaha, nianna ra Jesús‑ni ka benne rudhetinieha: ―Nnolha iyábale isatsale udhá ikile neti. Akaba attiba chi unne Tata Do Yebáha lo ka yetsi geeha, tti ree: “Neti uttibaa nu reki lo ka neruha nna ka neruha nna isatsa ttebakana.” ");
INSERT INTO zae_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Rágaba Jesús‑ni: ―Ttaka iki de chi beyaka bania lo elhuttiha, la'ania nna eya'a gaaya enerua lole esinaa daka Galilea‑ni, delola nna esiale. ");
INSERT INTO zae_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro‑ni nna rane: ―Meskiba adí ka nuní udhá ikikani lu, neti labí udhá ikia lu. ");
INSERT INTO zae_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Lee nna ree Pedro‑ni: ―Netiru ria: nnolha atti lanila kwesi chinkaha, lu tsunna libela chi bedhea lelu a ridí ro'olu deki ankabienlu neti. ");
INSERT INTO zae_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro‑ni nna rana Jesús‑ni: ―Neti meskila gattia lenlu, labí innía deki labí ankabiati lu. Aníha‑gaba ra adí ka benne rudhetinieha. ");
INSERT INTO zae_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nianna tti dia Jesús‑ni len ka benne rudhetinieha ttu latti ata tee láni Getsemaní, nianna ree ke: ―Nii gwaltse'e, laka neti tsiaya innea len Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nianna chebie Pedro‑ni lhe a chupa ka xi'in biyú Zebedeo‑ni nna tti uduloe bedú si'ina lebie lhe bedú xxattane lhe. ");
INSERT INTO zae_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nianna tti ree kana: ―Neti yalhá si'i du lasia. Gwanalu chiba gattia rakati. Nii gwaltse'e nna gwaltse'e tenná len neti, bittu ga'adhile. ");
INSERT INTO zae_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nianna tti biru'une a latti daka aná nna tti bettudhi loe lo yu nna unnebie len Tata Do Yebáha, ree: ―Tata to kia, nu diru innálu benchi kini abittu uyúa elha disa satea‑ni. Ttaka labí nu innía aka, sinuki nu innába kwinalu aka. ");
INSERT INTO zae_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nianna tti beyekie ata se'e ka benne tsunna rudhetinieha nna gwaxxake ka benneha te'adhilake. Nianna tti ree Pedro‑ni: ―¿Si niba ttu ura laa udaale tse'e tennále len neti? ");
INSERT INTO zae_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Gwaltse'e tenná lhe gwalinnaba len Tata Do Yebáha, kini abittu dhi yie nu xxegwiha le nna eyadi gaale. Gwalí galá lebi'i gwa rakabinle tse'e tennále, ttaka bela latile‑na labí ridaana uchíana. ");
INSERT INTO zae_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nianna tti dedheyye attu libe nna bedennee len Tata Do Yebáha nna ree: ―Tata to kia, ganna abíba aka kualu nu satea‑ni, la'ania nna nu innába kwinalu aka. ");
INSERT INTO zae_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tti bedeyekie attu libe dedheyye ata se'e ka benneha, nianna gwadixxakagabe ke dedete'adhigabake kumu de ta'a xxattake bisiela. ");
INSERT INTO zae_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Niha‑ba bodose'ebie ke nna dedheyye gwenne len Tata Do Yebáha beyonna libe. Bodeki adakabe ka tisa ka nu chi ree benneha. ");
INSERT INTO zae_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tti bedeyekie attu libe ata se'e ka benne rudhetinieha nna ree ke: ―¿Si sa te'adhibale? Neti benne daya yebáha, chiba bisia ura nuní utekana neti lasi ná ka nu ruin tulha. ");
INSERT INTO zae_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Chinka gwaleyadha nna gwaletía! ¡Ne nu utena neti lasi ná ka nu uttikana netiha chi daa naa! ");
INSERT INTO zae_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sa dula Jesús‑ni rinnebie tti bisin Judas nu selana lhe'e ka benne tsi'inu (12) rudhetinieha. Bisin lenna ixeru ka nu denkana espada lhe yaga lhe. Ka nu loni ge ka bixxudiha lhe ka nu anka benneola ge ka nu Israel‑ni lhe, lakana udhelhakana ka nuha. ");
INSERT INTO zae_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas nu utena Jesús‑ni lasi ná ka nuha nna chila rana ka nuha: ―Nu ibigaa goa xxaganiha, lana nuha udaxxule. ");
INSERT INTO zae_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nianna ubiga tteba Judas‑ni ata du Jesús‑ni nna rane: ―¡Padiuxi, maestru! Nianna tti utona xxage. ");
INSERT INTO zae_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Labie nna ree na: ―Betsi to, tsa ttela ben nu dalu uinlu. Nianna tti ubiga ka nu daa lennaha nna bedaxxu ttebakana Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ttaka ttu ka benne du len Jesús‑ni nna ulea ttebe espada geeha nna uchúe naga nu riben lo sina ge bixxudi xeniha. ");
INSERT INTO zae_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús‑ni nna ree benneha: ―¡Tasiekilu! Boga'a espada gelu‑na lhe'e xoni, kumu ka nu ruttikana len espada, len nunágaba gattikana. ");
INSERT INTO zae_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Si rakinlu labí aka kia innabaa len Tata kiaha kini idhelhe ixe juisiru ka anjeli ki odiláke neti loora tte nnanna? ");
INSERT INTO zae_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ttaka ganna gaxia ka benneha, la'ania nna, ¿galasina ki aka nu ra lo ka yetsi ge Tata Do Yebáha ata rigixxi'a ra deki teeki satea aní? ");
INSERT INTO zae_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Looraha tteba nna ra Jesús‑ni ka nu chi bedaxxukaneha: ―¿Beaka ttiba ttu nu daa gwedaxxu ubana dale gwedaxxu neti, denle espada lhe yaga lhe? Ki ttu ttu sába ridúa ro'o yotu‑na rule'enia le nna abí chiga bedaxxule neti. ");
INSERT INTO zae_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ttaka iyá nuní raka kini rado tisa ge nu unne ka profetaha lo ka yetsi ge Tata Do Yebáha. Nianna iyába ka benne rudhetini Jesús‑ni bexunnike nna a ttúbe bedúke. ");
INSERT INTO zae_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ka nu bedaxxukana Jesús‑ni nna deche ttebakane arlo Caifás nu anka bixxudi xeniha. Niha chi tupa ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe chi tupa ka benneola ge ka nu Israel‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ttaka Pedro‑ni nna idittuliba danalhane axtaliba bisinna lali'a ge yo'o ata do bixxudi xeniha. Uta'abana nna urena len ka nu se'e gweyú ro'o yo'oha kini ilenna bixa aka. ");
INSERT INTO zae_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ka nu loni ge ka bixxudiha lhe ka benneolaha lhe adíru ka nu runi elhuxtisi ge ka nu Israel‑ni rigilakana ka nu uin lekani ki usiakana iki Jesús‑ni ttu bixa. Aníha ki tee ro'okani ukinnikane nna uttikane. ");
INSERT INTO zae_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ttaka labí udaakana, meskiba bika betso dúkana ixe ka nu ben lekani. Delola nna bisia a chupakana nna ");
INSERT INTO zae_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","rákana: ―Nubiyú du nii rana: “Neti gwakaba kia uttampaa yotu ge Tata Do Yebáha nna delo tsunna ubisaba nna chi elhidhaa na.” ");
INSERT INTO zae_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Bixxudi xeniha nna udú liina nna rana Jesús‑ni: ―¿Bíunni rusia ka nuní ikilu? ¿Si lagwa gwekabilu ge nu rákana‑ni? ");
INSERT INTO zae_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ttaka Jesús‑ni siiba uke, labí bekabie. Bixxudi xeniha nna rane: ―Tata Do Yebaa benne anka baniha rudettia rinnabaa lenlu, utixxi'a, ¿si lu ankalu Cristu Xi'in benneha? ");
INSERT INTO zae_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús‑ni nna bekabie, ree: ―Luba chi raxa. Anágaba neti upegabaa le deki neti benne daya yebáha, debá nnanna chi ilenle neti dhoa daka ná ben ge Tata Do Yebaa benne ra tsitsi leeha lhe ilágabinle neti dedáya yebáha lhe'e beaha. ");
INSERT INTO zae_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nianna tti ulhi triba xo bixxudi xeniha uchedana nuha. Nianna tti rana ka nu se'e niha: ―¡Tata Do Yebáha nuná rorexxa gaana tti rana aná! Nnanna labíru riyasinri'i nuxa kixxi'enna ri'i deki bixa ben nuní, ki kwinaba lebi'i chi biyienin nagale deki rorexxa gaana Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Lebi'i nna, ¿bí rakinle? Ka nuha nna bekabikana, rákana: ―Ralhaba nuná gattina. ");
INSERT INTO zae_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nianna tti udulokana bettuttu xxenkani loe, attu chupakana nna bedhenkane nna attu chupakana nna uleakana gi ro'e. ");
INSERT INTO zae_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nianna tti rákane: ―Cristu, unne ya'achu, ¿núnna bedhenna lu ganna? ");
INSERT INTO zae_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Laka raka nuha, Pedro‑ni nna lali'a ge yo'oha‑ba dona. Nianna tti ubiga ttu ka nuila riben sina niha, rana na: ―Lu lhe danalhagabalu Jesús ge Galilea‑ni. ");
INSERT INTO zae_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ttaka lana labí uxí ro'oni arlo iyá ka nuha deki ankabienne. Rálana: ―Bi yu neti bí ge nuná rinnelu. ");
INSERT INTO zae_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tti chi deyyana eriana ro'o yo'oha, nianna tti bedeláni attu nuila riben sinaha Pedro‑ni. Nianna ra nuha ka nu se'e niha: ―Anágaba nuní danalhagabana Jesús ge Nazaret‑ni. ");
INSERT INTO zae_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ttaka lana nna labí bededí ro'oni, axtala rana: ―¡Yuru Tata Do Yebáha, labí ankabiati nubiyú‑na! ");
INSERT INTO zae_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Attu sattiruba nna chi bedebiga ka nu se'e niha ata du Pedro‑ni nna redeakana na: ―Gwalí galá, gaxa lu selagabalu len ka nu danalhakana Jesús‑ni, kumu reyakabia tteba elha rinne gelu. ");
INSERT INTO zae_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Lana nna rana: ―Gwalígati xa; labí ankabiati nubiyú‑na. Tata Do Yebáha ugwebie neti elha disa ganna abíba liiti. Looraha tteba nna uresi chinkaha. ");
INSERT INTO zae_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nianna gwadú tteba le Pedro‑ni ge nu ra Jesús‑ni tti rabie na: “Lanila kwesi chinkaha, lu tsunna libela chi bedhea lelu labí ridí ro'olu deki ankabienlu neti.” Nianna beria ttebana ata du naa, nna uresibana ttibaxkaba leni de releninna. ");
INSERT INTO zae_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tti chi ugwani dilaha nna iyába ka nu loni ge ka bixxudiha lhe ka benneola ge ka nu Israel‑ni lhe, iyábakana beda'a ro'okani deki gattiba Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nianna tti bexxikakane nna chekane gwaga'akane lo Pilato nu rinnabiaha. ");
INSERT INTO zae_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas nu betena Jesús‑ni lasi ná ka nu loni ge ka bixxudiha lhe lasi ná ka benneola ge ka nu Israel‑ni lhe, tti bilenna deki chiba bekinnikana Jesús‑ni ki gattie, nianna chi bodúna na ge nu bennaha nna ugía ttebana bodekina rerua (30) belhiu plata nu begwekana naha, ");
INSERT INTO zae_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","nna rana ka nuha: ―Neti tulha xxeniba nuná benia betea lasi nále ttu benne labí bi benie. Ttaka ka nuha nna bekabilakana, rákana: ―¡Deloxa, labí yu ri'itu! ¡Naba biyú! ");
INSERT INTO zae_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nianna gwadelha ttebana ka belhuha lhe'e yotuha nna tti biriana diana gwalhu'u tuu yienni. ");
INSERT INTO zae_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ka nu loni ge ka bixxudiha nna bedigakana ka belhuha nna rákana: ―Belhiu‑ni labí ga'anna egu'uri'i nuní lhe'e ata ru'u ka úna ge yotu‑ni kumu belhiu‑ni ankana nu utixari'i kini gatti ttu benne. ");
INSERT INTO zae_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aníha uka nna beda'a ro'okani go'okana len belhuha xulali nu tee láni Ata Riria Ka Yedhu, kini xulaliha ixúna igatsi ka nu dittu. ");
INSERT INTO zae_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","De nuha nna axtaba nnanna beya'an lá xulaliha Xulali Nu Biyo'o Len Reni. ");
INSERT INTO zae_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Aníha ki gwado tisa ge nu unne profeta Jeremías‑ni, tti ree: “Bedaxxubakana rerua (30) belhiu plataha. Ttanía nuha ulea ka nu Israel‑ni lidhaka benne gattiha. ");
INSERT INTO zae_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nianna tti betekana nuha kini biyo'o xulali ata riria ka yedhuha. Benbakana attiba raba Tata Xisiha neti”, aníha ra Jeremías‑ni. ");
INSERT INTO zae_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús‑ni nna bisin lenkane arlo Pilato nu rinnabiaha. Nuha nna unnaba tisane, rane: ―¿Si lu ankalu nu rinnabia ge ka benne Israel‑ni? Lee nna bekabie geni, ree: ―Luba chi ra deki nuná ankaa xa. ");
INSERT INTO zae_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ka nu loni ge ka bixxudiha lhe ka benneola ge ka nu Israel‑ni lhe, tti se'ekana rukinnikane arlo Pilato‑ni, lee nna kwachiruba bekabie gekani. ");
INSERT INTO zae_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nianna tti ra Pilato‑nie: ―¿Si gwa riyieninlu? Ttaníli nu rusiakana ikilu. ");
INSERT INTO zae_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ttaka Jesús‑ni nna niba ttu tisa laa bekabie. De nuha nna nu rinnabiaha rugía ya'abana de labí rekabie geni. ");
INSERT INTO zae_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kua risiaba laní Pascua, Pilato nu rinnabiaha labinna rodilána ttu ka nu tee lisiyya. Rebeabana nu rakaba le yiesiha eria. ");
INSERT INTO zae_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","La'ania nuha yaya ttu nubiyú lisiyya. Iyába ka benne yuke ge nu benna. Nubiyúha lána Barrabás. ");
INSERT INTO zae_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tti chi tupa ka benne niha, nna unnaba tisa Pilato‑ni kana, rana: ―¿Nú raka lele odiláya? ¿Si odiláya Barrabás‑ni ak? ¿Odiláya Jesús nu tee láni Cristu‑ni ak? ");
INSERT INTO zae_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Aníha ra Pilato‑ni kumu chiba yuna deki de ritisibakinna Jesús‑ni nna gwaga'akane loni. ");
INSERT INTO zae_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Laka do Pilato‑ni ata rinnabianaha nna udhelha nuila geniha ttu rresona geni, rana na: “Bittu uga'a nálu len nubiyú‑na. Labí bixa ben nuná. Kumu de lana nna neti yalhá elha disa biyúa bitsiati ttu ela.” ");
INSERT INTO zae_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ttaka ka nu loni ge ka bixxudiha lhe ka benneola ge ka nu Israel‑ni lhe, biri'aba lenkana uxí yiekana ka nu saa niha kini ka nuha nna unnabakana kini olhána Barrabás‑ni nna Jesús‑ni nna unnabakana kini gattie. ");
INSERT INTO zae_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nu rinnabiaha nna unnaba tisana kana attu libe, rana kana: ―Delo ixpa ka nuní, ¿nú ka nuní raka lele odiláya? Lakana nna rákana: ―Barrabás‑na bodilaa. ");
INSERT INTO zae_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato‑ni nna rana kana: ―Jesús nu rale Cristu‑ni nna, ¿bíla anka nu unia len nuní ganna? Iyábakana bekabikana, rákana: ―¡Betá nuná lo ya kurusi! ");
INSERT INTO zae_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nianna ra Pilato‑ni kana: ―¿Beaka? ¿Bí nu satsa ben nuní? Ttaka lakana nna adíla idisa ribesi'akana, rákana: ―¡Betá nuná lo ya kurusi! ");
INSERT INTO zae_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tti ute den Pilato‑ni deki labí dhaana lo ka nuha, kumu adíla rigiyyakana, nianna tti bedaxxuna inda nna utí náni arlokani nna rana kana: ―Labí udelhale kwe'a elhutti ge nubiyú‑ni. ¡Naba gwaluyú! ");
INSERT INTO zae_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Iyábakana bekabikana, rákana: ―Kwe'ebatu lhe kwe'e ka xi'intu‑niba tsia elhutti ge nuná. ");
INSERT INTO zae_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nianna bolhába Pilato‑ni Barrabás‑ni. Jesús‑ni nna udhelhana ki bekulhakane, nianna tti botene lasi ná ka nu utákane lo ya kurusiha. ");
INSERT INTO zae_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ka soldadu ge Pilato nu rinnabiaha chekana Jesús‑ni lhe'e guskadu ata ridona ruinna elhuxtisiha. Nianna tti bottupakana adí ka soldaduha abi'iba kwe'e Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Uleakana ka xoeha nna begukukane ttu lari xiná. ");
INSERT INTO zae_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nianna tti benkana ttu corona yetsi nna ulu'ukana nuha ikie nna begwekane ttiba ttu vara ge nu rinnabia den ná benbie, nianna tti bedú xibikani arloe ruxisikana gebie, rákane: ―¡Xxeni ra lelu xa nu rinnabia ge ka nu Israel! ");
INSERT INTO zae_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nianna tti ruttuttu xxenkani loe nna rudaxxukana vara denieha nna riginkana nuha ikie. ");
INSERT INTO zae_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Iki de chi bedhakakane aníha, nianna tti utuakana lari xiná nukueha nna bogukukane ka xoeha, nianna tti chekane kini utákane lo ya kurusiha. ");
INSERT INTO zae_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tti biriakana dia lenkana Jesús‑ni, nianna beti'akana ttu benne lhe'esi Cirene lábie Simón. Benneha bedo doelhakane ki bije kurusi ge Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nianna tti bisinkana ttu latti ata tee láni Gólgota. (Gólgota dienna innána Bega Iki Nu Yatti.) ");
INSERT INTO zae_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Niha begwekana Jesús‑ni vinu nu dia kuana ilhá ikini ki i'iye, ttaka iki de chi bennixxie nuha nna birua uka lebie i'iye nuha. ");
INSERT INTO zae_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Iki de chi betákane lo ya kurusiha, nianna bedelhakana suerti kini elha'akana ka xoeha, kini ula'ana nupaxakana galhakana edíkana ka nuha. Aníha ki gwado tisa ge nu unne benne uke profeta ge Tata Do Yebáha, tti ree: “Belha'abakana ka xoaha nna bedelhakana suerti ge ka nuha.” ");
INSERT INTO zae_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nianna tti use'ekana biyú tsitsibakane. ");
INSERT INTO zae_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Daka xekie betákana ttu breta dia letra loni ata rigixxi'a bí ge taabie lo ya kurusiha. Lo bretaha dia ra: “Nuní ankana Jesús nu rinnabia ge ka benne Israel‑ni.” ");
INSERT INTO zae_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Betákana Jesús‑ni lhe betágabakana a chupa ka ubana lo ka ya kurusi, ttúna daka ná banie nna attúna nna daka ná yattie. ");
INSERT INTO zae_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ka nu rite ata taabieha nna ruttába ikikani rulisa xxattakane, ");
INSERT INTO zae_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","rákana: ―Lu ralu deki ottampalu yotu‑na nna delo tsunna ubisaba chi elhidhalu na. ¡Ganna si gwalíginlu ankalu Xi'in Tata Do Yebáha, titúbalu benchu ki lhaalu lo ya kurusi‑na nna beyadichu! ");
INSERT INTO zae_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aníha‑gaba ruin ka nu loni ge ka bixxudiha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe aníha‑gaba ruin ka fariseo‑ni lhe ka benneola ge ka nu Israel‑ni lhe; ruxisigabakana gebie, rákana: ");
INSERT INTO zae_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―¡Ka benne subi gwa bodilána, ttaka lana nna a raka geni elaa titúbana lo ya kurusi‑na! ¡Ganna gwalíginna ankana nu rinnabia ge ka nu Israel‑ni, eyadichuna lo ya kurusi‑na, la'ania nna ri'itu gweyya letu geni! ");
INSERT INTO zae_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Bexxen leni ge Tata Do Yebáha, nnanna nna odiláchue na ganna gwalíga rakanie geni. Kumu rana: Neti ankaa Xi'in Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Anágaba ka ubanaha, ka nu taagabakana lenie lo ka ya kurusiha, rulisagabakane. ");
INSERT INTO zae_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Itúba yiesi lo yu‑ni udulo bechulha, udulo bechulha retin tsi'inu (12) nna axtaliba retin tsunnaha beyani. ");
INSERT INTO zae_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","La uraha‑gaba nuha, uresi'a Jesús‑ni itú lebie, ree: ―Elí, Elí, ¿lama sabactani? ―Tisa‑ni dienna innána: Tata Do Yebaa kia, Tata Do Yebaa kia, ¿beaka rudhá ikilu neti? ");
INSERT INTO zae_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tti biyienini ttu chupa ka nu se'e niha nu reeha, nianna ra luesikani: ―Profeta Elías‑niba nuná raxina. ");
INSERT INTO zae_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Looraha nna ttu ka soldadu du niha biresu ttebana gwaxxína ttu xunu nna bodibidhana nuha len vinu idí. Nianna tti bexxikana nuha lo ttu iyyaxtila nna bedona nuha ro'o Jesús‑ni kini i'iye nuha. ");
INSERT INTO zae_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Adí ka nu se'e niha nna rákana: ―Naa la taachuna si gwetedilaa Elías‑ni na lo ya kurusi‑na. ");
INSERT INTO zae_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ttaka Jesús‑ni nna uresi'e attu libe idisa, nianna tti bechú lebie. ");
INSERT INTO zae_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Looraha tteba nna bireda lari daa lhe'e yotuha, chubaa tíba ukana, udulona xekini nna axtaba xani'ani bireda. Yiesi lo yu‑ni nna bixú. Ka íyya bartoha nna bila'a lhe'ekani. ");
INSERT INTO zae_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Biyaligaba ka yieru baa nna beyaka ben ixeru ka benne chi uttiha, delába ka benne chi ulesi Tata Do Yebáha ki akake gebie. ");
INSERT INTO zae_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ka benneha beriake lhe'e ka yieru baaha nna iki de chi beyaka ben Jesús‑ni lo elhuttiha, la'ania nna beta'a ka benne beyaka baniha lhe'e yiesi le'aha, delába Jerusalén‑ni, nna niha bele'e loke len ixe ka benne. ");
INSERT INTO zae_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Soldadu nu baninna adí ka soldaduha, du lenna attu chupa ka soldadu ruyúkana Jesús‑ni. Ka soldaduha tti bilákinna chi rixúha lhe iyá nu chi ukaha lhe, nianna usi xxattakinna nna rákana: ―Benne‑niligaba nna gwalí anke Xi'in Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ixeba ka benne nuila, delába ka benne danalhake Jesús‑ni desdeba Galilea‑ni kini bete náke lenbie, ka benneha idittuliba se'eke gwelanni. ");
INSERT INTO zae_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lhe'e ka benneha sela María Magdalena lhe María nan ge Jacobo‑ni lhe José‑ni lhe; niha‑gaba sela nan ge ka xi'in Zebedeo‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tti chi ulha sáha nna bisin ttu benne biyú tee gebie. Benneha lábie José. Lee anke benne lhe'esi Arimatea. Benneha ukagabe ttu ka benne bedhetini Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","José‑ni ugíe arlo Pilato‑ni nna bennabe Jesús‑ni ki ukatsie benneha. Pilatuha nna udhelha ttebana kini botekana benneha len José‑ni. ");
INSERT INTO zae_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José‑ni nna bedíbe Jesús‑ni nna tti bottesie benneha ttu lari nari xú. ");
INSERT INTO zae_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nianna bekatsie Jesús‑ni lhe'e yieru baa kubi geeha. Yieru baaha uche'enie na lhe'e ttu íyya daa niha. Nianna iki de chi bekatsie Jesús‑ni nna tti bottulhue ttu íyya xeni kini bedheabie ro'o yieru baaha, nianna tti deyye. ");
INSERT INTO zae_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ata bigatsi Jesús‑ni re María Magdalena‑ni lhe attu María‑ni lhe; se'eke daka arlo yieru baaha. ");
INSERT INTO zae_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Beyeki sáha, la sá tti reyaka le ka benne Israel‑ni, ka nu loni ge ka bixxudiha lhe ka fariseo‑ni lhe bisinkana lo Pilato‑ni ");
INSERT INTO zae_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","rákana na: ―Tata xisi to, ri'itu rexxa letu ge nu ruin leniha tti sa anka bennaha, rana: “Ganna chi uka tsunna ubisa uttiaha, iki de nuha nna eyaka benbaa attu libe.” ");
INSERT INTO zae_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","De nuha nna rinnabatu len kwinalu kini idhelhalu ka nu tse'e tsitsikana ki uyúkana ro'o yieru baaha axtaliba ganna chi beyonna ubisaha, la'anialiba nna ebi'ettakana kumu ni kina tsia ka nu bedhetinaha nna salea sigákana nu yattiha. Nianna tti tsekikana gákana ka benne deki beyaka benba nuha lagwi ge ka benne chi uttiha. La'ania nna adírula xeni aka gwen lasi inne ka nuha attichula gwen lasi unne nuha sisi'a tteha. ");
INSERT INTO zae_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato‑ni nna rana kana: ―Naba se'e ka soldadu ka nu uyúkana ro'o yieru baaha. Gwaliche kana nna gwaludhea tsitsi ro'o yieru baaha. Gwaluinba ttiba rudhakaba lele kini tsaya tsitsi ro'oni. ");
INSERT INTO zae_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aníha uka nna diakana gwadhea tsitsikana íyya nu yaya ro'o yieru baaha nna bese'ekana ka soldaduha ki uyú tsitsikana ro'o nuha. ");
INSERT INTO zae_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Iki de chi ute sá tti reyaka le ka benne Israel‑ni, tti chi ugwani dila bedú ni'a xumanuha, dia María Magdalena‑ni lenie attu María‑ni diake gwalannike ro'o yieru baaha. ");
INSERT INTO zae_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ttiruba ttu nnelaba bixú idí kumu ttu anjeli ge Tata Xisiha ugwadie dabie yebáha. Bisie nna ubige ro'o yieru baaha nna utue íyya yaya ro'o nuha nna tti udoe ikini. ");
INSERT INTO zae_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Raka lhalhabe attiba raka lhalha tti rapi edha‑na lhe sitsi túba anka xobie ttiba begi. ");
INSERT INTO zae_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ka soldadu ka nu se'e ruyúkana ro'o yieru baaha, rixidinibakana de usikinna ge anjeliha, nna tuttíruba bechulhakinna ttiba ttu nu yatti ukakana. ");
INSERT INTO zae_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anjeliha nna unnebie, rabie ka benne nuilaha: ―Bittu gasinle, kumu neti gwayúbaa deki lebi'i regilale Jesús ge Nazaret benne betákana lo ya kurusiha. ");
INSERT INTO zae_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Lanúru benneha tee nii kumu chiba beyaka ben benneha atti tteba chi reeha. Gwaltáruga gwalugía ata utixxakaneha. ");
INSERT INTO zae_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nnanna nna jeru tte gwaleyya gwasattixxi'ani ka benne bedhetinieha deki chiba beyaka ben benneha lagwi ge ka benne chi uttiha nna chi deyye daka Galilea‑ni daneru gaabie nna niha ilenlee. Neti nuníba daya ugixxi'en le. ");
INSERT INTO zae_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aníha‑ba uka nna jeru tteba deyya ka benne nuilaha beru'unake ro'o yieru baaha, rasibakanie lhe redeakabakanie deyyake gwattixxi'akanie ka benne bedhetinieha. ");
INSERT INTO zae_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ttiru nna ttu nnelaba uka xxe Jesús‑ni arlo ka benne nuilaha nna begwebie ke padiuxi. Lake nna ubiga ttebake gwatesike lhe'e ka ni'eha nna bedú xibike arloe. ");
INSERT INTO zae_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús‑ni nna ree ke: ―Bittu gasinle. Gwaltsia nna gwaligasi ka betsi to kiaha, delába ka benne bedhetiniaha, gwaligasi ke tsiake daka Galilea‑ni, niha ilákanie neti. ");
INSERT INTO zae_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Laka deyu'u ka benne nuilaha neda deyyake, ttu chupa ka soldadu ka nu se'e gweyú ro'o yieru baaha deyya ttebakana lhe'esiha nna gwattixxi'akinna ka nu loni ge ka bixxudiha ge iyába nu chi ukaha. ");
INSERT INTO zae_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ka nu loni ge ka bixxudiha nna bitupa ttebakana unne lenkana ka benneola ge ka nu Israel‑ni nna beda'a ro'okani begwekana ka soldaduha ixeni belhiu. ");
INSERT INTO zae_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Nianna tti rákana ka nuha: ―Aní innále: Ka nu bedhetini Jesús‑niba bitakana lo rela tti te'adhituha nna beteleabakana benne yattiha. ");
INSERT INTO zae_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ganna eyona Pilatu benne rinnabiaha ge nuní, ri'itu gwanneba lentue kini lebi'i nna abittu isela elha gaa gele. ");
INSERT INTO zae_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aníoka nna ka soldaduha uxíbakana belhuha nna benbakana ttiba raba ka bixxudiha kana. De nuha nna nu ra ka soldaduha la'ania, nuha‑ba sa ra ka nu Israel‑ni axtaba nnanna. ");
INSERT INTO zae_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Iyába ka benne sinea bedhetini Jesús‑ni diake daka Galilea‑ni iki i'iya ata chi rabie keha. ");
INSERT INTO zae_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tti chi bilákanie bie, nianna bedú tteba xibike arlobie; ttaka attu chupake nna rudúbana ke, labí yuke ganna gwalíttiga lee nuha. ");
INSERT INTO zae_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús‑ni nna ubige ata se'ekeha nna ree ke: ―Tata Do Yebáha chiba betebie lo neda len neti kini innabiaya yebáha lhe yiesi lo yu‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","De nuha nna gwaltsia lhe'e iyá xea ka yiesi se'e yiesi lo yu‑ni nna gwaluse'e ka benne kini udhetike ka tisa kia‑ni nna gwalugadi ke inda lhe. Tti ugadile ke indaha nna udettile lá Tata Do Yebáha lhe lá Xi'inieha lhe lá Espíritu geeha lhe. ");
INSERT INTO zae_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Anágaba nna gwalule'e kanie kini udoke tisa ge iyá nu chi bodha'anaa len lebi'i uinke. Neti nna ttu ttu sába gwadúbaa len lebi'i axtaliba ganna chi lhuxa yiesi lo yu‑ni. Amén.");
INSERT INTO zae_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nii ridulo ka tisa ka nu rigixxi'akana ge Jesucristu benne anka Xi'in Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ukaba atti tteba ra lo yetsi ben profeta Isaías‑ni. Lo yetsiha rinne Tata Do Yebáha rulise Jesús‑ni, ree: Neti idhelhaa ttu benne tsie nnerue lolu kini kixxi'e ka tisa kia‑ni. Benneha idhalie neda gelu. ");
INSERT INTO zae_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lo yu bisi ata lanú benne se'e, niha riyien tsi'i benneha rinnebie idisa, ree: “Gwalegixxa tse neda ge benne anke Xxanari'iha. Gwalolixxa neda kini dhabie.” ");
INSERT INTO zae_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aníha‑ba ben Juan benne rugadi indaha tti ugwekie lo yu bisiha, rigixxi'anie ka benne kini odúna ke nna odaxxuke neda ge Tata Do Yebáha, nianna gadike inda kini anáchu nna ixú elha xen lasi ge ka tulha ruinkeha. ");
INSERT INTO zae_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Iyába ka benne se'e lhe'esi Jerusalén‑ni lhe ka benne se'e itúba daka Judea‑ni lhe, risinke ata reki Juan‑ni, rigixxi'ake ge ka tulha ruinke nna rugadie ke inda lhe'e yoo Jordán‑ni. ");
INSERT INTO zae_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan‑ni itsa xo camellu‑ba uka xoe nna udhí lhe'ebie ttu yieti. Nu xixxi ge betsirúba lhe kutsittaba lhe utobie ugwekie ");
INSERT INTO zae_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","nna rigixxi'anie ka benne, ree ke: ―Iki de neti nna si dala attu benne ra tsitsiru lebie attichula neti. Neti labí elha ralhaa iyettaa idhasia lo ka gwaracha geeha. ");
INSERT INTO zae_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Gwalí galá neti tti rugadia le inda, suna indaba rixúti, ttaka benneha nna ugadie le Espíritu ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lhe'e ka sáha‑gaba udá Jesús‑ni lhe'esi Nazaret, re nuha daka Galilea. Nianna bisine nna begadi Juan‑nie inda lhe'e yoo Jordán‑ni. ");
INSERT INTO zae_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tti lo reria Jesús‑ni lhe'e indaha, nianna bilánie biyali yebáha nna Espíritu ge Tata Do Yebáha attiba ttu becha ugwadie betedhoe ikie. ");
INSERT INTO zae_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nianna tti biyien tsi'i ttu benne unnebie yebáha, ree bie: ―Lu ankalu Xi'inia rakati gelu; lu ankalu benne ru'u lasia. ");
INSERT INTO zae_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nianna che tteba Espíritu ge Tata Do Yebáha Jesús‑ni daka lo yu bisiha, ata lanú benne se'e. ");
INSERT INTO zae_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Niha ugwekie chua (40) ubisa ata reki ka nimala ixxi. Niha‑gaba ben nu xxegwiha dhi yiene nna ka anjeliha‑ba bete náke lenbie. ");
INSERT INTO zae_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Iki de chi utixxakana Juan‑ni lisiyya, Jesús‑ni nna deyye daka Galilea rigixxi'anie ka benne ka tisa tse, delába rigixxi'e gasina ki akake benne innabia Tata Do Yebáha ke. ");
INSERT INTO zae_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nianna ree ka benneha: ―Chiba gwa dona sá ga'anani Tata Do Yebáha lhe chigaba dabigana innabie. De nuha nna gwalodúna le nna gwaltsia lele ge ka tisa geeha. ");
INSERT INTO zae_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tti ute Jesús‑ni ro'o indatoo ge Galilea‑ni, niha bilánie Simón‑ni lenna betsini Andrés‑ni yu'ukana rudelhakana yexxa ge ka belhaha lhe'e indaha, kumu ankakana benne rudaxxu belha. ");
INSERT INTO zae_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús‑ni nna ree kana: ―Gwaltá gwetenalha neti. Neti nna unia kini akale ka nu gaxile ka benne ki udaxxuke neda ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Looraha tteba nna bese'e bixxibakana ka yexxa gekaniha nna diakana danalhakane. ");
INSERT INTO zae_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A lattiruba bededábie nna bedelánie Jacobo‑ni lenna betsini Juan‑ni. Ka nuha ankakana xi'in Zebedeo. Se'ekana lhe'e barcu gekaniha reyoinkana ka yexxa ka nu rudaxxu lenkana belhaha. ");
INSERT INTO zae_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nianna uxi ttebe kana. Lakana nna bedhá bixxiba ikikani tata gekaniha lo barcuha lenie ka nu ren sina gekaniha, nianna dia ttebakana danalhakana Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tti bisin Jesús‑ni lenie ka benne rudhetinieha lhe'esi Capernaum‑ni, la sá tti reyaka le ka benne Israel‑ni, uta'a ttebe lhe'e yo'o ata rudhetike ka tisa ge Tata Do Yebáha nna uduloe rule'enie ka benne se'e niha. ");
INSERT INTO zae_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ka benneha nna rebanabakanie ge nu rule'enie keha kumu rinnebie ttiba rinne ttu uxtisi rapa lo neda, labí tti rinne ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni. ");
INSERT INTO zae_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lhe'e yo'o ata rudhetike ka tisaha, niha re ttu nubiyú yu'u latini ttu espíritu satsa. ");
INSERT INTO zae_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Nubiyúha nna unnena idisa, rana: ―¡Begwelha ri'itu! ¡Bittu etega'a gelu len ri'itu, lu Jesús ge Nazaret! ¿Si dalu gwetse'e loo ri'itu? Neti gwankabiabati lu. ¡Lu ankalu benne chi ulesi Tata Do Yebáha! ");
INSERT INTO zae_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús‑ni nna bedhaka dise espíritu satsaha, ree nuha: ―¡Bedhea ro'olu nna beria lati nubiyú‑ni! ");
INSERT INTO zae_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Espíritu satsaha nna bekubi xxattana nubiyúha nna ribesi'a layabana beriana latini. ");
INSERT INTO zae_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Iyába ka benne se'e niha bebanabakanie nna rinnaba tisa luesike, ráke: ―¿Bíunni raka? ¡Nubiyú du‑ni rula'ana attu tisa kubi! ¡Xxeniba ra leni nna axtaba ka espíritu satsa‑na rudokana tisa ge nu rana! ");
INSERT INTO zae_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nianna ttu nnelaba ugwadhi tisa ge Jesús‑ni nna ka benne se'e itúba daka Galilea‑ni rinneke ge nu runieha. ");
INSERT INTO zae_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Atti beriake lhe'e yo'o ata rudheti ka benne Israel‑ni ka tisa ge Tata Do Yebáha, Jesús‑ni lenie Jacobo‑ni lhe Juan‑ni lhe dia ttebake lisi Simón‑ni lhe Andrés‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nan ge nuila ge Simón‑ni teba benneha yu'u xxatte xilhaa. Nianna utixxi'akinna Jesús‑ni ge benneha. ");
INSERT INTO zae_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús‑ni nna ubiga ttebe bedaxxue ná benneha nna ulhidhe bie. Looraha tteba nna beria xilháha lati benneha nna udulo ttebe benie nu utoke. ");
INSERT INTO zae_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Atti chi ugwadi tatubisa‑na lo'eyya‑na, tti chi daa ratti loha, la'ania nna iyába ka benne yu'u isagwe latike lhe ka benne yu'u latike espíritu xxegwi uchekana ke ata du Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nianna itúba yiesiha bitupa ro'o yo'o ata dueha. ");
INSERT INTO zae_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús‑ni nna beyonie ixeba ka benne rani yu'u latike iyá looba isagwe lhe bebeabie ixeba ka espíritu xxegwi yu'u lati ka benne lhe. Labí begwelhe inne ka espírituha kumu yúbakana nú anke. ");
INSERT INTO zae_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Dila tteba ugwadha Jesús‑ni. Sa rula'aruba chulhaha birie die ro'esiha nna bisine ttu latti ata lanú benne se'e. Niha ulhapie tisa len Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón‑ni lhe ka benne se'e lennaha, diake satilake bie. ");
INSERT INTO zae_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tti gwaxxakake benneha nna ráke bie: ―Iyába ka benne chi rekike ugila lu. ");
INSERT INTO zae_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Lee nna ree ke: ―Tsiari'i lhe'e adí ka yiesi se'e gaxxaba nii kini lhe'e ka nuná kixxi'agabaa ka tisa ge Tata Do Yebáha, kumu de nuha‑la daya. ");
INSERT INTO zae_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Itúba Galilea‑ni reki Jesús‑ni rigixxi'e ka tisa ge Tata Do Yebáha lhe'e ka yo'o ata rudheti ka benne se'e niha ka tisa geeha lhe anágaba nna rebeagabe ka espíritu xxegwi yu'u lati ka benneha lhe. ");
INSERT INTO zae_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ttu benne biyú raka latie yiesu nu tee láni lepra, bisine ata du Jesús‑ni nna bedú xibie arlo benneha nna ree bie: ―Tata to, ganna lu aka lelu, gwadaabalu eyoinlu neti. ");
INSERT INTO zae_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús‑ni nna gwatuaba lebie benneha nna tti belhí nábie utane lati benneha nna ree bie: ―Gwaka galá lasia. ¡Nnanna, chinka beyaka! ");
INSERT INTO zae_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Looraha tteba nna betúa yiesuha lati benneha nna beyaka ttebe. ");
INSERT INTO zae_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nianna bedhelha tteba Jesús‑nie deyye nna bodha'an tsitsie, ree benneha: ");
INSERT INTO zae_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Biyú gelu. Anuttu nu kixxi'enlu. Sun tteba nna ugía gwatso du arlo bixxudiha nna uche úna nu daa lolu utelu ge Tata Do Yebáha de chi beyarilu. Beni attiba ra lo bia bennabi bodha'an Moisés‑ni. Aníha kini uyú lo ka benne deki chiba betúa isagwe‑na latilu. ");
INSERT INTO zae_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ttaka benne biyúha nna adíla benie. Tti berie niha deyye nna iyába ka benne utixxi'anie ge nu chi ben Jesús‑ni. De nuha nna birua uka ga'a Jesús‑ni la saa lhe'e ka yiesi se'e niha. Ka ro'esiha‑liba ridúe ata lanú benne se'e. Ata dueliba risina ka benne daa lhe'e iyába ka yiesiha. ");
INSERT INTO zae_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Iki de chi ute ttu chupa ubisaha nna bedesin Jesús‑ni lhe'esi Capernaum‑ni attu libe. Sun tteba bina ka benne deki chi doe lhe'e yo'oha, ");
INSERT INTO zae_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","nianna bitupa tteba ixeruke. Laxkala axtaba ro'o puertaha birua rakanike. Jesús‑ni nna rigixxi'anie ke ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nianna tti bisin ttapa ka benne biyú nujake ttu benne daa yatti latie ata dueha. ");
INSERT INTO zae_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ttaka kumu de tupa xxatta galá benne ro'o yo'oha, laxkala bi uka ga'ake len benne raniha kini isinke ata du Jesús‑ni. Nianna tti ugwapike iki yo'oha nna utuake ttu chupa ka texa ki udo belea ttu lhixxaba ata dueha. Aníha‑ruba kini uka ulhidake benne raniha xue lo ttu breta. ");
INSERT INTO zae_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tti bilani Jesús‑ni gwa riaba le ka benneha deki gwadaabe eyonie benne daa yatti latieha, nianna tti ree benneha: ―Xi'ini to kia, nnanna chiba bixú elha xen lasi ge ka tulha gelu‑na. ");
INSERT INTO zae_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Niha‑gaba se'e ttu chupa ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni. Ka nuha nna belaba lhi'u lekani, rakakinna: ");
INSERT INTO zae_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Beaka rinne nu du‑ni aní? Rilhida gaabana Tata Do Yebáha tti rinnena aná. Lanú nu aka geni dhina elha xen lasi ge ka tulha ruin ka benne, sunruba Tata Do Yebáha gwaka gebie dhie elha xen lasi gekani.” ");
INSERT INTO zae_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ttaka Jesús‑ni nna ute da ttebanie deki rulaba lhi'u lekani aníha. Nianna tti unnaba tise kana, ree: ―Lebi'i nna, ¿beaka rulaba lhi'u lele aná? ");
INSERT INTO zae_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Gwalinnáruga, ¿bí nuha nu sattiru gari'i benne daa yatti latie‑ni? ¿Si gari'e: “Chiba bixú elha xen lasi ge ka tulha gelu‑na” ak? o ¿gari'e: “Beyadha nna bodaxxu nu xualu loin‑na nna bedá”? ");
INSERT INTO zae_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nnannaruga ula'ania le ki uyú lole deki neti benne daya yebáha, yiesi lo yu‑ni gwa teeba lo neda kia ki dhia elha xen lasi ge ka tulha ruin ka benne. Nianna tti ra Jesús‑ni benne daa yatti latieha: ");
INSERT INTO zae_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Lu rulisaa. Beyadha nna bodaxxu nu xualu loin‑na nna beyya lisilu. ");
INSERT INTO zae_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Benne daa yatti latieha nna beyadha ttebe nna bodaxxue breta xue loniha nna berie lo iyába ka nu se'e niha. Ka nuha nna iyábakana bebanakinna, rákana: ―¡Xxeniba ra le Tata Do Yebáha! ¡Niru tsa labí chi bilenri'i aka luesi nu uka‑ni! ");
INSERT INTO zae_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iki de nuha nna bederia Jesús‑ni dedheyye ro'o indatooha nna iyába ka benne risinke ata dueha. Labie nna rule'enie ke ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tti utebie die, nianna bilánie Levíxi'in biyú Alfeo‑ni dona ata rukixakana belhiu nu daa lo ka benne rigixake ge Roma. Nianna tti ree na: ―Utá betenalha neti. Nianna udú lii ttebana nna gwanalhane. ");
INSERT INTO zae_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Uka nuha, tti chi do Jesús‑ni go yetta lhe'e lisi Leví‑ni, ixeba ka gwekixa lhe adíru ka nu tekinna lákani deki ankakana ka nu ruin satsa se'egabakana lenie go yetta. Anágaba nna se'egaba ka benne rudhetinieha. Kumu ixeba chi raka ka benne danalhake bieha. ");
INSERT INTO zae_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni, delába ka nu ankakana fariseo, tti bilákinna dobie go yetta len ka gwekixaha lhe ka nu ruin satsaha lhe, nianna tti rákana ka benne rudhetinieha: ―¿Beakala maestru gele‑na nna robe yetta len ka gwekixa‑na lhe len ka nu ruin satsa‑na lhe? ");
INSERT INTO zae_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tti biyienin Jesús‑ni nu rákanaha, nianna tti ree kana: ―Ka nu abittu rani‑na, ka nuná labí riyasakin nuná nu eyoinna kana, sinuki ka nu rani‑nala nuná riyasakinna nu eyoinna kana. Neti laa dagaa raxia ka nu ruin nu dika ixú, sinuki dalaa kini raxia ka nu ruin satsa. ");
INSERT INTO zae_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Atti bilani ka benne deki ka nu rudhetini Juan benne rugadi indaha lhe ka nu rudhetini ka fariseo‑ni lhe, ka nuha rutteba ubina lhe'ekani, labí rokana yetta, nianna tti ugía ka benneha nna gweasike Jesús‑ni: ―¿Beakala ka nu rudhetini Juan‑ni lhe ka nu rudhetini ka fariseo‑ni lhe rutteba ubina lhe'e ka nuná, ka nu rudhetinlu‑na nna labí rutte ubina lhe'e ka nuná? ");
INSERT INTO zae_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nianna bekabi Jesús‑ni, ree kana: ―¿Laaba ganna labí dika utte ubina lhe'e ka benne biyaxi kini tse'eke dha'aha, laka sa du nu kwiti rutsá nániha lenke? Neti ria: laka sa du nu kwitiha lenke labí dika utte ubina lhe'eke. ");
INSERT INTO zae_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ttaka ganna chi bisia sá tti itua nu kwitiha, anúruna dho lenke, la'anialigaba nna chi utte ubina lhe'eke. ");
INSERT INTO zae_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Anágaba lanú ttu benne do rotábie ttu ro'o lari kubi ro'o xo yaxxu geeha. Kumu ganna aníha unie, la'ania nna iyalhiba ro'o lari yaxxuha, nianna adíla satsa ireda xoeha, ");
INSERT INTO zae_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","lhe nigaba lanú ttu benne do riga'abie vinu kubi lhe'e ka yieti yaxxu. Kumu ganna aníha unie, vinu kubiha, ganna chi úlana, la'ania nna itsúba nuha yietiha nna ilaliba vinuha lhe tse'e loogaba yietiha lhe. Laxkala vinu kubiha teeki ita'a nuha lhe'e ka yieti kubi. ");
INSERT INTO zae_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","La sá tti reyaka le ka benne Israel‑ni, la'ania ute Jesús‑ni lhe'e ka xuxtila se'e niha len ka benne rudhetinieha. Ka benneha nna uduloke richekuke iki ka xuxtilaha. ");
INSERT INTO zae_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ka fariseo‑ni nna rákane: ―¡Biyúruga! ¿Beaka ruin ka nu rudhetinlu‑na nu abittu ga'anna uinri'i lhe'e ka sá atti reyaka leri'i? ");
INSERT INTO zae_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Lee nna bekabie, ree kana: ―¿Si ni tsa abittu chi belabale lo yetsi ge Tata Do Yebáha ata rigixxi'a bí ben David‑ni ttu libeha? Yule benneha itupa lenie ka benne ugweki lenie la'ania, tti bituinkeha nna biyasakanie nu goke. ");
INSERT INTO zae_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","La'ania uta'a David‑ni lhe'e yotu ge Tata Do Yebáha atti anka Abiatar‑ni bixxudi xeni. Nianna utoe ka yettaxtila ka nu chi riesike ankake sun tteba ge Tata Do Yebáha, anágaba nna begwegabe ka benne se'e lenie la'ania ki utoke benneha, delába utoke ka yettaxtila ka nu labí ga'anna go attu benne subi, sunruba ka bixxudiha gwaka gokana benneha. ");
INSERT INTO zae_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús‑ni nna rágabe kana: ―Ka sá tti reyaka leri'i‑na ukakana ki ri'i ixuinri'i kana, laa uligari'i kini nu innála ka sá‑na uinri'i. ");
INSERT INTO zae_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","De nuha nna neti benne daya yebáha, netiba ankaa xxana ka sá reyaka leri'i. De nuha nna gwa teeba lo neda kia innía bixa dika uinri'i lhe'e ka sá reyaka leri'i. ");
INSERT INTO zae_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús‑ni uta'abie attu libe lhe'e yo'o ata rudheti ka benne Israel‑ni ka tisa ge Tata Do Yebáha. Niha re ttu benne biyú daa yatti ttu lha'a nábie. ");
INSERT INTO zae_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ka fariseo‑ni nna rulhatsibakana ge Jesús‑ni ganna gweyonie benneha la sá tti reyaka lekaniha, kini anáchu nna tee ro'okani bixa usiakana ikie. ");
INSERT INTO zae_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nianna tti ra Jesús‑ni benne daa yatti neeha: ―Udú lii nna utá udú lagwi‑ni. ");
INSERT INTO zae_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nianna tti unnaba tise kana, ree kana: ―¿Bí ga'anna uinri'i lhe'e ka sá tti reyaka leri'i? ¿Si uinri'i latsiru ak? ¿O uinri'i nu satsa ak? ¿Si odilári'i ttu benne? ¿O ugwelhari'i gattie ak? Ttaka lakana siiba ukakana, labí bekabikana gebie. ");
INSERT INTO zae_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús‑ni nna risa'abanie rulannie lo ka nu se'e abi'iba kwe'eeha nna si'iba bedúna lebie kumu de ruin tsitsi lastokani, labí ria lekani. Nianna tti ree benne biyúha: ―Belhí nálu. Benneha nna belhí tteba nábie nna beyaka tteba nuha. ");
INSERT INTO zae_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tti beria ka fariseo‑ni lhe'e yo'oha nna unne tteba lenkana ka nu tákana Herodes‑ni, kumu regila lekani gaxasina uinkana kini uttikana Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús‑ni nna beru'une deyye len ka benne rudhetinieha daka ro'o indatooha nna ixe juisiru ka benne ge Galilea‑ni danalhake bie. ");
INSERT INTO zae_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Anágaba ka benne daa itúba daka Judea‑ni lhe Jerusalén‑ni lhe ka benne daa daka Idumea lhe ka benne se'e attu ladu yoo Jordán‑ni lhe. Anágaba nna dágaba ka benne se'e abi'iba kwe'e yiesi Tiro lhe Sidón lhe. Ixe juisiru ka benneha, tti biyienkanie iyá nu runieha nna danalhake bie. ");
INSERT INTO zae_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","De nuha nna ra Jesús‑ni ka benne rudhetinieha udú tseke ttu barcu kini tsapie loni ki abittu ukí ya'a ka benne bie. ");
INSERT INTO zae_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kumu de ixe galá ka benne chi beyonie, de nuha nna iyába ka benne raka latike ttu bixa, xua‑niba iki luesike diake kwe'ebie kumu de raka leke sattanke latie. ");
INSERT INTO zae_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ka espíritu satsa yu'u lati ka benne, atti rilákin nuha Jesús‑ni nna ribesi'abakana rudú xibikani arloe, rákane: ―¡Lu ankalu Xi'in Tata Do Yebáha! ");
INSERT INTO zae_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ttaka labie nna bedhaka dise ka espíritu satsaha kini abittu kixxi'akana nuxa anke. ");
INSERT INTO zae_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iki de nuha nna ugwapi Jesús‑ni iki i'iyaha, nianna uxie ka benne uka lebie gaxie. Ka benneha nna ubigake kwe'ebie. ");
INSERT INTO zae_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nianna tti bekwebie tsi'inuke (12) kini tseki lenke bie lhe kini idhelhe ke tsiake kixxi'ake ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Anágaba nna begwegabe ka benneha lo neda ki eyoinke ka benne rani lhe ki ebeake ka espíritu xxegwi yu'u lati ka benneha lhe. ");
INSERT INTO zae_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nii dia lá tsi'inu (12) ka benne bekweeha, delába, Simón benne utixxagabe lábie Pedro, ");
INSERT INTO zae_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","lhe Jacobo‑ni lenie betsie Juan‑ni. Ka benne‑ni ankake xi'in Zebedeo. Lagabake nuha utixxe láke Boanerges. (“Boanerges” dienna innána ka nu ru'u be idisa.) ");
INSERT INTO zae_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Bekwegabe Andrés, lhe Felipe, lhe Bartolomé, lhe Mateo, lhe Tomás, lhe Jacobo xi'in Alfeo, lhe anágaba Tadeo, lhe Simón benne rágabakana Zelote, ");
INSERT INTO zae_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","lhe bekwegabe Judas Iscariote nu betene lasi ná ka nu bettikaneha. ");
INSERT INTO zae_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iki de nuha nna beyeki Jesús‑ni besine lhe'e yo'oha, nianna bedetupa tteba ixeru ka benne. Laxkala niba yetta laa uka go lenie ka benne chi bekwebieha. ");
INSERT INTO zae_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tti bina ka benne raka luesieha ge nu runieha, nianna ugíake kini saxíke bie kumu ráke rakaba ikie. ");
INSERT INTO zae_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ttaka ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni, delába ka nu daa Jerusalén‑ni, ka nuha nna rákana deki Beelzebú nu anka xxana ka espíritu xxegwiha‑ba yu'u lati Jesús‑ni, laxkala Beelzebú‑niba rixuin Jesús‑ni kini rebeabie ka espíritu xxegwi yu'u lati ka benne. ");
INSERT INTO zae_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nianna tti uxi Jesús‑ni ka nu rinne aníha nna utixxi'anie kana ttu tisa. Aníha benie kini utte dákana bí diani nu raka lebie kixxi'anie kana, nianna tti ree: ―Laa gwakaga ge nu xxegwiha ebeana ka luesi xxegwi‑niha. ");
INSERT INTO zae_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ttibanka ganna ttixka lhe'e ttu yiesi se'e la'a ka benne geni de ritilha len luesike, la'ania nna labíru uchía yiesiha lo nu ratenaha ");
INSERT INTO zae_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","lhe ganna ttixka ka benne se'e lhe'e ttu yo'o se'e la'ake de ritilha len luesike, la'ania nna labíru aka tse'e ka benneha tutupa. ");
INSERT INTO zae_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Anágaba nu xxegwiha, ganna itilha lenna ka luesi xxegwi‑niha, la'ania nna labíru aka dhona tutupa len ka nuha. Ganna aníha uinna, la'ania nna chiba bisia sá ge nuha lhuxana. ");
INSERT INTO zae_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Anágaba lhe lanú nu aka geni ga'ana lhe'e yo'o ge ttu nubiyú ankana tipa kini lhanana nu se'e lhe'e yo'o ge nuha, ganna ttixka abíba udaxxuna nubiyú anka tipaha lade'a tte nna uxxikana nuha. Kumu gannaliba chi xikinna nubiyúha, la'anialiba nna gwaka geni lhanana nu se'e lhe'e lisi nuha. ");
INSERT INTO zae_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Netiru ria: gwadíba Tata Do Yebáha elha xen lasi ge iyába nu satsa uni ka benne lhe ge iyába nu satsa inneke lhe, ");
INSERT INTO zae_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ttaka ganna ttu benne inne satse ge Espíritu ge Tata Do Yebáha, benneha ttu tsala labí ixú elha xen lasi gebie, sinuki ttu dia liiba uja benneha yua ge nu inneeha. ");
INSERT INTO zae_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Aníha ra Jesús‑ni kumu ka nu rule'ekinna ka benne nu ra lo bia bennabiha rálakana deki espíritu satsaba yu'u latie. ");
INSERT INTO zae_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nianna tti bisin nan ge Jesús‑ni lhe ka betsieha ro'o yo'o ata do Jesús‑ni rule'enie ka benne. Ro'o yo'oha‑liba use'e ka nan geeha nna udhelhake kini belisakana Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ka benne se'e abi'iba kwe'eeha nna unneke, ráke bie: ―Ne nan geluha lhe ka betsiluha lhe ka danluha lhe, se'eke ro'o yo'o‑ni regilake lu. ");
INSERT INTO zae_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Lee nna bekabie ree: ―¿Nú rale deki anka nan kia lhe betsia lhe? ");
INSERT INTO zae_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nianna tti belannie lo ka benne se'e abi'iba kwe'eeha nna tti ree: ―Gwaluyúruga, ka benne se'e‑nila nuní ankake nan kia lhe betsia lhe. ");
INSERT INTO zae_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kumu nuxaba benne ganna runie nu ru'u le Tata Do Yebáha, benneha nuha anke betsia lhe danaa lhe nan kia lhe. ");
INSERT INTO zae_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús‑ni bededuloe attu libe rodole'enie ka benne ka tisa ge Tata Do Yebáha ro'o indatooha nna ixe juisiru ka benne bedetupake abi'iba kwe'ebie. Laxkala teeki ugwapie lo ttu barcu daa lo indaha nna udoe lhe'e nuha. Ka benne tupaha nna ro'o indaha‑liba se'eke rudo nagake gebie. ");
INSERT INTO zae_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ixeba nu rigixxi'anie ke. Aníha benie ki utte dáke bí diani nu raka lebie kixxi'anie keha, nianna tti ree ke: ");
INSERT INTO zae_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―¡Gwaludoruga nagale! Ttu nubiyú ruin sina biriana diana gwedelha xuxtila. ");
INSERT INTO zae_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tti dana gwedelha xuaha nna adí benneha utse ro'o nedaha, nianna tti biginni ka binniha, nna bediga ttebakana benneha. ");
INSERT INTO zae_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Attu chupe nna utse lo íyya atta'a ata labí gwadilo yu do. Benneha nna gwa be'eyu ttebe kumu de labí rea xua yuha niha. ");
INSERT INTO zae_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ttaka tti biria tatubisaha nna bettebe benneha kumu de labí lhi'u dia lhue, de nuha nna ubisi tteba benneha. ");
INSERT INTO zae_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Attu chupe nna utse lhe'e yietsiha, ttaka yietsiha biyelhabana nna belhiubinna benneha. Laxkala labí xua bete benneha. ");
INSERT INTO zae_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ttaka adí benneha nna gwa ubinnibe ata do yu tse. Benneha nna yalhá lhe'e be'eyue lhe biyelhe lhe. Laxkala tseba betebie lena. De rerua (30) lhe de gayuna (60) lhe de gayua (100) tteba xua bekudhi iki ttu ttu ka xuxtilaha. ");
INSERT INTO zae_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nianna tti ra Jesús‑ni ke: ―¡Ata sia nagale, gwaludo nagale ganna gwankale nu dika iyienini! ");
INSERT INTO zae_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Atti chi beya'an Jesús‑ni sun ttúbe lenie ka benne tsi'inu rudhetinieha (12) lhe attu chupa ka benne se'e gaxxaba ata dueha lhe, nianna tti unnaba tisake bie, ráke bie: ―¿Bí diani nu ralu tti utixxi'alu ge benne dia gwedelha xuxtilaha? ");
INSERT INTO zae_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Labie nna ree ke: ―Lebi'iligaba nna gwagixxi'abin Tata Do Yebáha le nu labí chi yu adí ka benne, delába gwa ruinba Tata Do Yebáha kini tte denle gasina innabie ka benne. Ttaka ka benne abittu chi rinnabie, neti bixxi kwe'eba rinnea tti rigixxi'ania ke nuní, ");
INSERT INTO zae_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kini meskiba gwa rulannike nna labí ilákanie, lhe meskiba gwa rudo nagake nna labí tte dákanie; aníha kini ka eyekike nna odaxxuke neda ge Tata Do Yebáha, lee nna dhie elha xen lasi geke. ");
INSERT INTO zae_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nianna tti ree ka benneha: ―¿Si lagwa gwa rite denle bí diani nu utixxi'aya ge benne dia gwedelha xuxtilaha? ¿Galasina tte denle adíru ka nu kixxi'ania le ganna? ");
INSERT INTO zae_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Benne rudelha xuxtilaha anke benne rigixxi'e ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ka xua utsa kwe'e nedaha nna ankake ka benne biyienkanie ka tisaha. Ttaka daa tteba nu xxegwiha nna rebea ttebana ka tisaha lhe'e lastoke; delába ruinna kini rexulhakanie ka tisa chi biyienkanieha. ");
INSERT INTO zae_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Adíke nna ankake ttiba ka xua utsa lo íyya atta'aha. Tti biyienkanie ka tisaha nna ittaba bedúna leke nna bedaxxu ttebake ka tisaha. ");
INSERT INTO zae_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ttaka kumu de labí chi begwe lhu ka tisaha lhe'e lastoke, de nuha nna sattiruba ria leke ge Tata Do Yebáha, nna atti chi rateke ttu bixa elha disa o lhe atti chi ridú nookana ke de ria leke ka tisaha, la'ania nna reyadi gaa ttebake. ");
INSERT INTO zae_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Alhe ka benneha nna ankake attiba ka xua utsa lhe'e yietsiha. Gwa riyienbakanie ka tisaha, ");
INSERT INTO zae_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ttaka ka elhaxchacha iki geke tee yiesi lo yu‑ni lhe de rudo xxattana leke gatta geke, lhe anágaba lhe de ru'u xxatta leke ge adíru nu tee yiesi lo yu‑ni, nuha‑la rudoruna leke ruinke, de nuha nna richúbana lo ka tisaha. La'ania nna labí ruin ka tisaha sina lhe'e lastoke kini uin tseke. ");
INSERT INTO zae_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Adíke nna ankake attiba ka xua ubinni lo yu tseha. Ka benneha nuha riyienkanie ka tisaha nna bedaxxuke ka tisaha. Laxkala gwa ruinba ka tisaha sina lhe'e lastoke. Ka benneha nuha ankake attiba ka xuxtila bete de rerua (30) lhe de gayuna (60) lhe de gayua (100) lhe. ");
INSERT INTO zae_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Rágaba Jesús‑ni kana: ―Ttu gi rudenna ki ilenri'i, laa taxxígari'i nuha kini uttudhiri'i ttu almoti ikini o ukatsiri'i na xan ata rattari'iha. ¿Laaba ganna teeki udori'i nuha gwetsá ki udenna geri'i? ");
INSERT INTO zae_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Anágaba labí ttu bixa tee gatsi nu abittu ilenri'i lhe labí ttu bixa raka sigá abittu iriana la loo. ");
INSERT INTO zae_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","¡Ata sia nagale, gwaludo nagale ganna gwankale nu dika iyienini! ");
INSERT INTO zae_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Lhe rágabe kana: ―Gwaludo tsitsi nagale gasina rutte dale nu rinnea‑ni, kumu ttu luesi nu rurixxibiale rugwele ka benne, ttu luesi nuha‑gaba orixxibia Tata Do Yebáha otebie gele. Benneha nna adírula xxeni otebie gele. ");
INSERT INTO zae_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kumu nu gwa tee geniha, gwadí chiettirula nuha nna nu abittu tee geniha nna axtala nu ttu latti chi tee geniha etua. ");
INSERT INTO zae_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús‑ni rágabe: ―Tata Do Yebáha atti rinnabie ka benne, elha rinnabia geeha raxxína na len nu ruin ttu benne dia gwedelha xuxtila. ");
INSERT INTO zae_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Benneha rattabe ra'adhie rela nna rani nna radhabe. Xua bedelheha nna rela resába dia benneha re'eyue lhe riyelhe lhe. Benne bedelha xuaha nna labí yue gasina raka, ");
INSERT INTO zae_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","kumu titúba yuha re'eyu lena loni. Lade'axa riria lhaga to ge xuaha, nianna tti ribea ikie. Iki deliba nuha nna tti chi ru'u lhe'ebie. ");
INSERT INTO zae_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ganna chi bigatsi xuxtilaha, la'ania nna udaxxu tteba iyyarsela ge benne bedelha xuxtilaha kini egitse benneha kumu chiba bisia sá exú benneha. Aníha‑ba raka atti rinnabia Tata Do Yebáha ka benne. ");
INSERT INTO zae_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús‑ni rágabe: ―¿Gasina rule'e tti rinnabia Tata Do Yebáha ka benne? ¿Bí nuha rula'a tti rula'a elha rinnabia geeha? ");
INSERT INTO zae_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tata Do Yebáha atti rinnabie ka benne, elha rinnabia geeha ankana ttiba ttu besi ge kuana muxtasa riyada lo yu. Besiha‑la nuha ankana nuxka'a toru delo iyá ka besi re'eyu yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ttaka iki de chi riyada besiha nna gwa re'eyubana. Nianna rixenba kuanaha nna xxenirula rakana attichula adí ka kuana ya'a. Xxeniba raka ka náni, laxkala axtaba ka binni‑na ratsiakana xula geni. ");
INSERT INTO zae_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ixeba luesi ka tisa‑ni bixúni Jesús‑ni ki unnebie. Aníha benie kini tte dani ka benne nu raka lebie kixxi'anie ke. Utixxi'abanie ke nu dika dhaake tte dákanie. ");
INSERT INTO zae_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Labí lhixxa rá utixxi'anie ke sinuki utixxi'abe nu raxxíbana len nu raka lebie ule'enie ke. Ttaka ka benne rudhetinieha, tti due sun len ka benneha‑ba nna gwa rigixxi'abanie ke bí diani iyá tte nu reeha. ");
INSERT INTO zae_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","La sáha‑gaba nuha, atti chi dia ralhaha, nianna ra Jesús‑ni ka benne rudhetinieha: ―Eteri'i lo indatoo‑ni kini eriari'i ro'oni daka nu reha. ");
INSERT INTO zae_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Niha‑ba boka'anke ka benne ixe danalhaha nna aníha‑ba dedo Jesús‑ni lo barcuha, dechekane. Danalhagaba adíru ka barcu. ");
INSERT INTO zae_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ttaka ttiruba ttu nnelaba bisia ttu be idí nna bedhú liina lo indatooha nna uta'ana lhe'e barcuha. Laxkala chi tteba ruin nuha xxudina lhi'u lhe'e indaha. ");
INSERT INTO zae_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ttaka Jesús‑ni nna tebe te'adhie daka xan barcuha kuni ikie ttu lari. Ka benne rudhetinieha nna bodibenke bie, ráke bie: ―¡Maestru! ¿Si bi gwa retabinlu ka tsapiri'i inda‑ni nna gattiri'i? ");
INSERT INTO zae_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nianna tti ugwadhe bedhaka dise beha nna ree indatooha: ―¡Siiba beyaka! La'ania nna udú sii tteba beha nna tsaba bebe sii lo indaha. ");
INSERT INTO zae_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nianna tti ra Jesús‑ni ke: ―¿Beaka rasinle? ¿Beaka a ruxxen lele kia? ");
INSERT INTO zae_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ttaka lake yalhá usikanie, nianna tti ra luesike: ―¿Nú anka benne‑ni nna axtaba be‑na lhe indatoo‑na lhe rudokana tisa gebie? ");
INSERT INTO zae_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Beteba Jesús‑ni lenie ka benne rudhetinieha lo indatooha nna bisinke daka lo yu ge ka benne Gadara. ");
INSERT INTO zae_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tti ugwadie lo barcuha nna biria tteba ttu nubiyú yu'u ttu espíritu satsa latini, biriana ata se'e ka baa ge ka benne yattiha, nianna tti betetsána Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Lhe'e ka baaha‑ba reya'an nubiyúha. Nurula ridaana uxxikana na, niruba len cadena. ");
INSERT INTO zae_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ixe lidú chi bexxikake ka ni'a náni len cadena, ttaka richú ttebana ka cadenaha nna niruba ttu benne a ridee loni. ");
INSERT INTO zae_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Rela resába rekina iki ka i'iyaha lhe lagwi ge ka baaha ribesi'ana lhe ruingaba gwe latini len ka íyya lhe. ");
INSERT INTO zae_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Idittuli daa Jesús‑ni bilenne, nianna biresu ttebana gwatsáne nna bedú xibini arloe. ");
INSERT INTO zae_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nianna tti unnena idisa, rane: ―¡Bittu etega'a gelu len neti, Jesús Xi'in Tata Do Yebaa benne ra xxeni leeha! ¡Rinnabaa lenlu, benchi lo ni'a ge Tata Do Yebáha bittu ugwelu neti elha disa! ");
INSERT INTO zae_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Aníha rana kumu Jesús‑ni chi unnebie, ree: ―¡Espíritu satsa, beria lati nubiyú‑ni! ");
INSERT INTO zae_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nianna tti unnaba tise na nna ree na: ―¿Bí lálu? Lana nna bekabina, rana: ―Legión‑ba lá neti, kumu ixe ri'itu raka. ");
INSERT INTO zae_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nianna unnaba ditiba nubiyúha len Jesús‑ni kini abittu ebeabie ka espíritu satsaha latini nna odelhe kana attu ta subi. ");
INSERT INTO zae_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Gaxxaba kwe'e i'iya do niha yu'u ixeru ka kuchi, yu'ukana go. ");
INSERT INTO zae_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Laxkala ka espíritu satsaha nna unnaba ditibakana lenie, rákane: ―Bedhelha ri'itu ata yu'u ka kuchi‑na, kini eta'atu latikani. ");
INSERT INTO zae_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús‑ni nna gwa begwelhabe kana. Nianna beria tteba ka espíritu satsaha lati nubiyúha nna gwata'akana lati ka kuchiha. Ttiba ttu chupa mili ka kuchiha raka. Ka nuha nna biria resu ttebakana gwatsettikana ro'o ttu íyya daa niha nna biginnikana lhe'e indatooha nna ugwapikana inda. ");
INSERT INTO zae_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ka nu se'e gweyú ka kuchiha nna boxunni ttebakana deyyakana gwattixxi'akana nuha lhe'esiha lhe utixxi'akinna ka benne se'e lhe'exxi itúba ka niha. Ka benneha nna biria ttebake gwalannike bixa nuha chi uka. ");
INSERT INTO zae_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tti bisinke ata du Jesús‑ni nna bilákanie nubiyú beria ka espíritu xxegwiha latini, tseba chi bedo ikini lhe chiba nuku xoni dona. Nianna yalhá usikanie. ");
INSERT INTO zae_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ka benne bilákanie nu gwate nubiyú uyu'u espíritu xxegwi latiniha lhe nu gwate ka kuchiha lhe, ka benneha nna utixxi'agabakanie adí ka benne. ");
INSERT INTO zae_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nianna tti unnaba ditibake len Jesús‑ni kini eriabie lo yu gekeha nna eyye attu ta subi. ");
INSERT INTO zae_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Atti beyapi Jesús‑ni lo barcuha nna nubiyú beria espíritu xxegwiha latini nna unnaba ditibana lenie kini ugwelhe na sanalhane. ");
INSERT INTO zae_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ttaka lee nna labí uka lebie nna ralee na: ―Beyya lisiluha ata se'e ka benne geluha, nna utixxi'a kanie iyá nu chi ben Tata Xisiha lenlu lhe utixxi'a kanie gasina gwatua lebie lu. ");
INSERT INTO zae_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nubiyúha nna bedá ttebana deyyana. Nianna udulo ttebana utixxi'ana itúba daka Decápolis ge iyá nu chi ben Jesús‑ni lenna, nna iyába ka benne binake nuha nna bebanabakanie. ");
INSERT INTO zae_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iki de chi beyapi Jesús‑ni lo barcuha nna betebie lo indatooha, besine ro'oni daka nu reha. Nianna bedetupa tteba ixe juisiru ka benne kwe'ebie. Labie nna ro'o indaha‑liba udúe. ");
INSERT INTO zae_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nianna tti bisin ttu ka nu baninna yo'o ata rudheti ka benne Israel‑ni ka tisa ge Tata Do Yebáha. Nubiyúha lána Jairo. Tti bilenna Jesús‑ni due niha, nianna biyachuna nna bedú xibini arloe, ");
INSERT INTO zae_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nna unnaba ditibana lenie, rane: ―Nuila to kiaha chi tteba gatti bi'iniha. Uyáchi nna ixxua nálu ikibi kini eyakabi nna abittu gattibi. ");
INSERT INTO zae_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nianna udá tteba Jesús‑ni die lenna. Ixe juisiru ka benne danalhake bie nna rukí ya'anibake bie. ");
INSERT INTO zae_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lagwi ge ka benne danalhaha sela ttu benne nuila chi anka tsi'inu (12) ida ridobie reni. ");
INSERT INTO zae_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yalhá chi gwatebie ugíe lo ixeba ka nu runi ramedi nna chiba beyá iyába nu tee gebie betse'e loobie. Ttaka labí reyake; rutse'e loo nna adíla diana rudialhana gebie. ");
INSERT INTO zae_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tti bine ge Jesús‑ni, nianna diabie sele lagwi ge ka benne danalhaha, nianna tti ubige daka kwe'e Jesús‑ni gwattáne ro'o lari nuku benneha, ");
INSERT INTO zae_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","kumu rakanie: “Kwadiba ro'o xoe sattánaa nna gweyakabaa.” ");
INSERT INTO zae_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Laxkala atti gwattáne ro'o xo Jesús‑ni nna loora tteba udú sii reni ridoeha, nianna ute danie deki chiba beyake. ");
INSERT INTO zae_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús‑ni nna tti ute danie deki nu tsitsi ra leeha chi beyoinna ttu benne, nianna tti bodeki loe rulannie lo ka benne danalhaha nna ree ka benneha: ―¿Núnni chi betettanna ro'o xoa‑ni? ");
INSERT INTO zae_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ka benne rudhetinieha nna ráke bie: ―Sa ralu, ¿núnni betettanna ro'o xoa? Ki gwa yu xeabalu aníli rukí ya'a ka benne ri'i. ");
INSERT INTO zae_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ttaka Jesús‑ni nna rulannibe abi'iba kwe'ebie kini ilánie nuxa nuha gwattána na ro'o xoeha. ");
INSERT INTO zae_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Benne nuilaha nna kumu yube nu chi ukaha, aníha uka nna itú rasibanie lhe itú rixidibe ubige nna bedú xibie arlo Jesús‑ni, nianna tti utixxi'anie bie iyá tte. ");
INSERT INTO zae_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Labie nna ree benne nuilaha: ―Xi'ini to, de ugía lelu deki gwadaabaa eyonia lu, de nuha nna gwa beyakabalu. Nnanna nna xen su lasi beyya. Chiba betúa nu ridakalu‑na. ");
INSERT INTO zae_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sa dula Jesús‑ni rinnebie, ttiru chi bisia ka nu daa lisi Jairo‑ni, rákana Jairo‑ni: ―Chiba utti xi'iniunnáluha. Bitturu udo doelhalu maestru‑ni ki dhabie. ");
INSERT INTO zae_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ttaka Jesús‑ni labí bedo nage ge nu ra ka nuha, nianna ree Jairo‑ni: ―Bittu gasinlu; sun tteba ugía lelu. ");
INSERT INTO zae_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nianna udá ttebe die nna lanúru nu begwelhe tsia lenie. Sunruba Pedro‑ni lhe Jacobo‑ni lhe Juan betsi Jacobo‑ni chebie. ");
INSERT INTO zae_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tti bisinke ro'o yo'o ge Jairo‑ni, nianna bilánie chi risatsa ka benne lhe bilánie ka benne ribesike lhe relen xxattakanie lhe. ");
INSERT INTO zae_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Atti chi ute'e lhe'e yo'oha nna ree ka benneha: ―¿Beaka análi ruinle lhe beaka ribesi xxattale lhe? Nuila to‑ni labí utti bi'in‑ni, te'adhiba bi'in‑ni. ");
INSERT INTO zae_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ttaka ka benne se'e niha, nna ruxisilake gebie. Lee nna nu benlee nna bebealee iyábake, nianna tti ute'e ata tee nuila toha. Ute'e len ka tata nan gebiha lhe len a tsunna ka benne cheeha lhe. ");
INSERT INTO zae_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nianna tti bedaxxue ná nuila toha nna unnebie, ree: ―Talita kumi. ―Talita kumi dienna innána: Nuila to, neti rulisaa lu, beyadha. ");
INSERT INTO zae_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Looraha tteba beyadha nuila toha nna bedá ttebabi, kumu chiba ankinbi tsi'inu (12) ida. Ka benne se'e niha nna uka tébakanie lhe yalhá bebanakanie lhe. ");
INSERT INTO zae_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ttaka Jesús‑ni nna bodha'an tsitsibe ree ke anuttu nu kixxi'akanie ge nu chi ukaha lhe rágabe ke: ―Gwalugo nuila to‑ni yetta. ");
INSERT INTO zae_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Bedába Jesús‑ni ata dueha nna deyye lhe'esi Nazaret ata uka lasieha nna deyyagaba ka benne rudhetinieha lenie. ");
INSERT INTO zae_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tti bisia sá tti reyaka le ka benne Israel‑ni, nianna uta'a Jesús‑ni lhe'e yo'o ata rudhetike ka tisa ge Tata Do Yebáha nna uduloe rule'enie ka benne. Ixeba ka benne se'e rudo nagake gebie nna bebanabakanie, nianna ra luesike: ―¿Gá gwaxxí nuní nu raka gen‑ni? Lhe, ¿bí elha rieni nuní rapa nuní? Lhe anágaba lhe, ¿gá gwaxxína ka milagru ruinna‑ni? ");
INSERT INTO zae_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Laaba nuníba nuha nu ruin ka mexaha lhe ka xxilaha lhe? Lana ankana xi'in biyú María‑ni, lhe anágaba lhe rakana betsi Jacobo‑ni lhe José‑ni lhe Judas‑ni lhe Simón‑ni lhe. Anágaba lhe, ¿laaba lhe'esi geri'i‑nigaba se'e ka danniha lhe? De nuha nna bituxxukinna gebie. ");
INSERT INTO zae_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nianna ra Jesús‑ni kana: ―Ttu benne anke profeta, gaxaba diabie gwa rugwebakana lidhake. Ttaka ka nu lhe'esi geeha lhe ka nu raka luesieha, lhe anágaba ka nu se'e lhe'e yo'o geeha lhe, labí rugwekana lidhaka benneha. ");
INSERT INTO zae_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","De nuha nna labí uka uni Jesús‑ni ni ttu milagru lhe'esi geeha, sunruba ttu chupa ka benne rani uxxua nábie ikike nna beyonie ke. ");
INSERT INTO zae_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Lee nna bebanabanie gekani kumu de labí ria lekani gebie. Iki de nuha nna tti ugwekie lhe'e iyába ka yiesi se'e abi'iba niha bele'enie ka benne. ");
INSERT INTO zae_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús‑ni bottupe ka benne tsi'inu (12) rudhetinieha nna udhelhe chupa chupa ka benneha. Begwebie ke lo neda ki ebeake ka espíritu satsa yu'u lati ka benne. ");
INSERT INTO zae_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nianna rabie ke: ―Bittu ichele nu ixuinle neda. Suna garroti gebale ichele. Nigaba bittu uja chuba gele lhe nigaba bittu ujale nu gole lhe anágaba bittugaba iche yieti belhiu gele. ");
INSERT INTO zae_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Suna gwaracha gebale gwalulea lhe bittugaba ichele chupa kwe xole lhe. ");
INSERT INTO zae_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Rágabe ke: ―Gaxaba lhe'e yo'o ata isinle, niha‑ba gwaltse'e. Axtaliba ganna chi eriale lhe'esiha, la'anialiba nna edále lhe'e yo'o ata bisinleha. ");
INSERT INTO zae_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ganna lhe'e ttu yiesi abittu ulabikana le lhe abittu udo nagakani ge nu kixxi'enle kana, la'ania nna gwaleria lhe'e yiesiha nna gwalukubi biste ni'ale, kini nuha unna liina deki Tata Do Yebáha labí uyu'u lee nu benkana. Netiru ria, ganna chi bisia sá uin Tata Do Yebáha elhuxtisi ge ka benne se'e yiesi lo yu‑ni, la'ania labí ttela elha disa tsitsi uyú ka benne ge Sodoma lhe ka benne ge Gomorra lhe, attichula elha disa uyú ka nu abittu ulabikana leha. ");
INSERT INTO zae_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ka benne rudhetinieha nna biriabake diake nna rigixxi'akanie ka benne ráke ke deki teeki odúna ke nna odaxxuke neda ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Lhe anágaba lhe bebeagabake ixe ka espíritu xxegwi yu'u lati ka benne lhe rigabigabake seti lati ka benne rani nna gwa reyakabake. ");
INSERT INTO zae_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herodes nu rinnabiaha binana ge Jesús‑ni kumu lhe'e iyába ka yiesi chi ugwadhi tisa ge nu runieha. Ttu chupa ka benne ráke: ―Juan benne rugadi indaha‑ba nuná chi beyaka benbie lagwi ge ka benne chi uttiha. De nuha nna ridaabie runie ka milagru. ");
INSERT INTO zae_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Adíkana nna rákana: ―Elías‑niba nuná. Adíkana nna redenákana: ―Ttu ka profeta use'e itú nu reha‑ba nuná. ");
INSERT INTO zae_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tti biyienin Herodes‑ni nu ra ka benneha, nianna tti rana: ―Juan nu begadi indaha‑ba nuná, delába nu udhelhaa kini uchúkana ikiniha. Labana nuná chi beyaka benna lagwi ge ka benne chi uttiha. ");
INSERT INTO zae_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kumu kwinaba Herodes‑ni udhelhana gwadaxxukana Juan‑ni nna bexxikakana na lhe'e lisiyyaha. Aníha benna de utisa Juan‑ni na delo ni'a ge de bedo lenna Herodías nu anka nuila ge betsini Felipe‑ni. Bituxxuin Herodes‑ni kumu de ra Juan‑ni na: “Labí ga'anna edo lenlu nuila ge betsilu‑na.” ");
INSERT INTO zae_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","De nuha nna bedo le nuilaha Juan‑ni nna benna uttina na, ttaka labí udaana, ");
INSERT INTO zae_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kumu Herodes‑ni usibinna Juan‑ni, kumu yúbana deki benneha anke ttu benne runie nu dika ixú lhe ankagabe ge Tata Do Yebáha lhe. De nuha nna biyú tsitsibana Juan‑ni nna atti rudo nagani ge benneha, nna gwa ru'uba leni ge nu rigixxi'anie naha, meskiba tti riyieninna nu rinneeha nna rudú chupana leni. ");
INSERT INTO zae_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ttaka tti bisia sá gwadoni Herodes‑ni ida, la'ania nna uxina adíru ka nu yala rise'e kwe'eniha lhe ka nu loni ge ka soldaduha lhe anágaba ka nu ra xxeni lekani se'e Galilea‑ni lhe, kini i'iya gokana lenna. La'ania nna Herodías‑ni, delába nuila ge Herodes‑ni, upana lo neda benna nu rulaba leniha. ");
INSERT INTO zae_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tti lo se'e ka Herodes‑ni ro'o mexaha, la'ania nna uta'a xi'iniunná Herodías‑ni ata se'ekanaha nna udulona ruya'ana. Herodes‑ni nna uyu'uba leni lhe ka nu se'e lenna ro'o mexaha lhe. Nianna tti rana nuila kwitiha: ―Unnababa bixaba raka lelu, neti nna gutebaa nuha gelu. ");
INSERT INTO zae_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nianna tti bodha'an tsitsi tisa geni len nuilaha, rana nuha: ―Bixaba raka lelu innabalu nna gutebaa na gelu. Meskiba salhe ka lo yu ata rinnabiaya‑ni utea gelu. ");
INSERT INTO zae_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nuilaha nna beria ttebana deyyana nna rana nan geniha: ―¿Bíla innabaa ganna? Nan geniha nna rabie na: ―Bega iki Juan nu rugadi indaha unnaba. ");
INSERT INTO zae_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nianna rigába nuila kwitiha beta'ana ata re Herodes nu rinnabiaha, nianna tti rana na: ―Looraha tte nnanna raka lasia taxxílu bega iki Juan nu rugadi indaha nna ku'ulu na lhe'e ttu ye'ena nna utelu na len neti. ");
INSERT INTO zae_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Meskiba bedú si'i xxattana le Herodes‑ni, ttaka de chi bodha'an tsitsi tisa geni len nuilaha lhe de chi biyienin ka nu se'e lennaha lhe, aníoka nna labí uka dhu disana utena nu rinnaba nuilaha. ");
INSERT INTO zae_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nianna tti udhelha ttebana ttu soldadu kini tsia nuha taxxína bega iki Juan‑ni. ");
INSERT INTO zae_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Soldaduha nna ugía ttebana gwachúna bega iki Juan‑ni lhe'e lisiyyaha. Nianna tti begu'una bega iki benneha lhe'e ttu ye'ena nna bogwena nuila kwitiha. Nuila kwitiha nna botena nuha len nan geniha. ");
INSERT INTO zae_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Atti chi bina ka benne rudhetini Juan‑ni nu chi ukaha, nianna ugía ttebake gwaxíke benne yattiha nna bekatsike benneha. ");
INSERT INTO zae_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Atti besin ka apóstol‑ni ugíake gwattixxi'akanie ka benne ka tisa ge Tata Do Yebáha, nianna betupa ttebake len Jesús‑ni nna utixxi'akanie bie ge iyá nu benke lhe iyá nu bele'ekanie ka benneha lhe. ");
INSERT INTO zae_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús‑ni nna ree ke: ―Sun lebi'iba gwaltá tsiari'i ata anuttu benne se'e kini eyaka lele latti. Aníha ree ke kumu ata se'ekeha ixeba benne risia lhe redá lhe, laxkala niba neda a rapake goke. ");
INSERT INTO zae_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aníha uka nna bedaxxuke barcu nna sun labake diake ata lanú benne se'e. ");
INSERT INTO zae_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ttaka ixeba ka nu bilákinna ke diake nna beyoinbiabakana ke. Nianna biria ttebakana lhe'e iyába ka yiesi se'e niha, nna ni'abakani diakana bisinkana ata isinkeha. Laxkala chila se'ekana niha atti bisinke. ");
INSERT INTO zae_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tti ugwadi Jesús‑ni lo barcuha nna bilánie chi re xxatta benne niha. Nianna gwatua lebie ke kumu se'ebake attiba ka neru to anú tee tsekina lokani. Nianna tti uduloe ixeba nu bele'enie ke. ");
INSERT INTO zae_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ttaka chi galá dia ubisa‑na nuha, nianna tti ubiga ka benne rudhetinieha nna ráke bie: ―Ttiruba chi dia ura nuní lhe gwea nna ata se'eri'i‑ni yu bisiba nuní, labí bixa tee nii. ");
INSERT INTO zae_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bedhelhala ka benne‑ni kini eyyake ata sia ka yo'o lhe'exxi o si lhe'e ka yiesi to se'e abi'iba ata se'eri'i‑ni kini tayo'oke nu goke. ");
INSERT INTO zae_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ttaka labie nna bekabilee, ree ka benneha: ―Lebi'iba gwalugwe ka benne‑ni nu goke. Ka benne rudhetinieha nna bekabike, ráke: ―¿Gasina tayo'otu nu go ka benne‑ni? Ixeni belhiu iyasinri'i; ge chupa gayua (200) sá sina teeba nuha ise'e loo kini iyo'o nu go ka benne‑ni. ");
INSERT INTO zae_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús‑ni nna ree ke: ―¿Balha yettaxtila chele? Gwatayúchu. Atti chi gwalannikeha nna ráke bie: ―Ne gayuruba yettaxtila nna a chupa ka belha nna. ");
INSERT INTO zae_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesús‑ni nna ree ke: ―Gwalose'e ka benne‑ni dhi dhi lo ixxi binni ya'a‑ni. ");
INSERT INTO zae_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nianna dhi dhiba bese'e ka benneha, benne bese'eba de gayua (100) lhe benne bese'eba de tsieyona (50) lhe. ");
INSERT INTO zae_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nianna tti bedaxxu Jesús‑ni gayu ka yettaxtilaha lhe a chupa ka belhaha nna tti belhidha loe yebáha nna begwebie Tata Do Yebáha ixkixaru. Nianna tti ulhe'e lhe'e ka benneha nna begwebie ka benne rudhetinieha, kini ka benneha nna utidhike benneha len ka benne se'e niha. Aníha‑gaba benie len chupa ka belhaha, ulhe'e lhe'e ka nuha nna begwebie iyá tteke. ");
INSERT INTO zae_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Iyábake utoke axtaba beyielakanie. ");
INSERT INTO zae_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Iki de chi utokeha nna bottuparulake a tsi'inu (12) sumi ka yettaxtila ro'o salha'a bexxaha lhe nu bexxa ge ka belhaha lhe. Besá tí ka sumiha. ");
INSERT INTO zae_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ttiba ttu gayu mili ka benne biyúha utoke. ");
INSERT INTO zae_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Iki de nuha nna ben Jesús‑ni kini beyapi ka benne rudhetinieha lo barcuha ki eneru gaake eyyake nna esinke ro'o indatooha daka nu reha, daka ata re lhe'esi Betsaida, laka lee nna richú tise ka benne se'e niha. ");
INSERT INTO zae_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tti chi beyaka uchú tise ka benneha, nianna tti ugwapie iki ttu i'iya do niha kini unne lenbie Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Atti chi ulhaha nna lagwi indatooha‑li chi deyya barcu ata deyya ka benne rudhetinieha. Jesús‑ni nna ttúbe beya'ane yu bisi. ");
INSERT INTO zae_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tti bilánie yalhá rate xxatta ka benne rudhetinieha ki rodháke barcuha, kumu daka arlo barcuha‑la retetsu'u beha, lee nna tti chi daa tsaniha, dedábie ata dedá ka benneha, redábie lo indaha, runie etebie loke. ");
INSERT INTO zae_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tti bilákanie bie dedábie lo indaha, nianna ukakanie ganna nu du elaba nuha. Nianna uresi'ake, ");
INSERT INTO zae_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kumu iyábake rilákanie nuha nna rasibakanie. Jesús‑ni nna unne ttebe, ree ke: ―¡Tsitsi gwalikweki lele! ¡Bittu gasinle! ¡Netiba nuní! ");
INSERT INTO zae_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Atti chi beyapie lo barcu ata dedákeha, nianna ure tteba beha. Lake nna uka tébakanie lhe bebana xxattakanie ge nu ukaha lhe, ");
INSERT INTO zae_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kumu lake ituaba a rite dákanie ge nu uka tti begobie ka benne yettaxtilaha, kumu sa yayaba ikike. ");
INSERT INTO zae_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Iki de chi beteke lo indatooha nna besinke lo yu ge Genesaret. Nianna begalhake barcuha ro'o indatooha. ");
INSERT INTO zae_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sun tteba ugwadike lo barcuha nna beyoinbia tteba ka benne se'e niha Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nianna ugweki tteba ka benne se'e niha lhe'e iyába ka yiesi se'e abi'iba niha kini raxxíke ka benne rani nna richeke ka benneha rixuakanie ke lo breta, risin lenke ka benneha ata runake du Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gaxaba dia Jesús‑ni, sila ritebie lhe'e ka yiesi xka'a to lhe sila ritebie lhe'e ka yiesi elha lhe, o sila ritebie ka lhe'exxi ata se'e ka benne lhe, ata ritebieha niha ruse'eke ka benne raniha ro'o ka neda nna rinnabake len Jesús‑ni, kini ugwelhe kwadiba ro'o lari nukueha udaxxu ka benneha kini eyakake. Aníha‑ba ruin ka benne raniha rudaxxuke ro'o xoeha nna reyaka ttebake. ");
INSERT INTO zae_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ka fariseo‑ni lhe attu chupa ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni, ka nuha dákana lhe'esi Jerusalén‑ni, nna ubigakana ata du Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tti bilákinna tsigaba anka ná ttu chupa ka benne rudhetini Jesús‑ni tti roke yetta; delába labí utí náke, labí benke ttiba labini ka benneola ge ka nu Israel‑ni ruinkana, de nuha nna riguakana bala'ana ge ka benneha. ");
INSERT INTO zae_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kumu ka fariseo‑ni lhe adíru ka nu Israel‑ni, sa ruinbakana ttiba ben ka benneola gekaniha. Ka benneola gekaniha labí kwenta go ka nuha yetta ganna abíba chi utí nákani, ");
INSERT INTO zae_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","lhe anágaba tti resinkana riakana ugo'o lhe'eyya, labí kwenta gokana yetta ganna abíba chi utí nákani. Ixerugaba nu labikinna ruinkana: ttibanka teeki kíkana ka kanti lhe ka xiga ka nu rixúkinna kini ri'iyakana lhe'ekani lhe anágaba adíru ka nu anka ge bronce ka nu rixúkinna ki riga'akana elho lhe'ekani. Lhe anágaba, aloba teeki kíkana ka nu rise'ekana loni tti rokana yetta. ");
INSERT INTO zae_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","De nuha nna ka fariseo‑ni lhe ka nu rule'ekinna ka benne nu ra lo bia bennabiha, unnaba tisakana Jesús‑ni, rákane: ―¿Beakala ka nu rudhetinlu‑na labí ruinkana nu bodha'an ka benneola geri'iha uinri'i? Ka nuná itupa tsigaba anka nákani rokana. ");
INSERT INTO zae_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Lee nna bekabie ree kana: ―Lebi'i xa fariseo, labí liinle. Delo tisaba ruinle deki ankale benne tse. Gwalíbani profeta Isaías‑ni tti unnena lo ka yetsi ge Tata Do Yebáha ge nu ruinle. Lo ka yetsi geeha rabie: Ka nuní len ro'oruba ka nuní rákana deki ria lekani neti, ttaka labí gwalíkinna rakakinna kia. ");
INSERT INTO zae_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kwentaruba rudú xibikani arloa, kumu nu anka ge benne se'e yiesi lo yu‑niba rule'ekana, labí nu anka kia nuná rule'ekinna ka benne. ");
INSERT INTO zae_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kumu lebi'i rudhanbale labíru ruinle nu bodha'an Tata Do Yebáha uinri'i, ge nu labin ka benne se'e yiesi lo yu‑nila rudoruna lele ruinle, delába rudorulana lele rigíle ka kanti lhe ka xiga ka nu ri'iyale lhe'ekinna, lhe anágaba nna ixerugaba ka luesi nuná labinle ruinle. ");
INSERT INTO zae_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Rágabe kana: ―¡Lebi'i, kattipa lhe'e ruinle! ¡Rigu'uba ni'ale nu bodha'an Tata Do Yebáha uinri'i nna rudorulana lele ruinle nu chi labinle ruinle! ");
INSERT INTO zae_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ki yule Moisés‑ni bodha'anna rana: “Tsia lele ka tata nan gele” lhe rágabana: “Nu rigena iki ka tata nan geniha, ralhaba nuha gattina.” ");
INSERT INTO zae_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ttaka lebi'i nna rálale: “Ttu benne gwakaba gebie gee ka tata nan geeha: Labí aka utea nu tee kia‑ni len lebi'i, kumu iyába nu dika utea len lebi'i, Tata Do Yebáha‑la chi ga'anati ugwea bie nuní.” ");
INSERT INTO zae_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Aníha ruinle kini benneha nna abitturu utee nu daa loe ugwebie ka tata nan geeha. ");
INSERT INTO zae_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Aná tte nuná nna rigu'u ni'ale ka tisa bodha'an Tata Do Yebáha delo ni'a ge nu rodha'an len luesile ruinle lhe anágaba nna ixeerugaba ka luesi nuní labinle ruinle. ");
INSERT INTO zae_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nianna tti bedeaxi Jesús‑ni ka benne saa niha attu libe nna redeabie ke: ―Gwaludo naga iyále kia nna gwalutte da nu innía‑ni. ");
INSERT INTO zae_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Labí nu rori'i rutsigana ri'i arlo Tata Do Yebáha, sinuki nu riria lhe'e lastolari'i nuná rutsigana ri'i arlo benneha. ");
INSERT INTO zae_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","¡Ata sia nagale, gwaludo nagale ganna gwankale nu dika iyienini! ");
INSERT INTO zae_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tti bedá Jesús‑ni ata se'e ka benne tupa niha, nianna besine lhe'e yo'oha. Ka benne rudhetinieha nna unnaba tisake bie bixa diani nu utixxi'anie keha. ");
INSERT INTO zae_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nianna ree ke: ―¿Si anágaba lebi'i, si abittugaba rite denle nu ria‑ni? ¿Si lagwa gwa rite denle deki iyába nu rori'i‑na laa nunága nuná rutsigana ri'i arlo Tata Do Yebáha? ");
INSERT INTO zae_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kumu laa lhe'e lastogari'i dia nu rori'i, lhe'e tu'ebari'i dia nuná, delola nna rebeabari'i nuná. Tti ra Jesús‑ni aníha, benna liie deki iyába nu rori'i ankana nari. ");
INSERT INTO zae_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Rágabe: ―Nu riria lhe'e lastolari'i nuná rutsigana ri'i arlo Tata Do Yebáha, ");
INSERT INTO zae_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","kumu lhe'e lastolari'i nuná riria nu satsa rulaba leri'i, lhe nágaba nuná riria nu ruinri'i ttixka rido lenri'i nu abittu anka latselari'i, lhe nágaba nuná riria nu ruinri'i tti risári'i nu subi subi, lhe anágaba lhe'e lastogabari'i riria nu rixegwiri'i ki ruinri'i elhutti, ");
INSERT INTO zae_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","lhe ruinri'i ubana lhe. Lhe anágaba lhe'e lastogabari'i nuná riria nu raka xxatta leri'i gatta geri'i, lhe nágaba nuná riria iyá nu abittu anka tse, lhe nágaba riria ka gwen lasi, lhe iyá nu satsa ridá leri'i ruinri'i, lhe anágaba, lhe'e lastogabari'i riria nu ritisin luesiri'i, lhe nágaba nuná riria nu rinne satsari'i ge ka benne, lhe nágaba nuná riria elha ttaba ruinri'i, lhe nágaba nuná riria nu ruinri'i tti a re itá ikiri'i. ");
INSERT INTO zae_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iyá nu satsa ruinri'i‑na, lhe'e lastobari'i raka xxe nuná. Iyá nuní ruinna kini rutsigana ri'i arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bedába Jesús‑ni ata dueha, nianna tti die daka Tiro lhe Sidón lhe. Tti chi bisine niha, nna ute'e lhe'e ttu yo'o. Labí uka lebie nuxa unana deki doe niha, ttaka labí uka dhoe gatsi, ");
INSERT INTO zae_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","kumu bina tteba ttu benne nuila do ttu xi'iniunne yu'u ttu espíritu satsa latini, bine deki do Jesús‑ni niha. Nianna ugía ttebe nna bedú xibie arlo Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Benne nuilaha nna unnaba ditibe len Jesús‑ni kini ebeabie espíritu satsa yu'u lati xi'iniunneha. Benne nuilaha labí anke nu Israel, sinuki benneha dabie daka Sirofenicia ");
INSERT INTO zae_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ttaka Jesús‑ni nna bekabie ge benneha, ree: ―Begwelhaxa eyielani ka xi'inia‑ni, delába ka benne Israel‑ni. Kumu labí anka tse udaxxua yettaxtila nu dika go ka xi'inia nna udelhaa na lo ka beku to‑na. ");
INSERT INTO zae_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Benne nuilaha nna bekabie ree: ―Gwalí galenlu, xa tata. Ttaka yulu axtala ka beku to‑na gwa redigagaba ka bia to‑na ka yettaxtila ro'o yuya riginni xani'a mexa ge ka nuto‑na. ");
INSERT INTO zae_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús‑ni nna ree benneha: ―Gwalíba nu ralu‑na. De bekabilu aná, de nuha nna xen su lasi beyya, kumu chiba beria espíritu xxegwiha lati xi'iniunnáluha. ");
INSERT INTO zae_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Atti besin benne nuilaha lisieha nna gwaxxake xi'iniunneha tena, chiba beria espíritu xxegwiha latini. ");
INSERT INTO zae_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tti beyeki Jesús‑ni beriabie Tiro, nianna deyye daka Sidón nna betebie daka Decápolis ki besine ro'o indatoo ge Galilea‑ni. ");
INSERT INTO zae_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nianna bisin lenkana ttu benne ata du Jesús‑ni. Benneha anke kwechu lhe labí rilí ro'e innee lhe. Nianna unnabakana len Jesús‑ni ki ixxua nábie iki benneha kini eyake. ");
INSERT INTO zae_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús‑ni nna bekwitta lenie benne biyúha ata se'e ka benne ixeha, nianna tti bega'a xubene lhe'e ka naga benneha. Nianna tti bettuttu xxenie lo xubene nna utane lo lhuse. ");
INSERT INTO zae_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nianna tti belhidha loe begíe gwetsáha nna benné lebie, nianna tti unnee, ree: ―¡Efata! ―Efata dienna innána: ¡Gwaleyali! ");
INSERT INTO zae_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Looraha tteba beyali ka naga benneha lhe bolhána lhuseha nna tseba unnebie. ");
INSERT INTO zae_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús‑ni nna ree ka benne se'e niha: ―Nuttu nu kixxi'enle ge nu chi uka‑ni. Ttaka meskiba bika ree ka benneha bittu kixxi'ake ge nu benieha, ttaka ka benneha nna adíla benke utixxi'abake. ");
INSERT INTO zae_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Iyábake bebana xxattakanie nna ráke: ―¡Tseba anka iyá nu runie! ¡Redhalie naga ka benne anka kwechu lhe redhalie ro'o ka benne ankake biría lhe! ");
INSERT INTO zae_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Attu sá bedetupa ixe juisiru ka benne ata du Jesús‑ni, ttaka labí nu goke tee. Nianna tti uxie ka benne rudhetinieha nna ree ka benneha: ");
INSERT INTO zae_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Ratua lasia ka benne se'e nii, kumu chiba uka tsunna ubisa se'eke len neti nna birula tee bixa goke. ");
INSERT INTO zae_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ganna suna anába ankake edhelhaa ke ki eyya lisike, la'ania nna ka satú leke, kumu adí ka benne‑ni idittuba dáke. ");
INSERT INTO zae_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ka benne rudhetinieha nna bekabike, ráke: ―¿Gála saxxíri'i nu go ka benne‑ni? Ki lo yu bisiba nuní se'eri'i. ");
INSERT INTO zae_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nianna ra Jesús‑ni ke: ―¿Balha yettaxtila chele? Lake nna bekabike ráke: ―Gasirubake chetu xa. ");
INSERT INTO zae_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nianna benie kini bese'e ka benne tupa niha lo yu nna tti bedaxxue gasi ka yettaxtilaha nna iki de chi begwebie ixkixaru len Tata Do Yebáha, nianna tti ulha'abie lhe'e ka yettaxtilaha nna begwebie ka benne rudhetinieha kini kidhike benneha ge iyá ka benne se'e niha. Ka benne rudhetinieha nna aníha‑ba benke. ");
INSERT INTO zae_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ka benneha chegabake ttu chupa ka belha to nna iki de chi begwe Jesús‑ni ixkixaru len Tata Do Yebáha, nianna tti redee ka benne rudhetinieha kidhigabake ka belhaha kini go ka benne se'e niha. ");
INSERT INTO zae_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Iyába ka benneha utobake axtaba beyielakanie nna bottuparulake a gasi ka sumi ka benne ro'o salha'a bexxaha. ");
INSERT INTO zae_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tu ttu ttapa mili ka benneha utoke. Nialiba nna tti bodhíbie ka benneha deyyake. ");
INSERT INTO zae_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Lee nna beyapi ttebe lo barcuha lenie ka benne rudhetinieha nna bisinke daka Dalmanuta. ");
INSERT INTO zae_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tti bisin ka fariseo‑ni ata du Jesús‑ni, nianna udulo ttebakana uxaka lenkane. Raka lekani unie ttu milagru. Aníha ruinkana kini ku'ukane prueba ki ula'a ganna gwalí Tata Do Yebáha udhelhe bie. ");
INSERT INTO zae_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús‑ni nna benné lebie nna ree: ―¿Beaka raka le ka benne se'e nnanna ilákanie unia ttu milagru? Netiru ria: labí unia bixa ttu milagru ki ilákanie. ");
INSERT INTO zae_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Niha‑ba bese'ebie ka fariseo‑ni nna beyapie lo barcuha. Betebie lo indaha nna besine ro'oni daka nu reha. ");
INSERT INTO zae_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ka benne rudhetinieha nna bixulhabakanie icheke nu goke, sunruba ttu túbi yettaxtila cheke lo barcuha. ");
INSERT INTO zae_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nianna ra Jesús‑ni ke: ―Gwaluyú gele ka iyietile kua dii ge ka fariseo‑ni lhe kua dii ge Herodes‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nianna tti ra luesike: ―Ganna de abíba yettaxtila cheri'i, de nuha‑ba nna rabie ri'i aná. ");
INSERT INTO zae_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ttaka Jesús‑ni nna ute dábanie nu rákeha, nianna tti ree ke: ―¿Beaka ra luesile deki labí yettaxtila tee? ¿Si itua ttu a rite denle lhe a rutte dale nu ria‑ni? ¿Laa tuttíruba yaya ikile? ");
INSERT INTO zae_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Laaba gwa yu'uba iyya lole nna a rilenle lhe gwa siaba nagale nna a riyieninle? ¿Si lagwa gwa radú lele ");
INSERT INTO zae_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","tti ulha'aya lhe'e gayu ka yettaxtila uto gayu mili ka benneha? La'ania, ¿a balha sumi besá ka yettaxtila ro'o salha'a bottupaleha? Lake nna bekabike, ráke: ―A tsi'inu sumi (12). ");
INSERT INTO zae_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nianna redenee: ―Atti ulha'aya lhe'e gasi ka yettaxtila uto ttapa mili ka benneha nna, ¿a balha ka sumiha besá ka yettaxtila ro'o salha'a bottupaleha? Lake nna bekabike, ráke: ―A gasi sumi. ");
INSERT INTO zae_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nianna ree ke: ―¿Ganna aníha nna beakala a rite denle? ");
INSERT INTO zae_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tti besin ka Jesús‑ni lhe'esi Betsaida, ka benne ge niha nna bisin tteba lenke ttu benne lo xua ata du Jesús‑ni, nianna unnaba ditibake lenie kini kane ka iyya lo benneha. ");
INSERT INTO zae_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Lee nna bedaxxu ttebe ná benne lo xuaha nna uleabie benneha ro'o yiesiha. Nianna tti bettuttu xxenie kini utabie ka iyya lo benneha lhe uxxua nábie ikie lhe, nianna tti unnaba tise benneha, ree: ―¿Si bi gwa chi relenlu ttuxka'a to? ");
INSERT INTO zae_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Benneha nna belannie nna ree: ―Chiba reláti ka benne, ttaka rula'abati ke ttiba ttu yaga ridá. ");
INSERT INTO zae_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nianna tti bedegan Jesús‑ni ka iyya lo benneha attu libe. La'anialiba nna chi beyaka ka iyya loeha nna belá tsenie iyá tte. ");
INSERT INTO zae_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nianna tti bedhelha Jesús‑ni benneha deyye lisie nna ree bie: ―Abittu sata'alu lhe'esi‑ni lhe abittugaba kixxi'enlu ka benne se'e lhe'esi‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Delola nna bederia Jesús‑ni dia lenie ka benne rudhetinieha, diake daka ta se'e ka yiesi to se'e daka Cesarea ge Filipo. Tti yu'uke nedaha nna unnaba tise, ree ke: ―¿Nú ra ka benne deki ankaa? ");
INSERT INTO zae_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ka benneha nna bekabike, ráke: ―Ttu chupa ka benne ráke deki lu ankalu Juan benne begadi indaha nna attu a chupake nna redenáke deki lu ankalu Elías, nna adíke nna ráke: “Ttu ka benne uka profeta ge Tata Do Yebáha‑ba nuná.” ");
INSERT INTO zae_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nianna ra Jesús‑ni ke: ―Lebi'i nna, ¿núla rale deki ankaa? Pedro‑ni nna bekabina rana: ―Lu ankalu Cristu benne chi ga'anani Tata Do Yebáha idhelhe. ");
INSERT INTO zae_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesús‑ni nna bodha'an tsitsie, ree ke: ―Anuttu nu gale deki neti ankaa Cristu. ");
INSERT INTO zae_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nianna tti udulo Jesús‑ni rabie ke: ―Neti benne daya yebáha teeki tate xxattaa uyúa elha disa. Ka benneola geri'iha lhe ka nu loni ge ka bixxudiha lhe, anágaba ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe, ka nuha ku'u ni'akani neti lhe uttikana neti lhe. Ttaka iki de chi beyonna ubisa uttiaha, la'ania nna eyaka benbaa attu libe. ");
INSERT INTO zae_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Lhixxa rába utixxi'e nuha. Laxkala Pedro‑ni uxine attu ta subi nna utisane. ");
INSERT INTO zae_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ttaka lee nna bodeki loe ata se'e adí ka benne rudhetinieha nna bedhaka dise Pedro‑ni, ree na: ―¡Ubi'etta kwe'a xa nu xxegwi! Kumu lu nu anka ge ka benne se'e yiesi lo yu‑niba do ikilu; labí do ikilu nu anka ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nianna tti uxie iyába ka benne se'e niha lhe ka benne rudhetinieha nna ree ke: ―Ganna nuxa ttúle raka lele etenalhale neti, teeki eria iki eria lele, meskila bixa satele nna gwaludaxxu kurusi gele nna gwaltá gwetenalha neti. ");
INSERT INTO zae_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kumu ttu benne ganna abittuba raka lebie bixa satebie de etenalhe neti, benneha nnittilee, delába labí aka ben benneha arlo Tata Do Yebáha. Ttaka benne eria iki eria lebie meskila bixa satebie delo ni'a kia lhe delo ni'a ge ka tisa ge Tata Do Yebáha lhe, benneha gwalálee. ");
INSERT INTO zae_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kumu, labí ixú nuha ganna ttixka ttu benne dhaabie uin gebie iyá nu se'e yiesi lo yu‑ni, ttaka arlo Tata Do Yebáha nna tsia nnittilee. ");
INSERT INTO zae_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nigaba labí aka geri'i go'ori'i elha nabani geri'i, kini anáchu aka benri'i ttu dia lii arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kumu ganna ttu benne ettunie kia lhe ettunie ge ka tisa kia‑ni arlo ka nu chi ruin satsa se'e nnanna, lhe chi rudhá ikikani Tata Do Yebáha, anágaba neti benne daya yebáha ettugabati gekani ganna chi dedáya lhe'e xiani ge Tata kiaha len ka anjeli geeha. ");
INSERT INTO zae_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Rágaba Jesús‑ni ke: ―Netiru ria: ttu chupale se'ele nii nnanna labí chi uttile axtaliba ganna chi bilenle isia Tata Do Yebáha innabie lhe ra tsitsi lebie lhe. ");
INSERT INTO zae_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Iki de chi ute xxupa ubisaha nna tti ugwapi Jesús‑ni iki ttu i'iya xeni do niha, chebie sun Pedro‑niba lhe Jacobo‑ni lhe Juan‑ni lhe. Niha besea lobie arlokani. ");
INSERT INTO zae_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ka xoeha raka lhalhabakana lhe sitsi túba beyakakana lhe. Ni ttú benne do yiesi lo yu‑ni dhaabie otsitsie ttu lari atti beyaka ka xo Jesús‑ni la'ania. ");
INSERT INTO zae_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Lengwa chi bela'akinna uka xxe Elías‑ni lhe Moisés‑ni lhe, se'eke gwenne len Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro‑ni nna rana Jesús‑ni: ―Maestru, ¡gwen tte uka se'etu nii! Usiatu tsunna ka yo'o lhaga gele: ttu gelu nna ttu ge Moisés‑ni nna attu ge Elías‑ni nna. ");
INSERT INTO zae_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Aníha‑ba rana kumu de labí yuna bixa innána de si rasilakinna. ");
INSERT INTO zae_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nianna tti bebe tteba ttu bea ata se'ekeha. Lhe'e beaha nna biyien tsi'i ttu benne unnebie, ree: ―Benne‑ni anke Xi'inia lhe rakati gebie lhe. Ge benne‑ni gwaludo nagale. ");
INSERT INTO zae_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ttiruba nna ttu nnelaba benitti loo ka benneha, laxkala atti bodeki lokani belannikana abi'iba kwe'ekani nna nurua ka benneha bilákinna, a sunruba Jesús‑ni du niha. ");
INSERT INTO zae_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tti deyyake reyadike lati i'iyaha nna ra Jesús‑ni kana: ―Nuttu nu kixxi'enle ge nu bilenle‑ni axtaliba ganna neti benne daya yebáha chi beyaka bania attu libe lagwi ge ka benne chi uttiha, la'anialiba nna chi dina kixxi'ale. ");
INSERT INTO zae_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Lake nna labí utixxi'ake, gwa ulu'uba leke nuha. Sun raba luesike: “¿Bíla dianie tti ree deki eyaka benbe attu libe?” ");
INSERT INTO zae_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nianna tti unnaba tisake Jesús‑ni, ráke bie: ―¿Beakala ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni nna rákana deki Elías‑ni teeki esie lade'a tte, niala nna tti isia Cristuha? ");
INSERT INTO zae_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús‑ni nna bekabie, ree kana: ―Gwalí galá deki Elías‑ni esie lade'a tte ki ose'e tsebie iyá nu se'e. Ttaka ganna aníha aka nna, ¿beakala ra lo ka yetsi ge Tata Do Yebáha deki neti benne daya yebáha teeki sate xxattaa lhe ku'u ni'akani neti lhe? ");
INSERT INTO zae_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ttaka neti ria, Elías‑ni chiba bita benneha nna bedhakabakane attiba ukaba lekani, benbakana attiba chi ga'anna lo ka yetsi ge Tata Do Yebáha satebie. ");
INSERT INTO zae_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tti besin Jesús‑ni lenie a tsunna ka benneha ata se'e adíru ka benne rudhetinieha, nianna gwaxxakake ixe juisiru ka benne chi tupake abi'iba kwe'e ka benneha. Niha‑gaba se'e ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni. Ka nuha ridaka lenkana ka benne rudhetinieha. ");
INSERT INTO zae_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ka benne se'e niha nna tti chi bilákanie dedá Jesús‑ni nna iyábake bebanakanie, nianna biresu ttebake gwatsáke bie ki gwagweke bie padiuxi. ");
INSERT INTO zae_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús‑ni nna unnaba tise ka benne rudhetinieha, ree ke: ―¿Bíunna ridaka lenle ka nuná? ");
INSERT INTO zae_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ttu benne sela lhe'e ka benne tupa niha nna bekabie ree: ―Xa tata maestru, laa chea xi'in biyúa‑ni len kwinalu. Yu'u ttu espíritu xxegwi latibi nna bodha'anna bi biría, nuní runi ki bittu raka innebi. ");
INSERT INTO zae_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gaxaba dubi rettina gebi nna tti rurixxi lona bi ribeana kuchina ro'obi, lhe raka rriba lo layabi. Nianna tti rodá yaga ttebana latibi. Chi unnabaa len ka benne rudhetinlu‑ni kini ebeake espíritu xxegwi‑ni latibi, ttaka labí udaake. ");
INSERT INTO zae_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús‑ni nna ree ka benneha: ―¡Aalexa nu a ria leni! ¿Nukalila sa dhua len lebi'i? ¿Nukalila sa utto uchíaya ge nu ruinle? Daka aní gwataxxí nu kwiti‑na. ");
INSERT INTO zae_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nianna tti gwaxxíke nu kwitiha, ttaka tti bilani espíritu yu'u lati nu kwitiha Jesús‑ni, nianna bexxidi ttebana nu kwitiha, nna betesina na lo yu, lhe ribeana kuchina ro'oni lhe. ");
INSERT INTO zae_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús‑ni nna unnaba tise tata ge nu kwitiha, ree benneha: ―¿Si isá chi ridakabi nuní? Benneha nna bekabie ree: ―Attiliba ankabi nutoha xa. ");
INSERT INTO zae_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ixe lidú chi bedelhana bi lo gi lhe bedelhana bi lhe'e inda lhe, ruinna uttina bi. Laxkala ganna gwaka gelu uinlu ttu bixa, gwatuachi lelu ri'itu lhe betechi nálu len ri'itu. ");
INSERT INTO zae_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús‑ni nna bekabie ge benneha, ree: ―¿Gasina nuha nna innálu: “Ganna gwaka gelu”? Neti ria, nu ria leniha gwakaba iyába nu innabana. ");
INSERT INTO zae_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tata ge nu kwitiha nna unne ttebe idisa, ree: ―¡Gwa ria galá lasia! ¡Rinnabaa len kwinalu, akachi lenlu neti kini tsia chiettiru lasia! ");
INSERT INTO zae_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tti bilani Jesús‑ni adíla chi rituparu ka benne, nianna bedhaka dise espíritu satsaha, ree nuha: ―¡Espíritu kwechu lhe biría lhe, neti rulisaa lu! ¡Beria lati nu kwiti‑ni nna bitturu eteta'alu latini! ");
INSERT INTO zae_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Espíritu satsaha nna ribesi'abana, nianna tti bodoxxidi xxattana lati nu kwitiha attu libe, niala nna tti beriana. Nu kwitiha nna ttiba ttu nu yatti beya'anna, laxkala ixeba ka benne ráke deki uttibana. ");
INSERT INTO zae_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ttaka Jesús‑ni nna bedaxxue ná nu kwitiha nna bechidhe na. Nu kwitiha nna beyadha ttebana bedúna. ");
INSERT INTO zae_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iki de nuha nna uta'a Jesús‑ni lhe'e ttu yo'o. Tti chi due niha sun lenbe ka benne rudhetinieha, nianna tti unnaba tisa ka benneha, ráke bie: ―¿Beakala ri'itu nna a udaatu ebeatu espíritu satsaha? ");
INSERT INTO zae_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Lee nna bekabie, ree ke: ―Luesi espíritu xxegwi‑na labí kwenta eria nuná, ganna abíba innabari'i len Tata Do Yebáha lhe ganna abíba utte ubina lhe'eri'i lhe. ");
INSERT INTO zae_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bedábake ata se'ekeha nna beteke daka Galilea‑ni, ttaka Jesús‑ni nna labí raka lebie una ka benne deki rekike niha, ");
INSERT INTO zae_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kumu lee raka lebie ule'enie ka benne rudhetinieha, nianna ree ke: ―Neti benne daya yebáha utekana neti lasi ná ka nu uttikana neti, ttaka ganna chi beyonna ubisa uttiaha, la'ania nna eyaka benbaa attu libe. ");
INSERT INTO zae_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ttaka lake nna labí rite dákanie ge nu reeha nna rasibakanie innaba tisake bie. ");
INSERT INTO zae_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tti chi besinke lhe'esi Capernaum, atti chi se'eke lhe'e yo'oha nna unnaba tisa Jesús‑ni ka benne rudhetinieha, ree ke: ―¿Bí ge nuha ridaka len luesile tti deyu'uri'i nedaha? ");
INSERT INTO zae_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ttaka lake nna siiba ukake labí bekabike, kumu atti deyu'uke nedaha ridaka len luesike ge nuxake ankake nu ra xxeniru leni. ");
INSERT INTO zae_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nianna tti urebie nna uxie ka benne tsi'inu (12) rudhetinieha nna ree ke: ―Ganna nuxa ttúle raka lele akale nu loni delo iyále, benne ake nu loniha labí unie deki ra xxeni lebie, akalee nu ixúni iyále. ");
INSERT INTO zae_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nianna tti bedaxxue ttu nuto bedúe nuha lagwi geke nna tti ulhenie bi'iniha nna ree ke: ");
INSERT INTO zae_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Nuxaba benne de ria lebie neti, ganna ulabie ttu luesi nuto‑ni, neti nuha rulabi benneha, nna benne ulabie netiha, laa netiga nuha rulabie, Tata kia benne udhelhe netiha, benneha nuha rulabie. ");
INSERT INTO zae_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan‑ni nna rana Jesús‑ni: ―Maestru, chi bilentu ttu nubiyú reki naa rudettina lu tti rebeana ka espíritu xxegwi yu'u lati ka benne. Ttaka ri'itu nna chi besunatu kini abitturu uinna aná, kumu de labí rekina len ri'i. ");
INSERT INTO zae_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ttaka Jesús‑ni nna ree kana: ―Bittu usunale ebeana ka espíritu‑na. Kumu lanú ttu benne do rudettie neti tti runie ttu milagru, delo nna eyekie innebie kia. ");
INSERT INTO zae_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kumu benne abittu rigu'u ni'e ri'i, benneha gwa dube len ri'i. ");
INSERT INTO zae_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Netiru ria, nuxaba benne ganna utebie kwadiba ttu xiga inda i'iyale de ankale benne ria lele neti, de nu unieha nna gugweba Tata Do Yebáha benneha nu tse ralhe dhie. ");
INSERT INTO zae_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Nuxaba benne ganna unie dhi yiebie ttu ka benne abittu ra xxeni leke; delába ttu ka benne ria leke neti, ganna benneha unie dhi yiebie ttu ka benneha ki uinke nu satsa, netiru ria, tserula taríane uxxigakana yienie ttu íyya ge mulinu nna udelhakane lhe'e indatooha. ");
INSERT INTO zae_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ganna nálu‑na abittuba daa siina, nnelaba ruinlu ttu bixa nu satsa lenna, tsa ttela uchú nuná, kumu tserula taríana lu esinlu ata aka benlu ttu dia liiha anka choku nálu, a laa kila esinlu len ixpa lha'a nálu ata uyúlu elha disa tsialu lo giha, delába gi nu abittuba reyola loniha nu satíaba rite loniha. ");
INSERT INTO zae_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Niha labí ratti ka bedua‑na, lhe nigaba labí reyola lo giha lhe. ");
INSERT INTO zae_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Lhe anágaba ni'alu‑na ganna abittuba ridú siina, nnelaba ruinlu ttu bixa nu satsa lenna, tsa ttela uchú nuná, kumu tserula saríana lu esinlu ata aka benlu ttu dia liiha anka choku ni'alu, a laa kila esinlu len ixpa lha'a ni'alu ata uyúlu elha disa nna iru'unalu tsialu lo giha, gi nu abittu reyola loniha, nu satíaba rite loniha. ");
INSERT INTO zae_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Niha labí ratti ka bedua‑na lhe nigaba labí reyola lo giha lhe. ");
INSERT INTO zae_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Anágaba ganna iyya lolu‑na rixuinlu na ki ruinlu ttu nu satsa, tsa ttela ulea nuná kumu tserula taríana lu esinlu ata rinnabia Tata Do Yebáha suna len ttu lha'aba iyya lolu, a laa kila esinlu leni ixpa lha'a lolu ata uyúlu elha disaha nna iru'unalu tsialu lo giha. ");
INSERT INTO zae_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Niha labí ratti ka bedua‑na lhe nigaba labí reyola lo giha lhe. ");
INSERT INTO zae_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Kumu iyába ka benne, giha nuha uinna ki tsettike ixe ttiba ttu deti. ");
INSERT INTO zae_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Deti‑na tseba anka nuná, ttaka ganna deti‑na itua ixe geni, la'ania nna, ¿gasina uinri'i kini eyona ixe? De nuha nna latsiru gwaluni. Elha ruin gele‑na akana attiba ttu deti. Ttiba deti‑na rugwena ixí ge ttu elho, aníha‑ba lebi'i latsiru gwaltse'e, bittu ttilha len luesile. ");
INSERT INTO zae_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Bedába Jesús‑ni Capernaum nna diabie daka Judea, daka attu ladu ro'o yoo Jordán‑ni. Nianna bedetupa tteba ixeru ka benne abi'iba kwe'ebie. Lee nna attiba chi labinie runie nna bededulo ttebe rodole'enie ka benneha ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nianna tti ubiga ttu chupa ka fariseo. Sun tteba ruinkana kini ku'ukane prueba, de nuha nna unnaba tisakane, rákane: ―¿Si gwaka udhá iki ttu nubiyú nuila geni? ");
INSERT INTO zae_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Lee nna bekabie gekani ree: ―¿Bíla ra lo bia bennabi bodha'an Moisés‑ni len lebi'i? ");
INSERT INTO zae_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Lakana nna bekabikana rákane: ―Lo bia bennabi bodha'an Moisés‑ni, gwa rugwelhabana deki nubiyúha gwakaba ilhidhana ttu yetsi ata inná lo nuha deki gwakaba ela'ana len nuila geniha. La'ania nna gwakaba udhá ikini nuilaha. ");
INSERT INTO zae_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús‑ni nna ree kana: ―Moisés‑ni bodha'an galábie aka aníha kumu de lebi'i labí rieninle. ");
INSERT INTO zae_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ttaka Tata Do Yebáha, ttili ure yiesi lo yu‑niha, nuila lhe nubiyúba lhe benie ka benne. ");
INSERT INTO zae_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","De nuha nna teeki udhana nubiyúha ka tata nan geniha nna utsá náni len nuila geniha ");
INSERT INTO zae_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kini akakana ttisidiba ttúba benne. Laxkala labíru ankakana chupa, sinuki ttúba benne chi akakana. ");
INSERT INTO zae_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Laxkala ka nu chi beketi Tata Do Yebáha, labí dika etsila ttu benne kana. ");
INSERT INTO zae_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tti chi se'eke lhe'e yo'oha nna bedennaba tisa ka benne rudhetinieha bie attu libe ge nu chi unneeha. ");
INSERT INTO zae_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús‑ni nna rabie ke: ―Ganna si ttu nubiyú udhá ikini nuila geniha nna edo lenna attu nu subi, la'ania nna satsaba nuha chi uin nubiyúha. ");
INSERT INTO zae_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Lhe anágaba nuilaha, ganna si udhá ikini nubiyú geniha nna edína attu nubiyú subi, satsagaba nuha chi uin nuilaha. ");
INSERT INTO zae_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bisingaba ka benne len ka nuto kini uxxua ná Jesús‑ni ikikabi, ttaka ka benne rudhetinieha nna rudhaka disalake ka benne cheke ka bi'iniha. ");
INSERT INTO zae_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tti bilani Jesús‑ni ruin ka benneha aníha, nianna bituxxunie nna ree ke: ―Gwalugwelha ka binto‑na itakabi len neti nna abittu usunale. Kumu ka benne ruinke tti ruin ka binto‑na, luesi ka benne‑na ralhake akake ka benne innabia Tata Do Yebáha ke. ");
INSERT INTO zae_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Netiru ria, ganna ttu benne abíba unie tti runi ttu nuto ugwelhe innabia Tata Do Yebáha bie, benneha labí ake nu innabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nianna tti rudaxxue ka bintoha rilhenie kabi nna tti rixxua nee ikikabi, rinnabe elha nabani gekabi len Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Chiba dha Jesús‑ni tsie, ttiruba nna gwexunniba bisin ttu nubiyú nna bedú xibini arloe nna rane: ―Maestru, lu ankalu benne tse. Unáchu, ¿bíla anka nu unia kini satíaba aka bania arlo Tata Do Yebáha? ");
INSERT INTO zae_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús‑ni nna bekabie geni, ree: ―¿Beaka ralu deki ankaa benne tse? Lanú ttu benne do anke benne tse, sunruba Tata Do Yebáha gwanke benne tse. ");
INSERT INTO zae_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Lu chiba yulu nu boka'an Tata Do Yebáha uinri'i, tti ree: Bittu akalu nu runi elhutti, lhe bittu dho lenlu nu abittu anka latselalu, lhe anágaba bittu lhanalu, lhe bittu kwentaba usialu iki ka benne deki benke ttu bixa, lhe anágaba bittu kualu bixa tee ge ttu benne, lhe tsiagaba lelu ka tata nan gelu lhe. ");
INSERT INTO zae_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nubiyúha nna bekabina gee, rane: ―Maestru, ttili ankaa nu kwiti toha chi rudoa tisa ge iyá nu ralu‑na. ");
INSERT INTO zae_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús‑ni nna begíabie loni nna besi'inie na, nianna tti rabie na: ―A sun tte attu nu riyasa uinlu: beyya nna betto'o iyá nu tee gelu nna belhiu ge nuha nna begwe ka benne abittu geke tee. Ganna lu uinlu aníha, la'ania nna gwattaba elha tse gelu yebáha. La'anialigaba nna chinka utá betenalha neti. ");
INSERT INTO zae_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ttaka nubiyúha, tti biyieninna nu rabie naha, nianna si'iba bedúna leni deyyana kumu de tee xxatta geni. ");
INSERT INTO zae_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nianna tti belanni Jesús‑ni abi'iba kwe'ebie nna ree ka benne rudhetinieha: ―Gáruba tsitsi anka ki isin ka nu tee gekinna akakana benne innabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ka benne rudhetinieha nna bebanabakanie ge nu reeha. Jesús‑ni nna redeabie ke: ―Xi'ini to, ka benne ruxxen leke ge nu tee geke, gáruba tsitsi anka ki isinke akake benne innabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Adírula satti ga'a ttu camellu lhe'e yieru do xan ttu yoxa attichula ga'a ka benne tee geke ki akake nu innabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ka benne rudhetinieha nna adikala rebanakanie, nianna ra luesike: ―Ganna aníha nna, ¿nú tteba dhaana esin lenna Tata Do Yebáha? ");
INSERT INTO zae_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nianna tti belanni Jesús‑ni loke nna ree ke: ―Len ka benne se'e yiesi lo yu‑ni abittu galá aka, ttaka len Tata Do Yebáha iyába gwakaba. ");
INSERT INTO zae_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro‑ni nna udulona rane: ―Biyúruga, ri'itu chiba bedhá ikitu iyába nu tee getu nna danalhatu lu. ");
INSERT INTO zae_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús‑ni nna bekabie ree: ―Netiru ria, nuxaba benne ganna bedhá ikie yo'o geeha lhe ka betsieha lhe ka daneha lhe ka tata nan geeha lhe, anágaba ganna bedhá ikie nuila geeha lhe ka xi'inieha lhe ka lo yu geeha lhe de danalhe neti, lhe de ria lebie ka tisa ge Tata Do Yebáha lhe, ");
INSERT INTO zae_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","benneha, nnanna doe yiesi lo yu‑ni gayua (100) libe‑la edíe nu bedhá ikieha, delába edíe ka yo'o lhe ka betsie lhe ka dane, lhe anágaba edíe ka tata nan gee lhe edíe ka xi'inie lhe ka lo yu gee lhe, anágaba meskila sanookane urio lákane, ttaka nu si daa nna satíaba aka benbie arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ttaka ixe ka nu ra xxeni lekani nnanna, la'ania nna eyakakana ka nu abittu ra xxeni lekani, nna ka nu abittu ra xxeni lekani nnanna, ka nuha‑la eyakakana ka nu ra xxeni lekani la'ania. ");
INSERT INTO zae_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yu'ubake neda diake Jerusalén‑ni nna daneruba Jesús‑ni lo ka benne rudhetinieha. Ka benneha nna rebanabakanie lhe itú rasibakanie danalhake bie. Nianna tti bedeaxie sun ka benne tsi'inuha‑ba (12) nna utixxi'anie ke nu satebie. ");
INSERT INTO zae_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nianna ree ke: ―Gwaluyúruga, chiba diari'i isinri'i Jerusalén‑ni. Neti benne daya yebáha nna chiba dabigana utekana neti lasi ná ka nu loni ge ka bixxudiha lhe lasi ná ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe. Ka nuha nna urixxi ukinnibakana neti kini gattia, nianna tti uttekana neti lasi ná ka nu abittu ankakana nu Israel. ");
INSERT INTO zae_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ka nuha nna uxisikana kia lhe ukulhakana neti lhe, anágaba nna uttuttugaba xxenkani loa, nianna tti uttikana neti. Ttaka ganna chi eyonna ubisaha, la'ania nna eyaka benbaa attu libe. ");
INSERT INTO zae_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jacobo‑ni lhe Juan‑ni lhe, lakana ankakana xi'in Zebedeo‑ni. Ixpabakana ubigakana ata du Jesús‑ni nna rákane: ―Maestru, raka letu uinlu nu innabatu. ");
INSERT INTO zae_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Lee nna ree kana: ―¿Bí raka lele unia? ");
INSERT INTO zae_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Lakana nna rákane: ―Ugwelhachilu ri'itu kwiatu gaxxa kwe'elu ganna chi esinlu yebáha ata innabialuha, ttutu dhotu daka ná benlu nna attutu nna dhotu daka ná yattilu. ");
INSERT INTO zae_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús‑ni nna ree kana: ―Lebi'i labí yule nu rinnabale‑na. ¿Si gwadaale uyúle luesi elha disa uyúa‑ni lhe si gwadaale satele luesi nu satea‑ni lhe? ");
INSERT INTO zae_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Lakana nna rákane: ―Ila. Gwadaa galátu. Lee nna ree kana: ―Gwalí galá, gwadaabale uyúle luesi elha disa uyúa‑ni lhe satele nu satea‑ni lhe, ");
INSERT INTO zae_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ttaka nu rale deki ugwelhaa le kwiale, ttúle daka ná bania lhe attule daka ná yattia lhe, labí neti ralhaa ugwelhaa le kwiale niha, sinuki nuná ankana ge ka benne chi ga'anani Tata Do Yebáha kwiake kwe'a niha. ");
INSERT INTO zae_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tti biyienini a tsii ka benne rudhetinieha nu rinnaba Jacobo‑ni lhe Juan‑ni lhe, nianna bisa'akanie len ka benneha. ");
INSERT INTO zae_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús‑ni nna beyaxie ke nna ree ke: ―Lebi'i gwa yúbale, ka nu rinnabia lhe'e ka yiesi dittu‑na, rinnabiabakana ka benne gekani attiba rakaba lekani lhe anágaba ka nu ra xxeni lekani se'e lhe'e ka yiesi‑na, nu rábakana raka. ");
INSERT INTO zae_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ttaka lebi'i labí aná dika udhaka luesile. Lebi'i nu uinlale, ganna nuxa ttúle raka lele akale nu ra xxeni leni delo iyále, benne inná xxeni leha, benneha‑la ake benne ixúni adíle, ");
INSERT INTO zae_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","lhe anágaba benne raka lebie ake nu loni gele, lalee ake attiba ttu nu to'o lo sina ixúe ute nábie len iyá ttele. ");
INSERT INTO zae_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kumu anágaba neti benne daya yebáha laa dagaa yiesi lo yu‑ni ki ixúti ka benne uinke nu innía, sinuki dalaa kini ixúa ute náya lenke lhe daya kini gattia kixaa ge ka tulha ruin ka benne, ki odiláya ixeke. ");
INSERT INTO zae_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bisinba Jesús‑ni lenie ka benne rudhetinieha lhe ixe juisiru ka benne lhe'esi Jericó. Tti chi deyyake eriake lhe'esiha, ro'o neda deyyakeha re ttu nubiyú a raka ilenna, rinnabana belhiu. Nubiyúha lána Bartimeo. Bartimeo‑ni ankana xi'in ttu benne tee lábie Timeo. ");
INSERT INTO zae_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tti ute den Bartimeo‑ni deki Jesús ge Nazaret‑niba nuha utee niha, nianna tti unnena idisa, rana: ―¡Jesús benne datia David, gwatuachi lelu neti! ");
INSERT INTO zae_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nianna ixeba ka benne bedhaka disake nubiyúha kini eyaka siina, ttaka lana nna adíla idisa uresi'ana, rana: ―¡Benne datia David, gwatuachi lelu neti! ");
INSERT INTO zae_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nianna tti uleda Jesús‑ni nna udhelhe kini gwalisake na. Ka benneha nna gwaxxíke benne lo xuaha nna ráke bie: ―Tsitsi uleki lelu nna udú lii. Chi raxie lu. ");
INSERT INTO zae_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Benneha nna bedelha bixxie lari nukueha nna gintsaba udú liie, nianna tti die ata du Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús‑ni nna unnaba tise benneha, ree bie: ―¿Bí raka lelu udhakaa lu? Benne xua loeha nna ree: ―Maestru, raka lasia eyali ka iyya loa‑ni. ");
INSERT INTO zae_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Lee nna ree benneha: ―Chinka beyya. De ugía lelu deki gweyakabalu, de nuha nna chiba beyakalu. Looraha tteba beyali ka iyya lo benneha, nianna dia ttebe danalhe Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tti chi isin ka Jesús‑ni lhe'esi Jerusalén‑ni, gaxxaba ata re lhe'esi Betfagé lhe Betania lhe, daka ata do i'iya ata daa ka ya olivuha, nianna tti udhelha Jesús‑ni chupa ka benne rudhetinieha, ");
INSERT INTO zae_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ree ke: ―Gwaltsia lhe'e yiesi to re arlori'i‑ni. Ganna chi uta'ale lhe'e yiesi‑na nna saxxaka ttebale nalha ttu burru to, ttu nu lanú nu chi udona kwe'eni. Gwalidhasi yienni nna gwaltá lenna. ");
INSERT INTO zae_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ganna nuxa innaba tisana le, gana le: “¿Beaka ridhasile yien burru to‑na?” Aní gwaligá na: “Jesús benne anke Xxanari'iha‑ba riyasanie nuní, delola nna gwetedha'an tte gee na.” ");
INSERT INTO zae_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nianna dia ttebake nna gwaxxakabake burru toha, nalhana ro'o nedaha, gaxxaba ro'o ttu yo'o. Nianna tti udhasike yienni. ");
INSERT INTO zae_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ttu chupa ka nu se'e niha nna unnaba tisakana, rákana: ―¿Bíunna ruinle? ¿Beaka ridhasile yien burru to‑na? ");
INSERT INTO zae_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ka benneha nna bekabibake atti tteba ra Jesús‑ni ekabike. Aníha uka nna gwa begwelhabakana ke decheke bia toha. ");
INSERT INTO zae_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tti besin lenke burru toha ata du Jesús‑ni, nianna utsilake ka xokeha kwe'e bia toha nna tti udoe kwe'eba. ");
INSERT INTO zae_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ixegaba ka benne utsilake ka xokeha lo neda ata dia Jesús‑ni ritebie nna adíke nna utitsake lo ka yaga daa niha nna utsilake lo nedaha. ");
INSERT INTO zae_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ka benne daneruke arloeha lhe ka benne danalhake bieha lhe, ka benneha nna ribesi'abake ráke bie: ¡Xxeniba ra lelu! ¡Karubárulu! ¡Lu ankalu benne udhelha Tata Xisiha! ");
INSERT INTO zae_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Karubárulu! ¡Lu innabialu ttiba unnabia tata geri'i David‑ni! ¡Xxeniba ra le Tata Do Yebáha! ");
INSERT INTO zae_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tti uta'a Jesús‑ni lhe'esi Jerusalén‑ni nna dia ttebe ata do yotuha nna bilánie abi'iba kwe'e yotuha iyá nu raka niha, ttaka kumu chi galá diora nuha, de nuha nna bedá ttebe len ka benne tsi'inu rudhetinieha (12) deyyake daka Betania. ");
INSERT INTO zae_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Beyeki sáha, tti beriake lhe'esi Betania, ugwetti bituin Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nianna tti bilánie du ttu ya higu axtaru nu reha gwa siaba lhaga geni. Lee nna dia ttebe ata du yagaha ganna gwa sia higu loni. Ttaka bi gwaxxake ni ttu higu lo nuha, sunruba lhaga geni sia, kumu labí higu chi rebia la'ania. ");
INSERT INTO zae_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nianna tti ree yagaha: ―¡Debá nnanna niruba attu higu a kwiaru lolu, laxkala lanúru nu gona nu xixxi gelu! Ka benne rudhetinieha nna biyienbakanie nu reeha. ");
INSERT INTO zae_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tti bisinke lhe'esi Jerusalén‑ni nna uta'a tteba Jesús‑ni lali'a yotuha nna udulo ttebe bochesue iyá ka nu se'e gwetto'oha lhe ka nu yu'u ugo'oha lhe. Berixxi logabe ka mexa ge ka nu rotsea belhiha lhe ka xxila ge ka nu se'e gwetto'o ka bechaha lhe. ");
INSERT INTO zae_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Anágaba labíru begwelhe ka benne tteke lali'a yotuha nujake yua. ");
INSERT INTO zae_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nianna rigixxi'anie ka benneha ree ke: ―¿Laaba ganna lo ka yetsi ge Tata Do Yebáha dia ra: “Yo'o kia‑ni ixúe kini iyá xea ka benne se'e yiesi lo yu‑ni ilhapike tisa len neti”? Ttaka lebi'i nna ttiba “belea ata yu'u ka ubanala” chi benle yotu‑ni. ");
INSERT INTO zae_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Biyienbakin ka nu loni ge ka bixxudiha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni nu ra Jesús‑ni, nianna tti begila lekani kini gaxasina uinkana uttikane, kumu rasibakinna gebie kumu de iyába ka benne rebanabakanie ge nu rule'enie keha. ");
INSERT INTO zae_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tti chi ulha sá nna beriaba Jesús‑ni Jerusalén‑ni lenie ka benne rudhetinieha deyyake. ");
INSERT INTO zae_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Beyeki dilaha nna dia Jesús‑ni lenie ka benne rudhetinieha nna uteke gaxxaba ata du ya higuha. Nianna bilákanie yagaha, chi ubisi nuha itupa lhu‑ni. ");
INSERT INTO zae_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nianna tti gwadú le Pedro‑ni nna rana Jesús‑ni: ―Maestru, belanniruga ya higu utisaluha, chiba ubisina. ");
INSERT INTO zae_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús‑ni nna bekabie, ree kana: ―Gwaluxxen tsitsi lele ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Netiru ria, nuxaba benne ganna ttixka gabie i'iya do naa: “Ubi'etta ata dolu‑na nna ugía gwaxxudi lhe'e indatoo‑na”, benne inná aníha abittu udú chupana lebie tti innee aníha, sinuki tuttíruga tsia tsitsi lebie deki gwakaba nu reeha, la'ania nna gwakaba nu rinnabeha. ");
INSERT INTO zae_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Laxkala de nuha nna ria le, iyába nu innabale len Tata Do Yebáha tti rinnele lenie, gwaltsia lele deki chiba uxíle nu unnabaleha, la'ania nna gwadíbale nuha, ");
INSERT INTO zae_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","lhe anágaba tti se'ele rilhapile tisa len Tata Do Yebáha, gwalidhí elha xen lasi ge ttu benne ganna ritilha lenlee, kini anágaba nna Tata gele benne do yebáha gwadígabe elha xen lasi ge ka tulha ruinle. ");
INSERT INTO zae_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kumu ganna lebi'i abíba dhile elha xen lasi ge ttu benne, anágaba Tata gele do yebáha, labígaba dhie elha xen lasi ge ka tulha ruinle. ");
INSERT INTO zae_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tti bedesinke Jerusalén‑ni nna laka reki Jesús‑ni ata do yotuha, nianna tti ubiga ka nu loni ge ka bixxudiha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe, anágaba ubigagaba ka benneola ge ka nu Israel‑ni, ");
INSERT INTO zae_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","nianna unnaba tisakana, rákane: ―¿Bí lo neda nuná rapalu kini ruinlu ka nu ruinlu‑na? ¿Núla betena lo neda gelu kini ruinlu nuná? ");
INSERT INTO zae_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús‑ni nna bekabie, ree kana: ―Anágaba neti innaba tisagabaa le ttu bixa. Ganna ekabile ge nu innaba tisaa le‑ni, la'ania nna neti gwagixxi'agabania le nú betena lo neda len neti kini runia ka nu runia‑ni. ");
INSERT INTO zae_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Gwalinná sanga, ¿nú iki biria ki begadi Juan‑ni ka benne inda? ¿Si iki Tata Do Yebáha ak? ¿Iki ka benne se'e yiesi lo yu‑ni ak? ");
INSERT INTO zae_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Lakana nna ra luesikani: ―Ganna gari'i na: “Tata Do Yebáha‑ba udhelhe benneha”, la'ania nna innána: “¿Beaka laa a ugía lele ge benneha ganna?” ");
INSERT INTO zae_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bittugaba aka geri'i gari'i na: “Ka benneba udhelhake benneha.” Aníha rákana kumu rasibakinna ge ka benne kumu iyábake ria leke deki Juan‑ni gwalíga uka benneha profeta ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aníha uka nna bekabikana ge Jesús‑ni, rákane: ―Labí yutu nuxa udhelhana benneha. Lee nna bekabie gekani, ree: ―Anágaba neti bittugaba kixxi'ania le nú rutena lo neda len neti kini runia ka nu runia‑ni. ");
INSERT INTO zae_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nianna tti udulo Jesús‑ni utixxi'anie ka nu loni ge ka nu Israel‑ni ttu tisa. Aníha benie kini utte dákana bí diani nu raka lebie kixxi'anie kana. Nianna tti ree: ―Ttu benne biyú beyade ka ya uva lo yu geeha, nianna tti bedheabie abi'iba ro'o yuha lhe ulekie ttu xieru ata idí uvaha. Anágaba nna bengabe ttu yo'o ttu nu yadha kini dho benne ulatsie ki anuttu nu salhidana uvaha. Nianna tti bete ganne yuha len ka nu kwenkana nuha, lee nna biriabie die idittu. ");
INSERT INTO zae_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Atti chi bisia sá exú uvaha nna udhelhe ttu ka benne riben lo sina geeha kini tsie ata se'e ka nu riben lo yuha ki utekana nu ralhe dhie ge lo yuha. ");
INSERT INTO zae_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ttaka ka nu riben lo yu geeha bedaxxulakana benne udhelheha nna uyalakane. Nianna suna anába anke bedhelhakane. ");
INSERT INTO zae_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nianna tti bededhelhe attu benne riben lo sina geeha, ttaka lakana nna bodosíalakana benneha íyya nna ulha'akana ikie lhe besiala lekanie lhe. ");
INSERT INTO zae_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nianna tti bededhelhe attue, ttaka benneha bettilakane. Iki de nuha nna udhelharugabe ixeeruke, ttaka ttu chupa ka benneha uyakana ke nna attu chupake nna bettibakana ke. ");
INSERT INTO zae_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nianna a sunruba xi'in biyúeha bexxa, benne rakanie geeha. Debá benneha udhelhe kumu rakanie: “Xi'inia‑niligaba nna gweyya lekanie.” ");
INSERT INTO zae_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ttaka ka nu riben lo yu geeha, tti bilákinna xi'in biyúeha, nianna ra luesikani: “Lana nuní eya'anna lo yu‑ni. Uttiri'i na kini eya'anri'i len yu‑ni.” ");
INSERT INTO zae_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nianna tti bedaxxukana benne kwitiha nna bettikane nna tti bedelhakane ro'o yu ata daa ka ya uvaha. ");
INSERT INTO zae_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nianna tti ra Jesús‑ni kana: ―¿Bí rakinle uin xxana ka ya uvaha ganna? ¿Laaba ganna tsie nna uttie ka nu riben lo yu geeha, nianna tti odotebie yuha len ka nu subi? ");
INSERT INTO zae_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Si lagwa chi belabale lo ka yetsi ge Tata Do Yebáha ata dia ra: Íyya nu ulu'u ni'a ka nu rukuakana yo'oha, íyyaha‑la nuha chi bisinna beyakana nu rixúru; ");
INSERT INTO zae_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tata Xisiha‑ba benie kini uka aní, nna rebanabinri'i rilenri'i nu benie? ");
INSERT INTO zae_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ka nu loni ge ka nu Israel‑ni, kumu ute dábakinna deki labakana nuha betani Jesús‑ni nu unneeha, de nuha nna ruinkana doelha udaxxukane, ttaka de rasikinna ge ka benne, de nuha nna labí beyaxakinna udaxxukane. Laxkala nna du bixxibe deyyakana. ");
INSERT INTO zae_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nianna tti udhelhakana ttu chupa ka fariseo lhe ttu chupa ka nu tákana Herodes‑ni lhe, kini tsia ka nuha ata du Jesús‑ni nna innaba tisakane ttu bixa kini ibixxinie bixa innábie kini aníha‑chu nna tee ro'okani ukinnikane. ");
INSERT INTO zae_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ka nuha nna bisinkana, rákane: ―Maestru, gwa yúbatu deki lu rinnebalu nu ankaba gwalí, labí retabinlu ge nu inná ka benne, kumu labí rulannilu ttixa anka ka benne. Lu rule'ebinlu ka benne neda ge Tata Do Yebáha attiba ankaba geni. Gwelha unáchu, ¿si gwa ga'anaba kixari'i belhiu nu daa lori'i kixari'i len César nu rinnabia xeniha, o abittuba ak? ¿Si gwagixari'i belhuha, o abittuba ak? ");
INSERT INTO zae_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ttaka lee nna ute da ttebanie nu rulha lekaniha, nianna tti ree kana: ―¿Beaka ruinle ki ichekua ki ibixxiti bixa innía? Nii gwalute ttu belhiu ki ugíaya loni. ");
INSERT INTO zae_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nianna tti begwekane belhuha. Labie nna ree kana: ―¿Nú lo nuní du lo belhiu‑ni lhe nú lá nuní dia xani'a nuní lhe? Lakana nna bekabikana, rákana: ―Lá César nu rinnabia xeniha‑ba nuní dia lo nuní. ");
INSERT INTO zae_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nianna bekabi Jesús‑ni, ree kana: ―Ganna aníha nna gwalugweba César‑ni nu anka geni. Anágaba Tata Do Yebáha nna gwalugwegabe nu anka gebie. Nianna bebanabakinna gebie. ");
INSERT INTO zae_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nianna bisin ttu chupa ka saduceo ata du Jesús‑ni. Ka nuha rákana deki labí reyaka ben ka benne chi uttiha. Nianna tti unnaba tisakane, rákane: ");
INSERT INTO zae_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestru, Moisés‑ni bodha'ane lo yetsi lenri'i, ree: “Ganna ttu nubiyú chi betsá náni, nianna gattina nna anúba xi'inni aka len nuila geniha, la'ania nna teeki edí betsiniha nuila bidabiha kini anáchu nna ka xi'ini aka len nuilaha nna eyakakana ttisidiba xi'in benne chi uttiha.” ");
INSERT INTO zae_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ttu lidú use'e gasi betsi ka nubiyú. Nu xxeniha betsába náni, ttaka uttibana nna lanú xi'inni uka len nuila geniha. ");
INSERT INTO zae_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nianna bedí nu berupaha nuila bidabiha, ttaka bedeattigaba nuha nna anúgaba xi'inkani bedeaka. Aníha‑gaba gwadite nu beyonnaha. ");
INSERT INTO zae_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aníha‑ba gwate iyába gasi betsikani, lanú xi'inkani uka len nuilaha. Iki de nuha nna uttigaba nuilaha. ");
INSERT INTO zae_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nnanna nna unáchu, ganna chi bisia sá eyaka ben ka benne chi uttiha, ¿núla nuila gekani eyaka nuilaha, ki iyába gasi betsikani udo lenkana nuha? ");
INSERT INTO zae_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús‑ni nna bekabie, ree kana: ―Lebi'i rinittibale nu gweala rale, kumu de labí yule nu ra lo ka yetsi ge Tata Do Yebáha lhe labí yule tsitsiba ra lebie lhe. ");
INSERT INTO zae_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kumu ganna chi bisia sá eyaka ben ka benne chi uttiha, la'ania nna nuila lhe nubiyú lhe labíru dina otsá ná ka benneha, nigaba uketike ka xi'inkeha kumu eyakabake attiba ka anjeli se'e yebáha. ");
INSERT INTO zae_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nu rari'i ge ka benne chi uttiha ganna gweyaka benke, nnanna kixxi'ania le: Lebi'i, ¿si lagwa chi belabale lo yetsi ben Moisés‑ni ata rigixxi'e ge xxiti rite loniha? Lhe'e xxitiha nuha unne Tata Do Yebáha, ree Moisés‑ni: “Neti ankaa Diosi ge Abraham‑ni lhe ge Isaac‑ni lhe ge Jacob‑ni lhe.” ");
INSERT INTO zae_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Laxkala Tata Do Yebáha labí anke Diosi ge ka benne chi uttiha, lee anke Diosi ge ka benne anka bani. De nuha nna lebi'i labí yule ge nu rale‑na. ");
INSERT INTO zae_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ttu ka nu rule'enna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni tti biyieninna du Jesús‑ni ridaka lanie ka saduceo‑ni lhe biyieninna deki gwa bekabi tseba Jesús‑ni ge ka nuha, nianna tti ubigana nna unnaba tisane, rana: ―Delo iyá ka tisa bodha'an Tata Do Yebáha uinri'i, ¿nú ka nuha dakaru? ");
INSERT INTO zae_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús‑ni nna bekabie geni, ree na: ―Dakaru tisa nu ra: “Lebi'i ka benne datiale Israel, gwaludo nagale. Tata Do Yebáha, ttúba benneha anke Xxanari'i, lanúru nu attu do ");
INSERT INTO zae_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","lhe anágaba ra: akinle ge Tata Do Yebaa benne anka Xxanaleha itú iki itú lele.” ");
INSERT INTO zae_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tisa nu berupa bodha'an Tata Do Yebáha uinri'i, nuha nna rana: “Akinle ge attu benne atti tteba rakabin gele.” Labí attu tisa tee nu dakaru bodha'ane uinri'i tti nu ra ka tisa‑ni. ");
INSERT INTO zae_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nu rule'enna ka benne nu ra lo bia bennabiha nna rana: ―Tseba bekabilu xa maestru. Gwalíbinlu ralu deki ttúba Tata Do Yebáha do, lanú nu attu do, ");
INSERT INTO zae_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","lhe anágaba nu ralu akinle ge Tata Do Yebáha itú iki itú lele lhe akagabinle ge ka benne atti tteba rakabin gele. Ka tisa‑nila dakaru attichula ka úna lhe ka nimala ruttiri'i, ruteri'i len Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús‑ni nna tti ute danie deki tseba bekabi nu rule'e lo bia bennabiha, nianna tti ree na: ―Lu chi tteba duna akalu benne innabia Tata Do Yebáha lu. Debá la'ania nna lanúru nu beyaxinna innaba tisana Jesús‑ni ge attu bixa. ");
INSERT INTO zae_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Laka du Jesús‑ni lali'a yotuha rule'enie ka benne ka tisa ge Tata Do Yebáha, nianna ree ke: ―¿Galasina nna ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni nna rálakana deki David‑ni ukana xutto Cristuha? ");
INSERT INTO zae_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ki kwinaba David‑ni tti yu'u Espíritu ge Tata Do Yebáha latini nna Espírituha beni kini unnena, rana: Tata Do Yebáha ree Cristu benne runie neti mandaduha: “Utá udo daka ná ben kia. Niiba dholu axtaliba ganna chi bese'a ka nu abittu raka uyúkana lu, kini ulealu ikikani.” ");
INSERT INTO zae_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ki ganna kwinaba David‑ni utixxana lá Cristuha benne runie na mandadu, ¿galasina nna uka David‑ni xutto Cristuha ganna? Ixeru ka benne rudo nagake ge Jesús‑ni nna ru'uba leke ge nu rigixxi'eha. ");
INSERT INTO zae_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús‑ni nna ree ka benne tti due rule'enie keha: ―Gwaluyú gele len ka nu rule'ekinna le nu ra lo bia bennabi bodha'an Moisés‑ni, kumu ka nuná ru'u lekani rekikana len ka xalho ttuni lhe ru'u lekani latsiru ga ka benne kana padiuxi atti reti'ake kana lo ka neda‑na, ");
INSERT INTO zae_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","lhe anágaba ru'ugaba lekani kwiakana lo ka xxila tseru se'e lhe'e ka yo'o ata rudhetiri'i ka tisa ge Tata Do Yebáha, lhe ru'ugaba lekani kwiakana ata anka tseru tti riakana go yetta. ");
INSERT INTO zae_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Anágaba nna riguagabakana ka yo'o ge ka nuila bidabi‑na, nna ukadiba rise'ekana isá rilhapikana tisa len Tata Do Yebáha kini rudheakana lo nu ruinkanaha. Ka nuná adírula elha disa tsitsi uyúkana la'ania. ");
INSERT INTO zae_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús‑ni doe ttu libe lali'a yotuha gaxxaba ata sia ka nu rigu'u ka benne úna lhe'ekani nna rulannie gasina rigu'ukana belhiu. Ixe ka nu tee gekani risinkana rigu'ukana ixeni belhiu lhe'e ka nuha. ");
INSERT INTO zae_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ttaka ttu benne nuila bidabi abittu gebie tee, bisine nna ulu'e chupa ka belhiu to, ka nu lattiruba lidhakakani tee. ");
INSERT INTO zae_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús‑ni nna uxie ka benne rudhetinieha nna ree ke: ―Netiru ria, benne nuila bidabi‑ni anke benne abittu gebie tee nna xxenirula daka belhiu ulu'e attichula nu chi ulu'u iyá ka nu chi ulu'u belhiu, ");
INSERT INTO zae_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","kumu ka nuná ulu'ubakana belhiu nu rexxaba gekani, ttaka benne nuila‑ni anke benne abittu gebie tee nna ulu'ube iyába belhiu tee gebie nu dika ixúnie ki aka banie. ");
INSERT INTO zae_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tti bedá Jesús‑ni ro'o yotuha nna ttu ka benne rudhetinieha nna ree bie: ―¡Maestru, biyúruga, aníliruba anka ka íyya kua‑ni lhe aníliruba anka ka yo'o‑ni lhe! ");
INSERT INTO zae_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús‑ni nna bekabie geni, ree na: ―¿Si gwa rilenlu ka yo'o xeni sia nii? Ka nuní tse'e loobakana. Niruba ttu íyya gekani laa eya'anna iki luesini; iyábakana itampabakana. ");
INSERT INTO zae_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tti do Jesús‑ni iki i'iya ata daa ka ya olivuha daka ata yeki lo yotuha, la'ania nna sun labe unnaba tisa Pedro‑ni lhe Jacobo‑ni lhe Juan‑ni lhe Andrés‑ni lhe, rákane: ");
INSERT INTO zae_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Utixxi'en ri'itu, ¿nuka aka nu ralu‑na lhe bí aka kini unna liina deki chi dabiga aka nu ralu‑na? ");
INSERT INTO zae_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús‑ni nna bekabie, ree kana: ―Gwaluyú gele bittu tsia lele ge ka nu ruin lekani, ");
INSERT INTO zae_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","kumu ixe ka nu isia uinkana ttisidiba netiba nuha ankakana, nianna tti innákana: “Neti ankaa Cristu.” La'ania nna ixeba ka benne dhi yiekana. ");
INSERT INTO zae_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Atti unale deki chi yu'u ka yiesi ritilha len luesikani lhe daa tisa deki ruin ka yiesi itilha len luesikani lhe, bittu gasinle kumu teeki aka aníha. Ttaka labí chi bisia ura lhuxa yiesi lo yu‑ni la'ania, ");
INSERT INTO zae_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","kumu ka yiesi elha‑na ebi'i noo luesikani ttilhakana lhe ka nu rinnabia‑na ebi'i noogaba luesikani, lhe anágaba gattibani yiesi lo yu‑ni ixú lhe isiagaba ubina lhe. La'ania nna si dhuloruba ka benne uyúke elha disa. ");
INSERT INTO zae_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Lebi'i nna gwaluyúla gele, kumu teeki taga'akana le lo ka uxtisi lhe ukulhagabakana le lhe'e ka yo'o ata rudhetiri'i ka tisa ge Tata Do Yebáha lhe axtala arlo ka nu rinnabia xeni tatso dúkana le delo ni'a kia, kini aníha nna lebi'i kixxi'enle kana kia. ");
INSERT INTO zae_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ttaka atti lanila lhuxa yiesi lo yu‑ni, teeki chadhi ka tisa ge Tata Do Yebáha lhe'e iyába ka yiesi se'e itúba yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tti udaxxukana le nna saga'akana le arlo ka uxtisiha, abittu uchacha ikile bixa innále looraha. Suna gwalekabiba tisa ute Espíritu ge Tata Do Yebáha len lebi'i, kumu laa lebi'iga nuha innele, Espírituha‑ba nuha inne. ");
INSERT INTO zae_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","La'ania eyeki ka benne ebi'i noo luesike. Ka nu raka betsikaniha utekana ka betsikaniha lasi ná ka nu uttikana ka nuha, lhe aníha‑gaba uin ka xxudiha len ka xi'inkaniha. Ka xi'inkaniha nna eyekikana ebi'i nookana ka xxudikaniha nna uinkana kini gatti ka benneha. ");
INSERT INTO zae_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Lebi'i nna iyába ka benne utía di lekani le delo ni'a ge ria lele neti. Ttaka benne dhaabie dhu tsitsie lo neda kia axtaliba ganna chi uluxa iyá nu akaha, benneha gwalábe. ");
INSERT INTO zae_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ttaka lebi'i isia sá ganna chi ilenle aka ttu nu tuttíruga satsa ata labí dina akana, delába ge nu satsa utixxi'a profeta Daniel‑ni. (Ata rulabale ka tisa‑ni, gwalutte da nu rákana.) Ganna chi ilenle aka nu satsaha, la'ania nna ka nu se'e daka Judea‑ni teeki uxunnikana tsapikana iki ka i'iya sia niha, ");
INSERT INTO zae_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","nna nu dona iki yo'o geniha abittu eyadina, lhe nigaba eta'ana lhe'e yo'oha saleana ttu bixa, ");
INSERT INTO zae_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","lhe nu dia lhe'exxiha bittu eyyana lhe'e yo'o geniha saxxína jabana geniha. ");
INSERT INTO zae_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Gwalíchiru le ka benne nuila ata nuja xi'inke la'ania, lhe denke ka nuto rasi lhe! ");
INSERT INTO zae_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gwalinnaba len Tata Do Yebáha ki abittu aka nuní tti raka idilhaha, ");
INSERT INTO zae_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","kumu elha disa tsitsi nuha uyú ka benne lhe'e ka sáha, ttu elha disa nu labí chi uka itú uleki Tata Do Yebáha yiesi lo yu‑ni, la'anialiba nna aka nuha lhe nigaba labíru aka luesi elha disaha nu si daa lhe. ");
INSERT INTO zae_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kumu Tata Do Yebáha, ganna ttixka abíba odatsie ka sáha, la'ania nna niru ttú benne labí lhaabie, iyábake gattike. Ttaka lee odatsie ka sáha kumu de rakanie ge ka benne chi bekwebie. ");
INSERT INTO zae_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ganna nuxa gana le la'ania: “Gwalulanniruga, ne benne anka Cristuha du nii”, o si innána: “Gwalugíaruga, ne bie du naa”, abittu tsia lele ge nu inná aníha. ");
INSERT INTO zae_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kumu isia ka nu labí gwalí ankakana Cristu lhe isia ka nu labí gwalí ankakana profeta ge Tata Do Yebáha nna uinkana ka milagru lhe uinkana ttu bixa nu dika ebanani ka benne geni. Aníha uinkana kini dhi yiekana ke. Gaxa axtala ka benne chi bekwe Tata Do Yebáha ki akake gebie, axtala ka benneha dhi yiekana ki tsia leke gekani. ");
INSERT INTO zae_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Laxkala lebi'i gwaluyú gele. Nnannali chi rigixxi'ania le iyá nu aka la'ania. ");
INSERT INTO zae_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Iki de chi ute ka sá tti uyú ka benne elha disaha, la'ania nna echulha lo tatubisa‑na nna nanto beo‑na nna labíru ku'ubie xiani. ");
INSERT INTO zae_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ka beli sia gwetsáha nna iginnibakana lo yu lhe adíru ka nu ra xxeni lekani se'e gwetsáha igubigabakana. ");
INSERT INTO zae_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","La'ania nna neti benne daya yebáha, iláni ka benne neti dedáya yebáha lhe'e beaha ra tsitsi lasia lhe raka lhalhaba xiani kia lhe. ");
INSERT INTO zae_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nianna tti idhelhaa ka anjeli kiaha itú tte yiesi lo yu‑ni, axtaba ata riluxa yebáha lhe axtaba ata riluxa yiesi lo yu‑ni lhe. Idhelhaa ke kini tsiake ottupake ka benne chi bekwe Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Gwalutte dáruga ge ya higuha. Nuha ganna chi renettu ka lo náni lhe reria ka lhaga geni lhe, la'ania nna chi yule deki chiba dabigana eta'a iyya. ");
INSERT INTO zae_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Anágaba lebi'i ganna chi ilenle aka nu chi ria‑ni, la'ania nna chi yule deki chi tteba dabiga esiaya. ");
INSERT INTO zae_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Netiru ria, atti isia sá aka iyá ka nuní, ka benne se'e nnanna labí chi uttike la'ania. ");
INSERT INTO zae_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yebáha lhe yiesi lo yu‑ni tse'e loobakana, ttaka ka tisa chi ria‑ni teekiba aka nu ra ka benne‑ni. ");
INSERT INTO zae_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Ttaka la sá lhe la ura aka nuha, lanú nu yuna, ni ka anjeli ge Tata Do Yebáha yuke lhe nigaba neti benne ankaa Xi'inieha a yua, sunruba Tataha yue. ");
INSERT INTO zae_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’De nuha nna gwaltse'e tsitsi lhe gwaltse'e ubeda lhe gwalinne len Tata Do Yebáha lhe kumu lebi'i labí yule nukaxa aka nuha. ");
INSERT INTO zae_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gwaluni attiba beni ttu benne birie die idittu nna bedha'ane yo'o geeha len ka nu reni lo sina geeha. Ttu ttu ka nuha begwebie kana sina ralhakana uinkana, nna nu ridú ridhalina lhe rodheana ro'o yo'oha nna ree nuha: “Ulanni tsitsilu ro'o yo'o kia‑ni kini anuttu nu ga'a.” ");
INSERT INTO zae_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Laxkala lebi'i gwaltse'e ubeda kumu labí yule nukaxa esia xxana yo'oha, si esie chi dia ralha o esie riluela, o esie atti chi ribesi ka chinka‑na lhe o si esie tti chi daa tsani lhe, ");
INSERT INTO zae_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","kini ni kina ttu nnelaba esie nna etexxake le te'adhile. ");
INSERT INTO zae_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nu xpeya le‑ni, nunígaba upeya iyá ka benne: ¡Gwaltse'e tenná! ");
INSERT INTO zae_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A chupa ubisaba riyasa isia laní Pascua tti ro ka benne Israel‑ni yettaxtila nu abittu kua dii sela lhe'eni. Ka nu loni ge ka bixxudiha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni, ka nuha regila lekani bixa ibixxini Jesús‑ni innee kini aníha‑chu nna tee ro'okani udaxxukane nna uttikane. ");
INSERT INTO zae_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ttaka lakana nna ra luesikani: ―Bittu uinri'i nuha tti raka laníha kini ka utsatsari'i ka benne. ");
INSERT INTO zae_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús‑ni doe lhe'esi Betania lhe'e lisi Simón nu uka latini yiesu nu tee láni lepra. Tti doe go yettaha bisin ttu nuila denna ttu re'e to ankana ge íyya ragalha. Íyya ragalhaha tee láni alabastro. Lhe'e re'e toha ta'a seti nu rure ixixxi nu raka xxatta yaxi. Setiha ankana taga'a ge ttu yaga tee láni nardo. Nuilaha nna ulha'ana re'e toha nna bedo ttattana seti ta'a lhe'e nuha iki Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ttu chupa ka nu se'e niha, nna bisa'akinna nna ra luesikani: ―¿Beaka kwentaba bedelha lattibana seti‑na? ");
INSERT INTO zae_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","A bito'ochila nuná gwate tsunna gayua (300) denario. Belhuha nna dhi ka benne dii ata abittu tee geke. Nianna rinnekana ge nuilaha. ");
INSERT INTO zae_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús‑ni nna ree kana: ―Naa la rena. Bittu innele geni, kumu ttu nu tse nuní chi benna len neti. ");
INSERT INTO zae_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ka benne dii abittu geke tee satíaba tse'e ka benne‑na len lebi'i nna gwakaba gele ute nále len ka benne‑na tti aka lele, ttaka neti labí satía dhoa len lebi'i. ");
INSERT INTO zae_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nuila‑ni benba nuní nu ukaba geni; chi begu'u gaana seti rure ixixxi‑ni latia kini igatsia ganna chi uttiaha. ");
INSERT INTO zae_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Netiru ria, itúba yiesi lo yu‑ni gaxaba lhe'e ka yiesi ata kixxi'a ka benne ka tisa kia‑ni, kixxi'agabake ge nuila‑ni. Aníha kini sadú le ka benne ge nu benna‑ni. ");
INSERT INTO zae_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote, ttu ka benne tsi'inu rudhetini Jesús‑ni (12), ugíana gwanne lenna ka nu loni ge ka bixxudiha kini utena Jesús‑ni lasi nákani. ");
INSERT INTO zae_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Lakana nna bedeakabakinna ge nu rana kanaha, nianna bisia ro'okani ugwekana na belhiu. Lana nna udulo ttebana begila leni ki gaxasina utena Jesús‑ni lasi nákani. ");
INSERT INTO zae_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Sá neru ge laní Pascua tti ro ka benne Israel‑ni yettaxtila nu abittu kua dii dia ikiniha lhe la'aniagaba nuha ruttike ka neru re'eni to roke laníha, nianna tti unnaba tisa ka benne rudhetini Jesús‑ni, ráke bie: ―¿Gá raka lelu tsiatu sentu irse ki gori'i laní Pascua‑ni? ");
INSERT INTO zae_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Lee nna udhelhe chupa ka benne rudhetinieha nna ree ke: ―Gwaltsia lhe'e yiesi‑na. Naa eti'ale ttu nubiyú dedána denojana ttu re'e inda nna gwaltsia gwasanalha na. ");
INSERT INTO zae_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ata eta'anaha, niha gwaligasi xxana yo'oha: “Aní ra maestruha: ¿Gon‑na do ttu cuartu ata go irse lania ka benne rudhetinia‑ni irse ge laní Pascua?” ");
INSERT INTO zae_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Xxana yo'oha nna ule'enna le yo'o nu do berupa kuaha. Niha chi do tse ttu cuartu xeni. Lhe'e nuha gwaluin irse ki gori'i. ");
INSERT INTO zae_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ka benne rudhetinieha nna dia ttebake uta'ake lhe'esiha nna gwaxxakabake iyába atti tteba chi ree keha. Niha benke irse ge laní Pascua. ");
INSERT INTO zae_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tti chi ralhaha nna bisin Jesús‑ni len ka benne tsi'inu rudhetinieha (12). ");
INSERT INTO zae_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tti chi se'eke ro'o mexaha go irse, nianna tti ree: ―Netiru ria, delo iyále se'ele go len neti ro'o mexa‑ni nuxa ttúle nuní utele neti lasi ná ka nu uttikana neti. ");
INSERT INTO zae_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Lake nna bedú si'i ttebana leke nna ttu ttubake unnaba tisake Jesús‑ni, ráke: ―¿Si bittuba neti nuná xa tata? ");
INSERT INTO zae_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Lee nna bekabie, ree ke: ―Delo iyá tsi'inule (12) se'ele nii, ttúle nu rugutule lhe'e ttúba ye'ena‑ni len neti, lana nuha utena neti lasi ná ka nu uttikana netiha. ");
INSERT INTO zae_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Neti benne daya yebáha eya'abaa attiba chi ga'anna lo ka yetsi ge Tata Do Yebáha. Ttaka gwalíchiru le nu utena neti lasi ná ka nu uttikana neti. Tserula saríana na ganna abittu ulina, a laa kila ulina. ");
INSERT INTO zae_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Laka se'eke goha nna bedaxxu Jesús‑ni yettaxtilaha nna begwebie Tata Do Yebáha ixkixaru. Nianna tti ulha'abie lhe'e benneha nna begwebie ka benne rudhetinieha nna ree ke: ―Gwaligo yettaxtila‑ni. Benne‑ni anke bela latia. ");
INSERT INTO zae_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Iki de nuha nna tti bedaxxue xiga ta'a vinuha nna begwebie ixkixaru Tata Do Yebáha, nianna tti begwebie ka benneha nna iyábake u'uyake vinuha. ");
INSERT INTO zae_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nianna tti ree ke: ―Nuní ankana reni kia rugwena lidhaka tisa chi bodha'an Tata Do Yebáha len ka benne. Reni‑ni ilalina kini odilána ixe ka benne. ");
INSERT INTO zae_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Netiru ria, debá nnannaba ri'iya vinu‑ni, labíru i'iyaa na, gannaliba chi besinaa ata rinnabia Tata Do Yebáha, la'anialiba nna ede'eyaa vinu kubi attu libe. ");
INSERT INTO zae_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iki de chi bilhake ttu le'a to, nianna tti biriake diake iki i'iya ata daa ka ya olivuha. ");
INSERT INTO zae_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tti chi se'eke iki i'iyaha, nianna ra Jesús‑ni ka benne rudhetinieha: ―Nnolha iyábale isatsale udhá ikile neti. Akaba attiba chi unne Tata Do Yebáha lo ka yetsi geeha, tti ree: “Neti uttibaa nu reki lo ka neruha nna ka neruha nna isatsa ttebakana.” ");
INSERT INTO zae_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Rágaba Jesús‑ni: ―Ttaka iki de chi beyaka bania lo elhuttiha, la'ania nna eya'a gaaya enerua lole esinaa daka Galilea‑ni, delola nna esiale. ");
INSERT INTO zae_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro‑ni nna rane: ―Meskiba adí ka nuní udhá ikikani lu, neti labí udhá ikia lu. ");
INSERT INTO zae_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús‑ni nna rabie na: ―Netiru ria, nnolha tti lanila kwesi chinkaha chupa libe, lu tsunna libela chi bedhea lelu abittu ridí ro'olu deki ankabienlu neti. ");
INSERT INTO zae_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ttaka Pedro‑ni nna ttu dúbana rana: ―Meskiba gattia lenlu, labí innía deki labí ankabiati lu. Aníha‑gaba ra adí ka benneha. ");
INSERT INTO zae_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nianna dia Jesús‑ni len ka benne rudhetinieha ttu latti ata tee láni Getsemaní, nianna ree ka benneha: ―Nii gwaltse'e, laka neti tanne lania Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Chebe Pedro‑ni lhe Jacobo‑ni lhe Juan‑ni lhe, nianna tti uduloe bedú si'ina lebie lhe bedú xxattane lhe. ");
INSERT INTO zae_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nianna tti ree kana: ―Yalhá si'i du lasia. Gwanalu chiba gattia rakati. Nii gwaltse'e nna bittu ga'adhile. ");
INSERT INTO zae_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Lee nna biru'une attu latti daka aná nna bedú xibie bere loe lo yu, nianna tti unnabe len Tata Do Yebáha kini gaa godilábe bie lo nu sateeha. ");
INSERT INTO zae_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nianna ree: ―Tata to kia, nu diru innálu, benchi kini abittu uyúa elha disa‑ni, kumu lu gwakaba gelu uinlu iyá. Ttaka labí nu innía aka, sinuki nu innába kwinalu aka. ");
INSERT INTO zae_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tti beyekie ata se'e ka benne tsunnaha nna gwaxxake ke te'adhilake. Nianna tti ree Pedro‑ni: ―Simón Pedro, ¿si te'adhibalu? ¿Si bi gwa udaalu dho tennálu kwadiba ttu ura? ");
INSERT INTO zae_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Gwaltse'e tenná lhe gwalinnaba len Tata Do Yebáha kini abittu dhi yie nu xxegwiha le nna eyadi gaale. Gwalí galá, lebi'i gwa rakabinle tse'e tennále, ttaka bela latile‑na labí ridaana uchíana. ");
INSERT INTO zae_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nianna tti bedeyekie attu libe nna gwadinne lenbie Tata Do Yebáha, bodeki adakabe ka tisa nu chi ree benneha. ");
INSERT INTO zae_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tti bedeyekie besine ata se'e ka benneha attu libe nna gwadixxakagabe ke dedete'adhigabake kumu de ta'a xxatta loke bisiela nna abígaba yuke bixa ekabike gebie. ");
INSERT INTO zae_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tti beyekie besine ata se'e ka benneha nu beyonna libeha, nianna tti redeabie ke: ―¿Si sa tebale te'adhile? ¡Ttanába! Chinka gwaleyadha, kumu neti benne daya yebáha chiba bisia ura nuní utekana neti lasi ná ka nu runi tulha. ");
INSERT INTO zae_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Chinka gwaleyadha nna gwaleyaa! ¡Ne nu utena neti lasi ná ka nu uttikana netiha, chi daa naa! ");
INSERT INTO zae_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sa dula Jesús‑ni gwenne, ttiru chi bisin Judas nu selana lhe'e ka benne tsi'inu (12) rudhetinieha, dia lenna ixe ka nu denkana yaga lhe espada lhe. Ka nuha udhelha ka nu loni ge ka bixxudiha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe, anágaba diagaba ka benneola ge ka nu Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas nu utena Jesús‑ni lasi ná ka nu udaxxukaneha nna chi rana ka nuha: ―Nu ibigaa goa xxaganiha, lana nuha. Gwaludaxxu na nna gwaluxxika na kini abittu elána. ");
INSERT INTO zae_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Aníoka nna tti bisin Judas‑ni ata du Jesús‑ni nna tti ubigana nna rane: ―Maestru. Nianna tti utona xxage. ");
INSERT INTO zae_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ka nuha nna bedaxxu ttebakane nna dechekane. ");
INSERT INTO zae_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ttaka ttu ka benne du len Jesús‑ni nna ulea ttebe espada geeha nna uchúe naga nu riben lo sina ge bixxudi xeniha. ");
INSERT INTO zae_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nianna ra Jesús‑ni kana: ―¿Beaka ttiba nu daa gwedaxxu ubana dale gwedaxxu neti denle espada lhe yaga lhe? ");
INSERT INTO zae_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ki ttu ttu sába dua len lebi'i rule'enia le ka tisa ro'o yotu‑na nna abí chiga bedaxxule neti. Ttaka teeki aka aní kini saxxína nu ra lo ka yetsi ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Looraha nna iyába ka benne rudhetinieha ttúbe bedúke nna bexunnilake. ");
INSERT INTO zae_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sunruba ttu nu kwiti diana danalhana Jesús‑ni, nukuna ttu lari nna lariha‑ba biyaxxukinna. ");
INSERT INTO zae_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ttaka lana nna belhá bixxina lari nukunaha nna tuntubana bexunnina. ");
INSERT INTO zae_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nianna bisin lenkana Jesús‑ni arlo bixxudi xeniha nna betupa tteba iyába ka nu loni ge ka bixxudiha lhe ka benneola ge ka nu Israel‑ni lhe anágaba ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro‑ni nna idittuliba danalhana Jesús‑ni bisinna lali'a yo'o ata do bixxudi xeniha, nna niha‑ba urena len ka nu rise'e gweyú ro'o lisi bixxudi xeniha rutsa'ana ro'o tee. ");
INSERT INTO zae_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ka nu loni ge ka bixxudiha lhe iyába ka nu runi elhuxtisi ge ka nu Israel‑ni, yu'ukana regila lekani bixa usiakana iki Jesús‑ni kini anáchu tee ro'okani uttikane, ttaka labí raxxakakana ttu bixa. ");
INSERT INTO zae_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kumu ixe ka nu ruin lekani rusiakana ikie, rákana deki runie ttu bixa, ttaka labí turo'o raxxína nu rinnekanaha. ");
INSERT INTO zae_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ttu chupakana udú liikana nna rusiakana ikie nu labí lii nna rákana: ");
INSERT INTO zae_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Ri'itu biyienintu rana: “Neti uttampaa yotu‑ni, yotu nu ben ka benne se'e yiesi lo yu‑ni. Nianna delo tsunna ubisaba nna chi elhidhaa attu yotu nu labí uin ka benne se'e yiesi lo yu‑ni.” ");
INSERT INTO zae_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ttaka nigaba aníha nna labí raxxína turo'o len nu rinnekanaha. ");
INSERT INTO zae_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nianna tti udú lii bixxudi xeniha lagwi ge ka benne tupa niha nna rana Jesús‑ni: ―¿Bíunni rusia ka nuní ikilu? ¿Si lagwa gwekabilu ge nu rákana‑ni? ");
INSERT INTO zae_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ttaka Jesús‑ni siiba uke, labí bekabie geni. Nianna tti bedennaba tisa bixxudi xeniha bie attu libe, rane: ―¿Si lu ankalu Cristu Xi'in benne anke le'aha? ");
INSERT INTO zae_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Lee nna bekabie geni, ree: ―Ila, neti galá. Lebi'i gwalábinle neti benne daya yebáha dhoa daka ná bani ge benne ra tsitsi xxatta leeha lhe ilágabinle neti dedáya yebáha lhe'e bea. ");
INSERT INTO zae_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tti biyienin bixxudi xeniha nu ra Jesús‑ni nna ucheda bixxiba xoni kini ula'a deki rise'enna, nianna tti rana: ―Nuruala riyasinri'i nuxa kixxi'ana bixa ben nuní. ");
INSERT INTO zae_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ki kwinaba lebi'i chi biyienin nagale rorexxa gaalana Tata Do Yebáha. Lebi'i nna, ¿bí rakinle? Nianna iyábakana beda'a ro'okani rákana deki ralhaba Jesús‑ni gattie. ");
INSERT INTO zae_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Attu chupakana nna udulokana bettuttu xxenkani lo Jesús‑ni lhe bettokana loe lhe rudhenkane lhe. Nianna tti rákane: ―Unne ya'achu, ¿núnni rudhenna lu? Lhe anágaba ka nu rise'e gweyú ro'o yotuha ribeagabakana gi ro'e. ");
INSERT INTO zae_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro‑ni nna duna rre lali'a yo'o ge bixxudi xeniha, nianna tti ute ttu ka nuila riben sina lhe'e yo'oha, ");
INSERT INTO zae_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","nna tti bilen nuha Pedro‑ni dona kwe'e giha rutsa'ana, nianna belanni tseaxabana loni nna tti rana na: ―Iyágabalu danalhalu Jesús ge Nazaret‑ni. ");
INSERT INTO zae_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro‑ni nna labí uxí ro'oni nna rálana nuilaha: ―Deloxa, labí yua bí ge nuná rinnelu. Nianna tti deyya Pedro‑ni eriana ro'o yo'oha nna uresi tteba chinkaha. ");
INSERT INTO zae_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tti bedeláni nuilaha na attu libe, nianna redeana ka nu se'e niha: ―Nubiyú du nii, ttu ka nu danalhakana Jesús‑niba nuní. ");
INSERT INTO zae_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ttaka lana nna attu libe, labí bededí ro'oni. Nianna attu sattiruba nna ka nu se'e niha nna redeakana Pedro‑ni: ―Gwalíba lu ankalu ttu ka nu selalu nuná, kumu lu ankalu ge Galilea. ");
INSERT INTO zae_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lana nna rana: ―Gwalígatixa, labí ankabiati nubiyú rale‑na. Tata Do Yebáha ugwebie neti elha disa ganna abíba liiti. ");
INSERT INTO zae_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Looraha nna bedebesi chinkaha attu libe. Nianna tti gwadú le Pedro‑ni nu ra Jesús‑ni na tti ree na: “Lanila kwesi chinkaha chupa libe, lu beyonna libela chi bedhea lelu abittu ridí ro'olu deki ankabienlu neti.” Nianna tti uresi tteba Pedro‑ni. ");
INSERT INTO zae_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Dila tteba bitupa ka nu loni ge ka bixxudiha lhe ka benneola ge ka nu Israel‑ni lhe, anágaba ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe adíru ka nu ruinkana elhuxtisi gekaniha lhe, nianna beda'a ro'okani nna bexxigakana Jesús‑ni nna chekane gwaga'akane lo Pilato‑ni. ");
INSERT INTO zae_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato‑ni nna unnaba tisane, rane: ―¿Si lu nuní ankalu nu rinnabia ge ka benne Israel‑ni? Labie nna bekabie geni, ree na: ―Luba chi ra deki nuná ankaa xa. ");
INSERT INTO zae_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kumu ka nu loni ge ka bixxudiha ixeba nu rusiakana ikie, ");
INSERT INTO zae_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","de nuha nna bedennaba tisa Pilato‑nie attu libe, rane: ―¿Si lagwa gwekabilu? Biyúruga ixeba nu rusia ka nuní ikilu. ");
INSERT INTO zae_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ttaka Jesús‑ni nna labí bekabie geni. De nuha nna Pilato‑ni rugía ya'abana de labí rekabie. ");
INSERT INTO zae_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kua risiaba laní Pascua rodilaa Pilato‑ni ttu ka nu tee lisiyya. Nu rakaba le ka benne olhána. ");
INSERT INTO zae_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","La'aniagaba tee ttu nubiyú lisiyya lána Barrabás. Tena lisiyya len adí ka luesini. Lakana bese'e disakana lo ka uxtisi nna benkana elhutti. ");
INSERT INTO zae_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nianna ixeru ka benne bisinke ata do Pilato‑ni nna unnabake lenna kini odilána ttu nu tee lhe'e lisiyya attiba labinna ruinna ttu ttu ida. ");
INSERT INTO zae_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nianna tti bekabi Pilato‑ni gekani, rana kana: ―Lebi'i benne Israel, ¿si gwa raka lele odiláya nu rinnabia gele‑ni? ");
INSERT INTO zae_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Aníha ra Pilato‑ni kumu rite dábinna deki ka nu loni ge ka bixxudiha, de ritisibakinna Jesús‑ni nna gwaga'akane loni. ");
INSERT INTO zae_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","12","Nianna tti redea Pilato‑ni kana attu libe: ―Nianna, ¿bí raka lele udhakaa nu tenle láni nu rinnabia gele? ");
INSERT INTO zae_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Lakana nna ribesi'akana idisa, rákana: ―¡Betá nuná lo ya kurusi! ");
INSERT INTO zae_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ttaka Pilato‑ni nna rana kana: ―¿Beaka? ¿Bí nu satsa ben nuní? Ttaka lakana nna adíla idisa ribesi'akana, rákana: ―¡Betá nuná lo ya kurusi! ");
INSERT INTO zae_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ttaka Pilato‑ni, de ruinna kini eya'an tsena len ka benne, aníoka nna bolhána Barrabás‑ni beria nuha lisiyya. Nianna tti udhelha Pilato‑ni bekulhakana Jesús‑ni. Iki de nuha nna botene lasi nákani kini utákane lo ya kurusi. ");
INSERT INTO zae_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nianna che ka soldaduha bie lali'a guskadu ata do nu rinnabia ge Roma‑ni. Niha bottupakana iyá xea ka soldaduha ");
INSERT INTO zae_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","nna tti begukukane ttu lari xiná chulha. Nianna benkana ttu corona yetsi nna ulu'ukana ikie ");
INSERT INTO zae_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","nna udulo ttebakana delo tisaba rinnekana idisa, rákane: ―¡Xxeni ra lelu xa nu rinnabia ge ka nu Israel! ");
INSERT INTO zae_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nianna tti riginkana ikie len ttu vara ge nu rinnabia lhe ruttuttu xxenkani loe nna tti riyettakana rudú xibikani arloe. ");
INSERT INTO zae_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Iki de chi bedhaka xiikaneha, nianna tti bebeakana latie lari xináha nna bogukukane ka xoeha, nianna tti uleakane ki utákane lo ya kurusiha. ");
INSERT INTO zae_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ka soldaduha nujakinna Jesús‑ni ya kurusiha. Lo neda dia lenkaneha, niha beti'akana Simón ge lhe'esi Cirene, xxudi ka Alejandro‑ni lhe Rufo‑ni lhe. Benneha dedábie ugíe lhe'exxi. Nianna bedo doelha ka soldaduha bie kini uje kurusi ge Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nianna tti dia lenkana Jesús‑ni nna bisin lenkane ttu latti ata tee láni Gólgota. (“Gólgota” dienna innána: Bega Iki Nu Yatti.) ");
INSERT INTO zae_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Niha begwekane vinu chixxina nu xixxi tee láni mirra, ttaka lee nna labí uka lebie i'iye vinuha. ");
INSERT INTO zae_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nianna tti betákane lo ya kurusiha. Ka soldaduha nna bedelhakana suerti kini elha'akana ka xo Jesús‑ni kini ula'ana nú ka xoeha eche ttu ttukana. ");
INSERT INTO zae_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Retin jaa dila nuha betákane lo ya kurusiha. ");
INSERT INTO zae_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nianna tti betákana ttu breta xekie ata rigixxi'a bí lo ni'a ge betákane lo ya kurusiha. Lo bretaha dia ra: “Nuní ankana nu rinnabia ge ka benne Israel.” ");
INSERT INTO zae_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Betágabakana a chupa ka nubiyú lo ka ya kurusi. Ka nuha benkana ubana. Ttúna betákana daka ná banie nna attuna nna betákana daka ná yattie. ");
INSERT INTO zae_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Aníha ki gwado tisa ge nu ra lo ka yetsi ge Tata Do Yebáha, ata dia ra: “Betselabakane len ka nu ruin tulhaha.” ");
INSERT INTO zae_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ka nu rite ata taabieha nna ruttába ikikani rulisa xxattakane, rákana: ―¡Kaxa! ¡Lu ralu deki ottampalu yotu‑na nna delo tsunna ubisaba chi elhidhalu na! ");
INSERT INTO zae_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Ganna gwalíginlu nna titúbalu benchu ki lhaalu lo ya kurusi‑na nna beyadichu! ");
INSERT INTO zae_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aníha‑gaba ruin ka nu loni ge ka bixxudiha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni, rulisa xiikane nna ra luesikani: ―Ki ka benne subi gwa bodilána, ttaka lana nna a raka geni lhaa titúbana lo ya kurusi‑na. ");
INSERT INTO zae_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Ki rana deki ankana Cristu nu rinnabia ge ka benne Israel‑ni, gwelha eyadichuna ki ilenri'i, kini anáchu nna ri'i tsia leri'i! Anágaba axtagaba ka nu taa len Jesús‑ni lo ka ya kurusiha rulisagabakane. ");
INSERT INTO zae_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tti chi begwena retin tsi'inuha (12) itúba yiesi lo yu‑ni bechulha nna axtaliba retin tsunnaha beyani. ");
INSERT INTO zae_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","La uraha‑gaba nna uresi'a Jesús‑ni itú lebie, ree: ―Eloi, Eloi, ¿lama sabactani? ―Tisa‑ni dienna innána: Tata Do Yebaa kia, Tata Do Yebaa kia, ¿beaka rudhá ikilu neti? ");
INSERT INTO zae_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Adí ka nu se'e niha, tti biyienkinna nu unneeha, nianna ra luesikani: ―Gwaludoruga nagale, chi raxina profeta Elías‑ni. ");
INSERT INTO zae_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nianna tti biresu tteba ttu nubiyú du niha gwaxxína ttu xunu nna bodibidhana nuha len vinu idí, nna tti bexxikana nuha lo ttu iyyaxtila nna bedona nuha ro'o Jesús‑ni ki i'iye. Nianna rana: ―Naa la taana. Ulannichuri'i si gwita Elías‑ni echidana na lo ya kurusi‑na. ");
INSERT INTO zae_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús‑ni nna uresi'e idisa, nianna utti ttebe. ");
INSERT INTO zae_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Looraha nna bireda lari daa lhe'e yotuha, chubaa tí uka nuha biredana. Udulo xekini nna axtaba xani'ani bireda. ");
INSERT INTO zae_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soldadu nu baninna ttu gayua (100) ka soldadu ge Roma‑ni, nuha duna gaxxaba arlo Jesús‑ni nna tti biyieninna uresi'e lhe tti bilenna gasina uttie, nianna tti unnena, rana: ―Nubiyú‑ni gwalíba anka nuní Xi'in Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Se'egaba ttu chupa ka benne nuila, idittuliba se'eke rulannike. Lhe'e ka benneha sela María Magdalena lhe Salomé lhe. Niha‑gaba du María nan ge José‑ni lhe Jacobo nu gwexxaha lhe. ");
INSERT INTO zae_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ka benne nuila‑ni nuha gwanalhake Jesús‑ni lhe bete náke lenbie tti rekie daka Galilea‑ni. Ata se'eke gwelanniha, niha‑gaba se'eru ixe ka nuila ka benne ugía lenke bie Jerusalén‑ni. ");
INSERT INTO zae_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tti chi ulha sá viarna, la sáha nuha chi rese'e tse ka benne Israel‑ni ki udaxxuke sá reyaka lekeha, ");
INSERT INTO zae_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","la'ania nna ugía José benne lhe'esi Arimatea, benneha labí usinie gwatte'e lo Pilato‑ni kini rennabe echide Jesús‑ni lo ya kurusiha. José‑ni anke ttu ka nu resá lagwi ge ka nu runi elhuxtisi ge ka benne Israel‑ni lhe anágaba dogabe ribede isia sá innabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato‑ni uka ttebinna tti binana deki chiba utti Jesús‑ni. Nianna uxi ttebana soldadu nu baninna adí ka soldaduha ki unnaba tisana nuha ganna si gwalí chi uttie. ");
INSERT INTO zae_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tti utixxi'en soldaduha na deki gwalíba chi utti Jesús‑ni, nianna bote ttebane len José‑ni. ");
INSERT INTO zae_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José‑ni nna uyo'ona ttu lari sibi nna tti bechidana Jesús‑ni nna bottesine lhe'e lariha, nianna gwakatsine lhe'e ttu baa uche'enna lhe'e ttu íyya daa niha. Nianna tti bottulhuna ttu íyya nna gwadheana ro'o yieru baaha. ");
INSERT INTO zae_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena‑ni lhe María nan ge José‑ni lhe, lake bilákanie ata bigatsi Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tti chi ute sá tti reyaka le ka benne Israel‑ni, María Magdalena‑ni lhe Salomé‑ni lhe María nan ge Jacobo‑ni lhe uyo'oke ixe loo ka nu rure ixixxi kini sattabike lati Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","La dila bedulo xumanuha nna dila tteba si dáruba riria tatubisa‑na, dia ka benne nuilaha ata bigatsi Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Laka yu'uke nedaha nna ra luesike: ―¿Núru nuha kuana íyya yaya ro'o yieru baaha ganna? ");
INSERT INTO zae_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Aníha ráke kumu yalhá xeni anka íyyaha. Ttaka atti belannike ro'o yieru baaha nna bilákanie chiba bisila íyyaha. ");
INSERT INTO zae_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tti uta'ake lhe'e yieru baaha nna bilákanie do ttu nubiyú kwiti nukuna ttu xo ttuni. Sitsi túba anka xoniha nna dona daka ná bani ge yieru baaha. Ka benne nuilaha nna yalhá usikanie. ");
INSERT INTO zae_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nubiyúha nna rana ke: ―¡Bittu gasinle! Lebi'i regilale Jesús ge Nazaret benne betákana lo ya kurusiha. Benneha chiba beyaka benbie. Lanúrue tee nii. Gwalulanniruga ata utixxakaneha. ");
INSERT INTO zae_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Gwaleyya nna gwaligasi ka benne rudhetinieha lhe gwaligasi Pedro‑ni lhe, daka Galilea‑nila chi deyye daneru gaabie nna niha‑liba ilenlee, attiba chi rabie le tti sa reki lenleha. ");
INSERT INTO zae_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ka benne nuilaha nna boxunni ttebake beriake ro'o yieru baaha kumu rasibakanie lhe rixidibake lhe. Lanú nu utixxi'akanie kumu de si rasilakanie. ");
INSERT INTO zae_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","La sá tti bedú ni'a xumanuha, beyaka ben Jesús‑ni. Tti chi daa tsaniha, lade'a tte bele'e loe len María Magdalena‑ni, benne bebeabie gasi ka espíritu xxegwiha latie. ");
INSERT INTO zae_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Benne nuilaha nna ugíe gwattixxi'anie ka benne gwanalhake Jesús‑ni tti do benbieha. Ka benneha se'eke du si'i leke lhe ribesike lhe. ");
INSERT INTO zae_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tti biyienkanie deki anka benba Jesús‑ni lhe deki chi bilen María‑nie lhe, lake nna laa ugía leke ge benneha. ");
INSERT INTO zae_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Delola nna attu ya lela bodola'a lo Jesús‑ni len a chupa ka benne gwanalhake bieha. Ka benneha yu'uke neda diake lhe'exxi. ");
INSERT INTO zae_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ka benneha nna beyekike gwattixxi'akanie adí ka benneha, ttaka nigaba ge ka benne chupaha a ugía leke. ");
INSERT INTO zae_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Iki deliba nuha nna tti bele'e lo Jesús‑ni len ka benne sineaha tti yu'uke go yettaha. Utise ke kumu de ttu tsaba labí ridielhake tsia leke ge ka benne chi bilákanie bie deki beyaka banie. ");
INSERT INTO zae_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nianna tti ra Jesús‑ni ke: ―Gwaltsia itú tte yiesi lo yu‑ni nna gwalikixxi'ani iyá ka benne ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ka benne tsia leke neti nna gadike inda, ka benneha godilába Tata Do Yebáha ke. Ttaka ka nu abittu tsia lekani neti, urixxi ukinnibe kana. ");
INSERT INTO zae_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ka nuní ka milagru uni ka nu tsia lekani neti: neti udettikana tti ebeakana ka espíritu xxegwi yu'u lati ka benne, lhe anágaba innegabakana attu tisa subi, ");
INSERT INTO zae_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","lhe meskiba udaxxukana ttu belha nna labí kisi'a nuha kana, lhe anágaba ganna i'iyakana bixa ttu nu dia venenu ikini labí bi dhakakana lhe ttixka ixxua nákani iki ka benne rani nna gweyakaba ka benneha. ");
INSERT INTO zae_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Iki de unne Jesús benne anke Xxanari'iha len ka benne sinea bedhetinieha, nianna tti beyapie deyye yebáha nna besine udoe daka ná ben ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ka benne bedhetinieha nna biriabake rigixxi'ake ge Jesús‑ni iyá laduba nna labe due rute nábie lenke, lhe anágaba len ka milagru ruinkeha rula'a deki nu rigixxi'akeha, nu gwalíba anka nuha. Amén");
INSERT INTO zae_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ixe ka benne chi benke ukuake latsiru lo yetsi ka tisa ata rigixxi'a ge nu ben Jesús‑ni lagwi geri'i. ");
INSERT INTO zae_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ukaba atti tteba chi utixxi'a ka benne sisi'a tte bilákanie nu ukaha, nianna tti bixúke lo sina ge Tata Do Yebáha utixxi'ake ka tisa geeha. ");
INSERT INTO zae_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Anágaba neti xa tata Teófilo, iki de chi ugwekia ulea liia gaxattiga siná udulo desdeli sisi'a tteha, nianna ukati ukuaya ka tisa‑ni latsiru lo yetsi kini idhelhaa na len kwinalu, ");
INSERT INTO zae_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kini anáchu nna lu una tselu gaxasinattiga uka iyá nu chi bele'ekanie lu. ");
INSERT INTO zae_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tti uka Herodes‑ni nu rinnabia daka Judea, la'ania udo ttu benne uke bixxudi utta lábie Zacarías. Benneha sele lhe'e ttu dhi ka bixxudi nna uke luesi bixxudi uka benne utta lábie Abías. Benne nuila ge Zacarías‑ni lábie Elisabet. Benneha datiagabe ka benne datiake Aarón‑ni; delába Aarón benne sisi'a tte uke bixxudi ge ka benne Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías‑ni lhe Elisabet‑ni lhe ixpabake ankake benne ruin tse arlo Tata Xisiha. Rudo tsitsibake tisa gebie, ruinbake iyába nu rabie. Laxkala labí bixa ge ritisake. ");
INSERT INTO zae_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ttaka nna lanú xi'inke raka, kumu nan Elisabet‑ni labí uka uja xi'in benneha. Gwea nna chigaba dia raxxuke la'ania. ");
INSERT INTO zae_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ttu sá ulha ka bixxudi, ka nu selakana len Zacarías‑ni, kini uinkana sina ge Tata Do Yebáha lhe'e yotuha. ");
INSERT INTO zae_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Uinkana attiba chi ga'anna runi ka bixxudiha. La'ania nna gwaxxína ulha Zacarías‑ni uta'abie lhe'e yotuha ata daa bekú ge Tata Xisiha kini ku'ubie sen yala. ");
INSERT INTO zae_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Laka rite yalaha lo bekúha nna ka benne tupake lali'a ro'o yotuha nna se'ebake rilhapike tisa len Tata Xisiha. ");
INSERT INTO zae_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nuha‑ba raka nna attiruba chi uka xxe ttu anjeli ge Tata Xisiha bisie udúe daka ná ben ge bekú ata rite yalaha. ");
INSERT INTO zae_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tti bilani Zacarías‑ni anjeliha nna uka tee lanie lhe usigabanie lhe. ");
INSERT INTO zae_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ttaka anjeli ge Tata Xisiha nna rane: ―Zacarías, bittu gasinlu kumu Tata Xisiha chiba biyieninie ge nu rinnabalu lenie, de nuha nna benne nuila gelu, Elisabet‑ni, chi utebie ttu xi'inlu. Nutoha nna kixxalu lábi Juan. ");
INSERT INTO zae_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Lu nna edeaka tábinlu lhe anágaba nna ixegaba ka benne tse'e ittake lenlu ganna chi uli bintoha, ");
INSERT INTO zae_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","kumu xi'inluha akabi benne xxeni arlo Tata Do Yebáha. Labí i'iyabi vinu, nigaba attu bixa ttu nu dika udhusinna bi. Sa nujala nan gebiha bi chi isia Espíritu ge Tata Do Yebáha tsu'e itúba latibi. ");
INSERT INTO zae_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Labi odekibi ixe ka benne Israel ki odaxxuke neda ge Tata Do Yebaa benne anke Xxanakeha. ");
INSERT INTO zae_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Lagababi nuha nnerubi kini idhalhibi neda ge Tata Xisiha; kweki lebi attiba uleki le Elías‑ni lhe inná tsitsi lebi attiba uná tsitsi le benneha. Aníha kini ose'e tsebi ka tataha len ka xi'inkeha lhe uinbi kini ka nu abittu rudokana tisa ulaba lekani attiba rulaba le ka nu ruin latsiru. Aníha uinbi kini ose'e tsebi ka benne kini anáchu chi se'eke ubeda Tata Xisiha ganna chi isiabie yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías‑ni nna unnaba tise anjeliha, ree benneha: ―¿Gasina ki aka xen lasia deki gwalí aka nu ralu‑na? Kumu neti chiba ankaa benneola lhe anágaba benne nuila kia‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anjeliha nna bekabie nna ree: ―Neti láya Gabriel. Doa rixúa runia nu ra Tata Do Yebáha. Labie udhelhe neti kini inne lania lu, kixxi'ania lu ka tisa tse. ");
INSERT INTO zae_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ttaka lu nna de labí ria lelu ge ka tisa kia‑ni, de nuha nna eya'anbalu biría; labí aka innelu. Axtaliba ganna chi bisia sá tti chi sadona aka nu ria‑ni, la'anialiba nna eyaka ennelu. ");
INSERT INTO zae_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Laka raka nuha nna ka benne se'e lali'a ge yotuha nna se'ebake ubeda eria Zacarías‑ni. Chiba rudúna ke de anúbie reriaxxi ata daa bekúha. ");
INSERT INTO zae_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ttaka tti chi berieha nna labíru raka innebie ulise ka benne se'e niha. La'anialiba nna tti ute dákanie deki bixa bele'eni Tata Do Yebáha bie lo bekúha, laxkala gwatebie aníha. A sunruba rutá nábie rule'enie ka benneha nna aníha‑ba beya'ane biría. ");
INSERT INTO zae_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tti chi beda'a sá gebie benie sina lhe'e yotuha, la'ania nna deyye lisie. ");
INSERT INTO zae_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Iki de chi ute nuha nna birua bisá nna attiruba chi bele'e nuja xi'ini nan Elisabet‑ni. Delo gayu beo labí birie yo'o. Nianna rabie: ");
INSERT INTO zae_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Aní chi ben Tata Xisiha. Gwatua lebie neti kini abitturu uxisi ka benne kia de lanú xi'inia raka.” ");
INSERT INTO zae_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tti chi uka xxupa beo nna Gabriel benne anke anjeli ge Tata Do Yebáha dedheyye bededhelha Tata Do Yebáha bie lhe'e ttu yiesi re daka Galilea‑ni. Yiesiha tee láni Nazaret. ");
INSERT INTO zae_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Niha do ttu nuila ribani re'eni, chi banani ttu nubiyú‑na. Nubiyúha tee láni José. Nuha datiana David, benne unnabie ka benne Israel‑ni itú nu reha. Nuila ribaniha tee láni María. ");
INSERT INTO zae_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tti uta'a anjeli ge Tata Do Yebáha ata do María‑ni, nianna rabie na: ―¡Padiuxi, nuila! Tata Xisiha gwa duba lenie lu. Delo iyá ka benne nuila, lu nuná akaru lenie lu. ");
INSERT INTO zae_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ttaka María‑ni tti biyieninna ka tisa unne anjeliha nna uka télinna, nianna rakinna: “¿Bí dien benne‑ni unnee aná?” ");
INSERT INTO zae_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ttaka anjeliha nna rabie na: ―María, bittu gasinlu, kumu Tata Do Yebáha‑ba aka lenie lu. ");
INSERT INTO zae_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nnanna nna uja xi'inlu nna gali ttu nuto biyú to. Nubiyú toha nna kixxalu lábi Jesús. ");
INSERT INTO zae_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nutoha akabi benne inná xxeni lebi nna kixxakana lábi Xi'ini Benne ra xxeni lebie do yebáha. Tata Do Yebaa benne anke Xxanari'iha nna unie kini innabiabi attigaba unnabia David benne uke benneola gebiha, ");
INSERT INTO zae_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","lhe anágaba nna ttu dia liiba innabiabi ka benne Israel‑ni. Labí lhuxa loo elha rinnabia gebi. ");
INSERT INTO zae_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María‑ni nna unnaba tisana anjeliha, rane: ―¿Gasina aka nu ralu‑na ki anúgaba nubiyú chi do lania? ");
INSERT INTO zae_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anjeliha nna bekabie geni, ree: ―Espíritu ge Tata Do Yebáha‑ba isiabie tsu'e latilu. Nianna Tata Do Yebáha, len nu ra tsitsi leeha unie kini tsu'u attiba ttu xula ge ttu bea ikilu. Laxkala binto galiha nna akabi gebie nna kixxakana lábi Xi'in Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Anágaba benne raka luesiluha, delába Elisabet‑ni, benneha chigaba gali xi'inie meskiba chi anke benneola. Labie rákana deki lanú xi'inie aka, ttaka nnanna nna chi aka xxupa beo‑ni du benneha nuje benne. ");
INSERT INTO zae_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Aníha aka kumu Tata Do Yebáha labí tee ttu bixa abí aka ge benneha unie; iyába gwakaba ge benneha unie. ");
INSERT INTO zae_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nianna ra María‑ni: ―Neti ankabaa benne rixúni Tata Xisiha. Uinbe len neti nu chi ralu‑na. Nianna tti bedá anjeli ge Tata Xisiha, deyye. ");
INSERT INTO zae_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ttu chupa ubisaba chi ute nna bediuba tteba le María‑ni diana iki ka i'iya ata re ttu yiesi daka Judea. ");
INSERT INTO zae_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tti bisinna lhe'e yiesi toha nna uta'ana lhe'e yo'o ge Zacarías‑ni nna begwena Elisabet‑ni padiuxi. ");
INSERT INTO zae_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tti biyienin Elisabet‑ni tsi'i María‑ni begwene padiuxi, nuto nujeha nna bitá ttebabi lhe'ebie, la'ania nuha bisia Espíritu ge Tata Do Yebáha uyu'e lati Elisabet‑ni, ");
INSERT INTO zae_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","nianna tti unnebie idisa, ree: ―¡Tata Do Yebáha chi ukaru lenie lu tti adí ka benne nuila lhe anágaba akagaba lenie binto nujalu‑na! ");
INSERT INTO zae_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Neti nna, ¿nú ankaa nna axtaba nan ge Benne runie neti mandaduha, axtaba benneha dabie gwelanni neti? ");
INSERT INTO zae_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kumu suna biyienbati tsi'ilu nna binto nujaa‑ni bitá ttebabi lhe'a de bedeakinbi. ");
INSERT INTO zae_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Karubárulu ugía lelu deki gwakaba iyá nu chi ra Tata Xisiha lu! ");
INSERT INTO zae_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","María‑ni nna rana: Itú iki itú lasia runia ki ra xxeni le Tata Xisiha ");
INSERT INTO zae_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","lhe anágaba yalhá itta du lasia de bodilábie neti. ");
INSERT INTO zae_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kumu Tata Do Yebáha chi bilánie neti labí ra xxeni lasia lhe anágaba ankagabaa benne rixúnie lhe. Laxkala debá nnanna nna iyába ka benne innáke: “¡Karubáru nuila‑na!” ");
INSERT INTO zae_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kumu Tata Do Yebaa benne ra tsitsi leeha, xxeniba anka nu chi benie len neti. Benneha nari xúba anke ");
INSERT INTO zae_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","lhe satíaba ratua lebie ka benne ria leke bie ");
INSERT INTO zae_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","lhe anágaba rula'abie nu xxeni ra leeha. Betse'e loogabe nu rulha le ka nu ruin ttaba ");
INSERT INTO zae_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","lhe riguabie ka nu ra tsitsi lekinna ata ribiakana rinnabiakana nna ka benne labí ra xxeni leke nna rugwebie lidhakake. ");
INSERT INTO zae_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ka benne rituinke abittu bi geke tee nna bete tame geke nna ka nu tee gekinna nna suna anába bese'ebie kana. ");
INSERT INTO zae_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Bete nábie len ka benne Israel‑ni, delába ka benne rixúnie ruinke nu ree. Labí bexxulha lebie a satua lebie ke, ");
INSERT INTO zae_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kumu aníha chi rabie ka benne uka xuttoleha. Rabie deki satíaba satua lebie Abraham‑ni lhe ka benne datiake benneha lhe. ");
INSERT INTO zae_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María‑ni nna niha‑ba beya'anna udona len Elisabet‑ni ttiba tsunna beo. Deloliba nna deyyana besinna lisini. ");
INSERT INTO zae_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tti chi gwadona beo gali xi'in nan Elisabet‑ni, nianna uli ttu nuto biyú to. ");
INSERT INTO zae_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tti bina ka benne se'e gaxxaba ata doeha lhe ka benne raka luesieha lhe, tti binake deki chi gwatua le Tata Do Yebáha bie betebie ttu xi'inie, la'ania nna bedeakakin benneha lenie. ");
INSERT INTO zae_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tti chi uka xxunu ubisa uli bintoha, nianna bitupake uchúke lo bela lati bi'iniha kini unna liina deki chi ankabi ge Tata Do Yebáha. Benbake attiba chi ra lo bia bennabi ge ka benne Israel‑ni. Nianna ruinke kixxake lá bintoha Zacarías ttiba lá tata gebiha. ");
INSERT INTO zae_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ttaka nan gebiha nna rabie: ―¡Labí gatta lábi aná! Juan‑ba gatta lábi. ");
INSERT INTO zae_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ka benne tupa niha nna bekabike gebie, ráke: ―Lanú benne datialu do lábie aná. ");
INSERT INTO zae_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nianna tti betten náke tata ge bintoha, ki unnaba tisake bie bixa raka lebie gatta lá bintoha. ");
INSERT INTO zae_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Benneha nna unnabe ttu breta kini unie loni. Lo nuha nna benie ree: “Juan‑ba gatta lábi.” Nianna iyábake bebanakanie. ");
INSERT INTO zae_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tti lo benie nuha nna beyali tteba ro'obie nna beyaka tteba bennebie. Nianna tti unnebie ree: ―¡Xxeniba ra le Tata Do Yebáha! ");
INSERT INTO zae_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Iyába ka benne se'e gaxxa ata do yo'o gekeha nna bebanabakanie. Anágaba ka benne se'e itúba daka iki ka i'iya sia daka Judea‑ni rinnegabake ge iyá nu chi ukaha. ");
INSERT INTO zae_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Iyába ka benne binake ge nuha nna rulaba leke, ráke: ―¿Nú isina binto‑na akabi ganna? Aníha ráke kumu rite dákanie deki Tata Xisiha‑ba nuha du lenie bintoha. ");
INSERT INTO zae_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías tata ge bintoha, tti bisia Espíritu ge Tata Do Yebáha uyu'e itúba latie, nianna tti uduloe unnebie ka tisa bete Espírituha, nianna ree: ");
INSERT INTO zae_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Xxeniba ra le Tata Do Yebáha benne anka Xxana ka benne Israel‑ni, kumu chi bisiabie kini odilábie ka benne gebie! ");
INSERT INTO zae_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Chi udhelhe ttu benne ra xxeni lebie ki odilábie ri'i. Benne‑ni datiabie David, delába David, benne bixúni Tata Do Yebáha kini benie nu ree. ");
INSERT INTO zae_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Benbe attiba rabie itú ttuha tti bixúnie ro'o ka profeta geeha kini unneke nu unieha. ");
INSERT INTO zae_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Rabie deki odilábie ri'i lo ná ka nu abittu raka uyúkana ri'iha lhe lo ná ka nu rutía di lekani ri'iha lhe. ");
INSERT INTO zae_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Chi rabie deki satua lebie ka benne uka xuttori'iha; labí uxxulha lebie nu chi reeha. ");
INSERT INTO zae_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nuní unnebie len Abraham‑ni, benne uke xuttori'iha, ");
INSERT INTO zae_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","delába tti rabie deki odilábie ri'i lo ná ka nu abittu raka uyúkana ri'iha kini anáchu nna anutturu nu ge gasinri'i ganna chi ixúri'i uinri'i nu reeha. ");
INSERT INTO zae_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Uinri'i ttiba runi ttu benne chi beyarie lhe runie nu dika ixú lhe. Aníha‑ba uinri'i itúba tse'eri'i aka benri'i. ");
INSERT INTO zae_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Lu nna xa xi'ini to, kixxakana lálu profeta ge Benne ra xxeni lebie doe yebáha, kumu lu tsialu nnerulu idhalilu neda ge Tata Xisiha, use'e tselu ka benne laka isie. ");
INSERT INTO zae_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kixxi'enlu ka benne Israel‑ni deki gwadíbe elha xen lasi ge ka tulha chi benke lhe godilábe ke lhe, ");
INSERT INTO zae_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","kumu Tata Do Yebaa geri'iha ratua xxatta lebie ri'i. Yebáha‑li udhelhe ttu benne anka xiani dabie gwelanni ri'i ");
INSERT INTO zae_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kini udanie iki ka benne se'eke ata anka chulha lhe ruxunnigabana geke gattike lhe. Aníha kini ku'ubie ri'i neda ata tse'e tseri'i lenie. ");
INSERT INTO zae_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nuto ge Zacarías‑ni nna diaba bi'iniha rixenbi lhe ribe yala lebi lhe. Itúba uka bi'iniha tania, lo yu bisi ata lanú benne se'e, niha‑ba udobi. Attiliba chi bisia sá bele'e lobi len ka benne Israel‑ni, la'anialiba nna biriabi ugwekibi. ");
INSERT INTO zae_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Uka nuha tti uka César Augusto‑ni nu rinnabia itúba Roma, la'ania nuha udhelhana ttu yetsi len ka benne se'e itúba ata rinnabianaha, rinnabana eyadha láke kini yuna balhaxa ka benne chi se'e. ");
INSERT INTO zae_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","La'ania nuha sisi'a tte beyadha lá ka benne. La'aniagaba anka Cirenio‑ni nu rinnabiana daka Siria. ");
INSERT INTO zae_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nianna iyába ka benne teeki beyyake lhe'esi ataliba ulikeha kini gwate láke. ");
INSERT INTO zae_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Laxkala de nuha nna José‑ni teeki bedábie lhe'esi Nazaret. Anka nuha ttu yiesi rena daka Galilea. Nianna deyye besine lhe'esi Belén. Yiesiha nna dedebena daka Judea ata uli David‑ni. Niha‑ba beyya José‑ni kumu anke benne datiabie David‑ni ");
INSERT INTO zae_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","kini gwate lábie lenie María benne nuila geeha. Chi du benneha nuje benne. ");
INSERT INTO zae_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ttaka gwaxxína, tti lo se'eke niha, chi gwadona gali xi'in María‑ni. ");
INSERT INTO zae_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","La'ania nna uli xi'in sisi'a tte gebie. Ulibi ata ru'u ka ku'una biaha. Iki de tti chi beyaka uli bintoha nna bottesi tteba María‑ni bi'iniha lari nna utixxe bi lhe'e ata ru'u nu ro ka nimalaha. Ata ru'u ka ku'una biaba ulibi kumu labíru ukanike eya'anke lhe'e yo'o do lhe'e yiesiha ata reya'ana ka benne yu'u neda. ");
INSERT INTO zae_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gaxxaba Belén‑ni reya'ana ka benne rekike lo ka neru to gekeha, ruyúke ka nuha lo rela lhe'exxiha. ");
INSERT INTO zae_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ttiruba nna ttu nnelaba chi uka xxe ttu anjeli ge Tata Xisiha ata se'e ka benneha. Tti uyu'u xiani ge Tata Xisiha abi'iba ata se'ekeha, nianna usi xxattakanie. ");
INSERT INTO zae_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ttaka anjeliha nna ree ke: ―Bittu gasinle, kumu neti daya ugixxi'en le ttu tisa tse, tisa nu dika odú ittana le iyába ka benne. ");
INSERT INTO zae_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lhe'esi ata uli David‑ni, nasá chi uli ttu benne ki odilábie ka benne. Labie anke Cristu lhe anke Xxanari'i lhe. ");
INSERT INTO zae_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Laxkala ganna eyyale nna saxxakale bintoha rilhibi lari yu'ubi lhe'e ata ru'u nu ro ka ku'una biaha. Ganna chi gwaxxakale bi'iniha, la'ania nna chi yule deki lababi nuha tee niha. ");
INSERT INTO zae_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Attiruba ttu nnelaba chi uka xxe adíru ka anjeli daa yebáha use'eke kwe'e anjeli du gwenneha nna rulhake ge Tata Do Yebáha, ráke: ");
INSERT INTO zae_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Xxeniba ra le Tata Xisiha doe yebáha! ¡Yiesi lo yu‑ni nna tseba tse'e ka benne uinke nu ru'u lebie! ");
INSERT INTO zae_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nuha‑ba ra ka anjeliha, nianna beyapike deyyake yebáha. Ka benne se'e lo ka neruha nna ra luesike: ―Eya'achuri'i lhe'esi Belén‑ni, salanniri'i nu chi uka niha, nu chi utixxi'ani Tata Xisiha ri'i. ");
INSERT INTO zae_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bediuba tteba leke deyyake. Tti besinke niha nna gwaxxakake María‑ni lenie José‑ni lhe bintoha lhe, yu'ubi lhe'e ata ru'u nu ro ka ku'una biaha. ");
INSERT INTO zae_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tti bilákanie bintoha, la'ania nna utixxi'ake iyá nu chi ra anjeliha ke ge bi'iniha. ");
INSERT INTO zae_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nianna iyába ka benne biyienkanie ge nu utixxi'a ka benne reki lo ka neruha nna bebanabakanie. ");
INSERT INTO zae_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ttaka María‑ni nna rudhá tsitsiba lebie iyá nuha nna ttu ttu sába rulaba lebie ge nuha. ");
INSERT INTO zae_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ka benne reki lo ka neruha nna beyekibake deyyake rulhake ge Tata Do Yebáha lhe ráke deki xxeniba ra lebie. Aníha ráke de bebanakanie ge nu biyienkanieha lhe ge nu bilákanieha lhe, kumu ukaba atti tteba chi utixxi'ani anjeliha ke. ");
INSERT INTO zae_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Atti chi gwadona xxunu ubisaha nna uchúke lo bela latibi attiba ra lo bia bennabi ge ka benne Israel‑ni. La'ania nna utixxake lá bi'iniha Jesús attiba chi ra anjeliha María‑ni atti lanila uje bi'iniha. ");
INSERT INTO zae_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tti chi bisia sá eyarike arlo Tata Do Yebáha attiba chi ra lo bia bennabi bodha'an Moisés‑ni, la'ania uche María‑ni lhe José‑ni nutoha lhe'esi Jerusalén‑ni. Ucheke bi'iniha kini gwatso duke bi arlo Tata Xisiha. ");
INSERT INTO zae_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Benbake attiba chi ra lo bia bennabi bodha'an Tata Xisiha ata dia ra: “Iyába ka nuto ka nu sisi'a tte galikana, ganna ankakana nubiyú to, la'ania nna teeki iriesikana ki akakana ge Tata Xisiha.” ");
INSERT INTO zae_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Aníha uka nna ugíake gwateke ka nu bani to ttiba ttu úna, beteke nuha len Tata Xisiha. Benbake attiba ra lo bia bennabi geeha ata dia ra: “Utele chupa ka bexu to o chupa ka becha to.” ");
INSERT INTO zae_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","La'aniagaba do ttu benne biyú lhe'esi Jerusalén‑ni, labie Simeón. Anke ttu benne ruin tse lhe rudo tsitsirue tisa ge Tata Do Yebáha lhe. Benneha dobie ubeda nukaxa idhelha Tata Do Yebaa benne odú itte le ka benne Israel‑ni. Espíritu ge Tata Xisiha gwa duba lenie Simeón‑ni ");
INSERT INTO zae_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","nna chi rabie benneha labí gattie axtaliba ganna chi bilánie isia Cristu, benne chi ga'anani Tata Xisiha idhelhe. La'anialiba nna gattie. ");
INSERT INTO zae_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Espírituha nna chebie Simeón‑ni die yotu la sáha. La'aniagaba bisin ka tata nan ge Jesús‑ni lenbi kini uinke nu ra lo bia bennabiha. ");
INSERT INTO zae_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nianna tti bedaxxu Simeón‑ni nutoha nna uxxua lo nábie bi nna ulhapie tisa len Tata Do Yebáha, ree: ");
INSERT INTO zae_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Nnannaligaba xa Tata Xisi to, chi uka nu ráluha. Neti benne rixuinlu, chibanka ugwelhalu neti gattia, ");
INSERT INTO zae_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kumu ixpa la'aba loa chi biláti benne udelhalu kini odilábie ri'itu. ");
INSERT INTO zae_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Benneha chi ga'aninlu idhelhalu lo iyá ka benne se'e yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Anke ttiba ttu xiani udanie iki ka nu abittu ankakana nu Israel; nna ka benne gelu nna delába ka benne Israel‑ni, unie kini inná xxeni leke. ");
INSERT INTO zae_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José‑ni lenie nuila geeha nna bebanabakanie tti biyienkanie nu ra Simeón‑ni ge bintoha. ");
INSERT INTO zae_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","La'ania nna unnaba Simeón‑ni kini aka len Tata Do Yebáha ke. Nianna tti rana María nan ge nutoha: ―Binto‑ni chi ga'anabi deki ukinnibi lhe odilábi ixe ka benne Israel‑ni lhe anágaba nna akabi ttu benne ku'u ni'akani bi, ");
INSERT INTO zae_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","kumu de udobi be nu satsa rulaba le ixe ka benne. Anágaba lu nna uyúlu elha disa ge nu udhakakana bi. Attiba ttu nu ga'a espada lhe'e lastoni, aníha‑ba akalu. ");
INSERT INTO zae_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ro'o yotuha‑gaba du ttu benne nuila lábie Ana. Benneha anke profeta ge Tata Do Yebáha. Anke xi'iniunná Fanuel benne datiabie ttu dhi ka benne datiake benne utta lábie Aser. Ana‑ni chi anka benneha ttu nanto to la'ania. Kwiti tte benneha betsá nábie, ttaka gasi idaruba udo lenie nubiyú geeha nna uka ttebe bidabi. ");
INSERT INTO zae_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","La'ania nna chi ankanie tta bixxi ttapa (84) ida nna labí rudú siie rie yotu. Rela resába rixúe runie nu ra Tata Do Yebáha, rutte ubina lhe'ebie lhe rilhapie tisa len benneha lhe. ");
INSERT INTO zae_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Looraha‑gaba bisine ata do yotuha. Rugwebie ixkixaru len Tata Do Yebáha. Nianna udulobie utixxi'e ge Jesús‑ni arlo ka benne se'e ubeda odilá Tata Do Yebáha Jerusalén‑ni, delába ka benne Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","José‑ni lhe María‑ni lhe, iki de chi benke iyá nu chi ga'anna lo bia bennabi bodha'an Tata Xisiha, la'ania nna beyekike deyyake nna besinke lhe'esi Nazaret. Nazaret‑ni ankana yiesi geke nna rena daka Galilea. ");
INSERT INTO zae_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Binto Jesús‑ni nna diaba bi'iniha rixenbi lhe ribe yala lebi lhe. Aníha‑gaba nna diagababi ridoruinbi xiani lhe raka len Tata Do Yebáha bi lhe. ");
INSERT INTO zae_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ka tata nan ge Jesús‑ni ttu ttu idaba riake lhe'esi Jerusalén‑ni tti risia laní Pascua. ");
INSERT INTO zae_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tti chi ukani Jesús‑ni tsi'inu (12) ida, la'ania nna dia lenke bi Jerusalén‑ni attiba chi labikanie riake laní. ");
INSERT INTO zae_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Iki de tti chi ute laníha nna beyekike dedáke, ttaka binto Jesús‑ni nna beya'anba bi'iniha lhe'esiha. Ka tata nan gebiha nna bi ute dákanie deki niha‑ba beya'an bintoha. ");
INSERT INTO zae_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Rakakanie ganna lhe'e adíru ka benne dedaaba desela bi'iniha. Laxkala nna beyu'ubake neda ttu sá, ttaka tti begilake bi'iniha ata dedá ka benne raka luesikeha lhe ka benne ankabiakanieha lhe ");
INSERT INTO zae_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","lanú bi'iniha gwaxxakake. Aníha uka nna beyekibake deyyake Jerusalén‑ni ugila bi. ");
INSERT INTO zae_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ukaliba tsunna ubisaha nna gwaxxakake bi dobi ro'o yotuha lagwi ge ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni. Rudo nagabi ge ka nuha lhe rinnaba tisabi kana lhe. ");
INSERT INTO zae_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iyába ka nu se'e rudo nagakani gebi rebanabakinna ge elha rieni do ikibi lhe rebanabakinna ge ka tisa rekabibi ge ka nuha lhe. ");
INSERT INTO zae_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tti bilani ka tata gebiha bi dobi len ka nuha, bebanabakanie. La'ania nna ra nan gebiha bi: ―Xi'ini to, ¿beaka bedhakalu ri'itu aná? Tata gelu‑ni lhe neti lhe yalhá chi rudúna ri'itu rekitu ugila lu. ");
INSERT INTO zae_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús‑ni nna bekabibi gebie, rabi: ―¿Beaka regilale neti? ¿Si bi gwa yule deki rakarula doelha udo lasia nu anka sina ge Tata kiaha? ");
INSERT INTO zae_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ttaka lake nna labí bette dáke bixa diani nu ra bi'iniha ke. ");
INSERT INTO zae_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","La'ania nna deyyababi len ka tata nan gebiha besinke lhe'esi Nazaret. Niha‑ba udobi bedobi tisa ge ka benneha ge iyába nu ráke bi. Nan gebiha nna rudhá tsitsiba lebie ge iyá nu ukaha. ");
INSERT INTO zae_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús‑ni diababi rixenbi lhe rido chiettirugabinbi xiani lhe. Anágaba Tata Do Yebáha lhe ka benne lhe, ru'ugaba leke elha ruin gebi. ");
INSERT INTO zae_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tti chi uka tsinu (15) ida rinnabia Tiberio César‑ni itúba Roma, Poncio Pilato‑ni nna rinnabiana daka Judea‑ni, Herodes‑ni nna rinnabiana daka Galilea‑ni, betsini Felipe‑ni nna rinnabiana daka Iturea lhe daka Traconite lhe. Benne tee lábie Lisanias nna rinnabie daka Abilinia. ");
INSERT INTO zae_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás‑ni lhe Caifás‑ni nna ankakana ka bixxudi xeni. La'ania nna belisa Tata Do Yebáha Juan, xi'in Zacarías‑ni, dona lo yu bisi ata lanú benne se'e. ");
INSERT INTO zae_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nianna utena itúba daka ro'o yoo Jordán‑ni rigixxi'enna ka benne kini odúna ke ge nu ruinke nna odaxxuke neda ge Tata Do Yebáha nna gadike inda, kini anáchu dhi benneha elha xen lasi ge ka tulha ruinke. ");
INSERT INTO zae_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ukaba attiba ra profeta Isaías‑ni tti unnebie lo ka yetsi ge Tata Do Yebáha, ree: Lo yu bisi ata lanú benne se'e, niha riyieni tsi'i ttu benne rinnebie idisa, ree: “Gwalegixxa tse neda ge benne anke Xxanari'iha; gwalolixxa neda kini dhabie. ");
INSERT INTO zae_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Iyába ata re ka xieru‑na nna esákana. Ka i'iya‑na lhe ka sitta xua xea‑na lhe eságabakana kini eyaka lapa. Ka neda kwalha‑na nna ese'e lhixxakana; anágaba ka neda anka satsa‑na, eyaka lapakana, ");
INSERT INTO zae_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","kini anáchu nna iyá ka benne ilákanie benne idhelha Tata Do Yebáha kini odilábie ke.” ");
INSERT INTO zae_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ixeru ka benne ririake ki rugadi Juan‑ni ke inda, nianna rana ke: ―¡Aalexa nu ruin satsa! ¡Lebi'i ankale ttiba ka belha‑na! ¿Nú chi rana le deki gwalále lo elha disa tsitsi nu chi dabigana ute Tata Do Yebáha gele? ");
INSERT INTO zae_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gwaluni nu dika ixú ganna xa. Aníha kini ule'e deki gwalí chi ankale benne bodúna le ge nu ruinle nna bodaxxule neda ge Tata Do Yebáha. Abittu tse'ele ulaba lhi'u lele akinle: “¡Ri'itu gwalábatu, kumu de ankatu benne datiatu Abraham‑ni!” Netiru ria, Tata Do Yebáha ganna aka lebie, gwakaba gebie eyonie ka íyya du'uya nii kini eyakakana benne datia Abraham‑ni; a laa kila iyasanie le. ");
INSERT INTO zae_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Anágaba nna chigaba du tse iyyatteha kini ichúna itupa lhu ka yaga. Laxkala iyába ka yaga ka nu abittu utekana nu xixxi tse, ka nuha chúbakana nna iru'unakana tsiakana lo giha. Aníha‑ba nuha satele ganna abíba uinle nu dika ixú. ");
INSERT INTO zae_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ka benneha nna rinnaba tisake Juan‑ni, ráke: ―Ganna aníha nna, ri'itu, ¿bíla anka nu uintu ganna? ");
INSERT INTO zae_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan‑ni nna bekabina geke, rana: ―Ganna ttu benne se'e chupa xobie, teeki utebie ttu nuha len attu benne abittu xobie tee; lhe ganna ttu benne tee lena robie, teeki kidhie nuha ugwebie benne abittu gebie tee. ");
INSERT INTO zae_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bisingaba ttu chupa ka gwekixa kini gadikana inda. Nianna rákana Juan‑ni: ―Maestru, ri'itu nna, ¿bíla anka nu uintu ganna? ");
INSERT INTO zae_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Lana nna rana kana: ―Abitturu ukixale yani lo nu chi ga'anna ukixale. ");
INSERT INTO zae_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Unnaba tisagaba ttu chupa ka soldadu, rákana: ―Ri'itu nna, ¿bíla anka nu uintu? Lana nna bekabina gekani, rana: ―Abittu uniasinle ka benne. Bittu uinle aníha ki kuale nu tee geke. Bittugaba kwenta usiale ikike deki benke ttu bixa. Gwaleyaka xenba lele ttixaruba gaxale. ");
INSERT INTO zae_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ka benne tupa niha nna rudo tsitsiba nagake kumu ribedake Cristu benne chi ga'anani Tata Do Yebáha idhelhe nna iyábake rulaba lhi'u leke rakakanie: “¿Si laaba Juan‑niba nuní anke Cristu?” ");
INSERT INTO zae_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ttaka Juan‑ni nna unnena rana iyába ka benne tupa niha: ―Gwalí galá neti tti rugadia ka benne inda, suna indaba rixúti, ttaka si dala attu benne tsitsirula ra lebie tti neti. Neti nna labí elha ralhaa idhasia lo ka gwaracha geeha. Benneha nuha ugadie le Espíritu ge Tata Do Yebáha lhe ugadie le gi lhe. ");
INSERT INTO zae_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Chi den tse barkilu ge benneha kini uin tsebie xuxtilaha nna ganna chi bolhube sináha nna ottupe xuxtilaha nna oga'abie xuaha ata regua tsebie benneha. Nianna tti udelhe tee ge xuaha lo gi nu satíaba rite loniha, nu abittu reyola loniha. Lebi'i nuha udhake aníha. ");
INSERT INTO zae_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Iyá nuní unne Juan‑ni tti belisana ka benne bele'enna ke ka tisa tse bete Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Anágaba nna utisagaba Juan‑ni Herodes nu rinnabiaha, kumu de bedo lenna Herodías nu anka nuila ge betsini Felipe‑ni lhe utisagabana na ge adíru ka nu satsa bennaha. ");
INSERT INTO zae_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ttaka betse'e loona, iki de iyá nu satsa chi ben Herodes‑ni nna bedienrula geni: bega'alana Juan‑ni lhe'e lisiyya de bedona na be ge nu ruinnaha. ");
INSERT INTO zae_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Uka nuha tti rugadi Juan‑ni iyába ka benne inda, la'aniagaba udi Jesús‑ni inda. Laka dubie rilhapie tisa len Tata Do Yebáha, nianna biyali yebáha. ");
INSERT INTO zae_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","La'ania nna ugwadi Espíritu ge Tata Do Yebáha, anke attiba ttu becha nna betedhobie iki Jesús‑ni. Nianna biyien tsi'i ttu benne rinnebie yebáha, ree bie: ―Lu ankalu Xi'inia rakati gelu. Lu ankalu benne ruinlu nu ru'u lasia. ");
INSERT INTO zae_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús‑ni chi ankanie ttiba rerua (30) ida tti uduloe sina ge Tata Do Yebáha. Ra ka benne deki lee uke xi'in José nna datiabie Elí. ");
INSERT INTO zae_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí nna uke xi'ini Matat, Matat nna uke xi'ini Leví, Leví nna uke xi'ini Melqui, Melqui nna uke xi'ini Jana, Jana nna uke xi'ini José, ");
INSERT INTO zae_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José nna uke xi'ini Matatías, Matatías nna uke xi'ini Amós, Amós nna uke xi'ini Nahum, Nahum nna uke xi'ini Esli, Esli nna uke xi'ini Nagai, ");
INSERT INTO zae_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nna uke xi'ini Maat, Maat nna uke xi'ini Matatías, Matatías nna uke xi'ini Semei, Semei nna uke xi'ini José, José nna uke xi'ini Judá, ");
INSERT INTO zae_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá nna uke xi'ini Joana, Joana nna uke xi'ini Resa, Resa nna uke xi'ini Zorobabel, Zorobabel nna uke xi'ini Salatiel, Salatiel nna uke xi'ini Neri, ");
INSERT INTO zae_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri nna uke xi'ini Melqui, Melqui nna uke xi'ini Adi, Adi nna uke xi'ini Cosam, Cosam nna uke xi'ini Elmodam, Elmodam nna uke xi'ini Er, ");
INSERT INTO zae_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er nna uke xi'ini Josué, Josué nna uke xi'ini Eliezer, Eliezer nna uke xi'ini Jorim, Jorim nna uke xi'ini Matat, ");
INSERT INTO zae_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat nna uke xi'ini Leví, Leví nna uke xi'ini Simeón, Simeón nna uke xi'ini Judá, Judá nna uke xi'ini José, José nna uke xi'ini Jonán, Jonán nna uke xi'ini Eliaquim, ");
INSERT INTO zae_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim nna uke xi'ini Melea, Melea nna uke xi'ini Mainán, Mainán nna uke xi'ini Matata, Matata nna uke xi'ini Natán, ");
INSERT INTO zae_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán nna uke xi'ini David, David nna uke xi'ini Isaí, Isaí nna uke xi'ini Obed, Obed nna uke xi'ini Booz, Booz nna uke xi'ini Salmón, Salmón nna uke xi'ini Naasón, ");
INSERT INTO zae_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón nna uke xi'ini Aminadab, Aminadab nna uke xi'ini Aram, Aram nna uke xi'ini Esrom, Esrom nna uke xi'ini Fares, Fares nna uke xi'ini Judá, ");
INSERT INTO zae_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá nna uke xi'ini Jacob, Jacob nna uke xi'ini Isaac, Isaac nna uke xi'ini Abraham, Abraham nna uke xi'ini Taré, Taré nna uke xi'ini Nacor, ");
INSERT INTO zae_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor nna uke xi'ini Serug, Serug nna uke xi'ini Ragau, Ragau nna uke xi'ini Peleg, Peleg nna uke xi'ini Heber, Heber nna uke xi'ini Sala, ");
INSERT INTO zae_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala nna uke xi'ini Cainán, Cainán nna uke xi'ini Arfaxad, Arfaxad nna uke xi'ini Sem, Sem nna uke xi'ini Noé, Noé nna uke xi'ini Lamec, ");
INSERT INTO zae_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec nna uke xi'ini Matusalén, Matusalén nna uke xi'ini Enoc, Enoc nna uke xi'ini Jared, Jared nna uke xi'ini Mahalaleel, Mahalaleel nna uke xi'ini Cainán, ");
INSERT INTO zae_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán nna uke xi'ini Enós, Enós nna uke xi'ini Set, Set nna uke xi'ini Adán, Adán‑ni nna uke benne ben Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús‑ni chiba deyu'u Espíritu ge Tata Do Yebáha itúba latie bedábie ro'o yoo Jordán‑ni deyye. Nianna deche Espírituha bie lo yu bisi ata lanú benne se'e. ");
INSERT INTO zae_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Delo chua (40) ubisaha ben nu xxegwiha dhi yiene. Labí utobie yetta itúba ugwekie niha. Tti chi gwadona chua ubisaha, la'ania nna tti ugwetti bitunie. ");
INSERT INTO zae_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nianna tti ra nu xxegwiha bie: ―Ganna si gwalíginlu ankalu Xi'in Tata Do Yebáha, usichu íyya re nii eyakana yettaxtila ki golu. ");
INSERT INTO zae_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús‑ni nna bekabie geni, ree: ―Lo ka yetsi ge Tata Do Yebáha dia ra: “Laa sunruga len yettaxtila aka ben ka benne.” ");
INSERT INTO zae_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nianna che nu xxegwiha bie iki ttu i'iya nna bele'enne ttu satti iyá ka yiesi ka nu ra tsitsi lekani se'e yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nianna tti rane: ―Neti utea lo neda lenlu kini innabialu kana, anágaba lhe utea nu tse tee gekinna, kumu neti chi bisiakana lasi náya. Laxkala utebaa kana len benne rakaba lasia ugwea. ");
INSERT INTO zae_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","De nuha nna ganna si lu udú xibilu arloa nna utsá lolu neti, la'ania nna iyába ka nu chi bele'a‑na akakana gelu. ");
INSERT INTO zae_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús‑ni nna bekabie geni, ree: ―Lo ka yetsi ge Tata Do Yebáha dia ra: “Suna arlo Tata Do Yebaa benne anke Xxanaluha, suna arlo benneha‑ba udú xibilu lhe suna nu innabe uinlu lhe.” ");
INSERT INTO zae_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nianna deche nu xxegwiha bie lhe'esi Jerusalén‑ni nna tti ulhapine iki yotuha gwetsáli. Nianna rane: ―Ganna si gwalíginlu ankalu Xi'in Tata Do Yebáha, niili dulu nna ubinnichu lo yuha, ");
INSERT INTO zae_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kumu lo ka yetsi geeha dia ra: Tata Do Yebáha idhelhe ka anjeli geeha kini uyú tsitsike lu. ");
INSERT INTO zae_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Udoni lo náke lu kini abittu tsu'u ni'alu iki ka íyya. ");
INSERT INTO zae_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús‑ni nna ree na: ―Lo ka yetsiha‑gaba dia ra: “Bittu dhi yielu Tata Do Yebaa benne anke Xxanaluha.” ");
INSERT INTO zae_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Atti abíruba udaa nu xxegwiha gaxasina dhi yiena Jesús‑ni, nianna bekwittachilana. Isá to gwadána bekwittana kwe'ebie. ");
INSERT INTO zae_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús‑ni nna beyekie besine daka Galilea. Tsitsiba ra lebie de yu'u Espíritu ge Tata Do Yebáha latie. Nianna lhe'e iyába ka yiesi se'e abi'iba niha, ugwadhi tisa ge nu runieha. ");
INSERT INTO zae_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Labie nna lhe'e ka yo'o ata rudheti ka benne Israel‑ni ka tisa ge Tata Do Yebáha, niha‑ba rekie rule'enie ka benneha. Laxkala iyábake ráke: ―¡Xxeniba ra le benne‑ni! ");
INSERT INTO zae_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús‑ni beyye lhe'esi Nazaret ata bixenieha. La sá tti reyaka le ka benne Israel‑ni uta'abie lhe'e yo'o ata rudhetike ka tisa ge Tata Do Yebáha attiba labinie runie. La'ania uta'abie nna udúbie kini ulabe ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Begwekane ka yetsi ben Isaías benne uke profeta ge Tata Do Yebáha. Tti udhalie lo ka yetsiha nna gwaxxake ata dia ra: ");
INSERT INTO zae_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espíritu ge Tata Xisiha yu'ubie latia kumu chi ulesie neti kini tsiaya kixxi'aya ka tisa tse len ka benne abittu tee geke nna udhelhe neti kini odú tsea le ka benne du si'i leke, lhe kixxi'ania ka benne tee lisiyya deki gwalábake, lhe anágaba nna edhalia iyya lo ka benne xua loke. Udhelhagabe neti kini odiláya ka benne ruyúke elha disa ttixka bixa rudhakakana ke, ");
INSERT INTO zae_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","lhe kixxi'aya deki isia sá Tata Xisiha aka lenie ka benne. ");
INSERT INTO zae_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nianna tti bottesie yetsiha nna bogwebie benne rigua tsebie ka yetsiha nna tti bedoe. Iyába ka benne se'e niha nna doba loke bie. ");
INSERT INTO zae_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nianna tti unnebie, ree: ―Nasá chi bilenle uka nu belabaa lo yetsi‑ni. ");
INSERT INTO zae_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iyába ka benne se'e niha rinne tseke ge Jesús‑ni lhe rebanabakanie ge ka tisa tsagwi rinneeha. Lhe anágaba nna rinnaba tisa luesike, ráke: ―¿Laaba xi'in José‑niba benne‑ni? ");
INSERT INTO zae_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús‑ni nna ree ke: ―Gaxa gwa rakabinle gale neti ttu tisa tee nu rinne ka benne ráke: “Lu nu reyoni ka benne rani, la lu tte beyoin latilu”, o innále: “¿Beakala lhe'esi gelu‑ni a ruinlu luesi nu chi binatu benlu lhe'esi Capernaum‑ni?” ");
INSERT INTO zae_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nianna unne chiettirue, ree: ―Netiru ria, ni ttú profeta ge Tata Do Yebáha, a rulabikane lhe'esi geeha. ");
INSERT INTO zae_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Neti gwalígati xa, use'e galá ixe ka benne nuila bidabi lo yu ge Israel‑ni tti udo profeta Elías‑ni. La'ania labíru iyya uka delo tsunna ida nalhaha, nianna bisiaru ttu ubina itúba ata se'e ka benne Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ttaka Tata Do Yebáha, ni len ttú ka benne nuila bidabi ge Israel‑ni a udhelhe Elías‑ni kini ute náni len ka benneha. ¿Laaba ganna len nuila bidabi ge lhe'esi Sarepta, delába yiesi re daka Sidón, laaba ganna len nuilaha‑la udhelhe na? ");
INSERT INTO zae_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aníha‑gaba tti udo profeta Eliseo‑ni, ixegaba ka benne use'e lo yu ge Israel‑ni, uka latike yiesu nu tee láni lepra. Ttaka ni ttú ka benneha a betúa yiesuha latike. ¿Laaba ganna Naamán benne doe lo yu ge Siria, benneha‑la gwa betúa yiesuha latie? ");
INSERT INTO zae_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tti biyienin iyá ka nu se'e gwedo naga lhe'e yo'oha nu ra Jesús‑ni, nianna bisa'a xxattakinna ");
INSERT INTO zae_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","nna tti udú liikana uleakane ro'o yiesiha, chekane ro'o belha'a du ro'o yiesiha. Nuha rena iki ttu i'iya. Niha ruinkana uttulhukane. ");
INSERT INTO zae_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ttaka Jesús‑ni beyeki ttebe betebie lagwi gekani nna deyye. ");
INSERT INTO zae_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús‑ni beyadie besine lhe'esi Capernaum. Nuha rena daka Galilea nna lhe'e ka sá atti reyaka le ka benne Israel‑ni nna rule'enie ke ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ka benneha nna rebanabakanie ge nu rule'enie keha, kumu rinnebie ttiba ttu uxtisi rapa lo neda. ");
INSERT INTO zae_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lhe'e yo'o ata rudhetike ka tisa ge Tata Do Yebáha, niha re ttu nubiyú yu'u latini ttu espíritu satsa. Nubiyúha nna itú leni uresi'ana, rana: ");
INSERT INTO zae_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Begwelha ri'itu! ¡Bittu etega'a gelu len ri'itu, lu Jesús ge Nazaret! ¿Si dalu gwetse'e loo ri'itu? Neti gwankabiabati lu. Lu ankalu benne chi ulesi Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús‑ni nna bedhaka dise espíritu xxegwiha, ree na: ―¡Bedhea ro'olu nna beria lati nubiyú‑ni! Nianna uru'una nu xxegwiha nubiyúha lo yu arlo iyába ka benne se'e niha. Nianna tti beria ttebana latini, labíru bixa bedhakana nubiyúha. ");
INSERT INTO zae_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iyába ka benne se'e niha uka télakanie nna rinnaba tisa luesike, ra luesike: ―¿Bí anka ka tisa rinne nubiyú du nii? ¡Xxeniba ra leni rulisana ka espíritu satsa‑na kini eriakana nna gwa rudobakana tisa geni reriakana! ");
INSERT INTO zae_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Iyába ka benne se'e lhe'e ka yiesi se'e itúba ka daka niha rinneke ge nu ruin Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús‑ni beriabe lhe'e yo'o ata rudheti ka nu Israel‑ni ka tisa ge Tata Do Yebáha nna gwate'e lisi Simón‑ni. Nan ge nuila ge Simón‑ni nna teba benneha ranie, yu'u xxatte xilhaa. Nianna unnabakana len Jesús‑ni kini eyonie benneha. ");
INSERT INTO zae_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús‑ni nna biyette arlo benne nuilaha, bedhaka dise xilháha nna beria ttebana lati benneha. Looraha tteba nna beyadha benneha nna benie nu utoke. ");
INSERT INTO zae_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Atti chi chadi tatubisa‑na, iyába ka benne se'e ka benne rani geke, ka benne ridakake iyá looba isagwe, cheke ka benneha ata du Jesús‑ni. Jesús‑ni nna iki ttu ttu ka benneha rixxua nábie nna reyonie ke. ");
INSERT INTO zae_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Lati ixegaba ka benne raniha beria ka espíritu xxegwiha, ribesi'abakana rákana: ―¡Lu ankalu Xi'in Tata Do Yebáha! Ttaka Jesús‑ni nna rudhaka disalee ka nuha. Labí rugwelhe kana innekana, kumu yúbakana deki labie anke Cristu benne chi ga'anani Tata Do Yebáha idhelhe. ");
INSERT INTO zae_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tti ugwani dilaha, biria Jesús‑ni ro'o yiesiha ata lanú benne risatsa. Ttaka ka benne regilake bie nna gwa bisinbake ata dueha. Ruinke ukwedake bie kini abittu eyye. ");
INSERT INTO zae_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ttaka lee nna ree ka benneha: ―Rakagaba doelha kixxi'ania ka benne se'e lhe'e adíru ka yiesi ka tisa tse, delába kixxi'ania ke gasina ki akake benne innabia Tata Do Yebáha ke, kumu de nuha‑la udhelhe neti. ");
INSERT INTO zae_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aníha‑ba dia Jesús‑ni daka Galilea‑ni rigixxi'e ka tisa tseha lhe'e ka yo'o ata rudheti ka benne Israel‑ni ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ttu lidú do Jesús‑ni ro'o indatoo ge Genesaret. Yalhá ixe ka benne tupa niha, axtaba rukí ya'ake bie de raka leke iyienkanie ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nianna bilani Jesús‑ni chupa ka barcu dákana ro'o indaha. Lanú nu tee lhe'ekani, kumu ka benne rudaxxuke belhaha si ugwadilake rigíke ka yexxa gekeha. ");
INSERT INTO zae_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús‑ni nna ugwapie lhe'e ttu ka barcuha nna unnabe len Simón nu anka xxana barcuha kini usigana nuha a latti lhe'e indaha. Nianna tti udoe lhe'e nuha. Niha‑liba doe nna uduloe rule'enie ka benne tupa ro'o indaha. ");
INSERT INTO zae_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tti chi beyaka unneeha, nianna ree Simón‑ni: ―Uche barcu‑ni ata re idila inda‑na nna gwaludelha ka yexxa gele‑na kini udaxxule belha. ");
INSERT INTO zae_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón‑ni nna bekabina, rane: ―Betuelaba uyu'utu sina xa tata, nurula biyaxxuintu. Ttaka ganna aná ra kwinalu nna udelhachua ka yexxa‑ni. ");
INSERT INTO zae_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Atti beyalhikana ka yexxaha nna desá tíba belha lhe'e ka nuha. Chi tteba isúkana. ");
INSERT INTO zae_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nianna bettá nákani uxikana adíru ka nu se'e lhe'e attu barcuha kini ugía ka nuha nna bete nákani lenkana. Laxkala ixpaba ka barcuha besá tíbakana belha. Chiba ruinkana xxudikana lhe'e indaha kumu de dedá xxattakana idi'i. ");
INSERT INTO zae_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tti bilani Simón nu tegaba láni Pedro, tti chi bilenna nu chi ukaha, nianna tti bedú xibini arlo Jesús‑ni nna rane: ―¡Ubi'etta kwe'a xa tata! Kumu neti ttu nu runi tulhaba ankaa. ");
INSERT INTO zae_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Aníha rana kumu lana lhe adíru ka nu se'e lennaha yalhá bebanakinna de bedaxxu xxattakana belha. ");
INSERT INTO zae_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Aníha‑gaba gwate Jacobo‑ni lhe Juan‑ni lhe. Ka nuha ankakana ka xi'in Zebedeo‑ni. Lakana ribengabakana turo'o len Simón Pedro‑ni. Ttaka Jesús‑ni nna rabie Simón Pedro‑ni: ―Bittu gasinlu. Debá nnanna nna labíru udaxxulu belha; ka bennela chi dhulolu gaxilu kini udaxxuke neda ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nianna tti bebeakana ka barcuha ro'o indaha nna bese'e bixxikana ka nuha nna dia ttebakana danalhakana Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ttu sá do Jesús‑ni lhe'e ttu ka yiesi se'e niha. Niha bisin ttu benne biyú sia xxatta latie yiesu nu tee láni lepra. Tti bilen benneha Jesús‑ni nna bere tteba loe lo yu nna unnabe len Jesús‑ni, ree bie: ―Tata xisi to, ganna lu aka lelu, gwadaabalu eyoinlu neti. ");
INSERT INTO zae_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nianna tti belhí ná Jesús‑ni utane lati benneha nna ree: ―Gwaka galá lasia. ¡Nnanna, chinka beyaka! Loora rinne Jesús‑ni nna betúa tteba yiesuha lati benneha. ");
INSERT INTO zae_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nianna tti ra Jesús‑nie: ―Anuttu nu galu. Beyyala gwatso du arlo bixxudiha nna bete úna nu daa lolu utelu ge Tata Do Yebáha de chi beyarilu. Beni attiba raba lo bia bennabi bodha'an Moisés‑ni. Aníha kini uyú lo ka benne deki chiba betúa isagwe‑na latilu. ");
INSERT INTO zae_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ttaka meskiba besuna Jesús‑ni nna adíla ugwadhi tisa ge nu runieha. Laxkala ixe ka benne ritupake kini rudo nagake gebie lhe ki reyonie ke ge bixaba isagwe ridakake. ");
INSERT INTO zae_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesús‑ni nna reru'une ata anuttu benne risatsa kini rilhapie tisa len Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ttu sá do Jesús‑ni rule'enie ka benne ka tisa ge Tata Do Yebáha. Niha‑gaba betetse'e ttu chupa ka fariseo‑ni lhe betetse'egaba ttu chupa ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni, ka nu daba lhe'e iyába ka yiesi to se'e daka Galilea‑ni lhe daka Judea‑ni lhe ka nu daba lhe'esi Jerusalén‑ni lhe. Jesús‑ni nna, kumu de du Tata Xisiha lenbie, de nuha nna tsitsiba ra lebie reyonie ka benne rani. ");
INSERT INTO zae_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nianna bisin ttu chupa ka nubiyú chekana ttu benne daa yatti latie xuakinne lo ttu breta. Ruinkana uga'akana benneha lhe'e yo'o ata du Jesús‑ni kini sattixxakana benneha arloe. ");
INSERT INTO zae_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ttaka de abí galá anka gaxa ga'a lenkana benneha kumu de tupa xxatta ka benne ro'o yo'oha, aníoka nna ugwapi lenkana benneha iki yo'oha. Utuakana ttu chupa ka texa ki udo belea nna ulhidakana benne xua lo bretaha lagwi ge ka benne saa niha. Aníha benkana kini bisine arlo Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tti bilani Jesús‑ni gwa riaba leke deki gwadaabe eyonie benneha, nianna ree benne raniha: ―Nnanna chiba bixú elha xen lasi ge ka tulha gelu‑na xa nubiyú. ");
INSERT INTO zae_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe ka fariseo‑ni lhe belaba lhi'u lekani, rakakinna: “¿Nú anka nubiyú du‑ni nna rilhida gaana Tata Do Yebáha? Sunruba benneha gwa raka gebie ridíe elha xen lasi ge ka tulha ruin ka benne.” ");
INSERT INTO zae_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ttaka Jesús‑ni nna ute dábanie nu rulaba lekaniha, nianna unnaba tise, ree kana: ―Lebi'i, ¿beaka rulaba lele aná? ");
INSERT INTO zae_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Gwalinnáchu, ¿bí nuha nu sattiru innári'i? ¿Si innári'i: “Chiba bixú elha xen lasi ge ka tulha gelu‑na” ak? o ¿innári'i: “Beyadha nna bedá”? ");
INSERT INTO zae_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ttaka nnanna chi ula'ania le kini uyú lole deki neti benne daya yebáha, yiesi lo yu‑ni gwa teeba lo neda kia ki dhia elha xen lasi ge ka tulha ruin ka benne. Nianna tti ree benne daa yatti latieha: ―Lu, rulisaa lu. Beyadha nna bodaxxu breta xualu loin‑na nna beyya lisilu. ");
INSERT INTO zae_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Looraha nna beyadha tteba benne biyúha arlo iyába ka benne se'e niha nna bodaxxue breta nu uxue loniha. Nianna tti deyye lisieha, rulhe ree: ―¡Xxeniba ra le Tata Do Yebáha! ");
INSERT INTO zae_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Iyába ka nu se'e niha bebanabakinna nna itú rasibakinna, rákana: ―Xxeniba ra le Tata Do Yebáha. Nasá chi bilenri'i uka ka elha tsagwi. ");
INSERT INTO zae_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iki de nuha nna beria Jesús‑ni lhe'e yo'oha, nianna bilánie ttu gwekixa dona ata rukixakana belhiu nu daa lo ka benne rigixake ge Roma‑ni. Nu anka gwekixaha tee láni Leví. Nianna tti ra Jesús‑ni na: ―¡Utá, betenalha neti! ");
INSERT INTO zae_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nianna udú lii Leví‑ni nna bedhá bixxi ikini sina ruinnaha nna gwanalha ttebana Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Delola nna ben Leví‑ni ttu laní ge Jesús‑ni lhe'e lisiniha nna ixeru ka gwekixa lhe adíru ka benne lhe use'ekana lenke go yetta. ");
INSERT INTO zae_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ttaka ka fariseo‑ni lhe anágaba ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni, udulokana rulisakana ka benne rudhetini Jesús‑ni, rákana ke: ―¿Beakala lebi'i nna ri'a robale len ka gwekixa‑na lhe len ka nu ruin satsa‑na lhe? ");
INSERT INTO zae_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ttaka Jesús‑ni nna bekabie gekani, ree: ―Ka nu abittu rani‑na, ka nuná labí riyasakinna nu eyoinna kana, sinuki ka nu rani‑na nuná riyasakinna nu eyoinna kana. ");
INSERT INTO zae_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Neti laa dagaa raxia ka nu runi nu dika ixú, sinuki dalaa raxia ka nu ruin satsa, kini odúna kana nna odaxxukana neda ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nianna rákana Jesús‑ni: ―¿Beakala ka benne rudhetini Juan benne rugadi indaha lhe ka benne rudhetini ka fariseo‑ni, rutte xxatta ubina lhe'eke, labí roke yetta lhe rilhapike tisa len Tata Do Yebáha lhe? ¿Beakala ka nu rudhetinlu‑ni nna ri'a roba ka nuní? ");
INSERT INTO zae_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús‑ni nna bekabie gekani, ree: ―¿Laaba ganna labí aka gele uinle ki utte ubina lhe'e ka benne biyaxike ki tse'eke dha'aha ganna ttixka sa duba nu kwiti rutsá nániha lenke? ");
INSERT INTO zae_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ttaka ganna chi bisia sá itua nu kwitiha, anutturuna dho lenke, la'anialiba nna chi utte ubina lhe'e ka benne se'e dha'aha. ");
INSERT INTO zae_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Utixxi'agabanie kana ttu tisa. Aníha benie kini utte dákana bí diani nu raka lebie kixxi'anie kanaha. Nianna tti ree: ―Lanú ttu benne do richúe salha'a ro'o xo kubi geeha nna otábie na ro'o xo yaxxuha, kumu ganna aníha unie, la'ania nna utse'e loobe xo kubiha. Anágaba nna lari kubiha laa gwetogin nuha edúna ro'o lari yaxxuha. ");
INSERT INTO zae_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nigaba lanú ttu benne do rige'e vinu kubi lhe'e ka yieti yaxxu, kumu ganna aníha unie, la'ania nna vinu kubiha, ganna chi galana nna itsúba nuha yietiha. La'ania nna ilaliba vinuha lhe tse'e loogaba yietiha lhe. ");
INSERT INTO zae_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Laxkala teeki ka'ake vinu kubiha lhe'e ka yieti kubi. ");
INSERT INTO zae_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nigaba lanú ttu benne do ri'e vinu yala, delo nna ede'ogaba lebie i'iye vinu kubi, kumu ree: “Vinu yala‑na nuná ri'aru ixí.” ");
INSERT INTO zae_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","La sá tti reyaka le ka benne Israel‑ni ute Jesús‑ni lhe'e ka xuxtila se'e niha. Ka benne rudhetinieha nna richekuke iki ka xuxtilaha nna rixubi len náke benneha nna roke ka xua toha. ");
INSERT INTO zae_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nianna tti unnaba tisa ttu chupa ka fariseo‑ni ke, rákana ke: ―¿Beaka ruinle nu abittu ga'anna uinri'i la sá reyaka leri'i? ");
INSERT INTO zae_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús‑ni nna bekabie gekani, ree: ―¿Si lagwa chi belabale lo yetsi ge Tata Do Yebáha bí ben David‑ni? Yule benneha lhe ka benne dia lenieha lhe, ttu lidú bituinke nna ");
INSERT INTO zae_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","uta'abie lhe'e yotu ge Tata Do Yebáha, nianna bedaxxue ka yettaxtila chi riesike ankake sun tteba ge Tata Do Yebáha, delába ka yettaxtila ka nu labí aka go attu benne subi, sunruba ka bixxudiha gwa ga'anna gokana benneha. ¿Laaba ganna David‑ni utobe benneha nna begwegabe ka benne dia lenieha kini utoke? ");
INSERT INTO zae_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Rágaba Jesús‑ni kana: ―Neti benne daya yebáha, netiba ankaa xxana ka sá reyaka leri'i. De nuha nna gwa teeba lo neda kia innía bixa dika uinri'i lhe'e ka sá reyaka leri'i. ");
INSERT INTO zae_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Uka nuha tti bisia attu sá tti reyaka le ka benne Israel‑ni, la'ania uta'a Jesús‑ni lhe'e yo'o ata rudhetike ka tisa ge Tata Do Yebáha. Nianna udulobie rule'enie ka benne se'e niha. Lhe'e yo'oha‑gaba re ttu benne biyú daa yatti ttu lha'a nábie. ");
INSERT INTO zae_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe ka fariseo‑ni lhe se'ekana rulatsikana ge Jesús‑ni ganna si gweyonie ttu benne rani la sáha, kini aníha‑chu nna tee ro'okani bixa usiakana ikie. ");
INSERT INTO zae_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ttaka labie nna, kumu yu galábie nu rulaba lekaniha, nianna ree benne daa yatti neeha: ―Udú lii nna utá udú lagwi‑ni. Benne biyúha nna udú lii ttebe die. ");
INSERT INTO zae_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nianna tti ra Jesús‑ni kana: ―Neti raka lasia innaba tisaa le ttu bixa. ¿Bí ga'anna uinri'i lhe'e ka sá tti reyaka leri'i? ¿Si uinri'i latsiru ak? ¿O uinri'i nu satsa ak? ¿Si odilári'i ttu benne o ugwelhari'i gattie ak? ");
INSERT INTO zae_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nianna tti bodeki loe belannie lo iyába ka benne se'e abi'iba kwe'eeha nna rabie benne biyúha: ―Belhí nálu. Aníha‑ba ben benneha nna beyaka tteba neeha. ");
INSERT INTO zae_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ttaka lakana nna yalhá bisa'a xxattakinna nna udulo ttebakana ra luesikani bixa udhakakana Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","La'ania ttegaba nuha ugwapi Jesús‑ni iki ttu i'iya do niha, nianna ulhapie tisa len Tata Do Yebáha. Betuelaba udoe unnebie len benneha. ");
INSERT INTO zae_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tti chi ugwani dilaha nna uxie ka benne rudhetinieha. Nianna bekwebie tsi'inu (12) ka benneha. Ka benneha nuha utixxe láke apóstol. ");
INSERT INTO zae_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bekwebie Simón benne utixxagabe lábie Pedro lhe Andrés betsi Simón‑ni lhe Jacobo‑ni lhe. Anágaba bekwegabe Juan‑ni lhe Felipe‑ni lhe Bartolomé‑ni lhe ");
INSERT INTO zae_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Bekwegabe Mateo‑ni lhe Tomás‑ni lhe Jacobo xi'ini Alfeo‑ni lhe. Anágaba bekwegabe Simón benne rákana Zelote lhe ");
INSERT INTO zae_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas betsi Jacobo‑ni lhe. Bekwegaba Jesús‑ni Judas Iscariote nu betto'one lasi ná ka nu bettikaneha. ");
INSERT INTO zae_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tti beyadi Jesús‑ni len ka apóstol geeha iki i'iyaha, nianna tti betelede ttu latsi re niha. Niha chi tupa adíru ka benne rudhetinieha lhe ixe juisiru ka benne lhe, ka benne daba itúba ka daka Judea lhe ka benne daba lhe'esi Jerusalén‑ni lhe ka benne daba itúba ka daka ro'o indatoo ge Tiro lhe Sidón lhe. Bisia ka benneha kini udo nagake ge Jesús‑ni lhe anágaba ki eyonie ka isagwe ridakakeha lhe. ");
INSERT INTO zae_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ka benne ruyúke elha disa de yu'u ka espíritu satsa latike, ka benneha gwa reyakabake. ");
INSERT INTO zae_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Aníha uka nna iyá xeaba ka benne raka leke sattanke lati Jesús‑ni, kumu de ra tsitsi lebie nna gwa ridaabe reyonie iyábake. ");
INSERT INTO zae_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús‑ni belannie lo ka benne rudhetinieha, nianna unnebie ree ke: ―Karubárule, lebi'i ka benne abí gele tee, kumu lebi'i nuná akale ka benne innabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Karubárule, lebi'i ata se'ele rituinle nnanna, kumu isia sá gobale nna eyielabinle. ’Karubárule, lebi'i ka nu ribesile nnanna, kumu isia sá nna gwedeakabinle. ");
INSERT INTO zae_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Neti benne daya yebáha, karubárule ganna ttixka delo ni'a kia nna utía di lekani le lhe urio lákana le lhe. Karubárule ganna ttixka ulisa xxattakana le lhe anágaba nna ganna ku'u ni'akani le innákana deki satsaba ruinle. ");
INSERT INTO zae_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gwalodú itta lele la sáha lhe egitta ebaa lele lhe, kumu lebi'i xxeniba anka nu dhile yebáha. Kumu ka nu rudhaka disakana le nnanna, anágaba bedhaka disa ka benneola gekaniha ka profeta ge Tata Do Yebáha itú ttuha. ");
INSERT INTO zae_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Ttaka lebi'i ka nu tee gele, ¡gwalíchi lele kumu sunruba yiesi lo yu‑ni se'ele xen su lasi de tee nu riyasinle! ");
INSERT INTO zae_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’¡Gwalíchi lele, lebi'i ata yiela súbinle nnanna, kumu isia sá gattibale ubina! ’¡Gwalíchi lele ata ruxisile nnanna, kumu isia sá nna kwesibale de eleninle! ");
INSERT INTO zae_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’¡Gwalíchi lele, lebi'i ttixka iyába ka benne rinne tseke gele! Kumu ttigaba ruinke rinne tseke gele nnanna, anágaba ben ka benneola gekeha len ka profeta gwen lasi ugweki itú ttuha. ");
INSERT INTO zae_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Ttaka lebi'i ka nu riyieninle rinnea, neti ria le: Akinle ge ka nu abittu raka uyúkana le. Latsiru gwaluin len ka nu ritisikinna le. ");
INSERT INTO zae_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gwalinnaba len Tata Do Yebába kini aka lenie ka nu rigekana ikile, lhe gwalinnabagaba lenie ge ka nu rudhaka gwekana le lhe. ");
INSERT INTO zae_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ganna si nuxa kweana gi xxagalu, bodekigaba attu lha'a xxagalu kini kweana gi. Ganna si nuxa kuana jabana gelu‑na, begwegaba na mixa gelu‑na. ");
INSERT INTO zae_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ganna si nuxa innabana lu ttu bixa, begwe na nu rinnabanaha o si ganna nuxa udaxxuna nu anka gelu, abittu ennabalu nuha. ");
INSERT INTO zae_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ttiba raka lele uin ka benne len lebi'i, aníha‑gaba uinle lenke. ");
INSERT INTO zae_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Kumu ganna suna ka nu rakakinna gele‑naruba gwa rakinle gekani, la'ania nna, ¿bíruala nu tse ruinle ganna? Ki ka nu runi tulha‑na, gwa rakagabakinna ge ka nu rakakinna gekani. ");
INSERT INTO zae_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Lhe anágaba ganna suna len ka nu gwa raka uyúkana le, ganna suna len ka nunáruba gwa ruin tsele, la'ania nna, ¿bíruala nu tse ruinle ganna? Ki ka nu runi tulha‑na anágaba ruin ka nuná. ");
INSERT INTO zae_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ganna si rute gannale len ka benne rakinle deki goteke gele, la'ania nna, ¿bíruala nu tse ruinle ganna? Ki ka nu runi tulha‑na gwa ribeagaba ge luesi ka nuná, kumu ribedagabakana edíkana nu betekanaha. ");
INSERT INTO zae_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ttaka lebi'i, akinle ge ka nu abittu raka uyúkana le lhe uinle latsiru lenkana lhe. Anágaba nna ute gannale ge ka benne nna bittu tse'ele kwedale deki gwedíle ge nu beteleha. Ganna aníha uinle, la'ania nna xxeniba anka nu tse ralhale dhile, lhe anágaba nna akale xi'in Tata Do Yebaa benne ra xxeni leeha. Kumu benneha anke benne tse len ka nu abittu rugwekane ixkixaru lhe anke benne tse len ka nu runi satsa lhe. ");
INSERT INTO zae_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Lebi'i nna satua lele ka benne; uinle attigaba ruin Tata geri'iha, ratua lebie ri'i. ");
INSERT INTO zae_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Bittu innele ge ka benne innále: “¿Beaka anála ruinle?” kini Tata Do Yebáha nna abittugaba udhake le aníha. Abittu urixxi ukinnile ka benne; aníha nna kini abittugaba urixxi ukinni Tata Do Yebáha le. Gwalidhí elha xen lasi ge ka benne; aníha‑gaba Tata Do Yebáha gwadígabe elha xen lasi gele. ");
INSERT INTO zae_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gwalute nu tee gele len ka benne; aníha‑gaba Tata Do Yebáha gutegabe nu tee gebie len lebi'i. Tseba orixxibiabie otebie gele, odisá tíe lhe ukí giripie lhe'e beduti gele, lhe anágaba odo bíe tti otebie gele kumu attigaba urixxibiale utele; aníha‑gaba orixxibiabie otebie gele. ");
INSERT INTO zae_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús‑ni nna utixxi'anie ka benne ttu tisa. Aníha benie kini utte dáke bixa diani nu raka lebie kixxi'anie keha. Nianna tti ree: ―Ttiba anka ttu benne xua loe, ¿si gwakaba gebie nnerue arlo attu benne xua loe? ¿Laaba ganna ixpabake iginnike lhe'e ttu yieru? ");
INSERT INTO zae_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nigaba ka nu rudhetiha labí rakarula gekani tti benne rule'enie kanaha. Axtaliba ganna chi uluxakinna bedhetikana, la'anialiba nna chi isinkana aka gekani tti raka ge benneha. ");
INSERT INTO zae_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Beaka ridolu rulannilu biste yu'u lhe'e iyya lo betsi to geri'iha, delo nna a ridoxalu ugíalu yaga yu'u lhe'e iyya lolu‑na? ");
INSERT INTO zae_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Galasina tee ro'olu galu betsi to geri'iha: “Betsi to, begwelhaxa kweaya biste yu'u lhe'e iyya lolu‑na”? Ki lu a rulannixalu tsapaba anka yaga yu'u lhe'e iyya lolu. ¡Aaluxa nu rigí xú loni! Lade'axa ulea yaga yu'u lhe'e iyya lolu‑na kini anáchu nna ilá tsenlu ki kwealu biste yu'u lhe'e iyya lo betsi to geri'iha. ");
INSERT INTO zae_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Ttu yaga ganna abittu anka tse‑na, labí di ute nuha nu xixxi tse; nigaba yaga anka tseha, labí di ute nuha nu xixxi abittu anka tse. ");
INSERT INTO zae_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kumu kua ttu ttu ka yaga‑na ankabienri'i kana gasina anka nu xixxi ribia lokani. Kumu labí dika echidari'i higu lo ka ya yietsi‑na; nigaba elhidari'i uva lo ka ya titsa. ");
INSERT INTO zae_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Benne re tse leeha, nu tse re lhe'e lastoeha‑ba rinnebie nna nu re satsa leniha nna nu satsa re lhe'e lastoniha‑gaba rinnena. Kumu ri'i nu re lhe'e lastobari'i, nuha‑ba rinneri'i. ");
INSERT INTO zae_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Beaka rale neti “Tata Xisi to” nna abígaba ruinle nu xpeya le? ");
INSERT INTO zae_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Neti kixxi'arugania le gasina anka ttu benne dabie len neti nna riyieninie ka tisa kia‑ni, nianna rudoe tisa ge nu xpeye. ");
INSERT INTO zae_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Benneha anke ttiba nubiyú bedona yo'o geniha iki ttu íyya. Uche'enna lhi'u, nianna bekuana íyya abi'iba xan nuha kini udo tsitsina. Tti ubixxi inda ro'o yoo tee niha, nianna gwatsu'una idí kwe'e yo'oha, nna niru latti a udaa indaha uttána nuha kumu tsitsiba do nuha iki íyyaha. ");
INSERT INTO zae_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ttaka benne riyieninie ka tisa rinnea‑ni nna ganna abíba rudoe tisa, benneha anke ttiba nubiyú bedona yo'o geniha nna labí uche'enna ki ukuana íyya abi'iba xan nuha nna lo liaba bedona nuha. Ttaka tti bisá yoo tee niha inda nna gwatsu'una idí kwe'e yo'oha nna ubixxi tteba nuha. Tuttíruba betse'e loo indaha yo'oha. ");
INSERT INTO zae_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iki de chi uluxani Jesús‑ni utixxi'anie ka benne se'e gwedo nagaha, nianna deyye lhe'esi Capernaum. ");
INSERT INTO zae_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lhe'esiha do ttu soldadu nu baninna ttu gayua (100) ka soldadu ge Roma‑ni. Nubiyúha do ttu nu kwiti riben lo sina geni. Yalhá raka xxattinna ge nuha. Ttaka nu kwitiha ranibana, chi tteba duna gattina. ");
INSERT INTO zae_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Soldadu nu baninna adí ka soldaduha, tti binana ge Jesús‑ni, nianna udhelha ttebana ttu chupa ka benneola ge ka nu Israel‑ni, rana kana: ―Gwaltsia gwaligasi Jesús‑ni kini ite eyonie nu kwiti riben sina kia‑ni. ");
INSERT INTO zae_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ka nuha nna tti bisinkana ata du Jesús‑ni nna unnaba ditibakana loe, rákane: ―Benne rinnabie ka soldaduha gaxa gwa ralhaba benneha ute nálu lenbie, ");
INSERT INTO zae_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kumu labie rakanie ge iyába ka benne geri'i lhe lagabe bedoe yo'o ata rudhetiri'i ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nianna dia tteba Jesús‑ni lenkana. Ttaka tti chi isinke gaxxaba ata do yo'o geniha, nianna chi udhelhana ttu chupa ka nubiyú se'e tse lennaha, kini tsiakana gákane: ―Aní ra soldadu nu bananie adí ka soldaduha: Uxí elha xen lasi xa tata xisi to, neti labí elha ralhaa ga'a kwinalu lhe'e lisia‑ni. ");
INSERT INTO zae_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kumu de nuha nna labí beyaxati ita kwinaga neti lenlu. Náliba dulu unne nna gweyakaba nu kwiti riben lo sina kia‑ni. ");
INSERT INTO zae_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kumu neti ankagabaa nu rudoa tisa ge ka nu ra xxeniru lekani tti neti. Anágaba nna rinnabiagabaa adíru ka soldadu. Laxkala tti upeya ttu ka nuha: “Ugía niha”, nuha gwa riabana nna tti rodopeya attu ka nuha: “Utá nii”, nuha nna gwa ritabana, nna tti upeya benne riben lo sina kiaha: “Ben nu tee nii.” Benneha nna gwa ruinbe nu xpeyeha. ");
INSERT INTO zae_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tti biyienin Jesús‑ni nu ra nubiyúha nna bebanabanie geni. Nianna tti bodeki loe ree ka benne danalhake bieha: ―Netiru ria, delo iyá ka benne Israel‑ni, niru ttúke labí chi gwaxxakaa ria tsitsi leke tti ria le nubiyú‑ni. ");
INSERT INTO zae_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ka nu udhelhana ki beti'akana Jesús‑ni, tti besin ka nuha lhe'e yo'oha, nna chi gwaxxakakana nu kwiti raniha, chiba beyakana. ");
INSERT INTO zae_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Iki de nuha nna dia Jesús‑ni lhe'e yiesi nu tee láni Naín. Diabie len ka benne rudhetinieha lhe anágaba diagaba ixe juisiru ka benne lhe. ");
INSERT INTO zae_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tti chi bisine gaxxa ro'esiha, nianna tti bilánie chekana ttu benne yatti, diakana takatsikane. Ttúru nu kwitiha xi'in benne nuila anka bidabiha. Ixeba ka benne lhe'esiha diake len benne nuilaha, danalhake benne yattiha. ");
INSERT INTO zae_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tti bilani Jesús‑ni benne nuilaha, nianna gwatua lebie benneha nna ree bie: ―Bittu kwesilu. ");
INSERT INTO zae_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nianna tti ubige utane ro'o i'ina ge nu kwitiha nna ka benne nujake benneha nna uleda ttebake. Nianna tti unnebie ree: ―Nu kwiti, lu rulisaa, beyadha. ");
INSERT INTO zae_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Benne yattiha nna beyadha ttebe bedoe nna udulo ttebe rinnebie. Nianna tti bote Jesús‑ni benneha len nan geeha. ");
INSERT INTO zae_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Iyába ka benne se'e niha usibakanie nna ráke: ―¡Gáruba ttipa xxeni ra le Tata Do Yebáha! Lagwi gebari'i chi ulea lo ttu profeta ra xxeni leni. Tata Do Yebáha chi bisiabie kini aka lenie ka benne gebie. ");
INSERT INTO zae_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Lhe'e iyába ka yiesi se'e daka Judea‑ni lhe lhe'e adíru ka yiesi se'e abi'iba ka daka niha ugwadhi tisa ge nu ben Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ka benne rudhetini Juan‑ni gwattixxi'akanie bie ge iyá nu chi ben Jesús‑ni. Nianna tti uxi Juan‑ni chupa ka benneha ");
INSERT INTO zae_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","nna udhelhe ka benneha ata du Jesús‑ni kini tannaba tisake benneha ganna si labie nuha benne chi ga'anna idhelha Tata Do Yebáha o teeki kwedake isia attu benne subi. ");
INSERT INTO zae_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tti bisin ka benne udhelha Juan‑ni ata du Jesús‑ni, nianna unnaba tisake, ráke bie: ―Juan benne rugadie indaha, udhelhe ri'itu len kwinalu kini innaba tisatu lu ganna si lu nuná ankalu benne chi ga'anna idhelha Tata Do Yebáha o teeki kwedatu attu benne. ");
INSERT INTO zae_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tti lo se'e ka benneha niha, nna beyoin Jesús‑ni ixeru ka benne ge bixaba isagwe rateke lhe beyoingabe ka benne yu'u latike ka espíritu satsa lhe anágaba ixegaba ka benne a raka ilákanie bedhalie loke. ");
INSERT INTO zae_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nianna tti bekabie ree ka benneha: ―Gwaleyya nna gwalikixxi'en Juan‑ni nu chi biyieninle lhe nu chi bilenle runia lhe. Gwaligá na: “Ka nu xua lokaniha, chiba relákinna lhe ka nu ridá natsaha, chiba redá tsekana nna ka nu raka latikani yiesu lepra, chigaba reyakakana lhe anágaba ka nu anka kwechuha, chigaba reyienkinna nna ka nu chi uttiha nna gwa reyaka bengabakana. Anágaba ka benne dii abittu geke tee, chigaba riyienkanie ka tisa ge Tata Do Yebáha.” ");
INSERT INTO zae_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Gwaligágaba na: “Karubáru benne abittu rudú chupana lebie de rilánie nu runia.” ");
INSERT INTO zae_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Atti beyeki ka benne udhelha Juan‑ni deyyake, nianna tti udulo Jesús‑ni utixxi'e ge Juan‑ni, ree ka benne ixe tupa niha: ―¿Bí biriale gwalannile lo yu bisi ata lanú benne se'e? ¿Si ugíale gwalannile ttu yettixtila ruttá beha ak? ");
INSERT INTO zae_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ganna abíba nna, ¿núla nuha gwagíale ganna? ¿Si ttu nubiyú nukuna xo raka lhalha loni? Ko'o. Neti ria, ka nu rukukana ka xo tse raka lhalha loin‑na lhe redí baakana nu tse tee gekani, ka nuná lhe'e ka yo'o ge ka nu rinnabia xeni‑naliba ralha ka nuná tse'ekana. ");
INSERT INTO zae_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ganna abíba nna, ¿núla gwagíale ganna? ¿Si ttu profeta ge Tata Do Yebáha ak? Gwalí galá, neti ria, lebi'i biriale gwagíale ttu benne xxenirula ra lebie tti ttu benne anke profeta. ");
INSERT INTO zae_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ge Juan‑ni nuha rinne Tata Do Yebáha lo ka yetsi geeha tti rulise Xi'inieha, ree: Neti idhelhaa ttu benne tsie nnerue lolu kini kixxi'e ka tisa kia‑ni. Benneha idhalie neda gelu. ");
INSERT INTO zae_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Netiru ria, delo iyá ka benne chi uli yiesi lo yu‑ni, lanú ttu benne do ra xxeniru lebie tti Juan‑ni. Ttaka delo iyá ka benne rinnabia Tata Do Yebáha ke, benne ra gwexxaru leeha, xxenirula ra lebie tti Juan‑ni. ");
INSERT INTO zae_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Iyába ka benne lhe iyágaba ka gwekixaha lhe, tti biyienkanie nu ra Jesús‑ni, nianna tti bokinni ikike deki tseba anka nu rinnaba Tata Do Yebáha uinke. De nuha nna chi uxielhake begadi Juan‑ni ke inda. ");
INSERT INTO zae_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ttaka ka fariseo‑ni lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni, labí uxielhakana ugadi Juan‑ni kana inda. Tti benkana aníha, nuha bele'e deki ulu'u ni'akani nu raka le Tata Do Yebáha unie lenkana. ");
INSERT INTO zae_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nianna redená Jesús‑ni: ―¿Nú utsania ka benne se'e nnanna ganna? ¿Nú anka tti ankake? ");
INSERT INTO zae_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ankabake ttiba ka nuto‑na rise'ekana rittakana ata raka i'iya ribesi'en luesikani, ra luesikani: “Ri'itu gwa bekwesibatu ka iyyaxtila getu‑ni, ttaka lebi'i nna abígaba beya'ale, lhe anágaba gwa bilhagabatu le'a ge benne yatti, lebi'i nna abígaba uresile.” ");
INSERT INTO zae_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kumu bisia Juan benne rugadie indaha, benneha labí utoe yettaxtila, nigaba labí u'uye vinu. Lebi'i nna rálale: “Ttu espíritu ge nu xxegwiha‑ba yu'u lati nuná.” ");
INSERT INTO zae_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nnanna nna neti benne daya yebáha, bisiaya nna roa lhe ri'iyaa lhe; lebi'i nna redenálale: “Nu du‑ni nna ankana ttu nu ro xxatta lhe ttu nu ri'a lhe. Anágaba nna rutságabana ka gwekixa‑na lhe ka nu ruin tulha‑na lhe.” ");
INSERT INTO zae_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ttaka atti rilenri'i elha ruin ge ka xi'in Tata Do Yebáha, la'ania nna rite denri'i deki elha rieni rapa Tata Do Yebáha nuha rapa ka benneha. ");
INSERT INTO zae_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ttu ka fariseo‑ni uxina Jesús‑ni lisiniha ki goe yetta lenna. Labie nna gwa ugíabe nna tti uta'abie lhe'e yo'o geniha, nna udoe ro'o mexaha. ");
INSERT INTO zae_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ttu nuila do lhe'esiha daa tisa geni deki ruinna satsa. Tti bina nuilaha deki do Jesús‑ni lhe'e lisi fariseo‑ni, nianna diana nna denna ttu re'e to ankana ge íyya ragalha. Íyya ragalhaha tee láni alabastro. Saa tíba re'e toha seti nu rure ixixxi. ");
INSERT INTO zae_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tti bisinna ata do Jesús‑ni, nianna biyachu ttebana urena kwe'ebie nna udulona ribesina, nna len inda gwina geniha‑ba bodibidhana ka ni'eha, nianna tti bodibisina ka nuha len itsa ikiniha. Betságaba loni ka ni'eha lhe utabina ka nuha seti dennaha lhe. ");
INSERT INTO zae_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fariseo nu uxina Jesús‑ni lisiniha, tti bilenna nu ruin nuilaha, nianna belaba lhi'u leni rakinna: “Ganna ttixka gwalígin nubiyú re nii deki ankana profeta ge Tata Do Yebáha, la'ania nna gwa ute dálinna nú nuila nuní rigánna latini, ki nuila ruin satsaba nuní.” ");
INSERT INTO zae_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesús‑ni nna bekabie ge fariseo‑ni ree na: ―Simón, upeya lu ttu nu upeya lu. Simón‑ni nna bekabina gebie, rana: ―Unába xa maestru. ");
INSERT INTO zae_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nianna ree na: ―Ttu lidú use'e chupa ka benne dáke belhiu ge ttu nu ribea belhiu. Ttu benneha daabie gayu gayua (500) denario, attue nna daabie tsieyona (50). ");
INSERT INTO zae_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ttaka kumu abí galá ridaake kixake belhuha, aníha uka nna gwa uxíbana elha xen lasi ge ixpaba ka benneha; labí bekixana ke belhuha. Nnanna nna lu, unáchu, ¿nú ka benneha akarukanie ge nu uxína elha xen lasi gekeha? ");
INSERT INTO zae_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón‑ni nna bekabina, rane: ―Neti rakati benne daabie ixenru belhuha, benneha nuha uxíruna elha xen lasi gebie. Jesús‑ni nna ree na: ―Gwalí galenlu. ");
INSERT INTO zae_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nianna tti bodeki loe belannie nuilaha nna tti ree Simón‑ni: ―¿Si gwa rilenlu nuila re nii? Neti tti uta'aya lhe'e lisilu‑ni, labí betelu inda kini ití ka ni'aya‑ni. Yúruga nuila‑ni, chi utína ka nuní len inda gwina geni lhe chi bodibisina kana len itsa ikini lhe. ");
INSERT INTO zae_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Anágaba nna abígaba utolu xxagaa atti bisiayaha. A beriarugalu nuila‑ni, ttili bisiayaha, birula chi bedú siina rutsá loni ka ni'aya‑ni. ");
INSERT INTO zae_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Lu nigaba a utabilu seti ikia. Yúruga nuila‑ni, chi utabina ttu nu rure ixixxi ka ni'aya‑ni. ");
INSERT INTO zae_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","De nuha nna ria lu, raka xxattinna kia kumu de chi bixú elha xen lasi ge ixe ka tulha chi benna. Kumu ganna ttu benne lattiruba elha xen lasi rixú gebie, la'ania nna lattirugaba raka si'in benneha attu benne. ");
INSERT INTO zae_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nianna tti ree nuilaha: ―Chiba bixú elha xen lasi ge ka tulha gelu‑na. ");
INSERT INTO zae_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Atti biyienin adíru ka benne se'eke lenbie ro'o mexaha nu rabie nuilaha, nianna uduloke rinnaba tisa luesike, ráke: ―¿Nú anka nuní nna ge iyába ka tulha‑na ridína elha xen lasi? ");
INSERT INTO zae_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ttaka lee nna unnerulee, ree nuilaha: ―De ugía lelu kia nna chiba bodilaa Tata Do Yebáha lu. De nuha nna xen su lasi beyya. ");
INSERT INTO zae_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Iki de nuha nna ugwekiru Jesús‑ni len iyába ka benne tsi'inu (12) rudhetinieha lhe'e iyába ka yiesi se'e niha. Rigixxi'e ka tisa tse, delába rigixxi'e gasina ki akake ka benne innabia Tata Do Yebáha ke. ");
INSERT INTO zae_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Danalhagaba attu chupa ka benne nuila, ka benne beria ka espíritu satsa latike lhe beyakake ge ka isagwe ridakakeha lhe, delába danalha María benne tegaba lábie Magdalena. Benneha beria gasi (7) ka espíritu satsa latie; ");
INSERT INTO zae_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","lhe danalhagaba Juana nuila ge Chuza, Chuza nu baninna iyá nu tee ge Herodes‑ni. Anágaba danalhagaba Susana‑ni lhe adíru ka benne nuila lhe. Nu teeba geke rudaxxuke kini rute náke len Jesús‑ni itupa lenie ka benne rudhetinieha. ");
INSERT INTO zae_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ixe juisiru ka benne ririake lhe'e ka yiesi gekeha nna diake ata du Jesús‑ni. Tti chi tupa ixe juisiruke, nianna utixxi'anie ke ttu tisa. Aníha benie kini utte dáke bí diani nu raka lebie kixxi'anie keha. Nianna tti ree: ");
INSERT INTO zae_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Ttu benne ruin sina birie die gwedelha xuxtila. Tti dabie rudelhe benneha nna ttu chupa ka xua toha utsake ro'o nedaha. Tti ute ka benne lo nedaha nna beleabake iki benneha, nianna tti biginni ka binniha nna bedigabakana benneha. ");
INSERT INTO zae_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Attu chupake nna utsake lo íyya atta'aha; ttaka atti be'eyu ka benneha nna ubisi ttebake kumu de labí lupa tee lo íyyaha. ");
INSERT INTO zae_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Adí ka benneha nna utsake lhe'e yietsiha. Ttaka tti be'eyu ka benneha nna biyelhagaba ka yietsiha nna belhiubakinna xua toha. ");
INSERT INTO zae_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ttaka adí ka benne ubinni ata do yu tseha. Ka benneha nna gwa be'eyubake nna yalhá lhe'e lena beteke. Ttu ttu gayua (100) tteba xua bekudhi iki ttu ttu ka xuaha. Nuha‑ba ra Jesús‑ni nna tti unnebie idisa, ree ka benne se'e niha: ―¡Ata sia nagale, gwaludo nagale ganna gwankale nu dika iyienini! ");
INSERT INTO zae_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ka benne rudhetinieha nna unnaba tisake bie, ráke: ―¿Bíla diani nu unnelu‑ni? ");
INSERT INTO zae_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús‑ni nna bekabie geke, ree: ―Lebi'iligaba nna gwagixxi'abin Tata Do Yebáha le nu labí chi yu adí ka benne, delába gwa ruinbe kini tte denle gasina innabie. Ttaka len adíru ka benne nna bixxi kwe'eba rinnea, kini meskiba bika rulannike nna labí ilákanie lhe meskiba bika riyienkanie nna labí tte dákanie. ");
INSERT INTO zae_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Aní diani ka tisa‑ni innákana, delába xuxtilaha nuha anke ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ka xua utsa ro'o nedaha nna ankake ka benne riyiencanie ka tisa ge Tata Do Yebáha, ttaka daa tteba nu xxegwiha nna rebea ttebana ka tisaha lhe'e lastoke. Aníha ruinna kini abittu tsia leke lhe kini abittu odilá Tata Do Yebáha ke lhe. ");
INSERT INTO zae_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ka xua utsa lo íyya atta'aha nna ankake ka benne ittaba du leke, riyienkanie ka tisaha nna ria leke ka benneha. Ttaka kumu de abí galá chi begwe lhu ka tisaha lhe'e lastoke, laxkala gwa riaba leke ttu satti, ttaka tti risia rateke ttu bixa, la'ania nna reyadi gaa ttebake. ");
INSERT INTO zae_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ka xua utsa lhe'e yietsiha nna ankake ka benne riyienkanie ka tisaha. Ttaka tti tee ka elhaxchacha iki geke lhe tti rudona leke gatta geke, anágaba lhe tti rite leke uinke nu raka yiesi lo yu‑ni, la'ania nna iyá nuha runi kini bittu se'e tsitsike lo neda ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ttaka ka xua ubinni ata do taga'a yuha nna ankake ka benne riyienkanie ka tisaha nna itú iki itú leke rudaxxuke ka tisaha. Anágaba nna labí rudú siike ruinke nu ra ka benneha. ");
INSERT INTO zae_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Lanú ttu benne do rugalhe iki ttu gi nu rudani, delo nna uttudhie ttu bixa ikini kini abittu ilá o lhe ukatsie na xan ata ratteha. ¿Laaba ganna teeki udoe nuha gwetsá kini udenna ge ka benne ga'a lhe'e yo'oha? ");
INSERT INTO zae_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nigaba labí ttu bixa tee gatsi nna abí eselana; nigaba ttu bixa raka sigá nna abí una ka benne geni lhe abittu iriana la loo lhe. ");
INSERT INTO zae_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Laxkala gwaludo tsitsi nagale gasina rite denle nu rinnea‑ni, kumu ganna ttu benne gwa rite dábanie ka tisa kia‑ni, la'ania nna gwate da chiettirulin benneha. Ttaka ganna ttu benne abíba rite danie, la'ania nna iyála nu rakanie deki chi rite danieha, etua. ");
INSERT INTO zae_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nan ge Jesús‑ni lhe ka betsieha lhe diake ata dueha, ttaka labí uka ibigake arloe, kumu de tupa xxatta ka benne. ");
INSERT INTO zae_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ttaka ttu benne du niha nna utixxi'anie bie, ree: ―Ne nan geluha lhe ka betsiluha lhe se'eke ro'o yo'o‑ni raka leke inne lenke lu. ");
INSERT INTO zae_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Labie nna bekabilee ree: ―Ka benne gwa riyienkanie ka tisa ge Tata Do Yebáha nna rudoke tisa gebie, ka benne‑na nuná ankake nan kia lhe ka betsia lhe. ");
INSERT INTO zae_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ttu sá uta'a Jesús‑ni lenie ka benne rudhetinieha lhe'e ttu barcu. Nianna ree ka benneha: ―Tteri'i lo indatoo‑ni kini iriari'i daka ro'oni nu reha. Nianna tti uta'ake diake. ");
INSERT INTO zae_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Laka yu'uke neda lo indaha nna uta'adhi Jesús‑ni nna ttiruba bisia ttu be idí lo indaha nna chi risá lhe'e barcuha inda nna chi ruxunnina geke xxudike lhi'u. ");
INSERT INTO zae_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nianna gwadiben ttebake Jesús‑ni, ráke bie: ―¡Bebaniruga xa tata! ¡Karubá tsapiri'i inda‑ni nna gattiri'i! Jesús‑ni nna ugwadha ttebe nna bedhaka dise beha lhe bedhaka dise nu ridú lii lo indaha lhe. Nianna siiba beyaka lo indatooha. ");
INSERT INTO zae_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nianna tti ree ka benne rudhetinieha: ―¿Gála gwa dule nu chi ria lele ge Tata Do Yebáha? Ttaka lake nna itú rasibakanie lhe rugía ya'abake nna rinnaba tisa luesike, ráke: ―¿Nú anka benne du nii nna axtaba be‑na lhe axtaba inda‑na rulise nna gwa rudobakana tisa gebie? ");
INSERT INTO zae_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tti biriake ro'o indaha nna bisinke lo yu ge ka benne Gadara. Gadara rena arlo Galilea‑ni daka ro'o indaha nu reha. ");
INSERT INTO zae_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tti ugwadi Jesús‑ni lo barcuha, nianna betetsá ttu nubiyú ge lhe'esiha bie, yu'u ka espíritu xxegwi latini. Chi usá labíru ruku xoni lhe labíru dona lhe'e yo'o lhe. Saná lo ka baa ge ka benne yattiha, niha‑ba reya'anna. ");
INSERT INTO zae_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Atti bilen nubiyúha Jesús‑ni, nianna uresi'ana idisa nna tti bedú xibini arloe nna unnena itú leni, rane: ―¡Jesús Xi'in Tata Do Yebaa benne ra xxeni leeha, bittu etega'a gelu len neti! ¡Rinnabaa lenlu bittu ugwelu neti elha disa! ");
INSERT INTO zae_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Aníha ra nubiyúha kumu Jesús‑ni chi rudhaka dise espíritu satsa yu'u latiniha kini eriana. Kumu ixe lidú resia nuha lati nubiyúha, laxkala meskiba bika ruxxikakana na len cadena lhe len ka iyya lhe, ttaka lana nna richúbana ka nuha, nianna tti ribea nu xxegwiha na lo yu bisi ata lanú benne se'e. ");
INSERT INTO zae_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús‑ni nna unnaba tise, ree na: ―¿Bí lálu? Lana nna bekabina, rane: ―Legión‑ba lá neti. Aníha tee láni kumu ixe ka espíritu xxegwi chi uta'a latini. ");
INSERT INTO zae_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ka nu xxegwiha nna rinnabakana len Jesús‑ni ki abittu udelhe kana lhe'e belha'a chulha ata se'e adíru ka espíritu xxegwiha. ");
INSERT INTO zae_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lati ttu i'iya do niha yu'u ixeru ka kuchi rekikana ugila go. Laxkala ka espíritu xxegwiha nna unnabakana lenie ki ugwelhe kana sata'akana lati ka kuchiha. Lee nna “O” ba ree, begwelhabe beta'akana lati ka nuha. ");
INSERT INTO zae_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ka espíritu xxegwiha nna beriabakana lati nubiyúha nna gwata'akana lati ka kuchiha. Ttaka ka kuchiha nna biria resu tteba ka nuha ugwadikana nna biriakana ro'o ttu íyya daa niha nna ubinnikana lhe'e indaha. Nianna ugwapikana indaha nna uttibakana. ");
INSERT INTO zae_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ka benne ruyúke ka kuchiha, tti bilákanie nu chi ukaha, nianna boxunni ttebake deyyake gwattixxi'ake nuha lhe'esiha lhe gwattixxi'akanie ka benne se'e lhe'exxi itúba ka niha. ");
INSERT INTO zae_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nianna biria tteba ka benne gwalannike nu chi ukaha. Tti bisinke ata du Jesús‑ni nna gwaxxakake nubiyú nu chi beria ka espíritu xxegwiha latini, dona arloe. Chi beyoku xoni lhe chi beriana ikini lhe. Nianna usilakanie. ");
INSERT INTO zae_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ka benne bilákanie nu ukaha nna utixxi'akanie ka benne gasina uka kini beyaka tse nubiyú uyu'u ka espíritu xxegwiha latini. ");
INSERT INTO zae_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nianna iyába ka benne se'e itúba daka lo yu ge Gadara, de rasi xxattakanie, de nuha nna unnabake len Jesús‑ni kini eriabie lo yu gekeha nna eyye attu ta subi. Aníha uka nna beta'a Jesús‑ni lhe'e barcuha nna deyye. ");
INSERT INTO zae_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nubiyú beria ka espíritu xxegwiha latini nna unnabana len Jesús‑ni kini ugwelhe na tanalhane. Ttaka Jesús‑ni nna bekabie geni, ree na: ");
INSERT INTO zae_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Beyya lisilu nna utixxi'a iyá nu chi ben Tata Do Yebáha lenlu. Nubiyúha nna itúba lhe'esiha deyyana rigixxi'ana nu chi ben Jesús‑ni lenna. ");
INSERT INTO zae_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tti beyeki Jesús‑ni lo indatooha besine, ixe juisiru ka benne chi se'eke ubede. Nianna redeakabakanie tti bilákanie besine. ");
INSERT INTO zae_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nuha‑ba raka nna tti bisin ttu nubiyú tee láni Jairo. Jairo‑ni baninna yo'o ata ritupa ka nu Israel‑ni rudhetikana ka tisa ge Tata Do Yebáha. Nubiyúha tti bisinna ata du Jesús‑ni nna bedú xibini arloe nna unnabana lenie kini tsie lisiniha ");
INSERT INTO zae_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kumu xi'iniunnániha chiba ratti nuha. Ttúru nuha xi'iniunnáni do nna chila ankin nuha ttiba ttu tsi'inu (12) ida. Jesús‑ni nna tti yu'e neda die, axtaba rukí ya'akane kumu ixe juisiru ka benne dia danalhake bie. ");
INSERT INTO zae_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lhe'e ka benneha sela ttu benne nuila. Chiba uka ttu tsi'inu (12) ida ridobie reni nna iyába belhiu nu tee geeha chi betse'e looe de rekie lo ka nu ruin ramedi, ttaka ni ttú ka nuha a udaakana eyoinkane. ");
INSERT INTO zae_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Benne nuilaha ubige daka kwe'e Jesús‑ni nna gwattáne ro'o lari nuku benneha. Looraha tteba nna udú sii tteba reniha. ");
INSERT INTO zae_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nianna tti ra Jesús‑ni: ―¿Núle nuní chi betettanle ro'o xoa‑ni? Ttaka iyábake ráke: ―Labí chi betettan ri'itu ro'o xolu. Nianna ra Pedro‑ni: ―Ka benne danalhaniba nuní rukí ya'ake lu xa tata. ");
INSERT INTO zae_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ttaka Jesús‑ni nna rabie: ―Nuxa nuní chi betettanna ro'o xoa‑ni, kumu neti chi ute dati biria nu tsitsi ra lasia beyonia ttu benne. ");
INSERT INTO zae_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tti bilani benne nuilaha abíba aka igatsi nu benieha, nianna itú rixidibe ubige bedú xibie arlo Jesús‑ni. Utixxi'e lo iyába ka benne se'e niha bí lo ni'a ge betettane ro'o xo Jesús‑ni lhe utixxi'agabe deki tti loora bedaxxue ro'o xo benneha nna beyaka ttebe. ");
INSERT INTO zae_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús‑ni nna rabie benneha: ―Xi'ini to, de ugía lelu deki gwadaabaa eyonia lu, de nuha nna chiba beyakalu. Nnanna nna xen su lasiba beyya. ");
INSERT INTO zae_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sa dula Jesús‑ni rinnebie, ttiru chi bisin ttu nu udá lhe'e lisi Jairo‑ni nna utixxi'enna na, rana na: ―Chi utti xi'iniunnáluha, laxkala bitturu uinlu doelha ichelu maestru‑ni. ");
INSERT INTO zae_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tti biyienin Jesús‑ni nu ra nubiyúha, nianna tti unnebie ree Jairo‑ni: ―Bittu gasinlu. Sun tteba tsia lelu nna gweyakaba xi'iniunnáluha. ");
INSERT INTO zae_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tti uta'abie lhe'e yo'o ge Jairo‑ni nna labí begwelhe ga'a nuxa lenie lhe'e yo'oha, sunruba Pedro‑ni lhe Jacobo‑ni lhe Juan‑ni lhe ka tata nan ge nuila toha lhe. ");
INSERT INTO zae_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iyába ka benne se'e niha ribesike lhe relenkanie ge nuila toha. Ttaka Jesús‑ni nna ree ke: ―Bittu kwesile. Laa uttiga bi'in‑ni, te'adhiba bi'in‑ni. ");
INSERT INTO zae_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Lakana nna bexisilakana gebie kumu yúbakana chiba utti nuila toha. ");
INSERT INTO zae_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nianna tti bedaxxue ná nuila toha nna tti unnebie idisa, ree: ―¡Nuila to, beyadha! ");
INSERT INTO zae_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nuila toha nna beyaka ben ttebabi nna beyadha ttebabi. Jesús‑ni nna rabie ka benne se'e niha ugoke bi yetta. ");
INSERT INTO zae_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ka tata nan ge nuila toha nna yalhá rebanakanie se'eke; ttaka Jesús‑ni nna ree ke: ―Anuttu nu kixxi'enle ge nu chi uka‑ni. ");
INSERT INTO zae_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús‑ni bottupe ka benne tsi'inu (12) rudhetinieha nna begwebie ke lo neda kini ebeake iyába ka espíritu xxegwi yu'u lati ka benne lhe ki ebeake ka isagwe yu'u latike lhe. ");
INSERT INTO zae_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nianna udhelhe ke ki tsiake kixxi'ake gasina ki akake benne innabia Tata Do Yebáha ka benne lhe kini eyoinke ka benne rani lhe. ");
INSERT INTO zae_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nianna ree ke: ―Bittu ichele bixa ixuinle neda: bittu dhen garroti gele, nigaba uja chuba gele lhe nigaba uja nu gole o dhenle belhiu lhe. Bittugaba uja chupa kwe xole. ");
INSERT INTO zae_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Gaxaba lhe'e yo'o isinle, niha‑ba gwaltse'e, edálibale nna eriale niha. ");
INSERT INTO zae_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ganna lhe'e ttu yiesi abittu ulabikana le, gwaleria lhe'e yiesiha nna gwalukubi biste ni'ale kini nuha unna liina deki Tata Do Yebáha labí uyu'u lebie nu benkana. ");
INSERT INTO zae_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ka benneha nna biriake diake nna riteke lhe'e iyába ka yiesi to se'e itúba ka niha. Rigixxi'akanie ka benne ka tisa tse lhe reyoinke ka benne rani lhe. ");
INSERT INTO zae_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes nu rinnabiaha, tti binana ge iyá nu ruin Jesús‑ni, nigaba a yuna bixa ulaba leni, kumu adí ka benne ráke deki Juan‑niba nuha chi beyaka benna lagwi ge ka benne chi uttiha. ");
INSERT INTO zae_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Attu chupake nna redenáke: “Elías‑niba nuná besia.” Adíke nna redenáke: “Ttu ka profeta use'e itú nu reha‑ba nuná chi beyaka bani.” ");
INSERT INTO zae_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ttaka Herodes‑ni nna rana: ―Ki kwinaba neti udhelhaa uchúkana iki Juan‑ni, ¿núla ge nuná riyienti rinne xxattakana ganna? De nuha nna Herodes‑ni yalhá re leni ilenna Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tti beyeki ka apóstol udhelha Jesús‑ni, ka benneha nna utixxi'akanie bie bipaxa benke ata ugíakeha. Nianna suna labake dechebie nna beru'unake daka lo yu bisi ge lhe'esi Betsaida‑ni. ");
INSERT INTO zae_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ttaka tti bina adíru ka benne deki rebie niha, nianna dia ttebake gwanalhake bie. Labie nna gwa belabibe ka benneha, nianna rigixxi'anie ke gasina ki akake benne innabia Tata Do Yebáha lhe anágaba nna reyonie ka benne rani lhe. ");
INSERT INTO zae_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ttaka atti chi kwe ubisa‑na loeyya‑na, ubiga ka benne tsi'inu rudhetinieha (12) ata dueha nna ráke bie: ―Bedhelhala ka benne tupa nii kini eyyake lhe'e ka yiesi to‑na lhe lhe'e ka yo'o lhe'exxi ka nu sia abi'iba ka nii kini eya'anke lhe ki kilake nu goke lhe. Kumu ata se'eri'i‑ni yu bisiba nuní, labí bi tee nii. ");
INSERT INTO zae_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Lee nna rabie ke: ―Lebi'iba gwalugwe ka benne‑ni nu goke. Ka benneha nna ráke: ―Bi den ri'itu. Ne sunruba gayu ka yettaxtila nna chupa ka belha dentu. Laaruba ganna tsiabatu tayo'otu nu go iyá ka benne tupa nii. ");
INSERT INTO zae_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kumu ttiba ttu gayu mili anka ka benne biyúha. Jesús‑ni nna rabie ka benne rudhetinieha: ―Tsieyona (50), tsieyona ka benne‑na gwaluse'e ttu ttu dhi. ");
INSERT INTO zae_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aníha‑ba benke nna bese'eke iyá ka benneha. ");
INSERT INTO zae_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesús‑ni nna bedaxxue gayu ka yettaxtilaha nna a chupa ka belhaha, nianna tti belhidha lobie yebáha nna begwebie ixkixaru len Tata Do Yebáha, nianna tti ulha'abie lhe'e ka benneha. Begwebie ka benne rudhetinieha kini kidhike ugweke ka benne tupa niha. ");
INSERT INTO zae_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Iyába ka benneha utoke nna beyielalibakanie. Nianna bottuparulake a tsi'inu (12) sumi ka ro'o salha'a bexxaha. ");
INSERT INTO zae_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ttu sá ttúba Jesús‑ni doe rilhapie tisa len Tata Do Yebáha. Niha‑gaba se'e ka benne rudhetinieha. Nianna tti unnaba tise ka benneha, rabie ke: ―¿Nú ra ka benne deki ankaa? ");
INSERT INTO zae_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Lake nna bekabike, ráke: ―Ttu chupa ka benne ráke deki lu ankalu Juan benne begadi indaha. Attu a chupake nna ráke deki lu ankalu Elías. Adíke nna redenáke: “Ttu ka profeta use'e itú nu reha‑ba nuná, chi beyaka benna.” ");
INSERT INTO zae_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesús‑ni nna rabie ke: ―Lebi'i nna, ¿núla rale deki ankaa? Pedro‑ni nna bekabina, rana: ―Lu ankalu Cristu benne udhelha Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ttaka Jesús‑ni nna bedha'an tsitsie, ree ke: ―Anuttu nu kixxi'enle. ");
INSERT INTO zae_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nianna tti ree ke: ―Neti benne daya yebáha, teeki tate xxattaa uyúa elha disa. Ka benneola geri'i‑ni lhe ka nu loni ge ka bixxudiha, lhe anágaba ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni, ka nuha ku'uba ni'akani neti lhe uttibakana neti lhe. Ttaka ganna chi beyonna ubisiha nna eyaka benbaa. ");
INSERT INTO zae_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nianna tti ree iyába ka benneha: ―Ganna nuxa ttúle raka lele etenalhale neti, teeki eria iki eria lele, meskila bixa satele nna udaxxu kurusi gele ttu ttu sá nna etenalhale neti. ");
INSERT INTO zae_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kumu ttu benne ganna abittuba raka lebie bixa satebie de etenalhe neti, benneha nnittilee, delába labí aka ben benneha arlo Tata Do Yebáha. Ttaka benne eria iki eria lebie etenalhe neti meskila bixa satebie de etenalhe neti, benneha gwalálee arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kumu, ¿bí ixú nuha ganna ttixka nuxa ttu benne dhaabie uin gebie iyá nu se'e yiesi lo yu‑ni, delo nna la labe nnittie arlo Tata Do Yebáha? ");
INSERT INTO zae_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kumu ganna ttu benne ettunie kia lhe ettunie ge ka tisa kia‑ni lhe, anágaba neti benne daya yebáha, ettugabati gebie ganna chi dedáya lhe'e xiani kiaha lhe lhe'e xiani ge Tata kia do yebáha, lhe lhe'e xiani ge ka anjeli geeha lhe. ");
INSERT INTO zae_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Neti gwalígati, ttu chupale ka nu se'ele nii nnanna, axtaliba ganna chi ilenle innabia Tata Do Yebáha, la'anialiba gattile. ");
INSERT INTO zae_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iki de chi ute ttu xxunu ubisa unne Jesús‑ni nuha, nianna chebie Pedro‑ni lhe Juan‑ni lhe Jacobo‑ni lhe ugwapike iki ttu i'iya do niha kini ilhapie tisa len Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Laka dobie rinnebie len benneha nna besea lobie. Sitsi túba lhe rapi edha linníba lo xobie. ");
INSERT INTO zae_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nianna tti uka xxe chupa ka benne biyú unne lenke bie. Moisés‑niba nuha lenna Elías‑ni. ");
INSERT INTO zae_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ka benneha abi'iba ata se'ekeha yu'u chába xiani, nianna rinne lenke Jesús‑ni ge elhutti chi ga'anna satebie lhe'esi Jerusalén‑ni. ");
INSERT INTO zae_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro‑ni lhe a chupa ka benne se'e lenieha, yalhá chi daa bisiela loke, ttaka nna gwa udaabake use'e tennáke, nianna bilákanie xiani ge Jesús‑ni lhe ge a chupa ka benneha lhe. ");
INSERT INTO zae_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tti chi reru'una ka benneha ata du Jesús‑ni, nianna unne Pedro‑ni, rane: ―¡Gwen tte uka se'etu nii xa tata! Usiatu tsunna ka yo'o lhaga gele: ttu gelu nna ttu ge Moisés‑ni nna attu ge Elías‑ni nna. Ttaka Pedro‑ni nna labí yuna bixa nuha rana. ");
INSERT INTO zae_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Laka duna rinnenaha, nianna tti bebe ttu bea ata se'ekeha. Tti ute dákanie se'eke lhe'e beaha, nianna tti usikanie. ");
INSERT INTO zae_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lhe'e beaha nna biyien tsi'i ttu benne, unnebie ree: ―Benne‑ni anke Xi'inia lhe rakati gebie lhe. Ge benne‑ni gwaludo nagale. ");
INSERT INTO zae_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Iki de chi biyienkanie tsi'i benne unneeha, la'ania nna a sunruba Jesús‑ni bilákanie due niha. Lake nna siiba ukake; lanú nu utixxi'akanie ge nu bilákanieha. ");
INSERT INTO zae_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Attu dilaha nna tti beyadike iki i'iyaha dedáke, ixe juisiru ka benne biriake gwatsáke Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lhe'e ka benneha sela ttu benne biyú nna unnebie idisa, ree: ―Biyúruttu nu kwiti kia‑ni xa tata maestru. Bichisilá ttúru nuní doti. ");
INSERT INTO zae_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ttu espíritu ge nu xxegwiha ra'ana latini lhe rukwesi'ana na lhe rukwalhana na lhe anágaba ribeagabana inda kuchina ro'oni lhe rigin xxattana na lo yu nna labí reriaxxina latini. ");
INSERT INTO zae_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Chigaba unnabaa len ka benne rudhetinlu‑ni kini ebeake espíritu yu'u latin‑ni, ttaka labí udaake. ");
INSERT INTO zae_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús‑ni nna bekabie, ree ka benne rudhetinieha: ―¡Aalexa lebi'i, ka nu abí ria lele lhe abí du itá lele lhe! ¿Nukalila sa dhua len lebi'i lhe sa utto uchíaya nu ruinle lhe? Aní utá len nu kwiti gelu‑na. ");
INSERT INTO zae_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tti dia nu kwitiha ribigana ata du Jesús‑ni, nianna bedegu'una espíritu xxegwiha na lo yu nna bere xxattana na íyya. Ttaka Jesús‑ni nna bedhaka dise nu xxegwi yu'u lati nu kwitiha, nianna beyonie na. Nianna tti rabie tata geniha: ―Ne nu kwiti geluha du nii. ");
INSERT INTO zae_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Iyába ka benne se'e niha nna bebanabakanie ge nu xxeni ra le Tata Do Yebáha. Laka se'e iyá ka benneha rebanabakanie ge iyá nu ruin Jesús‑ni, labie nna ree ka benne rudhetinieha: ");
INSERT INTO zae_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Gwaludo tsitsi nagale nu upeya le. Neti benne daya yebáha, teeki utekana neti lasi ná ka nu uttikana neti. ");
INSERT INTO zae_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ttaka lake nna labí rite dákanie bí ge nuha rinnebie, kumu Tata Do Yebáha labí chi begwelhe ki tte dákanie. Gwea nna rasigabakanie innaba tisake Jesús‑ni kini kixxi'e bixa diani nu reeha. ");
INSERT INTO zae_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nianna udulokana rulisa luesikani ra luesikani: ―Delo iyári'i, ¿núri'i nuní ra xxeniru leri'i? ");
INSERT INTO zae_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ttaka Jesús‑ni nna ute dábanie nu rulaba lekaniha. Nianna tti bedaxxue ttu nuto nna bedúe na daka lhitte, ");
INSERT INTO zae_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","nianna ree: ―Benne ulabie nuto du‑ni de ria lebie neti, neti nuha ulabie lhe nuxaba benne ganna ulabie neti, benne udhelhe netiha nuha rulabie. Laxkala delo iyá ttele, benne abittu ra xxeni leeha, benneha‑la nuha anke nu ra xxeniru lebie. ");
INSERT INTO zae_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan‑ni nna unnena, rana: ―Maestru, ri'itu chi bilentu ttu nu reki naa, tti rudettina lálu nna rebeana ka espíritu xxegwi yu'u lati ka benne. Ri'itu chi bentu usunatu kini abittu uinna aná, kumu de labí selana ri'i. ");
INSERT INTO zae_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ttaka Jesús‑ni nna ree na: ―Bittu usunale, kumu benne abittu rigu'u ni'e nu ruinri'i, gwa duba benneha lenri'i. ");
INSERT INTO zae_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tti chi dabigana isia sá eyapi Jesús‑ni yebáha, nianna bebeki lebie tsie lhe'esi Jerusalén‑ni. ");
INSERT INTO zae_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Lade'axa udhelhe ttu chupa ka benne diake nneruke. Ka benneha nna uta'ake lhe'e ttu yiesi re daka Samaria kini kilake gaxa eya'ane. ");
INSERT INTO zae_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ttaka ka benne Samaria‑ni labí uka leke ulabike bie, kumu de ute dákanie daka Jerusalén‑nila diabie. ");
INSERT INTO zae_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ka benne rudhetinieha nna, delába Jacobo‑ni lhe Juan‑ni lhe, tti bilákanie nu ukaha, nianna ráke bie: ―Tata, ¿si gwaka lelu uintu ki iginni gi daa yebáha ki utse'e loona kana? ");
INSERT INTO zae_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ttaka Jesús‑ni nna beyekie nna bedhaka dise ke. ");
INSERT INTO zae_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nianna dia ttebake lhe'e attu yiesi. ");
INSERT INTO zae_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Laka yu'uke neda diake, nianna tti ra ttu benne Jesús‑ni: ―Tata, neti gwetenalhabaa kwinalu gaxaba tsialu. ");
INSERT INTO zae_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús‑ni nna bekabie ge benne unneeha, ree bie: ―Ka beda‑na siaba lisi ka nuná ata reta'akana lhe anágaba ka nu sia xxilakani reki lo be‑na siaba lixxu'in ka nuná ata rebiakana, ttaka neti, benne daya yebáha, labí do gaxa kixxa ikia. ");
INSERT INTO zae_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nianna tti redea Jesús‑ni attu benne: ―Utá, betenalha neti. Benneha nna bekabie gebie, ree: ―Tata, begwelhaxa eya'aya takatsia tata kiaha. Iki deliba nuha nna tti itaa etenalhaa lu. ");
INSERT INTO zae_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús‑ni nna bekabie ge benneha, ree: ―Begwelha ka nu yatti‑na ukatsikana ka nu yatti gekinna. Lu nna ugweki utixxi'en ka benne gasina ki akake benne innabia Tata Do Yebáha ke. ");
INSERT INTO zae_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Attue nna redee Jesús‑ni: ―Neti gwetenalhabaa lu xa tata, deba nna begwelhaxa eya'aya sachú tisaha ka benne se'e lhe'e lisiaha. ");
INSERT INTO zae_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús‑ni nna bekabie ge benneha, ree: ―Benne rudaxxue xan belasuha, ganna sa rodekiba loe rulannie daka kwe'ebie, benneha labí nu ixú anke ata rinnabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Iki de nu chi ukaha nna tti bodokwe Jesús‑ni a gayuna bixxi tsi'inu (72) ka benne. Ka benneha nuha udhelhe chupa chupake kini uneruke loe nna tteke lhe'e iyába ka yiesi lhe ata chi ga'anna tsie lhe. ");
INSERT INTO zae_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nianna ree ka benneha: ―Yalhá ixeni lena tee exú, ttaka ka benne edíke lena‑ni ttu chuparubake raka, kumu ixeba ka benne se'e riyasakanie iyienkanie ka tisa ge Tata Do Yebáha, ttaka ka benne rigixxi'ake ka tisa geeha, ttu chuparubake raka. De nuha nna gwalinnaba len Tata Do Yebáha, delába benne anke Xxana ka benne riyasakanie iyienkanie ka tisaha, kini idhelharue ka benne kixxi'akanie ke. ");
INSERT INTO zae_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Lebi'i gwaltsia nna gwaluyúruga, neti ridhelhaa le attiba ttu nu ridhelhana ka neru xka'a to diakana lagwi ge ka sageo. ");
INSERT INTO zae_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bittu dhen belhiu gele lhe nigaba uja beduti gele ata ku'ule nu ixuinle lhe nigaba uja gwaracha gele, lhe anágaba bittu kwedale lo neda gale ka benne padiuxi. ");
INSERT INTO zae_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tti ga'ale lhe'e ttu yo'o, lade'axa gwaligasi ka benne se'e lhe'e yo'oha: “Besiru gwaltse'e.” ");
INSERT INTO zae_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ganna lhe'e yo'oha se'e ka benne gwa raka leke tse'e tseke len Tata Do Yebáha, la'ania nna gwakaba nu rale ka benneha. Ttaka ganna abíba nna la'ania nna labí aka nu unnabaleha. ");
INSERT INTO zae_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Lhe'e yo'o ata isinleha, niha‑ba gwaltse'e, lhe anágaba gwali'aba lhe gwaligoba nu uteke, kumu ttu benne riben sina ralhaba benneha dhibie nu goe. Aná nna bittu eriale ttu yo'o nna sadita'ale attu yo'o. ");
INSERT INTO zae_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Atti isinle lhe'e ttu yiesi ata gulabibakana le, gwaligo iyába nu usigakana lole ");
INSERT INTO zae_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","nna gwaleyoin ka benne rani se'e lhe'e yo'oha lhe gwaligágaba ke: “Lebi'i, chiba dabiga isia sá innabia Tata Do Yebáha le.” ");
INSERT INTO zae_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ttaka ganna isinle lhe'e ttu yiesi nna abíba ulabikana le, nianna gwaleria lo ka neda ge lhe'esiha nna gwalinná: ");
INSERT INTO zae_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“¡Axtaba biste ge lhe'esi gele‑ni nu utá lasi ni'atu, axtaba nuní rukubitu kini utte dale deki labí ben tsele len ri'itu! Ttaka chi rigixxi'entu le deki chiba dabigana innabia Tata Do Yebáha.” ");
INSERT INTO zae_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Neti ria: Ganna chi isia sá uyú ka benne elha disaha, adírula elha disa tsitsi uyú ka benne se'e lhe'e yiesi ata labí ulabikana leha attichula elha disa uyú ka benne se'e lhe'esi Sodoma‑ni. ");
INSERT INTO zae_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Gwalíchi lele xa benne lhe'esi Corazín! ¡Gwalíchi lele xa benne lhe'esi Betsaida! Ganna lhe'esi Tiro‑ni lhe lhe'esi Sidón‑ni lhe chi uka ka milagru ka nu chi uka lhe'e ka yiesi gele‑na, la nukala chi bodúna ka nuha nna bodaxxukana neda ge Tata Do Yebáha. Nianna tti uku xo ttipa gekani nna tse'ekana lo tee ge gi, kini ula'a deki gwalí chi bodúna kana. ");
INSERT INTO zae_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Laxkala ganna chi isia sá tti uin Tata Do Yebáha elhuxtisi ge ka benne, la'ania adírula tsitsi anka elha disa ugwebie le attichula elha disa tsitsi uyú ka benne ge Tiro‑ni lhe ge Sidón‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Lebi'i nna ka benne lhe'esi Capernaum, ¿si rakinle deki yebáha‑li eyapile? ¡Ko'o, labí! ¡Lhe'e belha'a chulhaha‑li iginnile ata uyúle elha disa! Nianna redeabie ka benne udhelheha: ");
INSERT INTO zae_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","―Benne udo nage gele, kia nuha rudo naga benneha nna benne abittu ulabie le, neti nuha abittu rulabi benneha nna benne a ulabie netiha nna benne udhelhe netiha nuha abittu rulabie. ");
INSERT INTO zae_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tti besin ka benne gayuna bixxi tsi'inu (72) udhelha Jesús‑ni, yalhá itta du leke, ráke: ―Tata, axtaba ka espíritu xxegwiha rudokana tisa getu tti bedettitu lálu. ");
INSERT INTO zae_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús‑ni nna rabie ke: ―Gwalí galá. Neti bilábati tti biginni nu xxegwiha dana yebáha, ttiba ttu edha biginnina. ");
INSERT INTO zae_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Neti chi betea lo neda gele kini uleale iki ka belha lhe iki ka ro'o chupa nna labí bi satele. Anágaba chi betea lo neda gele kini dhaale lo nu abittu raka uyúna ri'iha, delába nu xxegwi ra tsitsi leniha. ");
INSERT INTO zae_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ttaka lebi'i, labí edeakinle de chi rudo ka espíritu xxegwiha tisa gele. Lebi'i, gwaledeakalinle kumu de chi dia lále yebáha. ");
INSERT INTO zae_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nuha‑ba ra Jesús‑ni tti bodú itta Espíritu ge Tata Do Yebáha lebie, nianna bedeakanie nna ree: ―Tata, kwinalu ankalu Xxana yebáha lhe yiesi lo yu‑ni lhe. Xxeni ra lelu kumu chi bele'elu iyá nuní len ka benne abí tte raka geke nna bekatsilu nuní len ka nu yu lhe len ka nu rite dárukinna lhe. Gwalí galá xa Tata, kumu aná uka le kwinalu aka. Nianna ree kana: ");
INSERT INTO zae_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","―Tata kiaha iyába chi betebie lasi náya lhe anágaba lanú nu ankabienna neti benne ankaa Xi'inieha, sunruba Tataha gwankabianie neti lhe lanú nu ankabienna Tataha, sunruba neti benne ankaa Xi'inieha ankabiati benneha, lhe anágaba sunruba ka benne raka lasia ule'enia ke benneha ki uinbiake bie. ");
INSERT INTO zae_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nianna tti bodeki loe ata se'e ka benne rudhetinieha nna suna ka benneha‑ba rabie: ―¡Karubáru ka benne rilákanie nu rilenle‑ni! ");
INSERT INTO zae_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kumu neti ria le, ixe ka profeta lhe ixe ka nu rinnabia lhe, yalhá ukakinna ilákinna nu rilenle nnanna, ttaka labí bilákinna nuní. Ukagabakinna iyienikinna ka tisa riyieninle nnanna, ttaka labí biyienkinna. ");
INSERT INTO zae_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ttu ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni ruinna ku'una Jesús‑ni prueba. Nianna udú liina unnaba tisane, rane: ―Maestru, ¿bíla teeki unia ki aka bania ttu dia lii? ");
INSERT INTO zae_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús‑ni nna bekabie geni, ree: ―¿Bíla ra lo bia bennabi‑na? ¿Bíla rite denlu nu ra lo nuná? ");
INSERT INTO zae_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nu rule'enna ka benne nu ra lo bia bennabiha nna bekabina, rana: ―Lo nuní dia ra: “Akinlu ge Tata Do Yebaa benne anka Xxanaluha itú iki itú lelu lhe akagabinlu ge attu benne atti tteba rakinlu gelu.” ");
INSERT INTO zae_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús‑ni nna rabie na: ―Tseba bekabilu. Ganna uinlu aní nna gwaka benbalu ttu dia lii. ");
INSERT INTO zae_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ttaka nu rule'enna ka benne nu ra lo bia bennabiha nna ruinna deki bittuba rite denna. Nianna rana Jesús‑ni: ―¿Núla benne nuha akati gebie ganna? ");
INSERT INTO zae_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús‑ni nna bekabie geni, ree: ―Ttu nubiyú biriana lhe'esi Jerusalén‑ni nna diana lhe'esi Jericó. Lo nedaha biria ka ubana ulanakana na, axtaba ka xoniha utuakana lhe uyakana na lhe, tuttíruba bechulhinna. Niha‑ba utixxakana nubiyúha nna deyyakana. ");
INSERT INTO zae_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Lo nedaha‑gaba dia ttu bixxudi. Ttaka tti bilenna nubiyúha tena niha, lana nna bekwittalana nna utena diana. ");
INSERT INTO zae_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Aníha‑gaba bedoin ttu levita, tti bisinna ata tee nubiyúha, tti bilenna benneha nna bodokwittagabana nna utena diana. ");
INSERT INTO zae_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ttaka ttu benne biyú ge Samaria, la lo nedaha‑gaba die. Tti bilánie nubiyúha tena niha, nianna gwatua lebie na ");
INSERT INTO zae_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","nna tti ubige ata tee nubiyúha, utabie seti lhe vinu lo ka gweha, nianna bechilhie lari lo ka nuha. Iki de nuha nna belhapie nubiyúha kwe'e bia geeha nna dechebie na ata do ttu yo'o reya'an ka benne yu'u neda. Niha‑ba biyúe na. ");
INSERT INTO zae_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Beyeki dilaha nna ulea benne ge Samaria‑ni chupa ka belhiu nu anka lhiaxa ge chupa ubisa sina, begwebie xxana yo'oha nna ree nuha: “Biyú tsitsittu nubiyú‑ni. Ganna utse'e loorulu nna neti gwagixabaa gelu ganna chi besiayaha.” ");
INSERT INTO zae_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nianna ra Jesús‑ni nu rule'enna ka benne nu ra lo bia bennabiha: ―Nnanna nna unáchu, delo iyunna ka nubiyú ute niha, ¿nú ka nuha rakinlu deki gwa ukakinna ge benne uya ka ubanaha? ");
INSERT INTO zae_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nu rule'enna ka benne nu ra lo bia bennabiha nna bekabina, rane: ―Nubiyú nu gwatua leni benneha, lana nuha gwa ukinna gebie. Jesús‑ni nna ree na: ―Nnanna nna lu beyya nna aníha‑gaba beni. ");
INSERT INTO zae_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús‑ni yu'ubie neda die len ka benne rudhetinieha nna bisine lhe'e ttu yiesi to re niha. Lhe'e yiesi toha do ttu nuila lána Marta. Lana nna gwa belabibane lhe'e lisiniha. ");
INSERT INTO zae_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta‑ni do ttu xilani lána María. María‑ni nna ure ttebana arlo Jesús‑ni kini rudo nagani ge ka tisa rigixxi'eha. ");
INSERT INTO zae_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ttaka Marta‑ni si ruchachala ikini de tee xxatta sina geni lhe'e yo'oha. Nianna tti ubigana, rana Jesús‑ni: ―Tata, ¿si abí gwa retabinlu kia? Nuila xilaa‑ni, suna netiba rodha'anna sina‑ni. Usi na ute gaa náni len neti. ");
INSERT INTO zae_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ttaka Jesús‑ni nna bekabie geni, ree na: ―Lu xa Marta, ge ixeba nu ruchacha ikilu lhe ge ixeba riuba xxattinlu lhe. ");
INSERT INTO zae_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ttaka teela ttu nu rakaru doelha. María‑ni nna chi bekwena ttu nu anka tseru, delába rudo nagani ka tisa kia‑ni nna lanú nu kuana ka tisa‑ni lo náni. ");
INSERT INTO zae_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ttu lidú do Jesús‑ni ata rilhapie tisa len Tata Do Yebáha. Tti chi uluxanie unnebie len benneha, nianna tti ra ttu ka benne rudhetinieha bie: ―Tata, bele'enttu ri'itu kini aka getu innetu len Tata Do Yebáha ttiba ben Juan‑ni bele'enie ka benne bedhetinieha. ");
INSERT INTO zae_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús‑ni nna ree ke: ―Tti innele len Tata Do Yebáha, aní innále: Tata, ri'itu rugwetu lidhakalu kumu ankalu Diosi. Utá, unnabia ri'itu. ");
INSERT INTO zae_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bete benne gotu ttu ttu sá. ");
INSERT INTO zae_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Uxí elha xen lasi ge ka tulha ruintu ttiba ri'itu gwa ridíbatu elha xen lasi ge ka nu abittu ruin tsekana len ri'itu. Bittu ugwelhalu ixú yietu uintu nu satsa. ");
INSERT INTO zae_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nianna rágabe kana: ―Uindiri'i, ganna ttixka nuxa ttúle do ttu benne do tse lenle, nianna diale lisi benneha itú riluela ralee: “Betsi to, ulea ganna tsunna yettaxtila gelu‑na kia ");
INSERT INTO zae_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kumu si bisia tte ttu benne ankabientu dabie gwelanni ri'itu, ttaka labí teeti bixa usigaa loe.” ");
INSERT INTO zae_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Laaba ganna benne tee lhi'uha, lhi'uliba tebie nna ekabie innee: “Bittu utsetsinlu neti. Chiba yaya yo'o kia‑ni. Gwea nna chiba tee lania ka xi'inia‑ni. Labí aka chadhaa ki utea nu rinnabalu‑na.” ");
INSERT INTO zae_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Neti ria, labí de do tse lenlu benneha nna chadhe utebie nu rinnabaluha; deruba nna ki abitturu utsetsinlu benneha, de nuha‑ruba nna gwayadhe nna utebie iyá nu rinnabaluha. ");
INSERT INTO zae_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Laxkala neti ria le: gwalinnaba len Tata Do Yebáha, benneha nna gutebe nu rinnabaleha; gwalegila nna gwataxxakabale nu regilaleha. Gwalinne ro'o yo'oha nna gwadhalibakana kini ga'ale. ");
INSERT INTO zae_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kumu nuxaba benne ganna rinnabe ttu bixa nna gwa ridíbe nu rinnabeha lhe nuxaba benne ganna regilee ttu bixa nna gwa raxxakabe nu regileeha. Anágaba nna nuxaba benne ganna rinnebie ro'o yo'oha nna gwa ridhalibakana ra'abie. ");
INSERT INTO zae_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Ganna nuxa ttúle ankale xxudi, ¿si gugwele xi'inleha gona ttu belha ra'aya lhe'eni lo yu ganna ttixka innabana gona belha? ");
INSERT INTO zae_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O si ganna ttixka innabana gona sitta, laa gugwegale nuha ttu ro'o chupa ki gona? ");
INSERT INTO zae_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ki lebi'i ankalale nu runi satsa nna gwa rugwebale ka xi'inle‑na nu tse rinnabakana, ¿titiala Tata geri'i do yebáha, guteba benneha Espíritu geeha len ka benne ganna innabake lenbie? ");
INSERT INTO zae_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús‑ni daabie rebeabie ttu espíritu xxegwi yu'u lati ttu nubiyú. Nu xxegwiha benna kini beya'an nubiyúha biría. Tti chi beriana lati nubiyúha nna benné ttebana. Ka benne se'e niha nna bebanabakanie tti bilákanie nuha. ");
INSERT INTO zae_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ttaka attu chupakana nna rálakana: ―Beelzebú nu anka xxana ka espíritu xxegwiha‑ba rixuin nuní kini rebeana ka espíritu xxegwi‑na. ");
INSERT INTO zae_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Adíkana nna de ruinkana ki ku'ukane prueba kini ula'a ganna gwalí udhelha Tata Do Yebáha bie, de nuha nna unnabakana lenie unie ttu milagru. ");
INSERT INTO zae_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ttaka labie nna yuu gale nu rulaba lekaniha. Nianna tti ree kana: ―Ganna lhe'e ttu yiesi se'e la'a ka benne de ritilha len luesike, la'ania nna tse'e looba yiesiha lhe ganna ka benne se'e lhe'e ttu yo'o se'e la'ake de ritilha len luesike, la'ania nna tse'e loogabake. ");
INSERT INTO zae_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Anágaba nu xxegwiha, ganna do ttilhabana len ka luesi xxegwi‑niha, la'ania nna labí aka geni innabiana ka nuha. Aní ria kumu lebi'i rale neti deki Beelzebú nu anka xxana ka espíritu xxegwiha‑ba rixúti kini rebeaya adí ka espíritu xxegwi‑na. ");
INSERT INTO zae_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ganna lebi'i rale deki neti rixúti Beelzebú‑ni ki rebeaya ka espíritu xxegwi yu'u lati ka benne, ganna rale aná nna ka benne gele‑na nna, ¿si nu xxegwiha‑gaba rixúkinna kini rebeakana ka espíritu xxegwi yu'u lati ka benne? Ko'o, labí. Gwalinnaba tisarugakana. Ka nuná innákana ganna si gwalí nu rale‑na. ");
INSERT INTO zae_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Neti, Tata Do Yebáha‑ba runie kini rebeaya ka espíritu xxegwi yu'u lati ka benne. Nu runia‑ni runna liina deki chiba bisia Tata Do Yebáha len lebi'i kini innabie. ");
INSERT INTO zae_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Ttixka ttu nubiyú ankana tipa nna duna denna espada geniha kini anuttu nu tatta'ana lhe'e yo'o geniha, la'ania nna iyába nu tua tsenna lhe'e yo'oha, lanú nu ga'a dhina nuha. ");
INSERT INTO zae_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ttaka ganna isina attu nu ankaruna tipa nna dhaana loni, nianna tti kuana lo náni espada nu dika odilána naha, nianna tti kuana iyá nu tee geniha nna kidhina nuha len ka benne. ");
INSERT INTO zae_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Laxkala nu abittu du lenna netiha, nuha rigu'uba ni'ani neti nna nu abittu rute náni len neti ki ottupatu ka benne lo neda ge Tata Do Yebáha, nuha urio lálana ka benneha. ");
INSERT INTO zae_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Ttixka ttu espíritu satsa reriana lati ttu benne nna rekibana lo yu bisiha regilana ata eyaka leni, ttaka tti abíba raxxakanaha, nianna rana: “Eyekichilaa eya'aya lisia ata biriayaha.” ");
INSERT INTO zae_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tti eyekina esinnaha nna la'ania nna saxxakana benne beriana latieha chi doe anke ttiba ttu yo'o chi luba ra lhe'eni lhe chi yapa te xea lhe'eni lhe. ");
INSERT INTO zae_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nianna tti tsiana taxxína a gasi ka espíritu xxegwi, ka nu adírula satsa ruinkana tti lana. Nianna ga'akana tsu'ukana lati benneha. La'ania nna adírula satsa uni benneha attichula tti benie sisi'a tteha. ");
INSERT INTO zae_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Laka du Jesús‑ni ree aníha, nianna tti unne ttu benne nuila due lagwi ge ka benne tupa niha. Unnebie idisa, ree: ―¡Karubáru benne nuila bije lu lhe begasie lu lhe! ");
INSERT INTO zae_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ttaka lee nna bekabilee, ree: ―¡Karubárula ka benne ata gwa rudo nagake nu ra Tata Do Yebáha nna gwa rudoke tisa gebie lhe! ");
INSERT INTO zae_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tti chi rituparu ixe juisiru ka benne, nianna tti ra Jesús‑ni ke: ―Ka benne se'e nnanna satsaba ruinke de rinnabake unia ttu milagru xxeni kini unna liina deki Tata Do Yebáha udhelhe neti, ttaka labíru ula'ania ke bixa attu milagru, sunruba luesi nu gwate Jonás‑ni, sunruba luesi nuha gwalákanie. ");
INSERT INTO zae_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kumu nu gwate Jonás‑ni bixúna kini ugía le ka benne se'e Nínive‑ni geni. Anágaba neti benne daya yebáha nu sateaha ixúna kini tsia le ka benne se'e nnanna kia. ");
INSERT INTO zae_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nuila unnabiana ka yiesi se'e daka Sabá, ganna chi isia sá uin Tata Do Yebáha elhuxtisi ge ka benne se'e yiesi lo yu‑ni, la'ania nna eyadhana lo elhuttiha nna ukinnina ka benne se'e nnanna. Kumu lana idittuli dana nna betedo nagani ge elha rieni upa Salomón‑ni. Nnanna nna nii du ttu benne xxenirula ra lebie tti Salomón‑ni. ");
INSERT INTO zae_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Anágaba ka benne use'e lhe'esi Nínive‑ni, ganna chi isia sá uin Tata Do Yebáha elhuxtisi ge ka benne se'e yiesi lo yu‑ni, la'ania nna eyadhagaba ka benneha lo elhuttiha nna ukinnike ka benne se'e nnanna. Kumu ka benneha gwa bodúbana ke ge nu benke nna bodaxxuke neda ge Tata Do Yebáha tti biyienkanie ka tisa utixxi'a Jonás‑ni. Nnanna nna nii du ttu benne xxenirula ra lebie tti Jonás‑ni nna a ria lele gebie. ");
INSERT INTO zae_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Lanú ttu benne do rugalhe iki ttu gi nu rudani, delo nna ukatsie ikini; nigaba ruttudhie ttu almoti ikini. ¿Laaba ganna teeki udoe nuha gwetsá kini iláni ka benne ga'a lhe'e yo'oha? ");
INSERT INTO zae_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ka iyya lolu‑na ankakana ttiba ttu xiani ge latilu. Ganna ka iyya lolu‑na ankakana tse, delába ganna tseba rilákinna, la'ania nna itúba latilu tsu'u xiani; ttaka ganna ka iyya lolu‑na abíba rilá tsekinna, la'ania nna itúbalu aka chulha. ");
INSERT INTO zae_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","De nuha nna biyú gelu ni kina chulhaba anka xiani yu'u latilu. ");
INSERT INTO zae_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kumu ganna itúba latilu yu'u xiani, ganna abittuba chulha anka, la'anialigaba nna itúbalu aka yien chará ule'ebalu ttiba rula'a ttu nu yu'u xiani latini. ");
INSERT INTO zae_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tti chi uluxani Jesús‑ni unnebie, nianna tti uxi ttu fariseo‑nie lhe'e lisiniha kini goe yetta lenna. Tti ute'e lhe'e yo'oha, nianna udoe ro'o mexaha. ");
INSERT INTO zae_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tti bilani fariseo‑ni deki labí utí ná Jesús‑ni ki goe yetta, nianna uka tébinna. ");
INSERT INTO zae_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ttaka Jesús‑ni nna ree na: ―Lebi'i ka fariseo, rochari tte xeaba latile, ruinbale ttiba nu rocharina kwe'e xigaha lhe kwe'e ye'enaha lhe, ttaka lhi'u lhe'e lastole nna saa tíba nu satsa ruinle lhe nu riguale ge ttu benne lhe. ");
INSERT INTO zae_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Aalexa nu yieti, a rieninle! ¿Si bi gwa yule deki benne benie latiri'iha, lagabe nuha benie lhi'u lhe'e lastori'i? ");
INSERT INTO zae_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Lebi'i nu uinlale, itú iki itú lele gwalute nu tee gele len ka benne abittu geke tee kini aníha nna itú ttele eyarile. ");
INSERT INTO zae_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Gwalíchi lele xa fariseo! Lebi'i do tsitsiba lele rutele len Tata Do Yebáha tsii por ciento ge ka gwadhi bela lhe ge ka ruda lhe ge adíru ka kuana ya'a rexú gele. Ttaka nna rixxulhabinle uinle nu dika ixú lhe rixxulhabinle akinle ge Tata Do Yebáha lhe. Nuníla rakaru doelha uinle nna abittugaba udhanle utele nu chi ruteleha. ");
INSERT INTO zae_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Gwalíchi lele xa fariseo! Lebi'i ru'u lele kwiale lo ka xxila tseru se'e lhe'e ka yo'o ata rudhetile ka tisa ge Tata Do Yebáha, lhe anágaba raka lele latsiru inne ka benne gake le padiuxi atti reti'ake le lo ka neda‑na. ");
INSERT INTO zae_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Gwalíchi lele, lebi'i ka nu rule'enle ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe lebi'i ka fariseo lhe! Lebi'i ankale attiba ttu baa abittu rilána tena, laxkala meskiba rite ka benne ruleake loni nna labí yuke bixa yu'u lhi'u yu. ");
INSERT INTO zae_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nianna tti bekabi ttu ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni, rane: ―Maestru, tti ralu aná iyágaba getu nuná rinnelu. ");
INSERT INTO zae_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Labie nna rabie kana: ―¡Anágaba lebi'i ka nu rule'enle ka benne nu ra lo bia bennabi‑na, gwalíchi lele! Kumu lebi'i ttiba ttu yua idi'i nuná rudelhale kwe'e ka benne tti ruinle doelha deki udoke tisa ge ttu nu labí dhaake udoke tisa geni, ttaka lebi'i nna niba ttu latti a raka lele udole tisa ge nu rule'ele‑na. ");
INSERT INTO zae_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Gwalíchi lele! Lebi'i rusiale ka yo'o tse iki ka baa ge ka profeta betti ka benneola geleha. ");
INSERT INTO zae_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Len nuná runna liile deki gwa ru'uba lele nu ben ka benneola geleha, kumu lakana bettikana ka profetaha nna lebi'i nna rusiale ka yo'o to iki ka baa ge ka benneha. ");
INSERT INTO zae_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Laxkala Tata Do Yebáha, kumu de anke benne yuu, de nuha nna ree: “Neti idhelhaa ka profeta lhe ka apóstol lhe kini tsiake kixxi'akanie ka benne ka tisa kia, ttaka ttu chupake uttikana ke nna attu chupake nna dhu nookana ke.” ");
INSERT INTO zae_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","De nuha nna kwe'e ka benne se'e nnannaba udelhe reni ge iyá ka profeta bettikana attili sisi'a tte ure yiesi lo yu‑niha. ");
INSERT INTO zae_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Dhulona len Abel‑ni nna axtaba Zacarías benne bettikana ata daa bekú lali'a ro'o yotu ge Tata Do Yebáha. De nuha nna neti ria, kwe'e ka benne se'e nnannaba udelha Tata Do Yebáha reni ge ka benneha. ");
INSERT INTO zae_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Gwalíchi lele xa benne rule'enle ka benne nu ra lo bia bennabiha! Lebi'i chi ben gele elha rieni rute Tata Do Yebáha; ttaka nigaba lebi'i a rite denle lhe nigaba a rugwelhale tte dani adíru ka benne raka leke tte dákanie. ");
INSERT INTO zae_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tti ra Jesús‑ni aníha, ka nu rule'ekinna ka benne nu ra lo bia bennabiha lhe ka fariseo‑ni lhe yalhá bisa'a xxattakinna. Nianna udulokana bettisikinne nna ixeba nu unnaba tisakane. ");
INSERT INTO zae_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Aníha ruinkana kini inittie bixa innábie kini anáchu nna tee ro'okani usiakana ikie ge ttu bixa. ");
INSERT INTO zae_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Laka du Jesús‑ni niha nna risiaru ixe juisiru ka benne nna ruleaniba luesike. Nianna tti uduloe rinnebie, lade'axa rulise ka benne rudhetinieha, rabie ke: ―Gwaluyú gele ka iyietile nu satsa ruin ka fariseo‑ni, kumu lakana rise'ekana rákana: “Aní uinle”, ttaka lakana nna nu subila ruinkana. Ruinbakana ttiba ruin kua dii ria iki yiedi raka yettaxtila. Nuha lhe'e itúba kuaha rilhidhana. Aníha‑gaba nuná ruin ka fariseo‑ni; iyába ka benne runnittikana. ");
INSERT INTO zae_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kumu labí ttu bixa tee gatsi, abí eselana; nigaba ttu bixa raka sigá nna abí una ka benne geni. ");
INSERT INTO zae_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Laxkala iyába nu unnele gatsiha, unaba ka benne ge nuha lhe nu unne sigá ro'o naga luesile lhe'e yo'oha, nu unneleha, iriagaba ka nu innekana nuha idisa kini iyienkin benne. ");
INSERT INTO zae_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Neti rulisaa le xa betsi to kia. Bittu gasinle ge ka nu uttikana le yiesi lo yu‑ni. Kumu lakana sun bela latibale dhaakana uttikana, iki de nuha nna labíru dhaa ka nuná bixa udhakakana le. ");
INSERT INTO zae_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Neti kixxi'ania le nú ge gasinle: Gwaligasilinle ge benne kuabie elha nabani gele yiesi lo yu‑ni, iki de nuha nna gwaka gebie udelhe le lo gi ata uyú ka benne elha disa ttu dia lii, ge benneha nuní gasinle. ");
INSERT INTO zae_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Ttibanka ka binni to‑na, ¿laaba ganna ukare'aba len chupa ka belhiu to chi rito'o gayukaba? Ttaka meskiba abí tte daka ka binni toha, labí rixulhin Tata Do Yebáha gekaba. ");
INSERT INTO zae_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Anágaba lebi'i, axtaba ka itsa ikile‑na babani benneha. Laxkala bittu gasinle kumu lebi'i dakarulale attichula ixe ka binni to. ");
INSERT INTO zae_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Neti ria: Nuxaba benne ganna dhi ro'e arlo ka benne deki ria lebie neti, anágaba neti benne daya yebáha, gwadígaba ro'a arlo ka anjeli ge Tata Do Yebáha deki gwalíba ria lebie neti. ");
INSERT INTO zae_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ttaka nuxaba benne ganna abíba dhi ro'e arlo ka benne deki ria lebie neti, anágaba neti arlo ka anjeliha abittugaba dhi ro'a deki ria lebie neti. ");
INSERT INTO zae_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Neti benne daya yebáha, nuxaba benne kue bala'ana kia, gwadíba Tata Do Yebáha elha xen lasi ge benneha, ttaka nu inne satsana ge Espíritu ge Tata Do Yebáha, nuha labí dhie elha xen lasi geni. ");
INSERT INTO zae_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Ttixka ichekana le lhe'e ka yo'o ata rudhetiri'i ka tisa ge Tata Do Yebáha, o tatso dúkana le arlo ka xueda lhe arlo ka uxtisi lhe, bittu uchacha ikile gasina ekabile gekani lhe o bí innále lhe. ");
INSERT INTO zae_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kumu ganna chi galhale inneleha, la'ania nna Espíritu ge Tata Do Yebáha gutebe tisa len lebi'i kini ekabile gekani. ");
INSERT INTO zae_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ttu ka benne sela lhe'e ka benne tupa niha, unnebie rabie Jesús‑ni: ―Maestru, usi betsiaha utena nu ralhaa dhia ge nu bodha'an tata getuha ri'itu. ");
INSERT INTO zae_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ttaka Jesús‑ni nna bekabie geni, ree: ―Xa nubiyú, lanú nu chi bedúna neti kini akaa xueda o ki akaa nu kidhia gele. ");
INSERT INTO zae_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Rágabe ka benne se'e niha: ―Gwaluyú gele. Bittu udona lele gatta belhiu gele, kumu laa de gatta xxattaga gele nna aka benle. ");
INSERT INTO zae_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nianna utixxi'anie kana ttu tisa. Aníha benie kini utte dákana bixa diani nu raka lebie kixxi'anie kanaha, nianna tti ree: ―Udo ttu nubiyú utta geni. Bexú xxatta lena lo yu geniha. ");
INSERT INTO zae_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nianna belaba lhi'u leni, rana: “¿Galasina unia ganna? Labí doti gaxa oga'aya iyá lena kia‑ni.” ");
INSERT INTO zae_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nianna tti rana: “¡Aan, chi yua gasina unia! Otampaa ka ata rigua tsea ka lena kia‑ni nna odixenrua kana, kini odisáya lhe'ekani iyá lena kia rexú lhe iyá nu tee kia lhe. ");
INSERT INTO zae_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nianna tti upeya la netiba: Betsi to, ixeniba nu tua tsenlu. Ixe ida uchía nuná. Nnanna nna udoba beyaka lelu lhe uto u'uya lhe bedí baa lhe.” ");
INSERT INTO zae_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ttaka Tata Do Yebáha nna ree na: “¡Aaluxa nu akaa elha rieni ikini! Loolha‑ni tteba gattilu nna nu tua tsenlu‑na nna, ¿núla ge nuná?” ");
INSERT INTO zae_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Aníha‑ba sate ka nu ruttupa xxattakana elha tse gekani yiesi lo yu‑ni, ttaka arlo Tata Do Yebáha labí gatta ge ka nuná. ");
INSERT INTO zae_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nianna tti ra Jesús‑ni ka benne rudhetinieha: ―De nuha nna neti ria le: Bittu uchacha ikile bixa gole kini aka benle lhe nigaba uchacha ikile ge nu ukule lhe, ");
INSERT INTO zae_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","kumu rakarula doelha aka benri'i attichula nu gori'i lhe anágaba dakarula bela latiri'i attichula nu ukuri'i. ");
INSERT INTO zae_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gwalulanniruga ge ka beki‑na. Ka nuná labí rigu'ukana yiela, nigaba relapakana, nigaba labí tee ata rigua tsekana lena gekani. Laa kiga de nuha nna Tata Do Yebáha gwa rugobe kana. ¿Laaba ganna lebi'i dakarulale tti ka nu sia xxilakinna? ");
INSERT INTO zae_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Anágaba nna meskiba bika ruchacha xxatta ikile, laa de nuha‑ga nna itiaruinle attu satti. ");
INSERT INTO zae_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ki ganna ttu bixa nuxka'a to a ridaale uinle, ¿beakala ki ruchacha ikile ge adíru nu subi? ");
INSERT INTO zae_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Gwalulanniruga, gasina riyelha ka iyya to daa ka lhe'exxi‑na. Ka nuná labí riben ka nuná sina, nigaba a ribeakana tuilu. Neti ria le: Salomón nu unnabiaha, meskiba ukana nu ra xxeni leni, labí bikuna lari rula'a latsitoru tti rula'a ka iyya to‑na. ");
INSERT INTO zae_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ki Tata Do Yebáha aná rugukue ka ixxi to daa lhe'exxi‑na, ka nuná nasá ankakana ya'a nna uxxe gwisá nna chiba tsiakana itekana lo gi, anágaba lebi'i ka nu a ria tsitsi lele, ¿laaba ganna adírula tse ugukue le? ");
INSERT INTO zae_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Laxkala lebi'i bittu uchacha ikile ge bixa gole lhe bixa i'iyale lhe. Bittu udúna le ge nuná. ");
INSERT INTO zae_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kumu ge iyá nuní ruchacha iki ka benne se'e yiesi lo yu‑ni; ttaka lebi'i Tata gele do yebáha chiba yubie bí riyasinle. ");
INSERT INTO zae_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lebi'i nu uinlale gwaluinla doelha kini akale nu innabia Tata Do Yebáha, la'ania nna gutebe adí nu riyasinle. ");
INSERT INTO zae_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Lebi'i ka benne chi ankale kia, bittu gasinle. Ttu chuparubale se'e, ttaka Tata gele do yebáha nna chi bedá lebie betebie lo neda gele kini innabie len lebi'i. ");
INSERT INTO zae_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gwalutto'o nu tee gele nna gwalugwe ka benne abittu geke tee. Aníha gwaluni kini gatta elha tse gele yebáha. Gwaluni ttiba ttu nu rigua tsena nu tee geni lhe'e ka beduti. Aníha‑ba lebi'i, gwalikua tse elha tse gele yebáha, elha tse nu abittu lhuxa loona, nigaba ga'a ubana ki lhanana na, nigaba labí tsali belha dilha ikini. ");
INSERT INTO zae_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kumu ata gatta elha tse geleha, niha‑ba udo lele. ");
INSERT INTO zae_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Gwalese'e tse nna gwaledhí tsitsi lhe'ele lhe anágaba gwalugalha iki ka gi gele gwalidheni. ");
INSERT INTO zae_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Gwaluni ttiba runi ka nubiyú riben sina se'ekana ubeda xxanakaniha tti esia nuha ugíana dha'a, kini sun tteba ganna chi besia nuha ukampana ro'o yo'oha nna chi se'e tsekana kini idhalikana eta'a nuha. ");
INSERT INTO zae_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Karubáru ka benne ren lo xxanakeha ganna tti chi esianaha nna etexxakana ke se'eke ubeda na. Netiru ria: La kwinaba lana ose'ena ke ro'o mexaha nna tti dhu liina ka'ana elho goke. ");
INSERT INTO zae_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Karubáru ka benneha ganna etexxakana ke se'eke ubeda na, meskiba esiana itú riluela o chi daa tsani. ");
INSERT INTO zae_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ttaka lebi'i gwalúnaruga, ganna ttixka xxana ttu yo'o chi yuna bí ura etechadi ubanaha yo'o geniha, la'ania nna dho tennálana kini abittu ugwelhana nuha lhanana nu tee lhe'e yo'o geniha. ");
INSERT INTO zae_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Anágaba lebi'i, gwaltse'e ubeda, kumu neti benne daya yebáha, esiaya attila abittu ribedale neti. ");
INSERT INTO zae_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro‑ni nna unnaba tisane, rana: ―Tisa unnelu‑ni xa tata, ¿si suna ri'ibatu betenlu nuní aka, iyába ka benne ak? ");
INSERT INTO zae_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesús‑ni nna ree na: ―¿Laaba ganna nu rudo tsitsina tisa ge xxananiha lhe ruinna attiba ankaba geni, laaba ganna lana nuha bodha'an xxananiha na ki uyúna adí ka nu riben sina lhe'e lisi nuha lhe kini ugona ka nuha ura geni lhe? ");
INSERT INTO zae_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Karubáru benne ren sinaha ganna chi besia xxaneha nna etexxakane gwa ruinbe sina nu daa loe unie. ");
INSERT INTO zae_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Neti gwalígati, xxaneha odha'anbana lasi nábie kini uyúe iyá nu se'e geniha. ");
INSERT INTO zae_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ttaka ganna nubiyú riben sinaha ulaba lhi'u leni akinna: “Risába xxana sina‑ni, nu nuha resia.” Nianna tti dhulo ttebana gayana adíru ka nubiyú lhe ka nuila yu'u sinaha lhe, nianna tti dhona gona lhe i'iyana lhe dhusinna lhe. ");
INSERT INTO zae_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ttaka la sá attila abittu ribedanaha lhe ura attila abittu rakinna deki esia xxananiha, la'aniala nna iyyaba leni esia nuha. Nianna tti ugwe xxananiha na ttu elha disa tsitsi. La'ania nna tti kweana na nna udelhana na ata se'e adíru ka nu abittu rudokana tisa. ");
INSERT INTO zae_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Ganna ttixka nu riben sinaha gwa yúbana nu raka le xxananiha, ttaka ganna abíba rudona tisa ge nu rana na, nigaba a rudhá leni, la'ania nna yalhá igulha nuha. ");
INSERT INTO zae_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ttaka ganna nu ren sinaha abíba yuna nu raka le xxananiha, nna ganna nu subila uinna nu dika kilana elha disa geni, ttaka kumu de abittu yuna nu raka le xxananiha, de nuha nna labí tte igulhana. Kumu ttixka ttu benne ridírue ixeni, ixenirugaba dho doelha benneha otebie. Anágaba ganna ttixka ttu benne ruxxen xxatta lekani gebie deki gwaka gebie unie ttu bixa, ixenirugaba nu innabakana uin benneha. ");
INSERT INTO zae_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Neti daya gwedo gi yiesi lo yu‑ni. Aní rakati chi itena. ");
INSERT INTO zae_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Neti teeki satea uyúa ttu elha disa tsitsi. Laxkala itúba tee‑ni rudúna neti axtaliba ganna chi isia sá satea nuha, la'anialiba nna abitturu udúna neti. ");
INSERT INTO zae_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Lebi'i, ¿si rakinle deki daya kini tse'e tse len luesi ka benne se'e yiesi lo yu‑ni? Neti ria le, labí. Neti dalaa kini delo ni'a kia nna lha'a lhe'e luesi ka benne. ");
INSERT INTO zae_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kumu debá nnanna lhe nu si daa lhe, delo ni'a kia nna gayu ka benne yu'u lhe'e ttu yo'o tse'e ttilha len luesike, tsunnake ebi'i nooke a chupa ka benneha nna ka benne chupaha nna edebi'i nooke ka benne tsunnaha. ");
INSERT INTO zae_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Xxudiha nna abittu aka uyúna xi'in biyúniha nna xi'in biyúha nna abittu aka uyúna xxudiniha; ixná nuilaha nna abittu aka uyúna xi'iniunnániha nna xi'iniunnániha nna abittu aka uyúna ixnániha. Ixná nubiyúha nna abittu aka uyúna xolisiniha nna xolisiha nna abittu aka uyúna ixná nubiyúha. ");
INSERT INTO zae_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús‑ni nna rágabe ka benne ixe juisiru tupa niha: ―Lebi'i tti rilenle ganna chi reyadha ka bea daka ata rito ubisa‑na, nianna ra ttebale: “Aka iyya”, nna gwalíba nna rakaba iyya. ");
INSERT INTO zae_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Anágaba tti daa be ka daka rreha nna redenále: “Ubisaba aka”, nna gwalíba nna rakaba ubisa. ");
INSERT INTO zae_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Aalexa nu rigí xú loni! Gwa rite dábinle nu raka yiesi lo yu‑ni lhe nu raka gwetsá lhe; delo nna a rite denle nu raka nnanna. ");
INSERT INTO zae_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Kwinaba lebi'i gwalotte da gá tee nu dika ixú. ");
INSERT INTO zae_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kumu ttixka nu ritilha lenleha, diana taga'ana le lo uxtisi, laka yu'u lenle nuha neda diale, gwaluin doelha gwaleyoin leni kini abittu taga'ana le lo xuedaha nna xuedaha nna uttena le lo ná nu baninna lisiyyaha. Nuha nna uga'ana le lisiyya. ");
INSERT INTO zae_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Neti ria: Labí lhaale lisiyyaha chiliba utixale iyá belhiu rinnabakanaha, la'anialiba nna ebeakana le niha. ");
INSERT INTO zae_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","La'aniagaba se'e ttu chupa ka benne ata du Jesús‑ni. Ka benneha rigixxi'akanie bie deki Pilato‑ni chi udhelhana bettikana ka benne ge Galilea‑ni. Bettikana ke tti lo se'eke ruttike ka nimala uteke úna ge Tata Do Yebáha, nianna betselakana reni geke leni reni ge ka nimalaha. ");
INSERT INTO zae_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús‑ni nna bekabie ge ka benneha, ree: ―¿Si rakinle deki gwate ka benne ge Galilea‑ni aníha, kumu de ankake ka nu ruinru tulha tti adíru ka nu lhe'esi gekeha? ");
INSERT INTO zae_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Neti ria, labí. Anágaba lebi'i ganna abíba odúna le ge nu ruinle nna odaxxule neda ge Tata Do Yebáha, gattibale. ");
INSERT INTO zae_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Anágaba ka benne sixunu (18) uttike tti ubixxi yo'o yadha xxattaha ikike, yo'o nu tee láni Siloé, ¿si rakinle tulha xxeniru ben ka benneha tti adíru ka benne se'e lhe'esi Jerusalén‑ni? ");
INSERT INTO zae_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Neti ria, labí. Anágaba lebi'i ganna abíba odúna le ge nu ruinle nna odaxxule neda ge Tata Do Yebáha, gattigabale. ");
INSERT INTO zae_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús‑ni utixxi'anie ka benne tupa niha ttu tisa. Aníha benie kini utte dáke bí diani nu raka lebie kixxi'anie ke. Nianna tti ree ke: ―Ttu nubiyú du ttu ya higu geni lhe'e yu ata yadinna ka ya uvaha. Nianna ugíana gwalannina ganna gwasia lo nuha. Ttaka ni ttú higu bi tee lo nuha. ");
INSERT INTO zae_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Aníha uka nna rana nubiyú ruyúna ka ya uvaha: “Biyúruga, chi uka tsunna ida ritaa retegiaya ganna gwasia nu xixxi lo ya higu‑ni; ttaka nna niru ttú higu a retexxakaa loni. Uchú balha nuní. ¿Beaka ki duna nna sunruba rulhenna lo yu‑ni?” ");
INSERT INTO zae_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ttaka nubiyú ruyúna yu geniha bekabina geni rana na: “Begwelhaba na dhuna attu ida xa tata. Neti gwa'ana la'abaa xanni lhe gudelhabaa bebi to lhe, ");
INSERT INTO zae_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ni kina gaa gutebana nu xixxi to. Ganna siligaba abittu utena, la'anialigaba nna ichúlu na.” ");
INSERT INTO zae_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","La sá tti reyaka le ka benne Israel‑ni, la'ania du Jesús‑ni rule'enie ka benne lhe'e ttu ka yo'o ata rudhetike ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lhe'e yo'oha re ttu nuila chiba uka sixunu (18) ida ranina de yu'u ttu espíritu xxegwi latini, axtaba bedona ruba kwe'eni. De nuha nna labíru raka elína. ");
INSERT INTO zae_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Atti bilen Jesús‑ni nuilaha, nianna tti uxie na nna ree na: ―Nuila, nnanna chiba beyakalu ge isagwe ridakalu‑na. ");
INSERT INTO zae_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nianna tti uxxua nábie kwe'eni, loora nna belí tteba nuilaha. Nianna tti udulona rana: ―¡Xxeniba ra le Tata Do Yebáha! ");
INSERT INTO zae_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ttaka nubiyú rinnabiana lhe'e yo'o ata se'ekanaha nna bise'enna kumu de beyoni Jesús‑ni nuilaha la sá reyaka lekaniha. Nianna rana ka benne se'e niha: ―Gwa ga'anaba kwenri'i xxupa ubisa sina. Lhe'e ka sá‑ni gwaltá ki eyakale, nna bittu itale ka sá atti reyaka leri'i ki eyakale. ");
INSERT INTO zae_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesús‑ni nna bekabie geni, ree: ―¡Aalexa nu rigí xú loni! Lebi'i, ¿si lagwa gwa ridhasile iki ka ku'una geleha o ka burru geleha ki tagi'ale kana inda la sá tti reyaka leri'iha? ");
INSERT INTO zae_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nuila du‑ni nna ankana benne datiana Abraham‑ni. Chiba uka sixunu (18) ida den nu xxegwiha na. ¿Laaba ganna tseba anka elána lo ná nuha, meskila anka sá reyaka leri'i? ");
INSERT INTO zae_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tti ra Jesús‑ni aníha, ka nu abittu raka uyúkaneha bettubakinna; ttaka adíru ka benne se'e niha, nna iyábake redeakabakanie de rilákanie ka elha tsagwi runieha. ");
INSERT INTO zae_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús‑ni rágabe: ―¿Gasina rule'e tti rinnabia Tata Do Yebáha ka benne? ¿Bí nuha rula'a tti rula'ana? ");
INSERT INTO zae_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tata Do Yebáha, tti rinnabie ka benne, elha rinnabia geeha ankana attiba ttu besi ge kuana muxtasa úda ttu benne biyú lo yu geeha. Tti be'eyunaha nna, bisinbana ukana ttu yaga xeni nna axtala ka binniha rusia lhixxu'inkani lo ka náni. ");
INSERT INTO zae_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nianna tti redenee attu libe: ―¿Bí nuha raxxína len nu raka tti rinnabia Tata Do Yebáha ka benne? ");
INSERT INTO zae_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Elha rinnabia geeha ankana attiba kua dii bedaxxu ttu benne nuila nna bedelhe iki tsunna ya yiedi xuxtila kini ilhidhana lhe'e itúba kuaha. ");
INSERT INTO zae_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nedaba yu'u Jesús‑ni die lhe'esi Jerusalén‑ni nna ritebie lhe'e ka yiesi elha lhe lhe'e ka yiesi xka'a to lhe rule'enie ka benne ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nianna unnaba tisa ttu benne bie, rane: ―Tata, ¿si sunruba ttu chupa ka benne gwaka odilá Tata Do Yebáha ke? Labie nna bekabie geke nna ree: ");
INSERT INTO zae_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Gwaluin doelha gwaliga'a ro'o puerta suniha, kumu neti ria le, ixe ka benne raka leke ga'ake niha, ttaka labí dhaake ga'ake. ");
INSERT INTO zae_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kumu ganna chi ugwadha xxana yo'oha odheabie nuha, la'ania nna lebi'i nna eya'anbale lali'a ge yo'oha nna innále: “Tata to, udhalichi ki ga'atu.” Ttaka benneha nna ekabie gele innábie: “¡Neti labí yua gá benne le!” ");
INSERT INTO zae_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nianna tti dhulole innále: “Ki gwa utobatu lhe gwa u'uyabatu len kwinalu lhe anágaba ki gwa bele'ebinlu ri'itu ka tisa geluha lo ka neda ge lhe'esi getuha.” ");
INSERT INTO zae_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ttaka benneha nna ekabilee gele innábie: “¿Laa chi xpeya le: Labí yua gá uka lasile? ¡Gwalibietta kwe'a, lebi'i ka nu ruin satsa!” ");
INSERT INTO zae_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","La'aniala nna dhulole kwesile lhe gorriba lo layale tti ilenle Abraham‑ni lhe Isaac‑ni lhe Jacobo‑ni lhe iyá ka profeta ge Tata Do Yebáha lhe se'eke ata rinnabieha; ttaka lebi'i nna beya'anbale ro'o yo'oha. ");
INSERT INTO zae_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kumu la'ania isia ka nu dákana daka ata riria ubisa lhe daka ata rito ubisa lhe, ka nu dákana daka liaha lhe daka rreha lhe. Isia ka nuha ata rinnabia Tata Do Yebáha, tse'ekana ro'o mexa geeha go lenkane. ");
INSERT INTO zae_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","La'ania nna ka nu ra xxeni lekani nnanna, ka nuha akakana ka nu abittu ra xxeni lekani nna ka nu abittu ra xxeni lekani nnanna, la'ania nna akakana ka nu inná xxeni lekani. ");
INSERT INTO zae_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Looraha‑gaba bisin ttu chupa ka fariseo nna rákana Jesús‑ni: ―Beria nii kini Herodes‑ni ruinbana uttina lu. ");
INSERT INTO zae_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Labie nna bekabie gekani, ree: ―Gwaleyya nna gwaligasi bedaha: “Neti suna nasába lhe suna uxxeha‑ba rebeaya ka espíritu xxegwi yu'u lati ka benne lhe reyonia ka benne rani lhe; gwisáha nna chiba iri'a lania sina runia‑ni.” ");
INSERT INTO zae_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ttaka neti teeki tsiaya neda kia nasá lhe uxxeha lhe attu sá lhe kini isinaa lhe'esi Jerusalén‑ni. Kumu ttu benne anke profeta ge Tata Do Yebáha teeki gatti benneha lhe'esi Jerusalén‑ni, labí dika gatti benneha attu ta subi. ");
INSERT INTO zae_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Eru geni xa benne ge Jerusalén! Lebi'i ruttile ka profeta ge Tata Do Yebáha lhe rusiale íyya ka benne ridhelhe ki risiake lhe'esi gele‑ni rigixxi'ake ka tisa gebie. Ixe lidú benia ottupaa le ttiba runi beraha rottupana ka xi'inniha regu'u lhe'e xxilani kana, ttaka lebi'i nna labí uka lele. ");
INSERT INTO zae_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Gwaluyúruga, a sun ttúba lhe'esi gele‑na eya'anna. Neti upeya le, labíru ilenle neti axtaliba ganna chi bisia sá tti innále: “¡Karubárulu dedálu kwenta ge Tata Xisiha!” La'anialiba nna elenle neti attu libe. ");
INSERT INTO zae_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Uka nuha tti bisia ttu sá tti reyaka le ka benne Israel‑ni, la'ania ugía Jesús‑ni go yetta lisi ttu nu loni ge ka fariseo‑ni. Adíru ka fariseo‑ni nna rulhatsibakana gebie. ");
INSERT INTO zae_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Arlogabe du ttu benne biyú yu'u latie gi. ");
INSERT INTO zae_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nianna unnaba tise ka fariseo se'e niha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni, ree kana: ―¿Si gwa dika eyaka ttu benne rani la sá reyaka leri'i ak; o abittuba ak? ");
INSERT INTO zae_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ttaka lakana nna siiba ukakana; labí bekabikana. Nianna bedaxxue benne raniha nna beyonie bie, nianna ree bie: ―Beyya lisiluha. ");
INSERT INTO zae_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ka fariseo‑ni nna rabie kana: ―Ganna ttixka ttúle iginni ttu xi'in biyúle o ttu ku'una gele lhe'e ttu yiela inda, ¿laaba ganna meskiba anka la sáha sá reyaka leri'i, lebi'i nna tsia ttebale taleale nuha lhe'e yiela indaha? ");
INSERT INTO zae_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Lakana nna labí beselakinna bixa ekabikana gebie. ");
INSERT INTO zae_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tti bilani Jesús‑ni adíru ka nu uxi fariseo‑ni lhe'e lisiniha yu'ukana rukwekana ka xxila se'e lagwiha kini tse'ekana, nianna tti utixxi'anie kana ttu tisa. Aníha benie ki utte dákana bí diani nu raka lebie kixxi'anie kana, nianna tti ree: ");
INSERT INTO zae_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ttixka nuxa gaxina lu tsialu dha'a, bittu tadholu lo ka xxila se'e lagwiha, kumu ni kina delola isia ttu nu ra xxeniru leni tti lu. ");
INSERT INTO zae_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nianna tti isia benne uxie ixpaleha nna gabie lu: “Begwe benne du nii xxila dolu‑na kini dhobie.” La'ania nna itú rettubinlu edú liilu nna tarelu lo ka xxila se'e axta lo xubanaha. ");
INSERT INTO zae_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lu nu uinlalu, ganna ttixka gaxikana lu, ugíala gwache lo ka xxila se'e lo xubanaha kini ganna chi etelisa benne uxie lu lisieha nna gabie lu: “Betsi to, gaxxala nii utá udo.” Aníha‑la nna gwebanala lelu lo iyá ka nu se'e lenlu ro'o mexaha. ");
INSERT INTO zae_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kumu ttu nu runi deki ra xxeni leni, nna elhida gaala Tata Do Yebáha nuha nna ttu benne rorexxa gaa lebie nna uinla Tata Do Yebáha ki inná xxeni lebie. ");
INSERT INTO zae_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Rágaba Jesús‑ni nu uxine lisiniha: ―Ganna ttixka lu gaxilu ka benne ugolu xueke o irseke, bittu gaxilu ka nu do tse lenlu o ka betsilu, nigaba gaxilu ka benne raka luesilu, nigaba ka nu tee gekani se'e gaxxa ata doluha. Kumu ka nuha nna eyaxibakana lu, la'ania nna niha‑ba chi okixalu nu begolu ka nuha. ");
INSERT INTO zae_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Lu, nu uinlalu, ttixka utelu ttu elho, uxila ka benne abí geke tee lhe ka benne akaa ttu lha'a ni'ake o náke lhe ka benne ridá natsa lhe anágaba ka benne xua loke lhe. ");
INSERT INTO zae_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aníha‑la nna gwa teela elha gwedeaka lasi gelu arlo Tata Do Yebáha kumu ka benneha labí aka geke egixake elho uteluha. Ttaka ganna chi bisia sá eyaka ben ka benne gwa benke nu dika ixúha, la'ania nna gwa ralhalalu edílu ge nu beteluha. ");
INSERT INTO zae_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ttu ka nu do go yetta len Jesús‑ni, tti biyieninna nu unneeha, nianna rane: ―¡Karubáru benne edí baabie elho tee ata rinnabia Tata Do Yebáha! ");
INSERT INTO zae_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús‑ni nna rabie na: ―Ttu nubiyú benna ttu elho tse nna uxina ixe ka benne. ");
INSERT INTO zae_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tti chi bisia ura go irsekaniha, nianna udhelhana nubiyú riben sina geniha ki tsiana talisana ka nu chi biyaxiha, gana kana: “Gwaltá. Chiba tee elho.” ");
INSERT INTO zae_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ttaka nna iyábakana udulokana bedúkana tisa. Ttúna rana: “Si uxíbaa ttu lo yu kia nna nuha‑la raka doelha tsiaya gwelanni. Usittue dhichie elha xen lasi kia.” ");
INSERT INTO zae_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Attuna nna rana: “Si uxíbaa gayu neda ka ku'una kia nna si uttánalaa ka nuha. Usittue dhichie elha xen lasi kia.” ");
INSERT INTO zae_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Attuna nna redenána: “Si betsába náya, de nuha nna labí aka dhaya.” ");
INSERT INTO zae_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nianna tti beyeki nu ren sinaha nna utixxi'enna xxananiha iyá nu ra ka nuha. Xxananiha nna yalhá bise'enna, nianna tti rana nubiyú ren sina geniha: “Begwe lelu ugía lo ka neda xeni‑na lhe lo ka neda xka'a se'e lhe'e yiesi‑ni. Gwaxxí ka benne abittu tee geke lhe ka benne reku ni'a náke lhe anágaba ka benne xua loke lhe ka benne ridá natsa lhe. Usi ke itake.” ");
INSERT INTO zae_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Laa bikaga isá chi uka nna chi bedesia nubiyúha nna rana xxananiha: “Chiba benia nu ráluha xa tata, ttaka nna riyasaru ki isá benne lhe'e yo'o gelu‑ni.” ");
INSERT INTO zae_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nianna redea xxananiha na: “Ugía itú ro'esi‑na lhe ugía ata riria ka neda dia ka lhe'exxiha nna bedo doelha ka benne itake kini isá lhe'e yo'o kia‑ni. ");
INSERT INTO zae_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kumu neti ria, ni ttú ka nu uxia sisi'a tteha a unnixxikana elho kia‑ni.” ");
INSERT INTO zae_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ixeba ka benne danalhake Jesús‑ni, nianna bodeki loe, ree ke: ");
INSERT INTO zae_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Ttu benne ganna raka lebie etenalhe neti teeki akarunie kia attichula ge tata geeha lhe ge nan geeha lhe. Anágaba akarulanie kia attichula ge nuila geeha lhe ge ka xi'inieha lhe ge ka betsieha lhe ge ka daneha lhe. Anágaba nna akarunie kia attichula gebie, kumu ganna abíba nna labí dika aka benneha benne udhetinia. ");
INSERT INTO zae_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Anágaba benne ganna abíba uje kurusi gee etenalhe neti, delába ganna abíba eria iki eria lebie meskila bixa udhakakane de etenalhe neti, benneha labí dika ake benne udhetinia. ");
INSERT INTO zae_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","’Ganna ttixka nuxa ttúle raka lele udole ttu yo'o barto, ¿laaba ganna lade'axa teeki tse'ele udhaka lele ttixa utse'e loole ge nuha, kini aníha‑chu nna aka xen lele ganna gwadaa belhiu geleha ulhuxale yo'oha? ");
INSERT INTO zae_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kumu ni kina dhulobale ukuale íyya xan nuha, delo nna abí dhaale ulhuxale na. La'ania nna iyába ka nu ilákinna nuha dhulokana uxisikana gele, ");
INSERT INTO zae_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","innákana: “Benne do nii uduloe rudoe yo'o ttinka, ttaka nna abígaba udaabie ulhuxe na.” ");
INSERT INTO zae_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","’Anágaba nna ganna ttixka ttu nu rinnabia ge ttu yiesi tsiana ttilhana len attu nu rinnabia ge attu yiesi, ¿laaba ganna lade'axa dhona udhaka leni ganna gwadaa tsii mili ka benne chenaha itilhake len galhia (20) mili ka nu che nu ritilha lennaha? ");
INSERT INTO zae_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ganna udhaka leni deki abíba dhaana lo nuha, la'ania nna attili sa du nuha idittu len ka benne geniha nna idhelhana ka nu tsiakana tannabakana len nuha kini ese'e tsekana. ");
INSERT INTO zae_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Anágaba lebi'i, ganna nuxa ttúle abittu udhá ikile iyá nu tee gele, la'ania nna labí dika akale benne udhetinia. ");
INSERT INTO zae_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Detiha tseba anka nuha, ttaka ganna unnitti ixe geni, la'ania nna labíru go nuha ixe. ");
INSERT INTO zae_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nigaba a ixúruna tsiana lo yu lhe nigaba a ixúruna tsiana lhe'e ttu ti'a bebi, a sunruba ixúna iru'unana. ’¡Ata sia nagale, gwaludo nagale ganna gwankale nu dika iyienini! ");
INSERT INTO zae_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Iyába ka gwekixa lhe ka nu daa tisa gekani deki ruin satsakana, iyábakana ribigakana ata du Jesús‑ni ki udo nagakani gebie. ");
INSERT INTO zae_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ka fariseo‑ni lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni rinnekana ge Jesús‑ni, rákana: ―Nubiyú du nii anála ruinna, rulabibana ka nu runi tulha‑na lhe rogaba lenna ka nuná yetta lhe. ");
INSERT INTO zae_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nianna utixxi'ani Jesús‑ni kana ttu tisa. Aníha benie ki utte dákana bí diani nu raka lee kixxi'anie kanaha. Nianna tti ree: ");
INSERT INTO zae_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Ganna ttixka nuxa ttúle se'e ttu gayua (100) ka neru gele nna udelhale ttu nuha, ¿laaba ganna use'e bixxibale a tta bixxi chennia (99) ka nuha lhe'exxiha, nianna tsekile egilale neru bigannaha, axtaliba ki taxxakale na? ");
INSERT INTO zae_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ganna chi beselinle nuha, la'ania nna edeaka tenle odelha xa yienle na. ");
INSERT INTO zae_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ganna chi besinle lisileha nna ottupa ttebale ka benne se'e tse lenle lhe ka benne se'e gaxxa ata se'eleha lhe, nianna gale ke: “Gwaledeaka tenle len neti, kumu chiba gwaxxakaa neru bigannatiha.” ");
INSERT INTO zae_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nianna ra Jesús‑ni: ―Neti ria le: Gattarula elha gwedeaka lasi yebáha ganna ttixka ttu benne runi tulha odúne nna odaxxue neda ge Tata Do Yebáha, gattarula elha gwedeaka lasi ge benneha attichula ge tta bixxi chennia (99) ka benne ruinke latsiru nna labí riyasa odúna ke nna odaxxuke neda ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nianna redenágabe: ―Uindiri'i ganna ttu benne nuila tee tsii ka belhiu dinni gebie, nianna udelhe ttu ka nuha, ¿laaba ganna teeki ugalhe iki ttu gi lhe olhuba te xeabie lhe'e yo'oha kini egile nuha, axtaliba ki eselanie na? ");
INSERT INTO zae_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ganna chi beselanie belhuha, la'ania nna tti talise adíru ka luesi nuilee lhe ka benne se'e gaxxa ata doeha lhe, nianna gabie ka benneha: “Gwaledeaka tenle len neti kumu chiba beselati belhiu bedelhaaha.” ");
INSERT INTO zae_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nianna ra Jesús‑ni: ―Neti ria le: Aníha‑gaba gatta elha gwedeaka lasi ge ka anjeli ge Tata Do Yebáha ganna ttu benne ruin tulha odúne nna odaxxue neda ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús‑ni nna rágabe: ―Ttu benne biyú use'e chupa ka xi'in biyúe. ");
INSERT INTO zae_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nu gwexxaha rana tata gekaniha: “Tata, ulha'a lhe'e iyá nu tee gelu‑na nna bete nu ralhaa dhia.” Nianna ulha'abie lhe'e nu tee geeha nna begwebie kana. ");
INSERT INTO zae_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Bi bisá nuha nna chi bettupa nu gwexxaha nu ulhanaha nna biriana diana lhe'e attu yiesi dittu. Niha‑ba gwatse'e loona belhiu ge nu chi uxínaha; benbana attiba rakaba leni. ");
INSERT INTO zae_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tti chi beyá nuha betse'e loona, nianna tti bisiaru ttu ubina lhe'e yiesi ata donaha, nianna chi udulo biyasa geni. ");
INSERT INTO zae_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","La'ania nna tti ugíana gwadhona lo sina ge ttu ka nu tee geni do lhe'e yiesiha. Nuha nna udhelhana na ata yu'u ka kuchi geniha kini uyúna ka nuha. ");
INSERT INTO zae_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ttaka lana yalhá rituinna nna ridá leni gona nu ro ka kuchiha, ttaka lanú rugwena na nu gona. ");
INSERT INTO zae_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Niha‑ba dona nna tti botte dana nna rana: “Ixeba ka nu yu'u riben sina ge tata kiaha tee tamaba nu rokana. Neti nna doa nii rattia ubina. ");
INSERT INTO zae_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Eya'achilaa lisi tata kiaha nna upeye: Tatoo, neti chi betsetsia len Tata Do Yebáha lhe chi betsetsia len kwinalu lhe. ");
INSERT INTO zae_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nnanna labíru elha ralhaa gatta láya xi'inlu. Biyúba neti attiba ruyúlu ka benne yu'u sina gelu‑na.” ");
INSERT INTO zae_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aníha‑ba uka nna begu'una neda deyyana lisi tata geniha. ’Attili sa dedána idittuha nna chi bilani tata geniha na nna gwatua lebie na. Nianna biresu ttebe gwatsábie na nna utesie kwe'eni lhe utoe xxagani lhe. ");
INSERT INTO zae_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nu kwitiha nna rana: “Tata to kia, neti chi betsetsia len Tata Do Yebáha lhe chi betsetsia len kwinalu lhe. Labíru elha ralha neti gatta láya xi'inlu.” ");
INSERT INTO zae_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ttaka tata geniha nna rabie ka nu riben sina geeha: “¡Gwalugwe lele gwatalhea ttu xo tse nna gwaluguku na, lhe anágaba nna gwaliku'u ttu be'e náni lhe gwaliku'u gwaracha ni'ani lhe, ");
INSERT INTO zae_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","anágaba nna gwataxxí ttu gwirri to, ttu ka nu gwa rixenrukana nna gwalutti na kini gori'i uinri'i laní! ");
INSERT INTO zae_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kumu neti ukati chiba utti xi'inia‑ni, ttaka nnanna nna gwa besia benbana. Chiba binittina, ttaka nnanna nna chiba beselana.” Nianna tti uduloke laníha. ");
INSERT INTO zae_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Attu xi'in biyú xen ge uxtoha nna lhe'exxiha‑ba rekina. Tti beyekina deyyanaha nna tti besinna gaxxa kwe'e yo'oha nna biyieninna yu'u ka nu rulha lhe raka gweya'a lhe. ");
INSERT INTO zae_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nianna tti uxina ttu ka nu riben sina ge tata geniha nna unnaba tisana nuha, rana na: “¿Bíunna raka?” ");
INSERT INTO zae_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nubiyúha nna rana na: “Laa betsiluha nuná besia. Tata gelu‑na chi benie doelha kini utti ttu gwirri to ttu ka nu gwa rixenru, kumu betsiluha gwa besia tsebana.” ");
INSERT INTO zae_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ttaka nubiyú xeniha nna yalhá bisa'a xxattinna. Birula raka leni eta'ana yo'o. Aníha uka nna teeki biria tata geniha benie doelha loni ki beta'ana yo'o. ");
INSERT INTO zae_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ttaka lana nna rana tata geniha: “Lu gwa yu xeabalu, ixe ida chi rixúa lo sina gelu nna ni tsa labí chi bedú disaa lolu; ttaka nna lu niba ttu chiva to abittu chi betelu len neti ki unia laní len ka nu kwiti do tse lania. ");
INSERT INTO zae_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","¡Nnanna nna besia xi'inlu‑na, chi gwatse'e loona belhiu geluha len ka nuila ruin satsa nna lu nna de elha gwedeaka lasi geni nna chi bettilu ttu gwirri rixen xxatta!” ");
INSERT INTO zae_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tata geniha nna bekabie geni, ree na: “Xi'ini to kia, lu satíaba do lenlu neti nna iyába nu tee kia‑ni, gebalu nuní. ");
INSERT INTO zae_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ttaka nnanna nna raka doelha uinri'i laní lhe edeaka tenri'i kumu betsilu‑ni chiba uttina rakati, nnanna nna gwa besia benbana. Chiba binittina, ttaka nnanna nna chiba beselana.” ");
INSERT INTO zae_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús‑ni nna utixxi'agabanie ka benne rudhetinieha, ree ke: ―Udo ttu nubiyú utta xxatta geni. Nianna udogaba ttu nu uren sina geni. Nuha biyúna iyába nu tee geniha. Nianna ugía ka benne gwattixxi'akanie nu anka xxana sinaha, ráke nuha: “Nu ren lo sina geluha, kwentaba rutse'e loona nu tee geluha.” ");
INSERT INTO zae_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Xxana sinaha nna uxina nubiyúha, rana na: “¿Bíunna rákana ruinlu? Loora tte nnanna raka lasia kixxi'enlu neti ttixa rudhálu sina kia‑na, kumu neti labíru raka lasia kwenlu uyúlu nu tee kia.” ");
INSERT INTO zae_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nu ren sinaha nna belaba tteba leni, rana: “¿Bíla anka nu unia ganna? Nnanna abíruba sina kia ute nu anka xxanaa‑ni, neti nna labíru lheaka ankaa ki kwenia ka lo yu. Gwea nna rettulati tsekia innabaa belhiu.” ");
INSERT INTO zae_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nianna rana: “Chi yua bí unia kini ganna chi uchúna neti sina, la'ania nna chi tse'e ka benne gaxike neti lisike.” ");
INSERT INTO zae_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nianna tti udulona uxina ttu ttuba ka nu dákana ge xxananiha. Nu uxina sisi'a tteha nna unnaba tisana nuha, rana na: “¿Tti daalu ge uxto‑ni?” ");
INSERT INTO zae_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nuha nna bekabina, rana: “Laa daya ttu gayua (100) bega seti geni.” Nu reni sinaha nna rana na: “Ne yetsi ge nu daalu‑na tee nii nna begwe lelu nna udo bodo lo yetsi‑ni deki a suna tsieyonaba (50) daalu.” ");
INSERT INTO zae_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Delola nna bedennaba tisana attu nuha, redeana na: “Lu nna, ¿tti daalu?” Nuha nna redenána: “Laa daya ttu gayua (100) uxtali xuxtila.” Nianna redeana nuha: “Ne yetsi ge nu daalu‑na tee nii nna udo bodo lo yetsi‑ni deki a suna a tta (80) uxtaliba daalu.” ");
INSERT INTO zae_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Xxananiha nna bebanabinna ge elha si'inu ge nubiyú ren sina geniha. Kumu ka nu rudo lekani ge nu anka ge yiesi lo yu‑ni, resi'inurukana gasina uinkana tti ka benne chi ankake ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nianna ra Jesús‑ni: ―Neti rigixxi'ania le, ixuinle nu tse tee yiesi lo yu‑ni kini tse'e tse lenle ka benne kini anáchu ganna chi beyá nu tseha, la'ania nna chi se'e ka benne edíke le tti esinle lhe'e ka yo'o sia ttu dia lii yebáha. ");
INSERT INTO zae_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Kumu ttu benne ganna ttixka uyú tsitsibe nu ttu latti tee geeha, aníha‑gaba unie ganna ttixka tee ixeni gebie, tsitsigaba uyúe nuha nna nu abíba uyú tsitsina nu ttu latti tee geniha nna, aníha‑gaba uin nuha ganna ttixka tee ixeni geni, abígaba uyú tsitsina nuha. ");
INSERT INTO zae_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Laxkala ganna lebi'i abíba uyú tsitsile elha tse tee yiesi lo yu‑ni, anágaba nu gwalíga anka elha tse tee yebáha, ¿nú uxxen leni gele deki guyúle nuha? ");
INSERT INTO zae_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ganna abíba biyú tsitsile nu anka ge attu benne subi, la'ania nna, ¿gasina uxxen lekani le deki guyú tsitsile nu dika aka gele? ");
INSERT INTO zae_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Lanú ttu benne do aka gebie kwenie sina lo chupa ka xxane, kumu itisibanie ttu nuha, nna attu nuha nna akanie geni o udo tsitsibe tisa ge ttu nuha nna attu nuha nna ku'uba ni'e nu innána. Anágaba lebi'i labí aka gele kwenle lo sina ge chupa xxanale, delába labí aka ixúle ge Tata Do Yebáha lhe anágaba labí aka udogabana lele gatta xxatta belhiu gele. ");
INSERT INTO zae_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ttaka ka fariseo‑ni, kumu de raka galákinna ge belhiu, laxkala tti biyienkinna nu ra Jesús‑ni nna bexisilakana gebie. ");
INSERT INTO zae_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús‑ni nna rabie kana: ―Lebi'i lo benne rule'ele deki ankale benne ruin tse, ttaka Tata Do Yebáha gwa yube ttixa anka lhe'e lastole. Kumu ka benne se'e yiesi lo yu‑ni nu rakakanie deki dakaruna, Tata Do Yebáha ttu tsaba rigu'u ni'e nuha. ");
INSERT INTO zae_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Ka tisa dia lo bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni lhe ka tisa utixxi'a ka profeta ge Tata Do Yebáha lhe, debá tti bisia Juan‑ni gwa utixxi'aruke ka benneha. Iki de nuha nna chi uduloke rigixxi'ake gasina innabia Tata Do Yebáha ka benne. Laxkala de nuha nna iyába ka benne chi ruinke doelha ga'ake ki innabiabie ke. ");
INSERT INTO zae_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Yebáha lhe yiesi lo yu‑ni, adírula satti tse'e loo ka nuní attichula ttu tisa chika'a to dia lo bia bennabi bodha'an Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Satsaba nuha uni ttu nubiyú ganna udhá ikini nuila geniha nna edína attu nuila subi. Anágaba nna satsagaba nuha uni ttu nubiyú ganna edína ttu nuila chi bedhá ikikani. ");
INSERT INTO zae_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús‑ni rabie: ―Udo ttu nubiyú utta xxatta geni. Yalhá lhe'e udú xoni nna ttu ttu sába rugo tsena ka benne. ");
INSERT INTO zae_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Udogaba ttu benne utta lábie Lázaro; uke ttu benne dii nna ubia xxatta yiesu itúba latie. Benneha ridobie ro'o lisi nu tee xxatta geniha ");
INSERT INTO zae_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","nna raka lebie edige ka nu yuyya riginni xani'a mexa ge nuha. Anágaba nna axtaba ka bekuha risinkana rilhe'ekana lo ka yiesu geeha. ");
INSERT INTO zae_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ttu sá nna uttiba benneha nna ka anjeli ge Tata Do Yebáha nna betexíbake bie nna besine kwe'e Abraham‑ni. Nubiyú utta xxatta geniha nna uttigabana nna bigatsibana. ");
INSERT INTO zae_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tti lo ruyú nubiyú utta xxatta geniha elha disa ata se'e ka benne chi uttiha, nianna bechidha loni nna bilenna Abraham‑ni due idittu nna dúgaba Lázaro‑ni kwe'ebie. ");
INSERT INTO zae_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nianna unnena idisa, rane: “¡Tata Abraham, gwatuachi lelu neti! Udhelhachi Lázaro‑na unnucha lo xubenáni inda nna itana etedibidhana lo lhusaa kini yalhá rate xxattaa xuaya lo gi‑ni.” ");
INSERT INTO zae_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ttaka Abraham‑ni nna bekabie geni, ree na: “Xi'ini to, bodhú lelu, lu gwa bedí baabalu nu tse tti udolu yiesi lo yuha; Lázaro‑ni nna labí gwaria tsena nuní tti udona niha. Ttaka nnanna xen su lasila dona nii; lu nna elha disala ruyúlu. ");
INSERT INTO zae_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gwea nna ttu belha'a bartoba du lagwi geri'i. Laxkala ka benne se'eke daka ta se'etu‑ni ganna uinke tteke daka ta se'ele‑na, labí aka geke. Nigaba ka benne se'eke daka ta se'ele‑na, labí aka tteke daka nii.” ");
INSERT INTO zae_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nubiyú utta xxatta geniha nna rane: “Rinnabaa len kwinalu xa tata Abraham, edhelhachilu Lázaro‑na eyyana lisi tata kiaha. ");
INSERT INTO zae_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Niha se'e a gayu ka betsia. Eyyana kini sattixxi'enna kana gasina uinkana kini anágaba lakana bittu esiakana nii ata ruyú ka benne elha disa.” ");
INSERT INTO zae_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ttaka Abraham‑ni nna rabie na: “Chiba denkana ka tisa bodha'an Moisés‑ni lhe ka tisa bodha'an ka profeta ge Tata Do Yebáha lhe. Niha udo nagakani ge nu ra ka tisaha.” ");
INSERT INTO zae_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nubiyúha nna bekabina, rana: “Gwalí galenlu xa tata Abraham. Ttaka ganna ttu benne yatti eyaka banie nna ule'e lobie lenkana, godúbana ka nuha nna odaxxukana neda ge Tata Do Yebáha.” ");
INSERT INTO zae_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ttaka Abraham‑ni nna rabie na: “Ki ge Moisés‑ni lhe ge ka profetaha a ria lekani, anágaba ge ka benne chi uttiha abígaba tsia lekani geke, meskiba ganna eyaka benke sattixxi'akanie kana.” ");
INSERT INTO zae_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús‑ni nna rabie ka benne rudhetinieha: ―Teekiba ixú yie ka benne uinke ttu bixa nu satsa, ttaka ¡karusi'iru nu dhi yiena ka benneha! ");
INSERT INTO zae_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tserula ganna uxxigakana yienni ttu íyya ge mulinu nna udelhakana na lhe'e indatooha, a laa kila dhi yiena ttu ka nu abittu ra xxeni lekani se'e nii ki uinkana nu satsa. ");
INSERT INTO zae_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡De nuha nna gwaluyú gele! ’Ganna ttu betsi to geri'i utsetsinna lu, utisa na nna ganna ennabana elha xen lasi lenlu, uxí elha xen lasi geni. ");
INSERT INTO zae_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ganna gasi lidú utsetsinna lu lhe'e ttu sá nna ganna iyába gasi lidúha isiana gana lu: “Chiba bodúna neti nna uxíchi elha xen lasi kia, labíru unia aná”, la'ania nna lu uxíba elha xen lasi geni. ");
INSERT INTO zae_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ka benne rudhetini Jesús benne anke Xxanari'iha, ráke bie: ―Beni kini ri'itu tsia tsitsiru letu Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesús‑ni nna ree ke: ―Ttibanka ttu besi to ge kuana muxtasa, ttu nuxka'a toru anka nuha, aníha‑gaba nuná lebi'i, ganna ttuxka'a to tte tsia lele Tata Do Yebáha, la'ania nna gwakaba gele gale yaga du naa: “Belhupi ata yadalu‑na nna ugía beyada lagwi indatooha.” Yagaha nna gudobana tisa gele. ");
INSERT INTO zae_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Ganna ttixka nuxa ttule do ttu benne lo sina gele, ribenie lo ka yu geleha o rekie lo ka ku'una bia geleha, nna ganna chi resie rie lhe'exxiha nna, ¿si gweale benneha: “Aní bete bedoni kini golu yetta”? ");
INSERT INTO zae_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Laaba ganna gálale benneha: “Beni irsea nna bedú tse kini ka'alu goa. Axtaliba ganna chi bekoa, la'anialiba nna chi aka gelu dholu golu lhe i'iyalu lhe.” ");
INSERT INTO zae_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Anágaba nna nigaba a rugwele benneha ixkixaru de benie nu chi raleha. ");
INSERT INTO zae_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Anágaba lebi'i, ganna chi lhuxinle iyá nu chi ra Tata Do Yebáha uinle, la'ania nna innále: “Ri'itu benne abí dika ixúba ankatu, kumu benbatu nu daba lotu uintu.” ");
INSERT INTO zae_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tti yu'u Jesús‑ni neda die lhe'esi Jerusalén‑ni nna utebie ata risá debaa Samaria‑ni len Galilea‑ni. ");
INSERT INTO zae_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nianna bisine lhe'e ttu yiesi to. Lhe'e yiesi toha nna biria tsii ka benne biyú raka yiesu latike. Yiesuha tee láni lepra. Ka nubiyúha idittuliba se'eke nna ");
INSERT INTO zae_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","uresi'ake, ráke Jesús‑ni: ―¡Maestru Jesús, gwatuachi lelu ri'itu! ");
INSERT INTO zae_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tti bilani Jesús‑ni ka benneha, nianna ree ke: ―Gwaleyya nna gwatatso du arlo ka bixxudiha. Laka deyu'uke neda deyyakeha nna betúa yiesuha latike. ");
INSERT INTO zae_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ttu ka benneha nna tti chi bilánie betúa yiesuha latie, nianna beyekie ribesi'abie, ree: ―¡Xxeniba ra le Tata Do Yebáha! ");
INSERT INTO zae_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nianna bedú xibie arlo Jesús‑ni, tuttíruba bere lobie lo yu begwebie benneha ixkixaru. Benne beyekie betebie ixkixaruha, benneha anke benne ge Samaria. ");
INSERT INTO zae_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús‑ni nna rabie: ―¿Laaba tsiile nuná betúa yiesu‑na latile? ¿Nála a jaa ka nuha? ");
INSERT INTO zae_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Si sunruba benne abittu anke benne Israel‑ni gwa beyekie begwebie Tata Do Yebáha ixkixaru? ");
INSERT INTO zae_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nianna ree nubiyúha: ―Bedú lii nna beyya lisiluha. Kumu de ugía lelu kia, de nuha nna gwa beyakabalu. ");
INSERT INTO zae_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ka fariseo‑ni unnaba tisakana Jesús‑ni rákane: ―¿Nukala dhu lo Tata Do Yebáha innabie? Lee nna bekabie gekani, ree: ―Tti innabia Tata Do Yebáha labí ilenri'i tti innabieha. ");
INSERT INTO zae_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Laxkala labí aka ge ka benne innáke: “Gwaluyúruga, nii chi rinnabie”, o innáke “Niha chi rinnabie”, kumu lebi'i labí yule. Tata Do Yebáha, lagwi gebale chi do benneha rinnabie. ");
INSERT INTO zae_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nianna ree ka benne rudhetinieha: ―Neti benne daya yebáha isia sá yalhá aka lele dhoa len lebi'i kwadiba ttu sá. Ttaka labí aka. ");
INSERT INTO zae_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nianna iria ka nu gákana le: “Niiba chi do benneha”, o “Niha‑ba chi due.” Tti gákana le aníha, bittu tsiale lhe nigaba tanalhale kana lhe. ");
INSERT INTO zae_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kumu ttiba runi edha‑na rigu'u chábana xiani itúba gwetsáha tti rapina, aníha‑gaba neti benne daya yebáha ilá saaba ganna chi isia sá esiaya. ");
INSERT INTO zae_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ttaka lade'axa teeki uyú xxattaa elha disa lhe ku'u ni'a ka benne se'e nnanna neti lhe. ");
INSERT INTO zae_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Akaba attiba uka tti udo Noé‑ni, aníha‑gaba aka ganna chi isia sá esiaya, neti benne daya yebáha. ");
INSERT INTO zae_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ka benne use'e la'ania utobake lhe u'uyabake lhe, anágaba nna betsába náke lhe beketigabake ka xi'inkeha lhe axtaliba tti bisia sá uta'a Noé‑ni lhe'e barcuha, nianna bisá inda yiesi lo yu‑ni nna iyábake uttike. ");
INSERT INTO zae_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nuha‑gaba uka tti udo Lot‑ni. Ka benne use'e la'ania utobake lhe u'uyabake lhe uyo'obake lhe betto'obake lhe anágaba údagabake lena lhe besiagabake yo'o lhe. ");
INSERT INTO zae_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ttaka tti biria Lot‑ni lhe'esi Sodoma‑ni, nianna biginni gi yebáha lhe azufre lhe. La'ania nna iyá xeaba ka benne se'e lhe'esiha betse'e loona. ");
INSERT INTO zae_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aníha‑ba aka ganna chi isia sá esiaya, neti benne daya yebáha. ");
INSERT INTO zae_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ganna chi bisia sáha nna benne doe iki yo'oha nna ganna se'e ka lo irsine lhe'e yo'oha, bittu eyadie kweabie ka nu se'e lhe'e yo'oha nna benne die lhe'exxiha, nna bittu eyye lhe'e yo'o geeha. ");
INSERT INTO zae_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gwalodhú lele ge nu gwate nuila ge Lot‑ni. ");
INSERT INTO zae_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kumu benne rasinie ka satebie ttu bixa de etenalhe neti, benneha nnittilee, delába labí aka ben benneha arlo Tata Do Yebáha. Ttaka benne eria iki eria lebie etenalhe neti meskila bixa satebie, benneha nna gwalálee arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Neti ria le, ganna loolhaha chupa ka benne teke te'adhike lo ttúba ta'a. Ttúbie echea bie nna attubie nna odha'anbe. ");
INSERT INTO zae_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ganna chupa ka benne nuila yu'uke turo'o gwettu. Ttúbie echea bie nna attubie nna odha'anbe. ");
INSERT INTO zae_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ganna chupa ka benne biyú se'eke lhe'exxiha, ttúbie echea nna attubie nna odha'anbe. ");
INSERT INTO zae_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nianna unnaba tisake bie, ráke: ―¿Gá aka nuní xa tata? Lee nna bekabie geke, ree: ―Ttiba ruin ka chettu‑na tti rilákinna ata tee ttu nimala yatti, niha ritupakana. Aníha‑gaba ilenle ganna chi esiayaha. ");
INSERT INTO zae_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús‑ni utixxi'anie ka benne rudhetinieha ttu tisa. Aníha benie kini utte dáke deki satía teeki ilhapike tisa len Tata Do Yebáha, abittu edí lireke. ");
INSERT INTO zae_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nianna tti rabie ke: ―Lhe'e ttu yiesi udo ttu xueda. Labí ria leni Tata Do Yebáha, nigaba a ria leni ka benne. ");
INSERT INTO zae_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Lhe'e yiesiha‑gaba nna udo ttu benne nuila bidabi riabie lo xuedaha, ree na: “Benchi lo ni'a gelu xa tata. Beni elhuxtisi ge nu ritilha laniaha.” ");
INSERT INTO zae_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Isába gwadána, labí bedo naga xuedaha ge benne nuilaha. Ttaka delola nna belaba leni, rana: “Meskiba a ria lasia Tata Do Yebáha lhe meskiba a ria lasia ka benne lhe, ");
INSERT INTO zae_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ttaka nuila bidabi‑ni birula ribi'ettana, dudi dúbana. Tserula ganna udo nagaa geni. Uinlaa elhuxtisi geni kini ibi'ettana nii, kini guttisinna neti.” ");
INSERT INTO zae_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesús benne anke Xxanari'iha nna ree: ―Gwaluyúruga bí ra xueda re satsa leniha. ");
INSERT INTO zae_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Anágaba Tata Do Yebáha, ¿katte gwalu abí gwa unie elhuxtisi ge ka benne chi bekwebie ki akake gebie, ganna ttixka ka benneha rela resába se'eke rinnabake lenie? Lhe anágaba, ¿katte gwalu abí gwa udiuba lebie aka lenie ke? ");
INSERT INTO zae_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Neti ria, nnela unie elhuxtisi ge ka benneha. Sun tteba nna neti benne daya yebáha ganna chi besiayaha, la'ania nna yiesi lo yu‑ni, ¿si gwetexxakarua ka benne ria leke neti? ");
INSERT INTO zae_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ka nu rákana deki ankakana ka nu ruin tseru tti adí ka benne de nuha nna rigu'u ni'akani ke, ka nuha nuní utixxi'ani Jesús‑ni kana ttu tisa, benie kini utte dákana bí diani nu raka lebie kixxi'anie kanaha. Nianna ree: ");
INSERT INTO zae_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Chupa ka nubiyú ugíakana ata do yotu ge Tata Do Yebáha gwalhapikana tisa lenie. Ttu nuha ankana fariseo, attu nuha nna ankana gwekixa. ");
INSERT INTO zae_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo‑ni nna udúna rana: “Tata Do Yebáha kia, ixkixaru rugwea kwinalu kumu neti labí ankaa tti anka adí ka benne. Ka nuná ankakana ubana lhe ankakana ka nu abittu runi nu dika ixú lhe. Anágaba nna ankakana ka nu rido lenkana ka nuila subi subi lhe nigaba labí ankaa tti anka gwekixa du naa. ");
INSERT INTO zae_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Neti rutte ubina lhe'a chupa lidú lhe'e ttuxmanu lhe rutegabaa len kwinalu tsii por ciento ge iyá belhiu ridía.” ");
INSERT INTO zae_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ttaka gwekixaha nna idittuliba duna nna nigaba a reyaxinna elhidha loni gwetsá. Sunruba rudhen ro'o lastoni nna rana: “¡Tata Do Yebáha kia, gwatuachi lelu neti de ankaa benne runi nu satsa!” ");
INSERT INTO zae_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Netiru ria, gwekixaha gwa bixúla elha xen lasi ge nuha deyyana besinna lisini; ttaka fariseo‑ni nna labí bixú elha xen lasi geni. Kumu ttu nu ruinna inná xxeni leni, elhida gaala Tata Do Yebáha nuha nna ttu nu rorexxa gaa leni nna uinlee kini inná xxeni leni. ");
INSERT INTO zae_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bisingaba ka benne cheke ka nuto geke kini ixxua ná Jesús‑ni ikikabi. Ttaka tti bilani ka benne rudhetinieha, nianna bedhaka disake ka benneha. ");
INSERT INTO zae_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nianna tti uxi Jesús‑ni ke, ree ke: ―Gwalugwelha ka binto‑na itakabi len neti. Bittu usunale, kumu ka benne runi tti runi ka binto‑na, luesi ka benne‑na nuná ralhake akake ka benne innabia Tata Do Yebáha ke. ");
INSERT INTO zae_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Netiru ria, ganna ttu benne abíba unie tti runi ttu nuto, ugwelhe innabia Tata Do Yebáha bie, benneha labí ake nu innabia Tata Do Yebáha bie. ");
INSERT INTO zae_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ttu ka nu loni ge ka nu Israel‑ni unnaba tisana Jesús‑ni, rane: ―Maestru, lu ankalu benne tse. Utixxi'achu, ¿bí anka nu unia kini satíaba aka bania arlo Tata Do Yebáha? ");
INSERT INTO zae_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús‑ni nna bekabie geni, ree na: ―¿Beaka ralu deki ankaa benne tse? Lanú ttu benne do anke benne tse, sunruba Tata Do Yebáha anke benne tse. ");
INSERT INTO zae_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Lu chiba yulu nu boka'an Tata Do Yebáha uinri'i tti ree: “Bittu dho lenlu nu abittu anka latselalu. Bittu akalu nu runi elhutti lhe bittu lhanalu lhe. Anágaba nna bittu kwentaba usialu iki ttu benne deki benie ttu bixa lhe anágaba nna tsia lelu ka tata nan gelu lhe.” ");
INSERT INTO zae_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nubiyúha nna rane: ―Ttili ankaa kwitiha gwa rudobaa tisa ge iyá nuná. ");
INSERT INTO zae_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tti biyieninie nu ra nuha, nianna bekabie geni, ree: ―Sa riyasabalu uinlu attu nu uinlu: betto'o iyá nu tee gelu nna utidhi belhiu ge nu betto'oluha nna begwe ka benne abittu geke tee. Ganna aníha uinlu nna gwattaba elha tse gelu yebáha. La'anialigaba nna chinka utá, tenalha neti. ");
INSERT INTO zae_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ttaka tti biyienin nubiyúha nu reeha, nianna yalhá si'i bedúna leni kumu yalhá tee xxatta geni. ");
INSERT INTO zae_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tti bilani Jesús‑ni deki si'iba udú le nubiyúha, nianna ree: ―¡Gáruba tsitsi anka ki isin ka nu tee gekinna akakana benne innabia Tata Do Yebáha! ");
INSERT INTO zae_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Adírula satti ga'a ttu camellu lhe'e yieru do xan ttu yoxa attichula ttu nu tee geni ga'ana akana nu innabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ka nu biyienkinna nu reeha nna rákana: ―Ganna aníha nna, ¿nú dhaana esin lenna Tata Do Yebáha? ");
INSERT INTO zae_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús‑ni nna bekabie geni, ree: ―Nu labí ridaa ka benne se'e yiesi lo yu‑ni uinke, Tata Do Yebáha nna gwa ridaabe runie nuha. ");
INSERT INTO zae_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro‑ni nna rane: ―Ri'itu chiba bedhá ikitu iyá nu tee getu nna danalhatu lu. ");
INSERT INTO zae_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Labie nna bekabie gekani, ree: ―Netiru ria le, nuxaba benne ganna chi bedhá ikie yo'o geeha lhe nuila geeha lhe ka betsieha lhe ka tata nan geeha lhe o ka xi'inieha de anke benne rinnabia Tata Do Yebáha, ");
INSERT INTO zae_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","benneha xxenirula dhie yiesi lo yu‑ni nnanna, nu si daa nna satíaba aka benbie arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús‑ni uxie ka benne tsi'inu (12) rudhetinieha attu ta subi, nianna ree ke: ―Nnannaligaba nna tsiari'i lhe'esi Jerusalén‑ni ata aka iyá nu ra lo ka yetsi ben ka profeta ge Tata Do Yebáha tti utixxi'ake gasina teeki satea, neti benne daya yebáha. ");
INSERT INTO zae_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kumu teeki taga'akana neti lo ná ka nu abittu ankakana nu Israel nna udhaka xiikana neti lhe ulisakana neti lhe. Anágaba uttuttu xxenkani loa lhe ");
INSERT INTO zae_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ukulhakana neti lhe uttikana neti lhe. Ttaka ganna chi beyonna ubisaha nna eyaka benbaa. ");
INSERT INTO zae_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ka benne tsi'inuha (12) nna labí yuke bixa ge nuha rinnebie, kumu tee ttu nu rusuna na kini abittu rite dákanie nu reeha. ");
INSERT INTO zae_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Uka nuha, tti chi dabiga Jesús‑ni isine lhe'esi Jericó, ro'o nedaha do ttu benne anke lo xua rinnabe belhiu. ");
INSERT INTO zae_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tti biyieninie rite xxatta ka benne lo nedaha, nianna tti unnaba tise bixa nuha raka. ");
INSERT INTO zae_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ka benneha nna ráke bie: ―Jesús ge Nazaret‑niba nuná ute nii. ");
INSERT INTO zae_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Benneha nna uresi'a ttebe, ree: ―¡Jesús benne datia David, gwatuachi lelu neti! ");
INSERT INTO zae_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ka benne daneruha nna rudhaka disalake benneha ki eyaka siibie, ttaka benneha nna adírula idisa uresi'e, ree: ―¡Benne datia David, gwatuachi lelu neti! ");
INSERT INTO zae_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nianna uleda Jesús‑ni nna udhelhe kini gwaxxíkana benneha. Tti chi bisine ata du Jesús‑ni, nianna unnaba tise benneha, ree bie: ");
INSERT INTO zae_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Bí raka lelu udhakaa lu? Benne lo xuaha nna bekabie, ree: ―Tata to kia, raka lasia eyali ka iyya loa‑ni. ");
INSERT INTO zae_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús‑ni nna rabie benneha: ―¡Bedhali ka iyya lolu‑na! Kumu de ugía lelu nna gwa beyakabalu. ");
INSERT INTO zae_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Looraha nna belá ttebanie nna gwanalha ttebe Jesús‑ni. Nianna rinnebie ree: ―¡Xxeniba ra le Tata Do Yebáha! Iyágaba ka benne danalhaha, tti bilákanie nu ukaha nna rágabake: ―¡Xxeniba ra le Tata Do Yebáha! ");
INSERT INTO zae_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tti uta'a Jesús‑ni lhe'esi Jericó‑ni nna yu'ubie neda ki ttebie lhe'esiha. ");
INSERT INTO zae_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Niha do ttu nubiyú tee xxatta geni lána Zaqueo, ankana xxana ka gwekixa. ");
INSERT INTO zae_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nubiyúha raka leni uinbiana Jesús‑ni, ttaka labí re'eyuna ilenna, kumu de danalha xxatta ka benne. Gwea nna Zaqueo‑ni ankabana ttu benne gwexxa, labí ankana baganti. ");
INSERT INTO zae_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Laxkala de nuha nna bexunnina uneruna nna ugwapina lo ttu yaga du gaxxaba ata tte Jesús‑ni kini ilenne. ");
INSERT INTO zae_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tti bisin Jesús‑ni ata donaha, nianna bechidha loe gwetsá nna rabie na: ―Zaqueo, beyadi dhuti, kumu nnolha teeki eya'anaa lisiluha. ");
INSERT INTO zae_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nianna gwexunniba beyadi Zaqueo‑ni nna ittaba du leni, belabina Jesús‑ni lisiniha. ");
INSERT INTO zae_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tti bilani ka nu danalhaha iyá nu ukaha, nianna iyábakana udulokana rinnekana ge Jesús‑ni, rákana: ―Gwaluyúruga, lisi ttu nu runi tulhaba nuná gwaya'anna. ");
INSERT INTO zae_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueo‑ni nna udú liilana rana Jesús benne anke Xxanari'iha: ―Biyúruga xa tata, neti ugwea ka benne abittu geke tee salhe nu tee kia‑ni lhe anágaba lhe ganna si nuxa ttu benne chi bekixaa yani, ttapa lisiala odekia geke. ");
INSERT INTO zae_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús‑ni nna rabie na: ―Nasá chi bisia sá odilá Tata Do Yebáha ka benne se'e lhe'e yo'o‑ni, kumu nubiyú du nii ankagabana benne datiana tata Abraham‑ni. ");
INSERT INTO zae_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kumu neti, benne daya yebáha, daya ugila ka benne abittu chi se'eke lo neda ge Tata Do Yebáha lhe daya gwedilaa ke lhe. ");
INSERT INTO zae_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Iki de chi biyienin ka benne iyá nuní, nianna unneru Jesús‑ni utixxi'anie ke ttu tisa. Aníha benie kini utte dáke bí diani nu raka lebie kixxi'anie keha. Kumu de chi dubie gaxxaba Jerusalén‑ni, de nuha nna rakakanie ganna chi tteba innabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aníha uka nna rabie ke: ―Ttu nubiyú ra xxeni leni diana attu yiesi dittu taxxí ladini kini innabiana. Iki deliba chi taxxí ladiniha, la'anialiba nna tti eyekina esinna. ");
INSERT INTO zae_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tti lani tsianaha nna uxina tsii ka nu riben sina geniha. Tu tulapaba begwena ka nuha belhiu nna rana kana: “Gwaltseki gwalurixxi len belhiu kia‑ni laka neti esiaya.” ");
INSERT INTO zae_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ttaka ka benne lhe'esi geniha nna ritisibakanie nubiyúha. Nianna udhelhake ttu chupa ka nu ugíakana ata dia nubiyúha kini gákana ka uxtisi se'e niha: “Labí raka letu innabia nuná ri'itu.” ");
INSERT INTO zae_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tti beyeki nubiyúha besinna iki de chi gwaxxí ladiniha, nianna tti udhelhana gwalisakana ka nubiyú bodha'anna lenkana belhuha, kini uyúna ttixa belhiu chi ulhasu ttu ttukana. ");
INSERT INTO zae_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tti bisin nu uxí belhiu sisi'a tteha, nuha nna rana: “Tata xisi to, belhiu beteluha chi ugwanina a tsii libe.” ");
INSERT INTO zae_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Lana nna rana nuha: “Tseba benlu. Lu ankalu ttu benne riben tselu sina. Kumu de gwa biyú tsitsibalu nu latti betea lenluha, de nuha nna utea lenlu kini innabialu tsii ka yiesi.” ");
INSERT INTO zae_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tti bedesina nu berupaha nna redenána: “Tata xisi to, belhiu beteluha chi ugwanina a gayu.” ");
INSERT INTO zae_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nubiyúha nna redeagabana nuha: “Anágabalu innabiagabalu gayu ka yiesi.” ");
INSERT INTO zae_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nu beyonnaha nna bisinna, rana: “Tata xisi to, ne belhiu beteluha tee nii. Utua tsebaa nuní. Lhe'e ttu lari toba ulu'a na, ");
INSERT INTO zae_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kumu usibati gelu. Lu ankalu ttu benne ruin disalu kumu redílu nu labí betelu lhe redílu lena ata labí údalu lhe.” ");
INSERT INTO zae_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nu rinnabiaha nna rana: “¡Aaluxa nu ren sina re satsa leni! La len ka tisa gelu‑naba, kuaya bala'ana gelu. Ki ganna gwa yúbalu deki ankabaa ttu nu ruin disa, redíbaa nu labí betea lhe redíbaa lena ata labí údaa lhe, ");
INSERT INTO zae_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ganna aníha nna, ¿beakala nna a gwadha'anlu belhiu kia‑na lhe'e banku kini anáchu ganna chi besiaya nna odekilu na itupa len xi'inni?” ");
INSERT INTO zae_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nianna tti rana ka nu se'e niha: “Gwalikua belhiu‑na lo náni nna gwalute nuná len nu bedienna a tsii libe iki belhiu‑na.” ");
INSERT INTO zae_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ka nuha nna rákana na: “Ttaka nuní chiba den nuní a tsii xa tata.” ");
INSERT INTO zae_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ttaka nu rinnabiaha nna rana: “¿Bíla ge ria? Benne gwa biyú tsitsie nu bete Tata Do Yebáha, dhi chiettirula benneha; ttaka nu abittu biyú tsitsina nu bete benneha nna iyála nu chi tee geniha, etua. ");
INSERT INTO zae_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ttaka ka nu ritisikinna neti, ka nu abittu raka lekani akaa nu innabia gekani, aní gwataxxí kana nna gwalutti kana arloa.” ");
INSERT INTO zae_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iki de chi beyaka unne Jesús‑ni nuha, nianna uneru ttebe arlo ka benne nna ugwapibie die lhe'esi Jerusalén‑ni. ");
INSERT INTO zae_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tti chi bisine gaxxaba ro'esi Betfagé lhe Betania lhe, gaxxaba xan i'iya ata daa ka ya olivuha, nianna udhelhe chupa ka benne rudhetinieha, ");
INSERT INTO zae_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","rabie ke: ―Gwaltsia lhe'e yiesi to re arlori'i‑ni. Tti ga'ale ro'esi to‑na nna taxxakale nalha ttu burru kwiti to nu labí chi udo ttu benne kwe'eni. Gwalidhasi yienni nna gwaltá lenna. ");
INSERT INTO zae_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ganna nuxa innaba tisana le innána: “¿Beaka ridhasile yien nuná?”, gwaligá na: “Jesús benne anke Xxanari'iha, benneha‑ba riyasanie nuní.” ");
INSERT INTO zae_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ka benne rudhetinieha nna dia ttebake nna gwaxxakabake atti tteba ra Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tti chi yu'uke ridhasike yien burru toha, nianna bisin ka benne anka xxana nuha nna unnaba tisake ka benneha, ráke: ―¿Beakala ridhasile yien burru to‑na? ");
INSERT INTO zae_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Lake nna bekabike ge ka benneha, ráke: ―Kumu Jesús benne anke Xxanari'iha‑ba riyasanie nuní. ");
INSERT INTO zae_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nianna decheke burru toha ata du Jesús‑ni nna tti bedelhake ka xokeha kwe'e bia toha nna bedoke Jesús‑ni kwe'eba. ");
INSERT INTO zae_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kua diaba Jesús‑ni risile nna ka benne daneruha diake ritsilake ka xokeha lo nedaha. ");
INSERT INTO zae_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tti chi isinke chadike liaxu iki i'iya ata daa ka ya olivuha, nianna iyába ka benne danalhake Jesús‑ni, de elha gwedeaka lasi nna uduloke uresi'ake idisa rinneke ge nu tse ruin Tata Do Yebáha de rilákanie iyá ka milagru chi ben Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nianna ráke: ―¡Karubáru benne rinnabia udhelha Tata Xisiha! ¡Yebáha‑li dabie nna use'e tsebie ka benne! ¡Xxeniba ra le Tata Xisiha doe yebáha! ");
INSERT INTO zae_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ttaka ttu chupa ka fariseo, ka nu selakana lhe'e ka benne danalhaha nna rákana Jesús‑ni: ―Maestru, bedhaka disa ka nu rudhetinlu‑ni. ");
INSERT INTO zae_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ttaka Jesús‑ni nna bekabilee gekani, ree: ―Neti ria, ganna ka nuní eyaka siikana, la'ania nna ka íyya‑nala kwesi'akana. ");
INSERT INTO zae_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tti chi bisine gaxxaba Jerusalén‑ni, nianna uresie geni tti bilánie na, ");
INSERT INTO zae_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nianna rabie na: ―¡Eru geni xa lhe'esi Jerusalén! Anágaba lu, kwadila nasá tte denlu gasina uinlu kini dho tselu len Tata Do Yebáha. Ttaka nnanna ttiba ttu nu yaya loni ankalu labí rite denlu. ");
INSERT INTO zae_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Isia sá ka nu abittu raka uyúkana luha ebi'i nookana lu nna abi'iba kwe'elu tse'ekana. Tse'ekana daka arlolu lhe tse'ekana daka kwe'elu utiakana. ");
INSERT INTO zae_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tuttíruba kweki tinnikana lu, itupa lenlu ka benne se'e lhe'elu‑na. Niruba attu íyya laa odha'ankana iki luesini, kumu lu de labí betabinlu tti bisia Tata Do Yebáha odilábie lu. ");
INSERT INTO zae_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nianna uta'a Jesús‑ni lali'a ge yotuha nna uduloe bochesue ka nu yu'u gwetto'o niha. ");
INSERT INTO zae_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nianna ree kana: ―Tata Do Yebáha lo ka yetsi geeha ree: “Yo'o kia‑ni ixúe ki ilhapi ka benne tisa len neti”; ttaka lebi'i nna ttiba “belea ata yu'u ka ubanala” chi benle yotu‑ni. ");
INSERT INTO zae_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ttu ttu sába rule'eni Jesús‑ni ka benne ro'o yotuha, ttaka ka nu loni ge ka bixxudiha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe anágaba ka nu ra xxeni lekani ge yiesiha, rekikana regila lekani gasina uinkana kini uttikane. ");
INSERT INTO zae_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ttaka lakana labí reselakinna gasina uinkana, kumu iyába ka benne rudo tsitsiba nagake ge nu reeha. ");
INSERT INTO zae_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Uka nuha, ttu sá laka du Jesús‑ni ro'o yotuha rule'enie ka benne lhe rigixxi'anie ke ka tisa tse lhe, nianna tti bisin ka nu loni ge ka bixxudiha, dia lenkana ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe ka benneola ge ka nu Israel‑ni lhe, ");
INSERT INTO zae_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","rákane: ―Utixxi'en ri'itu, ¿Bí lo neda nuná rapalu ki ruinlu aná? ¿Nú betena lo neda gelu ki raka gelu ruinlu aná? ");
INSERT INTO zae_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús‑ni nna bekabie gekani, ree: ―Anágaba neti innaba tisagabaa le ttu bixa nna gwalinná sanga: ");
INSERT INTO zae_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿nú iki biria ki begadi Juan‑ni ka benne inda? ¿Si iki Tata Do Yebáha ak? ¿Iki ka benne se'e yiesi lo yu‑ni ak? ");
INSERT INTO zae_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lakana nna udulo ttebakana rinne len luesikani, rákana: ―Ganna ekabiri'i innári'i: “Tata Do Yebáha‑ba udhelhe benneha”, la'ania nna innána: “¿Beakala a ugía lele gebie ganna?” ");
INSERT INTO zae_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ttaka ganna innári'i: “Ka benneba udhelhake benneha”, la'ania nna ebi'i nooba ka benne ri'i nna usiake ri'i íyya, kumu iyábake chiba yuke deki Juan‑ni uke ttu profeta ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aníha uka nna bekabikana rákana: ―Labí yutu nuxa udhelhana benneha. ");
INSERT INTO zae_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nianna ra Jesús‑ni kana: ―Anágaba neti bittugaba kixxi'ania le nú rutena lo neda kia ki runia aní. ");
INSERT INTO zae_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nianna udulo Jesús‑ni utixxi'anie ka benne se'e niha ttu tisa. Aníha benie kini utte dáke bí diani nu raka lebie kixxi'anie ke. Nianna tti ree: ―Ttu nubiyú beyadana ka ya uva lo yu geniha. Nianna bete gannana yuha len ttu chupa ka nu kwenkana sina lo nuha. Nianna tti biriana diana isá lhe'e attu yiesi dittu. ");
INSERT INTO zae_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tti chi bisia sá rexú uvaha nna udhelhana ttu nu riben lo sina geniha ki tsia nuha tannabana len ka nuha kini utekana nu ralhana dhina ge lo yuha. Ttaka ka nu riben lo yuha nna uyalakana nubiyúha nna suna anába ankana bedhelhakana na. ");
INSERT INTO zae_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nianna bededhelha xxana yuha attu nu riben sina geniha. Ttaka aníha‑gaba bododhakakana nuha, uyagabakana na lhe belisa xxattakana na lhe, nianna suna anába ankana bededhelhakana na. ");
INSERT INTO zae_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nianna tti bededhelhana nu beyonnaha, ttaka ka nu riben lo yuha nna nuha‑gaba bododhakakana nuha, bedeongabakana nuha gwe, nianna tti bebeakana nuha ro'o yuha. ");
INSERT INTO zae_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Ukachiba nna ra xxana yuha: “¿Bíla anka nu unia ganna? Nnanna nna idhelhabaa xi'ini biyúa‑ni, benne rakati gee‑ni, ni kina gaa benne‑niligaba gweyya lekanie.” ");
INSERT INTO zae_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ttaka tti bilani ka nu riben lo yuha xi'in biyúniha, nianna ra luesikani: “Nu daa‑ni nuní eya'anna lo yu‑ni. Uttiri'i na kini eya'anri'i len yu‑ni.” ");
INSERT INTO zae_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aníha uka nna uleakana benne kwitiha ro'o yuha nna bettikane. Nianna ra Jesús‑ni: ―Nnanna nna, ¿si gwa yule bí udhaka xxana ka ya uvaha ka nu riben lo yu geniha? ");
INSERT INTO zae_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","¿Laaba ganna tsiabana nna tettina ka nuha, nianna tti utena yu geniha len ka benne subi? Tti biyienin ka benne se'e niha nu reeha, nianna ráke: ―¡Gaxa laa innákaba Tata Do Yebáha! ");
INSERT INTO zae_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ttaka Jesús‑ni nna belannie loke, nianna tti ree ke: ―Ganna aníha nna, ¿bíla diani nu ra lo ka yetsi ge Tata Do Yebáha ata dia ra: Íyya nu ulu'u ni'a ka nu rukuakana yo'oha, íyyaha‑la nuha chi bisinna beyakana nu rixúru? ");
INSERT INTO zae_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Laxkala nuxaba benne ganna ibixxie iki íyya nu ulu'u ni'akaniha, tuttíruba iyuya benneha lhe anágaba ganna ttixka íyyaha iginnina iki ttu benne utsutsa tána benneha. ");
INSERT INTO zae_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","La'ania tteba runi ka nu loni ge ka bixxudiha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni, ruinkana udaxxukana Jesús‑ni kumu yúbakana labakana nuha betanie tisa unneeha. Ttaka labí beyaxakinna udaxxukane kumu rasibakinna ge ka benne. ");
INSERT INTO zae_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nianna tti udhelhakana ttu chupa ka nu tsiakana gwelhatsi, ukadiba uin ka nuha deki benne tseba ankakana, nianna innaba tisakane ge ttu bixa. Aníha uinkana kini ibixxinie bixa innábie, kini aníha‑chu nna tee ro'okani taga'akane lo ka uxtisi. ");
INSERT INTO zae_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ka nuha nna unnaba tisakane, rákana: ―Maestru, ri'itu yutu deki nu rinnelu‑na lhe nu rule'elu‑na lhe tseba anka nuná. Anágaba nna ttúba rulannilu iyába ka benne. Lúligaba nna rule'enlu ka benne neda ge Tata Do Yebáha attiba ankaba geni. ");
INSERT INTO zae_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nnanna nna unáchu, ¿si gwa ga'anaba kixari'i belhiu nu daa lori'i kixari'i len César nu rinnabia xeniha ak; abittuba ak? ");
INSERT INTO zae_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ttaka Jesús‑ni nna ute dábanie ge nu rulha lekani udhakakaneha, nianna tti ree kana: ");
INSERT INTO zae_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Gwalule'echuin neti ttu belhiu. ¿Nú lo nuná du lo belhiu‑na lhe nú lá nuná dia xani'a nuná lhe? Lakana nna bekabikana, rákane: ―Lá César‑niba nuní dia lo nuní. ");
INSERT INTO zae_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nianna rabie kana: ―Ganna aníha nna, gwalugweba César‑ni nu ankaba geni. Anágaba Tata Do Yebáha, gwalugwegabe nu ankaba gebie. ");
INSERT INTO zae_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nianna siiba beyakakana kumu de labí udaakana kweakane tisa arlo ka benne se'e niha. Bebanalakinna ge nu bekabie gekaniha. ");
INSERT INTO zae_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Iki de nuha nna ubiga ttu chupa ka saduceo ata du Jesús‑ni. Ka nuha labí ria lekani deki gwa reyaka benba ka benne chi uttiha. ");
INSERT INTO zae_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Nianna tti unnaba tisakane, rákana: ―Maestru, Moisés‑ni bodha'ane lenri'i lo yetsi, ree: “Ganna ttu nubiyú do lenna nuila, nianna gattina nna anúba xi'inni aka len nuila geniha, la'ania nna teeki edí betsiniha nuila bidabiha kini ka xi'inni aka len nuilaha nna eyakakana ttisidiba xi'in benne chi uttiha.” ");
INSERT INTO zae_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ttu lidú use'e gasi betsi ka nubiyú. Nu xxeniha betsába náni nna, ttaka uttibana nna lanú xi'inni uka len nuila geniha. ");
INSERT INTO zae_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nianna bedí nu berupaha nuilaha, ttaka bedeattigaba nuha nna anúgaba xi'inni bodha'anna. ");
INSERT INTO zae_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nuha‑gaba bedeoni nu beyonnaha nna aníha‑gaba bedeoni adí ka nuha. Beyába iyá gasi betsikani utti nna anúgaba xi'inkani uka len nuilaha. ");
INSERT INTO zae_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Iki de nuha nna uttigaba nuilaha. ");
INSERT INTO zae_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nnanna nna unáchu, ganna chi bisia sá eyaka ben ka benne chi uttiha nna, ¿núla nuila gekani eyaka nuilaha ganna, ki iyába gasikana udo lenkana nuha? ");
INSERT INTO zae_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús‑ni nna bekabie, ree kana: ―Ka nu se'e yiesi lo yu‑ni rutsába nákani lhe ruketibakana ka xi'inkani lhe. ");
INSERT INTO zae_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ttaka ka nu ralhakana tse'ekana attu yiesi lo yuha lhe ralhakana eyaka benkana tti eyaka ben ka benne chi uttiha, ka nuha labíru dina otsá nákani, nigaba uketikana ka xi'inkaniha. ");
INSERT INTO zae_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aní aka kumu labíru aka gattikana attu libe. Eyakabakana attiba anka ka anjeli ge Tata Do Yebáha lhe akagabakana ka xi'in Tata Do Yebáha de beyaka benkana lo elhuttiha. ");
INSERT INTO zae_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kwinagaba Moisés‑ni tti bilánie rite xxiti bisiha, la'ania benna liibie deki ka benne chi uttiha gwa reyaka benbake, kumu ree: “Tata Xisiha anke Diosi ge Abraham‑ni lhe ge Isaac‑ni lhe ge Jacob‑ni lhe.” ");
INSERT INTO zae_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Laxkala Tata Xisiha labí anke Diosi ge ka benne yattiha; labie anke Diosi ge ka benne anka bani. Kumu len benneha iyába ka benne gwanka benke. ");
INSERT INTO zae_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nianna tti unne ttu chupa ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni nna rákane: ―Tseba anka nu ralu‑na, xa maestru. ");
INSERT INTO zae_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nianna labíru beyaxakinna bixa innaba tisakane. ");
INSERT INTO zae_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús‑ni nna unnaba tise kana, ree: ―¿Galasina nna ra ka benne deki David‑ni ukana xutto Cristuha? ");
INSERT INTO zae_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ki kwinaba David‑ni rana lo yetsi ata dia ka Salmo‑na: Tata Do Yebáha ree Cristu benne runie neti mandaduha: “Utá udo daka ná ben kia. ");
INSERT INTO zae_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Niiba dholu axtaliba ganna chi bese'a ka nu abittu raka uyúkana lu, kini ulealu ikikani.” ");
INSERT INTO zae_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ki ganna David‑ni daneruna Cristuha, ¿galasina nna rálana benneha: “Lu ankalu benne ruinlu neti mandadu”? ");
INSERT INTO zae_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Iyába ka benne se'e gwedo nagaha biyienkanie ra Jesús‑ni ka benne rudhetinieha: ");
INSERT INTO zae_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Gwaluyú gele ka uinle tti ruin ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni, kumu lakana ru'u lekani rekikana len ka xalho ttuni. Gwea nna raka lekani latsiru inne ka benne tti gake kana padiuxi atti reti'ake kana lo ka neda‑na. Anágaba nna ru'ugaba lekani tse'ekana lo ka xxila tseru se'e lhe'e ka yo'o ata rudhetiri'i ka tisa ge Tata Do Yebáha lhe ru'ugaba lekani kwiakana ata anka tse tti riakana go yetta. ");
INSERT INTO zae_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Gweala nna riguakana ka yo'o ge ka nuila bidabi‑na nna ukadiba rise'ekana isá rilhapikana tisa len Tata Do Yebáha. Aníha ruinkana ki ule'e deki gwankabakana benne tse. Ka nuná elha disa tsitsirula ugwe Tata Do Yebáha kana. ");
INSERT INTO zae_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús‑ni bechidha lobie nna bilánie ka nu tee gekaniha rigu'ukana belhiu lhe'e ata ru'u úna ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Bilágabanie ttu benne nuila bidabi abí gebie tee nna rigu'ubie chupa ka belhiu to, ka nu lattiruba lidhakakani tee. ");
INSERT INTO zae_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nianna ree: ―Neti gwalígati xa, benne nuila bidabi‑na ixenirula daka belhiu ulu'u benne‑na attichula nu chi ulu'u iyá ka nu chi rigu'u belhiu‑na. ");
INSERT INTO zae_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kumu iyába ka nuná nu rexxaruba nuná rigu'ukana; ttaka benne nuila‑ni, anke benne abí gebie tee nna ulu'ube iyába belhiu tee gebie nu dika ixúnie ki aka benie. ");
INSERT INTO zae_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ttu chupa ka nu se'e niha rinnekana rákana deki latsiruba rule'e ka íyya kua yotuha lhe adíru ka nu rule'e latsitoru taa latiniha lhe. Nianna ra Jesús‑ni kana: ");
INSERT INTO zae_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Isia sá iyába nu rilenle‑ni tse'e looba nuní; niruba attu íyya laa eya'anna iki luesini. Itúbana tse'e lo. ");
INSERT INTO zae_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nianna unnaba tisakana Jesús‑ni, rákane: ―Maestru, ¿nuka aka nuní? ¿Bí aka ki unna liina deki nuní chi dabigana aka? ");
INSERT INTO zae_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús‑ni nna bekabie, ree kana: ―Gwaluyú gele, bittu tsia lele ge ka nu reki naa. Kumu ixe ka nu isiakana nna uinkana ttisidiba netiba nuha ankakana, nianna tti innákana: “Neti ankaa Cristu” lhe innákana: “Chiba dabigana lhuxa yiesi lo yu‑ni.” Lebi'i nna abittu tsia lele gekani tti innákana aníha. ");
INSERT INTO zae_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ganna chi tsu'u nagale deki chi yu'u ka yiesi ritilha len luesikani lhe se'e ka benne rese'e disakana lo ka uxtisi gekaniha lhe, lebi'i bittu gasinle, kumu lade'axa teeki aka aní. Ttaka nna laa la'ania ttega nuha chi isia lhuxa yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Rárugabe kana: ―Ka yiesi elha‑na ebi'i noo luesikani ttilhakana lhe ka nu rinnabia‑na ebi'i noo luesikani lhe. ");
INSERT INTO zae_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Anágaba nna gattibani yiesi lo yu‑ni ixú xxatta lhe ga'a ubina lhe isagwe lhe. Anágaba nna ilágabin ka benne bixa aka yebáha, nu uinna ki gasikanie lhe ebanakanie lhe. ");
INSERT INTO zae_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ttaka tti lani aka iyá nuní, lebi'i chila udaxxukana le lhe chila dhu nookana le lhe anágaba lhe taga'akana le lo ka xueda se'e lhe'e ka yo'o ata rudhetiri'i ka tisa ge Tata Do Yebáha, nianna kixxakana le lhe'e lisiyya lhe anágaba utso dúkana le arlo ka nu rinnabia xeni. Aníha udhakakana le kumu de ria lele neti. ");
INSERT INTO zae_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Aní satele kini lebi'i gapale lo neda kixxi'enle kana kia. ");
INSERT INTO zae_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Gwaluin doelha bittu uchacha ikile bixa ekabile gekani, ");
INSERT INTO zae_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kumu neti gutebaa tisa len lebi'i lhe elha rieni nu dika ose'e siina iyá ka nu ritisikinna leha ki abittu ese'e disakana lole. ");
INSERT INTO zae_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Axtagaba ka xxudileha lhe ka betsileha o si ka benne raka luesileha o ka nu se'e tse lenleha taga'akana le lo ná ka uxtisi nna ttu chupale nna uttikana le. ");
INSERT INTO zae_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Anágaba iyába ka benne se'e yiesi lo yu‑ni utía di lekani le de ria lele neti. ");
INSERT INTO zae_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ttaka niruba ttú itsa ikile, labí tse'e loo nuná. ");
INSERT INTO zae_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","¡Ganna lebi'i tse'e tsitsile, gwa daabale odilá Tata Do Yebáha le! ");
INSERT INTO zae_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ganna chi ilenle ebi'i ka soldaduha abi'iba kwe'e Jerusalén‑ni, la'ania nna chi yule deki chi tteba duna tse'e loona. ");
INSERT INTO zae_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","La'ania nna lebi'i, ata se'ele daka Judea‑ni, gwaluxunni nna gwaltsapi iki ka i'iya sia niha. Ata se'ele Jerusalén‑ni, nna gwaliria lhe'e yiesiha nna ata se'ele lhe'exxiha nna abittu eyekile tata'ale lhe'esiha. ");
INSERT INTO zae_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kumu la'ania elha disa tsitsi nuha uyúle, ganna chi aka iyá nu chi ga'anna lo ka yetsi ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Gwalíchiru le ka benne nuila ata nuja xi'inke la'ania lhe denke ka nuto rasi lhe! Kumu elha disa tsitsi nuha isia itúba lo yu geri'i‑ni. La'ania nuha Tata Do Yebáha riguabie elha rise'iki geeha len ka benneha. ");
INSERT INTO zae_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ttu chupa ke uttikana ke len espada nna adíke nna udaxxukana ke nna echekana ke lhe'e iyába ka yiesi dittu. Ka nu dittuha nna utse'e lookana Jerusalén‑ni axtaliba ganna chi gwadona sá chi ga'anani Tata Do Yebáha satekana ttu bixa. ");
INSERT INTO zae_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’La'ania nna aka ttu bixa lo tatubisa‑na lhe lo nanto beo‑na lhe anágaba lo ka beli‑na lhe. Ka benne se'e yiesi lo yu‑ni nna aka télakanie lhe gasikanie de iyienkanie tsu'u be xxatta lo indatooha de radha xxatta loni. ");
INSERT INTO zae_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Axtaba echulhakanie de elha rasi ge nu aka yiesi lo yu‑ni, kumu ka beli‑na lhe adíru ka nu ra xxeni lekani se'e gwetsáha igubibakana. ");
INSERT INTO zae_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","La'ania nna neti benne daya yebáha, iláni ka benne neti dedáya yebáha lhe'e ttu bea ra tsitsi lasia lhe raka lhalhaba xiani kia lhe. ");
INSERT INTO zae_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ganna chi dhulo aka nuní, la'ania nna gwalelhidha ikile lhe tsitsi gwalese'e, kumu neti chi tteba esiaya kini odiláya le. ");
INSERT INTO zae_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Utixxi'agabani Jesús‑ni kana ttu tisa. Aníha benie kini utte dákana bí diani nu raka lebie kixxi'anie kanaha. Nianna tti ree: ―Gwalugíaruga lo ka ya higu‑na lhe o bixaba lo attu yaga. ");
INSERT INTO zae_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ganna chi rilenle rega'a lhaga gekani, la'ania nna chi yule deki chi tteba dabigana eta'a iyya. ");
INSERT INTO zae_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Anágaba la'ania ganna chi ilenle aka nu chi ria‑ni, la'ania nna chi yule deki chi tteba dabigana innabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Netiru ria, labí chi utti ka benne se'e nnanna tti isia sá aka iyá nuní. ");
INSERT INTO zae_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yebáha lhe yiesi lo yu‑ni lhe tse'e loobaka nuní, ttaka ka tisa ria‑ni teekiba aka nu ra ka benne‑ni. ");
INSERT INTO zae_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Gwaluyú gele, bittu tse'ele uinle nu rakaba lele, nigaba akale nu dusi lhe, kini ni kina ge ka elhaxchacha iki tee yiesi lo yu‑nila do ikile, la'ania nna ttu iyyaba lasi isia sá aka iyá nu chi ria‑ni. ");
INSERT INTO zae_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kumu ttu nnelaba aka nuní, ttiba ttu nu iyaxxuna lhe'e yalhi, aníha‑ba aka nuha. Ttu nnelaba isia elha disa ge iyába ka benne se'e yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Gwaltse'e tsitsi lhe satía gwalulisa Tata Do Yebáha kini dhaale lhaale lo iyá nu aka la'ania lhe anágaba kini aka eso dule arloa, neti benne daya yebáha. ");
INSERT INTO zae_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús‑ni lo resába rule'enie ka benne ro'o yotuha, lo rela nna raya'ane iki i'iya ta daa ka ya olivuha. ");
INSERT INTO zae_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Iyába ka benne dila tteba riake ro'o yotuha kini rado nagake gebie. ");
INSERT INTO zae_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Chi tteba dabigana isia laní nu tee láni Pascua. La'ania nuha tti ro ka benne Israel‑ni yettaxtila nu abittu kua dii dia ikiniha. ");
INSERT INTO zae_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ka nu loni ge ka bixxudiha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni sigába regila lekani gasina uttikana Jesús‑ni, kumu de rasikinna ge ka benne. ");
INSERT INTO zae_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","La'ania nna tti uta'a nu xxegwiha lhe'e lasto Judas nu tegaba láni Iscariote. Lana selana len ka benne tsi'inu (12) rudhetini Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nianna ugíana gwanne lenna ka nu loni ge ka bixxudiha lhe ka nu loni ge ka nu rise'ekana ruyúkana ro'o yotuha, kini gaxasina uinna ki utena Jesús‑ni lasi ná ka nuha. ");
INSERT INTO zae_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ka nuha nna bedeakabakinna ge nu ranaha, nianna tti bisia ro'okani ugwekana Judas‑ni belhiu. ");
INSERT INTO zae_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Lana nna gwa uxielhabana dhina belhuha. Nianna udulo ttebana begila leni gasina utena Jesús‑ni lasi ná ka nuha tti anuttu benne se'e. ");
INSERT INTO zae_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tti chi bisia laní tti ro ka benne Israel‑ni yettaxtila nu abittu kua dii dia ikiniha, la'ania teeki ruttike ka neru re'eni to ki roke tti raka laníha. ");
INSERT INTO zae_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nianna udhelha Jesús‑ni Pedro‑ni lhe Juan‑ni lhe, ree kana: ―Gwaltsia, gwaluni irseri'i kini gori'i nnanna bisia laní Pascua. ");
INSERT INTO zae_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Lakana nna rákane: ―¿Gá raka lelu tsiatu sentu irseha? ");
INSERT INTO zae_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús‑ni nna bekabie gekani, ree: ―Ganna chi diale ga'ale ro'o yiesiha, niha eti'ale ttu nubiyú dedána denojana ttu re'e inda. Gwaltsia gwatanalha na ataliba eta'ana lhe'e yo'oha. ");
INSERT INTO zae_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nianna gwaligasi xxana yo'oha: “Maestruha rinnaba tise, ree: ¿Gon‑na do ttu cuartu ata go irse lania ka benne rudhetinia‑ni irse ge laní Pascua?” ");
INSERT INTO zae_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Xxana yo'oha nna ule'enna le yo'o nu do berupa kuaha. Niha chi do tse ttu cuartu xeni. Lhe'e nuha gwaluin irse ki gori'i. ");
INSERT INTO zae_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nianna diakana nna gwaxxakabakana tti tteba ra Jesús‑ni kana. Niha benkana irse ge laní Pascua. ");
INSERT INTO zae_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tti chi bisia ura go irsekeha nna bedo Jesús‑ni lenie ka apóstol geeha ro'o mexaha. ");
INSERT INTO zae_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nianna rabie ke: ―¡Yalhá chi re lasia go irsea len lebi'i nnanna laní Pascua‑ni, tti lani uyúa elha disa gattia! ");
INSERT INTO zae_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kumu neti ria le, labíru goa luesi irse‑ni, axtaliba ganna chi go irsea attu libe len lebi'i ata rinnabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nianna tti bedaxxue ttu xiga ta'a vinu nna iki de chi begwebie ixkixaru len Tata Do Yebáha, nianna rabie: ―Gwaludaxxu nuní nna gwali'iya iyále latti latti. ");
INSERT INTO zae_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kumu neti ria le, labíru i'iyaa vinu‑ni, axtaliba ganna chi isia sá innabia Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nianna tti bedaxxue yettaxtilaha nna iki de begwebie Tata Do Yebáha ixkixaru, nianna tti ulha'abie lhe'e benneha nna begwebie ke nna ree: ―Benne‑ni anke bela latia. De lebi'i nna rutea bela latia‑ni ki gattia odiláya le. Gwaligo benne‑ni nna aní uinle kini sadú lele neti. ");
INSERT INTO zae_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aníha‑gaba benie len xiga ta'a vinuha. Iki de chi beko irsekeha, nianna tti bedaxxue xigaha nna ree: ―Vinu‑ni ankana reni kia. Rugwena lidhaka tisa kubi bodha'an Tata Do Yebáha. De lebi'i nna ulalia reni kia‑ni kini odiláya le. ");
INSERT INTO zae_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ttaka nu utena neti lasi ná ka nu uttikana netiha, niiba do nuha len neti ro'o mexa‑ni. ");
INSERT INTO zae_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Gwalí galá neti benne daya yebáha, eya'abaa attiba chi ga'anna satea. Ttaka gwalíchiru le nu utena neti lasi ná ka nu uttikana netiha. ");
INSERT INTO zae_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nianna tti udulo ka benne rudhetinieha rinnaba tisa luesike nuxake nuha ruinke uteke Jesús‑ni lasi ná ka nu uttikaneha. ");
INSERT INTO zae_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ka benne rudhetini Jesús‑ni uduloke rulisa luesike ki nuxake nuha akaruke benne inná xxeniru leke tti adíke. ");
INSERT INTO zae_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús‑ni nna ree ke: ―Yiesi lo yu‑ni ka nu rinnabia‑na lhe ka nu ra xxeni lekinna lhe, ka nuná rinnabiabakana ka yiesi gekani attiba rakaba lekani, nianna rákana deki ankabakana ka nu ruin tse. ");
INSERT INTO zae_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ttaka lebi'i labí aná dika uinle. Lebi'i nu uinlale: nu inná xxeniru leniha, nuha‑la uinna deki labí ra xxeni leni; nna nu rinnabiana adí ka nuha, nna akalana attiba ttu benne rixúe rute nee len adí ka nuha. ");
INSERT INTO zae_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nianna, ¿núkana nuha ra xxeniru lekani ganna? ¿Si nu do lo mexaha ak? ¿Nú riga'ana elho lhe'e ye'ena ro nu do lo mexaha ak? ¿Laaba ganna nu do lo mexaha, lana nuha ra xxeniru leni? Neti nna labí runia aná, sinuki dolaa len lebi'i kini rixúa rute náya len lebi'i. ");
INSERT INTO zae_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Lebi'i nuná gwa use'ele len neti tti biyúa iyába ka elha disa chi gwatea. ");
INSERT INTO zae_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","De nuha nna neti utea lo neda gele ki innabiale ttiba ben Tata kiaha len neti, ");
INSERT INTO zae_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","kini anáchu aka gele gole lhe i'iyale len neti ata dhoa innabiayaha. Anágaba lebi'i kwiagabale ata innabiale kini uinle elhuxtisi ge ka benne tsi'inu (12) dhi datiake benne tee lábie Israel. ");
INSERT INTO zae_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús benne anke Xxanari'iha rágabe Simón‑ni: ―Simón, nu xxegwiha chi unnabana len neti kini ugwelhaa na udekina ikile ttiba ttu xuxtila. ");
INSERT INTO zae_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ttaka neti nna chi unnabaa len Tata kiaha gelu kini abittu udhanlu tsia lelu neti. Lu nna ganna chi eyekilu odaxxulu neda kiaha, la'ania nna lu nuná ebeki tsitsilu le ka betsi to gelu‑ni kini ese'e tsitsike lo neda kia. ");
INSERT INTO zae_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón‑ni nna rane: ―Neti gwadúbaa lenlu xa tata, meskila tsia lania lu lisiyya, lhe o meskila gattia len kwinalu lhe. ");
INSERT INTO zae_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús‑ni nna bekabie geni, ree: ―Pedro, neti ria lu, nnolha, tti lanila kwesi chinkaha, lu tsunna libela chi bedhea lelu a ridí ro'olu deki ankabienlu neti. ");
INSERT INTO zae_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nianna unnaba tisa Jesús‑ni ke, ree: ―Tti udhelhaa le tti abittu belhiu cheleha lhe tti abittu chele nu ixuinle tsu'ule nedaha lhe anágaba tti abittu che gwaracha geleha, la'ania, ¿si biyasa ttu bixa gele? Lake nna bekabike, ráke: ―Labí. ");
INSERT INTO zae_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nianna ree ke: ―Ttaka nnanna nu tee belhiu geniha nna teeki dheni belhiu geni, anágaba nna ujana nu ixuinna tsu'una neda. Nu abittu espada geni tee nna utto'ona jabana geniha kini go'ona ttu espada geni. ");
INSERT INTO zae_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kumu neti ria le, teeki satea attiba ra lo ka yetsi ge Tata Do Yebáha ata dia ra: “Bedhakabakane ttiba rudhakakana ttu nu ruin satsa.” Kumu iyába nu ra lo ka yetsi ge Tata Do Yebáha deki satea tee kiba aka nuha. ");
INSERT INTO zae_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Lake nna ráke: ―Tata, ne chupa ka espada se'e nii. Lee nna bekabie, ree ke: ―Chinka, ttanába. ");
INSERT INTO zae_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nianna beria tteba Jesús‑ni lhe'e yo'oha nna diabie iki i'iya ata daa ka ya olivuha, benbe attiba chi labinie runie. Ka benne rudhetinieha nna danalhagabake bie. ");
INSERT INTO zae_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tti bisinke iki i'iyaha, nianna ree ke: ―Gwalinnaba len Tata Do Yebáha kini abittu dhi yie nu xxegwiha le nna eyadi gaale. ");
INSERT INTO zae_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Lee nna biru'une ata se'ekeha, biru'unabe ttiba ata radhá ttu íyya tti rigu'unari'i na. Nianna tti bedú xibie unnebie len Tata Do Yebáha, ree: ");
INSERT INTO zae_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","―Tata to, ganna kwinalu edá lelu, bodiláttu neti lo elha disa uyúa‑ni. Ttaka labí nu innía aka; nu inná kwinabalu aka. ");
INSERT INTO zae_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nuha‑ba ree nna tti uka xxe ttu anjeli ge Tata Do Yebáha bisie kini udú tsitsie bie. ");
INSERT INTO zae_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tti lo ruyú xxatta Jesús‑ni elha disaha, adikala itú lebie rilhapie tisa len Tata Do Yebáha. Indedha geeha nna tsuin tsuinba riginnina lo yu ttiba risuni reni. ");
INSERT INTO zae_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tti uluxanie unne lenie Tata Do Yebáha, nianna bedú liibie nna besine ata se'e ka benne tsunna rudhetinieha, gwaxxake ka benneha te'adhike de du si'i leke. ");
INSERT INTO zae_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nianna ree ke: ―¿Beaka te'adhile? Gwalchadha nna gwalinnaba len Tata Do Yebáha kini abittu dhi yie nu xxegwiha le nna eyadi gaale. ");
INSERT INTO zae_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sa dula Jesús‑ni rinnebie, ttiru chi bisin ixe ka benne ata dueha. Nu tee láni Judas, delába nu selagabana ka benne tsi'inu (12) rudhetinieha, lana daneruna lo ka benneha. Nianna ubigana gwattona xxaga Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesús‑ni nna rabie na: ―Judas, neti benne daya yebáha, ¿si de utolu xxagaa‑ni nna utelu neti lasi ná ka nu uttikana neti? ");
INSERT INTO zae_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tti chi bilani ka benne se'eke len Jesús‑ni nu raka la'ania, nianna ráke bie: ―Tata, ¿si gutíatu len ka espada‑ni? ");
INSERT INTO zae_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nianna ttu ka benneha benie gwe nubiyú riben lo sina ge bixxudi xeniha, uchúe naga ben geni. ");
INSERT INTO zae_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ttaka Jesús‑ni nna rabie: ―Chinka, ttanába. Nianna tti utane naga nubiyúha nna beyonie nagani. ");
INSERT INTO zae_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nianna rabie ka nu daa udaxxukaneha, delába ka nu loni ge ka bixxudiha lhe ka nu rise'e gweyú ro'o yotuha lhe anágaba ka nu anka benneola ge ka nu Israel‑ni lhe, rabie kana: ―¿Beaka ttiba ttu nu daa gwedaxxu ubana dale gwedaxxu neti, denle espada lhe yaga lhe? ");
INSERT INTO zae_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ki ttu ttu sába udúa len lebi'i ro'o yotuha, nna abí chiga bedaxxule neti. Ttaka nnanna anka ura gele, kumu nnanna anka chulha rinnabia nu xxegwiha. ");
INSERT INTO zae_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nianna tti bedaxxukana Jesús‑ni nna dechekane lisi bixxudi xeniha. Pedro‑ni nna idittuliba danalhana. ");
INSERT INTO zae_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nianna tti bekuakana gi lali'a ge yo'oha nna use'ekana abi'iba kwe'e nuha. Niha‑gaba beteche Pedro‑ni lagwi gekani. ");
INSERT INTO zae_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ttu nuila riben sina niha, tti bilenna Pedro‑ni dona kwe'e giha, nianna begía tsittabana loni nna rana: ―Nubiyú re nii, len Jesús‑nigaba reki nuní. ");
INSERT INTO zae_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ttaka Pedro‑ni nna labí uxí ro'oni, rálana: ―Labí ankabiati nuná xa nuila. ");
INSERT INTO zae_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ttu sattiruba chi bedete nna lengwa chi bedeláni attuna, nianna redenána: ―Lu lhe, ki luesi ka nunágabalu. Ttaka Pedro‑ni nna rana: ―Laa luesi ka nunága neti. ");
INSERT INTO zae_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ttiba ttu ura chi bedete, lengwa chi redená attuna: ―Neti rakati nu re nii len nunágaba reki nuní, kumu nu Galileagaba nuní. ");
INSERT INTO zae_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ttaka Pedro‑ni rana: ―Labí yua bí ge nuná rinnelu. A riluxala rinnenaha, ttiru chi uresi chinkaha. ");
INSERT INTO zae_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nianna tti bodeki lo Jesús benne anke Xxanari'iha belannie lo Pedro‑ni. Lana nna gwadú tteba leni tti ree: “Nnolha attila lani kwesi chinkaha, lu tsunna libela chi bedhea lelu abí ridí ro'olu deki ankabienlu neti.” ");
INSERT INTO zae_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nianna beria tteba Pedro‑ni ro'o yo'oha nna uresibana ttibaxkaba leni de releninna. ");
INSERT INTO zae_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ka nubiyú se'ekana ruyúkana Jesús‑ni nna ruxisikana gebie lhe rudhenkane lhe. ");
INSERT INTO zae_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ruttokana lobie nna tti rinnaba tisakane, rákane: ―Unne ya'achu, ¿nú nuná bedhenna lolu? ");
INSERT INTO zae_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bikala nuha rákane rulisa xxattakane. ");
INSERT INTO zae_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tti ugwani dilaha nna bitupa ka benneola ge ka nu Israel‑ni lhe ka nu loni ge ka bixxudiha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe, ka nuha uchekane ata ritupakana ruinkana elhuxtisiha. Nianna tti unnaba tisakane, rákane: ");
INSERT INTO zae_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Utixxi'en ri'itu, ¿si lu ankalu Cristu benne chi ga'anani Tata Do Yebáha idhelhe? Labie nna bekabie gekani, ree: ―Ganna innía: “Ila”, la'ania nna laa gweyyaga lele kia ");
INSERT INTO zae_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","lhe anágaba ganna neti innaba tisaa le ttu bixa, la'ania nna abígaba ekabile kia. ");
INSERT INTO zae_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ttaka debá nnanna neti benne daya yebáha, esinaa dhoa daka ná ben ge Tata Do Yebaa benne ra xxeni leeha. ");
INSERT INTO zae_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nianna iyábakana unnaba tisakane, rákana: ―Ganna aníha nna, ¿si lu nuná ankalu Xi'in Tata Do Yebáha? Jesús‑ni nna bekabie gekani, ree: ―Lebi'iba chi ra deki nuná ankaa xa. ");
INSERT INTO zae_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nianna rákana: ―Nnanna labíru riyasinri'i kixxi'akinna ri'i nuxa ankana. Ki kwinabari'i chi biyieninri'i nu rana. ");
INSERT INTO zae_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nianna iyábakana bedú liikana nna uchekana Jesús‑ni gwatso dúkane arlo Pilato‑ni. ");
INSERT INTO zae_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nianna udulokana besiakana ikie, rákana: ―Nubiyú du nii gwaxxakatu na rekina ruchixxina iki ka benne getu‑ni lhe rusunana uteke belhiu nu ruteri'i len César nu rinnabia xeniha. Anágaba nna rana deki lana ankana Cristu nu rinnabia. ");
INSERT INTO zae_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nianna unnaba tisa Pilato‑nie, rane: ―¿Si lu ankalu nu rinnabia ge ka nu Israel‑ni? Lee nna bekabie geni, ree: ―Luba chi ra deki nuná ankaa xa. ");
INSERT INTO zae_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nianna ra Pilato‑ni ka nu loni ge ka bixxudiha lhe ka benne sama niha lhe, rana ke: ―Neti, labí raxxakaa bixa tulha daa nubiyú‑ni. ");
INSERT INTO zae_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ttaka lakana nna doelhaba ruinkana, rákana: ―Rekina rutsatsana ka benne. Itúba daka Judea‑ni rekina rule'enna ke nu yuna. Udulona daka Galilea‑ni nna axtaba bisiana nii. ");
INSERT INTO zae_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tti biyienin Pilato‑ni rudettikana Galilea‑ni, nianna unnaba tisana kana ganna Jesús‑ni anke nu Galilea. ");
INSERT INTO zae_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tti biyieninna rákana deki dabie daka lo yu ata rinnabia Herodes‑ni, nianna bedhelhane arlo Herodes‑ni kumu lhe'esi Jerusalén‑nigaba re nuha la'ania. ");
INSERT INTO zae_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes‑ni nna tti bilenna Jesús‑ni yalhá bedeakinna kumu chi usá re leni ilenne de biyieninna ge nu runieha. De nuha nna raka leni ilenna unie ttu milagru. ");
INSERT INTO zae_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Laxkala ixe nu unnaba tisane, ttaka labie nna kwachiruba bekabie geni. ");
INSERT INTO zae_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ka nu loni ge ka bixxudiha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni, se'ekana nna doelhaba ruinkana rukinnikane. ");
INSERT INTO zae_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes‑ni lenna ka soldadu geniha nna labí biyú tsekane, bexisilakana gebie. Nianna begukukane ttu lari raka galha loni nna tti bedhelhakane arlo Pilato‑ni. ");
INSERT INTO zae_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","La sáha nna Pilato‑ni lenna Herodes‑ni bese'e tse len luesikani, kumu tti lanila aka nuní, labí raka uyú tse luesikani. ");
INSERT INTO zae_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato‑ni nna bottupana ka nu loni ge ka bixxudiha lhe ka uxtisi ge ka nu Israel‑ni lhe, anágaba ka benne ge yiesiha lhe. ");
INSERT INTO zae_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nianna tti rana kana: ―Lebi'i betega'ale nubiyú du nii loa, rusiale ikini rale deki rekina rutsatsana ka benne lhe'esi‑ni. Ttaka neti nna arlobale chi unnaba tisaa na nna labí gwaxxakaa deki ruinna nu rusiale ikinna. ");
INSERT INTO zae_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nigaba Herodes‑ni labí gwaxxakana bixa ben nuní, ki bedhelhalana nuní len ri'i attu libe. Gwaluyúruga, labí chi ben nuní ttu bixa nu dika ralhana gattina. ");
INSERT INTO zae_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Laxkala ugwebaa na ttu elha disa tsitsi, iki de nuha nna olhábaa na. ");
INSERT INTO zae_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Aníha ra Pilato‑ni kumu kua laníba teeki ebeana ttu nu tee lisiyya. ");
INSERT INTO zae_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ttaka iyábakana tulapaba uresi'akana, rákana: ―¡Betti nuná nna Barrabás‑naba bodilaa! ");
INSERT INTO zae_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás‑ni tena lisiyya kumu lhe'esiha lana lenna adíru ka nu subi, bese'e disakana arlo ka uxtisiha, anágaba nna de benna elhutti. ");
INSERT INTO zae_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato‑ni nna de raka leni odilána Jesús‑ni, aníoka nna belisana kana attu libe. ");
INSERT INTO zae_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ttaka lakana nna adíla idisa uresi'akana, rákana: ―¡Betá nuná lo ya kurusi! ¡Betá nuná lo ya kurusi! ");
INSERT INTO zae_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Beyonna libeha nna ra Pilato‑ni kana: ―¿Bíla nu satsa ben nuní ganna xa? Neti labí raxxakaa bixa benna ttu nu dika ralhana gattina. Ugwebaa na ttu elha disa nna iki de nuha nna odilábaa na. ");
INSERT INTO zae_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ttaka lakana nna bittuba bedo nagakani, ribesi'anibakana rinnabakana utáne lo ya kurusi. De ribesi'a xxattakanaha nna aloba biri'a lenkana, ");
INSERT INTO zae_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ben Pilato‑ni nu rinnabakanaha. ");
INSERT INTO zae_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Aníha uka nna bodilábana nubiyú nu unnabakana odilánaha, delába nu tee lisiyyaha de bedú disana arlo ka uxtisiha lhe de benna elhutti lhe. Ttaka Jesús‑ni nna botebane lasi nákani kini udhakakane nu rakaba lekani. ");
INSERT INTO zae_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tti chi dia lenkana Jesús‑ni kini utákane lo ya kurusiha, nianna bedaxxukana Simón ge lhe'esi Cirene‑ni, dedá nuha ugíana lhe'exxi. Nuha bejuakana na ya kurusiha kini bijana nuha tanoona Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Danalhagaba ixe ka benne lhe'esiha lhe anágaba danalhagaba ka benne nuila ribesike gebie de resi'ikanie bie. ");
INSERT INTO zae_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ttaka Jesús‑ni nna bodeki loe ata se'e ka benneha nna ree ke: ―Benne nuila ge Jerusalén. Bittu kwesile kia, gelale gwalikwesi lhe ge ka xi'inle‑na lhe. ");
INSERT INTO zae_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kumu isia sá inná ka benne: “Karubáru ka nuila ka nu abittu aka uja xi'inkani lhe ka nu anuttu xi'inkani chi bija lhe, anágaba ka nu anuttu nuto chi begasikana lhe.” ");
INSERT INTO zae_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nianna dhuloke gake ka i'iya‑na: “¡Gwaloguku ikitu!”, nna ka sitta xua xea‑na nna gake kana: “¡Gwalukatsi ri'itu!” ");
INSERT INTO zae_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kumu ki neti ankalaa attiba ttu ya ya'a nna rudhakakana neti aní, adírula udhakakana lebi'i de ankale attiba ttu ya bisi. ");
INSERT INTO zae_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Chegabakana a chupa ka nubiyú ben satsa kini uttikana ka nuha itupa len Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tti chi bisinkana lo yu tee láni Bega Iki Nu Yatti, niha betákana ke lo ka ya kurusi. Ttu ka nu ben satsaha betákana na daka ná ben gebie nna attuna nna daka ná yattie. ");
INSERT INTO zae_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nianna unne Jesús‑ni, ree: ―Tata, uxíchi elha xen lasi ge ka nu se'e nii, kumu labí yu ka nuní nu ruinkana. Ka soldaduha nna bedelhakana suerti kini elha'akana ka xo Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ka benne nna se'ebake rulannike, ka uxtisiha nna ruxisilakana gebie, rákana: ―Benne subi gwa bodilána. Nnanna nna titúbana eláchuna ganna gwalíginna ankana Cristu nu chi bekwe Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Anágaba ka soldaduha ruxisigabakana gebie. Ribigakana nna rugwekane vinu idí, ");
INSERT INTO zae_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","nianna ra kane: ―¡Ganna gwalíginlu ankalu nu rinnabia ge ka nu Israel‑ni, titúbalu beláchu lo ya kurusi‑ni! ");
INSERT INTO zae_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Lo ya kurusiha daka xekie, niha taa ttu breta ra loni: “Nuní ankana nu rinnabia ge ka benne Israel.” ");
INSERT INTO zae_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ttu ka nu ben satsa taa lo ya kurusiha rulisa satsane, rane: ―¡Ganna gwalíginlu ankalu Cristu, titúbalu beláchu lo ya kurusi‑ni lhe bodiláchu ri'itu lhe! ");
INSERT INTO zae_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ttaka attu nuha nna bedhaka disalana nu rinneeha, rana na: ―Lu, ¿si bi gwa elha rasi gelu tee len Tata Do Yebáha ki luesi elha disa ruyú benne‑nigaba ruyúlu? ");
INSERT INTO zae_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ri'i ruyú galári'i elha disa lo ya kurusi‑ni, kumu ralhabari'i kixari'i ge nu benri'i, ttaka benne‑ni nna labí bixa nu satsa chi benie. ");
INSERT INTO zae_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nianna tti rana Jesús‑ni: ―Tadúttu lelu neti ganna chi dhulolu innabialuha. ");
INSERT INTO zae_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nianna ra Jesús‑ni na: ―Netiru ria, nasá tteba esin lenlu neti ata dho tselu. ");
INSERT INTO zae_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ttiba tu retin tsi'inuha (12) bechulha itúba yiesi lo yu‑ni nna retin tsunnaha‑liba beyani. ");
INSERT INTO zae_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tatubisa‑na bechulhaba lobie nna lari daa lagwi lhe'e yotuha nna chubaa tíba bireda nuha. ");
INSERT INTO zae_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesús‑ni nna unnebie idisa, rabie: ―Tatoo, lasi nálu otea elha nabani kia‑ni. Nuha‑ba rabie nna tti uttie. ");
INSERT INTO zae_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tti chi bilani soldadu nu baninna ttu gayua (100) ka soldadu ge Roma‑ni nu chi ukaha, nianna rana: ―¡Xxeniba ra le Tata Do Yebáha! Gwalíba nna nubiyú‑ni benne tseba anka nuní. ");
INSERT INTO zae_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Iyába ka benne tupake ata uka nuha, tti bilákanie iyá nu chi ukaha, nianna si'iba du leke rudhen ro'o lastoke deyyake. ");
INSERT INTO zae_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ttaka iyába ka benne ankabiakanie Jesús‑ni lhe ka benne nuila gwanalhake bie tti ugwekie daka Galilea‑ni lhe, iyába ka benneha idittuliba se'eke rulannike iyá nu rakaha. ");
INSERT INTO zae_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","La'ania udo ttu benne biyú lábie José, re tse lebie lhe runie nu dika ixú lhe. Benneha anke benne lhe'esi Arimatea, ttu yiesi re daka Judea‑ni. Benneha sele lhe'e ka nu ruinkana elhuxtisi ge ka nu Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","José‑ni dogabe ribede isia sá innabia Tata Do Yebáha ka benne lhe anágaba nna bittugaba uyu'u lebie nu ben adí ka nuha len Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nianna ugíabie arlo Pilato‑ni nna unnabe lenna kini ugwelhane elhide Jesús‑ni lo ya kurusiha. ");
INSERT INTO zae_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Iki de belhide benneha, nianna tti bottesie bie lhe'e ttu lari sibi nna gwakatsie bie lhe'e ttu baa do lhe'e ttu íyya daa niha, ata lanú benne yatti chi bigatsi niha. ");
INSERT INTO zae_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","La'ania anka viarna nna la sáha ankana tti rese'e tse ka benne Israel‑ni kumu chi isia sá tti reyaka leke. ");
INSERT INTO zae_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ka benne nuila daa lenke Jesús‑ni ttili dabie daka Galilea‑ni, ka benneha ugíake nna bilákanie yieru baaha lhe bilákanie gasina utixxake benne yattiha lhe. ");
INSERT INTO zae_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tti besinke lhe'e yo'o ata se'ekeha nna benke ka biste rure ixixxi lhe adíru ka nu kabike lati Jesús‑ni. Nianna beyakaba leke la sá tti reyaka le ka nu Israel‑ni. Benbake attiba chi ga'anna lo bia bennabi bodha'an Moisés‑ni. ");
INSERT INTO zae_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ugwani dila tti bedú ni'a xumanuha, dila tteba udá ka benne nuilaha diake iki baaha cheke ka nu rure ixixxi chi benkeha. ");
INSERT INTO zae_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tti bisinkeha nna bilákanie íyya yaya ro'o yieru baaha, labíru yaya nuha ro'oni. ");
INSERT INTO zae_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nianna uta'ake lhi'u, ttaka lanúru Jesús benne anke Xxanari'iha gwaxxakake niha. ");
INSERT INTO zae_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Uka télakanie tti bilákanie nu chi ukaha. Ttiru nna ttu nnelaba chi uka xxe chupa ka benne biyú ata se'ekeha, nukuke xo raka lhalhaba loni. ");
INSERT INTO zae_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ka benne nuilaha nna itú rasibakanie bedetta loke lo yu. Ttaka ka benne biyúha nna ráke ke: ―¿Beaka regilale benne anka baniha lhe'e ka benne chi uttiha? ");
INSERT INTO zae_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Lanúru benneha tee nii, chiba beyaka ben benneha. Gwalodhú lele ge nu rabie tti sa rekie daka Galilea‑ni. ");
INSERT INTO zae_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Rabie deki lee benne daa yebáha, teeki iginnie lo ná ka nu ruin satsaha nna utákane lo ya kurusiha; eyonna ubisaha nna eyaka benbe. ");
INSERT INTO zae_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","La'aniala nna tti bodhú leke ge ka tisa unne Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nianna bedáke ro'o yieru baaha nna besinke utixxi'akanie ka benne sinea (11) bedhetinieha lhe adíru ka benne se'e niha, utixxi'akanie ke iyá nu chi bilákanieha. ");
INSERT INTO zae_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","María Magdalena‑ni nna Juana‑ni nna María nan ge Jacobo‑ni lhe adíru ka benne nuila, ka benneha nuha besinke utixxi'ake. ");
INSERT INTO zae_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ttaka ka apóstoal nna bitti ukalakanie ge nu ra ka nuilaha nna labí ugía leke ge ka benneha. ");
INSERT INTO zae_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ttaka Pedro‑ni nna bexunni ttebana diana ro'o yieru baaha. Tti bisinna ro'o nuha nna biyettana beká loni; ttaka lanúru Jesús‑ni bilenna, a sunruba ka lari nu bitesi benneha se'e. Nianna beyekina besinna lhe'e yo'oha nna rebanabinna ge nu chi ukaha. ");
INSERT INTO zae_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","La sáha‑gaba, dia chupa ka benne bedhetini Jesús‑ni yu'uke neda diake lhe'e ttu yiesi tee láni Emaús. Re nuha ttiba sinea (11) kilómetru idittu len lhe'esi Jerusalén‑ni. ");
INSERT INTO zae_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Diabake rinneke ge iyá nu chi ukaha. ");
INSERT INTO zae_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Laka diake rinnekeha nna ttiru chi uka xxe Jesús‑ni gwaxenie ke, nianna dia lenie ke turo'o. ");
INSERT INTO zae_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ttaka ttiba ttu nu yu'u ttu bixa loni, aníha‑ba ankake, labí rugwelhana eyakabiakanie bie. ");
INSERT INTO zae_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús‑ni nna unnaba tise ke, ree: ―¿Bí ge nuná rinnele yu'ule neda‑ni? Lake nna paba bese'eke nna si'iba du leke. ");
INSERT INTO zae_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nianna unne ttu ka benneha, delába benne lá Cleofas, bekabie ree: ―¿Si ttúbalu nu dittu dolu lhe'esi Jerusalén‑ni nna abittu binalu nu uka lhe'esi‑ni nnaya nnadhi? ");
INSERT INTO zae_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Labie nna bekabie, ree ke: ―¿Bí uka? Lake nna ráke: ―Nu gwate Jesús ge Nazaret‑niba xa. Benneha uke profeta ge Tata Do Yebáha. Yalhá lhe'e unnebie lhe xxeniba anka nu benie arlo Tata Do Yebáha lhe arlo iyába ka benne lhe. ");
INSERT INTO zae_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ttaka ka nu loni ge ka bixxudiha lhe ka uxtisi geri'i‑ni nna betelakane lasi ná ka nu uttikane. Ka nuha nna beda'a ro'okani rákana deki gattie, nianna betákane lo ya kurusiha. ");
INSERT INTO zae_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Batu ri'itu xxenba letu deki labie odilábie ka benne Israel‑ni. Ttaka betse'e loona aníla uka, chi uka tsunna ubisa‑ni tti gwatebie nuha. ");
INSERT INTO zae_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ttaka anágaba nna ttu chupa ka benne nuila se'eke len ri'ituha, chi bedú téke letu kumu dila tteba ugíake ro'o yieru baaha nna ");
INSERT INTO zae_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ttaka lanúru benne yattiha gwaxxakake. Nianna beyekike besiake lhe'e yo'o ata se'etuha nna rigixxi'ake ráke deki bele'e lo ka anjeli ge Tata Do Yebáha lenke. Ka anjeliha nna ráke deki Jesús‑ni anka benba benneha. ");
INSERT INTO zae_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Chigaba ugía ttu chupa ka benne getu gwalannike ro'o yieru baaha nna gwaxxakabake tti tteba ra ka nuilaha, ttaka Jesús‑ni nna lanúbie bilákanie. ");
INSERT INTO zae_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nianna rabie ka benneha: ―Gattiparuba riyasale tte denle lhe gattiparuba tsitsi anka ki tsia lele iyá nu unne ka profeta ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Laaba ganna teeki tate Cristuha iyá nuní atti lanila esine yebáha inná xxeni lebie? ");
INSERT INTO zae_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nianna udulobie utixxi'anie ke ata rinne gebie lo iyába ka yetsi ge Tata Do Yebáha, uduloe len ka yetsi bodha'an Moisés‑ni nna belhuxe len ka yetsi bodha'an ka profetaha. ");
INSERT INTO zae_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tti bisinke ro'o yiesi ata diakeha, Jesús‑ni nna benbe ttisidiba ttebe tsiabie. ");
INSERT INTO zae_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ttaka lake nna unnaba ditibake loe kini eya'ane lenke nna ráke bie: ―Utá, beya'ana len ri'itu, kini chiba dia tatubisaha nuní. Chi tteba galha nuní. Nianna uta'abie eya'ane lenke. ");
INSERT INTO zae_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tti chi se'eke ro'o mexaha, nianna bedaxxue yettaxtilaha nna begwebie Tata Do Yebáha ixkixaru, nianna ulha'abie lhe'e benneha, begwebie ke. ");
INSERT INTO zae_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","La'ania attiba ttu nu biyali loni ukake nna beyoinbia ttebake Jesús‑ni, ttaka lee nna benitti loo ttebe. ");
INSERT INTO zae_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nianna ra luesike: ―Laxkala bega'a dina lhe'e lastori'i, tti dabie rinne lenbie ri'i tti yu'uri'i nedaha, rigixxi'anie ri'i nu ra lo ka yetsi‑na. ");
INSERT INTO zae_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nianna birua uledake nna begu'u ttebake neda besinke lhe'esi Jerusalén‑ni. Niha betexxakake tupa ka benne sinea (11) anka apóstoal lhe adíru ka benne lhe. ");
INSERT INTO zae_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ka benneha nna ráke: ―Gwalíba chi beyaka ben Jesús benne anke Xxanari'iha. Chi bele'e lobie len Simón‑ni. ");
INSERT INTO zae_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ka benne besinaha utixxi'agabakanie ka benneha nu gwateke tti yu'uke nedaha lhe utixxi'agabakanie ke gasina uka beyakabiakanie Jesús‑ni tti rilha'abie lhe'e yettaxtilaha. ");
INSERT INTO zae_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sa yu'ulake rinneke ge nuha, ttiruba chi uka xxe Jesús‑ni, udúbie lagwi geke nna begwebie ke padiuxi nna ree ke: ―Bittu aka tenle, xen su lasi gwaltse'e. ");
INSERT INTO zae_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lake nna yalhá usikanie, rakakanie ganna ttu espírituba nuha rula'akanie. ");
INSERT INTO zae_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ttaka Jesús‑ni nna rabie ke: ―¿Beaka raka tenle? ¿Beaka rudú chupana lele? ");
INSERT INTO zae_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gwalulanniruga ka ni'aya‑ni lhe ka náya‑ni lhe. Netiba nuní. Gwaludaxxuruga latia kini aka xen lele. Ttu espíritu labí bela tee lati nuha, nigaba labí yu'una sitta tti rilenle yu'a sitta. ");
INSERT INTO zae_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tti rabie ke aníha, nianna tti bele'enie ke ka ni'eha lhe ka neeha lhe. ");
INSERT INTO zae_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ttaka lake nna si se'elake redeakakanie lhe rebanakanie lhe. De nuha nna labí yuke bixa ulaba leke. Nianna unnaba tisa Jesús‑ni ke, ree: ―¿Si bi gwa tee ttu bixa goa? ");
INSERT INTO zae_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Lake nna begweke bie salha'a belha chi biyexxu. ");
INSERT INTO zae_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Labie nna bedaxxube nuha nna utoe na arloke. ");
INSERT INTO zae_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nianna ree ke: ―Ge nu gwatea‑niba nuha chi utixxi'ania le tti sa doa len lebi'iha tti ria deki teeki satea iyá nu dia lo ka yetsi bodha'an Tata Do Yebáha len Moisés‑ni lhe nu dia lo ka yetsi bodha'an ka profeta ge Tata Do Yebáha lhe, anágaba nu ra lo ka Salmo‑na lhe. ");
INSERT INTO zae_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nianna tti udhalie ikike ki uka geke ute dákanie ka tisa dia lo ka yetsiha. ");
INSERT INTO zae_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jesús‑ni nna rabie ke: ―Lo ka yetsiha rixxi'a ra deki Cristuha teeba ki gatti benneha nna eyonna ubisaha nna eyaka benbe lagwi ge ka benne chi uttiha. ");
INSERT INTO zae_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Anágaba nna rixxi'agaba ra deki teeki tsiakana innekana kwenta gebie, kixxi'akinna ka benne deki teeki odúna ke nna odaxxuke neda ge Tata Do Yebáha, kini anáchu nna ixú elha xen lasi ge ka tulha ruinke. Dhulokana kixxi'akana lhe'esi Jerusalén‑ni, nianna tti tsiakana lhe'e iyába ka yiesi se'e itúba yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Lebi'i nuná kixxi'ale iyá nuní, ");
INSERT INTO zae_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","neti nna idhelhaa len lebi'i benne chi ra Tata kia deki utebie gele. Ttaka nna teeki kwedale lhe'esi Jerusalén‑ni axtaliba ganna chi unie kini inná tsitsi lele. Yebáha‑li daa nu tsitsi ra leeha kini utebie na gele. ");
INSERT INTO zae_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iki de nuha nna tti che Jesús‑ni ke biriake ro'esiha nna bisinke axtaba Betania. Nianna tti ulhidha nábie gwetsá nna unnabe kini aka len Tata Do Yebáha ke. ");
INSERT INTO zae_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Laka due rinnabe geke len Tata Do Yebáha, nianna beru'une ata se'ekeha nna beyapie deyye yebáha. ");
INSERT INTO zae_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Lake nna iki de chi bedú xibike bilhake ge Jesús‑ni, nianna redeaka tábakanie beyekike deyyake lhe'esi Jerusalén‑ni. ");
INSERT INTO zae_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ttu ttu sába se'eke lhe'e yotuha rulhake ge Tata Do Yebáha.");
INSERT INTO zae_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Attili lani kwe yiesi lo yu‑niha, chi do benne anke tisaha nna len Tata Do Yebáha‑ba doe nna la tisaha‑ba nuha anke Diosi. ");
INSERT INTO zae_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Lee nuha chi doe len Tata Do Yebáha attili lani kwe yiesi lo yu‑niha. ");
INSERT INTO zae_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Labie bixuin Tata Do Yebáha kini benie iyá tte nu se'e. Ganna ttixka anúba benneha do, la'ania nna iyába nu chi ukaha, labí uka nuha ganna ttixka. ");
INSERT INTO zae_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Len benne anke tisaha tee elha nabani geri'i ttu dia lii nna benne anke elha nabaniha, benneha nuha anke xiani ge ka benne. ");
INSERT INTO zae_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Xianiha nuha rudanie lhe'e chulhaha nna chulhaha labí udaana loe. ");
INSERT INTO zae_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Udo ttu benne biyú udhelha Tata Do Yebáha. Benneha utta lábie Juan. ");
INSERT INTO zae_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Labie bisiabie kini utixxi'e ge benne anke xianiha kini anáchu de nu utixxi'a Juan‑ni nna iyába ka benne tsia leke ge benne anka xianiha. ");
INSERT INTO zae_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Laa Juan‑niga nuha uke xianiha. ¡Ko'o! Suna bitaba benneha kini utixxi'e ge benne anka xianiha, ");
INSERT INTO zae_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","delába xiani nu gwalíga udanie ge iyá ka benne ki tte dákanie nuxa anka Tata Do Yebáha. Benne anka xianiha, benneha nuha chi bisiabie yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Chiba do benneha yiesi lo yu‑ni nna labie bixuin Tata Do Yebáha kini benie yiesi lo yu‑ni, ttaka ka benne se'e yiesi lo yu‑ni labí chi ankabiakanie benneha. ");
INSERT INTO zae_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Len ka benne geeha‑ba bisiabie, ttaka ka benne geeha nna labí belabike bie. ");
INSERT INTO zae_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ttaka iyába ka benne belabike bie lhe gwa ugía leke gebie lhe, ka benneha nuha begwebie ke lo neda kini akake xi'in Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ka benneha bisinke ukake xi'in Tata Do Yebáha, labí aníha chi ankake tti ulikeha, nigaba kumu de aníha uka le ka benne se'e yiesi lo yu‑ni akake, sinuki kumu Tata Do Yebáha‑ba bedá lebie ukake xi'inie. ");
INSERT INTO zae_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Benne anke tisaha beyake ttu benne attiba ri'i nna udoe lenri'i. Uka xxatte benne si'i lasi lhe bele'ebie nu anka gwalí lhe. Ri'i bilenri'i nu xxeni ra leeha, delába nu xxeni ra lebie nu bete Tata geeha kumu de anke Xi'in ttu túbiru ge benneha. ");
INSERT INTO zae_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan‑ni nna utixxi'ana ge benne anke tisaha lhe unnena idisa, rana: ―Ge benne‑ni nuha rinnea tti ria: “Benne delola dabie danalhe netiha, benneha xxenirula ra lebie tti neti, kumu benneha chila doe tti neti.” ");
INSERT INTO zae_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kumu de labie anke benne tee iyá nu tse gebie, de nuha nna iyábari'i redí baari'i nu tse geeha, nu labí rudú siie rutebie geri'i. ");
INSERT INTO zae_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kumu bia bennabi bete Tata Do Yebáha lenri'i, lasi ná Moisés‑niba bodha'ane nuha, ttaka elha si'i lasi geeha lhe nu anka gwalíha lhe, Jesucristuha‑ba bele'enie ri'i nuha. ");
INSERT INTO zae_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tata Do Yebáha lanú nu chi bilenna benneha. Sunruba benne anke ttu túbiru Xi'inieha, delába benne due lenieha, benneha‑ruba nuha chi bele'enie ri'i Tata geeha. ");
INSERT INTO zae_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Aní bekabi Juan‑ni ge ka bixxudiha lhe ge ka levita‑ni lhe. Ka nuná udákana lhe'esi Jerusalén‑ni, udhelha ka nu loni ge ka nu Israel‑ni kana kini ugíakana gwannaba tisakana Juan‑ni, rákane: ―Lu nna, ¿nú ankalu? ");
INSERT INTO zae_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Lee nna labí bedhea lebie, sinuki lhixxa rába utixxi'abie, ree: ―Neti labí ankaa Cristu benne chi ga'anani Tata Do Yebáha idhelhe. ");
INSERT INTO zae_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Lakana nna bedennaba tisakana, rákana: ―¿Núla ankalu ganna? ¿Si lu nuná Elías ak? Lee nna bekabie, ree: ―¡Labí neti! Nianna redeakane: ―¿Si lu nuná profeta benne chi ga'anna isiaha ak? Lee nna bedekabie ree: ―¡Labí neti! ");
INSERT INTO zae_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nianna rákane: ―¿Núla nuná ankalu ganna, kini anáchu ri'itu kixxi'entu ka benne udhelhake ri'ituha? Lu nna, ¿si lagwa gwagixxi'a gelu? ");
INSERT INTO zae_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan‑ni nna bekabie ree: ―Neti ankaa benne rekia lo yu bisiha, rinnea idisa attiba ra profeta Isaías‑ni: “Gwalolixxa neda kini dha benne anke Xxanari'iha.” ");
INSERT INTO zae_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ka nu ugía gwennaba tisaha selakana lhe'e ka nu tee lákani fariseo. ");
INSERT INTO zae_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nianna tti unnaba tisakane, rákane: ―Ki ganna labí ankalu Cristu lhe nigaba Elías lhe nigaba profeta nu chi ga'anna isiaha lhe, ¿beakala nna rugadilu ka benne inda ganna? ");
INSERT INTO zae_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan‑ni nna bekabie gekani, ree: ―Neti tti rugadia ka benne inda, suna indaba rixúti. Ttaka lagwi gebale reki ttu benne. Benneha labí ankabienlee. ");
INSERT INTO zae_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Labie nuha delola dabie danalhe neti. Benneha labí elha ralhaa idhasia lo ka gwaracha geeha. ");
INSERT INTO zae_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Iyá nuní uka lhe'esi Betania daka attu ladu yoo Jordán ata reki Juan‑ni rugadie ka benne inda. ");
INSERT INTO zae_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Utteyú dilaha bilani Juan‑ni Jesús‑ni dabie ata dueha, nianna tti ree: ―Ne benne anka neru to udhelha Tata Do Yebáha chi daa naa kini kuabie ka tulha ge ka benne se'e yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ge benne‑ni nuha rinnea, tti ria: “Benne dabie delola danalhane netiha, benneha xxeniru ra lebie tti neti, kumu chila do benneha tti neti.” ");
INSERT INTO zae_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nigaba neti ttuha labí chi yua nuxa anke, ttaka daya rugadia ka benne leni inda kini anáchu ka benne Israel‑ni nna uinbiake bie. ");
INSERT INTO zae_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Rigixxi'agaba Juan‑ni ree: ―Biláti Espíritu ge Tata Do Yebáha ugwadie dabie yebáha attiba radi ttu becha, bisiabie betedhobie ikie. ");
INSERT INTO zae_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Neti ttuha labí chi yua nuxa anke, ttaka Tata Do Yebáha benne udhelhe neti kini ugadia ka benne leni inda, benneha ree neti: “Benne ilenlu chadi Espíritu kia‑ni nna etedhobie ikie, benneha nuha ugadie ka benne Espíritu kiaha.” ");
INSERT INTO zae_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Neti chi bilátie nna rigixxi'aya deki labie anke Xi'in Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Beyeki sáha nna dedhú Juan‑ni niha attu libe len chupa ka benne rudhetinieha. ");
INSERT INTO zae_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tti bilánie Jesús‑ni rekie niha, nianna ree: ―¡Ne benne anke neru to udhelha Tata Do Yebáha reki naa! ");
INSERT INTO zae_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tti biyienin ixpa ka benne rudhetinieha nu reeha, nianna tti diake danalhake Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tti bodeki lo Jesús‑ni nna bilánie danalhake bie, nianna ree ke: ―¿Bí regilale? Lake nna bekabike, ráke bie: ―Rabí, ¿gála reya'anlu? (“Rabí” dienna innána maestru.) ");
INSERT INTO zae_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Labie nna ree ka benneha: ―Gwaltá gwalulanni. Nianna ugíake gwalannike ata doeha. Kumu chiba anka ttiba retin ttapa nuha, laxkala niha‑ba use'eke lenbie axtaba ulha sáha. ");
INSERT INTO zae_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Benne labie Andrés betsi Simón Pedro‑ni, delo chupake biyienkanie nu ra Juan‑ni, benneha nuha ugíabie gwanalhe Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés‑ni nuha lade'a tte gwatilee betsie Pedro‑ni, nna ree benneha: ―Chi gwaxxakatu Mesías‑ni. (“Mesías” dienna innána Cristu benne chi ga'anani Tata Do Yebáha idhelhe.) ");
INSERT INTO zae_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nianna tti chebie Simón‑ni ata du Jesús‑ni. Tti bilani Jesús‑ni Simón‑ni, nianna rabie na: ―Lu lálu Simón xi'in Jonás, ttaka nnanna eyatta lálu Cefas. (“Cefas” dienna innána Pedro.) ");
INSERT INTO zae_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Beyeki sáha bebeki le Jesús‑ni tsiabie daka Galilea, nianna beti'e Felipe‑ni nna ree benneha: ―Utá, betenalha neti. ");
INSERT INTO zae_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe‑ni anke benne lhe'esi Betsaida, delába lhe'esi ge Andrés‑ni lhe ge Pedro‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe‑ni nna beti'ana attu benne lábie Natanael nna rana benneha: ―Chi gwaxxakatu Jesús ge Nazaret‑ni, xi'in biyú José‑ni. Ge Jesús‑ni nuha unne Moisés‑ni lo bia bennabiha lhe ge benne‑nigaba nuha unne ka profeta ge Tata Do Yebáha lhe. ");
INSERT INTO zae_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nianna ra Natanael‑ni Felipe‑ni: ―¿Lhe'esi Nazaret‑ni, si gwaria tsa ttu benne unie ttu nu tse? Nianna ra Felipe‑ni benneha: ―Utáruga, belanni. ");
INSERT INTO zae_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tti bilani Jesús‑ni Natanael‑ni chi diabie ata dueha, nianna ree: ―Ne ttu benne gwalíga anke nu Israel daa nii, Benne‑ni labí gwen lasi rinnebie. ");
INSERT INTO zae_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael‑ni nna ree Jesús‑ni: ―¿Gála benbialu neti xa tata? Jesús‑ni nna bekabie gebie, ree: ―Attili lani gaxi Felipe‑na lu, neti chila biláti lu tti relu xan ya higuha. ");
INSERT INTO zae_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael‑ni nna ree Jesús‑ni: ―Maestru, lúligaba ankalu Xi'ini Tata Do Yebáha lhe lu ankalu benne rinnabialu ka benne Israel‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús‑ni nna bekabie ree Natanael‑ni: ―¿Si de xpeya lu chi biláti lu relu xan ya higuha, si de nuha nna ria lelu kia? Adírula xxeni anka ka nu si ilenlu tti ka nuní. ");
INSERT INTO zae_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Lhe rágaba Jesús‑ni: ―Netiru ria, debá nnanna lhe nu si daa lhe ilenle iyali yebáha nna ilágabinle ka anjeli ge Tata Do Yebáha tsapi chadike xaliekia, neti benne daya yebáha. ");
INSERT INTO zae_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Beyonna ubisaha nna utta ttu dha'a lhe'esi Caná ge Galilea‑ni. Niha‑gaba du nan ge Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Biyaxigaba Jesús‑ni lenie ka benne rudhetinieha tse'eke dha'aha. ");
INSERT INTO zae_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tti chi bebisi vinuha, nianna ra nan geeha bie: ―Birua vinu tee. ");
INSERT INTO zae_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús‑ni nna bekabie, ree: ―Nana, ¿beaka netila ralu nuná? Neti labí chi bisia ura kia. ");
INSERT INTO zae_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nan geeha nna rabie ka nu se'e gwexxua ya kwe'eha: ―¡Gwaluni iyába nu innábi! ");
INSERT INTO zae_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Niha se'e xxupa ka re'e ankakana ge íyya. Rita'a inda lhe'ekani. Lhe'e ttu ttu ka nuha rita'a ttiba ttu gayua (100) litru inda. Ka nuha rixúni ka benne Israel‑ni ki riga'ake inda lhe'ekani tti reyarike arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús‑ni nna rabie ka nu se'e gwexxua ya kwe'eha: ―Gwalodisá ka re'e‑na inda. Ka nuha nna bodisá tíbakana ka re'eha inda, ");
INSERT INTO zae_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","nianna tti ra Jesús‑ni kana: ―Nnanna nna gwalika'a latti nuná nna gwatagwe benne bananie dha'a‑ni. Nianna denkana nuha nna begwekana benneha. ");
INSERT INTO zae_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Benne bananie dha'aha, kumu labí yue gaxa gwaxxíkana vinuha, sunruba ka nu se'e gwexxua ya kwe'eha yúkana, kumu de lakana gwattekana indaha, laxkala tti bennixxie inda chi beyaka vinuha, nianna tti uxie nubiyú rutsá nániha ");
INSERT INTO zae_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nna ree na: ―Iyába ka nu runi ttu dha'a, lade'axa ruga'akana vinu tseru nna iki deliba ganna chi u'uya xxatta ka benne yu'u dha'aha nuha, la'anialiba nna chi ruga'akana vinu nu labí tte anka tse. Lu nna nnannaliba ruga'alu vinu tseru‑ni. ");
INSERT INTO zae_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nuní sisi'a tte milagru ben Jesús‑ni lhe'esi Caná ge Galilea. Len nu benieha bele'ebie nu xxeni ra lebie. Ka benne rudhetinieha nna ugía leke gebie. ");
INSERT INTO zae_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Iki de nuha nna ugwadie die lhe'esi Capernaum lenie nan geeha lhe ka betsieha lhe ka benne rudhetinieha lhe. Niha use'eke sunruba ttu chupa ubisa. ");
INSERT INTO zae_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kumu de chi dabigana isia laní ge ka benne Israel‑ni nu tee láni Pascua, Jesús‑ni nna ugwapie die lhe'esi Jerusalén‑ni. ");
INSERT INTO zae_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Lali'a yotuha gwaxxake ka nu rutto'okana ka ku'una lhe ka neru lhe ka becha lhe. Anágaba ka nu rotsea belhiu lhe, niha‑gaba se'ekana. ");
INSERT INTO zae_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nianna tti bilhe ttu tuu. Len nuha bochesue kana ro'o yotuha itupa lenkana ka neruha lhe ka ku'una rutto'okanaha, nna ka nu rotsea belhuha nna bedhíe belhiu gekaniha lo yu nna berixxi lobie ka mexa gekaniha. ");
INSERT INTO zae_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nianna rabie ka nu rutto'o ka bechaha: ―Gwalebea ka nuná nii nna bittu uinle lisi Tata kia‑ni yo'o ata raka i'iya. ");
INSERT INTO zae_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ka benne rudhetinieha nna gwadú tteba leke nu ra lo ka yetsi ge Tata Do Yebáha ata dia ra: “De raka xxattati ge lisilu‑ni, de nuha nna ruyú xxattaa elha disa.” ");
INSERT INTO zae_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ka nu loni ge ka benne Israel‑ni nna rákane: ―Lu, ¿bíla ttu seña ule'elu kini ula'a deki gwalí rapalu lo neda uinlu nu ruinlu‑ni? ");
INSERT INTO zae_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús‑ni nna bekabie gekani, ree: ―Gwaluttampa yotu‑ni nna delo tsunna ubisaba chi elhidhaa na. ");
INSERT INTO zae_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ka nu loni ge ka benne Israel‑ni nna rákane: ―Chua bixxi xxupa (46) ida bisá ka benne ulhidhake yotu‑ni, lu nna delo tsunna ubisaba ralu chi elhidhalu nuní. ");
INSERT INTO zae_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ttaka Jesús‑ni laa gwalíga ge yotuha nuha rinnebie, sinuki gebe nuha rinnebie. ");
INSERT INTO zae_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iki deliba chi beyaka benbie lagwi ge ka benne chi uttiha, la'anialiba nna gwadú le ka benne rudhetinieha deki chiba unnebie ge nuha, nianna tti ugía leke ge nu ra lo ka yetsi ge Tata Do Yebáha lhe ugíagaba leke ge nu ra Jesús‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Laka reki Jesús‑ni lhe'esi Jerusalén‑ni tti raka laní Pascuaha, ixe ka benne ugía leke gebie de bilákanie ka milagru runieha. ");
INSERT INTO zae_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ttaka kwinaba Jesús‑ni labí ruxxen lebie geke, kumu chiba yue gasina ruin iyáke. ");
INSERT INTO zae_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Labie labí riyasanie nuxa kixxi'ane gaxasina ruin ka benne se'e yiesi lo yu‑ni kumu chiba yue gasina anka lhe'e lastoke. ");
INSERT INTO zae_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Udo ttu benne la'ania anke fariseo, lábie Nicodemo. Uke ttu nu loni ge ka benne Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Benneha ugíabie ttu lo rela gwalannie Jesús‑ni nna ree benneha: ―Maestru, ri'itu yutu deki Tata Do Yebáha‑ba udhelhe lu kini ule'enlu ri'itu, kumu lanú ttu benne gwaka gebie unie ka milagru ruinlu‑na ganna abíba du Tata Do Yebáha lenbie. ");
INSERT INTO zae_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús‑ni nna bekabie ge benneha, ree: ―Netiru ria, benne abíba eyalie attu libe eyake benne kubi, benneha labí dhaabie isine ake benne innabia Tata Do Yebáha bie. ");
INSERT INTO zae_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo‑ni nna ree Jesús‑ni: ―¿Gasina aka ge ttu benne chi anke yaxxu eyalie attu libe? ¿Si gwakaba ge benneha eta'abie lhe'e nan geeha nna eyalie attu libe? ");
INSERT INTO zae_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús‑ni nna bekabie ree: ―Netiru ria, benne abíba eyalie len inda lhe eyalie len Espíritu ge Tata Do Yebáha lhe, benneha labí aka isine ake benne innabia Tata Do Yebáha bie. ");
INSERT INTO zae_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kumu ttu benne ralie lhe'e xxudi ixnábie, xi'in ka benne se'e yiesi lo yu‑niba anka benneha, nna benne ake xi'in Tata Do Yebáha nna Espíritu ge Tata Do Yebáha‑ba unie kini ake xi'inie. ");
INSERT INTO zae_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Laxkala bittu aka tenlu de ria: “Raka doelha eyali ka benne attu libe.” ");
INSERT INTO zae_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ttibanka be‑na, gatti laduba dana, gwa riyienibinlu tsi'ini, ttaka labí yulu gá udána dana lhe gá diana lhe. Aníha‑gaba runi Espíritu ge Tata Do Yebáha lhe'e lasto ka benne chi beyalike attu libe. ");
INSERT INTO zae_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo‑ni nna bekabie, ree: ―¿Gasina aka nu ralu‑na? ");
INSERT INTO zae_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús‑ni nna bekabie ge benneha, ree: ―Ki lu ankalalu maestru ge ka nu Israel‑ni nna a rite denlu nu ria‑ni. ");
INSERT INTO zae_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Netiru ria, ri'itu rinnebatu ge nu chi yutu lhe rigixxi'abatu ge nu chi bilentu lhe, ttaka lebi'i labí ria lele ge nu rigixxi'atu‑ni. ");
INSERT INTO zae_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ki nu anka ge yiesi lo yu‑ni rigixxi'aya nna a ria lele, ¿titiala ganna ttixka kixxi'ania le nu anka ge yebáha? ");
INSERT INTO zae_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Lanú nu chi ugwapina yebáha, sunruba neti benne daya yebáha ugwadia niha nna bisiaya nii. ");
INSERT INTO zae_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ttigaba ben Moisés‑ni lo yu bisiha ulhidhana belhaha bedána nuha gwetsá, anágaba neti benne daya yebáha teeki ilhidhakana neti nna utákana gwetsá, ");
INSERT INTO zae_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kini anáchu iyába ka benne tsia leke neti, abittu tsia nnittike, sinuki satíaba aka benke arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Kumu de yalhá ukani Tata Do Yebáha ge ka benne se'e yiesi lo yu‑ni, de nuha nna udhelhe neti benne ankaa Xi'in ttu túbiru geeha, kini anáchu iyába ka benne tsia leke neti nna abittu tsia nnittike, sinuki satíaba aka benke arloe. ");
INSERT INTO zae_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kumu Tata Do Yebáha laa udhelhage neti benne ankaa Xi'inie, laa udhelhage neti yiesi lo yu‑ni kini ukinnia ka benne, sinuki udhelhalee neti kini odiláya ke. ");
INSERT INTO zae_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Laxkala benne tsia lebie kia, labí urixxi ukinni Tata Do Yebáha benneha, ttaka benne abíba tsia lebie kia, chiba ubixxi biginni benneha kumu de labí ugía lebie neti benne ankaa Xi'in ttu túbiru ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ka nu labí ria lekaniha ibixxi iginniba ka nuha, kumu neti benne ankaa xianiha gwa bisiabaa yiesi lo yu‑ni, ttaka lakana nna adírula ute lekani chulhaha attichula xianiha kumu de satsaba anka nu ruinkana. ");
INSERT INTO zae_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kumu iyába ka nu runi nu satsa, labí raka uyúkana xianiha, labí ribigakana ata ruden nuha, kini abittu ilá nu ruinkanaha nna itisakana. ");
INSERT INTO zae_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ttaka benne gwa ruinbe nu raxxína len nu anka gwalí, gwa ribigaba benneha ata rudani xianiha, kini ilá deki nu runieha gwankaba nuha nu ru'u le Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Iki de nuha nna ugía Jesús‑ni lenbie ka benne rudhetinieha isá to daka Judea. Niha‑ba ugweki lenie ke nna rugadie ka benne inda. ");
INSERT INTO zae_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Anágaba Juan‑ni rugadigabe ka benne inda daka Enón kumu niha yu'u idila inda. Enón rena gaxxaba Salim. Niha risin ka benne ki radike inda. ");
INSERT INTO zae_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kumu Juan‑ni labí chi tena lisiyya la'ania. ");
INSERT INTO zae_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ka benne rudhetini Juan‑ni, ttu lidú belisa luesike len ka benne Israel‑ni. Belisa luesike delo ni'a ge gasina eyari ka benne kini eyakake nari xú arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nianna tti bisinke ata du Juan‑ni nna ráke benneha: ―Maestru, biyúruga. Nu du lenlu daka ro'o yoo Jordán‑ni, nu utixxi'agabinlu ri'itu geniha, nnanna nuha chigaba rugadina ka benne inda nna iyábake diake danalhake na. ");
INSERT INTO zae_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan‑ni nna bekabie ge ka benneha, ree: ―Labí aka ge ttu benne unie ttu bixa ganna abíba ute ná Tata Do Yebáha lenbie. ");
INSERT INTO zae_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ki kwinaba lebi'i biyienin nagale ge nu xpeya le deki neti labí ankaa Cristu, sinuki sun tteruba ankaa ttu benne udhelha Tata Do Yebáha kini danerua rigixxi'aya deki chi daa benneha. ");
INSERT INTO zae_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ttibanka lo ttu dha'a, nubiyú rutsá nániha, gebani anka nuila rutsá ná lennaha nna benne anka amigu ge nubiyú rutsá nániha, benneha dubie gaxxaba kwe'eni nna yalhá redeakanie tti riyieninie rinne nubiyúha. Neti nuha ankaa amigu ge nubiyú rutsá nániha, laxkala nnanna itta suba edú lasia. ");
INSERT INTO zae_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Benne rutsá neeha rakaru doelha tsie ake xxeniru, neti nna exxa gaalaa. ");
INSERT INTO zae_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Benne daa gwetsáha, benneha nuha ankarue xxeni delo iyá ka benne. Benne anka ge yiesi lo yu‑ni nna ge yiesi lo yu‑niba anka benneha nna nu anka ge yiesi lo yu‑niba rinne benneha. Benne daa yebáha nna benneha nuha ankarue xxeni delo iyá ka benne. ");
INSERT INTO zae_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ge nu bilábanie lhe ge nu biyienbanie rigixxi'abie, ttaka ni ttú ka benne a ria leke ge nu rigixxi'a benneha. ");
INSERT INTO zae_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ttaka nu gwa ria leni ge benneha, lana nuha rigixxi'iana deki Tata Do Yebáha rinne nu anka gwalí. ");
INSERT INTO zae_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kumu benne udhelha Tata Do Yebáha, ka tisa geeha‑ba rinne benneha kumu Tata Do Yebáha rute tame itú Espíritu geeha len benneha. ");
INSERT INTO zae_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tataha rakanie ge Xi'inieha, laxkala iyába chi bedha'ane lasi ná benneha. ");
INSERT INTO zae_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Laxkala benne tsia lebie ge Xi'in Tata Do Yebáha, gwaka benba benneha ttu dia lii arlo Tata Do Yebáha, nna nu abittu tsia leni ge Xi'inieha labí aka ben nuha ttu dia lii, sinuki ralhaba nuha dhina elha disa ute Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tti bina Jesús‑ni deki ka fariseo‑ni chi biyienkinna ra ka benne: “Jesús‑ni raxirue ixe ka benne ki sanalhake bie lhe rugadirue ixe ka benne inda tti Juan‑ni” ");
INSERT INTO zae_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(meskiba laa Jesús‑ni nuha rugadie ka benneha inda, ka benne rudhetinieha‑ba rugadike ka benneha inda), ");
INSERT INTO zae_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","tti bina Jesús‑ni nu chi biyienkin fariseo‑ni, nianna bedábie daka Judea nna besine daka Galilea attu libe. ");
INSERT INTO zae_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tti deyyeha nna teeki betebie daka Samaria ");
INSERT INTO zae_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","nna besine lhe'e ttu yiesi ge niha. Yiesiha tee láni Sicar. Rena gaxxaba ata tee ttu lo yu nu boka'an Jacob‑ni xi'in biyúni José‑ni. ");
INSERT INTO zae_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Niha re yiela inda tee láni Yiela Ge Jacob. Jesús‑ni nna de chi resanie deyu'e neda, de nuha nna besine ro'o yielaha nna ure ttebe. Ttiba retin tsi'inu (12) nuha chi anka la'ania. ");
INSERT INTO zae_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Niha bisin ttu nuila ge Samaria daa nuha uxí inda. Jesús‑ni nna ree nuilaha: ―Betetti inda i'iyaa. ");
INSERT INTO zae_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ka benne rudhetinieha nna si diala ka benneha lhe'esiha ugo'o nu goke. ");
INSERT INTO zae_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nuila ge Samaria‑ni nna rane: ―¿Gasina nna rinnabalu neti inda, ki lu benne Israel‑ba ankalu, neti nna benne Samariaba neti? Aníha rana kumu ka benne Israel‑ni lhe ka benne Samaria‑ni lhe, labí rutsá luesi ka benneha. ");
INSERT INTO zae_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús‑ni nna bekabie ge nuilaha, ree: ―Ganna ttixka lu yulu nu tse rute Tata Do Yebáha lhe ganna ttixka yulu nú benne nuní rabie lu: “Betetti inda i'iyaa”, la'ania nna gwannabalalu inda lenie, labie nna gutelee inda nu unna elha nabani gelu. ");
INSERT INTO zae_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nuilaha nna rane: ―Ki bigaba bi denlu ki kwealu inda‑ni xa tata. Yiela‑ni yalhá lhi'u dia nuní. ¿Gála salhealu inda nu unnana elha nabani ganna? ");
INSERT INTO zae_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Si xxenirula ra lelu tti benneola geri'i Jacob‑ni? Benneha bodha'ane yiela‑ni geri'i. Lhe'e yiela‑ni u'uye inda lhe u'uya ka xi'inieha lhe u'uya ka ku'una bia geeha lhe. ");
INSERT INTO zae_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús‑ni nna bekabie geni, ree: ―Nuxaba benne ganna i'iye inda ge yiela‑ni ebisiba benneha inda attu libe, ");
INSERT INTO zae_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ttaka benne i'iye inda utea‑ni, ni tsa labíru ebisi benneha inda attu libe; kumu inda utea‑ni akana ttiba ttu dina satíaba dhona lhe'e lastoe nna nuha uinna kini satíaba aka benbie arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nuilaha nna rane: ―Tata xisi to, bete luesi inda ralu‑na i'iyaa, kini abitturu ebisia inda lhe kini abitturu itaa nii ubea inda lhe. ");
INSERT INTO zae_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús‑ni nna rabie nuilaha: ―Beyya nna gwalisa nubiyú geluha nna utá lenna. ");
INSERT INTO zae_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nuilaha nna bekabina gebie, rane: ―Lanú nubiyú ki neti do. Jesús‑ni nna rabie na: ―Gwalíbinlu ralu: “Lanú nubiyú ki neti do.” ");
INSERT INTO zae_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kumu gayu ka nubiyú chi udo lenlu nna nu do lenlu nnanna, labí chi anka nuná nubiyú gelu. Gwalíbinlu nu ralu‑na. ");
INSERT INTO zae_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nuilaha nna rane: ―Neti rakati profetaba ankalu xa tata. ");
INSERT INTO zae_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ka benne uka xuttotuha, iki i'iya‑niba bitake bedú xibike arlo Tata Do Yebáha. Lebi'i ka benne Israel nna rale lhe'esi Jerusalén‑niliba teeki udú xibi ka benne arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús‑ni nna bekabie geni, ree: ―Ugía lelu kia xa nuila. Isia sá gaxaba se'ele udú xibile arlo Tataha. Labíru raka doelha itale iki i'iya‑ni, nigaba tsiale Jerusalén‑ni ki udú xibile arloe. ");
INSERT INTO zae_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Lebi'i labí yule núnna rudú xibile arloni, ri'itu nna gwa yutu nú arlo rudú xibitu. Kumu ri'itu ka benne Israel‑ni, lagwi getu iria benne odilábie ka benne ki esinke len Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ttaka gwasia ura, nnanna nuha chi bisia uraha, ka benne ka nu gwalíga ankake ka nu rudú xibike arlo Tataha, ka benneha nuha gwalíga udú xibike arloe tti tte ra Espíritu geeha, kumu Tataha luesi ka benneha rigile ki udú xibike arloe. ");
INSERT INTO zae_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tata Do Yebáha anke Espíritu, delába anke benne labí rilenri'e, laxkala ka benne rudú xibike arlobie, teeki uinke nuha gwalíga tti tte ra Espíritu geeha. ");
INSERT INTO zae_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nianna ra nuilaha Jesús‑ni: ―Neti gwa yubaa deki isia Mesías, delába benne anke Cristuha. Ganna chi isia benneha, la'ania nna kixxi'anie ri'i iyá tte. ");
INSERT INTO zae_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús‑ni nna rabie na: ―Neti nuní ankaa benneha xa, delába benne rinne lenlu‑ni. ");
INSERT INTO zae_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nuha‑ba raka nna chi besia ka benne rudhetinieha nna bebanabakanie tti bilákanie rinne lanie nuilaha; ttaka nna ni ttúke labí unnaba tisake innáke: “¿Bíunna rinnaba tisalu nuila‑na?” o, “¿bí ge nuná rinne lenlu nuná?” ");
INSERT INTO zae_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nuilaha nna bedú bixxibana re'e geniha nna deyyana lhe'esiha, gwagunana ka benne, rana ke: ");
INSERT INTO zae_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―¡Gwaltáruga, gwalulanni ttu nubiyú chi utixxi'ana ge iyába nu chi benia! ¿Si laaba nubiyúha‑ba nuha anka Cristu benne chi ga'anani Tata Do Yebáha idhelhe? ");
INSERT INTO zae_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nianna tti biria tteba ka benne lhe'esiha nna bisinke ata du Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Laka raka nuha nna ka benne rudhetini Jesús‑ni nna ráke bie: ―Uto yetta xa maestru. ");
INSERT INTO zae_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ttaka labie nna rabie ke: ―Neti teela ttu elho kia goa, lebi'i labí yule bixa elho nuha. ");
INSERT INTO zae_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nianna tti ra luesi ka benne rudhetinieha: ―¿Si nuxa chi betedha'ana nu gobie ak? ");
INSERT INTO zae_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús‑ni nna rabie ka benneha: ―Elho kia ankana, unia nu raka le benne udhelhe netiha nna ulhuxaa sina geeha. ");
INSERT INTO zae_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Laaba lebi'i rale: “Sa riyasaba ttapa beo tti isia gwetselaha”? Neti ria le: Gwalodeki lole nna gwalulanni ka xuxtila se'e naa. Chiba rigatsi ka nuná ki eyatsakana. ");
INSERT INTO zae_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ttu benne riben gwetsela ridíba lhiaxa benneha, nna lena ruttupeha nna ankana ka benne raxie lo neda ge Tata Do Yebáha kini satíaba aka benke, kini anáchu benne rudelhe xuaha lhe benne rottupe benneha lhe, ixpabake tse'e ittake ge sina benkeha. ");
INSERT INTO zae_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nii rado tisa ge nu rari'i: Ttu benne subi rudelhe xuaha nna attu benne subila redíe benneha. ");
INSERT INTO zae_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Neti ridhelhaa le kini egitsale xua bedelha ka benne subi, nu labí gwatele bedelhale. Nnanna nna lebi'ila chi redí baale ge sina ben ka benneha. ");
INSERT INTO zae_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ixe ka benne lhe'esi Sicar, (Sicar babana Samaria), ixe ka benneha ugía leke ge Jesús‑ni de nu utixxi'en nuilaha ke tti rana: “Benne‑ni chi utixxi'e ge iyá nu chi benia.” ");
INSERT INTO zae_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Laxkala tti chi bisin ka benneha ata du Jesús‑ni nna unnabake lenie, ráke bie: ―¡Ga innálu beya'anchi len ri'itu! Nianna beya'ane udoe lenke chupa ubisa ");
INSERT INTO zae_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","nna adírula ixe ka benne ugía leke tti biyienkanie nu ra kwinaga labie. ");
INSERT INTO zae_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nianna tti ráke nuilaha: ―A laa suna ge nu utixxi'enlu ri'ituha‑ruga ria letu, nnanna chi ria letu kumu kwinaga ri'itu chi biyienintu nu rinne benne‑ni. De nuha nna chi yutu deki gwalíga benne‑ni anke Cristu; labie odilábie ka benne se'e yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iki de chi gwadona chupa ubisaha, biria Jesús‑ni lo yu ge Samaria‑ni nna die daka Galilea, ");
INSERT INTO zae_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","kumu kwinaba labie ree deki ttu benne anke profeta, labí rugwekana lidhaka benneha lhe'esi gebie. ");
INSERT INTO zae_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tti besine daka Galilea, tseba belabi ka benne Galilea‑nie kumu de chiba bilákanie iyá nu benie lhe'esi Jerusalén‑ni tti raka laní Pascuaha, kumu ka benneha ugíagabake laníha. ");
INSERT INTO zae_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nianna beyeki Jesús‑ni attu libe lhe'esi Caná. Yiesiha rena daka Galilea ata beyonie indaha vinu. Lhe'esi Capernaum‑ni do ttu nu rinnabia nu duna kwe'e nu rinnabia xeniha. Nuha do ttu xi'in biyúni ranina. ");
INSERT INTO zae_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tti bina nuha deki chi bedá Jesús‑ni daka Judea‑ni nna besiabie daka Galilea, nianna tti ugíana nna gwannabana lenie, rane: ―¡Utáchi xa tata, ki eyoinlu nu kwiti kiaha. Bichisilá chi tteba gattibi! ");
INSERT INTO zae_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús‑ni nna bekabie geni, ree: ―Lebi'i labí tsia lele ganna abíba ilenle aka ka milagru lhe ka nu dika ebaninle geni lhe. ");
INSERT INTO zae_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ttaka nubiyúha nna rane: ―Tata xisi to, uyáxxiruga ttiru lani gatti nu kwiti kiaha. ");
INSERT INTO zae_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús‑ni nna ree na: ―Beyya lisiluha. Xi'in biyúluha chiba beyaka nuha. Nubiyúha nna gwa ugíaba leni ge nu ra Jesús‑ni na, nianna deyya ttebana. ");
INSERT INTO zae_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tti chi deyyana esinna lisiniha nna biria ka nu riben sina lhe'e yo'o geniha nna gwatsákana na, nianna rákana na: ―Gwanka benba nu kwiti geluha. ");
INSERT INTO zae_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nianna tti unnaba tisana ka nuha, rana kana: ―¿Bí ura beyaka nu kwiti kiaha? Ka nuha nna rákana na: ―Nnayaha ttiba retin ttú beria xilháha latibi. ");
INSERT INTO zae_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Niala nna tti gwadú le xxudi nu kwitiha deki uraha‑gaba nuha tti ra Jesús‑ni na: “Chiba beyaka xi'in biyúluha”, nianna tti ugía leni ge Jesús‑ni lhe ugíagaba le iyába ka benne se'e lhe'e lisiniha lhe. ");
INSERT INTO zae_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nuní berupa milagru ben Jesús‑ni iki de chi bedábie daka Judea‑ni nna besine daka Galilea‑ni. ");
INSERT INTO zae_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Iki de nuha nna bisia ttu laní ge ka benne Israel‑ni. Jesús‑ni nna ugwapie die lhe'esi Jerusalén‑ni. ");
INSERT INTO zae_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Lhe'esi Jerusalén‑ni, niha du puerta nu tee láni Puerta Ge Ka Neru. Gaxxaba niha re ttu yiela inda. Len tisa hebreo tee láni Betesda. Abi'iba ro'o yielaha rilhi ttu kweredori sia gayu ro'oni ata ra'a ka benne. ");
INSERT INTO zae_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Lhe'e kweredoriha ratta ixeru ka benne rani, ka benne lo xua lhe ka benne ridá natsa lhe ka benne daa yatti latike lhe, ribedake kini itá lo yiela indaha, ");
INSERT INTO zae_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kumu ttu anjeli ge Tata Do Yebáha, gwadú gwadú riginnie lhe'e yielaha nna ruttábie lo indaha, nna benne gwa riyúbanie riginnie lhe'e indaha, iki de chi reyaka ritá lo nuha, benneha nna reyaka ttebe ge bixaba isagwe ridake. ");
INSERT INTO zae_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Niha‑gaba tee ttu benne biyú ranie. Chiba uka rerua bixxi xxunu (38) ida ranie. ");
INSERT INTO zae_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tti bilani Jesús‑ni benneha tebie niha lhe bine deki isába chi ridake nuha, nianna tti rabie benneha: ―¿Si raka lelu eyakalu? ");
INSERT INTO zae_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Benne raniha nna bekabie ge Jesús‑ni, ree: ―Lanú tee uga'ana neti lhe'e yiela‑ni tti ritá loni xa tata. Kua ruinbaa ga'aya nna attu benne subila chi riyúbanie rixudie lade'a tte tti neti. ");
INSERT INTO zae_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús‑ni nna rabie benneha: ―Beyadha nna belhidha nu xualu loin‑na nna udá. ");
INSERT INTO zae_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Looraha nna beyaka tteba benne raniha. Nianna bodaxxu ttebe nu xue loniha nna uduloe udee. La sáha anka sá tti reyaka le ka benne Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ka nu loni ge ka benne Israel‑ni nna rákana benne beyakaha: ―Ki gwa yúbalu nasá anka sá reyaka leri'i. Labí aka eyojalu nu uttalu loin‑na. ");
INSERT INTO zae_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Benne biyúha nna bekabie gekani, ree: ―Benne beyonie netiha, kwinaba benneha rabie neti: “Belhidha nu xualu loin‑na nna udá.” ");
INSERT INTO zae_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nianna unnaba tisakana benneha, rákane: ―¿Núnna rana lu: “Belhidha nu xualu loin‑na nna udá”? ");
INSERT INTO zae_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ttaka benne beyakaha nna labí yue nuxa benne nuha rabie bie aníha, kumu Jesús‑ni chiba biganna lokanie lagwi ge ka benne saa niha. ");
INSERT INTO zae_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Delola nna beti'a Jesús‑ni benne beyakaha ro'o yotuha nna ree bie: ―Biyúruga chiba beyakalu. Bitturu uinlu tulha kini ka satelu ttu nu satsarula tti nu gwatelu‑na. ");
INSERT INTO zae_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Benne biyúha nna ugíe gwattixxi'anie ka nu loni ge ka benne Israel‑ni deki Jesús‑niba nuha beyonie bie. ");
INSERT INTO zae_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","De nuha nna ka nu loni ge ka benne Israel‑ni ridú nookana Jesús‑ni, ruinkana uttikane, kumu de runie ka milagru lhe'e ka sá reyaka lekaniha. ");
INSERT INTO zae_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ttaka Jesús‑ni nna ree: ―Tata kiaha satíaba riben benneha, de nuha nna neti ribengabaa. ");
INSERT INTO zae_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","De rabie aníha nna ka nu loni ge ka benne Israel‑ni adírula ruinkana uttikane, kumu laa sunruga rigu'u ni'e ka sá reyaka lekaniha, sinuki de rágabe deki Tata Do Yebáha‑ba anke Xxudie. Tti rabie aníha, runie deki turo'oba anke len Tata Do Yebáha. De nuha nna ruinkana uttikane. ");
INSERT INTO zae_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nianna bekabi Jesús‑ni ge ka nu loni ge ka benne Israel‑ni, rabie kana: ―Netiru ria, neti benne ankaa Xi'in Tata Do Yebáha labí aka unia nu yu'u ikia, sinuki ruinbaa nu rilábati ruin Tata kiaha. Kumu iyába nu ruin Tataha, aníha‑gaba neti benne ankaa Xi'inieha, aníha‑gaba runia. ");
INSERT INTO zae_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kumu Tataha rakanie kia, de nuha nna iyába nu runieha rule'enie neti nna adírula xxeni anka nu si ule'enie neti. Ule'ebie ttu nu dika ebaninle tti ilenle na. ");
INSERT INTO zae_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kumu ttiba ruin Tataha relhidhe ka benne chi uttiha nna runie kini reyaka benke arloe, anágaba neti benne ankaa Xi'inieha, ka benne aka lasia unia kini aka benke nna gwaka benbake. ");
INSERT INTO zae_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kumu Tataha lanú nu ruin benneha elhuxtisi geni, sinuki len neti benne ankaa Xi'inieha chi bodha'ane iyába lasi náya kini unia elhuxtisi ge ka benne, ");
INSERT INTO zae_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kini anáchu nna neti benne ankaa Xi'inieha, iyába ka benne ugweke lidhakaa ttigaba rugweke lidhaka Tataha nna nu abíba rugwena lidhakaa, labígaba rugwe nuha lidhaka Tataha benne udhelhe netiha. ");
INSERT INTO zae_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Netiru ria: Nu gwa rudo nagani ge nu rinnea‑ni lhe gwa ria leni Tata Do Yebaa benne udhelhe netiha, nuha satíaba aka benna arloe; labí ibixxi iginni nuha dhina elha disa, sinuki chiba ulhá nuha lo elhutti tee arlo Tata Do Yebáha nna isinna aka benna ttu dia lii. ");
INSERT INTO zae_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Netiru ria, chi isia ura, nnanna nuha chi bisia uraha, la'ania ka nu ankakana yatti arlo Tata Do Yebáha iyienkinna tsi'a, neti benne ankaa Xi'inieha nna ka benne gudo nagake kia, ka benneha nuha gwaka benke. ");
INSERT INTO zae_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kumu ttiba Tataha anke benne bani nna runie ki raka ben ka benne, anágaba neti benne ankaa Xi'inieha ankaa benne bani nna chi betebie lo neda kia kini unia ki aka ben ka benne, ");
INSERT INTO zae_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","lhe chigaba betebie lo neda len neti kini unia elhuxtisi ge ka benne kumu de ankaa benne daya yebáha. ");
INSERT INTO zae_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bittu aka tenle ge nu ria‑ni, kumu isiaba ura atti iyába ka benne tee lhe'e yieru baa iyienkanie tsi'a. ");
INSERT INTO zae_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ka benne ben tseha, eyadhake kini aka benke ttu dia lii nna ka nu ben nu satsaha nna eyadhakana kini iginnikana uyúkana elha disa. ");
INSERT INTO zae_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Neti labí aka kia unia nu yu'u ikia. Ruinbaa elhuxtisi ttiba ra Tataha unia nna elhuxtisi runia‑ni, ruinbaa na attiba ankaba geni, kumu labí runia nu raka lasia, sinuki ruinbaa nu raka le benne udhelhe netiha. ");
INSERT INTO zae_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","’Ganna si la netiba rigixxi'aya kia ge nuxa ankaa, la'ania nna nu rigixxi'ayaha labí daka nuha. ");
INSERT INTO zae_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ttaka kumu attu benne subiba rigixxi'e nuxa ankaa, de nuha nna chi yua deki nu rigixxi'a benneha kia, nu gwalíba anka nuha. ");
INSERT INTO zae_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Lebi'i tti udhelhale ka nu gwannaba tisakana kia len Juan‑ni, benneha nna gwa utixxi'abe ge nu ankaba gwalí. ");
INSERT INTO zae_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Neti laa de riyasagati nuxa attu benne kixxi'abie kia. ¡Ko'o! Suna rodhúbaa lele ge nu utixxi'a benneha kia kini anáchu nna lebi'i tsia lele nna odilá Tata Do Yebáha le. ");
INSERT INTO zae_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan‑ni uke ttiba ttu xiani bedenie gele. Lebi'i nna benle tse'e ittale lhe'e xiani geeha ttu satti to, delába bedeakinle ttu satti ge nu utixxi'eha. ");
INSERT INTO zae_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ttaka neti teela ttu nu rigixxi'a tseruna kia tti nu utixxi'a Juan‑ni, delába ka milagru bedha'an Tataha len neti ki unia. La ka nuha‑ba rigixxi'akana deki gwalíba labe udhelhe neti. ");
INSERT INTO zae_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Anágaba Tataha benne udhelhe netiha, chigaba utixxi'e nuxa ankaa, meskiba lebi'i labí chi biyieninle tsi'e lhe labí chi bilenlee lhe. ");
INSERT INTO zae_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nigaba a rulabile ka tisa geeha, kumu neti benne udhelheha labí ria lele kia. ");
INSERT INTO zae_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Lebi'i rudheti tsitsibale ka tisa dia lo ka yetsi ge Tata Do Yebáha kumu rakinle lo ka nuha saxxakale gasina aka benle ttu dia lii arloe. Gwalí galá lo ka yetsi geeha rigixxi'a kia, ");
INSERT INTO zae_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ttaka lebi'i nna labí raka lele ibigale len neti kini aka benle ttu dia lii. ");
INSERT INTO zae_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Neti labí runia kini inne tse ka benne kia. ");
INSERT INTO zae_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Anágaba nna chigaba ankabiati le deki labí rakinle ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Neti daya kwenta ge Tata kiaha; lebi'i nna a rulabile neti. Lala ganna attu nu subi dana kwenta geni, lala nuha nna gwa rulabibale na. ");
INSERT INTO zae_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Gágalo tsia lele kia? Kumu ki la lebi'iba rinne tse ge luesile nna labí ruinle ki Tata Do Yebaa benne anke ttu túbiru Diosiha, labí ruinle kini benneha inne tsebie gele. ");
INSERT INTO zae_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","’Labí akinle deki neti ukinnia le arlo Tata Do Yebáha. Moisés benne ruxxen lele geeha, benneha‑ba ukinnie le arloe. ");
INSERT INTO zae_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kumu gannala ttixka gwalíginle ria lele ge Moisés‑ni, la'ania nna gweyyala lele kia, kumu kia nuha utixxi'a Moisés‑ni lo ka yetsi benieha. ");
INSERT INTO zae_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ttaka ganna lebi'i abíba ria lele ge nu ben benneha lo ka yetsiha, ¿gasina tsia lele ge ka tisa rinnea‑ni? ");
INSERT INTO zae_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Iki de nuha nna tti dia Jesús‑ni daka attu ladu ro'o indatoo ge Galilea‑ni nu tegaba láni indatoo ge Tiberias, ");
INSERT INTO zae_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ixe ka benne danalhake bie kumu de chi bilákanie ixe ka milagru runie tti reyonie ka benne rani. ");
INSERT INTO zae_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nianna tti ugwapie iki ttu i'iya nna niha udobie lenie ka benne rudhetinieha. ");
INSERT INTO zae_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","La'ania nuha chi dabigana isia laní ge ka benne Israel‑ni nu tekanie láni Pascua. ");
INSERT INTO zae_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tti belhidha lo Jesús‑ni nna bilánie yalhá ixe ka benne chi danalhake bie, nianna rabie Felipe‑ni: ―¿Gála sayo'ori'i yettaxtila ki go iyá ka benne‑ni? ");
INSERT INTO zae_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","De lo tisaba unnebie aníha, kini lana nna bixa ekabina, kumu labie chiba yue bí unie. ");
INSERT INTO zae_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe‑ni nna bekabina gebie, rana: ―Ni len belhiu nu kixakana ri'i ge chupa gayua (200) ubisa sina, ni len nuha a dhaari'i go'ori'i yettaxtila ki go ka benne‑ni ttu ttuxka'a. ");
INSERT INTO zae_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ttu ka benne rudhetinieha, benne tee lábie Andrés betsi Simón‑ni, benneha rabie Jesús‑ni: ");
INSERT INTO zae_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ne ttu nu kwiti du nii denna gayu yettaxtila ge xua cebada nna a chupa ka belha nna, ttaka bi ixú nuní ki go iyá ka benne tupa‑ni. ");
INSERT INTO zae_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nianna tti ra Jesús‑ni ke: ―Gwaligasi ka benne‑na ese'eke. Nianna bese'e tteba ka benneha kumu yalhá ixxi binni tee niha. Sunrula ka benne biyúha ankake ttiba tu gayu mili. ");
INSERT INTO zae_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nianna tti bedaxxu Jesús‑ni ka yettaxtilaha nna iki de chi begwebie Tata Do Yebáha ixkixaru, nianna tti begwebie ka benne rudhetinieha yettaxtilaha, ka benneha nna utidhike benneha len iyá ka benne se'e niha. Aníha‑gaba benie len a chupa ka belhaha. Utobake nna axtaliba beyielakanie. ");
INSERT INTO zae_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tti chi beyielakin benneha, nianna ra Jesús‑ni ka benne rudhetinieha: ―Gwalottupa ka ro'o salha'a bexxa‑na kini abittu tsia lattike. ");
INSERT INTO zae_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ka benneha nna bottupake ka ro'o salha'a bexxa ge gayu ka yettaxtila ge xua cebadaha. A tsi'inu (12) sumi besá benne bottupakeha. ");
INSERT INTO zae_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ka benneha tti bilákanie milagru ben Jesús‑ni, nianna ráke: ―Benne‑niligaba gwalí anke profeta chi ga'anna isia yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ttaka Jesús‑ni nna tti ute danie deki doelhaba ruinkana echekane kini ake nu rinnabia gekani, nianna ttúbe beru'une dedheyye attu libe iki i'iyaha. ");
INSERT INTO zae_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tti chi uka relaha nna beyadi ka benne rudhetini Jesús‑ni ata re indatooha ");
INSERT INTO zae_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","nna beta'ake lhe'e ttu barcu daa niha, deyyake belháke lo indatooha kini esinke lhe'esi Capernaum. Chiba uka rela nuha nna Jesús‑ni nna labí chi besine lenke. ");
INSERT INTO zae_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Indatooha nna ridú lii loni de raka xxatta ttu be idí. ");
INSERT INTO zae_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tti chi bedáke lo indatooha ttiba gayu o xxupa kilómetru, nianna tti bilákanie Jesús‑ni redábie dedee lo indaha, rebige kwe'e barcuha, nianna tti usikanie. ");
INSERT INTO zae_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Labie nna unnebie, ree ke: ―Netiba nuní. Bittu gasinle. ");
INSERT INTO zae_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nianna redeakabakanie belhapike bie lo barcuha nna besin ttebake len barcuha ata deyyakeha. ");
INSERT INTO zae_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Beyeki sáha nna ka benne tupa ro'o indatooha binake deki sun ka benne rudhetini Jesús‑niba beyapike lhe'e barcuha. Kumu barcu deyya ka benneha, sunruba nuha udána ro'o indatooha nna lanú Jesús‑ni bilákanie eyapi len ka benneha lhe'e barcuha. ");
INSERT INTO zae_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nianna besia adíru ka barcu dedákana daka lhe'esi Tiberias. Besia ka nuha gaxxaba ata uto ka benne yettaxtilaha ata use'eke iki de chi begwe Jesús benne anke Xxanari'iha ixkixaru len Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tti lanú Jesús‑ni bilani ka benne tupa niha, nigaba a bilákanie ka benne rudhetinieha, nianna tti uta'ake lhe'e ka barcuha nna diake ugilee daka lhe'esi Capernaum‑ni. ");
INSERT INTO zae_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tti gwaxxakake bie attu ladu ro'o indatooha, nianna tti unnaba tisake, ráke bie: ―Maestru, ¿nukala bisialu nii? ");
INSERT INTO zae_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús‑ni nna bekabie geke, ree: ―Netiru ria, labí rekile ugila neti de rilenle ka milagru runia‑ni, sinuki rekile ugila neti kumu de begoa le yettaxtila nna axtaba beyielinle. ");
INSERT INTO zae_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bittu udona lele kilale elho nu abittu ruchíana isá, sinuki gwaludola lele gwalegila elho nu uinna kini satíaba aka benle. Neti benne daya yebáha, neti unia ki satíaba aka benle arlo Tata Do Yebáha, kumu neti chi bedha'ane ki unia aní. ");
INSERT INTO zae_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nianna tti ráke bie: ―¿Bíla teeki uintu kini dhaatu uintu nu raka le Tata Do Yebáha? ");
INSERT INTO zae_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús‑ni nna bekabie geke, ree: ―Tsia lele Tata Do Yebaa benne udhelhe netiha. Nuní raka lebie uinle. ");
INSERT INTO zae_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nianna tti ráke bie: ―¿Bí milagru uinlu kini ri'itu ganna chi bilentu ka milagruha nna tsia letu gelu? ¿Bí ttu nu tse uinlu? ");
INSERT INTO zae_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kumu ka benne uka xuttori'iha utoke nu udhelha Tata Do Yebáha nu tee láni maná, tti rekike lo yu bisiha. Ukaba attiba ra lo ka yetsi ge Tata Do Yebáha ata dia ra: “Yettaxtila daa yebáha, udhelhe ki utoke.” ");
INSERT INTO zae_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús‑ni nna rabie ke: ―Netiru ria: Labí Moisés‑ni nuha betena yettaxtila daa yebáha; sinuki Tata kiaha‑ba betebie nuha. Labie nuha rutebie nu gwalíga anka yettaxtila daa yebáha. ");
INSERT INTO zae_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kumu yettaxtila rute Tata Do Yebáha, benneha anke benne daa yebáha nna runie kini satíaba aka ben ka benne. ");
INSERT INTO zae_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nianna ráke bie: ―Satía bete luesi yettaxtila‑na gotu xa tata. ");
INSERT INTO zae_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús‑ni nna rabie ke: ―Netiba nuní ankaa yettaxtila rutea elha nabani ge ka benne. Benne ite len neti labíru ituin benneha lhe benne tsia lebie neti ni tsa labíru ebisi benneha inda. ");
INSERT INTO zae_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ttaka ttiba chi xpeya le, meskiba chi bilenle neti nna labí ria lele kia. ");
INSERT INTO zae_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Iyába ka benne ruin Tataha ki itake len neti, gwadábake len neti nna ka benne gwadáke len netiha nna labí odekia ka benneha. ");
INSERT INTO zae_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kumu neti laa ugwadigaa yebáha kini unia nu rakaba lasia, sinuki unia nu ra benne udhelhe netiha. ");
INSERT INTO zae_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nuní raka le benne udhelhe netiha unia, delába delo iyá tte ka benne uin Tataha ki itake len neti bittu unnittia ni ttúke, sinuki elhidha bania ke ganna chi bisia sá daluxaha. ");
INSERT INTO zae_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nunígaba raka le Tataha aka, delába iyába ka benne ilákanie neti benne ankaa Xi'inie lhe tsia leke kia lhe, ka benneha nuha satíaba aka benke arloe. Neti nna gwelhidha benbaa ke ganna chi bisia sá daluxaha. ");
INSERT INTO zae_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ka nu Israel‑ni nna udulokana rinnekana ge Jesús‑ni kumu de rabie: “Neti ankaa yettaxtila nu daa yebáha.” ");
INSERT INTO zae_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Lhe rágabakana: ―¿Laaba nuníba nuha Jesús xi'in biyú José‑ni? Ki gwankabiabinri'i xxudini lhe ixnáni lhe. ¿Galasina nna rana: “Yebáha‑ba daya”? ");
INSERT INTO zae_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús‑ni nna bekabie, ree: ―Bittu innele kia. ");
INSERT INTO zae_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Lanú ttu benne lhaxxaba isiabie len neti ganna Tata kia benne udhelhe netiha abíba idhelhe benneha len neti. Neti nna gwelhidha benbaa benneha lo elhuttiha ganna chi bisia sá daluxaha. ");
INSERT INTO zae_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Lo ka yetsi bodha'an ka profeta ge Tata Do Yebáha dia ra: “Iyábakana udhetini Tata Do Yebáha.” Laxkala iyába ka benne riyienkanie ge Tataha lhe ridetike gebie lhe, ka benneha nuha gwadáke len neti. ");
INSERT INTO zae_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tataha lanú nu chi bilenna benneha; sunruba neti benne udáya ata doeha, sunruba neti chi biláti Tataha. ");
INSERT INTO zae_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Netiru ria, benne gwa ria lebie netiha, benneha satíaba aka benbie arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Neti ankaa yettaxtila rutea elha nabani ge ka benne. ");
INSERT INTO zae_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ka benne uka xuttoleha utoke maná lo yu bisiha, laa kiga de utoke nuha nna abittu uttike, aloba uttigabake. ");
INSERT INTO zae_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ttaka nii chi du yettaxtila daa yebáha. Benne gobie yettaxtila‑ni, benneha labí gattie, satíaba aka benbie arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Neti nuní ankaa yettaxtila bani daa yebáha. Ganna nuxa benne gobie benne‑ni, benneha satíaba aka benbie. Yettaxtila nu utea‑ni ankana kwinaga bela latia. Utea na kini odiláya ka benne se'e yiesi lo yu‑ni kini satíaba aka benke arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ka nu Israel‑ni nna udulokana ritilha tisakana, ra luesikani: ―¿Gasina ute nuní bela latin‑na gori'i? ");
INSERT INTO zae_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús‑ni nna bekabie gekani, ree: ―Neti benne daya yebáha, netiru ria, ganna lebi'i abíba gole bela latia‑ni lhe ganna abíba i'iyale reni kia‑ni lhe, labí aka benle ttu dia lii arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nu gona bela kia‑ni lhe i'iyana reni kia‑ni lhe, nuha satíaba aka benna arlo Tata Do Yebáha. Neti nna gwechidhabaa na lo elhuttiha ganna chi bisia sá daluxaha. ");
INSERT INTO zae_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kumu bela latia‑ni ankana gwalíga elho go ka benne nna reni kia‑ni nna ankana nu gwalíga i'iya ka benne. ");
INSERT INTO zae_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Benne gobie bela kia‑ni lhe i'iye reni kia‑ni lhe, benneha nuha gwa due len neti, neti nna gwa dúgabaa lenbie. ");
INSERT INTO zae_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ttiba Tata kiaha benne udhelhe netiha anke benne bani, de benneha nna neti anka bengabaa. Anágaba benne gobie bela kia‑ni, de neti nna gwaka bengabe. ");
INSERT INTO zae_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Neti labí ankaa tti anka yettaxtila uto ka benne uka xuttoleha. Ka benneha laa kiga de utoke maná lo yu bisiha nna abittu uttike, aloba uttibake. Neti ankaa yettaxtila daa yebáha. Benne goe yettaxtila‑ni gwaka benbe ttu dia lii arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iyá nuní utixxi'a Jesús‑ni lhe'esi Capernaum‑ni. Utixxi'e nuha lhe'e yo'o ata ritupa ka benne Israel‑ni rudhetike ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tti biyienkin benne se'e niha nu rinne Jesús‑ni, ixe ka benne chi danalhake bie, ráke: ―Tsitsiba anka nu rinne benne‑ni. ¿Nú dhaana udo nagani ge benne‑ni? ");
INSERT INTO zae_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ttaka Jesús‑ni ute dábanie rinne lha ka benne danalhake bieha ge nu reeha, nianna tti rabie ke: ―¿Si rutsetsibin nu rigixxi'ania le‑ni? ");
INSERT INTO zae_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Titiala ganna ttixka neti benne daya yebáha ilenle eyapia ata doa ttuha? ");
INSERT INTO zae_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espíritu ge Tata Do Yebáha nuha runie kini raka benri'i. Bela latiri'i‑ni labí rixú nuní uinna kini aka benri'i. Ka tisa rinnea‑ni ankake ge Espírituha lhe ruteke elha nabani lhe. ");
INSERT INTO zae_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ttaka sa se'e attu chupale labí ria lele. Aníha ra Jesús‑ni kumu attili sisi'a tteha chi yue nupaxake nuha abittu ria leke gebie lhe chigaba yue núke nuha uteke bie lasi ná ka nu uttikaneha. ");
INSERT INTO zae_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Lhe rágabe ke: ―De nuha nna ria le, ni ttu benne labí aka gebie ite len neti ganna abíba Tata kiaha idhelhe bie. ");
INSERT INTO zae_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Debá la'ania ixe ka benne rudhetinieha, bedhanke labíru ugweki lenke bie. ");
INSERT INTO zae_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nianna tti ra Jesús‑ni ka benne tsi'inuha (12): ―Lebi'i ¿si rakagaba lele eyyale? ");
INSERT INTO zae_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro‑ni nna bekabina gebie, rana: ―Tata Xisi to, ¿núruala sanalhatu ganna? Ki lula nuná rinnelu ka tisa ka nu ruinkana kini satíaba aka bentu arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ri'itu chiba ria letu gelu lhe chigaba yutu deki kwinalu ankalu Cristu Xi'in Tata Do Yebáha benne anka banieha. ");
INSERT INTO zae_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús‑ni nna bekabie geke, ree: ―¿Laaba ganna tsi'inule (12) nuná chi bekwea? Ttaka ttúle nna nu xxegwiba ankale. ");
INSERT INTO zae_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ge Judas Iscariote xi'in biyú Simón‑niba nuha rinnebie tti ree aníha, kumu lana nuha selana ka benne tsi'inuha (12), lhe lana nuha utene lasi ná ka nu uttikaneha lhe. ");
INSERT INTO zae_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Iki de nuha nna Jesús‑ni daka Galilea‑niba rekie. Labí raka lebie tsekie daka Judea, kumu ka nu loni ge ka benne Israel‑ni ruinkana uttikane. ");
INSERT INTO zae_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ttaka kumu de chi dabiga isia laní ge ka benne Israel‑ni nu tee láni Laní Ge Ka Yo'o Lhaga, ");
INSERT INTO zae_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","nianna tti ra ka betsieha bie: ―Bittu eya'anlu nii. Biria nna ugía daka Judea‑ni kini anágaba ka nu rudhetinlu se'e niha ilákinna ka nu xxeni ruinlu. ");
INSERT INTO zae_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kumu ttu nu raka leni iláni ka benne nu ruinna, labí gatsila tsekina uinna nuha. Laxkala lu ganna nuná ruinlu, bela'a nuná arlo ka benne. ");
INSERT INTO zae_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Aníha ra ka betsieha bie kumu nigaba lakana a ria lekani gebie. ");
INSERT INTO zae_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús‑ni nna bekabie gekani, ree: ―Neti labí chi bisia ura kia tsiaya. Lebi'i bixaba ura aka lele tsiale. ");
INSERT INTO zae_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kumu ka benne labí tee ttu bixa ge itisikanie le. Netiligaba ritisikanie kumu de rigixxi'aya deki satsaba anka nu ruinke. ");
INSERT INTO zae_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Lebi'i gwaltsia laní, neti labí dhaya kumu labí chi bisia ura kia. ");
INSERT INTO zae_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aníha‑ba rabie kana nna beya'anbe Galilea. ");
INSERT INTO zae_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ttaka iki de tti chi ugwapi ka betsieha diakana laní, nianna ugwapigabe diabie, ttaka labí die la loo, ttisidiba gatsiba die. ");
INSERT INTO zae_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ka nu loni ge ka benne Israel‑ni nna ugilabe rekikana lo laníha nna ra luesikani: ―¿Gála rekina ganna? ");
INSERT INTO zae_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Gebe rinne iyába ka benne reki niha, nu raba: “Benne tseba ankana.” Adíkana nna rákana: “Labí ankana benne tse. Ruinba leni ki ridí yienna ka benne.” ");
INSERT INTO zae_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ttaka ni ttú ka benne rinneha labí reyaxakanie inneke gebie idisa, kumu rasibakanie ge ka nu loni gekeha. ");
INSERT INTO zae_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ttiba salhe chi dia laníha, nianna tti ugwapi Jesús‑ni die ro'o yotuha nna uduloe rule'enie ka benne. ");
INSERT INTO zae_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ka nu loni ge ka benne Israel‑ni nna rebanabakinna, rákana: ―¿Gasina nna raka xxatta ge nuní, ki abígaba bedhetina? ");
INSERT INTO zae_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús‑ni nna bekabie gekani, ree: ―Laa nu anka kigaa nuní rule'a; nu anka ge benne udhelhe netiha‑ba nuní rule'a. ");
INSERT INTO zae_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Benne raka lebie unie nu ru'u le Tata Do Yebáha, benneha nuha gwate danie ganna nu rule'a‑ni gwankana ge Tata Do Yebáha o nu anka kibaa nuní rule'a. ");
INSERT INTO zae_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nu rinnena nu anka gebani, ruinba nuha kini inná xxeni leni arlo ka benne; ttaka neti rinnea nu anka ge Tata Do Yebaa benne udhelhe netiha, benneha nuha runia kini ra xxeni lebie. Neti nuha rinnea nu anka gwalí, labí gwen lasi rinnea. ");
INSERT INTO zae_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Laaba ganna Moisés‑ni boka'ane bia bennabi ge Tata Do Yebáha len lebi'i? Ttaka nna niba ttúle a ruinle nu ra loni. ¿Beakala nna ruinlale uttile neti ganna? ");
INSERT INTO zae_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ka nu se'e niha nna bekabikana, rákane: ―Nu xxegwiha‑ba yu'u latilu. ¿Nú ruinna uttina lu? ");
INSERT INTO zae_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús‑ni nna bekabie gekani, ree: ―Iyábale uka tenle tti bilenle benia ttu milagru la sá tti reyaka leri'i. ");
INSERT INTO zae_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ki anágaba lebi'i meskiba raxxína sá reyaka leri'i, sinagaba nuha ruinle tti richúle lo bela lati ka nubiyú to gele; ruinbale nu bodha'an Moisés‑ni, meskiba laa kwinaga Moisés‑ni biria ikie ki uinle aní, sinuki ka xuttoleha‑liba chi dáke ruinke aní. ");
INSERT INTO zae_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ki lebi'i gwadú richúle lo bela lati ka nubiyú to gele tti risia ka sá reyaka leri'i. Ruinle aníha kini abittu rigu'u ni'ale bia bennabi bodha'an Moisés‑ni. Ki lebi'i ruinle aná, ¿beakala rise'enle len neti de chi beyonia ttu benne rani la sá tti reyaka leri'i, benneha nna chiba beyaka chábie? ");
INSERT INTO zae_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Bittu iyubinle kuale bala'ana ge nu rilenle, sinuki gwalinneba attiba ankaba geni. ");
INSERT INTO zae_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nianna ra ttu chupa ka nu Jerusalén‑ni: ―¿Si laaba nuníba nuha ruinkana uttikana? ");
INSERT INTO zae_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Gwaluyúruga la looba du nuní rinnena nna labí bixa rákana na. Laaruba ganna ka nu loni geri'i‑na chiba ridielhakana deki gwalíba nuní ankana Cristu nu chi ga'anani Tata Do Yebáha idhelhe. ");
INSERT INTO zae_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ttaka nuní gwa yúbari'i gá dana. Cristuha nna atti isie yiesi lo yu‑ni nna labí yuri'i gá daa benneha. ");
INSERT INTO zae_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús‑ni nna ro'o yotuha‑ba doe gwele'eni ka benne nna tti biyieninie nu rákanaha, nianna unnebie idisa, ree: ―Lebi'i gwankabiabinle neti lhe gwa yúbale gaxa anka lasia lhe, ttaka labí nu yu'u ikia benia kini daya. Benne udhelhe netiha, benneha anke benne gwalíga udhelhe neti. Lebi'i labí ankabienle benneha. ");
INSERT INTO zae_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Neti nna gwankabiabatie kumu ata doeha‑ba biriaya daya lhe labe udhelhe neti lhe. ");
INSERT INTO zae_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nianna benkana udaxxukane, ttaka ni ttúkana a bedaxxukane kumu labí chi bisia ura gebie iyaxxue. ");
INSERT INTO zae_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Laa kiga de nuha nna ixeba ka benne se'e niha ugía leke gebie, nianna ráke: ―Cristuha, tti isie, ¿si ixerula ka milagru uin benneha ttichula nu ruin benne‑ni? ");
INSERT INTO zae_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ka fariseo‑ni biyienbakinna nu rinne ka benne se'e niha ge Jesús‑ni, nianna lakana lhe ka nu loni ge ka bixxudiha lhe udhelhakana ka gwen sina ge yotuha kini sadaxxukane. ");
INSERT INTO zae_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesús‑ni nna rabie kana: ―Attu sattiruba dhoa len lebi'i, iki de nuha nna eya'abaa ata do benne udhelhe netiha. ");
INSERT INTO zae_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nianna tti egilale neti, ttaka labí eselinle neti kumu ata esinaaha, lebi'i labí aka esiale niha. ");
INSERT INTO zae_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ka nu loni ge ka benne Israel‑ni nna rinnaba tisa luesikani, rákana: ―¿Gá ruin nuní eyyana nna abí saxxakari'i na? ¿Si tsiachuna ata se'eru ka benne geri'i lhe'e ka yiesi dittu‑na nna ule'egabinna ka nu dittu‑na ak? ");
INSERT INTO zae_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Bíla dienna innána tti rana: “Meskiba egilale neti nna labí eselinle neti” lhe tti rana: “Ata esinaaha, lebi'i labí aka esiale niha”? ");
INSERT INTO zae_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tti chi bisia sá lhuxa laníha, la sáha nuha anka laní xxeniru. La'ania udú lii Jesús‑ni nna unnebie idisa, ree: ―Ganna nuxa ttu le rebisile inda, teeki itale len neti kini i'iyale inda. ");
INSERT INTO zae_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Attiba ra lo ka yetsi ge Tata Do Yebáha benne tsia lebie neti, lhe'e lastobie uxunni liiba inda nu rute elha nabani ttu dia lii gebie. ");
INSERT INTO zae_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ge Espíritu dhi ka benne tsia leke ge Tata Do Yebáha, ge benneha nuha rinne Jesús‑ni tti rabie aníha. Kumu axta la'ania labí chi uxí ka benne Espírituha kumu Jesús‑ni labí chi beyapie yebáha kini inná xxeni lebie. ");
INSERT INTO zae_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tti biyienin ka benne se'e niha nu ra Jesús‑ni, nianna ra ttu chupake: ―Benne‑niligaba nna gwalí anke profeta benne chi ga'anna isiaha. ");
INSERT INTO zae_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Adí ka benne nna ráke: ―¡Ko'o! Benne‑ni anke Cristu. Ttaka adíke nna ráke: ―Galo iria benne anke Cristuha daka Galilea. ");
INSERT INTO zae_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Laaba lo ka yetsi ge Tata Do Yebáha rixxi'a ra deki benne anke Cristuha teeki aka benneha benne datiabie David‑ni nna teeki gali benneha lhe'esi Belén, daka ata uka lasi David‑ni? ");
INSERT INTO zae_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aníha uka nna delo ni'a ge Jesús‑ni nna ya yaba le rulaba le ka benne, labí turo'o rinneke. ");
INSERT INTO zae_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ttu chupakana nna ruinkana udaxxukane, ttaka ni ttúkana a beyaxakinna udaxxukane. ");
INSERT INTO zae_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ka nu rise'e gweyú ro'o yotuha, ka nu dia tadaxxukana Jesús‑ni, ka nuha beyekikana besinkana ata se'e ka fariseo‑ni lhe ka nu loni ge ka bixxudiha lhe. Ka fariseo‑ni nna rákana ka nuha: ―¿Beakala a dechele nuha? ");
INSERT INTO zae_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ka nuha nna bekabikana, rákana: ―Labí chetu na kumu lanú ttu benne chi biyienintu innebie tti rinnena. ");
INSERT INTO zae_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nianna tti bekabi ka fariseo‑ni gekani, rákana kana: ―Lebi'i, ¿si chigaba uxí yiena le? ");
INSERT INTO zae_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Gwalinnáchu, ¿si nuxa ttu ka nu rinnabia geri'i‑na o nuxatu ttu ka fariseo chi ugía letu geni? ");
INSERT INTO zae_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Ko'o, labí! Ttaka ka nu rudo nagakani ge nuha, ka nuná labí yúkana nu ra lo bia bennabi bodha'an Moisés‑ni. Ka nuná ukinniba Tata Do Yebáha kana. ");
INSERT INTO zae_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nianna Nicodemo nu ankagabana fariseo, nu ugíana gwanne lena Jesús‑ni ttu lo rela, lana nuha rana adí ka fariseo‑ni: ");
INSERT INTO zae_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Ki yule lo bia bennabi geri'i‑na rixxi'a ra deki labí aka geri'i ukinniri'i ttu benne ganna abíba lade'axa chi biyienin nagari'i bixa benie. ");
INSERT INTO zae_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nianna bekabikana geni, rákana: ―Lu nna, ¿si nu Galileagabalu? Begilaruga lo ka yetsi ge Tata Do Yebáha. Lo ka nuná labí rigixxi'a ra deki daka Galilea teeki iria ttu profeta ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nuha‑ba rákana nna kua ttu ttubakana bodaxxu neda gekani deyya lisikani. ");
INSERT INTO zae_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús‑ni nna diabie daka iki i'iya ata daa ka ya olivuha. ");
INSERT INTO zae_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Attu dilaha nna beyekie besinbie ro'o yotuha nna iyába ka benne bedetupake kwe'ebie. Lee nna ure ttebe nna rule'enie ke. ");
INSERT INTO zae_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ka nu rule'ekinna ka benne nu ra lo bia bennabi boka'an Moisés‑ni, lenkana ka fariseo‑ni bisinkana chekana ttu nuila beyaxxukinna na len ttu nubiyú. Nianna bedúkana nuilaha lagwi ge ka benne se'e niha, ");
INSERT INTO zae_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","nna rákane: ―Maestru, nuila du‑ni bexuintu na len ttu nubiyú. Lo dana ruinna nuha bexuintu na. ");
INSERT INTO zae_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lo bia bennabi bodha'an Tata Do Yebáha len Moisés‑ni ra deki ka nuila ruinkana aní teeki usiari'i kana íyya kini gattikana. Lu nna, ¿bíla ralu? ");
INSERT INTO zae_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Rákane aníha kumu de ruinkana ibixxinie bixa innábie, kini aníha‑chu nna tee ro'okani bixa usiakana ikie. Ttaka Jesús‑ni biyettalee nna len xubenábe runie letra lo yu. ");
INSERT INTO zae_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ttaka kumu de doelhaba ruinkana rinnaba tisakane, nianna tti bedú liie nna ree kana: ―Nuxa ttúle abittu bi tulha chi benle, lebi'i nuha lade'a tte udaxxule íyya use'ele nuila‑ni. ");
INSERT INTO zae_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nianna tti bedeyetta adakabe attu libe nna redeonie letra lo yu. ");
INSERT INTO zae_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Lakana nna tti biyienkinna nu reeha, ttu ttubakana udulokana bedákana. Lade'axa bedá ka benneolaha, nianna tti bedá ka nu kwitiha, axtaliba ki beya'an a sun Jesús‑niba, nuilaha nna duna arloe. ");
INSERT INTO zae_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nianna tti beyadhe nna rabie nuilaha: ―Xa nuila, ¿nála ka nu rusiakana ikiluha? ¿Si niba ttúkana a beyaxakinna ukinnikana lu? ");
INSERT INTO zae_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nuilaha nna bekabina, rana: ―Niba ttúkana xa tata. Nianna ra Jesús‑ni nuilaha: ―Anágaba neti labí ukinnia lu. Beyya lisiluha nna debá nnanna bitturu uinlu tulha. ");
INSERT INTO zae_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús‑ni nna rodolise ka benne attu libe nna redeabie ke: ―Neti ankaa xiani ge ka benne se'e yiesi lo yu‑ni. Benne etenalhe neti, labí tseki benneha lhe'e chulha, sinuki tsekilee lhe'e xianiha, xiani nu uinna kini satíaba aka benbie arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tti biyienkin fariseo‑ni nu reeha, nianna rákane: ―La kwinabalu rigixxi'alu nuxa ankalu. Lanú attu nuxa benne rigixxi'ana gelu. De nuha nna labí daka nu rigixxi'alu‑na. ");
INSERT INTO zae_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús‑ni nna bekabie gekani, ree: ―Meskiba kwinaba neti rigixxi'aya kia, ttaka gwa dakaba nu rinnea‑ni kumu neti gwa yubaa gaxa biriaya daya lhe gaxa daka diaya lhe, ttaka lebi'i labí yule gá biriaya daya lhe gá daka diaya lhe. ");
INSERT INTO zae_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lebi'i ruinbale elhuxtisi ge ttu benne attiba ruinba ka benne se'e yiesi lo yu‑ni. Neti labí runia elhuxtisi ge nuxa benne. ");
INSERT INTO zae_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ganna unia elhuxtisi nna uinbaa na attiba ankaba geni, kumu labí ttú neti nuha unia elhuxtisiha, uingaba Tata kia benne udhelhe netiha. ");
INSERT INTO zae_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lo bia bennabi gele‑na dia ra deki ganna chupa ka benne rinneke turo'o rigixxi'ake ge nu bilákanie, la'ania nna gwa dakaba nu rinne ka benneha. ");
INSERT INTO zae_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Anágaba neti, la kwinaba neti rigixxi'aya kia lhe Tata kia benne udhelhe netiha, benneha nuha ankagabe attu benne rigixxi'abie kia. ");
INSERT INTO zae_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Lakana nna unnaba tisakane, rákana: ―¿Ná tata gelu? Jesús‑ni nna bekabie gekani, ree: ―Lebi'i labí gwalí ankabienle neti, nigaba ankabienle Tata kiaha. Gannala ttixka ankabienle neti, la'ania nna gwankabialinle Tata kiaha. ");
INSERT INTO zae_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iyá nuní ra Jesús‑ni tti doe rule'enie ka benne ro'o yotuha gaxxaba ata sia ka nu rigu'uke belhiu lhe'ekaniha nna ni ttúkana labí bedaxxukane kumu labí chi bisia ura gebie. ");
INSERT INTO zae_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nianna redea Jesús‑ni ka benneha attu libe: ―Neti eya'abaa, lebi'i nna egilale neti. Ttaka ata eya'ayaha, lebi'i labí aka esiale niha, nna lo ka tulha gele‑naba gattile. ");
INSERT INTO zae_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nianna ra ka nu loni ge ka benne Israel‑ni: ―¿Si la labana uin geni ki gattina, de nuha nna rana: “Ata eya'ayaha, lebi'i labí aka esiale niha”? ");
INSERT INTO zae_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús‑ni nna ree kana: ―Lebi'i ankabale ge yiesi lo yu‑ni, neti nna ankabaa ge yebáha. Labí ankaa ge yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","De nuha nna ria le: “Gattibale lo ka tulha gele‑na.” Kumu ganna abíba ria lele deki neti ankaa nu chi ria le deki ankaa, la'ania nna gattibale lo ka tulha gele‑na. ");
INSERT INTO zae_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nianna unnaba tisakane, rákane: ―Lu nna, ¿nú ankalu? Lee nna ree kana: ―Neti ankabaa benne chi xpeya le sisi'a tteha xa. ");
INSERT INTO zae_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ixeba nu teeti upeya le lhe ge ixeba nu ukinnia le lhe, ttaka labí unia aníha. Kumu sunruba rigixxi'ania ka benne se'e yiesi lo yu‑ni nu biyienti ra benne udhelhe netiha. Benneha rinnebe nu ankaba gwalí. ");
INSERT INTO zae_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ttaka lakana nna labí ute dákinna deki ge Tata geeha‑ba nuha rinnebie, delába benne do yebáha. ");
INSERT INTO zae_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","De nuha nna ra Jesús‑ni kana: ―Neti benne daya yebáha, gannaliba chi ulhidhale neti betále lo ya kurusiha, la'anialiba nna tte denle deki neti nuha ankaa nu chi ria le deki ankaa lhe anágaba tte dágabinle deki labí runia nu anka kia, sinuki attiba bele'eni Tata kiaha neti, aníha‑ba rinnea. ");
INSERT INTO zae_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tata kia benne udhelhe netiha gwa duba benneha len neti. Labí chi bedú benneha neti suna ttúbaa, kumu satíaba runia nu ru'u lebie. ");
INSERT INTO zae_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tti ra Jesús‑ni aníha, ixeba ka benne ugía leke gebie. ");
INSERT INTO zae_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nianna tti ra Jesús‑ni ka benne Israel, ka benne chi ugía leke geeha: ―Ganna lebi'i udole tisa ge nu rinnea‑ni, la'anialigaba nna chi akale benne gwalíga rudhetinia. ");
INSERT INTO zae_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","La'anialigaba nna chi tte denle nu anka gwalí nna nu anka gwalíha nna uinna ki ese'e lhaale. ");
INSERT INTO zae_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ka benneha nna bekabike, ráke: ―Ri'itu ankatu benne datiatu Abraham‑ni nna ni tsa labí chi bito'o ri'itu lo sina ge attu benne subi. ¿Gasina nuha nna innálu deki nu anka gwalíha uinna kini ese'e lhaatu? ");
INSERT INTO zae_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús‑ni nna bekabie ge ka benneha, ree: ―Netiru ria, iyába ka nu ruin tulha, to'obakana lo tulha ruinkanaha. ");
INSERT INTO zae_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kumu ttu nu to'ona lo sinaha labí aka dho nuha satía lisi xxananiha; xi'in biyú xxana nu to'o lo sinaha‑ligaba nna gwa ralhana dhona satía lisi xxudiniha kumu de ankana xi'in biyúni. ");
INSERT INTO zae_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Laxkala ganna neti benne ankaa Xi'in Tata Do Yebáha odiláya le lo ka tulha ruinle‑na, la'anialigaba nna gwalíga chi ese'e lhaale. ");
INSERT INTO zae_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Neti yua deki lebi'i ankale benne datiale Abraham‑ni, ttaka ruinlale uttile neti kumu de labí rulabile ka tisa rule'a‑ni. ");
INSERT INTO zae_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Neti rinnebaa ge nu bilábati tti doa len Tata kia do yebáha; lebi'i nna ruinbale nu rule'ebin xxudileha le. ");
INSERT INTO zae_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Lake nna bekabike ráke: ―Abraham‑niba anka xxudi ri'itu. Ttaka Jesús‑ni nna rabie ke: ―Gannala ttixka gwalíga datiale Abraham‑ni, la'ania nna gwa ruinlale nu ben benneha. ");
INSERT INTO zae_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ttaka de rigixxi'aya nu ankaba gwalí nu biyienbati ge Tata Do Yebáha, lebi'i nna ruinlale uttile neti. Abraham‑ni labí ben benneha tti ruinle‑na. ");
INSERT INTO zae_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Lebi'i ruinbale nu ruin xxudileha. Lake nna ráke bie: ―Ri'itu labí uka ri'itu lo neda; doba ttu xxudi ri'itu, delába Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús‑ni nna rabie ke: ―Gannala gwalíga Tata Do Yebáha anke xxudile, la'ania nna lebi'i gwa rakalinle kia, kumu neti ata do Tata Do Yebáha‑ba biriaya daya nna dua nii. Labí nu yu'u iki neti benia ki daya; labe udhelhe neti. ");
INSERT INTO zae_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Beaka a rite denle ge nu rinnea‑ni? Labí rite denle kumu labí raka lele iyieninle nu ria‑ni. ");
INSERT INTO zae_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nu xxegwiha‑ba anka xxudile nna nu raka le nuha‑ba ruinle. Nuha attili sisi'a tteha ankana ttu nu runi elhutti lhe labí ridú tsitsina lo nu anka gwalíha lhe, kumu labí rinnena nu anka gwalí. Tti rinnena nna rinnebana nu ankabana, kumu ruinba leni lhe ankabana xxudi ka nu ruin lekani lhe. ");
INSERT INTO zae_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Neti nna de rinnea nu anka gwalí, de nuha nna lebi'i labí ria lele kia. ");
INSERT INTO zae_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni ttúle labí aka gele usiale ikia deki ankaa benne ruin tulha. Kumu ganna neti rinnebaa nu ankaba gwalí, ¿beakala nna a ria lele kia ganna? ");
INSERT INTO zae_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Benne anke ge Tata Do Yebáha, ka tisa ge Tata Do Yebáha‑ba rudo naga benneha. Ttaka lebi'i, kumu de labí ankale ge Tata Do Yebáha, de nuha nna labí rudo nagale gebie. ");
INSERT INTO zae_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ka nu Israel‑ni nna bekabikana, rákana Jesús‑ni: ―Gwalíbintu ratu nu Samariaba ankalu nna nu xxegwiba yu'u latilu. ");
INSERT INTO zae_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús‑ni nna bekabie gekani, ree: ―Lanú nu xxegwi yu'u lati neti. Neti gwa rugwebaa lidhaka Tata kiaha, ttaka lebi'i labí rugwele lidhakaa. ");
INSERT INTO zae_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Neti labí runia kini akaa benne ra xxeni lasia. Ttaka Tata Do Yebáha‑ba raka lebie akaa benne ra xxeni lasia nna labe inná nú ri'i gwalínri'i. ");
INSERT INTO zae_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Netiru ria, benne rudobie tisa ge nu ria‑ni, labí gatti benneha. ");
INSERT INTO zae_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ka nu Israel‑ni nna rákane: ―Nnannaligaba chi yutu deki nu xxegwiha‑ba yu'u latilu. Abraham‑ni lhe ka profetaha lhe, uttiba ka benneha. Lu nna ralu: “Nu udona tisa ge nu rinnea‑ni, labí gattina.” ");
INSERT INTO zae_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Lu, ¿si xxenirula ra lelu atti tata getu Abraham‑ni? Benneha uttibe, anágaba ka profeta ge Tata Do Yebáha uttigaba ka benneha. Lu nna, ¿nú rakinlu deki ankalu? ");
INSERT INTO zae_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús‑ni nna bekabie, ree kana: ―Ganna kwinaba neti runia ki ra xxeni lasia, la'ania nna nu ra xxeni lasiaha labí daka nuha; sinuki Tata kiaha nuha runie kini ra xxeni lasia. Benneha‑gaba nuha rale deki anke Diosi gele. ");
INSERT INTO zae_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ttaka lebi'i labí ankabienle benneha; neti nna gwankabiabatie. Kumu ganna innía labí ankabiatie, la'ania nna ruingaba lasia attiba ruinle. Ttaka neti gwankabiabati benneha lhe gwa rudobaa tisa ge nu rabie neti lhe. ");
INSERT INTO zae_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham benne uka xuttoleha bedeakanie kumu chiba yue ilánie la sá isiayaha nna gwa bilábanie la sáha nna yalhá bedeakanie. ");
INSERT INTO zae_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nianna ra ka nu Israel‑nie: ―Ki nila tsieyona (50) ida abí chi ankinlu, delo nna ralu deki chi bilenlu Abraham‑ni. ");
INSERT INTO zae_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Lee nna ree kana: ―Netiru ria, attili lani gali Abraham‑ni, neti chila doa la'ania. ");
INSERT INTO zae_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nianna tti bedaxxukana íyya ruinkana use'ekane, ttaka Jesús‑ni bekatsi tteba loe lagwi ge ka benne saa niha nna beriabie ro'o yotuha deyye. ");
INSERT INTO zae_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tti deyu'u Jesús‑ni neda deyye nna bilánie ttu benne lo xua. Aníha‑ba anka benneha attili ulieha. ");
INSERT INTO zae_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ka benne rudhetinieha nna unnaba tisake Jesús‑ni, ráke bie: ―Maestru, ¿núke ben ttu bixa tulha de nuha nna anka nu kwiti‑ni aní? ¿Si lana ak? ¿Ka tata nan geniha ak? ");
INSERT INTO zae_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús‑ni nna bekabie ree: ―Labí ankana nu lo xua de bixa tulha benna, nigaba de bixa tulha ben ka tata nan geniha. Ankana aní kini eyoin Tata Do Yebáha na nna len nu unieha nna ule'e nu xxeni ra leeha. ");
INSERT INTO zae_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ttiru nnanna sa anka resá, uin‑xxiri'i sina ge benne udhelhe netiha; kumu ganna chi uka rela, la'ania nna lanúru aka geni kwenna sina. ");
INSERT INTO zae_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Laka nnanna doa yiesi lo yu‑ni, netiba ankaa xiani ge iyá ka benne se'e yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nuha‑ba ree nna tti bettuttu xxenie lo yu nna len xxenieha benie yuna, nianna tti utabie nuha ka iyya lo benne lo xuaha. ");
INSERT INTO zae_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nianna tti ree benneha: ―Ugía gwattí lolu ro'o yiela nu tee láni Siloé. (“Siloé” dienna innána Nu Ria Mandadu.) Benneha nna ugía ttebe gwattí lobie nna tti beyekieha nna chiba relánie. ");
INSERT INTO zae_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ka benne se'e gaxxaba ata do benne uka lo xuaha lhe ka benne chi bilákanie ridoe rinnabe belhiu, ka benneha ra luesike: ―¿Laaba nuníba nuha ridona rinnabana belhiu? ");
INSERT INTO zae_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ttu chupake nna ráke: ―Ila, labana nuha ridona niha. Adíke nna ráke: ―Laa lagana nuha. De rugíaba nuní tti rugía nuha. Nubiyúha nna rana: ―Ila, netiba nuha. ");
INSERT INTO zae_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nianna tti ráke na: ―¿Galasina uka nna chi belenlu? ");
INSERT INTO zae_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Lana nna bekabina, rana: ―Benne tee lábie Jesús‑niba benie latti yuna nna utabie ka iyya loa‑ni, nianna tti ree neti: “Ugía gwattí lolu ro'o yiela nu tee láni Siloé.” Nianna ugíaya gwattí loa nna belá ttebati. ");
INSERT INTO zae_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nianna tti ráke nubiyú chi beyali loniha: ―¿Gon‑na du nubiyú ralu‑na? Lana nna rana: ―Nú yu. ");
INSERT INTO zae_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nianna tti chekana benne uka lo xuaha arlo ka fariseo‑ni, ");
INSERT INTO zae_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","kumu tti ben Jesús‑ni yuna len xxenieha tti bedhalie lo nubiyúha, la sáha ukana sá tti reyaka le ka benne Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nianna bedennaba tisagaba ka fariseo‑ni nubiyúha attu libe, rákana na: ―¿Gasina uka nna belenlu? Lana nna bekabina, rana kana: ―Yunaba utabina ka iyya loa‑ni, nianna tti gwattí loa nna belá ttebati. ");
INSERT INTO zae_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ttu chupa ka fariseo‑ni nna rákana: ―Nubiyú benna nuní labí anka nuha ge Tata Do Yebáha, kumu ribenlana sina tti risia ka sá reyaka leri'i. Adíkana nna rákana: ―¿Gasina aka ge ttu benne unie luesi ka milagru‑ni ganna anke nu runi tulha? Ya yaba le rinnekana, labí turo'o rinnekana. ");
INSERT INTO zae_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nianna tti bedennaba tisakana nubiyú uka lo xuaha attu libe, rákana na: ―Lu nna, ¿bíla ralu ge nu bedhalina lolu‑na? Lana nna bekabina, rana: ―Neti ria, ankabana ttu profeta ge Tata Do Yebáha xa. ");
INSERT INTO zae_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ttaka ka nu loni ge ka benne Israel‑ni nna labí ria lekani deki uka nubiyúha benne lo xua, nnanna nna chiba relánie. Uxilibakana ka tata nan ge benneha ");
INSERT INTO zae_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","nna unnaba tisakana ka benneha, rákana ke: ―¿Si xi'in biyúle nu du‑ni, nu rale deki ttili ulinaha xua loni? ¿Galasina nna chiba relenna nnanna? ");
INSERT INTO zae_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ka xxudi ixná nubiyúha nna bekabike, ráke: ―Ri'itu yúbatu deki xi'inbatu nuní lhe yúgabatu deki nu lo xuaba anka nuní ttili ulinaha. ");
INSERT INTO zae_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ttaka labí yutu gaxasina uka nna chi relenna lhe nigaba a yutu nú bedhalina loni lhe. Gwalinnaba tisa na. Chiba anka nuná nu xxeni. Kwinaba lana kixxi'ana nú bedhalina loni. ");
INSERT INTO zae_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Aníha‑ba ra ka tata nan ge nubiyúha kumu rasikanie ge ka nu loni ge ka benne Israel‑ni kumu chi unnekana rákana, ganna ttu benne inne deki Jesús‑ni anke Cristu, la'ania nna ebea ttebakana benneha lhe'e yo'o ata rudheti ka benne Israel‑ni ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","De nuha nna ra ka tata nan geniha: “Naba gwalinnaba tisa na. Chiba anka nuná nu xxeni.” ");
INSERT INTO zae_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nianna tti bedeaxi ka nu loni ge ka benne Israel‑ni benne uka lo xuaha attu libe nna redeakane: ―Arlo Tata Do Yebáha unne nu anka gwalí. Ri'itu yutu deki nu beyoinna luha, nu ruin tulhaba anka nuha. ");
INSERT INTO zae_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nubiyúha nna bekabina gekani, rana: ―Neti bittuba yua si ankana nu ruin tulha. Neti nu yúrubaa, ukaa benne lo xua, nnanna nna chiba reláti. ");
INSERT INTO zae_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Lakana nna bedennaba tisakana nubiyúha attu libe, rákana na: ―¿Bí bedhakana lu ki belenlu? ¿Gasina bedhalina ka iyya lolu‑na? ");
INSERT INTO zae_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Lana nna bedekabina gekani, rana kana: ―Ki chiba xpeya le nna lebi'i nna bittuba ria lele. ¿Beaka raka lele kixxi'ania le attu libe? ¿Si rakagaba lele akale benne sanalhale na ak? ");
INSERT INTO zae_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nianna tti belisa satsakana nubiyúha, rákana na: ―Luba ankalu nu danalhalu na xa. Ri'itu Moisés‑niba danalha ri'itu. ");
INSERT INTO zae_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ri'itu yúbatu deki Tata Do Yebáha unne lenie Moisés‑ni, ttaka nubiyú ralu‑na labí yutu gaxa biria nuná dana. ");
INSERT INTO zae_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nubiyúha nna bekabina gekani, rana: ―¿Galabasina anka nuní? Lebi'i abígaba yule gaxa biriana dana. Neti nna gwa bedhalibana loa. ");
INSERT INTO zae_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ri'i gwa yu xeabari'i deki Tata Do Yebáha labí rudo naga benneha ge ka nu ruin tulha. Sunruba rudo nage ge ka nu gwaria lekanie lhe ruinkana nu ru'u lebie lhe. ");
INSERT INTO zae_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ni tsa labí chi biyieninri'i innekana ge ttu benne innákana deki bedhalie lo ttu benne ulie anke lo xua. ");
INSERT INTO zae_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ganna ttixka nu bedhalina ka iyya loa‑ni abittuba ankana nu udhelha Tata Do Yebáha, la'ania nna labí aka ge nuná uinna ttu bixa. ");
INSERT INTO zae_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nianna rákana nubiyúha: ―Ki lu nu ruin tulhaba ankalu attili uliluha, ¿gá lolu nna lula dalu gwele'en ri'itu? Nianna tti bebeakana nubiyúha lhe'e yo'o ata rudhetikana ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tti chi bina Jesús‑ni deki chi bebeakana nubiyúha niha, nna tti beti'abie naha nna ree na: ―¿Si gwa ria lelu benne daa yebáha? ");
INSERT INTO zae_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nubiyúha nna bekabina, rana: ―¿Núke nuná xa tata? Utixxi'a kini neti nna tsia lasia gebie. ");
INSERT INTO zae_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús‑ni nna rabie na: ―Chiba bilenlu benneha nna labie nuní rinne lenlu. ");
INSERT INTO zae_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nubiyúha nna rana: ―Gwa riaba lasia lu xa tata. Nianna tti bedú xibini arloe. ");
INSERT INTO zae_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesús‑ni nna ree na: ―Neti bisiaya yiesi lo yu‑ni kini unia elhuxtisi ge ka benne kini ka nu lo xua‑na nna elákinna, ka nu gwa rilálakinna nna eyakakana ka nu lo xua. ");
INSERT INTO zae_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ttu chupa ka fariseo‑ni ka nu se'ekana lenie niha, tti biyienkinna nu reeha, nianna unnaba tisakane, rákane: ―Ganna niha nna ri'itu, ¿si ankagabatu benne lo xua? ");
INSERT INTO zae_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús‑ni nna bekabie gekani, ree: ―Gannala ankale nu lo xua, la'ania nna abittula ujale yua ge ka tulha ruinle‑na. Ttaka kumu rale: “Gwa rilábintu”, de nuha nna nujabale yua ge ka tulha ruinle‑na. ");
INSERT INTO zae_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Netiru ria, nu abíba ra'ana ro'o puerta du ro'o lisi ka neruha, sinuki ata subila ribixxina ra'ana, nu runi aníha ubanaba anka nuha. ");
INSERT INTO zae_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ttaka nu gwa ra'ana ata do ro'o lisi ka neruha, nuha‑ligaba nna gwalí gwankana nu rekina lo ka nuha ");
INSERT INTO zae_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","nna nu ridú ki ruyúna ro'o lisi ka neruha gwa ridhaliba nuha kini ra'a nu reki lo ka neruha. Ka neruha nna reyoinbia ttebakana tsi'i nu rekina lokaniha. Lana nna kua ttu ttuba ka neruha raxina rudettina lákani, nianna tti ribeana kana. ");
INSERT INTO zae_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ganna chi uleana iyá ka neru ka nu anka geniha, nianna tti rineruna lo ka nuha. Ka nuha nna gwa ranalhabakana na kumu gwa reyoinbiabakana tsi'ini. ");
INSERT INTO zae_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ttaka nu abittu ankabiakinnaha, labí sanalhakana nuha; uxunnilakana geni kumu de labí ankabiakinna tsi'ini. ");
INSERT INTO zae_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Nuní unne Jesús‑ni betanie ka benne se'e niha, ttaka lake nna labí ute dákanie bixa diani nu raka lebie kixxi'anie keha. ");
INSERT INTO zae_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nianna redea Jesús‑ni ka benneha attu libe: ―Netiru ria: Neti nuha ankaa puerta du ro'o lisi ka neruha. ");
INSERT INTO zae_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Iyába ka nu abittu biyú tsekana ka neruha, ka nu chi bitakana tti lanila isiaya yiesi lo yu‑ni, ka nuha ubanaba ukakana. Ka neruha nna labí bedo nagakani gekani. ");
INSERT INTO zae_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Neti ankaa puerta du ro'o lisi ka neruha. Benne ga'abie ro'o puertaha, godilába Tata Do Yebáha bie. La'ania nna uinbe ttiba runi ttu neru to. Neru toha reria reta'abana, rigilana nu gona. ");
INSERT INTO zae_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ubanaha suna daba nuha kini lhanana lhe uttina lhe utse'e loona lhe; ttaka neti daya kini odiláya le kini satíaba aka benle arlo Tata Do Yebáha, kini anáchu nna gwasipa edí baale tse'ele. ");
INSERT INTO zae_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Neti nuha ankaa benne ruyú tse ka neruha. Benne ruyú tse ka neruha nna reria iki reria lebie meskila gattie kini odilábie ka neruha. ");
INSERT INTO zae_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ttaka ttu nu ridí lhiaxani ki rekina lo ka neruha, tti rilenna daa sageeha nna ruse'e bixxibana ka neruha nna ruxunnina kumu laaga geni ka nuha. Sageeha nna ruinna udaxxuna ka neruha, nianna rutsatsana kana. ");
INSERT INTO zae_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nu rekina lo ka neruha ruxunnilana nna labí retabinna ge ka nuha, kumu nu naxaba ankana. ");
INSERT INTO zae_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Neti ankaa benne ruyú tsea ka neruha. Neti ankabiabati ka neru ka nu ankakana kia. Anágaba ka nu chi ankakana kiaha nna gwankabiagabakinna neti. ");
INSERT INTO zae_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ttiba Tata kiaha chi ankabianie neti, anágaba neti chigaba ankabiatie lhe rutea elha nabani kia‑ni kini gattia ki odiláya ka neruha. ");
INSERT INTO zae_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Se'erugabati adí ka neru ka nu labí chi selakana ka nu se'e nii. Anágaba ka nuha rakagaba doelha taxía kana nna gwayienbakinna tsi'a. Gwanka suna ttu dhiba eyakakana lhe ttúba benne tsekie lokani lhe. ");
INSERT INTO zae_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’De nuha nna Tata kiaha rakanie kia, kumu rutea elha nabani kia‑ni ki gattia, kini delo nna eyaka benbaa attu libe. ");
INSERT INTO zae_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Lanú nu uttina neti, sinuki kwinaba neti redá lasia gattia kwenta ge ka benne, kumu neti gwa teeba lo neda kia utea elha nabani kia‑ni ki gattia. Anágaba nna gwakagaba kia eyaka bania attu libe. Nuní chi bodha'an Tata kia ki unia. ");
INSERT INTO zae_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tti biyienin ka nu Israel‑ni nu reeha, nianna bedela'a lhe'e luesikani kumu de labí riyien ten ge luesikani. ");
INSERT INTO zae_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ixebakana rákana: ―¿Beaka rudo nagakani ge nuní, ki espíritu xxegwiha‑ba yu'u lati nuní? Lhe rágabakana: ―Rakaba iki nuní. ");
INSERT INTO zae_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Adíkana nna rákana: ―Lanú ttu benne yu'u espíritu xxegwi latie gwaka gebie innee tti rinne nuní. Laa gwakaga ge espíritu xxegwiha edhalina lo ttu benne lo xua. ");
INSERT INTO zae_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tti chi bisia ka beo raka idilhaha, la'ania nuha ka benne Israel‑ni ruinke laní Jerusalén‑ni tti rexxa leke la sá bocharike yotuha nna boteke benneha len Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús‑ni nna rekie ro'o yotuha ata daa kweredori ge Salomón‑ni. ");
INSERT INTO zae_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ka benne Israel‑ni bitupake abi'iba kwe'ebie nna ráke bie: ―¿Nukalila kixxi'alu nuxa ankalu? Ganna lu ankalu Cristu, tsa ttela utixxi'en ri'itu kini aka xen letu. ");
INSERT INTO zae_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús‑ni nna bekabie geke, ree: ―Ki chiba utixxi'ania le nna abígaba ria lele. Ka milagru rute Tata kiaha ki runia, ka nuha rigixxi'akana nuxa ankaa. ");
INSERT INTO zae_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ttaka lebi'i nna labí ria lele, kumu de labí ankale neru kia. ");
INSERT INTO zae_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ka benne ankake neru kiaha, gwa riyienbakanie tsi'a tti rinnea. Neti nna gwankabiabati ke, lake nna gwa retenalhabake neti. ");
INSERT INTO zae_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Neti runia kini raka benke ttu dia lii nna ttu tsaba labí tse'e looke. Anágaba nna lanú nu aka geni eguana ke lo náya. ");
INSERT INTO zae_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tata kiaha betebie ke lasi náya. Benneha xxenirula ra lebie tti attu benne, laxkala lanú dhaana eguana ka benne ankake neru kiaha lo ná Tata kiaha. ");
INSERT INTO zae_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Neti lhe Tata kiaha lhe, ttúba benne anka ri'itu. ");
INSERT INTO zae_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nianna tti bododaxxu ka nu Israel‑ni íyya nna ruinkana odose'ekane. ");
INSERT INTO zae_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesús‑ni nna ree kana: ―Ixeba ka milagru chi benia arlole, delába ka milagru bete Tata kiaha kini unia. ¿Nú ge ka milagru beniaha ruinle usiale neti íyya? ");
INSERT INTO zae_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Lakana nna bekabikana, rákana: ―Laa ruingatu usiatu lu íyya de ruinlu ka milagru. Ruintu usiatu lu íyya kumu Tata Do Yebáha nuná rorexxa gaalu tti ralu aná. Kumu lu ki benneba ankalu nna ruinlu deki ankalu Diosi. ");
INSERT INTO zae_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Jesús‑ni nna bekabie ree kana: ―Ri'i gwa yúbari'i deki labí aka ku'u ni'ari'i nu ra lo ka yetsi ge Tata Do Yebáha. ¿Laaba lo ka yetsi denle‑na ra Tata Do Yebáha: “Lebi'i diosiba ankale”? Ki ganna diosi utixxa Tata Do Yebáha lá ka benne begwebie ke ka tisa geeha, ");
INSERT INTO zae_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿beakala netila ulesie nna udhelhe yiesi lo yu‑ni, beakala rálale neti deki rorexxa gaaya Tata Do Yebáha de ria, “Neti ankaa Xi'inie”? ");
INSERT INTO zae_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ganna neti abíba runia nu ruin Tata kiaha, bittugaba tsia lele kia, ");
INSERT INTO zae_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ttaka ganna gwa ruinbaa nu runie, meskila a ria lele kia, gwaltsia lele ge nu rilenle runia, kini tsala unale deki Tata kiaha ttúba benne anke len neti nna neti nna ttúba benne ankaa lenie. ");
INSERT INTO zae_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nianna tti redeonkana ododaxxukane attu libe, ttaka lee nna ulábe lo nákani. ");
INSERT INTO zae_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nianna tti dedheyye daka attu ladu ro'o yoo Jordán‑ni, daka ata begadi Juan‑ni ka benne inda ttuha nna niha‑ba ugwekie. ");
INSERT INTO zae_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ixe ka benne risinke ata dueha nna ráke: ―Gwalí galá Juan‑ni labí bixa ttu milagru ben benneha, ttaka iyába nu utixxi'anie ri'i ge nubiyú du nii, gwalíba nu ra benneha. ");
INSERT INTO zae_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nianna ixeba ka benne ugía leke ge Jesús‑ni tti rekie daka ro'o yoo Jordán‑ni. ");
INSERT INTO zae_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","La'ania do ttu benne rani lábie Lázaro. Anke benne lhe'esi Betania, lhe'esi ge María‑ni lhe ge xilani Marta‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María‑ni raka danni Lázaro‑ni. María‑ni nuha bedona seti rure ixixxi ka ni'a Jesús‑ni nna bodibisina ka nuha len itsa ikiniha. ");
INSERT INTO zae_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ixpa xilabakani udhelhakana, rákana Jesús‑ni: ―Tata, benne raka xxattinlu geeha, raniba benneha. ");
INSERT INTO zae_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús‑ni tti bine nuha nna ree: ―Isagwe ridaka nu kwitiha labí anka nuha nu uttina na, sinuki isagweha ixúlana kini ula'a nu xxeni ra le Tata Do Yebáha lhe anágaba neti benne ankaa Xi'inieha, ula'agaba nu xxeni ra lasia. ");
INSERT INTO zae_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús‑ni meskiba gwa rakanie ge Marta‑ni lhe ge xilaniha lhe ge Lázaro‑ni lhe, ");
INSERT INTO zae_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ttaka labie atti bine deki raniba Lázaro‑ni, beya'anlee ata rekieha a chupa ubisa. ");
INSERT INTO zae_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Delola nna ree ka benne rudhetinieha: ―Eya'alari'i daka Judea‑ni attu libe. ");
INSERT INTO zae_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ka benne rudhetinieha nna ráke bie: ―Maestru, ki si ukaba ttu chupa ubisa‑ni nuha tti ruin ka nu Israel‑ni usiakana lu íyya. ¿Si edeya'abari'i niha attu libe? ");
INSERT INTO zae_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús‑ni nna bekabie gekani, ree: ―¿Laaba ganna tsi'inu (12) ura yu'u lhe'e ttu sá? Nu reki resáha labí riyu'una nuha, kumu gwa rilábinna xiani ru'u yiesi lo yu‑ni, ");
INSERT INTO zae_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ttaka nu reki relaha iyu'unaba nuha, kumu labí xiani ru'u geni kini ilenna. ");
INSERT INTO zae_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iki de nuha nna ree: ―Amigu geri'i Lázaruha chiba uta'adhi benneha, ttaka chi tsiaya kini odibánie. ");
INSERT INTO zae_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ka benne rudhetinieha nna ráke bie: ―Tata, ganna chiba utta'adhie, nuha runna liina deki gweyakaba benneha. ");
INSERT INTO zae_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ttaka Jesús‑ni ge elhutti ge Lázaro‑niba nuha rinnebie. Lake nna ukakanie ganna ge bisiela ra'adhibari'i nuha rinnebie. ");
INSERT INTO zae_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Niala nna tti utixxi'a tsenie ke, rabie ke: ―Lázaro‑ni chiba utti nuha. ");
INSERT INTO zae_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","De lebi'i nna redeakati kumu de labí dua niha tti utti benneha. Nnanna nna tsiarugari'i kini ilenle nu unia, kini aníha nna tsia lele kia. ");
INSERT INTO zae_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomás benne tekanie lábie Kwachi, benneha ree adí ka benne rudheti lenieha: ―Anágaba ri'i tsiagabari'i kini gattigabari'i len benneha. ");
INSERT INTO zae_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tti bisin Jesús‑ni lhe'esi Betania bine deki chi uka ttapa ubisa bigatsi Lázaro‑ni. ");
INSERT INTO zae_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania‑ni rena gaxxaba kwe'e Jerusalén‑ni, rena ttiba tsunna kilómetru ");
INSERT INTO zae_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","nna ixe ka benne Israel chi ugíake gwalannike Marta‑ni lhe María‑ni lhe, ki gwadú ittake le ka benneha de du si'i leke utti dankeha. ");
INSERT INTO zae_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tti bina Marta‑ni deki chi isin Jesús‑ni lhe'esiha, nianna biria ttebana gwaledane, ttaka María‑ni nna beya'anbana lhe'e yo'oha. ");
INSERT INTO zae_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta‑ni nna rana Jesús‑ni: ―Gannaru dolu nii xa tata, labíga utti benne danaaha ganna ttixka. ");
INSERT INTO zae_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ttaka neti yubaa meskiba nnanna iyába nu innabalu len Tata Do Yebáha, gutebe nuha lenlu xa tata. ");
INSERT INTO zae_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús‑ni nna bekabie, ree na: ―Gweyaka benba danluha. ");
INSERT INTO zae_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta‑ni nna bekabina, rane: ―Neti yubaa deki gweyaka benba benneha tti eyadha ka benne chi uttiha eyaka benke ganna chi isia sá daluxaha. ");
INSERT INTO zae_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús‑ni nna rabie na: ―Neti runia ki reyaka ben ka benne chi uttiha lhe runia kini raka ben ka benne ttu dia lii lhe. Benne tsia lebie neti, meskiba chi uttie nna gweyaka benbe ttu dia lii, ");
INSERT INTO zae_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","nna iyába ka benne sa se'e benke, ganna tsia leke neti, ka benneha nna satíaba aka benke, labí gattike. ¿Si gwa ria lelu ge nu ria‑ni? ");
INSERT INTO zae_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta‑ni nna rane: ―Ila xa tata, gwa ria galá lasia deki lu ankalu Cristu Xi'in Tata Do Yebaa benne chi ga'anna isia yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Iki de tti chi rana Jesús‑ni aníha, nianna deyyana gwalisana xilani María‑ni nna sigába rana nuha: ―Naa chi du maestruha raxie lu. ");
INSERT INTO zae_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","María‑ni nna sun tteba biyieninna nuha nna bexunni ttebana diana ata du Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús‑ni labí chi uta'abie lhe'esiha, sa dube ata beti'a Marta‑nieha. ");
INSERT INTO zae_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ka benne Israel, ka benne se'e lenke María‑ni lhe'e yo'oha ki rodú ittake leni, ka benneha tti bilákanie ruxunnibana biriana diana, nianna danalha ttebake na ukakanie ganna iki baaba diana ubesi. ");
INSERT INTO zae_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tti bisin María‑ni ata du Jesús‑ni, tti bilenna benneha nna bedú tteba xibini arloe nna rane: ―Tata xisi to, gannaru do kwinalu nii, labíga utti benne danaaha ganna ttixka. ");
INSERT INTO zae_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús‑ni tti bilánie ribesi María‑ni lhe ribesi ka benne Israel dia lennaha lhe, axtaba bega'a dina lhe'e lastoe nna bedú si'ina lebie, ");
INSERT INTO zae_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","nianna tti unnaba tise, ree na: ―¿Gáli gwakatsile na? Lana nna rane: ―Utáruga belanni xa tata. ");
INSERT INTO zae_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nianna tti uresi Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ka benne Israel‑ni nna ráke: ―¡Gwaluyúruga, kattiparuba rakanie ge benneha! ");
INSERT INTO zae_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Adíke nna ráke: ―Nuní gwa uka geni bedhalina ka iyya lo benne lo xuaha, ¿beakala Lázaro‑ni nna a benna kini abittu uttina? ");
INSERT INTO zae_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús‑ni nna bododú si'i xxattana lebie attu libe, nianna tti die ata bekatsikana benneha. Yieru baa ata bigatsi benneha ttu beleaba anka nuha nna yaya ttu íyya bata ro'oni. ");
INSERT INTO zae_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nianna tti ree: ―Gwalikua íyya yaya ro'o yieru baa‑na. Marta dan benne chi uttiha nna rane: ―Gaxa chiba rure benne‑na xa tata. Chiba uka ttapa ubisa bigatsie. ");
INSERT INTO zae_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús‑ni nna bekabie, ree na: ―¿Laaba chiba ria lu ganna lu tsia lelu, la'ania nna gwalábinlu nu xxeni ra le Tata Do Yebáha? ");
INSERT INTO zae_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nianna tti utuakana íyya yaya ro'o yieru baaha. Jesús‑ni nna belhidha loe gwetsáha nna ree: ―Ixkixaru rugwea lu xa Tata, kumu gwa biyienbinlu kia. ");
INSERT INTO zae_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Neti yubaa deki satíaba gwa riyienibinlu kia, ttaka de ka benne se'e nii nna unnea ria aná, kini tsia leke deki lu udhelhalu neti. ");
INSERT INTO zae_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iki de chi rabie aníha, nianna tti unnebie idisa, nna ree: ―¡Lázaro, beria naa nna betá! ");
INSERT INTO zae_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Benne chi uttiha nna beriabie derilhi ka ni'eha lhe ka neeha lari. Anágaba loeha derilhigabana lari. Nianna tti ra Jesús‑ni ka benne se'e niha: ―Gwaledhasi ka lari‑na latini kini aka edána. ");
INSERT INTO zae_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ixe ka benne Israel ka benne dia lenke María‑ni, tti bilákanie nu ben Jesús‑ni, nianna ugía leke gebie. ");
INSERT INTO zae_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ttaka attu chupa ka nuha nna ugía ttebakana gwattixxi'akinna ka fariseo‑ni nu chi benieha. ");
INSERT INTO zae_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ka fariseo‑ni lhe ka nu loni ge ka bixxudiha lhe, bottupa ttebakana ka nu runi elhuxtisi ge ka benne Israel‑ni nna ra luesikani: ―¿Bíla anka nu uinri'i ganna? Nubiyú reki nii ixeba ka milagru ruinna. ");
INSERT INTO zae_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ganna anába la rugwelhabari'i na ruinna ka milagru ruinna‑na, la'ania nna iyába ka benne tsia leke geni, nianna tti ita ka nu rinnabia ge Roma‑ni etetse'e lookana yotu le'a geri'i‑ni lhe ka benne geri'i‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ttaka ttu ka nuha, delába nu tee láni Caifás nu anka bixxudi xeni lhe'e idaha, nuha nna rana kana: ―Lebi'iligaba birula yule. ");
INSERT INTO zae_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nigaba a rite denle deki tserula saríana ri'i ganna sun ttúba benne gattie kwenta ge ka benne geri'i, alaa kila iyábake tse'e looke. ");
INSERT INTO zae_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ttaka Caifás‑ni labí nu anka geni nuha unnena tti rana aníha, sinuki kumu de ankabana bixxudi xeni lhe'e idaha, de nuha nna unnena nu chi ga'anani Tata Do Yebáha aka, unnena deki Jesús‑ni gattie kini kixe ge ka benne Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Anna laa sun ge ka benneha‑ga kixe, anágaba kixagabe ge iyá ka benne chi ankake xi'in Tata Do Yebáha, delába ka benne se'e gatti gattiba, ki ottupe ke nna eyakake ttúba. ");
INSERT INTO zae_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Laxkala debá la sáha nna beda'a ro'okani uttikana Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","De nuha nna labíru ugweki Jesús‑ni la saa lagwi ge ka benne Israel‑ni. Berialee ata rekieha nna deyye gaxxaba lo yu bisi ata re ttu yiesi tee láni Efraín. Niha‑ba ugweki lenie ka benne rudhetinieha. ");
INSERT INTO zae_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tti chi dabigana isia laní Pascua, delába laní ge ka benne Israel‑ni, ixe ka benne se'e lhe'e adí yiesi diake lhe'esi Jerusalén‑ni atti lani isia laníha kini eyarike arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Niha rekike regilake Jesús‑ni nna rinnaba tisa luesike ro'o yotuha, ra luesike: ―¿Bí rakinle? ¿Si bi gwa itana laní ganna? ");
INSERT INTO zae_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ka nu loni ge ka bixxudiha lhe ka fariseo‑ni lhe, ka nuha chi bedhankana tisa rákana, ganna nuxa ttu benne une gaxa reki Jesús‑ni teeki kixxi'anie kana kini anáchu aka gekani udaxxukana Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Xxupa ubisa atti lanila isia laní Pascuaha, ugía Jesús‑ni lhe'esi Betania ata do Lázaro benne belhidha benbie lo elhuttiha. ");
INSERT INTO zae_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ka Lázaro‑ni benke ttu irse ki goke lenbie. Marta‑ni daabie riga'abie lhe'e ka ye'enaha, Lázaro‑ni nna labie nuha anke ttu ka nu do len Jesús‑ni ro'o mexaha. ");
INSERT INTO zae_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","María‑ni nna bedaxxue ttiba medi litru seti rure ixixxi. Setiha ankana taga'a ge ttu iyya to tee láni nardo. Setiha raka xxattana yaxi nna utabi María‑ni nuha ka ni'a Jesús‑ni. Nianna tti bodibisie ka ni'eha len itsa ikieha. Itúba lhe'e yo'oha ure tsi'i setiha. ");
INSERT INTO zae_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ttaka Judas Iscariote, ttu ka nu rudhetinieha nu utene lasi ná ka nu uttikaneha, lana rana: ");
INSERT INTO zae_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Beaka a bito'ochila seti rure ixixxi‑ni ki utekana geni tsunna gayua (300) denario, kini belhuha nna dhi ka benne dii abittu geke tee? ");
INSERT INTO zae_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas‑ni rana aníha, labí kumu de retabinna ge ka benne abittu geke tee, sinuki rana aníha kumu de ankana ubana lhe kumu lana denna beduti to yu'u belhiu gekeha nna chi labinna rudaxxu sigána belhiu rigu'uke lhe'e nuha. ");
INSERT INTO zae_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nianna tti ra Jesús‑ni na: ―Begwelha na egu'una seti‑ni ka ni'aya‑ni. Ruinna nuní kumu chi rodú tse gaana neti ganna chi isia sá igatsiaha. ");
INSERT INTO zae_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ka benne dii abittu geke tee satíaba tse'e ka benne‑na len lebi'i, ttaka neti labí satía dhoa len lebi'i. ");
INSERT INTO zae_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ixe ka nu Israel‑ni tti binakana deki do Jesús‑ni Betania, nianna ugíakana gwalannikane. Ttaka labí sun labie ugíakana gwelanni, sinuki ugíagabakana kini ilákinna Lázaro benne beyadha benbie lo elhuttiha. ");
INSERT INTO zae_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","De nuha nna ka nu loni ge ka bixxudiha chi beda'a ro'okani uttigabakana Lázaro‑ni, ");
INSERT INTO zae_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kumu de lana nna ixe ka benne Israel chi bekwittake lenkana nna ge Jesús‑nila chi ria leke. ");
INSERT INTO zae_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Beyeki sáha ixe ka benne dia laní Pascuaha, tti bina ka benneha deki chi daa Jesús‑ni ga'abie lhe'esi Jerusalén‑ni, ");
INSERT INTO zae_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","nianna ugíake gwaledake bie nna bedaxxuke dina denke nna ribesi'abake, ráke: ―¡Xxeniba ra lelu! ¡Lu ankalu benne udhelha Tata Xisiha! ¡Karubárulu! ¡Lu ankalu benne innabialu ka benne Israel‑ni! ");
INSERT INTO zae_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nianna tti gwaxxaka Jesús‑ni ttu burru kwiti to nna udobie kwe'eni. Ukaba attiba chi ga'anna lo ka yetsi ge Tata Do Yebáha ata dia ra: ");
INSERT INTO zae_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","¡Bittu gasinle, lebi'i ka benne ge lhe'esi Sión! ¡Gwalulanniruga! Ne benne rinnabia geleha chi daa naa doe kwe'e ttu burru kwiti to. ");
INSERT INTO zae_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tti sisi'a tteha, ka benne rudhetini Jesús‑ni labí ute dákanie iyá nu rakaha. Iki deliba chi uttieha nna beyapie yebáha ata ra xxeni leeha, la'anialiba nna tti gwadú leke deki iyába nu benke len benneha chiba ga'anna nuha lo ka yetsi ge Tata Do Yebáha deki aníha aka. ");
INSERT INTO zae_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ka benne se'e len Jesús‑ni tti beyaxie Lázaro‑ni lhe'e yieru baaha, tti belhidha benbie benneha lo elhuttiha, ka benneha rigixxi'ake ge nu bilákanie la'ania. ");
INSERT INTO zae_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","De nuha nna biria ka benne gwaledake bie kumu de binake ge milagru benieha. ");
INSERT INTO zae_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ka fariseo‑ni nna ra luesikani: ―Gwaluyúruga, ri'i labí dhaari'i. Gwalugíaruga, iyába ka benne danalhake nuná. ");
INSERT INTO zae_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Lagwi ge ka benne dia laníha, delába ka benne dia ki sadú xibike arlo Tata Do Yebáha, lhe'e ka benneha sela ttu chupa ka benne griegu. ");
INSERT INTO zae_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ka benneha ubigake ata du Felipe‑ni. Felipe‑ni ankana benne lhe'esi Betsaida. Yiesiha rena daka Galilea. Nianna unnabake lenna, ráke na: ―Raka letu ilentu Jesús‑ni, xa tata. ");
INSERT INTO zae_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe‑ni nna ugíana utixxi'enna Andrés‑ni. Nianna ixpabakana diakana gwatixxi'akinna Jesús‑ni nu ra ka benneha. ");
INSERT INTO zae_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús‑ni nna bekabie gekani, ree: ―Benne daa yebáha chiba bisia ura gatti benneha nna eyapie yebáha kini inná xxeni lebie. ");
INSERT INTO zae_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Netiru ria, ttiba xua xuxtilaha, ganna abíba igatsi yu ikie ki e'eyue, la'ania nna labí tsani benneha, ttúbe eya'anna. Ttaka ganna xuaha gattibe, delába egelhaba xoe nna e'eyue, la'ania nna ixeni lena ute benneha. ");
INSERT INTO zae_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Benne abittuba raka lebie bixa satebie de etenalhe neti, benneha nnittilee arlo Tata Do Yebáha nna benne eria iki eria lebie etenalhe neti meskila bixa satebie yiesi lo yu‑ni, benneha gwaka benlee ttu dia lii arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ganna nuxa ttu benne raka lebie ixúe kini unie nu raka lasia, teeki itee etenalhe neti nna ata esina dhoaha, niha‑gaba dhoe, nna ganna nuxa ttu benne chi rixúe runie nu raka lasia, Tata kiaha gugwebe lidhaka benneha. ");
INSERT INTO zae_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Loora nnanna yalhá rudú xxattana neti. Nianna, ¿si gwannílaa, “Tata, bodiláchittu neti lo elha disa uyúa‑ni”? Ttaka ki de uyúlaa elha disa‑ni, de nuha nna daya yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata, bele'e nu xxeni ra lelu arlo ka benne. Nuha‑ba rabie, nianna biyien tsi'i ttu benne unnebie yebáha, ree: ―Chiba bele'a nu xxeni ra lasia, nnanna nna odole'a na attu libe. ");
INSERT INTO zae_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ka benne se'e niha, tti biyienkanie tsi'i benne unneeha, ttu chupake ráke: ―Uyu'u beba nuná. Adíke nna ráke: ―Ttu anjeli daa yebáha‑ba nuná belise benne‑ni. ");
INSERT INTO zae_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús‑ni nna rabie kana: ―Laa de netiga nna biyien tsi'i benneha, de lebi'ila nuná nna biyien tsi'ibie. ");
INSERT INTO zae_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nnanna nuha chi bisia sá uin Tata Do Yebáha elhuxtisi ge ka benne se'e yiesi lo yu‑ni lhe nnanna nuha chi bisia sá kweabie nu rinnabiana yiesi lo yu‑ni, delába nu xxegwiha. ");
INSERT INTO zae_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Neti nna ganna chi ulhidhakana neti betákana neti lo ya kurusiha, la'ania nna unia kini iyába ka benne ibigake len neti. ");
INSERT INTO zae_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Aníha rinnebie ki benna liie gaxasina gattie. ");
INSERT INTO zae_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ka benneha nna bekabike gebie, ráke: ―Ri'itu yutu deki lo ka yetsi ge Tata Do Yebáha rigixxi'a ra deki benne anke Cristuha satíaba aka ben benneha. Lu nna, ¿galasina nna rálalu deki teeki ilhidhakana benne daa yebáha? ¿Núla nuha anka benne daa yebáha ganna? ");
INSERT INTO zae_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús‑ni nna rabie kana: ―Attu sattiruba do benne anke xiani‑ni lagwi gele. De nuha nna laka sa ruden xiani‑ni gele, gwalugwela lele kini abittu udaxxu elaha le, kumu nu reki lhe'e chulhaha, labí yu nuha gaxa diana. ");
INSERT INTO zae_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Laxkala gwaltsia lele ge benne anke xiani‑ni laka sa doe len lebi'i, kini anáchu nna akale gebie. Nuha‑ba ra Jesús‑ni nna deyye bekatsi lobie gekani. ");
INSERT INTO zae_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Meskiba chi ben Jesús‑ni ixe ka milagru arlo ka benne, ttaka labí ria leke gebie. ");
INSERT INTO zae_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Aníha uka ki gwado tisa ge nu unne profeta Isaías‑ni tti ree Tata Xisiha: Nurula chi ugía leni ge nu rigixxi'atu‑ni xa tata, lhe nurula nu chi bele'enlu nu xxeni ra lelu lhe. ");
INSERT INTO zae_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Labí uka tsia lekani ge Tata Xisiha, kumu attiba ra Isaías‑ni attu lisia lo ka yetsi ge Tata Do Yebáha, tti rana: ");
INSERT INTO zae_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Bechulhaba Tata Do Yebáha lokani lhe ben tsitsibe lastokani, kini meskiba yu'u lokani, abittu bilákinna, lhe meskiba tee elha rieni gekani nna abittu utte dákinna. Aníha benkana kini ka eyekikana odaxxukana neda kia nna eyonia kana, ra Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías‑ni unnena aníha kumu chiba bilenna nu xxeni inná le Jesús‑ni ganna chi bisie. De nuha nna utixxi'ana gebie. ");
INSERT INTO zae_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Laa kiga de nuha nna ixeba ka nu Israel‑ni ugía lekani ge Jesús‑ni, axtala ka nu rinnabia gekaniha ugía lekani. Ttaka kumu de rasikinna ge ka fariseo‑ni, de nuha nna labí rigixxi'akana kini ka kweakana kana lhe'e ka yo'o ata rudhetikana ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kumu ru'urula lekani eya'an tsekana arlo ka benne attichula arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús‑ni nna unnebie idisa, ree: ―Benne ria lebie netiha, labí sun neti nuha ria le benneha, sinuki riagaba lebie benne udhelhe netiha, ");
INSERT INTO zae_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","nna benne rilánie netiha, benne udhelhe netiha nuha rilen benneha. ");
INSERT INTO zae_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Neti ankaa xiani bisiaya yiesi lo yu‑ni kini iyába ka benne tsia leke neti abittu tse'eke ata anka chulhaha. ");
INSERT INTO zae_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nu iyieninna ka tisa kia‑ni nna abittu uinna nu rákana, labí neti ukinnia nuha, kumu neti laa dagaa gwerixxi gwekinni ka benne, sinuki dalaa kini odiláya ke. ");
INSERT INTO zae_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nu rigu'u ni'ani netiha lhe abittu rulabina ka tisa kia‑ni, chiba do nu ukinnina nuha, delába ka tisa chi unnea‑ni, ka tisa‑niba urixxi ukinnikana nuha ganna chi isia sá daluxaha. ");
INSERT INTO zae_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kumu neti labí rinnea nu anka kia. Tata kia benne udhelhe netiha, benneha‑ba chi rabie neti bixa innía lhe gasina innea lhe. ");
INSERT INTO zae_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Neti yúgabaa deki nu ra benneha uinri'i, nuha uinna kini satíaba aka ben ka benne. Laxkala nu rinnea‑ni, rinnebaa na attiba chi ra Tata kiaha. ");
INSERT INTO zae_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Atti lani isia laní Pascuaha, yuba Jesús‑ni deki chiba bisia ura edábie yiesi lo yu‑ni nna esine ata do Tataha. Aníha‑ba ttiba ukanie ge ka benne gebie se'e yiesi lo yu‑ni, aníha‑ba sa ukanie geke axtaba tti chi uttieha. ");
INSERT INTO zae_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tti chi se'eke go irseha, chi galá uxí yie nu xxegwiha Judas Iscariote xi'in Simón‑ni, ki utene lasi ná ka nu uttikaneha. ");
INSERT INTO zae_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús‑ni, kumu chiba yubie deki Tata Do Yebáha, iyába chi betebie lasi nábie lhe yube deki ata do Tataha‑ba birie nna bisie yiesi lo yu‑ni lhe ata do benneha‑gaba esine lhe, ");
INSERT INTO zae_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","de nuha nna loora se'eke go irseha, udú liie nna utuabie lari nukueha, nianna tti bedaxxue ttu lari bexxika lhe'ebie. ");
INSERT INTO zae_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nianna tti uta'abie inda lhe'e ttu xiga nna uduloe utíe ni'a ka benne rudhetinieha nna bodibisie ka nuha len lari xika lhe'eeha. ");
INSERT INTO zae_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tti chi diabie kíe ni'a Simón Pedro‑ni, lana nna rane: ―Labí dika lula kílu ni'aya xa tata. ");
INSERT INTO zae_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús‑ni nna bekabie geni, ree: ―Labí tte denlu bixa nuní runia nnanna, ttaka deloliba nna tte denlu nuní. ");
INSERT INTO zae_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro‑ni nna rane: ―¡Netiligaba nna labí dhielhaa kílu ni'aya! Jesús‑ni nna ree na: ―Ganna abíba dhielhalu kía ni'alu, labíru akalu kia. ");
INSERT INTO zae_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nianna ra Pedro‑nie: ―Ganna niha, nna labí sun ka ni'aya‑ni kílu, kígabalu ikia‑ni lhe ka náya‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús‑ni nna ree na: ―Ttu benne chi udi labíru riyasin benneha gadie attu libe, a sun ka ni'abe ití, kumu itúba benneha chi anke nari xú nna lebi'i chiba beyarile arlo Tata Do Yebáha, meskiba laa iyále chi beyari. ");
INSERT INTO zae_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kumu yube nuxakana nuha utekane lasi ná ka nu uttikaneha, de nuha nna rabie kana: “Labí iyále chi beyari.” ");
INSERT INTO zae_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Iki de chi utíbie ni'a ka benneha, nianna tti beyokue lari nukueha nna bedobie ro'o mexaha nna ree ke: ―¿Si gwa rite denle bixa nuní bedhakaa le? ");
INSERT INTO zae_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Lebi'i tenle láya Maestru lhe rale deki ankaa Xxanale lhe. Gwalíbinle kumu neti gwalíba ankaa nu rale‑na. ");
INSERT INTO zae_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ki neti ankalaa Xxanale lhe Maestru gele nna chi utía ka ni'ale‑na, anágaba lebi'i teeki kí ni'a luesile. ");
INSERT INTO zae_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Neti chi bele'enia le nuní, kini attiba benia utía ni'ale, anágaba uinle. ");
INSERT INTO zae_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Netiru ria, nu ren sina lo xxananiha labí xxenirula ra le nuha attichula xxananiha. Nigaba nu reki mandaduha, labí xxenirula ra le nuha attichila nu ruinna na mandaduha. ");
INSERT INTO zae_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Lebi'i ganna rite denle nu ria‑ni, karubárule ganna tse'ele uinle aní. ");
INSERT INTO zae_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Labí iyále nuní xpeya aní; kumu neti yu xeabaa gá se'e ka benne chi ulesia ke ki akake kia. Ttaka teeki sado tisa ge nu ra lo ka yetsi ge Tata Do Yebáha, ata dia ra: “Nu dona go yetta turo'o len netiha, la labana beyekina bebi'i noona neti.” ");
INSERT INTO zae_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nnannali chi rigixxi'ania le nuní tti lanila akana, kini ganna chi ukanaha, la'ania nna tsia lele deki neti nuha ankaa Cristu. ");
INSERT INTO zae_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Netiru ria, nu ulabina benne idhelhaaha, neti nuha ulabi nuha nna nu ulabina netiha nna benne udhelhe netiha nuha ulabina. ");
INSERT INTO zae_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iki de ra Jesús‑ni aníha, nianna tti bedú si'i xxattana lebie nna ree: ―Netiru ria, nuxa ttúle nuní utele neti lasi ná ka nu uttikana neti. ");
INSERT INTO zae_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ka benne rudhetinieha nna udulo ttebake rugía lo luesike, kumu labí yuke nuxa geke nuha rinnebie. ");
INSERT INTO zae_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ttu ka benneha, benne raka xxattani Jesús‑ni geeha, doe gaxxaba kwe'ebie tti yu'uke go irseha. ");
INSERT INTO zae_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Benneha nuha betten ná Simón Pedro‑ni kini innaba tise Jesús‑ni nuxa geke nuha rinnebie. ");
INSERT INTO zae_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Benneha nna ubigarue gaxxa kwe'e Jesús‑ni nna unnaba tise bie, ree: ―¿Núlatu nuní xa tata? ");
INSERT INTO zae_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús‑ni nna bekabie ree: ―Nu ugwea na yettaxtila odibidhaa ikini, lana nuha utena neti lasi ná ka nu uttikana netiha. Nianna tti bodibidhe iki yettaxtilaha nna begwebie Judas Iscariote xi'in Simón‑ni. ");
INSERT INTO zae_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tti chi utona yettaxtilaha nna uta'a tteba nu xxegwiha lhe'e lastoni, nianna tti ra Jesús‑ni na: ―Tsa ttela beni nu chi re lelu uinlu. ");
INSERT INTO zae_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ttaka ni ttú ka benne se'e lenie ro'o mexaha, a ute dákanie beaka rabie na aníha. ");
INSERT INTO zae_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kumu de Judas‑ni denna beduti to yu'u belhiu gekeha, laxkala ttu chupake rakakanie ganna raba Jesús‑ni na: “Ugía gwayo'o nu ixuinri'i laní‑ni” o ree na: “Begwe ka benne dii abittu geke tee latti belhiu.” ");
INSERT INTO zae_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Iki de chi beyaka uto Judas‑ni yettaxtilaha, nianna tti biria ttebana diana. Chiba anka rela nuha la'ania. ");
INSERT INTO zae_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nianna iki de chi biria Judas‑ni diana, nianna ra Jesús‑ni: ―Neti benne daya yebáha nnanna chi ula'a nu xxeni ra lasia, lhe de neti nna ula'a nu xxeni ra le Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ganna neti ule'a nu xxeni ra le Tata Do Yebáha, anágaba Tata Do Yebáha nna ule'egabe nu xxeni ra lasia nna chi tte duna ule'ebie nu xxeni ra lasia. ");
INSERT INTO zae_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Xi'ini to kia, attu satti toruba gwadoa len lebi'i, nianna tti egilale neti. Nnanna upeya le nu chigaba xpeya ka nu loni ge ka benne Israel‑ni: Ata eya'ayaha, lebi'i labí aka esiale niha. ");
INSERT INTO zae_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ttu tisa kubi rodha'anaa len lebi'i ki uinle nu rana, delába akin ge luesile. Lebi'i teeki akin ge luesile attiba neti rakati gele. ");
INSERT INTO zae_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ganna rakani ge luesile, la'ania nna iyába ka benne tte dákanie deki lebi'i chiba ankale benne rudhetinia. ");
INSERT INTO zae_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro‑ni nna unnaba tisana Jesús‑ni, rane: ―¿Gála tsialu xa tata? Jesús‑ni nna bekabie geni, ree: ―Ata eya'ayaha, lu labí aka etenalhalu neti nnanna, ttaka delola nna gwetabalu len neti. ");
INSERT INTO zae_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro‑ni nna rane: ―¿Beakala labí aka etanalhaa kwinalu nnanna xa tata? ¡Neti chiba beria iki beria lasia gattia kwenta gelu! ");
INSERT INTO zae_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús‑ni nna bekabie geni, ree: ―¿Si gattilu kwenta kia? Netiru ria, lanila kwesi chinkaha, lu tsunna libela chi bedhea lelu abittu ridí ro'olu deki ankabienlu neti. ");
INSERT INTO zae_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Bittu udú xxattana le, gwaluxxen lele ge Tata Do Yebáha lhe gwaluxxengaba lele kia lhe. ");
INSERT INTO zae_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lhe'e lisi Tata kiaha ixe ka yo'o sia ata tse'e ka benne. Ganna ttixka abíba sia, la'ania nna abittula xpeya le ten tsea ata tse'ele. ");
INSERT INTO zae_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ganna chi eya'aya ten tsea ata tse'ele, la'ania nna dedáya attu libe nna echea le len neti kini ata dhoaha, niha‑gaba tse'ele. ");
INSERT INTO zae_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Lebi'i chiba ankabienle neda deyya ata eya'ayaha. ");
INSERT INTO zae_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás‑ni nna rane: ―Labí yutu gá eyyalu xa tata. Laxkala, ¿gasina uinbiatu nedaha? ");
INSERT INTO zae_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús‑ni nna bekabie, ree na: ―Netiba nuha ankaa nedaha lhe netiba nuha ankaa benne rigixxi'aya ge nu anka gwalí lhe ankaa benne runia ki satíaba raka ben ka benne lhe. Lanú nu aka geni tsiana ata do Tataha ganna abíba neti echea na. ");
INSERT INTO zae_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ganna ttixka lebi'i chi yule nuxa gwalíga ankaa, la'ania nna chigaba yule nuxa anka Tata kiaha nna nnannali chi ankabienle benneha lhe chi bilenlee lhe. ");
INSERT INTO zae_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nianna tti unne Felipe‑ni, rana: ―Tata Xisi to, bele'en ri'itu Tataha nna ukare'aba ilentue nna eyaka xen letu. ");
INSERT INTO zae_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús‑ni nna bekabie, ree: ―Ki isába chi reki lenia le xa Felipe, ¿si itua ttu nna a ruinbiale neti? Benne chi bilánie neti, chigaba bilen benneha Tataha. ¿Gasina nuha nna rálalu: “Bele'en ri'itu Tataha”? ");
INSERT INTO zae_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Si lagwa gwa ria lelu deki neti ttúba benne ankaa len Tataha nna Tataha nna ttúba benne anke len neti? Ka tisa rinnea‑ni nna labí nu anka kia ka nuní rinnea; sinuki nu anka ge Tataha benne doe lhe'e lastoa‑niba nuní rinnea. Labe runie iyá nu runia‑ni. ");
INSERT INTO zae_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gwaltsia lele deki neti ttúba benne ankaa len Tataha nna Tataha ttúba benne anke len neti. Ganna abíba ria lele kia, kwadi ge ka nu rilenle runia‑ni gwaltsia lele. ");
INSERT INTO zae_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Netiru ria, nu gweyya leni netiha gwingaba nuha ka nu runia‑ni nna xxenirula anka ka nu uin nuha, kumu neti eya'abaa ata do Tataha. ");
INSERT INTO zae_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Lhe anágaba iyába nu innabale len Tataha tti udettile neti, neti nna gwinbaa nu innabaleha kini anáchu de neti benne ankaa Xi'inieha, de neti nna inná xxeni le Tataha. ");
INSERT INTO zae_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Bixaba innabale ganna udettile neti, neti nna gwinbaa nu innabaleha. ");
INSERT INTO zae_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Ganna lebi'i rakinle kia, la'ania nna gudobale tisa ge nu runia mandadu. ");
INSERT INTO zae_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Neti nna innabaa len Tataha ki idhelhe attu benne aka lenie le kini benneha nna dhoe lenle ttu dia lii, ");
INSERT INTO zae_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","delába idhelhe Espíritu benne kixxi'abie ge nu anka gwalí. Ka nu labí ria lekani, labí ulabikana Espírituha, kumu de labí chi bilákinne, nigaba a yúkana nuxa anke. Ttaka lebi'i chiba yule nuxa anka benneha kumu labie nuní doe len lebi'i lhe dhobie lhe'e lastole lhe. ");
INSERT INTO zae_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Labí odha'anaa le ttiba ttu bidabi, gwesiaba neti dhoa len lebi'i attu libe. ");
INSERT INTO zae_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ka benne abí ria leke kia, attu sattitoruba ilákanie neti, lengwa nna labíru edelákanie neti, ttaka lebi'i nna gwalábinle neti. Kumu neti anka benbaa, anágaba lebi'i gwaka bengabale. ");
INSERT INTO zae_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tti isia sá esiayaha, la'ania nna tte denle deki neti ankaa ttúba benne lenia Tata kiaha; lebi'i nna akale ttúba benne len neti, neti nna akaa ttúba benne len lebi'i. ");
INSERT INTO zae_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Benne chi biyieninie nu runia mandadu nna rudoe tisa geni, benneha nuha gwalíganie rakanie kia nna benne rakanie kia nna gwakagabani Tata kiaha gebie. Anágaba neti akagabati gebie lhe ule'egabanie nu gwalíga ankaa lhe. ");
INSERT INTO zae_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nianna tti ra Judas‑ni (labí Judas nu rákana Iscariote) rane: ―Tata Xisi to, ¿beakala len ri'itu ule'elu nu ankalu nna a ule'elu nu ankalu‑na len adíru ka benne? ");
INSERT INTO zae_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús‑ni nna bekabie geni, ree: ―Benne akanie kia, gudoba benneha tisa ge nu chi rigixxi'anie. Tata kiaha nna gwakagabanie ge benneha, la'ania nna ri'itu isiatu ki tse'etu lhe'e lastoe. ");
INSERT INTO zae_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nu abí rakinna kiaha, nuha labí rudona tisa ge nu rigixxi'ania na. Ka tisa chi riyieninle‑ni nna labí nu anka kia ka nuní rinnea, sinuki ankaba ka nuní ge Tataha, benne udhelhe netiha. ");
INSERT INTO zae_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Iyá nuní rinnea rigixxi'ania le nnanna laka sadoa len lebi'i, ");
INSERT INTO zae_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ttaka Espíritu benne ite ki aka lenie leha, benneha idhelha Tataha bie kini innebie kwenta kia. Labie ule'enie le iyá tte lhe odhúbie lele iyá nu chi utixxi'ania le lhe. ");
INSERT INTO zae_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Neti unia kini tse'ele xen su lasi. Elha xen lasi nu rutea len lebi'i labí anka nuná luesi nu rute ka benne se'e yiesi lo yu‑ni. Bittu udúna le lhe nigaba a gasinle lhe. ");
INSERT INTO zae_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Lebi'i chiba biyieninle ria: “Eya'abaa, delola nna gwedesiabaa len lebi'i.” Ganna si gwalíginle rakinle kia, la'ania nna gwedeakabinle de eya'aya ata do Tataha, kumu Tataha xxenirula ra le benneha tti neti. ");
INSERT INTO zae_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nnannali chi rigixxi'ania le nuní, kini ganna chi deya'ayaha, la'ania nna tsia lele kia. ");
INSERT INTO zae_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Labíru isá innea len lebi'i, kumu chiba daa nu xxegwi rinnabiana yiesi lo yu‑ni, neti niru latti labí dhaa nuha innabiana neti. ");
INSERT INTO zae_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ttaka aní teeki aka kini tte dani ka benne deki neti gwa rakabati ge Tataha, lhe gwa ruinbaa nu chi bedha'ane unia lhe. ’Nnanna nna gwaledú lii kini chi diari'i. ");
INSERT INTO zae_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Neti nuní ankaa ya uva nu gwalíga anka tse. Tata kiaha nna anke benne rugwe lebie ya uvaha. ");
INSERT INTO zae_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Iyába ka ná ya uvaha ka nu abittu runna nu xixxi, richúbe kana, ttaka iyába ka náni ka nu gwa rutekana nu xixxi, richúbe lokani lhe ruxíbe nu bisi gekani kini ute chiettirukana nu xixxi. ");
INSERT INTO zae_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ttiba ka ná ya uvaha chi biria nu bisi gekani, aníha‑gaba nuná lebi'i, de ka tisa chi utixxi'ania leha, de ka nuha nna chiba beyarile. ");
INSERT INTO zae_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Lebi'i, gwaltse'e len neti nna anágaba neti gwadúgabaa len lebi'i. Ttiba ka ná ya uvaha, ganna abíba yietikana lati yagaha, labí aka ute ka nuha nu xixxi, anágaba lebi'i, ganna abíba se'ele len neti, labí aka gele uinle nu anka tse. ");
INSERT INTO zae_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Neti nuní ankaa ya uvaha, lebi'i nna ankale ka náya. Benne gwa du lenie netiha, neti nna gwa dúgabaa lenie nna ixeba nu tse unie, kumu ganna lebi'i abíba du lenle neti, labí aka gele bixa uinle. ");
INSERT INTO zae_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nu abíba du lenna neti, nuha iru'unabana. Satebana attiba ka ná yagaha; ka nuha rirúbakana nna ribisibakana, nianna tti ritupakana nna riakana lo giha. ");
INSERT INTO zae_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Ganna lebi'i gwa se'ebale len neti lhe gwa ruinbale nu ra ka tisa kia‑ni, la'ania nna gwalinnababa bixaba raka lele nna gwadíbale nu rinnabaleha. ");
INSERT INTO zae_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tata kiaha nuha inná xxeni lebie ganna lebi'i uinle ixe nu anka tse. Aníha nuha nna gwasinle akale benne gwalíga rudhetinia. ");
INSERT INTO zae_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Attiba rakani Tataha kia, anágaba rakati gele. Laxkala gwaltse'e len neti bittu udhanle neti kini edí baale elha si'i lasi kia. ");
INSERT INTO zae_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ganna udole tisa ge nu odha'anaa uinle, la'ania nna gwedí baabale elha si'i lasi kia, attiba neti gwa redí baaba elha si'i lasi ge Tata kiaha kumu gwa rudobaa tisa ge nu bodha'ane unia. ");
INSERT INTO zae_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ria aní kini lebi'i edú itta lele len neti, aná nna itta suba edú lele. ");
INSERT INTO zae_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Akani ge luesile attiba neti rakati gele. Nuní rodha'anaa uinle. ");
INSERT INTO zae_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Benne gwa reria lebie gattie kwenta ge ka benne se'e tse lenie, benneha nuha gwa rakarunie ge ka benneha. ");
INSERT INTO zae_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lebi'i nuha ankale benne do tse lania ganna ttixka uinle nu ria. ");
INSERT INTO zae_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Labíru kixxaa lále nu reni lo sina kia, kumu nu reni lo sinaha, labí yu nuha bixa ruin xxananiha. Neti chi teeti lále benne do tse lania kumu iyába nu chi ra Tata kiaha neti, chiba utixxi'ania le nuha. ");
INSERT INTO zae_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Laa lebi'iga bekwele neti; netila bekwea le nna chi beka'anaa le ki tsiale uinle nu anka tse nna nu tse uinleha nna uchíana isá. Aníha kini iyába nu innabale len Tataha tti udettile neti, benneha nna gutebe nu innabaleha. ");
INSERT INTO zae_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Akin ge luesile. Nuní rodha'anaa uinle. ");
INSERT INTO zae_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Ganna ka nu abittu ria lekani neti ritisikinna le, gwaludhá lele ki netila bitisikinna lade'a tte. ");
INSERT INTO zae_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ganna lebi'i ankale ge ka nu abittu ria lekani neti, la'ania nna gwakalakinna gele attiba rakakinna ge ka benne gekani, ttaka lebi'i labí ankale gekani; neti chi bekwea le lagwi gekani, de nuha nna ritisikinna le. ");
INSERT INTO zae_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gwalodhú lele ge nu chi xpeya leha. Nu ren sina lo xxananiha labí xxenirula ra le nuha tti xxananiha. Ki neti chi udú nookana, anágaba lebi'i dhu noogabakana le, lhe gannala ttixka bedo nagakani kia, la'ania nna lebi'i gudogaba nagakani gele. ");
INSERT INTO zae_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Iyá nuní udhakakana le de ria lele neti, kumu lakana labí ankabiakinna benne udhelhe netiha. ");
INSERT INTO zae_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Ganna neti abíba bisiaya yiesi lo yu‑ni lhe ganna abíba utixxi'ania kana ka tisa ge Tata Do Yebáha, la'ania nna abittula nujakana yua ge ka tulha ruinkana ganna ttixka. Ttaka de chi utixxi'ania kana, de nuha nna labí tee ro'okani innákana: “Labí yutu ge ka tulha ruintu.” ");
INSERT INTO zae_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nu ritisinna netiha, ritisigabin nuha Tata kiaha. ");
INSERT INTO zae_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ganna ttixka neti abíba chi benia ka milagru lagwi gekani, ka milagru ka nu abittu chi ben nuxa attu benne, la'ania nna abittula nujakana yua ge ka tulha ruinkanaha ganna ttixka. Ttaka chiba bilákinna; laa kiga de chi bilákinna benia ka milagruha nna sa ritisibakinna neti lhe ritisigabakinna Tata kiaha lhe. ");
INSERT INTO zae_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ttaka teeki raka aní kini rado tisa ge nu ra lo bia bennabi gekaniha ata dia ra: “Labí bixa ge nna kwentaba bitisikinna neti.” ");
INSERT INTO zae_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Ttaka neti nna idhelhaa benne aka lenie le, delába Espíritu benne rigixxi'abie ge nu anka gwalíga. Ata do benneha‑li iria Espírituha dabie, nna kixxi'abie kia. ");
INSERT INTO zae_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Anágaba lebi'i kixxi'agabale kia, kumu lebi'i attili sisi'a tte uduloa rule'enia ka benne, la'aniali chi se'ele len neti. ");
INSERT INTO zae_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Rigixxi'ania le nuní kini abittu eyadi gaale nna a tsiaru lele kia. ");
INSERT INTO zae_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tse'e ka nu ebeakana le lhe'e ka yo'o ata rudhetile ka tisa ge Tata Do Yebáha, labíru ugwelhakana le ga'ale niha. Axtala isia sáha ka nu uttikana leha akakinna deki gwa ruinbakana nu ru'u le Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Aníha uinkana kumu de labí chi anka biakinna Tataha, lhe nigaba labí chi ankabiakinna neti lhe. ");
INSERT INTO zae_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Rigixxi'ania le nuní kini ganna chi bisia sá satele aní, la'ania nna sadú lele deki chiba utixxi'ania le nuní. ’Labí utixxi'ania le nuní sisi'a tteha, kumu len lebi'iba doa. ");
INSERT INTO zae_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ttaka nnanna chi eya'aya ata do benne udhelhe netiha nna niba ttúle a rinnaba tisale neti, innále: “¿Gá eyyalu?” ");
INSERT INTO zae_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Rutse'e loona rudú si'ilana lele de rigixxi'ania le nuní. ");
INSERT INTO zae_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ttaka netiru ria: tserula saríana le ganna eya'aya. Kumu ganna abíba eya'aya, Espíritu benne aka lenie leha labí isia benneha len lebi'i. Ttaka ganna eya'aya, la'ania nna neti idhelhe ki ite. ");
INSERT INTO zae_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tti isia benneha nna unie ki okinni iki ka benne deki ankabake benne ruin tulha lhe deki labí ruinke attiba ankaba geni lhe. Anágaba unie ki utte dáke deki ukinniba Tata Do Yebáha ke. ");
INSERT INTO zae_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Unie kini utte dáke deki ruinke tulha de labí ria leke kia ");
INSERT INTO zae_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","lhe unie kini utte dáke deki neti nuha ankaa benne runi nu dika ixú nna chiba eya'aya ata do Tataha nna labíru ilenle neti, ");
INSERT INTO zae_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","lhe anágaba unie kini utte dáke deki ibixxi iginniba ka nu ruin tulha‑na, kumu nu xxegwi nu rinnabia yiesi lo yu‑ni chiba berixxi bekinni Tataha nuha. ");
INSERT INTO zae_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ixeru nu teti upeya le, ttaka nnanna labí dhaale tte denle iyá nu rigixxi'ania le. ");
INSERT INTO zae_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ttaka atti isia Espíritu benne kixxi'abie ge nu anka gwalíga, Espírituha ule'enie le iyá nu anka gwalí, kumu labí inne benneha nu anka gebie, sinuki innebe nu iyienibanie ra Tataha lhe kixxi'agabanie le iyá nu aka nu si daa lhe. ");
INSERT INTO zae_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Benneha unie kini inná xxeni lasia, kumu udaxxu ni'e nu rule'a‑ni nna kixxi'anie le. ");
INSERT INTO zae_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Iyába nu anka ge Tataha, kígabaa anka nuha. De nuha nna xpeya le: “Espírituha udaxxu ni'abie nu rule'a‑ni nna kixxi'anie le.” ");
INSERT INTO zae_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Attu sattitoruba nna labíru ilenle neti. Iki de nuha nna attu sattitoruba nna chi edelenle neti. ");
INSERT INTO zae_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ttu chupa ka benne rudhetinieha nna ra luesike: ―¿Bí dianie tti ree: “Attu sattitoruba nna labíru ilenle neti”; delo nna redenee: “Iki de nuha nna attu sattitoruba nna chi edelenle neti”? Lhe anágaba, ¿bí dianie tti ree: “Chiba eya'aya ata do Tataha”? ");
INSERT INTO zae_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Lhe rágaba luesike, ¿bí dianie tti ree: “Attu sattitoruba”? Kwachiruba rite denri'i nu rinnee‑na xa. ");
INSERT INTO zae_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús‑ni nna ute dábanie deki raka le ka benneha innaba tisake bie ge nu chi reeha, nianna tti rabie ke: ―¿Si rinnaba tisa luesile, rale: “Bí diani nu ria‑ni tti ria: Attu sattitoruba nna labíru ilenle neti; iki de nuha nna attu sattitoruba nna chi edelenle neti”? ");
INSERT INTO zae_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Netiru ria, lebi'i kwesibale lhe elenibinle ge nu satea, ttaka ka nu se'e yiesi lo yu‑ni edeakalakinna. Lebi'i nna udú si'ilana lele, ttaka delola nna gwedú ittaba lele. ");
INSERT INTO zae_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ttiba nuila gali xi'inniha ruyúbana elha disa kumu chiba bisia ura gali nutoha, ttaka iki de chi uli nutoha, la'ania nna labíru radú leni ge elha disa biyúnaha, kumu si redeakalinna de chi bisia attu benne yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Anágaba lebi'i du si'iba lele nnanna, ttaka neti gwetabaa etelannia le, la'ania nna edú itta lele nna lanú nu dhaana kuana elha gwedeaka lasi geleha. ");
INSERT INTO zae_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","La sáha labíru bi innaba tisale neti. Netiru ria, iyába nu innabale len Tataha ganna udettile neti, benneha nna gutebe nu rinnabaleha. ");
INSERT INTO zae_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Axta nnanna labí chi unnabale udettile neti. Gwalinnaba nna gwadíbale, kini anáchu nna itta suba edú lele. ");
INSERT INTO zae_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Nnanna ttiba bixxi kwe'eba nuní rinnea, ttaka isia sá labíru innea aní, sinuki lhixxa rába chi innea kixxi'ania le ge Tataha. ");
INSERT INTO zae_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","La sáha lebi'iba chi innabale len Tataha udettile neti, labíru neti teeki innabaa gele arlo benneha. ");
INSERT INTO zae_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kumu kwinaba Tataha rakanie gele. Rakanie gele kumu lebi'i chi rakinle kia lhe anágaba kumu chi ugía lele deki gwalí ata do Tataha‑ba biriaya daya. ");
INSERT INTO zae_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ata do Tataha‑ba biriaya daya nna bisiaya yiesi lo yu‑ni, nnanna nna udha'anaa yiesi lo yu‑ni nna eya'aya ata do Tataha. ");
INSERT INTO zae_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ka benne rudhetinieha nna ráke bie: ―Nnannaligaba lhixxa rába chi rinnelu, labíru rinnelu bixxi kwe'e. ");
INSERT INTO zae_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nnanna chi rite dentu deki labí riyasinlu nuxa innaba tisana lu kumu iyába yulu. De nuha nna chi ria letu deki ata do Tata Do Yebáha‑ba birialu dalu. ");
INSERT INTO zae_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús‑ni nna bekabie geke, ree: ―¿Si nnannaliba chi ria lele? ");
INSERT INTO zae_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ttaka chiba isia ura nuní, nnanna nuha chi bisia uraha, lebi'i nna gatti chadhibale kua ttu ttubale udaxxu neda gele. La'ania nna ttu túbibaa udúle, ttaka labí ttú neti dua; Tataha gwa duba benneha len neti. ");
INSERT INTO zae_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Rigixxi'ania le nuní kini xen su lasiba tse'ele de du lenle neti. Yiesi lo yu‑ni satebale uyúle elha disa, ttaka tsitsi gwalikweki lele, kumu neti chiba udaaya lo iyá nu satsa raka yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iki de chi unne Jesús‑ni nuha, nianna tti belhidha loe yebáha nna ree: ―Tata, chiba bisia ura nuní. Neti benne ankaa Xi'inlu, bele'e nu xxeni ra lasia, kini anágaba neti ule'a nu xxeni ra lelu, ");
INSERT INTO zae_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","kumu lu chi betelu lo neda kia kini innabiaya iyá ka benne, kini anáchu unia ki satíaba aka ben iyá ka benne chi betelu lasi náya. ");
INSERT INTO zae_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ganna ka benne chi benbiake lu deki ankalu gwalíga ttu túbiru Diosi lhe ganna chi benbiake neti Jesucristu benne udhelhalu yiesi lo yu‑ni, la'ania nna ka benneha satíaba aka benke arlolu. ");
INSERT INTO zae_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Neti chiba bele'a nu xxeni ra lelu yiesi lo yu‑ni, chiba uluxati sina nu bedha'anlu unia. ");
INSERT INTO zae_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nnanna nna xa Tata, ben kini neti eyakaa benne ra xxeni lasia arlolu, ben ki eyakaa atti tteba ankaa tti doa lenluha atti lanila kwe yiesi lo yu‑niha. ");
INSERT INTO zae_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ka benne chi bekwelu lagwi ge ka benne se'e yiesi lo yu‑ni nna betelu ke len neti, ka benne‑ni chiba bele'enia ke nuxa ankalu. Gebalu ankake nna betelu ke len neti. Lake nna gwa rudobake tisa ge nu ralu. ");
INSERT INTO zae_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nnanna chiba yuke deki iyába nu betelu len neti, luba betelu nuha, ");
INSERT INTO zae_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kumu ka tisa betelu len netiha chiba utixxi'ania ke ka nuha nna gwa belabibake ka tisaha. Nnanna nna chiba yuke deki gwalíba ata dolu‑naba biriaya daya lhe chigaba ugía leke deki luba udhelhalu neti. ");
INSERT INTO zae_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ge ka benne‑ni rinnabaa lenlu xa tata. Labí rinnabaa ge ka nu abittu ria lekani neti, sinuki rinnabaa ge ka benne betelu len neti, kumu gebalu ankake. ");
INSERT INTO zae_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Iyába ka benne ankake kia, gegabalu anka ka benneha lhe iyába ka benne ankake gelu, kígabaa anka ka benneha. De ka benneha nna rule'e nu xxeni ra lasia. ");
INSERT INTO zae_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Neti labíru dhoa yiesi lo yu‑ni, ttaka lake tse'erubake. Neti nna esiabaa ata dolu‑na xa Tata. Lu ankalu nari xú, labí tulha ruinlu. De nuha nna ka benne chi betelu len neti, biyú ke len nu ra tsitsi lelu‑na kini anáchu akake ttúba benne attiba ri'i ankari'i ttúba benne. ");
INSERT INTO zae_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tti doa lenke yiesi lo yu‑niha, gwa biyúbaa ke len nu ra tsitsi lelu. Ka benne betelu len netiha, gwa biyúbaa ke nna ni ttúke labí binittike, sun ttúba nu chi ga'anna inittiha, binittina. Aníha uka kini gwado tisa ge nu ra lo ka yetsi geluha. ");
INSERT INTO zae_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Nnanna chiba esiaya ata dolu‑na, ttaka laka sa doa yiesi lo yu‑ni rigixxi'aya nuní kini lake nna itta suba dhu leke attiba neti itta suba du lasia. ");
INSERT INTO zae_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Neti chiba utixxi'ania ke ka tisa gelu‑ni, ttaka ka nu se'e yiesi lo yu‑ni ritisilakinna ke kumu de labí ankake ge yiesi lo yu‑ni, attigaba neti labí ankaa ge yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Labí rinnabaa kwealu ke lagwi ge ka benne se'e yiesi lo yu‑ni, sinuki odilálalu ke lo ná nu xxegwiha. ");
INSERT INTO zae_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Lake labí ankake ge yiesi lo yu‑ni, attigaba neti labí ankaa ge yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ka tisa gelu‑ni ankake nu gwalí. Beni kini, tti iyienkanie ka tisa‑ni nna iriesike akake gelu. ");
INSERT INTO zae_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Attiba kwinalu udhelhalu neti yiesi lo yu‑ni, anágaba neti ridhelhaa ke yiesi lo yu‑ni ki kixxi'ake ka tisa gelu. ");
INSERT INTO zae_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","De lake nna neti biriesia ki ixúa lo sina gelu, kini anágaba lake iriesigabake ki ixúke lo sina gelu de ria leke ge nu anka gwalí. ");
INSERT INTO zae_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Labí sun ge ka benne‑ni rinnabaa len kwina lu. Anágaba rinnabagabaa ge ka nu tsia lekani kia tti iyienkinna ka tisa kixxi'a ka benne‑ni, ");
INSERT INTO zae_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","kini anáchu nna iyába ka nu tsia lekani kia ttisidiba ttúba benne eyakakana, attiba lu xa Tata, ttúba benne ankalu len neti, neti nna ttúba benne ankaa lenlu. Anágaba ka nu tsia lekaniha, ttúba benne eyakakana len ri'i, kini anáchu adí ka nu a ria lekani nna tsia lekani deki luba udhelhalu neti. ");
INSERT INTO zae_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Neti chiba benia kini inná xxeni le ka nu tsia lekani kia attiba lu chi benlu ki uná xxeni lasia, kini akakana ttúba benne attiba lu len neti ttúba benne ankari'i. ");
INSERT INTO zae_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Lu dulu len neti; neti nna dhua lenkana, kini lakana nna gwalíga isinkana eyakakana attisidiba ttúba benne, kini anáchu adíru ka benne se'e yiesi lo yu‑ni tte dákanie deki luba udhelhalu neti lhe gwa rakabinlu ge ka nu tsia lekani kia attiba rakabinlu kia. ");
INSERT INTO zae_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Ka nu chi betelu len neti xa Tata, raka lasia ata dhoaha, niha‑gaba tse'ekana, ki ilákinna nu xxeni ra lasia nu chi betelu len neti, kumu lu rakinlu kia attili lani kwe yiesi lo yu‑niha. ");
INSERT INTO zae_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata, lu ankalu benne runi attiba ankaba geni. Ka nu se'e yiesi lo yu‑ni labí chi ankabiakinna lu, ttaka neti chiba ankabiati lu. Ka nu chi betelu len neti chiba yúkana deki luba udhelhalu neti. ");
INSERT INTO zae_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Chiba utixxi'ania kana nuxa ankalu, anába sa kixxi'ania kana, kini anáchu attiba rakinlu kia, anágaba lakana akin ge luesikani. Neti nna dhoa lhe'e lastokani. ");
INSERT INTO zae_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iki de chi unne Jesús‑ni iyá nuha, nianna tti biriabie dia lenie ka benne rudhetinieha uteke attu ladu ge yoo bisi nu tee láni Cedrón. Niha tee ttu yu daa ka ya olivu loni. Lhe'e yu ata daa ka yagaha uta'a lenie ka benne rudhetinieha. ");
INSERT INTO zae_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas nu utena Jesús‑ni lasi ná ka nu uttikaneha chigaba ankabienna niha, kumu ixe lidúba chi ugía Jesús‑ni len ka benne rudhetinieha lhe'e yuha. ");
INSERT INTO zae_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Aníha uka nna bisin len Judas‑ni ka soldadu lhe ka nu rise'e gweyú ro'o yotuha lhe. Ka nuha udhelha ka nu loni ge ka bixxudiha kana lhe udhelha ka fariseo‑ni kana. Diakana denkana espada lhe yaga lhe dengabakana ka lámpara lhe ya nalha gi lhe. ");
INSERT INTO zae_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ttaka kumu Jesús‑ni chiba yubie iyá nu satebie, nianna biriabie gwatsee kana nna ree: ―¿Nú regilale? ");
INSERT INTO zae_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Lakana nna bekabikana, rákana: ―Jesús ge Nazaret‑niba regilatu xa. Jesús‑ni nna ree kana: ―Netiba nuní regilale. (Judas nu utene lasi ná ka nu uttikaneha, niha‑gaba dana len ka nuha.) ");
INSERT INTO zae_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tti ra Jesús‑ni kana: “Netiba nuní”, nianna tti beyadi gaakana nna ubixxi lokana lo yu. ");
INSERT INTO zae_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nianna tti bedennaba tise kana attu libe, ree: ―¿Nú regilale? Lakana nna redenákana: ―Jesús ge Nazaret‑niba xa. ");
INSERT INTO zae_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús‑ni nna bedekabie gekani, ree: ―Ki chiba ria le: “Netiba nuní.” Ganna neti regilale, gwalugwelhaxa ka nu rudhetinia‑ni eyyakana. ");
INSERT INTO zae_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Aníha uka kini gwado tisa ge nu chi unnebie, tti ree: “Tata, ka benne chi betelu len neti, ni ttú ka benneha labí bennittia.” ");
INSERT INTO zae_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nianna tti ulea Simón Pedro‑ni espada dennaha nna uchúna naga ben ge Malco‑ni. Malco‑ni ribenna lo sina ge nu anka bixxudi xeniha. ");
INSERT INTO zae_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús‑ni nna rabie Pedro‑ni: ―Boga'a espada gelu‑na lhe'e xoni. Neti, ¿katte si abí gwa dhielhaa uyúa elha disa nu ute Tata kiaha? ");
INSERT INTO zae_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ka soldaduha lhe nu loni gekaniha lhe ka nu rise'e gweyú ro'o yotuha lhe, ka nuha bedaxxukana Jesús‑ni nna bexxigakane. ");
INSERT INTO zae_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nianna tti dechekane lade'a tte arlo Anás‑ni, kumu lana ankana xxudi nuila ge Caifás. Caifás‑ni nuha anka bixxudi xeni lhe'e idaha. ");
INSERT INTO zae_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás‑ni nuha rana ka nu loni ge ka nu Israel‑ni: “Tserula saríana ri'i ganna sun ttúba benne gattie kwenta ge iyá ka benne.” ");
INSERT INTO zae_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro‑ni lhe attu ka benne rudhetinieha lhe danalhabake Jesús‑ni. Kumu ttu benneha, de ankabianie bixxudi xeniha, de nuha nna uta'abe len Jesús‑ni lali'a yo'o ge bixxudiha. ");
INSERT INTO zae_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ttaka Pedro‑ni nna beya'anbana ro'o yo'oha, labí uta'ana. Benne ankabianie bixxudi xeniha nna beriabie nna unne lenie nuila nu ruyúna ro'o yo'oha, kini begwelha nuha uta'a Pedro‑ni. ");
INSERT INTO zae_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nuilaha nna unnaba tisana Pedro‑ni, rana na: ―¿Laaba lu ankagabalu ttu ka nu rudhetini nubiyú‑na? Lana nna bekabina, rana: ―¡Ko'o! Labí. ");
INSERT INTO zae_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ka nu riben sina ge bixxudi xeniha lhe ka nu rise'e gweyú ro'o yotuha lhe, ka nuha bebekikana gi nna se'ekana gwetsa'a ro'o giha kumu yalhá idilha raka. Niha‑gaba du Pedro‑ni len ka nuha gwetsa'a ro'o giha. ");
INSERT INTO zae_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Bixxudi xeniha nna unnaba tisana Jesús‑ni ge ka benne rudhetinieha lhe ge ka tisa rekie rule'enie ka benne lhe. ");
INSERT INTO zae_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús‑ni nna bekabie geni, ree na: ―Neti la looba rinnea arlo ka benne. Satíaba udúa rule'enia ka benne lhe'e yotuha lhe lhe'e ka yo'o ata ritupa iyári'i ka benne Israel rudhetiri'i ka tisa ge Tata Do Yebáha. Labí bixa unnea gatsi. ");
INSERT INTO zae_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Beaka netila rinnaba tisalu? Unnaba tisa ka nu chi biyienkinna ge nu rinnea‑ni. Ka nuná gwa yúkana bixa chi ria. ");
INSERT INTO zae_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tti ra Jesús‑ni aníha, ttu ka nu rise'e gweyú ro'o yotuha, nuha duna gaxxaba ata dueha nna uleana gi ro'e nna rane: ―¿Si aná dika ekabilu ge benne anke bixxudi xeni‑na? ");
INSERT INTO zae_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús‑ni nna bekabie geni, ree: ―Ganna abíba unne tsea, utixxi'achu biunna a unne tsea. Ganna gwa unne tsebaa nna, ¿beakala bedhenlalu neti? ");
INSERT INTO zae_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nianna aníha‑ba xika Jesús‑ni udhelha Anás‑nie arlo Caifás nu anka bixxudi xeniha. ");
INSERT INTO zae_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedro‑ni nna niha‑ba sa duna ro'o giha rutsa'ana, nianna tti ra ka nu se'e niha na: ―¿Laaba luba nuha ttu ka nu danalhalu nubiyú‑na? Lana nna labí uxí ro'oni, rálana: ―¡Ko'o! Laa netiga nuha. ");
INSERT INTO zae_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ttu ka nu riben sina ge bixxudi xeniha, delába ttu nu datiana nu uchú Pedro‑ni naganiha, nuha rana na: ―¿Laaba ata daa ka ya olivuha‑ba biláti lu, du lenlu nubiyú‑na? ");
INSERT INTO zae_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro‑ni nna labí bededí ro'oni attu libe. Looraha tteba nna uresi chinkaha. ");
INSERT INTO zae_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Chebakana Jesús‑ni udá lenkane lhe'e lisi Caifás‑ni nna bisin lenkane lhe'e guskadu ata do nu rinnabia ge Roma‑ni. Ttaka kumu chiba daa tsani nuha, laxkala ka nu lo ge ka benne Israel‑ni labí uta'akana lhe'e guskaduha kini ka itsigakana arlo Tata Do Yebáha ganna ga'akana ata se'e ka nu labí ankakana benne Israel. Kumu ganna itsigakana, la'ania nna labíru aka gokana irse nu tekinna láni irse ge laní Pascua. ");
INSERT INTO zae_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nianna tti biria Pilato‑ni ata se'ekanaha nna rana kana: ―¿Bí ge nuní rusiale iki nubiyú‑ni? ");
INSERT INTO zae_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Lakana nna bekabikana geni, rákana na: ―Gannala ttixka abittuba ankana ttu nu ruin satsa, la'ania nna abittula bisia lentu na arlolu ganna ttixka. ");
INSERT INTO zae_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato‑ni nna rana kana: ―Lebi'iba gwaleche na nna gwaluinba elhuxtisi geni attiba ra lo bia bennabi gele‑na. Ka nu loni ge ka benne Israel‑ni nna rákana: ―Ri'itu labí ga'anna uttitu ttu benne. ");
INSERT INTO zae_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Aníha uka kini gwado tisa ge nu unne Jesús‑ni tti utixxi'abie gaxasina gattie. ");
INSERT INTO zae_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nianna tti bedeta'a Pilato‑ni attu libe lhe'e guskaduha nna uxina Jesús‑ni nna rane: ―¿Si lu ankalu nu rinnabia ge ka benne Israel‑ni? ");
INSERT INTO zae_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús‑ni nna bekabie geni ree: ―¿Si nu anka gelu nuná ralu aná ak? O, ¿nu subiba utixxi'enna lu kia ak? ");
INSERT INTO zae_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato‑ni nna bekabina gee, rana: ―Ki gwa yúbalu laa benne Israel‑ga neti nna ralu aná. Ka benne lhe'esi gelu‑naba lhe ka nu loni ge ka bixxudi‑naba betega'akana lu lasi náya. ¿Bí benlu? ");
INSERT INTO zae_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús‑ni nna bekabie ree: ―Yiesi lo yu‑ni labí ankana ata innabiaya. Gannala ttixka innabiaya yiesi lo yu‑ni, la'ania nna ka benne danalhake netiha gwa bitilhalake kini abittu bedaxxu ka nu Israel‑ni neti, ttaka labí yiesi lo yu‑ni innabiaya. ");
INSERT INTO zae_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nianna ra Pilato‑nie: ―Nianna, ¿si lu ankalu nu rinnabia? Jesús‑ni nna bekabie, ree: ―Luba ra deki neti ankaa nu rinnabia xa. Neti ki de nuha‑la ulia lhe de nuha‑la daya yiesi lo yu‑ni kini kixxi'aya ge nu anka gwalí. Iyába ka nu gwa ria lekani ge nu anka gwalí, gwa rudoba nagakani ge nu rinnea. ");
INSERT INTO zae_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato‑ni nna rane: ―¿Bí nuha nu anka gwalí? Nuha‑ba ra Pilato‑ni nna tti bederiana attu libe ata se'e ka nu Israel‑ni nna rana kana: ―Labí raxxakaa bixa tulha ben nuní. ");
INSERT INTO zae_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ttaka kumu lebi'i chi labinle kua risiaba laní Pascua teeki odiláya ttu nu tee lisiyya, nnanna gwalinná: ¿si gwa raka lele odiláya nu anka nu rinnabia gele‑ni? ");
INSERT INTO zae_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ttaka iyábakana bedebesi'akana attu libe, rákana: ―¡Ko'o! ¡Labí olhálu nuná! ¡Barrabás‑nala bolhá! Barrabás‑ni ukana ttu nu runi ubana. ");
INSERT INTO zae_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nianna ben Pilato‑ni mandadu bedaxxukana Jesús‑ni ki bekulhakane. ");
INSERT INTO zae_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ka soldaduha nna benkana ttu corona yetsi nna ulu'ukana nuha ikie lhe begukukane ttu lari xiná chulha, ");
INSERT INTO zae_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","nianna tti ribigakana arloe nna rákane: ―¡Xxeni ra lelu xa nu rinnabia ge ka nu Israel! Nianna ribeakana gi ro'e, ");
INSERT INTO zae_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","nianna tti bederia Pilato‑ni attu libe, rana ka nu Israel‑ni: ―Gwaluyúruga. Nena chi kweaya‑ni kini uyú lole deki neti labí raxxakaa bixa tulha benna. ");
INSERT INTO zae_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tti biria Jesús‑ni nna chi yu'u ikie corona yetsiha lhe chi nukue lari xináha lhe. Nianna ra Pilato‑ni kana: ―Ne nubiyúha du nii. ");
INSERT INTO zae_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ka nu loni ge ka bixxudiha lhe ka nu rise'e gweyú ro'o yotuha lhe, tti bilákinna Jesús‑ni, nianna tti unnekana idisa rákana: ―¡Betá nuná lo ya kurusi! ¡Betá nuná lo ya kurusi! Pilato‑ni nna bekabina gekani, rana kana: ―Lebi'iba gwaleche na nna gwalutá na lo ya kurusi, kumu neti labí raxxakaa bixa tulha ben nuní. ");
INSERT INTO zae_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ka nu Israel‑ni nna bekabikana geni, rákana: ―Ri'itu tee ttu bia bennabi getu ata gwa rugwelhabana deki gattiba nuná kumu de rana ankana Xi'in Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tti biyienini Pilato‑ni nu ra ka nuha, nianna adíla usi chiettiruinna, ");
INSERT INTO zae_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","nianna tti bedeta'ana lhe'e guskaduha nna redeana Jesús‑ni: ―¿Gá benne lu? Jesús‑ni nna labí bekabie geni. ");
INSERT INTO zae_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nianna rane: ―Neti rinnea nna abígaba rekabilu kia. ¿Si bi gwa yulu deki neti gwa tee lo neda kia odiláya lu o utáya lu lo ya kurusi lhe? ");
INSERT INTO zae_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús‑ni nna bekabie geni ree: ―Labí aka gelu innabialu neti ganna abíba bete Tata Do Yebáha lo neda lenlu kini inná xxeni lelu. Laxkala nu betena neti lasi nálu, adírula tulha xxeni daa nuha tti lu. ");
INSERT INTO zae_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Debá la'ania ruin Pilato‑ni odilána Jesús‑ni, ttaka ka nu Israel‑ni ribesi'abakana, rákana: ―Ganna odilálu nuná, la'ania nna labí gwalí do tse lenlu César benne rinnabia xeniha, kumu iyába ka nu uinkana deki xxenirula ra lekani tti César‑ni, tti uinkana aníha, rigu'uba ni'akani benneha. ");
INSERT INTO zae_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tti biyienin Pilato‑ni nu ra ka nuha, nianna uleana Jesús‑ni nna lana nna bedona lo xxila ata ridona ruinna elhuxtisiha. Ata ridonaha, len tisa hebreo tee láni Gabata. (“Gabata” dienna innána Ata Yu'u Ka Íyya.) ");
INSERT INTO zae_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","La sáha nuha chi rese'e tse ka nu Israel‑ni kini attu sáha nna chi ga'akana laní Pascua. Ttiba retin tsi'inu (12) nuha nna ra Pilato‑ni ka nu Israel‑ni: ―¡Ne nu rinnabia geleha du nii! ");
INSERT INTO zae_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ttaka lakana nna uresi'alakana, rákana: ―¡Ttu tsa utua nuná! ¡Betá nuná lo ya kurusi! Pilato‑ni nna bekabina, rana kana: ―¿Si utáya nu rinnabia gele‑ni lo ya kurusi? Ka nu loni ge ka bixxudiha nna bekabikana geni, rákana: ―Ri'itu lanúru attu nu rinnabia ge ri'itu do, sunruba César‑ni dointu. ");
INSERT INTO zae_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Aníha uka nna bote Pilato‑nie lasi nákani kini utákane lo ya kurusi. Lakana nna dechekana Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús‑ni nna nuje kurusi geeha birie die ttu latti ata tee láni Gólgota len tisa hebreo. (“Gólgota” dienna innána bega iki nu yatti.) ");
INSERT INTO zae_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Niha betákane lo ya kurusiha. Betágabakana a chupa ka nubiyú lo ka ya kurusi, ttu ttukana utákana daka lhitte, labie nna betákane lagwi ge ka nuha. ");
INSERT INTO zae_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato‑ni benna lo ttu breta betákana lo ya kurusiha daka xaliekie. Lo bretaha dia ra: “Jesús ge Nazaret, nu rinnabia ge ka benne Israel.” ");
INSERT INTO zae_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ixe ka nu Israel‑ni belabakana nu dia lo bretaha, kumu ata betákana Jesús‑ni lo ya kurusiha gaxxaba re nuha ro'o yiesiha lhe kumu ka letraha ankakana len tisa hebreo lhe latín lhe griegu lhe. ");
INSERT INTO zae_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Laxkala ka nu loni ge ka bixxudi ge ka nu Israel‑ni, rákana Pilato‑ni: ―Bittuba a bedelhalu lo breta‑na: “Nu rinnabia ge ka benne Israel.” A bedelhabalu loni: “Nu rana: Neti ankaa nu rinnabia ge ka benne Israel.” ");
INSERT INTO zae_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ttaka Pilato‑ni nna rana kana: ―Neti nu chiga benia, benia. ");
INSERT INTO zae_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Iki de chi betá ka soldaduha Jesús‑ni lo ya kurusiha, nianna tti bedaxxukana ka xoeha nna benkana ka nuha ttapa lha'a. Ttu ttu lha'a ka nuha ulha ttu ttu ka soldaduha. Bedaxxugabakana lari nu nukue lo liaha, ttaka kumu labí tiyya nuha, suna ttu lhaaba anka itú nuha, ");
INSERT INTO zae_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","de nuha nna ka soldaduha ra luesikani: ―Labí itsúri'i nuní. Suertiba udelhari'i geni, kini nuxari'i eya'an lenri'i lari‑ni. Aníha uka kini gwado tisa ge nu dia lo ka yetsi ge Tata Do Yebáha ata ra: “Belha'abakana ka xoaha lhe bedelhabakana suerti gekani lhe.” Aníha‑ba ben ka soldaduha. ");
INSERT INTO zae_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Gaxxaba ata taa Jesús‑ni lo ya kurusiha du nan geeha lhe xila nan geeha lhe María nuila ge Cleofas‑ni lhe María Magdalena‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tti bilani Jesús‑ni nan geeha due niha, kwe'e benneha nna dúgaba ttu ka benne rudhetinieha, delába benne rakarunie geeha, nianna tti ree nan geeha: ―Nana, ne xi'inluha du naa. ");
INSERT INTO zae_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nianna tti redeabie benne rudhetinieha: ―Ne nan gelu du naa. Debá la'ania nna deche benne rudhetinieha nan ge Jesús‑ni lisieha. ");
INSERT INTO zae_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Iki de nuha nna kumu chiba yu Jesús‑ni deki iyába nu chi ga'anna akaha, chiba benie nuha, de nuha nna kini sado tisa ge nu ra lo ka yetsi ge Tata Do Yebáha, nianna ree: ―Rebisia inda. ");
INSERT INTO zae_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Niha du ttu kanti ta'a vinu idí lhe'eni. Bedokana ttu xunu lo ttu iyyaxtila, nianna begi'akana xunuha vinuha nna tti besigakana nuha ro'e. ");
INSERT INTO zae_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tti chi u'uye vinu idíha, nianna ree: ―Chi uluxa iyá nu chi ga'anna unia. Nianna tti bodetta ikie nna bechú lebie. ");
INSERT INTO zae_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kumu chi galá bisia sá tti rese'e tse ka nu Israel‑ni kini attu sáha‑ba nuha chi ga'akana laní Pascua, de nuha nna ka nu loni gekaniha labí raka lekani eya'an ka benne yattiha lo ka ya kurusiha la sá reyaka lekaniha kumu la sáha anka sá laní xxeniru. Aníha uka nna ugíakana unnabakana len Pilato‑ni kini kinkana yaga lhe'e ni'a ka benneha kini ila'a lhe'e ka sitta ni'akeha nna echidakana ke lo ka ya kurusiha. ");
INSERT INTO zae_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ka soldaduha nna ugíakana ulha'akana lhe'e ka sitta ni'a ttu ka nu taa len Jesús‑ni lo ka ya kurusiha, nianna tti bedeyekikana bedelha'akana lhe'e ka sitta ni'a attu nuha. ");
INSERT INTO zae_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ttaka tti ubigakana ata taa Jesús‑ni nna bilákinna chiba utti benneha. De nuha nna labíru ulha'akana lhe'e ka ni'eha. ");
INSERT INTO zae_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ttaka ttu ka soldaduha nna bega'ana iyya tutsa dennaha lhitte, nianna biria tteba reni lhe inda lhe. ");
INSERT INTO zae_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Benne rigixxi'abie nuní anke benne bilánie nu ukaha nna rigixxi'abe nu ankaba gwalí. Benneha yube deki nu gwalíba anka nu rinneeha kini anágaba lebi'i tsia lele ge nu rigixxi'eha. ");
INSERT INTO zae_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kumu aníha uka ki gwado tisa ge nu ra lo ka yetsi ge Tata Do Yebáha ata dia ra: “Ni ttú sitta lati benneha labí ilha'akana.” ");
INSERT INTO zae_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Rágaba attu lisia lo ka yetsi ge Tata Do Yebáha: “Tse'ebakana ugíakana benne utitikana lhitteha.” ");
INSERT INTO zae_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Iki de nuha nna José benne lhe'esi Arimatea ugíe gwannabe len Pilato‑ni kini ugwelhane elhide Jesús‑ni lo ya kurusiha kini ukatsie benneha. José‑ni uke ttu ka benne bedhetini Jesús‑ni, meskiba labí bele'e looe deki uke ttu ka nu bedhetini benneha kumu de rasinie ge ka nu loni ge ka nu Israel‑ni. Pilato‑ni nna gwa begwelhabana José‑ni kini dechebie benne yattiha. ");
INSERT INTO zae_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Anágaba Nicodemo‑ni, delába benne ugíe ttu lo rela gwanne lenie Jesús‑ni, bisingaba benneha denie ttiba rerua (30) kilu seti nu rure ixixxi. ");
INSERT INTO zae_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Laxkala José‑ni lhe Nicodemo‑ni lhe bottesike Jesús‑ni lhe'e ttu lari nu chi ulu'u taake seti nu rure ixixxiha. Benbake attiba chi labini ka benne Israel‑ni ruinke tti rukatsike ka benne yatti geke. ");
INSERT INTO zae_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ata betákana Jesús‑ni lo ya kurusiha, niha tee ttu yu yadakinna ka ya xixxi loni. Lhe'e yuha do ttu baa kubi, ttu baa lanú nu chi bigatsi lhe'eni. ");
INSERT INTO zae_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Niha‑ruba bekatsikana Jesús‑ni, kumu de chi ga'a sá tti reyaka le ka benne Israel‑ni lhe kumu yieru baaha‑ruba nuha do gaxxa ata uttieha. ");
INSERT INTO zae_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","La sá tti bedú ni'a xumanuha, delába duminku, dila tteba gwankaru chulha ugía María Magdalena‑ni gwalannina lo baaha. Tti bilenna chi bitua íyya yaya ro'o yieru baaha, ");
INSERT INTO zae_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","nianna ruxunnibana beyekina besinna ata do Simón Pedro‑ni lhe attu ka benne bedhetini Jesús‑ni, delába benne ukarunie geha, nianna tti utixxi'enna ka benneha, rana ke: ―Chiba bebeakana Tata Xisiha lhe'e yieru baaha nna labí yutu gá gwattixxakane. ");
INSERT INTO zae_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro‑ni lhe attu benneha nna bexunni ttebake diake ata do yieru baaha. ");
INSERT INTO zae_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tu tulapaba diake ruxunnike, ttaka attu benneha nna unerube lo Pedro‑ni, laxkala benneha bisine lade'a tte ro'o yieru baaha. ");
INSERT INTO zae_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tti bisine ro'o yieru baaha nna biyette beká loe lhi'u, niha‑ba bilánie ka lari bitesi benneha, ttaka labí uta'abie lhi'u. ");
INSERT INTO zae_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tti chi bisin Simón Pedro‑ni nna uta'a ttebe lhe'e yieru baaha nna bilánie ka lari bitesi benneha se'ekana niha. ");
INSERT INTO zae_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Lari nu bitesi iki Jesús‑ni nna labí re nuha ata se'e adí ka lariha, ta subila tesi nuha rena. ");
INSERT INTO zae_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nianna tti uta'agaba benne bisin lade'a tte ro'o yieru baaha. Tti ute'eha nna bilánie iyá nu chi ukaha, nianna tti ugía lebie. ");
INSERT INTO zae_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kumu lake labí chi ute dákanie nu dia lo ka yetsi ge Tata Do Yebáha ata ra deki teeki eyadha ben benneha lagwi ge ka benne chi uttiha. ");
INSERT INTO zae_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nianna tti beyekike besinke lhe'e yo'o ata reya'ankeha. ");
INSERT INTO zae_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María‑ni nna sa dube ro'o yieru baaha ribesie. Laka due ribesie nna biyette beká loe lhe'e yieru baaha. ");
INSERT INTO zae_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nianna bilánie chupa ka anjeli ge Tata Do Yebáha se'eke ata utta Jesús‑ni, nukuke xo sitsi. Ttúbie re daka ata utta ikieha nna attubie re daka ata use'e ka ni'eha. ");
INSERT INTO zae_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nianna tti belisake María‑ni, ráke bie: ―¿Beaka ribesilu xa nuila? Lee nna ree ka benneha: ―Ribesia kumu bebeabakana Tata Xisi to kia nna labí yua gá gwattixxakane. ");
INSERT INTO zae_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nuha‑ba ree nna tti bodeki loe daka kwe'ebie, nianna bilánie Jesús‑ni due niha, ttaka labí yue deki Jesús‑niba nuha. ");
INSERT INTO zae_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús‑ni nna ree bie: ―¿Beaka ribesilu xa nuila? ¿Nú regilalu? María‑ni nna ukanie ganna nu ruyúna lo yu ata yada ka ya xixxiha‑ba nuha. De nuha nna ree nuha: ―Ganna luba dechelu benneha xa tata, utixxi'a gá gwattixxalue kini echea bie. ");
INSERT INTO zae_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús‑ni nna ree: ―María. María‑ni nna bodeki loe unnebie tisa arameo, ree: ―¡Raboni! (“Raboni” dienna innána maestru.) ");
INSERT INTO zae_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús‑ni nna rabie María‑ni: ―Bittu udaxxulu neti kumu labí chi beyapia ata do Tata kiaha. Beyyala nna usi ka betsi to kiaha, delába ka benne bedhetiniaha, usi ke: “Chiba eya'aya ata do Tata kiaha, benne ankagabe Tata geleha. Benneha anke Diosi kia nna ankagabe Diosi gele.” ");
INSERT INTO zae_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nianna tti deyya María Magdalena‑ni kini kixxi'anie ka benne bedhetini Tata Xisiha deki chi bilánie benneha lhe utixxi'agabanie ka benneha iyá nu ra Tata Xisiha bie lhe. ");
INSERT INTO zae_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tti chi ulha sá bedú ni'a xumanuha, ka benne rudhetini Jesús‑ni yayabakanie yo'o ata tupakeha de rasikanie ge ka nu loni ge ka nu Israel‑ni. Nianna tti uka xxe Jesús‑ni nna udúbie lagwi geke nna rabie ke: ―¡Bittu gasinle! ¡Xen su lasi gwaltse'e! ");
INSERT INTO zae_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nuha‑ba ree nna tti bele'enie ke ka neeha lhe bele'enie ke lhitteha lhe. Ka benne rudhetinieha nna ittaba bedú leke tti bilákanie Tata Xisiha. ");
INSERT INTO zae_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nianna tti redea Jesús‑ni ke attu libe: ―¡Xen su lasi gwaltse'e! Kumu anába attiba udhelha Tataha neti, anágaba neti idhelhaa le kini kixxi'ale ka tisa kia‑ni. ");
INSERT INTO zae_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nuha‑ba rabie nna tti belubie ikike nna rabie ke: ―Gwalidhí Espíritu ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ka benne dhile elha xen lasi ge ka tulha ruinke, gwadígaba Tata Do Yebáha elha xen lasi ge ka benneha nna ka benne abittu dhile elha xen lasi geke, anágaba Tata Do Yebáha labígaba dhibie elha xen lasi ge ka benneha. ");
INSERT INTO zae_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ttu ka benne tsi'inu (12) rudhetini Jesús‑ni, benne tee lábie Tomás, benne rágabake Kwachi, benneha lanúbie tee tti bele'e lo Jesús‑ni len adí ka benneha. ");
INSERT INTO zae_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Delola nna adí ka benneha utixxi'akanie Tomás‑ni, ráke bie: ―Chi bilentu Tata Xisiha. Ttaka Tomás‑ni nna bekabie geke, ree: ―Ganna abíba iláti ka lasi nábie ata biyada ka clavuha lhe ganna abíba uga'a xubenáya ata biyada ka nuha lhe anágaba ganna abíba uga'a xubenáya lhe'e yieru do lhitteha, la'ania nna labí tsia lasia gele. ");
INSERT INTO zae_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Xxunu (8) ubisa chi ute tti uka nuha, nianna dedetupa ka benne rudhetini Jesús‑ni lhe'e yo'oha. La'ania nna gwa duba Tomás‑ni lenke. Dedeyayabakanie yo'oha, ttaka Jesús‑ni uka xxebie nna udúbie lagwi geke nna begwebie ke padiuxi nna ree ke: ―¡Xen su lasi gwaltse'e! ");
INSERT INTO zae_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nianna tti rabie Tomás‑ni: ―Belanni ka lasi náya‑ni lhe kwittaa‑ni lhe. Belhí nálu nna bega'a xubenálu lo ka gwe kia‑ni nna ugía lelu, bittu akalu nu a ria leni. ");
INSERT INTO zae_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomás‑ni nna bekabie ge Jesús‑ni, ree bie: ―Lu baninlu neti lhe ankalu Diosi kia lhe. ");
INSERT INTO zae_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús‑ni nna ree Tomás‑ni: ―Ria lelu kumu de chi bilenlu neti, ttaka karubáru ka benne bittu chi bilákanie neti nna gwa riaba leke. ");
INSERT INTO zae_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ixeeru ka milagru ben Jesús‑ni arlo ka benne rudhetinieha, ka nu labí diakana lo yetsi‑ni, ");
INSERT INTO zae_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ttaka ka nu chi dia lo yetsi‑ni, ukakana lo yetsi‑ni kini lebi'i tsia lele deki Jesús Xi'in Tata Do Yebáha anke Cristu lhe kini de tsia lele ge benneha nna gwaka benbale ttu dia lii arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Iki de nuha nna bodole'e lo Jesús‑ni attu libe len ka benne rudhetinieha ro'o indatoo tee láni Tiberias. Aní uka nuha: ");
INSERT INTO zae_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","du Simón Pedro‑ni lhe Tomás benne rágabakana Kwachi lhe Natanael ge lhe'esi Caná nu re daka Galilea lhe se'egaba ka xi'in Zebedeo‑ni lhe a chupa ka benne rudhetini Jesús‑ni. Turo'oba se'e iyábake niha. ");
INSERT INTO zae_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro‑ni nna ree ka benneha: ―Tsiaya sadaxxua belha. Ka benneha nna ráke bie: ―Ri'itu dhágabatu. Nianna diake ugwapike lo barcu daa niha, ttaka loolhaha nna birula belha biyaxxukanie. ");
INSERT INTO zae_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tti chi daa tsaniha nna uka xxe Jesús‑ni ro'o indatooha, ttaka ka benne rudhetinieha nna labí yuke deki labie nuha. ");
INSERT INTO zae_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús‑ni nna unnaba tise, rabie ke: ―Xi'ini to, ¿si bi gwa bedaxxule belha ki gori'i? Lake nna bekabike gebie, ráke: ―¡Birula xa tata! ");
INSERT INTO zae_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesús‑ni nna ree ke: ―Gwaludelharuga yexxa gele‑na daka lhitta ben ge barcu‑na nna uyúrugale gudaxxubale belha. Aníha‑ba benke bedelhake yexxaha, ttaka tti chi ebeake nuha, bi reyadhakanie yexxaha de chi desá xxatta belha lhe'eni. ");
INSERT INTO zae_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nianna ttu ka benne rudhetini Jesús‑ni, benne rakarunie geeha, benneha ree Simón Pedro‑ni: ―¡Jesús benne anke Xxanari'iha‑ba nuná rinne! Suna biyienbin Simón Pedro‑ni deki Benneha‑ba nuha, beyoku tteba xoe kumu uleabe ka nuha ki renie sina. Nianna uta'a ttebe lhe'e indaha. ");
INSERT INTO zae_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Adí ka benne rudhetinieha nna dedá lenke barcuha dena'ayake yexxaha desá tíbana nuha belha, kumu ttiba ttu gayua (100) metru riyasa eriake ro'o indaha. ");
INSERT INTO zae_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tti beyadike lo barcuha dedáke, nianna betexxakake chi re gi. Lo giha chi xua ttu belha lhe chigaba tee yettaxtila lhe. ");
INSERT INTO zae_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús‑ni nna rabie ke: ―Gwataxxí ttu chupa ka belha ka nu si bedaxxule‑na. ");
INSERT INTO zae_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ugwapi tteba Simón Pedro‑ni lo barcuha nna gwaleabie yexxaha ro'o indaha desá tí nuha ka belha xeni. Ttu gayua tsieyona bixxi tsunna (153) ka belhaha deyu'u lhe'e nuha. Meskiba ixe ka belhaha deyu'u, labí bisú yexxaha. ");
INSERT INTO zae_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús‑ni nna rabie ka benneha: ―Gwalibiga gwaligo ixtíle. Ni ttú ka benne rudhetinieha a reyaxakanie innaba tisake bie, gake bie: “Lu nna, ¿nú ankalu?” Kumu yúbake deki Jesús benne anka Xxanari'iha‑ba benneha. ");
INSERT INTO zae_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nianna tti ubiga Jesús‑ni bedaxxue yettaxtilaha nna utidhie benneha geke. Aníha‑gaba benie len ka belhaha. ");
INSERT INTO zae_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nuha beyonna lidú rule'e loe len ka benne rudhetinieha iki de chi beyaka banie lagwi ge ka benne chi uttiha. ");
INSERT INTO zae_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Iki de chi beyaka uto ixtíkeha nna ra Jesús‑ni Simón Pedro‑ni: ―Simón xi'in Jonás, ¿si rakaruinlu kia tti ka nu se'e‑ni? Lana nna bekabina, rana: ―Ila xa tata. Lu gwa yúbalu gwa rakabati gelu. Jesús‑ni nna ree na: ―Biyú ka neru to kia‑ni ganna. ");
INSERT INTO zae_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nianna redeabie na attu libe: ―Simón xi'in Jonás, ¿si gwa rakinlu kia? Lana nna bekabina, rana: ―Ila xa tata. Lu gwa yúbalu gwa rakabati gelu. Lee nna redeabie na: ―Biyú ka neru to kia‑ni ganna. ");
INSERT INTO zae_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Beyonna libeha redea Jesús‑ni na: ―Simón xi'in Jonás, ¿si gwa rakinlu kia? La'ania nna chi bedú si'ina le Pedro‑ni kumu de beyonna libela rinnaba tise, ree na: “Si gwa rakinlu kia?” Lana nna rane: ―Lu iyába gwa yúbalu xa tata. Lu yúbalu, gwa rakabati gelu. Jesús‑ni nna ree na: ―Biyú ka neru to kia‑ni ganna. ");
INSERT INTO zae_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Netiru ria, tti ankalu kwitiha titúbalu redú tselu nna riabalu ataba rakaba lelu, ttaka ganna chi uxxuluha, la'ania nna udábalu ka nálu‑na nna attu benne subila odú tsebie lu nna ichebe lu ata labí ru'u lelu tsialu. ");
INSERT INTO zae_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tti unne Jesús‑ni aníha benna liibie gaxasina gatti Pedro‑ni. Len elhutti sate Pedro‑ni inná xxeni le Tata Do Yebáha. Nuha‑ba unnebie, nianna tti ree na: ―Utá tenalha neti. ");
INSERT INTO zae_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tti bodeki lo Pedro‑ni nna bilenna danalha ttu ka benne rudhetini Jesús‑ni, delába benne rakarunie geeha. Benneha‑gaba nuha udobie daka litta Jesús‑ni tti yu'uke go irseha nna unnaba tise Jesús‑ni, ree bie: ¿Nútu nuní utetu lu lasi ná ka nu uttikana luha, xa tata? ");
INSERT INTO zae_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tti bilani Pedro‑ni danalha benneha, nianna unnaba tisana Jesús‑ni, rane: ―Tata, nuní nna, ¿bíla sate nuní ganna? ");
INSERT INTO zae_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús‑ni nna bekabie geni, ree: ―Neti ganna rakaba lasia anába dhona aka benna axtaliba ganna chi esiayaha, lu nna bila elha ralhalu nna rinnaba tisalu. Utá tenalha neti. ");
INSERT INTO zae_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nuní uyu'u naga adí ka betsi to geri'iha nna ráke deki benneha labí gattie, ttaka Jesús‑ni laa rage Pedro‑ni deki benneha labí gattie, sinuki sun rabe na: “Ganna neti aka lasia anába dhona aka benna axtaliba ganna chi esiayaha, lu nna bila elha ralhalu nna rinnaba tisalu.” ");
INSERT INTO zae_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Benne‑niba nuha bedhetini Jesús‑ni nna kwinaba labie rigixxi'e iyá nuní lhe benie na lo yetsi lhe. Ri'itu gwa yúbatu deki nu rigixxi'e‑ni ankaba nuní nu gwalí, labí ruin lebie. ");
INSERT INTO zae_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús‑ni ixeeru nu ben benneha. Ganna kua ttu ttu ka nu benieha tsiakana lo yetsi, neti rakati labí akani yiesi lo yu‑ni tsu'u ka yetsi ka nu tsia lokani iyá nu benieha. Amén.");
INSERT INTO zae_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Lo yetsi nu sisi'a tte benia ttuha xa tata Teófilo, lo nuha utixxi'aya ge iyá tte nu udulo Jesús‑ni benie lhe iyá tte nu bele'enie ka benne lhe ");
INSERT INTO zae_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","axtaliba tti chi bisia sá beyapie deyye yebáha. Attili lani eyapie eyye, la'aniali chi bixúnie Espíritu ge Tata Do Yebáha kini bodha'ane bixa anka nu uin ka apóstoal, delába ka benne chi bekweeha. ");
INSERT INTO zae_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Len ka apóstoal‑gaba nuha bele'e lo Jesús‑ni ixe lidú iki de tti chi uttieha. Aníha benie kini bela'a deki gwalí reki benbe. Delo chua (40) ubisaha bele'e lobie lenke lhe utixxi'agabanie ke gasina ki akake benne innabia Tata Do Yebáha ke. ");
INSERT INTO zae_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Attili sa doe len ka benneha chi utixxi'e rabie ke: ―Labí eriaxxile lhe'esi Jerusalén‑ni. Kwedabale axtaliba ganna chi udhelha Tataha benne chi rabie deki idhelheha. Neti chiba utixxi'ania le ge benne idhelheha. ");
INSERT INTO zae_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Gwalí galá Juan‑ni suna len indaruba begadie ka benne; ttaka lebi'i nna chi tte dabigana ugadi Tata Do Yebáha le Espíritu geeha. ");
INSERT INTO zae_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ka benne tupa niha unnaba tisake Jesús‑ni, ráke bie: ―Tata Xisi to, ¿si nnanna chi uinlu kini ri'i ka benne Israel edulori'i innabiari'i attu libe? ");
INSERT INTO zae_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Labie nna bekabie geke ree: ―Lebi'i labí elha ralhale unale bí sá lhe bí ura aka nuní, kumu sunruba Tataha chi ga'ananie nukaxa aka nuní. ");
INSERT INTO zae_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ttaka ganna chi bisia Espíritu ge Tata Do Yebáha latile, la'ania nna inná tsitsi lele. Nianna tti iriale tsiale kixxi'ale kia lhe'esi Jerusalén‑ni lhe lhe'e adíru ka yiesi se'e itúba daka Judea‑ni lhe daka Samaria‑ni lhe. Axtaba ata riluxa yiesi lo yu‑ni tsiale kixxi'ale kia. ");
INSERT INTO zae_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Iki de chi rabie iyá nuha, nianna tti beyapie deyye yebáha. Lake nna rulannibake se'eke. Nianna tti bebe ttu bea, bebena ata deyyeha nna lanúrue bilákanie. ");
INSERT INTO zae_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sa se'elake rugíake deyya Jesús‑ni gwetsáha, nianna ttiruba chi uka xxe chupa ka benne biyú ata se'ekeha, nukuke ka xo sitsi. ");
INSERT INTO zae_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nianna tti ra ka benneha ke: ―Lebi'i benne ge Galilea, ¿beaka se'ele gwelanni gwetsáha? Ki yule la kwinaba Jesús benne ugwekie lagwi gele nna beyapie deyye yebáha, la benneha‑gaba nuha esiabie attu sá. Ttiba bilenle beyapie deyye, aníha‑gaba esiabie. ");
INSERT INTO zae_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nianna beyadi tteba ka apóstol ge Jesús‑ni iki I'iya Ata Daa Ka Ya Olivuha nna deyyake besinke lhe'esi Jerusalén‑ni. Jerusalén‑ni rena gaxxaba niha. Laxkala lattiba bedáke. Raxxíbana nu bedábakeha attiba chi ga'anna dháke lhe'e ka sá atti reyaka leke. ");
INSERT INTO zae_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tti besinke lhe'esiha, nianna beyapike lhe'e yo'o do gwetsá ata reya'an Pedruha lhe Juan‑ni lhe Jacobuha lhe Andrés‑ni lhe anágaba Felipe‑ni lhe Tomás‑ni lhe Bartolomé‑ni lhe Mateo‑ni lhe, anágaba Jacobo xi'in Alfeo‑ni lhe Simón, benne rágabakana Zelote lhe anágaba Judas xi'in benne tegaba lábie Jacobo. ");
INSERT INTO zae_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Iyábake labí rudú siike, turo'oba rilhapike tisa rulisake Tata Do Yebáha, itupa lenke adíru ka benne nuilaha lhe anágaba María nan ge Jesús‑ni lhe ka betsieha lhe. ");
INSERT INTO zae_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ttu sá tupa ttiba ttu gayua galhia (120) ka betsi to geri'i, delába ka benne chi ria leke ge Jesús‑ni. Nianna tti udú lii Pedruha lagwi geke nna rabie ke: ");
INSERT INTO zae_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Xa betsi to, teeba ki gwado tisa ge nu unne Espíritu ge Tata Do Yebáha lo ka yetsi geeha, tti bixúnie David‑ni kini unnena ge nu uni Judas‑ni, delába Judas nu uchena ka nu bedaxxukana Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kumu lana ukana benne biselana ri'i. De nuha nna selagabana uinna sina nu chi ga'anna uinri'i. ");
INSERT INTO zae_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","’Ttaka Judas‑ni len belhiu uxína ge nu satsa bennaha, len nuha uyo'ona ttu lo yu ata ugíana úda ikini lo yu nna bisú lhe'eni, nianna tti ure tinni ka tu'eniha. ");
INSERT INTO zae_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Iyába ka nu lhe'esi Jerusalén‑ni binakana ge nu ukaha. Nianna utixxakana lá yu ata uttinaha Acéldama. Len tisa gekani dienna innána: Yu Ata Bilali Reni. ");
INSERT INTO zae_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","’Ge Judas‑ni nuha rinne lo ka Salmo‑na ata dia ra: Lhe'e lisiniha sii siibaniba eyaka; lanú benne tse'e lhe'e nuha. Lhe rágaba lo ka Salmo‑na: Attu benne subila odaxxue sina geniha. ");
INSERT INTO zae_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","De nuha nna raka doelha odúri'i attu benne subi kini odaxxue ladi Judas‑ni, kini tsekie lenri'i kixxi'ari'i deki beyaka benba Jesús‑ni lo elhuttiha. Odúri'i ttu ka benne betenalhake ri'i itúba tti ugweki Jesús benne anke Xxanari'iha lenri'i, desdeba tti begadi Juan‑nie inda nna axtaliba tti beyapie deyye yebáha. ");
INSERT INTO zae_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nianna tti bekwekana chupa ka benneha: bekwekana José benne tegaba lábie Barsabás, benne rágabakana Justo. Bekwegabakana attu benne tee lábie Matías. ");
INSERT INTO zae_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nianna tti ulhapikana tisa len Tata Do Yebáha, rákane: ―Tata Xisi to, luba yulu ttixa anka lhe'e lasto ttu ttutu. Nnanna rinnabatu len kwinalu, delo chupa ka benne biyú se'e nii, ule'elu nú ka benne‑ni chi bekwelu ");
INSERT INTO zae_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kini akake apóstol kixxi'ake ka tisa ge Jesús‑ni, uinke sina nu ralha Judas‑ni uinna. Kumu lana, de benna tulhaha, de nuha nna bennittiba sina geni. Laxkala diabana ataba ralhana tsiana. ");
INSERT INTO zae_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nianna tti bedelhake suerti kini ula'ana nuxa ka benneha saxxína. Nianna gwaxxíbana Matías‑ni. Laxkala la'ania tteba bisela Matías‑ni len ka benne sinea (11) anka apóstoal. ");
INSERT INTO zae_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tti bisia sá tti raka laní nu tee láni Pentecostés, la'ania iyába ka benne ria leke ge Jesús‑ni ttu sade'eba ta tupake. ");
INSERT INTO zae_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Attiruba nna iyya suba leke uyu'u be gwetsáha ttiba ata daa ttu be idí. Aníha‑ba betá tsi'ini itúba lhe'e yo'o ata se'ekeha. ");
INSERT INTO zae_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nianna tti uka xxe ttiba ka belha ge gi nna ugwadhikana iki ttu ttuke. ");
INSERT INTO zae_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","La'ania nuha bisia Espíritu ge Tata Do Yebáha nna uyu'e lati iyábake. Nianna tti udulo ttebake unneke ka tisa subi; unneke kua beteba Espírituha inneke. ");
INSERT INTO zae_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lhe'esi Jerusalén‑nigaba se'e ttu chupa ka nu ankakana nu Israel, delába ka nu rudo tsitsirukana tisa ge Tata Do Yebáha. Ka nuha dákana lhe'e iyába ka yiesi se'e yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tti biyienkinna uyu'u beha, nianna betupa ttebakana ata raka nuha, nna uka tébakinna kumu ttu ttukana biyienkinna rinne ka benneha ka tisa rinnekana lhe'e ka yiesi ata udákanaha. ");
INSERT INTO zae_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Rugía ya'abakana lhe bebanabakinna tti biyienkinna nu rakaha, nianna rinnaba tisa luesikani, rákana: ―¿Laaba ka nu Galileaba iyá ka nu se'e gwenne nii? ");
INSERT INTO zae_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Galasina nna gwa riyienbinri'i rinnekana ka tisa rinneri'i lhe'e ka yiesi ata dari'iha? ");
INSERT INTO zae_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ri'i ankari'i ka benne dari'i daka Partia lhe daka Media lhe daka Elam lhe dari'i daka Mesopotamia lhe daka Judea lhe anágaba daka Capadocia lhe daka Ponto lhe anágaba ka benne se'e daka Asia lhe. ");
INSERT INTO zae_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Dágaba ka benne se'e daka Frigia lhe ka benne se'e daka Panfilia lhe daka Egipto lhe ka benne daa daka Libia nu re gaxxaba ata re lhe'esi Cirene. Se'egaba ttu chupa ka benne dáke lhe'esi Roma, se'eke ttu satti nii. Ttu chupake ankake benne Israel nna attu chupake nna labí ankake benne Israel, ttaka nna beyakake nu Israel nna riagaba leke attiba ria le ka benne Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Se'egaba ka benne daa daka Creta lhe daka Arabia lhe. ¡Iyábari'i ka benne dari'i ka daka niha, gwa riyienbinri'i rinne ka benne‑ni ka tisa rinneri'i, rigixxi'ake ge nu xxeni ruin Tata Do Yebáha! ");
INSERT INTO zae_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Iyába ka benne se'e niha bebanabakanie, nigaba a yuke bixa ulaba leke. Nianna tti rinnaba tisa luesike, ráke: ―¿Bí diani iyá nu raka nii? ");
INSERT INTO zae_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ttaka adí ka nu se'e niha nna ruxisilakana, rákana: ―¡Dusibakin nuná! ");
INSERT INTO zae_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nianna tti udú lii Pedruha len a sinea (11) ka apóstol ge Jesús‑ni nna unnena idisa rana ka benne se'e niha: ―Lebi'i ka benne Israel lhe iyábale ka nu se'ele lhe'esi Jerusalén‑ni, gwaludoruga nagale nu innea kini unale bixa nuní raka nii. ");
INSERT INTO zae_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ka nu se'e‑ni laa dusigakin nuní, lebi'i nna rale deki dusikinna, ki si ankaruba retin jaa dila nuní. ");
INSERT INTO zae_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nnanna, nii chi rilenle raka nu utixxi'a Joel benne uke profeta ge Tata Do Yebáha itú nu reha, tti rabie: ");
INSERT INTO zae_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Aní ra Tata Do Yebáha: “Ganna chi dabigana isia ka sá daluxaha, la'ania ugadia Espíritu kia‑ni lati iyábale ka benne se'ele yiesi lo yu‑ni. La'ania ka xi'in biyúleha lhe ka xi'iniunnáleha kixxi'akinna le nu raka lasia unale. Ka nu kwiti geleha nna unia kini ula'akinna ttu bixa. Anágaba ka tatuxtoo to geleha uingabaa kini itsiakanie ka ela. ");
INSERT INTO zae_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","La'ania ugadia Espíritu kia‑ni lati ka benne biyú lhe lati ka benne nuila lhe, delába ka benne ixúti ke kini kixxi'ake nu raka lasia una adí ka benne. ");
INSERT INTO zae_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yebáha unia kini aka ttu bixa, kini iláni ka benne nna ebanakanie geni: Yiesi lo yu‑ni nna unia kini ilali reni lhe iria gi lhe chadha seni lhe. ");
INSERT INTO zae_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tatubisa‑na nna echulha lobie, nanto beo‑na nna eyake xiná attiba reni. Iyá nuní aka atti lanila isia sá esia Tata Xisiha. Ttu sá xxeni nuha aka la'ania lhe ttu sá nu dika ebanani ka benne geni lhe, ");
INSERT INTO zae_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","nna iyába ka benne ganna innabake len Tata Xisiha, labie nna godilábe ke.” ");
INSERT INTO zae_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Lebi'i xa benne Israel, ―ra Pedruha― gwaludoruga nagale nu upeya le: Lebi'i gwa yúbale, Tata Do Yebáha benie kini Jesús ge Nazaret‑ni benie ka milagru lhe benie adíru ka nu bebaninle geni lagwi gele. Iyá nuní benie kini bele'ebie deki lee udhelhe Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Benneha nuha betelee lasi ná ka nu ruin satsaha kini bettikane lo ya kurusiha. Ukaba attiba chi ga'anani Tata Do Yebáha aka. ");
INSERT INTO zae_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Jesús‑ni nuha belhidha ben Tata Do Yebáha lo elhuttiha, bodilee bie lo elha disa biyúe ge elhuttiha, kumu elhuttiha labí udaana uin genie. ");
INSERT INTO zae_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ge Jesús‑ni nuha unne David‑ni lo ka yetsi ge Tata Do Yebáha, tti rana: Satíaba riláti Tata Xisiha danerue arloa. Labí ruxunnina kia bixa satea, kumu benneha daka ná benbaa due. ");
INSERT INTO zae_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","De nuha nna ittaba du lasia lhe de elha gwedeaka lasi nna rulhaa gebie lhe anágaba xen su lasiba dhoa lhe; ");
INSERT INTO zae_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kumu lu xa Tata Xisi to kia, de chi ankaa benne chi ulesilu kini akaa gelu de nuha nna labí odha'anlu neti lhe'e yieru baaha, nigaba a ugwelhalu usu bela latia‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kwinabalu bele'enlu neti gasina aka bania ttu dia lii, lhe anágaba nna udú ittagabalu lasia de dulu len neti. ");
INSERT INTO zae_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Betsi to, gwalugwelharuga kixxi'aya ge David benne uka xuttori'iha. Yule benneha uttibe nna bigatsibe. Loora nnanna sa rilábinri'i teeba baa ge benneha. ");
INSERT INTO zae_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ttaka David‑ni uka galána profeta lhe anágaba nna chigaba yuna deki Tata Do Yebáha chi bodha'an tsitsi tisa gebie, ree deki ttu ka benne datiake naha, ttu ka benneha akake nu innabia, attiba lana ukana nu unnabia. ");
INSERT INTO zae_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Laxkala David‑ni la'aniali attisidiba chiba rilenna deki eyaka benba Cristuha lo elhuttiha. De nuha nna unnena rana, labí eya'an benneha yiesi elhuttiha lhe nigaba labí usu bela lati benneha lhe. ");
INSERT INTO zae_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Gwalíba nna Jesús‑niba nuha belhidha ben Tata Do Yebáha lo elhuttiha nna iyábatu biyú lotu aníha‑ba uka. ");
INSERT INTO zae_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Aníoka nna uxí lidhaka Jesús‑ni nna bisine udoe daka ná ben ge Tata Do Yebáha, nianna tti begwebie benneha Espíritu geeha, delába Espíritu nu chi rabie deki ugwebie Jesús‑ni. Espírituha nuní chi begadi Jesús‑ni latitu, de nuha nna riyieninle lhe rilenle nu raka nnanna. ");
INSERT INTO zae_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Lebi'i gwa yúbale laa David‑niga nuha beyapi yebáha, kumu kwinaba lana unnena rana: Tata Do Yebáha ree Cristu benne runie neti mandaduha: “Utá udo daka ná bania. ");
INSERT INTO zae_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Niiba dholu axtaliba ganna chi bese'a ka nu abittu raka uyúkana lu, kini lu nna ulealu ikikani.” ");
INSERT INTO zae_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’De nuha nna iyá ttele ka benne Israel, teeki una tsele deki Jesús benne betále lo ya kurusiha, benneha chi ben Tata Do Yebáha bie kini ake Xxanari'i lhe ake Cristu lhe. ");
INSERT INTO zae_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tti biyienkinna nu ra Pedruha nna ttiruba bega'a dina lhe'e lastokani, nianna tti unnaba tisakana benneha lhe adí ka apóstoal lhe, rákana ke: ―Betsi to, ¿bíla anka nu uintu ganna? ");
INSERT INTO zae_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedruha nna bekabina gekani, rana kana: ―Gwalodúna le ge nu ruinle nna gwalodaxxu neda ge Tata Do Yebáha nna kua ttu ttule gwaligadi inda nna udettile lá Jesucristuha atti gadile indaha. Aníha kini dhi Tata Do Yebáha elha xen lasi ge ka tulha chi benle. Nianna tti utebie Espíritu geeha len lebi'i. ");
INSERT INTO zae_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Espírituha nuha chi ra Tata Do Yebáha deki utebie gele lhe utebie ge ka xi'inle ka nu si daa lhe, anágaba nna utegabe Espírituha ge iyába ka benne se'e idittu, delába iyába ka benne gaxi Tata Do Yebaa benne anka Xxanari'iha. ");
INSERT INTO zae_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ixeba nu unne Pedruha rulisana ka benne se'e niha lhe rágabana ke: ―Gwalukwitta kwe'e ka nu ruin satsa se'e nnanna. ");
INSERT INTO zae_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Aníoka nna ka benne ugía leke ge ka tisa unne Pedruha, ka benneha udibake inda nna la sáha tteba nna bisela ttiba a tsunna mili ka benne kubi. Biselake len ka benne chi ria leke ge Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Iyába ka benne chi ria lekeha gwa ruinbake nu rule'eni ka apóstoal ke. Ttu tsapaba se'e len luesike lhe turo'oba roke yetta lhe ttúba rinneke tti rilhapike tisa len Tata Do Yebáha lhe. ");
INSERT INTO zae_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Iyába ka benne rasibakanie de rilákanie ixeba ka milagru lhe adíru ka nu rebanakanie geni ruin ka apóstol ge Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Iyába ka benne chi ria leke ge Jesús‑ni ttu tsapaba se'e len luesike lhe anágaba bixaba tee geke nna ge iyábake reyaka nuha. ");
INSERT INTO zae_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Rutto'obake ka lo yu gekeha lhe adíru nu tee geke lhe, belhuha nna ritidhina geke kua riyasabani ttu ttuke. ");
INSERT INTO zae_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Labí rudhanke, ttu ttu sába ritupake ata do yotuha lhe anágaba lhe'e ka yo'o gekeha itú iki itú leke ro len luesike yetta de elha gwedeaka lasi ");
INSERT INTO zae_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","lhe anágaba rulhagabake ge Tata Do Yebáha. Laxkala iyába ka nu lhe'esi Jerusalén‑ni rakakinna geke, lhe ttu ttu ságaba rutselaru Tata Xisiha adíru ka benne chi ga'ananie odilábie ke, rutsele ke len ka benne chi ria leke gebie. ");
INSERT INTO zae_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ttu sá ugwapi Pedruha dia lenna Juan‑ni ttiba tu retin tsunna nuha diakana ata do yotuha, kumu uraha rilhapi ka benne tisa len Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ro'o yotuha do ttu nubiyú anka xii ka ni'ani. Aníha‑ba ankana attili ulinaha nna ttu ttu sába radokana na daka ata du puerta nu tee láni Puerta Nu Anka Latsiru. Radokana nuha niha kini rinnabana belhiu len ka benne ra'a lali'a ge yotuha. ");
INSERT INTO zae_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tti bilen nubiyúha Pedruha lhe Juan‑ni lhe diakana ga'akana lali'a ge yotuha, nianna tti unnena rinnabana kana belhiu. ");
INSERT INTO zae_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Lakana nna belanni tsittabakana loni, nianna tti unne Pedruha, rana nubiyúha: ―¡Begía lotu! ");
INSERT INTO zae_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Lana nna “O” ba rana begíana lokani nna ubedaba dona kini ugwekana na belhiu. ");
INSERT INTO zae_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ttaka Pedruha nna rana na: ―Neti labí belhiu kia tee kini utea gelu. Gutebaa len lu nu téruba kia. ¡Jesucristu ge Nazaret‑ni rudettia, udú lii nna udá! ");
INSERT INTO zae_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nianna tti bedaxxu Pedruha ná ben‑ni nna tti bedhú liina na. Looraha tteba nna bedá rea tteba lhe'e ka ni'aniha lhe bedá rea tteba lhe'e ka sitta dheti geniha lhe. ");
INSERT INTO zae_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nianna gintsaba udú liina nna udulo ttebana udána. Nianna tti uta'ana len ka Pedruha lali'a ge yotuha, ridábana lhe rigintsa ladhibana rulhana ge Tata Do Yebáha ");
INSERT INTO zae_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","nna iyába ka benne rilákanie chi redána lhe rulhana ge Tata Do Yebáha lhe, ");
INSERT INTO zae_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","bebanabakanie lhe uka tébakanie tti bilákanie nu ukaha, kumu beyakabiabakanie na. Labana nuha ridona ro'o yotuha rinnabana belhiu daka ata du puerta nu tee láni Puerta Nu Anka Latsiru. ");
INSERT INTO zae_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nubiyú chi beyakaha labí rudhanna Pedruha lhe Juan‑ni lhe danalhabana kana. Ka benne se'e niha nna iyábake rebanabakanie ge nu ukaha nna bigaa ttebake diake ata se'ekanaha ata daa kweredori nu tee láni Kweredori ge Salomón. ");
INSERT INTO zae_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tti bilani Pedruha chi tupa xxatta ka benne, nianna tti rana ke: ―Lebi'i benne Israel, ¿beaka rebana xxattinle ge nu rilenle‑ni? Lhe ¿beaka doba lole ri'itu lhe? ¿Si rakinle deki ri'ibatu beyointu nubiyú‑ni de ra xxeni letu lhe o de ankatu benne rudo tsitsirutu tisa ge Tata Do Yebáha? ");
INSERT INTO zae_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ko'o labí ri'itu, sinuki Tata Do Yebaa benne anke Diosi ge Abraham‑ni lhe ge Isaac‑ni lhe ge Jacob‑ni, lhe ge adíru ka benne ukake xuttori'iha lhe, benneha‑ba benie kini uná xxeni le Jesús benne anke Xi'inieha, delába Jesús benne bedaxxuleha nna gwaga'alee lo ná ka uxtisiha, nianna labí uxielhale kini olhaa Pilato‑nie, tti rana deki olhábane. ");
INSERT INTO zae_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ttaka lebi'i nna ulu'ula ni'ale benne runie nu dika ixúha lhe anke ge Tata Do Yebáha lhe. Betse'e loona, lebi'i, nu ben elhuttiha‑la unnabale kini bodilaa Pilato‑ni ");
INSERT INTO zae_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","nna benne runie kini aka benri'i ttu dia liiha‑la bettile, ttaka Tata Do Yebáha belhidha benbe benneha lagwi ge ka benne chi uttiha. Ri'itu biyú lotu iyá nu ukaha. ");
INSERT INTO zae_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Laxkala nubiyú du nii, nu ankabienle‑ni lhe rilenle‑ni lhe, de ugía leni ge Jesús‑ni, de nuha nna benie kini bedú tsitsina. De ugía leni gebie, de nuha nna chi beyaka chána. Lebi'i gwa ruyúba lole deki chi beyakana. ");
INSERT INTO zae_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Neti yu xeabaa xa betsi to, lebi'i lhe ka nu rinnabia gele‑na lhe, de abíba yule nna bedhakale Jesús‑ni aníha. ");
INSERT INTO zae_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ttaka Tata Do Yebáha aníha benie kini uka nu chi unnebie itú ttuha. Bixúnie iyá ka profeta geeha kini ka benneha unneke, ráke deki Cristu idhelheha teeki gatti benneha. ");
INSERT INTO zae_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Laxkala lebi'i gwalodúna le ge nu ruinle nna gwalodaxxu neda ge Tata Xisiha kini oxíe ka tulha gele‑na. La'ania nna unie kini lebi'i saría tsena le ");
INSERT INTO zae_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","nna idhelhe Cristuha gele, delába Jesús benne chi ga'ananie idhelheha. ");
INSERT INTO zae_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ttaka teeki dho Cristuha kwede yebáha axtaliba ganna chi bisia sá ose'e tse Tata Do Yebáha iyá tte nu se'e. Akaba atti tteba chi ree akaha. Ka profeta geeha, ka benne use'e itú nu reha, ka benneha bixúnie kini utixxi'ake ge nu akaha, ");
INSERT INTO zae_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","attiba Moisés‑ni rana ka benne uka xuttori'iha: “Tata Do Yebaa benne anke Xxanari'iha, labie unie kini lagwi gebale kweabie ttu benne ake profeta attiba neti. Udole tisa ge iyá tte nu inná benneha. ");
INSERT INTO zae_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ttaka nu abittu udona tisa ge benneha, ttu tsaba chadi gaa nuha, labíru aka iselana ka benne chi ankake ge Tata Do Yebáha.” ");
INSERT INTO zae_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Debá Samuel‑ni nna, iyába ka profetaha unneke ge nu chi raka nnanna. ");
INSERT INTO zae_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Lebi'i dhile nu chi ra ka benneha lhe anágaba ralhagabale dhile nu chi ra Tata Do Yebáha Abraham‑ni ugwebie ka xuttori'iha. Tti bodha'an tsitsi tisa gebie len Abraham‑ni, la'ania rabie na: “Ka benne datialuha, ka benneha ixúti kini unia ki saría tsena iyá ka benne se'e yiesi lo yu‑ni.” ");
INSERT INTO zae_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Laxkala tti belhidha benbie Xi'inieha lo elhuttiha, len lebi'i nuha lade'a tte udhelhe benneha kini aka lenie le, kini anáchu nna ttu ttule udhanle nu satsa ruinle‑na. ");
INSERT INTO zae_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Sa dula Pedruha lhe Juan‑ni lhe rinne lenke ka benne tupa ro'o yotuha, ttiruba chi bisin ka bixxudiha, dia lenkana nu baninna ka nu rise'e ruyúkana ro'o yotuha. Chegabakana ka nu tee lákani saduceo. ");
INSERT INTO zae_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Risa'akinna kumu de Pedruha lhe Juan‑ni lhe rule'ekanie ka benne lhe rágabake ka benneha deki tti beyaka ben Jesús‑ni lo elhuttiha, nuha benna liina deki ka benne chi uttiha gweyaka benbake. ");
INSERT INTO zae_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nianna tti bedaxxu ttebakana ka Pedruha nna bega'akana ke lisiyya, ttaka kumu de chi galá dia ralha nuha, de nuha nna attu sáliba bebeakana ke. ");
INSERT INTO zae_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ttaka ixe ka benne biyienkanie nu rigixxi'a ka benneha ge Jesús‑ni, nianna ugía tteba leke gebie nna biselarula ttiba a gayu mili ka benne subi. Sun tterula ka benne biyúha nuha bibaba. ");
INSERT INTO zae_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Beyeki sáha nna betupa ka nu rinnabia ge ka nu Israel‑ni lhe'esi Jerusalén‑ni, lenkana ka benneola gekaniha lhe ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Iyágaba Anás nu anka bixxudi xeniha lhe Caifás‑ni lhe Juan‑ni lhe Alejandro‑ni lhe adíru ka nu raka luesi bixxudi xeniha lhe, iyábakana bitupakana niha. ");
INSERT INTO zae_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nianna udhelhakana ka nu gwaleakana Pedruha lhe Juan‑ni lhe, gwaleakana ke lhe'e lisiyyaha, nianna tti bese'ekana ke lagwi gekani. Nianna tti unnaba tisakana ke, rákana ke: ―Lebi'i nna, ¿núla betena lo neda gele kini ruinle nuní lhe núla udelhana le lhe? ");
INSERT INTO zae_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedruha nna yu'u galába Espíritu ge Tata Do Yebáha itúba latie, nianna tti unnebie ree: ―Gwaluyúruga xa benne rinnabia ge Israel lhe lebi'i ka tata benneola lhe, ");
INSERT INTO zae_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","lebi'i rinnaba tisale ri'itu ge nu tse bentu len benne rani‑ni. Rinnaba tisale gasina uka kini beyaka benne‑ni. ");
INSERT INTO zae_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nnanna nna raka letu unale lhe unagaba iyá tte ka benne Israel‑ni lhe, Jesucristu ge Nazaret, benne betále lo ya kurusiha, delába benne belhidha ben Tata Do Yebáha lagwi ge ka benne chi uttiha, benneha nuha betebie lo neda getu kini bentu ki beyaka nubiyú du arlole‑ni. ");
INSERT INTO zae_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesucristuha‑gaba nuha anke attiba íyya nu rikua ttu yo'o. Lebi'i nna ankale attiba ka nu rukuakana íyya ge yo'oha nna ulu'u ni'ale Jesús benne anke íyyaha. Ttaka nnanna benneha‑la nuha chi bisine uke íyya nu rixúru. ");
INSERT INTO zae_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Lhe anágaba lanú attu nuxa gwaka geni odilána ri'i, kumu lanú attu benne chi udhelha Tata Do Yebáha yiesi lo yu‑ni kini odilábie ri'i, sunruba Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tti bilani ka nu rinnabiaha deki labí rasin Pedruha lhe Juan‑ni lhe, anágaba nna yúgabakana deki labí yetsi raka geke lhe labí tte detike lhe, nianna bebanabakinna nna tti ute dákinna deki gwalíba ugweki ka benneha len Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Gwea nna ata se'ekanaha‑gaba du nubiyú chi beyakaha, laxkala labí tee ro'okani bixa innákana. ");
INSERT INTO zae_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nianna tti bebeakana ka Pedruha ata se'ekanaha nna suna labakana beya'ankana rinne len luesikani, ");
INSERT INTO zae_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","rákana: ―¿Bíla anka nu uinri'i len ka nuní ganna? Kumu iyába ka benne se'e Jerusalén‑ni chi yuke deki gwalíba chi ben ka nuní ttu milagru nu dika ebaninri'i geni. Ri'i nna labí dika innári'i deki labí lii ben ka nuní milagruha. ");
INSERT INTO zae_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Sun tteruba ttu nu uinri'i, uniasibinri'i kana kini udhankana abitturu kixxi'akana ge Jesús‑ni len adíru ka benne. Aníha kini abitturu chadhi ka tisa ge Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Aníoka nna beyaxikana ka Pedruha nna ttu tsaba besunakana rákana ke: ―Abitturu kixxi'ale ge Jesús‑ni lhe abittugaba ula'aruinle ka benne ge nuná lhe. ");
INSERT INTO zae_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ttaka Pedruha lhe Juan‑ni lhe bekabilake gekani ráke kana: ―Naba se'ele, gwalinnáchu, ¿si tseba anka ganna ttixka gelale udotu tisa attichula ge Tata Do Yebáha? ");
INSERT INTO zae_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kumu ri'itu labí aka getu udhantu a kixxi'atu ge nu chi biyienintu lhe ge nu chi bilentu lhe. ");
INSERT INTO zae_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ka nu rinnabiaha nna bedhaka disakana ka Pedruha, nialiba nna tti bolhákana ke. Bolhákana ke kumu de labí gwaxxakakana bixa ge ugwekana ke elha disa lhe anágaba de rixxusagabakinna ge ka benne, kumu iyábake rebanabakanie ge Tata Do Yebáha de nu chi ukaha, nianna tti ráke: ―¡Xxeniba ra le Tata Do Yebáha! ");
INSERT INTO zae_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Aníha ráke kumu nubiyú beyaka len milagruha chiba du nuha gwa tee chua (40) ida. ");
INSERT INTO zae_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Iki de chi begwelha ka nu rinnabia ge ka nu Israel‑ni deyya Pedruha lhe Juan‑ni lhe, nianna tti besinke ata se'e adí ka benne chi ria leke ge Jesús‑ni nna utixxi'akanie ka benneha ge iyá nu ra ka nu loni ge ka bixxudiha lhe nu ra ka benneola gekaniha lhe. ");
INSERT INTO zae_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ka benneha nna, iki de chi binake iyá nuha, nianna turo'oba unneke len Tata Do Yebáha, ráke: ―Tata Xisi to, kwinalu benlu yebáha lhe yiesi lo yu‑ni lhe indatooha lhe. Anágaba bengabalu iyá tte ka nu rapa ka nuní lhe. ");
INSERT INTO zae_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Lu bixuinlu ro'o David benne bixúe lo sina geluha, kini unnebie ree: ¿Beaka risa'a xxattakin nu dittu‑na, lhe beaka rulaba lekani nu abittu dika ixú lhe? ");
INSERT INTO zae_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ka nu rinnabia‑na lhe ka nu ankakana ka nu loni se'e yiesi lo yu‑ni lhe, ka nuná turo'oba riakana redú disakana lo Tata Xisiha, lhe lo Cristu benne udhelheha lhe. ");
INSERT INTO zae_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Gwalí galá, ki nuha ben Herodes‑ni lhe Poncio Pilato‑ni lhe, lakana lenkana ka nu dittuha lhe iyágaba ka nu Israel‑ni lhe, bitupakana lhe'esi‑ni kini bebi'i nookana Xi'inlu Jesús‑ni, delába benne chi ulesilu kini ake Cristu. ");
INSERT INTO zae_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Aníha benkana kini uka iyá nu chi bodha'anlu lhe iyá chi ralu aka lhe. ");
INSERT INTO zae_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nnanna xa Tata Xisi to, biyúruga bí ruinkana rudhaka disakana ri'itu. De nuha nna rinnabatu len kwinalu, aka lenlu ri'itu, ri'itu ka benne ruintu sina gelu, rinnabatu lenlu kini abittu gasintu tti kixxi'atu ka tisa gelu‑ni. ");
INSERT INTO zae_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Lu nna bele'e nu xxeni ra lelu kini eyaka ka benne rani lhe kini aka ka milagru lhe adíru ka nu ebanintu geni lhe. Iyá nuní aka kumu Xi'inlu Jesús, benne chi ulesiluha, benneha unie kini aka iyá nuní. ");
INSERT INTO zae_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tti chi uluxa ulhapike tisa len Tata Do Yebáha, nianna tti bixú ata tupakeha. La'ania nuha bisia Espíritu ge Tata Do Yebáha uyu'e itúba latike nna labí rasikanie tti rigixxi'ake ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Iyába ka benne chi ria leke ge Jesús‑ni, ttúba du leke lhe ttúba rulaba leke lhe. Ni ttúke labí innáke: “Suna kibaa anka nu tee‑ni.” Sinuki iyába nu tee geke, ge iyábake reyakana. ");
INSERT INTO zae_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ka apóstoal nna tsitsiba ra leke rigixxi'ake ráke: ―Beyaka benba Jesús benne anke Xxanari'iha lo elhuttiha. Anágaba lhe yalhá redá le Tata Do Yebáha raka lenie iyába ka benne chi ria leke Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Laxkala ni ttú ka benne selake ka benneha, labí riyasakanie ttu bixa kumu ata se'e lo yu geke lhe o ata sia lisike lhe, ka benneha rutto'oke ka nuha nna belhiu ge nu rutto'okeha nna ");
INSERT INTO zae_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ruteke nuha len ka apóstoal, kini ka benneha nna rigidhike nuha ge ka benne kua riyasabani ttu ttuke. ");
INSERT INTO zae_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Aníha‑ba ben ttu benne tee lábie José. Benneha datiabie Leví. Labie dabie daka lo yu nu tee láni Chipre. Nuha rena lagwi indatooha. Benneha nuha utixxa ka apóstoal lábie Bernabé. Bernabé dienna innána benne rodú tsebie le ka benne. ");
INSERT INTO zae_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Benneha tee ttu lo yu gebie nna betto'obie nuha. Belhiu ge yuha nna betebie na len ka apóstoal. ");
INSERT INTO zae_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ttaka udogaba attu benne biyú utta lábie Ananías lenie benne nuila geeha. Benne nuilaha utta lábie Safira. Ka benneha betto'oke ttu lo yu geke ");
INSERT INTO zae_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","nna beteke belhiu ge yuha len ka apóstol ge Jesús‑ni. Ttaka benne nuilaha yube deki utuaba benne biyúha iki belhuha; labí iyá nuha betebie len ka apóstoal. ");
INSERT INTO zae_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedruha nna rabie benne biyúha: ―Ananías, ¿beaka uxielhalu ge nu xxegwiha nna ruinlu dhi yielu Espíritu ge Tata Do Yebáha, delo nna utualu iki belhiu ge yu betto'oluha? ");
INSERT INTO zae_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Laaba ganna gebalu yuha nna ganna betto'olu nuha nna gwa ukaba gelu bixaba ben lenlu belhuha? ¿Beaka besi'inulu nna benlu aní? Laa rakaginlu len ka benne nuní ben lelu; len Tata Do Yebáha nuní ben lelu. ");
INSERT INTO zae_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tti biyienin Ananías‑ni nu ra Pedruha, nianna ubixxie nna utti ttebe. Iyába ka benne binake ge nu ukuha, yalhá usi xxattakanie. ");
INSERT INTO zae_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nianna tti ubiga ttu chupa ka nu kwiti nna bottesikana benneha lari nna gwakatsikane. ");
INSERT INTO zae_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Atti chi ute ttiba tsunna uraha nna lengwa chi bisin Safira, benne nuila ge Ananías‑ni. Labí yu benneha bixa chi uka. ");
INSERT INTO zae_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedruha nna unnaba tise benne nuilaha, ree bie: ―Utixxi'a, ¿si ttanába betto'ole yuha? Benne nuilaha nna bekabie ree: ―¡Ttaná galá! ");
INSERT INTO zae_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedruha nna rabie benneha: ―¿Beaka turo'oba ugíalu nubiyú geluha benle ku'ule prueba Espíritu ge Tata Xisiha? Biyúruga, ne ka nu gwakatsikana nubiyú geluha chi dedá eta'a ro'o yo'o‑ni. Anágaba lu ichegabakana lu takatsigabakana lu. ");
INSERT INTO zae_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Looraha tteba nna bedebixxi lo Safiraha arlo Pedruha nna bedeatti ttebe. Atti chi beta'a ka nu kwiti gwakatsikana benne nubiyú geeha, nianna bedelákinna chi dedete benne nuilaha bedeattie. Nianna dedeche ttebakane nna gwadikatsikane ata bigatsi nubiyú geeha. ");
INSERT INTO zae_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Iyába ka benne chi ria leke ge Jesús‑ni lhe iyába ka nu binakana ge nu ukaha, yalhá usi xxattakinna. ");
INSERT INTO zae_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ixeeru ka milagru lhe ixeeru ka nu rebaninri'i geni ben ka apóstol ge Jesús‑ni lhe'esi Jerusalén‑ni nna iyába ka benne chi ria leke ge Jesús‑ni nna ttúba ritupake ro'o yotuha ata daa kweredori nu tee láni Kweredori ge Salomón. ");
INSERT INTO zae_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ttaka adíke nna labí reyaxakanie tatselake ka benneha, meskiba iyábake gwa ru'uba leke nu ruin ka apóstoal. ");
INSERT INTO zae_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Laa kiga de nuha nna adikala dia raniru ka benne biyú lhe ka benne nuila ria leke ge Jesús benne anke Xxanari'iha. ");
INSERT INTO zae_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Axtaba ro'o ka nedaha ribeake ka benne raniha, rigixxake ka benneha lo ka ta'a kini ganna chi tte Pedruha nna kwadiba lixxínani tsu'u lo ttu chupake kini eyakake. ");
INSERT INTO zae_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Anágaba ka benne ge adí ka yiesi se'e gaxxaba ka niha, ixe juisiru ka benneha riake lhe'esi Jerusalén‑ni, richeke ka benne rani gekeha lhe ka benne yu'u espíritu satsa latikeha lhe, iyába ka benneha gwa reyakabake. ");
INSERT INTO zae_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","De nuha nna bixxudi xeniha lhe iyába ka nu gwa se'ekana lennaha lhe, delába ka nu tee lákani saduceo, ka nuha juisia betía di lekani ka apóstol ge Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nianna tti bedaxxukana ke nna bedheakana ke lisiyya. ");
INSERT INTO zae_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ttaka ttu anjeli ge Tata Xisiha lo relaha gwadhalie lisiyyaha kini bebeabie ka benneha, nianna tti ree ke: ");
INSERT INTO zae_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Gwaleyya nna gwaltsia ro'o yotuha nna gwalikixxi'en ka benne se'e niha gasina udaxxuke neda ge Jesús‑ni kini gatta elha nabani geke ttu dia lii. ");
INSERT INTO zae_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Lake nna bedoba nagake ge nu ra benneha. Laxkala ugwani dilaha nna dila tteba chi uta'ake lali'a ge yotuha nna udulo ttebake rule'ekanie ka benne tupa niha. Bixxudi xeniha lenna ka nu gwa se'ekana lennaha, bottupa ttebakana ka nu ruin elhuxtisi ge ka nu Israel‑ni lhe iyába ka benneola gekaniha lhe, nianna tti udhelhakana ka nu tsiakana kini saleakana Pedruha lhe Juan‑ni lhe'e lisiyyaha. ");
INSERT INTO zae_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ttaka tti bisin ka nu diakana ubea ka benneha, nurua ka benneha gwaxxakakana niha. Nianna tti beyeki ttebakana gwattixxi'akana rákana: ");
INSERT INTO zae_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","―Tsitsiba yaya lisiyyaha tti bisintuha nna ka nu se'e ruyúkana ro'o nuha, niha‑ba se'ekana, ttaka tti udhalitu uta'atuha, nurua ka nu tee lisiyyaha gwaxxakatu. ");
INSERT INTO zae_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bixxudi xeniha lhe nu baninna ka nu rise'e gweyú ro'o yotuha lhe anágaba adíru ka nu loni ge ka bixxudiha lhe, tti biyienkinna nu ra ka nuha, nianna rugía ya'abakana, rákana: ―¿Galabasina lhuxa loo nuní? ");
INSERT INTO zae_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nuha‑ba rákana se'ekana, ttiruba chi uka xxe ttu benne bisine, ree kana: ―Nela ka nu utixxale lisiyyaha chi se'e ro'o yotuha rule'ekinna ka benne ka tisa ge Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nianna dia tteba nu baninna ka nu rise'e gweyú ro'o yotuha itupa lenna ka gwensina geniha gwaxxíkana ka benne utta lisiyyaha. Labí bedhaka disakana ke, kumu rasibakinna kini ka usia ka benne tupa niha kana íyya. ");
INSERT INTO zae_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tti chi besin lenkana ka benneha arlo ka nu runi elhuxtisiha, nianna tti unne bixxudi xeniha rana ke: ");
INSERT INTO zae_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Laaba ttu tsa chi ratu le deki labíru kixxi'ale ge nubiyú rekile rigixxi'ale‑na? Ttaka lebi'i nna adíla ruinle. Gwaluyúruga iyába ka nu se'e Jerusalén‑ni chi bega'ale tisa gele‑na ikikani. Gwea nna ruinle udelhale kwe'etu deki ri'ibatu bettitu nubiyú nu rekile rigixxi'ale gen‑na. ");
INSERT INTO zae_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedruha lenie adí ka apóstoal nna bekabike geni, ráke: ―Ri'itu rakarula doelha udotu tisa ge Tata Do Yebáha attichula ge ka benne se'e yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tata Do Yebaa benne anka Diosi ge ka benne uka xuttori'iha, benneha belhidhe Jesús‑ni lo elhuttiha, delába Jesús benne bettileha nna betálee lo ya kurusiha. ");
INSERT INTO zae_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Benneha nuha ulhapi Tata Do Yebáha lebie nna bedoe bie daka ná benbie kini ake nu loni ge ka benne lhe odilábie ke lhe. Aníha kini ri'i ka benne Israel odúna ri'i nna odaxxuri'i neda ge Tata Do Yebáha, kini anáchu nna ixú elha xen lasi ge ka tulha ruinri'i. ");
INSERT INTO zae_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ri'itu lhe Espíritu bete Tata Do Yebáha ge ka benne gwa rudobake tisa gebie, iyábatu biyú lotu ge iyá nu ukaha. ");
INSERT INTO zae_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tti biyienkinna nu ra ka benneha, nianna bituxxu xxattakinna nna ruinkana uttikana ke. ");
INSERT INTO zae_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ttaka ttu fariseo nu tee láni Gamaliel selana lhe'e ka nu runi elhuxtisiha, lana ankana ttu ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni nna iyába ka nu lhe'esiha ria lekani na. Nuha udú liina nna rana ka nu se'e niha ebeakana ka apóstoal satti ata se'ekanaha. ");
INSERT INTO zae_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nianna tti unnena, rana: ―Xa benne Israel, gwaluyú gele ganna bixa udhakale ka nubiyú‑na. ");
INSERT INTO zae_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Yule itú ttuha uleagaba lo nu utta láni Teudas. Nuha la'ania rana deki lana ankana ttu nu ra xxeni leni. Laxkala ttiba ttu ttapa gayua (400) ka nubiyú gwanalhakana na. Ttaka bettibakana Teudas‑ni nna iyába ka nu gwanalhakana naha nna ugwadhibakana nna siiba beyaka. ");
INSERT INTO zae_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Iki de nuha nna bedebeagaba lo Judas ge Galilea‑ni tti reyadha lá ka benne geri'i. La'ania Judas‑ni udaagabana benoo xanni ixeru ka benne. Ttaka bedeottigabakana na nna iyába ka nu gwanalhakana naha nna bedeadhigaba ka nuha. ");
INSERT INTO zae_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","De nuha nna raka lasia upeya le: ka nubiyú se'e naa, gwalolhaa ka nuná. Bittu bi udhakale kana, kumu ganna tisa nu rigixxi'a ka nuná, gwa ankabana ge ka benne se'e yiesi lo yu‑ni, la'ania nna gwese'e looba ka tisa‑na. ");
INSERT INTO zae_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ttaka ganna ankaba ka tisa‑na ge Tata Do Yebáha, la'ania nna lebi'i labí dhaale utse'e loole kana. Gwaluyú gele, ni kina len Tata Do Yebáha‑la nuní yu'ule utilha. ");
INSERT INTO zae_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Lakana nna gwa bedoba nagakani ge nu ra Gamaliel‑ni kana. Niala nna tti beyaxikana ka apóstoal nna uyakana ke. Iki de chi uyakana keha nna tti besunakana rákana ke: ―Bitturu kixxi'ale ge Jesús‑ni. Iki deliba chi rákana ke aníha, nianna tti bolhákana ke. ");
INSERT INTO zae_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Lake nna redeakabakanie beriake arlo ka nu runi elhuxtisiha. Redeakakanie kumu Tata Do Yebáha rugwelhe ki rudhaka disakana ke de rigixxi'ake ge Jesús‑ni ");
INSERT INTO zae_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","nna ttu ttu sába se'eke lhe'e yotuha lhe ttu ttu sába ritupake lhe'e ka yo'o geke lhe, labí rudú siike rule'eke lhe a rigixxi'ake deki Jesús‑ni anke Cristu. ");
INSERT INTO zae_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","La'ania, kumu de chi dia rani ka benne ria leke ge Jesús‑ni, de nuha nna ka benne rinneke tisa griegu chi uduloke rinne bexeake ge ka benne rinne tisa hebreo. Ráke deki ka nuila bidabi geke, delába ka benne rinneke tisa griegu, labí ridí ka benneha ixeni nu ritidhi roke ttu ttu sá. ");
INSERT INTO zae_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Aníha uka nna bottupa ka benne tsi'inu (12) anka apóstoal iyába ka benne chi ria leke ge Jesús‑ni. Nianna ráke ka benneha: ―Labí aka ganna ri'itu udú siitu a kixxi'arutu ka tisa ge Tata Do Yebáha nna sunruba ugidhi nu go ka benne nuila bidabi‑ni tsekitu. ");
INSERT INTO zae_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","De nuha nna xa betsi to, gwalukwe a gasi ka benne biyú ka benne selake len lebi'i, ka benne gwa dika uxxen leri'i geke lhe rapa elha rieni lhe, anágaba nna ankagabake benne yu'u Espíritu ge Tata Do Yebáha itú latike. Gwalukwe ke kini use'eri'i ke ki kidhike nu go ka benne nuila bidabi‑ni, ");
INSERT INTO zae_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kini ri'itu nna udoruna letu ilhapitu tisa len Tata Do Yebáha lhe kixxi'arutu ka tisa geeha lhe. ");
INSERT INTO zae_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Iyába ka benneha gwa bokinniba ikike ge nu ra ka apóstol‑ni ke, nianna tti bodúke Esteban benne chi ria tsitsi lebie ge Tata Do Yebáha lhe chi yu'u Espíritu geeha itúba latie lhe, anágaba bodúgabake Felipe lhe Prócoro lhe Nicanor lhe Timón lhe Pármenas lhe Nicolás benne anke ge lhe'esi Antioquía‑ni, benne beyakagabe nu Israel lhe riagaba lebie attigaba ria le ka benneha lhe. ");
INSERT INTO zae_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nianna tti betso duke ka benneha arlo ka apóstoal. Ka apóstoal nna ulhapike tisa len Tata Do Yebáha nna uxxua náke iki ka benneha. ");
INSERT INTO zae_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ka tisa ge Tata Do Yebáha nna adíla diaru ka benneha radhike. Anágaba ka benne chi ria leke ge Jesús‑ni yalhá chi rani xxattake lhe'esi Jerusalén‑ni. Anágaba ka bixxudiha, ixegabakana ugía lekani ge Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban‑ni nna tsitsiba ra leni lhe bete tamaba Tata Do Yebáha elha tse geni kini ruinna ka milagru lagwi ge ka benne lhe adíru ka nu rebanakanie geni lhe. ");
INSERT INTO zae_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ttaka ttu chupa ka nu Israel ka nu dákana lhe'e yo'o ata rudhetikana ka tisa ge Tata Do Yebáha, delába ka nu tee lákani Ka Benne Chi Reyeki Lhaa, ka nuha itupa lenkana ka nu dákana daka Cirene lhe daka Alejandría lhe, anágaba ka nu dákana daka Cilicia lhe daka Asia lhe, iyábakana bese'e disakana lo Esteban‑ni. ");
INSERT INTO zae_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ttaka labí udúkana loni kumu Espíritu ge Tata Do Yebáha‑ba rugwebie na elha rieni kini rinnena. ");
INSERT INTO zae_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ka nuha ulu'ukana belhiu lasi ná ttu chupa ka nu innákana deki chi biyienkinna rigua Esteban‑ni bala'ana ge Moisés‑ni lhe ge Tata Do Yebáha lhe. ");
INSERT INTO zae_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Aníoka nna betsatsakana ka benne lhe ka benneola gekaniha lhe, anágaba ka nu rule'ekinna ka benne nu ra lo bia bennabi bodha'an Moisés‑ni lhe. Nianna tti ugíakana gwadaxxukana Esteban‑ni nna chekana na gwaga'akana na lo ná ka nu runi elhuxtisi ge ka nu Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Utilagabakana ka nu ben lekani kini besiakana ikini rákana: ―Nubiyú du nii birula rudú siina riguana bala'ana ge yotu le'a geri'i‑ni lhe ge bia bennabi geri'i‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kumu chi biyienintu rana: “Jesús ge Nazaret‑ni utse'e loobana yotu‑ni lhe otseabana ka nu labinri'i ruinri'i, delába ka nu bodha'an Moisés‑ni uinri'i.” ");
INSERT INTO zae_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ka nu runi elhuxtisiha nna, iyábakana belannikana lo Esteban‑ni, nianna tti bela'akinna loni ttiba lo ttu anjeli ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nianna tti unnaba tisa bixxudi xeniha Esteban‑ni, rana na: ―¿Si gwalí nu ra ka nuní? ");
INSERT INTO zae_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Lana nna bekabina, rana: ―Xa betsi to lhe xa tata benneola lhe, gwaludoruga nagale kia. Tata Do Yebáha benne ra xxeni leeha, labie bele'e lobie lani xxudiri'i Abraham‑ni atti sa do benneha Mesopotamia atti lanila isiabie dhoe lhe'esi Harán‑ni. ");
INSERT INTO zae_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","La'ania unnebie ree Abraham‑ni: “Bedhá ikilu lhe'esi gelu‑na lhe ka benne raka luesilu‑na lhe, biria nna ugía lo yu ata ule'enia lu.” ");
INSERT INTO zae_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Aníha uka nna biria Abraham‑ni lo yu ge ka nu Caldea‑ni nna die gwadhoe daka Harán. Iki de chi utti tata geeha, nianna che Tata Do Yebáha bie kini bisiabie nna udoe lo yu ata se'ele nnanna. ");
INSERT INTO zae_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","La'ania labí begwe tte Tata Do Yebáha bie niru latti lo yu ata dhobie. Ttaka bodha'an tsitsi tisa gebie len benneha, ree bie: “Gutebaa lo yu‑ni gelu lhe ge ka xi'inlu lhe ge ka xidholu ka nu si daa.” Aníha ra Tata Do Yebáha Abraham‑ni la'ania, meskiba tti ree benneha aníha lanú xi'in Abraham‑ni chi tee. ");
INSERT INTO zae_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Anágaba lhe rágabe Abraham‑ni deki ka xi'inie lhe ka xidhoe lhe, delába ka benne datiake bie, ka benneha akake benne dittu tse'eke lo yu ge ka nu dittu. Ka nuha nna urenkana ke sina lhe uyú satsakana ke delo ttapa gayua (400) ida. ");
INSERT INTO zae_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ttaka rágaba Tata Do Yebáha bie: “Neti utea elha disa ge yiesi nu urenna ka benne geluha sina. Iki de nuha‑liba nna tti eriake niha, nianna tti esiake nii nna uinke le'a kia.” ");
INSERT INTO zae_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Bodha'angaba Tata Do Yebáha len Abraham‑ni kini ichúe lo bela lati ka benne biyú. Aníha kini eya'an tsitsi tisa nu begwekeha. Laxkala atti chi uli xi'in biyú Abraham‑ni, delába Isaac‑ni, atti chi ankinna xxunu ubisaha, la'ania nna uchú Abraham‑ni lo bela latibi. Aníha‑gaba bedhaka Isaac‑ni xi'inni Jacob‑ni. Jacob‑ni nna aníha‑gaba bedeonna len ka xi'inniha, delába ka benne tsi'inu (12) ukake xxudi ka benne uka xuttori'iha. ");
INSERT INTO zae_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ka xi'in Jacob‑ni, delába ka benne uka xuttori'iha, ka benneha betía di leke betsike José‑ni, nna betto'oke benneha len ka nu chekane daka Egipto. Ttaka Tata Do Yebáha nna gwa udúbe len José‑ni ");
INSERT INTO zae_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","lhe gwa bodilágabe benneha lo iyába nu gwateeha lhe begwegabe bie elha rieni lhe. Bengabe kini Faraón nu unnabiana Egipto‑ni uyu'u leni nu ben José‑ni. De nuha nna Faraón‑ni bedúna José‑ni kini innabie ka yiesi se'e daka Egipto‑ni lhe innabiagabe ka nu riben sina lhe'e yo'o ge Faraón‑ni lhe. ");
INSERT INTO zae_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’La'ania nuha bisia ttu ubina itúba lo yu ge Egipto‑ni lhe ge Canaán‑ni lhe. Ttu elha disa tsitsi nuha biyú ka benne la'ania. Laxkala ka benne uka xuttori'iha labíru nu goke tee. ");
INSERT INTO zae_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Tti bina Jacob‑ni deki daka Egipto, niha tee xuxtila, nianna udhelhe ka xi'in biyúeha kini ugíake niha, delába ka benne ukake xuttori'iha. ");
INSERT INTO zae_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ka benneha ttiliba chi diake Egipto‑ni nu berupa libeha, la'anialiba nna chi utixxi'en José‑ni ke deki labana nuha anka betsike. La'anialiba nna tti ubina Faraón‑ni gá daka daa José‑ni lhe nú benne raka luesini lhe. ");
INSERT INTO zae_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Iki de nuha nna tti ben José‑ni doelha gwaxí ka betsiniha tata gekeha, delába Jacob‑ni, itupa lenie iyá ka benne raka luesieha. Gayuna bixxi tsinu (75) anka de iyáke. ");
INSERT INTO zae_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Aníoka nna bisin Jacob‑ni daka Egipto nna niha‑ba uttie, lhe niha‑gaba utti ka xuttori'iha lhe. ");
INSERT INTO zae_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nianna dechekana ka sitta gekeha nna besin lenkana ka sittaha daka Siquem. Niha‑ba bigatsike lhe'e baa ata uyo'o Abraham‑ni, delába baa nu betto'o ka xi'in benne tee lábie Hamor. ");
INSERT INTO zae_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Atti chi dabigana aka nu chi ra Tata Do Yebáha Abraham‑ni, la'ania yalhá chi ugwani ka benne geri'i se'e Egipto‑ni. Ixebake chi raka. ");
INSERT INTO zae_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tti chi uta'a attu nu unnabiana Egipto‑ni, nuha labíru benbiana José‑ni. ");
INSERT INTO zae_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nu rinnabiaha besi'inuna nna bedhaka xiina ka benne uka xuttori'iha, bedo doelhana ke kini udhá ikike ka nuto chichi to gekeha kini gattikabi. ");
INSERT INTO zae_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","La'ania nuha uli Moisés‑ni. Labi ukabi ttu binto nu uyu'u le Tata Do Yebáha. Ka tata nan gebiha gatsiba biyúke bi lhe'e yo'o gekeha delo tsunna beaha. ");
INSERT INTO zae_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ttaka tti abitturu uka igatsibi lhe'e yo'o gekeha, nianna bedhába ikike bi. Nianna tti bedí xi'iniunná Faraón‑ni bi kini bodixenna bi attisidiba xi'inbani ukabi. ");
INSERT INTO zae_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Aníha uka nna bideti Moisés‑ni nna uxína elha rieni ge ka nu Egipto‑ni. De nuha nna tsitsiba unnena lhe tsitsiba uka elha ruin geni lhe. ");
INSERT INTO zae_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Tti chi ukinna chua (40) idaha, la'ania bebeki leni salannina ka benne geniha, delába ka benne Israel‑ni. ");
INSERT INTO zae_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ttaka tti bilenna daa ttu nu Egipto rayana ttu ka benne geniha, nianna diana gwadilána benneha nna bettibana nu Egiptoha. ");
INSERT INTO zae_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Aníha benna kumu rakinna kini ka benne Israel‑ni tte dákanie deki lana ixúni Tata Do Yebáha kini odilána ke. Ttaka lake nna labí belaba leke aníha. ");
INSERT INTO zae_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Beyeki sáha nna gwadixxakagaba Moisés‑ni a chupa ka benne Israel yu'uke utilha. Lana nna latsiruba betsilana ke. Nianna tti rana ke: “Ki betsi to gebale raka, ¿beaka yu'ule ritilhale?” ");
INSERT INTO zae_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ttaka nu rayana attu benneha nna besigalana Moisés‑ni nna rana na: “Ttinka lu, ¿nú bedúna lu kini innabialu lhe uinlu elhuxtisi getu lhe? ");
INSERT INTO zae_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Si redeongabalu edeottilu neti attigaba benlu len nu Egipto bettilu nnayaha?” ");
INSERT INTO zae_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tti biyienin Moisés‑ni nu ra nuha, nianna bexunni ttebana diana lo yu tee láni Madián, ttiba ttu nu dittu ukana udona niha. Niha uka chupa xi'inni. ");
INSERT INTO zae_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Iki de tti chi bedeaka chua (40) idaha, la'ania nna bele'e lo ttu anjeli ge Tata Do Yebáha len Moisés‑ni lo yu bisi ata do i'iya Sinaí‑ni. Bele'e loe lhe'e ttu belha ge gi riria lhe'e ttu xxiti re niha. ");
INSERT INTO zae_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés‑ni nna bebanabinna tti bilenna belhaha. Nianna tti ubigana kini ilá tsenna nu raka niha. Nianna tti biyieninna tsi'i Tata Xisiha rabie na: ");
INSERT INTO zae_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Neti ankaa Diosi ge ka benne ukake xuttoluha. Neti ankaa Diosi ge Abraham‑ni lhe ge Isaac‑ni lhe ge Jacob‑ni lhe.” Moisés‑ni nna bixidi ttebana kumu de usi xxattinna nna birua beyaxinna ulannina lhe'e xxitiha. ");
INSERT INTO zae_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nianna ra Tata Xisiha na: “Ulea ni'alu ka gwaracha gelu‑na, kumu ata dulu‑ni, yu le'aba anka benne‑ni. ");
INSERT INTO zae_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Neti chi biláti elha disa nu ruyú ka benne kia se'e Egiptoha lhe chi biyienti ribesi gweke lhe. Nnanna nna chi ugwadia kini odiláya ke. De nuha nna utá kini idhelhaa lu kini tsialu Egipto‑ni.” ");
INSERT INTO zae_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’La Moisés‑nigaba nuha bedú disakana loni tti rákana na: “Ttinka lu, ¿nú bodúna lu kini innabialu ri'itu lhe uinlu elhuxtisi getu lhe?” La lagabana nuha udhelha Tata Do Yebáha kini akana nu innabiana ka benne Israel‑ni lhe odilána ke lhe. Anjeli bele'e loe lhe'e xxitiha, benneha nuha bixúni Tata Do Yebáha kini uka Moisés‑ni nu innabia lhe nu odilána ka benne lhe. ");
INSERT INTO zae_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Lana nuha benna ka milagru lhe adíru ka nu rebaninri'i geni tti bebeana ke lo yu ge Egipto‑ni lhe tti beteke lo indatoo nu tee láni Indatoo Xiná lhe tti ugwekike lo yu bisiha delo chua (40) idaha lhe. ");
INSERT INTO zae_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","’Moisés‑nigaba nuha rana ka benne Israel‑ni: “Tata Do Yebaa benne anke Xxanari'iha, benneha unie kini iria ttu profeta lagwi gele attiba neti. Ge benneha udo nagale.” ");
INSERT INTO zae_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","La Moisés‑nigaba nuha udúna len ka benne ukake xuttori'iha tti bitupake kwe'e i'iya Sinaí‑ni lo yu bisiha, delába tti unne len anjeli ge Tata Do Yebáha na iki i'iyaha nna begwebie na ka tisa ka nu dika uinke kini aka benri'i ttu dia lii. Lana nna bettena ka tisaha lenri'i. ");
INSERT INTO zae_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Ttaka ka xuttori'iha labí uka leke udoke tisa ge Moisés‑ni, sinuki ulu'ula ni'ake na nna ukala leke eyekike Egiptoha. ");
INSERT INTO zae_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nianna tti ráke Aarón‑ni: “Beni ka diosi geri'i kini enerukana lori'i eya'ari'i, kumu Moisés nu bebeana ri'i Egiptoha, labí yuri'i bí gwatena.” ");
INSERT INTO zae_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nianna ben ttebakana ttu gwirri ge oru nna bettikana ka nimala kini betekana úna ge gwirriha. Ttu laní xxeniba benkana de elha gwedeaka lasi ge gwirri nu ben labakanaha. ");
INSERT INTO zae_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","De nuha nna bedhába iki Tata Do Yebáha kana lhe begwelhabe kana benkana le'a ge ka beli sia gwetsá. Benbakana attiba ra lo ka yetsi bodha'ana ka profetaha. Lo ka yetsiha bodha'an ka benneha ka tisa unne Tata Do Yebáha, tti ree: Lebi'i benne Israel, delo chua (40) ida tti ugwekile lo yu bisiha, la'ania labí bettile ka nimala kini utele úna kia. ");
INSERT INTO zae_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Betse'e loona, yo'o lari ge diosi nu tee láni Moloc, nuha‑la dechele, anágaba lhe dechegabale beli ge diosi nu tee láni Refán. Ka diosi decheleha kwinaba lebi'i benle kana kini bedú xibile arlokani. Laxkala de nuha nna neti kweabaa le ata se'ele‑na nna nu reha udelhaa le, adírula idittu udelhaa le attichula ata re Babilonia‑ni. ");
INSERT INTO zae_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Ka benne uka xuttori'iha tti ugwekike lo yu bisiha gwa udoba yotu nu ukana ge lariha lenke. Nuha benna liina deki gwa udoba Tata Do Yebáha lenke la'ania. Yotu nu ukana ge lariha, ukabana atti tteba ra Tata Do Yebáha Moisés‑ni tti rabie na deki teeki uinna nuha atti tteba anka nu chi bilennaha. ");
INSERT INTO zae_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","La yotu lariha‑gaba nuha deche ka benne uka xuttori'iha tti deyyake len Josué‑ni nna beta'ake lo yu ge ka nu abittu ankakana nu Israel. Ka nuha‑gaba nuha bebea Tata Do Yebáha arlo ka benne ukake xuttori'iha. Yotu lariha debá atti udo David‑ni gwa udoruna. ");
INSERT INTO zae_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Kumu David‑ni de ukana benne uyu'u le Tata Do Yebáha, de nuha nna unnabana lenie kini ugwelhe na udona ttu lisie ata dika uin ka benne datiake Jacob‑ni le'a gebie, ttaka labí benna yotuha. ");
INSERT INTO zae_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Salomón‑niliba bedona lisieha. ");
INSERT INTO zae_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Meskigaba udo yotuha, ttaka Tata Do Yebaa benne ra xxeni leeha, labí dika dho benneha lhe'e yo'o nu runi ka benne len ni'a náke, ttiba ra profeta geeha: ");
INSERT INTO zae_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Yebáha ankana ata doa rinnabiaya, ra Tata Xisiha, yiesi lo yu‑ni nna ankana ata rudú ni'aya. Nianna, ¿gasina nuha nna rálale deki udole ttu yo'o kia? Gwalinnáruga, ¿si gwaka tsa ttu lisia ata dhoa eyaka lasia? ");
INSERT INTO zae_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ki kwinaba neti benia iyá nu se'e yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Ttaka lebi'i nna labí rieninle ―ra Esteban‑ni―. Yietiba ruinle abittuba ria lele. Lebi'i ruinbale attiba ben ka xuttoleha, rese'e disalale lo Espíritu ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ttiba ben ka xuttoleha, iyába ka benne uka profetaha gwanalhakana ke berio lákana ke lhe bettibakana ka profeta ka benne utixxi'ake deki isia ttu benne unie attiba ankaba geni. Nnanna nna benne utixxi'ake geeha, chiba bita benneha yiesi lo yu‑ni, lebi'i nna betelalee lasi ná ka nu bedaxxukaneha lhe benlale kini bettikane lhe. ");
INSERT INTO zae_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Lebi'igaba nuha uxíle bia bennabi ge Tata Do Yebáha nu bete ka anjeli geeha len lebi'i, ttaka nna abígaba rudole tisa geni. ");
INSERT INTO zae_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tti biyienkin nu ruin elhuxtisiha iyá nu ra Esteban‑ni, nianna bisa'a xxattakinna, roniba lo layakani. ");
INSERT INTO zae_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ttaka Esteban‑ni yu'u galába Espíritu ge Tata Do Yebáha itúba latini. Nianna tti belhidha loni belannina yebáha nna bilenna xiani ge Tata Do Yebáha lhe bilágabinna Jesús‑ni due daka ná ben ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nianna tti unnena, rana: ―¡Gwalugíaruga! Neti riláti du yali yebáha lhe rilágabati Jesús‑ni, due daka ná ben ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ttaka lakana nna bettola nagakani, nianna tti uresi'akana idisa nna bebi'i noo iyábakana Esteban‑ni. ");
INSERT INTO zae_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Uleakana Esteban‑ni ro'esiha nna besiakana na íyya, nna ka nu rusiakana ikini deki bixa bennaha, ka nuha uleaniba xokani nna bese'ekana ka xokaniha arlo ttu nu kwiti tee láni Saulo, ");
INSERT INTO zae_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","nianna tti besiakana Esteban‑ni íyya. Laka yu'ukana rusiakana na íyyaha, lana nna duna rinnena, rana: ―¡Tata Jesús to kia, chi dedáya len kwinalu! ¡Bedíttu neti! ");
INSERT INTO zae_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nianna tti bedú xibini nna unnena idisa, rana: ―¡Tata xisi to kia, bittu ku'inlu tulha nu ruin ka nuní! Nuha‑ba rana nna uttina. ");
INSERT INTO zae_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo‑ni nna uyu'uba leni bettikana Esteban‑ni. La sá tti bettikana Esteban‑ni, la'ania udulokana berio lákana ka benne chi ria leke ge Jesús‑ni se'eke lhe'esi Jerusalén‑ni. Ttu elha disa xxeni nuha uka la'ania. Iyábake ugwadhike diake itúba daka Judea‑ni lhe daka Samaria‑ni lhe. A sunruba ka apóstol ge Jesús‑ni beya'an lhe'esi Jerusalén‑ni, labí biriake. ");
INSERT INTO zae_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","La'ania ttu chupa ka benne biyú, ka benne gwa rudo tsitsiruke tisa ge Tata Do Yebáha, ka benneha gwalhidhake Esteban‑ni nna uresi xxattake geni tti gwakatsike naha. ");
INSERT INTO zae_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sauloha nna danalhabana ruinna utse'e loona ka benne chi ria leke ge Jesús‑ni. Kua suba ra'ana lhe'e ka yo'o, kini rache na'ayana ka benne nuila lhe ka benne biyú lhe, nianna tti radheana ke lisiyya. ");
INSERT INTO zae_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ttaka ka benne biriake lhe'esi Jerusalén‑ni, delába ka benne ugwadhiha, ka benneha ataba diake rigixxi'ake ka tisa ge Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe‑ni nna diana bisinna lhe'e ttu ka yiesi xeni ge Samaria‑ni. Niha udulona rigixxi'enna ka benne se'e niha ge Cristuha. ");
INSERT INTO zae_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ka benneha nna, tti riyienkanie nu ra Felipe‑ni lhe tti rilákanie ka milagru ka nu rebaninri'i geni ruinnaha, nianna iyábake ritupake rudo tsitsiba nagake ge nu rigixxi'anaha. ");
INSERT INTO zae_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ixeba ka benne yu'u espíritu satsa latike, gwa reyakabake nna ka espíritu satsaha nna ribesi'abakana tti reriakana latike. Anágaba nna ixegaba ka benne daa yatti latike lhe ka benne ridá natsa lhe gwa reyakagabake. ");
INSERT INTO zae_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Laxkala ttu elha gwedeaka lasi xxeni nuha uka lhe'esi Samaria‑ni la'ania. ");
INSERT INTO zae_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ttaka lhe'esiha‑gaba do ttu nubiyú tee láni Simón. Ttuha‑li chi ruin nuha ge elha gwesá nna gwa udaabana uxí yiena ka benne ge Samaria‑ni, kini ugía leke geni. Ruinna deki ankana ttu nu ra xxeni leni. ");
INSERT INTO zae_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Gebani rudo naga iyá xeabake, ka benne elha lhe ka binto lhe, nianna ráke: ―Benne‑ni nuní rape nu xxeni ra le Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Rudo tsitsiba nagake geni kumu isába chi ridí yiena ke kini ria leke ge ka elha gwesá ruinnaha. ");
INSERT INTO zae_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ttaka tti biyienkanie rigixxi'a Felipe‑ni gasina akake benne innabia Tata Do Yebáha ke lhe rigixxi'agabana ge Jesucristuha lhe, la'ania nuila lhe nubiyú ka benneha ugía leke geni, nianna tti udike inda. ");
INSERT INTO zae_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Iyágaba Simón‑ni ugía leni ge nu ra Felipe‑ni nna udigabana inda. Iki de tti chi udina indaha nna udulona gwanalhana benneha. Ataba diabie diana nna rugía ya'abana tti rilenna ka milagru lhe adíru ka nu rebaninri'i geni ruin benneha lhe. ");
INSERT INTO zae_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tti bina ka apóstol se'e Jerusalén‑ni deki chi bedaxxu ka benne ge Samaria‑ni tisa ge Tata Do Yebáha, nianna udhelhake Pedruha lhe Juan‑ni lhe kini ugíakana niha. ");
INSERT INTO zae_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tti bisinkana Samaria‑ni nna udulo ttebakana unnabakana len Tata Do Yebáha kini benneha nna utebie Espíritu geeha len ka benne chi ria leke gebie se'e Samaria‑ni, ");
INSERT INTO zae_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","kumu ni ttú ka benneha labí chi bisia Espírituha tsu'e latike. Sunruba lá Jesús benne anke Xxanari'iha, sunruba lá benneha bedettike tti udi ka benneha inda. ");
INSERT INTO zae_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Niala nna tti uxxua ná Pedruha lhe Juan‑ni iki ka benneha kini uxíke Espíritu ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tti bilani Simón‑ni rixxua ná ka apóstoal iki ka benneha, la'ania nuha ridíke Espíritu ge Tata Do Yebáha, nianna tti betesana belhiu len ka benneha, ");
INSERT INTO zae_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","nna rana ke: ―Anágaba neti gwalutegaba nu tsitsi ra lele‑na len neti kini ganna chi ixxua náya iki nuxaba benne, la'ania nna dhígaba benneha Espíritu ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedruha nna bekabina geni, rana na: ―¡Nu reha ugía len belhiu gelu‑na kumu lu rakinlu deki ukare'aba len belhiu nna chiba go'olu elha tse nu rute Tata Do Yebáha! ");
INSERT INTO zae_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Lu labí elha ralhalu uinlu luesi sina ruintu‑ni kumu labí du itá lelu arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","De nuha nna bodúna lu ge nu satsa belaba lelu‑na nna unnaba len Tata Xisiha kini ni kina gaa gwadíbe elha xen lasi gelu de belaba lelu aná, ");
INSERT INTO zae_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","kumu neti rite dati lu yalhá ritisinlu nna labí raka lelu udhanlu nu satsa ruinlu‑na, kumu attisidiba xigabalu lo nuná. ");
INSERT INTO zae_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simón‑ni nna bekabina rana: ―¿Si bi gwa innále gwalinnabachi kia len Tata Xisiha kini abittu satea, ni ttú ka nu chi rale satea‑ni? ");
INSERT INTO zae_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedruha lhe Juan‑ni lhe, iki de chi utixxi'ake lhe bele'eke ka tisa ge Tata Xisiha, nianna tti beyekike deyyake lhe'esi Jerusalén‑ni nna laka deyu'uke neda deyyakeha nna reteke lhe'e ixe ka yiesi to ge Samaria‑ni rigixxi'akanie ka benneha ge Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Iki de nuha nna tti bodole'e lo ttu anjeli ge Tata Xisiha, rabie Felipe‑ni: ―Bedú tse nna ugía daka rreha, daka lo neda nu radi Jerusalén‑ni nna risinna lhe'esi Gaza, delába lo neda nu rite lo yu bisiha. ");
INSERT INTO zae_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe‑ni nna udá ttebana diana. Lo nedaha beti'ana ttu nubiyú ge Etiopía. Nuha ankana ttu nu tee ttu ladi xxeni geni, lana ridona gaxxaba kwe'e Candace, delába nuila nu rinnabiana ka nu Etiopía‑ni. Nubiyúha ankana nu denna belhiu ge yiesiha. Nuha dedána ugíana Jerusalén‑ni gwadú xibini arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Deyu'ubana neda dedona lo carreta geniha nna rulabana lo ka yetsi ben Isaías benne uke profeta ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nianna tti ra Espíritu ge Tata Do Yebáha Felipe‑ni: ―Ugía nna ubiga kwe'e carreta deyya naa. ");
INSERT INTO zae_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tti chi bisin Felipe‑ni gaxxa kwe'e carretaha, nianna biyieninna rulaba nubiyúha lo ka yetsi ben profeta Isaías‑ni. Nianna tti rana nubiyúha: ―¿Si gwa rite denlu nu rulabalu‑na? ");
INSERT INTO zae_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nubiyúha nna bekabina, rana: ―¿Bi rite dati nuní kumu lanú tee kixxi'enna neti bixa nuní ra lo yetsi‑ni? Aníoka nna unnaba nubiyúha len Felipe‑ni kini tsapina lo carretaha nna dhona gaxxa kwe'eni. ");
INSERT INTO zae_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Lo ka yetsi ge Tata Do Yebáha ata rulaba nubiyúha, niha dia ra: Ttiba ttu neru, aníha‑ba chekana benneha die ata gattieha lhe ttiba ttu neru re'eni to, siiba ridúna arlo ka nu richúkana xoniha, aníha‑ba ben benneha, niruba ttu tisa a unnebie. ");
INSERT INTO zae_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tti lo ruyúe elha disaha, nurula bedíne; bettibakane yiesi lo yu‑ni. De nuha nna lanú nu aka geni kixxi'ana ge ka benne datiake benneha. ");
INSERT INTO zae_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nubiyú Etiopía‑ni nna unnaba tisana Felipe‑ni, rana na: ―Utixxi'entu neti, ¿nú ge nuní rinne profetaha tti rana aní? ¿Si la gebani nuní rigixxi'ana ak? ¿Ge attu benne subiba nuní rigixxi'ana ak? ");
INSERT INTO zae_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Felipe‑ni nna udulona lo yetsi ata rulaba nubiyúha nna udulona rigixxi'enna na ge Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Laka deyu'ukana neda deyyakanaha, nianna tti betekana ata sia ttu inda nna ra nu Etiopía‑ni Felipe‑ni: ―Ne inda sia naa. ¿Si nuxa usuna ganna neti gadia inda? ");
INSERT INTO zae_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe‑ni nna rana na: ―Ganna si lu itú iki itú lelu ria lelu, gwaka galá. Nubiyúha nna bekabina rana: ―Ila, gwa riaba lasia deki Jesucristuha anke Xi'in Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nianna tti ben nubiyúha mandadu kini bekwedakana carreta geniha, nianna tti diakana ugwadi ixpabakana lhe'e indaha. Niha begadi Felipe‑ni nubiyúha inda. ");
INSERT INTO zae_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tti chi beriakana lhe'e indaha nna Espíritu ge Tata Do Yebáha beyalhi ttebe Felipe‑ni dechebie na attu ata subi. Nurua na bilani nu Etiopía‑ni. Ttaka nu Etiopía‑ni nna itta suba chi du leni deyyana. ");
INSERT INTO zae_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe‑ni nna lhe'esi Azoto‑niliba bedeaka xxena nna lhe'e iyába ka yiesi se'e niha ritena rigixxi'ana ge Jesús‑ni, axtaliba bisinna lhe'esi Cesarea. ");
INSERT INTO zae_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sauloha nna birula rudú siina rudhaka disana ka benne chi ria leke ge Jesús benne anke Xxanari'iha, rana ke deki uttibana ke. De nuha nna ugíana lo bixxudi xeniha ");
INSERT INTO zae_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","gwannabana kini ute nuha yetsi dhenna ki tsiana daka Damasco‑ni kini aníha nna gapana lo neda satta'ana lhe'e ka yo'o ata rudheti ka nu Israel‑ni ka tisa ge Tata Do Yebáha kini sadaxxuna ka benne chi bedaxxuke neda ge Jesús‑ni, nuxaba ankake, si ankake nuila lhe si ankake nubiyú lhe. Udaxxuna ke nna uxxigana ke, nianna echena ke lhe'esi Jerusalén‑ni. ");
INSERT INTO zae_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ttaka tti chi diana isinna lhe'esi Damasco‑ni, ttiruba ttu nnelaba biria ttu xiani dana yebáha uyu'una abi'iba kwe'eni. ");
INSERT INTO zae_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Lana nna ubixxi lo ttebana lo yu, nianna tti biyieninna tsi'i ttu benne rabie na: ―¡Saulo! ¡Saulo! ¿Beaka neti danalhalu rudhaka disalu? ");
INSERT INTO zae_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauloha nna unnaba tisana, rana: ―¿Núle nuná xa tata? Benneha nna bekabie rabie na: ―Netiba nuní Jesús benne danalhalu rudhaka disalu. Tsitsiba anka kini dhaalu edúlu lo nu ruttisinna lu‑na. ");
INSERT INTO zae_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Lana nna itú rixidibana de rasi xxattinna, nianna tti unnena rana: ―Tata Xisi to, ¿bí raka lelu unia? Labie nna ree na: ―Beyadha nna uta'a lhe'e yiesi‑na. Lhe'e yiesi‑na kixxi'akinna lu bixa anka nu uinlu. ");
INSERT INTO zae_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ka nubiyú dia len Sauloha nna paba use'ekana, uka télakinna tti biyienkinna tsi'i benne unneeha, ttaka nna lanúbie bilákinna. ");
INSERT INTO zae_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauloha nna beyadha ttebana lo yu, ttaka tti chi bedhalina ka iyya loniha nna birua uka ilenna. Laxkala itú nalhibakana náni chibuka bisin lenkana na lhe'esi Damasco‑ni. ");
INSERT INTO zae_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Niha‑ba udona tsunna ubisa, labí uka ilenna, lhe labí utona yetta lhe nigaba a u'uyana inda lhe. ");
INSERT INTO zae_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Lhe'esi Damasco‑ni, niha do ttu nubiyú ria leni ge Jesús‑ni. Nuha tee láni Ananías. Nubiyúha bele'enna Jesús benne anke Xxanari'iha. Tti bele'enna benneha nna rabie na: ―¡Ananías! Lana nna bekabina, rana: ―Nii doa xa tata. ");
INSERT INTO zae_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jesús benne anke Xxanari'iha nna rabie Ananías‑ni: ―Udú lii nna ugía ata tee neda nu tee láni Neda Lhixxa. Lhe'e lisi Judas‑ni, niha innaba tisalu ge ttu nubiyú tee láni Saulo. Nuha ankana ge lhe'esi Tarso nna dona rinnena len Tata Do Yebáha lhe'e lisi Judas‑ni. ");
INSERT INTO zae_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nianna chi bele'enna ttu nubiyú tee láni Ananías, nuha uta'ana uxxua náni ikini kini beyali ka iyya loniha. ");
INSERT INTO zae_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananías‑ni nna bekabina gebie rana: ―Tata Xisi to, ixe ka benne chi utixxi'akanie neti ge nu ruin nubiyú ralu‑na. Yalhá nu chi bedhakana ka benne gelu se'e Jerusalén‑ni. ");
INSERT INTO zae_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nnanna nna chi dana nii kumu de chi begwe ka bixxudi xeniha na lo neda kini udaxxuna ka benne chi ria leke gelu. ");
INSERT INTO zae_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ttaka Jesús benne anke Xxanari'iha nna rabie na: ―Ugía, kumu neti chi bekwea nubiyúha kini idhelhaa na tsiana kixxi'ana kia len ka nu dittu lhe len ka nu rinnabia gekani lhe, anágaba kixxi'agabinna ka nu Israel‑ni lhe, ");
INSERT INTO zae_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","kumu neti ule'enia na xxeniba anka elha disa uyúna delo ni'a kia. ");
INSERT INTO zae_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nianna dia tteba Ananías‑ni. Tti bisinnaha nna uta'ana lhe'e yo'o ata do Saulo‑ni. Nianna tti uxxua náni ikini nna rana na: ―Betsi to, Jesús benne anke Xxanari'iha, labe nuha bele'e loe len lu tti yu'ulu neda dalu nii. Lagabe udhelhe neti kini eyali ka iyya lolu‑na lhe kini isia Espíritu ge Tata Do Yebáha tsu'e itúba latilu lhe. ");
INSERT INTO zae_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Looraha tteba nna ttiba ttu nu betúa bea loni nna belá ttebinna. Nianna tti udú liina nna udi ttebana inda. ");
INSERT INTO zae_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Iki de nuha nna utona yetta nna bedú tsitsi ttebana. Sauloha ttu chupa ubisaruba udona len ka benne chi ria leke ge Jesús‑ni se'e lhe'esi Damasco‑ni. ");
INSERT INTO zae_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nianna udulo ttebana riana lhe'e ka yo'o ata rudheti ka nu Israel‑ni ka tisa ge Tata Do Yebáha, niha rigixxi'ana ge Jesús‑ni. Rana kana deki benneha anke Xi'in Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Iyába ka nu riyienkinna nu rigixxi'anaha, rugía ya'abakana rákana: ―¿Laaba nuníba nuha rekina ruinna utse'e loona ka nu chi ria lekani ge Jesús‑ni lhe'esi Jerusalén‑ni lhe dágabana nii kini udaxxuna ka nu se'e nii nna taga'ana kana lo ná ka bixxudi xeniha? ");
INSERT INTO zae_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ttaka Sauloha nna adíla itú iki itú leni rigixxi'ana axtaba ruchixxina iki ka nu Israel se'e lhe'esi Damasco‑ni kumu rigixxi'ana deki Jesús‑ni nuha anke Cristu. ");
INSERT INTO zae_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Isába gwadána, nianna tti unne len luesi ka nu loni ge ka nu Israel‑ni, rákana deki uttikana Sauloha. ");
INSERT INTO zae_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ttaka Sauloha nna ute dábinna nu re lekani udhakakana naha, lhe binana deki rela resába se'ekana ruyú tsitsibakana ro'o yiesiha kini ganna chi eriana niha nna uttikana na. ");
INSERT INTO zae_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ttaka ka benne chi rudhetinna ka tisa ge Jesús‑ni nna begu'uke na lhe'e ttu sumi nna bechidake na lati de'e rilhi abi'iba kwe'e yiesiha ttu lo rela. Aníoka nna ulána, abittu bettikana na. ");
INSERT INTO zae_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tti besin Sauloha lhe'esi Jerusalén‑ni, nianna benna tatsána ka benne chi ria leke ge Jesús‑ni se'e niha. Ttaka iyába ka benneha rasibakanie na kumu labí ria leke deki lana chigaba ria leni ge Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nianna tti che Bernabé‑ni na gwatso duna na arlo ka apóstol ge Jesús‑ni nna utixxi'enna ke gasina bilen Sauloha Jesús benne anke Xxanari'iha tti yu'una neda diana lhe'esi Damasco‑ni lhe utixxi'agabin Bernabé‑ni ke gasina unne len Jesús‑ni Sauloha. Anágaba nna utixxi'agabinna ke gasina unne Sauloha itú iki itú leni tti utixxi'ana ge Jesús‑ni lhe'esi Damasco‑ni. ");
INSERT INTO zae_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Lhe'esi Jerusalén‑niba beya'an Sauloha udona ttu satti. Niha ugweki lenna ka apóstoal nna lanú nu besuna, beria beta'abana lhe'esiha, ");
INSERT INTO zae_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","labí usinna rigixxi'ana ge Jesús benne anke Xxanari'iha lhe anágaba nna ridakagaba lenna ka nu Israel‑ni, ka nu rinnekana tisa griegu. Ttaka ka nuha nna rulha lekani uttikana na. ");
INSERT INTO zae_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tti chi bina adí ka benne chi ria leke ge Jesús‑ni ge nu rulha le ka nuha uinkana, nianna bebeake Sauloha nna decheke na lhe'esi Cesarea. Debá niha nna bedhelhake na lhe'esi Tarso. ");
INSERT INTO zae_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ka benne chi ria leke ge Jesús‑ni se'e itúba daka Judea lhe daka Galilea lhe daka Samaria lhe, ka benneha xen su lasiba se'eke lhe gwa diabake rise'e tsitsiruke lo neda ge Tata Do Yebáha lhe rudo tsitsibake tisa gebie lhe, anágaba Espíritu geeha gwa rakagaba lanie ke kini raniruke. ");
INSERT INTO zae_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Tti reki Pedruha itúba ka daka niha, la'ania ugíagabana gwalannina ka benne chi ankake ge Tata Xisiha se'e lhe'esi Lida. ");
INSERT INTO zae_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Niha gwaxxakana ttu benne tee lábie Eneas. Benneha chi uka ttu xxunu ida yu'e lo ta'a daa yatti latie. ");
INSERT INTO zae_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedruha nna rana benneha: ―¡Eneas, beyadha! Jesucristuha chiba beyonie lu. ¡Beyadha nna bodapa ta'a gelu‑na! Eneas‑ni nna beyadha ttebe. ");
INSERT INTO zae_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nianna iyába ka nu se'e lhe'esi Lida lhe ka nu se'e daka Sarón, tti bilákinna chiba beyaka benneha, la'ania nna bedaxxukana neda ge Jesús benne anke Xxanari'iha. ");
INSERT INTO zae_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Lhe'esi Jope do ttu benne nuila ria lebie ge Jesús‑ni. Benneha tee lábie Tabita. Len tisa griegu nna tee lábie Dorcas. Benne nuilaha yalhá rudo lebie runie iyába nu anka tse lhe rute nábie len ka benne abittu geke tee lhe. ");
INSERT INTO zae_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","La'ania uni Tabita‑ni nna uttibe. Iki de chi bogadikaneha nna tti belhapikane lhe'e attu yo'o do gwetsá. ");
INSERT INTO zae_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kumu de gaxxa galá re lhe'esi Jope len Lida, de nuha nna ka benne chi ria leke ge Jesús‑ni, tti binake deki lhe'esi Lida‑niba re Pedruha, nianna udhelhake chupa ka benne biyú kini ugíake gwannabake lenna, ráke na: ―Bediuba lelu utá lhe'esi Jope‑ni. ");
INSERT INTO zae_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedruha nna dia tteba lenna ka benneha. Tti chi bisinna lhe'esiha nna ulhapi ttebake na lhe'e yo'o do gwetsá ata tee benne yattiha. Nianna bitupa tteba ka benne nuila bidabiha abi'iba kwe'e Pedruha, ribesike nna rula'akanie na ka xalho lhe ka tulhá utiyya Tabita‑ni tti sa doe anka banieha. ");
INSERT INTO zae_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedruha nna bebea ttebana iyába ka benne se'e lhe'e yo'o ata tee benne yattiha, nianna tti bedú xibini nna unnabana len Tata Do Yebáha nna tti bodetta loni ata tee benne yattiha nna rane: ―¡Tabita, beyadha! Benne nuilaha nna begiti tteba lobie. Tti bilánie Pedruha nna beyadha ttebe bedoe. ");
INSERT INTO zae_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedruha nna bodaxxu ttebana nábie nna bodhú liine. Nianna tti beyaxina ka benne nuila bidabiha lhe adíru ka benne chi ankake ge Jesús‑ni lhe, nianna tti bodúna Tabita‑ni arloke. ");
INSERT INTO zae_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ka nu se'e lhe'esi Jope‑ni tti chi binakana nu chi ukaha, la'ania nna ixebakana ugía lekani ge Jesús benne anke Xxanari'iha. ");
INSERT INTO zae_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedruha nna isáruba udona lhe'esi Jope‑ni, udona lhe'e lisi ttu benne rukusie ka yieti, tee lábie Simón. ");
INSERT INTO zae_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Udo ttu nubiyú lhe'esi Cesarea tee láni Cornelio. Nuha ankana nu baninna ttu gayua (100) ka soldadu ka nu tee lákani Italiano. ");
INSERT INTO zae_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nubiyúha lhe iyába ka benne se'e lhe'e lisiniha ankake ka benne rudoruna leke ria leke Tata Do Yebáha lhe rudo tsitsibake tisa gebie lhe. Anágaba Cornelio‑ni yalhá redá leni rutena nu teeba geni len ka benne Israel‑ni, ka benne abittu geke tee lhe anágaba satíaba rilhapina tisa len Tata Do Yebáha lhe. ");
INSERT INTO zae_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ttu sá do Cornelio‑ni ttiba ttu retin tsunna, nianna tti bele'enna ttu anjeli ge Tata Do Yebáha, bilá saabinna benneha ute'e lhe'e yo'o ata donaha, nianna tti rabie na: ―¡Cornelio! ");
INSERT INTO zae_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio‑ni nna rulanni tsittabana lo anjeliha nna itú rasibinna, rana benneha: ―¿Bí raka lelu xa tata? Anjeliha nna rabie na: ―Tata Do Yebáha chiba biyieninie ge ka tisa rilhapilu lenbie lhe anágaba nna gwa rapabe kwenta ge nu tse ruinlu de redá lelu rutelu nu teeba gelu len ka benne abittu geke tee. ");
INSERT INTO zae_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nnanna nna udhelha ttu chupa ka nubiyú kini tsiakana lhe'esi Jope taxxíkana Simón nu tegaba láni Pedro. ");
INSERT INTO zae_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Lana dona lhe'e lisi benne tegaba lábie Simón, delába benne rukusie ka yieti. Benneha doe gaxxaba ro'o indatooha. Labie innábie bixa anka nu uinlu. ");
INSERT INTO zae_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Iki de chi deyya anjeli unne len Cornelio‑ni, lana nna uxi ttebana chupa ka nu riben sina geniha lhe attu soldadu nu satíaba rixuinna lhe'e lisiniha, nu gwa rudo tsitsiruna tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Uxina ka nuha nna iki de chi utixxi'enna ka nuha iyá nu gwatenaha, nianna tti udhelhana ka nuha diakana lhe'esi Jope. ");
INSERT INTO zae_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Beyeki sáha laka yu'u ka nu udhelha Cornelio‑ni neda diakana nna chiba isinkana lhe'esi Jope‑ni. Pedruha nna ttiba tu retin tsi'inu (12) ugwapina gwetsá iki yo'o ata donaha, kini rilhapina tisa len Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nianna tti bituinna nna raka leni gona, ttaka laka raka elho gonaha, lana nna bele'enna ");
INSERT INTO zae_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","biyali yebáha, nianna ugwadi ttiba ttu lari xeni xiga itapaba ka ro'oni, dana radina lo yu. ");
INSERT INTO zae_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Lhe'e lariha yu'u iyá looba ka nimala: yu'u ka nu ra'aya lhe'ekani lo yu lhe ka nu ridá len ni'a nákani lhe ka nu sia xxilakani lhe. ");
INSERT INTO zae_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nianna tti biyieninna tsi'i ttu benne unnebie, rabie na: ―Pedro, udú lii, betti ka nuná nna uto kana. ");
INSERT INTO zae_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ttaka Pedruha nna bekabina, rana: ―Labí xa tata. Neti ni tsa labí chi uto neti nu abittu ga'anna gotu lhe nigaba labí chi utoa ttu bixa nu anka tsiga arlo Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Benne rinneha nna bedennebie attu libe, rabie na: ―Nu chi bochari Tata Do Yebáha bittu kixxalu lá nuha nu tsiga. ");
INSERT INTO zae_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tsunna libeba unne benneha, nianna tti beyapi lariha, deyyana yebáha. ");
INSERT INTO zae_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedruha nna si dolana rulaba leni ge bí diani nu bele'ennaha, nianna tti chi bisin ka nubiyú udhelha Cornelio‑ni ro'o lisi Simón benne rukusie ka yietiha, kumu chiba gwaxxakana ata do yo'o ge benneha. ");
INSERT INTO zae_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nianna tti unnaba tisakana, rákana: “¿Si níunni do Simón, benne tegaba lábie Pedro?” ");
INSERT INTO zae_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedruha nna sa dolana rulaba leni ge nu bele'ennaha, nianna tti ra Espíritu ge Tata Do Yebáha na: ―Ne tsunna ka nubiyú se'e ro'o yo'o‑ni regilakana lu. ");
INSERT INTO zae_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Bedú lii nna beyadi ugía lenkana. Abittu udúna lu kumu netiba udhelhaa ka nuní. ");
INSERT INTO zae_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedruha nna beyadi ttebana ata se'e ka nubiyúha nna rana kana: ―Neti nuní benne regilale. ¿Bí ge dale nii? ");
INSERT INTO zae_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ka nuha nna bekabikana geni rákana na: ―Ri'itu datu kumu Cornelio benne bananie ttu gayua (100) ka soldaduha, benneha udhelhe ri'itu. Labie anke ttu benne runi attiba ankaba geni lhe rudo tsitsibe tisa ge Tata Do Yebáha lhe. Iyába ka benne Israel‑ni ráke deki tseba runie, nna ttu anjeli ge Tata Do Yebáha ree bie deki gaxie kwinalu lhe'e lisieha, kini udo nage ge nu kixxi'enlue. ");
INSERT INTO zae_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Niala nna tti bega'a Pedruha ka nuha lhe'e yo'o ata donaha. Niha‑ba beya'ankana loolhaha. Attu dilaha‑liba nna dia lenna ka nuha. Diagaba lenna attu chupa ka betsi to geri'i se'e lhe'esi Jope‑ni. ");
INSERT INTO zae_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Beyeki sáha nna bisinkana lhe'esi Cesarea. Niha‑ba chi du Cornelio‑ni ribedana kana itupa lenna ka nu chi uxinaha, delába ka benne raka luesiniha lhe ka benne se'e tse lennaha lhe. ");
INSERT INTO zae_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tti chi bisin Pedruha ro'o yo'o ge Cornelio‑ni, lana nna biria ttebana gwatsána Pedruha nna bedú tteba xibini arloni kini utsá loni na. ");
INSERT INTO zae_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ttaka Pedruha bodhú lii ttebana Cornelio‑ni, nianna tti rana na: ―¡Bedú lii! Yuu neti lanú nu ankaa, kumu ttigabalu ankalu benne, anágaba neti bennegaba ankaa. ");
INSERT INTO zae_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Laka rinne lenna Cornelio‑ni nna uta'ana lhe'e yo'oha, niha bilenna ixeru ka benne chi tupake. ");
INSERT INTO zae_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nianna tti rana ka benneha: ―Lebi'i gwa yu xeabale, bia bennabi getu‑ni labí rugwelhana ri'itu, ka benne Israel, utsátu ka benne abittu ankake benne Israel, nigaba ga'atu lhe'e lisike lhe. Ttaka Tata Do Yebáha chi bela'anie neti deki labí dika upeya ttu benne: “Lu tsigaba ankalu arlo Tata Do Yebáha o satsaba ankalu lhe.” ");
INSERT INTO zae_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Laxkala tti bisia ka benne‑ni nna ráke neti: “Dhalu len ri'itu”, neti nna labí bedúa tisa nna daa tteba lania ke. Nnanna nna raka lasia kixxi'ale, ¿bí lo ni'a ge nna uxile neti? ");
INSERT INTO zae_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio‑ni nna bekabina ge Pedruha, rana na: ―Chi ute ttapa ubisa, ttiba ura‑ni rea lhe'e yo'o kia‑ni rutte ubina lhe'a, ttiba tu retin tsunna doa rilhapia tisa len Tata Do Yebáha. Nianna ttiruba chi uka xxe ttu benne biyú udúe arloa nukue ttu xo raka ragalhaba loni, ");
INSERT INTO zae_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","nianna tti rabie neti: “Cornelio, Tata Do Yebáha chiba biyieninie ge ka tisa rinnelu lenbie lhe chigaba upe kwenta ge nu tse ruinlu de rutelu nu tee gelu len ka benne abittu geke tee. ");
INSERT INTO zae_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nnanna nna udhelha ttu chupa ka benne kini tsiake lhe'esi Jope‑ni taxxíke Simón nu tegaba láni Pedro. Nuha dona lhe'e yo'o ge ttu benne tegaba labie Simón benne rukusie ka yieti. Benneha dobie gaxxaba ro'o indatooha. Tti isia Pedruha nna kixxi'enna lu bixa anka nu uinlu.” ");
INSERT INTO zae_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aníha uka nna udhelha ttebaa ka benne‑ni kini betetilake kwinalu. Lu nna tseba benlu dalu. Nnanna nna niiba chi se'e iyábatu arlo Tata Do Yebáha, kini udo nagatu ge iyá nu chi rabie lu kixxi'enlu ri'itu. ");
INSERT INTO zae_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nianna tti unne Pedruha, rana: ―Nnannaligaba lhixxa rába chi rite dati deki Tata Do Yebáha ttúba rulanni benneha ri'i, labí rugwerue lidhaka ttu benne tti attu benne, ");
INSERT INTO zae_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","sinuki gwa rulabibe ka benne rudoke tisa gebie lhe ruinke nu dika ixú lhe, meskiba se'eke lhe'e gaxaba yiesi. ");
INSERT INTO zae_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tata Do Yebáha unnebie len ri'itu ka benne Israel, utixxi'anie ri'itu ka tisa tse, delába ka tisa rigixxi'akana gasina ese'e tse ka benne lenie de tsia leke Jesucristuha. Jesucristuha nuha anke Xxana iyá tteri'i. ");
INSERT INTO zae_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Lebi'i gwa yúbale nu uka itúba Judea‑ni, udulona daka Galilea‑ni iki de tti chi ugweki Juan‑ni rana ka benne deki raka doelha gadike inda ");
INSERT INTO zae_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","lhe anágaba gwa yúbale gasina bete Tata Do Yebáha Espíritu geeha len Jesús ge Nazaret‑ni, lhe bengabe kini ra tsitsi le benneha lhe anágaba gwa yúgabale gasina ugweki Jesús‑ni benie nu tse lhe beyonie iyába ka benne rugwe nu xxegwiha ke elha disa. Benie iyá nuní kumu Tata Do Yebáha gwa udúba lenie bie. ");
INSERT INTO zae_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ri'itu biyú lotu iyá nu benie tti ugwekie daka Jerusalén‑ni lhe itúba daka Judea‑ni lhe. Iki de nuha nna tti bettikane betákane lo ttu ya kurusi. ");
INSERT INTO zae_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ttaka Tata Do Yebáha belhidha benbe benneha tti chi uka tsunna ubisaha, nianna benie kini benneha bele'e lobie. ");
INSERT INTO zae_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Labí len iyá ka benne bele'e lo benneha, suna len ri'ituruba ka benne chi bekwe Tata Do Yebáha, suna len ri'ituruba bele'e lobie kini bilentu, delába ri'itu ka nu utotu lhe u'uyatu lenie tti chi beyadhe lagwi ge ka benne chi uttiha. ");
INSERT INTO zae_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nianna tti udhelhe ri'itu kini tsekitu kixxi'entu ka benne lhe innátu deki gwalí labie chi bedú Tata Do Yebáha kini ake xueda unie elhuxtisi ge ka benne anka bani lhe ka benne chi utti lhe. ");
INSERT INTO zae_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ge Jesús‑ni nuha utixxi'a iyába ka benne ukake profetaha, ráke deki iyába ka benne tsia leke gebie, de tsiaba leke gebie nna gwadíba Tata Do Yebáha elha xen lasi ge ka tulha ruinke. ");
INSERT INTO zae_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Sa dula Pedruha rigixxi'ana nuha, ttiruba chi bisia Espíritu ge Tata Do Yebáha uyu'e lati iyába ka benne se'e gwedo nagaha. ");
INSERT INTO zae_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ka benne Israel‑ni, ka benne chi ria leke ge Jesús‑ni, delába ka benne daa lenke Pedruha, rugía ya'abake tti bilákanie deki gwa rutegaba Tata Do Yebáha Espíritu geeha len ka benne abittu ankake nu Israel, ");
INSERT INTO zae_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","kumu de riyienkanie rinne ka benne tupa niha ka tisa subi lhe ráke: “¡Xxeniba ra le Tata Do Yebáha!” ");
INSERT INTO zae_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Nianna tti ra Pedruha ka benne daa lennaha: ―¿Katte ra nuxa ttúri'i usunari'i a gadi ka benne‑ni inda, kumu ka benne‑ni chigaba uxíke Espíritu ge Tata Do Yebáha ttiba ri'i? ");
INSERT INTO zae_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nianna tti ben Pedruha mandadu kini ugadikana ka benneha inda nna udettikana lá Jesús benne anke Xxanari'iha tti gadike indaha. Iki de nuha nna tti unnaba ka benneha len Pedruha kini eya'anruna lenke attu chupa ubisa. ");
INSERT INTO zae_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ka apóstol ge Jesús‑ni lhe adíru ka betsi to geri'i se'e daka Judea‑ni, binake deki ka benne abittu ankake benne Israel chigaba bedaxxu ka benneha tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ttaka tti beyapi Pedruha besinna lhe'esi Jerusalén‑ni nna ka nu Israel, ka nu chi ria lekani ge Jesús‑ni se'e lhe'esiha, yalhá uxaka lenkana na, ");
INSERT INTO zae_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","rákana na: ―¿Beaka gwatta'alu lhe'e lisi ka nu abittu ankakana nu Israel lhe beaka utolu yetta lenkana lhe? ");
INSERT INTO zae_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedruha nna kua suba udulona utixxi'enna kana tti tteba ukaha, nianna tti rana kana: ");
INSERT INTO zae_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Doba neti lhe'esi Jope‑ni rilhapia tisa len Tata Do Yebáha nna ttiruba bela'ati ttiba ttu lari xeni xiga itapaba ka ro'oni dana gwetsáha. Lhixxaraba dana ata doaha. ");
INSERT INTO zae_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Begía tsitsibaa bixa nuha yu'u lhe'e lariha. Lhe'e lariha biláti iyá looba ka nimala to: yu'u ka nu ridá len ni'a nákani lhe ka nimala ixxi lhe yu'u ka nu ra'aya lhe'ekani lo yu lhe anágaba yu'ugaba ka nu sia xxilakani lhe. ");
INSERT INTO zae_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nianna tti biyienti tsi'i ttu benne rabie neti: “Pedro, udú lii, betti ka nuná nna uto kana.” ");
INSERT INTO zae_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Neti nna bekabia xpeye: “Labí xa tata, kumu neti ni tsa labí chi uto neti ttu nu abittu ga'anna goa lhe nigaba ttu nu anka tsiga arlo Tata Do Yebáha lhe.” ");
INSERT INTO zae_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nianna tti bedeyienti tsi'i benneha yebáha, bedennebie attu libe redenee: “Nu chi bochari Tata Do Yebáha abittu kixxalu lá nuha nu anka tsiga.” ");
INSERT INTO zae_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tsunna libeba unnebie, nianna tti beyapi adakaba lariha deyyana yebáha. ");
INSERT INTO zae_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Si beyaka tte uka nuha, nianna ttiruba chi uka xxe tsunna ka nubiyú udhelha ttu benne ge Cesarea‑ni, dákana regilakana neti nna bisiakana ro'o yo'o ata doaha. ");
INSERT INTO zae_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nianna tti ra Espíritu ge Tata Do Yebáha neti: “Bittu udú chupana lelu, ugía len ka benne‑na.” Udágaba a xxupa (6) ka betsi to geri'i se'e‑ni len neti. Laxkala iyábatu uta'atu lhe'e yo'o ge nubiyú uxina netiha. ");
INSERT INTO zae_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nubiyúha nna utixxi'enna ri'itu gasina bilenna anjeli ge Tata Do Yebáha uka xxebie lhe'e lisiniha nna rabie na: “Udhelha ka nu tsiakana lhe'esi Jope‑ni saxxíkana Simón nu tegaba láni Pedro. ");
INSERT INTO zae_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nuha kixxi'enna lu gaxasina uinlu kini odilá Tata Do Yebáha lu itupa lenlu iyá ka benne se'e lhe'e lisilu‑ni.” ");
INSERT INTO zae_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Neti nna tti uduloa unnea lenkanaha, bisia tteba Espíritu ge Tata Do Yebáha uyu'e latikani attigaba bisie uyu'e latiri'i sisi'a tteha. ");
INSERT INTO zae_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","La'ania nna gwadú lasia nu unne Jesús benne anke Xxanari'iha, tti rabie: “Gwalí galá Juan‑ni sunruba len inda begadie ka benne, ttaka lebi'i nna ugadi Tata Do Yebáha le Espíritu geeha.” ");
INSERT INTO zae_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kumu ki Tata Do Yebáha chi begwebie ka benneha Espíritu geeha attigaba betebie benneha lenri'i, ri'i ka benne chi ria leri'i ge Jesucristu benne anke Xxanari'iha, de nuha nna neti nna, ¿núla ankaa nna gattaa lo neda ge Tata Do Yebáha kini abittu unie nu raka lebie aka? ");
INSERT INTO zae_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tti chi biyienkin benne Israel‑ni nu ra Pedruha, nianna siiba beyakake nna tti ráke: ―¡Xxeniba ra le Tata Do Yebáha! ¡Ganna aníha nna iyágaba ka benne abittu ankake nu Israel chi benie kini gapake lo neda odúna ke nna odaxxuke neda gebie kini aka benke ttu dia lii! ");
INSERT INTO zae_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ka benne ugwadhike tti berio lákana keha, delába tti bettikana Esteban‑ni, ka benneha bisinke daka Fenicia lhe daka Chipre lhe daka Antioquía lhe. Lanú nu utixxi'akanie ge Jesús‑ni, sunruba ka nu Israel, ka nu se'e ka daka niha, sunruba ka nuha utixxi'akanie. ");
INSERT INTO zae_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ttaka sela lenke ttu chupa ka benne biyú ge Chipre lhe ge Cirene lhe. Ka benneha‑la nuha tti uta'ake lhe'esi Antioquía‑ni nna utixxi'agabakanie ka nu abittu ankakana nu Israel ka tisa ge Jesús benne anke Xxanari'iha. ");
INSERT INTO zae_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tata Xisiha nna gwa ukaba lenie ke, laxkala ixeba ka benne bedaxxuke neda ge Jesús‑ni de ugía leke ge nu rigixxi'a ka benneha. ");
INSERT INTO zae_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ka benne chi ria leke ge Jesús‑ni se'e lhe'esi Jerusalén‑ni, tti binake ge nu raka Antioquía‑ni, nianna tti udhelhake Bernabé‑ni kini ugíana niha. ");
INSERT INTO zae_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bernabé‑ni nna atti bisinna niha nna ute denna deki tseba ruin Tata Do Yebáha len ka benneha, nianna bedeakinna nna belisana ke kini bodú ittana le iyábake, rana: ―Ttu tsa gwalebeki lele tse'ele udole tisa ge Jesús benne anke Xxanari'iha. ");
INSERT INTO zae_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Kumu Bernabé‑ni ankana ttu benne re tse leni lhe ria tsitsi leni ge Jesús‑ni lhe anágaba yu'u Espíritu ge Tata Do Yebáha itúba latini lhe. De nuha nna ixe juisiru ka benne ugía leke ge Jesús benne anke Xxanari'iha. ");
INSERT INTO zae_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Iki de nuha nna tti ugía Bernabé‑ni lhe'esi Tarso‑ni gwatilana Sauloha. ");
INSERT INTO zae_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tti gwaxxakana Sauloha nna dechena na besin lenna na lhe'esi Antioquía‑ni. Niha‑ba biselakana ka benne chi ria leke ge Jesús‑ni itúba ttu idaha nna ixeba ka benne lhe'esiha bele'ekinna. Lhe'esi Antioquía‑ni, niha nuha sisi'a tte utta lá ka benne chi ria leke ge Jesús‑ni Ka Benne Ge Cristu. ");
INSERT INTO zae_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","La'aniagaba udá ttu chupa ka profeta lhe'esi Jerusalén‑ni nna bisinke lhe'esi Antioquía‑ni. ");
INSERT INTO zae_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ttu ka benneha, benne tee lábie Agabo, benneha udú liie nna unnebie ka tisa ka nu bete Espíritu ge Tata Do Yebáha lenbie nna rabie, isia ttu ubina tsitsi yiesi lo yu‑ni. Ubina nu ra benneha bisiana atti anka Claudio‑ni nu rinnabia xeni ge Roma‑ni. ");
INSERT INTO zae_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","La'ania ka benne chi ria leke ge Jesús‑ni se'e lhe'esi Antioquía‑ni, kua ttu ttuke lhe kua teeba geke bokinni ikike kini ute náke len ka betsi to geri'i se'e daka Judea‑ni. ");
INSERT INTO zae_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Aníha benke nna udhelhake belhiu bitupaha len Bernabé‑ni lhe len Saulo‑ni lhe kini gwadha'ankana nuha len ka benneola rise'e arlo ka benne chi ria leke ge Jesús‑ni. ");
INSERT INTO zae_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","La'aniagaba nuha ben Herodes nu rinnabiaha mandadu kini bedaxxukana ttu chupa ka benne chi ria leke ge Jesús‑ni kini gayakana ke, ");
INSERT INTO zae_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","nna benna mandadu kini bettikana Jacobo betsi Juan‑ni, len espada. ");
INSERT INTO zae_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Tti bilani Herodes‑ni deki gwa uyu'uba le ka nu Israel‑ni nu bennaha, nianna bedaxxugabana Pedruha bedheana na lisiyya. Nuní uka tti bisia laní nu tee láni Pascua, delába tti ro ka benne Israel‑ni yettaxtila nu abittu kua dii dia ikini. ");
INSERT INTO zae_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Tti bedaxxukana Pedruha nna bedheakana na lisiyya, nianna bodha'ankana na lasi ná ttapa kwe ka soldadu kini ka nuha nna uyú tsitsikana na. Ttapa ttapa ka soldaduha se'e lhe'e ttu ttu kweha. Aníha ben Herodes‑ni kumu rakinna ebeana Pedruha lo benne ganna chi ute laníha. ");
INSERT INTO zae_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Laxkala ruyú tsitsibakana Pedruha lhe'e lisiyyaha kini abittu eriana, ttaka ka benne chi ria leke ge Jesús‑ni labí rudú siike rinnabake geni len Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Loolha atti chi tsani dila ebea Herodes‑ni Pedruha lhe'e lisiyyaha, loolha tebana te'adhina lagwi ge chupa ka soldaduha xigana chupa ka cadena. Adí ka soldaduha nna se'ebakana gweyú ro'o lisiyyaha. ");
INSERT INTO zae_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ttiruba chi uka xxe ttu anjeli ge Tata Xisiha lhe'e lisiyyaha nna uyu'u chába xiani lhe'e nuha. Anjeliha nna begalhe kwitta Pedruha bodibenie na nna ree na: ―¡Jeru tte beyadha! Nianna beyasi tteba ka nániha ka cadena xikanaha. ");
INSERT INTO zae_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Anjeliha nna ree na: ―¡Bedhí lhe'elu lhe bolea ka gwaracha gelu‑na lhe! Pedruha nna rana: ―¡O! Nianna tti redea anjeliha na: ―Betubi lari gelu‑na nna betá betenalha neti. ");
INSERT INTO zae_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedruha nna danalhabana anjeliha beriana, ttaka labí yu tsena si gwalíttiga rebea anjeliha na lhe'e lisiyyaha, kumu rakinna ganna rula'abinna nuha. ");
INSERT INTO zae_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Betebake lo soldadu nu du gweyú ro'o lisiyyaha lhe betegabake lo nu berupaha lhe. Nianna tti besinke ata du puerta iyya nu du ro'o nedaha nna titúba nuha biyalina. Iki de tti chi beriakeha nna deyyake belháke lo ttu neda tee niha. Niha‑liba nna tti chi bekwitta anjeliha len Pedruha. ");
INSERT INTO zae_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","La'anialiba nna tti bete da tsenna nna rana: ―Nnannaligaba chi rite da tseti deki gwalíba udhelha Tata Xisiha anjeli geeha kini betedilábie neti lo ná Herodes‑ni lhe bodilágabe neti lo iyába nu ribeda ka nu Israel‑ni udhakana neti. ");
INSERT INTO zae_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tti ute den Pedruha nu gwatenaha, nianna tti deyyana besinna lisi María nan ge Juan nu tegaba láni Marcos. Niha se'e ixeru ka benne rilhapike tisa len Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tti unnena ro'o puerta nu du ro'o nedaha, nianna biria ttu nuila riben sina lhe'e yo'o ge María‑ni, kini ugía nuha gwado nagani nuxa nuha rinnee ro'o yo'oha. Nuilaha tee láni Rode. ");
INSERT INTO zae_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tti beyakabienna tsi'i Pedruha nna, de elha gwedeaka lasi nna labí udhali ttena puertaha. Lade'axala beyekina nna gwexunniba gwattixxi'ana deki Pedruha‑ba nuha rinne ro'o yo'oha. ");
INSERT INTO zae_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ttaka ka benneha nna ráke na: ―¡Rakaba ikilu! Ttaka nuilaha nna ttu duba nuha, rana: ―¡Ki ria, Pedruha‑ba nuná! Ka benneha nna ráke: ―Gaxa anjeli geniha‑ba benne‑na. ");
INSERT INTO zae_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ttaka Pedruha nna ttu dúbana rinnena ro'o yo'oha. Tti udhalikeha nna bilákanie na nna rugía ya'abake. ");
INSERT INTO zae_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Lana nna bettá ttebin náni ke kini eyaka siike, nianna tti utixxi'enna ke gasina uka bebea Tata Xisiha na lhe'e lisiyyaha. Iki de nuha nna tti rana ke: ―Gwalikixxi'en Jacobuha lhe adíru ka betsi to geri'iha lhe ge nu gwatea‑ni. Nianna tti biriana diana attu ta subi. ");
INSERT INTO zae_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Tti chi ugwani dilaha nna bisatsa tteruba ka soldaduha, kumu de labí yúkana bí uka len Pedruha. ");
INSERT INTO zae_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes‑ni nna iki de chi begilakana Pedruha nna tti anúbana gwaxxakakana, nianna benna mandadu kini biso du ka soldadu use'e gweyú ro'o lisiyyaha arloni, ttaka kumu labí biria ni'akinna bixa uka len Pedruha, nianna tti udhelhana kini bettikana ka soldaduha. Iki de nuha nna tti bedá Herodes‑ni Judea‑ni nna beyadina besinna lhe'esi Cesarea‑ni nna niha‑ba udona. ");
INSERT INTO zae_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes‑ni yalhá rise'enna len ka benne ge Tiro‑ni lhe ge Sidón‑ni lhe. Ttaka ka benneha nna ttúba belaba leke kini tsiake sanne lenke na. Blasto nu rido gaxxaba kwe'eniha, nuha‑ruba nuha gwa udaake bixú yiekanie na kini utso duna ke arlo Herodes‑ni. Laxkala de Blastoha‑ruba nuha nna gwa biri'a lenke unnabake kini bese'e tse lenke Herodes‑ni kumu lo ka yu se'e daka ata rinnabianaha, niha‑ruba nuha gwa rixú lena kini roke. ");
INSERT INTO zae_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tti chi gwadona sá inne len Herodes‑ni ka benneha, nianna biku xo tseni nna udona lo ata rinnabianaha. Nianna tti udulona ulu'una libana arlo ka benneha. ");
INSERT INTO zae_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ka benne saa niha nna ribesi'abake, ráke: ―¡Benne rinne‑ni, diosiba anka benne‑ni! ¡Labí anka benne‑ni, benne! ");
INSERT INTO zae_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Looraha tteba nna ben ttu anjeli ge Tata Xisiha kini uyu'u Herodes‑ni ttu isagwe, kumu de labí begwena lidhaka Tata Do Yebáha, sinuki la labana benna kini uná xxeni leni. De nuha nna uttina uto ka beduha latini. ");
INSERT INTO zae_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ka tisa ge Tata Do Yebáha nna ttu diaba ka benneha radhike nna ka benne chi ria leke ge Jesús‑ni nna diarugabake ranike. ");
INSERT INTO zae_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Sauloha lhe Bernabé‑ni lhe, tti chi uluxakinna sina nu daa lokani uinkanaha, nianna bedákana Jerusalén‑ni nna deyyakana Antioquía‑ni, dechegabakana Juan nu tegaba láni Marcos. ");
INSERT INTO zae_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Lhe'e ka benne chi ria leke ge Jesús‑ni se'e lhe'esi Antioquía, niha sela ka benne ankake profeta lhe ka benne rula'ake ka tisa ge Tata Do Yebáha lhe. Ka benneha nuha tee láke Bernabé lhe Simón benne tegaba lábie Benne Yadhi lhe Lucio benne lhe'esi Cirene lhe Manaen benne bixenie turo'o len Herodes nu unnabiana daka Galilea lhe niha‑gaba sela Sauloha lhe. ");
INSERT INTO zae_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ttu sá nna yu'uke rulhake ge Tata Xisiha lhe rutte ubina lhe'eke lhe, nianna tti unne Espíritu geeha, rabie ke: ―Kwesile Bernabé‑na lhe Saulo‑na lhe kini uinkana sina nu chi ga'anati uinkana. ");
INSERT INTO zae_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Aníha uka nna, iki de tti chi uluxakanie ulhapike tisa len Tata Do Yebáha lhe bette ubina lhe'eke lhe, nianna tti uxxua náke iki Bernabé‑ni lhe iki Saulo‑ni lhe, nianna tti uchú tisake kana nna biria ttebakana diakana. ");
INSERT INTO zae_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Espíritu ge Tata Do Yebáha‑ba udhelhe Bernabé‑ni lhe Saulo‑ni lhe diakana. Nianna tti ugwadikana bisinkana lhe'esi Seleucia. Niha bedaxxukana barcu kini diakana daka lo yu re lagwi indatooha nu tee láni Chipre. ");
INSERT INTO zae_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tti chi bisinkana lhe'esi Salamina, niha udulokana utixxi'akana ka tisa ge Tata Do Yebáha lhe'e ka yo'o ata rudheti ka benne Israel‑ni ka tisa geeha. Chegabakana Juan nu tegaba láni Marcos kini ute náni lenkana. ");
INSERT INTO zae_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Utebakana itúba lo yu re lagwi indatooha axtaliba biriakana ro'o nuha ata re yiesi nu tee láni Pafos. Niha gwaxxakakana ttu nu Israel ruinna elha gwesá. Nuha tee láni Barjesús. Lana ankana ttu profeta gwen lasi. ");
INSERT INTO zae_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Barjesús‑ni tseba do lenna Sergio Paulo nu rinnabiana iyába ka yiesi se'e daka Chipre‑ni. Sergio Paulo‑ni ankana ttu nu rapa elha rieni. Nianna uxina Bernabé‑ni lhe Saulo‑ni lhe kumu de raka leni udo nagani ge ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ttaka Barjesús‑ni, nu tegaba láni Elimas, lana richúbana lokani ruinna kini abittu tsia le Sergio Paulo‑ni gekani. ");
INSERT INTO zae_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ttaka Sauloha nu tegaba láni Pablo, yu'u galába itú latini Espíritu ge Tata Do Yebáha, nianna tti belanni tsittabana lo Barjesús‑ni ");
INSERT INTO zae_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nna rana na: ―¡Aaluxa nu gwen lasi lhe nu ruin iyá looba nu satsa lhe! ¡Lu ankalu xi'ini nu xxegwiha lhe abittuba ru'u lelu uinlu nu dika ixú lhe! ¿Nukala udú siilu abitturu unnittilu neda ge Tata Xisiha? ");
INSERT INTO zae_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Loora nnanna ugwebie lu ttu elha disa. Labíru aka ilenlu, isá tadána abitturu ilenlu xiani ge tatubisa‑na. Tti lo rinne Pabluha nna beya'an tteba Elimas‑ni lo xua. Nianna binchitoriba rekina, regilana nuxa eyalhina náni kumu de labíru rilenna. ");
INSERT INTO zae_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tti bilani nu rinnabiaha nu chi ukaha, nianna ugía tteba leni ge Jesús benne anke Xxanari'iha de bebaninna ge ka tisa geeha, delába ka tisa bele'ekin Pabluha na. ");
INSERT INTO zae_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pabluha lhe ka benne dia lennaha lhe, bedaxxuke barcu ro'o indatoo ge Pafos nna bisinke lhe'esi Perge. Nuha rena daka Panfilia. Ttaka debá niha‑ba bedha'an Juan Marcos‑ni ke nna beyekina deyyana lhe'esi Jerusalén‑ni. ");
INSERT INTO zae_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Lake nna bedáke Perge nna bisinke lhe'e yiesi nu tegaba láni Antioquía. Nuha rena daka Pisidia. Tti bisia sá reyaka le ka nu Israel‑ni, la'ania uta'a ka Pabluha lhe'e yo'o ata rudhetikana ka tisa ge Tata Do Yebáha nna use'e ttebake. ");
INSERT INTO zae_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Iki de chi bibaba ka tisa dia lo bia bennabi bodha'an Moisés‑ni lhe ka tisa dia lo ka yetsi bodha'an ka profetaha lhe, nianna tti udhelha ka nu rinnabia lhe'e yo'o ata rudheti ka benne ka tisaha, kini ugía ka nu gweasikana ka Pabluha: ―Xa betsi to, ganna si tee ttu bixa innele nu dika odú ittale le ka benne, gwalte nna gwalinne. ");
INSERT INTO zae_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nianna tti udú lii Pabluha nna bettá náni kini beyaka sii ka benne se'e niha, nianna tti unnena rana: ―Lebi'i ka benne Israel lhe iyá ttele ka benne dittu ka benne gwa rudole tisa ge Tata Do Yebáha, gwaludoruga nagale innea. ");
INSERT INTO zae_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ri'i ka benne Israel, Tata Do Yebaa geri'iha bekwebie ka benne uka xuttori'iha lhe bedien xxatte ke atti use'eke ukake benne dittu lo yu ge Egiptoha. Anágaba nna tsitsigaba uná lebie tti bebeabie ke lo yu ge ka nuha. ");
INSERT INTO zae_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Delo chua (40) idaha biyúbie ke tti deyu'uke neda deyyake lo yu bisiha. ");
INSERT INTO zae_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nianna iki de chi betse'e loobie gasi ka yiesi xeni, ka nu se'e daka lo yu ge Canaán‑ni, nianna tti betebie ka yuha lenke. ");
INSERT INTO zae_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Iyá nuní uka delo ttapa gayua bixxi tsieyona (450) idaha. ’Delola nna tti bese'e Tata Do Yebáha ka nu uka xueda kini unnabiakana ke. Debá tti udo Samuel benne uke profeta ge Tata Do Yebáha, debá la'ania gwa use'eru ka xuedaha. ");
INSERT INTO zae_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Iki de nuha nna tti unnabake len Tata Do Yebáha kini odúe ttu nu innabia xeni geke. Tata Do Yebáha nna bodúe Saúl xi'in biyú benne tee lábie Cis. Saúl‑ni ukana benne datiana Benjamín‑ni, delába ttu ka benne uka xuttori'iha. Saúl‑ni unnabiana chua (40) ida. ");
INSERT INTO zae_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tti chi ulhida gaa Tata Do Yebáha Saúl‑ni, nianna bodúbie David‑ni kini akana nu innabiana ke. Ge David‑ni nuha unne Tata Do Yebáha tti ree: “Neti chi gwaxxakaa David xi'in benne tee lábie Isaí, lana ankana ttu benne ru'u lasia lhe lana uinna iyá nu raka lasia lhe.” ");
INSERT INTO zae_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ttu ka benne datiake David‑ni, delába Jesús‑ni, labie nuha udhelha Tata Do Yebáha bie kini odilábie ri'i ka benne Israel. Benba Tata Do Yebáha attiba chi rabie unie. ");
INSERT INTO zae_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Atti lanila isia Jesús‑ni yiesi lo yu‑ni, Juan‑ni chila ugwekina utixxi'enna iyá ka benne Israel‑ni rana ke teeki odúna ke nna odaxxuke neda ge Tata Do Yebáha, nianna gadike inda. ");
INSERT INTO zae_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tti chi deoba lhuxin Juan‑ni sina nu bodha'an Tata Do Yebáha uinna, la'ania nna rana: “Laa netiga nuha benne rakinle chi ga'anani Tata Do Yebáha isia, sinuki iki dela neti nna si isiala benneha. Benneha labí elha ralhaa idhasia lo ka gwaracha geeha.” ");
INSERT INTO zae_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Betsi to, lebi'i ka benne datiale Abraham‑ni lhe anágaba lebi'i ka benne dittu ka nu gwa rudole tisa ge Tata Do Yebáha, len iyá tteri'i nuní chi bisia ka tisa ka nu rigixxi'akana gasina odilá Tata Do Yebáha ri'i. ");
INSERT INTO zae_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ka nu se'e Jerusalén‑ni lhe ka nu rinnabia gekaniha lhe, labí yúkana nuxa uka Jesús‑ni, nigaba a rite dákinna ata rinne ge benneha lo ka yetsi bodha'an ka profeta ge Tata Do Yebáha, delába ka yetsi ka nu ribaba tti risia ka sá reyaka leri'i. Ttaka tti bettikana Jesús‑ni, la'ania nna gwado tisa ge nu ra lo ka yetsiha. ");
INSERT INTO zae_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Meskiba labí gwaxxakakana bí lo ni'a ge uttikane la'ania, ttaka unnaba lo xuabakana len Pilato‑ni kini ugwelhana kana uttikane, ");
INSERT INTO zae_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","nna iki de chi benkana iyá nu rigixxi'a gebie lo ka yetsi ge Tata Do Yebáha, nianna tti bechidakane lo ya kurusiha nna bekatsikane. ");
INSERT INTO zae_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ttaka Tata Do Yebáha belhidhabe benneha lagwi ge ka benne chi uttiha ");
INSERT INTO zae_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","nna ixeru ubisa bele'e loe len ka benne ugwekike lenie atti birie lo yu ge Galilea‑ni nna bisine lhe'esi Jerusalén‑ni. Nnanna nna ka benne ugwekike lenbie la'ania, ka benneha nuní rekike rigixxi'ake gebie len ka benne ");
INSERT INTO zae_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","lhe anágaba ri'itu rigixxi'agabintu le ge benneha. Rigixxi'entu le ge nu chi ra Tata Do Yebáha ka benne ukake xuttori'iha deki unie ttu bixa len lebi'i. ");
INSERT INTO zae_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Laxkala tti belhidhe Jesús‑ni lo elhuttiha, len ri'i ka benne datiari'i ka benneha, len ri'i nuha betto lonie nu chi ree ka benneha. Benbe ttiba ra lo Salmo nu berupaha. Lo Salmoha rinnebie, ree: “Lu ankalu xi'inia, neti bijaa lu nasá.” ");
INSERT INTO zae_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Rágaba lo ka yetsi ge Tata Do Yebáha deki elhidhabe benneha lagwi ge ka benne chi uttiha, aníha kini abittu usu bela latie, kumu aníha unnebie ree: “Gutebaa len lebi'i nu tse chi xpeya David‑ni utea.” ");
INSERT INTO zae_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Laxkala lo attu Salmo rinnegaba David‑ni rana Tata Do Yebáha: “Abittu ugwelhalu initti bela lati benne chi ulesilu ki ake geluha.” ");
INSERT INTO zae_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ttaka nna laa gwalíga geni nuha rinnena tti rana aníha, kumu David‑ni, tti udona yiesi lo yu‑niha, iki de chi benna nu redá le Tata Do Yebáha uinna, nianna uttibana nna bigatsibana attiba bigatsi ka benneola geniha. Laxkala usuba bela latini. ");
INSERT INTO zae_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ttaka benne belhidha ben Tata Do Yebáha lo elhuttiha, benneha labí usu bela latie. ");
INSERT INTO zae_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Laxkala xa betsi to, teeki unale deki Jesús benne labí usu bela latieha, de nu gwate benneha nna rigixxi'entu le gwa teeba elha xen lasi ge ka tulha geri'i. ");
INSERT INTO zae_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kumu bia bennabi bodha'an Moisés‑ni labí udaa nuha kuana yua nujari'i ge ka tulha ruinri'i, ttaka ka benne chi ria leke ge Jesús‑ni, de labie nna iyábake labíru yua nujake ge ka tulha ruinke. ");
INSERT INTO zae_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Laxkala lebi'i, gwaluyú gele kini ka satele luesi nu ra lo ka yetsi ben ka profeta ge Tata Do Yebáha, ata dia ra: ");
INSERT INTO zae_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Lebi'i ka nu rigu'u ni'ale neti, enitti loobale lhe ugía ya'abale lhe, kumu lhe'e ka sá se'ele nnanna, unia ttu nu labí tsia lele geni, meskiba ganna nuxa kixxi'enna le geni nna labí tsia lele geni. ");
INSERT INTO zae_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tti beria ka Pabluha lhe'e yo'o ata rudheti ka benne Israel‑ni ka tisa ge Tata Do Yebáha, nianna tti unnaba ka benne lenkana kini kixxi'arukinna ke ge nu chi unnekanaha ganna chi bedesia attu sá tti reyaka lekeha. ");
INSERT INTO zae_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tti chi besatsakeha, nianna ixeru ka benne Israel lhe adíru ka benne dittu ka benne chi ria leke ge Tata Do Yebáha ttiba chi ria le ka benne Israel‑ni, iyábake danalhake Pabluha lhe Bernabé‑ni lhe. Lakana nna rákana ke: ―Bittu udhanle a tsiale lo neda tse chi bedá le Tata Do Yebáha betebie gele. ");
INSERT INTO zae_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tti gwadona xumanuha atti chi bedesia sá tti reyaka le ka benne Israel‑ni, la'ania nna a lattiba a bitupa iyá ka benne ge yiesiha kini bedo nagake ge ka tisa ge Tata Do Yebáha. ");
INSERT INTO zae_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ttaka tti bilani adíru ka nu Israel‑ni deki ixeba ka benne bitupake niha, nianna ttiba ttu nu upa yie ukakana nna tti udulokana rusia lekani Pabluha nna rákana: “Labí lii nu rinne nuní.” ");
INSERT INTO zae_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ttaka Pabluha lhe Bernabé‑ni lhe labí rasikinna rinnekana, rákana: ―Lebi'i ka benne Israel, lade'axa len lebi'i raka doelha kixxi'entu le ka tisa ge Tata Do Yebáha. Ttaka lebi'i rigu'ula ni'ale ka tisa‑ni lhe anágaba lhe ruinbale attisidiba labí elha ralhale aka benle ttu dia lii. De nuha nna ka benne abittu ankake ka benne Israel, ka benneha‑la tsiatu kixxi'entu ke ka tisa‑ni. ");
INSERT INTO zae_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kumu aníha chi bodha'an Tata Xisiha len ri'itu tti ree: Lu chi bedúa kini akalu attiba ttu xiani ge ka benne abittu ankake nu Israel kini ixúlu kixxi'alu gasina odiláya ka benne se'e axtaba ka xi'a besi ge yiesi lo yu‑ni. ");
INSERT INTO zae_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ka benne abittu ankake nu Israel nna, tti biyienkanie nu ra ka Pabluha, nianna tti bedú ittana leke nna ráke: ―¡Yalháruba tse anka ka tisa ge Tata Xisiha! La'ania nna iyába ka benne chi ga'anna deki aka benke ttu dia lii, iyába ka benneha ugía leke ");
INSERT INTO zae_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","nna lhe'e iyába ka yiesi to se'e itúba ka daka niha chi radhi ka tisa ge Tata Xisiha. ");
INSERT INTO zae_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ttaka ka nu loni ge ka nu Israel‑ni nna ulu'u tisakana ka nuila ka nu gwa riarukana yotu lhe ankakana ka nu ra xxeni lekani lo yiesiha lhe, anágaba lhe unnegaba lenkana ka nubiyú ka nu ankakana ka nu loni ge yiesiha, kini ka nuha nna betsatsakana ka benne, nianna tti bochesukana ka Pabluha bebeakana kana lo yu gekaniha. ");
INSERT INTO zae_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ka Pabluha nna tti beriakana lhe'esiha nna bekubi ni'akani biste arlo ka nu lhe'esiha. Aníha benkana kini benna liikana deki Tata Do Yebáha labí uyu'u lebie nu ben ka nuha de bebeakana kana lhe'esi gekaniha. Nianna tti bedá ka Pabluha nna bisinkana lhe'esi Iconio. ");
INSERT INTO zae_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ttaka ka benne beya'anke lhe'esiha, delába ka benne chi ria leke ge Jesús‑ni, yalhá itta du leke lhe anágaba lhe yu'ugaba Espíritu ge Tata Do Yebáha itúba latike lhe. ");
INSERT INTO zae_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Uka nuha tti bisin Pabluha lenna Bernabé‑ni lhe'esi Iconio‑ni, ixpabakana uta'akana lhe'e yo'o ata rudheti ka benne Israel‑ni ka tisa ge Tata Do Yebáha. N