﻿USE sofia;
DROP TABLE IF EXISTS sofia.zadNT_vpl;
CREATE TABLE zadNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zadNT_vpl WRITE;
INSERT INTO zadNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dga cho'en dill' nan Jesucrístona' nake' xiiṉ dia c̱he dii Davina' na' dii Abrahama'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahama' goke' x̱a Isaaca', na' Isaaca' goke' x̱a Jacoba', na' Jacoba' goke' x̱a Judána' len beṉ' bisheeka'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Na' Judána' goke' x̱a Fáreza' len Zárana', na' xṉeeka' wlie' Tamar. Na' Fáreza' goke' x̱a Esróma', na' Esróma' goke' x̱a Arama'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Na' Arama' goke' x̱a Aminadaba', na' Aminadaba' goke' x̱a Naasónna', na' Naasónna' goke' x̱a Salmónna'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Na' Salmónna' len Rahaba' gokgake' x̱axṉa' Booza'. Na' Booza' goke' x̱a Obeda' na' xṉeena' wlie' Rut. Na' Obeda' goke' x̱a Isaína'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Na' Isaína' goke' x̱a Davina', na' Davina' goke' x̱a Salomónna'. Na' xṉa' Salomónna', beena' bikaa Davina', goke' xool dii Uríaza'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Na' Salomónna' goke' x̱a Roboama', na' Roboama' goke' x̱a Abíaza', na' Abíaza' goke' x̱a Ásana'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Na' Ásana' goke' x̱a Josafata', na' Josafata' goke' x̱a Jorama', na' Jorama' goke' x̱a Uzíaza'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Na' Uzíaza' goke' x̱a Jotama', na' Jotama' goke' x̱a Acaza', na' Acaza' goke' x̱a Ezequíaza'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Na' Ezequíaza' goke' x̱a Manaséza', na' Manaséza' goke' x̱a Amónna', na' Amónna' goke' x̱a Josíaza'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Na' Josíaza' goke' x̱a Jeconíaza' len beṉ' bisheeka', ḻegaken' zoa kana' bc̱he'byen beṉ' Babilóniaka' beṉ' Israelka' lalle'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Na' shlak ni zoagake' Babilóniana' golj Salatiela' xiiṉ Jeconíaza', na' Salatiela' goke' x̱a Zorobabela'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Na' Zorobabela' goke' x̱a Abiuda', na' Abiuda' goke' x̱a Eliaquima', na' Eliaquima' goke' x̱a Azora'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Na' Azora' goke' x̱a Sadoca', na' Sadoca' goke' x̱a Aquima', na' Aquima' goke' x̱a Eliuda'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Na' Eliuda' goke' x̱a Eleazara', na' Eleazara' goke' x̱a Matánna', na' Matánna' goke' x̱a Jacoba'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Na' Jacoba' goke' x̱a Joséna' beṉ' c̱he Maríana', xṉa' Jesúza', beena' ḻekzka' nsi'gake' Cristo. ");
INSERT INTO zadNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Na' ka' gok wzoa shda' diaka' wzololenzan dii Abrahama' na' biyoll-lenan dii Davina'. Na' wde zi shda' diaka' bizzololenan dii Davina' ax̱t ka bc̱he'byengake' beṉ' Israelka' Babilóniana'. Na' wizak zi shda' diaka' bizzolon ka bc̱he'byengake' ḻegake' Babilóniana' ax̱t ka wzoa Crístona', beena' bseḻ' Chioza' iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ki gok ka golj Jesucrístona': Xṉee Maríana' ba nakan ikaa Joséna'ne', na' ka zi' soalene'ne' bi'e, ḻa' Espíritu Santo c̱he Chioza' bene' kwenc̱he bi'e. ");
INSERT INTO zadNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na' Joséna' beena' ba nakan ikeene', nake' to beṉ' chon ka cheeni Chioza', na' daa bi goklallee wsi'e Maríana' yeḻ' zto' gokile' c̱hooṉlalleene' ka kono gakbe'i. ");
INSERT INTO zadNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Na' shlak chza'lallee gone' dga, to anjl c̱he X̱ancho Chioza' bli'lawe' ḻe' lo bishgal c̱he'na', na' chi'ene': ―José, xiiṉ dia c̱he dii Daví, bi illebo' ikoo Maríana' daa ba no'e, ḻa' Espíritu Sántona' bene' kwenc̱he bi'e. ");
INSERT INTO zadNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Na' sane' to bi' byodo' na' wsi'ob' Jesús, ḻa' ḻeban' yislab' beṉ' yell c̱heb'ka' lao saaxya c̱he'ka' kwenc̱he bi kwiayi'gake'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gok yog' diiki kwenc̱he gok ka wna dii beena' wdix̱jee daa goll Chioza'ne', chi'e: ");
INSERT INTO zadNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","To nool wew' wee, na' sane' to bi' byodo', na' wsi'gake'b' Emanuel. Na' Emanuel zejin: Chioza' zoalene' cho'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Na' ka biban Joséna', bene' kon ka goll anjl c̱he X̱ancho Chioza'ne' na' wkee Maríana'. ");
INSERT INTO zadNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Na' bi wdelle'ne' ax̱t ki wxanche' bi'do'na', na' bsi'eb' Jesús. ");
INSERT INTO zadNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesúza' golje' yell Belénna', daa llia gana' mbani Judeana', kana' chṉabia' Heródeza'. Na'ch baḻ beṉ' sin', beṉ' nsed c̱he beljka', za'gake' ka de gana' chla'lə wbilla', bllintegake' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Na' che'gake': ―¿Gaṉi rey c̱he beṉ' Israelka', bi'na' ba golj? Ṉezinto' ba goljb' ḻa' ka de gana' chla'lə wbilla' ble'into' to belj dii bzajniin neto' nan ba goljb', daan ba za'nto' kwenc̱he we'la'onto'b'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Na' ka beni Heródeza' daa wnagake', gokshejlallee, na' ḻekzka' yog'ḻoḻ beṉ' Jerusalénka'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Na'ch Heródeza' goxe' yog'ḻoḻ bx̱ozka' chṉabia', na' beṉ'ka' chli' chsedi ley c̱he dii Moiséza', na' wṉabile' ḻegake' gan chiyaḻ' galj Crístona', beena' wseḻ' Chioza' iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Na'ch gollgake'ne': ―Yell Belénna' daa mbani Judeanan' galje', ḻa' kan' bzej to beṉ' wdix̱jee daa goll Chioza' ḻe', chi'e: ");
INSERT INTO zadNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Na' li', yell Belén llio' gani mbani Judeani, aga iṉacho nako' dii ḻiizelozi bibi zakii ladj yellka' zakii llia Judeani; ḻa' lawo'ni ichej to beṉ' iṉabi'e, na' gap wwie' beṉ' Israelka', beṉ'ka' nak yell c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Na'ch Heródeza', ka kono gokbe'zi goxe' beṉ' sin'ka' na' wṉabile' ḻegake' batyeṉ'an ble'gakile' belja'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Na'ch bseḻee ḻegake' Belénna' na' golle' ḻegake': ―Ḻi shaj, na' ḻi lljadiljyoll bi'do'na', na' kat' yillelileb' na' yidṉale nad' kwenc̱he len' sha' llje'lawaab'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Na' ka biyoll goll Heródeza' ka', na'ch wza'gake'. Na' belja' daa ble'gakile' kana' zi' sa'gake', zejan xan yabana' llialon lawe'ka', na' ka bllinan gana' zoa bi'do'na', na' na'zə wzoan. ");
INSERT INTO zadNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Na' ka bizle'i beṉ' sin'ka' belja', ḻe bibagakile'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Na'ch ka wyoogake' ḻoo yoona' ble'gakile' bi'do'na' len xṉa'b' Maríana'. Na'ch bc̱hek' xibe'ka' na' be'la'ogake'b'. Na' wlejgake' or, na' yal zix̱, na' ḻekzka' len nill' c̱he to yag dii chḻa' zix̱ daa le mirra, na' be'gake'n c̱heb'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ka biyoll be'la'ogake'b', Chioza' bsi'nile' ḻegake' lo yel bishgal c̱he'ka' kwenc̱he bich yidegake' gana' zoa Heródeza'. Daan, bikaagake' nez yoblə ziyajgake' lalle'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ka wde biza' beṉ' sin'ka', to anjl c̱he X̱ancho Chioza' bli'lawe' Joséna' lo bishgal c̱he'na' chi'ene': ―Wyas, na' bc̱he' bdo'na' len xṉa'baa na' ḻi shaj gana' mbani Egíptona'. Na' na'z soale ax̱t kat'ch iṉia' li' yiza'le. Ḻa' Heródeza' yiyilje' bdo'na' kwenc̱he wite'b'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Na'ch lii wyaste Joséna' na' bc̱hi'e bdo'na' len xṉa'baa, na' waḻ-lə wza'gake' zejlengake'b' gana' mbani Egíptona'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Na' wzoagake' na'zə ax̱t ka bllin lla wit Heródeza'. Na' daa gok ka', gok ka goll X̱ancho Chioza' to beṉ' wdix̱jee daa golle'ne', kana' wne': “Nad' biṉia' bi' c̱ha'na' kwenc̱he biza'b' gana' mbani Egíptona'.” ");
INSERT INTO zadNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na' ka gokbe'i Heródeza' bi ben beṉ' sin'ka' ka golle' ḻegake', ḻe bllee. Na' bene' mandad witgake' yog'ḻoḻ bi' byodo'ka' lle' yell Belénna' len yellka' ndiḻ nllagan, bdo' cheeṉka' ax̱t bi' c̱hop yizi, bsakee ka to yizka' ba gok ble'i beṉ' sin'ka' belja'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na' daa bengake' ka', gok daa wna dii Jeremíaza', beena' wdix̱jee daa goll Chioza' ḻe', ka wne': ");
INSERT INTO zadNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Kwe' wbell na' gakyeshii beṉ'ka' lle' yella' le Ramá. Noolka' nak xiiṉ dia c̱he dii Raquela' ni to kono cheengakile' gonxenlall' ḻegake', daa wit bi'do' c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Na'ch ka wde wit Heródeza', to anjl c̱he X̱ancho Chioza' bli'lawe' Joséna' lo yel bishgal c̱he'na' shlak ni zoe' Egíptona', na' chi'ene': ");
INSERT INTO zadNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Wyas, bic̱he' bi'do'na' len xṉa'baa na' ḻi yiyaj gana' mbani Israela', ḻa' ba wit beṉ'ka' cheengakile' witgake'b'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Na'ch wyas Joséna' na' bic̱hi'e bi'do'na' len xṉa'baa na' biyajgake' gana' mbani Israela'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Na' ka wṉezi Joséna' Arquelawa' ba chṉabi'e lo laz dii x̱e' Heródeza', na' bllebe' yiyajgake' Judéana'. Na' Chioza' wdix̱je'ile'ne' lo yel bishgal c̱he'na' yiyajgake' gana' mbani Galileana'. ");
INSERT INTO zadNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Na' ka billingake' Galileana' jazoagake' yell Nazareta'. Na' daa jazoagake' na', gok ka wna dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yi c̱he Jesúza', wnagake' wsi'gake'ne' beṉ' Nazaret. ");
INSERT INTO zadNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na' do kana', Juan, beena' bchoa beṉ' nisa', wyaje' to latj gana' bibi chashj chḻeb gana' mbani Judeana', na' wdix̱je'ile' beṉ'ka' chdi'a chllag na', ");
INSERT INTO zadNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","chi'e: ―Ḻi yiyaj yileni dii malka' chonle, ḻa' ba bllin lla iṉabia' Chioza', beena' zoa yabana', ḻoo yic̱hjlall'do'lena'. ");
INSERT INTO zadNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Na' dii Isaíaza', beena' wdix̱jee daa goll Chioza'ne', wne' c̱he Juanna': To beṉ' gosyee to lo latj ga bibi chashj chḻeb, na' iṉe': “Ḻi se kwas wzenagle c̱he X̱anchona' na' wsalj yic̱hjlall'do'leka' kat' zee.” ");
INSERT INTO zadNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na' Juanna' bene' xe'na' de xa kamey, na' nc̱hej lsineena' to yid. Na' wdawe' bish'zo len shin baser daa de lyix̱aa. ");
INSERT INTO zadNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na' beṉ'ka' lle' yell Jerusalénna', na' doxen gana' mbani Judeana' na' yellka' llia gaoz yao Jordánna' jazenaggake' dillaa cho'e. ");
INSERT INTO zadNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Na' bix̱oadoḻ'gake' saaxya c̱he'ka', na' bchoa Juanna' ḻegake' nisa' ḻoo yao Jordánna'. ");
INSERT INTO zadNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Na' ka ble'i Juanna' zan fariseoka' na' saduceoka' bllingake' lawe'na' kwenc̱he wchoe' ḻegake' nisa', na' golle' ḻegake': ―¡Le' naklikzle ka beḻ zṉia! ¿Achakile wak wxoṉjile' yeḻ' zak'zi' daa wseḻ' Chioza'? ");
INSERT INTO zadNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ḻi gon ka gakbe'i beṉ' nan dii ḻi ba biyaj bilenile. ");
INSERT INTO zadNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na' bi gakzile bibi yeḻ' zak'zi' ile'ile daa iṉazle: “Neto' naknto' xiiṉ dia c̱he dii Abrahama'.” Dii ḻi nia' le', ax̱t yajki wak gon Chioza' xiiṉ dia c̱he dii Abrahama'. ");
INSERT INTO zadNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yog'ḻoḻ-le shi bi chonle ka chiyoolallii Chioza' na' gak c̱hele ka chak c̱he to yag dii chbia dii zix̱ dii bi chak wen, na' lii chc̱hogtegake' ax̱t xanin na' chzaḻ'gake'n lo yi'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Dii ḻi nad' chchoa' le' nisa' daa chiyaj chilenile, per beena' zi' za' kollaana' napche' yeḻ' wak xench ka nad', na' ni bi zakaa gak' xmose' kwenc̱he galj' xele'na'. Ḻen' gone' ka yidsoa Espíritu Sántona' ḻoo yic̱hjlall'do'lena', ka le' chiyaj chilenile', na' beṉ'ka' bi chiyaj chileni wzaḻee ḻegake' lo yi' gabiḻa'. ");
INSERT INTO zadNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Na' gone' c̱he beṉ' yell-lioni ka chon beena' nox̱' yag xozaa daa chpa'ile' trígona' na' kooshawee trígona' na' wzeye' beb c̱heyinna' lo yi'na' daa biga yiyolkzə. ");
INSERT INTO zadNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na'ch wza' Jesúza' gana' mbani Galileana' wyaje' cho'a yao Jordánna' kwenc̱he wchoa Juanna'ne' nisa'. ");
INSERT INTO zadNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Na' ka blline', bi nan cheeni Juanna' wchoe'ne' nisa', san chi'ene': ―Li'lan chiyaḻ' wcho' nad' nisa', na' li'lə za'zo' kwenc̱he wchoa' li' nisa'. ");
INSERT INTO zadNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Per Jesúza' golle'ne': ―Ben goklen bchoa' nad' nisa' ḻa' chiyaḻ' goncho ka nak daa nllia Chioza' bia' goncho. Na'ch bchoe'ne' nisa'. ");
INSERT INTO zadNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Na' kon ka biyoll bchoe'ne' nisa' lii bichejte Jesúza' ḻoo nisa' na' lii byaljte yabana' na' ble'ile' Espíritu c̱he Chioza' chetje' ka to palom na' jsoalene' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na'ch bengakile' shii Chioza' zoa yabana' chi'e: ―Beenin nake' Xiiṉ', beena' chakid', na' ḻe chibaid' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Na'ch Espíritu c̱he Chioza' bc̱hi'e Jesúza' to latj ga bibi chashj chḻeb na' dii x̱iwaa goklalliin kooyeḻa'n ḻe' gone' ka cheenin. ");
INSERT INTO zadNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na' ka wde c̱hoa lla c̱hoa yel bibi wdawe', na' wdone'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na'ch bllin dii x̱iwaa kwite'na' gollan ḻe': ―Shi leilo' nako' Xiiṉ Chios, ben ka yiyak yajki yetxtil. ");
INSERT INTO zadNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Na'ch goll Jesúza': ―Cho'a xtill' Chioza' nan: “Aga toz yeḻ' wawa' choe'n yeḻ' mban c̱he beṉec̱ha', san ḻekzka' Cho'a Xtill' Chioza' choe'n yeḻ' mban.” ");
INSERT INTO zadNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Na'ch dii x̱iwaa bc̱he'n ḻe' Jerusalénna' daa nak yell c̱he Chioza' na' bḻepan ḻe' yic̱hj yoodo'na' gana' nak sib wal. ");
INSERT INTO zadNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Na'ch gollan ḻe': ―Shi leilo' nako' Xiiṉ Chios, lla bixit'shki ni. Ḻa' Cho'a Xtill' Chioza' nan: Wseḻee anjl c̱he'ka' gap wwiagake' li', na' gox̱'gake' li' kwenc̱he ki koo wc̱hewo' yajka'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Na' goll Jesúza' ḻen: ―Ḻekzka' na Cho'a Xtill' Chioza': “Bi wzo' Chioza' gone' daa nazan c̱ho' kwenc̱hezə x̱enlalloo shi gone' ka ba wne'.” ");
INSERT INTO zadNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Na'ch stokzə bizc̱he' dii x̱iwaane' to lo yaa sib wal na' bliin ḻe' yog' yellka' lle' yell-lioni na' yeḻ' zakii c̱heyinka'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Na' gollan ḻe': ―Yog' diiki chle'ilo' goṉ' li' shi wc̱hek' xibo'na' we'lawoo nad'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Na'ch goll Jesúza' ḻen: ―Biyaj, Satanás, ḻa' Cho'a Xtill' Chioza' nan: “Be'la'o toz X̱ano' Chioza' na' kon daa iṉe', ḻennan' gono'.” ");
INSERT INTO zadNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Na'ch biza' dii x̱iwaa kwit Jesúza' na' bllin baḻ anjlka' be'gake'ne' kon bi byalljile'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ka beni Jesúza' wloogake' Juanna' lillyana', bizee biyaje' gana' mbani Galileana'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Na' bizee yell Nazareta' na' jazoe' yell Capernaúma', to yell xen dii llia cho'a nisdo'na' gana' mbani yell-lio c̱he dia c̱he dii Zabulónna' na' dii Neftalína'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na' daa jazoe' na', gok ka wna dii Isaíaza', beena' wdix̱jee daa goll Chioza'ne', daa wne': ");
INSERT INTO zadNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ka nak yell-lio daa naki c̱he dia c̱he dii Zabulónna' na' dii Neftalína', daa llia shḻaa yao Jordánna', gana' xoa nez daa zej cho'a nisdo'na' daa llia gana' mbani Galileana', gana' lle' zan beṉ'ka' bi nak beṉ' Israel, ");
INSERT INTO zadNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","beṉ'ka' lle' na' gok yic̱hjlall'do'eka' shgasj shc̱hoḻ, na' Chioza' ba bseḻee to beeni' xen lawe'ka'. Lao beṉ'ka' lle' gana' chṉabia' yeḻ' wita' ba chzeeni' beeni' c̱he Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Na' wzolo Jesúza' chyix̱je'ile' beṉ' cho'a xtill' Chioza', chi'e: ―Ḻi yiyaj yileni dii malka' chonle, ḻa' ba bllin lla Chioza', beena' zoa yabana', iṉabi'e ḻoo yic̱hjlall'do'lena'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na' ka zej Jesúza' cho'a nisdo' c̱he Galileana' ble'ile' c̱hop bish' beṉ' wxen beḻ chzaḻ'gake' yix̱ja' ḻoo nisa' chzengake' beḻa'. Toe' le Simón na' ḻekzka' nsi'gake'ne' Pedro, na' beena' sto lie' Andrés. ");
INSERT INTO zadNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Na'ch Jesúza' chi'e ḻegake': ―Ḻi da, dino nad', na' kon ka chonle ṉaa chbejle beḻki ḻoo nisi, ka'kzan gonle yibejle beṉ' lao dii mala'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na' ka golle' ḻegake' ka', lii bkwaaṉ'tegake' yix̱j c̱he'ka' na' zejlengake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Na' zi lat'chga wza'gake' bizle'i Jesúza' zi c̱hop bish' beṉ', beena' to lie' Jacobo na' beena' sto lie' Juan, beṉ'ka' nak xiiṉ Zebedewa', lle'gake' to ḻoo barkw chiyonshao'gake' yix̱ja' daa chzengakile' beḻka'. Na' ḻekzka' goll Jesúza' Jacóbona' len Juanna' shajlengake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Na' lii bkwaaṉ'tegake' barkwa' len x̱e'ka' na' janogake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na' wda Jesúza' yog' yellka' llia doxen gana' mbani Galileana', chli' chsedile' beṉ' Israelka' gana' chdop chllaggake' choe'ḻwillgake' Chioza', cho'e dill' wen dill' kob c̱he yeḻ' wṉabia' c̱he Chioza', na' biyone' yog' beṉ' che'i wde wdeli yillwe'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na' doxen gana' mbani Síriana' wze dill' daa chon Jesúza', na' jwa'gake' yog'ḻoḻ beṉ'ka' che'i wde wdeli yillwe', beṉ' chey chla, beṉ' yoo dii x̱iw', beṉ' chaz shoṉ, na' beṉ' net ṉi'a nee. Na' Jesúza' biyone' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na' beṉ' zan inlleb jano ḻe', beṉ'ka' lle' yellka' mbani Galileana' na' yellka' mbani Decápoliza', na' beṉ'ka' lle' yell Jerusalénna' na' yellka' sto mbani Judeana', na' beṉ'ka' lle' yellka' llia shḻaa yao Jordánna'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ka ble'i Jesúza' beṉ' zan ba nogake'ne', na'ch wyepe' to lo yaa, na' wchi'e. Na'ch beṉ'ka' nakgake'ne' txen jabig'gake' kwite'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Na' wzolo Jesúza' chli' chsedile' ḻegake', chi'e: ");
INSERT INTO zadNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Chakomba beṉ'ka' chakbe'gakile' chyalljgakile' gaklen Chioza' ḻegake', ḻa' ḻegaken' yillingake' yabana' gana' chṉabia' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Chakomba beṉ'ka' chbellyesh', ḻa' Chioza' yizoe' ḻegake' mbalaz. ");
INSERT INTO zadNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Chakomba beṉ'ka' nak beṉ' gax̱jlall', ḻa' wllin lla Chioza' wi'e ḻegake' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Chakomba beṉ'ka' chzelall' gakgake' beṉ' ḻi beṉ' shao', ḻa' Chioza' iṉe' nakgake' beṉ' wen lawe'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Chakomba beṉ'ka' chiyeshii beṉ', ḻa' ka'kzə yiyeshii Chioza' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Chakomba beṉ'ka' nxi nyech yic̱hjlall'do'eka', ḻa' ḻegaken' ile'gakile' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Chakomba beṉ'ka' chon to dii byen soalen ljwellgake' mbalaz, ḻa' iṉa beṉ' dii ḻikzan nakgake' xiiṉ Chios. ");
INSERT INTO zadNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Chakomba beṉ'ka' chiya dii chen chle'i daa chongake' ka cheeni Chioza', ḻa' ḻegaken' yillingake' gana' chṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Chakomba le' kat' chiya dii na beṉ' c̱hele na' chiya dii chongakile' le', na' kat'ka' chiyiljlall'gake' bittezə dill' wxiye' c̱hele daa chonḻilall'le nad'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ḻi yiba yizaki, ḻa' yabana' gaple to dii wen dii shao'. Ḻa' ka chongakile' le' ṉaa, ka'kzan bc̱hi' bsak'gake' kani'yi dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Len' nakle ka zedaa ladj beṉ' yell-lioki. Zedaa, shi bich zxi'n, aga wakch yiyonchon zxi' ni bich gak wc̱hinchon, na' chchooṉchon gana' wlej wshoshj beṉ' ḻen. ");
INSERT INTO zadNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Len' nakle ka to beeni' ladj beṉ' yell-lioki. To yell dii llia to lo yaa, zit'lə nḻa'n, na' bi ngashaan. ");
INSERT INTO zadNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ni biga zoa to beṉ' chxene' kandila' na' chdose'n to dii wkwashaan ḻen, san chzoe'n sibə kwenc̱he wzeeni'n doxen ḻoo yoona'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ka'kzan le', ḻi gon to dii byen gonle daa nak wen kwenc̱he ile'i beṉ' na' we'la'ogake' X̱acho Chioza' zoa yabana'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Bi gakzile bid' kwenc̱he yikwas' ley daa bzej dii Moisézan' wa daa bli' bsedi dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegaken'. Bi nakan ka', san bid' kwenc̱he yiyoll gak yog'ḻoḻ ka na leya' na' daa bli' bsedi beṉ'ka' wdix̱jee daa goll Chioza' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Dii ḻi nia' le', shlak biṉ' te c̱he yabana' len yell-lioni, bi init ni shc̱ho'a dill' daa nllia ley c̱he Chioza' bia' gak, ax̱t ki gakch yog'ḻoḻ daa bllie' bia' gak. ");
INSERT INTO zadNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Daan, nottezə beṉ' chyishje' to daa nllia Chioza' bia' goncho, ḻa'kzi dii bi llialotek, na' shi wliile' beṉ' yoblə gone' ka chone', bitek bi zakee yabana' gana' chṉabia' Chioza'. San beena' gon daa nllia Chioza' bia' goncho na' wliile' beṉ' yoblə gone'n, beenan' gake' to beṉ' zakii yabana' gana' chṉabia' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Na' nia' le', aga wak yillinle gana' zoa Chioza' chṉabi'e shi toz ka chonlenle fariseoka' na' beṉ'ka' chli' chsedi leya', chiyaḻ' wzenagchle c̱he Chioza' aga ka ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Na' ḻekzka' che' Jesúza' ḻegake': ―Ṉezkzile goll dii Moiséza' dii x̱ozxto'choka': “Bi chiyaḻ' wito' beṉ'. Ḻa' beena' wit to beṉ' chiyaḻ' guete' daa bene' ka'.” ");
INSERT INTO zadNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Per nad' nia' le', nottez beena' chllee bish' ljwelle'na' chidoḻee tie' lo yeḻ' zak'zi'na'. Na' ḻekzka' beena' chzoazi'yee bish' ljwelle'na', beṉ'ka' chṉabia' chiyaḻ' wwiagake' nak gongake' c̱he'; na' beena' chṉie' bish' ljwelle'na' dill' zibia', chidoḻee wzaḻ' Chioza' ḻe' lo yi' gabiḻa'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Daan, shi ka zjoo daa chzanilo' wi'o Chioza' na' ka illino' gana' chzeygake'n lljadinilo' ngoolall' to bish' ljwello'na' li', ");
INSERT INTO zadNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","na'z bkwaaṉ daa nox̱oo, zigaate chiyaḻ' lljaye'xeno' bish' ljwello'na', na'tech wak wi'o Chioza' daa chzanilo' wi'one'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Shi no cheeni lljtao xya c̱ho' lao josc̱hiska', ben byen yiyoe'xeno'ne' shlak ni de xḻatjin. Ḻa' shi ba bllino' lao beena' wc̱hogbia' c̱ho', na' gone' li' lo na' beena' wseje' li' lillyana'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Dii ḻi nia' li', aga wibeje' li' lillyana' ax̱t ki c̱hixjo' doxen daa chiyaḻ' c̱hixjo'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ṉezkzile wna dii Moiséza': “Bi chiyaḻ' iṉeleno' nool bi nak nool c̱ho'.” ");
INSERT INTO zadNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","San nad' nia' le', nottez beena' chwia to noolə na' chza'lalleene' ḻoo yic̱hjlall'do'ena', daa chone' ka' ba benkze' ka chon beena' zoate xoole'na' na' chṉelene' nool yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Shi jalawo' de shḻina' chonan ka gono' dii mala', naklan wen wtoḻjo'n na' c̱hooṉo'n. Ḻa' wenchan soa tḻaaz jalawo'na' aga ka daa yiyaj doxentio' lo yi' gabiḻa'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na' shi noo de shḻina' chonan ka gono' dii mala', naklan wen wc̱hogo'n na' c̱hooṉo'n, ḻa' wenchan soa tḻaaz noona' aga ka daa yiyaj doxentio' lo yi' gabiḻa'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Ṉezkzile wna dii Moiséza': “Nottez beena' yiḻaa nool c̱he'na' chiyaḻ' c̱has to yish we'n dill' nan bilaagake'.” ");
INSERT INTO zadNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","San nad' nia' le' shi to beṉ' byo yiḻee xoole'na' ḻa'kzi xoole'na' bi chṉelene' beṉ' yoblə, daa yiḻeene' chone' ka yikaa noola' beṉ' yoblə na' gake' ka to noolə zoalentie' beṉ' c̱he'na' na' chṉelene' beṉ' yoblə. Na' beena' yikee noola' nḻaa beṉ' c̱he'na', ḻekzka' chone' ka chon beena' chṉelen xool beṉ' yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ḻekzka' ṉezkzile golle' dii x̱ozxto'leka': “Bi wkwaaṉzo' ka'zə daa ba bc̱hebo' lao X̱ancho Chioza' shi bzoatio' bi bzo' de tasc̱hiw.” ");
INSERT INTO zadNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","San nad' nia' le', bibi wzoale de tasc̱hiw kat' wc̱heble lao Chioza'. Bi wzoazle yabana' de tasc̱hiw, ḻa' yabana' nakan gana' zoa Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Na' ni bi wzoale yell-lioni de tasc̱hiw, ḻa' nakan ka gana' nzoa ṉi'a Chioza'; na' ni Jerusalénna', ḻa' ḻennan' yell c̱he beena' chṉabia' doxen. ");
INSERT INTO zadNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na' ni bi wzoazle yic̱hjlena' de tasc̱hiw, ḻa' aga wak gonle ka yiyak ni to yish' yic̱hjlena' yish' bez' shi nakan dii gasj wa gonle ka yiyakan dii gasj shi nakan yish' bez'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","San kon iṉale “wakan” wa iṉale “bi gakan”, ḻa' shi chzoale de tasc̱hiw bichlə wa nochlə, dii malan' chonan chonle ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ḻekzka' ṉezkzile' wna dii Moiséza': “Shi to beṉ' wshoshje' tḻaa jalawo'na' ḻekzka' yiyono' c̱he'. Na' shi to beṉ' wx̱ope' ḻeyo'na', ḻekzka' yix̱opo' ḻeye'na'.” ");
INSERT INTO zadNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","San nad' nia' le': Bi yizi'o wzon c̱he beṉ' mala'. Shi no kap' x̱agoona' tḻaa, bi'e daa zi shḻaa. ");
INSERT INTO zadNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Shi to beṉ' chbagoo dii chbagoo c̱he' na' cheenile' ikee xkamiso'na', be'shaze' lente daa nx̱oa kolloona'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Na' shi to beṉ' wwee li' yoa' c̱he'na' na' gone' byen woon to kilómetro, wza'lentegan c̱hop kilómetro. ");
INSERT INTO zadNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Na' nottezə beṉ' shi bi iṉabe' c̱ho', be'n. Na' shi no iṉabi li' wi'one' shloll bi de c̱ho', bi wllonilo'ne'n. ");
INSERT INTO zadNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Na' ḻekzka' ṉezile wnagake': “Goki bish' ljwello'na' na' bwiyi beṉ'ka' chakzi' chakzbangakile' li'.” ");
INSERT INTO zadNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","San nad' nia' le': Ḻi gaki beṉ'ka' chakzbangakile' le', ḻi iṉabi Chioza' gak wen c̱he beṉ'ka' chsak'zi'gake' le'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Shi gonle ka', na'ch iṉezi beṉ' nakle xiiṉ X̱acho Chioza', beena' zoa yabana'. Ḻa' ḻe' chone' ka chla' wbilla' lao beṉ' mal na' lao beṉ' wen, na' chone' ka chak yeja' lao beṉ' chon wen na' lao beṉ' chon mal. ");
INSERT INTO zadNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Na' shi to beṉ'ka' nllagzile chakile, aga bi zjanayin, ḻa' ka'klen chon beṉ' wic̱hixjka' beṉ'ka' chakile ḻe beṉ' mal nakgake'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na' shi to beṉ'ka' nllagzile chwaple chiox, ¿garan de dii wenna' chonle? Ḻa' ka'klen chon beṉ'ka' bi nombia'gake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ḻi gak dowalj beṉ' ḻi beṉ' shao' ka nak X̱acho Chioza' zoa yabana', nake' dowalj beṉ' ḻi beṉ' shao'. ");
INSERT INTO zadNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Bi wli' wzez c̱hele ladj beṉ' nan nakle beṉ' wen. Ḻa' shi kwenc̱hezə ile'i beṉaan chonle daa nak wen, bibi laxjle goṉ X̱acho Chioza', beena' zoa yabana'. ");
INSERT INTO zadNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Na' kat' chaklenle beṉ'ka' chyallj chc̱hini, bi wzelen dill', ka chon beṉ' wxiye'ka' gana' chdop chllagcho choe'ḻwillcho Chioza', wa do yawi nez. Choe'gake' dill' c̱he daa chongake' kwenc̱he we'la'o beṉ' ḻegake'. Dii ḻi nia' le', daa choe'la'o beṉ' ḻegake', ḻennan' laxje'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","San le', kat' choe'le beṉ' bi dii choe'lene', bi gonlen ka ile'i beṉ'. Na' ni to beṉ' bi ye'lene' bin chonle. ");
INSERT INTO zadNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","San ḻi gaklen beṉ' ka kono gakbe'i. Na' X̱achona', beena' chen chle'i daa chonle, goṉe' laxjle. ");
INSERT INTO zadNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Na' kat' choe'ḻwill-le Chioza', bi gonle ka beṉ' wxiye'ka'. Ḻegake' choolall'gake' sechagake' we'ḻwillgake' Chioza' gana' chdop chllagcho choe'ḻwillchone' wa ga lle' lla' beṉ' kwenc̱he ile'gakile' ka chongake'. Dii ḻi nia' le', daa chle'i beṉ' ka chongake', ḻezannan' laxje'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","San le', kat' we'ḻwill-le Chioza', ḻi yiyoo ḻoo lill-lena' na' ḻi wsej puerta', na' ḻi we'ḻwill X̱achona', beena' kono chle'i. Na'ch X̱achona', beena' chen chle'i daa chonle, goṉe' laxjle. ");
INSERT INTO zadNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Na' kat' choe'ḻwill-le Chioza' aga ḻiḻezi dill'ka' iṉale ka chon beṉ'ka' bi nombia'gake'ne', ḻa' chakgakile' daa choe'gake' dill' zan na' wzenague' bin che'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bi gonle ka chongake', ḻa' X̱acho Chioza' ba ṉezkzile' bi daa chyalljile ka zi' iṉabləlen. ");
INSERT INTO zadNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kat' we'ḻwill-le Chioza', kin iṉale: X̱anto' Chios, beṉ' zoa yaba, we'la'oshga yog'ḻoḻ beṉ' li'. ");
INSERT INTO zadNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na' iṉabia'gacho' ḻoo yic̱hjlall'do' yog'ḻoḻ beṉ', kwenc̱he gak lo yell-lioni ka chaklalloo, ka chak yabana'. ");
INSERT INTO zadNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ka nak daa choṉo' cheej chaonto' yog' lla, beṉgachan ṉaanlla. ");
INSERT INTO zadNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Wxi'xen c̱hento', ka chon neto' chzi'xennto' bittezə dii choni beṉ' neto'. ");
INSERT INTO zadNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bi we'gacho' latj ibix̱nto' gonnto' daa bi nak wen, san bislagach neto' lo ṉi'a na' dii mala'. Ḻa' lin' napo' yeḻ' wṉabia', na' yeḻ' wak, na' lin' chidoḻoo shoo balaaṉ xen zejḻi kaṉi. Kan' nakan. ");
INSERT INTO zadNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Ḻa' shi le' chzi'xenle c̱he beṉ' shi bi chongakile' le', ka'kzə X̱acho Chioza' zoa yabana' si'xene' c̱hele. ");
INSERT INTO zadNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","San shi le' bi chzi'xen c̱he ljwell-le, ka'kzə Chioza', beena' nak X̱ale, bi si'xene' dii malka' chonle. ");
INSERT INTO zadNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Kat' zoale wbas', bi gonzle cho'alaolena' nyesh' ka chon beṉ' wxiye'ka', ḻa' ḻegake' chon cho'alawe'ka' nyesh' kwenc̱he gakbe'i beṉ' bi neej naogake'. Dii ḻi nia' le', daa gakbe'i beṉ' daa chongake', ḻezannan' laxje'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","San le', kat' soale wbas', ḻi wpaa yic̱hjlena' na' ḻi c̱hib ḻi wx̱is cho'alaolena' ");
INSERT INTO zadNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kwenc̱he bi gakbe'i beṉ' nan zoale wbas'. San toz X̱acho Chioza', beena' kono chle'i, ile'ile' daa chonle na' goṉe' laxjle. ");
INSERT INTO zadNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Bi wtop wshagle yeḻ' wni'ana' yell-lioni, ḻa' baḻ diika' chaljan baka' chlliayi'gakban, na' baḻan chibia leyin na' chbiayi'gakan, wa choo wbanka' na' chkaagake'n. ");
INSERT INTO zadNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","San ḻi gon ka gat' yeḻ' shao' c̱hele yabana', ḻa' daa de yabana' bi galjan bado' wlliayi'ban, ni bi yibia leyin, ni bi gak sho' wbanna' ikeen. ");
INSERT INTO zadNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ḻa' gana' de yeḻ' shao' c̱helena', na'kzan se yic̱hjlall'do'lena' wṉeyi. ");
INSERT INTO zadNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Jalaochoki nakgakan beeni' c̱he kwerp c̱hechoni. Shi jalaochoki chle'gakin kwasḻoḻ, doxen kwerp c̱hechoni zoan lo beeni'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Per shi bi chle'i jalaochoki, kwerp c̱hechoni zoan lo yel c̱hoḻa'. Ka'kzan chak c̱he yic̱hjlall'do'choni. Shi bi chzenagcho c̱he Chioza', nc̱hoḻi yic̱hjlall'do'choni. ");
INSERT INTO zadNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Aga ga zoa to beṉ' wḻane' xshin c̱hop beṉ', ḻa' wakzbanile' beena' to, na' gakchile' beena' sto, wa gone' xshin beena' to do yic̱hj do lallee na' xshin beena' sto gone'n do ki do lallee. Na' ka'kzan chak c̱hecho len Chioza', aga wak goncho ka cheenile' shi we'techo latj iṉabia' yeḻ' wni'ana' cho'. ");
INSERT INTO zadNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Daan nia' le': Bitek kwek yic̱hjle daa yeej gaole kwenc̱he ibanle, ni xalaanle. Ḻa' zak'techlə yeḻ' mban c̱hechona' aga ka daa cheej chaocho, na' zak'tech kwerp c̱hechona' aga ka xalaanchona'. ");
INSERT INTO zadNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ḻi wwiakachi byiṉdo'ka' chda xan yabana', ḻa'kzi bi chaz chaaṉgakb na' bibi chizi' chilapgakb, ni bi zoa ga chgooshao'gakb dii gaogakb, len chweej chwaokz X̱acho Chioza' zoa yabana' ḻegakb. ¿Alechlin le', zak'techle aga ka bado'ka' ze lo llazə? ");
INSERT INTO zadNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Na' ni tole bi gak yisc̱hooch yeḻ' mban c̱helena' zi shloll ḻa'kzi nall inlleb zele wṉeyi c̱heyin. ");
INSERT INTO zadNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Na' ¿bic̱he chi' yic̱hjzle xalaanlena'? Wwiakachile ka chgol yejdo'ka' ze lyix̱aa, len aga bi llin chongakan ni bi choḻgakan do. ");
INSERT INTO zadNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Per nia' le', ni dii Salomónna', beena' wdapchga yeḻ' shao'ka', bi bllin gak xe'na' xochi ka yejdo'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Na' shi Chioza' none' yejdo'ka' ze lyix̱aa xochi, ḻa'kzi nakan de toldezə na'tech chtop beṉ' ḻen na' chzeye'n, ¿alechla le', gontechle' wen c̱hele goṉe' xalaanle ḻa'kzi bitek chajḻe'le gaklene' le'? ");
INSERT INTO zadNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Na' bi kwek yic̱hjzle iṉazle: “¿Bin yeej gaocho?” wa “¿Nak goncho gat' xalaancho?” ");
INSERT INTO zadNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ḻa' beṉ'ka' bi nonḻilall'gake' Chioza' to daazə chi' yic̱hjgake'. Per X̱achona', beena' zoa yabana', ṉezkzile' chyalljile yog' diiki. ");
INSERT INTO zadNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Na' daa llialote chiyaḻ' wzenagle c̱he Chioza' kwenc̱he iṉabi'e le', na' gonle kon daa cheenile', na' goṉkze' yog' daa chyalljile. ");
INSERT INTO zadNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bitek kwek yic̱hjle shi wyaj wdele llaka' zi za' ḻa' to to lla nsa' dii zed c̱heyin. ");
INSERT INTO zadNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Bi yiya yiyiljle beṉ', kwenc̱he bi yiya yiyilj Chioza' le'. ");
INSERT INTO zadNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ḻa' kon ka chiya chiyiljle beṉ', ka'kzan yiya yiyilj Chioza' le', na' kon ka gonile beṉ', ka'kzan goni Chioza' le'. ");
INSERT INTO zadNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Bic̱he chwiazo' bic̱ha' yoo ḻoo jalao bish' ljwello'na' na' bi chile'ilo' kwagaa yoo ḻoo jalawo'na'? ");
INSERT INTO zadNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Shi bi chle'ilo' kwagaa yoo ḻoo jalawo'na', ¿nakra gono' yoo bish' ljwello'na': “Beṉshki yibej' bic̱ha' yoo ḻoo jalawo'na'”? ");
INSERT INTO zadNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Beṉ' wxiye'! Zigaate bwia c̱ho'na' na'tech wwio' c̱he bish' ljwello'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Na' bi gonzle byen we'lenle xtill' Chioza' beṉ'ka' bi chazlall'gake'n, kwenc̱he ki gongakile' le' zṉia ka chon bekw'ka' chxoxj chtingakb kat' no chonḻegakib. Ni bi we'lenle xtill' Chioza' beṉ'ka' bi cheengakile' wzenaggake'n kwenc̱he ki wlej wshoshjgake' dillaa ka chon kushka' chlej chshoshjgakb daa bi choolall'gakb gaogakb. ");
INSERT INTO zadNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Ḻi iṉabi Chioza' bin cheenile na' goṉe'n. Ḻi yiyilj daa cheenile na' yillelilen. Ḻi iṉe cho'a puerta', na' wsalje'n. ");
INSERT INTO zadNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ḻa' beena' chṉabile' beṉ' daa cheenile', we'kze'n; na' beena' chiyilje' daa cheenile', willelkzile'n; na' beena' chṉe cho'a puerta', wsaljkzgake' sho'e. ");
INSERT INTO zadNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Le' zoa xiiṉle, shi iṉabib' le' to yetxtil aga we'leb' to yaj. ");
INSERT INTO zadNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Wa shi iṉabib' le' to beḻ yaa, aga we'leb' to beḻ zṉia. ");
INSERT INTO zadNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Shi le' naktele beṉ' mal chak we'le xiiṉleka' daa nak dii wen, ¿alechli X̱acho Chioza' zoa yabana' ki goṉe' le' dii wen dii shawaa shi iṉabilene'n? ");
INSERT INTO zadNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Kon ka cheenile goni beṉ' le', ka'kzan chiyaḻ' gonilene', ḻa' kan' na leya' na' librka' bzej dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Ḻi gon byen sho'le cho'a puerta' daa nshop'. Ḻa' nḻag' puerta' na' zlag' nak neza' daa zej gana' chbiayi' beṉ', na' beṉ' zan choogake'n. ");
INSERT INTO zadNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Per ka nak neza' daa zej yabana' gana' lljazoalencho Chioza', nakan to nez les, na' to c̱hopchga beṉ' chillelgakile'n. ");
INSERT INTO zadNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Ḻi wsak' kwenc̱he bi shajḻe'le c̱he beṉ'ka' chonz ka chyix̱jee daa che' Chioza' ḻegake', na' chonz kwingake' beṉ' wen beṉ' gax̱jlall', per beṉ' malzgakan na' chlliayi'gake' beṉ', ka chon to ba zṉia. ");
INSERT INTO zadNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ka ile'ile ka nsa' c̱hegake' na' gakbe'ile non nakgake'. Ḻa' ṉezkzile aga wishibcho uvana' to lo yag yesh' na' ḻekzka' aga wishibcho yix̱wewa' to lo yag yesh' yaa. ");
INSERT INTO zadNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ka'kzan yag wenna' chbian dii wen, na' yaga' daa bi nak wen chbian dii bi nak wen. ");
INSERT INTO zadNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ḻa' yaga' daa nak dii wen aga wbian dii bi nak wen, na' yaga' daa bi nak dii wen aga wbian dii nak wen. ");
INSERT INTO zadNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yog' yag dii chbia dii bi nak wen, chc̱hoggake'n na' chzeygake'n. ");
INSERT INTO zadNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Daan, wakbe'kzile ka nsa' c̱he beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Aga yog' beṉ'ka' na nad': “X̱an', X̱an'”, yillingake' yabana' gana' chṉabia' Chioza', ḻete beṉ'ka' chongake' ka cheeni X̱a' Chioza', beena' zoa yabana'. ");
INSERT INTO zadNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kat'ka' illin llana' yizia' kwent c̱he ben', zangake' iṉagake' nad': “X̱an', X̱an', neto' wdix̱jeento' daa wno', na' kon yeḻ' wak c̱ho'na' bibejnto' dii x̱iw'ka' yoo beṉ' na' bennto' dii zan yeḻ' wak.” ");
INSERT INTO zadNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Na'ch yepgakee: “Biga bembi'a le'. Ḻi kwas ka'lə, le' beṉ' wen dii mal.” ");
INSERT INTO zadNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Daan, nottez beena' chzenag cho'a xtillaani na' chone' ka nia', nake' ka to beṉ' sin', beena' ben lille'na' to lo yaj. ");
INSERT INTO zadNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na' ka gok yejsiwaa, bgol yaoka', na' wzechga be'na' nan wllig'gakan yoona', per bi billeen daa chi'cha leninna' lo yaja'. ");
INSERT INTO zadNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Per beena' cheni cho'a xtillaani na' bi chone' ka nia', nake' ka beena' bi chajnii, beena' bx̱e lille'na' lo yoxa'. ");
INSERT INTO zadNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na' ka gok yejsiwaa, bgol yaoka', na' wzechga be'na' na' bllig'gakan yoona' na' wlliayi'tekzan. ");
INSERT INTO zadNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Na' ka biyoll be' Jesúza' dillii, bibani beṉ'ka' ka chli' chsedile', ");
INSERT INTO zadNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","daa bli' bsedile' ḻegake' ḻega beṉ' za'len yeḻ' wṉabia', aga ka chli' chsedi beṉ'ka' chzajnii ḻegake' leya'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Na' ka biyetj Jesúza' lo yaana', beṉ' zan zinogake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na' kwite'na' bllin to beṉ' che'ile' lepra', na'ch bc̱hek' xibe' lawe'na', chi'ene': ―X̱an', ṉezid' wak yikwaso' yillwe'ni chak' sheḻ' gueenilo'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Na'ch Jesúza' bx̱oa neena' yic̱hje'na', chi'ene': ―Cheenid'x. Na' ṉaate yikwasa'n. Na' kon ka golle' ka', lii biyakteyi beena'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Na'ch che' Jesúza'ne': ―Ni to kono yoo ka nak daa ba ben' c̱ho'. Ḻete wyaj lao bx̱oza' kwenc̱he ile'ile' ba biyakilo', na' jwa' daa chiyaḻ' lljoo lao Chioza' ka nllia dii Moiséza' bia' goncho kwenc̱he iṉezi beṉ' ba biyakilo'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ka billin Jesúza' yell Capernaúma' lii bllinte to x̱an soldad lawe'na', na' got'yoile'ne', ");
INSERT INTO zadNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","chi'ene': ―X̱an', xmosaa die' lillaa, na' net tḻaa kwerp c̱he'na' na' ḻe chey chle'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Na'ch che' Jesúza'ne': ―Na' sa' yiyonee. ");
INSERT INTO zadNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Na' che' x̱an soldadka'ne': ―X̱an', aga zakii nad' kwenc̱he shoo ḻoo yoo lillaa. Kon ben mandad yiyakile' na' wiyakkzile'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nia' ka' ḻa' zoa beṉ' chṉabia' nad', na' nad' ḻekzka' chṉabia' soldad c̱ha'ka'. Kat' chep' toe': “Wyaj ni'”, na' chaje'; na' kat' chep' stoe': “Da ni”, na' chide'; na' kat' chizep' xmosaa: “Ben dga”, na' chone'n. ");
INSERT INTO zadNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ka beni Jesúza' cho'a xtilleena', bibanile' na' chi'e beṉ'ka' nogake' ḻe': ―Dii ḻi nia' le', bigaṉ' lljtia' to beṉ' Israel beṉ' gonḻilallee nad' ka chonḻilall' beeni nad'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na' nad' nia' le', beṉ' zan beṉ' zaak doxen yell-lioni gonḻilall'gake' nad' na' lljazoalengake' txen dii Abrahama', dii Isaaca' na' dii Jacoba' yabana' gana' chṉabia' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Na' ka nak beṉ'ka' wlej Chioza' nan lljazoagake' gana' chṉabi'e, zane' wzaḻee gana' shgasj shc̱hoḻ, gana' kwellyesh'gake' na' gaoyaax̱ax̱j ḻeye'ka' daa ḻe gakshejlall'gake', daa bi goongakile' iṉabi'e ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Na'ch che' Jesúza' x̱an soldadka': ―Biyaj lillo'na', na' gak ka cheenilo' daa chajḻi'o c̱ha'. Na' lo lla lo gorzə biyaki xmose'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Na'ch wyaj Jesúza' lill Pédrona', na' ble'ile' de tobiiṉ c̱he'na' yo'e dii ḻana'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Na' bex̱' Jesúza' neena' na' bicheje' dii ḻana'. Na' lii wyastie' bene' dii wdaogake'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na'ch ka ba chxoa wbilla', jwa'gake' beṉ' zan gana' zoa Jesúza', beṉ' yoo dii x̱iw'ka', na' shcho'azə dillaa bi'e bichejgakan. Na' ḻekzka' biyone' yog' beṉ' bi shao'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Gok ka' kwenc̱he gok ka wna dii Isaíaza', beena' wdix̱jee daa goll Chioza'ne', daa wne': “Ḻe' bikee yillwe'ka' che'icho na' bene' ka bigaa yeḻ' chey chla c̱hechona'.” ");
INSERT INTO zadNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na' ka ble'i Jesúza' beṉ' zan inlleb ba nec̱hjgake'ne', bene' mandad telene' beṉ'ka' nakgake'ne' txen shḻaa nisdo'na'lə. ");
INSERT INTO zadNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na' wbig' to beṉ' chli' chsedi leya', chi'ene': ―Maestro, cheenid' sa'len' li' gattezə shajo'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Na'ch che' Jesúza'ne': ―Bez'ka' nongakb yech ga chiyoogakb, na' byiṉdo'ka' non lilldo'gakb, san nad', Beṉ' Bseḻ' Chioza' Yell-lioni, bibi lill' de. ");
INSERT INTO zadNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na' bchej sto beṉ' nake' Jesúza' txen na' chi'ene': ―X̱an', wza'len' li' gattezə shajo' ka yiyoll guet x̱a'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Na'ch goll Jesúza'ne': ―Da, dino nad'. Wikwash'kzə ljwell beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Na'ch wyoo Jesúza' ḻoo barkwa' len beṉ'ka' ba nakgake'ne' txen. ");
INSERT INTO zadNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na' shlak zej barkwa' wtese'. Na' wzolo wzechga be'na' lo nisdo'na', na' wzolo chas chataan na' biyoll nisa' ḻoo barkwa'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na'ch beṉ'ka' nak Jesúza' txen jasbangake'ne', na' che'gake': ―¡X̱an', bisla cho'! ¡Ba chbe'cho yel! ");
INSERT INTO zadNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Na'ch che' Jesúza': ―¿Berac̱he chlleblikzle? ¿Bic̱he bi nx̱enilall'le nad' kwasḻoḻ? Na'ch wyase' bsheshlene' be'na' len nisdo'na', na' wlezgakan. ");
INSERT INTO zadNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Na' beṉ'ka' lle'len Jesúza' ḻoo barkwa' bibangakile' ka bene', na'ch che' ljwellgake': ―¿Noran nak beeni, lla? Ax̱t be'na' na' nisdo'na' chzenaggakan c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Na' ka bllin Jesúza' yell-liona' mbani Gadárana' daa llia shḻaa nisdo'na', c̱hop beṉ' yoogake' dii x̱iw'ka' bchejgake' ḻoo kapsanta' jatiḻgake'ne'. Na' daa ḻe zṉiagake' aga no chak te lo neza' chde gana' zoagake'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Na' besyaagakan che'gakan Jesúza': ―¿Bic̱he za'zo' gani zoanto', Jesús, Xiiṉ Chios? ¿Aba za'zelo' zidsak'zi'o neto' ḻa'kzi biṉ' illin lla sak'zi'nto'? ");
INSERT INTO zadNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na' gaoz lle' ba zan kush chaogakb. ");
INSERT INTO zadNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Na'ch got'yoi dii x̱iw'ka' Jesúza', che'gakan ḻe': ―Shi yibejo' neto' ḻoo yic̱hjlall'do' beṉ'ki, we'gacho' latj yiyoonto' kushka'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Na'ch goll Jesúza' ḻegakan: ―Wakkzan. Ḻi yiyoo shka'. Na'ch bichej dii x̱iw'ka' na' biyoogakan kushka', na' kushka' lii bxoṉjtegakb na' jabix̱gakb to cho'a yaa na' bxoptegakb ḻoo nisdo'na' na' wche'gakb yel. ");
INSERT INTO zadNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na'ch beṉ'ka' chap kushka' bixoṉjdogake', na' ka billingake' lalle'ka' gollgake' beṉ' yellka' doxen ka gok c̱he beṉ'ka' yoo dii x̱iw'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Na'ch wza' yog' beṉ' yellka' zjatiḻgake' Jesúza', na' ka ble'gakile'ne' got'yogakile'ne' yiyaje' gan yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Na' biyoo Jesúza' to ḻoo barkw, na'ch biḻag'gake' shḻaa nisdo'na' na' billine' yell c̱he'na' gana' wzee. ");
INSERT INTO zadNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na' bllinlengake' to beṉ' net ṉi'a neena' lawe'na', nx̱oagake'ne' to lo daa. Na' gokbe'i Jesúza' ḻe nonḻilall'gake'ne', na'ch golle' beṉ' we'na': ―Btiplalloo, xiiṉ', ba biyakxen xtoḻoona'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na'ch baḻ beṉ'ka' chli' chsedi leya' che' ljwellgake': “Ba chonz kwin beeni ka Chioza' daa ne' ka'.” ");
INSERT INTO zadNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Na' gokbe'i Jesúza' daa wza'lall'gake', na' chi'e ḻegake': ―¿Bic̱he chza'lall'zle ka'? ");
INSERT INTO zadNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Achakile chyalljchid' yeḻ' wak xench yep' beeni: “Ba bizi'xen' saaxya c̱ho'na'”, ka daa yepee: “Biyas na' bigoo nez”? ");
INSERT INTO zadNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Na' wliid' le', nad', Beṉ' Bseḻ' Chioza', nap' yeḻ' wṉabia' yell-lioni kwenc̱he yizi'xen' saaxya c̱he beṉ'. Na'ch golle' beena' net ṉi'a neena': ―Biyas, bitob daa c̱ho'na', na' biyaj lillo'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Na'ch biyas beena' net ṉi'a neena' na' ziyaje' lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Na' ka ble'i beṉ'ka' ka gok, bibangakile', na' be'la'ogake' Chioza' daa bi'e yeḻ' wak xenna' to beṉ' yell-lio. ");
INSERT INTO zadNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ka biza' Jesúza' na', ble'ile' to beṉ' wic̱hixj, lie' Mateo, chi'e gana' chc̱hixje'. Na' chi'ene': ―Da, dino nad'. Na'ch lii wzolla'te Matewa' janoe'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na' shlak chi' Jesúza' lill Matewa', bllin beṉ' zan wic̱hixjka' na' zan beṉ' zeyi c̱heyi bi nsa' c̱hegake' wen, wche'gake' cho'a mesa' wdaolengake' Jesúza' len beṉ'ka' nakgake'ne' txen. ");
INSERT INTO zadNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Na'ch ka ble'i fariseoka' chaolen Jesúza' beṉ'ka', na'ch wṉabgakile' beṉ'ka' nakgake'ne' txen, che'gake': ―¿Bic̱he chaolenz maestro c̱heleni beṉ' wic̱hixjki len beṉ'ki bi nsa' c̱heyin wen? ");
INSERT INTO zadNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Na' beni Jesúza' daa goll fariseoka', na'ch chi'e ḻegake': ―Aga beṉ'ka' shawaan chyalljgakile' wen rmecha' san beṉ'ka' bi shawaan chyalljgakile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ḻi yiyaj na' ḻi lljased bin zeji Cho'a Xtill' Chioza' gana' nan: “Nad' cheenchid' yiyeshii ljwell-le, aga ka daa witle bayix̱'ka' kwenc̱he we'la'ole nad'.” Aga bid' ni c̱he beṉ'ka' nak beṉ' ḻi beṉ' shao', san bid' ni c̱he beṉ' saaxyaka'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Na'ch beṉ'ka' nak Juanna' txen jabig'gake' kwit Jesúza' na' wṉabgakile'ne' che'gake': ―Neto' na' fariseoka' zeyi c̱hento' chzoanto' wbas'. Na' ¿bic̱he beṉ'ka' nakgake' li' txen bi chzoagake' wbas'? ");
INSERT INTO zadNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Na'ch che' Jesúza' ḻegake': ―Kat' chak to wishagna' beṉ'ka' chdi'a chllag lill beṉ' byona' aga chdagake' nyesh', san cheej chaogake'. Na' ka'kzan beṉ'ki nakgake' nad' txen, cheej chaogake' ṉaa zoalen' ḻegake', per wllin lla wkwas beṉ' nad' kwite'ka', kana'chan soagake' wbasaa. ");
INSERT INTO zadNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Ni to kono chida' lat' lech' kob ḻee lech' gola', ḻa' kat' shechan na' yibe' lech' koba' na' wsho'chan dii gola' na' gana' nllo' gakchan dii xench. ");
INSERT INTO zadNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na' aga no chgaa vino daa zi' bchejte ḻoo yid gola', ḻa' wchez' yid gola' na' ḻaljə vinona', na' ka vinona' ka yida' kwiayi'gakan. San chiyaḻ' sholl vino daa zi' bchejte ḻoo yid koba' kwenc̱he ni ton bi kwiayi'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Na' ni choe'te Jesúza' dill', ka bllin to beṉ' wṉabia' na' bc̱hek' xibe'na' lao Jesúza', chi'ene': ―Shintg wit to bi' nool c̱ha'; per shi li' sa'gacho' na' wx̱oa noona'b' na' yibam'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Na'ch lii wzolla'te Jesúza' zejlene' beṉ'ka' nakgake'ne' txen lill beṉ' wṉabia'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na' ka zejgake' lill beṉ' wṉabia'na' jano to noolə ḻegake', na' ba gok shlliṉ yiz chzoe' wbaa. Na'ch wbiguee koll' Jesúza' bex̱ee xe'na', ");
INSERT INTO zadNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ḻa' chakile': “Kon sheḻ' ba bex̱aa xe'na' wiyakkzid'.” ");
INSERT INTO zadNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Na' biyec̱hj Jesúza' na' ka ble'ile' noola' chi'ene': ―Btiplalloo, xiiṉ', ba biyakilo' daa chonḻilalloo nad'. Na' lii biyakteyi noola'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na' ka bllin Jesúza' lill beṉ' wṉabia'na' ba lle' beṉ'ka' chkwell blleja' na' beṉ' zan ba chosyaagake' chbellgake'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Na'ch che' Jesúza' beṉ'ka': ―Ḻi yillesh ni. Aga witba'n san cheszbaan. Per bxill-ligake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Na' ben Jesúza' byen billeshgake', na' wyo'e na' bex̱ee na' bi' nool weta' na' lii biyasteb'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na' yog' yellka' llia gaoz wze dill' daa bene'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Na' ka biza' Jesúza', c̱hop beṉ' lc̱hoḻ janogake'ne'. Na' chosyaagake' zilljə che'gake': ―¡Biyesh'lall'gachi neto', xiiṉ dia c̱he dii Daví! ");
INSERT INTO zadNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ka biyoo Jesúza' ḻoo yoona', beṉ' lc̱hoḻka' jabig'gake' kwite'na'. Na'ch che' Jesúza' ḻegake': ―¿Achajḻe'le wak gon' ka ile'ile? Na'ch goll beṉ' lc̱hoḻka'ne': ―Awe, X̱annto', wak gono' ka ile'into'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Na'ch bex̱' Jesúza' jalawe'ka' na' golle' ḻegake': ―Daa chonḻilall'le nad' na' gak ka cheenile. ");
INSERT INTO zadNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na'ch bile'gakile'. Na' Jesúza' golle' ḻegake': ―Ḻi gon byen kono ye'le ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Per ka biza'gake' kwite'na' lii wzolotegake' choe'gake' dill' doxen gana' mbani yella' daa ben Jesúza' c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Shlak chiza' beṉ'ka' gok beṉ' lc̱hoḻ, bllin beṉ' yoblə lao Jesúza' nc̱he'gake' to beṉ' bi chak iṉe daa yo'e dii x̱iwaa. ");
INSERT INTO zadNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Na' kon ka bibej Jesúza' dii x̱iwaa yoo beena' na' biṉie'. Na' bibani beṉ'ka' lle' na', nagake': ―Ni shlin biṉ' ile'icho yell Israeli to yeḻ' wak ka dga ba ben beeni. ");
INSERT INTO zadNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Per fariseoka' che'gake': ―Beeni chibeje' dii x̱iw'ka' kon yeḻ' wak c̱he daa chṉabia' ḻegakan. ");
INSERT INTO zadNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Na' wda Jesúza' yog' yellka', ka yell xen ka yelldo', chli' chsedile' to to gana' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza'. Wdix̱je'ile' ḻegake' dill' wen dill' kob c̱he yeḻ' wṉabia' c̱he Chioza' na' biyone' beṉ' che'i bittezə yillwe'. ");
INSERT INTO zadNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Na' ble'i Jesúza' beṉ' zan zejlengake'ne' na' biyeshile' ḻegake', ḻa' gokbe'ile' ka nyesh'lazan chak c̱hegake', ka xil' ba kono x̱anin zoa. ");
INSERT INTO zadNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Na'ch golle' beṉ'ka' nakgake'ne' txen: ―Dii ḻi nia' le', beṉ'ka' zi' gonḻilall'gake' Chioza' zaklebgakile' to dii wlliachga to lo yell-lio, na' chyallj no yizi' yilapan, per to c̱hopchga wen llinka' zoa. ");
INSERT INTO zadNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Na' ḻi iṉabi X̱ancho Chioza' wzanche' beṉ'ka' wtopgake' beṉ'ka' gonḻilall'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na'ch biti'a Jesúza' beṉ'ka' shlliṉ wleje' na' bi'e ḻegake' yeḻ' wṉabia' kwenc̱he gak yibejgake' dii x̱iw'ka' yoo beṉ', na' yiyongake' beṉ' che'i bittezə yillwe'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na' kin le postlka' shlliṉ: zigaate wleje' Simónna', beena' ḻekzka' che'gake' Pedro, len beṉ' bishee Andréza', na'tech Jacóbona' len beṉ' bishee Juanna', beṉ'ka' nak xiiṉ Zebedewa', ");
INSERT INTO zadNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","na'ch Felípena', Bartoloména', Tomáza', Mateo, beṉ' wic̱hixja', Jacobo xiiṉ Alfewa', Tadewa', ");
INSERT INTO zadNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, beena' bsi'gake' Zelote, na' Jud Scariota', beena' bene' Jesúza' lo na' beṉ' malka'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na'ch bseḻ' Jesúza' beṉ'ka' shlliṉ je'gake' cho'a xtill' Chioza', na' chi'e ḻegake': ―Bi shajle yellka' gana' zoa beṉ'ka' bi nak beṉ' Israel, ni bi shajle yellka' llia gana' mbani Samáriana'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","San ḻi shaj gana' lle' beṉ' Israelka', beṉ'ka' nak ka xil' ba wnit. ");
INSERT INTO zadNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ḻi shaj ḻi lljtix̱jee ba zoa gaoshosh iṉabia' Chioza' beena' zoa yabana' ḻoo yic̱hjlall'do' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ḻi yiyon beṉ'ka' bi shao' na' beṉ'ka' che'i lepra, ḻi yisban beṉ' ba wit, na' ḻi yibej dii x̱iw'ka' yoo beṉ'. Na' ka beṉ Chioza', beṉe' le' yeḻ' waka' ka'z, ka'kzan le' bibi wc̱hixjle yiyonle beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Na' bi wa'le mech de or, de plat ni de cobre. ");
INSERT INTO zadNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Na' ni bi gaḻ'le no yix̱j les, ni bi gox̱'le zi shkwe' xale, ni zi shkwe' xel-le, ni bi gox̱'le yag bar, ḻa' to wen llin chidoḻee yeej gawe'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Na' kat' illinle to to yell xen wa yelldo'zə, c̱hiljle to beṉ' nsa' c̱he' wen, na' yigaaṉle lille'na' na' na'tezə soale ax̱t ka illinch lla yiza'le. ");
INSERT INTO zadNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Na' ka sho'le lille'na' ye'lene': “Chioza' wzoe' le' mbalaz.” ");
INSERT INTO zadNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na' shi dii ḻi beṉ'ka' lle' na' nakgake' beṉ' wen, wakkzə daa ye'le ḻegake'; san shi bi nakgake' beṉ' wen, na' aga wakan. ");
INSERT INTO zadNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na' gattezə illinle shi kono wleb le' na' ni bi wzenaggake' c̱hele, na' yiza'le lill beena' wa yella' gana' gongakile' le' ka' na' yishible bishtena' llia ṉi'aleka'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Dii ḻi nia' le', kat' illin lla wc̱hoglo Chioza' c̱he beṉ', yeḻ' zak'zi' xench ile'chi beṉ' yellka' gana' gongakile' le' ka' aga ka beṉ' yell Sodómana' na' yell Gomórrana'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Nad' chseḻaa le' ka xildo' ladj ba zṉiaka'. Na' chiyaḻ' gakle beṉ' sin' na' beṉ' wen. ");
INSERT INTO zadNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Wsak'gale, ḻa' wchej beṉ' lljwee le' lao beṉ'ka' chṉabia' na' wit c̱hingake' le' gana' chdop chllagcho choe'ḻwillcho Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Na' lljwa'gake' le' lao beṉ' wṉabia' xenka' daa chonḻilall'le nad', na' ka' gak we'lenle ḻegake' cho'a xtillaana' na' ka'kzə beṉ'ka' bi nakgake' beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Na' kat' gongake' le' lo na' beṉ'ka', bi sele wṉeyi naklə iṉale wa bi iṉale, ḻa' ka gaḻ' iṉele, Chioza' wx̱oe' dillaa cho'a ḻoll'leka'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ḻa' aga len' iṉele, san Espíritu c̱he X̱acho Chiozan' gone' ka iṉele. ");
INSERT INTO zadNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Beena' zoa beṉ' bishee ḻeteze' gone'ne' lo na' beṉ'ka' witgake'ne', na' beena' zoa xiiṉe' gone'b' lo na' beṉ' wite'b'. Na' soa beṉ' yizoshyi'e x̱axṉeena' na' gone' ḻegake' lo na' beṉ'ka' witgake' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yog'ḻoḻ beṉ' gakzbangakile' le' daa nonḻilall'le nad', per beena' so sakile' bittezə daa yen ile'ile' ax̱t kat' guete', beenan' gat' yeḻ' mban c̱he' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Shi to yell yilaggake' le', ḻi yiyaj yell yoblə. Ḻa' dii ḻi nia' le' bilaṉ' yiyoll tale yog'ḻoḻ yellki mbani Israeli kat' illin lla yiyed' nad', Beṉ' Bseḻ' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’To beṉ' chsed aga zak'che' ka beena' chli' chsedi ḻe', na' ka'kzə to wen llin aga zak'che' ka x̱ane'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Na' beena' ni chsed yibaile' gake' ka beena' chli' chsedi ḻe', na' ka'kzə wen llinna', yibaile' gake' ka x̱ane'na'. Nad' nak' x̱anle, na' shi nagake' c̱ha' non' txen dii x̱iwaa daa le Bezlo, ¿alelə ki iṉagake' c̱hele ka'? ");
INSERT INTO zadNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Bi illeble beṉ'ka' biya dii wc̱hi' wsak'gake' le'. Ḻa' daa kono ṉezi ṉaa, wllin lla ila'lawin, na' aga ga de to dii ngash' dii bi illin lla ila'lawin. ");
INSERT INTO zadNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Diika' chli' chsedid' le' do ngash'zə, ḻi we'n dill' ladj lkwe' beṉ'. Na' diika' nia' le' to le'zə, ḻi wzenin yog'ḻoḻ beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bi illeble beṉ'ka' cheengakile' witgake' le', ḻa' kwerp c̱hele na'zan witgake', aga bi gak gongakile' yic̱hjlall'do'lena'. San Chiozan' chiyaḻ' illeble, ḻa' ḻen' wakə wlliayee kwerp c̱helena' len yic̱hjlall'do'lena' lo yi' gabiḻa'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Ḻa'kzi wak si'cho c̱hop byiṉdo' kon to sintabdo', ni tob bi guet shi X̱acho Chioza' bi wi'e latj. ");
INSERT INTO zadNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na' ka nakle le', ax̱t yish' yic̱hjlena' nḻabe'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Daan bi chiyaḻ' illeble, ḻa' zak'ch le' aga ka ba zan byiṉdo'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Beena' we' dill' lao beṉ' iṉe' nake' nad' txen, ka'kzə nad' yep' X̱a'na' zoa yabana' nake' nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Na' beena' bi chc̱heb lao beṉ' nan nake' nad' txen, ka'kzə nad' yep' X̱a'na' zoa yabana' bi nake' nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Bi gakzile bid' lo yell-lioni kwenc̱he gon' ka soalen ljwell beṉ' mbalaz. Aga daan bid', san bid' kwenc̱he wx̱ia' wdiḻ. ");
INSERT INTO zadNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Daa bid' na' yidiḻ-len beṉ' byona' x̱e'na' na' noola' yidiḻ-lene' xṉeena', na' beena' zoa xoolille' yidiḻ-lene' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na' beṉ'ka' zoa toz yoo gakzbani ljwelle'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Beena' chakchile' x̱e'na' wa xṉeena' aga ka nad', bi chidoḻee gake' nad' txen, na' ka'kzə shi chaktechile' xiiṉe'na' ka nad', ḻekzka' bi chidoḻee gake' nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Beena' bi chzani yeḻ' mban c̱he'na' yen ile'ile' bittezə kwenc̱he gone' ka nia', bi chidoḻee gake' nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Na' beena' chakile' sheḻ' kono wc̱hi' wsak' ḻe', beenan' kwiayee. San beena' chzani yeḻ' mban c̱he'na' yen ile'ile' bittez daa nonḻilallee nad', beenan' gat' to yeḻ' mban c̱he' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Beena' wlebe' le', nad'kzan chlebe'. Na' beena' wlebe' nad' ḻekzka' Chioza', beena' bseḻ' nadaan, chlebe'. ");
INSERT INTO zadNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Beena' wlebe' to beṉ' chyix̱jee daa che' Chioza'ne', lenkzen' ikee ka laxj beena' chyix̱jee daa che' Chioza'ne'. Na' ḻekzka' beena' wlebe' to beṉ' chone' daa nak shḻi daa chibaile' nake' beṉ' ḻi beṉ' shao', ḻekzka' lene'n ikee ka laxj beena' chon daa nak shḻi. ");
INSERT INTO zadNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na' beena' we' ḻa'c̱h' lat' nis yeej beṉ'ki nakgake' nad' txen, dii ḻi nia' le', de laxje'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Na' ka biyoll goll Jesúza' beṉ'ka' shlliṉ bin chiyaḻ' gongake', na'ch bizee na', na' jali' jasedile' beṉ' na' jtix̱je'ile' ḻegake' cho'a xtill' Chioza' yellka' llia gana' mbani Galileana'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na' Juanna' beena' chchoa beṉ' nisa', ba die' lillyana'. Ka wṉezile' daa chon Crístona', na'ch bseḻee c̱hop beṉ'ka' nakgake'ne' txen gana' zoe'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Na' jaṉabgakile'ne' che'gake': ―¿Alin' beena' ba llia bia' yid?, ¿anti chiyaḻ' kweznto' sto beṉ' yoblə? ");
INSERT INTO zadNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Na'ch che' Jesúza' ḻegake': ―Ḻi yiyaj na' ḻi lljayell Juanna' daa chenile nia' na' daa chle'ile chon'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ḻi lljayelle' chon' ka chle'i beṉ' lc̱hoḻka', na' chiza' beṉ'ka' bi chak sa', na' chiyaki beṉ'ka che'i lepra, na' chiyeni beṉ' kwellka', na' chisban' beṉ'ka' ba wit, na' chyix̱je'id' beṉ' yesh'ka' dill' wen dill' kob c̱he Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Chakomba beena' chajḻe' c̱ha' na' bi chakc̱hoplallee. ");
INSERT INTO zadNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Na' ka biza' beṉ'ka' bseḻ' Juanna', na'ch wzolo Jesúza' be'lene' beṉ'ka' lle' na' xtill' Juanna', chi'e ḻegake': ―¿Nakran nsa' c̱he beena' jawiale latja' gana' bibi chashj chḻeb? ¿Anake' to beṉ' chakc̱hoplallii c̱he dill'ka' cho'e? ");
INSERT INTO zadNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Shi bi nakan ka', ¿nakran nak beena' jawiale? ¿Ato beṉ' nakw xalaane' dii ḻe nakə? Bi nakan ka'. Ḻa' ṉezkzile beṉ'ka' nakw xalaangake' dii ḻe nak zoagake' ḻoo yoo lill beṉ' wṉabia'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Nakrakzan nak beena' jawiale? ¿Ato beṉ' chyix̱jee daa che' Chioza'ne'? Dii ḻi kan' chone', na' chontechle' ka beṉ'ka' chyix̱jee daa che' Chioza' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ḻa' c̱he beenin cho'e Cho'a Xtill' Chioza' dill' daa nan: Wseḻaa beena' kwialo lawo'na', na' c̱hix̱ji'e xtilloona' kwenc̱he soa beṉ' wzenaggake' c̱ho' kat' illino'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Dii ḻi nia' le', ladj yog' beṉ' yell-lioki, ni toe' biṉ' ichej gake' beṉ' zak'chi' aga ka Juanna' beena' chchoa beṉ' nisa'. Per nottezə beena' choe' latj iṉabia' Chioza' yic̱hjlall'do'ena', zak'teche' aga ka Juanna'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Kon ka wzolo Juanna' bchoe' beṉ' nisa' ax̱t ṉaanlla, zoa beṉ' chsej chllongake' kono wleb yeḻ' wṉabia' c̱he Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Librka' daa bzej dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' na' leya' bzej dii Moiséza' wdix̱jeegakan c̱he yeḻ' wṉabia' c̱he Chioza', na' ḻekzannan' cho'e Juanna' dill' ṉaa blee. ");
INSERT INTO zadNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na' shi cheenile shajḻe'le dga nia' le', ḻekzen' Elíaza', beena' nagake' yid kwenc̱he c̱hix̱ji'e cho'a xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ka le' chenile dga nia', ḻi sen wṉeyi. ");
INSERT INTO zadNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Bera ka wsaklebid' le' mbanle ṉaa? Le' chonle ka bi'do'ka' lle' gana' chak yaana' na' chosyaagakb' che' ljwellb': ");
INSERT INTO zadNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Bkwellnto' blleja' na' bi byaale, na' beḻnto' daa chon nyesh' na' ni bi wchellkzle.” ");
INSERT INTO zadNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ḻa' Juanna' bi weej wdawe' dii wen dii shao', na' wnagake' c̱he': “Dii x̱iwaan yo'e.” ");
INSERT INTO zadNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Na'ch wdena' bid' nad' nak' Beṉ' Bseḻ' Chioza' Yell-lioni, na' cheej chaw', na' nagake' nak' to beṉ' waox̱at na' to weezo, na' ḻekzka' nagake' non' txen beṉ' wen dii malka' na' beṉ' wic̱hixjka'. Per yeḻ' sin' c̱he Chioza' chli'lawin ka chsa' c̱he beṉ'ka' chzenaggake' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Na'ch wzolo Jesúza' bsheshlene' beṉ' yellka' gana' bli'che' yeḻ' waka', daa bi biyaj bilengakile' xtoḻeeka'. Na' wne': ");
INSERT INTO zadNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Nyesh'laz gak c̱hele, le' beṉ' yell Corazín! ¡Nyesh'laz gak c̱hele, le' beṉ' yell Betsaida! Ḻa' sheḻ' beṉ'ka' lle' yell Tírona' na' yell Sidónna' ble'gakile' yeḻ' wakka' ba ble'ile, lii biyaj bilenteljagakile' xtoḻeeka', na' gokwljagake' lech' zeshaa na' bllaagake' dena' yic̱hje'ka' daa ḻe gokyesh'gakile', sheḻ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Na' daa bi biyaj bilenile, ba nia' le', llana' wc̱hoglo Chioza' c̱he ben', dii walch sak'zi'le aga ka beṉ' Tíroka' na' beṉ' Sidónka'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na' le' beṉ' Capernaúm, ¿achakile willinle yabana'? Aga willinle na', san latj gana' sak'zi'len yillinle. Ḻa' sheḻ' beṉ' Sodómaka' ble'gakile' yeḻ' wakka' daa ba ble'ile, balja biyaj bilengakile' saaxya c̱he'ka' na' ni ndia yella', sheḻ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Daan nia' le', kat' illin lla wc̱hoglo Chioza' c̱he beṉ', dii walch sak'zi'le aga ka beṉ' Sodómaka'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Na' lo gora' wṉe Jesúza', chi'e: ―X̱a, li' nako' x̱an yabana' na' yell-lioni, choe'lawaa li' daa bkwashilo' beṉ' sin'ka' diika' ba bliilo' beṉ'ka' bibi chajnii. ");
INSERT INTO zadNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Beno' ka', X̱a, ḻa' kan' wyazlalloo. ");
INSERT INTO zadNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Na'ch goll Jesúza' beṉ'ka': ―X̱a'na' bene' lall' na' yog'ḻoḻ daa chon'. Na' ni to kono nombia'yeṉ' nad' ḻete X̱a'na', na' ḻekzka' kono nombia'yeṉ' X̱a'na' ḻete nad' nak' Xiiṉe' len beṉ'ka' cheenid' gon' ka gombia'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ḻi gonḻilall' nad', yog'le le' ba chjshiaile na' nakle ka beṉ' ntakw nc̱hej to dii zii dii zshab, na' nad' gon' ka yizi'lall'le. ");
INSERT INTO zadNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ḻi gon ka nia', na' ḻi wzenag daa chzajniid' le', ḻa' nad' nak' beṉ' gax̱jlall' na' gon' ka gat' yeḻ' wixi'lall' c̱hele. ");
INSERT INTO zadNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Daa nia' le' gonle aga nakan dii bi gak gonle, na' daa chli' chsedid' le' bi nakan dii bi so sakile. ");
INSERT INTO zadNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","To lla sabd, llana' chombaaṉ beṉ' Israelka', wdelen Jesúza' beṉ'ka' nakgake'ne' txen to ga naz to beṉ' trígona', na' beṉ'ka' zejlengake'ne' wzolo wdishjgake' trígona' na' wdaogake'n. ");
INSERT INTO zadNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Na' ka ble'i fariseoka' daa chon beṉ'ka', na'ch che'gake'ne': ―Bwia ka chon beṉ'ki nakgake' li' txen, chongake' daa bi chiyaḻ' goncho llani chombaaṉcho. ");
INSERT INTO zadNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Na'ch che' Jesúza' ḻegake': ―¿Abiṉ' wlable ka ben dii Davina' len beṉ'ka' nakgake'ne' txen ka wdongake'? ");
INSERT INTO zadNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wyo'e ḻoo lill xḻatj Chioza' na' wdoyoe' yetxtilka' daa naki c̱he Chioza' daa toz bx̱ozka' de lsens gaogake'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Abiṉ' wlable leya' gana' nan aga bi xya nakan c̱he bx̱ozka' ḻa'kzi chongake' llinna' ḻoo yoodo'na' llaka' chombaaṉcho? ");
INSERT INTO zadNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na' nia' le', ladjleni zoa to beṉ' zak'che' aga ka yoodo'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bilja wyajniile bi zeji Cho'a Xtill' Chioza' daa na: “Nad' cheenchid' yiyeshii ljwell-le, aga ka daa witle bayix̱'ka' kwenc̱he we'la'ole nad'.” Ḻa' sheḻ' le' wyajniilen, aga waole xya c̱he beṉ' bi nap doḻ', sheḻ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nad', Beṉ' Bseḻ' Chioza' Yell-lioni, chṉabi'a lao llani chombaaṉcho. ");
INSERT INTO zadNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Na'ch biza' Jesúza' latja', na' biyaje' gana' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na' ladj beṉ'ka' len to beṉ' net tḻaa neena'. Na' fariseoka' chwiagake' naklə ka si' sengake' kwenc̱he gaogake' xya c̱he Jesúza', na'ch wṉabgakile'ne', che'gake': ―¿Beran na leya'? ¿Ade lsens yiyoncho to beṉ' bi shao' llani chombaaṉcho? ");
INSERT INTO zadNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Na'ch che' Jesúza' ḻegake': ―Shi nole zoa to xil' c̱hele na' ixopb to ḻoo yech llaki chombaaṉcho, ¿abi yibejleb? ");
INSERT INTO zadNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na' ¡zak'techlə beṉec̱ha' aga ka xilaa! Daan de lsens goncho daa nak wen llaki chombaaṉcho. ");
INSERT INTO zadNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Na'ch golle' beena' net tḻaa neena': ―Bḻi noona'. Na' ka bḻi neena' lii biyakten ka nak daa zi shḻaa. ");
INSERT INTO zadNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Na' ka biza' fariseoka' gana' chdop chllaggake', be'gake' dill' nak sho' xṉezi witgake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ka gokbe'i Jesúza' daa cheengakile' gongake', na' bizee ziyaje' gan yoblə. Na' beṉ' zan inlleb janoe'ne' na' biyone' yog' beṉ'ka' bi shao'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Na' golle' beṉ'ka' biyone' bi we'gake' dill' daa chone'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Daa bene' ka', billinin ka wna dii Isaíaza', beena' wdix̱jee daa goll Chioza'ne', kana' wne': ");
INSERT INTO zadNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Beenin nake' wen llin c̱ha', beena' ba wlej', na' ḻe chakidee na' chazlallaa ka chone'. Na' wzoa' Espíritu c̱ha'na' ḻoo yic̱hjlall'do'ena', na' c̱hix̱je'ile' beṉ'ka' lle' yell-lioni ka cheenid' gongake'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Bi gakdiḻ-lene' beṉ', na' ni bi gosyee wi'e dill' yawi nez. ");
INSERT INTO zadNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Aga wisyoll wistoe' c̱hishje' yax̱tila' daa ba chashjə. na' aga wisole' mesha' daa ba chiyol, ax̱t ki gone' gan wli'lao yeḻ' ḻi yeḻ' shao' c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na' beṉ' lle' doxen yell-lioni gongake' lez ḻen' gaklene' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jwa'gake' lao Jesúza' to beṉ' yo'e dii x̱iw' na' bi chle'ile' ni bi chak iṉie'. Na' bibej Jesúza' dii x̱iwaa yo'e, na' bile'ile' na' gokte biṉie'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yog'ḻoḻ beṉ'ka' bibangakile' ka nak daa bene', na' chisne': ―¿Aaga beenin xiiṉ dia c̱he dii Davina', beena' chbezcho, lla? ");
INSERT INTO zadNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ka beni fariseoka' dillaa choe' beṉ'ka', na' che'gake': ―Aga bi yeḻ' wak nap beeni. San yeḻ' wak c̱he Bezlona', daa chṉabia' dii x̱iw'ka'zan, chibejile' diika'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Na' gokbe'i Jesúza' daa chza'lall' fariseoka', na'ch chi'e ḻegake': ―Shi gana' chṉabia' to beṉ' na' tiḻgake' to ḻezgake' na' gakgake' c̱hoplə, na' kwiayi' gana' chṉabi'e, na' ka'kzə shi to yell wa beṉ' lle' toz yoo gakgake' c̱hoplə aga wdiagake'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ka'kzə Satanáza', shi yibej ljwell dii x̱iwiinka' yoo beṉ', aga wdia yeḻ' wṉabia' c̱heyinna', sheḻ'ka', ḻa' to ḻezgakannan' chidiḻ-len kwingakin. ");
INSERT INTO zadNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Le' nale chibej' dii x̱iwaa yoo beṉ' kon yeḻ' wak c̱he Bezlona' daa chṉabia' ḻegakan. ¿Shera beṉ'ka' nakle txen? ¿Aḻekzka' ḻennan' chibejlengake' dii x̱iw'ka' yoo beṉ'? Daa bi nakan ka', na' chli'n nakllejile. ");
INSERT INTO zadNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Na' shi nad' chibej' dii x̱iw'ka' kon yeḻ' wak c̱he Espíritu c̱he Chioza' zejin ladjleni ba bla' yeḻ' wṉabia' c̱he Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Aga no gak sho' lill to beṉ' wal na' kwane' dii de c̱he' shi bi wc̱heje'ne' zigaate. Na'chan gak kwane' lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Beena' bi chone' nad' txen, ḻen' chakzbanile' nad'; na' beena' bi chaklene' nad' kwenc̱he wzenag beṉ' c̱he Chioza', ḻen' chsej chllone' wzenaggake'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Na' nia' le', wizi'xen Chioza' yog' saaxya c̱helena' na' yog'te dii mala' daa chbell chṉele, san shi iṉele zban c̱he Espíritu Sántona' na' c̱heyi diika' chone', aga wizi'xen Chioza' c̱hele. ");
INSERT INTO zadNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Na' shi no iṉe c̱ha', nad', Beṉ' Bseḻ' Chioza' Yell-lioni, ḻekzka' wizi'xen Chioza' c̱he', san beena' iṉe c̱he Espíritu Sántona', aga wizi'xene' c̱he' ṉaa zoe' yell-lioni ni kat' illin llana' wc̱hogloe' c̱he beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Ṉezicho yaga' daa nak wen chbian dii wen, na' yaga' daa bi nak wen aga bi dii wen chbian. Kon ka nak yaga', ka'te nak daa chbian. ");
INSERT INTO zadNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Le' beṉ' wen dii mal! ¿Nakra gonle iṉele daa nak dii wen daa nakle beṉ' mal? Ḻa' yog' dill' daa chchej cho'a ḻoll'chona' za'n ḻoo yic̱hjlall'do'chona'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Beena' nak beṉ' wen cho'e dill' wen, daa yoo dii wenna' ḻoo yic̱hjlall'do'ena'; na' beena' nak beṉ' michian bi cho'e dill' yejni'alallii, daa yoo dii michianna' ḻoo yic̱hjlall'do'ena'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Na' nad' nia' le', kat' illin lla yizi' Chioza' kwent c̱he yog' beṉ', kanan' yidele kwent c̱he yog'te dill'ka' konteḻe wṉele. ");
INSERT INTO zadNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ḻa' shi le' choe'le dill' wen, na'ch iṉa Chioza' bibi doḻ' naple; per shi le' bi choe'le dill' wen, na' wc̱hogloe' c̱hele sak'zi'le. ");
INSERT INTO zadNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Na'ch baḻ fariseoka' na' beṉ'ka' chli' chsedi leya' che'gake' Jesúza': ―Maestro, cheeninto' ile'into' gono' to yeḻ' wak kwenc̱he gakbe'into' shi Chiozan' bseḻee li'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Na' che' Jesúza' ḻegake': ―Le' nakle beṉ' mal na' beṉ' bi chzenag c̱he Chioza' chṉable ile'ile' yeḻ' waka' kwenc̱he wli'n shi Chiozan' bseḻee nad', per aga wliid' le' daa cheenile. Ḻete ile'ile to dii nak ka yeḻ' wak daa ben Chioza' c̱he dii Jonáza'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ḻa' Jonáza' wyo'e shoṉə lla shoṉə yel ḻoo ḻee beḻ xenna', na' ka'kzə nad', Beṉ' Bseḻ' Chioza' Yell-lioni, shoṉ lla shoṉ yel igaaṉa' ḻoo bana'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kat' illin lla wc̱hoglo Chioza' c̱he beṉ' yell-lioni, kanan' dii beṉ' Níniveka' gaogake' xya c̱hele, le' zoale ṉaa, ḻa' ḻegake' biyaj bileni saaxya c̱he'ka' kana' wdix̱je'i dii Jonáza' ḻegake' cho'a xtill' Chioza'. Na' nad', zak'techid' aga ka dii Jonáza' na' bi chzenagle c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na' ḻekzka' llana' kat' wc̱hoglo Chioza' c̱he beṉ' yell-lioni, noola' wṉabia' yellka' lle' do lli'lə gawe' xya c̱hele, le' zoale ṉaa, ḻa' ḻen' wzee zit' nlleb bidzenague' dill' sin' daa wṉe dii Salomónna'. Na' nad', zak'techid' aga ka dii Salomónna' na' bi chzenagle c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Kat' chichej dii x̱iwaa yoo beṉ', na' chdan gana' bibi chashj chḻeb chyiljan gana' yizi'lalliin. Na' kat' bi chllelin gana' yizi'lalliin, ");
INSERT INTO zadNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","na'ch chakin: “Yiyaach' dii yoblə gana' bichejkz'.” Na' kat' yillinan gana' bichejan, nakan ka to yoo desh dii nxi nḻoa. ");
INSERT INTO zadNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Na'ch lljaxi'n zi gall dii x̱iw'ka' nakch dii malch aga ka ḻen, na' sho'gakan beena'. Na' gaktech mal c̱he beena' aga ka gok c̱he' dii nech. Ka'kzan gak c̱he beṉ' malka' lle' ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ni choe'lente Jesúza' beṉ'ka' dillaa ka bllin xṉeena' len beṉ' bisheeka' goklall'gake' wshaljlengake'ne' na' wzegake' lesh' chyoona'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Na' goll to beṉ' Jesúza': ―Xṉoona' len beṉ' bishooka' zegake' lesh' chyoona' cheengakile' wshaljlengake' li'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Na' che' Jesúza' beena' golle'ne' ka': ―¿Noran xṉa'na' na' noran beṉ' bishaaka'? ");
INSERT INTO zadNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Na'ch bli'e beṉ'ka' nakgake'ne' txen na' chi'e: ―Beṉ'kin xṉa'na' na' beṉ' bishaaka'. ");
INSERT INTO zadNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ḻa' nottezə beena' chon ka cheeni X̱a'na' zoa yabana', beenan' nake' beṉ' bishaa, beṉ' zan' na' xṉa'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na' lo llana'tezə wza' Jesúza' yoona' gana' zoe' na' jc̱hi'e cho'a nisdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Na' daa bdop beṉ' zan gana' chi'e, na' wyepe' jshie' to ḻoo barkw. Na' yog' beṉ'ka' bdop bllag wzegake' cho'a nisdo'na'zə. ");
INSERT INTO zadNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Na'ch bseesee zan jemplka' kwenc̱he bli' bsedile' ḻegake', chi'e: ―To beṉ' goz gooṉ wzee zeje' goza'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Na' ka zej chzaḻee biṉna', bxop baḻan cho'a neza' na' bllin byiṉka' wdaogakban. ");
INSERT INTO zadNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Na' zi baḻan bxop ladj yajka' gana' bitek chi' yona', na' ḻobe' bilaan daa bi wyazan zitj. ");
INSERT INTO zadNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Na' ka wṉa'n wbilla', bkwedan na' wbillten daa bitek bde loinna'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Na' zi baḻan bxop ladj yag yesh'ka', na' bgol yag yesh'ka' na' bi be'gakan latj igolgakan. ");
INSERT INTO zadNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Na' zi baḻan bxop lo yo wenna', na' wlliachgan. Baḻan wllia to guiyoa, na' zi baḻan wllia guiyon na' zi baḻan wllia shichoa. ");
INSERT INTO zadNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ka le' chenile dga nia', ḻi sen wṉeyi. ");
INSERT INTO zadNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na' beṉ'ka' nak Jesúza' txen jabig'gake' kwite'na', wṉabgakile'ne': ―¿Bic̱he chseesoo jemplka' kat' chli' chsedilo' beṉ'? ");
INSERT INTO zadNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Na' che' Jesúza' ḻegake': ―Chioza' cho'e latj iṉezile ka nak yeḻ' wṉabia' c̱he'na' daa kono ṉezi. Na' beṉ'ka' bi nak nad' txen, bi cho'e latj iṉezgakile'n. ");
INSERT INTO zadNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ḻa' beena' ze wṉeyi shajniile' Cho'a Xtill' Chioza', zizikli shajni'chile'n. Na' beena' bi se wṉeyi shajniile'n, na' gaḻ-lallee daa ba wyajniile' lat'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Daan chseesaa jemplka' kat' chzajniid' ḻegake'. Ḻa' beṉ'ka' chwiategake' na' bi chakbe'gakile' bin zeji daa chon', na' chengakile' daa chṉia' na' bi chajni'gakile' bin zejin, daa bi chajḻe'gake' c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Na' daa chongake' ka', chillinin ka wna dii Isaíaza' ka wdix̱ji'e daa goll Chioza'ne', daa na: Ḻa'kzi yengakile', aga wyajni'gakile' bi zeji daa yengakile'. Na' ḻa'kzi ile'gakile', aga wakbe'gakile' bi zeji daa ile'gakile'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ḻa' yic̱hjlall'do'eka' nc̱hoḻ nnitin, na' chongake' ka beṉ' ndap naguin na' ka beṉ' nshod' jalawin. Sheḻ' bi chongake' ka', na' shajni'gakile' daa chzajniid' ḻegake' na' c̱hazan ḻoo yic̱hjlall'do'eka' na' yiyaj yilengakile' dii malka' chongake', na' yiyongakee sto beṉ' wen. ");
INSERT INTO zadNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Per chakomba le' chakbe'ile bi zeji diika' chle'ile chon' na' chajniile diika' chli' chsedid'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Dii ḻi nia' le', zan dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' na' zan dii beṉ'ka' bsa' c̱heyin wen lao Chioza' goklall'gake' ile'gakile' ka dga chle'ile ṉaa, na' bi ble'gakile'n. Na' goklall'gake' yengakile' ka dga chenile ṉaa na' bi bengakile'n. ");
INSERT INTO zadNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Ḻi wzenag bin zeji jempl c̱he beṉ' goz gooṉa'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Beena' cheni cho'a xtill' Chioza' daa chzajniin ḻe' c̱he yeḻ' wṉabia' c̱he'na', na' bi chajniile'n, nake' ka cho'a neza' gana' bxop binṉa' daa wdao byiṉdo'ka', ḻa' dii x̱iwaa chikwasan cho'a xtill' Chioza' daa wyoo ḻoo yic̱hjlall'do'ena'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Na' beena' cheni cho'a xtill' Chioza' na' ḻe chibaile' chlebe'n, nake' ka ladj yajka' gana' bxop biṉna' ");
INSERT INTO zadNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","daa bitek bi loin bde na' bi bdian. Ḻa' kat' bi chak c̱he' wa chc̱hi' chsak' beṉ' ḻe' ni c̱he cho'a xtill' Chioza', na' lii chbejte yic̱hje'n. ");
INSERT INTO zadNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na' beena' cheni cho'a xtill' Chioza' per chi' yic̱hje' diika' chak c̱he' na' chzelall'tie' yeḻ' wni'ana', na' chsej chllongakan gon xshin cho'a xtill' Chioza' lo yeḻ' mban c̱he'na'. Beenan' nake' ka daa bla' ladj yag yesh'ka' daa bi be'gakan latj igolan. ");
INSERT INTO zadNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Per beena' cheni cho'a xtill' Chioza' na' chajniile'n na' chone' ka nan, nake' ka yo wenna' gana' bxop biṉna', na' baḻan wllian to guiyoa, baḻan do guiyon, na' zi baḻan wllian shichoa. ");
INSERT INTO zadNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Na' bsees' Jesúza' sto jempl, chi'e ḻegake': ―Yeḻ' wṉabia' c̱he Chioza' nakan ka to beṉ' goze' biṉ wenna' lo yell-lio c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Per waḻ chela' shlak chese', wyaj to beṉ' chakzbanile'ne' jeze' ladj trígona' daa nak x̱enin, na' ka biyoll bene' ka' bizee. ");
INSERT INTO zadNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na' ka bgol trígona' na' wllian, na' ḻekzka' bgolte x̱eninna' ladjinna'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Na' wyaj wen llinka' jellgake' x̱aninna': “Beṉ'do', ¿aaga biṉ wennan jezo' lo c̱ho'na'? ¿Gara wza' x̱eninna' lenzan ladjinna', lla?” ");
INSERT INTO zadNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Na' che' x̱aninna' ḻegake': “Nochod' beṉ' chakzbanile' nad' jene' ka'.” Na' goll wen llinka' ḻe': “¿Acheenilo' shajnto' lljaḻall'nto'n?” ");
INSERT INTO zadNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Na' chi'e ḻegake': “Bi lljaḻall'len, ḻa' nxoll lente trígona' wḻall'le. ");
INSERT INTO zadNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","San igol-lenchan trígona', na' kat' illin lla yic̱hoggake'n, na' yep' beṉ'ka' zigaate yiḻall'gake' x̱eninna' na' gongake'n shḻen wej kwenc̱he sheyan, na'tech yitopgake' trígona' na' yigooshao'gake'n ḻoo lillinna'.” ");
INSERT INTO zadNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Na' ḻekzka' bzoa Jesúza' sto jempl, chi'e: ―Yeḻ' wṉabia' c̱he Chioza' nakan ka sa mostásana' daa goz to beṉ' lo yell-lio c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ḻa'kzi sa mostásana' nakan ḻiizelozi diido' yid lao bichlə sa yix̱' kwan, kat' chḻa'n na' chgolan na' chakan dii xench aga ka yix̱' kwanka' sto, na' ax̱t byiṉdo'ka' chon lillbka' lo xoziinna'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Na' ḻekzka' bzoe' sto jempl, chi'e: ―Yeḻ' wṉabia' c̱he Chioza' nakan ka levadúrana' daa chc̱hix̱ to noolə shoṉa rob yezja' kwenc̱he yisgolan kwa c̱he yetxtila'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesúza' toshiizi bc̱hine' jemplka' ka bi'e dill' ladj lao lkwe' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Na' daa ben Jesúza' ka', billinin daa wdix̱jee to beṉ' daa goll Chioza'ne', ka wne': Wc̱hin' jemplka' ka we'len' beṉ' dill'. We'len' beṉ' dill' c̱heyi daa konoṉ' iṉezi dezd kana' bx̱e bsilte Chioza' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Na' bisa' Jesúza' beṉ'ka' lle' na', na' biyo'e ḻoo yoona'. Na' beṉ'ka' nakgake'ne' txen jabig'gake' kwite'na' che'gake'ne': ―Bizajnii neto' bi zeji jempl c̱he x̱en trígona' ");
INSERT INTO zadNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Na' goll Jesúza' ḻegake': ―Kin zejin: Nad', Beṉ' Bseḻ' Chioza' Yell-lioni, zaklebid' beena' goz trígona'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Na' doxen yell-lioni zaklebin gana' goz beena' trígona'. Na' beṉ'ka' choe'gake' latj chṉabia' Chioza' yic̱hjlall'do'eka' zaklebgakile' trígona'. Na' beṉ'ka' choe'gake' latj chṉabia' dii x̱iwaa yic̱hjlall'do'eka' zaklebgakile' x̱en trígona'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na' dii x̱iwaa zaklebin beṉ' mala', beena' jez ladj trígona' daa nak x̱enin. Na' llana' chilapgake', zaklebin llana' kwiayi' yell-lioni. Na' anjlka' zaklebgakile' beṉ'ka' chizi' chilap trígona'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Na' ka chitopgake' daa nak x̱en trígona' kwenc̱he wzeygake'n, ka'kzan gak c̱he beṉ'ka' chṉabia' dii x̱iwaa yic̱hjlall'do'eka' ka illin lla kwiayi' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nad', Beṉ' Bseḻ' Chioza' Yell-lioni, wseḻaa anjl c̱ha'ka' kwenc̱he yitopgake' beṉ' wen dii malka' na' beṉ'ka' chzechgake' beṉ' yoblə gongake' dii mala'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Na' wzaḻ'gake' ḻegake' lo yi' gabiḻa' gana' kwellyesh'gake' na' gaox̱ax̱j ḻeye'ka' daa ḻe gakshejlall'gake'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Na' beṉ' ḻi beṉ' shao'ka' sho'gake' balaaṉ choo balaaṉ xen yabana' gana' chṉabia' X̱acho Chioza'. Ka le' chenile dga nia', ḻi sen wṉeyi. ");
INSERT INTO zadNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Yeḻ' wṉabia' c̱he Chioza' nakan ka to mech xen dii ngash' to lo yell-lio c̱he beṉ' gana' to beṉ' jadi'en. Na' na'tezə bikwasheen, na' chibaile' jayet' jadie' yog' dii de c̱he' kwenc̱he bizi'e yell-liona' gana' ngash' mecha'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Yeḻ' wṉabia' c̱he Chioza' zaklebin to beṉ' chone' delgens c̱he perla dii zak'chga. ");
INSERT INTO zadNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Na' ka bllelile' to dii ḻiizelozi zakii, na'ch jayet' jadie' yog' dii de c̱he' kwenc̱he wxi'en. ");
INSERT INTO zadNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Yeḻ' wṉabia' c̱he Chioza' zaklebin to yix̱j c̱he beḻ. Beṉ'ka' chzen beḻa' chzaḻ'gake' yix̱ja' ḻoo nisdo'na' na' chzenan zan kwen beḻ. ");
INSERT INTO zadNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Na' kat' chilla' yix̱ja' na' chibejgake'n cho'a nisdo'na' na' chbe'gake' chibegake' beḻka' nak wen na' chgooshao'gake'b to ḻoo llom, na' baka' bi nak wen, chchooṉgake'b. ");
INSERT INTO zadNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kan' gak c̱he beṉec̱ha' ka illin lla kwiayi' yell-lioni. Anjlka' yibegake' beṉ' wenka' ladj beṉ' malka', ");
INSERT INTO zadNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na' wzaḻ'gake' beṉ' malka' lo yi' gabiḻa' na' kwellyesh'gake' na' gaox̱ax̱j ḻeye'ka' daa ḻe gakshejlall'gake'. ");
INSERT INTO zadNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Na'ch che' Jesúza' beṉ'ka' nakgake'ne' txen: ―¿Azajniile yog' daa ba bli' bsedid' le'? Na'ch che'gake'ne': ―Awe, zajniinto'n. ");
INSERT INTO zadNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Na' chi'e ḻegake': ―Beena' chli' chsedi leya' na' nzedile' c̱he yeḻ' wṉabia' c̱he Chios, beena' zoa yabana', zaklebile' to x̱an yoo beṉ' ngooshawee dii zan dii zakii, ka dii kob na' ka dii gol, na' chbeje'gakan chc̱hine'gakan. ");
INSERT INTO zadNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ka biyoll bsees' Jesúza' jemplka', na' bizee. ");
INSERT INTO zadNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Na' ka billine' yell Nazareta' gana' bgole', na' bli' bsedile' beṉ' Israelka' chdop chllag gana' choe'ḻwillgake' Chioza'. Na' bibani beṉ'ka', che'gake': ―¿Gara jx̱i' beeni yeḻ' sin' c̱he'na', na' nak chak chone' yeḻ' wakka'? ");
INSERT INTO zadNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Aaga xiiṉ karpintera'zan na' xṉeena' lie' María? Na' ¿aaga beṉ' bishee Jacóbona', Joséna', Simónna' na' Júdaza'? ");
INSERT INTO zadNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na' beṉ' zane'ka' zoagake' lallchoni. ¿Gara jasede' yog'ḻoḻ diiki chli' chsedile', lla? ");
INSERT INTO zadNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Na' daa bi wyajḻe'gake' c̱he Jesúza', na' golle' ḻegake': ―To beṉ' chyix̱jee daa che' Chioza'ne', gattez chgoogake'ne' balaaṉ san lall lille'na' aga no chgoo ḻe' balaaṉ. ");
INSERT INTO zadNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na' aga bitek yeḻ' wak ben Jesúza' yell Nazareta' daa bi wyajḻe'gake' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na' do kana', Heródeza', beena' chṉabia' gana' mbani Galileana', benile' ka nak daa chon Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Na' golle' beṉ'ka' chon xshine'na': ―Beenan' dii Juanna', beena' bchoa beṉ' nisa'. Ba bibane' ladj beṉ' wetka', daan chak chone' yeḻ' wakka'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ḻa' kana' ni mban dii Juanna', Heródeza' bseḻee beṉ' bex̱'gake'ne' na' wloogake'ne' lillyana' ni c̱he Herodíaza' xool beṉ' bisheena', beena' le Felipe. ");
INSERT INTO zadNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ḻa' dii Juanna' golle' Heródeza': ―Bi nakan wen nkoo xool beṉ' bishoona'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Na' daa golle'ne' ka' goklall' Heródeza' wite'ne', per bi biyaxjile' daa bllebe' beṉ'ka' chajḻe' daa nak Juanna' to beṉ' chyix̱jee daa che' Chioza'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Per ka wya'i Heródeza' yiz, bi' nool wew' c̱he Herodíaza' byaab' lao beṉ'ka' lle' lṉina'. Na' daa ḻe biyoolallii Heródeza' ka byaab' ");
INSERT INTO zadNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ax̱t bzoe' Chioza' de tasc̱hiw bc̱hebe' wi'eb' bittezə dii iṉabib' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na' kon ka bzajnii xṉa'baab' bem', na' che'b' Heródeza': ―Yic̱hj Juanna', beena' chchoa beṉ' nisa', cheenid' goṉo'n nad' to lo plat llilj. ");
INSERT INTO zadNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Na' gokyeshii Heródeza', per daa ba bc̱heble' lao yog' beṉ'ka' goxe' lṉina' wi'eb' kon daa iṉabib' ḻe', benshaze' byen we'gake'b' daa wṉabb'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Na' bseḻee beṉ' jac̱hoggake' yic̱hj Juanna' ḻoo lillyana'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na' blliagake'n to lo plat llilj na' be'gake'n bi' nool wewaa na' be'baan xṉa'baa. ");
INSERT INTO zadNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Na'ch beṉ'ka' wdalen Juanna' txen wyajgake' jaxi'gake' kwerp c̱he'na' na' bkwash'gake'n. Na' wdena' jellgake' Jesúza' ka gok. ");
INSERT INTO zadNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na' ka wṉezi Jesúza' daa gok c̱he Juanna', bizee gana' zoe' na' biyo'e to ḻoo barkw ziyaje' gana' kono beṉ' lle'. Na' ka wṉezi beṉ'ka' lle' yellka' llia gaozə cho'a nisdo'na' galan zej Jesúza', na'ch wloogake' nez janogake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Na' ka bichej Jesúza' ḻoo barkwa', ble'ile' beṉ' zan inlleb ba lle' na', na' biyeshile' ḻegake' na' biyone' beṉ'ka' bi shao'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Na' ka ba wlle', na'ch beṉ'ka' nak Jesúza' txen jabig'gake' kwite'na', che'gake'ne': ―Ba wlle' ṉaa, na' gani lle'cho kono zoa wit' dii gaocho. Goll beṉ'ki yiyajgake' yellka' llia gaozə kwenc̱he lljx̱i'gake' dii gaogake'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Na' che' Jesúza' ḻegake': ―Bi chonan byen yiyajgake'. Len', ḻi we' dii gaogake'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Na' che'gake'ne': ―Gay'chga yetxtil na' zi c̱hopchga beḻ noa'nto' ni. ");
INSERT INTO zadNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Na' che' Jesúza' ḻegake': ―Ḻi goṉshkin ni. ");
INSERT INTO zadNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na'ch golle' beṉ'ka' kwe'gake' lo yixa'. Na' bex̱ee yetxtilka' gay' na' beḻka' c̱hop na' bḻis lawe'na' yabana' na' bi'e Chioza' yeḻ' chox̱ken. Na'ch bxoxje' yetxtilka' na' bi'en beṉ'ka' nakgake'ne' txen kwenc̱he be'gake' c̱he c̱he beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na' wdao yog'ḻoḻ beṉ'ka' ax̱t ka beljgakile'. Na' ka bidaogake', na'ch bitopgake' diika' bgaaṉ, na' biyakan shlliṉ xet'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na' beṉ' byoka' wdao gokgake' ka do gayaa mil, na' bi blabgake' noolka' na' bi'do'ka' wdao. ");
INSERT INTO zadNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ka wde dga bigoo Jesúza' beṉ'ka' nakgake'ne' txen to ḻoo barkw kwenc̱he yiḻag'gake' shḻaa nisdo'na' to ḻezgake', na' ḻe' bigaaṉe' kwenc̱he bisee beṉ'ka' bdop bllag. ");
INSERT INTO zadNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Na' wde bisee beṉ'ka', na'ch wyepe' to lo yaa kwenc̱he jeḻwille' Chioza' toze'. Na' ni zetie' lo yaana' ka goḻ. ");
INSERT INTO zadNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Na' barkwa' gana' ziyoo beṉ'ka' nakgake'ne' txen ba zejan gchoḻ nisdo'na'. Chakan to ki to ka'lə daa chas chat' nisa', na' be'na' bi cho'en latj yiyajan shḻicha. ");
INSERT INTO zadNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na' zbaḻz biyetj Jesúza' lo yaana' na' bizee tlo nisdo'na' zeje' gana' zejləgake'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Na' ka ble'i beṉ'ka' non Jesúza' txen zeje' tlo nisa', ḻe bllebgake' na' ax̱t besyaagake', nagake': ―¡Ba za' to yel bx̱en! ");
INSERT INTO zadNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Na' lii wṉete Jesúza' ḻegake', chi'e: ―Bi illeble. Nad'kzan'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Na'ch wṉe Pédrona' chi'e: ―X̱an', shi lin', ben ka gak saa lo nisi kwenc̱he yid' kwito'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Na' che' Jesúza'ne': ―Dashka'. Na'ch bchej Pédrona' ḻoo barkwa' na' wzoloe' chzee tlo nisa' nan shaje' kwit Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Per ka gokbe'ile' zechga be'na', na' bllebe' na' lii wzolote chbi'e yel, na'ch besyee chi'e: ―¡X̱an', bisla nad'! ");
INSERT INTO zadNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na' lii biyox̱'te Jesúza' neena', chi'ene': ―¿Berac̱he gokc̱hopzilo'? ¿Bic̱he bi nx̱enilalloo nad' kwasḻoḻ? ");
INSERT INTO zadNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na' kon ka biyoogake' ḻoo barkwa' na' bgan be'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Na' beṉ'ka' bgaaṉ ḻoo barkwa', be'la'ogake' Jesúza' na' gollgake': ―Dii ḻi, lin' Xiiṉ Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na' ka bḻag'gake' shḻaa nisdo'na' na' bllingake' gana' mbani Genesareta'. ");
INSERT INTO zadNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na' beṉ' Genesaretka' biyombia'gake' Jesúza' na'ch bzengakile' beṉ' yellka' lle' gao nan ba bllin Jesúza'. Na' jwa'gake' yog' beṉ'ka' bi shao' lawe'na', ");
INSERT INTO zadNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","na' got'yogakile'ne' wi'e latj ḻa'c̱h' gox̱' beṉ' we'ka' xe'na', na' yog' beṉ'ka' bex̱'gake'n biyakgakile'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Baḻ fariseoka' na' beṉ'ka' chli' chsedi leya', wza'gake' Jerusalénna' na' wyajgake' lao Jesúza', wṉabgakile'ne': ");
INSERT INTO zadNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Bic̱he beṉ'ki nakgake' li' txen bi chongake' ka wyoolo dii x̱ozxto'choka'? Ḻa' bi chix̱is chiyib neeka' ka zi' gaogake'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Na' wṉabi Jesúza' ḻegake' chi'e: ―¿Bic̱he chyishjle daa nllia Chioza' bia' gonle na' zechle wṉeyi chonle ka ben dii x̱ozxto'choka'? ");
INSERT INTO zadNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ḻa' kin wna Chioza': “Ḻi gap x̱axṉa'le balaaṉ”, na' “Beena' iṉe zban c̱he x̱e'na' wa xṉeena', chiyaḻ' guete'.” ");
INSERT INTO zadNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Per le', nale wak ye' beṉ' x̱axṉeena': “Bi gak gaklen' le', ḻa' yog' daa nap' ba nc̱heb' wi'an Chioza'.” ");
INSERT INTO zadNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Na' beena' yee x̱axṉeena' ka', cho'allalene' daa nale bi chonan byen gaklene' ḻegake'. Na' daa chonle ka', chonile daa nllia Chioza' bia' goncho ka to dii bibi zakii kwenc̱he nole diika' wyoolo dii x̱ozxto'choka'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Le' beṉ' wxiye', le' wen gan! Kwasḻoḻ inlleb be' dii Isaíaza' xtill'le, ka wne': ");
INSERT INTO zadNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Beṉ'ki choe'la'ogake' nad' de cho'a ḻoll'zgake', ḻa' aga do yic̱hj do lall'gaken' choe'la'ogake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bibi zjanayin chonzgake' ka beṉ' choe'la'o nad'; na' diika' chli' chsedgakile' nakgakan c̱he beṉ' yell-lioz. ");
INSERT INTO zadNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Na' wṉe Jesúza' beṉ'ka' lle' na', golle' ḻegake': ―Ḻi wzenag dga iṉia' le' na' ḻi shajniin. ");
INSERT INTO zadNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Aga daa cheej chao beṉaan chx̱iṉj chḻenan yic̱hjlall'do'ena', san dill'ka' chchej cho'enan', ḻennan' chx̱iṉj chḻenan yic̱hjlall'do'ena'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Na'ch beṉ'ka' nak Jesúza' txen wbig'gake' kwite'na', gollgake'ne': ―¿Azakbe'ilo' gokzi'chgayi fariseoka' ka bengakile' wno' ka'? ");
INSERT INTO zadNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Na'ch goll Jesúza' ḻegake': ―Nottezə beṉ' bi chzenague' c̱he X̱a'na' zoa yabana', yiyol yinite', na' gak c̱he' ka chak c̱he to yag dii chḻall' beṉ' do loyin. ");
INSERT INTO zadNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jwayishazi fariseoka', ḻa' nnit nc̱hoḻgakilen'. Na' ṉezicho shi to beṉ' lc̱hoḻ wc̱hi'e sto ljwell lc̱hoḻe', c̱hoptie' lljabix̱. ");
INSERT INTO zadNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Na'ch Pédrona' golle' Jesúza': ―Bizajnii neto' bi zejin jempla' daa ba bseesoo. ");
INSERT INTO zadNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Na'ch goll Jesúza' ḻegake': ―¿Aḻekzka' lenle biṉ' shajniile bi zejin daa ba wnia'? ");
INSERT INTO zadNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Abi ṉezile nan daa cheej chaocho chjc̱he'n ḻoo ḻeechona' na'tech chiden? ");
INSERT INTO zadNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Per ka nak daa chṉecho, ḻennan' chalj chxen ḻoo yic̱hjlall'do'chona'. Na' shi chṉecho dii bi nak wen, ḻennan' chx̱iṉj chḻenan cho'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ḻa' ḻoo yic̱hjlall'do' beṉec̱han' chalj chxe diiki bi nak wen: yeḻ' chon xya, yeḻ' chṉelen ljwellin, yeḻ' wban, yeḻ' chyiljlall' c̱he beṉ', na' yeḻ' chbell chṉe c̱he beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Diikin chx̱iṉjan yic̱hjlall'do' beṉ', aga daa bi chix̱is chiyib neena' ka zi' gawen'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Na' biza' Jesúza' wyaje' gana' mbani yell Tírona' len yell Sidónna'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na' to noolə cananea zoe' gana' mbani yellka' wbigue' kwite'na' na' wṉie' zilljə, chi'ene': ―X̱an', Xiiṉ dia c̱he dii Daví, biyesh'lall'gachi nad', ḻa' bi' nool c̱ha'na' yoob' dii x̱iwaa na' ḻe chsak'zi'n ḻeb'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Per Jesúza' bikzə bi golle' noola'. Na'ch beṉ'ka' nakgake'ne' txen wbig'gake' kwite'na' gollgake'ne': ―Goll nooli yiyaje', ḻa' kon chosyee zidnoe' cho'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Na'ch goll Jesúza': ―Bseḻ' Chioza' nad' kwenc̱he gaklen' to beṉ' Israelka'zə, beṉ'ka' nak ka xil'ka' wnit. ");
INSERT INTO zadNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Na'ch noola' jabiguee kwit Jesúza' na' bc̱hek' xibe'na' lawe'na' chi'ene': ―¡X̱an', goklengach nad'! ");
INSERT INTO zadNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Na'ch che' Jesúza'ne': ―Bi nakan wen yikaacho yeḻ' wawa' chao bi'do' c̱hechoka' na' we'chon bekw'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na'ch noola' chi'ene': ―Lekzilo', X̱an', per chak chao xikw'choka' diika' chxop lo yona'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Na'ch goll Jesúza'ne': ―¡Noolə, nonḻilall'likzo' nad'! Na' gak ka cheenilo'. Na' katena' lii biyakteyi bi' nool c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Na' biza' Jesúza' na', na' billine' cho'a nisdo' c̱he Galileana' na' wyepe' to lo yaa jc̱hi'e. ");
INSERT INTO zadNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Na' beṉ' zan bllin lawe'na' nc̱he'gake' no beṉ' bi chak sa', no beṉ' lc̱hoḻ, no beṉ' bi chak iṉe, no beṉ' nxiṉj, no beṉ' chak bichlə yillwe'. Na' bzoagake' ḻegake' lao Jesúza' na' biyone' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Na' bibani beṉ'ka' ka gok, ḻa' beṉ'ka' bi chak iṉe wṉegake', na' beṉ'ka' nxiṉj biyakgakile', na' beṉ'ka' bi chak sa' wza'gake', na' beṉ' lc̱hoḻka' ble'gakile'. Na'ch yog'ḻoḻ beṉ'ka' be'la'ogake' Chios, beena' choe'la'o beṉ' Israelka'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Na'ch gox Jesúza' beṉ'ka' nakgake'ne' txen, na' golle' ḻegake': ―Ḻe chiyeshid' beṉ'ki, ḻa' ba gok shoṉ lla zoalengake' cho' ni, na' aga bi de dii gaogake'. Na' bi cheenid' yisangakee daa biṉ' gaogake', ḻa' nxoll ikwidgakile' tneza'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Na' che' beṉ'ka' nakgake'ne' txen: ―Per ¿ga lljx̱i'cho dii gao yog'ḻoḻ beṉ'ki?, ḻa' gani lle'cho kono zoa wit' dii gaocho. ");
INSERT INTO zadNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Na'ch wṉabi Jesúza' ḻegake', chi'e: ―¿Zi baḻchga yetxtil c̱hechoka' de? Na' che'gake'ne': ―De gall yetxtilka' na' sto c̱hop beḻ. ");
INSERT INTO zadNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Na'ch goll Jesúza' beṉ'ka' kwe'gake' lo yona'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Na' bex̱ee yetxtilka' gall na' beḻka' na' bi'e Chioza' yeḻ' chox̱ken, na' bxoxje'n bi'en beṉ'ka' nakgake'ne' txen kwenc̱he be'gake' c̱he c̱he beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Na' yoguee wdao ax̱t ka beljgakile'. Na' wdena' bitopgake' dii lao'ka' bichooṉan, gokten zi gall xet'. ");
INSERT INTO zadNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Na' beṉ' byoka' wdao nakgake' tapa mil, na' bi blabgake' noolka' ni bi'do'ka' wdao. ");
INSERT INTO zadNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Na' biyoll bisa' Jesúza' ḻegake', biyo'e to ḻoo barkw len beṉ'ka' nakgake'ne' txen na' biyajgake' gana' mbani yell Magdálana'. ");
INSERT INTO zadNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseoka' len saduceoka' jawiagake' Jesúza' na' wṉabgakile'ne' gone' to yeḻ' wak dii ile'gakile' kwenc̱he wli'n shi Chiozan' bseḻeene'. ");
INSERT INTO zadNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Na' goll Jesúza' ḻegake': ―Shlle'na' chwiale xan yabana' na' nale: “Ḻe yillaa wx̱e, ḻa' ḻe nḻatjcha.” ");
INSERT INTO zadNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na' shi chibe'cha shzila' na' nale: “Wak yeja' ḻa' ba bibe'cha.” Le' chakbe'ile shi gak zey' wa gak yej daa chwiale ka nak xan yabana', per aga chakbe'ile bin zeji diika' chon Chioza' llaki zoacho ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Le' nakle beṉ' mal na' beṉ' bi chzenag c̱he Chioza', chṉable ile'ile' to yeḻ' wak kwenc̱he wli'n shi Chioza' bseḻee nad', per bi wliid' le' daa chṉable. Ḻete ile'ile sto yeḻ' wak ka daa ben Chioza' c̱he dii Jonáza'. Na' wde goll Jesúza' ḻegake' ka', na' bizee kwite'ka' ziyaje'. ");
INSERT INTO zadNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Na' ka bllingake' shḻaa nisdo'na', beṉ'ka' nakgake'ne' txen goḻ-lall'gake' wa'gake' yetxtila'. ");
INSERT INTO zadNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Na' goll Jesúza' ḻegake': ―Wsak'gale bi shajḻe'le dill' wxiye' c̱he fariseoka' na' saduceoka', daa zaklebi levadúrana'. ");
INSERT INTO zadNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Na' che' ljwellgake': ―Daa goḻ-lall'cho wa'cho yetxtilan' ne' cho' ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Na' gokbe'i Jesúza' daa che' ljwellgake' na' golle' ḻegake': ―¿Bic̱he nazle bibi yetxtila' bia'le? ¿Bic̱he bi nx̱enilall'le nad' kwasḻoḻ? ");
INSERT INTO zadNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Abikzaṉ' shajniile ka nak diika' chon'? ¿Abi chjadinile kana' wdao gayaa mil beṉ' kon gay'zə yetxtilka' na' baḻ xet' dii bixjka' bitople? ");
INSERT INTO zadNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na' ¿shera kana' wdao tapa mil beṉ' kon gallzə yetxtilka'? ¿Abi chjadinile baḻ xet' dii bixjka' bitople? ");
INSERT INTO zadNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Bic̱he c̱he yetxtila'lə wyajnizile ka wnia' wsak'gale c̱he levadura c̱he fariseoka' len saduceoka'? ");
INSERT INTO zadNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Na' kana'ch wyajni'gakile' nan aga c̱he levadura c̱he yetxtilan' chi'e ḻegake' wsak'gake' san diika' chli' chsedi fariseoka' len saduceoka'lan. ");
INSERT INTO zadNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Na' ka bllin Jesúza' len beṉ'ka' nakgake'ne' txen gana' mbani yell Cesarea c̱he Filípona', na'ch chi'e ḻegake': ―¿Non na beṉ' yell-liona' nak', nad', Beṉ' Bseḻ' Chioza' Yell-lioni? ");
INSERT INTO zadNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Na' che'gake'ne': ―Baḻe' nagake' nako' dii Juanna', beena' bchoa beṉ' nisa', na' zi baḻe' nagake' nako' Elíaza', na' zi baḻe' nagake' nako' dii Jeremíaza', na' baḻe' nagake' nako' sto beṉ' chyix̱jee daa che' Chioza'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Na'ch chi'e ḻegake': ―¿Shera le'? ¿Nora nale nak'? ");
INSERT INTO zadNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Na' Simón Pédrona' chi'ene': ―Lin' Crístona', Xiiṉ Chios yaa Chios banna'. ");
INSERT INTO zadNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Na' Jesúza' chi'ene': ―Chakomba li' Simón, xiiṉ Jonás, ḻa' aga nochlan bzajnii li' daa ba wno'. X̱a'na' zoa yabanan' ba bzajniile'n li'. ");
INSERT INTO zadNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na' nad' nia' li', lin' lio' Pedro, daa zeji yaj, na' gako' ka to yaj wal na' lin' wc̱hin' kwenc̱he gono' ka shanch beṉ'ka' gonḻilall'gake' nad', na' ni yeḻ' wita' bi yizoin wlliayi'n beṉ'ka' ba wlej' kwenc̱he nakgake' lall' na'. ");
INSERT INTO zadNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Na' goṉ' li' yeḻ' wṉabia' daa zaklebi to xiiṉya dii chsaljan yabana' gana' chṉabia' Chioza'. Na' diika' iṉo' bi chiyaḻ' gon beṉ' yell-lioni, ḻekzka' iṉa Chioza' zoa yabana', na' diika' iṉo' wak gongake', ḻekzka' iṉa Chioza' zoa yabana'. ");
INSERT INTO zadNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Na' goll Jesúza' beṉ'ka' nakgake'ne' txen ni to kono ye'gake' ḻen' Crístona', beena' bseḻ' Chioza' iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Na' lo llana' wzolo Jesúza' bzajniile' beṉ'ka' nakgake'ne' txen daa llia bia' gak c̱he'. Golle' ḻegake' chonan byen yiyaje' Jerusalénna' kwenc̱he gake' lo na' beṉ' golka' chṉabia' na' lo na' bx̱ozka' chṉabia' na' lo na' beṉ'ka' chli' chsedi leya', na' ḻe wsak'zi'gake'ne', na' chonan byen witgake'ne' na' ka gak shoṉ lla yibane' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Na'ch Pédrona' wleje' Jesúza' ladj beṉ'ka' chi'ene': ―X̱an', ¡bat gak c̱ho' ka ba wno'! ");
INSERT INTO zadNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Na' biyec̱hj Jesúza' chi'e Pédrona': ―Kwas ka'lə, Satanás. Cheenzilo' bi gon' daa llia bia' gon' daa bi yoo yic̱hjo' daa cheeni Chioza', san daa nak c̱he yell-liozan yoo yic̱hjo'. ");
INSERT INTO zadNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Na' che' Jesúza' beṉ'ka' nakgake'ne' txen: ―Shi no cheeni gon nad' txen, chiyaḻ' wsanlall' kwine', na' izani yeḻ' mban c̱he'na' yen ile'ile' bittez ni c̱ha', na' gone' ka chazlallaa. ");
INSERT INTO zadNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ḻa' beena' bi chzani yeḻ' mban c̱he'na', beenan' kwiayi', san beena' chzani yeḻ' mban c̱he'na' yen ile'ile' bittez ni c̱ha', beenan' gat' to yeḻ' mban c̱he' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Bera zjanayin gap beṉ' yog'te dii de yell-lioni, shi ḻe' kwiayee? Aga bi de wi'e lo laz yeḻ' mban c̱he'na' kwenc̱he bi kwiayee. ");
INSERT INTO zadNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ḻa' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, yiyed' len anjl c̱ha'ka' zinsa' balaaṉ xen c̱he X̱a' Chioza'. Kana'chan c̱hixj' to to beṉ' kon ka dii bene'. ");
INSERT INTO zadNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Dii ḻi nia' le', baḻ-le lle'le ni, ni mbanle ile'ile yeḻ' wṉabia' c̱ha'na', nad', Beṉ' Bseḻ' Chioza' Yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ka wde x̱op lla, bc̱he' Jesúza' Pédrona', na' Jacóbona' len beṉ' bishee Juanna', na' to ḻezgake' wyajlene' to lo yaa xen. ");
INSERT INTO zadNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Na' ka lle'gake' lo yaana', gok Jesúza' nlla'lə lawe'ka'. Wyep wyeeni' cho'alawe'na' kakzə wbilla', na' xe'na' nakwe' gokan xtil llyish ax̱t chey cheeni'n. ");
INSERT INTO zadNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na' beṉ'ka' lle'lengake'ne' ble'gakile' dii Moiséza' na' Elíaza' chshaljlengake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Na'ch Pédrona' golle' Jesúza': ―X̱an', ḻe mbalaz zoacho ni. Shi cheenilo', gon' shoṉ ransh, ton cho', ston c̱he Moiséza' na' ston c̱he Elíaza'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Na' ka golle' ka', betj to bej dii chey cheeni' na' bkwashaan ḻegake', na' ḻoo beja' bengakile' che' Chioza': ―Beenin Xiiṉaa, beena' chakid', na' chazlall'chga' ka chone'. Ḻi wzenag c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Na' beṉ'ka' nak Jesúza' txen, ka bengakile' wṉe Chioza', ḻe bllebchgagake' na' to bdoszgake' lo yona'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Na' wbig' Jesúza' kwite'ka' bex̱ee ḻegake', chi'e: ―Ḻi yiyas. Bi illeble. ");
INSERT INTO zadNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Na' ka biḻis yic̱hje'ka', koch no beṉ'ka' ble'gakile', stochga Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na' ka biza'gake' lo yaana' goll Jesúza' ḻegake': ―Ni to kono ye'le ka nak dga ba ble'ile ax̱t kat'ch nad', Beṉ' Bseḻ' Chioza' Yell-lioni, ba biban' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na'ch beṉ'ka' nak Jesúza' txen che'gake'ne': ―¿Berac̱he naz beṉ'ka' chli' chsedi leya' zigaate Elíazan' yiyed? ");
INSERT INTO zadNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Na' goll Jesúza' ḻegake': ―Dii ḻi ka nakannan', zigaate Elíazan' yiyede' yigwee xṉezi yog'ḻoḻte. ");
INSERT INTO zadNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Per nad' nia' le', ba biyed Elíaza', na' bi gokbe'gakile' shi ḻen'. Na' bengakile'ne' kon ka wnazan c̱hegake'. Na' ka'kzan gongakile' nad', Beṉ' Bseḻ' Chioza' Yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Na' gokbe'gakile' nan c̱he Juanna', beena' bchoa beṉ' nisan' cho'e dill'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na' ka billingake' gana' lle' lla' beṉ', na'ch bchej to beṉ' jabiguee kwit Jesúza' na' bc̱hek' xibe'na' lawe'na', chi'ene': ");
INSERT INTO zadNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Maestro, biyesh'gachi bi' c̱ha'ni. Chazb' shoṉ na' ḻe chzak'zi'b'. Zan shii ba bzaḻa'n ḻeb' lo yi'na' na' ḻekzka' ḻoo nisa'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na' ba jwa'b' lao beṉ'ka' nakgake' li' txen na' bi gok yiyongake'b'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Na' goll Jesúza': ―¡Zi'tegalə c̱helena', le' beṉ' mal na' beṉ' bi chajḻe'! ¿Zi ka'k'tek chiyaḻ' soalen' le'? Na' ¿zi ka'k'tek chiyaḻ' soid' le'? Ḻi da diwa' bi' xkwidaa ni. ");
INSERT INTO zadNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Na'ch bsheshlen Jesúza' dii x̱iwaa yoob' na' bichejan. Na' katena' biyakib'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Na' ka biyoll gok ka', beṉ'ka' nak Jesúza' txen bshaljlengake'ne' to ḻezgake', gollgake': ―¿Bic̱he bi gok yibejnto' dii x̱iwaa yoo bi' xkwidaa? ");
INSERT INTO zadNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Na' goll Jesúza' ḻegake': ―Bi gok yibejlen, ḻa' bi chajḻe'le Chioza' gone' ka yichejan. Dii ḻi nia' le', sheḻ'ka' yeḻ' chajḻe' c̱helena' nakan ḻa'c̱h' ka sa mostásana' daa nak diido'zə, wakte ye'le yaani: “Bkwas ni na' jsoa gan yoblə”, na' wkwasan ka'lə. Aga ga de to dii bi gak gonle sheḻ'ka' chajḻe'le c̱he Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kwenc̱he gak yibejle dii x̱iwaa ka daa bibej' bi' xkwidaa, chiyaḻ' soale wbas' na' soac̱hec̱hle we'ḻwill-le Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Na' shlak chdalen Jesúza' beṉ'ka' nakgake'ne' txen gana' mbani Galileana', golle' ḻegake': ―Nad', Beṉ' Bseḻ' Chioza' Yell-lioni, gak' lo na' beṉ' malka'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Na' witgake' nad', na' ka gak shoṉ lla yiban' ladj beṉ' wetka'. Na' ka golle' ḻegake' ka', ḻe gokyesh'gakile'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na' ka billin Jesúza' len beṉ'ka' nakgake'ne' txen Capernaúma', beṉ' Israelka' beṉ'ka' chc̱hixj c̱he yoodo'na' jawiagake' Pédrona', na' wṉabgakile'ne': ―¿Achyixj maestro c̱helena' daa chidoḻ'cho we'cho c̱he yoodo'na'? ");
INSERT INTO zadNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Na' goll Pédrona' ḻegake': ―Awe, chyixje'n. Na' ka biyoo Pédrona' ḻoo yoona' gana' zoagake', Jesúza' bkwialoe' dillaa chi'e: ―¿Nak ka chakilo', Simón? Beṉ'ka' chṉabia' yell-lioni, ¿abeṉ' wlall c̱he'kan' chc̱hixjgake'?, ¿awa beṉ' zit'kan'? ");
INSERT INTO zadNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Na' billii Pédrona' xtilleena': ―Beṉ' zit'kan' chc̱hixjgake'. Na' goll Jesúza'ne': ―Zejin beṉ' wlall c̱he'ka' bi chonan byen c̱hixjgake'. ");
INSERT INTO zadNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Per kwenc̱he bi wshaachogake', wyaj cho'a nisdo'na' na' wzaḻoo daa chzenilo' beḻa'. Na' beḻ necha' seno' wx̱oo cho'aba' na' ḻoo cho'aba' yillelilo' to mech. Waktekzin lljtixjo' c̱he c̱hoptecho. ");
INSERT INTO zadNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na' do kana'kzə, beṉ'ka' nak Jesúza' txen jabig'gake' kwite'na' che'gake'ne': ―¿Noran nak beṉ' zak'chi ladj beṉ'ka' chṉabia' Chioza'? ");
INSERT INTO zadNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Na' wṉe Jesúza' to bi'do' na' bzie'b' ladje'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Na'ch chi'e ḻegake': ―Dii ḻi nia' le', beena' bi yiyak yic̱hjlall'do'ena' ka c̱he bi'do'ni kwenc̱he iṉabia' Chioza' ḻe', bi ḻene' beṉ'ka' chṉabia' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Daan beena' wḻex̱j yic̱hje' wzenague' c̱he Chioza' ka chḻex̱j yic̱hj bi'do'ni chzenagb' c̱he x̱axṉa'baa, beenan' zak'chi ladj beṉ'ka' chṉabia' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na' beena' wlebe' to bi'do' ka bi'do'ni daa chonḻilallee nad', nad'kzan chlebe'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Nottez beena' wchix̱e' to beṉ' zi' chzolo chonḻilallee nad' gone' dii mala', naklan wen wwaḻ'gake' yene'na' to yaj c̱he molin na' lljḻekgake'ne' yel ḻoo nisdo'na' aga ka daa wchix̱e' beṉ' lao dii mala'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Nyesh'laz c̱he beṉ' yell-lioki!, ḻa' biga iyallji daa gonan ka wx̱iṉj wḻengake'. Per ¡nyesh'lazch gak c̱he beena' gon ka wx̱iṉj wḻen beṉ' yoblə! ");
INSERT INTO zadNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Na' shi noona' wa ṉi'ona' gonan ka ibix̱o' lao dii mala', naklan wen wc̱hogo'n na' c̱hooṉo'n, ḻa' wenchlan bi de noona' tḻaa wa ṉi'ona' tḻaa yillino' kwit Chioza' aga ka daa yiyaj doxentio' lo yi' gabiḻa' daa biga yiyol. ");
INSERT INTO zadNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na' shi daa ile'ilo' kon jalawo'na' gonan ka ibix̱o' lao dii mala', naklan wen wḻec̱hjo'n na' c̱hooṉo'n, ḻa' wenchlan yillinleno' tḻaaz jalawo'na' kwit Chioza' aga ka daa yiyaj doxentio' lo yi' gabiḻa'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Bi gonile nakzi ni to beṉ'ki zi' wzolo chonḻilall' nad'. Ḻa' nia' le', anjl c̱he'ka' toshiizi zoagake' lao X̱a'na', beena' zoa yabana'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ḻa' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, bid' kwenc̱he yisla' beṉ'ka' yoo nez daa wlliayi'n ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Nak chakile? Shi to beṉ' lle' to guiyoa xil' c̱he' na' ṉit tob, ¿abi wkwaaṉe' baka' taplaḻj twaḻj na' shaje' lljadilje' bana' wnit? ");
INSERT INTO zadNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na' shi yillelile'b, ḻech yibaile' c̱heb aga ka c̱he baka' taplaḻj twaḻj baka' lle' tozga. ");
INSERT INTO zadNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ka'kzan X̱acho Chioza' zoa yabana' cheenile' ni to beṉ'ki zi' wzolo chonḻilall' nad' bi kwiayi' sheḻ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Shi to beṉ' nakle txen nonḻilall'le Chioza' gone' to dii mal c̱ho', je'lene' dill' to li' to ḻe' daa bene' c̱ho'. Shi ba bzenague' c̱ho', ba beno' gan bizoaleno'ne' wen. ");
INSERT INTO zadNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Per shi bi wzenague' bin yoone', na'ch wc̱hi'o sto c̱hop beṉ' kwenc̱he gakgake' tasc̱hiw c̱he daa yoone'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na' shi ni ka' bi wzenague' c̱hele, wak ye'le yog' beṉ'ka' nakle txen nonḻilall'le Chioza' ka nak daa ba bene' kwenc̱he we'lengake'ne' dill'. Na' shi ni c̱he beṉ'ka' bi wzenague', na'chan gonilene' ka to beṉ' bi nonḻilall' Chioza' wa ka to beṉ' wic̱hixj. ");
INSERT INTO zadNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Na' dii ḻi nia' le', diika' iṉale bi gon beṉ' yell-lioni, ḻekzka' iṉa Chioza' zoa yabana', na' diika' iṉale wak gon beṉ' yell-lioni, ḻekzka' iṉa Chioza' zoa yabana'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Na' ḻekzka' nia' le', shi c̱hople idiḻi xtill'lena' yell-lioni kat' bi iṉable lao X̱a' Chioza', beena' zoa yabana', na' gone' daa iṉabilene'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ḻa' gana' chdop c̱hope' wa shoṉe' choe'la'ogake' nad', na'kz zoa' ladje'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Na' wbig' Pédrona' kwit Jesúza', chi'ene': ―X̱an', ¿baḻ shii chiyaḻ' yizi'xen' c̱he bish' ljwellaa shi bi dii mal chone' c̱ha'? ¿Azeelo gall shii? ");
INSERT INTO zadNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Na' che' Jesúza'ne': ―Aga nia' li' zeelo gall shii yizi'xeno' c̱he bish' ljwello'na', san nia' li' chiyaḻ' yizi'xeno' guiyon shin'c̱hopə shii. ");
INSERT INTO zadNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Yeḻ' wṉabia' c̱he Chioza' zaklebin to beṉ' wṉabia' beena' bizi' kwent c̱he mecha' daa chaḻ' wen llin c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Na' ka wzoloe' chizi'e kwent c̱he to toe', jwa'gake' to wen llin c̱he'na' beena' chaḻ' dii xen inlleb. ");
INSERT INTO zadNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Per aga bi mech nap beena' kwenc̱he yiyixje' daa chbaguee, na' x̱ane'na' bene' mandad wit' wdegake'ne' do xiiṉ do xoole' na' yog'ḻoḻ dii de c̱he' kwenc̱he yiyaxj xyana' daa llie'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Na' beena' chbag' mecha' bc̱hek' xibe'na' lao x̱ane'na', chonyeshee, chi'e: “X̱an', wdapgach yeḻ' chxenlall' c̱ha', wiyixjkz' doxen daa chbagaa c̱ho'.” ");
INSERT INTO zadNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Na' x̱ane'na' biyeshile'ne', na' bene' ka'z doxen daa chaḻee c̱he', na' bisane'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Per ḻe', ka bicheje' lill x̱ane'na', billague' sto wen llin beṉ' chaḻ' lat'do' xmeche', na' lii bṉiztie' yene'na' chi'ene': “¡Biyoṉ xmechaa daa chaḻoo!” ");
INSERT INTO zadNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Na' bc̱hek' xib beena' lawe'na' na' chonyeshee, chi'ene': “Wdapgach yeḻ' chxenlall' c̱ha', wiyixjkz' doxen daa chbagaa c̱ho'.” ");
INSERT INTO zadNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Na' bi goonile', san lii wyajtie' ji'ene' part kwenc̱he wloogake'ne' lillyana' ax̱t ki yiyixjche' doxen daa chaḻee c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Na' ka ble'i wen llinka' sto ka bene', na' gokyesh'gakile' na' jayellgake' x̱ane'ka' doxen ka bene'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Na' wizax x̱ane'na' ḻe', chi'ene': “Beṉ' mal inlleb nako'. Nad' ben' ka'z doxen daa chaḻoo c̱ha' daa benyeshoo lawa'. ");
INSERT INTO zadNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ka'kzan nan chiyaḻ' yiyeshilo' bish' ljwello'na' chaḻ' c̱ho', ka biyeshid' li'.” ");
INSERT INTO zadNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Na' daa ḻe bllaachga x̱ane'na', bene'ne' lo na' beṉ'ka' wdix̱jgake'ne' lillyana' na' wit c̱hingake'ne' ax̱t ki yiyixjche' doxen daa chaḻee. ");
INSERT INTO zadNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Na'ch goll Jesúza' ḻegake': ―Ka'kzan goni X̱a'na' beena' zoa yabana' le' shi bi si'xen c̱he ljwell-le do yic̱hj do lall'le. ");
INSERT INTO zadNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Na' ka biyoll be' Jesúza' dill'ki, bizee Galileana' na' biyaje' gana' mbani Judeana' daa llia shḻaa yao Jordánna'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Na' beṉ' zan zjanogake'ne', na' na' biyone' beṉ'ka' bi shao'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na' wbig' baḻ fariseoka' lao Jesúza' daa goklall'gake' wi'e dill' dii wchix̱a'n ḻe', na' che'gake'ne': ―¿Ade lsens yiḻaa xool beṉ' ni c̱he bizə diido' chone' dii bi chiyoolallee? ");
INSERT INTO zadNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Na'ch che' Jesúza' ḻegake': ―¿Abiṉ' wlable gana' nan ka wxe wzil yell-lioni Chioza' bene' beṉec̱ha', beṉ' byo na' noolə? ");
INSERT INTO zadNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na' wne': “Daan, wḻaa beṉ' byona' x̱axṉeena' kat' ikaa c̱he', na' soalene' xoole'na' gakgake' toz.” ");
INSERT INTO zadNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Na' bich nakgake' c̱hop, san ba nakgake' toz. Na' daan bi chiyaḻ' yiḻaa xool beṉ', ḻa' Chiozan' ba btiḻe' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Na' gollgake'ne': ―Na' ¿bic̱he ben dii Moiséza' mandad kat' to beṉ' yiḻaa xoole'na' chiyaḻ' wḻise' to yish dii we'n dill' bich nake' xoole' na' wak yichooṉe'ne'? ");
INSERT INTO zadNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Na' goll Jesúza' ḻegake': ―Yeḻ' widenag c̱helenan' be' dii Moiséza' latj yiḻaa xool-lena'. Per ka ben Chioza' beṉ' nechka', bi gokan ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nad' nia' le', shi nool c̱helena' bi chdalene' beṉ' yoblə, bi chiyaḻ' yiḻaalene' na' yikaale nool yoblə, ḻa' shi ka' gonle, na' chonle ka beena' zoalente xoole'na' na' chdalene' noolə yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Na' beṉ'ka' nakgake'ne' txen gollgake'ne': ―Shi ka' nak c̱he beena' chshagna', naklan wen kono wshagna'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Na' goll Jesúza' ḻegake': ―Aga yog' beṉ' chajni'gakile' dga, ḻete beṉ'ka' chon Chioza' ka shajni'gakile'n. ");
INSERT INTO zadNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ḻa' de dii chllonan wshagna' beṉ'. Baḻ beṉ' bi chshagna'gake' daa bi nak kwerp c̱he'ka' wen ka chaljtegake', na' zi baḻe' bi chshagna'gake' daa bx̱iṉj beṉec̱ha' kwerp c̱he'ka'. Na' zi baḻe' bi chshagna'gake' daa cheenchgakile' gongake' xshin Chioza'. Beena' wlebe' dga, na' gonin c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na' wyaj beṉ' jwa' bi'do' c̱he'ka' lao Jesúza' kwenc̱he wx̱oa neena' yic̱hjb'ka' na' we'ḻwille' Chioza' ni c̱hegakb'. Per beṉ'ka' nakgake'ne' txen bsheshlengake' beṉ'ka' zjwa' bi'do'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Na' goll Jesúza' ḻegake': ―Ḻi we' latj yid bi'do'ki lawa'ni, bi wllonle, ḻa' Chioza' chṉabi'e ḻoo yic̱hjlall'do' beṉ'ka' nak ka ḻegakb'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Na' ka biyoll bx̱oa na' Jesúza' yic̱hj bi'do'ka', na'ch bizee ziyaje' gan yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Na' bllin to bi' wew' lao Jesúza' che'b' ḻe': ―Maestro, ¿bi dii wennan' chiyaḻ' gon' kwenc̱he gat' to yeḻ' mban c̱ha' zejḻi kaṉi? ");
INSERT INTO zadNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Na'ch goll Jesúza' ḻeb': ―¿Bic̱he chṉabzilo' nad' c̱he daa nak wen? Toz Chioza' nake' beṉ' wen. Na' shi cheenilo' gat' to yeḻ' mban c̱ho' zejḻi kaṉi, chiyaḻ' gono' diika' bllia Chioza' bia' goncho. ");
INSERT INTO zadNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Na' goll bi' wewaane': ―¿Bera diika' chiyaḻ' gon', lla? Na' che' Jesúza': ―Bi wito' beṉ', bi soaleno' nool bi nak nool c̱ho', bi kwano' bi de c̱he beṉ', bi c̱hiljlalloo bizə gon iṉo' c̱he beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Wdap balaaṉ x̱axṉoona' na' goki bish' ljwello'na' ka chaki kwino'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Na' che' bi' wewaane': ―Yog' diika' chon' kana' naktia' bi'do'. ¿Berachan ni chyallj gon'? ");
INSERT INTO zadNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Na' goll Jesúza' ḻeb': ―Shi lekzilo' cheenilo' gako' dowalj beṉ' ḻi beṉ' shao', biyaj jayet' yog' dii de c̱ho' na' xmechinna' wyoon beṉ' yesh'ka', na' yido' gono' nad' txen. Na' kat' yillino' yabana' na' goṉ Chioza' li' yeḻ' shawaa. ");
INSERT INTO zadNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Na' ka beni bi' wewaa dga, nyesh' inlleb gokib' na' biza'b', ḻa' bi' wni'a nlleban nakb'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Na' goll Jesúza' beṉ'ka' nakgake'ne' txen: ―Dii ḻi nia' le', lallj inlleb chonan c̱he beṉ' wni'ana' yilline' yabana' gana' chṉabia' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sto shii nia' le', ḻobe'ch te to kamey to xan yesh' aga ka to beṉ' wni'a yilline' yabana' gana' chṉabia' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Na' bibangakile' ka wne', na' che' ljwellgake': ―¿Notg gak yillin lao Chioza', shka'? ");
INSERT INTO zadNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Na' bwia Jesúza' ḻegake', na' golle': ―Ni to beṉ' yell-liona' bi gak gone' dga, san Chioza' yog'ḻoḻte chak gone'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Na' che' Pédrona'ne': ―Neto' ba wlej yic̱hjnto' yog' dii de c̱hento' kwenc̱he naknto' li' txen. ¿Bin gonnto' gan? ");
INSERT INTO zadNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Na' che' Jesúza' ḻegake': ―Dii ḻi nia' le', kat' illin lla yikob yog'ḻoḻ dii de, nad', Beṉ' Bseḻ' Chioza' Yell-lioni, kwi'a iṉabi'a gana' sho'a balaaṉ xen wal, na' le', shlliṉtele, nakle nad' txen kwe'le kwitaa kwenc̱he iṉabia'lenle nad'. Na' yizi'le kwent shlliṉ kwente yell c̱he beṉ' Israelka'. ");
INSERT INTO zadNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na' nottez beena' ba wlej yic̱hje' lille'na', beṉ' bisheeka', beṉ' zane'ka', x̱axṉeeka', wa xiiṉ xoole', wa yell-lio c̱he' ni c̱ha', Chioza'kzə wi'ene' dii zak' dii xen inllebch aga ka daa wlej yic̱hje', na' ḻekzka' wi'ene' to yeḻ' mban zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Per beṉ' zan nakgake' beṉ' zakii, wllin lla bich bi sak'gake', na' beṉ' zan bi nakgake' beṉ' zakii, wllin lla gakgake' beṉ' zakii. ");
INSERT INTO zadNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Na' wna Jesúza': ―Yeḻ' wṉabia' c̱he Chioza' chzaklebin daa gok c̱he to x̱an yell-lio beena' naz yag uvana'. Na' shzildo' wzee zeje' zjtilje' wen llinka' kwenc̱he lljengake' llinna' gana' naze' yag uvaka'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Na' bgaaṉgake' dill' c̱hixje' ḻegake' c̱he lla, na'ch bseḻee ḻegake' gana' lljengake' llinna'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Na' ba gok shoṉ gor chon beṉ' nechka' llinna' ka wyaje' dii yoblə gana' chak yaana', na' ble'ile' lle' beṉ' bibi llin de gongake'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Na'ch chi'e ḻegake': “Ḻi shaj ḻi lljen llinna' gana' naz' yag uvana' na' c̱hixj' le' daa chidoḻ'le.” Na' wza'gake' zejgake' llinna'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Na' do ka gobill wizaje' dii yoblə, na' ḻekzka' chida shoṉə, bizllelile' beṉ' yoblə lljengake' llin c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na' do ka chida gay', wizaje' dii yoblə na' bizle'ile' beṉ' lle'zgake'. Na'ch chi'e ḻegake': “¿Bic̱he bi benle llinna' ṉaanlla?” ");
INSERT INTO zadNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Na' goll beṉ'ka'ne': “Ḻa' ni to kono bc̱he' neto' llinna'.” Na' golle' ḻegake': “Ḻi shaj, lla, ḻi lljen llinna' gana' naz' yag uvana'.” ");
INSERT INTO zadNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Na' ka wzeḻes yela' na' che' x̱an yag uvana' beena' ngoo lo nee llinna': “Biyax wen llinka' na' wdixjgake'. Zigaate beṉ'ka' zi' wyoo llinna' c̱hixjo', na' yiyoll-lin beṉ'ka' wzolo nech.” ");
INSERT INTO zadNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Na' bene' kon ka goll x̱ane'na', na' wdixje' zigaate beṉ'ka' wyoo llinna' do ka chida gay'. Na' wdixje' to toe' c̱he llakzə. ");
INSERT INTO zadNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na' ka goḻ' c̱hixje' beṉ'ka' wyoogake' llinna' shzildo', gokgakile' wx̱oache' laxje'ka'. Per bich bi bx̱oe' san c̱he llachokzə wdixje' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Na' ka ba nox̱'gake' laxje'ka', wzologake' biz chon chnagake' c̱he x̱an llinna', ");
INSERT INTO zadNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","na' gollgake'ne': “Do lla wzento' lo bana' bennto' xshino'na' na' toz ka wdixjo' neto' len beṉ'ka' zi' wyoo, na' zi' tgorchga bengake' llinna'.” ");
INSERT INTO zadNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Na' che' x̱an llinna' toe': “Bish'dawaa, aga bi laxjo' chzeshaa. ¿Aaga bgaaṉcho dill' c̱he llan c̱hixj' li'? ");
INSERT INTO zadNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Wkaa laxjo'na', na' biyaj. Nad' cheenid' c̱hixj' beṉ'ka' wyoo llinna' ba wlle'ch ka to daa ba wkoo. ");
INSERT INTO zadNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Jwayishaz nad' bi gonid' xmechaa. ¿Anti chakziilo' daa chonid' beṉ' wen?” ");
INSERT INTO zadNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Na' ka wde bzoa Jesúza' jempli, na' chi'e beṉ'ka': ―Ka'kzan beṉ' zan nakgake' beṉ' zakii, wllin lla bich bi sak'gake', na' beṉ' zan bi nakgake' beṉ' zakii, wllin lla gakgake' beṉ' zakii. ");
INSERT INTO zadNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ka ziyaj Jesúza' Jerusalénna' wṉie' to beṉ'ka' shlliṉzə, chi'e: ");
INSERT INTO zadNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Ṉaa ba ziyajcho Jerusalénna', gana' gongake' nad', Beṉ' Bseḻ' Chioza' yell-lioni, lo na' bx̱ozka' chṉabia' na' lo na' beṉ'ka' chli' chsedi leya', na' wc̱hoglogake' witgake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na' gongake' nad' lo na' beṉ'ka' bi nak beṉ' Israel kwenc̱he wtitjgakile' nad' na' wit c̱hingake' nad', na'tech wda'gake' nad' ḻee yag cruza', per ka gak shoṉ lla yiban' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Na' Jacóbona' len Juanna', beṉ'ka' nak xiiṉ Zebedewa', wbig'lengake' xṉeeka' kwit Jesúza', na' xṉeeka' bc̱hek' xibe'na' lawe'na' wṉabile'ne' to goklen. ");
INSERT INTO zadNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Na' goll Jesúza'ne': ―¿Bera goklenan cheenilo' gon' c̱ho'? Na' golle'ne': ―Cheenid' gongacho' goklen kweko' bi' c̱ha'ki shḻaa wej kwito'na' kat'ka' illin lla iṉabi'o. ");
INSERT INTO zadNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Na' goll Jesúza'ne': ―Ni bi ṉezile bin chṉable. ¿Awizoile wtiḻ-le yeḻ' zak'zi'na' ka daa wtiḻ' na' gak c̱hele ka daa gak c̱ha'? Na' gollgake'ne': ―Wizokzinto'n. ");
INSERT INTO zadNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Na' goll Jesúza' ḻegake': ―Lekzile wtiḻ-le ka daa wtiḻ', na' gak c̱hele ka daa gak c̱ha', per daa nale kwe'le shḻaa wej kwitaa bi nak lo na' gon' ka nale, san X̱a'nan' ba mbeje' beṉ'ka' wi'en. ");
INSERT INTO zadNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Na' beṉ'ka' zi shi, bllaagake' Juanna' len Jacóbona' daa wṉabgake' kwe'gake' kwit Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Na' bitop Jesúza' ḻegake', na' chi'e: ―Ṉezkzile zoa beṉ' wṉabia' na' beṉ' zakii c̱he to to yell na' chongakile' kon daa nazan c̱hegake' beṉ' yell c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Per aga kan' chiyaḻ' gonle. Shi nole cheenile gakle beṉ' mbejlawin chiyaḻ' gakle ka to beṉ' chon xshin beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na' shi nole cheenile gakle beṉ' zakii, chiyaḻ' gakle ka beṉ' ndoo lla yel chone' xshin beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ka nak nad', Beṉ' Bseḻ' Chioza' Yell-lioni, aga bid' kwenc̱he gaklen beṉ' nad', san bid' kwenc̱he gaklen' beṉ' na' wi'a yeḻ' mban c̱ha'ni kwenc̱he yisla' beṉ' zan lao saaxya c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Na' ka biza' Jesúza' yell Jericóna' len beṉ'ka' nakgake'ne' txen, beṉ' zan inlleb janogake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na' cho'a neza' chi' c̱hop beṉ' lc̱hoḻ, na' ka bengakile' bide Jesúza' kwite'ka' na'ch besyaagake', che'gake': ―¡X̱an', xiiṉ dia c̱he dii Daví, biyesh'lall'gachi neto'! ");
INSERT INTO zadNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Na' beṉ'ka' zejlen Jesúza' bsheshlengake' ḻegake' kwenc̱he nan kwe'gake' lliz, per ziziklə besyaachgake', che'gake': ―¡X̱an', xiiṉ dia c̱he dii Daví, biyesh'lall'gachi neto'! ");
INSERT INTO zadNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Na'ch wlez Jesúza' na' wṉie' beṉ' lc̱hoḻka', na' chi'e ḻegake': ―¿Beran cheenile gon' c̱hele? ");
INSERT INTO zadNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Na'ch che' beṉ' lc̱hoḻka'ne': ―X̱an', bengach ka ile'into'. ");
INSERT INTO zadNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Na' biyesh'lallii Jesúza' ḻegake' na' bex̱ee jalawe'ka'. Na' katena' gok ble'gakile' na' janogake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na' ka ba zoa yillingake' Jerusalénna', bllingake' cho'a yell Betfagéna' daa llia kwit Yaa Olívoza'. Na' wlej Jesúza' c̱hop beṉ'ka' nakgake'ne' txen na' bseḻee ḻegake' yella'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Na' chi'e ḻegake': ―Ḻi shaj yella' daa llia shḻaana'. Na' ile'ile to burr ba noolə da'b yag na' nc̱he' to xiiṉdo'b. Na' wsell-leb wc̱he'legakb nilə. ");
INSERT INTO zadNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na' shi no bi iṉa le', na' ye'lene': “X̱annto'nan' chyalljile' ḻegakb, na' lii yidsantento'gakb.” ");
INSERT INTO zadNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Na' daa gok ka', billinin ka bzej dii beena' wdix̱jee daa goll Chioza'ne' daa wne': ");
INSERT INTO zadNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ḻi ye' beṉ'ka' lle' yell Siónna': “Ḻi wwia, ba za' beṉ' wṉabia' c̱helena', nake' beṉ' gax̱jlall' na' llie' to burrdo'; xiiṉ to ba choa' yoa'.” ");
INSERT INTO zadNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na' wza' beṉ'ka' nakgake'ne' txen zejgake' yelldo'na' gana' bseḻ' Jesúza' ḻegake' na' bengake' kon ka golle' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Na' jx̱i'gake' burra' len xiiṉba' na' bc̱he'gake' ḻegakb kwit Jesúza'. Na'ch bx̱oagake' xe'ka' koll'bka', na'ch wllia Jesúza'b zeje' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Na' beṉ' zan wdix̱jgake' xe'ka' tneza', na' zi baḻe' bc̱hoggake' no zin na' wdix̱jgake'n tneza' gana' zeje'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na' beṉ'ka' llialo lao Jesúza', na' ka'kzə beṉ'ka' nogake'ne', wzologake' chosyaagake', nagake': ―¡We'la'ocho beeni nak xiiṉ dia c̱he dii Davina'! ¡Gonḻeeyshga X̱ancho Chioza' beeni ba bseḻee! ¡Ḻi da we'la'ocho Chioza' zoa yabana'! ");
INSERT INTO zadNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Na' ka wyoo Jesúza' yell Jerusalénna', na' yog' beṉ'ka' lle' na' bllesh bcheeṉgake', nagake': ―¿Noraz beeni bla' ni, lla? ");
INSERT INTO zadNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Na' beṉ'ka' che'gake': ―Beenin Jesúza' beṉ' Nazareta' yell daa mbani Galileana', beena' chyix̱jee daa che' Chioza'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Na' wyoo Jesúza' lesh' chyoodo'na' na' bisheshe' yog' beṉ'ka' chit' chde na'. Na'ch bishi'e mes c̱he beṉ'ka' chsha' mecha' na' bzoles bzolline' gana' chi' beṉ'ka' chit'gake' palomka'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Na' ka wde bene' ka' chi'e ḻegake': ―Cho'a xtill' Chioza' nan: “Lillaa nakan ga choe'ḻwill beṉ' nad'”, na' le', ba nonzlen ka to ga chdop chllag wban. ");
INSERT INTO zadNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na' shlak zoa Jesúza' yoodo'na', baḻ beṉ' lc̱hoḻ na' beṉ' bi chak sa'gake' wen bllingake' lawe'na', na' biyone' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Na' bx̱ozka' chṉabia' na' beṉ'ka' chli' chsedi leya' ḻe bllaagake' ka ble'gakile' yeḻ' wakka' chon Jesúza', na' bengakile' chosyaa bi'do'ka' lesh' chyoodo'na', che'gakb': “¡We'la'ocho beeni nak xiiṉ dia c̱he dii Davina'!” ");
INSERT INTO zadNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Na' gollgake' Jesúza': ―¿Achenilo' ka na bi'do'ka'? Na' chi'e ḻegake': ―Awe, chenkzid'. ¿Abiṉ' wlable Cho'a Xtill' Chioza' gana' na: Chc̱hino' cho'a ḻoll' bi' xkwid'do'ka' na' bdo'ka' ni chall' chxop kwenc̱he choḻ chṉegakb' li' ka chiyaḻ' we'la'o beṉ' li'? ");
INSERT INTO zadNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Na'ch bicheje' ladj beṉ'ka', na' bizee yell Jerusalénna' ziyaje' yell Betániana' gana' wdie' yel. ");
INSERT INTO zadNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na' betiyo biza'gake' shzildo' yell Betániana' kwenc̱he biyajgake' yell Jerusalénna' dii yoblə, na' tneza' wzolo chdon Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Na' ble'ile' to yag yix̱wew dii zoa cho'a neza', na' jawie' shi llian. Per zeelo xḻaguiinna'z llia. Na' golle'n: ―¡Batch kwio' yix̱wewa'! Na' katena' lii wbillte yaga'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Na' ka ble'i beṉ'ka' nakgake'ne' txen ka gok, ḻe bibangakile', na' che'gake'ne': ―¿Berac̱he lii wbilltelikazə yag yix̱wewa'? ");
INSERT INTO zadNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Na'ch che' Jesúza' ḻegake': ―Dii ḻi nia' le', shi nonḻilall'le Chioza' na' bi gakc̱hoplall'le, aga daazan gak gonle, san wakte ye'le yaani: “Bkwas, na' jsoa ḻoo nisdo'na'”, na' gak ka ye'len. ");
INSERT INTO zadNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na' yog' daa iṉabile Chioza' ka we'ḻwill-lene' goṉkze'n kon shi nonḻilall'lene'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na' wyaj Jesúza' dii yoblə yoodo'na' kwenc̱he jali' jasedile' beṉ'ka'. Na' shlak chli' chsedile' ḻegake', bx̱ozka' chṉabia' na' beṉ' golka' chṉabia' beṉ' Israelka' bllingake', na' che'gake'ne': ―¿Nora lsens c̱heyi chono' diiki? ¿No beṉ li' yeḻ' wṉabia'na'? ");
INSERT INTO zadNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Na' goll Jesúza' ḻegake': ―Ḻekzka' de to dii cheenid' iṉabid' le'. Na' shi le' iṉale nad' daa iṉabid' le', na' iṉia' le' no lsens c̱heyi chon' yog' diiki. ");
INSERT INTO zadNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ḻi iṉashki nad', ¿noran bseḻ' Juanna' kwenc̱he bidchoe' beṉ' nisa'? ¿AChioza' anti beṉ' yell-lioni? Na' wzologake' chakguedgake' to ḻezgake', nagake': ―Shi ye'chone' Chioza' bseḻeene' na'ch iṉe' cho': “¿Bic̱he bi wyajḻe'le c̱he', lla?” ");
INSERT INTO zadNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na' shi ye'chone' beṉ' yell-liona' bseḻee Juanna', ḻe xoll bi goni beṉ'ki cho', ḻa' yog'ḻoḻe' chajḻe'gake' Chioza' bseḻee Juanna' kwenc̱he bidtix̱ji'e daa golle'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Na'ch che'gake' Jesúza': ―Bi ṉezinto' non bseḻ' dii Juanna'. Na' goll Jesúza' ḻegake': ―Ḻekzka' nad', aga wnia' le' nora lsens c̱heyin chon' diiki. ");
INSERT INTO zadNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Na' goll Jesúza' ḻegake': ―¿Bi ka iṉale c̱heyi dga wseesaa? To beṉ' zoa c̱hop xiiṉe', na'ch golle' bi'na' to: “Xiiṉdawaa, wyajgach jen llinna' gana' nazcho yag uvana'.” ");
INSERT INTO zadNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Na' che' xiiṉe'na'ne': “¡Bi sha'!” Per na'tech biyajib' na' wyajkzb' jem' llinna'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Na' wyaj x̱abaa jelle' bi'na' sto ka golle' bi' bish'baa, na'ch goll bi'na'ne': “Wakkzə x̱a, na' sha'.” Per bi wyajb'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ḻi iṉashki, ¿nora bi'ka' c̱hop ben ka cheeni x̱ab'ka'? Na' goll beṉ'ka'ne': ―Bi'na' golle' ka' dii nech. Na'ch che' Jesúza' ḻegake': ―Dii ḻi nia' le', beṉ' wic̱hixjka' na' noolə wdaka', ḻelgaken' zigaate we'gake' latj iṉabia' Chioza' ḻegake' aga ka le'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ḻa' ka bid Juanna' bchoe' beṉ' nisa', bidzajniile' le' ka chiyaḻ' soa kwezle, per le' aga wyajḻe'le c̱he', ḻete beṉ' wic̱hixjka' na' nool wdaka'chgan wyajḻe'gake' c̱he'. Na' le' ṉaalla, ḻa'kzi gokbe'ile ba chajḻe'gake' c̱he', aga biyaj bileni saaxya c̱heleka' na' shajḻe'le c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Ḻi wzenag jempli sto. Wzoa to beṉ' biyaze' yag uva lo yell-lio c̱he'na' na'ch wlo'en leej, na'tech benshawee to ga wsigake' uvaka'. Na' ḻekzka' bene' to yoo sibə gana' kwia beena' gap wwie'n. ’Na'tech bene'n lo na' to c̱hop beṉ' na' wzee zeje' zit'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Na' ka goḻ' yishibgake' uvaka', na'ch bseḻee to c̱hop wen llin c̱he'na' gana' lle' beṉ'ka' chapgake' yag uvaka' kwenc̱he lljaxi'gake' uvaka' daa chidoḻee. ");
INSERT INTO zadNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Per ka bllingake' gana' lle' beṉ'ka' chapgake' yag uvaka', na'ch bex̱'gake' beṉ'ka' bllin, toe' bet wdingake'ne', na' stoe' bettekzgake'ne' na' beena' sto btakwgake'ne' yaja'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Na'ch bseḻ' x̱an yag uvaka' zanch wen llin c̱he'ka' aga ka to beṉ'ka' bseḻee dii nech, per beṉ'ka' chap yag uvaka' bengakile' ḻegake' ka bengakile' beṉ' nechka' bllin. ");
INSERT INTO zadNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Na'ch x̱an yag uvaka' bseḻee kwinkz xiiṉe'na', chakile': “Wapgake' balaaṉ bi' c̱ha'ni na' we'gake'b' daa chidoḻaa.” ");
INSERT INTO zadNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Per beṉ'ka' chap yag uvaka' ka ble'gakile' xiiṉe'na', na'ch che' ljwelle': “Bi'nin xiiṉ x̱an yag uvaki na' ḻeban' yigaaṉlem' yog' dii nape'. Ḻi da witchob' kwenc̱he yigaaṉlencho daa gaki c̱heb'.” ");
INSERT INTO zadNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Na'ch bex̱'gake'b' bibejgake'b' gana' lle' yag uvaka' na' betgake'b'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Na' Jesúza' chi'e beṉ'ka' lle' na': ―¿Nakra ka chakile gon x̱an yag uvaka' c̱he beṉ'ka' chapgake'n ka illine' kwine'? ");
INSERT INTO zadNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Na' che' beṉ'ka': ―Ba nakten wite' ḻegake' na' bi yiyeshile' ḻegake' daa nakgake' beṉ' mal. Na' yiyone' yell-lio c̱he'na' lo na' beṉ' yoblə, beṉ' yiyoe'gake'ne' daa chidoḻee kat' yishibgake'n. ");
INSERT INTO zadNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Na' goll Jesúza' ḻegake': ―¿Abigaṉ' wlable Cho'a Xtill' Chioza' gana' na: Yaja' daa bi wyoolall' wen yooka', ḻeyeṉ'lannan' yaja' daa ba nc̱hejcha yoona'. Dgan ben X̱ancho Chioza' na' nakan to dii yibanicho? ");
INSERT INTO zadNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Daan nia' le', kon ka gon x̱an yag uvaka' yiyone' yell-lio c̱he'na' lall' na' beṉ' yoblə, beṉ' gongake' ka cheenile', ka'kzan gon Chioza' c̱hele. Kwej yic̱hje' le', na' beṉ'ka' wzenaggake' c̱he', si'gake' banez yeḻ' wṉabia' c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Na' ka nak yaja', nottezə beṉ' lljc̱haze' lawinna' kwiayee, na' shi idakwan beṉ', ax̱t wshoshjan ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na' ka biyoll bzenag bx̱ozka' chṉabia' na' fariseoka' jemplki bzoa Jesúza', na'ch gokbe'gakile' c̱hegake'n chṉie'. ");
INSERT INTO zadNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Na'ch goklall'gake' gox̱'gake'ne', per bi biyaxjgakile', ḻa' bllebgake' beṉ'ka' lle' na' daa chajḻe'gake' Jesúza' nake' to beṉ' chyix̱jee daa che' Chioza'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Na' Jesúza' bseesile' ḻegake' sto jempl, chi'e: ");
INSERT INTO zadNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Yeḻ' wṉabia' c̱he Chioza' chzaklebin to beṉ' wṉabia', beṉ' bene' to lṉi c̱he xiiṉe'na' ka bshagna'b'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Na' bseḻee wen llin c̱he'ka' lljaṉegake' beṉ'ka' ba bye', per beṉ'ka' bye' bi goongakile' shajgake'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Na'ch bizseḻee zi shkwen wen llin c̱he'ka' chi'e ḻegake': “Ḻi lljell beṉ'ka' ba bya' yid lṉi c̱he bi' c̱ha'na' ba de daa gaocho. Ba betgake' gooṉ c̱ha'ka' na' nochlə baka' ḻe nak, na' ba de yeḻ' wawa'. Ḻi lljellgake' yidgake' kwenc̱he yeej gaocho.” ");
INSERT INTO zadNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Per beṉ'ka' ba bye' bi bengake' kwent daa goll wen llinka'. Toe' wyaj jawia' yell-lio c̱he'na' na' stoe' wzee zeje' delgens c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Na' beṉ'ka' sto bex̱'gake' wen llinka' na' biya dii bengakile' ḻegake' ax̱t ka witgake'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Na' ḻe bllaachga beṉ' wṉabia'na', na'ch bseḻee soldad c̱he'ka' kwenc̱he jetgake' ḻegake' na' bzeygake' yell c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Na'ch chi'e wen llin c̱he'ka' sto: “Ba gok daa yeej gaocho, na' wentelan bi wlen beṉ'ka' bya'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Na' ḻi shaj lyell na' ḻi wc̱he' kon no beṉ' yillagle tneza' kwenc̱he yidgake' yeej gaogake'.” ");
INSERT INTO zadNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Na'ch wza' wen llinka' zejgake', na' jx̱i'gake' kon no beṉ' billaggake', ka beṉ' wen ka beṉ' mal. Na' billa'cha lill beṉ' wṉabia'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Na' ka wyoo beṉ' wṉabia'na' chwie' beṉ'ka' ba ndop nllag, na' ladj beṉ'ka' len to beṉ' bi nakw xe'na' daa chiyaḻ' gakwe' gana' chak wishagna'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Na' goll beṉ' wṉabia'na'ne': “Bish'dawaa, ¿nakra gok wyoozo' na' bi nakw xo'na' daa chiyaḻ' gako' kwenc̱he ḻeno' gani chak wishagna'ni?” Na' beena' bikzə bi billel-lallee yeene'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Na'ch che' beṉ' wṉabia'na' beṉ'ka' chde yeḻ' wawa': “Ḻi wc̱hej ṉi'a na' beeni na' ḻi yibeje' na' ḻi wzaḻee gana' shgasj shc̱hoḻ, gana' kwellyeshee na' gaox̱ax̱j ḻeye'na' daa ḻe gakshejlallee.” ");
INSERT INTO zadNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ḻa' beṉ' zan nak beṉ'ka' chax chṉab Chioza', per baḻchgagake' kweje' gakgake' lall' nee. ");
INSERT INTO zadNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na' biza' fariseoka', na' wloogake' xṉezi naklə gongake' kwenc̱he we' Jesúza' dill' dii wchix̱a'n ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Na'ch bseḻ'gake' baḻ beṉ'ka' nakgake'ne' txen na' zi baḻ beṉ'ka' nak Heródeza' txen kwenc̱he wyajgake' lao Jesúza' na' jellgake'ne': ―Maestro, ṉezinto' nako' beṉ' ḻi beṉ' shao' na' chli' chsedilo' beṉ' c̱he nez ḻi c̱he Chioza' kon ka nakan, na' bi chshoo cho'a xtilloona' lao nottezə beṉ', ḻa' bi chwio' no nakgake'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Daan cheeninto' iṉagacho' neto' nak ka chakilo': ¿Achiyaḻ' c̱hixjcho daa chṉab beṉ' wṉabia' Césara', anti bi chiyaḻ' c̱hixjchon? ");
INSERT INTO zadNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Na' gokbe'i Jesúza' aga do lall'gaken' gollgake'ne' ka', na'ch chi'e ḻegake': ―Le' beṉ' wxiye', aga dii leilen nale ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ḻi wli'shki nad' to mech daa chyixjile beṉ' wṉabia'na'. Na' be'gake'ne' to mech. ");
INSERT INTO zadNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Na' goll Jesúza' ḻegake': ―¿Nora cho'alawin na' no leyin da' ḻee mechi? ");
INSERT INTO zadNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Na'ch che'gake'ne': ―C̱he beṉ' wṉabia', Césaran'. Na' che' Jesúza' ḻegake': ―Na'len, ḻi we' Césara' daa naki c̱he', na' ḻekzka' ḻi we' Chioza' daa naki c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Na'ch bibangakile' daa goll Jesúza' ka'. Na' biza'gake' kwite'na' ziyajgake'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na' lo llana'kzə saduceoka', beṉ'ka' bi chajḻe'gake' yiban beṉ' wetka', wyajgake' lao Jesúza', na' wṉabgakile'ne': ");
INSERT INTO zadNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestro, dii Moiséza' wne' shi to beṉ' byo guete' na' kono xiiṉe' wzoa, beṉ' bisheena' chiyaḻ' yikee xool dii beṉ' bisheena' kwenc̱he soa xiiṉ dia c̱he dii beṉ' weta'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na' ki gok c̱he gall bish' beṉ' nakgake' neto' txen. Beṉ' necha' bshagnee, na' wite' na' kono xiiṉe' wzoa, na' beṉ' bishee, beṉ' wchopina', bikee xoole'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na' ḻekzka' wit beṉ' wchopina' na' kono xiiṉe' wzoa. Na' ka'kzə wit beṉ' wyoṉina' na' ax̱t biyate beṉ'ka' gall wit. Na' ni togake' bi wzoa xiiṉgake'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Na' ka wde wit yog'ḻoḻe' na'ch ḻekzka' wit noola'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na' kat' yiban beṉ' wetka', ṉaa, ¿nora beṉ'ka' gall bish' gaki xoole' noola'? ḻa' yog'ḻoḻen' wkaagake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Na'ch che' Jesúza' ḻegake': ―Nakllejzilen daa bi ṉezile ka na Cho'a Xtill' Chioza', na' ka nak yeḻ' wak c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ḻa' kat' yiban beṉ' wetka', koch no yikaa ljwellin, ni koch no wit' wde xiiṉin, san yiyakgake' ka anjlka' lle' yabana'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na' ka nak daa yiban beṉ' wetka', ṉaa, ¿abiṉ' wlable daa wna kwin Chioza', gana' nan: ");
INSERT INTO zadNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nad nak' Chios c̱he Abrahama', Isaaca' na' Jacoba'”? Na' bi nake' Chios c̱he beṉ' wet, san nake' Chios c̱he beṉ' ban, ḻa' lao Chioza' mban beṉ'ki. ");
INSERT INTO zadNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Na' ka beni beṉ'ka' lle' na' daa wna Jesúza', ḻe bibangakile' ka chli' chsedile'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ka wṉezi fariseoka' ba wleklli Jesúza' saduceoka', na'ch wyajgake' kwite'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na' to beena' chli' chsedi leya' wṉabile' Jesúza' kwenc̱hezə wchix̱eene', chi'e: ");
INSERT INTO zadNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ¿beran llialote nllia leya' bia' goncho? ");
INSERT INTO zadNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Na' Jesúza' golle'ne': ―“Chiyaḻ' gakilo' X̱ancho Chioza' do yic̱hj do lalloo na' ax̱t ga zeelo chajniilo'.” ");
INSERT INTO zadNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Dgan ḻiizelozi chonte na' llialon lawi yog' diika' nllia leya' bia'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na' de wchopina' nakan katekzə dii necha', na' nan: “Chiyaḻ' gakilo' bish' ljwello'ka' ka chaki kwino'.” ");
INSERT INTO zadNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Na' diiki c̱hop chejin doxen ka na leya' len diika' bzej dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na' shlak ndop nllag fariseoka' kwit Jesúza' ");
INSERT INTO zadNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","wṉabile' ḻegake': ―¿Nak ka chakile c̱he Crístona', beena' iṉabia'? ¿No xiiṉ dia c̱heyin nake'? Na' che'gake'ne': ―Xiiṉ dia c̱he dii Davinan'. ");
INSERT INTO zadNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Na' che' Jesúza' ḻegake': ―Na' ¿berac̱he ben Espíritu Sántona' ka goll dii Davina'ne': “X̱an'”? Ḻa' kin na daa bzeje': ");
INSERT INTO zadNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","X̱ancho Chioza' golle' X̱an'na': “Wche' kwit' de shḻini, shlak wzoa' xṉi'ona' beṉ'ka' chakzbani li'.” ");
INSERT INTO zadNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na' shi kwin dii Davina' golle' Crístona': “X̱an'”, ¿berac̱he nazle nake' xiiṉ dia c̱he', shka'? ");
INSERT INTO zadNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na' ni toe' bi gok yilliigake' xtilleena'. Na' zeelo kana' koch no biyaxji bi iṉabgakile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Na'ch Jesúza' golle' beṉ'ka' nakgake'ne' txen len beṉ'ka' lle' na', chi'e: ");
INSERT INTO zadNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Beṉ'ka' chli' chsedi leya' na' fariseoka' nak lo na'gake' wzajni'gakile' beṉ' daa bzej dii Moiséza'. ");
INSERT INTO zadNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Na' chiyaḻ' wzenagle c̱hegake' kat' chzajni'gakile' le' leya' na' gonle ka nan. Per bi gonle ka chongake', ḻa' ḻegake' bi chongake' ka nagake' chiyaḻ' gonle. ");
INSERT INTO zadNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dii zan dii che'gake' beṉ' chiyaḻ' gongake', na' nakan ka to yoa' xen dii chwa'gake' beṉ' dii kono so saki, na' ḻegake' bikz bi chda na'gake' kwenc̱he gaklengake'. ");
INSERT INTO zadNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Na' yog' diika' chongake' chongake'n kwenc̱hezə ile'i beṉ' ka chongake' na' we'la'ogake' ḻegake'. Na' kajdo'ka' nak de yid daa yoo lat' Cho'a Xtill' Chioza' daa chda' loxgue'ka' na' daa chc̱heḻ neeka' chongake'n dii xench aga ka c̱he beṉ' yoblə, na' chtoṉchgake' lox xe'ka' aga ka c̱he beṉ' yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Na' kat' chajgake' lṉika', ḻe chibagakile' kwe'gake' gana' chbe' beṉ'ka' zakii, na' ḻekzka'yeṉ' chjengake' gana' chdop chllaggake' choe'ḻwillgake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Na' ḻe chibagakile' gap beṉ' ḻegake' balaaṉ kat' chillaggake' ḻegake' ga lle' lla' beṉ' na' ye'gake' ḻegake': “maestro”. ");
INSERT INTO zadNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’San le', bi we'le latj iṉa beṉ' le' “maestro”, ḻa' toz nadaan nak' Maestro c̱hele na' yog'le nakle ka bish' ljwellin. ");
INSERT INTO zadNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na' kono ye'le “x̱a” lo yell-lioni, ḻa' toz Chioza', beena' zoa yabana', nake' X̱ale. ");
INSERT INTO zadNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni bi we'le latj iṉagake' le' “maestro”, ḻa' toz nad', Cristo, nak' Maestro c̱hele. ");
INSERT INTO zadNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ḻa' beena' nak beṉ' gax̱jlall' na' chaklene', beenan' nake' beṉ' zak'chi ladjlena'. ");
INSERT INTO zadNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na' beena' chon kwine' beṉ' zakii, Chioza' gone'ne' beṉ' bibi zakii. Na' beena' chon kwine' ka beṉ' bibi zakii, Chioza' gone'ne' beṉ' zakii. ");
INSERT INTO zadNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Nyesh'laz gak c̱hele, le' chli' chsedile' leya' na' le' fariseo, daa nakle beṉ' wxiye'! Ḻa' chsej chllonle gombia' beṉ' yeḻ' wṉabia' c̱he Chioza', na' ni bi choe'le latj iṉabi'e le', ni bi choe'le latj c̱he beṉ'ka' cheengakile' iṉabi'e ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Nyesh'laz gak c̱hele, le' chli' chsedile' leya' na' le' fariseo, daa nakle beṉ' wxiye'! Ḻa' chkaale lill nool wizebka' na' choe'ḻwill-le Chioza' ssha nlleb kwenc̱he gaki beṉ' nakle beṉ' wen. Na' daa chonle ka', Chioza' wsak'zi'che' le' aga ka beṉ' yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Nyesh'laz gak c̱hele, le' chli' chsedile' leya' na' le' fariseo, daa nakle beṉ' wxiye'! Chdale to ni to na' chyiljle beṉ' wsede' daa chli' chsedile. Na' kat' chllelilene' chónlene' beṉ' malch aga ka le' na' chlliayi'chlene' ax̱t c̱hoplə ka to ba mbiayi'le. ");
INSERT INTO zadNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Nyesh'laz gak c̱hele, le' nakle ka beṉ' lc̱hoḻ, beṉ' chakile' wak wc̱hi'e sto beṉ' lc̱hoḻ! Ḻa' nale: “Shi to beṉ' wc̱hebe' to dii gone' na' wzoe' yoodo'na' de tasc̱hiw kwenc̱he gone' daa bc̱hebe', bi chonan byen gone'n.” Na' chiznale: “Shi wzoe' de tasc̱hiw ora' daa de ḻoo yoodo'na', na'chan chiyaḻ' gone' daa bc̱hebe'.” ");
INSERT INTO zadNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Le' nakle ka beṉ' lc̱hoḻ daa bi nteyile! ¿Abi chakbe'ile zak'ch yoodo'na' aga ka ora'? Ḻa' yoodo'nan' chonan kwenc̱he ora' de ḻo'inna' nakan c̱he Chios. ");
INSERT INTO zadNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Na' ḻekzka' chiznale: “Shi to beṉ' wc̱hebe' to dii gone' na' wzoe' de tasc̱hiw gana' chzeygake' bayix̱'ka' chitgake' kwenc̱he choe'la'ogake' Chioza', bi chonan byen gone' daa bc̱hebe'. Per shi wzoe' de tasc̱hiw bayix̱aa chx̱oagake' lawinna', na'chan chiyaḻ' gone' daa bc̱hebe'.” ");
INSERT INTO zadNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Le' nakle ka beṉ' lc̱hoḻ daa bi chajniile! ¿Abi chakbe'ile' gana' chzeygake' bayix̱aa chzanile we'le Chioza' zak'chan aga ka bayix̱aa chzeygake' lawinna'?, ḻa' gana' chzeygake'b chonan ḻeb ba c̱he Chios. ");
INSERT INTO zadNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ḻa' beena' chc̱heb wi'e to dii wi'e na' chzoe' de tasc̱hiw gana' chzeygake'b, aga toz ḻennan' chzoe' de tasc̱hiw, san ḻekzka' len yog' daa xoa lawinnan'. ");
INSERT INTO zadNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na' beena' chc̱heb wi'e to dii wi'e na' chzoe' de tasc̱hiw yoodo'na', aga toz yoodo'nan' chzoe' de tasc̱hiw, san ḻekzka' len Chiozan' daa nakan lill xḻatje'. ");
INSERT INTO zadNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na' ḻekzka' beena' chc̱heb wi'e to dii wi'e na' chzoe' de tasc̱hiw yabana', aga toz yabanan' chzoe' de tasc̱hiw, san len Chiozan' daa nakan gana' chṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Nyesh'laz gak c̱hele, le' chli' chsedile leya' na' le' fariseo, daa nakle beṉ' wxiye'! Choe'le Chioza' diézmona' ax̱t len yix̱weja', aníza', na' cominna', per bi chonle daa llialotech daa nllia Chioza' bia' goncho. Dii llialotech goncho daa nak shḻi, yiyesh'lallicho beṉ', na' gonḻilall'cho Chioza' do yic̱hj do lall'cho. Diikin chiyaḻ' gonle, per ḻekzka' bi chiyaḻ' wsanle gonle diika' sto. ");
INSERT INTO zadNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Le' nakle ka to beṉ' lc̱hoḻ beṉ' chakile' wak wc̱hi'e sto beṉ' lc̱hoḻ! Na' chonle ka to beṉ' chone' byen chibeje' to bi'a lesdo' ḻoo yeḻ' wao c̱he'na' na' bi chakbe'ile' chebe' to kamey. ");
INSERT INTO zadNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Nyesh'laz gak c̱hele, le' chli' chsedile leya' na' le' fariseo, daa nakle beṉ' wxiye'! Nakle ka xig' yeeṉ dii nxi nyech kolliinna' per ḻo'inna' bi nxe bi nzak' nakan, daa chonle ka chaki beṉ' nakle beṉ' wen per ḻe chzelall'le bi dii de c̱he beṉ' na' chbanlen. ");
INSERT INTO zadNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Na' le' fariseo, ¡nakle ka beṉ' lc̱hoḻ daa bi chajniile! Ḻi yiyaj yileni daa chonle kwenc̱he gakle beṉ' wen ka chaki beṉ' nakle, na'ch gakle ka xig' yeeṉ dii nxi nyech ka ḻoolə ka koll'lin. ");
INSERT INTO zadNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Nyesh'laz gak c̱hele, le' chli' chsedile leya' na' le' fariseo, daa nakle beṉ' wxiye'! Ḻa' nakle ka to lill beṉ' wet dii nyebgake' yiw' na' nḻa' lawinna' xochi, per ḻo'inna' lle' lla'n llit wetka' na' bichlə dii zban. ");
INSERT INTO zadNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kan' nakle le' daa chonle ka chaki beṉ' nakle beṉ' ḻi beṉ' shao' per ḻoo yic̱hjlall'do'lena' lle' lla'n de wxiye' na' dii mal. ");
INSERT INTO zadNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Nyesh'laz gak c̱hele, le' chli' chsedile leya' na' le' fariseo, daa nakle beṉ' wxiye'! Chonshao'zle gana' bkwash'gake' dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yi, na' chonle xochi gana' bkwash'gake' nochlə beṉ'ka' gok beṉ' ḻi beṉ' shao'. ");
INSERT INTO zadNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Na' nale: “Sheḻ'ka' neto' ba zoanto' kana' wzoa dii x̱ozxto'nto'ka' aga bennto' ḻegake' txen ka betgake' dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake'.” ");
INSERT INTO zadNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Per kwinzkzlen chli'le nakle toz beṉ'ka' betgake' dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yi, ḻa' toz ka chonlenle ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Na' ḻi yisyoll ḻi yisto ḻi gon dii mala' daa bi biyoll gon dii x̱ozxto'leka'! ");
INSERT INTO zadNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Le' nakle ka beḻ zṉia! Bi gakile shi wilale lo yi' gabiḻa'. ");
INSERT INTO zadNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Daan wseḻaa beṉ' c̱hix̱je'gakile' le' daa yepgakee. Wseḻaa beṉ' sin' beṉ' chajnii kwenc̱he wli' wsedgakile' le' cho'a xtillaana'. Per baḻgake' witle, na' baḻgake' wda'le ḻee yag cruza', na' baḻgake' wit c̱hinle gana' chdop chllagle choe'ḻwill-le Chioza', na' zi baḻgake' lljalagle to to yellka' gana' illingake'. ");
INSERT INTO zadNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na' daa gonle ka', yidobile yeḻ' wit c̱he yog'ḻoḻ beṉ' ḻi beṉ' shao'ka' bet dii x̱ozxto'leka', wzolozin dii Abela' beena' gok beṉ' ḻi beṉ' shao', ax̱t dii Zacaríaza', xiiṉ Berequíaza', beena' betgake' latja' daa de cho'a yoodo'na', kwit gana' chzeygake' bayix̱'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Dii ḻi nia' le', ka le' zoale ṉaa chidoḻ'le sak'zi'le c̱he yog' daa ben dii x̱ozxto'leka'. ");
INSERT INTO zadNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Le' beṉ' Jerusalén, le' chitle beṉ'ka' chyix̱jee daa che' Chioza' ḻegake', na' chlliale yaj beṉ'ka' chseḻee c̱hix̱je'gakile' le' cho'a xtilleena'! ¡Zan shii goklallaa gon' c̱hele ka chon jeda' chiyellb xiiṉdo'bka' xan x̱ilba', na' bi goklall'le! ");
INSERT INTO zadNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na' ṉaa ba wlej yic̱hj Chioza' le', na' gani lle'le idesh iloan. ");
INSERT INTO zadNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na' nia' le', bich ile'ile nad' ax̱t kat'ch illin lla iṉale: “¡Gaklenshga X̱ancho Chioza' beeni ba bseḻee!” ");
INSERT INTO zadNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Na' ka bichej Jesúza' ḻoo yoodo'na' kwenc̱he yiyaje' gan yoblə, beṉ'ka' nakgake'ne' txen jabig'gake' kwite'na' na' wzologake' choe'lengake'ne' dill' ka xochi nak yoodo'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Na'ch che' Jesúza' ḻegake': ―Yog' dga chle'ile ṉaa, dii ḻi nia' le' wllin lla kat' yiyiṉj doxenan, ni to yaj bich igaaṉ koll' ljwellin. ");
INSERT INTO zadNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na'ch biyajgake' lo Yaa Olívoza', na' ka chi' Jesúza' lo yaana' na'ch wbig' beṉ'ka' nakgake'ne' txen na' xochitezə wṉabgakile'ne', che'gake': ―Cheeninto' iṉo' neto' batran gak daa ba wno'. ¿Nakran gak kat' ba zoa yiyedo' dii yoblə na' kat' ba zoa te c̱he yell-lioni? ");
INSERT INTO zadNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Na'ch che' Jesúza' ḻegake': ―Wsak'yeṉ'gale kwenc̱he kono siye'z le'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ḻa' beṉ' zan ichej iṉazgake': “Nadaan Crístona'.” Na' beṉ' zan shajḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Na' yenile chak wdiḻ to ni to na', per bi gakshejlall'le. Ḻa' dii chiyaḻ'kz gakan, per aga ba bllin lla te c̱he yell-lionin kat' ba chak ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ḻa' yidiḻ-len ljwell yellka' na' beṉ' wṉabia'ka' yidiḻ-len ljwellgake', na' kwe' yillwe', kwe' wbin, na' zan yell gak bedxo' wal. ");
INSERT INTO zadNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kat' ba chak diiki, shinz chzolo ka nak daa yen ile'i beṉ' yell-lioki. ");
INSERT INTO zadNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Na'ch gongake' le' lo na' beṉ'ka' wc̱hi' wsak' le', na' witgake' le', na' yog' beṉ' yell-lioki gakzbangakile' le' daa nonḻilall'le nad'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Na' kat' ba chak diiki beṉ' zan bich gonḻilall'gake' nad', na' gakzbani ljwelle' na' gon ljwellgake' lo na' beṉ' malka'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na' ichej zan beṉ' gonzgake' ka beṉ' chyix̱jee daa che' Chioza' ḻegake', na' beṉ' zan shajḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na' daa kwe'chachga dii mala', beṉ' zan bich gakgakile' Chioza' ni bish' ljwelle'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Per beena' soac̱hec̱h gonḻilallee nad' ax̱t ka yiyoll diika' yen ile'ile', beenan' gat' to yeḻ' mban c̱he' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na' ka nak dill' wen dill' kob c̱he yeḻ' wṉabia' c̱he Chioza', chonan byen lljtix̱jeegake'n doxen yell-lioni kwenc̱he yog'ḻoḻ beṉ' yengakile'n, na' kana'chan te c̱he yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Dii Daniela', beena' wdix̱jee daa goll Chioza'ne', bzeje' c̱heyi daa soa ḻoo yoodo'na' daa wṉitan balaaṉ c̱heyinna', na' chiyaḻ' sele wṉeyi bin zejin. Na' kat' ile'ile'n ḻoo yoodo'na' ");
INSERT INTO zadNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","kanan' beṉ'ka' zoa Judeana' chiyaḻ' wxoṉjgake' shajgake' yaa yaoka'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na' beena' llia koll' lille'na' ni bich gaḻ' yiyetje' lljaleje' dii de ḻoo yoo lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na' beena' chda lyix̱aa ni bich gaḻ' yiyaje' lille'na' lljaxi'e xe'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Nyesh'laz gak c̱he noolka' noa' na' noolka' chwall' chx̱op llana' gak ka'! ");
INSERT INTO zadNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ḻi iṉabi Chioza' kwenc̱he llana' wxoṉjile dga bi gakan kat'ka' chbe' dii zaga' wa to lla sabd, llana' chombaaṉcho. ");
INSERT INTO zadNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ḻa' yeḻ' zak'zi' wal inlleban nak daa yen ile'ile, daa konoṉ' yen ile'kzi dezd ka wxe wzil yell-lioni ax̱t ṉaa, na' kat' ba wde gokan kochno yen ile'i ka ḻen. ");
INSERT INTO zadNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Na' shi Chioza' bi wzeshee llaka' gak ka', kono yila, sheḻ'ka'. Per wzesheen daa chakile' beṉ'ka' ba wleje' kwenc̱he nakgake' lall' nee. ");
INSERT INTO zadNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Na' llaka' chak ka' shi no iṉa le': “Ḻi wwia, ni ze Crístona'”, wa iṉe' le': “Na' zie'”, bi shajḻe'le. ");
INSERT INTO zadNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ḻa' wchej beṉ' siye'gake', iṉazgake': “Nadaan Crístona'”, wa “Nadaan chyix̱ji'a daa na Chioza'”. Na' ḻekzka' gongake' dii gonan ka yibani beṉ', na' gongake' yeḻ' wak xen kwenc̱he siye'gake' beṉ', ax̱t sheḻ' wxegakile' siye'gake' beṉ'ka' ba wlej Chioza' nakgake' lo nee. ");
INSERT INTO zadNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Na' ṉaa ba bzenid' le' ka nak daa zi' gak. ");
INSERT INTO zadNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Daan shi no iṉaz le': “Crístona' zoe' latja' gana' bibi chashj chḻeb”, bi shajle; wa shi no iṉaz le': “Ḻoo yoona' zoe'”, bi shajḻe'le. ");
INSERT INTO zadNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ḻa' kat' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, zizaa dii yoblə, gak ka chak kat' chep yes na' chzeeni'n doxen xan yabana'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ḻa' gana' de ba weta' nan' chllag llodka'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Na' kate yiyoll yeḻ' zak'zi'ka', lii gakte shgasj shc̱hoḻ lao wbilla' na' bewaa bich wzeeni'n na' beljka' ixopgakan, na' yog' diika' llia xan yabana' iṉibgakan. ");
INSERT INTO zadNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Na'ch yog' beṉ' lle' yell-lioni ile'gakile' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, zizaa ladj bejka' kon yeḻ' wak na' balaaṉ xen. Na' yog' beṉ'ka' lle' doxen yell-lioni kwellyesh'gake'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Na' ka kwell trompeta' zillj wseḻaa anjl c̱ha'ka' zbii zkaaṉ yell-lioni kwenc̱he yitopgake' beṉ'ka' wlej Chioza' nak lall' nee. ");
INSERT INTO zadNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Na' ḻi wwia ka chak c̱he yag yix̱wewa': kat' ba chzolo chibia xḻaguiinna', na' chakbe'ile ba zoa yiyoo la'o linna'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ka'kzan, kat' ile'ile ba chak yog' diika' ba wnia' le' gakə, na' gakbe'ile ba zoa gaoshosh te c̱he yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Dii ḻi nia' le', aga ba wit beṉ'ki zoa ṉaa kat' gak yog' diiki llia bia' gakə. ");
INSERT INTO zadNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yabana' na' yell-lioni te c̱hegakin, san cho'a xtillaana' biga te c̱heyin na' gak ka nan. ");
INSERT INTO zadNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Kono ṉezi bi lla bi gor te c̱he yell-lioni, ni anjlka' lle' yabana', ni nad' nak' Xiiṉ Chioza'. Toz X̱a' Chioza' ṉezile'n. ");
INSERT INTO zadNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Na' ka gok kana' wzoa dii Noéna', ka'kzan chak kat' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, yiyed' dii yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ḻa' beṉ'ka' wzoa kana' zi' gak yej ziw' wala', cheej chaogake', na' chshagna'gake' na' no choe'gake' yeḻ' wishagna' c̱he xiiṉe'ka' ax̱t llana' wyoolen dii Noéna' xiiṉ xoole'na' ḻoo barkwa'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Na' beṉ'ka' bi wyoo bi gokbe'gakile' bin gak ax̱t ka wzolo chak yejsiwaa na' bia' nisa' yog'gake'. Na' ka'kzan ni to kono gakbe'i kat' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, zizaa. ");
INSERT INTO zadNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kana'n, gana' lle' c̱hop beṉ' lyix̱aa, toe' yic̱hi'a na' beena' sto yigaaṉe'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Na' gana' lle' c̱hop noolə chotgake', toe' yic̱hi'a na' stoe' yigaaṉe'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Daan ḻi se kwas kwezle nad' nak' X̱anle, ḻa' bi ṉezile bi lla bi gor zizaa. ");
INSERT INTO zadNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ḻi shajni'kachi dga, sheḻ' x̱an yoona' ṉezile' bi gor illin beṉ' wbanna' lille'na', aga wes yele' kwenc̱he bi wi'e latj sho' wbanna' lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Na' daan, ḻi soatezi soa kwezle nad', Beṉ' Bseḻ' Chioza' Yell-lioni, ḻa' kat' bilə nonle lez, tokonganzi zizaa. ");
INSERT INTO zadNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Na' ḻi gak ka to wen llin beṉ' chajnii na' chone' daa chiyaḻ' gone' na' kat' chza' x̱ane'na' chone' lall' nee lille'na' kwenc̱he wi'e dii yeej gao wen llinka' sto gor c̱heyin. ");
INSERT INTO zadNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Chakomba wen llinna' daa chilaḻile' chone' daa chidoḻee gone' kat' yillin x̱ane'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ḻa' dii ḻi nia' le', x̱ane'na' gone' lall' nee yog' dii de c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Per shi wen llinna' nake' beṉ' mal na' gakile': “Wllaljachkzi x̱an'na' yilee.” ");
INSERT INTO zadNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Na' soloe' wit c̱hine' wen llinka' nak lall' nee na' yeej gaolene' weezoka'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Na' llana' bi nonyeṉ'le' lez, tokonganz yillin x̱ane'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na' daa bi chone' wen, na' wsak'zi'ene' ka sak'zi' beṉ' wxiye'ka' gana' kwellyesh'gake' na' gaox̱ax̱j ḻeye'ka' daa ḻe gakshejlall'gake'. ");
INSERT INTO zadNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Yeḻ' wṉabia' c̱he Chioza' chzaklebin daa gok c̱he shi bi' nool wew' wyaj to wishagna', na' bex̱'gakb' kandil c̱heb'ka' jḻezgakb' bi' byona' lill noola'. ");
INSERT INTO zadNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Na' gay'gakb' nteyi na' zi gay'gakb' bi nteyi. ");
INSERT INTO zadNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bi'ka' bi nteyi konteḻe wza'len kandil c̱heb'ka', per bich bex̱'gakb' seta' yigaagakba'n. ");
INSERT INTO zadNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Na' bi'ka' nteyi, bex̱'gakb' kandil c̱heb'ka' na' bex̱'tegakb' seta' yigaagakba'n. ");
INSERT INTO zadNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na' bi' wishagna'na' wlle'ib' na' bi' nool wew'ka' chbez gokxwesgakb' na' wtesgakb'. ");
INSERT INTO zadNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Na' do ka chel besyaa to beṉ', chi'e: “¡Ba za' bi' wishagna'na', ḻi sho' lljatilchob'!” ");
INSERT INTO zadNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Na' wyas bi' nool wew'ka' wzologakb' chiyonshao' kandil c̱heb'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Na' bi' nool wew'ka' bi nteyi gollgakb' bi'ka' zi gay': “Ḻi goṉgach neto' lat' set c̱helena' ḻa' ba chibill c̱hento'ni.” ");
INSERT INTO zadNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Per bi'ka' nox̱' seta' che'gakb': “Bi goṉnto'n, kwenc̱he ki iyalljichon ganga. Wenlə ḻi shaj ḻi lljx̱i' c̱helena' gana' chiteen.” ");
INSERT INTO zadNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Na' shlak zejgakb' zjx̱i'gakb' seta', bllin bi' wishagna'na' na' bi'ka' nox̱' seta' wyoolengakb' beṉ'ka' ḻoo yoona' gana' chak wishagna'na', na'ch wyej puerta'. ");
INSERT INTO zadNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Na' ka billin bi' nool wew'ka' jx̱i' seta', wṉegakb' x̱an yoona' che'gakb': “¡Beṉ'do', bsaljgach shoonto'!” ");
INSERT INTO zadNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Per x̱an yoona' chi'e ḻegakb': “Bi wsalj', ḻa' bi nombi'a le'.” ");
INSERT INTO zadNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Na'ch che' Jesúza' beṉ'ka': ―Ka'kzə le', chiyaḻ' se kwasle, ḻa' aga ṉezile bi lla bi gor zizaa. ");
INSERT INTO zadNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Yeḻ' wṉabia' c̱he Chioza' zaklebin dga wseesaa. To beṉ' wzee zeje' zit', na' ka ba zoa see, goxe' wen llin c̱he'ka' na' bene' lall' na'gake' xmeche'na' kwenc̱he gonlengake'n delgens. ");
INSERT INTO zadNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Na' toe' bi'e gayaa mil mech de or, na' stoe' c̱hopa milan, na' beena' sto bi'e to milan. Bi'e to toe' kon ka dii chakile' wak gonlengake' llinna'. Na'ch wzee zeje'. ");
INSERT INTO zadNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na' beena' bi'e gayaa milan, benlene'n llin na' bene' gan zi gayaa milan. ");
INSERT INTO zadNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Na' ḻekzka' beena' bi'e c̱hopa milan, benlene'n llin na' bene' gan zi c̱hopa milan. ");
INSERT INTO zadNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","San beena' bi'e to milan, jtene' to yech na' bkwasheen. ");
INSERT INTO zadNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Na' ka ba gok ssha na' billin x̱ane'ka', na' goxe' to togake' kwenc̱he bidegake' kwent lawe'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na'ch zigaate beena' bi'e gayaa mil mech de or blline' lawe'na', chi'ene': “X̱an', ni de de gayaa mila' beṉo' nad', na' ni de zi gayaa mil daa benlena'n gan.” ");
INSERT INTO zadNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Na' che' x̱ane'na'ne': “Ḻe wen beno', to wen llin wen inlleb nako', beno' ka chiyaḻ' gono' kon daa bkwaaṉlen' li' lat'. Na' dii xench goṉ' li' ṉaa. Wyoo kwenc̱he yibalenilo' nad'.” ");
INSERT INTO zadNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Na'ch wdena' bllin wen llinna' bkwaaṉlene' c̱hopa mil, chi'ene': “X̱an', ni de de c̱hopa mila' beṉo' nad', na' ni de zi c̱hopa mil daa benlena'n gan.” ");
INSERT INTO zadNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Na'ch che' x̱ane'na'ne': “Ḻe wen beno', to wen llin inlleb wen nako', beno' ka chiyaḻ' gono' kon daa bkwaaṉlen' li' lat'. Na' dii xench goṉ' li' ṉaa. Wyoo kwenc̱he yibalenilo' nad'.” ");
INSERT INTO zadNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Per ka bllin wen llinna' bkwaaṉlene' to mil, na' golle' x̱ane'na': “X̱an', ṉezid' nako' beṉ' zṉia, na' to chizi'zo' banez daa chon beṉ' yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Na'chan blleb' gonditj' xmecho'na', daan wden' to yech na' bkwashaan. Ni de xmecho'na', bikaagachan, ḻa' c̱hekzo'n.” ");
INSERT INTO zadNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Na'ch che' x̱ane'na'ne': “Beṉ' lia, bikz bi llin yejni'alallii chono'. Ṉezteilo' to chizi'z' banez daa chon beṉ' yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na' daa ṉezilo' kan' chon', ¿berac̱he ki joo xmechaa gana' chon yic̱hjin shlak bi wzoa'? Sheḻ' beno' ka', na' ṉaa ba biyed' yiyoṉo'n lente yic̱hjinna', sheḻ'ka'.” ");
INSERT INTO zadNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Na'ch golle' beṉ'ka' lle' na': “Ḻi yikaa mecha' daa bkwaaṉlene' na' ḻi we'n beena' nap shi milan. ");
INSERT INTO zadNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ḻa' kan' nakan, beena' chgone' llin daa yoo lo nee, gonche' lall' nee dii xench ax̱t gat' kwe'chile'; san beena' bi chgone' llin daa yoo lo nee, ax̱t daa ngoo lo nee lat' yidoyo. ");
INSERT INTO zadNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na' wen llinni bi yejni'alallii, ḻi wzaḻee gana' shgasj shc̱hoḻ, gana' kwellyeshee na' gaox̱ax̱j ḻeye'na' daa ḻe gakshejlallee.” ");
INSERT INTO zadNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Kat' ziza' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, len balaaṉ xen c̱ha'na' na' yog' anjl c̱ha'ka', na' wli'a yeḻ' wṉabia' choo yeḻ' wṉabia' xen c̱ha'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na' yog' beṉ' lle' doxen yell-lioni yidopgake' lawa'na', na' gon' c̱he c̱heləgake' ka chon to beṉ' chape' bayix̱' chone' c̱helə xil'ka' na' c̱helə shibka'. ");
INSERT INTO zadNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Na' wzoa' shḻaa de shḻi c̱ha'ni beṉ'ka' zaklebi xil'ka' daa chonḻilall'gake' nad', na' beṉ'ka' zaklebi shibka' daa bi benḻilall'gake' nad', wzoagakee shḻaa de robes c̱ha'ni. ");
INSERT INTO zadNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Na' nad', beṉ' wṉabia', yep' beṉ'ka' lle' shḻaa de shḻi c̱ha'ni: “Ḻi da, ka le' ba ben X̱a' Chioza' ka gak wen c̱hele, na' si'le banez daa ba nonshawee c̱hele ka bx̱e bsiltie' yell-liona'. ");
INSERT INTO zadNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ḻa' ka wdon', bwaole nad'; na' ka wbiḻid', beṉle dii weej'; na' ka wda' ka beṉ' zit', bleble nad' lill-lena'. ");
INSERT INTO zadNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na' ka byallj xalaana', beṉle dii gokw', na' ka bi shawaa, bidwiale nad'; na' ka gotaa lillyana', bidwiale nad'.” ");
INSERT INTO zadNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Na' yog' beṉ' ḻi beṉ' shao'ka' iṉagake' nad': “X̱an', ¿batran ble'into' li' chdono' na' bwaonto' li'? ¿Batran ble'into' li' chbiḻilo' na' beṉnto' daa weejo'? ");
INSERT INTO zadNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Batran ble'into' li' chdo' ka beṉ' zit' na' blebnto' li' ḻoo yoo lillnto'na'? ¿Batran ble'into' li' chdo' bibi xalaano' de na' beṉnto'n? ");
INSERT INTO zadNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na' ¿batran gokbe'into' bi shawoo wa gotoo lillyana' na' bidwianto' li'?” ");
INSERT INTO zadNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na' nad', beṉ' wṉabia', yepgakee: “Dii ḻi nia' le', yog' daa benle c̱he beṉ'ka' byallj bc̱hini, beṉ'ka' nak beṉ' bishaa na' beṉ' zan', ḻa'kzi bi nakgake' beṉ' zakii, nad'kzan benile ka'.” ");
INSERT INTO zadNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Na'ch yep' beṉ'ka' lle' shḻaa de robesi: “Ḻi kwas ka'lə, le' wen dii mal. Lo yi' gabiḻa' daa chaḻ' zejḻi kaṉi chidoḻ'le yiyajle gana' ba non Chioza' sak'zi' dii x̱iwaa len anjl c̱heyinka'. ");
INSERT INTO zadNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ḻa' ka wdon' bi beṉle dii gaw'; na' ka wbiḻid' bi beṉle dii yeej'. ");
INSERT INTO zadNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na' ka wda' ka beṉ' zit', aga bleble nad' ḻoo yoo lill-le. Na' ka byallj xalaana', aga bi beṉle; na' ka bi shawaa wa gotaa lillyana', aga bidwiale nad'.” ");
INSERT INTO zadNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Na' iṉagake' nad': “X̱an', ¿batran wdono', wa wbiḻilo', wa wdoo ka beṉ' zit', wa bibi xalaano' got', wa bi shawoo, wa gotoo lillyana' na' bi goklennto' li'?” ");
INSERT INTO zadNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Na' yepgakee: “Dii ḻi nia' le', daa bi goklenle beṉ'ka' byallj bc̱hini, beṉ'ka' nak beṉ' bishaa na' beṉ' zan', ḻa'kzi bi nakgake' beṉ' zakii, nad'kzan bi goklenle.” ");
INSERT INTO zadNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Na' beṉ' malkan' yiyajgake' gana' tegake' yeḻ' sak'zi'na' zejḻi kaṉi, na' beṉ'ka' nak beṉ' ḻi beṉ' shao' soalengake' nad' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Na' ka biyoll be' Jesúza' yog' dill'ka', na'ch golle' beṉ'ka' nakgake'ne' txen: ");
INSERT INTO zadNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Ba ṉezkzile zi c̱hop llazan chyallj gaḻ' lṉi Paskwa', na' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, gak' lo na' beṉ'ka' witgake' nad' ḻee yag cruza'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na'ch bx̱ozka' chṉabia' na' beṉ'ka' chli' chsedi leya' na' beṉ' golka' chṉabia' beṉ' Israelka' bdopgake' lill bx̱oz choo bx̱oz xenna', beena' le Caifás. ");
INSERT INTO zadNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Na' wloogake' xṉezin gox̱'gake' Jesúza' xochizi, ka ki gakbe'i beṉ', na' witgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Na' che' ljwelle': ―Bi gox̱'chone' shlak chaḻ' lṉina' kwenc̱he bi wta wṉecho beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na' ka zoa Jesúza' Betániana' len beṉ'ka' nakgake'ne' txen, wyajgake' lill to beṉ' le' Simón, beena' gok yillwe' daa le lepra. ");
INSERT INTO zadNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Na' shlak chi' Jesúza' cho'a mesa', bllin to noolə nox̱ee to lmet de yaj xochi na' yollan set dii chḻa' zix̱ dii zak' mech xen, na'ch bwazje'n yic̱hj Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Na' ka ble'i beṉ'ka' nak Jesúza' txen daa ben noola', ḻe bllaagake' na' che' ljwelle': ―¿Bic̱he benditjz beeni seta'? ");
INSERT INTO zadNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Sheḻ' bet'chokle'n, ḻa' dii xen zakaan, na' bi'e xmechinna' beṉ' yesh'ka', sheḻ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Na' beni Jesúza' ka choe'gake' dill', na' golle' ḻegake': ―¿Bic̱he chṉezle c̱he nooli? Ḻa' daa ba bene' c̱ha' nakan dii wen. ");
INSERT INTO zadNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ka nak beṉ' yesh'ka', toshiizi soagake' ladjlena', san nad', aga toshiizi soalen' le'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Daa ba bwazj nooli nad' set zix̱a', bene' ka' kwenc̱he gakshao'zega kwerp c̱ha'ni kat' wkwash'gake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na' dii ḻi nia' le', gattezə we'gake' dill' wen dill' kob c̱he Chioza' lo yell-lioni, ḻekzka' we'gake' dill' ka nak dii wenna' daa ba ben nooli na' lljadingakile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Na'ch beena' le Jud Scariot, beena' nak txen beṉ'ka' shlliṉ, wyaje' lao bx̱ozka' chṉabia'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Na' golle' ḻegake': ―¿Ka'k' c̱hixjle nad' shi gon' Jesúza' lo na'le? Na'ch wdixjgake'ne' shichoa mech plat. ");
INSERT INTO zadNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Na'ch lo llana'tez wzolo Juda' chinoe' nakan gone' kwenc̱he gone' Jesúza' lo na' beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lla nech c̱he lṉi Paskwa', llana' chaogake' yetxtila' daa bi nc̱hix̱ levadúrana', beṉ'ka' nak Jesúza' txen wyajgake' kwite'na' che'gake'ne': ―¿Ga cheenilo' lljasini'anto' xshe' c̱he lṉi Paskwi? ");
INSERT INTO zadNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Na'ch che' Jesúza' ḻegake': ―Ḻi shaj yell Jerusalénna', na' beena' yillagle ye'lene': “Maestrona' ne' ba zoa gak daa llia bia' gak c̱he', na' lillo'na' cheenile' wsini'anto' daa gaolennto'ne' xshe' c̱he lṉi Paskwi.” ");
INSERT INTO zadNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na'ch beṉ'ka' nakgake'ne' txen bengake' kon ka golle' ḻegake', na' jasini'agake' xshe' c̱he lṉi Paskwa'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na' ka goḻ, wche'len Jesúza' beṉ'ka' shlliṉ cho'a mesa'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Na' shlak chaogake' che' Jesúza' ḻegake': ―Dii ḻi nia' le', tole gonle nad' lo na' beṉ'ka' chakzi' chakzbani nad'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na' ka golle' ḻegake' ka' ḻe gokyesh'gakile' na' to toe' che'gake'ne': ―X̱an', ¿anadaan gon' ka', lla? ");
INSERT INTO zadNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Na'ch che' Jesúza' ḻegake': ―Beena' ba bḻeejlene' nad' yetxtil c̱he'na' ḻoo yeeṉa', beena'kzan' gone' nad' lo na' beṉ'ka' chakzi' chakzbani nad'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ka nak nad', Beṉ' Bseḻ' Chioza' Yell-lioni, wit beṉ' nad' kon ka na Cho'a Xtill' Chioza', per ¡nyesh'laz gak c̱he beena' gone' nad' lo na' beṉ'ka'! ¡Naklan wen sheḻ'ka' bi golje'! ");
INSERT INTO zadNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Na'ch Juda', beena' wdie' Jesúza' lo na' beṉ'ka', chi'ene': ―Maestro, ¿anadaan gon' ka'? Na'ch che' Jesúza'ne': ―Kan' ba wno'z. ");
INSERT INTO zadNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na' shlak chaogake', bex̱' Jesúza' yetxtila' na' bi'e Chioza' yeḻ' chox̱ken, na' bxoxje'n na'ch bi'en beṉ'ka' nakgake'ne' txen, chi'e: ―Ḻi gao dga. Ḻennan' kwerp c̱ha'ni. ");
INSERT INTO zadNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Na'tech bex̱ee to kop dii yoll vino, na' bi'e Chioza' yeḻ' chox̱ken na' bi'en ḻegake', na' golle': ―Yog'le ḻi yeej dga yoll ḻoo kopi, ");
INSERT INTO zadNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ḻa' ḻennan' xc̱hen'na' daa gon ka gak ḻi dii koba' bc̱heb Chioza' gone'. Na' ḻaljan kwenc̱he yiyakxen saaxya c̱he beṉ' zan. ");
INSERT INTO zadNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na' nia' le', ni zeelo cheejlen' le' nis uvani. Aga weejcha'n ax̱t kat'ch illin lla soacho txen gana' chṉabia' X̱a' Chioza', kana'chan yeejlena'n le' dii yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Na' ka bidaogake', beḻgake' be'la'ogake' Chioza' na'ch biyajgake' lo yaa Olívoza'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Na' ka ziyajgake', che' Jesúza' ḻegake': ―Yog'le kwej yic̱hjle nad' ṉaanlle'. Ḻa' kin na Cho'a Xtill' Chioza': “Wit' beena' chap xil'ka' na' illeshlesgakb.” ");
INSERT INTO zadNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Per ka yiban' ladj beṉ' wetka', yiyaa Galileana' lljalez' le'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Na'ch che' Pédrona'ne': ―Ḻa'kzi yog' beṉ'ki kwej yic̱hjgake' li', nad' bi kwej yic̱hj' li'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Na'ch che' Jesúza'ne': ―Dii ḻi nia' li', ṉaanlle' shoṉ shii bi wc̱hebo' shi nombi'o nad' ka zi' kwell shikwteza'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Na' Pédrona' chi'ene': ―Ḻa'kzi guetlentia' li', biga iṉia' bi nombi'a li'. Na' ka'kzə goll yog'ḻoḻ beṉ'ka' nakgake'ne' txen. ");
INSERT INTO zadNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Na' ka bllinlen Jesúza' beṉ'ka' nakgake'ne' txen latja' le Getsemaní, na'ch golle' ḻegake': ―Nizə ḻi kwe' shlak shaa daa ka'lə llje'ḻwill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Na' bc̱hi'e Pédrona' na' c̱hop bish'te xiiṉ Zebedewa', na' wzolo chakyeshile' dii wal inlleb. ");
INSERT INTO zadNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Na' golle' ḻegake': ―Ax̱t chaklikazid' lii guettia' daa ḻe chakyeshii yic̱hjlall'dawaani. Ḻi igaaṉ nizə na' bi guesle. ");
INSERT INTO zadNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Na' bḻee ḻegake' zi lat' na' bc̱hek' yic̱hje'na' lo yona' na' be'ḻwille' Chioza', chi'e: ―X̱adawaa, shi wakan, bengach ka ikwas dga yen ile'id', per aga gak ka cheenid', san gak ka cheenilo'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Na'ch biyaje' gana' lle' beṉ'ka' shoṉ, na' ble'ile' ba chesgake'. Na' golle' Pédrona': ―¿Abikzə bchejlat'gaile ḻa'c̱h' tgor kwezle nad' bi guesle? ");
INSERT INTO zadNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bi guesle. Ḻi we'ḻwill Chioza' kwenc̱he bi we'zle latj gon beli chenna' le' gan. Aga ki cheeni yic̱hjlall'do'lena' gonlen per beli chenna' bi chizoin. ");
INSERT INTO zadNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Na'ch wyaje' de wchop shii jeḻwille' Chioza', chi'e: ―X̱adawaa, shi ba nakten idiḻ illag' dga, gakkzə ka cheenilo'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Na' ka billine' dii yoblə ḻekzka' chesləgake' daa bi wzogakile' bishgala'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Na' bikzə bisbane' ḻegake', na' wzee sto shii jeḻwille' Chioza' de wyoṉ shii na' golle'ne' ka ba gollkze'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Na'ch biyaje' gana' bgaaṉ beṉ'ka', na' golle' ḻegake': ―¿Ani chestkile? Ba bllin gor nad', Beṉ' Bseḻ' Chioza' Yell-lioni, gak' lo na' beṉ' saaxyaka'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ḻi c̱has na' ḻi sho'. Ba za' beena' wdie' nad' lo neeka'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bilaṉ' yiyoll yee Jesúza' ka' ka bllin Juda' beena' nak txen beṉ'ka' shlliṉ, nc̱hi'e beṉ' zan beṉ'ka' bseḻ' bx̱ozka' chṉabia' len beṉ' golka' chṉabia' beṉ' Israelka'. Na' nox̱'gake' no spad na' no yag. ");
INSERT INTO zadNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na' Juda' ba bzajniile' beṉ'ka' nc̱hi'e nakan gone' wli'e beena' gox̱'gake', golle': “Kon beena' wnop', ḻen gox̱'le.” ");
INSERT INTO zadNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Na' ka bllinlene' beṉ'ka' kwit Jesúza', lii wbig'tie' lawe'na' chi'ene': ―¡Chiox ṉaa, maestro! Na'ch bnope'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Na' Jesúza' golle'ne': ―Bish'dawaa, ben daa zidyeno'. Na'ch lii wbig'te beṉ'ka' bex̱'gake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na' ka bex̱'gake'ne', to beena' nake'ne' txen wleje' spad c̱he'na' na' wdine'n xmos bx̱oz choo bx̱oz xenna', bc̱hogtie' tḻaa nague'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Na'ch goll Jesúza'ne': ―Bigooshao' spad c̱ho'na', ḻa' yog' beṉ'ka' chitgakile' beṉ' yesya, ḻekzka' ḻen guetgakile'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Achakile bi gak iṉabid' X̱a'na' gaklene' nad' na' lii wseḻ'tie' anjl zan inlleb, sheḻ'ka'? ");
INSERT INTO zadNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Per shi ka' gon', ¿nakra gak yillini Cho'a Xtill' Chioza' gana' nan chonan byen gak ki? ");
INSERT INTO zadNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Na'ch goll Jesúza' beṉ'ka' ba nox̱'gake'ne': ―¿Achakile' no wban no nad' za'lenzle no spad no yag kwenc̱he gox̱'le nad'? Yog' lla bli' bsedid' beṉ' ḻoo yoodo'na', ¿bic̱he bi bex̱'le nad' shlak bli' bsedid' beṉ' na'? ");
INSERT INTO zadNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Per daa chonle ki, chillinin ka na Cho'a Xtill' Chioza' daa bzej dii beṉ'ka' wdix̱jee daa golle' ḻegake'. Na'ch yog'ḻoḻ beṉ'ka' nak Jesúza' txen bxoṉjgake' na' bkwaaṉ'gake' toze'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Na' beṉ'ka' bex̱'gake' Jesúza' jwa'gake'ne' lill Caifáza', beena' nak bx̱oz choo bx̱oz xen, na' lille'na' ba ndop nllag beṉ'ka' chli' chsedi leya' na' beṉ' golka' chṉabia'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na' Pédrona' janoe' Jesúza' de zit'lə, bllintie' lesh' chyoo c̱he bx̱oz choo bx̱oz xenna' na' jc̱he'lene' beṉ'ka' chap yoodo'na' kwenc̱he ile'ile' ka gak c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na' bx̱ozka' chṉabia' len beṉ'ka' chṉabia' beṉ' Israelka' wdiljgake' beṉ' c̱hiljlallee c̱he Jesúza' kwenc̱he wc̱hoglogake' guete'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Na' ḻa'kzi beṉ' zan beṉ'ka' biya dii biyiljlall'gake' c̱he Jesúza', aga bidiḻi cho'a dill' c̱he'ka', ax̱t ki bllin c̱hop beṉ' ");
INSERT INTO zadNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","be'gake' toz dill', che'gake': ―Ki wna beeni: “Nad' wak yic̱hinj' yoodo' c̱he Chioza' na' shoṉ llazə yiyontia'n dii yoblə.” ");
INSERT INTO zadNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Na'ch wzolla' bx̱oz choo bx̱oz xenna', golle' Jesúza': ―¿Abikz bi iṉo' c̱heyi dga nagake' c̱ho'? ");
INSERT INTO zadNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Na' Jesúza' bikzə wṉie'. Na'ch che' bx̱oz choo bx̱oz xenna'ne': ―Chios yaa Chios banna' soe' de tasc̱hiw. Wnashki neto' shi lin' Crístona', beena' nak Xiiṉe'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Na' goll Jesúza'ne': ―Awe, kan' nakan. Na' ḻekzka' nia' le', wle'ile nad', Beṉ' Bseḻ' Chioza' Yell-lioni, kwi'a shḻaa de shḻi c̱he Chioza', beena' zeelo nap yeḻ' wak choo yeḻ' wak xenna', na' ḻekzka' ile'ile nad' zizaa ladj bejka' ze xan yabana'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Na'ch bsho' bc̱hez' xa bx̱oz choo bx̱oz xenna'. Na' daa bene' ka', bli'e nan ḻe bllee, na' wne: ―¡Kwinle ba benile naz beeni nake' Xiiṉ Chioza'! Bich chyalljicho beṉ' gao xya c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Bi ka iṉale? Na'ch gollgake'ne': ―Chiyaḻ' guete'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Na'ch bllaa x̱eneeka' cho'alao Jesúza' na' wdap' wlall'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Na' che'gake'ne': ―Shi lin' Crístona', wnashki non wdap wlall' li'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na' shlak chak ka', Pédrona' chi'e lesh' chyoona' ka bllin to noolə wen mandad kwite'na' chi'ene': ―Lenon' nako' txen Jesúza', beṉ' Galileana'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Na' lao yog' beṉ'ka' lle' na', aga bc̱heb Pédrona' shi nake' Jesúza' txen, na' golle' noola': ―Bi ṉezid' bin no'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Na' ka ziyaje' cho'a puerta' bizle'i sto beṉ' yoblə ḻe' na' chi'e beṉ'ka' lle' na': ―Len beenin nake' txen Jesúza', beṉ' Nazareta'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Na' ḻekzka' aga bizc̱heb Pédrona' shi nake' Jesúza' txen, bzoatie' Chioza' de tasc̱hiw, chi'ene': ―Bi nombi'a beena'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Na' gokzə xtit na' jabig' beṉ'ka' lle' na' kwit Pédrona' na' che'gake'ne': ―Dii ḻikzan lenon' nako' ḻegake' txen, ḻa' lii nakbia'te ka chshaljo'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Na'ch wzolo Pédrona' chone' zṉia, chi'e: ―¡Dii baḻkzan nia' bi nombi'ane'! ¡Chioza' wsak'zi'e nad' shi chziye'zan'! Na' biyoll wne' ka' lii wchellte shikwteza'. ");
INSERT INTO zadNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Na'ch jadini Pédrona' daa goll Jesúza'ne': “Shoṉ shii bi wc̱hebo' shi nombi'o nad' ka zi' kwell shikwteza'.” Na'ch biza' Pédrona' chbellyeshee. ");
INSERT INTO zadNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na' ka wyeeni', yog'ḻoḻ bx̱ozka' chṉabia' na' beṉ' golka' chṉabia' beṉ' Israelka' bengake' toz dill' witgake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Na' bc̱hejgake'ne' jwa'gake'ne' lao Pilátona' beena' chṉabia' gana' mbani Judeana'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Juda', beena' bene' Jesúza' lo na' beṉ'ka', ka gokbe'ile' ba nakan witgake' Jesúza' na' wdao bdiachgan ḻe'. Na'ch wyaje' lao bx̱ozka' chṉabia' na' lao beṉ' golka' chṉabia' jasane' shichoate mech de plata' daa be'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Na' chi'e ḻegake': ―Ḻe malchga ben' daa bdia' to beṉ' bibi doḻ' nape' lo na'lena'. Na' ḻegake' che'gake'ne': ―¿Bera kwent c̱he neto'? Li'z ṉezilo' bin beno'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Na' jazaḻ' Juda' mecha' ḻoo yoodo'na', na' tech jayet kwine' jaloo do yene'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Na' bx̱ozka' chṉabia' bitopgake' mecha' na' che' ljwellgake': ―Bi gak yiyonchon toz mech c̱he yoodo'na', ḻa' nakan dii ba nap xya. ");
INSERT INTO zadNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Na' be'gake' dill' yizi'gakile' mecha' to yell-lio dii le Yell-lio c̱he Beṉ' Wen Yes' gana' wkwash'gake' beṉ' zit'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Daan ax̱t ṉaanlla yell-liona' len Yell-lio Chen. ");
INSERT INTO zadNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Na' daa gok ka', billinin ka wna dii Jeremíaza', beena' wdix̱jee daa goll Chioza'ne', ka wne': “Bikaagake' shichoa mech plat daa bc̱hogbia' beṉ' Israelka' zak' beena'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Na' kon ḻen wxi'gakile' Yell-lio c̱he Beṉ' Wen Yesaa, kon kana' wna X̱ancho Chioza' nad'.” ");
INSERT INTO zadNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ka bllin Jesúza' lao Pilátona', na'ch che' Pilátona'ne': ―¿Alin' beṉ' wṉabia' c̱he beṉ' Israelka'? Na' che' Jesúza'ne': ―Kan' ba wno'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Na' shlak bx̱ozka' chṉabia' na' beṉ' golka' chṉabia' beṉ' Israelka' chaogake' xya c̱he', bibi dill' billi'e ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Na'ch goll Pilátona'ne': ―¿Abi chenilo' diika' chaogake' xya c̱ho'? ");
INSERT INTO zadNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Per Jesúza' ni to diika' chaogake' xya c̱he' ni shc̱ho'a dill' bi billi'e, na' ḻe bibanchgayi Pilátona'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na' beṉ' wṉabia'na' yooloe' yog' yiz chisane' to beṉ' de lillyana' lla lṉi Paskwa', kon beena' iṉab yog' beṉ' yell yisane'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na' de to beṉ' lillyana', beṉ' ḻe zeyi c̱he' nake' beṉ' mal, na' lie' Barrabás. ");
INSERT INTO zadNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Na' ka ndop nllag beṉ' yellka', che' Pilátona' ḻegake': ―¿No beṉ'ki cheenile yisan'?, ¿aBarrabáza', awa Jesúzi, beeni nsi'gake' Cristo? ");
INSERT INTO zadNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Golle' ḻegake' ka' ḻa' gokbe'ile' daa chakxe'gakile' Jesúzan' jwa'gake'ne' lawe'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Shlak chi' Pilátona' gana' chone' yeḻ' josc̱hisa', bseḻ' xoole'na' to rson, chi'ene': “Bi gaklebilo' beṉ'ka' chao xya c̱he beena', ḻa' aga bi doḻ' c̱he' de, ḻa' nlle'yi wṉeid' to yel c̱he', na' ḻe bsheban nad'.” ");
INSERT INTO zadNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Per bx̱ozka' chṉabia' na' beṉ' golka' chṉabia' beṉ' Israelka' wlooyeḻ'gake' beṉ'ka' lle' lla' na' iṉabgake' yisane' Barrabáza' na' gone' mandad guet Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Na' Pilátona' sto shii wṉabile' ḻegake': ―¿No beṉ'ki c̱hop cheenile yisan'? Na' beṉ'ka' che'gake'ne': ―¡Bisan Barrabáza'! ");
INSERT INTO zadNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Na' che' Pilátona' ḻegake': ―Na' ¿bera ka gonid' Jesúzi beeni nsi'gake' Cristo? Na' yog'ḻoḻe' che'gake'ne': ―¡Bdee ḻee yag cruza'! ");
INSERT INTO zadNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Na' che' Pilátona' ḻegake': ―Per ¿bera dii malan' ba bene'? Na' ḻegake' zizikli chosyaadiagake', che'gake'ne': ―¡Bdee ḻee yag cruza'! ");
INSERT INTO zadNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Na' ka gokbe'i Pilátona' bich bi de gone' daa zizikchli ba chaklleshgakile', bene' mandad jx̱i'gake' nisa' kwenc̱he binee lao yog' beṉ'ka', na' chi'e: ―Aga bi doḻ' nap' nad' daa guet beeni. Len' gak xbag'lene'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Na' yog'ḻoḻ beṉ'ka' che'gake'ne': ―¡Neto' len xiiṉnto'ka' idobinto'ne'! ");
INSERT INTO zadNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Na'ch bisan Pilátona' Barrabáza', na' bene' mandad bet wdingake' Jesúza' na' bene'ne' lo na'gake' kwenc̱he wda'gake'ne' ḻee yag cruza'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Na' soldadka' bc̱he'gake' Jesúza' gana' chon Pilátona' yeḻ' josc̱hisa' na' biti'agake' yog'ḻoḻ soldadka' nakgake' txen. ");
INSERT INTO zadNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Na'ch wdiṉgake' xa Jesúza' na' bwakwgake'ne' to lech' xṉa ka c̱he to beṉ' wṉabia'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Na' bengake' to bxooṉ de xis yesh' na' bllingake'n yic̱hje'na' ka to corona, na' nee de shḻina' bgox̱'gake'ne' to bar. Na'ch bc̱hek' xibe'ka' lawe'na' na' btitjgakile'ne' che'gake': ―¡Toshiizi sechgayi c̱he beeni chṉabia' beṉ' Israelka'! ");
INSERT INTO zadNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Na'ch no chlla' x̱eneeka' ḻe', no chikaagake' bara' daa bgox̱'gake'ne' na' chyingake'n yic̱hje'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Na' ka wde btitjgakile'ne' na'ch biyiṉgake' lechaa bwakwgake'ne' na' biwakwgake' xe'na' nakwkze'. Na'ch bc̱he'gake'ne' kwenc̱he wda'gake'ne' ḻee yag cruza'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Na' ka ba chchejgake' cho'a yell Jerusalénna', billaggake' to beṉ' Cirene, beṉ' le Simón, na' bengake' byen bi'e yag cruz c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na' ka' bllingake' latja' le Gólgota, na' zejin Latj c̱he llit yic̱hj beṉ' wet. ");
INSERT INTO zadNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Na' nan wweejgake' Jesúza' vino daa nc̱hix̱' to dii zḻa', per ka bnix̱e'n, bi goonile' yeeje'n. ");
INSERT INTO zadNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Na' ka biyoll bda'gake'ne' ḻee yag cruza', soldadka' bengake' to wyitj kwenc̱he got'bia' nogake' yidoḻ' xa Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Na'tech wche'gake' wdapgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Na' yic̱hj yag cruz c̱he'na' bda'gake' to dii choe'n dill' bic̱he nda'gake'ne' na', na' nan: “Beenin Jesúza', beṉ' wṉabia' c̱he beṉ' Israelka'.” ");
INSERT INTO zadNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na' ḻekzka' bda'gake' c̱hop beṉ' wban shḻaa wej kwit yag cruz c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na' beṉ'ka' chde gana' dee, chta yic̱hje'ka' na' chgoogake'ne' belban, ");
INSERT INTO zadNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","che'gake'ne': ―Li' wno' yic̱hiṉjo' yoodo'na' na' shoṉ llazə yiyontio'n, ¡bisla kwino' ḻee yag cruzi shi leilo' nako' Xiiṉ Chios! ");
INSERT INTO zadNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Na' ḻekzka' bx̱ozka' chṉabia' na' beṉ'ka' chli' chsedi leya', na' fariseoka' len beṉ' golka' chṉabia' btitjgakile'ne', che' ljwelle': ");
INSERT INTO zadNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Gok bisle' beṉ' yoblə per bi chak yisla kwine'. Shi leile' ḻen' beṉ' wṉabia' c̱hechona', cho' beṉ' Israel, yiyetjshkile' ḻee yag cruza' ṉaa kwenc̱he shajḻe'cho c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nx̱enilallee Chioza'. Yislashkile'ne' ṉaa shi leile' chakile'ne', ḻa' wne' nake' Xiiṉ Chios. ");
INSERT INTO zadNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na' ax̱t wbanka' da' ḻee yag cruza' kwite'na' ḻekzka' biya dii che'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na' do ka gobill kat' bic̱hoḻ doxen yell-lioni ax̱t do ka chida shoṉch biyeeni'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Na' do ka chida shoṉə besyaa Jesúza' zilljə, ne': ―Elí, Elí, ¿lama sabactani? ―na' zejin: Chios c̱ha', Chios c̱ha', ¿bic̱he ba wlej yic̱hjzo' nad'? ");
INSERT INTO zadNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Na' baḻ beṉ'ka' lle' na', bengakile' ka wne', na'ch che'gake': ―Elíazan' chaxe', beena' wdix̱jee daa goll Chioza'ne' kani'yi. ");
INSERT INTO zadNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Na' toe' lii zejdotie' jx̱i'e to dii bḻeeje' ḻoo vino daa nak zic̱hj zḻa', na'ch bzoe'n to lo xis na' jazoe'n cho'a Jesúza' kwenc̱he yeeje'n. ");
INSERT INTO zadNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Na' beṉ'ka' sto che'gake': ―Jwayishkile'na', la'shki shi wid Elíaza' kwenc̱he yidsle'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Na' ka biyoll besyaa Jesúza' zilljə dii yoblə, na' wite'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na' ka wite', lechaa ze ḻoo yoodo'na' lii bchez'ten gokan c̱hoplə. Na' gok to bedxo' na' wlaa yajka'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Na' ḻekzka' ax̱t biyalj gana' bgash' beṉ' wetka'. Na' zan beṉ' wetka', beṉ'ka' benḻilall' Chioza', bibangake' sto shii ");
INSERT INTO zadNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","na' bichejgake' gana' bgash'gake'. Na' ka bibanch Jesúza', biyoogake' yell Jerusalénna', na' beṉ' zan ble'gakile' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na' x̱an soldadka' len beṉ'ka' chaplene' Jesúza' ḻe bllebgake' ka wxo' na' bichlə diika' gok. Na' wnagake': ―Dii ḻikzan Xiiṉ Chios beeni. ");
INSERT INTO zadNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na' zan noolka' wno Jesúza' dezd gana' mbani Galileana', beṉ'ka' goklengake'ne' c̱he bi dii byalljile', lle'gake' de zit'lə bwiagake' doxen ka gok. ");
INSERT INTO zadNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Na' ladje'ka' len María, beṉ' yell Magdálana', na' María beena' nak xṉa' Jacóbona' len Joséna', na' xṉa' beṉ'ka' nak xiiṉ Zebedewa'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Na' ka chzeḻes yela' bllin to beṉ' wni'a lie' José, beena' nak beṉ' yell Arimatea na' goke' txen Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Na' wyaje' lao Pilátona' jaṉabe' kwerp c̱he Jesúza', na' Pilátona' bene' mandad biyoe'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Na' bikaa Joséna' kwerp c̱he Jesúza' na' bitobe'ne' to lech' xtil. ");
INSERT INTO zadNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Na' jḻo'ene' to ḻoo ba kob dii zi' benshawee to ḻee yaj. Na'tech bdee to yaj xen cho'ayinna'. Na'ch bizee. ");
INSERT INTO zadNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na' María, beṉ' yell Magdálana', len Maríana' sto wche'gake' cho'a bana'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Na' betiyo, llana' chombaaṉ beṉ' Israelka', wyaj bx̱ozka' chṉabia' len fariseoka' lao Pilátona', ");
INSERT INTO zadNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","che'gake'ne': ―Beṉ'do', ba jadininto' ka wna dii beṉ' wxiye'na' kana' mbane', wne' yiyoṉ lla yibane' dii yoblə ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Na' bseḻ'gach beṉ' lljtape' gana' bkwash'gake'ne' ax̱t ka gakch shoṉ lla kwenc̱he bi shaj beṉ'ka' nakgake'ne' txen do waḻ chel lljalejgake' kwerp c̱he'na', na' tena' ye'gake' beṉ': “Ba bibane' dii yoblə ladj beṉ' wetka'.” Ḻa' shi ba bengake' ka', na'ch gongake' to dii wxiye' walch aga ka dii necha'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Na'ch che' Pilátona' ḻegake': ―Na' lle' soldadka', ḻi wc̱he'gake' kwenc̱he gapgake'n ax̱t ga zeelo gakgake'. ");
INSERT INTO zadNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Na'ch wyajlengake' soldadka' na' bsejchachgake' gana' da' yaja' nkwasha'n cho'a bana'. Na'ch bzoagake' soldadka' kwenc̱he gapgake'n. ");
INSERT INTO zadNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na' ka wde lla sabda', llana' chombaaṉgake', ni baḻ lla nech c̱he xmanna' sto, wyaj María nool Magdálana', len Maríana' sto jawiagake' cho'a bana'. ");
INSERT INTO zadNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na' wzolo to bedxo' xen wal daa betj to anjl c̱he X̱ancho Chioza' yabana', na' ka blline' cho'a bana' na' bikwase' yaja' daa nsejan cho'a bana' na' wllie' lawinna'. ");
INSERT INTO zadNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na' anjla' chey cheeni'e kakzə ga chep yes na' xe'na' nakan xtil inlleb. ");
INSERT INTO zadNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na' ka ble'i soldadka' ḻe' ax̱t bxiztitgake' daa ḻe bllebgake' na' ax̱t witgake' shlet. ");
INSERT INTO zadNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Na'ch che' anjla' noolka': ―Bi illeble. Ṉezid' Jesúzan' chiyiljle, beena' wit ḻee yag cruza'. ");
INSERT INTO zadNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Koch no de ni. Ba bibane' kon ka wne'. Ḻi dakachi wwiale gani wdix̱jgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na' ḻi yiyajdo ḻi lljayell beṉ'ka' nakgake'ne' txen: “Ba bibane' ladj beṉ' wetka' na' ba ziyaje' Galileana' lljaleze' le', na' na'kzə ile'ilene'.” Na' ba wnia' le' ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Na'ch biza'do noolka' cho'a bana' chllebgake' na' ḻe chibagakile' zjadix̱je'gakile' beṉ'ka' nak Jesúza' txen daa goll anjla' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na' ka ziyajgake', bli'lao Jesúza' ḻegake' na' bwape' ḻegake' chiox. Na' jabig'gake' kwite'na' na' wdeḻ'gake' ṉi'ena' be'la'ogake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Na' che' Jesúza' ḻegake': ―Bi illeble. Ḻi lljayell beṉ' bishaaka' shajgake' Galileana' na' ile'gakile' nad' na'. ");
INSERT INTO zadNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na' ka biza' noolka', baḻ soldadka' wdap gana' bkwash'gake' Jesúza' biyajgake' yell Jerusalénna' jayellgake' bx̱ozka' chṉabia' yog' diika' gok. ");
INSERT INTO zadNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Na'ch wyaj bx̱ozka' chṉabia' je'lengake' beṉ' golka' chṉabia' dill' naklə ka gongake' daa goll soldadka' ḻegake'. Na' ka biyoll be'gake' dillaa, na'ch be'gake' soldadka' mech xen, ");
INSERT INTO zadNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","che'gake': ―Iṉatezle waḻ chel shlak chesle, beṉ'ka' nak Jesúza' txen bidḻejgake' kwerp c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na' shi ba biṉezi Pilátona' dga, neto'kzə lljazajniinto'ne' nakan gok kwenc̱he bibi gonile' le'. ");
INSERT INTO zadNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Na'ch soldadka' bex̱'gake' mecha' na' biza'gake' jazegake'n dill' kon ka gollgake' ḻegake'. Na' ax̱t ṉaanlla beṉ' Israelka' ni nagake' ka'. ");
INSERT INTO zadNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na' wyaj beṉ'ka' shnej, beṉ'ka' nak Jesúza' txen, Galileana' kwenc̱he yillaggake' Jesúza' lo yaana' gana' golle' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Na' ka ble'gakile' Jesúza', be'la'ogake'ne', per baḻgake' gokc̱hoplall'gake'. ");
INSERT INTO zadNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Na'ch jabig' Jesúza' kwite'ka', chi'e ḻegake': ―Ba non Chioza' lo na' iṉabi'a yabana' na' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Daan, ḻi shaj doxen yell-lioni, ḻi lljali' lljasedi yog' beṉ' kwenc̱he gakgake' nad' txen. Na' wchoale ḻegake' nis daa ba nonḻilall'gake' X̱acho Chioza', na' nad', Xiiṉe', len Espíritu Sántona'. ");
INSERT INTO zadNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na' wli' wsedile ḻegake' gongake' yog' diika' ba ben' mandad gonle. Na' nad' soalen' le' toshiizi ax̱t ka te c̱he yell-lioni.");
INSERT INTO zadNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ki wzolo dill' wen dill' kob c̱he Jesucrístona', beena' nak Xiiṉ Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Gok ka wna dii Isaíaza', beena' wdix̱jee daa goll Chioza'ne': Wseḻaa to beṉ' kwialoe' lawo'na', wi'e xtilloona' kwenc̱he ba lle' beṉ' wzenague' c̱ho' kat' illino'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","To beṉ' wṉie' zilljə to lo latj gana' bibi chashj chḻeb, chi'e: “Ḻi se kwas wzenagle c̱he X̱anchona' na' wsalj yic̱hjlall'do'leka' kat' zee.” ");
INSERT INTO zadNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Na' bllin Juanna' latja' gana' bibi chashj chḻeb. Bchoe' beṉ' nis, na' wdix̱je'ile' beṉ' chiyaḻ' yiyaj yilengakile' na' c̱hoagake' nis kwenc̱he yizi'xen Chioza' saaxya c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na' yog' beṉ'ka' lle' gana' mbani Judeana' na' beṉ'ka' lle' yell Jerusalénna' jazenaggake' dillaa cho'e. Na' bix̱oadoḻ'gake' saaxya c̱he'ka', na' bchoa Juanna' ḻegake' nis ḻoo yao Jordánna'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na' xa Juanna' gokan de xa kamey na' bc̱hej lsineena' to yid. Na' wdawe' bish'zo na'ch shin baser dii de lyix̱aa. ");
INSERT INTO zadNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Na' wdix̱je'ile' beṉ'ka' cho'a xtill' Chioza', chi'e: ―Zi' za'lə beena' napch yeḻ' wak xench ka nad', na' ni bi zakaa gak' xmose' kwenc̱he wḻec̱hj' xele'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nad' ba bchoa' le' nisa', san ḻe', gone' ka yidsoa Espíritu c̱he Chioza' ḻoo yic̱hjlall'do'lena'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na' kana'yeṉ' Jesúza' wzee yell Nazareta' daa llia gana' mbani Galileana' na' wyaje' cho'a yao Jordánna' gana' bchoa Juanna'ne' nisa'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na' shlak chichej Jesúza' ḻoo nisa', ble'ile' byalj yabana' na' betj Espíritu c̱he Chioza' jsoalene'ne' na' ble'ile' Espírituna' ka to palom. ");
INSERT INTO zadNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na' bengakile' wṉe Chioza' yabana', chi'e Jesúza': ―Lin' nako' Xiiṉ', chakchgaid' li' na' ḻe chibaid' li'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Na' lii bc̱he'te Espíritu c̱he Chioza' ḻe' latja' gana' bibi chashj chḻeb. ");
INSERT INTO zadNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Na' wzoe' na' c̱hoa lla ladj ba zṉiaka', na' Satanáza' daa chṉabia' dii x̱iw'ka' goklalliin kooyeḻa'n ḻe' gone' ka cheenin. Na' ka wde, jaklen anjlka' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Biyoll wloogake' Juanna' lillyana', Jesúza' wyaje' gana' mbani Galileana' na' je'lene' beṉ' dill' wen dill' kob c̱he Chioza', ");
INSERT INTO zadNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","chi'e: ―Ba bllin lla iṉabia' Chioza' ḻoo yic̱hjlall'do'lena'. Ḻi yiyaj yileni dii malka' chonle na' ḻi shajḻe' dill' wen dill' kob c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Shlak ngoo Jesúza' nez cho'a nisdo' c̱he Galileana', ble'ile' Simónna' len beṉ' bishee Andréza', chzaḻ'gake' yix̱j daa chzengakile' beḻka' ḻoo nisdo'na', ḻa' ḻennan' noni xshingake'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na' goll Jesúza' ḻegake': ―Ḻi da, dino nad'. Na' ka chonle chbejle beḻka' ḻoo nisi, ka'kzan gonle yibejle beṉ' lao dii mala'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na' ka biyoll golle' ḻegake' ka', lii bkwaaṉ'tegake' yix̱ja' daa chzengakile' beḻka' na' zejlengake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ka ba wza'gake' zi lat', ble'i Jesúza' Jacóbona' len beṉ' bishee Juanna', beṉ'ka' nak xiiṉ Zebedewa', lle'gake' ḻoo barkwa' chiyonshao'gake' yix̱ja' daa chzengakile' beḻka'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Na' lii wṉetie' ḻegake', na' bkwaaṉ'gake' x̱e'ka', beena' le Zebedeo, len beṉ'ka' chaklen ḻegake' ḻoo barkwa', na' wyajlengake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Na' bllingake' yell Carpernaúma'. Na' lla sabda', llana' chombaaṉ beṉ' Israelka', wyaj Jesúza' gana' chdop chllaggake' choe'ḻwillgake' Chioza' na' wzoloe' chli' chsedile' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Na' bibani beṉ'ka' lle' na' ka chli' chsedi Jesúza', ḻa' bli' bsedile' ḻegake' ḻega beṉ' nap yeḻ' wṉabia', na' bi chli' chsedile' ka beṉ'ka' chli' chsedi leya'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na' ladj beṉ'ka' chdop chllag gana' chli' chsedile' ḻegake', len to beṉ' yo'e dii x̱iwaa, na' besyaan, che'n: ");
INSERT INTO zadNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¡Jwayi neto', Jesús, beṉ' Nazaret! ¿Abido' kwenc̱he wlliayoo neton'? Nad' nombi'a li' na' ṉezid' nako' dowalj beṉ' ḻi beṉ' shao' c̱he Chios. ");
INSERT INTO zadNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Na' Jesúza' bsheshlene'n, chi'e: ―¡Llizə wzoa! ¡Bichej ḻoo yic̱hjlall'do' beeni! ");
INSERT INTO zadNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na' dii x̱iwaa wchooṉan beena' na' bchix̱ btoḻan ḻe' na' bichejan chosyaadian. ");
INSERT INTO zadNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na' yog' beṉ'ka' lle' na' bibangakile', na' che' ljwellgake': ―¿Bi dii kob dga chli' chsedi beeni, lla? ¡Nakbia' nape' yeḻ' wṉabia', ḻa' ax̱t len dii x̱iw'ka' chsheshlene' na' chzoagakan xtillee! ");
INSERT INTO zadNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na' lii wzete dill' doxen gana' mbani Galileana' ka nak daa chon Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Na' biza' Jesúza' gana' chdop chllaggake' na' biyajlene' Jacóbona' len Juanna' lill Simónna' na' Andréza'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na' tobiiṉ c̱he Simónna' die' yo'e dii ḻa. Na' gollgake' Jesúza' daa chak c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Na' wbiguee gana' die' na' bex̱ee neena' bḻise'ne'. Na' lii bichejte dii ḻana' na' wzoloe' bene' daa wdaogake'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na' ka ba wxoa wbilla', jwa'gake' lao Jesúza' yog' beṉ'ka' bi shao' na' beṉ'ka' yoo dii x̱iwaa. ");
INSERT INTO zadNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Na' yog' beṉ'ka' lle' yella' bdi'a bllaggake' cho'a yoona' gana' zoe'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na' Jesúza' biyone' beṉ' chak wde wdeli yillwe'. Na' ḻekzka' bibeje' dii x̱iw'ka' yoo beṉ', na' bi bi'e latj iṉegakan daa nombia'gakan ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na' Jesúza' wyase' ni baḻ, na' bcheje' yella' jeḻwille' Chioza' ga kono beṉ' lle'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Na' wyaj Simónna' len beṉ'ka' nakgake'ne' txen jadiljgake'ne', ");
INSERT INTO zadNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","na' ka billelgakile'ne' na'ch gollgake'ne': ―Yog'z beṉ' chiyiljgake' li'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Na' che' Jesúza' ḻegake': ―Ḻi sho' yellka' sto, diika' llia gaozə, kwenc̱he ḻekzka' llje'len' cho'a xtill' Chioza' beṉ'ka' lle' na', ḻa' ni c̱heyinnan' bid'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Na' wda Jesúza' yog' yellka' llia doxen gana' mbani Galileana' choe'lene' beṉ'ka' cho'a xtill' Chioza' yog' gana' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza', na' bibeje' dii x̱iw'ka' yoo beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","To beṉ' chak yillwe' daa le lepra blline' lawe'na' na' bc̱hek' xibe'na' lawe'na', chi'e: ―Shi cheenilo', wak yikwaso' yillwe'ni chak'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Na' biyesh'lallii Jesúza'ne', na' bx̱oa neena' yic̱hje'na' chi'e: ―Cheenid'x. Na' ṉaate yikwasa'n. ");
INSERT INTO zadNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na' katena' lii bikwaste léprana' na' biyakile'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Na' Jesúza', chi'ene': ");
INSERT INTO zadNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Kono yoo dga ba ben' c̱ho'. San wyaj jali'lawo' lao bx̱oza', na' jwa' daa chiyaḻ' lljoo lao Chioza' ka nllia dii Moiséza' bia' goncho kwenc̱he iṉezile' ba biyakilo'. ");
INSERT INTO zadNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Per ka bizee, wzoloe' bi'e dill' lao yog'ḻoḻ beṉ' daa gokə. Na' daa bene' ka', bich gok sho' Jesúza' ka nḻa'zə yellka', san bigaaṉe' ga kono beṉ' lle'. Per bia'kzə wyaj beṉ' za' wde wdeli yell jawiagake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wde to c̱hop lla, Jesúza' billine' sto shii yell Capernaúma'. Na' ka wṉezi beṉ'ka' lle' na' ba billine' yoona' gana' wzoe', ");
INSERT INTO zadNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","na' bdi'a bllag beṉ' zan inlleb ḻoo yoona' ax̱t bich chaki lesh' chyoona' she'gake'. Na' bli' bsedile' ḻegake' cho'a xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Na' bllin tap beṉ' nḻengake' to beṉ' net ṉi'a neena'. ");
INSERT INTO zadNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Na' daa bi gok illingake' gana' zete Jesúza' daa lle' beṉ' zan inlleb, na' wzologake' bsaljgake' koll' yoona' na' bḻetjgake'ne' do daa c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na' ka gokbe'i Jesúza' chajḻe'gake' c̱he', golle' beṉ' we'na': ―Xiiṉ, ba biyakxen saaxya c̱ho'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na' chi' baḻ beṉ'ka' chli' chsedi leya', na' wza'lall'gake': ");
INSERT INTO zadNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Berac̱he naz beeni ka'? Chonz kwine' ka Chioza'. Kono zoa sto beṉ' gak yizi'xen saaxya c̱he beṉ', san toz Chioza' gak yizi'xene'n.” ");
INSERT INTO zadNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na' lii gokbe'teyi Jesúza' daa chza'lall'gake', na' wṉabile' ḻegake', chi'e: ―¿Berac̱he chza'lall'zle ka'? ");
INSERT INTO zadNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Achakile chyalljchid' yeḻ' wak xench yep' beeni: “Ba bizi'xen' saaxya c̱ho'na'”, ka daa yepee: “Biyas na' bigoo nez”? ");
INSERT INTO zadNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Na' wliid' le', nad' Beṉ' Bseḻ' Chioza' nap' yeḻ' wṉabia' yell-lioni kwenc̱he yizi'xen' saaxya c̱he beṉ'. Na'ch golle' beena' net ṉi'a neena': ");
INSERT INTO zadNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Nia' li', biyas, bitob daa c̱ho'na', na' biyaj lillo'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na' lii biyastie' bitobe' daa c̱he'na' na' bizee chwiate beṉ'ka' lle' na'. Na' yog'zgake' bibani na' be'la'ogake' Chioza', che'gake': ―Bigaṉ' ile'icho ka dga. ");
INSERT INTO zadNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Na' wyaj Jesúza' sto shii cho'a nisdo'na' na' beṉ' zan janogake'ne', na' bli' bsedile' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na' wde Jesúza' gana' chi' Levína', xiiṉ Alfewa', chc̱hixje' daa chkaa beṉ' Rómaka'. Na' chi'ene': ―Da, dino nad'. Na' wzolla' Levína' janoe'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na' to shii Jesúza' len beṉ'ka' nakgake'ne' txen cheej chaogake' lill Levína', na' zan beṉ' wic̱hixjka' na' beṉ'ka' zeyi c̱hegake' nakgake' beṉ' mal cheej chaolengake'ne', ḻa' beṉ' zan ba nak beṉ'ka' no ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na' baḻ fariseoka', beṉ'ka' ḻekzka' chli' chsedi leya', ka ble'gakile' cheej chaolen Jesúza' beṉ'ka', na' gollgake' beṉ'ka' nakgake'ne' txen: ―¿Berac̱he cheej chaolenz beena' chli' chsedi le' beṉ' wic̱hixjka' na' beṉ' malka'? ");
INSERT INTO zadNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Na' ka beni Jesúza' che'gake' ka', na'ch chi'e: ―Beṉ'ka' zoa shi'a shao' aga no wen rmech chyalljgakile', san beṉ'ka' bi shawaan chyalljgakile'ne'. Ka'kzə nad', aga bid' ni c̱he beṉ'ka' nak beṉ' ḻi beṉ' shao', san ni c̱he beṉ' malkan' bid'. ");
INSERT INTO zadNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","To shii beṉ'ka' nak Juanna' txen na' beṉ'ka' nak fariseoka' txen chzoagake' wbas'. Na' baḻ beṉ' wyajgake' lao Jesúza' na' che'gake'ne': ―Beṉ'ka' nak Juanna' txen na' beṉ'ka' nak fariseoka' txen chzoagake' wbas'. ¿Berac̱he beṉ'ka' nakgake' li' txen bi chongake'n? ");
INSERT INTO zadNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Na' che' Jesúza' ḻegake': ―¿Awak soa beṉ'ka' chaxe' to ga chak wishagna' wbasaa shlak chak lṉina'? Bi gakan, ḻa' shlak zoalen beena' chshagna' ḻegake' aga wak soagake' wbasaa. ");
INSERT INTO zadNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","San wllin lla kat' yikwas beṉ' beena' chshagna' ladje'ka', kana'chan soagake' wbasaa. ");
INSERT INTO zadNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Ni to beṉ' bi chida' chichollee ḻee lech' gola' lat' lech' kob, ḻa' lech' koba' yibe'n kat' c̱hibe'n na' zizikli wc̱hez'chan lech' gola', na' dii xench gak gana' nchez'. ");
INSERT INTO zadNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ni biga zoa beṉ' chguee vino koba' ḻoo yid golka', ḻa' vino koba' wc̱hezaan yid gola' na' kwiayi' vino koba' lente yid gola'. Na' daan, chiyaḻ' sholl vino koba' ḻoo yid koba'. ");
INSERT INTO zadNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na' to lla sabd, llana' chombaaṉ beṉ' Israelka', wdelen Jesúza' beṉ'ka' nakgake'ne' txen to ga naz to beṉ' trigo, na' wzolo beṉ'ka' nakgake'ne' txen wdishjgake' trígona' wdaogake'n. ");
INSERT INTO zadNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Na' goll fariseoka'ne': ―¿Berac̱he chonz beṉ'ki nako' txen daa bi chiyaḻ' gongake' llani chombaaṉcho? ");
INSERT INTO zadNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Na' golle' ḻegake': ―¿Ani shlin biṉ' wlable daa ben dii Davina' to shii kon beṉ'ka' nakgake'ne' txen ka byallj daa gaogake'? ");
INSERT INTO zadNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kana' nak Abiatara' bx̱oz choo bx̱oz xen, wyoo Davina' gana' nongake' lill xḻatjə Chioza' na' wdoyoe' yetxtila' daa naki c̱he Chioza' na' wdaolene'n beṉ'ka' nakgake'ne' txen, ḻa'kzi toz bx̱ozkan' chiyaḻ' gaogake'n. ");
INSERT INTO zadNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Na' ḻekzka' golle' ḻegake': ―Chioza' wleje' llani chombaaṉcho kwenc̱he gaklenan beṉec̱ha', aga bx̱e bsile' beṉec̱ha' kwenc̱hezə we'la'ogake' llani chombaaṉchon. ");
INSERT INTO zadNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Daan, nad', Beṉ' Bseḻ' Chioza' Yell-lioni, chṉabi'a lao llani chombaaṉcho. ");
INSERT INTO zadNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na' sto shii wyaj Jesúza' gana' chdop chllaggake' choe'ḻwillgake' Chioza' na' ladj beṉ'ka' lle' na' len to beṉ' net neena' tḻaa. ");
INSERT INTO zadNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na' chwiayeṉ'gake' shi wiyon Jesúza'ne' lla sabda', llana' chombaaṉgake', kwenc̱he gaogake' xya c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Na' che' Jesúza' beena' net neena' tḻaa: ―Wzolla' na' wze gchoḻ beṉ'ki. ");
INSERT INTO zadNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Na'ch wṉabile' beṉ'ka' ndop nllag na': ―¿Beran na leya' chiyaḻ' goncho lla sabdka'? ¿Agoncho daa nak wen, anti goncho daa nak mal? ¿Ayislacho beṉ', anti witchone'? Na' kokzno billii xtilleena'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Na' ka chwie' beṉ'ka' lle' na', bllee na' gokyeshile' daa nakgake' beṉ' lall'do' c̱hec̱h, na' chi'e beena': ―Bḻi noona'. Na'ch bḻi na' beena' na' lii biyakteyin. ");
INSERT INTO zadNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Na' bichej fariseoka' na' wzologake' chgoogake' xṉezin len beṉ'ka' non Heródeza' txen kwenc̱he witgake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Na' biza' Jesúza' gana' zoe' na' zejlene' beṉ'ka' nakgake'ne' txen cho'a nisdo'na' na' beṉ' zan beṉ' Galiléaka' wnogake' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Na' beṉ' zan beṉ'ka' lle' gana' mbani Judeana', na' yell Jerusalénna', na' gana' mbani Idumeana', na' beṉ'ka' lle' shḻaa yao Jordánna' na' yellka' ndiḻ nllag yell Tírona' na'ch yell Sidónna', ka wṉezgakile' chon Jesúza' dii zan yeḻ' wak, na' wyajgake' jawiagake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Na' daa lle' beṉ' zan inlleb, golle' beṉ'ka' nakgake'ne' txen yisbig'gake' to barkw gana' lljshie' kwenc̱he bi idakwyill' beṉ' be beṉ' zilka' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ḻa' beṉ' zan inlleb ba biyone' na' yog' beṉ'ka' bi shao' chdi'a chllaggake' lawe'na' kwenc̱he gox̱'gake'ne' na' yiyakgakile'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na' dii x̱iw'ka' yoo baḻ beṉ'ka', ka chle'gakin Jesúza', chongakan ka chc̱hek' xib beṉ'ka' lawe'na' na' chosyaagakan, che'gakan: ―¡Lin' nako' Xiiṉ Chioza'! ");
INSERT INTO zadNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Na' Jesúza' bsheshlene'gakan kwenc̱he bi iṉagakan ka' ga lle' lla' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ka biyoll ben Jesúza' diika', na' wleje' baḻ beṉ'ka' wyazlallee gakgake'ne' txen na' wyajlengake'ne' to lo yaa. ");
INSERT INTO zadNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na' wleje' shlliṉ beṉ'ka' kwenc̱he talengake'ne' txen na' kwenc̱he wseḻee ḻegake' llje'gake' cho'a xtill' Chioza', na' bsi'e ḻegake' postl. ");
INSERT INTO zadNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Na' bi'e ḻegake' yeḻ' wṉabia' kwenc̱he yiyongake' beṉ'ka' bi shao' na' yibejgake' dii x̱iw'ka' yoo beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Beṉ'kin wleje' shlliṉ: Simónna', beena' bisi'e Pedro; ");
INSERT INTO zadNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacóbona' len beṉ' bishee Juanna', beṉ'ka' nak xiiṉ Zebedewa', (beṉ'ka' bsi'e Boanerges, daa zeji beṉ' nak ka yi' wziw' dii chashj chtin); ");
INSERT INTO zadNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","na' Andréza', Felípena', Bartoloména', Matewa', Tomáza', Jacóbona', xiiṉ Alfewa', Tadewa', Simón, beena' wlen cananistka', ");
INSERT INTO zadNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na'ch Jud Scariota', beena' bene' Jesúza' lo na' beṉ' malka'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Na' Jesúza' len beṉ'ka' nakgake'ne' txen biyajgake' gana' zoagake'. Na' daa bizdi'a bizllag beṉ' zan inlleb, ni bi gok latj gaogake'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ka wṉezi beṉ'ka' nak bish' ljwell Jesúza', wyajgake' nan lljaxi'gake'ne', ḻa' gokgakile' ba chaktonte'n. ");
INSERT INTO zadNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Na' ḻekzka' beṉ'ka' chli' chsedi leya', beṉ'ka' zaak Jerusalénna', nagake' c̱he': ―Bezlo daa chṉabia' dii x̱iw'kan' yo'e, na' yeḻ' wak c̱heyinnan' chisheshile' dii x̱iw'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Na' gox Jesúza' ḻegake' na' bzoe' to jempl lawe'ka', chi'e: ―¿Nakra gon Satanáza' yibej ljwell dii x̱iwiinna'? ");
INSERT INTO zadNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Beṉ'ka' lle' toz yell shi tiḻ-len ljwellgake' na' gakgake' c̱hoplə, aga ssha soagake'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na' beṉ'ka' lle' toz yoo shi illaa ljwellgake' na' gakgake' c̱hoplə, aga ssha soagake'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na' shi Satanáza' na' dii x̱iw'ka' nak lall' na'yin yiyakdiḻgakan na' gakgakan c̱hoplə, bi idiagakan, san ba bllin lla kwiayi'gakannan', shi ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Kono gak sho' ḻoo yoo lill to beṉ' wal na' kwane' bi de c̱he' shi bi wc̱heje'ne' zigaate, na'chan wtesh wḻoe' ḻoo lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Dii ḻi nia' le', Chioza' yizi'xene' yog'ḻoḻ saaxya na' yog'ḻoḻ dii mal daa chbell chṉe beṉ' c̱he'; ");
INSERT INTO zadNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","san beena' iṉe zban c̱he Espíritu Sántona', biga yizi'xene' c̱he', na' toshiizi gak xbaguee c̱heyi daa wchell wṉie' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Golle' ḻegake' ka' daa wnagake' c̱he' dii x̱iwaan yo'e. ");
INSERT INTO zadNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na'ch bllin xṉa' Jesúza' len beṉ' bisheeka', wzegake' lesh' chyoona' na' bseḻ'gake' beṉ' jaṉegake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na' beṉ'ka' chi' kwit Jesúza' gollgake'ne': ―Ba chiyilj xṉoona' li' len beṉ' bishooka'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Na' chi'e ḻegake': ―¿Aṉezile noran xṉa'na' na' beṉ' bishaaka'? ");
INSERT INTO zadNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Na' chwie' beṉ'ka' chi' kwite'na' na'ch chi'e: ―Beṉ'kin xṉa'na' na' beṉ' bishaaka'. ");
INSERT INTO zadNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nottezə beena' chon ka cheeni Chioza', ḻen' beṉ' bishaana', beṉ' zanna' na'ch xṉa'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sto shii wzolo Jesúza' bli' bsedile' beṉ' cho'a nisdo'na', na' daa bdop bllag beṉ' zan inlleb jshie' to ḻoo barkw daa chi' cho'a nisdo'na', na' beṉ'ka' bdi'a bllag wlle'gake' cho'a nisdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na' dii zan dii bli' bsedile' ḻegake' na' bc̱hine' jemplka', na' golle' ḻegake': ");
INSERT INTO zadNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Ḻi wzenag dga. To beṉ' goz gooṉ wzee zeje' goza'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Na' ka zej chzaḻee biṉna', baḻan bxop cho'a neza' na' bllin byiṉka' wdaogakban. ");
INSERT INTO zadNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Na' zi baḻan bxop ladj yajka', gana' bitek bi yo chi'. Na' tolbe' bilaan, daa bi chi'tekan yona'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Per ka bla' wbilla', bkwedgakan. Na' daa bi bde loinna', wbillan. ");
INSERT INTO zadNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Na' zi baḻan bxop ladj yag yesh'ka' na' yag yesh'ka' bi be'gakan latj igolgakan na' bibi wllian. ");
INSERT INTO zadNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Na' zi baḻan bxop gana' chi' yo wenna', na' bgolgakan na' ḻe wlliagakan. Baḻan wllia shichoa wej, na' zi baḻan guiyon wej, na'ch to guiyoa wej. ");
INSERT INTO zadNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na' chi'e ḻegake': ―Ka le' chenile dga nia', ḻi sen wṉeyi. ");
INSERT INTO zadNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na' ka bgaaṉ stoz Jesúza', beṉ'ka' wlle' gaoshosh kwite'na' len beṉ'ka' shlliṉ, wṉabgakile'ne' bi zeji jempla' daa bseesile' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Na' chi'e ḻegake': ―Chioza' cho'e latj iṉezile daa kono wṉezi c̱he yeḻ' wṉabia' c̱he'na'. Per beṉ'ka' bi chzenag c̱he', chseesid' ḻegake' jemplka' ");
INSERT INTO zadNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kwenc̱he ḻa'kzi ile'tegakile' ka chon', bi shajni'gakile' bi zejin, na' ḻa'kzi yentegakile' xtillaana', bi shajni'gakile'n, kwenc̱he bi yiyaj yilengakile' lao Chioza' na' bi yizi'xene' c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na' chi'e ḻegake': ―Shi bi chajniile jempli, ¿nakra gonle shajniile diika' sto? ");
INSERT INTO zadNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Beena' chaz zaklebile' beena' choe' cho'a xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Zoa beṉ' chengakile' cho'a xtill' Chioza' na' kat' ba bengakile'n, ḻii zejte dii x̱iwaa chikwasan daa ḻoo yic̱hjlall'do'eka'. Na' chak c̱hegake' ka gok c̱he biṉna' daa bxop cho'a neza'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Zi baḻgake' chak c̱hegake' ka gok c̱he biṉna' daa bxop ladj yajka' na' aga bi logakin bde. Ḻa' ka chengakile' cho'a xtill Chioza' chiba chizak'gakile' chzenaggake'n ");
INSERT INTO zadNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","per shlollchga chajḻe'gake'. Na' kat' bi chen chle'gakile' ni c̱he cho'a xtill' Chioza', lii chbej yic̱hjtegake'n. ");
INSERT INTO zadNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Zi baḻgake' chak c̱hegake' ka gok c̱he biṉna' daa bxop ladj yag yesh'ka'. Chengakile' cho'a xtill' Chioza', ");
INSERT INTO zadNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","per chi' yic̱hjgake' diika' chak c̱hegake', na' zetegake' wṉeyi c̱he yeḻ' wni'ana' na' chzelall'tegake' yog'ḻoḻte daa de yell-lioni. Na' ḻegakannan' chsej chllongakan gon xshin cho'a xtill' Chioza' ḻoo yic̱hjlall'do'eka'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Na' zoa zi baḻ beṉ' chengakile' cho'a xtill' Chioza' na' chajḻe'gake' do yic̱hj do lall'gake', na' chon xshinin ḻoo yic̱hjlall'do'eka'. Na' chak c̱hegake' ka biṉna' bxop lo yo wenna' daa wllia shichoa wej, na' guiyon wej na'ch to guiyoa wej. ");
INSERT INTO zadNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Na' ḻekzka' chi'e ḻegake': ―Biga zoa beṉ' chxene' kandila' na' chdose'n to dii wkwashaan ḻen wa chṉi'en xan xḻague'na', san chzoe'n sibə kwenc̱he wzeeni'n doxen ḻoo yoona'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na' ḻekzka' yog'ḻoḻte dii ngash' ṉaa wllin lla yila' lawin, na' daa kono ṉezi ṉaa wllin lla iṉezi beṉaan. ");
INSERT INTO zadNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Le' chenile dga nia', ḻi sen wṉeyi. ");
INSERT INTO zadNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Na' ḻekzka' chi'e ḻegake': ―Ḻi se wṉeyi c̱heyi dga chzenagle. Na' shi gonle ka dii le, Chioza' wzajni'chile' le' dii xench. ");
INSERT INTO zadNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Beena' chzenag, zizikchli shajni'chile', na' beena' bi chzenag, ax̱t daa ba benile' lat' yiyaḻ-lallee. ");
INSERT INTO zadNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Na' ḻekzka' chi'e ḻegake': ―Yeḻ' wṉabia' c̱he Chioza' zaklebin daa chak c̱he biṉna' chaz beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Beena' chaz chaaṉ, chila' daa chaze' na' chgolan ḻa'kzi chese' wa chec̱hj chdaze', ka'kzə shi waḻ wa tella, na' ni bi ṉezile' nak chak chgolan. ");
INSERT INTO zadNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Lo yell-lioni chla' daa chaz beṉ': zigaate chila'n, na' chgolan, na' chzen do, na'tech chbian. ");
INSERT INTO zadNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Na' kat' ba gol daa chbian, na' chizi' chilape'n. ");
INSERT INTO zadNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ḻekzka' che' Jesúza' ḻegake': ―¿Bera ka wsaklebicho yeḻ' wṉabia' c̱he Chioza', lla? wa ¿bera ka jempl wc̱hincho wsaklebichon? ");
INSERT INTO zadNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yeḻ' wṉabia' c̱he Chioza' nakan ka sa mostásana' daa chazgake'. Ḻa'kzi ḻennan' biṉna' daa ḻiizelozi nesh'ch, ");
INSERT INTO zadNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","kat' ba bla'n na'ch chgolan na' chakan dii xench ka yog'te yix̱' kwan yoblə, na' chak xoziinka' dii xen ax̱t byiṉdo'ka' wak lljshiagakban na' sho'gakb xol c̱heyinna'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Dii zan jempl bc̱hin Jesúza' ka bli' bsedile' beṉ'ka' cho'a xtill' Chioza', bene' kon ga zeelo wyajni'gakile'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Na' toshiizi bzoe' jemplka' lao beṉ'ka' bdi'a bllag, na' toz beṉ'ka' nakgake'ne' txen bizajniile' bi zejin yog' diika'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na' ka goḻ, golle' beṉ'ka' nakgake'ne' txen: ―Techo shḻaa nisdo'ni. ");
INSERT INTO zadNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Na' biza'gake' kwit beṉ'ka' bdi'a bllag na' bic̱he'gake' Jesúza' ḻoo barkwa' daa chi' cho'a nisdo'na', na' lench barkw yoblə ziyajlengake'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Na' wze to yejpe' wal na' wzolo nisdo'na' chas chataan ax̱t ba chiyollan ḻoo barkwa', na' ba wzolo chbe'n yel. ");
INSERT INTO zadNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Na' ba de Jesúza' chese' xaninna' nkogtie' to dii nkogue', na' jasbangake'ne' che'gake': ―¡Maestro! ¿Abikzə chakbe'ilo' ba chbe'cho yel? ");
INSERT INTO zadNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Na' wyase' bsheshlene' be'na', na' chi'e nisdo'na': ―Lliz wzoa. Na' wlez be'na' na' wche'lli nisdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Na' golle' beṉ'ka' nakgake'ne' txen: ―¿Bic̱he chllebzle? ¿Abikzaṉ' gonḻilall'le nad'? ");
INSERT INTO zadNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na' ḻe bllebgake', na' che' ljwellgake': ―¿Nora beeni, lla?, ax̱t be'na' na'ch nisdo'ni chzoagakan xtillee. ");
INSERT INTO zadNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Na'ch bllingake' gana' mbani Gadárana' daa llia shḻaa nisdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Na' ka bichej Jesúza' ḻoo barkwa', na' wbig' to beṉ' yo'e dii x̱iwaa. Na' beeni bcheje' ḻoo kapsanta' ");
INSERT INTO zadNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","gana' none' ka lill xḻatje'. Na' kono gok wc̱hej ḻe', ni gdenna' bi ben llin. ");
INSERT INTO zadNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Zan shii bc̱hejgake' ṉi'a neena' gdenka', na' tolbe'do' chc̱hogue'gakan, na' kono wzoyi ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ka waḻ ka tella chec̱hj chde' yaa yaoka' na'ch kapsanta' chosyaadie' na' chgoyoe' yajka' chon kwine' zi'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","De zit'lə ble'ile' zej Jesúza' na' bxoṉjdoe' jatiḻe'ne' na' jac̱hek' xibe'na' lawe'na', ");
INSERT INTO zadNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","na' besyee zillj, chi'e: ―¡Bi wlalli' c̱ho' kon nad', Jesús, Xiiṉ Chios, beṉ' choo beṉ' xen! Chat'yoid' li', ¡bc̱heb lao Chioza' bi wsak'zi'o nad'! ");
INSERT INTO zadNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Gollan ka' daa goll Jesúza' ḻen: ―¡Dii x̱iw', bichej ḻoo kwerp c̱he beeni! ");
INSERT INTO zadNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Na' goll Jesúza' ḻen: ―¿Bin lio'? Na' che'n: ―Legiónan lia', ḻa' zannto' nak. ");
INSERT INTO zadNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na' got'yochgain Jesúza' bi wseḻeegakan gan yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na' gaozə kwit yaana' gana' lle'gake', lle' zan kush chaogakb. ");
INSERT INTO zadNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Na' got'yoi dii x̱iw'ka' ḻe', che'gakan: ―Bseḻ' neto' gana' lle' kushka' na' be' latj yiyoonto' ḻegakb. ");
INSERT INTO zadNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na' bi'e latj c̱hegakin, na' bichejgakan jayoogakan kushka'. Na' nakgakb ka c̱hopa mil, na' wzologakb chxoṉjdogakb jabix̱gakb ḻoo nisdo'na', na' jc̱he'gakb yel. ");
INSERT INTO zadNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Na' beṉ'ka' chap kushka' ziyajdogake' jayellgake' beṉ'ka' lle' yella' na' beṉ'ka' lle' lyix̱aa daa ble'gakile', na' beṉ' zan jawia daa gok. ");
INSERT INTO zadNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Na' ka bllingake' gana' ze Jesúza', ble'gakile' beena' wyoo dii x̱iw'ka' chi'e kwite'na' ba biyakw xe'na' na' ba biyeeṉ biyeeniile', na' bllebgake'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na' beṉ'ka' ble'i daa gok c̱he beena' wyoo dii x̱iw'ka' na' daa gok c̱he kushka', be'gake'n dill' lao beṉ'ka' bllin. ");
INSERT INTO zadNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Na' got'yogakile' Jesúza' yiyaje' gan yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ka chiyoo Jesúza' ḻoo barkwa', beena' wyoo dii x̱iw'ka' got'yoile'ne' wi'e latj shajlene'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Per bi bi'e latj, san chi'ene': ―Biyaj lillo'na' gana' lle' bish' ljwello'ka', na' jayellgake' ka nak diiki ba ben X̱ancho Chioza' c̱ho' na' ka ba biyesh'lallile' li'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Na'ch biza' beena' na' jaye' dill' doxen gana' mbani Decápoliza' daa ben Jesúza' c̱he', na' yog' beṉ' bibani. ");
INSERT INTO zadNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ka billinlen Jesúza' barkwa' shḻaa nisdo'na', na' bdi'a bllag beṉ' zan cho'a nisdo'na' gana' billine'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Na' bllin to beṉ' le Jairo, nake' to beṉ'ka' chgoogake' xṉezi diika' chon beṉ' Israelka' gana' chdop chllaggake' choe'ḻwillgake' Chioza'. Na' ka blline' gana' ze Jesúza', bc̱hek' xibe' lawe'na' ");
INSERT INTO zadNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","na' benyesh'chgue', chi'e: ―Ba chet bi' c̱ha'na'. Ben goklen sho'gach wx̱oa noona' yic̱hjbaa kwenc̱he yiyakib' na' ibanchb'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Na' wyajlen Jesúza' ḻe', na' beṉ' zan inlleb nogake'ne' ax̱t bdakwyillgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na' ladj beṉ' zan walka' len to noolə ba gok shlliṉ yiz chzoe' wbaa. ");
INSERT INTO zadNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dii zan dii ba ben ble'ile' lao beṉ' wen rmechka', na' ba blliayee yog' dii de c̱he' na' bi gokkze' rmech, san gokxinlile'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Na' ka benile' xtill' Jesúza', jṉi'e ladj beṉ' zan walka' no ḻe' na' jex̱ee xe'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ḻa' gokile': “Ḻa'c̱h' xe'na' sheḻ' ba bex̱aa, na' yiyakid'.” ");
INSERT INTO zadNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Na' katena' wlez wbaana' na' gokbe'ile' ba bigaa yillwe' c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na' gokbe'i Jesúza' bchej yeḻ' wak c̱he'na', na' biyec̱hje' chi'e beṉ'ka': ―¿Noran bex̱' xa'na'? ");
INSERT INTO zadNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Na' beṉ'ka' non ḻe' txen che'gake'ne': ―Beṉ' zan walan ndakwyill li'. ¿Bic̱he nazo': “Non ba bex̱' nad'”? ");
INSERT INTO zadNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Na' ze Jesúza' chwie' beṉ'ka' lle' kwite'na' kwenc̱he iṉezile' non bex̱' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na'ch noola', daa ba gokbe'ile' biyakile', de chall chllebzile' wdie' na' bc̱hek' xibe'na' lawe'na' na' golle' ḻe' doxen daa ba gok c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Na' che' Jesúza'ne': ―Xiiṉ', daa chonḻilalloo nadaan ba biyakilo'. Biyaj mbalaz daa ba bigaa yillwe'na' bsak'zi' li'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na' ni chshaljte Jesúza' ka bllin to c̱hop beṉ' wza' lill Jairona', chi'ene': ―Ba wit bi' c̱ho'na'. Bich gonilo' maestroni zed. ");
INSERT INTO zadNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Na' bi ben Jesúza' ḻegake' kwent, na' golle' Jairona': ―Bi illebo'. Kon bx̱enilall' nad'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Na' bi bi'e latj shajlen beṉ' yoblə ḻe', ḻete Pédrona' na' c̱hop bish'te, Jacóbona' na'ch Juanna'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Na' ka bllingake' lill Jairona', ble'ile' ḻe chakyeshii beṉ'ka' lle' na' na'ch chbellgake' na' ḻe chosyaagake'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Na' jabiguee gana' lle'gake' na' golle' ḻegake': ―¿Berac̱he chonzle daṉe na' chbellzle? Aga ba wit bi'do'nan', san cheszbaan. ");
INSERT INTO zadNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na' bxillgakile' Jesúza'. Na' bisheshe' yog'ḻoḻe' na' wyoolene' x̱axṉa'baa na' beṉ'ka' zejlene' txen gana' de bi'do'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Na' bex̱ee na'baa na' golle'b': ―Talita, cumi ―na' zejin: Bi' nooldo', nia' li' biyas. ");
INSERT INTO zadNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Na' bi' nooldo'na' lii biyasteb' na' bidab', ḻa' ba gokkzib' shlliṉ yizan. Na' bibanchgayi beṉ'ka' lle' na'. ");
INSERT INTO zadNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Na' Jesúza' bene' mandad kono ye'gake' daa gok, na' golle' ḻegake' we'gake' dii gao bi'do'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na' biza' Jesúza' biyaje' lalle'na', na' beṉ'ka' nakgake'ne' txen zejlengake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na' ka bllin lla sabda', llana' chombaaṉ beṉ' Israelka', wyaje' gana' chdop chllaggake' choe'ḻwillgake' Chioza' na' wzoloe' bli' bsedile' beṉ'ka' lle' na'. Na' zan beṉ'ka' bzenag xtilleena' bibangakile', na' che'gake': ―¿Gara jasedz beeni diiki, lla? ¿Gara za' yeḻ' sin' c̱he beeni, na' yeḻ' wakka' chone', lla? ");
INSERT INTO zadNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Aaga beenin karpintera', beena' nak xiiṉ Maríana', na' beṉ' bish' Jacóbona', Joséna', Júdaza' na'ch Simónna'? Na' ḻekzka' beṉ' zane'ka' zoagake' lallchoni. Na' bi wyajḻe'gake' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Na' che' Jesúza' ḻegake': ―To beṉ' chyix̱jee daa che' Chioza'ne', gattez chgoogake'ne' balaaṉ, san lall lille'na' aga no chgoo ḻe' balaaṉ. ");
INSERT INTO zadNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na' aga bitek yeḻ' wak gok gone' na', ḻete x̱onjchga beṉ' we'ka' bx̱oa neena' yic̱hje'ka' na' biyone' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Na' bibanile' daa bi chajḻe' beṉ'ka' c̱he'. Na' wde' bli' bsedile' beṉ'ka' lle' to to yellka' llia gaozə yell Nazareta'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na' wṉie' beṉ'ka' shlliṉ, na' bseḻee c̱hop weje', na' bi'e ḻegake' yeḻ' wṉabia' kwenc̱he yibejgake' dii x̱iw'ka' yoo beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Na' golle' ḻegake' bibi gox̱'gake' kat' koogake' nez; bi chiyaḻ' wa'gake' yix̱j ga koo xshinḻaze'ka', ni dii gaogake', ni mech, san twejz yag bar gox̱'gake'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Na' shkwe'z xelgake' wlej, na' zi shkwe'z xe'ka' gakw. ");
INSERT INTO zadNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Na' chi'e ḻegake': ―Yoona' gana' illinle, na'z soale ax̱t ka illinch lla yiza'le. ");
INSERT INTO zadNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na' yella' gana' bi wlebgake' le' ni bi wzenaggake' c̱hele, ka yiza'le na', yishible bishtena' llia ṉi'aleka' kwenc̱he gakbe'gakile' aga wenan chongake' bi chlebgake' cho'a xtill' Chioza'. Dii ḻi nia' le', kat' illin lla wc̱hoglo Chioza' c̱he beṉ', beṉ'ka' lle' yella' gana' bi wlebgake' le', ile'gakile' yeḻ' zak'zi' xench aga ka beṉ'ka' wlle' yell Sodómana' na' yell Gomórrana'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Na' wza'gake' zjtix̱je'gakile' beṉ' chiyaḻ' yiyaj yilengakile' saaxya c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Na' bibejgake' zan dii x̱iw'ka' yoo beṉ', na' bshongake' lat' wej seta' yic̱hj beṉ'ka' bi shao' na' biyakgakile'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na' Heródeza', beena' wṉabia' gana' mbani Galileana', benile' yog' daa chon Jesúza', daa ḻe ba zeyi c̱he'. Baḻ beṉ'ka' che'gake': ―Dii Juanna', beena' bchoa beṉ' nisan' ba biban, daan chone' yeḻ' wakka'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Zi baḻe' che': ―Elíazan' ba biyed. Na' zi baḻe' che': ―Nake' beṉ' chyix̱jee daa che' Chioza'ne', ka beṉ'ka' wzoa kani'yi. ");
INSERT INTO zadNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ka beni Heródeza' dill'ki, na' chi'e: ―¡Beenan' dii Juanna', beena' ben' mandad wchog yic̱hje'na'! ¡Ba bibane' ladj beṉ' wetka'! ");
INSERT INTO zadNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ḻa' kwin Heródeza' bene' mandad bex̱'gake' Juanna' na' bseje'ne' lillyana' daa bseshlene'ne' daa bikee Herodíaza', xool beṉ' bishee, Felípena'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juanna' golle'ne': ―Xya nlleb nakan bikoo xool beṉ' bishoona'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Na' bllaa Herodíaza' Juanna' na' goklallee wite'ne', per bibi gok gone' ");
INSERT INTO zadNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","daa chlleb Heródeza' Juanna', daa ṉezile' nake' to beṉ' ḻi beṉ' shao' beṉ' nak lall' na' Chioza', na' bi bi'e latj no bi goni ḻe'. Na' ḻa'kzi chakc̱hoplallee c̱he dill'ka' cho'e, bibaile' bzenague' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Per ka wyayi Heródeza' yiz, bene' to lṉi na' goxe' beṉ'ka' chṉabia', na' x̱an soldadka', na' beṉ'ka' mbejlawin gana' mbani Galileana'. Na' got' xḻatjin gon Herodíaza' ka cheenile'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Na' bi' nool wew' c̱he Herodíaza' byaab' lao beṉ'ka' lle' lṉina', na' ḻe bibayi Heródeza' len beṉ'ka' chaolene' ka byaab'. Na' golle'b': ―Wṉab bittezə cheenilo' na' goṉa'n. ");
INSERT INTO zadNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na' bc̱hebe' wi'eb' daa cheenib', ḻa'kzi ax̱t gashj gana' chṉabi'e wi'eb'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na' bichejb' jaṉabib' xṉa'baa: ―¿Bera ka iṉab', lla? Na' che' xṉa'baa: ―Wṉab yic̱hj Juan wichoa nisa'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na' lii biyooteb' gana' chi' Heródeza', na' che'b': ―Cheenid' yic̱hj Juanna' to lo plat llilj ṉaate. ");
INSERT INTO zadNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Na' ḻe gokyeshii Heródeza', per daa ba bc̱heble' lao yog' beṉ'ka' goxe', bi goklallee wllonile'b' daa chṉabib' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Na' lii bseḻ'tie' to soldad jac̱hogue' yen Juanna' ḻoo lillyana' ");
INSERT INTO zadNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","na' bllie' yic̱hje'na' to lo plat. Na' bi'en bi' nool wewaa na' ḻeb' be'baan xṉa'baa. ");
INSERT INTO zadNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ka wṉezi beṉ'ka' nak Juanna' txen, na' jaxi'gake' kwerp c̱he'na' na' jakwash'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ka billin postlka' gana' zoa Jesúza', na' gollgake'ne' yog' diika' jengake' na' daa jali' jasedgakile' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na' che' Jesúza' ḻegake': ―Ḻi sho' shajcho ga kono beṉ' lle' kwenc̱he yizi'lall'lat'cho. Golle' ka' daa ḻe chdia chllag beṉ' zan lawe'ka', na' ni bi chak latj gaogake'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Na' wyoogake' to barkw wyajgake' ga kono beṉ' lle'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Na' beṉ' zan ble'gakile' ka wza'gake' na' biyombia'gake' ḻegake', na' wza'do beṉ'ka' lle' to to yell zejdogake' gana' illin barkwa' na' nechləgake' bllin. ");
INSERT INTO zadNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Na' ka bichej Jesúza' ḻoo barkwa' ble'ile' ba bdi'a bllag beṉ' zan inlleb na' biyesh'lallile' ḻegake' daa nakgake' ka xil'do', ba kono x̱anin zoa. Na' wzoloe' dii zan dii bli' bsedile' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Na' ka wlle', beṉ'ka' nakgake'ne' txen wbig'gake' lawe'na' che'gake'ne': ―Ba wlle' ṉaa, na' gani lle'cho kono zoa wit' dii gaocho. ");
INSERT INTO zadNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Goll beṉ'ki yiyajgake' ranshka', na' yellka' llia gaozə kwenc̱he lljx̱i'gake' daa gaogake'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Na' che' Jesúza' ḻegake': ―Len', ḻi we' dii gaogake'. Na' che'gake'ne': ―¿Nakra gonnto' lljx̱i'nto' yetxtilka' gao yog' beṉ'ki? ḻa' wyejljain c̱he c̱hop guiyoa lla c̱he laxj beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Na' che' Jesúza' ḻegake': ―Ḻi lljawia ka'k' yetxtilka' naple. Na' ka wṉezgakile' ka'ka'n de, na' che'gake'ne': ―De gayaan, na' zi c̱hop beḻ. ");
INSERT INTO zadNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Na'ch goll Jesúza' ḻegake' kwekgake' x̱oṉj wej beṉ'ka' lo yixa'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na' wche' to guiyoa wejgake' na' shiyon wejgake'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Na' bex̱' Jesúza' yetxtilka' gay' na' beḻka' zi c̱hop na' bḻis jalawe'na' yabalə bi'e Chioza' yeḻ' chox̱ken, na' bxoxje' yetxtilka' bi'en beṉ'ka' nakgake'ne' txen kwenc̱he be'gake' c̱he c̱he beṉ'ka'. Na' ḻekzka' yog'gake' be'gake' beḻka'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na' yog'ḻoḻgake' wdaogake' ka beljgakile'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Na' postlka' bitopgake' yetxtilka' len beḻka' bichooṉan, na' biyakan zi shlliṉ xet'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na' beṉ'ka' wdao, to beṉ' byoka'zə gokgake' gayaa mil. ");
INSERT INTO zadNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Na' ka wde, bigoo Jesúza' beṉ'ka' nakgake'ne' txen ḻoo barkwa' kwenc̱he yibialogake' lawe'na' yiyajgake' Betsáidana' daa llia zi shḻaa nisdo'na', shlak bisee beṉ'ka' bdi'a bllag na'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Na' ka biya beṉ'ka' billesh, na' wyaje' lo yaana' jeḻwille' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Na' ka goḻ, ba zej barkwa' gchoḻ nisdo'na' na' stoz Jesúza' bgaaṉe' gana' biza'n. ");
INSERT INTO zadNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na' ble'ile' ḻe chllaglogaken' daa za' be'na' gana' zejləgake'. Na' ni baḻ wlo'e nez tlo nisdo'na' zeje' gana' ziyajlgake'. Na' ba zoa yidie' lawe'ka' ");
INSERT INTO zadNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ka ble'gakile'ne' zeje' tlo nisdo'na' na' gokgakile' yel bx̱enzan. Na' besyaagake' ");
INSERT INTO zadNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","daa ḻe bllebgake' daa ble'gakile'. Na' lii wṉetie' ḻegake', chi'e: ―Bi illeble, nad'kzan. ");
INSERT INTO zadNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Na' biyepe' ḻoo barkwa' na' wche'lli be'na'. Na' ḻe bibangakile', ");
INSERT INTO zadNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ḻa' aga ba wyajni'gakile' yeḻ' waka' daa bene' c̱he yetxtilka' daa gokgake' beṉ' lall'do' wal. ");
INSERT INTO zadNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Na' ka biyoll wdegake' lo nisdo'na' na' bllingake' yell-lio daa mbani Genesareta', na' bda' barkw c̱he'ka' yag cho'a nisdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ka bchejgake' ḻoo barkwa', lii biyombia'te beṉ' Genesaretka' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Na' wdadogake' doxen gana' mbani lalle'ka' btopgake' beṉ' bi shao', na' lo daazə nx̱oagake' ḻegake' chjwa'gake' ḻegake' gana' ṉezgakile' bllin Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na' gattezə chaje' ḻaa yelldo'ka' ḻaa yell xenka', wa ḻaa ranshka', chyix̱jgake' beṉ'ka' bi shao' tneza' gana' chdie'. Na' chat'yogakile'ne' wi'e latj gox̱'gake' ḻa'c̱h' xe'na'. Na' yog' beṉ'ka' gok bex̱'gake'n biyakgakile'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseoka' len zi baḻ beṉ'ka' chli' chsedi leya', beṉ'ka' zaak Jerusalénna', bllingake' lao Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Na' ka ble'gakile' baḻ beṉ'ka' nak Jesúza' txen bi bix̱is biyib neeka' ka zi' gaogake', na' wdaogake' xya c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Ḻa' fariseoka' len yog'z beṉ' Israelka' ni nogake' daa bli' bsedi dii x̱ozxtoe'ka' ḻegake' nan bi gak gaogake' shi biṉ' yix̱is yiyib neeka'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na' ka chiyoll chajgake' lao yaana' shi bi yix̱is yiyib neeka' bi gak gaogake'. Na' ḻekzka' chix̱is chiyibgake' diika' cheej chaogakile'. Na' dii zanch diika' yoologake' chongake'.) ");
INSERT INTO zadNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Na' fariseoka' len beṉ'ka' chli' chsedi leya' wṉabgakile' Jesúza', che'gake': ―¿Bic̱he bi chon beṉ'ki nako' txen ka bli' bsedi dii x̱ozxto'choka' cho'?, ḻa' bi chix̱is chiyib neeka' kat' cheej chaogake'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Na' che' Jesúza' ḻegake': ―Kwasḻoḻ inlleban wṉe dii Isaíaza' c̱hele, le' beṉ' wxiye', kana' bzeje' daa na: Ka nak beṉ'ki, de cho'a dill'zan choe'la'ogake' nad', na' aga choe'la'ogake' nad' do yic̱hj do lall'gake'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bibi zjanayin chongake' ka choe'la'o nad'; na' daa chli' chsedgakile' nakan dii chyiljlall'z beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Na' le' chbej yic̱hjle daa nllia Chioza' bia' gonle kwenc̱he gonle daa chyiljlall' beṉ' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na' ḻekzka' golle' ḻegake': ―Chzoale ka'lə daa nllia Chioza' bia' gonle kwenc̱he gonle daa bli' bsedi dii x̱ozxto'leka' le'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moiséza' wne': “Ḻi koo x̱axṉa'lena' balaaṉ”, na' “Beena' iṉe zban c̱he x̱axṉeena' chiyaḻ' guete'.” ");
INSERT INTO zadNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Na' le' choe'le latj yee beṉ' x̱axṉeena': “Bi gak gaklen' le', ḻa' yog' dga de c̱ha' ba nc̱heb' wi'an Chioza'.” ");
INSERT INTO zadNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Na' daa nale ka', bich chonle byen gaklen beṉ' x̱axṉeena'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Na' daa chonle ka', chzoale cho'a xtill' Chioza' ka'lə kwenc̱he chonle daa bli' bsedi dii x̱ozxto'leka' le'. Na' dii zanch ka dga chonle. ");
INSERT INTO zadNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Na' wṉe Jesúza' yog' beṉ'ka' lle' na', na' golle' ḻegake': ―Ḻi wzenag dga iṉia' le', na' ḻi shajniin: ");
INSERT INTO zadNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Aga daa cheej chao beṉ' yell-lionin chx̱iṉj chḻenan ḻe'. San daa chalj chxe ḻoo yic̱hjlall'do'enan' chx̱iṉj chḻenan ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ka le' chenile dga nia', ḻi sen wṉeyi. ");
INSERT INTO zadNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Na' ka bikwase' kwit beṉ'ka' lle' na' biyo'e ḻoo yoona' gana' zoagake', na' beṉ'ka' nakgake'ne' txen wṉabgakile'ne' bi zejin daa golle' beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Na' golle' ḻegake': ―¿Ani le' bi chajniilen? ¿Abi chajniile aga daa cheej chao beṉaan chx̱iṉj chḻenan ḻe'? ");
INSERT INTO zadNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ḻa' aga ḻoo yic̱hjlall'do'enan' illinan, san ḻoo ḻi'enan' lljc̱he'n, na'tech yichejan. Na' daa golle' ka', zejin bittezə yeḻ' wao wak yeej gaocho. ");
INSERT INTO zadNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na' ḻekzka' golle': ―Daa chchej ḻoo yic̱hjlall'do' beṉ' yell-lioni, ḻennan' chx̱iṉj chḻenan ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ḻa' ḻoo yic̱hjlall'do'ekan' chalj chxe diiki bi nak wen: yeḻ' chza'lall' mal, yeḻ' chṉelen ljwellin, yeḻ' chiyit ljwellin, ");
INSERT INTO zadNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yeḻ' wban, yeḻ' wzelall', yeḻ' wen dii mal, yeḻ' wxiye', yeḻ' wenlen kwerp c̱heyinna' daa bi nxe bi nzak', yeḻ' xe', yeḻ' wyilj wzan dill' c̱he beṉ', yeḻ' chep cha'lall', na' yeḻ' nc̱hoḻ nniti. ");
INSERT INTO zadNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yog'ḻoḻ dii malki chalj chxegakan ḻoo yic̱hjlall'do' beṉ' na' chx̱iṉj chḻengakan ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Na' biza' Jesúza' gana' wzoe' na' ziyaje' gana' mbani yell Tírona' na'ch yell Sidónna'. Na' blline' to yoo na' bi goklallee no iṉezin, per bi gok wkwashee. ");
INSERT INTO zadNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Na' to noolə, beṉ' zoa to bi' nool c̱he' yoob' dii x̱iwaa, ka wṉezile' bllin Jesúza', lii wyajtie' jac̱hek' xibe'na' lawe'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Na' noola' nake' beṉ' griego, na' golje' gana' mbani Sirofeníciana'. Na' got'yoile' Jesúza' yibeje' dii x̱iwaa yoo bi' nool c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Na' goll Jesúza' ḻe': ―Yog'zə beṉ' zigaate chwawe' xiiṉe'ka'. Ḻa' bi nakan wen koyocho daa chao xiiṉchoka' na' wzaḻ'chon lao bekw'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Na' che' noola' ḻe': ―Lekzilo'n, beṉ'do', per bekw'ka' chbe'gakb xan mesa' na' chitopgakb bḻaaka' chxop. ");
INSERT INTO zadNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Na'ch golle'ne': ―Ni c̱he dillii ba bi'o, biyaj mbalaz. Ba bichej dii x̱iwaa yoo bi' c̱ho'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na' ka billin noola' lille'na', ble'ile' bi' nool c̱he'na' deb' lo blaga' na' ba bichej dii x̱iwaa wyoob'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Na' biza' Jesúza' gana' mbani Tírona' na' bidie' yell Sidónna' na' billine' gana' de nisdo' c̱he Galileana', gana' mbani Decápoliza'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na' jwa'gake' lawe'na' to beṉ' kwell na' leyi bi cha'yeṉ' iṉie', na' got'yogakile'ne' wx̱oa neena' yic̱hje'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Na' bc̱he' Jesúza'ne' ka'lə gana' kono lle', na' bṉe' xbene'na' ḻoo nague'na', na' bllaa x̱eneena' lo xbene'na', bshile'n lo ḻoll' beena'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Na' bḻis jalawe'na' cha'lə, wkaalallee, na' golle'ne': ―¡Éfata! ―zejin: ¡Byalj! ");
INSERT INTO zadNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na' lii byaljte nague'na', na' gok bita ḻolleena' na' bishalje' wen. ");
INSERT INTO zadNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Na' che' Jesúza' beṉ'ka' ble'i kono ye'gake' ka'. Na' ḻa'kzi golle' ḻegake' ka', zizikli bzegake'n dill'. ");
INSERT INTO zadNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na' ḻe bibangakile', che'gake': ―Yog'ḻoḻte chak gon beeni, chiyone' beṉ'ka' bi cheni, na' beṉ'ka' bi chak iṉe, chone' ka chṉegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Do kana', beṉ' zan inlleb bdop bllag. Na' daa bibi de yeej gaogake', wṉe Jesúza' beṉ'ka' nakgake'ne' txen chi'e ḻegake': ");
INSERT INTO zadNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Chiyeshid' beṉ'ki, ḻa' ba gok shoṉ lla zoalengake' nad' na' bibi de yeej gaogake'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na' shi yiseḻaa ḻegake' bi neej naogake', xoll ic̱hoḻ-lall'gake' tneza', ḻa' baḻgake' za'gake' zit'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Na' beṉ'ka' nakgake'ne' txen che'gake'ne': ―¿Gatg lljx̱i'cho dii gao yog' beṉ'ki?, ḻa' gani lle'cho kono zoa wit' dii gaocho. ");
INSERT INTO zadNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Na' che' Jesúza' ḻegake': ―¿Ka'k' yetxtilka' noa'le? Na' che'gake'ne': ―Gallan. ");
INSERT INTO zadNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Na' bene' mandad kwe' beṉ'ka' lo yona', na' bex̱ee gallte yetxtilka', na' ka biyoll bi'e Chioza' yeḻ' chox̱ken, na' bxoxje'n na' bi'en beṉ'ka' nakgake'ne' txen kwenc̱he c̱hisgake' c̱he c̱he beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Na' ḻekzka' nox̱'gake' zto c̱hop beḻ. Na' bi'e Chioza' yeḻ' chox̱ken, na' golle' beṉ'ka' nakgake'ne' txen we'gake' c̱he c̱he beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na' yog'ḻoḻgake' weej wdaogake' ax̱t ka beljgakile', na' bitopgake' zi gall xet' diika' bichooṉan. ");
INSERT INTO zadNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Beṉ'ka' weej wdao gokgake' ka tapa mil. Na' Jesúza' bisee ḻegake' ");
INSERT INTO zadNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","na' bizee biyoolene' beṉ'ka' nakgake'ne' txen ḻoo barkwa' na' ziyajgake' gana' mbani Dalmanútana'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Na' bllin fariseoka' na' wzologake' chakguedlengake' Jesúza'. Na' daa goklall'gake' wchix̱gake'ne', wṉabgakile'ne' gone' to yeḻ' wak lawe'ka' kwenc̱he gakbia' shi Chioza'kzan bseḻeene'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Na' Jesúza' ax̱t wkaalallee, golle': ―¿Berac̱he le' zoale ṉaa chṉabzle gon' to yeḻ' wak dii ile'ile'? Dii ḻi nia' le', aga bi yeḻ' wak gon' ile'ile'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na' bizee kwite'ka', na' biyo'e ḻoo barkwa' sto shii ziyaje' shḻaa nisdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na' beṉ'ka' nak Jesúza' txen goḻ-lall'gake' wa'gake' yetxtil c̱he'ka', na' tlish'chga dii noa'gake' ḻoo barkw c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Na' che' Jesúza' ḻegake': ―Wsak'gale bi shajḻe'le dill' wxiye' c̱he fariseoka' na' c̱he Heródeza', daa zaklebi levadúrana'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Na' beṉ'ka' nakgake'ne' txen che' ljwellgake': ―Daa bi bi'acho yetxtilan' ne' ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Na' gokbe'i Jesúza' dillaa choe'gake', na' golle' ḻegake': ―¿Berac̱he chakzile daa bi bi'ale yetxtilan' nia' ka'? ¿Abiṉ' shajni'kzile' ni biṉ' gakbe'ile ka nak diika' chon'? ¿Abiṉ' iyalj yic̱hjlall'do'lenan'? ");
INSERT INTO zadNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Zoate jalaoleka' na' bi chle'ile, na' zoate nagleka' na' bi chenile'. ¿Abi chjadinile ka ben'? ");
INSERT INTO zadNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kana' bxoxj' gay' yetxtilka' na' wdao beṉ'ka' gaya' mil, ¿baḻ xet' diika' bichooṉan? Na' gollgake'ne': ― Shlliṉan. ");
INSERT INTO zadNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Na' kana' bxoxj' gall yetxtilka' na' wdao beṉ'ka' tapa mil, ¿baḻ xet' diika' bichooṉan? Na' che'gake'ne': ―Zi gallan. ");
INSERT INTO zadNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Na' che' Jesúza' ḻegake': ―¿Ana' ni ka' biṉ' shajni'kzile? ");
INSERT INTO zadNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Na' bllingake' yella' le Betsaida, na' beṉ'ka' lle' yella' jwa'gake' to beṉ' lc̱hoḻ lao Jesúza' na' got'yogakile'ne' gox̱'gache'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Na' bex̱' Jesúza' na' beṉ' lc̱hoḻa' na' wleje'ne' yella'. Na' blle' x̱eneena' jalawe'na' na' bx̱oa neena' yic̱hje'na', na' wṉabile'ne' shi ba chle'ile'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Na' che' beṉ' lc̱hoḻa': ―Chle'id' x̱oṉj beṉ', na' nakgake' ka yag dii chza'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Na' Jesúza' bex̱ee jalawe'na' sto shii, na' biyakile'. Na' ble'ile' kwasḻoḻ yog'ḻoḻte. ");
INSERT INTO zadNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Na' biseḻ' Jesúza'ne' shḻicha lille'na', chi'ene': ―Bi lljayoo dill' yella'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na' biza'len Jesúza' beṉ'ka' nakgake'ne' txen wyajgake' yellka' mbani Cesarea de Filípona'. Na' shlak ngoogake' nez, wṉabile' ḻegake', chi'e: ―¿Non na beṉ' nak'? ");
INSERT INTO zadNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na' che'gake'ne': ―Baḻgake' nagake' lin' dii Juanna', beena' bchoa beṉ' nisa', na' zi baḻgake' nagake' lin' Elíaza', na' zi baḻgake' nagake' nako' sto beṉ' wdix̱jee daa goll Chioza'ne' kani'yi. ");
INSERT INTO zadNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Na' chi'e ḻegake': ―Shera le', ¿nora nale nak'? Na' che' Pédrona': ―Lin' Crístona', beena' nc̱heb Chioza' wseḻee. ");
INSERT INTO zadNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Na' che' Jesúza' ḻegake' kono ye'gake' ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na' wzolo Jesúza' bli' bsedile' ḻegake' nan ḻe', Beṉ' Bseḻ' Chioza' Yell-lioni, chonan byen sak'zi'e dii xen, na' beṉ' golka' chṉabia' na' bx̱ozka' chṉabia' na'ch beṉ'ka' chli' chsedi leya' gakzbangakile'ne', na' chonan byen witgake'ne' na' yibane' ka gak shoṉ lla. ");
INSERT INTO zadNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Na' bshaljlene' ḻegake' kwasḻoḻ daa gak c̱he'. Na'ch wlej Pédrona'ne' ka'lə na' wzolo golle'ne' bi koo cho'e daa. ");
INSERT INTO zadNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Na' biyec̱hj Jesúza' chwie' beṉ'ka' nakgake'ne' txen, na' bsheshlene' Pédrona', chi'ene': ―¡Kwas ka'lə, Satanás!, ḻa' bi chajniilo' daa cheeni Chioza' gone', san de yell-liozan chajniilo'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Na' wṉe Jesúza' beṉ'ka' nakgake'ne' txen len beṉ'ka' lle' na', na' chi'e: ―Shi no cheeni gake' nad' txen, chiyaḻ' wsanlall' kwine' na' izanile' yeḻ' mban c̱he'na' yen ile'ile' bittez ni c̱ha', na' gone' ka chazlallaa. ");
INSERT INTO zadNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ḻa' beena' bi chzanile' yeḻ' mban c̱he'na', beenan' kwiayi', san beena' chzanile' yeḻ' mban c̱he'na' ni c̱ha' na' ni c̱he dill' wen dill' kob c̱ha'na', beenan' gat' to yeḻ' mban c̱he' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bibi zjanayin gap beṉ' yog'ḻoḻ daa de yell-lioni, shi ḻe' kwiayee. ");
INSERT INTO zadNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Na' aga zakii c̱hixje' kwenc̱he yisla yeḻ' mban c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nottezə beena' chido'i wc̱hebe' nombi'e nad' wa wi'e cho'a xtillaana' lao beṉ' saaxyaka' beṉ'ka' bi chonḻilall' nad', ka'kzə nad', Beṉ' Bseḻ' Chioza' Yell-lioni, yiyii yido'id' ḻe' kat' yiyedlen' anjl c̱ha'ka' na' zinsa' balaaṉ xen c̱he X̱a' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Na' ḻekzka' golle' ḻegake': ―Dii ḻi nia' le', baḻ-le lle'leni, ni mbanle ile'ile ka chṉabia'len Chioza' yeḻ' wak xen c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wde x̱op lla, Jesúza' wyaje' to lo yaa sibə, na' bc̱hi'e Pédrona', Jacóbona' na'ch Juanna'. Na' lawe'ka' biyake' nlla'lə. ");
INSERT INTO zadNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Na' xe'na' ax̱t chep cheeni'n, na' biga zoa beṉ' c̱hibe'n xtil inlleb ka gokan. ");
INSERT INTO zadNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na' ble'gakile' Elíaza' na'ch dii Moiséza' chshaljlengake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Na' che' Pédrona' Jesúza': ―Maestro, ¡wen inlleb zoacho ni! Gonnto' twej ransh c̱hele, to c̱ho', to c̱he dii Moiséza', na' sto c̱he Elíaza'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kon bi billel-lallee golle', daa chllebchgagake'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Na' wze to bej bkwashaan ḻegake', na' ḻoo beja' wṉe Chioza', chi'e: ―Beenin xiiṉaa, na' ḻe chakidee. Ḻi wzenag c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Na' ka bwiagake' gana' wlle' beṉ'ka' shoṉ, stoz Jesúza' ze. ");
INSERT INTO zadNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na' shlak chiyetjgake' lo yaana', goll Jesúza' ḻegake' kono ye'gake' daa ble'gakile' ax̱t kat'ch ḻe', Beṉ' Bseḻ' Chioza' Yell-lioni, ba bibane' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Na' daa golle' ka', ni to kono beṉ' yoblə gollgake' daa ben ble'gakile', ḻa'kzi wṉabi ljwellgake', bi zejin daa golle' yibane' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na' wṉabgakile' Jesúza', che'gake'ne': ―¿Bic̱he naz beṉ'ka' chli' chsedi leya' nan zigaate Elíazan' yiyed? ");
INSERT INTO zadNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Na' chi'e ḻegake': ―Dii ḻi, Elíaza' yide' zigaate yidgwee xṉezi yog'ḻoḻte. ¿Abi ṉezile bic̱he Cho'a Xtill' Chioza' nan Beena' Bseḻ' Chioza' Yell-lioni chonan byen sak'zi'chgue' na' gakzbani beṉ' ḻe'? ");
INSERT INTO zadNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na' nia' le', ba biyed Elíaza', na' bengakile'ne' daa nazan c̱hegake', kon ka na Cho'a Xtill' Chioza' gongake' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na' ka billingake' gana' lle' beṉ'ka' sto, beṉ'ka' nakgake'ne' txen, na' ble'gakile' lle' beṉ' zan inlleb kwite'ka', na' len baḻ beṉ'ka' chli' chsedi leya' chakguedlengake' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na' beṉ'ka' lle' na' ka ble'gakile' Jesúza', bibangakile' na' wza'dogake' jawapgake'ne' chiox. ");
INSERT INTO zadNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na' chi'e ḻegake': ―¿Bi c̱heyin chakguedlenile beṉ'ka'? ");
INSERT INTO zadNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Na' to beena' len ladj beṉ'ka' lle' na' chi'ene': ―Maestro, ni ba nc̱hi'a bi' c̱ha'ni lawo'ni, ḻa' yoob' to dii x̱iw' na' chllonan iṉeb'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gattezə chdab' dii x̱iwaa chox̱a'n ḻeb' na'ch chchooṉan ḻeb' lo yona'. Na' chbia bllin' cho'abaa, na' chaox̱ax̱j ḻeybaa na' chzecha kwerp c̱he'baa. Na' ba gosh' beṉ'ki nako' txen yibejgake' dii x̱iwaa yoob', per bi chakgake'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Na' che' Jesúza' ḻegake': ―¡Le' beṉ' bi chajḻe'! ¿Zi' ka'k'tek chiyaḻ' soalen' le'? ¿Zi' ka'k'tek chiyaḻ' soid' le'? Ḻi lljx̱i'shkib' ni. ");
INSERT INTO zadNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na' jwa'gake'b' lawe'na'. Na' ka ble'i dii x̱iwaa Jesúza', benan ka wyazb' shoṉa'. Na' billeeb' lo yona' na' wbix̱ wtoḻb' na' wllia bllin'na' cho'abaa. ");
INSERT INTO zadNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Na' wṉabi Jesúza' x̱abaa, chi'e: ―¿Batrate wzolo chakb' ki? Na' che' x̱abaa: ―Kana' nakteb' bi'do' chakb' ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Na' zan shii ba bzaḻ' dii x̱iwaab' lo yi'na' na' ḻoo nisa' kwenc̱he witan ḻeb'. Na' shi wak yiyono'b', biyesh'lall'gachi neto' na' goklengach neto'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Na' che' Jesúza': ―¿Bic̱he nazo' shi wak'?, ḻa' beena' chonḻilall' Chioza' aga bi dii lallj gat' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na' besyaa x̱abaa, chi'e: ―Chonḻilallaane'. ¡Goklen nad' gonḻilall'chee! ");
INSERT INTO zadNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na' ka ble'i Jesúza' ba chdop chllag beṉ' zan inlleb, na' bsheshlene' dii x̱iwaa, chi'en: ―Dii x̱iw', lin' chono' kwenc̱he bi cheni bi'ni ni bi chak iṉeb', nad' nia' li', bichej, na' bich gak yiyoo sto shii. ");
INSERT INTO zadNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Na' besyaa dii x̱iwaa, na' bx̱izan ḻeb' zibia' wal na' bichejan, na' gotb' ka bi' wet. Na' beṉ' zan wnagake': “Ba witb'.” ");
INSERT INTO zadNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Na' bex̱' Jesúza' na'ba' kwenc̱he bisolleeb'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Na' ka biyoo Jesúza' to ḻoo yoo, beṉ'ka' nakgake'ne' txen wṉabgakile'ne' to ḻezgake', che'gake': ―¿Berac̱he bi gok yibejnto' dii x̱iwaa? ");
INSERT INTO zadNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Na' chi'e ḻegake': ―Kwenc̱he gak yichej dii x̱iw' ka dga, chiyaḻ' soale wbas' na' we'ḻwill-le Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Na' biza'gake', na' bidegake' gana' mbani Galileana'. Na' Jesúza' bi goklallee no iṉezi gan zoagake' ");
INSERT INTO zadNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","daa chzajniile' beṉ'ka' nakgake'ne' txen. Na' chi'e ḻegake': ―Nad', Beṉ' Bseḻ' Chioza' Yell-lioni, gon beṉ' nad' lo na' beṉ' malka' na' witgake' nad', na' ka gak shoṉ lla, yiban' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Na' bi wyajni'gakile' daa chi'e ḻegake', na' bi biyaxjgakile' iṉabgakile'ne' bic̱he che'ze' ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Na' billingake' yell Capernaúma'. Na' ka billingake' gana' zoagake', na' chi'e ḻegake': ―¿Bi c̱heyin chakguedzle shlak zingoocho neza'? ");
INSERT INTO zadNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Na' ni togake' bi wṉe, daa gokguedgake' c̱he noyeṉ'gaken' nak beṉ' zak'chi. ");
INSERT INTO zadNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Na' wche' Jesúza' na' goxe' beṉ'ka' shlliṉ, chi'e ḻegake': ―Shi nole cheenile gakle beṉ' zakii, chiyaḻ' gon kwinle ka wen llin c̱he beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Na'ch bzoe' to bi'do' ladje'ka'. Na' bḻene'b' chi'e ḻegake': ");
INSERT INTO zadNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Nottezə beṉ' wlebe' to bi'do' ka bi'do'ni daa chonḻilallee nad', nad'kzan chlebe'. Na' beena' chlebe' nad', ḻekzka' chlebe' Chioza', beena' bseḻ' nad'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Na' che' Juanna' ḻe': ―Maestro, ba ble'into' to beṉ' chzetje' lio'na' kwenc̱he chibeje' dii x̱iw'ka' yoo beṉ' na' bllonnto' gone' ka', ḻa' bi nake' cho' txen. ");
INSERT INTO zadNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Na' che' Jesúza': ―Bi wllonle gone' ka', ḻa' beena' chzetj lia'na' kwenc̱he chone' yeḻ' wak, aga wak iṉie' zban c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ḻa' beena' bi chakzbani cho', txenkzan nake' cho'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na' nottezə beena' goṉe' le' ḻa'c̱h' lat' nis yeejle daa nakle nad' txen, dii ḻi nia' le', de dii si'e banez. ");
INSERT INTO zadNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Nottezə beena' gon ka ibix̱ to beṉ' zi' chzolo chonḻilallee nad', naklan wen wwaḻ'gake' yene'na' to yaj c̱he molinna' na' lljazaḻ'gake'ne' ḻoo nisdo'na' aga ka daa gone' ka ibix̱ beṉ' lao dii mala'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na' shi noona' chonan ka ibix̱o' lao dii mala', bc̱hogan. Wenchlan bi de noona' tḻaa yillino' kwit Chioza' aga ka daa yiyaj doxentio' lo yi' gabiḻa' daa biga yiyol, ");
INSERT INTO zadNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","gana' ni bzogaa bi chet ni biga chiyol yi'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na' shi ṉi'ona' chonan ka chono' to dii mal, bc̱hogan. Wenchlan bi de ṉi'ona' tḻaa yillino' kwit Chioza' aga ka daa yiyaj doxentio' lo yi' gabiḻa', ");
INSERT INTO zadNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","gana' ni bzogaa bi chet ni biga chiyol yi'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na' shi jalawo'na' chonan ka chono' to dii mal, wlejan. Wenchlan bi de jalawo'na' tḻaa yillino' gana' zoa Chioza' chṉabi'e aga ka daa yiyaj doxentio' lo yi' gabiḻa', ");
INSERT INTO zadNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","gana' bi chet bzogaa ni biga chiyol yi'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ka yog'te diika' chzangakile' choe'gake' Chioza' chgoogake'n zed', ka'kzan yog'te beṉ'ka' nonḻilall' nad' yen ile'gakile' yeḻ' zak'zi'na' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Zedaa nakan dii wen, per shi bich nakan zxi', aga wakch yiyonchon zxi' dii yoblə kwenc̱he wc̱hinchon. Chiyaḻ' soalen ljwell-le mbalaz, na' shi gonle ka', nakle ka yeḻ' wao daa yoo zed' na' sian. ");
INSERT INTO zadNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Biza' Jesúza' Capernaúma' ziyaje' gana' mbani Judeana' na' lo yell-liona' daa de shḻaa yao Jordánna'. Na' bizdi'a bizllag beṉ' zan lawe'na' na' wzoloe' chli' chsedile' ḻegake' kon ka ba yooloe' chone'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Na' baḻ fariseoka' wbig'gake' lawe'na', na' kwenc̱hezə wchix̱gake'ne' wṉabgakile'ne' shi de lsens yiḻaa xool beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Na' chi'e ḻegake': ―¿Bin bllia dii Moiséza' bia' gonle? ");
INSERT INTO zadNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Na' che'gake'ne': ―Dii Moiséza' bi'e latj yichooṉ beṉ' byona' xoole'na' na' wi'ene' to yish daa cho'e dill' ba bilaagake'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Na' che' Jesúza' ḻegake': ―Dii Moiséza' bllie' bia' gonle ka' daa nakle beṉ' widenag. ");
INSERT INTO zadNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Per dii nech ka wxe wzil yell-lioni, Chioza' “bene' beṉ' byona' na'ch noola'.” ");
INSERT INTO zadNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Daan, beṉ' byona' wḻee x̱axṉeena' kwenc̱he soalene' xoole'na' ");
INSERT INTO zadNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na' gakgake' toz.” Na' bich nakgake' c̱hop, san ba nakgake' toz. ");
INSERT INTO zadNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Na' beṉ'ka' ba non Chioza' toz, ni to beṉ' yell-lio bi chiyaḻ' yiḻee ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ka billingake' yoona' gana' zoagake', beṉ'ka' nakgake'ne' txen wṉabgakile'ne' c̱heyi daa golle' ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na' che' Jesúza' ḻegake': ―Beena' yiḻee nool c̱he'na' na' yishagnee nool yoblə, chone' ka beena' zoakzə nool c̱he' na' chdalene' nool yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na' shi noola' yiḻee beṉ' c̱he'na' na' yikee beṉ' yoblə, chone' ka beena' zoakzə beṉ' c̱he' na' chdalene' beṉ' yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na' baḻ beṉ' jwa'gake' bi'do' c̱he'ka' lao Jesúza' kwenc̱he wx̱oa neena' yic̱hjb'ka' na' gonḻeeye' ḻegakb'. Na' beṉ'ka' nakgake'ne' txen wzologake' chsheshlengake' beṉ'ka' zjwa' bi'do'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Na' ka ble'i Jesúza' chsheshlengake' beṉ'ka', bllee na' chi'e ḻegake': ―Ḻi we' latj yid bi'do'ki lawa'ni, bi wllonle, ḻa' Chioza' chṉabi'e ḻoo yic̱hjlall'do' beṉ'ka' nak ka ḻegakb'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Dii ḻi nia' le', beena' bi yiyak yic̱hjlall'do'ena' ka c̱he bi'do'ki kwenc̱he iṉabia' Chioza' ḻe', bi yilline' gana' zoa Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Na' bḻene' bi'do'ka', na' bx̱oa neena' yic̱hjb'ka' na' benḻeeye' ḻegakb'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ka ba chiza' Jesúza' yigwee nez, bllindo to bi' wew' bc̱hek' xibbaa lawe'na' che'bee: ―Maestro, li' nako' beṉ' wen. ¿Beran chiyaḻ' gon' kwenc̱he gat' to yeḻ' mban c̱ha' zejḻi kaṉi? ");
INSERT INTO zadNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Na' che' Jesúza' ḻeb': ―¿Berac̱he nazo' nad' beṉ' wen? Toz Chioza' nake' beṉ' wen. ");
INSERT INTO zadNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ba ṉezkzilo' daa nllia Chioza' bia' goncho: “Bi wito' beṉ', bi soaleno' nool bi nak nool c̱ho', bi kwano', bi c̱hiljlalloo bizə gon iṉo' c̱he beṉ', ni bi siyoo, na' wdap balaaṉ x̱axṉoo.” ");
INSERT INTO zadNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na'ch che'bee: ―Maestro, kana' naktia' bi' xkwid' chon' yog' diika'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Na' bwia Jesúza' ḻeb' kon yeḻ' chaki, chi'e: ―Stozə daa chyallj gono': jayet' yog' dii de c̱ho' na' be'n beṉ' yesh'ka', na' gat' to yeḻ' shao' c̱ho' yabana'. Na' da dino' nad'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Na' gokyeshii bi' wni'ana' ka golle'b' ka'. Na' ziyajb' chakyeshib' daa nakb' bi' wni'a xen inlleb. ");
INSERT INTO zadNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Na' bwia Jesúza' beṉ'ka' lle' na', na' chi'e beṉ'ka' nakgake'ne' txen: ―¡Lallj inlleb chonan c̱he beṉ' wni'aka' we'gake' latj iṉabia' Chioza' ḻegake'! ");
INSERT INTO zadNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na' bibani beṉ'ka' nakgake'ne' txen daa golle' ka'. Na' chizi'e ḻegake': ―Le' xiiṉdawaa, chonan lallj c̱he beṉ' wni'ana' yilline' yabana' gana' chṉabia' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ḻobe'ch te to kamey to xan yesh' aga ka to beṉ' wni'a yilline' yabana' gana' chṉabia' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ka bengakile' golle' ka', zizikli bibangakile', na' che' ljwellgake': ―¿Notg gak yillin lao Chioza', shka'? ");
INSERT INTO zadNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Na' bwia Jesúza' ḻegake' chi'e: ―Ni to beṉ' yell-lio bi gak gone' dga, per Chioza' aga bi dii lallj c̱he' de, ḻa' yog'ḻoḻte chak gone'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Na' Pédrona' chi'ene': ―Neto' ba wlej yic̱hjnto' yog'ḻoḻ dii napnto' kwenc̱he nonnto' li' txen. ");
INSERT INTO zadNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Na' che' Jesúza': ―Dii ḻi nia' le', nottezə beṉ' ba bzanile' no lille', no x̱axṉee, no beṉ' bishee, no beṉ' zane', no xiiṉ xoole', no yell-lio c̱he' ni c̱ha' nad' na' ni c̱he dill' wen dill' kob c̱ha'na', ");
INSERT INTO zadNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","lo yell-lioni Chioza' yiyo'ene' dii zanch ka diika' wlej yic̱hje', no lille', no beṉ' bishee, no beṉ' zane', no xiiṉe', no yell-lio c̱he' ḻa'kzi chiya dii wsak'zi' beṉ' ḻe', na' illin lla gat' to yeḻ' mban c̱he' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Per beṉ' zan nakgake' beṉ' zakii ṉaa, wllin lla bich bi sak'gake', na' beṉ' zan bi nakgake' beṉ' zakii, wllin lla gakgake' beṉ' zakii. ");
INSERT INTO zadNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ka ziyajgake' Jerusalénna', na' zillialo Jesúza' lao beṉ'ka' nakgake'ne' txen. Na' ḻe chibangakile', na' beṉ'ka' zinoch ḻe' ḻe chllebgake'. Na' bc̱he' Jesúza' beṉ'ka' shlliṉ ka'lə na' wzoloe' cho'e dill' lawe'ka' daa gak c̱he', ");
INSERT INTO zadNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","chi'e ḻegake': ―Ba gokbe'kzile' ba ziyajcho Jerusalénna', na' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, gongake' nad' lo na' bx̱ozka' chṉabia' na' beṉ'ka' chli' chsedi leya', na' wc̱hoglogake' c̱ha' guet' na' gongake' nad' lo na' beṉ' zit'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Na' wtitjgakile' nad', na' wlla' x̱eneeka' nad', na' wit c̱hingake' nad', na' witgake' nad'. Na' ka gak shoṉ lla yiban' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Na' Jacóbona' len Juanna', beṉ'ka' nak xiiṉ Zebedewa', wbig'gake' lao Jesúza' che'gake'ne': ―Maestro, cheeninto' gongacho' goklen gono' dga iṉabinto' li'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Na' chi'e ḻegake': ― ¿Beran cheenile' gon' c̱hele? ");
INSERT INTO zadNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Na' che'gake'ne': ―We'gacho' latj kwe'nto' shḻaa wej kwito'na' kat' solo iṉabi'o gana' de balaaṉ xen c̱ho'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Na' che' Jesúza' ḻegake': ―Aga ṉezile' bin chṉable. ¿Awzoile' wtiḻ-le ka yeḻ' zak'zi'ka' idiḻ illag' na' gak c̱hele ka gak c̱ha'? ");
INSERT INTO zadNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Na' che'gake'ne': ―Wzointo'n. Na' che' Jesúza' ḻegake': ―Dii ḻi, wtiḻ-le ka yeḻ' zak'zi'ka' idiḻ illag' na' gak c̱hele ka gak c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Per daa nale kwe'le shḻaa wej kwitaa bi nak lo na' gona'n, san beṉ'ka' ba mbej Chiozan', gakan c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ka beni beṉ'ka' zi shi, na' bllaagake' Jacóbona' na'ch Juanna'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Na' wṉe Jesúza' ḻegake', chi'e: ―Ṉezkzile beṉ'ka' chṉabia' yell-lioni na' beṉ'ka' zakii chongake' byen chzenag beṉ' c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Per aga kan' chiyaḻ' gonle. Shi nole cheenile gakle beṉ' mbejlawin chiyaḻ' gon kwinle ka wen llin c̱he beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na' shi nole cheenile gakle beṉ' zakii, chiyaḻ' gakle ka beṉ' ndoo lla yel chone' xshin beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ḻa' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, aga bid' kwenc̱he gaklen beṉ' nad', san bid' kwenc̱he gaklen' beṉ' na' wi'a yeḻ' mban c̱ha'na' kwenc̱he yisla' beṉ' zan lao saaxyana'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na' bllingake' Jericóna', na' ka ba chichej Jesúza' yella' kon beṉ'ka' nakgake'ne' txen na' len beṉ' zanch zinogake'ne', na' chi' to beṉ' lc̱hoḻ cho'a neza' cheenile' no we' ḻe' mech, na' lie' Bartimeo, xiiṉ to beṉ' le Timeo. ");
INSERT INTO zadNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na' ka benile' nan Jesús, beṉ' Nazaretan', wdena', na' wzoloe' chosyee, chi'e: ―¡Jesús, xiiṉ dia c̱he dii Daví, biyesh'lall'gachi nad'! ");
INSERT INTO zadNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Na' beṉ' zan bsheshlengake'ne' daa chosyee, na' zizikli chosyaache', chi'e: ―¡Xiiṉ dia c̱he dii Daví, biyesh'lall'gachi nad'! ");
INSERT INTO zadNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Na' wlez Jesúza' chi'e: ―Ḻi iṉie'. Na' wṉegake'ne', che'gake': ―Btiplalloo, wzolla', ba chṉie' li'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Na' bzaḻee ka'lə lechaa nx̱oa kolleena' na' wzollee jsie' lao Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Na' wṉabile'ne', chi'e: ―¿Bin cheenilo' gon' c̱ho'? Na' che' beṉ' lc̱hoḻa'ne': ―Maestro, cheenid' ile'id'. ");
INSERT INTO zadNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Na' che' Jesúza'ne': ―Wak yiyajo'. Daa ba benḻilalloo nad', ba biyakilo'. Na' katena' lii ble'teile' na' wnoe' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ka ba zoa yillingake' Jerusalénna', na' wdegake' gaozə gana' llia yell Betfagéna' na' yell Betániana', kwit Yaa Olívoza', na' Jesúza' bseḻee c̱hop beṉ'ka' nakgake'ne' txen, ");
INSERT INTO zadNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","chi'e ḻegake': ―Ḻi shaj yella' daa llia gaozə, na' ka illinle na', ile'ile to burr chbando', ba konoṉ' kwia, da'b yaga'. Na' wsell-leb wc̱he'leb nilə. ");
INSERT INTO zadNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na' shi no iṉaz le': “¿Berac̱he chsellzleb?”, na' ye'lene': “X̱anchonan' chyalljile'b xtit, na' yiyoṉtie'b.” ");
INSERT INTO zadNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na'ch wyaj beṉ'ka' bseḻee, na' ble'gakile' to burr da'b to cho'a yoo gana' chde neza', na' bsellgake'b. ");
INSERT INTO zadNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Na' beṉ'ka' lle' na' wṉabgakile' ḻegake': ―¿Bin chonle? ¿Bic̱he chsellzleb? ");
INSERT INTO zadNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Na' gollgake' ḻegake' daa goll Jesúza', na' be'gake' latj bc̱he'gake'b. ");
INSERT INTO zadNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Na' bx̱oagake' xe'ka' koll' burra' na' jasangake'b lao Jesúza', na' wllie'b. ");
INSERT INTO zadNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na' beṉ' zan bshiljgake' xe'ka' tneza', na' zi baḻe' bc̱hoggake' no zin na' wdix̱jgake'n tneza'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na' ka beṉ'ka' llialo lao Jesúza' ka beṉ'ka' nogake'ne', chosyaagake', nagake': ―¡Ḻi we'la'o Chioza'! ¡Gonḻeeyshga X̱ancho Chioza' beeni ba bseḻee! ");
INSERT INTO zadNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Gonḻeeyshga X̱ancho Chioza' yeḻ' wṉabia' c̱he beeni zee lo dia c̱he dii x̱ozxto'cho Davina'! ¡Ḻi da we'la'ocho Chioza' zoa yabana'! ");
INSERT INTO zadNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Na' wyoo Jesúza' yell Jerusalénna' na' zeje' gana' zoa yoodo'na'. Na' ka biyoll bwie' doxenten na' ziyaje' Betániana' len beṉ'ka' shlliṉ, daa ba wlle'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na' betiyo ka biza'gake' Betániana', wdon Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na' zit'lə ble'ile to yag yix̱wew llia xḻaguinna', na' jawie' shi ḻekzka' llian yix̱wewa'. Na' ka blline' zeelo xḻaguiinna' llia, ḻa' aga tiemp c̱he yix̱wew kana'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Na'ch golle' yaga': ―¡Batch kwio' dii gao beṉ'! Na' beni beṉ'ka' nakgake'ne' txen ka golle'n. ");
INSERT INTO zadNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Na' ka billingake' Jerusalénna', Jesúza' wyo'e lesh' chyoodo'na' na' wzoloe' bishesh bic̱heeṉe' beṉ'ka' chit' chde na' beṉ'ka' cha'o chzi'. Na' bishi'e mes c̱he beṉ'ka' chshaa mecha' na' bzoles bzolline' gana' chi' beṉ'ka' chit'gake' palomka'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na' bi bi'e latj no sho'lench dii wit' wdie' lesh' chyoodo'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na' wzoloe' chli' chsedile' beṉ'ka' lle' na', chi'e: ―Cho'a Xtill' Chioza' nan: “Lilla'na' nakan ga choe'ḻwill yog'te beṉ' lle' doxen lo yell-lioni nad'”, per le', ba nonzlen ka to ga chdop chllag wban. ");
INSERT INTO zadNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na' ka beni bx̱ozka' chṉabia' na' beṉ'ka' chli' chsedi leya' ka wne', wzologake' wdiljlall'gake' nak gongake' witgake'ne', daa ḻe chllebgake'ne', ḻa' yog' beṉ' chibangakile' ka chli' chsedile' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na' ka goḻ, biza'len Jesúza' beṉ'ka' nakgake'ne' txen Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na' betiyo shzila' ka wdegake' gana' zoa yag yix̱wewa', ble'gakile' ba wbill ax̱t loinna'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Na' jadini Pédrona' daa goll Jesúza' yaga' na' chi'ene': ―Maestro, bwiakachi, yag yix̱wewa' daa bsheshleno'. Ba wbillan. ");
INSERT INTO zadNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Na' che' Jesúza' ḻegake': ―Ḻi gonḻilall' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Dii ḻi nia' le, nottezə beena' yee yaani: “Bkwas ka'lə na' jsoa ḻoo nisdo'na'”, na' bi gonc̱hoplallee, san shajḻi'e, na' gak ka iṉe'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Daan nia' le', bittezə iṉable kat' we'ḻwill-le Chioza', ḻi shajḻe' ba nakkzan goṉe'n, na' ikaalen. ");
INSERT INTO zadNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na' kat'ka' choe'ḻwill-le Chioza', ḻi si'xen c̱he bish' ljwell-lena' shi bi chone' c̱hele kwenc̱he X̱alena' beena' zoa yabana' si'xene' saaxya c̱heleka'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ḻa' shi le' bi si'xen c̱he ljwell-le, ḻekzka' X̱alena', beena' zoa yabana', bi si'xene' saaxya c̱heleka'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Na' billingake' Jerusalénna' sto shii, na' shlak chda Jesúza' lesh' chyoodo'na', wbig' bx̱ozka' chṉabia', len beṉ'ka' chli' chsedi leya' na' beṉ' golka' chṉabia', ");
INSERT INTO zadNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","na' che'gake'ne': ―Wnashki neto', ¿nora lsens c̱heyi chono' diiki? ¿No beṉ li' yeḻ' wṉabia'na' kwenc̱he chono' diiki? ");
INSERT INTO zadNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Na' che' Jesúza' ḻegake': ―Ḻekzka' nad', de to dii iṉabid' le'. Na' shi le' iṉale nad' daa iṉabid' le', na' iṉia' le' no lsens c̱heyin chon' yog' diiki. ");
INSERT INTO zadNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Noran bseḻ' Juanna' kwenc̱he bidchoe' beṉ' nisa'? ¿AChiozan' bseḻeene', anti beṉ' yell-liona'zan? Ḻi iṉashki nad'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Na'ch choe'len ljwellgake' dill', che'gake': ―Shi ye'chone' Chioza' bseḻeene', ḻobe' iṉe' cho': “¿Berac̱he ki wyajḻe'le c̱he', lla?” ");
INSERT INTO zadNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na' bite gak yize'chone' nozə beṉaan bseḻeene'. Bi biyaxjgakile' ye'gake'ne' ka' daa bllebgake' beṉ' yellka', ḻa' yog'zgake' yoo yic̱hjgake' Juanna' goke' to beṉ' wdix̱jee daa goll Chioza'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Na' gollgake' Jesúza': ―Bi ṉezinto'. Na' che' Jesúza' ḻegake': ―Ḻekzka' nad', bi iṉia' le' no beṉ nad' yeḻ' wṉabia'na' chon' diiki. ");
INSERT INTO zadNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Na' wzolo Jesúza' bseesile' ḻegake' to jempl, chi'e: ―To beṉ' biyaze' yag uva. Na' wlo'en leeja', na' benshawee gana' wsigake' uvaka', na' bene' to yoo sibə, gana' kwia beena' gap wwie'n. ’Na'tech bene'n lo na' to c̱hop beṉ' na' wzee zeje' zit'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Na' ka bllin lla yishibgake' uvaka', bseḻee to wen llin c̱he'na' lao beṉ'ka' chap yag uvaka' kwenc̱he lljaxi'e daa chidoḻee. ");
INSERT INTO zadNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Per beṉ'ka' bex̱'gake' wen llin c̱he'na', na' bet wdingake'ne' na' bilaggake'ne' to ka che'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Na' x̱an yag uvaka' bseḻee sto wen llin c̱he' lawe'ka', na' bḻaagake' yic̱hje'na', na' chiya dii bengakile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Na'ch bseḻee stoe', na' betgake'ne'. Na'tech bseḻee zanch beṉ' yoblə; na' baḻgake' bengakile' zibia', na' zi baḻgake' betgake'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Na' ni chgaaṉ bi'na' nakyeṉ' xiiṉe', bi'na' ḻe chakile'. Na' bseḻeeb', ḻa' gokile': “Wapgake' balaaṉ bi' c̱ha'ni.” ");
INSERT INTO zadNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Na' beṉ'ka' nak lo na'gake' yag uvaka' che' ljwellgake': “Bi'nin gaki c̱heb' dga chapcho. Ḻi da witchob', na' gakin c̱hecho.” ");
INSERT INTO zadNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Na' bex̱'gake'b' na'ch betgake'b' na' bibejgake' kwerp c̱hebaa gana' lle' yag uvaka'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Na' wṉabi Jesúza' ḻegake': ―¿Beraka chakile gon x̱an yag uvaka'? De de shaje' na' lljete' beṉ'ka' na' yiyone' yell-lio c̱he'na' gana' lle' yag uvaka' lo na' beṉ' yoblə. ");
INSERT INTO zadNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Abigaṉ' wlable Cho'a Xtill' Chioza'?, gana' na: Yaja' daa bi wyoolall' wen yooka', ḻeyeṉ'lannan' yaja' daa ba nc̱hejcha yoona'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dgan ben X̱ancho Chioza' na' nakan to dii yibanicho. ");
INSERT INTO zadNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na'ch goklall'gake' gox̱'gake' Jesúza' daa gokbe'gakile' bc̱hine' jempla' daa bi chajḻe'gake' c̱he'. Per daa chllebgake' beṉ'ka' ndop nllag, biza'gake' bibi bengakile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Na' bseḻ'gake' lao Jesúza' baḻ fariseoka' na' zi baḻ beṉ'ka' nak Heródeza' txen, kwenc̱hezə kwejyelgakile'ne' na' lljadaogake' xya c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Na' wyajgake' lawe'na', che'gake'ne': ―Maestro, ṉezinto' dillaa choo nakan dii ḻi. Na' biga chshoo cho'a xtilloona' lao nottez beṉ', ḻa' bi chwio' shi no nakgake'. San chli'o nez ḻi c̱he Chioza' kon ka nakan. Wnashki neto': ¿Achiyaḻ' c̱hixjcho daa chṉab beena' chṉabia' Rómana', anti bi chiyaḻ' c̱hixjchon? ");
INSERT INTO zadNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Na' gokbe'i Jesúza' aga do lall'gake'n che'gake'ne' ka', na'ch chi'e ḻegake': ―¿Berac̱he chyiljlall'zle wchix̱le nad'? Ḻi goṉshki ni to mech kwenc̱he ile'ida'n. ");
INSERT INTO zadNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Na' be'gake'ne'n, na' che' Jesúza' ḻegake': ―¿Nora cho'alawin na' no lein da' ḻee mechi? Na' che'gake'ne': ―C̱he beena' chṉabia' Rómanan'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Na' che' Jesúza' ḻegake': ―Na'len ḻi we' beena' chṉabia' Rómana' daa naki c̱he', na' ḻekzka' ḻi we' Chioza' daa naki c̱he'. Na' ḻe bibangakile' daa golle' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Na' wyaj baḻ saduceoka' lao Jesúza'. Na' daa nagake' bich yiban beṉ' wetka', wṉabgakile'ne' dga: ");
INSERT INTO zadNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, ley daa bzej dii Moiséza' nan shi to beṉ' byo guete' na' yigaaṉ xoole'na' wizeb na' kono xiiṉgake' wzoa, beṉ' bisheena' chiyaḻ' yikee nool wizeba' kwenc̱he soa xiiṉ dia c̱he dii beṉ' bisheena'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na' to shii wzoa gall bish' beṉ'. Na' beṉ' necha' bshagnee, na' wite' na' kono xiiṉe' wzoa. ");
INSERT INTO zadNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Na' beṉ' wchopina' bikee noola', na' ḻekzka' wite' na' kono xiiṉe' wzoa. Na' ka'kzə gok c̱he beṉ' wyoṉina'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Na' gall bish'te beṉ'ki wzoalengake' noola' na' kono xiiṉgake' wzoa. Na' ka wde wit yog'ḻoḻgake', ḻekzka' wit noola'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na' kat' yiban beṉ' wetka', ¿norayeṉ'en' gak beṉ' c̱he noola', lla? ḻa' gall bish'tegaken' wkaagake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Na' che' Jesúza' ḻegake': ―Nakllejzilen, daa bi nombia'le Cho'a Xtill' Chioza' ni yeḻ' wak c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kat'ka' yiban beṉ' wetka', koch no ikaa ljwellin, ni koch no wit' wde xiiṉin, san yiyakgake' ka anjlka' lle' yabana'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na' ka nak daa yiban beṉ' wetka', ¿abiṉ' wlable daa bzej dii Moiséza' gana' cho'en dill' c̱he yagdo'na' chaḻ', na' goll Chioza' dii Moiséza': “Nadaan Chios c̱he Abrahama', Isaaca', na'ch Jacoba'”? ");
INSERT INTO zadNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na' bi nake' Chios c̱he beṉ' wet, san nake' Chios c̱he beṉ' ban. Dii xen inlleb nakllejile. ");
INSERT INTO zadNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na' beni to beṉ' chli' chsedi leya' ka golle' ḻegake'. Na' daa gokbe'ile' ḻe wen billi'e xtilleeka', na' wṉabile'ne': ―¿Beran llialote nllia leya' bia' goncho? ");
INSERT INTO zadNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Na' che' Jesúza'ne': ―Daa llialote lao diika' nllia Chioza' bia' goncho, ḻen daa na: “Ḻi wzenag, le' beṉ' Israel, X̱ancho Chioza' zeelo nake' Chios. ");
INSERT INTO zadNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Goki X̱ano' Chioza' do yic̱hj do lalloo, ax̱t ga zeelo chajniilo', na' do ka nak fuerz c̱ho'na'.” ");
INSERT INTO zadNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na' de wchopina' nakan ka dii necha': “Chiyaḻ' gakilo' bish' ljwello'na' ka chaki kwino'.” Bich de dii zak'chi ka diiki. ");
INSERT INTO zadNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Na' beena' chli' chsedi leya' chi'ene': ―Kakzan nakan, Maestro. Dii ḻi kan' nakan: toz Chiozan' zoa, na' bichga zoa ka ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na' daa gakicho Chioza' do yic̱hj do lall'cho, na' ax̱t ga zeelo chajniicho, na' do ka nak fuerz c̱hechona', na' gaki bish' ljwellchona' ka chaki kwincho, zak'chan aga ka yog'ḻoḻte bayix̱'ka' chitgake' na' chzeygake'b lao Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Na' ka gokbe'i Jesúza' kayeṉ'nan billii beena' xtilleena', na' chi'ene': ―Zi lat'zə chyalljilo' kwenc̱he iṉabia' Chioza' yic̱hjlall'do'na'. Na' koch no biyaxji iṉabchile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na' shlak chli' chsedi Jesúza' beṉ'ka' lesh' chyoodo'na', na' chi'e ḻegake': ―¿Berac̱he nazə beṉ'ka' chli' chsedi leya' nan Crístona', beena' ba mbej Chioza' iṉabi'e, nake' xiiṉ dia c̱he dii Davina'? ");
INSERT INTO zadNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ḻa' kwin dii Davina' bi'e dill' daa goll Espíritu c̱he Chioza'ne', kana' wne': X̱ancho Chioza' golle' X̱an'na': “Wche' kwit' de shḻini, shlak wzoa' xṉi'ona' beṉ'ka' chakzbani li'.” ");
INSERT INTO zadNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Len kwin dii Davinan' golle' Crístona': X̱an', ¿berac̱he nazgake' Crístona' nake' xiiṉ dia c̱he dii Davina'? Na' beṉ' zanka' ndop nllag bibagakile' xtilleena'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Na' ka chli' chsedi Jesúza' beṉ'ka', chi'e ḻegake': ―Wsak'gale bi gonle ka beṉ'ka' chli' chsedi leya'. Ḻe chibagakile' gon xe'ka' dii toṉ, na' cheengakile' yog'zə beṉ' gapgake' ḻegake' balaaṉ ladj lkwe' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Na' gana' chdop chllagcho choe'ḻwillcho Chioza' ḻe chibagakile' kwe'gake' gana' chbe' beṉ'ka' zakii, na' ka'kzə chongake' ga de yeḻ' wao. ");
INSERT INTO zadNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Na' ḻekzka' chkaatezgake' lill nool wizebka', na' kwenc̱he iṉa beṉ' ḻe shḻicha zej beṉ'ki lao Chioza', chongake' ka choe'ḻwill Chioza' ssha nlleb. Na' daa chongake' ka', ba nakten ile'chgakile' yeḻ' zi' walch. ");
INSERT INTO zadNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","To shii chi' Jesúza' gaozə gana' chgoogake' mech c̱he yoodo'na' na' chwie' beṉ'ka' chgoogake' mecha'. Na' beṉ' zan beṉ' wni'aka' wloogake' mech xen. ");
INSERT INTO zadNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na' bllin to nool wizeb, beṉ' yesh', wlo'e c̱hop sintabdo'. ");
INSERT INTO zadNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Na' wṉe Jesúza' beṉ'ka' nakgake'ne' txen, chi'e ḻegake': ―Dii ḻi nia' le', nool wizebi ba be'che' dii xench aga ka yog'te beṉ'ka' wloo mech xench. ");
INSERT INTO zadNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ḻa' yog'gake' daa chichooṉzannan' be'gake', san ḻe', naktie' nool yesh', ba wlo'e doxen daa nape' ḻa'kzi chyalljile'n. ");
INSERT INTO zadNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ka chichej Jesúza' lesh' chyoodo'na', to beṉ'ka' nakgake'ne' txen chi'ene': ―Maestro, bwiakachi ka xochi nak yajki na' yooki. ");
INSERT INTO zadNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Na' che' Jesúza' ḻe': ―Ka nak yooki chwiale ṉaa, wllin lla kwiayi' yogaan na' ni sto yaj bich kwia koll' ljwellin. ");
INSERT INTO zadNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na' ziyajgake' lo Yaa Olívoza' gana' nḻa' yoodo'na'. Na' shlak chi' Jesúza' na', Pédrona', Jacóbona', Juanna', na'ch Andréza' wṉabgakile'ne' to ḻezgake': ");
INSERT INTO zadNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Cheeninto' iṉo' neto' batran gak daa ba wno'. ¿Bera ka ile'into' gak kwenc̱he iṉezinto' nan ba zoa gaoshosh gakan? ");
INSERT INTO zadNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Na' che' Jesúza' ḻegake': ―Bi we'le latj no siye' le'. ");
INSERT INTO zadNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ḻa' beṉ' zan ichej na' iṉazgake': “Nadaan Crístona'”, na' beṉ' zan shajḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Na' ka yenile chak wdiḻ to ni to na', bi illeble. Ḻa' chonan byen gakgakan, per aga ba bllin lla te c̱he yell-lionin. ");
INSERT INTO zadNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ḻa' yidiḻ-len ljwell yellka' na' beṉ' wṉabia'ka' yidiḻ-len ljwellgake'. Na' zan latj gak bedxo', na' gat' wbin, na' kwe' wdiḻ wishesh. Kat' ba chak diiki shinz chzolo ka nak daa yen ile'i beṉ' yell-liokin. ");
INSERT INTO zadNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Wsak'gale, ḻa' gongake' le' lall' na' beṉ'ka' chṉabia' cho' beṉ' Israel, na' wit c̱hingake' le' gana' chdop chllagcho choe'ḻwillcho Chioza'. Na' daa nakle nad' txen, lljwa'gake' le' lao beṉ' wṉabia' xenka' na' lao nochlə beṉ'ka' chṉabia', na' ka' gak we'le xtillaana' lawe'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na' ka zi' te c̱he yell-lioni, chiyaḻ' illilj dill' wen dill' kob c̱ha'na' doxen yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na' kat' ba zjwa'gake' le' lao beṉ'ka' chṉabia', bi sele wṉeyi bin ye'le ḻegake', san daa wzajnii Chioza' len' iṉele, ḻa' aga tobia'lall'zlen iṉele, san Espíritu Sántonan' iṉe. ");
INSERT INTO zadNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Beena' zoa beṉ' bish' golje', ḻeteze' gone'ne' lo na' beṉ'ka' witgake'ne', na' beena' zoa xiiṉe', ḻeteze' gone' xiiṉe'na lo na' beṉ'ka' witgake'ne', na' baḻ beṉ', xiiṉe'ka'tezə gongake' x̱axṉeeka' lo na' beṉ'ka' witgake' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na' yog'zə beṉ' gakzbangakile' le' daa nonḻilall'le nad'. Per beena' so saki bittez dii yen ile'ile' ax̱t ka yiyoll diika' yen ile'ile', beenan' gat' to yeḻ' mban c̱he' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Na' kat' ile'ile ba zoa daa nak dii zban inlleb latja' gana' bi chiyaḻ' soan, na'ch beṉ'ka' lle' Judeana' chiyaḻ' wxoṉjgake' shajgake' lo yaaka'lə. (Le' chlable dga, ḻi shajniin.) ");
INSERT INTO zadNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Na' beena' llia koll' lille'na' ni bi gaḻ' yiyetje' lljaleje' dii de ḻoo lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na' beena' chda lyix̱aa, ni bich gaḻ' yiyaje' lille'na' kwenc̱he lljadoyoe' xe'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Nyesh'laz gak c̱he noolka' noa' na' noolka' chwall' chx̱op llana' gak ka'! ");
INSERT INTO zadNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ḻi iṉabi Chioza' bi gak dga kat'ka' chbe' dii zaga', ");
INSERT INTO zadNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ḻa' yeḻ' zak'zi' wal inlleban nak daa yen ile'ile, daa konoṉ' yen ile'kzi dezd ka bx̱e bsil Chioza' yell-lioni ax̱t ṉaa, na' kat' ba wde gokan kochno yen ile'i ka ḻen. ");
INSERT INTO zadNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na' shi X̱ancho Chioza' bi wzeshee llaka' gak ka', kono yila sheḻ'ka'. Per wzesheen daa chakile' beṉ'ka' ba wleje' nakgake' lall' nee. ");
INSERT INTO zadNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Na' kat' gak diika', shi no iṉa le': “Ḻi wwia, ni ze Crístona'”, wa iṉe', “Ḻi wwia, na' zie'”, bi shajḻe'le. ");
INSERT INTO zadNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ḻa' wchej beṉ' siye'gake' iṉazgake': “Nadaan Crístona'”, na' beṉ' chonz ka chyix̱jee daa che' Chioza'ne', na' wli'gake' no yeḻ' wak kwenc̱he siye'gake' beṉ', ax̱t sheḻ' wxegakile' siye'gake' beṉ'ka' ba wlej Chioza' nakgake' lo nee. ");
INSERT INTO zadNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Wsak'gale. Ba bzenid' le' ka nak yog' diiki zi' gak. ");
INSERT INTO zadNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Na' kat' ba biyoll wde yeḻ' zak'zi'ka', lii yic̱hoḻte lao wbilla' na' beo'do'na' bich wzeeni'n. ");
INSERT INTO zadNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Na' beljdo'ka' ixopgakan na' yog' diika' llia xan yabana' iṉibgakan. ");
INSERT INTO zadNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Na' ile'gakile' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, zizaa ladj bejka' kon yeḻ' wak choo yeḻ' wak xen c̱ha'na' na' balaaṉ c̱ha'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na' wseḻaa anjl c̱ha'ka' tap ḻaate yell-lioni ax̱t gana' zeelo chiyollan kwenc̱he yitopgake' beṉ'ka' nak lall' na'. ");
INSERT INTO zadNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Ḻi wwia ka chak c̱he yag yix̱wewa': kat' chzolo chigaan na' chibia xḻaguinna', na' chakbe'ile ba zoa yiyoo la'o linna'. ");
INSERT INTO zadNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ka'kzan, kat' ile'ile ba chak yog' diiki ba wnia' le' gak, na' gakbe'ile ba zoa gaoshosh te c̱he yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Dii ḻi nia' le', aga ba wit beṉ'ki zoa ṉaa kat' gak yog' diiki. ");
INSERT INTO zadNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yabana' na' yell-lioni te c̱hegakin, san cho'a xtillaana' aga wde bi gak ka nan. ");
INSERT INTO zadNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Na' kono ṉezi bi lla bi gor gak diiki, ni anjlka' lle' yabana', ni nad' nak' Xiiṉ' Chios. Toz X̱a' Chioza' ṉezile'n. ");
INSERT INTO zadNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Ḻi wsak', na' ḻi se kwas, na' ḻi we'ḻwill Chioza', ḻa' bi ṉezile bat illin lla gakan. ");
INSERT INTO zadNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nakan ka ben to beṉ' ba zoa see shaje' to yell zit', na' golle' beṉ'ka' chon xshine'na' gapgake' lille'na'. Na' to togake' bene' lall' na'gake' daa gongake', na' golle' beena' chap cho'a leej c̱he'na' bi guetlalleen. ");
INSERT INTO zadNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ḻi se kwas, ḻa' bi ṉezile bat yila' x̱an yoona'; shi yilee chaldo'zə, wa yilee chel, wa kat' chbell tezka', wa yilee cheeni'ḻesdo'. ");
INSERT INTO zadNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Shi tokonganzə yilee na' yidoḻile' le' bich ze kwasle. ");
INSERT INTO zadNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Dga nia' le', ḻekzka' yog'ḻoḻ beṉaan chep' ka', ḻi se kwas. ");
INSERT INTO zadNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chyallj zi c̱hop llazə gaḻ' lṉi Paskwa', kana' chaogake' yetxtila' bi yoo levadúrana', na' bx̱ozka' chṉabia' na' beṉ'ka' chli' chsedi leya' biyiljlall'gake' naklə siye'gake' Jesúza' kwenc̱he gox̱'gake'ne' na' witgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Na' che' ljwellgake': ―Bi gox̱'chone' lo lṉina' kwenc̱he bi wsees wc̱heeṉcho beṉ' yell. ");
INSERT INTO zadNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ka zoa Jesúza' Betániana', wyaje' lill beena' le Simón, beena' gok yillwe' daa le lepra. Na' shlak chi'e cho'a mesa', bllin to noolə nox̱ee to lmet de yaj xochi yoollan set zix̱ de nardo na' dii xen zakaan. Na' wdishje' yen lmeta' na' bwazje' set zix̱a' yic̱hj Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Na' baḻ beṉ'ka' lle' na' bllaagake', na' che' ljwellgake': ―¿Berac̱he benditjz nooli set zix̱a'? ");
INSERT INTO zadNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Sheḻ' bet'chokle'n na' bi'e mecha' beṉ' yesh'ka', ḻa' zakaan c̱he shoṉ guiyoa lla c̱he laxj beṉ'. Na' bsheshlengake' noola' daa bene' ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Na' che' Jesúza': ―Bibi ye'lene'. ¿Berac̱he chsheshlenzlene'? Daa ba bene' c̱ha' nakan dii wen. ");
INSERT INTO zadNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ka nak beṉ' yesh'ka', toshiizi soagake' ladjlena', na' wak gaklenle ḻegake' kat'ka' cheenile'; san nad', aga toshiizin soalen' le'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ka nak nooli ba bene' daa zeelo gok bene'. Ba bwazje' nad' set zix̱a' kwenc̱he gakshao'zega kwerp c̱ha'ni kat' wkwash'gake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Dii ḻi nia' le', gattezə we'gake' dill' wen dill' kob c̱he Chioza' lo yell-lioni, ḻekzka' we'gake' dill' ka nak dii wenna' daa ba ben nooli na' lljadingakile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na' Jud Scariota', beena' nake' txen beṉ'ka' shlliṉ, wyaje' lao bx̱ozka' chṉabia' kwenc̱he gone' Jesúza' lo na'gake'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na' ka golle' ka', bibagakile' na' bc̱hebgake' we'gake'ne' mech. Na' wzolo Juda' chinoe' nakan gone' kwenc̱he gone' Jesúza' lo na'gake'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na' lla nech c̱he lṉina' kat' chaogake' yetxtila' daa bi nc̱hix̱ə levadúrana', llana' chitgake' xil'do'na' chaogake' lṉi Paskwa', beṉ'ka' nak Jesúza' txen wṉabgakile'ne': ―¿Ga cheenilo' lljasini'anto' xshe' c̱he lṉi Paskwi? ");
INSERT INTO zadNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Na' bseḻee c̱hopgake', chi'e ḻegake': ―Ḻi shaj yell Jerusalénna' na' yillagle to beṉ' byo zino'e to chee nis, na' lljanólene'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Na' gana' yiyo'e, ḻi yee x̱an yoona': “Maestrona' ne': ¿Garan zoa yoona' gana' gaolene' beṉ'ka' nakgake'ne' txen lle' lṉi Paskwi?” ");
INSERT INTO zadNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Na' wliile' le' to yoo xen dii llia shkwia cha'lə ga ba nonshao'tie'. Na' nan' wsini'ale daa gaocho xshe'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na' wza' beṉ'ka' bseḻee, wyajgake' yella'. Na' gok kon kayeṉ' golle' ḻegake'. Na' bsini'agake' daa gaogake' lle' lṉi Paskwa'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na' ka goḻ billinlen Jesúza' beṉ'ka' shlliṉ yoona'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na' shlak chi'gake' cho'a mesa' chaogake', goll Jesúza' ḻegake': ―Dii ḻi nia' le', tole chi'le ni chaolenle nad' gonle nad' lo na' beṉ'ka' chakzi' chakzbani nad'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Na' gokyesh'gakile', na' wzolo to togake' chṉabgakile'ne': ―¿Anadaan gon' ka', lla? ");
INSERT INTO zadNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Na' che' Jesúza' ḻegake': ―Ladjleni, ka le' nakle shlliṉ chḻeejlenle nad' yetxtila' ḻoo yeeṉi, len beena' gon ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ka nak nad', Beṉ' Bseḻ' Chioza' Yell-lioni, wit beṉ' nad' ka na Cho'a Xtill' Chioza'. Per nyesh'laz gak c̱he beena' gone' nad' lo na' beṉ'ka'. Naklan wen sheḻ'ka' bi golje'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na' shlak chaogake', bex̱' Jesúza' yetxtila' na' bi'e Chioza' yeḻ' chox̱ken, na' bxoxje'n na' bi'en ḻegake', chi'e: ―Ḻi gao dga. Ḻennan' kwerp c̱ha'ni. ");
INSERT INTO zadNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Na' bex̱ee kopa', na' bi'e Chioza' yeḻ' chox̱ken na' bdie'n lawe'ka' na' yog'ḻoḻgake' weejgake' daa yollan. ");
INSERT INTO zadNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Na' chi'e ḻegake': ―Ḻennan' xc̱hen'na' daa gon ka gak ḻi dii koba' bc̱heb Chioza' gone'. Na' ḻaljan kwenc̱he gaklenan beṉ' zan. ");
INSERT INTO zadNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Dii ḻi nia' le', bichga yeej' x̱is uvana' ax̱t ki illin lla yeeja'n gana' chṉabia' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Na' ka biyoll beḻgake' be'la'ogake' Chioza', na'ch wyajgake' lo Yaa Olívoza'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Na' che' Jesúza' ḻegake': ―Yog'le le' kwej yic̱hjle nad'. Ḻa' Cho'a Xtill' Chioza' nan: “Wit' beena' chap xil'ka', na' guesles xil'ka' chape'.” ");
INSERT INTO zadNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Per kat' ba biban' ladj beṉ' wetka', na' yiyaa Galileana' lljalez' le'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Na' che' Pédrona'ne': ―Ḻa'kzi yog' beṉ'ki c̱hooṉlall'gake' li', nad' bi gon' ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Na' che' Jesúza'ne': ―Dii ḻi nia' li', ṉaanyel ka zi' kwell teza' de wchop shii, shoṉ shii wi'o dill' nan bi nombi'o nad'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Na' zeyid Pédrona' chi'ene': ―Ḻa' guetlentia' li', biga iṉia' bi nombi'a li'. Na' yog'zgake' che'gake'ne' ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Na' wyajgake' to latj gana' le Getsemaní, na' che' Jesúza' beṉ'ka' nakgake'ne' txen: ―Nizə ḻi kwe' shlak llje'ḻwill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na' bc̱hi'e Pédrona', Jacóbona', na'ch Juanna', na' wzoloe' chakyeshile' na'ch chakchgaile' dii wal inlleb. ");
INSERT INTO zadNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Na' chi'e ḻegake': ―Ax̱t chaklikazid' lii guettia' daa ḻe chakyeshii yic̱hjlall'dawaani. Ḻi igaaṉ nizə na' bi guesle. ");
INSERT INTO zadNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Na' wzee zi lat' kwite'ka', na' bc̱hek' xibe'na' lo yona' na' be'ḻwille' Chioza' chi'ene' shi wak ten ka'zə daa wtiḻe'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Na' chi'e: ―X̱adawaa, aga bi dii lallj c̱ho' li' de. Bislagach nad' lawi dga ba zoa idiḻ illag'. Per aga gak ka cheenid', san gak ka cheenilo' li'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Na' biyaje' gana' lle'gake' na' ble'ile' ba chesgake'. Na' chi'e Pédrona': ―Simón, ¿Aba cheson'? ¿Abikzə bchejlat'gailo' ḻa'c̱h' tgor bi gueso'? ");
INSERT INTO zadNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bi guesle, ḻi we'ḻwill Chioza' kwenc̱he bi we'zle latj gon beli chenna' le' gan. Aga ki cheeni yic̱hjlall'do'chona' gonchon per beli chenna' bi chizoin. ");
INSERT INTO zadNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Na' wyaje' sto shii jeḻwille' Chioza', na' toz ka golle'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Na' ka billine' gana' lle'gake', na' bizle'ile' chizesgake', ḻa' jalawe'ka' bi chizoyin bishgala'. Na' bibi billelgakile' ye'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Na' ka billine' de wyoṉ shii, chi'e ḻegake': ―¿Ani cheskzle? Ba gok. Ba bllin gor nad', Beṉ' Bseḻ' Chioza' Yell-lioni, gak' lo na' beṉ' saaxyaka'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ḻi c̱has. Ḻi sho'. Ba za' beena' gone' nad' lo na'gake'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ni choe'te Jesúza' dill' ka bllin Juda', beena' wlen beṉ'ka' shlliṉ, lene' beṉ' zan beṉ'ka' bseḻ' bx̱ozka' chṉabia' len beṉ'ka' chli' chsedi leya' na'ch beṉ' golka' chṉabia', nox̱'gake' spad, na' no yag. ");
INSERT INTO zadNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na' Juda', beena' bene'ne' lo na' beṉ'ka', ba be'le' dill', chi'e: ―Beena' wnop', ḻen' gox̱'le, na' wc̱he'lene'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Na' ka bllingake', jabiguee lao Jesúza' na' chi'ene': ―¡Maestro! Na'ch bnope'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Na' lii bex̱'tegake' Jesúza' bc̱he'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Na' to beena' len na' wleje' spad c̱he'na' bc̱hogue' shḻaa nag xmos bx̱oz choo bx̱oz xenna'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Na' che' Jesúza' ḻegake': ―¿Berac̱he za'zle nox̱'le no spad no yag kwenc̱he gox̱'le nad' ka to no beṉ' wban? ");
INSERT INTO zadNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yog' lla wzoa' ladjlena' bli' bsedid' ḻoo yoodo'na', na' biga bex̱'le nad'. Per chonan byen gak ka na Cho'a Xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Na' yog'ḻoḻ beṉ'ka' ben Jesúza' txen wchooṉlall'gake'ne' na' bxoṉjgake'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na' to bi' xkwid' nob' ḻe' ndobb' to lech'. Na' ka bex̱'gake'b' ");
INSERT INTO zadNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","bsam' lechaa ndobb' na' bxoṉjb' gaḻ'yidzb'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Na' jwa'gake' Jesúza' lao bx̱oz choo bx̱oz xenna', na' bdi'a yog'ḻoḻ bx̱ozka' chṉabia' na' beṉ' golka' chṉabia' na'ch beṉ'ka' chli' chsedi leya'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na' zit' zit'lə jano Pédrona'ne' bllintie' lesh' lill bx̱oz choo bx̱oz xenna'. Na' wche'lene' beṉ'ka' chap yoodo'na' chbillgake' cho'a yi'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na' bx̱ozka' chṉabia' na' yog'ḻoḻ beṉ'ka' chṉabia' beṉ' Israelka' lle' na' chiyiljyollgake' ga si' sengake' kwenc̱he wc̱hoglogake' c̱he Jesúza' guete', per bi bllel dii gao xya c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ḻa'kzi beṉ' zan chiya de wxiye' che'gake' c̱he', bi bidiḻi cho'a dillaa choe'gake'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Baḻgake' wzolla'gake' chziye'gake' na' chaogake' xya c̱he', che'gake': ");
INSERT INTO zadNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Neto' ba beninto' ne': “Nad' wc̱hiṉj yoodo'ni dga ben beṉ' yell-lioki. Na' ka gak shoṉ lla yiḻis' ston na' aga beṉ' yell-lionichan gone'n.” ");
INSERT INTO zadNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Na' ḻa'kzi wxiye'gake', bi bidiḻi cho'a xtilleeka'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Na' bx̱oz choo bx̱oz xenna' wzollee ladj beṉ'ka' na' chi'e Jesúza': ―¿Abikz bi iṉo' c̱heyi dga na beṉ'ki c̱ho'? ");
INSERT INTO zadNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Na' Jesúza' wzie' lliz bibi gollkze'. Na' bx̱oz choo bx̱oz xenna' chizi'ene': ―¿Alin' Crístona', Xiiṉ Chioza'? ");
INSERT INTO zadNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Na' che' Jesúza'ne': ―Awe, nadaan. Na' ile'ile nad', Beṉ' Bseḻ' Chioza' Yell-lioni, chi'a de shḻi c̱he Chioza', beṉ' yeḻ' wak choo beṉ' yeḻ' wak xenna', na' ḻekzka' ile'ile' zizaa ladj bejka' ze xan yabana'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Na' bx̱oz choo bx̱oz xenna' bsho' bc̱hez' xe'na' kwenc̱he chli'n nan ḻe chllee. Na' chi'e: ―Bich chyalljicho beṉ' gawe' xya c̱he beeni. ");
INSERT INTO zadNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kwinle ba benile ka chṉie' c̱he Chioza'. ¿Nakra gonchon? Na' yog'ḻoḻgake' bc̱hoglogake' c̱he' nan chiyaḻ' guete'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Na' baḻgake' wzologake' chlla'gake'ne' x̱eneeka'. Na' bsejgake' jalawe'na' na'ch chgap' chball'gake'ne', na' che'gake'ne': ―Wnashki, non bet li'. Na' beṉ'ka' chap yoodo'na' wdap'gake' x̱ague'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na' Pédrona' zie' lesh' chyoona' de lli'lə ka bllin to noolə, beṉ' nak xmos bx̱oz choo bx̱oz xenna'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Na' ka ble'ile' Pédrona' chbille' cho'a yi'na', na' wzie' chwie'ne' chi'e: ―Lenon' nako' txen Jesús, beṉ' Nazareta'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Na' bi bc̱heb Pédrona', san chi'e: ―Bi nombi'a beena', ni bi ṉezid' bi dillaan choo. Na' bicheje' na' jazie' cho'a leeja'. Na' wchell to tez. ");
INSERT INTO zadNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na' ble'i noola'ne' sto shii, na' golle' beṉ'ka' sto: ―Beenin lene' beṉ'ka' nak Jesúza' txen. ");
INSERT INTO zadNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Na' sto shii bi bc̱hebe' nake'ne' txen. Na' ka gok zi shloll, beṉ'ka' lle' na' gollgake'ne' sto shii: ―Dii ḻi lenon' nako'ne' txen, ḻa' nakbia' nako' beṉ' Galilea. ");
INSERT INTO zadNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Na' Pédrona' wzoloe' chone' zṉia, chi'e: ―Chioza' gone' yeḻ' zi' c̱ha' shi chziye'zan nia' bi nombi'ane'. ");
INSERT INTO zadNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Na' katena' lii wchellte teza' de wchop shii. Na' jadini Pédrona' daa goll Jesúza'ne': “Ka zi' kwell teza' de wchop shii, na' gak shoṉ shii bi wc̱hebo' shi nombi'o nad'.” Na' wzoloe' chbelle'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na' ka wyeeni' bidi'a bx̱ozka' chṉabia' len beṉ' golka' chṉabia', na' beṉ'ka' chli' chsedi leya' na'ch yog'ḻoḻ beṉ'ka' chṉabia'gake' yell Israela'. Na' bc̱hejgake' Jesúza' jwa'gake'ne' lao Pilátona'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Na' wṉabi Pilátona'ne', chi'e: ―¿Alin' nako' beṉ' wṉabia' c̱he beṉ' Israelka'? Na' che' Jesúza'ne': ―Kan' ba wno'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na' bx̱ozka' chṉabia' dii zan dii chaogake' xya c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Na' che' Pilátona'ne' sto shii: ―¿Abibi iṉakzo'? Bwialat', dii zan dii chaogake' xya c̱ho'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Na' bibi goll Jesúza'ne'. Na' bibani Pilátona' daa bibi golle'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na' kat' chaḻ' lṉina', Pilátona' chisane' to beṉ'ka' nseje' lillyana', beena' iṉab beṉ' yellka' wsane'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","To beṉ' le Barrabás die' lillyana' len beṉ'ka' benlene' xyana' daa bx̱egake' wdiḻa'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Na' bdi'a bllag beṉ' yellka', na' che'gake' Pilátona' gone' ka chonkze' yog' yiz. ");
INSERT INTO zadNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Na' che' Pilátona' ḻegake': ― ¿Acheenile yisan' beṉ' wṉabia' c̱heleni, le' nakle beṉ' Israel? ");
INSERT INTO zadNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ḻa' chakbe'ile' nan bx̱ozka' chṉabia' daa chakxe'zgakile'nen' jwa'gake'ne' lawe'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Na' bx̱ozka' chṉabia' bta bṉegake' beṉ'ka' lle' na' kwenc̱he iṉabgake' yisane' Barrabáza'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Na' che' Pilátona' ḻegake': ―Na' bera cheenile' gonid' beena' nale nake' beṉ' wṉabia' c̱hele, le' beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Na' besyaagake' che'gake': ―¡Bdee ḻee yag cruza'! ");
INSERT INTO zadNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Na' che' Pilátona' ḻegake': ―¿Bera dii malan' bene'? Na' zizikli besyaagake' che'gake': ―¡Bdee ḻee yag cruza'! ");
INSERT INTO zadNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Na' daa goklall' Pilátona' yigaaṉe' wen lao beṉ'ka' lle' na', bisane' Barrabáza'. Na' bene' mandad wit c̱hingake' Jesúza', na'tech bene'ne' lo na' beṉ'ka' wda'gake'ne' ḻee yag cruza'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na' bc̱he' soldadka' Jesúza' lesh' chyoona' gana' chon Pilátona' yeḻ' josc̱hisa', na' biti'a bishaggake' yog' soldadka' lle' na'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Na' bwakwgake'ne' to lech' xṉa, na' bengake' to bxooṉ de xis yesh' na' bllingake'n yic̱hje'na' ka to corona. ");
INSERT INTO zadNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na' wzologake' chosyaagake' nagake': ―¡Soashga beṉ' wṉabia' c̱he beṉ' Israelka' mbalaz! ");
INSERT INTO zadNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na' wdingake' xisa' yic̱hje'na', na' bllaa x̱eneeka' ḻe', na' bc̱hek' xibe'ka' lawe'na' bengake' ka beṉ' chgwee balaaṉ. ");
INSERT INTO zadNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ka biyoll btitjgakile'ne', bikwasgake' lech' xṉana' daa bx̱oagake' kolleena' na' biwakwgake'ne' xe'na'kzə. Na' wlejgake'ne' kwenc̱he lljada'gake'ne' ḻee yag cruza'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","To beṉ' yell Cirene lie' Simón, x̱a Alejándrona' na' Rúfona', zizee lyix̱aa. Na' ka billague' ḻegake', bengake' byen bi'e yag cruz c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na' bc̱he'gake' Jesúza' latja' le Gólgota, na' zejin: Latj c̱he llit yic̱hj beṉ' wet. ");
INSERT INTO zadNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na' bshabgakile'ne' vino daa nc̱hix̱ə mírrana', per bi weeje'n. ");
INSERT INTO zadNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Na' bda'gake'ne' ḻee yag cruza'. Na' soldadka' bengake' to wyitj kwenc̱he yiḻaagake' xe'na' na' ikaagake' daa yidoḻ' to togake'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Na' chida ga kana' bda'gake'ne' ḻee yag cruza'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na' yic̱hj yag cruz c̱he'na' bda'gake' to dii cho'en dill' bic̱he nda'gake'ne' ḻee yag cruza', nan: “Beenin beṉ' wṉabia' c̱he beṉ' Israelka'.” ");
INSERT INTO zadNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na' bda'lengake'ne' c̱hop beṉ' wban, toe' wda' kwite' de shḻina', na' stoe' kwite' de robesa'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na' billinin ka na Cho'a Xtill' Chioza' daa nan: “Ble'gakilene' ka to beṉ' mal.” ");
INSERT INTO zadNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na' beṉ'ka' chde na', chṉeḻegakile'ne', na' chta yic̱hje'ka' che'gake': ―¡Lin' wnazo' yic̱hiṉjo' yoodo'na' na' lo shoṉ llazə yiyono'n, ");
INSERT INTO zadNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","bislashki kwino' na' biyetj ḻee yag cruza'! ");
INSERT INTO zadNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na' ḻekzka' chon bx̱ozka' chṉabia' len beṉ'ka' chli' chsedi leya', chṉeḻegakile'ne', che'gake': ―Beṉ' yoblə gok bisle', na' bi chak yisla kwine'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Shi leile' ḻen' Crístona', beṉ' wṉabia' c̱hechona', cho' beṉ' Israel, yiyetjshkile' ḻee yag cruza' ṉaa kwenc̱he ile'teicho na' shajḻe'cho c̱he'. Na' ax̱t len beṉ'ka' da'lene' ḻee yag cruza' chṉeḻegakile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ka bllin gobill, doxen yell-liona' bic̱hoḻ, bllinte chida shoṉ. ");
INSERT INTO zadNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na' chida shoṉ besyaa Jesúza' zillj, chi'e: ―Eloí, Eloí, ¿lama sabactani? ―na' zejin: Chios c̱ha', Chios c̱ha', ¿bic̱he ba wlej yic̱hjzo' nad'? ");
INSERT INTO zadNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Na' baḻ beṉ'ka' lle' na' bengakile' daa wne' na' che'gake': ―Ḻi wzenag, ba chaxe' Elíaza'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Na' zejdo toe' na' bḻeeje' to dii chzi' nisa' gana' yollə vino daa zic̱hj zḻa' na' bzoe'n to lo xis kwenc̱he bzoe'n cho'ena' x̱ope'n, na' chi'e: ―Jwayishkile'na', wwiashkicho shi wid Elíaza' yiḻetje'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Na' besyaadia Jesúza', na'ch wite'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na' ka wite', lechaa ze ḻoo yoodo'na' bcheza'n gokan c̱hoplə. ");
INSERT INTO zadNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na' beena' chṉabia' soldadka' zie' lao Jesúza', ka benile' besyee na' ble'ile' ka gok wite', na' chi'e: ―Dii ḻi beenin Xiiṉ Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ḻekzka' zi baḻ noolka' lle'gake' de zit'lə chwiagake'. Na' ladje'ka' len María beṉ' Magdálana', na' Saloména', na'ch María, beena' nak x̱na' Joséna' len Jacóbona', beṉ' neshaa. ");
INSERT INTO zadNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Noolkin wnogake' Jesúza' na' goklengake'ne' kana' zoe' gana' mbani Galileana'. Na' ḻekzka' len zanch noolka' beṉ'ka' wyajlengake'ne' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na' llana' gok ka' nakan llana' chsini'a beṉ' Israelka' c̱he llana' chombaaṉgake'. Na' ka goḻ, ");
INSERT INTO zadNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","bllin José beṉ' Arimatéana', beena' nak txen beṉ'ka' chṉabia' beṉ' Israelka', na' lene' none' lez beena' wseḻ' Chioza' iṉabi'e. Na' biyaxjile' wyaje' lao Pilátona' jaṉabe' lsens yiḻetje' kwerp c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Na' bibani Pilátona' daa ba wite'. Na' goxe' beena' chṉabia' soldadka' kwenc̱he iṉabilene' shi dii ḻikzan ba witen'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Na' ka che' beena' chṉabia' soldadka' ba wite' na' wxenlallee, na' bi'e lsens biḻetj Joséna' kwerp c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Na' wxi' Joséna' to lech' de lino na' biḻetje' kwerp c̱he Jesúza' na' bitobe'ne' lechaa. Na' jḻo'ene' to ḻoo blej, na' bisejile'n to yaj xen. ");
INSERT INTO zadNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na' María beṉ' yell Magdálana', na' María, xṉa' Joséna', chwiayeṉ'gake' gana' jḻo'ene'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Na' ka wde lla sabda', llana' chombaaṉ beṉ' Israelka', María beṉ' Magdálana' len Saloména', na'ch María, x̱na' Jacóbona', wxi'gake' diika' chḻa' zix̱ kwenc̱he wlla'gake'n kwerp c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na' lla nech c̱he xmanna', shinzə chla' wbilldo'na', wyajgake' cho'a ba c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Na' ka zejgake' che' ljwellgake': ―¿Nora gaklen cho' wkwase' yaja' daa chi' cho'a ba c̱he'na', lla? ");
INSERT INTO zadNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Per ka bllingake', ble'gakile' bich chi' yaj xenna' cho'a bana'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na' ka wyoogake' ḻoo bana', ble'gakile' chi' to beṉ' xkwid' de shḻi c̱he bana' nakwe' to lech' llyish dii toṉ. Na' ḻe blleb noolka'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Na' chi'e ḻegake': ―Bi illeble. Le' chiyiljle Jesús, beṉ' Nazareta', beena' bda'gake' ḻee yag cruza'. Ba biban beena', bich zoe' ni. Ḻi wwiakachi gana' wdix̱jgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ḻi yiyaj lao beṉ'ka' nakgake'ne' txen na' len lao Pédrona', na' ḻi lljayellgake': “Ba ziyaje' zjaleze' le' Galileana', na' na' yile'ile'ne' sto shii, kon ka wne' le'.” ");
INSERT INTO zadNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Na'ch bichej noolka' ḻoo bana' ziyajdogake' ax̱t chxiztitgake' daa ḻe chllebgake'. Na' kono bi gollgake' daa ḻe bllebgake'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na' ka biban Jesúza' ladj beṉ' wetka' lla nech c̱he xmanna' shzildo', zigaate bli'lawe' María beṉ' yell Magdálana', beena' bibej Jesúza' gall dii x̱iw'ka'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Na' Maríana' wyaje' lao beṉ'ka' wdalen Jesúza' txen. Na' ka blline' lawe'ka' ḻe chakyesh'gakile' na' chbellgake', na' golle' ḻegake' ba biban Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Na' ka beni beṉ'ki mban Jesúza' na' ba ble'teyi Maríana'ne', bi wyajḻe'gake'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ka biyoll gok ka', c̱hop beṉ'ka' nak Jesúza' txen ngoogake' nez zejgake' lyix̱aa, na' bli'lawe' ḻegake' na' nake' nlla'lə. ");
INSERT INTO zadNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Na' biyajgake' gana' lle' beṉ'ka' sto, jayellgake' ḻegake' ba ble'gakile'ne', na' ni c̱hegake' bi wyajḻe'gake'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Na' wdetech, bli'lao Jesúza' beṉ'ka' shnej shlak chi'gake' chaogake'. Na' bsheshlene' ḻegake' daa bi chajḻe'gake' na' daa nakgake' lall'do' c̱hec̱h, ḻa' bi wyajḻe'gake' c̱he beṉ'ka' ble'gakile'ne' ka wde bibane'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Na' chi'e ḻegake': ―Ḻi shaj doxen yell-lioni, ḻi lljtix̱je'i yog'ḻoḻ beṉ' dill' wen dill' kob c̱ha'na'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Beena' shajḻe' na' c̱hoe' nisa', gat' yeḻ' mban c̱he' zejḻi kaṉi, san beena' bi shajḻe', c̱hogbi'a kwiayee. ");
INSERT INTO zadNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na' diikin gon beṉ'ka' nonḻilall' nad': wc̱hingake' lia'na' yibejgake' dii x̱iwaa yoo beṉ'; na' iṉegake' dill' kob dii bi nombia'gake'; ");
INSERT INTO zadNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","na' shi gonzin gox̱'gake' no beḻ wa yeejgake' dii nak yierb, aga bi gakgakile'. Na' ḻekzka' wx̱oa neeka' yic̱hj beṉ' we'ka' na' yiyakgakile'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ka biyoll bshaljlene' ḻegake', X̱ancho Jesúza' biyepe' yabana' na' jachi'e kwit Chioza' shḻaa de shḻina'. ");
INSERT INTO zadNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na' beṉ'ka' nakgake'ne' txen wyajgake' doxen jtix̱je'gake' cho'a xtilleena' na' X̱ancho Jesúza' goklene' ḻegake' bengake' yeḻ' wakka' kwenc̱he wyajḻe' beṉ' dillaa be'gake' nakan dii ḻi.");
INSERT INTO zadNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Beṉ' zan ba goklall'gake' wzejgake' to to diika' ba gok ladjnto'ni ");
INSERT INTO zadNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","kon ka wna beṉ'ka' bli' bsedi neto', beṉ'ka' ble'gakile' daa gok dezd nech na' gok lo na'gake' be'gake'n dill'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na' ka'kz nad', ba wṉabyoll' nakyeṉ'an gok dezd nech. Na' chakid' nakan wen wzej' li', Teófilo, kon ka gok to to diiki, ");
INSERT INTO zadNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kwenc̱he iṉezilo' daa ba bli' bsedgakile' li' nakan dowalj dii ḻi. ");
INSERT INTO zadNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kana' chṉabia' rey Heródeza' gana' mbani Judeana' wzoa to beṉ' wlie' Zacarías, goke' toz bx̱ozka' nonlen dii Abíaza'. Na' xoole', Elizabeta', ḻekzka' goke' xiiṉ dia c̱he dii bx̱oz Aarónna'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Na' c̱hop xooltie' chongake' wen lao Chioza', na' chongake' yog'ḻoḻte daa nllie' bia'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Na' aga no xiiṉgake' wzoa daa nak Elizabeta' nool will; na' ba naktegake' beṉ' gol. ");
INSERT INTO zadNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Na' to shii ka bidoḻ' bx̱ozka' nak Zacaríaza' txen gongake' xshin Chioza' daa nak lo na'gake', ");
INSERT INTO zadNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","bengake' to wyitj, ka yoologake' chongake', kwenc̱he got'bia' noe' yidoḻ' lljḻo' llen yala' ḻoo lill xḻatj X̱ancho Chioza'. Na' bidoḻ' Zacaríaza' gone'n. ");
INSERT INTO zadNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na' shlak chgwee llen yala' ḻoo yoodo'na', beṉ' zan bgaaṉ chyoolə choe'ḻwillgake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na' bli'lao to anjl c̱he X̱ancho Chioza' Zacaríaza', na' anjla' zie' shḻaa de shḻina' gana' chzeygake' yala'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ka ble'i Zacaríaza' anjla', bikzə bi billel-lallee gone' daa ḻe bllebe'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Na' anjla' chi'ene': ―Bi illebo' Zacarías, ḻa' Chioza' ba bzenague' daa chṉabilo'ne', na' xoolo' Elizabeta' sane' to xiiṉo' na' wsi'ob' Juan. ");
INSERT INTO zadNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Na' yibachgailo' kat' galjb', na' ḻekzka' beṉ' zan yibayi, ");
INSERT INTO zadNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ḻa' xiiṉo'na' gakb' to beṉ' zakii lao Chioza'. Bi chiyaḻ' wnix̱b' vino wa bichlə dii gonan ka sollib', na' Espíritu Sántona' soloe' iṉabi'e yic̱hjlall'do'baa ka zi' galjləb'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na' yigoob' beṉ' zan xiiṉ dia c̱he Israela' lo xṉez Chioza', beena' nak X̱angake'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Na' kwialob' lao X̱anchona', na' soalen Espíritu c̱he Chioza' ḻeb' ka wzoalene' Elíaza', na' gapb' yeḻ' wak ka daa wdape'. Na' ye'b' beṉ'ka' bi zoalen xiiṉe'ka' wen, yizoagake' mbalaz. Na' gom' ka wzenag beṉ'ka' bi cheeni wzenaggake' dill' sin' c̱he beṉ'ka' zej shḻi lao Chioza'. Na' diikin gom' kwenc̱he kat' za' X̱anchona' na' gonḻilall'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Na'ch che' Zacaríaza' anjla': ―¿Nakra gak iṉezid' shi lekzilo'n?, ḻa' ba nak' beṉ' gol na' ḻekzka' nool c̱ha'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Na'ch che' anjla'ne': ―Nadaan anjl Gabriela', na' chon' xshin Chioza', na' kwine' bseḻee nad' kwenc̱he zaa zidnia' li' dill' wenni. ");
INSERT INTO zadNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na' daa bi wyajḻi'o daa wnia' li', idap shi'ona'. Bich gak iṉio' ax̱t kat'ch illin lla gak yog' dga ba wnia' li'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na' beṉ'ka' lle' chyoolə chbezgake' yichej Zacaríaza', gokllejgakile' daa wllaile' ḻoo yoodo'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Na' ka bicheje' bich chak iṉie', seṉzə chone', na' gokbe'gakile' nan nochodan' bli'lao ḻe' ḻoo yoodo'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Na' ka biyoll ben Zacaríaza' daa llia bia' gone' yoodo'na', na'ch biyaje' lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Na' ka wde gok diiki, na' bia' xoole', Elizabeta'. Na' lao gay' beo' bichkzə ga bcheje', na' wne': ");
INSERT INTO zadNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“X̱ancho Chioza' ba goklene' nad' kwenc̱he bich sia' yeḻ' zto' lao beṉ'.” ");
INSERT INTO zadNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Na' ka gok x̱op beo' noa' Elizabeta', bseḻ' Chioza' anjla' le Gabriel yella' le Nazaret daa llia gana' mbani Galileana', ");
INSERT INTO zadNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","gana' zoa to nool wew' lie' María. Na' Maríana' ba nakan wshagna'lene' to beṉ' le José, na' Joséna' nake' xiiṉ dia c̱he dii rey Davina'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na' wyoo anjla' gana' zoa Maríana' na' chi'ene': ―¡Chwap' li' chiox, nool, beṉ' ba goklen Chioza' kwenc̱he gak dii wen c̱ho'! X̱anchona' zoalene' li', na' ba benḻeeyche' li' aga ka yog'ḻoḻte nool. ");
INSERT INTO zadNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Na' Maríana' bibanile' daa golle'ne' ka', na' gokile' berac̱he naz beeni nad' ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Na' che' anjla' ḻe': ―Bi illebo' María, ḻa' Chioza' ba wleje' li' kwenc̱he gone' to dii wen c̱ho'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Na' ṉaa woo to bdo' na' kat' galjb' na' wsi'ob' Jesús. ");
INSERT INTO zadNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Na' gakb' to beṉ' zakii na' ye'gake'b' Xiiṉ Chios, beena' nak ḻiizelozi beṉ' choo beṉ' xen. Na' X̱ancho Chioza' gone'b' to beṉ' wṉabia' ka dii x̱ozxto'b' Davina' ");
INSERT INTO zadNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","kwenc̱he toshiizi iṉabia'b' le' beṉ' Israel, le' nakle xiiṉ dia c̱he dii Jacoba', na' yeḻ' wṉabia' c̱he'baa bi yiyoll yidon. ");
INSERT INTO zadNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Na'ch wṉabi Maríana' anjla', chi'ene': ―¿Nakra gakz wa', lla?, ḻa' aga no beṉ' byo zoalen'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Na'ch che' anjla' ḻe': ―Espíritu Sántona' yidsoalene' li', na' yeḻ' wak c̱he Chioza', beena' nak ḻiizelozi beṉ' choo beṉ' xen, soalenan li'. Na' bi'do'na' galj gakb' lall' na' Chioza' na' ye'gake'b' Xiiṉ Chios. ");
INSERT INTO zadNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ḻekzka' dialla c̱ho' Elizabeta' ba no'e, ḻa'kzi ba nake' beṉ' gol. Na' ḻa'kzi chaki beṉ' nake' nool will, ba gok x̱op beo' no'e. ");
INSERT INTO zadNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Aga bi de dii bi chak gon Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Na'ch che' Maríana' anjla': ―Xmos X̱ancho Chiozan' nak', na' wak gone' c̱ha' kon ka ba wno'. Na' biza' anjla' gana' zoa Maríana'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Na' lii wza'te Maríana' wyaje' to yell dii llia yaa yao c̱he Judeana'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Na' blline' lill Zacaríaza' na' bwape' Elizabeta' chiox. ");
INSERT INTO zadNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na' ka bwap Maríana' ḻe' chiox, gokbe'i Elizabeta' bxit' bdo'na' ḻoo ḻi'ena'. Na' wzolo wṉabia' Espíritu Sántona' ḻoo yic̱hjlall'do'ena', ");
INSERT INTO zadNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","na' wṉie' zillj, chi'ene': ―Chioza' ba benḻeeyche' li' ladj yog'ḻoḻ nool, na' ḻekzka' bdo' c̱ho'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Nora nak' nad' zidwia'zə xṉa' X̱an'na' nad', lla? ");
INSERT INTO zadNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ḻa' kon ka bwapo' nad' chiox, lii bxit'te bdo' c̱ha'ni ḻoo ḻi'ani daa chibaib'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Chakomba li' wyajḻi'o ka wna anjla', ḻa' yog' daa wna X̱anchona', aga wde bi gakan. ");
INSERT INTO zadNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Na'ch wna Maríana': Do yic̱hj do lallaa choe'lawaa X̱ancho Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Chibayi yic̱hjlall'dawaani lao Chioza', beena' chisla nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ba biyesh'lallile' nad' nak' xmose', ṉaa solo yog' beṉ' iṉe' nad': “Chakomba li'.” ");
INSERT INTO zadNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ḻa' Chioza', beena' nap yeḻ' wak choo yeḻ' wak xen, ba bene' dii wen inlleb c̱ha'. Nake' ḻiizelozi beṉ' ḻi beṉ' shao', ");
INSERT INTO zadNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","na' chiyesh'lallile' yog'te beṉ'ka' chall chllebgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dii zakii nlleb ba benlene' yeḻ' wak c̱he'na'. Ba bc̱hiṉj bselle' yog'ḻoḻ daa nan gon beṉ'ka' chep cha'lall'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ba bikwase' yeḻ' wṉabia' c̱he beṉ' wṉabia'ka', na' beṉ'ka' ble'gakile' nakzi, Chioza' ba bene' ḻegake' beṉ' zakii. ");
INSERT INTO zadNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Na' beṉ'ka' chbiḻ chdon, ba bzesh bzeljile' ḻegake' kon dii wen dii shao' c̱he'na', na' bilague' beṉ' wni'aka' to ka cha'gake'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ba goklene' cho' beṉ' Israel, cho' nakcho xmose', na' toshiizi chiyesh'lallile' cho', ");
INSERT INTO zadNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kon ka bc̱hebe' gone' c̱he dii x̱ozxto'cho Abrahama' na' yog' beṉ' zizaak lo dia c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na' Maríana' bgaaṉe' ka do shoṉ beo' lill Elizabeta', na'ch bizee ziyaje' lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na' ka bllin lla wxan Elizabeta', wxane' to bi' byodo'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na'ch ka wṉezi beṉ' wlill c̱he'ka' na' beṉ' dialla c̱he'ka', wyajgake' bibalengakile'ne' daa ba biyeshii X̱ancho Chioza' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na' ka gokib' to xman, jḻoogake'b' seṉ daa ne' circuncisión, na' goklall'gake' wsi'gake'b' Zacarías ka le x̱abaa. ");
INSERT INTO zadNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Na' che' xṉa'baa: ―¡Bi gakan! Juanan chiyaḻ' wsi'nto'b'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Na' gollgake'ne': ―¿Bic̱he wsi'zo'b' ka'? Ḻa' aga no dialla c̱ho' le ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Na'ch bengake' seṉ kwenc̱he wṉabgakile' x̱abaa bi cheenile' wsi'e bdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Na'ch wṉabe' to yagla'do' kwenc̱he bzeje'n, na' daa bzeje' nan: “Juanan wsi'nto'b'.” Na' yog' beṉ'ka' bibani. ");
INSERT INTO zadNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na' lii gokte biṉe Zacaríaza', na'ch wzoloe' choe'lawee Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na' beṉ' wlill c̱he'ka' bllebgake' ka nak daa gok, na' yog' yellka' lle' ladj yaa yao c̱he Judeana' wze dill' ka gok. ");
INSERT INTO zadNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na' yog' beṉ'ka' beni ka gok, gokgakile': ―¿Noran gak bi'do'ni, lla? Wnagake' ka', ḻa' nakbia' zoalen X̱ancho Chioza' ḻeb'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na' Espíritu Sántona' wṉabi'e yic̱hjlall'do' x̱ab' Zacaríaza' na' bi'e cho'a xtill' Chioza', wne': ");
INSERT INTO zadNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Choe'lawaa X̱anchona', beena' nak Chios c̱hecho, cho' beṉ' Israel, ḻa' ba bide' ladjchoni, cho' nakcho beṉ' yell c̱he', kwenc̱he yisle' cho' lawi dii mala'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Na' ba bseḻee to beṉ' nap yeḻ' wak xen yisle' cho', na' zee lo dia c̱he dii Davina', beena' gok xmose'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ba chak ka bc̱hebe' gone' kani'yi daa golle' dii beṉ'ka' wdix̱jee cho'a xtilleena', beṉ'ka' gok lall' nee. ");
INSERT INTO zadNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bc̱hebe' yisle' cho' lao beṉ'ka' bi chle'shii cho', na' lao yog' beṉ'ka' chakzi' chakzbani cho'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Na' golle' dii x̱ozxto'choka' yiyeshile' ḻegake', na' bi gaḻ-lallee ka nak diika' bc̱hebe' gone'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ki nak daa bc̱heb Chioza' gone' c̱he dii x̱ozxto'cho Abrahama': ");
INSERT INTO zadNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Bc̱hebe' yisle' cho' lao beṉ'ka' bi chle'shii cho' kwenc̱he we'la'ochone' na' bibi wwall wsheban cho', ");
INSERT INTO zadNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","na' gon kwincho lall' nee na' goncho ka yiyoolallile' shlak mbancho. ");
INSERT INTO zadNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na'ch Zacaríaza' chi'e bdo' c̱he'na': Na' li', xiiṉdawaa, iṉa beṉ' li' beṉ' chyix̱jee daa na Chioza', beena' nak ḻiizelozi beṉ' choo beṉ' xen. Na' kwialozego' lao X̱anchona' kwenc̱he wzenaggake' c̱he' kat' zee. ");
INSERT INTO zadNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wzenilo' beṉ' wlall c̱hechoka' daa chiyaḻ' gongake' kwenc̱he yizi'xen Chioza' saaxya c̱he'ka' na' yisle' ḻegake' bi tegake' lo yeḻ' zak'zi'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ḻa' Chios c̱hechona' chakile' cho' na' chiyesh'lallile' cho', na' wseḻee to beṉ' za' yabana' nsee to beeni' c̱he yic̱hjlall'do' beṉ' yell-lioni ");
INSERT INTO zadNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kwenc̱he sho' beeni'na' ḻoo yic̱hjlall'do' beṉ'ka' chda gani nak shgasj shc̱hoḻ ni che dii mala' daa nsa' yeḻ' wit, na' wliile' cho' nez ḻi c̱he'na' na' soacho mbalaz. ");
INSERT INTO zadNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Shlak bgol Juanna', ben Chioza'ne' beṉ' wal. Na' wzoe' to latj gana' bibi chashj chḻeb ax̱t ka bllin lla wzoloe' be'lene' beṉ' Israelka' cho'a xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kana' chṉabia' César Augústona', bene' byen ibab baḻ beṉ' lle' to to yell doxen yell-liona' gana' chṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Na' ka wbabgake' dii nech, beena' le Cirenio nake' gobernador c̱he Síriana'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Na' benan byen biyaj yog' beṉ' yell c̱he c̱hegake' kwenc̱he jada' lie'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na' daa nak Joséna' xiiṉ dia c̱he dii Davina', bizee yell Nazareta' daa llia gana' mbani Galileana', na' biyaje' yell Belénna' gana' golj dii Davina', daa llia gana' mbani Judeana'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Na' kwenc̱he ibabgake' biyaje' yell Belénna' len Maríana', beena' ba nakan ikee. Na' Maríana' ba no'e. ");
INSERT INTO zadNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na' shlak zoagake' Belénna', bllin lla sane'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Na' wxane' to bi' byodo' nakb' bi' nech, na' btobe'b' lechaa na' wdix̱je'b' gana' chao bayix̱'ka', ḻa' bich bi latj bllel gana' chigaaṉ beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na' lle'na' goljb', gaozə yell Belénna' lle' x̱oṉj beṉ' chapgake' xil' c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Na' gokx̱e to anjl c̱he X̱ancho Chioza', na' yeḻ' chey cheeni' c̱he X̱anchona' bzeeni'n gana' lle'gake', na' ḻe bllebgake'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Na' che' anjla' ḻegake': ―Bi illeble, ḻa' zidtix̱je'id' le' dill' wen dill' koba' daa gonan ka yibachgayi yog' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ḻa' ṉaa yell c̱he dii Davina' ba golj beena' yisla le' lao dii mala'. Na' ḻen' X̱ancho Crístona', beena' chbezle wseḻ' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na' kwenc̱he yillelileb', ki nak gana' deb': deb' gana' chao bayix̱'ka' na' ndobb' lech'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Na' ka biyoll goll anjla' ka', lii bllinte anjl zanch kwite'na', na' choe'la'ogake' Chioza', nagake': ");
INSERT INTO zadNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡We'la'ocho Chioza' zoa yabana'! Mbalaz beṉ'ka' zoa yell-lioni, beṉ'ka' ba bli'yi Chioza' yeḻ' goklen c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Na' ka biza' anjlka' ziyajgake' yabana', na'ch che' ljwell beṉ'ka' chap xil'ka': ―Ḻi yidoshki Belénna', ḻi sho' diwiashki daa ba gok, daa ba wdix̱je'i anjl c̱he X̱anchona' cho'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Na'ch ziyajdogake' Belénna' na' bllingake' gana' zoa Maríana' len Joséna', na' bdo'na' deb' gana' chao bayix̱'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Na' ka biyoll ble'gakile'b', na' be'gake' dill' lao beṉ' wlall c̱he'ka' daa goll anjla' ḻegake' c̱he bdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na' yog' beṉ'ka' beni ka wna wap xil'ka' bibangakile' ka dillaa be'gake'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Na' Maríana' kon ka biyoll bzenague' dill'ka' na' bgaaṉan ḻoo yic̱hjlall'do'ena', na' gokile' bera zejin dga. ");
INSERT INTO zadNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na'ch ziyaj wap xil'ka' choe'la'ogake' Chioza' daa ba ben ble'gakile' yog' daa goll anjla' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na' ka gokib' to xman, wloogake'b' seṉ daa le circuncisión, na' bsi'gake'b' Jesús kon ka goll anjla' Maríana' kana' zi' weeb'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na' kon ka na ley c̱he dii Moiséza' gongake', wlezgake' ka bzaa llaka' bixi biyech Maríana' len bdo' c̱he'na', na'ch wyajlengake'b' Jerusalénna' kwenc̱he jengake'b' lo na' X̱ancho Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bengake' ka', ḻa' ley c̱he X̱anchona' nan: “Bi' byo nech c̱he yog'ḻoḻ beṉ', chiyaḻ' gongake'b' lo na' Chioza'.” ");
INSERT INTO zadNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na' jaake' je'la'ogake' X̱ancho Chioza' jengake' ka na leya' daa nan chiyaḻ' witgake' c̱hop ngolbex wa c̱hop palom. ");
INSERT INTO zadNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na' kana' jwa'gake' Jesúza' yoodo'na', zoa to beṉ' le Simeón Jerusalénna'. Nake' to beṉ' chon dii wen dii shao' na' choe'lawee Chioza', na' chbeze' batan wseḻ' Chioza' beena' gaklene' beṉ' Israelka'. Na' zoalen Espíritu Santo c̱he Chioza' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Na' Espíritu Sántona' ba bzenile'ne' nan aga wete' shi biṉ' ile'ile' Crístona', beena' chbezgake' wseḻ' X̱ancho Chioza' kwenc̱he iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na' Espíritu Sántona'kz bseḻeene' yoodo'na', na' na' zie' ka bllinlen x̱axṉa' Jesúza' ḻeb' kwenc̱he gongakile'b' ka na leya'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Na'ch bḻen Simeónna' ḻeb' na' be'lawee Chioza', chi'e: ");
INSERT INTO zadNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Chios c̱ha', be' latj guet' mbalaz ṉaa, ḻa' ba beno' daa bc̱hebo' gono' c̱ha', nad' nak' xmoso'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ḻa' ba ble'id' beena' yisla neto', ");
INSERT INTO zadNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","beena' ba bseḻoo lao yog'ḻoḻ beṉ' yell-lioki. ");
INSERT INTO zadNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ḻen' kwee beeni'na' ḻoo yic̱hjlall'do' beṉ'ka' bi nakgake' beṉ' Israel. Na' gone' ka neto' beṉ' Israel sho'nto' balaaṉ, neto' naknto' yell c̱ho'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na'ch Joséna' len xṉa'ba bibangakile' ka nak daa wna Simeónna' c̱heb'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Na'ch wṉabi Simeónna' Chioza' gaklene' ḻegake', na' chi'e Maríana', xṉa' Jesúza': ―Ba nc̱hogbi'a Chioza' c̱he bi'do'ni gom' kwenc̱he zan beṉ' Israelka' kwiayi'gake' na' ḻekzka' zane' yila. Na' wliib' beṉ' ka nak yeḻ' wak c̱he Chioza', na' beṉ' zan iṉegake' zban c̱heb' na' bi shajḻe'gake' c̱heb', ");
INSERT INTO zadNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","na'ch gakbia' ka chza'lall' beṉ' ḻoo yic̱hjlall'do'eka'. Na' ka nako' li', ḻoo yic̱hjlall'do'na' gakan ka'kzə ga chaz to spad ka ile'ilo' daa illaglob'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na' ḻekzka' yoodo'na' zoa to nool goldo', beṉ' chyix̱jee daa che' Chioza'ne', na' lie' Ana. Nake' xiiṉ dii Fanuela' na' xiiṉ dia c̱he dii Asera'. Beṉ' xkwid'ze' bshagnee, na' gall yizchga wzoalene' beṉ' c̱he'na' ka wite'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nake' noolə wizeb na' ba gokile' taplaḻj tap yiz. Na' toshiizi zoe' yoodo'na', na' ka waḻ ka tella zoe' choe'lawee Chioza', na' tlizi chzoe' wbas' na' choe'ḻwille'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na' ḻekzka' wbiguee kwite'ka' na' bi'e Chioza' yeḻ' chox̱ken daa ba bseḻee beena' gaklene' beṉ' Israelka'. Na' bi'e dill' c̱he Jesúza' lao beṉ' Jerusalénka', beṉ'ka' chbez wseḻ' Chioza' beena' yisla ḻegake' lao dii mala'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Na' ka biyoll bengake' yog' daa nllia ley c̱he X̱ancho Chioza' bia', na'ch biyajgake' lalle'ka' daa le Nazaret daa llia gana' mbani Galileana'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na' Jesúza' bgolb' na' zejch gokb' bi' wal na' bi' sin', na' ḻe goklen Chioza' ḻeb'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","X̱axṉa' Jesúza' chajgake' Jerusalénna' yog' yiz kat' chaḻ' lṉi Paskwa'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Na' ka goki Jesúza' shlliṉ yiz, wyajlengake'b' lṉina' kon ka yoologake'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na' ka wde lṉina' biza' x̱axṉa'baa, na' bi gokbe'gakile' bigaaṉ Jesúza' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Gokgakile' do ladj beṉ'ka' ziyajlengake' zilem', na' kon bigootezgake' nez do lla. Na' ka biyiljgake'b' ladj beṉ' dialla c̱he'ka' na' beṉ'ka' nombia'gake' ");
INSERT INTO zadNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","aga billelgakile'b'. Na' bibiigake' jadiljgake'b' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Na' ka gok shoṉə lla billelgakile'b' yoodo'na', chi'b' ladj beṉ'ka' chli' chsedi leya' chzenagb' xtilleeka' na' chṉabib' ḻegake' c̱he daa choe'gake' dill'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Na' yog' beṉ'ka' chzenag xtill'baa chibangakile' yeḻ' chajnii c̱he'baa na' ka chilliib' xtill' beṉ'ka' chli' chsedi leya'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na' ka ble'i x̱axṉa'baab' bibangakile'. Na'ch che' xṉa'baa: ―Xiiṉdawaa, ¿bic̱he benzilo' neto' ka'? X̱o'ni na' nad' ba gokshejlall'chgainto' biyiljnto' li'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Na'ch che' Jesúza' ḻegake': ―¿Bic̱he chiyiljzle nad'? ¿Abi ṉezile chiyaḻ' soa' lill X̱a'na'? ");
INSERT INTO zadNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Na' aga wyajni'gakile' bi zejin daa gollb' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Na'ch Jesúza' biyajlem' ḻegake' Nazareta' na' bzenagb' c̱hegake' toshiizi. Na' xṉa'baa aga goḻ-lallee diika' gok. ");
INSERT INTO zadNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na' Jesúza' zejch bgolb' na' wdapchb' yeḻ' sin', na' Chioza' bibachile'b', na' ḻekzka' bibayi beṉ' ḻeb'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Na' ka gok shin' yiz chṉabia' César Tibériona', na' Poncio Pilátona' chṉabi'e gana' mbani Judéana', na' Heródeza' chṉabi'e gana' mbani Galileana', na' beṉ' bishee Felípena' chṉabi'e gana' mbani Ituréana' len Traconítena', na' Lisániaza' chṉabi'e gana' mbani Abilíniana', ");
INSERT INTO zadNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","na' Anáza' len Caifáza' nakgake' bx̱oz choo bx̱oz xen c̱he beṉ' Israelka'. Na' kana'yeṉ' wṉe Chioza' Juanna', xiiṉ Zacaríaza', kana' zoe' to latj gana' bibi chashj chḻeb. ");
INSERT INTO zadNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Na'ch wyaj Juanna' jte' doxen yell-liona' de cho'a yao Jordánna' na' wdix̱je'ile' beṉ' chiyaḻ' yiyaj yilengakile' na' c̱hoagake' nis kwenc̱he yizi'xen Chioza' c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Bene' kon ka bzej dii Isaíaza' gana' nan: To beṉ' gosyee latja' gana' bibi chashj chḻeb, na' iṉe': “Ḻi se kwas wzenagle c̱he X̱anchona' na' wsalj yic̱hjlall'do'leka' kat' zee. ");
INSERT INTO zadNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ḻa' ḻe' gone' ka chon beṉ' chillee ga nak xitj yao, na' ka beṉ' chc̱hiṉj yaa kwenc̱he chiḻeshe'n. Na' chiḻie' yog'ḻoḻ nez dii nyok nḻew, na' chillee xitjka' chi' lo neza'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na' yog'ḻoḻ beṉ' ile'gakile' ka gon Chioza' yisle' beṉ' lawi dii mala'.” ");
INSERT INTO zadNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na' beṉ' zan chllin lao Juanna' kwenc̱he wchoe' ḻegake' nisa', na'ch kat' chllingake' lawe'na', chi'e ḻegake': ―¡Le' naklikzle ka beḻ zṉia! ¿Achakile wak wxoṉjile' yeḻ' zak'zi' daa wseḻ' Chioza'? ");
INSERT INTO zadNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ḻi gon ka gakbe'i beṉ' nan dii ḻi ba biyaj bilenile'. Na' bi gakzile bibi yeḻ' zak'zi' ile'ile daa iṉazle: “Neto' naknto' xiiṉ dia c̱he dii Abrahama'.” Ni iṉia' le' ax̱t yajki wak gon Chioza' xiiṉ dia c̱he dii Abrahama'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yog'ḻoḻ-le shi bi chonle ka chiyoolallii Chioza' na' gak c̱hele ka chak c̱he to yag dii choe' dii zix̱ dii bi nak wen, na' lii chc̱hogtegake'n na' chzaḻ'gake'n lo yi'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Na' beṉ'ka' chzenag xtill' Juanna' che'gake'ne': ―¿Beran chiyaḻ' gonnto', shka'? ");
INSERT INTO zadNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Na'ch che' Juanna' ḻegake': ―Beena' de c̱hop kwe' xe', chiyaḻ' wi'e shkwe' c̱he beena' bi de c̱he'. Na' beena' de dii cheej chawe', chiyaḻ' gaolene'n beena' bi de c̱heyin. ");
INSERT INTO zadNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Na' ḻekzka' bllin baḻ beṉ' wic̱hixjka' kwenc̱he wchoa Juanna' ḻegake' nisa', na' wṉabgakile'ne': ―Maestro, ¿beran chiyaḻ' gonnto', shka'? ");
INSERT INTO zadNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Na'ch che' Juanna' ḻegake': ―Bi wc̱hixjle dii xenchlə ka to daa chiyaḻ' wc̱hixjle. ");
INSERT INTO zadNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na' ḻekzka' baḻ beṉ'ka' nak soldad wṉabgakile'ne': ―¿Shera neto', beran chiyaḻ' gonnto' shka'? Na'ch che' Juanna' ḻegake': ―Bi wwall wsheble beṉ' kwenc̱he ikaazle bi de c̱he', ni bi wtobilene' dii bi nak ka'. Ḻi gon banez laxjlena'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na' beṉ' zan yoo yic̱hjgake' ila' Crístona', beena' wseḻ' Chioza' kwenc̱he iṉabi'e, na' yog'ze' gokgakile' Juanna'ljan Crístona'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Na' Juanna' golle' ḻegake': ―Zi' za' beena' napch yeḻ' wak xench ka nad'. Na' nad' ni bi zakaa gak' xmose' kwenc̱he wḻec̱hj' xele'na'. Nad' chchoa' le' nis daa chiyaj chilenile, san ḻen' gone' ka yidsoa Espíritu Sántona' ḻoo yic̱hjlall'do'lena', na' beṉ'ka' bi chiyaj chileni, wseḻee ḻegake' lo yi' gabiḻa'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Na' daa gon Crístona' c̱he beṉ' chzaklebin ka daa chon beena' nox̱' yag xoz' daa chpa'ile' trígona', na' yitope' trígona' kooshaween na' wzeye' beb c̱heyinna' lo yi'na' daa biga yiyolkzə. ");
INSERT INTO zadNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kan' nak diika' bzajnii Juanna' beṉ'ka', na' dii zanch dill' dii be'lene' ḻegake' kana' bi'e dill' wen dill' kob c̱he Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Na' Juanna' ḻekzka' bsheshlene' Heródeza', beena' wṉabia' Galileana', daa bikee Herodíaza', xool beṉ' bishee Felípena', na' c̱he bichlə dii malka' ba bene'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Na'ch Heródeza' benche' bish' ljwell dii malka' ba bene' daa wlo'e Juanna' lillyana'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kana' chchoa Juanna' beṉ' nisa', len Jesúza' bchoe'n. Na' shlak choe'ḻwill Jesúza' Chioza', byalj yabana' ");
INSERT INTO zadNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na' betj Espíritu Sántona' jsoalene'ne', na' ble'gakile' Espírituna' ka to palom. Na' bengakile' shii Chioza' za'n yabana', chi'e: ―Lin' nako' Xiiṉ', chakchgaid' li' na' ḻe chibaid' li'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na' do shichoa yizi Jesúza' ka wzoloe' bene' yog' daa llia bia' gone'. Na' yog' beṉ' wnagake' xiiṉ Josénan'. Na' Joséna' goke' xiiṉ Elína', ");
INSERT INTO zadNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elína' goke' xiiṉ Matata', Matata' goke' xiiṉ Levína', Levína' goke' xiiṉ Mélquina', Mélquina' goke' xiiṉ Jánana', Jánana' goke' xiiṉ Joséna'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joséna' goke' xiiṉ Matatíaza', Matatíaza' goke' xiiṉ Amóza', Amóza' goke' xiiṉ Nahuma', Nahuma' goke' xiiṉ Éslina', Éslina' goke' xiiṉ Nagaina'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaina' goke' xiiṉ Maata', Maata' goke' xiiṉ Matatíaza', Matatíaza' goke' xiiṉ Semeina', Semeina' goke' xiiṉ Joséna', Joséna' goke' xiiṉ Judána'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judána' goke' xiiṉ Joánana', Joánana' goke' xiiṉ Résana', Résana' goke' xiiṉ Zorobabela', Zorobabela' goke' xiiṉ Salatiela', Salatiela' goke' xiiṉ Nérina'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nérina' goke' xiiṉ Mélquina', Mélquina' goke' xiiṉ Ádina', Ádina' goke' xiiṉ Cosama', Cosama' goke' xiiṉ Elmodama', Elmodama' goke' xiiṉ Era'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Era' goke' xiiṉ Josuéna', Josuéna' goke' xiiṉ Eliezera', Eliezera' goke' xiiṉ Jorima', Jorima' goke' xiiṉ Matata'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matata' goke' xiiṉ Levína', Levína' goke' xiiṉ Simeónna', Simeónna' goke' xiiṉ Judána', Judána' goke' xiiṉ Joséna', Joséna' goke' xiiṉ Jonánna', Jonánna' goke' xiiṉ Eliaquima'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquima' goke' xiiṉ Meleana', Meleana' goke' xiiṉ Mainána', Mainána' goke' xiiṉ Matátana', na' Matátana' goke' xiiṉ Natánna'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natánna' goke' xiiṉ Davina', Davina' goke' xiiṉ Isaína', Isaína' goke' xiiṉ Obeda', Obeda' goke' xiiṉ Booza', na' Booza' goke' xiiṉ Salmónna', Salmónna' goke' xiiṉ Naasónna'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasónna' goke' xiiṉ Aminadaba', Aminadaba' goke' xiiṉ Arama', Arama' goke' xiiṉ Ezroma', Ezroma' goke' xiiṉ Fáreza', Fáreza' goke' xiiṉ Judána'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judána' goke' xiiṉ Jacoba', Jacoba' goke' xiiṉ Isaaca', Isaaca' goke' xiiṉ Abrahama', Abrahama' goke' xiiṉ Taréna', Taréna' goke' xiiṉ Nacora'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacora' goke' xiiṉ Seruga', Seruga' goke' xiiṉ Ragauna', Ragauna' goke' xiiṉ Pelega', Pelega' goke' xiiṉ Hebera', Hebera' goke' xiiṉ Sálana'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sálana' goke' xiiṉ Cainánna', Cainánna' goke' xiiṉ Arfaxada', Arfaxada' goke' xiiṉ Sema', Sema' goke' xiiṉ Noéna', Noéna' goke' xiiṉ Lameca'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameca' goke' xiiṉ Matusalénna', Matusalénna' goke' xiiṉ Enoca', Enoca' goke' xiiṉ Jareda', Jareda' goke' xiiṉ Mahalaleela', Mahalaleela' goke' xiiṉ Cainánna'. ");
INSERT INTO zadNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainánna' goke' xiiṉ Enóza', Enóza' goke' xiiṉ Seta', Seta' goke' xiiṉ Adánna', na' Adánna' goke' xiiṉ Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ka biza' Jesúza' cho'a yao Jordanna', Espíritu Sántona', beena' chṉabia' ḻoo yic̱hjlall'do'ena', bc̱hi'ene' latja' gana' bibi chashj chḻeb. ");
INSERT INTO zadNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Na' na' wzoe' c̱hoa lla, na' dii x̱iwaa goklalliin kooyeḻa'n ḻe' gone' ka cheenin. Na' shlak wzoe' na' ni lat' bibi wdawe', na' ka gok c̱hoa lla, wdone'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Na'ch che' dii x̱iwaane': ―Shi leilo' nako' Xiiṉ Chios, goll yaji yiyakan yetxtil. ");
INSERT INTO zadNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Na'ch che' Jesúza': ―Cho'a Xtill' Chioza' nan: “Aga toz yeḻ' wawa' choe'n yeḻ' mban c̱he beṉec̱ha', san ḻekzka' Cho'a Xtill' Chioza' choe'n yeḻ' mban c̱hegake'.” ");
INSERT INTO zadNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Na'ch ka wde, bc̱he' dii x̱iwaa Jesúza' to lo yaa sib wal, na' tolbe'do' bliin ḻe' yog' yellka' llia yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Na'ch che'n ḻe': ―Goṉ' li' doxen yeḻ' wṉabia'na' na' yeḻ' zakiina' daa de c̱he yog' yellki, ḻa' ba nakin c̱ha' na' wak wi'an kon no cheenid'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Na' goṉa'n li' shi wc̱hek' xibo'na' we'lawoo nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Na' che' Jesúza': ―Cho'a Xtill' Chioza' nan: “Be'la'o toz X̱ano' Chioza' na' kon daa iṉe', ḻennan' gono'.” ");
INSERT INTO zadNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Na'ch ka wde, bizc̱he' dii x̱iwaa Jesúza' Jerusalénna' na' bḻepan ḻe' yic̱hj yoodo'na' gana' nakch sib wal, na' gollan ḻe': ―Shi leilo' nako' Xiiṉ Chios, lla bxit'shki ni. ");
INSERT INTO zadNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ḻa' Cho'a Xtill' Chioza' nan: Chioza' wseḻee anjl c̱he'ka' gap wwiagake' li', ");
INSERT INTO zadNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","na' gox̱'gake' li' kwenc̱he ki koo wc̱hewo' yajka'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Na'ch che' Jesúza': ―Ḻekzka' na Cho'a Xtill' Chioza': “Bi wzo' Chioza' gone' daa nazan c̱ho' kwenc̱he x̱enlalloo shi gone' ka ba wne'.” ");
INSERT INTO zadNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Na' ka bi gok kooyeḻ' dii x̱iwaa Jesúza' gone' ka cheenin, na'ch bkwasan kwite'na' shloll. ");
INSERT INTO zadNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesúza' billine' gana' mbani Galileana' ziyoochgue' yeḻ' wak c̱he Espíritu Sántona', na' doxenzə na' wze dill' daa chone'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Na' chjali' chjasedile' beṉ' Israelka' gana' chdop chllaggake' choe'ḻwillgake' Chioza', na' yog' beṉ' nagake' ḻe xochi cho'e dill'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Na'ch biyaje' Nazareta', yella' gana' bgole'. Na' ka bllin lla sabda', llana' chombaaṉ beṉ' Israelka', wyaje' gana' chdop chllaggake' choe'ḻwillgake' Chioza' kon ka yooloe' chone'. Na'ch wzollee lawe'ka' kwenc̱he blabe' Cho'a Xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Na' be'gake'ne' yisha' daa bzej dii Isaíaza', beena' wdix̱jee daa goll Chioza'ne', na' ka bzeshe'n blabe' gana' na: ");
INSERT INTO zadNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espíritu c̱he X̱ancho Chioza' zoalene' nad', na' Chioza' ba bzoe' nad' zidye'len' beṉ' yesh'ka' dill' wen dill' kob c̱he'na'. Ba bseḻee nad' kwenc̱he zidtip' lall' beṉ'ka' chakyeshii yic̱hjlall'do'eka', na' zidtix̱je'id' beṉ' wak yisell yiḻaagake', na' gon' ka ile'i beṉ' lc̱hoḻka', na' gaklen' beṉ'ka' chc̱hi' chsak' beṉ' ḻegake', ");
INSERT INTO zadNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na' wi'a dill' ba bllin lla gaklen X̱anchona' beṉ' yell-lioki. ");
INSERT INTO zadNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ka biyoll blabe' yisha' na'ch bitobe'n na' biyo'en beena' ngoo lall' neen, na' bibi'e. Na' yog' beṉ'ka' lle' na' shin chizozgakile' chwiagake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na' wzoloe' cho'e dill', chi'e: ―Ṉaa billinin ka na Cho'a Xtill' Chioza' dga ba benile. ");
INSERT INTO zadNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Na' yog' beṉ'ka' lle' na' che' ljwellgake' ḻe chon beeni, na' chibangakile' ka xochi cho'e dill'. Na' che' ljwellgake': ―¿Aaga beenin xiiṉ Joséna'? ");
INSERT INTO zadNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Na'ch che' Jesúza' ḻegake': ―Wnaljale c̱ha' ka dillaa de: “Wen rmech, biyon kwino'.” Na' ḻekzka' wnaljale nad': “Daa beninto' beno' Capernaúma' ḻekzka' benshkin lallchoni.” ");
INSERT INTO zadNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Na' be'che' dill' chi'e ḻegake': ―Dii ḻi nia' le', to beṉ' chyix̱jee daa che' Chioza'ne' aga no shajḻe' c̱he' yell c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na' nia' le', zan nool wizeb wlle' gani mbani Israeli kana' wzoa Elíaza', beena' wdix̱jee daa goll Chioza'ne', kana' aga bi yej gok shoṉ yiz yoo gashjə na' wche'chga wbinna' doxen gani mbani Israeli. ");
INSERT INTO zadNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Na' bi bseḻ' Chioza' Elíaza' kwenc̱he gaklene' nool wizebka' lle' ni, san bseḻeene' to yell zit' daa le Sarepta, daa llia gaozə yell Sidónna', gana' goklene' to nool wizeb zoa na'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na' ḻekzka' gok kana' wzoa dii Elisewa', beena' wdix̱jee daa goll Chioza'ne'. Beṉ' zan beṉ' Israelka' che'gakile' yillwe' daa le lepra, per ni toe' bi biyone'. Toz beṉ' Síriana' biyone', beena' le Naamán. ");
INSERT INTO zadNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na' yog' beṉ'ka' lle' gana' chdop chllaggake' ḻe bllaagake' daa wna Jesúza' ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Na' lii wzolla'tegake' bibejgake' Jesúza' yella', na' bc̱he'gake'ne' to ga ze bdiṉj xen wal, goklall'gake' lljachix̱gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Per Jesúza' bicheje' ladje'ka' na' ziyaje'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesúza' wyaje' Capernaúma', sto yell daa llia gana' mbani Galileana', na' bli' bsedile' beṉ'ka' lla sabda', llana' chombaaṉ beṉ' Israelka'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na' bibangakile' ka chli' chsedi Jesúza', ḻa' bli' bsedile' ḻegake' ḻega beṉ' nap yeḻ' wṉabia'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na' gana' chdop chllaggake', len to beṉ' yoo dii x̱iwaa na' bgosyaan ḻe' zillj wal, chi'e: ");
INSERT INTO zadNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Jwayi neto', Jesús, beṉ' Nazaret! ¿Abido' kwenc̱he wlliayoo neton'? Nad' nombi'a li', na' ṉezid' nako' ḻiizelozi beṉ' ḻi beṉ' shao' c̱he Chios. ");
INSERT INTO zadNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Na'ch bsheshlen Jesúza' dii x̱iwaa, golle'n: ―¡Llizə wzoa! ¡Bichej! Na' chwiate beṉ'ka' bchix̱ btoḻ dii x̱iwaa beena', na' bichejan na' bikzə gayile' bi goki. ");
INSERT INTO zadNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na' yog' beṉ'ka' lle' na' bibangakile', na' che' ljwellgake': ―¿Naktekan nak cho'a xtill' beeni, lla? Ka chṉeze' chillesh dii x̱iw'ka' yoo beṉ' daa napchgue' yeḻ' wṉabia' na' yeḻ' wak. ");
INSERT INTO zadNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na' doxen na' wze dill' ka nak daa chon Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na' biza' Jesúza' gana' chdop chllaggake' na' biyaje' lill Simónna'. Na' tobiiṉ c̱he Simónna' bi shawee, yoochgue' dii ḻana', na' wṉabgakile' Jesúza' gaklene'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Na'ch wbig' Jesúza' kwite'na' gana' die' na' bsheshlene' dii ḻana' na' bichejan. Na' lii biyaste noola' wzoloe' bene' dii weej wdaogake'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na' ka ba chxoa wbilla', beṉ'ka' lle' na' jwa'gake' lao Jesúza' beṉ'ka' chak wde wdeli yillwe'. Na' bx̱oa neena' to togake' na' biyakgakile'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Na' bibeje' dii x̱iwaa yoo beṉ' zan, na' ka bichejgakan chosyaagakan zillj inlleb, che'gakan: ―Lin' nako' Xiiṉ Chioza'. Na'ch bsheshlen Jesúza' ḻegakan. Bi bi'e latj iṉegakan ḻa' ṉezgakin ḻen' nake' Crístona', beena' chbez beṉ' Israelka' wseḻ' Chioza' iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ka wyeeni', bchej Jesúza' yella' na' wyaje' ga kono lle'. Per beṉ' yellka' biyiljgake'ne', na' ka bllingake' kwite'na', goklall'gake' wzag'gake'ne' kwenc̱he yigaaṉlene' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Na'ch goll Jesúza' ḻegake': ―Ḻekzka' chiyaḻ' c̱hix̱je'id' beṉ'ka' lle' yell yoblə ka nak yeḻ' wṉabia' c̱he Chioza', ḻa' daan bseḻee nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na' wda Jesúza' wdix̱ji'e cho'a xtill' Chioza' to to gana' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","To shii bllin Jesúza' cho'a nisdo' c̱he Genesareta' na' bllin beṉ' zan wal ax̱t bdakwyillgake'ne', daa cheengakile' wzenaggake' cho'a xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na' ble'i Jesúza' c̱hop barkw chi'gakan cho'a nisdo'na'. Ba bichej beṉ' wxen beḻka' na' ba chiyibgake' yix̱j c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Na'ch wyoo Jesúza' ḻoo barkw c̱he Simónna', na' wṉabile'ne' wllig' zilateen ḻoo nisdo'na'. Na' wche' Jesúza' ḻoo barkwa' na' wzoloe' bli' bsedile' beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Na' ka biyoll bli' bsedile' ḻegake', na'ch chi'e Simónna': ―Wyajlen barkwi gana' zitj na' wzaḻ'le yix̱j c̱helena' kwenc̱he senle beḻka'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Na'ch che' Simónna': ―Maestro, do yel ba bennto' llinna' na' ni tlish'b bi bdoḻinto', per shi kan' no', wzaḻ'chnto' yix̱jki. ");
INSERT INTO zadNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na' ka bzaḻ'gake' yix̱j c̱he'ka', wxenan beḻ zan inlleb. Na' ka nan yibejgake' yix̱ja' wzolo chcheza'n. ");
INSERT INTO zadNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Na' blaa neeka' beṉ'ka' lle' ḻoo barkwa' sto kwenc̱he jaklengake' ḻegake'. Na' ka bllin beṉ'ka', na'ch bissha'chagake' c̱hopte barkwka' ax̱t ba chakgakan ka dii kwe' yel. ");
INSERT INTO zadNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ka ble'i Simón Pédrona' ka gok, bc̱hek' xibe'na' lao Jesúza' na' chi'ene': ―Bikwasgach kwitii X̱an', ḻa' beṉ' saaxyaz nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Golle'ne' ka' daa bibanile', na' ka'kzə beṉ'ka' lene' bibangakile' daa bdoḻ' beḻ zan inlleb. ");
INSERT INTO zadNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Na' ḻekzka' bibani Jacóbona' len Juanna' xiiṉ Zebedewa', ḻa' lengaken' nakgake' txen Simónna'. Na' che' Jesúza' Simónna': ―Bi illebo'. Kon ka chono' ṉaa chbejo' beḻki ḻoo nisi, ka'kzan gono' yibejo' beṉ' lao dii mala'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Na' ka billinlengake' barkwka' cho'a nisdo'na', na'zə bkwaaṉgake'n len xshinḻaze'ka' na'ch janogake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Na' shlak zoa Jesúza' to yell, bllin to beṉ' lawe'na' chak doxen kwerp c̱he'na' yillwe' daa le lepra. Na' ka ble'ile' Jesúza', bc̱hek' xibe'na' lawe'na' na' bc̱hek' yic̱hje'na' ax̱t lo yona' na' got'yoile'ne', chi'ene': ―X̱an', ṉezid' wak yikwaso' yillwe'ni chak' shi cheenilo'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Na'ch Jesúza' bx̱oa neena' yic̱hj beena', na' chi'ene': ―Cheenid'x. Na' ṉaate yikwasa'n. Na' kon ka golle' ka' lii biyakteyi beena'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Na'ch che' Jesúza'ne': ―Kono yoo ka ba ben' c̱ho'. Ḻete wyaj lao bx̱oza' kwenc̱he ile'ile' ba biyakilo', na' jwa' daa chiyaḻ' lljoo c̱he Chioza' daa nllia dii Moiséza' bia' kwenc̱he iṉezi beṉ' ba biyakilo'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Na' ḻa'kzi golle'ne' ka', zizikchli wzeyi c̱he', na' beṉ' zan bdop bllaggake' kwenc̱he bzenaggake' cho'a xtilleena' na' kwenc̱he biyone' bittezə yillwe' dii chakgake'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Per Jesúza' yooloe' chaje' ga kono beṉ' chak kwenc̱he chjeḻwille' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","To lla ka chli' chsedi Jesúza', x̱oṉj fariseoka' na' beṉ'ka' chli' chsedi leya', na' beṉ'ka' za' yog' yellka' daa mbani Galileana' na'ch daa mbani Judeana' na' ḻekzka' beṉ' za' yell Jerusalénna', chi'gake' chzenaggake' dill' daa cho'e. Na' yeḻ' wak c̱he Chioza' wzoalenan Jesúza' kwenc̱he gok biyone' beṉ'ka' bi shao'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na'ch bllin to c̱hop beṉ' nḻengake' to beṉ' net ṉi'a neena' nx̱oagake'ne' to lo daa. Goklall'gake' sho'lengake'ne' ḻoo yoona' kwenc̱he lljwa'gake'ne' lao Jesúza', ");
INSERT INTO zadNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","per bi gok sho'lengake'ne' daa nyichachga beṉ'ka' ḻoo yoona'. Na'ch wyepgake' koll' yoona'lə na' bkwasgake' dexka' kwenc̱he gok bḻetjgake'ne' do daa c̱he'na' ladj beṉ'ka' lle' na' kwenc̱he blline' lao Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Na' ble'i Jesúza' ḻe nx̱enilall'gake'ne', na'ch chi'e beṉ' we'na': ―Bish'dawaa, ba biyakxen saaxya c̱ho'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Na'ch beṉ'ka' chli' chsedi leya' na' fariseoka' wza'lall'gake', chakgakile': “¿Nora beeni chonz kwine' ka Chioza'? ¡Ḻa' toz Chiozan' chak chizi'xene' saaxya c̱he beṉ'!” ");
INSERT INTO zadNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Na' gokbe'i Jesúza' daa wza'lall'gake', na'ch golle' ḻegake': ―¿Berac̱he chza'lall'zle ka'? ");
INSERT INTO zadNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Achakile chyalljchid' yeḻ' wak xench yep' beeni: “Ba bizi'xen' saaxya c̱ho'na'”, ka daa yepee: “Biyas na' bigoo nez”? ");
INSERT INTO zadNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Na' wliid' le', nad', Beṉ' Bseḻ' Chioza', nap' yeḻ' wṉabia' yell-lioni kwenc̱he yizi'xen' saaxya c̱he beṉ'. Na'ch golle' beena' net ṉi'a neena': ―Ṉaa nia' li', biyas, bitob daa c̱ho'na' na' biyaj lillo'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na' lii biyaste beena' chwiate beṉ'ka' lle' na', bitobe' daa c̱he'na' bizee ziyaje' lill-le' choe'lawee Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na' yog'ḻoḻ beṉ'ka' bibangakile' na' be'la'ogake' Chioza', na' do chllebzgake' che'gake': ―Ṉaanlla ba ble'icho dga chonan ka chibanicho. ");
INSERT INTO zadNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ka biza' Jesúza', na' ble'ile' to beṉ' wic̱hixj lie' Leví, chi'e gana' chc̱hixjgake'. Na' chi'ene': ―Da, dino nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Na'ch lii wzolla'te Levína', wlej yic̱hje' xshine'na' na' janoe' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na' Levína' bene' to lṉi xen c̱he Jesúza' lille'na'. Na' wyaj beṉ' zan beṉ' wic̱hixjka' na' zi baḻ beṉ' yoblə wdaogake' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Na' fariseoka' na' beṉ'ka' chli' chsedi leya' wzologake' chakdiḻ-lengake' beṉ'ka' nak Jesúza' txen, che'gake': ―¿Berac̱he cheej chaolenle beṉ' wic̱hixjka' na' beṉ' malka'? ");
INSERT INTO zadNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Na'ch che' Jesúza' ḻegake': ―Beena' zoa shi'a shao' aga no wen rmech chyalljile', san beena' bi shawaan chyalljile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aga bid' ni c̱he beṉ'ka' nak beṉ' ḻi beṉ' shao', san bid' kwenc̱he yep' beṉ' saaxyaka' chiyaḻ' yiyaj yilengakile'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Na' wṉabgakile' Jesúza', che'gake'ne': ―Beṉ'ka' nak Juanna' txen na' beṉ'ka' nak fariseoka' txen zekizezi chzoagake' wbas' na' choe'ḻwillgake' Chioza'. Na' ¿berac̱he beṉ'ki nakgake' li' txen bi chzoagake' wbas'? ");
INSERT INTO zadNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Na' chi'e ḻegake': ―Kat' de to yeḻ' wishagna', aga wak gonle byen beṉ'ka' chdop chllag soagake' wbasaa shlak zoalengake' bi'na' chshagna'. Na' ka'kzan beṉ'ki nakgake' nad' txen, cheej chaogake' ṉaa zoalen' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Per wllin lla wkwas beṉ' nad' ladje'ka', kana'chan soagake' wbasaa. ");
INSERT INTO zadNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Na' ḻekzka' bzoe' sto jempl, chi'e ḻegake': ―Ni to beṉ' bi chc̱hogue' xa kobe'na' na' chideen ḻee xe' dii gola'. Ḻa' shi gone'n ka', na' wlliayee dii koba', na' dii gola' aga wṉelebin lech' koba'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na' ni kono chgaa vinona' daa zi' chchejte to ḻoo yid golə. Ḻa' shi no gon ka', vino koba' wc̱hezaan yid gola' na' c̱hopten kwiayi'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","San vino koba' chiyaḻ' shollan ḻoo yid koba'. ");
INSERT INTO zadNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na' ḻekzka' to beṉ' ba yooloe' cheeje' vino gola' aga weenile' yeeje' dii koba', daa chziachile' dii gola'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","To lla sabd, llana' chombaaṉ beṉ' Israelka', wdelen Jesúza' beṉ'ka' nakgake'ne' txen to ga naz beṉ' trígona', na' beṉ'ka' zejlengake'ne' wzolo wdishjgake' trígona' na' wxobgake'n wdaogake'n. ");
INSERT INTO zadNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Na' baḻ fariseoka' gollgake' ḻegake': ―¿Bic̱he chonzle daa bi chiyaḻ' goncho llani chombaaṉcho? ");
INSERT INTO zadNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Na'ch che' Jesúza' ḻegake': ―¿Abiṉ' wlable gana' cho'en dill' ka ben dii Davina' len beṉ'ka' nakgake'ne' txen ka wdongake'? ");
INSERT INTO zadNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wyo'e ḻoo lill xḻatj Chioza' na' wdoyoe' yetxtilka' daa naki c̱he Chioza' daa toz bx̱ozka' de lsens gaogake'. Na' ḻekzka' bi'en beṉ'ka' nakgake'ne' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na' ḻekzka' chi'e fariseoka': ―Nad', Beṉ' Bseḻ' Chioza' Yell-lioni, chṉabi'a lao llani chombaaṉcho. ");
INSERT INTO zadNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na' sto lla sabd, llana' chombaaṉ beṉ' Israelka', wyaj Jesúza' gana' chdop chllaggake' choe'ḻwillgake' Chioza' na' wzoloe' chli' chsedile' ḻegake'. Na' ladj beṉ'ka' len to beṉ' net nee de shḻina'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na' fariseoka' na' beṉ'ka' chli' chsedi leya' lle'gake' chwiayeṉ'gake' shi wiyon Jesúza' beena' llana' chombaaṉgake', kwenc̱he gaogake' xya c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Na' gokbe'i Jesúza' daa chza'lall'gake', na'ch golle' beena' net tḻaa neena': ―Wzolla' na' wze gchoḻa'. Na'ch wzolla' beena', wzie' gchoḻa'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Na'ch goll Jesúza' beṉ'ka': ―Ni iṉabid' le': ¿Beran na leya' chiyaḻ' goncho lla sabdka'? ¿Agoncho dii wenna' anti goncho dii mala'? ¿Ayislacho beṉ' anti witchone'? ");
INSERT INTO zadNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Na'ch bwia Jesúza' ḻegake', na' chi'e beena' net tḻaa neena': ―Bḻi noona'. Na'ch bḻi neena' na' biyakin. ");
INSERT INTO zadNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Na' fariseoka' na' beṉ'ka' chli' chsedi leya' ḻe bllaagake' na' choe'gake' dill' nak ka gongake' c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na' wyaj Jesúza' to lo yaa kwenc̱he jeḻwille' Chioza', na' do yel be'ḻwille'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ka wyeeni', goxe' beṉ'ka' nakgake'ne' txen na' ladj beṉ'ka' wleje' beṉ'ki shlliṉ na' bsi'e ḻegake' postl: ");
INSERT INTO zadNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simónna' beena' bsi'e Pedro, len beṉ' bishee Andréza', na' Jacóbona', Juanna', Felípena', Bartoloména', ");
INSERT INTO zadNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matewa', Tomáza', Jacobo xiiṉ Alfewa', Simónna', beena' bsi'gake' Zelote, ");
INSERT INTO zadNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, beṉ' bish' Jacóbona' na' Jud Scariota', beena' bene' Jesúza' lo na' beṉ' malka'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Na'ch biyetjlen Jesúza' ḻegake' lo yaana' na' billingake' to ga nak lesh'. Na' na' lle' beṉ' zan inlleb, beṉ' zaak doxen gana' mbani Judeana' na' yell Jerusalénna', na' beṉ' zaak cho'a nisdo'na' gana' mbani yell Tírona' na' yell Sidónna'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wyajgake' kwit Jesúza' kwenc̱he wzenaggake' xtilleena' na' yiyakgakile' bi yillwe' dii chakgake'. Na' ḻekzka' biyaki beṉ'ka' chsak'zi' dii x̱iw'ka' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yog'z beṉ' goklall'gake' idi'gake' Jesúza' daa ba ṉezgakile' chchej yeḻ' wak c̱he'na' na' chiyaki yog' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Na'ch bwia Jesúza' beṉ'ka' nakgake'ne' txen, na' chi'e ḻegake': ―Chakomba le' nakle beṉ' yesh' daa chleble yeḻ' wṉabia' c̱he Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Chakomba le' chbiḻ chdonle ṉaa; wllin lla yesh yeljile. ’Chakomba le' chbell-le ṉaa; wllin lla yixill-le. ");
INSERT INTO zadNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Chakomba le' shi chakzbani beṉ' le', shi bi chongake' le' txen, shi biya dii nagake' le', na' shi chongakile' le' nakzi ka chongakile' to beṉ' wen dii mal ni c̱ha', nad', Beṉ' Bseḻ' Chioza' Yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ḻi yibayi, na' ḻi soa mbalaz kat' ba chongakile' le' ka', ḻa' yabana' gaple to dii wen dii shao'. Ḻa' ka'kzə beni dii x̱ozxtoe'ka' beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yi. ");
INSERT INTO zadNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Nyesh'laz gak c̱hele, le' nakle beṉ' wni'a, ḻa'kzi ḻe wen chak c̱hele ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Nyesh'laz gak c̱hele, le' de dii cheej chaole ṉaa, ḻa' wllin lla ibiḻ idonle. ’Nyesh'laz gak c̱hele, le' chyitj chxill-le ṉaa; wllin lla kwellyesh'le. ");
INSERT INTO zadNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Nyesh'laz gak c̱hele, le' choe'la'o yog' beṉ' le', ḻa' ka'kzə be'la'o dii x̱ozxto'leka' dii beṉ'ka' benzə ka chyix̱jee daa che' Chioza' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Le' chzenagle ṉaa, nia' le', ḻi gaki beṉ'ka' chakzbani le'. Ḻi gonigake' wen. ");
INSERT INTO zadNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ḻi iṉabi Chioza' gone' ka gak wen c̱he beṉ'ka' chyishj bia' blag' c̱hele. Ḻi iṉabi Chioza' gaklene' beṉ'ka' chiya dii nagake' c̱hele. ");
INSERT INTO zadNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Shi no kap' x̱ag'lena' tḻaa, ḻi wze daa zi shḻaa. Na' shi no koyo xachel-lena', ḻi we'tega len xkamislena'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nottezə beṉ' shi bi iṉabe' c̱hele, ḻi we'n. Na' ka', shi no ikaa bi de c̱hele, bi yiṉabzilene'n. ");
INSERT INTO zadNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ḻi goni beṉ' kon ka cheenile gongakile' le'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Shi to beṉ'ka' nllagzile chakile, ¿garan de dii wenna' daa chonle? Ḻa' ka'klen chon beṉ' saaxyaka'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ḻekzka' shi to beṉ'ka' chonzi le' wen chiyonile wen, ¿garan de dii wenna' chonle? Ḻa' ka'klen chon beṉ' saaxyaka'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na' shi choe'le bi choe'le beṉ' daa ṉezile yigwee wzonna', ¿garan de dii wenna' daa chonle? Ḻa' ka'klen chon beṉ' ssaxyaka', choe'gake' bi choe'gake' daa nongake' lez wigoogake' wzon c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Na' le', ṉaalla, chiyaḻ' gakile beṉ'ka' chakzbani le', na' gonle wen c̱hegake'. Na' shi we'le dii we'le ḻegake', bi gonle lez yiyoṉgake'n. Shi ka' gonle, Chioza' yiyoṉe' dii xench c̱hele, na' iṉezi beṉ' nakle xiiṉ Chios, beena' nak beṉ' choo beṉ' xen, ḻa' ḻe' chone' wen c̱he beṉ'ka' bi choe' ḻe' yeḻ' chox̱ken na' beṉ' wen dii malka'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Chiyaḻ' yiyeshii ljwell-le ka chiyeshii X̱acho Chioza' yog' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Bi wwia wyile bi chon beṉ', kwenc̱he bi gon Chioza' xya c̱hele. Bibi wtobile' beṉ', kwenc̱he bi gaple doḻ' lao Chioza'. Ḻi si'xen c̱he ljwell-le, na' Chioza' si'xene' c̱hele. ");
INSERT INTO zadNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ḻi we' beṉ' bi chyalljile' na' Chioza' yiyoṉe'n. Na' yiyoṉchle' dii xench, ka chon beṉ' chzanile' do yic̱hj do lallee kat' bi wi'e, chzoayaa chzoalline'n. Ḻa' kon ka chonle chzanile' we'le beṉ' bi de c̱hele, ka'kzan goni Chioza' le'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Na' bzoa Jesúza' to jempl, chi'e ḻegake': ―Ṉezicho bi gak to beṉ' lc̱hoḻ wc̱hi'e sto beṉ' lc̱hoḻ, ḻa' c̱hoptegake' lljabix̱gake' to ḻoo yech. ");
INSERT INTO zadNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Na' beena' chsed bi gak iṉe': “Chonch' ka beena' chli' chsedile' nad'.” Kat'ch yiyoll yido wsede', kana'chan gake' ka beena' bli' bsedile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Bic̱he chwiazo' bic̱ha' yoo ḻoo jalao bish' ljwello'na' na' bi chile'ilo' kwagaa yoo ḻoo jalawo'na'? ");
INSERT INTO zadNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Shi bi chle'ilo' kwagaa yoo ḻoo jalawo'na', ¿nakra gono' yoo bish' ljwello'na': “Beṉshki yibej' bic̱ha' yoo ḻoo jalawo'na'”? ¡Beṉ' wxiye'! Zigaate bwia c̱ho'na' na' tech wwio' c̱he' bish' ljwello'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Biga zoa to yag wen na' kwiazan dii bi nak wen, ni biga zoa to yag dii bi nak wen kwiazan dii nak wen. ");
INSERT INTO zadNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ka ile'icho daa chbia to yag, na' chṉezicho bi yag daa. Yag yeshaa aga wbian yix̱wewa', na' ḻekzka' yag bisgaana' aga wbian uvana'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ka'kzan beena' nak beṉ' wen, choe' dill' wen, ḻa' ḻoo yic̱hjlall'do'enan' yoo dii wenna'. Na' beena' nak beṉ' mal, cho'e dill' dii nak mal, ḻa' ḻoo yic̱hjlall'do'enan' yoo dii mala', ḻa' yog' daa chṉecho chchejan ḻoo yic̱hjlall'do'chona'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Berac̱he nazle nad' “X̱an', X̱an'”, na' bi chonle daa nia' le'? ");
INSERT INTO zadNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ni iṉia' le' no zaklebi beena' chone' nad' txen na' chzenague' c̱ha' na' chone' ka nia'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Zaklebile' beena' ben to yoo. Zigaate wdene' zitj wal na' wleke' leninna' lo yaja'. Ka wde yawa' na' wyoon ḻe'inna', aga bizoyin yisheen daa, ḻa' chi'cha leninna' lo yaja'. ");
INSERT INTO zadNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Na' beena' cheni cho'a xtillaana' na' bi chone' ka nia', zaklebile' beena' ben lille'na' lo yona' na' bibi lenin wleke'. Na' ka wde yawa' wyoon ḻe'inna', lii billeeten na' wlliayi'tekkzan. ");
INSERT INTO zadNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ka biyoll be'len Jesúza' beṉ'ka' dill', biyaje' Capernaúma'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na' yella' zoa to beṉ' Roma beṉ' chṉabi'e to guiyoa soldad, na' zoa to xmose' lille'na', beena' ḻe chakile', na' chake' to yillwe' dii chonan ka witan ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Na' ka beni x̱an soldadka' choe'gake' xtill' Jesúza', na'ch bseḻee baḻ beṉ' golka' chṉabia' Israela' kwenc̱he lljet'yogakile'ne' lljayene' beena' bi shao'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Na' ka bllin beṉ' golka' kwit Jesúza', got'yogakile'ne', che'gake': ―X̱an soldadka' chidoḻee gakleno'ne', ");
INSERT INTO zadNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ḻa' ḻe chakile' cho' beṉ' Israel na' ḻen' bene' yoona' gana' chdi'anto' choe'ḻwillnto' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Na'ch wyajlen Jesúza' ḻegake'. Na' ka ba zoa yillingake' lille'na', x̱an soldadka' bseḻee baḻ beṉ' nllaguile' kwenc̱he jellgake' Jesúza' dill'ki: ―X̱an', bi sio' wṉeyi yido', ḻa' bi chidoḻaa shoo ḻoo lillii. ");
INSERT INTO zadNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Daan bi biyaxjid' yid' kwin' yidtiḻ' li'. Ḻa'c̱h' to c̱hop cho'a dill' sheḻ' iṉo' na' yiyakile'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ḻa' zoa no chṉabia' nad', na' ḻekzka' chṉabi'a soldad c̱ha'ka'. Na' kat' chep' toe': “Wyaj ni”, na' chaje'. Na' kat' chep' stoe': “Da ni”, na' chide'. Na' kat' chep' xmosaa: “Ben dga”, na' chone'n. ");
INSERT INTO zadNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Na' ka beni Jesúza' xtill' beena' na' bibanile', na' biyec̱hje' bwie' beṉ'ka' zjanogake'ne', na' chi'e ḻegake': ―Dii ḻi, ni to beṉ' Israel biṉ' illag' beṉ' gonḻilall'ḻikze' nad' ka chonḻilall' beeni nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na'ch ziyaj beṉ'ka' bseḻ' x̱an soldadka', na' ka billingake' lille'na' ble'gakile' ba biyaki xmose'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ka wde, na' wyaj Jesúza' sto yell dii le Naín kon beṉ'ka' nakgake'ne' txen na' lench zan beṉ' yoblə. ");
INSERT INTO zadNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Na' ka bllingake' cho'a yella', ble'gakile' zjakwash' beṉ'ka' to bi' wet. Na' bi'na' wit nakb' bi' tlish', na' xṉa'baa nake' noolə wizeb. Na' beṉ' zan beṉ' yellka' zjakwash'gake'b'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na' ka ble'i X̱ancho Jesúza' noola', na' biyeshile'ne', chi'ene': ―Bi kwello'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Na'ch jabiguee bex̱ee gana' xoa bi' weta', na' wlez beṉ'ka' nḻengake'b'. Na' golle' bi' weta': ―Bi' xkwid', nia' li', ¡biyas! ");
INSERT INTO zadNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na' bi' weta' lii bibanteb' na' bibe'b' na' wzolo chiṉeb', na' biyon Jesúza'b' lo na' xṉa'baa. ");
INSERT INTO zadNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na' ka ble'i beṉ'ka' daa bene', yog'ḻoḻze' blleb na' wzologake' choe'la'ogake' Chioza', nagake': ―Ladjchoni ba bla' to beṉ' zakii beṉ' chyix̱jee daa che' Chioza'ne'. Na' ḻekzka' nagake': ―Chiozan' ba blee kwenc̱he gaklene' cho' nakcho yell c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Na' doxen gana' mbani Judeana' na' yellka' llia gaozə wṉezgakile' daa ben Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na' beṉ'ka' nongake' Juanna' txen jayellgake'ne' yog' diika' chon Jesúza'. Na'ch Juanna' wṉie' c̱hope' ");
INSERT INTO zadNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na' bseḻee ḻegake' gana' zoa Jesúza' kwenc̱he jaṉabgakile'ne' shi ḻeyeṉ'en' beena' llia bia' yid wa shi chiyaḻ' kwezgake' sto beṉ' yoblə. ");
INSERT INTO zadNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Na' ka bllin beṉ'ka' bseḻ' Juanna' kwit Jesúza', che'gake'ne': ―Juanna', beena' chchoa beṉ' nisa', bseḻee neto' kwenc̱he zidṉabinto' li' shi li'yeṉ'kzan nako' Crístona', beena' chbeznto' wseḻ' Chioza' kwenc̱he iṉabi'e, wa shi chiyaḻ' kweznto' stoe'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na' shlak zegake' na', biyon Jesúza' beṉ' zan beṉ' chak yillwe', na' ḻekzka' bibeje' dii x̱iw'ka' yoo beṉ', na' bene' ka ble'i beṉ' zan beṉ' lc̱hoḻka'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Na'ch che' Jesúza' beṉ'ka' bseḻ' Juanna': ―Ḻi yiyaj na' ḻi lljayell Juanna' daa ba ben ble'ile. Ḻi lljayelle' beṉ' lc̱hoḻka' chle'gakile', na' beṉ'ka' bi chak sa' chza'gake', na' beṉ'ka' chak yillwe'na' daa le lepra chiyakgakile', na' beṉ' kwellka' chengakile', na' chiban beṉ' wetka', na' chyix̱je'id' beṉ' yesh'ka' dill' wen dill' kob c̱he Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Chakomba beena' chajḻe' c̱ha' na' bi chakc̱hoplallee. ");
INSERT INTO zadNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Na' ka biza' beṉ'ka' bseḻ' Juanna', Jesúza' bi'e xtill' Juanna' lao beṉ'ka' lle' na', chi'e: ―¿Nakra nak beena' jawiale latja' gana' bibi chashj chḻeb? ¿Anake' to beṉ' chakc̱hoplallii c̱he dill'ka' cho'e? ");
INSERT INTO zadNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Na' shi bi nake' ka', ¿nakran nak beena' jawiale, shka'? ¿Ato beṉ' nakwe' lech' dii zakii? Ḻa' ṉezkzile beṉ'ka' nakw lech' dii zakii, na' naptegake' bittezə dii chzelall'gake', zoagake' lill beṉ' wṉabia'ka', aga zoagake' latja' gana' bibi chashj chḻeb. ");
INSERT INTO zadNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Na' ¿nakran nak beena' jawiale, shka'? ¿Ato beṉ' chyix̱jee daa che' Chioza'ne'? Dii ḻi kan' chone', na' chontechle' ka to beṉ' chyix̱jee daa che' Chioza'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ḻa' c̱he beenin cho'e Cho'a Xtill' Chioza' dill' gana' nan: Wseḻaa beena' kwialo lawo'na', na' c̱hix̱ji'e xtilloona' kwenc̱he soa beṉ' wzenaggake' c̱ho' kat' illino'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na' nia' le', lao yog'ḻoḻte beṉ' yell-lioni, ni to konoṉ' ichej beṉ' zak'teche' ka Juanna'. Per nottezə beena' choe' latj iṉabia' Chioza' ḻoo yic̱hjlall'do'ena', zak'teche' ka Juanna'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na' yog'ḻoḻ beṉ'ka' bchoa Juanna' nisa', no beṉ' wic̱hixjka' na' zan beṉ' yoblə, ka bengakile' daa wna Jesúza', gokbe'gakile' dill' ḻi dill' shao' nak cho'a xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Na' fariseoka' na' beṉ'ka' chli' chsedi leya' bi goongakile' wchoa Juanna' ḻegake' nisa', ni bi goklall'gake' gon Chioza' dii wenna' cheenile' gone' c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Na'ch goll X̱ancho Jesúza' ḻegake': ―¿Bi ka wsaklebid' le' mbanle ṉaa? ¿No ka iṉia' nakle? ");
INSERT INTO zadNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nakle ka bi'do'ka' chbe' gana' chak yaana' na' chosyaagakb' che' ljwellb': “Bkwellnto' blleja' na' bi byaale, na' beḻnto' dii chon nyesh', na' ni bi wchell-le.” ");
INSERT INTO zadNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ḻa' bid Juan wichoa nisa', na' bi chawe' yetxtil ni bi cheeje' vino, na' nale c̱he': “Dii x̱iwaan yo'e.” ");
INSERT INTO zadNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Na'ch bid' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, na' chle'ile cheej chaw', na' nale c̱ha': “Ḻe beṉ' waox̱at nak beeni na' cheejtie', na' nllagteile' beṉ' saaxyaka' na' beṉ' wic̱hixjka'.” ");
INSERT INTO zadNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Per yeḻ' sin' c̱he Chioza' chli'lawin ka nsa' c̱he beṉ'ka' chzenaggake' c̱heyin. ");
INSERT INTO zadNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","To fariseo wṉie' Jesúza' kwenc̱he gaogake' lille'na'. Ka blline' na' wchi'e cho'a mesa'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na' to noolə wda zoa yella', ka wṉezile' zjtao Jesúza' lill farisewa', na'ch wyaje' nox̱ee to lmet de yaj xochi na' yollan set zix̱. ");
INSERT INTO zadNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","De chbellzile' jabiguee xṉi'a Jesúza' na' bisbisile' ṉi'ena' nis xc̱hell c̱he'na'. Na' bisbillile'n yish' yic̱hje'na', na' bnope'n na' bwazje'n set zix̱a'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Na' farisewa', beena' wṉie' Jesúza' lille'na', ka ble'ile' ka chon noola', na' gokile': “Sheḻ'ka' dii ḻi nak beeni to beṉ' chyix̱jee daa che' Chioza'ne', wakbe'ile' nan nooli chox̱' ṉi'ena' nake' beṉ' saaxya.” ");
INSERT INTO zadNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Na'ch che' Jesúza' farisewa': ―Simón, de to dii cheenid' iṉia' li'. Na' che' Simónna': ―Wna, Maestro. ");
INSERT INTO zadNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Na'ch che' Jesúza': ―C̱hop beṉ' chbag'gake' mech c̱he to beṉ' chon yic̱hjin. Toe' chbaguee gay' guiyoa mech plat, na' stoe' chbaguee shiyonan. ");
INSERT INTO zadNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Na' ni toe' bi bllelgakile'n yiyixjgake'n. Na'ch x̱an mecha' benxenlallee daa chaḻ'gake' c̱he'. Wnashki nad', ¿no beṉ'ka' c̱hop gakchile'ne'? ");
INSERT INTO zadNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Na'ch che' Simónna': ―Chakid' beena' chbag' dii xench. Na' che' Jesúza'ne': ―Lekzilo', kan' nakan. ");
INSERT INTO zadNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Na'ch bwia Jesúza' noola' na' chi'e Simónna': ―Bwiakachi nooli. Ka wyo'a ḻoo lillo'ni bi beṉo' nisa' kwenc̱he c̱hib ṉi'ani, per nooli ba wdibile' nis xc̱hell c̱he'na' ṉi'ani na' bisbillile'n yish' yic̱hje'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Bi bnopo' nad', per nooli kon ka wyo'a chnoptezi chnope' ṉi'ani. ");
INSERT INTO zadNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Bi wdebo' yic̱hjii set, per nooli ba bwazje' set zix̱a' ṉi'ani. ");
INSERT INTO zadNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Daan nia' li', ḻa'kzi dii zan saaxya ba ben nooli, ba biyakxengakan daa ḻe chakchgaile' nad'. Na' beena' lat'zə biyakxen c̱he', ḻekzka' lat'chga chakile' nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Na'ch golle' noola': ―Ba biyakxen saaxya c̱ho'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Na' beṉ'ka' chi'lengake' Jesúza' txen wzologake' che' ljwellgake': ―¿Nora beeni, lla, ax̱t saaxyaka' chizi'xene'? ");
INSERT INTO zadNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Na' Jesúza' chi'e noola': ―Daa chonḻilalloo nad', ba bilo' lao yeḻ' zak'zi'na'. Biyaj mbalaz. ");
INSERT INTO zadNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ka wde dga, wda Jesúza' zan yell xen na' zan yelldo', chyix̱ji'e dill' koba' nan Chioza' chṉabi'e ḻoo yic̱hjlall'do' beṉ'ka' chzenag c̱he'. Na' postl c̱he'ka' shlliṉ chdalengake'ne' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Na' ḻekzka' len baḻ noolka' ba biyone'. Baḻe' bibeje' dii x̱iw'ka' wyoogake', na' zi baḻe' gokgake' yillwe' na' biyone' ḻegake'. Na' ladje'ka' len Maríana', noola' nsi'gake' Magdalena, beena' bibej Jesúza' gall dii x̱iw'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Na' ḻekzka' len noola' le Juana, xool Chúzana', beena' ngoo lo nee chap chwie' lill Heródeza'. Na' len Susánana', na' zanch noolka' beṉ'ka' jano Jesúza' na' bc̱hingake' dii de c̱hegake' kwenc̱he goklengake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Beṉ' zan bllesh to to yell jawiagake' Jesúza', na' ka bdop beṉ' zan wal na'ch bseesile' ḻegake' to jempl, chi'e: ");
INSERT INTO zadNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―To beṉ' goz gooṉ wzee zeje' goza'. Na' ka zej chzaḻee biṉna', baḻan bxop cho'a neza' na' blej bshoshj beṉ' ḻen, na' bllin byiṉka' wdaogakban. ");
INSERT INTO zadNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Na' zi baḻan bxop ladj yajka' gana' bitek chi' yona', na' ka bla'gakan to wbillzgakan, ḻa' aga bi gop' de gana' bxopan. ");
INSERT INTO zadNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Na' zi baḻan bxop ladj yag yesh'ka', na' ka bla'gakan aga be' yag yesh'ka' latj igolgakan. ");
INSERT INTO zadNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na' zi baḻan bxop lo yo wenna', na' ḻe bgolgakan na' ax̱t do to guiyoa wej wllia to ton. Na' ka biyoll bseesee jempla', na'ch wṉie' zilljə chi'e: ―Le' chenile dga nia', ḻi sen wṉeyi. ");
INSERT INTO zadNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na'ch wṉab beṉ'ka' nakgake'ne' txen bi zejin jempla' daa bseesee. ");
INSERT INTO zadNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Na' che' Jesúza' ḻegake': ―Chioza' cho'e latj iṉezile daa kono ṉezkzi, ka chṉabi'e ḻoo yic̱hjlall'do' beṉ'ka' chzenaggake' c̱he'. Na' beṉ'ka' sto chseesid' ḻegake' shgaḻ' jempl, ḻa' ḻa'kzi chle'gakile' bin chon', kon chongake' ka beṉ' bi chle'i. Na' ḻa'kzi chengakile' bin nia', aga chajni'gakile'n. ");
INSERT INTO zadNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Kin zeji jempl c̱he beṉ goz gooṉa': cho'a xtill' Chioza' nakan ka biṉna' daa goze'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Na' zoa beṉ' chzenaggake' cho'a xtill' Chioza', na' lii ze'te dii x̱iwaa chikwasan daa kwenc̱he bi shajḻe'gake' na' kwiayi'gake'. Chak c̱hegake' ka gok c̱he biṉna' daa bxop cho'a neza'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na' zoa beṉ' chibagakile' chzenaggake' cho'a xtill' Chioza' na' chlebgake'n, per kat' chak bi chak c̱hegake' na' chbej yic̱hjgake'n. Chak c̱hegake' ka gok c̱he biṉna' bi bde loinna' daa bxopan lo yaja'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na' zoa beṉ' chzenague' cho'a xtill' Chioza', per chi'ch yic̱hjgake' daa chak c̱hegake' na' c̱he yeḻ' wni'ana', na' c̱he bichlə dii chzelall'gake', na' bi chakchagake' lo xṉez Chioza'. Chak c̱hegake' ka gok c̱he biṉna' bxop ladj yag yesh'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na' zoa beṉ' chzenaggake' cho'a xtill' Chioza' do yic̱hj do lall'gake' na' chongake' ka nan, na' chzo chzakgakile' bittezə dii chak c̱hegake'. Beṉ'kin chak c̱hegake' ka gok c̱he biṉna' bxop lo yo wenna' daa ḻe wllia. ");
INSERT INTO zadNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Biga zoa to beṉ' chxene' kandila' na' chdose'n to dii wkwashaan daa wa chzoe'n xan xḻague'na', san chzoe'n sibə kwenc̱he ile'i beṉ'ka' sho' ḻoo yoona'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Na' ḻekzka' yog'ḻoḻte dii ngash' ṉaa, wllin lla yila' lawin, na' daa kono ṉezi ṉaa, wllin lla iṉezi beṉaan. ");
INSERT INTO zadNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Ḻi wzenag dga nia' le' ṉaa. Beena' chzenag zizikchli shajni'chile', na' beena' bi chzenag, daa ba bzenague' lat', yog'ḻoḻan yiyaḻ-lallee. ");
INSERT INTO zadNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Na'ch bllin xṉa' Jesúza' len beṉ' bisheeka' gana' zoe', na' bi gok ibig'gake' kwite'na' daa lle' beṉ' zan. ");
INSERT INTO zadNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Na' wbig' to beṉ' golle' Jesúza': ―Xṉoona' len beṉ' bishooka' lle'gake' lesh' chyoona' na' cheengakile' wshaljlengake' li'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Na' goll Jesúza': ―Beṉ'ka' chzenaggake' cho'a xtill' Chioza' na' chongake' ka nan, ḻegaken' nakgake' xṉa' na' beṉ' bishaa. ");
INSERT INTO zadNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","To lla wyoo Jesúza' to ḻoo barkw len beṉ'ka' nakgake'ne' txen na' golle' ḻegake': ―Techo shḻaalə nisdo'ni. Na'ch wza'gake'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Na' shlak ngoo barkwa' nez, wtes Jesúza'. Na'ch wze to be' wal lo nisdo'na' na' wzolo chas chat' nisa' na' biyollan ḻoo barkwa', na' zi lat'zə nan kwe'n yel. ");
INSERT INTO zadNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na' jasbangake' Jesúza', che'gake'ne': ―¡Maestro! ¡Maestro! ¡Ba chbe'cho yel! Na' wyas Jesúza' na' bsheshlene' be'na' len nisdo'na'. Na' wlezgakan, bich bi gok. ");
INSERT INTO zadNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Na'ch golle' ḻegake': ―¿Abi chonḻilall'kzle nad'? Na' ḻegake' ḻe chllebgake' na' ḻe chibangakile' na' che' ljwellgake': ―¿Nora beeni lla?, ax̱t be'na' na' nisdo'na' chzenaggakan c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Na'ch bllingake' yell-lio c̱he beṉ' Gadáraka', daa llia shḻaa nisdo'na' ndiḻ yell-lio c̱he Galileana'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ka bichej Jesúza' ḻoo barkwa' jabig' to beṉ' Gadara kwite'na'. Ba wlla yo'e dii x̱iw'ka', na' bich bi xalaane' nakw, ni bich zoe' lille', san kapsanta' noni lille'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Na' ka ble'ile' Jesúza', besyee na' jac̱hek' xibe' lawe'na', na' zillj inlleb chi'e: ―Jwayiz nad', Jesús Xiiṉ Chios, beṉ' nak ḻiizelozi beṉ' choo beṉ' xen. Ben goklen bi wsak'zi'o nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Gollan ka' daa ba chon Jesúza' byen yichejan. Ba wlla chṉabi'an ḻe' na' ḻa'kzi chc̱hejgake' ṉi'a neena' gdenna', ḻobe' chc̱hogue'n. Na' dii x̱iwaa chtadon ḻe' na' chjsoe' ga kono beṉ' lle'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Na' che' Jesúza': ―¿Bin lio'? Na' chi'e: ―Legiónan lia'. Golle' ka', ḻa' zanannan' yo'e. ");
INSERT INTO zadNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na' got'yogakin Jesúza' bi wseḻeegakan gana' kwiayi'gakan. ");
INSERT INTO zadNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na' gaozə zoa to yaa gana' lle' kush zan chaogakb. Na' dii x̱iw'ka' wzeyidgakan wṉabgakin Jesúza' wi'e latj yiyoogakan kushka', na' bi'e latj. ");
INSERT INTO zadNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na'ch bichej dii x̱iw'ka' yoo beena' na' biyoogakan kushka'. Na' lii goklleshtegakib na' jabix̱gakb to cho'a bdiṉj na' jshoogakb ḻoo nisa' na' witgakb. ");
INSERT INTO zadNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na' beṉ'ka' chap kushka' ka ble'gakile' daa gok, biyajdogake' jazengakile'n beṉ'ka' lle' yella' na' beṉ'ka' lle' lyix̱aa. ");
INSERT INTO zadNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na'ch bllesh beṉ'ka' jawiagake' daa gok. Na' ka bllingake' kwit Jesúza', na' chi' beena' wyoo dii x̱iw'ka' kwite'na'. Ba biyakw xalaane'na' na' ba biyeeṉ biyeeniile'. Na' bllebgake'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na' beṉ'ka' ble'gakile' daa gok, gollgake' beṉ'ka' zi' bllin nakan gok biyaki beena' wyoo dii x̱iw'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Na' yog'ḻoḻ beṉ' Gadáraka' got'yogakile' Jesúza' yizee lalle'ka' daa ḻe chllebgake' ka bene'. Na' biyo'e ḻoo barkwa' ziyaje'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Na' beena' bichej dii x̱iw'ka' got'yoile' Jesúza' wi'e latj shajlene'ne'. Per Jesúza' chi'ene': ");
INSERT INTO zadNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Biyaj lillo'na' na' jaye' dill' ka nak dii wen dii shawaa daa ba ben Chioza' c̱ho'. Na'ch biyaj beena' jayee dill' doxen yella' ka nak dii wen dii shawaa daa ben Jesúza' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ka billin Jesúza' shḻaa nisdo'na', ḻe chiba chizaki beṉ'ka' lle' na', ḻa' yog'zgake'n chbezgake' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na'ch bllin to beṉ' le Jairo, nake' to beṉ'ka' chgoo xṉezi c̱heyi diika' chon beṉ' Israelka' gana' chdop chllaggake' choe'ḻwillgake' Chioza'. Na' bc̱hek' xibe'na' lao Jesúza' na' got'yoile'ne' shaje' lille'na', ");
INSERT INTO zadNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","daa ba chakshwet bi' nool c̱he'na'. Nakb' to bi' tlish' tyaj, na' ka do shlliṉ yizib'. Na' shlak zej Jesúza' beṉ' zan janogake'ne' ax̱t bdakwyillgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na' ladj beṉ'ka' zjano Jesúza' len to noolə ba gok shlliṉ yiz chzoe' wbaana'. Na' ba blliayee yog' dii de c̱he' daa chajtezi chaje' lao beṉ' wen rmechka', na' ni to kono gok yiyon ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Na'ch wbiguee koll' Jesúza' bex̱ee xe'na', na' katena' lii biyakteile'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Na'ch goll Jesúza' beṉ'ka' zjano ḻe': ―¿No beena' ba bex̱' nad'? Na' ni to kono bc̱heb. Na'ch goll Pédrona'ne': ―Maestro, beṉ'kin chdakwyillgake' li' na' chllig'gake' li' to ki to ka'lə. ¿Bic̱he nazo': “Non ba bex̱' nad'”? ");
INSERT INTO zadNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Na' che' Jesúza' ḻegake': ―Nochodan' ba bex̱' nad', ḻa' gokbe'teid' bchej yeḻ' wak c̱ha'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na' noola', ka gokbe'ile' aga wak wkwashee, do chllebze' jac̱hek' xibe'na' lao Jesúza'. Na' lao yog'ḻoḻ beṉ'ka' lle' na', golle' bic̱he bex̱'ze' xe'na' na' daa bex̱een lii biyakteile'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Na'ch goll Jesúza'ne': ―Xiiṉ', daa chonḻilalloo nadaan biyakilo'. Biyaj mbalaz. ");
INSERT INTO zadNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ni choe'telə Jesúza' dill' ka bllin to beṉ' wzee lill Jairona', na' jelle'ne': ―Ba wit bi' c̱ho'na'. Bich gonilo' Maestroni zed. ");
INSERT INTO zadNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Na' ka beni Jesúza', na' golle' Jairona': ―Bi illebo'. Wyajḻe' c̱ha', na' wiyakkzi bi' c̱ho'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Na' ka bllingake' lille'na', aga be' Jesúza' latj sho' beṉ' yoblə, ḻete Pédrona', Jacóbona', Juanna' na' x̱axṉa' bi' weta'zə. ");
INSERT INTO zadNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Yog'ḻoḻ beṉ'ka' lle' lill Jairona' chbellgake' daa ba wit bi'do'na'. Na' goll Jesúza' ḻegake': ―Bi kwell-le, aga witbaan, cheszbaan. ");
INSERT INTO zadNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na' bxill-ləgake' c̱he', ḻa' ṉezgakile' ba witbaan. ");
INSERT INTO zadNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Na'ch bex̱' Jesúza' na' bi' wetdo'na' na' wṉie' zilljə, chi'e: ―Biyas, bi'do'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na'ch bibam' na' lii biyasteb'. Na' goll Jesúza' ḻegake' we'gake' dii gaob'. ");
INSERT INTO zadNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na' x̱axṉa'baa ḻe bibangakile', na' che' Jesúza' ḻegake' ni to kono ye'gake' daa gok. ");
INSERT INTO zadNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Na' bitop Jesúza' beṉ'ka' shlliṉ, na' bi'e ḻegake' yeḻ' wak na' yeḻ' wṉabia' kwenc̱he yibejgake' yog'ḻoḻ dii x̱iw'ka' yoo beṉ' na' yiyongake' beṉ' che'i yillwe'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na' bseḻee ḻegake' kwenc̱he llje'gake' dill' ka nak yeḻ' wṉabia' c̱he Chioza', na' yiyongake' beṉ'ka' bi shao'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Na' chi'e ḻegake': ―To ka chazlen ḻi shaj. Bi gox̱'le yag bar, bi wa'zle yix̱j ga koo xshinḻazle, bi wa'le dii gaole, ni mech, na' ni zi shkwe' xale. ");
INSERT INTO zadNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Na' yoona' gana' illinle, na'tezə soale ax̱t ka illinch lla yiza'le. ");
INSERT INTO zadNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na' yella' gana' bi wlebgake' le', kat' yiza'le, yishible bishtena' llia ṉi'aleka' kwenc̱he gakbe'gakile' aga wenan chongake' bi chlebgake' cho'a xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Na'ch wza' beṉ'ka' nakgake'ne' txen na' wyajgake' to to yell wdix̱je'gake' dill' wen dill' kob c̱he Chioza' na' biyongake' beṉ'ka' bi shao'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Heródeza', beena' wṉabia' gana' mbani Galileana', benile' yog' daa chon Jesúza'. Na' chakile' nora beena', ḻa' baḻ beṉ' nagake' dii Juan wichoa nisan' ba bibane' dii yoblə. ");
INSERT INTO zadNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Na' zi baḻe' nagake' Elíazan' ba bila' dii yoblə. Na' zi baḻe' nagake' nochod' dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yin ba biban ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Na' Heródeza' wne': ―Nad' ben' mandad wchog yen dii Juanna'. ¿Noraz beena' chenzid' nagake' chiya dii chone', lla? Na' ḻe goklall' Heródeza' ile'ile' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na' ka billin postlka' shlliṉ, na' gollgake' Jesúza' yog'ḻoḻ diika' jengake'. Na'ch bc̱hi'e to ḻezgake' yella' le Betsaida. ");
INSERT INTO zadNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Na' ka wṉezi beṉ'ka' ba zej Jesúza', na'ch wloogake' nez zjanogake'ne' na' ka bllingake' lawe'na', blebe' ḻegake' na' bzajniile' ḻegake' ka nak yeḻ' wṉabia' c̱he Chioza', na' biyone' beṉ'ka' bi shao'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na' ka ba wlle', beṉ'ka' shlliṉ jabig'gake' kwit Jesúza' na' gollgake'ne': ―Goll beṉ'ki yiyajgake' yellka' wa no ranshdo'ka' llia gaozə lljadiljgake' dii gaogake' na' ga guesgake', ḻa' ga ni zoacho bikzə bi de. ");
INSERT INTO zadNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Na' che' Jesúza' ḻegake': ―Len', ḻi we' dii gaogake'. Na'ch che'gake'ne': ―Gay'lish'tgui yetxtilki napcho na' zi c̱hopchga beḻ, ḻechozə shi willjx̱i'chnto' c̱he yoguee. ");
INSERT INTO zadNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Gollgake'ne' ka' ḻa' ka do gayaa mil beṉ' byoka' lle' na'. Na'ch che' Jesúza' beṉ'ka' shlliṉ: ―Ḻi ye'gake' kwe' shiyon wejgake'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Na' bzoagake' xtillee na' wlekgake' beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Na'ch bex̱' Jesúza' yetxtilka' gay' na' beḻka' c̱hop. Na' bḻis jalawe'na' yabana' bi'e Chioza' yeḻ' chox̱ken, na' bxoxje'n na' bi'en beṉ'ka' nakgake'ne' txen na'ch be'gake' c̱he c̱he beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Na' yog'gake' wdao ka beljgakile', na' diika' bichooṉan bitopgake'n biyakten shlliṉ xet'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","To shii ka choe'ḻwill Jesúza' Chioza', na' lle' beṉ'ka' nakgake'ne' txen, na' wṉabile' ḻegake': ―¿Non na beṉ'ka' nak'? ");
INSERT INTO zadNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Na' che'gake'ne': ―Baḻe' nagake' nako' dii Juan wichoa nisa', na' zi baḻe' nagake' nako' Elíaza', na' zi baḻe' nagake' nako' to beṉ' wdix̱jee daa goll Chioza'ne' kani'yi, na' ba bibane' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Na'ch chi'e ḻegake': ―Shera le', ¿nora nale nak'? Na'ch che' Pédrona'ne': ―Lin' Crístona', beena' nc̱heb Chioza' wseḻee. ");
INSERT INTO zadNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Na'ch goll Jesúza' ḻegake' ni to kono ye'gake' ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Na' chi'e ḻegake': ―Kon ka nchogbia' c̱ha', nad', Beṉ' Bseḻ' Chioza' Yell-lioni, biya dii wc̱hi' wsak'gake' nad'. Na' beṉ' golka' chṉabia' wzoagake' nad' ka'lə na' ka'kzə bx̱ozka' chṉabia' na' beṉ'ka' chli' chsedi leya'. Na' chonan byen witgake' nad', na' ka gak shoṉ lla yiban' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Na'ch golle' yog'ḻoḻe': ―Shi no cheeni gon nad' txen, chiyaḻ' wsanlall' kwine' na' izanile' yeḻ' mban c̱he'na' yen ile'ile' bittez ni c̱ha', na' gone' ka chazlallaa. ");
INSERT INTO zadNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ḻa' beena' bi chzani yeḻ' mban c̱he'na' yen ile'ile' bittez ni c̱ha', beenan' kwiayi'. San beena' chzani yeḻ' mban c̱he'na' ni c̱ha', beenan' gat' to yeḻ' mban c̱he' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bibi zjanayin gap beṉ' yog'ḻoḻ daa de yell-lioni, shi ḻe' kwiayee. ");
INSERT INTO zadNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nottezə beṉ' chiyii chido'i nad' na' c̱he cho'a xtillaana', ka'kz nad', Beṉ' Bseḻ' Chioza' Yell-lioni, yiyii yido'id' ḻe' kat' yiyed' kon balaaṉ xen c̱ha'na', na' c̱he X̱a' Chioza' na' c̱he anjl c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na' dii ḻi nia' le', baḻ-le lle'le ni, ni mbanle kat' wli' Chioza' yeḻ' wṉabia' c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ka gok do to xman wna Jesúza' ka', na'ch wyaje' to lo yaa kwenc̱he jeḻwille' Chioza' na' bc̱hi'e Pédrona', Juanna' na' Jacóbona'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Na' shlak choe'ḻwille' Chioza', biyak cho'alawe'na' nlla'lə, na' biyak xe'na' xtil ax̱t chey cheeni'n. ");
INSERT INTO zadNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na' gokx̱e c̱hop beṉ' bshaljlengake'ne', toe' dii Moiséza' na' beena' sto Elíaza'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Na' yeḻ' chey cheeni'na' nec̱hjan ḻegake'. Na' chshaljlengake'ne' c̱he ka nak yeḻ' wita' ile'ile' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na' Pédrona' len Juanna' na' Jacóbona' ḻe chakxwesgake', per bendiplall'gake' bi wtesgake', na'ch ble'gakile' yeḻ' chey cheeni' c̱he Jesúza' na' c̱he beṉ'ka' zi c̱hop bllin kwite'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na' ka ba chikwas dii Moiséza' na' Elíaza' kwit Jesúza', Pédrona' golle' Jesúza': ―Maestro, ¡ḻe wen zoacho nizə! Gonnto' shoṉə ransh, to c̱ho', to c̱he dii Moiséza' na' sto c̱he Elíaza'. Na' ni bi gokbe'i Pédrona' bin golle'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Na' ni choe'tie' dill', ka wze to bej gana' lle'gake' na' bkwashaan ḻegake'. Na' ḻe bllebgake' ka gokbe'gakile' ba yoogake' ḻoo beja'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na' ḻoo beja' bengakile' shii Chioza', chi'e ḻegake': ―Beenin xiiṉaa, na' ḻe chakidee. Ḻi wzenag c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Na' ka wde goll Chioza' ḻegake' ka', na' ble'gakile' stozə Jesúza' ze. Na' ni to kono gollgake' daa ben ble'gakile'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Betiyo, ka biyetjgake' lo yaana', beṉ' zan wal jatiḻgake' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na'ch ladj beṉ'ka' wṉe to beṉ' byo zillj, chi'e Jesúza': ―Maestro, ben goklen bwiagach bi' c̱ha'ni, ḻa' tlish' tyajchgabaan zoa. ");
INSERT INTO zadNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dii x̱iwaa chox̱a'n ḻeb' na' tokonganz chosyaab', na' chonan ka chazb' shoṉ ax̱t chbia bllin' cho'abaa. Na' chiya dii chonin ḻeb', na' aga cheenin wsanan ḻeb'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ba got'yoid' beṉ'ki nakgake' li' txen yibejgachgake' dii x̱iwaa yoob', na' bi gokgake' yibejgake'n. ");
INSERT INTO zadNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Na'ch che' Jesúza': ―¡Zi'tegalə c̱helena', le' beṉ' mal na' beṉ' bi chajḻe'! ¿Zi ka'k'tek chiyaḻ' soalen' le'? Na' ¿zi ka'k'tek chiyaḻ' soid' le'? Da diwa' bi' c̱ho'na' ni. ");
INSERT INTO zadNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na' ka zej bi'na' kwit Jesúza' na' wchooṉ dii x̱iwaa ḻeb' lo yona' na' wyazb' shoṉa' sto shii. Na'ch bsheshlen Jesúza' dii x̱iwaa na' bichejan, na' biyakib'. Na' biyone'b' lall' na' x̱abaa. ");
INSERT INTO zadNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na' yog' beṉ'ka' lle' na' bibangakile' daa ble'gakile' yeḻ' wak xen c̱he Chioza'. Na' shlak chibani yog' beṉ'ka' ble'i daa ben Jesúza', na' golle' beṉ'ka' nakgake'ne' txen: ");
INSERT INTO zadNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Ḻi wzeyeṉ' nagle dga iṉia' le': gongake' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, lall' na' beṉ'ka' chakzi' chakzbani nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Na' bi wyajni'gakile' bin golle', ḻa' ni ngashaan lawe'ka' kwenc̱he bi shajni'gakile'n. Na' bllebgake' iṉabgakile'ne' bi zejin daa golle' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na' wzolo chakdiḻ-len ljwellgake' nogaken' nak beṉ' zak'chi. ");
INSERT INTO zadNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ka gokbe'i Jesúza' daa chza'lall'gake', na'ch wdoyoe' to bi'do' na' bzie'b' kwite'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Na' chi'e ḻegake': ―Nottezə beṉ' wlebe' ḻaa to bi'do'zə ka bi'do'ni daa chonḻilallee nad', nad'kzan chlebe'. Na' beena' chlebe' nad', ḻekzka' chlebe' Chioza', beena' bseḻ' nad'. Na' beena' chaki bibi zakee lao yog'le, ḻen' nake' beṉ' zak'chi ladjlena'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Na'ch goll Juanna'ne': ―Maestro, ba ble'into' to beṉ' chzetje' lio'na' kwenc̱he chibeje' dii x̱iw'ka' yoo beṉ'. Na' bllonnto' gone' ka', ḻa' bi nake' cho' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Na' che' Jesúza' ḻegake': ―Bi wllonle gone' ka', ḻa' beena' bi chakile' cho' zi', txenkzan nake' cho'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na' ka ba zoa yiyaj Jesúza' yabana', na'ch btoblallee yiyaje' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na' bseḻee beṉ' wllialozegagake' na' wyajgake' to yell daa mbani Samáriana' jtiljgake' gana' yigaaṉe'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Na' beṉ' Samáriaka' bi blebgake'ne' daa ṉezgakile' Jerusalénna'lan yiyaje'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Na' c̱hop beṉ'ka' nakgake'ne' txen, Jacóbona' len Juanna', ka ble'gakile' ka ben beṉ' Samáriaka', na' che'gake' Jesúza': ―X̱an', ¿acheenilo' iṉabinto' Chioza' wseḻee yi'na' kwenc̱he sheytega beṉ'ki? ");
INSERT INTO zadNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Na' biyec̱hj Jesúza' bsheshlene' ḻegake', chi'e: ―Aga ṉezile non chṉabia' yic̱hjlall'do'lena' nazle ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nad', Beṉ' Bseḻ' Chioza' Yell-lioni, aga zaa kwenc̱he wlliayaa yeḻ' mban c̱he beṉ', san zaa kwenc̱he yisla' yeḻ' mban c̱he'kan'. Na'ch biyajgake' yell yoblə. ");
INSERT INTO zadNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na' ka zejgake' tneza', to beṉ' chi'e Jesúza': ―X̱an', cheenid' sa'len' li' gattezə shajo'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Na' che' Jesúza'ne': ―Zoa yech ga chiyoo bez'ka', na' byiṉdo'ka' non lilldo'gakb, san nad', Beṉ' Bseḻ' Chioza' Yell-lioni, biga de yigaaṉ'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Na'ch che' Jesúza' sto beṉ': ―Da dino nad'. Na' beena' chi'ene': ―X̱an', ben goklen be' latj zigaate lljakwashaa x̱a'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Na'ch che' Jesúza'ne': ―Bibi gakilo', wikwash'kzə ljwell beṉ' wetka'. San li', jtix̱je'i beṉ' ka nak yeḻ' wṉabia' c̱he Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na'ch sto beṉ' yoblə chizi'e Jesúza': ―X̱an', cheenid' sa'len' li' per zigaate be' latj lljaḻaach' dill' bish' ljwell'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Na' che' Jesúza'ne': ―To beṉ' chwaaṉe' gooṉ, aga wak wwie' gozkoll'lə. Na' ka'kzan nakan c̱he beena' noe' nad', shi bi nc̱hoglallee aga wak gone' ka cheeni Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Na' ka wde dga, Jesúza' wleje' zi guiyon shi beṉ' na' bseḻee c̱hop weje' wllialogake' lawe'na' kwenc̱he llje'gake' cho'a xtilleena' yellka' gana' llia bia' shaje'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Na' golle' ḻegake': ―Dii ḻi nia' le', dii xen wal daa yizi' yilaple de, na' to c̱hoptgui wen llinka' zoa. Na' ḻi iṉabi Chioza', beena' nak x̱an llinna' wseḻ'stoe' wen llinka' kwenc̱he yizi' yilapgake'n. ");
INSERT INTO zadNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ḻi shajshki ṉaa, nad' chseḻaa le' ka xil'do' ba zej ladj ba zṉia. ");
INSERT INTO zadNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bi wa'le ga koo xshinḻazle, ni mech, ni zi shkwe' xel-le; na' bi shazile wwaple beṉ' chiox tneza'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Na' ka sho'le to lill beṉ', zigaate wwaplene' chiox, ye'lene': “Soashgale mbalaz, le' zoale yooni.” ");
INSERT INTO zadNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na' shi zoa beṉ' cheenile' soe' mbalaz, na' yeḻ' mbalaza' yigaaṉlenan ḻe'. Na' shi bi cheenile', na' yibiilenan le'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Na' yoona' gana' illinle na'tezə yigaaṉle na' yeej gaole kon bi goṉgake' le', ḻa' to wen llin chiyaḻ' ikaa laxje'. Na' bi lljsoale to to yoo. ");
INSERT INTO zadNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kat' illinle to yell ga wlebgake' le', yeej gaotezle bittezə dii goṉgake' le'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Na' yiyonle beṉ'ka' bi shao' yella', na' ye'le ḻegake': “Yeḻ' wṉabia' c̱he Chioza' ba bla'n laoleni.” ");
INSERT INTO zadNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Na' shi illinle to yell ga bi wlebgake' le', ḻi yide lyell, ḻi ye'gake': ");
INSERT INTO zadNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ax̱t bishte c̱he yell c̱heleni wllia ṉi'anto'ni chibibnto'n kwenc̱he gakbe'ile aga wenan chonle bi chleble cho'a xtill' Chioza'. Na' ḻi koosha yic̱hjle dga iṉanto' le', yeḻ' wṉabia' c̱he Chioza'n ba bla'n laoleni.” ");
INSERT INTO zadNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na' nia' le', beṉ'ka' lle' yellka' gana' bi wlebgake' le', dii xench nak yeḻ' zak'zi'na' ile'gakile' aga ka beṉ' yell Sodómaka' llana' wc̱hoglo Chioza' c̱he beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Nyesh'laz gak c̱hele, le' beṉ' yell Corazín na' le' beṉ' yell Betsaida! Ḻa' sheḻ' gok yeḻ' wakka' yell Tírona' na' Sidónna' ka diika' ba gok ladjlena', kana'telja biyaj bilengakile' saaxya c̱he'ka', na' ba wche'gake' bwazjgake' dena' yic̱hjlaogake' na' gokwgake' lech' zeshaa, kwenc̱he wli'gake' nan ba biyaj bilengakile' daa chongake', sheḻ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kat' illin lla wc̱hoglo Chioza' c̱he beṉ', yeḻ' zi' xench ile'ile aga ka beṉ' yell Tíroka' na' beṉ' yell Sidonka'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Na' le' beṉ' yell Capernaúm, bi gonle lez yillinle yabana', ḻa' Chioza' wzaḻee le' gana' sak'zi'le. ");
INSERT INTO zadNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Na'ch che' Jesúza' beṉ'ka' bseḻee: ―Beṉ'ka' chzenaggake' c̱hele, c̱ha'kzan chzenaggake'. Na' beṉ'ka' bi chlebgake' le', nad'kzan bi chlebgake'. Na' beena' bi chlebe' nad', ḻekzka' bi chlebe' Chioza', beena' bseḻ' nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Na' beṉ'ka' guiyon shi ḻe chibagakile' ka billingake' kwit Jesúza', na' che'gake'ne': ―X̱an', ax̱t dii x̱iw'ka' chilleshgakan ka chzetjnto' lio'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Na'ch che' Jesúza' ḻegake': ―Ble'id' Satanáza' daa chṉabia' dii x̱iw'ka' bxopan yabana' ka chxop to yi' wziw'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nad' ba beṉ' le' yeḻ' waka' kwenc̱he ḻa'kzi gad' no beḻ zṉia wa no bex̱joni' le' aga bi gakile', na' wlej wshoshjtele yog' daa chon dii x̱iwaa. ");
INSERT INTO zadNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Per bi yibaile daa chisheshle dii x̱iw'ka', san ḻi yibayi daa ba da' lelena' ḻee libra' de yabana'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na' katena' Espíritu Sántona' bene' ka bibachgayi Jesúza', na' wne': ― X̱a, li' nako' X̱an yabana' na' yell-lioni, na' choe'lawaa li' daa ba bliilo' beṉ'ka' bibi chajnii daa bi bliilo' beṉ' sin'ka' na' beṉ'ka' nteyi. Kan' ba wyazlalloo gono', X̱a. ");
INSERT INTO zadNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’X̱a'na' ba none' lall' na' yog'te dii de. Na' ni to kono ṉezi noyeṉ'an' nak' nad' Xiiṉe'; toz X̱a'na' ṉezile'n. Na' ni to kono ṉezi noyeṉ'an' nak X̱a'na'; toz nad' Xiiṉe' ṉezid', na' chon' ka iṉezi beṉ'ka' cheenid' iṉezgakile'n. ");
INSERT INTO zadNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Na'ch biyec̱hje' bwie' beṉ'ka' nakgake'ne' txen, chi'e ḻegake': ―Chakomba beṉ'ka' chle'gakile' diika' chle'ile ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nia' le' ka', ḻa' zan beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' na' zan beṉ' wṉabia'ka' goklall'gake' ile'gakile' diiki chle'ile ṉaa, na' bi ble'gakile'n. Goklall'gake' yengakile' dga chenile ṉaa, na' bi bengakile'n. ");
INSERT INTO zadNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na'ch wbig' to beṉ' chli' chsedi leya' wṉabile' Jesúza' kwenc̱hezə iṉezile' shi wak yillii Jesúza' xtilleena', na' wṉabile'ne': ―Maestro, ¿bin chiyaḻ' gon' kwenc̱he gat' to yeḻ' mban c̱ha' zejḻi kaṉi? ");
INSERT INTO zadNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Na'ch che' Jesúza'ne': ―¿Bin na leya' chiyaḻ' goncho? ¿Bi na daa chlabo'? ");
INSERT INTO zadNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Na'ch beena' chli' chsedi leya' chi'e: ―“Chiyaḻ' gakicho X̱ancho Chioza' do yic̱hj do lall'cho, do ka nak fuerz c̱hechona', na' ax̱t ga zeelo chajniicho; na' gaki bish' ljwellcho ka chaki kwincho.” ");
INSERT INTO zadNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Na'ch che' Jesúza'ne': ―Kayeṉ'nan nakan ka ba wno'. Shi gono' ka nan, na' gat' to yeḻ' mban c̱ho' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Na' beena' bi goklall' wṉit kwine', na'ch chi'ene': ―¿Noran bish' ljwell'? ");
INSERT INTO zadNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Na'ch che' Jesúza'ne': ―To beṉ' ziyo'e nez daa ziza' Jerusalénna' daa ziyaj Jericólə, na' bchej wbanka' tneza' wlangake' yog'te diika' zino'e ax̱t len xe'na' daa nakwe' goljgake', na' bet wdingake'ne', sto chdoaze' bengake', na' bixoṉjgake'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Na' shintk gok ka' ka wde to bx̱oz lo neza'. Na' ka ble'ile' beena' de na', to wdeze' ka'lə. ");
INSERT INTO zadNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na' ḻekzka' wde to beṉ' nake' xiiṉ dia c̱he dii Levína'. Na' ka ble'ile' chtoḻ beena' na', ḻekzka' to wdeze' ka'lə. ");
INSERT INTO zadNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Na' sto beṉ' Samaria ḻekzka' zeje' tneza' ka ble'ile' beena' chtoḻ na', na' biyeshile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Na' jabiguee kwite'na', na'ch bllie' lo we'na' set na'ch vino, na' bc̱heje'n. Na' biḻepe'ne' koll' bayix̱' c̱he'na', bic̱hi'ene' to yoo gana' wdape'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na' betiyo, ka ba zoa yiza' beṉ' Samáriana', wleje' c̱hop mech plat, na' bi'en x̱an yoona' kwenc̱he gap wwie'ne' zan lla, na' chi'ene': “Wdap bwiagach beeni, na' shi bi gaki mechi chkwaaṉ', na' yiyixja'n kat' zizaa dii yoblə.” ");
INSERT INTO zadNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Na' ¿nora beṉ'ki shoṉ chakilo' beni bish' ljwell beena' wlan beṉ' wbanka'? ");
INSERT INTO zadNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Na' beena' chli' chsedi leya' chi'ene': ―Beena' biyeshile'ne'. Na' che' Jesúza'ne': ―Ḻekzka' li', kan' chiyaḻ' gono'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na' shlak ngoo Jesúza' nez, blline' to yelldo' na' to noolə le Marta blebe'ne' lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na' zoa to beṉ' bil Mártana' lie' María, na' Maríana' wchi'e lao Jesúza' chzenague' dillaa cho'e. ");
INSERT INTO zadNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Na' Mártana', dechga daa gone' na' wzeche' wṉeyi c̱heyin, na'ch wyaje' kwit Jesúza', chi'ene': ―X̱an', goll-lat' beṉ' bila'ni gaklene' nad'. Toz' ndakw' yog' mandadka'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Na' che' Jesúza'ne': ―Marta, Marta, chi'chga yic̱hjo' na' zechgo' wneyi c̱heyi diika' gono'. ");
INSERT INTO zadNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Per toz daa de nakan dii llialoch na' Maríani ba wleje'n, na' kono gak yikaan lawe'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Shlin choe'ḻwill Jesúza' Chioza' to latj, na' ka biyoll be'ḻwille'ne', to beena' nake'ne' txen golle'ne': ―X̱an', bli'yi neto' nakan chiyaḻ' we'ḻwillnto' Chioza', ka ben Juanna' bli' bsedile' beṉ'ka' bengake'ne' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Na'ch che' Jesúza' ḻegake': ―Kat' we'ḻwill-le Chioza' kin iṉale: X̱anto' Chios, beṉ' zoa yaba, we'la'oshga yog'ḻoḻ beṉ' li'. Na' iṉabia'gacho' ḻoo yic̱hjlall'do' yog'ḻoḻ beṉ' kwenc̱he gak lo yell-lioni ka chazlalloo, kon ka chak yabana'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ka nak daa choṉo' cheej chaonto' yog' lla, beṉgachan ṉaanlla. ");
INSERT INTO zadNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Wxi'xen c̱hento', ka chon neto' chzi'xennto' bittezə dii choni beṉ' neto'. Bi we'gacho' latj ibix̱nto' gonnto' daa bi nak wen, san bislagach neto' lo ṉi'a na' dii mala'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Na'ch che' Jesúza' ḻegake': ―Iṉatezcho shi zoa to beṉ' nllaguile na' do chel shajle lille'na' na' ye'lene': “Beṉ' bish'dawaa, beṉ shloll nad' shoṉ yetxtil, ");
INSERT INTO zadNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ḻa' ba bla' lilla'na' to beṉ' nllaguid', zee zit', na' bikzə bi de c̱ha' wshabidee.” ");
INSERT INTO zadNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na'ch beena' yoo ḻoolə lii iṉatie' le': “Bi gonzilo' nad' zed, ba nsejl' lillii na' ba delen' bi' c̱ha'ki. Aga wak c̱has' goṉ' daa chyalljilo'.” ");
INSERT INTO zadNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na' nia' le', ḻa'kzi nllagteile'ne', bi c̱hase' wi'ene' daa chṉabile'ne'. San shi seyide' iṉabe'n, chen ki cheenile' c̱hase' wi'e yog' daa chyalljile. ");
INSERT INTO zadNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Daan nia' le': Ḻi iṉabi Chioza' bin cheenile na' goṉe'n. Ḻi yiyiljan na' willelkzilen. Ḻi wtankw ḻee puerta', na' wsaljkze'n. ");
INSERT INTO zadNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ḻa' beena' chṉabile' to bi chṉabile' beṉ', cho'ene'n; na' beena' chiyilje' bi chiyilje', chillelkzile'n; na' beena' chtankwe' to ḻee puert, na' chsaljkzgake'n. ");
INSERT INTO zadNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Ka chak c̱hele le' nakle beṉ' chisgol chischoo bi'do', ka iṉabi xiiṉlena' le' yetxtila', aga we'leb' to yaj. Wa shi iṉabib' le' to beḻ gaob', aga we'leb' to beḻ zṉia. ");
INSERT INTO zadNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wa shi iṉabib' le' to llit gaob', aga we'leb' to bex̱joni'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Le' naktele beṉ' mal, chak we'le xiiṉleka' daa nak dii wen. ¡Na' X̱acho Chioza' zoa yabana' nakteche' beṉ' wench! Na' wi'e Espíritu Santo c̱he'na' soe' ḻoo yic̱hjlall'do' yog' beṉ' iṉabe'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesúza' chibeje' to dii x̱iw' yoo to beṉ' bi chak iṉie', na' ka bichejan na'ch gok biṉie'. Na' beṉ'ka' lle' na', bibangakile' daa bene'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Na' baḻe' che'gake': ―Kon yeḻ' wak c̱he Bezlona', daa chṉabia' dii x̱iw'kan', chibeji beeni dii x̱iw'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Na' zi baḻe' wṉabgakile'ne' gone' to yeḻ' wak dii ile'gakile' kwenc̱he wli'n shi Chioza'kzan bseḻeene'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Na' ba ṉezli Jesúza' daa chza'lall'gake', na'ch chi'e ḻegake': ―Shi beṉ'ka' lle' to yell gakgake' c̱hoplə na' tiḻ-len ljwellgake', na' kwiayi' yella', shi ṉaa. Na' ḻekzka' shi beṉ'ka' lle' toz yoo tiḻ-len ljwellgake', aga ssha soagake' toz. ");
INSERT INTO zadNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na' ka'kzə Satanáza' na' dii x̱iw'ka' yoo lo na'yin, shi gakgakan c̱hoplə na' kwiayi' yeḻ' wṉabia' c̱heyinna'. Nia' le' ka' daa nale yeḻ' wak c̱he Bezlonan chibejid' dii x̱iw'ka' yoo beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Shi chibej' dii x̱iwaa yoo beṉ' kon yeḻ' wak c̱he Bezlona', ¿sheralə beṉ'ka' nakle txen? ¿Aḻekzka' ḻennan' chibejlengake' dii x̱iwaa yoo beṉ'? Daa bi nakan ka', chli'n nakllejilen. ");
INSERT INTO zadNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Na' daa chibej' dii x̱iwaa yoo beṉ' kon yeḻ' wak c̱he Chioza', ḻennan' chli'n ba bla' yeḻ' wṉabia' c̱he Chioza' ladjleni. ");
INSERT INTO zadNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Kat' to beṉ' wal nape' dii gonile' zṉia na' chape' lille'na', aga no gak lljtoyo dii de c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Per shi illin sto beṉ' walch tiḻ-lene'ne', na' gone'ne' gan, na'ch yigoyoe' yog' daa none' lez wṉiaile', na' kwantie' yog' daa yoo ḻoo lille'na' na' wi'e lat' wej c̱he beṉ'ka' nakgake'ne' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Beena' bi nake' nad' txen, chakzbanile' nad'. Na' beena' bi chaklen kwenc̱he wzenag beṉ' cho'a xtill' Chioza', ḻen' chsej chllone' wzenaggake'n. ");
INSERT INTO zadNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Kat' chichej to dii x̱iw' dii yoo beṉ', na' chjadan ga bibi dekzə na' chyiljan gana' yizi'lalliin. Na' shi bi chllelin gana' yizi'lalliin na'ch chakin: “Yiyaachkz' dii yoblə gana' bichejkz'.” ");
INSERT INTO zadNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na' ka chillinan gana' bichejan, nakan ka to ḻoo yoo dii nxi nḻoa na' nakan xochi. ");
INSERT INTO zadNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Na'ch chza'n chjx̱i'n zi gall dii x̱iw'ka' daa nakch dii malch aga ka ḻen, na' yogaan choogakan beena'. Na' chaktechlə mal c̱he beena' aga ka gok c̱he' dii nech. ");
INSERT INTO zadNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Na' shlak che' Jesúza' ka', to noolə zie' ladj beṉ'ka' lle' na' wṉie' zilljə, chi'e: ―¡Chakomba noola' wxane' li' na' bwall bx̱ope' li'! ");
INSERT INTO zadNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Na' che' Jesúza'ne': ―¡Mbalazch beṉ'ka' chzenaggake' cho'a xtill' Chioza' na' chongake' ka nan! ");
INSERT INTO zadNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na' bdi'a bllagch beṉ'ka' kwit Jesúza' na' golle' ḻegake': ―Le' zoale ṉaa, nxiṉj yic̱hjlall'do'leka'. Chṉable wliid' le' to yeḻ' wak, na' aga wliid' le' daa cheenile. Ḻete ile'ile to dii nak ka yeḻ' waka' daa ben Chioza' c̱he dii Jonáza'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Daa gok c̱he Jonáza' bli'n yeḻ' wak c̱he Chioza' lao beṉ' Níniveka'. Kakzə nad', Beṉ' Bseḻ' Chioza' Yell-lioni, wli'a yeḻ' wak c̱he Chioza' laolena', le' zoale ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na' llana' wc̱hoglo Chioza' c̱he beṉ', na' yiban noola' wṉabia' do lli'lə, na' gawe' xya c̱hele lao Chioza', le' zoale ṉaa, iṉe' chiyaḻ' sak'zi'le. Ḻa' noola', zit' wal wzee bidzenague' dill' sin'na' daa be' dii Salomónna', na' nad' zoa' ni, nak' beṉ' zak'chi ka dii Salomónna', na' bi chzenagle c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na' ḻekzka' llana' wc̱hoglo Chioza' c̱he beṉ', na' yiban beṉ' Níniveka' na' gaogake' xya c̱hele lao Chioza', le' zoale ṉaa, iṉagake' chiyaḻ' sak'zi'le. Ḻa' ḻegake' biyaj bileni saaxya c̱he'ka' ka be'len Jonáza' ḻegake' cho'a xtill' Chioza', na' nad' zoa' ni, nak' beṉ' zak'chi ka dii Jonáza', na' bi chzenagle c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Na' ḻekzka' chi'e ḻegake': ―Biga zoa beṉ' chxene' to kandil na' chzoe'n to ga ngash' wa wdoseen to dii wkwashaan ḻen, san chzoe'n sibə kwenc̱he ile'i beṉ'ka' sho' ḻoo yoona'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jalawo'ka' nakan ka to yi' c̱he kwerp c̱ho'na'. Shi jalawo'na' nakan wen, doxen kwerp c̱ho'na' zoan lo beeni'na'. San shi bi chle'i jalawo'na', kwerp c̱ho'na' zoan lo yel c̱hola'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Na' bsak' wze wṉeyi kwenc̱he ki lwaa to' lo beeni'na', tazo' lo yel c̱hoḻa'lə. ");
INSERT INTO zadNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Shi doxen kwerp c̱ho'na' yoon beeni', na' ni to dii shgasj shc̱hoḻ bi yoon, na' ile'ilo' kwasḻoḻ ka chle'ilo' kat' ze to yi' chzeeni'n doxen. ");
INSERT INTO zadNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Na' ka biyoll be' Jesúza' dillaa, na' bc̱he' to fariseo ḻe' lljtawe' lille'na'. Na' wyoo Jesúza' lille'na' na' wchi'e cho'a mesa'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na' farisewa' bibanile' ka ble'ile' bi bina' Jesúza' ka yoologake' chongake' ka zi' gaogake'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Na'ch che' X̱ancho Jesúza'ne': ―Le' fariseo nakle ka xig' yeeṉ dii nyib x̱ise' tcho'a tlawin na' ḻo'inna' besjan. Chaki beṉ' ḻe beṉ' wen nakle, len le' chibaile chkaale bi de c̱he beṉ' na' chibaile chonle bichlə dii mal. ");
INSERT INTO zadNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Le' beṉ' bi nteyi! ¿Abi chakbe'ile Chioza', beena' ben kwerp c̱hechoni, ḻekze'n bene' yic̱hjlall'do'choni? ");
INSERT INTO zadNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ḻi izani bi de c̱hele, ḻi we'n beṉ' bibi de c̱he', na'ch yixi' yiyech yic̱hjlall'do'lena'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Nyesh'laz gak c̱hele, le' fariseo! Choe'le Chioza' lat' wej no yix̱wej, no kwanirod na' bichlə yix̱' kwan dii mbekle. Na' bi chonle daa nak shḻicha na' bi chakteile' Chioza'. Ḻa' daayeṉ'an llialoch gonle per ḻekzka' bi wsanle kwejle daa chṉab Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Nyesh'laz gak c̱hele, le' fariseo! Ḻe chibaile kwe'le gana' chbe' beṉ'ka' zakii gana' chdop chllagcho choe'ḻwillcho Chioza', na' cheenile yog' beṉ' kwee le' balaaṉ ga lle' lla' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Nyesh'laz gak c̱hele, daa nakle beṉ' wxiye'! Nakle ka to ba c̱he beṉ' wet dii bi nla' lawinna' dii bi chle'i beṉ' na' chaj chdegake' lawinna', ni bi chakbe'gakile' bin naki ḻoolə. ");
INSERT INTO zadNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na'ch to beena' chli' chsedi leya' golle' Jesúza': ―Maestro, daa no' ka' len neto' chzoazi'yoo. ");
INSERT INTO zadNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Na' goll Jesúza': ―¡Ḻekzka' nyesh'laz gak c̱hele, le' chli' chsedile leya'! Dii zan dii che'le beṉ' chiyaḻ' gongake', na' nakan ka to yoa' xen dii chwa'le ḻegake' dii kono soyi, na' le' bikz bi chda na'le kwenc̱he gaklenle ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Nyesh'laz gak c̱hele! Le' chonshao'zle cho'a ba c̱he dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake', beṉ'ka' bet dii x̱ozxto'leka'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Na' daa chonle ka' zejin chonle txen dii x̱ozxto'leka' ka nak daa bengake'. Ḻa' ḻegaken' betgake' beṉ'ka', na' le' chonshao'le cho'a ba c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Na' daan, lo yeḻ' sin' c̱he Chioza' wne': “Wseḻaa beṉ' c̱hix̱jee daa yepee na' len beṉ' wi'e cho'a xtillaana', na' baḻe' witgake' na' zi baḻe' biya dii gongakile'ne'.” ");
INSERT INTO zadNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Na' le' zoale ṉaa, lenle ile'ile ka yeḻ' zi'na' ile'i beṉ'ka' blalj xc̱hen dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake', wzolozan ka wxe wzil yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Le' zoale ṉaa, lenle chidoḻ'le sak'zi'le ni c̱he yeḻ' wit c̱he dii Abela' ax̱t dii Zacaríaza', beena' betgake' cho'a yoodo'na' kwit gana' chzeygake' bayix̱'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Nyesh'laz gak c̱hele, le' chli' chsedile leya'! Ḻa' nazle chsedile beṉ' c̱he Chioza', per ni le' bi cheenile wzenagle daa nan, na' chllontele shajnii beṉ'ka' chzenagan. ");
INSERT INTO zadNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Na' ka goll Jesúza' ka', beṉ'ka' chli' chsedi leya' na' fariseoka' zizikli bllaagake' na' wzologake' chongakile'ne' zed wal wṉabgakile'ne' chiya dii nak lallj, ");
INSERT INTO zadNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","goklall'gake' we' Jesúza' dill' dii wchix̱a'n ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na'ch bdop bllag beṉ' zan inlleb gana' zoa Jesúza' ax̱t chdakw ljwellgake', na' wzoloe' zigaate be'lene' beṉ'ka' nakgake'ne' txen dill', chi'e: ―Wsak'gale bi shajḻe'le dill' wxiye' c̱he fariseoka' daa zaklebi levadúrana'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ḻa' daa kono ṉezi ṉaa, wllin lla iṉezi beṉaan, na' yog'ḻoḻ daa ngash' ṉaa, wllin lla ila' lawin. ");
INSERT INTO zadNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Na' yog' daa chakile kono beni daa wnale, wllin lla iṉezgakile'n. Na' daa wnale ka yoole ḻoolə nsejshoshle yoona', ax̱t gosya'i beṉ' wzie'n dill'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Le' nllaguid', nia' le' bi illeble beṉ'ka' witgake' le', ḻa' kachokzan zeelo gak gongakile' le'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Per ni iṉia' le' non chiyaḻ' illeble: ḻi illeb Chioza', ḻa' ka yiyoll yikee yeḻ' mban c̱helena' ḻekzka' nape' yeḻ' wṉabia' wzaḻee le' lo yi' gabiḻa'. Ḻen', ḻi illeb. ");
INSERT INTO zadNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Ṉezicho wak si'cho gay' byiṉdo' kon c̱hop sintabdo'. Ḻa'kzi aga bitek zak'gakb, ni tob bi mbej yic̱hj Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na' ka'kzə le', ax̱t to to yish' yic̱hjlena' mbab. Na' bi illeble, ḻa' zak'chle aga ka zan byiṉdo'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Na' nia' le', beena' wc̱heb lao beṉ' nake' nad' txen, ḻekzka' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, wi'a dill' lao yog'ḻoḻ anjl c̱he Chioza', yepgakee beeni nake' nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","San beena' bi wc̱heb nake' nad' txen, ḻekzka' nad', wi'a dill' lao yog'ḻoḻ anjl c̱he Chioza', yepgakee beeni bi nake' nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Na' beena' biz gon iṉa c̱ha', nad', Beṉ' Bseḻ' Chioza' Yell-lioni, wizi'xen Chioza' c̱he', san beena' iṉe zban c̱he Espíritu Sántona', aga wizi'xen Chioza' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Kat' lljwa'gake' le' lao beṉ'ka' chṉabia' gana' chdop chllagcho choe'ḻwill-cho Chioza', wa lao beṉ' chc̱hogbia' c̱he beṉ' wa lao josc̱his, bi sele wṉeyi naklə yilliile cho'a xtill' beṉ'ka' wa bin iṉale. ");
INSERT INTO zadNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ḻa' kat' iṉele, Espíritu Sántona'kzan wzajniile' le' daa chiyaḻ' iṉale. ");
INSERT INTO zadNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Na' ladj beṉ'ka' ndop nllag wṉe to beṉ', golle' Jesúza': ―Maestro, gollgach beṉ' bishaana' goṉe' daa chidoḻ' ikaa c̱he dii x̱anto'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Na' che' Jesúza'ne': ―¿Nora bzoa nad' ladjleni ka to beṉ' chon yeḻ' josc̱his c̱he beṉ' wa beṉ' chḻaa bi dii de c̱he beṉ'? ");
INSERT INTO zadNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Na' ḻekzka' chi'e: ―Ḻi wsak' kwenc̱he bi selall'le gat'ch bi gat' c̱hele, ḻa' aga dii kan' llialo lo yeḻ' mban c̱helena'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na'ch bzoe' to jempl, chi'e ḻegake': ―Wzoa to beṉ' wni'a na' dii zan bizi' bilape' lo yell-lio c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Na'ch chakile': “¿Nakra ka gona'n ṉaa? Biga de kooshawaa dga bizi' bilap'.” ");
INSERT INTO zadNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na'ch wne': “Ba ṉezid' bi gon'. Yic̱hiṉj' yoona' gana' chgooshawaa daa chizi' chilap' na' yiyona'n dii xench, na' kooshawaa daa bizi' bilap' na' bichlə dii de c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na'ch zan yiz yizia' banez c̱he daa ngooshawaa, na' yizi'lallaa na' yeej gaw', na' soa' mbalaz.” ");
INSERT INTO zadNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Na' goll Chioza'ne': “Li', beṉ' bi nteyi, ṉaanlle' gueto' na' daa ngooshawoo, nola c̱heyi gakan.” ");
INSERT INTO zadNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kan' gak c̱he beena' chtop chshag yeḻ' wni'ana', na' bibi zakee lao Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ka wde dga, Jesúza' golle' beṉ'ka' nakgake'ne' txen: ―Ṉaa nia' le': Bi sele wṉeyi c̱he daa yeej gaole, ni bi sele wṉeyi c̱he xalaanlena'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ḻa' zak'techlə yeḻ' mban c̱helena' aga ka daa yeej gaole, na' zak'tech xkwerplena' aga ka xalaanlena'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ḻi wwiakachi bec̱hjka', ḻa'kzi bi chaz chaaṉgakb na' bibi chizi' chilapgakb, ni bi zoa ga chgooshao'gakb dii gaogakb, len chweej chwaokz Chioza' ḻegakb. Na' le', ṉaa, zak'techle aga ka bado'ka' ze lo llazə. ");
INSERT INTO zadNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ni tole bi gak yisc̱hoochle yeḻ' mban c̱helena' ni zi tgor ḻa'kzi nall inlleb selen wṉeyi. ");
INSERT INTO zadNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Shi dga nak diido'zə bi chak gonlen, ¿berac̱he zezle wṉeyi c̱he bichlə dii yoblə? ");
INSERT INTO zadNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Ḻi wwiakachi ka chgol yejdo'ka', len aga bi llin chongakan ni bi choḻgakan do. Na' nia' le', ni Salomónna', beena' wdapchga yeḻ' shao'ka', bi bllin gak xe'na' xochi ka yejdo'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Shi Chioza' none' xochi yejdo'ka' ze lyix̱aa, ḻa'kzi xtitchgan mbanan na'ch wtop beṉ' ḻen wlli'en lo yi'na', ¿alechlin ki gone' c̱hele, ḻa'kzi bitek chajḻe'le gaklene' le'? ");
INSERT INTO zadNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Na' daan bi setekle wṉeyi ga sa' daa yeej gaole. ");
INSERT INTO zadNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ḻa' beṉ'ka' bi nonḻilall'gake' Chioza' to daazə chinogake'. Per le', Chioza' nake' X̱ale, na' ṉezile' chyalljilen. ");
INSERT INTO zadNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ḻi se wṉeyi wzenagle c̱he Chioza' kwenc̱he iṉabi'e le', na' goṉkze' yog' daa chyalljile. ");
INSERT INTO zadNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Bi illeble. Ḻa'kzi bi nyanle, X̱acho Chioza', yeḻ' beṉ' wen c̱he'na', chaklallee yillinle iṉabia'lenlene' gana' chṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ḻi wit' wde bi de c̱hele, na' ḻi gaklen beṉ' bibi de c̱heyin. Shi ka' gonle, na' gat' yeḻ' shao' c̱hele dii bi te c̱heyin yabana' gana' bi gak kwan wbanna'n, ni bi iteban. ");
INSERT INTO zadNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Na' gana' de yeḻ' shao' c̱helena', na'kzan se yic̱hjlall'do'lena' wṉeyi. ");
INSERT INTO zadNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Na' ḻekzka' chi'e ḻegake': ―Ḻi gakto ka wen llinka', beṉ'ka' chbezgake' x̱ane'ka' yilline' daa zeje' to ga chak wishagna'. Na' toshiizi chi'gake' chbezgake'ne' na' nox̱'tegake' yi' c̱he'ka' kwenc̱he kate wtankwe' ḻee puerta' lii wsaljtegake'n. ");
INSERT INTO zadNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Chakomba wen llinka' chbezgake' kat' yillin x̱ane'ka', ḻa' dii ḻi nia' le', kwine' kweke' ḻegake' cho'a mesa' na' wi'e dii gaogake'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Chakomba beṉ'ka' chbezgake' yillin x̱ane'ka' ḻa'kzi yilline' do chel wa do zbaḻzə. ");
INSERT INTO zadNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Na' chiyaḻ' shajniile dga, sheḻ'ka' to x̱an yoo iṉezile' bi gor illin wbanna' lille'na', wbe'noe'ne' na' bi wi'e latj sho'e lille'na' kwane'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ka'kzan le' chiyaḻ' sele wṉeyi toshiizi kwezle nad', Beṉ' Bseḻ' Chioza' Yell-lioni, ḻa' tokonganzə yiyed'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Na'ch wṉabi Pédrona' Jesúza', chi'ene': ―X̱an', ¿ato neto'zan no' ka', anti c̱he yog' beṉaan no' ka'? ");
INSERT INTO zadNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Na'ch goll X̱ancho Jesúza': ―¿Nakra chakile chon to wen llin wen, beṉ' ṉezi nak gone' llinna', shi x̱ane'na' gone' lall' nee yog'te beṉ'ka' zoa ḻoo yoo lille'na' kwenc̱he wweej wwawe' ḻegake' gor c̱heyin? ");
INSERT INTO zadNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Chakomba wen llinna' chilaḻile' chone' daa nak lall' nee ka yillin x̱ane'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Dii ḻi nia' le', x̱ane'na' gone' lall' nee yog'ḻoḻ dii de c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Na' shi wen llinna' gakile': “Akza ṉaa yila' x̱an'na'”, na'ch soloe' gonile' zban wen llinka' sto, ka nool ka beṉ' byo, na' soloe' yeej gawe' na' sollile'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na' tokonganzi yillin x̱ane'na' llana' bi none' lez, na' wdie'ne' to yeḻ' zi' wal kon ka ba nc̱hogloe' gak c̱he beṉ'ka' bi chongake' daa chiyaḻ' gongake'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Beṉ' wen llinna' ṉezi bin cheeni x̱ane'na' gone', na' bi chone'n ni bi zie'n wṉeyi, na' wit c̱hinchga x̱ane'na' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Per beena' bi ṉezi bin cheeni x̱ane'na' gone', na' chone' dii chonan ka wsak'zi' x̱ane'na'ne', agalə wsak'zi'teke'ne'. Ḻa' beena' be'lenyeṉee dill' nakan gone', chonan byen gonyeṉee ka bzajniile'ne'. Na' beena' ba bene' lall' nee gone' dii zan dii cheenile' gone', chonan byen gone' yog'ḻoḻte diika' bene' lall' nee. ");
INSERT INTO zadNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Daa bid' yell-lioni nakan ka iṉacho yin' bidxen'. Na' cheenchgaid' sheḻ' ṉaate ba chaḻ'ṉiṉan. ");
INSERT INTO zadNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Biya dii yen ile'id', na' ḻe ba chakyeshid' ax̱t ni illini llana'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Achakile bid' yell-lioni kwenc̱he gon' ka soalen ljwell beṉ' mbalaz? Aga kan', san daa bid' illaa ljwellgake' na' gakgake' c̱hoplə. ");
INSERT INTO zadNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ḻa' ṉaa, shi to yoo lle' gayee, na' gakgake' c̱hoplə, shoṉe' tiḻ-lengake' beṉ'ka' c̱hop, na' beṉ'ka' zi c̱hop tiḻ-lengake' beṉ'ka' zi shoṉə. ");
INSERT INTO zadNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","X̱a bi' byona' tiḻ-lene'b', na' ḻeb' tiḻ-lem' x̱abaa. Na' xṉa' bi' noola' tiḻ'lene'b', na' ḻeb' tiḻ-lem' xṉa'baa. Na' noola' tiḻ-lene' xoolille'na', na' xoolille'na' tiḻ-lene' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Na' ḻekzka' che' Jesúza' beṉ'ka' lle' na': ―Kat' chle'ile ziza' beja' gana' chxoalə wbilla', lii natele: “Wakə yeja'”, na' kayeṉ' chak. ");
INSERT INTO zadNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na' kat' chde be'na' daa za' lli'lə, na' nale: “Ḻe zey'chga yizak”, na' kayeṉ' chak. ");
INSERT INTO zadNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Le' beṉ' wxiye'! Kat' chle'ile bin chak xan yabana' na' lo yell-lioni ṉezile beran gak. ¿Bic̱he bi chakbe'ile bin zeji daa chon Chioza' llaki zoacho ṉaa? ");
INSERT INTO zadNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Bic̱he ki chiyiljle to kwinzle daa nak dii ḻi dii shao'? ");
INSERT INTO zadNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Shi no chao xya c̱hele na' wc̱hi'e le' lao josc̱hiska', ḻi gon byen yiyoe'xenlene' tneza'. Ḻa' shi lljwee le' lao beena' chc̱hogbia' c̱he beṉ', na' ḻe' gone' le' lo na' beena' wseje' le' lillyana'. ");
INSERT INTO zadNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na' nia' le', aga wichejle lillyana' ax̱t ki c̱hixjle doxen daa chiyaḻ' c̱hixjle. ");
INSERT INTO zadNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na' lo llana'tezə bllin baḻ beṉ' lao Jesúza' gollgake'ne' ka ben Pilátona' bene' mandad betgake' baḻ beṉ' Galiléaka' ka chitgake' bayix̱'ka' choe'la'ogake' Chioza'. Na' xc̱hene'ka' biyakan toz kon xc̱hen bayix̱'ka' betgake'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Na' che' Jesúza' ḻegake': ―¿Achakile beṉ' Galiléaka' betgake' nakchgake' beṉ' malch aga ka nochlə beṉ' wlall c̱he'ka'? ");
INSERT INTO zadNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nia' le' bi nakan ka'. Shi le' bi yiyaj yilenile dii malka' chonle, ḻekzka' yog'le kwiayi'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Shera beṉ' Jerusalénka' shiṉ'shoṉə, beṉ'ka' wit daa bdakwgake' yoo siba' daa zoa Siloéna', ¿achakile' napchgake' doḻ' aga ka beṉ' wlall c̱he'ka'? ");
INSERT INTO zadNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nia' le' bi nakan ka'. Na' shi le' bi yiyaj yilenile dii malka' chonle, ḻekzka' yog'le kwiayi'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Na'ch bzoa Jesúza' to jempl, chi'e beṉ'ka': ―To beṉ' zoa to yag yix̱wew lo yell-lio c̱he'na' gana' naze' yag uvaka', na' wyaje' jawie' shi llian yix̱wewa', na' ka blline' ni tlish' bi llian. ");
INSERT INTO zadNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Na'ch chi'e beena' chap yell-lio c̱he'na': “Ba gok shoṉ yiz chidwia' shi llian yix̱wewa', na' ni to bibi chbian. Bc̱hogchoklan, ḻa' nḻanchokzan yell-lioni.” ");
INSERT INTO zadNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Na' beena' chape' yell-lio c̱he'na' chi'e: “X̱an', zi' zoashkin zi twiz na' wc̱heeṉ' xaninna' na' wlla'n ben'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Shera shicholə wbian. Na' shi bi wlliakzan, na' wc̱hogo'n.” ");
INSERT INTO zadNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na' to lla sabd, llana' chombaaṉ beṉ' Israelka', chli' chsedi Jesúza' beṉ'ka' chdop chllag gana' choe'ḻwillgake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na' len to noolə ba gok shiṉ'shoṉ yiz nḻew dii x̱iwaa ḻe', na' bichkzə gok yizie' shḻi. ");
INSERT INTO zadNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Na' ka ble'i Jesúza'ne' wṉie'ne' na' golle'ne': ―Noolə, ba bikwas yillwe' c̱ho'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Na'ch bx̱oa neena' koll' noola' na' katena' lii bizetie' shḻicha, na' wzoloe' choe'lawee Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Na' beena' chgoo xṉezi c̱heyi diika' chongake' gana' chdop chllaggake' bllee daa biyon Jesúza' noola' llana' chombaaṉgake', na'ch chi'e beṉ'ka' lle' na': ―De x̱op lla goncho llinna', na' bittezə llaka' yidle kwenc̱he yiyakile, na' bi gonle lez yiyakile' llani chombaaṉcho. ");
INSERT INTO zadNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Na'ch che' X̱ancho Jesúza' ḻegake': ―Le' beṉ' wxiye', ¿abi wsell-le gooṉ c̱heleka' wa burr c̱heleka' lljaweejlegakb nisa' llani chombaaṉcho? ");
INSERT INTO zadNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nooli nake' xiiṉ dia c̱he dii Abrahama', na' ba gok shiṉ'shoṉ yiz Satanáza' daa chṉabia' dii x̱iw'ka' nonan ḻe' ka beṉ' nc̱heje'. ¿Ana' chakile bi nakan wen biyonee llani chombaaṉcho? ");
INSERT INTO zadNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Na' ka goll Jesúza' ka', yog' beṉ'ka' chakzbangakile'ne' biyii bido'gakile', na' yog' beṉ'ka' sto bibagakile' daa ble'gakile' yeḻ' wakka' chone'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Na'ch wna Jesúza': ―¿Nakra ka nak yeḻ' wṉabia' c̱he Chioza', lla? Na' ¿bera ka wsaklebida'n? ");
INSERT INTO zadNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Zaklebin sa mostásana' daa goz to beṉ' lo yell-lio c̱he'na', na' ka bla'n na' bgolan gokan to yag xen na' ax̱t byiṉdo'ka' ben lillbka' lo xoziinna'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Na' ḻekzka' chize' Jesúza': ―Dga sto wsaklebida'n yeḻ' wṉabia' c̱he Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Zaklebin levadúrana' daa chc̱hix̱ to noolə shoṉa rob yezj kwenc̱he yisgolan kwa c̱he yetxtila'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Shlak ziyaj Jesúza' Jerusalénna', bidie' yell yeḻka' na' yelldo'ka' na' bli' bsedile' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na' bchej to beṉ' wṉabile'ne', chi'ene': ―Maestro, ¿ato c̱hopchga beṉ' yila bi kwiayi'gake'? Na'ch che' Jesúza'ne': ");
INSERT INTO zadNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Ḻi gon byen sho'le cho'a puert daa nak diido'zə kwenc̱he soalenle Chioza'. Ḻa' beṉ' zan gaklall'gake' sho'gake'n, na' bi gak sho'gake'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Na' ka solla' x̱an yoona' wseje' puerta', na' le', igaaṉle cho'a puerta' wtankwle ḻe'inna' na' ye'lene': “Beṉ'do', bsaljgach kwenc̱he sho'nto'.” Na' x̱an yoona' iṉe' le': “Bi nombi'a le' ni bi ṉezid' ga beṉ' le'.” ");
INSERT INTO zadNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Na'ch ye'lene': “Weej wdaolennto' li' txen, na' bli' bsedilo' neto' yell c̱hento'na'.” ");
INSERT INTO zadNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Na'ch iṉe' le': “Bi nombi'a le', ni bi ṉezid' ga beṉ' le'. Ḻi lljayaak do na'lə yog'ḻoḻ-le le' beṉ' wen dii mal.” ");
INSERT INTO zadNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Na' kwellchgale ax̱t gaox̱ax̱j ḻeylena' daa ḻe gakshejlall'le ka ile'ile dii Abrahama', dii Isaaca', dii Jacoba' na' yog' dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' lle'gake' yabana' gana' chṉabia' Chioza', na' le', bi gok yiyoole. ");
INSERT INTO zadNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Na' wde wdeli beṉ' lle' zbii zkaaṉ yell-lioni yillingake' yabana' gana' chṉabia' Chioza' na' kwe'gake' gaogake'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na' baḻ beṉ' bi nak beṉ' zakii ṉaa gakgake' beṉ' zakii, na' beṉ'ka' nak beṉ' zakii ṉaa bich gakgake' beṉ' zakii. ");
INSERT INTO zadNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Na' lo llana'tezə bllin baḻ fariseoka' kwit Jesúza' na' che'gake'ne': ―Biyaj gan yoblə. Cheeni Heródeza' wite' li'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Na' che' Jesúza' ḻegake': ―Ḻi yiyaj na' ḻi lljayell beṉ' wxiye'na': “Nin soa' to c̱hop shoṉ lla kwenc̱he yibej' dii x̱iw'ka' yoo beṉ' na' yiyon' beṉ' bi shao', na' sheelo diika' chon'.” ");
INSERT INTO zadNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Chonan byen kooch' nez ṉaa, wx̱e len willj kwenc̱he yiyaa Jerusalénna' gana' chitgake' beṉ'ka' chyix̱jee daa che' Chioza', ḻa' agagaṉ' witgake' ḻegake' gan yoblə. ");
INSERT INTO zadNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Le' beṉ' Jerusalén, chitle beṉ'ka' chidtix̱jee daa che' Chioza' ḻegake', na' yaja' chitile beṉ'ka' chseḻee choe'gake' cho'a xtilleena'! Dii zan shii goklallaa yitop' le' ka chon jeda' chiyellb xiiṉdobka' xan x̱ilba', na' le' bi goonile'. ");
INSERT INTO zadNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ḻi koo yic̱hjle dga iṉia' le', Chioza' kwej yic̱hje' gani zoale. Na' nia' le', aga wle'chile nad' ax̱t kat'ch illin lla iṉale: “¡Gaklenshga X̱ancho Chioza' beeni ba bseḻee!” ");
INSERT INTO zadNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","To lla sabd, llana' chombaaṉ beṉ' Israelka', wyaj Jesúza' jtawe' lill to fariseo, beṉ' chṉabia', na' fariseoka' sto chinaḻ' chinogake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na' lawe'na' ze to beṉ' yo'e yi. ");
INSERT INTO zadNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na'ch Jesúza' wṉabile' fariseoka' na' beṉ'ka' chli' chsedi leya', chi'e ḻegake': ―¿Ade lsens yiyoncho to beṉ' bi shao' llani chombaaṉcho, anti bi den? ");
INSERT INTO zadNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Na' ḻegake' bikzə bi gollgake'ne'. Na'ch Jesúza' bex̱ee beena' yoo yina' na' biyone'ne', na' golle'ne': ―Wak yiyajo'. ");
INSERT INTO zadNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Na'ch chi'e fariseoka': ―Shi to burr c̱hele wa to gooṉ c̱hele ixopb to ḻoo yech to lla chombaaṉcho, ¿abi yibejleb katena' ḻa'kzi nakan llana' chombaaṉcho? ");
INSERT INTO zadNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na' bikz bi billel-lall'gake' ye'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na' ble'i Jesúza' ka chon beṉ'ka' wdaolene' lill farisewa', wche'gake' gana' chbe' beṉ'ka' zakii. Na'ch bseesee to jempl, chi'e ḻegake': ");
INSERT INTO zadNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Kat' no gax le' to ga chak wishagna', bi kwe'le gana' chbe' beṉ'ka' zakii. Ḻa' shera shi ila' beṉ' zak'chi ka le', ");
INSERT INTO zadNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","na' beena' goxe' le' iṉe': “Wzolla' kwenc̱he kwe' beeni gani chi'o.” Na'ch do chido'zile yizolla'le na' lljache'le xanteyin. ");
INSERT INTO zadNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Na' bi gonle ka'. San kat' no gax le', chiyaḻ' lljc̱he'le xanteyin kwenc̱he kat' ila' beena' goxe' le' na' iṉe': “Bish'dawaa, nilə wda kwi'o gani zak'chi.” Na' ka' sho'le balaaṉ lao beṉ'ka' chi'lenle cho'a mesa'. ");
INSERT INTO zadNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ḻa' beena' chon kwine' beṉ' choo beṉ' xen, Chioza' gone'ne' beṉ' bibi zakii; na' beena' chakile' bibi zakee, Chioza' gone'ne' beṉ' choo beṉ' xen. ");
INSERT INTO zadNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Na' ḻekzka' che' Jesúza' beena' goxe'ne' lille'na': ―Kat' cheenilo' wwawo' beṉ', bi gaxo' beṉ' zoalenzo' wen, no beṉ' bishoo, no beṉ' dialla c̱ho', ni no beṉ' wlill c̱ho', beṉ' nake' beṉ' wni'a, ḻa' ḻegake' ḻekzka' wak yigoogake' wzonna' yiwaogake' li' ka beno' c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Aga kan' gono', san byi beṉ' yesh', beṉ' net ṉi'a nee, beṉ' bi chak sa' wen na' beṉ' lc̱hoḻ. Beṉ'kan' chiyaḻ' gaxo', ");
INSERT INTO zadNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","na'ch so' mbalaz. Ḻa' beṉ'kan' aga wak yigoogake' wzon c̱ho', san Chiozan' yigwee wzon c̱ho'na' llana' kat' yisbane' beṉ' wenka' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na' to beena' chi'lene' Jesúza' cho'a mesa', ka benile' wne' ka', na' chi'ene': ―¡Chakomba beṉ'ka' lljadaogake' gana' chṉabia' Chioza'! ");
INSERT INTO zadNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Na'ch che' Jesúza'ne': ―Wzoa to beṉ' bene' to lṉi xen, na' goxe' beṉ' zan kwenc̱he shajgake' lille'na' lljtaogake'. ");
INSERT INTO zadNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na' ka goḻ' gaogake', bseḻee to wen llin c̱he'na' jelle' beṉ'ka' ba bye': “Ḻi dagach, ḻa' ba gok daa gaocho.” ");
INSERT INTO zadNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Na' yog' beṉ'ka' jaṉie' wzologake' chc̱he'gake' dill'. Toe' golle'ne': “Zi' bizi'a lat' yell-lio na' chonan byen lljawia'n. Ye'gacho'ne' si'xene' bi gak yid'.” ");
INSERT INTO zadNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Na' beena' sto chi'ene': “Zi' bizi'a gay' kwe' gooṉ na' chonan byen wwia' shi wak gaaṉgakb. Ye'gacho'ne' si'xene' bi gak yid'.” ");
INSERT INTO zadNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na' beena' sto chi'ene': “Zi' bshagna', na' bi gak yid'.” ");
INSERT INTO zadNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Na'ch biza' wen llinna' jayelle' x̱ane'na' yog' daa goll beṉ'ka' ḻe'. Na'ch bllaa x̱ane'na' na' chi'e wen llin c̱he'na': “Ḻobe' jta lyell na' bc̱he' kon no beṉ' yillago', no beṉ' yesh', no beṉ' net ṉi'a nee, no beṉ' lc̱hoḻ, na' no beṉ' bi chak sa' wen.” ");
INSERT INTO zadNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Na' ka jasane' beṉ'ka' jatope', na'ch chi'e x̱ane'na': “X̱an', ba ben' ka wno', na' ni dech latj sho' beṉ'.” ");
INSERT INTO zadNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Na'ch che' x̱ane'na': “Wyaj do yawi nezka' na' ben byen yid beṉ'ka' yillago' kwenc̱he yilla' ḻoo lilla'ni. ");
INSERT INTO zadNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na' nia' le', ka nak beṉ'ka' bya' dii nech, ni toe' bi gaogake' daa ba bsini'a.” ");
INSERT INTO zadNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Beṉ' zan zjanogake' Jesúza', na'ch biyec̱hje' chi'e ḻegake': ");
INSERT INTO zadNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Shi nole cheeni gakle nad' txen, chiyaḻ' gakchile nad' aga ka x̱axṉa'le, xool-le, xiiṉle, beṉ' bish'le, beṉ' zanle, na' ax̱t yeḻ' mban c̱helena'. Shi bi gakile' nad', aga wak gakle nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na' ḻekzka' beena' bi chzanile' yeḻ' mban c̱he'na', gak bittezə dii gak c̱he', kwenc̱he gone' daa chazlallaa, aga wak gake' nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Shi nole cheenile gonle to yoo sib wal, zigaate chiyaḻ' wwiale ka'k' gaki na' shi waki xmechlena' sheeloin. ");
INSERT INTO zadNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ḻa' shi ba wlekwle leninna' na' tena' bich bi de wzeeloilen, na' yog' beṉ'ka' ile'gakile' bi biyollan wxillgakile' le'. ");
INSERT INTO zadNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Na' iṉagake': “Kon wdishj beena' len yoona' na' bi goki xmeche'na' wzeeloe'n.” ");
INSERT INTO zadNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Na' ka'kz to beṉ' wṉabia', shi cheenile' tiḻ-lene' sto wṉabia' yoblə, na' ḻekzka' chiyaḻ' wsakee shi wzoi shi mil beṉ'ka' nape' tiḻ-lengake' beena' nap gaḻja mil beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na' shi gakbe'ile' bi soi beṉ'ka' nape', na' zi' illinlə beṉ' wṉabia'na' sto, wseḻee to c̱hop beṉ' lljellgake'ne': “Bizə tiḻcho.” ");
INSERT INTO zadNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Na' ka' le', shi bi c̱hooṉlall'le yog' dii de c̱hele, aga wakə gakle nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Zedaa nakan dii wen, na' shi bich zxi'n aga wakch yiyonchon zxi' dii yoblə kwenc̱he wc̱hinchon. ");
INSERT INTO zadNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ni bi gak wc̱hinchon lwaa ben', san c̱hooṉchon. Na' le' chenile dga nia', ḻi sen wṉeyi. ");
INSERT INTO zadNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yog' beṉ' wic̱hixjka' na' beṉ' saaxyaka' jabig'gake' kwit Jesúza' kwenc̱he bzenaggake' dillaa cho'e. ");
INSERT INTO zadNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Na' fariseoka' na' beṉ'ka' chli' chsedi leya' wzologake' biz chon chnagake' c̱he Jesúza', che'gake': ―Chlebtezə beeni beṉ' saaxyaka' na' chaolenteze' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Na'ch bzoa Jesúza' to jempl, golle' ḻegake': ");
INSERT INTO zadNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Shi tole naple to guiyoa xil' na' ṉit tob, na' wkwaaṉle baka' taplalj twaḻj lyix̱aa na' lljadiljle bana' wnit, na' ax̱t kon ka yillelb gonle. ");
INSERT INTO zadNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na' ka yillelb, yibaile yix̱oaleb yaaxizlena'. ");
INSERT INTO zadNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Na' ka yillinle lill-lena' wtople beṉ'ka' nllaguile na' beṉ' wlill c̱heleka', na' ye'le ḻegake': “Ḻi yibaleni nad', ḻa' ba billel xil' c̱ha'na' bana' wnit.” ");
INSERT INTO zadNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na' nia' le', ka'kzan chibayi Chioza' len anjl c̱he'ka' yabana' kat' to beṉ' wen dii mal chiyajile' saaxya c̱he'na' aga ka taplalj twaḻj beṉ'ka' bi chonan byen yiyajgakile'. ");
INSERT INTO zadNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Wa shi to noolə de shi mech plat c̱he' na' ṉit ton, na' wxene' yi' c̱he'na' na' wḻoe' ḻoo lille'na' na' yiyilje'n ax̱t ki yillelile'n. ");
INSERT INTO zadNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na' ka yillelile'n na' wtope' noolka' nllaguile' na' beṉ' wlill c̱he'ka', na' yee ḻegake': “Ḻi yibaleni nad', ḻa' ba billel mech c̱ha'na' daa wnit.” ");
INSERT INTO zadNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na' nia' le', ka'kzan chibayi Chioza' len anjl c̱he'ka' kat' chiyaj chileni to beṉ' saaxya. ");
INSERT INTO zadNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Na' ḻekzka' che' Jesúza' ḻegake': ―To beṉ' wzoa c̱hop xiiṉe', ");
INSERT INTO zadNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","na' bi' neshaa gollb' x̱abaa: “X̱a, bḻaa daa de c̱ho' na' beṉ nad' daa chiyaḻ' ikaa.” Na'ch bḻaa x̱abaa daa de c̱he' na' bi'en ḻegakb'. ");
INSERT INTO zadNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Na' aga wlla, biyit' bide bi' neshaa daa bi'eb', na' mecha' daa bex̱'b' c̱heyin wyajlema'n to yell zit' na' jenditjba'n na' jem' kon daa nazan c̱heb'. ");
INSERT INTO zadNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Na' ka biyoll benditj xmechbaa wche' to wbiṉ xen yella' gana' chdab', na'ch wzolo chdeb' wbinna'. ");
INSERT INTO zadNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Na' wyajb' jaṉabb' llinna' gom' lao to beṉ' yella' gana' chdab', na' beena' bseḻeeb' lyix̱aa gana' nllee kushka' kwenc̱he jtapb' ḻegakb. ");
INSERT INTO zadNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na' daa ḻe chdom' goklall'b' gaob' daa chao kushka', na' ni ḻen bi be'gake'b'. ");
INSERT INTO zadNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Na' gokib': “Beṉ' zan wen llin c̱he x̱a'na' lle' na' chichooṉzan dii cheej chaogake', na' nad', ba chetid' wbinni. ");
INSERT INTO zadNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ba ziyaachoklə kwit x̱a'na' na' yepee: X̱adawaa, ba bx̱iṉj' bḻen' lao Chioza' na' lawo'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Bich chidoḻaa gak' xiiṉo', san beni nad' ka nottezə wen llin c̱ho'ki.” ");
INSERT INTO zadNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Na'ch biza'b' ziyajb' lill x̱abaa. ’Na' zi dii xench yillim' lillbaa ble'i x̱abaa ḻeb' na' biyesh'lallile'b'. Na'ch zejdoe' jatiḻe'b' na' wdeḻe'b' na' bnope'b'. ");
INSERT INTO zadNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Na'ch che'b' x̱abaa: “X̱adawaa, ba bx̱iṉj bḻen' lao Chioza' na' lawo'na', bich chidoḻaa gak' xiiṉo'.” ");
INSERT INTO zadNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Na' x̱abaa chi'e wen llin c̱he'ka': “Ḻobe'zə ḻi lljḻej tgot lech' daa ḻiizelozi nakch na' ḻi wwakwba'n, na' ḻekzka' ḻi wllin to niy xbemaa na' ḻi wllin yel ṉi'abaa. ");
INSERT INTO zadNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Na' ḻi lljx̱i' me'do'na' mbejchlawin, ḻi witb kwenc̱he gaochob na' goncho to lṉi, ");
INSERT INTO zadNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ḻa' xiiṉdawaani gok c̱heb' ka bi' ba wit, na' ṉaa ba bila'b' mbam'. Gok c̱heb' ka bi' wnit, na' ṉaa ba billelb'.” Na'ch wzologake' bengake' lṉina'. ");
INSERT INTO zadNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Na' ka wzolo lṉina', xiiṉe' bi' necha' chdab' lyix̱aa. Na' ka billim' gaozə lillbaa, benib' chkwell wikwellka' na' chakte wiyaana'. ");
INSERT INTO zadNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Na'ch wṉeb' to wen llinka' na' wṉabibee bin chak lillbaa. ");
INSERT INTO zadNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Na' wen llinna' chi'e: “Bi' bishoonan' ba bila', na' ben x̱o'na' mandad betgake' me'do'na' mbejchlawin daa bila'b' shi'a shao'.” ");
INSERT INTO zadNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Na' xiiṉe' bi' necha' bllaab' na' bi goonib' yiyoob'. Na'ch bchej x̱abaa got'yoile'b' kwenc̱he yiyoob'. ");
INSERT INTO zadNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Na'ch che'b' x̱abaa: “Ṉezkzilo' ba gok zan yiz chon' yog' daa no', na' ni shlin biṉ' c̱hishj' cho'a xtilloona'. Na' bigaṉ' goṉo' nad' ḻa'c̱h' to shibdo' kwenc̱he wit'b yeej gaolem' bi'ka' nllaguid'. ");
INSERT INTO zadNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Na' ṉaa bila' xiiṉo'ni biyit' bideb' yog' daa bi'ob' na' benditjb' xmecho'na' kon noolə wdaka', na' ba betzo' me'do'na', bana' ḻe nak, ni c̱heb'.” ");
INSERT INTO zadNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Na'ch che' x̱abaa: “Xiiṉdawaa, li' zoaleno' nad' toshiizi, na' yog' bi de c̱ha' c̱hekzo' daa. ");
INSERT INTO zadNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Per chonan byen ṉaa yibaicho na' goncho lṉini, ḻa' ba bila' bi' bishooni. Ba gok c̱heb' ka bi' ba wit, na' ṉaa ba bila'b' mbam'; gok c̱heb' ka bi' wnit, na' ṉaa ba billelb'.” ");
INSERT INTO zadNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Na' ḻekzka' goll Jesúza' beṉ'ka' nakgake'ne' txen: ―Wzoa to beṉ' wni'a nape' to wen llin c̱he', na' bene' lo nee yog' dii de c̱he'. Na' wyaj baḻ beṉ' jellgake'ne': “Ḻe chonditj beena' daa beno' lo nee.” ");
INSERT INTO zadNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Na'ch wṉe x̱ane'na' ḻe', chi'ene': “Ba benid' ka nagake' chono', na' chiyaḻ' yidio' kwent diika' ngoo lo no', ḻa' bich goṉ' xshino'na'.” ");
INSERT INTO zadNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Na'ch chaki wen llinna': “¿Nakra gona'n ṉaa, bich goṉ x̱an'na' llinna' gon'? Bi soid' gon' llin wal, na' chido'id' yep' beṉ' yiyesh'gakile' nad' goṉgake' lat' wej xmech'. ");
INSERT INTO zadNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ba ṉezid' nak gon' kwenc̱he wleb beṉ' nad' lille'ka' kat' bich gat' llin c̱ha'na'.” ");
INSERT INTO zadNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Na'ch goxe' to to beṉ'ka' chaḻ'gake' c̱he x̱ane'na', na' beṉ' necha' wṉabile'ne', chi'ene': “¿Ka'k' chaḻoo c̱he x̱an'na'?” ");
INSERT INTO zadNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Na' beena' chi'e: “Chaḻaa to guiyoa medid set.” Na'ch chi'ene': “Ni de yisha', ḻobe'zə wche' na' bda'n shiyonzannan' chaḻoo.” ");
INSERT INTO zadNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Na' ka wde, wṉabile' beena' sto, chi'ene': “¿Shera li'? ¿Ka'k' chaḻoo?” Na' beena' chi'ene': “Chaḻaa to guiyoa gush trigo.” Na'ch chi'ene': “Ni de yisha' na' bda'n taplaḻj gushzannan' chaḻoo.” ");
INSERT INTO zadNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Na' x̱an wen llinna' be'lawee wen llin mal c̱he'na' daa biyiljlallee naklan gone'n. Ḻa' beṉ'ka' zech wṉeyi c̱he daa chak lo yell-lioni, chiyiljlall'chgake' nak soalen ljwellgake' wen kwenc̱he ile'shii ljwellgake', aga ka beṉ'ka' ba yoo beeni' c̱he Chioza' ḻoo yic̱hjlall'do'eka'. ");
INSERT INTO zadNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Na' nia' le', ḻi wc̱hin yeḻ' shawaa de c̱hele yell-lioni kwenc̱he gaklenle beṉ', na' kat' ba wde c̱he yeḻ' shawaa, Chioza' wlebe' le' soalenlene' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Na' beena' chon ka chiyaḻ' kon lat' daa nak lall' nee, ka'kzan gone' shi bichlə dii xench koo lall' nee. Na' beena' bi chon ka chiyaḻ' kon daa nak lall' nee, ka'kzə gone' shi bitekchlə dii xench koo lall' nee. ");
INSERT INTO zadNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Shi bi chonle ka chiyaḻ' kon yeḻ' shawaa de yell-lioni, bi gonzle lez ikaale yeḻ' shawaa de yabana'. ");
INSERT INTO zadNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na' shi bi chonle ka chiyaḻ' kon yeḻ' shawaa nak lall' na'le yell-lioni, ¿nakra gon Chioza' goṉe' le' yeḻ' shawaa daa gaki c̱hele? ");
INSERT INTO zadNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Aga ga zoa to beṉ' wḻane' xshin c̱hop beṉ', ḻa' wakzbanile' beena' to, na' gakchile' beena' sto, wa gone' xshin beena' to do lallee na' xshin beena' sto gone'n nakzi. Aga wak gonle ka cheeni Chioza' shi ḻe chzelall'le yeḻ' wni'ana'. ");
INSERT INTO zadNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Na' fariseoka' ḻe chzelall'gake' mecha', na' ka bengakile' dillaa choe' Jesúza', bxillgakile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Na'ch che' Jesúza' ḻegake': ―Ḻa'kzi nale nakle beṉ' wen, Chioza' ṉezile' nakan nak yic̱hjlall'do'lena'. Ḻa' daa chaki beṉ' yell-lioni nakan dii llialote, ḻeyeṉ'lannan' chakzbani Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Na' ḻekzka' che' Jesúza': ―Leya' na' daa bli' bsedi dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake', ḻegakannan' wṉabia'gakan ax̱t ka bllin lla bid Juanna'. Na' ka bid Juanna', wzolo chzenag beṉ' dill' wen dill' kob c̱he yeḻ' wṉabia' c̱he Chioza', na' chongake' to dii byen kwenc̱he iṉabi'e ḻoo yic̱hjlall'do'eka'. ");
INSERT INTO zadNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Dii ḻi nia' le', ḻobe'ch te c̱he yabana' len yell-lioni, aga ka daa tegonz shc̱ho'a daa na leya'. ");
INSERT INTO zadNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Shi to beṉ' byo yiḻee xoole'na' na' yikee noolə yoblə, chone' ka chon beena' zoate nool c̱he'na' na' chdalene' noolə yoblə. Na' beena' yikee noola' biḻaa beṉ' c̱he'na' ḻe', ḻekzka' chone' ka chon beena' zoalente nool c̱he'na' na' chdalene' noolə yoblə. ");
INSERT INTO zadNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Na' chize' Jesúza' beṉ'ka': ―Wzoa to beṉ' wni'a na' chakwe' shgaḻ' lech' dii wen na' yog' lla chaoshawe'. ");
INSERT INTO zadNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na' ḻekzka' wzoa to beṉ' yesh' wlie' Lázaro, na' llia we'na' doxen kwerp c̱he'na'. Na' tlizi chjc̱hi'e cho'a yoo c̱he beṉ' wni'ana', ");
INSERT INTO zadNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","gokile' gawe' ḻa'c̱h' bḻaaka' chxop xan mes c̱he'na', na' ax̱t bekw'ka' chḻeegakb we'na' llie'. ");
INSERT INTO zadNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Na' bllin lla wit beṉ' yeshaa, na' bic̱he' anjl c̱he Chioza'ne' kwenc̱he jazoalene' dii Abrahama'. Na' ḻekzka' wit beṉ' wni'ana' na' bkwash'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Na' dii beṉ' wni'ana' chdezi'chgue' gana' lle' beṉ' wetka', na' bḻis jalawe'na' na' zit'lə ble'ile' dii Lázarona' chi'e kwit dii Abrahama'. ");
INSERT INTO zadNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Na'ch wṉie' zilljə chi'e: “X̱adawaa Abraham, biyesh'gachi nad' na' bseḻ' Lázarona' kwenc̱he wḻeejlat' xbene'na' ḻoo nisa' na' yidshone'n lo ḻollaani, ḻa' ḻe chllaglochgan' lo yi'ni.” ");
INSERT INTO zadNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Na' Abrahama' chi'ene': “Xiiṉ, jadini ka mbalaz gok c̱ho' shlak wbano' yell-liona', na' Lázaroni aga bi dii wen gok c̱he'. Na' ṉaa chizi'e banez ni, na' li' chzak'zi'o. ");
INSERT INTO zadNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Na' ziznakan sto, ze to bdiṉj xen gchoḻi, na' aga wak te beṉ'ki yidgake' gana' lle'le, na' beṉ'ka' lle' na' aga wak tegake' yidgake' gani zoanto'.” ");
INSERT INTO zadNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Na'ch che' beṉ' wnia'na'ne': “Chṉabid' li' shka', x̱adawaa Abraham, ben goklen bseḻ'gach Lázarona' lill x̱a'na' ");
INSERT INTO zadNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","gana' zoa zi gay' beṉ' bishaaka', llje'lene' ḻegake' dill' kwenc̱he bi lengake' yiyedgake' gani de yeḻ' zak'zi'ni.” ");
INSERT INTO zadNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Na' Abrahama' chi'ene': “Napkzgake' daa bzej dii Moiséza' na' daa bzej dii beṉ'ka' wdix̱jee daa goll Chioza'. ¡Na' chiyaḻ' wzenaggake'n!” ");
INSERT INTO zadNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Na' che' beṉ' wnia'na'ne': “Aga wakan, x̱adawaa Abraham, san sheḻ' to beṉ' ba wit yibane' na' yiyaje' lljaye'lene' ḻegake' dill', na' wiyaj wilengakile' saaxya c̱he'ka'.” ");
INSERT INTO zadNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Na' che' Abrahama'ne': “Shi bi chzenaggake' daa bzej dii Moiséza' na' daa bzej dii beṉ'ka' wdix̱jee daa goll Chioza', ḻekzka' aga wyajḻe'gake' ḻa'kzi yiban to beṉ' wet.” ");
INSERT INTO zadNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Na'ch che' Jesúza' beṉ'ka' nakgake'ne' txen: ―Bia'kzə de dii gon ka ixop beṉ' gone' dii mala', per ¡nyesh'laz gak c̱he beena' wchix̱e' beṉ' yoblə gone' dii mala'! ");
INSERT INTO zadNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wenlan sheḻ' wwaḻ'gake' yene'na' to yaj c̱he molin na' lljazaḻ'gake'ne' ḻoo nisdo'na' aga ka daa wchix̱e' to beṉ'ki chajḻe'gake' c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Daan, ḻi wsak'. ’Shi to bish' ljwell-le gone' mal c̱hele, ḻi wsheshlene', na' shi yiyajile' daa bene' c̱hele, ḻi yizi'xen c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ḻa'kzi ax̱t gall shii shlla gone' bi gone' c̱hele, na' gall shiite iṉe' le': “Chiyajid' daa ben' c̱ho'”, chiyaḻ' yizi'xenle c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na'ch goll postlka' X̱ancho Jesúza': ―Goklen neto' gonḻilall'chnto' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Na'ch che' X̱ancho Jesúza' ḻegake': ―Sheḻ' yeḻ' chajḻe' c̱helena' nakan ḻa'c̱h' ka nak sa mostásana', daa nak diido'zə, wak ye'le yag xen wala': “Blall'shki, na' jsoa ḻoo nisdo' na'lə”, na' gon yaga' daa ye'len, sheḻ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Shi nole zoa to wen llin c̱hele na' zizee lyix̱aa jawaaṉe' gooṉna' wa jtapeeb, aga we'lene': “Biyoo, na' wche' kwenc̱he gawo'.” ");
INSERT INTO zadNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aga we'lene' ka', san ye'l-lene': “Bsini'a daa gaw' xshe'na', na' wze wṉeyi kwenc̱he wdio' daa yeej gaw', na'techlə yeej gawo'.” ");
INSERT INTO zadNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Na' ni bi we'lene' yeḻ' chox̱ken daa ba bene' daa che'lene' gone'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ḻekzka' le', kat' ba biyoll benle yog' daa non Chioza' mandad gonle, chiyaḻ' iṉale: “Neto' bi chizo chizakinto' gonnto' yog'ḻoḻten, shinchga bizointo' ba bennto' daa chonan byen gonnto'.” ");
INSERT INTO zadNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na' shlak zjada Jesúza' Jerusalénna', wdie' gana' ndiḻ yell-lioka' mbani Samáriana' na' Galileana'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Na' ka blline' to cho'a yelldo', bllesh shi beṉ' chakgake' yillwe' daa le lepra kwenc̱he lljatiḻgake'ne', na' de zit'lə wzegake' ");
INSERT INTO zadNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","besyaagake' zilljə, che'gake'ne': ―¡Jesús, Maestro, biyesh'lall'gachi neto'! ");
INSERT INTO zadNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Na' ka ble'i Jesúza' ḻegake', na' golle': ―Ḻi shaj lao bx̱ozka' kwenc̱he ile'gakile' le'. Na' shlak zejgake' bigaa yillwe' c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Na'ch toe' bibi'e ka gokbe'ile' ba biyakile', na'ch ax̱t chosya'ile' choe'lawee Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Na' bc̱hek' xibe'na' lao Jesúza' na' bdose' lo yona' kwenc̱he bi'ene' yeḻ' chox̱ken. Na' beena' ben ka' nake' beṉ' Samaria. ");
INSERT INTO zadNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Na'ch che' Jesúza': ―¿Aaga shigaken' biyaki? ¿Garaṉ beṉ'ka' zi ga? ");
INSERT INTO zadNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Atochga beṉ' zitiin bibi'e choe'lawee Chioza'? ");
INSERT INTO zadNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Na'ch che' Jesúza' beena': ―Bizolla' na' biyaj. Ba biyakilo' daa wyajḻi'o c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Na'ch wṉabi fariseoka' Jesúza' batran solo iṉabia' Chioza' lo yell-lioni. Na' chi'e ḻegake': ―Ka nak yeḻ' wṉabia' c̱he Chioza', aga nakan ka to dii ile'tekzicho. ");
INSERT INTO zadNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Aga no iṉa: “Ni chṉabia' Chioza'”, wa “Na' chṉabi'e”, ḻa' ladjlenikzan ba bla' yeḻ' wṉabia' c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Na'ch chi'e beṉ'ka' nakgake'ne' txen: ―Wllin lla kat' gaklall'le ḻa'c̱h' zi shlla ile'chile iṉabi'a, nad', Beṉ' Bseḻ' Chioza' Yell-lioni, na' aga wle'chile nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Na' ichej beṉ' iṉe': “Ni zoe'”, wa “Na' zoe'.” Na' bi shajle, ni bi gonle beṉ'ka' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ḻa' ka chak kat' chep yes, chzeeni'n doxen xan yabana', ka'kzan gak llana' kat' zizaa, nad', Beṉ' Bseḻ' Chioza' Yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Na' chonan byen zigaate biya daa yen ile'id', na' beṉ'ki zoa ṉaa wzoagake' nad' ka'lə. ");
INSERT INTO zadNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kon ka gok kana' wzoa dii Noéna', ka'kzan gak kat' ba zoa illin lla yiyed' dii yoblə, nad', Beṉ' Bseḻ' Chioza' Yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kana' wzoa dii Noéna', beṉ' yell-lioka' cheej chaogake', chshagna'gake', na' choe'gake' yeḻ' wishagna' c̱he xiiṉe'ka' bllinte llana' wyoo dii Noéna' ḻoo barkwa'. Na' wzolo chak yejsiwaa yell-lioni ax̱t billa'cha lawinna' nisa', na' blliayi'n yog'ḻoḻe'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Na' ḻekzka' wizak kana' wzoa dii Lota'. Cheej chaogake', chiya'o chidegake' bi de c̱hegake', na' chaz chaaṉgake', na' chon lillgake'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Per ka bchej dii Lota' yell Sodómana', Chioza' bḻetje' yi'na' xan yabana' nc̱hix̱an daa ne' azufre na' betan yog' beṉ' yell Sodómaka'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Na' ka'kzan gak llana' kat' yiyed', nad', Beṉ' Bseḻ' Chioza' Yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Llana' zizaa, shi to beṉ' llie' yic̱hj lille'na' na' xshinḻaze'na' den ḻoo yoo c̱he'na', bi yiyetjze' kwenc̱he lljaleje'n. Na' shi to beṉ' zeje' lyix̱aa, bi yiyajze' lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ḻi lljadini ka gok c̱he dii xool Lota'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Beena' bi chsanlall' yeḻ' mban c̱he'na', beenan' kwiayi'; san beena' chsanlall' yeḻ' mban c̱he'na', beenan' gat' to yeḻ' mban c̱he' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Na' nia' le', lle'na' kat' zizaa, c̱hop beṉ' die' toz blag, toe' yic̱hi'a na' stoe' yigaaṉ. ");
INSERT INTO zadNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Na' gana' lle' c̱hop noolə chotgake', toe' yic̱hi'a na' stoe' yigaaṉ. ");
INSERT INTO zadNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Na' c̱hop beṉ' byo chongake' llin lyix̱aa, toe' yic̱hi'a na' beena' sto yigaaṉe'. ");
INSERT INTO zadNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Na'ch wṉabgakile'ne': ―¿Garan gak dga, X̱an'? Na' chi'e ḻegake': ―Gana' de ba weta', nan' chdop chllag llodka'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Na' bzoa Jesúza' to jempl kwenc̱he bli' bsedile' ḻegake' bi lljshyagakile' we'ḻwillgake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Chi'e ḻegake': ―Wzoa to beṉ' wen yeḻ' josc̱his to yell, na' bi chall chllebe' Chioza', ni bibi chakile' shi bi chiyoolallii beṉ' ka chone'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na' yella' wzoa to noolə wizeb na' chajtezi chaje' lawe'na', chi'ene': “Bensha yeḻ' josc̱his c̱ha'ni.” ");
INSERT INTO zadNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Na' ssha ba gok chaje' lawe'na' na' bikzə chone' bin chi'ene', na' bllin lla kat' chakile': “Ḻa'kzi bi chall chlleb' Chioza' na' ni bibi chakid' shi bi chiyoolallii beṉ' ka chon', ");
INSERT INTO zadNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","gonch' yeḻ' josc̱his c̱he nooli kwenc̱he bich yidyembeguile' nad'.” ");
INSERT INTO zadNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Na' X̱ancho Jesúza' chi'e ḻegake': ―Ḻi wzenag ka ben beṉ' wen yeḻ' josc̱hisa', beena' bi chall chlleb Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Achakile Chioza' bi gaklene' beṉ'ka' ba wleje' nakgake' lall' nee, beṉ'ka' choe'ḻwillgake'ne' ka waḻ ka tella? ¿Awllaile' gaklene' ḻegake'? ");
INSERT INTO zadNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Bi nakan ka', san nia' le' katena' gaklene' ḻegake'. Per kat' zizaa, nad', Beṉ' Bseḻ' Chioza' Yell-lioni, ¿alle'ch beṉ' nonḻilall' nad' yell-lioni, lla? ");
INSERT INTO zadNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Na' bzoa Jesúza' sto jempl c̱he beṉ'ka' chakgakile' nakgake' beṉ' wen lao Chioza' na' chongakile' beṉ' yoblə nakzi. Na' wne': ");
INSERT INTO zadNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―C̱hop beṉ' wyajgake' yoodo'na' kwenc̱he je'ḻwillgake' Chioza'. Toe' nake' fariseo na' beena' sto nake' beṉ' wic̱hixj. ");
INSERT INTO zadNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na' farisewa' zie' chshalj chshon c̱he kwine', chi'e: “Chios c̱ha', chox̱keno' bi chon' ka chon beṉ' yoblə, bi chzi' chban', bi nak' beṉ' wen dii mal, agagaṉ' kwej yic̱hj' nool c̱ha'na' kwenc̱he soalen' nool yoblə, na' ni bi chon' ka chon beṉ' wic̱hixji. ");
INSERT INTO zadNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","C̱hop shii to xman chzoa' wbas', na' lawi yog' daa chon' gan chbej' daa chidoḻoo ikoo.” ");
INSERT INTO zadNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Na' beṉ' wic̱hixja', zit'lə wzie' na' ni bi biyaxjile' wḻis lawe'na' wwie' yabana', san chballee cho'a lc̱ho'ena' chi'e: “¡Chios c̱ha', biyesh'gachi nad' daa nak' beṉ' saaxya!” ");
INSERT INTO zadNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na' nia' le', Chioza' bzenague' c̱he beṉ' wic̱hixja' na' bizee biyaje' lille'na' ba biyakxen saaxya c̱he'na'. San bi bzenague' c̱he farisewa'. Ḻa' beena' chon kwine' beṉ' choo beṉ' xen, Chioza' gone'ne' beṉ' bibi zakii. Na' beena' chakile' bibi zakee, Chioza' gone'ne' beṉ' choo beṉ' xen. ");
INSERT INTO zadNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Na' ḻekzka' beṉ' zan jwa' bi'do' c̱he'ka' lao Jesúza' kwenc̱he bx̱oa neena' yic̱hjb'ka' na' wṉabile' Chioza' gaklene'gakb'. Na' ka ble'i beṉ'ka' nakgake'ne' txen, bsheshlengake' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Na' Jesúza' goxe' bi'do'ka', na' chi'e beṉ'ka' nakgake'ne' txen: ―Ḻi we' latj yid bi'do'ki lawa'ni, bi wllonle, ḻa' Chioza' chṉabi'e ḻoo yic̱hjlall'do' beṉ'ka' nak ka ḻegakb'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Dii ḻi nia' le', beena' bi yiyak yic̱hjlall'do'ena' ka c̱he bi'do'ki kwenc̱he iṉabia' Chioza' ḻe', bi yilline' gana' zoa Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","To beṉ' zakii wṉabile' Jesúza', chi'ene': ―Maestro, li' nako' beṉ' wen. Wna nad' beran chiyaḻ' gon' kwenc̱he gat' to yeḻ' mban c̱ha' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Na'ch che' Jesúza'ne': ―¿Berac̱he nazo' nad' beṉ' wen? Toz Chioza' nake' beṉ' wen. ");
INSERT INTO zadNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ba ṉezkzilo' daa nllia Chioza' bia' goncho: “Bi soaleno' nool bi nak nool c̱ho', bi wito' beṉ', bi kwano', bi c̱hiljlalloo bizə gon iṉo' c̱he beṉ', na' wdap balaaṉ x̱axṉoo.” ");
INSERT INTO zadNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Na'ch che' beena'ne': ― Kana' naktia' bi' xkwid' chon' yog' diika'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Na'ch ka beni Jesúza' ka goll beena'ne', na' chi'ene': ―Stozə daa chyallj gono': jayet' jade yog' daa de c̱ho' na' be'n beṉ' yesh'ka'. Na' shi gono' ka', na' gat' to yeḻ' shao' c̱ho' yabana'. Na' da, dino' nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Na' ka beni beena' ka goll Jesúza'ne', ḻe gokyeshile', ḻa' beṉ' wni'a nlleban'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Na' ka ble'i Jesúza' ḻe gokyeshile', na' chi'e: ―¡Lallj inlleb chonan c̱he beṉ' wni'aka' we'gake' latj iṉabia' Chioza' ḻegake'! ");
INSERT INTO zadNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ḻobe'ch te to kamey xan yeshaa aga ka to beṉ' wni'a yiyo'e yabana'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Na' beṉ'ka' beni, gollgake'ne': ―¿Noran yila shka'? ");
INSERT INTO zadNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Na'ch che' Jesúza' ḻegake': ―Daa bi chak gon beṉec̱ha', Chioza' chak gone'n. ");
INSERT INTO zadNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Na'ch che' Pédrona' Jesúza': ―X̱an', ba wlej yic̱hjnto' yog' dii de c̱hento' kwenc̱he naknto' li' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Na'ch che' Jesúza' ḻegake': ―Dii ḻi nia' le', nottezə beṉ' ba bzanile' no lille', no x̱axṉee, no beṉ' bishee, no beṉ' zane', no xiiṉ xoole' kwenc̱he cho'e latj chṉabia' Chioza'ne', ");
INSERT INTO zadNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Chioza'kzə wi'e dii zak'chi c̱he' yell-lioni aga ka diika' wlej yic̱hje', na' ka yilline' yabana' wi'ene' to yeḻ' mban zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Na'ch wlej Jesúza' beṉ'ka' shlliṉ ka'lə, beṉ'ka' nakgake'ne' txen, chi'e ḻegake': ―Dga ziyajcho Jerusalénna' ṉaa, yillinin daa bzej dii beṉ'ka' wdix̱jee daa goll Chioza' kani'yi daa gak c̱ha', nad', Beṉ' Bseḻ' Chioza' Yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ḻa' gongake' nad' lo na' beṉ'ka' bi nombia' Chioza', na' gonḻegake' c̱ha', biya dii iṉagake' nad', na' wlla' x̱eneeka' nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Na' wit c̱hingake' nad' na'tech witgake' nad', na' yiyoṉ lla yiban' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Na' beṉ'ka' nakgake'ne' txen ni lat' bi wyajni'gakile' daa golle' ḻegake', na' ni bi wṉezgakile' berac̱he chi'e ḻegake' ka', ḻa' daa golle' ḻegake' nakan dii bi gak shajni'gakile'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Na' ka ba chllin Jesúza' yell Jericóna', na' chi' to beṉ' lc̱hoḻ cho'a neza' chṉabile' beṉ' yiyesh'lall'gakile'ne' we'gake' lat' wej xmeche'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Na' ka benile' chde beṉ' zan na'ch wṉabe' bin chak. ");
INSERT INTO zadNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Na' gollgake'ne': ―Jesús, beṉ' Nazaretan', chda ni. ");
INSERT INTO zadNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Na'ch besyee, chi'e: ―¡Jesús, Xiiṉ dia c̱he dii Daví, biyesh'lall'gachi nad'! ");
INSERT INTO zadNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Na' beṉ'ka' llialo lao Jesúza' chsheshlengake'ne' kwenc̱he kwi'e llizə, na' zizikchlə chosyee, chi'e: ―¡Xiiṉ dia c̱he dii Daví, biyesh'lall'gachi nad'! ");
INSERT INTO zadNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Na'ch wlez Jesúza' na' bene' mandad lljx̱i'gake'ne'. Na' ka bllin beṉ' lc̱hoḻa' lawe'na' na'ch wṉabile'ne': ");
INSERT INTO zadNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Beran cheenilo' gon' c̱ho'? Na'ch che' beṉ' lc̱hoḻa'ne': ―X̱an', cheenid' ile'id'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Na'ch che' Jesúza'ne': ―Daa ba chonḻilalloo nad' na' ile'ilo'. ");
INSERT INTO zadNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Na' katena' lii bile'teile', na'ch janoe' Jesúza' choe'lawee Chioza'. Na' yog' beṉ'ka' ble'i daa ben Jesúza' be'la'ogake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Na'ch bllin Jesúza' yell Jericóna' na' wdie' gchoḻ yella'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na' yella' zoa to beṉ' wni'a lie' Zaqueo, na' ngoo lall' nee x̱oṉj wic̱hixjka'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Na' goklallee ile'ile' Jesúza', per bi gok ile'ile'ne' daa nake' beṉ' bc̱hekwdo' na' daa zejlen Jesúza' beṉ' zan. ");
INSERT INTO zadNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Na'ch wllialodoe' lawe'ka' na' wyepe' to lo yag xen kwenc̱he ile'ile'ne' ka tie'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Na' ka bllin Jesúza' xan yaga', na' bḻis lawe'na' chi'ene': ―Zaqueo, btalalloo biyetj, ḻa' lillo'nan' yigaaṉa' ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Na'ch biyetjdo Zaquewa' chibaile' bic̱hi'e Jesúza' lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Na' ka ble'i beṉ'ka' lle' na' ka gok, yog'ze' wzolo biz chon chnagake' c̱he', che'gake': ―Yigaaṉxgale' lill beṉ' saaxyani, na. ");
INSERT INTO zadNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na'ch wzolla Zaquewa' na' chi'e X̱ancho Jesúza': ―X̱an', cheenid' wi'a gashjə daa de c̱ha' beṉ' yesh'ka', na' yog' beṉ'ka' ba bc̱hixj' dii xench, yiyoe'gakee taplə ka daa ba wlan' c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Na'ch che' Jesúza'ne': ―Ṉaanlla ba bisla Chioza' beṉ'ki zoa ḻoo yooni kwenc̱he bi kwiayi'gake', daa len Zaquewi nake' xiiṉ dia c̱he dii Abrahama'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ḻa' ka nak' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, bid' kwenc̱he yiyilj' na' yisla' beṉ'ka' yoo nez daa wlliayi'n ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Shlak chzenag beṉ'ka' daa che' Jesúza', bseesile' ḻegake' to jempl, daa ba zoa illine' Jerusalénna' na' ḻegake' gokgakile' daa nake' beṉ' bseḻ' Chioza' lii solotie' iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Na'ch chi'e ḻegake': ―To beṉ' zakii bcheje' wyaje' to yell zit' wal kwenc̱he lljaḻane' yeḻ' wṉabia' c̱he lalle'na', na' ka yilline' iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Na' ka zi' see, wṉie' shi wen llin c̱he'ka' na' bi'e ḻegake' twej mech dii zak' dii xen na' chi'e ḻegake': “Ni de mechi, ḻi gonlenan delgens shlak bi soa'.” ");
INSERT INTO zadNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Na' beṉ' wlall c̱he'ka' ḻe chakzbangakile'ne', na' ka wde wzee bseḻ'gake' x̱oṉj beṉ' wyajgake' lao beena' we' lsens iṉabi'e kwenc̱he jellgake'ne': “Bi cheeninto' iṉabia' beeni neto'.” ");
INSERT INTO zadNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Per bia'kzə gok lo nee iṉabi'e, na' biyaje' lalle'na'. Na' ka billine' goxe' beṉ'ka' bkwaaṉlene' mecha' kwenc̱he iṉezile' ka'k' wej ben mecha' gan daa bkwaaṉlene' to toe'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Na' ka bllin beṉ' necha' lawe'na' na' chi'ene': “X̱an', xmecho'na' bkwaaṉ'leno' nad' bena'n gan shin.” ");
INSERT INTO zadNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Na'ch beṉ' wṉabia'na' chi'ene': “Wenkzan beno'. Daa beno' ka chiyaḻ' kon lat' mecha' bkwaaṉlen' li', wzoa' li' iṉabi'o shi yell.” ");
INSERT INTO zadNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na' ka bllin beena' sto lawe'na' na' chi'ene': “X̱an', xmecho'na' bkwaaṉ'leno' nad' bena'n gan gayaan.” ");
INSERT INTO zadNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Na' ḻekzka' chi'e beena': “Wzoa' li' iṉabi'o gay' yell.” ");
INSERT INTO zadNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Na'ch bllin stoe' lawe'na' na' chi'ene': “X̱an', ni de xmecho'na' bkwaaṉ'leno' nad'. Blall'tipteza'n to lech' na' wlooshawaan ");
INSERT INTO zadNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","daa blleb' li', ḻa' ḻe beṉ' zṉia nako'. Chkaatezo' dii bi naki c̱ho', na' chizi' chilaptezo' dii goz gooṉ beṉ' yoblə.” ");
INSERT INTO zadNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Na'ch che' beṉ' wṉabia'na' ḻe': “Bikzbi yejni'alallii beno'. Kon ka ba wno' ka'kzan gak c̱ho'. Ṉezilo' nak' beṉ' zṉia, na' chkaatez' dii bi naki c̱ha' na' chizi' chilap' dii goz gooṉ beṉ' yoblə. ");
INSERT INTO zadNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na' daa ṉezilo' ka' chon', ¿berac̱he ki bi'o xmechaa gon yic̱hjin kwenc̱he yikaan ṉaa ba biyed'?” ");
INSERT INTO zadNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Na'ch chi'e beṉ'ka' lle' na': “Ḻi yikaa mecha' daa bi'ane' na' ḻi we'n beena' bene' gan shin.” ");
INSERT INTO zadNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Na'ch che' beṉ'ka'ne': “X̱an', ba napkzə beena' shin.” ");
INSERT INTO zadNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Na' che' beṉ' wṉabia'na' ḻegake': “Nia' le', beena' chonlene' llin daa yoo lo nee, wakch lall' nee dii xench; san beena' bi chonlene' llin daa yoo lo nee, ax̱t daa ngoo lo nee lat' yidoyo. ");
INSERT INTO zadNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na' ka nak beṉ'ka' chakzbangakile' nad', beṉ'ka' bi cheengakile' iṉabi'a, ḻi lljx̱i'gake' ni na' ḻi witgake' ile'teid'.” ");
INSERT INTO zadNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Na' ka wde wna Jesúza' ka', na'ch bigoolene' nez beṉ'ka' nakgake'ne' txen ziyajgake' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Na' ka billingake' xṉi'a yaa daa le Yaa Olivos, gaozə yellka' le Betfagé na' Betania, na'ch bseḻee c̱hop beṉ'ka' nakgake'ne' txen, ");
INSERT INTO zadNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","na' chi'e ḻegake': ―Ḻi shaj yella' llia na', na' ka illinle ile'ile to burr chbando', ba konoṉ' kwia, da'b yag. Na' wsell-leb wc̱he'leb nilə. ");
INSERT INTO zadNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Na' shi no iṉaz le': “¿Berac̱he chsellzleb?”, na' ye'lene': “X̱anchonan' chyalljile'b.” ");
INSERT INTO zadNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Na'ch wyaj beṉ'ka' bseḻee, na' ka bllingake' ble'gakile' to burr chbando' da'b yag, kon kayeṉ' goll Jesúza' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Na' ka chsellgake' burra' na'ch che' x̱ama' ḻegake': ―¿Berac̱he chsell-leb? ");
INSERT INTO zadNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Na'ch che'gake'ne': ―X̱anchonan' chyalljile'b. ");
INSERT INTO zadNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Na'ch bc̱he'gake'b jwa'gake'b lao Jesúza' na' bx̱oagake' xe'ka' koll'ba' na' blliagake' Jesúza' koll'ba'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na' shlak zej Jesúza' llie' burra', chshilj xa beṉ'ka' tlo neza'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na' ka ba chillingake' gaozə gana' chiyetj nez daa ziza' Yaa Olívoza', yog'ḻoḻ beṉ'ka' nakgake'ne' txen chosyaagake' daa chibagakile' na' choe'la'ogake' Chioza' daa ble'gakile' yog' yeḻ' wakka' bene'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Na'ch nagake': ―¡Gaklenshga X̱ancho Chioza' beeni ba bseḻee iṉabi'e! ¡Ḻi da, we'la'ocho Chioza' zoa yabana' daa bene' ka zoalenchone' mbalaz! ");
INSERT INTO zadNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Na' baḻ fariseoka' len ladj beṉ'ka' no Jesúza', che'gake'ne': ―Maestro, goll beṉ'ki nakgake' li' txen soagake' llizə. ");
INSERT INTO zadNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Na' che' Jesúza' ḻegake': ―Nia' le', shi beṉ'ki soagake' llizə, na' yaj kilə solo gosyaagakan we'la'ogakan nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Na' ka billine' gaozə yell Jerusalénna', gokyeshile' ka ble'ile'n na' wchelle' c̱he beṉ'ka' zoa na'. ");
INSERT INTO zadNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Na' chi'e: ―¡Sheḻ'ka' ṉaanlla gakbe'ile nakan gonle kwenc̱he soale mbalaz! Per ngashaan laolena' na' aga wakbe'kzile. ");
INSERT INTO zadNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wllin lla ila' beṉ'ka' chakzbangakile' le' na' wzec̱hjgake' yelli leej na' kono gak sho' ichej. ");
INSERT INTO zadNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Na' ni sto yaj c̱he lill-leka' bich yikwaaṉgake' koll' ljwellin, na' witgake' le' len xiiṉleka', ḻa' bi gokbe'ile ka bla' Chioza' ladjleni. ");
INSERT INTO zadNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Na'ch ka bllin Jesúza' cho'a yoodo'na' na' bisheshe' beṉ'ka' chit' chde. ");
INSERT INTO zadNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Na' chi'e ḻegake': ―Cho'a Xtill' Chioza' nan: “Lilla'na' nakan ga choe'ḻwill beṉ' nad'”, na' le' ṉaa ba nonzlen ka to ga chdop chllag wban. ");
INSERT INTO zadNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Na' yog' lla bli' bsedi Jesúza' beṉ' gana' zoa yoodo'na', na' bx̱ozka' chṉabia' na' beṉ'ka' chli' chsedi leya' na' nochlə beṉ' wṉabia' c̱he beṉ' Israelka' ḻa'kzi biyiljlall'gake' naklə gongake' kwenc̱he witgake'ne' ");
INSERT INTO zadNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","bikzə bi gok gongake', ḻa' yog'zə beṉ' chibagakile' chzenaggake' dill'ka' cho'e. ");
INSERT INTO zadNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Na' bllin to lla, shlak chli' chsedi Jesúza' beṉ'ka' lesh' chyoodo'na' na' chyix̱je'ile' ḻegake' dill' wen dill' kob c̱he Chioza', bllin bx̱ozka' chṉabia' na' beṉ'ka' chli' chsedi leya' len beṉ' golka' chṉabia'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Na' che'gake'ne': ―Wnashki neto', ¿bi yeḻ' wṉabia' napo' chono' diiki? Na' ¿nora beṉ li' yeḻ' wṉabia'ni? ");
INSERT INTO zadNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Na'ch che' Jesúza' ḻegake': ―Ḻekzka' nad' de to dii iṉabid' le', ḻi iṉashki nad': ");
INSERT INTO zadNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Noran bseḻ' Juanna' kwenc̱he bidchoe' beṉ' nisa'? ¿AChiozan' bseḻeene'? ¿Anti beṉ' yell-liona'zan bseḻeene', lla? ");
INSERT INTO zadNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Na'ch wzologake' choe'len ljwellgake' dill', che'gake': ―¿Nakra ka ye'chone', lla? Shi ye'chone' Chioza' bseḻeene', ḻobe' iṉe' cho': “¿Berac̱he ki wyajḻe'le c̱he', shka'?” ");
INSERT INTO zadNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na' shi yize'chone' nozə beṉ' bseḻeene', yog' beṉ'ki wlliagake' cho' yaj witgake' cho', ḻa' yog'gake' chajḻe'gake' Juanna' bi'e dill' daa goll Chioza'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Na'ch gollgake' Jesúza': ―Bi ṉezinto' no bseḻ' beena'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Na'ch che' Jesúza' ḻegake': ―Ḻekzka' nad' aga wnia' le' noran beṉ nad' yeḻ' wṉabia'na' kwenc̱he chon' diiki. ");
INSERT INTO zadNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Na' Jesúza' bseesee to jempl lao beṉ'ka' lle' na': ―To beṉ' billee yag uva, na' bene'n lall' na' beṉ'ka' gap wwian, na' wzee wyaje' ssha gan yoblə. ");
INSERT INTO zadNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na' ka bizi' bilap beṉ'ka' uvana', x̱aninna' bseḻee to wen llin c̱he' kwenc̱he lljelle' beṉ'ka' nak lall' na'gake' yag uvaka' we'gake'ne' daa chidoḻee yikee. Na' beṉ'ka' chapgake' yag uvaka' bex̱'gake'ne' bet wdingake'ne', na'tech bilaggake'ne' to ka' che'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Na'ch bseḻee sto wen llin c̱he'na'. Na' ḻekzka' bet wdingake'ne', na' biya dii bengakile'ne', na' bizlaggake'ne' to ka' che'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Na'ch de wyoṉ shii, bizseḻee wen llin yoblə, na' ḻekzka' bengake'ne' bido we'zi, na' bizlaggake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Na'ch chaki x̱an yag uvaka': “¿Nakra ka gona'n? Wseḻ'shkid' bi' c̱ha'ni, bi'ni ḻe chakid'. Shera shicholə wzenaggake' c̱heb'.” ");
INSERT INTO zadNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Na' ka ble'i beṉ'ka' chap yag uvaka' xiiṉe'na', na'ch che' ljwelle': “Bi'nin yigaaṉlem' yell-lioni. Ḻi da witchob' kwenc̱he yigaaṉlenchon.” ");
INSERT INTO zadNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Na' wlejgake'b' gana' lle' yag uvaka' na' betgake'b'. Na'ch wṉabi Jesúza' beṉ'ka' chzenag: ―¿Nakra ka chakile goni x̱an yag uvaka' beṉ'ka', lla? ");
INSERT INTO zadNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ba nakten shaje' na' lljete' beṉ'ka' chap yag uva c̱he'na' na' yiyone' yell-lio c̱he'na' lall' na' beṉ' yoblə. Na' ka beni beṉ'ka' wne' ka', na' wnagake': ―¡Bat we' Chioza' latj gak ka'! ");
INSERT INTO zadNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Na' bwia Jesúza' ḻegake', chi'e: ―¿Beran zejin Cho'a Xtill' Chioza' gana' na: Yaja' daa bi wyoolall' wen yooka', ḻeyeṉ'lannan' yaja' daa ba nc̱hejcha yoona'? ");
INSERT INTO zadNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nottezə beṉ' lljc̱haze' lawinna' kwiayee, na' shi idakwan beṉ', ax̱t wshoshjan ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na' bx̱ozka' chṉabia' na' beṉ'ka' chli' chsedi leya' goklall'gake' gox̱'gake' Jesúza' ka biyoll golle' ka', ḻa' gokbe'gakile' c̱hezgaken' wṉie' daa bi chajḻe'gake' c̱he'. Per bllebgake' beṉ'ka' ndop nllag na'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Na'ch bseḻ'gake' to c̱hop beṉ' wiwia wiyi, na' bentezgake' ka beṉ' cheenchgayi wzenag c̱he'. Per aga do lall'gaken' wyajgake', san kwenc̱hezə kwejyelgakile' Jesúzan' na' lljadaogake' xya c̱he' lao beena' chṉabia' gana' mbani Judeana'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Na' wṉabgakile'ne': ―Maestro, ṉezinto' daa no' na' daa chli'o nakan dii ḻi, na' aga chwio' nak nak beṉ', shi nake' beṉ' zakii wa shi bi nake'. Ṉezinto' chli'o nez ḻi c̱he Chioza' kon ka nakan. ");
INSERT INTO zadNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wnashki neto': ¿Achiyaḻ' c̱hixjcho daa chṉab Césara', beena' chṉabia', anti bi chiyaḻ' c̱hixjchon? ");
INSERT INTO zadNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Na' gokbe'i Jesúza' aga do lall'gaken' wṉabgakile'ne', na'ch chi'e: ");
INSERT INTO zadNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Ḻi wli'shkayi nad' to mech. ¿Nora cho'alawin na' no leyin da'n? Na' che'gake'ne': ―C̱he Césaran', beena' chṉabia' Rómana'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Na'ch chi'e: ―Na'len, ḻi we' Césara' daa naki c̱he', na' ḻekzka' ḻi we' Chioza' daa naki c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Na' ni shcho'a dill' daa bi'e lao beṉ'ka' bi gok wc̱hingake'n kwenc̱he gaogake' xya c̱he'. Na' bibangakile' ka golle' ḻegake' na' bibe'gake' llizə. ");
INSERT INTO zadNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ka wde dga, bllin baḻ saduceoka' lao Jesúza', beṉ'ka' bi chajḻe' daa yiban beṉ' wetka'. Na'ch che'gake' Jesúza': ");
INSERT INTO zadNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestro, leya' bzej dii Moiséza' nan: shi to beṉ' byo guete' na' igaaṉ xoole'na' wizeb na' kono xiiṉgake' wzoa, beṉ' bish' beṉ' weta' chiyaḻ' yikee nool wizeba' kwenc̱he soa xiiṉ dia c̱he dii beṉ' bisheena'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ki gok to shii, wzoa gall bish' beṉ', na' beṉ' necha' bshagnee, na' wite' na' kono xiiṉe' wzoa. ");
INSERT INTO zadNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Na' beṉ' wchopina' bikee noola', na' ḻekzka' wite' na' kono xiiṉe' wzoa. ");
INSERT INTO zadNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na' beṉ' wyoṉina', ḻekzka' bizkee noola', na' wizete' na' kono xiiṉe' wzoa. Na' ḻekzka' beṉ'ka' zi tap bizkaagake' noola' na' witgake', na' ni to beṉ'ka' gall bi wzoa xiiṉgake' kon noola'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Na' ka bllin lla ḻekzka' wit noola'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na' kat' yiban beṉ' wetka', ¿norayeṉ'en' gak beṉ' c̱he', lla?, ḻa' galltien' wzoalene'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Na'ch che' Jesúza' ḻegake': ―Beṉ'ka' lle' yell-lioni ṉaa chkaa ljwellgake', na' ḻekzka' choe' yeḻ' wishagna' c̱he xiiṉe'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","San beṉ'ka' iṉa Chioza' zak'gake' yiyajgake' gana' zoe' ka yibangake' ladj beṉ' wetka', aga ka'chan gongake'. Ḻa' koch no wshagna' gana' zoa Chioza', ");
INSERT INTO zadNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ni koch no guet, san soagake' ka zoa anjlka'. Na' gakgake' xiiṉ Chios daa ba bisbane' ḻegake' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kwin dii Moiséza' bzeje' kwenc̱he iṉezicho yiban beṉ' wetka' kana' bzeje' c̱he yag yeshaa daa ble'ile' chaḻ'ṉiṉ. Na' wne' X̱ancho Chioza' nake' Chios c̱he Abrahama', Isaaca' na' Jacoba'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Na' Chioza' aga nake' Chios c̱he beṉ' wet, san nake' Chios c̱he beṉ' de yeḻ' mban c̱heyin. Ḻa' yog'ḻoḻ beṉ' nx̱enilallii Chioza', dekzə yeḻ' mban c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Na'ch baḻ beṉ'ka' chli' chsedi leya' gollgake'ne': ―Maestro, ka ba wnayeṉoon nakan. ");
INSERT INTO zadNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na' bich bi biyaxjchgakile' iṉabchgakile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Na' che' Jesúza' ḻegake': ―¿Berac̱he nazə beṉ' Crístona' nake' xiiṉ dia c̱he dii Davina'?, ");
INSERT INTO zadNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","len kwin dii Davinan' bzeje' ḻee libr c̱he Sálmoka' gana' na: X̱ancho Chioza' golle' X̱an'na': “Wche' kwit' de shḻi ni ");
INSERT INTO zadNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","shlak wzoa' xṉi'ona' beṉ'ka' chakzbani li'.” ");
INSERT INTO zadNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Berac̱he chakzile Crístona' nake' xiiṉ dia c̱he dii Davina', len kwin Davina' golle'ne': “X̱an'”? ");
INSERT INTO zadNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Na' shlak chzenag yog' beṉ'ka' lle' na', Jesúza' golle' beṉ'ka' nakgake'ne' txen: ");
INSERT INTO zadNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Ḻi wsak' bi gonle ka chon beṉ'ki chli' chsedi leya'. Ḻe chibagakile' gon xe'ka' dii toṉ, na' cheengakile' yog'zə beṉ' gapgake' ḻegake' balaaṉ ladj lkwe' beṉ'. Na' gana' chdop chllagcho choe'ḻwillcho Chioza' chbagakile' kwe'gake' gana' chbe' beṉ'ka' zakii, na' ka'kzə chongake' ga de yeḻ' waw. ");
INSERT INTO zadNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Na' ḻekzka' chkaatezgake' lill nool wizebka', na' chongake' ka chshaljlen Chioza' ssha nlleb kwenc̱he gaki beṉ' ḻe wen chongake'. Na' daa chongake' ka', ba nakten ile'gakile' yeḻ' zak'zi' wala'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Na' ble'i Jesúza' ka chgoo beṉ' wni'aka' mecha' gana' chgoo beṉ' mech c̱he yoodo'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Na' ḻekzka' ble'ile' to nool yesh', beṉ' wizeb, wlo'e c̱hop sintabdo'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Na' goll Jesúza' ḻegake': ―Dii ḻi nia' le', ḻa'kzi nool wizebi nake' beṉ' yesh', ba be'che' dii xench aga ka yog'te beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ḻa' yog'gake' choe'gake' daa chichooṉan c̱he'ka', na' ḻe', naktie' beṉ' yesh', wlo'e doxen daa nape', ḻa'kzi chyalljile'n. ");
INSERT INTO zadNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na' baḻ beṉ'ka' choe'gake' xtill' yoodo'na' ka xochi nak yajka' nongakile'n na' diika' bzani beṉ' be'gake'n yoodo'na'. Na'ch che' Jesúza' ḻegake': ");
INSERT INTO zadNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Ka nak diiki chwiale ṉaa, wllin lla kwiayi' yogaan, ni sto yaj bich kwia koll' ljwellin. ");
INSERT INTO zadNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Na'ch wṉabgakile' Jesúza', che'gake'ne': ―Maestro, ¿batran gak dga ba wno'? ¿Bera ka ile'into' gak kwenc̱he iṉezinto' nan ba zoa gaoshosh gakan? ");
INSERT INTO zadNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Na'ch che' Jesúza' ḻegake': ―Ḻi wsak' bi we'le latj no siye' le'. Ḻa' beṉ' zan zi ichej gonzgake' ka nad', na' iṉazgake': “Nadaan Crístona'”, na' ḻekzka' iṉazgake': “Ba bllin lla kwiayi' yell-lioni.” Bi gonle ḻegake' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na' ka yenile chak no wdiḻ wa chtop chshag ljwell beṉ' kwenc̱he soshyi'gake' beṉ' wṉabia'ka', bi illeble. Chonan byen zigaate gak diiki, per aga lii tete c̱he yell-lioni kat' ba chakgakan. ");
INSERT INTO zadNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Na'ch golle' ḻegake': ―Ganga kwe' wdiḻa' na' tiḻ yell kon yell. ");
INSERT INTO zadNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na' gak no bedxo' wal, na' gat' wbin, na' biya yillwe' kwe' lo yell-lioni, na' biya dii gak xan yabana' dii wwall wsheban beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Na' ka zi gak diiki, gox̱'gake' le' na' biya dii gongakile' le'. Na' lljwa'gake' le' gana' chdop chllagcho choe'ḻwill-cho Chioza' na' yiya yiyiljgake' le' na' koogake' le' lillya, na' lljwa'gake' le' lao beṉ' wṉabia' xenka' na' lao beṉ' wṉabia'ka' sto ni c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na' kat' gak c̱hele ka', na'chlə gat' latj we'le cho'a xtillaana' lawe'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Na' bi sezle wṉeyi naklə iṉale kat' lljsele lao beṉ' wṉabia'ka', ");
INSERT INTO zadNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ḻa' nad'kzan wzajniid' le' nakan iṉale na' goṉ' le' yeḻ' sin'na' kwenc̱he ni to beṉ'ka' chakzbangakile' le' bi sogakile' iṉagake' bi nakan ka nale. ");
INSERT INTO zadNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Na' no x̱axṉa'tezle, no beṉ' bish'le, no dialla c̱hele, na' no beṉ' zoalenle wen gongake' le' lo na' beṉ' wṉabia'ka', na' witgake' baḻ-le. ");
INSERT INTO zadNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na' ax̱t yog'zə beṉ' gakzbangakile' le' daa nonḻilall'le nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Per ḻi koo yic̱hjle, Chioza' gaklene' le' na' ni tlish' yish' yic̱hjlena' bi kwiayi'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Na' shi sechale lawi daa yen ile'ile na' bi gakc̱hoplall'le, na'chan gat' to yeḻ' mban c̱hele dii bi te c̱heyin. ");
INSERT INTO zadNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Na' kat' ile'ile nec̱hj soldadka' Jerusalénni, kanan' iṉezile nan ba zoa kwiayi'n. ");
INSERT INTO zadNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na'ch beṉ'ka' lle' gani mbani Judeani, chiyaḻ' wxoṉjgake' lljakwash'gake' do yaa yaoka', na' beṉ'ka' lle' yelli, chiyaḻ' wxoṉjgake', na' beṉ'ka' zej lyix̱aa, bichoklə yiyedgake' yelli. ");
INSERT INTO zadNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ḻa' kanan' gon Chioza' yeḻ' zi' c̱he yog'ze' kwenc̱he yillinin doxen ka na Cho'a Xtilleena'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Nyesh'laz wal gak c̱he noolka' noa' na' noolka' chwall' chx̱op llana' gak diiki! Ḻa' dii xen daa yen ile'i beṉ' Israelki. ");
INSERT INTO zadNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Baḻgake' guet lo wdiḻa' na' zi baḻe' wc̱he'gake' pres yell zit'ka'. Na' beṉ' zit'ka' wlej wshoshjgake' yell Jerusalénni ax̱t kat'ch illin lla yiyoll yido ka llia bia' gongake'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Na' lo wbilla', lo bewaa na'ch lo beljka' gak dii gonan ka yibani beṉ'. Na' beṉ'ka' lle' yell-lioni gakshejlall'gake' na' illebgake' kat' gon nisdo'na' sshag wal daa so' kwe'n. ");
INSERT INTO zadNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Na' ax̱t ic̱hoḻ-lall' beṉ' daa chllebgake' kwiayi'lengake' yell-lioni, ḻa' ax̱t yog' diika' llia xan yabana' iṉibgakan. ");
INSERT INTO zadNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na'ch ile'gakile' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, zizaa to lo bej kon yeḻ' wak xen na' balaaṉ xen. ");
INSERT INTO zadNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na' kat' solo gak diiki, ḻi wtipch lall'le, ḻa' ba zoa gaoshosh yidsla' len'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Na' ḻekzka' bsees' Jesúza' to jempl chi'e: ―Ḻi wwiakachi yag yix̱wewa' wa bichlə yag. ");
INSERT INTO zadNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kat' chle'ile ba chibia xḻaguiinka', chakbe'ile ba zoa yiyoo la'o linna'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ka'kzə, kat' ile'ile ba chak diiki ba wnia', chiyaḻ' iṉezile ba zoa gao wli' Chioza' yeḻ' wṉabia' c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Dii ḻi nia' le', aga ba wit beṉ'ka' zoa ṉaa kat' gak yog' diiki. ");
INSERT INTO zadNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","’Yabana' na' yell-lioni te c̱hegakin, san cho'a xtillaana' aga wde bi gak ka nan. ");
INSERT INTO zadNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Ḻi wsak' bi we'le latj sho' diika' wxiṉjan yic̱hjlall'do'lena'. Bi wḻanzle yeḻ' weezo, na' bi sezle wṉeyi bi chak c̱hele. Ḻi wsak' kwenc̱he aga sha c̱hel-le chon llana' zizaa. ");
INSERT INTO zadNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ḻa' tokonganzan gak diiki yen ile'i yog'te beṉ'ka' lle' doxen yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Na' le', ḻi se wṉeyi, ḻi iṉabi Chioza' toshiizi gaklene' le' kwenc̱he yilale lao yog' diiki llia bia' gak, na' kwenc̱he bi gall illeble sele lawa'na', nad', Beṉ' Bseḻ' Chioza' Yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na' Jesúza' bli' bsedile' beṉ' yog' lla yoodo'na', na' ka chaḻ, chjagaaṉe' lo Yaa Olívoza'. ");
INSERT INTO zadNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na' yog' zil yog' beṉ' chajgake' yoodo'na' chjazenaggake' daa chli' chsedile'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ba zoa gaozə lṉi Paskwa' kat' chaogake' yetxtil daa bi nc̱hix̱ levadúrana'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na' bx̱ozka' chṉabia' len beṉ'ka' chli' chsedi leya' chiyiljlall'gake' naklə gongake' witgake' Jesúza' ka kono gakbe'i, ḻa' bllebgake' shi bi goni beṉ' wlall c̱he'ka' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Na'ch x̱an dii x̱iw'ka' daa le Satanás wyoon ḻoo yic̱hjlall'do' Jud Scariota', beena' nak txen beṉ'ka' shlliṉ. ");
INSERT INTO zadNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Na' wyaje' lao bx̱ozka' chṉabia' len lao beṉ'ka' ngoo lall' na' beṉ'ka' chap yoodo'na', na' bi'e dill' nakan gone' Jesúza' lall' na'gake'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Na' ḻe bibagakile' na' bc̱hebgake' we'gake'ne' mech. ");
INSERT INTO zadNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Na'ch bc̱hebe' gone'ne' lall' na'gake'. Na' wzolo chinoe' batan gat' latj kat' kono beṉ' lle' gone' Jesúza' lall' na'gake'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na' bllin llana' chsini'agake' c̱he lṉina', llana' chzolo chaogake' yetxtil daa bi' nc̱hix̱ levadúrana' na' chitgake' to xil'do', bana' gaogake' lle' Paskwa'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Na'ch wlej Jesúza' Pédrona' len Juanna' na' chi'e ḻegake': ―Ḻi lljasini'a daa gaocho lṉi Paskwi. ");
INSERT INTO zadNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Na'ch che'gake'ne': ―¿Garan cheenilo' lljasini'anto'n? ");
INSERT INTO zadNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Na' che' Jesúza' ḻegake': ―Ka sho'le Jerusalénna', na' ile'ile to beṉ' byo zino'e to chee nis, na' ḻi lljanoe' ax̱t yoona' gana' yilline'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Na' ye'le x̱an yoona': “Maestrona' chṉabile' li': ¿Garan zoa yoona' wyoone' gana' gaolene' beṉ'ka' nakgake'ne' txen lle' Paskwi?” ");
INSERT INTO zadNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Na' wliile' le' to yoo xen dii llia shkwiana' cha'lə ga ba nonshao'tie'. Nan' wsini'ale daa gaocho xshe'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Na' wloogake' nez zejgake', na' kon kayeṉ' golle' ḻegake' gok. Na' bsini'agake' daa wdaogake' lle' lṉi Paskwa'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na' ka goḻ' gaogake' xshe'na', Jesúza' wche'lene' postl c̱he'ka' cho'a mesa'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Na'ch chi'e ḻegake': ―Ba goklall'chga' yeej gaolen' le' lṉi Paskwi ṉaa biṉ' witgake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Na' ba nia' le', zeelo ṉaa cheej chaw' dga. Bichga yeej gawa'n ax̱t ki illin llana' wli' Chioza' yeḻ' wṉabia' xen c̱he'na', kana'ch yeej gawa'n dii yoblə. ");
INSERT INTO zadNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Na' bex̱ee kopa' na' bi'e Chioza' yeḻ' chox̱ken, na' chi'e: ―Ḻi gox̱' dga, ḻi yeejan lat' wej. ");
INSERT INTO zadNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Na' nia' le', bichga yeej' nis uvani ax̱t ki illin lla wli' Chioza' yeḻ' wṉabia' xen c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Na'ch bex̱ee yetxtila' na' bi'e yeḻ' chox̱ken Chioza'. Na' bxoxje'n bi'en ḻegake' kwenc̱he wdaogake'n, na' chi'e: ―Dgan kwerp c̱ha'ni, chzanlallidaan ni c̱hele. Kin gonle kwenc̱he lljadinile nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Na' ḻekzka' bene' ka wde wdaogake' xshe'na', bex̱ee kopa' sto shii, na'ch chi'e: ―Dga yoll ḻoo kopi zejin xc̱hen'na' daa ḻaljə ni c̱hele daa gonan ka gakḻi dii koba' bc̱heb Chioza' gone'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Na' ṉaa, beena' gone' nad' lo na' beṉ'ka' chakzi'gakile' nad' chi'lene' nad' cho'a mesi. ");
INSERT INTO zadNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ḻa' ba bllin lla gak ka nak daa llia bia' gak c̱ha', nad', Beṉ' Bseḻ' Chioza' Yell-lioni, per ¡nyesh'laz gak c̱he beena' gone' nad' lo na' beṉ' malka'! ");
INSERT INTO zadNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Na'ch beṉ'ka' nakgake'ne' txen wzologake' chṉabi ljwellgake' noen' gone'ne' lo na' beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na' ḻekzka' chakdiḻ-len ljwellgake' nogaken' nak beṉ' zak'chi. ");
INSERT INTO zadNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Na' che' Jesúza' ḻegake': ―Zoa beṉ' wṉabia' to to nación, na' chongake' byen chzenag beṉ' c̱hegake', na' nagake' c̱he kwingake' ḻe chaklengake' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","San le', bi chiyaḻ' gonle ka'. Shi nole nakle beṉ' zakii, chiyaḻ' wc̱hek' yic̱hjle ka to bi' xkwid', na' shi nole chṉabia', chiyaḻ' gonle ka nottezə beṉ' wen mandad. ");
INSERT INTO zadNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Noran nak beṉ' zak'chi?, ¿abeena' chbe' cho'a mesa' chawe'?, ¿anti beena' chon mandadan', lla? Beena' chi' cho'a mesan' nake' beṉ' zak'chi. San nad', ḻa'kzi naktia' x̱anle, zoa' ladjleni ka to beṉ' wen mandad c̱hele. ");
INSERT INTO zadNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Le' ba wzoalenle nad' lao yog'te daa ba gok c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na' daan, goṉ' le' yeḻ' wṉabia'na' ka daa beṉ X̱a'na' nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Na' yeej gaolenle nad' gana' iṉabi'a. Na' kwe'le gana' iṉabia'le yizi'le kwent c̱he shlliṉ kwen beṉ'ka' nak xiiṉ dia c̱he dii Israela'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Na' ḻekzka' golle' Simón Pédrona': ―Simón, Simón, Satanáza', daa chṉabia' dii x̱iw'ka', ba wṉaban le' gakle lo na'yin kwenc̱he gondinj gonganin le'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Na' nad' ba wṉabid' Chioza' gaklene' li', Simón, kwenc̱he gonḻilall'cho nad'. Na' kat' ba biyajilo' c̱heyi daa gono', na' gakleno' beṉ'ki nako' txen kwenc̱he soac̱hec̱hgake' gonḻilall'gake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Na' che' Simónna': ―X̱an', ba nc̱hoglallaa ḻaa lillyana' sa'len' li' wa ax̱t guetlen' li' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Na' che' Jesúza': ―Pedro, nia' li', ṉaanlle' shoṉ shii bi wc̱hebo' shi nombi'o nad' ka zi' kwell shikwteza'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Na'ch che' Jesúza' ḻegake': ―¿Azyalljile bi byalljile kana' bseḻaa le' na' bibi bex̱'le, ni ga koo xalaanle, ni mech na' ni xel-le? Na' che'gake': ―Bibi byalljinto'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Na'ch golle': ―Per ṉaach nia' le', shi de ga chgoo xalaanle, ḻi gox̱aan, na' shi de xmechle, ḻi wa'n; na' shi nole bi de spad c̱hele, ḻi lljayet' xalena' na' ḻi si' tlisha'n. ");
INSERT INTO zadNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nia' le', chonan byen gak c̱ha' kon ka na Cho'a Xtill' Chioza' gana' na: “Gongakile'ne' ka chongakile' to beṉ' wen dii mal.” ");
INSERT INTO zadNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Na' che'gake': ―X̱an', ni napnto' c̱hop spad. Na' chi'e: ―Lliz ḻi soachoklə. ");
INSERT INTO zadNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Na'ch biza' Jesúza', na' kon ka yooloe' chone' biyaje' lo Yaa Olívoza', na' zjano beṉ'ka' nakgake'ne' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Na' ka bllingake' latja', na' chi'e ḻegake': ―Ḻi we'ḻwill Chioza' kwenc̱he bi we'zle latj gon beli chenna' le' gan. ");
INSERT INTO zadNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na' bkwase' kwite'ka', ka to ga zeelo chllin to yaj dii chzaḻ'cho, na'ch bc̱hek' xibe'na' be'ḻwille' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Na' golle': ―X̱a, shi li' cheenilo', bislagach nad' lawi dga ba zoa idiḻ illag'; per aga gak ka cheenid', san gak ka cheenilo'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na'ch bli'lao to anjl beṉ' za' yabana' ḻe', na' biyo'ene' fuerz. ");
INSERT INTO zadNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na' daa ḻe chakyesh'chgaile', zizikli be'ḻwillche' Chioza' ax̱t biyaklolje'. Na' nis yes c̱he'na' daa chxop lo yona' nakan ka to bllon wej chen. ");
INSERT INTO zadNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Biyoll be'ḻwille' Chioza', na' bizollee biyaje' gana' lle' beṉ'ka' nakgake'ne' txen, na' ka billine' kwite'ka' ba chesgake' daa chakyesh'gakile'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Na' chi'e ḻegake': ―¿Berac̱he cheszle? Ḻi c̱has na' ḻi we'ḻwill Chioza' kwenc̱he bi we'zle latj gon beli chenna' le' gan. ");
INSERT INTO zadNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ni choe'te Jesúza' dill', ka bllin beṉ' zan, na' beena' le Jud, beena' nak txen beṉ'ka' shlliṉ, nc̱hi'e ḻegake'. Na' ka blline' jabiguee kwit Jesúza' na' bnope' x̱agueena'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Na'ch che' Jesúza'ne': ―Jud, ¿akon dga bnopo' nad' chono' nad', Beṉ' Bseḻ' Chioza' Yell-lioni, lo na' beṉ'ki? ");
INSERT INTO zadNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na' beṉ'ka' lle'len Jesúza', ka ble'gakile' ka ba chak c̱he', na'ch gollgake'ne': ―X̱an', ¿awṉiayinto' spadki? ");
INSERT INTO zadNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na' toe' lii wdintie'n to mos c̱he bx̱oz choo bx̱oz xenna' bc̱hogtie' nague' de shḻina'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Na' che' Jesúza': ―Bich bi gonile beṉ'ka'. Na'ch bida' Jesúza' nag beena'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Na' daa bllin bx̱ozka' chṉabia' len beṉ'ka' chap yoodo'na', na' beṉ' golka' chṉabia', kwenc̱he gox̱'gake'ne', chi'e ḻegake': ―¿Berac̱he za'zle nox̱'le yag na' spad kwenc̱he zidṉizle nad' ka to no beṉ' wban? ");
INSERT INTO zadNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yog' lla wzoa' ladjlena' yoodo'na' na' bi bex̱'le nad'. Per ṉaach bllin lla gonle ka cheenile na' ṉaayeṉ' chṉabia' dii mala' daa chṉabia' gana' shgasj shc̱hoḻ. ");
INSERT INTO zadNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Na'ch bṉizgake' Jesúza' na' bc̱he'gake'ne' lill bx̱oz choo bx̱oz xenna', na' zit' zit'lə zjano Pédrona'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na' bxengake' yi'na' lesh' chyoo c̱he bx̱oz choo bx̱oz xenna' na' wche'gake' cho'a yi'na', na' wlen Pédrona' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na' to noolə wen mandad, ka ble'ile' chi' Pédrona' cho'a yi'na', lii wzetie' chwie'ne', na' chi'e: ―Ḻekzka' len beenin nake' Jesúza' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Na' Pédrona' aga bc̱hebe', na' chi'ene': ―Noolə, aga nombi'a beena'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Na' gokzə xtit bizle'i beṉ' yoblə Pédrona' na' chizi'ene': ―Ḻekzka' lenon' nako' beṉ'ka' txen. Na' Pédrona' chi'ene': ―Bi len' nak' beṉ'ka' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Na' wizak ka do zi' tgor na' wize' sto beṉ' yoblə: ―Dii ḻikzan len beeni nake' txen Jesúza' ḻa' ḻekzka' beṉ' Galilean. ");
INSERT INTO zadNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Na'ch che' Pédrona'ne': ―¡Ni bi ṉezid' bi dillaan choo! Na' ni che'telə Pédrona' ka', ka wchell to shikwtez. ");
INSERT INTO zadNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Na'ch biyec̱hj X̱ancho Jesúza' bwie' Pédrona', na' Pédrona' jadinile' daa golle'ne', kana' chi'e: “Ṉaanlle' shoṉ shii bi wc̱hebo' shi nombi'o nad' ka zi' kwell shikwteza'.” ");
INSERT INTO zadNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Na' bichej Pédrona' gana' lle' beṉ'ka' na' wchellyeshee. ");
INSERT INTO zadNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na'ch beṉ'ka' chapgake' Jesúza' btitjgakile'ne' na' wdap' wlall'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Na' bsejgake' jalawe'na', na'ch wlall'gake'ne', che'gake'ne': ―¡Wnashki non wlall' li'! ");
INSERT INTO zadNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na' biya dii gollgake'ne' kwenc̱he gakile' zi'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Na' ka wyeeni', bidop beṉ'ka' chṉabia' beṉ' Israelka', len bx̱ozka' chṉabia' na' beṉ'ka' chli' chsedi leya'. Na' bdegake' Jesúza' lawe'ka'. Na'ch wṉabgakile'ne', che'gake': ");
INSERT INTO zadNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Wnashki neto' shi li'kzan Crístona', beena' chbeznto'. Na' che' Jesúza': ―Shi iṉia' le': “Awe, nadaan”, aga wyajḻe'le c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na' shi iṉabid' le' bi dii iṉabid' le', aga williilen na' ni bi yisanle nad', shi ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Na' ṉaate, nad', Beṉ' Bseḻ' Chioza' Yell-lioni, kwi'a kwit de shḻi c̱he Chioza', beena' nap yeḻ' wak xenna'. ");
INSERT INTO zadNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Na'ch yog'ze' wṉabgakile'ne': ―¿Ana' lin' nako' Xiiṉ Chioza'? Na'ch che' Jesúza': ―Awe, shḻikzan ba wnale. ");
INSERT INTO zadNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Na'ch che' ljwellgake': ―Kochno chyalljicho gawe' xya c̱he beeni. Kwintekzcho ba benicho ka ba wne'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Na'ch yog'ḻoḻ beṉ'ka' bizolla'gake' na' jwa'gake' Jesúza' lao Pilátona'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na'ch wzologake' chaogake' xya c̱he Jesúza', che'gake': ―Ba bidoḻinto' beeni chta chṉie' beṉ' wlall c̱hento'ka'. Chi'e bi chiyaḻ' c̱hixjcho daa chṉab Césara', beena' chṉabia', na' ḻekzka' naze' nake' Crístona', na' daa ne' ka' zejin nake' to beṉ' wṉabia'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Na'ch wṉabi Pilátona' Jesúza', chi'ene': ―¿Alin' nako' beṉ' wṉabia' c̱he beṉ' Israelki? Na'ch che' Jesúza'ne': ―Kan' nakan. ");
INSERT INTO zadNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Na'ch che' Pilátona' bx̱ozka' chṉabia' na' yog' beṉ'ka' lle' na': ―Ni to dii mal bi chillelid' chon beeni. ");
INSERT INTO zadNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Na' zizikchli che'gake': ―Diika' chli' chsedile' chta chṉen yog'ḻoḻ beṉ' lle' doxen lallnto'ni. Wzoloze' Galileana', na' ax̱t Judeani ba bide'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ka gollgake' Pilátona' ka', na'ch wṉabile' ḻegake' shi nak Jesúza' beṉ' Galilea. ");
INSERT INTO zadNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na' ka wṉezile' nake' beṉ' Galilea, na'ch bdie'ne' lao Heródeza', beena' nḻane' chṉabi'e Galileana', ḻa' kana'yeṉ' zoa Heródeza' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Na' ḻe bibayi Heródeza' ka ble'ile' Jesúza', ḻa' ba wlla cheenile' ile'ile'ne' daa ba benile' choe' beṉ' xtilleena'. Na' goki Heródeza' ile'ile' gone' to yeḻ' wak. ");
INSERT INTO zadNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Na' biya dii wṉabile' Jesúza', na' ni to daa wṉabile'ne' bi billi'e. ");
INSERT INTO zadNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Na' ḻekzka' na' lle' bx̱ozka' chṉabia' len beṉ'ka' chli' chsedi leya', na' zizikli chaogake' xya c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Na'ch Heródeza' len soldad c̱he'ka' biya dii bengakile'ne', na' btitjgakile'ne' bwakwgake'ne' to lech' ka daa chakw to beṉ' wṉabia'. Na'tech bizseḻ' Heródeza'ne' lao Pilátona'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na' lo llana' bizoalen Pilátona' Heródeza' wen, ḻa' kana'te chakzbani ljwelle'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Na'ch biti'a Pilátona' bx̱ozka' chṉabia', na' beṉ'ka' chṉabia'gake' beṉ' Israelka' na'ch beṉ' yell, ");
INSERT INTO zadNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","na' golle' ḻegake': ―Le' bidwa'le beeni lawii, nale chta chṉie' beṉ', na' nad' ba wṉabidee laoleni, na' bi chillelid' ni to daa nale c̱he' shi ḻi ka chone'n. ");
INSERT INTO zadNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Na' ni Heródeza' bi billelile' shi bi doḻ' nap beeni, na' ba bizseḻeene' laochoni. Na' ba ble'teile aga bi bene' iṉacho wc̱hoglozcho guete'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Na' ṉaa gon' mandad wit c̱hingake'ne' na'tech yisanee. ");
INSERT INTO zadNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Na' ka chakz yog' yiz, chiyaḻ' yisane' to beena' nej lillyana' kat' chaḻ' lṉi Paskwa'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Na' yog' beṉ'ka' ndop nllag na', wzologake' chosyaagake', che'gake': ―¡Guettega beeni! ¡Na' bisan Barrabáza'! ");
INSERT INTO zadNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nyix̱jgake' Barrabáza' lillyana' daa bx̱ie' wdiḻa' yell Jerusalénna', na' bettie' to beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Na' daa cheeni Pilátona' yisane' Jesúza', na' stokzə wṉabile' beṉ'ka' shi wisane'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Na' beṉ'ka' zizikchli chosyaagake', che'gake': ―¡Bdee ḻee yag cruza'! ¡Bdee ḻee yag cruza'! ");
INSERT INTO zadNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Na' de wyoṉ shiyi che' Pilátona' ḻegake': ―¿Bera dii malan' ṉezile ba ben beeni, lla? Bi chillelid' ni to dii mal dii ba bene' kwenc̱he guete'. Gonch' mandad wit c̱hingake'ne' na'tech yisanee. ");
INSERT INTO zadNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Na' beṉ'ka' wzeyidgake' chosyaagake' chṉabgakile'ne' wdeene' ḻee yag cruza'. Na' daa wzeyidgake' chosyaagake', bengake' gan wzoa xtilleeka'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Na' bc̱hoglall' Pilátona' gone' ka cheeni beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Na' bisane' beena' wṉabgake', beena' de lillyana' daa bx̱ie' wdiḻa' na' daa bettie' to beṉ'. Na' bene' Jesúza' lo na'gake' kwenc̱he gongakile'ne' ka chaklall'gake'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na' ka nc̱he'gake' Jesúza' lljada'gake'ne' ḻee yag cruza', billaggake' to beṉ' Cirene lie' Simón zizee lyix̱aa. Na' bex̱'gake'ne' bwa'gake'ne' yag cruz c̱he Jesúza' na'ch janoe'ne'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na' beṉ' zan zjanogake'ne', na' zan noolka' chbellgake' na' chosyaagake' ni c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Na' biyec̱hj Jesúza' bwie' ḻegake' na' golle': ―Le' nool Jerusalén, bi kwellzle c̱ha'; ḻi kwell c̱he kwinle na' c̱he xiiṉleka'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ḻa' wllin lla kat' iṉa beṉ': “Chakomba nool willka', beṉ'ka' bi wxan na' bi bwall bx̱opgake'.” ");
INSERT INTO zadNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Na'ch beṉ'ka' zoa llana' gak ka', solo iṉagake': “Sheḻ' iyiṉjtega yaa yaoki idakwtegan neto'.” ");
INSERT INTO zadNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Shi yag yaa yag banna' chongakile'n kon daa nazan c̱hegake', ¿alechla ki gongakile' yag billa'? ");
INSERT INTO zadNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na' ḻekzka' nc̱he'gake' c̱hop beṉ' wen dii mal kwenc̱he witgake' ḻegake' txen len Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Na' ka bllingake' latja' gana' le Llit Yic̱hj Beṉ' Wet, bda'gake' Jesúza' ḻee yag cruza'. Na' ḻekzka' bda'gake' c̱hopte beṉ' wen dii malka' shḻaa wej kwite'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Na' ka chda'gake' Jesúza' ḻee yag cruza', chi'e: ―X̱a, wxi'xen c̱hegake', ḻa' aga ṉezgakile' bin chongake'. Na' soldadka' bengake' to wyitj kwenc̱he wṉezgakile' nogake' yidoḻ' xe'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na' lle' beṉ' zan chwiagake', na' ax̱t beṉ'ka' chṉabia'gake' beṉ' Israelka' btitjgakile'ne', nagake': ―Gok bisle' beṉ' yoblə, na' ṉaa yislashki kwine' shi leile' ḻen' Crístona', beena' ba wlej Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Na' ḻekzka' soldadka' btitjgakilene', na' jabig'gake' kwit yag cruza' gana' nda'gake'ne' na' bshabgakile'ne' to vino dii nak zic̱hj zḻa'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Na' che'gake'ne': ―Shi lin' nako' beṉ' wṉabia' c̱he beṉ' Israelki, bislashki kwino'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na' yic̱hj yag cruz c̱he'na' bda'gake' to dii cho'en dill' bic̱he nda'gake'ne' ḻee yag cruza', nan: “Beenin beṉ' wṉabia' c̱he beṉ' Israelka'.” Bzejgake'n dill' griego, dill' latín na' dill' hebreo. ");
INSERT INTO zadNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Na' to beṉ' wen dii mala', beena' da' kwit Jesúza', biya dii golle'ne', chi'ene': ―Shi lin' Crístona', Beena' Bseḻ' Chioza' iṉabia', bislashki kwino' na' ḻekzka' bisla neto'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Na' beena' sto bsheshlene'ne', chi'e: ―¿Abikzə chall chlleblatoo Chioza'?, len kon ka chak c̱hen' ba chak c̱ho'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Cho', ka chiyaḻ'kz gak c̱hechon' kwenc̱he c̱hixjcho c̱he dii mala' daa bencho; san beeni aga bi dii mal bene'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Na'ch golle' Jesúza': ―Jesús, lljadingachilo' nad' kat'ka' solo iṉabi'o. ");
INSERT INTO zadNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Na'ch che' Jesúza'ne': ―Dii ḻi nia' li', ṉaanlla soaleno' nad' latja' gana' nak mbalaz. ");
INSERT INTO zadNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Na' do ka gobill bic̱hoḻ doxen yell-liona', bllinte do ka chida shoṉ, ");
INSERT INTO zadNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","daa bich bzeeni' wbilla'. Na' lechaa ze ḻoo yoodo'na' bllon' gokan c̱hop ḻaalə. ");
INSERT INTO zadNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Na'ch besyaa Jesúza' zilljə, chi'e: ―X̱a, chiyon' bishbe c̱ha'ni lall' noo. Na' biyoll golle' ka' na'ch wite'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na' ka ble'i beena' chṉabia' soldadka' diika' gok, be'lawee Chioza', chi'e: ―Dii ḻi beeni nake' dowalj beṉ' wen. ");
INSERT INTO zadNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na' yog' beṉ'ka' lle' na', ka ble'gakile' ka gok, ziyajgake' chball'gake' cho'alc̱ho'eka'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na' yog' beṉ'ka' nombia'gake' Jesúza', do noolka' za'lengake'ne' ax̱t Galileana', wzegake' zit'lə chwiagake' ka gok. ");
INSERT INTO zadNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Wzoa to beṉ' wlie' José, beṉ' yell Arimatea, daa mbani Judéana'. Na' Joséna' nake' txen beṉ'ka' chṉabia' beṉ' Israelka'. Nake' to beṉ' wen na' to beṉ' chon ka cheeni Chioza', ");
INSERT INTO zadNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","na' zoe' chbeze' wseḻ' Chioza' beena' iṉabia'. Na' Joséna' aga wyoolallee ka ben beṉ'ka' chṉabia'lene' daa betgake' Jesúza', na' bi benlene' ḻegake' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Na'ch wyaje' lao Pilátona' na' wṉabe' lsens yiḻetje' kwerp c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na' biḻetje'ne' ḻee yag cruza', na'ch bitobe'ne' to lech' xen na' jḻo'ene' to ḻoo blej daa benshawee, ga biṉ' wkash'gake' ni tlish' beṉ' wet. ");
INSERT INTO zadNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na' llana' gok diiki nakan lla chsini'a beṉ' Israelka' c̱hegake' kwenc̱he bibi llin gongake' lla sabda', llana' chombaaṉgake', na' zi lat'zə chyallj solo llana' chombaaṉgake'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na' noolka' za'lengake' Jesúza' ax̱t Galileana', wyajgake' jawiagake' bleja' na' jale'gakile' nak wdix̱jgake' kwerp c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Na'ch biza'gake', na' ka billingake' gana' zoagake', benshao'gake' daa chḻa' zix̱. Na' bizi'lall'gake' lla sabda' kon ka na leya'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Na' lla necha' chizolo xmanna', wizaj noolka' ni baḻ cho'a bana', nox̱'gake' diika' chḻa' zix̱ daa benshao'gake', na' wyaj zi baḻ noolə yoblə kon ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Na' ble'gakile' aga chi'ch yaja' cho'a bana'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Na' wyoogake' ḻoo bleja', na' ble'gakile' aga bich bi kwerp c̱he X̱ancho Jesúza' de na'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Na' shlak chakgakile' bera zejin dga, kat'kzali ble'gakile' c̱hop beṉ' byo, nakwgake' lech' dii chey cheeni', zegake' kwite'ka'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na' noolka' bllebchgagake' na' bc̱hek' yic̱hje'ka' ax̱t lo yona'. Na'ch beṉ'ka' zena' che'gake': ―¿Berac̱he chiyiljzle beena' mban ladj beṉ' wetki? ");
INSERT INTO zadNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kochno de ni. Ba bibane' ladj beṉ' wetki. Ḻi lljadini daa wne' le' kana' zoalene' le' Galileana'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Wne' chonan byen Beena' Bseḻ' Chioza' Yell-lioni gake' lo na' beṉ' malka', na' witgake'ne' ḻee yag cruza', na' ka yiyoṉ lla yibane' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na'ch jadini noolka' daa goll Jesúza' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Na' biza'gake' biyajgake' gana' lle' postlka' shnej len yog' beṉ'ka' sto gokgake'ne' txen, na' be'gake' dill' yog' daa gok c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na' noolkin jayellgake' postlka' daa gok c̱hegake': María beṉ' yell Magdálana', Juánana', María xṉa' Jacóbona', na' len zi baḻ nool yoblə. ");
INSERT INTO zadNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Na' postlka' ni lat' bi wyajḻe'gake' daa goll noolka' ḻegake' daa gokgakile' bizan chon chnagake'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Na' Pédrona' wzee zejdoe' cho'a bana', na' ka blline', bwie' ḻoo bleja' na' ble'ile' lech'ka' chi'gakan ka'lə. Na'ch bizee zjade' gana' zoe' chibanile' ka nak daa ba gok. ");
INSERT INTO zadNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na' lo llana' gok ka', c̱hop beṉ'ka' nak Jesúza' txen wyajgake' to yell dii le Emaús, na' nḻaa ljwellin ka do shnej kilometro kon Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Na' lo zej ngoogake' nez choe'gake' dill' c̱heyi diika' ba gok. ");
INSERT INTO zadNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Na' shlak choe'gake' dill' c̱heyi diika' gok, na' jabig' kwin Jesúza' kwite'ka' na' zejlene' ḻegake' txen. ");
INSERT INTO zadNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Na' ḻa'kzi chwiagake'ne', aga gokbe'gakile' no beena'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Na'ch wṉabi Jesúza' ḻegake': ―¿Bera dillaan choe'le za'le ni? ¿Berac̱he chakyesh'zile? ");
INSERT INTO zadNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Na' toe', beena' le Cleofas, chi'ene': ―Yog'zə beṉ' ṉezgakile' daa ba gok Jerusalénna' llaki ba wde. ¿Astozo' li' bi ṉezilo' daa ba gok? ");
INSERT INTO zadNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Na'ch chi'e ḻegake': ―¿Beran gok? Na'ch che'gake': ―Diika' gok c̱he Jesús, beṉ' Nazareta'. Goke' to beṉ' wdix̱jee daa che' Chioza'ne', na' bene' yeḻ' wak na' bi'e dill' zakii dii nak shḻi lao Chioza' na' lao beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Na' bx̱ozka' chṉabia' na' beṉ'ka' chṉabia'gake' cho' beṉ' Israel bengake'ne' lo na' josc̱hiska' kwenc̱he bc̱hoglogake' c̱he' guete', na' bda'gake'ne' ḻee yag cruza'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Neto' nonnto' lez nan ḻen' yibeje' cho' beṉ' Israel lo na' beṉ' zit'ka'. Na' ba gok shoṉ lla gok diiki. ");
INSERT INTO zadNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Na' baḻ noolka' nak neto' txen wyajgake' cho'a bana' daa baabaḻi, na' ḻe bibaninto' ka wnagake' ");
INSERT INTO zadNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bich ble'gakile' kwerp c̱he'na' gana' bkwash'gake'ne'. Na'ch bila'gake' nagake' ble'gakile' c̱hop anjl, beṉ' goll ḻegake' mbankzə Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Na'ch wyaj baḻ beṉ' byoka' nonlennto' txen cho'a bleja', na' nakan kon ka wna noolka', per aga no Jesúza' ble'gakile'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Na'ch che' Jesúza' ḻegake': ―¡Le' beṉ' bi chajnii! ¡Bi llabia' bat shajḻe'le daa bzej dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake'! ");
INSERT INTO zadNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Abi ṉezile lliakzə bia' biya daa yen ile'i beena' nak Crístona' ka zi' yiyo'e gana' sho'e balaaṉ xenna'? ");
INSERT INTO zadNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Na'ch wzoloe' chzajniile' ḻegake' Cho'a Xtill' Chioza' gana' cho'en dill' c̱he kwine', wzoloe' zigaate kon daa bzej dii Moiséza', na'tech diika' bzej yog' beṉ'ka' wdix̱jee daa goll Chioza' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na' ka bllingake' yella' gana' zejgake', bentezə Jesúza' ka beṉ' shaj gan yoblə. ");
INSERT INTO zadNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Na' beṉ'ka' bengake' byen yigaaṉlene' ḻegake', che'gake'ne': ―Bigaaṉlen neto', ḻa' ba wlle' ṉaa, na' ba chaḻ. Na'ch wyoo Jesúza' bigaaṉlene' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Na' ka ba chi'gake' cho'a mesa', bex̱ee to yetxtil na' bi'e yeḻ' chox̱ken Chioza', na'tech bxoxje'n na' bi'en ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Na'ch biyombia'yeṉ'gake' nan ḻen' Jesúza', na' to binitloze'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Na'ch che' ljwelle': ―¡Bera daan, ax̱t mbalaz inlleb chibayi lall'do'chona' kana' za'cho tneza' choe'lene' cho' dill' chzajniile' cho' Cho'a Xtill' Chioza'! ");
INSERT INTO zadNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na'ch lii biza'tegake' ziyajgake' Jerusalénna'. Na' ka billingake', ndop nllag postlka' shnej na' nochlə beṉ'ka' nakgake'ne' txen, ");
INSERT INTO zadNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","na' gollgake' ḻegake': ―Dii ḻikzan ba biban X̱anchona' ladj beṉ' wetka'. Ba bli'lawe' Simónni. ");
INSERT INTO zadNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na'ch beṉ'ka' c̱hop gollgake' ḻegake' ka gok c̱hegake' tneza', na' ka biyombia'gake' Jesúza' ka bxoxje' yetxtila' bi'en ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Na' shlak ni choe'gake' dillaa, tokonganzi jaze Jesúza' ladje'ka' na' bwape' ḻegake' chiox, chi'e ḻegake': ―Soashgale mbalaz. ");
INSERT INTO zadNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Na' ḻe bllebgake' daa chakgakile' yel bx̱enzan chwiagake'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Na' che' Jesúza' ḻegake': ―¿Berac̱he chllebzle? ¿Bic̱he chak c̱hoplall'zle? ");
INSERT INTO zadNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ḻi wwia ṉi'a na'ki kwenc̱he iṉezile nad'kzan. Ḻi gox̱' nad' kwenc̱he iṉezile aga nak' to yel bx̱en, ḻa' to yel bx̱en bibi bel' bibi llit yoon ka nak' nad'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Na' ka golle' ḻegake' ka', bliile' ḻegake' ṉi'a neena'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Na' yeḻ' chiba chizaki c̱he'ka' na' yeḻ' chibanina', ni bi chakbe'gakile' shi ḻekzen'. Na'ch chi'e ḻegake': ―¿Abi de lat' dii gaocho? ");
INSERT INTO zadNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Na'ch be'gake'ne' lat' beḻ ba bwey'gake' lo yi'na'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Na' bex̱eeb wdawe'b chwiategake'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Na' chi'e: ―Ka nak daa ba gok c̱ha', ḻennan' wnia' le' kana' ni zoalen' le', kana' wnia' llia bia' yillinin gak c̱ha' yog' diika' bzej dii Moiséza', na' diika' bzej dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' na' diika' da' ḻee sálmoka'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Na'ch ben Jesúza' ka wyajni'gakile' diika' na Cho'a Xtill' Chioza', ");
INSERT INTO zadNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","chi'e ḻegake': ―Cho'a Xtill' Chioza' nan: chonan byen Crístona', biya dii yen ile'ile' na' witgake'ne' na' yiyoṉ lla yibane' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na' ḻekzka' nan: ides cho'a xtilleena' daa nan shi yiyaj yileni beṉ' dii malka' chongake' na' yiyakxen c̱hegake'. Na' solozan Jerusalénni na' illiljan doxente. ");
INSERT INTO zadNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Na' le' chiyaḻ' ye'le beṉ' yog' diiki ba ble'ile gok c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na' nad' wseḻaa beena' bc̱heb X̱a' Chioza' goṉe' gaklene' le', na' ḻi soatezə Jerusalénni ax̱t kat'ch X̱a'na' goṉe' le' yeḻ' waka' daa za' yabana'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Na'ch bc̱he' Jesúza' ḻegake' wyajgake' yell Betániana'. Na' bḻis neena' benḻeeye' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Na' ni chonḻeeytie' ḻegake', ka bikwase' kwite'ka' na' biyepe' yabana'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na' beṉ'ka' nakgake'ne' txen, biyoll be'la'ogake'ne', biza'gake' ziyajgake' Jerusalénna' chiba chizakgakile'. ");
INSERT INTO zadNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Na' wzoatezi wzoagake' be'la'ogake' Chioza' yoodo'na'.");
INSERT INTO zadNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ba zoakzə beena' le Xtill' Chios ka wxe wzil yog'ḻoḻte dii de. Ḻen' ba zoalene' Chioza', na' ḻekzen' Chioza', ");
INSERT INTO zadNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","na' dezd nechte ba zoalenkze' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ḻen' bene' yog'te dii de, na' biga de to dii bi bene'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ḻen' cho'e yeḻ' mban, na' nake' beeni' c̱he beṉ' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na' beeni' c̱he'na' chzeeni'n yell-lioni gani nak shgasj shc̱hoḻ ni c̱he dii mala', na' yel c̱hoḻa' bi bizoyin yisolan beeni'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wzoa to beṉ' bseḻ' Chioza' wlie' Juan. ");
INSERT INTO zadNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Juanna' bidyee dill' c̱he beena' nsa' beeni'na' kwenc̱he yog' beṉ' gonḻilall'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Aga Juanna'yeṉ'nan nsee beeni'na', san to bidtix̱je'ze' c̱he beena' nsa' beeni'nan'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Beena' nsa' beeni'na' daa nak dowalj daa wzeeni'n lao yog'ḻoḻ beṉ', ba zee yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Na' beena' nsa' beeni'na' bidsoe' yell-lioni, na' ḻa'kzi ḻe' bx̱e bsile' yell-lioni, beṉ'ka' lle' lawinna' aga gokbe'gakile' non nake'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Blline' ladj beṉ'ka' nak beṉ' yell c̱he', na' ḻegake' bi blebgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Per yog' beṉ'ka' blebgake'ne' na' benḻilall'gake'ne', bene' ḻegake' xiiṉ Chios. ");
INSERT INTO zadNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Na' aga daa nakgake' beṉ' de beli chenan, wa daa cheeni beṉ' soalen ljwellen', ni aga daa cheeni beṉ' soa xiiṉen', san daa benḻilall'gake'nen' gokgake' xiiṉ' Chios. ");
INSERT INTO zadNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na' beena' le Xtill' Chios golje' goke' to beṉ' de beli chen na' wzoe' ladjnto'ni. Na' ble'into'ne' nake' beṉ' zakii nlleb daa nake' Xiiṉ tlish' tyaj X̱acho Chioza', na' nake' beṉ' lall'do' xen inlleb na' bli'e do ka nak dii ḻina'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Na' Juanna' bi'e dill' c̱he' wne': ―C̱he beenin bzajniid' le' kana' wnia': “Beena' zi' za' nake' beṉ' zak'chi aga ka nad', ḻa' ba zoakze' kana' zi' soa' nad'.” ");
INSERT INTO zadNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Daa nake' beṉ' wen inlleb na' daa chakchgaile' cho', dii zan dii wenka' ba bene' c̱he yog'cho. ");
INSERT INTO zadNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dii Moiséza' bzajniile' cho' diika' bllia Chioza' bia' goncho; per Jesucrístona' bli'e yeḻ' chiyesh'lalli c̱he Chioza' len dii ḻi c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni to konoṉ' ile'i Chioza', per Xiiṉe'na' nak tlish' tyaj, beena' zoalene'ne', ḻen' bidliile' cho' ka nake'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Beṉ' wṉabia' c̱he beṉ' Israelka' lle' Jerusalénna' bseḻ'gake' to c̱hop bx̱oz na' sto c̱hop beṉ'ka' nak xiiṉ dia c̱he dii Levína' kwenc̱he jaṉabgakile' Juanna' non nake'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Na' bi bkwashee non nake', san golle' ḻegake': ―Aga nadaan Crístona', beena' chbezcho wseḻ' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Na'ch wizṉabgakile'ne': ―¿Norakzan nako' shka'? ¿Alin' Elíaza', beena' wdix̱jee daa goll Chioza'ne' kani'yi? Na' Juanna' chi'e: ―Aga ḻe' nad'. Na'ch chize'gake'ne': ―¿Alin' beena' ba llia bia' yid kwenc̱he c̱hix̱ji'e daa che' Chioza'ne', shka'? Na' che' Juanna': ―Akza ḻe' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Na'ch che'gake'ne': ―¿Norakzə li', shka'? Cheeninto' iṉezinto' kwenc̱he lljayellnto' beṉ'ka' bseḻ' neto' non nako'. ¿Bi ka iṉo' c̱he kwino'? ");
INSERT INTO zadNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Na'ch che' Juanna' ḻegake': ―Dii Isaíaza', beena' wdix̱jee daa goll Chioza'ne' kani'yi, dill' c̱han' bi'e kana' wne': “To beṉ' gosyee zillj latja' gana' bibi chashj chḻeb, na' iṉe': Ḻi se kwas kwenc̱he wzenagle c̱he X̱anchona' kat' zee.” ");
INSERT INTO zadNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na' beṉ'ka' bseḻ' fariseoka' ");
INSERT INTO zadNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","wṉabgakile'ne': ―¿Berac̱he chchoazo' beṉ' nis shi aga lin' Crístona', ni Elíaza', ni beena' llia bia' wseḻ' Chioza' kwenc̱he c̱hix̱ji'e daa chi'ene'? ");
INSERT INTO zadNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Na' che' Juanna' ḻegake': ―Nad' chchoa' beṉ' nis, per ladjleni zoa to beṉ' bi nombia'le, ");
INSERT INTO zadNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","na' ḻen' zi' wli'lawe'. Na' nad' ni bi zakaa gak' xmose' kwenc̱he galj' ḻa'c̱h' xele'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yog' diiki gok gana' le Betania, daa llia shḻaa yao Jordanna', gana' bchoa Juanna' beṉ' nisa'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na' betiyo ble'i Juanna' Jesúza' zeje' kwite'na', na' chi'e: ―Ḻi wwia, beenin bseḻ' Chioza' na' zaklebile' xil'do'na' chitcho, ḻa' ḻen' yikwase' saaxya c̱he beṉ' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na' xtill' beenin bi'a kana' wnia': “Zi' za' to beṉ' zak'chi ka nad', na' ba zoakz beeni kana' zi' soa'.” ");
INSERT INTO zadNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ni nad' bi wṉezid' no xtilliin bi'a, per kwenc̱he gombia' beṉ' Israelki ḻe', bidchoa' beṉ' nis. ");
INSERT INTO zadNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Na' Juanna' wizne': ―Ble'id' Espíritu c̱he Chioza' betje' yabana' nake' ka to palom na' jsoalene' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ḻa' ni nad' bi wṉezid' no xtilliin bi'a, per Chioza', beena' bseḻ' nad' chchoa' beṉ' nis, wne': “Ile'ilo' yetj Espíritu c̱ha'na' lljsoalene' beena' wlej', na' ḻen' gone' ka yidsoa Espíritu Sántona' ḻoo yic̱hjlall'do' beṉ'.” ");
INSERT INTO zadNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ba ble'id' gok ka wna Chioza' nad', na' ṉaa nia' le' beenin Xiiṉ Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Na' betiyo Juanna' zelene' c̱hop beṉ'ka' nakgake'ne' txen. ");
INSERT INTO zadNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Na' ka ble'ile' chda Jesúza' na', na'ch chi'e: ―Ḻi wwia, beenin bseḻ' Chioza' na' zaklebile' xil'do'na' chitcho kwenc̱he chiyakxen saaxya c̱hechoka'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Na' c̱hop beṉ'ka' nak Juanna' txen, ka bengakile' wna Juanna' ka', na' janogake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Na'ch ka biyec̱hj Jesúza', ble'ile' zjanogake'ne' na' chi'e ḻegake': ―¿Bin cheenile? Na' che'gake'ne': ―Rabí, ¿garan zo'? (Na' Rabí zejin: beṉ' chli' chsedi beṉ'.) ");
INSERT INTO zadNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Na' che' Jesúza': ―Ḻi da wwiale. Na'ch wyajlengake'ne' na' jale'gakile' gana' zoe', na' bigaaṉlengake'ne' ax̱t ka wde llana', ḻa' ka do chida tapan billinlengake'ne' gana' zoe'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na' beena' le Andrés, beṉ' bish' Simón Pédrona', len sto beṉ' yoblə gokgake' c̱hopə janogake' Jesúza' ka bengakile' daa wna Juanna' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Na' Andréza' lii jadiljtie' beṉ' bishee Simónna', na' chi'ene': ―Ba billelinto' beena' nak Mesíaza'―. Na' Mesías zejin Cristo, beena' chbezgake' wseḻ' Chioza' kwenc̱he iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Na'ch Andréza' bc̱hi'e Simónna' gana' zoa Jesúza', na' ka ble'i Jesúza'ne', chi'ene': ―Lin' Simón, xiiṉ Jonáza', na' ṉaa yilio' Cefas―. Na' Cefas zejin Pedro. ");
INSERT INTO zadNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Na' betiyo ka zi' yiyaj Jesúza' gana' mbani Galileana', billague' Felípena' na' chi'ene': ―Da dino nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felípena' nake' beṉ' yell Betsaida, gana' nak lall Andréza' na' Pédrona'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Na'ch jadilj Felípena' Natanaela' na' chi'ene': ―Ba billelinto' beena' bzej dii Moiséza' xtilleena' ḻee libr c̱he leya'. Na' ḻekzka' c̱hen' bzej dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yi. Ḻen' Jesúza', beṉ' Nazareta', xiiṉ Joséna'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Na' Natanaela' chi'ene': ―¿Aka Nazareta' ichej to beṉ' zakii? Na' Felípena' golle'ne': ―Dakachi kwenc̱he gakbe'ilo'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Na' ka ble'i Jesúza' zej Natanaela' gana' zie', golle': ―Ni za' to beṉ' nak dowalj beṉ' Israel, to beṉ' bi nak beṉ' wxiye'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Na'ch goll Natanaela'ne': ―¿Nakra chak nombi'o nad'? Na' Jesúza' golle'ne': ―Ka zi' yidṉelə Felípena' li', ble'id' li' xan yag yix̱wewa'. ");
INSERT INTO zadNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Na' goll Natanaela'ne': ―Maestro, lin' nako' Xiiṉ Chioza'. Na' lin' beena' zidṉabia' neto' beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Na' goll Jesúza'ne': ―¿Adaa wnia' ble'id' li' xan yag yix̱wewan' chajḻi'o c̱ha'? Zi' ile'chilo' dii xench aga ka dga. ");
INSERT INTO zadNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Na' ḻekzka' gollch Jesúza': ―Dii ḻi nia' le', ile'ile yabana' nyaljan, na' beṉ'ka' nak anjl c̱he Chioza' chep chetjgake' lawa', nad', Beṉ' Bseḻ' Chioza' Yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Na' biyoṉ lla got' to wishagna' yella' le Caná daa llia gana' mbani Galileana', na' na' len xṉa' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Na' ḻekzka' goxgake' Jesúza' na' beṉ'ka' nakgake'ne' txen. ");
INSERT INTO zadNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Na' shlak chak lṉina' bibill vino c̱he'ka', na' goll xṉa' Jesúza'ne': ―Ba bibill vino c̱he beṉ'ki. ");
INSERT INTO zadNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Na'ch che' Jesúza'ne': ―¿Berac̱he nazo' nad' ka'? Biṉ' gaḻ' gon' daa llia bia' gon'. ");
INSERT INTO zadNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Per xṉeena' golle' wen mandadka': ―Ḻi gon kon bin iṉe' le'. ");
INSERT INTO zadNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na' na' zoa x̱op yes' xen de yaj, dii choll nis, diika' chon llin kat' beṉ' Israelka' chixi chiyechgake' kon ka na ley c̱he'ka'. Na' to to yes'ka' chollan ka do shoṉ yid nis. ");
INSERT INTO zadNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Na' che' Jesúza' wen mandadka': ―Ḻi kaa nisa' ḻoo yes'ki. Na' wda'gake'n ax̱t ka billa'chagakan. ");
INSERT INTO zadNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Na'ch che' Jesúza' ḻegake': ―Ḻi gash' lataan ṉaa na' ḻi lljeen beena' ngoo lo neen. Na' bengake' ka golle'. ");
INSERT INTO zadNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Na' beena' ngoo lo neen bnix̱e' nisa' daa biyak vino, ni bi ṉezile' ga wza'n. Tochga wen mandadka' ṉezgakile', ḻa' ḻegaken' wdaagake' nisa'. Na'ch beena' ngoo lo neen goxe' bi'na' chshagna', ");
INSERT INTO zadNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","chi'eb': ―Yog' beṉ' zigaate chdie' vino wenna', na' kat' ba weej beṉ'ka' len lṉina' dii zil, na'ch chdie' daa bi naktek wen. San li', ba bzagoo vino wenni na' ax̱t ṉaach chdio'n. ");
INSERT INTO zadNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yeḻ' waki dga ben Jesúza' yell Canána' daa llia gana' mbani Galileana', ḻennan' bene' dii nech. Na' ka' bli'e yeḻ' wak c̱he'na' nape', na'ch beṉ'ka' nongake' ḻe' txen benḻilall'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Na' ka wde, biyaje' Capernaúma' len xṉeena', len beṉ' bisheeka' na' len beṉ'ka' nakgake'ne' txen, na' wzoagake' na' to c̱hop shoṉ lla. ");
INSERT INTO zadNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Na' ka ba zoa gaḻ' lṉi Paskwa' daa chon beṉ' Israelka', wyaj Jesúza' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na' ka blline' lesh' chyoodo'na', ble'ile' lle' beṉ' chit'gake' gooṉ, xil', na' palom, na' ḻekzka' na' chi' beṉ'ka' chisha' mecha'. ");
INSERT INTO zadNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Na' ka ble'ile' ka chak, bene' to do tashj, na' kon ḻen bisheshile' yog'ḻoḻe' lesh' chyoodo'na' lente gooṉka' na' xil'ka'. Na' bzaḻee xmech beṉ'ka' chisha' mecha' lo yona' na' bishi'e mes c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Na' beṉ'ka' chit' palomka', golle' ḻegake': ―¡Ḻi yishesh baki ni! ¡Bi gonzle lill X̱a'na' ka lao yaa! ");
INSERT INTO zadNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na'ch beṉ'ka' nakgake'ne' txen jadingakile' Cho'a Xtill' Chioza' gana' nan: “Daa ḻe chakid' lill xḻatjo'na' ḻen wlliayi'n nad'.” ");
INSERT INTO zadNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Na'ch beṉ' Israelka' lle' na' che'gake' Jesúza': ―¿Bi yeḻ' wak gono' dii wli'n napo' yeḻ' wṉabia' kwenc̱he chono' diiki? ");
INSERT INTO zadNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Na' che' Jesúza' ḻegake': ―Ḻi yic̱hinj yoodo'ni na' lo shoṉə llazə yiyona'n. ");
INSERT INTO zadNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Na'ch che' beṉ' Israelka' ḻe': ―X̱opiyon yiz bengake' yoodo'ni, na' li' nazo' shoṉə llazə yiyono'n. ");
INSERT INTO zadNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Per daa goll Jesúza' ḻegake' ka', kwerp c̱he'nan' bsaklebile' yoodo'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Na'ch ka biban Jesúza' ladj beṉ' wetka', jadini beṉ'ka' nakgake'ne' txen daa wne', na' wyajḻe'gake' Cho'a Xtill' Chioza' na' dill'ka' be' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na' shlak zoa Jesúza' lṉi Paskwa' Jerusalénna', beṉ' zan wyajḻe'gake' c̱he' daa ble'gakile' yeḻ' wakka' bene'. ");
INSERT INTO zadNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Per Jesúza' bi bx̱enilallee ḻegake', ḻa' nombi'e yic̱hjlall'do' yog'ḻoḻ beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Aga byalljile' no yee ḻe' nakan nak beṉec̱ha', ḻa' kwasḻoḻ nombi'e yic̱hjlall'do'eka'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wzoa to fariseo beṉ' wle Nicodemo, na' goke' to beṉ' wṉabia' ladj beṉ' Israelka'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Na' Nicodémona' wyaje' jawie' Jesúza' waḻ-lə na' chi'ene': ―Maestro, ṉezinto' Chioza' bseḻee li' kwenc̱he wli' wsedilo' neto', ḻa' bi gak gono' yeḻ' wakka' chono' sheḻ' bi zoalen Chioza' li'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Na'ch Jesúza' chi'ene': ―Dii ḻi nia' li', beena' bi yiyalj dii yoblə aga wak lljazoe' gana' chṉabia' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Na' che' Nicodémona'ne': ―¿Nakra gon to beṉ' gol yiyaljze' dii yoblə? Ḻa' aga wak yiyo'e ḻoo ḻee xṉeena' kwenc̱he yiyalje' sto shii. ");
INSERT INTO zadNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Na' Jesúza' chi'ene': ―Dii ḻi nia' li', kono gak yiyaj gana' zoa Chioza' chṉabi'e shi biṉ' galjlenile' nis na' yikob Espíritu c̱he Chioza' yic̱hjlall'do'ena' kwenc̱he gake' ka beṉ' galj sto shii. ");
INSERT INTO zadNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Beena' nak xiiṉ beṉ' de beli chen, de beli chenchokzan nake'. Per beena' chikob Espíritu c̱he Chioza'ne', nake' xiiṉ Chios na' de to yeḻ' mban c̱he' daa bi te c̱heyin. ");
INSERT INTO zadNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bi yibanilo' daa nia' li': “Yog' beṉ' chiyaḻ' galje' dii yoblə.” ");
INSERT INTO zadNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kat' chze be'na' na' chajan kon ga cheenin, na' ḻa'kzi chenicho ka sshag chonan aga ṉezicho galan za'n, ni bi ṉezicho galan zejan. Ḻekzkan' aga ṉezicho nakan chon Espíritu c̱he Chioza' kwenc̱he chiyalj beṉ' dii yoblə. ");
INSERT INTO zadNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Na'ch wizṉabi Nicodémona'ne': ―¿Nakra gak gakz dga? ");
INSERT INTO zadNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Na' che' Jesúza'ne': ―Len naktio' to beṉ' chli' chsedi beṉ' Israelki, ¿ana' bi ṉezilo' diiki? ");
INSERT INTO zadNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Dii ḻi nia' li', choe'nto' dill' c̱he daa ṉezinto' na' daa ben ble'into', per bi chajḻe'le daa nanto' le'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Shi bi chajḻe'le daa wnia' le' c̱he diika' chak yell-lioni, ¿alechlə shi we'len' le' dill' c̱he daa nak c̱he yabana'? ");
INSERT INTO zadNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ni to konoṉ' shep yabana', toz nad', Beṉ' Bseḻ' Chioza' Yell-lioni, nak' beṉ' za' yabana'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Na' ka ben dii Moiséza' gana' bibi chashj chḻeb bdee beḻ de broncena' ḻee yaga', ka'kzan gongakile' nad', Beṉ' Bseḻ' Chioza' Yell-lioni. Wda'gake' nad' ḻee yaga' ");
INSERT INTO zadNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kwenc̱he nottez beṉ' gonḻilall' nad' bi kwiayee, san gat' to yeḻ' mban c̱he' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Daa ḻe chakchgayi Chioza' beṉ' yell-lioni, bseḻee Xiiṉe'na' tlish' tyaj kwenc̱he nottez beṉ' gonḻilalleene' bi kwiayee, san gat' yeḻ' mban c̱he' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Chioza' bseḻee xiiṉe'na' yell-lioni aga kwenc̱he wlliayee beṉaan, san kwenc̱he yisle' ḻegaken'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Beena' nonḻilall' Xiiṉ Chioza', bich nchoglo c̱he' sak'zi'e, san beena' bi nonḻilalleene', ba nchoglo c̱he' kwiayee daa bi nonḻilallee Xiiṉ tlish' tyaj Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ba nchoglo kwiayi' beṉ' yell-lioni daa ba bla' beena' nsa' beeni'na', na' daa chongake' dii mala', wyazlall'chgake' yel c̱hoḻa' aga ka beeni'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yog' beṉ'ka' chon diika' bi yejni'alallii chakzbangakile' beeni'na', na' aga willjabig'lat'gake' lawinna' daa chllebgake' wli'lawi dii mala' chongake'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","San beṉ'ka' zoagake' chongake' ka na dill' ḻi c̱he Chioza', chbig'gake' lao beeni' c̱he'na' kwenc̱he gakbia' chongake' ka cheeni Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ka wde, wyaj Jesúza' Judeana' len beṉ'ka' nakgake'ne' txen na' wzoagake' na' xtit wen, na' bchoagake' beṉ' nis. ");
INSERT INTO zadNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Na' Juanna' ḻekzka' chchoe' beṉ' nis gana' le Enón, gaozə gana' le Salim, ḻa' na' de nis zil, na' chaj beṉ' kwenc̱he chchoe' ḻegake' nisa'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Diiki gokgakan kana' zi' koogake' Juanna' lillyana'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na'ch beṉ'ka' nakgake' Juanna' txen gokdiḻ-lengake' sto beṉ' Israel ni c̱heyi diika' yoologake' chongake' kwenc̱he chixi chiyechgake' lao Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Na' wyajgake' jellgake' Juanna': ―Maestro, beena' wzeleno' shḻaa yao Jordanna', beena' bi'o xtilleena', ba chchoe' beṉ' nis na' yog'zə beṉ' chajgake' kwite'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Na'ch che' Juanna' ḻegake': ―Kono gak bi gon shi Chioza' bi wi'e latj. ");
INSERT INTO zadNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kwinkzle benile kana' wnia' aga nadaan Crístona', beena' chbezcho wseḻ' Chioza', san nak' to beṉ' bseḻee kwenc̱he kwialoa' lawe'na' na' yep' beṉ' wzenaggake' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","To ga chak wishagna', bi'na' chshagnan' ikaab' noola'. Na' bi'na' nllaguib' chi'b' kwitbaa, ḻe chibaib' ka chenib' chshaljb'. Kayeṉ'nan chak c̱ha', ḻe chibaid' daa chzenaggake' c̱he Crístona'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ḻen' zizikchli seyi c̱he', na' nad' bichtek seyi c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Ka nak beena' za' yabana', ḻen' zak'chi' aga ka yog'ḻoḻ beṉ'. Na' beṉ'ka' lle' yell-lioni, chinogake' daa de lo yell-lionizə, na' c̱he yell-lionizə choe'gake' dill'. San beena' za' yabana' zak'che' aga ka yog'ḻoḻte beṉ', ");
INSERT INTO zadNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","na' choe' dill' c̱heyi diika' ba ben ble'ile' yabana', per baḻchga beṉ' chajḻe' xtilleena'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Na' nottez beena' chajḻe' c̱he', chli'e Chioza' cho'e dill' ḻi. ");
INSERT INTO zadNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Beena' bseḻ' Chioza', cho'a xtill' Chiozan' cho'e, ḻa' Chioza' no'ene' do ka nak Espíritu c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Chioza' chakile' Xiiṉe'na', na' ba bene' lall' nee yog'ḻoḻte dii de. ");
INSERT INTO zadNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na' beena' gonḻilall' Xiiṉ Chioza' gat' yeḻ' mban c̱he' zejḻi kaṉi. Per beena' bi cheeni gonḻilalleene' bi gat' yeḻ' mban c̱he' zejḻi kaṉi, san ile'ile' yeḻ' zak'zi'na' we' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseoka' gokbe'gakile' beṉ' zanch nakgake' Jesúza' txen, na' beṉ' zanch chchoe' nisa' aga ka Juanna', ");
INSERT INTO zadNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ḻa'kzi aga kwin Jesúzan' bchoe' beṉ' nisa', san beṉ'ka' nakgake'ne' txenan. ");
INSERT INTO zadNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Na' ka gokbe'i Jesúza' ba ṉezi fariseoka' beṉ' zanch nakgake'ne' txen, na'ch bizee gana' mbani Judeana' ziyaje' gana' mbani Galiléana'lə. ");
INSERT INTO zadNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na' kwenc̱he yilline' gana' mbani Galileana' chiyaḻ' yidie' gana' mbani Samáriana'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Na' billingake' to yell dii le Sicar, daa llia gana' mbani Samáriana'. Na' yella' llian gaozə gana' de yell-liona' be' dii Jacoba' xiiṉe' dii Joséna'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na' lo yell-liona' llia posa' wden dii Jacoba'. Na'ch wche' Jesúza' cho'a posa' daa ba chjx̱akchgaile' zingwee neza'. Na' ba chonan ka gobill. ");
INSERT INTO zadNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Na' beṉ'ka' nakgake'ne' txen zejgake' yella' zjx̱i'gake' daa gaolengake'ne'. Na' cho'a posa' chi' Jesúza' ka bllin to noolə Samaria zjx̱i'e nisa'. Na' che' Jesúza'ne': ―Beṉ lat' nis yeej'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Na'ch che' noolə Samáriana'ne': ―¿Berac̱he chṉabzilo' nad' nisa' yeejo'?, ḻa' beṉ' Israel li', na' nool Samaria nad'. Golle' ka' ḻa' beṉ' Israelka' bi zoalengake' wen beṉ' Samáriaka'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Na'ch che' Jesúza'ne': ―Sheḻ'ka' ṉezshailo' daa choṉ Chioza' na' no nad' chṉabid' li' nisa' yeej', ba wṉabilo' nad' goṉ daa yeejo', sheḻ'ka', ḻa' nap' to nis yaa nis ban daa goṉ li'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Na' noola' chi'ene': ―Beṉ'do', bibi nox̱oo wḻepilo' nisa', na' posi ḻe zitjan. ¿Gara lljx̱i'o nis yaa nis banna' goṉo' nad' nazo' ka'? ");
INSERT INTO zadNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Dii x̱ozxto'cho Jacoba' bkwaaṉlene' neto' posi gani weeje', na' weej xiiṉe'ka' na' bayix̱' c̱he'ka'. ¿Achakilo' zak'chilo' ka ḻe'? ");
INSERT INTO zadNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Na' che' Jesúza'ne': ―Nottezə beṉ' cheeje' nis c̱he posi, wbiḻchkzile' dii yoblə. ");
INSERT INTO zadNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","San beena' yeej nisa' daa wi'ane', aga wbiḻchile'. Ḻa' nisa' daa wi'ane' nakan ka to dii galchga ḻoo yic̱hjlall'do'ena' na' gonan ka gat' yeḻ' mban c̱he' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Na'ch che' noola'ne': ―Beṉ'do', beṉ nad' nisa' no' ka' kwenc̱he bich ibiḻid' na' bich yid beja' ni. ");
INSERT INTO zadNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Na' che' Jesúza'ne': ―Biyaj jaṉe beṉ' c̱ho'na', na' dalene' ni. ");
INSERT INTO zadNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Na' che' noola'ne': ―Aga no beṉ' c̱ha' zoa. Na' Jesúza' chi'ene': ―Lekzilo' no' ka', aga no beṉ' c̱ho' zoa. ");
INSERT INTO zadNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ḻa' ba gok gay' beṉ' c̱ho'ka', na' beena' zoaleno' ṉaa ni bi nshagna'lenkzo'ne'. Shḻikzan ba wṉio'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Na'ch noola' chi'ene': ―Beṉ'do', ba gokbe'id' nako' to beṉ' chyix̱jee daa na Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Dii x̱ozxto'nto'ka' be'la'ogake' Chioza' lo yaani, na' le' beṉ' Israel nale chonan byen we'la'ochone' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Na' che' Jesúza'ne': ―Noolə, wyajḻe' c̱ha', wllin lla kat' bich gonan byen yidle lo yaani, ni bich gonan byen shajle Jerusalénna' kwenc̱he we'la'ole X̱acho Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Le' beṉ' Samaria ni bi nombia'le non choe'la'ole, san neto' beṉ' Israel nombia'nto' Chioza', beena' choe'la'onto', ḻa' ladjnto'nan' ichej beena' yisle' beṉ' kwenc̱he bi kwiayi'gake'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ba zoa illin lla, wa ba bllinkz llana' beṉ'ka' dii ḻi choe'la'ogake' X̱acho Chioza' we'la'ogake' beena' nak dowalj Chios do yic̱hj do lallgake', ḻa' kan' chaklall' X̱acho Chioza' we'la'ochone'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Chioza' nake' Espíritu, na' beṉ'ka' cheengakile' we'la'ogake'ne', chiyaḻ' we'la'ogake'ne' dowalj na' do yic̱hj do lall'gake'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Na' che' noola'ne': ―Ṉezid' wla' beena' chbezcho wseḻ' Chioza' beena' nsi'e Mesías wa Cristo. Na' kat' yide', wzajniile' cho' yog' diiki. ");
INSERT INTO zadNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Na' che' Jesúza'ne': ―Nad'kzan' beena' no' ka', na' ḻen' chshaljlene' li'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na' shlak choe'lene' noola' dill', billin beṉ'ka' nakgake'ne' txen na' bibangakile' daa chshaljlen Jesúza' to noolə. Per ni toe' bi biyaxji iṉabile'ne' bin cheeni noola' wa bi dillaan chshaljlene'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Na'ch noola' bkwaaṉe' chee nis c̱he'na' na'zə, na' biyaje' jayelle' beṉ' wlall c̱he'ka': ");
INSERT INTO zadNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ḻi da lljawiacho to beṉ' ba wne' nad' yog' diika' ba ben'. ¿Aaga ḻen' Crístona', lla? ");
INSERT INTO zadNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Na'ch blleshgake' yella' wyajgake' gana' chi' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Na' shlak ziyaj noola' zeyid beṉ'ka' nak Jesúza' txen che'gake'ne': ―Maestro, wdao lat'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Na' Jesúza' chi'e ḻegake': ―De to yeḻ' wao c̱ha' daa bi nombia'le. ");
INSERT INTO zadNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Na'ch che' ljwell beṉ'ka' nakgake'ne' txen: ―¿Anti no ba bidwa' dii wdawe', lla? ");
INSERT INTO zadNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Na' che' Jesúza' ḻegake': ―Yeḻ' wao c̱ha'na' nakan daa chon' ka cheeni beena' bseḻ' nad' na' wzeeloa' daa cheenile' gon'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Le' nazle: “Chyalljch zi tap beo' kwenc̱he yizi' yilapcho.” Per nad' nia' le', ḻi wwiakachi ba de daa yizi' yilapcho. ");
INSERT INTO zadNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Beena' chyix̱jee cho'a xtill' Chioza' ṉaa, zaklebile' to beṉ' ba chilaḻile' chizi' chilape'. Na' beṉ'ka' chzenag daa chyix̱ji'e, gat' to yeḻ' mban c̱hegake' zejḻi kaṉi, na' beena' goz yibalenile' beena' chizi' chilap. ");
INSERT INTO zadNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nakan ka dillaa de daa na: “Beṉ' yoblan chaz na' beṉ' yoblə chizi' chilap.” ");
INSERT INTO zadNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nad' ba bseḻaa le' lljalaple gana' bi bllaglole gozle, ḻa' le' gonle ka wzenag beṉ' cho'a xtill' Chioza' daa wdix̱jee beṉ' yoblə. ");
INSERT INTO zadNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Beṉ' zan beṉ' Samáriaka', beṉ'ka' lle' yell Sicara' benḻilall'gake' Jesúza' daa goll noola' ḻegake': “Ba wne' nad' yog'te dii ba ben'.” ");
INSERT INTO zadNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Na'ch ka bllingake' gana' chi' Jesúza', got'yogakile'ne' kwenc̱he yigaaṉlene' ḻegake'. Na' bigaaṉe' na' c̱hop lla. ");
INSERT INTO zadNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Na' beṉ' zanch benḻilall'gake'ne' daa bengakile' dillaa cho'e. ");
INSERT INTO zadNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Na'ch che'gake' noola': ―Ṉaach ba chajḻe'nto', aga daa wnazo' neto' kan', san kwinkznton' ba beninto' cho'e dillaa na' ṉezinto' dii ḻi ḻekzen' beena' yisla beṉ' yell-lioni kwenc̱he bi kwiayi'gake'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Na' ka gok c̱hop lla, bizee biyaje' gana' mbani Galileana'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kwinkz Jesúza' wne' nan to beṉ' chyix̱jee daa che' Chioza'ne' aga no chgoo ḻe' balaaṉ lalle'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Na' ka billine' gana' mbani Galileana', blebgake'ne' daa ble'gakile' yog' daa bene' Jerusalénna' ka goḻ' lṉi Paskwa'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Na' dii yoblə wizaj Jesúza' yell Canána' daa llia gana' mbani Galileana', gana' biyone' nisa' vino. Na' yella' zoa to beṉ' zakii beṉ' chon llin c̱he beṉ' wṉabia'na', na' zoa to xiiṉe' bi' byo bi shao'b'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Na' ka wṉezile' ba billin Jesúza' Galileana' zizee Judeana'lə, na' wyaje' lawe'na' got'yoile'ne' shaje' lljayene' bi' c̱he'na' daa ba chakshwetb'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Na'ch che' Jesúza'ne': ―Aga wyajḻe'le c̱ha' shi bibi yeḻ' wak gon' ile'ile. ");
INSERT INTO zadNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Na' beṉ' wṉabia'na' chi'ene': ―Beṉ'do', ben goklen dagach ṉaate, shategali biṉ' guet bi' c̱ha'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Na'ch che' Jesúza'ne': ―Biyaj, jawia. Aga wet bi'na'. Na' beena' wyajḻi'e daa goll Jesúza'ne' na' bizee. ");
INSERT INTO zadNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na' ka ba zoa yilline' lille'na' jatiḻ xmose'ka' ḻe', che'gake'ne': ―Ba biyaki bi' c̱ho'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Na'ch wṉabile' ḻegake' ka do bi gor wzolo chiyakshao'lall'b'. Na' che'gake'ne': ―Daa ṉeji do ka chida to bichejb' dii ḻana'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Na'ch gokbe'i x̱abaa biyakshao'lall'b' ka gora' goll Jesúza'ne': “Biyaj jawia. Aga wet bi'na'.” Na' ḻe' len yog' beṉ'ka' zoa lille'na' benḻilall'gake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Dga gok de wchopi yeḻ' wakka' ben Jesúza' Galileana' ka zizee Judeana'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ka wde gok diiki, goḻ' to lṉi c̱he beṉ' Israelka' Jerusalénna', na' biyaj Jesúza' lṉina'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na' Jerusalénna', gaozə cho'a puerta' le Puert C̱he Xil'ka' llia to tang dii le Betesda dill' hebreo. Na' gay' koridor nec̱hjan tanga'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Na' ḻoo koridorka' de beṉ' zan beṉ' we', no beṉ' lc̱hoḻ, no beṉ' bi chak sa' wen, na' no beṉ' net ṉi'a nee, chbezgake' ta nisa'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ḻa' zoa kat' chetj to anjl cho'a tanga' chte' nisa', na' beena' chyobi cho'e ḻoo nisa' chiyoll chta anjla'n chiyakile' bittezə yillwe' che'ile'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na' ladj beṉ'ka' lle' na' len to beṉ' ba gok shin'shoṉichoa yiz bi shawee. ");
INSERT INTO zadNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Na' ble'i Jesúza'ne' na' gokbe'ile' ba wlla die' ka', na'ch chi'ene': ―¿Acheenilo' yiyakilo'? ");
INSERT INTO zadNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Na'ch beena' bi shao' chi'ene': ―Beṉ'do', aga no zoa c̱ha' wḻetje' nad' ḻoo nisi kat' chdan. Na' kat' chakid' yetj' ḻoo nisa', beṉ' yoblə lii chjsho'tie' ḻo'inna'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Na'ch che' Jesúza'ne': ―Biyas, bitob daa c̱ho'na' biyoa'n na' bigoo nez. ");
INSERT INTO zadNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Na' katena' biyakile' na' lii bitobtie' daa c̱he'na' biyo'en na' bigwee nez. Gok dga lla sabda', llana' chombaaṉgake'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Na' beṉ'ka' chṉabia' beṉ' Israelka' gollgake' beena' biyaki: ―Lla chombaaṉcho ṉaa. Aga bi lsens de woo daa c̱ho'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Na'ch che' beena' ḻegake': ―Beena' biyone' nad' ḻen' wne': “Bitob daa c̱ho'na' biyoa'n na' bigoo nez.” ");
INSERT INTO zadNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Na'ch che'gake'ne': ―¿Nora beena' wna li': “Bitob daa c̱ho'na' biyoa'n na' bigoo nez”? ");
INSERT INTO zadNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Na' beena' biyaki aga ṉezile' non biyon ḻe', ḻa' Jesúza' ba bikwase' ladj beṉ'ka' lle' na'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Na'tech billag Jesúza'ne' lesh' chyoodo'na', na' chi'ene': ―Ba biyakilo' ṉaa. Bich bi dii mal gono' kwenc̱he ki wtiḻcho' dii walch. ");
INSERT INTO zadNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Na'ch beena' biyaje' lao beṉ' wṉabia' c̱he beṉ' Israelka' jayelle' ḻegake' nan Jesúza' biyone'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Na' daa ben Jesúza' yeḻ' waka' lla sabda', llana' chombaaṉgake', goklall'gake' witgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Na' Jesúza' chi'e ḻegake': ―X̱a'na' bittezə lla chone' llin na' ka'kzə nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Na'ch beṉ' wṉabia' c̱he beṉ' Israelka' goklall'gake' witgake'ne' aga toz daa wdishje' leya' daa cho'en dill' c̱he llana' chombaaṉgake', san ḻekzka' daa chon kwine' ka Chios daa chi'e Chioza' nake' X̱e'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Na' Jesúza' chi'e ḻegake': ―Dii ḻi nia' le', nad', Xiiṉ Chios, aga bi gak gon' tobia'loz', san daa chle'id' chon X̱a'nan' ḻekzannan' chon'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ḻa' X̱a'na' chakile' nad' na' chliile' nad' yog' diika' chone'. Na' wli'chile' nad' dii zak'techlə ka diiki, dii gonan ka yibanchile. ");
INSERT INTO zadNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ka chon X̱a'na' chisbane' beṉ' wetka' na' chiyo'e yeḻ' mban c̱hegake', ka'kzə chon nad', Xiiṉe', cho'a yeḻ' mban c̱he nottezə beṉ' cheenid' wi'an. ");
INSERT INTO zadNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Na' X̱a'na' aga ga chc̱hogloe' c̱he beṉ', san nad' nak' Xiiṉe', ba bene' lall' na' wc̱hogloa' c̱he yog'ḻoḻ beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Bene' ka' kwenc̱he yog' beṉ' koogake' nad' balaaṉna' ka daa chgoogake' X̱a'na'. Beena' bi chgwee nad' balaaṉ, nad' nak' Xiiṉ Chios, ḻekzka' bi chgwee X̱a'na' balaaṉ, beena' bseḻ' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Dii ḻi nia' le', beena' chzenag xtillaana' na' chonḻilallee beena' bseḻ' nad', gat' yeḻ' mban c̱he' zejḻi kaṉi. Na' aga bi de dii gonan ka c̱hoglo c̱he' sak'zi'e, san ba bile' lo yeḻ' wita' na' ba zoe' lo yeḻ' mban daa bi te c̱heyin. ");
INSERT INTO zadNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Dii ḻi nia' le', wllin lla kat' beṉ' wetka' yengakile' iṉia' ḻegake', nad' nak' Xiiṉ Chios, na' beṉ'ka' yengakile' kat' iṉia' na' yibangake'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","X̱a'na' nape' yeḻ' wak kwenc̱he wi'e yeḻ' mban c̱he beṉ' daa bi te c̱heyin. Ka'kzə ba beṉe' nad' Xiiṉe' yeḻ' wak kwenc̱he wi'a yeḻ' mban c̱he beṉ' daa bi te c̱heyin. ");
INSERT INTO zadNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na' ḻekzka' ba beṉe' nad' yeḻ' wṉabia' kwenc̱he gon' yeḻ' josc̱his daa nak' Beṉ' Bseḻ' Chioza' Yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bi yibanile daa nia' ka', ḻa' wllin lla wllin gor yeni yog'te beṉ' wetka' kat' iṉia' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Na' ka yengakile' iṉia' na'ch yichejgake' ḻoo bana'. Na' beṉ'ka' ben dii wenna' yibangake' na' si'gake' banez to yeḻ' mban daa bi te c̱heyin, na' beṉ'ka' ben dii mala', yibangake' na' c̱hoglo tegake' lo yeḻ' zak'zi'na' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Ni to bibi gak gon' tobia'loz', san chc̱hogloa' c̱he beṉ' kon ka nllia Chioza' bia' gon', na' kon ka nakannan' wc̱hogloa'n. Ḻa' aga chon' kon ka cheenid', san daa cheeni X̱a'na', beena' bseḻ' nad', ḻennan' chon'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Na' shi nad' wi'a dill' c̱he kwin', ṉezid' aga no shajḻe' c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","San zoa to beṉ' cho'e xtillaana', na' ṉezid' daa ne' c̱ha' nakan shḻicha. ");
INSERT INTO zadNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Le' bseḻ'le beṉ' jaṉabgakile' Juanna' bi ka iṉe' c̱ha', na' dillaa daa bi'e c̱ha' nakan dii ḻi. ");
INSERT INTO zadNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ḻa'kzi nad' bi chyalljid' we' beṉ' yell-lioni xtillaa; nia' le' diiki kwenc̱he yilale na' bi kwiayi'le. ");
INSERT INTO zadNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanna' goke' ka to yi' dii bzeeni' na' ḻe bibaile bzenagle c̱he' tolde. ");
INSERT INTO zadNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Daa chon' diika' non X̱a' Chioza' lall' na' gon' choe'n dill' c̱ha', na' zak'chin aga ka daa wna Juanna'. Na' chli'lawin Chiozan' bseḻee nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","X̱a'na', beena' bseḻ' nad', ḻekzka' ba bi'e dill' c̱ha'. Ni shlin bigaṉ' yenile iṉie' ni biṉ' ile'ilene' nak nake'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Na' cho'a xtilleena' biṉ' sho'n ḻoo yic̱hjlall'do'lena', ḻa' bi chajḻe'le c̱ha', nad' beṉ' bseḻee. ");
INSERT INTO zadNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Le' chsedchgale Cho'a Xtill' Chioza' daa chakile ḻe'inna' yillelile naklə ka gonle kwenc̱he gat' yeḻ' mban c̱hele zejḻi kaṉi. Na' ḻa'kzi Cho'a Xtill' Chioza' choe'n xtillaana', ");
INSERT INTO zadNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","aga cheenile gakle nad' txen kwenc̱he gat' yeḻ' mban c̱hele daa bi te c̱heyin. ");
INSERT INTO zadNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Aga chyalljid' no koo nad' balaaṉ. ");
INSERT INTO zadNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Na' nombia' le', na' ṉezid' aga chakile Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","X̱a' Chioza' bseḻee nad' na' ba bid', na' bi chzenagle c̱ha'. San shi yid beṉ' yoblə tobia'loze', beena'lan ḻe gak c̱hele. ");
INSERT INTO zadNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Nakrakzə gonle shajḻe'le c̱ha'? Ḻa' gangazə chgoo ljwell-le balaaṉ, na' bi chinole sho'le balaaṉ c̱he beena' zeelo nak Chios. ");
INSERT INTO zadNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Bi gakile nad' gaw' xya c̱hele lao X̱a' Chioza', ḻa' zoa sto beṉ' gawe' xya c̱hele. Dii Moiséza', beena' nonle lez gaklene' le', ḻen' gawe' xya c̱hele lao X̱a' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ḻa' sheḻ' chajḻe'le daa bzej dii Moiséza', ḻekzka' wyajḻe'le c̱ha', sheḻ'ka'. Ḻa' ḻen' bzeje' xtillaana'. ");
INSERT INTO zadNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Na' daa bi chajḻe'le c̱he daa bzej dii Moiséza', ¿nakra gonle shajḻe'le c̱he diiki nia'? ");
INSERT INTO zadNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Na' ka wde, Jesúza' wyaje' shḻaa nisdo' c̱he Galileana', daa ḻekzka' le nisdo' c̱he Tiberias. ");
INSERT INTO zadNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Na' beṉ' zan janogake'ne' daa ble'gakile' yeḻ' wakka' bene' kana' biyone' beṉ'ka' bi shao'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Na'ch wyep Jesúza' to lo yaa na' wche'lene' beṉ'ka' nakgake'ne' txen. ");
INSERT INTO zadNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na' ba zoa gaḻ' lṉi Paskw c̱he beṉ' Israelka'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ka ble'i Jesúza' beṉ' zan ba bllin gana' chi'e, na' chi'e Felípena': ―¿Gara lljx̱i'cho dii gao yog' beṉ'ki? ");
INSERT INTO zadNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Golle' ka' daa chakile' la'shki bi yee Felípena', ḻa' ba ṉezkzile' nakan gone'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Na' Felípena' chi'ene': ―Aga waki laxj to beṉ' c̱he x̱on' beo' lljx̱i'yicho dii gao yog' beṉ'ki lat' wej. ");
INSERT INTO zadNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Na' sto beena' nak Jesúza' txen lie' Andrés, beṉ' bish' Simón Pédrona', chi'ene': ");
INSERT INTO zadNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ni ze to bi' xkwid' no'ab' gay' yetxtil de cebada na' zi c̱hop beḻ. Per bizə daa par yog' beṉ'ki. ");
INSERT INTO zadNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Na'ch Jesúza' chi'e: ―Ḻi yee yog' beṉ'ka' kwe'gake'. Na' dechga yixdo' gana' lle'gake', na' yog'tie' wche', na' to beṉ' byoka'zə gok ka do gayaa mil. ");
INSERT INTO zadNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Na'ch bex̱' Jesúza' yetxtilka', na' bi'e Chioza' yeḻ' chox̱ken, na' bgone' c̱he c̱he beṉ'ka' nakgake'ne' txen na' ḻegake' be'gake' c̱he yog' beṉ'ka' chi' na' ax̱t ka beljgakile'. Na' ḻekzka' bene' c̱he beḻka'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Na' ka beljgakile', na'ch chi'e beṉ'ka' nakgake'ne' txen: ―Ḻi yitop yog'ḻoḻ dii lao'ka' bichooṉan kwenc̱he bibi gakditj. ");
INSERT INTO zadNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Na'ch bitopgake'n, biyakte shlliṉ xet' diika' bichooṉan lao yetxtilka' gay'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Na' ka ble'i beṉ'ka' yeḻ' waka' daa ben Jesúza', na'ch che' ljwellgake': ―Dii ḻi beenin nake' beena' llia bia' yid yell-lioni kwenc̱he c̱hix̱ji'e daa che' Chioza'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Na' daa gokbe'i Jesúza' cheengakile' yic̱he'gake'ne' kwenc̱he wzoagake'ne' iṉabi'e ḻegake', bicheje' ladje'ka' na' wyepe' toze' zi lat' cha'ch lo yaana'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ka ba chaḻ, beṉ'ka' nak Jesúza' txen biyetjgake' cho'a nisdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Na' biyoogake' to ḻoo barkw kwenc̱he ziyajgake' yell Capernaúma'. Ba goḻ na' biṉ' yillin Jesúza' kwite'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na'ch wzolo wzechga be'na' na' wzolo chas chat' nisdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na' ka do gay' wa x̱op kilómetro ba wza'len barkwa' ḻegake' lo nisdo'na' kat' ble'gakile' Jesúza' zeje' tlo nisdo'na' zjatiḻe' barkwa' na' ḻe bllebgake'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Na' Jesúza' chi'e ḻegake': ―Nad'kzan, ¡bi illeble! ");
INSERT INTO zadNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Na' chibagakile' bigoogake'ne' ḻoo barkwa', na' lii bllintekzgake' gana' chwiagake' illingake'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Na' betiyo gokbe'i beṉ'ka' bigaaṉ shḻaa nisdo'na' nan tochga barkwa' got' na' to beṉ'ka' nonz Jesúza' txen biyoogake'n na' bi len Jesúza' biyoolene' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Na' gaozə gana' wdaogake' yetxtilka' ka wde be' X̱ancho Jesúza' Chioza' yeḻ' chox̱ken, bllin sto c̱hop barkw dii za' yell Tibériaza'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Na' ka gokbe'i beṉ'ka' aga no Jesúza' nḻa' ni beṉ'ka' nakgake'ne' txen, na'ch biyoogake' ḻoo barkwka' ziyajgake' Capernaúma' jadiljgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na' ka bllingake' shḻaa nisdo'na' jadi'gake'ne', na' gollgake'ne': ―Maestro, ¿bat biyedo' ni? ");
INSERT INTO zadNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Na' Jesúza' chi'e ḻegake': ―Dii ḻi nia' le', chiyiljle nad' aga daa wyajni'lati'le bi zejin yeḻ' wakka' benan', san daa wdaozle ax̱t ka beljilen. ");
INSERT INTO zadNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bi yilaḻ yizodzile kwenc̱he gat' dii yeej gaole, ḻa' dii te c̱heyin nak daa. San ḻi gaḻ' kwe'no daa goṉ yeḻ' mban c̱hele zejḻi kaṉi, daa goṉ' nad', Beṉ' Bseḻ' Chioza' Yell-lioni. Ḻa' X̱a' Chioza' ba bene'n lall' na' wi'an. ");
INSERT INTO zadNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Na' che'gake'ne': ―¿Beran chiyaḻ' gonnto' kwenc̱he gonnto' daa cheeni Chioza'? ");
INSERT INTO zadNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Na' che' Jesúza' ḻegake': ―Daa cheeni Chioza' gonle, gonḻilall'le nad', beṉ' bseḻee. ");
INSERT INTO zadNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Na'ch che'gake'ne': ―¿Bera yeḻ' wak gono' ile'into' kwenc̱he shajḻe'nto' c̱ho'? ¿Bi ka gono'? ");
INSERT INTO zadNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Dii x̱ozxto'choka' wdaogake' daa le maná latja' gana' bibi chashj chḻeb, ka na Cho'a Xtill' Chioza' gana' na: “Yeḻ' wawa' daa za' yabana' bi'en wdaogake'.” ");
INSERT INTO zadNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Na' che' Jesúza' ḻegake': ―Dii ḻi nia' le', aga dowaljyeṉ' yeḻ' wao daa za' yabanan' be' dii Moiséza' ḻegake', san X̱a'na' choṉe' daa nak dowalj yeḻ' wao daa za' yabana'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ḻa' nad', beṉ' za' yabana', nak' ka to yeḻ' wao dii choe' Chioza' beṉ' yell-lioki kwenc̱he ibangake'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Na'ch che'gake'ne': ―Beṉ'do', beṉgach neto' toshiizi yeḻ' wawa' no' ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Na' che' Jesúza' ḻegake': ―Nad' nak' ka yeḻ' wawa' daa choe'n yeḻ' mban c̱he beṉ'. Beena' gake' nad' txen, gake' ka beṉ' nelj nlla'i toshiizi. Na' beena' gonḻilallee nad', gake' ka to beṉ' bichga ibiḻi. ");
INSERT INTO zadNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Per kon ka ba wnia' le', ḻa'kzi ba ble'ile nad' bi chajḻe'le. ");
INSERT INTO zadNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yog' beṉ'ka' chon X̱a'na' lall' na', gakgake' nad' txen. Na' beena' gake' nad' txen aga wzoa'ne' ka'lə. ");
INSERT INTO zadNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ḻa' zaa yabana' na' zoa' yell-lioni aga kwenc̱he gon' daa nazan c̱han', san zaa kwenc̱he gon' daa cheeni X̱a'na', beena' bseḻ' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na' X̱a'na', beena' bseḻ' nad', cheenile' bi wi'a latj kwiayi' ni to beṉ'ka' ba wleje' kwenc̱he gakgake' nad' txen. San cheenile' yisban' ḻegake' ladj beṉ' wetka' kat' illin lla te c̱he yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Na' dgan cheeni X̱a'na', beena' bseḻ' nad': chaklallee gat' yeḻ' mban zejḻi kaṉi c̱he yog'ḻoḻ beṉ' gakbe'i nak' X̱iine' na' gonḻilallee nad'. Na' nad' yisbanee ladj beṉ' wetka' kat' te c̱he yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na'ch beṉ' wṉabia' c̱he beṉ' Israelka' wzologake' biz chon chnagake' c̱he Jesúza' daa wne': “Nad' nak' yeḻ' wao daa za' yabana'.” ");
INSERT INTO zadNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Na' che'gake': ―¿Aaga beenin Jesús, xiiṉ Joséna'? Nombia'cho x̱axṉa' beeni. ¿Berac̱he naze': “nad' za' yabana'”? ");
INSERT INTO zadNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Na'ch che' Jesúza' ḻegake': ―Bibi gon iṉazle c̱heyi daa wnia' le'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni to kono gak gon nad' txen shi X̱a'na', beena' bseḻ' nad', bi gone' ḻe' lall' na'. Na' beṉ'ka' nak nad' txen, yisban' ḻegake' kat' te c̱he yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ḻee librka' bzej dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yi nan: “Chioza' wli' wsedile' yog'ḻoḻte beṉ'.” Na' yog' beṉ' chzenag c̱he X̱a'na' na' chajni'gakile' daa ne', ḻegaken' chongake' nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Aga ga zoa beṉ' ba ble'ile' X̱a'na'; toz nad', beṉ' za' yabana', ba ble'idee. ");
INSERT INTO zadNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Dii ḻi nia' le', nottez beṉ' nonḻilallee nad' de yeḻ' mban c̱he' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nadaan nak' ka yeḻ' wawa' daa choe'n yeḻ' mban c̱he beṉ' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Dii x̱ozxto'leka' wdaogake' daa le maná latja' gana' bibi chashj chḻeb na' bia'kzə witgake'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","San nad' cho'a dill' c̱he yeḻ' wao daa za' yabana', na' beena' gawe'n aga bi yeḻ' wit zejḻi kaṉi ile'ile'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nadaan nak' yeḻ' wao daa za' yabana' daa cho'en yeḻ' mban c̱he beṉ'. Beena' gao yeḻ' wawi, ibane' zejḻi kaṉi. Na' yel' wawa' daa wi'ane', ḻennan' beli chen c̱ha'ni daa chzanid' kwenc̱he gat' yeḻ' mban c̱he beṉ' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Na'ch beṉ' Israelka' wzolo chshesh chṉegake', che' ljwelle': ―¿Nakra gon beeni goṉe' beli chen c̱he'na' gaochon? ");
INSERT INTO zadNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Na' che' Jesúza' ḻegake': ―Nad', Beṉ' Bseḻ' Chioza' Yell-lioni, dii ḻi nia' le', shi bi gaole kwerp c̱ha'ni na' shi bi yeejle chen c̱ha'ni, aga wat' yeḻ' mban c̱hele daa bi te c̱heyin. ");
INSERT INTO zadNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ḻa' beṉ'ka' gaogake' kwerp c̱ha'ni na' yeejgake' chen c̱ha'ni, beṉ'kan' gat' yeḻ' mban c̱hegake' zejḻi kaṉi. Na' kat' illin lla te c̱he yell-lioni, nad' yisbangakee ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ḻa' kwerp c̱ha'ni nakan dowalj yeḻ' wao, na' chen c̱ha'ni nakan dowalj dii cheeje'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Beena' gao kwerp c̱ha'ni na' yeeje' chen c̱ha'ni, nake' nad' txen, na' ḻekzka' nad' nakee txen. ");
INSERT INTO zadNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","X̱a'na', beena' bseḻ' nad', zoe' zejḻi kaṉi na' de yeḻ' mban c̱ha' daa mbane' ḻe'. Na' ka'kzan beena' gao beli chen c̱ha'ni ibane' daa wi'ane' yeḻ' mbanna'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Beli chen c̱ha'ni nakan yeḻ' waw dii za' yabana'. Ka nak yeḻ' wawi, aga nakan ka daa le maná daa wdao dii x̱ozxto'leka' na' bia'kzə witgake'. Beena' gao yeḻ' wawa' daa za' yabana', ibane' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Diikin wna Jesúza' shlak bli' bsedile' beṉ' gana' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza' yell Capernaúma'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na' zan beṉ'ka' nogake'ne', ka bengakile' daa wna Jesúza', na' wnagake': ―Lallj inlleb nak dga chli' chsedi beeni. ¿Notgui gon ka ne'? ");
INSERT INTO zadNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Na' Jesúza' gokbe'ile' bi wyazlall'gake' xtillee'na', na'ch wṉabile' ḻegake': ―¿Achakzbanile dga ba wnia' le'? ");
INSERT INTO zadNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Nakra gonle sheḻ'ka' ile'ile nad', Beṉ' Bseḻ' Chioza' Yell-lioni, yiyep' gana' wzaa? ");
INSERT INTO zadNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espíritu c̱he Chioza' cho'e yeḻ' mban c̱he beṉ', ḻa' beli chenna' aga bi zakiin. Dill'ka' ba wnia' gonan ka soalen Espírituna' le' na' gat' yeḻ' mban c̱hele. ");
INSERT INTO zadNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Per bia'kzə zoa baḻ-le bi chajḻe'le. Goll Jesúza' ḻegake' ka', ḻa' dezd nechte ba ṉezkzile' no beṉ'ka' bi chajḻe' c̱he' na' non gon ḻe' lo na' beṉ' malka'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Na' chi'e ḻegake': ―Ba wniakz' le' ni to kono gak gon nad' txen shi X̱a'na' bi gone'ne' lall' na'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Na' lo llana'tez beṉ' zan beṉ'ka' nakgake'ne' txen bkwasgake' bich janogake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Na'ch che' Jesúza' beṉ'ka' shlliṉ, beṉ'ka' nakgake'ne' txen: ―¿Aḻekzka' lenle cheenile yiyajle? ");
INSERT INTO zadNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Na' Simón Pédrona' chi'ene': ―X̱an', aga nochlə c̱heyi zakii wzenagnto', ḻa' tozo' lin' choo dillaa daa chonan ka gat' yeḻ' mban c̱hento' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ba wyajḻe'nto' c̱ho', na' ṉezinto' lin' Crístona', Xiiṉ Chios yaa Chios banna'. ");
INSERT INTO zadNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Na' Jesúza' chi'e ḻegake': ―Ba wlej' shlliṉle gakle nad' txen. Per tole nakle dii x̱iwaa txen. ");
INSERT INTO zadNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Wne' ka' c̱he Jud Scariota', xiiṉ to beṉ' le Simón, ḻa' ṉezile' nan Juda' gone'ne' lall' na' beṉ' malka', ḻa'kzi wlene' beṉ'ka' shlliṉ. ");
INSERT INTO zadNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ka wde dga, Jesúza' wde' doxen gana' mbani Galileana'. Ḻa' bi goklallee shaje' gana' mbani Judeana' daa cheeni beṉ' wṉabia' c̱he beṉ' Israelka' witgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na' ka ba zoa gaḻ' lṉi c̱he ranshdo'ka' daa chon beṉ' Israelka' yog' yiz, ");
INSERT INTO zadNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","beṉ'ka' nak beṉ' bish' golj Jesúza' che'gake'ne': ―Bi yigaaṉo' nizə, san wyaj Judeana' kwenc̱he beṉ'ka' ba non li' txen ile'gakile' yeḻ' wakka' chono'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ḻa' beena' cheeni seyi c̱he', aga chkwashee diika' chone'. Bachgali chono' yeḻ' wakki, jentegan lao yog'ḻoḻ beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ḻa' ni beṉ' bisheekan' bi wyajḻe'gake' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Na'ch che' Jesúza' ḻegake': ―Biṉ' illin lla illin gor gon' daa llia bia' gon'. San le', bat'tez wak shajle. ");
INSERT INTO zadNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Beṉ' yell-lioki bibi de dii gonan ka gakzbangakile' le', san nadaan chakzbangakile' daa chepgakee malan' chongake'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ḻi shaj le' lṉina'. San nad' bi saa, ḻa' biṉ' illin lla illin gor gak c̱ha' daa llia bia'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Biyoll golle' ḻegake' ka' na' bigaaṉe' Galileana' zi xtit. ");
INSERT INTO zadNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Na' ka wde wza' beṉ' bisheeka', ḻekzka' wzee wyaje' lṉina' do ngash'z. ");
INSERT INTO zadNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na' beṉ'ka' chṉabia' beṉ' Israelka' chiyiljgake'ne' lo lṉina', che' ljwellgake': ―¿Garaṉzi beena', lla? ");
INSERT INTO zadNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Na' ladj beṉ'ka' lle' lṉina', beṉ' zan choe'gake' xtill' Jesúza'. Baḻe' che': “Nake' beṉ' wen.” Na' zi baḻe' che': “Bi nake' beṉ' wen, ḻa' chdaze' chziyee beṉ'.” ");
INSERT INTO zadNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Per ni to kono biyaxji we' xtill' Jesúza' ka nḻa'z daa chllebgake' beṉ'ka' chṉabia' beṉ' Israelka'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na' ba zej shoṉ tap lla chak lṉina' ka bllin Jesúza' gana' zoa yoodo'na' na' wzoloe' chli' chsedile' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Na' chibani beṉ' Israelka', na' che' ljwelle': ―¿Nakra chak chli' chsedi beeni beṉ', len aga bi nsede'? ");
INSERT INTO zadNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Na' che' Jesúza' ḻegake': ―Diika' chli' chsedid' aga nakan dii chyiljlall'z', san beena' bseḻ' nad', ḻen' bli' bsedile' nad' diiki. ");
INSERT INTO zadNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nottez beṉ' cheenile' gone' ka cheeni Chioza', wakbe'ile' shi daa chli' chsedid' nakan c̱he Chios wa shi nakan dii chyiljlall'z'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Beena' tobia'loze' cho'e xtillee, balaaṉ c̱he kwinzen' chyilje', san beena' chyilje' sho' beena' bseḻ' ḻe' balaaṉ, ḻen' cho'e dill' ḻi, na' aga bi dill' wxiye' cho'e. ");
INSERT INTO zadNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Dii Moiséza' beṉe' le' ley c̱he Chioza', na' ni tole bi chonle ka nllian bia' gonle. ¿Bic̱he cheenzile witle nad'? ");
INSERT INTO zadNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Na'ch beṉ'ka' lle' na' che'gake'ne': ―Dii x̱iwaan yoo no' ka'. ¿Noran cheeni wit li'? ");
INSERT INTO zadNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Na' che' Jesúza' ḻegake': ―Tochga yeḻ' waka' ba ble'ile ben' llana' chombaaṉcho na' yog'le chibanile. ");
INSERT INTO zadNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Dii ḻi dii Moiséza' bene' byen yog'tele nakle beṉ' byo chiyaḻ' sho'le seṉ daa le circuncisión, ḻa'kzi aga ḻen' wzololene'n, san dii x̱ozxto'leka'ten. Daan chgoole bi' byodo'ka' seṉna' ḻa'kzi nakan lla chombaaṉcho. ");
INSERT INTO zadNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Na' shi choe'le latj sho' bi' byodo'ka' seṉ daa le circuncisión lo llana' chombaaṉcho kwenc̱he gak ka na leya' daa bzej dii Moiséza', ¿bic̱he chllaazle nad' daa biyon' to beṉ' llana' chombaaṉcho? ");
INSERT INTO zadNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Bi wc̱hogḻizle c̱he beṉ' shi bi chle'ile chone', san cheenin iṉezile nakyeṉ'an nakan kwenc̱he we'le dill' kon ka nakan. ");
INSERT INTO zadNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Na'ch baḻ beṉ' Jerusalénka' nagake': ―¿Aaga beenin cheengakile' witgake', lla? ");
INSERT INTO zadNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ḻi wwia ka cho'e dill' ladj lkwe' beṉ', na' ni to kono bi che'. ¿Anti ba chajḻe'lzə beṉ' wṉabia'ka' nan dii ḻi beeni nake' Crístona', beena' wseḻ' Chioza' iṉabi'e, lla? ");
INSERT INTO zadNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Cho' ṉezicho ga beṉ' beeni. San kat' yid beena' nak Crístona', ni to kono iṉezi galə za' beena'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesúza' chli' chsedile' beṉ'ka' yoodo'na', na' ka benile' daa wna beṉ'ka' c̱he', na' wṉie' zillj chi'e: ―Chakzile nombia'le nad' na' ṉezile ga beṉ' nad'. Aga zaa tolazz', san zoa beena' bseḻ' nad', beena' chon kon ka chc̱hebe' gone'. Na' le' bi nombia'lene', ");
INSERT INTO zadNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","san nad' nombi'ane', ḻa' gana' zoen' wzaa, na' ḻen' bseḻee nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Na'ch baḻe' goklall'gake' gox̱'gake'ne', per ni toe' bi bex̱' ḻe', ḻa' biṉ' illin lla illin gor gak c̱he' daa llia bia'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Na' beṉ' zan wyajḻe'gake' c̱he', na' wnagake': ―Kat' yid beena' nak Crístona', beena' wseḻ' Chioza' iṉabi'e, ¿awli'techle' yeḻ' wak aga ka daa chli' beeni, lla? ");
INSERT INTO zadNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na' fariseoka' bengakile' dillaa daa choe' beṉ'ka' c̱he Jesúza'. Na' ḻegake' len bx̱ozka' chṉabia' bseḻ'gake' beṉ'ka' chap yoodo'na' kwenc̱he lljex̱'gake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Na' Jesúza' golle': ―Aga sshach soalen' le', na'ch yiyaa gana' zoa beena' bseḻ' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Na' yiyiljle nad' per aga willelile nad' daa bi gak yidle gana' lljazoa'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Na'ch beṉ' Israelka' che' ljwellgake': ―¿Garan yiyaj beeni na' bich yillelichone', lla? ¿Anti gana' lle' beṉ' wlall c̱hechoka', beṉ'ka' lle' lall beṉ' zit'kan' shaje' kwenc̱he lljasedile' beṉ' griegoka', lla? ");
INSERT INTO zadNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Beran zejin daa ne': “Yiyiljle nad', per aga willelile nad' daa bi gak yidle gana' lljazoa'”? ");
INSERT INTO zadNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na' llana' zeelo gok lṉina', llana' nak lla choo lla xen, wzolla' Jesúza' na' wṉie' zillj, chi'e: ―Shi nole chbiḻi, ḻi da yeejle nisa' daa goṉ' le'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Na' gak kon ka na Cho'a Xtill' Chioza' gana' nan beena' gonḻilallee nad', gak ḻoo yic̱hjlall'do'ena' ka ga chaltit nis yaa nis ban. ");
INSERT INTO zadNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Na' daa wna Jesúza' ka', zejin soa Espíritu c̱he Chioza' ḻoo yic̱hjlall'do' beena' gonḻilall' ḻe'. Ḻa' ka gora' biṉ' yidsoa Espírituna' ḻoo yic̱hjlall'do' beṉ' daa biṉ' sho' Jesúza' balaaṉna' daa llia bia' sho'e kat' yiyepe' gana' zoa Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Na' baḻ beṉ'ka' bengakile' daa wna Jesúza' na' wnagake': ―Dii ḻi beeni nake' beena' llia bia' yid kwenc̱he c̱hix̱ji'e daa che' Chioza'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Na' zi baḻe' che'gake': ―Beenikzan' Crístona', beena' chbezcho wseḻ' Chioza' iṉabi'e. Na' zi baḻe' che'gake': ―¿Achakile ladj beṉ' Galileaka' ichej beena' wseḻ' Chioza' iṉabi'e? ");
INSERT INTO zadNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Cho'a xtill' Chioza' nan lo dia c̱he dii Davina' galj beena' nak Crístona', na' gake' beṉ' yell Belén ka dii Davina'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ka' gok, gokgake' c̱hop shoṉ kwenlə ni c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Baḻe' goklall'gake' gox̱'gake'ne', per ni toe' bi biyaxji. ");
INSERT INTO zadNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na'ch beṉ'ka' chap yoodo'na' billingake' gana' zoa fariseoka' len bx̱ozka' chṉabia'. Na'ch che'gake' ḻegake': ―¿Bic̱he bi bc̱he'lene'? ");
INSERT INTO zadNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Na' beṉ'ka' chap yoodo'na' che'gake': ―Ni to konoṉ' we' dill' ka dillaa choe' beena'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Na'ch che' fariseoka': ―¿Aḻekzka' lenle ba wxiyee? ");
INSERT INTO zadNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ni to beṉ' wṉabia' c̱hechoka', ni neto' fariseo bi chajḻe'nto' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Per beṉ'ki bi nombia'gake' leya', ba wlliayi'gake'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Na' farisewa' le Nicodemo, beena' wyaj lao Jesúza' waḻ-lə, chi'e ḻegake': ");
INSERT INTO zadNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Ley c̱hechona' nan aga wak wc̱hoglocho c̱he to beṉ' iṉacho chone' mal shi biṉ' wzenagcho dillaa wi'e kwenc̱he iṉezicho bin chone'. ¿Anti aga kan' nakan? ");
INSERT INTO zadNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Na'ch che'gake'ne': ―¿Aḻekzka' beṉ' Galilea li'? Bsed kwenc̱he iṉezilo' ni to beṉ' chyix̱jee daa che' Chioza'ne' biṉ' ichej gana' mbani Galileana'. ");
INSERT INTO zadNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Na'ch billeshgake' ziyaj lill c̱he c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Na' Jesúza' wyaje' lo Yaa Olívoza'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na' betiyo ka wyeeni' wizaje' yoodo'na'. Na' beṉ' zan inlleb wbig' kwite'na', na' wchi'e wzoloe' bli' bsedile' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Na'ch beṉ'ka' chli' chsedi leya' len fariseoka' nc̱he'gake' to noolə bidoḻ'lene' to beṉ' byo, na' bzegake'ne' ladj beṉ'ka' lle' na'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Na' che'gake' Jesúza': ―Maestro, ba bidoḻinto' nooli kon to beṉ' byo. ");
INSERT INTO zadNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na' ṉezinto' leya' daa bzej dii Moiséza' nan chiyaḻ' witcho noolka' chon ka' kon yaj. ¿Shera li', bi ka iṉo'? ");
INSERT INTO zadNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Che'gake'ne' ka' kwenc̱hez kwejgake'ne' dill' ga si' sengake' na' gaogake' xya c̱he'. Na'ch Jesúza' bchekee bzeje' lo yona' kon xbene'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Na' daa zeyidgake' chṉabgakile'ne', na' bibe'shawee chi'e ḻegake': ―Beena' bibi saaxya c̱he' de, wak soloe' wtakwe'ne' yaja'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Na'ch bizchekee chizzeje' lo yona'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Na' ka goll Jesúza' ḻegake' ka', na' biza' twej tweje', wzolozan beṉ' golka' na'tech beṉ' xkwid'ka', na' stoz noola' bgaaṉlene' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Na' bibe'shao' Jesúza' dii yoblə, na' chi'ene': ―Noolə, ¿garaṉ beṉ'ka' chao xya c̱ho'? ¿Ani toe' bibi beni li'? ");
INSERT INTO zadNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Na' che' noola'ne': ―Ni toe', beṉ'do'. Na'ch che' Jesúza'ne': ―Ni nad' bibi gonid' li'. Biyaj, na' bich wx̱iṉj wḻeno'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Na'ch Jesúza' bizoloe' choe'lene' beṉ'ka' lle' na' dill', chi'e: ―Nad' nak' beeni' c̱he beṉ' yell-lioni. Beena' gone' nad' txen bich soe' lo yel c̱hoḻ c̱he dii mala', san ḻoo yic̱hjlall'do'ena' gape' beeni' daa nsa' yeḻ' mban zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Na'ch che' fariseoka'ne': ―Li' choe'zo' xtill' kwino', na' daa choe' xtill' kwino' bi nakan dii shajḻe'cho. ");
INSERT INTO zadNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Na' che' Jesúza' ḻegake': ―Ḻa'kzi choa' dill' c̱he kwin', ṉezid' nakan dill' ḻi, ḻa' ṉezid' gan zaa na' gan yiyaa. San le', aga ṉezile gan zaa, ni bi ṉezile gan yiyaa. ");
INSERT INTO zadNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Le' chc̱hoglole c̱he beṉ' ḻega beṉ' yell-lio. San nad' bi chc̱hogloa' c̱he beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Per shi nad' wc̱hogloa' c̱he beṉ', kon ka nakannan' wc̱hogloa'n, ḻa' aga tobia'lozaan chc̱hogloa'n, san X̱a'na', beena' bseḻ' nad', naknto' txen chc̱hoglonto' c̱he beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ley c̱helena' nan shi c̱hop beṉ' toz ka chitiḻi xtilleeka' chiyaḻ' shajḻe'cho c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na' nak c̱hopnto', nad' cho'a dill' c̱he kwin', na' ḻekzka' X̱a'na', beena' bseḻ' nad', cho'e dill' c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Na'ch che'gake'ne': ―¿Garan zoa X̱o'na'? Na' che' Jesúza' ḻegake': ―Ni nad' ni X̱a'na' bi nombia'le. Ḻa' sheḻ' nombia'le nad', ḻekzka' nombia'le X̱a'na', sheḻ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesúza' bi'e dill'ki shlak bli' bsedile' beṉ' latja' gana' chi' daa chgoogake' mech c̱he yoodo'na', per ni to kono bex̱' ḻe' daa biṉ' illin lla biṉ' illin gor gak c̱he' daa llia bia'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Na'ch Jesúza' wizi'e ḻegake': ―Nad' yiyaa, na' yiyiljle nad', na' gana' yiyaa aga wak sa'le, ḻa' lao saaxya c̱heleka' guetle. ");
INSERT INTO zadNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Na'ch beṉ' wṉabia' c̱he beṉ' Israelka' che' ljwellgake': ―¿Acheenile' yiyit kwinen', lla? ¿Adaan naze': “Gana' yiyaa bi gak sa'le”? ");
INSERT INTO zadNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Na'ch che' Jesúza' ḻegake': ―Le' nakle beṉ' yell-lio, na' nad' zaa yabana'. Le' chonle ḻega beṉ' yell-lio, san nad' bi chon' ka le' beṉ' yell-lio. ");
INSERT INTO zadNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Daan nia' le', guetle lao saaxya c̱heleka'. Ḻa' shi bi chajḻe'le nadaan nak' beena' ba wnia' nak', na' guetle lao saaxya c̱heleka'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Na'ch che'gake'ne': ―¿Norakzə li', shka'? Na' che' Jesúza' ḻegake': ―Nadaan nak' beena' ba wṉiakz' le' dii nechte. ");
INSERT INTO zadNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Dii zan dii gak iṉia' dii gaogakan xya c̱hele. Per beena' bseḻ' nad' cho'e dill' ḻi, na' daa wne' nad' ḻennan' choe'len' beṉ' yell-lioni dill'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Na' ḻegake' aga wyajni'gakile' shi xtill' X̱e'nan' choe'lene' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Na' daan chi'e ḻegake': ―Kat' ba bda'le nad', Beṉ' Bseḻ' Chioza' Yell-lioni, to ḻee yag, kana'chan gakbe'ile nak' beena' ba wnia' nak'. Na' gakbe'ile aga ga de to dii ben' to bia'loz', san kon daa bsedi X̱a'na' nad', ḻennan' cho'a dill'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ḻa' X̱a'na', beena' bseḻ' nad', ḻekzen' zoalene' nad'. Bi chbej yic̱hje' nad', ḻa' toshiizi chon' ka chazlallee. ");
INSERT INTO zadNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Na' ka biyoll be' Jesúza' dill'ka', beṉ' zan benḻilall'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Na'ch che' Jesúza' beṉ' Israelka' ba chajḻe' c̱he': ―Shi le' soac̱hec̱hle gonle ka ba wnia', dii ḻi txenan ba nakle nad', shi ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na' gombia'le dill' ḻi c̱ha'na', na' kat' ba nombia'len, gakle ka to beṉ' ba biyell bila' lao daa ntakw nc̱hejan ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Na'ch che'gake'ne': ―Neto' naknto' xiiṉ dia c̱he dii Abrahama' na' ax̱t ṉaanlla aga noṉ' iṉabia' neto' kwenc̱he gonznto' kon daa iṉe'. ¿Berac̱he nazo' yiyell yila'nto'? ");
INSERT INTO zadNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Na' che' Jesúza' ḻegake': ―Dii ḻi nia' le', nottez beena' chon dii mala' nake' ka beṉ' ndoo lawinna' daa chṉabi'an ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","To wen llin aga toshiizi soe' lill x̱ane'na', san xiiṉ x̱an llinna', toshiizi soe' lill x̱e'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Na' shi nad', Xiiṉ Chios, yisell yiḻaa le' lawi dii mala', dii ḻi wiyell wila'le lawinna'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ṉezkzid' nakle xiiṉ dia c̱he dii Abrahama', per cheenile witle nad' daa bi chleble cho'a xtillaani. ");
INSERT INTO zadNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nad' cho'a dill' c̱he daa ba ble'id' gana' zoa X̱a'na', na' le', chonle ka na x̱alena'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Na' che'gake'ne': ―Xiiṉ dia c̱he dii Abrahama' neto'. Na' Jesúza' chi'e ḻegake': ―Sheḻ' nakle dowalj xiiṉ dia c̱he dii Abrahama', kon ka ben dii Abrahama' chonle, sheḻ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ḻa'kzi ba wnia' le' dill' ḻi daa wna Chioza' nad', kon cheenkzile witle nad'. Dii Abrahama' agaga bene' ka chonle. ");
INSERT INTO zadNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Le' chonle kon ka chon x̱alena'. Na'ch che'gake'ne': ―Aga naknto' ka to beṉ' bi wyoo x̱ayin. Toz Chioza' nake' X̱anto'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Na'ch che' Jesúza' ḻegake': ―Sheḻ' lekzile Chioza' nake' X̱ale, wakile nad' sheḻ'ka', ḻa' kwite'nan' wzaa. Aga tobia'lozaan bid', san Chiozan' bseḻee nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Na' aga chajniile diika' nia' le' daa bi cheenile wzenagle dill'ka' cho'a. ");
INSERT INTO zadNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Dii x̱iwaan nak x̱ale na' chibaile chonle daa chaklalliin. Ḻa' kana'te dii x̱iwaa nakan to wen xya, na' ni shlin biṉ' gonan daa nak shḻi, ni bi choe'n dill' ḻi. Kat' chziye'n chonan kon ka nan ḻoo lall'do'inna', ḻa' nakan ḻiizelozi dii wxiye' na' nakten x̱an yeḻ' wxiye'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na' nad', daa cho'a dill' ḻina' aga chajḻe'le c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni tole bi gak wli'le shi de saaxya c̱ha'. Na' shi cho'a dill' ḻi, ¿berac̱he bi chajḻe'le c̱ha'? ");
INSERT INTO zadNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Beena' nak xiiṉ Chioza' chzenague' xtilleena'. Na' le', bi chzenaglen daa bi nakle xiiṉe'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Na'ch beṉ' wṉabia' c̱he beṉ' Israelka' che'gake'ne': ―¡Aga naznto' nanto' nako' beṉ' Samaria na' yootio' to dii x̱iw'! ");
INSERT INTO zadNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Na' che' Jesúza' ḻegake': ―Aga no dii x̱iw' yo'a, san X̱a'nan' chgwaa balaaṉ, per le', chṉit chdele nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Aga chyilj' koo beṉ' nad' balaaṉ. San zoa beena' cheeni sho'a balaaṉ, na' ḻen' chc̱hogloe' c̱he beṉ' kon ka nakan. ");
INSERT INTO zadNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Dii ḻi nia' le', beena' chon ka nia', ibane' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Na'ch beṉ' wṉabia' c̱he beṉ' Israelka' che'gake'ne': ―Ṉaach ba wṉezinto' dii x̱iw'kzan yoo. Dii x̱ozxto'cho Abrahama' wite' na' ḻekzka' yog' beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yi. Na' li' ṉaa, nazo': “Beena' chzenag c̱ha' ibane' zejḻi kaṉi.” ");
INSERT INTO zadNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Achakilo' zak'cho' aga ka dii x̱ozxto'cho Abrahama'? Ḻe' wite' na' ka'kzə dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yi. ¿Noraka chakzi kwino'? ");
INSERT INTO zadNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Na'ch che' Jesúza' ḻegake': ―Sheḻ' nadaan chgwaa kwin' balaaṉ aga bi zakiin, sheḻ'ka'. Per X̱a'na', beena' nale nake' Chios c̱hele, ḻen' chgwee nad' balaaṉ. ");
INSERT INTO zadNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ḻa'kzi bi nombia'lene', nad' nombi'ane'. Sheḻ'ka' nia' bi nombi'ane', na' nak' ka le' beṉ' wxiye'. Per nombi'ane' na' chon' ka ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Dii x̱ozxto'cho Abrahama' bibaile' daa wṉezile' ile'ile' llaki zoa' yell-lioni. Na' ba ble'ile'n na' bibaile'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Na'ch beṉ'ka' chṉabia' beṉ' Israelka' che'gake'ne': ―Ni shiyon yiz biṉ' gakilo' na' nazo' zle'ilo' dii Abrahama'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Na'ch che' Jesúza' ḻegake': ―Dii ḻi nia' le', kana' zi' galjte dii Abrahama', bakz zoa' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Na'ch lii wdoyotegake' yaja' nan wtakwgake'ne'n, per lii bkwash'tie' na' bizee gana' zoa yoodo'na'. Na' ni bi gokbe'gakile' bidie' ladje'ka' ziyaje'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ka zej Jesúza' na' ble'ile' to beṉ' byo beṉ' golje' nc̱hoḻe'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Na' beṉ'ka' nakgake'ne' txen che'gake'ne': ―Maestro, ¿berac̱he golj beeni nc̱hoḻe', lla? ¿Anc̱hoḻe' ni c̱he saaxya c̱he'na', anti ni c̱he saaxya c̱he x̱axṉeekan', lla? ");
INSERT INTO zadNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Na' che' Jesúza' ḻegake': ―Aga ni c̱he saaxya c̱he'nan' ni aga ni c̱he saaxya c̱he x̱axṉeekan', san kwenc̱he wli'lawi yeḻ' wak c̱he Chioza' lo yeḻ' mban c̱he'nan' nake' ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Shlak ṉaa ni de latj, chiyaḻ' goncho xshin beena' bseḻ' nad'. Ḻa' wllin lla kat' kochno bi gak gon. ");
INSERT INTO zadNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Shlak ni zoa' yell-lioni nak' beeni' c̱he beṉ' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Na' ka biyoll wna Jesúza' ka', na'ch blle' x̱eneena' lo yona' na' bene' lat' beṉj kon x̱eneena', na'ch wdebe'n jalao beṉ' lc̱hoḻa'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Na' chi'ene': ―Wyaj jadib jalawo'na' cho'a tanga' daa le Siloé ―na' Siloé zejin Beṉ' Nseḻee. Na'ch wyaj beṉ' lc̱hoḻa' jadib jalawe'na', na' ka bizee na', ba chle'ile'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Na'ch beṉ' wlill c̱he'ka' na' beṉ'ka' ble'gakile'ne' kana' nc̱hoḻe' che'gake': ―¿Aaga beenin chbi'e chṉabe' mecha'? ");
INSERT INTO zadNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Na' baḻe' che': ―Awe, ḻen'. Na' zi baḻe' che': ―Aga ḻen', per ka'tekzə nake'. Na' beena' chi'e: ―Nad'kzan'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Na'ch wṉabgakile'ne': ―¿Nakra gok ba chle'ilo'? ");
INSERT INTO zadNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Na' chi'e ḻegake': ―To beṉ' le Jesús bene' beṉja' na' wdebe'n jalaw'ki na'ch wne' nad': “Wyaj gana' llia tanga' daa le Siloé na' jadib jalawo'na'.” Na'ch wyaa na' ka biyiba'n, na' gok ble'id'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Na'ch che'gake'ne': ―¿Garaṉ beena' no' ka'? Na' chi'e ḻegake': ―Bi ṉezid'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Na'ch jwa'gake' beena' gok beṉ' lc̱hoḻ lao fariseoka'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na' llana' wdeb Jesúza' beṉja' jalao beena' kwenc̱he ble'ile' nakan lla chombaaṉgake'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Na'ch fariseoka' ḻekzka' wṉabgakile'ne' nak gok chle'ile'. Na' chi'e ḻegake': ―Beena' biyone' nad' wdebe' beṉja' jalaw'ki, na' ka biyiba'n gok ble'id'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Na'ch baḻ fariseoka' che'gake': ―Aga Chiozan' bseḻee beena', ḻa' chone' daa bi chiyaḻ' goncho llani chombaaṉcho. Na' zi baḻe' che'gake': ―¿Nakra gon to beṉ' saaxya gone' yeḻ' wak ka diiki chon beeni? Na'ch gokgake' c̱hoplə. ");
INSERT INTO zadNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Na'ch dii yoblə gollgake' beena' gok beṉ' lc̱hoḻ: ―¿Shera li'? ¿Bi iṉo' c̱he beena' ben ka chle'ilo'? Na' chi'e ḻegake': ―Nad' nia' nake' to beṉ' chyix̱jee daa che' Chioza'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na' beṉ'ka' chṉabia' beṉ' Israelka' bi wyajḻe'gake' shi dii ḻi gok beena' beṉ' lc̱hoḻ na' ṉaa ba chle'ile'. Na'ch goxgake' x̱axṉeena', ");
INSERT INTO zadNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","na' wṉabgakile' ḻegake': ―¿Abeenin xiiṉlena', beena' nale nc̱hoḻe' ka golje'? Na' ¿nakra gok ba chle'ile' ṉaa, shka'? ");
INSERT INTO zadNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Na' x̱axṉeena' billiigake' xtilleeka': ―Ṉezinto' beenin xiiṉnto'na' na' golje' nc̱hoḻe'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Per aga ṉezinto' nak gok chle'ile' ṉaa, ni bi ṉezinto' non biyon ḻe'. Ḻi iṉabile', ḻa' aga nake' bi'do' iṉacho bi gak iṉe' non biyon ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Goll x̱axṉeena' ka' daa chllebgake' beṉ'ka' chṉabia' beṉ' Israelka', ḻa' ba bgaaṉgake' dill' nottezə beṉ' iṉe' Jesúza' nake' Crístona' bi wlebgake'ne' gana' chdop chllaggake' choe'ḻwillgake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Daan golltezə x̱axṉeena': “Ḻi iṉabile', ḻa' aga nake' bi'do' iṉacho bi gak iṉe' non biyon ḻe'.” ");
INSERT INTO zadNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Na'ch dii yoblə goxgake' beena' gok beṉ' lc̱hoḻ, che'gake'ne': ―Bzoashki Chioza' de tasc̱hiw shi leilo' choo dill' ḻi, ḻa' ṉezinto' beena' biyon li' nake' beṉ' saaxya. ");
INSERT INTO zadNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Na'ch golle' ḻegake': ―Bi ṉezid' shi nak beena' beṉ' saaxya. Ḻete dii ṉezid', golj' nc̱hoḻ' na' ṉaa ba chle'id'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Na'ch che'gake'ne': ―¿Beran benile' li'? ¿Nak bene' kwenc̱he chle'ilo'? ");
INSERT INTO zadNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Na' chi'e ḻegake': ―Ba wniakz' le', na' bi chzi'le cho'a xtillaana'. ¿Bic̱he cheenzile iṉia'n dii yoblə? ¿Anti ḻekzka' lenle ba cheenile gonlene' txen? ");
INSERT INTO zadNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Na'ch wṉegake'ne' zibia', che'gake'ne': ―Lin' nako' beena' txen, san neto' Moisézan' naknto' txen. ");
INSERT INTO zadNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ṉezinto' Chioza' wṉie' Moiséza', san beena', ni bi ṉezinto' ga zee. ");
INSERT INTO zadNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Na'ch beena' gok beṉ' lc̱hoḻ chi'e ḻegake': ―¡Nakkzan dii yibanicho daa bi ṉezile ga za' beena' na' ba bene' ka chle'id'! ");
INSERT INTO zadNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ṉezkzicho aga chzenag Chioza' c̱he beṉ' saaxyaka', san chzenague' c̱he beṉ'ka' choe'la'ogake'ne' na' chongake' daa chazlallee. ");
INSERT INTO zadNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dezd ka wxe wzil yell-lioni biṉ' yenicho shi zoa beṉ' chak chone' ka chle'i to beṉ' golje' nc̱hoḻe'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sheḻ' beeni bi nake' to beṉ' bseḻ' Chioza', ni to yeḻ' wak bi gak gone', sheḻ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Na'ch che'gake'ne': ―Dezd ka goljo' nako' beṉ' saaxya. ¿Ana' chakilo' wli' wsedilo' neto'? Na'ch bibejgake'ne' ladje'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Na' wṉezi Jesúza' bibej fariseoka' beena' gok beṉ' lc̱hoḻ ladje'ka', na' ka billague'ne' na'ch chi'ene': ―¿Achonḻilalloo Beena' Bseḻ' Chioza' Yell-lioni? ");
INSERT INTO zadNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Na' beena' chi'ene': ―Beṉ'do', wnashki nad' nora beena' kwenc̱he gonḻilallaane'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Na' che' Jesúza'ne': ―Ba ble'kzilo'ne', na' ḻekzen' chshaljleno' ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Na'ch lii bc̱hek'te xibe'na' lao Jesúza', na' chi'ene': ―Chonḻilallaa li', X̱an' ―na'ch be'laweene'. ");
INSERT INTO zadNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Na'ch che' Jesúza': ―Ba bid' yell-lioni kwenc̱he wc̱hogloa' c̱he beṉ' yell-lioni. Zaa kwenc̱he beṉ'ka' nak ka beṉ' lc̱hoḻ ile'gakile', na' beṉ'ka' chakgakile' chle'gakile' yiyakgake' ka beṉ' lc̱hoḻ. ");
INSERT INTO zadNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Na'ch baḻ fariseoka' lle' na', ka bengakile' chi'e ka', che'gake'ne': ―¿Achakilo' lennton' naknto' beṉ' lc̱hoḻ? ");
INSERT INTO zadNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Na'ch che' Jesúza' ḻegake': ―Sheḻ' nakle beṉ' lc̱hoḻ, aga bi xtoḻ'le de, sheḻ'ka'. Per daa nale chle'ile, daan de xtoḻ'le. ");
INSERT INTO zadNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Dii ḻi nia' le', beena' bi choo cho'a leej c̱he xil'ka' san chiyiljlallee cho'e gan yoblə, beenan' beṉ' wbanna'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","San beena' choo cho'a leeja', ḻen' ngoo lall' nee chape' ḻegakb. ");
INSERT INTO zadNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Na' beena' chap cho'a leej c̱hebka' chsalje'n kwenc̱he cho'e, na' xil'ka' lii chiyombia'tegakb shi'ena'. Na' cho'e le to tob na' chbeje' ḻegakb ḻoo leej c̱hebka'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Na' chde chbeje' yog' xil' c̱he'na' na'ch chbialoe' laobka'. Na' xil'ka' xochi chjanogakb ḻe' daa nombia'gakb shi'ena'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Aga willjanogakb beṉ' yoblə, san wxoṉjdogakib ḻe' daa bi nombia'gakb shi'ena'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Bzoa Jesúza' jempli kwenc̱he bzajniile' beṉ'ka'. Per ḻegake' aga wyajni'gakile' bin zeji daa golle' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Na'ch chize' Jesúza' ḻegake': ―Dii ḻi nia' le': Nad' nak' ka cho'a leej c̱he xil'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yog' beṉ'ka' bid kana' biṉ' yid', nakgake' ka beṉ' wban. Na' beṉ'ka' nia' nakgake' xil' c̱ha' bi bzenaggake' c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nad' nak' ka cho'a leej c̱he xil'ka', na' beena' gonḻilallee nad' bi kwiayee, san gake' ka xilaa, bana' mbalaz choob na' chchejb cho'a leej c̱heba' na' chllelib dii cheej chaob. ");
INSERT INTO zadNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ka nak wbanna', za'ze' kwenc̱he kwane' na' wite' na' wlliayee ḻegake'. San nad', zaa kwenc̱he wi'a to yeḻ' mban shao' c̱hegake', na' soagake' mbalaz. ");
INSERT INTO zadNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nad' nak' ka to beṉ' chapshi'e xil' c̱he'na', beena' ax̱t chzani yeḻ' mban c̱he'na' ni c̱he xil'do'ka' nape'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","San beena' chap xil'ka' ni c̱he mba laxje'na', ka chle'ile' ba za' to ba zṉia gaob xil'ka', lii chchooṉlall'tie'gakb na' chxoṉje' daa bi nakgakb ba c̱he'. Na'ch chllin ba zṉiana' chox̱'b xil'ka' na' chsheshlesb ḻegakb. ");
INSERT INTO zadNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Beena' chzi' laxje'na' chxoṉjtezile' xil'ka', ḻa' daa ikaaz laxje'nan' chibaile', na' bi chakile' ḻegakb. ");
INSERT INTO zadNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Nad' nak' ka to beṉ' chapshi' xil'do'. Na' beṉ'ka' chonḻilall'gake' nad' nakgake' ka xil'do' c̱ha'. Nad' nombi'a ḻegake' na' ḻegake' ḻekzka' nombia'gake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ka chak c̱he X̱a'na' nombi'e nad', na' nad' nombi'ane', ka'kzan nad' nombi'a ḻegake', na' chzanid' yeḻ' mban c̱ha'ni ni c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na' ḻekzka' zoach beṉ' yoblə, beṉ' zi' gonḻilall' nad', na' ḻekzka' nakgake' ka xil' c̱ha', per biṉ' gakgake' txen xil' c̱ha'ka'. Na' chiyaḻ' gaxgakee kwenc̱he wzenaggake' c̱ha', na' yog'gake' gakgake' tozə, na' toz nad' gak lall' na'gake'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Chaki X̱a'na' nad' daa chzanid' yeḻ' mban c̱ha'ni witgake' nad', na'tech yiban' sto shii. ");
INSERT INTO zadNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni to kono yikaa yeḻ' mban c̱ha'ni, san kwinkza'n wi'an. Nap' yeḻ' wṉabia' kwenc̱he wi'a yeḻ' mban c̱ha'ni witgake' nad', na' ḻekzka' nap' yeḻ' wṉabia' kwenc̱he yiban'. Ḻa' kan' nllia X̱a'na' bia' gon'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Na'ch dii yoblə beṉ' Israelka' lle' na' gokgake' c̱hoplə ka bengakile' daa wne'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Zane' che'gake': ―¿Bic̱he chzenagzle c̱he beena'? Dii x̱iwaan yo'e, na' chaktonte'n. ");
INSERT INTO zadNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Na' zi baḻe' che'gake': ―Aga choe' beeni dill' ka beṉ' yoo dii x̱iw', ḻa' aga bi yeḻ' wak nap dii x̱iwaa yiyonan to beṉ' lc̱hoḻ. ");
INSERT INTO zadNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na' do kana', goḻ' lṉina' Jerusalénna' daa chisa'lall'gake' llana' bengake' lall' na' Chioza' yoodo'na', na' nak beo' zag. ");
INSERT INTO zadNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Na' chda Jesúza' ḻoo koridor c̱he dii Salomónna' daa ze kwit yoodo'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Na' beṉ'ka' chṉabia' beṉ' Israelka' wyec̱hjyobgake'ne', che'gake'ne': ―¿Ax̱t batrakzə yikwaso' yeḻ' chakc̱hoplall' c̱hento'ni? Shi li'kzan Crístona', beena' chbeznto' wseḻ' Chioza', lla wnatega neto' kwenc̱he iṉezinto'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Na' che' Jesúza' ḻegake': ―Ba wniakz' le' kan', na' bi chajḻe'le. Yeḻ' wakka' chon', chonlena'n yeḻ' wṉabia' c̱he X̱a'na', na' chli'n nan ḻen' bseḻee nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Na' le', bi chajḻe'le daa bi nakle txen beṉ'ka' nia' nakgake' xil' c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nombi'a beṉ'ka' nia' nakgake' xil' c̱ha', na' ḻegake' chzenaggake' xtillaana' na' nogake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na' cho'a ḻegake' yeḻ' mban zejḻi kaṉi, na' bi kwiayi'gake'. Na' ni to kono gak yibej ḻegake' lo ṉi'a na'ni. ");
INSERT INTO zadNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","X̱a'na' ba bene' ḻegake' lall' na' gapshiigakee, na' ḻen' chṉabia'che' lao nottez. Na' ni to kono gak yikwas ḻegake' lo ṉi'a neena'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ka X̱a'na'kz, nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Na'ch beṉ' Israelka' bizgoyogake' yaja' kwenc̱he nan wtakwgake'n Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Na' chi'e ḻegake': ―Dii zan dii wen ba ble'ile chonlen' yeḻ' wak c̱he X̱a'na'. Na' ¿nonnan' bi choolall'le daa cheenile' wtakwle nad' yaja'? ");
INSERT INTO zadNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Na' beṉ'ka' chṉabia' beṉ' Israelka' che'gake'ne': ―Aga ni c̱he dii wenka' ba benon' cheeninto' wtakwnto' li' yaja', san daa chonz kwino' ka Chiozan', ḻa' beṉ'zə li'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Na'ch che' Jesúza' ḻegake': ―Ley c̱helena' nan, Chioza' ne': “Nad' wnia' le' nakle chios.” ");
INSERT INTO zadNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Cho'a Xtill' Chioza' toshiizi nakan ka wne', na' shi cho'en dill' bsi'e “chios” beṉ'ka' wdix̱jee xtilleena', ");
INSERT INTO zadNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿bic̱he nazle nad' chṉia' c̱he X̱acho Chioza' daa nia' nak' Xiiṉe', len ḻen' wleje' nad' na' bseḻee nad' yell-lioni? ");
INSERT INTO zadNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Shi bi chon' ka chon X̱a'na', aga wyajḻe'le c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Na' shi chle'ile chon' ka diika' chon X̱a'na', ḻi shajḻe' c̱he diika' chon', ḻa'kzi bi cheenile shajḻe'le c̱ha', kwenc̱he iṉezyeṉ'ile X̱a'na' zoalene' nad' na' nad' zoalenee. ");
INSERT INTO zadNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Na'ch dii yoblə goklall'gake' gox̱'gake'ne' na' bene' gan bile' lawe'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Na'ch bizyaj Jesúza' dii yoblə shḻaa yao Jordánna' jazoe' latja' gana' bchoa Juanna' beṉ'ka' nisa' kana'. ");
INSERT INTO zadNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Na' beṉ' zan wyajgake' gana' zoe' na' che'gake': ―Ḻa'kzi bibi yeḻ' wak bli' Juanna', yog' diika' wne' c̱he beeni nakan dii ḻi. ");
INSERT INTO zadNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Na' beṉ' zan wyajle'gake' c̱he Jesúza' na'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Yell Betániana' wzoa to beṉ' bi shao' wlie' Lázaro, na' ḻekzka' na' wzoa beṉ' zane'ka' Maríana' len Mártana'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maríana', beṉ' zan Lázarona', ḻen' bwazje' set zix̱a' ṉi'a X̱ancho Jesúza' na' bisbillile'n yish' yic̱hje'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Na' c̱hop bilte beṉ' zan Lázarona' bseḻ'gake' rson lao Jesúza' che'gake'ne': ―X̱an', bi shao' beṉ' zannto'ni, beeni nllaguilo'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Na' ka beni Jesúza' rsonna', chi'e: ―Bi guetile' yillwe'na', san chak c̱he ka' kwenc̱he sho' Chioza' balaaṉ, na' ḻekzka' nad', nak' Xiiṉe', sho'a balaaṉ. ");
INSERT INTO zadNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ḻa'kzi Jesúza' chakchgaile' Mártana', na' beṉ' bile'na' na' Lázarona', ");
INSERT INTO zadNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ka benile' rson bi shao' Lázarona', wllachile' zi c̱hop lla gana' zoe'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Na' ka wde, chi'e beṉ'ka' nakgake'ne' txen: ―Ḻi sho' Judeana' sto shii. ");
INSERT INTO zadNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Na'ch beṉ'ka' nakgake'ne' txen che'gake'ne': ―Maestro, kani batchgana' goklallii beṉ' Israelka' lle' na' witgake' li' kon yaja'. ¿Ana' cheenilo' yizajo' na'? ");
INSERT INTO zadNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Na' che' Jesúza' ḻegake': ―¿Aaga shlliṉ goran' de beeni'na' shlla? Na' beena' chda tellalə aga willjac̱hewee daa de beeni'na' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","San shi chde' waḻ-lə, willjac̱hewee daa bi nḻa'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Na'tech golle' ḻegake': ―Ba ches Lázarona', beena' nllaguicho, na' sha' lljasbanee. ");
INSERT INTO zadNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Na'ch che' beṉ'ka' nakgake'ne' txen: ―X̱an', shi ba chese', wiyakshao'lall'kzile'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesúza' golle' ka' daa ṉezile' ba wit Lázarona', na' ḻegake' chakgakile' daa cheszen' golle' ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Na'ch be'len Jesúza' ḻegake' dill' ka to shajni'gakile', chi'e: ―Ba wit Lázarona'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na' chibaid' bi wzoa', ḻa' chyalljch gon' ka shajḻe'chle c̱ha'. Ḻi sho' shajcho gana' die'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Na'ch Tomáza', beena' che'gake' Dídimo, chi'e beṉ'ka' sto: ―Ḻi sho'lene' kwenc̱he lencho guetlenchone' shi witgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Na' ka bllingake' yella', na' che'gake'ne' ba gok tap lla bgash' Lázarona'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na' Betániana' llian gaozə Jerusalénna', ka do shoṉ kilómetro nḻaagakan. ");
INSERT INTO zadNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Na' beṉ' zan beṉ' Israelka' lle' Jerusalénna' wyajgake' jenxenlall'gake' Mártana' len Maríana' daa wit beṉ' zane'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Na' ka wṉezi Mártana' ba zoa illin Jesúza', na'ch jatiḻe'ne', per Maríana' bigaaṉe' lille'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Na' ka blline' kwite'na', chi'ene': ―X̱an', sheḻ' zo' ni kana' wḻen yillwe' c̱he beṉ' zan'na' bi wite', sheḻ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Na' ṉaa ḻa'kzi ba wite', ṉezid' goṉ Chioza' bittezə dii iṉabilo'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Na' che' Jesúza'ne': ―Wiban beṉ' zano'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Na'ch che' Mártana': ―Awe, ṉezid' wibane' kat' yiban beṉ' wetka' llana' te c̱he yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Na' che' Jesúza'ne': ―Nad' chon' ka chiban beṉ' wetka' na' nap' yeḻ' mban dii bi te c̱heyin. Beena' chonḻilallee nad', ḻa'kzi ba wite', wibanchkze'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na' yog' beṉ'ka' mban na' chonḻilall'gake' nad' bi guetgake' toshiizi. ¿Achajḻi'o dga nia' li'? ");
INSERT INTO zadNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Na' che' Mártana'ne': ―Awe, X̱an', chajḻi'a lin' nako' Crístona', na' lin' Xiiṉ Chioza', beena' llia bia' yid yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Na' biyoll wna Mártana' ka', na'ch ziyaje' zjaṉie' beṉ' bile' Maríana', na' chi'ene' xochizi: ―Ba bid Maestrona' chṉie' li'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Na' kon ka golle' Maríana' ka', lii wzolla'tie' jawie' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Bilaṉ' sho' Jesúza' yella', ni zetie' gana' jatiḻ Mártana'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na' beṉ' Israelka', beṉ'ka' chonxenlall'gake' Maríana' lille'na', ka ble'gakile' wzollee na' zejdoe', na'ch zjanogake'ne' chakgakile' lljc̱helle' cho'a banan'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Na' ka bllin Maríana' kwit Jesúza', lii bc̱hek'te xibe'na' lawe'na' chi'ene': ―X̱an', sheḻ' zoasho' ni, bi wit beṉ' zan'na', sheḻ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na' ka ble'i Jesúza' chbell Maríana', na' ka'kzə beṉ'ka' zejlengake'ne', na' to dii wal inlleb gokile'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Na' chi'e ḻegake': ―¿Gara jakwash'lene'? Na'ch che'gake'ne': ―Sho' lljawiacho gana' die', X̱an'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Na' wchell Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Na'ch che' ljwell beṉ' Israelka' lle' na': ―Ḻi wwia ka gokchgaile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Na'ch baḻe' che'gake': ―Beeni bene' ka ble'i beṉ' lc̱hoḻa', ¿Aaga zak bisle' Lázarona', na' bi wite' sheḻ'ka', lla? ");
INSERT INTO zadNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na'ch Jesúza' wizakile' dii wal ka bllingake' cho'a bana'. Na' bana' nakan to blej, na' chi' to yaj nkwasha'n cho'ayinna'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Na'ch che' Jesúza': ―Ḻi yikwas yaja' ka'lə. Na' Mártana', beṉ' zan beṉ' weta', chi'ene': ―X̱an', ba chḻa' beena' zban, ḻa' ba gok tap lla wite'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Na' che' Jesúza'ne': ―¿Aaga ba wnia' li' shi shajḻi'o, na' ile'ilo' yeḻ' wak choo yeḻ' wak xen c̱he Chioza'? ");
INSERT INTO zadNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Na'ch bikwasgake' yaja' cho'a bana' gana' die'. Na' bḻis jalao Jesúza' yabana', na' chi'e: ―X̱a, chox̱keno' ba bzenago' c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ṉezid' toshiizi chzenago' c̱ha', per chṉia' li' kwenc̱he shajḻe' beṉ'ki lle' ni nan lin' bseḻoo nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Na' ka biyoll wne' ka', na'ch wṉie' zillj, chi'e: ―¡Lázaro, bichej na'! ");
INSERT INTO zadNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Na' lii bichejte Lázarona' ndob ṉi'a neena' lech'ka', na' cho'alawe'na' ndoban to lech'. Na'ch che' Jesúza' ḻegake': ―Ḻi yizeshe' lechaa na' ḻi yisane' yiyaje'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Na' zan beṉ' Israelka', beṉ'ka' jen Maríana' txen daa wit beṉ' zane'na', ble'gakile' ka ben Jesúza' na' benḻilall'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Per baḻe' wyaj lao fariseoka' na' jellgake' ḻegake' ka ben Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Na'ch bx̱ozka' chṉabia' na' fariseoka' bitopgake' yog' beṉ'ka' chṉabia' beṉ' Israelka', na' che'gake': ―¿Nakraz ka gonchon, lla? Ḻa' zan yeḻ' wak chli' beeni. ");
INSERT INTO zadNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Na' shi iṉacho jwayi beena', yog'z beṉ' gonḻilall'gake'ne' na'ch yid beṉ' Rómaka' na' wlliayi'gake' yoodo' c̱hechoni len yell c̱hechoni. ");
INSERT INTO zadNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Na' len to beṉ' le' Caifás, nake' bx̱oz choo bx̱oz xen ka lo yiza'. Na' chi'e ḻegake': ―Bi ṉezzilen, ");
INSERT INTO zadNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ni bi chakbe'ile wenlan toz beṉ' guet ni c̱he beṉ' wlall c̱hechoka', aga ka daa kwiayi' doxen lallchoni. ");
INSERT INTO zadNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na' aga kon ka wnaz Caifáza' kan', san daa nake' bx̱oz choo bx̱oz xen lo yizan', ben Chioza' ka bi'e dill' guet Jesúza' ni c̱he beṉ' Israelka'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na' aga ni c̱he toz beṉ' Israelkan' guet Jesúza', san ḻekzka' ni c̱he yog' beṉ'ka' ba wleje' gakgake' xiiṉe' doxen yell-lionin, kwenc̱he gakgake' toz. ");
INSERT INTO zadNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Na' daa goll Caifáza' ka', lo llana' wzolo bengake' toz dill' kwenc̱he witgake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Na' daa wzolo chongake' ka', aga wdatekch Jesúza' ladj beṉ' Israelka', san wzee wyaje' to yell dii le Efraín, daa llia gaozə latja' gana' bibi chashj chḻeb, na' na'z wzoe' len beṉ'ka' nakgake'ne' txen. ");
INSERT INTO zadNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na' ba zoa gao gaḻ' lṉi Paskw c̱he beṉ' Israelka', na' beṉ' zan beṉ' yell yoblə wyajgake' Jerusalénna' ka zi' gaḻ' lṉina' kwenc̱he yixi yiyechgake' ka nllia leya' bia'. ");
INSERT INTO zadNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na' chdagake' chiyiljgake' Jesúza', na' shlak lle'gake' lesh' chyoodo'na', chṉabi ljwelle': ―¿Beraka chakile? ¿Awide' lṉina', lla? ");
INSERT INTO zadNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Na' bx̱ozka' chṉabia' len fariseoka' bengake' mandad shi no ṉezi ga chda Jesúza' do na' lljellgake' ḻegake' ka' kwenc̱he gox̱'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Zi' x̱op lla gaḻ' lṉi Paskwa' wyaj Jesúza' yell Betániana', gana' zoa Lázarona', beena' bisbane' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na' beṉ'ka' lle' Betániana' bsini'agake' to xshe' c̱he Jesúza', na' Mártana' bdie' yeḻ' wawa'. Na' Lázarona' wche'lene' Jesúza' cho'a mesa' na' nochlə beṉ'ka' wdaolengake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Na'ch bex̱' Maríana' ka do gashj litr set zix̱a' daa le nardo, daa ḻe zak'chga, na' bwazje'n ṉi'a Jesúza', na' tech bisbillile'n yish' yic̱hje'na'. Na' doxen ḻoo yoona' wche' shii set zix̱a'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Na' len Jud Scariota', beena' nak Jesúza' txen, beena' gone'ne' lo na' beṉ' malka'. Na' golle': ");
INSERT INTO zadNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Berac̱he bi betee set zix̱a' na' wi'e mecha' gaklenan beṉ' yesh'ka', lla? Len ḻa' ka c̱he twiz laxj beṉaan zakaan. ");
INSERT INTO zadNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Juda' wne' ka' aga iṉacho daa chiyeshile' beṉ' yesh'kan', san daa nake' to beṉ' wbanan. Ḻa' ḻen' gok lall' nee xmeche'ka' na' chbane' lat' wejan. ");
INSERT INTO zadNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Na'ch che' Jesúza'ne': ―Bi wllono' gone' ka'. Ba nzoashao'kze' daa kwenc̱he wgone'n llin kat'ka' wkwash'gake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ka nak beṉ' yesh'ka', toshiizin soakz beṉ'ka' ladjleni, san nad', aga toshiizin soalen' le'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na' zan beṉ' Israelka' wṉezgakile' zoa Jesúza' yell Betániana' na' wyajgake' na'. Per aga wyajgake' yella' ni c̱he toz Jesúzan', san ḻekzka' kwenc̱he ile'gakile' Lázarona', beena' bisban Jesúza' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Na'ch bx̱ozka' chṉabia' bengake' toz dill' witgake' len Lázarona'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ḻa' daa biban Lázarona' ladj beṉ' wetka', zan beṉ' Israelka' benḻilall'gake' Jesúza' na' bich bzenaggake' c̱he bx̱ozka'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na' betiyo beṉ' be beṉ' zil, beṉ'ka' lle' yell Jerusalénna' daa chaḻ' lṉi Paskwa', wṉezgakile' ba ngoo Jesúza' nez yilline' yella'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Na'ch wyajgake' jḻezgake'ne' nox̱'gake' zinka', na' choe'la'ogake'ne', nagake': ―¡Ḻi we'la'o Chioza'! ¡Gonḻeeyshga X̱ancho Chioza' beeni ba bseḻee iṉabi'e cho' beṉ' Israel! ");
INSERT INTO zadNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Na' blleli Jesúza' to burr chbando' na' wllie'b. Na' gok kon ka na Cho'a Xtill' Chioza', gana' na: ");
INSERT INTO zadNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Le' beṉ' yell Jerusalén, bi illeble. Ḻi wwia, ni ba za' beena' iṉabia' le' na' llie' to burr chbando'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Na' beṉ'ka' nakgake'ne' txen aga wyajni'gakile' diiki ka lo gora'. Ka bibanch Jesúza' ladj beṉ' wetka', kana'ch gokbe'gakile' nan Cho'a Xtill' Chioza' daa bzej beṉ'ka' kani'yi choe'n dill' c̱he', na' c̱he diika' bengakile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na' beṉ'ka' lle'len Jesúza' kana' bisbane' Lázarona' ladj beṉ' wetka', beṉ'ka' bengakile' biṉie'ne' kwenc̱he bicheje' ḻoo bana', ḻegaken' be'gake' dill' daa bene'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Daan beṉ' zan jatiḻgake' Jesúza' daa bengakile' ka nak yeḻ' waka' bene'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Na'ch fariseoka' che' ljwellgake': ―Ḻi wwia ka ba chak, bibi de goncho. Ḻi wwia, yog'ḻoḻzə beṉ' ba nogake' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ladj beṉ'ka' wyaj lṉina' Jerusalénna' je'la'ogake' Chioza' na' len baḻ beṉ' griego. ");
INSERT INTO zadNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Na' beṉ'ki jabig'gake' gana' ze Felípena', beena' nak beṉ' yell Betsaida daa llia yell-lio daa mbani Galileana', na' che'gake'ne': ―Beṉ'do', cheeninto' we'lennto' Jesúza' dill'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Na' Felípena' jelle' Andréza' ka', na' c̱hoptie' wyajgake' jellgake' Jesúza' ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Na'ch che' Jesúza' ḻegake': ―Ba bllin lla, nad', Beṉ' Bseḻ' Chioza' Yell-lioni, sho'a balaaṉ xenna'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Dii ḻi nia' le', shi to biṉ c̱he trígona' bi igasha'n ḻoo yona', ka'chokzə kwe'n. Per shi igasha'n ḻoo yona', na' yila'n na' yiyakan dii zan wal. ");
INSERT INTO zadNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Beena' ze wṉeyi c̱he yeḻ' mban c̱he'na' yell-lioni, ḻen' kwiayee. San beena' chzani yeḻ' mban c̱he'na' bittezə dii gak c̱he', beenan' gat' yeḻ' mban c̱he' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nottezə beṉ' cheenile' gone' xshin'na' chiyaḻ' gone' nad' txen. Na' gana' soa', na'kzə soe'. Na' beena' gon xshin'na', X̱a'na' kwee ḻe' balaaṉ. ");
INSERT INTO zadNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Ṉaatek chakyeshid' dii wal inlleb. ¿Awṉabid' X̱a'na' yisle' nad' lawi dga wtiḻ', lla? Bi gak gon' ka', ḻa' ni c̱heyi dgayeṉ'kzan bid'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Na'ch golle': ―X̱a, benshki ka shoo balaaṉ. Na'ch wṉe Chioza' yabana', chi'e: ―Ba ben' kwenc̱he wyo'a balaaṉ, na' ṉaa gon' ka sho'a balaaṉ sto shii. ");
INSERT INTO zadNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na' beṉ'ka' lle' na' bengakile' shii Chioza', na' baḻe' wnagake' wziwa'zan wṉe. Na' zi baḻe' wna to anjlan' ba wṉie' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Na'ch Jesúza' chi'e ḻegake': ―Aga ni c̱ha' nadaan wṉe Chioza', san ni c̱he len'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Na' ba bllin lla gone' yeḻ' josc̱his c̱he yog' beṉ' lle' yell-lioni, na' ṉaa kweje' dii x̱iwaa daa chṉabia' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na' kat'ka' wḻisgake' yaga' cha'lə gana' nda'gake' nad', kanan' gat' latj gonḻilall' nottezə beṉ' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Na' daa wne' ka', bzajniile' ḻegake' nakan guete'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Na' beṉ'ka' lle' na' che'gake'ne': ―Ba beninto' chlabgake' Cho'a Xtill' Chioza' gana' nan Crístona', beena' wseḻ' Chioza' iṉabi'e, soe' zejḻi kaṉi. Na' ¿bic̱he nazo' Beena' Bseḻ' Chioza' Yell-lioni wḻisgake'ne' cha'lə wwia beṉ' ḻe' ḻee yaga' gana' dee? ¿Nora Beena' Bseḻ' Chioza' Yell-lioni no' ka'? ");
INSERT INTO zadNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Na'ch che' Jesúza' ḻegake': ―Nad' nak' beeni' c̱he beṉ' yell-lioni, per zi shlollchga soalen' le'. Ḻi sho' lo nez ḻina' shlak ni de beeni'na' kwenc̱he bi gak c̱hele ka chak c̱he to beṉ' chaḻile' kat' ngwee' nez. Ḻa' beena' chda' gana' shc̱hoḻ bi ṉezile' galan zeje'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ḻi gonḻilall' nad' ṉaa shlak ni zoalen' le' kwenc̱he sho' beeni' c̱ha'na' ḻoo yic̱hjlall'do'lena'. Biyoll wna Jesúza' ka' na'ch bizee jakwashi'le' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ḻa'kzi beṉ' Israelka' ble'gakile' yeḻ' wak zan daa ben Jesúza', zangake' bi benḻilall'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Na' daa bengake' ka', gok ka wna dii Isaíaza', beena' wdix̱jee daa goll Chioza'ne' kani'yi, daa wne': X̱an' ¿azoa beṉ' ba wyajḻi'e dillaa chyix̱je'nto'? Na' ¿azoa beṉ' ba gokbe'ile' bli'o yeḻ' wak c̱ho'na'? ");
INSERT INTO zadNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Na' bi wyajḻe'gake', ḻa' Chioza' bene' c̱hegake' ka na sto dii bzej dii Isaíaza': ");
INSERT INTO zadNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Bene' ḻegake' ka beṉ' lc̱hoḻ na' lall'do' c̱hec̱h kwenc̱he bi gakbe'gakile' bi zejin diika' chle'gakile', ni bi shajni'gakile' diika' chengakile', kwenc̱he ki yiyaj yilengakile' na' yiyone' ḻegake' beṉ' wen. ");
INSERT INTO zadNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Wna Isaíaza' ka' daa ble'ile' ka nak balaaṉ xen wala' nap Jesúza', na' bi'e dill' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Na' ḻa'kzi ka', beṉ' zan beṉ' Israelka' lente no beṉ' wṉabia' c̱he'ka' benḻilall'gake' Jesúza'. Per bi be'gake'n dill' daa bllebgake' bich wleb fariseoka' ḻegake' gana' chdop chllaggake' choe'ḻwillgake' Chioza', ");
INSERT INTO zadNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ḻa' wyoolall'chgake' iṉa beṉ' nakgake' beṉ' wen aga ka daa iṉa Chioza' nakgake' beṉ' wen. ");
INSERT INTO zadNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na'ch wṉe Jesúza' zillj chi'e: ―Nottez beṉ' chonḻilall' nad', aga toz' nadaan chonḻilallee, san len beena' bseḻ' nadaan chonḻilallee. ");
INSERT INTO zadNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Na' nottezə beṉ' chle'ile' nad', ḻekzka' chle'ile' beena' bseḻ' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Zaa yell-lioni kwenc̱he beena' gonḻilallee nad' te' lo beeni' c̱ha'na' na' bich soe' lo yel c̱hoḻa'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Na' shi no beṉ' chenile' cho'a xtillaani na' bi chone' ka nia', aga nadaan wc̱hogloa' c̱he', ḻa' aga zaa kwenc̱he wc̱hogloa' c̱he beṉ' yell-lionin, san zaa kwenc̱he yislagakee na' bi kwiayi'gake'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Beena' bi cheenile' gonḻilallee nad' na' bi chzenague' c̱ha', de daa gawan xya c̱he'. Cho'a xtillaana' daa ba bi'a, ḻennan' gawan xya c̱he' kat' illin lla te c̱he yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ḻa' dillaa daa ba bi'a aga to bia'lozan' wnia' ka'. X̱a'na', beena' bseḻ' nad', ḻen' nllie' bia' bin chiyaḻ' iṉia' na' bin chiyaḻ' wli' wsedid' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na' ṉezid' dill' daa nllia X̱a'na' bia' iṉia' nsa'n yeḻ' mban zejḻi kaṉi. Daan, yog'ḻoḻ diika' nia', nakan kon ka wna X̱a'na' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ka ba zoa gaḻ' lṉi Paskwa', na' ṉezi Jesúza' ba zoa gao yizee yell-lioni kwenc̱he yiyaje' kwit X̱e'na'. Na' chakchgaile' beṉ'ka' nonḻilall'gake'ne' yell-lioni, na' ka' gokile' ḻegake' ax̱t ga zeelo. ");
INSERT INTO zadNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Na' ka chaogake' xshe'na', ba wloolə dii x̱iwaa ḻoo yic̱hjlall'do' Jud Scariota', xiiṉ Simónna', gone' Jesúza' lo na' beṉ' malka'. ");
INSERT INTO zadNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Na' ṉezi Jesúza' X̱e'na' bene' lall' nee yog' dii de, na' ṉezile' wzee gana' zoa Chioza' na' kwite'na'kzə yilline' dii yoblə. ");
INSERT INTO zadNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Na' lo zej chaogake' xshe'na', wzolla' Jesúza' na' bkwase' xe' dii toṉa' ka'lə, na' bc̱heḻe' to lech' lsineena'. ");
INSERT INTO zadNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Na'ch wdee nisa' to ḻoo sha' na' wzoloe' chyibe' ṉi'a to to beṉ'ka' nakgake'ne' txen, na' bisbillile'n lechaa nc̱heje' lsineena'. ");
INSERT INTO zadNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na' ka bidoḻ' c̱hibe' ṉi'a Simón Pédrona', na'ch che' Pédrona'ne': ―X̱an', ¿ali'lə c̱hibzo' ṉi'ani? ");
INSERT INTO zadNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Na' che' Jesúza'ne': ―Aga chajniilo' dga chon' ṉaa, per techlə shajniilo'n. ");
INSERT INTO zadNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Na'ch che' Pédrona'ne': ―Bat wi'a latj c̱hibo' ṉi'ani. Na'ch che' Jesúza'ne': ―Shi bi c̱hib' ṉi'ona', bich gako' nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Na'ch chize' Pédrona'ne': ―Shi kan' nakan, X̱an', aga toz ṉi'ani c̱hibo' san ḻen yic̱hji na' na'ki. ");
INSERT INTO zadNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Na'ch che' Jesúza'ne': ―Beena' nosh' nazje', toz ṉi'enan' chiyaḻ' shech, ḻa' ba nechkz kwerp c̱he'na'. Ka'kzan le', ba nxi nyechle, ḻa'kzi aga yog'le. ");
INSERT INTO zadNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Daa ṉezi Jesúza' non gon ḻe' lo na' beṉ' malka', daan chi'e ḻegake': “Aga yog'le ba nxi nyech.” ");
INSERT INTO zadNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Na' ka biyoll wdibe' ṉi'eka', na'ch biyakwe' xe' dii toṉa' na' jachi'e cho'a mesa' sto shii. Na' chi'e ḻegake': ―¿Aṉezile bi zejin dga ba ben'? ");
INSERT INTO zadNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Le' nale nad' Maestro na' X̱an', na' lekzile, ḻa' kan' nakan. ");
INSERT INTO zadNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na' shi nad', naktia' Maestro c̱hele na' X̱anle, ba wdib' ṉi'alena', ḻekzka' le' chiyaḻ' c̱hib ṉi'a ljwell-le. ");
INSERT INTO zadNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ba ben' dga kwenc̱he bliid' le' kan' chiyaḻ' gon c̱he ljwell-le. ");
INSERT INTO zadNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Dii ḻi nia' le', aga zak'chi to mos ka x̱ane'na', na' to beṉ' zej mandad aga zak'che' ka beena' bseḻeene'. ");
INSERT INTO zadNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Shi chajniile diiki ba wnia' na' gonlen, na' soale mbalaz. ");
INSERT INTO zadNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Na' aga yog'len nia' ka'. Ṉezid' nolen ba wlej' kwenc̱he nonḻilall'le nad'. Na' chiyaḻ' gak ka na Cho'a Xtill' Chioza', gana' na: “Beena' chaolentie' nad' txen ba chiyec̱hje' nad' gone' mal c̱ha'.” ");
INSERT INTO zadNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ṉaa nia' le' dga zi' gak, kwenc̱he kat' ba chakan shajḻe'le nak' beena' ba wnia' nak'. ");
INSERT INTO zadNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na' dii ḻi nia' le', beena' wlebe' nottezə beena' wseḻaa, nad'kzan chlebe'. Na' beena' chlebe' nad', lenkz beena' bseḻ' nadaan chlebe'. ");
INSERT INTO zadNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Na' biyoll wna Jesúza' ka', ḻe gokyeshii ḻoo yic̱hjlall'do'ena', na' bi'e dill' kwasḻoḻ, chi'e: ―Dii ḻi nia' le', tole gonle nad' lo na' beṉ' malka'. ");
INSERT INTO zadNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Na'ch beṉ'ka' nakgake'ne' txen chwia ljwellgake' chakgakile' nogaken' chi'e ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na' to beena' nak Jesúza' txen, beena' chakchgaile', chi'e kwite'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Na' Simón Pédrona' bene' seṉ kwenc̱he iṉabi beena' chi' kwit Jesúza' noen' chi'e ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Na'ch jabig'ch beena' gaoch kwit Jesúza' na' wṉabile'ne', chi'ene': ―¿Noran gon ka', X̱an'? ");
INSERT INTO zadNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Na'ch che' Jesúza'ne': ―Wḻeejch' lat' yetxtili ḻo'i dga yoll ḻoo yeeṉi, na' kon beena' wi'an, ḻen' gon ka'. Na'ch bḻeeje' lat' yetxtila' na' bi'en Jud Scariota', xiiṉ beena' le Simón. ");
INSERT INTO zadNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Na' kon ka biyoll be' Jesúza' Juda' yetxtila', lii wyoote Satanáza' ḻoo yic̱hjlall'do'ena'. Na'ch che' Jesúza'ne': ―Daa ba ngoo yic̱hjo' gono', bentegan. ");
INSERT INTO zadNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Na' ni to beṉ'ka' chaolengake'ne' bi wyajni'gakile' bic̱he gollze'ne' ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Baḻe' gokgakile' goll Jesúza' Juda' lljx̱i'e bi dii chyalljgakile' c̱he xshe' c̱he'ka', wa wi'e lat' mech beṉ' yesh'ka'. Ḻa' ḻen' nak lall' nee xmeche'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Na' ka wde wdao Juda' yetxtila' daa be' Jesúza'ne', lii wza'tie'. Na' ba goḻ ka wzee. ");
INSERT INTO zadNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Na' ka wde wza' Juda', na'ch che' Jesúza': ―Ba bllin lla sho'a balaaṉ, nad', Beṉ' Bseḻ' Chioza' Yell-lioni, na' ḻekzka' dga gon', gonan ka sho' Chioza' balaaṉ. ");
INSERT INTO zadNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na' daa gon' ka sho' Chioza' balaaṉ, ḻekzka' kwin Chioza' gone' kwenc̱he nad', Beṉ' Bseḻ' Chioza' Yell-lioni, sho'a balaaṉ, na' lii gontie'n. ");
INSERT INTO zadNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Le' xiiṉdawaa, zi shlollchga zoalen' le'. Na' yiyiljle nad', na' chiznia' le' ka gosh' beṉ'ka' chṉabia' beṉ' Israelka': Gana' yiyaa, bi gak sa'le. ");
INSERT INTO zadNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Na' to dii kob chllia' bia' gonle ṉaa: Ḻi gaki ljwell-le. Ka chakid' le', kan' chiyaḻ' gaki ljwell-le. ");
INSERT INTO zadNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Shi gaki ljwell-le, na'ch iṉezi yog'ḻoḻte beṉ' nakle nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Na'ch Simón Pédrona' wṉabile' Jesúza', chi'ene': ―X̱an', ¿garan yiyajo'? Na' che' Jesúza'ne': ―Aga wak soo gana' yiyaa ṉaa, per wllin lla soo. ");
INSERT INTO zadNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Na'ch che' Pédrona'ne': ―X̱an', ¿berac̱he bi gak sa'len' li' ṉaa? Ba nc̱hoglallaa guet' ni c̱ho'. ");
INSERT INTO zadNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Na' Jesúza' chi'ene': ―¿Achakilo' ba nc̱hoglalloo gueto' ni c̱ha'? Dii ḻi nia' li', shoṉ shii bi wc̱hebo' shi nombi'o nad' ka zi' kwell-lə shikwteza'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Bi gakshejlall'le. Ḻi gonḻilall' Chioza' na' ḻekzka' ḻi gonḻilall' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lill xḻatj X̱a'na' dii xen latj de. Sheḻ' bi nakan ka', ba wnia' le' ka', sheḻ'ka'. Na' ṉaa yiyaa lljayenshawaa gana' yidzoale. ");
INSERT INTO zadNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na' kat' ba benshawaan, na'ch yiyed' yidxia' le' kwenc̱he lenle soale gana' zoa'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Na' ba nombia'le neza' daa chillin gana' lljazoa'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Na'ch Tomáza' chi'ene': ―X̱an', bi ṉezinto' gan yiyajo'. ¿Nakran gonnto' yillelinto' neza'? ");
INSERT INTO zadNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Na' che' Jesúza'ne': ―Nadaan' neza' daa chillin lao Chioza', na' chli'a daa nak dii ḻi, na' cho'a beṉ' yeḻ' mban zejḻi kaṉi. Aga no yillin kwit X̱a'na' shi bi gonḻilallee nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Daa ba nombia'le nad', lenkz X̱a'nan' ba nombia'le. Na' ṉaa ba nombia'lene' na' ba ble'ilene'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Na'ch che' Felípena'ne': ―X̱an', ben ka ile'into' X̱o'na' na' x̱enlall'nto'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Na'ch billii Jesúza' xtilleena', chi'e: ―Felipe, ba wlla zoalen' le', ¿ana' bikzaṉ' gombia'yeṉoo nad'? Beena' ba ble'ile' nad' ḻekzka' ba ble'ile' X̱a'na'. ¿Berac̱he chṉabzo' gon' ka ile'ilene'? ");
INSERT INTO zadNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Abi chajḻi'o zoalen X̱a'na' nad' na' nad' zoalenee? Diika' nia' le' aga to bia'lozan' chṉia'n, san daa cheeni kwin X̱a'na', beena' zoalene' nad', ḻennan' cho'a dill' na' ḻennan' chon'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ḻi shajḻe' daa nia' zoalen X̱a'na' nad', na' nad' zoalen' ḻe'. Na' shi bi chajḻe'le dga nia', ḻa'c̱h' ḻi shajḻe' c̱ha' ni c̱he yeḻ' wakki chle'ile' chon'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Dii ḻi nia' le', nottez beṉ' chonḻilallee nad', gone' ka diika' chon'. Na' dii zak'techi gone' aga ka diika' chon', daa yiyaa kwit X̱a'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na' gon' bittez daa iṉabile X̱a'na' daa nakle nad' txen kwenc̱he sho'e balaaṉ ni c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nad' gon' bittezə daa iṉable daa nakle nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Shi chakile nad', ḻi gon diika' nllia' bia' gonle. ");
INSERT INTO zadNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na' iṉabid' X̱a'na' wseḻee sto beṉ' gaklene' le' na' soalene' le' toshiizi. ");
INSERT INTO zadNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ḻen' Espíritu Sántona', beena' chli' daa nak dii ḻi. Na' beṉ' yell-lioki aga wak wlebgake'ne', ḻa' bi chle'gakile'ne' ni bi nombia'gake'ne'. San le', ba nombia'lene' daa zoalene' le' na' soe' ḻoo yic̱hjlall'do'lena'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Aga wikwaaṉ' le' ka bi' wizeb, san wiyedch' soalen' le'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aga chllach bich ile'i beṉ' yell-lioni nad', san le' wle'chkzile nad'. Na' daa mban' toshiizi, ḻekzka' le' toshiizi ibanle. ");
INSERT INTO zadNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kat' illin llana' nia' ka', na' gakbe'ile zoalen' X̱a'na', na' le' zoalenle nad' na' nad' zoalen' le'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nottez beṉ' chzenague' daa nllia' bia' na' chone' ka nan, beenan' chakile' nad'. Na' beena' chakile' nad', ḻekzka' gaki X̱a'na'ne', na' nad' ḻekzka' gakidee na' gon' kwenc̱he gombia'che' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Na' Júdaza' (beena' sto, aga Jud Scariota',) chi'ene': ―X̱an', ¿berac̱he to neto'z gonzo' ka gombia'chnto' li' na' bi len beṉ' yell-lioki, beṉ'ka' bi chonḻilall'gake' li'? ");
INSERT INTO zadNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Na' billii Jesúza' xtilleena': ―Beena' chakile' nad', wzoe' xtillaa, na' X̱a'na' gakile'ne', na' nad' kon X̱a'na' yidsoalennto'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Na' beena' bi chakile' nad', bi chzoe' xtillaa. Na' diika' chli' chsedid' aga dii chyiljlallzaan, san X̱a'na', beena' bseḻ' nad', chzajniile'n nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Yog' diiki choe'len' le' dill' ṉaa shlak ni zoalen' le'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Na' kat' bich soa' len le', Espíritu Sántona', beena' wseḻ' X̱a'na', gaklene' le' na' wzajniile' le' yog' dii chiyaḻ' iṉezile, na' gone' ka lljadinile yog' diika' ba wnia' le'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Yeḻ' mbalaza' chkwaaṉlena'n le'. Na' yeḻ' mbalaz c̱ha'na' choṉ' le' bi nakan ka yeḻ' mbalaz c̱he beṉ' yell-lioka'. Bi gakshejlall'le, ni bi gall illeble. ");
INSERT INTO zadNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ba benkzile nia' yiyaa gana' zoa X̱a'na' na' ḻekzka' wiyedchkz' yidzoalen' le'. Na' shi chakile nad', chiyaḻ' yibaile daa yiyaa gana' zoa X̱a'na', ḻa' zak'che' aga ka nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Na' ba nia' le' diiki zi' gak kwenc̱he kat' gakan shajḻe'le. ");
INSERT INTO zadNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Na' bich bitek dill' we'lench' le' ṉaa, ḻa' ba za' dii x̱iwaa, daa chṉabia' yell-lioni. Per aga wak iṉabia'n nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ḻa' chon' kon ka nllia X̱a'na' bia' gon' kwenc̱he iṉezi beṉ' yell-lioki chakid' X̱a'na'. Ḻi yizolla'. Ḻi yidó. ");
INSERT INTO zadNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Nad' nak' ka yag uva daa nak dowalj, na' X̱a'na' nake' ka beena' chaz chaaṉan. ");
INSERT INTO zadNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Na' yog'ḻoḻ xoz' xka'inna' daa bi chbia, chc̱hogue'n. Na' diika' chbia, chonshao'che'n kwenc̱he zizikli kwian. ");
INSERT INTO zadNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Na' le', nakle ka xoz' xka'inna' daa chbia, daa bzenagle ka nak dill'ka' be'len' le'. ");
INSERT INTO zadNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ḻi soatezi soa gonle nad' txen, na' ka'kz nad' soatezi soalen' le'. Ka xoz' xka'inna', shi bi ndiḻ nllagan xyaguinna' aga bi chbian, ka'kzan le' shi bi soatezi soale gonle nad' txen bi gak gonle daa chibaid'. ");
INSERT INTO zadNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Nad' nak' ka to yag uva, na' le' nakle ka xoz' xka'inna'. Shi le' soatezi soale gonle nad' txen na' nad' soatezi soalen' le', na' gakle ka xoz' xka'inna' daa chbiachga. Shi le' bi nakle nad' txen aga bi gak gonle. ");
INSERT INTO zadNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Beena' bi gone' ka dii le gone' nad' txen, nake' ka xoz' xka'inna' daa ba bc̱hogue' na' ibillan, na' yitope'n wzaḻeen lo yi'na' kwenc̱he sheyan. ");
INSERT INTO zadNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Shi le' soatezi soale gonle nad' txen na' toshiizi chzoale xtillaana', ḻi iṉab daa cheenile na' gakan. ");
INSERT INTO zadNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","X̱a'na' cho'e balaaṉ kat' chonle dii wenna', na' daa chonle ka', chli'lawin dii ḻi nakle nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ka chaki X̱a'na' nad', ka'kzan chakid' le'. Ḻi soatezi soa gonle nad' txen kwenc̱he gakbe'ile chakid' le'. ");
INSERT INTO zadNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Shi gonle daa nllia' bia' gonle, na'ch gakbe'ile ḻe chakid' le', ka chon' nad', chon' daa nllia X̱a'na' bia' gon', na' ka' chakbe'id' ḻe chakile' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ba wnia' le' ka' kwenc̱he yiba yizaklenile' nad', na' yiyoll yido soale mbalaz. ");
INSERT INTO zadNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Na' dgan nllia' bia' gonle: Gaki ljwell-le ka chakid' le'. ");
INSERT INTO zadNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bich bi yeḻ' chaki dii xench de ka c̱he beena' chzani yeḻ' mban c̱he'na' guete' ni c̱he beṉ'ka' nllaguile'. ");
INSERT INTO zadNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Len' nakle beṉ'ka' nllaguid' shi chonle ka nllia' bia' gonle. ");
INSERT INTO zadNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Bich gon' le' ka mos, ḻa' beena' nak mos aga ṉezile' bin chon x̱ane'na'. San nakle beṉ' nllaguid' ḻa' ba bzajniid' le' yog' diika' wna X̱a'na' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Aga len' wlejle nad', san nadaan wlej' le' na' ba bzoa' le' shajle lljenle dii wenna' daa bi te c̱heyi. Na' X̱a'na' goṉe' yog' daa iṉabilene' daa nakle nad' txen. ");
INSERT INTO zadNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na' dgan chllia' bia' gonle: Gaki ljwell-le ganga. ");
INSERT INTO zadNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Bibi gakile shi beṉ'ka' bi nombia' Chioza' gakzbangakile' le', ḻa' ṉezkzile ka'kzan gokzbangakile' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sheḻ' nakle ḻegake' txen na'ch gakgakile' le', sheḻ'ka'. Per daa ba wlej' le' kwenc̱he gakle nad' txen, daan chakzbangakile' le'. ");
INSERT INTO zadNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ḻi lljadini ka ba wniakz' le': “Aga iṉacho zak'chi to mos ka x̱ane'na'.” Ka ba bsak'zi'gake' nad', ka'kzan wsak'zi'gake' le'. Na' shi bzenaggake' cho'a xtillaana', ḻekzka' wzenaggake' c̱hele. ");
INSERT INTO zadNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yog' diikin gongakile' le' daa nakle nad' txen, ḻa' bi nombia'gake' X̱a'na' beena' bseḻ' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Beṉ'ka' bi nombia' Chioza', aga bi doḻ' napgake' sheḻ'ka' bi bidye'len' ḻegake' xtilleena'. Per daa ba bidye'len' ḻegake' xtilleena' bi gak iṉagake' bi chakbe'gakile' chongake' dii mala'. ");
INSERT INTO zadNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Beena' chakzbanile' nad' lenkz X̱a'nan' chakzbanile'. ");
INSERT INTO zadNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Aga bi doḻ' napgake' sheḻ'ka' bi bli'a yeḻ' wakka' daa konoṉ' gon ladje'ka'. Na' ḻa'kzi ba ble'gakile' diika' chon', bia'kzə chakzbangakile' nad' na' X̱a'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Chak dga kwenc̱he chillinin ka na ley c̱he'ka' gana' nan: “Kon gokzi' gokzbangakile' nad' ḻa'kzi aga bi ben' c̱hegake'.” ");
INSERT INTO zadNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Na' wseḻaa Espíritu c̱he X̱a' Chioza', beena' gaklene' le'. Espírituna', beena' chli' daa nak dii ḻi, see gana' zoa X̱a' Chioza' na' yidyee xtillaa. ");
INSERT INTO zadNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na' ḻekzka' lenle we'le cho'a xtillaana', ḻa' ba gokle nad' txen ka wzoloa' chli' chsedid' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Ba wnia' le' diiki kwenc̱he bi yidiṉjile' daa chonḻilall'le nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ḻa' bich wlebgake' le' gana' chdop chllagcho choe'ḻwillcho Chioza', na' wllin lla ax̱t wit beṉ' le' daa gakile' kan' chazlall' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Gongake' ka' daa bi nombia'gake' X̱a'na', ni bi nombia'gake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Na' nia' le' diiki kwenc̱he kat' ba bllin lla ile'ile yeḻ' zak'zi'ka', lljadinile ka'kzan ba wnia' gak c̱hele. Bi wnia' le' ka' dii nechte daa ni zoalen' le'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","’Na' ṉaa yiyaa lljazoalen' X̱a'na' beena' bseḻ' nad', na' ni stole bich chṉabile nad' gan yiyaa. ");
INSERT INTO zadNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Na' daa ba wnia' le' ka' ḻe chakyesh'zi'le'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Per dii ḻi nia' le', wakch wen c̱hele shi yiyaa. Ḻa' shi bi yiyaa, beena' gaklene' le' bi yidsoalene' le'. San shi ba ziyaa, na' wseḻaane'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na' kat' yide', gone' kwenc̱he gakbe'i beṉ' yell-lioki nakgake' beṉ' saaxya daa bi biyombia'gake' beena' nak dowalj beṉ' ḻi beṉ' shao', na' gakbe'gakile' chidoḻ'gake' wc̱hoglo Chioza' c̱hegake' ni c̱he xtoḻeeka'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yiyakbe'gakile' napgake' doḻ' daa bi chonḻilall'gake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Na' yiyakbe'gakile' nak' beṉ' ḻi beṉ' shao' daa yiyaa gana' zoa X̱a'na' na' aga wle'chile nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Na' ḻekzka' yiyakbe'gakile' Chioza' wi'e yeḻ' zak'zi' c̱he beṉ'ka' bi chzenag c̱ha', ḻa' ba bc̱hogloe' sak'zi' dii x̱iwaa daa chṉabia' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Dii zanch de dii iṉia' le', dii bi shajniile ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Per kat' ila' Espíritu Sántona', beena' chli' daa nak dii ḻi, ḻen' wzajniile' le' kwasḻoḻ daa nak dii ḻi. Ḻa' aga dii c̱hiljlall'ze'n iṉe', san iṉe' daa che' X̱a'na'ne', na' c̱hix̱je'ile' le' diika' zi' za' gak. ");
INSERT INTO zadNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Na' gone' ka sho'a balaaṉ, ḻa' wzajniile' le' diika' ba wnia'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ḻa' yog'ḻoḻte daa na X̱a'na' ḻennan' cho'a dill'. Daan nia', Espírituna' wzajniile' le' diika' ba wnia'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Aga chllach bich ile'ile nad', na' ḻekzka' aga wlla yizle'ile nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Na' baḻ beṉ'ka' nakgake'ne' txen wṉabi ljwelle': ―¿Bera zejin daa ne' aga chllach bich ile'ichone', na' ḻekzka' aga wlla yizle'ichone', na' daa natelze' yiyaje' kwit X̱e'na'? ");
INSERT INTO zadNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Bi zejin daa naze' “aga chllach”? Bi chajniicho bic̱he naze' ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na' Jesúza' gokbe'ile' cheengakile' iṉabgakile'ne' bi zejin daa wne', na'ch chi'e ḻegake': ―¿Achṉabi ljwell-le bi zejin daa wnia' le' aga chllach bich ile'ile nad', na' ḻekzka' aga wlla yizle'ile nad'? ");
INSERT INTO zadNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Dii ḻi nia' le', kwell-le na' gakyeshile shlak beṉ'ka' bi nombia' Chioza' yibagakile'. Na' ḻa'kzi gakyeshile, yeḻ' chakyeshii c̱helena' yiyakan yeḻ' xaba. ");
INSERT INTO zadNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kat' chzan to noolə, chey chle' daa ba bllin gor sane'. Na' ka chiyoll chzane' ni bich chjtinile' yeḻ' chey chlana', daa ḻe chibaile' ba zoa to bi'do' c̱he' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ka'kzan chak c̱hele. Ṉaa chakyeshile, na' ka yillagcho dii yoblə kanan' yiba yizakile, na' ni to kono wsej wllon yibaile. ");
INSERT INTO zadNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Na' kana'chan bich bi iṉabile nad'. Dii ḻi nia' le', bittezə dii iṉabile X̱a'na', goṉkze'n, daa nonḻilall'le nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ax̱t ṉaa ni to bibiṉ' iṉabile X̱a'na' daa nonḻilall'le nad'. Ḻi iṉab bittez dii cheenile iṉabilene' na' goṉkze'n kwenc̱he yiyoll yido soale mbalaz. ");
INSERT INTO zadNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Ba bseesaa jemplka' bzajniid' le' diiki, na' wllin lla kat' bich wzajniid' le' kon jempl, san we'len' le' dill' c̱he X̱a'na' ka to shajniilen. ");
INSERT INTO zadNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Na' kat' ba bllin llana', kanan' iṉabile X̱a'na' bittezə dii iṉabilene' daa nonḻilall'le nad', na' bi chonan byen kwin' iṉabidee gaklene' le', ");
INSERT INTO zadNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ḻa' kwinkz X̱a'na' chakile' le' daa chakile nad' na' daa chajḻe'le bseḻee nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Wzaa gana' zoa X̱a'na' kwenc̱he bid' yell-lioni, na' ṉaa yizaa yell-lioni kwenc̱he yiyaa gana' zoe'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Na'ch che' beṉ'ka' nakgake'ne' txen: ―Ṉaach ba choo dill' dii najnii, na' bich bi jempl chc̱hino'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Na' chakbe'into' ṉez nḻe'ilo' yog'ḻoḻte, na' aga chonan byen no bi iṉabzi li', ḻa' ba ṉezlilo' bin iṉabile' li'. Daan chajḻe'nto' dii ḻi zoo gana' zoa Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Na' che' Jesúza' ḻegake': ―¿Aṉaach chajḻe'le? ");
INSERT INTO zadNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ba zoa illin lla, wa ba bllinkz llana', illeshlesle na' gala ikaa twej twejle, na' yikwaaṉle toz'. Per aga tozan' yigaaṉa', ḻa' zoalenkz X̱a'na' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ba wnia' le' yog' diiki kwenc̱he soale mbalaz daa nakle nad' txen. Yell-lioni biya dii yen ile'ile, per ḻi gondiplall', ḻa' ba ben' gan daa chṉabia' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Na' ka wde wna Jesúza' diika', na' bḻis jalawe'na' bwie' yabalə, na' golle': ―X̱a, ba bllin gor illagloa' daa llia bia' wtiḻ'. Wloo nad' balaaṉ, nad' nak' xiiṉo', kwenc̱he ḻekzka' nad' kwaa li' balaaṉ. ");
INSERT INTO zadNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ḻa' ba beno' lo na' iṉabia' lao yog'ḻoḻ beṉ', kwenc̱he gon' ka gat' yeḻ' mban zejḻi kaṉi c̱he beṉ'ka' wlejo' gonḻilall'gake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na' daa gat' yeḻ' mban zejḻi kaṉi c̱he beṉ', zejin nombia'gake' li', nako' dowalj Chios, na' ḻekzka' nombia'gake' nad', beṉ' bseḻoo yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Nad' ba wlo'a li' balaaṉ lao beṉ' yell-lioki, na' ba biyoll ben' daa bllio' bia' gon'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Na' ṉaa, X̱a, yiyoṉgacho' nad' balaaṉna' kat' yiyed' kwito'na' ka balaaṉna' daa wdapkz' kana' wzoalen' li' ka zi' x̱e sil yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ba beṉo' nad' beṉ'ki wlejo' yell-lioni kwenc̱he gonḻilall'gake' nad', na' ba bzajniid' ḻegake' ka nako'. Lall' non' nakgake', na' beno' ka benḻilall'gake' nad' na' chzenaggake' xtilloona'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Na' ṉaa ba ṉezgakile' yog' dill'ka' bi'a nakan dii wno'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ḻa' ba be'len' ḻegake' dill' daa nllio' bia' we'lengakee na' ba bzenaggake'n. Na' ba gokbe'gakile' dii ḻi wzaa gana' zo' na' ba wyajḻe'gake' lin' bseḻoo nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Chṉabid' li' gakleno' ḻegake'. Aga chṉab' gakleno' yog' beṉ' yell-lioki, san chṉab' gakleno' beṉ'ka' wlejo' kwenc̱he gonḻilall'gake' nad', ḻa' lall' non' nakgake'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Na' yog' beṉ'ka' nak lall' na' ḻekzka' nakgake' lall' no'. Na' ḻegake' ba wloogake' nad' balaaṉ. ");
INSERT INTO zadNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Na' ṉaa ba chiza' yell-lioni. Na' ḻegake' yigaaṉgake' ni. X̱a, li' nako' dowalj beṉ' wen beṉ' shao'. Wdapgach beṉ'ka' ba beṉo' nonḻilall'gake' nad' kon yeḻ' wak c̱ho'na' kwenc̱he gakgake' toz, ka nakcho cho' nakcho toz. ");
INSERT INTO zadNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Shlak wzoalen' ḻegake' yell-lioni ba wdap bwia' ḻegake' kon yeḻ' wak c̱ho'na'. Na' ni toe' bi wlliayi', ḻetechokzə beena' ba nakan kwiayee, kwenc̱he gak ka na Cho'a Xtilloona'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Na' ṉaa ba zizaa gana' zo'. Na' nia' li' diiki shlak ni zoa' yell-lioni kwenc̱he beṉ'ki gapgake' yeḻ' xaba ka daa nap'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nad' ba bzajniid' ḻegake' cho'a xtilloona', na' beṉ'ka' bi nombia' li' chakzi' chakzbangakile' ḻegake' daa bi nakgake' ḻegake' txen, ka chon' nad' bi chon' txen beṉ'ka' bi nombia' li'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Aga chṉabid' li' yikoo beṉ'ki nonḻilall' li' lo yell-lioni, san chṉab' wkweejgachgako'ne' kwenc̱he ki c̱hitj seni dii mala' daa chda yell-lioni ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bi nongake' txen beṉ'ka' bi nombia' li', ka chon' nad' bi chon' beṉ'ka' txen. ");
INSERT INTO zadNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bengach kwenc̱he beṉ'ki nonḻilall' nad' gakchgake' ka chazlalloo daa chzenaggake' dill' ḻi c̱ho'na', ḻa' cho'a xtilloona' nakan dii ḻi. ");
INSERT INTO zadNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ka beno' bseḻoo nad' kwenc̱he bidsoa' yell-lioni, ka'kzan chseḻaa ḻegake' kwenc̱he shajgake' ladj beṉ' yell-lioki. ");
INSERT INTO zadNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Chzanlallaa kwin' gon' ka no' ni c̱hegake', kwenc̱he ḻekzka' gongake' ka no' daa ba chzenaggake' dill' ḻi c̱ho'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Aga chṉabid' li' gakleno' to ḻezgake', san ḻekzka' chṉab' gakleno' beṉ'ka' gonḻilall' nad' kat' wzenaggake' cho'a xtillaana' daa we' beṉ'ki. ");
INSERT INTO zadNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","X̱a, chṉabid' li' gonshgo' ka gak yog'gake' toz, ka nakcho cho' nakcho toz. Ḻekzka' chṉab' gakgake' cho' toz kwenc̱he beṉ'ka' bi nonḻilall' li' shajḻe'gake' lin' bseḻoo nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ba wlo'a ḻegake' balaaṉ ka daa wloo nad', kwenc̱he gakgake' toz ka nakcho cho' nakcho toz. ");
INSERT INTO zadNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nad' nakgakee toz ka nakcho cho' nakcho toz. Bengach ka gakgake' toz ka chiyaḻ', kwenc̱he beṉ'ka' bi nonḻilall' li' gakbe'gakile' lin' bseḻoo nad', na' gakbe'gakile' chakilo' beṉ'ka' nonḻilall' nad' ka chakilo' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’X̱a, li' ba beṉo' nad' ḻegake', na' cheenid' soalengake' nad' gana' soa' kwenc̱he ile'gakile' balaaṉ c̱ha'na' daa beṉo' nad' ka zi' x̱e silte yell-lioni daa chakilo' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","X̱a, li' nako' beṉ' ḻi beṉ' shao'. Ḻa'kzi beṉ'ka' bi nonḻilall' nad' bi nombia'gake' li', nad' nombi'a li' na' beṉ'ki nonḻilall' nad' ṉezgakile' lin' bseḻoo nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Na' ba bzajniid' ḻegake' non nako', na' zizikli wzajni'chgakidee kwenc̱he kon ka chakilo' nad' ka'kzə gakgakile' beṉ', na' nad' soalenkzgakee. ");
INSERT INTO zadNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Na' ka biyoll wna Jesúza' ka', wza'lene' beṉ'ka' nakgake'ne' txen wyajgake' shḻaa yao Cedrónna', na' wyoolene' ḻegake' to yell-lio ga lle' lla' yag olivo. ");
INSERT INTO zadNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na' Juda', beena' bene' Jesúza' lo na' beṉ' malka', ḻekzka' nombi'e latja', ḻa' Jesúza' zan shii wyajlene' ḻegake' na'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Na' bllinlen Juda' beṉ' zan soldad na' zi x̱oṉj beṉ'ka' chap yoodo'na', beṉ'ka' bseḻ' bx̱ozka' chṉabia' len fariseoka'. Zejgake' nox̱'gake' no kandil, no yi' yech, na' dii wṉiagakile'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Na' Jesúza' ba ṉezkzile' yog' daa zi' gak c̱he', na'ch bcheje' jatiḻe' ḻegake', na' chi'e: ―¿Non chiyiljle? ");
INSERT INTO zadNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Na' che'gake'ne': ―Jesús, beṉ' Nazaretan', chiyiljnto'. Na'ch che' Jesúza' ḻegake': ―Nadaan'. Na' lengake' Juda', beena' bene' ḻe' lall' na'gake'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Na' ka goll Jesúza': “Nadaan”, to biza'zgake' jayetgake' wza'che'lə. ");
INSERT INTO zadNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Na'ch wizṉabi Jesúza' ḻegake': ―¿Noran chiyiljle? Na' che'gake'ne': ―Jesús, beṉ' Nazaretan'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Na'ch che' Jesúza' ḻegake' sto shii: ―Ba wniakz' le' nadaan. Na' shi nadaan chiyiljle, ḻi we' latj yiyaj beṉ'ki. ");
INSERT INTO zadNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Golle' ḻegake' ka' kwenc̱he billinin daa wne': “X̱a, ba wdap' beṉ'ka' beṉo' nad' na' ni toe' bi wlliayi'.” ");
INSERT INTO zadNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Na' Simón Pédrona' no'e to spad, na'ch wleje'n bc̱hogue' tḻaa nag to beṉ' le Malco, de shḻina'. Na' Málcona' nake' xmos bx̱oz choo bx̱oz xenna'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Na'ch che' Jesúza' Pédrona': ―Bigoo spad c̱ho'na' ḻoo lillinna'. Ḻa' chonan byen gak c̱ha' daa ba nllia X̱a'na' bia' gak. ");
INSERT INTO zadNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Na'ch soldadka' len x̱ane'ka', na' beṉ'ka' chap yoodo' c̱he beṉ' Israelka', bex̱'gake' Jesúza' na' bc̱hejgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Na' zigaate jwa'gake'ne' lao Anáza' xtobiiṉ c̱he Caifáza', na' Caifáza' nake' bx̱oz choo bx̱oz xen lo yiza'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na' Caifáza', ḻen' beena' golle' beṉ'ka' chṉabia' beṉ' Israelka' wenchlan witgake' toz Jesúza' aga ka daa kwiayi' yog' beṉ' wlall c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na' Simón Pédrona' len sto beṉ' nake' Jesúza' txen janogake'ne'. Na' beena' zejlen Pédrona' txen nombia' bx̱oz choo bx̱oz xenna'ne', daan gok wyoolene' Jesúza' lesh' chyoo c̱he bx̱oz choo bx̱oz xenna'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Na' Pédrona' wzie' cho'a leeja'. Na'ch beena' nombia' bx̱oz choo bx̱oz xenna', bicheje' jashaljlene' bi' nool wewaa chap cho'a leeja' kwenc̱he be'b' latj wyoo Pédrona'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Na'ch bi' nool wewaa chap cho'a leeja' che'b' Pédrona': ―¿Aaga lenon' nako' beeni txen? Na' che' Pédrona'b': ―Bi len' nakee txen. ");
INSERT INTO zadNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na' moska' len beṉ'ka' chap yoodo'na' wlekgake' yi'na' kwenc̱he wbillgake' daa ba chak zag. Na' jselen Pédrona' ḻegake' cho'a yi'na' kwenc̱he billa'ile'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na' beena' nak bx̱oz choo bx̱oz xen wṉabyollile' Jesúza' no beṉ'ka' nakgake'ne' txen na' beran chli' chsedile'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Na' che' Jesúza'ne': ―Ladj lkwe' beṉaan ba bi'a dill'. Ba bli' bsedid' beṉ' lesh' chyoodo'na' na' gachlə chdop chllag beṉ' wlallka' choe'ḻwillgake' Chioza'. Na' bibi dill' bi'a do ngash'zə. ");
INSERT INTO zadNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Berac̱he chṉabzilo' nad'? Wṉabi beṉ'ka' ba bli' bsedid' kwenc̱he iṉagake' li' beran ba goshgakee. Ḻa' ṉezgakile' bin ba bli' bsedid' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Na' ka wde wna Jesúza' ka', to beṉ'ka' chap yoodo'na' wdape' x̱agueena', chi'ene': ―¿Bic̱he chilliizo' bx̱oz choo bx̱oz xenni dill'? ");
INSERT INTO zadNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Na' che' Jesúza'ne': ―Shi bi dii mal ba wnia', wnashki beran ba wnia'. Na' shi shḻikzan ba wnia', ¿berac̱he chitzo' nad'? ");
INSERT INTO zadNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Na'ch de nchejzi Jesúza' bde Anáza'ne' lao Caifáza', beena' nak bx̱oz choo bx̱oz xen. ");
INSERT INTO zadNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na' shlak ze Pédrona' chshee cho'a yi'na', beṉ'ka' lle' na' che'gake'ne': ―¿Aaga lenon' nako' beeni txen? Na' bi bc̱hebe', san chi'e: ―Bi nakee txen. ");
INSERT INTO zadNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Na' to xmos bx̱oz choo bx̱oz xenna', beena' nak bish' ljwell beena' bc̱hog Pédrona' nague'na', chi'ene': ―¿Aaga lenon' ble'lenid' Jesúza' gana' lle' yag olívoka'? ");
INSERT INTO zadNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Na' stokzə bi bc̱heb Pédrona', na' lii wchellte shikwteza'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na' cheeni'ḻesdo' bichejgake' lill Caifáza' na' bic̱he'gake' Jesúza' gana' chon Pilátona' yeḻ' josc̱hisa'. Na' beṉ' Israelka' aga wyoolengake' Jesúza' gana' chon Pilátona' yeḻ' josc̱hisa', ḻa' aga wak gaogake' daa chsini'agake' c̱he Paskwa' shi ba wyoogake' ḻoo yoona'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Na'ch bchej Pilátona' chi'e ḻegake': ―¿Bi xyan chaole c̱he beeni? ");
INSERT INTO zadNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Na' che'gake'ne': ―Sheḻ' bibi dii mal chone' aga widwa'nto'ne' lawo' ni, sheḻ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Na'ch che' Pilátona' ḻegake': ―Ḻi yic̱hi'e na' ḻi gon yeḻ' josc̱his c̱he' kon ka na ley c̱helena'. Na' beṉ'ka' chṉabia' beṉ' Israelka' che'gake'ne': ―Aga bi lsens c̱hento' de witnto' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Na' daa gok ka', billinin ka wna Jesúza' gak kat'ka' guete'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Na'ch biyoo Pilátona' gana' chone' yeḻ' josc̱hisa', na' goxe' Jesúza' chi'ene': ―¿Alin' nako' beṉ' wṉabia' c̱he beṉ' Israelki? ");
INSERT INTO zadNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Na' che' Jesúza'ne': ―¿Adii chza'z lalloon no' ka'? ¿Awa beṉ' yoblan ba be'lene' li' xtillaana'? ");
INSERT INTO zadNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Na'ch che' Pilátona'ne': ―¿Achakilo' beṉ' Israel nad'? Beṉ' wlall c̱ho'kikzan na' bx̱ozka' chṉabia' le', ba bengake' li' lo na'. ¿Beran beno'? ");
INSERT INTO zadNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Na'ch che' Jesúza'ne': ―Aga nak yeḻ' wṉabia' c̱ha'na' ka c̱he beṉ' yell-lioki. Sheḻ' nakan ka', beṉ'ka' nak nad' txen wllongake' nad' kwenc̱he bi gox̱' beṉ' wlall c̱ha'ki nad', sheḻ'ka'. Per aga nak yeḻ' wṉabia' c̱ha'na' de yell-lioz. ");
INSERT INTO zadNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Na'ch che' Pilátona'ne': ―¿Ana' beṉ' wṉabia'kzan nako', shka'? Na' che' Jesúza'ne': ―Awe, kan' nakan. Ni c̱heyi daan golj' na' bid' yell-lioni, kwenc̱he wi'a dill' daa nak dii ḻi. Na' yog'ḻoḻ beṉ'ka' chzenaggake' dill' ḻina', chzenaggake' c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Na'ch che' Pilátona'ne': ―¿Beran nak dill' ḻi? Na' ka wde goll Pilátona'ne' ka', na'ch bizcheje' kwenc̱he jashaljlene' beṉ' wṉabia' c̱he beṉ' Israelka', na' chi'e ḻegake': ―Ni to dii mal bi chillelid' chon beeni. ");
INSERT INTO zadNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Na' kon ka yoolole chak yog' yiz chsan' to beṉ' de lillyana' kat' chaḻ' lṉi Paskwi, ¿abi cheenile yisan' beṉ' wṉabia' c̱heleni, le' nakle beṉ' Israel? ");
INSERT INTO zadNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Na'ch yog'gake' besyaagake' zillj, che'gake'ne': ―¡Aga beenan' yisano'! ¡Barrabázan' bisan! Na' Barrabáza' nake' to beṉ' wban. ");
INSERT INTO zadNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Na' ka' gok ben Pilátona' mandad bet wdingake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Na' soldadka' bengake' to bxooṉ de xis yesh' na' bllingake'n yic̱hje'na' ka corona na' bwakwgake'ne' to lech' de morad. ");
INSERT INTO zadNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Na'ch wbig'gake' lawe'na' chtitjgakile'ne', chongake' ka beṉ' chgoo ḻe' balaaṉ, che'gake': ―¡Toshiizi sechgayi c̱he beeni chṉabia' beṉ' Israelka'! Na' wdapgake' x̱agueena'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Na'ch bizchej Pilátona', chi'e beṉ' Israelka': ―Ḻi wwia, ni kwejee kwenc̱he iṉezile ni to dii mal bi chillelid' bene'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Na' bchej Jesúza' mbinte bxooṉ de xis yeshaa yic̱hje'na' na' nakwtie' lech' morada'. Na'ch che' Pilátona' ḻegake': ―Ni ze beeni chaole xya c̱heyin. ");
INSERT INTO zadNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Na' bx̱ozka' chṉabia' na' beṉ'ka' chap yoodo'na' ka ble'gakile'ne', na'ch wzologake' chosyaagake' zillj, che'gake': ―¡Bdee ḻee yag cruza'! ¡Bdee ḻee yag cruza'! Na' che' Pilátona' ḻegake': ―Ḻi yic̱hi'e, shka'. Na' ḻi wdee, le'. Ḻa' nad', ni to dii mal bi chillelid' bene'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Na' beṉ' wṉabia' c̱he beṉ' Israelka' che'gake'ne': ―De to ley c̱hento' daa na chiyaḻ' guete' daa nalze' nake' Xiiṉ Chios. ");
INSERT INTO zadNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Na' ka gollgake' Pilátona' ka', zizikchli bllebe'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Na'ch biyo'e sto shii gana' chone' yeḻ' josc̱hisa' na' chi'e Jesúza': ―¿Gara beṉ' li'? Na' Jesúza' bikzə bi dill' billi'e. ");
INSERT INTO zadNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Na'ch che' Pilátona'ne': ―¿Berac̱he ki chilli'o xtillii? ¿Abi ṉezilo' nap' yeḻ' wṉabia' kwenc̱he wdaa li' ḻee yag cruza' na' naptia' yeḻ' wṉabia' kwenc̱he yisan' li'? ");
INSERT INTO zadNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Na'ch che' Jesúza'ne': ―Aga bi yeḻ' wṉabia' napo' bi gonilo' nad' sheḻ' bi noṉ Chioza'n li'. Daan, beena' bdie' nad' lawo' ni, doḻ' xench nape' aga ka li'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Na'ch ka beni Pilátona' wne' ka', biyiljlallee naklə ka gone' kwenc̱he yisane' Jesúza', per beṉ'ka' chṉabia' beṉ' Israelka' ax̱t chosyaayigake', che'gake'ne': ―Shi yisano'ne' bi nako' txen Césara', ḻa' nottez beena' iṉa nake' beṉ' wṉabia', Césaran' chizoshyi'e. ");
INSERT INTO zadNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Na' ka beni Pilátona' gollgake'ne' ka', bizcheje' nc̱hi'e Jesúza'. Na'ch jc̱hi'e gana' chone' yeḻ' josc̱hisa', gana' le Gábata de dill' hebreo, na' zejin latj ga ntaogake' yaj. ");
INSERT INTO zadNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na' gok dga llana' chsini'agake' c̱he lṉi Paskwa'. Na' ka do gobill goll Pilátona' beṉ' Israelka': ―Ni ze beṉ' wṉabia' c̱heleni. ");
INSERT INTO zadNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Na'ch ḻegake' chosyaagake'. Zeyidgake', che'gake': ―¡Wdoyo beena'! ¡Bdee ḻee yag cruza'! Na'ch che' Pilátona' ḻegake': ―¿Acheenile wi'a lsens wda'gake' beṉ' wṉabia' c̱heleni ḻee yag cruza'? Na' bx̱ozka' chṉabia' che'gake'ne': ―Toz Césaran' chṉabi'e neto'. Koch no beṉ' yoblə zoa. ");
INSERT INTO zadNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Na'ch Pilátona' bene' Jesúza' lo na'gake' kwenc̱he wda'gake'ne' ḻee yag cruza', na'ch bc̱he'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Na'ch bwa'gake' Jesúza' yag cruz c̱he'na', na' bc̱he'gake'ne' gana' le Gólgota de dill' hebreo, na' zejin Latj c̱he llit yic̱hj beṉ' wet. ");
INSERT INTO zadNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Na' na' bda'gake' Jesúza' ḻee yag cruza', na' ḻekzka' bda'gake' zi twej beṉ' shḻaa wej. ");
INSERT INTO zadNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Na' Pilátona' bzeje' to dii bda'gake' yic̱hj yag cruz c̱he Jesúza', na' nan ki: “Jesús, beṉ' Nazaret, beṉ' wṉabia' c̱he beṉ' Israelka'.” ");
INSERT INTO zadNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Na' bzeje'n dill' hebreo, dill' latín na' dill' griego. Na' zan beṉ' Israelka' blabgake' daa da' yic̱hj yag cruza', ḻa' gana' bda'gake' Jesúza' ḻee yag cruza' chgaaṉan gaozə yell Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Daan bx̱ozka' chṉabia' beṉ' Israelka' gollgake' Pilátona': ―Bi chiyaḻ' iṉan “Beṉ' wṉabia' c̱he beṉ' Israelka'”; san iṉan “Beenin nalze' nake' beṉ' wṉabia' c̱he beṉ' Israelka'.” ");
INSERT INTO zadNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Na' Pilátona' chi'e ḻegake': ―Kon ka ba bzeja'n, ka'kzan igaaṉan. ");
INSERT INTO zadNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Na' biyoll bda' soldadka' Jesúza' ḻee yag cruza', na'ch bex̱'gake' xe'na' na' bengake'n taplə kweṉche bikaa twej c̱hegake'. Na' ḻekzka' bex̱'gake' xe' dii toṉa' daa nak to shwiḻizə. ");
INSERT INTO zadNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Na' che' ljwellgake': ―Bi wxoxjchon, san goncho to wyitj kwenc̱he ila'shki nocho ikaan. Na' ka' ben soldadka'. Na' daa bengake' ka', billinin ka na Cho'a Xtill' Chioza' gana' na: “Biḻaagake' xa'na', na' bengake' to wyitj kwenc̱he got'bia' nogake' wkaan.” ");
INSERT INTO zadNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na' kwit yag cruz c̱he Jesúza' ze xṉeena' len beṉ' bile'na', na' len María, xool Cleófaza', na' María beṉ' yell Magdálana'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Na' ka ble'i Jesúza' xṉeena', na' ḻekzka' ble'ile' gaozə ze to beena' nake'ne' txen, beena' ḻe chakile', na'ch chi'e xṉeena': ―Beenin yiyoni xiiṉo' ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Na'ch chi'e beena' nake'ne' txen: ―Beenin yiyoni xṉoo ṉaa. Na' lo llana' bic̱hi'e xṉa' Jesúza' wzoe' lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Na' ka wde, ṉezi Jesúza' ba gok yog' daa llia bia' gakə, na' kwenc̱he yillinin ka na Cho'a Xtill' Chioza', wne': ―Chbiḻid'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na' na' zoa to xwag nakan tolla' vino dii nak zic̱hj zḻa'. Na'ch bḻeejgake'n to dii chzi' nisa' na' bzoagake'n to lo xis kwenc̱he bzoagake'n cho'ena'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Na' wde weej Jesúza' daa nak zic̱hj zḻa', na'ch wne': ―Ba gok yog' daa llia bia' gak ṉaa. Na' bc̱hek' yic̱hje'na', na' wite'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na' beṉ'ka' chṉabia' beṉ' Israelka' bi goongakile' yigaaṉ kwerp c̱he beṉ'ka' ḻee yag cruzka' llana' chombaaṉgake'. Daan gollgake' Pilátona' gone' mandad lljtishjgake' ṉi'a beṉ'ka' da' ḻee yag cruza' kwenc̱he yob guetgake' na' yiḻetjgake' kwerp c̱he'ka' ḻee yag cruzka'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Na'ch bseḻee soldad c̱he'ka', na' jtishjgake' c̱hop ḻaate ṉi'a beṉ' necha' da' kwit Jesúza', na' ḻekzka' bengake' c̱he beena' sto da' zi shḻaa kwite'na'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Na' ka jabig'gake' gana' da' Jesúza' ble'gakile' ba wite', na' bi wdishjgake' ṉi'ena'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Na' to soldada' wllibe' to ya lo tosh' kwit ḻi'ena' na' lii bchejten chen len nis. ");
INSERT INTO zadNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Na' beena' choe' dill' c̱heyi diiki, ḻen' ble'ile' ka gok, na' cho'e dill' kwenc̱he lenle shajḻe'le. Na' ḻe' ṉezile' dill' ḻin cho'e. ");
INSERT INTO zadNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Gok diiki kwenc̱he billinin ka na Cho'a Xtill' Chioza' gana' na: “Ni to llitka' yo'e bi c̱hishjgake'.” ");
INSERT INTO zadNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na' gan yoblə ḻee Cho'a Xtill' Chioza' chiznan: “Wwiagake' beena' wllibgake' yana'.” ");
INSERT INTO zadNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Na' ka wde gok diiki, José beṉ' yell Arimatéana', wṉabile' Pilátona' wi'e latj yikee kwerp c̱he Jesúza'. Joséna' goke' txen Jesúza' do ngash'zə daa bllebe' beṉ'ka' chṉabia' beṉ' Israelka'. Na' Pilátona' bi'e latj, na'ch wyaj Joséna' bikee kwerp c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Na' wyajlene' Nicodémona', beena' wyaj jawia Jesúza' waḻ-lə. Na' no'e ka do shichoa kil dii chḻa' zix̱ daa nongake' de mirra na' nc̱hix̱an daa le áloe. ");
INSERT INTO zadNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Na'ch btobgake' kwerp c̱he Jesúza' to lech' toṉ na' blla'gake'n daa chḻa' zix̱, kon ka chon beṉ' Israelka' kat' chkwash'gake' to beṉ' wet. ");
INSERT INTO zadNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na' gaozə gana' bda'gake' Jesúza' ḻee yag cruza' de to latj ga nazgake' yag dii chbia dii zix̱, na' na' zoa to blej kob dii biṉ' koogake' ni tlish' beṉ' wet. ");
INSERT INTO zadNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Na' daa chakbyengakile' wsini'agake' c̱he llana' chombaaṉgake', lii wlootegake' kwerp c̱he Jesúza' ḻoo bleja' zoa gaozə na'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na' lla nech c̱he xmanna', ni shtedo', wyaj María nool Magdálana' cho'a bana'. Na' ble'ile' bich nkwash' yaja' cho'a bana'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Na'ch bizee ziyajdoe' gana' zoa Simón Pédrona' na' sto beena' nak Jesúza' txen, beena' ḻe gokile', jayelle' ḻegake': ―Ba jalejgake' X̱anchona' ḻoo bana' na' bi ṉezinto' galə jaloogake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Na'ch wza' Pédrona' len beena' sto zejgake' cho'a bana'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","C̱hoptie' zejdogake', per beena' to bxoṉjche' aga ka Pédrona' na' zigaate ḻe' blline' cho'a bana'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Na' bchekee bwie' ḻoo bana' na' ble'ile' lech'ka' chi' na', per bi wyo'e. ");
INSERT INTO zadNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Na' ka bllin Simón Pédrona' na' wyo'e ḻoo bana' na' ḻekzka' ble'ile' lech'ka' chi' na'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Na' lecha' bdob yic̱hje'na' aga lenan chi' kwit lech'ka', san ndoban chi'n ka'lə. ");
INSERT INTO zadNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Na'ch ḻekzka' wyoo beena' bllin dii nech cho'a bana', na' ka ble'ile' diika' na' wyajḻi'e dii ḻi biban Jesúzan'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ḻa' kana' aga ba wyajni'yeṉ'gakile' Cho'a Xtill' Chioza' gana' cho'en dill' yiban Jesúza' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Na'ch beṉ'ka' c̱hop non Jesúza' txen biyajgake' gana' zoagake'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Na' Maríana' bigaaṉe' cho'a bana' chbelle'. Na' lo zej chbelle' bchekee kwenc̱he bwie' ḻoo bana'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Na' ble'ile' c̱hop anjl zoagake' do xtil, chi'gake' ḻoo bana', toe' chi' yic̱hjinna' na' stoe' chi' xṉi'alin gana' got' kwerp c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Na'ch che'gake' Maríana': ―¿Berac̱he chbellzo', noolə? Na' golle' ḻegake': ―Chbell' daa ba bidḻejgake' kwerp c̱he X̱an'na', na' bi ṉezid' galə jaloogake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Shintg wne' ka', ka bllii jalawe'na' na' ble'ile' ze Jesúza' kolleena', per bi biyombi'e shi Jesúzan'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Na'ch che' Jesúza'ne': ―¿Berac̱he chbellzo', noolə? ¿Nodaa chiyiljo'? Na' Maríana' chakile' beena' chap yag zix̱kan', na' chi'ene': ―Beṉ'do', shi ba bibejo'ne', wnagach nad' galə jadix̱jo'ne' kwenc̱he yic̱hi'ane'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Na'ch che' Jesúza'ne': ―¡María! Na' biyec̱hje' na' wṉie'ne' dill' hebreo, chi'ene': ―¡Raboni! ―na' zejin: beṉ' chli' chsedi beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Na' che' Jesúza'ne': ―Bi gox̱oo nad', ḻa' biṉ' yiyep' kwit X̱a'na'. Ḻete biyaj, jaṉe beṉ'ka' nak nad' txen jayellgake' ba ziyaa kwit X̱a'na', beena' ḻekzka' nak X̱ale. Lljazoalen' Chios c̱ha'na', beena' ḻekzka' nak Chios c̱hele. ");
INSERT INTO zadNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Na'ch biza' María, beṉ' yell Magdálana', jayelle' beṉ'ka' nak Jesúza' txen nan ba ble'ile' X̱ancho Jesúza'. Na' golle' ḻegake' diika' goll Jesúza' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na' ka goḻ lo llana' bibane', lla nech c̱he xmanna', ba ndop nllag beṉ'ka' nak Jesúza' txen na' nsejtegake' yoona' daa chllebgake' beṉ'ka' chṉabia' beṉ' Israelka', ka gokbe'gakile' ba ze Jesúza' ladje'ka', na' chi'e ḻegake': ―Soashgale mbalaz. ");
INSERT INTO zadNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Na' ka biyoll golle' ḻegake' ka', na'ch bliile' ḻegake' c̱hop ḻaate neena' na' kwit ḻi'ena'. Na' beṉ'ka' nakgake'ne' txen ḻe bibagakile' ble'gakile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Na'ch wize' Jesúza' ḻegake': ―Soashgale mbalaz. Ka bseḻ' X̱a'na' nad' kwenc̱he zidsoa' yell-lioni, ka'kzan chseḻaa le' llje'le cho'a xtillaana' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Na' ka wde golle' ḻegake' ka', na'ch blobe' ḻegake', na' chi'e: ―Ḻi ikaa Espíritu Sántona'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Na' beṉ'ka' yizi'xenle saaxya c̱he'ka', wiyakxenan. Na' beṉ'ka' bi yizi'xenle c̱heyin, bi yiyakxen c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomáza', beena' che'gake' Dídimo nake' txen beṉ'ka' shlliṉ, na' bi lene' ka jali'lao Jesúza' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Na' che'gake'ne': ―Ba ble'into' X̱anchona'. Na' Tomáza' chi'e ḻegake': ―Shi bi ile'id' neena' na' wde xben'ni gana' wde klabka', na' wde na'ni kwit ḻi'ena', aga wyajḻi'a. ");
INSERT INTO zadNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Na' ka wde x̱on' lla, dii yoblə bidop beṉ'ka' nongake' Jesúza' txen ḻoo yoona' na' len Tomáza'. Na' ḻa'kzi nsejtegake' yoona', wyoo Jesúza' jsie' ladje'ka'. Na' chi'e ḻegake': ―Soashgale mbalaz. ");
INSERT INTO zadNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Na'ch chi'e Tomáza': ―Bwia na'ni, na' bṉe'n xbeno'na'; na' bṉe' noona' kwit ḻi'ani. Bi gakc̱hoplalloo, san wyajḻe'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Na'ch che' Tomáza'ne': ―¡Lin' nako' X̱an' na' naktio' Chios c̱ha'! ");
INSERT INTO zadNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Na' che' Jesúza'ne': ―Galj ble'ilo' nad' na'ch chajḻi'o. Chakomba beṉ'ka' chajḻe'gake' ḻa'kzi biṉ' ile'gakile' nad'. ");
INSERT INTO zadNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Zan yeḻ' wak daa ben Jesúza' lao beṉ'ka' nakgake'ne' txen bi nyojgakan ḻee libri. ");
INSERT INTO zadNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Per diiki nyojgakan kwenc̱he shajḻe'le Jesúza' nake' Xiiṉ Chioza' na' ḻen' Crístona', beena' wleje' iṉabi'e, na' daa gonḻilall'lene' gat' yeḻ' mban c̱hele dii bi te c̱heyin. ");
INSERT INTO zadNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ka wde, Jesúza' jali'lawe' sto shii beṉ'ka' nakgake'ne' txen cho'a Nisdo' c̱he Galileana' daa ḻekzka' le Nisdo' c̱he Tiberias. Na' ki gok: ");
INSERT INTO zadNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pédrona' len Tomáza', beena' nsi'gake' Dídimo, na' Natanaela', beṉ' yell Canána' daa llia gana' mbani Galileana', na' c̱hopte xiiṉ Zebedewa' na' zi c̱hop beṉ'ka' nongake' Jesúza' txen lle'gake' Galileana'. ");
INSERT INTO zadNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Na' Simón Pédrona' chi'e ḻegake': ―Sha'ch' lljx̱en' beḻa'. Na' ḻegake' gollgake'ne': ―Ḻekzka' wza'lennto' li'. Na'ch wyoogake' to ḻoo barkw zejgake' wxen beḻa', na' ni tlish' kono wxengake' do yel. ");
INSERT INTO zadNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na' cheeni'ḻesdo' bllin Jesúza' cho'a nisdo'na', na' beṉ'ka' nakgake'ne' txen aga chakbe'gakile' shi ḻen'. ");
INSERT INTO zadNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Na'ch Jesúza' wṉie' ḻegake', chi'e: ―Le' beṉ' bish'dawaa, ¿abiṉ' senle beḻa' gaocho? Na' che'gake'ne': ―Aga no de. ");
INSERT INTO zadNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Na'ch che' Jesúza' ḻegake': ―Ḻi wzaḻ' yix̱j c̱helena' shḻaa de shḻi c̱he barkwa' na' idoḻ'gakb. Na' bengake' ka golle', na' ka nan yigoyogake' yix̱ja' ḻoo nisa' aga chizogakile'n daa nyichachgan beḻka'. ");
INSERT INTO zadNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Na' beena' ḻe chaki Jesúza'ne', golle' Pédrona': ―¡X̱anchonan'! Na' kon ka beni Pédrona' golle'ne' ka', lii biyakwte xe'na', na' bxitee ḻoo nisa'. ");
INSERT INTO zadNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Na' beṉ'ka' sto biyajlengake' barkwa' cho'a nisdo'na'lə, zingoyon yix̱ja' daa zinyichachga beḻka', ḻa' aga nakchan zit', ka sto guiyoa metrzan. ");
INSERT INTO zadNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Na' ka bichejgake' ḻoo barkwa', ble'gakile' ba chi' yi'na' xṉa na' xoa to beḻ lawinna', na' dete yetxtil. ");
INSERT INTO zadNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Na' che' Jesúza' ḻegake': ―Ḻi yiyox̱'to beḻka' zi' wxenle. ");
INSERT INTO zadNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Na'ch wyoo Simón Pédrona' ḻoo barkwa' kwenc̱he jaselle' yix̱j beḻa' na' bigoyoe'n ax̱t cho'a nisdo'na'. Na' ḻa'kzi tolla'cha nak yix̱ja' daa ziyoon to guiyoa shiiṉiyon beḻ yeḻka', bi bcheza'n. ");
INSERT INTO zadNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Na'ch che' Jesúza' ḻegake': ―Ḻi da gaole xsila'. Na' ni to beṉ'ka' nakgake'ne' txen bi biyaxjgakile' ye'gake'ne': “¿Nora li'?” Ḻa' gokbe'gakile' X̱ancho Jesúza'kzan'. ");
INSERT INTO zadNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Na'ch wbig' Jesúza' na' bex̱ee yetxtila' len beḻa' na' bi'e c̱he c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na' dga gok de wyoṉ shii jali'lao Jesúza' beṉ'ka' nakgake'ne' txen ka wde bibane' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Na' ka bidaogake' xsila', na'ch che' Jesúza' Simón Pédrona': ―Simón, xiiṉ Jonás, ¿achakchilo' nad' aga ka to chaki beṉ'ki nad'? Na' Pédrona' chi'ene': ―X̱an', ṉezkzilo' chakid' li'. Na'ch che' Jesúza'ne': ―Na'len wdap bwia beṉ'ka' chonḻilall'gake' nad', beṉ'ka' nak ka xil'do' c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Na' de wchop shii wizṉabile'ne', chi'ene': ―Simón, xiiṉ Jonás, ¿achakilo' nad'? Na' Pédrona' chi'ene': ―X̱an', ṉezkzilo' chakid' li'. Na'ch che' Jesúza'ne': ―Na'len wdap bwia beṉ'ka' chonḻilall'gake' nad', beṉ'ka' nak ka xil' c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Na' de wyoṉ shii wizṉabile'ne', chi'ene': ―Simón, xiiṉ Jonás, ¿ana' chakilo' nad'? Na' gokyeshii Pédrona' daa ba gok shoṉ shii chṉab Jesúza' shi chakile'ne', na' chi'ene': ―X̱an', ṉez nḻe'ilo' yog'ḻoḻte, na' ṉezkzilo' chakid' li'. Na'ch che' Jesúza'ne': ―Na'len wdap bwia beṉ'ka' chonḻilall'gake' nad', beṉ'ka' nak ka xil'do' c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Dii ḻi nia' li', ka goko' beṉ' wew', gokw xalaano' to kwinzo' na' wyajo' kon ga wnan c̱ho'. Per kat' ba gox̱oo, wḻi nooka' na' yiwakw beṉ' yoblə xalaano'na', na' wc̱hi'e li' ga bi cheenilo' shajo'. ");
INSERT INTO zadNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Na' daa goll Jesúza'ne' ka', bzajniile' ḻegake' ka guet Pédrona', na' daa guete' ka' sho' Chioza' balaaṉ. Na' ka wde golle' Pédrona' ka', chi'ene': ―Btiplalloo benḻilall' nad' toshiizi. ");
INSERT INTO zadNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Na' biyec̱hj Pédrona' na' ble'ile' beena' sto, beena' ḻe chaki Jesúza'ne', noe' ḻegake'. Ḻen' wchi'e kwit Jesúza' kana' zeelo wdaogake' xshe'na' kana' wṉabile'ne', chi'ene': “X̱an', ¿norakznton' gon li' lo na' beṉ' malka'?” ");
INSERT INTO zadNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Na' ka ble'i Pédrona'ne', na'ch chi'e Jesúza': ―X̱an', ¿shera beeni? ");
INSERT INTO zadNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Na' che' Jesúza'ne': ―Shi cheenid', ni mbankz beeni kat' yiyed'. Bi sio' beena' wṉeyi. Lin' btiplalloo benḻilall' nad' toshiizi. ");
INSERT INTO zadNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Na' daa golle' ka', wze dill' ladj beṉ'ka' chonḻilall' Jesúza' nan aga wet beena'. Per bi goll Jesúza' Pédrona' bi guet beena', san chi'ene': “Shi cheenid', ni mbankze' kat' yiyed'. Bi sio' beena' wṉeyi.” ");
INSERT INTO zadNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Na' beena' nake' Jesúza' txen, beena' ḻe chakile', cho'e dill' kon ka gokə na' bzeje'n ḻee libri. Na' ṉezinto' dillaa cho'e nakan dii ḻi. ");
INSERT INTO zadNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Dii zanch dii ben Jesúza' na' bi nyojan. Sheḻ' nyoj yog' diika' bene', chakid' bi gaki yell-lioni ikwa' librka' sheḻ'ka'.");
INSERT INTO zadNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, ḻee libr necha' bzej', na' bzej' yog' dii wenka' ben Jesúza' na' diika' bli' bsedile' dezd ka wzoloe' ");
INSERT INTO zadNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ax̱t ka bllin lla biyepe' yabana'. Na' ka zi' yizee, bzajniile' postlka' wleje' daa goll Espíritu Sántona'ne' kwenc̱he gongake' llinna' daa bene' lall' na'gake'. ");
INSERT INTO zadNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Na' ka wde wite' na' bibane' ladj beṉ' wetka', jali'lawe' ḻegake' na' dii zan dii bene' kwenc̱he iṉezgakile' nan mbankzen'. Na' lo c̱hoa lla jali'lawe' ḻegake', na' bzajniile' ḻegake' c̱he yeḻ' wṉabia' c̱he Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na' shlak wzoalen Jesúza' postlka', golle' ḻegake': ―Bi illeshle Jerusalénni. Ḻi kwez gak ka bc̱heb X̱acho Chioza' gone', kon ka ba wniakz'. ");
INSERT INTO zadNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Dii ḻi Juanna' bchoe' beṉ' nisa', per le', aga chllach yidsoa Espíritu Sántona' ḻoo yic̱hjlall'do'lena'. ");
INSERT INTO zadNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Na' beṉ'ka' ndop nllag kwit Jesúza', wṉabgakile'ne': ―X̱an', ¿awibejo' cho' beṉ' Israel lo ṉi'a na' beṉ' zit'ka' ṉaa kwenc̱he iṉabi'o neto'? ");
INSERT INTO zadNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Na' Jesúza' golle' ḻegake': ―Bi chidoḻ'le iṉezile bi lla bi gor gon X̱acho Chioza' daa gone', ḻa' toze' ḻen' chṉabi'e na' ba bllie' bia' batan gone'n. ");
INSERT INTO zadNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Na' ka yidsoa Espíritu Sántona' ḻoo yic̱hjlall'do'lena' na' goṉe' le' yeḻ' wak, na' we'le xtillaana' yell Jerusalénna', na' doxen gani mbani Judeani na' ḻekzka' gana' mbani Samáriana', na' doxen zbii zkaaṉ yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Na' ka biyoll golle' ka', wzolo biyepe' yabana' chwiate beṉ'ka', na' wze to bej bkwashaan ḻe' na' bich ble'gakile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Na' ka lle'gake' chwiagake' yabana' gana' biyep Jesúza', lii bllinte c̱hop anjl kwite'ka', na' zoagake' do xtil. ");
INSERT INTO zadNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Na' gollgake': ―Le' beṉ' Galilea, ¿berac̱he chwiazle yabana'? Kwin Jesúza', beena' ble'ile bichej ladjleni na' biyepe' yabana', kakzan ile'ilene' yiyede'. ");
INSERT INTO zadNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Na'ch biyetjgake' lo Yaa Olívoza' ziyajgake' Jerusalénna'. Nakan gaozə, ka to daa nllia ley c̱he'ka' bia' koogake' nez llana' chombaaṉgake'. ");
INSERT INTO zadNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Na' ka billingake' Jerusalénna', biyepgake' yoona' llia shkwiana' cha'lə gana' zoagake'. Na' beṉ'kin billin: Pédrona', Jacóbona', Juanna', Andréza', Felípena', Tomáza', Bartoloména', Matewa', Jacóbona' xiiṉ Alfewa', Simón, beena' che'gake' Zelote, na' Judas beṉ' bish' Jacóbona'. ");
INSERT INTO zadNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yog' beṉ'ki chdopgake' yog' lla kon beṉ'ka' nak beṉ' bish' Jesúza' kwenc̱he choe'ḻwillgake' Chioza', na' len Maríana' xṉa Jesúza' na' zi' baḻ noolka'. ");
INSERT INTO zadNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Na' llaka' wzoagake' na', Pédrona' wzie' ladj beṉ'ka' chonḻilall'gake' Jesucrístona', nakgake' ka do to guiyoa gaḻjə, na' golle' ḻegake': ");
INSERT INTO zadNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Le' beṉ' bish', benan byen billinin ka goll Espíritu Sántona' dii Davina' na' bzeje'n ḻee Cho'a Xtill' Chioza'. Bi'e dill' nakan gon Juda', beena' bc̱hi'e beṉ'ka' bex̱'gake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Juda' goke' neto' txen naknto' postl, na' lenen' nan gone' neto' txen dga ngoo lo na'nto' chonnto'. ");
INSERT INTO zadNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Na' mecha' daa bex̱ee c̱he dii mala' daa bene', ḻennan' biziile' to yell-lio gana' bxope' de gozyic̱hjlə na' goshj ḻi'ena' na' bchej yog' xjloe'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Na' ka wṉezi beṉ' Jerusalénka' ka gok c̱he Juda', na' bsi'gake' yell-liona' daa bizi'e Acéldama de xtill'gake', na' zejin Yell-lio Chen. ");
INSERT INTO zadNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ḻa' ḻee libr c̱he Sálmoka' nan: Yidesh yiloashga lill xḻatje'na', na' ni sto kochno soan. Na' ḻekzka' nan: Beṉ' yoblə yiyakshga lo nee daa nan gok lo nee gone'. ");
INSERT INTO zadNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Na' chonan byen kwejcho to beṉ'ki bengake' cho' txen toshiizi kana' wzoalen X̱ancho Jesúza' cho', ");
INSERT INTO zadNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","beṉ'ki nakgake' cho' txen dezd ka bchoa Juanna' Jesúza' nisa' ax̱t ka biyepe' yabana', kwenc̱he gone' cho' txen we'cho dill' nakan gok biban Jesúza' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Na'ch wlejgake' c̱hope': toe' le Matías, na' sto beṉ' yoo shoṉə leyin, José, Barsabás, na'ch Justo. ");
INSERT INTO zadNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Na' be'ḻwillgake' Chioza', che'gake': ―Chios, beṉ' nak X̱annto', li' nombi'o yic̱hjlall'do' yog' beṉ'. Bliyi neto' no beṉ'ki c̱hop ba wlejo' ");
INSERT INTO zadNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kwenc̱he gake' neto' txen naknto' postl, ḻa' Juda' ba bṉite' daa ndoḻee yeḻ' wen dii mal c̱he'na' na' ziyaje' latja' gana' chidoḻee. ");
INSERT INTO zadNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Na'ch bengake' to wyitj kwenc̱he wṉezgakile' noran ba wlej Chioza', na' bidoḻ' Matíaza', na' wlene' postlka' shnej. ");
INSERT INTO zadNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na' ka bllin lla goḻ' lṉi Pentecostéza', yog' beṉ'ka' chonḻilall'gake' Jesúza' tozga ndop nllaggake'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Na' tokonganzi bengakile' to sshag ka ga za' to be' wal, za'n yabalə na' wṉiṉ doxen ḻoo yoona' gana' lle'gake'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Na'ch ble'gakile' dii nak ka beḻ yi' chaḻ'ṉiṉan, na' yog'ze' zen yic̱hje'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Na' Espíritu Santo c̱he Chioza' wyo'e ḻoo yic̱hjlall'do' to toe', na' wzologake' wṉegake' wde wdeli dill', kon ka goklall' Espíritu Sántona' iṉe to toe'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na' lo llana' beṉ' zan beṉ' Israelka' lle' Jerusalénna' choe'la'ogake' Chioza', no beṉ' zaak wde wdeli yell dii lle' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Na' ka bengakile' sshaga' daa chak, na' bdop bllaggake' gana' chak ka'. Na' gokllej gokgaṉgakile' ka biyombia'gake' xtilleeka' daa chṉe beṉ'ka' lle' na'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Na' ḻe chibangakile', na' che' ljwelle': ―¿Aaga beṉ' Galilea yog' beṉ'ki choe' dill'ki? ");
INSERT INTO zadNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Nakra chak chakzgake' dill'ka' chṉe to tocho, lla? ");
INSERT INTO zadNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ḻa' ni zoa beṉ' Partia, beṉ' Media, beṉ' Elam, beṉ' Mesopotamia, beṉ' Judea, beṉ' Capadocia, beṉ' Ponto, beṉ' Asia, ");
INSERT INTO zadNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","beṉ' Frigia na' Panfilia, beṉ' Egipto na' zi baḻe' beṉ' África, beṉ' zaak gaozə yell Cirénena', na' ḻekzka' len beṉ' za' Rómana'te. Baḻcho nakcho beṉ' Israel, na' zi baḻcho choncho beṉ' Israelki txen. ");
INSERT INTO zadNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Na' ḻekzka' zoa beṉ' Creta na' beṉ' Arabia. Na' yog'techo chenicho chṉe beṉ'ki xtill' to tocho, choe'gake' dill' c̱he dii wenka' ba ben Chioza', diika' chonan ka yibanicho. ");
INSERT INTO zadNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na' yog' beṉ'ka' bdop bllag na', bibangakile' na' gokllej gokgaṉgakile'. Na' che' ljwellgake': ―¿Bi zejin dga, lla? ");
INSERT INTO zadNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Na' baḻe' wṉeḻegakile' ḻegake', nagake': ―Zolli beṉ'kin. ");
INSERT INTO zadNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Na'ch Pédrona' wzechaile' len postlka' zi shnej, na' wṉie' zillj chi'e beṉ'ka' ndop nllag na': ―Le' beṉ' Israel na' yog'le le' zoale Jerusalénni, cheenid' wzajniid' le' bi zeji dga chak, ḻi wzenagyeṉ' dga iṉia' le'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Beṉ'ki nak' txen aga zollgakilen' ka chza'lall'zle, ḻa' shzilgaz ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Dga chak ki ṉaa, chillinin daa wna dii Joela', beena' bzej daa goll Chioza'ne' kani'yi, na' wne': ");
INSERT INTO zadNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Kat' ba zoa illin lla te c̱he yell-lioni, nad' Chios wi'a Espíritu c̱ha'na' soe' ḻoo yic̱hjlall'do' beṉ'ka' lle' zbii zkaaṉ yell-lioni. Na' gon' kwenc̱he xiiṉleka', ka bi' byo na' ka bi' noolə, c̱hix̱je'gakb' daa yep'gakb'. Na' bi' wew'ka' ile'do'gakib', na' beṉ' golka' iṉegakile' yel. ");
INSERT INTO zadNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Na' ka'kzə wi'a Espíritu c̱ha'na' yog' beṉ'ka' choe'la'ogake' nad' llana' gak ka', ka beṉ' byo ka noolə, na' we'gake' dill'ka' wx̱oa' cho'a ḻolleeka'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Na' xan yabana' wli'a dii gonan ka yibani beṉ', na' ka'kzə lo yell-lioni wli'gakidee chen, na' yi', na' llen. ");
INSERT INTO zadNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wbilla' bich wzeeni'n, na' bewaa yiyakan xṉa ka chen ka zi' illin lla choo lla xen c̱he X̱anchona'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na' nottez beṉ' iṉabile' X̱ancho Chioza' gaklene'ne', na' yisle'ne' kwenc̱he bi kwiayee. ");
INSERT INTO zadNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Na' le' nakle beṉ' Israel, ḻi wzenag dga iṉia' le'. Ṉezkzile Chioza' wleje' Jesús, beṉ' Nazareta', daa bi'ene' yeḻ' wṉabia'na' kwenc̱he bidyene' ladjleni dii zan yeḻ' wak choo yeḻ' wak xen na' bichlə dii benan ka bibani beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Na' beeni goke' lall' na'le kon ka bllia Chioza' bia' gak c̱he', na' béx̱'lene' bénlene' lo na' beṉ' malka' kwenc̱he betgake'ne' ḻee yag cruza'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Per Chioza' bisbane'ne' ladj beṉ' wetka', na' bi bi'e latj guete' toshiizi, daa bi gok iṉabia' yeḻ' wita' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dii Davina' bi'e dill' c̱he Jesúza' kani'yi, ka wne': Chle'id' X̱an'na' toshiizi. Na' daa zoe' kwitii shḻaa de shḻini kono gak bi goni nad'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Daan ḻe chibayi lall'dawaani na' cho'a dill' ka mbalaz zoa'. Na' beli chen c̱ha'ni nonan lez yibanan, ");
INSERT INTO zadNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ḻa' aga wsanlalloo nad' toshiizi ladj beṉ' wetka', ni bi wi'o latj gooll' iteb beli chen c̱ha'ni daa nak' lall' no'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ba bliilo' nad' nakan nak neza' sho'a kwenc̱he gat'ch yeḻ' mban c̱ha', na' yiba yizakid' daa soalen' li' toshiizi. ");
INSERT INTO zadNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Le' beṉ' bish', ṉezkzicho dii x̱ozxto'cho Davina' wite' na' bkwash'gake'ne', na' ni nakbia'te ṉaa gana' bkwash'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Na' dii Davina' bi'e dill' diika' goll Chioza' ḻe', na' wṉezile' kwin Chioza' bc̱hebe' wzoe' to xiiṉ dia' c̱he' iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Chioza' bliile' dii Davina' diika' zi' gak c̱he Crístona', na' bi'e dill' yibane' ladj beṉ' wetka' ka wne' aga wigaaṉe' ladj beṉ' wetka' na' ni bi gooll' iteb beli chen c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Na' ka' gok, Chioza' bisbane' Jesúza' ladj beṉ' wetka', na' yog'nto' ble'into'ne' na' choe'nto' dill' bibane'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Na' ka biyoll bigoyoe'ne' yabana' na' wlekwe'ne' kwite' de shḻina', bene' lo nee bseḻee Espíritu Sántona' ladjnto'ni ka bc̱hebe'. Na' Espíritu Sántona' ba bene' yog' dga ba ben ble'ile ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Bi gakile dii Davinan' biyepe' yabana', ḻa' kwine', wne': X̱ancho Chioza' golle' X̱an'na': “Wche' kwit' de shḻi ni ");
INSERT INTO zadNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","shlak wzoa' xṉi'ona' beṉ'ka' chakzbani li'.” ");
INSERT INTO zadNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Na' nia' le', yog'cho cho' beṉ' Israel chiyaḻ' iṉezicho, Jesúza', beena' betle ḻee yag cruza', Chioza' bzoe'ne' nake' X̱ancho, na' ḻen' Crístona', beena' wlej Chioza' iṉabi'e cho'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na' beṉ'ka' lle' na' ka bengakile' goll Pédrona' ḻegake' ka', ḻe nyesh'chga gokgakile', na' wṉabgakile' Pédrona' na' postlka' sto, che'gake': ―Le' beṉ' bish', ¿beran chiyaḻ' gonnto' shka'? ");
INSERT INTO zadNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Na'ch Pédrona' chi'e ḻegake': ―To tole, ḻi yiyaj yileni na' ḻi c̱hoa nisa' shi ba chonḻilall'le Jesucrístona', na' yiyakxen xtoḻ'leka' na' yidsoa Espíritu Sántona' ḻoo yic̱hjlall'do'lena'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Chioza' ba bc̱hebe' goṉe' le Espíritu c̱he'na', na' len xiiṉleka', na' nottez beṉ' zit'. Ḻa' nc̱hebe' wi'ene' yog' beṉ' gaxe' kwenc̱he gonḻilall'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Na' dii zanch dill' be'len Pédrona' ḻegake', got'yoile' ḻegake', chi'e: ―Ḻi yisla kwinle lao yel' zi'na' daa ile'i beṉ' wen dii malka' bi chajḻe' c̱he Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Na' beṉ'ka' wyajḻe' daa goll Pédrona' wchoagake' nisa'; na' lo llana' shoṉa mil beṉ'ka' wlengake' beṉ'ka' nonḻilall' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Na' yog'gake' wzegake' wṉeyi bengake' diika' bli' bsedi postlka' ḻegake', na' xochi wzoagake'. Na' bdop bllaggake' be'ḻwillgake' Chioza' na' weej wdaogake' txen. ");
INSERT INTO zadNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na' yog'ze' bibani daa ble'gakile' yeḻ' wak zanka' ben postlka'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Na' yog' beṉ'ka' chonḻilall'gake' Jesúza' gokgake' toz, na' choe' ljwelle' bi ka dii chyallji to toe'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Na' biyit' bidegake' no yell-lio, no yoo c̱hegake' wa bichlə dii napgake' na' choe' ljwellgake' ka to dii chyallji to toe'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na' yog' lla bdopgake' lesh' chyoodo'na' choe'ḻwillgake' Chioza', na' ḻekzka' bibagakile' weej wdaogake' txen lill ljwellgake'. ");
INSERT INTO zadNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Na' wzoatezi wzoagake' be'la'ogake' Chioza' na' yog'zə beṉ' gokbe'gakile' ka mba chongake'. Na' yog' lla, X̱ancho Chioza' bene' ka wyanch beṉ'ka' benḻilall' Jesucrístona'. ");
INSERT INTO zadNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","To lla do ka chida shoṉə shlle'na', ka gora' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza', Pédrona' len Juanna' wyajgake' yoodo'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na' cho'a puert c̱he zeena' daa nec̱hj yoodo'na', puert daa nsi'gake' Puert Xochi, chi' to beṉ' nxiṉj ṉi'ena' ka goljtie'. Na' yog' lla chjḻekgake'ne' na' kwenc̱he chṉabe' karidá lao beṉ'ka' chdop chllag yoodo'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Na' ka bllin Pédrona' na' Juanna' gana' chi'e, na' wṉabile' ḻegake' izangakile' lat' mech we'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Na'ch Pédrona' len Juanna' bwiagake'ne', na' Pédrona' golle'ne': ―Bwiakachi neto'. ");
INSERT INTO zadNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Na' beena' bwie' ḻegake', gokile' mechan' we'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Na' Pédrona' chi'ene': ―Bibi mech nap' goṉ' li', ḻete dii nap' goṉ' li'. Kon yeḻ' wak c̱he Jesucristo, beṉ' Nazareta', nia' li' bizolla' na' bigoo nez. ");
INSERT INTO zadNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Na'ch Pédrona' wdoyoe' nee de shḻina' na' bisolléene', na' lii biyakteyi ṉi'ena'. ");
INSERT INTO zadNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Na'ch ka beṉ' bxit'zə bene' bizollee. Na' wyoolene' ḻegake' lesh' chyoodo'na' chec̱hj chde' na' chxit'sheshe' choe'lawee Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Na' yog' beṉ'ka' lle' na' ble'gakile'ne' chde' choe'lawee Chioza', ");
INSERT INTO zadNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","na' billej bibangakile' daa nombia'gake'ne' chbi'e chṉabe' karidá cho'a puert daa nsi'gake' Puert Xochi. ");
INSERT INTO zadNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na' beena' biyaki ṉi'ena' aga bsane' Pédrona' len Juanna', kon noe' ḻegake'. Na' yog' beṉ'ka' lle' lesh' chyoodo'na' chillej chibangakile' na' wyajdogake' gana' zoa koridor daa le Koridor C̱he dii Salomón gana' zelengake' beena' biyaki. ");
INSERT INTO zadNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Na' ka ble'i Pédrona' beṉ'ka' chdop chllag na', golle' ḻegake': ―Le' beṉ' Israel, ¿berac̱he chibanzile daa biyaki beeni? ¿Na' berac̱he chwiazle neto'? ¿Achakile kon yeḻ' wak c̱hento'nan' biyaki beeni? ¿Awa chakile daa zoanto' chonnto' ka chiyoolallii Chiozan' biyakile'? Aga daan. ");
INSERT INTO zadNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Chios, beena' be'la'o dii Abrahama', dii Isaaca', dii Jacoba', na' nochlə dii x̱ozto'choka', ḻen' wlo'e Xiiṉe' Jesúza' balaaṉ xenna', beena' benle lo na' beṉ'ka' betgake'ne'. Na' ka goklall' Pilátona' yisane'ne', bi be'le latj. ");
INSERT INTO zadNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Lwaa dii nan iṉable yisane' Jesúza', beena' nak ḻiizelozi beṉ' ḻi beṉ' shao', beṉ' wen xyana'lə wṉable bisane'. ");
INSERT INTO zadNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kan' benle betle Jesúza', beena' choṉ yeḻ' mban daa nak dowalj. Per Chioza' bisbane'ne' ladj beṉ' wetka', na' neto' choe'nto' dill' daa ṉezinto' bibane'. ");
INSERT INTO zadNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Daa chonḻilall'nto' Jesúzan', ba biyaki beeni chwiale na' nombia'le. Dii ḻi, daa nonḻilall'nto' Jesúzan' chwiatele ba biyakchaile'. ");
INSERT INTO zadNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Le' beṉ' bish', ṉezid', ka le' na' ka beṉ'ka' chṉabia' le', bi gokbe'ile bin benle ka betle Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Na' Chioza' bi'e latj gok ka' kwenc̱he billinin ka wna dii beṉ'ka' wdix̱jee xtilleena' kani'yi, daa wnagake' Crístona' biya dii wc̱hi' wsak' beṉ' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Na' ṉaa, ḻi wzenag c̱he X̱ancho Chioza', na' ḻi yiyaj yileni dii malka' chonle kwenc̱he yizi'xene' c̱hele na' wzoe' le' mbalaz. ");
INSERT INTO zadNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Na' yiseḻee Crístona', beena' wleje' kwenc̱he iṉabi'e, kon ka wdix̱jee dii beṉ'ka' kani'yi. ");
INSERT INTO zadNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Chonan byen yigaaṉe' yabana' ax̱t ka illin lla yiyonshao' Chioza' yog'ḻoḻte dii de, kon ka goll Chioza' dii beṉ'ka' wleje' wdix̱je'gake' cho'a xtilleena' kani'yi. ");
INSERT INTO zadNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ḻa' dii Moiséza' golle' dii x̱ozxto'choka' dill'ki: “X̱ancho Chioza' kweje' sto beṉ' ka nad' ladjleni, beṉ' c̱hix̱je'ile' le' bi dill' we'lene'ne'. Na' ḻi wzenag yog' daa iṉe'. ");
INSERT INTO zadNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Na' beena' bi wzenag c̱he', Chioza' kwej yic̱hje'ne' na' bich gak gone' txen beṉ'ka' nak yell c̱he Chioza'.” ");
INSERT INTO zadNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Na' yog'ḻoḻ dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yi, wzolozan kon dii Samuela', wdix̱je'gake' gak diiki chak ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Len', naki c̱hele daa ba bc̱heb Chioza' lao dii beṉ'ka' wdix̱jee daa golle' ḻegake' kani'yi. Na' ḻekzka' naki c̱hele dii wenna' daa bc̱heb Chioza' gone' c̱he dii x̱ozxto'cho Abrahama', ka golle'ne': “Ni c̱he xiiṉ dia c̱ho'na' gon' dii wen c̱he yog'ḻoḻ beṉ' lle' zbii zkaaṉ yell-lioni.” ");
INSERT INTO zadNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Na' ka bseḻ' Chioza' Xiiṉe' Jesúza', zigaate bseḻeene' ladjchoni kwenc̱he gak wen c̱hecho na' to tocho yiyaj yilenicho dii malka' choncho. ");
INSERT INTO zadNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Na' ni choe'lente Pédrona' len Juanna' beṉ'ka' dill' ka bllin bx̱ozka' len beena' ngoo lo nee beṉ'ka' chap yoodo'na' na' len zi baḻ saduceoka'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ḻe chllaagake' daa chli' chsedi Pédrona' len Juanna' beṉ'ka' lle' na' nakan gok biban Jesúza' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Na'ch bex̱'gake' ḻegake', na' daa ba wlle', jḻoogake' ḻegake' lillyana', ax̱t betiyoch bibejgake' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Per beṉ' zan beṉ'ka' bzenaggake' dillaa be' Pédrona' len Juanna' benḻilall'gake' Jesúza'. Na' ka', wyanch beṉ'ka' benḻilall'gake'ne', na' gokgake' ka do gayaa mil to beṉ' byoka'zə. ");
INSERT INTO zadNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na' betiyo bidop billag beṉ'ka' chṉabia' beṉ' Israelka' yell Jerusalénna', len beṉ' golka' chṉabia', na' beṉ'ka' chli' chsedi leya'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Na' ḻekzka' len Anáza', beena' nak bx̱oz choo bx̱oz xen, na' Caifáza', Juanna', Alejándrona', na' nokchlə beṉ'ka' nak dialla c̱he bx̱oz choo bx̱oz xenna'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Na'ch bzegake' Pédrona' len Juanna' gchoḻe'ka', na' wṉabgakile' ḻegake': ―¿No lsens c̱heyi na' no bseḻ' le' chonle diiki? ");
INSERT INTO zadNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Na' Espíritu Santo c̱he Chioza' bzajniile' Pédrona' kwenc̱he golle' ḻegake' ki: ―Le' beṉ' wṉabia', na' le' beṉ' gol chṉabia'le yell Israeli, ");
INSERT INTO zadNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","chṉabile neto' ka nak dii wenna' gok c̱he beeni, na' cheenile iṉezile nakan gok biyakile'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Cheeninto' yog'ḻoḻ-le iṉezile na' yog'ḻoḻ beṉ' Israelka' iṉezgakile', beeni chwiale ze laoleni biyakile' kon yeḻ' wak c̱he Jesucristo, beṉ' Nazareta', beena' betle ḻee yag cruza', per Chioza' bisbane'ne' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","C̱he Jesúzan' choe'n dill' daa nan “yaja' daa bi wyoolall'le le' nakle wen yoo, ḻeyeṉ'lannan' yaja' daa ba nc̱hejcha yoona'.” ");
INSERT INTO zadNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Bichga zoa sto beṉ' yoblə gak yisle' cho' kwenc̱he bi kwiayi'cho. Ḻa' kochno zoa doxen yell-lioni beṉ' ba wlej Chioza' kwenc̱he yisle' cho'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ḻe bibani beṉ' wṉabia'ka' daa chwiagake' bi blleb Pédrona' len Juanna' choe'gake' dillaa lawe'ka', ḻa' nakbia' aga bi nsedgake' na' aga no nakgake'. Na' gokbe'gakile' daa wdalengake' Jesúza' txenan chongake' ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Na' daa ze beena' biyaki ṉi'ena' kwite'ka', bibi gok ye'gake' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Na'ch bibejgake' ḻegake' shlak be'len ljwellgake' dill' nak koogake' xṉezin. ");
INSERT INTO zadNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Che' ljwelle': ―¿Nakra goncho c̱he beṉ'ki? Ḻa' yog'zə beṉ' zoa Jerusalénni iṉezgakile' ba bengake' to yeḻ' wak xen, na' aga wak iṉacho bi nakan ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Na' kwenc̱he bich ides dill'ka' choe'gake', chiyaḻ' kooshebchogake' kwenc̱he kochno we'lengake' dill' c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Na'ch goxgake' Pédrona' len Juanna' dii yoblə, na' gollgake' ḻegake' bich wli' wsedgakile' beṉ' ni bi we'lengake' ḻegake' xtill' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Na' Pédrona' len Juanna' che'gake': ―Ḻi wwiayeṉ'shki shi nakan wen lao Chioza' wzenagnto' c̱hele lwaa dii wzenagnto' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Bi gak wsannto' we'nto' dill' daa ben ble'into' c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Na'ch beṉ' wṉabia'ka' biya dii gollgake' ḻegake' kwenc̱he nan illebgake', na'ch bisanchokləgake' ḻegake', ḻa' bibi billel-lall'gake' gongake' daa yog'zə beṉ' choe'la'ogake' Chioza' ni c̱he daa gok. ");
INSERT INTO zadNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Na' beena' biyaki ṉi'ena' kon yeḻ' wak c̱he Jesúza' ba wdeile' c̱hoa yiz. ");
INSERT INTO zadNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Na' ka bisangake' Pédrona' len Juanna', biyajgake' gana' zoa beṉ'ka' nonlengake' txen na' gollgake' ḻegake' yog' daa goll bx̱ozka' chṉabia' na' beṉ' golka' chṉabia'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Na' ka bengakile' daa gollgake' ḻegake', na'ch gokgake' toz be'ḻwillgake' Chioza', che'gake': ―Chios, li' nako' beṉ' zeelo chṉabia'. Li' beno' yabana', yell-lioni, na' nisdo'na', na' yog'te dii de lo yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Na' Espíritu Santo c̱ho'na' bx̱oe' dill'ki cho'a ḻoll' dii Davina' kana' wne': ¿Berac̱he chllaa chlokz beṉ' yell-lioki? ¿Berac̱he toshiizi chgoo beṉ'ki xṉezin gongake' daa bi nxe bi nzak'? ");
INSERT INTO zadNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Beṉ'ka' chṉabia' lo yell-lioni gokgake' toz gokzbangakile' na' biṉiatezgake' X̱ancho Chioza' len Crístona', beena' wleje' kwenc̱he iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Dii ḻi yell Jerusalénni Heródeza' na' Poncio Pilátona', len beṉ' zit'ka' na' beṉ' Israelka', bdop bllaggake' gokgake' toz goklall'gake' wlliayi'gake' Jesúza', beena' nak ḻiizelozi beṉ' ḻi beṉ' shao', beena' wlejo' kwenc̱he iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Na' daa bengake' ka', gok ka bllio' bia'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na' ṉaa Chios, bwia ka ngoosheb beṉ' wṉabia'ka' neto', na' goklen neto' naknto' wen llin c̱ho', kwenc̱he we'chnto' cho'a xtilloona' na' bi gall illebnto'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Bli' yeḻ' wak c̱ho'na' kwenc̱he yiyaki beṉ' bi shao' na' kwenc̱he gonnto' bichlə dii yibani beṉ' kon yeḻ' wak c̱he Xiiṉo' Jesúza', beena' nak ḻiizelozi beṉ' ḻi beṉ' shao'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Na' ka biyoll be'ḻwillgake' Chioza', wxo' wṉib latja' gana' ndop nllaggake', na' wṉabia'chga Espíritu Sántona' ḻegake' na' bi bllebgake' we'gake' cho'a xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Na' yog' beṉ'ka' ba chonḻilall' Jesúza', toz ka gok yic̱hjlall'do'eka'. Na' yog' daa de c̱he to toe', benin c̱he yoguee. Ni toe' bi wna: “C̱ha' dga.” ");
INSERT INTO zadNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Na' postlka', kon yeḻ' wak xen c̱he Chioza', be'chgake' dill' c̱he X̱ancho Jesúza' daa bibane' ladj beṉ' wetka', na' Chioza' dii xen goklene' yog'ḻoḻe'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Na' ni toe' bibi byallji, ḻa' beena' de yell-lio c̱he' wa lille' na' chiyiteen, na' mecha' daa chox̱ee c̱heyin ");
INSERT INTO zadNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","cho'en postlka' kwenc̱he choe'gake' kon ka'k' wej chyallji to toe'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Na' wzoa to beṉ' Chipre lie' José. Nake' dia c̱he dii Levína', na' postlka' bsi'gake'ne' Bernabé, na' zejin witip lall' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Na' Joséni biyitee to yell-lio dii nape', na' mecha' bi'en postlka'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Na' wzoa to beṉ' wlie' Ananías, na' xoole'na' wlie' Safira, na' biyit'gake' shkwe' yell-lio c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Na' Ananíaza' len xoole'na' gokgake' toz bkwaaṉgake' lat' mecha' na' bentezgake' ka be' doxenan postlka'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Na'ch Pédrona' golle'ne': ―Ananías, ¿berac̱he be'zo' latj wṉabia' Satanáza' yic̱hjlall'do'na' na' chakilo' siyoo Espíritu Sántona' daa bgaaṉleno' lat' mecha' daa wdixjgake' c̱he yell-lio c̱ho'na'? ");
INSERT INTO zadNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","C̱ho' yell-liona' kana' zi' yiyitoon, na' c̱ho' mecha' daa bex̱oo c̱heyin ka biyitoon. ¿Berac̱he wloolzə yic̱hjlall'do'na' siyoo? Aga beṉ' yell-lionin chziyoo, san Chiozan' cheenilo' siyoo. ");
INSERT INTO zadNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Na'ch ka beni Ananíaza' daa goll Pédrona', to ka billeeze' wite'. Na' ḻe blleb yog' beṉ'ka' wṉezi ka gok c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Na' bllin to c̱hop bi' wew' gana' chtoḻ Ananíaza', na' bitobgakbee to lech' na' jakwash'gakbee. ");
INSERT INTO zadNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Na' gok ka do shoṉ gor ka bllin xoole'na', aga ṉezile' bin ba gok c̱he beṉ' c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Na' wṉabi Pédrona'ne', chi'ene': ―Wnashki nad', ¿aka to nakz beṉ' c̱ho'na'n biyit'le yell-lio c̱helena'? Na' Safírana' chi'ene': ―Awe, ka't'kzan biyit'nto'n. ");
INSERT INTO zadNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Na'ch che' Pédrona'ne': ―¿Berac̱he benzle toz dill' kon beṉ' c̱ho'na' chakile wak siye'le Espíritu c̱he Chioza'? Cho'a yooni ba ziza' bi'ka' jakwash'gakb' dii beṉ' c̱ho'na', na' ṉaa lljakwash'gakb' li'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na' lii billeete Safírana' wite' lao Pédrona'. Na' ka biyoo bi' wew'ka' ble'gakib' ba wite', na'ch bibejgakbee na' jakwash'gakbee kwit dii beṉ' c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na' ḻe blleb beṉ'ka' nonḻilall' Jesucrístona' len yog' beṉ'ka' wṉezi ka gok c̱he dii Ananíaza' na' dii Safírana'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na' postlka' bengake' dii zan yeḻ' wak na' bichlə dii chonan ka yibani beṉ' ladj beṉ'ka' lle' Jerusalénna'. Na' yog' beṉ'ka' chonḻilall' Jesúza' chdop chllaggake' ḻoo koridor c̱he yoodo'na' daa le Koridor c̱he dii Salomón. ");
INSERT INTO zadNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Na' nochlə beṉ'ka' aga biyaxjgakile' gongake' ḻegake' txen, ḻa'kzi ḻe ble'shiigakile' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Na' beṉ' zan, ka noolə ka beṉ' byo, benḻilall'gake' X̱ancho Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na' chyix̱jgake' tnezka' beṉ'ka' bi shao', nx̱oagake' ḻegake' no lo yagla' na' no lo daa, kwenc̱he kat' te Pédrona' ḻa'c̱h' bx̱en c̱he'na' ten gana' degake' na' yiyakgakile'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na' ḻekzka' zan beṉ' yellka' llia gaozə Jerusalénna' chajgake' lao postlka' chjwa'gake' beṉ' che'i yillwe' na' beṉ' yoo dii x̱iw'ka'. Na' yog'ḻoḻzgake' chiyaki. ");
INSERT INTO zadNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Na'ch bx̱oz choo bx̱oz xenna' na' saduceoka', beṉ'ka' nakgake'ne' txen, gokxee gokzbangakile' postlka'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Na'ch bex̱'gake' postlka' na' wloogake' ḻegake' lillyana'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Na' waḻa' bllin to anjl c̱he X̱ancho Chioza' bsalje' lillyana' na' bibeje' ḻegake', na' golle': ");
INSERT INTO zadNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Ḻi yiyaj yoodo'na', na' ḻi wzajnii beṉ'ka' chdop chllag na' doxen ka nak yeḻ' mban zejḻi kaṉi daa we' Chioza' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Na'ch ka wyeeni', biyajgake' yoodo'na' ka goll anjla' ḻegake', na' bli' bsedgakile' beṉ'ka'. Na'ch bx̱oz choo bx̱oz xenna' na' beṉ'ka' nakgake'ne' txen bitopgake' yog'ḻoḻ beṉ'ka' chṉabia' yell Israela', na' bseḻ'gake' beṉ' kwenc̱he nan lljx̱i'gake' postlka' de lillyana'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Na' ka bllin beṉ'ka' chap yoodo'na' cho'a lillyana', kochno postlka' de na'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Na'ch jayellgake' beṉ'ka' chṉabia': ―Nejc̱hec̱h lillyana', na' lle'te soldadka' cho'a puertka' chapgake'n, na' ka bsaljnto'n, ni to beṉ' bi yoo ḻo'inna'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na' beena' ngoo lo nee beṉ'ka' chap yoodo'na', len bx̱ozka' chṉabia', ka bengakile' che'gake' ka', na' gokgakile' gate yiyoll yido dga. ");
INSERT INTO zadNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na' ni choe'tegake' dill', bllin to beṉ' chi'e ḻegake': ―Beṉ'ka' wloole lillyana' lle'tgake' yoodo'na' chli' chsedgakile' beṉ'ka' lle' na'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Na'ch wyaj beṉ'ka' chap yoodo'na' kon beena' chṉabia' ḻegake' jaxi'gake' postlka' xochi. Bibi bengakile' ḻegake' daa bllebgake' shi beṉ'ka' chzenag c̱hegake' wlliagake' ḻegake' yaj. ");
INSERT INTO zadNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Na' ka billinlengake' postlka' lao beṉ'ka' chṉabia' yell Israela', na' bx̱oz choo bx̱oz xenna' chi'e ḻegake': ");
INSERT INTO zadNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Abi chajḻe'kzlen nanto' le' bich wli' wsedzile beṉ' xtill' Jesúza'? Na' ḻi wwia ka ba benle, ba bli' bsedile yog' beṉ' Jerusalénki cho'a xtilleena', na' cheenile wtobile neto' daa betgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Na'ch Pédrona' len postlka' sto che'gake': ―Chonchan byen wzenagnto' c̱he Chioza' aga ka c̱he beṉ' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Le' betle Jesúza' na' bda'lene' ḻee yag cruza'. Na' Chios, beena' be'la'o dii x̱ozxto'choka', ḻe' bisbane'ne' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Na' Chioza' ba mbeke'ne' kwite' de shḻina' gana' ba chi'e chṉabi'e, na' nzoe'ne' kwenc̱he yisle' beṉ' lao dii mala', ḻa' cheenile' yog' beṉ' Israelki yiyaj yileni dii malka' chongake' kwenc̱he yizi'xen Chioza' c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Na' neto' choe'nto' dill' daa ble'into' gok c̱he Jesúza', na' daa betj Espíritu Sántona', beena' ba bzoa Chioza' ḻoo yic̱hjlall'do' yog' beṉ' chzenague' c̱he', ḻekzka' chli'n nakan ka nannto'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Na' ka beni beṉ' wṉabia'ka' daa goll postlka', ḻe bllaagake' na' goklall'gake' witgake' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Na' ladj beṉ'ka' chṉabia' len to fariseo, beṉ' le Gamaliel, beṉ' chli' chsedi leya', na' yog'z beṉ' chle'shi'gakile'ne'. Na' wzollee, golle' ḻegake' kwejgake' postlka' xtit chyoolə, ");
INSERT INTO zadNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","na' golle' beṉ' wṉabia'ka': ―Le', beṉ' Israel, ḻi wsak' shi bin gonile beṉ'ki. ");
INSERT INTO zadNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ḻi lljadini kani batz bchej to beṉ' le Teudas, na' wne' nake' to beṉ' zakii, na' ka do tap guiyoa beṉ' bengake'ne' txen. Na' ka betgake'ne', yog' beṉ'ka' gokgake'ne' txen biyesḻesgake', bich bi bengake'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Na' ka wde gok ka', wizak dii yoblə kana' chlabgake' baḻ beṉ' lle' to to yell, na' bizchej Judas beṉ' Galileana', na' ka'kzə beṉ' zan bengake'ne' txen. Na' ḻekzka' betgake'ne' na' biyesḻes beṉ'ka' gokgake'ne' txen. ");
INSERT INTO zadNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Na' ṉaa, nia' le' bibi gonile beṉ'ki, ḻa' ka nak dga chli' chsedgakile', shi nakan dii chyiljlall'zgake' winitlokzan. ");
INSERT INTO zadNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Na' shi nakan c̱he Chios, aga wak yisol yiṉitlen. Chiyaḻ' wwiayeṉ'le kwenc̱he bi gakdiḻ-lenle Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Na'ch betjgakile' daa goll Gamaliela' ḻegake'. Na' bizgoogake' postlka', na' bet wdingake' ḻegake', na' dii yoblə bllongake' kochno wli' wsedgakile' xtill' Jesúza'. Na' biyolla' bisangake' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na'ch bichej postlka' gana' ndop nllag beṉ'ka' chṉabia', na' ḻe chibagakile' daa be' Chioza' latj bc̱hi' bsak' beṉ'ka' ḻegake' daa choe'gake' xtill' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na' yog' lla postlka' bli' bsedgakile' xtill' Jesucrístona' yoodo'na' na' lill beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na' ka zej chanch beṉ'ka' chonḻilall' Jesúza', beṉ'ka' chṉe dill' griegona' wzolo che'gake' aga chaklebi ikaa noolə wizebka' chṉe dill' griegona' ka to daa chkaa nool wizebka' chṉe dill' hebrewa' kat' chyisgake' yeḻ' wawa' yog' lla. ");
INSERT INTO zadNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Na'ch postlka' shlliṉ bti'agake' yog' beṉ'ka' chonḻilall' Jesúza', na' che'gake': ―Bi gak wsannto' c̱hix̱je'nto' cho'a xtill' Chioza' kwenc̱he kooz lo nanto' we'nto' dii yeej gao beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Na' le' beṉ' bish', ḻi kwej gall beṉ' ladjleni, beṉ' chon wen, beṉ' chajnii, na' chṉabia' Espíritu Sántona' ḻegake'. Na' gak lall' na'gake' c̱hisgake' yeḻ' wawa'. ");
INSERT INTO zadNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Na' neto' we'ḻ-lall'chnto' we'ḻwillnto' Chioza' na' wli' wsedchinto' beṉ' cho'a xtilleena'. ");
INSERT INTO zadNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Na' yog'z beṉ'ka' biyoolall'gake' ka goll postlka', na' wlejgake' beena' le Esteban, nake' beṉ' nonḻilall'chgue' Chioza' na' chṉabia' Espíritu Sántona' ḻe'. Na' ḻekzka' wlejgake' Felípena', Prócorona', Nicanora', Timónna', Parménaza', na' Nicoláza', beṉ' Antioquíana', beena' bene' txen beṉ' Israelka'. ");
INSERT INTO zadNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Na' jwa'gake' ḻegake' gana' lle' postlka', na' postlka' bx̱oa neeka' yic̱hje'ka' na' wṉabgakile' Chioza' gaklene' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Na' beṉ' zanch beni cho'a xtill' Chioza' na' wyanchga beṉ'ka' benḻilall'gake' Jesúza' Jerusalénna', na' zan bx̱ozka' bzenaggake' na' benḻilall'gake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Na' Estébanna', wzoalenchga yeḻ' wak c̱he Chioza' ḻe', na' dii xen goklene'ne' kwenc̱he bli'e yeḻ' wakka' na' bichlə dii chonan ka yibani beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Na'ch lle' shkwen beṉ' Israelka' ba biyell bila' lo na' beṉ'ka' wxi' ḻegake', na' non c̱heləgake' chdop chllaggake' gana' choe'ḻwillgake' Chioza'. Na' gokgake' toz baḻ beṉ' Cirene, beṉ' Alejandría, beṉ' Cilicia, na'ch beṉ' zaak do Ásiana', gokdiḻ-lengake' Estébanna'. ");
INSERT INTO zadNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Na' aga gokgake' yeḻ' sin' c̱he Estébanna', daa chṉie' kon ka che' Espíritu c̱he Chioza'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Na' wdixjgake' baḻ beṉ' kwenc̱he wxiye'gake', che'gake': “Ba beninto' Estébanna' chṉie' zban c̱he dii Moiséza' na' c̱he Chioza'.” ");
INSERT INTO zadNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na' daa gollgake' ka', bta bṉegake' beṉ' zan, len beṉ' golka' chṉabia' na' beṉ'ka' chli' chsedi leya' kwenc̱he bex̱'gake' Estébanna' na' jwa'gake'ne' lao beṉ'ka' chṉabia' beṉ' Israelka'. ");
INSERT INTO zadNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Na' wdiljchgake' beṉ'ka' wxiye', kwenc̱he gollgake': ―Bi chsankzə beeni iṉie' c̱he yoodo' c̱he Chios c̱hechona', na' c̱he ley c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Na' ba bizeninto' chizne' Jesús, beṉ' Nazareta', yic̱hiṉje' yoodo' c̱hechona' na' yisha'tie' daa ba yoolocho choncho ka daa bli' bsedi dii Moiséza' cho'. ");
INSERT INTO zadNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na' yog' beṉ'ka' chi' chongake' yeḻ' josc̱hisa', ka bwiagake' Estébanna' na' ble'gakile' chey cheeni' cho'alawe'na' ka cho'alao anjl. ");
INSERT INTO zadNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Na'ch bx̱oz choo bx̱oz xenna' wṉabile' Estébanna', chi'ene': ―¿Alekzi beṉ'ki ka chono'n? ");
INSERT INTO zadNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Na' Estébanna' chi'e ḻegake': ―Le' beṉ' bish' na' le' nakle ka x̱anto', ḻi wzenag dga iṉia' le': Chios c̱hechona', beena' ḻiizelozi nak beṉ' choo beṉ' xen, bli'lawe' dii x̱ozxto'cho Abrahama' kana' zoe' yell-liona' mbani Mesopotámiana', kana' zi' shaje' yell Haránna'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Na' Chioza' golle'ne': “Bkwaaṉ yell c̱ho'ni na' dialla c̱ho'ka', na' wyaj yell-lio gana' wliid' li'.” ");
INSERT INTO zadNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Na'ch dii Abrahama' bcheje' gana' mbani beṉ' caldeoka' na' jsoe' yell Haránna'. Na'ch ka wde wit x̱e'na', Chioza' bizseḻeene' gani zoacho ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Na' Chioza' bi bene' lo na' dii Abrahama' ni lat' yell-lioni de ni, san bc̱hebe' wi'ene'n na' kat' guete' yigaaṉan lo na' xiiṉ dia c̱he'na', ḻa'kzi aga noṉ' bi' c̱he dii Abrahama' ba zoa ka golle'ne' ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Na' ḻekzka' Chioza' chi'ene' xiiṉ dia c̱he'ka' soagake' yell zit' na' iṉabia' beṉ'ka' ḻegake' wgongake' ḻegake' llinna', na' wsak'zi'gake' ḻegake' tap guiyoa yiz. ");
INSERT INTO zadNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Na' ḻekzka' Chioza' golle'ne': “Gon' yeḻ' zi' c̱he beṉ'ka' wc̱hi' wsak'gake' ḻegake', na' yiyolla' yiza'gake' lall beṉ'ka' na' yiyedgake' ni, na' we'la'ogake' nad'.” ");
INSERT INTO zadNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Na' ka bc̱heb Chioza' gone' dii wen c̱he dii Abrahama', golle'ne' chiyaḻ' sho'e seṉna' daa le circuncisión, ḻe' na' xiiṉ dia c̱he'na'. Daan, dii Abrahama' wlo'e dii xiiṉe' Isaaca' seṉna' ka gok x̱on' lla goljb', na' ka'kzə ben dii Isaaca' kon dii xiiṉe' Jacoba', na' ka'kz ben dii Jacoba' kon dii xiiṉe'ka' shlliṉ, beṉ'ka' gok dii x̱ozxto'cho, cho' beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Na' beṉ'ka' nak xiiṉ dii Jacoba', gokxe'gakile' dii Joséna', beena' nak beṉ' bish'gake', na' bet'gake'ne' wxi' beṉ' Egíptoka'ne'. Per Chioza' wzoalene' dii Joséna', ");
INSERT INTO zadNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","na'ch bisle'ne' lao yog'ḻoḻ dii ben ble'ile'. Na' bi'ene' yeḻ' sin' kwenc̱he faraónna', beena' chṉabia' Egíptona', ble'shiile'ne' na' bzoe'ne' kwenc̱he wṉabia'lene' ḻe' na' bene' lo nee yog' dii de c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Na' wzolo wche' wbinna', na' gokchga yeḻ' zi' yeḻ' yeshaa doxen gana' mbani Egíptona' na' gana' mbani Canaánna', na' bi got' dii yeej gao dii x̱ozxto'choka'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Na' ka wṉezi dii Jacoba' de trígona' Egíptona', na' bseḻee bi' c̱he'ka', beṉ'ka' gok dii x̱ozxto'cho, jx̱i'gake'n. ");
INSERT INTO zadNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Na' ka wyajgake' de wchopi, dii Joséna' golle' ḻegake' nan ḻen' nake' beṉ' bish'gake', na'ch bembia' faraónna' dialla c̱he dii Joséna'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Na'ch Joséna' biseḻee ḻegake' kwenc̱he jaxi'gake' x̱e', Jacoba', na' yog' xiiṉ c̱he'ka'. Na' yog'gake' nakgake' ka do guiyon shin'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kan' gok jsoa dii Jacoba' Egíptona' gana' wite', na' ḻekzka' na' wit xiiṉe'ka', beṉ'ka' gok dii x̱ozxto'cho. ");
INSERT INTO zadNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na' jakwash'gake' ḻegake' ḻoo bana' daa bizi' dii Abrahama' yell Siquema' c̱he xiiṉ beena' le Hamor. ");
INSERT INTO zadNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Na' ka ba zoa gao gon Chioza' daa bc̱hebe' gone' c̱he dii Abrahama', ba wyanchga xiiṉ dia c̱he dii Israela', beṉ'ka' lle' Egíptona', beṉ' zan wal ba nakgake'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Na'ch bllin lla wzolo wṉabia' sto beṉ' yoblə yell Egíptona', beṉ' bi bembi'e dii Joséna'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Na' beṉ' wṉabia'na' wxiyee beṉ' wlall c̱hechoka' na' biya dii bc̱hi' bsakee dii x̱ozxto'choka', na' bene' byen lljc̱hooṉgake' bdo'do' c̱he'ka' kwenc̱he guetgakb'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Na' kana'yeṉ' golj dii Moiséza', nakchgab' xochido', na' shoṉ beo'chga bisgol x̱axna'baab' lille'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Na' ka bich gok wkwash'gake'b' lille'ka', benan byen jc̱hoongake'b' kwenc̱he nan guetb'. Na'ch noola' nak xiiṉ faraónna' billelile'b' na' bikeeb' na' bisgole'b' ka xiiṉe'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ka' gok bsed dii Moiséza' yog'ḻoḻ yeḻ' sin' c̱he beṉ' Egíptoka' na' bi'e dill' zakii na' leyi bene' dii zakii. ");
INSERT INTO zadNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Na' ka goki dii Moiséza' c̱hoa yiz, na' gokile' lljawie' beṉ' Israelka', beṉ'ka' nak beṉ' wlall c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Na' ka ble'ile' to beṉ' Egipto chc̱hi' chsakee to beṉ' Israel, na' goklene' beṉ' Israela', bizi'e wzon c̱he beṉ' Egíptona', bettie'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Na' goki dii Moiséza' beṉ' wlall c̱he'ka' gakbe'gakile' nan Chioza' wc̱hine' ḻe' kwenc̱he yisle' ḻegake' lo na' beṉ' Egíptoka', per bi gokbe'gakile'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Na' betiyo ble'ile' c̱hop beṉ' wlall c̱he', beṉ' Israel, chdiḻgake'. Na' gokile' yizoe' ḻegake' wen, na' chi'e ḻegake': “¿Berac̱he chdiḻ-lenzə ljwell-le?, aga ne' beṉ' bishee tiḻ-lene'.” ");
INSERT INTO zadNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Na'ch beena' chit chyine' beṉ' wlall c̱he'na' blliguee dii Moiséza' na' chi'ene': “¿No bzoa li' iṉabi'o neto' na' koo xṉezi c̱hento'ni? ");
INSERT INTO zadNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Aḻekzka' cheenilo' wito' nad' ka beto' beṉ' Egíptona' daa ṉeji?” ");
INSERT INTO zadNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Na' daa goll beeni ka', dii Moiséza' bxoṉje' na' jsoe' gana' mbani Madiánna'. Na' ḻa'kzi nake' beṉ' zit' ladj beṉ'ka', na' bgaaṉe' na'z na' wzoa c̱hop xiiṉe'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Ba gok c̱hoa yiz zoe' na', ka bli'lao to anjl ḻe' to lo yag yesh' dii chaḻ'ṉiṉ, zoan gana' bibi chashj chḻeb gaoz Yaa Sinaína'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Na' ḻe bibani dii Moiséza' daa ble'ile' daa, na' wbiguee kwenc̱he bwiayeṉee kwasḻoḻ. Na'ch benile' shii X̱ancho Chioza', chi'ene': ");
INSERT INTO zadNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nadaan nak' Chios, beena' be'la'o dii x̱ozxto'ka', Abrahama', Isaaca' na' Jacoba'.” Na'ch dii Moiséza' ḻe bllebe' ax̱t chxiztite', na' aga biyaxjchile' wwie'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Na'ch X̱ancho Chioza' golle' dii Moiséza': “Bḻec̱hj xelo'na', ḻa' nad' zoa' latji gani zio', na' aga ka nḻa'z no se ni. ");
INSERT INTO zadNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nad' ba ble'id' yeḻ' zi'na' chle'i beṉ' Israelka' yell Egíptona', beṉ'ka' nak yell c̱ha'. Ba benid' chonyesh'gake', na' ba bid' kwenc̱he yisla' ḻegake'. Na' li', chidoḻoo yiseḻaa Egíptona'.” ");
INSERT INTO zadNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Na' Chioza' bseḻeene' kwenc̱he yisle' beṉ' wlall c̱he'ka' lo na' beṉ' Egíptoka', na' iṉabia'tie' ḻegake', ḻa'kzi bi bzenaggake' c̱he' kana' wzoe' Egíptona'. Bengakile'ne' nakzi, na' gollgake'ne': “¿No bzoa li' iṉabi'o neto' na' koo xṉezi c̱hento'ni?” Ḻa'kzi gollgake' ka', Chioza' bseḻeene' ka bli'lao anjla' ḻe' lo yag yeshaa daa goḻ'ṉiṉ. ");
INSERT INTO zadNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Na' dii Moiséza' bene' zan yeḻ' wak diika' ben ka bibani beṉ' Egíptoka' kana' bibeje' dii x̱ozxto'choka' lalle'ka'. Na' bene' yeḻ' wak ḻoo nisdo'na' le Nisdo' Xṉa, na' ḻekzka' latja' gana' bibi chashj chḻeb gana' wdagake' c̱hoa yiz. ");
INSERT INTO zadNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Na' golle' dii x̱ozxto'choka': “X̱ancho Chioza' kweje' sto beṉ' ka nad' ladjleni, beṉ' c̱hix̱je'ile' le' dillaa daa we'lene'ne'.” ");
INSERT INTO zadNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Na' dii Moiséza' wzoalene' dii x̱ozxto'choka' latja' gana' bibi chashj chḻeb, na' len anjla', beena' bshaljlene'ne' lo yaa Sinaína', na' Chioza' be'lene'ne' dill' dii nsa'n yeḻ' mban daa bikwaaṉlene' cho'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Na' dii x̱ozxto'choka' aga goongakile' wzenaggake' c̱he dii Moiséza', bzoatezgake'ne' ka'lə na' goklall'gake' yiyajgake' Egíptona'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Na'ch gollgake' dii Aarónna': “Cheeninto' gono' to lwaa lsak' dii we'la'onto', kwenc̱he yibialon laonto'ni. Ka nak Moiséza', beena' bibeje' cho' Egíptona', bi ṉezicho bi ba gok c̱he'.” ");
INSERT INTO zadNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Na'ch bengake' to lwaa lsak' me'do' na' bengake' lṉi c̱heyin, betgake' no bayix̱' kwenc̱he be'la'ogake' daa beni ṉi'a neeka'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Na'ch Chioza' wlej yic̱hje' ḻegake' na' bi'e latj be'la'ogake' beljka' llia xan yabana'. Bengake' ka na ḻee libra' daa bzej dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yi, gana' nan: Le', beṉ' Israel, ¿Achakile nadaan be'la'ole kana' betle bayix̱'ka' lo c̱hoa yiza' wzoale latja' gana' bibi chashj chḻeb? ");
INSERT INTO zadNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Aga nadaan be'la'ole. Molocan' be'la'ole, benle to yoo de lech' gana' be'la'olen ka chios c̱hele, na' be'la'ole belj c̱he chios c̱hele Refánna', diika' benḻilall'le. Na' ni c̱heyi diikin kwej' le' lall-leni, na' wseḻaa le' zit' walch aga ka yell Babilóniana'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Na' shlak wzoa dii x̱ozxto'choka' latja' gana' bibi chashj chḻeb, bengake' to yoodo' de lech' dii gak yidob na' yiyoa'gake'n. Na' bengake'n kon ka goll Chioza' dii Moiséza', na' kon ka bliile'ne'. Na' ḻo'inna' wlooshao'gake' yaj taaka' gana' nyoj ley c̱he Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Dii x̱ozxto'choka' bigaaṉlengake' yoodo' de lechaa, na' bia'gake'n ka wyajlengake' dii Josuéna' jtiḻ-lengake' yellka' ben Chioza' lall' na'gake', na' bgaaṉan lallchoni ax̱t ka bllin lla wṉabia' dii Davina'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Na' Chioza', beena' be'la'o dii x̱ozxto'cho Jacoba', bibaile' ka ben dii Davina'. Na' Davina' wṉabile'ne' wi'e latj gone' to lill xḻatje'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Per Salomónna'lə, beena' nak xiiṉe', bene'n ");
INSERT INTO zadNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ḻa'kzi Chioza', beena' nak ḻiizelozi beṉ' choo beṉ' xen, bi zoe' to ḻoo yoo dii chon beṉ' yell-lioni. Ḻa' ka wna dii beena' wdix̱jee daa goll Chioza'ne' kani'yi: ");
INSERT INTO zadNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Yabana' nakan gana' chi'a chṉabi'a, na' lo yell-liona' nzoa' ṉi'ani. ¿Nakran chakile gonle yoona' gana' soa'?, na X̱anchona'. ¿Achakile chyallj ga yizi'lallaa? ");
INSERT INTO zadNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Abi chwiale nadaan ben' yog'ḻoḻ dii de? ");
INSERT INTO zadNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Na'ch Estébanna' chi'e beṉ'ka' lle' na': ―Ḻe beṉ' yic̱hjlall'do' wal nakle. Bi chzenagle c̱he Chioza' na' chonle ka beṉ' bi nombia' Chioza'. Nakle beṉ' widenag ka gok dii x̱ozxto'choka'. Bikzə chzenagle c̱he Espíritu Sántona'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Dii x̱ozxto'choka' bc̱hi' bsak'gake' yog' dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yi. Betgake' beṉ'ka' be' dill' nan Chioza' wseḻee beena' zeelo nak beṉ' ḻi beṉ' shao'. Na' ka bide' na' bénlene' lo na' beṉ'ka' betgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ḻa'kzi nombia'le ley daa be' anjlka' dii Moiséza', bi chzenagkzlen. ");
INSERT INTO zadNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ka beni beṉ'ka' daa goll Estébanna' ḻegake', ḻe bllaagake' ax̱t chaoyaax̱ax̱j ḻeye'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Na' Estébanna', chṉabia'chga Espíritu Sántona' ḻe', na' bḻis lawe'na' yabana' ble'ile' yeḻ' chey cheeni' c̱he Chioza', na' ble'teile' ze Jesúza' kwit de shḻi c̱he Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Na'ch golle' ḻegake': ―¡Ḻi wwia! Chle'id' nyalj yabana', na' Beena' Bseḻ' Chioza' Yell-lioni zie' kwit Chioza' shḻaa de shḻina'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Na' beṉ'ka' lle' na' bsej nague'ka' kwenc̱he bi bengakile' xtilleena', na' de chosyaadiazgake' bex̱'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Na' wlejgake'ne' yell Jerusalénna' jalliagake'ne' yaja'. Na' beṉ'ka' ben ka' bkwaaṉlen xe'ka' daa ndobgake' to bi' wew' le Saulo kwenc̱he wdapbaan. ");
INSERT INTO zadNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Na' ka chlliagake'ne' yaja', be'ḻwille' Jesúza', chi'ene': ―Jesús, li' nako' X̱an', bizi' bikaagach nad'. ");
INSERT INTO zadNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Na' biyoll wne' ka', na' bc̱hek' xibe'na' na' wṉie' zillj, wne': ―X̱an', wxi'xen c̱he beṉ'ki dga chongakile' nad'. Na' biyoll wne' ka' wite'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Na' Sáulona' goke' toz beṉ'ka' betgake' Estébanna'. Na' lo llana'tez wzolo bc̱hi' bsak'gake' yog' beṉ'ka' nonḻilall' Jesúza' Jerusalénna'. Na' wisḻesgake' doxen gana' mbani Judeana' na' gana' mbani Samáriana', na' totgui postlka' bigaaṉgake' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Na' to c̱hop beṉ' nonḻilall' Jesúza' jakwash'gake' dii Estébanna' na' ḻe wchellgakile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Na' Sáulona' bc̱hi' bsakee beṉ'ka' nonḻilall' Jesúza', chaje' lill c̱he c̱hegake' chjtoyoe' ka nool ka beṉ' byo kwenc̱he chgwee ḻegake' lillyana'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na' beṉ'ka' bllesh Jerusalénna' be'gake' dill' wen dill' kob c̱he Crístona' gattezə wyajgake'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Na' beena' le Felipe, wyaje' to yell xen c̱he Samáriana' na' be'lene' beṉ'ka' dill' c̱he Crístona'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Na' bdop bllag beṉ', na' yog'ḻoḻgake' bzenagyeṉ'gake' dill' daa be' Felípena', daa ble'gakile' yeḻ' wakka' chone'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Na' beṉ' zan bichej dii x̱iwaa, na' ka bichejgakan chosyaadiagakan. Na' ḻekzka' biyone' zan beṉ' net ṉi'a nee, na' beṉ' bi chak sa' wen. ");
INSERT INTO zadNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Na' daa gok ka', ḻe biba bizaki beṉ'ka' lle' yella'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na' ḻekzka' yella' wzoa to beṉ' willa' lie' Simón, na' kon yeḻ' willa'na' chone' chziyee beṉ' doxen gana' mbani Samáriana', na' ben kwine' beṉ' choo beṉ' xen. ");
INSERT INTO zadNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Yog' beṉ' lle' na' chzenaggake' xtilleena', ka bi' xkwid' ka beṉ' gol, na' nagake': ―Beenin nsi'gake' Yeḻ' Wak Choo Yeḻ' Wak Xen c̱he Chios. ");
INSERT INTO zadNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Na' ḻe wyajḻe'gake' c̱he', ḻa' zan yiz ba gok chziyee ḻegake' kon yeḻ' willa'na' daa chone'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Na' ka bzajnii Felípena' ḻegake' dill' wen dill' kob c̱he yeḻ' wṉabia' c̱he Chioza' na' c̱he Jesucrístona', na' beṉ' zan wyajḻe'gake' xtilleena' na' wchoagake' nisa', ka noolə ka beṉ' byo. ");
INSERT INTO zadNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na' lente Simónna' wyajḻi'e na' wchoe' nisa', na' wzoloe' chdalene' Felípena' gattez zeje', na' chibanile' ka nak yeḻ' wakka' daa chon Felípena'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na' ka wṉezi postlka' lle' Jerusalénna' ba chajḻe' beṉ' Samáriaka' cho'a xtill' Chioza', na' bsel'gake' Pédrona' len Juanna' Samáriana'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Na' ka bllingake', be'ḻwillgake' Chioza' wṉabgakile'ne' soa ḻoo yic̱hjlall'do' beṉ' Samáriaka' Espíritu Sántona'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ḻa' biṉ' soa' Espíritu Sántona' ḻoo yic̱hjlall'do'eka'. Tochga ba wchoagake' nisa' daa chajḻe'gake' c̱he X̱ancho Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Na'ch Pédrona' len Juanna' bx̱oa neeka' yic̱hj beṉ'ka', na' jsoa Espíritu Sántona' ḻoo yic̱hjlall'do'eka'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Na' ka gokbe'i Simónna' jsoa Espíritu Sántona' ḻoo yic̱hjlall'do' beṉ'ka' biyoll bx̱oa na' postlka' yic̱hje'ka', na' bshabile' ḻegake' mech, ");
INSERT INTO zadNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","chi'e: ―Ḻi goṉ nad' yeḻ' waki kwenc̱he nottez beṉ' ka wx̱oa' na'ki yic̱hje'ka' soa Espíritu Sántona' ḻoo yic̱hjlall'do'eka'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Na'ch Pédrona' golle'ne': ―Kwiayi'lenshgo' xmecho'na', daa chakilo' wak si'leno'n daa choṉ Chioza' ka'z. ");
INSERT INTO zadNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Bikz ga gak gono' ka nak dga chonnto', ḻa' bi nak yic̱hjlall'do'na' ka cheeni Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Biyaj bileni dii mala' chono', na' be'ḻwill Chioza' shi yizi'xene' c̱heyi daa ba goklalloo gono'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ḻa' nakbia'cha bin nxe bin nzak' nak ḻoo yic̱hjlall'do'na', na' ḻennan' ntakw nc̱hejan li'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Na'ch che' Simónna' ḻegake': ―Ḻi we'ḻwillgach Chioza' ni c̱ha' kwenc̱he bi gak daa ba wnale gak c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Na' ka biyoll be' Pédrona' na' Juanna' cho'a xtill' Chioza', na' biza'gake' ziyajgake' Jerusalénna'. Na' ka zingoogake' nez, be'gake' dill' wen dill' kob c̱he Jesucrístona' zan yellka' gana' mbani Samáriana'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Na'ch to anjl c̱he X̱ancho Chioza' wṉie' Felípena', chi'e: ―Wyaj lli'lə na' gox̱oo neza' daa ziza' Jerusalénlə na' zejan yell Gázalə, neza' daa chde latja' gana' bibi chashj chḻeb. ");
INSERT INTO zadNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Na' wza' Felípena' zeje', na' tneza' billague' to beṉ' Etiopía wyaje' Jerusalénna' je'lawee Chioza'. Na' nake' to eunuco, beṉ' zakii, na' nak lall' nee mech c̱he noolə wṉabia' c̱he Etiopíana' beena' le Candace. ");
INSERT INTO zadNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Na' ba zingwee nez ziyaje' lalle'nalə, na' ziyo'e ḻoo karret c̱he'na' chlabe' daa bzej dii Isaíaza', beena' wdix̱jee daa goll Chioza'ne' kani'yi. ");
INSERT INTO zadNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Na'ch Espíritu c̱he Chioza' chi'e Felípena': ―Jabig' kwit karreta'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Na' ka jabig' Felípena' kwit karreta', benile' chlab beena' daa bzej dii Isaíaza'. Na' chi'ene': ―¿Achajniilo' daa chlabo'? ");
INSERT INTO zadNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Na'ch beṉ' Etiopíana' chi'e: ―¿Nakra gon' shajniida'n?, ḻa' bi zoa no wzajnii nad'. Na' golle' Felípena': ―Wyepgach na' wche' kwitii. ");
INSERT INTO zadNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na' Cho'a Xtill' Chioza' gana' chlabe' nan: Betgake'ne' ka chite' to xil'do'; na' ka to xil'do', ba bi chosyaa kat' chshibe'b, ka'kz ḻe', ni shcho'a dill' bi wṉie'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Na' bsi'gake'ne' yeḻ' zto', na' aga no goklen ḻe' gone' yeḻ' josc̱his c̱he'. Na' kono xiiṉ dia c̱he wzoa, ḻa' bsol bṉitgake' yeḻ' mban c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Na'ch beṉ' Etiopíana' chi'e Felípena': ―Ben goklen wna nad', ¿nora c̱heyin wna dii Isaíaza' ka'? ¿Ac̱he kwinen' cho'e dill', anti c̱he beṉ' yoblan? ");
INSERT INTO zadNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Na'ch Felípena' wzoloe' bzajniile'ne' ka zeji gana' chlabe' na' bi'e dill' wen dill' kob c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Na' ka bllingake' to ga llia nis, na' che' beṉ' Etiopíana' Felípena': ―Ni llia nis, ¿ade daa wsej wllonan c̱hoa' nisa'? ");
INSERT INTO zadNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Na' che' Felípena'ne': ―Shi chajḻi'o do yic̱hj do lalloo, wak wchoa' li' nisa'. Na' che' beṉ' Etiopíana': ―Chajḻi'a Jesucrístona' nake' Xiiṉ Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Na'ch bkweze' karreta' na' betjgake'; na' wyoogake' ḻoo nisa' na' Felípena' bchoe'ne' nisa'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Na' ka bichejgake' ḻoo nisa', Espíritu c̱he X̱ancho Chioza' bic̱hi'e Felípena' gan yoblə, na' aga ble'chi beṉ' Etiopíana' ḻe', per chiba chizakile' ziyaje'. ");
INSERT INTO zadNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Na' Felípena' billine' yella' le Azoto, na' bidie' to to yell chyise' dill' wen dill' kob c̱he Jesúza' ax̱t billintie' Cesareana'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Na' Sáulona' kon chde' chwall chshebe' beṉ'ka' nonḻilall' X̱ancho Jesucrístona'. Chiyiljlallee nak gone' kwenc̱he wite' ḻegake'. Daan wyaje' Jerusalénna' jawie' bx̱oz choo bx̱oz xenna' ");
INSERT INTO zadNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","na' wṉabile'ne' wzeje' twej yish c̱he to to gana' chdop chllag beṉ' wlall c̱he'ka' choe'ḻwillgake' Chioza' yell Damáscona', na' we'n lsens yiyilje' beṉ'ka' ba wyoo lo nez ḻi nez shao' c̱he Jesucrístona' na' gox̱ee ḻegake' kwenc̱he yic̱hi'e ḻegake' pres Jerusalénna', ka noolə ka beṉ' byo. ");
INSERT INTO zadNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ka ni ngwee nez, na' ba zoa illine' yell Damáscona', tokonganzi wyec̱hj to beeni' xen wal ḻe' dii za' yabalə. ");
INSERT INTO zadNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Na' Sáulona' jc̱haze' lo yona' na' benile' to shii beṉ', chi'ene': ―Saulo, Saulo, ¿bic̱he chc̱hi' chsak'zo' nad'? ");
INSERT INTO zadNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Na'ch Sáulona' chi'e: ―¿Nora li', beṉ'? Na'ch billii beenan', chi'e: ―Nadaan Jesúza', beena' chc̱hi' chsakoo. Na' daa chono' ka', zi' c̱he kwinzon' chono' na' chak c̱ho' ka chak c̱he gooṉa' chilibb xisa' daa chbibe'b kwenc̱he sa'b. ");
INSERT INTO zadNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Na'ch Sáulona' ax̱t chxiztite' daa chllebe', na' golle'ne': ―X̱an', ¿beran cheenilo' gon'? Na' X̱anchona' chi'ene': ―Biyas na' wyaj Damáscona', na' na' iṉagake' li' daa chiyaḻ' gono'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Na' beṉ'ka' zejlengake' Sáulona' txen ḻegatega wzegake' bibangakile' na' bllebgake', daa bengakile' chak xṉe, per ni to kono ble'gakile'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Na'ch biyas Sáulona' lo yona'. Na' ka bix̱a' jalawe'na' aga ble'chile'. Na' beṉ'ka' zejlene' txen bex̱'gake' neena' kwenc̱he bc̱he'gake'ne' yell Damáscona'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Na' shoṉ lla bi gok ile'ile', ni bi weej wdawe'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na' Damáscona' zoa to beṉ' chonḻilallee Jesúza' na' lie' Ananías, na' ben X̱ancho Jesúza' ka ble'do'ile'ne', na' chi'ene': ―Ananías. Na' Ananíaza' chi'ene': ―Ni zia', X̱an'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Na' X̱anchona' chi'ene': ―Wyaj, na' wyoo neza' daa le Shḻicha, na' lill Júdaza' iṉabo' to beṉ' Tarso, beṉ' le Saulo. Ba choe'ḻwille' nad', ");
INSERT INTO zadNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","na' ba ble'do'ile' li' choo gana' zoe' na' chx̱oa noona'ne' kwenc̱he yile'ile'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ka beni Ananíaza' chi'ene' ka', na' golle'ne': ―X̱an', ze xtill' beena' chsak'zi'e beṉ'ka' nonḻilall' li' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na' ṉaa ba blee ni nox̱ee yish daa bzej bx̱ozka' chṉabia' daa cho'en lsens gox̱ee yog'ḻoḻnto', neto' choe'ḻwillnto' li', na' yic̱hi'e neto' pres Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Na' X̱ancho Jesúza' golle'ne': ―Wyaj, ḻa' ba wlej' Sáulona' kwenc̱he wi'e xtillaana' lao beṉ'ka' bi nak beṉ' Israel, na' lao beṉ' wṉabia' c̱he'ka', na' ḻekzka' laole le' nakle beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nad' wliidee ka chiyaḻ' si' sakee ni c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Na'ch Ananíaza' wyaje' gana' zoa Sáulona' na' wyo'e ḻoo yoona', na' bx̱oa neena'ne'. Na' chi'ene': ―Saulo, beṉ' bish', X̱ancho Jesúza', beena' wṉie' li' tneza' kana' zo' ni, ba bseḻee nad' kwenc̱he gon' ka yile'ilo' na' soa Espíritu Sántona' ḻoo yic̱hjlall'do'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Na' ka bx̱oa neena' Sáulona', lii bikwaste jalawe'na' daa nak ka yid bdeej, na' bile'ile'. Na'ch bizollee na' wchoe' nisa'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Na' ka wdawe', biyakshao'lallee, na' bigaaṉlene' beṉ'ka' nonḻilall' Jesúza' yell Damáscona' zan lla. ");
INSERT INTO zadNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Na' lii wzolote Sáulona' cho'e xtill' Crístona' to to gana' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza' yell Damáscona', na' chi'e beṉ'ka' Jesúza' nake' Xiiṉ Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Na' yog' beṉ'ka' bengakile' dill' daa choe' Sáulona' chibangakile', na' che' ljwelle': ―¿Aaga beenin chde' chc̱hi' chsakee beṉ'ka' nonḻilall' Jesúza' Jerusalénna'? Na' ¿aaga ni c̱heyinnan' bide' ni kwenc̱he yic̱hi'e yog'ḻoḻgake' pres lljasane' ḻegake' lao bx̱ozka' chṉabia'? ");
INSERT INTO zadNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Na' btipch lall' Sáulona' kwenc̱he zizikchli bi'e dill' nan Jesúzan' nake' beena' bc̱heb Chioza' wseḻee kwenc̱he iṉabi'e, na' bich gok iṉa beṉ' Israelka' lle' yell Damáscona' bi nakan ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ka ba gok zan lla choe' Sáulona' xtill' Jesúza' yell Damáscona', na' beṉ' Israelka' lle' na' bshag ljwellgake' nan witgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Na' gokbe'i Sáulona' ba chinogake'ne'. Ka waḻ ka tella wdapgake' cho'a puert c̱he zeena' daa nec̱hj yella' kwenc̱he gox̱'gake'ne' ka yicheje' na' witgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Na'ch beṉ'ka' nonlene' txen, waḻ-lə wloogake'ne' to ḻoo llom na' biḻetjgake'ne' ḻee zeena' nec̱hj yella' kwenc̱he bile'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ka billin Sáulona' Jerusalénna', gokile' ḻene' beṉ'ka' nonḻilall' Jesúza', per yog'ḻoḻe' bllebgake'ne', bi wyajḻe'gake' shi dii ḻi ba chonḻilallee Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Na' Bernabéna' bc̱hi'e Sáulona' gana' lle' postlka'. Na' golle' ḻegake' nan Sáulona' ble'ile' X̱ancho Jesúza' tneza' ka zeje' yell Damáscona', na' Jesúza' be'lene'ne' dill'. Na' ḻekzka' golle' ḻegake' bi bllebe' bi'e xtill' Jesúza' yell Damáscona'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Na' ka' gok bigaaṉe' Jerusalénna' goke' txen beṉ'ka' nonḻilall' Jesúza', na' wal inlleb goke' bi'e xtill' X̱ancho Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Na' be'lene' dill' beṉ' Israelka' chṉe dill' griegona' kwenc̱he shajḻe'gake' c̱he Jesúza', per ḻegake' goklall'ligake' witgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Na' ka wṉezi beṉ'ka' nonḻilall' Jesúza' ba chinogake' Sáulona' kwenc̱he witgake'ne', bc̱he'gake'ne' Cesareana'lə. Na' ka bllingake' na', na' biseḻ'gake'ne' Társona'lə gana' nak lalle'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Na'ch beṉ'ka' nonḻilall' Jesúza' doxen Judeana', Galileana' na' Samáriana' wzoagake' mbalaz, ḻa' koch no bc̱hi' bsak'ch ḻegake'. Na' wlooshosh yic̱hjgake' toz Chioza'. Na' Espíritu Sántona' goklene' ḻegake' kwenc̱he gokchachgake' lo xṉez Chioza' na' kwenc̱he wyanchgake'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Do kana', chda Pédrona' chjawie' beṉ'ka' nonḻilall' Jesúza' to to yell, na' ḻekzka' jawie' beṉ'ka' lle' yell Lídana'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Na' yell Lídana' jti'e to beṉ' le' Eneas. Ba gok x̱on' yiz die' bi chak c̱hase' daa net ṉi'a neena'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Na' Pédrona' golle'ne': ―Eneas, Jesucrístona' yiyone' li'. Biyas na' bitob daa c̱ho'na'. Na' lii biyaste Enéaza'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Na' yog' beṉ'ka' lle' yell Lídana' na' yell Sarónna', ble'gakile' biyaki beena' na' benḻilall'gake' X̱ancho Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na' ḻekzka' yell Jópena' wzoa to noolə benḻilallee Jesúza', na' wlie' Tabita, na' dill' griegona' che'gake'ne' Dorcas. Na' nooli, shlak wbane' toshiizi bzani ṉi'a neena' goklene' beṉ', na' biyesh'lallile' beṉ'ka' bibi de c̱heyin. ");
INSERT INTO zadNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Na' bllin to lla gok Dorcaza' to yillwe' na' wite'. Na'ch biyoll biwazjgake'ne', jadix̱jgake'ne' ḻoo yoo c̱he'na' llia shkwiana' cha'lə. ");
INSERT INTO zadNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Na' Jópena' llian gaozə yell Lídana', na' beṉ'ka' wṉezgakile' zoa Pédrona' yell Lídana', na'ch bseḻ'gake' c̱hop beṉ' jellgake'ne': ―Sho'gach Jópena' ṉaate. ");
INSERT INTO zadNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Na'ch Pédrona' wzee zejlene' beṉ'ka' Jópena'. Na' ka blline', na' jwa'gake'ne' ḻoo yoona' gana' de beṉ' weta', na' yog' nool wizebka' wyec̱hjgake' Pédrona' chbellgake', na' bli'gakile'ne' xe'ka' daa ben dii Dorcaza' shlak wbane'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Na' Pédrona' bibeje' yog'ḻoḻe' chyoolə, na' bc̱hek' xibe'na' be'ḻwille' Chioza'. Na'ch bwie' noola' ba wit na' golle'ne': ―Tabita, biyas. Na'ch lii bix̱a'te jalao Dorcaza' chwie' Pédrona'. Na'ch biyase' bibi'e. ");
INSERT INTO zadNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Na' Pédrona' bex̱ee neena' na' bisolléene'. Na'ch biṉie' nool wizebka' na' nochlə beṉ'ka' nonḻilall' Jesúza' kwenc̱he bizoe'ne' shi'a shbane' lawe'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Na' wze dill' doxen yell Jópena' ka gok c̱he Dorcaza', na' beṉ' zan benḻilall'gake' X̱ancho Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Na' Pédrona' bigaaṉe' Jópena' zan lla lill Simónna, beena' chkoll yidxa bayix̱'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na' yell Cesareana' wzoa to beṉ' wlie' Cornelio, na' nak lall' nee zan soldadka', na' beṉ'ka' nak lall' nee wlegake' Beṉ' Italia. ");
INSERT INTO zadNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Na' Cornéliona' len beṉ'ka' nakgake' toz ḻoo yoo lille'na' choe'la'ogake' Chioza' na' chall chllebgake'ne'. Na' zoatezi zoe' choe'ḻwille' Chioza' na' cho'e mech xen kwenc̱he chaklene' beṉ' Israelka', beṉ'ka' chyallj chc̱hinin. ");
INSERT INTO zadNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","To lla, do ka chida shoṉ, ble'do'ile' to anjl c̱he Chioza' wyo'e gana' zoe' na' golle'ne': ―¡Cornelio! ");
INSERT INTO zadNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Na' Cornéliona' chwiayeṉee anjla' do chllebze', na' golle'ne': ―¿Beran cheenilo' beṉ'do'? Na' anjla' chi'ene': ―Chioza' chibaile' daa zoatezi zo' choe'ḻwillo'ne' na' daa chakleno' beṉ' yesh'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Na' ṉaa bseḻ' beṉ' shajgake' yell Jópena' kwenc̱he lljx̱i'gake' beena' le Simón Pedro. ");
INSERT INTO zadNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Zoe' lill to beṉ' le Simón, beena' chkoll yid, na' lille'na' zoan gaoz cho'a nisdo'na'. Na' Simón Pédrona' iṉe' li' daa chiyaḻ' gono'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na' ka biza' anjla' bshaljlen Cornéliona', na'ch Cornéliona' goxe' c̱hop xmose'na', na' sto soldad, beena' nonḻilallee Chioza' na' zoe' chaklene'ne' chgwee xṉezi bittez. ");
INSERT INTO zadNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Na' golle' ḻegake' yog' daa goll anjla', na'ch bseḻee ḻegake' Jópena'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na' betiyo do ka gobill ba zoa illin beṉ'ka' bseḻ' Cornéliona' yell Jópena'. Na' ka lo gora', Pédrona' wyepe' koll' yoona' gana' zoe' kwenc̱he we'ḻwille' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Na' wdone', na' goklallee gawe' sheḻ'ka'. Na' shlak chongake' daa gawe', ble'do'ile' ");
INSERT INTO zadNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","byalj yabana', na' to dii nak ka to lech' xen dii nchej tap yic̱hjten chetjan lo yona'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Na' ḻoo lechaa lle' biya bayix̱', no ba llia tap ṉi'a na'in, na' no ba chx̱obi ḻeeb lo yona' na' no ba zoa x̱ilin. ");
INSERT INTO zadNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Na'ch benile' shii to beṉ', chi'ene': ―Wzolla' Pedro. Bet baka', na' wdao. ");
INSERT INTO zadNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Na'ch Pédrona' golle'ne': ―Bi gaw' baka', X̱an'; ni shlin biṉ' gaw' baki bi nak ba xilall'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Na' sto shii benile' shii beena', chi'ene': ―Daa ba wna Chioza' wak gawo', bich iṉazo' bi nakan xilall'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Shoṉ shii golle' ka', na'ch biyep lechaa yabana'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Na' chibani Pédrona' chakile' bera zejin daa ble'do'ile', ka bllin beṉ'ka' bseḻ' Cornéliona' cho'a yoona' gana' zoe', daa ba wṉabgake' gan zoa lill beena' le' Simón, beena' chkoll' yid xa bayix̱'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Na' ka bllingake', na' wṉegake' zillj wṉabgake' shi nan' zoa to beṉ' le Simón Pedro. ");
INSERT INTO zadNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Na' Pédrona' zie' wṉeyi c̱heyi daa ble'do'ile', kat' wne Espíritu Sántona', chi'ene': ―Bwiakachi, na' lle' shoṉ beṉ' chiyiljgake' li'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Bizolla' na' biyetj, na' wyajlengake'. Bi gakc̱hopilo', ḻa' nadaan bseḻaa ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Na'ch biyetj Pédrona' gana' lle' beṉ'ka' bseḻ' Cornéliona'. Na' chi'e ḻegake': ―Nadaan beena' chiyiljle. ¿Beran chak c̱hele zidwiale nad'? ");
INSERT INTO zadNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Na'ch che' beṉ'ka' Pédrona': ―To beṉ' wṉabia' c̱he soldadka' lie' Cornelio bseḻee neto'. Nake' to beṉ' zej shḻi lao Chioza' na' ngooshosh yic̱hje'ne', na' yog' beṉ' Israelka' ṉezgakile' zoe' chone' wen. Na' to anjl c̱he Chioza' golle'ne' iṉie' li' kwenc̱he shajo' lille'na' wzajniilo'ne' na' wzenague' dill'ka' we'leno'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Na'ch Pédrona' wlo'e ḻegake' ḻoo yoolə gana' zoe', na' bigaaṉgake' shyel. Na' betiyo wyajlen Pédrona' ḻegake' na' len to c̱hop beṉ' Jope, beṉ' nonḻilall' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Na' llana' sto bllingake' Cesareana'. Na' Cornéliona' ba btope' yog'ḻoḻ dialla c̱he'na' na' beṉ'ka' nllaguile', na' ba lle'gake' lille'na' chbezgake' illin Pédrona'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Na' ka bllin Pédrona' lill Cornéliona', lii bchejte Cornéliona' bc̱hek' xibe'na' lawe'na' choe'laweene'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Na' Pédrona' bisolléene', chi'ene': ―Bizolla', bi wc̱hekz' xibo' lawii, ḻa' ḻekzka' beṉ'zə nad'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Na'ch shlak chshaljgake' wyoogake' ḻoo yoona', na' ble'i Pédrona' beṉ' zan ba lle'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Na'ch golle' ḻegake': ―Le' ṉezile ka na ley c̱hento'na', neto' beṉ' Israel bi chiyaḻ' gonnto' txen le' bi nakle beṉ' Israel, na' ni bi chiyaḻ' sho'nto' ḻoo yoo lill-le. Per Chioza' ba bzajniile' nad' bi chiyaḻ' gakid' zban nottez beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Daan ka bla' beṉ'ki chṉegake' nad', lii za'tia' bi bc̱hia' dill'. Na' ṉaa cheenid' iṉezid' bic̱he bseḻoo beṉ'ki bidx̱i'gake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Na'ch Cornéliona' chi'ene': ―Ba gok tap lla, do ka ṉaayeṉ', chida shoṉ, choe'ḻwill' Chioza' ḻoo lillii kat' ble'id' to beṉ' byo zie' lawa' nakwe' to lech' dii chey cheeni'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Na' wne' nad': “Cornelio, Chioza' ba bzenague' daa choe'ḻwillo'ne', na' ḻekzka' chle'ile' ka chakleno' beṉ' yesh'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Na' bseḻ' beṉ' shajgake' yell Jópena' lljx̱i'gake' Simón Pédrona' kwenc̱he yide' we'lene' li' dill'. Zoe' lill to beṉ' le Simón, beṉ' chkoll yid, na' lill beeni zoan gaoz cho'a nisdo'na'.” ");
INSERT INTO zadNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Daan lii bentia' wṉeyi bidx̱i'gake' li', na' chox̱keno' ba bido'. Na' ṉezkzi Chioza' yog'nto' cheeninto' wzenagnto' yog' cho'a dillaa daa cheenile' iṉo' neto'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Na'ch wzolo Pédrona' bi'e dill', chi'e: ―Chakbe'id' ṉaa, dii ḻi Chioza' aga nakzi beṉ' chakile', ");
INSERT INTO zadNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","san chle'shiile' yog' beṉ' lle' gattez yell kon shi chall chllebgake'ne' na' chongake' daa nak shḻi. ");
INSERT INTO zadNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Chioza' bseḻee beṉ' wdix̱je'ile' neto' beṉ' Israel dill' wen dill' kob c̱he'na' nan wak yizoalenchone' mbalaz daa bseḻee Jesucrístona', beena' nak X̱an yog'ḻoḻcho. ");
INSERT INTO zadNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ṉezkzile kwasḻoḻ diika' gok gana' mbani Judeana', daa wzolo gana' mbani Galileana' ka wde wdix̱je'i dii Juanna' beṉ' nan chonan byen yiyaj yilengakile' na' c̱hoagake' nis. ");
INSERT INTO zadNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ṉezile Chioza' bi'e Jesús, beṉ' Nazareta', yeḻ' wak na' Espíritu Sántona', na' wda Jesúza' bene' dii wenka' na' biyone' yog' beṉ'ka' ntakw nc̱hej dii x̱iwaa, daa wzoalen Chioza' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Neto' choe'nto' dill' c̱he yog'te diika' ben Jesúza' Jerusalénna' na' doxen gana' mbani Judeana'. Na' biyoll bene' diika', betgake'ne' bda'gake'ne' ḻee yag cruza'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Per Chioza' bisbane'ne' ladj beṉ' wetka' biyoṉ llana', na' bidli'lawe' neto'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Aga yog' beṉ' bli'lao Jesúza' ka bibane' ladj beṉ' wetka', san bli'lawe' toz neto', neto' naknto' beṉ' ba wlej Chioza' kwenc̱he we'nto' xtilleena'. Na' neto' weej wdaolennto'ne' ka wde bibane' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Na' Jesúza' bseḻee neto' c̱hix̱je'into' beṉ' nan Chioza' nzoe'ne' kwenc̱he gone' yeḻ' josc̱his c̱he yog'ḻoḻ beṉ', ka beṉ' mban na' ka beṉ' ba wit. ");
INSERT INTO zadNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Na' ḻekzka' kani'yi yog' dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' be'gake' xtill' Jesúza', wnagake' Chioza' yizi'xene' saaxya c̱he nottezə beṉ' gonḻilallee Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Na' ni chshaljte Pédrona', kat' Espíritu Sántona' wyo'e ḻoo yic̱hjlall'do' yog' beṉ'ka' chzenaggake' xtilleena'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Na' beṉ' Israelka' nonḻilall' Jesúza', beṉ'ka' bllinlen Pédrona' lill Cornéliona', bibangakile' daa wyoo Espíritu Sántona' ḻoo yic̱hjlall'do' beṉ'ka' bi nak beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Na' bengakile' chṉe beṉ'ka' wde wdeli dill' dii bi nombia'gake', choe'la'ogake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Na' Pédrona' golle' beṉ' Israelka' lle' na': ―Aga no gak wllon wchoa beṉ'ki nisa', ḻa' ba yoo Espíritu Sántona' ḻoo yic̱hjlall'do'eka' ka ba yo'e cho'. ");
INSERT INTO zadNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Na' ben Pédrona' mandad wchoagake' nisa' daa chonḻilall'gake' X̱ancho Jesucrístona'. Na' biyolla' wṉabgakile' Pédrona' kwenc̱he bigaaṉlene' ḻegake' c̱hop shoṉ lla. ");
INSERT INTO zadNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Na' postlka' na' nochlə beṉ'ka' nonḻilall' Jesúza' Judeana' bengakile' nan beṉ'ka' bi nak ben' Israel ḻekzka' chajḻe'gake' cho'a xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Na' ka billin Pédrona' Jerusalénna' gokdiḻ-len x̱oṉj beṉ' ḻe', beṉ'ka' che' chonan byen sho' beṉ' byoka' nonḻilall' Chioza' seṉ daa le circuncisión ḻa'kzi bi nakgake' beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Na' gollgake'ne': ―¿Bic̱he wyoozo' ḻoo yoo lill beṉ'ka' bi nak beṉ' Israel na' weej wdaolenzgako'ne'? ");
INSERT INTO zadNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Na'ch Pédrona' golle' ḻegake' yog' ka gok, chi'e: ");
INSERT INTO zadNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Kana' ni zoa yell Jópena', shlak choe'ḻwill' Chioza' ble'do'id' to dii nak ka lech' xen, dii nchej tap yic̱hjten, chetjan xan yabana' na' bla'ten gana' zia'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Na' ka bwiayeṉaa diika' llia ḻoo lechaa, na' ble'id' lle' bayix̱' ba zoa tap ṉi'a na'b, na' no ba zṉia, no ba chx̱obi ḻe'in lo yona', na' ba zoa x̱ilin. ");
INSERT INTO zadNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Na' benid' shii to beṉ' ne' nad': “Wzolla' Pedro, bet baka' na' wdao.” ");
INSERT INTO zadNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Na' goshee: “Bi, X̱an', ni tshii biṉ' gaw' baki bi nak ba xilall'.” ");
INSERT INTO zadNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Na' sto shii benid' shii beena' ne' nad': “Daa ba wna Chioza' wak gawo' bich iṉazo' bi nakan xilall'.” ");
INSERT INTO zadNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Gokte shoṉ shii wne ka', na'tech biyep lech' xenna' yabana'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Na' shintg ble'do'id' diika' kat' bidse shoṉə beṉ' cho'a yoona' gana' zoa', zaake' yell Cesareana' ziddiljgake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Na' Espíritu c̱he Chioza' wne' nad' bi gonc̱hoplallaa sha'len' ḻegake'. Na' lenkz beṉ' bish'choki x̱op wza'lengake' nad', na' yog'tento' wyoonto' lill Cornéliona'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Na' Cornéliona' bseesile' neto' nan ble'ile' to anjl zie' lille'na'. Na' anjla' golle'ne': “Bseḻ' to c̱hop beṉ' yell Jópena' kwenc̱he lljx̱i'gake' beena' le Simón Pedro. ");
INSERT INTO zadNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Na' ḻe' iṉe' li' nakan gono' kwenc̱he yilaleno' beṉ'ka' lle' ḻoo yoo lillo'na' bi kwiayi'le.” ");
INSERT INTO zadNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Na' ka wzoloa' choe'lengakee dill', betj Espíritu Sántona' wyo'e ḻoo yic̱hjlall'do'eka', ka bidsoe' ḻoo yic̱hjlall'do'choki. ");
INSERT INTO zadNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Na'ch jadinid' daa wna X̱ancho Jesúza' kana' wne': “Dii ḻi Juanna' bchoe' beṉ' nis, san le', dii zak'chi gak c̱hele, daa yidsoa Espíritu Sántona' ḻoo yic̱hjlall'do'lena'.” ");
INSERT INTO zadNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ḻa' Chioza' bene' ka zoa Espíritu Sántona' ḻoo yic̱hjlall'do'eka' ka zoe' ḻoo yic̱hjlall'do'choki, cho' chonḻilall'cho X̱ancho Jesucrístona'. Na' ¿nora nak' nad' wllon' gon Chioza' daa cheenile' gone'? ");
INSERT INTO zadNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Na'ch ka biyoll bzenag beṉ' Jerusalénka' nonḻilall' Jesúza' dillaa be' Pédrona', na' wzoagake' llizə, bich bi gollgake'ne'. Na' be'la'ogake' Chioza', che'gake': ―Len beṉ'ka' bi nak beṉ' Israel ba be' Chioza' latj yiyaj yilengakile' dii malka' chongake' kwenc̱he gat' yeḻ' mban c̱hegake' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Na' beṉ' Israelka' nonḻilall' Jesúza', beṉ'ka' bsheshlesgake' ka wde wit dii Estébanna', baḻe' wyaj zit' ax̱t Feníciana', na' zi baḻe' bllin Chíprena' na' zibaḻe' bllin yell Antioquíana'. Na' gana' bllin to toe' be'lengake' to beṉ' wlall c̱he'ka'z xtill' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Per baḻ beṉ'ka' nak beṉ' Chipre na' beṉ' Cirene, ka bllingake' yell Antioquíana', wzologake' be'lengake' beṉ' bi nak beṉ' Israel dill' wen dill' kob c̱he X̱ancho Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Na' yeḻ' wak c̱he X̱anchona' wzoalenan ḻegake', na' beṉ' zan wlej yic̱hjgake' diika' nx̱enilall'gake' na' benḻilall'gake' X̱ancho Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Na' beṉ'ka' nonḻilall' Jesúza' Jerusalénna', ka wṉezgakile' ba nonḻilall' beṉ' Antioquíaka' Jesúza', na' bseḻ'gake' Bernabéna' jawie' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Na' ka blline' Antioquíana', ble'ile' ba goklenchga Chioza' ḻegake' na' ḻe bibaile'. Na' btipche' lall' beṉ'ka' kwenc̱he soac̱hec̱hgake' gonḻilall'gake' X̱ancho Jesúza' do yic̱hj do lall'gake'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Na' beṉ' zanch benḻilall'gake' X̱ancho Jesúza', ḻa' Bernabéna' nake' to beṉ' wen, na' chṉabia' Espíritu Sántona' ḻe', na' ḻe benḻilallee Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Na' ka wde, wza' Bernabéna' zeje' Társona' kwenc̱he lljadilje' Sáulona', na' ka billelile'ne' na' bc̱hi'ene' Antioquíana'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Na' wzoalengake' beṉ'ka' nonḻilall' Jesúza' Antioquíana' twiz, na' bli' bsedgakile' beṉ' zan. Na' Antioquíana' dii nechdo' bsi'gake' beṉ'ka' nonḻilall' Jesucrístona' “Cristianos”. ");
INSERT INTO zadNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Na' do kana'kzə, baḻ beṉ'ka' chyix̱jee daa che' Chioza' ḻegake' wza'gake' Jerusalénna' bllingake' Antioquíana'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Na' wzolla' toe', beena' le Ágabo, na' bi'e dill' ka ba bzajnii Espíritu c̱he Chioza' ḻe', na' golle' kwe' to wbin wal doxen yell-lioni. Na' ka' gok kana' chṉabia' beena' le Claudio gana' mbani Rómana'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Na' beṉ' Antioquíaka' nonḻilall' Jesúza' be'gake' dill' we'gake' kon ka'k' wej gak we' to toe' kwenc̱he gaklengake' beṉ'ka' nonḻilall' Jesúza' gana' mbani Judeana', gana' chi' wbinna'. ");
INSERT INTO zadNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Na' ka' bengake', na' daa bdop bigox̱'gake'n Bernabéna' len Sáulona' kwenc̱he jasangake'n lao beṉ'ka' ngoo lall' na' beṉ'ka' nonḻilall' Jesúza' Judeana'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Na' do kana'kzə beṉ' wṉabia' Heródeza' bex̱ee baḻ beṉ'ka' nonḻilall' Jesúza' kwenc̱he wc̱hi' wsakee ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Na' bc̱hogloe' gueti Jacóbona' yesya, beena' nak beṉ' bish' Juanna'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Na' ka gokbe'ile' bibayi beṉ'ka' chṉabia' beṉ' Israelka' daa bene' ka', na'ch ḻekzka' bex̱ee Pédrona' lo lṉi Paskwa' kana' chaogake' yetxtila' daa bi nc̱hix̱ levadúrana'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Na' ka bdoḻile'ne', wdix̱je'ne' lillyana' gana' wdap shin'to soldadka' ḻe', na' bene' tap weje' kwenc̱he bibeji ljwellgake' wdapgake'ne'. Na' gokile' yiyoll lṉi Paskwa' kweje'ne' lao beṉ' yellka' na' wc̱hogloe' c̱he' guete'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Shlak nej Pédrona' lillyana', beṉ'ka' nonḻilall' Jesúza' toshiizi be'ḻwillgake' Chioza' ni c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Na' lle'na' ka wx̱ezə kwej Heródeza'ne' kwenc̱he wc̱hogloe' c̱he' guete', Pédrona' die' chese' ladj c̱hop soldadka', na' nc̱hejgake'ne' c̱hop gden, na' zi c̱hop soldadka' chapgake' cho'a lillyana'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Na' tokonganzi bllin to anjl c̱he X̱ancho Chioza' gana' de Pédrona' na' to beeni' xen wyoo ḻoo lillyana'. Na' anjla' wdane' kwit ḻi'ena' bisbane'ne', chi'ene': ―Ḻobe'te wyas. Na' katena' biyell gdenka' nchej neena'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Na'ch che' anjla'ne': ―Bikaacha ḻi'ona' na' bilej xelo'na'. Na' ben Pédrona' daa chi'ene', na'ch che' anjla'ne': ―Bix̱oa kolloo xachelo'na', na' da dino' nad'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Na'ch zjano Pédrona' anjla', ni bi ṉezile' shi ka chakkzan, kon gokile' chle'do'zilen'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Na' bidegake' gana' lle' soldadka' shkwen, na' bidetegake' gana' lle' beṉ'ka' zi shkwen, na' ka bllingake' gana' zoa puert de yana' daa ḻiizelote, to kwinzin byaljan na' bichejgake'. Na' ka ba biyoogake' neza', bikwaaṉ anjla' toz Pédrona'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kana'ch gokbe'i Pédrona', na' wne': ―Ṉaach chakbe'id' dii ḻi Chioza' ba bseḻee anjl c̱he'na' kwenc̱he bisle' nad' lo na' Heródeza', na' bi wtiḻ' daa non beṉ' Israelki lez gak c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Na' ka gokbe'ile' ba bicheje' lillyana', na' ziyaje' lill Maríana' xṉa' Juanna', beena' nsi'gake' Marcos. Na' lill Maríana' ndop nllag beṉ' zan choe'ḻwillgake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ka blline', na' wṉie' cho'a leeja', na' bchej to bi' noolə le Rode, jawiab' no beena' chṉe. ");
INSERT INTO zadNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Na' ka biyombia'b' shii Pédrona' chibachgaib', na' daa ḻe chibaib' bikz bsaljb'. Zigaate jayellb' beṉ'ka' lle' ḻoo yoona' ba ze Pédrona' cho'a leeja'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Na'ch che'gake'b': ―Chakzilo'n. Na' ḻeb' wzeyidb' che'b' ḻen'. Na' ḻegake' che'gake'b': ―Anjl c̱he'na'ljan. ");
INSERT INTO zadNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Na' Pédrona' ni zie' chṉie' cho'a leeja'. Na' ka bsaljgake' ble'gakile'ne', bibanchgagakile'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Na'ch Pédrona' bene' to seṉ kon neena' kwenc̱he soagake' llizə, na' golle' ḻegake' ka ben X̱ancho Chioza' bibeje'ne' lillyana'. Na' chi'e ḻegake': ―Ḻi ye' Jacóbona' na' yog' beṉ' bish'choka' ka ba ben X̱anchona' c̱ha'. Na'ch bizee ziyaje' gan yoblə. ");
INSERT INTO zadNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Na' ka wyeeni', wche' to yeḻ' wban xen ladj soldadka' daa bi gokbe'gakile' nak gok bichej Pédrona'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Na'ch Heródeza' bta bṉie' beṉ'ka' biyiljgake'ne', na' bi billelgakile'ne'. Na'ch wṉabile' soldadka' chap lillyana' nak gok bicheje', na' bikz bi dill' be'gake'. Na'ch bene' mandad betgake' soldadka'. Na' ka wde bene' ka', wzee Judeana' jsoe' Cesareana'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heródeza' chllee beṉ' Tíroka' na' beṉ' Sidónka'. Na' beṉ'ki gokgake' toz bshaljlengake' Blástona', to wen llin zakii c̱he Heródeza', na' bengakile'ne' wen kwenc̱he goklene' ḻegake', ḻa' byalljgakile' si'gake' dii yeej gaogake' gana' chṉabia' Heródeza'. Na' Blástona' bshaljlene' Heródeza' kwenc̱he wxi'xene' c̱he beṉ' Tíroka' na' beṉ' Sidónka' na' yizoalene' ḻegake' wen sto shii. ");
INSERT INTO zadNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Na' Heródeza' bllie' bia' batan lljawiagake'ne'. Na' gokwe' xe'na' daa ḻe nak daa chakwe' kat' chli'lawe' lao lkwe' beṉ'. Na'ch jshie' gana' chc̱hogloe' c̱he beṉ', na' bi'e dill' lao beṉ'ka' ndop nllag na'. ");
INSERT INTO zadNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Na' shlak cho'e dill', na' besyaa beṉ'ka' che'gake': ―To chioza'n chṉe, aga konteḻe beṉaan. ");
INSERT INTO zadNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Na' anjl c̱he X̱ancho Chioza' lii be'tie' Heródeza' to yillwe' wal benan ka chyiṉ chḻall' beḻ bzog'ka' ḻoo ḻi'ena' na' wite', daa bi'e latj wloo beṉ'ka' ḻe' balaaṉ daa chidoḻ' toz beena' nak dowalj Chios. ");
INSERT INTO zadNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Na' dill' wen c̱he Chioza' zej chlliljchan doxen. ");
INSERT INTO zadNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Na' Bernabéna' len Sáulona' ka wde bengake' daa chiyaḻ' gongake' Jerusalénna', biza'gake' biyajgake' Antioquíana', na' bc̱he'gake' Juanna', beena' ḻekzka' nsi'gake' Marcos. ");
INSERT INTO zadNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Na' ladj beṉ'ka' nonḻilall' Jesúza' yell Antioquíana' lengake' beṉ' chyix̱jee daa che' Chioza' na' beṉ' chli' chsedi cho'a xtill' Chioza'. Na' ḻegake' beṉ'ki: Bernabéna', Simónna', beena' che'gake' beṉ' gasj, Lúciona' beṉ' Cirénena', Sáulona' na' Manaénna', beena' bgol-len Heródeza' beena' wṉabia' gana' mbani Galileana'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Na' to shii ka zoagake' wbasaa na' choe'la'ogake' Chioza' wṉe Espíritu Sántona' ḻegake', chi'e: ―Ḻi wzoa Bernabéna' na' Sáulona' kwenc̱he gongake' xshin'na', ḻa' ni c̱heyinnan' ba wlej' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Na' ka wyeelo be'ḻwillgake' Chioza' na' biyoll wzoagake' wbasaa, na' bx̱oa neeka' yic̱hj beṉ'ka' c̱hop, na'ch bseḻ'gake' ḻegake' gana' lljengake' xshin Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Na'ch Espíritu Sántona' bseḻee Bernabéna' na' Sáulona' yell Seleúciana' gana' wyoogake' barkwa' kwenc̱he jwaan ḻegake' yell-lio Chíprena' daa llia lo nisdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Na' ka wlez barkwa' cho'a yell Salamínana', bchejgake' na' wzologake' wdix̱je'gake' cho'a xtill' Chioza' to to gana' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza'. Na' nc̱he'gake' sto beṉ' le Juan kwenc̱he gaklene' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Na' wdegake' to to yellka' llia Chíprena'. Na' ka bllingake' yell Páfoza', na' jadi'gake' to beṉ' Israel, beena' le Barjesús. Nake' to beṉ' willa', na' chziyee beṉ' chi'e nake' to beṉ' chyix̱jee daa che' Chioza' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Na' beeni nllaguile' beena' chṉabi'e doxen Chíprena', beena' le' Sergio Paulo. Na' Sergio Paulona' nake' to beṉ' chajnii, na' goxe' Bernabéna' len Sáulona' kwenc̱he wzajni'gakile'ne' cho'a xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Na' beṉ' willa'na', nsi'gake'ne' Elimas (na' zejin beṉ' willa'), goklallee gone' ka bi shajḻe' beṉ' wṉabia'na' c̱he cho'a xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Na'ch Sáulona', beena' ḻekzka' lie' Pablo, daa chṉabia'chga Espíritu Sántona' ḻe', bwiayeṉee Elímaza', ");
INSERT INTO zadNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","na' golle'ne': ―¡Li' ben' wxiye', beṉ' wen dii mal, xiiṉ dii x̱iwaan nako' na' chakzbanilo' yog' daa nak dii wen! ¿Bic̱he chshok chlewzo' daa nak dii ḻi c̱he X̱ancho Chioza'? ");
INSERT INTO zadNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Na' ṉaa Chioza' wseḻee yeḻ' zi' c̱ho', gone' ka ic̱hoḻo' na' shloll wen bich ile'ilo' beeni' c̱he wbilla'. Na' kate golle'ne' ka' lii wc̱hoḻtie', na' chgan chtobzile' chṉabe' no yiyox̱' neena' daa bich chle'ile'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Na' ka ble'i beṉ' wṉabia'na' daa gok, na' wyajḻi'e, na' le bibanile' ka nak cho'a xtill' X̱ancho Jesúza' daa chli' chsedgakile'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Na'ch Páblona' na' beṉ'ka' chdalene' wyoogake' barkwa' yell Páfoza' na' wyajgake' yell Pérgena' daa llia gana' mbani Panfíliana', na' Juan Márcona' bixoṉje' ziyaje' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Na' Páblona' len beṉ'ka' chdalene' na', biza'gake' yell Pérgena' na' wyajgake' yell Antioquíana' daa llia gana' mbani Pisídiana'. Na' ka bllin lla sabda', llana' chombaaṉ beṉ' Israelka', wyajgake' gana' chdop chllaggake' choe'ḻwillgake' Chioza', na' jc̱he'lengake' beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Na' ka biyoll blabgake' lat' ley c̱he Chioza' na' zi lat' daa bzej dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake', na'ch beṉ'ka' chgoo xṉezi c̱heyi diika' chongake' gana' chdop chllaggake' bseḻ'gake' to beṉ' gana' chi' Páblona' len Bernabéna' na' golle' ḻegake': ―Le' beṉ' bish', shi bi dill' de we'lenle beṉ'ki kwenc̱he wtipch lall'gake', wak we'len ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Na'ch wzolla' Páblona' na' bḻis neena' kwenc̱he kwe'gake' llizə wzenaggake', na' chi'e: ―Le', beṉ' Israel, na' le' bi nakle beṉ' Israel choe'la'ole Chioza', ḻi wzenag dga iṉia': ");
INSERT INTO zadNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Chios, beena' nonḻilall'cho cho' beṉ' Israel, wleje' dii x̱ozxto'choka' na' bene' ka wyangake' shlak wzoagake' Egíptona'. Na' bllin lla bibeje' ḻegake' kon yeḻ' wak c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Na' wdape' yeḻ' chxenlall' c̱he yeḻ' widenag c̱he'ka' lo c̱hoa yiza' wzoagake' latja' gana' bibi chashj chḻeb. ");
INSERT INTO zadNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Na' blliayee yellka' gall kwen lle' gana' mbani Canaánna' kwenc̱he bi'e dii x̱ozxto'choka' yell-lio c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kan' gok lawi tap guiyoa yoo gashj yiz. Na'tech, bzoa' Chioza' beṉ'ka' wloo lall' na'gake' ḻegake', ax̱t nika bllin lla wzoa dii Samuela', beena' wdix̱jee daa goll Chioza'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Na'ch wṉabgake' soa to beṉ' wṉabia' kwenc̱he iṉabi'e ḻegake'. Na' Chioza' bi'e ḻegake' dii Saúla', beena' wṉabi'e ḻegake' lo c̱hoa yiz. Goke' xiiṉ dii beena' wle Cis, beena' gok xiiṉ dia c̱he dii Benjamínna'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Na' ka bikwas Chioza' yeḻ' wṉabia' c̱he dii Saúla', bizoe' dii Davina' iṉabi'e na' bi'e dill' c̱he', wne': “Davina', xiiṉ Isaína', nake' to beṉ' chon ka chazlallaa, na' ṉezid' gone' yog' daa cheenid' gone'.” ");
INSERT INTO zadNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Na' lo dia c̱he dii Davina' golj Jesucrístona', beena' wlej Chioza' kwenc̱he yisle' cho' beṉ' Israel lawi dii mala' kon ka' bc̱hebe' gone'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Na' ka zi' solo Jesúza' wli' wsedile' beṉ', dii Juanna' golle' yog' beṉ' Israelka' chiyaḻ' yiyaj yilengakile' xtoḻeeka' na' c̱hoagake' nisa'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Na' ka ba zoa yiyoll gon dii Juanna' daa nak lall' nee gone', na' ba zoate illin lla guete', na' wne': “Bi nak' beena' chakile nak'. Zi' za'lə beena' zak'ch ka nad'. Na' nad' ni bi zakaa gak' xmose' kwenc̱he wḻec̱hj' xele'na'.” ");
INSERT INTO zadNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Le' beṉ' bish', le' nakle xiiṉ dia c̱he dii Abrahama', na' le' choe'la'ole Chioza' ḻa'kzi bi nakle beṉ' Israel, Chioza' ba bseḻee cho'a xtilleena' laochoni daa cho'en dill' yisle' beṉ' kwenc̱he bi kwiayi'gake'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Beṉ' Jerusalénka' na' beṉ' wṉabia' c̱he'ka' bi gokbe'gakile' bseḻ' Chioza' Jesúza'. Ni bi wyajni'gakile' diika' bzej dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yi, ḻa'kzi chlabgake'n yog' lla sabd gana' chdop chllaggake' choe'ḻwillgake'ne'. Na' daa wnagake' chiyaḻ' guet Jesúza', billinin daa bzej dii beṉ'ka' be' dill' daa goll Chioza' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ḻa'kzi bibi dii mal billelgakile' ben Jesúza' dii gonan ka wc̱hoglogake' witgake'ne', wṉabgakile' Pilátona' gone' mandad witgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Na'ch ka biyoll bengakile'ne' yog' daa nyoj ḻee cho'a xtill' Chioza' gak c̱he', na'ch biḻetjgake'ne' ḻee yag cruza' na' jakwash'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Na' Chioza' biḻise'ne' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Na' ka wde bibane', zan lla bli'lawe' beṉ'ka' wno wnaḻ'gake'ne' dezd ka wzee Galileana' zeje' Jerusalénna'. Na' ḻegaken' choe'lengakee beṉ' wlall c̱hechoka' xtilleena' ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Na' chyix̱je'into' le' dill' wen dill' kob c̱he Jesúza' daa bc̱heb Chioza' lao dii x̱ozxto'choka'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Na' ṉaa ba biyoll bido bene' ka bc̱hebe' gone' c̱hecho, cho' nakcho xiiṉ dia c̱hegake', daa bisbane' Jesúza' ladj beṉ' wetka'. Gok ka nyoj Salmo de wchopina', gana' nan: “Lin' nako' Xiiṉ', na' ṉaa, daa solo iṉabi'o na' iṉezi beṉ' nadaan nak' X̱o'.” ");
INSERT INTO zadNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Chioza' ba bi'e dill' yiḻise'ne' ladj beṉ' wetka' na' bichga guete', na' wne': “Dii ḻi gaklen' le' dii xen wal ka bc̱heb' lao dii Davina'.” ");
INSERT INTO zadNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Na' ḻekzka' sto Salmo nan: “Bi wi'o latj gooll' iteb beli chen c̱ha'ni, daa nak' lall' no'.” ");
INSERT INTO zadNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Na' ṉezicho dii Davina' goklene' dii x̱ozxto'choka' kon ka bllia Chioza' bi'a gone', na' ka bllin lla wite' jakwash'gake'ne' gana' bkwash'gake' dii x̱ozxtoe'ka', na' gooll' bteb beli chen c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Per kwerp c̱he Jesúza', beena' bisban Chioza' ladj beṉ' wetka', bi wlliayi'n. ");
INSERT INTO zadNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Le' beṉ' bish', chyix̱je'into' le' Chioza' chizi'xene' xtoḻ' nottez beṉ' chonḻilallee Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Nottez beṉ' gonḻilalleene' yiyake' beṉ' ḻi beṉ' shao' lao Chioza'. Aga no yiyak beṉ' ḻi beṉ' shao' lao Chioza' daa chone' daa na ley c̱he dii Moiséza'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Na' ḻi wsak' kwenc̱he ki gak c̱hele ka bzej dii beṉ'ka' be' dill' daa goll Chioza' ḻegake' kani'yi, gana' nan: ");
INSERT INTO zadNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ḻi wwia, le' beṉ' wenḻe. Ḻi yibani. Wllin lla kwiayi'le daa bi chajḻe'le. Llaki mbanle gon' to dii wal dii bi shajḻe'le ḻa'kzi shi no iṉa le' ki gak. ");
INSERT INTO zadNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Na' ka bichejlen Páblona' beṉ'ka' nakgake'ne' txen gana' chdop chllag beṉ' Israelka', na'ch beṉ'ka' bi nak beṉ' Israel wṉabgakile'ne' we'lene' ḻegake' cho'a xtill' Chioza' lla sabda' sto. ");
INSERT INTO zadNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Na' ka billeshgake', zan beṉ' Israelka', na' zan beṉ'ka' chongake' ḻegake' txen choe'la'ogake' Chioza', janogake' Páblona' len Bernabéna'. Na' Páblona' len Bernabéna' gollgake' ḻegake' chiyaḻ' soac̱hec̱hgake' gonḻilall'gake' Chioza' daa ḻe chakile' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na' ka bizoa xmanna' sto, llana' chombaaṉ beṉ' Israelka', zi lat'z ki biya beṉ'ka' lle' yella' bdop kwenc̱he wzenaggake' cho'a xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Na' ka ble'i beṉ' Israelka' beṉ' zan ndop nllag, na' gokxe'gakile' Páblona' na' wṉegake' zban c̱he dillaa cho'e, na' biya dii wnagake' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Na'ch Páblona' len Bernabéna' aga bllebgake', na' gollgake' beṉ' Israelka': ―Benan byen zigaate le' wzajniinto' cho'a xtill' Chioza'. Per daa bi cheenile wzenaglen, chli'le bi chidoḻ'le goṉ Chioza' yeḻ' mban c̱hele zejḻi kaṉi, na' solochoklənto' ṉaa wzajniinto'n beṉ'ka' bi nak beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ḻa' dgan non X̱ancho Chioza' mandad gonnto', na' ne': Ba bzoa' li' kwenc̱he gono' ka sho' beeni' c̱ha'na' ḻoo yic̱hjlall'do' beṉ'ka' bi nak beṉ' Israel. Na' yoo beṉ'ka' lle' doxen yell-lioni ka gongake' kwenc̱he yilagake' na' bi kwiayi'gake'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Na' beṉ'ka' bi nak beṉ' Israel, ka bengakile' daa wna Páblona' len Bernabéna', ḻe bibagakile' na' wnagake' ḻe mba nak cho'a xtill' Chioza'. Na' yog' beṉ'ka' ba wlej Chioza' kwenc̱he gat' yeḻ' mban c̱hegake' zejḻi kaṉi benḻilall'gake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ka' gok bllilj cho'a xtill' X̱ancho Jesúza' doxen na'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Na' beṉ' Israelka', beṉ'ka' bi wyajḻe'gake' c̱he Jesúza', wlooyeḻ'gake' baḻ noolə wnia'ka', beṉ'ka' choe'la'o Chioza', na' beṉ' byoka' ḻe zeyi c̱heyin yella' kwenc̱he bengakile' Páblona' na' Bernabéna' zban, na' bilaggake' ḻegake' yell c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Na'ch Páblona' len Bernabéna' ka biza'gake' wllib ṉi'eka' bishte c̱he yella' daa bi goklall' beṉ'ka' lle' na' wzenaggake' c̱he Chioza'. Na' wyajgake' yell Icóniona'. ");
INSERT INTO zadNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na' beṉ'ka' nonḻilall' Jesúza' wzoachgagake' mbalaz, na' Espíritu Sántona' wṉabi'e ḻoo yic̱hjlall'do'eka'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Na' ka bllin Páblona' len Bernabéna' Icóniona', wyajgake' gana' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza'. Na' Chioza' goklene' ḻegake' ka be'gake' cho'a xtilleena' kwenc̱he beṉ' zan benḻilall'gake' Jesúza', ka beṉ' Israel na' ka beṉ' bi nak beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Na' beṉ' Israelka', beṉ'ka' bi goni shajḻe' c̱he Jesúza', wlooyeḻ'gake' baḻ beṉ'ka' bi nak beṉ' Israel kwenc̱he gokzbangakile' beṉ'ka' nonḻilall' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Daan bigaaṉ Páblona' len Bernabéna' Icóniona' ssha, na' be'gake' xtill' X̱ancho Jesúza' na' bi bllebgake', ḻa' nx̱enilall'gake' zoalen X̱ancho Chioza' ḻegake'. Na' X̱anchona' goklene' ḻegake' bli'gake' yeḻ' wak c̱he'na' kwenc̱he gokbe'i beṉ' nan choe'gake' dill' ḻi. ");
INSERT INTO zadNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Na' beṉ' Icónioka' gokgake' c̱hoplə, baḻe' wda'gake' beṉ' Israelka' na' zi baḻe' wda'gake' Páblona' len Bernabéna'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Na'ch beṉ' Israelka' bengake' txen beṉ'ka' bi nak beṉ' Israel na' gokgake' toz len beṉ' wṉabia'ka', goklall'gake' yiya dii gongakile' Páblona' len Bernabéna' na' wlliagake' ḻegake' yaj. ");
INSERT INTO zadNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Na' ka wṉezi Páblona' len Bernabéna' ka ba chwia beṉ'ka' gongakile' ḻegake', lii biza'tegake', wyajgake' yell Lístrana' na' yell Dérbena', yellka' llia gana' mbani Licaóniana'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Na' ḻekzka' be'gake' dill' wen dill' kob c̱he Jesúza' na'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Na' Lístrana' jadi'gake' to beṉ' nxiṉj ṉi'ena' ka goljtie'. Na' bi chak see daa bi chzoa c̱hec̱h ṉi'ena'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Na' chi'e chzenague' dillaa choe' Páblona'. Na' Páblona' chwie'ne' na' gokbe'ile' chajḻi'e wak yiyon Chioza' ḻe' kwenc̱he gak see. ");
INSERT INTO zadNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Na'ch golle'ne' zillj: ―Wzolla'. Na' lii wzolla'tie' na' gok wzee. ");
INSERT INTO zadNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ka ble'i beṉ' Lístraka' daa ben Páblona', wzolo chosyaagake' chṉegake' xtilleeka' daa nak dill' Licaonia che'gake': ―¡Ba betj chios c̱hechoka' gani zoacho na' chle'gakichone' ka beṉec̱h! ");
INSERT INTO zadNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Na' wnagake' Bernabéna' nake' chios c̱he'ka' beena' nsi'gake' Júpiter, na' Páblona' nake' chios c̱he'ka' beena' nsi'gake' Mercurio, ḻa' ḻen' cho'e dillaa. ");
INSERT INTO zadNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Na' bx̱oz c̱he yoodo' c̱he Júpitera', daa zoa katez choogake' yella', jwee gooṉka' na' nwaḻee ḻegakb bga de yej, na' ḻe', na' beṉ'ka' ndop nllag na', goklall'gake' witgake' ḻegakb kwenc̱he we'la'ogake' Páblona' len Bernabéna'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Na' ka gokbe'i Bernabéna' len Páblona' bin gon beṉ'ka', na' wzologake' bc̱hez' xe'ka', ḻa' chakgakile' dii mal nlleban chon beṉ'ka'. Na' jsedogake' ladje'ka', na' wṉegake' zillj, che'gake': ");
INSERT INTO zadNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―Le' beṉ'do', ¿berac̱he chonzle ka'? Ḻekzka' beṉ' yell-lioz neto', ka le', na' ba bidnto' kwenc̱he wzajniinto' le' chiyaḻ' kwejyic̱hjle diiki bibi zak' na' gonḻilall'le Chios, beṉ' yaa beṉ' banna', beena' ben yabana', yell-lioni, na' nisdo'na', na' yog' dii de xan yabana', lo yell-lioni, na' ḻoo nisdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kani'yi Chioza' bwialoze' c̱he beṉec̱ha' bengake' kon daa nazan c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Na' ḻa'kzi bwialoze' ka bengake', bliile' ḻegake' yeḻ' wak c̱he'na' kwenc̱he ka' gakbe'gakile' zoe'. Ḻa' ḻen' chone' yeja' kwenc̱he chak dii chaz chaaṉcho na' chat' dii cheej chaocho kwenc̱he soacho mbalaz. ");
INSERT INTO zadNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Na' ḻa'kzi Páblona' len Bernabéna' gollgake' ka', kaṉi goongakile' bi witgake' gooṉka' daa nan we'la'ogake' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Na' bllin baḻ beṉ' Israelka' zaak Antioquíana' na' Icóniona', na' wlooyeḻ'gake' beṉ' Lístraka' kwenc̱he blliagake' Páblona' yaja'. Na' daa gokgakile' ba witen', na'ch bx̱obgake'ne' jadix̱jgake'ne' cho'a yella'te. ");
INSERT INTO zadNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Na' beṉ'ka' nonḻilall' Jesúza' bdi'a bllaggake' gana' de Páblona', na' biyase' biyo'e yella' sto shii. Na' betiyo bizee len Bernabéna' na' biyajgake' yell Dérbena'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Na' ḻekzka' wdix̱jeegake' dill' wen dill' kob c̱he Jesúza' yell Dérbena', na' beṉ' zan benḻilall'gake' Jesúza'. Na'tech, biza'gake' bidegake' yell Lístrana', Icóniona' na'ch Antioquíana'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Na' to to yellka' gana' bidegake' btipgake' lall' beṉ'ka' ba chajḻe' c̱he Jesúza' kwenc̱he soac̱hec̱hgake' gonḻilall'chgake'ne'. Na' gollgake' chiyaḻ' yizo yizakicho bittez dii yen ile'icho kwenc̱he gak lljazoalencho Chioza' gana' chṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Na' to to yellka' wlejgake' to c̱hop beṉ' koo lall' na'gake' beṉ'ka' ba nonḻilall'gake' Jesúza'. Na' wzoagake' wbas' be'ḻwillgake' Chioza', na'ch bengake' ḻegake' lall' na' X̱ancho Jesúza', beena' nonḻilall'gake'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Na' wde Páblona' len Bernabéna' gana' mbani Pisídiana' na' bllingake' gana' mbani Panfíliana'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Na' be'gake' cho'a xtill' Chioza' yell Pérgena'. Na'ch biza'gake' ziyajgake' yell Atáliana'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Na' yell Atáliana' biyoogake' to ḻoo barkw na' billingake' yell Antioquíana' gana' lle' beṉ'ka' bengake' ḻegake' lo na' Chioza' kana' bseḻ'gake' ḻegake' lljengake' llinna' daa ba biyoll jengake'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Na' ka billingake' yell Antioquíana', btopgake' beṉ'ka' nonḻilall' Jesúza', na' gollgake' yog' daa goklen Chioza' ḻegake' to to yellka'. Na' ḻekzka' gollgake' ka ben Chioza' bi'e latj c̱he beṉ'ka' bi nak beṉ' Israel kwenc̱he benḻilall'gake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Na' Páblona' len Bernabéna' bigaaṉgake' ssha yell Antioquíana' len beṉ'ka' nonḻilall' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Shlak zoa Páblona' len Bernabéna' yell Antioquíana', bllin baḻ beṉ' za' Judeana' na' wzologake' bli' bsedgakile' beṉ'ka' nonḻilall' Jesúza' nan chiyaḻ' gongake' ka na ley c̱he dii Moiséza' na' sho'gake' seṉ daa le circuncisión kwenc̱he Chioza' wi'e yeḻ' mban c̱hegake' zejḻi kaṉi. ");
INSERT INTO zadNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Na' Páblona' len Bernabéna' gokdiḻ-lengake' beṉ' Judeaka'. Na' daa gok ka', beṉ' Antioquíaka' bengake' toz dill' wseḻ'gake' Páblona' len Bernabéna' na' sto c̱hop beṉ' yell Jerusalénna' kwenc̱he llje'lengake' postlka' dill' len beṉ'ka' ngoo lall' na'gake' beṉ'ka' nonḻilall' Jesúza' Jerusalénna', c̱heyi daa chli' chsedi beṉ' Judeaka' bllin Antioquíana'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Na' wloogake' nez kon ka goll beṉ'ka' nonḻilall' Jesúza' Antioquíana', na' lo ka zejgake' wdegake' gana' mbani Feníciana' na' gana' mbani Samáriana', na' gollgake' beṉ'ka' nonḻilall' Jesúza' ka ba wyanchga beṉ'ka' bi nak beṉ' Israel ba yoogake' lo xṉez Chioza'. Na' ka beni beṉ'ki dga, ḻe bibagakile'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ka bllin beṉ'ki Jerusalénna', beṉ'ka' nonḻilall' Jesúza' len beṉ'ka' ngoo lall' na' ḻegake' na' postlka' blebgake' ḻegake'. Na' Páblona' len Bernabéna' gollgake' ḻegake' yog' daa ba goklen Chioza' ḻegake' jengake'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Na' baḻ fariseoka' nonḻilall' Jesúza' wzolla'gake' na' wnagake': ―Beṉ'ka' bi nak beṉ' Israel chonan byen sho'gake' seṉ daa le circuncisión ka solo gonḻilall'gake' Jesúza', na' chiyaḻ' gongake' ka na ley c̱he dii Moiséza'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Na' bdop bllag postlka' len beṉ'ka' ngoo lall' na'gake' beṉ'ka' nonḻilall' Jesúza' kwenc̱he wwiagake' naklə ka sho' xṉezi dga. ");
INSERT INTO zadNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ba gok ssha chdiḻ cho'a xtilleeka' ka wzolla' Pédrona' na' golle' ḻegake': ―Le', beṉ' bishaa, ba ṉezkzile kana' wlej Chioza' nad' ladjleni kwenc̱he llji'a dill' wen dill' kob c̱he Jesúza' lao beṉ'ka' bi nak beṉ' Israel kwenc̱he gonḻilall'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Chioza', beena' nombi'e yic̱hjlall'do' yog' beṉ', bli'e nan chlebe' beṉ'ka' bi nak beṉ' Israel daa bseḻee Espíritu Sántona' zoe' ḻoo yic̱hjlall'do'eka' kon ka bene' c̱hecho. ");
INSERT INTO zadNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Toz ka ba ben Chioza' c̱hecho na' c̱he beṉ'ka', ḻa' ḻekzka' ba biyib bix̱ise' ḻoo yic̱hjlall'do'eka' daa ba nonḻilall'gake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Na' ¿berac̱he bi chajḻe'le daa ba ben Chioza'?, na' ¿bic̱he cheenile gon beṉ'ka' bi nak beṉ' Israel diiki? Ḻa' ni cho' ni dii x̱ozxto'choka' biṉ' sakicho gonchon. ");
INSERT INTO zadNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ḻete chajḻe'cho daa chaki X̱ancho Jesúza' chon' ba bisle' cho', na' ka'kz ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Na' yoguee wzoagake' llizə bzenaggake' shlak Páblona' len Bernabéna' be'gake' dill' ka ben Chioza' goklene' ḻegake' bengake' yeḻ' wakka' ladj beṉ'ka' bi nak beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Na' ka biyoll be' Páblona' len Bernabéna' dill', na'ch wṉe Jacóbona', golle': ―Le' beṉ' bish', cheenid' wzenagle dga iṉia' le': ");
INSERT INTO zadNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pédroni ba bi'e dill' ka wzolo Chioza' wleje' beṉ' ladj beṉ'ka' bi nak beṉ' Israel kwenc̱he gakgake' lall' nee. ");
INSERT INTO zadNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Na' dga gok ka' chidiḻ-lebin daa bzej dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yi, gana' nan: ");
INSERT INTO zadNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ka te dga, yiyed' na' wzoa' to xiiṉ dia c̱he dii Davina' iṉabi'e. Ḻa'kzi yeḻ' wṉabia' c̱he'na' nakan ka to yoo dii ba biyiṉj, wllin lla yic̱hisa'n. ");
INSERT INTO zadNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Gon' dga kwenc̱he yog' beṉ'ka' biṉ' gonḻilall'gake' nad' yiyiljgake' nad', lente yog'ḻoḻ beṉ'ka' bi nak beṉ' Israel, beṉ'ka' ba nak lall' na'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kan' wna X̱ancho Chioza', beena' bzajniile' beṉ'ka' diiki kani'teyi. ");
INSERT INTO zadNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Na'chan nia' le', bi chiyaḻ' ye'cho beṉ'ka' bi nak beṉ' Israel, beṉ'ka' ba nonḻilall'gake' Chioza', gongake' dii bi chonan byen. ");
INSERT INTO zadNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kon wzejcho to yish ye'chogake' bich gaogake' yeḻ' wawa' daa chllia beṉ' lao lwaa lsak' chios c̱he'ka', na' bi gaogake' bel' c̱he bayix̱'ka' bi wlalj xc̱hema', na' ni bi gaogake' xc̱hen bayix̱'ka'. Na' ḻekzka' bi iṉelenzgake' xiiṉ xool beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ḻa' kani'teyi zoakzə beṉ' to to yell chzajni'gakile' beṉ' ley c̱he dii Moiséza', na' ḻennan' ni chlabgake' ṉaa gana' chdop chllaggake' choe'ḻwillgake' Chioza' yog' lla sabd. ");
INSERT INTO zadNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Na'ch postlka', na' yog' beṉ'ka' nonḻilall' Jesúza' len beṉ'ka' ngoo lall' na' ḻegake' bengake' toz dill' wlejgake' to c̱hop beṉ' ladje'ka' kwenc̱he shajlengake' Páblona' len Bernabéna' Antioquíana'. Na' wlejgake' Judas, beena' ḻekzka' lie' Barsabás, na' Sílaza', nakgake' beṉ' mbejlawin ladj beṉ'ka' nonḻilall' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Na' bseḻ'lengake' beṉ'ki to yish dii bzejgake', na' ki choe'n dill': “Le' beṉ' bish' na' le' beṉ' zannto', le' bi nakle beṉ' Israel na' zoale yell Antioquíana', na' doxen gana' mbani Síriana' na' Cilíciana', neto' postl na' beṉ'ki ngoo lall' na' beṉ'ka' nonḻilall' Jesúza' Jerusalénni, na' yog' beṉ' bish'choki lle' ni, chwapnto' le' chiox. ");
INSERT INTO zadNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ba wṉezinto' ba bchej to c̱hop beṉ' ladjnto'ni bidgake' to bia'lall'zgake' gana' zoale, na' benllejgakile' le' daa wnagake' chiyaḻ' sho'le seṉ daa le circuncisión, na' chiyaḻ' gonle doxen ka na leya'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Daan, ba bennto' toz dill' wlejnto' beṉ'ki c̱hop ladjnto'ni zidwiagake' le'. Na' chseḻ'lennto' ḻegake' Pábloni na' Bernabéni, beṉ' bish'choki ḻe chakicho, ");
INSERT INTO zadNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","beṉ'ki chzoa dii nxoll yeḻ' mban c̱he'ka' daa chongake' x̱shin X̱ancho Jesucrístona'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Na' chseḻ'nto' beṉ'ki le Judas na' Silas, na' ḻegake' wzajni'gakile' le' dga chzejnto' le'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Na' wyazlall'nto' ka bzajnii Espíritu Sántona' neto' bi wzoanto' le' gonle dii bi yizoile. Diikizə chakinto' chonan byen bi gonle: ");
INSERT INTO zadNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Bi gaole yeḻ' wawa' daa chllia beṉ' lao lwaa lsak' chios c̱he'ka', na' ni bi gaole bel' c̱he bayix̱'ka' shi bi wlalj xc̱hema', ni bi gaole xc̱hen bayix̱'ka', na' ḻekzka' bi iṉelenzle xiiṉ xool beṉ'. Shi wzenagle diiki nannto' le', wenkzan chonle. Ka'tz nak dill'ki chzejnto' le'.” ");
INSERT INTO zadNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Na'ch ka bllin beṉ'ka' bseḻ'gake' Antioquíana', na' btopgake' yog' beṉ'ka' nonḻilall' Jesúza', na' be'gake' ḻegake' yisha' daa nox̱'gake'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Na' ka blabgake'n ḻe bibagakile' ka dillaa choe'n. ");
INSERT INTO zadNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Na' ka nak Júdaza' na' Sílaza', daa ḻekzka' nakgake' beṉ' chyix̱jee daa che' Chioza' ḻegake' be'gake' dill' zan dii btipan lall'gake' na' goklenan ḻegake' wzoatip wzoashoshchgake'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Na' biyoll wzoalengake' ḻegake' shloll wen, na'ch beṉ'ka' nonḻilall' Jesúza' Antioquíana' mbalaz biḻaagake' ḻegake' dill' na' biyajgake' kwit beṉ'ka' bseḻ' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Na' Sílaza' wyazlallee igaaṉe' na'z. ");
INSERT INTO zadNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Páblona' na' Bernabéna' bigaaṉgake' Antioquíana'. Na' len zan beṉ' yoblə bli' bsedchgakile' beṉ' cho'a xtill' X̱ancho Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Na' ba gok zan lla zoagake' Antioquíana' ka goll Páblona' Bernabéna': ―Shajcho dii yoblə yellka' gana' ba je'cho cho'a xtill' X̱ancho Jesúza' kwenc̱he lljawiacho nak chak c̱he beṉ'ka' ba wyajḻe'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Na' Bernabéna' goklallee wc̱he'gake' Juan, beena' ḻekzka' nsi'gake' Marcos. ");
INSERT INTO zadNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Na' bi gooni Páblona' wc̱he'gake'ne', ḻa' kana' bc̱he'gake'ne' bixoṉje' na' bkwaaṉe' ḻegake' Panfíliana', na' bich jenlene' ḻegake' xshin Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Na' ni c̱heyin, gokguedgake' na' wlaagake'. Bernabéna' wzee bc̱hi'e Márcona' na' wyoogake' to ḻoo barkw na' wyajgake' Chíprena'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Na' Páblona' wzee bc̱hi'e Sílaza'. Na' beṉ'ka' lle' Antioquíana', beṉ'ka' nonḻilall' Jesúza', wṉabgakile' X̱ancho Chioza' gaklene' ḻegake' gattezə shajgake'. ");
INSERT INTO zadNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Na' Páblona' len Sílaza' wdegake' gana' mbani Síriana' na' Cilíciana' kwenc̱he goklengake' beṉ'ka' nonḻilall' Jesúza' wzoatip wzoashoshchgake'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Na'ch Páblona' len Sílaza' bllingake' yell Dérbena', na'tech wyajgake' yell Lístrana'. Na' na' zoa to bi' xkwid' nonḻilall'b' Jesúza' leb' Timoteo. Nakb' xiiṉ to noolə Israel, na' nooli nonḻilallee Jesúza', per x̱abaa nake' beṉ' griego. ");
INSERT INTO zadNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Na' beṉ' Lístraka' len beṉ' Icónioka' nonḻilall' Jesúza' be'gake' dill' ḻe wen nsa' c̱heb'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Na' Páblona' wṉabile'b' shajlem' ḻegake', na' wlo'eb' seṉ daa le circuncisión kwenc̱he bi gakzbani beṉ' Israelka' ḻeb', ḻa' ṉezgakile' x̱abaa bi nake' beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Na' yog' yellka' gana' wdegake' be'lengake' beṉ'ka' nonḻilall' Jesúza' dill' c̱he diika' chiyaḻ' gongake', diika' be' postlka' dill' kon beṉ'ka' ngoo lall' na'gake' beṉ'ka' nonḻilall' Jesúza' yell Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Na'ch beṉ'ka' nonḻilall' Jesúza' yellka' benḻilall'chgake'ne' do yic̱hj do lall'gake', na' lla kon lla wyanchgake'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Páblona' len Sílaza' na' Timotewa' to wdezgake' gana' mbani Frígiana' len Galáciana', daa bi be' Espíritu Sántona' latj llje'gake' cho'a xtill' Chioza' gana' mbani Ásiana'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Na' ka bllingake' gaoz yell-lio gana' le Misia, wnalall'gake' shajgake' gana' mbani Bitíniana', na' ḻekzka' bi be' Espíritu Sántona' latj shajgake' na'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Na'ch wdegake' yell-lio c̱he Mísiana' bllintegake' yell Tróaza' daa llia cho'a nisdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Na' lo yela' Chioza' bene' ka ble'do'i Páblona' to beṉ' byo, beṉ' Macedonia, zie' chat'yoile'ne', chi'ene': “Dagach Macedóniani kwenc̱he gakleno' neto'.” ");
INSERT INTO zadNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Na' ka biyoll ble'do'i Páblona', lii bsini'ate c̱hento' kwenc̱he wyajnto' Macedóniana', ḻa' wyajniinto' Chioza' cheenile' shajnto' llje'lennto' beṉ'ka' lle' na' dill' wen dill' kob c̱he Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Na' yell Tróaza' wyoonto' barkwa' na' wyajnto' shḻicha gana' llia to yell-lio lo nisdo'na' daa le Samotracia. Na' betiyo bllinnto' to yell dii le Neápolis. ");
INSERT INTO zadNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Na' wza'nto' Neápoliza' wyajnto' yell Filípoza'. Nakan to yell ga lle' beṉ' Rómaka', na' nakan to yell xen dii zakii gana' mbani Macedóniana'. Na' bigaaṉnto' na' c̱hop shoṉ lla. ");
INSERT INTO zadNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Na' shlak zoanto' na', lla sabda' bchejnto' yella' na' wyajnto' to cho'a yao ga chje'ḻwillgake' Chioza'. Na' jc̱he'nto' na', be'lennto' dill' noolka' bdop bllag. ");
INSERT INTO zadNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Na' ladj noolka' len to beṉ' le Lidia. Nake' beṉ' yell Tiatira, na' chitee lech' wen dii nak de morad. Na' choe'lawee Chioza' na' X̱ancho Chioza' bene' kwenc̱he bzenague' dillaa choe' Páblona'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Na' ka wde wchoe' nisa' do bxooṉe', na' wne' neto': ―Shi chakile dii ḻi ba nonḻilallaa X̱ancho Jesúza', ḻi sho' na' yigaaṉle lillaa. Na' bene' byen jagaaṉnto' lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Na' to shii ka zejnto' gana' choe'ḻwillgake' Chioza', na' billagnto' to bi' nool wew' yoob' dii x̱iwaa, na' dii x̱iwaa chonan kwenc̱he chṉeyaab'. Na' nakb' to bi' ndoo lla yel chom' xshin beṉ', na' dii xen chon x̱ama' gan daa chṉeyaab'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Na'ch bi'ni wnob' Páblona' shlak zejlennnto'ne', chosyaab' zillj, nab': ―Beṉ'kin chongake' xshin Chioza', beena' nak beṉ' choo beṉ' xen, na' chzajni'gakile' beṉ' nez ḻi c̱he Chioza' gana' sho'cho kwenc̱he bi kwiayi'cho. ");
INSERT INTO zadNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Na'ch kon ka' wnab' yog' lla, na' gokzedi Páblona', na'ch biyec̱hje', golle' dii x̱iwaa yoob': ―Kon yeḻ' wṉabia' c̱he Jesucrístona' nia' li' bichej. Na' lii bichejte dii x̱iwaa. ");
INSERT INTO zadNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Na' ka gokbe'i x̱am'ka' bich bi mech gongake' gan, na'ch bex̱'gake' Páblona' len Sílaza' na' jwa'gake' ḻegake' lao josc̱hiska'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Na' ka bllinlengake' ḻegake' lao josc̱hiska', na' che'gake': ―Beṉ' Israelki chta chṉegake' beṉ', lallchoni. ");
INSERT INTO zadNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Na' chli' chsedgakile' beṉ' dii bi chiyaḻ' goncho ni bi chiyaḻ' wlebcho, cho' nakcho beṉ' Roma. ");
INSERT INTO zadNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Na' beṉ' zan bdi'a na' wṉegake' zban c̱he Páblona' len Sílaza'. Na'ch josc̱hiska' bc̱hogbia'gake' wdiṉgake' xe'ka' na' bet wdingake' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Na' ka wde bet wdinchgagake' ḻegake', na' wloogake' ḻegake' lillyana', na' gollgake' beena' chap lillyana' gape' ḻegake' byendad kwenc̱he ki yilagake'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Na' daa gollgake' beeni ka', wlo'e ḻegake' bill' xyoote na' bṉi'e yen ṉi'eka' to ḻee kwag' dii nyidjgake'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Na' do ka chel Páblona' len Sílaza' choe'ḻwillgake' Chioza' na' choḻgake' choe'la'ogake'ne', na' beṉ'ka' sto de lillyana' chzenaggake' ka chongake'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Na' tokonganzi wde to bedxo' xen wal na' bṉiban doxen lillyana'. Na' lii byaljten, na' gdenka' diika' nc̱hejgake' beṉ'ka' de lillyana' tolazzin biyellgakan. ");
INSERT INTO zadNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Na' beena' chap lillyana' bibane' na' ble'ile' ba nyaljchee lillyana', na'ch wleje' spad c̱he'na' nan yiyit kwine' daa gokile' yog' beṉ'ka' de lillyana' ba billeshgake'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Na' Páblona' besyee, golle'ne': ―¡Bibi goni kwino'! Nikz lle' yog'nto'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Na'ch beena' chap lillyana' wṉabe' to yi' na' wyoodoe' jawie' gana' yoo Páblona' len Sílaza', na' lii bc̱hek'te xibe'na' lawe'ka' do chxizze' daa ḻe bllebe'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Na' lii bibejtie' ḻegake' lillyana', na' chi'e: ―¿Le', beṉ'do', beran chiyaḻ' gon' kwenc̱he bi kwiayaa? ");
INSERT INTO zadNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Na' gollgake'ne': ―Benḻilalloo X̱ancho Jesucrístona', li' na' do xiiṉ xoolo', kwenc̱he yisle' le' na' bi kwiayi'le. ");
INSERT INTO zadNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Na' be'lengake' ḻe' na' beṉ'ka' zoa lille'na' cho'a xtill' X̱ancho Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Na'ch beena' chap lillyana' wdibe' we'na' lliagake', ḻa'kzi nakan waḻ chel. Na' ḻekzka' yog'ḻoḻtie' lii wchoategake' nisa'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Na' bic̱hi'e Páblona' len Sílaza' lille'na' na' bweej bwawe' ḻegake'. Na' ḻe chibayi beeni do xiiṉ xoole' daa ba nonḻilall'gake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Na' ka wyeeni', josc̱hiska' bseḻ'gake' beṉ' jellgake' beena' chap lillyana' yisane' ḻegake' kwenc̱he yiyajgake'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Na' beena' chap lillyana' golle' Páblona': ―Ba bseḻ' josc̱hiska' beṉ'ki, na' nagake' ba de lsens yisan' le'. Na' wak yiyajle ṉaa, kochno bi goni le'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Na' Páblona' golle' ḻegake': ―Neto' ndento' kwent yell Rómana', na' ni bi biyiljni'agake' bin bennto' ba bet wdingake' neto' lao lkwe' beṉ' na' wdix̱jzgake' neto' lillyani. ¿Ana' ṉaa cheenzgakile' yisangake' neto' do ngash'zə? Yidch kwingake' yibejgake' neto'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Na' jayellgake' josc̱hiska' daa goll Páblona' ḻegake', na' josc̱hiska' ḻe bllebgake' ka wṉezgakile' Páblona' len Sílaza' ndegake' kwent ka beṉ' Roma. ");
INSERT INTO zadNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Na'ch wyaj josc̱hiska' jaye'xengake' Páblona' len Sílaza' na' bibejgake' ḻegake' lillyana', na' got'yogakile' ḻegake' bich yigaaṉgake' yella'. ");
INSERT INTO zadNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Na' ka bichej Páblona' len Sílaza' lillyana', na' biyajgake' lill Lídiana' jawiagake' beṉ'ka' ba nonḻilall' Jesúza' na' btipchgake' lall'gake', na'tech biza'gake'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Na' ka biza' Páblona' len Sílaza', wdegake' yell Anfípoliza' na' yell Apolóniana', na' bllingake' yell Tesalónicana' gana' zoa yoona' gana' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Na' lo shoṉ xman yog' lla sabdka' wyaj Páblona' gana' chdop chllaggake', kon ka yooloe' chone', na' be'lene' ḻegake' Cho'a Xtill' Chioza', ");
INSERT INTO zadNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","bzajniile' ḻegake' Crístona', beena' wlej Chioza' iṉabi'e, benan byen biya dii wxak'zi'e na' wite', na' bibane' ladj beṉ' wetka'. Na' chi'e ḻegake': ―Jesúza', beena' choe'len' le' xtilleena' ṉaa, ḻen' Crístona', beena' wlej Chioza' iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Na' baḻ beṉ' Israelka' wyajḻe'gake' na' bengake' txen Páblona' len Sílaza', na' ḻekzka' zan beṉ' griegoka', beṉ'ka' ba choe'la'ogake' Chioza', wyajḻe'gake' c̱he Jesúza', na' ḻekzka' zan noolka' zakii. ");
INSERT INTO zadNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Na' beṉ' Israelka' bi wyajḻe', gokxe'gakile' Páblona' len Sílaza', na' btopgake' beṉ' wdallagka' nak beṉ' mal, na' wlekgake' to dii zed yella'. Na'ch wyajgake' lill beena' le Jasón jadiljgake' Páblona' len Sílaza' kwenc̱he gongake' ḻegake' lo na' beṉ' yellka'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Na' daa bi zoa Páblona' len Sílaza' na', na'ch wdoyogake' Jasónna' na' zi to c̱hop beṉ'ka' nonḻilall' Jesúza' na' jwa'gake' ḻegake' lao josc̱hiska'. Na' wṉegake' zillj che'gake': ―Beṉ'ka' chda chbekgake' dii zed doxen yell-lioni ba bla'gake' yell c̱hechoni. ");
INSERT INTO zadNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Na' Jasónni ba blebze' ḻegake' lille'na'. Na' ba nakgake' toz bich chzenaggake' daa nllia Césara' bia' goncho, ḻa' nagake' zoa sto beṉ' wṉabia' le Jesús. ");
INSERT INTO zadNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Na' beṉ' yellka' len josc̱his c̱he'ka' bllaagake' na' gokllesh'gakile'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Na' wxenlall' josc̱hiska' bllia Jasónna' mech len beṉ'ka' nakgake'ne' txen, na'ch bisangake' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Na' kon ka goḻ, beṉ'ka' nonḻilall' Jesúza' bisa'dogake' Páblona' len Sílaza' kwenc̱he yiyajgake' yell Bereana'. Na' ka bllingake' yella', lii wyajtegake' gana' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Na' beṉ' Bereaka' nakchgake' beṉ' wench aga ka beṉ' Tesalónicaka', na' bibagakile' bzenaggake' daa bzajnii Páblona' len Sílaza' ḻegake'. Na' yog' lla biyiljgake' ḻee Cho'a Xtill' Chioza' shi nakan ka daa chli' chsedgakile' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Na' zan beṉ' Israelka' zoa na' benḻilall'gake' Jesúza' na' ka'kzə zan beṉ' griegoka', ka beṉ' byoka' na' ka noolka' zakii. ");
INSERT INTO zadNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Na'ch beṉ' Israelka' lle' Tesalónicana', beṉ'ka' bi benḻilall' Jesúza', ka wṉezgakile' Páblona' choe'lene' beṉ' Bereaka' xtill' Chioza', na'ch wyajgake' jata jaṉegake' beṉ' yellka'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Na' beṉ'ka' nonḻilall' Jesúza' lii bseḻ'tegake' Páblona' cho'a nisdo'na'lə, na' Sílaza' len Timotewa' bigaaṉgake' Bereana'zə. ");
INSERT INTO zadNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Na' beṉ'ka' zejlen Páblona' jwa'gake'ne' gana' lliate yell Aténaza'. Na' ka zi yiza'gake' yiyajgake' Bereana', Páblona' golle' ḻegake' ye'gake' Sílaza' len Timotewa' wtalall'gake' shajgake' gana' zoe'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Na' shlak chbez Páblona' Sílaza' len Timotewa' yell Aténaza', ḻe bllaa yic̱hje' daa ble'ile' to ni to na' nzoa beṉ' Aténaska' diika' choe'la'ogake'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ni c̱heyi daan bzajniile' beṉ' Israelka' gana' chdop chllaggake' choe'ḻwillgake' Chioza', na' len zi x̱oṉj beṉ' griego. Na' ḻekzka' yog' lla wyaje' gana' chak yaana' gana' lle' lla' beṉ' na' be'lene' ḻegake' dill'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Na' baḻ epicúreoka', beṉ'ka' chsedgake' daa bli' bsedi beena' wle Epicúreo, len baḻ estóicoka', wzologake' wdiḻ xtilleeka' len Páblona'. Na' baḻe' che': ―¿Beran naz beeni chshaljchgue'? Na' zi baḻe' nagake': ―¿Aaga beenin zidye'lene' cho' dillaa daa nan chiyaḻ' we'la'ocho sto chios yoblə? Wnagake' ka' daa chyix̱je'i Páblona' ḻegake' dill' wen dill' kob c̱he Jesúza', chi'e ḻegake' bibane' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Na'ch bc̱he'gake' Páblona' to latj gana' nsi'gake' Areópago ga chdopgake' choe'gake' dill', na' ka bllinlengake'ne', che'gake': ―Cheeninto' iṉezinto' bi dii koban chli' chsedilo'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ḻa' ndantekzi nak dill'ki choo, na' cheeninto' iṉezinto' bi zejin. ");
INSERT INTO zadNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ḻa' yog' beṉ' Aténaska' na' ḻekzka' beṉ' zit'ka' zoa na', bichkzə bilə chongake', to chinozgake' bi dill' kob wzenaggake' na' to xtillii daazə choe'gake' yog' lla. ");
INSERT INTO zadNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Na'ch Páblona' wzie' ladje'ka' gana' nzi' Areópago, na' golle' ḻegake': ―Le' beṉ' Atenas, chakbe'id' ḻe chibaile choe'la'ole diika' noni chios c̱hele. ");
INSERT INTO zadNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ḻa' ba ble'id' yell c̱heleni to to latj gana' chgoole diika' balaaṉ, na' ble'id' to ga da' to dill' dii na: “C̱he Chios, beena' kono nombia'.” Na' beena' chgoole balaaṉ ḻa'kzi bi nombia'lene', dill' c̱he'nan' zidye'len' le' ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Chios, beena' ben yell-lioni na' yog' dii de lawinna' nake' X̱an yabana' na' yell-lioni. Aga zoe' ḻoo yoodo' dii choni ṉi'a na' beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Na' aga bi chyallji Chioza' dii iṉacho gak gon beṉ' yell-liona' c̱he'. Ḻa' ḻen' noṉe' yeḻ' mban c̱he yog'ḻoḻcho, na' noṉe' bishbe c̱hecho, na' yog' bi dii de c̱hecho. ");
INSERT INTO zadNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Ḻen' bx̱e bsile' to beṉ' yell-lio, na' yog'ḻoḻcho cho' nakcho xiiṉ dia c̱he beena' bx̱e bsile', na' ḻe'kze' ba nllie' bia' baḻ yiz soacho yell-lioni na' gana' soa to tocho. ");
INSERT INTO zadNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Na' bzoe' cho' yell-lioni kwenc̱he yiyiljcho nakan goncho gombia'chone'. Na' dii ḻi gaḻ' gllin zelen Chioza' to tocho, ");
INSERT INTO zadNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ḻa' ḻen' chone' ka mbancho na' ka chzo chdacho. Kan' bzej baḻ beṉ' sin' c̱heleka', beṉ'ka' wnagake': “Nakcho xiiṉ Chioza'.” ");
INSERT INTO zadNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Na' daa nakcho xiiṉ Chioza', bi chiyaḻ' gakicho nake' to beṉ' de or, de plat, de yaj, de yag, ka chaljlall' beṉ'ka' chongake' diiki. ");
INSERT INTO zadNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Kana'teyi Chioza' bwialoze' ben beṉ'ka' daa nazan c̱hegake' yeḻ' bi chajnii c̱he'ka', per ṉaanlla chone' byen yog'ḻoḻ beṉ' lle' doxen yell-lioni yiyaj yilengakile'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ḻa' Chioza' ba bllie' bia' to lla gone' yeḻ' josc̱his c̱he to to beṉ' lle' yell-lioni, na' gone' c̱he to toe' kon ka chidoḻee. Na' ba bliile' cho' beena' wleje' gon yeḻ' josc̱hisa' daa biḻise'ne' ladj beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Na' ka bengakile' wna Páblona' Chioza' chisbane' beṉ' ladj beṉ' wetka', baḻe' bxillgake', na' zi baḻe' gollgake'ne': ―Sto llagalə wzenagnto' c̱ho' c̱heyi dga choo dill'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Na' biza' Páblona' gana' lle' beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Na' baḻ beṉ' bengake'ne' txen na' benḻilall'gake' Jesúza'. Na' ladje'ka' len to beṉ' lie' Dionisio, beena' len beṉ'ka' zakii chdop latja' nzi' Areópago, na' ḻekzka' sto noolə lie' Dámaris, na' sto c̱hop beṉ' yoblə. ");
INSERT INTO zadNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ka wde biza' Páblona' yell Aténaza', na' biyaje' yell Coríntona'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Na' ka billine' Coríntona' billague' to beṉ' Israel lie' Aquila. Na' beeni nake' beṉ' yell Ponto na' nool c̱he'na' lie' Priscila. Zi' bllinzgake' Coríntona' biza'gake' gana' mbani Itáliana', ḻa' Claudiona', beṉ' wṉabia'na', bisheshe' yog' beṉ' Israelka' Rómana' gana' zoe'. Na' Páblona' jawie' ḻegake', ");
INSERT INTO zadNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na' daa nḻangake' toz ka llin, bigaaṉlene' ḻegake', na' wdiagake' yid xa bayix̱'ka' daa chc̱hingake' lwaa yoo. ");
INSERT INTO zadNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Na' yog' lla sabd, Páblona' chaje' gana' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza', na' chzajniile' beṉ'ka' lle' na' xtill' Jesúza', ka beṉ' Israel na' ka beṉ' bi nak beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Na' Sílaza' len Timotewa' biza'gake' Macedóniana' na' bllingake' gana' zoa Páblona'. Na' daa bllingake', bich bi llin yoblə ben Páblona', san toz xshin Chioza' bene' na' bzajniile' beṉ' Israelka' nan Jesúza' nake' Crístona', beena' wlej Chioza' iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Per wzololəgake' chakdiḻ-lengake'ne' na' wṉegake' zban c̱he', na' wllib xalaane'na' lawe'ka' kwenc̱he bli'e nan chbejyic̱hje' ḻegake', na' golle': ―Le'zkzan wlliayi' kwinle. Aga bi doḻ' gap' nad'. Na' ṉaa lljali' lljasedid' beṉ'ka' bi nak beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Na'ch bizee kwite'ka' na' biyaje' lill to beṉ' le Justo, beena' choe'la'o Chioza', na' zoa lille'na' gao gana' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Na' to beṉ' le Crispo ngoo lall' nee chgwee xṉezi c̱heyi diika' chon beṉ' Israelka' gana' chdop chllaggake', na' do xiiṉ xoole' wyajḻe'gake' c̱he X̱ancho Jesúza'. Na' beṉ' zanch beṉ' Coríntoka', ka bengakile' xtill' Chioza' daa be'len Páblona' ḻegake', wyajḻe'gake' na' wchoagake' nisa'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Na'ch to lle' bli'lao X̱ancho Jesúza' Páblona', na' golle'ne': ―Bi illebo'. Be'ch xtillaana' lao beṉ'ki na' bi so' llizə. ");
INSERT INTO zadNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nad' zoalen' li', na' bi wi'a latj no bi goni li', ḻa' beṉ' zan zi' gombia'gake' nad' yelli. ");
INSERT INTO zadNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Na' bigaaṉ Páblona' Coríntona' twiz yoo gashj bli' bsedile' beṉ' cho'a xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Na' kana' chṉabia' beena' le Galión gana' mbani Acáyana', beṉ' Israelka' gokgake' toz bex̱'gake' Páblona' na' bc̱he'gake'ne' gana' chon Galiónna' yeḻ' josc̱hisa'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Na' che'gake' Galiónna': ―Beeni chde' chgooyeḻee beṉ' kwenc̱he we'la'ogake' Chioza' nlla'lə aga ka na ley c̱he Rómana' daa chṉabia' cho'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ka nan iṉe Páblona', lii wṉete Galiónna' beṉ' Israelka', chi'e: ―Ka nak dga chaole xya, shi bi doḻ' nap beeni wa shi bi xya wal bene', wak gon' yeḻ' josc̱his c̱helena'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","San shi chaole xya c̱he dill' daa cho'e, na' daa chzetje' le beṉ', na' c̱he ley c̱helena', bi nakan ka dii gon' yeḻ' josc̱his c̱heyin. Le'zə, ḻi wwia naklə gonlen. ");
INSERT INTO zadNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Na' bibeje' ḻegake' gana' chone' yeḻ' josc̱hisa'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Na'ch yog' beṉ' griegoka' bex̱'gake' Sósteneza', beena' chgoo xṉezin c̱heyi diika' chon beṉ' Israelka' gana' chdop chllaggake' choe'ḻwillgake' Chioza', betsodgake'ne'. Na' chwiazə Galiónna' bikzə bi golle' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ka wde gok ka', Páblona' bigaaṉche' sshach Coríntona'. Na'ch biḻee dill' beṉ'ka' nonḻilall' Jesúza' na' bizee kwenc̱he shaje' gana' mbani Síriana'. Na' Priscílana' len Aquílana' zejlengake'ne'. Na' ka zi' sho'gake' ḻoo barkwa' yiza'gake' yell Cencreana', Páblona' bshib yic̱hje'na' kon ka nc̱hebe' gone' lao Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ka bllingake' yell Éfesona', Páblona' bikwaaṉze' Priscílana' len Aquílana', na' wzee wyaje' gana' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza' na' be'lene' beṉ'ka' dill'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Na' beṉ'ka' ndop nllag na', wṉabgakile' Páblona' yigaaṉlenche' ḻegake', na' Páblona' bi goonile'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Na'ch chi'e ḻegake': ―Chonan byen yiyaa Jerusalénna' kat' gaḻ' lṉina' daa za', na' widchkz' yidwia' le' shi Chioza' wi'e latj. Na'ch bizee Éfesona' biyo'e to ḻoo barkw. ");
INSERT INTO zadNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Na' ka betje' barkwa' Cesareana', wyaje' Jerusalénna' jawape' chiox beṉ'ka' nonḻilall' Jesúza'. Na' bizee biyaje' Antioquíana'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Na' bigaaṉe' shloll, na'tech wzee wyaje' sto shii to to yell gana' mbani Galáciana' na' Frígiana' jatipche' lall' beṉ'ka' nonḻilall Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Na' do kana' bllin to beṉ' Israel Éfesona' lie' Apolos, beṉ' golj yell Alejandríana'. Na' chak cho'e dill' lao lkwe' beṉ', na' ḻe nsede' Cho'a Xtill' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apóloza' nsede' c̱he X̱ancho Jesúza', na' do yic̱hj do lallee cho'e dill' c̱he' kon ga zeelo ṉezile', per zeelo ṉezile' daa bli' bsedi Juanna' c̱he daa chchoa beṉ' nisa'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Na' Apóloza' bi bllebe' bi'e dill' c̱he Jesúza' gana' chdop chllag beṉ' Israelka' choe'ḻwillgake' Chioza'. Na' ka beni Priscílana' len Aquílana' ka chli' chsedi Apóloza', na'ch bic̱he'gake'ne' kwenc̱he bzajni'chgakile'ne' kwasḻoḻ ka nak xṉez Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ka goki Apóloza' shaje' gana' mbani Acáyana', beṉ'ka' nonḻilall' Jesúza' btipgake' lallee na' bzejgake' to yish dii bex̱ee c̱he beṉ'ka' nonḻilall' Jesúza' na', kwenc̱he wlebgake'ne'. Na' ka blline', ḻe goklene' beṉ'ka' ba biyesh'lallii Chioza' kwenc̱he nonḻilall'gake' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Na' bli' bsedile' beṉ' nan klelan chajnii beṉ' Israelka' c̱he Jesúza'. Na' bibi gok yee beṉ' Israelka' daa bliile' ḻegake' to to gana' nyoj Cho'a Xtill' Chioza' daa na Jesúza' nake' Crístona', beena' wseḻ' Chioza' iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Na' shlak wzoa Apóloza' Coríntona', Páblona' wdie' to to yellka' llia ladj yaa yaoka' gana' mbani Galáciana' na' Ásiana', na' bllintie' Éfesona' gana' jadi'e baḻ beṉ' ba nonḻilall' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Na' wṉabile' ḻegake', chi'e: ―¿Azidsoa Espíritu Sántona' ḻoo yic̱hjlall'do'lena' ka wzolole chonḻilall'le Jesúza'? Na' beṉ'ka' gollgake'ne': ―Ni bi ṉezinto' shi zoa Espíritu Sántona' beena' no' ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Na'ch Páblona' wizṉabile' ḻegake': ―¿Bin wyajniile ka wchoale nisa'? Na' che'gake'ne': ―Kon ka bzajnii dii Juanna'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Na'ch goll Páblona' ḻegake': ―Dii Juanna' bzajniile' beṉ' chiyaḻ' c̱hoagake' nisa' daa wli'n ba biyaj bilengakile' na' ḻekzka' golle' ḻegake' chiyaḻ' gonḻilall'gake' beena' zi' yid, na' ḻen' Jesúza', beena' wlej Chioza' iṉabi'e. ");
INSERT INTO zadNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Na' ka bengakile' daa goll Páblona' ḻegake', na' wchoagake' nisa' daa chonḻilall'gake' X̱ancho Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Na' ka bx̱oa na' Páblona' yic̱hje'ka', Espíritu Sántona' wyo'e ḻoo yic̱hjlall'do'eka' na' wṉegake' wde wdeli dill' na' ḻekzka' wdix̱je'gake' dill' daa goll Chioza' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Na' beṉ'ki gok c̱heyin ka' nakgake' ka do shlliṉ. ");
INSERT INTO zadNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Na' wzoa Páblona' Éfesona' shoṉ beo' bli' bsedile' beṉ' Israelka' gana' chdop chllaggake' choe'ḻwillgake' Chioza' na' bi bllebe'. Na' be'lenche' beṉ'ka' dill' kwenc̱he wyajni'gakile' ka chṉabia' Chioza' ḻoo yic̱hjlall'do' beṉ'ka' nonḻilall'gake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Na' baḻ beṉ'ka' nak beṉ' lall'do' wal aga goongakile' shajḻe'gake', na' biya dii wnagake' lao lkwe' beṉ' c̱he nez ḻi nez shao' c̱he Jesucrístona'. Na'ch biza' Páblona' kwite'ka', na' bic̱hi'e beṉ'ka' ba nonḻilall' Jesúza', wyajlene' ḻegake' lill to beṉ' le Tirano dii nak ka yoo skwel gana' chdi'a beṉ', na' bli' bsedchile' ḻegake' yog' lla. ");
INSERT INTO zadNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Gokte c̱hop yiz bli' bsedile' ḻegake', na' yog'ḻoḻ beṉ'ka' lle' doxen Ásiana' bengakile' xtill' X̱ancho Jesúza', ka beṉ' Israel ka beṉ' griego. ");
INSERT INTO zadNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Na' Chioza' bc̱hine' Páblona' kwenc̱he bene' yeḻ' wak xen dii benan ka bibanchgayi beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Na' ax̱t no bachyic̱hj, no lech' chjatigake'ne' na' chiyox̱'gake'n ga de beṉ' bi shao' na' chiyakgakile', na' ḻekzka' chichej dii x̱iwaa yoo beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Na' baḻ beṉ' Israelka' chdagake' to to yell chibejgake' dii xiw'ka' yoo beṉ', na' chakgakile' wc̱hingake' le X̱ancho Jesúza' kwenc̱he yibejgake'n. Na' che'gake'n: ―Kon yeḻ' wak c̱he Jesúza', beena' choe' Páblona' xtilleena', nannto' le', ḻi yichej. ");
INSERT INTO zadNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ka' ben gall xiiṉ to beṉ' Israel le Esceva, beena' nak to wṉabia' c̱he bx̱ozka'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Na' ka nan yibejgake' dii x̱iwaa, na' gollan ḻegake': ―Nombi'a Jesúza', na' ḻekzka' Páblona', per le', bi ṉezid' no le'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Na'ch beena' yoo dii x̱iwaa bxitee bṉize' ḻegake', na' bc̱hezee xalaane'ka' na' bene' ḻegake' zi' ax̱t bllie' ḻegake' we' na' gaḻ'yid gaḻ'bel'zgake' bixoṉjgake' lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Na' yog' beṉ'ka' zoa Éfesona', ka beṉ' Israel ka beṉ' bi nak beṉ' Israel, wṉezgakile' ka gok c̱he beṉ'ka', na' ḻe bllebgake' na' wloochgake' X̱ancho Jesúza' balaaṉ. ");
INSERT INTO zadNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Na' zan beṉ'ka' ba nonḻilall'gake' Jesúza' jax̱oadoḻ'gake' lao lkwe' beṉ' ka nak dii malka' ba bengake'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Na' zan beṉ'ka' bḻan yeḻ' willa'na' jwa'gake' libr c̱he'ka' daa bsedgake' na' bzeygake'n lao yog' beṉ'ka'. Na' bengake' kwent ka'k' zak' librka' bzeygake', na' bllinan ka do shiyona mil mech plat. ");
INSERT INTO zadNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ka' gok blliljch xtill' X̱ancho Jesúza' na' beṉ' zanch benḻilall'gake'ne' daa gokbe'gakile' xtill' Chioza' nsa'n yeḻ' wak xen. ");
INSERT INTO zadNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Na' ka wde gok yog' diiki, Páblona' bc̱hoglallee shaje' lljawie' beṉ'ka' lle' yellka' llia Macedóniana' na' Acáyana', na'tech yiyaje' Jerusalénna'. Na' ḻekzka' golle': “Ka yiyoll yiyaa Jerusalénna' chiyaḻ' shaa Rómana'.” ");
INSERT INTO zadNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Na'ch bseḻee Timotewa' na' Erástona' Macedóniana', beṉ'ki c̱hop chaklengake'ne', na' ḻe' bigaaṉe' Ásiana' zi shloll wen. ");
INSERT INTO zadNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Na' got' to dii zed wal Éfesona' daa chli' chsedi Páblona' c̱he nez ḻi nez shao' c̱he Jesucrístona'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Na' beena' wlek dii zeda' lie' Demetrio, na' noni xshine' chone' de plat lwaa lsak' yoodo' c̱he xnax Dianana', beena' noni chios c̱hegake'. Na' dii xen chone' gan c̱heyin len beṉ'ka' chonlengake'ne' llinna'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Na' btope' beṉ'ka' chonlene' llinna' na' yog' beṉ'ka' nḻangake' llin ka daa, golle' ḻegake': ―Ṉezile llin dga nḻancho dii xen chkwaaṉan c̱hecho. ");
INSERT INTO zadNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Na' ba chen chle'ile ka chon beena' le Pablo, chde' chzajniile' beṉ' wlall c̱hechoki na' doxen gani mbani Ásiani, chi'e aga bi zakii lwaa lsak' dii chon beṉ' kwenc̱he we'la'ozgake'n. Na' beṉ' zan ba chzenaggake' c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Na' nxoll bich too diiki choncho, na' ḻekzka' nxoll bich seyi c̱he yoodo' gana' zoa xnax Diana c̱hechona', beena' nak beṉ' choo beṉ' xen. Na' beeni choe'la'o yog'zə beṉ' lle' gani mbani Ásiani na' beṉ' lle' doxen yell-lioni, gongakile'ne' ka to beṉ' bibi zakii. ");
INSERT INTO zadNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ka goll Demétriona' ḻegake' ka', ḻe bllaagake' na' besyaagake', nagake': ―¡Beṉ' choo beṉ' xen nak xnax Diana c̱hechona', cho' beṉ' Éfeso! ");
INSERT INTO zadNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Na' yog'ḻoḻe' gokgake' toz, wlekgake' dii lc̱hix̱ wal yella', na' bex̱'gake' c̱hop beṉ' Macedonia, toe' le Gayo, na' stoe' le Aristarco, beṉ'ka' zejlen Páblona'. Na' wdoyogake' ḻegake' bllinlentegake' ḻegake' gana' chidopgake' choe'gake' dill'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Na' Páblona' gokile' sho'e ladj beṉ'ka' ndop nllag na' kwenc̱he nan we'lene' ḻegake' dill', per beṉ'ka' nonḻilall' Jesúza' aga be'gake' latj sho'e. ");
INSERT INTO zadNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Na' ḻekzka' ladj josc̱his c̱he beṉ' Ásiaka' len beṉ' nllagui Páblona', na' bseḻ'gake' rson, che'gake'ne': ―Ben goklen, bi shoo gana' lle' beṉ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Na' beṉ'ka' ndop nllag na' chosyaagake', wde wdeli dii na to toe'. Na' zan beṉ'ka' len ladje'ka' ni bi ṉezgakile' bic̱he lle'zgake' na'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Na' baḻ beṉ' Israelka' bllig'gake' Alejándrona' lao beṉ'ka' kwenc̱he wi'e dill' lawe'ka'. Na'ch Alejándrona' bḻis neena' kwenc̱he soagake' llizə na' wzenaggake' daa yee ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Na' ka ble'gakile'ne' na' gokbe'gakile' nan beṉ' Israelan, na'ch bizologake' chosyaagake', nagake': ―¡Beṉ' choo beṉ' xen nak xnax Diana c̱hechona', cho' beṉ' Éfeso! Ka do c̱hop gor besyaagake' che'gake' ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Na'ch beena' nak sikriban c̱he yella' bzoe' ḻegake' llizə. Na'ch golle' ḻegake': ―Le' beṉ' wlall, yog' beṉ' yell-lio ṉezgakile' cho' beṉ' Éfeso chidoḻ'cho gap wwiacho yoodo' c̱he xnax Diana c̱hechona', beena' nak beṉ' choo beṉ' xen. Na' ṉezgakile' lwaa lsakeena' za'n yabalə, ");
INSERT INTO zadNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","na' ni to kono gak iṉa aga kan' nakan. Na' ḻi soa llizə kwenc̱he bi gonle to dii bi chiyaḻ' gonle. ");
INSERT INTO zadNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ka nak beṉ'ki ba bidwa'le ni, bi iṉacho ba wlangake' bi de ḻoo yoodo' c̱hechona', ni bi iṉacho ba wṉegake' zban c̱he xnax Diana c̱hechona'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Na' shi Demétrioni na' beṉ'ka' chonlengake'ne' llinna' de dii chak c̱hegake' kon nottezə beṉ', daan chi' beṉ'ka' chc̱hoglogake' c̱he beṉ' na' wak shajgake' lawe'ka' kwenc̱he gongake' yeḻ' josc̱his c̱he'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Na' shi bichlə dii cheenile gak, chiyaḻ' yitopcho yog'ḻoḻ beṉ' yell na' we'chon dill'. ");
INSERT INTO zadNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ḻa' ka nak dga gok ṉaa, nxoll iṉa beṉ' to cho'zan chta chṉecho beṉ' yell, na' ¿bera iṉacho shi ba chṉabgakile' cho' c̱he dga ba gok ṉaa? ");
INSERT INTO zadNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ka wde golle' ḻegake' ka', na' bisheshe' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Na' ka bibe'lli daa ben beṉ' Éfesoka', na'ch gox Páblona' beṉ'ka' nonḻilall' Jesúza' na' be'lene' ḻegake' to c̱hop dill' dii gaklenan ḻegake' na' wdeḻe' to togake', na' biḻee ḻegake' dill'. Na' bizee zjade' gana' mbani Macedóniana'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Na' bidie' to to yellka' llia Macedóniana' na' be'lene' beṉ'ka' nonḻilall' Jesúza' zan dill' dii btipan lall'gake'. Na' biyolla' billine' Gréciana', ");
INSERT INTO zadNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","na' shoṉ beo' wzoe' na'. Na' ba zoa yiyo'e ḻoo barkwa' kwenc̱he yiyaje' gana' mbani Síriana', ka wṉezile' ba chino beṉ' Israelka' ḻe'. Na' bc̱hoglallee bigwee nez kon ṉi'aze ziyaje' Macedóniana'lə. ");
INSERT INTO zadNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Na' beṉ' zan zejlengake' Páblona' Ásiana'. Ladje'ka' len Sópatera' xiiṉ Pírrona', beṉ' Bereana'; na' Aristárcona' len Segúndona', beṉ' Tesalónicaka'; na' Gáyona', beṉ' Dérbena'; Timotewa', na'ch Tíquicona' len Trófimona', beṉ' Ásiaka'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Na' yog' beṉ'ki wllialogake' laonto'na', na' wlezgake' neto' yell Tróaza'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Na' ka wde lṉi Paskwa' kat' chaogake' yetxtila' daa bi nc̱hix̱ levadúrana', na'ch biza'nto' yell Filípoza' biyoonto' to ḻoo barkw. Na' ka gok to xman biza'nto' na' billinnto' yell Tróaza' gana' ba chbez beṉ'ka' neto'. Na' wzoanto' na' gall lla. ");
INSERT INTO zadNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Na' ka bllin lla dmiwa', lla nech c̱he xmanna', bdop bllagnto' weej wdaonto' txen len beṉ'ka' nonḻilall' Jesúza', na' Páblona' bli' bsedile' ḻegake'. Na' daa ba nakan yizee yetiyo, ax̱t chelch wyeelo be'lene' ḻegake' dill'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Na' ndop nllagnto' to ḻoo yoo dii llia shkwia cha'lə, na' nakan bido yi'zi. ");
INSERT INTO zadNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Na' to bi' wew' lliab' cho'a ventanna', na' leb' Eutico. Na' daa bshaljlen Páblona' beṉ'ka' ssha, bex̱'kza bishgala' ḻeb' na' bxopb' cho'a ventan c̱he yoo de shoṉ kwiana' gana' lliab', na' ka biḻisgake'b' ba witb'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Na'ch biyetj Páblona', na' ka blline' gana' jadix̱jgake'b' bchekee wdeḻe'b'. Na' golle' beṉ'ka': ―Bi illeble; mbankzba'n. ");
INSERT INTO zadNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Na'ch biyep Páblona' dii yoblə, bxoxje' yetxtila' na' wdaogake'n. Na'tech bizoloe' choe'lene' ḻegake' dill' ni ka wyeeni'teyi. Na'ch bizee. ");
INSERT INTO zadNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Na' ka billesh beṉ'ka', chibagakile' bic̱he'gake' bi' wewaa shi'a shbam'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Na'ch neto' bibialonto' biyoonto' to ḻoo barkw wyajnto' yell Asónna' gana' yillagnto' Páblona' ka bgaaṉnto' dill', na' bigwee nez ṉi'aze'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Na' ka billagnto' Páblona' Asónna', na' biyoolene' neto' ḻoo barkwa' na' wyajnto' yella' le Mitilene. ");
INSERT INTO zadNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Na'ch biza'nto' Mitilénena', na' betiyo bidento' gaozə yell-lio Quíona' daa llia lo nisdo'na'. Na' gok lillj billinnto' yell-lio Sámoza' daa llia lo nisdo'na', na' llana' sto wyajchnto' yell Milétona'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ka' bennto', ḻa' Páblona' bi goonile' shajchnto' Éfesona' kwenc̱he bi sha'ile' Ásiana', daa ba chakbyenile' yilline' Jerusalénna' daa ba zoa gaḻ' lṉi Pentecostéza'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Na' ka zoanto' Milétona', Páblona' bseḻee rson na' goxe' beṉ'ka' ngoo lo na'gake' beṉ'ka' nonḻilall' Jesúza' Éfesona'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Na' ka bllingake', goll Páblona' ḻegake': ―Le' ṉezile nak bsa' c̱ha' dezd nechte ka wzoalen' le' Ásiani. ");
INSERT INTO zadNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ba wzoa' ba ben' xshin Chioza' do yic̱hj do lallaa, na' zan shii gokyeshid' na' wchell', na' biya dii ben ble'id' daa bc̱hi' bsak' beṉ' Israelka' nad'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Na' aga ni c̱he ka' bsan' bich wnia' le' daa chiyaḻ' iṉezile, san bli' bsedchkzid' le' gana' chdop chllagle na' ka'kzə lill to tole. ");
INSERT INTO zadNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ka beṉ' Israel ka beṉ' bi nak beṉ' Israel, be'lengakee dill' nan chiyaḻ' yiyaj yilengakile' c̱he dii malka' chongake' lao Chioza' na' gonḻilall'gake' X̱ancho Jesucrístona'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Na' ṉaa, Espíritu c̱he Chioza' chone' byen yiyaa Jerusalénna', na' bi ṉezid' bi gak c̱ha' na'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Zeelo dii ṉezid', Espíritu Sántona' ne' nad' to to yell gana' tia' gataa lillya na' biya dii gak c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Na' aga bi chakid' c̱heyi diika' gak c̱ha', ḻa' aga llialo yeḻ' mban c̱ha'ni, san llialote yiyoll gon' yog'ḻoḻ daa ben X̱ancho Jesúza' lo na' gon', ḻa' ḻen' wleje' nad' kwenc̱he c̱hix̱ji'a dill' wen dill' kob c̱he Chioza' daa chakile' cho'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Na' ba bzajniid' le' ka chon Chioza' chṉabi'e ḻoo yic̱hjlall'do' beṉ' chonḻilalleene', na' ṉaa ni stole le' bich ile'ile nad' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Daan nia' le' ṉaa, aga bi doḻ' nap' shi nole kwiayi'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ḻa' ba bzajniid' le' yog' daa cheeni Chioza'. Bibi bkwashaa dii iṉacho bi wnia' le'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Na' ḻi wsak', ḻi gap wwia beṉ'ka' nakle txen, ḻa' Espíritu Sántona' wleje' le' kwenc̱he gap wwiale beṉ'ka' nonḻilall' X̱ancho Jesúza', beṉ'ka' biya'o bizi'lene' xc̱hene'na' daa blalje' ḻee yag cruza'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ḻa' ṉezid' kat' bich soalen' le' na' yid beṉ' gonllejgakile' le' kwenc̱he kwej yic̱hjle daa nonḻilall'le Jesúza'. Gongake' ka ba zṉia, ba chjatao xil'do' c̱he beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Na' ladjlena' ichej beṉ' wli' wsedile' le' daa bi nak shḻi kwenc̱he gonlene' txen. ");
INSERT INTO zadNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Na' ḻi wsak' kwenc̱he kono siye' le'. Na' ḻi lljadini ka ben' lo shoṉ yiza' wzoalen' le', ḻa' ka tella ka waḻ got'yoid' to tole kwenc̱he wzenagle c̱he Chioza', na' ax̱t wchell' ni c̱hele. ");
INSERT INTO zadNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Na' ṉaa, chon' le' lo na' Chioza' len cho'a xtilleena' daa na ḻe chakile' cho'. Ḻa' ḻennan' napan yeḻ' wak kwenc̱he gaklenan le' soac̱hec̱hle gonḻilall'lene'. Na' ka' lljazoalenlene' txen len yog' beṉ' nakgake' lall' nee. ");
INSERT INTO zadNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ṉezkzile bibiṉ' selallaa c̱hele, ni xmechle, ni xalaanle, ni bichlə dii naple. ");
INSERT INTO zadNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Na' ṉezkzile ṉi'a na'ni benlen' llin kwenc̱he bllelid' bi dii byalljlenid' beṉ'ki chonlengake' nad' xshin Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ben' llinna' kwenc̱he bliid' le' ka chiyaḻ' gaklencho beṉ' kat' bi chyalljgakile'. Ḻa' chiyaḻ' lljadinicho xtill' X̱ancho Jesúza' kana' wne': “Mbalazch soacho shi we'cho beṉ' bi we'chone', aga ka daa ikaacho bi dii goṉe' cho'.” ");
INSERT INTO zadNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Na' ka biyoll be'len Páblona' ḻegake' dill', na'ch bc̱hek' xibe'ka' be'ḻwillgake' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Na' yog'gake' wchell, na' wdeḻ'gake' Páblona' na' bnopgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Na' ḻe nyesh' wzoagake' daa goll Páblona' ḻegake' bich ile'i ljwellgake'. Na' jasangake'ne' gana' biyo'e barkwa'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Na' ka bilaanto' beṉ' Éfesoka', na'ch biyoonto' ḻoo barkwa' ziyajnto' shḻicha yell-lio Coza' daa llia lo nisdo'na', na' betiyo billinnto' yell-lio Ródaza' daa llia lo nisdo'na', na' biza'nto' billinnto' yell Pátarana'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Na' ka billinnto' Pátarana' ble'into' to barkw dii shaj gana' mbani Feníciana', na' biyoonto'n. ");
INSERT INTO zadNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Na' ka zejnto' ḻoo barkwa' ble'into' yell-lio Chíprena' daa llia lo nisdo'na' na' to wdeznto' shḻaana'lə zejnto' yell Tírona' daa llia gana' mbani Síriana'. Na' ka billin barkwa' Tírona', biḻetjgake' yoa'na' noa'n na' biyetjnto'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Na' jadiljnto' beṉ'ka' nonḻilall' Jesúza' na' bigaaṉlennto' ḻegake' to xman. Na' Espíritu Sántona' golle' ḻegake' bi chiyaḻ' yiyaj Páblona' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Na' ka gok to xman biza'nto'. Na' yog' beṉ'ka' ba nonḻilall' Jesúza' yell Tírona', do xiiṉ xoolgake', wza'lengake' neto' cho'a yella'. Na' ka bllinnto' cho'a nisdo'na', bc̱hek' xibnto' be'ḻwillnto' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Na'ch biḻaa ljwellnto' dill', na' biyoonto' ḻoo barkwa', na' beṉ'ka' biyajgake' lill c̱he c̱hegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Na' biza'nto' Tírona' billinnto' yell Tolemáidana', na' bwapnto' chiox beṉ'ka' nonḻilall' Jesúza' na', na' bigaaṉlennto' ḻegake' shlla. ");
INSERT INTO zadNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Na' betiyo biza'nto' Tolemáidana' na' billinnto' yell Cesareana'. Na' wyajnto' lill Felípena' beena' choe' dill' wen dill' kob c̱he Crístona', na' nake' txen beṉ'ka' gall chaklengake' postlka', na' bigaaṉnto' lille'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Na' zoa tap bi' nool wew' c̱he', na' chyix̱je'gakb' daa che' Chioza' ḻegakb'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Na' ka ba gok shoṉ tap lla zoanto' lille'na', na' bla' to beṉ' Judea lie' Ágabo, beṉ' chyix̱jee daa che' Chioza' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Bidwie' neto' na' wṉabe' xpachḻee Páblona' na' bic̱hej ṉi'a na' kwine', na' chi'e: ―Ba bzajnii Espíritu Sántona' nad' ne' beṉ' wlallka' lle' Jerusalénna' wc̱hejgake' ṉi'a na' x̱an bachḻeeni ka ba nc̱hej' ṉi'a na'ni, na' gongake'ne' lo na' beṉ'ka' bi nak beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Na' ka beninto' wna Ágabona' ka', neto' len beṉ' Cesareaka' got'yointo' Páblona' bi yiyaje' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Na' Páblona' wne' neto': ―Bi kwell-le c̱ha', bi gonle ka gakyeshid'. Zoakz' wtiḻ' diika', aga toz daa wc̱hejgake' nad', san wakte witgake' nad' daa nonḻilallaa X̱ancho Jesucrístona'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Na' ka gokbe'into' bi chzenag Páblona' daa che'nto'ne' bi yiyaje' Jerusalénna', na'ch wnanto': ―Gakshga ka cheeni X̱ancho Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Na' ka wde, bisini'a c̱hento' kwenc̱he biza'nto' ziyajnto' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Na' baḻ beṉ' Cesareaka' nonḻilall' Jesúza' wza'lengake' neto'. Na' bc̱he'gake' neto' lill to beṉ' le Mnasón, gana' yigaaṉnto'. Beeni nake' beṉ' Chipre na' ssha ba gok nonḻilallee Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Na' ka billinnto' Jerusalénna', ḻe chibayi beṉ'ka' naknto' txen nonḻilall'nto' Jesúza'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Na' betiyo wza'len Páblona' neto' jawianto' Jacóbona'. Na' ka bllinnto', ba lle' yog' beṉ'ka' ngoo lo na'gake' beṉ'ka' nonḻilall' Jesúza' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Na' biyoll bwap Páblona' ḻegake' chiox, na' golle' ḻegake' to to diika' goklen Chioza' ḻe' daa bene' ladj beṉ'ka' bi nak beṉ' Israel. ");
INSERT INTO zadNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Na' ka wde bzenaggake' diika' wna Páblona', be'la'ogake' Chioza'. Na'ch gollgake'ne': ―Li', beṉ' bish', ṉezkzilo' beṉ' zan wal inlleb beṉ' Israelka' ba nonḻilall'gake' Jesúza', na' yoguee nagake' chonan byen goncho daa na leya'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Na' ba bengakile' rson ka chono', na' nagake' chzajniilo' yog' beṉ' Israelka' lle' yell zit'ka' bich gongake' ka na ley c̱he dii Moiséza', ni bi koo bi' c̱he'ka' seṉ daa le circuncisión, na' bich gongake' daa yoolocho choncho. ");
INSERT INTO zadNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Nakra gonchon, lla? Ḻa' lii idop illagte beṉ' kat' iṉezgakile' ba biyedo'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Waklja gono'n ki: Ladjnto'ni zoa tap beṉ' nc̱hebe' to dii nc̱hebe' lao Chioza', na' chonan byen wdelazgake' daa nc̱hebgake'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Chiyaḻ' wc̱hi'o ḻegake' yoodo'na' kwenc̱he txen yixi yiyechle. Na' li' c̱hixjo' daa chiyaḻ' c̱hixjgake' kwenc̱he gak wshib yic̱hje'ka' ka nllia leya' bia'. Na' shi gono' ka', yog' beṉ' iṉezgakile' bi nakan ka nagake' c̱ho', na' gakbe'gakile' ḻekzka' chzenago' daa na leya'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Na' ka nak beṉ'ka' bi nak beṉ' Israel na' ba nonḻilall'gake' Jesúza', ba bzejnto' ḻegake' bi kwe' yic̱hjgake' diika' zejlencho cho' beṉ' Israel. Na' gollnto'gake' daa chiyaḻ' gongake': bi gaogake' yeḻ' wao daa ba bllia beṉ' lao lwaa lsak' daa choe'la'ogake', na' bi gaogake' xc̱hen bayix̱aa, ni xpel' bana' bi wlalj xc̱hema', na' bi iṉelenzgake' xiiṉ xool beṉ'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Na' betiyo ka bixi biyech Páblona' len beṉ'ka' zi tap, na' wyajgake' yoodo'na' kwenc̱he wzenile' bx̱ozka' bi llan sheelo daa ba nc̱hebgake' kwenc̱he ka yiyoll yixi yiyechgake' ka nllia leya' bia' na' we'gake' bayix̱'do'ka' witgake'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Na' ba zoa izaa gall lla chongake' daa chiyaḻ' gongake' kwenc̱he yixi yiyechgake', na' baḻ beṉ' Israelka', beṉ'ka' zaak Ásiana', ble'gakile' Páblona' ḻoo yoodo'na'. Na'ch bta bṉegake' beṉ'ka' lle' na', kwenc̱he bex̱'gake' Páblona'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Na' wṉegake' zilljə che'gake': ―Le', beṉ' Israel, ḻi gaklen neto'. Beeni chde' doxen chli' chsedile' beṉ' kwenc̱he gakzbangakile' cho' beṉ' Israel, len ley c̱hechona' na' yoodo' c̱hechoni. Na' ṉaa sto dii zban wal ba bizone', ba wlo'e to c̱hop beṉ' griego yoodo' c̱hechoni, ḻa' bi de lsens sho' beṉ'ki lill xḻatj Chios c̱hechona'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Wnagake' ka' daa ba ble'gakile' Trófimona', to beṉ' yell Éfeso, chdalene' Páblona' txen Jerusalénna', na' gokgakile' ḻekzka' bc̱he' Páblona'ne' yoodo'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Yog'z beṉ' lle' yella' bllesh bcheeṉgake' zejdogake'. Na'ch bigoyogake' Páblona' ax̱t de xṉeze' bibejgake'ne' yoodo'na', na' lii bsejtegake' puertka'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Na' ba llagdia'gake' Páblona' cheengakile' wittekzgake'ne' ka bllin dillaa lao beṉ' wṉabia' c̱he soldadka' nan chak daṉe nlleb doxen yell Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Na' lii btoptie' soldadka' na' beṉ'ka' ngoo lall' na' ḻegake' na' wyajdogake' gana' lle' beṉ'ka'. Na' beṉ'ka' chit Páblona' ka ble'gakile' beṉ' wṉabia'na' len soldad c̱he'ka', na'ch bsangake' bich bet wdingake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Na'ch jabig' beṉ' wṉabia'na', na' bex̱ee Páblona' na' bene' mandad bc̱hejgake'ne' c̱hop gden. Na'ch wṉabile' beṉ'ka' no beena' na' bin bene'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Na' beṉ'ka' kon chosyaagake' na' chiya dii na to toe', na' bi wyajnii beṉ' wṉabia'na' daa zi'te chongake' sshag. Na'ch bene' mandad bic̱he' soldadka' Páblona' gana' zoagake'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Na' ka bllingake' cho'a shkwiaka' lle' cho'a lill soldadka' benan byen bḻen soldadka' Páblona' daa zej beṉ' Israelka' cheengakile' wṉizgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Na' beṉ' zan nogake'ne' chosyaagake', che'gake': ―¡Ḻii wittegue'! ");
INSERT INTO zadNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Na' ka ba zoa lljḻoogake' Páblona' gana' zoa lill soldadka', na'ch golle' beṉ' wṉabia'na': ―¿Awak we'len' li' to c̱hop cho'a dill'? Na' beṉ' wṉabia'na' golle'ne': ―¿Achako' dill' griegona'? ");
INSERT INTO zadNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Aaga lin' beṉ' Egíptona' beena' wzoshyi' beṉ' wṉabia'ka' kani batzə, na' bc̱hi'e tapa mil beṉ' wen xyaka' latja' gana' bibi chashj chḻeb? ");
INSERT INTO zadNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Na'ch goll Páblona'ne': ―Aga ḻe' nad'. Nad' nak' to beṉ' Israel, beṉ' yell Tarso dii nak to yell xen gana' mbani Cilíciana'. Ben goklen be' latj we'len' beṉ'ki dill'. ");
INSERT INTO zadNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Na' beṉ' wṉabia'na' bi'e lsens. Na'ch wze Páblona' lo shkwiaka' na' bze neena' lawe'ka' kwenc̱he soagake' llizə. Na'ch ka wche'lligake' na' wzoloe' be'lene' ḻegake' dill' hebrewa' daa nak xtill'gake', chi'e: ");
INSERT INTO zadNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","―Le' beṉ' bish', na' le' beṉ' gol, ḻi wzenag dill' c̱ha'ni wi'a. ");
INSERT INTO zadNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Na' beṉ'ka', ka bengakile' chṉe Páblona' dill' hebrewa' na' wlle'gake' llizə. Na' Páblona' chi'e ḻegake': ");
INSERT INTO zadNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","―Nad' nak' beṉ' Israel na' golj' yell Társona' gana' mbani Cilíciana', per bgol' Jerusalénni, na' bli' bsedi maestro Gamaliela' nad' kwasḻoḻ ka na ley c̱he dii x̱ozxto'choka', na' toshiizi choe'ḻ-lallaa chon' ka chazlall' Chioza' do yic̱hj do lallaa, ka chonkzle le' ṉaanlla. ");
INSERT INTO zadNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Na' bc̱hi' bsakaa beṉ'ka' ba wyoo lo nez ḻi nez shao' c̱he Jesucrístona' na' goklallaa guetgake'. Na' bex̱aa ka nool ka beṉ' byo, na' wlo'a ḻegake' lillyana'. ");
INSERT INTO zadNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Beena' nak bx̱oz choo bx̱oz xen na' yog' beṉ' golka' chṉabia' beṉ' Israelka' ṉezgakile' ka ben'. Na' ḻegake' beṉgake' nad' yish daa bex̱aa ka wzaa zyaa yell Damáscona', gokid' lljex̱aa yog'ḻoḻ beṉ'ka' nogake' xtill' Jesucrístona' na' yic̱he'gakee Jerusalénni kwenc̱he sak'zi'gake'. ");
INSERT INTO zadNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Na' ka do gobill, ka ba zoa illin' Damáscona', tokonganzi wyalj to yi' dii za' yabana' lo neza' gana' zyaa. ");
INSERT INTO zadNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Na' to wzoatishz' lo yona'. Na'ch benid' shii to beṉ' wne' nad': “Saulo, Saulo, ¿berac̱he chc̱hi' chsak'zo' nad'?” ");
INSERT INTO zadNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Na' wṉabidee, chepee: “¿No li', beṉ'?” Na' wne': “Nadaan Jesús, beṉ' Nazareta', beena' chc̱hi' chsakoo.” ");
INSERT INTO zadNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Na' beṉ'ka' zyaalen' txen ble'gakile' yi'na' daa wyalj na' bllebgake', per aga bengakile' daa wna beena' nad'. ");
INSERT INTO zadNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Na'ch goshee: “¿Beran chiyaḻ' gon', X̱an'?” Na' wne' nad': “Biyas na' wyaj Damáscona', na' na' iṉagake' li' yog' daa chiyaḻ' gono'.” ");
INSERT INTO zadNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Na' beeni' wala' bc̱hoḻan nad', na' beṉ'ka' zyaalen' txen biyox̱'gake' na'na' na' bc̱he'gake' nad' Damáscona'. ");
INSERT INTO zadNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Na' Damáscona' zoa to beṉ' le Ananías, na' zoe' chone' yog' daa na leya', na' yog' beṉ' Israelka' zoa Damáscona' nagake' c̱he' nake' to beṉ' chon dii wen. ");
INSERT INTO zadNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Na' Ananíaza' bide' bidwie' nad', na' ka blee, wne' nad': “Saulo, beṉ bish', ṉaa yile'ilo' sto shii.” Na' kate wne' ka', lii bile'teid', na'ch gok ble'idee. ");
INSERT INTO zadNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Na'ch wne' nad': “Chioza', beena' be'la'o dii x̱ozxto'choka', ba wleje' li' kwenc̱he gombi'o daa cheenile' gono', na' kwenc̱he ble'ilo' beena' nak ḻiizelozi beṉ' wen, na' benteilo' kwine'n ba bshaljlene' li'. ");
INSERT INTO zadNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Na' li' wi'o xtilleena' doxen yell-lioni, na' we'leno' beṉ' dill' yog'ḻoḻ diika' ba ben ble'ilo'. ");
INSERT INTO zadNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Na' ṉaa, bibi wsej wllonan c̱hoatego' nisa' na' wṉabi X̱ancho Jesúza' yisol yiṉite' saaxya c̱ho'ka'.” ");
INSERT INTO zadNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Na' ka biyed' Jerusalénni, wyaa yoodo'na' je'ḻwill' Chioza', na' Chioza' bene' ka ble'do'id'. ");
INSERT INTO zadNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Na' ble'id' Jesúza', beena' nak X̱an', na' wne' nad': “Btalalloo bchej Jerusalénni, ḻa' aga no wzenag xtillaana' daa we'lengako'ne'.” ");
INSERT INTO zadNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Na'ch chepee: “X̱an', ḻegake' ṉezgakile' ka wya' to to gana' chdop chllagnto' choe'ḻwillnto' Chioza' jex̱aa beṉ'ka' nonḻilall' li', na' bet wdingakee na' bic̱he'gakee ni, bsejgakee lillyana'. ");
INSERT INTO zadNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na' kana' betgake' dii Estébanna' beena' be' xtilloona', len' bi'a latj betgake'ne', na' wdap' xa beṉ'ka' bet ḻe'.” ");
INSERT INTO zadNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Na' Jesúza', beena' nak X̱an', wne' nad': “Wloo nez, wyaj yell zit'ka' na' je'len beṉ'ka' bi nak beṉ' Israel xtillaana'.” ");
INSERT INTO zadNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Zeelo diika'z bzenaggake' c̱he Páblona', na'ch wzolo chosyaagake' che'gake': ―¡Bisol biṉittegue' yell-lioni! ¡Aga chiyaḻ' soach ka ḻe'! ");
INSERT INTO zadNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Na' bikzə bsangake' chosyaagake' daa ḻe chllaagake'. Ax̱t no xe'ka' chzaḻ'gake' ka'lə na' no bishte yona' chashgake'n chzaḻ'gake'n cha'lə. ");
INSERT INTO zadNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Na' beṉ' wṉabia' c̱he soldadka' bene' mandad wloogake' Páblona' gana' zoa lill soldadka' na' wit c̱hingake'ne' kwenc̱he wi'e dill' bin bene' daa zi'te chllaa beṉ'ka' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Na' ka ba nc̱hejgake'ne' kwenc̱he wit c̱hingake'ne', Páblona' golle' x̱an soldadka': ―¿Ade lsens wit c̱hinle to beṉ' nde kwent Rómana' ḻa'kzi biṉ' yiyiljyoll-le bin bene'? ");
INSERT INTO zadNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Na' ka goll Páblona' x̱an soldadka' ka', na'ch jelle' beṉ' wṉabia' c̱he'ka': ―Wsak'shkilo', nde beeni kwent yell Rómana', na. ");
INSERT INTO zadNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Na' beṉ' wṉabia' c̱he soldadka' wyaje' kwit Páblona' na' wṉabile'ne', chi'ene': ―¿Aḻin ndio' kwent yell Rómana'? Na' Páblona' chi'ene': ―Awe. ");
INSERT INTO zadNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Na'ch beṉ' wṉabia' c̱he soldadka' chi'e Páblona': ―Nad' mech xen wxakidaan kwenc̱he ndia' kwent yell Rómana'. Na' Páblona' golle'ne': ―Nad' dezd ka goljtia' ndia' kwent yell Rómana'. ");
INSERT INTO zadNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Na' daa goll Páblona' ka', beṉ'ka' nan wit c̱hingake'ne' lii bikwastegake' kwite'na'. Na' ax̱t beena' chṉabia' soldadka', ka gokbe'ile' Páblona' ndie' kwent yell Rómana', ḻe bllebe' daa bene' mandad bc̱hejgake'ne' gdenka'. ");
INSERT INTO zadNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Na' betiyo, beṉ' wṉabia' c̱he soldadka' btope' bx̱ozka' chṉabia' na' yog'ḻoḻ beṉ'ka' chṉabia' beṉ' Israelka'. Na' bselle' gdenka' daa nchej ṉi'a na' Páblona', na' wleje'ne' bzie'ne' lao beṉ'ka' daa cheenile' iṉezile' bic̱he chao beṉ' Israelka' xya c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Na'ch Páblona' bwie' beṉ'ka' chṉabia' beṉ' Israelka' na' golle' ḻegake': ―Le' beṉ' bish', ṉezi yic̱hjlall'dawaani ax̱t ṉaa chon' daa chazlall' Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Na'ch Ananíaza', beena' nak bx̱oz choo bx̱oz xen, golle' beṉ'ka' ze kwit Páblona' kwall'gake' cho'ena'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Na' Páblona' golle'ne': ―¡Chioza' wit c̱hine' li', wxiye'! Li' chi'oni kwenc̱he yiya yiyiljo' nad' kon ka na leya', per chyishjo' daa na leya' daa beno' mandad wlall'gake' cho'ani. ");
INSERT INTO zadNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Na'ch beṉ'ka' lle' na', che'gake' Páblona': ―¿Naktekara chiyaxjilo' chilliizo' dill' beena' nak bx̱oz choo bx̱en c̱he Chioza'? ");
INSERT INTO zadNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Na'ch Páblona' golle' ḻegake': ―Le' beṉ' bish', bi ṉezid' shi ḻen' bx̱oz choo bx̱oz xenna'. Sheḻ'ka' ṉezid', aga goshee ka', ḻa' Cho'a Xtill' Chioza' nan: “Bi iṉio' zban to beṉ' wṉabia' c̱he yell c̱ho'na'.” ");
INSERT INTO zadNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Na' Páblona' gokbe'ile' beṉ'ka' chṉabia' nakgake' c̱hop kwenlə. Baḻe' nak txen saduceoka' na' baḻe' nak txen fariseoka'. Na'ch wṉie' zillj chi'e: ―Le' beṉ' bish', nad' nak' fariseo na' naktia' xiiṉ fariseo. Na' chaole xya c̱ha' daa non' lez yiban beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ka goll Páblona' ka' na' gok to wishesh wal ladj fariseoka' len saduceoka'. Na' gokgake' c̱hoplə. ");
INSERT INTO zadNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ḻa' saduceoka' nagake' aga wibanch beṉ' wetka', na' ḻekzka' nagake' aga no anjl zoa ni dii x̱iw'. Na' fariseoka' chajḻe'gake' zoa anjl na' zoa dii x̱iw' na' chajḻe'gake' yiban beṉ' wetka'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Na' yog'gake' besyaagake' choe'gake' wde wdeli dill'. Na'ch wzolla' baḻ beṉ'ka' chli' chsedi leya' nakgake' txen fariseoka', na' che'gake': ―Ni to dii mal biṉ' gon beeni. Shera shi to beṉ' bi gak ile'icho wa to anjlan' ba wṉie' ḻe'. Bi chiyaḻ' soshyi'cho Chioza'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Na' daa zi'telə gokdiḻ-len ljwell beṉ'ka', bxolli beṉ' wṉabia' c̱he soldadka' wxoxj wtingake' Páblona'. Na'ch wṉie' soldadka' yibejgake' Páblona' ladje'ka' na' lljaloogake'ne' dii yoblə gana' zoa lille'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Na' llana' sto ka goḻ, bli'lao X̱ancho Jesúza' Páblona' na' golle'ne': ―Bendiplalloo Pablo, ka ba be'kzo' xtillaana' Jerusalénni, ka'kzan chonan byen lljeno' Rómana'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Na' betiyo baḻ beṉ' Israelka' gokgake' toz kwenc̱he witgake' Páblona', na' wloo cho'agake' bibi yeej gaogake' ax̱t ki guet Páblona', na' gollgake' Chioza' wsak'zi'e beena' yeej gao shlak biṉ' witgake'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Wdeli c̱hoa beṉ'ka' wloo cho'agake' witgake' Páblona'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Na'ch wyajgake' lao bx̱ozka' chṉabia' na' lao beṉ' gol c̱he'ka' chṉabia' beṉ' Israelka' na' jellgake': ―Ba bc̱hebnto' wsak'zi' Chioza' neto' shi yeej gaoznto' na' biṉ' witnto' Páblona'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Na' le' nakle beṉ' wṉabia' c̱hento', ḻi gak toz na' ḻi iṉabi beṉ' wṉabia' c̱he soldadka' kweje'ne' wx̱e na' yidweene' laoleni, na' wda'tezilen yiyiljyoll-le berakzan bene'. Na' neto' kwe'nonto'ne' tneza' kwenc̱he witnto'ne' ka zi' ilee ni. ");
INSERT INTO zadNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Na' bi' c̱he beṉ' zan Páblona' benib' dill'ka' be'gake', na' wyajb' gana' zoa lill soldadka' jasi'nib' Páblona'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Na' Páblona' wṉie' to beṉ' nak x̱an to guiyoa soldadka', golle'ne': ―Jwa'gach bi'ni lao beṉ' wṉabia' c̱he soldadka', ḻa' de to dii ye'b' ḻe'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Na' x̱an soldadka' jweeb' lao beṉ' wṉabia' c̱he yog' soldadka', na' golle'ne': ―Páblona', beena' nej lillyana', wṉabile' nad' yidwa' bi'ni lawo'ni, ḻa' de to dii iṉab' li' na. ");
INSERT INTO zadNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Na' beṉ' wṉabia' c̱he yog' soldadka' bex̱ee na' bi'na', na' bc̱hi'eb' ga kono lle'. Na'ch wṉabile'b': ―¿Beran cheenilo' iṉo' nad'? ");
INSERT INTO zadNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Na' bi' xkwidaa gollb' ḻe': ―Beṉ' Israelka' ba gokgake' toz kwenc̱he iṉabgakile' li' kwejo' Páblona' wx̱e na' wseḻoone' lao beṉ'ka' chṉabia' ḻegake', na' wda'tezgakile'n yiyiljyollgake' berakzan bene'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Na' bi shajḻi'o c̱hegake', ḻa' wdeli c̱hoa beṉ'ka' kwe'nogake'ne' tneza' kwenc̱he witgake'ne', na' che'gake' Chioza' wsak'zi'e ḻegake' shi yeej gaozgake' na' biṉ' guete'. Na' ba chbezgake' gono' ka cheengakile'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Na'ch beṉ' wṉabia' c̱he soldadka' chi'eb': ―Ni to kono yoo ka nak dga ba wno' nad'. Na'ch biza'b'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Na'ch beṉ' wṉabia' c̱he soldadka' wṉie' c̱hop x̱an soldad c̱he'ka' na' bene' mandad wzengakile' soldadka' wsini'a c̱hegake' kwenc̱he ichejgake' koogake' nez do ka chida ga waḻa' shajgake' Cesareana'. Na' bene' mandad c̱hop guiyoagake' shajgake' ṉi'azgake', na' giyonshigake' kwiagake' kabay na' zi c̱hop guiyoagake' gox̱'gake' lanza. ");
INSERT INTO zadNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Na' ḻekzka' golle' ḻegake' koogake' xa kabayka' wc̱hin Páblona' na' illine' shi'a shbane' lao Félixa', beena' chṉabia'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Na'ch bgox̱ee ḻegake' to yish dii na ki: ");
INSERT INTO zadNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Si'xengacho' beṉ' wṉabia' Félix, nad' Claudio Lisias chzej' li', na' chwap' li' chiox. ");
INSERT INTO zadNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ka nak beeni chseḻaa lawo'na', beṉ' Israelka' bex̱'gake'ne' na' ba zoa witgake'ne' sheḻ' ki nad' jasla'ne' len soldad c̱ha'ka', ḻa' wṉezid' ndie' kwent yell Rómana'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Na' daa goklallid' iṉezid' berac̱he chaogake' xya c̱he', jwaane' lao beṉ'ka' chṉabia' beṉ' Israelka'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Na' got'bia' chaogake' xya c̱he' daa bi chone' ka na ley c̱he'ka', per bi chonan ka guete' wa gatee lillya. ");
INSERT INTO zadNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Na' ka wṉezid' beṉ' Israelka' ba ngoogake' xṉezin witgake'ne', bc̱hoglallaa wseḻaane' lawo'na'. Na' ba gosh' beṉ'ka' chao xya c̱he' yidgake' lawo'na' na' iṉagake' li' bin chaklen c̱hegake' Pábloni. Ka'tz dii nia' li'.” ");
INSERT INTO zadNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Na'ch soldadka' lle' na' bc̱he'gake' Páblona' zejlengake'ne', bllinlentegake'ne' yella' le Antípatris kon ka goll beṉ' wṉabia' c̱he'ka' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Na' betiyo, soldadka' zej ṉi'azgake' bibiigake' ziyajgake' Jerusalénna'. Na' beṉ'ka' llia kabayka' zejlenchgake' Páblona'. ");
INSERT INTO zadNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Na' ka bllingake' Cesareana', be'gake' beṉ' wṉabia'na' yisha' nox̱'gake' na' bengake' Páblona' lo nee. ");
INSERT INTO zadNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Na' ka wde blab beṉ' wṉabia'na' yisha', na'ch wṉabile' Páblona' ga beṉaan. Na' ka wṉezile' Páblona' nake' beṉ' yell Tarso, daa llia gana' mbani Cilíciana', ");
INSERT INTO zadNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","na'ch golle'ne': ―Na' wzenagshkid' bin iṉo' kat' yid beṉ'ka' chao xya c̱ho'. Na'ch bene' mandad lljasejgake'ne' yoona' ben dii Heródeza', gana' chzoa beṉ' wṉabia'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Gok gay' lla zoa Páblona' Cesareana' ka bllin bx̱oz choo bx̱oz xenna', beena' le Ananías, na' nc̱hi'e baḻ beṉ' golka' chṉabia' na' kon to beṉ' wide dill', beṉ' le Tértulo. Na' bllingake' lao beena' chṉabia' kwenc̱he gaogake' xya c̱he Páblona'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Na'ch bdegake' Páblona' lao beṉ' wṉabia'na' le Félix na' wzolo Tértulona' chawe' xya c̱he', chi'e: ―Chox̱keno' li', beṉ' wṉabia', zoanto' mbalaz na' chak wen c̱hento' lallnto'ni daa chak koo xṉezi yog'ḻoḻte kon yeḻ' sin' c̱ho'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Na' daan, gattez zoanto' toshiizi nanto' li' chox̱keno' dii zan las, li' beṉ' wṉabia'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Na' kwenc̱he bich wshayinto' li', chṉabinto' li' gono' goklen wzenago' to c̱hop ka nak dga iṉanto' li'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ka nak beeni ze lawo'ni, ṉezinto' nake' to beṉ' chbek dii zed, na' chdaze' doxen yell-lioni chta chṉie' beṉ' kwenc̱he neto' beṉ' Israel gaknto' c̱hoplə, na' ngoo lo nee x̱oṉj beṉ' chonḻilall' to beṉ' Nazaret. ");
INSERT INTO zadNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ga biyollin, goklallee kwee ḻoo yoodo'na' beṉ' bi nak beṉ' Israel. Daan bex̱'nto'ne'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Na' wyaz beṉ' wṉabia' c̱he soldadka', beena' le Lisias, na' bigoyoe'ne' lo na'nto'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Na' wne' neto' chiyaḻ' yidnto' lawo'ni kwenc̱he gaonto' xya c̱he'. Na' kwino' ṉaa, wak iṉabilo' Pábloni kwenc̱he iṉezilo' bic̱he chaonto' xya c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Na' beṉ' Israelka' lle'lengake' na', bisc̱hopgake' dillaa che'gake': “Ka nakannan'.” ");
INSERT INTO zadNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Na'ch beṉ' wṉabia'na' bene' seṉ lao Páblona' kwenc̱he wi'e dill', na'ch wzolo Páblona' chi'e: ―Ṉezid' ba gok zan yiz chono' yeḻ' josc̱his c̱he beṉ'ki lle' gani mbanilo'. Daan chibaid' wi'a dill' daa chak c̱ha' lawo'ni. ");
INSERT INTO zadNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Zi' gok shlliṉ lla billin' Jerusalénna' jaye'lawaa Chioza', na' shi cheenilo' gakḻiyilo'n, wak iṉabo' kwenc̱he x̱enlalloo ka nakannan'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Na' kono ble'i nad' chakdiḻ-len' beṉ' wa chbekw' wdiḻ wishesh ladj beṉ', ni ḻoo yoodo'na' ni gan yoblə ga chdop chllagnto' choe'ḻwillnto' Chioza' ni gachli yella'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Na' ka nak diiki na beṉ'ki c̱ha', ni ton bi gongake' gan iṉagake' ka nakannan'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ḻete to dii wc̱heb' lawo'ni choe'lawaa Chioza', beena' be'la'o dii x̱ozxto'nto'ka', kon ka nak nez ḻi nez shao' c̱he Jesucrístona' daa yo'a, daa na beṉ'ki bi zejan shḻi. Per chajḻi'a yog' daa na ley c̱he Chioza' na' diika' bzej dii beṉ'ka' wdix̱jee daa golle' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Na' ka beṉ'ki chao xya c̱ha' na' ka nad', toz ka nonnto' lez yisban Chioza' beṉ' wetka', ka beṉ' wen ka beṉ' mal. ");
INSERT INTO zadNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Daan chon' byen yixi yiyech yic̱hjlall'dawaani, ḻa' cheenid' bibi doḻ' gap' lao Chioza' ni lao beṉ' yell-lioni. ");
INSERT INTO zadNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","’Ba gok zan yiz chda' yell zit'ka', na' billin' Jerusalénna' kwenc̱he wi'a mech dii gaklenan beṉ' wlall c̱ha'ka' na' ḻekzka' wi'a bi dii wi'a yoodo'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Na' diikin chon' ka biyoll bixi biyech' kon ka na leya', kat' to c̱hop beṉ' Israel, beṉ' zaak Ásiana', ble'gakile' nad' yoodo'na'. Aga no beṉ' ntop nshag' na' ni to wdiḻ wishesh bi mbek'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ḻegaken' chiyaḻ' yidgake' ni gaogake' xya c̱ha' shi bin ble'gakile' chon'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Wa beṉ'ki zoa ni, iṉashkigake' shi bi dii mal billelgakile' c̱ha' kana' jwa'gake' nad' lao beṉ' wṉabia' c̱hento'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","¿Awa shi daa besyaa goshgakee: “Chaozle xya c̱ha' daa chajḻi'a wllin lla yiban beṉ' wetka'”? ");
INSERT INTO zadNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Na' ka biyoll beni Félixa' wna Páblona' ka', na' bsane' bich bene' yeḻ' josc̱his c̱he'na', ḻa' ba wṉezile' nakan nak diika' chajḻe' beṉ'ka' yoo lo nez ḻi nez shao' c̱he Jesucrístona'. Na' golle' beṉ'ka': ―Kat' yid Lísiaza', beena' chṉabia' soldadka', kana' iṉezyeṉ'id' nakran nak dga chak c̱hele. ");
INSERT INTO zadNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Na'ch Félixa' golle' x̱an soldadka' wseje' Páblona', per bi wllone' sho' beṉ'ka' nombia' ḻe' na' llje'gake'ne' bi dii chyalljile'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Na' ka wde c̱hop shoṉ lla, bizllinlen Félixa' xoole'na' le Drusila, to nool Israel. Na'ch ben Félixa' mandad bllin Páblona' lawe'ka' kwenc̱he wzenaggake' dillaa daa cho'e daa ne' chiyaḻ' gonḻilall'cho Jesucrístona'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Na'ch be' Páblona' dill' chi'e chiyaḻ' goncho byen goncho wen na' bi goncho daa nazan c̱hecho, ḻa' wllin lla yizi' Chioza' kwent c̱he to tocho. Na' ka beni Félixa' xtilleena', ḻe bllebe'. Na'ch golle' Páblona': ―Ba gokz to ka't', na' kat' gat' latj c̱ha'na' iṉia' li' dii yoblə. ");
INSERT INTO zadNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Félixa' ḻekzka' goklallee we' Páblona' ḻe' mech kwenc̱he yisane'ne'. Daan zekizezi wṉie'ne' kwenc̱he be'lene'ne' dill'. ");
INSERT INTO zadNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ka'z wde c̱hop yiz, na' ka bichej Félixa' bich wṉabi'e na' wyoo to beṉ' yoblə lie' Porcio Festo. Na' kwenc̱he ile'shii beṉ' Israelka' Félixa', bi bisane' Páblona'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Na'ch ka bllin Féstona' Cesareana' kwenc̱he iṉabi'e, na' wzoe' shoṉ lla. Na'tech wzee wyaje' Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Na' bx̱ozka' chṉabia' na' nochlə beṉ'ka' chṉabia' beṉ' Israelka' ka wṉezgakile' ba blline' Jerusalénna', na'ch jtaogake' xya c̱he Páblona' lawe'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Na' wṉabgakile'ne' gone' to goklen yiseḻee Páblona' Jerusalénna' kwenc̱he gak yeḻ' josc̱his c̱he'na'. Gollgake'ne' ka' daa goklall'gake' witgake'ne' tneza'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Per goll Féstona' ḻegake': ―Cesareana'zkzə yigaaṉ Páblona', na' aga chllach yiyaa na'lə. ");
INSERT INTO zadNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Na' golle' ḻegake': ―Beṉ'ka' chṉabia' le' chiyaḻ' sa'lengake' nad' Cesareana' kwenc̱he gaole xya shi bi dii malan bene'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Na' ka do zi ga shi lla wzoa Féstona' Jerusalénna', na' bizee ziyaje' Cesareana'. Na' betiyo wchi'e gana' gone' yeḻ' josc̱hisa' na' bene' mandad jx̱i'gake' Páblona'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Na' ka wyoo Páblona' gana' chi' Féstona' lii wbig'te beṉ' Israelka' zaak Jerusalénna' chaogake' xya c̱he', che'gake' dii zan dii mal ba bene', per na' ni to daa wdaogake' xya c̱he' bi bengake' gan ye'gake' ka nakannan'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Na'ch Páblona' bzoa rson c̱he', chi'e ḻegake': ―Nad' ni tlish' dii mal biṉ' gon', ni biṉ' c̱hishj' ley c̱hento'na' neto' beṉ' Israel, ni biṉ' wnit' balaaṉ c̱he yoodo' c̱hento'na', ni bigaṉ' iṉia' zban c̱he Césara' beena' chṉabia'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Na' daa goklall' Féstona' ile'shii beṉ' Israelka' ḻe', na' chi'e Páblona': ―¿Acheenilo' yiyajo' Jerusalénna' kwenc̱he gon' yeḻ' josc̱his c̱ho'na' na'lə? ");
INSERT INTO zadNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Na' Páblona' chi'ene': ―Ba zia' lawo'ni, na' beṉ' wṉabia' Césara' ba nzoe' li' ni kwenc̱he gono' yeḻ' josc̱his, na' nin chiyaḻ' gak yeḻ' josc̱his c̱ha'na'. Ṉezkzilo' aga bi ben' c̱he beṉ' wlall c̱ha'ki. ");
INSERT INTO zadNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Shi ba ben' dii chon ka chidoḻaa guet', wakkzə guet'. Per shi bibi ben' c̱he beṉ'ki chao xya c̱ha', kono gak gon nad' lo na'gake'. Na' chṉab' wdio' nad' lao beṉ' wṉabia' Césara' kwenc̱he kwine' gone' yeḻ' josc̱his c̱ha'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Na'ch Féstona', ka wde be'lene' dill' beṉ'ka' chaklen ḻe' chone' yeḻ' josc̱hisa', na'ch chi'e Páblona': ―Ba wṉabo' tio' lao beṉ' wṉabia' Césara' kwenc̱he gone' yeḻ' josc̱his c̱ho'na', na' wseḻaa li' lawe'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Na' gok c̱hop shoṉ lla na'ch bllin beṉ' wṉabia' Agrípana' len Berenícena' yell Cesareana' jawapgake' Féstona' chiox. ");
INSERT INTO zadNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Na' daa wzoagake' Cesareana' zan lla, Féstona' be'lene' Agrípana' dill' ka nak daa chak c̱he Páblona', na' golle'ne': ―Ni nej to beṉ' bi ben Félixa' yeḻ' josc̱his c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ka wya' Jerusalénna', beṉ' wṉabia' c̱he bx̱ozka' na' beṉ' golka' chṉabia' beṉ' Israelka' wdaogake' xya c̱he' lawa'na', goklall'gake' wc̱hogbi'a guete'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Na' gosh'gakee ka choncho cho' beṉ' Roma, aga lii wc̱hogbia'tezcho guet to beṉ' shi bi sie' wzoa rson c̱he' lao beṉ'ka' chao xya c̱he'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Daan, ka bid beṉ'ka' bidtao xya c̱he', bi bshe'ida'n, san betiyoz lii bentia' wṉeyi jx̱i'gake'ne' kwenc̱he gon' yeḻ' josc̱his c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Na' beṉ'ka' bidtao xya c̱he', ni tlish' diika' wza'lallaa bene' bi wnagake'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Daa zeelo nagake' c̱he', nlla'lə chajḻi'e c̱he Chioza' na' chde' cho'e dill' c̱he to beṉ' wle Jesús, beena' ba wit, na' ḻe' ne' mbankze'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Na' daa bi ṉezid' nak gon' yeḻ' josc̱his c̱he beṉ'ki, wṉabid' ḻe' shi cheenile' yiza'lene' nad' Jerusalénna' kwenc̱he gak yeḻ' josc̱his c̱he'na' na'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Per Páblona' wṉabe' tie' lao César Augústona' kwenc̱he gone' yeḻ' josc̱his c̱he'na', na' ben' mandad shejze' ax̱t kat'ch gak wseḻaane' Rómana'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Na'ch Agrípana' golle' Féstona': ―Ḻekzka' cheenid' wzenag' ka dillaa cho'e. Na' Féstona' chi'ene': ―Wx̱ete wzenago'n, shka'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Na' betiyo bllin Agrípana' ḻega beṉ' zakii, len Berenícena' na' len baḻ beṉ'ka' chṉabia'gake' soldadka', na' beṉ'ka' mbejlawin yella'. Na'ch Féstona' bseḻee beṉ' jx̱i'gake' Páblona'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Na' wṉe Féstona', chi'e: ―Li' beṉ' wṉabia' Agripa, na' yog'le le' lle'le ni, ka nak beeni ze ni, yog' beṉ' Israelka', ka beṉ' lle' Jerusalénna' na' ka beṉ' lle' Cesareani, chaogake' xya c̱he', na' chongake' byen c̱hogbi'a guete'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Na' nad' chakbe'id' aga bi dii mal ba ben beeni kwenc̱he c̱hogbi'a guete'. Na' kwine' ba wṉabe' tie' lao César Augústona' kwenc̱he gone' yeḻ' josc̱his c̱he'na', na' ba bc̱heb' wdia'ne' na'lə. ");
INSERT INTO zadNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Per bi chillelid' bin ben Pábloni kwenc̱he wzej' Césara' yepee bin bene'. Daan ba nzia'ne' laoleni na' lawo'niyeṉ'kzə li', beṉ' wṉabia' Agripa, kwenc̱he iṉabyollichone' bin bene', na' ka' wllia' ḻee yisha'. ");
INSERT INTO zadNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ḻa' chakid' bi nakan wen wseḻaa to beṉ' lawe'na' kwenc̱he wc̱hogloe' c̱he' na' bi nzej' bin bene'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Na' Agrípana' golle' Páblona': ―Bzoashki rson c̱ho'na' ṉaa. Na'ch Páblona' bḻis neena' na' wzoloe' bi'e dillaa, chi'e: ");
INSERT INTO zadNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","―Li' beṉ' wṉabia' Agripa, mbalaz wal chakid' daa gak wzoa rson c̱ha'ni lawo'ni c̱he yog' diika' chao beṉ' Israelka' xya c̱ha'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ḻa' ṉezkzilo' ka yoolo neto' beṉ' Israel chonnto', na' ḻekzka' c̱he diḻ c̱hix̱ c̱hento'ka'. Daan chṉab' gapgacho' yeḻ' chxenlall' na' wzenaggacho' ka nak dga iṉia' li' ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","’Yog'ḻoḻ beṉ' Israelka' ṉezgakile' ka bsa' c̱ha' ladje'ka', ka yell c̱ha'na' gana' bgol' na' ka Jerusalénna'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Na' ḻekzka' ṉezgakile' toshiizi nak' toz fariseoka', beṉ'ka' chzenagchgake' c̱he ley c̱he dii Moiséza' aga ka nochlə beṉ' yoblə. Na' wak yizi' cho'agake'n shi gueengakile'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Na' ṉaa chaogake' xya c̱ha' daa non' lez wllin lla gon Chioza' ka bc̱hebe' lao dii x̱ozxto'nto'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Na' neto' naknto' shlliṉ kwente dia c̱he dii Israela', nonnto' lez gon Chioza' daa bc̱hebe' gak, na' daan choe'la'onto' Chioza' ka tella ka waḻ. Na' daa non' lez gak daa bc̱heb Chioza', daan chao beṉ' Israelki xya c̱ha', li' beṉ' wṉabia'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Berac̱he bi chajḻe'le wak yisban Chioza' beṉ' wetka'? ");
INSERT INTO zadNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","’Ḻekzka' nad' gokid' chiyaḻ' wsak'zi'a beṉ'ka' nonḻilall' Jesús, beṉ' Nazareta'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Na' ka' ben' Jerusalénna'. Na' bx̱ozka' chṉabia' beṉgake' lsens wlo'a lillyana' beṉ'ka' nonḻilall' Jesúza', na' ka betgake' ḻegake' ḻekzka' len' chakid' kan' chiyaḻ' gak. ");
INSERT INTO zadNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Zan shii wya' gana' chdop chllagnto' choe'ḻwillnto' Chioza' na' biya dii benid' ḻegake' kwenc̱he iṉegake' zban c̱he Jesucrístona'. Na' ḻe bllaachga' ḻegake', ax̱t yell zit'ka' wya' jasak'zi'gakee. ");
INSERT INTO zadNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","’Na' ḻekzka' nan lljenid' beṉ'ka' nonḻilall' Jesúza' yell Damáscona', na' bx̱ozka' chṉabia' bseḻ'gake' nad' na' beṉgake' lsens lljasak'zi'gakee. ");
INSERT INTO zadNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Na' ki gok c̱ha', li' beṉ' wṉabia'. Ka zyaa ngwaa neza', do ka gobill ble'id' to yi' wal dii za' yabana' dii chzeeni'ch aga ka wbilla', na' wyec̱hjan nad' len beṉ'ka' zyaalen'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Yog'tento' wzoatishnto' lo yona', na'ch nad' benid' shii to beṉ' wṉie' nad' dill' hebreo, ne': “Saulo, Saulo, ¿berac̱he chc̱hi' chsak'zo' nad'? Daa chono' ka', zi' c̱he kwinzon' chono' na' chak c̱ho' ka chak c̱he gooṉa' chilibb xisa' daa chbibe'b kwenc̱he sa'b.” ");
INSERT INTO zadNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Na'ch wnia', chepee: “¿Nora li', beṉ'?” Na' wne': “Nadaan Jesúza', beena' chc̱hi' chsakoo. ");
INSERT INTO zadNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Na' ṉaa biyas. Ba bli'law' li' kwenc̱he gono' ka cheenid' na' kwenc̱he wi'o dill' c̱he dga chen chle'ilo' ṉaa na' c̱heyi diika' zi' wliid' li'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Na' wseḻaa li' gana' lle' beṉ'ka' bi nak beṉ' Israel, na' gaklen' li' kwenc̱he ni ḻegake' na' ni beṉ' Israelka' bi witgake' li'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Na' wseḻaa li' kwenc̱he lljali' lljasedilo' ḻegake' kwenc̱he sho' beeni' c̱ha'na' ḻoo yic̱hjlall'do'eka' na' bich tagake' lo yel c̱hoḻa'. Gono' ka bich iṉabia' Satanáza' ḻegake', san gonḻilall'gake' Chioza' na' gonḻilall'tegake' nad' na' yizi'xen' xtoḻeeka'. Na' lengake' ikaagake' daa we' Chioza' beṉ'ka' nak lall' nee.” ");
INSERT INTO zadNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","’Kan' gok c̱ha', li' beṉ' wṉabia' Agripa, na'chan bzenag' daa wna Jesúza' ka bli'lawe' nad'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Na' zigaate beṉ' Damáscoka' bli' bsedid' cho'a xtill' Jesucrístona', na'tech beṉ' Jerusalénka', na' beṉ' lle' doxen yell-lio Judeana', na' ḻekzka' beṉ'ka' bi nak beṉ' Israel. Gosh'gake' chiyaḻ' yiyaj yileni c̱he xtoḻeeka' na' wzenaggake' c̱he Chioza', na' gongake' ka gakbe'i beṉ' nan ba biyaj bilengakile'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Na' ni c̱heyi diikin, bex̱' beṉ' wlall c̱ha'ka' nad' yoodo'na' na' nan witgake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Per Chioza' chaklene' nad' kwenc̱he choe'ch' xtilleena' lao beṉ' ax̱t ṉaanlla, ka lao beṉ' zakii na' ka lao beṉ' bi zakii. Na' kon ka wnakz dii Moiséza' gak na' ka wnakzə dii beṉ'ka' wdix̱jee daa goll Chioza' ḻegake' kani'yi, kon kakzan nia', aga bichlə dii yoblan nia'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ḻa' ḻegake' wnagake' Chioza' nllie' bia' Crístona', beena' wseḻee, yiya dii yen ile'ile' na' witgake'ne', na' ḻen' gake' beṉ' necha' yibane' ladj beṉ' wetka', na' c̱hix̱je'ile' beṉ' Israelka' na' beṉ'ka' bi nak beṉ' Israel nakan chiyaḻ' gongake' kwenc̱he sho' beeni' c̱he'na' ḻoo yic̱hjlall'do'eka'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Na' shlak Páblona' chzoa rson c̱he'na', besyaa Féstona', chi'ene': ―¡Chaktonto'n, Pablo! Daa zi'telə chsedo' ba chontontin li'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Na' Páblona' chi'ene': ―Aga chaktonta'n, beṉ'do', san dill' ḻin cho'a, na' nakan dii shajḻe'cho. ");
INSERT INTO zadNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Na' beṉ' wṉabia' Agrípani ṉezile' c̱he yog' diiki nia' le', daan chiyaxjid' cho'a dill' lawe'ni. Aga iṉacho bi ṉezile' diika' gok, ḻa' ga lle' lla' beṉaan gokan. ");
INSERT INTO zadNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Na' li', beṉ' wṉabia' Agripa, ¿achajḻi'o cho'a xtill' Chioza' daa bzej dii beṉ'ka' wdix̱jee daa golle' ḻegake' kani'yi? Nad' ṉezid' chajḻi'o. ");
INSERT INTO zadNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Na'ch Agrípana' chi'e Páblona': ―¿Achakilo' xtitz wshaljleno' nad' cho'a xtill' Jesúza' na' gonḻilallaane'? ");
INSERT INTO zadNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Na'ch Páblona' chi'ene': ―Ḻa' xtitzə wa ḻa' ssha wshaljlen' li', Chioza' wi'e latj aga tozo' li' shajḻi'o san yog' beṉ'ki lle' ni chengakile' dillii cho'a shajḻe'gake' ka ba wyajḻi'a nad', per aga nia' wc̱hejgake' ḻegake' gden ka nc̱hejgake' nad'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Na' ka biyoll wna Páblona' ka', na'ch bizolla' Agrípana' na' Berenícena' len Féstona' na' yog' beṉ'ka' wche'lengake'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Na'ch bichejgake' gana' lle'gake' na' be'gake' dill', che' ljwelle': ―Aga bi ben beeni kwenc̱he c̱hogbi'a guete' ni bi chiyaḻ' gatee lillyana'. ");
INSERT INTO zadNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Na'ch Agrípana' golle' Féstona': ―Wak yislacho beeni sheḻ'ka' ki ba wṉabe' tie' lao beṉ' wṉabia' Césara' kwenc̱he gone' yeḻ' josc̱his c̱he'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Na'ch ka bc̱hoglall'gake' wseḻ'gake' neto' Itáliana' ḻoo barkwlə, bengake' Páblona' kon sto c̱hop pres yoblə lo na' beena' le Julio, nake' x̱an to guiyoa soldadka' beṉ'ka' nzi' soldad c̱he beena' chṉabia' Rómana'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Na'ch wyoonto' to ḻoo barkw dii za' yell Adramítiona' na' zejan Ásiana'. Na' wza'len to beṉ' le Aristarco neto'. Nake' beṉ' Tesalónica, daa llia gana' mbani Macedóniana'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Na' betiyo bllinnto' yell Sidónna', na' Júliona' ḻe wen benile' Páblona' na' bi'e latj jawie' beṉ'ka' nombi'e yella' kwenc̱he be'gake'ne' bi dii byalljile'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Na' ka biza'nto' Sidonna' na' wdeteznto' yic̱hjlə yell-lio Chíprena' daa llia lo nisdo'na' kwenc̱he bkweejan neto' daa ḻe ze be'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Na' wdetento' lo nisdo'na' daa de tcho'a yell-lio gana' mbani Cilíciana' na' Panfíliana', na' bllinnto' cho'a yell Mírana', daa llia gana' mbani Líciana'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Na' yell Mírana' x̱an soldadka' bllelile' to barkw dii za' Alejandríana' na' zejan Itáliana', na' bidie' neto' ḻo'inna'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Na' zan lla wyajlennto' barkwa' sho'lall'zə, na' kaṉi bllinnto' cho'a yell Gnídona'. Na' daa ze be'na' klelə, na' wyec̱hjnto' yell-lio Crétana' daa llia lo nisdo'na', wdeteznto' cho'a yell Salmónna'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Na' kaṉi gok zejnto' tcho'a nisdo'na' ax̱t ni bllintento' gana' le Buenos Puertos, gaozə yell Laseana'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Zan llate ba wllainto' na' ba chonan dii nxoll shajchnto' lo nisdo'na' daa ba zoa yiḻen dii zaga'. Na' goll Páblona' ḻegake': ");
INSERT INTO zadNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","―Chakbe'id' shi shajchcho nxoll kwiayi' barkwi na' kwiayi'te yoa'na' nsa'n, na' aga toz diiki san lenkzcho ḻe nxoll kwiayi'cho. ");
INSERT INTO zadNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Per na' x̱an soldadka', bzenagche' c̱he beena' chsa' barkwa' na' c̱he x̱aninna', na' bi bzenague' daa goll Páblona' ḻegake'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Na' daa bi nak latja' wen yigaaṉnto' na'z shlak chi' dii zaga', zangake' bc̱hoglall'gake' shajchnto' kwenc̱he illinnto' yell Fenícena' gana' yigaaṉnto' shlak te dii zaga'. Nakan to latj ga mbani Crétana', gana' choo barkwka', na' bitek choon be'na' daa za' cha'lə ni daa za' lli'lə. ");
INSERT INTO zadNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Na'ch wzolo ze to be'ḻes dii za' lli'lə, na' beṉ'ka' chsa' barkwa' gokgakile' wakkzə shajgake'. Na'ch wdegake' tcho'azi yell-lio c̱he Crétana' daa llia lo nisdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ka gok shloll, wzolo to be' wal dii za' cha'lə. ");
INSERT INTO zadNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Na'ch wzolon chlligaan barkwa' na' bikzə bi gok gonnto', na' bsanlall'choklənto'n nllig' be'na' ḻen. ");
INSERT INTO zadNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Na' ka wdento' gaozə to yell-liodo' le Clauda daa llia lo nisdo'na', na' bich zetek be'na'. Na'ch barkwdo'na' ngoyo barkw xenna' biḻepnto'n ḻoo barkw xenna', per kaṉi gokan. ");
INSERT INTO zadNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Na' ka biyoll biḻepnto'n, na'ch bc̱hejgake' barkw xenna' rietka' kwenc̱he goklenan daa. Na' daa bllebgake' lljshia barkwa' lo yoxa' latja' le Sirte, na' bitobgake' lech'ka' daa chonan ka chza' barkwa' na' be'gake' latj bllig' be'na' barkwa' kwenc̱he shajan kon ga wlliga'n ḻen. ");
INSERT INTO zadNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Na' betiyo, daa zizikli wzech be'na', na' wzologake' bsheshgake' yoa'na' nsa' barkwa' na' bzaḻ'gake'n ḻoo nisdo'na' kwenc̱he bichtek gok barkwa' zii. ");
INSERT INTO zadNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Na' ka gok shoṉ lla, ax̱t len xshinḻaz barkwa' bzaḻ'nto' ḻoo nisdo'na'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Na' zan lla bi bli'lao wbilla' ni beljka', na' daa zechga be'na', bich bennto' lez yilanto'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Na' ka ba gok zan lla biṉ' gaonto', na'ch Páblona' wzie' ladj beṉ'ka' na' chi'e ḻegake': ―Sheḻ' bzenagle c̱ha' kana' zoacho Crétana', ka wnia' le' bich shajcho, aga bi bṉitcho ni bi zoacho dii nxoll, sheḻ'ka'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Na' ṉaa bikzə gonc̱hoplall'zle, ḻa' ni tole bi guet. Toz barkwi kwiayi'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ḻa' daa nlle'yi Chios c̱ha'na' beena' chonḻilallaa bseḻee to anjl bli'lawe' nad'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Na' anjla' wne' nad': “Bi illebo' Pablo. Chonan byen illino' lao beṉ' wṉabia' Césara', na' ni c̱ho' li' yiyesh'lallii Chioza' yog' beṉ'ka' zejleno' txen ḻoo barkwi na' bi guetgake'.” ");
INSERT INTO zadNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Na' ṉaa, ḻi wtiplall'le, ḻa' nx̱enilallaa Chioza' na' ṉezyeṉid' kon ka wna anjla' nad' kayeṉ'nan gak. ");
INSERT INTO zadNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Per chonan byen wwiacho naklə goncho kwenc̱he yichooṉan cho' to lo yell-liodo' dii llia lo nisdo'ni. ");
INSERT INTO zadNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Na' ba gok shda' wbill ka bllinnto' gana' de Nisdo' Adriáticona', na' ni chllig' be'na' barkwa' to ki to ka'lə lo nisdo'na'. Na' ka bllin chel, beṉ'ka' chsa' barkwa' gokbe'gakile' ba chllinnto' gana' de yo billa'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Na'ch bḻetjgake' to ya kwenc̱he bchix̱gake' ka'k' zitj nisa', na' ka bchix̱gake'n zitjan shin'toyichoa metr. Na'ch ka wza'n zilat' na'ch bizchix̱gake'n dii yoblə na' zitjan gallichoa metr. ");
INSERT INTO zadNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Na' daa bllebgake' lljsho' barkwa' ḻee yajka', bḻetjgake' tap ya xen dii llia xoziin kwenc̱he kwe' barkwa' tozga, sheḻ' wxegakile' lii sheeni'te. ");
INSERT INTO zadNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Na' beṉ'ka' chsa' barkwa' gokgakile' yixoṉjgake'. Na'ch wzologake' chḻetjgake' barkwdo'na' daa yoo ḻoo barkw xenna', chontezgake' ka chḻetj sto ya xen c̱he barkwa'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Na'ch Páblona' golle' x̱an soldadka' na' soldad c̱he'ka': ―Shi beṉ'ki bich yigaaṉgake' ḻoo barkwi, aga wilalat'le shi ṉaa. ");
INSERT INTO zadNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Na'ch soldadka' bc̱hoggake' rietka' daa nchej barkwdo'na' na' bxopan ḻoo nisa'. ");
INSERT INTO zadNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Na' ka ba zoa sheeni' Páblona' golle' ḻegake': ―Ḻi gaolat'. Ba gok shda' wbill bi ch