﻿USE sofia;
DROP TABLE IF EXISTS sofia.zacNT_vpl;
CREATE TABLE zacNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zacNT_vpl WRITE;
INSERT INTO zacNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ndëꞌë na listë shtë ra shtadë guëlú Jesucristo. Guc më llëbní David nu guc më llëbní Abraham. ");
INSERT INTO zacNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham guc shtadë Isaac. Hia na gubani Isaac gúquiꞌ shtadë Jacob. Hia lë́ꞌiꞌ gúquiꞌ shtadë Judá con ra bë́chiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá guc shtadë Fares nu Zara. Tseꞌlë Judá bërulë́ Tamar. Fares guc shtadë Esrom; hia na gubani Esrom gúquiꞌ shtadë Aram. ");
INSERT INTO zacNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram guc shtadë Aminadab. Hia tiempë na gubani Aminadab gúquiꞌ shtadë Naasón. Hia lëꞌë Naasón gúquiꞌ shtadë Salmón. ");
INSERT INTO zacNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón guc shtadë Booz; shniꞌa Booz guc Rahab; Booz guc shtadë Obed; shniꞌa Obed guc Rut. Obed guc shtadë Isaí. ");
INSERT INTO zacNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí guc shtadë rëy David. Hia rëy David guc shtadë Salomón nu shniꞌa Salomón guc tseꞌlë tëgulë Urías. ");
INSERT INTO zacNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón guc shtadë Roboam. Hia lëꞌë Roboam guc shtadë Abías. Hia lëꞌë Abías guc shtadë Asa. ");
INSERT INTO zacNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa guc shtadë Josafat nu Josafat guc shtadë Joram. Hia na gubani Joram gúquiꞌ shtadë Uzías. ");
INSERT INTO zacNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías guc shtadë Jotam nu Jotam guc shtadë Acaz. Hia na gubani Acaz gúquiꞌ shtadë Esequías. ");
INSERT INTO zacNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esequías guc shtadë Manasés. Hia na gubani Manasés gúquiꞌ shtadë Amón nu Amón gúquiꞌ shtadë Josías. ");
INSERT INTO zacNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías guc shtadë Jeconías nu con ra bë́chiꞌ. Tiempë ni biaꞌa ra mënë lëꞌë ra israelitë ziquë prësi parë Babilonia. ");
INSERT INTO zacNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Despuësë de ni, Jeconías guc shtadë Salatiel nu guc Salatiel shtadë Zorobabel. ");
INSERT INTO zacNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel guc shtadë Abiud. Hia na gubani Abiud gúquiꞌ shtadë Eliaquim nu Eliaquim gúquiꞌ shtadë Azor. ");
INSERT INTO zacNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor guc shtadë Sadoc. Hia iurë na gubani Sadoc gúquiꞌ shtadë Aquim. Aquim guc shtadë Eliud. ");
INSERT INTO zacNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud guc shtadë Eleazar nu Eleazar gúquiꞌ shtadë Matán. Matán guc shtadë Jacob. ");
INSERT INTO zacNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob guc shtadë José, tseꞌlë María. Hia lë́ꞌiꞌ guc shniꞌa Jesús. Jesús nápiꞌ stubi lë, Cristo. ");
INSERT INTO zacNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Manërë ni naescritë ndëꞌë chidá generación, mënë naná shtadë guëlú Jesús; gubani raiꞌ entrë Abraham hashtë David. Nu zac naescritë ndëꞌë lë shtadë guëlú Jesús naná guc stubi chidá generación entrë David hashtë biaꞌa ra mënë ra israelitë parë Babilonia. Nu naescritë ndëꞌë lë shtë mënë naná stubi chidá generación, ra naguquëreldë dizdë tiempë gua raiꞌ Babilonia hashtë gulë Jesucristo. ");
INSERT INTO zacNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Zndëꞌë guc iurë gulë Jesucristo. María, shniꞌa më nápiꞌ comprumisi parë guëtsë́ꞌaiꞌ con José. Antsë de quë guëquëreldë raiꞌ juntë, hia lëꞌë María bëdzéliꞌ nua shíniꞌ por pudërë shtë Espíritu Santo. ");
INSERT INTO zacNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, tseꞌlë María, na tubi nguiu zaꞌquë. Guc shtuꞌu José niasáꞌniꞌ lëꞌë María sin quë adë niac bë́ꞌadiꞌi ra mënë parë adë guërúꞌudiꞌi shtu shtë María. ");
INSERT INTO zacNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mientras quëhúniꞌ llgabë zni, tubi ianglë shtë Dios bëluaꞌalú lu mbëcaꞌldë nu repi ianglë: ―José, llëbní David, adë rdzë́bëdiꞌil gúnël recibir María cumë ziquë tséꞌlël purquë lëꞌë shíniꞌ zéꞌdiꞌ por pudërë shtë Espíritu Santo. ");
INSERT INTO zacNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Lëꞌë María gápiꞌ tubi shíniꞌ nu guërulë́ meꞌdë Jesús. Zni guërulë́ meꞌdë purquë lë́ꞌiꞌ gúniꞌ salvar ra shmënë më de grë duldë shtë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Grë́tëꞌ ndëꞌë guzac parë gac cumplir lo quë naguniꞌi Dadë Dios lu muzë nabiadiꞌdzë shtiꞌdzë më guahietë; bëquë́ꞌëiꞌ: ");
INSERT INTO zacNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Lëꞌë lliguënaꞌa gua shíniꞌ nu gápiꞌ tubi meꞌdë naguërulë́ Emanuel. Lë ni runë cuntienë: Dios con lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iurë lëꞌë José gubani lu mbëcaꞌldë, bë́ꞌniꞌ tal cumë guniꞌi ianglë lúhiꞌ. Bë́ꞌniꞌ recibir María cumë ziquë tséꞌliꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Perë adë guquëréldëdiꞌi raiꞌ ziquë tséꞌliꞌ hashtë iurë lëꞌë shini María bëdchini lu guë́ꞌdchiliu. Iurní bëdëꞌë José lë meꞌdë; bërulë́hiꞌ Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iurë Jesús gulë guëꞌdchi Belén, tubi guëꞌdchi shtë Judea, lëꞌë Herodes na rëy naquëgnibëꞌa guëdubi lugar ni. Iurní bëdchini ra rëy mago hashtë ciudá Jerusalén. Zeꞌdë raiꞌ de nezë guiaꞌa zitu. ");
INSERT INTO zacNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Gunaꞌbë diꞌdzë ra mënë ni: ―¿Ca gulë rëy shtë ra më israelitë? purquë nezë guiaꞌa guná naꞌa lu mbelëguiꞌi shtë́hiꞌ; por ni zëꞌpë naꞌa parë guëdëꞌnë naꞌa adorar lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Iurë lëꞌë rëy Herodes bini ra diꞌdzë ni, adë bëdzélëdiꞌi pë gúnëll; adë gurëdchídiꞌi ldúꞌull. Nu grë́tëꞌ mënë shtë Jerusalén guzac rall zni. ");
INSERT INTO zacNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Iurní lëꞌë rëy gunaꞌbë grë ra jëfë shtë ra bëshuzi nu grë ra narluaꞌa lëy nabëquëꞌë Moisés entrë ra mënë israelitë. Gunaꞌbë diꞌdzë rëy: ―¿Ca galë Cristo? ");
INSERT INTO zacNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Lëꞌë rall bëquebi: ―Guëdchini Cristo Belén shp3 Judea purquë zni bëquëꞌë tubi muzë shtë Dios guahietë. Naescritë zndëꞌë: ");
INSERT INTO zacNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Lë́ꞌël Belén, guëꞌdchi shtë Judá. Nal tubi guëꞌdchi mituꞌnë perë nídiꞌi stubi guëꞌdchi más importantë quë lë́ꞌël entrë ra guëꞌdchi shtë Judá naná importantë. De lë́ꞌël guëdchini tubi më ruꞌbë nagapë grë́tëꞌ shmëna. ");
INSERT INTO zacNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Iurní lëꞌë Herodes gunaꞌbë lëꞌë rëy mago guitsë guitsë. Nu gunaꞌbë díꞌdzëll tubi tiempë namás ecsactë guc bëluaꞌalú mbelëguiꞌi lu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Iurní guniꞌi Herodes lu ra mago tsa raiꞌ Belén nu répill: ―Gulë tsagná ndë nu gulë tsagnaꞌbë diꞌdzë zaꞌquë zaꞌquë shcuendë meꞌdë. Iurë lëꞌë të guëdzelë të meꞌdë, iurní gulë bëꞌnë visi na purquë rac shtuaꞌa tsaguëna adorar lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Gualú bini ra mago shtiꞌdzë rëy, iurní ziaꞌa raiꞌ. Lëꞌë mbelëguiꞌi naguná raiꞌ nezë guiaꞌa, ziáꞌasë delantë lu raiꞌ hashtë por fin lëꞌë mbelëguiꞌi guzudchí lugar catë nanú meꞌdë. ");
INSERT INTO zacNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Iurë lëꞌë mago guná lu mbelëguiꞌi guzudchí, nalë́ bëquitë lduꞌu raiꞌ con lëgrë ruꞌbë laꞌni lduꞌu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Iurë guatë́ raiꞌ laꞌni hiuꞌu, guná raiꞌ lu meꞌdë nu María, shniꞌa meꞌdë. Iurní bëzullibi ra rëy; bëꞌnë raiꞌ adorar lëꞌë meꞌdë. Lueguë bëshaꞌlë raiꞌ cajë nanuaꞌa raiꞌ parë bëzëlaaꞌdchi raiꞌ orë, gushialë nu mirra. ");
INSERT INTO zacNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Despuësë guniꞌi shcaꞌldë raiꞌ lu mbëcaꞌldë de quë guëabrídiꞌi raiꞌ lu rëy Herodes. Bëabrí raiꞌ ladzë raiꞌ perë hia por stubi nezë. ");
INSERT INTO zacNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Despuësë de zëagzë́ ra mago, tubi ianglë shtë Dios bëluaꞌalú lu mbëcaꞌldë lu José nu repi ianglë: ―Guashtë́; gudëdchi meꞌdë; gulë gua con shniꞌa meꞌdë. Gulë gua nasesë guëꞌdchi shtë Egipto të ndë guëquëreldë të hashtë iurë lëꞌë na guëniaꞌa guëabrí të ladzë të purquë lëꞌë rëy Herodes tsatílill lëꞌë meꞌdë parë gati meꞌdë. ");
INSERT INTO zacNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Iurní guashtë́ José; bëruꞌunú raiꞌ meꞌdë laꞌni gueꞌlë parë Egipto. ");
INSERT INTO zacNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ngaꞌli guquëreldë raiꞌ hashtë iurë lëꞌë rëy Herodes guti. Zni guc cumplir lo quë naguniꞌi Dios por diꞌdzë nabëquëꞌë muzë shtë më guahietë. Guníꞌiꞌ: “Hashtë naciuni Egipto gunaꞌba shinia”. ");
INSERT INTO zacNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Iurë lëꞌë Herodes bëdëꞌë cuendë de quë lëꞌë ra mago guluguë́ rall lëꞌë rëy, iurní nalë́ bëdchini llanë laꞌni ldúꞌull. Nu gunibë́ꞌall gati grë ra ngulëꞌnë nanapë chupë izë parë guetë naquëreldë Belén, con ra meꞌdë nananú guëdubi alrededurë lugar ni. Zni bëꞌnë rëy según tiempë ecsactë naguniꞌi ra mago bëluaꞌalú mbelëguiꞌi lu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Zni guc cumplir lo quë naescritë por Jeremías, muzë shtë Dios: ");
INSERT INTO zacNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Bini tubi bë ruꞌbë; grë́tëꞌ ra naꞌa naquëreldë regiuni Ramá, biꞌni raiꞌ nu guá lduꞌu raiꞌ. Raquel rúꞌniꞌ por shíniꞌ perë adë nídiꞌi mudë parë chu gunë consolar lëꞌë raiꞌ purquë grë́tëꞌ ra meꞌdë gunitilú raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Perë despuësë guti Herodes, lëꞌë ianglë shtë Dios bëluaꞌalú lu mbëcaꞌldë lu José catë quëreldë raiꞌ Egipto nu repi ianglë: ");
INSERT INTO zacNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Guashtë́; gudëdchi meꞌdë; gulë gua con shniꞌa meꞌdë të guëabrí të naciuni Israel stubi. Hia lëꞌë mënë naguc shtuꞌu quini lëꞌë meꞌdë, guti rall. ");
INSERT INTO zacNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Iurní José guashtë́. Biáꞌaiꞌ meꞌdë con shniꞌa meꞌdë parë regiuni Israel. ");
INSERT INTO zacNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Iurë José bini de quë Arquelao quëgnibëꞌa Judea shlugar shtádëll Herodes, bëdzëbë José niáhiꞌ ndë, perë lu mbëcaꞌldë gua tubi visi de quë guëgzë́hiꞌ regiuni shtë Galilea. ");
INSERT INTO zacNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Iurë bëdchini raiꞌ ngaꞌli, iurní guquëreldë raiꞌ guëꞌdchi Nazaret. Zndë guzac parë guc cumplir lo quë naguniꞌi ra muzë shtë Dios guahietë: “Guërulë́ më Nazareno”. ");
INSERT INTO zacNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tiempë dzë ni Juan Bautista bëdchini Judea hashtë tubi shlatë catë adë quëréldëdiꞌi mënë. Quëadiꞌdzë Juan dizaꞌquë shtë Dios; ");
INSERT INTO zacNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","guníꞌiꞌ: ―Gulë bëꞌnë nadzëꞌë mudë nabani të purquë hia lëꞌë iurë bëgaꞌa parë guënibëꞌa Dios shmënë më. ");
INSERT INTO zacNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Lëꞌë Juan na el quë naguniꞌi Isaías, muzë shtë Dios. Bëquë́ꞌëiꞌ shtiꞌdzë Dios manërë rëꞌ: Guini të tubi bë shtë tubi mënë narniꞌi fuertë lu tubi shlatë ruꞌbë: “Gulë bëꞌnë preparar nezë shtënë Dadë. Gulë bëꞌnë preparar laꞌni lduꞌu të ziquë nezë ldi parë iurë guëdchini Dadë. Gulë gubani tubi vidë zaꞌquë.” ");
INSERT INTO zacNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Lari shtë Juan nactsáꞌuhin con guitsë ladi camellë. Hia cinturón shtë́niꞌ na tubi guiꞌdi, nu dau shtë́niꞌ guc shanchi nu dchini shtë mbeeꞌzë lachi. ");
INSERT INTO zacNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Iurní glli glli rdchini ra mënë shtë ciudá Jerusalén con ra mënë shtë guëꞌdchi shtë Judea con ra naquëreldë lugar guëlladchi Jordán; rdchini rall parë guëquë́ diaguë rall shtiꞌdzë Juan. ");
INSERT INTO zacNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Iurë lëꞌë ra mënë rshubë duldë rall duldë shtë rall lu Dios, Juan bëchuꞌbë nisë lëꞌë rall laꞌni guëëꞌgu Jordán. ");
INSERT INTO zacNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Perë iurë guná Juan cantidá mënë religiusë fariseo nu saduceo, bëdchini rall parë chubë nisë rall; guniꞌi Juan lu rall: ―Llëbní mbeꞌldë, ¿chull bëtsëbë lëꞌë të? ¿Pëzielú daniꞌi rlluꞌnë të parë guëcaꞌchilú të lu cashtigu dushë nanapë quë guëdchini? ");
INSERT INTO zacNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Gulë bëꞌnë obrë zaꞌquë parë guëná mënë de quë guc cambi mudë nabani të, de quë bëabrí lduꞌu të con Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nu adë rníꞌidiꞌi të laꞌni lduꞌu të gunë më perdunë lëꞌë të sulë purquë na të llëbní Abraham. Rniaꞌa lu të si talë adë gúnëdiꞌi më recibir lëꞌë të, napë më pudërë parë gunë më llëbní Abraham de guëꞌë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Gunë më cashtigu ra mënë mal ziquë lëꞌë guiubëaguë hia na listë parë guëchuguin hiaguë. Grë́tëꞌ ra hiaguë nadë rnéꞌediꞌi nashi zaꞌquë, chuguin nu tsequin lu guiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Guldía, na rchuꞌbë nisa lëꞌë të con nisë parë guëluaꞌa de quë bëꞌnë nadzëꞌë të mudë nanabani të, perë el quë nazeꞌdë despuësë de na, më ni guëzunë́hiꞌ lduꞌu të nu guëneꞌe më Espíritu Santo parë cuezënúhiꞌ lëꞌë të. Guësheꞌldë më Espíritu Santo ziquë beꞌlë të parë gac të limpi. Më ni napë más pudërë quë na; adë rúnëdiꞌi tucara ni siquierë guahia rachi shtënë më. ");
INSERT INTO zacNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Gunë më separar ra mënë mal entrë mënë zaꞌquë. Hia lëꞌë më napreparadë con palë guiaꞌa më të parë guëzunë́ më trigu të parë guëruꞌu guiꞌlli tubi cuꞌ. Hia trigu tsutsaꞌu laꞌni catë riutsáꞌuhin perë grë́tëꞌ guiꞌlli tsequi lu guiꞌi. Lëꞌë guiꞌi nunquë adë rëáldëdiꞌin. ");
INSERT INTO zacNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Iurní Jesús bëdchini de Galilea hashtë ruaꞌ guëëꞌgu Jordán catë nanú Juan të parë guëchuꞌbë nisë Juan lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Primërë adë në́diꞌi Juan; répiꞌ lu Jesús: ―Runë tucara chubë nisa por lë́ꞌël perë lë́ꞌël zeꞌdë lua. ");
INSERT INTO zacNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Perë Jesús guniꞌi: ―Bëneꞌe sí iurneꞌ purquë zni gac të parë guëdë́ꞌnaꞌa cumplir grë cusë zaꞌquë naquëgnibëꞌa Dios. Iurní lëꞌë Juan gunë́ ");
INSERT INTO zacNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","nu bëchuꞌbë nísiꞌ lëꞌë Jesús. Iurë Jesús gualú bëriubë nísiꞌ, lueguë bërúꞌuiꞌ laꞌni nisë; lueguë lueguë bëllaꞌlë lu gubeꞌe hashtë guná më lugar catë quëbezë Dios nu guná Jesús lu Espíritu Santo shtë Dios; bëdchíniꞌ ziquë tubi palumë. Gulezënúhiꞌ lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Iurní bini më tubi bë, tubi voz nabëruꞌu lu gubeꞌe naguniꞌi: ―Ndëꞌë lëꞌë shinia. Nalë́ rac shtuaꞌa lë́ꞌiꞌ. Nalë́ rquitë lduaꞌa rnahia lúhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Lueguë lëꞌë Espíritu Santo guanú lëꞌë Jesús lu tubi lumë shlatë catë nídiꞌi mënë të guëtëꞌdë mëdzabë prëbë nihunë më cuntrë voluntá shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Guquëreldë më ngaꞌli sin adë gudáudiꞌi më durantë cuarenta dzë nu cuarenta gueꞌlë. Despuësë bëdchini galërldiaꞌnë lduꞌu më. ");
INSERT INTO zacNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bëdchini naná rsiguë́; guabíꞌguëll lu më. Guníꞌill: ―Si talë de verdá nal shini Dios, gunibëꞌa guëꞌë rëꞌ parë guëaquin guetështildi gaul. ");
INSERT INTO zacNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Perë Jesús bëquebi: ―Sagradas Escrituras rniꞌi: “Lëdë niáꞌasëdiꞌi guetështildi guëbani nguiu sino por grë diꞌdzë narniꞌi Dios”. ");
INSERT INTO zacNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Iurní lëꞌë mëdzabë biaꞌa lëꞌë më ciudá Jerusalén. Güeꞌpinull lëꞌë më guëc iáduꞌu tubi partë más guiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Iurní répill: ―Si talë gualdí rníꞌil nal shini Dios, bëruꞌldë lë́ꞌël hashtë lu guiuꞌu purquë Sagradas Escrituras rniꞌi: Dios guënibëꞌa lëꞌë ra ianglë të parë gapë raiꞌ lë́ꞌël nu guëldisë raiꞌ lë́ꞌël con guiaꞌa raiꞌ të parë ni tubi guëꞌë gunënë́diꞌi guëaꞌl. ");
INSERT INTO zacNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús bëquebi: ―Nu zac rniꞌi Sagradas Escrituras: “Adë rtë́ꞌdëdiꞌil prëbë Dios, Shtadë të. Adë rúnëdiꞌil obligar lë́ꞌiꞌ.” ");
INSERT INTO zacNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nu lëꞌë mëdzabë biaꞌa Jesús lu tubi dani ruꞌbë, nu bëluaꞌa mëdzabë grë ra naciuni con lujë shtë rahin ziquë grë cusë zaꞌquë nananú lu guë́ꞌdchiliu; ");
INSERT INTO zacNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","guníꞌill lu Jesús: ―Na guënehia grë́tëꞌ ndëꞌë cáꞌal si talë guëzullíbil lua, gúnël adorar na. ");
INSERT INTO zacNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iurní Jesús repi: ―Guabsú lua, Satanás, purquë Sagradas Escrituras rniꞌi: “Sulë Dios Shtadë të gúnël adorar. Sulë lëꞌë më guëzuꞌbë diáguël shtíꞌdziꞌ.” ");
INSERT INTO zacNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Iurní mëdzabë bësaꞌnë Jesús. Lueguë bëdchini ra ianglë. Bëꞌnë raiꞌ sirvë lu Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iurë Jesús bini de quë Juan nanú lachiguiꞌbë, iurní ziaꞌa më parë regiuni shtë Galilea. ");
INSERT INTO zacNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Perë adë bëáꞌnëdiꞌi më Nazaret sino quë guaglaꞌguë më guquëreldë më Capernaum, tubi guëꞌdchi naquë́ guëlladchi ruaꞌ nisë ruꞌbë por nezë shtë regiuni Zabulón nu Neftalí. ");
INSERT INTO zacNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Zndë guzac parë guc cumplir lo quë nabëquëꞌë muzë shtë më guahietë; lë́hiꞌ Isaías. Naescritë zndëꞌë: ");
INSERT INTO zacNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Guëꞌdchi Zabulón nu Neftalí, nezë naquë́ ruaꞌ nisë ruꞌbë ladë cuꞌ guiaꞌa shtë guëëꞌgu Jordán, partë más zitu shtë Galilea catë quëreldë ra nadë nádiꞌi më israelitë. ");
INSERT INTO zacNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ra mënë narëtaꞌ ndë, guquëreldë rall lu nacahi perë guná rall tubi llni ruꞌbë. Ra mënë naquëreldë regiuni catë nanú shcaaꞌl shtë galguti, ngaꞌli bianí tubi llni ruꞌbë guná rall. ");
INSERT INTO zacNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Dizdë iurní Jesús guzublú bëꞌnë më predicar dizaꞌquë nu guniꞌi më: ―Gulë bëꞌnë nadzëꞌë mudë nabani të purquë hia bëgaꞌa iurë parë guënibëꞌa Dios lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús ziaglaꞌguë më nezë ruaꞌ nisë ruꞌbë shtë Galilea. Guná më chupë nguiu narë́ ngaꞌli, tubi na Simón nu lë zac Pedro. Stubi nguiu lë Andrés, bëchi Pedro. Na raiꞌ pescadurë. Quëgldaguë raiꞌ guëꞌshu laꞌni nisë. ");
INSERT INTO zacNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iurní Jesús repi: ―Gulë gudeꞌe naldë na të guna lëꞌë të pescadurë shtë ra nguiu; gueꞌdënú të mënë lua. ");
INSERT INTO zacNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mizmë iurní bësaꞌnë raiꞌ guëꞌshu nu guanaldë raiꞌ lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ziaꞌa Jesús más delantë; guná më lu chupë bëchi ra më narëtaꞌ, Jacobo nu Juan, shini Zebedeo. Nanú raiꞌ laꞌni barcu. Zúbëgaꞌa raiꞌ con shtadë raiꞌ. Quëhunë raiꞌ rumiendë guëꞌshu. Gunaꞌbë Jesús lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mizmë iurní bësëáꞌnëga raiꞌ barcu con shtadë raiꞌ. Guanaldë raiꞌ lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús ziaglaꞌguë më guëdubi Galilea. Quëgluaꞌa më ra mënë laꞌni iáduꞌu shtë rall cadë guëꞌdchi catë bëdchini më. Quëadiꞌdzë më dizaꞌquë shtë Dios lla tsutë́ mënë lugar catë rnibëꞌa Dios. Nu runë më rumëdi grë́tëꞌ clasë galguidzë nanapë ra mënë. Bënëac më ra narac lluꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bërëꞌtsë diꞌdzë naquëhunë Jesús hashtë guëdubi regiuni shtë Siria. Bëdchininú ra mënë grë́tëꞌ naquëzac zi lu galguidzë nu ra naquëhunë sufrir dulurë nu grë nanapë mëdzabë laꞌni lduꞌu rall nu grë́tëꞌ ra narati zini ra, nu ra narac galguidzë llunguë. Jesús bënëac ra mënë ni. ");
INSERT INTO zacNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nalë́ zihani mënë guanaldë rall lëꞌë më, mënë shtë Galilea nu guëꞌdchi shtë Decápolis nu Jerusalén. Lëꞌë quë lëꞌë zihani mënë shtë regiuni Judea nu ra naquëreldë stubi tëchi guëëꞌgu Jordán, guanaldë rall lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iurë Jesús guná lu ra mënë zihani, güeꞌpi më lu lumë shtë dani. Guzubë më ngaꞌli. Iurní shini gusëꞌdë më bëdëá raiꞌ rdondë raiꞌ catë zúbëgaꞌa më. ");
INSERT INTO zacNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesús guzublú cagluaꞌa më zndëꞌë: ");
INSERT INTO zacNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Dichusë ra mënë narac bëꞌa nanú nicidá gac rall limpi laꞌni lduꞌu rall, pues tsutë́ raiꞌ catë rnibëꞌa Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Dichusë ra mënë naruꞌnë por duldë shtënë rall, pues Dios gunë consolar lëꞌë mënë ni. ");
INSERT INTO zacNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Dichusë ra mënë naduꞌu. Pues grë ra mënë ni gunë rall recibir guë́ꞌdchiliu catë guëdëꞌë Dios caꞌa rall, guëquëreldë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Dichusë na ra mënë narac shtuꞌu parë gac rall limpi delantë lu më; hia rëdchí lduꞌu rall por lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Dichusë ra mënë nargaꞌa lduꞌu saꞌ rall; pues zni rgaꞌa lduꞌu më lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Dichusë ra mënë nalimpi lduꞌi; mënë ni guëná rall lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Dichusë ra mënë nargutë́ en paz parë ra mënë; pues Dios gulë́ më ra mënë ni shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Dichusë ra mënë narzac zi purquë quëhunë rall cumplir shtiꞌdzë Dios; pues tsutë́ rall catë rnibëꞌa më. ");
INSERT INTO zacNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Dichusë na të iurë lëꞌë ra mënë rniꞌi guidzë lëꞌë të nu iurë rzunaldë mënë lëꞌë të nu iurë lëꞌë mënë guëniꞌi bishi cuntrë lëꞌë të purquë na të shmëna. ");
INSERT INTO zacNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mizmë manërë shtadë guëlú të guzunaldë rall muzë shtë Dios naguquëreldë más guahietë quë lëꞌë të. Gulë bëquitë lduꞌu të nu tsu lëgrë lduꞌu të purquë gunë të recibir tubi premi ruꞌbë lu gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Lëꞌë të na të ziquë zedë entrë ra mënë shtë guë́ꞌdchiliu rëꞌ të parë adë rshínidiꞌiruꞌu mënë. Si talë zedë guëdchíguëdiꞌi, ¿lla gunë nguiu të guëabrí sabor shtë zedë? Hia adë rlluíꞌidiꞌin sino parë quë guëzebin nu parë guëlú mënë guëquin. ");
INSERT INTO zacNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Lëꞌë të na të ziquë llni parë mënë narëtaꞌ lu guë́ꞌdchiliu. Tubi ciudá nazúbëgaꞌa guëc tubi dani, adë gáquëdiꞌi guëcaꞌchiluhin. Adë rcaꞌchi ldúꞌudiꞌil lu mënë llni nanápël. ");
INSERT INTO zacNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Adë gáquëdiꞌi subë llni laꞌni tubi tëpë; más bien zubin guiaꞌa të parë guëzianí të guëná mënë nananú laꞌni hiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Zni zac lëꞌë të, gulë bëꞌnë ziquë llni narabtsëꞌë delantë lu ra mënë të parë guëná mënë cusë zaꞌquë nacanihunë të; iurní ra mënë gunë rall alabar Shtadë të, më naquëbezë gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Adë rúnëdiꞌi të llgabë zelda lu guë́ꞌdchiliu parë guëdëꞌa fin lëy shtë Moisés, nilë parë guëdëꞌa fin enseñansë shtë ra muzë nabiadiꞌdzë shtiꞌdzë Dios guahietë. Adë zéldëdiaꞌa parë guëdë́ꞌëhia fin sino parë guëluáꞌahia pë runë cuntienë shtiꞌdzë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Purquë guldía rniaꞌa lu të, mientras nanú gubeꞌe nu guë́ꞌdchiliu, ni tubi partë shtë lëy, ni tubi puntë shtë letrë ni partë mituꞌnë shtë lëy, adë gunë fáltëdiꞌin. Grë́tëꞌ napë quë gac cumplirin. ");
INSERT INTO zacNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Por ni grë́tëꞌ nadë rúnëdiꞌi casë cualquier mandamientë shtë lëy, aunquë más mituꞌnë partë shtë mandamientë, nu rluáꞌall ra mënë lu mizmë zni, pues runë tucarë gáquëll më nalasáquëdiꞌi catë rnibëꞌa Dios. Perë grë́tëꞌ el quë narzuꞌbë diaguë nu quëgluáꞌall gunë mënë cumplir grë puntë shtë lëy, ni runë tucarë gáquëll más më lasac lugar catë rnibëꞌa Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Na rniaꞌa lu të, si talë adë nádiꞌi conductë shtënë të más nazaꞌquë quë conductë shtë ra mënë religiusë fariseo nu ra mësë shtë lëy, jamás adë tsutë́diꞌi të catë rnibëꞌa Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Lëꞌë të bini të ra shtadë guëlú hiaꞌa guniꞌi raiꞌ: “Adë quínidiꞌil mënë; cualquier narguini sáhiꞌ pues napë quë gac juzgar mënë ni”. ");
INSERT INTO zacNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Perë na rniaꞌa lu të, grë́tëꞌ el quë naná rldë lu sáhiꞌ, nápëll culpë lu nagunë juzguë. El quë narushtiá lu sáhiꞌ, napë quë gac juzgar mënë ni lu Junta Suprema. El quë narniꞌi lu sáhiꞌ: shënë, nanú peligrë tsall lu guiꞌi shtë gabildi. ");
INSERT INTO zacNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Zni si talë lë́ꞌël rac shtúꞌul guëdë́ꞌël ofrendë lu bëcuꞌguë nu ngaꞌli rëagná ldúꞌul de quë bëldënul saꞌl, ");
INSERT INTO zacNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bësëaꞌnë ofrendë shtë́nël cuꞌ bëcuꞌguë; iurní guagná bë́chil të parë tsu en paz con lë́ꞌëll; iurní sí, zac guëabril lu bëcuꞌguë të parë guëdë́ꞌël ofrendë lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Si talë chu guëdchiꞌbë demandë cuntrë lë́ꞌël, iurë zianul mënë ni nezë, gulë gac të de acuerdë lueguë të parë adë gúnëdiꞌi mënë intriegu lë́ꞌël lu juësi, purquë iurní juësi gúnëll intriegu lë́ꞌël lu ra soliar të parë guëldaguë rall lë́ꞌël lachiguiꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Guldía rniaꞌa, ngaꞌli guërúꞌudiꞌil hashtë quíllil lúltimë centavë nanazéꞌbil. ");
INSERT INTO zacNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Lëꞌë të bini të lo quë naguniꞌi mënë antsë: “Adë rquënúdiꞌil tseꞌlë mënë”. ");
INSERT INTO zacNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Perë na rniaꞌa lu të, cualquier lo quë naná rzebi lduꞌu ra naꞌa más quë tséꞌlëll, hia bëꞌnë mënë ni duldë adulteri laꞌni ldúꞌull. ");
INSERT INTO zacNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Si talë slul ladë ldi napë culpë quëhúnël duldë, gulú slul të parë guërúꞌldëlin zitu. Más mejurë guëniti tubi slul no sea quë tsal guëdubi cuerpë shtë́nël laꞌni gabildi. ");
INSERT INTO zacNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Si tubi guiáꞌal ladë ldi napë culpë quëhúnël duldë, bëchuguë guiáꞌal, bëruꞌldin zitu; mejurë guënítil tubi partë shtë cuerpë, lëdë guëdúbidiꞌi cuerpë shtë́nël tsal laꞌni gabildi. ");
INSERT INTO zacNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Nu zac guniꞌi ra mënë guahietë: “Grë́tëꞌ el quë narlë́ tseꞌlë, napë quë guëdëꞌë nguiu tubi cartë shtë divurci caꞌa tséꞌliꞌ”. ");
INSERT INTO zacNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Perë na rniaꞌa lu të, si talë gunë nguiu divorciar tséꞌliꞌ por tubi cusë de nadë, quësínill lëꞌë tséꞌlëll lu duldë adulteri. Grë ra nacaꞌa naꞌa divorciadë pues hia bë́ꞌnëll duldë adulteri. Por tubsë motivë tsu divurci, si talë bëdzelënull stubi nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Nu zac bini të de quë guniꞌi ra shtadë guëlú hiaꞌa: “Jamás adë guësáꞌnëdiꞌi të gunë të cumplir lo quë narunë jurar delantë lu Dadë Dios”. ");
INSERT INTO zacNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Perë na rniaꞌa lu të, adë rúnëdiꞌi të jurar por ni tubi rsunë; adë rúnëdiꞌi të jurar por lo quë nananú gubeꞌe purquë gubeꞌe na trunë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Adë rúnëdiꞌi të jurar por guë́ꞌdchiliu purquë nahin catë zu guëaꞌ më; ni adë rúnëdiꞌi të jurar por Jerusalén purquë ni na tubi ciudá ruꞌbë shtë rëy narnibëꞌa más. ");
INSERT INTO zacNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Adë rúnëdiꞌi të jurar por lo quë nananú guë́quël purquë adë gáquëdiꞌi gúnël gan gac tubi guitsë guë́quël naquichi u nagasë, ni tubi guítsëꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nadë más gulë guniꞌi: “Ahaꞌ” u “Aquëdiꞌi” purquë lo quë nardchiꞌbë guëc diꞌdzë ni zeꞌdë de mëdzabë Satanás. ");
INSERT INTO zacNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Lëꞌë të bini të de quë guniꞌi mënë guahietë: “Gulú slu saꞌl, el quë nagulú slul, nu gulú laiꞌ saꞌl, el quë nagulú laiꞌl”. ");
INSERT INTO zacNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Perë na rniaꞌa, adë rzutípëdiꞌil lu ra hiumbrë mal; al contrari si talë chu cubë́ tubi ladë lul, bëdëꞌë stubi ladë. ");
INSERT INTO zacNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Si talë chu quëgdchiꞌbë demandë u rac shtúꞌull guëdchisull manguë shtë́nël, bëdëꞌë manguë shtë́nël con shabë guítsël të guaꞌa mënë ni. ");
INSERT INTO zacNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Si talë chu gunë obligar lë́ꞌël guáꞌal tubi bultë tubi kilómetro, biaꞌain chupë kilómetro. ");
INSERT INTO zacNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Cualquier tubi naquëgnaꞌbë tubi prështë, bëdëꞌëin nu adë rdchigrë́diꞌil nezë të́chil sino bëdëꞌë lo quë narac shtuꞌu mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Nu zac bini të lo quë naguniꞌi mënë antsë: “Gac shtúꞌul amigu shtë́nël perë guëná túshël lu ra enemigu shtë́nël”. ");
INSERT INTO zacNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Perë na rniaꞌa, gulë gac shtuꞌu ra enemigu shtënë të. Gulë gunaꞌbë lu Dios parë grë ra narzunaldë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Si talë quëhunë të cumplir grë ra cusë rëꞌ, gac të shini Dios nacabezë gubeꞌe. Lëꞌë më rsheꞌldë më llni ngubidzë parë grë́tëꞌ mënë, parë mënë mal nu mënë zaꞌquë. Lëꞌë më ldaguë më guiu parë ra mënë naná tubldí shcuéndiꞌ nu parë ra mënë nanádiꞌi tubldí shcuéndiꞌ lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Si talë lëꞌë të nadë más rac shtuꞌu të ra narac shtuꞌu lë́ꞌël ¿pëllë premi gápël? purquë grë ra narunë cubrë impuestë rac shtuꞌu rall saꞌ rall. ");
INSERT INTO zacNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Si talë nadë más runë të saludar con cariñi ra mënë bëchi saꞌ të ¿pë bien canihúnël? Pues ra naná guënë́diꞌi Dios runë rall saludar saꞌ rall. ");
INSERT INTO zacNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Gulë bëꞌnë cumplir con grë mënë; gulë gac të ziquë Shtadë të naquëbezë gubeꞌe; ni tubi faltë nápëdiꞌi më. ");
INSERT INTO zacNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Adë rluáꞌadiꞌi të obrë zaꞌquë delantë lu ra mënë nadë más parë guëná mënë lu të purquë si talë runë të zni, Shtadë të naquëbezë gubeꞌe adë guënéꞌediꞌi më premi caꞌa të. ");
INSERT INTO zacNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Por ni lëꞌë të iurë rdëꞌë të guꞌnë caꞌa nabënápëdiꞌi, adë rúꞌldëdiꞌil damburë parë guëná mënë; adë gúnëdiꞌil ziquë mënë falsë, ziquë runë ra mënë naná ziquë guetë nadchiꞌbë lu dchiꞌli. Laꞌni ra iáduꞌu shtënë rall nu nezë rdëꞌë rall guꞌnë të parë rna ra mënë, parë guëniꞌi zaꞌquë ra mënë de lëꞌë rall. Perë guldía rniaꞌa lu të, hia napë rall labansë shtë mënë naná lúniquë premi nagunë rall recibir. ");
INSERT INTO zacNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Perë iurë lëꞌë të guëdëꞌë të guꞌnë caꞌa nabënápëdiꞌi, gulë bëꞌnin manërë nagaꞌchi. Hia lëꞌë Shtádël naquëbezë gubeꞌe, rna më grë lo quë naquëhúnël nagaꞌchi. Lëꞌë më guëneꞌe më tubi premi cáꞌal. ");
INSERT INTO zacNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Iurë lëꞌë të gunë të orar, adë rúnëdiꞌi të ziquë runë ra mënë naná falsë. Rquitë lduꞌu rall gunë rall orar të guëná mënë lu rall; rzuldí rall laꞌni iáduꞌu nu rzu rall shquini shtë nezë të parë guëná ra mënë lo quë naquëhunë rall. Guldía rniaꞌa lu të, hia napë rall lúniquë premi nagunë rall recibir. ");
INSERT INTO zacNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Perë iurë lëꞌë të gunë të orar, gulë guëuꞌ laꞌni hiuꞌu cuartë shtë të. Bësëꞌau ruaꞌ hiuꞌu; iurní bëꞌnë orar; guniꞌi lu Dadë Dios naquëbezë gubeꞌe, sulë lëꞌë më con lë́ꞌël. Rac bëꞌa më lo quë nanú laꞌni ldúꞌul; iurní Shtádël naquëbezë gubeꞌe guëneꞌe më lo quë naquëgnáꞌbël. ");
INSERT INTO zacNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Iurë gúnël orar, adë rúnëdiꞌi të oraciuni zihani vueltë ziquë runë ra mënë nanádiꞌi më israelitë. Runë rall llgabë guini Dios diꞌdzë shtë rall por ruadiꞌdzë rall zihani diꞌdzë. ");
INSERT INTO zacNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Adë rúnëdiꞌi të zni ziquë lëꞌë rall purquë lëꞌë Dadë hia rac bëꞌa më grë lo quë narquiꞌni të antsë guënaꞌbë të lúhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Por ni rniaꞌa lu të, gulë bëꞌnë orar lu më zndëꞌë: Dios, nal Shtadë naꞌa naquëbezë gubeꞌe. Rac shtuꞌu naꞌa gunë grë mënë alabar lë́ꞌël de verdá. ");
INSERT INTO zacNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Rac shtuꞌu naꞌa guënibë́ꞌal grë mënë, sullibi rall lul. Ziquë quëhunë ra ianglë cumplir voluntá shtë́nël lu gubeꞌe, rac shtuꞌu naꞌa grë mënë narëtaꞌ lu guë́ꞌdchiliu, gunë rall cumplir lo quë narac shtúꞌul. ");
INSERT INTO zacNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bëneꞌe nagáu naꞌa dzë con dzë. ");
INSERT INTO zacNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bëꞌnë perdunë duldë shtë naꞌa; zni lëꞌë naꞌa rdëꞌnë naꞌa perdunë duldë narunë ra mënë cuntrë lëꞌë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Adë rdë́ꞌëdiꞌil permisi guëtëꞌdë mëdzabë prëbë lëꞌë naꞌa të ldáguëdiꞌi naꞌa lu duldë. Purquë lë́ꞌël rnibë́ꞌal gubeꞌe nu lë́ꞌël nápël grë derechë nu llëruꞌbë na pudërë shtë́nël. Nápëdiꞌil fin. Amén. ");
INSERT INTO zacNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Si talë lëꞌë të gunë të perdunë ra mal nabëꞌnë mënë cuntrë lëꞌë të, zni zac Dadë naquëbezë gubeꞌe gunë më perdunë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Perë si talë adë në́diꞌi të gunë të perdunë saꞌ të duldë narúnëll cuntrë lëꞌë të, tampuquë Dadë naquëbezë gubeꞌe gúnëdiꞌi më perdunë duldë shtë të. ");
INSERT INTO zacNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Iurë lëꞌë të gunë të ayunë, adë rëáꞌnëdiꞌi të tristë cumë ziquë runë ra mënë naná falsë purquë lëꞌë rall rzu rall tristë; runë rall seri no más parë guëná ra mënë de quë quëhunë rall ayunë. Guldía rniaꞌa lu të, hia napë rall grë lo quë nagunë rall recibir ziquë premi. ");
INSERT INTO zacNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Perë lëꞌë të iurë gunë të ayunë, gulë tsu nalëgrë; gulë bëzunë́ lëꞌë të bien bien ");
INSERT INTO zacNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","të parë iurë guëná mënë lul, adë guëdë́ꞌëdiꞌi mënë cuendë de quë lë́ꞌël quëhúnël ayunë. Nadë más sulë lëꞌë Dadë Dios naquëbezë gubeꞌe, më ni rna lo quë naquëhúnël. Lëꞌë më napë më cuendë nu gunë më honrar lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Adë rúnëdiꞌi të muntuni zihani cusë lu guë́ꞌdchiliu catë lëꞌë ra mbichuguë rzalú ma grë́tëꞌ ra cusë, catë rnaꞌzi tën guiꞌbë nu rllinin; nu riutë́ ngubaꞌnë parë rbaaꞌnëll ra cusë. ");
INSERT INTO zacNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Más bien gulë bëꞌnë muntuni tesurë lu gubeꞌe catë adë nídiꞌi ra mbichuguë nu adë guëzalúdiꞌi mahin, catë adë rnáꞌzidiꞌi tën guiꞌbë. Ra ngubaꞌnë adë riutë́diꞌi rall ngaꞌli parë cuanë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Catë nacuetsaꞌu tesurë shtë́nël, ndë rac shtúꞌul guëbánil. ");
INSERT INTO zacNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Si talë rdë́ꞌël sí parë guënibëꞌa Dios lë́ꞌël, na ziquë slul naná bien nu guëdubi cuerpë shtë́nël quëbezënú llni ");
INSERT INTO zacNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","perë si talë adë në́diꞌil tsasël shtiꞌdzë Dios, blac llëruꞌbë na nacahi laꞌni ldúꞌul. Nahin ziquë slul naná mal; guëdubi cuerpë quëbezin nacahi. ");
INSERT INTO zacNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Adë gáquëdiꞌi gunë mënë sirvë lu chupë lamë, purquë tubi lamë adë rac shtúꞌudiꞌi mënë lë́ꞌëll; stubi lamë rac shtúꞌull. Quëhúnëll rëspëti tubi lamë perë hia stubi lamë quëhúnëll desprëci. Tubsë lamë nápël. Si talë Dios na lamë shtë́nël, iurní gúnël lo quë narac shtuꞌu më; perë si talë dumí na lamë shtë́nël, iurní Dios adë nádiꞌiꞌ shlámël. ");
INSERT INTO zacNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Rniaꞌa lu të iurneꞌ, adë rquëdíꞌnidiꞌi lduꞌu të por lo quë nagáu të u por lo quë nagú të parë guëbani të, ni por shabë të parë nagacu të. Más lasac vidë quë dau; lëꞌë shcuerpë të más lasac quë shabë të. ");
INSERT INTO zacNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gulë guná lu ra maꞌñi naná riasë, adë rcabnídiꞌi ma, nilë adë rcáꞌadiꞌi ma cusechë parë cuetsáꞌuhin, perë sin adë guëtë́ꞌdëdiꞌi, Dadë shtë të naquëbezë gubeꞌe quëgneꞌe më grë́tëꞌ nagáu të. Más lasac të quë ra maꞌñi. ");
INSERT INTO zacNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Chu de lëꞌë të por tantë rquëdiꞌni ldúꞌul, guëbánil tubi dzë más? ");
INSERT INTO zacNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Pëzielú rquëdiꞌni lduꞌu të por shabë të? Gulë guná, lla riaruꞌbë guëꞌë lachi. ");
INSERT INTO zacNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Adë rúnëdiꞌi guëꞌë dchiꞌni perë rniaꞌa lu të, rëy Salomón con guëdubi galëlujë shtë́niꞌ, adë guzú záꞌquëdiꞌiꞌ cumë ziquë ra guëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Chulë rluaꞌa guëꞌë lachi nedzë́, quëhunë Dios; perë glli guëbidchi guëꞌë nu tsequin lu guiꞌi. ¿Pë adë gápëdiꞌi më lëꞌë të? lëꞌë të naná rialdí lduꞌi duꞌpë. ");
INSERT INTO zacNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Por ni rniaꞌa lu të, adë rquëdíꞌnidiꞌi lduꞌu të nu adë rníꞌidiꞌi të: “¿Pë cha guëdáuhaꞌa?” u “¿Pë cha guëdí hiaꞌa?” u “¿Ca guëruꞌu shábaꞌa?” ");
INSERT INTO zacNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pues grë mënë nanadë guënë́diꞌi Dios, zianaldë rall tëchi ra cusë ni. Perë lëꞌë të napë të tubi Shtadë të naquëbezë gubeꞌe; rac bëꞌa më grë lo quë narquíꞌnil. ");
INSERT INTO zacNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Primërë gulë guanaldë tëchi nezë catë rnibëꞌa Dios ziquë rëy. Gulë bëꞌnë cumplir lo quë narac shtuꞌu më, iurní gunë të recibir grë cusë narquiꞌni të parë guëbani të. ");
INSERT INTO zacNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","¿Pëzielú rquëdiꞌni ldúꞌul nedzë́ por ra cusë nazeꞌdë glli? Nanú sufsientë problemë parë nedzë́. ");
INSERT INTO zacNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Adë rúnëdiꞌi të juzguë saꞌ të, purquë gunë më juzguë lëꞌë të mizmë manërë ziquë quëhunë të juzguë saꞌ të. ");
INSERT INTO zacNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gunë më juzguë lëꞌë të mizmë manërë narunë të. Mizmë varë naguishi të con saꞌ të, mizmë varë ni quishi Dadë Dios con lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Pëzielú rnal lu guiꞌlli nananú laꞌni slu saꞌl perë adë rnádiꞌil laꞌni slul nanú tubi trunquë ruꞌbë? ");
INSERT INTO zacNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Lla gúnël guëníꞌil lu saꞌl? “Bëneꞌe sí guëgúa guiꞌlli nananú slul” perë nanú tubi trunquë laꞌni slul. ");
INSERT INTO zacNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Na të falsë; gulú trunquë nananú laꞌni slul; iurní sí, guënal bien parë cul guiꞌlli nananú laꞌni slu saꞌl. ");
INSERT INTO zacNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nanú mënë ziquë mbecu dushë narahuëëꞌ. Adë rúnëdiꞌi rall rëspëti cusë santu shtë Dios. Na rall ziquë guchi narlú guëc tubi perla nu rëabrí ma të reꞌdë caꞌnë ma lul. Adë ruadíꞌdzëdiꞌi të diꞌdzë santu lu nanë́diꞌi tsasë́ verdá shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Gulë gunaꞌbë lu Dios grë́tëꞌ lo quë narac shtuꞌu të. Lëꞌë më guëneꞌe mëhin. Gulë quilin të parë guëdzelë tëhin. Gulë bësëdchi ruaꞌ puertë të parë guëllaꞌlin. ");
INSERT INTO zacNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Grë mënë natsaglaꞌguë guënaꞌbë lu Dios, gúnëll recibirin; grë mënë narguili cusë shtë Dios, guëdzelin. El quë naná ziquë tubi nguiu narnaꞌbë fuertë ruaꞌ nezë, guëllaꞌlë puertë parë lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Chu tubi de lëꞌë të si talë guënaꞌbë shínil guetështildi gáuhiꞌ; ni mudë guëdë́ꞌël tubi guëꞌë gáuhiꞌ? ");
INSERT INTO zacNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Ni mudë guëdë́ꞌël tubi mbeꞌldë iurë shínil rnáꞌbëll mbeldë gáuhiꞌ? ");
INSERT INTO zacNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Si talë lëꞌë të na të mal, nu rac bëꞌa të guëdëꞌë të cusë zaꞌquë lo quë narnaꞌbë shini të, más segurë Shtadë të naquëbezë gubeꞌe, guëneꞌe më cusë zaꞌquë lo quë narnaꞌbë të lu më. ");
INSERT INTO zacNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Manërë lo quë narac shtúꞌul gunë mënë tratë lë́ꞌël, mizmë manërë ni gulë bëꞌnë tratë saꞌl. Zni si talë quëhúnël cumplir rëglë ni, canihúnël cumplir lëy nu lo quë nabëquëꞌë muzë shtë Dios guahietë. ");
INSERT INTO zacNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Gulë tsutë́ nezë ruaꞌ puertë nu nezë ca nadeꞌe purquë ruaꞌ puertë nu nezë narniti mënë, nalë́ shlaguin nu napin zihani lugar. Cantidá mënë riutë́ rall ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Perë puertë nu ruaꞌ nezë nadeꞌe catë napë mënë vidë sin fin, tubldí nahin nu trabaju riutë́ mënë ngaꞌli. Duꞌpsë mënë riutë́ lu nezë ni. ");
INSERT INTO zacNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Gulë gupë cuidadë con ra mësë falsë naná rniꞌi ruadiꞌdzë rall shtiꞌdzë Dios. Zeꞌdë rall; por fuërë rluaꞌa rall ziquë lliꞌli perë dentrë laꞌni lduꞌu rall na rall ziquë ma dushë. ");
INSERT INTO zacNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Lëꞌë të gac bëꞌa të u gunguë bëꞌa të chu na rall por lo quë narunë rall. Pues adë rldáguëdiꞌi të uvë lu ra hiaguë guitsë. Tampuquë nídiꞌi mudë guëldaguë të bëldaꞌu lu hiaguë guitsëbé. ");
INSERT INTO zacNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Zni nahin, grë́tëꞌ hiaguë zaꞌquë rneꞌe nashi zaꞌquë perë hiaguë mal rneꞌe nashi mal. ");
INSERT INTO zacNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Lëꞌë hiaguë zaꞌquë adë gáquëdiꞌi gudëꞌëin nashi mal. Ni tampuquë tubi hiaguë mal gáquëdiꞌi guëdëꞌëin nashi zaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Grë́tëꞌ hiaguë nadë rdë́ꞌëdiꞌi nashi zaꞌquë, chuguin nu tsequin lu guiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Zni gac bëꞌa të mënë zaꞌquë nu mënë mal por lo quë narunë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Lëdë grë́diꞌi narniꞌi lua: “Dadë, Dadë”, tsutë́ rall catë rnibëꞌa Dios sino nadë más el quë narunë cumplir voluntá shtë Dadë naquëbezë gubeꞌe, ni sí quëgnibëꞌa më lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Iurë lëꞌë iurë guëgaꞌa, dzë ni cantidá mënë guëniꞌi rall lua: “Dadë, lëꞌë naꞌa biadiꞌdzë naꞌa shtíꞌdzël nu por lël gulú naꞌa mëdzabë nananú laꞌni lduꞌu mënë. Bëdëꞌnë naꞌa zihani milagrë iurë guniꞌi naꞌa lël.” ");
INSERT INTO zacNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Perë iurní guëniaꞌa lu mënë ni: “Jamás adë guënë́diaꞌa lëꞌë të. Gulë guabsú lua purquë na të mënë mal.” ");
INSERT INTO zacNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Zni na el quë narquë́ diaguë nu quëhúnëll lo quë narniaꞌa, nall cumë ziquë tubi nguiu nariasë́ nu bëzáꞌall lídchill lu cimientë shtë guëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bëdchini guiu; guaruꞌbë nisë guëëꞌgu; bëruꞌu mbë dushë; bëdíꞌahin hashtë guëaꞌ hiuꞌu perë adë guláguëdiꞌi hiuꞌu purquë napin cimientë nazubë lu guëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Perë el quë narini shtiꞌdza perë adë rúnëdiꞌill cuendë lo quë narniaꞌa, nall ziquë tubi nguiu tuntë nanë́diꞌi tsasëll. Bëzáꞌall lídchill lu iuꞌlli. ");
INSERT INTO zacNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bëdchini guiu; guaruꞌbë nisë guëëꞌgu; bëruꞌu mbë dushë nu bëdíꞌahin guëaꞌ hiuꞌu. Gulaguë hiuꞌu purquë nídiꞌi cimientë guetë. Nalë́ tubi cusë dushë guc ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iurë Jesús gualú biadiꞌdzë më lu ra mënë, nalë́ bëdzëguëëꞌ lduꞌu rall nu guasë́ lduꞌu rall por ldaiꞌ shtë më. ");
INSERT INTO zacNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Cagluaꞌa më cumë ziquë el quë nanapë pudërë, lë́dëdiꞌi ziquë ra mësë shtë lëy nananú entrë lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iurë bietë Jesús lu dani, cantidá mënë zianaldë rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Iurní guabiꞌguë tubi nguiu narac lluꞌu galguidzë naruꞌdzë ládiꞌ. Bëzullíbill lu më. Répill: ―Dadë, si talë rac shtúꞌul, nápël pudërë gunëáquël na; guëzunël ladia. ");
INSERT INTO zacNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iurní Jesús bëdchiꞌbë më guiaꞌa më guë́quëll nu guniꞌi më: ―Rac shtuaꞌa, sunë́ ládil. Iurë lëꞌë më guniꞌi zndëꞌë, grë galguidzë ruꞌdzë bëac. ");
INSERT INTO zacNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús repi: ―Bëquë́ diaguë, adë chu lu ruadíꞌdzëdiꞌil; nadë más guaguëꞌnë presentar lu bëshuzi nu bëdëꞌë tubi ofrendë lo quë narnibëꞌa Moisés të parë grë́tëꞌ mënë, guëdëꞌë rall cuendë de quë lë́ꞌël bëáquël nu guc límpil de galguidzë shtë́nël. ");
INSERT INTO zacNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iurë guatë́ Jesús guëꞌdchi Capernaun, tubi capitán rumanë guabíꞌguëll lu më nu bë́ꞌnëll ruëguë. ");
INSERT INTO zacNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Répill lu Jesús: ―Dadë, shmuza rac llúꞌull galguidzë llunguë. Nagáꞌall lidcha. Nalë́ quëhúnëll sufrir lu galguidzë. ");
INSERT INTO zacNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús guniꞌi: ―Na tsahia parë gunëaca lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Capitán bëquebi: ―Dadë, rúnëdiꞌi tucara tsal lidcha; adë chu nádiaꞌa. Nadë más gunibëꞌa nu bëdëꞌë tubsë diꞌdzë, iurní guëac shmuza. ");
INSERT INTO zacNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mizmë na runa lo quë narniꞌi ra narnibëꞌa na, nu napa suldadë bajo ordë shtëna. Iurë rniaꞌa lu tubi suldadë, tsall; pues riall. Iurë rniaꞌa guídëll, pues lueguë rídëll. Iurë rnibë́ꞌahia tubi shmuza tsaguë́ꞌnëll lo quë narac shtuaꞌa, rzuꞌbë diáguëll shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iurë Jesús bini diꞌdzë ni, nalë́ guasë́ lduꞌu më. Guniꞌi më lu ra nazianaldë lëꞌë më: ―Guldía rniaꞌa lu të, guëdubi naciuni Israel nunquë bëdzaꞌguëlúdiaꞌa tubi nguiu narialdí lduꞌi shtiꞌdza ziquë nguiu rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Rniaꞌa, cantidá mënë guëruꞌu rall de grë ladë shtë guë́ꞌdchiliu. Guidë rall të parë subënú rall Abraham nu Isaac nu Jacob parë gaunú rall mënë ni catë rnibëꞌa Dios gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Perë nanú mënë nabini shtiꞌdzë më de quë guënibëꞌa më ziquë rëy; guëruꞌu rall tëchi fuërë catë nacahi. Ngaꞌli guꞌnë rall nu guëchushí laiꞌ rall. ");
INSERT INTO zacNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Iurní Jesús guníꞌiꞌ lu capitán: ―Bëagzë́ lídchil; hia shmúzël bëac tal ziquë gualdí ldúꞌul. Lëꞌë muzë ni bëáquiꞌ mizmë iurë ni. ");
INSERT INTO zacNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús gua lidchi Pedro. Ngaꞌli guná më nagaꞌa suëgrë Pedro. Naꞌa ni rac shldi ruꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iurní gunaꞌzi më guiaꞌa naꞌa. Lueguë bëruꞌu shldi. Iurní suëgrë Pedro guashtë́hiꞌ nu bë́ꞌniꞌ sirvë lu raiꞌ. Bëdë́ꞌëiꞌ nagáu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Iurë gueꞌlë guꞌ, beꞌdënú mënë zihani saꞌ rall lu Jesús. Beꞌdënú rall ra nanapë mëdzabë laꞌni lduꞌu rall; con tubsë diꞌdzë rgu më grë́tëꞌ ra mëdzabë. Nu zac bëꞌnë më rumëdi grë́tëꞌ ra nanapë galguidzë. ");
INSERT INTO zacNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Zndë guzac parë gac cumplir lo quë nabëquëꞌë muzë shtë Dios guahietë. Guniꞌi Isaías: “Lëꞌë më biaꞌa më galguidzë shtë́naꞌa nu lëꞌë më biaꞌa më grë́tëꞌ debilidá shtë́naꞌa”. ");
INSERT INTO zacNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iurë guná Jesús cantidá mënë bëdëá rdondë catë zubë më, gunibëꞌa më parë tëdë ra shini gusëꞌdë më stubi tëchi nisë. ");
INSERT INTO zacNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tubi mësë shtë lëy guabíꞌguëll lu Jesús nu répill: ―Mësë, rac shtuaꞌa sënalda lë́ꞌël cualquier lugar ca tsal. ");
INSERT INTO zacNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús bëquebi: ―Ra ma lachi napë cuevë shtë ma. Ra maꞌñi napë bëcheꞌzë llicu hiaguë perë na, adë nápëdiaꞌa catë guëcuꞌguë guëca aunquë nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Stubi nguiu naguanaldë lëꞌë Jesús repi lu më: ―Dadë, bëneꞌe sí, primërë tsacaꞌcha shtada, iurní gueꞌdë nalda lë́ꞌël. Gaca shmë́nël iurní. ");
INSERT INTO zacNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús guniꞌi: ―Gudeꞌe naldë na lueguë. Nanú mënë nadë rialdídiꞌi lduꞌu shtiꞌdza parë guëcaꞌchi rall ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iurní guatë́ Jesús laꞌni barcu con ra shini gusëꞌdë më ");
INSERT INTO zacNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","perë bëdchini mbë lu nisë. Nalë́ fuertë bëdchini mbë. Gutë́ zili nisë laꞌni barcu. Jesús nagaꞌsi më. ");
INSERT INTO zacNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Iurní ra shini gusëꞌdë më guacuaꞌñi raiꞌ lëꞌë më nu repi raiꞌ: ―Dadë, bëlá lëꞌë naꞌa. Aquë zátiaꞌa iurneꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Lëꞌë më guníꞌiꞌ lu raiꞌ: ―¿Pëzielú nalë́ rdzëbë të? ¿Pë hia adë rialdídiꞌi lduꞌu të na? Iurní guashtë́ më nu guniꞌi më guëc mbë nu guëc nisë ruꞌbë. Lueguë gurëdchí nisë. ");
INSERT INTO zacNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Hia ra nguiu naná zënú më, nalë́ bëdzëguëëꞌ lduꞌu raiꞌ. Guasë́ lduꞌu raiꞌ. Guniꞌi raiꞌ: ―¿Chull më rëꞌ? Rzuꞌbë diaguë mbë nu nisë shtíꞌdziꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iurë Jesús bëdchini stubi ladë ruaꞌ nisë, ladzë ra më gadareno, chupë nguiu bëruꞌu laꞌni catë bëgaꞌchi tëgulë. Guabiꞌguë rall lu më. Guërupë rall napë rall mëdzabë laꞌni lduꞌu rall. Nalë́ nadushë rall. Ni tubi adë chu ráquëdiꞌi rdëdë nezë catë nanú rall. ");
INSERT INTO zacNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Iurní guzublú gurushtiá rall fuertë: ―¿Pëzielú riutël con lëꞌë naꞌa, Jesús shini Dios? ¿Gu bëdchínil ndëꞌë parë guëzac zil lëꞌë naꞌa antsë guëgaꞌa tiempë? ");
INSERT INTO zacNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Zitu rëtaꞌ cantidá ra guchi. Quëháu ra ma guiꞌlli. ");
INSERT INTO zacNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ra mëdzabë bëꞌnë rall ruëguë lu Jesús; guniꞌi rall: ―Si talë guëgul lëꞌë naꞌa laꞌni ra nguiu rëꞌ, perë bëneꞌe permisi të guëdëuꞌ naꞌa laꞌni ra guchi. ");
INSERT INTO zacNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Iurní Jesús repi: ―Gulë gua. Lueguë bëruꞌu mëdzabë laꞌni ra nguiu ni. Guatë́ rall laꞌni guchi. Lueguë grë́tëꞌ ra guchi ziaꞌa guëlluꞌnë nasesë; gulaguë ra ma catë rlaguë guiuꞌu ruaꞌ nisë ruꞌbë. Guatë́ ma laꞌni nisë. Bëldaꞌu nisë ra ma; lueguë guti ra ma. ");
INSERT INTO zacNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hia naquëhapë guchi bëlluꞌnë rall hashtë guëꞌdchi nu guzublú biadiꞌdzë rall lo quë naguc, nu shcuendë ra nguiu nagú mëdzabë laꞌni lduꞌu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Iurní grë mënë shtë guëꞌdchi bëruꞌu rall; guagná rall catë quëbezë Jesús. Iurë guná rall lu më, bëꞌnë rall ruëguë de quë guëruꞌu më ladzë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iurní Jesús guatë́ laꞌni barcu parë tëdë më stubi tëchi nisë. Iurní bëdchini më guëꞌdchi shtë më. ");
INSERT INTO zacNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ngaꞌli bëdchininú mënë tubi narac lluꞌu galguidzë llunguë. Nagáꞌall lu daaꞌ. Iurë Jesús guná rialdí lduꞌu rall, repi më lu narac lluꞌu: ―Lë́ꞌël, adë riádiꞌi ldúꞌul. Naperdunë duldë shtë́nël. ");
INSERT INTO zacNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Iurní bëldá mësë narluaꞌa lëy guniꞌi rall laꞌni lduꞌu rall: “Hiumbrë rëꞌ blac diꞌdzë dzabë ruadíꞌdzëll cuntrë Dios”. ");
INSERT INTO zacNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Perë guc bëꞌa Jesús pë llgabë quëbezënú rall. Iurní repi më: ―¿Pëzielú runë të llgabë mal? ");
INSERT INTO zacNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Pë más sencigi guëniaꞌa lu narac lluꞌu: “Naperdunë duldë shtë́nël”, u guëniaꞌa lull: “Guashtë́ nu bëagzë́”? ");
INSERT INTO zacNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Parë gac bëꞌa të nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, nu parë gac bëꞌa të napa pudërë parë guna perdunë duldë shtë mënë. Iurní repi më lu narac lluꞌu: ―Guashtë́; bëtëá shtaaꞌl nu bëagzë́ lídchil. ");
INSERT INTO zacNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Lëꞌë narac galguidzë llunguë guasuldill nu bëagzëll lídchill. ");
INSERT INTO zacNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Guná mënë lull, iurní bëdzëguëëꞌ lduꞌu rall. Guniꞌi rall llëruꞌbë na pudërë shtë Dios. Bëꞌnë rall alabar lëꞌë Dios purquë bëdëꞌë më pudërë ruꞌbë guiaꞌa tubi nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús bëruꞌu më ngaꞌli. Guná më lu tubi nguiu lë Mateo. Zúbëgaꞌall lugar catë rúnëll cubrë impuestë. Iurní repi më: ―Gudeꞌe naldë na. Iurní Mateo guasuldí nu guanáldëll lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Guzac iurë Jesús caniháu laꞌni tubi hiuꞌu, cantidá mënë narunë cubrë impuestë nu zihani pecadurë bëdchini rall ngaꞌli parë gulezënú rall lëꞌë më lu mellë. Guzubënú rall lu mellë con Jesús nu con ra shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Perë ra fariseo iurë guná rall lu ra mënë ni, gunaꞌbë diꞌdzë rall lu shini gusëꞌdë Jesús: ―¿Pëzielú mësë shtë të quëhaunull ra pecadurë nu con ra mënë narunë cubrë impuestë? ");
INSERT INTO zacNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Bini Jesús pë quëgniꞌi ra fariseo; iurní guniꞌi më: ―Adë rquíꞌnidiꞌi ra mënë ducturë si rac llúꞌudiꞌi rall perë mënë narac lluꞌu, sí, ni rquiꞌni rall ducturë. ");
INSERT INTO zacNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gulë gua; gulë bëdëꞌë cuendë lo quë narunë cuntienë lo quë naná escritë: “Na rac shtuaꞌa de quë gac të mënë nargaꞌa lduꞌu sáhiꞌ; ni más mejurë quë gunë të ofrecer ma lua ziquë ofrendë”. Zeldë guënaꞌba ra pecadurë të guëabrí lduꞌu rall con Dios. Adë zeldë guënáꞌbëdiaꞌa mënë narniꞌi: “Nápëdiaꞌa duldë”. ");
INSERT INTO zacNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Iurní ra nazianaldë lëꞌë Juan Bautista, guabiꞌguë rall lu Jesús nu gunaꞌbë diꞌdzë rall: ―¿Pëzielú lëꞌë naꞌa nu ra fariseo rdëꞌnë naꞌa ayunë zihani vueltë perë ra shmë́nël adë rúnëdiꞌi rall ayunë? ");
INSERT INTO zacNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús guniꞌi: ―Nahia ziquë lliguë shtë saꞌa. ¿Ni mudë gunë të obligar ra invitadë shtë saꞌa, gacu rall lari nagasë ziquë mënë narunë velar guëc tëgulë mientras quëbezënú lliguë lëꞌë rall? Aquëdiꞌi. Perë guëdchini dzë nu guëdchini tiempë lëꞌë lliguë tsabsú ngaꞌli; iurní sí, gunë rall ayunë. ");
INSERT INTO zacNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Ni tubi adë chu rúnëdiꞌi rumiendë lu tubi lari gushë con lari nardëá purquë si talë guëguëuꞌl lari nardëá lu lari gushë, más nasesë rcheꞌzë lari cubi lëꞌë lari gushë. Iurní más fier rluaꞌa lari. ");
INSERT INTO zacNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ni tubi adë rgutsaꞌu vini cubi laꞌni bulsë gushë purquë adë gúnëdiꞌi gan bulsë gushë la fuersë shtë vini cubi. Rieꞌzë bulsë gushë nu lëꞌë vini guëllëꞌë lu guiuꞌu, nu gullini ra bulsë. Por ni rquiꞌni tsutsaꞌu vini cubi laꞌni bulsë cubi. Iurní lëꞌë vini nu ra bulsë adë guënítidiꞌin. Shtiꞌdza adë rgáꞌadiꞌi con custumbrë shtënë të. ");
INSERT INTO zacNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mientras Jesús quëadíꞌdziꞌ ra cusë rëꞌ, tubi narnibëꞌa mënë bëdchini; bëzullíbill lu më nu guníꞌill: ―Shtsaꞌpa niáꞌasë gualú guti, perë si talë guídël lidcha; si talë guëdchiꞌbë guiáꞌal guëc shinia, guëbániꞌ stubi. ");
INSERT INTO zacNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús guasuldiꞌ; iurní guanaldë më lë́ꞌëll con ra shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Iurë guanaldë më lë́ꞌëll, tubi naꞌa narac lluꞌu rllëꞌë rë́niꞌ; guabíꞌguëll lu Jesús. Guc chiꞌbë chupë izë rac llúꞌull. Iurní guabíꞌguëll lu Jesús nezë tëchi më. Gunáꞌzill ruaꞌ shabë më. ");
INSERT INTO zacNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Rúnëll llgabë: “Si talë guënaꞌzia shabë më, guëaca”. ");
INSERT INTO zacNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús bëdchigrë́ lu më nezë tëchi më; guná më lu naꞌa nu repi më: ―Adë riádiꞌi ldúꞌul, Nanë. Hia lë́ꞌël bëáquël purquë gualdí ldúꞌul na. Mizmë iurní bëáquëll. ");
INSERT INTO zacNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iurë Jesús bëdchíniꞌ lidchi më importantë; guná më lu narëtaꞌ nu guná më lu ra musiquë. Ra mënë ruꞌnë rall nu ruidë bëꞌnë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Iurní repi Jesús: ―Gulë bëruꞌu ndëꞌë purquë lëꞌë lliguënaꞌa rëꞌ adë gútidiꞌiꞌ sino nagáꞌsiꞌ. Perë ra mënë bëllidchinú rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesús guníꞌiꞌ de quë guëruꞌu rall. Iurní guatë́ më laꞌni hiuꞌu nu gunaꞌzi më guiaꞌa tëgulë. Iurní guashtë́ tëgulë ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Guëdubi lugar catë rnibëꞌa regiuni ni, bërëꞌtsë diꞌdzë nu famë shtënë më. Biadiꞌdzë mënë pë guc con lëꞌë tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús bëruꞌu lugar ni; chupë ciegu guanaldë rall lëꞌë më; guniꞌi rall fuertë: ―Bëgaꞌa ldúꞌul lëꞌë naꞌa, llëbní David. ");
INSERT INTO zacNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iurë Jesús guatë́ laꞌni hiuꞌu, bëdchini ra ciegu lu më; repi më lu rall: ―¿Gu rialdí lduꞌu të de quë zac gunëaca lëꞌë të? Lëꞌë rall bëquebi rall: ―Rialdí lduꞌu naꞌa, Dadë. ");
INSERT INTO zacNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Iurní Jesús bëshá guiaꞌa slu rall nu repi më: ―Gaquin según fe nanapë të. ");
INSERT INTO zacNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hia slu ra mënë ni bëaquin. Iurní Jesús gunibë́ꞌaiꞌ con ordë lu rall, ni tubi adë chu gac bë́ꞌadiꞌi lo quë nabë́ꞌniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Perë niáꞌasë gualú bëruꞌu rall ngaꞌli, iurní guzublú ruadiꞌdzë rall guëdubi regiuni lo quë nabëꞌnë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Iurë Jesús con ra shini gusëꞌdë më ziagruꞌu raiꞌ ngaꞌli, bëldá ra mënë beꞌdënú rall tubi guꞌpë nanapë mëdzabë laꞌni lduꞌi. ");
INSERT INTO zacNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Lueguë Jesús gulú hiaꞌldë lëꞌë mëdzabë ni; hia lëꞌë guꞌpë guzublú biadíꞌdzëll. Nalë́ bëdzëguëëꞌ lduꞌu ra mënë. Guniꞌi rall: ―Nunquë laꞌdi gunádiꞌiaꞌa guëdubi mënë shtë Israel saꞌ ra cusë ziquë quëhunë më. ");
INSERT INTO zacNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Perë guniꞌi ra fariseo: ―Nguiu rëꞌ rgu hiáꞌldëll ra mëdzabë por pudërë shtë mëdzabë narnibëꞌa más. ");
INSERT INTO zacNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús ziaglaꞌguë më grë ra guëꞌdchi naná rëtaꞌ guëlladchi ngaꞌli. Cagluaꞌa më laꞌni iáduꞌu shtë ra mënë cadë lugar catë rdchini më. Biadiꞌdzënú më mënë cusë zaꞌquë lla guëdchini mieti catë rnibëꞌa Dios. Nu bënëac më grë clasë galguidzë nu grë ra naquëhunë sufrir ra dulurë. ");
INSERT INTO zacNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iurë guná më ra mënë zihani, bëgaꞌa lduꞌu më lëꞌë rall purquë nalë́ rzac zi rall nu adë rbedchídiꞌi lduꞌu rall. Na rall ziquë lliꞌli nanápëdiꞌi vëquërë. ");
INSERT INTO zacNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Iurní repi më lu ra shini gusëꞌdë më: ―Guldía rniaꞌa, nanú zihani cusechë perë duꞌpsë na rall parë gunë rall dchiꞌni perë rniaꞌa lu të, ");
INSERT INTO zacNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","gulë gunaꞌbë lu Dios naná nashtënë cusechë parë guësheꞌldë më más mënë parë guadiꞌdzë rall dizaꞌquë lu mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iurní Jesús gunaꞌbë chiꞌbë chupë shini gusëꞌdë më nu bëdëꞌë më autoridá nu pudërë parë guëgú raiꞌ ra mëdzabë laꞌni lduꞌu ra mënë nu parë gunëac raiꞌ grë ra narunë sufrir galguidzë nu dulurë. ");
INSERT INTO zacNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ndëꞌë na lë ra poshtë; guëzá chiꞌbë chupë raiꞌ: primërë Simón; nápiꞌ stubi lë́hiꞌ Pedro. Nu bëꞌnë më nombrar Andrés bëchi Pedro. Gunaꞌbë më Jacobo nu bë́chiꞌ Juan, shini Zebedeo. ");
INSERT INTO zacNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Gunaꞌbë më Felipe, Bartolomé, Tomás, Mateo el quë narunë cubrë impuestë. Gunaꞌbë më Jacobo shini Alfeo. Gunaꞌbë më Lebeo, nápiꞌ stubi lë́hiꞌ Tadeo. ");
INSERT INTO zacNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Gunaꞌbë më Simón naná miembrë shtë partidë cananista, nu gunaꞌbë më Judas Iscariote el quë nabëꞌnë intriegu lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús gunibëꞌa guëzá chiꞌbë chupë nguiu ni; guniꞌinú më lëꞌë raiꞌ lla guziaꞌa raiꞌ. Repi më lu raiꞌ: ―Adë tsádiꞌi të regiuni catë quëreldë ra nadë nádiꞌi më israelitë. Nu adë tsutë́diꞌi të guëꞌdchi Samaria. ");
INSERT INTO zacNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Más bien tsa të lu ra mënë naná ziquë lliꞌli naguniti, quiere decir, naciuni Israel. ");
INSERT INTO zacNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gulë biadiꞌdzë lu mënë lla tsutë́ mënë catë rnibëꞌa Dios purquë hia lëꞌë iurë ziagdchini të guënibëꞌa më. ");
INSERT INTO zacNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gulë bënëac ra narac lluꞌu. Gulë bëcuaꞌñi ra tëgulë. Gulë bënëac narac galguidzë ruꞌdzë ládiꞌ. Gulë cu grë́tëꞌ mëdzabë laꞌni lduꞌu ra mënë. Lëꞌë të bëꞌnë të recibir pudërë ndigá; gulë bëdëꞌë sin quë gúnëdiꞌi të cubrë. ");
INSERT INTO zacNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Adë guáꞌadiꞌi të orë, ni bëdchichi, ni dumí mituꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Adë guáꞌadiꞌi të panitë parë quë dumí. Adë guáꞌadiꞌil chupë manguë, nilë chupë par rachi. Adë guáꞌadiꞌil bastunë. Pues el quë narunë dchiꞌni napë derechë parë gaull lidchi shlámëll. ");
INSERT INTO zacNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Iurë lëꞌë të guëdchini të tubi guëꞌdchi u tubi ranchi, gulë quili ngaꞌli tubi mënë naná runë tucarë guëquë́ diaguë shtiꞌdza. Hia ngaꞌli guëaꞌnë të lídchill hashtë iurë lëꞌë të guëbiꞌ të. ");
INSERT INTO zacNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Iurë lëꞌë të tsutë́ të lidchi mënë ni, gulë bëꞌnë saludar lë́ꞌiꞌ con tubi dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Si talë ra mënë ni runë tucarë guëquë́ diáguëll shtiꞌdza, gulë bëdëꞌë bendición shtë të ngaꞌli; perë si talë adë guëquë́ diáguëdiꞌi rall shtiꞌdzë të, si talë adë nádiꞌi ra mënë më zaꞌquë, gulë biequi ngaꞌli con grë dizaꞌquë shtë të. ");
INSERT INTO zacNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Si talë në́diꞌi mënë ni gunë recibir dizaꞌquë nu në́diꞌill guëquë́ diáguëll shtiꞌdzë të, iurní gulë bëruꞌu hiuꞌu ni u guëꞌdchi ni. Iurní gulë guëdchibi gushëguiuꞌu nadchiꞌbë guëaꞌ të ziquë sëñi de quë adë gualdídiꞌi lduꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Guldía rniaꞌa, dzë shtë juici más llëruꞌbë na cashtigu parë guëꞌdchi ni quë parë ra mënë shtë Sodoma u Gomorra. ");
INSERT INTO zacNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Gulë guná, na guësheꞌlda lëꞌë të cumë ziquë ra lliꞌli ladi ra ma dushë, perë gulë gac nasini cumë ziquë serpientë, nu gulë gac naduꞌu ziquë palumë. ");
INSERT INTO zacNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gulë gapë cuidadë ra mënë shtë lugar ni; gunë rall intriegu lëꞌë të lu ra gubiernë nu hashtë guëneꞌe rall galnë́ lëꞌë të laꞌni iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tsanú rall lëꞌë të lu ra gubernadurë nu lu rëy purquë na të shmëna. Zni gac të testigu shtëna delantë lu ra autoridá hashtë delantë lu ra nanádiꞌi më israelitë. ");
INSERT INTO zacNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Perë iurë lëꞌë rall gunë rall intriegu lëꞌë të lu ra gubiernë, adë rquëdíꞌnidiꞌi lduꞌu të por lo quë naguëniꞌi të lu rall u por lo quë naguadiꞌdzë të lu ra mënë, purquë iurë lëꞌë iurë guëgaꞌa, Dios guësëdchini më diꞌdzë parë guadiꞌdzë të ");
INSERT INTO zacNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","purquë lëdë lë́ꞌëdiꞌi të guadiꞌdzë të sino lëꞌë Espíritu Santo nazeꞌdë de Shtadë të, guadíꞌdziꞌ por lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ra nguiu gunë rall traicionar ra bëchi saꞌ rall të parë gati saꞌll. Ra shtadë ra mënë gunë rall traicionar shini rall. Shini rall guëásëll guëc shtadë rall hashtë quini rall shtadë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Grë́tëꞌ mënë shtë guë́ꞌdchiliu guëná záꞌquëdiꞌi rall lu të purquë na të shmëna, perë el quë nagac firmë hashtë fin, ndëꞌë gac salvar. ");
INSERT INTO zacNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Iurë lëꞌë mënë guëzunaldë rall lëꞌë të cualquier tubi guëꞌdchi catë guëdchini të, gulë bëruꞌu ngaꞌli; gulë bëlluꞌnë hashtë stubi guëꞌdchi purquë guldía rniaꞌa, lëꞌë nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu guëdchíniꞌ antsë quë lëꞌë të guadiꞌdzënú të dizaꞌquë lu mënë guëdubi guëꞌdchi shtë Israel. ");
INSERT INTO zacNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ni tubi narsëꞌdë lu shmë́siꞌ, lasáquëdiꞌill más quë mësë shtë́nëll. Ni tubi muzë lasáquëdiꞌi más quë shlámiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","El quë narsëꞌdë, tsull cunformë según el quë naquëgluaꞌa, hashtë despuësë iurní tsalú studi shtë́nëll, iurní gáquiꞌ ziquë lëꞌë mësë. Zni na tubi muzë parë lu shlámëll. Ziquë tubi nguiu con shíniꞌ, cagniꞌi ra mënë rnibëꞌa mëdzabë Beelzebú na, nu zac guëniꞌi rall rnibëꞌa mëdzabë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Por ni rniaꞌa lu të, adë rdzë́bëdiꞌi të ra mënë. Pues ni tubi cusë nanagaꞌchi adë guëáꞌnëdiꞌin sin adë guërúꞌudiꞌin lu llni. Nu grë cusë nagaꞌchi, napë quë guëdëꞌë mënë cuendë de ni. ");
INSERT INTO zacNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lo quë narniaꞌa lu të apartë, gulë guniꞌi diꞌdzë ni delantë lu grë mënë. Lo quë nabëluáꞌahia lu të apartë, gulë guniꞌi fuertë dizdë guëc hiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Adë rdzë́bëdiꞌi të ra narguini cuerpë perë adë gáquëdiꞌi quini rall almë. Más bien gulë bëdzëbë el quë nanapë pudërë guëzalú cuerpë nu almë laꞌni gabildi. ");
INSERT INTO zacNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Rduꞌ ra maꞌñi, chupë ma por tubi centavë, perë ni tubi de lëꞌë ra ma adë rátidiꞌi sino quë lëꞌë Dadë Dios adë guëdëꞌë më sí; Dios rdëꞌë më cuendë. ");
INSERT INTO zacNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Napë më cuendë bëldá guitsë guë́quël. ");
INSERT INTO zacNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Adë rdzë́bëdiꞌi të; pues más lasac të quë ra maꞌñi. ");
INSERT INTO zacNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Grë́tëꞌ el quë naguëquebi favurë de na delantë lu ra mënë, na guëquebia favurë de lë́ꞌëll delantë lu Shtada naquëbezë gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Perë si talë nanú el quë narniꞌi nádiꞌill shmëna delantë lu ra mënë, na guna negar lë́ꞌëll delantë lu Shtada naquëbezë gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Adë rúnëdiꞌi të shgabë të de quë zeldënúa paz lu guë́ꞌdchiliu rëꞌ. Pues adë zeldënúdiaꞌa parë cuedchí lduꞌu mënë con saꞌll lu guë́ꞌdchiliu sino parë gac dividir mënë por shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na zelda parë grë ra nguiu guëasë rall guëc shtadë rall, shtsaꞌpë rall guëasë rall guëc shniꞌa rall. Nu ra lliꞌlli guëasë rall guëc suëgrë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","De mudë de cadë tubi rall gac rall enemigu parë famili shtënë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’El quë narac shtuꞌu shtádiꞌ u shníꞌaiꞌ más quë rac shtúꞌull na, adë rlluíꞌidiꞌi gáquiꞌ shmëna. El quë narac shtuꞌu llgáꞌniꞌ u shtsápiꞌ más quë rac shtúꞌull na, adë rllúiꞌidiꞌi gáquëll shmëna. ");
INSERT INTO zacNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","El quë nadë gúnëdiꞌi renunci prupi deseo shtë́nëll, si talë adë në́diꞌi gátill por na; si talë adë tsanáldëdiꞌill shneza, nguiu ni nasáquëdiꞌill gáquëll shmëna. ");
INSERT INTO zacNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","El quë narac shtuꞌu gac salvar vidë shtë́nëll, guënítill vidë shtë́niꞌ, perë el quë naguëniti vidë shtë́niꞌ por na, ni gac salvárëll. ");
INSERT INTO zacNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’El quë narunë recibir cualquier tubi de lëꞌë të, mënë ni también rúnëll recibir na. El quë narunë recibir na, mënë ni rúnëll recibir el quë nabësheꞌldë na. ");
INSERT INTO zacNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","El quë narunë recibir tubi shmuzë Dios purquë zeꞌdë mënë ni de Dios, ni gúnëll recibir mizmë premi nardëꞌë Dios parë ra shmuzë më nabiadiꞌdzë shtiꞌdzë më. El quë narunë recibir tubi nguiu zaꞌquë purquë nall më zaꞌquë, mënë ni gúnëll recibir premi shtë më zaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Cualquier el quë naguëdëꞌë tubi vasë nisë galë, të gu tubi más humildë shmëna, guldía rniaꞌa lu të, segurë guëdëꞌë Dios tubi premi cáꞌall. ");
INSERT INTO zacNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iurë Jesús gualú guniꞌi më lla mudë guziaꞌa ra chiꞌbë chupë shini gusëꞌdë më, bëruꞌu më ngaꞌli parë ziaꞌa më. Bëluaꞌa më dizaꞌquë lu ra mënë guëꞌdchi narëtaꞌ guëlladchi. ");
INSERT INTO zacNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan nanú lachiguiꞌbë perë bíniꞌ lo quë naquëhunë Cristo. Iurní bëshéꞌldiꞌ bëldá shmë́niꞌ; tsagná rall lëꞌë Jesús ");
INSERT INTO zacNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","parë guagnaꞌbë diꞌdzë rall lu më: ―¿Gu lë́ꞌël nal Cristo, el quë napë quë guëdchini por partë shtë Dadë Dios, u napë quë guëlezë naꞌa stubi naguëdchini? ");
INSERT INTO zacNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús repi: ―Gulë tsaguëchi lu Juan lo quë naguná të nu lo quë nabini të. ");
INSERT INTO zacNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gulë biadiꞌdzë grë́tëꞌ lo quë naguná të: ra ciegu rna; ra cujë rzë; ra narac galguidzë ruꞌdzë ládiꞌ, guzunë́ rall; grë ra cueꞌtë bëabrí rini rall. Ra tëgulë gubani rall stubi. Grë ra prubi quëquë́ diaguë rall dizaꞌquë parë gac salvar rall. ");
INSERT INTO zacNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Guëquitë lduꞌu ra naná tsaglaꞌguë tsaldí lduꞌi na, grë ra nartúdiꞌi lúhiꞌ gáquëll shmëna. ");
INSERT INTO zacNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Iurë lëꞌë shmënë Juan zëagzë́, iurní Jesús guzublú quëadiꞌdzë më shcuendë Juan. Repi më lu ra mënë: ―¿Pë guagná të lu shlatë; tubi ziquë guiꞌlli narniꞌbi mbë? ");
INSERT INTO zacNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aquëdiꞌi. ¿Pë guagná të lu tubi nguiu nanacu lari chulë? Aquëdiꞌi. Lëꞌë të nanë́ të de quë grë ra naracu con lari nalasac zihani dumí, quëreldë rall lidchi rëy. ");
INSERT INTO zacNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Por fin ¿pë guagná të lu tubi muzë shtë Dios? Perë sí, de verdá guná të tubi muzë shtë më mayurë quë ra nabiadiꞌdzë shtiꞌdzë më guahietë. ");
INSERT INTO zacNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan na el quë narniꞌi Sagradas Escrituras: Na guësheꞌlda tubi naguadiꞌdzë por na antsë guëluaꞌalul lu mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Guldía rniaꞌa, grë́tëꞌ ra mënë nagubani tiempë guahietë, nápëdiꞌi raiꞌ más hunurë quë Juan. Perë rniaꞌa lu të, el quë namás humildë entrë ra mënë narialdí lduꞌi dizaꞌquë shtëna, napë rall más hunurë quë Juan. ");
INSERT INTO zacNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Dizdë Juan Bautista hashtë iurneꞌ, ra mënë mal rac shtuꞌu rall guëzalú rall dizaꞌquë shtë Dios parë adë tsutë́diꞌi mënë catë rnibëꞌa Dios. Ra narac shtuꞌu tsutë́ nezë zaꞌquë, runë rall llëruꞌbë fuersë parë tsutë́ rall. ");
INSERT INTO zacNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Grë́tëꞌ lo quë nabëquëꞌë ra muzë nabiadiꞌdzë shtiꞌdzë Dios nu lo quë nabëquëꞌë Moisés, guniꞌi raiꞌ lo quë narac shtuꞌu Dios hashtë tiempë shtë Juan Bautista. ");
INSERT INTO zacNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Si talë lëꞌë të rac shtuꞌu të tsaldí lduꞌu të lo quë narniaꞌa de Juan, náhiꞌ ziquë Elías. Juan náhiꞌ el quë muzë shtë Dios guniꞌi guahietë napë quë guëdchini. ");
INSERT INTO zacNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Si talë rac shtuꞌu të tsasë́ të, gulë bëquë́ diaguë bien lo quë narniaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Guadiꞌdza tubi comparaciuni lla na mënë tiempë neꞌ. Lëꞌë rall na rall ziquë llguëꞌnë nacaguitë. Zúbëgaꞌa rall lu llguëaꞌ nu rniꞌi rall fuertë lu saꞌ rall: ");
INSERT INTO zacNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Bëdiꞌldi naꞌa musiquë lëgrë perë adë bëguíꞌidiꞌi të. Bëdiꞌldi naꞌa cantë tristë perë adë bíꞌnidiꞌi të.” ");
INSERT INTO zacNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bëdchini Juan; adë gudáudiꞌiꞌ zihani cusë nu adë biiꞌdiꞌiꞌ licor, perë lëꞌë të rniꞌi të de quë nápiꞌ tubi mëdzabë laꞌni ldúꞌiꞌ; por ni adë guanáldëdiꞌi të lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Lueguë bëdchinia, nguiu nabësheꞌldë Dios; rniꞌi të rau shaꞌta nu rniꞌi të ruhia vini. Rniꞌi të nahia amigu shtë pecadurë nu amigu shtë ra narunë cubrë impuestë, por ni adë rialdídiꞌi lduꞌu të shtiꞌdza. Manërë nacanihunë Dios na ziquë llni; rluaꞌain laꞌni vidë shtë ra naná riasë́ shtiꞌdzë më de verdá. ");
INSERT INTO zacNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iurní lëꞌë Jesús guzublú quëgniꞌi më lu ra mënë guëꞌdchi catë bëꞌnë më más milagrë ruꞌbë purquë ra mënë ni, adë bëabrídiꞌi lduꞌu rall con Dios. Iurní guniꞌi më: ");
INSERT INTO zacNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Prubi de lëꞌë të mënë shtë guëꞌdchi Corazín. Prubi de lëꞌë të mënë shtë guëꞌdchi Betsaida; purquë si talë mënë shtë Tiro nu Sidón nianá rall grë ra milagrë naguná të, pues hia niac cambi mudë nanabani rall; niabrí lduꞌu rall con Dios. Niazubë rall lu dë nu niacu rall lari nagasë ziquë señi de quë bëꞌnë nadzëꞌë mudë nanabani rall. ");
INSERT INTO zacNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Na rniaꞌa lu të, dzë guësheꞌldë Dios juici guëc mënë shtë guë́ꞌdchiliu, ra mënë shtë Tiro nu Sidón gunë rall sufrir menos quë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nu rniaꞌa lu të naquëreldë guëꞌdchi Capernaum, runë nadchini të por tantë llni nabëꞌnë të recibir, perë tsalú të lugar catë quëbezë ra tëgulë purquë mënë shtë ciudá Sodoma, si talë nianá rall milagrë cumë ziquë guná të, pues todavía nianá quëbezë guëꞌdchi Sodoma iurneꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Perë rniaꞌa lu të, dzë shtë juici lëꞌë të gunë të recibir más cashtigu dushë quë ra mënë shtë regiuni shtë Sodoma. ");
INSERT INTO zacNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tiempë ni Jesús biadiꞌdzënúhiꞌ Shtádiꞌ: ―Dadë, dushquíllil, rnibë́ꞌal gubeꞌe nu guë́ꞌdchiliu. Quëhuna alabar lë́ꞌël, Dadë; bëluáꞌal shtíꞌdzël lu mënë humildë, rac bëꞌa rallin. Perë nacahi shtíꞌdzël bë́ꞌnël parë ra mënë narniꞌi na rall më ruꞌbë, ra mënë narianaldë tëchi llgabë nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Zni bë́ꞌnël Dadë purquë zni rac shtúꞌul gac. ");
INSERT INTO zacNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Lëꞌë Shtada bëneꞌe grë́tëꞌ cusë rëꞌ parë na; ni tubi chu runguë bëꞌa chu nahia de verdá, sulamëntë Shtada runguë bë́ꞌaiꞌ. Ni tubi chu runguë bëꞌa chu na Shtada de verdá, sulamëntë na runguë bë́ꞌahia chu náhiꞌ. Nahia shini më; gunguë bëꞌa mënë Shtada sulamëntë si rac shtuaꞌa guëluáꞌahia nguiu ni Shtada. ");
INSERT INTO zacNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Gulë teꞌe lua grë́tëꞌ el quë narbedchídiꞌi lduꞌi, grë të nariashac lduꞌi por duldë shtë të, guënehia paz parë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gulë bëcaꞌa yuguë naguëdchiꞌba guëc të nu gulë bësëꞌdë shtiꞌdza. Nadúꞌuhia nu nalë́ pacënci nahia. Gulë teꞌe lua të guëdzelë të descansë parë almë shtë të. ");
INSERT INTO zacNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ldaiꞌ nabëluáꞌahia lu të, nalë́ sencigi nahin parë guaꞌa të ziquë tubi yuguë shashu. Lo quë narnibë́ꞌahia adë nagánëdiꞌin. ");
INSERT INTO zacNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Laꞌni ra dzë ni Jesús ziáꞌaiꞌ nezë shtënë më catë rgabní trigu. Tubi dzë narziꞌi lduꞌu mënë, ra shini gusëꞌdë më bëdchini galërldiaꞌnë lduꞌu raiꞌ. Iurní guzublú caniashi raiꞌ duꞌu shtë trigu parë quëháu raiꞌ bëꞌdchi trigu. ");
INSERT INTO zacNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Iurë lëꞌë ra fariseo guná rall lo quë nabëꞌnë raiꞌ, repi rall lu Jesús: ―Guná, ra shini gusë́ꞌdël quëhunë rall lo quë naprovidë según lëy. Caniashi rall duꞌu dzë narziꞌi lduꞌu mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús repi: ―¿Pë adë bíꞌldidiꞌi të histuri lo quë nabëꞌnë David guahietë con ra narianaldë të́chiꞌ? Bëldiaꞌnë David nu guatë́hiꞌ lidchi Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Gunaꞌzi David guetështildi sagradë. David gudáuhiꞌ guetështildi ni, perë según lëy shtë Dios sulë bëshuzi napë rall derechë gau raiꞌ guetështildi sagradë, lë́dëdiꞌi David con ra mënë nananú con lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Hia biꞌldi të lëy shtë Moisés. Ra bëshuzi shtë iáduꞌu adë rzíꞌidiꞌi lduꞌu rall dzë descansë por trabaju nanapë raiꞌ; nu nádiꞌin duldë. ");
INSERT INTO zacNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na rniaꞌa lu të, zugaꞌa tubi nguiu ndëꞌë naná más importantë quë iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Lëꞌë të, ¿pë adë riasë́diꞌi të lo quë narniꞌi Sagradas Escrituras? “Na rac shtuaꞌa guëgaꞌa lduꞌu të saꞌ të más quë ra ma narneꞌe të lu bëcuꞌguë ziquë ofrendë”. Si talë riasë́ të diꞌdzë ni, adë gúnëdiꞌi të condenar ra nanápëdiꞌi faltë. ");
INSERT INTO zacNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Lëꞌë nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, nápiꞌ autoridá nu pudërë parë guëníꞌiꞌ pë gunë mënë dzë narziꞌi lduꞌu mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iurní Jesús bëruꞌu lugar ni. Guatë́ më laꞌni iáduꞌu shtë ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ngaꞌli zugaꞌa tubi nguiu nagubidchi tubi guiáꞌaiꞌ. Perë ra fariseo rac shtuꞌu rall guëdzelë rall manërë parë gunë rall acusar lëꞌë Jesús. Iurní gunaꞌbë diꞌdzë rall lu Jesús: ―Según lëy ¿gu nanú permisi gunëac mënë narac lluꞌu grë ra dzë narziꞌi lduꞌu mënë? ");
INSERT INTO zacNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Repi Jesús: ―¿Chu de lëꞌë të si talë guënítil tubi lliꞌli, si talë ldaguë ma laꞌni guërzú dzë descansë, pë adë tsaldúdiꞌi të ma? ");
INSERT INTO zacNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pues más nasac vidë shtë nguiu quë lliꞌli. Zni nanú permisi gunë mieti bien dzë narziꞌi lduꞌu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Iurní repi më lu nguiu nagubidchi guiáꞌaiꞌ: ―Bëldí guiáꞌal. Lëꞌë nguiu bëldí guiáꞌaiꞌ. Lueguë bëac guiáꞌaiꞌ; bëaꞌnë guiáꞌaiꞌ ziquë na stubi guiáꞌaiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Iurní bëruꞌu ra fariseo. Guzublú rall quili rall manërë parë quini rall lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iurë guc bëꞌa Jesús pë quëhunë ra fariseo, bëruꞌu më; ziaꞌa më stubi lugar. Perë cantidá mënë guanaldë rall lëꞌë më. Jesús bënëac grë́tëꞌ narac lluꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nu bëdëꞌë më ordë de quë adë guadíꞌdzëdiꞌi ra mënë chu na më. ");
INSERT INTO zacNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Zndëꞌë guc parë gac cumplir lo quë nabëquëꞌë Isaías, muzë shtë Dios: ");
INSERT INTO zacNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ndëꞌë lëꞌë shmuza nagulë́a; el quë nalë́ rac shtuaꞌa nu el quë narquitë lduaꞌa. Guëdë́ꞌëhia Espíritu Santo cuezënúhiꞌ më ni. Guëniꞌi më lu mënë nanádiꞌi më israelitë de quë zeꞌdë guëdchini juici shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Adë guadíꞌdzëdiꞌi më tantë. Na më naduꞌu. Adë rtáꞌlëdiꞌi më diꞌdzë; adë guëníꞌidiꞌi më fuertë nezë. ");
INSERT INTO zacNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Na më pacënci; adë nádiꞌi më ziquë el quë narguitsu guiꞌlli. Nádiꞌi më ziquë el quë narsëaldë mëchi narquë́ guiꞌi. Cuezë më hashtë cueshtë́ gubiernë shtë́hiꞌ; guënibëꞌa më manërë justë. ");
INSERT INTO zacNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mënë nanádiꞌi më israelitë, tsaldí lduꞌu rall shtiꞌdzë më parë gac salvar rall. ");
INSERT INTO zacNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Iurní bëdchininú mënë tubi nguiu lu Jesús. Nall ciegu nu guꞌpë. Bëꞌnë mëdzabë nananú laꞌni lduꞌu nguiu ni parë adë rnádiꞌill nu rníꞌidiꞌill. Jesús bënëac lë́ꞌiꞌ. Iurní guná nguiu, nu clarë biadiꞌdzë nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Grë́tëꞌ ra mënë narëtaꞌ ngaꞌli, guasë́ lduꞌu rall nu bëdzëguëëꞌ lduꞌu rall. Guniꞌi rall: ―¿Pë lë́ꞌëdiꞌi llëbní David ndëꞌë, el quë nacabézaꞌa? ");
INSERT INTO zacNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Perë ra fariseo bini rall lo quë naguniꞌi mënë; guniꞌi rall: ―Perë hiumbrë rëꞌ rgull mëdzabë por pudërë shtë Beelzebú, jëfë shtë ra mëdzabë. ");
INSERT INTO zacNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Perë guc bëꞌa Jesús lo quë narunë rall shgabë rall. Iurní repi më: ―Si talë grë mënë shtë gubiernë rdildi cuntrë mizmë saꞌ rall, tsalú gubiernë. Igual gac con tubi guëꞌdchi nu si talë tubi famili rdildi entrë lëꞌë rall, guëdchini tiempë tsalú famili ni. ");
INSERT INTO zacNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nu Satanás, si talë Satanás nadivididë mizmë lë́ꞌëll, tsalú pudërë shtë́nëll; guënibë́ꞌadiꞌill shmë́nëll iurní. ");
INSERT INTO zacNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Si talë rguhia mëdzabë por pudërë shtë Beelzebú, ¿chu runë compañi ra mënë saꞌ të nargú mëdzabë laꞌni lduꞌu mënë? Mizmë nguiu ni gunë rall juzguë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Perë si talë con pudërë shtë Dios rguhia mëdzabë, hia bëgaꞌa iurë; guëlladchi zugaꞌa Dios parë guënibë́ꞌaiꞌ lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Llallë gac tsutë́ tubi ngubaꞌnë lidchi tubi nguiu fuertë të parë guëdchisull pë shtënë mënë? Primërë napë quë guëlíꞌbill nguiu ni, iurní sí, zac guëdchisull pë shtënë mënë ni. ");
INSERT INTO zacNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’El quë nanë́diꞌi guëniꞌi favurë de na, nall cuntrë de na. El quë nadë rtëádiꞌi mënë lua, na ziquë tubi narsëlluꞌnë mënë lua. ");
INSERT INTO zacNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Rniaꞌa lu të de quë zac perdunë grë duldë shtë ra nguiu nu grë́tëꞌ didzabë narniꞌi rall, gunë më perdunë, perë si talë guniꞌi mënë diꞌdzë mal cuntrë Espíritu Santo, ni sí, jamás adë nídiꞌi perdunë. ");
INSERT INTO zacNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Cualquier narniꞌi didzabë guëc nguiu nabësheꞌldë Dios, zac perdúnëll perë el quë naruadiꞌdzë cuntrë Espíritu Santo, jamás adë gáquëdiꞌi perdunë parë guëdubi tiempë lu guë́ꞌdchiliu rëꞌ, nilë́ lu stubi guë́ꞌdchiliu nanadë tsalúdiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Si talë hiaguë nahin cusë zaꞌquë, zni rneꞌein nashi zaꞌquë. Si talë hiaguë nahin mal, pues nashi mal rneꞌein. Shnashi hiaguë rluaꞌa pë hiaguin. ");
INSERT INTO zacNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Lëꞌë të llëbní mbeꞌldë, ¿llallë gac guëniꞌi të cusë zaꞌquë? hia quë lëꞌë të mizmë lëꞌë të na të mal. Pues ruadiꞌdzë të zihani diꞌdzë dzabë nazeꞌdë laꞌni lduꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nguiu zaꞌquë ruadíꞌdzëll cusë zaꞌquë purquë cusë zaꞌquë nanú laꞌni ldúꞌull. Perë ra nguiu mal ruadíꞌdzëll cusë mal purquë cusë mal nanú laꞌni lduꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Perë na rniaꞌa lu të, dzë shtë juici grë mieti guëdëꞌë rall cuendë lu Dios por grë ra diꞌdzë nagúpëdiꞌi rall cuidadë. ");
INSERT INTO zacNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Purquë según diꞌdzë nabiadiꞌdzë të, gunë më juzguë lëꞌë të; gac salvar të u gac condenadë të. ");
INSERT INTO zacNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Iurní guniꞌi ra fariseo nu ra narluaꞌa lëy lu Jesús: ―Mësë, rac shtuꞌu naꞌa guëná naꞌa tubi señi, tubi milagrë ruꞌbë gúnël. ");
INSERT INTO zacNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús bëquebi: ―Mënë mal nalë́ rac shtuꞌu rall guëná rall tubi sëñi nu milagrë ruꞌbë, perë hia jamás adë chu guënéꞌeruꞌu más sëñi, sulë sëñi ziquë naguc con Jonás. ");
INSERT INTO zacNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ziquë Jonás gua laꞌni mbeldë durantë tsunë dzë nu tsunë gueꞌlë, zni zac con nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu; guëcaꞌchi ra mënë lë́ꞌiꞌ laꞌni baꞌa; tsúhiꞌ ngaꞌli tsunë dzë nu tsunë gueꞌlë. ");
INSERT INTO zacNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Grë ra naguquëreldë ciudá shtë Nínive tsasuldí rall lu juici con ra mënë naquëreldë neꞌ, nu guëniꞌi ra mënë shtë Nínive ra mënë nanabani neꞌ na rall culpablë purquë ra mënë shtë Nínive, iurë bini rall shtiꞌdzë Jonás, bëabrí lduꞌu rall con Dios. Gulë guná, hia bëdchini tubi más më importantë quë Jonás. ");
INSERT INTO zacNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Iurë gac juici shtë Dios, lëꞌë reina nagunibëꞌa ladzë Sur, tsasuldill nu gúnëll juzguë mënë nanabani neꞌ; na rall culpablë purquë naꞌa ni bidë guënall lu Salomón të guëquë́ diáguëll llgabë shtë Salomón; perë gulë guná, hia bëdchini tubi más më importantë quë Salomón. ");
INSERT INTO zacNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Iurë bëruꞌu mëdzabë laꞌni lduꞌu nguiu, rzëll catë nídiꞌi nisë. Rguílill catë cuézëll perë adë rdzélëdiꞌill lugar. Iurní rníꞌill: ");
INSERT INTO zacNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Guëabría lduꞌu mënë catë bëruaꞌa”. Bëdzélëll nguiu ziquë tubi hiuꞌu bien arregladë nu limpi. ");
INSERT INTO zacNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Iurní tsaglliꞌi mëdzabë gadchi mëdzabë más mal quë lë́ꞌëll; riutë́ rall laꞌni lduꞌu nguiu ni. Por fin bëaꞌnë nguiu peor quë antsë. Zni gac suceder con ra mënë mal rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nianá Jesús ziaglaꞌguë quëadíꞌdziꞌ lu ra mënë zihani, iurní bëdchini shniꞌa më con ra bëchi më. Rëtaꞌ raiꞌ tëchi fuërë nu rac shtuꞌu raiꞌ guadiꞌdzënú raiꞌ lëꞌë më.  ");
INSERT INTO zacNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Bëdchini tubi nabëdchininú rsunë lu Jesús. Guníꞌill: ―Lëꞌë shníꞌal nu ra bë́chil zugaꞌa raiꞌ tëchi fuërë; rac shtuꞌu raiꞌ guadiꞌdzënú raiꞌ lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Perë lëꞌë më repi lu naguanú rsunë: ―¿Chull na shníꞌahia? ¿Chull na bëcha? ");
INSERT INTO zacNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Iurní bëꞌnë më sëñi con guiaꞌa më; guniꞌi më shcuendë ra shini gusëꞌdë më: ―Ndë lëꞌë shníꞌahia nu ndëꞌë na bëcha ");
INSERT INTO zacNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","purquë grë́tëꞌ el quë narunë según voluntá shtë Shtada naquëbezë gubeꞌe, na bëcha; nall zana, nu nall shníꞌahia. ");
INSERT INTO zacNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mizmë dzë ni bëruꞌu Jesús hiuꞌu. Iurní guzubë më ruaꞌ nisë ruꞌbë nu cantidá mënë bëdëá rall lugar catë quëbezë më. ");
INSERT INTO zacNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Por ni Jesús guatë́ laꞌni tubi barcu; iurní guzubë më parë guëluaꞌa më. Grë́tëꞌ ra mënë bëaꞌnë rall ruaꞌ nisë lu guiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Cagluaꞌa më zihani cusë por comparaciuni. Guniꞌi më: ―Tubi nguiu guagtë́ꞌtsëll bëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Iurë bëtë́ꞌtsëll bëꞌdchi, duꞌpë bëꞌdchi gulaguë lu nezë, hia ngaꞌli bëdchini ra maꞌñi. Gudáu ma ra bëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Stuꞌpë bëꞌdchi gulaguë lu guiuꞌu guëꞌë catë duꞌpë guiuꞌu nanú. Hia bëꞌdchi ni nasesë gualdanin purquë duꞌpë guiuꞌu nanú ");
INSERT INTO zacNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","perë iurë lëꞌë ngubidzë bëruꞌu, güeꞌqui plantë purquë nápëdiꞌin llëruꞌbë shluꞌchi; gubidchin. ");
INSERT INTO zacNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Stuꞌpë bëꞌdchi gulaguë ladi ra guiꞌlli guitsë. Gualdanin laꞌni guiꞌlli guitsë perë guiꞌlli guni guëquin. ");
INSERT INTO zacNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Perë stuꞌpë bëꞌdchi gulaguë lu guiuꞌu zaꞌquë. Ngaꞌli bëdëꞌin cusechë. Bëldá bëꞌdchi bëdëꞌë tubi gahiuꞌa por tubi. Sëbëldahin bëdëꞌë sesenta por tubi bëꞌdchi. Stubi bëdëꞌë galdë bi chi por tubi. ");
INSERT INTO zacNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Si talë rac shtuꞌu të tsasë́ të, gulë bëquë́ diaguë bien shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iurní ra shini gusëꞌdë më guabiꞌguë raiꞌ lu Jesús. Gunaꞌbë diꞌdzë raiꞌ: ―¿Pëzielú ruadíꞌdzël lu ra mënë por comparaciuni? ");
INSERT INTO zacNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Lëꞌë më bëquebi: ―Dios bësheꞌldë llni guëc të parë riasë́ të manërë narnibëꞌa Dios ziquë rëy, perë adë bëshéꞌldëdiꞌi Dios llni guëc rall parë gac bëꞌa rall manërë narnibëꞌa më. ");
INSERT INTO zacNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","El quë narac shtuꞌu tsasë́ shtiꞌdzë më, guëdëꞌë më más llni, perë el quë nanë́diꞌi tsasë́ shtiꞌdzë më, tsabsú grë llni nanápëll. ");
INSERT INTO zacNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Por ni quëadiꞌdza por comparaciuni purquë lëꞌë rall rna rall lu milagrë shtëna perë adë riasë́diꞌi rall. ");
INSERT INTO zacNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Zni na rall. Guc cumplir shtiꞌdzë Isaías el quë nabiadiꞌdzë shtiꞌdzë Dios guahietë. Bëquë́ꞌëiꞌ: Lëꞌë të, sí, segurë guini të perë adë riasë́diꞌi të. Segurë guëná të perë adë guëdë́ꞌëdiꞌi të cuendë ");
INSERT INTO zacNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","purquë nalë́ naguëdchi lduꞌu mënë. Adë në́diꞌi rall tsasë́ rall; adë në́diꞌi guëdëꞌë rall cuendë shtiꞌdzë Dios. Në́diꞌi rall guëdchini llni guëc rall. Na rall ziquë ra ciegu nu ziquë naná rcueꞌtë. Në́diꞌi rall tsasë́ rall parë guëabrí lduꞌu rall con na parë gunëaca almë shtë rall të gac salvar rall. ");
INSERT INTO zacNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Dichusë të purquë riasë́ të lo quë narná të nu rdëꞌë të cuendë shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Guldía rniaꞌa, cantidá ra muzë shtë Dios guahietë nu mënë zaꞌquë naguquëreldë antsë, guc shtuꞌu raiꞌ nianá raiꞌ cusë nabëna perë adë gunádiꞌi raiꞌ. Guc shtuꞌu raiꞌ nini raiꞌ diꞌdzë shtëna nabini të perë adë bínidiꞌi raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Gulë bëquë́ diaguë iurneꞌ lo quë narunë cuntienë comparaciuni shtë naquëgtëꞌtsë bëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Grë ra nabini dízaꞌquë narniꞌi lla rnibëꞌa Dios ziquë rëy perë riasë́diꞌill, nall ziquë bëꞌdchi nagulaguë lu nezë. Ridë mëdzabë; rdchisú mëdzabë dizaꞌquë nabëcabní më laꞌni ldúꞌull. ");
INSERT INTO zacNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bëꞌdchi nagulaguë lu guiuꞌu guëꞌë, na ziquë mënë narini dizaꞌquë; rëuuꞌ lduꞌu rall dizaꞌquë; lueguë rcaꞌa rallin con gustë. ");
INSERT INTO zacNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Perë cumë ziquë plantë nanápëdiꞌi shluꞌchi, adë tsagláꞌguëdiꞌi rall shnezë më. Iurë lëꞌë ra mënë rzac zi rall lë́ꞌëll por shtiꞌdzë Dios u iurë rzunaldë mënë lë́ꞌëll, lueguë rëazë guétëll. ");
INSERT INTO zacNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bëꞌdchi nagulaguë ladi guiꞌlli guitsë, na ziquë el quë narini dizaꞌquë perë por tantë rac lduꞌu rall por ra cusë shtë guë́ꞌdchiliu nu rac shtuꞌu rall gac rall ricu, hia adë rianáldëdiꞌi rall tëchi dizaꞌquë. Grë deseo mal na ziquë guiꞌlli guitsë narteꞌe ra plantë nu adë rdë́ꞌëdiꞌin cusechë. ");
INSERT INTO zacNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Perë bëꞌdchi nagulaguë lu guiuꞌu zaꞌquë, na ziquë ra mënë narini dizaꞌquë shtë Dios. Riasë́ rall pë runë cuntienë shtiꞌdzë më. Nall ziquë plantë nardëꞌë cusechë. Bëldá rall rdëꞌë tubi gahiuꞌa por tubi bëꞌdchi. Sëbëldahin rdëꞌë sesenta por tubi, nu stubi rdëꞌë galdë bi chi por tubi. ");
INSERT INTO zacNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús guniꞌi stubi comparaciuni: ―Lugar catë rnibëꞌa Dios na ziquë tubi nguiu nabëcabní bëꞌdchi zaꞌquë lu guiuꞌu shtë́niꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Perë iurë lëꞌë rall nagaꞌsi rall, bëdchini tubi enemigu. Hia hiumbrë ni bëcabní guiꞌlli mal ladi trigu. Lueguë ziáꞌall. ");
INSERT INTO zacNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Iurë lëꞌë trigu guaruꞌbin nu lëꞌë duꞌu bëruꞌu, también lëꞌë guiꞌlli guaruꞌbin ladi trigu. ");
INSERT INTO zacNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Iurní muzë shtë lamë repi rall: “Dadë, bëꞌdchi nabëcabnil lu lachi ¿pë bëꞌdchi zaꞌquin? ¿Callë bëruꞌu guiꞌlli mal gualdani ladi trigu?” ");
INSERT INTO zacNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Lëꞌë nashtënë guiuꞌu guniꞌi: “Aquë, tubi enemigu bëcabní bëꞌdchi guiꞌlli”. Iurní ra muzë gunaꞌbë diꞌdzë rall: “¿Gu rac shtúꞌul guiá naꞌa të guëdashi naꞌa grë́tëꞌ ra guiꞌlli mal?” ");
INSERT INTO zacNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Perë lëꞌë lamë guniꞌi: “Aquëdiꞌi purquë si talë gashi të guiꞌlli mal, nu zac trigu gashi të. ");
INSERT INTO zacNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mejurë ziaruꞌbin juntë hashtë tiempë shtë cusechë. Iurní guënibë́ꞌahia ra muzë të parë guëtëá rall guiꞌlli mal primërë nu guëliꞌbin, gac manullin të parë tsequin. Hia despuësë guëdëá trigu të parë tsutsáꞌuhin.” ");
INSERT INTO zacNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús guniꞌi stubi comparaciuni: ―Lugar catë rnibëꞌa Dios, na ziquë tubi bëꞌdchi mituꞌnë. Tubi nguiu guacabní bëꞌdchi lu shguiúꞌull. ");
INSERT INTO zacNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bëꞌdchi ni na más mituꞌnë quë grë ra bëꞌdchi, perë iurë ra plantë riaruꞌbë, llëruꞌbë na hiaguë más quë grë plantë shtë lachi. Hia iurní ridë ra maꞌñi; bëdchiꞌbë ra ma bëcheꞌzë lu llicu hiaguë. ");
INSERT INTO zacNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Guniꞌi më stubi comparaciuni: ―Lugar catë rnibëꞌa Dios na ziquë tubi ldë levadurë nabëdchiꞌbë naꞌa con tsunë medidë harinë. Bëshepi levadurë hashtë bëdëꞌëin fuersë grë nacubë. ");
INSERT INTO zacNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Guniꞌi Jesús grë́tëꞌ ra cusë rëꞌ lu ra mënë con comparaciuni. Ni tubi cusë adë guníꞌidiꞌi më sin comparaciuni. ");
INSERT INTO zacNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Zndë guc parë gac cumplir lo quë nabëquëꞌë muzë shtë Dios guahietë: Guadiꞌdza por comparaciuni. Guadiꞌdza ra cusë nagaꞌchi dizdë iurë lëꞌë Dios bëcueꞌshtë́ guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iurní bëtëꞌtsë Jesús mënë. Guatë́ më tubi hiuꞌu. Iurní ra shini gusëꞌdë më guabiꞌguë raiꞌ lu më nu repi raiꞌ: ―Biadiꞌdzë lu naꞌa pë runë cuntienë comparaciuni shtë guiꞌlli mal. ");
INSERT INTO zacNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iurní Jesús repi: ―El quë narcabní bëꞌdchi zaꞌquë, quëhúniꞌ representar nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Hia lachi runë significar guë́ꞌdchiliu. Bëꞌdchi zaꞌquë quëhunë representar ra mënë nabëꞌnë recibir Dios ziquë rëy. Hia lëꞌë guiꞌlli mal runë significar mënë narzuꞌbë diaguë shtiꞌdzë mëdzabë. ");
INSERT INTO zacNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Enemigu nabëcabní bëꞌdchi mal, na mëdzabë. Ra cusechë runë significar fin shtë guë́ꞌdchiliu. Hia narcaꞌa cusechë ni, na ra ianglë. ");
INSERT INTO zacNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ziquë ra guiꞌlli mal guëdëahin të parë tsahin lu guiꞌi, zni gac iurë guëdchini fin shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Guënibë́ꞌahia tsa ra ianglë parë guëtëá raiꞌ ra mënë narunë mal nu grë narsini sáhiꞌ lu duldë. Na rall ziquë tubi guëꞌë catë rreldë mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Grë́tëꞌ ra hiumbrë ni tsa rall lu guiꞌi shtë gabildi catë guꞌnë rall nu hashtë guëchushí laiꞌ rall. ");
INSERT INTO zacNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Iurní ra shini Dios guëcabtsëꞌë raiꞌ ziquë ngubidzë catë rnibëꞌa Dios, Shtadë raiꞌ. Si talë rac shtuꞌu të tsasë́ të, gulë bëquë́ diaguë bien shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Lugar catë rnibëꞌa Dios, na ziquë tubi tesurë nabëcaꞌchi mënë lu tubi guiuꞌu lachi, perë tubi nguiu bëdzelë tesurë ni. Iurní bëquitë ldúꞌull. Bëcáꞌchill tesurë ni laꞌni guiuꞌu stubi. Bëtuuꞌll grë́tëꞌ shtë́nëll parë síꞌill guiuꞌu catë nanú tesurë. ");
INSERT INTO zacNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’También lugar catë rnibëꞌa Dios, na ziquë tubi narziꞌi perla fini. Ziatílill perla namás lasac. ");
INSERT INTO zacNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iurë lë́ꞌëll bëdzélëll perla namás lasac, iurní guëtuuꞌll grë́tëꞌ lo quë nanápëll të parë síꞌill perla ni. ");
INSERT INTO zacNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Nu zac lugar catë rnibëꞌa Dios, na ziquë tubi guëꞌshu nabëtiaꞌa mënë lu nisë të guënaꞌzi guëꞌshu grë́tëꞌ clasë mbeldë. ");
INSERT INTO zacNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Iurë lëꞌë guëꞌshu guadzë́, mënë narnaꞌzi mbeldë rgu rall guëꞌshu ruaꞌ nisë. Hia ngaꞌli zubë rall parë rbë rall mbeldë. Rgutsaꞌu rall ra mbeldë zaꞌquë laꞌni tubi tëpë. Hia grë ra mbeldë nadë rlluíꞌidiꞌi rruꞌldë rall tubi ladë. ");
INSERT INTO zacNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Zni gac fin shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Guëdchini ra ianglë lu guë́ꞌdchiliu parë cuë raiꞌ ra mënë narunë mal ladi ra mënë narunë bien të parë tsa ra hiumbrë mal gabildi catë nanú beꞌlë. Ngaꞌli guꞌnë rall nu guëchushí laiꞌ rall. ");
INSERT INTO zacNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iurní Jesús gunaꞌbë diꞌdzë: ―¿Gu riasë́ të grë́tëꞌ cusë rëꞌ? Lëꞌë raiꞌ bëquebi raiꞌ: ―Aha, Dadë. Riasë́ naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Iurní repi më: ―Tubi mësë shtë lëy naná bësëꞌdë shcuendë lugar catë rnibëꞌa Dios, iurë rluáꞌall stubi saꞌll, nall ziquë tubi lamë shtë hiuꞌu. Rac rgu lamë cusë cubi nu rac rgull ra cusë guahietë. Zni lëꞌë mësë rac rluáꞌall enseñansë cubi nu enseñansë antigu. ");
INSERT INTO zacNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iurë Jesús gualú guniꞌi më grë ra comparaciuni, iurní gubiꞌ më ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bëabrí më guëꞌdchi shtënë më. Ngaꞌli guzublú quëgluaꞌa më laꞌni iáduꞌu shtë rall. Nalë́ bëdzëguëëꞌ lduꞌu ra mënë nu guniꞌi rall: ―¿Callë guagsëꞌdë nguiu rëꞌ? ¿Chull bëdëꞌë tantë llni? ¿Llallë rúnëll milagrë ruꞌbë? ");
INSERT INTO zacNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nu ndëꞌë lëꞌë shini carpintërë José, nu shníꞌall María. Bë́chill Jacobo nu José, Simón nu Judas. ");
INSERT INTO zacNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nu ra zánëll también quëreldënú rall lëꞌë hiaꞌa. ¿Callë nezë guagsë́ꞌdëll grë́tëꞌ cusë rëꞌ? ");
INSERT INTO zacNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Adë bëgáꞌadiꞌi guzac mënë shtë guëꞌdchi; bë́ꞌnëdiꞌi rall cuendë de lëꞌë më. Jesús repi: ―Adë rúnëdiꞌi mënë rëspëti tubi muzë shtë Dios ladzë muzë, nilë́ por shfamílill. Stubi lugar sí, runë ra mënë rëspëti lëꞌë muzë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Adë bë́ꞌnëdiꞌi më zihani milagrë ngaꞌli purquë adë gualdídiꞌi lduꞌu rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tiempë dzë ni, Herodes guc rëy shtë Galilea. Bínill famë shtë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Iurní répill lu ra narunë sirvë lull: ―Jesús na Juan Bautista naguashtë́ ladi ra tëgulë; por ni nápëll pudërë; rúnëll milagrë ruꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Perë Herodes hia nanëll de quë antsë lë́ꞌëll gunibë́ꞌall tsa Juan lachiguiꞌbë líꞌbiꞌ con cadënë. Bëꞌnë Herodes zni por causë Herodías naná tseꞌlë bëchi Herodes. Felipe lë bë́chill. ");
INSERT INTO zacNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Zihani vueltë Juan guniꞌi lu Herodes: ―Adë nádiꞌi bien cuáꞌal tseꞌlë bë́chil ziquë tséꞌlël. ");
INSERT INTO zacNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes guc shtuꞌu quínill lëꞌë Juan perë bëdzë́bëll por ra mënë purquë casi grë mënë guniꞌi rall de quë Juan na tubi naguniꞌi shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Perë guc lë Herodes; shtsaꞌpë Herodías bëguíꞌill lu grë ra invitadë shtë Herodes. Nu bëquitë lduꞌu Herodes bëguiꞌi lliguënaꞌa ni. ");
INSERT INTO zacNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Bëꞌnë Herodes prometer con juramentu guëdë́ꞌëll cualquier cusë naguënaꞌbë lliguënaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Iurní lëꞌë lliguënaꞌa guagniꞌi lu shníꞌaiꞌ niaꞌa pë guënáꞌbëll lu Herodes. Shníꞌall bëquili guëniꞌi shtsáꞌpëll të guënáꞌbëll lu Herodes: ―Neꞌ guënéꞌel guëc Juan Bautista tsu laꞌni tubi platë. ");
INSERT INTO zacNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nalë́ gulaguë tristë lduꞌu Herodes, perë hia cumë bë́ꞌnëll jurar delantë lu ra invitadë shtë́nëll, ");
INSERT INTO zacNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","iurní gunibë́ꞌall de quë gati Juan nu guëdëꞌë ra suldadë lo quë nagunaꞌbë lliguënaꞌa. Gunibëꞌa Herodes guriuguë guëc Juan lachiguiꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Iurní beꞌdënú suldadë guëc Juan laꞌni platë; bëdëꞌë rall cuaꞌa lliguënaꞌa. Nu lë́ꞌëll bëdëꞌëin cuaꞌa shníꞌall. ");
INSERT INTO zacNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Iurní bini ra naguanaldë lëꞌë Juan; bëdchini raiꞌ ngaꞌli parë biaꞌa raiꞌ cuerpë shtë Juan parë guacaꞌchi rallin. Hia despuësë guaguëchi mënë lu Jesús de quë lëꞌë Juan guti. ");
INSERT INTO zacNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iurë lëꞌë Jesús bini naguniꞌi Herodes de lëꞌë më, bëruꞌu më ngaꞌli, sulë lëꞌë më con ra shini gusëꞌdë më. Güeꞌpi raiꞌ tubi barcu; ziaꞌa raiꞌ tubi lugar catë chu nádiꞌi. Perë iurë bini ra mënë nu guc bëꞌa rall ca ziaꞌa më, bëruꞌu rall guëꞌdchi parë ziaꞌa rall lugar ni. ");
INSERT INTO zacNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bëdchini më ruaꞌ nisë; bëruꞌu më laꞌni barcu; guná më cantidá mënë. Iurní bëgaꞌa lduꞌu më lëꞌë ra mënë nu bënëac më grë ra narac lluꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Iurë riuꞌ gueꞌlë, iurní ra shini gusëꞌdë Jesús bëdchini raiꞌ lu më nu repi raiꞌ: ―Hia guadzeꞌ. Ni tubi adë chu quëréldëdiꞌi lugar ndëꞌë. Guchi lu ra mënë të guzëá rall; tsa rall lu ra guëꞌdchi naquë́ guëlladchi. Tsasiꞌi rall nagáu rall. ");
INSERT INTO zacNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús repi: ―Rquíꞌnidiꞌi guzëá rall; gulë bëdëꞌë nagáu rall. ");
INSERT INTO zacNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lëꞌë raiꞌ repi raiꞌ: ―Adë chu nápëdiꞌi nagáu raiꞌ, niétiquë gaꞌi guetështildi con chupë mbeldë. ");
INSERT INTO zacNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús guniꞌi: ―Gulë gudeꞌenuhin ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Iurní gunibëꞌa më subë ra mënë lu guiꞌlli. Iurní gunaꞌzi më guetështildi, guëzá gaꞌi guetështildi con chupë mbeldë. Iurní gubiꞌa më lu gubeꞌe. Bëdëꞌë më graci lu Dios nu bëshullë më guetështildi. Iurní bëdëꞌë mëhin cuaꞌa ra shini gusëꞌdë më. Lëꞌë raiꞌ gudiꞌdzin cuaꞌa ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Grë́tëꞌ ra mënë gudáu rall hashtë bielë rall. Despuësë guadzë́ chiꞌbë chupë tëpë grë ra pedasë nabëꞌnë subrë. ");
INSERT INTO zacNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Grë ra naná gudáu guetështildi na rall ziquë gaꞌi mili nguiu sin adë nagábëdiꞌi ra naꞌa nilë ra llguëꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Iurní Jesús gunibëꞌa më parë guziaꞌa ra shini gusëꞌdë më laꞌni barcu parë quiblú raiꞌ lu më stubi ladë ruaꞌ nisë. Quëgniꞌi më lu ra mënë parë guzëá ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Despuësë de ni, beꞌpi Jesús lu tubi dani parë guëniꞌinú më Shtadë më. Iurë lëꞌë gueꞌlë guꞌ, Jesús zugaꞌa më lë́ꞌësë më ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Lëꞌë barcu ziazú casi guëruldë nisë. Mbë con nisë nalë́ nadushë runin parë barcu purquë mbë zeꞌdë al contrari con zihani fuersë. ");
INSERT INTO zacNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Hia zeꞌdë grëgueꞌlë; Jesús zeꞌdë guëdchíniꞌ catë ziazú raiꞌ. Ziazú më lu nisë. ");
INSERT INTO zacNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Iurë shini gusëꞌdë më guná raiꞌ rzë më lu nisë, bëdzëbë raiꞌ. Gurushtiá raiꞌ fuertë: ―Aquë tu fantasmë zeꞌdë. ");
INSERT INTO zacNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Perë lueguë guniꞌi Jesús lu raiꞌ: ―Gulë gapë valurë. Na ndëꞌë. Adë rdzë́bëdiꞌi të. ");
INSERT INTO zacNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Iurní lëꞌë Pedro repi lu Jesús: ―Dadë si talë lë́ꞌël niꞌi, gunibëꞌa të nu na sëa lu nisë parë guelda catë zul. ");
INSERT INTO zacNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús repi: ―Gudeꞌe pë. Iurní lëꞌë Pedro bietë laꞌni barcu. Guzublú rzëhiꞌ lu nisë parë tsáhiꞌ catë zugaꞌa më ");
INSERT INTO zacNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","perë iurë bëdëꞌë Pedro cuendë por tantë fuersë nanapë mbë, bëdzë́bëiꞌ nu rë́ꞌaziꞌ laꞌni nisë. Iurní guníꞌiꞌ fuertë: ―Bëlá na, Dadë. ");
INSERT INTO zacNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mizmë iurní gunaꞌzi Jesús guiaꞌa Pedro nu repi më: ―¿Pë duꞌpsë fe nápël? ¿Pëzielú adë rialdídiꞌi ldúꞌul na? ");
INSERT INTO zacNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Iurní lëꞌë raiꞌ güeꞌpi raiꞌ laꞌni barcu nu bëac dchi mbë. ");
INSERT INTO zacNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Grë ra nazúbëgaꞌa laꞌni barcu, bëzullibi raiꞌ lu Jesús nu repi raiꞌ: ―Verdá nal Shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Gudëdë raiꞌ stubi tëchi nisë. Bëdchini raiꞌ tubi regiuni nalë Genesaret. ");
INSERT INTO zacNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ra mënë shtë lugar ni bënguë bëꞌa rall lëꞌë Jesús. Bësheꞌldë rall rsunë guëdubi regiuni shtë lugar de quë bëdchini më ndë. Beꞌdënú ra mënë lu më grë́tëꞌ ra mënë narac lluꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bëꞌnë rall ruëguë lu më parë guëdëꞌë më permisi guënaꞌzi rall ruaꞌ shabë më. Grë ra nagunaꞌzi shabë më, bëac rall. ");
INSERT INTO zacNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Iurní bëldá fariseo nu ra mësë narluaꞌa lëy, guabiꞌguë rall lu Jesús. Zeꞌdë rall ciudá Jerusalén. Gunaꞌbë diꞌdzë rall: ");
INSERT INTO zacNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Pëzielú shini gusë́ꞌdël adë rúnëdiꞌi rall cumplir custumbrë shtë ra shtadë guëlú hiaꞌa? sino rau rall guetështildi sin quë riétidiꞌi guiaꞌa rall. ");
INSERT INTO zacNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Perë Jesús gunaꞌbë diꞌdzë: ―¿Pëzielú lëꞌë të también adë rzuꞌbë diáguëdiꞌi të mandamientë shtë Dios? Mejurë zianaldë të custumbrë shtë të ");
INSERT INTO zacNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","purquë Dios guniꞌi: “Gulë gapë rëspëti lu shtádël nu lu shníꞌal”. Nu guniꞌi Dios: “El quë nargué guëc shtádëll u guëc shníꞌall, napë quë zu rátill”. ");
INSERT INTO zacNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Perë lëꞌë të rniꞌi të stubi cusë. Rniꞌi të: “Si talë guëniꞌi nguiu lu shtádëll u lu shníꞌall: Gáquëdiꞌi guna compañi lëꞌë të purquë grë lo quë naniacaꞌa të de na, nahin ofrendë parë Dios”. ");
INSERT INTO zacNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Rniꞌi të cualquier nguiu narniꞌi zni, hiadë rquíꞌnidiꞌi guëdëꞌë nguiu dumí caꞌa shtádëll. Zni cagniꞌi të lasáquëdiꞌi mandamientë shtë Dios. Más tsanaldë të tëchi custumbrë shtë të. ");
INSERT INTO zacNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Na të falsë. Bien guniꞌi Isaías guahietë shcuendë të; bëquë́ꞌëiꞌ lo quë naguniꞌi Dios zdëꞌë: ");
INSERT INTO zacNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ra mënë rëꞌ rac shtuꞌu rall na nadë más con ruaꞌ rall perë lduꞌu rall nalë́ zitu zugaꞌa parë na. ");
INSERT INTO zacNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Adë rlluíꞌidiꞌi ra cusë narunë rall iurë quëhunë rall adorar na. Enseñansë shtë rall nadë más nahin tubi mandadë shtë nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iurní gunaꞌbë më ra mënë nu repi më: ―Gulë bëquë́ diaguë nu gulë tsasë́ lo quë narniaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Grë ra nariutë́ ruaꞌ nguiu, lëdë nídiꞌi rshíꞌnidiꞌi lëꞌë nguiu. Más bien lo quë narruꞌu ruaꞌ nguiu, zeꞌdin de laꞌni lduꞌu nguiu, ni sí rshiꞌnin lduꞌu nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Iurní ra shini gusëꞌdë më gunaꞌbë diꞌdzë raiꞌ lu Jesús: ―¿Pë adë nanël de quë ra fariseo bëldënú rall lë́ꞌël por diꞌdzë rëꞌ? ");
INSERT INTO zacNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Perë Jesús repi: ―Cualquier plantë nabëcabnídiꞌi Shtada, më naquëbezë gubeꞌe, guieꞌshi ni con grë shluꞌchin. ");
INSERT INTO zacNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Adë gúnëdiꞌi të meter con lëꞌë rall. Na rall ziquë ciegu nu rluaꞌa rall shtiꞌdzë rall lu los de más ciegu. Si talë tubi ciegu guësëll saꞌll, guërupë rall ldaguë rall laꞌni guëru. ");
INSERT INTO zacNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Iurní Pedro repi: ―Biadiꞌdzë lu naꞌa pë runë cuntienë comparaciuni rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús repi: ―¿Pë nu lëꞌë të adë riasë́diꞌi të? ¿Pë na të ziquë los de más mënë? ");
INSERT INTO zacNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Pë adë rac bë́ꞌadiꞌi të, grë́tëꞌ lo quë naráu mënë ziaꞌa laꞌni nguiu; despuësë rrúꞌuhin laꞌni cuerpë? ");
INSERT INTO zacNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Perë lo quë narruꞌu ruaꞌ mënë, zeꞌdë de laꞌni lduꞌu nguiu. Ni sí, rshiꞌni lëꞌë nguiu lu Dios ");
INSERT INTO zacNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","purquë laꞌni lduꞌu nguiu rruꞌu grë́tëꞌ cusë mal: mal llgabë, rguini rall saꞌll; rquënú rall saꞌll; nu napë nguiu zihani naꞌa nu napë naꞌa zihani nguiu; rbaaꞌnë rall pë shtë mënë; nu ruadiꞌdzë rall bishi; nu rniꞌi rall didzabë cuntrë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Grë ra cusë rëꞌ rshiꞌni lduꞌu nguiu, perë parë gaul sin gúnëdiꞌil cumplir ra custumbrë ziquë guíbidiꞌil guiáꞌal, lëdë nídiꞌi narshiꞌni lduꞌu nguiu lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús bëruꞌu lugar ni; ziaꞌa më parë regiuni shtë Tiro nu Sidón. ");
INSERT INTO zacNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tubi naꞌa më Cananea quëréldëll regiuni ni; bëdchíniꞌ lu Jesús nu guníꞌill fuertë: ―Dadë, llëbní David, bëgaꞌa ldúꞌul na. Lëꞌë shtsaꞌpa nanú tubi mëdzabë laꞌni ldúꞌull. Nalë́ rzac zi shtsaꞌpa. ");
INSERT INTO zacNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Perë Jesús adë bëquébidiꞌi ni tubi diꞌdzë. Iurní ra shini gusëꞌdë më bëdchini raiꞌ lu më nu bëꞌnë raiꞌ ruëguë lu më: ―Bëꞌnë lo quë narnaꞌbë naꞌa rëꞌ të guziáꞌall purquë nalë́ cagníꞌill nezë të́chaꞌa; zeꞌdë náldëll lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iurní repi Jesús: ―Dios bësheꞌldë na nadë más parë guna sirvë ra më israelitë purquë na rall ziquë lliꞌli nabëniti lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Perë lëꞌë naꞌa guabiꞌguë nu bëzullíbill lu më. Guníꞌill: ―Dadë bëꞌnë compañi na. ");
INSERT INTO zacNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús repi: ―Nádiꞌi bien guëdchisúl guetështildi shtë ra shini mënë parë gau ra mbécuꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Perë lëꞌë naꞌa guniꞌi: ―Nia Dadë, perë ra mbécuꞌnë nananú guëaꞌ mellë, rau ma pedasë narruꞌu hiaꞌldë ruaꞌ llguëꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Iurní Jesús repi: ―Nanë, llëruꞌbë na fe shtë́nël. Gaquin según rac shtúꞌul. Mizmë iurní lëꞌë shtsaꞌpë naꞌa bëac. ");
INSERT INTO zacNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús bëruꞌu ngaꞌli parë ziaꞌa më ruaꞌ nisë ruꞌbë nalë Galilea. Lueguë güeꞌpi më lu tubi lumë nu guzubë më ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Cantidá mënë bëdchini rall catë quëbezë më. Beꞌdënú rall cujë, ciegu, guꞌpë, mancu, nu cantidá ra narac lluꞌu. Bëdchininú rall lëꞌë narac lluꞌu lu Jesús. Lëꞌë më bënëac më lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nalë́ bëdzëguëëꞌ lduꞌu ra mënë iurë guná rall ra guꞌpë biadiꞌdzë rall; ra mancu bëac rall, ra cujë bëabrí guzë́ rall, ra ciegu bëabrí guná rall. Ra mënë bëꞌnë alabar Dios; guniꞌi rall llëruꞌbë na pudërë shtë Dios de Israel. ");
INSERT INTO zacNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iurní gunaꞌbë Jesús ra shini gusëꞌdë më nu repi më: ―Nalë́ rgaꞌa lduaꞌa ra mënë rëꞌ purquë hia guc tsunë dzë zeꞌdë naldë rall na. Nápëdiꞌi rall nagáu rall. Si talë guësheꞌlda lëꞌë rall lidchi rall sin quë gáudiꞌi rall, scaꞌa mbeeꞌzë rall lu nezë. ");
INSERT INTO zacNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ra shini gusëꞌdë më repi raiꞌ iurní: ―¿Perë llallë gac guëdzelë dau parë blac zihani mënë? Lugar rëꞌ ni tubi adë chu nádiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús gunaꞌbë diꞌdzë: ―¿Bëldá guetështildi napë të? Lëꞌë raiꞌ bëquebi raiꞌ: ―Gadchi guetështildi nu duꞌpë mbeldë mituꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Iurní gunibëꞌa më parë subë ra mënë lu guiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Iurní gunaꞌzi më guëzá gadchi guetështildi nu gunaꞌzi më ra mbeldë. Bëdëꞌë më graci lu Dios. Lueguë lëꞌë më bëshullë mëhin. Bëdëꞌë mëhin cuaꞌa ra shini gusëꞌdë më. Hia lëꞌë raiꞌ gudiꞌdzë raiꞌ parë ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Grë́tëꞌ ra mënë gudáu hashtë bielë rall. Despuësë gaulú gudáu raiꞌ, guadzë́ gadchi tëpë ra pedasë nabëꞌnë subrë. ");
INSERT INTO zacNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Grë ra nagudáu na ra ziquë tapë mili nguiu sin nagábëdiꞌi naꞌa nilë ra llguëꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Despuësë Jesús bëꞌnë më despedir ra mënë. Iurní guatë́ më laꞌni barcu parë ziaꞌa më regiuni nalë Magdala. ");
INSERT INTO zacNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ra fariseo nu ra saduceo bëdchini rall lu Jesús parë guëtëꞌdë rall prëbë lëꞌë më nihunë më nanádiꞌi voluntá shtë Dios. Gunaꞌbë rall guëluaꞌa më tubi milagrë con pudërë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Perë lëꞌë më bëquebi: ―Guadzeꞌ rniꞌi të: “Glli gac tubi dzë zaꞌquë purquë lu gubeꞌe nalë́ nallní rluaꞌa”. ");
INSERT INTO zacNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nu rsili rniꞌi të: “Nedzë́ gac tubi mal tiempë purquë lu gubeꞌe nallní nu rëtaꞌ shcahi”. Lëꞌë të na të falsë; runguë bëꞌa të lla rluaꞌa shcahi lu gubeꞌe perë adë ráquëdiꞌi riasë́ të sëñi shtë tiempë neꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ra mënë mal nu mënë nadë rzuꞌbë diáguëdiꞌi shtiꞌdzë Dios, rac shtuꞌu rall guëná rall tubi milagrë ruꞌbë perë adë guënádiꞌi rall lu más sëñi; niétiquë guëná rall tubi sëñi ziquë guc con Jonás, el quë nabiadiꞌdzë shtiꞌdzë Dios guahietë. Iurní bësëaꞌnëgá më lëꞌë rall. Ziaꞌa më. ");
INSERT INTO zacNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Iurní lëꞌë ra shini gusëꞌdë Jesús gudëdë raiꞌ stubi ladë ruaꞌ nisë, perë bëaꞌldë lduꞌu raiꞌ niuaꞌa raiꞌ guetështildi. ");
INSERT INTO zacNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iurní Jesús guniꞌi: ―Gulë gupë cuidadë con levadurë shtë ra fariseo nu saduceo. ");
INSERT INTO zacNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ra shini gusëꞌdë më guzublú guniꞌi lu saꞌ raiꞌ: ―Aquë por adë chu nuáꞌadiꞌi guetështildi, por ni guniꞌi më zni. ");
INSERT INTO zacNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Perë Jesús guc bëꞌa shgabë rall nu repi më: ―¿Pëzielú ruadiꞌdzë lu saꞌ të adë nuáꞌadiꞌi të guetështildi? Duꞌpsë fe napë të. ");
INSERT INTO zacNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Pë todavía runë fáltëruꞌu tsasë́ të chu nahia? ¿Pë adë rëagnádiꞌi lduꞌu të gaꞌi guetështildi nagudiꞌdza parë gaꞌi mili nguiu? ¿Bëldá tëpë bëcaꞌa të? ");
INSERT INTO zacNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Pë adë rëagnádiꞌi lduꞌu të gadchi guetështildi nagudiꞌdza gudáu parë tapë mili mënë? ¿Bëldá tëpë bëcaꞌa të? ");
INSERT INTO zacNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Pëzielú adë rac bë́ꞌadiꞌi të adë quëadíꞌdzëdiaꞌa shcuendë shtë guetështildi? Gulë gupë cuidadë levadurë shtë ra fariseo nu ra saduceo. ");
INSERT INTO zacNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Iurní guc bëꞌa ra shini gusëꞌdë më de quë Jesús adë quëgníꞌidiꞌiꞌ shcuendë levadurë, sino shcuendë enseñansë narluaꞌa ra fariseo nu saduceo. ");
INSERT INTO zacNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iurní guziaꞌa Jesús parë regiuni shtë Cesarea nanaquë́ Felipo. Iurní gunaꞌbë diꞌdzë më lu ra shini gusëꞌdë më: ―¿Chu rniꞌi ra mënë chu nahia? nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Lëꞌë raiꞌ bëquebi raiꞌ: ―Bëldá ra mënë rniꞌi rall nal Juan Bautista. Sëbëldá ra mënë rniꞌi rall nal Elías. Stubi tantë rniꞌi rall nal Jeremías u stubi naná biadiꞌdzë shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iurní repi më: ―Lëꞌë të ¿chu rniꞌi të nahia? ");
INSERT INTO zacNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedro repi iurní: ―Lë́ꞌël nal Cristo. Nal shini Dios nanabani. ");
INSERT INTO zacNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús bëquebi: ―Dichusë nal Simón shini Jonás, purquë ni tubi nguiu bëluáꞌadiꞌi lë́ꞌël chu nahia sino quë Shtada naquëbezë gubeꞌe; ni bëluáꞌaiꞌ lul chu nahia. ");
INSERT INTO zacNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Perë na rniaꞌa lul; lë́ꞌël Pedro. Subrë tubi guëꞌë ruꞌbë guna formar grupë shtë shmënë Dios naná rianaldë tëchi ldaiꞌ shtëna. Nu ni siquierë pudërë shtë galguti gúnëdiꞌi gan lu ra mënë narialdí lduꞌi na. ");
INSERT INTO zacNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Na guënehia shtiꞌdza ziquë liahi parë tsagníꞌil lu ra mënë të guëdchini mënë lu Shtada catë rnibëꞌa më. Lo quë narúnël permitir es quë hia bëꞌnë më permitirin más antsë. Nápël autoridá; guëníꞌil napë mënë libertá. Lo quë narúnël prohibë es quë hia bëꞌnë më prohibin dizdë más antsë. Guëníꞌil chu naperdunë nu chu nádiꞌi perdunë. ");
INSERT INTO zacNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Iurní guniꞌi Jesús tubldí; gunibë́ꞌaiꞌ adë chu lu guadíꞌdzëdiꞌi ra shini gusëꞌdë më na më Cristo. ");
INSERT INTO zacNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dizdë iurní Jesús guzublú quëgniꞌi më lu shini gusëꞌdë më de quë lëꞌë më napë quë guziaꞌa më Jerusalén nu de quë ra më guaniꞌsi shtë naciuni Israel nu ra jëfë shtë ra bëshuzi con ra mësë narluaꞌa lëy, guëzac zi rall lëꞌë më. Gunë rall zihani cusë cuntrë lëꞌë më. Nu repi më de quë quini rall lëꞌë më perë dzë tsunë tsashtë́ më ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Iurní lëꞌë Pedro biaꞌa lëꞌë më tubi ladë nu guzublú gudíldill lëꞌë më. Guniꞌi Pedro: ―Aquë Dadë, ni lo quiere Dios. Nunquë adë guëdchínidiꞌi të́dël cusë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Perë Jesús bëdchigrë́ lu më nu repi më lu Pedro: ―Guabsú lua, Satanás, lë́ꞌël nal ziquë guëꞌë narreldë mënë. Adë riasë́diꞌil lo quë narac shtuꞌu Dios. Rúnël llgabë ziquë mënë shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Iurní Jesús repi lu ra shini gusëꞌdë më: ―Si talë nanú tubi mënë narac shtuꞌu gáquëll shmëna, napë quë gúnëll renunci prupi vidë shtë́nëll. Napë quë gáquëll dispuestë gátill por na nu guidë náldëll na. ");
INSERT INTO zacNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","El quë nadë rac shtúꞌudiꞌi gati por na, zátill. Perë el quë naguëniti vidë shtë́niꞌ por na nu por dizaꞌquë, guëbánill parë siemprë; gac salvárëll. ");
INSERT INTO zacNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Adë pë rlluíꞌidiꞌi gunë nguiu gan grë́tëꞌ cusë lu guë́ꞌdchiliu nu despuësë guënítill vidë shtë́nëll, adë nídiꞌi fin parë lë́ꞌëll. ¿Pë ofrendë guëdëꞌë nguiu lu Dios parë gac salvárëll? ");
INSERT INTO zacNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu; guëdchinia con pudërë shtë Shtada. Guëdchinia con ra ianglë shtënë më. Iurní quilla cadë tubi nguiu según lo quë nabë́ꞌnëll. ");
INSERT INTO zacNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Guldía nabani bëldá mënë ndëꞌë; adë gátidiꞌi rall hashtë guëná rall lua; iurní napa pudërë ziquë rëy. Guëdchinia parë guënibë́ꞌahia. ");
INSERT INTO zacNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Gudëdë shuꞌpë dzë; Jesús biaꞌa më Pedro nu Jacobo nu Juan, bëchi Jacobo; ziaꞌa raiꞌ lu tubi dani catë más guiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Iurní guc cambi Jesús stubi formë delantë lu raiꞌ. Lu më rabtsëꞌë ziquë ngubidzë. Hia shabë më bëaquin naquichi como llni. ");
INSERT INTO zacNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mizmë iurní guná ra shini gusëꞌdë më lu Moisés nu Elías; quëadiꞌdzënú raiꞌ Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Iurní Pedro guniꞌi lu më: ―Dadë, bien dzu naꞌa ndëꞌë iurneꞌ. Si talë rac shtúꞌul guëdëntsaꞌu naꞌa tsunë ranchi, tubin parë lë́ꞌël, tubin parë Moisés, stubin parë Elías. ");
INSERT INTO zacNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nianá lëꞌë Pedro quëadiꞌdzë, iurní bëdchini tubi shcahi narabtsëꞌë nabësëꞌau lëꞌë raiꞌ. Laꞌni shcahi bëdchini tubi bë. Nu bini raiꞌ tubi voz narniꞌi: ―Ndëꞌë lëꞌë shinia narac shtuaꞌa. Nalë́ rquitë lduaꞌa con lë́ꞌiꞌ. Gulë bëquë́ diaguë shtíꞌdziꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iurë bini ra shini gusëꞌdë më diꞌdzë ni, bëzullibi raiꞌ hashtë bëdiaꞌa luquë́ raiꞌ lu guiuꞌu nu bëdzëbë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iurní Jesús guabiꞌguë lu raiꞌ. Bëdchiꞌbë guiaꞌa më guëc raiꞌ nu répiꞌ: ―Gulë tsasuldí; adë rdzë́bëdiꞌi të. ");
INSERT INTO zacNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Iurë lëꞌë raiꞌ gubiꞌa raiꞌ stubi vueltë, hia ni tubi chu lu gunádiꞌi raiꞌ sino sulë Jesús zugaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Iurë bietë raiꞌ lu dani, Jesús gunibëꞌa: ―Adë chu lu guadíꞌdzëdiꞌi të shcuendë lo quë naguná të hashtë iurë nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu tsashtë́hiꞌ ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Iurní gunaꞌbë diꞌdzë shini gusëꞌdë më: ―¿Pëzielú rniꞌi ra mësë shtë lëy de quë Elías napë quë guídiꞌ primërë, antsë guëdchini Cristo? ");
INSERT INTO zacNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús bëquebi: ―Verdá Elías guidë primërë. Gúniꞌ rëglë grë cusë. ");
INSERT INTO zacNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Hia bidë Elias perë ra mënë adë bënguë bë́ꞌadiꞌi rall lë́ꞌiꞌ sino quë bëꞌnënú rall lë́ꞌiꞌ lo quë naguc shtuꞌu rall. Mizmë manërë el quë nabësheꞌldë Dios lu guë́ꞌdchiliu, sac zi më lu guiaꞌa rall, gati më. ");
INSERT INTO zacNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Iurní ra shini gusëꞌdë më bëdëꞌë raiꞌ cuendë de quë Jesús quëadíꞌdziꞌ shcuendë Juan Bautista. ");
INSERT INTO zacNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Iurë bëdchini raiꞌ catë rëtaꞌ los de más mënë, iurní guabiꞌguë tubi nguiu lu Jesús nu bëzullíbill lu më. Répill: ");
INSERT INTO zacNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Dadë, bëgaꞌa ldúꞌul shinia. Ráquëll galguidzë rati zini nu rzac zill. Zihani vueltë guláguëll laꞌni guiꞌi nu guláguëll laꞌni nisë. ");
INSERT INTO zacNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na zeꞌdënúa lë́ꞌëll lu ra shini gusë́ꞌdël perë adë bë́ꞌnëdiꞌi rall gan nëac shinia. ");
INSERT INTO zacNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús guniꞌi: ―Lëꞌë të mënë narialdídiꞌi lduꞌi na, siemprë rsini të saꞌ të lu duldë. ¿Hashtë guc guëbezënúa lëꞌë të, të parë tsaldí lduꞌu të shtiꞌdza? ¿Blac tiempë guëquëreldënúa lëꞌë të, të gapë të fe? Gudeꞌenú shínil lua. ");
INSERT INTO zacNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iurní Jesús guníꞌiꞌ guëc mëdzabë ni. Nu gunibëꞌa më guëruꞌu mëdzabë laꞌni lduꞌu ngulëꞌnë. Lueguë bëac ngulëꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Despuësë de ni, ra shini gusëꞌdë më biadiꞌdzë raiꞌ lu Jesús stubi cuꞌ. Gunaꞌbë diꞌdzë raiꞌ: ―¿Pëzielú adë bë́ꞌnëdiꞌi naꞌa gan niagú naꞌa mëdzabë fier laꞌni ngulëꞌnë? ");
INSERT INTO zacNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús repi: ―Purquë lëꞌë të duꞌpsë fe napë të. Guldía rniaꞌa, si talë napë të fe masiá zucsë duꞌpë, guëniꞌi të lu dani rëꞌ: “Guabsú ngaꞌli të parë súbël stubi lugar”. Lëꞌë dani tsabsú. Zac gunë të grë cusë si talë rialdí lduꞌu të Dios.  ");
INSERT INTO zacNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Perë mëdzabë fier saꞌ ndëꞌë sulë rruꞌu rall si talë runë të ruëguë lu Dios nu si talë quëhunë të ayunë. ");
INSERT INTO zacNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mientras ziazú raiꞌ juntë regiuni shtë Galilea, Jesús guníꞌiꞌ de quë nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, gac intriéguiꞌ guiaꞌa ra mënë mal ");
INSERT INTO zacNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nu quini rall lë́ꞌiꞌ perë dzë tsunë gac resucitáriꞌ. Diꞌdzë rëꞌ nalë́ bësëdchini tristë lduꞌu ra shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iurë Jesús nu shini gusëꞌdë më bëdchini raiꞌ guëꞌdchi Capernaum, ra narunë cubrë impuestë shtë iáduꞌu guagná rall Pedro nu gunaꞌbë diꞌdzë rall lu Pedro: ―¿Gu rguilli mësë shtë të impuestë parë iáduꞌu? ");
INSERT INTO zacNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro bëquebi: ―Ahaꞌ. Iurní guatë́ bëabrí Pedro lídchiꞌ; guniꞌi Jesús primërë lu Pedro: ―¿Pë llgabë quëhúnël, Simón? ¿Chu mënë runë cubrë raiꞌ impuestë nu ra contribución caꞌa rëy shtë guë́ꞌdchiliu rëꞌ? ¿Gu rguilli ra shini rëy u rguilli ra mënë zitu nanádiꞌi shmënë rëy? ");
INSERT INTO zacNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Simón bëquebi: ―Ra më zitu rguilli rall impuestë. Jesús repi: ―Por ni ra shini rëy adë rguíllidiꞌi rall impuestë. ");
INSERT INTO zacNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Perë parë adë ldaguë llánëdiꞌi rall, gua ruaꞌ nisë. Bëtiaꞌa iagullë shtë́nël laꞌni nisë. Primërë mbeldë naná guënáꞌzil, bëshaꞌlë ruaꞌ ma. Guëdzélël tubi dumí. Gudilli impuestë por lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tiempë dzë ni ra shini gusëꞌdë më guabiꞌguë raiꞌ lu Jesús nu gunaꞌbë diꞌdzë raiꞌ: ―¿Chu gac más më ruꞌbë iurë guënibëꞌa Dios ziquë Rëy? ");
INSERT INTO zacNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iurní Jesús gunaꞌbë tubi llguëꞌnë; bëzú më llguëꞌnë guëláu de lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nu repi më: ―Guldía rniaꞌa, si talë lëꞌë të adë gúnëdiꞌi të cambi shgabë të nu gac të ziquë llguëꞌnë rëꞌ, adë gáquëdiꞌi të tsutë́ të lugar catë rnibëꞌa Dios. Napë quë gac të mënë humildë. ");
INSERT INTO zacNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nguiu namás lasac lugar catë rnibëꞌa Dios, na el quë narialdí lduꞌi na ziquë ra llguëꞌnë, adë runë llërúꞌbëdiꞌi rall. ");
INSERT INTO zacNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Si talë ra mënë gunë rall recibir tubi shmëna naná ziquë llguëꞌnë humildë, también quëhúnëll recibir na. ");
INSERT INTO zacNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Perë cualquier el quë naná guëldaguë sáhiꞌ laꞌni duldë cumë ziquë tubi mënë humildë naná rialdí lduꞌi shtiꞌdza, el quë narluaꞌa tubi më humildë mal nezë të gúnëll duldë, mejurë galdë nguiu ni tubi guichi ruꞌbë iénill, tsagrúꞌldëll lë́ꞌëll laꞌni nisëduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Prubi mënë shtë guë́ꞌdchiliu iurë zeꞌdë ocasiuni gunë rall duldë. Napë quë guëdchini tiempë guëquili mëdzabë lëꞌë mënë parë gunë rall duldë perë prubi el quë naquëgluaꞌa sáhiꞌ mal nezë. ");
INSERT INTO zacNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Por ni rniaꞌa lu të; si talë guiáꞌal u guëaꞌl rac shtuꞌu guëldaguë lë́ꞌël lu duldë, bëchuguin; bëruꞌldin zitu. Mejurë guëdchínil catë nápël vidë sin fin ziquë cujë u ziquë narunë faltë guiáꞌall u guëaꞌll quë guëdubi cuerpë tsal gabildi. Ndë nunquë rëáldëdiꞌi beꞌlë. ");
INSERT INTO zacNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Si talë slul rac shtuꞌu guëldaguë lë́ꞌël lu duldë, gulú slul, bëruꞌldin zitu. Más mejurë tsutël catë rnibëꞌa Dios tubsë slul lë́dëdiꞌi tsal gabildi con guërupë slul. ");
INSERT INTO zacNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Adë rúnëdiꞌi të desprëci tubi ziquë llguëꞌnë rëꞌ. Pues rniaꞌa lu të lu gubeꞌe, ra ianglë shtë raiꞌ siemprë napë raiꞌ entradë catë quëbezë Dios.  ");
INSERT INTO zacNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nguiu nabësheꞌldë Dios, bídiꞌ parë gúniꞌ salvar grë lo quë nabëniti. ");
INSERT INTO zacNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Pë rniꞌi lduꞌu të? si talë tubi nguiu nápëll tubi gahiuꞌa lliꞌli nu gunítill tubi lliꞌli, tsatílill lëꞌë ma. Guësáꞌnëll noventa y nueve lliꞌli lu dani parë tsatílill lliꞌli naguniti. ");
INSERT INTO zacNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Si talë guëdzélëll lëꞌë ma, runa segurë de quë guëquitë ldúꞌull por lliꞌli ni más quë ra noventa y nueve nadë gunítidiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Zni zac Shtadë të naquëbezë gubeꞌe, rac shtuꞌu më guënítidiꞌi ni tubi shmënë më naná humildë. ");
INSERT INTO zacNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Si talë bë́chil quëhúnëll mal cuntrë lë́ꞌël, guniꞌinú lë́ꞌëll, sulë lë́ꞌëll të parë gac bë́ꞌall guadë faltë nanápëll. Si talë guëdë́ꞌëll cuendë shtíꞌdzël, guëabrí ldúꞌull con Dios. Zni lë́ꞌël bë́ꞌnël compañi saꞌl të tsagláꞌguëll shnezë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Perë si talë adë rúnëdiꞌill cuendë shtíꞌdzël, iurní biaꞌa tubi testigu u chupë testigu të parë gac bëꞌa rall shcuendë ra cusë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Si talë adë rúnëdiꞌill cuendë lëꞌë ra mënë ni, iurní guchi lu grë ra nardëá laꞌni iáduꞌu faltë nanapë bë́chil. Si adë rúnëdiꞌill cuendë grupë shtë shmënë Dios, iurní bëꞌnë tratë lë́ꞌëll cumë ziquë tubi adë guënë́diꞌi Dios u ziquë tubi më mal narunë cubrë impuestë. ");
INSERT INTO zacNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Guldía rniaꞌa, grë lo quë narunë të permitir es quë hia bëꞌnë më permitirin más antsë. Napë të autoridá të guëniꞌi të napë mënë libertá. Lo quë narunë të prohibë es quë hia bëꞌnë më prohibin dizdë más antsë. Guëniꞌi të chu na perdunë nu chu nádiꞌi perdunë. ");
INSERT INTO zacNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Nu rniaꞌa lu të, si talë chupë de lëꞌë të cue të lu guë́ꞌdchiliu de acuerdë subrë lo quë naguënaꞌbë të lu Shtada naquëbezë gubeꞌe, grë́tëꞌ guëneꞌe më ");
INSERT INTO zacNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","purquë catë rdëá chupë u tsunë mënë por nombre shtë na nu rialdí lduꞌu rall na, ngaꞌli quëbezënúa lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Iurní bëdchini Pedro nu gunaꞌbë díꞌdziꞌ lu më: ―Dadë, ¿bëldá vësë guna perdunë bëcha, el quë narunë duldë cuntrë na, hashtë gadchi vueltë? ");
INSERT INTO zacNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús bëquebi: ―Guëníꞌidiaꞌa gadchi vueltë perë sino gadchi vësë setenta, bëꞌnë perdunë bë́chil. ");
INSERT INTO zacNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Lugar catë rnibëꞌa Dios nahin ziquë tubi rëy naguc shtuꞌu suldí cuendë shtë ra muzë. ");
INSERT INTO zacNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Iurë guzublú quëgnaꞌbë rëy lëꞌë ra muzë, bëdchini tubi nazeꞌbi tubi millón bëllë. ");
INSERT INTO zacNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Cumë muzë ni adë nápëdiꞌill parë quíllill, lëꞌë lamë gunibëꞌa guëtuuꞌ mënë muzë ni con tséꞌlëll nu shínill. Guëtuuꞌ rëy grë lo quë nanapë muzë parë quilli muzë lo quë nazéꞌbill. ");
INSERT INTO zacNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Iurní lëꞌë muzë bëzullíbill lu lamë nu bë́ꞌnëll ruëguë: “Dadë, gupë pacënci lëꞌë na; quilla grë́tëꞌ lo quë nazeꞌbia”. ");
INSERT INTO zacNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Lëꞌë lamë bëgaꞌa ldúꞌull muzë nu bëꞌnë lamë perdunë grë lo quë nazeꞌbi muzë. ");
INSERT INTO zacNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Perë lueguë lëꞌë muzë bëdiaꞌguëlull stubi saꞌll nazeꞌbi tubi dumí mituꞌnë. Iurní gunáꞌzill ieni saꞌll parë bëtéꞌell ieni saꞌll. Iurní répill: “Gudilli lo quë nazéꞌbil”. ");
INSERT INTO zacNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Lëꞌë prubi nguiu bëzullíbill lull nu bë́ꞌnëll ruëguë lull: “Gupë pacënci con na. Quilla grë lo quë naná zeꞌbia.” ");
INSERT INTO zacNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Perë lë́ꞌëll adë në́diꞌill sino quë bëtiáꞌall saꞌll lachiguiꞌbë hashtë quíllill lo quë nazéꞌbill. ");
INSERT INTO zacNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Iurë stubi saꞌ muzë shtë lamë gunall pë guc, iurní gulaguë tristë laꞌni lduꞌu muzë ni. Biadíꞌdzëll lu shlámëll grë lo quë nabëꞌnë primërë muzë. ");
INSERT INTO zacNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Iurní lëꞌë lamë gunibëꞌa parë gueꞌdë guëzë́ muzë lu lamë. Iurní repi lamë: “Muzë mal, na bëna perdunë grë́tëꞌ dumí nazéꞌbil purquë bë́ꞌnël ruëguë lua. ");
INSERT INTO zacNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Zni lë́ꞌël niápël pacënci con saꞌl cumë ziquë napa pacënci lë́ꞌël.” ");
INSERT INTO zacNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Iurní lëꞌë lamë bëldëll nu gunibëꞌa lamë tsa muzë lu cashtigu hashtë quíllill grë́tëꞌ lo quë nazéꞌbill. ");
INSERT INTO zacNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús gualú guniꞌi më grë́tëꞌ ndëꞌë nu guniꞌi më: ―Shtada naquëbezë gubeꞌe, gunë më ziquë rëy rëꞌ si talë cadë lëꞌë të adë gúnëdiꞌil perdunë saꞌl con guëdubinú ldúꞌul. ");
INSERT INTO zacNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Despuësë de guniꞌi Jesús grë ra diꞌdzë rëꞌ, bëruꞌu më Galilea. Bëdchini më regiuni shtë Judea nanaquë́ ladi guiaꞌa guëëꞌgu Jordán. ");
INSERT INTO zacNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Cantidá mënë guanaldë rall lëꞌë më. Ngaꞌli bënëac më zihani ra narac lluꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Iurní bëldá fariseo guabiꞌguë rall lu Jesús parë guëldaguë rall lëꞌë më tubi trampë. Gunaꞌbë diꞌdzë rall: ―¿Gu nanú mudë según lëy parë guëlë́ tseꞌlë mënë por cualquier cusë? ");
INSERT INTO zacNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Lëꞌë më bëquebi: ―¿Pë adë bíꞌldidiꞌi të Sagradas Escrituras de quë iurë nabëcueꞌshtë́ Dios guë́ꞌdchiliu, bëntsaꞌu më nguiu nu naꞌa? ");
INSERT INTO zacNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nu guniꞌi më: “Lëꞌë nguiu guësáꞌnëll shtádiꞌ nu shníꞌaiꞌ parë guëquëreldënull tséꞌlëll. Hia guërupë rall gac rall tubsë.” ");
INSERT INTO zacNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Zni hiadë nádiꞌi rall chupë sino tubsë; unidë na rall. Lo quë nabëꞌnë Dios unir, adë chu guëldë́diꞌi lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Iurní gunaꞌbë diꞌdzë rall: ―¿Pëzielú bëꞌnë Moisés permitir guëdëꞌë nguiu tubi cartë shtë divurci parë caꞌa tséꞌlëll nu guëlë́ tséꞌlëll? ");
INSERT INTO zacNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús repi: ―Purquë nalë́ naguëdchi lduꞌu të; por ni bëdëꞌë Moisés permisi parë guëlë́ tseꞌlë mënë, perë dizdë principi shtë guë́ꞌdchiliu, adë gúquëdiꞌin voluntá shtë Dios guësaꞌnë nguiu tseꞌlë nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nanú tubsë motivë parë guëlë́ tseꞌlë nguiu, sulë si talë quëhunë tséꞌlëll duldë con stubi nguiu. Perë si caꞌa mënë ni stubi naꞌa, quëhúnëll duldë adulteri. Nu el quë naguëtsëꞌa con lëꞌë naꞌa divurciadë pues nu záquëll quëhúnëll duldë adulteri. ");
INSERT INTO zacNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ra shini gusëꞌdë më guniꞌi: ―Si talë nídiꞌi permisi guëlë́ tseꞌlë nguiu, mejurë adë cáꞌadiꞌi nguiu naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús repi: ―Lë́dëdiꞌi grë mënë riasë́ nacagniaꞌa lu të, sino nadë más el quë nagunë Dios compañi parë gac bë́ꞌallin. ");
INSERT INTO zacNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nanú nguiu nádiꞌi rall completë dizdë gulë rall. Sëbëldá nguiu nádiꞌi rall completë; bëꞌnë mënë. Nanú sëbëldá mënë adë në́diꞌi guëtsëꞌa rall por prupi voluntá shtë rall të parë guadiꞌdzë rall dizaꞌquë shtë Dios lu los de más mënë. El quë nariasë́ diꞌdzë rëꞌ, gúnëll recibirin. ");
INSERT INTO zacNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Iurní bëdchininú ra mënë llguëꞌnë lu Jesús parë guëdchiꞌbë më guiaꞌa më guëc rall nu guënaꞌbë më lu Dios por lëꞌë rall. Perë ra shini gusëꞌdë më guzublú gudildi raiꞌ guëc ra nabëdchininú llguëꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Perë Jesús repi: ―Bëdëꞌë sí, guidë biꞌguë ra llguëꞌnë lua, adë guëcádiꞌi të lu ra niꞌi purquë ra mënë naná ziquë ra llguëꞌnë, tsutë́ rall catë rnibëꞌa Dios ziquë Rëy. ");
INSERT INTO zacNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Bëdchiꞌbë guiaꞌa më guëc ra llguëꞌnë; iurní ziaꞌa më stubi lugar. ");
INSERT INTO zacNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tubi sultërë guagná lëꞌë Jesús nu répill: ―Mësë zaꞌquë, ¿pë cusë zaꞌquë guna parë gapa vidë eternë? ");
INSERT INTO zacNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús repi: ―¿Pëzielú rniꞌi lua, mësë zaꞌquë? purquë ni tubi adë chu nazaꞌquë, sulë Dios. Perë si talë rac shtúꞌul gac salvárël, bëzuꞌbë diaguë grë mandamientë. ");
INSERT INTO zacNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Repi sultërë: ―¿Guadë naná ra mandamientë ni? Jesús repi: ―Adë quínidiꞌil saꞌl. Adë rquënúdiꞌil ra saꞌl. Adë cuánëdiꞌil pë shtë mënë; adë guadíꞌdzëdiꞌil bishi. ");
INSERT INTO zacNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Bëzuꞌbë diaguë shtiꞌdzë shníꞌal nu shtádël, nu guc shtuꞌu bëchi saꞌl mizmë manërë cumë ziquë rac shtúꞌul lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Lëꞌë sultërë repi: ―Bëna cumplir grë mandamientë rëꞌ dizdë nabiꞌcha. ¿Pë runë faltë? ");
INSERT INTO zacNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús guniꞌi: ―Si talë rac shtúꞌul gac tubldí shcuéndël lu Dios, bëtuuꞌ grë cusë nanápël; bëdëꞌë dumí caꞌa ra prubi, iurní gápël tesurë lu gubeꞌe. Iurní sënáldël na. ");
INSERT INTO zacNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Perë iurë lëꞌë sultërë bini diꞌdzë rëꞌ, nalë́ gulaguë tristë laꞌni ldúꞌull; ziagzëll purquë nalë́ ricu nall. ");
INSERT INTO zacNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iurní Jesús repi lu ra shini gusëꞌdë më: ―Guldía rniaꞌa, naganë tsutë́ tubi ricu lugar catë rnibëꞌa Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Rniaꞌa lu të, más sencigi tsutë́ tubi camellë ichi tubi iagullë quë tubi ricu tsutëll gubeꞌe, lu lugar catë rnibëꞌa Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iurë bini ra shini gusëꞌdë më diꞌdzë rëꞌ, nalë́ guasë́ lduꞌu raiꞌ nu bëdzëguëëꞌ lduꞌu raiꞌ. Iurní gunaꞌbë diꞌdzë lu saꞌ raiꞌ: ―¿Chúllëtiꞌi gac salvar? ");
INSERT INTO zacNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús gubiꞌa lu raiꞌ nu répiꞌ: ―Adë gúnëdiꞌi nguiu gan gunë salvar mizmë lë́ꞌiꞌ, perë Dios napë pudërë gunë më grë́tëꞌ ra cusë. ");
INSERT INTO zacNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Iurní Pedro repi: ―Dadë, lëꞌë naꞌa bësëaꞌnë naꞌa grë́tëꞌ lo quë nanapë naꞌa parë zeꞌdë naldë naꞌa lë́ꞌël. ¿Pë guëdëꞌnë naꞌa recibir? ");
INSERT INTO zacNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús repi: ―Guldía rniaꞌa, tiempë grë cusë gáquin nacubi, iurë nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu súbiꞌ lu trunë shtë́niꞌ catë quëbezë Dios, lëꞌë të nazeꞌdë naldë na cuezënú të na lu chiꞌbë chupë trunë parë gunë të juzgar ra chiꞌbë chupë grupë shtë Israel. ");
INSERT INTO zacNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Grë́tëꞌ narsëaꞌnë lídchiꞌ u bë́chiꞌ u zániꞌ u shtádiꞌ u shníꞌaiꞌ u tséꞌliꞌ u shíniꞌ u shguiuꞌu raiꞌ purquë rac shtúꞌull gáquëll shmëna, ni gúnëll recibir tubi gahiuꞌa vësë más nu gápëll vidë sin fin. ");
INSERT INTO zacNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Zihani naná más nasac entrë lu saꞌ rall, gac rall lúltimë dzë ni nu zihani naná lúltimë iurneꞌ, gac rall mënë namás nasac lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Lugar catë rnibëꞌa Dios na ziquë tubi nashtënë tubi guiuꞌu lachi nargabní. Bëruꞌu lamë tumpranë rsili parë ziatílill muzë, gunë rall dchiꞌni catë nanú hiaguë uvë. ");
INSERT INTO zacNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Primërë guagnëll muzë de quë quíllill tubi dumí denario por tubi dzë. Nu gunibë́ꞌall tsaguënë ra muzë dchiꞌni. ");
INSERT INTO zacNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Despuësë bërúꞌull rquë guëꞌë; gunall lu stubi ra muzë nazugaꞌa shquini llguëaꞌ. Adë pë quëhúnëdiꞌi rall. ");
INSERT INTO zacNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Iurní repi lamë lu mënë ni: “Gulë tsa shchiꞌnia. Quilla lëꞌë të narunë tucarë.” Iurní lëꞌë rall ziaꞌa rall. ");
INSERT INTO zacNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Lëꞌë nashtënë guiuꞌu bërúꞌull casi guëruldë dzë, nu guall rquë tsunë guadzeꞌ; mizmë zni bë́ꞌnëll con másruꞌu muzë. ");
INSERT INTO zacNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hia rquë gaꞌi guadzeꞌ guall stubi shquini llguëaꞌ. Bëdzélëll sëbëldá muzë nadë pë quëhúnëdiꞌi. Iurní repi lamë: “¿Pëzielú rëtaꞌ të ndëꞌë casi hia mërë tsaꞌa dzë? ni dchiꞌni adë quëhúnëdiꞌi të”. ");
INSERT INTO zacNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Repi rall: “Purquë ni tubi adë chu bëneꞌe dchiꞌni”. Iurní repi lamë: “Nu lëꞌë të gulë tsa shchiꞌnia; tsaguënë të dchiꞌni lu guiuꞌu. Guëguilla lëꞌë të narunë tucarë.” ");
INSERT INTO zacNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Iurë lëꞌë gueꞌlë bëdchini, lëꞌë nashtënë guiuꞌu repi lu encargadë shtë dchiꞌni: “Guagnaꞌbë grë́tëꞌ muzë të parë gallë rall. Bëdëꞌë pagu caꞌa cadë tubi rall el quë naguatë́ lu dchiꞌni rquë gaꞌi nu hashtë ra naguatë́ lu dchiꞌni tumpranë.” ");
INSERT INTO zacNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Iurní bëdchini ra naguatë́ lu dchiꞌni rquë gaꞌi guadzeꞌ; cadë tubi rall bëꞌnë rall recibir pagu completë, tubigá dumí denario. ");
INSERT INTO zacNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Despuësë bëꞌnë tucarë naguatë́ primërë; bëꞌnë rall llgabë de quë gunë rall recibir más dumí quë naguatë́ guadzeꞌ. Perë mizmë pagu bëdëꞌë lamë, lëꞌë quë lëꞌë tubigá denario. ");
INSERT INTO zacNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nagutë́ ra tumpranë iurë bëꞌnë rall recibirin, iurní guzublú bëꞌnë rall reclamë lu lamë. ");
INSERT INTO zacNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Repi rall: “Ra nabëdchini lúltimë, bëꞌnë rall dchiꞌni tubsë iurë nu gudíllil igual ziquë lëꞌë naꞌa, nu lëꞌë naꞌa bëdëꞌnë naꞌa dchiꞌni doblë; biaꞌa lduꞌu naꞌa lu ngubidzë guaꞌtë dzë”. ");
INSERT INTO zacNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Perë lëꞌë nashtënë guiuꞌu bëquebi lu tubi rall: “Amigu, adë quëhúnëdiaꞌa ni tubi cusë mal. Hia bëdë́ꞌnaꞌa tratë gáshtël tubi denario. ");
INSERT INTO zacNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Gunaꞌzi shtumil nu bëagzë́. Na rac shtuaꞌa quilla mizmë pagu caꞌa naguatë́ rquë gaꞌi ziquë narunë tucarë të. ");
INSERT INTO zacNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Napa derechë rnibë́ꞌahia shtumía; guna lo quë narac shtuaꞌa. ¿Pë nal mbidi purquë nahia nazaꞌquë?” ");
INSERT INTO zacNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Zihani mënë nalasac delantë lu saꞌ rall, gac rall lúltimë dzë ni; nu zihani mënë naná lúltimë iurneꞌ, gac rall mënë namás lasac lu Dios. Gunaꞌbë Dios zihani mënë perë duꞌpsë mënë gulë́ më parë gac rall shmënë më. ");
INSERT INTO zacNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús ziazú më nezë parë Jerusalén. Biaꞌa më ra shini gusëꞌdë më tubi cuꞌ nu repi më: ");
INSERT INTO zacNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Hia nanë́ të ziagdchíniaꞌa Jerusalén catë lëꞌë nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, gac intriéguiꞌ lu jëfë shtë ra bëshuzi nu ra mësë shtë lëy parë gunë rall condenar lë́ꞌiꞌ lu galguti. ");
INSERT INTO zacNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nu gunë rall intriegu lë́ꞌiꞌ lu guiaꞌa mënë nanádiꞌi israelitë të parë gunë rall burnë lëꞌë nguiu ni, nu guëdëꞌë rall galnë́ nu guëquëꞌë rall lë́ꞌiꞌ lu cruz, perë dzë tsunë tsashtë́hiꞌ ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Iurní guabiꞌguë shniꞌa Jacobo nu Juan lu Jesús. Na rall shini Zebedeo; bëdchini raiꞌ lu Jesús. Iurní bëzullibi naꞌa ni delantë lu Jesús parë guënáꞌbëll tubi favurë lu më. ");
INSERT INTO zacNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Gunaꞌbë diꞌdzë më: ―¿Pë rac shtúꞌul guna? Shniꞌa ra nguiu ni répill: ―Gunibëꞌa guërupë shinia subënú rall lë́ꞌël iurë guënibë́ꞌal ziquë Rëy, túbill ladë ldi shtë́nël, stúbill ladë rubësë. ");
INSERT INTO zacNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Perë Jesús bëquebi: ―Lëꞌë të adë rac bë́ꞌadiꞌi të lo quë narnaꞌbë të. ¿Zëzac zi të ziquë na? ¿Pë zac tëdë të cusë durë natëda, cusë demasiadë durë? Lëꞌë raiꞌ bëquebi: ―Zac naꞌa, Dadë. ");
INSERT INTO zacNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iurní repi më: ―Verdá gunë të sufrir demasiadë ziquë guna sufrir. Gu të mizmë vasë shtë sufrimientë; perë subë të culaꞌnia, tubi de lëꞌë të ladë ldi nu stubi ladë rubësë, adë rúnëdiꞌi tucarë guënehia sí, subë të ndë. Shtada bëꞌnë preparar lugar ni sulë parë ra narac shtuꞌu më subë rall ndë. ");
INSERT INTO zacNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Iurë lëꞌë ra stubi chiꞌi ra shini gusëꞌdë më bini lo quë nagunaꞌbë Juan nu Jacobo, bëldë́ raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Perë Jesús gunaꞌbë lëꞌë raiꞌ nu guniꞌi më: ―Lëꞌë të nanë́ të ra jëfë shtë naciuni nanádiꞌi israelitë, nalë́ nadushë rnibëꞌa rall; rdchiꞌbë rall lëy naná dushë gunë mënë cumplir ");
INSERT INTO zacNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","perë gáquëdiꞌin entrë de lëꞌë të. Al contrari, el quë narac shtuꞌu gac më ruꞌbë entrë de lëꞌë të, napë quë gúnëll sirvë lu los de más sáhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Cualquier de lëꞌë të si talë rac shtúꞌul gáquël mayurë entrë grë ra saꞌl, napë quë gáquël muzë shtë grë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu; zelda ziquë muzë shtë mënë. Zéldëdiaꞌa parë gunë mënë sirvë lua. Guënehia vidë shtëna ziquë prëci parë gac salvar zihani mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iurë lëꞌë raiꞌ ziagruꞌu raiꞌ ciudá Jericó, cantidá mënë zianaldë rall lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ngaꞌli zúbëgaꞌa chupë ciegu. Zúbëgaꞌa rall guëlladchi ruaꞌ nezë. Iurë bini ra ciegu Jesús hia zéꞌdiꞌ, guniꞌi rall fuertë: ―Dadë llëbní David, bëgaꞌa ldúꞌul lëꞌë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ra mënë guniꞌi guëc ra ciegu parë guëac dchi rall, perë lëꞌë rall más ziaglaꞌguë guniꞌi rall fuertë: ―Dadë llëbní David, bëgaꞌa ldúꞌul lëꞌë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iurní guzudchí Jesús nu gunaꞌbë më ra ciegu nu gunaꞌbë diꞌdzë më: ―¿Pë rac shtuꞌu të guna? ");
INSERT INTO zacNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Lëꞌë rall bëquebi: ―Dadë, rac shtuꞌu naꞌa guëná naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iurní Jesús bëgaꞌa lduꞌu më lëꞌë rall. Bëshá guiaꞌa më slu rall. Lueguë iurní ra ciegu guná rall llni. Bëac slu rall nu guanaldë rall lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Hia ziagdchini raiꞌ Jerusalén; bëdchini raiꞌ guëꞌdchi Betfagé. Betfagé quëhin guëlladchi tubi dani nalë Olivos. Bësheꞌldë Jesús chupë shini gusëꞌdë më ");
INSERT INTO zacNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nu repi më: ―Tsa të guëꞌdchi naná quë delantë. Ngaꞌli guëdzelë të tubi burrë quëdú con shini ma. Gulë bëshaꞌquë ma të gueꞌdënú të ma ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Si talë chu guëniꞌi lu të u guënaꞌbë díꞌdzëll lu të, guchi de quë lëꞌë Dadë rquiꞌni lëꞌë ra ma. Lueguë guëshéꞌldëll nagueꞌdënú ra ma. ");
INSERT INTO zacNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Zndë guzac parë guc cumplir lo quë nabëquëꞌë muzë shtë Dios guahietë. Guníꞌiꞌ: ");
INSERT INTO zacNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Gulë guchi lu ra mënë naquëreldë guëꞌdchi Sión: “Gulë guná, lëꞌë Rëy shtë të zeꞌdë guëdchíniꞌ. Nadúꞌuiꞌ; dchíꞌbiꞌ tëchi tubi burrë, shini tubi ma naruaꞌa carguë.” ");
INSERT INTO zacNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iurní lëꞌë shini gusëꞌdë më ziaꞌa raiꞌ; bëꞌnë raiꞌ tal cumë guniꞌi Jesús lu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Beꞌdënú raiꞌ burrë con shini ma. Iurní gudchiꞌbë raiꞌ shabë raiꞌ tëchi ma nu gudchibë Jesús tëchi ma. ");
INSERT INTO zacNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Hia ra mënë zihani gudishi rall shabë rall lu guiuꞌu parë ziazúhiꞌ lu nezë. Sëbëldá ra mënë bëchuguë rall ndiaguë shtë hiaguë parë gudishi rall ndiaguë lu nezë. ");
INSERT INTO zacNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Hia ra mënë naziaꞌa delantë también naná zeꞌdë trasë, guzublú guniꞌi rall: ―Gunë Dios salvar llëbní David. Benditë el quë nazeꞌdë guëdchini por partë shtë Dios. Rac shtuꞌu naꞌa Dios nacabezë gubeꞌe gunë më salvar llëbní David. ");
INSERT INTO zacNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iurë Jesús bëdchini Jerusalén, guëdubi ciudá bëdzatsu ra mënë. Nu grë mënë gunaꞌbë diꞌdzë rall: ―¿Chu ndëꞌë? ");
INSERT INTO zacNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ra mënë rniꞌi rall: ―Lë́hiꞌ Jesús më Nazaret shtë Galilea. Ruadíꞌdziꞌ shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Despuësë de ni, Jesús guatë́ laꞌni iáduꞌu ruꞌbë. Iurní gualdú hiaꞌldë më grë́tëꞌ mënë nartuuꞌ nu narziꞌi. Bërëꞌshë më mellë shtë ra nacagchili dumí shtë ra mënë. Bërëꞌshë më ra iagshili shtë ra naquëgtuuꞌ ra palumë. ");
INSERT INTO zacNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Iurní guniꞌi më: ―Laꞌni Sagradas Escrituras rniꞌi zndëꞌë: “Lidcha na parë gunë mënë orar lu Dios” perë lëꞌë të bëꞌnë të cambi lugar ni ziquë cuevë shtë ngubaꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mizmë laꞌni iáduꞌu guabiꞌguë ra ciegu nu ra cujë lu Jesús. Bënëac më lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Perë ra jëfë shtë ra bëshuzi nu ra mësë shtë lëy, guná rall lu milagrë naquëhunë më. Iurë lëꞌë rall bini rall lo quë naguniꞌi ra llguëꞌnë, bëldë́ rall. Fuertë guniꞌi ra llguëꞌnë laꞌni iáduꞌu: ―Gunë Dios salvar llëbní David ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bëldë́ ra bëshuzi; repi rall lu Jesús: ―¿Gu rínil lo quë naquëgniꞌi ra llguëꞌnë rëꞌ? Jesús bëquebi: ―Ahaꞌ. Rinia. ¿Pëllë adë bíꞌldidiꞌi të Sagradas Escrituras? lo quë naruadiꞌdzë zndëꞌë: Dios bë́ꞌniꞌ të ruaꞌ llguëꞌnë nu ra meꞌdë radchi guëruꞌu labansë parë Dios; nahin labansë más chulë parë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Iurní bësëaꞌnëgá më lëꞌë rall. Ziaꞌa më parë guëꞌdchi Betania. Hia ngaꞌli gudëdë gueꞌlë më. ");
INSERT INTO zacNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Hia brëgueꞌlë rsili iurní ziagdchini raiꞌ Jerusalén. Bëldiaꞌnë lduꞌu më. ");
INSERT INTO zacNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Guná më lu tubi hiaguë bëldaꞌu nazubë ruaꞌ nezë. Iurní guabiꞌguë më lu hiaguë; gáuhiꞌ tubi nashi perë adë bëdzélëdiꞌi më nashi; purë ndiaguë nuaꞌa hiaguë. Iurní Jesús repi lu hiaguë: ―Nunquë jamás adë guëabrídiꞌi quë nashi lul. Mizmë iurní lëꞌë hiaguë bëldaꞌu gubidchi. ");
INSERT INTO zacNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Iurë guná ra shini gusëꞌdë më zndëꞌë, bëdzëguëëꞌ lduꞌu raiꞌ. Guniꞌi raiꞌ: ―¿Guná, nasesë gubidchi hiaguë rëꞌ? ");
INSERT INTO zacNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús bëquebi: ―Guldía rniaꞌa lu të, si talë napë të fe nu adë rzádiꞌi lduꞌu të, lëdë niáꞌasëdiꞌi gunë të ziquë bëna con hiaguë bëldaꞌu sino guëniꞌi të lu dani: “Guabsú ndëꞌë; tsal laꞌni nisëduꞌu”. Pues zni gaquin. ");
INSERT INTO zacNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Grë́tëꞌ lo quë naguënaꞌbë të con oraciuni, si talë rialdí lduꞌu të Dios, pues gunë të recibirin. ");
INSERT INTO zacNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iurní Jesús guatë́ laꞌni iáduꞌu. Mientras quëgluaꞌa më ngaꞌli, bëdchini ra jëfë shtë ra bëshuzi con ra më gushë shtë guëꞌdchi. Gunaꞌbë diꞌdzë rall lu Jesús: ―¿Chu bësheꞌldë lë́ꞌël nu bëneꞌe derechë nu pudërë parë rúnël cusë rëꞌ? ");
INSERT INTO zacNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús bëquebi: ―Nu na runa tubi preguntë lu të. Si talë guëquebi të lua, guëniaꞌa lu të chu bëneꞌe pudërë runa grë ra cusë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Chu gunibëꞌa lëꞌë Juan parë bëchuꞌbë nísiꞌ ra mënë? ¿Pë Dios u nguiu? Iurní guzublú rall quëadiꞌdzë lu saꞌ rall; repi rall: ―Si talë guëniꞌi hiaꞌa Dios gunibëꞌa lëꞌë Juan, iurní guëquebi nguiu rëꞌ: “¿Pëzielú adë gualdídiꞌi lduꞌu të shtiꞌdzë Juan?” ");
INSERT INTO zacNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Si talë guëniꞌi hiaꞌa ra nguiu bësheꞌldë lëꞌë Juan, pues rdzë́baꞌa ra mënë purquë grë rall rialdí lduꞌu rall de quë biadiꞌdzë Juan shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Iurní repi rall lu Jesús: ―Adë rdë́ꞌëdiꞌi naꞌa cuendë chu bësheꞌldë lëꞌë Juan. Iurní lëꞌë më repi: ―Pues ni na tampuquë adë guëquébidiaꞌa chu shtë pudërë nu autoridá quëhuna ra cusë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús repi: ―¿Pë runë të shgabë të zndëꞌë? Tubi nguiu napë chupë shínill. Repi dadë lu shíniꞌ: “Llgaꞌnë, tsaguë́nël dchiꞌni shtë cusechë catë nanú hiaguë uvë”. ");
INSERT INTO zacNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Lëꞌë shini më bëquébill: “Tsaguë́nëdiaꞌa dchiꞌni”, perë despuësë bë́ꞌnëll cambi shgábëll; guaguë́ꞌnëll dchiꞌni. ");
INSERT INTO zacNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Lueguë lëꞌë dadë ni guagná lëꞌë stubi shíniꞌ; guníꞌill: “Tsaguë́nël dchiꞌni”. Nguiu ni bëquebi lu shtádiꞌ: “Ahaꞌ Dadë, tsaguëna dchiꞌni” perë adë guádiꞌill. ");
INSERT INTO zacNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Guadë de guërupë ra llguëꞌnë ni bëꞌnë lo quë naguniꞌi shtádiꞌ? Iurní repi rall: ―Lëꞌë primërë. Iurní Jesús repi: ―Guldía rniaꞌa, ra cubradurë shtë impuestë nu ra naꞌa mal, tsutë́ rall lugar catë rnibëꞌa Dios antsë de lëꞌë të ");
INSERT INTO zacNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","purquë Juan Bautista bidë guëluáꞌaiꞌ shnezë Dios lla gac salvar të, perë lëꞌë të adë gualdídiꞌi lduꞌu të shtiꞌdzë Juan. Perë en cambi ra cubradurë shtë impuestë nu ra naꞌa mal, gualdí lduꞌu rall shtíꞌdziꞌ. Lëꞌë të guná të lo quë nabëꞌnë Juan perë adë bë́ꞌnëdiꞌi të cambi mudë nanabani të; adë gualdídiꞌi lduꞌu të shtíꞌdziꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Gulë bëquë́ diaguë stubi comparaciuni. Guꞌ tubi nguiu nanapë tubi ldë guiuꞌu lachi nargabní. Bëcabnill hiaguë uvë nu bëntsáꞌull tubi luꞌ alrededurë; bëntsáꞌull catë guëruꞌu juguë shtë uvë. Bëzáꞌall tubi hiuꞌu guiaꞌa parë quëhapë ra muzë ra plantë. ’Iurní bëdëꞌë mënë ni guiuꞌu parë ra trabajadurë gunë rall dchiꞌni mëdi. Iurní ziáꞌall zitu. ");
INSERT INTO zacNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","’Iurë lëꞌë tiempë shtë cusechë bëdchini, gunibëꞌa lamë shtë guiuꞌu bëldá muzë parë tsaglliꞌi rall mëdi narunë tucarë caꞌa lamë. ");
INSERT INTO zacNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ra trabajadurë gunaꞌzi rall lëꞌë ra muzë ni; tubi muzë bëdëꞌë rall galnë́. Stubi muzë gudini rall. Stubi muzë bëdëꞌë guëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Iurní lëꞌë nashtënë guiuꞌu bëshéꞌldëll másruꞌu muzë perë ra trabajadurë bëꞌnë rall tratë muzë ni mizmë manërë. ");
INSERT INTO zacNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Por fin gunibëꞌa nashtënë guiuꞌu tsa llgáꞌniꞌ. Bëꞌnë shgábiꞌ: “Zunë rall rëspëti shinia”. ");
INSERT INTO zacNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Perë iurë guná trabajadurë lu shini nashtënë guiuꞌu, repi rall: “Ndëꞌë na el quë nagunë recibir herenci. Cha guëdíniaꞌa lë́ꞌëll të parë guëaꞌnë guiuꞌu rëꞌ caꞌa hiaꞌa.” ");
INSERT INTO zacNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Zni gunaꞌzi rall llgáꞌnëll. Gulú hiaꞌldë rall shini lamë lu guiuꞌu nu gudini rall shini lamë. ");
INSERT INTO zacNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Iurní Jesús gunaꞌbë diꞌdzë: ―Iurë lëꞌë nashtënë guiuꞌu gueꞌdë guëzë́, ¿pë gúnëll con ra trabajadurë iurní? ");
INSERT INTO zacNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bëquebi rall: ―Pues gati ra muzë mal sin adë chu guëgáꞌadiꞌi lduꞌu lëꞌë rall. Iurní caꞌa stubi mënë guiuꞌu të parë gúnëll intriegu ra cusechë cadë izë. ");
INSERT INTO zacNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iurní Jesús repi: ―¿Pë nunquë bíꞌldidiꞌi të ra Escrituras narniꞌi zndëꞌë? Guëꞌë nabëruꞌldë albañil tubi ladë, guëꞌë rëꞌ gunë sirvë parë shquini hiuꞌu. Zni bëꞌnë më, el quë narnibëꞌa lëꞌë hiaꞌa. Guná hiaꞌa pudërë shtë më; nalë́ nasaꞌa nahin. ");
INSERT INTO zacNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Por ni rniaꞌa lu të, Dios adë guënéꞌediꞌi lugar tsutë́ të catë rnibëꞌa më. Lo quë nanapë të, guësheꞌldë mëhin hashtë stubi mënë naná ziquë trabajadurë zaꞌquë nabëdëꞌë cusechë narunë tucarë nashtënë guiuꞌu.  ");
INSERT INTO zacNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","El quë narreldë guëc guëꞌë rëꞌ, gac chupë ldëll perë iurë ldaguë guëꞌë ni guëc mënë, gáquëll ziquë pulvë. ");
INSERT INTO zacNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Iurë lëꞌë ra jëfë shtë ra bëshuzi con ra fariseo bini rall grë comparaciuni lo quë naguniꞌi Jesús, bëdëꞌë rall cuendë de quë quëadiꞌdzë më shcuendë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Iurní guc shtuꞌu rall guënaꞌzi rall lëꞌë më prësi perë bëdzëbë rall los de más mënë purquë guniꞌi mënë na Jesús tubi profetë narniꞌi shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús guzublú quëadiꞌdzë më stubi por comparaciuni. Repi më: ");
INSERT INTO zacNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Lëꞌë lugar catë rnibëꞌa Dios, na ziquë tubi rëy nabëꞌnë tubi laní shtë saꞌa parë shíniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Gunibëꞌa rëy ni ra muzë parë tsagnaꞌbë raiꞌ ra invitadë lu saꞌa, perë adë në́diꞌi ra mënë niagdchini rall lu saꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Iurní gunaꞌbë rëy stubi shcuaꞌa muzë. Guniꞌi rëy: “Gulë guniꞌi lu ra invitadë hia napreparadë dau; hia ngunë nandchú con los de más ra ma hia guꞌi; grë́tëꞌ nahin listë. Nadë más guëdchini rall parë cuezë rall lu saꞌa.” ");
INSERT INTO zacNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Perë ra invitadë adë bë́ꞌnëdiꞌi rall cuendë. Tubi de lëꞌë rall guagnall lu shguiúꞌull. Stubi guagnall ra neguci shtë́nëll. ");
INSERT INTO zacNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Hia stubi ra invitadë gunaꞌzi rall muzë shtë rëy; bëꞌnë rall maltratë muzë ni hashtë gudini rall lëꞌë muzë. ");
INSERT INTO zacNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Iurní lëꞌë rëy bëldëll. Gunibë́ꞌall ra suldadë parë tsatini rall lëꞌë narguini mënë. Nu tsa quëguiꞌi ra suldadë guëꞌdchi ni. ");
INSERT INTO zacNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Lueguë repi rëy lu muzë stubi: “Hia grë na listë parë saꞌa; perë ra invitadë bëluaꞌa rall de quë adë rúnëdiꞌi tucarë rall invitación shtëna. ");
INSERT INTO zacNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Gulë tsa iurneꞌ ra nezë principal. Gulë bëꞌnë invitar lëꞌë mënë lu saꞌa, grë ra naguëdiaꞌguëlú të; tsutë́ rall.” ");
INSERT INTO zacNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Iurní bëruꞌu ra muzë nezë; guagtëá rall grë́tëꞌ lo quë nabëdiaꞌguëlú rall, tantë hiumbrë mal nu nguiu zaꞌquë. Iurní sí, guadzë́ hiuꞌu catë na preparadë parë saꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Iurní rëy guatë́ catë nanú ra mënë. Guná rëy lu tubi nguiu naquëbezë ngaꞌli, perë adë nuáꞌadiꞌill lari shtë saꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Repi rëy: “Amigu, ¿lla guatël ndëꞌë sin adë nuáꞌadiꞌil lari shtë saꞌa cumë ziquë na custumbrë?” Perë nguiu ni adë pë guníꞌidiꞌill. ");
INSERT INTO zacNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Iurní lëꞌë rëy repi lu naquëhunë sirvë lu mellë: “Gulë bëldiꞌbi guëaꞌll nu guiaꞌa nguiu rëꞌ. Gulë bëtiaꞌa lë́ꞌëll parë lu nacahi catë guꞌnë mënë nu hashtë guëchushí laiꞌ rall.” ");
INSERT INTO zacNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Rniaꞌa lu të, zihani mënë guënaꞌbë Dios parë tsutë́ rall catë rnibëꞌa më, perë duꞌpsë mënë gulë́ më parë gac rall shmënë më. ");
INSERT INTO zacNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Iurní ra fariseo ziaꞌa rall parë gurë́ rall de acuerdë lla tsu mudë guësiguë́ rall lëꞌë më të niniꞌi më cusë mal. ");
INSERT INTO zacNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nu bësheꞌldë rall partidë shtë rall con stubi partidë shtë Herodes parë tsaguëchi rall lu Jesús: ―Mësë rdëꞌë naꞌa cuendë de quë lë́ꞌël rníꞌil verdá nu rluáꞌal nezë shtë Dios sin adë rúnëdiꞌil cuendë lo quë narniꞌi mënë. Adë rúnëdiꞌil juzguë según el quë narná mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Guniꞌi lu naꞌa ¿pë na bien según lëy guëdílliaꞌa impuestë lu rëy César, u guëdíllidiꞌiaꞌa impuestë? ");
INSERT INTO zacNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Perë Jesús bëdëꞌë cuendë de quë cabezënú rall mal llgabë. Repi më lu rall: ―Na të falsë. ¿Pëzielú zeꞌdë guësiguë́ të na? ");
INSERT INTO zacNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gulë bëluaꞌa dumí denario naquilli të impuestë. Iurní beꞌdënú rall tubi monedë. ");
INSERT INTO zacNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Guná Jesús lu monedë; iurní gunaꞌbë diꞌdzë më: ―¿Chu lu nu chu lë naquë́ lu dumí rëꞌ? ");
INSERT INTO zacNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bëquebi rall: ―Lu rëy César naquë́ lu dumí. Iurní Jesús repi: ―Gulë bëdëꞌë nacaꞌa César lo quë naná shtë César nu gulë bëdëꞌë nacaꞌa Dios lo quë naná shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iurë bini rall ra diꞌdzë rëꞌ, bëaꞌnë dchi rall nu guasë́ lduꞌu rall. Iurní bësëaꞌnëgá rall lëꞌë më; ziaꞌa rall. ");
INSERT INTO zacNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mizmë dzë ni bëldá ra saduceo guagná rall lëꞌë Jesús. Ra saduceo rniꞌi de quë adë tsashtë́diꞌi ra tëgulë. Gunaꞌbë diꞌdzë rall lu më: ");
INSERT INTO zacNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Mësë, bëquëꞌë Moisés guahietë si tubi nguiu gátiꞌ sin shíniꞌ, bëchi tëgulë napë quë cáꞌall tseꞌlë tëgulë të gapë raiꞌ shini parë adë tsalúdiꞌi shfamili tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Guc gadchi bëchi; primërë nguiu bëtsë́ꞌall perë gútill sin ni tubi shíniꞌ. Bësëáꞌnëll viudë parë segundë bë́chill. ");
INSERT INTO zacNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Segundë bëchi tëgulë cuáꞌall lëꞌë viudë perë gútill sin ni tubi shíniꞌ. Na tsunë lo mizmë; cuáꞌall tseꞌlë tëgulë perë gútill sin ni tubi shíniꞌ. Guëzá bëchi tëgulë cuaꞌa rall lëꞌë naꞌa ni perë adë gúpëdiꞌi raiꞌ shíniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Despuësë lëꞌë naꞌa ni gútiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Iurë tsashtë́ ra tëgulë ¿chu gac tseꞌlë naꞌa ni? pues gadchi nguiu guc tseꞌlë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús bëquebi: ―Bëganë të con diꞌdzë shtë të purquë adë riasë́diꞌi të lo quë narniꞌi Sagradas Escrituras; nu adë guënë́diꞌi të pudërë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Iurë ra tëgulë tsashtë́ raiꞌ stubi, adë guëtsë́ꞌadiꞌi raiꞌ; adë rnádiꞌi raiꞌ guëtsëꞌa shini raiꞌ. Na raiꞌ ziquë ianglë shtë Dios nacabezë gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Perë shcuendë tsashtë́ ra tëgulë ¿pë adë bíꞌldidiꞌi të lo quë narniꞌi Dios? Guniꞌi më zndëꞌë: ");
INSERT INTO zacNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nahia Dios shtë Abraham; nahia Dios shtë Isaac; nu Dios shtë Jacob”. Grë shmënë Dios nabani raiꞌ aunquë hia guti raiꞌ. Napë raiꞌ vidë sin fin. Perë lëꞌë më adë nádiꞌi Dios parë el quë nanápëdiꞌi vidë sin fin. ");
INSERT INTO zacNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Iurë bini mënë zndëꞌë, nalë́ bëdzëguëëꞌ lduꞌu rall nu guasë́ lduꞌu rall lo quë naquëgluaꞌa më. ");
INSERT INTO zacNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Iurë ra fariseo guc bëꞌa rall de quë Jesús bësëac dchi më ra saduceo, iurní bëdëá rall. ");
INSERT INTO zacNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tubi de lëꞌë rall na mësë shtë lëy. Guc shtúꞌull ldaguë më lu trampë; gunaꞌbë díꞌdzëll: ");
INSERT INTO zacNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Mësë, ¿guadë mandamientë namás lasac de grë mandamientë? ");
INSERT INTO zacNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús repi: ―“Gulë guc shtuꞌu Dadë Dios con guëdubinú ldúꞌul nu guëdubi almë shtë́nël nu guëdubi shgábël”. ");
INSERT INTO zacNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ndëꞌë namás lasac nu nahin primërë mandamientë lu grë mandamientë. ");
INSERT INTO zacNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Hia nachupë na cumë ziquë primërë. Rniꞌin: “Gulë guc shtuꞌu saꞌl cumë ziquë rac shtúꞌul mizmë lë́ꞌël”. ");
INSERT INTO zacNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Si talë rzuꞌbë diaguë të mandamientë rëꞌ también canihunë të cumplir lo de más nabëquëꞌë Moisés nu lo quë nabëquëꞌë ra muzë shtë Dios guahietë. ");
INSERT INTO zacNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mientras lëꞌë ra fariseo nianá rëtaꞌ rall lu Jesús, ");
INSERT INTO zacNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","lëꞌë më gunaꞌbë diꞌdzë: ―¿Pë runë të shgabë të? ¿Chu na Cristo? ¿Chu shini lëꞌë më? Iurní repi rall: ―Llëbní David. ");
INSERT INTO zacNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Iurní gunaꞌbë diꞌdzë Jesús: ―Espíritu Santo quëbezënúhiꞌ lëꞌë David nu por pudërë shtë Espíritu Santo guniꞌi David shcuendë llëbní David: ");
INSERT INTO zacNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dadë Dios guniꞌi lu lamë shtëna, el quë narnibëꞌa na: “Guzubë ladë ldi shtëna hashtë guna gan lu enemigu shtë́nël të guëzuꞌbë diaguë rall shtíꞌdzël”. ");
INSERT INTO zacNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Lla na posiblë gac Cristo shini David cumë David guniꞌi Cristo na Dadë narnibëꞌa lëꞌë David? ");
INSERT INTO zacNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Iurní ni tubi rall gúquëdiꞌi niaquebi rall lu më. Dizdë dzë ni hia ni tubi rall adë gúpëdiꞌi rall valurë nianaꞌbë diꞌdzë rall lu më. ");
INSERT INTO zacNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Iurní guniꞌi Jesús lu ra mënë nu lu ra shini gusëꞌdë më: ");
INSERT INTO zacNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Ra mësë shtë lëy nu ra fariseo rzubë rall shlugar Moisés iurë rluaꞌa rall ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Gulë bëzuꞌbë diaguë shtiꞌdzë rall. Gulë bëꞌnë grë́tëꞌ lo quë narniꞌi rall perë adë tsanáldëdiꞌi të tëchi manërë nanabani rall. Bien rniꞌi rall perë adë rúnëdiꞌi rall cumplir. ");
INSERT INTO zacNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bien rluaꞌa rall lëy shtë Dios perë ra cusë naquëhunë rall obligar gunë mënë, na ziquë tubi carguë nëꞌë; adë chu típëdiꞌi guëldisin. Rnibëꞌa rall mënë të parë guaꞌa ra mënë carguë ni, perë lëꞌë rall ni siquierë más zucsë tubi shcuënë rall guëldisë rallin. ");
INSERT INTO zacNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Grë́tëꞌ devociuni narunë rall quëhunë rallin të guëná mënë. Luquë́ rall nu ruaꞌ llicu rall nuaꞌa rall partë diꞌdzë shtë Sagradas Escrituras të guëná mënë devociuni narunë rall. Chulë zutsaꞌu lu shabë duni shtë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nu rac shtuꞌu rall subë rall lugar más lasac catë rau mënë shtse nu catë zubë më ruꞌbë laꞌni iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nu rac shtuꞌu rall grë mënë gunë saludar lëꞌë rall con zihani rëspëti iurë lëꞌë rall ziazú rall nezë. Rac shtuꞌu rall gunë mënë saludar lëꞌë rall con diꞌdzë rëꞌ: “Mësë”. ");
INSERT INTO zacNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Perë lëꞌë të adë rúnëdiꞌi të ziquë lëꞌë mënë ni. Adë rac shtúꞌudiꞌi të guëniꞌi mënë na të mësë, purquë napë të tubsë mësë; náhiꞌ Cristo. Grë të na të bëchi la saꞌ të. ");
INSERT INTO zacNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Adë rníꞌidiꞌi të lu tubi saꞌ të: “Dadë” parë lu guë́ꞌdchiliu rëꞌ, purquë nanú tubsë Shtadë të, më naquëbezë gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nu adë rníꞌidiꞌi të: “Lamë” lu saꞌ të, purquë Jesucristo náhiꞌ lúniquë lamë nanapë të. ");
INSERT INTO zacNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mënë narunë sirvë parë los de más saꞌ hiaꞌa, ni más më ruꞌbë entrë lëꞌë të ");
INSERT INTO zacNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","purquë grë́tëꞌ narunë naruꞌbë, gac nasáquëdiꞌi rall. El quë narunë lasáquëdiꞌi, ni nasac iurní. ");
INSERT INTO zacNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Prubi të mësë shtë lëy nu fariseo, na të mënë falsë purquë rtaꞌu të ruaꞌ nezë shtë Dios të parë adë chu tsutë́diꞌi, nu nilë mizmë lëꞌë të adë në́diꞌi të tsutë́ të. Nu adë rdë́ꞌëdiꞌi të lugar parë grë narac shtuꞌu tsutë́ nezë zaꞌquë.  ");
INSERT INTO zacNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Prubi de lëꞌë të mësë shtë lëy nu fariseo; na të mënë falsë purquë rdchisú të lidchi ra viudë; iurní parë guësiguë́ të ra mënë, runë të orar zihani vueltë. Lëꞌë të gunë të recibir más cashtigu dushë. ");
INSERT INTO zacNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Prubi de lëꞌë të mësë shtë lëy nu fariseo; na të falsë. Ria të stubi guëꞌdchi namás zitu parë tsagtëꞌtsë të shldaiꞌ të lu ra mënë, perë iurë lëꞌë të runë të gan tubi shmënë të, nall chupë vueltë más shini gabildi quë lëꞌë të purquë riuguëll bishi shtë të. ");
INSERT INTO zacNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Prubi de lëꞌë të, na të ziquë mësë ciegu. Rniꞌi të si talë quëhunë mënë jurar por iáduꞌu ruꞌbë, pues adë rúnëdiꞌi obligar gunë mënë cumplirin, perë si talë runë mënë jurar por orë shtë iáduꞌu, ni sí, runë mënë comprumisi; napë quë gunë mënë cumplirin. Zni cagniꞌi të. ");
INSERT INTO zacNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tuntë nu ciegu na të. ¿Pë más lasac orë u lëꞌë iáduꞌu? Iáduꞌu nu orë na santu. ");
INSERT INTO zacNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nu también cagluaꞌa të si talë chu runë jurar por bëcuꞌguë laꞌni iáduꞌu, adë rúnëdiꞌi obligar gunë mënë cumplir juramentu ni, perë rniꞌi të si talë runë mënë jurar por ofrendë nadchiꞌbë lu bëcuꞌguë, ni sí, napë quë gúnëll cumplir. ");
INSERT INTO zacNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tuntë nu ciegu ¿pë más lasac ofrendë nadchiꞌbë lu bëcuꞌguë u lëꞌë bëcuꞌguë nabëdëꞌë Dios ziquë lugar santu? ");
INSERT INTO zacNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pues rniaꞌa lu të, el quë narunë jurar por bëcuꞌguë, adë quëhúnëdiꞌill jurar por bëcuꞌguë sulamëntë perë también por grë ofrendë nadchiꞌbë lu bëcuꞌguë. ");
INSERT INTO zacNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","El quë narunë jurar por iáduꞌu, adë quëhúnëdiꞌill jurar sulamëntë por iáduꞌu sino quë también por lëꞌë Dios nacabezë laꞌni iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","También el quë narunë jurar por gubeꞌe, quëhúniꞌ jurar por trunë shtë Dios nu por mizmë Dios narnibëꞌa lugar ni. ");
INSERT INTO zacNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Prubi de lëꞌë të mësë shtë lëy nu fariseo; na të falsë. Lëꞌë të rdëꞌë të ofrendë narunë tucarë Dios, cadë chiꞌi ra cusë rdëꞌë të tubi parë Dios. Correctë nahin; perë adë rúnëdiꞌi të cuendë ra enseñansë más lasac shtënë më. Adë rúnëdiꞌi të cumplir; adë rgáꞌadiꞌi lduꞌu të saꞌ të. Nádiꞌi të justë. Adë rúnëdiꞌi të cumplir shtiꞌdzë të. Cagniaꞌa lu të, rquiꞌni gunë mieti cumplir grë mandamientë ruꞌbë nu también los de más mandamientë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Lëꞌë të na të ziquë mësë ciegu; rdchiꞌbi të vini parë guëruꞌu rëshë antsë gul vini, perë adë rdë́ꞌëdiꞌi të cuendë de quë nanú tubi ma ruꞌbë ziquë camellë guti nagaꞌa laꞌni vini. ");
INSERT INTO zacNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Prubi de lëꞌë të mësë shtë lëy nu ra fariseo; na të falsë. Zunë́ të por fuërë vasë nu ra platë perë nezë laꞌni, nalë́ suci nahin. Zni na të; na të ngubaꞌnë nu quëhunë të cumplir deseo mal. ");
INSERT INTO zacNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseo ciegu, primërë gulë bëzunë́ nezë laꞌni lduꞌu të, iurní napë të conductë zaꞌquë. Iurní na të ziquë vasë narieꞌti guëdubi partë. ");
INSERT INTO zacNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Prubi de lëꞌë të mësë shtë lëy nu fariseo; na të falsë. Na të ziquë baꞌa. Nalë́ cusë zaꞌquë naquichi rluaꞌa fuërë nu chulë rluaꞌain, perë nezë laꞌni gadzë́ ra baꞌcu shtë tëgulë nu grë cusë ziquë narruꞌldë mënë ruaꞌ guëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Zni na të, lëꞌë të; por fuërë rluaꞌa të cusë zaꞌquë. Lu ra mënë rluaꞌa të bien, perë nezë laꞌni të nalë́ gadzë́ ra bishi nu adë quëhúnëdiꞌi të cumplir lëy shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Prubi de lëꞌë të mësë shtë lëy nu fariseo; na të falsë; rzaꞌa të capillë shtë nabiadiꞌdzë shtiꞌdzë Dios guahietë, nu rzutsaꞌu të ruaꞌ baꞌa shtë ra mënë naguc më zaꞌquë lu guë́ꞌdchiliu con guëꞌë iarë. ");
INSERT INTO zacNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Iurní lueguë rniꞌi të: “Si talë lëꞌë naꞌa niaquëreldë naꞌa tiempë shtë ra shtadë guëlú naꞌa, adë chu nihúnëdiꞌi compañi ra nagudini ra profetë”. ");
INSERT INTO zacNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Por mizmë diꞌdzë shtënë të quëgniꞌi të na të llëbní shtë ra nagudini ra profetë. Na të testigu cuntrë mizmë lëꞌë të; na të tubsë rënë con shtadë guëlú të. ");
INSERT INTO zacNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Gulë bëꞌnë cumplir lo quë narac shtuꞌu të, maldá nananú laꞌni lduꞌu të ziquë bëꞌnë shtadë guëlú të con ra muzë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Serpientë, llëbní mbeꞌldë, ¿llallë gunë të parë guëcaꞌchilú të lu cashtigu shtë gabildi? ");
INSERT INTO zacNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Casheꞌlda mënë zaꞌquë naruadiꞌdzë shtiꞌdza, perë lëꞌë të quini të sëbëldá raiꞌ. Nu gunë të crucificar lëꞌë raiꞌ. Sëbëldá raiꞌ guëdëꞌë të galnë́ laꞌni iáduꞌu shtë të nu sunaldë të lëꞌë raiꞌ guëꞌdchi por guëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Zni na të culpablë. Ldaguë cashtigu guëc të por grë duldë nabëꞌnë mënë guahietë iurë gudini rall Abel hashtë tiempë gudini mënë Zacarías, shini Berequías. Gudini të lë́ꞌiꞌ entrë bëcuꞌguë nu iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Guldía rniaꞌa lu të, culpë shtë grë mënë ni ldaguë subrë guëc ra mënë naquëreldë lu guë́ꞌdchiliu iurneꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Mënë shtë Jerusalén, lëꞌë të rguini të ra nabiadiꞌdzë shtiꞌdzë Dios; rdëꞌë guëꞌë të grë ra nazeꞌdënú dizaꞌquë shtë më. Zihani vueltë guc shtuaꞌa niatëahia lëꞌë të cumë ziquë tubi guidi rguëdchi ra guidi meꞌdë, perë adë në́diꞌi të guëdchini të lua. ");
INSERT INTO zacNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Gulë guná, lëꞌë të con lidchi të guëaꞌnë ziquë tubi hiuꞌu dachi; adë chu gúnëdiꞌi compañi lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Rniaꞌa lu të, hiadë guëabrídiꞌi guëná të lua hashtë guëdchini tiempë iurë lëꞌë të guëniꞌi të: “Benditë na el quë nazeꞌdë guëdchini por nombre shtë Dios. Bëꞌnë ldaiꞌ më lë́ꞌiꞌ.” ");
INSERT INTO zacNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Bëruꞌu Jesús iáduꞌu. Iurë zëagzë́ më, ra shini gusëꞌdë më guabiꞌguë raiꞌ lu më nu guzublú bëluaꞌa raiꞌ ra guëꞌë ruꞌbë shtë iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús bëquebi: ―¿Gu rna të lu grë́tëꞌ ra cusë rëꞌ? Guldía rniaꞌa lu të, lugar rëꞌ ni tubi guëꞌë adë guëáꞌnëdiꞌi guëc saꞌ guëꞌë. Grë́tëꞌ tsaluhin. ");
INSERT INTO zacNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iurní ziaꞌa raiꞌ lu dani shtë Olivos. Jesús guzubë ngaꞌli. Iurní ra shini gusëꞌdë më guagniꞌi lu më guitsë guitsë: ―Rac shtuꞌu naꞌa guëníꞌil lu naꞌa, guc gac grë ra cusë naquëgníꞌil. ¿Guadë naná sëñi shtë tiempë naguëabril stubi? ¿Guc gac fin shtë guë́ꞌdchiliu? ");
INSERT INTO zacNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iurní Jesús repi: ―Gulë gapë cuidadë ni tubi adë chu cuguë́diꞌi lëꞌë të ");
INSERT INTO zacNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","purquë cantidá mënë guëdchini rall; guëniꞌi rall: “Na nahia Cristo”, nu guëguguë́ rall cantidá mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nu lëꞌë të guini të nutici shtë ra guërru nazeꞌdë guëllaꞌ nezë rëꞌ nu zitu, perë adë rdzë́bëdiꞌi të purquë zni napë quë gac. Perë todavía lë́dëdiꞌi fin shtë guë́ꞌdchiliu ");
INSERT INTO zacNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","purquë tubi naciuni tildinú stubi naciuni; tubi guëꞌdchi tildinú stubi guëꞌdchi. Nu guidë ra gubini, galguidzë, nu guëllú zihani lugar. ");
INSERT INTO zacNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Con cusë ni na principi shtë cusë durë nazeꞌdë. ");
INSERT INTO zacNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Iurní gunë ra mënë intriegu lëꞌë të parë gunë rall mal tratë lëꞌë të nu hashtë quini rall lëꞌë të. Nu grë́tëꞌ mënë shtë guë́ꞌdchiliu, guëná záꞌquëdiꞌi rall lu të purquë na të shmëna. ");
INSERT INTO zacNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tiempë dzë ni cantidá mënë guëniti rall fe shtë rall. Lëꞌë rall guëná záꞌquëdiꞌi rall lu saꞌ rall. Nu gunë rall traicionar saꞌ rall. ");
INSERT INTO zacNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Guëdchini cantidá naguëguguë́ lëꞌë ra mënë. Guëniꞌi rall de quë ruadiꞌdzë rall shtiꞌdzë Dios. Cantidá mënë guëguguë́ rall. ");
INSERT INTO zacNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Zihani cusë mal tsadalë, por ni cantidá mënë hiadë gac shtúꞌudiꞌi rall saꞌ rall ");
INSERT INTO zacNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","perë grë́tëꞌ el quë nagac firmë hashtë fin, ni gac salvar. ");
INSERT INTO zacNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Lëꞌë dizaꞌquë narniꞌi shcuendë lugar catë rnibëꞌa Dios, napë quë gac predicarin guëdubi guë́ꞌdchiliu. Guadiꞌdzë mënë dizaꞌquë parë grë́tëꞌ naciuni parë gunguë bëꞌa mënë lëꞌë më. Iurní guëgaꞌa iurë shtë fin. ");
INSERT INTO zacNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Lëꞌë muzë shtë Dios nabërulë́ Daniel, bëquë́ꞌëiꞌ lla na tiempë natsutë́ cusë mal iáduꞌu ruꞌbë. Iurë lëꞌë të guëná të lu cusë narunë manchar iáduꞌu santu, lëꞌë iurë bëgaꞌa; guëlladchi na fin shtë guë́ꞌdchiliu. El quë naquëhuꞌldë shtiꞌdza, gulë tsasë́ lo quë narniaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","El quë narëtaꞌ guëꞌdchi Judea iurní, guëlluꞌnë rall parë dani. ");
INSERT INTO zacNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Grë el quë nazubë guëc hiuꞌu lídchiꞌ, adë gáquëdiꞌi tsaldú rall pë shtënë rall laꞌni hiuꞌu; mejurë guëlluꞌnë rall lueguë. ");
INSERT INTO zacNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Grë el quë nananú lachi iurní, adë gáquëdiꞌi guëabrí rall parë tsaglliꞌi rall shabë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Prubi ra naꞌa tiempë dzë ni, grë ra naꞌa nanuaꞌa shíniꞌ u grë ra narcaꞌa meꞌdë. ");
INSERT INTO zacNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gulë gunaꞌbë lu Dios të gáquëdiꞌi ra cusë durë tiempë naldë, nilë por dzë narziꞌi lduꞌu mënë ");
INSERT INTO zacNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","purquë tiempë ni gac suceder cusë demasiadë durë nanadë gunádiꞌi mënë dizdë principi shtë guë́ꞌdchiliu, nu nunquë jamás gáquëdiꞌi saꞌ ra cusë ni. ");
INSERT INTO zacNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Si talë adë bë́ꞌnëdiꞌi Dios menos ra dzë shtë sufrimientë, adë chu nádiꞌi gac salvar perë por ra mënë nagulë́ Dios, gac menos ra dzë ni. ");
INSERT INTO zacNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Si talë guëniꞌi tubi nguiu lu të: “Gulë guná, ndëꞌë lëꞌë Jesucristo”, u “Gulë tsagná ndë; lëꞌë më nanú”, adë tsaldídiꞌi lduꞌu të shtiꞌdzë mënë ni. ");
INSERT INTO zacNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Guëdchini ra naguëguguë́ lëꞌë mënë. Guëniꞌi rall na rall Cristo. Sëbëldá rall guëniꞌi rall na rall naruadiꞌdzë shtiꞌdzë Dios. Gunë rall sëñi ruꞌbë nu milagrë parë guëguguë́ rall mënë hashtë si na posiblë guëguguë́ rall ra nagulë́ Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Hia guniaꞌa lu të antsë ");
INSERT INTO zacNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","por ni, si talë chu guëniꞌi lu të: “Gulë guná, lëꞌë më nanú më lu shlatë catë chu nádiꞌi”, adë tsádiꞌi të ngaꞌli; u si talë chu guëniꞌi: “Gulë guná, nanú më laꞌni tubi hiuꞌu”, adë tsaldídiꞌi lduꞌu të ");
INSERT INTO zacNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","purquë ziquë raꞌa tubi guiꞌi shtë nguziꞌu; rabtsëꞌë guiꞌi nezë guiaꞌa hashtë nezë guetë, zni gac iurë lëꞌë nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, guëdchíniꞌ stubi. ");
INSERT INTO zacNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Catë nagaꞌa ra naguti, ngaꞌli rdëá ra bëchu. ");
INSERT INTO zacNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Despuësë gudëdë ra dzë shtë cusë durë, lueguë lëꞌë ngubidzë guëcahi lúhiꞌ nu mbehu hiadë guënéꞌediꞌin llni. Ra mbelëguiꞌi ldaguë. Grë́tëꞌ fuersë shtë gubeꞌe guëniꞌbi. ");
INSERT INTO zacNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Iurní lu gubeꞌe guëná të sëñi shtë nguiu nabësheꞌldë Dios. Grë́tëꞌ ra mënë shtë guë́ꞌdchiliu, guꞌnë rall nu guëná rall lu nguiu nabësheꞌldë Dios; guëdchíniꞌ ruaꞌ shcahi lu gubeꞌe. Guëluaꞌa llëruꞌbë pudërë nu llni shtënë më. ");
INSERT INTO zacNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nu guëshéꞌldiꞌ ianglë shtë́niꞌ con guꞌldë trompetë parë guëdëá grë́tëꞌ nagulë́ Dios guëdubi guë́ꞌdchiliu dizdë tubi cuꞌ hashtë stubi ladë. ");
INSERT INTO zacNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Gulë bësëꞌdë tubi comparaciuni shtë tubi hiaguë bëldaꞌu. Iurë guëná të luhin, rguëhin nu rruꞌu ra ndiaguë lu llícuhin, hia rac bëꞌa të bëdchini tiempë shtë galnaꞌi. ");
INSERT INTO zacNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mizmë manërë ni, iurë guëná të ra cusë rëꞌ, gulë bëdëꞌë cuendë lëꞌë më zeꞌdë guëdchíniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Guldía rniaꞌa, grë́tëꞌ ndë gac cumplir antsë quë gati ra mënë nanabani iurneꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Gubeꞌe nu guë́ꞌdchiliu tsalú rahin perë shtiꞌdza adë tsalúdiꞌin. ");
INSERT INTO zacNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Perë dzë nu iurë adë chu rac bë́ꞌadiꞌi, ni por mizmë ianglë shtë gubeꞌe, ni por shini Dios, sulamëntë Dios Shtada rac bëꞌa më dzë shtë fin. ");
INSERT INTO zacNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ziquë guzac tiempë shtë Noé, zni gac iurë lëꞌë nguiu nabësheꞌldë Dios guëdchíniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tiempë dzë ni antsë lëꞌë juici shtë nisë bëdchini, nabani ra mënë lu guë́ꞌdchiliu; gudáu rall nu biiꞌ rall; bëtsëꞌa rall, nu bëdëꞌë rall shini rall parë riu saꞌa shtë niꞌi, hashtë lëꞌë Noé gutë́ laꞌni barcu. ");
INSERT INTO zacNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Todavía adë bëdë́ꞌëdiꞌi rall cuendë hashtë iurë lëꞌë juici bëdchini. Biaꞌa nisi grë́tëꞌ ra mënë. Zni gac iurë nguiu nabësheꞌldë Dios guëdchíniꞌ stubi. ");
INSERT INTO zacNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tiempë dzë ni chupë nguiu nanú lachi; tubi nguiu tsabsú, stubi nguiu guëaꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Chupë naꞌa caniuꞌu; tubi tsabsú, stubi guëaꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Gulë cue nasini purquë adë rac bë́ꞌadiꞌi të ca iurë guëdchini el quë naguënibëꞌa lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Perë gulë bësëꞌdë ndëꞌë, si talë tubi nashtënë hiuꞌu rac bë́ꞌall ca iurë guëdchini ngubaꞌnë, gaꞌa nasínill parë gáquëdiꞌi tsaldanë ngubaꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Por ni gulë cue nasini nu gulë gac preparadë lduꞌu të purquë menos runë të shgabë të, iurní guëná të lu nguiu nabësheꞌldë Dios; hia bëdchíniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Chu na muzë namás riasë́ nu namás obedientë? Na ziquë el quë nabëꞌnë recibir dchiꞌni. Lamë shtë nguiu ni gunibë́ꞌall guëdëꞌë nguiu nagáu iurë bëꞌnë tucarë gau lamë. ");
INSERT INTO zacNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Dichusë muzë si talë quëhúnëll bien iurë lëꞌë lamë guëdchini. Guëdzelë lamë lëꞌë muzë; quëhúniꞌ cumplir. ");
INSERT INTO zacNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Guldía rniaꞌa, lëꞌë lamë guëzú lëꞌë muzë ni; gáquëll encargadë shtë grë lo quë nanapë lamë. ");
INSERT INTO zacNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Perë si talë muzë nall tubi nguiu mal, gúnëll llgabë de quë shlámëll gac ldëꞌë parë gueꞌdë guëzë́ ");
INSERT INTO zacNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nu gúnëll tratë mal stubi saꞌ muzë, nu tsataunull ra zudchi; ruuꞌll con lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Iurë lëꞌë lamë guëabrí, lëꞌë muzë ni adë rúnëdiꞌi shgábëll ca iurë gueꞌdë guëzë́ lamë. ");
INSERT INTO zacNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Perë lëꞌë lamë guëdëꞌë tubi cashtigu ruꞌbë parë muzë ni; gac condenárëll mizmë manërë cumë ziquë mënë naná falsë. Iurní gúꞌnëll ngaꞌli hashtë rchushí laiꞌll. ");
INSERT INTO zacNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Iurë guëdchini tiempë, manërë naguënibëꞌa Dios na ziquë chiꞌi lliguënaꞌa nagunaꞌzi lámpara nariú sëiti parë quëguiꞌin; bëruꞌu rall të parë gunë rall recibir lëꞌë lliguë iurë guëdchíniꞌ lidchi saꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gaꞌi lliguënaꞌa na tuntë, adë rúnëdiꞌi rall guë́quëll, perë gaꞌi ra lliguënaꞌa na rall listë. ");
INSERT INTO zacNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ra lliguënaꞌa tuntë biaꞌa rall lámpara shtë rall perë adë biáꞌadiꞌi rall sëiti parë tsadzë́ lámpara. ");
INSERT INTO zacNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Perë ra lliguënaꞌa listë biaꞌa rall bëtë́i sëiti nu gadzë́ ra lámpara. ");
INSERT INTO zacNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Lëꞌë lliguë guc ldëꞌë parë guëdchínill; iurní mbëcaꞌldë bëdchini lu ra lliguënaꞌa. Por fin lëꞌë rall guꞌtë gaꞌsi. ");
INSERT INTO zacNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Iurní cumë ziquë guëruldë gueꞌlë, bini rall tubi naguniꞌi fuertë: “Hia lëꞌë lliguë zeꞌdë. Gulë bëruꞌu të parë gunë të recibir lëꞌë lliguë.” ");
INSERT INTO zacNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Grë́tëꞌ lliguënaꞌa guashtë́ rall parë bëꞌnë rall preparar lámpara shtë rall. ");
INSERT INTO zacNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hia zëgaꞌi ra naná tuntë repi rall lu zëgaꞌi naná listë: “Denú duꞌpë sëiti purquë lëꞌë lámpara shtënë naꞌa guëaldin”. ");
INSERT INTO zacNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Perë lliguënaꞌa naná listë bëquebi raiꞌ: “Aquëdiꞌi, purquë iurní guëbidchi sëiti shtënë naꞌa. Parë lëꞌë të adë gáldëdiꞌin; mejurë gulë tsacaꞌa sëiti catë rduhin. Gulë tsasíꞌihin të parë iurní napë tëhin.” ");
INSERT INTO zacNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Perë mientras gaꞌi naꞌa guasiꞌi rall sëiti, lëꞌë lliguë beꞌdë guëzë́. Ra lliguënaꞌa naná preparadë guatënú rall lliguë lu saꞌa. Iurní bëꞌau ruaꞌ puertë. ");
INSERT INTO zacNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Despuësë bëdchini ra zëgaꞌi lliguënaꞌa; iurní guniꞌi rall: “Dadë, bëshaꞌlë puertë”. ");
INSERT INTO zacNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Perë naná shtënë hiuꞌu bëquebi: “Guldía rniaꞌa de quë adë guënë́diaꞌa lëꞌë të”. ");
INSERT INTO zacNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Iurní Jesús repi: ―Gulë gac preparadë. Gulë gac nasini purquë adë rac bë́ꞌadiꞌi të pë dzë, ni pë iurë guëdchini nguiu nabësheꞌldë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Lugar catë rnibëꞌa Dios nu tiempë gunë më juzguë ra mënë, na ziquë tubi nguiu naguziaꞌa parë stubi naciuni. Gunaꞌbë nguiu ni ra shmúzëll. Bë́ꞌnëll incarguë shtumill lu ra muzë ni. ");
INSERT INTO zacNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Tubi de lëꞌë ra muzë bëdë́ꞌëll gaꞌi mili bëllë. Stúbill cuaꞌa chupë mili dumí. Stúbill cuaꞌa tubi mili bëllë, según narac cadë tubi rall. Iurní lëꞌë nguiu ni guziaꞌa viajë. ");
INSERT INTO zacNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hia lëꞌë muzë nabëꞌnë recibir gaꞌi mili bëllë, lueguë bë́ꞌnëll neguci con dumí. Bë́ꞌnëll gan stubi zëgaꞌi mili bëllë de guëc ra nabë́ꞌnëll recibir. ");
INSERT INTO zacNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mizmë manërë ni nabëꞌnë recibir chupë mili bëllë, bë́ꞌnëll gan stubi chupë mili más. ");
INSERT INTO zacNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Perë el quë nabëꞌnë recibir tubi mili bëllë, bëcáꞌchill dumí shtë lamë. Guatánill tubi guëru catë guacáꞌchill dumí. ");
INSERT INTO zacNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Hia llëruꞌbë tiempë gudëdë; bëabrí lamë shtë muzë ni. Iurní guzublú gunaꞌbë lamë shcuendë dumí. ");
INSERT INTO zacNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Primërë bëdchini nabëꞌnë recibir gaꞌi mili bëllë. Bë́ꞌnëll intriegu lu shlámëll stubi zëgaꞌi mili. Répill: “Dadë, lëꞌë gaꞌi mili nabënéꞌel cuahia ndëꞌë; perë guná, stubi zëgaꞌi mili bëna gan subrë guëc gaꞌi mili”. ");
INSERT INTO zacNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Lëꞌë lamë repi: “Bien nahin; lë́ꞌël nal tubi muzë zaꞌquë. Rac bë́ꞌahia gúnël lo quë narac shtuaꞌa. Hia quë lë́ꞌël bë́ꞌnël bien de lo duꞌpë, guënehia másruꞌu cusë zaꞌquë të guënibë́ꞌal. Guatë́; bëquitë ldúꞌul con na.” ");
INSERT INTO zacNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Despuësë bëdchini stubi muzë nabëꞌnë recibir chupë mili bëllë. Répill lu lamë: “Dadë, bënéꞌel chupë mili bëllë cuahia; lëꞌë ndëꞌë. Perë chupë mili bëllë más bëna gan subrë guëc chupë mili.” ");
INSERT INTO zacNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Lëꞌë lamë repi: “Bien nahin. Nal tubi muzë zaꞌquë. Napa confiansë lë́ꞌël. Hia quë lë́ꞌël nal muzë zaꞌquë de lo duꞌpë nabëna incarguë guiáꞌal; bë́ꞌnël gan más. Guatë́; bëquitënú ldúꞌul na.” ");
INSERT INTO zacNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Perë iurë bëdchini muzë nabëꞌnë recibir tubi mili bëllë, répill lu shlámëll: “Dadë, nanë́a quë lë́ꞌël nal tubi nguiu naná rzac zi muzë. Rcáꞌal cusechë catë adë bëcabnídiꞌil, nu rtëal catë adë bëtë́ꞌtsëdiꞌil bëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Por ni bëdzëba; guacaꞌcha shtumil laꞌni guiuꞌu perë iurneꞌ lëꞌë shtë́nël ndëꞌë.” ");
INSERT INTO zacNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Lëꞌë lamë bëquebi: “Muzë mal nal, nu nabë́chil. Rníꞌil de de quë rcahia cusechë catë adë rcabnídiaꞌa, nu rtëáhia catë adë rtë́ꞌtsëdiaꞌa bëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Por ni niagutël dumí lu bancu parë iurná nihuna recibir shini dumí lo quë narunë tucara.” ");
INSERT INTO zacNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Iurní repi lamë lu ra narëtaꞌ ngaꞌli: “Gulë bëdchisú mili bëllë de muzë mal nu bëdëꞌëin caꞌa naná bëꞌnë recibir chiꞌi mili. ");
INSERT INTO zacNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Si talë guëquë́ diaguë të bien, Dios guëneꞌe më más shtiꞌdzë më parë lëꞌë të perë si talë rúnëdiꞌil cuendë shtiꞌdza, guëdchisú më llni narníꞌil nápël. ");
INSERT INTO zacNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nu lëꞌë muzë mal, gulë bëtiaꞌa lë́ꞌëll tëchi fuërë catë nacahi, catë guꞌnë mënë nu rchushí laiꞌ rall.” ");
INSERT INTO zacNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Iurë lëꞌë nguiu nabësheꞌldë Dios guëdchíniꞌ stubi, guëdchíniꞌ con llni nu pudërë nu con ra ianglë shtë Dios. Subë më lu trunë shtënë më con llëruꞌbë pudërë. ");
INSERT INTO zacNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ra mënë shtë grë naciuni guëdëá rall delantë lu më. Hia lëꞌë më cuë më ra mënë cumë ziquë rbë vëquërë ra lliꞌli con ra chivë. ");
INSERT INTO zacNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Cueꞌe zaꞌquë më ra më zaꞌquë nagulë́ Dios ziquë lliꞌli ladë ldi shtënë më, nu ra më mal, ra nagualdídiꞌi lduꞌi lëꞌë më, cue rall ladë rubësë. ");
INSERT INTO zacNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Iurní lëꞌë rëy guëniꞌi lu naquëbezë ladë ldi: “Gulë teꞌe guëdchini të lua, lëꞌë të el quë naná gulë́ Shtada. Gulë bëꞌnë recibir lugar zaꞌquë naná preparadë parë lëꞌë të dizdë Dios bëcueꞌshtë́ guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pues bëldíꞌana, nu lëꞌë të bëneꞌe të nagudáuha. Gubidcha, nu bëneꞌe të nabiaꞌ. Guca ziquë më zitu, nu lëꞌë të bëneꞌe të catë guꞌtë gaꞌsia. ");
INSERT INTO zacNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Bëꞌnë faltë shaba perë bëneꞌe të lo quë nabëquiꞌnia. Guc llúꞌuhia; bidë guëná të na; guahia lachiguiꞌbë, nu beꞌdë guëná të na.” ");
INSERT INTO zacNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Iurní lëꞌë ra naná justë guëniꞌi rall lu më: “Dadë, ¿guc guná naꞌa lul; bëldiáꞌnël, nu bëneꞌe naꞌa nagaul? ¿Guc guná naꞌa gubídchil, nu bëneꞌe naꞌa nabiiꞌl? ");
INSERT INTO zacNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Guc guná naꞌa lul ziquë më zitu, nu bëneꞌe naꞌa catë guquëréldël? ¿Guc guná naꞌa bëꞌnë faltë shábël, nu bëneꞌe náꞌahin? ");
INSERT INTO zacNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Guc guná naꞌa guc llúꞌul u gual lachiguiꞌbë, nu beꞌdë guëná naꞌa lë́ꞌël?” ");
INSERT INTO zacNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Iurní rëy guëquebi: “Guldía rniaꞌa, grë́tëꞌ lo quë nabëꞌnë të por tubi ra bëcha namás mituꞌnë, ziquë bëꞌnë të tratë grë ra shmëna hashtë el quë namás lasáquëdiꞌi, pues mizmë na bëꞌnë të tratë”. ");
INSERT INTO zacNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Iurní lëꞌë rëy guepi lu naná rëtaꞌ ladë rubësë: “Gulë guabsú lua, lëꞌë të hia nanudé të parë gabildi. Tsa të lu beꞌlë nanápëdiꞌi fin, preparadë parë mëdzabë nu parë ra ianglë shtë́nëll. ");
INSERT INTO zacNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pues bëldíꞌana perë adë bënéꞌediꞌi të nagudáuha. Gubidcha perë adë bënéꞌediꞌi të nabiaꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Guca ziquë më zitu perë adë bënéꞌediꞌi të catë naquërelda. Runë faltë shaba perë lëꞌë të adë bënéꞌediꞌi të niétiquë. Guc llúꞌuhia; guahia lachiguiꞌbë perë adë beꞌdë guënádiꞌi të na.” Iurní lëꞌë ra më mal guepi rall: ");
INSERT INTO zacNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Dadë, ¿guc guná naꞌa bëldíꞌanël u gubídchil u ziquë më zitu u bëꞌnë faltë shábël u guc llúꞌul u gual lachiguiꞌbë, nu adë chu beꞌdë guënádiꞌi lë́ꞌël?” ");
INSERT INTO zacNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Lëꞌë rëy guëquebi iurní: “Guldía rniaꞌa, manërë mal bëꞌnë të tratë shmëna naná más humildë, zni bëꞌnë të tratë mizmë na”. ");
INSERT INTO zacNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Lueguë iurní lëꞌë ra nguiu guziaꞌa rall lu cashtigu nanápëdiꞌi fin perë grë́tëꞌ naná tubldí shcuéndiꞌ lu Dios, guziaꞌa raiꞌ gubeꞌe catë cabezë Dios catë nídiꞌi fin. ");
INSERT INTO zacNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iurë Jesús gualú biadiꞌdzë më grë́tëꞌ ra cusë ni, repi më lu ra shini gusëꞌdë më: ");
INSERT INTO zacNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Lëꞌë të hia rac bëꞌa të dentrë de chupë dzë shtë laní Pascu, lëꞌë nguiu nabësheꞌldë Dios gac intriéguiꞌ guiaꞌa mënë mal nu gac crucificáriꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tiempë dzë ni ra jëfë shtë ra bëshuzi nu ra mësë shtë lëy nu ra më gushë entrë ra israelitë, bëdëá rall lu rualdëaꞌ shtë palaci shtë Caifás, jefë shtë ra bëshuzi. ");
INSERT INTO zacNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ngaꞌli bëntsaꞌu rall tubi tratë parë guënaꞌzi rall Jesús con diꞌdzë bishi parë quini rall lëꞌë më ");
INSERT INTO zacNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","perë guniꞌi lu saꞌ rall: ―Lëdi laꞌni dzë laní parë adë guëdzátsudiꞌi ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús nanú Betania lidchi Simón el quë naguc lluꞌu ládiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Iurní guabiꞌguë tubi naꞌa; nuáꞌall tubi bëtë́i guëꞌë shtë sëiti nashi nu nalë́ lasaquë sëiti ni. Iurë quëbezë Jesús lu mellë, lëꞌë naꞌa ni bëtéꞌbiꞌ sëiti guëc Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Iurë lëꞌë ra shini gusëꞌdë më guná raiꞌ pë bëꞌnë naꞌa, bëldë́ raiꞌ nu guzublú guniꞌi raiꞌ: ―¿Pëzielú bëꞌnë naꞌa rëꞌ desperdici sëiti nashi guëc më? ");
INSERT INTO zacNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","purquë bien niatuuꞌ naꞌa sëiti por zihani dumí nu niadë́ꞌëll dumí caꞌa ra prubi. ");
INSERT INTO zacNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Perë guc bëꞌa Jesús shgabë raiꞌ nu guniꞌi më: ―¿Pëzielú cagniꞌi të cuntrë naꞌa rëꞌ? El quë nabë́ꞌniꞌ nahin tubi cusë zaꞌquë parë na. ");
INSERT INTO zacNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pues ra prubi guëdubi tiempë quëbezënú rall lëꞌë të perë na lëdë guëdubi tiémpëdiꞌi quëbezënúa të. ");
INSERT INTO zacNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Lo quë nabëꞌnë naꞌa nabëteꞌbi sëiti guëdubi cuerpë shtëna, bë́ꞌniꞌ parë gac preparar iurë gatia nu guëgaꞌcha. ");
INSERT INTO zacNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Guldía rniaꞌa, guëdubi lugar catë guadiꞌdzë ra mënë dizaꞌquë guëdubi guë́ꞌdchiliu, guadiꞌdzë ra mënë lo quë nabëꞌnë naꞌa rëꞌ. Guëagná lduꞌu mënë lo quë nabë́ꞌniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Iurní tubi naná chiꞌbë chupë poshtë nabërulë́ Judas Iscariote, guagníꞌill lu ra jëfë shtë ra bëshuzi ");
INSERT INTO zacNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","nu répill: ―¿Blac guëneꞌe të talë guna intriegu Jesús guiaꞌa të? Iurní lëꞌë rall gudilli rall galdë bi chi bëllë bëdchichi. ");
INSERT INTO zacNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Dizdë iurní Judas gudílill manërë parë gúnëll intriegu lëꞌë më guiaꞌa ra contrari shtë më. ");
INSERT INTO zacNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Primërë dzë shtë laní naráu mënë guetështildi sin levadurë, ra shini gusëꞌdë më guabiꞌguë raiꞌ lu më nu gunaꞌbë diꞌdzë raiꞌ: ―¿Ca lu rac shtúꞌul guëdëꞌnë naꞌa preparar shtse shtë Pascu; guëdáuhaꞌa? ");
INSERT INTO zacNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús repi: ―Gulë tsa tubi ciudá lidchi tubi nguiu nu gulë guchi: “Lëꞌë mësë guniꞌi zndëꞌë: Hia lëꞌë iurë zia guëdchini. Lídchil guna laní Pascu con ra shini gusëꞌda.” ");
INSERT INTO zacNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ra shini gusëꞌdë më bëꞌnë raiꞌ cumë ziquë gunibëꞌa Jesús. Bëꞌnë raiꞌ preparar shtse shtë Pascu. ");
INSERT INTO zacNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Iurë lëꞌë gueꞌlë guꞌ, quëbezënú Jesús lëꞌë chiꞌbë chupë shini gusëꞌdë më lu mellë. ");
INSERT INTO zacNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mientras caniháu raiꞌ, repi më: ―Guldía rniaꞌa, tubi de lëꞌë të gunë të intriegu na. ");
INSERT INTO zacNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Iurní lëꞌë raiꞌ guzublú riá lduꞌu raiꞌ demasiadë; gunaꞌbë diꞌdzë raiꞌ tubi por tubi: ―Dadë ¿ni mudë guna intriegu lë́ꞌël? ");
INSERT INTO zacNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús repi: ―El quë naraunú na laꞌni el mizmë platë, ni lëꞌë nagunë intriegu na. ");
INSERT INTO zacNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Lëꞌë nguiu nabësheꞌldë Dios guziaꞌa parë nezë según narniꞌi Sagradas Escrituras, perë prubi de lëꞌë nguiu el quë nagunë intriegu na. Mejurë adë niálëdiꞌi nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iurní lëꞌë Judas, lëꞌë traidor, guniꞌi: ―Mësë ¿ni mudë na guna intriegu lë́ꞌël? Jesús bëquebi: ―Ahaꞌ, lë́ꞌël la laꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mientras quëhaunú Jesús lëꞌë raiꞌ, gunaꞌzi më guetështildi nu bëdëꞌë më graci lu Dios. Despuësë de bëshullë mëhin, bëdëꞌë më guetështildi cuaꞌa ra shini gusëꞌdë më; nu repi më: ―Gulë gau ndëꞌë; ndëꞌë lëꞌë shcuerpa. ");
INSERT INTO zacNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Iurní gunaꞌzi më copë. Bëdëꞌë më graci lu Dios nu bëdëꞌë mëhin cuaꞌa ra shini gusëꞌdë më. Repi më: ―Gulë biiꞌ grë́tëꞌ të copë rëꞌ; ");
INSERT INTO zacNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ndëꞌë lëꞌë shrëna narunë sellar tëstë cubi purquë nahin tubi favurë parë cantidá mënë; bëllëꞌë rënë ni parë perdunë shtë ra duldë. ");
INSERT INTO zacNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Perë rniaꞌa, hiadë guëbrídiꞌi gunúhia lëꞌë të juguë shtë uvë rëꞌ hashtë dzë naná guëbezënúhia lëꞌë të gubeꞌe. Iurní guhia vini cubi lu gubeꞌe catë rnibëꞌa Shtada. ");
INSERT INTO zacNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Despuësë de quëhuꞌldë raiꞌ tubi cantë, iurní gua raiꞌ lu dani shtë Olivos. ");
INSERT INTO zacNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Iurní Jesús repi: ―Grë́tëꞌ të guëtú lu të de na nu guësëaꞌnë të na gueꞌlë neꞌ purquë rniꞌi laꞌni Sagradas Escrituras: “Tsatinia lëꞌë vëquërë; hia ra lliꞌli guërëꞌtsë”. ");
INSERT INTO zacNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Perë despuësë iurë tsashtë́a ladi ra tëgulë, tsahia delantë lu të hashtë Galilea. ");
INSERT INTO zacNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Iurní Pedro bëquebi: ―Aunquë nilë grë́tëꞌ raiꞌ guësëaꞌnë raiꞌ lë́ꞌël, perë na jamás adë guësëáꞌnëdiaꞌa lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús repi: ―Guldía rniaꞌa, mizmë gueꞌlë neꞌ antsë lëꞌë gay guëllidchí, lë́ꞌël gúnël negar na tsunë vueltë. ");
INSERT INTO zacNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Perë Pedro repi: ―Masiá quini mënë na, adë gúnëdiaꞌa negar lë́ꞌël. Grë ra shini gusëꞌdë më guniꞌi raiꞌ lo mizmë. ");
INSERT INTO zacNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iurní Jesús bëdchini con ra shini gusëꞌdë më tubi lugar lë Getsemaní. Repi më lu raiꞌ: ―Gulë guzubë ndëꞌë mientras tsahia ndë. Guadiꞌdzënúa Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Iurní biaꞌa më Pedro nu ra shini Zebedeo; guzublú riá lduꞌu më; guasënú lduꞌu më. ");
INSERT INTO zacNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Guniꞌi më: ―Nalë́ rbini laꞌni lduaꞌa por tristë shtë galguti. Gulë cuezë ndëꞌë nu gulë cue nasini con na. ");
INSERT INTO zacNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Gua Jesús stuꞌpë delantë. Bëzullibi më nu bëaꞌchi guëc më hashtë lu guiuꞌu. Iurní bëꞌnë më orar lu Dios; répiꞌ: ―Dadë shtëna, si talë nahin posiblë bëlá na lu sufrimientë rëꞌ, perë adë gáquëdiꞌin según lo quë narac shtuaꞌa sino según voluntá shtë́nël. ");
INSERT INTO zacNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Iurní bëabrí më catë cabezë ra shini gusëꞌdë më. Bëdzelë më lëꞌë raiꞌ nagaꞌsi raiꞌ. Iurní repi më lu Pedro: ―¿Pë adë gáquëdiꞌi cue nasini të duꞌpë tiempë, ni siquierë tubi iurë? ");
INSERT INTO zacNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Gulë bëtëꞌtsë mbëcaꞌldë; gulë cue nasini nu gulë gunaꞌbë lu Dios parë adë ldáguëdiꞌi të lu prëbë shtë mëdzabë. Lduꞌu të rniꞌi, niá; perë shcuerpë të adë nídiꞌi fuersë. ");
INSERT INTO zacNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Hia narrupë ziaꞌa më; guaguëꞌnë më orar zndëꞌë: ―Dadë, si talë na imposiblë tsalú vasë shtë sufrimientë, bëꞌnin según voluntá shtë́nël. ");
INSERT INTO zacNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Iurní bëabrí më stubi; bëdzelë më ra shini gusëꞌdë më hia nagaꞌsi raiꞌ purquë nalë́ bëdchini mbëcaꞌldë lu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Iurní bësëaꞌnë më lëꞌë raiꞌ; ziaꞌa më; bëꞌnë më orar stubi natsunë vësë. Guniꞌi më mizmë diꞌdzë ni. ");
INSERT INTO zacNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bëabrí më catë rëtaꞌ ra shini gusëꞌdë më; repi më: ―Iurneꞌ sí, gulë guëgaꞌsi; gulë tsa descansë. Hia lëꞌë iurë bëgaꞌa de quë lëꞌë nguiu nabësheꞌldë Dios, gac intriéguiꞌ guiaꞌa ra nanapë zihani duldë. ");
INSERT INTO zacNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gulë tsasuldí; gulë cha purquë hia el quë nagunë intriegu na zéꞌdëll. ");
INSERT INTO zacNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nianá quëadiꞌdzë Jesús, bëdchini Judas naná de chiꞌbë chupë shini gusëꞌdë më; zeꞌdënull cantidá mënë nanuaꞌa spadë nu hiaguë. Zeꞌdë rall por partë shtë ra jëfë shtë ra bëshuzi nu ra më gushë shtë guëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas lëꞌë traidor, bëdë́ꞌëll tubi sëñi; répill: ―El quë naguna saludar, tsagruahia lë́ꞌëll; gulë biaꞌa nguiu ni prësi. ");
INSERT INTO zacNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iurní guabiꞌguë Judas lu Jesús nu répill: ―Shtsanë, Mësë. Nu bëtsagruaꞌll lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús guniꞌi lu Judas: ―¿Pë zéꞌdël? amigu. Iurní guabiꞌguë ra mënë nu gunaꞌzi rall lëꞌë Jesús. Biaꞌa rall lëꞌë më prësi. ");
INSERT INTO zacNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mizmë iurní tubi saꞌ Jesús gulú spadë; bëchúguiꞌ diaguë ladë ldi muzë shtë jëfë shtë bëshuzi. ");
INSERT INTO zacNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Iurní Jesús repi: ―Gulútsaꞌu spadë shtë́nël shlugarin purquë grë́tëꞌ el quë narguini con spadë, zni gati rall con spadë. ");
INSERT INTO zacNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Pëllë adë rac bë́ꞌal zac guënaꞌba lu Shtada nu guësheꞌldë më mizmë iurneꞌ más quë chiꞌbë chupë grupë ianglë, chiꞌi mili cadë grupë të gunë raiꞌ compañi na? ");
INSERT INTO zacNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Perë si talë gaquin zni ¿lla gac cumplir Sagradas Escrituras narniꞌi napë quë gaquin zni? ");
INSERT INTO zacNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Iurní Jesús repi lu ra mënë: ―Beꞌdë guëdchini të con spadë nu hiaguë parë guënaꞌzi të na cumë ziquë tubi ngubaꞌnë. Grë́tëꞌ dzë gulezënúa lëꞌë të. Cagluáꞌahia lëꞌë të laꞌni iáduꞌu shtënë të perë nunquë adë gunáꞌzidiꞌi të na prësi. ");
INSERT INTO zacNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Perë ndëꞌë quëhac parë gac cumplir lo quë nabëquëꞌë muzë shtë Dios guahietë laꞌni Sagradas Escrituras: Iurní ra shini gusëꞌdë më bësaꞌnë raiꞌ lëꞌë më. Bëlluꞌnë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ra nagunaꞌzi lëꞌë Jesús prësi, biaꞌa rall lëꞌë më lu Caifás, jëfë principal shtë ra bëshuzi. Nu rëtaꞌ ra mësë shtë lëy nu ra më gushë nabëdëá ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Guanaldë Pedro zitu hashtë rualdëaꞌ shtë lidchi bëshuzi principal. Guatë́ Pedro ngaꞌli; guzubënú Pedro ra soliar të parë guënáhiꞌ niaꞌa lla tsalú shcuendë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ra jëfë shtë ra bëshuzi nu ra mënë gushë nu grë ra Junta Suprema, quëguili rall manërë parë gunë rall acusar lëꞌë më aunquë nilë nahin cusë falsë parë gac condenar Jesús lu galguti. ");
INSERT INTO zacNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Perë adë bëdzélëdiꞌi rall prëbë aunquë nilë zihani testigu falsë guniꞌi rall bishi cuntrë lëꞌë më. Por fin bëdchini bëldá testigu falsë ");
INSERT INTO zacNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","naná repi: ―Lëꞌë nguiu rëꞌ guniꞌi: “Zac guëchilia iáduꞌu shtë Dios nu guëabrí guëldishtë́hia iáduꞌu entrë tsunë dzë”. ");
INSERT INTO zacNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Iurní jëfë shtë ra bëshuzi guasuldí nu répill lu Jesús: ―¿Pë adë rquébidiꞌil grë ra diꞌdzë rëꞌ? ¿Pë runë cuntienë lo quë naquëgniꞌi mënë cuntrë lë́ꞌël? ");
INSERT INTO zacNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús dchisë náhiꞌ. Iurní lëꞌë jëfë shtë bëshuzi repi: ―Por nombre shtë Dios nanabani, quëgniaꞌa lul, biadiꞌdzë lu naꞌa si talë nal Cristo, Shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús repi: ―Ni nahia, cumë ziquë cagníꞌil. Nu zac rniaꞌa lu të guëná të lu Shini Dios; quëbéziꞌ ladë ldi shtë Dios, el quë narnibëꞌa grë́tëꞌ cusë. Nu guëná të lua; guëdchinia laꞌni shcahi shtë gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Iurní lëꞌë jëfë shtë bëshuzi bëcheꞌzë shábëll cumë ziquë tubi sëñi de quë adë rëuuꞌdiꞌi ldúꞌull lo quë naguniꞌi Jesús. Bëldëll. Répill: ―Hia nguiu rëꞌ bë́ꞌnëll ofender Dios con diꞌdzë nabëruꞌu ruaꞌll. ¿Pë nicidá nápaꞌa de más testigu? Mizmë lëꞌë të bini të diꞌdzë mal naquëgníꞌill. ");
INSERT INTO zacNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Pë rniꞌi lduꞌu të? Guniꞌi rall: ―Runë tucarë gati nguiu rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Iurní bëchiꞌbë shënë rall lu më nu bëdëꞌë rall galnë́ guëc më. Stúbill gulubë́ lu më ");
INSERT INTO zacNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nu guniꞌi rall: ―Lë́ꞌël nal Cristo; bëꞌnë divini chu gudini lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mientras zu Pedro rualdëa, tubi criadë guabíꞌguëll lu Pedro nu répill: ―Lë́ꞌël zugaꞌanul Jesús, më Galilea. ");
INSERT INTO zacNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Perë Pedro bëꞌnë negar delantë lu grë mënë. Répiꞌ: ―Adë rac bë́ꞌadiaꞌa pë cagníꞌil. ");
INSERT INTO zacNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Iurní Pedro ziagrúꞌuiꞌ ruaꞌ nezë. Iurë guná stubi criadë lu Pedro, guníꞌill lu ra mënë narëtaꞌ ngaꞌli: ―Nu nguiu rëꞌ rzënú Jesús më Nazaret. ");
INSERT INTO zacNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Stubi vësë más Pedro bëꞌnë negar nu bë́ꞌniꞌ jurar lu Dios: ―Adë guënë́diaꞌa nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Duꞌpsë ziaꞌa, iurní mënë nazugaꞌa ngaꞌli guabiꞌguë rall lu Pedro nu guniꞌi rall: ―Verdá nal shmënë Jesús purquë ruadíꞌdzël ziquë mënë galileo. ");
INSERT INTO zacNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Iurní guzublú Pedro; bë́ꞌniꞌ jurar; répiꞌ: ―Adë guënë́diaꞌa nguiu ni. Gunë Dios cashtigu na si talë adë ruadíꞌdzëdiaꞌa verdá. Mizmë iurní bëllidchí gay. ");
INSERT INTO zacNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Iurní bëagná lduꞌu Pedro lo quë naguniꞌi Jesús: “Antsë guëllidchí gay, gúnël negar na tsunë vueltë”. Iurní bëruꞌu Pedro nu nalë́ bíꞌniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Iurë brëgueꞌlë grë́tëꞌ ra jëfë shtë ra bëshuzi nu ra më gushë shtë ra israelitë, guc rall de acuerdë nu bëntsaꞌu rall tubi tratë parë quini rall Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bëldiꞌbi rall lëꞌë më; biaꞌa rall lëꞌë më parë guaguëꞌnë rall intriegu lëꞌë më lu Poncio Pilato gubernadurë. ");
INSERT INTO zacNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Iurë Judas el quë nabëꞌnë intriegu Jesús, bëdë́ꞌëll cuendë de quë nacondenárëll, gubini ldúꞌull. Bëdchigrëll galdë bi chi bëllë bëdchichi parë ra jëfë shtë ra bëshuzi con ra më gushë, ");
INSERT INTO zacNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","répill: ―Na bëna duldë. Bëna intriegu lëꞌë më rëꞌ lu galguti nu nápëdiꞌiꞌ duldë. Perë lëꞌë rall bëquebi rall: ―Parë niꞌi, ¿pë runë importë naꞌa? Shcuéndël niꞌi. ");
INSERT INTO zacNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Iurní Judas bëquëldí dumí laꞌni iáduꞌu. Guziáꞌall. guagzéꞌbill lë́ꞌëll lu hiaguë. ");
INSERT INTO zacNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ra jëfë shtë ra bëshuzi bëtëá rall dumí nu repi rall: ―Adë chu guëtiáꞌadiꞌi dumí rëꞌ laꞌni cajë shtë ofrendë purquë nahin probidë según lëy shtë Dios. Nahin prëci nabëtuuꞌ Judas lëꞌë Jesús parë galguti. ");
INSERT INTO zacNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Iurní guc rall de acuerdë parë guëziꞌi rall tubi ldë guiuꞌu con dumí ni. Bërulë́ lachi ni: Lachi shtë el quë Naguctsaꞌu Trashtë. Lachi ni na catë guëgaꞌchi ra më zitu. ");
INSERT INTO zacNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Por ni bërulë́ lachi ni hashtë iurneꞌ; Lachi Catë Bëllëꞌë Rënë. ");
INSERT INTO zacNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Zni guc cumplir lo quë naguniꞌi Jeremías: “Gunaꞌzi rall galdë bi chi bëllë bëdchichi, prëci nabëꞌnë më israelitë tratë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Con dumí guziꞌi rall tubi lachi shtë el quë naguctsaꞌu trashtë. Zni gunibëꞌa Dadë Dios.” ");
INSERT INTO zacNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Biaꞌa rall Jesús lu gubernadurë; gunaꞌbë díꞌdzëll lu më: ―¿Pë lëꞌë nal rëy shtë ra më israelitë? Jesús repi: ―Zni nahin cumë ziquë quëgníꞌil. ");
INSERT INTO zacNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ra jëfë shtë bëshuzi nu ra mënë gushë, bëdchiꞌbë rall demandë cuntrë Jesús perë Jesús adë pë bëquébidiꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Iurní Pilato repi: ―¿Pë adë rínidiꞌil lo quë naquëgniꞌi ra mënë cuntrë lë́ꞌël? ");
INSERT INTO zacNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Perë Jesús adë bëquébidiꞌi më de manërë lëꞌë gubernadurë guasë́ ldúꞌull iurní nu adë guc bë́ꞌadiꞌill pë gúnëll. ");
INSERT INTO zacNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Durantë dzë shtë laní, lëꞌë gubernadurë napë custumbrë guëldáꞌall tubi prësi, el quë narac shtuꞌu ra mënë gápëll libertá. ");
INSERT INTO zacNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nanú tubi prësi namás më dushë, lë Barrabás. ");
INSERT INTO zacNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Iurë lëꞌë rall bëdëá rall ngaꞌli, Pilato gunaꞌbë diꞌdzë: ―¿Guadë narac shtuꞌu të guëdëꞌa libertá, Barrabás u Jesús nabërulë́ Cristo? ");
INSERT INTO zacNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato bëdëꞌë cuendë de quë rldënú rall Jesús nu mbidi na rall; por ni bëꞌnë rall intriegu lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mientras Pilato zúbëgaꞌa catë rúnëll juzguë, lëꞌë tseꞌlë Pilato gunibëꞌa naguanú rsunë: “Adë riutë́diꞌil con nguiu rëꞌ purquë më zaꞌquë náhiꞌ; neꞌ gueꞌlë guniꞌi shcaꞌlda tubi mbëcaꞌldë dushë de lëꞌë më. Adë gurëdchídiꞌi lduaꞌa.” ");
INSERT INTO zacNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Perë ra jëfë shtë ra bëshuzi nu më gushë guniꞌinú rall mënë parë guënaꞌbë rall libertá parë Barrabás nu guënaꞌbë rall gati Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Lëꞌë gubernadurë gunaꞌbë diꞌdzë stubi; répill: ―¿Guadë de chupë ra mënë rëꞌ rac shtuꞌu të guëdëꞌa libertá? Lëꞌë rall bëquebi: ―Barrabás. ");
INSERT INTO zacNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato gunaꞌbë diꞌdzë iurní: ―¿Pë rac shtuꞌu të guna con Jesús? el quë nabërulë́ Cristo. Grë́tëꞌ rall guniꞌi rall: ―Quëll lu cruz. ");
INSERT INTO zacNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Iurní Pilato guniꞌi: ―¿Pë mal bë́ꞌnëll? Perë lëꞌë rall bëabrí gurushtiá rall: ―Quëll lu cruz. ");
INSERT INTO zacNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Iurní Pilato guná hiadë nídiꞌi mudë lla gúnëll sino quë másruꞌu ziadalë mënë nu rdzatsu mënë. Iurní gunibëꞌa Pilato nisë, tsati guiáꞌall ziquë tubi sëñi de quë nápëdiꞌill faltë por galguti shtë Jesús. Gudíbill guiáꞌall; guníꞌill: ―Nádiaꞌa responsablë por galguti shtë nguiu rëꞌ purquë nápëdiꞌiꞌ faltë. Shcuendë të na ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Grë́tëꞌ ra mënë bëquebi: ―Lëꞌë naꞌa con shini naꞌa, na naꞌa responsablë por galguti shtë nguiu rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Iurní Pilato bëdë́ꞌëll libertá Barrabás. Lueguë gunibë́ꞌall guëdiaꞌa më galnë́, nu bëꞌnë Pilato intriegu lëꞌë më parë gac crucificar më. ");
INSERT INTO zacNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Iurní ra suldadë shtë gubernadurë, biaꞌa rall lëꞌë Jesús laꞌni palaci nu bëdëá grë́tëꞌ suldadë alrededurë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Gulú rall shabë më të parë guëgacu rall stubi lari guindë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bëzuꞌbë rall tubi corunë shtë guitsë guëc më. Bëdëꞌë rall tubi varë caꞌa më parë guꞌ guiaꞌa ladë ldi më. Iurní bëzullibi rall delantë lu më nu bëꞌnë rall burnë; guniꞌi rall: ―Guëbani Rëy shtë më israelitë. ");
INSERT INTO zacNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nu bëchiꞌbë shënë rall lu më nu gunaꞌzi rall varë parë rdëꞌë rall galnë́ guëc më. ");
INSERT INTO zacNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Despuësë de quëhunë rall burnë zni, bëdchisú rall lari guindë. Bëdëꞌë rall shabë më, gutë më stubi. Iurní biaꞌa rall lëꞌë më parë gac crucificar më. ");
INSERT INTO zacNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hia ziagruꞌu më parë ziazú më ruaꞌ guëꞌdchi, bëdzaꞌguëlú rall tubi nguiu, më Cirene nalë Simón. Iurní gunibëꞌa ra suldadë parë guaꞌa Simón cruz shtë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Zni bëdchini rall tubi lugar nalë Gólgota narunë cuntienë, Lugar shtë Calavera. ");
INSERT INTO zacNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ngaꞌli bëdëꞌë rall vini naná mescladë con naldá. Biiꞌdiꞌi mëhin, nadë más bëꞌnë më prë́bëhin. ");
INSERT INTO zacNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hia iurë gualú bëꞌnë rall crucificar lëꞌë më, ra suldadë gudchitë rall dado parë gudiꞌdzë rall shabë më. Zni guc cumplir lo quë naguniꞌi profetë; “Gudiꞌdzë rall shaba entrë mizmë lëꞌë rall nu gudchitë rall suertë guëc shaba”. ");
INSERT INTO zacNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Iurní guzubë rall ngaꞌli parë gapë rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Guiaꞌa guëc Jesús bëquëꞌë rall tubi letrërë narniꞌi pëzielú bëꞌnë rall condenar lëꞌë më. Letrërë ni rniꞌi: “Ndëꞌë na rëy shtë mënë israelitë. Lëll Jesús.” ");
INSERT INTO zacNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nu zac chupë ngubaꞌnë guc crucificar con lëꞌë më, túbill ladë ldi, stúbill ladë rubësë. ");
INSERT INTO zacNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Grë́tëꞌ nardëdë ngaꞌli, runë rall burnë, rniꞌbi rall guëc rall; ");
INSERT INTO zacNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","rniꞌi rall: ―Lë́ꞌël rníꞌil cuel iáduꞌu ruꞌbë nu dzë tsunë guëabrí guëzáꞌalin; bëꞌnë salvar mizmë lë́ꞌël talë nal shini Dios. Bëldaguë lë́ꞌël lu cruz. ");
INSERT INTO zacNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Zni zac bëꞌnë burnë ra jëfë shtë ra bëshuzi nu mësë shtë lëy con ra fariseo con grë ra më gushë shtë ciudá. Guniꞌi lu saꞌ rall: ");
INSERT INTO zacNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Bë́ꞌnëll salvar stubi mënë perë el mizmë lë́ꞌëll adë gúnëdiꞌill gan gúnëll salvar lë́ꞌëll. Si talë nall rëy shtë Israel, pues guëldáguëll lë́ꞌëll lu cruz të parë tsaldí lduꞌu hiaꞌa lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Pues rialdí ldúꞌull Dios; zuzull niaꞌa zunë Dios salvar lë́ꞌëll purquë rníꞌill: “Nahia shini Dios”. ");
INSERT INTO zacNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hashtë ra mizmë ngubaꞌnë naná quënú lëꞌë më lu cruz, bëꞌnë rall burnë; guniꞌi rall mizmë diꞌdzë ni guëc më. ");
INSERT INTO zacNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Iurní guëdubi guë́ꞌdchiliu bëcahi dizdë guëruldë dzë hashtë rquë tsunë guadzeꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Iurní fuertë guniꞌi Jesús: ―Elí, Elí, lama sabactani. Runë cuntienë diꞌdzë ni: Dios mio, Dios mio, ¿pëzielú bësáꞌnël na? ");
INSERT INTO zacNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bëldá mënë narëtaꞌ ngaꞌli, bini rall lo quë naguniꞌi më nu repi rall: ―Cagnáꞌbëll Elías. ");
INSERT INTO zacNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mizmë iurní tubi de lëꞌë rall guagllúꞌnëll; guagllíꞌill tubi spongë nu bëgáꞌdzëll spongë con vini hiꞌ. Iurní bëzúꞌbëll spongë guëc tubi varë të parë gu më vini. ");
INSERT INTO zacNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Perë sëbëldá mënë guniꞌi: ―Cha bézaꞌa; guëná hiaꞌa nia zidë Elías të parë guësiétiꞌ lë́ꞌëll lu cruz. ");
INSERT INTO zacNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iurní stubi vueltë guniꞌi Jesús fuertë; iurní guti më. ");
INSERT INTO zacNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mizmë iurní lëꞌë cortinë shtë iáduꞌu gureꞌzin; guc chupë ldëhin dizdë guiaꞌa hashtë guetë. Nu lëꞌë guë́ꞌdchiliu bëllú. Ra dani gureꞌzë. ");
INSERT INTO zacNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ra baꞌa bëllaꞌlë hashtë guashtë́ zihani tëgulë, ra mënë nagualdí lduꞌi shtiꞌdzë Dios antsë. ");
INSERT INTO zacNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Grë ra më rëꞌ, bëruꞌu ra laꞌni baꞌa nu despuësë de guashtë́ Jesús ladi ra tëgulë, guatë́ raiꞌ ciudá Jerusalén. Cantidá mënë guná lu mënë ni. ");
INSERT INTO zacNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Iurní lëꞌë capitán nu ra nagupë cuerpë shtë Jesús, iurë guná rall llu, nu guná rall cusë naguzac ngaꞌli, nalë́ bëdzëbë rall; repi lu saꞌ rall: ―De verdá nguiu rëꞌ náhiꞌ shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Cantidá naꞌa zu rall ngaꞌli; gubiꞌa rall dizdë zitu. Naꞌa ni guanaldë rall lëꞌë Jesús antsë dizdë Galilea. Bëꞌnë rall compañi lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Entrë ra naꞌa ni nanú María Magdalena nu María shniꞌa Jacobo nu shniꞌa José. Nu zugaꞌa shniꞌa ra shini Zebedeo. ");
INSERT INTO zacNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Hia iurë riuꞌ gueꞌlë, bëdchini tubi nguiu ricu lë José. Nall më guëꞌdchi Arimatea nu zac nall shmënë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","José guagnall lëꞌë Pilato nu gunáꞌbëiꞌ cuerpë shtë Jesús. Pilato gunibëꞌa parë guëdëꞌë mënë cuerpë caꞌa José. ");
INSERT INTO zacNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Biaꞌa José cuerpë shtënë më nu bëtúꞌbill cuerpë tubi sabë naquichi. ");
INSERT INTO zacNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Iurní guacáꞌchiꞌ lëꞌë Jesús laꞌni tubi baꞌa cubi nabëdaꞌni hia más antsë laꞌni guëꞌë shtë dani. Despuësë de gualú bëgaꞌchi më, iurní bësëꞌau José ruaꞌ baꞌa con tubi guëꞌë ruꞌbë. Hia iurní zëagzë́ José. ");
INSERT INTO zacNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ngaꞌli quëbezë María Magdalena nu stubi María, Zúbëgaꞌa raiꞌ ruaꞌ baꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Brëgueꞌlë stubi dzë, quiere decir despuësë ra preparación shtë dzë narziꞌi lduꞌu mënë, ra jëfë shtë ra bëshuzi nu ra fariseo, gua rall lu Pilato; ");
INSERT INTO zacNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","guniꞌi rall: ―Dadë, rëagná lduꞌu naꞌa de quë lëꞌë nguiu bishi guníꞌill iurë nabánill de quë despuësë de tsunë dzë, gac resucitárëll ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Por ni gunibëꞌa të parë gac segurë baꞌa hashtë dzë tsunë të parë tsádiꞌi ra mënë shtë́nëll gueꞌlë parë tsaldanë rall cuerpë. Nu despuësë guëniꞌi rall lu mënë de quë guc resucitar Jesús ladi ra tëgulë. Zni lúltimë bishi rëꞌ nahin más peor quë ra bishi naguniꞌi Jesús antsë. ");
INSERT INTO zacNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato repi: ―Lëꞌë të napë të guardë shtë ra suldadë. Gulë tsaguëꞌnë segurë ruaꞌ baꞌa, mejurë lo quë narac shtuꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Iurní ziaꞌa rall; bëꞌnë rall segurë ruaꞌ baꞌa nu bëquëꞌë rall tubi sëgi lu guëꞌë nanadaꞌu ruaꞌ baꞌa. Nu bësëaꞌnë rall guardë shtë ra suldadë. ");
INSERT INTO zacNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Iurë dzë narziꞌi lduꞌu mënë hia guaꞌa, hia zia grëgueꞌlë primërë dzë shtë llmalë, María Magdalena nu stubi María, guagná rall ruaꞌ baꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Perë dizdë lueguë bëdchini tubi llu ruꞌbë lu guë́ꞌdchiliu; lëꞌë ianglë shtë Dadë Dios zeꞌdë de gubeꞌe. Bëdchíniꞌ ruaꞌ baꞌa. Bëdchisúhiꞌ guëꞌë nanadaꞌu ruaꞌ baꞌa. Nu guzúbiꞌ guëc guëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nalë́ rabtsëꞌë ianglë ni cumë ziquë nguziꞌu. Nu shábiꞌ naquichi cumë ziquë nievë. ");
INSERT INTO zacNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Iurë guná ra suldadë lu llu, iurní bëdzëbë rall; bëaꞌnë rall ziquë tubi naguti. ");
INSERT INTO zacNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Iurní lëꞌë ianglë guniꞌi lu ra naꞌa: ―Adë rdzë́bëdiꞌi të. Na rac bë́ꞌahia de quë quëguili të Jesús, më nacuë́ lu cruz. ");
INSERT INTO zacNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Perë adë nídiꞌi më ndëꞌë. Guc resucitáriꞌ cumë guniꞌi më lu të antsë. Gulë teꞌe të guëná të lugar catë bëcaꞌchi ra mënë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gulë tsa; gulë guchi lu ra shini gusëꞌdë më quë lëꞌë më guti perë guc resucitáriꞌ. Nu lëꞌë më tsáhiꞌ Galilea antsë guëdchini të ndë. Ndë guëná të lu më. Ni na lo quë narniaꞌa lu të. ");
INSERT INTO zacNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Iurní lëꞌë ra naꞌa nasesë bëruꞌu raiꞌ ruaꞌ baꞌa perë nalë́ bëdzëbë raiꞌ. Mizmë tiempë bëquitë lduꞌu raiꞌ. Guaglluꞌnë raiꞌ të guëniꞌinú raiꞌ shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mizmë iurní Jesús bëluaꞌalú më lu ra naꞌa nu bëꞌnë më saludar lëꞌë rall. Iurní guabiꞌguë ra naꞌa lu më; bëꞌnë raiꞌ adorar lëꞌë më. Gudëdchi raiꞌ guëaꞌ më. ");
INSERT INTO zacNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Perë Jesús repi: ―Adë rdzë́bëdiꞌi të. Gulë tsaguëꞌnë visi los de más bëcha të parë tsa raiꞌ Galilea. Ndë guëná raiꞌ lua. ");
INSERT INTO zacNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mientras zëagzë́ ra naꞌa, bëldá suldadë shtë guardë gua rall ciudá. Guaguëchi rall lu jëfë shtë ra bëshuzi grë́tëꞌ lo quë naguc. ");
INSERT INTO zacNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Iurní ra jëfë guagniꞌi lu ra më gushë parë guc rall de acuerdë; iurní bëdëꞌë rall zihani dumí cuaꞌa ra suldadë. ");
INSERT INTO zacNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Repi rall: ―Gulë guniꞌi de quë durantë laꞌni gueꞌlë mientras lëꞌë të nagaꞌsi të, ra shmënë Jesús bidë ldanë rall cuerpë shtë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Talë lëꞌë gubernadurë gac bë́ꞌall lo quë naguc, lëꞌë naꞌa guëniꞌinú naꞌa lëꞌë gubernadurë të parë guëzalú naꞌa grë ra dificultá parë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Iurní ra suldadë bëꞌnë rall recibir dumí nu guaguëꞌnë rall lo quë naguniꞌi jëfë shtë ra bëshuzi lu rall. Bishi ni na lo quë naruadiꞌdzë ra më israelitë hashtë iurneꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Zni guc; ra guëzá chiꞌbë tubi ra shini gusëꞌdë më ziaꞌa raiꞌ parë Galilea hashtë tubi dani catë guniꞌi Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Iurë guná raiꞌ lu më, bëꞌnë raiꞌ adorar lëꞌë më aunquë bëldá raiꞌ bëzá lduꞌu raiꞌ. Gualdídiꞌi lduꞌu raiꞌ guashtë́ më ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iurní Jesús guabíꞌguiꞌ lu raiꞌ; repi më: ―Grë pudërë bëneꞌe Dios parë guënibë́ꞌahia gubeꞌe nu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gulë tsa guëdubi naciuni. Gulë bëꞌnë lëꞌë rall shmëna. Gulë bëchuꞌbë nisë lëꞌë rall iurë rialdí lduꞌu rall shtiꞌdza. Gulë bëchuꞌbë nisë lëꞌë rall por lë shtënë Dadë Dios, nu por lëa, nu por Espíritu Santo. ");
INSERT INTO zacNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Gulë bëluaꞌa të gunë ra mënë cumplir grë diꞌdzë nagunibë́ꞌahia lëꞌë të. Nu gulë bëdëꞌë cuendë de quë na quëbezënúa lëꞌë të grë́tëꞌ dzë hashtë fin shtë guë́ꞌdchiliu. Amén.");
INSERT INTO zacNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Zndëꞌë guzublú dizaꞌquë shtë Jesucristo, shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Guzubluhin según nabëquëꞌë Isaías, el quë nabiadiꞌdzë shtiꞌdzë Dios guahietë. Bëquëꞌë Isaías shtidzë Dios narniꞌi shcuendë Jesucristo: Gulë guná, guësheꞌlda tubi shmuza naguëniꞌi por na delantë lul. Lë́ꞌiꞌ gúniꞌ preparar lduꞌu mënë antsë tsagniꞌinul lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mënë ni guëníꞌiꞌ lu tubi shlatë ruꞌbë. Fuertë guëníꞌiꞌ parë guini grë mënë shtíꞌdziꞌ. Guëníꞌiꞌ lu ra mënë: “Gulë bëꞌnë preparar laꞌni lduꞌu të ziquë nezë ldi të parë iurë guëdchini Dadë”. ");
INSERT INTO zacNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Por ni Juan bëchuꞌbë nísiꞌ; lugar ni adë nídiꞌi mënë catë naquë́ guëëꞌgu Jordán. Guniꞌinúhiꞌ lëꞌë ra mënë chubë nisë rall ziquë sëñi de quë runë nadzëꞌë rall mudë nanabani rall nu guëabrí lduꞌu rall con Dios parë gunë Dios perdunë duldë shtë rall. ");
INSERT INTO zacNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Grë́tëꞌ ra mënë shtë regiuni Judea nu ra më Jerusalén bëdchini rall lu Juan parë chubë nisë rall. Iurë bëshuꞌbë duldë rall lu Dios, iurní Juan bëchuꞌbë nísiꞌ lëꞌë ra mënë laꞌni guëëꞌgu Jordán. ");
INSERT INTO zacNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nacu Juan tubi lari nanactsaꞌu con guitsë ladi camellë nu lliꞌi láꞌniꞌ tubldë́ guiꞌdi. Ráuhiꞌ shanchi nu dchini shtë ra mbeeꞌzë lachi. ");
INSERT INTO zacNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Guniꞌi Juan shtiꞌdzë Dios lu ra mënë: ―Zeꞌdë stubi më más lasac quë na. Na adë lasáquëdiaꞌa parë lëꞌë më. Ni tubi adë chu nádiaꞌa parë guëshaca du guiꞌdi shtënë shrachi më. ");
INSERT INTO zacNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na bëchuꞌbë nisa lëꞌë të con nisë perë lëꞌë më gunë më stubi cusë namás cusë ruꞌbë. Guëzunë́ më lduꞌu të nu guëneꞌe më Espíritu Santo parë cuezënúhiꞌ laꞌni lduꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Gudëdë sëbëldá dzë, iurní bëruꞌu Jesús guëꞌdchi Nazaret nanaquë́ regiuni Galilea. Juan bëchuꞌbë nísiꞌ lëꞌë Jesús laꞌni guëëꞌgu Jordán. ");
INSERT INTO zacNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iurë bëruꞌu më laꞌni nisë, mizmë iurní bëllaꞌlë lu gubeꞌe hashtë guná më catë quëbezë Dios. Guná më lu Espíritu Santo; bëdchíniꞌ ziquë tubi palumë parë cuezënúhiꞌ lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nu bëruꞌu tubi diꞌdzë nezë lu gubeꞌe naguniꞌi: ―Ndëꞌë lëꞌë shinia. Nalë́ rac shtuaꞌa lë́ꞌiꞌ. Nalë́ rquitë lduaꞌa rnahia lúhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Iurní Espíritu Santo biaꞌa lëꞌë Jesús lu tubi shlatë nezë cuꞌ dani. ");
INSERT INTO zacNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ndë guquëreldë më cuarenta dzë. Ngaꞌli guc shtuꞌu mëdzabë Satanás niasiguë́ lëꞌë më parë guëniti më shnezë më. Guquëreldë më ladi ra ma dushë. Despuësë bëdchini ra ianglë parë bëꞌnë raiꞌ sirvë lu më. ");
INSERT INTO zacNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Despuësë de bëtiaꞌa ra mënë Juan Bautista lachiguiꞌbë, bëabrí Jesús regiuni Galilea. Cagniꞌi më dizaꞌquë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Repi më: ―Lëꞌë tiempë hia guc cumplir; bëgaꞌa iurë parë guënibëꞌa Dios ziquë rëy. Gulë bëabrí lduꞌu të lu Dios nu gulë tsaldí lduꞌu të shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Gudëdë Jesús guëllaꞌ ruaꞌ nisë ruꞌbë nalë Galilea. Guná më lu Simón nu bë́chiꞌ Andrés. Cagldaguë raiꞌ guëꞌshu laꞌni nisë. Na raiꞌ pescadurë shtë mbeldë. ");
INSERT INTO zacNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Repi më lu raiꞌ: ―Gulë gudeꞌe naldë na; na guënehia dchiꞌni gunë të. Ziquë na të pescadurë; guna lëꞌë të pescadurë shtë mënë; gueꞌdënú të mënë lua. ");
INSERT INTO zacNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Lueguë bësëaꞌnëgá raiꞌ guëꞌshu nu guanaldë raiꞌ lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Gudëdë më stuꞌpë más delantë; guná më lu Jacobo, llgaꞌnë Zebedeo. Guná më lu Juan, bëchi Jacobo. Quëhunë raiꞌ rumiendë guëꞌshu; zubë raiꞌ laꞌni barcu shtë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Lueguë Jesús gunaꞌbë lëꞌë raiꞌ. Iurní guanaldë raiꞌ lëꞌë më. Bësëaꞌnëgá raiꞌ shtadë raiꞌ, Zebedeo; zubënú Zebedeo ra muzë laꞌni barcu. ");
INSERT INTO zacNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Guatë́ raiꞌ guëꞌdchi Capernaum. Tubi dzë nabëziꞌi lduꞌu mënë, bëluaꞌa Jesús lëꞌë ra mënë laꞌni iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Guasë́ lduꞌu mënë por lo quë naguniꞌi Jesús lu rall. Bëluaꞌa më enseñansë shtë́hiꞌ ziquë tubi nanapë pudërë, lë́dëdiꞌi ziquë ra mësë narluaꞌa lëy shtë Moisés. ");
INSERT INTO zacNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","De repëntë zugaꞌa tubi nguiu laꞌni iáduꞌu. Nanú tubi mëdzabë fier laꞌni lduꞌu nguiu ni; biadíꞌdzëll guëc lalú. Guníꞌill fuertë: ");
INSERT INTO zacNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Ja, ¿pë nápël con na? lë́ꞌël Jesús. Guëꞌdchi shtë́nël lë Nazaret. ¿Pëllë zéꞌdël parë guënítil lëꞌë naꞌa? Na nanë́a chu nal; nal limpi ldúꞌul delantë lu Dios. Bëdchínil de Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús guniꞌi fuertë lu mëdzabë: ―Guitsëgá nu bëruꞌu de lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Iurní lëꞌë mëdzabë fier nalë́ bëséꞌsëll lëꞌë nguiu. Gurushtiall; bërúꞌull laꞌni lduꞌu nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Grë mënë guasë́ lduꞌu rall. Guniꞌi lu saꞌ rall: ―¿Pëllë ndëꞌë? ¿Pëllë ldaiꞌ cubi rëꞌ? Napë Jesús autoridá hashtë ra mëdzabë rzuꞌbë diaguë rall shtiꞌdzë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Por guëdubi nezë shtë Galilea bërëꞌtsë diꞌdzë nabëꞌnë Jesús. Nasesë bërëꞌtsë famë shtë më. ");
INSERT INTO zacNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Lueguë bëruꞌu më laꞌni iáduꞌu. Ziazunú më Jacobo nu Juan; bëdchini raiꞌ lidchi Simón nu Andrés. ");
INSERT INTO zacNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Suëgrë Simón nagáꞌaiꞌ lu camë; ráquëll shldi ruꞌbë. Lueguë guniꞌi ra mënë lu Jesús pë cusë cazac nanë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iurní bëdchini më; gunaꞌzi më guiaꞌa naꞌa nu bëldishtë́ më lë́ꞌëll. Guashtëll; lueguë bëruꞌu shldill. Iurní bëꞌnë naꞌa ni sirvë lu raiꞌ nagáu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mizmë dzë iurë nabëlaguetë ngubidzë, hia guadzeꞌ, zihani mënë biaꞌa raiꞌ saꞌ raiꞌ lu Jesús, ra nanapë galguidzë nu ra nanapë mëdzabë laꞌni lduꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Grë́tëꞌ ra mënë shtë guëꞌdchi, bëteꞌe saꞌ rall ruaꞌ hiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús bënëac zihani rall de grë clasë galguidzë. Bëgú më zihani mëdzabë laꞌni lduꞌu rall. Adë bëdë́ꞌëdiꞌi më permisi ra mëdzabë parë nianiꞌi rall purquë bënguë bëꞌa rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Guashtë́ më tumpranë nianá nacahi. Ziaꞌa më shlatë catë nídiꞌi mënë. Ndë guniꞌinú më Dios, Shtadë më. ");
INSERT INTO zacNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Iurní lëꞌë Simón con ra sáhiꞌ guatili raiꞌ lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Iurë bëdzelë raiꞌ lëꞌë më, guniꞌi raiꞌ: ―Zihani mënë zeꞌdë tili lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Guchi më lu raiꞌ: ―Cha guiá hiaꞌa ra guëꞌdchi naquë́ guëllaꞌ. Guëdiaꞌa diꞌdzënú hiaꞌa lëꞌë rall shtiꞌdzë Dios; parë ni zelda. ");
INSERT INTO zacNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iurní gua më grë nezë Galilea; rniꞌi më dizaꞌquë shtë Dios laꞌni iáduꞌu shtë ra mënë israelitë. Bëgú më mëdzabë laꞌni lduꞌu ra nanapë mëdzabë. ");
INSERT INTO zacNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Bidë tubi nguiu narac galguidzë naruꞌdzë ládiꞌ. Bëzullíbill lu më; bë́ꞌnëll ruëguë lu më; répill: ―Nápël pudërë; si talë nápël voluntá guëzunël ladia; guëaca. ");
INSERT INTO zacNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Bëgaꞌa lduꞌu Jesús lë́ꞌëll. Bëdchiꞌbë më guiaꞌa më guë́quëll nu repi më: ―Rac shtuaꞌa; guëac galguidzë shtë́nël. ");
INSERT INTO zacNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Despuësë de guniꞌi më ra diꞌdzë ni, lueguë lëꞌë galguidzë bësaꞌnë lë́ꞌëll. Bëáquëll. ");
INSERT INTO zacNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bëꞌnë më incarguë lull ni tubi adë chu lu guadíꞌdzëll. Repi më: ");
INSERT INTO zacNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Adë chu lu ruadíꞌdzëdiꞌil. Guagluaꞌa lë́ꞌël lu bëshuzi. Bëꞌnë cumplir lo quë naguniꞌi Moisés. Bëdëꞌë ofrendë lu Dios parë gac guëdëꞌë mënë cuendë de quë hia bëáquël. ");
INSERT INTO zacNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Perë iurë zëagzëll, guzublú biadíꞌdzëll lo quë nabëꞌnë Jesús de manërë de quë Jesús adë guc më niadchini më guëꞌdchi rëꞌ tantë mënë gulezë rall lëꞌë më. Bëaꞌnë më fuërë shtë guëꞌdchi catë nídiꞌi mënë. Zihani mënë beꞌdë guëdchini rall lu më de grë ladë guëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gudëdë bëldá dzë, Jesús guatë́ stubi vueltë guëꞌdchi Capernaum. Bini ra mënë quëreldë më lidchi më. ");
INSERT INTO zacNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Lueguë bëdëá zihani mënë hashtë gúldëdiꞌi ruaꞌ hiuꞌu niutë́ ra mënë. Cagniꞌi më shtiꞌdzë Dios lu rall. ");
INSERT INTO zacNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Iurní bidë tapë nguiu; nuaꞌa rall tubi daaꞌ catë nanú tubi narac galguidzë llunguë. ");
INSERT INTO zacNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Por tantë mënë adë guc niadchininú rall narac lluꞌu lu më. Iurní gudidë rall guëc hiuꞌu parë bëldaguë rall daaꞌ delantë lu më. ");
INSERT INTO zacNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Guná më rialdí lduꞌu rall lëꞌë më; iurní repi më lu narac lluꞌu: ―Dadë, runa perdunë duldë shtë́nël. ");
INSERT INTO zacNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Laꞌni hiuꞌu rëꞌ zubë bëldá mësë narluaꞌa lëy; nalë́ runë rall llgabë laꞌni lduꞌu rall; rniꞌi rall: ");
INSERT INTO zacNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Pëzielú rniꞌi Jesús diꞌdzë rëꞌ? Nablac rúnëll ofender Dios purquë sulë Dios napë pudërë gunë më perdunë duldë, lëdë núdiꞌi lë́ꞌëll.” ");
INSERT INTO zacNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Guc bëꞌa Jesús pë cagniꞌi rall; repi më lu rall: ―¿Pëzielú runë të llgabë zniꞌi? ");
INSERT INTO zacNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Pë más sencigi guëniaꞌa lu narac lluꞌu: “Naperdunë duldë shtë́nël” u guëniaꞌa lull: “Guasuldí nu bëagzë́”? ");
INSERT INTO zacNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Parë gac bëꞌa të na nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu nu napa pudërë parë guna perdunë duldë shtë mënë. Iurní guniꞌi më lu narac galguidzë llunguë: ");
INSERT INTO zacNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Guashtë́ nu bëtëá shtaaꞌl. Bëagzë́ lídchil. ");
INSERT INTO zacNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Lueguë guashtëll nu bëldísëll shtaaꞌll. Bërúꞌull lu grë nacabezë lugar ni. Guasë́ lduꞌu mënë; guniꞌi rall llëruꞌbë na pudërë shtë Dios. Nu guniꞌi rall: ―Nunquë láꞌadiꞌi guná hiaꞌa cusë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Gua Jesús stubi vueltë ruaꞌ nisë ruꞌbë. Zihani mënë guabiꞌguë rall lu më nu bëluaꞌa më lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Iurë gudëdë më nezë, guná më lu Leví, shini Alfeo. Leví zúbëgaꞌa lu banju catë riatilli mënë impuestë. Guniꞌi më lu Leví: ―Gudeꞌe naldë na. Lueguë guasuldí Leví nu guanáldëll lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Iurë nanú Jesús lidchi Leví, zubënú më shini gusëꞌdë më con zihani ra narunë cubrë impuestë. Nu zubë ra pecadurë nanadë runë cumplir ra custumbrë shtë mënë religiusë. Zihani mënë guanaldë rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Iurní ra mësë narluaꞌa lëy con ra fariseo, gunaꞌbë diꞌdzë rall lu ra shini gusëꞌdë më: ―¿Pëzielú mësë shtë të quëhaunull ra pecadurë nu con ra narunë cubrë impuestë? ");
INSERT INTO zacNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Bini më lo quë naguniꞌi rall; repi më: ―Ra narac lluꞌu rquiꞌni rall tubi ducturë perë el quë nabëráquëdiꞌi, adë rquíꞌnidiꞌill ducturë. Zeldë guënaꞌba gac salvar ra mënë mal të guëabrí lduꞌu rall con Dios; adë zeldë guënáꞌbëdiaꞌa mënë narniꞌi mënë zaꞌquë na rall. ");
INSERT INTO zacNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Guzac iurë ra shini gusëꞌdë Juan nu ra shini gusëꞌdë fariseo bëꞌnë rall ayunë, bëdchini bëldá mënë lu Jesús nu gunaꞌbë diꞌdzë rall: ―¿Pëzielú ra shini gusëꞌdë Juan nu ra shini gusëꞌdë fariseo quëhunë rall ayunë; adë ráudiꞌi rall? perë shini gusë́ꞌdël rau rall; quëhúnëdiꞌi rall ayunë. ");
INSERT INTO zacNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Guniꞌi Jesús lu rall: ―¿Ni mudë gunë të obligar ra invitadë shtë saꞌa gunë rall ayunë mientras cabezënú lliguë lëꞌë rall? Si talë cabezënú lliguë lëꞌë rall, adë rúnëdiꞌi rall ayunë. ");
INSERT INTO zacNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Perë guëdchini dzë hiadë cuézëdiꞌi lliguë entrë lëꞌë rall; iurní gunë rall ayunë. ");
INSERT INTO zacNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Ni tubi chu rúnëdiꞌi rumiendë lu lari gushë con lari cubi purquë si talë guëguëuꞌl lari cubi lu lari gushë, más nasesë rcheꞌzë lari cubi lëꞌë lari gushë. Iurní más fier rluaꞌa rumiendë ni. ");
INSERT INTO zacNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ni tubi adë rgutsaꞌu vini cubi laꞌni bulsë guiꞌdi gushë. Adë gúnëdiꞌi gan bulsë gushë lu fuersë shtë vini cubi. Rcheꞌzë vini cubi lëꞌë bulsë gushë nu lëꞌë vini guëllëꞌin lu guiuꞌu. Hia lëꞌë bulsë adë rlluíꞌidiꞌin. Rquiꞌni tsutsaꞌu vini cubi laꞌni bulsë cubi. ");
INSERT INTO zacNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tubi dzë descansë gudëdë Jesús con ra shini gusëꞌdë më catë nanú trigu. Ra shini gusëꞌdë më caniashi raiꞌ duꞌu shtë trigu të gau raiꞌ bëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Iurní ra fariseo guniꞌi rall lu Jesús: ―¿Pëzielú runë rall lo quë naná providë quëhunë mieti dzë narziꞌi lduꞌu mënë? ");
INSERT INTO zacNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús bëquebi: ―¿Pë adë biꞌldi të lo quë nabëꞌnë David guahietë con ra narianaldë të́chiꞌ? Nápëdiꞌi raiꞌ pë gau raiꞌ nu rldiaꞌnë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Guatë́ David lidchi Dios. Dzë ni Abiatar na jëfë shtë ra bëshuzi. Gunaꞌzi David guetështildi naná sagradë; ni tubi adë chu rau guetështildi ni, sulë niétiquë bëshuzi. Perë David bëdëꞌë guetështildi ni cuaꞌa ra nacanaldë lë́ꞌiꞌ; gudáu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nu guniꞌi më lu ra fariseo: ―Dios bëdëꞌë dzë descansë parë bien shtë nguiu të guëziꞌi lduꞌu raiꞌ. Adë bë́ꞌnëdiꞌi Dios formar lëꞌë nguiu niétiquë parë gunë rall cumplir custumbrë shtë dzë descansë. ");
INSERT INTO zacNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu; napa derechë guënibë́ꞌahia pë cusë gunë mieti dzë descansë. ");
INSERT INTO zacNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Guzac tubi dzë narziꞌi lduꞌu mënë, guatë́ Jesús laꞌni iáduꞌu. Ndë zugaꞌa tubi nguiu nagubidchi guiáꞌaiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Quëgldaꞌchi ra fariseo lëꞌë më, nia zunë më rumëdi dzë descansë parë guëdchiꞌbë rall demandë cuntrë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús guniꞌi lu nguiu nagubidchi guiáꞌaiꞌ: ―Gudeꞌe ndëꞌë nu guasuldí ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Guniꞌi më lu ra nacagldaꞌchi: ―Según lëy shtë Dios, ¿pë runë tucarë gunë nguiu dzë narziꞌi lduꞌu mieti? ¿Gunë nguiu bien u gunë nguiu mal; zúnëll rumëdi nguiu u zësáꞌnëll gati nguiu? Perë lëꞌë contrari shtë më adë pë guníꞌidiꞌi rall. ");
INSERT INTO zacNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Guná më lu grë rall; bëldë́ më; gulaguë tristë laꞌni lduꞌu më por tantë naguëdchi lduꞌu rall. Iurní guniꞌi më lu nguiu narac lluꞌu: ―Bëldí guiáꞌal. Iurní bëldill guiáꞌall. Lueguë bëac guiáꞌall. ");
INSERT INTO zacNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nasesë bëruꞌu ra fariseo. Guzublú gunaꞌbë diꞌdzë rall lu ra naná partidë shtë Herodes lla gunë rall parë gati Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iurní bëruꞌunú Jesús ra shini gusëꞌdë më; bëdchini raiꞌ ruaꞌ nisë ruꞌbë. Guanaldë zihani mënë shtë regiuni Galilea. ");
INSERT INTO zacNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Iurë bini ra mënë ra milagrë nabëꞌnë Jesús, guagná rall lëꞌë më. Mënë shtë Jerusalén nu mënë shtë regiuni Idumea nu regiuni Judea, bëdchini rall. Mënë naquëreldë stubi ladë ruaꞌ guëëꞌgu Jordán nu ra mënë shtë regiuni Tiro nu Sidón bëdchini rall të guëná rall lu Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Por ni gunibëꞌa Jesús lu ra shini gusëꞌdë më gac preparadë tubi barcu lu nisë parë tsu më laꞌnin parë adë guëtéꞌediꞌi mënë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Zihani mënë bëdchini purquë antsë bënëac më zihani narac lluꞌu. Iurní grë́tëꞌ narac lluꞌu, beꞌdë guëteꞌe rall lëꞌë më parë bëgaꞌldë rall shabë më. ");
INSERT INTO zacNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Iurë ra nanapë mëdzabë laꞌni lduꞌi guná rall lu Jesús, bëzullibi rall lu më. Gurushtiá rall; guniꞌi rall: ―Nal lúniquë shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Perë Jesús nalë́ bëꞌnë më incarguë lëꞌë rall adë guadíꞌdzëdiꞌi rall chu na më. ");
INSERT INTO zacNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Laꞌni ra dzë ni güeꞌpi Jesús lu dani. Gunaꞌbë më ra naguc shtuꞌu më parë gulezënú raiꞌ lëꞌë më. Bëdchini raiꞌ lu më. ");
INSERT INTO zacNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Gudili më chiꞌbë chupë nguiu parë sënú raiꞌ lëꞌë më nu parë tsagniꞌinú raiꞌ mënë shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Bëdëꞌë më pudërë lëꞌë raiꞌ parë guëgú raiꞌ mëdzabë laꞌni lduꞌu mënë, nu bëdëꞌë më pudërë gunëac raiꞌ narac lluꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Zndëꞌë lë ra shini gusëꞌdë më. Primërë poshtë lë Simón; bëdëꞌë më stubi lë́hiꞌ, Pedro. ");
INSERT INTO zacNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Nu bëꞌnë më nombrar Jacobo nu Juan; rac bëchi raiꞌ; shtadë raiꞌ lë Zebedeo. Bëdëꞌë më stubi lë raiꞌ parë Juan nu Jacobo naná Boanerges narunë cuntienë shini nguziꞌu purquë runë raiꞌ tubi cusë tubi chupëgá. ");
INSERT INTO zacNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","En seguidë bëꞌnë më nombrar Andrés, nu Felipe, nu Bartolomé, nu Mateo, nu Tomás, nu Jacobo naná shini Alfeo. También bëꞌnë më nombrar Tadeo nu Simón nanapë llëruꞌbë ánimo parë lëy. ");
INSERT INTO zacNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Nu bëꞌnë më nombrar Judas Iscariote nabëꞌnë intriegu lëꞌë Jesús más despuësë. Despuësë de ni, guatë́ më lidchi më. ");
INSERT INTO zacNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Stubi vueltë bëdëá zihani mënë hashtë adë gúquëdiꞌi niháu Jesús con ra shini gusë́ꞌdëiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Iurní bini shfamili Jesús ra cusë nabëꞌnë më; bëdchini raiꞌ parë guaꞌa raiꞌ lëꞌë më la fuersë purquë rniꞌi mënë rac luguë më. ");
INSERT INTO zacNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nu ra mësë narluaꞌa lëy bëdchini rall de Jerusalén; guniꞌi rall: ―Napë Jesús mëdzabë laꞌni ldúꞌiꞌ. Rgull ra mëdzabë por pudërë shtë Beelzebú naná jëfë shtë los de más mëdzabë. ");
INSERT INTO zacNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iurní gunaꞌbë Jesús lëꞌë ra mësë. Guniꞌi më tubi comparaciuni lu rall: ―¿Acasë guëgú Satanás mizmë lë́ꞌëll? ");
INSERT INTO zacNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Si talë guëruldë shmënë gubiernë rdildi rall cuntrë mizmë gubiernë, tsalú gubiernë. ");
INSERT INTO zacNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nu si talë nadivididë tubi famili, guëdchini tiempë tsalú famili ni. ");
INSERT INTO zacNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nu zac, si talë Satanás nadivididë mizmë shmë́nëll, tsalú pudërë shtë́nëll; hia bëgaꞌa fin shtë́nëll. ");
INSERT INTO zacNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ni tubi chu adë gac tsutë́ lidchi tubi nguiu putëntë të parë guëgull pë shtë më putëntë sino quë primërë napë quë guëldíꞌbill nguiu putëntë; iurní sí, gúnëll gan guëgull pë shtë nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Guldía rniaꞌa lu të de quë zac perdunë grë duldë shtë ra nguiu nu grë́tëꞌ diꞌdzë narniꞌi rall cuntrë shini Dios ");
INSERT INTO zacNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","perë si talë guëniꞌi mënë diꞌdzë mal cuntrë Espíritu Santo, ni sí, jamás nídiꞌi perdunë parë nguiu ni. Nall culpablë parë guëdubi tiempë; adë nídiꞌi fin shtë́nëll. ");
INSERT INTO zacNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Zni guniꞌi më purquë guniꞌi ra mënë napë më mëdzabë laꞌni ldúꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iurní lëꞌë shniꞌa më con ra bë́chiꞌ, bëdchini raiꞌ catë cabezë më. Gulezë raiꞌ tëchi fuërë; bësheꞌldë raiꞌ tubi mënë naguagnaꞌbë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ra mënë narëtaꞌ alrededurë lëꞌë më guniꞌi: ―Lëꞌë shníꞌal nu ra bë́chil zugaꞌa rall tëchi fuërë. Rac shtuꞌu rall guadiꞌdzënú rall lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Repi më lu ra mënë ni: ―¿Chull na shníꞌahia; chull na bëcha? ");
INSERT INTO zacNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Guná më lu grë ra narëtaꞌ alrededurë lëꞌë më nu guníꞌiꞌ: ―Ra nazubënú na ndëꞌë, ni na shníꞌahia nu ni na bëcha ");
INSERT INTO zacNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","purquë grë ra narzuꞌbë diaguë shtiꞌdzë Dios, ni na bëcha; nall zana; nall shníꞌahia. ");
INSERT INTO zacNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Stubi vueltë guzublú cagluaꞌa më ra mënë ruaꞌ nisë ruꞌbë. Mënë zihani bëdchini rall lu më, por ni guatë́ më laꞌni tubi barcu; guzubë më laꞌnin lu nisë. Grë mënë cabezë rall ruaꞌ nisë lu guiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Bëluaꞌa më lëꞌë rall zihani cusë por comparaciuni. ");
INSERT INTO zacNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Guniꞌi më: ―Gulë bëquë́ diaguë. ");
INSERT INTO zacNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tubi nguiu guagtë́ꞌtsëll bëꞌdchi. Duꞌpë bëꞌdchi gulaguë lu guiuꞌu nezë. Iurní lueguë bëdchini ra maꞌñi; gudáu maꞌñi bëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Stuꞌpë bëꞌdchi gulaguë lu guiuꞌu guëꞌë catë duꞌpë guiuꞌu nanú. Lueguë gutsëlú bëꞌdchi purquë adë ni zihani guiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Iurë bëruꞌu ngubidzë, güeꞌqui plantë purquë nápëdiꞌin llëruꞌbë shluꞌchin. Gubidchin. ");
INSERT INTO zacNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Stubi partë bëꞌdchi gulaguë lu guiꞌlli guitsë; gualdanin laꞌni guiꞌlli guitsë perë guiꞌlli guni guëquin; adë bëdë́ꞌëdiꞌin nashi. ");
INSERT INTO zacNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Stubi partë bëꞌdchi gulaguë lu guiuꞌu zaꞌquë. Gualdanin; guaruꞌbin. Bëldá bëꞌdchi bëdëꞌë galdë bi chi por tubin. Stubin bëdëꞌë sesenta por tubin. Stubin bëdëꞌë tubi gahiuꞌa por tubin. ");
INSERT INTO zacNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iurní guniꞌi më: ―Si talë rac shtúꞌul tsasël, gulë bëquë́ diaguë bien shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Despuësë zu Jesús lë́ꞌësë më, iurní ra mënë nazugaꞌa guëllaꞌ lëꞌë më con ra shini gusëꞌdë më, gunaꞌbë diꞌdzë raiꞌ pë runë cuntienë ra comparaciuni. ");
INSERT INTO zacNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Guniꞌi më lu rall: ―Dios bëꞌnë favurë parë guasë́ të manërë rnibëꞌa më ziquë rëy; perë na, ruadiꞌdza por comparaciuni lu ra mënë nanadë në́diꞌi tsasë́ shtiꞌdzë më ");
INSERT INTO zacNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","të parë guëná rall perë adë riasë́diꞌi rall. Rini rall perë rúnëdiꞌi rall cuendë. Por ni ruadiꞌdza ra comparaciuni lu rall të parë adë guëabrídiꞌi lduꞌu rall con Dios, nu adë gúnëdiꞌi Dios perdunë duldë shtë rall. ");
INSERT INTO zacNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iurní guniꞌi më lu ra nacabezënú më: ―¿Pëllë adë riasë́diꞌi të comparaciuni shtë nartëꞌtsë bëꞌdchi? ¿Lla gunë të parë tsasë́ të grë́tëꞌ ra comparaciuni narniaꞌa lu të? ");
INSERT INTO zacNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","El quë nartëꞌtsë bëꞌdchi, na ziquë el quë nartëꞌtsë shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nanú mënë ziquë guiuꞌu guëdchi catë gulaguë bëꞌdchi lu nezë. Rini rall shtiꞌdzë Dios perë lueguë ridë mëdzabë Satanás nu rdchisú mëdzabë diꞌdzë laꞌni lduꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Stubi tantë mënë na rall ziquë guiuꞌu guëꞌë catë gulaguë bëꞌdchi lu guëꞌë. Rini rall; rëuuꞌ lduꞌu rall shtiꞌdzë Dios perë adë guáꞌdzëdiꞌi diꞌdzë laꞌni lduꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ziquë tubi plantë nanapë duꞌpë shlúꞌchiꞌ, rialdí lduꞌu rall duꞌpë tiempë. Iurë ridë ra cusë durë nu rguini mënë saꞌ rall por dizaꞌquë, iurní rsaꞌnë rall dizaꞌquë; rëazë guetë rall. ");
INSERT INTO zacNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nu zac nanú mënë naná ziquë bëꞌdchi nagulaguë lu guiꞌlli guitsë. ");
INSERT INTO zacNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Rini rall shtiꞌdzë Dios perë por tantë llgabë runë rall lla guëbani rall nu rzebi lduꞌu rall zihani cusë; rac shtuꞌu rall zihani dumí. Rteꞌe ra cusë ni dizaꞌquë; nídiꞌi mudë cuezë shtiꞌdzë Dios laꞌni lduꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Perë nanú mënë ziquë bëꞌdchi narlaguë lu guiuꞌu zaꞌquë. Guëdubinú lduꞌu rall rialdí lduꞌu rall. Na rall ziquë plantë narneꞌe resultá galdë bi chi por tubi nu sesenta por tubi u tubi gahiuꞌa por tubi. ");
INSERT INTO zacNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","También guniꞌi më lu rall: ―¿Ni mudë guidënul tubi llni parë suhin guëaꞌ camë u suhin laꞌni rmudi? ¿Pëllë lëdë guiáꞌadiꞌi zubin të parë guëzianín laꞌni hiuꞌu? ");
INSERT INTO zacNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Grë ra cusë nagaꞌchi lu ra mënë, napë quë guëruꞌu rahin lu llni parë tsasë́ mieti. Adë nídiꞌi mudë gaquin nagaꞌchi parë siemprë. ");
INSERT INTO zacNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Si talë rac shtúꞌul tsasël, gulë bëquë́ diaguë bien shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Guniꞌi më lu rall: ―Gulë guná; gulë bëquë́ diaguë bien. Con el mizmë medidë narrëꞌshë të iurneꞌ, medidë ni napë quë guëbishi të. Nu guëneꞌe më másruꞌu llni lëꞌë të narquë́ diaguë shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Si talë guëquë́ diaguë të bien, Dios guëneꞌe më más shtiꞌdzë më parë lëꞌë të, perë si talë rúnëdiꞌil cuendë shtiꞌdza, guëdchisú më llni narníꞌil nápël. ");
INSERT INTO zacNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nu zac Jesús guniꞌi: ―Zni na catë rnibëꞌa Dios ziquë Rëy. Nahin cumë ziquë tubi nguiu nartëꞌtsë bëꞌdchi lu guiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nagáꞌsill gueꞌlë; despuësë riashtëll. Rdëdë ra dzë nu rdëdë ra gueꞌlë. Lëꞌë bëꞌdchi rialdanin nu riaruꞌbë plantë. Lëꞌë nguiu adë rac bë́ꞌadiꞌill lla riaruꞌbë plantë. ");
INSERT INTO zacNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","De lëꞌë guiuꞌu primërë rldani plantë, iurní rruꞌu ra duꞌu shtëhin. Lëꞌë duꞌu ni nuaꞌa zihani bëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Iurë lëꞌë bëꞌdchi gubidchi, lueguë rchuguë rall bëꞌdchi purquë hia bëdchini tiempë shtë cusechë. ");
INSERT INTO zacNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Guniꞌi më stubi comparaciuni: ―¿Guadë diꞌdzë nu comparaciuni guëluáꞌahia lu të parë tsasë́ të lla na tiempë naguënibëꞌa Dios ziquë rëy? ");
INSERT INTO zacNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tiempë ni na ziquë tubi bëꞌdchi mituꞌnë. Iurë bëtëꞌtsë nguiu bëꞌdchi ni, nahin ziquë más mituꞌnë lu grë́tëꞌ bëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Despuësë de bërëꞌtsin nu guaruꞌbin, beꞌpin más de grë ra plantë. Gupin llicu ruꞌbë nu bëdchini ra maꞌñi; bëdchiꞌbë ra ma bëcheꞌzë lu llicu hiaguë. ");
INSERT INTO zacNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Zihani cusë bëluaꞌa më con comparaciuni según guasë́ ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Siemprë biadiꞌdzë më lu ra mënë con comparaciuni nu bëquebi më lu ra shini gusëꞌdë më pë runë cuntienë shtíꞌdziꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mizmë dzë ni iurë bëdchini gueꞌlë, guniꞌi më lu ra shini gusëꞌdë më: ―Cha guiá hiaꞌa stubi ladë ruaꞌ nisë. ");
INSERT INTO zacNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Iurní lëꞌë raiꞌ bëꞌnë raiꞌ despedir ra mënë zihani narë́ ruaꞌ nisë ruꞌbë. Biaꞌa ra shini gusëꞌdë më lëꞌë më zíquësë zugaꞌa më të parë ziaꞌa raiꞌ laꞌni barcu. Nu zianaldë stubi shcuaꞌa barcu con lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Iurní bëdchini tubi mbë dushë lu nisë. Guatë́ nisë laꞌni barcu hashtë mërë në́ꞌazë guëdubi barcu laꞌni nisë. ");
INSERT INTO zacNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nagaꞌsi Jesús nezë ichi barcu; nacuꞌguë më tubi almadë. Bëcuaꞌñi raiꞌ lëꞌë më nu guniꞌi raiꞌ: ―Mësë, aquë zati hiaꞌa iurneꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iurní guashtë́ më; guniꞌi më guëc mbë nu guëc nisë: ―Guitsëgá nu bëac dchi. Lueguë gurëdchí nisë nu lëꞌë mbë bëac dchi. ");
INSERT INTO zacNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Guniꞌi më lu ra shini gusëꞌdë më: ―¿Pëzielú rdzëbë të? ¿Pë hia rialdídiꞌi lduꞌu të Dios? ");
INSERT INTO zacNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nalë́ bëdzëguëëꞌ lduꞌu raiꞌ; guniꞌi lu saꞌ raiꞌ: ―¿Chull më rëꞌ? Rzuꞌbë diaguë nisë nu mbë shtíꞌdziꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bëdchini raiꞌ stubi ladë tëchi nisë ruꞌbë ladzë ra më gadareno. ");
INSERT INTO zacNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iurë bëruꞌu më laꞌni barcu, lueguë guabiꞌguë tubi nguiu lu më; nanú tubi mëdzabë fier laꞌni ldúꞌull. Bëruꞌu nguiu ni catë nanú cuevë catë bëgaꞌchi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ndë guquëréldëll. Nilë con cadënë adë chu gac guëldiꞌbi lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Zihani vueltë bëldiꞌbi mënë lë́ꞌëll con cadënë guëaꞌll nu guiáꞌall perë bëchúguëll cadënë nu rúnëll pedasë ra guiꞌbë. Adë chu rúnëdiꞌi gan lull të guëldíꞌbill lëꞌë nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dzë la gueꞌlë canzëll nu gurushtiall catë nanú baꞌa nu catë nanú dani. Mizmë lë́ꞌëll rguínill lë́ꞌëll con guëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Dizdë zitu gubíꞌall lu Jesús; guagllúꞌnëll lu më nu bëzullíbill lu më. ");
INSERT INTO zacNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Gurushtiall nu guníꞌill fuertë: ―¿Pëllë nápël con na? Jesús. Lë́ꞌël nal shini Dios nacabezë gubeꞌe. Por Dios rniaꞌa lul, adë guëtiáꞌadiꞌil na lu guiꞌi shtë cashtigu. ");
INSERT INTO zacNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Zni guníꞌill purquë antsë guniꞌi Jesús lull: ―Bësaꞌnë lëꞌë nguiu rëꞌ. Nal tubi mëdzabë demasiadë fier. ");
INSERT INTO zacNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Gunaꞌbë diꞌdzë Jesús lull: ―¿Chu lël? Bëquébill: ―Lëa Chupë Mili. Zihani na naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Iurní ra mëdzabë bëꞌnë rall ruëguë lu Jesús parë adë guëgúdiꞌi më lëꞌë rall fuërë de lugar ni. ");
INSERT INTO zacNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Guëllaꞌ ruaꞌ dani rëtaꞌ zihani guchi; quëháu ra ma. ");
INSERT INTO zacNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ra mëdzabë bëꞌnë rall ruëguë lu më; guniꞌi rall: ―Bësheꞌldë lëꞌë naꞌa laꞌni lduꞌu guchi të tsutë́ naꞌa laꞌni lduꞌu ra ma. ");
INSERT INTO zacNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Bëdëꞌë më permisi; iurní ra mëdzabë bëruꞌu rall nguiu ni nu guatë́ rall laꞌni ra guchi. Na ra ma más quë chupë mili. Ziaglluꞌnë ra ma catë nanú tubi bërrancu ruaꞌ nisë. De guiaꞌa guzutuꞌu ra ma laꞌni nisë; guti ra ma. ");
INSERT INTO zacNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ra narapë guchi iurë guná rall pë guc, guaglluꞌnë rall lu më guëꞌdchi nu lu ra mënë narë́ lachi. Guniꞌi rall lo quë naguc. Bëruꞌu ra mënë; guagná rall nia pë guc lugar ni. ");
INSERT INTO zacNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bëdchini rall catë nanú Jesús nu guná rall lu nguiu nanapë mëdzabë laꞌni ldúꞌull antsë. Nguiu ni zubë ngaꞌli nu nácull shábëll; hia beꞌrquë na shgábëll. Nalë́ bëdzëguëëꞌ lduꞌu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Grë ra testigu naguná lo quë nabëꞌnë Jesús, biadiꞌdzë rall lo quë nabëꞌnë më con lëꞌë nguiu nu con ra guchi. ");
INSERT INTO zacNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Iurní bëꞌnë ra mënë ruëguë lu Jesús të guëruꞌu më ladzë rall. ");
INSERT INTO zacNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Güeꞌpi më laꞌni barcu; lëꞌë nguiu nanagupë chupë mili mëdzabë antsë, bë́ꞌnëll ruëguë lu më parë tsanáldëll lëꞌë më ");
INSERT INTO zacNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","perë Jesús adë gunë́diꞌiꞌ; guníꞌiꞌ lu nguiu: ―Bëagzë́ lídchil nu biadiꞌdzë lu shfamílil ra cusë ruꞌbë nabëꞌnë Dios con lë́ꞌël. Biadiꞌdzë lu rall blac bëgaꞌa lduꞌu më lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Iurní gubiꞌll; guzublú biadíꞌdzëll lu ra mënë shtë regiuni nalë Decápolis; biadíꞌdzëll cusë ruꞌbë nabëꞌnë Jesús con lë́ꞌëll. Grë ra nabini shtíꞌdzëll, guasë́ lduꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Beꞌpi më laꞌni barcu; bëabrí më stubi ladë ruaꞌ nisë ruꞌbë. Zihani mënë bëdchini lu më catë zu më ruaꞌ nisë. ");
INSERT INTO zacNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Beꞌdë guëdchini tubi mënë lë Jairo lu Jesús. Jairo nall tubi më importantë laꞌni iáduꞌu shtë më israelitë. Iurë guná Jairo lu Jesús; bëzullíbill lu më. ");
INSERT INTO zacNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nalë́ bë́ꞌnëll ruëguë lu më; guníꞌill: ―Shtsaꞌpa hia rlúllëll. Bëꞌnë favurë, cha guëdchiꞌbë guiáꞌal guë́quiꞌ parë guëáquëll nu guëbánill. ");
INSERT INTO zacNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iurní ziaꞌanú më Jairo; nalë́ zihani mënë canaldë rall lëꞌë më hashtë rteꞌe rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nanú tubi naꞌa ladi ra mënë; hia guc chiꞌbë chupë izë rllëꞌë rë́nëll. ");
INSERT INTO zacNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nalë́ bë́ꞌnëll sufrir por ra rumëdi nabëꞌnë ra ducturë hashtë bë́ꞌnëll gashtë grë́tëꞌ dumí nanápëll perë ni duꞌpë adë bëáquëdiꞌill sino más rac llúꞌull. ");
INSERT INTO zacNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Bini naꞌa rëꞌ pë bëꞌnë Jesús nu guabíꞌguëll nezë tëchi më. Bëgáꞌldëll ruaꞌ shabë më. ");
INSERT INTO zacNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Guníꞌill laꞌni ldúꞌull: “Talë guëgaꞌlda ruaꞌ shabë më zëaca”. ");
INSERT INTO zacNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Bëgáꞌldëll shabë më nu lueguë gulezë galërllëꞌë rënë. Bëdë́ꞌëll cuendë hia bëáquëll. ");
INSERT INTO zacNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús guc bë́ꞌaiꞌ de quë bëac tubi më por pudërë shtë më. Bëdchigrë́ lu më; guná më lu ra nazugaꞌa ndëꞌë; gunaꞌbë diꞌdzë më: ―¿Chu bëgaꞌldë shaba? ");
INSERT INTO zacNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ra shini gusëꞌdë më guniꞌi: ―Guná; blac mënë zihani quëgteꞌe rall lë́ꞌël, nu rnaꞌbë díꞌdzël chu bëgaꞌldë shábël. ");
INSERT INTO zacNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús guná guëdubi ladë lu ra mënë të parë guëná më chu bëgaꞌldë shábiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Iurní lëꞌë naꞌa ni bëdzë́bëll; bëchíꞌchill; bëzullíbill lu më. Guc bë́ꞌall bëac galguidzë shtë́nëll. Bëquébill grë lo quë nabë́ꞌnëll. ");
INSERT INTO zacNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Guniꞌi Jesús lull: ―Nanë, bëáquël purquë rialdí ldúꞌul na. Bëagzë́ con bien. Hia gulezë galguidzë shtë́nël. ");
INSERT INTO zacNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nianá quëadiꞌdzënú më naꞌa ni, bëdchini bëldá mënë nazeꞌdë lidchi Jairo. Guniꞌi rall lu Jairo: ―Shtsáꞌpël hia gútiꞌ. Adë guënáꞌbëruꞌul favurë lu më. ");
INSERT INTO zacNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Perë Jesús bini lo quë naguniꞌi rall. Repi më lu Jairo: ―Adë rdzë́bëdiꞌil; guaglaꞌguë tsaldí ldúꞌul na. ");
INSERT INTO zacNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Adë në́diꞌi më tsanaldë ra mënë, sulë Pedro nu Jacobo nu Juan bëchi Jacobo. ");
INSERT INTO zacNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bëdchini raiꞌ lidchi Jairo. Guná më zihani mënë; nalë́ ruꞌnë rall nu bëꞌnë rall ruidë. ");
INSERT INTO zacNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Guatë́ më hiuꞌu; guniꞌi më: ―¿Pëzielú tantë ruidë quëhunë të? ruꞌnë të. Lëꞌë ntsaꞌpë rëꞌ adë gútidiꞌiꞌ sino nagáꞌsiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bëꞌnë mënë burnë nu rllidchinú rall lëꞌë Jesús. Iurní bëgú më grë mënë. Biaꞌa më shtadë ntsaꞌpë con shníꞌaiꞌ nu ra nabëdchininú më. Guatë́ raiꞌ catë nagaꞌa tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Gunaꞌzi më guiaꞌa tëgulë; guniꞌi më: ―Talita cumi (diꞌdzë rëꞌ runë cuntienë con dizë́ shtë më: “Ntsaꞌpë, guashtë́ ngaꞌli”). ");
INSERT INTO zacNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Lueguë lueguë iurní guashtë́ ntsaꞌpë ni. Guzúbiꞌ; guzë́hiꞌ purquë nápiꞌ chiꞌbë chupë izë. Nalë́ bëdzëguëëꞌ lduꞌu mënë. ");
INSERT INTO zacNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iurní gunibëꞌa më të guëdëꞌë rall nagáu ntsaꞌpë. Gunibëꞌa më lu rall adë chu lu guadíꞌdzëdiꞌi rall pë bëꞌnë Jesús con shtsaꞌpë Jairo. ");
INSERT INTO zacNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Bëruꞌu më lugar ni nu bëabrí më ladzë më. Ziaꞌanú më ra shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Iurë bëdchini dzë descansë, guzublú cagluaꞌa më laꞌni iáduꞌu. Zihani mënë nabëquë́ diaguë shtiꞌdzë më, bëdzëguëëꞌ lduꞌu rall nu guniꞌi rall: ―¿Con pë pudërë quëhunë Jesús tantë cusë rëꞌ? ¿Chull bëdëꞌë tantë llni? ¿Chull bëdëꞌë pudërë guiáꞌall tantë milagrë quëhúniꞌ? ");
INSERT INTO zacNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Pëllë lëdë carpintë́rëdiꞌi; nu nall shini María? Ra bë́chill lë rall Jacobo nu José nu Judas nu Simón. Nu zánëll quëreldë rall ndëꞌë entrë lëꞌë hiaꞌa. Adë bëgáꞌadiꞌi guzac rall ");
INSERT INTO zacNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","perë Jesús guniꞌi lu rall: ―Grë́tëꞌ ra muzë shtë Dios adë rúnëdiꞌi mënë rëspëti lëꞌë raiꞌ, ni sáhiꞌ, ni ra shfamíliꞌ; rúnëdiꞌi rall rëspëti lë́ꞌiꞌ. Sulë stubi lugar runë mënë rëspëti tubi muzë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Por ni adë guc nihunë më milagrë, sulë bënëac më duꞌpsë mënë narac lluꞌu. Bëdchiꞌbë më guiaꞌa më guëc rall nu bëac rall. ");
INSERT INTO zacNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nalë́ bëdzëguëëꞌ lduꞌu më purquë adë gualdídiꞌi lduꞌu rall shtiꞌdzë më. Hia lëꞌë Jesús guagluaꞌa ra mënë naquëreldë ra guëꞌdchi naná guëllaꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Gunaꞌbë më ra chiꞌbë chupë shini gusëꞌdë më nu bësheꞌldë më chúpëll tubi ladë, chúpëll stubi ladë. Zni bësheꞌldë më grë raiꞌ. Bëdëꞌë më pudërë guëgú raiꞌ ra mëdzabë fier laꞌni lduꞌu mënë. ");
INSERT INTO zacNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Gunibëꞌa më lu shini gusëꞌdë më adë guáꞌadiꞌi raiꞌ zihani cusë, sulë tubi bastunë parë nezë; adë guáꞌadiꞌi raiꞌ bulsë, nilë guetështildi, nilë dumí, sulë bastunë. ");
INSERT INTO zacNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Guniꞌi më lu raiꞌ guëquëꞌë raiꞌ rachi nu gacu raiꞌ tubsë shcuaꞌa shabë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Guniꞌi më lu raiꞌ: ―Cualquier lidchi mënë ca guëdchini të, gulë bëaꞌnë ngaꞌli hashtë guziaꞌa të stubi guëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Si talë në́diꞌi mënë gunë rall recibir lëꞌë të nu në́diꞌi rall guëquë́ diaguë rall dizaꞌquë, gulë bëruꞌu guëꞌdchi ni; gulë bëdchibë gushëguiuꞌu nanaquë́ guëaꞌ të ziquë tubi sëñi de quë adë gualdídiꞌi lduꞌu rall shtiꞌdzë Dios. Rniaꞌa lu të gunë më cashtigu más ra mënë nanadë bë́ꞌnëdiꞌi recibir lëꞌë të quë ra mënë shtë guëꞌdchi Sodoma nu Gomorra. ");
INSERT INTO zacNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iurní ziaꞌa ra shini gusëꞌdë më. Cagniꞌinú raiꞌ mënë të guëabrí lduꞌu rall con Dios nu gunë nadzëꞌë rall mudë nanabani rall. ");
INSERT INTO zacNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nu zac bëgú raiꞌ zihani mëdzabë laꞌni lduꞌu ra mënë. Bëteꞌbi raiꞌ sëiti guëc ra narac lluꞌu. Zihani mënë bëac. ");
INSERT INTO zacNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lëꞌë rëy Herodes bínill lo quë nabëꞌnë Jesús. Famë shtë më bërëꞌtsë guëdubi nezë. Guniꞌi bëldá mënë: ―Jesús na Juan Bautista naguashtë́ ladi ra tëgulë; por ni nápiꞌ llëruꞌbë pudërë. ");
INSERT INTO zacNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Stubi mënë guniꞌi: ―Jesús na Elías. Stubi rall guniꞌi: ―Jesús na tubi nabiadiꞌdzë shtiꞌdzë Dios guahietë perë bëabrí guashtë́hiꞌ ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Iurë bini Herodes diꞌdzë ni, guníꞌill: ―Juan Bautista ndëꞌë. Guagchuguë ra suldadë guëc Juan perë guashtë́hiꞌ ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Pues más antsë Herodes gunibëꞌa guënaꞌzi ra suldadë lëꞌë Juan parë tsáhiꞌ lachiguiꞌbë. Bëldiꞌbi rall lëꞌë Juan con cadënë. Guc ni por causë shtë Herodías, tseꞌlë Felipe naná bëchi Herodes. Herodes cuaꞌa naꞌa ni ziquë tséꞌlëll. ");
INSERT INTO zacNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Pues Juan guniꞌi lu Herodes: ―Guzáꞌquëdiꞌi cuáꞌal tseꞌlë bë́chil. ");
INSERT INTO zacNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Por diꞌdzë ni bëldë́ Herodías. Rac shtúꞌull quínill lëꞌë Juan perë adë bë́ꞌnëdiꞌill gan ");
INSERT INTO zacNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","purquë Herodes bëdzë́bëll lëꞌë Juan. Bë́ꞌnëll rëspëti Juan; guc bë́ꞌall na Juan nguiu zaꞌquë nu santu. Por ni bësë́ꞌaull lëꞌë Juan lachiguiꞌbë. Bëuuꞌ lduꞌu Herodes shtiꞌdzë Juan perë bëꞌnë chúpëll ldúꞌull. ");
INSERT INTO zacNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Perë bëdchini tubi dzë bëꞌnë Herodías gan. Guc lë Herodes nu bë́ꞌnëll invitar ra më ruꞌbë shtë Galilea nu ra suldadë nu jushtici shtë́hiꞌ; gau rall lidchi Herodes. ");
INSERT INTO zacNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Iurë dzu laní, shtsaꞌpë Herodías guatë́ nu bëguíꞌill lu ra invitadë shtë Herodes. Nalë́ bëuuꞌ lduꞌu Herodes con grë ra mënë nazugaꞌa ndë. Guniꞌi Herodes lu ntsaꞌpë: ―Cualquier cusë guënáꞌbël lua, guënéhiahin cáꞌal. ");
INSERT INTO zacNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Bëꞌnë Herodes jurar lu lliguënaꞌa: ―Guldía, lo quë narac shtúꞌul, guënéhiahin hashtë guëruldë catë rnibë́ꞌahia. ");
INSERT INTO zacNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Bëruꞌu lliguënaꞌa nu gunaꞌbë díꞌdzëll lu shníꞌall: ―¿Pë cusë guënaꞌba lu Herodes? Guniꞌi shniꞌa lliguënaꞌa ni: ―Gunaꞌbë guëc Juan Bautista. ");
INSERT INTO zacNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nasesë guatë́ lliguënaꞌa catë nanú Herodes. Guníꞌill: ―Na rac shtuaꞌa guënéꞌel lueguë guëc Juan Bautista; tsu laꞌni platë cahia. ");
INSERT INTO zacNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Iurní nalë́ zunú rëy tristë perë bë́ꞌnëll jurar lu ra nazubënull lu mellë; napë quë gúnëll cumplir. ");
INSERT INTO zacNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Lueguë gunibëꞌa Herodes tubi suldadë parë tsagllíꞌill guëc Juan. ");
INSERT INTO zacNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Gua suldadë lachiguiꞌbë; bëchúguëll guëc Juan nu bëdchíꞌbëllin lu platë. Bë́ꞌnëll entregarin guiaꞌa shtsaꞌpë Herodías. Hia lliguënaꞌa bëdëꞌëin guiaꞌa shníꞌall. ");
INSERT INTO zacNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Iurní bini ra shmënë Juan de quë hia gútiꞌ, bëdchini raiꞌ nu biaꞌa raiꞌ cuerpë parë guacaꞌchi raiꞌ cuerpë laꞌni baꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ra shini gusëꞌdë më bëabrí raiꞌ; guniꞌi raiꞌ lu Jesús grë́tëꞌ lo quë nabëꞌnë raiꞌ nu lo quë nabëluaꞌa raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Guniꞌi Jesús lu raiꞌ: ―Cha guiá hiaꞌa tubi lugar catë nídiꞌi mënë të guëziꞌi lduꞌu hiaꞌa duꞌpë. Zni guniꞌi më purquë zihani mënë bëdchini lugar ni nu ziaꞌa rall de manërë adë nápëdiꞌi më tiempë gáuhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Iurní guatë́ raiꞌ laꞌni barcu; ziaꞌa raiꞌ catë na tubi shlatë; adë nídiꞌi mënë. ");
INSERT INTO zacNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Perë zihani mënë guná ca nezë ziaꞌa raiꞌ. Bënguë bëꞌa rall lëꞌë Jesús nu guaglluꞌnë rall delantë. Bëdchini rall guëaꞌ rall de grë guëꞌdchi. Gudchibëlú rall lu më. ");
INSERT INTO zacNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iurë bëruꞌu më laꞌni barcu, guná më lu mënë zihani; na rall ziquë lliꞌli nanápëdiꞌi vëquërë. Bëgaꞌa lduꞌu më lëꞌë rall; guzublú bëluaꞌa më lëꞌë rall zihani cusë. ");
INSERT INTO zacNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Iurë guc guadzeꞌ, bëdchini ra shini gusëꞌdë më; repi raiꞌ lu më: ―Hia guadzétiꞌ nu lugar rëꞌ adë chu nádiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bësheꞌldë ra mënë lu guëꞌdchi u lu ra ranchi guëllaꞌ; tsasiꞌi rall nagáu rall. Ndëꞌë nídiꞌi nagáu. ");
INSERT INTO zacNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesús guniꞌi lu raiꞌ: ―Gulë bëdëꞌë nagáu rall. Lëꞌë shini gusëꞌdë më guniꞌi: ―¿Ca guiá siꞌi naꞌa guetështildi gau rall? Rquiꞌni masiá chupë gahiuꞌa bëllë parë guëdëꞌë hiaꞌa nagáu rall. ");
INSERT INTO zacNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iurní guniꞌi Jesús: ―¿Bëldá guetështildi napë të? Gulë tsagná. Iurë guagná raiꞌ, guniꞌi raiꞌ: ―Nanú gaꞌi guetështildi con chupë mbeldë. ");
INSERT INTO zacNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Iurní gunibëꞌa Jesús subë ra mënë lu guiꞌlli naguëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Guzubë rall tubi gahiuꞌa mënë tubi ladë, cincuenta mënë stubi ladë. Zni guzubë grë mënë, por grupë guzubë rall. ");
INSERT INTO zacNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Iurní gunaꞌzi Jesús gaꞌi guetështildi nu chupë mbeldë. Guná më lu gubeꞌe; bëdëꞌë më graci lu Dios. Bëshullë më guetështildi cuaꞌa ra poshtë. Lëꞌë raiꞌ guatiꞌdzë raiꞌ guetështildi cuaꞌa ra mënë. Nu zac bëꞌnë më con chupë mbeldë. ");
INSERT INTO zacNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Grë ra mënë gudáu rall hashtë bielë rall. ");
INSERT INTO zacNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Iurní bëtëá ra shini gusëꞌdë më chiꞌbë chupë tëpë ra pedasë guetështildi nu mbeldë nabëꞌnë subrë. ");
INSERT INTO zacNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Grë ra mënë nagudáu guetështildi na rall gaꞌi mili nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Lueguë gunibëꞌa më lu shini gusëꞌdë më guëuꞌ raiꞌ laꞌni barcu të parë ziaꞌa raiꞌ stubi ladë ruaꞌ nisë ruꞌbë. Gudchibëlú raiꞌ parë ziaꞌa raiꞌ guëꞌdchi Betsaida mientras bëꞌnë më despedir ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bësaꞌnë më ra mënë; gua më lu dani të parë guadiꞌdzënú më Shtadë më. ");
INSERT INTO zacNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Iurní bëdchini gueꞌlë; lëꞌë barcu ziazú guëruldë nisë ruꞌbë. Bëaꞌnë më lu guiuꞌu tubsë më. ");
INSERT INTO zacNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Guná më lu barcu; hia ra shini gusëꞌdë më adë bë́ꞌnëdiꞌi raiꞌ gan guësë́ raiꞌ barcu purquë mbë zeꞌdë al contrari. Nalë́ bëdzaguë raiꞌ. Hia zeꞌdë grëgueꞌlë; lëꞌë Jesús zeꞌdë zu më lu nisë catë ziazú raiꞌ. Guc lduꞌu më niaguibëlú më lu barcu. ");
INSERT INTO zacNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Guná raiꞌ lu më; ziazú më lu nisë. Iurní bëꞌnë raiꞌ llgabë náhiꞌ tubi fantasmë. Gurushtiá raiꞌ por galërdzëbë. ");
INSERT INTO zacNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Guná raiꞌ lu më; nalë́ bëdzëbë raiꞌ perë lueguë Jesús guniꞌi lu raiꞌ: ―Adë rdzë́bëdiꞌi të. Na ndëꞌë; gulë gapë valurë. ");
INSERT INTO zacNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Iurní beꞌpi më laꞌni barcu nu lueguë gulezë mbë dushë. Nalë́ bëdzëguëëꞌ lduꞌu ra shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Aunquë guná raiꞌ bëdëꞌë më guetështildi gau gaꞌi mili nguiu, adë guasë́diꞌi raiꞌ chu na më tantë naguëdchi lduꞌu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Gudëdë raiꞌ stubi ladë nisë ruꞌbë. Bëdchini raiꞌ regiuni nalë Genesaret. Bëquëdú raiꞌ barcu ruaꞌ nisë. ");
INSERT INTO zacNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bëruꞌu raiꞌ laꞌni barcu; lueguë ra mënë bënguë bëꞌa rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bëlluꞌnë ra mënë grë ladë të tsaglliꞌi rall narac lluꞌu lu Jesús. Nuaꞌa rall ra fërmë lu daaꞌ ancalë bini rall nanú më. ");
INSERT INTO zacNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Cualquier guëꞌdchi u ciudá u lachi catë guatë́ Jesús, ndë rguishi ra mënë ra narac lluꞌu catë nezë tëdë më. Bëꞌnë rall ruëguë lu më parë guëdëꞌë më permisi guënaꞌzi rall ruaꞌ shabë më. Grë ra nagunaꞌzi shabë më bëac rall. ");
INSERT INTO zacNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bëdchini bëldá fariseo lu Jesús nu mësë narluaꞌa lëy, bëdchini rall lu më. Na rall më Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Guná rall lu shini gusëꞌdë më; gudáu raiꞌ guetështildi sin quë adë bë́ꞌnëdiꞌi raiꞌ cumplir ziquë na custumbrë; adë gudíbidiꞌi raiꞌ guiaꞌa raiꞌ ziquë custumbrë religiusë shtë ra fariseo. Iurní bëꞌnë rall juzguë ra shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ra fariseo nu grë ra mënë israelitë, adë ráudiꞌi rall sin quë adë riéꞌtidiꞌi guiaꞌa rall zihani vueltë. Ziaglaꞌguë rall con ra custumbrë shtë ra mëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Iurë rëabrí rall lu llguëaꞌ antsë gau rall, razë rall bien ziquë custumbrë religiusë. Zihani custumbrë napë rall, cusë ziquë rguibi rall vasë nu mbluri nu ra bandëjë, nu zac hashtë ra camë rguibi rall. ");
INSERT INTO zacNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ra fariseo nu ra mësë gunaꞌbë diꞌdzë rall lu Jesús: ―¿Pëzielú shini gusë́ꞌdël adë rúnëdiꞌi rall cumplir custumbrë shtë ra shtadë guëlú hiaꞌa sino rau rall guetështildi sin quë adë riéꞌtidiꞌi guiaꞌa rall? ");
INSERT INTO zacNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús guniꞌi: ―Na të falsë. Guldí Isaías el quë nabiadiꞌdzë shtiꞌdzë Dios; guníꞌiꞌ shcuendë të lla na të. Bëquë́ꞌëiꞌ shtiꞌdzë Dios narniꞌi: Ra mënë rëꞌ rac shtuꞌu rall na nadë más con ruaꞌ rall, perë lduꞌu rall nalë́ zitu zugaꞌa parë na. ");
INSERT INTO zacNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Adë rlluíꞌidiꞌi ra cusë narunë rall iurë quëhunë rall adorar na. Enseñansë shtë rall nadë más nahin tubi mandadë shtë nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Rluaꞌa tëchi të lu mandamientë shtë Dios parë gunë të cumplir ra custumbrë shtë të, ziquë rguibi të vasë nu ra mbluri nu zihani cusë más quëhunë të cumplir. ");
INSERT INTO zacNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nu guniꞌi më lu rall: ―Quëgsiguë́ të; rsaꞌnë të mandamientë tubi ladë; más canaldë të tëchi custumbrë shtë të ");
INSERT INTO zacNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","purquë Moisés bëquëꞌë: “Gápël rëspëti lu shtádël nu lu shníꞌal”. También bëquëꞌë Moisés: “El quë nargué guëc shtádiꞌ u shníꞌaiꞌ napë quë quini mënë nguiu ni”, ");
INSERT INTO zacNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","perë lëꞌë të rniꞌi të: “Si talë tubi nguiu guépill lu shtádiꞌ: Grë dumí narunë tucarë guënehia cáꞌal, na corbán, nahin sulë parë Dios”. ");
INSERT INTO zacNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Si talë guëniꞌi nguiu zni, iurní rniꞌi të rquíꞌnidiꞌi guëdëꞌë nguiu dumí caꞌa shtádiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Pues zni cagniꞌi të lasáquëdiꞌi shtiꞌdzë Dios. Más ziaglaꞌguë të tëchi ra custumbrë, nu rluaꞌa të custumbrë ni lu ra shini gusëꞌdë të. Zihani cusë igual runë të. ");
INSERT INTO zacNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Stubi vueltë gunaꞌbë Jesús ra mënë zihani nu guniꞌi më: ―Gulë bëquë́ diaguë nu gulë guasë́ nacagniaꞌa lu të. ");
INSERT INTO zacNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Lo quë nagáu nguiu, adë rshíꞌnidiꞌi lduꞌu nguiu perë ra didzabë narruꞌu ruaꞌll, sí, ni rshiꞌni ldúꞌull.  ");
INSERT INTO zacNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Si talë rac shtúꞌul tsasël, gulë bëquë́ diaguë grë lo quë narniaꞌa lu të. ");
INSERT INTO zacNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iurní bëruꞌu më ladi ra mënë; guatë́ më lidchi më. Gunaꞌbë diꞌdzë ra shini gusëꞌdë më pë runë cuntienë comparaciuni rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Guniꞌi më: ―¿Pëllë nu lëꞌë të adë riasë́diꞌi të shtiꞌdza? ¿Pëllë adë rac bëꞌa të naráu nguiu adë rúnëdiꞌi manchë ldúꞌull? ");
INSERT INTO zacNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","purquë adë riutë́diꞌi naráu nguiu laꞌni ldúꞌull sino riutëhin laꞌni shpúchill; despuësë rruꞌuin. Manërë ni guniꞌi më grë naráu mënë nazaꞌquin; adë rúnëdiꞌin manchë lduꞌu nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nu guniꞌi më: ―Lo quë narruꞌu laꞌni ruaꞌ mieti, ni zeꞌdë de laꞌni lduꞌu nguiu. Ni sí, canihunin manchë lduꞌu nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Laꞌni lduꞌu nguiu rruꞌu grë́tëꞌ cusë mal: mal llgabë, rquënú nguiu tseꞌlë mënë, napë nguiu zihani naꞌa nu ra naꞌa napë zihani nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Rbaaꞌnë rall pë shtë mënë; rguini rall saꞌll; rzebi lduꞌu rall pë shtë mënë; runë rall mal cuntrë saꞌ rall; rsiguë́ rall saꞌll; mal vidë nabani rall; nambidi rall; napë rall vici; runë nadchini rall; cusë nadë rlluíꞌidiꞌi runë rall. ");
INSERT INTO zacNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Grë ra cusë ni rruꞌu dizdë laꞌni lduꞌu nguiu nu por ni napë nguiu duldë delantë lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bëruꞌu më lugar ni; gua më regiuni shtë Tiro nu Sidón. Guatë́ më tubi hiuꞌu; guc shtúꞌudiꞌi më gac bëꞌa mënë catë nanú më perë grë́tëꞌ mënë guc bëꞌa rall catë nanúhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Lueguë bini tubi naꞌa catë nanú Jesús. Naꞌa ni shtsáꞌpëll napë tubi mëdzabë fier laꞌni ldúꞌull. Bëdchini naꞌa lu Jesús; bëzullíbill lu më. ");
INSERT INTO zacNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Naꞌa ni na mënë sirofenicia; dizë́ shtëll na griego. Bë́ꞌnëll ruëguë lu Jesús guëgú më mëdzabë laꞌni lduꞌu shtsáꞌpëll. ");
INSERT INTO zacNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Perë Jesús guniꞌi lu naꞌa: ―Napë quë gau ra shini mieti hashtë guielë rall purquë nádiꞌi bien guëdchisul guetështildi shtë ra shini mënë parë gau ra mbécuꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Guniꞌi naꞌa: ―Nia Dadë, perë ra mbécuꞌnë nananú guëaꞌ mellë, rau ma pedasë narruꞌu hiaꞌldë ruaꞌ llguëꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Guniꞌi më iurní: ―Bien guníꞌil. Bëagzë́ lídchil; hia lëꞌë mëdzabë bërúꞌull laꞌni lduꞌu shtsáꞌpël. ");
INSERT INTO zacNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ziaꞌa naꞌa; bëdchíniꞌ lídchiꞌ; bëdzéliꞌ shtsáꞌpiꞌ nagaꞌa lu camë. Bëáquiꞌ; hia adë nídiꞌi mëdzabë laꞌni ldúꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bëruꞌu më regiuni shtë Tiro nu gudëdë më lugar nalë Decápolis; bëdchini më guëꞌdchi Sidón naná ruaꞌ nisëduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Beꞌdënú mënë tubi naná guꞌpë nu natiꞌngu ruadíꞌdzëll. Runë mënë ruëguë lu më guëdchiꞌbë më guiaꞌa më guëc nguiu ni të guëáquëll. ");
INSERT INTO zacNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Biaꞌa Jesús lë́ꞌëll tubi ladë. Bëzëꞌë më shcuënë më laꞌni diáguëll. Bëtiaꞌa më duꞌpë shënë më lu ldúdzëll. ");
INSERT INTO zacNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Iurní guná më lu gubeꞌe; bëcaꞌa lduꞌu më nu guníꞌiꞌ: ―Efata. (Ndëꞌë runë cuntienë dizë́ shtë më, guëac diáguël.) ");
INSERT INTO zacNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Lueguë bëllaꞌlë diaguë nguiu ni, nu bëac ldúdzëll. Guzublú ruadíꞌdzëll bien. ");
INSERT INTO zacNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús gunibëꞌa ra mënë adë chu lu guadiꞌdzë rall lo quë nabë́ꞌniꞌ perë por más guniꞌi më, más bërëꞌtsë diꞌdzë nabëꞌnë më. ");
INSERT INTO zacNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nalë́ guasë́ lduꞌu mënë; rniꞌi rall: ―Grë narunë Jesús na bien. Ra cueꞌtë rini rall nu ra guꞌpë ruadiꞌdzë rall. ");
INSERT INTO zacNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Guc tubi dzë zihani mënë bëdëá lu më, nu nápëdiꞌi rall nagáu rall. Jesús gunaꞌbë ra shini gusëꞌdë më; guniꞌi më: ");
INSERT INTO zacNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Nalë́ rgaꞌa lduaꞌa ra mënë rëꞌ purquë hia guc tsunë dzë zeꞌdë naldë rall na nu nápëdiꞌi rall nagáu rall. ");
INSERT INTO zacNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Si talë guësheꞌlda lëꞌë rall lidchi rall sin adë gáudiꞌi rall, scaꞌa mbeeꞌzë rall lu nezë. Bëldá rall zitu zeꞌdë rall. ");
INSERT INTO zacNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ra shini gusëꞌdë më bëquebi: ―¿Ca guiá caꞌa hiaꞌa guetështildi gau rall? Ni tubi mënë quëréldëdiꞌi ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús gunaꞌbë diꞌdzë: ―¿Bëldá guetështildi napë të? Guniꞌi raiꞌ: ―Gadchi. ");
INSERT INTO zacNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iurní Jesús gunibëꞌa subë mënë zihani lu guiuꞌu. Gunaꞌzi më guëzá guetështildi. Bëdëꞌë më graci lu Dios; lueguë bëshullë më guetështildi; bëdëꞌë më cuaꞌa ra shini gusëꞌdë më të quiꞌdzë raihin parë gau ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nu nuaꞌa raiꞌ bëldá mbeldë. Jesús bëdëꞌë graci; guniꞌi më lu shini gusëꞌdë më të quiꞌdzë raiꞌ mbeldë lu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Grë́tëꞌ mënë gudáu rall hashtë catë lu bielë rall. Iurní bëtëá raiꞌ gadchi tëpë pedasë nabëꞌnë subrë. ");
INSERT INTO zacNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Grë ra nagudáu na ra ziquë tapë mili nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Iurní bëꞌnë Jesús despedir ra mënë; beꞌpi më laꞌni barcu con ra shini gusëꞌdë më të ziaꞌa raiꞌ regiuni nalë Dalmanuta. ");
INSERT INTO zacNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bëdchini ra fariseo lu Jesús. Guzublú rchupë diꞌdzë rall. Bëtëꞌdë rall tubi prëbë lëꞌë më, nihunë më tubi milagrë lu rall. ");
INSERT INTO zacNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bëcaꞌa lduꞌu më nu guniꞌi më: ―¿Pëzielú rac shtuꞌu të guëná të tubi milagrë? Guldía rniaꞌa lu të; gúnëdiaꞌa ni tubi milagrë delantë lu të. ");
INSERT INTO zacNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Iurní bësëaꞌnë më lëꞌë ra mënë të güeꞌpi më stubi vueltë laꞌni barcu. Ziaꞌa më stubi ladë ruaꞌ nisë ruꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ra shini gusëꞌdë më nuaꞌa tubsë guetështildi laꞌni barcu purquë bëaꞌldë lduꞌu raiꞌ niuaꞌa raiꞌ nagáu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús guniꞌi lu raiꞌ: ―Gulë gupë cuidadë levadurë shtë ra fariseo nu levadurë shtë Herodes. ");
INSERT INTO zacNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Iurní guzublú guniꞌi raiꞌ lu saꞌ raiꞌ: ―Aquë. Adë chu nuáꞌadiꞌi guetështildi, por ni rniꞌi më zndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús guc bëꞌa laꞌni ldúꞌiꞌ lo quë nabëꞌnë raiꞌ llgabë. Guniꞌi më: ―¿Pëzielú rniꞌi lu saꞌ të nuáꞌadiꞌi të guetështildi? ¿Pë adë riasë́diꞌi të? ¿Pë adë rdë́ꞌëdiꞌi të cuendë? ¿Pë naguëdchi lduꞌu të? ");
INSERT INTO zacNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Pë adë nápëdiꞌi të slu të parë guëná të? ¿Pë adë rini të? ¿Pë adë rëagná lduꞌu të milagrë nabëna? ");
INSERT INTO zacNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Dzë na bëshulla guetështildi parë gudáu gaꞌi mili nguiu, ¿bëldá tëpë pedasë bëtëá të? Bëquebi raiꞌ: ―Chiꞌbë chupë tëpë. ");
INSERT INTO zacNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Nu iurë bëshulla gadchi guetështildi parë tapë mili nguiu, ¿bëldá tëpë pedasë bëtëá të? Guniꞌi raiꞌ: ―Gadchi tëpë. ");
INSERT INTO zacNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Guniꞌi më lu raiꞌ: ―¿Pë laꞌdi guëdë́ꞌëdiꞌi të cuendë chu nahia? ");
INSERT INTO zacNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iurní bëdchini raiꞌ guëꞌdchi Betsaida. Beꞌdënú ra mënë tubi ciegu lu më. Bëꞌnë rall ruëguë guëdchiꞌbë më guiaꞌa më guëc ciegu të guëáquëll. ");
INSERT INTO zacNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Gunaꞌzi më guiaꞌa ciegu; guanú më lë́ꞌëll fuërë shtë guëꞌdchi. Bëtiaꞌa më duꞌpë shënë më ruaꞌ slull; bëdchiꞌbë më guiaꞌa më guë́quëll nu gunaꞌbë diꞌdzë më: ―¿Gu rnal duꞌpë? ");
INSERT INTO zacNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Lëꞌë ciegu guná guiaꞌa; répill lu më: ―Rnahia lu ra mënë cumë ziquë ra hiaguë; ziazú rahin. ");
INSERT INTO zacNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iurní bëdchiꞌbë Jesús guiáꞌaiꞌ ruaꞌ slu ciegu stubi. Bëldisë më lull guiaꞌa. Lueguë bëac slull; beꞌrquë rnall zitu. ");
INSERT INTO zacNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iurní Jesús bësheꞌldë lë́ꞌëll; ziagzëll lídchill. Guniꞌi më: ―Adë tsutël guëꞌdchi nu adë chu lu guadíꞌdzëdiꞌil lo quë nabëna. ");
INSERT INTO zacNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús nu ra shini gusëꞌdë më gua raiꞌ parë regiuni nalë Cesarea Filipo. Iurë ziazú më nezë, gunaꞌbë diꞌdzë më lu raiꞌ: ―¿Chu rniꞌi mënë nahia? ");
INSERT INTO zacNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bëquebi raiꞌ: ―Nanú mënë narniꞌi nal Juan Bautista. Stúbill rniꞌi nal Elías. Sëbëldá mënë rniꞌi nal tubi nabiadiꞌdzë shtiꞌdzë Dios guahietë. ");
INSERT INTO zacNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Repi Jesús lu raiꞌ: ―Lëꞌë të ¿chu rniꞌi të nahia? Pedro guniꞌi: ―Nal Cristo, el quë nagudili Dios parë guënibë́ꞌal. ");
INSERT INTO zacNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iurní gunibëꞌa më adë chu lu guadíꞌdzëdiꞌi raiꞌ na më Cristo. ");
INSERT INTO zacNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Iurní guzublú rluaꞌa Jesús lëꞌë ra shini gusë́ꞌdëiꞌ de quë nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, gúniꞌ sufrir demasiadë. Guniꞌi më ra mëgulë narnibëꞌa nu ra bëshuzi namás lasac con ra mësë narluaꞌa lëy, gunë rall desprëci lëꞌë më. Guniꞌi më quini rall lëꞌë më perë despuësë de tsunë dzë, tsashtë́ më ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Clarë guniꞌi më diꞌdzë ni. Iurní Pedro biaꞌa lëꞌë Jesús tubi ladë nu guzublú gudildi Pedro lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús bëdchigrë́ lu më; guná më lu shini gusëꞌdë më. Gudildi më lëꞌë Pedro; fuertë guniꞌi më: ―Guabsú lua, Satanás. Adë rúnëdiꞌil llgabë ziquë Dios sino ziquë mënë shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iurní gunaꞌbë Jesús ra shini gusëꞌdë më nu ra mënë zihani; guniꞌi më lu rall: ―Si talë nanú mënë narac shtuꞌu gáquëll shmëna, napë quë gúnëll renunci prupi deseo shtë́nëll. Napë quë gáquëll dispuestë gátill por na; nu guidë náldëll na. ");
INSERT INTO zacNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","El quë nadë rac shtúꞌudiꞌi gati por na, zátill. Perë el quë naguëniti vidë shtë́niꞌ por na nu por dizaꞌquë, guëbánill parë siemprë; gac salvárëll. ");
INSERT INTO zacNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Adë pë rlluíꞌidiꞌi gunë nguiu gan grë́tëꞌ cusë lu guë́ꞌdchiliu nu despuësë guënítill vidë shtë́nëll, adë nídiꞌi fin parë lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Pë ofrendë guëdëꞌë nguiu lu Dios parë gac salvárëll? ");
INSERT INTO zacNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ra mënë bësaꞌnë rall shnezë Dios nu napë rall zihani duldë. Cualquier de lëꞌë nguiu si talë rtu lull de na; si talë rtu lull de dizaꞌquë delantë saꞌll, iurní guëtú lua de lëꞌë nguiu ni iurë gueldë guëdchinia de gubeꞌe. Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu; guëdchinia con ra ianglë shtë gubeꞌe. Guëdchinia con pudërë nu llni shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","También guniꞌi më: ―Guldía, nabani bëldá mënë ndëꞌë; adë gátidiꞌi rall hashtë guëná rall de quë cagnibëꞌa Dios laꞌni lduꞌu mënë, de quë hia rnibëꞌa më con pudërë. ");
INSERT INTO zacNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Gudëdë shuꞌpë dzë; Jesús biaꞌa Pedro nu Jacobo nu Juan; ziazú raiꞌ tubi dani ruꞌbë. Iurní Jesús guc cambi delantë lu ra shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Shabë më guc cambi hashtë rabëniꞌi tantë naquichin ziquë ni tubi biashtildi adë gúnëdiꞌi gan guësëquichin. ");
INSERT INTO zacNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bëluaꞌalú Elías nu Moisés lu raiꞌ. Guná raiꞌ quëadiꞌdzë Jesús con Elías nu Moisés. ");
INSERT INTO zacNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Iurní Pedro guniꞌi: ―Mësë, nabënë dzu hiaꞌa ndëꞌë. ¿Pë zëdëntsaꞌu naꞌa tsunë ranchi ndëꞌë? tubin parë lë́ꞌël guëquëréldël, stubin parë Moisés, stubin parë Elías. ");
INSERT INTO zacNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Perë rac bë́ꞌadiꞌi Pedro pë guníꞌiꞌ tantë bëdzëbë ra shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Iurní bëdchini tubi shcahi nabësëꞌau grë raiꞌ, nu bini raiꞌ tubi bë naguniꞌi laꞌni shcahi: ―Ndëꞌë lëꞌë shinia narac shtuaꞌa; gulë bëquë́ diaguë shtíꞌdziꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Iurní guná ra shini gusëꞌdë më grë ladë; ni tubi chu lu guná raiꞌ; sulë Jesús zugaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bietë raiꞌ lu dani. Gunibëꞌa më ni tubi chu lu guepi raiꞌ naguná raiꞌ lu dani hashtë iurë lëꞌë nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu tsashtë́hiꞌ ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Adë chu lu biadíꞌdzëdiꞌi raiꞌ lo quë guná raiꞌ guëc dani perë gunaꞌbë diꞌdzë lu saꞌ raiꞌ pë runë cuntienë shtiꞌdzë më de quë tsashtë́hiꞌ ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Iurní gunaꞌbë diꞌdzë raiꞌ lu më: ―¿Pëzielú rniꞌi ra mësë shtë lëy de quë Elías napë quë guídiꞌ primërë? ");
INSERT INTO zacNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Bëquebi më: ―Verdá nahin. Hia bidë Elías të parë gunë záꞌquiꞌ grë́tëꞌ ra cusë. Perë ¿pë rniꞌi ra Sagradas Escrituras cerquë shcuendë nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu? Pues rniꞌi rahin de quë gúniꞌ sufrir; sac zíhiꞌ; nu gunë mënë desprëci lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Guná, hia bidë Elías nu bëꞌnë ra mënë lo quë naguc shtuꞌu rall. Lo quë naná escritë de lë́ꞌiꞌ hia guc cumplir. ");
INSERT INTO zacNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Bëagrí raiꞌ catë zubë los de más shini gusëꞌdë më. Guná raiꞌ zihani mënë alrededurë shtë raiꞌ. Ra mësë narluaꞌa lëy gudildi diꞌdzë rall con lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Iurë guná ra mënë lu Jesús, guasë́ lduꞌu rall; beꞌdë guëlluꞌnë rall lu më parë gunë rall saludar lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iurní gunaꞌbë diꞌdzë Jesús lu rall: ―¿Pëllë quëadiꞌdzë të ngaꞌli? ¿Pëzielú gudildi diꞌdzë të? ");
INSERT INTO zacNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Iurní tubi nguiu bëruꞌu ladi grë mënë; guníꞌill: ―Mësë, zeldënúa llgaꞌna lul. Nápëll tubi mëdzabë laꞌni ldúꞌull. Nall guꞌpë, bëꞌnë mëdzabë. ");
INSERT INTO zacNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ancalë rnaꞌzi mëdzabë lëꞌë llguëꞌnë, rruꞌldë mëdzabë lë́ꞌëll lu guiuꞌu. Rruꞌu bëchini ruaꞌll nu rchushí laiꞌll. Zni másruꞌu rbáꞌcull. Zeꞌdënúa lë́ꞌëll lu shini gusë́ꞌdël perë adë bë́ꞌnëdiꞌi rall gan nëac llguëꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Repi më iurní: ―Lëꞌë të nalë́ naguëdchi lduꞌu të. ¿Hashtë guc guëbezënúa lëꞌë të, të parë tsaldí lduꞌu të shtiꞌdza? ¿Blac tiempë guëquëreldënúa lëꞌë të, të parë tsaldí lduꞌu të? Gudeꞌenú shínil lua. ");
INSERT INTO zacNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Iurë beꞌdë guënú shtadë llguëꞌnë lëꞌë llguëꞌnë lu Jesús, guná mëdzabë guꞌpë lu Jesús. Bëruꞌldë mëdzabë ngulëꞌnë lu guiuꞌu. Bëchiꞌchi llguëꞌnë nu guꞌtë guduꞌbi llguëꞌnë lu guiuꞌu; bëruꞌu bëchini ruaꞌll. ");
INSERT INTO zacNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús gunaꞌbë díꞌdziꞌ lu shtadë llguëꞌnë: ―¿Blac tiempë rac lluꞌu llguëꞌnë? Bëquebi shtadë llguëꞌnë: ―Dizdë nabíꞌchill. ");
INSERT INTO zacNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Zihani vueltë bëtiaꞌa mëdzabë lë́ꞌëll lu guiꞌi u lu nisë të gati llguëꞌnë. Si talë záquël gunëáquël lë́ꞌëll zuduꞌpë, bëꞌnë favurë; bëgaꞌa ldúꞌul lëꞌë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Guniꞌi Jesús lu shtadë llguëꞌnë: ―¿Pëzielú rníꞌil lua zniꞌi? Si talë tsaldí ldúꞌul Dios, lëꞌë më gunë më grë́tëꞌ cusë parë lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Lueguë shtadë llguëꞌnë guniꞌi fuertë: ―Rialdí lduaꞌa perë bëꞌnë compañi na të tsaldí lduaꞌa más. ");
INSERT INTO zacNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesús guná nalë́ zihani mënë bëdëá hashtë rdiaꞌa lu saꞌ rall. Iurní fuertë guniꞌi më guëc mëdzabë: ―Lë́ꞌël mëdzabë naná guꞌpë nu cueꞌtë, rnibë́ꞌahia lë́ꞌël; bëruꞌu de llguëꞌnë rëꞌ nu adë guëabrídiꞌi tsutël laꞌni ldúꞌull jamás. ");
INSERT INTO zacNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Iurní lëꞌë mëdzabë gurushtiá nu bërúꞌldëll lëꞌë llguëꞌnë lu guiuꞌu nu bëséꞌsëll lëꞌë llguëꞌnë. Bëruꞌu mëdzabë; bëaꞌnë llguëꞌnë ziquë naguti. Zihani mënë guniꞌi hia guti llguëꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Perë Jesús gunaꞌzi guiáꞌall parë bëldisë më lë́ꞌëll. Guasuldill. ");
INSERT INTO zacNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iurní guatë́ Jesús tubi hiuꞌu nu ra shini gusëꞌdë më guatë́ raiꞌ. Gunaꞌbë diꞌdzë raiꞌ lu Jesús: ―¿Pëzielú adë bë́ꞌnëdiꞌi naꞌa gan niagú naꞌa mëdzabë fier laꞌni llguëꞌnë? ");
INSERT INTO zacNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Repi Jesús: ―Sulë si talë rialdí lduꞌu të de verdá nu gunë të ayunë, iurní gapë të pudërë parë guëgú të mëdzabë ziquë mëdzabë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bëruꞌu raiꞌ lugar ni; gudëdë më nezë Galilea. Adë guc shtuꞌu më ni tubi chu gac bëꞌa ca ziaꞌa raiꞌ ");
INSERT INTO zacNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","purquë quëgluaꞌa më ra shini gusëꞌdë më. Guniꞌi më lu raiꞌ: ―Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. Gac entregara lu guiaꞌa mënë të quini rall na perë dzë tsunë tsashtë́a ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Adë guasë́diꞌi raiꞌ shtiꞌdzë më. Bëdzëbë raiꞌ nianaꞌbë diꞌdzë raiꞌ lu Jesús pë runë cuntienë lo quë naguniꞌi më. ");
INSERT INTO zacNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Iurní bëdchini raiꞌ guëꞌdchi Capernaum. Iurë nanú raiꞌ laꞌni hiuꞌu, gunaꞌbë diꞌdzë më lu ra shini gusëꞌdë më: ―¿Pë cagniꞌi lu saꞌ të ngaꞌli iurë zeꞌdë zu të nezë? ");
INSERT INTO zacNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bëac dchi raiꞌ purquë bëchupë diꞌdzë raiꞌ chu namás më lasac entrë lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iurní guzubë më; gunaꞌbë më ra chiꞌbë chupë shini gusëꞌdë më; guniꞌi më: ―Si talë tubi të rac shtúꞌul gáquël më más lasac lu saꞌl, napë quë gáquël lúltimë de grë të nu napë quë gúnël sirvë los de más saꞌl. ");
INSERT INTO zacNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Iurní gunaꞌbë më tubi llguëꞌnë; bëzú më llguëꞌnë guëláu ladi ra shini gusëꞌdë më. Gudëdchi më lëꞌë llguëꞌnë nu guniꞌi më lu raiꞌ: ");
INSERT INTO zacNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―El quë naquëhapë tubi llguëꞌnë ziquë ndëꞌë purquë mënë ni rac shtúꞌull na, también quëhúnëll recibir na. El quë naquëhunë recibir na, también quëhúnëll recibir el quë nabësheꞌldë na. ");
INSERT INTO zacNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Iurní Juan guniꞌi lu Jesús: ―Mësë, guná naꞌa tubi nguiu; rgull mëdzabë laꞌni lduꞌu mënë iurë rníꞌill lël, perë lëꞌë naꞌa bëdëꞌnë naꞌa prohibë tsagláꞌguëdiꞌi gull mëdzabë purquë adë rzënúdiꞌill lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús guniꞌi: ―Adë chu guëcádiꞌi lë́ꞌëll purquë el quë naquëhunë milagrë por pudërë shtëna, adë nádiꞌill capaz guëníꞌill cuntrë na. ");
INSERT INTO zacNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","El quë nadë rníꞌidiꞌi cuntrë lëꞌë hiaꞌa, nall favurë de lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Cualquier mënë naguëneꞌe tubi vasë nisë gu të, rnéꞌell nisë ni purquë na të shmëna, segurë guëdëꞌë Dios premi caꞌa nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Iurní repi më: ―Cagniaꞌa shcuendë tubi më humildë naná rialdí lduꞌi na. El quë narluaꞌa tubi më humildë mal nezë të gúnëll duldë, mejurë galdë nguiu ni tubi guichi ruꞌbë iénill; tsagrúꞌldëll lë́ꞌëll laꞌni nisëduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Si talë guiáꞌal rac shtuꞌu guëldaguë lë́ꞌël lu duldë, bëchuguë guiáꞌal. Mejurë guëdchínil con tubsë guiáꞌal catë nápël vidë sin fin quë guëdubi cuerpë tsal gabildi. Ndë nunquë rëáldëdiꞌi beꞌlë.  ");
INSERT INTO zacNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","nu mbiziuguë adë rátidiꞌi; nunquë adë rëáldëdiꞌi guiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Si talë guëaꞌl rac shtuꞌu guëldaguë lë́ꞌël lu duldë, bëchuguë guëaꞌl. Mejurë guëdchínil tubsë guëaꞌl catë nápël vidë sin fin quë guëdubi cuerpë guziáꞌal gabildi catë nunquë rëáldëdiꞌi beꞌlë  ");
INSERT INTO zacNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","nu rátidiꞌi mbiziuguë nu adë rëáldëdiꞌi guiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Si talë slul rac shtuꞌu guëldaguë lë́ꞌël lu duldë, gulú slul. Mejurë tsutël catë rnibëꞌa Dios tubsë slul, no sea tsal gabildi con guërupë slul. ");
INSERT INTO zacNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ndë ra mbiziuguë rátidiꞌi nu nunquë rëáldëdiꞌi beꞌlë. ");
INSERT INTO zacNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Grë mieti napë quë gac purificar raiꞌ con beꞌlë. Guëtiaꞌa mënë duꞌpë zedë guëc ma nadchiꞌbë lu bëcuꞌguë. ");
INSERT INTO zacNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nabënë na zedë perë si talë nápëdiꞌi zedë sabor, ¿lla gunë nguiu të guëabrí sabor shtë zedë? Gulë gapë zedë shtë galnaduꞌu nu gulë gac më pacënci delantë lu saꞌ të. ");
INSERT INTO zacNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Bëruꞌu më Capernaum; bëdchini më regiuni shtë Judea hashtë tubi lugar nanaquë́ nezë guiaꞌa guëëꞌgu Jordán. Zihani mënë bëdëá lu më; bëluaꞌa më lëꞌë rall ziquë siemprë. ");
INSERT INTO zacNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bidë guëbiꞌguë ra fariseo lu më; caguili rall mudë guëdchiꞌbë rall demandë cuntrë lëꞌë më. Gunaꞌbë diꞌdzë rall lu më si talë nanú permisi según lëy guësaꞌnë nguiu tseꞌlë nguiu. ");
INSERT INTO zacNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Bëquebi më: ―¿Pë bëquëꞌë Moisés laꞌni librë shtë Dios? ");
INSERT INTO zacNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Guniꞌi rall: ―Moisés bëdëꞌë permisi guësaꞌnë nguiu tseꞌlë nguiu, sulë napë quë guëdëꞌë nguiu tubi guichi shtë divurci. ");
INSERT INTO zacNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iurní guniꞌi më: ―Purquë nalë́ naguëdchi lduꞌu të, por ni bëquëꞌë Moisés mandamientë rëꞌ ");
INSERT INTO zacNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","perë dizdë guzublú guë́ꞌdchiliu, iurë bëntsaꞌu më grë́tëꞌ ra cusë, “Bëꞌnë Dios formar lëꞌë nguiu nu lëꞌë naꞌa”. ");
INSERT INTO zacNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Por ni guëruꞌu nguiu lidchi shtádëll con shníꞌall nu guëbaninú nguiu tséꞌlëll. ");
INSERT INTO zacNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Hia guërupë rall gac rall tubsë; nádiꞌi rall chupë sino tubsë. ");
INSERT INTO zacNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Por ni, lo quë nabëꞌnë Dios unir, adë chu guëldë́diꞌi lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Iurë nanú Jesús laꞌni hiuꞌu, ra shini gusëꞌdë më gunaꞌbë diꞌdzë raiꞌ lu më pë runë cuntienë diꞌdzë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Guniꞌi më: ―El quë naguësaꞌnë tséꞌliꞌ nu guëtsë́ꞌall stubi vueltë, rúnëll duldë lu primërë tséꞌlëll; ni na adulteri. ");
INSERT INTO zacNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nu si talë tubi naꞌa guësáꞌnëll tséꞌliꞌ të parë guëtsë́ꞌall stubi vueltë, rúnëll duldë adulteri. ");
INSERT INTO zacNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Iurní guanú mënë zihani ra llguëꞌnë parë guëdchiꞌbë guiaꞌa më guëc raiꞌ. Ra shini gusëꞌdë më gudildi raiꞌ naguanú ra llguëꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iurë guná më lla bëꞌnë ra shini gusëꞌdë më, bëldë́ më; guniꞌi më: ―Gulë bëdëꞌë sí, guidë ra llguëꞌnë lua. Adë guëcádiꞌi të lu ra niꞌi, purquë ra mënë naná ziquë ra llguëꞌnë tsutë́ rall catë rnibëꞌa Dios ziquë Rëy. ");
INSERT INTO zacNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Guldía, sulë el quë nagunë recibir Dios ziquë Rëy të guënibëꞌa më lë́ꞌëll ziquë tubi llguëꞌnë, sulë nguiu ni guëbánill catë na më rëy. ");
INSERT INTO zacNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Iurní gudëdchi më ra llguëꞌnë. Bëdchiꞌbë më guiaꞌa më guëc rall nu bëꞌnë ldaiꞌ më lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iurë ziaglaꞌguë Jesús nezë, bidë guëlluꞌnë tubi nguiu lu më. Bëzullíbill lu më nu gunaꞌbë díꞌdzëll: ―Mësë zaꞌquë, ¿lla guna parë gapa vidë sin fin? gac salvara. ");
INSERT INTO zacNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Guniꞌi më: ―¿Pëzielú rníꞌil lua nazaꞌca? purquë ni tubi adë chu nazaꞌquë, sulë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nanël ra mandamientë: “Adë rguínidiꞌil saꞌl; adë rquënúdiꞌil tseꞌlë saꞌl; adë cuánëdiꞌil pë shtë mënë; adë guadíꞌdzëdiꞌil bishi; adë guësiguë́diꞌil mënë, nu bëzuꞌbë diaguë shtiꞌdzë shtádël nu shníꞌal”. ");
INSERT INTO zacNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nguiu ni guniꞌi: ―Mësë, bëna cumplir grë ra mandamientë rëꞌ dizdë nabiꞌcha, ");
INSERT INTO zacNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús guná lull; nalë́ guc shtuꞌu më lë́ꞌëll. Guniꞌi më: ―Tubi cusë runë faltë; bëtuuꞌ grë cusë nanápël; bëdëꞌë dumí caꞌa ra prubi; iurní gápël tesurë lu gubeꞌe. Nu gudeꞌe naldë na; bëꞌnë renunci prupi deseo shtë́nël të guëluaꞌa nadispuestë sac zil por na. ");
INSERT INTO zacNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Iurë bini nguiu ni diꞌdzë shtë më, riá ldúꞌull; zëagzëll tristë purquë nápëll tubi shtaci ruꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Guná më lu ra nazugaꞌa alrededurë lëꞌë më; repi më lu ra shini gusëꞌdë më: ―Nalë́ naganë tubi nanapë zihani dumí gúnëll recibir Dios ziquë Rëy. ");
INSERT INTO zacNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ra shini gusëꞌdë më bëdzëguëëꞌ lduꞌu raiꞌ por diꞌdzë shtë më. Jesús guniꞌi lu raiꞌ: ―Lëꞌë të ziquë llguëꞌnë, blac naganë gunë ra ricu recibir Dios ziquë Rëy, ra nguiu narunë confiar dumí. ");
INSERT INTO zacNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Más sencigi tsutë́ tubi camellë ichi iagullë quë tubi ricu tsutëll catë rnibëꞌa Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iurní más guasë́ lduꞌu raiꞌ; guniꞌi lu saꞌ raiꞌ: ―¿Chúllëtiꞌi gac salvar? ¿Chull gapë vidë sin fin? ");
INSERT INTO zacNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús guná lu grë raiꞌ; guniꞌi më: ―Adë gúnëdiꞌi nguiu gan gunë salvar lë́ꞌiꞌ perë Dios napë pudërë gunë më grë́tëꞌ ra cusë. ");
INSERT INTO zacNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Iurní Pedro guniꞌi lu më: ―Guná, lëꞌë naꞌa bësaꞌnë naꞌa grë́tëꞌ cusë parë zeꞌdë naldë naꞌa lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Guniꞌi Jesús: ―Guldía, el quë nabësaꞌnë lídchiꞌ, bë́chiꞌ, zániꞌ, shtádiꞌ u shníꞌaiꞌ, u tséꞌliꞌ, u shíniꞌ, u guiuꞌu lachi shtë́niꞌ; guësánëll ra cusë ni purquë rac shtúꞌull dizaꞌquë shtëna, niétiquë guënítidiꞌill. ");
INSERT INTO zacNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Gúnëll recibir zihani cusë más iurneꞌ hashtë tubi gahiuꞌa vueltë más lídchiꞌ, bë́chiꞌ, zániꞌ, shníꞌaiꞌ, shíniꞌ, shláchiꞌ. Nu gunë mënë cuntrë nguiu ni perë despuësë guëbánill lu gubeꞌe tubi vidë sin fin. ");
INSERT INTO zacNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Zihani mënë nalasac iurneꞌ delantë lu saꞌ rall, gac rall lúltimë dzë ni; nu zihani naná lúltimë iurneꞌ, gac rall mënë namás lasac lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nianá ziazú raiꞌ nezë Jerusalén, ziazú më delantë lu ra shini gusëꞌdë më. Nalë́ guasë́ lduꞌu raiꞌ nu ra nacanaldë tëchi më, bëdzëbë rall. Iurní lëꞌë më biaꞌa lëꞌë ra shini gusëꞌdë më tubi cuꞌ; guzubëlú guniꞌi më lu raiꞌ ra cusë nagunënú mënë lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Guniꞌi më: ―Zia hiaꞌa Jerusalén catë gunë ra mënë cuntrë na, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. Ndë gac entregara guiaꞌa ra jëfë shtë ra bëshuzi nu lu ra mësë shtë lëy. Gunë rall condenar na lu galguti. Gunë rall intriegu na lu guiaꞌa mënë de stubi naciuni. ");
INSERT INTO zacNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Gunë rall burnë de na; guëchiꞌbë shënë rall lua nu guëquëꞌë hiaguë rall na nu quini rall na, perë dzë tsunë tsashtë́a ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Iurní Juan nu Jacobo, shini Zebedeo, bëdchini raiꞌ lu Jesús. Guniꞌi raiꞌ: ―Mësë, rac shtuꞌu naꞌa gúnël tubi favurë naguënaꞌbë naꞌa lul. ");
INSERT INTO zacNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Guniꞌi më lu raiꞌ: ―¿Pë rac shtuꞌu të guna? ");
INSERT INTO zacNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Guniꞌi raiꞌ: ―Rac shtuꞌu naꞌa guënéꞌel permisi iurë guënibë́ꞌal ziquë Rëy, subënú naꞌa lë́ꞌël, tubi de lëꞌë naꞌa ladë ldi, stubi de lëꞌë naꞌa ladë rubësë. ");
INSERT INTO zacNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Iurní guniꞌi Jesús lu raiꞌ: ―Adë guënë́diꞌi të lo quë narnaꞌbë të lua. Gulë guniꞌi lua, ¿zëzac zi të ziquë na? ¿Zac tëdë të cusë durë natëda? ");
INSERT INTO zacNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bëquebi raiꞌ: ―Zac naꞌa. Jesús guníꞌiꞌ: ―Guldí të. Gunë të sufrir demasiadë ziquë guna sufrir. Gu të el mizmë vasë shtë sufrimientë ");
INSERT INTO zacNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","perë parë subë të culaꞌnia, tubi de lëꞌë të ladë ldi, stubi ladë rubësë, adë rúnëdiꞌi tucarë guënehia sí subë të ndë. Dios bëꞌnë preparar lugar ni sulë parë ra narac shtuꞌu më subë rall ndë. ");
INSERT INTO zacNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Iurë bini chiꞌi shini gusëꞌdë më lo quë nagunaꞌbë Jacobo nu Juan, bëldënú raiꞌ Jacobo nu Juan. ");
INSERT INTO zacNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús gunáꞌbëiꞌ lëꞌë raiꞌ, nu guniꞌi më: ―Lëꞌë të nanë́ të ra jëfë shtë naciuni nanádiꞌi më israelitë, nalë́ rzac zi rall mënë nu rdchiꞌbë rall lëy naná dushë ");
INSERT INTO zacNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","perë adë gáquëdiꞌi zni entrë lëꞌë të. Si talë rac shtúꞌul gáquël më ruꞌbë lu saꞌl, napë quë gúnël sirvë los de más saꞌl. ");
INSERT INTO zacNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Cualquier de lëꞌë të si talë rac shtúꞌul gáquël mayurë entrë grë ra saꞌl, napë quë gáquël muzë shtë grë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu; zelda ziquë muzë shtë mënë. Zéldëdiaꞌa parë gunë mënë sirvë lua. Guënehia vidë shtëna ziquë prëci parë gac salvar zihani mënë. ");
INSERT INTO zacNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iurní bëdchini Jesús con ra shini gusëꞌdë më guëꞌdchi Jericó. Iurë hia na raiꞌ parë guëruꞌu raiꞌ guëꞌdchi, zianaldë cantidá mënë lëꞌë raiꞌ. Tubi ciegu nalë Bartimeo naná shini Timeo, zúbëll lu nezë. Cagnáꞌbëll guꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bini Bartimeo zeꞌdë Jesús më Nazaret; iurní fuertë guníꞌill: ―Jesús llëbní David, bëgaꞌa ldúꞌul na. ");
INSERT INTO zacNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Zihani mënë guniꞌi rall guëc Bartimeo të guëac dchill perë lë́ꞌëll másruꞌu fuertë guníꞌill: ―Llëbní David, bëgaꞌa ldúꞌul na. ");
INSERT INTO zacNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iurní Jesús guzudchí; guniꞌi më: ―Gulë guaglliꞌi ciegu rëꞌ. Gunaꞌbë raiꞌ lëꞌë ciegu nu guniꞌi raiꞌ: ―Bëquitë ldúꞌul. Guasuldí; cagnaꞌbë Jesús lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Iurní bëruꞌldë Bartimeo shabë guítsëll nu bëchésëll. Guagllúꞌnëll lu më. ");
INSERT INTO zacNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús guniꞌi lull: ―¿Pë rac shtúꞌul guna? Bartimeo guniꞌi: ―Mësë, rac shtuaꞌa guënahia ziquë antsë. ");
INSERT INTO zacNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús repi: ―Bëagzë́, hia bëáquël purquë rialdí ldúꞌul na. Bëac nguiu ni nu guanáldëll lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iurní ziagdchini raiꞌ guëꞌdchi Jerusalén guëllaꞌ ra guëꞌdchi Betfagé nu Betania. Bëdchini raiꞌ ruaꞌ dani shtë Olivos nanaquë́ frentë parë Jerusalén. Iurní Jesús bëshéꞌldiꞌ chupë shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Guniꞌi më: ―Gulë tsa guëꞌdchi nanaquë́ delantë. Ngaꞌli guëdzelë të tubi burrë; quëdú ma ruaꞌ nezë. Lëꞌë burrë ni laꞌdi chu quíbëdiꞌi tëchi ma. Gulë bëshaꞌquë ma nu gulë teꞌenú ma ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Si talë guënaꞌbë diꞌdzë mënë pë gunë të burrë, gulë guniꞌi lull de quë lëꞌë mësë shtënë të rquíꞌniꞌ lëꞌë ma, nu lueguë guëshéꞌldiꞌ lëꞌë ma. ");
INSERT INTO zacNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iurní ziaꞌa ra shini gusëꞌdë më; bëdiaꞌguëlú raiꞌ lëꞌë ma naquëdú ruaꞌ nezë. Bëshaꞌquë raiꞌ lëꞌë ma. ");
INSERT INTO zacNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bëldá mënë nazú ngaꞌli guniꞌi rall: ―¿Pë quëhunë të? ¿Pëzielú bëshaꞌquë të burrë rëꞌ? ");
INSERT INTO zacNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Repi raiꞌ ziquë guniꞌi Jesús lu raiꞌ. Iurní bësaꞌnë mënë parë biaꞌa raiꞌ burrë. ");
INSERT INTO zacNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bëdchini raiꞌ lu Jesús, nu bëdchiꞌbë raiꞌ shabë raiꞌ tëchi burrë të gudchibë Jesús tëchi ma. ");
INSERT INTO zacNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Zihani mënë gudishi shabë rall lu nezë catë zeꞌdë Jesús. Stubi shcuaꞌa mënë bëldietë rall ndiaguë shtë hiaguë. Gudishi rallin lu nezë. ");
INSERT INTO zacNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Iurní mënë nazeꞌdë delantë nu ra nazeꞌdë trasë nalë́ fuertë guniꞌi rall: ―Gunë më salvar. Benditë el quë nazeꞌdë guëdchini por partë shtë më. ");
INSERT INTO zacNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bëꞌnë ldaiꞌ Dios lëꞌë Rëy nazeꞌdë; súbëll lu trunë shtë David, shtadë guëlú hiaꞌa. Llëruꞌbë na pudërë shtë Dios nacabezë gubeꞌe. Gunë më salvar. ");
INSERT INTO zacNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Guatë́ Jesús Jerusalén. Lueguë guatë́ më iáduꞌu ruꞌbë; guná më grë ladë, iurní bëruꞌu më; ziaꞌa më Betania con ra shini gusëꞌdë më purquë hia guadzeꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Stubi dzë bëruꞌu raiꞌ Betania. Iurë ziazú më nezë, bëldiaꞌnë më; guná më zitu tubi hiaguë bëldaꞌu nanapë ndiaguë. ");
INSERT INTO zacNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Guagná më si talë naquë́ nashi lu hiaguë, gau më. Adë bëdzélëdiꞌi më nashi; purë ndiaguë naquë́ lu hiaguë purquë nádiꞌi shtiempë nashi. ");
INSERT INTO zacNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Iurní guniꞌi më lu hiaguë: ―Nunquë jamás adë chu gáudiꞌi nashi shtë́nël. Bini ra shini gusëꞌdë më lo quë naguniꞌi më lu hiaguë. ");
INSERT INTO zacNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bëdchini raiꞌ Jerusalén. Guatë́ më laꞌni iáduꞌu ruꞌbë. Guzubëlú bësëlluꞌnë më ra naquëgtuuꞌ nu ra naquëgziꞌi laꞌni iáduꞌu. Bërëꞌshë më mellë shtë ra nacagchili dumí. Bërëꞌshë më ra iagshili shtë ra nacagtuuꞌ palumë. ");
INSERT INTO zacNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Gunibëꞌa më ni tubi chu guaꞌa trashtë laꞌni iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bëluaꞌa më ra mënë; guníꞌiꞌ: ―Laꞌni Sagradas Escrituras rniꞌi zndëꞌë: “Iáduꞌu shtëna na parë gunë mieti orar lu Dios”; perë lëꞌë të bëꞌnë të cambi iáduꞌu ziquë cuevë shtë ngubaꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ra jëfë shtë bëshuzi nu ra mësë narluaꞌa lëy bini rall shtiꞌdzë më. Bëdzëbë rall lëꞌë më purquë grë́tëꞌ mënë guasë́ lduꞌu rall enseñansë shtë më. Por ni gudili ra contrari shtë më mudë parë quini rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Iurë bëdchini gueꞌlë, Jesús con ra shini gusë́ꞌdëiꞌ bëruꞌu raiꞌ ciudá Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Stubi dzë rsili gudëdë raiꞌ catë zubë hiaguë bëldaꞌu. Guná raiꞌ gubidchin hashtë shluꞌchin. ");
INSERT INTO zacNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Iurní Pedro bëagná lduꞌi shtiꞌdzë më; guniꞌi Pedro: ―Mësë guná, lëꞌë hiaguë naguludel lëꞌin gubidchi. ");
INSERT INTO zacNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Guniꞌi më: ―Gulë tsaldí lduꞌu të shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Guldía rniaꞌa lu të, cualquier nguiu narniꞌi lu dani rëꞌ: “Guabsú ndëꞌë nu tsal laꞌni nisëduꞌu”, si talë adë rzádiꞌi lduꞌu nguiu ni, si talë tsaldí ldúꞌull, gunë më lo quë naguníꞌill. ");
INSERT INTO zacNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Por ni rniaꞌa lu të, grë́tëꞌ lo quë narnáꞌbël lu Dios, gulë tsaldí lduꞌu të gunë të recibirin, iurní guëneꞌe mëhin. ");
INSERT INTO zacNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Iurë cagnáꞌbël lu Dios, bëꞌnë perdunë contrari shtë́nël, iurní Shtádël naquëbezë gubeꞌe gúniꞌ perdunë duldë shtë́nël.  ");
INSERT INTO zacNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","En cambi si talë adë në́diꞌil gúnël perdunë saꞌl, tampuquë gunë Dios perdunë lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bëagrí raiꞌ Jerusalén stubi vueltë. Guatë́ më iáduꞌu ruꞌbë. Iurní bëdchini ra jëfë shtë ra bëshuzi nu ra mësë narluaꞌa lëy con ra më gushë shtë guëꞌdchi. Bëdchini rall lu Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Gunaꞌbë diꞌdzë rall: ―¿Chu shtë permisi rúnël cusë rëꞌ? ¿Chu bësheꞌldë lë́ꞌël? ");
INSERT INTO zacNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús bëquebi: ―Nu na guënaꞌbë diꞌdza lu të. Gulë guniꞌi lua, iurní guëniaꞌa lu të chu bëneꞌe permisi parë guna ra cusë. ");
INSERT INTO zacNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Chu bësheꞌldë Juan Bautista parë guëchuꞌbë nísiꞌ, Dios u mënë? Gulë guniꞌi chu bëdëꞌë permisi lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Guzublú gunaꞌbë diꞌdzë lu saꞌ rall. Guniꞌi rall: ―Si talë guëniꞌi hiaꞌa lu Jesús de quë Dios bësheꞌldë Juan, iurní guënaꞌbë diꞌdzë Jesús lu hiaꞌa: “¿Pëzielú adë gualdídiꞌi lduꞌu të shtíꞌdziꞌ?” ");
INSERT INTO zacNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ni mudë guëniꞌi hiaꞌa lu Jesús: “Ra mënë bësheꞌldë lëꞌë Juan”. Zni cagniꞌi rall purquë bëdzëbë rall ra mënë. Casi grë mënë gualdí lduꞌu rall de quë Dios bësheꞌldë Juan të guëníꞌiꞌ shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Iurní guniꞌi rall lu Jesús: ―Rdë́ꞌëdiꞌi naꞌa cuendë chu bësheꞌldë lëꞌë Juan. Jesús guniꞌi lu rall: ―Nu na adë guëquébidiaꞌa lu të chu bësheꞌldë na parë runa ra cusë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Guzublú Jesús cagniꞌi më por comparaciuni; guniꞌi më: ―Tubi nguiu bëcabní zihani hiaguë uvë nu bëntsáꞌull tubi luꞌ alrededurë. Bëntsáꞌull catë guëruꞌu juguë shtë uvë; nu bëntsáꞌull tubi hiuꞌu guiaꞌa parë quëhapë muzë ra hiaguë. ’Nu bëdëꞌë nguiu ni guiuꞌu parë trabajadurë gunë rall dchiꞌni mëdi. Iurní ziáꞌall zitu. ");
INSERT INTO zacNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Iurë bëgaꞌa tiempë shtë cusechë, lëꞌë lamë bëshéꞌldiꞌ tubi muzë; tsagcaꞌa muzë lo quë narunë tucarë lamë. ");
INSERT INTO zacNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Perë ra nabëcaꞌa guiuꞌu gunaꞌzi rall lëꞌë muzë; bëdëꞌë rall galnë́ lëꞌë muzë, nu bësëlluꞌnë rall lëꞌë muzë sin adë pë bëdë́ꞌëdiꞌi rall niuaꞌa muzë. ");
INSERT INTO zacNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Iurní lamë bëshéꞌldëll stubi muzë; bëꞌnë ra nguiu ridë guëc muzë. Guniꞌi rall didzabë guëc muzë. ");
INSERT INTO zacNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Lëꞌë lamë bëshéꞌldëll stubi muzë. Muzë ni gudini ra nguiu. Bësheꞌldë lamë más zihani muzë. Bëldá raiꞌ gudini rall lëꞌë raiꞌ. Sëbëldá ra muzë bëdëꞌë rall galnë́. ");
INSERT INTO zacNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Lamë ni nápëll tubsë shínill. Nalë́ rac shtuꞌu lamë shíniꞌ. Bësheꞌldë lamë shíniꞌ lu ra nguiu; guniꞌi lamë: “Gapë rall rëspëti lu shinia”. ");
INSERT INTO zacNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Perë ra nabëcaꞌa guiuꞌu guniꞌi lu saꞌ rall: “Guná, ndëꞌë llgaꞌnë lamë naguëcaꞌa herenci shtë lamë. Cha guëdíniaꞌa lë́ꞌëll nu grë herenci guëaꞌnë parë lëꞌë hiaꞌa.” ");
INSERT INTO zacNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Gunaꞌzi rall shini lamë; gudini rall lë́ꞌëll nu bëruꞌldë rall lë́ꞌëll fuërë de lugar ni. ");
INSERT INTO zacNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iurní gunaꞌbë diꞌdzë Jesús: ―¿Pë gunë lamë con ra muzë mal? Guidë lamë catë zu hiaguë uvë të quini lamë ra muzë mal, nu guëdëꞌë lamë hiaguë uvë parë stubi mënë. ");
INSERT INTO zacNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Pëllë bíꞌldidiꞌi të Sagradas Escrituras narniꞌi? Guëꞌë nabëruꞌldë albañil tubi ladë, guëꞌë rëꞌ gunë sirvë parë shquini hiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Zni bëꞌnë më, el quë narnibëꞌa lëꞌë hiaꞌa. Guná hiaꞌa pudërë shtë më; nalë́ nasaꞌa nahin. ");
INSERT INTO zacNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iurní ra contrari shtë Jesús gudili rall mudë parë guënaꞌzi rall lëꞌë Jesús. Bien guc bëꞌa rall Jesús guniꞌi comparaciuni rëꞌ cuntrë lëꞌë rall. Niétiquë adë pë bë́ꞌnëdiꞌi rall cuntrë lëꞌë më purquë bëdzëbë rall los de más mënë. Bësaꞌnë rall lëꞌë më; zëagzë́ rall. ");
INSERT INTO zacNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ra contrari shtë Jesús bësheꞌldë rall bëldá fariseo nu bëldá shmënë Herodes parë guësiguë́ rall lëꞌë më. Guc shtuꞌu rall nianiꞌi më tubi cusë mal të guëdchiꞌbë rall demandë cuntrë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Gunaꞌbë diꞌdzë rall lu më: ―Mësë, nanë́ naꞌa rluáꞌal purë verdá. Rúnël tratë igual ra mënë humildë nu ra mënë narnibëꞌa. Quëgluáꞌal lla tsutë́ mënë shnezë Dios. Guniꞌi lu naꞌa iurneꞌ, según lëy ¿pë na bien guëdílliaꞌa impuestë lu rëy César u guëdíllidiꞌiaꞌa impuestë? ");
INSERT INTO zacNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Guc bëꞌa Jesús na rall mënë falsë. Guniꞌi më lu rall: ―¿Pëzielú zeꞌdë guësiguë́ të na? Gulë bëluaꞌa tubi dumí të guënahia luhin. ");
INSERT INTO zacNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Guaglliꞌi rall tubi monedë; iurní guniꞌi më: ―¿Chu lë nu chu lu naquë́ lu dumí? Guniꞌi rall: ―Lu rëy César naquë́ lu dumí. ");
INSERT INTO zacNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bëquebi më: ―Gulë bëdëꞌë nacaꞌa César lo quë naná shtë César, nu gulë bëdëꞌë nacaꞌa Dios lo quë naná shtë Dios. Guasë́ lduꞌu rall shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Iurní bëdchini bëldá saduceos lu Jesús. Ra saduceos rniꞌi rall adë tsashtë́diꞌi ra tëgulë ladi ra tëgulë. Gunaꞌbë diꞌdzë rall lu më: ");
INSERT INTO zacNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Mësë, bëquëꞌë Moisés guahietë si tubi nguiu gátiꞌ sin shíniꞌ, bëchi tëgulë napë quë cáꞌall tseꞌlë tëgulë; gapë raiꞌ shini parë adë tsalúdiꞌi shfamili tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Guc gadchi bëchi. Primërë nguiu bëtsë́ꞌall perë gútill sin ni tubi shíniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Segundë bëchi tëgulë cuáꞌall lëꞌë viudë perë gútill sin ni tubi shíniꞌ. Tecërë lo mizmë cuáꞌall tseꞌlë tëgulë perë gútill sin ni tubi shíniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Guëzá bëchi tëgulë cuaꞌa rall lëꞌë naꞌa ni perë adë gúpëdiꞌi raiꞌ shíniꞌ. Despuësë lëꞌë naꞌa ni gútiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Iurë tsashtë́ ra tëgulë, ¿chu gac tseꞌlë naꞌa ni? pues gadchi nguiu guc tseꞌlë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús bëquebi: ―Bëganë të con diꞌdzë shtë të purquë adë riasë́diꞌi të Sagradas Escrituras nu adë guënë́diꞌi të pudërë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Iurë ra tëgulë tsashtë́ raiꞌ, adë guëtsë́ꞌadiꞌi raiꞌ; adë rnádiꞌi raiꞌ guëtsëꞌa shini raiꞌ. Na raiꞌ ziquë ra ianglë nacabezë gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Perë si talë cagnaꞌbë diꞌdzë të si talë ra tëgulë tsashtë́ raiꞌ stubi, gulë bëdëꞌë cuendë lo quë nabëquëꞌë Moisés laꞌni histuri shtë hiaguë narëuldë. ¿Pëllë adë bíꞌldidiꞌi të histuri ni? Bëquëꞌë Moisés de quë Dios guníꞌiꞌ lúhiꞌ: “Nahia Dios shtë Abraham; nahia Dios shtë Isaac; nahia Dios shtë Jacob”. ");
INSERT INTO zacNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pues grë shmënë Dios nabani aunquë hia guti raiꞌ. Napë raiꞌ vidë sin fin. Lëꞌë të saduceos, riasë́diꞌi të shtiꞌdzë Dios; zihani vësë rganë të. ");
INSERT INTO zacNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tubi mësë narluaꞌa lëy guabíꞌguëll lu Jesús. Bínill lla quëdildi diꞌdzë ra saꞌll nu bínill de quë Jesús bëquébiꞌ bien lu rall. Guniꞌi mësë ni lu Jesús: ―Mësë, ¿guadë mandamientë namás lasac de grë mandamientë? ");
INSERT INTO zacNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Guniꞌi më lull: ―Mandamientë namás lasac rniꞌi: “Gulë bëquë́ diaguë, lëꞌë të mënë israelitë; Dios Shtádaꞌa tubsë na më. ");
INSERT INTO zacNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Gulë guc shtuꞌu lëꞌë më con guëdubinú ldúꞌul, nu guëdubi almë shtë́nël, nu con guëdubi fuersë shtë́nël”. Ni na mandamientë namás lasac. ");
INSERT INTO zacNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Segundë mandamientë rniꞌi: “Gulë guc shtuꞌu saꞌl ziquë rac shtúꞌul mizmë lë́ꞌël”. Nídiꞌi stubi mandamientë namás lasac quë mandamientë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Lëꞌë mësë repi: ―Mësë, guldí shtíꞌdzël. Verdá na tubsë Dios; nídiꞌi chu stubi. ");
INSERT INTO zacNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nu napë quë gac shtúꞌul lëꞌë më con guëdubinú ldúꞌul nu con almë shtë́nël, nu con fuersë shtë́nël. Nu zac napë quë gac shtúꞌul saꞌl igual ziquë rac shtúꞌul mizmë lë́ꞌël. Ra cusë ni más lasac quë gunë nguiu ofrecërë lu Dios tubi ma u stubi cusë narieꞌqui lu bëcuꞌguë. ");
INSERT INTO zacNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iurë bini Jesús de quë nguiu rëꞌ guníꞌill bien, guniꞌi më lull: ―Duꞌpë runë faltë të guënibëꞌa Dios lë́ꞌël të gápël vidë sin fin. Iurní adë chu nápëdiꞌi valurë nianaꞌbë diꞌdzë lu më. ");
INSERT INTO zacNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iurë cagluaꞌa Jesús laꞌni iáduꞌu ruꞌbë, guniꞌi më: ―¿Pëguëaꞌ rniꞌi ra mësë shtë lëy de quë Cristo na shini David? ");
INSERT INTO zacNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mizmë David bëquëꞌë por pudërë shtë Espíritu Santo diꞌdzë rëꞌ: Dadë Dios guniꞌi lu Shtada narnibëꞌa: “Guzubë ladë ldi shtëna hashtë guna gan lu enemigu shtë́nël të guëzuꞌbë diaguë rall shtíꞌdzël”. ");
INSERT INTO zacNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Lla na posiblë gac Cristo shini David, cumë David rníꞌiꞌ Cristo na Dadë narnibëꞌa lëꞌë David? Ra mënë zihani bini rall shtiꞌdzë më; bëuuꞌ lduꞌu rall nacagniꞌi më. ");
INSERT INTO zacNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Quëgluaꞌa më ra mënë; guniꞌi më: ―Gulë gapë cuidadë ra mësë narluaꞌa lëy. Rëuuꞌ lduꞌu rall gacu rall lari duni. Rac shtuꞌu rall gunë mënë saludar lëꞌë rall con zihani rëspëti lu nezë. ");
INSERT INTO zacNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Rguili rall lugar mejurë laꞌni iáduꞌu; rac shtuꞌu rall lugar shtë rëspëti lu mellë. ");
INSERT INTO zacNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Perë rdchisú rall lidchi ra viudë nu parë guësiguë́ rall mënë, quëhunë rall oraciuni llëduni. Lëꞌë rall gunë rall recibir más cashtigu dushë. ");
INSERT INTO zacNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Guzubë më laꞌni iáduꞌu frentë catë rtiaꞌa mënë ofrendë; guná më lu ra mënë nabëtiaꞌa guꞌnë laꞌni canciá. Zihani mënë ricu bëtiaꞌa rall zihani dumí. ");
INSERT INTO zacNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Iurní bëdchini tubi viudë prubi; bëtiáꞌall chupë centavë laꞌni canciá. ");
INSERT INTO zacNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iurní Jesús gunaꞌbë më ra shini gusëꞌdë më. Guniꞌi më lu raiꞌ: ―De verdá rniaꞌa, lëꞌë viudë prubi rëꞌ bëtiáꞌall más quë grë mënë nabëdëꞌë dumí ");
INSERT INTO zacNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","purquë los de más rall bëtiaꞌa rall dumí nabëꞌnë subrë perë viudë rëꞌ bëdë́ꞌëll grë́tëꞌ nanápëll, grë nasíꞌill parë gaull. ");
INSERT INTO zacNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nianá bëruꞌu më iáduꞌu, tubi shini gusëꞌdë më guniꞌi: ―Mësë, guná, blac chulë ra guëꞌë ruꞌbë. Blac chulë hiuꞌu rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús guniꞌi: ―¿Gu rna të lu guëꞌë ruꞌbë shtë iáduꞌu? Adë guëáꞌnëdiꞌi ni tubi guëꞌë nadchiꞌbë guëc saꞌ. Grëhin tsalú. ");
INSERT INTO zacNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Guzubë më catë zu dani shtë Olivos nanaquë́ frentë nezë catë rluaꞌa iáduꞌu ruꞌbë. Iurní Pedro nu Jacobo nu Juan nu Andrés gunaꞌbë diꞌdzë raiꞌ lu Jesús tubi cuꞌ: ");
INSERT INTO zacNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―¿Guc gac ra cusë narníꞌil lu naꞌa? ¿Pë sëñi nanú de quë hia gac cumplirin? ");
INSERT INTO zacNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iurní guniꞌi Jesús: ―Gulë gapë cuidadë ni tubi adë chu guësiguë́diꞌi lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Zihani mënë guëcaꞌa rall lëa; guëdchini rall nu guëniꞌi rall: “Nahia Cristo”. Guësiguë́ rall zihani mënë. ");
INSERT INTO zacNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Iurë ruadiꞌdzë mënë nanú zihani guërru nu rdzatsu mënë cuntrë gubiernë, adë rdzë́bëdiꞌi të. Grë cusë ni napë quë gac cumplir perë runë faltë parë tsalú guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tildi naciuni cuntrë stubi naciuni nu tildi guëꞌdchi cuntrë stubi guëꞌdchi. Guidë llu dushë zihani lugar. Guëdchini gubini dushë. Ni na principi shtë cusë durë naguër gac. ");
INSERT INTO zacNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Gulë bëꞌnë preparar lëꞌë të purquë gunë mënë intriegu lëꞌë të lu ra gubiernë. Guëneꞌe mënë galnë́ lëꞌë të laꞌni iáduꞌu. Guëdchiꞌbë rall demandë cuntrë lëꞌë të lu gubiernë nu lu ra rëy purquë na të shmëna. Zni guëniꞌi të dizaꞌquë lu ra më ruꞌbë; gac të testigu shtëna. ");
INSERT INTO zacNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Antsë guëdchini fin shtë guë́dchiliu, napë quë guërëꞌtsë dizaꞌquë entrë grë ra naciuni. ");
INSERT INTO zacNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Iurná guaꞌa mënë lëꞌë të lu gubiernë, adë rquëdíꞌnidiꞌi lduꞌu të por lo quë naguëniꞌi të. Gulë biadiꞌdzë lo quë narneꞌe Espíritu Santo lëꞌë të iurní, purquë lë́dëdiꞌi lëꞌë të guadiꞌdzë të sino Espíritu Santo quëadíꞌdziꞌ iurní. ");
INSERT INTO zacNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tiempë ni ra nguiu gunë rall intriegu bëchi rall parë gati bë́chill. Nu ra shtadë llguëꞌnë gunë rall cuntrë shínill. Ra llguëꞌnë guëasë rall cuntrë ra shtádëll; gati shtádëll. ");
INSERT INTO zacNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Guëldënú grë mënë lëꞌë të purquë na të shmëna perë el quë nagac firmë lu shnezë Dios hashtë fin, nguiu ni gac salvar. ");
INSERT INTO zacNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Iurë guëná të cusë mal tsutë́ iáduꞌu ruꞌbë, cusë ni gunin manchë iáduꞌu; zuhin catë nídiꞌi permisi. (Gulë tsasë́ ndëꞌë el quë naguꞌldë diꞌdzë rëꞌ.) Ra nananú Judea guëlluꞌnë rall lu dani. ");
INSERT INTO zacNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","El quë nazugaꞌa guëc hiuꞌu adë guiétëdiꞌill parë tsutëll laꞌni hiuꞌu të guáꞌall pë shtëll sino guëllúꞌnëll. ");
INSERT INTO zacNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nu el quë nanú lachi adë guëabrídiꞌill lídchill parë guáꞌall shábëll sino guëllúꞌnëll lu dani. ");
INSERT INTO zacNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Prubi ra naꞌa nanuaꞌa shíniꞌ dzë ni, nu prubi ra narcaꞌa meꞌdë. ");
INSERT INTO zacNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gulë bëꞌnë ruëguë lu Dios adë gaquin tiempë naldë. ");
INSERT INTO zacNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Laꞌni ra dzë ni gunë mieti sufrir demasiadë, cusë durë naná láꞌadiꞌi guná mënë dizdë principi shtë guë́ꞌdchiliu nu nunquë jamás gáquëdiꞌi saꞌ ra cusë ni. ");
INSERT INTO zacNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Si talë adë bë́ꞌnëdiꞌi Dios menos ra dzë shtë sufrimientë, adë chu nádiꞌi gac salvar; perë por ra mënë nagudili Dios, gac menos ra dzë ni. ");
INSERT INTO zacNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Si talë chu guëniꞌi lul: “Gulë guná, ndëꞌë lëꞌë Jesucristo”, u “Gulë tsagná; ndë lëꞌë më nanú”, adë tsaldídiꞌi ldúꞌul shtíꞌdzëll. ");
INSERT INTO zacNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Guëdchini ra naguëguguë́ ra mënë. Guëniꞌi rall na rall Cristo u tubi narniꞌi shtiꞌdzë Dios nu gunë rall milagrë nu guëluaꞌa rall sëñi ruꞌbë të parë guësiguë́ rall hashtë ra nagudili Dios si na posiblë. ");
INSERT INTO zacNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Por ni gulë guzú listë nu preparadë; hia guniaꞌa lu të ra diꞌdzë ni antsë gac cumplirin. ");
INSERT INTO zacNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Despuësë ra dzë shtë sufrimientë lëꞌë ngubidzë guëcahi nu lëꞌë mbehu adë guënéꞌediꞌin llni. ");
INSERT INTO zacNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ra mbelëguiꞌi ldaguë. Grë́tëꞌ fuersë shtë gubeꞌe guëniꞌbin. ");
INSERT INTO zacNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Iurní guëná mënë na, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu; guëdchinia laꞌni shcahi con llëruꞌbë pudërë nu llni. ");
INSERT INTO zacNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Iurní guësheꞌlda ra ianglë parë guziaꞌa raiꞌ guëdubi guë́ꞌdchiliu. Guëtëá raiꞌ ra shmënë Dios, ra nagudili më. Guëdchini rall de guëdubi ladë shtë guë́ꞌdchiliu nu dizdë más zitu. ");
INSERT INTO zacNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Gulë tsasë́ comparaciuni shtë hiaguë bëldaꞌu. Iurë lëꞌë ndiaguë rënë rruꞌu, rdëꞌë të cuendë hia mërë guëdchini tiempë naꞌi. ");
INSERT INTO zacNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Zni iurë guëná të quëhac grë ra cusë rëꞌ, gulë tsasë́ hia mërë guëdchinia. ");
INSERT INTO zacNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Guldía rniaꞌa lu të, grëhin gac cumplir antsë gati mënë naquëreldë lu guë́ꞌdchiliu dzë ni. ");
INSERT INTO zacNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Gubeꞌe nu guë́ꞌdchiliu tsalú rahin perë shtiꞌdza adë tsalúdiꞌin. ");
INSERT INTO zacNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Perë dzë nu iurë, ni tubi adë chu rac bë́ꞌadiꞌi, ni por mizmë ianglë shtë gubeꞌe, ni por shini Dios; sulamëntë Dios, Shtada, rac bë́ꞌaiꞌ dzë shtë fin. ");
INSERT INTO zacNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Gulë guzú listë; gulë gac nasini purquë lëꞌë të adë rac bë́ꞌadiꞌi të dzë shtë fin. ");
INSERT INTO zacNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nahin ziquë tubi nguiu naziaꞌa zitu. Bësëáꞌnëll lídchill nu bëdë́ꞌëll dchiꞌni caꞌa muzë, cadë tubi rall con shchíꞌniꞌ. Nu gunibëꞌa nguiu ni lu portërë sull listë guëdubi tiempë. ");
INSERT INTO zacNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Rniaꞌa lu të, gulë guzú listë; adë rdë́ꞌëdiꞌi të cuendë guc guëdchini lamë. Zeꞌdë guëdchíniꞌ iurë gueꞌlë u guëruldë gueꞌlë u rquë tsunë cahi u hashtë rsili. ");
INSERT INTO zacNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Gulë guzú listë, no sea guëdchini më de repëntë nu lë́ꞌël nagáꞌsil. ");
INSERT INTO zacNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Lo quë nacagniaꞌa lu të, rniaꞌa lu grë mënë; gulë guzú listë. ");
INSERT INTO zacNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chupë dzë antsë bëdchini laní Pascu nu laní iurë gudáu mënë guetështildi sin levadurë, ra principal bëshuzi nu ra mësë narluaꞌa lëy, caguili rall mudë parë guënaꞌzi rall lëꞌë më prësi sin quë adë chu gac bë́ꞌadiꞌi, nu quini rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Guniꞌi rall: ―Lëdë laꞌni dzë́diꞌi laní gaquin të adë guëdzátsudiꞌi ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Guzac Jesús nanú Betania; iurë nanú më lidchi Simón el quë naguc lluꞌu galguidzë naruꞌdzë ládiꞌ, guzubë më lu mellë. Iurní bëdchini tubi naꞌa; nuáꞌall tubi bëtë́i nanactsaꞌu de guëꞌë alabastro. Gadzë́ bëtë́i ni con perfumë shtë nardë purë. Lasaquin zihani dumí. Bëldë́ naꞌa bëtë́i nu bëtiáꞌall perfumë guëc më. ");
INSERT INTO zacNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bëldá mënë bëldënú rall naꞌa ni; guniꞌi lu saꞌ rall: ―¿Pëguëaꞌ bëꞌnë naꞌa rëꞌ desperdici perfumë guëc më? ");
INSERT INTO zacNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","purquë bien niatuuꞌ naꞌa perfumë por más de tsunë gahiuꞌa bëllë nu niadë́ꞌëll dumí caꞌa ra prubi. Gudildi rall naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Iurní guniꞌi Jesús: ―Zuzú naꞌa. ¿Pëzielú cagniꞌi të cuntrë lë́ꞌëll? Bë́ꞌnëll tubi cusë zaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Siemprë nanú ra prubi entrë lëꞌë të, nu cualquier dzë rac guëdëꞌë të lo quë narac shtuꞌu të caꞌa prubi, perë na adë guëquëreldënúdiaꞌa lëꞌë të llëduni tiempë. ");
INSERT INTO zacNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Naꞌa ni bë́ꞌniꞌ zni mientras nabania ndëꞌë. Bëtiáꞌall perfumë shcuerpa antsë gatia nu guëgaꞌcha. ");
INSERT INTO zacNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Guldía narniaꞌa lu të, ancalë catë guadiꞌdzë mënë dizaꞌquë guëdubi guë́ꞌdchiliu, lo quë nabëꞌnë naꞌa rëꞌ guini mënë. Guëagná lduꞌu rall lo quë nabëꞌnënú naꞌa na. ");
INSERT INTO zacNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Iurní Judas Iscariote tubi naná chiꞌbë chupë shini gusëꞌdë më, ziáꞌall lu ra principal bëshuzi të gúnëll tratë nu gúnëll intriegu Jesús guiaꞌa rall. ");
INSERT INTO zacNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Iurë bini rall shtiꞌdzë Judas, nalë́ bëquitë lduꞌu rall nu bëꞌnë rall prometer guëdëꞌë rall dumí. Dizdë iurní gudili Judas mudë parë gúnëll intriegu lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Iurní bëdchini primërë dzë shtë laní; gudáu mënë guetështildi sin levadurë. Mizmë dzë ni bëꞌnë tucarë quini mënë tubi lliꞌli shtë Pascu. Ra shini gusëꞌdë më gunaꞌbë diꞌdzë raiꞌ lu më: ―¿Ca lu rac shtúꞌul guëdëꞌnë naꞌa preparar shtse shtë Pascu guëdáuhaꞌa? ");
INSERT INTO zacNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bësheꞌldë më chupë shini gusëꞌdë më; guniꞌi më: ―Gulë tsa guëꞌdchi. Guëdzaꞌguëlú të tubi nguiu nanuaꞌa tubi rëëꞌ nisë. Gulë guanaldë lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Catë tsutëll, gulë guniꞌi lu nashtë́ hiuꞌu: “Mësë shtë naꞌa cagnaꞌbë díꞌdziꞌ lul, ¿ca lu guënéꞌel tubi cuartë parë guëdáu shtse naꞌa shtë Pascu?” ");
INSERT INTO zacNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Iurní guëluáꞌall tubi cuartë ruꞌbë guiaꞌa segundë pisë; listë nahin. Gulë bëꞌnë preparar laní ndë. ");
INSERT INTO zacNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ra shini gusëꞌdë më ziaꞌa raiꞌ guëꞌdchi. Bëdzaꞌguëlú raiꞌ lëꞌë nguiu nanuaꞌa nisë, ecsactë ziquë guniꞌi më lu raiꞌ. Ndë bëꞌnë raiꞌ preparar shtse shtë laní. ");
INSERT INTO zacNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Iurë bëdchini gueꞌlë, bëdchini më con ra chiꞌbë chupë shini gusëꞌdë më catë nanú tubi cuartë. ");
INSERT INTO zacNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Iurë quëháu raiꞌ, guniꞌi më: ―Guldía cagniaꞌa lu të, tubi entrë de lëꞌë të guëruꞌu tubi nagunë intriegu na lu galguti. Quëhaunú nguiu ni na. ");
INSERT INTO zacNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Guzublú gulaguë tristë laꞌni lduꞌu raiꞌ; guniꞌi raiꞌ lu më tubi por tubi: ―Dadë, ¿ni mudë guna intriegu lë́ꞌël? ");
INSERT INTO zacNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Repi Jesús: ―Nguiu ni na tubi de chiꞌbë chupë shini gusëꞌda. Quëgtiáꞌall guetështildi laꞌni platë con na; gúnëll intriegu na lu galguti. ");
INSERT INTO zacNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gac cumplir lo quë narniꞌi Sagradas Escrituras de na, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, perë prubi nguiu el quë nagunë intriegu na lu galguti. Mejurë adë niálëdiꞌi nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mientras quëhaunú Jesús lëꞌë raiꞌ, gunaꞌzi më guetështildi nu bëdëꞌë më graci. Bëshullë më guetështildi; bëdëꞌë mëhin cuaꞌa ra shini gusëꞌdë më. Guniꞌi më: ―Gulë gau ndëꞌë; ndëꞌë lëꞌë shcuerpa. ");
INSERT INTO zacNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nu zac gunaꞌzi më copë shtë vini; bëdëꞌë më graci nu bëdëꞌë më lëꞌë copë cuaꞌa ra shini gusëꞌdë më. Biiꞌ raiꞌ lëꞌë vini. ");
INSERT INTO zacNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Guniꞌi më lu raiꞌ: ―Ndëꞌë na rënë shtëna naná sëgi parë tubi tëstë cubi entrë Dios nu ra mënë. Guëllëꞌë rënë shtëna parë gac salvar zihani mënë. ");
INSERT INTO zacNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Guldía rniaꞌa lu të, hiadë guëabrídiꞌi guaꞌ vini con lëꞌë të hashtë dzë naná quëbezënúa lëꞌë të catë rnibëꞌa Dios ziquë Rëy. ");
INSERT INTO zacNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Despuësë biꞌldi raiꞌ tubi cantë, iurní bëruꞌu raiꞌ; ziaꞌa raiꞌ dani shtë Olivos. ");
INSERT INTO zacNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Guniꞌi më lu raiꞌ: ―Grë́tëꞌ të guësaꞌnë të na; zni rniꞌi ra Sagradas Escrituras: “Tsatinia lëꞌë vëquërë nu ra lliꞌli guërëꞌtsë ra”. ");
INSERT INTO zacNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Perë despuësë iurë tsashtë́a ladi ra tëgulë, quibëlúa lu të hashtë Galilea. ");
INSERT INTO zacNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Iurní guniꞌi Pedro: ―Aunquë nilë grë́tëꞌ mënë guësaꞌnë rall lë́ꞌël, perë na jamás guësáꞌnëdiaꞌa lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús guniꞌi lu Pedro: ―Guldía, mizmë gueꞌlë neꞌ antsë lëꞌë gay guëllidchí, lë́ꞌël gúnël negar na tsunë vësë. ");
INSERT INTO zacNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Perë fuertë guniꞌi Pedro: ―Masiá quini ra mënë na, adë gúnëdiaꞌa negar lë́ꞌël. Grë ra shini gusëꞌdë më guniꞌi raiꞌ lo mizmë. ");
INSERT INTO zacNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bëdchininú më ra shini gusëꞌdë më lugar nalë Getsemaní. Guniꞌi më lu raiꞌ: ―Gulë guzubë ndëꞌë mientras guadiꞌdzënúa Dios, Shtada. ");
INSERT INTO zacNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Biaꞌa Jesús Pedro, Juan, nu Jacobo. Guzublú riá lduꞌu më demasiadë. Bëꞌnë më sufrir. ");
INSERT INTO zacNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Guniꞌi më lu raiꞌ: ―Gulë cuezë ndëꞌë; gulë cue nasini. Nalë́ tristë shtë galguti nanú laꞌni lduaꞌa; mërë gatia. ");
INSERT INTO zacNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ziaꞌa më stuꞌpë delantë; bëzullibi më; bëꞌnë më orar; gunáꞌbëiꞌ Shtádiꞌ si talë naposiblë guëlá Dios lë́ꞌiꞌ lu sufrimientë naná rdëdë lduꞌu më. ");
INSERT INTO zacNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Guniꞌi më lu Dios: ―Dadë, cagnaꞌba lul; nápël pudërë gúnël grë cusë. Bëlá na lu sufrimientë rëꞌ, perë adë gáquëdiꞌin según lo quë narac shtuaꞌa sino según voluntá shtë́nël. ");
INSERT INTO zacNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iurní bëabrí më catë cabezë Pedro, Juan, nu Jacobo. Bëdzelë më lëꞌë raiꞌ nagaꞌsi raiꞌ. Guniꞌi më guëc Pedro: ―Moni, ¿pë adë gáquëdiꞌi guëruꞌu mbëcaꞌldë lul tubi iurë? ");
INSERT INTO zacNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Gulë cue nasini; gulë gunaꞌbë lu Dios të adë guësiguë́diꞌi Satanás lëꞌë të. Lduꞌu të rniꞌi, nia, perë shcuerpë të adë nídiꞌi fuersë. ");
INSERT INTO zacNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Stubi vueltë ziaꞌa më; biadiꞌdzënúhiꞌ Dios. Guniꞌi më mizmë diꞌdzë ziquë antsë. ");
INSERT INTO zacNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bëabrí më; bëdzelë më lëꞌë shini gusëꞌdë më, nagaꞌsi raiꞌ tantë mbëcaꞌldë lu raiꞌ. Adë bëdzélëdiꞌi raiꞌ nianiꞌi raiꞌ lu më. ");
INSERT INTO zacNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Gua më; bëabrí më stubi; guniꞌi më: ―Iurneꞌ sí, gulë guëgaꞌsi; gulë tsa descansë. Hia lëꞌë iurë bëgaꞌa; nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu gac intriegu guiaꞌa ra nanapë duldë. ");
INSERT INTO zacNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gulë guashtë́; gulë cha purquë zeꞌdë biꞌguë el quë nagunë intriegu na. ");
INSERT INTO zacNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nianá cagniꞌi Jesús, bëdchini Judas naná tubi de chiꞌbë chupë shini gusëꞌdë më; bëdchininull zihani mënë nanuaꞌa hiaguë nu spadë. Zeꞌdë rall partë shtë ra jëfë shtë ra bëshuzi nu ra mësë shtë lëy nu ra mëgulë narnibëꞌa entrë lëꞌë rall. Bësheꞌldë rall mënë zihani ni. ");
INSERT INTO zacNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, lëꞌë traidor, bëdë́ꞌëll tubi sëñi antsë; guníꞌill lu rall: ―El quë naguna saludar, tsagruahia lë́ꞌëll; gulë gunaꞌzi lë́ꞌëll; gulë biaꞌa lë́ꞌëll prësi. ");
INSERT INTO zacNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Iurë guabiꞌguë Judas lu më, lueguë guníꞌill: ―Mësë. Bëtsagruaꞌll lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Iurní gunaꞌzi mënë lëꞌë më të guaꞌa rall lëꞌë më prësi. ");
INSERT INTO zacNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tubi nazugaꞌa ndë, gulull spadë shtë́nëll. Bëchúguëll tubi diaguë muzë shtë principal bëshuzi. ");
INSERT INTO zacNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iurní guniꞌi Jesús lu ra mënë: ―¿Pëzielú bëdchini të con spadë nu hiaguë parë zeꞌdë guëlliꞌi të na cumë ziquë ngubaꞌnë? ");
INSERT INTO zacNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Dzë con dzë zugáꞌahia con lëꞌë të iáduꞌu ruꞌbë perë adë gunáꞌzidiꞌi të na iurní. Perë ndëꞌë quëhac parë gac cumplir ra Sagradas Escrituras. ");
INSERT INTO zacNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iurní grë ra shini gusëꞌdë më bësaꞌnë raiꞌ lëꞌë më. Bëlluꞌnë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tubi sultërë guanaldë lëꞌë më. Nácull tubsë lari sabë. Gunaꞌzi mënë lë́ꞌëll ");
INSERT INTO zacNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","perë bësëáꞌnëll lari guiaꞌa ra mënë; gaíchill bëllúꞌnëll. ");
INSERT INTO zacNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Biaꞌa rall lëꞌë Jesús lu principal bëshuzi. Ndë bëdëá grë ra jëfë shtë ra bëshuzi nu ra mësë narluaꞌa lëy nu ra mëgulë narunë juzguë. ");
INSERT INTO zacNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Guanaldë Pedro dizdë zitu; guatë́hiꞌ lidchi bëshuzi principal. Guzubënúhiꞌ ra soliar. Cagtsëꞌë rall ruaꞌ guiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Iurní ra principal bëshuzi nu ra jushtici narunë juzguë, gudili rall tubi testigu cuntrë Jesús. Rac shtuꞌu rall quini rall lëꞌë më perë adë bëdzélëdiꞌi rall testigu cuntrë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Zihani mënë bëꞌnë rall testificar cuntrë lëꞌë më perë adë na igual diꞌdzë shtë rall. ");
INSERT INTO zacNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Por fin guasuldí bëldá mënë falsë naguniꞌi: ");
INSERT INTO zacNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Bini naꞌa Jesús guniꞌi: “Guëchilia iáduꞌu ruꞌbë naná bëntsaꞌu nguiu, nu entrë tsunë dzë guntsaꞌua stubi nanadë bëntsaꞌu nguiu”. ");
INSERT INTO zacNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Diꞌdzë naná rniꞌi ra testigu, adë rgáꞌadiꞌin purquë nádiꞌin igual. ");
INSERT INTO zacNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Iurní lëꞌë bëshuzi principal guasuldí nu gunaꞌbë díꞌdzëll lu më: ―¿Pëzielú adë rquébidiꞌil lu ra diꞌdzë rëꞌ? ¿Pë runë cuntienë lo quë naquëgniꞌi mënë cuntrë lë́ꞌël? ");
INSERT INTO zacNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Perë lëꞌë më dchisë na më; adë pë guniꞌi më. Iurní lëꞌë jëfë shtë bëshuzi bëabrí gunaꞌbë díꞌdzëll: ―¿Pë lë́ꞌël nal Cristo, shini Dios, lúniquë narunë tucarë gunë mieti adorar? ");
INSERT INTO zacNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús guniꞌi: ―Nahia Cristo nu guëná të lua, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. Guëná të na; cueza ladë ldi shtë Dios Pudërusë, nu guëná të iurë guëabría con pudërë laꞌni shcahi shtë gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Lëꞌë jëfë shtë bëshuzi nalë́ bëldëll nu bëchéꞌzëll shábëll tantë llanë gulaguë guë́quëll. Guníꞌill: ―¿Pë guëdë́ꞌnaꞌa másruꞌu testigu? ");
INSERT INTO zacNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hia bini të diꞌdzë dzabë naguniꞌi nguiu rëꞌ cuntrë Dios. ¿Pë rniꞌi të iurneꞌ? Grë ra mënë guniꞌi runë tucarë gati Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Iurní bëldá rall guzublú bëchiꞌbë shënë rall lu më. Bëtaꞌu rall lu më. Bëdëꞌë rall galnë́ guëc më nu gunaꞌbë diꞌdzë rall: ―¿Chu bëneꞌe galnë́ lë́ꞌël? Ra soliar bëdëꞌë rall galnë́ lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Zugaꞌa Pedro guetë rualdëaꞌ shtë lidchi bëshuzi. Bëdchini tubi criadë shtë bëshuzi principal. ");
INSERT INTO zacNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Gunall lu Pedro naná cagtsëꞌë ruaꞌ guiꞌi. Iurní gubíꞌall lu Pedro nu guníꞌill: ―Lë́ꞌël zugaꞌanul Jesús më Nazaret. ");
INSERT INTO zacNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Perë Pedro bë́ꞌnëll negar; guníꞌill: ―Guënë́diaꞌa lëꞌë nguiu; adë rac bë́ꞌahia pë cagníꞌil. Bëruꞌu Pedro fuërë ruaꞌ nezë. Bëllidchí gay. ");
INSERT INTO zacNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Stubi vueltë gubiꞌa criadë ni lu Pedro nu guníꞌill lu ra mënë nazugaꞌa ndë: ―Nguiu niꞌi nall shmënë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro bëabrí bëꞌnë negar; guníꞌiꞌ lo mizmë. Gudëdë duꞌpë tiempë, iurní ra nazugaꞌa ngaꞌli guniꞌi rall lu Pedro: ―Verdá nal shmënë Jesús purquë nu nal më Galilea; ruadíꞌdzël ziquë ra mënë ni. ");
INSERT INTO zacNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Iurní Pedro bëꞌnë jurar. Guníꞌiꞌ: ―Gunë Dios cashtigu na si talë adë ruadiꞌdza verdá. Runguë bë́ꞌadiaꞌa nguiu ni el quë narniꞌi të na Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Lueguë bëllidchí gay stubi vueltë. Pedro bëagná lduꞌi lo quë naguniꞌi Jesús lúhiꞌ antsë: “Antsë guëllidchí gay chupë vueltë, gúnël negar na tsunë vueltë”. Iurní bëꞌnë Pedro llgabë nu bíꞌniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Iurë brëgueꞌlë, bëdëá ra jëfë shtë bëshuzi nu ra mësë narluaꞌa lëy nu ra mëgulë narunë juzguë. Bëꞌnë rall tomar tubi acuerdë. Bëldiꞌbi rall lëꞌë Jesús. Biaꞌa rall lëꞌë më lu Pilato. ");
INSERT INTO zacNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato gunaꞌbë díꞌdzëll lu më: ―¿Guldil nal rëy shtë ra israelitë? Bëquebi më: ―Mizmë lë́ꞌël guníꞌil diꞌdzë ni. ");
INSERT INTO zacNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ra jëfë shtë ra bëshuzi nalë́ bëꞌnë rall acusar lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Stubi vueltë gunaꞌbë diꞌdzë Pilato lu më: ―¿Pëguëaꞌ adë pë rníꞌil? Blac cusë quëgdchiꞌbë rall cuntrë lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Perë Jesús dchisë bëáꞌniꞌ, nu nalë́ guasë́ lduꞌu Pilato. ");
INSERT INTO zacNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Durantë dzë shtë laní napë Pilato custumbrë guëldáꞌall tubi prësi, el quë narac shtuꞌu mënë guëruꞌu librë. ");
INSERT INTO zacNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Lachiguiꞌbë nanú tubi prësi nalë Barrabás. Lë́ꞌëll con ra saꞌll lachiguiꞌbë, gudini rall mënë iurë bëdzatsu rall cuntrë gubiernë. ");
INSERT INTO zacNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bidë mënë lu Pilato të guënaꞌbë rall gunë Pilato ziquë custumbrë shtë́nëll. ");
INSERT INTO zacNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Gunaꞌbë diꞌdzë Pilato lu ra mënë ni: ―¿Guadë narac shtuꞌu të guëdëꞌa libertá, Jesús naná rëy shtë të? ");
INSERT INTO zacNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Guc bëꞌa Pilato por mbidi ra jëfë shtë ra bëshuzi bëꞌnë rall intriegu lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Perë ra jëfë shtë bëshuzi bëtsatsu rall ra mënë parë guënaꞌbë rall guëdëꞌë Pilato libertá Barrabás. ");
INSERT INTO zacNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Iurní Pilato gunaꞌbë diꞌdzë lu rall stubi vueltë: ―¿Perë pë rac shtuꞌu të guna con Jesús? el quë narniꞌi të: “Rëy shtë naciuni Israel”. ");
INSERT INTO zacNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Iurní gurushtiá rall fuertë; guniꞌi rall: ―Gati nguiu rëꞌ lu cruz. ");
INSERT INTO zacNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato guniꞌi: ―¿Pëllë mal bë́ꞌnëll? Perë lëꞌë rall más fuertë gurushtiá rall lu Pilato. Guniꞌi rall: ―Gati nguiu rëꞌ. Gátill; gátill. ");
INSERT INTO zacNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato guc shtúꞌull guëáꞌnëll bien con ra mënë; bëdë́ꞌëll libertá Barrabás. Despuësë de bëdëꞌë ra suldadë galnë́ shtë chicuti lëꞌë më, bëꞌnë Pilato intriegu lëꞌë më të parë guëquëꞌë rall Jesús lu cruz. ");
INSERT INTO zacNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Iurní ra suldadë biaꞌa rall Jesús parë rualdëaꞌ shtë palaci. Lugar ni lë Pretorio. Bëdëá grë ra suldadë. ");
INSERT INTO zacNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bëgacu rall lëꞌë më tubi lari color guindë. Bëntsaꞌu rall tubi corunë guitsë; gulú rallin guëc më. ");
INSERT INTO zacNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Guzublú bëꞌnë rall saludar lëꞌë më de burnë. Guniꞌi rall: ―Guëbani Rëy shtë mënë israelitë. ");
INSERT INTO zacNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bëdëꞌë rall galnë́ guëc më con hiaguë. Bëchiꞌbë shënë rall lu më; bëzullibi rall lu më; bëꞌnë rall rëspëti lëꞌë më ziquë burnë. ");
INSERT INTO zacNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Despuësë de ni, bëdchisú rall lari guindë nanacu më të parë bëgacu rall shabë më stubi vueltë. Lueguë biaꞌa rall lë́ꞌiꞌ fuërë ruaꞌ guëꞌdchi të gunë rall crucificar lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ziadëdë tubi nguiu nezë; lëll Simón. Guall lachi perë hia zeꞌdë guëdchínill guëꞌdchi. Simón nall shtadë Alejandro nu Rufo. Bëꞌnë ra suldadë punërë lëꞌë Simón të guáꞌall cruz shtë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Biaꞌa rall lëꞌë Jesús tubi lugar nalë Gólgota, narunë cuntienë Lugar shtë Calavera. ");
INSERT INTO zacNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bëdëꞌë rall vini nanutsë mirra perë lëꞌë më adë biiꞌdiꞌi mëhin. ");
INSERT INTO zacNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Iurní bëꞌnë rall crucificar lëꞌë më, nu ra suldadë gudchitë rall dado nia guadë nagunë gan shabë më. Mudë ni gudiꞌdzë rall shabë më. ");
INSERT INTO zacNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Rquë guëꞌë rsili bëꞌnë rall crucificar lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nu bëquëꞌë rall tubi letrërë guëc cruz naná causë shtë më; rniꞌin: “Rëy shtë naciuni Israel”. ");
INSERT INTO zacNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nu bëquëꞌë rall chupë ngubaꞌnë lu cruz; túbill ladë ldi, stúbill ladë rubësë.  ");
INSERT INTO zacNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Zni guc cumplir Sagradas Escrituras narniꞌi: “Bëꞌnë rall tratar lëꞌë më ziquë ngubaꞌnë”. ");
INSERT INTO zacNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Grë mënë nardëdë lugar ni, bëꞌnë rall burnë; rniꞌbi guëc rall lu më; guniꞌi rall: ―Ja, lë́ꞌël rníꞌil, guëcuel iáduꞌu ruꞌbë nu dzë tsunë guëabrí guëzáꞌalin stubi. ");
INSERT INTO zacNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bieti lu cruz; bëꞌnë salvar mizmë lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nu ra principal bëshuzi nu ra mësë shtë lëy, bëꞌnë rall burnë; guniꞌi lu saꞌ rall: ―Bë́ꞌnëll salvar stubi mënë perë el mizmë lë́ꞌëll adë gúnëdiꞌill gan gúnëll salvar lë́ꞌëll. Guníꞌill nall Cristo. ");
INSERT INTO zacNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Si talë nall Rëy shtë më israelitë, pues guëldáguëll lë́ꞌëll lu cruz të guëná hiaꞌa, iurní tsaldí lduꞌu hiaꞌa shtíꞌdzëll. Nu ra mënë mal naguc crucificar con lëꞌë më bëꞌnë rall burnë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Iurë bëgaꞌa rquë chiꞌbë chupë, bëcahi guëdubi guë́ꞌdchiliu hashtë rquë tsunë guadzeꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mizmë iurë rquë tsunë, fuertë guniꞌi më: ―Eloi, Eloi, lama sabactani. (Diꞌdzë ni runë cuntienë: Dios mio, Dios mio, ¿pëguëaꞌ bësáꞌnël na?) ");
INSERT INTO zacNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bëldá ra nguiu nazú guëllaꞌ lu cruz bini rall pë guniꞌi më. Repi rall lu saꞌ rall: ―Guná; lëꞌë nguiu rëꞌ cagnáꞌbëll Elías. ");
INSERT INTO zacNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Lueguë tubi nazugaꞌa ndë guagllúꞌnëll; guagllíꞌill tubi spongë. Bëgáꞌdzëllin con vini hiꞌ. Iurní bëzúꞌbëll spongë guëc varë të parë gu më vini. Guníꞌill lu saꞌll: ―Cha bézaꞌa, guëná hiaꞌa nia zidë Elías të parë guësiétiꞌ lë́ꞌëll lu cruz. ");
INSERT INTO zacNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iurní guniꞌi më fuertë; guti më. ");
INSERT INTO zacNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Mizmë iurë ni lëꞌë cortinë laꞌni iáduꞌu gureꞌzin; guc chupë ldëhin dizdë guiaꞌa hashtë guetë. ");
INSERT INTO zacNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tubi capitán naná rnibëꞌa tubi gahiuꞌa suldadë, zull frentë lu cruz; gunall iurë naguti më. Guníꞌill: ―De verdá nguiu rëꞌ náhiꞌ shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","También zugaꞌa ngaꞌli bëldá ra naꞌa. Cagbiꞌa rall de zitu. Ladi rall zugaꞌa María Magdalena nu Salomé nu stubi María naná shniꞌa José nu Jacobo. Jacobo nápëll menor edá. ");
INSERT INTO zacNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ra naꞌa rëꞌ guanaldë rall lëꞌë më iurë ziazú më Galilea. Bëꞌnë rall compañi lëꞌë më. Nu zac ndë zugaꞌa stubi shcuaꞌa ra naꞌa naguanaldë lëꞌë më hashtë Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Bëdchini guadzeꞌ visperë shtë dzë descansë. Bëꞌnë mënë preparar nagáu rall parë grëgueꞌlë dzë laní purquë dzë descansë adë bë́ꞌnëdiꞌi rall dchiꞌni. ");
INSERT INTO zacNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Por ni José naná më guëꞌdchi Arimatea bëdchínill lu Pilato. Gupë José valurë; gunáꞌbëll permisi lu Pilato të parë guëcáꞌchill cuerpë shtë Jesús. José guc tubi më principal ladi ra jushtici narunë juzguë. Nu José quëbézëll tiempë iurë guënibëꞌa Dios ziquë Rëy. ");
INSERT INTO zacNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Iurë bini Pilato guti Jesús, guasë́ ldúꞌull. Gunáꞌbëll lëꞌë capitán shtë suldadë; gunaꞌbë díꞌdzëll si de verdá guti Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Capitán rëꞌ bëquebi lu Pilato: ―Verdá nahin; hia guti Jesús. Iurní bëdëꞌë Pilato permisi lëꞌë José të parë guëcaꞌchi José cuerpë shtë më. ");
INSERT INTO zacNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José guzíꞌill tubi lari naquichi fini; bësiétëll cuerpë lu cruz nu bëtúꞌbill cuerpë shtë më con lari. Iurní bëcáꞌchill lëꞌë më laꞌni tubi baꞌa nanactsaꞌu laꞌni guëꞌë. Gudíshill tubi guëꞌë ruaꞌ baꞌa. ");
INSERT INTO zacNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena nu María shniꞌa José bëchi Rufo, guná raiꞌ ca bëgaꞌchi Jesús. ");
INSERT INTO zacNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Gudëdë dzë narziꞌi lduꞌu mënë. María Magdalena nu Salomé nu stubi María shniꞌa Jacobo, guziꞌi rall loción parë tsagteꞌbi rallin ladi cuerpë shtë më. ");
INSERT INTO zacNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tumpranë primërë dzë shtë llmalë iurë brëgueꞌlë, gua rall ruaꞌ baꞌa. Hia gualdani ngubidzë. ");
INSERT INTO zacNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Repi lu saꞌ rall: ―¿Chull guëdchibsú guëꞌë rëꞌ ruaꞌ baꞌa? ");
INSERT INTO zacNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Iurní guná raiꞌ lëꞌë guëꞌë nagaꞌa tubi ladë nu nablac llëruꞌbë guëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Guatë́ raiꞌ laꞌni baꞌa; guná raiꞌ ladë ldi shtë baꞌa tubi nguiu nazubë ndë. Nácuhiꞌ tubi lari naquichi. Bëdzëbë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Guniꞌi nguiu: ―Adë rdzë́bëdiꞌi të. Lëꞌë të caguili të Jesús më Nazaret naguc crucificar. Hia guashtë́hiꞌ ladi ra tëgulë. Chu nádiꞌi ndëꞌë. Gulë guná catë bëgaꞌchi më. ");
INSERT INTO zacNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Gulë bëagzë́ nu gulë guniꞌi lu shini gusëꞌdë Jesús nu lu Pedro de quë Jesús guziaꞌa më delantë lu të parë Galilea. Ndë guëná të lu më. Zni guniꞌi më lu të dizdë más antsë. ");
INSERT INTO zacNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Iurní bëruꞌu raiꞌ; bëlluꞌnë raiꞌ. Nalë́ bëdzëbë raiꞌ; bëchiꞌchi raiꞌ tantë bëdzëguëëꞌ lduꞌu raiꞌ. Ni tubi adë chu lu biadíꞌdzëdiꞌi raiꞌ purquë bëdzëbë raiꞌ.  ");
INSERT INTO zacNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Despuësë guashtë́ Jesús ladi ra tëgulë, primërë dzë shtë llmalë, bëluaꞌalú më lu María Magdalena primërë. Antsë bëgú më gadchi mëdzabë laꞌni lduꞌu María. ");
INSERT INTO zacNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","María guaguëꞌnë visi lu ra naguanaldë lëꞌë më antsë. Lëꞌë rall nalë́ riá lduꞌu raiꞌ nu ruꞌnë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Iurní bini raiꞌ de quë Jesús nabani stubi nu guná María lúhiꞌ, adë gualdídiꞌi lduꞌu raiꞌ shtíꞌdziꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mizmë dzë guadzeꞌ chupë shmënë Jesús naziaꞌa nezë lachi, guná rall lu Jesús. Bëluaꞌalú më lu rall stubi formë. ");
INSERT INTO zacNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bëagrí rall guëꞌdchi nu biadiꞌdzë rall lu saꞌ rall de quë bëluaꞌalú më lu rall perë adë gualdídiꞌi lduꞌu saꞌ rall. ");
INSERT INTO zacNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Más guadzeꞌ bëluaꞌalú Jesús lu ra chiꞌbë tubi shini gusëꞌdë më; zubë raiꞌ lu mellë. Gudildi më lëꞌë raiꞌ purquë naguëdchi lduꞌu raiꞌ. Adë gualdídiꞌi lduꞌu raiꞌ shtiꞌdzë saꞌ raiꞌ naguná lu më despuësë guashtë́ më ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Guniꞌi më lu raiꞌ: ―Gulë tsagluaꞌa dizaꞌquë lu ra mënë narëtaꞌ guëdubi guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","El quë narialdí lduꞌi dizaꞌquë nu chubë nísiꞌ gac salvárëll, perë el quë nanë́diꞌi tsaldí lduꞌi dizaꞌquë gac condenárëll. ");
INSERT INTO zacNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Sëñi rëꞌ gunë rahin compañi ra narialdí lduꞌi shtiꞌdzë Dios, por pudërë shtëna guëgú rall mëdzabë laꞌni lduꞌu mënë; guadiꞌdzë rall dizë́ naná guënë́diꞌi rall. ");
INSERT INTO zacNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Guënaꞌzi rall serpientë nu si talë gu rall cusë venenë adë pë gúnëdiꞌi ra cusë ni. Guëdchiꞌbë rall guiaꞌa rall guëc ra narac lluꞌu nu guëac raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Despuësë biadiꞌdzë më diꞌdzë ni, beꞌpi më gubeꞌe. Guzubë më ladë ldi shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ra shini gusëꞌdë më ziaꞌa raiꞌ nu guagluaꞌa raiꞌ dizaꞌquë lu grë mënë. Mizmë Dadë Jesús bëꞌnë compañi lëꞌë raiꞌ; bëꞌnë raiꞌ milagrë; zni bëluaꞌa Dios de quë shtiꞌdzë raiꞌ na verdá. Amén.");
INSERT INTO zacNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Na Lucas, quëquëaꞌa librë rëꞌ nu guëshéꞌldahin lul Tiófilo con llëruꞌbë rëspëti. Nanël zihani mënë bëquëꞌë rall lo quë nabëluaꞌa Jesús nu lo quë nabëꞌnë më. Guc shtuꞌu rall guëquëꞌë rall cusë según tiempë ecsactë naguquin. ");
INSERT INTO zacNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bëquëꞌë rall lo quë narialdí lduꞌu hiaꞌa guquin. Bëquëꞌë rall lo quë naguná mënë dizdë tiempë naguzublú ruadiꞌdzë më dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nu guc lduaꞌa cumë cusë zaꞌquë guëquëaꞌa tubi histuri ecsactë parë gac bë́ꞌal verdá na diꞌdzë rëꞌ. Gunaꞌbë diꞌdza lu zihani mënë pë guná rall, nu nanë́a ra diꞌdzë rëꞌ na verdá. ");
INSERT INTO zacNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Caquëaꞌa lul iúbil Tiófilo, parë gac bë́ꞌal ra cusë nabëluaꞌa mënë lul nahin verdá. ");
INSERT INTO zacNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tiempë dzë ni Herodes guc rëy shtë Judea, nanú tubi bëshuzi lë Zacarías. Náhiꞌ con los de más sáhiꞌ grupë shtë Abías. Tseꞌlë Zacarías lë Elizabet; shtadë guëlú Elizabet guc bëshuzi nabërulë́ Aarón. ");
INSERT INTO zacNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías nu Elizabet tubldí na shcuendë raiꞌ lu Dios nu bëzuꞌbë diaguë raiꞌ grë mandamientë nu lëy shtë Dadë Dios. Bëꞌnë raiꞌ cumplir. ");
INSERT INTO zacNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Gúpëdiꞌi raiꞌ shíniꞌ purquë Elizabet gúdiꞌi shíniꞌ. Además de ni guërupë raiꞌ hia më gushë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Guzac tubi dzë bëꞌnë tucarë Zacarías gúniꞌ dchiꞌni shtë bëshuzi lu Dios según turnë grupë shtë Zacarías gunë raiꞌ dchiꞌni. ");
INSERT INTO zacNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ziquë na custumbrë shtë ra bëshuzi, gua raiꞌ tubi pueshtë niaꞌa chu gunë tucarë tsaldú gushialë lu Dios laꞌni iáduꞌu ruꞌbë. Bëꞌnë tucarë Zacarías. Guatë́hiꞌ lugar sagradë shtë iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Iurë lëꞌë ialë rieꞌqui, grë ra mënë zihani narë́ rualdëaꞌ shtë iáduꞌu, quëadiꞌdzënú rall Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Iurní bëluaꞌalú tubi ianglë shtë Dios lu Zacarías. Zúhiꞌ ladë ldi shtë bëcuꞌguë catë rieꞌqui ialë. ");
INSERT INTO zacNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Iurë guná Zacarías lu ianglë, bëdzëbë Zacarías; bëdzélëdiꞌi Zacarías pë nihúniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Perë lëꞌë ianglë guniꞌi: ―Zacarías, adë rdzë́bëdiꞌil purquë shtíꞌdzël bëdchini lu Dios. Gunë më lo quë narnáꞌbël lu më. Lëꞌë tséꞌlël Elizabet gapë tubi meꞌdë naguëdëꞌë të lë́hiꞌ Juan. ");
INSERT INTO zacNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Iurë lëꞌë meꞌdë guëdchini guë́ꞌdchiliu, guëquitë ldúꞌul nu tsu lëgrë ldúꞌul. Zihani mënë guëquitë lduꞌu rall iurë lëꞌë meꞌdë galë. ");
INSERT INTO zacNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Gáquiꞌ siervë ruꞌbë shtë Dadë Dios, nu gúdiꞌiꞌ vini. Gúdiꞌiꞌ ni tubi clasë licor. Dizdë antsë gáliꞌ hia cabezë Espíritu Santo laꞌni ldúꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Guëníꞌiꞌ shtiꞌdzë Dios nu zihani mënë shtë naciuni Israel guëabrí lduꞌu rall con Dadë Dios shtë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Shínil quiblú lu el quë naguësheꞌldë Dios. Ziquë guc el quë nabiadiꞌdzë shtiꞌdzë Dios con llëruꞌbë pudërë; lë́hiꞌ Elías; shínil guëdchini con mizmë pudërë nu llni. Guëniꞌinú shínil naciuni Israel parë cue zaꞌquë shtadë rall nu shini rall. Guëluáꞌaiꞌ lu narzuꞌbë diáguëdiꞌi shtiꞌdzë Dios parë guëabrí lduꞌu rall lu nezë zaꞌquë. Zni gac preparar mënë parë gunë rall sirvë lu Dadë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Iurní Zacarías gunaꞌbë diꞌdzë lu ianglë: ―¿Lla gac bë́ꞌahia zni purquë hia guꞌsha nu tseꞌla napë zihani izë? ");
INSERT INTO zacNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Iurní bëquebi ianglë: ―Gabriel lëhia. Na zua lu Dios. Bësheꞌldë më na parë zeldë guëniaꞌa lul dizaꞌquë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Perë guná, cumë adë gualdídiꞌi ldúꞌul lo quë naguniaꞌa lul, guꞌpë guëáꞌnël. Gáquëdiꞌi guëníꞌil hashtë guëdchini shínil lu guë́ꞌdchiliu. Gac cumplirin según tiempë nagunë Dios disponer. ");
INSERT INTO zacNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ra mënë narë́ rualdëaꞌ shtë iáduꞌu quëbezë rall lëꞌë Zacarías. Bëdzélëdiꞌi rall pë nianiꞌi rall pëzielú quëac ldëꞌë Zacarías lugar sagradë, ");
INSERT INTO zacNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","perë iurë gualú bëruꞌu Zacarías, ráquëdiꞌi rniꞌi Zacarías. Guc bëꞌa mënë de quë guná Zacarías tubi cusë ruꞌbë shtë Dios laꞌni iáduꞌu. Purë con guiáꞌaiꞌ ruadíꞌdziꞌ purquë bëáꞌniꞌ guꞌpë. ");
INSERT INTO zacNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Iurní gualú ra dzë nabëꞌnë tucarë gunë Zacarías sirvë laꞌni iáduꞌu, bëabriꞌ lídchiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Despuësë de ni Elizabet, tseꞌlë Zacarías, nua shíniꞌ. Adë ca bërúꞌudiꞌi Elizabet; guquëréldiꞌ lídchiꞌ por gaꞌi mbehu. ");
INSERT INTO zacNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Guníꞌiꞌ laꞌni ldúꞌiꞌ: “Dadë Dios nacabezë gubeꞌe bënéꞌeiꞌ permisi parë gapa shinia. Bëgaꞌa lduꞌu më na; iurní adë rtúdiꞌi lua lu ra mënë gúpëdiaꞌa shinia.” ");
INSERT INTO zacNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Shuꞌpë mbehu nua shini Elizabet, iurní bësheꞌldë Dios tubi ianglë lë Gabriel parë guanúhiꞌ rsunë lu María naquëreldë tubi guëꞌdchi Nazaret shtë Galilea. ");
INSERT INTO zacNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","María na lliguënaꞌa. Nápiꞌ comprumisi parë guëtsë́ꞌaiꞌ con tubi sultërë lë José. Shtadë guëlú José guc rëy David. ");
INSERT INTO zacNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabriel guatë́ lugar catë quëreldë María, nu guníꞌiꞌ lu María: ―Shtsanë. Nalë́ rac shtuꞌu Dios lë́ꞌël. Cabezënú më lë́ꞌël. Bëꞌnë ldaiꞌ më lë́ꞌël entrë grë ra naꞌa narë́ lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nalë́ bëdzëguëëꞌ lduꞌu María; bíniꞌ diꞌdzë rëꞌ. Adë gurëdchídiꞌi ldúꞌiꞌ. Runë shgábiꞌ pë runë cuntienë saludë shtë ianglë. ");
INSERT INTO zacNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Iurní ianglë guniꞌi: ―María, adë rdzë́bëdiꞌil. Dios gudili lë́ꞌël parë gunë më tubi favurë parë lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Shínil bëꞌa; gápël tubi shínil. Lëꞌë meꞌdë naguëdchini guë́ꞌdchiliu, guërulë́hiꞌ Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Gáquiꞌ tubi më ruꞌbë. Gápiꞌ lë zndëꞌë: Shini Dios nacabezë gubeꞌe. Nu Dadë Dios guëdëꞌë pudërë lë́ꞌiꞌ parë guënibë́ꞌaiꞌ grë mënë israelitë. Cuéziꞌ lu trunë shtë David, shtadë guëlúhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Shínil guënibë́ꞌaiꞌ guëdubi naciuni Israel parë siemprë, nu guënibë́ꞌaiꞌ manërë nanápëdiꞌi fin. ");
INSERT INTO zacNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Iurní María gunaꞌbë diꞌdzë lu ianglë: ―¿Lla gac lo quë naguníꞌil lua? Laꞌdi guënë́diaꞌa nguiu. ");
INSERT INTO zacNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Repi ianglë iurní: ―Gaquin por pudërë shtë Espíritu Santo naguëdchini lul. Pudërë shtë Dios nacabezë gubeꞌe, guëdchíniꞌ lul ziquë tubi shcahi naguësëꞌau lë́ꞌël. Por ni shínil nagápël, grë mënë shtë guë́ꞌdchiliu guëniꞌi rall náhiꞌ santu, shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nu shprímël Elizabet gápiꞌ tubi ngulëꞌnë. Hia më gushë na Elizabet perë guná, hia guc shuꞌpë mbehu nua shíniꞌ, nu rniꞌi mënë tsúdiꞌi shíniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Parë Dios ni tubi cusë nádiꞌi naganë. ");
INSERT INTO zacNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Iurní bëquebi María: ―Nahia criadë shtë Dadë Dios. Gaquin según nagunë Dios disponer, cumë ziquë guníꞌil lua. Lueguë lëꞌë ianglë zëagzë́. ");
INSERT INTO zacNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mizmë ra dzë ni María gua nasesë lu tubi guëꞌdchi shtë Judea. Guëꞌdchi ni naquë́ culaꞌni dani. ");
INSERT INTO zacNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Guatë́ María lidchi Zacarías nu guniꞌi María lu Elizabet: ―Shtsanë. ");
INSERT INTO zacNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Iurë bini Elizabet lo quë naguniꞌi María, lëꞌë meꞌdë bëniꞌbi laꞌni Elizabet. Mizmë iurní bëdchini Espíritu Santo parë cuezënúhiꞌ lëꞌë Elizabet. ");
INSERT INTO zacNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Fuertë guníꞌiꞌ lu María: ―Dios bëꞌnë ldaiꞌ lë́ꞌël más quë grë naꞌa, nu bëꞌnë ldaiꞌ më shínil nanuáꞌal. ");
INSERT INTO zacNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Chu nahia bidë guënal na? Nal shniꞌa më el quë narnibëꞌa na. ");
INSERT INTO zacNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Iurë binia chaꞌl, lëꞌë meꞌdë bëniꞌbi lania por tantë bëquitë ldúꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nu nalë́ dichusë nal purquë gualdí ldúꞌul Dios. Gualdí ldúꞌul gac cumplir lo quë naguniꞌi Dios lul. ");
INSERT INTO zacNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Iurní guniꞌi María: Con guëdubinú lduaꞌa quëhuna alabar Dadë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Rquitë lduaꞌa purquë Dios na Salvador shtëna. ");
INSERT INTO zacNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bëgaꞌa lduꞌu më na; bëꞌnë më cuendë adë nádiaꞌa më ruꞌbë sino tubi criadë humildë shtë́hiꞌ, perë dizdë iurneꞌ grë mënë naguëdchini lu guë́ꞌdchiliu, guëniꞌi rall bëꞌnë ldaiꞌ më na. ");
INSERT INTO zacNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","El quë narnibëꞌa grë cusë, bë́ꞌniꞌ cusë ruꞌbë parë na. Santu na më. ");
INSERT INTO zacNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Siemprë rgaꞌa lduꞌu më nu quëhunë më compañi grë mënë nanapë rëspëti lu më. ");
INSERT INTO zacNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Zihani cusë ruꞌbë bëꞌnë më con guiaꞌa më. Bësëlluꞌnë më ra narunë naruꞌbë con grë shgabë rall. ");
INSERT INTO zacNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mënë narunë naruꞌbë, gulaguë rall catë rnibëꞌa rall, bëꞌnë Dios, perë bëdë́ꞌëruꞌu më parë güeꞌpi guiaꞌa ra mënë narunë narúꞌbëdiꞌi lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bëneꞌe më cusë zaꞌquë parë ra narldiaꞌnë hashtë bielë rall. Ra ricu bësheꞌldë më; ziaꞌa rall sin adë pë nápëdiꞌi rall. ");
INSERT INTO zacNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Bëꞌnë më compañi lëꞌë ra më israelitë, ra narunë sirvë lu më. Adë bëáꞌldëdiꞌi lduꞌu më shmënë më. ");
INSERT INTO zacNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Zni bëꞌnë më cumplir lo quë naguniꞌi më lu ra shtadë guëlú hiaꞌa, lu Abraham nu lu ra llëbní shtë́hiꞌ naná shtadë guëlú hiaꞌa. Diꞌdzë ni na parë siemprë. ");
INSERT INTO zacNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María guquëreldënú Elizabet tsunë mbehu. Iurní bëabriꞌ lídchiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Hia guc cumplir tiempë gulë shini Elizabet. Gúpiꞌ tubi ngulëꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Iurë ra shvëcini Elizabet con shfamíliꞌ bini rall de quë bëgaꞌa lduꞌu Dios lë́ꞌiꞌ nu bëdëꞌë më tubi shíniꞌ, bëdchini rall nu nalë́ bëquitë lduꞌunú rall Elizabet. ");
INSERT INTO zacNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Gudëdë shunë dzë nu bëdchini tiempë parë gunë bëshuzi cumplir custumbrë religiusë; chuguë duꞌpë partë delicadë shtë meꞌdë. Ra mënë guc shtuꞌu rall niacaꞌa meꞌdë ziquë lë shtadë meꞌdë, ");
INSERT INTO zacNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","perë shniꞌa meꞌdë guniꞌi: ―Juan guërulë́ meꞌdë. ");
INSERT INTO zacNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Guniꞌi rall iurní: ―Ni tubi Juan nídiꞌi ladi shfamílil. ");
INSERT INTO zacNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Iurní gunaꞌbë diꞌdzë rall con guiaꞌa rall lu shtadë meꞌdë parë gac bëꞌa rall nia chu guërulë́ meꞌdë; guëniꞌi shtadë meꞌdë. ");
INSERT INTO zacNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacarías con sëñi gunáꞌbëiꞌ tubi tablë parë quë lëtrë luhin. Bëquë́ꞌëiꞌ: “Juan guërulë́ meꞌdë”. Grë mënë bëdzëguëëꞌ lduꞌu rall iurní. ");
INSERT INTO zacNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mizmë iurní bëabrí guniꞌi Zacarías. Bëniꞌbi ldúdziꞌ. Guzublú biadíꞌdziꞌ; guníꞌiꞌ llëruꞌbë na pudërë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ra mënë naquëreldë alrededurë lidchi Zacarías, bëdzëguëëꞌ lduꞌu raiꞌ. Por grë nezë shtë Judea hashtë lu lumë shtë dani, bërëꞌtsë ra diꞌdzë pë guc con Elizabet nu Zacarías. ");
INSERT INTO zacNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Grë ra nabini pë guc, bëꞌnë rall llgabë nu guniꞌi rall lu saꞌ rall: ―¿Pë chaꞌa gac meꞌdë? Rniꞌi rall zni purquë en verdá cabezënú Dios lëꞌë meꞌdë. ");
INSERT INTO zacNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Espíritu Santo cabezënú lëꞌë Zacarías, shtadë Juan, nu guniꞌi Zacarías diꞌdzë rëꞌ por pudërë shtë Dios: ");
INSERT INTO zacNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Llëruꞌbë na pudërë shtë Dios con lëꞌë hiaꞌa; na hiaꞌa më Israel. Bidë guëná më lëꞌë hiaꞌa nu bëꞌnë më salvar lëꞌë hiaꞌa, ra nagulë́ më. ");
INSERT INTO zacNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nu bëneꞌe Dios tubi më ruꞌbë nagunë salvar lëꞌë hiaꞌa. Nápiꞌ llëruꞌbë pudërë. Bëdchíniꞌ de famili shtë David, el quë nabëꞌnë sirvë lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Zni guc cumplir lo quë naguniꞌi ra mënë nabiadiꞌdzë shtiꞌdzë Dios guahietë. Santu na raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Guniꞌi më dizdë guahietë de quë gunë më salvar lëꞌë hiaꞌa guiaꞌa ra enemigu shtë hiaꞌa. Nu gunë më librar lëꞌë hiaꞌa de grë narldënú lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Gunë më ra cusë rëꞌ purquë bëꞌnë më prometer lu shtadë guëlú hiaꞌa de quë guëgaꞌa lduꞌu më lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Bëꞌnë më prometer con juramentu lu shtadë guëlú hiaꞌa Abraham ");
INSERT INTO zacNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","de quë gunë më salvar lëꞌë hiaꞌa de grë pudërë nanapë enemigu shtë hiaꞌa parë gac guëdë́ꞌnaꞌa sirvë lu më sin adë guëdzë́bëdiꞌiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Guëdubi tiempë naguëbániaꞌa, guëdë́ꞌnaꞌa sirvë lu më manërë zaꞌquë sin ni tubi duldë laꞌni lduꞌu hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Lë́ꞌël shinia, Dios nacabezë gubeꞌe, gunë më punërë lë́ꞌël ziquë tubi naruadiꞌdzë shtiꞌdzë Dios lu ra mënë. Antsë guëdchini el quë narnibëꞌa lëꞌë hiaꞌa, quibëlul lúhiꞌ parë gac preparadë ra mënë parë iurë guëdchini më. ");
INSERT INTO zacNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Guëníꞌil lu ra mënë nagulë́ më lla gac salvar rall të gac perdunë duldë shtë rall. ");
INSERT INTO zacNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Grë ni na por galërgaꞌa lduꞌu më. Gac cumplirin iurë gueꞌdë guëdchini tubi ziquë llni shtë ngubidzë brëgueꞌlë dizdë nezë guiaꞌa ");
INSERT INTO zacNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","të parë guianí nezë shtë ra naquëreldë lu nacahi, ra nardzëbë lu galguti, të parë cuedchí lduꞌu hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Juan, shini Zacarías, guarúꞌbiꞌ nu másruꞌu riaruꞌbë llni shtë Dios parë lë́ꞌiꞌ. Guquëréldiꞌ lugar catë nídiꞌi mënë. Zni bë́ꞌniꞌ hashtë dzë guzublú guniꞌinúhiꞌ ra mënë israelitë dizaꞌquë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tiempë dzë ni César Augusto gunibëꞌa tsasë cënsë shtë ra mënë guëdubi guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ni na primërë cënsë naguc dzë na Cirenio guc gubernadurë shtë Siria. ");
INSERT INTO zacNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Grë mënë gua ladzë shtadë guëlú raiꞌ parë guëdëꞌë raiꞌ lë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nu zac bëruꞌu José guëꞌdchi Nazaret shtënë regiuni Galilea. Bëdchíniꞌ Belén shtënë regiuni Judea parë guagdë́ꞌëiꞌ lë́hiꞌ purquë náhiꞌ famili shtë David nu Belén na guëꞌdchi shtë David. ");
INSERT INTO zacNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","María nápiꞌ comprumisi parë guëtsë́ꞌaiꞌ con José. Tiempë ni hia nua shini María. ");
INSERT INTO zacNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nanú raiꞌ Belén; bëdchini tiempë parë galë shíniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ndë bëdchini primërë meꞌdë nguiu. Bëtuꞌbi María meꞌdë tubi lari nu gúꞌtiꞌ catë rau ma purquë nídiꞌi lugar catë guëaꞌnë raiꞌ pusadë. ");
INSERT INTO zacNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Cerquë guëꞌdchi Belén rëtaꞌ ra vëquërë. Quëhapë rall lliꞌli lachi. Hia na gueꞌlë. ");
INSERT INTO zacNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Iurní bëdchini tubi ianglë nabësheꞌldë Dadë Dios. Bëdchini tubi llni dushë shtë Dios. Rabtsëꞌë llni alrededurë de ra vëquërë. Nalë́ bëdzëbë rall. ");
INSERT INTO zacNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Iurní repi ianglë: ―Adë rdzë́bëdiꞌi të purquë zeldënúa tubi nutici zaꞌquë; na parë grë saꞌ të. Diꞌdzë ni guësëquitë lduꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nedzë́ gulë tubi meꞌdë guëꞌdchi shtë David. Na meꞌdë Cristo, el quë nagudili Dios parë guënibë́ꞌaiꞌ. Náhiꞌ Dadë nagunë salvar lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Parë gac bëꞌa të chu náhiꞌ, guëdzelë të lëꞌë meꞌdë dúꞌbiꞌ tubi ldë lari. Nagáꞌaiꞌ catë rau ma. ");
INSERT INTO zacNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mizmë iurní guná vëquërë másruꞌu zihani ianglë shtë gubeꞌe culaꞌni primërë ianglë. Bëꞌnë raiꞌ alabar Dios; guniꞌi raiꞌ: ");
INSERT INTO zacNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Llëruꞌbë na pudërë shtë Dios nacabezë más guiaꞌa lu gubeꞌe. Bëꞌnë më tubi favurë parë ra mënë narsëquitë lduꞌu lëꞌë më; lu guë́ꞌdchiliu tsu paz, cuedchí lduꞌu mieti. ");
INSERT INTO zacNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Iurë ra ianglë bëabrí raiꞌ gubeꞌe, guniꞌi ra vëquërë lu saꞌ raiꞌ: ―Cha guiá hiaꞌa Belén, nia pë guc de lo quë nabëluaꞌa Dadë Dios lu hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Iurní nasesë ziaꞌa raiꞌ Belén. Guná raiꞌ lu María nu José nu meꞌdë. Lëꞌë meꞌdë nagaꞌa catë rau ma. ");
INSERT INTO zacNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Iurë guná ra vëquërë lu raiꞌ, guniꞌi rall lu ra mënë nazugaꞌa ndë lo quë naguniꞌi ianglë lu rall shcuendë meꞌdë. ");
INSERT INTO zacNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Grë nazugaꞌa ndë bini naguniꞌi vëquërë; bëꞌnë rall llgabë gu nanú verdá lo quë naguniꞌi vëquërë. ");
INSERT INTO zacNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Perë María adë ruadíꞌdzëdiꞌi pë llgabë nananú laꞌni ldúꞌiꞌ. Guaglaꞌguë bë́ꞌniꞌ llgabë lla na ra cusë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ra vëquërë bëabrí rall. Guniꞌi rall de quë llëruꞌbë na pudërë shtë Dios. Guniꞌi rall dushquilli Dios por lo quë naguná rall nu lo quë nabini rall. Bëdëꞌë rall graci lu më purquë grë cusë guc cumplir tal ziquë guniꞌi ianglë lu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Gudëdë shunë dzë; iurní bëchuguë bëshuzi duꞌpë guiꞌdi shtë partë delicadë shtë meꞌdë. Bërulë́ meꞌdë Jesús, el mizmë naguniꞌi ianglë lu María antsë lë́ꞌiꞌ guaꞌa shíniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Iurë gualú cuarenta dzë, iurní bëꞌnë tucarë gunë María nu José cumplir según lëy shtë Moisés të gáquiꞌ limpi. Bëꞌnë raiꞌ narunë tucarë tubi naꞌa narapë meꞌdë. Por ni José nu María guanú raiꞌ lëꞌë Jesús iáduꞌu ruꞌbë ciudá Jerusalén. Guagdchininú raiꞌ lëꞌë meꞌdë lu Dadë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bëꞌnë raiꞌ ni purquë naescritë laꞌni lëy shtë Dios narniꞌi: “Primërë ngulëꞌnë naguëneꞌe Dios parë lëꞌë të, gulë tsagdchininú të meꞌdë lu Dadë Dios purquë náhiꞌ parë lëꞌë më”. ");
INSERT INTO zacNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nu zac María nu José bëdëꞌë raiꞌ chupë maꞌñi gati ra ziquë ofrendë lu Dios purquë lëy shtë Dios rniꞌi: “Ra prubi gunë rall ofrecërë chupë guguë u chupë palumë biꞌchi”. ");
INSERT INTO zacNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tiempë ni guquëreldë tubi nguiu guëꞌdchi Jerusalén. Lë́hiꞌ Simeón nu tubldí na shcuéndiꞌ lu Dios. Bë́ꞌniꞌ cumplir shtiꞌdzë më. Nu cabéziꞌ guëdchini tubi nagunë salvar naciuni Israel de grë enemigu shtë rall. Espíritu Santo cabezënúhiꞌ Simeón. ");
INSERT INTO zacNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bëdchini tubi diꞌdzë lu Simeón por pudërë shtë Espíritu Santo de quë adë gátidiꞌi Simeón hashtë despuësë guënáhiꞌ lu Cristo, el quë nagudili Dios parë guënibë́ꞌaiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Espíritu Santo bëꞌnë compañi lëꞌë Simeón të guáhiꞌ iáduꞌu ruꞌbë mizmë tiempë bëdchini María nu José parë guëdchininú raiꞌ meꞌdë Jesús lu Dios, nu bëꞌnë raiꞌ ofrecërë chupë ma lu më. Bëꞌnë raiꞌ cumplir lëy shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón gudëdchi lëꞌë meꞌdë. Bëꞌnë Simeón alabar Dios; guniꞌi Simeón: ");
INSERT INTO zacNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Dadë, iurneꞌ nahia cunformë; gualú shchiꞌnia. Cuntëntë gatia purquë bë́ꞌnël cumplir lo quë naguníꞌil lua. ");
INSERT INTO zacNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Gunahia con prupi sluhia lu nagunë salvar lëꞌë naꞌa. Bëshéꞌldël nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Bëshéꞌldël lë́ꞌiꞌ delantë grë ra naciuni shtë guë́ꞌdchiliu të guëná rall lu Salvador. ");
INSERT INTO zacNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Lë́ꞌiꞌ náhiꞌ ziquë na llni parë guëzianiꞌ lu ra mënë nanádiꞌi më israelitë; gac bëꞌa rall shtíꞌdziꞌ, nu por lë́ꞌiꞌ ra më israelitë nagudílil, gapë rall hunurë. ");
INSERT INTO zacNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José con shniꞌa Jesús guasë́ lduꞌu raiꞌ iurë bini raiꞌ lo quë naguniꞌi Simeón. ");
INSERT INTO zacNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeón gunaꞌbë lu Dios të gunë ldaiꞌ më lëꞌë raiꞌ. Nu guniꞌi Simeón lu María: ―Guná, por lo quë nagunë meꞌdë rëꞌ zihani mënë israelitë tsabiꞌguë rall lu Dios, nu zihani rall guëniti rall lu më. Shtíꞌdziꞌ gac ziquë sëñi parë ra mënë naquëreldë tiempë neꞌ perë gunë rall cuntrë lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Perë lë́ꞌël, María, gápël dulurë ziquë tubi spadë dëdë laguë laꞌni ldúꞌul. Por meꞌdë rëꞌ llgabë nagaꞌchi shtë zihani mënë, guëruꞌu rahin lu llni. ");
INSERT INTO zacNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nu zac laꞌni Jerusalén nanú tubi naꞌa lë Ana naná shtsaꞌpë Fanuel. Aser guc shtadë guëlú raiꞌ. Ana guc tubi siervë nabiadiꞌdzë shtiꞌdzë Dios, perë hia gúꞌshiꞌ. Llíguiꞌ bëtsë́ꞌaiꞌ. Gubaninúhiꞌ tséꞌliꞌ gadchi izë, guti tséꞌliꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Bëáꞌniꞌ viudë; neꞌ nápiꞌ ochenta y cuatro izë. Grë ra dzë riáhiꞌ iáduꞌu. Dzë la gueꞌlë rúniꞌ adorar Dios. Ruadiꞌdzënúhiꞌ Dios nu rúniꞌ ayunë. ");
INSERT INTO zacNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mërë iurní guabiꞌguë Ana catë cabezë José nu María con meꞌdë, bëdëꞌë Ana graci lu Dios. Guaglaꞌguë biadiꞌdzënú Ana lu ra mënë naquëbezë el quë naguësheꞌldë Dios parë gúniꞌ salvar naciuni Israel. Jesús na el quë nabësheꞌldë Dios, guniꞌi Ana. ");
INSERT INTO zacNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Iurní gualú bëꞌnë María nu José cumplir grë narunë tucarë según lëy shtë Dios iurë lëꞌë primërë shini mënë guëdchini guë́ꞌdchiliu, bëabrí raiꞌ Galilea hashtë guëꞌdchi Nazaret, ladzë María nu José. ");
INSERT INTO zacNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Lëꞌë meꞌdë guaruꞌbë con llëruꞌbë llni shtë Dios. Bëꞌnë Dios compañi lë́ꞌiꞌ nu bëꞌnë ldaiꞌ më guë́quiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cadë izë ria shtadë Jesús Jerusalén parë gac laní Pascu. ");
INSERT INTO zacNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Chiꞌbë chupë izë napë Jesús, iurní gua raiꞌ Jerusalén ziquë na custumbrë shtë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Iurë gualú laní, gunaꞌzi raiꞌ nezë Nazaret. Hia Jesús bëáꞌniꞌ Jerusalén perë adë bëdë́ꞌëdiꞌi raiꞌ cuendë. ");
INSERT INTO zacNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bëꞌnë raiꞌ llgabë Jesús zeꞌdë ladi ra mënë nazeꞌdënú raiꞌ. Hia guc tubi dzë zeꞌdë guëzë́ raiꞌ, iurní guatili raiꞌ shini raiꞌ entrë shfamili raiꞌ nu entrë los de más saꞌ raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Adë bëdzélëdiꞌi raiꞌ Jesús. Iurní bëabrí raiꞌ Jerusalén parë tsatili raiꞌ Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Gudëdë tsunë dzë; bëdzéliꞌ laꞌni iáduꞌu. Zubënúhiꞌ ra mësë narluaꞌa lëy shtë Moisés. Caquë́ diaguë Jesús shtiꞌdzë rall nu zac gunaꞌbë díꞌdziꞌ lu rall. ");
INSERT INTO zacNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Grë nabini naguniꞌi Jesús, bëdzëguëëꞌ lduꞌu rall tantë ráquiꞌ nu manërë rquébiꞌ lu shtiꞌdzë ra mësë. ");
INSERT INTO zacNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Iurë lëꞌë shtádiꞌ bëdchini con shníꞌaiꞌ, bëdzëguëëꞌ lduꞌu raiꞌ. Iurní guniꞌi María: ―Llgaꞌnë, ¿pëzielú bë́ꞌnël zniꞌi con lëꞌë naꞌa? Shtádël nu lëꞌë na nalë́ rquëdiꞌni lduꞌu naꞌa; zudili naꞌa lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iurní guniꞌi Jesús lu raiꞌ: ―¿Pëzielú quëguili të na stubi lugar? ¿Pë adë rac bë́ꞌadiꞌi të napë quë guna lo quë narac shtuꞌu Shtada? ");
INSERT INTO zacNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Perë lëꞌë raiꞌ adë guc bë́ꞌadiꞌi raiꞌ pë runë cuntienë shtiꞌdzë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Lueguë bëabrí Jesús con lëꞌë raiꞌ guëꞌdchi Nazaret. Guaglaꞌguë bëzuꞌbë diaguë Jesús lu shtádiꞌ. Hia shníꞌaiꞌ quëhúniꞌ tantë llgabë laꞌni ldúꞌiꞌ perë adë chu lu biadíꞌdzëdiꞌiꞌ pë llgabë nápiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús guaglaꞌguë guarúꞌbiꞌ nu bëdëꞌë Dios llni guë́quiꞌ. Grë lo quë nabë́ꞌniꞌ, bëaꞌnin bien lu Dios nu lu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Laꞌni izë cheꞌñi shtë gubiernë Tiberio César naná rëy rumanë, Poncio Pilato guc gubernadurë shtë Judea. Herodes guc gubernadurë shtë Galilea. Lëꞌë bë́chill, Felipe, guc gubernadurë shtë Iturea nu Traconite. Lisanias guc gubernadurë shtë Abilinia. ");
INSERT INTO zacNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás nu Caifás na rall primërë bëshuzi namás rnibëꞌa. Laꞌni ra dzë ni bëdchini shtiꞌdzë Dios lu Juan, shini Zacarías, lugar catë nídiꞌi mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan ziaꞌa zihani nezë. Guagníꞌiꞌ lu ra mënë naquëreldë guëlladchi ruaꞌ guëëꞌgu Jordán. Guníꞌiꞌ lu ra mënë chubë nisë rall parë gac bëꞌa mieti gunë nadzëꞌë mudë nanabani rall, zni gac perdunë duldë shtë rall. ");
INSERT INTO zacNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Zni bëꞌnë Juan según nabëquëꞌë Isaías, el quë nabiadiꞌdzë shtiꞌdzë Dios. Bëquëꞌë Isaías: Nanú tubi narniꞌi fuertë lugar catë quëréldëdiꞌi mënë. Guníꞌiꞌ: “Gulë bëꞌnë preparar laꞌni lduꞌu të ziquë nezë ldi parë iurë lëꞌë më guëdchini. ");
INSERT INTO zacNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Grë bërrancu guëdzeꞌ. Grë dani con ra lumë gaquin tubldí. Grë nezë lecu guëldí rahin. Ra nezë despareju guëac zaꞌquin. ");
INSERT INTO zacNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Grë ra mënë shtë guë́ꞌdchiliu guëná rall lla mudë guëzunë́ më almë shtë ra mënë parë gac salvar rall.” ");
INSERT INTO zacNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Iurë bëdchini zihani mënë lu Juan parë guëchuꞌbë nisë Juan lëꞌë rall, guniꞌi Juan: ―Na të ziquë shini mbeꞌldë. Gunë më juzguë lëꞌë të. Nídiꞌi mudë guëruꞌu të sin quë adë gac juzguë të. ");
INSERT INTO zacNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Si talë gunë nadzëꞌë të mudë nabani të, gulë gac të ziquë hiaguë nardëꞌë nashi. Gulë bëꞌnë bien lu saꞌ të. Adë gápëdiꞌi të confiansë purquë na të llëbní Abraham gunë Dios salvar lëꞌë të purquë rniaꞌa lu të, napë më pudërë parë lëꞌë guëꞌë rëꞌ gac rahin llëbní Abraham. ");
INSERT INTO zacNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mizmë iurneꞌ ziquë guiubëaguë nalistë parë chuguë ra hiaguë, grë ra hiaguë nanápëdiꞌi nashi zaꞌquë, chuguin nu tsahin lu guiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Iurní gunaꞌbë diꞌdzë ra mënë zihani: ―¿Pë rac shtuꞌu Dios guëdëꞌnë naꞌa? ");
INSERT INTO zacNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan bëquebi: ―El quë nanapë chupë manguë, guëdë́ꞌëll tubi caꞌa el quë nabënápëdiꞌi. El quë nanapë naguëdaꞌu, quíꞌdzëllin caꞌa nabënápëdiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nu bëdchini bëldá cubradurë shtë impuestë parë chubë nisë rall. Gunaꞌbë diꞌdzë rall lu Juan: ―Mësë. ¿Pë guëdëꞌnë naꞌa? ");
INSERT INTO zacNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan guniꞌi: ―Adë rúnëdiꞌi të cubrë más de lo quë narniꞌi lëy caꞌa të. ");
INSERT INTO zacNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nu bëldá suldadë rumanë gunaꞌbë diꞌdzë rall: ―Lëꞌë naꞌa, ¿pë guëdëꞌnë naꞌa? Guniꞌi Juan lu rall: ―Adë cuánëdiꞌi të shtë mënë con galnë́. Adë guëdchisúdiꞌi të pë shtë mënë con bishi. Gulë gac cunformë lo quë naquëguilli gubiernë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Cumë ziquë ra mënë gualdí lduꞌu rall zeꞌdë guëdchini cusë ruꞌbë, guniꞌi rall laꞌni lduꞌu rall gu lëꞌë chaꞌa Juan náhiꞌ Cristo, el quë nagudili Dios parë guënibë́ꞌaiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Perë Juan bëquebi lu ra mënë: ―Guldía, rchuꞌbë nisa con nisë perë zeꞌdë stubi më más nanapë pudërë quë na. Adë rúnëdiꞌi tucarë guëshaca du guiꞌdi shtë shrachi më. Lëꞌë më gunë më stubi cusë. Guëzunë́ më lduꞌu të con Espíritu Santo nu guënéꞌeiꞌ pudërë. Stubi tantë lëꞌë të gunë më juzguë con juici shtë guiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ziquë tubi narsú bëꞌdchi trigu të parë rruꞌu guiꞌlli tubi cuꞌ, zni guëdchini më të cuë më ra mënë zaꞌquë parë lëꞌë më. Ra mënë narialdídiꞌi lduꞌi Dios tsa rall lu guiꞌi catë nídiꞌi fin. ");
INSERT INTO zacNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Con ra diꞌdzë rëꞌ nu con zihani enseñansë, bëluaꞌa Juan dizaꞌquë lu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Perë Juan guniꞌi guëc gubernadurë Herodes de quë nádiꞌi zaꞌquë nabëꞌnë Herodes con tseꞌlë bëchi Herodes. Felipe lë bë́chill. Naꞌa ni lë Herodías. Por zihani cusë mal nabëꞌnë Herodes guniꞌi Juan guë́quëll. ");
INSERT INTO zacNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nu Herodes bë́ꞌnëll stubi cusë más naná mal; bëtiáꞌall lëꞌë Juan lachiguiꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Antsë Juan gua lachiguiꞌbë, iurë lëꞌë ra mënë bëriubë nisë, nu Jesús bëriubë nisë; guzac iurë guniꞌinú Jesús Dios, iurní bëllaꞌlë gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Iurní bëdchini Espíritu Santo parë cuezënúhiꞌ lëꞌë më. Rluáꞌaiꞌ ziquë shcuerpë palumë nu bëdchini tubi bë nezë lu gubeꞌe nu guniꞌi bë: ―Lë́ꞌël nal shinia narac shtuaꞌa. Nalë́ rquitë lduaꞌa rnahia lul. ");
INSERT INTO zacNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús napë galdë bi chi izë, iurní guzublú bëluaꞌa më lëꞌë ra mënë. Grë ra mënë gualdí lduꞌu rall Jesús na shini José. Shtadë José guc Elí. ");
INSERT INTO zacNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Shtadë Elí guc Matat. Shtadë Matat guc Leví. Shtadë Leví guc Melqui. Shtadë Melqui guc Jana. Shtadë Jana guc José. ");
INSERT INTO zacNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Shtadë José guc Matatías. Shtadë Matatías guc Amós. Shtadë Amós guc Nahum. Shtadë Nahum guc Esli. Shtadë Esli guc Nagai. ");
INSERT INTO zacNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Shtadë Nagai guc Maat. Shtadë Maat guc Matatías. Shtadë Matatías guc Semei. Shtadë Semei guc José. Shtadë José guc Judá. ");
INSERT INTO zacNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Shtadë Judá guc Joana. Shtadë Joana guc Resa. Shtadë Resa guc Zorobabel. Shtadë Zorobabel guc Salatiel. Shtadë Salatiel guc Neri. ");
INSERT INTO zacNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Shtadë Neri guc Melqui. Shtadë Melqui guc Adi. Shtadë Adi guc Cosam. Shtadë Cosam guc Elmodam. Shtadë Elmodam guc Er. ");
INSERT INTO zacNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Shtadë Er guc Josué. Shtadë Josué guc Eliezer. Shtadë Eliezer guc Jorim. Shtadë Jorim guc Matat. ");
INSERT INTO zacNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Shtadë Matat guc Leví. Shtadë Leví guc Simeón. Shtadë Simeón guc Judá. Shtadë Judá guc José. Shtadë José guc Jonan. Shtadë Jonan guc Eliaquim. ");
INSERT INTO zacNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Shtadë Eliaquim guc Melea. Shtadë Melea guc Mainán. Shtadë Mainán guc Matata. Shtadë Matata guc Natán. Shtadë Natán guc David. ");
INSERT INTO zacNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Shtadë David guc Isaí. Shtadë Isaí guc Obed. Shtadë Obed guc Booz. Shtadë Booz guc Salmón. Shtadë Salmón guc Naasón. ");
INSERT INTO zacNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Shtadë Naasón guc Aminadab. Shtadë Aminadab guc Aram. Shtadë Aram guc Esrom. Shtadë Esrom guc Fares. Shtadë Fares guc Judá. ");
INSERT INTO zacNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Shtadë Judá guc Jacob. Shtadë Jacob guc Isaac. Shtadë Isaac guc Abraham. Shtadë Abraham guc Taré. Shtadë Taré guc Nacor. ");
INSERT INTO zacNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Shtadë Nacor guc Serug. Shtadë Serug guc Ragau. Shtadë Ragau guc Peleg. Shtadë Peleg guc Heber. Shtadë Heber guc Sala. ");
INSERT INTO zacNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shtadë Sala guc Cainán. Shtadë Cainán guc Arfaxad. Shtadë Arfaxad guc Sem. Shtadë Sem guc Noé. Shtadë Noé guc Lamec. ");
INSERT INTO zacNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Shtadë Lamec guc Matusalén. Shtadë Matusalén guc Enoc. Shtadë Enoc guc Jared. Shtadë Jared guc Mahalaleel. Shtadë Mahalaleel guc Cainán. ");
INSERT INTO zacNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Shtadë Cainán guc Enós. Shtadë Enós guc Set. Shtadë Set guc Adán. Adán na shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús bësëaꞌnë guëëꞌgu Jordán, nu guc më completamente de acuerdë con lo quë narac shtuꞌu Espíritu Santo. Iurní Espíritu Santo biaꞌa lëꞌë Jesús catë nídiꞌi mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Hia ndë guquëreldë më cuarenta dzë. Durantë guëdubi tiempë ni adë gudáudiꞌi më, nu bëdchini mëdzabë Satanás parë guëtëꞌdë mëdzabë prëbë lëꞌë më të niasiguë́ mëdzabë lëꞌë më. Iurë gualú cuarenta dzë, bëdchini galërldiaꞌnë lduꞌu më. ");
INSERT INTO zacNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Guniꞌi mëdzabë lu Jesús: ―Si talë rníꞌil nal shini Dios, guniꞌi lu guëꞌë rëꞌ guëaquin guetështildi gaul. ");
INSERT INTO zacNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús repi lull: ―Naescritë laꞌni shtiꞌdzë Dios: “Lëdë niáꞌasëdiꞌi guetështildi guëbani nguiu sino por grë diꞌdzë narniꞌi Dios guëbani nguiu”. ");
INSERT INTO zacNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Iurní biaꞌa mëdzabë lëꞌë Jesús lu guëc dani ruꞌbë. Mizmë iurní bëluáꞌall grë lugar catë rnibëꞌa ra mënë. Guná më lu rahin tubi chupë mumëntë. ");
INSERT INTO zacNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Repi mëdzabë lu më: ―Grë ndëꞌë guënehia cáꞌal con grë cusë zaꞌquë nananú lu guë́ꞌdchiliu. Guënibë́ꞌal rahin. Bëna recibir pudërë guënibë́ꞌahia grë cusë ni, nu guëdë́ꞌahin caꞌa el quë naquëhuna disponer. ");
INSERT INTO zacNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Grë guënibë́ꞌal si talë guëzullíbil lua nu gúnël adorar na. ");
INSERT INTO zacNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Perë Jesús repi: ―Guabsú lua. Naescritë laꞌni shtiꞌdzë Dios: “Sulë Dadë Dios gúnël adorar. Sulë lëꞌë më guëzuꞌbë diáguël.” ");
INSERT INTO zacNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Despuësë lëꞌë mëdzabë biaꞌa lëꞌë më ciudá Jerusalén catë zubë iáduꞌu ruꞌbë. Ziaꞌanú mëdzabë lëꞌë më guëc iáduꞌu. Iurní guniꞌi mëdzabë: ―Si talë guldil rníꞌil nal shini Dios, bëruꞌldë lë́ꞌël hashtë lu guiuꞌu ");
INSERT INTO zacNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","purquë shtiꞌdzë Dios rniꞌi: Dios guënibëꞌa ra ianglë parë gapë raiꞌ lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Guaꞌa raiꞌ lë́ꞌël guiaꞌa raiꞌ të ni tubi guëꞌë gunënë́diꞌi guëaꞌl. ");
INSERT INTO zacNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iurní Jesús guníꞌiꞌ lu mëdzabë: ―Nu zac shtiꞌdzë Dios rniꞌi: “Adë rtë́ꞌdëdiꞌil prëbë lëꞌë Dadë Dios shtënë të. Adë rúnëdiꞌil obligar lë́ꞌiꞌ.” ");
INSERT INTO zacNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Despuësë gualú zihani prëbë shtë mëdzabë nihunë më mal, bësëáꞌnëll lëꞌë më por tubi tiempë. ");
INSERT INTO zacNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Completamentë cabezënú Espíritu Santo Jesús; bëabrí më Galilea. Bërëꞌtsë famë shtë më grë́tëꞌ guëꞌdchi alrededurë de regiuni ni. ");
INSERT INTO zacNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Quëgluáꞌaiꞌ laꞌni grë iáduꞌu shtë më israelitë, nu grë mënë guniꞌi rall napë më llëruꞌbë pudërë. ");
INSERT INTO zacNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Beꞌdë guëzë́ Jesús Nazaret catë guarúꞌbiꞌ. Guzac tubi dzë descansë gua më iáduꞌu ziquë custumbrë shtë́hiꞌ. Guasuldí më parë guꞌldë më shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bëdëꞌë mënë nabëquëꞌë Isaías, el quë nabiadiꞌdzë shtiꞌdzë Dios guahietë. Bëdchili më luhin catë bëdzelë më narniꞌi zni: ");
INSERT INTO zacNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espíritu shtë Dadë Dios cabezënúa. Gudili më na parë guëniaꞌa dizaꞌquë lu ra prubi, ra nadë guënë́diꞌi Dios. Bësheꞌldë më na parë gac librë ra naná bajo ordë shtë mëdzabë. Nu nahia parë guëabrí slu ra ciegu, gac bëꞌa rall shnezë Dios. Nu nahia parë cuedchí lduꞌu ra naná rzac zi. ");
INSERT INTO zacNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nu bësheꞌldë më na parë guadiꞌdza de quë bëgaꞌa tiempë zaꞌquë gunë më favurë parë mënë narëtaꞌ lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Iurní bëtuꞌbi Jesús librë nu bëdëꞌë mëhin guiaꞌa el quë nacanihapë ra librë. Iurní guzubë më. Grë ra mënë narëtaꞌ laꞌni iáduꞌu, rbiꞌa rall lu më. ");
INSERT INTO zacNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesús guzublú biadíꞌdziꞌ lu rall: ―Nedzë́ guc cumplir shtiꞌdzë Dios rëꞌ mientras bini të diꞌdzë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Grë mënë cagniꞌi bien na shtiꞌdzë Jesús. Bëdzëguëëꞌ lduꞌu rall dizaꞌquë naguniꞌi më tantë nasaꞌa rac më. Nu guniꞌi lu saꞌ rall: ―Ndëꞌë naruadiꞌdzë, nadë más nall shini José. ");
INSERT INTO zacNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iurní Jesús guniꞌi lu rall: ―Seguramentë guëniꞌi të lua dichë narniꞌi: “Ducturë, bënëac mizmë lë́ꞌël”. Nu guëniꞌi të lua: “Lo quë nabë́ꞌnël ladi guëꞌdchi Capernaum, bëꞌnë ra cusë rëꞌ ládzël. Bini naꞌa lo quë nabë́ꞌnël guëꞌdchi Capernaum.” ");
INSERT INTO zacNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Guaglaꞌguë biadiꞌdzë më: ―En verdá rniaꞌa lu të, ra mënë adë nápëdiꞌi rall rëspëti parë tubi naruadiꞌdzë shtiꞌdzë Dios si talë náhiꞌ më ladzë rall. ");
INSERT INTO zacNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Guldía, tiempë shtë Elías nanú zihani viudë ladi ra më israelitë. Guláguëdiꞌi guiu por tsunë izë guëruldë, nu guꞌ gubini guëdubi naciuni rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Perë Dios bësheꞌldë lëꞌë Elías guëꞌdchi Sarepta shtë Sidón parë guëníꞌiꞌ lu tubi viudë nananú ladi guëꞌdchi rëꞌ. Adë bëshéꞌldëdiꞌi Dios lëꞌë Elías lu ra viudë nananú ladi mënë Israel. ");
INSERT INTO zacNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nu tiempë guahietë ladi naciuni Israel, nanú zihani narac lluꞌu galguidzë naruꞌdzë ládiꞌ. Tiempë ni nanú Eliseo el quë nabiadiꞌdzë shtiꞌdzë Dios, perë ni tubi mënë narac lluꞌu galguidzë ni ladi mënë Israel, bëáquëdiꞌi rall. Perë Naamán sulamëntë bëáquëll por pudërë shtë Dios. Nu lë́ꞌëll nall mënë shtë Siria, lë́dëdiꞌi shtë naciuni Israel. ");
INSERT INTO zacNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Iurë bini ra mënë diꞌdzë rëꞌ, grë ra narë́ laꞌni iáduꞌu, nalë́ bëldë́ rall. ");
INSERT INTO zacNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lueguë gulú rall lëꞌë Jesús ruaꞌ guëꞌdchi nu biaꞌa rall lë́ꞌiꞌ guiaꞌa ruaꞌ tubi bërrancu të parë guëldaguë rall lëꞌë më laꞌni parë gátiꞌ. Guëꞌdchi Nazaret zubë lu dani rëꞌ, ");
INSERT INTO zacNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","perë Jesús gudëdë lu rall parë guziaꞌa më stubi ladë. ");
INSERT INTO zacNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Gua Jesús Capernaum ciudá shtë Galilea. Ziagluaꞌa më stubi laꞌni iáduꞌu ra dzë narziꞌi lduꞌu mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Iurní bëdzëguëëꞌ lduꞌu mënë ldaiꞌ nu diꞌdzë naruadiꞌdzë më. Bënguë bëꞌa rall de quë bëluaꞌa Jesús con pudërë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Laꞌni iáduꞌu nanú tubi nguiu nanapë mëdzabë mal laꞌni ldúꞌull. Fuertë gurushtiall. Guníꞌill: ");
INSERT INTO zacNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¿Pë nápël con lëꞌë naꞌa, Jesús më Nazaret? ¿Pë zéꞌdël parë guëzalul lëꞌë naꞌa? Nanë́a chu nal. Nalimpi ldúꞌul lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iurní Jesús guniꞌi guëc mëdzabë. Guniꞌi Jesús fuertë lu espíritu mal: ―Guitsëgá, nu bëruꞌu de lë́ꞌëll. Iurní mëdzabë bëruꞌldë lëꞌë nguiu ni lu guiuꞌu delantë lu ra mënë. Bëruꞌu mëdzabë sin adë pë bëꞌnënúdiꞌill. ");
INSERT INTO zacNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Grë mënë bëdzëguëëꞌ lduꞌu rall. Guniꞌi lu saꞌ rall: ―¿Pëllë ldaiꞌ cubi rëꞌ? Jesús rnibëꞌa ra mëdzabë. Nápiꞌ pudërë parë rgúhiꞌ mëdzabë laꞌni lduꞌu mënë. Rzuꞌbë diaguë ra mëdzabë shtíꞌdziꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Por guëdubi nezë bërëꞌtsë diꞌdzë nabëꞌnë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iurní Jesús bëruꞌu iáduꞌu. Gua më lidchi Simón Pedro nu guatë́ më laꞌni hiuꞌu. Suëgrë Simón rac llúꞌull; ráquëll shldi ruꞌbë. Bëꞌnë mënë ruëguë lu Jesús gunëac më lëꞌë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iurní bëaꞌchi më, guná më lu narac lluꞌu. Fuertë guniꞌi më lu shldi. Lueguë bëruꞌu shldi. Lueguë lueguë guashtë́ naꞌa nu bëdëꞌë naꞌa nagáu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Iurë guaꞌzë ngubidzë, grë ra narac lluꞌu nu ra nanapë grë clasë galguidzë, beꞌdënú ra mënë lëꞌë rall lu Jesús. Bëdchiꞌbë më guiaꞌa më guëc rall. Grë rall bëac rall. ");
INSERT INTO zacNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nu bëgú më zihani mëdzabë nananú laꞌni lduꞌu mënë. Gurushtiá ra mëdzabë. Guniꞌi rall: ―Lë́ꞌël nal shini Dios. Perë lëꞌë Jesús bësëac dchi lëꞌë rall nu guniꞌi më fuertë lu rall të adë guadíꞌdzëdiꞌi rall purquë guc bëꞌa rall na më Cristo el quë nagudili Dios parë guënibë́ꞌaiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Iurë brëgueꞌlë, bëruꞌu Jesús guëꞌdchi rëꞌ. Ziaꞌa më tubi lugar catë nídiꞌi mënë. Lëꞌë ra mënë caguili rall lëꞌë më. Bëdchini rall catë cabezë më. Rac shtuꞌu rall guëaꞌnënú më lëꞌë rall. Guniꞌi rall adë guësëaꞌnë më lëꞌë rall, ");
INSERT INTO zacNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","perë Jesús guniꞌi: ―Rquiꞌni tsahia grë ra guëꞌdchi parë guadiꞌdza dizaꞌquë lla tsutë́ mënë catë rnibëꞌa Dios. Parë ni bësheꞌldë Dios na. ");
INSERT INTO zacNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nu guaglaꞌguë biadiꞌdzë më dizaꞌquë laꞌni iáduꞌu catë quëreldë ra mënë israelitë. ");
INSERT INTO zacNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Guzac tubi dzë nanú Jesús ruaꞌ nisë ruꞌbë lë Genesaret. Bëdchini mënë zihani hashtë rteꞌe mënë lëꞌë më. Rac shtuꞌu rall guini rall shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús guná lu chupë barcu nananú ruaꞌ nisë. Ra narnaꞌzi mbeldë bëruꞌu rall laꞌni barcu nu caguibi rall guëꞌshu shtë mbeldë. ");
INSERT INTO zacNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iurní guatë́ më laꞌni barcu shtë Simón Pedro. Guniꞌi më lu Pedro guëazë guetë barcu duꞌpë. Guzubë më lu barcu të parë guëluaꞌa më dizaꞌquë lu ra mënë narë́ ruaꞌ nisë ruꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Iurní gualú biadiꞌdzë më, guniꞌi më lu Pedro: ―Cha guiá hiaꞌa ca más zili nisë të guëtiaꞌa të guëꞌshu shtë të parë guëgaꞌa mbeldë. ");
INSERT INTO zacNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Perë Pedro repi: ―Mësë, guëdubi gueꞌlë bëdëꞌnë naꞌa dchiꞌni sin ni tubi mbeldë gáꞌadiꞌi guëgaꞌa. Perë hia quë lë́ꞌël rnibë́ꞌal guëtiaꞌa naꞌa guëꞌshu laꞌni nisë, guëdëꞌnë naꞌain. ");
INSERT INTO zacNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Lueguë bëꞌnë raiꞌ lo quë naguniꞌi Jesús. Bëgaꞌa mbeldë zihani hashtë lëꞌë guëꞌshu guzublú chíꞌezë. ");
INSERT INTO zacNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Iurní bëꞌnë raiꞌ sëñi lu saꞌ raiꞌ nazubë laꞌni stubi barcu parë guidë guëꞌnë raiꞌ compañi. Bëdchini raiꞌ. Bëguëuꞌ raiꞌ mbeldë laꞌni chupë barcu. Por tantë zihani mbeldë hia mërë në́ꞌazë barcu laꞌni nisë. ");
INSERT INTO zacNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Iurë guná Simón Pedro zihani mbeldë bëgaꞌa, bëzullibi Pedro lu Jesús nu guniꞌi Pedro: ―Bësëaꞌnë na, Dadë, nahia pecadurë. Napa zihani duldë. ");
INSERT INTO zacNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Zni guniꞌi Pedro purquë nalë́ bëdzëguëëꞌ ldúꞌiꞌ nu grë narëtaꞌ ngaꞌli bëdzëbë raiꞌ por tantë mbeldë gunaꞌzi raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nanú Jacobo nu bë́chill Juan ngaꞌli. Bëꞌnënú raiꞌ dchiꞌni con Pedro. Na Jacobo nu Juan shini Zebedeo. Nalë́ bëdzëguëëꞌ lduꞌu raiꞌ. Iurní Jesús guniꞌi lu Pedro: ―Adë rdzë́bëdiꞌil. Ziquë nal pescadurë iurneꞌ, zni gáquël pescadurë; gueꞌdënul mënë lua. ");
INSERT INTO zacNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Iurní gulú raiꞌ barcu ruaꞌ nisë catë na guiuꞌu. Bësëaꞌnë raiꞌ dchiꞌni nu guanaldë raiꞌ lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Guzac ladi tubi guëꞌdchi, bëdchini tubi nguiu lu Jesús. Rac llúꞌull galguidzë naruꞌdzë ládiꞌ guëdubi cuerpë shtë́nëll. Bëzullíbill lu më hashtë bëdchini luquëll lu guiuꞌu. Bë́ꞌnëll ruëguë lu më: ―Dadë si talë rac shtúꞌul, záquël gunëáquël na. ");
INSERT INTO zacNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iurní Jesús bëdchiꞌbë më guiaꞌa më guë́quëll. Guniꞌi më: ―Rac shtuaꞌa. Guëac galguidzë shtë́nël. Niáꞌasë gualú guniꞌi Jesús diꞌdzë rëꞌ, lueguë bëáquëll. ");
INSERT INTO zacNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iurní Jesús gunibëꞌa lë́ꞌëll adë chu lu guadíꞌdzëll. Guniꞌi më: ―Gua iáduꞌu; tsagnal bëshuzi parë guëná bëshuzi lul. Nu bëꞌnë ziquë guniꞌi Moisés shcuendë ra narac lluꞌu galguidzë ládiꞌ perë bëac rall. Gúnëlin parë grë mënë gac bëꞌa rall de verdá hia bëáquël. ");
INSERT INTO zacNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Guëdubi nezë ruadiꞌdzë mënë lo quë nabëꞌnë Jesús nu guagláꞌguëruꞌu bërëꞌtsë naguniꞌi mënë de lëꞌë më. Zihani mënë bëdëá parë guëquë́ diaguë rall shtiꞌdzë më nu parë gunëac më narac lluꞌu. ");
INSERT INTO zacNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Perë Jesús ziaꞌa tubi lugar catë nídiꞌi mënë. Ngaꞌli biadiꞌdzënúhiꞌ Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tubi dzë Jesús cagluaꞌa ra mënë. Ndë nanú bëldá mënë religiusë fariseos nu mësë narluaꞌa lëy shtë Moisés. Guzubë rall. Zeꞌdë rall zihani guëꞌdchi shtë Galilea nu Judea. Zeꞌdë rall de Jerusalén. Jesús napë pudërë shtë Dios parë bënëac më narac lluꞌu. ");
INSERT INTO zacNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Iurní guzac bëdchini bëldá nguiu; nuaꞌa rall tubi daaꞌ catë dchiꞌbë tubi nguiu narac llunguë. Rac shtuꞌu rall tsutënú rall narac lluꞌu laꞌni hiuꞌu catë cabezë më të gunëac më lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Perë adë gúquëdiꞌi guëdchini rall lu më tantë zihani mënë. Iurní güeꞌpi rall guëc hiuꞌu guiaꞌa. Gudidë rall dëllë guëc hiuꞌu të parë bëldaguë rall daaꞌ catë nagaꞌa nguiu narac lluꞌu. Bëldaguë rallin entrë de ladi ra mënë hashtë delantë lu Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús guná rialdí lduꞌu rall lëꞌë më. Guniꞌi më lu narac lluꞌu: ―Lë́ꞌël, naperdunë duldë shtë́nël. ");
INSERT INTO zacNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Iurní lëꞌë ra mësë shtë lëy nu ra fariseo guzublú quëhunë rall llgabë. Guniꞌi rall laꞌni lduꞌu rall: “¿Chu ndëꞌë? Blac diꞌdzë dzabë ruadíꞌdzëll cuntrë Dios purquë tubsë Dios runë perdunë duldë, lëdë núdiꞌi mënë.” ");
INSERT INTO zacNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Perë Jesús guc bëꞌa pë llgabë quëhunë rall. Iurní guniꞌi më: ―¿Pëzielú runë të llgabë zniꞌi? ");
INSERT INTO zacNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Pë más sencigi guëniaꞌa: “Naperdunë duldë shtë́nëll”? u guëniaꞌa: “Guasuldí nu guzë́”. ");
INSERT INTO zacNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Parë gac bëꞌa të nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, nu napa pudërë parë guna perdunë duldë, gulë guná. Iurní repi më lu nguiu narac lluꞌu galguidzë llunguë: ―Lul rniaꞌa, guasuldí. Bëtëá shtaaꞌl nu bëagzë́ lídchil. ");
INSERT INTO zacNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lueguë lëꞌë nguiu narac lluꞌu galguidzë, guasuldíll delantë lu rall. Bëtëall shtaaꞌll nu bëagrill lídchill. Bëdë́ꞌëll graci lu Dios. Llëruꞌbë na pudërë shtë më, guníꞌill. ");
INSERT INTO zacNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Grë mënë bëdzëguëëꞌ lduꞌu rall. Guniꞌi rall llëruꞌbë na pudërë shtë Dios. Bëchiꞌchi rall tantë rdzëbë rall. Guniꞌi rall: ―Neꞌ guná hiaꞌa cusë ruꞌbë nadë riasë́diꞌiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iurní Jesús bëruꞌu guëꞌdchi ni. Guná më lu tubi nguiu narunë cubrë impuestë. Lëll Leví nu guzúbëll lugar catë riatilli mënë impuestë. Guniꞌi Jesús lu Leví: ―Gudeꞌe naldë na. ");
INSERT INTO zacNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lueguë Leví guasuldill nu guanáldëll lëꞌë Jesús. Bësëaꞌnëgall shchíꞌnill nu grë nashtë́nëll. ");
INSERT INTO zacNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Más despuësë Leví gunibëꞌa gac tubi laní parë Jesús lidchi Leví. Zihani mënë narunë cubrë impuestë bëdchini rall. Lëꞌë rall con más mënë guzubë rall lu mellë con Leví nu Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Perë ra fariseo nu mësë shtë ra fariseo guzublú guniꞌi rall cuntrë ra shini gusëꞌdë më; guniꞌi rall: ―¿Pëzielú raunú të con ra pecadurë nu con ra narunë cubrë impuestë nu ruuꞌnú të lëꞌë rall? ");
INSERT INTO zacNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús guniꞌi lu rall: ―Ra narac lluꞌu, rquiꞌni rall tubi ducturë perë el quë nabëráquëdiꞌi, adë rquíꞌnidiꞌill ducturë. ");
INSERT INTO zacNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Zeldë guënaꞌba gac salvar ra pecadurë të guëabrí lduꞌu rall con Dios. Na adë zeldë guënáꞌbëdiaꞌa mënë narniꞌi nápëdiꞌi duldë. ");
INSERT INTO zacNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Iurní ra fariseo gunaꞌbë diꞌdzë rall lu Jesús: ―Ra shini gusëꞌdë Juan Bautista quëhunë rall ayunë zihani vueltë nu zihani ruadiꞌdzënú rall Dios, nu ra shini gusëꞌdë fariseo runë rall zni. ¿Pëzielú shini gusë́ꞌdël rau rall; ruuꞌ rall? ");
INSERT INTO zacNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús guniꞌi iurní: ―¿Pë zunë të obligar ra invitadë shtë saꞌa gunë rall ayunë mientras cabezënú rall lliguë? ");
INSERT INTO zacNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Perë guëdchini dzë hiadë cuezënúdiꞌi lliguë lëꞌë rall, iurní sí, gunë rall ayunë. ");
INSERT INTO zacNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Guniꞌi Jesús comparaciuni rëꞌ: ―Ni tubi chu rúnëdiꞌi rumiendë lu lari gushë con lari cubi, purquë si talë guëguëuꞌl lari bëuldë con lari cubi, rcheꞌzë lari cubi. Adë rgáꞌadiꞌi rluaꞌa lari cubi rëuꞌ lu lari gushë. ");
INSERT INTO zacNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ni tubi adë rgutsaꞌu vini cubi laꞌni bulsë gushë. Adë gúnëdiꞌi bulsë gushë gan lu fuersë shtë vini cubi. Ríꞌezë bulsë gushë nu lëꞌë vini guëllëꞌë lu guiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Por ni rquiꞌni tsutsaꞌu vini cubi laꞌni bulsë cubi. Iurní lëꞌë vini nu ra bulsë adë guënítidiꞌin. ");
INSERT INTO zacNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","El quë naruuꞌ vini nanapë tiempë, rac shtúꞌudiꞌill gull vini cubi purquë rniꞌill: “Vini nanapë tiempë na mejurë”. ");
INSERT INTO zacNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Guzac tubi dzë narziꞌi lduꞌu mënë, gudëdë Jesús con ra shini gusëꞌdë më catë nanú trigu. Lëꞌë shini gusëꞌdë më caniashi raiꞌ duꞌu shtë trigu nu quëshá guiaꞌa raiꞌ guëc duꞌu parë guëruꞌu bëꞌdchi gau raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Iurní ra mënë religiusë fariseo nazugaꞌa ngaꞌli, guná rall pë quëhunë raiꞌ. Gunaꞌbë diꞌdzë rall lu Jesús: ―¿Pëzielú runë të lo quë naná providë quëhunë të dzë narziꞌi lduꞌu mënë? ");
INSERT INTO zacNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús bëquebi lu rall: ―¿Pë adë bíꞌldidiꞌi të lo quë nabëꞌnë David guahietë? Iurë bëldiaꞌnë grë shmënë David, ");
INSERT INTO zacNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","guatë́ David lidchi Dios. Gunaꞌzi David guetështildi sagradë nabëdchiꞌbë bëshuzi lu Dios. Gudáu David. Bëdëꞌë David gudáu ra mënë nazeꞌdënú lë́ꞌiꞌ. Perë guetështildi sagradë niétiquë bëshuzi ráuhin. Naprovidë gau cualquier mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Guaglaꞌguë guniꞌi Jesús: ―Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. Napa derechë guënibë́ꞌahia pë cusë gunë ra mënë dzë descansë. ");
INSERT INTO zacNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Guzac stubi dzë narziꞌi lduꞌu mënë guatë́ Jesús iáduꞌu. Quëgluaꞌa më dizaꞌquë lu ra mënë. Ndë zugaꞌa tubi nguiu nagubidchi guiáꞌaiꞌ ladë ldi. ");
INSERT INTO zacNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ra mësë shtë lëy con ra fariseo quëgldaꞌchi rall lëꞌë më parë guëná rall nia pë gunë më dzë narziꞌi lduꞌu mënë. Quëgldaꞌchi rall nia zunëac më parë guëdzelë rall mudë parë pë gunënú rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Perë Jesús guc bëꞌa pë llgabë quëhunë rall. Iurní guniꞌi më lu nguiu nagubidchi guiáꞌaiꞌ: ―Gudeꞌe ndëꞌë nu guasuldí guëláu. Lëꞌë nguiu ni guasuldill. Guzull catë guniꞌi më. ");
INSERT INTO zacNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Iurní guniꞌi Jesús lu ra nazugaꞌa: ―Rnaꞌbë diꞌdza tubi cusë. ¿Pë rniꞌi lëy shtë hiaꞌa? ¿Gunë nguiu bien u gunë nguiu mal dzë descansë? ¿Zúnëll rumëdi nguiu u zësáꞌnëll gati nguiu? ");
INSERT INTO zacNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iurní Jesús gubiꞌa lu grë ra mënë nabëdëá ngaꞌli. Guniꞌi më lu nguiu: ―Bëldí guiáꞌal. Lueguë bëldí guiáꞌaiꞌ. Lueguë bëáquëll. ");
INSERT INTO zacNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ra fariseo nu ra mësë nalë́ bëldë́ rall. Iurní guzublú rall guënaꞌbë diꞌdzë lu saꞌ rall pë gunë rall con Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Laꞌni ra dzë ni Jesús ziaꞌa lu dani parë guadiꞌdzënúhiꞌ Dios. Guaꞌa gueꞌlë biadiꞌdzënúhiꞌ Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Iurná brëgueꞌlë gunaꞌbë më ra shini gusëꞌdë më. Bëꞌnë më nombrar chiꞌbë chupë mënë parë gac rall poshtë shtënë më. ");
INSERT INTO zacNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ndëꞌë na lë ra poshtë: primërë poshtë lë Simón nu bëdëꞌë më stubi lë́hiꞌ, bërulë́hiꞌ Pedro. En seguidë na Andrés, bëchi Simón. Nanú Jacobo, nu Juan nu Felipe nu Bartolomé, ");
INSERT INTO zacNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","nu Mateo nu Tomás nu Jacobo. Jacobo na shini Alfeo. Nu bëꞌnë Jesús nombrar Simón nanapë llëruꞌbë ánimo parë lëy. ");
INSERT INTO zacNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Nu nanú Judas, shini Jacobo con stubi Judas nabërulë́ Iscariote, el quë nabëꞌnë intriegu lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús con ra shini gusëꞌdë më, bietë raiꞌ lu dani. Cabezë raiꞌ lu lumë shtë dani con zihani narianaldë lëꞌë më. Nu zeꞌdë mënë zihani de Judea nu Jerusalén nu zeꞌdë rall regiuni shtë Tiro nu Sidón naquë́ ruaꞌ nisë ruꞌbë. Bëdchini rall parë guëquë́ diaguë rall shtiꞌdzë Jesús, nu parë gunë më rumëdi ra galguidzë shtë rall. ");
INSERT INTO zacNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nu ra nanapë mëdzabë fier laꞌni lduꞌi, bëac rall. ");
INSERT INTO zacNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Grë mënë rac shtuꞌu rall guëgaꞌldë rall shabë më parë guëac rall. Bënëac më narac lluꞌu con pudërë shtënë më. ");
INSERT INTO zacNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iurní Jesús gubiꞌa lu shini gusëꞌdë më, nu guníꞌiꞌ: ―Dichusë të, adë nápëdiꞌi të zihani cusë shtë guë́ꞌdchiliu perë rnibëꞌa Dios lëꞌë të; tsutë́ të lugar catë na më Rëy. ");
INSERT INTO zacNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Dichusë të, napë të nicidá laꞌni lduꞌu të iurneꞌ. Gunë të recibir lo quë narquiꞌni të. ’Dichusë të, lëꞌë të naruꞌnë iurneꞌ. Guëquitë lduꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Dichusë të iurë rna záꞌquëdiꞌi mënë lu të, nu iurë rgu rall lëꞌë të iáduꞌu, iurë rushtiá rall guëc të, nu iurë guëniꞌi mënë na të cusë mal. Gunë rall grë ndëꞌë purquë na të shmëna, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gulë bëquitë lduꞌu të nu gulë bëchesë tantë rquitë lduꞌu të dzë naguëniꞌi mënë cuntrë lëꞌë të. Zni ra shtadë guëlú rall bëꞌnë rall cuntrë ra nabiadiꞌdzë shtiꞌdzë Dios guahietë. Gulë bëquitë lduꞌu të purquë napë më tubi premi ruꞌbë gubeꞌe parë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Perë rniaꞌa lu ra ricu, prubi de lëꞌë të purquë hia napë të grë lo quë narsëquitë lduꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Nu rniaꞌa lu të nanapë grë lo quë narac shtuꞌu të. Prubi de lëꞌë të purquë guëdchini tiempë guëaꞌnë të sin quë adë pë nápëdiꞌi të. ’Nu rniaꞌa lu të nabëquitë lduꞌi guë́ꞌdchiliu. Prubi de lëꞌë të purquë despuësë guꞌnë të nu cushtiá të. ");
INSERT INTO zacNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Nu rniaꞌa lu të nanapë gustë iurë lëꞌë mënë rniꞌi bien de lëꞌë të. Prubi de lëꞌë të purquë na të ziquë shtadë guëlú të. Shtadë guëlú të guniꞌi rall bien de nguiu bishi naguniꞌi na rall siervë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Guaglaꞌguë guniꞌi Jesús: ―Rniaꞌa lu të nabini shtiꞌdza, gulë guc shtuꞌu ra narldënú lëꞌë të. Gulë bëꞌnë bien lu contrari shtë të. ");
INSERT INTO zacNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gulë guniꞌi bien lu narniꞌi guidzë guëc të. Gulë gunaꞌbë lu Dios por el quë narushtiá guëc të. ");
INSERT INTO zacNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Si talë chu cubë́ lul, adë rúnëdiꞌil ziquë bë́ꞌnëll; más bien bëdëꞌë lë́ꞌël cubëll stubi ladë. Si talë chu rquëduꞌu guëdchisú shábël, bëdëꞌë lë́ꞌël guëdchisull shmánguël. ");
INSERT INTO zacNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Gulë bëdëꞌë nacaꞌa el quë narnaꞌbë lul. Si talë chu rdchisú pë nápël, adë guënáꞌbëdiꞌil lull parë guënéꞌellin. ");
INSERT INTO zacNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gulë bëꞌnë tratë saꞌl igual ziquë rac shtúꞌul gunë rall tratë con lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Si talë rac shtúꞌul lë́ꞌësë narac shtuꞌu lë́ꞌël, ¿pë premi gápël? purquë ra mënë mal rac shtuꞌu rall el quë narac shtuꞌu lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Si talë runë të bien lë́ꞌësë narunë bien con lëꞌë të, ¿chu guëneꞌe premi cáꞌal? purquë ra mënë mal runë rall bien con saꞌ rall. ");
INSERT INTO zacNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Si talë rúnël prështë dumí lë́ꞌësë ra naguëdchigrë́ lëꞌë dumí, ¿chu guëneꞌe premi cáꞌal? Ra mënë mal runë rall prështë dumí; quëbezë rall quilli mënë mizmë cantidá dumí. ");
INSERT INTO zacNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Perë rniaꞌa lu të, gulë guc shtuꞌu ra mënë narunë cuntrë lëꞌë të. Gulë bëꞌnë bien con grë mënë. Gulë bëꞌnë prështë aunquë adë guëdchigrë́diꞌi rall dumí. Si talë quëhunë të ra cusë ni, gapë të premi ruꞌbë nu na të ziquë shini Dios nacabezë gubeꞌe. Pues Dios rac shtúꞌuiꞌ ra mënë mal nu quëhunë më bien con ra mënë nanadë rdë́ꞌëdiꞌi graci lu më. ");
INSERT INTO zacNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gulë bëgaꞌa lduꞌu të ra mënë igual ziquë Shtadë të rgaꞌa ldúꞌiꞌ lëꞌë ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Nu rniaꞌa lu të, adë rúnëdiꞌil juzguë saꞌl purquë gunë më juzguë lë́ꞌël igual ziquë quëhúnël juzguë saꞌl. Adë rúnëdiꞌil condenar mënë, nu Dios gúnëdiꞌi më condenar lë́ꞌël. Gulë bëꞌnë perdunë saꞌ të guëdubinú ldúꞌul nu Dios gunë më perdunë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gulë bëdëꞌë nacaꞌa nabënápëdiꞌi, iurní gunë Dios igual con lëꞌë të. Guëneꞌe më medidë completë hashtë guëquiꞌchi mëhin, hashtë guëniꞌbi mëhin, hashtë guërëꞌtsin, guëneꞌe më caꞌa të. Medidë nardë́ꞌël mizmë medidë gúnël recibir. ");
INSERT INTO zacNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iurní guniꞌi Jesús tubi comparaciuni: ―¿Gu rac guësë́ ciegu stubi ciegu? Guërupë rall ldaguë rall laꞌni guëru. ");
INSERT INTO zacNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tubi narsëꞌdë lu mësë shtë́nëll, nádiꞌill más më ruꞌbë quë mësë shtë́nëll, perë iurë tsalú studi shtë́nëll, iurní gáquëll ziquë mësë shtë́nëll. Gulë guná bien guadë guëluaꞌa lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Pëzielú guëníꞌil lu saꞌl nanú tubi guiꞌlli laꞌni slull nu iurní nanú tubi trunquë laꞌni slul? ");
INSERT INTO zacNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Lla guëníꞌil lu saꞌl: “Amigu, bëneꞌe sí guëdchisúa guiꞌlli nananú laꞌni slul”? Perë lë́ꞌël rnádiꞌil trunquë laꞌni slul. Lë́ꞌël nal falsë; gulú primërë trunquë nananú laꞌni slul, iurní gac guënal bien parë cul guiꞌlli laꞌni slu saꞌl. ");
INSERT INTO zacNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Guaglaꞌguë guniꞌi Jesús: ―Nanë́ mieti hiaguë zaꞌquë rnéꞌediꞌin nashi mal, nu hiaguë mal rnéꞌediꞌin nashi zaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ra nashi naquë́ lu hiaguë rluaꞌa pë clasë hiaguë nahin. Adë tsagllíꞌidiꞌi ra mënë nashi higu lu hiaguë guitsë nu adë guësiétëdiꞌi ra mënë uvë lu hiaguë guitsë. ");
INSERT INTO zacNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tubi më zaꞌquë ruadiꞌdzë cusë zaꞌquë purquë nabënë na lduꞌu mënë ni. Perë tubi mënë mal ruadíꞌdzëll cusë nadë rlluíꞌidiꞌi purquë lë́ꞌësë mal nanú laꞌni ldúꞌull. Lo quë nananú laꞌni lduꞌu mënë ruadiꞌdzë rall. ");
INSERT INTO zacNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Guaglaꞌguë guniꞌi Jesús lu ra mënë: ―Rniꞌi të nahia el quë narnibëꞌa lëꞌë të ziquë shtadë të perë rúnëdiꞌi të cumplir shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Iurní guëniaꞌa lu të lla na el quë naguidë rini shtiꞌdza nu rúnëll cumplir shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nall ziquë tubi nguiu narzaꞌa tubi hiuꞌu. Gudánill guetë catë naguëdchi guiuꞌu. Bëzáꞌall hiuꞌu lu cimientë shtë guëꞌë. Iurë lëꞌë nisë guaruꞌbë nu bëdëꞌë nisë hashtë guëaꞌ hiuꞌu, perë ni adë bëníꞌbidiꞌi hiuꞌu purquë zubë hiuꞌu lu guëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Perë el quë narini shtiꞌdza perë rúnëdiꞌill cuendë, na ziquë tubi nguiu narzaꞌa tubi hiuꞌu lu iuꞌlli perë nídiꞌi cimientë shtë hiuꞌu. Iurë guaruꞌbë nisë nu bëdëꞌë nisë hashtë guëaꞌ hiuꞌu, gurëhin lueguë. Completamente gualúhin sin ni tubi adë bë bëáꞌnëdiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iurní gualú biadiꞌdzë më lu ra mënë, bëabrí më Capernaum. ");
INSERT INTO zacNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ndë guquëreldë tubi capitán më rumanë narnibëꞌa tubi gahiuꞌa suldadë. Nápëll tubi muzë narac lluꞌu hashtë hia rlullë muzë. Lëꞌë më rumanë nalë́ rac shtúꞌull muzë shtë́nëll. ");
INSERT INTO zacNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Iurë bini capitán lo quë nabëꞌnë Jesús, bëshéꞌldëll bëldá më gushë israelitë parë tsaglliꞌi rall lëꞌë Jesús; guidë më nu gunë më rumëdi muzë narac lluꞌu. ");
INSERT INTO zacNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ra më gushë bëdchini rall catë nanú Jesús nu guaglaꞌguë bëꞌnë rall ruëguë lu më. Guniꞌi rall: ―El quë nabësheꞌldë lëꞌë naꞌa lul, runë tucarë gúnël favurë narac shtúꞌull. ");
INSERT INTO zacNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Rac shtúꞌull ra më israelitë; bëzáꞌall con dumí shtë́nëll iáduꞌu shtënë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Guanú Jesús lëꞌë rall lidchi capitán. Iurë hia ziagdchini rall hiuꞌu shtë capitán, bësheꞌldë capitán bëldá amigu shtë́nëll. Guniꞌi rall lu Jesús shtiꞌdzë capitán: ―Dadë, tsutë́diꞌil lidcha purquë më ruꞌbë nal. Na adë chu nádiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Adë rúnëdiꞌi tucara guëniaꞌa lul, por ni bësheꞌlda guidë guëlliꞌi ra mënë lë́ꞌël. Rialdí lduaꞌa sulamëntë guëníꞌil tubi diꞌdzë, guëac shmuza. ");
INSERT INTO zacNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Na runa lo quë narniꞌi ra narnibëꞌa na. Nu napa suldadë narunë narnibë́ꞌahia. Iurë guepia lu túbill, tsall; rzuꞌbë diáguëll shtiꞌdza. Nu iurë guëniaꞌa lu stúbill, guídëll; lueguë rzuꞌbë diáguëll shtiꞌdza. Iurë guënibë́ꞌahia lu muzë gúnëll dchiꞌni, lueguë rzuꞌbë diáguëll shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iurë bini Jesús shtiꞌdzë capitán, guasë́ lduꞌu më tantë gualdí lduꞌu capitán. Bëdchigrë́ lu më; gubiꞌa më lu mënë nazianaldë lëꞌë më; guniꞌi më lu rall: ―Guldía, ni tubi israelitë adë rialdídiꞌi lduꞌu rall na cumë ziquë rialdí lduꞌu capitán rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Iurë bëabrí ra amigu shtë capitán lídchill, guná rall lu muzë. Hia lëꞌë muzë bëac. ");
INSERT INTO zacNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Iurní Jesús ziaꞌa parë guëꞌdchi nalë́ Naín. Ra shini gusëꞌdë më con zihani mënë, bëꞌnë raiꞌ compañi lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iurë ziagdchini raiꞌ cerquë ruaꞌ guëꞌdchi, bëdzaꞌguëlú raiꞌ ra mënë naziacaꞌchi tubi tëgulë. Tëgulë ni na tubsë shini lu shníꞌaiꞌ, nu shníꞌaiꞌ náhiꞌ viudë. Zihani mënë shtë guëꞌdchi, bëꞌnë rall compañi parë ziacaꞌchi rall tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Guná Jesús lu viudë. Bëgaꞌa lduꞌu më lë́ꞌëll; guniꞌi më lull: ―Adë rúꞌnëdiꞌil. ");
INSERT INTO zacNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Iurní Jesús guabiꞌguë nu bëdchiꞌbë guiaꞌa më guëc cajón. Hia nanuaꞌa lëꞌë tëgulë guzudchí. Jesús guniꞌi lu tëgulë: ―Lë́ꞌël, na rniaꞌa lul, guashtë́ ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Lueguë lëꞌë tëgulë guashtë́ nu guzubë ldill. Guzublú ruadíꞌdzëll. Iurní Jesús bëdëꞌë lëꞌë nguiu ni lu shniꞌa nguiu. ");
INSERT INTO zacNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Grë mënë guná gubani nguiu ni; bëdzëguëëꞌ lduꞌu rall. Guzublú guniꞌi rall: ―Llëruꞌbë na pudërë shtë Dios. Hia bëdchini tubi më ruꞌbë naruadiꞌdzë shtiꞌdzë Dios entrë lëꞌë hiaꞌa. Nu guniꞌi rall: ―Bëagná lduꞌu Dios shtiꞌdzë më; bidë guëdchini më con lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Por guëdubi nezë nu hashtë grë lugar shtë Judea, guniꞌi ra mënë lu saꞌ rall bëldishtë́ Jesús tubi tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bini Juan lo quë nabëꞌnë Jesús purquë ra nazianaldë lëꞌë Juan biadiꞌdzë rall lu Juan. Iurní gunaꞌbë Juan chupë shmë́niꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Bësheꞌldë Juan lëꞌë raiꞌ lu Dadë Jesús parë tsagnaꞌbë diꞌdzë raiꞌ si talë lëꞌë më na el quë nanapë quë guëdchini, lë Cristo, u cuezë mënë stubi më naguëdchini. ");
INSERT INTO zacNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bëdchini raiꞌ catë nanú Jesús. Guniꞌi raiꞌ lu më: ―Juan Bautista bësheꞌldë lëꞌë naꞌa parë guënaꞌbë diꞌdzë naꞌa, ¿pë lë́ꞌël nal el quë nanapë quë guëdchini, Cristo, u guëbezë naꞌa stúbiꞌ? ");
INSERT INTO zacNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mizmë iurë nabëdchini ra shmënë Juan, bënëac Jesús zihani mënë narac lluꞌu de grë clasë galguidzë nu guëëꞌdzu. Bëgú më mëdzabë nananú laꞌni lduꞌu mënë. Bënëac më zihani ciegu. ");
INSERT INTO zacNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Iurní guniꞌi Jesús lu shmënë Juan: ―Gulë tsagniꞌi lu Juan lo quë naguná të nu lo quë nabini të. Gulë guniꞌi lúhiꞌ con pudërë shtëna bëac ra ciegu. Ra cujë bëac zaꞌquë guëaꞌ rall. Ra narac lluꞌu galguidzë naruꞌdzë ládiꞌ, bëac rall. Ra naná cueꞌtë bëac diaguë rall. Ra tëgulë gubani rall con pudërë shtëna. Ra mënë prubi rini rall dizaꞌquë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Rquitë lduꞌu ra mënë, el quë natsaglaꞌguë tsaldí lduꞌi shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Iurë ra shmënë Juan ziaꞌa, Jesús guzublú guníꞌiꞌ lu ra mënë shcuendë Juan: ―¿Chu guagbiꞌa të lúhiꞌ ruaꞌ guëëꞌgu Jordán? ¿Pë guná të tubi nguiu fuertë u tubi nguiu ziquë guiꞌlli narniꞌbi mbë? ");
INSERT INTO zacNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Chu guagbiꞌa të lúhiꞌ? Adë gunádiꞌi të tubi nguiu nanacu con lari zaꞌquë. Bien nanë́ të ra nanacu lari chulë, ra nabani con galëlujë, quëreldë rall lidchi ra rëy. ");
INSERT INTO zacNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Lla na nguiu naguagbiꞌa të lúhiꞌ? ¿Gu náhiꞌ ziquë tubi nabiadiꞌdzë shtiꞌdzë Dios guahietë? Rniaꞌa lu të Juan napë más llëruꞌbë dchiꞌni quë ra mënë naquëreldë guahietë. ");
INSERT INTO zacNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ra Sagradas Escrituras rniꞌi shcuendë Juan: Rsheꞌlda el quë narniꞌi por na delantë lul parë gúniꞌ preparar nezë delantë lul. ");
INSERT INTO zacNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Rniaꞌa lu të entrë grë ra mënë nabiadiꞌdzë shtiꞌdzë Dios lu ra mënë shtë guë́ꞌdchiliu, ni tubi rall na rall más më naruꞌbë quë Juan Bautista. Perë guná, el quë natsutë́ shnezë Dios catë rnibëꞌa më, aunquë nádiꞌi më naruꞌbë, nápëll más dchiꞌni llëruꞌbë quë Juan. ");
INSERT INTO zacNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ra mënë nabëchuꞌbë nisë Juan nu ra narunë cubrë impuestë nabëchuꞌbë nisë Juan, iurë bini rall shtiꞌdzë Juan, guniꞌi rall bënë nu justë na Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Perë ra më religiusë fariseo nu ra mësë narluaꞌa lëy, gunë́diꞌi rall niachuꞌbë nisë Juan lëꞌë rall. Bëquë́ guiaꞌa rall voluntá shtë Dios parë mizmë lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesús guniꞌi lu rall: ―Rniaꞌa lu të, ¿lla na ra mënë shtë tiempë neꞌ? ");
INSERT INTO zacNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Na rall ziquë llguëꞌnë. Rzubë llguëꞌnë; rguitë rall lu llguëaꞌ. Rushtiá rall lu saꞌ rall; rniꞌi rall: “Bëdiꞌldi naꞌa musiquë shtë saꞌa perë adë në́diꞌi të guëguiꞌi të. Bëdiꞌldi naꞌa marchë shtë tëgulë perë adë bíꞌnidiꞌi të. Ni tubi cusë rëuuꞌdiꞌi lduꞌu të.” ");
INSERT INTO zacNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bidë guëniꞌi Juan lu të. Adë gudáudiꞌi Juan guetështildi nu biiꞌdiꞌiꞌ vini, perë lëꞌë të guniꞌi të nápiꞌ tubi mëdzabë laꞌni ldúꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Iurní bëdchinia, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu; rauha lu laní, nu ruha vini, perë rniꞌi të rau shaꞌta. Rniꞌi të ruha zili vini. Rniꞌi të nahia amigu shtënë ra pecadurë. Amigu shtënë ra narunë cubrë impuestë, rniꞌi të. ");
INSERT INTO zacNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Manërë nacanihunë Dios na ziquë llni; rluaꞌain laꞌni vidë shtë ra naná sabi de verdá. ");
INSERT INTO zacNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tubi fariseo lë Simón bë́ꞌnëll invitar lëꞌë Jesús parë tsa më lídchill të gaunú më lë́ꞌëll. Jesús gua lídchill nu guzubë më lu mellë. ");
INSERT INTO zacNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Iurní bëdchini tubi naꞌa nanapë zihani nguiu. Quëreldë naꞌa lu mizmë guëꞌdchi. Iurë bini naꞌa lëꞌë Jesús ziatáu lidchi fariseo, bëdchininú naꞌa tubi bëtë́i naná guëꞌë; gadzëhin sëiti nashi. ");
INSERT INTO zacNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Bëzullibi naꞌa guëaꞌ Jesús catë cabezë më. Biꞌni naꞌa nu guzublú radzë guëaꞌ më con nisë narruꞌu slu naꞌa. Lueguë bëshá naꞌa guitsë guëc naꞌa guëaꞌ më parë guëbidchi guëaꞌ më. ");
INSERT INTO zacNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Iurë guná Simón lo quë nabëꞌnë naꞌa, bë́ꞌnëll llgabë: “Si talë lëꞌë nguiu nabëna invitar lidcha, na tubi naruadiꞌdzë shtiꞌdzë Dios, niadë́ꞌëiꞌ cuendë pë clasë naꞌa na el quë nabëdchini lúhiꞌ. Nall tubi naꞌa nanapë zihani duldë.” ");
INSERT INTO zacNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iurní guniꞌi Jesús lu Simón: ―Moni, rac shtuaꞌa guëniaꞌa lul. Guniꞌi Simón: ―Mësë, ¿pë rac shtúꞌul guëníꞌil lua? ");
INSERT INTO zacNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús guniꞌi: ―Guc chupë nguiu nazéꞌbi dumí lu nargudini. Túbill nazeꞌbi gaꞌi gahiuꞌa bëllë bëdchichi. Stúbill nazeꞌbi cincuenta bëllë bëdchichi. ");
INSERT INTO zacNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Perë ni tubi de lëꞌë rall nápëdiꞌi rall dumí parë quilli rall. Lëꞌë nargudini bë́ꞌnëll perdunë guërupë rall. ’Gunaꞌbë diꞌdza lul, Moni, ¿guadë de lëꞌë rall rac shtuꞌu más lëꞌë nargudini dumí? ");
INSERT INTO zacNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón bëquebi: ―Lluáꞌahia el quë narzeꞌbi más llëruꞌbë dumí rac shtúꞌull más lëꞌë nargudini dumí. Guniꞌi Jesús iurní: ―Guldil, zni nahin. ");
INSERT INTO zacNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Iurní lëꞌë Jesús guná lu naꞌa nu guniꞌi më lu Simón: ―Hia gunal lla bëꞌnë naꞌa rëꞌ. Gutë́a lídchil. Bënéꞌediꞌil nisë parë tsati guëahia ziquë na custumbrë, perë lëꞌë naꞌa rëꞌ bëgaꞌdzë guëahia con nisë narruꞌu slúhi. Nu bëcuë́ꞌdchill guëahia con guitsë guë́quëll. ");
INSERT INTO zacNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Adë bëtsagruaꞌdíꞌil guiahia ziquë na custumbrë, perë naꞌa rëꞌ dizdë iurë bëdchinia, adë rbézëdiꞌi rtsagruaꞌ naꞌa guëahia. ");
INSERT INTO zacNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nu adë bëtiáꞌadiꞌil sëiti nashi guëca, perë naꞌa rëꞌ bëtiáꞌall sëiti nashi guëahia. ");
INSERT INTO zacNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Rniaꞌa lul de quë duldë zihani shtë́nëll naperdunë; por ni nalë́ rac shtúꞌull na. Perë el quë naguc perdunë duꞌpë, duꞌpsë rac shtúꞌull na. ");
INSERT INTO zacNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Iurní guniꞌi Jesús lu naꞌa: ―Duldë nabë́ꞌnël hia bëna perdunë. ");
INSERT INTO zacNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ra invitadë nazúbëgaꞌa con Jesús, guzublú rniꞌi lu saꞌ rall: ―¿Chu rníꞌill nall? Rníꞌill nápëll pudërë gúnëll perdunë duldë shtë mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Perë Jesús guniꞌi lu naꞌa: ―Hia nasalvárël purquë gualdí ldúꞌul na. Bëagzë́ con bien. ");
INSERT INTO zacNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Despuësë de ni, lëꞌë Jesús ziaꞌa zihani guëꞌdchi nu ranchi parë guadiꞌdzë më dizaꞌquë shtë Dios lla tsutë́ mënë shnezë Dios. Ra chiꞌbë chupë poshtë guanaldë raiꞌ lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nu ra naꞌa zianaldë rall Jesús; antsë bënëac Jesús lëꞌë rall narac lluꞌu. Gulú më mëdzabë laꞌni lduꞌu ra nanapë mëdzabë. Entrë lëꞌë rall zianaldë María Magdalena nabëruꞌu gadchi mëdzabë laꞌni ldúꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nu zianaldë Juana, tseꞌlë Chuza naná encargadë gapë lidchi Herodes. Nu zianaldë Susana con zihániruꞌu naꞌa nabëdëꞌë dumí shtë rall parë el quë narquiꞌni Jesús nu ra shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bëdëá zihani mënë lu Jesús. Bëdchini ra mënë de grë ladë. Guniꞌi më tubi comparaciuni lu rall: ");
INSERT INTO zacNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Tubi nguiu guagtëꞌtsë bëꞌdchi lachi. Duꞌpë bëꞌdchi gulaguë lu nezë. Ngaꞌli bëlú mënë guëquin. Iurní bëdchini ra maꞌñi; gudáu maꞌñi bëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Stubi tantë bëꞌdchi gulaguë lu guiuꞌu guëꞌë. Iurë lëꞌë bëꞌdchi gutsëlú, lueguë gubidchi plantë purquë duꞌpë shcupë nanú. ");
INSERT INTO zacNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Stubi tantë bëꞌdchi gulaguë ladi guiꞌlli guitsë. Gualdani bëꞌdchi perë guni guiꞌlli guitsë guëquin. ");
INSERT INTO zacNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Perë stubi partë bëꞌdchi gulaguë lu guiuꞌu zaꞌquë. Gualdanin. Guaruꞌbin nu bëdëꞌëin cusechë hashtë tubi gahiuꞌa por tubin. Iurní Jesús guniꞌi fuertë: ―Si talë rac shtúꞌul tsasël, gulë bëquë́ diaguë bien shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Iurní ra shini gusëꞌdë më gunaꞌbë diꞌdzë raiꞌ pë runë cuntienë comparaciuni rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Guniꞌi më: ―Rniaꞌa lu të, Dios bëꞌnë favurë parë tsasë́ të lla rnibëꞌa më ziquë Rëy. Antsë guasë́diꞌi mënë ra cusë ni. Ra mënë nanë́diꞌi tsasë́ shtiꞌdza, na rniaꞌa lu rall con comparaciuni të rna rall perë adë riasë́diꞌi rall. Rini rall perë adë rdë́ꞌëdiꞌi rall cuendë pë runë cuntienë ra comparaciuni. ");
INSERT INTO zacNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Guëniaꞌa lu të pë runë cuntienë comparaciuni nartëꞌtsë bëꞌdchi. Ra bëꞌdchi na ziquë shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tubi tantë bëꞌdchi nagulaguë lu nezë, na ziquë ra mënë narini shtiꞌdzë Dios perë ridë mëdzabë, rdchisull shtiꞌdzë Dios lduꞌu ra mënë parë adë tsaldídiꞌi lduꞌu mënë parë gáquëdiꞌi salvar rall. ");
INSERT INTO zacNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ra bëꞌdchi nagulaguë ladi guëꞌë, na ziquë ra mënë narini shtiꞌdzë Dios nu rcaꞌa rallin con gustë. Ziquë plantë nanapë duꞌpë luꞌchi rialdí lduꞌu rall por duꞌpë tiempë, perë iurë ridë tubi prëbë, rniꞌi guidzë mënë guëc rall, iurní rsaꞌnë rall shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ra bëꞌdchi nagulaguë laꞌni guiꞌlli guitsë, na ziquë ra mënë narini shtiꞌdzë Dios nu rianaldë rall nezë shtë më, perë por tantë llgabë shtë dchiꞌni, lla guëbani rall, nu rzebi lduꞌu rall gapë rall zihani dumí, nu por mal deseo nananú laꞌni lduꞌu rall, hia iurní rteꞌein shtiꞌdzë Dios laꞌni lduꞌu rall. Iurní na rall ziquë tubi plantë nadë rnéꞌediꞌi nashi. ");
INSERT INTO zacNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Perë bëꞌdchi nagulaguë lu guiuꞌu zaꞌquë, na ziquë mënë narini shtiꞌdzë Dios. Con guëdubinú lduꞌu rall rialdí lduꞌu rall. Rdëꞌë rall cuendë shtiꞌdzë më. Na rall më pacënci. Na rall ziquë tubi plantë nariaglaꞌguë rdëꞌë nashi zaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Ni tubi mënë guësëuꞌldë llni laꞌni lintërnë nu lueguë guëtáꞌull con tubi tëpë u guëzullin guëaꞌ camë, sino quë guiaꞌa zubin parë el quë natsutë́ laꞌni hiuꞌu guëzianí. ");
INSERT INTO zacNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Grë lo quë nagaꞌchi lu ra mënë iurneꞌ, napë quë guëruꞌu lu llni parë tsasë́ mieti. ");
INSERT INTO zacNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Si talë guëquë́ diaguë të bien, guëneꞌe Dios más llni; perë si talë rúnëdiꞌil cuendë shtiꞌdza, guëdchisú më llni narníꞌil nápël. ");
INSERT INTO zacNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iurní lëꞌë shniꞌa Jesús con bë́chiꞌ, bëdchini raiꞌ catë cabezë më, perë gúquëdiꞌi niabiꞌguë raiꞌ lu më por tantë zihani mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tubi mënë guanú rsunë lu Jesús. Guníꞌill: ―Lëꞌë shníꞌal nu ra bë́chil zugaꞌa tëchi fuërë. Rac shtuꞌu guadiꞌdzënú raiꞌ lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Perë Jesús repi: ―Ra narquë́ diaguë shtiꞌdzë Dios nu runë rall cumplir narniꞌi më, ni na ra shníꞌahia, ni na ra bëcha. ");
INSERT INTO zacNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tubi dzë guatë́ Jesús laꞌni barcu con ra shini gusëꞌdë më nu guniꞌi më lu raiꞌ: ―Cha guia hiaꞌa stubi ladë ruaꞌ nisë. Iurní ziaꞌa raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mientras ziazú raiꞌ lu nisë, Jesús gutëgaꞌsi. Iurní bëdchini tubi mbë dushë lu nisë. Guatë́ nisë laꞌni barcu hashtë mërë në́ꞌazë barcu laꞌni nisë. ");
INSERT INTO zacNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Lueguë guacuaꞌñi raiꞌ lëꞌë Jesús nu guniꞌi raiꞌ: ―Mësë, Mësë, aquë zati hiaꞌa iurneꞌ. Iurní Jesús guashtë́. Gunibë́ꞌaiꞌ lu mbë nu nisë parë cuedchí nisë. Iurní lueguë gurëdchí nisë. ");
INSERT INTO zacNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Iurní guniꞌi Jesús lu ra shini gusëꞌdë më: ―¿Pë hia adë rialdídiꞌi lduꞌu të Dios? Iurní bëdzëbë raiꞌ nu bëdzëguëëꞌ lduꞌu raiꞌ. Guniꞌi lu saꞌ raiꞌ: ―¿Chull më rëꞌ? tantë pudërë nápiꞌ. Rzuꞌbë diaguë mbë nu nisë shtíꞌdziꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bëdchini raiꞌ stubi ladë nisë ruꞌbë, ladzë ra më gadareno. Galilea naquë́ stubi ladë ruaꞌ nisë ruꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bëdchini raiꞌ ruaꞌ guiuꞌu. Bëruꞌu më laꞌni barcu. Lueguë guabiꞌguë tubi nguiu shtë guëꞌdchi gadareno lu Jesús. Por zihani izë rácudiꞌill lari nu adë nídiꞌi lídchill sino quë guquëréldëll laꞌni cuevë catë rgaꞌchi ra tëgulë. Nguiu ni napë zihani mëdzabë fier laꞌni ldúꞌull. ");
INSERT INTO zacNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Iurë guall lu Jesús, bëzullíbill lu më. Gurushtiall. Guníꞌill fuertë lu Jesús: ―¿Pë nápël con na? Jesús. Lë́ꞌël nal shini Dios nacabezë gubeꞌe. Runa ruëguë lul adë guëtiaꞌadiꞌil na lu guiꞌi shtë cashtigu. ");
INSERT INTO zacNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Zni guníꞌill purquë más antsë Jesús gunibëꞌa lëꞌë ra mëdzabë fier parë guëruꞌu rall de lëꞌë nguiu. Vidë shtë nguiu ni guc zndëꞌë; zihani vueltë lëꞌë mëdzabë gunaꞌzi lëꞌë nguiu ni. Lëꞌë ra mënë bëldiꞌbi guiáꞌall nu guëaꞌll con cadënë parë gac segurë nguiu ni, perë lë́ꞌëll bëchúguëll cadënë. Lëꞌë mëdzabë bësëlluꞌnë lë́ꞌëll tubi lugar catë nídiꞌi mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús gunaꞌbë diꞌdzë lull: ―¿Chu lël? Lë́ꞌëll bëquebi: ―Lëhia Chupe Mili. Zihani na naꞌa. Zni guníꞌill purquë zihani mëdzabë gutë́ laꞌni ldúꞌull. ");
INSERT INTO zacNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ra mëdzabë bëꞌnë ruëguë lu më parë adë guënibë́ꞌadiꞌi më lëꞌë rall tsa rall gabildi. ");
INSERT INTO zacNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tiempë ni nanú zihani guchi lu lumë shtë dani. Quëháu ra ma. Lëꞌë ra mëdzabë bëꞌnë ruëguë lu Jesús tsa rall laꞌni lduꞌu ra guchi. Bëdëꞌë më permisi. ");
INSERT INTO zacNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Iurní bëruꞌu ra mëdzabë laꞌni lduꞌu nguiu. Bëuꞌ rall laꞌni lduꞌu guchi. Iurní bëlluꞌnë ra ma catë naquë́ tubi nisë ruꞌbë. Guzutuꞌu ra ma hashtë guetë laꞌni nisë. Ngaꞌli gualú ra ma. ");
INSERT INTO zacNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ra narapë guchi iurë guná rall pë guc, guaglluꞌnë rall hashtë guëꞌdchi. Biadiꞌdzë rall lu ra mënë naquëreldë guëꞌdchi nu lu ra më nananú lachi pë guc con ra guchi. ");
INSERT INTO zacNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ra mënë guagbiꞌa rall niaꞌa pë guc. Nu bëdchini rall catë nanú Jesús. Guná rall lu nguiu nananú mëdzabë laꞌni ldúꞌiꞌ. Zúbëll culaꞌni Jesús. Nácull lari nu beꞌrquë ruadíꞌdzëll. Bëac zaꞌquë shgábëll. Ra mënë bëdzëguëëꞌ lduꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Grë naguná nabëꞌnë Jesús, biadiꞌdzë rall lla bëꞌnë më parë bëac nguiu nanapë mëdzabë laꞌni ldúꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Iurní grë ra më gadareno, bëꞌnë rall ruëguë lu më parë guëruꞌu më ladzë rall tantë bëdzëbë rall. Iurní Jesús güeꞌpi laꞌni barcu parë ziáꞌaiꞌ stubi ladë. ");
INSERT INTO zacNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Lëꞌë nguiu nabëruꞌu mëdzabë laꞌni ldúꞌiꞌ, bë́ꞌnëll ruëguë lu Jesús parë guëdëꞌë më permisi tsanáldëll lëꞌë më. Perë Jesús gunibëꞌa guëáꞌnëll ládzëll. Guniꞌi më: ");
INSERT INTO zacNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Bëabrí lídchil nu biadiꞌdzë grë lo quë nabëꞌnë Dios con lë́ꞌël. Bëagzëll nu biadíꞌdzëll por guëdubi nezë nu guëꞌdchi lo quë nabëꞌnë Jesús con lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bëabrí më stubi ladë ruaꞌ nisë ruꞌbë. Ra mënë quëbezë lëꞌë më nu bëꞌnë rall recibir lëꞌë më. Rquitë lduꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Iurní bëdchini tubi nguiu lë Jairo. Nall tubi jëfë shtë iáduꞌu. Bëzullíbill lu Jesús. Bë́ꞌnëll ruëguë tsa më lídchill ");
INSERT INTO zacNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","purquë Jairo nápëll tubsë shtsáꞌpëll. Napë ntsaꞌpë chiꞌbë chupë izë. Hia rlúllëll. Iurë lëꞌë Jesús ziaꞌa, mënë zihani guanaldë rall lëꞌë më hashtë rteꞌe mënë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nu guanaldë tubi naꞌa con los de más mënë; rllëꞌë rë́nëll. Hia guc chiꞌbë chupë izë rac llúꞌull. Ni chu bë́ꞌnëdiꞌi gan nëáquëll. ");
INSERT INTO zacNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Iurní guabiꞌguë naꞌa nezë tëchi më. Bëgáꞌldëll ruaꞌ shabë më. Lueguë gulezë rënë nu bëáquëll. ");
INSERT INTO zacNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iurní Jesús guniꞌi: ―¿Chu bëgaꞌldë shaba? Grë mënë guniꞌi: ―Ni túbidiꞌi. Iurní guniꞌi Pedro: ―Mësë, ra mënë zihani quëgteꞌe rall lë́ꞌël, nu cagsini rall lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Perë Jesús guniꞌi: ―Entrë de lëꞌë të nanú tubi nabëgaꞌldë shaba, purquë guc bë́ꞌahia tubi mënë bëáquëll con pudërë shtëna. ");
INSERT INTO zacNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Lëꞌë naꞌa guc bë́ꞌall adë nídiꞌi mudë gaquin nagaꞌchi. Iurní bëdchínill nu rchíꞌchill nu bëzullíbill lu më. Guníꞌill delantë lu grë mënë pëzielú bëgáꞌldëll shabë më. Guníꞌill lueguë bëáquëll. ");
INSERT INTO zacNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iurní Jesús guniꞌi lull: ―Nanë, bëáquël purquë rialdí ldúꞌul na. Bëagzë́ con bien. ");
INSERT INTO zacNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nianá quëadiꞌdzë Jesús, bëdchini tubi mënë nabëruꞌu lidchi Jairo. Guníꞌill lu Jairo: ―Hia lëꞌë shtsáꞌpël gualú guti. Adë rsiúꞌbëdiꞌil más lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iurë bini Jesús pë guniꞌi nguiu ni, guniꞌi më lu Jairo: ―Adë rdzë́bëdiꞌil. Guaglaꞌguë tsaldí ldúꞌul na. Lëꞌë shtsáꞌpël guëáquëll. ");
INSERT INTO zacNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Iurë guatë́ Jesús lidchi Jairo, gunë́diꞌi më chu niutë́ catë nagaꞌa tëgulë; sulë Pedro nu Juan con shtadë nu shniꞌa ntsaꞌpë guanú më. ");
INSERT INTO zacNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Grë mënë biꞌni nu bëꞌnë rall ruidë por lëꞌë tëgulë. Perë Jesús guniꞌi lu rall: ―Adë rúꞌnëdiꞌi të. Gútidiꞌi ntsaꞌpë sino nagaꞌsi niꞌi. ");
INSERT INTO zacNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bëꞌnë rall burnë nu rllidchinú rall lëꞌë Jesús purquë hia rac bëꞌa rall tëgulë na ntsaꞌpë. ");
INSERT INTO zacNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Iurní Jesús gunaꞌzi guiaꞌa tëgulë. Guniꞌi më fuertë: ―Ntsaꞌpë, guashtë́ ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Iurní lueguë bëabrí gubani tëgulë. Guashtë́ ntsaꞌpë lueguë. Gunibëꞌa Jesús të guëdëꞌë rall nagáu ntsaꞌpë. ");
INSERT INTO zacNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ra shtadë niꞌi guasë́ lduꞌu rall. Perë Jesús gunibëꞌa ni tubi chu lu guadíꞌdzëdiꞌi rall lo quë naguc. ");
INSERT INTO zacNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Bëtëá Jesús lëꞌë chiꞌbë chupë shini gusëꞌdë më nu bëdëꞌë më pudërë parë guënibëꞌa raiꞌ grë mëdzabë; guëlú raiꞌ mëdzabë laꞌni lduꞌu mënë nu gunëac raiꞌ narac lluꞌu. ");
INSERT INTO zacNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bësheꞌldë më lëꞌë raiꞌ parë guëniꞌi raiꞌ lu mënë bëgaꞌa iurë parë guënibëꞌa Dios lëꞌë rall, nu guniꞌi më gunëac raiꞌ grë clasë galguidzë. ");
INSERT INTO zacNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Guniꞌi më: ―Adë pë guáꞌadiꞌi të parë nezë, ni tubi bastunë ni panitë parë quë dumí, ni guetështildi guáꞌadiꞌi të. Gulë biaꞌa tubsë manguë gacu të cadë tubi de lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Cualquier lidchi mënë ca guëdchini të, gulë bëaꞌnë ngaꞌli hashtë guziaꞌa të stubi guëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Si talë ca në́diꞌi mënë gunë recibir lëꞌë të, gulë bëruꞌu guëꞌdchi ni. Iurní guëdchibë të gushëguiuꞌu guëaꞌ të cumë ziquë tubi sëñi de quë adë gualdídiꞌi lduꞌu rall dizaꞌquë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bëruꞌu raiꞌ. Gua raiꞌ por guëdubi nezë shtë ra guëꞌdchi. Biadiꞌdzë raiꞌ dizaꞌquë shtë Dios. Bënëac raiꞌ narac lluꞌu. ");
INSERT INTO zacNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Lëꞌë gubernadurë Herodes bini grë lo quë nabëꞌnë Jesús. Bë́ꞌnëll tantë llgabë perë adë bëdë́ꞌëdiꞌill cuendë chu na Jesús. Bëldá mënë guniꞌi Jesús na Juan Bautista naguashtë́ ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Stubi rall guniꞌi Jesús na tëgulë Elías nagubani stubi. Sëbëldá mënë guniꞌi Jesús na tubi nabeꞌdë guëniꞌi shtiꞌdzë Dios más guahietë perë guashtë́hiꞌ ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes guniꞌi: ―Lëdë lë́ꞌëdiꞌi Juan ndë purquë na gunibë́ꞌahia guagchuguë ra suldadë guëc Juan. Gútiꞌ. ¿Perë chu na nguiu rëꞌ? Binia zihani cusë ruꞌbë nabë́ꞌnëll. Herodes guc shtuꞌu guënall lu Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iurë bëabrí ra poshtë, biadiꞌdzë raiꞌ lu Jesús lo quë nabëꞌnë raiꞌ. Biaꞌa më lëꞌë raiꞌ tubi lugar catë nídiꞌi mënë cerquë ruaꞌ guëꞌdchi Betsaida. ");
INSERT INTO zacNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Perë iurë bini ra mënë cabezë më lugar ni, guanaldë rall lëꞌë më. Nu Jesús bëꞌnë recibir lëꞌë rall con gustë. Biadiꞌdzë më lu rall lla gac salvar rall, nu bënëac më narac lluꞌu. ");
INSERT INTO zacNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bëgaꞌa iurë gunaꞌzi guadzeꞌ, iurní bëdchini ra poshtë lu më. Guniꞌi raiꞌ: ―Gunibëꞌa lu ra mënë tsa rall guëꞌdchi lugar catë nanú mënë. Gau rall nu tsa rall descansë purquë ni tubi mënë quëréldëdiꞌiꞌ ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús guniꞌi iurní: ―Gulë bëdëꞌë nagáu rall. Lëꞌë ra shini gusëꞌdë më bëquebi raiꞌ: ―Nápaꞌa gáꞌisë guetështildi con chupë mbeldë. ¿Ca lu tsasiꞌi naꞌa guetështildi gau ra mënë rëꞌ? ");
INSERT INTO zacNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nanú más de gaꞌi mili nguiu nazugaꞌa. Jesús guniꞌi lu ra shini gusëꞌdë më: ―Gulë guniꞌi lu ra mënë të subë mënë cadë grupë masiá de cincuenta mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Zni bëꞌnë raiꞌ. Guzubë grë ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iurní Jesús gunaꞌzi gaꞌi guetështildi con chupë mbeldë. Guná më lu gubeꞌe. Bëdëꞌë më graci lu Dios. Bëshullë më guetështildi nu belë mbeldë. Bëdë́ꞌëiꞌ guetështildi cuaꞌa ra poshtë. Lëꞌë raiꞌ guatiꞌdzë raiꞌ guetështildi cuaꞌa ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Grë rall gudáu rall hashtë ca lu bielë rall. Iurní ra shini gusëꞌdë më bëtsadzë́ chiꞌbë chupë tëpë ra pedasë nabëꞌnë subrë. ");
INSERT INTO zacNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tubi dzë gua Jesús lë́ꞌësë më tubi lugar. Quëadiꞌdzënú më Dios. Iurní bëdchini ra shini gusëꞌdë më lu më. Gunaꞌbë diꞌdzë Jesús lu raiꞌ: ―¿Chu rniꞌi ra mënë nahia? ");
INSERT INTO zacNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Lëꞌë raiꞌ bëquebi raiꞌ: ―Bëldá ra mënë rniꞌi nal Juan Bautista. Sëbëldá mënë rniꞌi nal Elías. Sëbëldá mënë rniꞌi nal tubi nabiadiꞌdzë shtiꞌdzë Dios más guahietë. Rniꞌi rall guashtël ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iurní Jesús guniꞌi lu raiꞌ: ―Lëꞌë të, ¿chu rniꞌi të nahia? Pedro guniꞌi: ―Nal Cristo, el quë nagudili Dios parë guënibë́ꞌal. ");
INSERT INTO zacNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús gunibëꞌa ni tubi chu lu guadíꞌdzëdiꞌi raiꞌ na më Cristo. ");
INSERT INTO zacNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Guniꞌi më lu raiꞌ: ―Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. Napë quë guëzac zia. Ra bëshuzi ruꞌbë, ra më gushë shtë iáduꞌu, nu ra mësë shtë lëy, guëquë́ guiaꞌa rall na. Quini rall na perë dzë tsunë despuësë, tsashtë́a ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Iurní guniꞌi më lu grë ra mënë: ―El quë narac shtuꞌu gáquëll shmëna, napë quë gúnëll renunci prupi deseo shtë́nëll. Napë quë gáquëll dispuestë gátill por na. Dzë con dzë napë quë tsanáldëll shneza. ");
INSERT INTO zacNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","El quë narac shtuꞌu gapë vidë shtë́nëll, guënítill, perë el quë naguëniti vidë shtë́nëll purquë nall shmëna, guëbánill parë siemprë. ");
INSERT INTO zacNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Adë pë guëlluiꞌi gunë nguiu gan guëdubi guë́ꞌdchiliu nu despuësë guënítill almë shtë́nëll. ");
INSERT INTO zacNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Si talë chu rtu lúhiꞌ por na nu por shtiꞌdza iurneꞌ, zni na guëtú lua de lë́ꞌëll iurë lëꞌë na guëabría de gubeꞌe. Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu perë guëdchininuhia con ra ianglë. Guëluaꞌa llëruꞌbë llni nu pudërë shtë Dios iurë guëabría. ");
INSERT INTO zacNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Guldía rniaꞌa lu të, nanú mënë entrë lëꞌë të guëná rall rnibëꞌa Dios ziquë rëy; despuësë de ni gati rall. ");
INSERT INTO zacNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Gudëdë shunë dzë; biaꞌa Jesús Pedro nu Jacobo nu Juan. Ziazú raiꞌ lu dani parë guadiꞌdzënú Jesús Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Iurë biadiꞌdzënúhiꞌ Dios, guc cambi lu Jesús delantë lu raiꞌ. Shábiꞌ bëac más naquichi hashtë rabtsëꞌin. ");
INSERT INTO zacNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Iurní guná raiꞌ chupë nguiu nabiadiꞌdzënú Jesús. Lëꞌë raiꞌ náhiꞌ Moisés nu Elías. ");
INSERT INTO zacNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nanú raiꞌ laꞌni tubi shcahi nanapë llni. Quëadiꞌdzë raiꞌ lla gati Jesús nu lla guëzac zi më ciudá Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro, Jacobo, nu Juan nalë́ mbëcaꞌldë gunaꞌzi lëꞌë raiꞌ, perë guná raiꞌ lu llni. Guná raiꞌ lla guc cambi Jesús. Nu guná raiꞌ lu chupë nguiu nazunú Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nianá lëꞌë chupë nguiu bësëaꞌnë raiꞌ Jesús, guniꞌi Pedro lu më: ―Mësë, nabënë dzu hiaꞌa ndëꞌë. Guëzaꞌa naꞌa tsunë ranchi, tubin parë lë́ꞌël guëquëréldël; stubin parë Moisés; stubin parë Elías. Perë Pedro rac bë́ꞌadiꞌi pë guníꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nianá quëadiꞌdzë Pedro, bëdchini tubi shcahi nabësëꞌau grë raiꞌ. Bëdzëbë ra shini gusëꞌdë më iurë lëꞌë Moisés nu Elías nanú laꞌni shcahi. ");
INSERT INTO zacNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Iurní bini raiꞌ tubi bë nabëruꞌu laꞌni shcahi. Guniꞌi bë: ―Ndëꞌë lëꞌë shinia narac shtuaꞌa; gudilia lë́ꞌiꞌ. Gulë bëquë́ diaguë shtíꞌdziꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Despuësë gualú guniꞌi bë, guná raiꞌ lë́ꞌësë Jesús zúgaꞌa. Ra shini gusëꞌdë më adë biadíꞌdzëdiꞌi raiꞌ lu saꞌ raiꞌ por tubi tiempë lo quë naguná raiꞌ guëc dani. ");
INSERT INTO zacNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Brëgueꞌlë stubi dzë bietë raiꞌ lu dani. Iurní zihani mënë bëdchini lu Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ladi ra mënë zeꞌdë tubi nguiu. Guníꞌill fuertë: ―Mësë, bëꞌnë favurë, gudeꞌe guëná shinia, pues tubsë niꞌi napa. ");
INSERT INTO zacNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nanú tubi mëdzabë narguitsuëꞌ lë́ꞌëll. Rdchibi mëdzabë lë́ꞌëll. Rushtiall nu rruꞌu bëchini ruaꞌll. Rzianë mëdzabë lë́ꞌëll nu iurë ziaꞌa mëdzabë, rdzaguë llgaꞌna. ");
INSERT INTO zacNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Hia bëna ruëguë lu ra shini gusë́ꞌdël parë guëgú raiꞌ mëdzabë laꞌni lduꞌu shinia, perë adë bë́ꞌnëdiꞌi raiꞌ gan. ");
INSERT INTO zacNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús guniꞌi lu ra mënë: ―Lëꞌë të mënë nadë rialdídiꞌi lduꞌi na, naguëdchi lduꞌu të. ¿Hashtë guc guëbezënuhia lëꞌë të parë tsaldí lduꞌu të? ¿Blac tiempë guca pacënci con lëꞌë të? Guaglliꞌi shínil ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Iurë guabiꞌguë ngulëꞌnë, lëꞌë mëdzabë bëruꞌldë ngulëꞌnë lu guiuꞌu. Nu bëséꞌsëll ngulëꞌnë, perë Jesús guniꞌi guëc mëdzabë fier, nu bënëac më lëꞌë llguëꞌnë. Iurní Jesús bëdëꞌë ngulëꞌnë guiaꞌa shtádëll. ");
INSERT INTO zacNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Grë ra mënë bëdzëguëëꞌ lduꞌu rall por llëruꞌbë pudërë shtë Dios. Nianá rdzëguëëꞌ lduꞌu ra mënë lo quë nabëꞌnë Jesús, guniꞌi më lu ra shini gusëꞌdë më: ");
INSERT INTO zacNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Gulë bëquë́ diaguë naguëniaꞌa lu të iurneꞌ, nu adë rëáꞌldëdiꞌi lduꞌu të shtiꞌdza. Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu perë gaca intriegu guiaꞌa ra mënë parë quini rall na. ");
INSERT INTO zacNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Perë ra shini gusëꞌdë më adë guc bë́ꞌadiꞌi raiꞌ lo quë naguniꞌi Jesús purquë nagaꞌchi na diꞌdzë ni nu adë guasë́diꞌi raiꞌ pë runë cuntienë diꞌdzë shtë Jesús. Nu bëdzëbë raiꞌ nianaꞌbë diꞌdzë raiꞌ lu Jesús pë runë cuntienë lo quë naguniꞌi më. ");
INSERT INTO zacNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ra shini gusëꞌdë më guzublú quëdildi diꞌdzë raiꞌ chu na más më ruꞌbë entrë lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús bëdëꞌë cuendë pë llgabë quëhunë raiꞌ laꞌni lduꞌu raiꞌ. Iurní bëzú Jesús tubi llguëꞌnë culáꞌniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Guniꞌi më lu raiꞌ: ―El quë naquëhapë tubi llguëꞌnë ziquë ndëꞌë purquë rac shtuꞌu mënë ni na, también na quëhúnëll recibir. Nu mizmë tiempë quëhúnëll recibir el quë nabësheꞌldë na. El quë quëhunë sirvë lu sáhiꞌ entrë lëꞌë të, ni na más më ruꞌbë lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Iurní Juan guniꞌi lu Jesús: ―Mësë, guná naꞌa tubi nguiu; rgull mëdzabë laꞌni lduꞌu mënë. Rníꞌill lël parë guënibë́ꞌall ra mëdzabë. Iurní lëꞌë naꞌa gunibëꞌa naꞌa lull adë guëgúdiꞌill mëdzabë purquë adë rsënúdiꞌill lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Perë Jesús guniꞌi: ―Bëdëꞌë sí, gull mëdzabë laꞌni lduꞌu mënë. Bien quëhúnëll. El quë nadë rníꞌidiꞌi cuntrë lëꞌë hiaꞌa, nall favurë de lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bëdchini tiempë parë tsepi Jesús gubeꞌe. Ziaꞌa më nezë parë Jerusalén. Adë bëdzë́bëdiꞌi më. ");
INSERT INTO zacNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bësheꞌldë më bëldá nguiu parë tsa rall guëꞌdchi Samaria. Guagnaꞌbë raiꞌ pusadë parë guëquëreldë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Perë ra më guëꞌdchi shtë Samaria, adë gunë́diꞌi rall nihunë rall recibir lëꞌë më purquë guc bëꞌa rall ziaꞌa më nezë parë Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iurë Jacobo nu Juan guná raiꞌ në́diꞌi mënë shtë Samaria gunë rall recibir lëꞌë Jesús, guniꞌi raiꞌ lu më: ―Dadë, ¿gu rac shtúꞌul guënibëꞌa naꞌa të guëdchini guiꞌi lu gubeꞌe parë tsequi ra më Samaria ziquë bëꞌnë Elías guahietë? ");
INSERT INTO zacNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Iurní Jesús bëdchigrë́ lúhiꞌ; guníꞌiꞌ guëc raiꞌ: ―Llgabë narunë të nádiꞌi bien. Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu; rac shtúꞌudiaꞌa tsa mënë gabildi sino rac shtuaꞌa gac salvar mieti. ");
INSERT INTO zacNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Iurní ziaꞌa raiꞌ stubi guëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Iurní ziazú raiꞌ tubi nezë, tubi nguiu guniꞌi lu Jesús: ―Dadë, sënalda lë́ꞌël ancalë ca tsal. ");
INSERT INTO zacNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Guniꞌi Jesús lull: ―Ra ma lachi napë catë rgaꞌsi ma. Ra maꞌñi napë bëcheꞌzë shtë ma lu hiaguë. Perë na nápëdiaꞌa lidcha ca rgaꞌsia. Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Iurní Jesús guniꞌi lu stubi nguiu: ―Gudeꞌe naldë na ziquë shmëna. Perë guniꞌi nguiu ni: ―Nia Dadë, perë bëneꞌe permisi despuësë de gati shtada, iurní sënalda lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús repi lull: ―Nanú mënë nadë rialdídiꞌi lduꞌu raiꞌ shtiꞌdza parë guëcaꞌchi rall ra tëgulë. Lë́ꞌël lueguë biadiꞌdzë lu ra mënë lla mudë gac salvar rall. ");
INSERT INTO zacNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Iurní stubi nguiu guniꞌi lu Jesús: ―Dadë, sënalda lë́ꞌël perë runa ruëguë lul, bëneꞌe permisi tsahia lidcha primërë, guna despedir shfamilia. ");
INSERT INTO zacNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús guniꞌi lull: ―El quë naná ziquë naraaꞌnë lachi perë rbíꞌall nezë të́chill, adë rlluíꞌidiꞌill parë tsutëll catë rnibëꞌa Dios. Adë chu guëníꞌidiꞌi nguiu ni nall shmëna. ");
INSERT INTO zacNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Gudëdë stubi tiempë; iurní gudili Dadë Jesús setenta nguiu. Bësheꞌldë më lëꞌë raiꞌ lu grë ra guëꞌdchi catë rac shtuꞌu më tsa më despuësë. Chupë nguiu bësheꞌldë më tubi ladë. Chupë nguiu bësheꞌldë më stubi ladë. Grë raiꞌ gua. ");
INSERT INTO zacNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Guniꞌi më lu rall: ―Ra mënë shtë guë́ꞌdchiliu na ziquë lachi con ganzaꞌquë perë duꞌpsë na el quë narunë dchiꞌni. Por ni gulë gunaꞌbë lu Dios guësheꞌldë më más nagunë dchiꞌni. ");
INSERT INTO zacNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Gulë gua. Rsheꞌlda lëꞌë të ziquë lliꞌli lu ra ma dushë; mënë humildë entrë mënë dzabë. ");
INSERT INTO zacNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Adë guáꞌadiꞌi të bëdu shtë dumí. Adë guáꞌadiꞌi të bëdu lari. Adë guáꞌadiꞌi të rachi. Adë gac ldëꞌë të lu nezë parë guadiꞌdzënú të mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Iurë guëdchini të lidchi mënë, gulë bëꞌnë saludar ra mënë. Gulë guniꞌi lu rall: “Gulë bëꞌnë recibir bendición shtë Dios”. ");
INSERT INTO zacNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Si talë quëreldë nguiu ndë nagunë recibir bendición shtë́nël, cuezënú bendición con lë́ꞌëll; perë si talë guëquë́ guiáꞌall bendición ni, guëabrí guëaꞌnë bendición parë lë́ꞌël stubi. ");
INSERT INTO zacNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Gulë tsaglaꞌguë cuezë të mizmë hiuꞌu ni catë bëꞌnë mënë recibir lë́ꞌël. Gulë gau narneꞌe rall gau të. Gulë biiꞌ lo quë narneꞌe rall purquë zni na el quë narunë dchiꞌni; nápëll derechë gaull lu mellë shtë lamë shtë́hiꞌ. Adë rnítidiꞌi të tiempë ziaꞌa të zihani lidchi mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Iurë guëdchini të lu guëꞌdchi catë runë ra mënë recibir lëꞌë të, gulë gau lo quë narneꞌe rall gau të. ");
INSERT INTO zacNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Gulë bënëac ra nanapë galguidzë. Gulë guniꞌi lu mënë shtë guëꞌdchi: “Hia bëgaꞌa iurë, guëlladchi zugaꞌa Dios parë guënibëꞌa më lëꞌë të”. ");
INSERT INTO zacNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Perë si talë guëdchini të lu guëꞌdchi catë adë rúnëdiꞌi mënë recibir lëꞌë të, gulë tsa grë nezë shtë guëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Gulë guniꞌi: “Gushëguiuꞌu naquë́ guëaꞌ naꞌa, guëdchibë naꞌa ziquë sëñi cuntrë lëꞌë të, të gac bëꞌa të bëdchini naꞌa nu guniꞌi naꞌa lu të bëgaꞌa iurë; guëlladchi zugaꞌa Dios parë guënibëꞌa më lëꞌë të”. ");
INSERT INTO zacNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Rniaꞌa lu të iurë zeꞌdë guëdchini juici shtë Dios, ra mënë shtë guëꞌdchi nadë rzuꞌbë diáguëdiꞌi shtiꞌdzë Dios, gunë Dios cashtigu lëꞌë rall más quë mënë shtë ciudá Sodoma. ");
INSERT INTO zacNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Prubi de lëꞌë të mënë shtë guëꞌdchi Corazín nu Betsaida, purquë adë gualdídiꞌi lduꞌu të na. Si talë nihuna milagrë lu mënë shtë guëꞌdchi Tiro nu Sidón cumë bëna entrë lëꞌë të, niabrí lduꞌu rall con Dios. Niasubë rall lu dë nu niacu rall lari nagasë ziquë sëñi de quë bëꞌnë nadzëꞌë rall mudë nanabani rall. ");
INSERT INTO zacNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Por ni, iurë guësheꞌldë Dios juici guëc ra mënë shtë guë́ꞌdchiliu, ra mënë shtë Tiro nu Sidón gunë rall sufrir menos quë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nu rniaꞌa lu të mënë shtë Capernaum, lluaꞌa të na të mënë nabëꞌnë ldaiꞌ Dios guëc të perë guëtiaꞌa Dios lëꞌë të lu cashtigu shtë guiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Guniꞌi më lu setenta shmënë më: ―El quë narzuꞌbë diaguë shtiꞌdzë të, también rzuꞌbë diáguëll shtiꞌdza. El quë narquë́ guiaꞌa lëꞌë të, rquë guiáꞌall na. Nu mizmë tiempë rquë guiáꞌall el quë nabësheꞌldë na. ");
INSERT INTO zacNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Gua ra setenta shmënë Jesús. Rquitë lduꞌu raiꞌ. Guniꞌi raiꞌ lu Jesús: ―Dadë, guniꞌi naꞌa lël parë guëgú naꞌa mëdzabë laꞌni lduꞌu mënë nu rzuꞌbë diaguë ra mëdzabë shtiꞌdzë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Guniꞌi Jesús lu raiꞌ: ―Vencidë na Satanás. Gunahia lu Satanás iurë bëquëldí Dios lë́ꞌëll; guláguëll ziquë tubi ray shtë nguziꞌu. Guláguëll dizdë gubeꞌe catë quëbezë Dios hashtë guetë. ");
INSERT INTO zacNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Guná, bënehia pudërë parë guëlú të guëc ra serpientë nu nillë. Napë të pudërë gunë të gan lu Satanás. Adë pë gáquëdiꞌi të. ");
INSERT INTO zacNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Perë guná, adë rquítëdiꞌi lduꞌu të purquë rzuꞌbë diaguë mëdzabë shtiꞌdzë të sino quë gulë bëquitë lduꞌu të purquë nasalvar të. Lë të naescritë lu gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Laꞌni mizmë iurë Jesús bëquitë ldúꞌiꞌ por pudërë shtë Espíritu Santo. Guniꞌi më lu Dios: ―Shtada, dushquíllil, rnibë́ꞌal gubeꞌe nu guë́ꞌdchiliu. Quëhuna alabar lë́ꞌël. Bëluáꞌal shtíꞌdzël lu mënë humildë, rac bëꞌa rall. Perë nacahi shtíꞌdzël bë́ꞌnël parë ra mënë narniꞌi na rall më ruꞌbë, nu parë ra mënë narianaldë tëchi llgabë nguiu. Zni bë́ꞌnël, Dadë, purquë zni rac shtúꞌul gac. ");
INSERT INTO zacNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Guniꞌi më lu ra mënë: ―Shtada bëneꞌe grë ra cusë guiahia. Ni tubi chu runguë bëꞌa chu nahia de verdá, sulamëntë Shtada runguë bë́ꞌaiꞌ. Ni tubi chu runguë bëꞌa chu na Shtada de verdá, sulamëntë na runguë bë́ꞌahia chu náhiꞌ. Nahia shini më, nu gunguë bëꞌa mieti Shtada sulamëntë si rac shtuaꞌa guëluáꞌahia nguiu ni Shtada. ");
INSERT INTO zacNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Iurní guniꞌi më lu lë́ꞌësë ra shini gusëꞌdë më: ―Nalë́ bëꞌnë ldaiꞌ Dios lëꞌë mënë nariasë́ lo quë nariasë́ të. ");
INSERT INTO zacNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Zihani mënë nabiadiꞌdzë shtiꞌdzë Dios nu rëy naguquëreldë guahietë, guc shtuꞌu raiꞌ guëná raiꞌ lo quë narná të, perë gunádiꞌi raiꞌ. Guc shtuꞌu raiꞌ guini raiꞌ lo quë narini të perë bínidiꞌi raiꞌ diꞌdzë ni. ");
INSERT INTO zacNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tubi narluaꞌa lëy shtë Moisés bëdchínill lu Jesús parë guëtë́ꞌdëll tubi prëbë lëꞌë më. Gunaꞌbë díꞌdzëll lu më: ―¿Pë rníꞌil lla guna parë gac salvara? ");
INSERT INTO zacNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús bëquebi: ―¿Pë rniꞌi lëy shtë Dios? ¿Lla rníꞌil quëgniꞌi lëy? ");
INSERT INTO zacNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Guniꞌi nguiu iurní: ―Naná escritë: “Gulë guc shtuꞌu Dadë Dios con guëdubinú ldúꞌul. Gulë guc shtuꞌu Dios con guëdubi almë shtë të, nu con guëdubi fuersë shtë të. Gulë guc shtuꞌu Dios con guëdubi shgabë të.” Nu rniꞌi lëy shtë Dios: “Gulë guc shtuꞌu grë saꞌl ziquë rac shtúꞌul mizmë lë́ꞌël”. ");
INSERT INTO zacNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús guniꞌi lull: ―Bien rníꞌil. Si talë gúnël cumplir lo quë naná escritë, guëbánil parë siemprë. ");
INSERT INTO zacNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Perë lëꞌë nguiu rac shtuꞌu guëniꞌi mënë bien de lë́ꞌëll. Gunaꞌbë díꞌdzëll lu më: ―¿Chu na sahia? ");
INSERT INTO zacNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús bëquebi con comparaciuni rëꞌ: ―Tubi nguiu bërúꞌull Jerusalén parë ziáꞌall guëꞌdchi Jericó. Terciuni bëruꞌu ngubaꞌnë lu nezë. Gulaaꞌnë rall grë nanuáꞌall hashtë nu shábëll. Bëdëꞌë ngubaꞌnë galnë́ lë́ꞌëll, iurní bësëaꞌnë rall lë́ꞌëll hia mërë niátill. ");
INSERT INTO zacNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Guzac tubi bëshuzi bëdchini catë nagaꞌa nguiu ni. Iurë guná bëshuzi lu nguiu, gudëdë bëshuzi stubi nezë. ");
INSERT INTO zacNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nu tubi më levita narunë compañi lëꞌë bëshuzi laꞌni iáduꞌu, bëdchínill; gunall lu nguiu nagaꞌa nezë. Lëꞌë quë lëꞌë stubi nezë gudë́dëll. ");
INSERT INTO zacNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Perë tubi nguiu shtë guëꞌdchi Samaria ziaꞌa mizmë nezë ni. Gunall lu nguiu nagaꞌa. Bëgaꞌa ldúꞌull lëꞌë nguiu. ");
INSERT INTO zacNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Iurní guabíꞌguëll lu nguiu, nu bë́ꞌnëll rumëdi lu ridë. Bëtiáꞌall sëiti con vini nu bëshíꞌill tubi lari lu ridë. Bëdchíꞌbëll nguiu ni tëchi ma nanuáꞌall. Guanull lëꞌë nguiu catë rëaꞌnë nguiu pusadë. Ndë bë́ꞌnëll compañi naná ridë. ");
INSERT INTO zacNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Stubi dzë nabrëgueꞌlë, iurë lëꞌë samaritano guziaꞌa, gulull chupë dumí bëdchichi. Bëdë́ꞌëll cuaꞌa nashtënë pusadë. Nu guníꞌill: “Gupë nguiu rëꞌ. Si talë gúnël gashtë más, na guëguilla iurë guëabría.” ");
INSERT INTO zacNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Guniꞌi Jesús lu narluaꞌa lëy: ―Guniꞌi lua, de tsunë nguiu naguná lu nguiu naguc ridë por ra ngubaꞌnë, ¿chu guc shtuꞌu lëꞌë sáhiꞌ? ");
INSERT INTO zacNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Guniꞌi mësë shtë lëy: ―El quë nabëgaꞌa lduꞌu naná ridë. Iurní guniꞌi më lull: ―Zni lë́ꞌël, guaguëꞌnë ziquë bëꞌnë më samaritano. ");
INSERT INTO zacNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Guaglaꞌguë ziaꞌa Jesús nezë con ra mënë. Bëdchini më tubi guëꞌdchi catë quëreldë Marta nu béldëll María. Bëꞌnë raiꞌ recibir lëꞌë Jesús lidchi raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","María guzubë guëaꞌ Dadë Jesús parë guëquë́ diáguiꞌ shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta rquëdiꞌni ldúꞌull tantë dchiꞌni nanú laꞌni hiuꞌu. Guabiꞌguë Marta lu Jesús, nu guníꞌiꞌ: ―Dadë, ¿pëzielú bëdë́ꞌël permisi guzubë belda guëaꞌl? guëquë́ diáguëll shtíꞌdzël, nu tubsia quëhuna dchiꞌni. Guniꞌi lull gúnëll compañi na. ");
INSERT INTO zacNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Guniꞌi Jesús lu Marta: ―Marta, Marta, nalë́ rquëdiꞌni ldúꞌul por dchiꞌni nananú; adë rbedchídiꞌi ldúꞌul. ");
INSERT INTO zacNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tubsë cusë rquiꞌni. María gudili lo mejurë. Adë chu guëdchisú lo quë nanápiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Guzac Jesús biadiꞌdzënúhiꞌ Dios. Iurë gualú, tubi shini gusëꞌdë më guniꞌi lu Jesús: ―Dadë bëluaꞌa lëꞌë naꞌa tubi oraciuni ziquë Juan Bautista bëluáꞌaiꞌ mënë shtë́hiꞌ lla guënaꞌbë raiꞌ lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús guniꞌi: ―Iurë ruadiꞌdzënú të Dios, gulë guniꞌi: Nal Shtadë naꞌa; rac shtuꞌu naꞌa grë mënë gunë rall alabar lë́ꞌël. Rac shtuꞌu naꞌa guënibë́ꞌal grë mënë narëtaꞌ lu guë́ꞌdchiliu. Rac shtuꞌu naꞌa grë mënë gunë rall lo quë narac shtúꞌul igual ziquë ra ianglë lu gubeꞌe rzuꞌbë diaguë raiꞌ shtíꞌdzël. ");
INSERT INTO zacNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bëneꞌe nagáu naꞌa dzë con dzë. ");
INSERT INTO zacNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bëꞌnë perdunë duldë shtë naꞌa purquë runë naꞌa perdunë el quë narunë mal cuntrë lëꞌë naꞌa. Adë rdë́ꞌëdiꞌil permisi guëtëꞌdë mëdzabë prëbë lëꞌë naꞌa të ldaguë naꞌa lu duldë. ");
INSERT INTO zacNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Guaglaꞌguë guniꞌi Jesús: ―Si talë nápël tubi amigu, nu tsal lídchill guëruldë gueꞌlë. Guëníꞌil lúhiꞌ: “Amigu, bëꞌnë prështë tsunë guetështildi ");
INSERT INTO zacNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","purquë tubi amigu bëdchini zitu. Nápëdiaꞌa pë gaull.” ");
INSERT INTO zacNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Perë amigu shtë́nël guëquébill dizdë laꞌni hiuꞌu zndëꞌë: “Adë rsiúꞌbëdiꞌil na; nëꞌau puertë ruaꞌ lidcha. Grë naꞌa nagaꞌsi naꞌa. Nídiꞌi mudë guënehia narac shtúꞌul.” ");
INSERT INTO zacNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Rniaꞌa lu të, mënë ni na amigu shtë́nël perë aunquë adë në́diꞌill guënéꞌell lo quë narquíꞌnil purquë nal tubi amigu, perë si talë tsaglaꞌguë guënáꞌbëruꞌul, lë́ꞌëll tsashtëll; guënéꞌell lo quë narquíꞌnil. ");
INSERT INTO zacNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Rniaꞌa lu të, gulë bëꞌnë zni. Gulë guaglaꞌguë guënaꞌbë të lo quë narac shtúꞌul, iurní guëneꞌe më caꞌa të. Gulë tsaglaꞌguë quili të, të guëdzelë të. Gulë bësëdchi ruaꞌ puertë hashtë guëllaꞌlë puertë. ");
INSERT INTO zacNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Grë mënë narnaꞌbë lu Dios, gúnëll recibirin. Grë mënë narguili, guëdzelin. Grë mënë narsëdchi ruaꞌ puertë, guënall lla rllaꞌlë puertë parë lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Lëꞌë të naná shtadë llguëꞌnë, si talë shínil guënáꞌbëll belë mbeldë gaull, ¿pë zëdë́ꞌël tubi mbeꞌldë cáꞌall? Aquëdiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Si talë guënáꞌbëll tubi dchitë gaull, ¿pë zëdë́ꞌël tubi nillë? ");
INSERT INTO zacNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Si talë lëꞌë të naná mënë mal, perë rac të guëdëꞌë të cusë zaꞌquë caꞌa ra shini të, mucho más guëneꞌe Shtadë të naquëbezë gubeꞌe lëꞌë Espíritu Santo parë cuezënúhiꞌ lëꞌë të si talë tsaglaꞌguë rnáꞌbël lu më. ");
INSERT INTO zacNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Guzac tubi dzë Jesús cagúhiꞌ tubi mëdzabë guꞌpë nananú laꞌni tubi nguiu. Ruadíꞌdzëdiꞌill. Perë iurní bëruꞌu mëdzabë, bien ruadiꞌdzë nguiu. Ra mënë bëdzëguëëꞌ lduꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Perë bëldá rall guniꞌi: ―Rgu Jesús mëdzabë por pudërë shtë Beelzebú naná jëfë shtë los de más mëdzabë. ");
INSERT INTO zacNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Sëbëldá mënë bëtëꞌdë rall prëbë lëꞌë më, nihunë më lo quë nanádiꞌi voluntá shtë Dios. Gunaꞌbë rall gunë më tubi milagrë lu rall, ziquë tubi sëñi de quë na më shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Guc bëꞌa më llgabë naquëhunë rall. Guniꞌi më: ―Si talë guëruldë shmënë gubiernë rdildi cuntrë mizmë gubiernë, tsalú gubiernë. Nu si talë nadivididë tubi famili, guëdchini tiempë tsalú famili ni. ");
INSERT INTO zacNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nu Satanás si talë Satanás nadivididë mizmë lë́ꞌëll, tsalú pudërë shtë́nëll. Cagniaꞌa ndëꞌë purquë rniꞌi të rguhia mëdzabë por pudërë shtë Beelzebú. ");
INSERT INTO zacNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Si talë rguhia mëdzabë por pudërë shtë Beelzebú, ¿chu runë compañi ra mënë entrë lëꞌë të nargú mëdzabë laꞌni lduꞌu mënë? Lëꞌë nargú mëdzabë entrë lëꞌë të, guëniꞌi rall lu të chu bëneꞌe pudërë guiahia parë rguhia mëdzabë, nu guëniꞌi rall runë të mal llgabë. ");
INSERT INTO zacNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Perë si talë con pudërë shtë Dios, rguhia mëdzabë laꞌni lduꞌu mënë, hia bëgaꞌa iurë, guëlladchi zugaꞌa Dios parë guënibë́ꞌaiꞌ lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Si talë tubi nguiu putëntë quëhápëll bien lídchill con guiꞌbë narguini mënë, pues grë nanapë nguiu ni nasegurë. ");
INSERT INTO zacNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Perë si talë guëdchini stubi nguiu más fuertë nu gúnëll gan lu primërë nguiu, iurní guëgull grë nanapë primërë nguiu nu rtë́ꞌtsëllin entrë ra shmë́nëll. Ra guiꞌbë naná rialdí lduꞌu primërë nguiu, hia na rahin guiaꞌa stubi nguiu. ");
INSERT INTO zacNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’El quë nanë́diꞌi guëniꞌi favurë de na, nall cuntrë de na. El quë nadë rtëádiꞌi mënë lua, na ziquë tubi narsëlluꞌnë mënë lua. ");
INSERT INTO zacNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Guaglaꞌguë guniꞌi Jesús: ―Iurë bëruꞌu mëdzabë laꞌni lduꞌu nguiu, riazëll catë nídiꞌi nisë. Rguílill catë cuézëll perë adë rdzélëdiꞌill lugar. Iurní rníꞌill: “Guëabría lduꞌu mënë catë bëruaꞌa”. ");
INSERT INTO zacNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bëdchini mëdzabë. Bëdzélëll ziquë tubi hiuꞌu bien arregladë nu limpi. ");
INSERT INTO zacNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Iurní tsalliꞌi mëdzabë gadchi mëdzabë más mal quë lë́ꞌëll; riutë́ rall laꞌni lduꞌu nguiu ni. Bëaꞌnë nguiu ni con gadchi mëdzabë, lëdë túbsëdiꞌi mëdzabë. Más mal bëaꞌnë nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iurë cagniꞌi më ra diꞌdzë rëꞌ, tubi naꞌa nazú entrë ra mënë zihani guníꞌill fuertë lu më: ―Dichusë na gullanë lë́ꞌël, nu bëgáꞌdchill lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús guniꞌi: ―Más bien na el quë narquë́ diaguë diꞌdzë shtë Dios nu rzuꞌbë diáguëll shtíꞌdziꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Zihani mënë bëdchini; bëdëá rall lu Jesús. Guniꞌi më lu rall: ―Nalë́ mal na mënë tiempë neꞌ. Cagnaꞌbë rall tubi sëñi shtë Dios. Cagnaꞌbë rall guna tubi milagrë. Ni tubi cusë ruꞌbë guëná rall, sulamëntë tubi cusë ziquë naguzac tiempë shtë Jonás guëná rall. ");
INSERT INTO zacNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ziquë guc Jonás tubi sëñi parë ra mënë shtë Nínive de quë gac cumplir shtiꞌdzë Dios, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu gáquiꞌ sëñi parë ra mënë nanabani neꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Iurë gac juici shtë Dios, lëꞌë reina nagunibëꞌa ladzë Sur, tsasuldill nu gúnëll juzguë mënë nanabani iurneꞌ, na rall culpablë purquë naꞌa ni bidë guëná lëꞌë Salomón parë guëquë́ diáguëll shtiꞌdzë Salomón. Gulë guná, hia bëdchini tubi más më ruꞌbë quë Salomón. ");
INSERT INTO zacNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nu zac ra mënë naguquëreldë guëꞌdchi Nínive, tsasuldí rall lu juici con ra mënë naquëreldë neꞌ; nu guëniꞌi ra mënë shtë Nínive, ra mënë nanabani neꞌ na rall culpablë purquë ra mënë shtë Nínive, iurë bini rall shtiꞌdzë Jonás, bëabrí lduꞌu rall con Dios. Gulë guná, hia bëdchini tubi más më ruꞌbë quë Jonás. ");
INSERT INTO zacNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Ni tubi mënë rsëuꞌldëdiꞌill llni laꞌni lintërnë nu despuësë tsagcáꞌchill lintërnë lugar nagaꞌchi. Adë guëtáꞌudiꞌill lintërnë con tubi tëpë. Perë guëzuꞌbëllin guiaꞌa parë el quë natsutë́ laꞌni hiuꞌu guëzianí. ");
INSERT INTO zacNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Slul na ziquë tubi lintërnë. Si talë nazaꞌquë slul, nápël llni guëdubi laꞌni ldúꞌul. Perë si talë rac lluꞌu nacahi slul, nápëdiꞌi të llni. ");
INSERT INTO zacNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gulë bëꞌnë llgabë bien si talë llni nanapë të adë nahin nacahi. ");
INSERT INTO zacNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Iurë nanú llni guëdubi laꞌni lduꞌu të, ni tubi partë nacahi; na ziquë tubi lintërnë narzianí lu nacahi. ");
INSERT INTO zacNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nianá cagluaꞌa Jesús ra mënë, tubi fariseo bëꞌnë invitar gau më lidchi fariseo. Gua më lidchi fariseo nu guzubë më lu mellë. ");
INSERT INTO zacNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Guná fariseo zubë më lu mellë perë adë gudíbidiꞌi më guiaꞌa më ziquë na custumbrë religiusë. Guasë́ lduꞌu fariseo. ");
INSERT INTO zacNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Iurní guniꞌi Dadë Jesús lu fariseo: ―Lë́ꞌël con los de más fariseo na të ziquë trashtë naríꞌetidiꞌi. Rguibi të bien ladi ra trashtë ziquë custumbrë religiusë, perë laꞌni lduꞌu të nanú zihani maldá. Rzebi lduꞌu të pë shtë mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tuntë na të. Dios bëntsaꞌu lëꞌë nguiu nezë fuërë nu nezë laꞌni. ");
INSERT INTO zacNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gulë bëdëꞌë nanapë të caꞌa mënë. Gulë gac të mënë zaꞌquë, iurní grë cusë na limpi parë lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Prubi de lëꞌë të fariseo; caguilli të lo quë narunë tucarë caꞌa Dios hashtë ra plantë namás mituꞌnë, perë ra cusë ruꞌbë adë rúnëdiꞌi të cumplir. Rúnëdiꞌi të tratë bien con saꞌ të. Nu rac shtúꞌudiꞌi të Dios. Runë tucarë gunë të cumplir cusë rëꞌ nu los de más mandamientë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Prubi de lëꞌë të fariseo. Nalë́ rac shtuꞌu të guëzubë të primërë asientë laꞌni iáduꞌu. Rquitë lduꞌu të iurë mënë runë rall saludar lëꞌë të con zihani rëspëti catë rdëá mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Prubi de lëꞌë të. Na të ziquë ra baꞌa nagaꞌchi catë bëgaꞌchi tëgulë. Ra mënë rdëdë rall guëc ra baꞌa perë rdë́ꞌëdiꞌi rall cuendë blac fier na lugar ni. ");
INSERT INTO zacNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Iurní tubi mësë narluaꞌa lëy guníꞌill lu më: ―Mësë, nu zac cagníꞌil guëc naꞌa por diꞌdzë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús guniꞌi: ―También prubi de lëꞌë të mësë shtë lëy purquë quëhunë të obligar ra mënë gunë rall zihani custumbrë. Nahin ziquë tubi carguë nëꞌë, perë lëꞌë të adë rldísidiꞌi tëhin ni siquierë con tubi shcuënë të. ");
INSERT INTO zacNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Prubi de lëꞌë të. Rzaꞌa të capillë shtë ra profetë nabiadiꞌdzë shtiꞌdzë Dios. Shtadë guëlú të gudini rall ra profetë ni. ");
INSERT INTO zacNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Na të testigu gudini ra shtadë guëlú të lëꞌë ra profetë, nu na të de acuerdë con lo quë nabëꞌnë rall purquë rzaꞌa të capillë shtë ra profetë. ");
INSERT INTO zacNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Por ni laꞌni librë nanuaꞌa sabiduría shtë Dios rniꞌi: “Guësheꞌlda profetë nu poshtë lu ra mënë perë quini mënë bëldá ra nabësheꞌlda, gati raiꞌ. Sëbëldá raiꞌ guëzac zi mënë.” ");
INSERT INTO zacNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Perë rniaꞌa lu të, gunë Dios juzguë ra mënë tiempë neꞌ por grë maldá nabëꞌnë ra mënë cuntrë ra profetë dizdë bëcueꞌshtë́ më guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ra mënë nanabani neꞌ na rall culpablë por galguti shtë Abel nu por galguti shtë grë më zaꞌquë, hashtë galguti shtë Zacarías, el quë nagudini mënë entrë iáduꞌu nu bëcuꞌguë. Gunë më juzguë lëꞌë të por grë ra cusë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Prubi de lëꞌë të mësë shtë lëy purquë napë të liahi parë gac bëꞌa lla gac salvar mënë perë adë në́diꞌi tsutë́ të shnezë Dios nu adë në́diꞌi të tsutë́ mënë shnezë më; gac rall shmënë më. ");
INSERT INTO zacNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nianá cagniꞌi më ra cusë rëꞌ, ra mësë shtë lëy nu ra fariseo bëldënú rall Jesús. Bëdchiꞌbë rall zihani diꞌdzë guëc më. Gudildi diꞌdzë rall të guëniꞌi më cusë mal. ");
INSERT INTO zacNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Bëtëꞌdë rall prëbë lëꞌë më parë ldaguë më lu trampë shtë rall. Mudë ni gudili rall parë gunë rall acusar lëꞌë më lu gubiernë rumanë. ");
INSERT INTO zacNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tiempë ni bëdëá zihani mili mënë hashtë rteꞌe saꞌ rall. Jesús guzublú guniꞌi më lu ra shini gusëꞌdë më, primërë lu raiꞌ: ―Gulë gupë cuidadë enseñansë shtë ra fariseo. Na rall falsë. Enseñansë shtë rall rrëꞌtsë ziquë levadurë laꞌni nacubë. ");
INSERT INTO zacNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lo quë nanú laꞌni lduꞌu mënë guëruꞌu lu llni. Grë cusë nagaꞌchi napë quë gac bëꞌa mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Grë lo quë narniꞌi të lu nacahi, guini mënë lu llni. Lo quë narniꞌi të nagaꞌchi nu lo quë naruadiꞌdzë të laꞌni hiuꞌu catë nëꞌau, gac bëꞌa mënë. Guëabrí guadiꞌdzë mënë fuertë shtiꞌdzë të lu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Guaglaꞌguë guniꞌi Jesús: ―Na të amigu shtëna. Rniaꞌa lu të adë rdzë́bëdiꞌi të mënë narguini cuerpë perë nápëdiꞌi rall pudërë gunë rall más cusë cuntrë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Perë na guëniaꞌa lu të chu guëdzëbë të lúhiꞌ. Náhiꞌ el quë despuësë quíniꞌ lë́ꞌël, nápiꞌ pudërë parë guëshéꞌldiꞌ lë́ꞌël gabildi. Rniaꞌa lu të stubi, gulë bëdzëbë lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Rdu gaꞌi maꞌñi por chupë dumí biꞌchi. Perë Dios rëagná ldúꞌiꞌ lëꞌë ra ma. ");
INSERT INTO zacNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nu napë më cuendë bëldá guitsë guëc të zubë cadë de lëꞌë të. Adë rdzë́bëdiꞌi të lo quë quëhunë mënë cuntrë lëꞌë të; más lasac të quë zihani maꞌñi. ");
INSERT INTO zacNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Rniaꞌa lu të, si talë rniꞌi të lu ra mënë na të shmëna, guëniaꞌa lu ra ianglë shtë Dios na të mënë shtëna. Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Perë si talë guëniꞌi të lu ra mënë adë nádiꞌi të shmëna, iurní guëniaꞌa lu ra ianglë nádiꞌi të mënë shtëna. ");
INSERT INTO zacNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. El quë narniꞌi didzabë cuntrë na, gac gunë Dios perdunë lë́ꞌëll; perë si rníꞌil didzabë cuntrë Espíritu Santo, gúnëdiꞌi më perdunë lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Iurë guaꞌa mënë lëꞌë të lu ra gubiernë u lu ra juësi u lu ra narunë juzguë laꞌni iáduꞌu, adë rúnëdiꞌi të llgabë pë guëniꞌi të lu rall, lla guëquebi të parë guëruꞌu të, ");
INSERT INTO zacNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","purquë mizmë iurë ni Espíritu Santo guëluáꞌaiꞌ lëꞌë të pë guëquebi të lu rall. ");
INSERT INTO zacNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Iurní tubi mënë nabëruꞌu ladi mënë zihani, guníꞌill lu Jesús: ―Mësë, bëꞌnë favurë; guniꞌi lu bëcha guënéꞌell herenci narunë tucarë cahia. ");
INSERT INTO zacNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Perë Jesús guniꞌi lull: ―Rúnëdiꞌi tucara nihuna juzguë entrë lëꞌë të. Ni tubi të bë́ꞌnëdiꞌi nombrar na parë quiꞌdza herenci shtënë të. ");
INSERT INTO zacNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Guaglaꞌguë guniꞌi më lu ra mënë: ―Gulë gupë mizmë lëꞌë të parë adë rzébidiꞌi lduꞌu të ra cusë shtë guë́ꞌdchiliu. Galërquitë lduꞌu nguiu zeꞌdë de Dios, lë́dëdiꞌi por cusë zihani nanapë nguiu lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Iurní guniꞌi më tubi comparaciuni: ―Guc tubi nguiu ricu. Shguiúꞌull bëdëꞌë tubi bënë ganzaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Bë́ꞌnëll llgabë: “Lla guna con tantë lluꞌbë. Nídiꞌi lugar parë cuetsáꞌuhin.” ");
INSERT INTO zacNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Guníꞌill: “Guëchilia hiuꞌu catë cuetsaꞌu lluꞌbë. Guëzáꞌahia stubi más naruꞌbë, cuetsaꞌu lluꞌbë laꞌni con grë cusë nanapa. ");
INSERT INTO zacNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mizmë na runa llgabë, nanú sufsientë por zihani izë. Gúnëdiaꞌa dchiꞌni lachi; más bien guëbeza lidcha. Gáuha; guaꞌ vini. Guëquitë lduaꞌa.” ");
INSERT INTO zacNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nianá quëhúnëll llgabë, guniꞌi Dios lull: “Tuntë nal. Gueꞌlë neꞌ gátil. Ra cusë nabëtëal, ¿chu gac nashtënë rahin?” ");
INSERT INTO zacNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Zni na grë ra nguiu nartëá zihani cusë parë mizmë lë́ꞌëll perë nápëdiꞌill cusë nalasac lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","También guniꞌi Jesús lu ra shini gusëꞌdë më: ―Rniaꞌa lu të, adë rquëdíꞌnidiꞌi lduꞌu të por lo quë nagáu të parë guëbani të, ni por shabë të nagacu të. ");
INSERT INTO zacNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Vidë shtë të na más lasac quë nagáu të. Cuerpë shtë të más lasac quë shabë të. ");
INSERT INTO zacNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gulë guná, ziquë ra ma riegu adë rcabnídiꞌi ma lluꞌbë. Adë riagllíꞌidiꞌi ma cusechë lachi cuetsaꞌu mahin laꞌni hiuꞌu. Perë Dios rgáuhiꞌ ra ma. Lëꞌë të lasac të más quë ra maꞌñi. ");
INSERT INTO zacNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Chu de lëꞌë të por tantë rúnël llgabë guëbánil tubi dzë más? ");
INSERT INTO zacNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Si talë gáquëdiꞌi gunë të ra cusë mituꞌnë, ¿pëzielú runë të llgabë por ra cusë ziquë nagáu të u nagacu të? ");
INSERT INTO zacNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Gulë guná, lla riaruꞌbë ra guëꞌë. Adë rúnëdiꞌi rahin dchiꞌni. Adë rtíꞌbidiꞌi rahin, perë rëy Salomón con guëdubi galëlujë shtë́hiꞌ, bë́ꞌnëdiꞌiꞌ gan niácuhiꞌ ziquë ra guëꞌë lachi. ");
INSERT INTO zacNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gulë guná, lëꞌë të narialdí lduꞌi duꞌpë, chulë rluaꞌa guëꞌë lachi nedzë́, quëhunë Dios; perë glli guëbidchi guëꞌë nu tsahin lu guiꞌi. Mucho más guëneꞌe më narquiꞌni të. ");
INSERT INTO zacNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Adë rianáldëdiꞌi të tëchi ra cusë pë gau të, pë gu të; adë rquëdíꞌnidiꞌi lduꞌu të por ra cusë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ra mënë nadë rialdídiꞌi lduꞌi shtiꞌdzë Dios, rianaldë rall tëchi ra cusë shtë guë́ꞌdchiliu, perë lëꞌë të napë të Shtadë të. Runë më cuendë grë nicidá nanapë të. ");
INSERT INTO zacNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Primërë gulë guanaldë tëchi narac shtuꞌu Dios. Na më rëy. Iurní guëneꞌe më grë cusë narquiꞌni të parë guëbani të. ");
INSERT INTO zacNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Na të duꞌpë mënë narianaldë tëcha ziquë ra lliꞌli narianaldë tëchi vëquërë. Adë rdzë́bëdiꞌi të purquë Shtadë të gudili lëꞌë të, të guënibëꞌa të catë na më rëy. ");
INSERT INTO zacNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gulë bëtuuꞌ nanapë të caꞌa mënë dumí, el quë nabënápëdiꞌi. Gulë gapë të panitë nadë rúꞌshidiꞌi con dumí nadë rialúdiꞌi; quiere decir, tesurë lu gubeꞌe. Ndë ni tubi ngubaꞌnë riutë́diꞌi. Nídiꞌi ma naráu panitë parë tsaluhin. ");
INSERT INTO zacNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Catë nacuetsaꞌu tesurë shtë́nël, ndë rac shtúꞌul guëbánil. ");
INSERT INTO zacNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Gulë gac listë nu preparadë guëdubi tiempë, ziquë nguiu nalliꞌi láꞌniꞌ parë dchiꞌni, ziquë mënë nanuaꞌa lintërnë naquë́ llni. ");
INSERT INTO zacNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Gulë gac ziquë ra muzë naquëbezë lamë shtë rall. Gua lamë lidchi saꞌa. Ra muzë naná listë parë guëshaꞌlë rall puertë lueguë, iurë rsëdchi lamë ruaꞌ puertë; ");
INSERT INTO zacNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","rquitë lduꞌu ra muzë si nabani rall iurë lëꞌë lamë guëdchini, purquë rniaꞌa lu të de verdá, guëruꞌu shumbrelë lamë nu guëniꞌi lamë lu ra muzë: “Gulë guzubë lu mellë”. Iurní lëꞌë lamë gúnëll sirvë lu rall, gau rall. ");
INSERT INTO zacNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Si talë guëdchini lamë guëruldë gueꞌlë; si talë guëdchini lamë zeꞌdë grëgueꞌlë nu guëdzelë lamë lëꞌë ra muzë quëbezë rall, hia nabani rall; rquitë lduꞌu ra muzë iurní. ");
INSERT INTO zacNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nanë́ të bien si talë niac bëꞌa nashtënë tubi hiuꞌu pë iurë guëdchini ngubaꞌnë lídchiꞌ, zúgaꞌa nguiu ni listë. Në́diꞌill tsutë́ ngubaꞌnë lídchill. ");
INSERT INTO zacNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nu zac lëꞌë të napë quë gac të listë purquë adë nápëdiꞌi të cuendë ca iurë guëdchinia stubi. Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu; guëdchinia iurë rniꞌi të runë faltë parë guëdchinia. ");
INSERT INTO zacNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Iurní gunaꞌbë diꞌdzë Pedro lu më: ―¿Pë guníꞌil comparaciuni rëꞌ lu grë mënë u guníꞌilin sulë parë lëꞌë naꞌa? ");
INSERT INTO zacNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Guniꞌi më: ―¿Chu na muzë zaꞌquë nu nasini guë́quëll? Nall ziquë tubi mënë encargadë con lidchi shlámëll. Rnibëꞌa shlámëll guënall grë dchiꞌni, nu guëdë́ꞌëll nagáu ra muzë iurë rgaꞌa iurë rau rall. ");
INSERT INTO zacNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nalë́ rquitë lduꞌu encargadë ni si talë quëhúnëll bien iurë guëdchini lamë shtë́nëll. ");
INSERT INTO zacNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Guldía rniaꞌa lu të, lëꞌë lamë gúnëll nombrar lëꞌë nguiu ni, guënibë́ꞌall grë nanapë lamë. ");
INSERT INTO zacNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Perë si talë lëꞌë nguiu rníꞌill laꞌni ldúꞌull, adë guëdchínidiꞌi lamë lueguë, nu guëzublú nguiu ni sac zill ra muzë nu ra criadë con galnë́, perë lë́ꞌëll raull, ruuꞌll, rzuuꞌdchill. ");
INSERT INTO zacNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Guëdchini lamë shtë́nëll mërë iurë adë quëbézëdiꞌill lëꞌë lamë. Guëabrí lamë de repëntë iurë adë quëhúnëdiꞌi nguiu ni bien. Lëꞌë lamë gúnëll cashtigu lë́ꞌëll nu guënibëꞌa lamë gátill nu tsall lugar catë nanú ra nadë rialdídiꞌi lduꞌi Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Lëꞌë muzë naguc bëꞌa pë rac shtuꞌu lamë gúnëll perë adë bë́ꞌnëdiꞌill cumplir, adë bë́ꞌnëdiꞌill preparar, guëdëꞌë lamë zihani galnë́ guëc muzë ni. ");
INSERT INTO zacNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Perë lëꞌë muzë nadë guc bë́ꞌadiꞌi pë rac shtuꞌu lamë gúnëll, nu bëꞌnë muzë lo quë narunë tucarë cashtigu, guëdëꞌë lamë duꞌpsë galnë́ guëc muzë ni. Si talë bëdëꞌë Dios zihani llni guëc nguiu, nall responsablë lu më gúnëll bien con ra cusë ni. Lëꞌë nguiu nabëꞌnë recibir pë shtë mënë, nall responsablë nu mënë guënaꞌbë rall más de nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Beꞌdë guëdchinia parë gac cashtigu mënë shtë guë́ꞌdchiliu lu guiꞌi. Nalë́ rac shtuaꞌa de quë subluhin. ");
INSERT INTO zacNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Napë quë guëtiáꞌahia lu galërzac zi, ziquë rtiaꞌa mënë nguiu laꞌni nisë parë chubë nisë nguiu. Nahia ziquë mënë narlullë hashtë tsalú gac cumplirin. ");
INSERT INTO zacNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Gu lluaꞌa të beꞌdë guëdchinia parë cuedchí lduꞌu mënë con saꞌ rall? Aquëdiꞌi. Lëdë znídiꞌi. Beꞌdë guëdchinia parë gac divididë ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dizdë iurneꞌ gac divididë famili; tsunë mënë guëruꞌu rall favurë de na. Mizmë famili guëruꞌu chupë mënë cuntrë de na. ");
INSERT INTO zacNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Shtadë llguëꞌnë rldënú rall cuntrë shíniꞌ. Llguëꞌnë na cuntrë shtadë llguëꞌnë. Shniꞌa na cuntrë shtsáꞌpiꞌ. Shtsaꞌpë na cuntrë shníꞌaiꞌ. Suëgrë rldënú llíꞌllill. Lliꞌlli na cuntrë suë́grëll. ");
INSERT INTO zacNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nu zac guniꞌi Jesús lu ra mënë zihani: ―Iurë rna të shcahi nagasë nezë guetë, rniꞌi të: “Hia mërë guëdchini guiu”. Lueguë rlaguë guiu. ");
INSERT INTO zacNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Si zeꞌdë mbë nezë sur, rniꞌi të: “Zeꞌdë galnaꞌi”. Nu lueguë rac naꞌi. ");
INSERT INTO zacNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Na të falsë, nanë́ të sëñi nananú lu guë́ꞌdchiliu nu ra sëñi nananú gubeꞌe. ¿Pëzielú rac bë́ꞌadiꞌi të pë runë cuntienë lo quë naquëhac iurneꞌ? ");
INSERT INTO zacNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Gulë bëꞌnë llgabë cadë tubi të lo quë nazaꞌquë lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Por ejemplë, si talë tubi mënë runë demandë lë́ꞌël lu gubiernë, antsë guëdchínil lu autoridá, bëꞌnë rëglë con contrari shtë́nël parë guëaꞌnë en paz. Si adë rúnëdiꞌil zni, lëꞌë contrari shtë́nël gúnëll demandë lë́ꞌël lu juësi. Lëꞌë juësi gúnëll intriegu lë́ꞌël lu suldadë. Lëꞌë suldadë tsagsaꞌnë rall lë́ꞌël lachiguiꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Guldía, adë guërúꞌudiꞌil hashtë quíllil grë centavë nanazéꞌbil. ");
INSERT INTO zacNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nianá biadiꞌdzë Jesús diꞌdzë rëꞌ, bëruꞌu bëldá nguiu naguniꞌi lu Jesús mal nabëꞌnë Pilato, purquë Pilato gudini bëldá mënë shtë Galilea laꞌni iáduꞌu ruꞌbë. Rënë shtë ra nguiu ni guc mescladë con rënë shtë ma nabëꞌnë ra më israelitë ofrecërë ziquë ofrendë lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús guniꞌi lu rall: ―¿Pë llgabë quëhunë të neꞌ? Ra mënë nabëꞌnë sufrir zni, adë nápëdiꞌi rall más duldë quë los de más saꞌ rall. ");
INSERT INTO zacNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Rniaꞌa lu të, si talë adë guëabrí lduꞌu të con Dios, zac guëniti të catë nídiꞌi fin. ");
INSERT INTO zacNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Pë lluaꞌa të ra cheꞌñi bi tsunë nguiu naguti iurë gulaguë tubi hiuꞌu guiaꞌa guëc rall, na raiꞌ más më duldë quë grë ra mënë naquëreldë Jerusalén dzë ni? Guti raiꞌ, bëꞌnë luꞌ shtë Siloé. ");
INSERT INTO zacNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Rniaꞌa lu të, lëdë znídiꞌi. Si talë adë gúnëdiꞌi të cambi mudë nanabani të lu Dios, zac lëꞌë të guëniti të catë nídiꞌi fin. ");
INSERT INTO zacNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iurní guniꞌi më comparaciuni rëꞌ: ―Tubi nguiu bëcabní tubi hiaguë higu entrë ra hiaguë uvë. Gudëdë izë. Guaglliꞌi nguiu nashi shtë hiaguë higu perë pë bëdzélëdiꞌill. ");
INSERT INTO zacNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Iurní guníꞌill lu naquëhapë ra plantë: “Guná, tsunë izë beꞌdë guëllihia nashi shtë hiaguë higu perë ni tubi nashi bëdzélëdiaꞌa. Bëchuguë hiaguë ni. ¿Pëzielú quëhunë hiaguë cupar lugar lu shlatë?” ");
INSERT INTO zacNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Perë nguiu naquëhapë ra plantë guniꞌi: “Dadë, bësëaꞌnë hiaguë ni stubi izë. Tsagldëꞌa guiuꞌu nu guëtiáꞌahia bonë guëaꞌ hiaguë parë guëneꞌe hiaguë nashi. ");
INSERT INTO zacNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Guëbézaꞌa stubi izë, si talë adë guënéꞌediꞌin nashi, gunibëꞌa, guëchúgahin iurní.” ");
INSERT INTO zacNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tubi dzë narziꞌi lduꞌu mënë, Jesús cagluaꞌa ra mënë laꞌni iáduꞌu shtë ra më israelitë. ");
INSERT INTO zacNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ndë nanú tubi naꞌa narac lluꞌu cheꞌñi bi tsunë izë. Bëlecu të́chiꞌ, bëꞌnë mëdzabë mal. Adë bëꞌnë naꞌa gan guzuldill. ");
INSERT INTO zacNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iurë guná Jesús lu naꞌa ni, gunaꞌbë më lë́ꞌëll nu guniꞌi më: ―Lë́ꞌël, hia bëáquël; nal librë galguidzë shtë́nël. ");
INSERT INTO zacNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Bëdchiꞌbë më guiaꞌa më guëc naꞌa. Guasuldill. Guzublú guníꞌill llëruꞌbë na pudërë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Perë lëꞌë jëfë shtë iáduꞌu bëldënull Jesús purquë bënëac më lëꞌë naꞌa dzë narziꞌi lduꞌu mënë. Guniꞌi jëfë lu ra mënë: ―Shuꞌpë dzë nanú gunë mënë dchiꞌni. Guëdchini ra mënë narac lluꞌu entrë laꞌni llmalë, lë́dëdiꞌi dzë descansë guëac rall. ");
INSERT INTO zacNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Iurní guniꞌi Dadë Jesús lull: ―Na të mënë falsë. Cadë tubi të nanapë burrë u tubi ngunë, rshaꞌquë të ma nu riaꞌanú të ma, gu ma nisë. Grë ra dzë quëhunë të zni. ");
INSERT INTO zacNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Guná lu naꞌa rëꞌ, nall llëbní Abraham. Cheꞌñi bi tsunë izë rac llúꞌull; quëdull por pudërë shtë Satanás. ¿Pë rníꞌil; guëshaca lë́ꞌëll lu galguidzë rëꞌ dzë narziꞌi lduꞌu mënë? ");
INSERT INTO zacNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iurë guniꞌi Jesús diꞌdzë rëꞌ, grë ra mënë narunë cuntrë lëꞌë më, rtu lu rall. Los de más mënë bëquitë lduꞌu rall iurë guná rall cusë ruꞌbë nabëꞌnë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Guniꞌi Jesús tubi comparaciuni: ―¿Lla guërëꞌtsë diꞌdzë de quë guëlladchi na Dios parë guënibë́ꞌaiꞌ mieti? ¿Pë guëniaꞌa lu të, të gac bëꞌa të? ");
INSERT INTO zacNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Manërë narnibëꞌa Dios mënë, na ziquë tubi bëꞌdchi biꞌchi. Gudishi nguiu bëꞌdchi ni. Gualdani bëꞌdchi nu guaruꞌbin hashtë guquin tubi hiaguë ruꞌbë. Ra maꞌñi bëdchiꞌbë bëcheꞌzë lu llicu hiaguë. ");
INSERT INTO zacNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Guaglaꞌguë guniꞌi Jesús: ―¿Pë comparaciuni guëniaꞌa lu të? të gac bëꞌa të manërë rnibëꞌa Dios ziquë Rëy. ");
INSERT INTO zacNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nahin ziquë levadurë nabëdchiꞌbë tubi naꞌa guëc tsunë medidë harinë. Lëꞌë levadurë rdëꞌëin fuersë grë nacubë. ");
INSERT INTO zacNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Guaglaꞌguë guzë́ më nezë parë Jerusalén. Bëluaꞌa më ra më guëꞌdchi nu më ranchi catë canzë́ më. ");
INSERT INTO zacNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Guzac tubi mënë gunaꞌbë díꞌdzëll lu Jesús: ―Dadë, ¿blac mënë gac salvar, duꞌpsë u zihani mënë? Guniꞌi më lull: ");
INSERT INTO zacNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Gulë guniꞌi lduꞌu të parë tsutë́ të puertë nadeꞌe, purquë guëdchini tiempë zihani mënë gac shtuꞌu tsutë́ rall puertë ni perë gúnëdiꞌi rall gan. ");
INSERT INTO zacNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Gaquin ziquë nashtënë hiuꞌu. Nëꞌau puertë shtë hiuꞌu. Lëꞌë të zugaꞌa të fuërë. Rsëdchi të puertë ni nu guëniꞌi të: “Dadë, bëshaꞌlë puertë, guëdchini naꞌa”. Perë lëꞌë nguiu ni guëniꞌi lu të: “Adë runguë bë́ꞌadiaꞌa chu na të”. ");
INSERT INTO zacNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Iurní lëꞌë të guëzublú guëniꞌi të: “Gudaunú naꞌa lë́ꞌël; biiꞌnú naꞌa lë́ꞌël. Bëluáꞌal lëꞌë naꞌa ladi guëꞌdchi shtë naꞌa.” ");
INSERT INTO zacNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Iurní nguiu ni guëquébill lu të: “Hia guniaꞌa lu të, rdë́ꞌëdiaꞌa cuendë chu na të, lëꞌë të mënë naquëhunë maldá. Gulë guabsú lua.” ");
INSERT INTO zacNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Rniaꞌa lu të lugar ni guꞌnë të; gau laiꞌ të purquë guëbiꞌa të lu grë ra nabiadiꞌdzë shtiꞌdzë Dios guahietë lu gubeꞌe perë lëꞌë të adë tsutë́diꞌi të. Guëaꞌnë të fuërë. ");
INSERT INTO zacNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Guëdchini mënë nezë guiaꞌa. Guëdchini mënë nezë guetë. Guëdchini mënë nezë nortë nu nezë sur. Guëzubë rall; gau rall lu gubeꞌe catë rnibëꞌa Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Guná, bëldá mënë nalasáquëdiꞌi lu guë́ꞌdchiliu iurneꞌ, lasac rall lu Dios iurní; nu bëldá mënë naná më ruꞌbë neꞌ, adë gáquëdiꞌi rall më ruꞌbë iurní. ");
INSERT INTO zacNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mizmë dzë naguniꞌi Jesús diꞌdzë rëꞌ, bëdchini bëldá fariseo lu Jesús. Guniꞌi rall lu më: ―Bëruꞌu de ndëꞌë purquë Herodes rac shtuꞌu quínill lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús guniꞌi lu rall: ―Herodes nasini guë́quëll parë guësiguëll. Gulë guagniꞌi lull: “Nedzë́ nu glli riaglaꞌguë gunëaca ra narac lluꞌu. Guëgúa mëdzabë laꞌni lduꞌu mënë. Perë tëchi glli guëzubluhia shchiꞌnia.” ");
INSERT INTO zacNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Napë quë tsaglaꞌga shneza nedzë́, glli, nu tëchi glli purquë nádiꞌin posiblë tubi naruadiꞌdzë shtiꞌdzë Dios gátiꞌ stubi guëꞌdchi; sulamëntë Jerusalén gátiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Mënë shtë Jerusalén, rniaꞌa lu të, rguini të ra nabiadiꞌdzë shtiꞌdzë Dios, guti raiꞌ. Bëdëꞌë guëꞌë të ra narniꞌi shtiꞌdzë Dios lu të. Zihani vueltë guc shtuaꞌa niatëahia lëꞌë të ziquë tubi guidi rguëdchi ra guidi meꞌdë, perë në́diꞌi të guëdchini të lua. ");
INSERT INTO zacNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Rniaꞌa lu të, më Jerusalén, guëaꞌnë të ziquë tubi hiuꞌu dachi. Gúnëdiꞌi Dios compañi lëꞌë të. Nu adë guënádiꞌi të lua hashtë dzë naguëniꞌi të: “Benditë na el quë nabësheꞌldë Dadë Dios lu guë́ꞌdchiliu. Bëꞌnë ldaiꞌ më lë́ꞌiꞌ.” Zni guëniꞌi të. ");
INSERT INTO zacNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Guzac tubi dzë descansë, guataunú më lidchi jëfë shtë ra fariseo. Los de más fariseo quëgldaꞌchi rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Guëlladchi më nanú tubi nguiu narac lluꞌu nagadzë́ guiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesús gunaꞌbë diꞌdzë lu ra fariseo nu lu ra mësë shtë lëy: ―¿Pë rniꞌi të? ¿Gu runë providë lëy shtë Dios gunëácaꞌa ra narac lluꞌu dzë narziꞌi lduꞌu mënë? ");
INSERT INTO zacNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Perë lëꞌë rall adë bëquébidiꞌi rall. Iurní Jesús biaꞌa lëꞌë nguiu tubi ladë; bënëac më lë́ꞌëll. Guniꞌi më tsall con bien. ");
INSERT INTO zacNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Lueguë guniꞌi më lu ra fariseo: ―Grë të si talë guëlaguë tubi ngunë u tubi burrë laꞌni guërzú dzë descansë, lueguë tsaldú të ma. Ni tubi të adë guëbézëdiꞌi hashtë stubi dzë parë guëgú të ma. ");
INSERT INTO zacNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Gúquëdiꞌi rall nihunë rall contëstë lu Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Guná Jesús lla na ra mënë invitadë lidchi fariseo, gudili rall mejurë lugar lu mellë iurë gudáu rall. Guniꞌi më tubi comparaciuni lu rall: ");
INSERT INTO zacNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Iurë runë mënë invitar lë́ꞌël lu saꞌa, adë rzúbëdiꞌil lugar mejurë purquë si talë nanul lugar zaꞌquë nu guëdchini stubi më más lasac quë lë́ꞌël, ");
INSERT INTO zacNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","lëꞌë më nabëꞌnë invitar guërupë të, guëníꞌill lul: “Bëꞌnë favurë guasuldí; subë nguiu rëꞌ ndëꞌë catë zúbël”. Pues tsasúbël stubi lugar trasë perë blac rtu lul iurní. ");
INSERT INTO zacNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Perë guná, si talë tsal lidchi mënë, guzúbël lugar humildë, iurní lëꞌë nguiu nabëꞌnë invitar lë́ꞌël, guënall catë zúbël. Guëníꞌill lul iurní: “Dadë, bëꞌnë favurë guzubë lugar zaꞌquë culaꞌni ra më nalasac”. Zni nápël hunurë lu ra mënë nazubënú lu mellë. ");
INSERT INTO zacNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","El quë narunë parë gáquëll më ruꞌbë, guëláguëll con shtu, perë el quë nadë rúnëdiꞌi parë gáquëll më ruꞌbë, Dios gunë honrar lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iurní guniꞌi Jesús lu nabëꞌnë invitar lëꞌë më gau më lídchill: ―Iurë quëhúnël invitar ra mënë të gau rall, guëruldë dzë u gueꞌlë, adë rnáꞌbëdiꞌil amigu shtë́nël, nilë shfamílil, nilë ra bë́chil. Adë rnáꞌbëdiꞌil vëcini ricu shtë́nël purquë lëꞌë rall despuësë gunë rall lo mizmë con lë́ꞌël, gaul lu mellë shtënë rall; ");
INSERT INTO zacNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","sino quë iurë quëhúnël invitar ra mënë lídchil, gunaꞌbë ra prubi. Gunaꞌbë ra mancu, ra cujë, ra ciegu të gau rall lídchil. ");
INSERT INTO zacNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bë nápëdiꞌi rall të parë guëabrí quilli rall lë́ꞌël. Guëquitë ldúꞌul iurní; nu Dios quilli lë́ꞌël dzë natsashtë́ ra shmënë më ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tubi nazubënú Jesús lu mellë, iurë bínill diꞌdzë rëꞌ, guníꞌill: ―Dichusë grë ra natsutë́ gubeꞌe catë Dios na Rëy, të súbëll lu mellë, gaull. ");
INSERT INTO zacNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús guniꞌi lu nguiu ni: ―Tubi nguiu bëꞌnë preparar guëdë́ꞌëll tubi cumidë zaꞌquë. Gunáꞌbëll zihani mënë guëdchini të gau rall. ");
INSERT INTO zacNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bëgaꞌa iurë hia listë na grë cusë. Iurní bësheꞌldë nguiu ni tubi muzë naguagniꞌi lu ra invitadë: “Gulë gudeꞌe lueguë. Hia nadchiꞌbë cumidë lu mellë gau të.” ");
INSERT INTO zacNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Perë grë ra invitadë tubi por tubi bëꞌnë rall dispensar. Primërë nguiu guniꞌi: “Bëꞌnë dispensar na. Guzía tubi ldë guiuꞌu, napë quë tsagnahia luhin.” ");
INSERT INTO zacNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Stubi guniꞌi: “Guzía gaꞌi nezë ngunë. Mërë iurneꞌ gac prëbë ma nia zunë ma dchiꞌni. Bëꞌnë dispensar na.” ");
INSERT INTO zacNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Stubi guniꞌi: “Tampa bëtsë́ꞌahia. ¿Llallë tsahia iurneꞌ?” ");
INSERT INTO zacNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Bëabrí muzë lidchi lamë ni. Guníꞌill lúhiꞌ grë lo quë guniꞌi ra invitadë. Bëldë́ lamë ni. Guníꞌill lu muzë: “Gua lueguë nasesë lu nezë hashtë ra nezë biꞌchi shtë guëꞌdchi. Guaglliꞌi ra prubi, ra mancu, ra cujë, nu ra ciegu; gau rall.” ");
INSERT INTO zacNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Gudëdë stuꞌpë tiempë bëabrí muzë. Guniꞌi muzë lu lamë: “Dadë, hia bëna lo quë naguníꞌil perë todavía nanú lugar lu mellë”. ");
INSERT INTO zacNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Lëꞌë lamë guníꞌill: “Gua stubi; bëꞌnë ruëguë lu mënë nazugaꞌa nezë lachi nu ra nananú caminë reali parë gueꞌdë guëzë́ rall lidcha. Gac zihani mënë hashtë tsúdiꞌi lugar lu mellë. ");
INSERT INTO zacNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ni tubi nagunaꞌba primërë gáudiꞌi rall cumidë zaꞌquë nabëna preparar.” ");
INSERT INTO zacNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Zihani mënë guanaldë rall tëchi më. Bëdchigrë́ më; guná më tëchi më nu guniꞌi më lu rall: ");
INSERT INTO zacNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―El quë narac shtuꞌu gáquëll shmëna, napë quë gac shtúꞌull na más quë shtádëll, más quë shníꞌall, más quë tséꞌlëll, nu shínill, nu ra bë́chill, nu zánëll. Napë quë rac shtúꞌull na más quë prupi vidë shtë́nëll. Si talë rúnëdiꞌill ni, nídiꞌi mudë gáquëll shmëna. ");
INSERT INTO zacNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Cualquier narac shtuꞌu gáquëll shmëna, napë quë gúnëll renunci prupi deseo shtë́nëll nu gáquëll dispuestë gátill por na. ");
INSERT INTO zacNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Cadë tubi de lëꞌë të si talë rac shtúꞌul guëzáꞌal tubi hiuꞌu ruꞌbë, primërë guënaꞌbë díꞌdzël blac dumí runë costar parë tsalú dchiꞌni. Iurní guëlábël dumí nanápël; gac bë́ꞌal si talë nanú sufsientë dumí. ");
INSERT INTO zacNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Si talë adë rúnëdiꞌil llgabë bien, despuësë de guntsáꞌul cimientë shtë hiuꞌu, nídiꞌi dumí tsalú hiuꞌu, grë ra mënë naguëná lu cimientë, tsaglaꞌguë gunë rall burnë lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Guëniꞌi rall iurní: “Nguiu rëꞌ guzublú guëzáꞌall hiuꞌu perë nápëdiꞌill dumí parë tsalú dchiꞌni”. ");
INSERT INTO zacNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Gulë bëquë́ diaguë stubi comparaciuni. Tubi rëy con chiꞌi mili suldadë rac shtuꞌu tsatíldill con stubi rëy. Primërë quëhúnëll llgabë si talë gúnëll gan con fuersë nanápëll lu rëy nanapë galdë mili suldadë. ");
INSERT INTO zacNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Si talë rdë́ꞌëll cuendë adë gúnëll gan, mientras zitu na rëy con galdë mili suldadë, guëshéꞌldëll rsunë lu rëy parë gac en paz, parë tsalúdiꞌi tildi rall. ");
INSERT INTO zacNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Zni nahin con lëꞌë të, el quë nadë rúnëdiꞌi renunci grë lo quë nanápëll, nídiꞌi mudë gáquëll shmëna. ");
INSERT INTO zacNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Nabënë na zedë perë si guëniti zedë sabor, ¿lla gunë nguiu guëabrí sabor shtë zedë? ");
INSERT INTO zacNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Adë rlluíꞌidiꞌin, nilë parë guëc guiuꞌu ziquë bonë, ni parë stubi cusë. Guëruꞌldë mënë zedë ni lu nezë. Si talë rac shtúꞌul tsasël, gulë bëquë́ diaguë bien shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Zihani mënë mal ziquë ra narunë cubrë impuestë nu ra pecadurë, beꞌdë biꞌguë rall lu më parë guëquë́ diaguë rall shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ra fariseo con mësë narluaꞌa lëy, guniꞌi rall cuntrë Jesús. Guniꞌi rall: ―Jesús na amigu shtënë ra pecadurë. Ria Jesús lidchi rall të gaull. ");
INSERT INTO zacNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Iurní Jesús guniꞌi comparaciuni rëꞌ lu ra contrari shtë më: ");
INSERT INTO zacNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Si talë nápël tubi gahiuꞌa lliꞌli perë guënítil tubsë ma, rsëáꞌnël los de más ra ma lachi parë tsatílil lëꞌë ma naguniti hashtë guëdzélël lëꞌë ma. ");
INSERT INTO zacNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Iurë guëdzélël lëꞌë ma, quëdchíbël ma iénil nu nalë́ rquitë ldúꞌul. ");
INSERT INTO zacNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Iurë nanul lídchil, guënáꞌbël amigu nu vëcini shtë́nël nu guëníꞌil lu rall: “Bëꞌnë compañi na tantë rquitë lduaꞌa purquë bëdzela lëꞌë ma naguniti”. ");
INSERT INTO zacNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Rniaꞌa lu të, na lëgrë lu gubeꞌe iurë tubi mënë nanapë duldë, guëabrí ldúꞌull con Dios, más lëgrë quë noventa y nueve mënë zaꞌquë nanadë rquíꞌnidiꞌi guëabrí lduꞌu rall con Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Gulë bëquë́ diaguë stubi comparaciuni. Tubi naꞌa nápëll chiꞌi munedë bëdchichi nalasac. Si talë guënítill tubsë munedë, ¿pë gúnëll? Rquëguíꞌill llni lintërnë. Rldúꞌbëll guëdubi laꞌni hiuꞌu. Rguílill bien hashtë guëdzélëll dumí. ");
INSERT INTO zacNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Iurë bëdzélëll dumí, guënáꞌbëll vëcini nu amigu shtë́nëll; rníꞌill: “Bëꞌnë compañi na purquë hia bëdzela munedë naguniti nu rquitë lduaꞌa”. ");
INSERT INTO zacNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Manërë ni rquitë lduꞌu ra ianglë iurë tubi mënë nanapë duldë, guëabrí ldúꞌull con Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","’Guzac tubi nguiu napë chupë llgáꞌniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","El quë namás nabiꞌchi guníꞌill lu shtádëll: “Dadë, rac shtuaꞌa guënéꞌel herenci narunë tucarë cahia”. Iurní gudiꞌdzë shtadë ra sultërë herenci shtë́hiꞌ. Bëdëꞌë mënë ni entrë chupë llgáꞌniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Gudëdë bëldá dzë, iurní lëꞌë ngulëꞌnë menurë bëtuuꞌll herenci. Gunáꞌzill nezë. Guall ladzë mënë zitu. Con dumí nanuáꞌall bë́ꞌnëll zihani duldë. ");
INSERT INTO zacNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hia bëgaꞌa tiempë bëshíꞌnill dumí lu ra cusë mal. Iurní gunaꞌzi tubi gubini lugar ni nu rldiaꞌnë nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Guagnáꞌbëll dchiꞌni lu nguiu naquëreldë lugar ni. Shlámëll gunibëꞌa tsaguépill guchi lachi, gau ma. ");
INSERT INTO zacNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Bëdchini galërldiaꞌnë ldúꞌull; guc shtúꞌull gaull cumidë shtë ra guchi perë ni tubi mënë bëdë́ꞌëdiꞌi nagaull. ");
INSERT INTO zacNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Iurní bëꞌa llnill. Guníꞌill: “Zihani muzë napë shtada. Rau rall hashtë napë rall de subrë, perë na gatia tantë rldiaꞌna. ");
INSERT INTO zacNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Guëabría lidchi shtada. Guëniaꞌa lúhiꞌ: Dadë, bëna duldë lul; nahia pecadurë lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Hia adë rúnëdiꞌi tucarë guëquërelda ziquë shínil. Bëꞌnë tratë na ziquë tubi muzë shtë́nël.” ");
INSERT INTO zacNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Gunaꞌzi nguiu ni nezë parë guëabrill lidchi shtádëll. ’Zitu nazéꞌdëll lídchill, guná shtádëll lull. Bëgaꞌa lduꞌu shtádëll lë́ꞌëll. Bëdchini guëlluꞌnë shtádëll lull. Bë́ꞌnëll recibir shínill con gustë. Gudë́dchill shínill. Bëtsagruaꞌll shínill. ");
INSERT INTO zacNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nguiu ni guniꞌi lu shtádëll: “Dadë, bëna duldë lul nu nahia pecadurë lu Dios. Hia adë rúnëdiꞌi tucarë guëquërelda ziquë shínil.” ");
INSERT INTO zacNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Perë shtádëll guniꞌi lu ra muzë: “Nasesë guaglliꞌi shabë záꞌquëll, lo más mejurë, gacu shinia. Guaglliꞌi tubi nigi parë guiáꞌall. Guaglliꞌi sabadu parë guëquëhin guëaꞌll. ");
INSERT INTO zacNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Gulë quini ngunë nandchú të guëdáuhaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gac laní purquë rniaꞌa guti shinia perë bëabrí nabani shinia. Bënítill perë hia bëdzélaꞌa lë́ꞌëll.” Lueguë guzublú laní. ");
INSERT INTO zacNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Guzac shini mayurë nanull lachi. Iurë bëabrill lídchill, bínill musiquë nu caguiꞌi ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Gunáꞌbëll tubi muzë. Gunaꞌbë díꞌdzëll pë runë cuntienë laní. ");
INSERT INTO zacNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Guniꞌi muzë: “Bë́chil bëabrill nabánill. Gunibëꞌa shtádël guëdini naꞌa ngunë nandchú të guëdáuhaꞌa. Bëꞌnë shtádël recibir bë́chil con gustë; nabánill.” ");
INSERT INTO zacNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Iurní lëꞌë llgaꞌnë mayurë bëldëll; në́diꞌill tsutëll laꞌni hiuꞌu. Bëruꞌu shtádëll; gunaꞌbë shtádëll lë́ꞌëll; bë́ꞌniꞌ ruëguë lull tsutëll laꞌni hiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Perë guniꞌi shini mayurë: “Blac tiempë bëna sirvë lul nu bëzuꞌbë diaga shtíꞌdzël perë nunquë bënéꞌediꞌil pë cahia, ni siquierë tubsë chivë mituꞌnë parë gac laní con amigu shtëna. ");
INSERT INTO zacNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Perë iurneꞌ bëabrí shini rë́ꞌël; bëshíꞌnill shtumil. Guagnáldëll zihani naꞌa mal. Nu lë́ꞌël gunibë́ꞌal gati ma nandchú, gau të. Gac laní.” ");
INSERT INTO zacNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Iurní guniꞌi shtádëll: “Nal shinia. Nabaninual. Grë lo quë nanapa nashtë́nël. ");
INSERT INTO zacNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Perë runë tucarë laní; gácaꞌa nalëgrë purquë bë́chil gútill perë bëabrill nabánill. Bënítill perë iurneꞌ bëdzélaꞌa lë́ꞌëll stubi.” ");
INSERT INTO zacNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Guniꞌi Jesús lu ra shini gusëꞌdë më: ―Guc tubi nguiu ricu nabëdëꞌë dchiꞌni gunë nguiu narac rguꞌ cuendë. Perë los de más muzë guagniꞌi rall lu ricu de quë lëꞌë nguiu adë bë́ꞌnëdiꞌill bien. Quëgnítill lo quë nanapë ricu. ");
INSERT INTO zacNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Lëꞌë ricu gunaꞌbë nguiu ni. Guniꞌi ricu: “¿Pë na verdá narniꞌi ra muzë? Bëꞌnë intriegu cuendë dchiꞌni nabë́ꞌnël purquë hia adë gáquël encargadë con shchiꞌnia.” ");
INSERT INTO zacNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Iurní lëꞌë nguiu bë́ꞌnëll llgabë: “¿Pë guna iurneꞌ? Hiadë nahia encargadë con shchiꞌni lamë. Rúnëdiaꞌa gan dchiꞌni ruꞌbë nu rtu lua tsaldúa guꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Guna stubi cusë parë gapa amigu nagunë recibir na lidchi rall iurë nápëdiaꞌa dchiꞌni.” ");
INSERT INTO zacNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Iurní nguiu ni gunáꞌbëll ra mënë nanazeꞌbi dumí lu lamë. Tubi rall por tubi rall bëdchini rall. Gunaꞌbë diꞌdzë nguiu lu primërë nabëdchini: “¿Blac nazéꞌbil lu lamë?” ");
INSERT INTO zacNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Bëquébill: “Nazeꞌbia tubi gahiuꞌa barrili sëiti”. Iurní guniꞌi nguiu: “Ndëꞌë na guichi pagaré shtë́nël; bëcheꞌzin nu bëntsaꞌu stubi narniꞌi nazéꞌbil cincuenta barrili sëiti”. ");
INSERT INTO zacNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Lu stubi mënë guníꞌill: “¿Blac nazéꞌbil lu lamë?” Bëquébill: “Nazeꞌbia tubi gahiuꞌa rmudi shtë trigu”. Iurní guniꞌi nguiu: “Ndëꞌë na guichi pagaré shtë́nël; bëntsaꞌu stubi pagaré narniꞌi nazéꞌbil lë́ꞌësë ochenta rmudi shtë trigu”. ");
INSERT INTO zacNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Lëꞌë lamë guniꞌi lu nguiu mal: “Nasini guë́quël. Bë́ꞌnël segurë vidë shtë́nël parë tiempë nazeꞌdë.” Ra mënë shtë guë́ꞌdchiliu quëhunë rall galënasini con ra saꞌ rall más quë ra mënë naná rialdí lduꞌi shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Mënë runë rall gan dumí con zihani maldá, perë rniaꞌa lu të, gulë bëꞌnë bien con dumí nanápël; zeꞌdë guëdchini dzë adë lasáquëdiꞌi dumí. Iurní gunë më recibir lë́ꞌël lu gubeꞌe catë nídiꞌi fin. ");
INSERT INTO zacNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’El quë narunë cumplir con duꞌpë nanápëll, gúnëll cumplir si talë nápëll zihani cusë. El quë nadë rúnëdiꞌi bien con duꞌpë, también gúnëdiꞌill bien con zihani cusë. ");
INSERT INTO zacNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Si talë adë bë́ꞌnël bien con dumí naná mal, ¿chu guëneꞌe cáꞌal lo quë nanasac de verdá? ");
INSERT INTO zacNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Si talë adë bë́ꞌnëdiꞌil bien con cusë nanádiꞌi shtë́nël, ¿chu guëneꞌe lo quë narunë tucarë cáꞌal lu gubeꞌe? ");
INSERT INTO zacNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ni tubi mënë gáquëdiꞌi gúnëll sirvë chupë lamë. Rac shtúꞌull tubsë lamë. Lu stubi lamë rúnëdiꞌill cuendë. Rzuꞌbë diáguëll shtiꞌdzë lamë, stubi lamë quëhúnëll desprëci. Nídiꞌi mudë gac shtúꞌul Dios nu mizmë tiempë gac shtúꞌul dumí. ");
INSERT INTO zacNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ra fariseo narac shtuꞌu dumí, bini rall grë naguniꞌi Jesús. Bëꞌnë rall burnë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Iurní guniꞌi Jesús lu rall: ―Lëꞌë të runë të parë rluaꞌa të nazaꞌquë lu ra mënë. Rniꞌi të lo quë naquëhunë të nazaꞌquin, perë Dios rna lla na lduꞌu të. Lo quë narac shtuꞌu mënë gapë rall lu guë́ꞌdchiliu, nahin cusë narná záꞌquëdiꞌi Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Lo quë nabëquëꞌë Moisés nu ra nabiadiꞌdzë shtiꞌdzë Dios laꞌni Sagradas Escrituras, gunibëꞌa Dios gunë mënë cumplir hashtë tiempë shtë Juan Bautista. Perë iurneꞌ na quëgniaꞌa dizaꞌquë lu të, të parë tsutë́ mënë catë rnibëꞌa Dios. Perë ra mënë nariutë́ lugar ni runë rall zihani esfuersë por tsutë́ rall. ");
INSERT INTO zacNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Más sencigi tsalú guë́ꞌdchiliu nu gubeꞌe quë tubi cusë mituꞌnë shtë lëy tsaluhin. Shtiꞌdzë Dios adë tsalúdiꞌin. ");
INSERT INTO zacNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Si talë guësaꞌnë nguiu tséꞌliꞌ nu guëtsë́ꞌall con stubi naꞌa, quëhúnëll duldë adulteri. Nu si talë stubi nguiu caꞌa lëꞌë naꞌa ni, quëhúnë nguiu ni duldë adulteri. ");
INSERT INTO zacNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Guc tubi nguiu ricu. Nácull con lari zaꞌquë nalasac zihani dumí. Grë dzë rau záꞌquëll lu laní nananú lidchi ricu. ");
INSERT INTO zacNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","También guꞌ tubi prubi lë Lázaro. Rac llúꞌull. Rátsull guëëꞌdzu. Guzúbëll ruaꞌ puertë shtë ricu. ");
INSERT INTO zacNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lázaro guc shtúꞌull nihaull pedasë guetë nagulaguë guëaꞌ mellë shtë ricu, tantë rldiaꞌnë Lázaro. Ra mbecu bëdchini; bëldeꞌe mbecu lu guëëꞌdzu ladi Lázaro. ");
INSERT INTO zacNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tubi dzë guti Lázaro. Bëdchini ra ianglë; biaꞌa raiꞌ almë shtë́hiꞌ gubeꞌe catë nanú Abraham. Nu lëꞌë ricu guti. Bëgaꞌchi ricu. ");
INSERT INTO zacNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ricu nanull lugar shtë cashtigu catë ria nanadë rialdídiꞌi lduꞌi Dios. Gubiꞌa ricu lu Abraham zitu. Guná ricu lu Lázaro nananú culaꞌni Abraham. ");
INSERT INTO zacNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Fuertë guniꞌi ricu: “Dadë Abraham, bëgaꞌa ldúꞌul na. Bësheꞌldë Lázaro; gáꞌdzëll bëcuënë shtë́nëll të parë ldaguë tubi gotë nisë lu ldudza tantë rbidchi lduaꞌa. Quëhuna sufrir laꞌni beꞌlë rëꞌ.” ");
INSERT INTO zacNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Iurní guniꞌi Abraham lu ricu: “Lë́ꞌël, ¿gu rëagná ldúꞌul lla guc vidë shtë́nël? Zihani cusë nápël; nídiꞌi nicidá de Dios. Perë Lázaro, vidë shtë́hiꞌ guc prubi. Iurní rquitë ldúꞌull mientras nanul lugar shtë cashtigu. ");
INSERT INTO zacNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Más de ni entrë lëꞌë hiaꞌa nanú tubi bërrancu. Nídiꞌi mudë guidë të ndëꞌë. Nu nídiꞌi mudë guidë mënë nananú ndëꞌë parë ngaꞌli.” ");
INSERT INTO zacNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Iurní guniꞌi ricu: “Si es quë ni, Dadë Abraham, bëꞌnë tubi favurë. Bësheꞌldë lëꞌë Lázaro lu ra bëcha. ");
INSERT INTO zacNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Napa gaꞌi bëcha naquëreldë lidchi shtada; guini rall shtiꞌdzë Lázaro. Guadíꞌdzëll lu raiꞌ lla na ra cusë të guídëdiꞌi rall ndëꞌë lugar shtë cashtigu.” ");
INSERT INTO zacNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Perë Abraham guniꞌi lu ricu: “Lëꞌë ra bë́chil napë rall lo quë nabëquëꞌë Moisés nu ra shmuzë Dios nabiadiꞌdzë shtiꞌdzë më; guëquë́ diaguë rall shtiꞌdzë raiꞌ”. ");
INSERT INTO zacNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Guniꞌi ricu: “Dadë, si talë tubi natsashtë́ ladi ra tëgulë, guëníꞌiꞌ shtiꞌdzë Dios lu rall, tsaldí lduꞌu rall. Guëabrí lduꞌu rall lu Dios iurní.” ");
INSERT INTO zacNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Guniꞌi Abraham lu ricu: “Aquëdiꞌi. Si talë runë nadzë́ꞌëdiꞌi rall mudë nanabani rall iurë rini rall shtiꞌdzë Moisés nu shtiꞌdzë ra nabiadiꞌdzë shtiꞌdzë Dios, tampuquë tsaldídiꞌi lduꞌu rall shtiꞌdzë natsashtë́ ladi ra tëgulë.” ");
INSERT INTO zacNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús guniꞌi lu ra mënë narianaldë enseñansë shtë́hiꞌ: ―Napë quë guëdchini tiempë guëquili mëdzabë lëꞌë të parë gunë të duldë, perë prubi nguiu el quë naquëhunë parë gunë mënë duldë. ");
INSERT INTO zacNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","El quë narluaꞌa tubi më humildë mal nezë gúnëll duldë, mejurë galdë nguiu ni tubi guichi ruꞌbë iénill; tsagrúꞌldëll lë́ꞌëll laꞌñi nisëduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Gulë gupë mizmë lëꞌë të. ’Si talë bë́chil gúnëll cuntrë lë́ꞌël, guniꞌi lull pë faltë nanápëll. Si talë guëabrí ldúꞌull nezë zaꞌquë, bëꞌnë perdunë lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Si talë gúnëll mal cuntrë lë́ꞌël gadchi vueltë tubi dzë nu gadchi vueltë guëabrí guëníꞌill lul: “Hia adë gúnëdiꞌiruaꞌa cuntrë lë́ꞌël”, napë quë gúnël perdunë lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ra poshtë guniꞌi raiꞌ lu Jesús: ―Bëꞌnë compañi lëꞌë naꞌa të tsaldí lduꞌu naꞌa lë́ꞌël más. ");
INSERT INTO zacNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Guniꞌi Jesús: ―Si talë rialdí lduꞌu të shtiꞌdza suduꞌpë, masiá duꞌpë ziquë tubi bëꞌdchi biꞌchi, zac guëníꞌil lu hiaguë sicómoro nazubë ndëꞌë: “Bíꞌeshi de ndëꞌë nu bëcabní mizmë lë́ꞌël laꞌñi nisëduꞌu”, si talë tsaldí ldúꞌul Dios, lëꞌë hiaguë guëzuꞌbë diaguin shtíꞌdzël. ");
INSERT INTO zacNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Si talë napë të tubi muzë nabëabrí lídchil; guaguénëll u guaguépill ra ma lachi, iurë bëdchínill hiuꞌu adë guëníꞌidiꞌil lull: “Gudëdë gaul lueguë”. ");
INSERT INTO zacNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aquëdiꞌi. Guëníꞌil lull: “Bëꞌnë preparar nagauha nu guatibi guiáꞌal; bëꞌnë sirvë lu mellë gauha nu guaꞌ. Despuësë gaul; gul.” ");
INSERT INTO zacNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Si lëꞌë muzë quëhúnëll lo quë narnibë́ꞌal, adë guëníꞌidiꞌil: “Dushquíllil”. ");
INSERT INTO zacNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Zni lëꞌë të, despuësë de bëꞌnë të cumplir grë lo quë narnibëꞌa Dios gunë mënë, gulë guniꞌi: “Na naꞌa muzë nalasáquëdiꞌi. Bëdëꞌnë naꞌa sulamëntë lo quë nabëꞌnë tucarë guëdëꞌnë naꞌa.” ");
INSERT INTO zacNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Guaglaꞌguë ziaꞌa Jesús nezë Jerusalén. Gudëdë më regiuni naná entrë Samaria nu Galilea. ");
INSERT INTO zacNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Iurë guagbiꞌguë më tubi guëꞌdchi, bëdzaꞌguëlú më chiꞌi mënë narac lluꞌu galguidzë ruꞌdzë ládiꞌ. Zitu bëaꞌnë rall. ");
INSERT INTO zacNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Fuertë guniꞌi rall: ―Jesús, Mësë, bëgaꞌa ldúꞌul lëꞌë naꞌa; bënëac lëꞌë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús guná lu rall nu guniꞌi më: ―Gulë tsagná lëꞌë bëshuzi të guënall lu të. Iurní nianá ziaꞌa rall, mizmë iurní bëac rall. ");
INSERT INTO zacNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tubi de lëꞌë rall iurë guná lla bëáquëll, bëabrill lu Jesús. Guníꞌill fuertë, dushquilli Dios por favurë nabëꞌnë më. ");
INSERT INTO zacNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bëzullíbill lu Jesús hashtë bëdchini luquëll lu guiuꞌu. Bëdë́ꞌëll graci lu më. Nguiu ni na më Samaria. ");
INSERT INTO zacNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iurní guniꞌi Jesús: ―Chiꞌi nguiu narac lluꞌu bënëaca. ¿Gua rall? ");
INSERT INTO zacNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Túbsëll bëabrí, bëdë́ꞌëll graci lu Dios. Nall de stubi naciuni. ");
INSERT INTO zacNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Iurní guniꞌi më lu nguiu: ―Guasuldí. Guziaꞌa con bien. Bëáquël purquë rialdí ldúꞌul na. ");
INSERT INTO zacNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ra fariseo gunaꞌbë diꞌdzë rall lu Jesús, guc guëdchini tiempë naguënibëꞌa Dios ziquë Rëy. Jesús repi: ―Iurë guëdchini tiempë naguënibëꞌa Dios, adë guëdchínidiꞌin con sëñi naguëná të. ");
INSERT INTO zacNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Adë guëníꞌidiꞌi mënë: “Ndëꞌë rnibëꞌa më ziquë Rëy”, u “Ndë rnibëꞌa më”; purquë hia neꞌ rnibëꞌa më bëldá mënë naquëreldë entrë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Iurní guniꞌi Jesús lu ra shini gusëꞌdë më: ―Guëdchini tiempë lëꞌë të gac shtuꞌu të guëná të lua, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. Guëdchinia perë lëdë guënádiꞌi të lua lueguë. ");
INSERT INTO zacNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mënë guëniꞌi lu të: “Ndëꞌë bëdchíniꞌ”, u “Ndë bëdchíniꞌ”. Adë tsagnádiꞌi të lëꞌë rall. Adë rianáldëdiꞌi të tëchi rall, ");
INSERT INTO zacNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","purquë ziquë rdchini nguziꞌu; rluaꞌa llni dizdë ladë ldi hashtë guiaꞌa ladë rubësë, zni guëdchinia. Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Antsë gac ra cusë ni, guna sufrir galguti. Ra mënë tiempë neꞌ guëquë́ guiaꞌa rall na. ");
INSERT INTO zacNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ziquë bëꞌnë mënë shtë guë́ꞌdchiliu tiempë shtë Noé, zni gunë rall antsë guëdchinia stubi. ");
INSERT INTO zacNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Gudáu rall. Biiꞌ rall. Bëtsëꞌa rall. Guc laní shtë lliguë hashtë Noé guatë́ laꞌni barcu ruꞌbë. Iurní bëdchini juici shtë nisë guëc rall. Grë mënë guti. ");
INSERT INTO zacNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Zni guc también tiempë shtë Lot. Gudáu ra mënë. Biiꞌ rall. Bëtuuꞌ rall. Guziꞌi rall. Bëcabní rall. Bëzaꞌa rall lidchi rall. ");
INSERT INTO zacNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Perë iurë Lot bëruꞌu ciudá Sodoma, gulaguë guiꞌi dzë ni. Gulaguë asufrë narieꞌqui dizdë gubeꞌe nu grë mënë guti. ");
INSERT INTO zacNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ziquë bëꞌnë mënë tiempë shtë Lot, zni gunë rall iurë guëdchinia, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. Guëná ra mënë lua. ");
INSERT INTO zacNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Dzë ni si talë tubi de lëꞌë të nanú guëc hiuꞌu, adë tsutë́diꞌil laꞌni hiuꞌu parë guáꞌal lo quë nanápël. Si talë tubi de lëꞌë të nanú të lachi dzë ni, adë guëabrídiꞌil parë guáꞌal cusë nanápël. ");
INSERT INTO zacNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gulë bëagná lduꞌu të pë guc tseꞌlë Lot. ");
INSERT INTO zacNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","El quë nanë́diꞌi guëneꞌe vidë shtë́nëll por na, segurë guënítill vidë shtë́nëll; perë el quë naguëniti vidë shtë́niꞌ por na, guëbánill parë siemprë. ");
INSERT INTO zacNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Dzë naguëdchinia, nanú chupë mënë lu camë. Túbsëll guënaꞌbë Dios tsall gubeꞌe. Stúbill guëaꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chupë naꞌa caniuꞌu juntë. Túbsëll guënaꞌbë më tsall gubeꞌe. Stúbill guëaꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Chupë nguiu nanú lachi. Túbsëll guënaꞌbë më tsall gubeꞌe. Stúbill guëaꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iurë bini ra shini gusëꞌdë më diꞌdzë rëꞌ, gunaꞌbë diꞌdzë raiꞌ: ―Dadë, ¿guc gac ra cusë ni? Guniꞌi më tubi dichë: ―Iurë gac ra cusë ni, gac bëꞌa të seguramëntë, igual ziquë rac bëꞌa të rdëá ra bëchu catë nagaꞌa naguti. ");
INSERT INTO zacNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús guniꞌi tubi comparaciuni parë gac bëꞌa shmënë më runë tucarë guadiꞌdzënú rall Dios guëdubi tiempë, de quë adë guëzalúdiꞌi rall pacënci parë guënaꞌbë rall lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Guniꞌi më: ―Guc tubi juësi naguquëreldë guëꞌdchi. Adë gualdídiꞌi ldúꞌull Dios nu adë bë́ꞌnëdiꞌill rëspëti saꞌll. ");
INSERT INTO zacNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mizmë guëꞌdchi guquëreldë tubi viudë nanapë dishiꞌbi con stubi narunë cuntrë lë́ꞌëll. Guagnaꞌbë viudë lu juësi parë gac rëglë asuntë shtë́nëll según lëy. Guniꞌi viudë: “Bëꞌnë rëglë asuntë con contrari shtëna”. Zihani vueltë guagná viudë lëꞌë juësi. ");
INSERT INTO zacNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Në́diꞌi juësi gúnëll rëglë asuntë ni, perë despuësë bëꞌnë juësi llgabë: “Adë rialdídiꞌi lduaꞌa Dios nu nápëdiaꞌa rëspëti parë mënë, ");
INSERT INTO zacNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","perë viudë rëꞌ riaglaꞌguë guënáꞌbëll lua. Guna rëglë asuntë shtë́nëll të adë tsalúdiꞌi pacënci shtëna tantë rbézëdiꞌi ridëll lua.” ");
INSERT INTO zacNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iurní Jesús guniꞌi: ―Gulë bëdëꞌë cuendë naguniꞌi juësi mal. Mucho más gunë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Gunë më juzguë ra contrari shtë mënë narialdí lduꞌi Dios. Gunë më compañi ra nariaglaꞌguë guënaꞌbë rall lu më dzë la gueꞌlë. Adë gac ldëꞌë më parë gunë më lo quë narnaꞌbë rall lu më. ");
INSERT INTO zacNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Rniaꞌa lu të, iurë rgaꞌa iurë adë gac ldëꞌë më sino gunë më jushtici. Perë guënaꞌbë diꞌdza lu të, ¿iurë guëabrí nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, niaꞌa zëdzéliꞌ ra narialdí lduꞌi Dios iurní? ");
INSERT INTO zacNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Guniꞌi Jesús stubi comparaciuni lu ra narunë llgabë nabënë na rall perë bëꞌnë rall desprëci saꞌ rall. Guniꞌi më: ");
INSERT INTO zacNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Chupë nguiu guagniꞌinú rall Dios iáduꞌu ruꞌbë. Túbill na më fariseo; stúbill na el quë narunë cubrë impuestë. ");
INSERT INTO zacNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Lëꞌë fariseo guasuldill; guníꞌill laꞌni ldúꞌull diꞌdzë rëꞌ: “Dadë gullanë, dushquíllil, rdë́ꞌëhia graci nádiaꞌa ziquë na ra mënë. Nádiaꞌa ziquë ra ngubaꞌnë. Nádiaꞌa ziquë narniꞌi bishi. Nádiaꞌa ziquë ra nanapë stubi naꞌa. Dushquíllil nádiaꞌa ziquë nguiu ndëꞌë narunë cubrë impuestë. ");
INSERT INTO zacNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Runa ayunë chupë vueltë laꞌni llmalë. Rdëꞌa tubi por cadë chiꞌi ra cusë, grë lo quë narunë tucarë caꞌa Dios.” ");
INSERT INTO zacNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Perë lëꞌë nguiu narunë cubrë impuestë zugáꞌall ruaꞌ puertë shtë iáduꞌu. Adë rbíꞌadiꞌill guiaꞌa. Guníꞌill: “Dadë, bëgaꞌa ldúꞌul na. Napa zihani duldë.” ");
INSERT INTO zacNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Rniaꞌa lu të, lëꞌë pecadurë bëabrill lídchill limpi. Bëzunë́ Dios almë shtë́nëll, lë́dëdiꞌi lëꞌë fariseo. El quë narunë naruꞌbë, guëláguëll con shtu perë el quë narunë narúꞌbëdiꞌi, gunë Dios honrar lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Guanú mënë zihani llguëꞌnë lu Jesús parë guëdchiꞌbë më guiaꞌa më guëc rall. Perë shini gusëꞌdë më guná raiꞌ, gudildi raiꞌ naguanú lëꞌë ra llguëꞌnë lu Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Perë guniꞌi më; gunaꞌbë më ra llguëꞌnë: ―Gulë bëdëꞌë sí, guidë ra llguëꞌnë lua. Adë rcádiꞌi të guidë ra llguëꞌnë lua purquë cagnibëꞌa Dios lëꞌë ra mënë naná ziquë ra llguëꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Guldía rniaꞌa lu të; sulë el quë nagunë recibir Dios ziquë Rëy të guënibëꞌa Dios lë́ꞌëll cumë ziquë tubi llguëꞌnë; rquitë lduꞌu llguëꞌnë rnibëꞌa Dios lë́ꞌëll, sulë nguiu ni guëbánill lugar catë na më Rëy. ");
INSERT INTO zacNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tubi nguiu narnibëꞌa ladi guëꞌdchi, gunaꞌbë díꞌdzëll lu Jesús: ―Mësë zaꞌquë, ¿pë rníꞌil guna parë gac salvara parë gapa vidë sin fin? ");
INSERT INTO zacNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Guniꞌi Jesús lull: ―¿Pëzielú rníꞌil nahia nazaꞌquë? Nanú tubsë naná nazaꞌquë. Náhiꞌ Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Bien nanël ra mandamientë: “Adë rquënúdiꞌil tseꞌlë mënë. Adë rguínidiꞌil saꞌl. Adë cuánëdiꞌil pë shtë mënë. Adë rníꞌidiꞌil bishi. Bëzuꞌbë diaguë shtiꞌdzë shtádël nu shníꞌal.” ");
INSERT INTO zacNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nguiu guniꞌi: ―Grë mandamientë ni bëna cumplir dizdë nabiꞌcha. ");
INSERT INTO zacNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Bini Jesús diꞌdzë rëꞌ nu guniꞌi më: ―Tubi cusë runë faltë. Bëtuuꞌ grë cusë nanápël, bëdëꞌëin caꞌa ra prubi, iurní gápël tesurë lu gubeꞌe. Nu gudeꞌe naldë na të gáquël shmëna. ");
INSERT INTO zacNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Iurë lëꞌë nguiu ni bini shtiꞌdzë Jesús, bëáꞌnëll tristë purquë de verdá nall ricu. ");
INSERT INTO zacNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Guná Jesús lull; nalë́ bëdchini tristë laꞌni lduꞌu më. Guniꞌi më: ―Naganë tubi nanapë zihani dumí, gúnëll recibir Dios ziquë rëy. ");
INSERT INTO zacNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Más sencigi tsutë́ tubi ma camellë ichi iagullë quë tubi ricu tsutëll catë rnibëꞌa Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ra mënë nabini diꞌdzë ni, gunaꞌbë diꞌdzë: ―Si es quë ni, ¿chu gac salvar? ");
INSERT INTO zacNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Guniꞌi më: ―Adë gúnëdiꞌi nguiu gan gunë salvar mizmë lë́ꞌiꞌ perë Dios napë pudërë gunë më grë́tëꞌ ra cusë. ");
INSERT INTO zacNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Iurní Pedro guniꞌi lu Jesús: ―Dadë, lëꞌë naꞌa bësëaꞌnë naꞌa grë́tëꞌ parë zeꞌdë naldë naꞌa lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Guniꞌi Jesús: ―Guldía, el quë nabësëaꞌnë lídchiꞌ, shtádiꞌ, shníꞌaiꞌ u bë́chiꞌ, u tséꞌliꞌ, u shíniꞌ purquë rac shtúꞌull guënibëꞌa Dios lë́ꞌëll, ");
INSERT INTO zacNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","gúnëll recibir zihani cusë más neꞌ laꞌñi vidë shtë́hiꞌ, nu guëquëréldëll parë siemprë tubi vidë sin fin con Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Gunaꞌbë Jesús ra poshtë tubi ladë. Guniꞌi më lu raiꞌ: ―Iurneꞌ guziá hiaꞌa Jerusalén. Gac cumplir grë lo quë nabëquëꞌë ra nabiadiꞌdzë shtiꞌdzë Dios de na, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gunë ra mënë intriegu na lu guiaꞌa shtë mënë nanádiꞌi më israelitë. Gunë rall burnë; guëniꞌi guidzë rall na. Guëchiꞌbë shënë rall lua. ");
INSERT INTO zacNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Guëneꞌe rall galnë́ na, despuësë gatia. Perë dzë tsunë tsashtë́a ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ra poshtë adë guasë́diꞌi raiꞌ shtiꞌdzë më, nacahin parë lëꞌë raiꞌ. Adë bëdë́ꞌëdiꞌi raiꞌ cuendë pë runë cuntienë shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Guabiꞌguë raiꞌ guëꞌdchi Jericó. Nanú tubi ciegu nazubë lu nezë. Cagnáꞌbëll guꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bini ciegu gudëdë zihani mënë. Gunaꞌbë diꞌdzë ciegu pë quëhac. ");
INSERT INTO zacNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Guniꞌi mënë: “Jesús nazareno ziazúhiꞌ nezë”. ");
INSERT INTO zacNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Iurní ciegu fuertë guniꞌi: ―Jesús, llëbní David, bëgaꞌa ldúꞌul na. ");
INSERT INTO zacNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ra mënë naziaꞌa delantë, guniꞌi rall guëc ciegu parë guëac dchi ciegu perë másruꞌu guniꞌi ciegu. Fuertë guníꞌill: ―Llëbní David, bëgaꞌa ldúꞌul na. ");
INSERT INTO zacNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iurní Jesús guzudchí. Gunibëꞌa më tsaglliꞌi raiꞌ lëꞌë ciegu. Bëdchini ciegu lu më. Guniꞌi më lull: ");
INSERT INTO zacNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Pë rac shtúꞌul guna? Repi ciegu: ―Rac shtuaꞌa, Dadë, guënéꞌel slua. ");
INSERT INTO zacNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Guniꞌi më: ―Nia. Bëáquël purquë rialdí ldúꞌul na. ");
INSERT INTO zacNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mizmë iurní bëac ciegu. Guanáldëll lëꞌë Jesús. Bëdë́ꞌëll graci lu Dios. Grë ra mënë guniꞌi rall llëruꞌbë na pudërë shtë Dios, purquë guná rall pë bëꞌnë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iurní Jesús guatë́ guëꞌdchi Jericó. Mërë guëruꞌu më guëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ladi guëꞌdchi ni guc tubi ricu lë Zaqueo. Nall jëfë narunë cubrë impuestë. ");
INSERT INTO zacNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Guc shtuꞌu Zaqueo guënall lu Jesús perë gúnëdiꞌill gan tantë zihani mënë gudëdë, nu nadupë shcuerpë Zaqueo. ");
INSERT INTO zacNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Iurní Zaqueo bëlluꞌnë delantë. Güéꞌpill ladi tubi hiaguë sicómoro parë guënall lu më. Hiaguë ni zubi culaꞌni nezë catë zeꞌdë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bëdchini më lugar ni; guná më lu Zaqueo. Guniꞌi më lull: ―Zaqueo, bietë nasesë. Napë quë guënéꞌel pusadë lídchil, guëana. ");
INSERT INTO zacNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Lueguë bietë Zaqueo nasesë. Nalë́ bëquitë ldúꞌull. Bë́ꞌnëll recibir Jesús lídchill. ");
INSERT INTO zacNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Guná mënë guanú Jesús Zaqueo. Guaglaꞌguë guniꞌi rall cuntrë Jesús. Guniꞌi rall Jesús gua visitë lidchi tubi pecadurë. ");
INSERT INTO zacNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Iurní guasuldí Zaqueo. Guníꞌill lu Dadë Jesús: ―Dadë, guëruldë nanapa guëdë́ꞌëhia caꞌa ra nabënápëdiꞌi. Nu si talë bëdchisúa dumí shtë mënë con bishi, guëabría tapë vueltë más dumí caꞌa rall. ");
INSERT INTO zacNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Guniꞌi Jesús: ―Nedzë́ nasalvárël. Salvaciuni bëdchini lídchil. Nu lë́ꞌël guc Abraham shtadë guëlul. ");
INSERT INTO zacNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu parë quilia el quë nabëniti parë gac salvárëll. ");
INSERT INTO zacNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Riaglaꞌguë rini ra mënë shtiꞌdzë Jesús. Hia mërë guëdchini raiꞌ ciudá Jerusalén. Nu quëhunë mënë llgabë runë faltë duꞌpsë parë guënibëꞌa Dios ziquë Rëy. ");
INSERT INTO zacNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Iurní guniꞌi më tubi comparaciuni: ―Guc tubi nguiu shini rëy; bërúꞌull ládzëll. Ziáꞌall stubi naciuni parë gúnëll recibir pudërë ziquë rëy parë guënibë́ꞌall. Despuësë guëabrill ládzëll. ");
INSERT INTO zacNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Antsë bërúꞌull ládzëll, gunáꞌbëll chiꞌi muzë naná encargadë shchíꞌnill. Bëdë́ꞌëll dumí lasac cadë tubi de lëꞌë ra muzë. Guniꞌi shini rëy: “Gulë bëꞌnë bien con dumí rëꞌ. Gulë guziꞌi; gulë bëtuuꞌ, hashtë guëabría.” Iurní guziáꞌall. ");
INSERT INTO zacNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Perë ra mënë naquëreldë ladzë nguiu ni bëldë́ rall; rac shtúꞌudiꞌi rall gáquëll rëy shtë rall. Bësheꞌldë rall rsunë narniꞌi: “Adë rac shtúꞌudiꞌi naꞌa gac nguiu rëꞌ rëy shtë naꞌa”. ");
INSERT INTO zacNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Perë nguiu ni bë́ꞌnëll recibir ziquë rëy shtë rall. Bëabrill ládzëll. Gunáꞌbëll ra muzë nabëcaꞌa dumí të guëná rëy bëldá bëꞌnë rall gan guëc dumí. ");
INSERT INTO zacNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Primërë muzë bëdchini nu guníꞌill lu rëy: “Dadë, shtumil ndëꞌë con chiꞌi vueltë más shini dumí”. ");
INSERT INTO zacNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Lëꞌë rëy guniꞌi: “Bien bë́ꞌnël con duꞌpë dumí. Iurní guënehia pudërë guënibë́ꞌal chiꞌi guëꞌdchi. Muzë zaꞌquë nal.” ");
INSERT INTO zacNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Stubi muzë bëdchini guníꞌill: “Dadë, shtumil ndëꞌë con gaꞌi vueltë más shini dumí”. ");
INSERT INTO zacNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Guniꞌi rëy lull: “Guënibë́ꞌal gaꞌi guëꞌdchi”. ");
INSERT INTO zacNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Stubi muzë bëdchini nu guníꞌill: “Dadë, ndëꞌë lëꞌë shtumil. Bëquëtsaꞌuin tubi panitë. ");
INSERT INTO zacNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bëdzëba lë́ꞌël. Nal nguiu nargáꞌadiꞌi lduꞌu mënë. Rcáꞌal lo quë nabëdchíꞌbëdiꞌil nu rcáꞌal cusechë sin adë rcabnídiꞌil.” ");
INSERT INTO zacNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Iurní guniꞌi rëy lull: “Nal mal. Con mizmë shtíꞌdzël guna juzguë lë́ꞌël. Guníꞌil nahia el quë nargáꞌadiꞌi lduꞌu mënë nu rcahia lo quë nabëdchíꞌbëdiaꞌa nu rcahia catë rcabnídiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Pëzielú adë bësëáꞌnëdiꞌil shtumía lu bancu parë gapa shini dumí iurë bëdchinia?” ");
INSERT INTO zacNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Iurní guniꞌi rëy lu mënë nazugaꞌa ngaꞌli: “Gulë bëdchisú dumí shtë nguiu nabëquëꞌë dumí panitë. Nu bëdëꞌëin caꞌa nabëꞌnë gan chiꞌi tantë dumí.” ");
INSERT INTO zacNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Guniꞌi ra mënë: “Dadë, hia nápëll chiꞌi dumí”. ");
INSERT INTO zacNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Lëꞌë rëy guniꞌi: “Rniaꞌa lu të, el quë nanapë, gúnëll recibir más perë el quë nabënápëdiꞌi, guëdchisú lëꞌë duꞌpë nanápëll. ");
INSERT INTO zacNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Perë lëꞌë ra enemigu shtëna ra nanë́diꞌi guënibë́ꞌahia lëꞌë rall, gulë tsaglliꞌi lëꞌë rall ndëꞌë. Gulë quini lëꞌë rall lua.” ");
INSERT INTO zacNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Despuësë de guniꞌi Jesús diꞌdzë rëꞌ, guaglaꞌguë ziagdchini më parë Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bëdchini më guëꞌdchi Betfagé nu Betania nanaquë́ lu lumë catë nanú zihani hiaguë olivo. Bësheꞌldë më shini gusëꞌdë më; ");
INSERT INTO zacNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","guniꞌi më lu raiꞌ: ―Gulë gua guëꞌdchi naná guëlladchi. Iurë guëdchini të, guëná të lu tubi burrë. Quëdú ma. Lëꞌë burrë ni laꞌdi chu quíbëdiꞌi tëchi ma. Gulë bëshaꞌquë ma nu gudeꞌenú ma ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Si talë guënaꞌbë diꞌdzë mënë pë gunë të burrë, gulë guniꞌi lull: “Lëꞌë Dadë Jesús rquiꞌni lëꞌë ma”. ");
INSERT INTO zacNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Gua ra shini gusëꞌdë më. Bëdzelë raiꞌ burrë igual cumë zíquësë guniꞌi më lu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Iurë bëshaꞌquë raiꞌ burrë, nashtënë burrë gunaꞌbë díꞌdzëll: ―¿Pëzielú bëshaꞌquë të shpurra? ");
INSERT INTO zacNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bëquebi raiꞌ: ―Purquë Dadë Jesús rquiꞌni lëꞌë ma. ");
INSERT INTO zacNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Guanú raiꞌ burrë lu Jesús. Bëdchiꞌbë raiꞌ shabë raiꞌ tëchi ma parë quibë Jesús tëchi ma. ");
INSERT INTO zacNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Iurë lëꞌë burrë ziazú lu nezë, gudishi mënë shabë rall lu nezë catë zeꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Bëdchini ra mënë lumë shtë dani catë nezë rlaguetë. Grë ra narianaldë tëchi më guzublú guëniꞌi rall llëruꞌbë na pudërë shtë Dios. Bëꞌnë rall alabar lëꞌë më por milagrë naguná rall. ");
INSERT INTO zacNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Guniꞌi rall: ―Bëꞌnë ldaiꞌ Dios lëꞌë Rëy ndëꞌë, el quë nazeꞌdë guëdchini por nombre shtë Dadë Dios. Llëruꞌbë na Dios nacabezë más guiaꞌa lu gubeꞌe; tsu paz lu gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Iurní bëldá fariseo nananú ladi zihani mënë guniꞌi rall lu Jesús: ―Mësë, guniꞌi lu ra shmë́nël të adë guëníꞌidiꞌi rall diꞌdzë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Perë Jesús guniꞌi lu ra fariseo: ―Rniaꞌa lu të, si talë ra mënë guëac dchi, ra guëꞌë rëꞌ guërushtiá; guëniꞌi rahin diꞌdzë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iurë bëdchini më guëlladchi Jerusalén, gubiꞌa më lu ciudá. Biꞌni më. ");
INSERT INTO zacNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Guniꞌi më: ―Mizmë lëꞌë të më Jerusalén, rac shtuaꞌa lëꞌë të niac bëꞌa të nezë catë rbedchí lduꞌu mieti con Dios, perë iurneꞌ nacahi slu të parë tsasë́ të ra cusë ni. ");
INSERT INTO zacNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Guëdchini cusë durë guëc të. Enemigu shtë të guëzubë grë ladë shtë ciudá parë tildi rall. Guntsaꞌu rall tubi luꞌ alrededurë guëdubi guëꞌdchi, tsu guërru cuntrë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Guëcué rall grë hiuꞌu shtë të. Quini rall lëꞌë të hashtë nu shini të gati raiꞌ. Adë guëáꞌnëdiꞌi tubi guëꞌë quibë guëc saꞌ guëꞌë. Completamente tsaluhin; ziquë tubi hiuꞌu dachi guëaꞌnin purquë adë bëdë́ꞌëdiꞌi të cuendë iurë bëꞌnë më favurë parë lëꞌë të gac salvar të. ");
INSERT INTO zacNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iurní Jesús guatë́ laꞌni iáduꞌu ruꞌbë. Guzublú cagsëllúꞌniꞌ ra nacagtuuꞌ laꞌni iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Guniꞌi më lu rall: ―Sagradas Escrituras rniꞌi shtiꞌdzë Dios: “Iáduꞌu shtëna na parë gunë mieti orar lu Dios, perë lëꞌë të bëꞌnë të cambi iáduꞌu ziquë cuevë shtë ngubaꞌnë”. ");
INSERT INTO zacNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Grë dzë bëluaꞌa Jesús laꞌni iáduꞌu. Ra bëshuzi narnibëꞌa más con ra mësë shtë lëy con los de más më naruꞌbë shtë guëꞌdchi, gudili rall formë lla gati më. ");
INSERT INTO zacNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Perë bëdzélëdiꞌi rall mudë nianaꞌzi rall lëꞌë më purquë grë ra mënë con ánimo rac shtuꞌu rall rquë diaguë rall pë guniꞌi më. ");
INSERT INTO zacNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tubi dzë nanú Jesús iáduꞌu ruꞌbë. Quëgluaꞌa më ra mënë shtiꞌdzë Dios lla mudë tsutë́ rall shnezë Dios të gac salvar rall. Iurní bëdchini ra bëshuzi narnibëꞌa más con mësë shtë lëy con më gushë narunë juzguë; ");
INSERT INTO zacNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","guniꞌi rall lu më: ―Guniꞌi lu naꞌa. ¿Pë derechë nápël parë guëluáꞌal ra mënë? ¿Chu bëneꞌe permisi rúnël grë cusë nabë́ꞌnël? ");
INSERT INTO zacNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Guniꞌi Jesús lu rall: ―Nu na guënaꞌbë diꞌdza lu të. Rac shtuaꞌa guëniꞌi të lua. ");
INSERT INTO zacNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Chu bëdëꞌë derechë lëꞌë Juan Bautista parë guëchuꞌbë nísiꞌ; Dios u mënë? ¿Chu bësheꞌldë lë́ꞌiꞌ? ");
INSERT INTO zacNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Iurní guzublú quëgniꞌi rall entrë de lëꞌë rall. Guniꞌi rall lu saꞌ rall: ―¿Pë guëniꞌi hiaꞌa lu Jesús? Si talë guëniꞌi hiaꞌa Dios bësheꞌldë lëꞌë Juan, iurní guëníꞌill lu hiaꞌa: “¿Pëzielú adë gualdídiꞌi lduꞌu të shtíꞌdziꞌ?” ");
INSERT INTO zacNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Si talë guëniꞌi hiaꞌa mënë bësheꞌldë lëꞌë Juan, iurní guëneꞌe guëꞌë mënë lëꞌë hiaꞌa, gátiaꞌa purquë grë mënë rialdí lduꞌu rall guniꞌi Juan shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Por ni bëquebi rall lu Jesús de quë adë bëdë́ꞌëdiꞌi rall cuendë chu bësheꞌldë lëꞌë Juan parë guëchuꞌbë nísiꞌ ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iurní guniꞌi Jesús lu rall: ―Lëꞌë të rquébidiꞌi të; nu na adë guëquébidiaꞌa chu bësheꞌldë na; chu bëneꞌe permisi guna ra cusë. ");
INSERT INTO zacNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Guzublú guniꞌi më lu ra mënë comparaciuni rëꞌ: ―Guc tubi nguiu nabëcabní hiaguë uvë lachi. Despuësë bëdë́ꞌëll mëdi stubi mënë nu guziáꞌall zitu. Gudëdë tiempë. ");
INSERT INTO zacNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bëgaꞌa iurë shtë cusechë, bëshéꞌldëll tubi muzë; guënaꞌbë muzë partë narunë tucarë shlámëll. Perë ra mënë gunaꞌzi rall lëꞌë muzë. Bëdëꞌë rall galnë́. Bësëlluꞌnë rall muzë sin adë bë bëdë́ꞌëdiꞌi rall. ");
INSERT INTO zacNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Iurní bësheꞌldë shlamë rall stubi muzë, tsaglliꞌi muzë cusechë. Perë ra mënë guniꞌi diꞌdzë dzabë lu muzë nu bëdëꞌë rall galnë́. Bësëlluꞌnë rall muzë sin adë bë bëdë́ꞌëdiꞌi rall. ");
INSERT INTO zacNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Lamë ni bësheꞌldë stubi muzë perë ra mënë gudini rall lëꞌë muzë. Gulú rall lëꞌë muzë tantë bëldë́ rall. ");
INSERT INTO zacNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Iurní guniꞌi lamë shtë guiuꞌu: “¿Pë guna iurneꞌ? Guësheꞌlda shinia narac shtuaꞌa. Iurë guëná ra mënë lúhiꞌ, tal vez gunë rall rëspëti shinia.” ");
INSERT INTO zacNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Perë iurë guná ra mënë narunë dchiꞌni lu shini lamë, guniꞌi rall lu saꞌ rall: “Ndëꞌë naguëcaꞌa herenci. Cha díniaꞌa lë́ꞌëll të iurní gácaꞌa nashtë́ guiuꞌu.” ");
INSERT INTO zacNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Iurní gulú rall shini lamë lu guiuꞌu stubi ladë. Gudini rall lë́ꞌiꞌ. Iurní guniꞌi Jesús lu ra mënë: ―¿Pë gunë nashtë́ guiuꞌu con ra naquëhunë dchiꞌni? ");
INSERT INTO zacNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mizmë lamë guëdchini parë quínill ra mënë mal, leꞌ. Guëdë́ꞌëll guiuꞌu caꞌa stubi mënë. Iurní bini ra mënë comparaciuni rëꞌ, guniꞌi rall lu Jesús: ―Ni lo quiera Dios gac zni. ");
INSERT INTO zacNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Perë Jesús gubiꞌa lu rall, guniꞌi më: ―Gulë guniꞌi lua pë runë cuntienë nanaquë́ laꞌni Sagradas Escrituras. Rniꞌin zndëꞌë: Guëꞌë nabëruꞌldë ra albañil tubi ladë, guëꞌë rëꞌ gunë sirvë parë gac shquini shtë iáduꞌu ruꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","El quë narreldë guëc guëꞌë rëꞌ, gac chupë ldëll, perë iurë ldaguë guëꞌë ni guëc mënë, gáquëll ziquë pulvë. ");
INSERT INTO zacNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ra jëfë shtë bëshuzi con mësë shtë lëy rac shtuꞌu rall guënaꞌzi rall lëꞌë Jesús lueguë. Guc bëꞌa rall guniꞌi më comparaciuni ni cuntrë lëꞌë rall. Adë gunáꞌzidiꞌi rall lëꞌë më purquë bëdzëbë rall los de más mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Iurní bësheꞌldë rall mënë naguagldaꞌchi lëꞌë Jesús. Rluaꞌa rall ziquë mënë zaꞌquë. Rac shtuꞌu rall guësiguë́ rall lëꞌë më nianiꞌi më tubi cusë mal parë gunë rall intriegu lëꞌë më lu gubiernë rumanë. ");
INSERT INTO zacNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Por ni naguagldaꞌchi lëꞌë Jesús, gunaꞌbë diꞌdzë rall: ―Mësë, nanë́ naꞌa rluáꞌal nu rníꞌil purë verdá. Rluáꞌal igual lu mënë humildë nu lu mënë narnibëꞌa. Guldil, quëgluáꞌal lla tsutë́ mënë shnezë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Guniꞌi lu naꞌa, ¿pë na bien guëdilli hiaꞌa impuestë lu rëy rumanë u guëdíllidiꞌi hiaꞌa impuestë? ");
INSERT INTO zacNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Perë Jesús bëdëꞌë cuendë niasiguë́ rall lëꞌë më. Guníꞌiꞌ: ");
INSERT INTO zacNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Gulë bëluaꞌa tubi dumí. ¿Chu lu nu chu lë naquë́ lu dumí? Bëquebi rall: ―Lu rëy César naquë́ lu dumí. ");
INSERT INTO zacNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Guniꞌi më iurní: ―Nia, por ni gulë bëdëꞌë caꞌa rëy César lo quë nashtë́ César, nu gulë bëdëꞌë caꞌa Dios lo quë nashtë́ Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Adë bëꞌnë ra contrari shtë Jesús gan nianiꞌi më cusë mal lu ra mënë. Bëdzëguëëꞌ lduꞌu ra mënë ni; bëaꞌnë dchi rall. ");
INSERT INTO zacNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Iurní bëldá nguiu religiusë saduceos, guagná rall lëꞌë Jesús. Ra saduceos rniꞌi adë tsashtë́diꞌi tëgulë ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Perë gunaꞌbë diꞌdzë rall lu Jesús: ―Mësë, bëquëꞌë Moisés tiempë guahietë si tubi nguiu gati sin shíniꞌ, bëchi tëgulë napë quë guëtsë́ꞌall tseꞌlë tëgulë. Gapë rall shíniꞌ parë adë tsalúdiꞌi shfamili tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Guc gadchi bëchi. Primërë nguiu bëtsë́ꞌall perë gútill sin ni tubi shínill. ");
INSERT INTO zacNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Segundë bëchi tëgulë bëtsë́ꞌall con viudë perë gútill sin ni tubi shínill. ");
INSERT INTO zacNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tecërë bëchi tëgulë bëtsë́ꞌall tseꞌlë tëgulë. Nu gútill; pues hashtë shuꞌpë bëchi tëgulë bëtsëꞌa rall tseꞌlë tëgulë. Gúdiꞌi shini raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Despuësë guti naꞌa ni. ");
INSERT INTO zacNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Guniꞌi lu naꞌa, iurë tsashtë́ tëgulë, ¿chu gac tseꞌlë naꞌa cumë gadchi nguiu guc tseꞌlë naꞌa ni? ");
INSERT INTO zacNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iurní Jesús bëquebi: ―Iurneꞌ lu guë́ꞌdchiliu ra nguiu, ra naꞌa, rtsëꞌa rall, ");
INSERT INTO zacNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","perë grë ra naguëdëꞌë Dios permisi tsutë́ rall stubi guë́ꞌdchiliu nu tsashtë́ raiꞌ ladi ra tëgulë, adë guëtsë́ꞌadiꞌi raiꞌ. Adë rnádiꞌi raiꞌ guëtsëꞌa shini raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nunquë gátidiꞌi raiꞌ. Na raiꞌ ziquë ra ianglë shtë gubeꞌe. Na raiꞌ shini Dios iurní, purquë guashtë́ raiꞌ ladi ra tëgulë, guëbani raiꞌ parë siemprë. ");
INSERT INTO zacNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Perë si talë rnaꞌbë diꞌdzë të tsashtë́ ra tëgulë ladi ra tëgulë, gulë bëdëꞌë cuendë lo quë Moisés bëquëꞌë laꞌni histuri shtë hiaguë narëuldë. Bëquëꞌë Moisés de quë Dadë Dios na Dios shtë Abraham, nu Isaac, nu Jacob; nu blac tiempë guti raiꞌ parë tiempë dzë ni. ");
INSERT INTO zacNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Grë shmënë Dios nabani aunquë hia guti raiꞌ. Napë raiꞌ vidë sin fin. ");
INSERT INTO zacNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Iurní bëldá mësë shtë lëy guniꞌi rall: ―Mësë, bien bëquébil lu rall. ");
INSERT INTO zacNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hia bëdzëbë rall guënaꞌbë diꞌdzë rall más lu Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús guniꞌi lu rall: ―¿Llallë rniꞌi mënë Cristo na shini David? ");
INSERT INTO zacNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","purquë mizmë David guniꞌi laꞌni librë nalë Salmos: Dadë Dios guniꞌi lu Shtada narnibëꞌa: Guzubë ladë ldi shtëna ");
INSERT INTO zacNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hashtë guna gan lu enemigu shtë́nël të guëzuꞌbë diaguë rall shtíꞌdzël. ");
INSERT INTO zacNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Lla na posiblë gac Cristo shini David, cumë mizmë David rniꞌi Cristo na Dadë narnibëꞌa lë́ꞌiꞌ? ");
INSERT INTO zacNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Iurë grë mënë caquë́ diaguë rall shtiꞌdzë Jesús, guniꞌi më lu ra shini gusëꞌdë më: ");
INSERT INTO zacNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Gulë gupë cuidadë ra mësë shtë lëy. Rëuuꞌ lduꞌu rall nacu rall lari duni. Rac shtuꞌu rall gunë mënë saludar lëꞌë rall con zihani rëspëti lu nezë. Rdzelë rall guëzubë rall lugar mejurë laꞌni iáduꞌu. Rac shtuꞌu rall lugar shtë rëspëti lu mellë. ");
INSERT INTO zacNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Perë rdchisú rall lidchi viudë, pero parë guësiguë́ rall mënë, quëhunë rall oraciuni ruꞌbë. Rniaꞌa lu të gunë rall recibir más cashtigu dushë. ");
INSERT INTO zacNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Laꞌni iáduꞌu guná Jesús ra ricu, bëtiaꞌa rall dumí laꞌni cajë shtë ofrendë. ");
INSERT INTO zacNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nu tubi viudë prubi guná më; bëtiáꞌall chupë centavë. ");
INSERT INTO zacNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Guniꞌi më: ―Guldía, lëꞌë viudë prubi bëdëꞌë más quë ra ricu. ");
INSERT INTO zacNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Grë mënë bëdëꞌë nabëꞌnë subrë perë naꞌa rëꞌ bëdë́ꞌëll grë nanápëll, grë nasíꞌill gaull. ");
INSERT INTO zacNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ruadiꞌdzë mënë lla na iáduꞌu ruꞌbë. Blac chulë na ra guëꞌë nu blac chulë na ra regalë nabëzëlaaꞌdchi ra mënë parë iáduꞌu. Iurní Jesús guniꞌi: ");
INSERT INTO zacNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Guëdchini tiempë grë lo quë naquëgná të neꞌ, cue. Ni tubi guëꞌë quibë guëc sádiꞌin. ");
INSERT INTO zacNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iurní gunaꞌbë diꞌdzë raiꞌ lu më: ―Mësë, ¿guc gac ra cusë narníꞌil lu naꞌa? ¿Pë sëñi nanú naguëluaꞌa guëlladchi na tiempë gac cumplir shtíꞌdzël? ");
INSERT INTO zacNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Guniꞌi Jesús: ―Gulë gupë mizmë lëꞌë të, adë guësiguë́diꞌi mënë lëꞌë të. Zihani mënë guëdchini ziquë shmëna. Guëniꞌi rall: “Nahia Cristo”; u guëniꞌi rall: “Hia bëgaꞌa iurë guënibëꞌa Dios ziquë Rëy”. Perë rniaꞌa lu të, adë tsanáldëdiꞌi të tëchi shtiꞌdzë rall. ");
INSERT INTO zacNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Iurë ruadiꞌdzë mënë nanú zihani guërru nu rdzatsu mënë cuntrë gubiernë, adë rdzë́bëdiꞌi të. Grë cusë ni napë quë gac cumplir perë runë faltë parë guënibëꞌa Dios ziquë rëy. ");
INSERT INTO zacNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Guaglaꞌguë guniꞌi më: ―Gac cumplir tubi naciuni tildi cuntrë stubi naciuni. Tubi gubiernë tildi cuntrë stubi gubiernë. ");
INSERT INTO zacNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Guëllú nadushë iurní. Guëdchini gubini dushë nu galguidzë zihani lugar. Lu gubeꞌe guëluaꞌa cusë nadzëꞌbë nu sëñi ruꞌbë guëluaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Antsë gac cumplir ra cusë ni, gunë mënë cuntrë lëꞌë të. Guënaꞌzi rall lëꞌë të parë gunë rall juzguë lëꞌë të laꞌni iáduꞌu shtë të. Guëldaguë rall lëꞌë të lachiguiꞌbë. Gunë rall demandë lëꞌë të lu gubiernë nu lu rëy purquë na të shmëna. ");
INSERT INTO zacNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Zni gunë të gan guëniꞌi të lu ra gubiernë dizaꞌquë shtëna. ");
INSERT INTO zacNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Adë ráquëdiꞌi lduꞌu të; adë gúnëdiꞌi të llgabë pë guëniꞌi të iurní, ");
INSERT INTO zacNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","purquë na guënehia diꞌdzë parë guëniꞌi të lu gubiernë. Guna compañi lëꞌë të hashtë enemigu shtë të guëac dchi lu të; nápëdiꞌi rall pë guëniꞌi rall cuntrë lëꞌë të iurní. ");
INSERT INTO zacNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Gunë mënë intriegu lëꞌë të gati të, bëldá të. Shtadë të gúnëll intriegu lëꞌë të. Bëchi të, shfamili të nu ra amigu shtë të gunë rall intriegu lëꞌë të, gati të. ");
INSERT INTO zacNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Grë mënë guëldënú rall lëꞌë të purquë na të shmëna; rialdí lduꞌu të na. ");
INSERT INTO zacNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Perë pë gáquëdiꞌi të; ni tubi guitsë guëc të tsalúdiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Si talë gac të firmë lu shnezë Dios, gapë të vidë nadë rialúdiꞌi parë siemprë. ");
INSERT INTO zacNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Iurë guëná të lu suldadë grë ladë ciudá Jerusalén, hia mërë cue ciudá. ");
INSERT INTO zacNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","El quë nananú Judea dzë ni, guëllúꞌnëll parë lu dani. El quë nananú ciudá Jerusalén, guëruꞌu rall. El quë nananú lachi adë guëabrídiꞌill guëꞌdchi, ");
INSERT INTO zacNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","purquë ra dzë rëꞌ na shtë cashtigu. Grë lo quë naescritë laꞌni Sagradas Escrituras gac cumplirin. ");
INSERT INTO zacNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Prubi ra naꞌa nanuaꞌa shíniꞌ u ra naꞌa narcaꞌa meꞌdë dzë ni. Gunë mënë israelitë sufrir lu cashtigu shtë Dios. Cusë durë gac con mënë tiempë neꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bëldá mënë gati rall lu guërru. Stubi tantë tsa rall guëdubi naciuni ziquë prësi; gunë rall dchiꞌni shtë stubi mënë. Ra mënë zitu guënibëꞌa rall Jerusalén naná cue hashtë gac cumplir tiempë nabëꞌnë Dios disponer. Jerusalén guëaꞌnë ziquë hiuꞌu dachi. ");
INSERT INTO zacNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Dzë ni guëluaꞌa sëñi lu gubeꞌe con ngubidzë, mbelëguiꞌi, nu mbehu. Lu guë́ꞌdchiliu grë mënë shtë ra naciuni adë gáquëdiꞌi pë gunë rall nu adë rbedchí lduꞌu rall por cusë nadzëꞌbë. Guini rall ruidë shtë nisëduꞌu tantë rniꞌbi nisë. ");
INSERT INTO zacNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Iurní guëcahi mënë por tantë galërdzëbë nu galriá lduꞌi por cashtigu naguëdchini. Ra fuersë shtë gubeꞌe guëniꞌbi rahin shlugarin. ");
INSERT INTO zacNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Iurní guëná ra mënë lua, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. Guëdchinia laꞌni shcahi. Guëdchininúa con zihani puderë nu llni. ");
INSERT INTO zacNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Iurë guëná të ra cusë guëzublú gac, gulë gubiꞌa lu gubeꞌe; gulë tsaldí lduꞌu të purquë hia mërë gunë më salvar lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Guniꞌi më tubi comparaciuni: ―Gulë guná lu hiaguë higu u cualquier stubi hiaguë. ");
INSERT INTO zacNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Iurë lëꞌë ndiaguë rënë rruꞌu, rdëꞌë të cuendë hia mërë guëdchini tiempë naꞌi. ");
INSERT INTO zacNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Zni iurë guëná të ra cusë mal guëdchini, gulë gac bëꞌa të hia mërë guëdchini tiempë naguënibëꞌa Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Guldía rniaꞌa lu të, grëhin gac cumplir antsë gati ra mënë naquëreldë tiempë neꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Gubeꞌe nu guë́ꞌdchiliu tsalú rahin perë shtiꞌdza napë quë gac cumplir. Adë tsalúdiꞌi shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Gulë gubani guëdubi tiempë. Adë rdëꞌë të lugar gapë të vici. Adë rzuuꞌdchidiꞌi të. Adë ráquëdiꞌi lduꞌu të por nagáu të purquë si talë quëhúnël ra cusë ni, adë gac bë́ꞌadiꞌi të naquëhac. ");
INSERT INTO zacNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ziquë rldaguë lasë mënë tubi ma, zni guëdchini ra cusë durë guëc ra mënë narëtaꞌ lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Por ni, gulë cue nasini nu gulë gunaꞌbë lu Dios guëdubi iurë të gunë më compañi lëꞌë të, guëruꞌu të ladi ra cusë dushë sin adë bë gáquëdiꞌi të. Gulë guëaꞌnë nasini parë iurë guëdchinia, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu; tsasuldí të lua. ");
INSERT INTO zacNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús bëluaꞌa ra mënë laꞌni iáduꞌu ruꞌbë rdzë perë gueꞌlë ria më lu dani shtë Olivos parë guëaꞌnë më hashtë brëgueꞌlë. ");
INSERT INTO zacNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Grë mënë bëdchini iáduꞌu tumpranë të guini rall shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hia mërë guëdchini laní Pascu, iurë rëagná lduꞌu mënë tiempë nabëꞌnë Dios librar ra israelitë de Egipto. Dzë ni adë gudáudiꞌi rall guetështildi nanapë levadurë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ra jëfë shtë bëshuzi con ra mësë shtë lëy gudili rall mudë quini rall lëꞌë Jesús nagaꞌchi purquë bëdzëbë rall mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Iurní Satanás guatë́ laꞌni lduꞌu Judas Iscariote, tubi poshtë shtë më entrë chiꞌbë chupë ra poshtë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Guagniꞌi Judas lu ra jëfë shtë ra bëshuzi con los de más më ruꞌbë shtë iáduꞌu. Guniꞌi Judas lla gúnëll intriegu lëꞌë më guiaꞌa rall. ");
INSERT INTO zacNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bëquitë lduꞌu rall; bëꞌnë rall prometer guëdëꞌë rall dumí caꞌa Judas. ");
INSERT INTO zacNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Bëaꞌnë Judas de acuerdë nu gudílill mudë parë gúnëll intriegu lëꞌë Jesús nagaꞌchi iurë nídiꞌi mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Iurní bëdchini dzë shtë laní, gudáu ra mënë guetështildi sin levadurë. Mizmë dzë bëꞌnë tucarë quini rall tubi lliꞌli shtë Pascu. ");
INSERT INTO zacNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iurní bësheꞌldë Jesús lëꞌë Pedro nu Juan; guniꞌi më lu raiꞌ: ―Guaguëꞌnë preparar shtse shtë Pascu, guëdáuhaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Gunaꞌbë diꞌdzë raiꞌ: ―¿Ca lu rac shtúꞌul guëdëꞌnë naꞌa preparar shtse shtë laní? ");
INSERT INTO zacNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús guniꞌi lu raiꞌ: ―Gulë gua guëꞌdchi. Iurë guëdchini të ruaꞌ guëꞌdchi, guëdzaꞌguëlú të tubi nguiu nanuaꞌa tubi rëëꞌ nisë. Gulë guanaldë lë́ꞌëll. Gulë tsutë́ catë tsutëll. ");
INSERT INTO zacNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Gulë guniꞌi lu nashtënë hiuꞌu: “Lëꞌë mësë cagnaꞌbë diꞌdzë lul; ¿ca na cuartë catë gáuhiꞌ shtse shtë laní con poshtë shtë́hiꞌ?” ");
INSERT INTO zacNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Iurní guëluaꞌa nashtë́ hiuꞌu tubi cuartë ruꞌbë segundë pisë. Arregladë nahin. Gulë bëꞌnë preparar ndë pë cusë guëdáuhaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Gua Pedro nu Juan. Bëdzelë raiꞌ grë cusë ziquë guniꞌi më. Bëꞌnë raiꞌ preparar shtse shtë laní, gau raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bëgaꞌa iurë shtë shtse, Jesús guzubënúhiꞌ lëꞌë ra poshtë lu mellë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Guniꞌi më lu raiꞌ: ―Con guëdubinú lduaꞌa rac shtuaꞌa guëdáuha shtse shtë Pascu con lëꞌë të antsë gatia, ");
INSERT INTO zacNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","purquë adë gáudiaꞌa shtse shtë Pascu stubi hashtë gac cumplir grë lo quë narunë cuntienë shtse Pascu; gac cumplirin iurë guënibëꞌa Dios ziquë Rëy. ");
INSERT INTO zacNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iurní gunaꞌzi më tubi vasë shtë vini. Bëdëꞌë më graci lu Dios nu guniꞌi më: ―Gulë gudiꞌdzë nu gulë biiꞌ vini rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Adë guaꞌ vini stubi vueltë hashtë iurë guënibëꞌa Dios ziquë Rëy. ");
INSERT INTO zacNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Iurní gunaꞌzi më guetështildi. Bëdë́ꞌëiꞌ graci lu Dios nu gudiꞌdzë mëhin cuaꞌa ra poshtë. Guniꞌi më: ―Ndëꞌë lëꞌë shcuerpa naguna intriegu lu galguti parë gac salvar të. Gulë gau, nu gulë bësëagná lduꞌu të galguti shtëna. ");
INSERT INTO zacNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Iurë gualú shtse, gunaꞌzi më vasë shtë vini; bëdëꞌë më graci, bëdëꞌë më vasë ni guiaꞌa ra poshtë nu guniꞌi më: ―Ndëꞌë na tëstë cubi entrë lëꞌë të nu Dios. Guëruꞌu shrëna parë lasac tëstë ni. ");
INSERT INTO zacNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Perë guná, lëꞌë nguiu nagunë intriegu na, zubënull na lu mellë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu napë quë ziáꞌaiꞌ nezë narunë tucarë según voluntá shtë Dios, perë prubi nguiu nagunë intriegu na lu galguti. ");
INSERT INTO zacNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Iurní ra poshtë gunaꞌbë diꞌdzë lu saꞌ raiꞌ, chull gunë intriegu lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ra poshtë gudildi diꞌdzë chu na más më ruꞌbë entrë lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Guniꞌi Jesús lu raiꞌ: ―Ra rëy shtë naciuni nalë́ nadushë rnibëꞌa rall, nu rac shtuꞌu rall guëniꞌi mënë de quë na rall më zaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Perë entrë lëꞌë të adë nazáꞌquëdiꞌi quëhunë të llgabë zni. El quë na más më ruꞌbë entrë lëꞌë të, napë quë gáquëll ziquë na más nalasáquëdiꞌi. El quë narnibëꞌa entrë lëꞌë të, gáquiꞌ ziquë el quë narunë sirvë lu saꞌll. ");
INSERT INTO zacNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Chu na más më naruꞌbë, el quë nazubë lu mellë gaull primërë, u el quë narunë sirvë lu mellë? El quë nazubë lu mellë, leꞌ; perë na, nahia ziquë mënë narunë sirvë entrë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Lëꞌë të rianú të na. Adë bësëáꞌnëdiꞌi të na sino bëꞌnë të sufrir con na. ");
INSERT INTO zacNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ziquë Shtada bëneꞌe pudërë guënibë́ꞌahia ziquë Rëy, zni rnéꞌehia pudërë caꞌa të, guënibëꞌa të con pudërë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Guëzubë të lu trunë catë rnibë́ꞌahia parë gunë të juzguë guëzá chiꞌbë chupë grupë shtë naciuni Israel. ");
INSERT INTO zacNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nu guniꞌi Jesús lu Pedro: ―Moni, Moni, Satanás gunaꞌbë permisi lu Dios, gúnëll prëbë lë́ꞌël të ldáguël lu duldë; gaquin ziquë rgu rnërë mënë lluꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Perë bëna ruëguë lu Dios por lë́ꞌël parë adë gúnëdiꞌi faltë fe parë tsaldí ldúꞌul Dios. Rniaꞌa lul, despuësë ra prëbë, iurë guëabrí ldúꞌul con Dios, bëꞌnë compañi ra narialdí lduꞌi dizaꞌquë parë gac rall firmë lu shnezë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón Pedro guniꞌi lu Jesús: ―Dadë, adë guësëáꞌnëdiaꞌa lë́ꞌël. Guna compañi lë́ꞌël hashtë lachiguiꞌbë nu nilë hashtë gatia con lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Guniꞌi Jesús iurní: ―Bedë, antsë guëllidchí gay, gúnël negar na tsunë vueltë. Guëníꞌil lu ra mënë adë guënë́diꞌil na. ");
INSERT INTO zacNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iurní Jesús gunaꞌbë díꞌdziꞌ lu poshtë: ―Iurë bësheꞌlda lëꞌë të parë guëniꞌi të dizaꞌquë lu ra mënë, adë nuáꞌadiꞌi të bulsë. Adë nuáꞌadiꞌi të bëdu dumí, adë nuáꞌadiꞌi të sabadu. ¿Pë bëꞌnë faltë lëꞌë të iurní? Bëquebi raiꞌ: ―Ni tubi cusë bë́ꞌnëdiꞌi faltë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Iurní guniꞌi më: ―Pues iurneꞌ el quë nanapë bulsë, guaꞌain. El quë nanapë bëdu dumí, guáꞌall dumí. El quë nadë nápëdiꞌi spadë, guëtuuꞌll manguë të síꞌill tubi spadë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Rniaꞌa lu të, rquiꞌni gac cumplir diꞌdzë rëꞌ lo quë naná escritë laꞌni Sagradas Escrituras: “Bëꞌnë mënë tratë lë́ꞌiꞌ cumë ziquë narguini mënë”. Vidë shtëna mërë tsaluhin. Runë faltë duꞌpë parë gac cumplir grë naná escritë de na. ");
INSERT INTO zacNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iurní guniꞌi raiꞌ: ―Dadë, ndëꞌë napë naꞌa chupë spadë. Guniꞌi më: ―Hia naꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iurní guziaꞌa më. Gua më lu dani shtë Olivos ziquë bëꞌnë më grë ra gueꞌlë. Ra shini gusëꞌdë më guanaldë raiꞌ lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bëdchini raiꞌ lu dani. Guniꞌi më lu raiꞌ: ―Gulë gunaꞌbë lu Dios të gunë më compañi lëꞌë të parë ldáguëdiꞌi të lu duldë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Iurní gua më lë́ꞌësë më tubi distanci ziquë narldaꞌa nguiu tubi guëꞌë. Bëzullibi më. Iurní biadiꞌdzënú më Dios, Shtadë më. ");
INSERT INTO zacNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Guniꞌi më: ―Dadë, bëlá lëꞌë na lu sufrimientë rëꞌ si talë na voluntá shtë́nël, perë bëꞌnë lo quë narac shtúꞌul lë́dëdiꞌi lo quë narac shtuaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Iurní bëdchini tubi ianglë shtë gubeꞌe. Bëdëꞌë ianglë fuersë parë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Más fuertë bëꞌnë më sufrir, se entiende, sufrimientë lduꞌu më. Guniꞌinú më Dios con más diꞌdzë. Rdzu nisë lúhiꞌ ziquë gotë ruꞌbë shtë rënë narlaguë lu guiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Iurní gualú biadiꞌdzënú më Dios, bëabrí më catë nanú ra poshtë. Bëdzelë më lëꞌë raiꞌ nagaꞌsi raiꞌ, tantë bëdzaguë raiꞌ purquë nalë́ riá lduꞌu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Guniꞌi më lu raiꞌ: ―¿Pëzielú nagaꞌsi të? Gulë guashtë́ ngaꞌli. Gulë gunaꞌbë lu Dios të gunë më compañi lëꞌë të parë ldáguëdiꞌi të lu duldë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nianá cagniꞌi më, bëdchini zihani mënë. Judas, tubi poshtë shtë më, nall cabësë shtë ra mënë. Guabiꞌguë Judas lu Jesús parë guëtsagruaꞌll lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Guniꞌi më lu Judas: ―Judë, ¿pë con tubi dchidu gúnël intriegu na? nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ra mënë nanaldë Jesús guná raiꞌ pë quëhac. Gunaꞌbë diꞌdzë raiꞌ lu më: ―Dadë, ¿zëdildi naꞌa con spadë nadiaꞌa naꞌa? ");
INSERT INTO zacNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tubi de lëꞌë raiꞌ gulull spadë. Bëchúguëll diaguë ldi shtë muzë. Muzë ni bëꞌnë sirvë lu narnibëꞌa más entrë grë ra bëshuzi. ");
INSERT INTO zacNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Guniꞌi Jesús: ―Hia naꞌ. Adë tíldidiꞌi të. Iurní Jesús bëgaꞌldë diaguë muzë. Bënëac më lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iurní guníꞌiꞌ lu ra jëfë shtë bëshuzi con mënë naquëhapë iáduꞌu ruꞌbë; guniꞌi më lu më gushë nabëdchini të guënaꞌzi rall lëꞌë më: ―¿Pëzielú bëdchini të con spadë nu hiaguë parë zeꞌdë guëlliꞌi të na cumë ziquë ngubaꞌnë? ");
INSERT INTO zacNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Dzë con dzë zugáꞌahia con lëꞌë të iáduꞌu ruꞌbë perë adë gunáꞌzidiꞌi të na iurní. Perë hia bëgaꞌa iurë según voluntá shtë Dios; gunë të narac shtuꞌu të, nu bëgaꞌa iurë parë gac cumplir grë lo quë narnibëꞌa lu nacahi, gúnëll cuntrë na. ");
INSERT INTO zacNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Iurní ra mënë gunaꞌzi lëꞌë Jesús prësi. Guanú rall lë́ꞌiꞌ lidchi jëfë shtë ra bëshuzi. Perë guanaldë Pedro zitu. ");
INSERT INTO zacNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ra mënë bëcueꞌe rall guiꞌi rualdëaꞌ lidchi bëshuzi. Rac naldë iurní. Guzubë rall grë ladë guiꞌi nu Pedro guzubënúhiꞌ lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Iurní tubi criadë guná lu Pedro, guzúbiꞌ guëlladchi ruaꞌ guiꞌi. Gubiꞌa naꞌa lu Pedro nu guníꞌill: ―Nguiu rëꞌ na shmënë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Perë Pedro bëꞌnë negar, guníꞌiꞌ: ―Guënë́diaꞌa nguiu niꞌi. ");
INSERT INTO zacNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Gudëdë stuꞌpë tiempë, stubi mënë guná lu Pedro nu guníꞌill: ―Nu lë́ꞌël nal shmënë Jesús. Perë Pedro guniꞌi: ―Aquëdiꞌi. Nádiaꞌa shmënë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tubi iurë gudëdë. Stubi mënë guníꞌiruꞌull: ―Na verdá, nguiu rëꞌ nall shmënë Jesús purquë nu nall më Galilea. ");
INSERT INTO zacNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Iurní guniꞌi Pedro: ―Lë́ꞌël adë guënë́diaꞌa pë quëadíꞌdzël. Nianá quëadiꞌdzë Pedro, bëllidchí gay. ");
INSERT INTO zacNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Iurní Jesús bëdchigrë́ lúhiꞌ. Gubíꞌaiꞌ lu Pedro. Bëagná lduꞌu Pedro naguniꞌi më lull: “Antsë guëllidchí gay nedzë́, guëníꞌil lu mënë tsunë vueltë adë guënë́diꞌil na”. ");
INSERT INTO zacNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Iurní bëruꞌu Pedro ruaꞌ puertë shtë nezë, nalë́ bíꞌniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ra nguiu narnaꞌzi Jesús guzublú bëꞌnë rall burnë. Bëdëꞌë rall galnë́ lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bësëꞌau rall lúhiꞌ nu guniꞌi rall: ―¿Chu bëneꞌe galnë́ lë́ꞌël? Guniꞌi por pudërë shtë Dios, ¿chu lëa? ");
INSERT INTO zacNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Zihani cusë mal guniꞌi rall lu më. Guaglaꞌguë bëꞌnë rall burnë lëꞌë më con diꞌdzë dzabë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hia brëgueꞌlë bëdëá më gushë shtë naciuni Israel con ra jëfë shtë bëshuzi nu ra mësë shtë lëy. Grë rall guaꞌa rall lëꞌë Jesús lu Junta Suprema, mënë narunë juzguë entrë lëꞌë rall. Guniꞌi ra mënë ni lu Jesús: ");
INSERT INTO zacNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Guniꞌi lu naꞌa si talë nal Cristo, el quë nagudili Dios parë guënibë́ꞌaiꞌ. Guniꞌi Jesús lu rall: ―Si guëniaꞌa lu të nahia Cristo, adë tsaldídiꞌi lduꞌu të na. ");
INSERT INTO zacNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Si talë guënaꞌbë diꞌdza lu të, guëquébidiꞌi të lu shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Dizdë neꞌ lëꞌë nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, guëzúbiꞌ ladë ldi shtë Dios pudërusë. ");
INSERT INTO zacNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Lueguë grë mënë gunaꞌbë diꞌdzë rall: ―¿Pë lë́ꞌël nal tubsë shini Dios? Guniꞌi më lu rall: ―Guldía nahia tubsë shini Dios. Mizmë lëꞌë të guniꞌi të diꞌdzë ni. ");
INSERT INTO zacNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Iurní guniꞌi rall: ―Bini hiaꞌa diꞌdzë naguníꞌill. ¿Pë guëdë́ꞌnaꞌa másruꞌu testigu? ");
INSERT INTO zacNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Iurní lueguë ra contrari shtë Jesús guaꞌa rall lëꞌë më lu Pilato. ");
INSERT INTO zacNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Guzublú guëniꞌi rall; quëdchiꞌbë rall galquiá cuntrë Jesús: ―Bëdzelë naꞌa nguiu rëꞌ; rtsátsull ra mënë cuntrë gubiernë. Rníꞌill rúnëdiꞌi tucarë guëdilli naꞌa impuestë caꞌa gubiernë rumanë. Nu rníꞌill mizmë lë́ꞌëll na Cristo, tubi rëy nagudili Dios parë guënibë́ꞌaiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Iurní gunaꞌbë diꞌdzë Pilato: ―¿Guldil nal Rëy shtë ra israelitë? Jesús guniꞌi: ―Mizmë lë́ꞌël guníꞌil diꞌdzë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato guniꞌi lu ra jëfë shtë ra bëshuzi con grë ra mënë zihani: ―Bëdzélëdiaꞌa cusë mal nabëꞌnë nguiu rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Perë guníꞌiruꞌu rall más fuertë: ―Rtsátsull grë mënë shtë Judea con shtíꞌdzëll. Bëluáꞌall më Galilea primërë, iurní ndëꞌë cagluáꞌall cuntrë gubiernë rumanë. ");
INSERT INTO zacNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Iurë bini Pilato diꞌdzë rëꞌ, gunaꞌbë díꞌdzëll si na Jesús më Galilea. ");
INSERT INTO zacNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Guniꞌi mënë quë sí, iurní bësheꞌldë Pilato lëꞌë Jesús lu Herodes, gubernadurë shtë Galilea, gac rëglë asuntë ni. Pues Herodes nanú Jerusalén dzë ni. ");
INSERT INTO zacNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bëquitë lduꞌu Herodes iurë gunall lu Jesús purquë dizdë más antsë guc shtuꞌu Herodes guënall lu Jesús. Guniꞌi mënë pë bëꞌnë Jesús, nu Herodes guc shtúꞌull guënall tubi milagrë naquëhunë më. ");
INSERT INTO zacNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Zihani cusë gunaꞌbë diꞌdzë Herodes perë Jesús pë guníꞌidiꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","También zugaꞌa ndë ra jëfë shtë bëshuzi nu ra mësë narluaꞌa lëy. Bëdchiꞌbë rall galquiá con másruꞌu diꞌdzë. Gurushtiá rall cuntrë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Iurní Herodes con ra suldadë shtë́nëll bëꞌnë rall burnë lëꞌë më. Cumë burnë bëgacu rall lëꞌë më con lari zaꞌquë. Despuësë bësheꞌldë Herodes lëꞌë Jesús, guëabrí më lu Pilato. ");
INSERT INTO zacNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dzë ni guc Herodes nu Pilato amigu purquë antsë na rall enemigu. ");
INSERT INTO zacNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bëtëá Pilato ra jëfë shtë bëshuzi con ra më gushë shtë iáduꞌu con grë mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Guniꞌi Pilato lu rall: ―Lëꞌë të beꞌdënú të lëꞌë nguiu rëꞌ. Guniꞌi të rtsátsull ra mënë con bishi. Gunaꞌbë diꞌdza lull delantë grë të perë bëdzélëdiaꞌa cusë mal nabë́ꞌnëll ziquë rniꞌi të. Nápëdiꞌill ni tubi delitë. ");
INSERT INTO zacNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nu Herodes bëdzélëdiꞌill cusë mal purquë bëdchigrë́ Herodes lë́ꞌëll ndëꞌë. Adë bë́ꞌnëdiꞌill ni tubi mal parë gátill. ");
INSERT INTO zacNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Guënibë́ꞌahia tsanull galnë́, despuësë guëdëꞌa libertá lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilato napë custumbrë guëdë́ꞌëll libertá tubi prësi cadë laní Pascu, el quë naguënaꞌbë mënë gapë libertá. ");
INSERT INTO zacNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Perë guaglaꞌguë guníꞌiruꞌu mënë ziquë tubsë bë; fuertë guniꞌi rall: ―Gati nguiu rëꞌ. Bëdëꞌë libertá parë Barrabás. ");
INSERT INTO zacNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Pues Barrabás nanú lachiguiꞌbë purquë gúquëll cabësë shtë ra mënë nabëꞌnë cuntrë gubiernë rumanë. Nu gudínill mënë laꞌni ciudá. ");
INSERT INTO zacNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato guc shtúꞌull guëdë́ꞌëll libertá Jesús. Guniꞌi Pilato stubi lu mënë, ");
INSERT INTO zacNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","perë más fuertë guniꞌi rall: ―Gati nguiu rëꞌ lu cruz. Gátill; gátill. ");
INSERT INTO zacNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Stubi vueltë guniꞌi Pilato lu ra mënë: ―¿Pë mal bë́ꞌnëll? Gulë guniꞌi lua. Bëdzélëdiaꞌa cusë mal parë gátill. Guna cashtigu con galnë́ lë́ꞌëll, despuësë guëdëꞌa libertá lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Perë más ruidë bëꞌnë rall. Gurushtiá rall. Gunaꞌbëruꞌu rall galguti parë lëꞌë më. Guniꞌi rall fuertë hashtë bëꞌnë rall gan. ");
INSERT INTO zacNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato bëdëꞌë ordë gac narac shtuꞌu rall; gati Jesús lu cruz. ");
INSERT INTO zacNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Bëdëꞌë Pilato libertá Barrabás naná culpablë de galguti shtë mënë nu bë́ꞌnëll cuntrë gubiernë rumanë. Zni gunaꞌbë ra mënë. Bëꞌnë Pilato intriegu lëꞌë Jesús guiaꞌa ra contrari shtë më të gac narac shtuꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Iurë biaꞌa rall lëꞌë Jesús nezë parë gati më, gudëdë tubi nguiu lë Simón, më guëꞌdchi Cirene. Zeꞌdë guëzëll lachi. Ra suldadë gunaꞌzi lëꞌë Simón parë guáꞌall cruz nezë tëchi më. ");
INSERT INTO zacNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Zihani mënë con zihani naꞌa guanaldë rall lëꞌë më. Biꞌni ra naꞌa tantë gubini lduꞌu rall. Gurushtiá rall. ");
INSERT INTO zacNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Perë Jesús bëdchigrë́ lúhiꞌ, guná më lu rall; guniꞌi më: ―Lëꞌë të naꞌa shtë Jerusalén, adë bíꞌnidiꞌi të por na, más bien gulë biꞌni por mizmë lëꞌë të nu por shini të. ");
INSERT INTO zacNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Guëdchini tiempë guëniꞌi mënë: “Dichusë ra naꞌa nariúdiꞌi shíniꞌ. Dichusë ra naꞌa nadë nua shínidiꞌi, nu adë rcáꞌadiꞌi meꞌdë.” Nu guniꞌi më: ");
INSERT INTO zacNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","―Dzë ni ra mënë guëzublú guëniꞌi rall lu dani: “Gulaguë guëc naꞌa”. Guëniꞌi rall lu lumë: “Bëcaꞌchi lëꞌë naꞌa”. ");
INSERT INTO zacNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Si talë gunë mënë cuntrë na, nahia ziquë hiaguë nanabani; nápëdiaꞌa duldë, gunë rall másruꞌu cusë mal cuntrë lëꞌë të, na të ziquë hiaguë bidchi, napë të zihani duldë. ");
INSERT INTO zacNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","También guaꞌa ra suldadë chupë ngubaꞌnë, gatinú rall Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Iurní bëdchini rall lugar nalë́ Calavera. Bëꞌnë rall crucificar lëꞌë më. Bëꞌnë rall crucificar lëꞌë chupë ngubaꞌnë, túbill ladë ldi më, stúbill ladë rubësë. ");
INSERT INTO zacNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iurní guniꞌi Jesús: ―Dadë, bëꞌnë perdunë lëꞌë ra mënë. Adë riasë́diꞌi rall pë quëhunë rall. Nu ra suldadë gudchitë rall guëꞌë dado parë gudiꞌdzë rall shabë më. ");
INSERT INTO zacNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ra mënë zugaꞌa; gubiꞌa rall lu më. Ra më gushë shtë iáduꞌu bëꞌnë rall burnë. Guniꞌi rall: ―Bë́ꞌnëll salvar pecadurë. Iurneꞌ guëná hiaꞌa niaꞌa zúnëll salvar mizmë lë́ꞌëll si talë nall Cristo, el quë nagudili Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ra suldadë bëꞌnë rall burnë. Guabiꞌguë rall guëaꞌ cruz. Bëꞌnë rall ofrecërë vini hiꞌ të gu më. ");
INSERT INTO zacNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Guniꞌi rall: ―Si talë rníꞌil nal Rëy shtë mënë Israel, bëꞌnë salvar mizmë lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nanú tubi letrërë naquë́ guëc cruz narniꞌi: “Ndëꞌë na Rëy shtë më israelitë”. ");
INSERT INTO zacNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tubi ngubaꞌnë nanaquë́ lu cruz, gurushtiall guëc më; guníꞌill: ―Si talë rníꞌil nal Cristo, bëꞌnë salvar mizmë lë́ꞌël nu bëꞌnë salvar lëꞌë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Perë stubi nguiu mal guniꞌi guëc saꞌll: ―¿Pë adë rdzë́bëdiꞌil Dios? Bëneꞌe mënë ordë gátiaꞌa ziquë lëꞌë më rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Pues lëꞌë hiaꞌa runë tucarë gátiaꞌa por maldá nabëdë́ꞌnaꞌa, perë nguiu rëꞌ adë bë́ꞌnëdiꞌiꞌ mal parë quë́hiꞌ ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Iurní guniꞌi ngubaꞌnë lu Jesús: ―Dadë Jesús, bësëagná ldúꞌul na iurë gúnël recibir pudërë parë guënibë́ꞌal. ");
INSERT INTO zacNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús guniꞌi: ―Guldía na rniaꞌa lul, nedzë́ sënáldël na gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Bëgaꞌa rquë chiꞌbë chupë, iurní bëcahi guëdubi guë́ꞌdchiliu hashtë rquë tsunë guadzeꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nacahi ngubidzë nu lari cortinë laꞌni iáduꞌu ruꞌbë gureꞌzin. Guc chupë ldëhin. ");
INSERT INTO zacNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Guniꞌi Jesús fuertë: ―Dadë, guna intriegu almë shtëna guiáꞌal. Gualú diꞌdzë ni, iurní guti më. ");
INSERT INTO zacNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Iurë guná capitán shtë ra suldadë pë guc, guníꞌill llëruꞌbë na pudërë shtë Dios. Bëquébill: ―Guldía, nguiu rëꞌ nápëdiꞌill culpë. Më zaꞌquë nall. ");
INSERT INTO zacNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Grë mënë zihani nabëdëá lugar ni parë guëná rall naquëac, gubiꞌa rall. Iurní bëabrí rall ciudá. Gulubë́ rall lduꞌu rall tantë nadzëꞌbë guc. ");
INSERT INTO zacNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ra amigu shtë Jesús con ra naꞌa nabëꞌnë compañi lëꞌë Jesús dizdë tiempë nanú më Galilea, zugaꞌa raiꞌ zitu. Gubiꞌa raiꞌ grë lo quë naguzac. ");
INSERT INTO zacNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Guꞌ tubi nguiu lë José; ládzëll lë Arimatea naquë́ Judea. Gúquëll miembrë shtë Junta Suprema. Nall më zaꞌquë nu bë́ꞌnëll cumplir lëy shtë Moisés. ");
INSERT INTO zacNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Quëbezë José guëdchini tiempë guënibëꞌa Dios ziquë rëy nu gúquëdiꞌi José de acuerdë naná bëꞌnë Junta Suprema iurë bëꞌnë rall cuntrë lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","José guagnaꞌbë lu Pilato parë guëdëꞌë Pilato permisi guëgaꞌchi Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Bësietë José cuerpë shtë më lu cruz. Bëtúꞌbill cuerpë shtënë më tubi sabë. Bëcáꞌchill lëꞌë më laꞌni baꞌa nanactsaꞌu laꞌni guëꞌë catë ni tubi mënë bëgáꞌchidiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Guc dzë runë mënë preparar parë dzë narziꞌi lduꞌu mënë. Hia mërë rgaꞌa iurë guëzublú dzë descansë. ");
INSERT INTO zacNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ra naꞌa naguanaldë lëꞌë Jesús antsë dizdë nanú më Galilea, guagná raiꞌ catë bëgaꞌchi më. Guná raiꞌ lla nagaꞌa tëgulë laꞌni baꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Despuësë bëabrí raiꞌ lidchi raiꞌ. Bëꞌnë raiꞌ preparar nisë nashi con stubi cusë tsagteꞌbi raiꞌ cuerpë shtë më. Iurní bëgaꞌa dzë descansë; bëziꞌi lduꞌu raiꞌ según mandamientë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Primërë dzë shtë llmalë, ra naꞌa bëabrí raiꞌ ruaꞌ baꞌa catë bëgaꞌchi Jesús. Tumpranë bëdchini raiꞌ. Nuaꞌa raiꞌ nisë nashi nabëꞌnë raiꞌ preparar. ");
INSERT INTO zacNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Guná raiꞌ lu baꞌa perë guëꞌë nanëꞌau ruaꞌ baꞌa nagaꞌa tubi ladë. ");
INSERT INTO zacNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Guatë́ raiꞌ laꞌni baꞌa. Guná raiꞌ nídiꞌi cuerpë shtë Dadë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bëdzélëdiꞌi raiꞌ pë nihunë raiꞌ. Iurní lueguë guná raiꞌ chupë nguiu nazugaꞌa guëlladchi lu raiꞌ. Shabë raiꞌ nalë́ rabtsëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Más bëdzëbë ra naꞌa; bëzullibi raiꞌ hashtë bëdchini luquë́ raiꞌ lu guiuꞌu. Guniꞌi nguiu lu raiꞌ: ―¿Pëzielú caguili të el quë nanabani lugar catë rgaꞌchi tëgulë? ");
INSERT INTO zacNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nídiꞌi më ndëꞌë. Guashtë́hiꞌ ladi ra tëgulë. Gulë bëagná lduꞌu të lo quë naguníꞌiꞌ lu të dizdë tiempë nananú më Galilea. ");
INSERT INTO zacNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Guníꞌiꞌ iurní, rquiꞌni nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, gac intriéguiꞌ lu guiaꞌa mënë mal. Nu guníꞌiꞌ gunë rall crucificar lë́ꞌiꞌ lu cruz, perë dzë tsunë tsashtë́hiꞌ ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Iurní bëagná lduꞌu ra naꞌa shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bëabrí raiꞌ lu ciudá Jerusalén. Biadiꞌdzë raiꞌ lu chiꞌbë tubi poshtë con stubi tantë mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ra naꞌa naguniꞌi diꞌdzë rëꞌ, lë raiꞌ María Magdalena, con Juana, nu stubi María shniꞌa Jacobo. Gua raiꞌ con sëbëldá ra naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Perë lo quë naruadiꞌdzë raiꞌ, na ziquë tubi cuendë. Ra mënë adë gualdídiꞌi lduꞌu raiꞌ shtiꞌdzë ra naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Perë Pedro bëruꞌu; guagllúꞌniꞌ hashtë ruaꞌ baꞌa. Gunáhiꞌ laꞌni baꞌa. Lu lari shtë tëgulë gunáhiꞌ. Tubi ladë nagaꞌa lari. Bëabrí Pedro; bëdzëguëëꞌ ldúꞌiꞌ. Bë́ꞌniꞌ llgabë pë guc. ");
INSERT INTO zacNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mizmë dzë, primërë dzë shtë llmalë, chupë shmënë Jesús ziaꞌa raiꞌ parë Emaús, tubi guëꞌdchi ziquë chiꞌbë tubi kilómetro de Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Quëadiꞌdzë raiꞌ pë guc laꞌni ra dzë ni. ");
INSERT INTO zacNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iurë quëadiꞌdzë raiꞌ, guniꞌi raiꞌ llgabë nanú laꞌni lduꞌu raiꞌ, Jesús guabiꞌguë lu raiꞌ. Grë raiꞌ guaglaꞌguë ziazú raiꞌ nezë. ");
INSERT INTO zacNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Guná raiꞌ lu më perë adë bënguë bë́ꞌadiꞌi raiꞌ lëꞌë më, bëꞌnë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iurní gunaꞌbë diꞌdzë Jesús lu raiꞌ: ―¿Pë quëadiꞌdzë të iurë ziazú të nezë? Guzudchí raiꞌ; tristë rluaꞌa lu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tubi de lëꞌë raiꞌ guniꞌi; lë́hiꞌ Cleofas: ―De grë visitantë nabëdchini Jerusalén, sulë lë́ꞌël adë guënë́diꞌil pë guc ndë laꞌni dzë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iurní guniꞌi Jesús: ―¿Pë guc? Guniꞌi raiꞌ: ―Jesús Nazareno, gudini mënë lë́ꞌiꞌ. Náhiꞌ tubi nabiadiꞌdzë shtiꞌdzë Dios con pudërë. Bëluáꞌaiꞌ dizaꞌquë lu ra mënë. Bë́ꞌniꞌ milagrë con pudërë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Perë ra bëshuzi nu gubiernë shtë́naꞌa, bëꞌnë rall intriegu lë́ꞌiꞌ parë gac crucificáriꞌ. Gútiꞌ lu cruz. ");
INSERT INTO zacNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nu lëꞌë naꞌa quëbezë naꞌa nihúniꞌ librar naciuni Israel de grë enemigu shtë́naꞌa. Hia gudëdë tsunë dzë dizdë guquin. ");
INSERT INTO zacNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Gútiꞌ perë bëldá naꞌa narianaldë tëchi dizaꞌquë, guniꞌi rall lu naꞌa diꞌdzë nadzëꞌbë. Rsíliga guagná rall lugar catë bëgaꞌchi Jesús. ");
INSERT INTO zacNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Gunádiꞌi rall lu shcuérpiꞌ. Guná rall lu chupë ianglë naguniꞌi lu raiꞌ guashtë́ Jesús ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Stubi de lëꞌë shmënë naꞌa, gua raiꞌ hashtë ruaꞌ baꞌa. Guná raiꞌ laꞌni baꞌa ziquë guniꞌi ra naꞌa perë gunádiꞌi rall lu më. ");
INSERT INTO zacNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iurní Jesús guniꞌi lu rall: ―Lëꞌë të nguiu narunë faltë llni guëc të, ¿hashtë guc tsaldí lduꞌu të grë lo quë nabëquëꞌë ra muzë shtë Dios guahietë? ");
INSERT INTO zacNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Guc necesari gunë Cristo sufrir galguti nu despuësë guëabrí më lu gubeꞌe catë gunë Dios honrar lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Iurní Jesús guzublú biadíꞌdziꞌ pë runë cuntienë ra Sagradas Escrituras catë rniꞌi shcuendë Jesús. Guniꞌi më dizdë nabëquëꞌë Moisés nu nabëquëꞌë ra nabiadiꞌdzë shtiꞌdzë Dios de mizmë lëꞌë më. Biadíꞌdziꞌ pë runë cuntienë diꞌdzë ni. ");
INSERT INTO zacNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Iurní bëdchini raiꞌ guëꞌdchi catë cuezë raiꞌ. Jesús niaglaꞌguë niazë́hiꞌ delantë, ");
INSERT INTO zacNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","perë lëꞌë raiꞌ bëꞌnë raiꞌ ruëguë guëaꞌnë më con lëꞌë raiꞌ. Guniꞌi raiꞌ: ―Bëaꞌnënú lëꞌë naꞌa ndëꞌë. Hia guadzeꞌ. Hia gulaguetë ngubidzë. Iurní guatë́ Jesús laꞌni hiuꞌu të guëaꞌnë më. ");
INSERT INTO zacNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Guzac guzubë raiꞌ lu mellë të gau raiꞌ, gunaꞌzi më guetështildi. Bëdëꞌë më graci. Gudiꞌdzë mëhin cuaꞌa raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Lueguë lueguë bëdëꞌë raiꞌ cuendë chu na më. Llni bëdchini laꞌni lduꞌu raiꞌ. Perë de repëntë gunitilú më lu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Guniꞌi lu saꞌ raiꞌ: ―Bini naꞌa laꞌni lduꞌu naꞌa bëgaꞌa diꞌdzë naguniꞌi më lu naꞌa iurë biadíꞌdziꞌ lu naꞌa lu nezë pë runë cuntienë ra Sagradas Escrituras. ");
INSERT INTO zacNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Lueguë bëabrí raiꞌ Jerusalén. Guná raiꞌ lu ra chiꞌbë tubi poshtë rdëá rai con stubi shcuaꞌa mënë. ");
INSERT INTO zacNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Guniꞌi ra mënë lu raiꞌ: ―Verdá guashtë́ Jesús ladi ra tëgulë nu bëluaꞌalúhiꞌ lu Simón Pedro. ");
INSERT INTO zacNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Iurní guniꞌi raiꞌ pë guc iurë zeꞌdëzú raiꞌ lu nezë nu guniꞌi raiꞌ bënguë bëꞌa raiꞌ lëꞌë më iurë gudiꞌdzë më guetështildi cuaꞌa raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mërë iurní quëadiꞌdzë raiꞌ, Jesús bëluaꞌalú lu raiꞌ. Guniꞌi më: ―Gulë cuedchí lduꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bëdzëbë raiꞌ nu nalë́ bëzezë raiꞌ; guná raiꞌ lu më. Lluaꞌa raiꞌ na më tubi espíritu shtë tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Guniꞌi Jesús lu raiꞌ: ―¿Pëzielú rdzëbë të? ¿Pëzielú rza lduꞌu të? ");
INSERT INTO zacNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gulë guná guiahia. Gulë guná guëahia. Gulë tsaldí lduꞌu të nahia Jesús. Gulë gunaꞌzi guiahia; gulë guná lua. Pues tubi espíritu nápëdiꞌi cuerpë ziquë rna të lua. ");
INSERT INTO zacNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Iurní bëluaꞌa më guiaꞌa më nu guëaꞌ më catë gudëdë clavë. ");
INSERT INTO zacNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Perë ni con ndëꞌë adë gualdídiꞌi lduꞌu raiꞌ purquë nanú tantë lëgrë laꞌni lduꞌu raiꞌ; bëdzëguëëꞌ lduꞌu raiꞌ. Iurní guniꞌi më: ―¿Gu nanú pë gáuha? ");
INSERT INTO zacNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bëdëꞌë raiꞌ tubi pedasë belë mbeldë. ");
INSERT INTO zacNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Gunaꞌzi mëhin nu gudáu më lu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Guniꞌi më: ―Grë lo quë naguc con na, guniaꞌa lu të antsë napë quë gac cumplirin. Guniaꞌa lu të dizdë guzënú të na, gac cumplir lo quë nabëquëꞌë Moisés de na. Gac cumplir lo quë nabëquëꞌë ra nabiadiꞌdzë shtiꞌdzë Dios guahietë de na nu gac cumplir naná escritë laꞌni librë Salmos de na. ");
INSERT INTO zacNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Iurní bëdëꞌë më llni parë riasë́ raiꞌ diꞌdzë shtë Sagradas Escrituras. ");
INSERT INTO zacNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Guniꞌi më: ―Naescritë, Cristo napë quë gúniꞌ sufrir galguti perë dzë tsunë gac resucitar më ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Guëniꞌi mënë de quë napë quë guëabrí lduꞌu mënë con Dios, iurní gunë më perdunë duldë shtë rall iurë rnaꞌbë rall lë shtëna. Primërë guëniꞌinú mënë lu ra mënë shtë Jerusalén, despuësë tsagniꞌinú raiꞌ mënë narëtaꞌ guëdubi lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Na të testigu de grë lo quë naguc. ");
INSERT INTO zacNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Gulë guná, na guësheꞌlda lëꞌë Espíritu Santo el quë nabëꞌnë Shtada prometer, cuezënúhiꞌ lëꞌë të. Perë gulë bëaꞌnë ndëꞌë laꞌni ciudá Jerusalén hashtë gunë të recibir pudërë shtë Dios naguëdchini de gubeꞌe; gacu të ziquë tubi lari con llëruꞌbë pudërë. ");
INSERT INTO zacNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iurní bëruꞌu raiꞌ ciudá. Jesús biaꞌa më ra shini gusëꞌdë më ruaꞌ guëꞌdchi Betania. Ndë bëldisë më guiaꞌa më. Bëꞌnë ldaiꞌ më lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Iurë gualú bëꞌnë ldaiꞌ më lëꞌë raiꞌ, bësëaꞌnë më lëꞌë raiꞌ. Güeꞌpi më gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Iurní bëabrí raiꞌ Jerusalén. Bëquitë lduꞌu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ria raiꞌ iáduꞌu ruꞌbë; bëdëꞌë raiꞌ graci lu Dios, nu bëꞌnë raiꞌ alabar lëꞌë më. Amén.");
INSERT INTO zacNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tiempë guahietë antsë cueshtë́ guë́ꞌdchiliu, nanú el quë nabësëdchini shtiꞌdzë Dios. Quëbezënúhiꞌ Dios. Náhiꞌ Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mizmë mënë ni quëbezënúhiꞌ Dadë Dios dizdë principi shtë grë ra cusë. ");
INSERT INTO zacNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Grë cusë gurështë́ por lëꞌë më, el quë nabësëdchini shtiꞌdzë Dios; ni chu stubi bëntsaꞌu lo quë nananú. ");
INSERT INTO zacNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Por lëꞌë më nanú galnabani nu lëꞌë galnabani na llni shtë mieti. ");
INSERT INTO zacNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lëꞌë llni tsaglaꞌguë rabtsëꞌë catë nacahi. Lëꞌë nacahi adë bë́ꞌnëdiꞌi gan lu llni parë bësëꞌau lu llni. ");
INSERT INTO zacNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Guꞌ tubi nguiu nabësheꞌldë Dios. Nguiu ni bërulë́ Juan. ");
INSERT INTO zacNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Bëdchíniꞌ; náhiꞌ testigu parë guëníꞌiꞌ chu na lëꞌë llni të parë grë mënë tsaldí lduꞌu rall shtiꞌdzë Dios por lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan nádiꞌi narneꞌe llni perë bëdchini Juan parë gáquiꞌ testigu; guëníꞌiꞌ chu na el quë narneꞌe llni verdadërë. ");
INSERT INTO zacNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Lëꞌë llni verdadërë naridë lu guë́ꞌdchiliu, rneꞌe llni parë grë mënë naquëreldë lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bëdchini më lu guë́ꞌdchiliu nu guctsaꞌu guë́ꞌdchiliu por pudërë shtë më, perë ra mënë shtë guë́ꞌdchiliu adë bënguë bë́ꞌadiꞌi rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Beꞌdë guëdchini më entrë ra mënë shtë guë́ꞌdchiliu perë adë bë́ꞌnëdiꞌi ra mënë recibir lëꞌë më ");
INSERT INTO zacNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","perë grë nabëꞌnë recibir lë́ꞌiꞌ, ra narialdí lduꞌi lëꞌë më, bëdëꞌë më derechë parë gac rall shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Lëꞌë rall guc rall shini Dios, lë́dëdiꞌi por deseo laꞌni lduꞌu mënë, ni por voluntá shtë mënë sino por pudërë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lëꞌë nabësëdchini shtiꞌdzë Dios, gúliꞌ nu guquëréldiꞌ entrë lëꞌë hiaꞌa. Guná hiaꞌa pudërë nu llni shtë më. Sulë lúniquë shini Dios quëbezënú llëruꞌbë favurë narquitë lduꞌu hiaꞌa. Ruadiꞌdzë më purë verdá. ");
INSERT INTO zacNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan guc testigu shtë́hiꞌ nu guniꞌi Juan: ―Ndëꞌë na el quë naguniaꞌa lu të más antsë, náhiꞌ më ruꞌbë; na adë chu nahia. Bëdchíniꞌ despuësë de na, perë nanúhiꞌ dizdë tiempë guahietë más antsë guëdchinia lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Por pudërë shtë më ni bëdë́ꞌnaꞌa recibir zihani bendición; por lëꞌë më quëhúnëruꞌu Dios favurë nu más favurë parë lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Lëy shtë Dios bëquëꞌë Moisés según voluntá shtë më, perë por Jesucristo nadápaꞌa favurë shtë Dios, nu nadápaꞌa shtíꞌdziꞌ naná verdá. ");
INSERT INTO zacNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni tubi chu gunádiꞌi lu Dios Padre; sulë tubsë shini më nacabezënú Dios, bëluáꞌaiꞌ chu na Dios verdadërë. ");
INSERT INTO zacNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juan bëꞌnë testificar iurë ra më israelitë naquëreldë Jerusalén, bësheꞌldë rall bëldá bëshuzi con mënë nabëꞌnë compañi ra bëshuzi. Gunaꞌbë diꞌdzë rall lu Juan chu náhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Adë bë́ꞌnëdiꞌi Juan negar sino bëquébiꞌ: ―Nádiaꞌa Cristo, el quë nagudili Dios parë guënibë́ꞌaiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Iurní gunaꞌbë diꞌdzë rall stubi: ―¿Chu nal? ¿Gu nal Elías? Juan guniꞌi: ―Aquëdiꞌi; nádiaꞌa Elías. Guaglaꞌguë gunaꞌbë diꞌdzë rall: ―¿Gu nal el quë naguadiꞌdzë shtiꞌdzë Dios nanapë quë guëdchini? Juan guniꞌi: ―Aquëdiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Iurní guniꞌi rall: ―¿Chu nal? të parë guëdëꞌë naꞌa rsunë lu ra nabësheꞌldë lëꞌë naꞌa. ¿Pë rníꞌil de mizmë lë́ꞌël? ");
INSERT INTO zacNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan repi: ―Nahia tubi bë, tubi narniꞌi lu shlatë catë nídiꞌi mënë: “Gulë bëꞌnë preparar laꞌni lduꞌu të ziquë nezë ldi parë iurë guëdchini Dadë”. Zni guniꞌi Isaías, el quë nabiadiꞌdzë shtiꞌdzë Dios guahietë. ");
INSERT INTO zacNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bëldá ra nabiadiꞌdzënú Juan na rall fariseos. ");
INSERT INTO zacNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Gunaꞌbë diꞌdzë rall lu Juan: ―Si talë adë nádiꞌil Cristo, si adë nádiꞌil Elías, ni tubi naguadiꞌdzë shtiꞌdzë Dios nanapë quë guëdchini, ¿pëzielú rchuꞌbë nísël ra mënë? ");
INSERT INTO zacNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Guniꞌi Juan: ―Na rchuꞌbë nisa con nisë perë nanú tubi më entrë lëꞌë të, adë guënë́diꞌi të chu náhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Náhiꞌ el quë nazeꞌdë guëdchini despuësë de na. Ni tubi adë chu nádiaꞌa parë guëshaca lëꞌë du guiꞌdi shtë shráchiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Grë cusë ni guc lugar nalë Betábara nanaquë́ guëëꞌgu Jordán ladë cuꞌ guiaꞌa catë lëꞌë Juan bëchuꞌbë nisë ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Stubi dzë Juan guná lu Jesús; ziabíꞌguiꞌ lu Juan. Guniꞌi Juan lu ra mënë: ―Gulë guná, nguiu rëꞌ nazeꞌdë de Dios; gátiꞌ ziquë tubi lliꞌli por duldë shtë mënë. Guëdchisúhiꞌ duldë shtë ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Náhiꞌ el quë naguniaꞌa lu të más antsë: “Náhiꞌ më ruꞌbë. Na adë chu nahia. Bëdchíniꞌ despuësë de na perë nanúhiꞌ dizdë tiempë más antsë quë na.” ");
INSERT INTO zacNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Adë bënguë bë́ꞌadiaꞌa lë́ꞌiꞌ perë bëdchinia parë gunguë bëꞌa mënë israelitë lë́ꞌiꞌ. Por ni rchuꞌbë nisa ra mënë parë guëná mënë chu na më. ");
INSERT INTO zacNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nu bëꞌnë Juan testificar: ―Gunahia lu Espíritu Santo nabëdchini de gubeꞌe. Biétiꞌ ziquë tubi palumë parë cuezënúhiꞌ lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Adë bënguë bë́ꞌadiaꞌa chu guëdchini, perë el quë nabësheꞌldë na të guëchuꞌbë nisa, guníꞌiꞌ lua: “Iurë guënal lu Espíritu Santo zeꞌdë guëdchini parë cuezënúhiꞌ lëꞌë nguiu, na më el quë naguëzunë́ lduꞌu të nu guëshéꞌldiꞌ Espíritu Santo parë cuezënúhiꞌ lëꞌë të”. ");
INSERT INTO zacNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Gunahia lu më ni, nu nahia testigu de quë nguiu rëꞌ na shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Stubi dzë Juan zugaꞌa stubi vueltë con chupë nanaldë lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Iurë guná Juan lu Jesús nardëdë, guniꞌi Juan: ―Gulë guná, ndëꞌë na lëꞌë nguiu nabësheꞌldë Dios; gátiꞌ ziquë lliꞌli. ");
INSERT INTO zacNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Guërupë nguiu nazianaldë lëꞌë Juan, bini raiꞌ lo quë naguniꞌi Juan. Iurní guanaldë rall lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iurë lëꞌë Jesús bëdchigrë́ lúhiꞌ nezë të́chiꞌ, gunáhiꞌ lu raiꞌ. Guniꞌi Jesús lu raiꞌ: ―¿Pë rguili të? Guniꞌi raiꞌ con diꞌdzë narunë cuntienë, lamë: ―Dadë, ¿ca quëréldël? ");
INSERT INTO zacNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Guniꞌi Jesús: ―Gulë gudeꞌe nu gulë guná. Iurní guagná raiꞌ catë quëreldë më, nu bëaꞌnë raiꞌ ndë purquë hia casi ziquë rquë tapë guadzeꞌ iurní. ");
INSERT INTO zacNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tubi de lëꞌë ra mënë nabini shtiꞌdzë Juan nu guanáldiꞌ lëꞌë Jesús, na Andrés, bëchi Simón Pedro. ");
INSERT INTO zacNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Primërë guatili Andrés bëchi Andrés, lëll Simón, nu guniꞌi Andrés: ―Bëdiaꞌguëlú naꞌa el Mesías. (Diꞌdzë ni runë cuntienë, Cristo, el quë nagudili Dios parë guënibë́ꞌaiꞌ.) ");
INSERT INTO zacNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Lueguë Andrés biaꞌa lëꞌë Simón Pedro catë zugaꞌa Jesús. Iurë Jesús guná lu Pedro, guniꞌi më: ―Lë́ꞌël lël Simón, shini Jonás; perë neꞌ guërulël Cefas, (lë ni runë cuntienë guëꞌë). ");
INSERT INTO zacNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Stubi dzë Jesús guc shtúꞌuiꞌ tsáhiꞌ regiuni shtë Galilea. Gunáhiꞌ lu Felipe nu guniꞌi më lu Felipe: ―Gudeꞌe naldë na. ");
INSERT INTO zacNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe na më guëꞌdchi Betsaida catë na ladzë Andrés nu Pedro. ");
INSERT INTO zacNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Iurní guatili Felipe lëꞌë Natanael; répiꞌ: ―Guná naꞌa lu tubi nguiu naná bëquëꞌë Moisés shcuéndiꞌ laꞌni ra librë shtë lëy, nu ra nabiadiꞌdzë shtiꞌdzë Dios bëquëꞌë raiꞌ diꞌdzë narniꞌi shcuéndiꞌ. Náhiꞌ Jesús, shini José. Guëꞌdchi Jesús na Nazaret. ");
INSERT INTO zacNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Repi Natanael: ―¿Ni mudë guëruꞌu tubi cusë zaꞌquë guëꞌdchi Nazaret? Felipe bëquebi: ―Gudeꞌe guënal. ");
INSERT INTO zacNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Guabiꞌguë Natanael lu Jesús. Iurë lëꞌë Jesús guná lu Natanael, guníꞌiꞌ: ―Ndëꞌë lëꞌë tubi nguiu israelitë verdadërë. Ni tubi bishi adë nídiꞌi laꞌni ldúꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Iurní gunaꞌbë diꞌdzë Natanael: ―¿Llallë nanël chu nahia? Guniꞌi Jesús: ―Na gunahia lul antsë iurë lëꞌë Felipe beꞌdë guënaꞌbë lë́ꞌël, iurë lë́ꞌël zugáꞌal guëaꞌ hiaguë bëldaꞌu. ");
INSERT INTO zacNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael guniꞌi: ―Mësë, lë́ꞌël nal shini Dios. Lë́ꞌël nal Rëy shtë naciuni Israel. ");
INSERT INTO zacNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús guniꞌi lu Natanael: ―¿Gu rialdí ldúꞌul purquë na guniaꞌa lul, gunahia lul guëaꞌ hiaguë bëldaꞌu? Delantë guënáruꞌul más cusë ruꞌbë quë ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nu guniꞌi Jesús: ―Guldía rniaꞌa lul, lë́ꞌël guënal llaꞌlë lu gubeꞌe. Ra ianglë shtë Dios tsepi raiꞌ nu guëdchini raiꞌ guëca, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dzë tsunë despuësë de ni, guꞌ tubi saꞌa guëꞌdchi Caná nanaquë́ regiuni shtë Galilea. Lëꞌë shniꞌa Jesús nanúhiꞌ ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nu Jesús con ra shini gusëꞌdë më gua raiꞌ purquë bëꞌnë ra mënë invitar lëꞌë raiꞌ lu saꞌa ");
INSERT INTO zacNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","perë gubidchi vini. Iurní lëꞌë shniꞌa Jesús guníꞌiꞌ lu më: ―Nídiꞌi vini. Hia gubidchin. ");
INSERT INTO zacNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Perë Jesús repi: ―Nanë, ¿pëzielú cagníꞌil lua zniꞌi? Gáꞌadiꞌi guëgaꞌa tiempë parë gac bëꞌa mieti chu nahia. ");
INSERT INTO zacNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Iurní shniꞌa më guniꞌi lu narëtaꞌ, ra naquëhunë sirvë: ―Gulë bëꞌnë grë́tëꞌ lo quë naná guënibë́ꞌaiꞌ lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Zugaꞌa shuꞌpë guëꞌë nariú nisë, cadë tubi guëꞌë ni riú gadchi u shunë rëëꞌ nisë. Na rahin parë më israelitë; rieꞌti guiaꞌa rall según custumbrë religiusë shtë rall. ");
INSERT INTO zacNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús guniꞌi lu ra naquëhunë sirvë: ―Gulë bëtsadzë́ guëzá guëꞌë rëꞌ nisë. Iurní guadzëhin guëꞌë ni nisë; ");
INSERT INTO zacNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesús guniꞌi: ―Iurneꞌ gulë cu duꞌpin nu guanuhin lu nguzanë shtë saꞌa. Zni bëꞌnë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Lëꞌë nguzanë shtë laní bëꞌnë prëbë nisë naná bëac vini perë adë rdë́ꞌëdiꞌill cuendë ca nezë bërúꞌuhin. (Sulë ra naquëhunë sirvë, rac bëꞌa rall de quë nisë bëac vini). Iurní lëꞌë nguzanë shtë saꞌa gunáꞌbëll lëꞌë lliguë. ");
INSERT INTO zacNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Guníꞌill: ―Grë lugar primërë rdëꞌë mënë vini zaꞌquë gu ra mënë. Hia despuësë iurë cantidá biiꞌ rall, rdëꞌë mënë vini corrientë gu mieti, perë lë́ꞌël bë́ꞌnëdiꞌil zni. Hashtë iurneꞌ bënéꞌel vini zaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ndëꞌë bëꞌnë Jesús Caná shtë Galilea. Ndë guc primërë milagrë nabëluaꞌa Jesús lu ra mënë. Bëluaꞌa më pudërë nanapë më. Ra shini gusëꞌdë më gualdí lduꞌu raiꞌ bësheꞌldë Dios lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Despuësë de ni, gua më guëꞌdchi Capernaum con shniꞌa më nu con shini gusëꞌdë më. Ndë guquëreldë raiꞌ duꞌpë tiempë. ");
INSERT INTO zacNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Hia mërë guëdchini laní Pascu shtë ra më israelitë, Jesús gua ciudá Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Guatë́ më iáduꞌu ruꞌbë. Guná më ra naquëgtuuꞌ ngunë. Guná më ra naquëgtuuꞌ lliꞌli nu palumë. Nu ngaꞌli zúbëgaꞌa mënë lu mellë catë rchili rall dumí. ");
INSERT INTO zacNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Bëntsaꞌu më tubi chicuti con du lasë. Iurní bësëlluꞌnë më grë́tëꞌ ra mënë laꞌni iáduꞌu con ra lliꞌli nu con ra ngunë. Bërëꞌshë më mellë. Bërëꞌtsë dumí shtë ra narchili dumí. ");
INSERT INTO zacNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Repi më lu ra nartuuꞌ palumë: ―Gulë cu grë cusë ndëꞌë. Adë rúnëdiꞌi të lidchi Shtada tubi llguëaꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Iurní lëꞌë ra shini gusëꞌdë më bëagná lduꞌu raiꞌ ziquë naescritë: “Nalë́ rzebi lduaꞌa por lidchi Dios; gaquin limpi”. ");
INSERT INTO zacNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Iurní lëꞌë ra më israelitë gunaꞌbë diꞌdzë: ―¿Pë milagrë guëluáꞌal lu naꞌa ziquë tubi sëñi de quë nápël derechë quëhúnël ra cusë rëꞌ? ");
INSERT INTO zacNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús bëquebi: ―Gulë bëzalú iáduꞌu rëꞌ; dzë tsunë guëldishtë́ahin stubi nacubi. ");
INSERT INTO zacNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Iurní guniꞌi ra mënë: ―Cuarenta y seis izë guzú guaꞌa iáduꞌu rëꞌ. ¿Ni mudë lë́ꞌël guëdishtëlin tsúnësë dzë? ");
INSERT INTO zacNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Perë lëꞌë iáduꞌu, el quë naquëgniꞌi Jesús, na cuerpë shtënë më. ");
INSERT INTO zacNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hia despuësë guashtë́ më ladi ra tëgulë, bëagná lduꞌu ra shini gusëꞌdë më lo quë naguniꞌi më, nu gualdí lduꞌu raiꞌ shtiꞌdzë më, nu gualdí lduꞌu raiꞌ ra Sagradas Escrituras. ");
INSERT INTO zacNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Iurë lëꞌë Jesús nanú Jerusalén, guꞌ laní Pascu. Cantidá mënë gualdí lduꞌu rall lëꞌë më iurë guná rall milagrë nabëꞌnë më. ");
INSERT INTO zacNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Perë Jesús adë rúnëdiꞌi confiar lëꞌë ra mënë purquë rac bëꞌa më lduꞌu ra grë́tëꞌ rall. ");
INSERT INTO zacNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Adë rquíꞌnidiꞌi më chu guëniꞌi lu më shcuendë ra mënë. Mizmë lëꞌë më rac bëꞌa më lla na laꞌni lduꞌu mieti. ");
INSERT INTO zacNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Guꞌ tubi nguiu nabërulë́ Nicodemo. Nall miembrë shtë partidë religiusë fariseo nu nall tubi nguiu namás lasac ladi ra më israelitë. ");
INSERT INTO zacNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nicodemo guagná lëꞌë Jesús gueꞌlë nu guníꞌill: ―Mësë. Rdëꞌë naꞌa cuendë de quë Dios bësheꞌldë lë́ꞌël parë zeꞌdë guëluáꞌal, purquë ni tubi adë chu gáquëdiꞌi guëluaꞌa pudërë nu milagrë cumë ziquë rúnël, sulë si talë Dios quëbezënúhiꞌ lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iurní guniꞌi Jesús lu Nicodemo: ―Guldía rniaꞌa lul, el quë nagalë nacúbidiꞌi stubi, gáquëdiꞌi tsutëll catë rnibëꞌa Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Bëquebi Nicodemo: ―Perë no es posiblë tubi nguiu hia guꞌshë, guëabrí gálëll stubi. ¿Ni mudë guëabrí guëuꞌll laꞌni shníꞌall stubi parë galë stubi nacubi? ");
INSERT INTO zacNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús bëquebi: ―Guldía rniaꞌa lul, el quë nagálëdiꞌi con nisë nu con Espíritu Santo, adë tsutë́diꞌill catë rnibëꞌa Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Grë́tëꞌ naná gulë ziquë ra cualquier mënë, mënë na ni, perë el quë naralë con Espíritu Santo, espíritu na ni. ");
INSERT INTO zacNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Adë rdzëguëëꞌdiꞌi ldúꞌul lo quë naguniaꞌa lul, grë́tëꞌ napë quë guësaꞌnë guëdchini vidë cubi laꞌni lduꞌu rall por pudërë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Lëꞌë mbë rruꞌu nezë catë rac shtuꞌu mbë, nu rínil ruidë narunë mbë perë adë rdë́ꞌëdiꞌil cuendë ca nezë zeꞌdë mbë nu ca nezë ziaꞌa mbë. Zni na grë́tëꞌ nanapë vidë cubi por pudërë shtë Espíritu Santo. ");
INSERT INTO zacNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Iurní Nicodemo bëabrí gunaꞌbë diꞌdzë: ―¿Perë llallë gac ndëꞌë? ");
INSERT INTO zacNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús guniꞌi lull: ―Lë́ꞌël nal tubi mësë ladi ra më israelitë nu adë guënë́diꞌil ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Guldía rniaꞌa lul, lëꞌë naꞌa rac bëꞌa naꞌa lo quë naruadiꞌdzë naꞌa nu lo quë narluaꞌa naꞌa; nu na naꞌa testigu de lo quë guná naꞌa, perë lëꞌë të adë rialdídiꞌi lduꞌu të lo quë narniꞌi naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Guniaꞌa lu të cusë narac lu guë́ꞌdchiliu perë adë gualdídiꞌi lduꞌu të. ¿Lla tsasë́ të cusë shtë gubeꞌe narniaꞌa lu të? ");
INSERT INTO zacNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ni tubi chu beꞌpi gubeꞌe, sulë el quë nabëdchini de gubeꞌe. Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu; lidcha na gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ziquë Moisés bëldísiꞌ serpientë lu shlatë, zni zac con na, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu; guna sufrir galguti; ");
INSERT INTO zacNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","parë grë natsaldí lduꞌi na, adë tsagnítidiꞌi rall sino napë rall vidë sin fin. ");
INSERT INTO zacNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Dios nalë́ rac shtúꞌuiꞌ ra mënë narëtaꞌ lu guë́ꞌdchiliu; bësheꞌldë më tubsë shini më parë grë́tëꞌ narialdí lduꞌi lëꞌë shini më, adë tsagnítidiꞌi rall sino napë rall vidë nadë rialúdiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios adë bëshéꞌldëdiꞌi shíniꞌ lu guë́ꞌdchiliu parë gunë shíniꞌ condenar ra mënë sino parë gúniꞌ salvar ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’El quë narialdí lduꞌi shini Dios, nádiꞌi condenárëll, perë el quë adë në́diꞌi tsaldí lduꞌu, hia nacondenárëll purquë në́diꞌill tsaldí ldúꞌull tubsë shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ra nanë́diꞌi tsaldí lduꞌi shtiꞌdza, nacondenárëll purquë iurë lëꞌë llni bidë lu guë́ꞌdchiliu, más bëquitë lduꞌu mënë nacahi quë llni. Adë rac shtúꞌudiꞌi rall llni. ¿Pëzielú? purquë runë rall cusë mal. ");
INSERT INTO zacNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Grë́tëꞌ lo quë narunë mal, rna záꞌquëdiꞌi rall lu llni nu adë riabíꞌguëdiꞌi rall lu llni purquë lëꞌë llni rluaꞌa ra cusë mal lo quë naquëhunë rall; ");
INSERT INTO zacNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","perë grë lo quë narquitë lduꞌu verdá, riabíꞌguëll lu llni të parë guëná mënë de quë grë lo quë naquëhúnëll, zeꞌdë de Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Despuësë de ndëꞌë, Jesús gua con ra shini gusëꞌdë më hashtë regiuni Judea. Gulezënú më lëꞌë raiꞌ dupëꞌnë, nu bëchuꞌbë nisë raiꞌ mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nu zac bëchuꞌbë nisë Juan Bautista lugar nabërulë́ Enón guëlladchi Salim purquë ngaꞌli rëtaꞌ zili nisë. Bidë ra mënë lu Juan, chubë nisë rall. ");
INSERT INTO zacNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Zndëꞌë guzac antsë bëtiaꞌa ra mënë Juan lachiguiꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Iurní bëldá shini gusëꞌdë Juan, gudildi diꞌdzë raiꞌ con tubi israelitë nabëꞌnë cumplir custumbrë. Guzublú rall chupë diꞌdzë subrë shcuendë lla gunë rall parë gac limpi rall lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Iurní guaguëchi mënë lu Juan: ―Mësë, guná; el quë naguzunú lë́ꞌël stubi ladë guëëꞌgu Jordán, el quë bë́ꞌnël testificar napë quë guëdchíniꞌ, quëgchuꞌbë nísiꞌ. Grë́tëꞌ mënë zianaldë rall lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Iurní guniꞌi Juan: ―Ni tubi adë chu nápëdiꞌi pudërë si talë adë bëdë́ꞌëdiꞌi Dios pudërë. ");
INSERT INTO zacNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mizmë lëꞌë të na të testigu, guniaꞌa lu të de quë na nádiaꞌa Cristo sino quë bësheꞌldë më na antsë guëdchíniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ziquë tubi nabëtsëꞌa, rquitë ldúꞌull purquë nápëll tséꞌlëll, perë zac amigu shtë lliguë, quëquë́ diáguëll nu rquitë ldúꞌull quëbezënull lliguë. Rínill lo quë naruadiꞌdzë lliguë. Zni iurneꞌ nalë́ rquitë lduaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Napë quë gáquiꞌ más më ruꞌbë, perë na napë quë gaca ziquë nalasáquëdiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’El quë nazeꞌdë de gubeꞌe, ni naná rnibëꞌa más quë grë nguiu. El quë naná mënë, no más nall më shtë guë́ꞌdchiliu nu ruadíꞌdzëll cusë shtë guë́ꞌdchiliu; perë el quë nazeꞌdë de gubeꞌe, ni ruadíꞌdziꞌ cusë shtë gubeꞌe. Nápiꞌ grë pudërë. ");
INSERT INTO zacNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Lëꞌë më quëhunë testificar lo quë naguná më nu lo quë nabini më, perë ni tubi adë chu rialdídiꞌi lduꞌi lo quë narniꞌi më. ");
INSERT INTO zacNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Perë el quë nagualdí lduꞌu shtiꞌdzë më de verdá, quëhúnëll ziquë el quë narquë́ sëgi lu guichi; rquébill Dios na verdá. ");
INSERT INTO zacNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","El quë nabësheꞌldë Dios, ni ruadíꞌdzëll shtiꞌdzë Dios purquë Dios rdëꞌë Espíritu Santo sin medidë parë nguiu ni të cuezënúhiꞌ lëꞌë nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dios Padre rac shtuꞌu shíniꞌ nu bëdëꞌë më pudërë parë guënibë́ꞌaiꞌ grë́tëꞌ cusë. ");
INSERT INTO zacNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","El quë narialdí lduꞌu shini Dios, ni napë vidë sin fin, perë el quë nanë́diꞌi tsaldí lduꞌi shini Dios, gápëdiꞌill vidë sin fin sino quë rëaꞌnë cashtigu shtë Dios guë́quëll. ");
INSERT INTO zacNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ra fariseo bini rall de quë napë Jesús más zihani shmë́niꞌ nu más zihani mënë naquëchuꞌbë nísiꞌ quë Juan Bautista. ");
INSERT INTO zacNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Lë́dëdiꞌi Jesús bëchuꞌbë nisë ra mënë sino shini gusëꞌdë më bëchuꞌbë nisë raiꞌ ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Iurë lëꞌë Jesús guc bëꞌa naguniꞌi ra fariseo, bëruꞌu më de Judea parë bëabrí më Galilea. ");
INSERT INTO zacNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Napë quë tëdë më Samaria parë guëdchini më Galilea. ");
INSERT INTO zacNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Bëdchini më guëꞌdchi Sicar nanaquë́ regiuni Samaria. Sicar na ruaꞌ guiuꞌu lachi nabëdëꞌë Jacob ziquë herenci parë shíniꞌ, José. ");
INSERT INTO zacNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ngaꞌli zúbëgaꞌa guërzú nabërulë́ Guërzú shtë Jacob. Lëꞌë Jesús zeꞌdë bëdzáguiꞌ. Guzúbiꞌ guëlladchi ruaꞌ guërzú; hia ziágaꞌa ru ngubidzë. ");
INSERT INTO zacNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ra shini gusëꞌdë më ziaꞌa raiꞌ parë guëꞌdchi. Ziasiꞌi raiꞌ naguëdaꞌu. Mizmë iurní bëdchini tubi naꞌa shtë Samaria ruaꞌ guërzú parë guëgúhiꞌ nisë. Jesús guniꞌi lu naꞌa rëꞌ: ―Denú duꞌpë nisë guaꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Iurní lëꞌë naꞌa shtë Samaria bëquebi: ―¿Pëzielú rnáꞌbël nisë lua, nu më israelitë nal? (Adë rniꞌi lu sáꞌdiꞌi më israelitë lu ra më shtë Samaria.) ");
INSERT INTO zacNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iurní guniꞌi Jesús: ―Si talë niac bë́ꞌal lo quë narneꞌe Dios ndigá, si talë niac bë́ꞌal chúllëtiꞌi ndëꞌë, el quë narnaꞌbë nisë lul, nanáꞌbël nisë lúhiꞌ nu lë́ꞌiꞌ guënéꞌeiꞌ nisë narneꞌe vidë sin fin. ");
INSERT INTO zacNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Lëꞌë naꞌa guniꞌi: ―Dadë, nápëdiꞌil pë guëgul nisë laꞌni guërzú. Más de ni guetë na guërzú. ¿Cátiꞌi nápël nisë narneꞌe vidë? ");
INSERT INTO zacNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Shtadë guëlú hiaꞌa Jacob bësëaꞌnë guërzú rëꞌ catë bíhiꞌ nisë, lë́ꞌiꞌ nu biiꞌ ra shíniꞌ nu con ra ma shtënë raiꞌ. ¿Ni mudë más më ruꞌbë nal quë lëꞌë Jacob? ");
INSERT INTO zacNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Bëquebi Jesús: ―Grë́tëꞌ el quë nagú nisë rëꞌ, guëabrí guëbidchi, ");
INSERT INTO zacNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","perë el quë nagú nisë naná guëdëꞌa, jamás adë guëabrídiꞌi guëbídchill, purquë nisë naná guëdëꞌa rcasë laꞌni ldúꞌull cumë ziquë nisë shtë zini parë guëdëꞌëin vidë sin fin. ");
INSERT INTO zacNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Iurní lëꞌë naꞌa guniꞌi: ―Dadë, denú nisë ni të parë adë guëbídchidiaꞌa jamás nu gueldë cádiaꞌa nisë ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Repi Jesús: ―Guagnaꞌbë tséꞌlël nu bëabrí ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Lëꞌë naꞌa guniꞌi: ―Nápëdiaꞌa tseꞌla. Jesús guniꞌi iurní: ―Nápël rsunë, guníꞌil verdá: “Nápëdiaꞌa tseꞌla”, ");
INSERT INTO zacNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","purquë gaꞌi nguiu guc raiꞌ tséꞌlël nu el quë nanápël iurneꞌ, lë́dëdiꞌi tséꞌlël. Verdá guníꞌil. ");
INSERT INTO zacNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Iurë bini naꞌa lo quë naguniꞌi më, guníꞌill: ―Dadë, lluáꞌahia nal tubi naruadiꞌdzë shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Shtadë guëlú naꞌa, mënë Samaria, bëꞌnë raiꞌ adorar Dios lu dani rëꞌ, perë lëꞌë të më israelitë rniꞌi të Jerusalén na lugar catë runë tucarë gunë mieti adorar Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús guniꞌi: ―Nanë, tsaldí ldúꞌul shtiꞌdza; guëdchini iurë de quë lëꞌë të gunë të adorar Dios Padre sin adë rquíꞌnidiꞌi guidë të lu dani rëꞌ u tsa të Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Lëꞌë të mënë Samaria, adë guënë́diꞌi të lo quë narunë të adorar perë lëꞌë naꞌa, sí, nanë́ naꞌa lo quë nardëꞌnë naꞌa adorar purquë el quë nagunë salvar ra mënë, na më israelitë. ");
INSERT INTO zacNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Perë guëdchini iurë nu mizmë iurneꞌ, lëꞌë ra mënë naná runë adorar Dios de verdá, napë quë gunë rall adorar lëꞌë më con lduꞌu rall nu de acuerdë con enseñansë shtëna. Pues Dios Padre rac shtúꞌuiꞌ gunë mënë adorar lë́ꞌiꞌ manërë ni. ");
INSERT INTO zacNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios na espíritu; ra narunë adorar lëꞌë më, napë quë gunë rall adorar lëꞌë më con espíritu nu de acuerdë con ra enseñansë shtëna. ");
INSERT INTO zacNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Lëꞌë naꞌa guniꞌi: ―Nanë́a de quë guëdchini Mesías narniꞌi ra mënë, Cristo, el quë nagudili Dios parë gunibë́ꞌaiꞌ. Iurë lëꞌë më guidë, guëluáꞌaiꞌ parë gac bëꞌa naꞌa shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Repi Jesús: ―Nípaꞌala, nahia mizmë naquëadiꞌdzënul. ");
INSERT INTO zacNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iurní bëdchini ra shini gusëꞌdë më; bëdzëguëëꞌ lduꞌu raiꞌ de quë quëadiꞌdzënú Jesús tubi naꞌa, perë ni tubi de lëꞌë raiꞌ guniꞌi lu Jesús: “¿Pëzielú quëadiꞌdzënul lë́ꞌëll?” u “¿Pë quëgnaꞌbë díꞌdzël lu naꞌa?” ");
INSERT INTO zacNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Iurní lëꞌë naꞌa bësëaꞌnëgá rëëꞌ; bëabrill parë guëꞌdchi catë guagníꞌill lu ra nguiu: ");
INSERT INTO zacNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Gulë cha të guëná të tubi nguiu naguniꞌi grë lo quë nabëna. ¿Adë lëꞌë narniꞌi ra mënë Cristo ndëꞌë? ");
INSERT INTO zacNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Iurní bëruꞌu ra mënë guëꞌdchi. Bëdchini rall lu Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mientras lëꞌë shini gusëꞌdë më bëꞌnë raiꞌ ruëguë lu më; repi raiꞌ: ―Mësë, gudáu. ");
INSERT INTO zacNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Perë Jesús guniꞌi: ―Na napa tubi dau naná guënë́diꞌi të. ");
INSERT INTO zacNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ra shini gusëꞌdë më guzublú raiꞌ gunaꞌbë diꞌdzë lu saꞌ raiꞌ: ―Aquë, ¿nu chu beꞌdënú nagudáuhiꞌ? ");
INSERT INTO zacNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Perë Jesús bëquebi: ―Dau shtëna na guna cumplir voluntá shtë më el quë nabësheꞌldë na. ");
INSERT INTO zacNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Adë guníꞌidiꞌi të: “Runë faltë stapë mbehu parë guëruꞌu cusechë”. Rniaꞌa lu të, gulë guná, hia bëquichi bëcuelë shtë guezë; bëgaꞌa iurë shtë cusechë. ");
INSERT INTO zacNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","El quë narunë dchiꞌni, runë tucarë tsu pagu shtëll. Grë́tëꞌ lo quë narcabní, guëcáꞌall cusechë; nápëll premi lu gubeꞌe. El quë narcabní nu el quë narldë́ guëniꞌa, rquitë lduꞌu rall juntë. ");
INSERT INTO zacNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Verdá na lo quë narniꞌi dichë: “El quë narcabní, ni na tubi; el quë narldë́ guëniꞌa, ni na stubi”. ");
INSERT INTO zacNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na bësheꞌlda lëꞌë të parë tsagniꞌi të lu mënë perë stubi el quë nagueꞌdënú mënë lua. Zni stubi mënë bëꞌnë dchiꞌni perë lëꞌë të quëhunë të provëchë grë́tëꞌ dchiꞌni shtë rall. ");
INSERT INTO zacNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Cantidá mënë shtë guëꞌdchi Samaria, gualdí lduꞌu rall Jesús por lo quë naguniꞌi naꞌa iurë lëꞌë naꞌa guniꞌi: “Guniꞌi më grë lo quë nabëna”. ");
INSERT INTO zacNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Iurní bëdchini ra mënë shtë Samaria lu më; bëꞌnë rall ruëguë lu më të parë guëaꞌnë më con lëꞌë rall. Bëaꞌnënú më lëꞌë rall chupë dzë. ");
INSERT INTO zacNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nu másruꞌu zihani mënë gualdí lduꞌu rall iurë bini rall lo quë naguniꞌi Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Iurní guniꞌi rall lu naꞌa: ―Iurneꞌ rialdí lduꞌu naꞌa, lëdë niáꞌasëdiꞌi por lo quë naguníꞌil lu naꞌa, sino quë mizmë lëꞌë naꞌa bini naꞌa shtíꞌdziꞌ, nu rac bëꞌa naꞌa de quë verdá më rëꞌ na el quë nagunë salvar mënë shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Despuësë de guërupë dzë, Jesús bëruꞌu Samaria. Ziagláꞌguiꞌ nezë shtë́hiꞌ parë regiuni shtë Galilea. ");
INSERT INTO zacNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mizmë Jesús bëꞌnë testificar de quë grë́tëꞌ ra muzë shtë Dios, adë rúnëdiꞌi mënë rëspëti lëꞌë raiꞌ. Sulë stubi lugar runë mënë rëspëti muzë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Iurë bëdchini Jesús Galilea, ra mënë ni bëꞌnë rall recibir lëꞌë më con bien purquë gua rall laní Pascu ciudá Jerusalén; guná rall lo quë nabëꞌnë më, ra milagrë nabë́ꞌniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iurní Jesús bëabrí Caná shtë Galilea catë bë́ꞌniꞌ cambi nisë vini. Bini tubi më ruꞌbë shtë gubiernë de quë bëdchini Jesús ndë. Nguiu ni nápëll tubi shínill narac lluꞌu guëꞌdchi Capernaum. ");
INSERT INTO zacNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Iurë lëꞌë nguiu ni bini de quë Jesús bëdchini Galilea, guagnall nu bë́ꞌnëll ruëguë lu më parë tsa më lídchill të parë gunëac më shínill purquë hia casi rlullë llguëꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iurní Jesús guniꞌi: ―Lëꞌë të adë rialdídiꞌi lduꞌu të si talë rnádiꞌi të milagrë. ");
INSERT INTO zacNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Perë lëꞌë narunë shchiꞌni gubiernë guniꞌi: ―Dadë, nasesë, cha lidcha purquë aquë zati shinia. ");
INSERT INTO zacNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iurní Jesús guniꞌi: ―Bëabrí lídchil; lëꞌë shínil nabani. Nguiu ni gualdí ldúꞌull shtiꞌdzë Jesús. Lueguë zëagzëll lídchill. ");
INSERT INTO zacNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Iurë lëꞌë nguiu beꞌdë guëzë́ lídchill, lëꞌë ra muzë naquëreldë hiuꞌu, guagtsaꞌguëlú rall lëꞌë nguiu; repi rall lúhiꞌ: ―Lëꞌë shínil bëac. ");
INSERT INTO zacNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Iurní gunaꞌbë díꞌdzëll: ―¿Ca iurë bëac llguëꞌnë? ¿Ca iurë guzublú nahueꞌi? Repi rall: ―Naꞌguë ziquë rquë tubi guadzeꞌ bëruꞌu shldi. ");
INSERT INTO zacNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Lëꞌë shtadë llguëꞌnë bëdë́ꞌëll cuendë de quë mizmë iurë ni guniꞌi Jesús: “Shínil nabani”. Lëꞌë nguiu ni con grë shfamílill gualdí lduꞌu rall Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ni na segundë milagrë nabëꞌnë Jesús despuësë bëruꞌu më Judea parë guziáꞌaiꞌ Galilea. ");
INSERT INTO zacNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Despuësë gudëdë ra dzë, bëꞌnë tucarë tubi laní shtë më israelitë, nu Jesús gua parë Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mizmë ciudá ni cerquë ruaꞌ puertë nalë Puertë shtë Lliꞌli, nanú tubi tanquë ruꞌbë shtë nisë. Lugar ni lëhin Betesda con dizë́ hebreo. Napin gaꞌi portali alrededurë shtë tanquë. ");
INSERT INTO zacNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ngaꞌli rëtaꞌ zihani narac lluꞌu; nagaꞌa raiꞌ lu daaꞌ. Nanú ciegu; nanú cujë; nanú narac galguidzë llunguë. Quëbezë raiꞌ parë guëniꞌbi nisë. ");
INSERT INTO zacNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Rniꞌi raiꞌ ridë tubi ianglë laꞌni tanquë parë rníꞌbiꞌ nisë. Primërë nariutë́ laꞌni nisë despuësë lëꞌë ianglë bëniꞌbi nisë, guëáquëll de cualquier galguidzë. ");
INSERT INTO zacNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ndë nanú tubi nguiu; hia guc treinta y ocho izë rac llúꞌull. ");
INSERT INTO zacNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iurë lëꞌë Jesús guná lu nguiu nagaꞌa, bëdëꞌë më cuendë de quë hia zihani izë nagáꞌall lu galguidzë. Repi Jesús: ―¿Gu rac shtúꞌul guëáquël? ");
INSERT INTO zacNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Lëꞌë më narac lluꞌu bëquebi: ―Dadë, rac shtuaꞌa perë chu nádiꞌi guëtiaꞌa na laꞌni nisë iurë lëꞌë nisë rniꞌbi. Cadë vësë narac shtuaꞌa tsahia laꞌni nisë, lëꞌë stubi rlaguë laꞌni nisë primërë. ");
INSERT INTO zacNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús guniꞌi: ―Guashtë́ ngaꞌli. Bëtëá shtaaꞌl nu bëagzë́. ");
INSERT INTO zacNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mizmë iurní lëꞌë nguiu bëac. Bëtëall shtaaꞌll nu guzublú rzëll. Perë dzë ni na dzë narziꞌi lduꞌu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Iurní ra më israelitë naquëhunë cumplir custumbrë, guniꞌi rall lu el quë nabëac: ―Nápëdiꞌil permisi parë guáꞌal shtaaꞌl purquë nedzë́ rziꞌi lduꞌu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Lëꞌë nguiu bëquebi: ―El quë nabënëac na guniꞌi lua: “Bëtëá shtaaꞌl nu bëagzë́”. ");
INSERT INTO zacNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Iurní gunaꞌbë diꞌdzë rall: ―¿Chull guniꞌi lul? “Bëtëá shtaaꞌl nu bëagzë́”. ");
INSERT INTO zacNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Perë lëꞌë nguiu adë guënë́diꞌill chu bënëac lë́ꞌëll purquë Jesús gunitilú më ladi ra mënë zihani narëtaꞌ lugar ni. ");
INSERT INTO zacNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Despuësë lëꞌë Jesús bëdiaꞌguëlú nguiu ni laꞌni iáduꞌu; iurní guniꞌi më: ―Guná, hia lë́ꞌël bëáquël; adë rúnëdiꞌil duldë të adë guídëdiꞌi galguidzë más peor guë́quël. ");
INSERT INTO zacNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Lëꞌë nguiu zëagzëll iurní. Guagdë́ꞌëll partë lu ra më israelitë de quë Jesús bënëac lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Por ni lëꞌë rall guzunaldë rall lëꞌë Jesús parë quini rall lëꞌë më purquë bëꞌnë më milagrë rëꞌ dzë narziꞌi lduꞌu mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Perë Jesús guniꞌi lu rall: ―Shtada todavía canihúniꞌ dchiꞌni; adë rbézëdiꞌi rúniꞌ dchiꞌni; nu zac quëhuna dchiꞌni. ");
INSERT INTO zacNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Por ni ra contrari shtë më, másruꞌu rac shtuꞌu rall quini rall lëꞌë më purquë lëdë niáꞌasëdiꞌi rúnëdiꞌi Jesús cuendë ra custumbrë shtë dzë narziꞌi lduꞌu mënë, sino quë quëhúniꞌ lë́ꞌiꞌ ziquë Dios; guniꞌi më Dios na Shtádiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iurní Jesús guniꞌi: ―Guldía rniaꞌa de quë nahia shini Dios; adë gáquëdiꞌi guna según voluntá shtëna; sulamëntë runa lo quë narunë Shtada. Grë́tëꞌ lo quë narunë Shtada, mizmë manërë runa ");
INSERT INTO zacNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","purquë Shtada rac shtúꞌuiꞌ na. Quëgluaꞌa më na grë lo quë narunë më. Todavía runë faltë cusë ruꞌbë naguëluaꞌa më na, cusë nartsëguëëꞌ lduꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ziquë Shtada rcuaꞌñi ra tëgulë parë guëbani raiꞌ, igual guënehia vidë parë ra narac shtuaꞌa guëbani raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Cumë ziquë Dadë adë rúnëdiꞌiꞌ juzguë ni tubi chúdiꞌi, sino bëneꞌe më pudërë guiahia parë guna juzguë lëꞌë ra mënë të parë gunë mënë rëspëti na igual ziquë runë rall rëspëti Shtada. ");
INSERT INTO zacNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","El quë nadë rúnëdiꞌi rëspëti na, adë rúnëdiꞌill rëspëti Dadë Dios, el quë nabësheꞌldë na lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Guldía rniaꞌa, el quë narquë́ diaguë shtiꞌdza lo quë narniaꞌa nu tsaldí ldúꞌull el quë nabësheꞌldë na, nápëll vidë sin fin. Adë gáquëdiꞌi condenárëll; gudë́dëll lu galguti. Iurneꞌ nápëll vidë nanadë rialúdiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Verdá rniaꞌa, hia bëgaꞌa iurë lëꞌë ra tëgulë guini raiꞌ voz shtë shini Dios. Grë́tëꞌ naguëzuꞌbë diaguë voz shtë më, guëbani rall parë siemprë ");
INSERT INTO zacNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","purquë ziquë grë mieti nabani rall por pudërë shtë Dadë Dios, también bëdëꞌë më derechë lu shini më parë gápiꞌ mizmë pudërë. Rac guëdëꞌa vidë parë ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nu bëdëꞌë më derechë lu shini më parë gúniꞌ juzguë ra mënë purquë náhiꞌ nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Adë rdzëguëëꞌdiꞌi lduꞌu të ndëꞌë purquë guëdchini iurë grë ra tëgulë guini raiꞌ chahia, nu guëruꞌu raiꞌ laꞌni baꞌa. ");
INSERT INTO zacNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Grë́tëꞌ el quë nabëꞌnë bien, guëbani rall; gac resucitar rall parë vidë sin fin perë grë́tëꞌ ra nabëꞌnë mal, guëbani rall; gac resucitar rall parë gac condenar rall. ");
INSERT INTO zacNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Na adë gáquëdiꞌi guna shcuendë iubia; quëhuna juzguë según diꞌdzë narniꞌi Shtada lua. Tubldí quëhuna juzguë; adë rúnëdiaꞌa según lo quë narac shtuaꞌa sino según voluntá shtë el quë nabësheꞌldë na. ");
INSERT INTO zacNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Si talë rniaꞌa favurë de na, lo quë narniaꞌa nádiꞌin ziquë tubi nanasac ");
INSERT INTO zacNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","perë nanú stubi testigu narniꞌi favurë de na. Nu rac bë́ꞌahia de quë grë el quë narniꞌi më ni de na, lasaquin; verdá nahin. ");
INSERT INTO zacNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Lëꞌë të bësheꞌldë të el quë naguagnaꞌbë diꞌdzë lu Juan Bautista, perë lo quë nabëquebi Juan de na, verdá nahin. ");
INSERT INTO zacNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Perë na adë rquíꞌnidiaꞌa guëniꞌi mënë favurë de na. Rniaꞌa lu të diꞌdzë rëꞌ parë gac salvar të. ");
INSERT INTO zacNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan nadë más náhiꞌ ziquë tubi lintërnë, ziquë narzianí parë ra mënë, nu lëꞌë të guagnaldë të tëchi Juan por duꞌpë tiempë. Bëquitë lduꞌu të shtíꞌdziꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Perë na napa testimonio más lasac lo quë naguniꞌi Juan. Grë́tëꞌ cusë el quë naruna, bëneꞌe Shtada parë guna cumplirin. Milagrë naquëhuna, rneꞌe prëbë de quë verdá bësheꞌldë Dios na. ");
INSERT INTO zacNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Lëꞌë Dadë nabësheꞌldë na, bë́ꞌniꞌ testificar de na, perë lëꞌë të nunquë adë bínidiꞌi të chaꞌ më, nu nunquë adë gunádiꞌi të lu më. ");
INSERT INTO zacNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Grë́tëꞌ dizaꞌquë shtë́niꞌ, adë gutë́diꞌin laꞌni lduꞌu të purquë në́diꞌi të tsaldí lduꞌu të shtiꞌdzë el quë nabësheꞌldë më. ");
INSERT INTO zacNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Lëꞌë të bësëꞌdë të laꞌni ra Sagradas Escrituras con llëruꞌbë cuidá parë guëdzelë të laꞌni librë ni nezë parë gapë të vidë sin fin, perë rniaꞌa lu të, ra Sagradas Escrituras rneꞌe testimonio chu nahia ");
INSERT INTO zacNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","perë adë në́diꞌi të guidë të lua parë gapë të vidë sin fin. ");
INSERT INTO zacNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Na adë rcádiaꞌa hunurë shtë mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Más de ni nanë́a lëꞌë të adë rac shtúꞌudiꞌi të Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na zelda por lë Shtada, perë adë bë́ꞌnëdiꞌi të recibir na. Perë si talë guëdchini stubi më por mizmë lëll, ni sí, gunë të recibir lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Llallë tsaldí lduꞌu të na purquë rguili të guëniꞌi mënë bien de lëꞌë të? Adë rguílidiꞌi të lëꞌë hunurë nazeꞌdë de Dios verdadërë. ");
INSERT INTO zacNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Gulë tsasë́ de quë na adë guëdchiꞌba galquiá guëc të delantë de Shtada. El quë naguëdchiꞌbë galquiá guëc të, na el quë nabëquëꞌë Moisés, mizmë lë́ꞌiꞌ el quë más rianaldë të të́chiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Si talë lëꞌë të nialdí lduꞌu të lo quë nabëquëꞌë Moisés, nu zac shtiꞌdza nialdí lduꞌu të purquë Moisés bëquëꞌë shcuenda. ");
INSERT INTO zacNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Perë si talë adë rialdídiꞌi lduꞌu të lo quë nabëquëꞌë Moisés ¿lla tsaldí lduꞌu të lo quë narniaꞌa lu të? ");
INSERT INTO zacNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Despuësë de ndëꞌë, Jesús gua stubi ladë ruaꞌ nisë ruꞌbë shtë Galilea; mizmë nisë ni lëhin Tiberias. ");
INSERT INTO zacNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Zihani mënë guanaldë lëꞌë më purquë guná rall ra cusë ruꞌbë nu milagrë lo quë nabëꞌnë më. Bënëac më ra narac lluꞌu. ");
INSERT INTO zacNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Iurní lëꞌë Jesús beꞌpi guëc tubi lumë. Guzubë më ngaꞌli con ra shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Guëlladchi zeꞌdë guëdchini laní Pascu, laní shtë ra israelitë. ");
INSERT INTO zacNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iurë Jesús guná cantidá mënë zianaldë lëꞌë më, guniꞌi më lu Felipe: ―¿Ca guiasiꞌi hiaꞌa nagáu mënë zihani rëꞌ? ");
INSERT INTO zacNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Guniꞌi më të niaꞌa pë guëniꞌi Felipe purquë Jesús hia rac bë́ꞌaiꞌ guadë el quë nagunë më. ");
INSERT INTO zacNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Iurní Felipe bëquebi: ―Chupë gahiuꞌa bëllë bëdchichi guetështildi, adë gáldëdiꞌi parë ni siquierë tubi pedasë gau cadë tubi de lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andrés, tubi shini gusëꞌdë më, nu náhiꞌ bëchi Pedro; guniꞌi: ");
INSERT INTO zacNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ndë zugaꞌa tubi llguëꞌnë. Nuáꞌall gaꞌi guetështildi nu chupë mbeldë, ¿pë gunë ndëꞌë parë blac mënë zihani? ");
INSERT INTO zacNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iurní Jesús guniꞌi: ―Gulë guniꞌi lu grë́tëꞌ mënë të parë subë ra mënë. Ngaꞌli cantidá ra guiꞌlli nanú lu guiuꞌu, subë rall. Iurní guzubë ra mënë ziquë gaꞌi mili nguiu. ");
INSERT INTO zacNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús gunaꞌzi guetështildi. Bëdëꞌë më graci lu Dios. Iurní bëdëꞌë më guetështildi cuaꞌa ra shini gusëꞌdë më. Hia lëꞌë raiꞌ guatiꞌdzë raiꞌ guetështildi parë grë́tëꞌ el quë nazúbëgaꞌa. Zni bëꞌnë më con mbeldë. Grë́tëꞌ gudáu tantë lo quë narac shtuꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Iurë lëꞌë raiꞌ gualú gudáu, Jesús guniꞌi lu ra shini gusëꞌdë më: ―Gulë bëtëá grë pedasë nabëꞌnë subrë të parë adë shínidiꞌi ni tubi. ");
INSERT INTO zacNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bëtëá raiꞌ pedasë nabëꞌnë subrë; tsadzë́ raiꞌ chiꞌbë chupë tëpë grë ra pedasë nabëꞌnë subrë de lo gaꞌi guetështildi. ");
INSERT INTO zacNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Iurë guná ra mënë lo quë nabëꞌnë Jesús nu milagrë nabëluaꞌa më lu rall, guniꞌi rall: ―Ndëꞌë sí, de verdá náhiꞌ el quë naruadiꞌdzë shtiꞌdzë Dios, el quë nanapë quë guëdchini lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesús guc bëꞌa de quë rac shtuꞌu rall guaꞌa rall lëꞌë më la fuersë parë gac më rëy shtë rall. Iurní biequi më de ngaꞌli. Ziaꞌa më parë tubi dani parë guëquëreldë më lë́ꞌësë më. ");
INSERT INTO zacNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Iurë lëꞌë gueꞌlë guꞌ, ra shini gusëꞌdë më bietë raiꞌ ruaꞌ nisë. ");
INSERT INTO zacNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Guatë́ raiꞌ laꞌni tubi barcu. Iurní gunaꞌzi raiꞌ nezë parë stubi ladë ruaꞌ nisë parë guëdchini raiꞌ Capernaum, Hia nacahi iurní, nu Jesús laꞌdi guëabrídiꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Iurní guzublú tubi mbë dushë. Ra olë shtë nisë ruꞌbë nalë́ rzuldí. ");
INSERT INTO zacNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Iurë lëꞌë raiꞌ ziazú raiꞌ cumë ziquë gaꞌi u shuꞌpë kilómetro lu nisë, iurní guná raiꞌ lu Jesús; ziabiꞌguë më ruaꞌ barcu. Rzë́hiꞌ lu nisë. Iurní bëdzëbë ra nguiu nananú laꞌni barcu ");
INSERT INTO zacNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","perë Jesús guniꞌi: ―Na ndëꞌë; adë rdzë́bëdiꞌi të. ");
INSERT INTO zacNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Iurní bëquitë lduꞌu raiꞌ; rac shtuꞌu gunë raiꞌ recibir lëꞌë më laꞌni barcu. Mizmë iurní bëdchini raiꞌ catë ziaꞌa raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Stubi dzë ra mënë nabëaꞌnë stubi ladë ruaꞌ nisë ruꞌbë, bëdëꞌë rall cuendë de quë shini gusëꞌdë më ziaꞌa raiꞌ laꞌni lúniquë barcu naná zugaꞌa ngaꞌli perë Jesús adë guanáldëdiꞌiꞌ lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Perë mientras bëdchini sëbëldá barcu nazeꞌdë de guëꞌdchi Tiberias, tubi lugar nanaquë́ catë gudáu ra mënë guetështildi, catë bëdëꞌë Jesús graci lu Dios por guetështildi. ");
INSERT INTO zacNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Perë iurë guná ra mënë de quë adë nídiꞌi Jesús, nilë ra shini gusëꞌdë më nídiꞌi raiꞌ; iurní guatë́ rall laꞌni ra barcu. Ziaꞌa rall parë Capernaum. Bëdchini rall; caguili rall lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Iurë bëdiaꞌguëlú rall Jesús, gunaꞌbë diꞌdzë rall lu më: ―Mësë, ¿guc bëdchínil ndëꞌë? ");
INSERT INTO zacNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús guniꞌi: ―Guldía rniaꞌa, caguili të na, lë́dëdiꞌi purquë guná të nu riasë́ të ra milagrë nabëna, sino caguili të na sulë purquë gudáu të guetështildi hashtë bielë të. ");
INSERT INTO zacNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Adë rúnëdiꞌi të dchiꞌni por cumidë naná rialú sino quë gulë bëꞌnë dchiꞌni tubi dau lo quë nunquë adë rialúdiꞌi nu rneꞌein vidë sin fin. Lëꞌë dau ni rneꞌe nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, purquë Dios bëneꞌein parë na. Bëluaꞌa Dios con milagrë nahia el quë narquitë ldúꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Iurní gunaꞌbë diꞌdzë rall: ―¿Lla guëdëꞌnë naꞌa cumplir lo quë narac shtuꞌu Dios? ");
INSERT INTO zacNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús bëquebi: ―Lo quë narac shtuꞌu Dios gunë të, tsaldí lduꞌu të el quë nabësheꞌldë më lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Iurní gunaꞌbë diꞌdzë rall: ―¿Pë milagrë guëluáꞌal të parë guëná naꞌa nu tsaldí lduꞌu naꞌa shtíꞌdzël? ¿Pë sëñi guënéꞌel parë lëꞌë naꞌa? ");
INSERT INTO zacNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ra shtadë guëlú hiaꞌa gudáu raiꞌ guetështildi maná lu shlatë cumë ziquë rniꞌi Sagradas Escrituras: “Dios bëdëꞌë guetështildi de gubeꞌe; gudáu raiꞌ”. ");
INSERT INTO zacNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús bëquebi: ―Guldía rniaꞌa, lëdë Moisés bëdëꞌë guetështildi nazeꞌdë de gubeꞌe sino quë Shtada; cagdëꞌë më guetështildi verdadërë naná zeꞌdë de gubeꞌe ");
INSERT INTO zacNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","purquë guetështildi narneꞌe Dios, na el quë nazeꞌdë de gubeꞌe. Nu rdë́ꞌëiꞌ vidë sin fin parë ra nguiu. ");
INSERT INTO zacNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Iurní guniꞌi rall: ―Dadë, bëneꞌe guetështildi niꞌi grë dzë nu parë siemprë. ");
INSERT INTO zacNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús guniꞌi: ―Na nahia guetështildi narneꞌe vidë sin fin. El quë naguidë lua, nunquë adë guëldiáꞌnëdiꞌill jamás. Nu el quë natsaldí lduꞌi shtiꞌdza, nunquë adë guëbídchidiꞌill. ");
INSERT INTO zacNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ziquë guniaꞌa lu të, guná të lua perë në́diꞌi të tsaldí lduꞌu të shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Grë lo quë narneꞌe Shtada parë na, ni zeꞌdë lua, nu el quë nazeꞌdë lua adë guëgúdiaꞌa tëchi fuërë ");
INSERT INTO zacNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","purquë na zéldëdiaꞌa de gubeꞌe parë guna según voluntá shtëna sino parë guna según voluntá shtë më el quë nabësheꞌldë na. ");
INSERT INTO zacNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Voluntá shtë Shtada, el quë nabësheꞌldë na, es quë ni tubi adë chu guënítidiaꞌa lo quë nabëneꞌe më sino quë guëcuaꞌñia ra mënë ni lúltimë dzë. ");
INSERT INTO zacNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Voluntá shtë më el quë nabësheꞌldë na, es quë grë́tëꞌ el quë naguëná lu shini Dios nu tsaldí ldúꞌull lëꞌë më, gapë rall vidë sin fin. Na guëcuaꞌñia lëꞌë rall lúltimë dzë. ");
INSERT INTO zacNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Iurní ra më israelitë guzublú guniꞌi guidzë rall lëꞌë Jesús purquë guniꞌi më: “Na nahia guetështildi nazeꞌdë de gubeꞌe”. ");
INSERT INTO zacNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Iurní guniꞌi rall: ―Nguiu rëꞌ na shini José. Lëꞌë hiaꞌa nanë́ hiaꞌa shtádëll nu shníꞌall. ¿Pëzielú rníꞌill de quë zéꞌdëll de gubeꞌe? ");
INSERT INTO zacNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús guniꞌi iurní: ―¿Pëzielú ruadiꞌdzë të cuntrë na? ");
INSERT INTO zacNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni tubi adë chu guídëdiꞌi lua lë́ꞌësë, napë quë Shtada, el quë nabësheꞌldë na, guësëdchini më mënë lua, nu na guëcuaꞌñia lë́ꞌëll lúltimë dzë. ");
INSERT INTO zacNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ra librë shtë ra nabiadiꞌdzë shtiꞌdzë Dios guahietë, rniꞌi zdëꞌë: “Dios guëluaꞌa grë ra mieti”. Zni grë́tëꞌ el quë naguëquë́ diaguë shtiꞌdzë Shtada nu el quë nabëdëꞌë cuendë shtíꞌdziꞌ, ni ridë lua. ");
INSERT INTO zacNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ni tubi adë chu gunádiꞌi lu Shtada; sulë na gunahia lu më purquë na zelda de Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Guldía rniaꞌa, el quë natsaldí lduꞌi shtiꞌdza, nápëll vidë sin fin. ");
INSERT INTO zacNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na nahia guetështildi narneꞌe vidë eternë. ");
INSERT INTO zacNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ra shtadë guëlú hiaꞌa gudáu raiꞌ maná lu shlatë perë guti raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Lëꞌë guetështildi verdadërë zeꞌdë de gubeꞌe; si talë gudáu tubi nguiu guetështildi ni, guëbánill tubi vidë nanadë rialúdiꞌi; gátidiꞌill. ");
INSERT INTO zacNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na nahia guetështildi verdadërë nazeꞌdë de gubeꞌe. Si talë gau nguiu guetështildi ni, nápëll vidë sin fin. Lëꞌë guetështildi nardëꞌa na prupi shcuerpa. Guëdë́ꞌahin parë gac salvar ra mënë narëtaꞌ lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Iurní lëꞌë ra israelitë guzublú rall quëchupë diꞌdzë lu saꞌ rall, mizmë lëꞌë rall. Guniꞌi rall: ―¿Llallë gac guëneꞌe mënë ni mizmë shcuérpiꞌ guëdáuhaꞌa? ");
INSERT INTO zacNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús guniꞌi lu raiꞌ: ―Guldía rniaꞌa, si talë lëꞌë të gáudiꞌi të cuerpë shtë nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, nu si talë gúdiꞌi të rënë shtënë më ni, nápëdiꞌi të vidë sin fin. ");
INSERT INTO zacNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","El quë nagáu cuerpë shtëna nu el quë nagú shrëna, nápëll vidë sin fin, nu na guëcuaꞌñia lë́ꞌëll lúltimë dzë. ");
INSERT INTO zacNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Cuerpë shtëna na verdadërë cumidë nu rënë shtëna na bebidë verdadërë. ");
INSERT INTO zacNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","El quë nagunë recibir na ziquë cumidë verdadërë nu ziquë bebidë verdadërë, guëbaninull na, nu quëbezënúa lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Lëꞌë Dadë Dios nanabani, bësheꞌldë më na, nu nabania por lë́ꞌiꞌ. El quë nagunë recibir na, guëbánill por pudërë shtëna. ");
INSERT INTO zacNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Na ruadiꞌdza shcuendë guetështildi naná zeꞌdë lu gubeꞌe. Guetështildi rëꞌ nádiꞌi cumë ziquë maná naná gudáu ra shtadë guëlú hiaꞌa; aunquë gudáu raiꞌ maná, guti raiꞌ. El quë nagáu guetështildi verdadërë, guëbánill parë siemprë. ");
INSERT INTO zacNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús bëluaꞌa grë́tëꞌ ra cusë rëꞌ laꞌni iáduꞌu shtë Capernaum. ");
INSERT INTO zacNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iurní zihani ra narianaldë lëꞌë Jesús, iurë bini rall diꞌdzë rëꞌ, guniꞌi raiꞌ: ―Naganë diꞌdzë rëꞌ. ¿Chu rac tsaldí lduꞌu shtiꞌdzë Jesús? ");
INSERT INTO zacNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iurní lëꞌë Jesús bëdëꞌë cuendë de quë ra shini gusëꞌdë më guniꞌi raiꞌ mizmë diꞌdzë; gunaꞌbë diꞌdzë më lu raiꞌ: ―¿Pë gulaguë llanë lduꞌu të por shtiꞌdza? ");
INSERT INTO zacNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Pë gunë të si talë guëná të lu nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, tsépiꞌ catë cabéziꞌ más antsë? ");
INSERT INTO zacNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Lëꞌë Espíritu Santo rneꞌe vidë sin fin; lëꞌë cuerpë shtë nguiu adë nápëdiꞌin pudërë. Ra diꞌdzë narniaꞌa lu të, na pudërë shtë Espíritu parë gapë të vidë sin fin. ");
INSERT INTO zacNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Perë todavía nanú sëbëldá de lëꞌë të, adë rialdídiꞌi lduꞌu të shtiꞌdza. Jesús guc bëꞌa dizdë principi chu el quë narialdídiꞌi lduꞌi nu guc bëꞌa më chu el quë nagunë intriegu lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Guniꞌi më: ―Por ni guniaꞌa lu të, ni tubi adë chu guidë lua si talë Shtada adë gueꞌdënúdiꞌi më nguiu ni lua. ");
INSERT INTO zacNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Dizdë iurní cantidá mënë nazianaldë lëꞌë Jesús, bësaꞌnë rall lëꞌë më; hiadë rzënúdiꞌi rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Iurní lëꞌë Jesús gunaꞌbë díꞌdziꞌ lu ra chiꞌbë chupë shini gusëꞌdë më: ―¿Pë nu lëꞌë të rac shtuꞌu të guësaꞌnë të na? ");
INSERT INTO zacNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Perë Simón Pedro bëquebi: ―Dadë, ¿callë guiá naꞌa? Sulë lë́ꞌël ruadíꞌdzël diꞌdzë narneꞌe vidë sin fin. ");
INSERT INTO zacNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Lëꞌë naꞌa gualdí lduꞌu naꞌa de verdá nu rdëꞌë naꞌa cuendë de quë nal Cristo, shini Dios nanabani. ");
INSERT INTO zacNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús bëquebi: ―Gudilia chiꞌbë chupë të perë tubi de lëꞌë të na mëdzabë. ");
INSERT INTO zacNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Zni quëgniꞌi më shcuendë Judas Iscariote, shini Simón purquë Judas bëꞌnë intriegu lëꞌë më parë gati më. Bëꞌnë Judas ni aunquë nall tubi de chiꞌbë chupë shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Despuësë de ndëꞌë, Jesús ziaꞌa regiuni shtë Galilea. Adë rac shtúꞌudiꞌi më niazë́ më Judea purquë ra contrari shtë më rac shtuꞌu rall quini rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Perë hia ziagdchini laní narniꞌi rall Laní shtë Cusechë; na laní parë grë ra mënë israelitë. ");
INSERT INTO zacNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ra bëchi Jesús guniꞌi rall lu më: ―Adë rëáꞌnëdiꞌil ndëꞌë; guziáꞌal parë Judea të parë grë́tëꞌ nazeꞌdë naldë lë́ꞌël, ra naquëreldë ndë, guëná rall milagrë narúnël. ");
INSERT INTO zacNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pues si talë tubi mënë rac shtuꞌu gac bëꞌa mënë chu nall, adë rúnëdiꞌill milagrë nagaꞌchi. Hia quë lë́ꞌël rúnël ra milagrë, bëꞌnë lo mizmë delantë lu grë mënë shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nilë ra bëchi Jesús adë gualdídiꞌi lduꞌu rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Iurní guniꞌi Jesús: ―Runë faltë guëgaꞌa iurë parë guënë́ mënë chu nahia, perë parë lëꞌë të grë iurë na igual. ");
INSERT INTO zacNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Grë ra narialdídiꞌi lduꞌi Dios, adë guëldënúdiꞌi rall lëꞌë të, perë na, sí, rna záꞌquëdiꞌi rall lua purquë na runa grë́tëꞌ lo quë narniꞌi Dios. Nu clarë rluaꞌa lo quë naquëhunë rall, nádiꞌin bien sino mal nahin. ");
INSERT INTO zacNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gulë gua laní. Na adë tsádiaꞌa purquë laꞌdi bëgaꞌa iurë guëluaꞌa pudërë shtëna. ");
INSERT INTO zacNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Despuësë de guniꞌi më zni, bëaꞌnë më Galilea. ");
INSERT INTO zacNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Despuësë de gua ra bëchi Jesús laní, nu zac Jesús gua më laní. Lë́dëdiꞌi shlatë shlatë gua më sino casi nagaꞌchi gua më. ");
INSERT INTO zacNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ra contrari shtë më caguili rall lëꞌë më lu laní, nu guniꞌi rall: ―¿Gua chaꞌa nguiu ni? ");
INSERT INTO zacNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ladi ra mënë zihani quëadiꞌdzë ra mënë shcuendë më. Zeꞌdë narniꞌi: “Tubi nguiu zaꞌquë na më rëꞌ”. Stubi rall rniꞌi: “Nádiꞌi më zaꞌquë sino rguguë́ mënë ni ra mënë”. ");
INSERT INTO zacNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Perë ni tubi rall adë bërúꞌudiꞌi rall favurë de lëꞌë më purquë rdzëbë rall ra contrari shtë më. ");
INSERT INTO zacNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hia guëruldë laní ziazú; iurní Jesús guatë́ iáduꞌu ruꞌbë. Guzublú quëgluaꞌa më. ");
INSERT INTO zacNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ra mënë israelitë nabini shtiꞌdzë më, nalë́ rdzëguëëꞌ lduꞌu rall lo quë narniꞌi më. Guniꞌi rall: ―¿Llallë rac nguiu rëꞌ lëtrë? ¿Ca guagsë́ꞌdëiꞌ? ");
INSERT INTO zacNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús bëquebi: ―Enseñansë narluáꞌahia, lëdë shtë́nëdiaꞌain, sino zeꞌdin de lëꞌë më nabësheꞌldë na. ");
INSERT INTO zacNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Si talë cualquier mënë na dispuestë gúnëll ziquë rac shtuꞌu Dios, gunguë bë́ꞌall ldaiꞌ nacagluáꞌahia, zeꞌdin de Dios; gac bë́ꞌall lë́dëdiꞌin por mizmë shcuenda. ");
INSERT INTO zacNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","El quë naruadiꞌdzë por mizmë lë́hiꞌ, rac shtúꞌull hunurë shtë ra mënë perë el quë naruadiꞌdzë parë gúnëll honrar el quë nabësheꞌldë më ni, ni sí, nall verdá. Nídiꞌi bishi laꞌni ldúꞌull. ");
INSERT INTO zacNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Pëllë adë nádiꞌi verdá de quë Moisés bëneꞌe lëy parë lëꞌë hiaꞌa? perë sin quë adë guëtë́ꞌdëdiꞌi, ni tubi de lëꞌë të adë në́diꞌi të guëzuꞌbë diaguë të lëy ni. ¿Pëzielú rac shtuꞌu të quini të na? ");
INSERT INTO zacNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ra mënë bëquebi: ―Nápël tubi mëdzabë laꞌni ldúꞌul. ¿Chull de lëꞌë naꞌa rac shtuꞌu quini lë́ꞌël? ");
INSERT INTO zacNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús guniꞌi: ―Por tubi cusë nabëna, grë́tëꞌ të rdzëguëëꞌ lduꞌu të hashtë pë nápëdiꞌi guëniꞌi të ");
INSERT INTO zacNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","perë Moisés bëneꞌe tubi custumbrë religiusë narunë ra mënë con ra ngulëꞌnë. Lë́dëdiꞌi guzublú Moisés custumbrë ni sino quë shtadë guëlú hiaꞌa más antsë, bëneꞌe rall custumbrë ni; por ni riuguë duꞌpë partë delicadë shtë ngulëꞌnë aunquë runë tucarë dzë narziꞌi lduꞌu mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Pues iurneꞌ parë adë gunë fáltëdiꞌi lëy nabëquëꞌë Moisés, lëꞌë të quëhunë të cumplir custumbrë ni aunquë na dzë narziꞌi lduꞌu mënë. ¿Pëzielú rldënú të na purquë bënëaca tubi nguiu dzë descansë? ");
INSERT INTO zacNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Adë rúnëdiꞌi të juzguë según cusë narná të sino gulë bëꞌnë juzguë tubldí. ");
INSERT INTO zacNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Iurní bëldá ra naquëreldë Jerusalén, guzublú rall quëgnaꞌbë diꞌdzë rall: ―¿Pëllë lëdë lë́ꞌëdiꞌi naquëguili contrari shtë́nëll parë gátiꞌ? ");
INSERT INTO zacNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Gulë guná, lë́ꞌëll quëadíꞌdzëll delantë lu grë mënë nu adë pë rniꞌi contrari shtë́hiꞌ. ¿Ni mudë ra më gushë shtë iáduꞌu, rialdí lduꞌu rall lëꞌë nguiu ni, de quë lë́ꞌiꞌ náhiꞌ Cristo, el quë nagudili Dios parë guënibë́ꞌaiꞌ? ");
INSERT INTO zacNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Perë lëꞌë hiaꞌa nanë́ hiaꞌa ca nezë zéꞌdiꞌ, perë iurë Cristo guëdchíniꞌ, ni tubi adë guënéꞌediꞌi cuendë ca nezë guídiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iurë lëꞌë Jesús bini zndëꞌë, quëgluaꞌa më laꞌni iáduꞌu ruꞌbë. Fuertë guniꞌi më: ―Lëꞌë të runguë bëꞌa të na nu nanë́ të nezë ca zelda. Zéldëdiaꞌa por partë shtëna sino bësheꞌldë më naná verdá, perë adë runguë bë́ꞌadiꞌi të lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Perë na, sí, runguë bë́ꞌahia lëꞌë më purquë de lëꞌë më zelda, nu bësheꞌldë më na. ");
INSERT INTO zacNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Iurní guc shtuꞌu rall niuaꞌa rall lëꞌë më prësi, perë ni tubi chu adë gunáꞌzidiꞌi lëꞌë më purquë laꞌdi guëgaꞌa iurë gati më. ");
INSERT INTO zacNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Perë cantidá mënë gualdí lduꞌu rall shtiꞌdzë më nu guniꞌi rall lu saꞌ rall: ―Iurë lëꞌë Cristo guëdchini lu guë́ꞌdchiliu, ¿ni mudë gúniꞌ milagrë más naruꞌbë quë ra milagrë naquëhunë nguiu rëꞌ? ");
INSERT INTO zacNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ra fariseo bini rall shtiꞌdzë mënë, lo quë narniꞌi rall shcuendë Jesús. Iurní lëꞌë rall juntë con ra bëshuzi naná më ruꞌbë entrë lëꞌë rall, bësheꞌldë rall soliar shtë iáduꞌu parë guaꞌa rall lëꞌë më prësi. ");
INSERT INTO zacNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Iurní guniꞌi Jesús: ―Guëbezënúa lëꞌë të stuꞌpë tiempë más. Despuësë de ni, guëabría; guzëahia lu më nabësheꞌldë na. ");
INSERT INTO zacNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Lëꞌë të tsatili të na perë adë guëdzélëdiꞌi të na purquë adë gáquëdiꞌi tsa të catë quërelda. ");
INSERT INTO zacNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Iurní lëꞌë ra contrari shtënë Jesús guzublú rnaꞌbë diꞌdzë lu saꞌ rall: ―¿Callë tsa nguiu rëꞌ? nu adë gáquëdiꞌi chu tsatili lë́ꞌëll. ¿Ni mudë guziáꞌall parë stubi guëꞌdchi zitu catë quëreldë más më israelitë entrë ra mënë griego? ¿Ni mudë tsagluáꞌall mënë nanádiꞌi israelitë? ");
INSERT INTO zacNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Pë runë cuntienë naguníꞌill: “Quili të na perë adë guëdzélëdiꞌi të na purquë adë gáquëdiꞌi të tsa të catë quërelda”? ");
INSERT INTO zacNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Hia bëgaꞌa lúltimë dzë shtë laní, dzë namás delicadë. Dzë ni lëꞌë Jesús guasuldí nu guniꞌi më fuertë: ―Si talë tubi de lëꞌë të rbidchi të, gulë teꞌe lua, gu të naguënehia. ");
INSERT INTO zacNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ziquë rniꞌi Sagradas Escrituras, zili nisë guëldani nu guëruꞌu laꞌni lduꞌu ra narialdí lduꞌu shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Quëgniꞌi Jesús shcuendë Espíritu Santo el quë natsaldí lduꞌu lëꞌë më, gunë rall recibir; perë todavía bëdchínidiꞌi Espíritu Santo purquë todavía runë faltë gac resucitar më ladi ra tëgulë nu laꞌdi guzëádiꞌi më gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bëldá ra mënë narëtaꞌ iurë bini rall naguniꞌi Jesús, guniꞌi rall: ―Verdá nguiu rëꞌ na el quë naruadiꞌdzë shtiꞌdzë Dios, el quë nanapë quë guëdchini. ");
INSERT INTO zacNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Stubi rall guniꞌi: ―Ndëꞌë na Cristo, el quë nagudili Dios parë guënibë́ꞌaiꞌ. Perë stubi bëldá rall guniꞌi: ―¿Callë gac më Galilea Cristo? ");
INSERT INTO zacNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Sagradas Escrituras rniꞌi de quë Cristo na llëbní David nu napë quë guëdchíniꞌ de Belén, guëꞌdchi shtë David. ");
INSERT INTO zacNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Zni ra mënë guc dividir por shcuendë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bëldá rall guc shtuꞌu niuaꞌa rall lëꞌë më prësi perë bëdzélëdiꞌi rall pë nihunënú rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Lëꞌë soliar shtë iáduꞌu bëabrí rall stubi catë rëtaꞌ ra fariseo con ra jëfë shtë bëshuzi. Iurní gunaꞌbë diꞌdzë rall lu soliar: ―¿Pëzielú beꞌdënúdiꞌi të nguiu ni? ");
INSERT INTO zacNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ra soliar bëquebi: ―Nídiꞌi chu stubi naruadiꞌdzë ziquë nguiu rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Iurní ra fariseo guniꞌi rall: ―¿Acasë nu lëꞌë të guguë́ të? ");
INSERT INTO zacNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Ni mudë gualdí lduꞌu cualquier de tubi gubiernë shtë ra fariseo u stubi më ruꞌbë gualdí ldúꞌull shtiꞌdzë Jesús? ");
INSERT INTO zacNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Perë los de más mënë adë guënë́diꞌi rall lëy; nacondenarë rall. ");
INSERT INTO zacNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo, el quë naguagná lëꞌë Jesús gueꞌlë, nu nall tubi fariseo, guníꞌill lu saꞌll: ");
INSERT INTO zacNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Según rniꞌi lëy shtë hiaꞌa, gáquëdiꞌi condenar tubi nguiu sin adë chu guínidiꞌi primërë parë gac bëꞌa hiaꞌa pë lo quë nabëꞌnë mënë ni. ");
INSERT INTO zacNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Iurní guniꞌi rall guëc Nicodemo: ―¿Pë nul nal më Galilea? Bësëꞌdë shtiꞌdzë Dios, nu guëdë́ꞌël cuendë de quë ni tubi naruadiꞌdzë shtiꞌdzë Dios, guëdchínidiꞌiꞌ de Galilea.  ");
INSERT INTO zacNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Iurní cadë tubi rall ziagzë́ rall lidchi rall. ");
INSERT INTO zacNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Perë Jesús ziaꞌa parë lu dani nalë los Olivos. ");
INSERT INTO zacNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Stubi dzë iurë brëgueꞌlë, bëabrí më iáduꞌu ruꞌbë. Grë́tëꞌ ra mënë guabiꞌguë lu më. Iurní guzubë më nu guzublú cagluaꞌa më ra dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Iurní ra mësë shtë lëy con ra fariseo, beꞌdënú rall tubi naꞌa nabëdzelënú nguiu nanádiꞌi tséꞌlëll. Bëzú rall lëꞌë naꞌa guëláu lu ra mënë narëtaꞌ ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Iurní guniꞌi rall lu Jesús: ―Naꞌa rëꞌ bëdzelë shtu; bëdzelënull tubi nguiu. ");
INSERT INTO zacNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lëy shtë Moisés rniꞌi; quëgnibë́ꞌahin de quë gati naꞌa rëꞌ con guëꞌë, grë clasë naꞌa narunë zni. ¿Lë́ꞌël pë rníꞌil? ");
INSERT INTO zacNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Lëꞌë rall guniꞌi rall zni parë guëtëꞌdë rall prëbë lëꞌë më nu parë gac guëdchiꞌbë rall galquiá cuntrë lëꞌë më. Iurní Jesús bëáꞌchiꞌ; guzublú guëquëꞌë më lu guiuꞌu con shcuënë më; ");
INSERT INTO zacNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","perë lëꞌë rall ziaglaꞌguë quëgnaꞌbë diꞌdzë rall. Iurní guasuldí më; guniꞌi më: ―Cualquier de tubi lëꞌë të nanápëdiꞌi duldë, gac primërë guëldaꞌa guëꞌë lëꞌë naꞌa rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Iurní bëabrí më bëaꞌchi më stubi parë guëquëꞌë më lu guiuꞌu con shcuënë më. ");
INSERT INTO zacNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Perë lëꞌë rall iurë bini naguniꞌi Jesús, bini laꞌni lduꞌu rall; el mizmë shgabë rall rdëꞌë cuendë napë rall duldë. Iurní guzublú rruꞌu tubigá rall. Guzublú dizdë de más nagushë ra hashtë grë rall bëruꞌu rall de ngaꞌli. Iurë grë́tëꞌ rall gualú bëruꞌu, Jesús bëáꞌniꞌ niétiquë con lëꞌë naꞌa nazugaꞌa lu më. ");
INSERT INTO zacNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iurní Jesús guasuldí nu guná më ni tubi chu nádiꞌi. Sulë lëꞌë naꞌa zugáꞌall ngaꞌli. Iurní guniꞌi më: ―Nanë, ¿gua ra nardchiꞌbë galquiá guë́quël? ¿Pëllë ni tubi de lëꞌë rall bë́ꞌnëdiꞌi condenar lë́ꞌël? ");
INSERT INTO zacNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Lëꞌë naꞌa bëquebi: ―Aquëdiꞌi, ni túbidiꞌi, Dadë. Iurní Jesús guniꞌi: ―Ni na rúnëdiaꞌa condenar lë́ꞌël. Iurneꞌ bëagzë́ perë hia adë tsaglaꞌguë gúnëdiꞌil duldë. ");
INSERT INTO zacNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús guniꞌi stubi lu ra mënë: ―Nahia llni shtë ra mënë narë́ lu guë́ꞌdchiliu. El quë nagueꞌdë naldë na, gapë rall llni narneꞌe vidë sin fin. Jamás adë së́diꞌi rall nacahi. ");
INSERT INTO zacNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Iurní lëꞌë ra fariseo guniꞌi rall: ―Mizmë lë́ꞌël quëgníꞌil favurë de lë́ꞌël. Testimonio narníꞌil adë lasáquëdiꞌin. ");
INSERT INTO zacNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús bëquebi: ―Testimonio shtëna, sí, lasaquin aunquë mizmë na quëgniaꞌa favurë de na purquë nanë́a ca nezë zelda nu ca nezë guzëahia; perë lëꞌë të adë guënë́diꞌi të ca nezë zelda nu ca nezë guzëahia. ");
INSERT INTO zacNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lëꞌë të runë të juzguë según rëglë shtë guë́ꞌdchiliu; según rna të runë të juzguë, perë na adë rúnëdiaꞌa juzguë ni túbidiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Si talë na runa juzguë, lo quë narniaꞌa, tubldí nahin; lasaquin purquë adë rúnëdiaꞌa juzguë tubsia perë Dios Padre quëbezënúhiꞌ na; bësheꞌldë më na lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Laꞌni lëy shtë hiaꞌa naescritë de quë por chupë testigu narniꞌi lo mizmë diꞌdzë, napë quë tsaldí lduꞌu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Pues bien, na nahia tubi testigu favurë de na, nu lëꞌë Shtada Dios, më nabësheꞌldë na, náhiꞌ stubi testigu favurë de na. ");
INSERT INTO zacNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Iurní gunaꞌbë diꞌdzë rall: ―¿Guátiꞌi shtádël? Jesús repi: ―Lëꞌë të adë runguë bë́ꞌadiꞌi të na, nilë runguë bë́ꞌadiꞌi të Shtada. Si talë niunguë bëꞌa të na nu zac Shtada niunguë bëꞌa të. ");
INSERT INTO zacNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús guniꞌi ra diꞌdzë rëꞌ mientras quëgluaꞌa më laꞌni iáduꞌu ruꞌbë, tubi lugar catë nagaꞌa cajë shtë ofrendë; perë ni tubi de lëꞌë contrari shtë më, adë cuë́diꞌi valurë parë niuaꞌa rall lëꞌë më prësi. Gáꞌadiꞌi guëgaꞌa iurë shtë më, gati më. ");
INSERT INTO zacNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús bëabrí guníꞌiꞌ: ―Na guzëahia perë lëꞌë të tsatili të na. Gatinú të duldë shtë të. Catë tsahia lëꞌë të adë gáquëdiꞌi guidë të. ");
INSERT INTO zacNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Iurní ra contrari shtë më guniꞌi: ―¿Ni mudë el mizmë lë́ꞌëll quínill lë́ꞌëll? por ni rníꞌill: “Adë chu gáquëdiꞌi guidë të catë tsahia”. ");
INSERT INTO zacNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iurní Jesús guniꞌi: ―Lëꞌë të na të mënë shtë guë́ꞌdchiliu rëꞌ perë na, nahia de gubeꞌe. Lëꞌë të na të mënë shtë guë́ꞌdchiliu perë na adë nádiaꞌa mënë shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Por ni quëgniaꞌa lu të, gatinú të duldë shtë të purquë si talë adë në́diꞌi të tsaldí lduꞌu të nahia el quë narniaꞌa, gatinú të duldë shtë të. ");
INSERT INTO zacNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Iurní gunaꞌbë diꞌdzë rall: ―¿Chull nal? Jesús guniꞌi: ―Hia guniaꞌa lu të dizdë principi chu nahia ");
INSERT INTO zacNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","nu nápëruꞌu más guëniaꞌa lu të nu napë quë guna juzguë lëꞌë të, perë el quë nabësheꞌldë na, ni ruadíꞌdziꞌ verdá. Lo quë naquëgniaꞌa lu mënë, ni lo quë nabinia de lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Perë lëꞌë rall adë guasë́diꞌi rall pë guniꞌi Jesús, de quë quëgniꞌi më shcuendë Dadë Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Guniꞌi më iurní: ―Iurë lëꞌë të guëldisë të na guiaꞌa parë guëquëꞌë të na lu cruz, iurní gunguë bëꞌa të nahia el quë narniaꞌa nahia. Nahia nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. Tsasë́ të adë rúnëdiaꞌa según prupi voluntá shtëna sino rniaꞌa sulë lo quë nabëluaꞌa Shtada. ");
INSERT INTO zacNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","El quë nabësheꞌldë na, ni quëbezënúhiꞌ na. Shtada adë bësáꞌnëdiꞌi më na purquë siemprë runa lo quë narquitë ldúꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iurë Jesús guniꞌi ndëꞌë, zihani mënë gualdí lduꞌu rall na më el quë nabësheꞌldë Dios lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Iurní Jesús guniꞌi lu ra më israelitë nagualdí lduꞌi shtiꞌdzë më: ―Si tsaglaꞌguë tsanaldë të shtiꞌdza nu talë guëquë́ diaguë të shtiꞌdza, iurní de verdá na të shmëna. ");
INSERT INTO zacNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Gunguë bëꞌa të verdá nu lëꞌë verdá gunin të gapë të libertá. ");
INSERT INTO zacNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Lëꞌë rall bëquebi: ―Lëꞌë naꞌa na naꞌa llëbní Abraham. Lëꞌë naꞌa nunquë adë chu nádiꞌi bajo ordë shtë mënë. ¿Pëzielú rníꞌil lu naꞌa guëdapë naꞌa libertá? ");
INSERT INTO zacNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Guniꞌi më: ―Guldía rniaꞌa, grë́tëꞌ el quë narunë duldë, ni nall bajo ordë shtë duldë; rnibëꞌa duldë lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tubi naná bajo ordë shtë mënë, nápëdiꞌill derechë gáquëll partë shtë famili perë tubi shini raiꞌ, sí, ni napë derechë gáquëll partë shtë famili. ");
INSERT INTO zacNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Zni si talë shini Dios gúniꞌ librar lëꞌë të, guëaꞌnë të de verdá sin duldë. ");
INSERT INTO zacNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nanë́a de quë na të llëbní Abraham, perë el mizmë tiempë rac shtuꞌu të quini të na purquë adë rialdídiꞌi lduꞌu të lo quë narniaꞌa lu të. ");
INSERT INTO zacNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na ruadiꞌdza lo quë nagunahia catë cabezë Shtada, perë lëꞌë të runë të ziquë na shtadë të; cusë nabini të de shtadë të, ni quëhunë të. ");
INSERT INTO zacNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ra mënë guniꞌi lu Jesús: ―Shtadë guëlú naꞌa guc Abraham. Perë Jesús guniꞌi: ―Si talë lëꞌë të na të de verdá shini Abraham, ziquë bë́ꞌniꞌ, zni zac nihunë të. ");
INSERT INTO zacNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Rac shtuꞌu të quini të na, el quë naguniꞌi lu të purë verdá, diꞌdzë nabinia lu Shtada. Abraham nunquë bë́ꞌnëdiꞌiꞌ zniꞌi. ");
INSERT INTO zacNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Quëhunë të lo quë narac shtuꞌu shtadë të. Guniꞌi rall: ―Adë chu nádiꞌi ziquë meꞌdë lldubi. Napë naꞌa tubsë Shtadë naꞌa; náhiꞌ Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iurní guniꞌi Jesús: ―Si talë de verdá Dios na Shtadë të, lëꞌë të niac shtuꞌu të na purquë na adë zéldëdiaꞌa shcuendë iubia; zelda de Dios nu zugáꞌahia ndëꞌë. Adë zéldëdiaꞌa shcuendë iubia sino quë Dios bësheꞌldë më na. ");
INSERT INTO zacNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Pëzielú adë në́diꞌi të tsasë́ të lo quë narniaꞌa lu të? purquë adë rac shtúꞌudiꞌi të guini të shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Lëꞌë shtadë të na mizmë mëdzabë nu lëꞌë të na të de lë́ꞌëll. Ziquë rúnëll, runë të purquë lëꞌë mëdzabë na tubi narguini mënë dizdë gurështë́ guë́ꞌdchiliu. Nunquë adë nídiꞌi verdá laꞌni ldúꞌull nu nunquë adë biadíꞌdzëdiꞌill verdá. Iurë ruadíꞌdzëll, bishi quëhúnëll purquë nídiꞌi stubi cusë laꞌni ldúꞌull. Nu lë́ꞌëll na dadë shtë ra naruadiꞌdzë bishi. ");
INSERT INTO zacNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Perë cumë na ruadiꞌdza verdá, lëꞌë të adë në́diꞌi të tsaldí lduꞌu të shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Chu de lëꞌë të rac guëluaꞌa të napa masiá tubi duldë mituꞌnë? Si talë rniaꞌa verdá lu të, ¿pëzielú në́diꞌi të tsaldí lduꞌu të na? ");
INSERT INTO zacNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","El quë na shmënë Dios, ni rzuꞌbë diáguëll shtiꞌdzë Dios; perë ziquë lëꞌë të adë nádiꞌi të shmënë Dios, por ni në́diꞌi të guëquë́ diaguë të shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Iurní ra contrari shtë Jesús guniꞌi: ―Napë naꞌa segurë iurë rniꞌi naꞌa de quë nal tubi samaritano nu nápël tubi mëdzabë laꞌni ldúꞌul. ");
INSERT INTO zacNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús repi: ―Nídiꞌi mëdzabë laꞌni lduaꞌa. Quëhuna honrar Dadë Dios, perë lëꞌë të runë të desprëci na. ");
INSERT INTO zacNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Adë rac shtúꞌudiaꞌa gunë të honrar na; nanú tubi naná gunë honrar na, nu lëꞌë më gunë më juzguë. ");
INSERT INTO zacNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Guldía, el quë nagunë cumplir lo quë narniaꞌa, jamás adë gátidiꞌi nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Iurní ra contrari shtë më bëquebi rall: ―Iurneꞌ sí, napë naꞌa segurë nápël tubi mëdzabë laꞌni ldúꞌul. Abraham nu grë́tëꞌ ra nabiadiꞌdzë shtiꞌdzë Dios guahietë, guti raiꞌ, nu rníꞌil: “El quë nagunë cumplir lo quë narniaꞌa, jamás adë gátidiꞌill”. ");
INSERT INTO zacNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ni mudë nal más më ruꞌbë quë shtadë guëlú hiaꞌa Abraham? Lë́ꞌiꞌ gútiꞌ nu grë ra nabiadiꞌdzë shtiꞌdzë Dios guahietë, guti raiꞌ. ¿Chull rniꞌi ldúꞌul nal? ");
INSERT INTO zacNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús repi iurní: ―Si talë mizmë na quëhuna honrar na, adë lasáquëdiꞌi lo quë naquëhuna, perë Shtada quëhúniꞌ parë gunë mënë honrar na. Na më el mizmë de quë rniꞌi të náhiꞌ Dios shtë të. ");
INSERT INTO zacNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Perë lëꞌë të adë runguë bë́ꞌadiꞌi të lëꞌë më perë na, sí, runguë bë́ꞌahia lëꞌë më. Si talë nianiaꞌa lu të de quë adë runguë bë́ꞌadiaꞌa lëꞌë më, iurní nabisha igual ziquë lëꞌë të. Perë na guldía rniaꞌa, runguë bë́ꞌahia lëꞌë më nu quëhuna cumplir lo quë narniꞌi më lua. ");
INSERT INTO zacNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham, shtadë guëlú hiaꞌa, bëquitë ldúꞌiꞌ nu gúpiꞌ fe de quë guëdchini el quë naguësheꞌldë Dios lu guë́ꞌdchiliu. Nu de verdá gunáhiꞌ de quë bëdchinia nu guꞌ lëgrë laꞌni ldúꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Iurní guniꞌi rall lu Jesús: ―Todavía ni nápëdiꞌil cincuenta izë nu rníꞌil gunal lu Abraham. ");
INSERT INTO zacNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús bëquebi: ―Guldía rniaꞌa, antsë de Abraham hia nabania. ");
INSERT INTO zacNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iurní gunaꞌzi rall guëꞌë të parë guëldaꞌa rall lëꞌë Jesús perë lëꞌë më bëcaꞌchilú më. Bëruꞌu më laꞌni iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iurní ziadëdë Jesús stubi lugar; guná më lu tubi nguiu naná gulë ciegu. ");
INSERT INTO zacNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ra shini gusëꞌdë më gunaꞌbë diꞌdzë: ―Dadë, ¿pëzielú gulë nguiu rëꞌ ciegu; pë por duldë shtë shtádëll u por mizmë duldë shtë́nëll gúlëll ciegu? ");
INSERT INTO zacNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús repi: ―Gúquëdiꞌin por duldë shtë́nëll ni por duldë shtë shtádëll, sino quë gúlëll ciegu parë guëná mënë pudërë shtë Dios laꞌni vidë shtë́nëll. ");
INSERT INTO zacNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iurneꞌ na tiempë parë guëdë́ꞌnaꞌa dchiꞌni shtë më, el quë nabësheꞌldë na, purquë lëꞌë tiempë zeꞌdë, hia iurní adë chu gúnëdiꞌi dchiꞌni. ");
INSERT INTO zacNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mientras zugáꞌahia lu guë́ꞌdchiliu, nahia llni shtë ra narëtaꞌ lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Despuësë de guniꞌi Jesús ndëꞌë, bëchiꞌbë shënë më lu guiuꞌu. Bëntsaꞌu më duꞌpë benë con bëllënë. Iurní bëteꞌbi më benë lu slu ciegu. ");
INSERT INTO zacNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Iurní guniꞌi më: ―Guatibi lul ruaꞌ tanquë shtë Siloé. (Diꞌdzë ni runë cuntienë, el quë naguziaꞌa.) Lëꞌë ciegu guatibi slúhiꞌ. Iurní bëabrill; hia beꞌrquë rnall. ");
INSERT INTO zacNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Iurní lëꞌë ra vëcini nu los de más ra nananë́ lëꞌë ciegu, guniꞌi rall: ―¿Pë lëdë lë́ꞌëdiꞌi narzubë glli glli; rnáꞌbëll guꞌnë? ");
INSERT INTO zacNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bëldá rall guniꞌi: ―Lë́ꞌëll ndëꞌë. Stubi rall guniꞌi: ―Lë́ꞌëdiꞌill ndëꞌë perë ziquë rluaꞌa ciegu rluáꞌall. Mizmë lëꞌë nguiu guniꞌi: ―Na nahia nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Iurní gunaꞌbë diꞌdzë rall: ―¿Llallë bëac slul? ");
INSERT INTO zacNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Lëꞌë ciegu bëquebi: ―Lëꞌë nguiu naná lë Jesús bëntsaꞌu benë. Bëtéꞌbiꞌ slua nu guníꞌiꞌ lua: “Gua ruaꞌ tanquë shtë Siloé të guatibi slul”. Guahia iurní. Iurë na gudibia slua, hia beꞌrquë rnahia. ");
INSERT INTO zacNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Gunaꞌbë diꞌdzë rall: ―¿Guátiꞌi nguiu ni? Lëꞌë ciegu guniꞌi: ―Guënë́diaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Iurní biaꞌa mënë lëꞌë naguc ciegu lu ra fariseo. ");
INSERT INTO zacNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesús bëntsáꞌuhiꞌ duꞌpë benë nu bënëáquiꞌ lëꞌë nguiu ni dzë narziꞌi lduꞌu mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ra fariseo bëabrí gunaꞌbë diꞌdzë rall lu nguiu ni, llallë guc beꞌrquë rnall. Lë́ꞌëll guníꞌill: ―Benë bëtéꞌbiꞌ slua. Iurní guatibia slua; hia iurní gunahia. ");
INSERT INTO zacNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Iurní bëldá ra fariseo guniꞌi: ―Perë nguiu naná bëꞌnë ndëꞌë, lëdë de Diósëdiꞌi zéꞌdëll purquë rúnëdiꞌill rëspëti dzë narziꞌi lduꞌu mënë. Perë sëbëldá rall guniꞌi: ―¿Ni mudë nall pecadurë? purquë tubi pecadurë nápëdiꞌi pudërë gúniꞌ milagrë ziquë narunë më rëꞌ. Guc dividir ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Iurní bëabrí gunaꞌbë diꞌdzë ra fariseo lu naná antsë na ciegu: ―Lë́ꞌël, ¿pë rníꞌil parë lëꞌë nguiu nabëneꞌe slul? Lë́ꞌëll guníꞌill: ―Na rniaꞌa de quë na më tubi naruadiꞌdzë shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Perë lëꞌë rall adë gualdídiꞌi lduꞌu rall de quë guc ciegu nguiu ni nu iurneꞌ rnall, hashtë gunaꞌbë rall ra shtadë nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Iurní gunaꞌbë diꞌdzë rall lu shtadë nguiu: ―¿Pë lëꞌë shini të ndëꞌë? naná rniꞌi të gulë ciegu. ¿Llallë guc ni rnall? ");
INSERT INTO zacNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ra shtádiꞌ bëquebi: ―Nanë́ naꞌa de quë nguiu ni na shini naꞌa nu gúlëll ciegu ");
INSERT INTO zacNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","perë adë chu guënë́diꞌi lla guc ni de quë neꞌ rnall. Tampuquë guënë́diꞌi naꞌa chu bënëac slull. Gulë gunaꞌbë diꞌdzë lull. Hia më gúshëll; mizmë lë́ꞌëll guëníꞌill chu bënëac slull. ");
INSERT INTO zacNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Zni guniꞌi ra shtadë nguiu purquë rdzëbë raiꞌ ra më shtë iáduꞌu. Ra mënë shtë iáduꞌu na rall de acuerdë guëgú rall grë ra mënë narniꞌi de quë Jesús na Cristo, el quë nagudili Dios parë guënibë́ꞌaiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Por ni guniꞌi shtadë ciegu: “Gulë gunaꞌbë diꞌdzë lull; hia më gúshëll”. ");
INSERT INTO zacNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Iurní ra mënë shtë iáduꞌu, bëabrí gunaꞌbë rall lu ciegu; repi rall: ―Guniꞌi lu naꞌa purë verdá. Guniꞌi de quë Dios bënëac lë́ꞌël nu bëdëꞌë graci lu më, perë lëꞌë naꞌa nanë́ naꞌa de quë Jesús na pecadurë. ");
INSERT INTO zacNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Iurní repi ciegu: ―Adë guënë́diaꞌa si nall pecadurë u aquëdiꞌi; lúniquë lo quë nananë́a de quë na nahia ciegu nu iurneꞌ rnahia bien. ");
INSERT INTO zacNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bëabrí gunaꞌbë diꞌdzë rall: ―¿Pëllë bë́ꞌnëtiꞌi? ¿Pëllë bë́ꞌnëll parë bënéꞌell slul? ");
INSERT INTO zacNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Lëꞌë ciegu bëquebi: ―Hia guniaꞌa lu të nu iurneꞌ adë në́diꞌi të guëdëꞌë të cuendë. ¿Pëzielú bëabrí guniꞌi të zniꞌi? ¿Ni mudë rac shtuꞌu të gac të shmënë nguiu ni? ");
INSERT INTO zacNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Iurní gurushtiá rall. Guniꞌi guidzë rall lëꞌë ciegu: ―Lë́ꞌël nal shmënë nguiu ni, perë lëꞌë naꞌa rianaldë naꞌa lëy shtë Moisés. ");
INSERT INTO zacNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Lëꞌë naꞌa nanë́ naꞌa de quë Dios guniꞌi lu Moisés perë níꞌiꞌ, ni siquierë adë chu guënë́diꞌi ca nezë bërúꞌull. ");
INSERT INTO zacNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Iurní lëꞌë nguiu bëquebi: ―¿Lla na shgabë të? Rniꞌi të guënë́diꞌi të ca nezë bërúꞌull perë gulë guná, bënëáquiꞌ slua. ");
INSERT INTO zacNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bien nanë́ hiaꞌa de quë Dios rínidiꞌi shtiꞌdzë ra mënë nanapë duldë; rini më shtiꞌdzë el quë narunë adorar lëꞌë më de verdá nu rini më el quë narunë según voluntá shtë më. Ni sí, rini më shtíꞌdziꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Pues dizdë gurështë́ guë́ꞌdchiliu, laꞌdi chu bínidiꞌi de quë tubi mënë bëdëꞌë slu nagulë ciegu. ");
INSERT INTO zacNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Si talë Jesús adë zéꞌdëdiꞌiꞌ de Dios, adë gáquëdiꞌi pë gúniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Iurní guniꞌi rall guëc ciegu: ―Lë́ꞌël gúlël ziquë pecadurë nu nápël duldë, nu rac shtúꞌul guëluáꞌal lëꞌë naꞌa. Iurní gulú rall lëꞌë ciegu laꞌni iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús guc bëꞌa de quë lëꞌë nguiu ni gulú hiaꞌldë rall iáduꞌu, hia jamás guasúdiꞌiruꞌuiꞌ iáduꞌu. Iurë lëꞌë më bëdiaꞌguëlú lëꞌë nguiu ni, guniꞌi më lull: ―¿Gu rialdí ldúꞌul shtiꞌdzë shini Dios? ");
INSERT INTO zacNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Lëꞌë nguiu ni guniꞌi: ―Dadë, guniꞌi lua ¿chull më ni? të parë tsaldí lduaꞌa lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iurní guniꞌi Jesús: ―Hia lë́ꞌël gunal lúhiꞌ. Na nahia mënë ni naquëadiꞌdzënul. ");
INSERT INTO zacNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Iurní lëꞌë nguiu bëzullibi lu Jesús nu guníꞌill: ―Rialdí lduaꞌa, Dadë. ");
INSERT INTO zacNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Lueguë guniꞌi Jesús: ―Na zelda lu guë́ꞌdchiliu të parë guna juzguë ra mënë. Zelda të parë ra ciegu guëná rall, nu parë grë ra narniꞌi rna rall, guëabrí gac rall ciegu. ");
INSERT INTO zacNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Iurní bëldá ra fariseo naquëbezënú lëꞌë më, guniꞌi rall: ―¿Ni mudë nu lëꞌë naꞌa na naꞌa ciegu? ");
INSERT INTO zacNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús bëquebi: ―Si talë lëꞌë të na të ciegu, ni tubi faltë nápëdiꞌi të lu Dios, perë cumë ziquë rniꞌi të de quë rna të, pues napë të duldë delantë lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Guldía rniaꞌa, el quë natsutë́ ruaꞌ gurrali shtë lliꞌli, na el quë naquëhapë ra ma; perë el quë naná riutë́ stubi tëchi, ni lëꞌë ngubaꞌnë nartëꞌtsë ma. ");
INSERT INTO zacNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Perë el quë nariutë́ ruaꞌ gurrali, na vëquërë shtë ra lliꞌli. ");
INSERT INTO zacNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Lëꞌë naná portërë rsháꞌlëll ruaꞌ puertë parë riutë́ vëquërë shtë lliꞌli. Nu runguë bëꞌa ra lliꞌli chaꞌ vëquërë ni. Rnaꞌbë vëquërë cadë lëꞌë ra ma con lë ma. Nu rgu vëquërë lëꞌë ra ma laꞌni gurrali. ");
INSERT INTO zacNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Despuësë rgu vëquërë lëꞌë ra ma shtë́nëll, grë́tëꞌ ra lliꞌli rianaldë tëchi vëquërë. Hia lëꞌë lliꞌli zianaldë tëchi më purquë rini ma chaꞌ më ");
INSERT INTO zacNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","perë adë rianáldëdiꞌi ra lliꞌli tubi mënë naguënë́diꞌi ma. Al contrari, rlluꞌnë ma lu ra mënë ni purquë adë guënë́diꞌi ma chaꞌ mënë ni. ");
INSERT INTO zacNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús bëzú comparaciuni rëꞌ perë lëꞌë rall adë guasë́diꞌi rall lo quë naquëadiꞌdzë më lu rall. ");
INSERT INTO zacNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Iurní lëꞌë Jesús bëabrí guniꞌi më: ―Guldía rniaꞌa lu të, nahia ruaꞌ puertë shtë ra lliꞌli. ");
INSERT INTO zacNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Grë ra naná bidë antsë de na, na rall ziquë ngubaꞌnë nacaꞌa ra lliꞌli parë mizmë lëꞌë rall, nu na rall ziquë narruꞌu lu ra mënë, perë ra lliꞌli adë bë́ꞌnëdiꞌi cuendë shtiꞌdzë rall. ");
INSERT INTO zacNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na nahia puertë; el quë natsutë́ por na nasalvárëll, nu na rall ziquë lliꞌli nariutë́ ruaꞌ gurrali nu rruꞌu ma; adë runë faltë nagáu ma. Napë ra ma zihani dau. ");
INSERT INTO zacNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Perë lëꞌë ngubaꞌnë nadë más rídëll parë rbaaꞌnëll nu parë rguínill ra lliꞌli nu rzalull lëꞌë ma; perë na zelda parë gapë të vidë sin fin nu parë gapë tëhin sin adë runë fáltëdiꞌin. ");
INSERT INTO zacNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nahia vëquërë zaꞌquë. Guënehia vidë shtëna por ra lliꞌli. ");
INSERT INTO zacNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","El quë narunë dchiꞌni nadë más por pagu, iurë lë́ꞌëll rnall zeꞌdë tubi ma dushë, rsáꞌnëll ra lliꞌli; más bien rllúꞌnëll lu ma dushë. Iurní lëꞌë ma dushë rnaꞌzi lëꞌë lliꞌli nu rtëꞌtsë ma lliꞌli. El quë nádiꞌi vëquërë shtë lliꞌli, rsáꞌnëll ra lliꞌli purquë nádiꞌill nashtënë ma. ");
INSERT INTO zacNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Así es quë nguiu rëꞌ rllúꞌnëll purquë nadë más rúnëll dchiꞌni por pagu; adë rúnëdiꞌill importë ra lliꞌli. ");
INSERT INTO zacNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Na nahia vëquërë zaꞌquë. Runguë bë́ꞌahia ra shiꞌlia nu ra shiꞌlia runguë bëꞌa raiꞌ na. ");
INSERT INTO zacNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ziquë Shtada runguë bëꞌa na, na runguë bë́ꞌahia lëꞌë Shtada. Na rdchiꞌba vidë shtëna por ra lliꞌli. ");
INSERT INTO zacNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Napa stubi partidë lliꞌli nanádiꞌi ndëꞌë; napë quë tsagnaꞌba lëꞌë rall. Guëquë́ diaguë ma chahia; gac ma tubsë partidë nanapë tubsë vëquërë. ");
INSERT INTO zacNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Lëꞌë Dadë Dios rac shtuꞌu na purquë rdë́ꞌëhia vidë shtëna; gatia por ra mënë nu despuësë guëabrí guëbania. ");
INSERT INTO zacNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni tubi adë chu guëdchisúdiꞌi vidë shtëna sino na rdë́ꞌëhia vidë shtëna por voluntá shtëna, nu napa pudërë de quë despuësë guëdë́ꞌahin, guëbania stubi. Zni na ordë nabëna recibir de Shtada. ");
INSERT INTO zacNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iurë ra contrari shtë më bini rall grë diꞌdzë rëꞌ, iurní bëabrí guc dividir rall. ");
INSERT INTO zacNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Cantidá rall guniꞌi: ―¿Pëzielú runë të cuendë hiumbrë rëꞌ? cumë nápëll mëdzabë laꞌni ldúꞌull. Rac lúguëll. ");
INSERT INTO zacNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Sëbëldá rall guniꞌi: ―Ni tubi chu nanapë mëdzabë laꞌni lduꞌu, gac gunë ziquë runë më rëꞌ. ¿Ni mudë tubi nanapë mëdzabë guëdë́ꞌëiꞌ slu ciegú? ");
INSERT INTO zacNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Hia bëgaꞌa tiempë naldë. Ciudá Jerusalén bëꞌnë tucarë laní narëagná lduꞌu ra mënë dzë nagualú dchiꞌni shtë iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús canzë́ ruaꞌ iáduꞌu ruꞌbë catë nanú portali shtë Salomón. ");
INSERT INTO zacNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ra contrari shtë më bëtiaꞌa rdondë rall lëꞌë më nu guniꞌi rall: ―¿Guc guëníꞌil lu naꞌa clarë de quë lë́ꞌël nal Cristo? të tsaldí lduꞌu naꞌa. Guniꞌi por derechë tubigasë të guënë́ naꞌa de verdá nal el quë nagudili Dios parë guënibë́ꞌal. ");
INSERT INTO zacNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Guniꞌi Jesús: ―Hia guniaꞌa lu të perë adë në́diꞌi të tsaldí lduꞌu të shtiꞌdza. Grë́tëꞌ cusë el quë nabëna, guc por pudërë shtë Shtada; ra milagrë rluaꞌain de quë nahia shini Dios ");
INSERT INTO zacNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","perë lëꞌë të adë në́diꞌi të tsaldí lduꞌu të shtiꞌdza purquë nádiꞌi të shiꞌlia. Hia guniaꞌa lu të antsë. ");
INSERT INTO zacNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ra shiꞌlia rini shtiꞌdza nu nanë́a ra lliꞌli shtëna, nu lëꞌë ra shiꞌlia ridë naldë na. ");
INSERT INTO zacNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Na rdëꞌa lëꞌë rall vidë sin fin; jamás adë tsagnítidiꞌi rall parë siemprë. Ni tubi adë chu cúdiꞌi shiꞌlia lu guiahia. ");
INSERT INTO zacNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Shtada bëneꞌe lëꞌë rall parë na. Lëꞌë më na más më ruꞌbë quë grë nanabani. Napë më pudërë nu adë ni tubi chu cúdiꞌi shiꞌlia lu guiaꞌa Shtada. ");
INSERT INTO zacNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Lëꞌë Shtada con na, na naꞌa tubsë. ");
INSERT INTO zacNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Iurní ra contrari shtë Jesús bëabrí gunaꞌzi rall guëꞌë parë guëldaꞌa rall lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesús guniꞌi lu rall: ―Cantidá cusë zaꞌquë bëna delantë lu të por pudërë shtë Shtada, ¿por guadë puntë naguëneꞌe guëꞌë të na? ");
INSERT INTO zacNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Guniꞌi rall: ―Adë chu guënéꞌediꞌi guëꞌë lë́ꞌël por tubi cusë zaꞌquë nabë́ꞌnël sino quë guníꞌil mal cuntrë Dios. Nguiu nal perë rníꞌil nal Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iurní guniꞌi Jesús: ―Laꞌni lëy shtë hiaꞌa naescritë: “Guníꞌihia lëꞌë të na të dioses”, ");
INSERT INTO zacNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","nu nanë́ hiaꞌa de quë Sagradas Escrituras na verdá, adë chu gúnëdiꞌi anular shtiꞌdzë më catë bërulë́ ra mënë dioses, grë́tëꞌ ra nabëꞌnë recibir shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Talë Dios gulë́ na nu bëꞌnë ldaiꞌ më na nu bësheꞌldë më na lu guë́ꞌdchiliu, ¿pëzielú rniꞌi të de quë na guniaꞌa diꞌdzë cuntrë Dios iurë guniaꞌa lu të: “Nahia shini Dios”? ");
INSERT INTO zacNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Si talë quëhúnëdiaꞌa dchiꞌni shtë Shtada, adë tsaldídiꞌi lduꞌu të na. ");
INSERT INTO zacNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Perë si talë runa milagrë con pudërë shtë Dios, aunquë adë rialdídiꞌi lduꞌu të na, gulë tsaldí lduꞌu të lo quë naquëhuna të gac bëꞌa të nu tsaldí lduꞌu të purquë Shtada quëhúniꞌ grë́tëꞌ cusë ni por na; unidë na naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bëabrí rall stubi parë guaꞌa rall lëꞌë më prësi perë Jesús bëruꞌu guiaꞌa rall. ");
INSERT INTO zacNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iurní Jesús bëabrí stubi ladë cuꞌ guiaꞌa guëëꞌgu Jordán, mizmë lugar catë bëchuꞌbë nisë Juan ra mënë guëlútëꞌ. Ndë bëaꞌnë më. ");
INSERT INTO zacNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Cantidá mënë guagná rall lëꞌë më nu guniꞌi rall: ―De verdá Juan adë bë́ꞌnëdiꞌiꞌ milagrë ruꞌbë nanianá ra mënë perë grë́tëꞌ el quë naguniꞌi Juan shcuendë nguiu rëꞌ, verdá nahin. ");
INSERT INTO zacNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Cantidá ra mënë gualdí lduꞌu rall lëꞌë Jesús lugar ni. ");
INSERT INTO zacNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Laꞌni guëꞌdchi Betania guquëreldë Lázaro con chupë zánëll, María nu Marta. Rac lluꞌu Lázaro. ");
INSERT INTO zacNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mizmë María ni antsë gati Jesús, bëtéꞌbëiꞌ sëiti nashi guëaꞌ Jesús nu bëcuë́ꞌdchiꞌ con guitsë guë́quiꞌ guëaꞌ më. Zanë María rac llúꞌull. ");
INSERT INTO zacNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Marta nu María bësheꞌldë bëldá mënë naguaguëchi lu Jesús: ―Dadë, lëꞌë el quë nalë́ rac shtúꞌul, lë́ꞌëll rac llúꞌull. ");
INSERT INTO zacNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iurë bini më lo quë naguniꞌi rall, guniꞌi më: ―Galguidzë rëꞌ adë tsalúdiꞌi con galguti, más bien parë guëná të pudërë shtë Dios, nu por galguidzë rëꞌ ra mënë guëniꞌi rall llëruꞌbë na pudërë shtëna. Guëniꞌi rall llëruꞌbë na pudërë shtë shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nalë́ guc shtuꞌu Jesús Marta nu béldëll nu Lázaro. ");
INSERT INTO zacNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Iurë lëꞌë ra mënë repi lu Jesús de quë Lázaro rac llúꞌiꞌ, bëaꞌnë më chupë dzë catë nanú më. ");
INSERT INTO zacNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Despuësë guniꞌi më lu ra shini gusëꞌdë më: ―Cha guiá hiaꞌa stubi hashtë Judea. ");
INSERT INTO zacNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Guniꞌi raiꞌ lu më: ―Mësë, ¿ni mudë tsal Judea stubi? Guc lduꞌu ra contrari shtë́nël niaguini rall lë́ꞌël con guëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús guniꞌi: ―¿Pëllë lëdë guldídiꞌi narniꞌi: “Chiꞌbë chupë iurë napë tubi dzë”? Si talë chu ziaꞌa rdzë, adë rréldëdiꞌill purquë rnall lu llni shtë ngubidzë, ");
INSERT INTO zacNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","perë si talë chu ziaꞌa gueꞌlë, ni sí, rreldë ni purquë runë faltë llni. ");
INSERT INTO zacNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Despuësë de guniꞌi Jesús diꞌdzë rëꞌ, guniꞌi më: ―Lëꞌë amigu shtë hiaꞌa, Lázaro, gutëgaꞌsi perë na tsacuaꞌñia lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Iurní lëꞌë ra shini gusëꞌdë më guniꞌi: ―Dadë, si talë nagaꞌsi Lázaro, guëáquiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Perë Jesús quëgniꞌi de quë Lázaro guti. Ra shini gusëꞌdë më runë shgabë raiꞌ de quë quëadiꞌdzë më shcuendë mbëcaꞌldë. ");
INSERT INTO zacNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Iurní clarë guniꞌi më: ―Lázaro hia guti ");
INSERT INTO zacNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","perë na rquitë lduaꞌa de quë núdiaꞌa con lë́ꞌiꞌ parë tsaldí lduꞌu të na. Cha guiá guëná hiaꞌa lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Iurní lëꞌë Tomás, el quë narniꞌi raiꞌ Cuachi, guníꞌiꞌ lu los de más shini gusëꞌdë më: ―Cha guiá hiaꞌa nu lëꞌë hiaꞌa të parë gatinú hiaꞌa lëꞌë më ndë. ");
INSERT INTO zacNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Iurë bëdchini Jesús guëlladchi Betania, bíniꞌ lëꞌë Lázaro hia guc tapë dzë bëgáꞌchiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania naquë́ guëlladchi ruaꞌ Jerusalén cumë ziquë chupë kilómetro guëruldë. ");
INSERT INTO zacNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Cantidá më israelitë guaguëꞌnë visitar lëꞌë Marta nu María parë gac consolar raiꞌ por tëgulë, zanë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Iurë Marta guc bëꞌa de quë Jesús ziagdchini, bërúꞌuiꞌ; guagtsaꞌguëlúhiꞌ lëꞌë Jesús perë María bëaꞌnë hiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta guniꞌi lu Jesús: ―Dadë, si talë niaquëréldël ndëꞌë, adë niátidiꞌi zana. ");
INSERT INTO zacNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Perë nanë́a de quë Dios guëneꞌe grë́tëꞌ lo quë naná rnáꞌbël lu më. ");
INSERT INTO zacNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús guniꞌi lu Marta: ―Lëꞌë zánël guëabrí guëbániꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta guniꞌi: ―Nanë́a de quë guëabrí guëbániꞌ iurë guëbani ra tëgulë stubi, lúltimë dzë. ");
INSERT INTO zacNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús guniꞌi: ―Rcuaꞌñia ra tëgulë, nu rdëꞌa vidë sin fin. El quë narialdí lduꞌi na, aunquë nilë gútill, guëabrí guëbánill. ");
INSERT INTO zacNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nu grë́tëꞌ el quë nanabani iurneꞌ nu tsaldí ldúꞌull na, jamás adë gátidiꞌill. ¿Gu rialdí ldúꞌul ndëꞌë, Marta? ");
INSERT INTO zacNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta guniꞌi iurní: ―Ahaꞌ Dadë, rialdí lduaꞌa de quë nal Cristo, shini Dios, el quë nanapë quë guëdchini lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Despuësë de guniꞌi Marta diꞌdzë rëꞌ, guagnáꞌbëiꞌ béldiꞌ María. Iurní guniꞌi Marta guitsë guitsë: ―Hia lëꞌë mësë nanú ndëꞌë. Lë́ꞌiꞌ quëgnáꞌbëiꞌ lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Lueguë guasuldí María nu guagnáhiꞌ lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús laꞌdi tsutë́diꞌi më guëꞌdchi. Lëꞌë më quëreldë më lugar catë bëdiaꞌguëlú më Marta. ");
INSERT INTO zacNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Iurë ra më guëꞌdchi ni, ra nabëdchini parë gac consolar raiꞌ, guná rall guziaꞌa María, guasuldí rall nasesë. Guagnaldë rall lëꞌë María; guniꞌi lu saꞌ rall: ―Guziaꞌa María ruaꞌ baꞌa parë gúꞌniꞌ ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Iurë lëꞌë María bëdchini catë zugaꞌa Jesús, bëzullibi María guëaꞌ Dadë nu guníꞌiꞌ: ―Dadë, si talë nanul ndëꞌë, adë niátidiꞌi zana. ");
INSERT INTO zacNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iurë lëꞌë Jesús guná ruꞌnë María, nu guná më lu ra mënë narunë compañi lëꞌë zanë tëgulë, nu guná më ruꞌnë raiꞌ, nalë́ bëdchini tristë laꞌni lduꞌu më, demasiadë gubini lduꞌu më. ");
INSERT INTO zacNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Gunaꞌbë diꞌdzë më lu ra mënë: ―¿Ca bëgaꞌchi tëgulë? Guniꞌi rall: ―Dadë, gudeꞌe guënal. ");
INSERT INTO zacNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iurní Jesús bíꞌniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ra mënë guniꞌi iurní: ―Gulë guná, blac rac shtuꞌu më lëꞌë tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Perë bëldá ra mënë guniꞌi: ―Ndëꞌë lëꞌë el quë nabëdëꞌë slu ciegu, ¿pëllë nápiꞌ pudërë parë niátidiꞌi Lázaro? ");
INSERT INTO zacNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús nalë́ gubini ldúꞌiꞌ stubi. Iurní guabiꞌguë më ruaꞌ baꞌa. Nahin ziquë tubi nichë laꞌni dani. Daꞌu ruahin tubi guëꞌë ruꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús guniꞌi: ―Gulë bëdchisú guëꞌë rëꞌ. Marta, zanë tëgulë, guníꞌiꞌ: ―Dadë, perë rldiaꞌa nahiuꞌdzë tëgulë purquë hia guc tapë dzë gútiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Perë Jesús guniꞌi: ―¿Pë adë guníꞌidiaꞌa lul de quë si talë tsaldí ldúꞌul na, guënal pudërë shtë Dios? ");
INSERT INTO zacNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Iurní bëdchisú rall guëꞌë nananú ruaꞌ baꞌa. Jesús gubiꞌa lu gubeꞌe nu guniꞌi më: ―Dadë, dushquíllil purquë rínil grë́tëꞌ lo quë narnaꞌba lul. ");
INSERT INTO zacNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nanë́a de quë lë́ꞌël rquë diáguël shtiꞌdza siemprë perë rniaꞌa lul por bien shtë ra mënë narëtaꞌ ndëꞌë të parë tsaldí lduꞌu rall de quë lë́ꞌël bëshéꞌldël na. ");
INSERT INTO zacNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Despuësë de guniꞌi më ndëꞌë, iurní fuertë guniꞌi më: ―Lázaro, bëruꞌu ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lëꞌë tëgulë bëruꞌu. Ra guiaꞌa Lázaro nu guëáhiꞌ liꞌbi con lari vendas. Nu lu Lázaro daꞌu tubi lari. Jesús guniꞌi: ―Bëshaꞌquë lari rëꞌ të parë gac guzëáhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Con milagrë ni másruꞌu gualdí lduꞌu ra mënë israelitë shtiꞌdzë Jesús, ra mënë nabëꞌnë compañi lëꞌë María. Guná rall lo quë nabëꞌnë më nu gualdí lduꞌu rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Perë bëldá mënë gua rall lu fariseo nu guaguëchi rall grë lo quë nabëꞌnë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Iurní ra fariseo nu ra jëfë shtë ra bëshuzi bëdëá rall con ra Junta Suprema naná runë juzguë. Guniꞌi rall lu saꞌ rall: ―¿Pë guëdë́ꞌnaꞌa? Jesús quëhunë cusë ruꞌbë nu milagrë. ");
INSERT INTO zacNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Si talë guëdëꞌë hiaꞌa sí lë́ꞌëll, grë́tëꞌ mënë tsaldí lduꞌu rall lëꞌë Jesús, nu ra gubiernë shtë ra mënë rumanë guëdchini rall të parë guëzalú rall iáduꞌu shtë hiaꞌa. Guëdubi naciuni shtë hiaꞌa guëdëꞌë rall fin. ");
INSERT INTO zacNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Perë tubi de lëꞌë rall, Caifás, nall mërë jëfë shtë ra bëshuzi izë ni; guníꞌiꞌ: ―Lëꞌë të adë guënë́diꞌi të ");
INSERT INTO zacNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","nu adë rdë́ꞌëdiꞌi të cuendë de quë más mejurë parë lëꞌë hiaꞌa, gati tubsë nguiu, lë́dëdiꞌi grë guëꞌdchi guëniti nu guëdubi naciuni tsalú. ");
INSERT INTO zacNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás guníꞌidiꞌi zndëꞌë por shcuéndëll; más bien cumë nall jëfë shtë ra bëshuzi izë ni, guníꞌiꞌ diꞌdzë rëꞌ purquë el Espíritu Santo bëꞌnë compañi lë́ꞌëll guëníꞌill cusë naguër gac. Guníꞌill gati Jesús shlugar naciuni Israel. ");
INSERT INTO zacNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Lëdë guníꞌidiꞌill lë́ꞌësë shcuendë naciuni Israel sino quë gati Jesús parë guëtëá më grë́tëꞌ shini Dios naná bërëꞌtsë stubi naciuni. ");
INSERT INTO zacNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Zni dizdë dzë ni, ra contrari shtë Jesús bëꞌnë rall de acuerdë parë quini rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Por ni hia Jesús adë në́diꞌiꞌ ziazë́ më shlatë shlatë Jerusalén catë ra contrari shtë më nanú, sino bëruꞌu më regiuni shtë Judea. Guziaꞌa më tubi lugar naquë́ guëlladchi catë na tubi shlatë, tubi lugar nalë Efraín. Ngaꞌli bëaꞌnë më con ra shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Hia runë faltë stuꞌpsë parë laní Pascu shtë ra mënë israelitë. Cantidá mënë guëꞌdchi gua rall Jerusalén parë gac laní. Bëꞌnë tucarë gunë rall custumbrë parë gac limpi rall según custumbrë shtë rall antsë bëgaꞌa laní. ");
INSERT INTO zacNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ra mënë quëguili rall lëꞌë Jesús. Iurë rëtaꞌ rall iáduꞌu ruꞌbë, gunaꞌbë diꞌdzë lu saꞌ rall: ―¿Pë zidë Jesús lu laní u adë guídëdiꞌill? ");
INSERT INTO zacNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ra fariseo nu ra jëfë shtë ra bëshuzi gunibëꞌa rall de quë si talë chu guini u chu guná lu Jesús, tsanú rall rsunë të parë guënaꞌzi rall lëꞌë më prësi. ");
INSERT INTO zacNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Shuꞌpë dzë antsë laní Pascu, Jesús gua guëꞌdchi Betania catë quëreldë Lázaro. Lázaro na el quë nabëcuaꞌñi Jesús ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ngaꞌli bëꞌnë rall tubi shtse parë Jesús, gau më. Marta bëꞌnë sirvë lu mellë. Lázaro guzubënúhiꞌ Jesús lu mellë. ");
INSERT INTO zacNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Iurní lëꞌë María bëdchininú tubi guëruldë litro sëiti nashi shtë nardo. Lasaquin zihani dumí. Bëtéꞌbëiꞌ sëiti ni guëaꞌ Jesús. Iurní bëcuë́ꞌdchiꞌ guëaꞌ më con guitsë guë́quiꞌ. Guëdubi laꞌni hiuꞌu guꞌtë olor nashi. ");
INSERT INTO zacNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Iurní guniꞌi tubi shini gusëꞌdë më, Judas Iscariote, mizmë Judas nagunë intriegu lëꞌë Jesús, guniꞌi Judas: ");
INSERT INTO zacNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Pëzielú niatuuꞌ nisë nashi rëꞌ por tsunë gahiuꞌa bëllë bëdchichi parë guëdëꞌë hiaꞌa caꞌa prubi? ");
INSERT INTO zacNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Perë Judas adë guníꞌidiꞌill zni purquë bëgaꞌa ldúꞌull ra prubi sino nall ngubaꞌnë. Nall tesurërë shtë dumí nu rbaaꞌnëll dumí lo quë nardëꞌë ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iurní guniꞌi Jesús: ―Zuzú naꞌa purquë bë́ꞌniꞌ zniꞌi por dzë na guëgaꞌcha. ");
INSERT INTO zacNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ra prubi zugaꞌa con lëꞌë të guëdubi tiempë perë na lëdë cuezënúdiaꞌa lëꞌë të guëdubi tiempë. ");
INSERT INTO zacNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Cantidá ra më israelitë guc bëꞌa rall de quë Jesús nanú Betania. Gua rall ngaꞌli, lëdë niáꞌasëdiꞌi parë guëná rall lu Jesús sino quë rac shtuꞌu rall guëná rall lu Lázaro, el quë nabëcuaꞌñi Jesús ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Iurní lëꞌë ra jëfë shtë ra bëshuzi guꞌ rall de acuerdë parë quini rall Lázaro ");
INSERT INTO zacNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","purquë por shtiꞌdzë Lázaro cantidá ra mënë israelitë bësaꞌnë rall ldaiꞌ shtë ra fariseo nu gualdí lduꞌu rall Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Zihani mënë gua Jerusalén parë laní Pascu. Stubi dzë bini rall de quë Jesús ziagdchini parë ciudá Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Iurní bëchuguë rall llicu hiaguë zini parë guagtsaꞌguëlú rall lëꞌë më, fuertë guniꞌi rall: ―Gunë Dios salvar. Llëruꞌbë na Rëy shtë hiaꞌa nazeꞌdë por lë Dadë Dios. Benditë na Rëy shtë Israel. ");
INSERT INTO zacNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús gudchibë më tëchi burrë. Zni rniꞌi Sagradas Escrituras: ");
INSERT INTO zacNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Adë rdzë́bëdiꞌi të, mënë naquëreldë guëꞌdchi Sión. Gulë guná Rëy shtënë të; zeꞌdë guëdchíniꞌ. Dchíꞌbiꞌ tëchi burrë. ");
INSERT INTO zacNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ra shini gusëꞌdë më adë guasë́diꞌi raiꞌ lueguë; hashtë más despuësë iurë lëꞌë Jesús guashtë́hiꞌ ladi ra tëgulë, iurní bëagná lduꞌu raiꞌ grë́tëꞌ ndëꞌë naescritë lo quë narniꞌi laꞌni Sagradas Escrituras shcuendë Jesús. Bëagná lduꞌu raiꞌ lo quë naguc con Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nu ra mënë nazunú Jesús iurë lëꞌë më gunaꞌbë më Lázaro laꞌni baꞌa nu bëcuaꞌñi më lëꞌë Lázaro ladi ra tëgulë, biadiꞌdzë rall lu ra mënë lo quë naguná rall. ");
INSERT INTO zacNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Por ni ra mënë bëruꞌu; guagtsaꞌguëlú rall lëꞌë Jesús. Bini rall de quë Jesús bëꞌnë milagrë con Lázaro ");
INSERT INTO zacNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","perë ra fariseo guniꞌi lu saꞌ rall: ―¿Gu rna të ni tubi adë chu pë rúnëdiꞌi? Gulë guná, grë ra mënë narë́ lu guë́ꞌdchiliu, zianaldë rall lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Entrë ra mënë nabëdchini Jerusalén parë gunë rall adorar Dios, nanú bëldá mënë griego. ");
INSERT INTO zacNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Guabiꞌguë rall lu Felipe më Betsaida, tubi guëꞌdchi shtë Galilea. Bëꞌnë rall ruëguë lu Felipe; guniꞌi rall: ―Dadë, rac shtuꞌu naꞌa guëná naꞌa lu Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe guagniꞌi lu Andrés. Guërupë raiꞌ guaguëchi raiꞌ lu Jesús de quë ra më griego rac shtuꞌu rall guëná rall lu më. ");
INSERT INTO zacNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iurní Jesús guniꞌi: ―Neꞌ bëgaꞌa iurë të guëluaꞌa Dios llëruꞌbë na pudërë shtëna, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Guldía rniaꞌa, si talë tubi bëꞌdchi trigu adë ldáguëdiꞌin laꞌni guiuꞌu nu ratsu luhin, todavía nahin tubsë bëꞌdchi, perë si talë ldaguë bëꞌdchi lu guiuꞌu nu gatsu luhin, tsaldanin nu guëneꞌein zihani bëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","El quë naquëhapë vidë shtë́niꞌ no más parë mizmë lë́ꞌëll, segurë guënitin, perë el quë naná dispuestë guëniti vidë shtë́niꞌ por na, guëbánill parë siemprë. ");
INSERT INTO zacNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Si talë chu rac shtuꞌu gunë sirvë lua, napë quë gueꞌdë náldëll na. Catë riahia, ndë guëdzelë el quë narunë sirvë lua. Si talë chu gunë sirvë lua ziquë shmëna, gunë Shtada honrar nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Guniꞌi Jesús: ―Iurneꞌ adë rbedchídiꞌi lduaꞌa perë ¿pë guna? ¿Ni mudë guëniaꞌa lu Shtada: “Bëlá na lo quë nagaca”? purquë parë ni zelda lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dadë, bëluaꞌa pudërë nanápël. Iurní bëdchini tubi bë nabëruꞌu lu gubeꞌe. Guniꞌi bë: ―Hia guc bëluáꞌahia pudërë shtëna, nu guëluáꞌahia pudërë shtëna stubi. ");
INSERT INTO zacNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ra mënë zihani narëtaꞌ ngaꞌli, bini rall lëꞌë bë. Bëldá rall guniꞌi de quë nguziꞌu gubë́. Sëbëldá rall guniꞌi: ―Tubi ianglë biadiꞌdzë lu më dizdë gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iurní Jesús guniꞌi: ―Lëdë por nádiꞌi bëdchini bë rëꞌ sino por lëꞌë të parë tsaldí lduꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Iurneꞌ bëgaꞌa iurë de quë lëꞌë guë́ꞌdchiliu rëꞌ gac juzguë. Nu iurneꞌ guësëlluꞌnë Dios lëꞌë Satanás, el quë narnibëꞌa mënë shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Iurë lëꞌë ra mënë guëquëꞌë rall na lu cruz, manërë ni guënaꞌba grë ra mënë lua. ");
INSERT INTO zacNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Zni guniꞌi më lu rall parë guëdëꞌë rall cuendë lla mudë gati më. ");
INSERT INTO zacNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ra mënë guniꞌi rall lu Jesús: ―Riasë́ naꞌa por ra Sagradas Escrituras de quë lëꞌë Cristo guëbániꞌ parë siemprë. ¿Pëzielú rníꞌil de quë lëꞌë nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu, gac crucificáriꞌ? ¿Chu na el quë nabësheꞌldë Dios? ");
INSERT INTO zacNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iurní Jesús guniꞌi lu rall: ―Por stuꞌpë tiempë nanú llni entrë ladi të. Gulë tsaglaꞌguë tsanaldë të llni. Gulë cue mientras napë të llni të parë adë guënáꞌzidiꞌi nacahi lëꞌë të terciuni. Na ziquë el quë narzë́ lu nacahi; rdë́ꞌëdiꞌill cuendë ca nezë tsall. ");
INSERT INTO zacNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Gulë tsaldí lduꞌu të lëꞌë llni mientras zugaꞌa llni lu guë́ꞌdchiliu. Zni gac të shini Dios nanapë llni shtë më laꞌni lduꞌu të. Despuësë de guniꞌi më ra cusë rëꞌ, Jesús guziaꞌa nu bëcaꞌchilú më lu rall. ");
INSERT INTO zacNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús bëꞌnë zihani milagrë ruꞌbë lu ra mënë perë adë gualdídiꞌi lduꞌu rall na më shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Pues zni guc cumplir naguniꞌi Isaías, tubi nabiadiꞌdzë shtiꞌdzë Dios guahietë. Bëquëꞌë Isaías: Dadë, ¿chull gualdí lduꞌu dizaꞌquë shtë hiaꞌa? ¿Chull gualdí lduꞌu iurë bëluáꞌal pudërë shtë́nël lúhiꞌ? ");
INSERT INTO zacNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Por ra diꞌdzë rëꞌ adë bë́ꞌnëdiꞌi rall gan tsaldí lduꞌu rall purquë nu zac naescritë laꞌni mizmë librë shtë Isaías: ");
INSERT INTO zacNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios bëꞌnë ra mënë ciegu nu bë́ꞌniꞌ naguëdchi lduꞌu rall të parë adë guënádiꞌi rall con slull, nu tsasë́diꞌi rall con lduꞌu rall. Guquin parë adë guëabrídiꞌi lduꞌu rall con Dadë Dios të gunëac më lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías guniꞌi zndëꞌë purquë gunáhiꞌ lu Jesucristo de quë llëruꞌbë na pudërë shtë më. ");
INSERT INTO zacNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Zihani më narnibëꞌa, gualdí lduꞌu rall lëꞌë Jesús perë adë në́diꞌi guëniꞌi rall delantë lu mënë de quë na rall shmënë Jesús. Bëdzëbë rall ra fariseo të parë guëgúdiꞌi ra fariseo lëꞌë rall laꞌni iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Más bëquitë lduꞌu rall gunë mënë alabar lëꞌë rall quë nihunë rall cumplir voluntá shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús guniꞌi fuertë: ―El quë natsaldí lduꞌi na, lëdë niáꞌasëdiꞌi na rialdí lduꞌi sino también rialdí lduꞌi Shtada el quë nabësheꞌldë na. ");
INSERT INTO zacNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","El quë narná lua, rna lu më el quë nabësheꞌldë na. ");
INSERT INTO zacNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nahia llni. Zelda lu guë́ꞌdchiliu. Grë́tëꞌ el quë narialdí lduꞌi na, adë guëáꞌnëdiꞌill laꞌni nacahi. ");
INSERT INTO zacNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Si talë tubi de lëꞌë të rini të shtiꞌdza, perë adë rzuꞌbë diáguëdiꞌil shtiꞌdza, lëdë nádiꞌi guna condenar mënë ni purquë adë zéldëdiaꞌa lu guë́ꞌdchiliu parë guna condenar lëꞌë ra mënë sino zelda parë guna salvar ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","El quë naguëquë́ guiaꞌa na nu adë rialdídiꞌi lduꞌu shtiꞌdza, nápëll el quë nagunë condenar lë́ꞌëll. Ra diꞌdzë naguniaꞌa lull, ni nagunë condenar ra mënë ni lúltimë dzë. ");
INSERT INTO zacNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Adë ruadíꞌdzëdiaꞌa según voluntá shtëna; lëꞌë Shtada el quë nabësheꞌldë na, gunibë́ꞌaiꞌ na parë guëniaꞌa lu të. Lo quë nabëluáꞌahia, na mandamientë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nu rac bë́ꞌahia el quë nagunë cumplir mandamientë shtë Shtada, nápëll vidë eternë. Grë lo quë narniaꞌa, zeꞌdë de Shtada; lo quë naguniꞌi më lua, zni ruadiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Antsë bëdchini laní Pascu, rac bëꞌa Jesús de quë hia lëꞌë iurë bëgaꞌa parë gati më nu guësëaꞌnë më ra shini gusëꞌdë më; guzëá më lu Shtadë më. Nalë́ guc shtuꞌu më ra shini gusëꞌdë më nananú guë́ꞌdchiliu. Guc shtuꞌu më lëꞌë raiꞌ hashtë gati më. ");
INSERT INTO zacNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Hia gualú shtse shtë Pascu, iurní lëꞌë mëdzabë bëuꞌ laꞌni lduꞌu Judas Iscariote, shini Simón. Bëꞌnë mëdzabë parë rac shtuꞌu Judas gúnëll intriegu lëꞌë Jesús guiaꞌa ra contrari shtë më. ");
INSERT INTO zacNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús hia guc bëꞌa de quë zeꞌdë më de Dios nu guëabrí më con Dios nu lëꞌë Dadë bëdëꞌë grë́tëꞌ pudërë parë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Guasuldí më lu mellë. Iurní bëdchisú më lari lu guiaꞌa nanacu më. Bëldiꞌbi më tubi toallë laꞌni më. ");
INSERT INTO zacNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Iurní gudë́ më nisë laꞌni tubi natsëꞌë. Guzublú më gudibi më guëaꞌ ra shini gusëꞌdë më nu bëshá më toallë nanuaꞌa më guëaꞌ shini gusëꞌdë më parë guëbidchi nisë. ");
INSERT INTO zacNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iurë bëdchini më lu Simón të quíbiꞌ guëaꞌ Simón Pedro, perë Pedro guniꞌi: ―¿Pë lë́ꞌël quíbil guëahia? ");
INSERT INTO zacNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús guchi lu Pedro: ―Iurneꞌ adë riasë́diꞌil lo quë naquëhuna perë despuësë sí, tsasël. ");
INSERT INTO zacNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Perë Pedro guniꞌi: ―Jamás adë quíbidiꞌil guëahia. Jesús guchi lu Pedro: ―Si talë guëzunë́diaꞌa lë́ꞌël, hiadë nádiꞌil shmëna. ");
INSERT INTO zacNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Guniꞌi Simón Pedro: ―Iurneꞌ pë Dadë, lëdë niáꞌasëdiꞌi guëahia tsati sino también guiahia nu guëca. ");
INSERT INTO zacNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Perë Jesús guniꞌi: ―El quë naná gualú guzë, adë rquíꞌnidiꞌi gázëll stubi, nadë más guëaꞌll tsati. Hia lëꞌë të limpi lduꞌu të perë lëdë grë́diꞌi të. ");
INSERT INTO zacNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Guniꞌi më adë grë́diꞌi raiꞌ na raiꞌ limpi purquë guc bëꞌa më chu gunë intriegu lëꞌë më. Por ni guniꞌi më: “Lëdë grë́diꞌi të na të limpi”. ");
INSERT INTO zacNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Despuësë de gudibi më guëaꞌ ra shini gusëꞌdë më, Jesús bëabrí gutë më shabë më; iurní guzubë më stubi lu mellë. Guniꞌi më: ―¿Gu riasë́ të lo quë naná bëna? ");
INSERT INTO zacNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Lëꞌë të rniꞌi të nahia mësë nu Dadë shtë të. Napë të rsunë purquë ni nahia. ");
INSERT INTO zacNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pues na, mësë nu Dadë shtë të, gudibia guëaꞌ të nu zac lëꞌë të napë quë quibi të guëaꞌ saꞌ të. ");
INSERT INTO zacNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na bëdchiꞌba tubi muestrë parë lëꞌë të. El mizmë ni gunë të con saꞌ të ziquë nabëna. ");
INSERT INTO zacNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Guldía rniaꞌa, tubi muzë adë lasáquëdiꞌill más quë shlámiꞌ; más lasac nabësheꞌldë lëꞌë muzë. ");
INSERT INTO zacNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Si talë rdëꞌë të cuendë lo quë narniaꞌa lu të nu gunë të cumplirin, iurní rquitë lduꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Adë quëgníꞌidiaꞌa de grë të. Na rac bë́ꞌahia guadë el quë nagulëhia perë napë quë gac cumplir lo quë narniꞌi Sagradas Escrituras: “El quë naraunú na, ni bëꞌnë cuntrë na parë gatia”. ");
INSERT INTO zacNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Dizdë iurneꞌ rniaꞌa lu të antsë gac ndëꞌë të parë gac bëꞌa të nahia el quë naguniaꞌa nu parë tsaldí lduꞌu të shtiꞌdza iurë lëꞌë ndëꞌë gac. ");
INSERT INTO zacNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Guldía rniaꞌa lu të, el quë nagunë recibir el quë naná bësheꞌlda, ni gunë recibir na, nu el quë nagunë recibir na, ni gunë recibir el quë nabësheꞌldë na. ");
INSERT INTO zacNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iurë gualú guniꞌi Jesús diꞌdzë ni, nalë́ bëꞌnë më llgabe laꞌni lduꞌu më; nalë́ gubini lduꞌu më. Iurní guniꞌi më con diꞌdzë clarë: ―Guldía rniaꞌa, tubi de lëꞌë të gunë intriegu na lu galguti. ");
INSERT INTO zacNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ra poshtë guzublú gubiꞌa raiꞌ lu saꞌ raiꞌ perë adë bëdë́ꞌëdiꞌi raiꞌ cuendë chu gunë intriegu lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tubi de lëꞌë raiꞌ, el quë narac shtuꞌu më, zúbiꞌ culaꞌni Jesús; caniháuhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro bëꞌnë sëñi con guiáꞌaiꞌ të guënaꞌbë diꞌdzë nguiu ni lu Jesús, chu gunë intriegu lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Iurní nguiu ni guniꞌi lu Jesús: ―Dadë, ¿chull gunë intriegu lë́ꞌël? ");
INSERT INTO zacNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús bëquebi: ―Guëtiáꞌahia pedasë guetështildi laꞌni platë nu guëdë́ꞌahin caꞌa nguiu nagunë intriegu na. Iurní bëtiaꞌa Jesús guetështildi laꞌni platë nu bëdëꞌë më pedasë cuaꞌa Judas Iscariote, shini Simón. ");
INSERT INTO zacNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas bëꞌnë recibirin; lueguë lueguë Satanás guatë́ laꞌni ldúꞌull. Iurní Jesús guniꞌi lu Judas: ―Lo quë narac shtúꞌul gúnël, bëꞌnin lueguë. ");
INSERT INTO zacNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Perë ni tubi de los de más poshtë adë guc bë́ꞌadiꞌi raiꞌ pëzielú guniꞌi më zndëꞌë lu Judas. ");
INSERT INTO zacNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Cumë Judas guc tesurërë shtë dumí, bëldá raiꞌ bëꞌnë raiꞌ llgabë de quë Jesús rac shtuꞌu tsasiꞌi Judas lo quë naná rquiꞌni lu laní, u tal vez guëdëꞌë Judas guꞌnë caꞌa ra prubi. ");
INSERT INTO zacNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Despuësë de lëꞌë Judas bëꞌnë recibir tubi ldë guetështildi, lueguë bërúꞌull. Hia riuꞌ gueꞌlë. ");
INSERT INTO zacNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Despuësë de lëꞌë Judas bëruꞌu, Jesús guniꞌi: ―Iurneꞌ guëluaꞌa Dios de quë llëruꞌbë na pudërë shtë nguiu nabësheꞌldë më lu guë́ꞌdchiliu, nu zihani mënë gunë rall alabar Dios por lo quë naguna; guëniꞌi rall llëruꞌbë na pudërë shtë më. ");
INSERT INTO zacNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Si guëluaꞌa llëruꞌbë pudërë shtë Dios por lo quë naguna, también guëluaꞌa më llëruꞌbë na pudërë shtëna. Adë gac ldëꞌë më parë gúniꞌ cumplirin. ");
INSERT INTO zacNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Lëꞌë të narac shtuaꞌa, adë zúdiaꞌa con lëꞌë të llëruꞌbë tiempë. Lëꞌë të tsatili të na perë cumë ziquë guniaꞌa lu contrari shtëna más antsë, rniaꞌa lu të lo mizmë iurneꞌ. Rniaꞌa lu të stubi de quë adë gáquëdiꞌi tsa të catë guzëahia. ");
INSERT INTO zacNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Perë rnehia tubi mandamientë cubi parë lëꞌë të de quë gac shtuꞌu të bëchi saꞌ të. Cumë ziquë na rac shtuaꞌa lëꞌë të, znígaꞌa lëꞌë të napë quë gac shtuꞌu të saꞌ të. ");
INSERT INTO zacNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Si talë gac shtuꞌu të saꞌ të de verdá, grë mënë shtë guë́ꞌdchiliu guëdëꞌë rall cuendë de quë na të shmëna. ");
INSERT INTO zacNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro gunaꞌbë diꞌdzë lu Jesús: ―Dadë, ¿ca tsal? Jesús guniꞌi: ―Catë guzëahia, hiadë gáquëdiꞌi gueꞌdë náldël lueguë perë despuësë, sí, iurní gueꞌdë náldël na. ");
INSERT INTO zacNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Iurní lëꞌë Pedro guniꞌi: ―Dadë, ¿pëzielú gáquëdiaꞌa gueꞌdë nalda lë́ꞌël iurneꞌ? Na nahia dispuestë guënehia vidë shtëna nu gatinúal. ");
INSERT INTO zacNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús guniꞌi iurní: ―¿Guënéꞌel vidë shtë́nël por na? Guldía rniaꞌa lul, antsë lëꞌë gay guëllidchí, guëníꞌil lu ra mënë de quë adë runguë bë́ꞌadiꞌil na. Tsunë vueltë guëníꞌil zni. ");
INSERT INTO zacNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Gulë cueꞌzë rquëdiꞌni lduꞌu të. Gulë tsaldí lduꞌu të Dios nu gulë tsaldí lduꞌu të na. ");
INSERT INTO zacNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lidchi Shtada nanú zihani lugar parë guëquëreldë të; si talë adë nádiꞌin zni, hia nianíꞌihia lu të. Zni gac tsaguëna preparar tubi lugar parë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Despuësë de bëna preparar lugar ni, iurní guëabría stubi con lëꞌë të, guëquëreldënú të na lidchi Shtada catë quërelda. ");
INSERT INTO zacNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Lëꞌë të nanë́ të ca nezë guzëahia nu nanë́ të nezë ni. ");
INSERT INTO zacNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Repi Tomás: ―Dadë, adë chu guënë́diꞌi ca nezë tsal. ¿Llallë guënë́ naꞌa nezë? ");
INSERT INTO zacNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús bëquebi: ―Nahia nezë parë gubeꞌe; na ruadiꞌdza verdá; rdëꞌa vidë sin fin; sulë por na gac guëdchini mënë lu Shtada. ");
INSERT INTO zacNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Si talë lëꞌë të runguë bëꞌa të na, nu zac Shtada runguë bëꞌa të. Nu lëꞌë të hia runguë bëꞌa të lë́ꞌiꞌ dizdë iurneꞌ purquë guná të lu më. ");
INSERT INTO zacNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Iurní Felipe guniꞌi: ―Dadë, bëluaꞌa Dios guëná naꞌa lúhiꞌ, hia con ni naꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Guniꞌi Jesús: ―Felipe, ¿blac tiempë quëbezënúa lëꞌë të nu todavía adë guënë́diꞌi të chu nahia? El quë naguná lua nu zac gunall lu Shtada. Nétiꞌi, ¿pëzielú rnáꞌbël de quë rac shtúꞌul guënal lu Dadë Dios? ");
INSERT INTO zacNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Pëllë adë riasël na quëbezënúa Dadë nu Dadë quëbezënúhiꞌ na? Grë lo quë narniaꞌa lu të, lëdë shcuendë iúbidiaꞌa; lëꞌë Dadë quëbezënúhiꞌ na; lëꞌë më quëhunë më shchiꞌni më. ");
INSERT INTO zacNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gulë tsaldí lduꞌu të de quë Dadë quëbezënúhiꞌ na nu na quëbezënúa lëꞌë më. Si talë adë rac tsaldídiꞌi lduꞌu të shtiꞌdza, gulë tsaldí lduꞌu të na por ra milagrë nabëna delantë lu të. ");
INSERT INTO zacNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Guldía rniaꞌa, el quë natsaldí lduꞌi shtiꞌdza, gúnëll mizmë dchiꞌni naquëhuna, nu hashtë más cusë nalasac gúnëll purquë guzëahia catë quëbezë Shtada. ");
INSERT INTO zacNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Grë́tëꞌ lo quë naguënaꞌbë të lu Shtada por nombre shtëna, gúnahin. Grë lo quë narnaꞌbë të por nombre shtëna, gúnahin të parë shini Dios guësëdchini labansë lu Dadë Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Na guna cualquier cusë parë lëꞌë të, grë lo quë naguënaꞌbë të por nombre shtëna. ");
INSERT INTO zacNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Si talë rac shtuꞌu të na, gulë bëzuꞌbë diaguë mandamientë shtëna. ");
INSERT INTO zacNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nu guna ruëguë lu Dadë Dios të guësheꞌldë më stubi natsaglaꞌguë guëneꞌe cunseju parë lëꞌë të nu cuezënúhiꞌ lëꞌë të parë siemprë. ");
INSERT INTO zacNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Náhiꞌ Espíritu Santo naruadiꞌdzë verdá. Ra mënë shtë guë́ꞌdchiliu, adë në́diꞌi gunë rall recibir lëꞌë më purquë adë rnádiꞌi rall lúhiꞌ nu adë runguë bë́ꞌadiꞌi rall lë́ꞌiꞌ; perë lëꞌë të runguë bëꞌa të lë́ꞌiꞌ purquë lë́ꞌiꞌ quëbezënúhiꞌ lëꞌë të. Quëhúniꞌ compañi lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Adë guësëáꞌnëdiaꞌa lëꞌë të ziquë bëzebi. Guëabría stubi parë guëquëreldënúa lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Stuꞌpë tiempë quëreldënúa lëꞌë të perë hia lëꞌë mënë shtë guë́ꞌdchiliu, adë guënádiꞌi rall lua. Lëꞌë të guëná të lua stubi. Lëꞌë të guëbani të purquë nabania. ");
INSERT INTO zacNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Dzë ni guëdëꞌë të cuendë de quë na con Shtada unidë na naꞌa, nu guëdëꞌë të cuendë de quë unidë na hiaꞌa, lëꞌë të con na. ");
INSERT INTO zacNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","El quë narac bëꞌa nu rzuꞌbë diáguëll mandamientë shtëna, mënë ni rac shtúꞌull na de verdá. Nu Shtada rac shtúꞌuiꞌ el quë narac shtuꞌu na, nu zac na rac shtuaꞌa lëꞌë narac shtuꞌu na. Nu guëluáꞌahia pudërë shtëna lúhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Iurní Judas, lëdë Iscariótëdiꞌi, guníꞌill lu Jesús: ―Dadë, ¿pëzielú rníꞌil guëluáꞌal pudërë shtë́nël lu naꞌa perë adë guëluáꞌadiꞌil pudërë shtë́nël lu mënë shtë guë́ꞌdchiliu? ");
INSERT INTO zacNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús guniꞌi: ―El quë narac shtuꞌu na de verdá, guëzuꞌbë diáguëll shtiꞌdza. Shtada gúniꞌ gac shtúꞌuiꞌ lëꞌë nguiu ni, nu Shtada con na guëdchini naꞌa; guëlezënú naꞌa lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Perë el quë adë rac shtúꞌudiꞌi na, tampuquë guëzuꞌbë diáguëll shtiꞌdza. Dizaꞌquë shtëna nabini të, lëdë shtë́nëdiaꞌain sino shtënë Dadë Dios, el quë nabësheꞌldë na lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Quëgniaꞌa lu të grë ndëꞌë mientras quëbezënúa lëꞌë të ");
INSERT INTO zacNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","perë lëꞌë Espíritu Santo, el quë naguëneꞌe cunseju parë lëꞌë të, Shtada guësheꞌldë lë́ꞌiꞌ; cuezënúhiꞌ shlugara nu guëluáꞌaiꞌ lëꞌë të grë́tëꞌ lo quë naguniaꞌa lu të. Guëníꞌiꞌ laꞌni lduꞌu të, të parë guëagná lduꞌu të enseñansë shtëna. ");
INSERT INTO zacNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Paz shtëna guësëana parë lëꞌë të, cuedchí lduꞌu të. Ra mënë shtë guë́ꞌdchiliu gúnëdiꞌi rall gan cuedchí lduꞌu të perë na sí, por na cuedchí lduꞌu të. Gulë cueꞌzë rquëdiꞌni lduꞌu të. Adë rdzë́bëdiꞌi lduꞌu të lo quë naguër gac. ");
INSERT INTO zacNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Hia bini të de quë guzëahia con Shtada perë guëabría stubi parë guëquëreldënúa lëꞌë të. Talë de verdá rac shtuꞌu të na, napë të lëgrë laꞌni lduꞌu të. Bëaꞌnë të tristë purquë guniaꞌa lu të: “Guzëahia lidchi Shtada”. Lëꞌë më napë më más pudërë quë na. ");
INSERT INTO zacNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Rniaꞌa lu të iurneꞌ të parë iurë lëꞌë ndëꞌë gac, iurní tsaldí lduꞌu të na. ");
INSERT INTO zacNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Hiadë guadiꞌdzënúdiꞌiruaꞌa lëꞌë të purquë hia mërë guëdchini el quë narnibëꞌa mënë shtë guë́ꞌdchiliu. Lë́ꞌëll nápëdiꞌill ni tubi pudërë parë na. ");
INSERT INTO zacNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Napë quë gac zni të parë ra mënë shtë guë́ꞌdchiliu, gac bëꞌa rall de quë lëꞌë më bësheꞌldë më na. Gac bëꞌa rall lo quë naruna, gunibëꞌa më gúnahin. ’Gulë tsasuldí. Cha guëruꞌu hiaꞌa de ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesús guniꞌi: ―Nahia ziquë hiaguë nashi naná verdadërë. Shtada quëhapë më hiaguë ni. ");
INSERT INTO zacNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Rchúguiꞌ grë llicu hiaguë nardë́ꞌëdiꞌi nashi, nu grë llicu hiaguë nanuaꞌa nashi, rquiꞌni guëldin nu sunëhin të parë guëneꞌe másruꞌu nashi. ");
INSERT INTO zacNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lëꞌë të na të ziquë llicu hiaguë nanápëdiꞌi ndiaguë bidchi. Guquin por shtiꞌdza naguniaꞌa lu të. ");
INSERT INTO zacNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Gulë gac unidë con na. Gulë tsaglaꞌguë tsaldí lduꞌu të na, iurní quëbezënúa lëꞌë të. Tubi llicu hiaguë adë gáquëdiꞌi guëdëꞌëin nashi si talë adë quë́diꞌin culaꞌni trunquë shtë hiaguë. Mizmë manërë ni na të. Lëꞌë të gáquëdiꞌi guëdëꞌë të nashi si talë nádiꞌi të unidë con na. ");
INSERT INTO zacNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Na nahia ziquë trunquë shtë hiaguë; na të ziquë llicu hiaguë. El quë naná unidë con na nu quëbezënúa lë́ꞌiꞌ, ni el quë naguëneꞌe zihani nashi. Pues adë gáquëdiꞌi gapë të nashi lë́ꞌësë të. Con na sí, gac të ziquë tubi hiaguë narneꞌe nashi. ");
INSERT INTO zacNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","El quë nádiꞌi unidë con na, ni guëzebi të parë guëbidchi ziquë llicu hiaguë të guëdëahin parë tsequin lu guiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Si talë tsaglaꞌguë të, gac të unidë con na, nu adë guëáꞌldëdiꞌi lduꞌu të grë́tëꞌ nabëluáꞌahia lu të. Gulë gunaꞌbë grë lo quë narac shtuꞌu të, grë́tëꞌ guënehia caꞌa të. ");
INSERT INTO zacNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Lëꞌë Shtada gunë recibir hunurë iurë lëꞌë të rdëꞌë të zihani nashi. Zni gac të de verdá shmëna. ");
INSERT INTO zacNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Na rac shtuaꞌa lëꞌë të ziquë rac shtuꞌu Shtada na. Gulë tsaglaꞌguë gac shtuꞌu të na. ");
INSERT INTO zacNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Si talë guëzuꞌbë diaguë të grë mandamientë shtëna, zni guëná mënë de quë rac shtuꞌu të na de verdá. Mizmë mudë ni rzuꞌbë diaga grë mandamientë shtë Shtada nu tsaglaꞌguë rac shtuaꞌa Shtada. ");
INSERT INTO zacNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Na ruadiꞌdza zndëꞌë të parë guëquitë lduꞌu të con na nu tsu lëgrë lduꞌu të siemprë. ");
INSERT INTO zacNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ndëꞌë na mandamientë shtëna de quë gac shtuꞌu të saꞌ të ziquë na rac shtuaꞌa lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","El quë narac shtuꞌu amigu shtë́nëll de verdá, rdë́ꞌëll vidë shtë́nëll shlugar amigu ni. Nídiꞌi más llëruꞌbë amor quë ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lëꞌë të na të amigu shtëna si talë gunë të cumplir grë́tëꞌ lo quë narnibë́ꞌahia. ");
INSERT INTO zacNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Adë rníꞌidiaꞌa na të muzë shtëna purquë ra muzë adë guënë́diꞌi rall pë runë shlamë rall; más bien rniaꞌa lu të na të amigu shtëna. Grë́tëꞌ nabëluáꞌahia lu të, nanë́ të iurneꞌ. Grë́tëꞌ lo quë naguniꞌi Shtada lua, ni na lo quë nabëluáꞌahia lu të. ");
INSERT INTO zacNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Adë gudílidiꞌi të na sino na gudilia lëꞌë të parë gac të shmëna, nu na bëna incarguë lu të de quë gac të ziquë tubi hiaguë narneꞌe zihani nashi zaꞌquë nu nashi ni adë tsalúdiꞌin. Grë́tëꞌ lo quë narnaꞌbë të lu Shtada por lëa, guëneꞌe mëhin si talë tsaldí lduꞌu të shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Zndë rniaꞌa lu të nu rnibë́ꞌahia lëꞌë të de quë gac shtuꞌu të bëchi saꞌ të. ");
INSERT INTO zacNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Si talë ra mënë shtë guë́ꞌdchiliu, adë guëná záꞌquëdiꞌi rall lu të, gulë bëdëꞌë cuendë guëlú adë guná záꞌquëdiꞌi rall lua. ");
INSERT INTO zacNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Si talë na të mënë shtë guë́ꞌdchiliu, iurní sí, ra mënë niac shtuꞌu rall lëꞌë të cumë rac shtuꞌu rall saꞌ rall. Na gudilia lëꞌë të ladi ra mënë shtë guë́ꞌdchiliu, por ni ra mënë adë rna záꞌquëdiꞌi rall lu të purquë hiadë nádiꞌi të mënë shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gulë bësëagná lduꞌu të lo quë naguniaꞌa lu të: “Ni tubi muzë lasáquëdiꞌi más quë shlámiꞌ”. Si talë guzunaldë mënë na, nu zac lëꞌë të sunaldë rall. Ra mënë nagualdí lduꞌu grë́tëꞌ lo quë nabëluáꞌahia lëꞌë rall; nu zac tsaldí lduꞌu rall naguëluaꞌa të lëꞌë rall, zac gunë rall recibir shtiꞌdzë të. ");
INSERT INTO zacNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Zndëꞌë gunë rall. Guëná záꞌquëdiꞌi rall lu të purquë na të shmëna. Adë runguë bë́ꞌadiꞌi rall el quë nabësheꞌldë na. ");
INSERT INTO zacNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Lëꞌë rall ni tubi faltë nápëdiꞌi rall si talë adë néldëdiaꞌa lu guë́ꞌdchiliu nu si talë adë niuadíꞌdzëdiaꞌa lu rall, perë iurneꞌ naculpablë rall lu Dios purquë guná rall lua nu bini rall shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","El quë narná záꞌquëdiꞌi lua, nu lu Shtada rna záꞌquëdiꞌi mënë. ");
INSERT INTO zacNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ni tubi faltë niápëdiꞌi rall si talë adë nihúnëdiaꞌa cusë ruꞌbë lu rall. Ni tubi mënë adë bë́ꞌnëdiꞌill cumë ziquë bëluáꞌahia lu rall, perë hia lëꞌë rall guná rall grë́tëꞌ ra cusë rëꞌ perë siemprë rna záꞌquëdiꞌi rall lua nu rna záꞌquëdiꞌi rall lu Shtada. ");
INSERT INTO zacNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Zndëꞌë guc parë gac cumplir ra diꞌdzë nanaquë́ laꞌni lëy nabëꞌnë rall recibir. Rniꞌin: “Guná záꞌquëdiꞌi rall lua sin pë lu nezë”. ");
INSERT INTO zacNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Perë iurë guëdchini el quë nagunë consolar lëꞌë të, guëníꞌiꞌ favurë de na. Guësheꞌlda lë́ꞌiꞌ parë cuezënúhiꞌ lëꞌë të. Guëdchíniꞌ por partë shtë Shtada nu guëníꞌiꞌ lu të purë verdá purquë nádiꞌiꞌ bishi. ");
INSERT INTO zacNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nu lë́ꞌëgaꞌa të también guadiꞌdzë të favurë de na lu ra mënë; gac të testigu shtëna purquë gulezënú të na dizdë guzublúa shchiꞌnia. ");
INSERT INTO zacNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Rniaꞌa lu të grë ra cusë rëꞌ parë gac preparadë të, të adë guëazë guétëdiꞌi të iurë guëdchini cusë mal. ");
INSERT INTO zacNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Guëgú ra mënë lëꞌë të iáduꞌu nu guëdchini iurë quini mënë lëꞌë të. Guëniꞌi rall de quë ni na voluntá shtë Dios iurë quini rall lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Zndëꞌë gac purquë nunquë adë runguë bë́ꞌadiꞌi ra mënë shtë guë́ꞌdchiliu Dadë Dios nu runguë bë́ꞌadiꞌi rall na. ");
INSERT INTO zacNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Zndëꞌë rniaꞌa lu të, të iurë guëgaꞌa iurë, iurní guëagná lduꞌu të hia grë́tëꞌ ndëꞌë guniaꞌa lu të. ’Adë guníꞌidiaꞌa lu të ra cusë rëꞌ dizdë guzublú shchiꞌnia purquë na quëbezënúa lëꞌë të iurní, ");
INSERT INTO zacNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","perë iurneꞌ guzëahia parë cuezënúhia më el quë nabësheꞌldë na. Perë ni tubi de lëꞌë të adë gunaꞌbë díꞌdzëdiꞌi të lua: “¿Pëzielú tsal?” ");
INSERT INTO zacNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Bini të de quë guzëahia, por ni bëaꞌnë të tristë ");
INSERT INTO zacNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","perë rniaꞌa lu të verdá, mejurë nahin parë lëꞌë të. Guzëahia purquë si talë adë tsádiaꞌa, adë guídëdiꞌi më naguëneꞌe cunseju parë lëꞌë të, perë si talë guzëahia, guësheꞌlda lë́ꞌiꞌ; cuezënúhiꞌ lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Iurë lëꞌë më guëdchini, guëníꞌiꞌ lu ra mënë të gac bëꞌa rall blac duldë quëhunë rall. Guëluáꞌaiꞌ tubi nezë ldi shtë Dios, nu guëníꞌiꞌ de quë gunë Dios juzguë ra mënë shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Napë rall duldë purquë adë gualdídiꞌi lduꞌu rall na. ");
INSERT INTO zacNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tsasë́ rall pë runë cuntienë nezë ldi shtë Dios purquë na guzëahia catë quëbezë më. Hia lëꞌë të adë guënádiꞌi të lua. ");
INSERT INTO zacNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tsasë́ rall de quë nanú juici shtë Dios purquë hia nacondenadë lëꞌë narnibëꞌa lëꞌë ra mënë shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Nápëruaꞌa más lo quë narac shtuaꞌa guëniaꞌa lu të perë lëꞌë të adë gáquëdiꞌi tsasë́ të iurneꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Perë iurë lëꞌë Espíritu Santo guëdchíniꞌ, lëꞌë më guëluaꞌa më lëꞌë të grë́tëꞌ verdá purquë nídiꞌi bishi laꞌni ldúꞌiꞌ. Adë guëníꞌidiꞌiꞌ por partë shcuéndiꞌ; más bien guëníꞌiꞌ lu të lo quë nabíniꞌ de Shtada. Gac bëꞌa të lo quë naguër gac por pudërë shtë Espíritu Santo. ");
INSERT INTO zacNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Lëꞌë Espíritu Santo guëluáꞌaiꞌ nahia më ruꞌbë. Guëluáꞌaiꞌ shtiꞌdza parë gac bëꞌa të, parë guëdëꞌë të cuendë pë runë cuntienë shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Grë́tëꞌ lo quë nanapë Shtada, shtëna; por ni guniaꞌa lu të lëꞌë Espíritu Santo gúniꞌ recibir lo quë naná shtëna nu guëluáꞌaiꞌ lëꞌë të parë tsalú guëdëꞌë të cuendë shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Stuꞌpsë runë faltë, hia guënádiꞌi të lua perë por dupëꞌnë másruꞌu tsadzé iurní sí, guëná të lua purquë hia guzëahia catë quëbezë Shtada. ");
INSERT INTO zacNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Iurní bëldá ra shini gusëꞌdë më gunaꞌbë diꞌdzë raiꞌ lu saꞌ rall: ―¿Pë runë cuntienë ra diꞌdzë rëꞌ: “Stuꞌpsë runë faltë hia guënádiꞌi të lua perë por dupëꞌnë másruꞌu sí, guëná të lua”? ¿Pëzielú rníꞌiꞌ: “Purquë guzëahia catë quëbezë Shtada”? ");
INSERT INTO zacNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Guaglaꞌguë guniꞌi rall: ―¿Pë runë cuntienë stuꞌpsë nu despuë́sëgaꞌa stuꞌpsë? Adë chu riasë́diꞌi pë quëadiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús guc bëꞌa de quë rac shtuꞌu raiꞌ guënaꞌbë diꞌdzë raiꞌ. Iurní guniꞌi më: ―Quëgnaꞌbë diꞌdzë të lu saꞌ të shcuendë lo quë naguniaꞌa lu të: “Runë faltë stuꞌpsë; hiadë guënádiꞌi të lua perë despuësë másruꞌu tsadzé, guëabrí të guëná të lua”. Ni rac shtuꞌu guënaꞌbë diꞌdzë të lu saꞌ të. ");
INSERT INTO zacNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Guldía rniaꞌa, lëꞌë të guꞌnë të nu ldaguë tristë laꞌni lduꞌu të perë ra mënë shtë guë́ꞌdchiliu, guëquitë lduꞌu rall purquë rnádiꞌi rall lua. Aunquë lëꞌë të guëaꞌnë të con galriá lduꞌu, despuësë guëquitë lduꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Cumë tubi naꞌa iurë lëꞌë naꞌa bëgaꞌa shiurë galë shini naꞌa, rdzëbë naꞌa nu rbini lduꞌu naꞌa por dulurë, perë despuësë lëꞌë meꞌdë bëdchini guë́ꞌdchiliu, hia adë rëagná lduꞌu naꞌa dulurë. Iurní guëquitë lduꞌu naꞌa purquë gulë tubi meꞌdë lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Zni zac lëꞌë të; rbini lduꞌu të iurneꞌ, perë na napë quë guëabría. Guënahia lu të stubi; iurní nalë́ guëquitë lduꞌu të, tubi cusë lëgrë; adë chu guëdchisúdiꞌin de lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Dzë ni hiadë guënáꞌbëdiꞌi diꞌdzë të lua ni tubi cusë. Guldía rniaꞌa, lëꞌë Dadë Dios guëneꞌe grë́tëꞌ lo quë naguënaꞌbë të lúhiꞌ. Guëneꞌe mëhin si talë guënaꞌbë të por na. ");
INSERT INTO zacNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hashtë iurneꞌ adë gunáꞌbëdiꞌi të lu Dadë por na. Rniaꞌa lu të, gulë gunaꞌbë lu më. Guëneꞌe më lo quë narunë faltë të parë guëquitë lduꞌu të de verdá. ");
INSERT INTO zacNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Hia guniaꞌa lu të grë ra cusë rëꞌ por comparaciuni, perë guëdchini iurë hiadë guadíꞌdzëdiaꞌa por comparaciuni sino quë iurní guadiꞌdza clarë shcuendë Dadë. ");
INSERT INTO zacNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Dzë ni lëꞌë të guënaꞌbë të lu Shtada por lëa purquë iurní rquíꞌnidiꞌi guënaꞌba lu më por lëꞌë të ");
INSERT INTO zacNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","purquë lëꞌë Shtádaꞌa rac shtúꞌuiꞌ lëꞌë të. Rac shtuꞌu më lëꞌë të purquë rac shtuꞌu të na nu rialdí lduꞌu të de quë beldë guëdchinia de Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Bëruaꞌa catë quëbezë Shtada nu bëdchinia lu guë́ꞌdchiliu, perë iurneꞌ guësaꞌna lëꞌë guë́ꞌdchiliu parë guëabría con lëꞌë Shtada. ");
INSERT INTO zacNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Iurní ra shini gusëꞌdë më guniꞌi: ―Iurneꞌ sí, quëadíꞌdzël clarë sin adë quëhunë dchíꞌnidiꞌil comparaciuni. ");
INSERT INTO zacNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Iurneꞌ rialdí lduꞌu naꞌa lë́ꞌël nu nanë́ naꞌa riasël grë cusë. Rquíꞌnidiꞌil chu guënaꞌbë diꞌdzë lul. Rialdí lduꞌu naꞌa de quë bëdchínil por partë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús repi: ―¿Gu gualdí lduꞌu të iurneꞌ? ");
INSERT INTO zacNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Guná, guëdchini iurë nu mizmë iurneꞌ, lëꞌë të guërëꞌtsë të cadë lëꞌë të tubi ladë. Iurní guësaꞌnë të na tubsia, perë adë zúdiaꞌa tubsia purquë lëꞌë Shtada quëbezënúhiꞌ na. ");
INSERT INTO zacNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Rniaꞌa lu të grë́tëꞌ ndëꞌë të parë cuedchí lduꞌu të por na. Ra mënë shtë guë́ꞌdchiliu guëzac zi rall lëꞌë të perë gulë bëquitë lduꞌu të. Bëna gan lu narnibëꞌa mënë shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Despuësë gualú biadiꞌdzë më grë ra cusë rëꞌ, gubiꞌa më lu gubeꞌe nu guniꞌi më: ―Dadë, hia lëꞌë iurë bëgaꞌa. Bëluaꞌa ra mënë de quë shínil náhiꞌ personë ruꞌbë delantë lul. Iurní shínil guëquébiꞌ nal personë ruꞌbë delantë lu rall. ");
INSERT INTO zacNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Bënéꞌel pudërë guiahia parë guënibë́ꞌahia grë́tëꞌ ra mënë narëtaꞌ lu guë́ꞌdchiliu, nu iurneꞌ napa derechë guëdëꞌa vidë sin fin parë mënë nabënéꞌel parë na. ");
INSERT INTO zacNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Parë gapë ra mënë vidë sin fin, napë quë gunguë bëꞌa rall lë́ꞌël nu napë quë gunguë bëꞌa rall na. Nahia shínil nabëshéꞌldël lu guë́ꞌdchiliu. Sulë lë́ꞌël nal Dios verdadërë. ");
INSERT INTO zacNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Siemprë bëluáꞌahia lu ra mënë llëruꞌbë na pudërë shtë́nël. Bëna gan grë́tëꞌ dchiꞌni nabënéꞌel guna. ");
INSERT INTO zacNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Bëꞌnë honrar na culáꞌnil ziquë antsë lëꞌë guë́ꞌdchiliu cueshtë́, quëbezënúa lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Grë ra mënë nagulël ladi ra mënë shtë guë́ꞌdchiliu, bënéꞌel lëꞌë rall parë na; na rall shmëna. Bëluáꞌahia lu raiꞌ pudërë shtë́nël nu bëzuꞌbë diaguë raiꞌ dizaꞌquë shtë́nël. ");
INSERT INTO zacNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Iurneꞌ rdëꞌë rall cuendë de quë pudërë nanapa, bënéꞌel guiahia. ");
INSERT INTO zacNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Grë ra diꞌdzë naguníꞌil lua, biadiꞌdza lu raiꞌ nu bëꞌnë raiꞌ recibir ra diꞌdzë ni. Hia gualdí lduꞌu raiꞌ de verdá de quë bëshéꞌldël na lu guë́ꞌdchiliu. Nanë́ raiꞌ zelda por ordë shtë́nël. ");
INSERT INTO zacNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Na runa ruëguë por lëꞌë raiꞌ iurneꞌ. Adë rúnëdiaꞌa ruëguë por ra mënë shtë guë́ꞌdchiliu sino por ra mënë nabënéꞌel parë na purquë shtë́nël lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Grë ra mënë ni nashtë́nël nu na raiꞌ shtëna. Por lëꞌë raiꞌ zihani mënë guná rall pudërë shtëna. ");
INSERT INTO zacNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Na adë guëáꞌnëdiaꞌa lu guë́ꞌdchiliu, perë lëꞌë raiꞌ sí, guëaꞌnë raiꞌ lu guë́ꞌdchiliu. Hia lëꞌë na gueldë guëzë́a catë quëréldël. Santo nal, nia Dadë. Gupë lëꞌë raiꞌ con pudërë shtë́nël grë ra nabënéꞌel parë na parë gac raiꞌ unidë ziquë lë́ꞌël nu na unidë na hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Iurë quëbezënúa lëꞌë nabënéꞌel parë na, gupa lëꞌë raiꞌ. Ni tubi adë chu bënítidiꞌi sino el quë nagulë parë gac condenádëll. Zni guquin parë gac cumplir naná escritë laꞌni Sagradas Escrituras de lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Iurneꞌ Dadë, mërë gueldë guëzë́a catë quëbézël perë mientras zugáꞌahia stúpëꞌnë lu guë́ꞌdchiliu, rniaꞌa lul grë ra cusë rëꞌ, guini naná guëquë́ diaguë diꞌdzë rëꞌ. Guëquitë lduꞌu raiꞌ; mizmë lëgrë nanapa gapë raiꞌ guëdubi tiempë. ");
INSERT INTO zacNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na bëluáꞌahia dizaꞌquë shtë́nël lu raiꞌ perë ra mënë shtë guë́ꞌdchiliu, adë rna záꞌquëdiꞌi rall lu raiꞌ. Grë raiꞌ nabëquë́ diaguë shtíꞌdzël, adë na raiꞌ ziquë mënë shtë guë́ꞌdchiliu; igual ziquë na, adë rianáldëdiꞌi raiꞌ tëchi ra cusë shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Adë rnáꞌbëdiaꞌa, Dadë, de quë guëgul lëꞌë raiꞌ lu guë́ꞌdchiliu, sino rac shtuaꞌa gápël lëꞌë raiꞌ lu ra cusë shtë mëdzabë. ");
INSERT INTO zacNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Cumë ziquë na, adë nádiaꞌa mënë shtë guë́ꞌdchiliu, nu lëꞌë raiꞌ adë nádiꞌi raiꞌ mënë shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Por shtíꞌdzël bëꞌnë gac raiꞌ santu parë lë́ꞌël. Grë dizaꞌquë shtë́nël na verdá. ");
INSERT INTO zacNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Cumë ziquë bëshéꞌldël na lu ra mënë shtë guë́ꞌdchiliu, zni zac bësheꞌlda lëꞌë raiꞌ lu ra mënë shtë guë́ꞌdchiliu. Guëniꞌinú raiꞌ shtíꞌdzël lu rall. ");
INSERT INTO zacNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Quëhuna apartar mizmë na parë bien shtë raiꞌ të gac raiꞌ completamente entregadë lu voluntá shtë́nël. Gac cumplir ndëꞌë, Dadë, por shtíꞌdzël naná verdá. ");
INSERT INTO zacNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Perë adë rnáꞌbëdiaꞌa sulamëntë por lëꞌë raiꞌ, sino también por grë́tëꞌ natsaldí lduꞌi shtiꞌdza iurë guadiꞌdzë raiꞌ dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Grë́tëꞌ ra mënë ni natsaldí lduꞌi shtiꞌdza, quëhuna ruëguë gac raiꞌ unidë, Dadë. Gapë raiꞌ tubsë llgabë ziquë na hiaꞌa unidë nu nadápaꞌa mizmë llgabë. Bëꞌnë compañi lëꞌë raiꞌ parë gac raiꞌ unidë con lëꞌë hiaꞌa, Dadë, parë ra mënë shtë guë́ꞌdchiliu, gac bëꞌa rall lë́ꞌël bëshéꞌldël na. ");
INSERT INTO zacNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Lëꞌë derechë nu pudërë nabënéꞌel parë na, bëdë́ꞌëhia parë lëꞌë raiꞌ parë gac raiꞌ unidë ziquë lëꞌë hiaꞌa na hiaꞌa unidë. ");
INSERT INTO zacNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ziquë quëbezënúa lëꞌë raiꞌ nu quëbezënul na, zni rac shtuaꞌa gac rall unidë completamente con lëꞌë hiaꞌa parë ra mënë shtë guë́ꞌdchiliu, guëdëꞌë rall cuendë lë́ꞌël bëshéꞌldël na nu guëdëꞌë rall cuendë de quë rac shtúꞌul lëꞌë rall mizmë manërë ziquë rac shtúꞌul na. ");
INSERT INTO zacNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Dadë lë́ꞌël bënéꞌel grë́tëꞌ ndëꞌë, nu rac shtuaꞌa de quë catë quëbézël nu zac lëꞌë raiꞌ cuezë raiꞌ. Rac shtuaꞌa catë nezë guëquërelda nu lëꞌë raiꞌ guëquëreldë raiꞌ të parë guëná raiꞌ lugar zaꞌquë lu gubeꞌe. Guëná raiꞌ pudërë nabënéꞌel purquë nalë́ rac shtúꞌul na antsë lëꞌë guë́ꞌdchiliu cueshtë́. ");
INSERT INTO zacNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Dadë, lë́ꞌël rúnël bien guëdubi tiempë perë ra mënë shtë guë́ꞌdchiliu, adë runguë bë́ꞌadiꞌi rall lë́ꞌël, perë na sí, runguë bë́ꞌahia lë́ꞌël nu lëꞌë ra nagualdí lduꞌi lë́ꞌël, rdëꞌë raiꞌ cuendë de quë lë́ꞌël bëshéꞌldël na. ");
INSERT INTO zacNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Bëluáꞌahia lëꞌë raiꞌ parë gunguë bëꞌa raiꞌ chu nal, nu todavía tsaglaꞌguë guëluáꞌaruꞌuhia lëꞌë raiꞌ parë gac shtuꞌu raiꞌ saꞌ raiꞌ ziquë rac shtúꞌul na; mizmë amor shtëna gapë raiꞌ laꞌni lduꞌu raiꞌ parë saꞌ raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Despuësë de gualú biadiꞌdzë Jesús ra diꞌdzë rëꞌ, bëruꞌu më con ra shini gusëꞌdë më parë ziaꞌa raiꞌ stubi ladë ruaꞌ tubi rugi guëëꞌgu nalë Cedrón. Ngaꞌli naquë́ tubi lahuertë, nu guatënú Jesús ra shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nu Judas, lëꞌë naná rac shtuꞌu gúnëll intriegu Jesús, nanëll lugar ni purquë zihani vësë guanú Jesús lëꞌë raiꞌ ndë. Nu ngaꞌli rdëá raiꞌ antsë. ");
INSERT INTO zacNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Zni bëꞌnë Judas; bëdchínill con tubi shcuaꞌa mënë con bëldá guëshiágduꞌu. Ra jëfë shtë ra bëshuzi con ra fariseo bësheꞌldë rall lëꞌë mënë ni. Nuaꞌa rall lintërnë nu grëaguë parë guëzianí. Nuaꞌa rall spadë. ");
INSERT INTO zacNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Hia rac bëꞌa Jesús grë́tëꞌ lo quë nanagac; iurní bëruꞌu më ladi ra shmënë më nu guniꞌi më lu ra mënë: ―¿Chu rguili të? ");
INSERT INTO zacNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Lëꞌë rall bëquebi: ―Rguili naꞌa Jesús de Nazaret. Jesús guniꞌi iurní: ―Na ndëꞌë. Lëꞌë Judas nabëꞌnë intriegu Jesús, zugáꞌall con ra mënë ni. ");
INSERT INTO zacNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iurë lëꞌë Jesús guniꞌi: “Na ndëꞌë”, iurní bëazë guetë rall nu gulaguë rall lu guiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iurní guniꞌi më stubi: ―¿Chull rguili të? Lëꞌë rall guniꞌi rall: ―Jesús de Nazaret. ");
INSERT INTO zacNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús repi lu rall iurní: ―Hia guniaꞌa lu të de quë na ndëꞌë. Si talë rguili të na, gulë bëneꞌe sí, të parë guzëá ra shmëna. ");
INSERT INTO zacNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Zni guc parë gac cumplir diꞌdzë naguniꞌi Jesús antsë: “Grë́tëꞌ el quë nabënéꞌel parë na, ni tubi adë gunítidiaꞌa”. ");
INSERT INTO zacNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Iurní lëꞌë Simón Pedro nápiꞌ tubi spadë; gulúhiꞌ spadë nu bëchúguiꞌ diaguë ladë ldi tubi naná lë Malco. Malco na muzë shtë jëfë shtë ra bëshuzi. ");
INSERT INTO zacNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Perë Jesús repi lu Pedro: ―Bëguëuꞌ spadë shtë́nël shlugarin. Si talë según voluntá shtë Shtada zeꞌdë parë sac zia, napë quë guna cumplirin. ");
INSERT INTO zacNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Iurní lëꞌë ra mënë con comandante shtë ra soliar nabësheꞌldë contrari shtë Jesús, gunaꞌzi rall lëꞌë më parë guaꞌa rall lëꞌë më prësi. Bëldiꞌbi rall guiaꞌa më. ");
INSERT INTO zacNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Lueguë biaꞌa rall lëꞌë më lu Anás naná suëgrë Caifás. Izë ni Caifás guc bëshuzi namás narnibëꞌa. ");
INSERT INTO zacNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás rëꞌ mizmë naguniꞌi lu ra më israelitë: “Más mejurë parë lëꞌë hiaꞌa gati tubsë nguiu quë guëdubi naciuni tsalú”. ");
INSERT INTO zacNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro con stubi ra poshtë, guanaldë raiꞌ lëꞌë Jesús. Lëꞌë stubi poshtë ni na el quë nanë́ Caifás naná bëshuzi namás narnibëꞌa. Guatënú poshtë ni Jesús rualdëaꞌ lidchi Anás. ");
INSERT INTO zacNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro bëaꞌnë fuërë ruaꞌ puertë shtë nezë. Iurní bëruꞌu lëꞌë poshtë nananë́ lëꞌë jëfë shtë ra bëshuzi. Lëꞌë poshtë ni guchi lu naꞌa narapë ruaꞌ puertë parë tsutë́ Pedro. ");
INSERT INTO zacNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Iurní lëꞌë naꞌa gunaꞌbë díꞌdzëll lu Pedro: ―¿Pë nu lë́ꞌël nal shmënë nguiu rëꞌ? Pedro bëquebi: ―Aquëdiꞌi, nádiaꞌa shmënë nguiu ni. ");
INSERT INTO zacNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Cumë nalë́ naldë dzë ni, ra muzë con ra soliar bëntsaꞌu tubi guërdë́ të parë bëcueꞌe rall guiꞌi të guëdzëꞌë rall. Nu zac Pedro zugaꞌa con lëꞌë rall. Quëtsëꞌë Pedro ruaꞌ guiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Lëꞌë Anás, tubi jëfë shtë ra bëshuzi, guzublú gunaꞌbë díꞌdzëll lu Jesús shcuendë ra shini gusëꞌdë më nu pë ldaiꞌ rluaꞌa më. ");
INSERT INTO zacNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Repi Jesús: ―Na biadiꞌdza delantë lu grë mënë. Bëluáꞌahia laꞌni ra iáduꞌu nu hashtë iáduꞌu ruꞌbë, grë́tëꞌ lugar catë rdëá ra mënë israelitë. Ni tubi cusë adë guníꞌidiaꞌa nagaꞌchi. ");
INSERT INTO zacNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Pëzielú rnaꞌbë díꞌdzël lua pë cusë bëluáꞌahia? Gulë gunaꞌbë diꞌdzë lu ra mënë nabini shtiꞌdza. Nanë́ rall ldaiꞌ lo quë bëluáꞌahia. ");
INSERT INTO zacNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iurë lëꞌë Jesús guniꞌi zndëꞌë, tubi soliar shtë iáduꞌu nazugaꞌa guëlladchi, gulubëll lu më nu guníꞌill: ―¿Pë zniꞌi rquébil lu jëfë shtë ra bëshuzi? ");
INSERT INTO zacNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús repi: ―Si talë guniaꞌa mal, bëluaꞌa nia pë mal bëna perë si talë guniaꞌa verdá ¿pëzielú gulubël lua? ");
INSERT INTO zacNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Iurní lëꞌë Anás bësheꞌldë lëꞌë më lu Caifás. Liꞌbi guiaꞌa më. Caifás na bëshuzi narnibëꞌa más entrë grë ra bëshuzi. ");
INSERT INTO zacNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Perë Pedro tsaglaꞌguë quëgtsë́ꞌëiꞌ ruaꞌ guiꞌi con ra mënë. Iurní guchi ra mënë: ―¿Pë nul lë́ꞌël nal shmënë Jesús? Pedro bëꞌnë negar; guníꞌiꞌ: ―Aquëdiꞌi, nádiaꞌa shmënë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Iurní gunaꞌbë diꞌdzë tubi muzë shtë Caifás, muzë ni nall shfamili shtë nguiu nabëchuguë Pedro diáguiꞌ. Guniꞌi muzë ni lu Pedro: ―¿Pë nul lë́ꞌël gunahia laꞌni lahuertë con Jesús? ");
INSERT INTO zacNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro bëꞌnë negar stubi. Mizmë iurní bëllidchí tubi gay. ");
INSERT INTO zacNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Iurní biaꞌa rall Jesús lu palaci catë gunë gubernadurë juzguë. Hia zeꞌdë grëgueꞌlë iurní. Ra contrari shtë Jesús adë guatë́diꞌi rall laꞌni palaci parë guëaꞌnë rall limpi según custumbrë religiusë shtë rall. Zni nanú permisi gau rall shtse shtë Pascu. ");
INSERT INTO zacNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Por ni Pilato bëruꞌu parë guagníꞌill lu rall: ―¿Pë mal bëꞌnë hiumbrë rëꞌ? ");
INSERT INTO zacNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Guniꞌi rall: ―Si talë nádiꞌill hiumbrë mal, adë chu guëdë́ꞌnëdiꞌi intriegu lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Iurní Pilato repi: ―Gulë biaꞌa lë́ꞌëll mizmë lëꞌë të nu gulë bëꞌnë juzguë lë́ꞌëll según narniꞌi lëy shtë të. Ra contrari shtë Jesús bëquebi: ―Perë lëꞌë naꞌa nápëdiꞌi naꞌa derechë parë guëdini naꞌa ni tubi mënë gátill. ");
INSERT INTO zacNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Zni guc parë gac cumplir shtiꞌdzë Jesús naguniꞌi más antsë parë gac bëꞌa rall lla mudë gati më. ");
INSERT INTO zacNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Iurní Pilato bëabrí guatë́ laꞌni palaci; iurní gunáꞌbëll lëꞌë Jesús nu guniꞌi Pilato: ―¿Pë lë́ꞌël nal Rëy shtë ra më israelitë? ");
INSERT INTO zacNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús repi: ―¿Pë ni rnaꞌbë díꞌdzël por shcuéndël u nu chu stubi guniꞌi lul chu nahia? ");
INSERT INTO zacNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato guniꞌi: ―Nádiaꞌa më israelitë. Mizmë mënë saꞌl con ra jëfë shtë ra bëshuzi, bëꞌnë rall intriegu lë́ꞌël lua ziquë tubi më mal. Guniꞌi lua pë mal bë́ꞌnël. ");
INSERT INTO zacNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Guniꞌi më: ―Nahia Rëy shtë gubiernë nanádiꞌi ziquë gubiernë shtë guë́ꞌdchiliu. Si talë gubiernë shtëna niac ziquë gubiernë shtë guë́ꞌdchiliu, pues niadildi shmëna parë gáquëdiꞌi intriegu na guiaꞌa ra më israelitë. Perë iurneꞌ rniaꞌa lul de quë rnibë́ꞌahia; nahia Rëy perë lë́dëdiꞌi rëy shtë guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Iurní Pilato repi: ―Rníꞌil de quë nal tubi Rëy. Jesús guniꞌi: ―Nahia Rëy ziquë quëgníꞌil, parë ni gula lu guë́ꞌdchiliu. Zelda lu guë́ꞌdchiliu parë guadiꞌdza verdá. Grë́tëꞌ el quë narac shtuꞌu guini verdá, ni rdëꞌë rall cuendë shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato repi: ―¿Pë runë cuntienë diꞌdzë, verdá? Despuësë de gualú gunaꞌbë diꞌdzë Pilato diꞌdzë rëꞌ, bërúꞌull stubi parë guadiꞌdzënull ra contrari shtë Jesús. Guniꞌi Pilato: ―Ni tubi delitë adë rdzélëdiaꞌa shtë nguiu rëꞌ ");
INSERT INTO zacNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","perë ziquë tubi custumbrë, guëdëꞌa libertá tubi prësi laꞌni dzë laní shtë Pascu. ¿Sëldahia Jesús rëy shtë të, u pë rniꞌi të? ");
INSERT INTO zacNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Iurní grë ra mënë gurushtiá rall: ―Adë rldáꞌadiꞌil Jesús; bëdëꞌë libertá parë Barrabás. Barrabás na tubi ngubaꞌnë, tubi më dushë. ");
INSERT INTO zacNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Iurní lëꞌë Pilato gunibëꞌa guanú Jesús galnë́ con chicuti. ");
INSERT INTO zacNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ra suldadë bëntsaꞌu rall tubi corunë guitsë nu gulú rallin guëc Jesús nu bëgacu rall lëꞌë më tubi lari color guindë. ");
INSERT INTO zacNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Lueguë guabiꞌguë rall lu më; bëꞌnë rall burnë. Guniꞌi rall: ―Guëbani Rëy shtë ra më israelitë. Gulubë́ rall lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Iurní Pilato bëabrill; bërúꞌull nu répill lu ra mënë: ―Gulë guná, rguhia nguiu rëꞌ delantë lu të parë guëdëꞌë të cuendë de quë adë rdzélëdiaꞌa ni tubi delitë parë lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Iurní bëruꞌu Jesús con corunë guitsë zubë guëc më nu nacu më tubi lari color guindë. Iurní Pilato repi: ―Lëꞌë nguiu ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Iurë ra jëfë shtë ra bëshuzi con ra soliar shtë iáduꞌu, guná rall lëꞌë më, guzublú gurushtiá; guniꞌi rall: ―Quëll lu cruz. Quëll lu cruz. Pilato guniꞌi: ―Gulë biaꞌa lë́ꞌëll nu gulë bëquëꞌë lë́ꞌëll lu cruz purquë adë rdzélëdiaꞌa ni tubi delitë nabë́ꞌnëll. ");
INSERT INTO zacNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Perë ra contrari shtë më bëquebi rall: ―Lëꞌë naꞌa napë naꞌa tubi lëy; según lëy shtë naꞌa rniꞌin de quë gati mënë ni purquë guníꞌill nall shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Iurë Pilato bini zndëꞌë, másruꞌu bëdzë́bëll. ");
INSERT INTO zacNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Iurní bëuꞌll stubi laꞌni palaci nu gunaꞌbë díꞌdzëll lu Jesús: ―¿Chu më́nël? Perë Jesús adë bëquébidiꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Iurní repi Pilato: ―¿Pë adë guëquébidiꞌil lua chu më́nël? ¿Ni mudë adë guënë́diꞌil napa pudërë parë guna crucificar lë́ꞌël nu zac napa pudërë parë guënehia libertá lë́ꞌël? ");
INSERT INTO zacNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús guniꞌi: ―Ni tubi pudërë nápëdiꞌil parë na si talë Dios adë bënéꞌediꞌiꞌ pudërë. Por ni rniaꞌa lul de quë ra nabëꞌnë intriegu na lul, ni napë mayurë duldë. Na rall más pecadurë quë lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Dizdë iurní Pilato gudílill manërë parë guëdë́ꞌëll libertá lëꞌë Jesús, perë ra contrari shtë më gurushtiá rall: ―Si talë guëldáꞌal nguiu rëꞌ, nádiꞌil amigu shtë rëy César, el quë narnibëꞌa lëꞌë hiaꞌa. Cualquier el quë nagac rëy, ni quëhúnëll cuntrë gubiernë shtë César. ");
INSERT INTO zacNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Iurë bini Pilato diꞌdzë rëꞌ, gunibë́ꞌall guëruꞌu Jesús lugar ni nu Pilato guzúbëll lu tribunal shtë́nëll, lugar naná lë Gabata con dizë́ hebreo. Lë ni runë cuntienë, Empedrado, lugar catë nanú pisë shtë cemëntë. ");
INSERT INTO zacNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Guc visperë shtë Pascu, iurë bëꞌnë mënë preparar laní. Mizmë dzë ziquë guëruldë dzë, iurní Pilato guniꞌi lu ra contrari shtë Jesús: ―Ndëꞌë na rëy shtënë të. ");
INSERT INTO zacNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Lëꞌë rall gurushtiá rall; guniꞌi rall: ―Gátill, gátill, quëll lu cruz. Pilato guniꞌi: ―¿Ni mudë guna crucificar rëy shtënë të? Perë ra jëfë shtë ra bëshuzi bëquebi rall: ―Lëꞌë naꞌa sulë tubsë rëy napë naꞌa. Nall rëy César, el quë narnibëꞌa más laꞌni guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Con ndëꞌë Pilato bë́ꞌnëll intriegu lëꞌë Jesús lu rall parë gati më lu cruz. Biaꞌa rall lëꞌë më de ndë. ");
INSERT INTO zacNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nuaꞌa më cruz. Ziaꞌanú rall lëꞌë më lugar nalë Calavera, diꞌdzë hebreo lëhin Gólgota. ");
INSERT INTO zacNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ngaꞌli bëꞌnë rall crucificar lëꞌë më con chupë mënë mal, tubi rall cadë tubi cuꞌ, hia lëꞌë Jesús guëláu. ");
INSERT INTO zacNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato bëquëꞌë tubi letrërë narniꞌi: “Jesús de Nazaret, rëy shtë naciuni Israel”. Quë letrërë guëc cruz. ");
INSERT INTO zacNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Cantidá mënë narëtaꞌ ndë, biꞌldi rall letrërë ni purquë lugar catë cuë më lu cruz naquë́ guëlladchi ruaꞌ ciudá Jerusalén. Lëꞌë letrërë ni naescritë con dizë́ hebreo, nu dizë́ griego, nu dizë́ latín. ");
INSERT INTO zacNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ra jëfë shtë ra bëshuzi guniꞌi rall lu Pilato: ―Adë rquë́ꞌëdiꞌil “Rëy shtë naciuni Israel” sino más bien bëquëꞌë lo quë naguníꞌill: “Nahia Rëy shtë naciuni Israel”. ");
INSERT INTO zacNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Perë Pilato bëquebi: ―Lo quë nabëquëaꞌa, zni guëaꞌnin. ");
INSERT INTO zacNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Despuësë lëꞌë ra suldadë bëquëꞌë rall lëꞌë më lu cruz, iurní bëtëá rall shabë më nu gudiꞌdzë rall lari ni. Gulú rallin tapë ldë, tubi ldë́gahin parë cadë tubi suldadë. Iurní gunaꞌzi rall lari capë. Nahin tubi lari mantë, lari intërë de tubsë hili. ");
INSERT INTO zacNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ra suldadë guniꞌi rall lu saꞌ rall: ―Adë chu guëchéꞌzëdiꞌin; más mejurë guëdchítaꞌa guëꞌë dado të parë niaꞌa chu gunë gan lari rëꞌ. Zni guc cumplir Sagradas Escrituras narniꞌi: “Gudiꞌdzë rall shaba, perë stubi ldëhin gudchitë rall guëꞌë dado”. ");
INSERT INTO zacNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Zndë bëꞌnë ra suldadë rumanë. Guëaꞌ cruz shtë Jesús quëbezë shniꞌa më nu quëbezë béldiꞌ lë María naná tseꞌlë Cleofas. Nu quëbezë María Magdalena guëaꞌ cruz. ");
INSERT INTO zacNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iurë Jesús guná më lu shniꞌa më, zugáꞌaiꞌ culaꞌni poshtë namás rac shtuꞌu më, repi më lu shniꞌa më: ―Nanë, lëꞌë shínil niꞌi. Gápiꞌ lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nu guniꞌi më lu poshtë ni: ―Lëꞌë shníꞌal niꞌi. Dizdë iurní lëꞌë poshtë ni bë́ꞌniꞌ recibir lëꞌë María lidchi poshtë. ");
INSERT INTO zacNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Despuësë de ndëꞌë, cumë Jesús rac bëꞌa më de quë grë́tëꞌ guc cumplir nu parë gac cumplir laꞌni Sagradas Escrituras, guniꞌi më: ―Rbidcha. ");
INSERT INTO zacNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ngaꞌli zugaꞌa tubi mbluri gadzë́ vini hiꞌ. Iurní gunaꞌzi ra suldadë tubi spongë; bëgaꞌdzë rallin con vini nu bëzuꞌbë rall spongë ni guëc tubi hiaguë shtë hisopo. Iurní bëdchiꞌguë rallin ruaꞌ Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús gudchi më guëc spongë ni, Biiꞌ më vini; iurní guniꞌi më: ―Grë́tëꞌ guc cumplir. Iurní bërëꞌngu më nu bë́ꞌniꞌ intriegu espíritu shtë́hiꞌ lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Stubi dzë antsë gac laní, dzë narziꞌi lduꞌu mënë, ra mënë israelitë adë në́diꞌi rall guëaꞌnë ra cuerpë lu cruz parë dzë narziꞌi lduꞌu mënë, pues dzë ni na dzë descansë nu nalë́ laní ruꞌbë na. Nu na dzë delicadë. Por ni gunaꞌbë rall lu Pilato parë quitsu suldadë guëaꞌ ra naquë́ lu cruz parë gati rall nu tsabsú cuerpë shtë rall lu cruz. ");
INSERT INTO zacNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Iurní ra suldadë bëdchini rall guëaꞌ cruz. Guditsu rall guëaꞌ primërë naquënú më lu cruz. Nu guditsu rall guëaꞌ stubi naquë́ stubi cuꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Perë guabiꞌguë rall lu Jesús; guná rall hia guti më. Por ni adë gudítsudiꞌi rall guëaꞌ më. ");
INSERT INTO zacNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Perë tubi suldadë bëquë́ꞌëll lansë culaꞌni më. Iurní bëruꞌu rënë con nisë. ");
INSERT INTO zacNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","El quë naruadiꞌdzë ndëꞌë gunall nu rníꞌill verdá nu rac bë́ꞌall de quë verdá ruadíꞌdzëll të parë lëꞌë të tsaldí lduꞌu të zndëꞌë ");
INSERT INTO zacNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","purquë zndëꞌë guzac parë gac cumplir Sagradas Escrituras narniꞌi: “Adë gudítsudiꞌi rall ni tubi baꞌcu shtë́niꞌ”. ");
INSERT INTO zacNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nu stubi partë shtë Escrituras rniꞌi: “Guëbiꞌa rall lu el quë nabëquëꞌë rall lansë”. ");
INSERT INTO zacNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Despuësë de gualú grë́tëꞌ ndëꞌë, José më guëꞌdchi Arimatea, guagnáꞌbëll permisi lu Pilato parë guáꞌall cuerpë shtë Jesús të tsacáꞌchill lëꞌë më. José guc tubi shmënë më perë aunquë nilë nagaꞌchi purquë rdzë́bëiꞌ lu ra contrari shtë Jesús. Pilato bëdëꞌë permisi; iurní biaꞌa José cuerpë shtënë më. ");
INSERT INTO zacNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nu zac Nicodemo, el quë naguagná lëꞌë më gueꞌlë, bëdchininú Nicodemo con nanutsë mirra nu áloes cumë cincuenta kilo nuáꞌall. ");
INSERT INTO zacNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Zni lëꞌë José con Nicodemo biaꞌa rall cuerpë shtë Jesús. Bëtuꞌbi rall lëꞌë më tubi ldë lari naquichi con mizmë naguctsaꞌu nisë nashi nanutsë según custumbrë shtë ra më israelitë napë quë guëgaꞌchi tubi tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lugar ni catë bëquëꞌë rall lëꞌë më lu cruz, ngaꞌli naquë́ tubi lahuertë. Mizmë laꞌni lahuertë ni naquë́ tubi baꞌa catë ni tubi laꞌdi chu bëgáꞌchidiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ngaꞌli bëcaꞌchi raiꞌ cuerpë shtë Jesús purquë lëꞌë baꞌa ni naquë́ guëlladchi, nu dzë descansë hia bëgaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Primërë dzë shtë llmalë María Magdalena gua ruaꞌ baꞌa. Tumpranë nianá rruꞌu nacahi gunáhiꞌ hiadë nídiꞌi guëꞌë nadaꞌu ruaꞌ baꞌa. ");
INSERT INTO zacNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Iurní guaglluꞌnë María catë zúgaꞌa Simón Pedro con lëꞌë poshtë namás rac shtuꞌu Jesús. Guniꞌi María: ―Biaꞌa mënë shcuerpë Dadë Jesús catë bëgáꞌchiꞌ; adë chu guënë́diꞌi catë guacaꞌchi ra mënë shcuérpiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Iurní Pedro con stubi poshtë bëruꞌu raiꞌ. Gua raiꞌ ruaꞌ baꞌa. ");
INSERT INTO zacNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Guërupë raiꞌ ziaglluꞌnë raiꞌ juntë perë lëꞌë stubi poshtë gudchibëlú lu Pedro; bëdchíniꞌ guëlútëꞌ lë́ꞌiꞌ ruaꞌ baꞌa. ");
INSERT INTO zacNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Iurní bëáꞌchiꞌ nu gunáhiꞌ lu lari liensë nanagaꞌa ngaꞌli perë adë guatë́diꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Despuësë Simón Pedro bëdchini tëchi poshtë ni. Iurní Pedro guatë́hiꞌ laꞌni baꞌa, nu zac lë́ꞌiꞌ gunáhiꞌ lu lari liensë; zaꞌquë zaꞌquë në́ꞌachi dchiꞌbin shlugarin. ");
INSERT INTO zacNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nu guná Pedro lari naquichi nabëlliꞌi guëc Jesús; adë dchiꞌbin juntë sino tubi ladë në́ꞌachi dchiꞌbin. ");
INSERT INTO zacNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Iurní poshtë nabëdchini primërë, guatë́hiꞌ nu gunáhiꞌ. Gualdí ldúꞌiꞌ guashtë́ Jesús ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Perë todavía adë guasë́diꞌi raiꞌ Sagradas Escrituras de quë Jesús napë quë gac resucitáriꞌ ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Iurní ra poshtë bëabrí raiꞌ lidchi raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María Magdalena bëáꞌniꞌ tëchi fuërë ruaꞌ baꞌa. Rúꞌniꞌ culaꞌni baꞌa. Mientras quëhúꞌniꞌ, iurní bëáꞌchiꞌ parë guënáhiꞌ laꞌni baꞌa. ");
INSERT INTO zacNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Gunáhiꞌ chupë ianglë zugaꞌa; nacu raiꞌ lari naquichi. Zúbëgaꞌa ra ianglë ni; tubi zúbëgaꞌa nezë guëc catë bëgaꞌchi Jesús. Stubi zúbëgaꞌa nezë guëaꞌ catë bëgaꞌchi më. ");
INSERT INTO zacNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Lëꞌë ra ianglë guniꞌi raiꞌ lu María: ―Nanë, ¿pëzielú rúꞌnël? Lë́ꞌiꞌ bëquebi: ―Purquë biaꞌa ra mënë lëꞌë Dadë Jesús, perë adë chu guënéꞌediꞌi rsunë ca nezë guacaꞌchi ra mënë lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Niáꞌasë gualú guniꞌi María zni, bëdchigrë́hiꞌ lúhiꞌ nezë të́chiꞌ; gunáhiꞌ lu Jesús. Lëꞌë më zugaꞌa më ngaꞌli perë adë rdë́ꞌëdiꞌi María cuendë de quë lëꞌë Jesús ni. ");
INSERT INTO zacNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iurní Jesús gunaꞌbë díꞌdziꞌ lu María: ―Nanë, ¿pëzielú rúꞌnël? ¿Chull rguílil? María rúniꞌ llgabë de quë aquë narapë lahuertë ni quëgniꞌi. Iurní répiꞌ lu mënë ni: ―Si talë lë́ꞌël biáꞌal cuerpë shtë Jesús, guniꞌi lua ca nezë guacáꞌchil lë́ꞌiꞌ të parë tsagllía shcuérpiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús repi: ―María. Lëꞌë María bëdchigrë́hiꞌ nu guníꞌiꞌ con dizë́ hebreo: ―Raboni. (Diꞌdzë ni runë cuntienë, Mësë.) ");
INSERT INTO zacNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús repi: ―Adë cuéꞌzëdiꞌil na purquë laꞌdi tsépidiaꞌa catë quëbezë Shtada, perë tsagníꞌil lu ra los de más bëcha de quë lëꞌë na tsepia catë quëreldë Shtada nu Shtádëgaꞌa të también. Tsepia catë quëreldë Dios shtëna nu Dios shtënë të. ");
INSERT INTO zacNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Iurní lëꞌë María Magdalena guaguë́ꞌniꞌ visi lu ra shini gusëꞌdë më de quë lë́ꞌiꞌ gunáhiꞌ lu Dadë Jesús nu lëꞌë më guniꞌi grë ra cusë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mizmë dzë ni na primërë dzë shtë llmalë; hia riuꞌ gueꞌlë; ra poshtë rdëá raiꞌ ngaꞌli. Nëꞌau ruaꞌ hiuꞌu dchidchiꞌchi purquë rdzëbë raiꞌ contrari shtë Jesús. Iurní Jesús bëluaꞌalú lu raiꞌ laꞌni hiuꞌu. Guzú më guëláu catë rëtaꞌ raiꞌ nu guniꞌi më: ―Gulë cuedchí lduꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Despuësë de gualú guniꞌi më, iurní bëluaꞌa më guiaꞌa më con culaꞌni më catë gua clavë nu lansë. Iurní bëquitë lduꞌu raiꞌ; guná raiꞌ lu Jesús. ");
INSERT INTO zacNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Lueguë Jesús repi lu raiꞌ stubi: ―Gulë cuedchí lduꞌu të. Cumë ziquë Dadë bëshéꞌldiꞌ na, zni guësheꞌlda lëꞌë të. Guëniꞌi të lu ra mënë shtiꞌdza. ");
INSERT INTO zacNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Iurní bëcaꞌa mbë më nu repi më: ―Gulë bëꞌnë recibir Espíritu Santo. ");
INSERT INTO zacNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Napë të derechë; guëniꞌi të chu bëꞌnë më perdunë, nu chu bë́ꞌnëdiꞌi më perdunë. ");
INSERT INTO zacNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás, tubi de lëꞌë ra poshtë narniꞌi ra mënë Cuachi, adë nídiꞌiꞌ ngaꞌli iurë lëꞌë Jesús bëluaꞌalú lu ra poshtë. ");
INSERT INTO zacNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Los de más ra poshtë guniꞌi raiꞌ lu Tomás: ―Guná naꞌa lu Dadë Jesús. Perë Tomás repi: ―Si talë adë guënádiaꞌa catë gua lansë culaꞌni më nu guëgutë́a shcuëna lugar shtë clavë nu cutë́a guiahia culáꞌniꞌ, hashtë iurní tsaldí lduaꞌa guashtë́ më ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Bëdzaꞌguë llmalë despuësë gudëdë ni, ra poshtë rëtaꞌ raiꞌ stubi nacubi hiuꞌu ni. Dzë ni zugaꞌa Tomás con lëꞌë raiꞌ. Iurní aunquë nilë nëꞌau ruaꞌ hiuꞌu dchidchiꞌchi, Jesús bëluaꞌalú lu raiꞌ nu guzú më guëláu catë rëtaꞌ raiꞌ. Guniꞌi më: ―Gulë cuedchí lduꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nu guniꞌi më lu Tomás: ―Bëtiaꞌa shcuë́nël lu guiahia nu gudeꞌenú guiáꞌal; bëtiaꞌa guiáꞌal culania. Adë rníꞌidiꞌil laꞌni ldúꞌul de quë adë guashtë́diaꞌa ladi ra tëgulë sino tsaldí ldúꞌul nabania. ");
INSERT INTO zacNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Bëquebi Tomás iurní: ―Lë́ꞌël nal Dadë shtëna. Lë́ꞌël nal Dios shtëna. ");
INSERT INTO zacNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús repi: ―Tomás, iurneꞌ sí, rialdí ldúꞌul purquë gunal lua perë más dichusë el quë nagunádiꞌi lua perë rialdí lduꞌu rall na. ");
INSERT INTO zacNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús bëꞌnë másruꞌu cantidá ra cusë ruꞌbë nu milagrë lu ra shini gusëꞌdë më, cusë ni adë bëquë́ꞌëdiaꞌa laꞌni librë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Perë ndëꞌë bëquëaꞌa të parë tsaldí lduꞌu të Jesús de quë na më Cristo, shini Dios. Si talë tsaldí lduꞌu të shtiꞌdzë Jesucristo, guëneꞌe më vidë sin fin parë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Despuësë de ndëꞌë, Jesús bëluaꞌalú lu ra shini gusëꞌdë më stubi vueltë. Zugaꞌa më ruaꞌ nisë nalë Tiberias. Zni guc iurë bëluaꞌalú më lu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Bëdëá ra poshtë, Simón Pedro con Tomás, el quë narniꞌi raiꞌ Cuachi. Zugaꞌa Natanael naná më Caná shtë Galilea nu zugaꞌa ra shini Zebedeo nu chupë de los de más shini gusëꞌdë më. ");
INSERT INTO zacNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Iurní Simón Pedro guniꞌi lu raiꞌ: ―Tsagnaꞌzia mbeldë. Lëꞌë raiꞌ guniꞌi raiꞌ: ―Nu zac lëꞌë naꞌa guëzë́ naꞌa. Iurní beꞌpi raiꞌ laꞌni barcu, perë gueꞌlë ni adë chu mbeldë gunáꞌzidiꞌi raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Hia iurë zeꞌdë grëgueꞌlë, Jesús bëluaꞌalú lu raiꞌ ruaꞌ nisë perë ra shini gusëꞌdë më adë bëdë́ꞌëdiꞌi raiꞌ cuendë de quë lëꞌë më ni. ");
INSERT INTO zacNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Iurní repi më: ―Lëꞌë të narac shtuaꞌa, ¿Pë adë chu mbeldë gunaꞌzi të? Lëꞌë raiꞌ bëquebi raiꞌ: ―Ni túbidiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Iurní guniꞌi Jesús lu raiꞌ: ―Gulë bëtiaꞌa guëꞌshu shtënë të ladë ldi culaꞌni barcu; iurní guënaꞌzi të mbeldë. Zni bëꞌnë raiꞌ. Despuësë adë bë́ꞌnëdiꞌi raiꞌ gan niagú raiꞌ guëꞌshu mbeldë laꞌni nisë tantë zihani mbeldë nanú laꞌni. ");
INSERT INTO zacNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Iurní lëꞌë poshtë naguc shtuꞌu Jesús más, guníꞌiꞌ lu Pedro: ―Lëꞌë Dadë Jesús ndë. Niáꞌasë gualú bini Pedro de quë lëꞌë Dadë Jesús ni, iurní gútiꞌ shabë purquë bëruꞌu lari iurë guagnáꞌziꞌ mbeldë. Iurní bëldáꞌaiꞌ lë́ꞌiꞌ laꞌni nisë parë guëdchíniꞌ guëlú lë́ꞌiꞌ catë zugaꞌa më. ");
INSERT INTO zacNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Los de más poshtë bëdchini raiꞌ ruaꞌ nisë con barcu. Nu quëshaguiú raiꞌ guëꞌshu shtë mbeldë. Pues zugaꞌa ra poshtë ziquë tubi gahiuꞌa metro hashtë ca lu zu më. ");
INSERT INTO zacNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Iurë lëꞌë raiꞌ bëdchini raiꞌ lu guiuꞌu, bëruꞌu raiꞌ laꞌni barcu nu guná raiꞌ tubi guërdë́ dchiꞌbë tubi mbeldë lu guiꞌi. Guná raiꞌ duꞌpë guetështildi. ");
INSERT INTO zacNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús guniꞌi: ―Gulë teꞌenú bëldá mbeldë naguër gualú bëgaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro güeꞌpi laꞌni barcu; iurní bëshaguiúhiꞌ guëꞌshu hashtë ruaꞌ nisë catë na guiuꞌu. Gadzë́tëꞌin mbeldë, purë ma ruꞌbë, ciento cincuenta y tres; perë aunquë nilë zihani ma, adë guriéꞌzidiꞌi guëꞌshu. ");
INSERT INTO zacNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iurní guniꞌi më lu raiꞌ: ―Gulë teꞌe të gau të. Ni tubi raiꞌ adë cuë́diꞌi valurë nianaꞌbë diꞌdzë chu na më purquë rac bëꞌa raiꞌ lëꞌë Dadë Jesús ni. ");
INSERT INTO zacNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iurní lëꞌë Jesús guabiꞌguë më lu raiꞌ. Gunaꞌzi më guetështildi nu belë shtë mbeldë; bëdëꞌë mëhin cuaꞌa ra poshtë gau raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Zndë guc natsunë vësë de quë lëꞌë Jesús bëluaꞌalú më lu ra poshtë despuësë guashtë́ më ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Despuësë gualú gudáu ra poshtë, Jesús guniꞌi lu Simón Pedro: ―Simón, shini Jonás, ¿gu rac shtúꞌul na de verdá más quë los de más saꞌl rac shtuꞌu raiꞌ na? Pedro bëquebi: ―Ahaꞌ Dadë, lë́ꞌël nanël de quë rac shtuaꞌa lë́ꞌël. Jesús repi: ―Pues iurneꞌ, gupë ra mënë narialdí lduꞌi na, ra naná ziquë lliꞌli mituꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iurní bëabrí gunaꞌbë diꞌdzë më nachupë: ―Simón shini Jonás, ¿gu rac shtúꞌul na de verdá? Pedro bëquebi: ―Ahaꞌ Dadë, nanël de quë rac shtuaꞌa lë́ꞌël. Iurní repi më: ―Neꞌ gupë ra mënë narialdí lduꞌi na. Na rall ziquë lliꞌli narquiꞌni vëquërë. ");
INSERT INTO zacNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Hia natsunë vësë gunaꞌbë diꞌdzë më lu Pedro: ―Simón shini Jonás, ¿gu rac shtúꞌul na? Iurní tristë bëaꞌnë lduꞌu Pedro purquë hia bëhunë gunaꞌbë diꞌdzë më lúhiꞌ, si rac shtuꞌu Pedro lëꞌë më. Iurní guniꞌi Pedro: ―Lë́ꞌël nanël grë́tëꞌ cusë. Nanël de quë rac shtuaꞌa lë́ꞌël. Iurní repi më: ―Iurneꞌ gupë ra lliꞌli shtëna, ra mënë nareꞌdë naldë na. ");
INSERT INTO zacNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Guldía rniaꞌa lul, iurë gúquël sultërë, rácul shábël lo quë narniꞌi ldúꞌul nu rial catë rac shtúꞌul perë iurë lë́ꞌël gúꞌshël, stubi mënë guënaꞌzi guiáꞌal parë sël, nu stúbiꞌ gunë compañi lë́ꞌël parë gácul shábël, nu guáꞌaiꞌ lë́ꞌël catë adë në́diꞌil tsal. ");
INSERT INTO zacNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Zni guniꞌi më parë guëdëꞌë hiaꞌa cuendë lla mudë gati Pedro purquë por galguti shtë Pedro, gúniꞌ guëluáꞌaiꞌ llëruꞌbë na pudërë shtë Dios. Despuësë repi më: ―Guaglaꞌguë bëzuꞌbë diaguë enseñansë shtëna. ");
INSERT INTO zacNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Iurní guná Pedro nezë të́chiꞌ; zeꞌdë naldë lëꞌë poshtë naguc shtuꞌu Jesús, mizmë poshtë el quë nagudaunú më nu nazubë culaꞌni më lu shtse shtë Pascu, mizmë el quë naguniꞌi lu më: “Dadë, ¿chull gunë intriegu lë́ꞌël?” ");
INSERT INTO zacNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Iurë lëꞌë Pedro guná lu poshtë ni, gunaꞌbë diꞌdzë Pedro lu Jesús: ―Dadë, ¿pë gac poshtë rëꞌ? ");
INSERT INTO zacNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús bëquebi: ―Si rac shtuaꞌa guëbánill ndëꞌë hashtë iurë guëabría stubi, adë rúnëdiꞌi tucarë gac bë́ꞌal. Lë́ꞌël guaglaꞌguë bëzuꞌbë diaguë enseñansë shtëna. ");
INSERT INTO zacNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Iurní bërëꞌtsë diꞌdzë rëꞌ ladi los de más bëchi saꞌ ra poshtë de quë adë gátidiꞌi poshtë ni, perë adë guníꞌidiꞌi Jesús de quë adë gátidiꞌi poshtë ni, sino quë guniꞌi më: “Si talë na rac shtuaꞌa de quë guëbániꞌ hashtë guëabría stubi, adë rúnëdiꞌi tucarë gac bë́ꞌal”. ");
INSERT INTO zacNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ndë lo mizmë poshtë naquëhunë testificar grë ra cusë rëꞌ, nu më el quë nabëquëꞌë laꞌni librë rëꞌ. Rdëꞌë hiaꞌa cuendë de quë verdá ruadíꞌdziꞌ. Grë ra poshtë rdëꞌë raiꞌ cuendë de quë verdá na grë ra diꞌdzë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nanú másruꞌu lo quë nabëꞌnë Jesús. Si talë niaquëꞌë por tubin, lluáꞌahia de quë ni parë guëdubi guë́ꞌdchiliu adë niáldëdiꞌi nabé librë lo quë naniactsaꞌu. Amén.");
INSERT INTO zacNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Laꞌni primërë librë nabëquëaꞌa lul, Teófilo, bëquëaꞌa lo quë nabëꞌnë Jesús nu lo quë nabëluaꞌa më dizdë nabëdchini më guë́ꞌdchiliu hashtë iurë beꞌpi më gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Antsë güeꞌpi më gubeꞌe gulezë më poshtë shtë më. Espíritu Santo bëꞌnë compañi lëꞌë Jesús parë guniꞌi më lu ra poshtë guadë dchiꞌni nabëaꞌnënú raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tsana gudëdë guti Jesús, lo mizmë lëꞌë më bëluaꞌalú më lu ra poshtë tal zíquësë nabani më. Nu durantë cuarenta dzë guaglaꞌguë bëluaꞌalú më lu raiꞌ. Zihani cusë bëꞌnë më lu raiꞌ. Biadiꞌdzënú më lëꞌë raiꞌ lla mudë tsutë́ mënë nezë lu gubeꞌe catë rnibëꞌa Dios të gac salvar rall. ");
INSERT INTO zacNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Iurë nianá zugaꞌanú Jesús lëꞌë ra poshtë, guniꞌi më lu raiꞌ adë guërúꞌudiꞌi raiꞌ ciudá Jerusalén. Repi më: ―Gulë cuezë ndëꞌë hashtë guëdchini Espíritu Santo ziquë guniꞌi Shtada lu të, purquë guniꞌi Shtada nu na guniaꞌa lu të, guësheꞌldë më Espíritu Santo parë cuezënúhiꞌ lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Verdá Juan Bautista bëchuꞌbë nísiꞌ ra mënë con nisë perë laꞌni sëbëldá dzë lëꞌë më guëzunë́ më lduꞌu të con pudërë shtë Espíritu Santo. Guëdchini më parë cuezënúhiꞌ lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Iurë zunú Jesús ra poshtë, gunaꞌbë diꞌdzë raiꞌ lu më: ―Dadë, ¿pë hia bëgaꞌa iurë parë guëcubi naciuni Israel ziquë nahin antsë? ");
INSERT INTO zacNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Perë Jesús repi lu raiꞌ: ―Adë rúnëdiꞌi tucarë gac bëꞌa të guc gaquin. Adë rúnëdiꞌi tucarë gac bëꞌa të pë dzë Shtada gunë ra cusë rëꞌ purquë niétiquë lëꞌë më napë më cuendë pë tiempë guëcubin. ");
INSERT INTO zacNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Perë iurë guëdchini Espíritu Santo parë cuezënúhiꞌ lëꞌë të, lë́ꞌiꞌ guënéꞌeiꞌ pudërë parë gac të firmë; tsagniꞌinú të ra mënë grë ra cusë naguná të bëna. Guëniꞌi të lu ra më Jerusalén nu guziaꞌa të regiuni shtë Judea nu regiuni shtë Samaria hashtë lúltimë guëꞌdchi catë rialú guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Iurë gualú biadiꞌdzënú Jesús ra poshtë, mientras rbiꞌa raiꞌ lu më, beꞌpi më gubeꞌe. Gunitilú më laꞌni shcahi. Dizdë iurní adë gunádiꞌi raiꞌ lu Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nianá rbiꞌa ra poshtë nezë lu gubeꞌe, beꞌpi Jesús. De repëntë guná raiꞌ chupë ianglë zugaꞌa culaꞌni raiꞌ; nacu ianglë lari naquichi. ");
INSERT INTO zacNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Repi ianglë lu raiꞌ: ―Lëꞌë të më Galilea, ¿pëzielú rbiꞌa të lu gubeꞌe? purquë Jesús naguná të beꞌpi lu gubeꞌe, lo mizmë lëꞌë më guëabrí stubi vueltë tal zíquësë guná të beꞌpi më. Zni guëabrí më stubi. ");
INSERT INTO zacNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Iurní bietë raiꞌ lu dani nalë Olivos. Bëabrí raiꞌ parë Jerusalén. Rëaꞌnë Jerusalén guëllaꞌ parë dani Olivos tubi distanci de tubi kilómetro. ");
INSERT INTO zacNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Iurë bëdchini raiꞌ Jerusalén, bëá raiꞌ hiuꞌu catë quëreldë raiꞌ. Beꞌpi raiꞌ hashtë guiaꞌa segundë pisë catë na tubi cuartë ruꞌbë. Grë ra nabëagrí lë raiꞌ: Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo llgaꞌnë Alfeo. Nu zugaꞌa Simón nanapë llëruꞌbë ánimo parë lëy shtë Moisés. También zugaꞌa Judas shini Jacobo. ");
INSERT INTO zacNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Grë ra më rëꞌ bëdëá raiꞌ tubsë parë ruadiꞌdzënú raiꞌ Dios. Nu ra bëchi Jesús nu María, shniꞌa më, bëdëá raiꞌ con sëbëldá ra naꞌa; bëdëá raiꞌ ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Dzë ni Pedro guasuldí guëláu ladi grë nazubëgaꞌa ndë. Na rall ziquë tubi gahiuꞌa galdë mënë nagualdí lduꞌi dizaꞌquë shtë Jesús. Guniꞌi Pedro lu raiꞌ: ");
INSERT INTO zacNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Rniaꞌa lu të iurneꞌ cumë ziquë bëcha, napë quë guc cumplir nabëquëꞌë David. Espíritu Santo bëꞌnë compañi lëꞌë David tsana bëquë́ꞌëiꞌ laꞌni Sagradas Escrituras ra cusë nabëꞌnë Judas purquë Judas guanull ra mënë parë gunaꞌzi rall Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Guc Judas tubi saꞌ naꞌa iurë guzënú naꞌa lëꞌë Jesús. Jesús gudili lë́ꞌëll nu gúquëll tubi shini gusëꞌdë më parë bë́ꞌnëll dchiꞌni con lëꞌë naꞌa, ");
INSERT INTO zacNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","perë bë́ꞌnëll duldë. Con dumí nabëtuuꞌ Judas lëꞌë Jesús, guasiꞌi ra mënë tubi ldë guiuꞌu lachi. Lo mizmë lugar ni gulaguë Judas rguëc Judas. Nu gutsë láꞌnill; bëruꞌu grë llëguëzíꞌall. ");
INSERT INTO zacNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ra më Jerusalén bini rall pë guc con Judas nu gululë́ rall lachi ni Acéldama según dizë́ shtënë rall. Rniꞌi rall, Lachi Catë Bëllëꞌë Rënë. ");
INSERT INTO zacNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Guniꞌi zac Pedro: ―Guc cumplir narniꞌi laꞌni librë Salmos. Rniꞌi librë ni zndëꞌë: Guëaꞌnëgá lídchill, nu adë guëdzélëdiꞌi chu guëquëreldë lídchill. Guëdzelë stubi naguëuꞌ shlugárëll, tubi nagunë dichiꞌni. ");
INSERT INTO zacNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Zeꞌdë naldë ra nguiu naquëhunë compañi lëꞌë naꞌa lu guëdubi tiempë naguzënú naꞌa Dadë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Zeꞌdë naldë rall dizdë nabëchuꞌbë nisë Juan lëꞌë Jesús nu hashtë tsana lëꞌë më beꞌpi gubeꞌe. Rquiꞌni guëdili hiaꞌa stubi nguiu; guëuꞌ nguiu ni shlugar Judas. Rquiꞌni tubi naná testigu de quë guashtë́ Jesús ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Iurní gudili raiꞌ chupë nguiu nazeꞌdë naldë lëꞌë raiꞌ dizdë naguzënú raiꞌ Jesús. Túbill lë José nu lëll Barsabás. Nu napë stubi lëll Justo; tsunë lëll. Stúbill lë Matías. ");
INSERT INTO zacNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Iurní grë raiꞌ biadiꞌdzënú raiꞌ Dios: ―Dadë, lë́ꞌël nanël lla na laꞌni lduꞌu grë nguiu; por voluntá shtë́nël bëluaꞌa guadë de chupë nguiu rëꞌ gáquëll poshtë; gúnëll shchíꞌnil con lëꞌë naꞌa ");
INSERT INTO zacNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","purquë Judas bëniti. Bësëaꞌnëgall shchíꞌnil. Por duldë nabë́ꞌnëll, zëagzëll lugar shtënë cashtigu. Gabildi bëꞌnë tucárëll. ");
INSERT INTO zacNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Iurní gudchitë raiꞌ guëꞌë dado niaꞌa chu guëruꞌunú poshtë. Bëꞌnë tucarë Matías. Iurní lueguë bëuꞌll ladi ra poshtë parë bëzá raiꞌ chiꞌbë chupë. ");
INSERT INTO zacNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tsana bëdchini laní Pentecostés, grë ra poshtë nu ra narialdí lduꞌi dizaꞌquë, bëdëá rall tubsë lugar. ");
INSERT INTO zacNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","De repëntë bini raiꞌ tubi ruidë nabëruꞌu nezë lu gubeꞌe ziquë ridë tubi mbë dushë. Gubë́ guëdubi laꞌni hiuꞌu catë zubë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Iurní bëdchini llni guëc raiꞌ. Cadë túbiꞌ rluaꞌain ziquë tubi beꞌlë cadë lëꞌë ra nazubë laꞌni hiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Grë raiꞌ bëꞌnë recibir Espíritu Santo laꞌni lduꞌu raiꞌ parë cuezënú më lëꞌë raiꞌ. Espíritu Santo bëzunë́ lduꞌu raiꞌ nu bëdë́ꞌëiꞌ pudërë të guadiꞌdzë raiꞌ stubi dizë́ nadë ráquëdiꞌi raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Dzë ni guquëreldë zihani israelitë ciudá Jerusalén. Bëdchini rall de grë naciuni shtë guë́ꞌdchiliu. Rialdí lduꞌu rall shtiꞌdzë Dios nu runë rall cumplir creenci shtë mënë israelitë. ");
INSERT INTO zacNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Iurë bini rall ruidë naguꞌ ngaꞌli, bëdëá rall nu adë bëdzélëdiꞌi rall pë nihunë rall purquë cadë lëꞌë rall bini rall dizë́ shtënë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nalë́ bëdzëguëëꞌ lduꞌu rall. Guasë́ lduꞌu rall; guniꞌi lu saꞌ rall: ―¿Pë lë́ꞌëdiꞌi më Galilea grë ra ndëꞌë naquëadiꞌdzë? ");
INSERT INTO zacNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Llallë bëꞌnë rall rac rall ruadiꞌdzë rall dizë́ shtë hiaꞌa? ");
INSERT INTO zacNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","purquë ndëꞌë zëꞌpaꞌa zihani guëꞌdchi nu naciuni. Ndëꞌë zeꞌdë mënë shtënë Partia. Zeꞌdë mënë shtënë Media. Zeꞌdë mënë shtënë Elam. Zeꞌdë mënë shtënë Mesopotamia. Zeꞌdë mënë shtënë Judea. Zeꞌdë mënë shtënë Capadocia. Zeꞌdë mënë shtënë Ponto. Zeꞌdë mënë shtënë Asia. ");
INSERT INTO zacNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Nu zeꞌdë mënë shtënë Frigia. Zeꞌdë ra mënë shtënë Panfilia nu Egipto. Zeꞌdë ra mënë lugar shtënë Africa narëaꞌnë más zitu quë Cirene. Nu entrë lëꞌë hiaꞌa nanú ra israelitë nanapë derechë ziquë mënë rumanë; quëreldë rall ndëꞌë. Stubi shcuaꞌa mënë gualdí lduꞌu rall creenci shtënë ra israelitë. ");
INSERT INTO zacNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","También nanú ra mënë nazeꞌdë tubi dani nalë Creta nazubë laꞌni nisëduꞌu. Nu zeꞌdë ra mënë Arabia, perë grë hiaꞌa rini hiaꞌa quëadiꞌdzë ra mënë Galilea con dizë́ shtë́naꞌa. Quëadiꞌdzë rall milagrë nu cusë zaꞌquë nabëꞌnë Dios parë ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Grë́tëꞌ mënë Jerusalén rdzëguëëꞌ lduꞌu rall; adë bëdzélëdiꞌi rall pë gunë rall. Rniꞌi lu saꞌ rall: ―¿Pë runë cuntienë ra cusë rëꞌ? ");
INSERT INTO zacNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Perë stubi tantë rall bëꞌnë rall burnë; guniꞌi rall: ―Rzuuꞌdchi ra tuntë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Iurní guasuldí Pedro con guëzá chiꞌbë tubi poshtë. Guniꞌi Pedro lu mënë; fuertë guníꞌiꞌ: ―Lëꞌë të më Judea nu grë ra mënë naquëreldë Jerusalén, gulë bëquë́ diaguë lo quë narniaꞌa lu të iurneꞌ parë gac bëꞌa të. ");
INSERT INTO zacNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ni tubi naꞌa adë rzuuꞌdchidiꞌi naꞌa cumë ziquë runë të shgabë të. Nanë́ të ni tubi chu rzuuꞌdchidiꞌi rquë guëꞌë rsili. ");
INSERT INTO zacNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Más ndëꞌë ra cusë naguná të iurneꞌ, bëquëꞌë Joel tiempë guahietë; bëquë́ꞌëiꞌ shcuendë lo quë naguër gac. Joel guniꞌi shtiꞌdzë Dios zdëꞌë: ");
INSERT INTO zacNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Lúltimë dzë guësheꞌlda Espíritu Santo parë cuezënúhiꞌ grë mënë narëtaꞌ lu guë́ꞌdchiliu. Llgaꞌnë ra mënë nu shtsaꞌpë rall guadiꞌdzë rall shtiꞌdza. Lëꞌë rall guëná rall cusë naguër gac nu nagudëdë guc. Nu mëgulë guëná rall cusë naguëniꞌi shcaꞌldë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Dzë ni guësheꞌlda Espíritu Santo parë cuezënúhiꞌ nguiu nu ra naꞌa narzuꞌbë diaguë shtiꞌdza. Guadiꞌdzë rall zihani cusë cumë ziquë guniꞌi ra shmuza guahietë. ");
INSERT INTO zacNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Guiaꞌa lu gubeꞌe guëluáꞌahia cusë natsasë́ lduꞌu mënë, nu guetë lu guë́ꞌdchiliu guësheꞌlda ra sëñi nadzëꞌbë cumë ziquë rënë, beꞌlë nu tsasë ra shcahi cumë ziquë gushë. ");
INSERT INTO zacNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Guëꞌau lu ngubidzë guëcahi. Nu mbehu guëac ziquë na rënë, antsë guëdchini më. Dzë ni guëdchini më con llëruꞌbë pudërë nu llni shtënë më. ");
INSERT INTO zacNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nu grë ra mënë narnaꞌbë lu më, gac salvar rall. ");
INSERT INTO zacNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Lëꞌë të më israelitë, gulë bëquë́ diaguë iurneꞌ lo quë narniaꞌa lu të. Dios bëꞌnë zihani milagrë lu guë́ꞌdchiliu. Bëꞌnë më cusë ruꞌbë por Jesús, më Nazaret, parë guëná të nu parë guëdëꞌë të cuendë de quë Jesús na el quë nabësheꞌldë Dios. Hia lëꞌë të nanë́ të ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Perë gulë guná, tsana guc intriegu Jesús guiaꞌa të, biaꞌa të lëꞌë më prësi. Bëꞌnë të intriegu lëꞌë më lu ra nguiu mal parë gudini rall lëꞌë më. Bëquëꞌë rall lëꞌë më lu cruz perë dizdë antsë, ni na voluntá shtë Dios purquë hia zni zeꞌdë më gati më lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Perë tsana guti Jesús, bëldishtë́ Dios lëꞌë më ladi ra tëgulë. Adë bëꞌnë galguti gan nasëaꞌnë lëꞌë më purquë napë më pudërë parë guashtë́ më ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Guahietë bëquëꞌë rëy David shcuendë Jesús zdëꞌë: Siemprë rnahia lu Dadë. Cabezënuhia lëꞌë më, nu lëꞌë më cabezë ladë ldi shtëna. Con lëꞌë më adë chu guësëníꞌbidiꞌi na. ");
INSERT INTO zacNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Por ni nanú nilli lduaꞌa nu biadiꞌdza ra dizaꞌquë nabësëquitë lduꞌu ra mënë. Rialdí lduaꞌa si talë gatia, guëziꞌi lduaꞌa. Adë bë gáquëdiꞌi shcuerpa, ");
INSERT INTO zacNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","purquë lë́ꞌël adë guësëáꞌnëdiꞌil shcuerpa ladi ra tëgulë. Nu adë guësáꞌnëdiꞌil gau guiuꞌu shcuerpa purquë nahia shínil narac shtúꞌul. ");
INSERT INTO zacNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Bëluaꞌa na nezë zaꞌquë catë nezë napa vidë sin fin. Nalë́ rquitë lduaꞌa iurë guëquëreldënúa lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Rniaꞌa lu të Dadë, cusë clarë nahin. Shtadë guëlú hiaꞌa David, gútiꞌ nu bëgáꞌchiꞌ. Pues catë nagaꞌa baꞌa shtë́hiꞌ grë hiaꞌa nanë́ hiaꞌa catë nagaꞌa baꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Perë guc David muzë shtë Dios nu biadíꞌdziꞌ shtiꞌdzë më. Bëquëꞌë David lo quë naguc con Jesús. Dios guniꞌi lu David; bëꞌnë më prometer nu bëꞌnë më jurar de quë tubi shini David gac Rëy. Guërulë́ shini David, Cristo nu guënibë́ꞌaiꞌ cumë ziquë gunibëꞌa David. ");
INSERT INTO zacNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David cumë ziquë gunáhiꞌ lo quë nagac cumplir dizdë antsë, biadíꞌdziꞌ shcuendë lla tsashtë́ Jesús ladi ra tëgulë. Nu guniꞌi David adë guësëaꞌnëgá Dios lëꞌë Jesús ladi ra tëgulë, nilë shcuerpë më adë guëáꞌnëdiꞌi laꞌni baꞌa parë adë gáudiꞌi guiuꞌu lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios bëldishtë́ lëꞌë Jesús ladi ra tëgulë, el mizmë Jesús nagudini të. Na naꞌa testigu de quë guti Jesús nu nabani më iurneꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Por voluntá shtë Dios guzubë më ladë ldi shtë më, nu bëdëꞌë Dios Espíritu Santo parë Jesús ziquë bëꞌnë më prometer antsë. Bëdëꞌë Dios pudërë lëꞌë Jesús parë guësheꞌldë më Espíritu Santo guë́ꞌdchiliu parë cuezënúhiꞌ grë ra narialdí lduꞌu dizaꞌquë shtënë Jesús. Nu grë ra cusë rëꞌ narini të nu narná të, zeꞌdin de lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Zni nahin purquë lë́dëdiꞌi David beꞌpi gubeꞌe sino mizmë David guniꞌi zdëꞌë: Lëꞌë Dadë guniꞌi lu Shlama: “Guzubë ndëꞌë ladë ldi shtëna ");
INSERT INTO zacNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hashtë iurë guna gan lu grë enemigu shtë́nël nu guëzuꞌbë diaguë rall shtíꞌdzël”. ");
INSERT INTO zacNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Guëdubi naciuni Israel napë quë gac bëꞌa rall nahin verdá. Jesús nabëꞌnë të crucificar, na më Cristo el quë nabësheꞌldë Dios parë guënibë́ꞌaiꞌ lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Iurë bini ra mënë ra cusë naguniꞌi Pedro, nalë́ bëdzëbë rall nu gunaꞌbë diꞌdzë rall lu Pedro nu lu ra poshtë nacabezë ngaꞌli. Guniꞌi rall: ―Gulë guniꞌi Dadë, ¿pë guëdëꞌnë naꞌa? ");
INSERT INTO zacNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Iurní Pedro repi lu rall: ―Gulë bësaꞌnë duldë shtënë të. Gulë bëabrí lduꞌu të con Dios nu gulë guniꞌi con guëdubinú lduꞌu të Jesús na Cristo. Gulë tsa të, chubë nisë të. Iurní gunë më perdunë duldë shtë të nu guëneꞌe më Espíritu Santo të cuezënúhiꞌ lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Quëhunë Dios prometer grë cusë rëꞌ parë lëꞌë të nu parë ra shini të nu parë ra naquëreldë zitu stubi naciuni. Dios guësheꞌldë Espíritu Santo parë grë mënë nacagnaꞌbë më. Na më Dios narnibëꞌa lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Con ra diꞌdzë rëꞌ nu zihani más, Pedro guaglaꞌguë biadiꞌdzënúhiꞌ mënë. Guníꞌiꞌ: ―Lueguë lueguë gulë gunë salvar lëꞌë të ladi mënë mal naná guëdchi lduꞌi. ");
INSERT INTO zacNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Grë ra naguasë́ shtiꞌdzë Pedro, bëriubë nisë rall. Ra nagualdí lduꞌu dizaꞌquë, na raiꞌ ziquë tsunë mili mënë. Bëdëá rall con ra narialdí lduꞌi shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Grë ra naguanaldë ra tëchi ra poshtë, guc rall firmë. Bëzuꞌbë diaguë rall grë ra cusë nabëluaꞌa ra poshtë. Nu gubani rall cumë ziquë tubi famili. Guc lduꞌu saꞌ rall. Rnaꞌbë rall lu Dios. Bëdëá rall parë bëllullë guetështildi ziquë bëluaꞌa Jesús lëꞌë rall antsë. Dzë ni bëagná lduꞌu rall la Santa Cena naguc tsana guzë́ nabani Jesús lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Grë mënë nalë́ bëdzëguëëꞌ lduꞌu rall por tantë milagrë nu cusë ruꞌbë nabëꞌnë ra poshtë. ");
INSERT INTO zacNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Grë ra mënë narialdí lduꞌi dizaꞌquë tubsë llgabë nuaꞌa rall. Gudiꞌdzë rall nanapë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bëtuuꞌ rall nanapë rall ziquë shguiuꞌu rall. Iurní gudiꞌdzë rall centavë cuaꞌa saꞌ rall nabënápëdiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Dzë con dzë ria rall iáduꞌu ruꞌbë nu ria raiꞌ lidchi mënë. Ria raiꞌ parë rëagná lduꞌu raiꞌ la Santa Cena. Grë raiꞌ tubsë rau raiꞌ. Rquitë lduꞌu raiꞌ nu guc lduꞌu saꞌ raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Rnaꞌbë raiꞌ lu Dios nu ruꞌldë ruaꞌ raiꞌ. Guniꞌi raiꞌ: ―Llëruꞌbë na pudërë shtë Dios. Los de más mënë guëꞌdchi bëꞌnë rall rëspëti shmënë Jesús. Dzë con dzë gunaꞌbë Dios mënë parë gac salvar mënë të guëdëá rall con shmënë më. ");
INSERT INTO zacNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tubi dzë Pedro nu Juan ziaꞌa raiꞌ iáduꞌu ruꞌbë rquë tsunë guadzeꞌ. Iurní na iurë rnaꞌbë mënë lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ndë zubë tubi nguiu ruaꞌ iáduꞌu; nall cujë dizdë nagúlëll. Ráquëdiꞌi rzëll; por ni glli glli rianú ra mënë cujë ruaꞌ iáduꞌu. Rzuꞌbë rall cujë ni ruaꞌ puertë nalë Hermosa parë rnáꞌbëll guꞌnë lu ra mënë naziaꞌa iáduꞌu. ");
INSERT INTO zacNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Iurë guná cujë lu Pedro nu Juan, ziaꞌa raiꞌ parë tsutë́ raiꞌ laꞌni iáduꞌu; gunaꞌbë guniꞌi cujë lu raiꞌ parë guëdëꞌë raiꞌ tubi guꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Iurní Pedro nu Juan gubiꞌa raiꞌ lu cujë; repi Pedro lu cujë: ―Guná lu naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Lëꞌë cujë gubiꞌa lu raiꞌ. Lluaꞌa cujë pë nadëꞌë raiꞌ niacaꞌa cujë. ");
INSERT INTO zacNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Perë Pedro guchi lull: ―Adë napa dumí nu adë napa orë parë guënehia cáꞌal, perë lo quë nanapa guna con lë́ꞌël. Ziquë muzë nanahia shtënë Jesucristo më Nazaret, rniaꞌa lul iurneꞌ. Por lë shtë më guasuldí ngaꞌli nu guzë́. ");
INSERT INTO zacNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pedro gunaꞌzi guiaꞌa cujë ladë ldi parë guasuldí cujë. Lueguë lueguë guasuldill. Bëac guëaꞌll. ");
INSERT INTO zacNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Iurní lëꞌë cujë bëchésëll; guzublú rzëll. Guatënú cujë Pedro nu Juan laꞌni iáduꞌu. Rzëll nu rchésëll. Guníꞌill llëruꞌbë na pudërë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Grë ra mënë nazugaꞌa laꞌni iáduꞌu, guná rall lëꞌë cujë rzë nu bini rall nacagniꞌi cujë lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nalë́ bëdzëguëëꞌ lduꞌu rall nu rdzëbë rall iurë guná rall lu cujë. Hia nanë́ rall nguiu ni na lo mizmë nguiu narzubë ruaꞌ iáduꞌu nalë Hermosa. Glli gllítëꞌ gunáꞌbëll guꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Cujë nabëac hiadë bësáꞌnëdiꞌill Pedro nu Juan. Zugaꞌa raiꞌ rualdëaꞌ catë lë Portali shtë Salomón. Nalë́ guabiꞌguë guëlluꞌnë mënë zihani lu Pedro nu Juan. Bëdzëguëëꞌ lduꞌu rall. Guná rall lëꞌë cujë zuldí. ");
INSERT INTO zacNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Iurë guná Pedro ra mënë zihani, guníꞌiꞌ lu rall: ―Lëꞌë të më israelitë, adë rdzëguëëꞌdiꞌi lduꞌu të. ¿Pëzielú rbiꞌa të lu naꞌa zniꞌi? purquë lëdë lë́ꞌëdiꞌi naꞌa bëdënëac naꞌa nguiu rëꞌ parë rzëll. Adë gúquëdiꞌin con pudërë shtë naꞌa; adë gúquëdiꞌin por devociuni nanapë naꞌa con Dios sino quë bënëac Jesús nguiu rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","El mizmë Dios shtënë ra shtadë guëlú hiaꞌa Abraham, Isaac, nu Jacob, nalë́ bëꞌnë më honrar shini më Jesús. Perë lëꞌë të grë të bëꞌnë të intriegu Jesús lu ra gubiernë parë gati më. Nu iurë Pilato guc ldúꞌull niadë́ꞌëll libertá lëꞌë Jesús, lëꞌë të adë gunë́diꞌi të. ");
INSERT INTO zacNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mejurë gunaꞌbë të libertá shtë tubi nguiu nagudini mënë. Adë gunë́diꞌi të niadëꞌë Pilato libertá lëꞌë Jesús, el quë naná limpi lu Dios, el quë naná justë delantë lu më. Santo náhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Zni gudini të Jesús el quë narneꞌe vidë parë lëꞌë mieti. Perë bëldishtë́ Dios lëꞌë Jesús ladi ra tëgulë. Na naꞌa testigu purquë bëabrí guná naꞌa lu më stubi vueltë. ");
INSERT INTO zacNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesús bënëac lëꞌë cujë rëꞌ purquë gualdí lduꞌu naꞌa shtiꞌdzë më. Ziquë muzë nanahia shtë Jesús, guniaꞌa lu cujë: “Guasuldí nu guzë́”. Bëáquëll lueguë ziquë rna të lull iurneꞌ, nu nanë́ të lë́ꞌëll bëáquëll. ");
INSERT INTO zacNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Lëꞌë të Dadë, nanë́a tsana gunibëꞌa jëfë shtë të quini të Jesús, gudini të lëꞌë më, perë adë guc bë́ꞌadiꞌi të chu gudini të. Nilë ra jëfë shtë të guc bë́ꞌadiꞌi rall chu na më. ");
INSERT INTO zacNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Zni guc cumplir voluntá shtë Dios purquë bëquëꞌë ra profetë shtiꞌdzë më antsë quë Cristo gati më lu cruz. ");
INSERT INTO zacNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Por ni iurneꞌ gulë gunë nadzëꞌë mudë nanabani të. Gulë bëdchigrë́ lduꞌu të con Dios parë gunë më perdunë duldë shtënë të. Si talë gunë të zni, Dios guëzunë́ më laꞌni lduꞌu të nu gunë ldaiꞌ më guëdubi vidë shtë të. ");
INSERT INTO zacNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nu guësheꞌldë më Jesucristo stubi vueltë guë́ꞌdchiliu. Ni na guniꞌi Dios antsë. ");
INSERT INTO zacNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Perë iurneꞌ Jesucristo cabezë gubeꞌe hashtë iurë lëꞌë Dios guëzú shnezë grë́tëꞌ ra cusë nabëquëꞌë ra profetë santu, ra nabiadiꞌdzë shtiꞌdzë më guahietë. ");
INSERT INTO zacNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Zni guniꞌi Moisés lu ra shtadë guëlú hiaꞌa: “Dios Padre guëshéꞌldiꞌ tubi naguëniꞌi shtiꞌdzë më, tubi nagalë ladi bëchi të ziquë bësheꞌldë më na. Gulë bëquë́ diaguë grë lo quë naguëniꞌi më lu të ");
INSERT INTO zacNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","purquë grë ra nadë guëzuꞌbë diáguëdiꞌi shtiꞌdzë më, guëdchisú më derechë nanapë rall ziquë mënë israelitë nu gac condenar rall.” ");
INSERT INTO zacNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Zni guniꞌi ra profetë dizdë Samuel hashtë ra profetë nabidë despuësë. Grë raiꞌ guniꞌi raiꞌ naquëac iurneꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Lëꞌë të bëaꞌnënú të ra diꞌdzë naguniꞌi Dios lu ra profetë. Na ni parë lëꞌë të nu parë bien shtënë të. Dios guniꞌi lu Abraham; bëꞌnë më prometer ra cusë naquëac cumplir iurneꞌ. Guniꞌi më lu Abraham: “Por ra shínil gunë ldahia grë ra mënë nanarë́ lu guë́ꞌdchiliu”. ");
INSERT INTO zacNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","’Iurë bëldishtë́ Dios lëꞌë shini më Jesús ladi ra tëgulë, bidë më primërë lu të. Bëdchini më lu të parë gunë ldaiꞌ më lëꞌë të. Gunë më compañi lëꞌë të parë guësaꞌnë të duldë shtë të, të gac salvar të. ");
INSERT INTO zacNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nianá cagniꞌi Pedro nu Juan lu ra mënë, bëdchini ra bëshuzi. Bëdchini tubi jëfë narapë iáduꞌu ruꞌbë. Nu ra saduceos bëdchini. ");
INSERT INTO zacNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nalë́ nalaaꞌdchi rall purquë Pedro nu Juan cagluaꞌa raiꞌ ra mënë nu guniꞌi raiꞌ guashtë́ Jesús ladi ra tëgulë. Guniꞌi raiꞌ por pudërë shtë Jesús, tsashtë́ grë tëgulë catë bëgaꞌchi raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Gunaꞌzi gubiernë lëꞌë Pedro nu Juan nu bëtiaꞌa rall lëꞌë raiꞌ lachiguiꞌbë purquë hia guadzeꞌ parë gac rëglë shcuendë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Perë mënë zihani nabini dizaꞌquë shtë Jesús, gualdí lduꞌu rall shtiꞌdzë më, naꞌa la nguiu. Nu ra nagualdí lduꞌi shtiꞌdzë më, guc rall gaꞌi mili, niétiquë nguiu bëgabë. ");
INSERT INTO zacNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Iurë brëgueꞌlë stubi dzë, bëdëá ra gubiernë nu ra mëgulë nu ra mësë narluaꞌa lëy. Grë rall bëdëá rall Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Zugaꞌa Anás naná jëfë shtë ra bëshuzi. Zugaꞌa Caifás. Zugaꞌa Juan, shmënë bëshuzi. Zugaꞌa Alejandro nu grë shfamili shtë bëshuzi narnibëꞌa los de más bëshuzi. Zugaꞌa rall lugar ni. ");
INSERT INTO zacNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Iurní gulú rall Pedro nu Juan lachiguiꞌbë parë bëzú rall lëꞌë Pedro nu Juan delantë lu ra mënë. Gunaꞌbë diꞌdzë rall lu Pedro nu Juan: ―¿Chu rnibëꞌa lëꞌë të? ¿Chu bëꞌnë punërë lëꞌë të; bënëac të cujë rëꞌ? ");
INSERT INTO zacNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Iurní con pudërë nabëdëꞌë Espíritu Santo laꞌni lduꞌu Pedro, guníꞌiꞌ diꞌdzë rëꞌ: ―Lëꞌë të jëfë shtë guëꞌdchi rëꞌ nu mëgulë shtë naciuni Israel, ");
INSERT INTO zacNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","hia quë lëꞌë të rnaꞌbë diꞌdzë të lu naꞌa lla bëdëꞌnë naꞌa parë bëac cujë rëꞌ; ");
INSERT INTO zacNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","rquebi naꞌa lu të parë gac bëꞌa grë ra mënë israelitë. Lëꞌë cujë naguc lluꞌu zugaꞌa ndëꞌë delantë lu grë të. Bëáquëll por pudërë shtë Jesucristo, më Nazaret, lo mizmë nagudini të. Bëquëꞌë të lëꞌë më lu cruz perë bëldishtë́ Dios lëꞌë Jesús ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Na Jesús ziquë tubi guëꞌë principal shtë iáduꞌu. Guniꞌi të adë guëlluíꞌidiꞌin perë iurneꞌ Jesús bëac më ziquë tubi guëꞌë namás lasac. Lëꞌë të adë guc shtúꞌudiꞌi të lëꞌë më, ");
INSERT INTO zacNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","perë ni tubi chu stubi gunë salvar lëꞌë hiaꞌa, niétiquë Jesús purquë tubsë nguiu bësheꞌldë Dios lu guë́ꞌdchiliu nagunë perdunë duldë shtë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ra gubiernë shtë ra israelitë guná rall adë bëdzë́bëdiꞌi Pedro nu Juan; cagniꞌi raiꞌ lu ra mënë. Guc bëꞌa rall Pedro nu Juan adë na raiꞌ më nabësëꞌdë nu adë nádiꞌi raiꞌ më ruꞌbë. Guasë́ lduꞌu rall. Guc bëꞌa rall Pedro nu Juan guzënú raiꞌ Jesús más antsë. ");
INSERT INTO zacNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nu guná ra gubiernë lëꞌë nguiu naguc cujë; lë́ꞌëll zugaꞌanú Pedro nu Juan. Hiadë pë rníꞌidiꞌi rall cuntrë lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Iurní gunibëꞌa rall guëruꞌu Pedro nu Juan ladi rall parë gac guadiꞌdzë lul saꞌ rall lla mudë gunë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Guniꞌi lu saꞌ rall: ―¿Pë guëdë́ꞌnaꞌa con ra nguiu rëꞌ? purquë grë ra naquëreldë Jerusalén, nanë́ rall milagrë ruꞌbë nabëꞌnë Pedro nu Juan. Bënëac rall cujë. Nu lëꞌë hiaꞌa adë nu mudë guëcá hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mejurë parë adë guërë́ꞌtsëdiꞌi diꞌdzë ladi ra mënë, guëtsë́baꞌa lëꞌë rall parë adë guadíꞌdzëdiꞌi rall lu ra mënë na rall shmënë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Iurní gunaꞌbë rall lëꞌë Pedro nu Juan. Gunibëꞌa rall parë adë guadíꞌdzëdiꞌi raiꞌ, nilë guëluáꞌadiꞌi raiꞌ dizaꞌquë shtë Jesús, nu nilë adë guëníꞌidiꞌi raiꞌ lë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Iurní repi Pedro nu Juan lu ra gubiernë: ―Gulë bëꞌnë shgabë të chu shtënë diꞌdzë guëzuꞌbë diaguë naꞌa. ¿Pë guëzuꞌbë diaguë naꞌa shtiꞌdzë të, u guëzuꞌbë diaguë naꞌa shtiꞌdzë Dios? ");
INSERT INTO zacNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Lëꞌë naꞌa adë nu mudë guëcaꞌchi lduꞌu naꞌa ra cusë naguná naꞌa nu ra cusë naná bini naꞌa. Napë quë guëdiaꞌa diꞌdzë naꞌa lu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Iurní ra gubiernë bëtsëbë rall lëꞌë Pedro nu Juan perë lo mizmë tiempë bëldaꞌa rall lëꞌë raiꞌ purquë adë bëdzélëdiꞌi rall lla mudë nihunë rall cashtigu lëꞌë raiꞌ. Bëldaꞌa rall lëꞌë raiꞌ purquë bëdzëbë rall los de más mënë; grë mënë guniꞌi bëac cujë con pudërë shtë Jesús. Llëruꞌbë na pudërë shtë më, guniꞌi rall. ");
INSERT INTO zacNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Cujë nabëac por pudërë shtë Jesús, nápëll más de cuarenta izë. ");
INSERT INTO zacNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Iurní bëruꞌu Pedro nu Juan; bëagzë́ raiꞌ catë rë los de más saꞌ raiꞌ. Biadiꞌdzë raiꞌ grë lo quë naguniꞌi principal bëshuzi con ra më gushë lu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Iurë gualú biadiꞌdzë raiꞌ lla guc con lëꞌë raiꞌ, grë ra narialdí lduꞌi dizaꞌquë shtë Jesús, gunaꞌbë raiꞌ lu Dios. Juntë guniꞌi raiꞌ: ―Dios Padre, lë́ꞌël nal Shtadë naꞌa. Lë́ꞌël nápël llëruꞌbë pudërë. Bëntsáꞌul gubeꞌe; bëcueꞌshtël guë́ꞌdchiliu. Bëcueꞌshtël nisëduꞌu nu grë ra cusë nananú lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Lë́ꞌël bëshéꞌldël Espíritu Santo parë gulezënúhiꞌ lëꞌë David, muzë shtë́nël. Bëluáꞌal lëꞌë David lla guëquë́ꞌëiꞌ ra diꞌdzë shtë́nël narniꞌi zdëꞌë: ¿Pëzielú bëdzatsu ra mënë? ¿Pëzielú ra mënë shtë guë́ꞌdchiliu runë rall llgabë nanadë rlluíꞌidiꞌi? ");
INSERT INTO zacNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ra rëy shtë guë́ꞌdchiliu nu ra gubiernë shtë ra guëꞌdchi, tubsë bëdzatsu rall cuntrë Dadë. Bëꞌnë rall cuntrë Cristo, el quë nagudílil parë guënibë́ꞌaiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Verdá nahin Herodes nu Poncio Pilato bëdëá rall ndëꞌë cuntrë Jesús, shínil. Limpi náhiꞌ; santu náhiꞌ. Nu ra më rumanë con ra më israelitë, bëꞌnë rall cuntrë shínil nabëshéꞌldël parë guënibë́ꞌaiꞌ lëꞌë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Con ni guc cumplir ra cusë naguníꞌil antsë. Bëꞌnë rall ni purquë hia zni zeꞌdë gac. ");
INSERT INTO zacNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Dadë, iurneꞌ guná pë runë rall cuntrë lëꞌë naꞌa. Bëꞌnë compañi lëꞌë naꞌa parë adë guëdzë́bëdiꞌi naꞌa. Guëdiaꞌa diꞌdzë naꞌa dizaꞌquë shtë́nël lu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Bëluaꞌa pudërë shtë́nël. Bëꞌnë compañi lëꞌë naꞌa parë gunëac naꞌa narac lluꞌu. Guëdëꞌnë naꞌa ra milagrë narac shtúꞌul. Gac rahin por pudërë shtënë Jesús, shínil, më naná limpi laꞌni ldúꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Iurë gualú biadiꞌdzënú raiꞌ Dios, lugar catë rë raiꞌ bëllú. Nacubi bëdchini Espíritu Santo parë cuezënúhiꞌ lëꞌë raiꞌ. Nu adë bëdzë́bëdiꞌi raiꞌ; guniꞌi raiꞌ dizaꞌquë shtë Dios lu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ra nagualdí lduꞌi dizaꞌquë shtë Jesús, guc rall zihani. Tubsë llgabë napë rall. Tubsë na lduꞌu rall. Ni tubi adë chu rniꞌi: “Ndëꞌë shtëna” purquë gudiꞌdzë rall grë nanapë rall cuaꞌa nadë pë nápëdiꞌi según nicidá shtënë cadë lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ra poshtë guaglaꞌguë guniꞌi raiꞌ lu mënë con llëruꞌbë pudërë de quë Dadë Jesús gubani purquë bëldishtë́ Dios lë́ꞌiꞌ ladi ra tëgulë. Nalë́ bëꞌnë ldaiꞌ Dios guëc raiꞌ, nu ra mënë bëꞌnë rëspëti lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ladi ra mënë nagualdí lduꞌi dizaꞌquë, ni tubi rall adë pë bëquíꞌnidiꞌi purquë ra mënë nanapë ra guiuꞌu lachi nu ra nanapë lídchiꞌ, bëtuuꞌ raiꞌ guiuꞌu parë beꞌdë guënú rall dumí. ");
INSERT INTO zacNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Dumí ni bëꞌnë raiꞌ intriegu lu poshtë. Hia ra poshtë gudiꞌdzë raiꞌ dumí parë narquiꞌni según nicidá nanapë mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tiempë ni guꞌ tubi nguiu lëll José. Gúlëll tubi dani nalë Chipre nazubë laꞌni nisëduꞌu. Nall levita. Ra poshtë gululë́ lë́ꞌëll Bernabé narniꞌi, el quë narunë consolar. ");
INSERT INTO zacNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Bernabé bëtuuꞌ tubi ldë guiuꞌu nanápëll. Dumí nabëtuuꞌll guiuꞌu guagsáꞌnëll lu ra poshtë. ");
INSERT INTO zacNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Dzë ni guꞌ tubi nguiu lëll Ananías. Tséꞌlëll lë Safira. Bëtuuꞌ rall tubi ldë guiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nguiu ni bëaꞌnënú tubi partë dumí nabëtuuꞌll guiuꞌu. Stubi partë ni guagsáꞌnëll lu ra poshtë. Répill: ―Zeldë guënúa dumí nabëtúa shguiuꞌua. Perë tséꞌlëll bien nanëll de quë bëaꞌnënú rall tubi partë dumí. ");
INSERT INTO zacNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Iurní Pedro guchi lu Ananías: ―Ananías, ¿pëzielú bësáꞌnël guatë́ mëdzabë laꞌni ldúꞌul parë bëntsáꞌul bishi lu Espíritu Santo? Bëaꞌnë guënul tubi partë dumí nagudilli mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Pëllë lëdë shtë́diꞌil guiuꞌu ni? Iurë bëtuuꞌl, shtë́nël grë dumí. ¿Pëzielú bë́ꞌnël ni? purquë lu Dios bëntsáꞌul bishi, lëdë niétiquëdiꞌi lu naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Iurë Ananías bini ra diꞌdzë naguniꞌi Pedro, guláguëll nu gútill. Grë ra nabini naguc Ananías, nalë́ bëdzëbë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Iurní bëdchini bëldá nguiu catë gulaguë Ananías. Bëtuꞌbi rall cuerpë tubi lari naquichi. Lueguë biaꞌa rall tëgulë parë guacaꞌchi rall tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hia guc tsunë iurë guti Ananías; iurní bëdchini tséꞌlëll Safira perë gáꞌadiꞌi guc bë́ꞌall pë guc con Ananías. ");
INSERT INTO zacNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro gunaꞌbë diꞌdzë lu Safira: ―Bëquebi lua. ¿Pë verdá nahin bëtuuꞌ të guiuꞌu prëci shtë grë dumí nabeꞌdë guësaꞌnë Ananías lu naꞌa? Safira guchi lu Pedro: ―Ahaꞌ. Dani bëtuuꞌ naꞌa guiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Iurní Pedro guniꞌi lull: ―¿Pëzielú guꞌ të de acuerdë? Bëntsaꞌu të bishi parë bësiguë́ të Espíritu Santo niaꞌa guldí më runë më cashtigu. Perë fuërë zeꞌdë ra nguiu nabiaꞌa tséꞌlël parë guacaꞌchi rall tséꞌlël. Iurneꞌ guaꞌa rall lë́ꞌël parë tsacaꞌchi rall lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lueguë iurní gulaguë Safira lu Pedro. Gútill. Iurní guatë́ ra nguiu catë zu Pedro; guná rall lu naꞌa; hia guti naꞌa. Gulú rall naꞌa laꞌni hiuꞌu parë guacaꞌchi rall lëꞌë naꞌa cuꞌ tseꞌlë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Grë ra mënë narialdí lduꞌi dizaꞌquë shtë Jesús nu grë ra nabini ra cusë rëꞌ naguc con Ananías nu Safira, nalë́ bëdzëbë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Zihani milagrë nu cusë ruꞌbë bëꞌnë ra poshtë lu ra mënë. Grë ra narialdí lduꞌi dizaꞌquë, rdëá rall rualdëaꞌ catë lë Portali shtë Salomón. ");
INSERT INTO zacNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Perë zihani mënë adë bëdë́ꞌëdiꞌi valurë të guëdëá rall ladi shmënë Jesús, perë adë pë rníꞌidiꞌi rall cuntrë ra mënë ni purquë casi grë mënë shtë ciudá Jerusalén, bëꞌnë rall rëspëti shmënë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Dzë con dzë más bëac zihani ra nguiu nu zihani ra naꞌa nagualdí lduꞌu shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Iurní guzublú rall gulú rall narac lluꞌu nezë. Gudishi rall narac lluꞌu lu daaꞌ u lu tubi pedasë lari naꞌldë parë iurë tëdë Pedro, guëquë́ shcaaꞌl shtë Pedro guëc ra narac lluꞌu. ");
INSERT INTO zacNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","También bëdchini zihani mënë shtë guëꞌdchi guëllaꞌ nu mënë shtë Jerusalén; bëdchininú rall narac lluꞌu. Bëdchininú rall ra nanapë mëdzabë laꞌni lduꞌi. Bëac grë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Dzë ni jëfë shtë ra bëshuzi con shmënë ra partidë saduceo, gupë rall llëruꞌbë mbidi tantë zihani mënë zianaldë tëchi poshtë. ");
INSERT INTO zacNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Gunaꞌzi rall ra poshtë. Bëtiaꞌa rall poshtë lachiguiꞌbë ");
INSERT INTO zacNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","perë tubi ianglë shtë Dios laꞌni gueꞌlë, guagsháꞌliꞌ ra puertë shtë lachiguiꞌbë parë bëruꞌu ra poshtë nu guchi ianglë lu raiꞌ: ");
INSERT INTO zacNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Gulë bëagzë́ nu gulë biadiꞌdzë lu ra mënë laꞌni iáduꞌu ruꞌbë, lla gunë rall parë gac salvar rall. ");
INSERT INTO zacNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Iurë bini raiꞌ naguniꞌi ianglë, brëgueꞌlë tumpranë gua raiꞌ iáduꞌu ruꞌbë parë ziaglaꞌguë cagluaꞌa raiꞌ mënë. Iurní jëfë shtë ra bëshuzi nu ra nazugaꞌanú rall, bëtëá rall saꞌ rall miembrë shtë Junta Suprema. Ndëꞌë na ra gubiernë narunë juzguë, quiere decir, grë ra më gushë shtë naciuni Israel. Iurní gunibëꞌa rall guëruꞌu ra poshtë lachiguiꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Perë iurë bëdchini ra suldadë ruaꞌ lachiguiꞌbë, adë chu nádiꞌi laꞌni. Guanú rall rsunë lu ra gubiernë. ");
INSERT INTO zacNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Repi rall lu ra nazugaꞌa lu juntë: ―Biagná naꞌa ruaꞌ lachiguiꞌbë. Niétiquë na; dchiꞌchi nëꞌau ruaꞌ lachiguiꞌbë. Guná naꞌa lu ra suldadë naquëhapë ruaꞌ lachiguiꞌbë, perë iurë bëshaꞌlë naꞌa lachiguiꞌbë, ni tubi adë chu nádiꞌi laꞌni. ");
INSERT INTO zacNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Jëfë narapë iáduꞌu con ra bëshuzi principal con lëꞌë bëshuzi más më ruꞌbë, bini rall naguchi ra suldadë lu rall; bëdzëguëëꞌ lduꞌu rall. Guniꞌi lu saꞌ rall: ―¿Pë fin gapë ndëꞌë iurneꞌ? ");
INSERT INTO zacNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Lueguë iurní bëdchini tubi nguiu lu ra jëfë nu gúchill: ―Ra nguiu nabëtiaꞌa të lachiguiꞌbë, lëꞌë rall zugaꞌa laꞌni iáduꞌu ruꞌbë. Cagluaꞌa rall lëꞌë ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Iurní lëꞌë jëfë narapë iáduꞌu con sëbëldá suldadë, guaglliꞌi rall ra poshtë perë sin quë adë pë bëꞌnënú rall lëꞌë raiꞌ purquë bëdzëbë rall niagáu guëꞌë ra mënë lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Iurë beꞌdë guënú rall ra poshtë, bëzú rall lëꞌë raiꞌ lu Junta Suprema. Guniꞌi jëfë shtë ra bëshuzi: ");
INSERT INTO zacNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Hia bëdëꞌnë naꞌa providë lëꞌë të de quë adë guadíꞌdzëdiꞌi të lë Jesús parë guëluaꞌa të ra mënë. Nu guná, ¿pë quëhunë të iurneꞌ? Casi grë mënë Jerusalén hia bini rall nacagluaꞌa të. ¿Pë adë runë të shgabë të? Cagdchiꞌbë të guëc naꞌa por nguiu naguti lu cruz. ");
INSERT INTO zacNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Iurní Pedro nu ra poshtë guniꞌi raiꞌ: ―Pimërë napë quë guëzuꞌbë diaguë naꞌa shtiꞌdzë Dios, lëdë guëlúdiꞌi shtiꞌdzë ra nguiu guëzuꞌbë diaguë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Perë Dios shtë shtadë guëlú hiaꞌa, bëldishtë́ më lëꞌë Jesús ladi ra tëgulë, el mizmë Jesús nagudini të, el quë nabëquëꞌë të lu cruz. ");
INSERT INTO zacNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dios bëldishtë́ lë́ꞌiꞌ parë gubeꞌe. Bëcueꞌzë më lëꞌë Jesús ladë ldi shtë më. Dios guniꞌi Jesucristo na el quë naguënibëꞌa lëꞌë hiaꞌa; náhiꞌ el quë nagunë salvar lëꞌë hiaꞌa lu cashtigu shtënë më. Bëꞌnë Dios punërë nguiu ni të parë gunë nadzëꞌë të mudë nanabani të, nu parë gunë më perdunë lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","De grë cusë rëꞌ na naꞌa testigu con Espíritu Santo purquë cabezënúhiꞌ lëꞌë naꞌa. Verdá nahin guashtë́ Jesús ladi ra tëgulë, nu Dios bëdëꞌë Espíritu Santo parë grë ra nagualdí lduꞌi shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Iurë bini ra nazugaꞌa lu juntë lo quë naguniꞌi ra poshtë, nalë́ bëldë́ rall nu guc lduꞌu rall niaguini rall lëꞌë ra poshtë. ");
INSERT INTO zacNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Perë ladi ra nazubë lu juntë, bëruꞌu tubi nguiu lë Gamaliel. Nall mësë shtë lëy nabëquëꞌë Moisés nu nall fariseo. Nalë́ runë ra mënë rëspëti lë́ꞌëll. Guasuldill nu gunibë́ꞌall parë bëruꞌu ra poshtë stubi ladë. ");
INSERT INTO zacNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Lueguë guníꞌill lu ra saꞌll: ―Rniaꞌa lu të ziquë më ládzaꞌa, gulë gapë cuidadë lo quë nagunënú të ra nguiu rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bësëagná lduꞌu të hia ziaꞌa tiempë neꞌ; dzë ni guꞌ tubi nguiu nabërulë́ Teudas. Guníꞌill lu ra mënë lë́ꞌëll nall tubi nguiu ruꞌbë. Bësiguëll mënë. Ziquë tapë gahiuꞌa nguiu guanaldë rall lëꞌë Teudas, perë despuësë gudini ra mënë lë́ꞌëll. Hia grë ra mënë nacanaldë lë́ꞌëll, bëtëꞌtsë rall. Zni gualú partidë shtë Teudas. ");
INSERT INTO zacNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Despuësë de ra dzë ni, guꞌ stubi nguiu. Bërulëll Judas. Nall më Galilea. Dzë ni guasë cënsë shtë ra mënë. Zihani mënë guanaldë lëꞌë Judas, perë gudini rall lë́ꞌëll nu grë ra shmë́nëll bësaꞌnë saꞌ rall. Bëtëꞌtsë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Por ni rniaꞌa lu të, gulë bësaꞌnë ra nguiu rëꞌ. Zuziaꞌa rall. Adë rzunáldëdiꞌi të lëꞌë rall purquë si talë cusë rëꞌ nahin cusë shtë nguiu, zialuhin. ");
INSERT INTO zacNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Perë si talë ndëꞌë nahin shchiꞌni Dios nu rac shtuꞌu të guënitilú tëhin, ¿lla guëruꞌu të? Gulë gupë cuidadë, purquë si talë lëꞌë rall quëhunë rall shchiꞌni Dios nu lëꞌë të rzu të lu rall, quëhunë të cuntrë Dios iurní. ");
INSERT INTO zacNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Iurë gualú biadiꞌdzë Gamaliel lu ra nazú lu juntë, bëaꞌnë rall cunformë. Iurní gunaꞌbë rall lëꞌë poshtë. Gunibëꞌa rall guëdiaꞌa raiꞌ hiaguë, nu guniꞌi rall fuertë lu raiꞌ de quë adë guadíꞌdzëdiꞌi raiꞌ shtiꞌdzë Jesús. Bëdëꞌë rall libertá lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bëruꞌu ra poshtë lu juntë. Nalë́ bëquitë lduꞌu raiꞌ purquë ra nazubë lu juntë, guniꞌi guidzë rall lëꞌë Pedro nu Juan purquë na raiꞌ shmënë Jesús. Guc bëꞌa raiꞌ grë lo quë naguc, bëꞌnë më ordenar nu bëquitë lduꞌu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Perë adë bësáꞌnëdiꞌi raiꞌ guaglaꞌguë biadiꞌdzë raiꞌ lu ra mënë de quë Jesús na Cristo el quë nabësheꞌldë Dios lu guë́ꞌdchiliu. Glli gllítëꞌ guazë́ guagluaꞌa raiꞌ ra mënë laꞌni iáduꞌu ruꞌbë nu lidchi ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tiempë dzë ni zihani mënë gualdí lduꞌu raiꞌ dizaꞌquë. Cadë dzë gudiꞌdzë rall cumidë gau ra nanadë nápëdiꞌi, perë ra më israelitë naruadiꞌdzë dizë́ griego guzublú guniꞌi rall cuntrë ra më israelitë naruadiꞌdzë dizë́ hebreo. Guniꞌi rall lu ra poshtë, ra viudë naruadiꞌdzë griego adë cuáꞌadiꞌi rall igual ziquë cuaꞌa ra viudë naruadiꞌdzë hebreo. ");
INSERT INTO zacNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Iurní guëzá chiꞌbë chupë poshtë bëtëá raiꞌ grë ra mënë narialdí lduꞌi dizaꞌquë. Guchi raiꞌ lu rall: ―Adë napë naꞌa tiempë parë quiꞌdzë naꞌa cumidë parë ra narquiꞌni cumidë. Más nasac guëdiaꞌa diꞌdzë naꞌa dizaꞌquë shtë Jesús lu ra mënë. Zni rac shtuꞌu më. ");
INSERT INTO zacNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Por ni rniaꞌa lu të, Dadë, gulë gudili gadchi nguiu entrë lëꞌë të. Gulë gudili ra nguiu naná humildë, ra nanapë llgabë zaꞌquë nu ra nguiu nacabezënú Espíritu Santo laꞌni lduꞌu rall; quiꞌdzë rall nagáu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Lëꞌë naꞌa guënaꞌbë naꞌa lu Dios por lëꞌë të nu tsaglaꞌguë guëdiaꞌa diꞌdzë naꞌa dizaꞌquë shtë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Grë rall gurë́ rall de acuerdë. Iurní gudili rall gadchi nguiu parë gunë rall dchiꞌni. Primërë Esteban, nall tubi nguiu con guëdubinú ldúꞌull rialdí ldúꞌull Dios. Cabezë Espíritu Santo laꞌni ldúꞌull. Guaglaꞌguë lë rall: Felipe, Prócoro, Nicanor, Timón, Parmenas nu Nicolás. Nicolás na më guëꞌdchi Antioquía. Adë nall më israelitë perë más antsë gualdí lduꞌi creenci shtë ra më israelitë. ");
INSERT INTO zacNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Lueguë beꞌdë guënú rall ra nguiu rëꞌ lu ra poshtë. Gunaꞌbë raiꞌ lu Dios por lëꞌë rall nu bëdchiꞌbë ra poshtë guiáꞌaiꞌ guëc rall parë bëꞌnë rall recibir dchiꞌni ni. ");
INSERT INTO zacNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Guëdubi guëꞌdchi shtë Jerusalén bërëꞌtsë dizaꞌquë shtë Jesús. Nalë́ guadalë ra narialdí lduꞌi dizaꞌquë. Zihani ra bëshuzi israelitë gualdí lduꞌu raiꞌ dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban nall tubi nguiu nanapë pudërë nu favurë shtë Dios. Dios runë compañi lë́ꞌëll parë rúnëll milagrë nu cusë ruꞌbë lu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Perë bëldá ra nguiu gudildi diꞌdzë con Esteban. Ra nguiu ni zeꞌdë rall de iáduꞌu shtë mënë nalë Esclavos Libertados. Ra nguiu ni guc rall muzë naguzac zi, perë despuësë gupë rall libertá. Bëdchini sëbëldá nguiu de los de másruꞌu lugar cumë ziquë Cirene, Alejandría, Cilicia nu regiuni shtë Asia. Grë ra nguiu rëꞌ gudildi diꞌdzë rall con Esteban, ");
INSERT INTO zacNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","perë adë bë́ꞌnëdiꞌi shtiꞌdzë rall gan lu Esteban purquë Esteban ruadíꞌdziꞌ con llëruꞌbë pudërë nabëdëꞌë Espíritu Santo parë lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Iurë guná rall adë bë́ꞌnëdiꞌi rall gan parë niuadiꞌdzënú rall Esteban, gudilli rall bëldá nguiu mal parë guëniꞌi rall bishi cuntrë Esteban. Guniꞌi rall de quë bini rall cagniꞌi Esteban ra diꞌdzë cuntrë lëy shtë Moisés nu cuntrë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mudë ni bëtsatsu rall ra mënë con ra më gushë nu mësë narluaꞌa lëy. Gunaꞌzi rall Esteban nu biaꞌa rall lë́ꞌiꞌ lu Junta Suprema. ");
INSERT INTO zacNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Gudili rall stubi shcuaꞌa nguiu mal naguëniꞌi bishi cuntrë Esteban. Guniꞌi rall: ―Nguiu rëꞌ siemprë rníꞌill cuntrë iáduꞌu santu shtë́naꞌa nu cuntrë lëy nabëquëꞌë Moisés. ");
INSERT INTO zacNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nu bini naꞌa rniꞌi nguiu rëꞌ, quë Jesús më Nazaret, guëcuell iáduꞌu ruꞌbë; gúnëll cambi custumbrë nabësëaꞌnë Moisés parë lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Iurní ra gubiernë shtë Junta Suprema nu grë ra nazugaꞌa lu juntë, guná rall lu Esteban. Guc cambi lúhiꞌ. Guná rall lúhiꞌ cumë ziquë lu tubi ianglë. ");
INSERT INTO zacNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Iurë zugaꞌa Esteban lu Junta Suprema, jëfë shtë ra bëshuzi gunaꞌbë diꞌdzë lu Esteban zdëꞌë: ―¿Pë gualdí ra nguiu narniꞌi cuntrë lë́ꞌël? ");
INSERT INTO zacNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Con zihani histuri biadiꞌdzë Esteban lu rall: ―Dadë bëchi, gulë bëquë́ diaguë lo quë narniaꞌa lu të. Llëruꞌbë na Dios shtë́naꞌa. Bëluaꞌalú më lu shtadë guëlú hiaꞌa Abraham tsana guquëréldiꞌ regiuni Mesopotamia. Biadiꞌdzënú më Abraham antsë tsana guquëréldiꞌ Harán. ");
INSERT INTO zacNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Repi Dios lu Abraham: “Bësaꞌnë ládzël nu grë ra saꞌl nu bëagzë́ zitu tubi lugar naguëluáꞌahia lë́ꞌël”. ");
INSERT INTO zacNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Iurní bëruꞌu Abraham ládziꞌ nalë Caldea parë guëquëréldiꞌ Harán. Despuësë guti shtadë Abraham, iurní Dios bësheꞌldë lëꞌë Abraham lugar catë dzu hiaꞌa iurneꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Perë Dios adë bëdë́ꞌëdiꞌi ni tubi partë shtë lugar rëꞌ parë nianibëꞌa Abraham ni siquierë tubi ldë guiuꞌu mituꞌnë catë niazubë tubi hiuꞌu lídchiꞌ. Perë Dios bëꞌnë prometer lu Abraham guëdëꞌë më lugar ni parë shíniꞌ despuësë tsana gátiꞌ, perë dzë ni Abraham gáꞌadiꞌi nápiꞌ shíniꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nu guniꞌi Dios lu Abraham ra shíniꞌ natsadalë, guëquëreldë rall ziquë më zitu lugar catë adë na ladzë rall. Por tapë gahiuꞌa izë gac rall muzë nu guëzac zi rall lu dchiꞌni. ");
INSERT INTO zacNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","También guniꞌi Dios lu Abraham: “Na guna cashtigu ra mënë naguëzac zi ra shínil lu dchiꞌni. Despuësë tsana guëruꞌu rall lugar ni, iurní gunë rall adorar na lugar rëꞌ.” Lugar ni dzu hiaꞌa iurneꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dios bëꞌnë prometer lu Abraham de quë grë ra shini Abraham, na rall shmënë Dios. Ziquë tubi lëy parë lëꞌë raiꞌ, gunibëꞌa më gac circuncidar shini Abraham, quiere decir, bëchuguë Abraham duꞌpë guiꞌdi shtënë partë delicadë shtë llguëꞌnë. Dzë Isaac napë tubi llmalë gúlëll, guc circuncidárëll. Isaac bëꞌnë lo mizmë tsana gúpëll shínill, Jacob. Nu zni bëꞌnë Jacob con ra shíniꞌ. Ra shini Jacob bëac rall chiꞌbë chupë nanaguc chiꞌbë chupë grupë shtë naciuni Israel. ");
INSERT INTO zacNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ra shini Jacob naguc ra shtadë guëlú hiaꞌa, gupë rall mbidi José, bëchi raiꞌ. Bëtuuꞌ raiꞌ lëꞌë José. Ra naguziꞌi José biaꞌa lëꞌë José parë Egipto, perë Dios bëꞌnë compañi lë́ꞌiꞌ; ");
INSERT INTO zacNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","adë bësáꞌnëdiꞌi më lë́ꞌiꞌ. Nu bëdëꞌë më llëruꞌbë llgabë parë bëáꞌnëll bien lu rëy Faraón. Nu Faraón bëꞌnë nombrar lëꞌë José ziquë gubernadurë shtë Egipto. José guná grë ra dchiꞌni nagunë ra mënë lidchi Faraón. ");
INSERT INTO zacNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Gudëdë ra izë; bëdchini galzí guëc ra mënë shtë Egipto nu Canaán. Nalë́ bëldiaꞌnë rall lu gubini. Ra shfamili Jacob, ra shtadë guëlú hiaꞌa, adë rdzélëdiꞌi raiꞌ nagáu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Perë bini Jacob de quë nanú dau Egipto, iurní bëshéꞌldiꞌ ra shíniꞌ parë guacaꞌa rall nagáu raiꞌ. Nu bëabrí raiꞌ ladzë raiꞌ. Ndëꞌë primërë viajë shtë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Dzë bërë́ dau shtë raiꞌ, gua rall Egipto stubi vueltë. José bëquebi lu ra bë́chiꞌ chu nall. Nu rëy shtë Egipto bínill ca nezë zeꞌdë José. ");
INSERT INTO zacNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Iurní José bësheꞌldë ra bë́chill parë guaglliꞌi rall Jacob, shtadë rall con grë shfamíliꞌ. Famili rëꞌ na raiꞌ setenta y cinco mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Zni guc con Jacob. Bëagzë́ raiꞌ Egipto con grë shfamíliꞌ. Guquëreldë raiꞌ ndë. Despuësë guti Jacob. Nu ndë guti ra shini Jacob, ra shtadë guëlú hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Iurní biaꞌa raiꞌ baꞌcu shtë ra tëgulë parë lugar nalë Siquem. Ndë bëgaꞌchi ra baꞌcu ni catë guziꞌi Abraham tubi ldë guiuꞌu lachi más antsë lu shini Hamor naquëreldë ra Siquem. ");
INSERT INTO zacNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Dzë ni hia mërë gac cumplir lo quë nabëꞌnë më prometer lu Abraham, bëꞌnë më jurar lu Abraham de quë guëdalë shíniꞌ. Bëac raiꞌ mënë zihani lugar Egipto. ");
INSERT INTO zacNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tiempë ni cagnibëꞌa tubi rëy naciuni Egipto perë adë bëagnádiꞌi ldúꞌull pë bëꞌnë José guahietë. ");
INSERT INTO zacNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mizmë rëy ni bësiguëll shtadë guëlú hiaꞌa. Gunibëꞌa rëy lu ra israelitë parë guëruꞌldë rall shini rall lu nisë parë gati ra meꞌdë. ");
INSERT INTO zacNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Dzë ni gulë Moisés. Guc meꞌdë chulë nu nachaꞌngu meꞌdë delantë lu Dios. Bëꞌnë shtadë meꞌdë gan; gupë raiꞌ lëꞌë meꞌdë tsunë mbehu lídchiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Tsana guagsaꞌnë raiꞌ meꞌdë lu nisë parë niaꞌa pë niac meꞌdë, bëdchini shtsaꞌpë rëy shtë Egipto. Biáꞌall meꞌdë nu gunall meꞌdë cumë ziquë shínill. ");
INSERT INTO zacNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Zdëꞌë mudë bësëꞌdë Moisés grë́tëꞌ studi narac bëꞌa ra më Egipto. Nu gúquëll tubi nguiu de buen llgabë parë ruadíꞌdzëll nu grë ra cusë nalë́ ráquëll. ");
INSERT INTO zacNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Dzë ni napë Moisés cuarenta izë, guagnáhiꞌ ra më ládziꞌ, ra më israelitë naquëreldë tubi lugar shtë Egipto. ");
INSERT INTO zacNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Lugar ni gunáhiꞌ lu mal tratë naquëhunë tubi më Egipto con tubi më israelitë. Moisés guagláhiꞌ më ládziꞌ. Por mal nabëꞌnënú më Egipto, gudini Moisés më Egipto. ");
INSERT INTO zacNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés bë́ꞌniꞌ llgabë ra më ládziꞌ nadëꞌë rall cuendë de quë Dios bësheꞌldë lë́ꞌiꞌ parë guëdë́ꞌëiꞌ libertá lëꞌë rall, perë ra më israelitë adë guasë́diꞌi rall. ");
INSERT INTO zacNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Stubi dzë Moisés bëdiaꞌguëlú chupë më ládziꞌ; cadildi rall. Guaglá Moisés lëꞌë rall nu gúchiꞌ lu ra nacadildi: “Lëꞌë të bëchi saꞌ të. ¿Pëzielú rdildi të?” ");
INSERT INTO zacNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Iurní nacagdëꞌë galnë́ saꞌll, bësínill lëꞌë Moisés; répill: “¿Chull bësheꞌldë lë́ꞌël? ¿Pë zéꞌdël ndëꞌë ziquë narnibëꞌa parë zeꞌdë guë́ꞌnël juzguë lëꞌë naꞌa? ");
INSERT INTO zacNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Pëllë rac shtuꞌu quínil na ziquë gudínil më Egipto naꞌguë?” ");
INSERT INTO zacNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Iurë bini Moisés lo quë naguniꞌi nguiu ni, bëlluꞌnë Moisés. Bëagzëll parë regiuni nalë Madián. Ndë guquëréldëll ziquë më zitu. Bëtsë́ꞌall nu gúpëll chupë shínill. ");
INSERT INTO zacNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Hia guc cuarenta izë guquëréldëll Madián. Dzë ni zull lachi guëllaꞌ dani nalë Sinaí, bëluaꞌalú tubi ianglë lull. Bërúꞌuiꞌ lu beꞌlë catë rëuldë tubi hiaguë. ");
INSERT INTO zacNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés bëdzëguëëꞌ ldúꞌiꞌ; bë́ꞌniꞌ llgabë, pëzielú rëuldë hiaguë rëꞌ. Guabíꞌguëll parë gunall luhin. Bínill voz shtë Dios naguniꞌi: ");
INSERT INTO zacNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nahia Dios shtënë ra shtadë guëlul. Nahia Dios shtë Abraham. Nahia Dios shtë Isaac. Nahia Dios shtë Jacob.” Iurní lëꞌë Moisés guzublú bëdzë́bëll nu bëchíꞌchill. Hia adë gunë́diꞌill niagbíꞌall lu hiaguë catë rruꞌu beꞌlë. ");
INSERT INTO zacNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nu guchi Dios lull: “Gulú rachi guëaꞌl purquë lugar catë nanul na lugar santu purquë na zugáꞌahia ndëꞌë iurneꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Rnahia grë trabaju nardëdë ra shmëna naquëreldë Egipto, nu rquë diaga iurë ruꞌnë rall lua. Por ni iurneꞌ guna librar lëꞌë rall. Guësheꞌlda lë́ꞌël ziquë shmëna hashtë Egipto.” ");
INSERT INTO zacNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Antsë ra israelitë adë bë́ꞌnëdiꞌi rall cuendë lëꞌë Moisés; repi rall: “¿Chu bësheꞌldë lë́ꞌël ziquë jëfë parë zeꞌdë guë́ꞌnël juzguë lëꞌë naꞌa?” Perë Dios bësheꞌldë lë́ꞌiꞌ Egipto. Nu lëꞌë ianglë naguniꞌi lull catë zubë hiaguë narëuldë, bë́ꞌniꞌ compañi lëꞌë Moisés. Gúquiꞌ jëfë parë gualdull më israelitë lugar ni. ");
INSERT INTO zacNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Gua Moisés Egipto parë gualdúhiꞌ ra shtadë guëlú hiaꞌa. Por pudërë shtë Dios bë́ꞌniꞌ milagrë nu cusë ruꞌbë Egipto. Bë́ꞌniꞌ milagrë ruaꞌ Nisëduꞌu Llni. Por cuarenta izë bë́ꞌniꞌ milagrë laꞌni ra dani catë ziaꞌa zu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Lo mizmë Moisés rëꞌ guniꞌi lu ra më israelitë: “Dios guësheꞌldë tubi naguadiꞌdzë shtiꞌdza delantë lu të. Galë më ladi bëchi saꞌ të cumë ziquë bësheꞌldë më na. Gulë tsaldí lduꞌu të grë lo quë naguëniꞌi më lu të.” ");
INSERT INTO zacNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Lëꞌë Moisés ni guzënú lëꞌë ra mënë laꞌni ra dani Sinaí catë guniꞌi ianglë lúhiꞌ antsë. Moisés guquëreldënú ra shtadë guëlú hiaꞌa. Bë́ꞌniꞌ recibir ra dizaꞌquë shtë Dios të guëneꞌe Moisés diꞌdzë ni parë lëꞌë hiaꞌa. Diꞌdzë ni napë pudërë parë siemprë; nunquë adë tsalúdiꞌin. ");
INSERT INTO zacNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Shtadë guëlú hiaꞌa bëzuꞌbë diáguëdiꞌi raiꞌ shtiꞌdzë Moisés. Adë gunë́diꞌi rall nanibëꞌa Moisés lëꞌë rall. Mejurë guc lduꞌu rall nëabrí rall parë Egipto. ");
INSERT INTO zacNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tubi dzë adë zugaꞌanú Moisés lëꞌë rall, repi rall lu Aarón: “Adë guëneꞌe naꞌa rsunë pë cazac Moisés. Adë nídiꞌill ndëꞌë, nu gulull lëꞌë hiaꞌa Egipto; por ni rac shtuꞌu naꞌa iurneꞌ, guntsáꞌul tubi dios naquiblú lu hiaꞌa delantë.” ");
INSERT INTO zacNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Lueguë bëntsaꞌu rall tubi ngunë mituꞌnë de orë. Gudini rall bëldá ma parë bëdëꞌë rall tubi ofrendë lu dzanë narunë rall adorar. Nalë́ bëquitë lduꞌu rall por lo quë nabëntsaꞌu rall con guiaꞌa rall. ");
INSERT INTO zacNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Iurní Dios bëꞌnë intriegu lëꞌë rall parë quëhunë rall adorar ra cusë lu guë́ꞌdchiliu, ziquë ra mbelëguiꞌi nu ngubidzë. Zni naescritë laꞌni librë nabëquëꞌë ra profetë. Rniꞌi librë ni: Lëꞌë të më israelitë, guzë́ të lu dani durantë cuarenta izë. Gudini të ra ma parë bëꞌnë të ofrecer lu dios shtë të, perë ni tubi ma adë bëꞌnë të ofrecer lua con guëdubinú lduꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Beꞌrquë nuaꞌa të nichi shtë Moloc, dios shtë të. Nuaꞌa të tubi mbelëguiꞌi shtë dios Renfán. Ra ídolo rëꞌ bëntsaꞌu të parë runë të adorar. Por ni guëgúa të de ladzë të parë guësheꞌlda lëꞌë të más zitu stubi ladë Babilonia parë tsa të cashtigu. ");
INSERT INTO zacNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Ra shtadë guëlú hiaꞌa tsana guzë́ rall dani, nuaꞌa rall tubi hiuꞌu lari nu tubi nichi catë nutsaꞌu ra lëy nabëquëꞌë Moisés. Hiuꞌu lari guctsáꞌuhin ziquë guniꞌi Dios lu Moisés nu ziquë bëluaꞌa më lúhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ra shtadë guëlú hiaꞌa gupë rall hiuꞌu lari ni por llëduni tiempë ziquë tubi cusë nabësëaꞌnë Dios parë lëꞌë rall. Nu ra mënë nabidë con Josué, nuaꞌa rall hiuꞌu lari rëꞌ tsana bëdchisú rall ra guiuꞌu shtënë stubi ra naciuni. Dios bëꞌnë compañi lëꞌë rall parë guëruꞌu ra mënë lugar ni parë guëuꞌ ra shtadë guëlú hiaꞌa. Ngaꞌli guquëreldë rall hashtë tiempë nagunibëꞌa rëy David. ");
INSERT INTO zacNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios guc shtuꞌu lëꞌë David. Gunaꞌbë David lu Dios niuntsáꞌuiꞌ tubi iáduꞌu catë niaquëreldë Dios verdadërë, mizmë Dios nabëꞌnë Jacob adorar. ");
INSERT INTO zacNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Perë David adë bë́ꞌnëdiꞌiꞌ gan nazaꞌa tubi iáduꞌu lidchi Dios, perë shínill Salomón, sí, bë́ꞌnëll gan; bëzáꞌaiꞌ iáduꞌu lidchi Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Perë Dios nacabezë gubeꞌe cumë llëruꞌbë na më, adë quëréldëdiꞌi më laꞌni iáduꞌu narzaꞌa ra nguiu. Ziquë guniꞌi profetë shtiꞌdzë Dios narniꞌi: ");
INSERT INTO zacNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Gubeꞌe cabeza, nu rnibë́ꞌahia guëdubi guë́ꞌdchiliu. Guë́ꞌdchiliu na ziquë tubi bangu catë rzu guëahia. ¿Pëllë clasë iáduꞌu guntsaꞌu të parë guëbeza laꞌni? Adë rquíꞌnidiaꞌa lugar catë guëziꞌi lduaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Na bëntsaꞌua grë cusë rëꞌ lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Lëꞌë të de por si naguëdchi lduꞌu të nu adë rínidiꞌi të shtiꞌdzë Dios. Na të cumë ziquë ra mënë nadë guënë́diꞌi Dios. Siemprë quëhunë të cuntrë Espíritu Santo. Na të ziquë guc ra shtadë guëlú hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ra shtadë guëlú hiaꞌa, bëdëꞌë rall hiaguë grë ra nabiadiꞌdzë shtiꞌdzë Dios guahietë. Ni túbiꞌ adë chu bídëdiꞌi sin quë adë niadëꞌë hiaguë guëc raiꞌ. Ra shtadë guëlú hiaꞌa, gudini rall profetë nabiadiꞌdzë de quë guëdchini stubi nguiu naná tubldí shcuéndiꞌ lu Dios. Iurná bidë më perë lëꞌë të bëꞌnë të intriegu lëꞌë më lu guiaꞌa më rumanë nu gudini të lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Lëꞌë të bëꞌnë të recibir lëy shtë Dios nabidënú ra ianglë, perë adë bëzuꞌbë diáguëdiꞌi të diꞌdzë ni. ");
INSERT INTO zacNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Iurë gualú bini rall grë ra cusë naguniꞌi Esteban, nalë́ bëldë́ rall hashtë rchushí laiꞌ rall; rna rall lu Esteban. ");
INSERT INTO zacNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Perë cabezënú Espíritu Santo laꞌni lduꞌu Esteban. Bëldísiꞌ lúhiꞌ lu gubeꞌe; gunáhiꞌ lu gluri shtë Dios catë cabezë më. Nu gunáhiꞌ lu Jesús nacabezë ladë ldi shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Guniꞌi Esteban: ―Gulë guná, rnahia gubeꞌe llaꞌlë. Rnahia lu Jesús, nguiu nabësheꞌldë Dios lu guë́ꞌdchiliu. Cabezë më ladë ldi shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Perë grë rall bësëꞌau rall diaguë rall. Gurushtiá rall nu zeꞌdë guëlluꞌnë rall parë quini rall Esteban. ");
INSERT INTO zacNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Gulú rall Esteban fuërë ruaꞌ guëꞌdchi. Ndë bëdëꞌë guëꞌë rall Esteban parë gátiꞌ. Ra nabini shtiꞌdzë Esteban, gulú rall shabë rall nu guatishi rall shabë rall lu tubi nguiu nalë Saulo. ");
INSERT INTO zacNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Iurë bëdëꞌë guëꞌë rall Esteban, quëadiꞌdzënúhiꞌ Jesús. Gunáꞌbëiꞌ lëꞌë më; guníꞌiꞌ: ―Dadë Jesús, bëꞌnë recibir espíritu shtëna. ");
INSERT INTO zacNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Despuësë iurní bëzullibi Esteban nu fuertë guníꞌiꞌ lu Dios nacabezë gubeꞌe: ―Adë rtiáꞌadiꞌil culpë duldë shtë rall. Iurë gualú guniꞌi Esteban diꞌdzë ni, gútiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo guꞌ de acuerdë tsana gudini rall Esteban. Mizmë dzë ni guzublú guzunaldë mënë grë ra narialdí lduꞌi dizaꞌquë ciudá Jerusalén. Grë ra shmënë Jesús bërëꞌtsë rall; gua nagunaꞌzi nezë regiuni shtë Judea nu gunaꞌzi raiꞌ nezë Samaria, perë ra poshtë bëaꞌnë raiꞌ Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bëldá nguiu zaꞌquë bëcaꞌchi rall lëꞌë Esteban nu nalë́ biꞌni rall por lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Perë Saulo adë bëgáꞌadiꞌi ldúꞌull ra mënë narialdí lduꞌi dizaꞌquë. Riutëll hiuꞌu por hiuꞌu parë rgull ra mënë, naꞌa la nguiu. Rshaguiull ra prubi parë riagsëáꞌnëll mënë lachiguiꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ra nabëruꞌu Jerusalén cualquier nezë ziaꞌa rall, rniꞌi rall dizaꞌquë shtë Jesús lu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe gua tubi guëꞌdchi shtë Samaria. Ndë guzublú guníꞌill lu ra mënë chu na Jesucristo. ");
INSERT INTO zacNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bëdëá mënë zihani parë rquë diaguë rall bien grë ra diꞌdzë naguniꞌi Felipe. Nu rna rall lu milagrë nabëꞌnë Felipe. ");
INSERT INTO zacNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Zihani mënë narac lluꞌu, bëac rall. Gulú Felipe mëdzabë laꞌni lduꞌu ra nanapë mëdzabë. Nalë́ gurushtiá ra mëdzabë iurë bëruꞌu rall. Zihani cujë nu mënë narac galguidzë llunguë, bëac rall. ");
INSERT INTO zacNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nalë́ bëquitë lduꞌu ra mënë grë nabëꞌnë Felipe ciudá ni. ");
INSERT INTO zacNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ndë guquëreldë tubi nguiu nalë Simón. Rac rquëꞌë bëlliull. Zdëꞌë mudë bësiguëll ra mënë shtë Samaria. Bëdzëguëëꞌ lduꞌu rall iurë rna rall narunë Simón. Rníꞌill de quë lë́ꞌëll nall tubi më nalasac. ");
INSERT INTO zacNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Grë ra mënë dizdë ra më ruꞌbë hashtë más nabiꞌchi, bëquë́ diaguë rall pë rniꞌi Simón. Guniꞌi rall lë́ꞌëll nall më ruꞌbë nabësheꞌldë Dios lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Gualdí lduꞌu rall lëꞌë Simón por magi nabë́ꞌnëll. Llëduni tiempë bësiguëll ra mënë ");
INSERT INTO zacNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","perë zihani mënë gualdí lduꞌu rall dizaꞌquë naguniꞌi Felipe. Ruadiꞌdzë Felipe mudë tsutë́ mënë nezë lu gubeꞌe parë tsa rall catë rnibëꞌa Dios. Por Jesús gac salvar mieti, guniꞌi Felipe nu bëchuꞌbë nísiꞌ naꞌa la nguiu, ra nagualdí lduꞌi dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Mizmë Simón bëriubë nísëll purquë gualdí ldúꞌull dizaꞌquë nu guanáldëll lëꞌë Felipe. Nalë́ bëdzëguëëꞌ ldúꞌull; gunall milagrë nu sëñi ruꞌbë nabëꞌnë Felipe. ");
INSERT INTO zacNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bini ra poshtë nabëaꞌnë Jerusalén, ra mënë Samaria gualdí lduꞌu rall dizaꞌquë. Iurní bësheꞌldë raiꞌ Pedro nu Juan parë ziaꞌa raiꞌ Samaria. ");
INSERT INTO zacNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bëdchini Pedro nu Juan guëꞌdchi ni; gunaꞌbë raiꞌ lu Dios parë guëdëꞌë më Espíritu Santo parë cuezënúhiꞌ grë ra më Samaria nagualdí lduꞌi dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ra nagualdí lduꞌi dizaꞌquë todavía adë bë́ꞌnëdiꞌi rall recibir Espíritu Santo laꞌni lduꞌu rall. Más antsë tsana bëriubë nisë rall, ra nabëchuꞌbë nisë lëꞌë rall, gunaꞌbë rall niétiquë lë shtë Dadë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Iurní Pedro nu Juan bëdchiꞌbë guiaꞌa raiꞌ guëc ra mënë ni. Lueguë bëdchini Espíritu Santo parë gulezënúhiꞌ lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Iurë guná Simón bëdchiꞌbë poshtë guiaꞌa raiꞌ guëc ra mënë nu gunall bëdchini Espíritu Santo parë cuezënúhiꞌ lëꞌë rall, Simón bë́ꞌnëll ofrecërë dumí. ");
INSERT INTO zacNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Répill lu ra poshtë: ―Gulë bëtuuꞌ duꞌpë pudërë nanapë të parë guna ziquë runë të, të iurë guëdchiꞌba guiahia guëc ra mënë, gunë rall recibir Espíritu Santo. ");
INSERT INTO zacNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Repi Pedro lull: ―Dios guënitilú lë́ꞌël con grë shtumil. ¿Pëllë lluáꞌal síꞌil con dumí lo quë narzëlaaꞌchi Dios caꞌa mënë? ");
INSERT INTO zacNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Adë nápël derechë con lëꞌë naꞌa purquë bë́ꞌnël duldë laꞌni ldúꞌul. Zuldídiꞌi shcuéndël delantë lu më. ");
INSERT INTO zacNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Bësaꞌnë llgabë mal shtë́nël; bëagrí ldúꞌul con Dios; gunaꞌbë lu më të gunë më perdunë lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gadzë́ duldë laꞌni ldúꞌul; nal ziquë nanú bajo ordë shtë Satanás. ");
INSERT INTO zacNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Iurní guchi Simón lu poshtë: ―Gulë gunaꞌbë lu Dios por na të parë adë guëzac zídiꞌi më na ziquë guniꞌi të. ");
INSERT INTO zacNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ra poshtë guniꞌi raiꞌ lu mënë Samaria ra cusë naguná rall nu biadiꞌdzë raiꞌ dizaꞌquë lu ra mënë. Iurní bëruꞌu raiꞌ parë gua raiꞌ los de más guëꞌdchi shtë Samaria. Guagniꞌi raiꞌ dizaꞌquë; despuësë bëagrí raiꞌ parë Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Dzë ni repi tubi ianglë lu Felipe: ―Bëꞌnë preparar të tsal tubi nezë narëaꞌnë ladë sur, nezë naziaꞌa de Jerusalén parë guëꞌdchi nalë Gaza. Nezë rëꞌ rdëdë catë nídiꞌi mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Lueguë bëruꞌu Felipe. Ziáꞌaiꞌ; perë nezë naziáꞌaiꞌ, bëdiaꞌguëlúhiꞌ tubi nguiu më Etiopía. Nádiꞌill nguiu completë nu nall tesorërë shtë Candace, tubi naꞌa narnibëꞌa naciuni Etiopía. Lëꞌë tesorërë guall Jerusalén parë guaguë́ꞌnëll adorar Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Zëagzëll parë ládzëll. Zúbëll lu guërredë shtëll. Quëúꞌldëll laꞌni tubi librë nabëquëꞌë Isaías. ");
INSERT INTO zacNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Iurní repi Espíritu Santo lu Felipe: ―Guabiꞌguë culaꞌni guërredë shtënë më Etiopía. ");
INSERT INTO zacNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Iurë guabiꞌguë Felipe culaꞌni guërredë, bíniꞌ quëuꞌldë nguiu ni laꞌni librë shtë Isaías. Felipe gunaꞌbë diꞌdzë lull: ―¿Gu riasël lo quë nacagniꞌi laꞌni librë? ");
INSERT INTO zacNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nguiu ni repi lu Felipe: ―Adë riasë́diaꞌa purquë adë nápëdiaꞌa chu guëniꞌi pë runë cuntienë ni. Iurní répill lu Felipe të tsepi Felipe nu subë Felipe laꞌni shguërrédëll. ");
INSERT INTO zacNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Laꞌni librë catë quëuꞌldë më Etiopía lëꞌë partë ni cagniꞌi: Biaꞌa rall nguiu parë gátiꞌ ziquë lliꞌli, nu ziquë rëaꞌnë lliꞌli ziquë guꞌpë delantë lu ra narnaꞌzi, zni bëaꞌnë nguiu rëꞌ. Adë bëlláꞌlëdiꞌi ruaꞌll parë niaruꞌu tubi diꞌdzë. ");
INSERT INTO zacNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Dzë ni gunaꞌzi ra mënë lë́ꞌëll, bëꞌnë rall condenar lëꞌë nguiu ni sin ni tubi causë. Adë pë jushtisi bëꞌnë rall. Nalë́ fier bëꞌnë rall tratë nguiu ni. Bëdchisú rall vidë shtë́nëll. ");
INSERT INTO zacNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Iurní më Etiopía gunaꞌbë diꞌdzë lu Felipe: ―Bëꞌnë favurë guniꞌi lua, ¿chu guzac zdëꞌë? ¿Pë lu mizmë lë́ꞌëll rníꞌill u nu chu stubi guzac zdëꞌë? ");
INSERT INTO zacNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Iurní Felipe guzublú guníꞌiꞌ pë runë cuntienë partë catë biꞌldi më Etiopía laꞌni librë. Guniꞌi Felipe ra dizaꞌquë shtë Jesús nu lla gac salvárëll. ");
INSERT INTO zacNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Iurë ziadëdë rall tubi lugar catë rë nisë, gunaꞌbë diꞌdzë më Etiopía lu Felipe: ―Ndëꞌë rë nisë. ¿Pë adë gac chubë nisa ndëꞌë? ");
INSERT INTO zacNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe repi lull: ―Si talë guëdubinú ldúꞌul rialdí ldúꞌul shtiꞌdzë Jesús, zac chubë nísël ndëꞌë. Iurní repi nguiu ni: ―Rialdí lduaꞌa niétiquë Jesucristo na shini Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Gunibëꞌa nguiu parë guzudchí guërredë parë bietë raiꞌ. Iurní guatë́ raiꞌ laꞌni nisë. Bëchuꞌbë nisë Felipe lë́ꞌëll ndë. ");
INSERT INTO zacNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Iurë bëruꞌu rall ruaꞌ nisë, Espíritu Santo biaꞌa lëꞌë Felipe. Lëꞌë nguiu nilli guꞌ ldúꞌull nu rquitë ldúꞌull. Guagláꞌguëll shnézëll. ");
INSERT INTO zacNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Bëdchini Felipe guëꞌdchi nalë Azoto, nu gudë́dëiꞌ guëꞌdchi por guëꞌdchi. Cagluáꞌaiꞌ mënë dizaꞌquë hashtë bëdchíniꞌ guëꞌdchi nalë Cesarea. ");
INSERT INTO zacNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo guaglaꞌguë bëꞌnë nalaaꞌdchill; guc ldúꞌull quínill ra mënë narialdí lduꞌi dizaꞌquë. Por ni guagnall jëfë shtë ra bëshuzi ");
INSERT INTO zacNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","parë gunë rall firmar tubi guichi parë ziaꞌa Saulo. Guziáꞌall ra iáduꞌu shtë më israelitë guëꞌdchi Damasco. Ndë tsatílill ra naꞌa nu nguiu nacanaldë tëchi dizaꞌquë shtë Jesús. Gueꞌdënull ra mënë ni; guëldáguëll lëꞌë raiꞌ lachiguiꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Guc iurë ziaꞌa zull nezë, hia mërë guëdchínill guëꞌdchi Damasco, nasesë bëdchini tubi llni nezë lu gubeꞌe. Guꞌtë llni lu nezë catë ziáꞌall. ");
INSERT INTO zacNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulo gulaguë lu guiuꞌu; gunall lu llni nu bínill tubi bë naguniꞌi: ―Saulo, Saulo, ¿pëzielú rzunáldël na? ");
INSERT INTO zacNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Iurní gunaꞌbë diꞌdzë Saulo: ―¿Chu lë́ꞌël? Dadë, rníꞌil lua zniꞌi. Iurní bë guniꞌi: ―Nahia Jesús. Rzunáldël shmëna parë quinil. ¿Pë adë rac bë́ꞌal lo mizmë na rzunáldël? Adë guëlluíꞌidiꞌi lo quë naquëhúnël. Quëhúnël ziquë runë ngunë narldaꞌa patadë lu garrudchi. Zni quëhúnël. ");
INSERT INTO zacNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Iurní nalë́ bëdzëbë Saulo nu bëchíꞌchill. Répill: ―Dadë, ¿guadë narac shtúꞌul guna? Perë lëꞌë bë guniꞌi: ―Guashtë́ ngaꞌli nu gutë́ ladi guëꞌdchi. Ndë guëniꞌi mënë lul pë gúnël. ");
INSERT INTO zacNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ra nguiu nazënú lëꞌë Saulo, bëaꞌnë rall ziquë guꞌpë tantë bëdzëbë rall purquë bini rall bë nacagniꞌi lu Saulo, perë ni tubi adë chu gunádiꞌi rall. ");
INSERT INTO zacNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Iurní Saulo guashtë́ lu guiuꞌu, perë iurë bësháꞌlëll slull, hiadë gúquëdiꞌi nianall. Bëáꞌnëll ciegu. Ra nguiu nazënúhiꞌ, gunaꞌzi rall guiáꞌaiꞌ parë guc bëdchíniꞌ guëꞌdchi Damasco. ");
INSERT INTO zacNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ndë bëáꞌniꞌ tsunë dzë; adë gúquëdiꞌi nianáhiꞌ. Adë gudáudiꞌiꞌ nu adë pë biiꞌdiꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Guëꞌdchi Damasco quëreldë tubi nguiu nalë Ananías. Rialdí ldúꞌull shtiꞌdzë Jesús. Bëluaꞌalú Jesús lull nu repi më lull: ―Ananías. Bëquebi Ananías lueguë: ―Lëꞌë na ndëꞌë, Dadë. ");
INSERT INTO zacNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jesús repi lull iurní: ―Guashtë́ ngaꞌli nu gua lidchi Judas naquëreldë nezë nalë Nezë Ldi. Gunaꞌbë diꞌdzë por tubi nguiu më Tarso. Lëll Saulo. Ndë quëadiꞌdzënull Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Lu Saulo bëluaꞌalú tubi nguiu lë Ananías. Nguiu ni lë́ꞌël. Gunall guatël parë guëdchiꞌbë guiáꞌal guë́quëll të parë guëac slull nu guëná Saulo stubi vueltë ziquë nall antsë. ");
INSERT INTO zacNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Iurní bini Ananías naguniꞌi Jesús, repi Ananías lu më: ―Perë Dadë, zihani mënë rniꞌi lua shcuendë nguiu rëꞌ. Nablac fier quëhúnëll Jerusalén con ra mënë narialdí lduꞌi shtíꞌdzël. ");
INSERT INTO zacNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Iurneꞌ zéꞌdëll ndëꞌë con guichi nabëdëꞌë ra jëfë shtë bëshuzi parë guáꞌall prësi grë ra mënë narunë adorar lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Perë Jesús repi lu Ananías: ―Guasë purquë na gudilia nguiu rëꞌ parë guëníꞌill dizaꞌquë delantë lu ra mënë shtë stubi naciuni nu lu ra rëy shtë rall. Nu tsagníꞌill dizaꞌquë shtëna lu ra më israelitë. ");
INSERT INTO zacNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na guëluáꞌahia lë́ꞌëll nu guëniaꞌa lull grë cusë mal nagunënú mënë cuntrë lë́ꞌëll purquë nall shmëna. ");
INSERT INTO zacNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Iurní lëꞌë Ananías ziaꞌa lidchi Judas catë quëreldë Saulo. Guatëll nu bëdchiꞌbë guiáꞌall guëc Saulo. Répill: ―Bëchi Saulo, lëꞌë Jesús naguniꞌi lul nezë nazéꞌdël, bësheꞌldë më na ndëꞌë parë gac guënal stubi vueltë nu parë guëdchini Espíritu Santo të cuezënúhiꞌ lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Lueguë iurní bëllaꞌlë slu Saulo. Gunáhiꞌ nu bíniꞌ gulaguë cumë ziquë tubi guiꞌlli laꞌni slúhiꞌ. Saulo guasuldí nu bëriubë nísiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Despuësë gudáuhiꞌ nu bëuꞌ fuersë shtë́hiꞌ stubi vueltë. Bëáꞌniꞌ bëldá dzë Damasco con ra narialdí lduꞌi dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Lueguë guzublú guniꞌi Saulo dizaꞌquë shtë Jesús lu ra mënë laꞌni iáduꞌu shtë ra israelitë. Guníꞌill lu mënë, Jesús náhiꞌ shini Dios nabidë lu guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Grë ra mënë nabëquë́ diaguë shtiꞌdzë Saulo, bëdzëguëëꞌ lduꞌu rall nu guniꞌi lu saꞌ rall: ―Perë nguiu rëꞌ na el quë naguzunaldë ra mënë Jerusalén, ra narialdí lduꞌi dizaꞌquë. Nu lo mizmë lë́ꞌëll zéꞌdëll ndëꞌë parë guáꞌall prësi ra shmënë më parë tsagsáꞌnëll lëꞌë rall lu ra jëfë shtë bëshuzi. ");
INSERT INTO zacNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Perë Saulo biadíꞌdzëll lu ra mënë con más llni; adë bëdzë́bëdiꞌiꞌ. Guníꞌiꞌ de quë Jesús na Cristo nabësheꞌldë Dios. Bëꞌnë Dios compañi lëꞌë Saulo. Ra israelitë naquëreldë Damasco, bëaꞌnë rall sin ni tubi diꞌdzë purquë adë bëdzélëdiꞌi rall pë nianiꞌi rall. ");
INSERT INTO zacNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Gudëdë zihani dzë; iurní ra më israelitë gurë́ rall de acuerdë parë quini rall lëꞌë Saulo. ");
INSERT INTO zacNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Lueguë bini Saulo pë llgabë quëhunë rall. Dzë la gueꞌlë rbezë rall Saulo ruaꞌ puertë salidë shtë ciudá parë quini rall Saulo. ");
INSERT INTO zacNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ra shmënë Jesús bëtiaꞌa rall Saulo laꞌni tubi rëguelë parë iurë guꞌ gueꞌlë, bëldaguë rall Saulo stubi tëchi luꞌ. Luꞌ ni nahin ziquë tubi luꞌ bësuꞌu nasëꞌau alrededurë ciudá. Zni mudë gulaꞌa Saulo lu galguti. ");
INSERT INTO zacNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Iurë bëdchini Saulo Jerusalén, guc ldúꞌiꞌ niagdzáꞌguiꞌ ladi ra shmënë Jesús perë grë rall rdzëbë rall Saulo purquë gáꞌadiꞌi tsaldí lduꞌu rall de quë Saulo hia bëabrí ldúꞌull, de quë bëáquëll shmënë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Perë Bernabé guagsëáꞌnëll Saulo lu ra poshtë. Biadíꞌdzëll lla guniꞌi Saulo lu ra mënë Damasco, de quë Saulo biadíꞌdzëll con guëdubinú ldúꞌull ziquë tubi muzë shtë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Iurní Saulo bëáꞌniꞌ Jerusalén parë quëhúniꞌ dchiꞌni con ra poshtë. Guadiꞌdzënúhiꞌ dizaꞌquë hiuꞌu por hiuꞌu sin adë pë nádiꞌi. ");
INSERT INTO zacNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Con guëdubinú ldúꞌiꞌ ruadíꞌdziꞌ ziquë muzë shtë Jesús. Biadiꞌdzënúhiꞌ con ra më israelitë naruadiꞌdzë dizë́ griego. Perë ra mënë gudili rall mudë parë quini rall Saulo. ");
INSERT INTO zacNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ra mënë narialdí lduꞌi dizaꞌquë, guc bëꞌa rall de quë ra më israelitë zunaldë rall lëꞌë Saulo. Iurní biaꞌa rall lëꞌë Saulo parë guëꞌdchi Tarso. ");
INSERT INTO zacNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Dzë ni grë ra mënë narialdí lduꞌi dizaꞌquë, ra narëtaꞌ regiuni Judea nu Galilea nu Samaria, nalë́ rbedchí lduꞌu rall. Másruꞌu guc shtuꞌu rall lëꞌë Jesús nu rzuꞌbë diaguë rall shtiꞌdzë më. Nu Espíritu Santo bëꞌnë compañi lëꞌë rall parë guaruꞌbë grupë shtë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Canzë́ Pedro; quëhúniꞌ visitar grë ra naná shmënë Jesús. Gudëdë guagnáhiꞌ ra narianaldë nezë santu shtë Jesús, ra naquëreldë tubi guëꞌdchi nalë Lida. ");
INSERT INTO zacNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ndë nanú tubi nguiu nalë Eneas. Hia guc shunë izë ráquëll galguidzë llunguë. Nagáꞌall; adë ráquëdiꞌi rzëll. ");
INSERT INTO zacNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro bëdchini lu Eneas nu guchi Pedro: ―Eneas, Jesucristo gunëac lë́ꞌël. Guashtë́ ngaꞌli nu bëldisë shtaaꞌl. Lueguë lueguë guashtë́ Eneas. ");
INSERT INTO zacNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Grë ra naquëreldë guëꞌdchi Lida nu grë ra naquëreldë guëꞌdchi Sarón, guná rall lla bëac nguiu ni. Lueguë bësaꞌnë rall custumbrë guahietë shtë rall parë guanaldë rall nezë zaꞌquë shtë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tiempë ni nanú tubi naꞌa guëꞌdchi shtë Jope. Rialdí lduꞌi dizaꞌquë shtë Jesús. Lëll Tabita perë ra mënë naruadiꞌdzë dizë́ griego, rniꞌi rall lë naꞌa ni Dorcas. Dorcas bëꞌnë bien nu bëdë́ꞌëll guꞌnë cuaꞌa ra prubi. Bë́ꞌnëll zihani cusë zaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Bëdchini tubi dzë, guc lluꞌu Dorcas nu gútill. Custumbrë shtë ra mënë ni na rguibi rall cuerpë shtë ra tëgulë. Gudibi rall shcuerpë Dorcas nu bëcueꞌzë rall cuerpë guiaꞌa laꞌni hiuꞌu guërupë pisë. ");
INSERT INTO zacNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Guëꞌdchi Jope rëaꞌnë guëllaꞌ guëꞌdchi shtë Lida catë nanú Pedro. Bini ra më Jope nanú Pedro guëꞌdchi Lida. Iurní bësheꞌldë rall chupë nguiu parë guagniꞌi rall lu Pedro: ―Guërrë́ cha guiá hiaꞌa guëꞌdchi Jope. ");
INSERT INTO zacNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Lueguë bëruꞌu Pedro con lëꞌë ra nguiu ni. Iurë bëdchini rall Jope, biaꞌa rall Pedro cuartë catë nagaꞌa tëgulë. Nalë́ ruꞌnë ra viudë nabëdëá ngaꞌli. Bëluaꞌa rall vestidë nu manguë nabëntsaꞌu Dorcas tsana gubániꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Lueguë Pedro gunibëꞌa guëruꞌu grë ra mënë laꞌni cuartë. Iurní bëzullibi Pedro nu biadiꞌdzënúhiꞌ Dios. Rbíꞌaiꞌ lu naguti nu répiꞌ lúhiꞌ: ―Tabita, guashtë́ ngaꞌli. Lueguë lëꞌë tëgulë bëllaꞌlë slúhiꞌ; gunáhiꞌ lu Pedro. Guzubë ldiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro gunaꞌzi guiáꞌall parë guasuldill. Lueguë gunaꞌbë Pedro ra viudë nu los de más narialdí lduꞌi Jesús parë bë́ꞌniꞌ presentar lëꞌë Dorcas nagubani. ");
INSERT INTO zacNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Grë mënë shtë ciudá Jope bini rall milagrë nabëꞌnë Pedro. Nalë́ zihani mënë gualdí lduꞌu raiꞌ dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Por zihani dzë bëaꞌnë Pedro ciudá Jope lidchi tubi curtidor shtë guiꞌdi ladi ngunë. Lëll Simón. ");
INSERT INTO zacNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Guꞌ tubi nguiu ciudá Cesarea; lëll Cornelio. Nall capitán narnibëꞌa tubi gahiuꞌa suldadë. Ra suldadë ni lë rall Italiano. ");
INSERT INTO zacNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelio con grë shfamílill runë rall adorar Dios guëdubinú lduꞌu rall. Adë nádiꞌi Cornelio më israelitë perë bëdë́ꞌëll zihani dumí. Bë́ꞌnëll ayudë ra më israelitë. Siemprë ruadiꞌdzënull Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tubi dzë quierë rquë tsunë guadzeꞌ, bëluaꞌalú tubi ianglë lu Cornelio. Clarë gunall tubi ianglë shtë Dios naguatë́ catë zugaꞌa Cornelio. Repi ianglë lull: ―Cornelio. ");
INSERT INTO zacNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Gubiꞌa Cornelio lu ianglë nu nalë́ bëdzë́bëll. Gunaꞌbë díꞌdzëll lu ianglë: ―¿Pë rac shtúꞌul guna? Iurní repi ianglë lull: ―Dios bëquë́ diaguë ra diꞌdzë shtë́nël iurë ruadiꞌdzënul më nu rëagná lduꞌu më lë́ꞌël purquë bë́ꞌnël ayudë ra prubi. ");
INSERT INTO zacNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Bësheꞌldë bëldá nguiu guëꞌdchi Jope parë tsaglliꞌi rall Simón, nu lëll Pedro; chupë lëll. ");
INSERT INTO zacNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Quëreldë Pedro lidchi tubi curtidurë nalë zac Simón. Nápëll lídchill ruaꞌ nisëduꞌu. Pedro guëniꞌi lul pë gúnël. ");
INSERT INTO zacNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Iurë gubiꞌ ianglë, gunaꞌbë Cornelio chupë shmúzëll con tubi suldadë nananë́ Cornelio. Suldadë ni gualdí lduꞌi shtiꞌdzë Jesús. Guëzá rall na rall muzë shtë Cornelio. ");
INSERT INTO zacNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Biadiꞌdzë Cornelio lu rall lla biadiꞌdzënull ianglë. Iurní bësheꞌldë Cornelio lëꞌë rall parë ziaglliꞌi rall Pedro. ");
INSERT INTO zacNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Stubi dzë quierë guëruldë dzë, ziagdchini rall ciudá Jope. Lo mizmë iurë Pedro beꞌpi guëc hiuꞌu të guadiꞌdzënúhiꞌ Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nalë́ rldiꞌanë Pedro; rac shtúꞌuiꞌ gáuhiꞌ. Perë mientras quëhunë ra shfamili Pedro preparar cumidë, Pedro gunall bëdchini tubi cusë shtë Dios lull. ");
INSERT INTO zacNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Guná Pedro bëllaꞌlë lu gubeꞌe nu gunall lu ziquë tubi lari naquichi ruꞌbë. Zeꞌdin ca zu Pedro. Liꞌbi guëzá shquini. ");
INSERT INTO zacNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Laꞌni lari nanú grë clasë ra ma nanapë tapë guëáhiꞌ nu ra ma narllaꞌ lduꞌi lu guiuꞌu nu ra ma nariasë. ");
INSERT INTO zacNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Iurní bini Pedro tubi bë naguniꞌi: ―Pedro, guasuldí nu gudini ma gaul. ");
INSERT INTO zacNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Perë Pedro guchi: ―Dadë, nunquë adë ráudiaꞌa ra ma naná providë según ra custumbrë shtë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Lëꞌë bë guniꞌi lu Pedro stubi vueltë: ―Lo quë nabëzunë́ Dios, limpi nahin; adë rníꞌidiꞌil nahin mal parë lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Zni guc tsunë vësë; iurní beꞌpi lari lu gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Quëhunë Pedro llgabë pë runë cuntienë nagunall iurë lëꞌë ra nguiu nabësheꞌldë Cornelio zeꞌdë guënaꞌbë diꞌdzë rall ca na lidchi curtidurë nalë Simón. ");
INSERT INTO zacNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bëdchini rall ruaꞌ lidchi Simón; fuertë canaꞌbë rall: ―¿Gu quëreldë tubi nguiu ndëꞌë nalë Simón Pedro? ");
INSERT INTO zacNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro nianá zúbëll guiaꞌa guëc hiuꞌu. Quëhúnëll llgabë niaꞌa pë runë cuntienë lo quë nabësheꞌldë Dios lull. Iurní repi Espíritu Santo lull: ―Pedro guná, tsunë nguiu cagnaꞌbë rall lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Bietë; bëꞌnë compañi lëꞌë rall. Adë pë llgabë rúnëdiꞌil purquë na bësheꞌlda lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Iurë bietë Pedro, guagnall ra nguiu nabësheꞌldë Cornelio. Répill lu ra nguiu: ―Na lëa Pedro nacaguili të. ¿Pë rsunë nuaꞌa të? ");
INSERT INTO zacNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Repi rall lu Pedro: ―Zëꞌpë naꞌa purquë bësheꞌldë Cornelio lëꞌë naꞌa parë sël con lëꞌë naꞌa lídchill. Cornelio nall tubi nguiu honradë nu rialdí ldúꞌull Dios. Nalë́ rac shtuꞌu më israelitë lë́ꞌëll. Tubi ianglë shtë Dios guniꞌi lu Cornelio parë bëshéꞌldëll lëꞌë naꞌa nu guniꞌi ianglë lull lë́ꞌël guëníꞌil lu Cornelio pë gúnëll. ");
INSERT INTO zacNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Iurní Pedro guniꞌi lu rall: ―Gulë tsutë́ ndëꞌë; gulë bëaꞌnë ne gueꞌlë. Hia brëgueꞌlë bëruꞌunú Pedro lëꞌë rall parë ziaꞌa rall lidchi Cornelio. Nu guanaldë bëldá narialdí lduꞌi dizaꞌquë naquëreldë guëꞌdchi Jope. ");
INSERT INTO zacNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Stubi dzë bëdchini rall ciudá Cesarea. Ndë cabezë Cornelio lëꞌë rall con grë shfamílill. También gunaꞌbë Cornelio bëldá amigu shtëll. ");
INSERT INTO zacNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Iurë bëdchini Pedro lidchi Cornelio, Cornelio bëruꞌu; bë́ꞌnëll saludar lëꞌë Pedro nu bëzullíbill lu Pedro parë bë́ꞌnëll adorar Pedro. ");
INSERT INTO zacNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Perë Pedro gunaꞌzi guiaꞌa Cornelio; répiꞌ: ―Guzuldí purquë adë guzáꞌquëdiꞌi rzullíbil lua purquë nahia nguiu ziquë lë́ꞌël. ");
INSERT INTO zacNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Mientras ziazú rall quëadiꞌdzë rall, guatë́ Pedro lidchi Cornelio. Guná Pedro zihani mënë rë. ");
INSERT INTO zacNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Guniꞌi Pedro lu ra mënë: ―Lëꞌë të bien nanë́ të lla na creenci shtë ra më israelitë. Providë guëdzaꞌguë ra më israelitë con mënë de stubi naciuni. Adë nápëdiꞌi rall permisi parë tsutë́ rall lidchi mënë zitu, perë bëluaꞌa Dios na adë tsagláꞌguëdiaꞌa creenci ni. Grë ra nguiu nabëzunë́ Dios, limpi na rall. Adë naprovidë parë tsutë́a lidchi rall. Bëluaꞌa Dios na de quë adë guëníꞌidiaꞌa sulë mënë israelitë na rall allegadë lu Dios, de quë mënë zitu na rall condenadë. ");
INSERT INTO zacNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Por ni zíquësë gunaꞌbë të na, lueguë zelda; adë bë́ꞌnëdiaꞌa negar. Gulë guniꞌi lua niaꞌa pë rac shtuꞌu të. ");
INSERT INTO zacNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Iurní guzublú biadiꞌdzë Cornelio lu Pedro: ―Guc tapë dzë neꞌ; lo mizmë iurë ziquë iurní, rquë tsunë guadzeꞌ quërelda; quëhuna ayunë nu quëhuna orar lu Dios. De repëntë gunahia tubi ianglë shtë Dios. Nalë́ rcabniꞌi lari naquichi. ");
INSERT INTO zacNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Guniꞌi ianglë lëa: “Cornelio, Dios bëquë́ diaguë ra diꞌdzë shtë́nël iurë rnáꞌbël lu më. Nu rëagná lduꞌu më lë́ꞌël purquë bëdë́ꞌël dumí cuaꞌa ra prubi. ");
INSERT INTO zacNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Bësheꞌldë bëldá shmë́nël ciudá Jope parë tsaglliꞌi rall Simón Pedro. Nápëll lídchill ruaꞌ nisëduꞌu. Pedro guëniꞌi lul ra cusë nagúnël.” Zni guniꞌi ianglë lua. ");
INSERT INTO zacNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Por ni lueguë bësheꞌlda ra shmëna; bidë guëlliꞌi rall lë́ꞌël. Iurneꞌ dzu naꞌa grë naꞌa ndëꞌë delantë lu Dios parë guëquë́ diaguë naꞌa grë lo quë naguniꞌi Dios lul parë guëníꞌil lu naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Guzublú guniꞌi Pedro lu grë mënë narë́ lidchi Cornelio. Guniꞌi Pedro: ―Iurneꞌ gualú rac bë́ꞌahia adë rúnëdiꞌi Dios menos ni tubi mënë lu guë́ꞌdchiliu ");
INSERT INTO zacNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","sino quë rcaꞌa më grë ra nanapë rëspëti nu rzuꞌbë diaguë rall shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Guniꞌi Dios más antsë lu grë naꞌa ziquë shini Jacob ra dizaꞌquë shtë më. Bësheꞌldë më lëꞌë Jesucristo parë bidë guëniꞌinúhiꞌ lëꞌë hiaꞌa dizaꞌquë shtë Dios parë cuedchí lduꞌu hiaꞌa. Jesucristo na rëy; napë më derechë parë rnibëꞌa më grë naciuni. ");
INSERT INTO zacNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Lëꞌë të bien nanë́ të pë guc ladzë ra më israelitë. Primërë guzublú Juan Bautista, bëluáꞌaiꞌ dizaꞌquë lu ra mënë, iurní bëchuꞌbë nísiꞌ. Despuësë guzublú Jesús shchíꞌniꞌ nezë Galilea. ");
INSERT INTO zacNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Lëꞌë të nanë́ të lla bëdëꞌë Dios pudërë parë Jesús më Nazaret. Bësheꞌldë Dios Espíritu Santo parë cuezënúhiꞌ lëꞌë më. Bënëac më grë ra nananú mëdzabë laꞌni lduꞌi. Bëꞌnë më bien por pudërë shtë Dios cumë cabezënúhiꞌ lëꞌë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Lëꞌë naꞌa na naꞌa testigu shtë grë ra cusë rëꞌ nabëꞌnë Jesús. Bëꞌnë më milagrë nezë Judea nu ladi ciudá Jerusalén. Despuësë bëquëꞌë ra mënë lëꞌë Jesús lu cruz; guti më. ");
INSERT INTO zacNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Gudëdë tsunë dzë guti Jesús, iurní bëldishtë́ Dios lëꞌë Jesús ladi ra tëgulë. Nu Dios bësheꞌldë Jesús parë bëluaꞌalú më lu naꞌa stubi vueltë. ");
INSERT INTO zacNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Adë bëluaꞌalú më lu grë ra mënë, niétiquë lu naꞌa bëluaꞌalú më. Dios gudili lëꞌë naꞌa dizdë antsë parë na naꞌa testigu. Verdá nahin; guashtë́ më ladi ra tëgulë. Despuësë lëꞌë naꞌa gudaunú naꞌa lëꞌë më; bëdiiꞌnú naꞌa lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nu bësheꞌldë më lëꞌë naꞌa parë guiagniꞌi naꞌa dizaꞌquë shtë më lu ra mënë. Iurneꞌ cagniꞌi naꞌa verdá. Dios bëdëꞌë pudërë lëꞌë Jesús ziquë tubi juësi parë gunë më juzguë grë ra mënë nanabani nu grë naguti. ");
INSERT INTO zacNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","También ra profetë nagurë́ guahietë, cagniꞌi raiꞌ shcuendë Jesús de quë grë ra natsaldí lduꞌi lëꞌë më, runë më perdunë duldë shtë rall. Por lëꞌë më gac perdunë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nianá quëadiꞌdzënú Pedro lëꞌë ra mënë lidchi Cornelio, lëꞌë Espíritu Santo bëdchini parë cuezënúhiꞌ grë ra narquë́ diaguë diꞌdzë shtë Pedro. ");
INSERT INTO zacNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ra israelitë narialdí lduꞌi dizaꞌquë, ra nazeꞌdë naldë lëꞌë Pedro, nalë́ bëdzëguëëꞌ lduꞌu rall. Guná rall ra narquë́ diaguë shtiꞌdzë Pedro, adë na rall më israelitë perë bëꞌnë rall recibir Espíritu Santo nabëzëlaaꞌdchi Dios parë lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bini rall quëadiꞌdzë ra më rëꞌ stubi dizë́. Quëhunë rall adorar Dios; guniꞌi rall llëruꞌbë na pudërë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Iurní guniꞌi Pedro: ―Hia quë bëdchini Espíritu Santo parë cuezënúhiꞌ lëꞌë rall igual cumë ziquë bëdë́ꞌnaꞌa recibir lë́ꞌiꞌ, hiadë nídiꞌi stubi cusë más. Guëriubë nisë rall iurneꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Gunibëꞌa Pedro lu rall: ―Gulë bëchubë nisë lëꞌë të. Gulë guniꞌi lë Jesucristo purquë na të shmënë më. Despuësë bëꞌnë rall ruëguë lu Pedro parë guëaꞌnë Pedro sëbëldá dzë con lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ra poshtë nu ra nagualdí lduꞌi dizaꞌquë narë́ Judea, bini rall de quë también ra mënë nanádiꞌi më israelitë gualdí lduꞌu raiꞌ dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Iurë bëabrí Pedro Jerusalén, bëldá ra më israelitë gudildi diꞌdzë rall con Pedro. Mënë ni guanaldë rall tëchi custumbrë shtë gac circuncidar mieti. ");
INSERT INTO zacNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Bësëguaꞌa rëdchi rall Pedro. Guniꞌi rall: ―¿Pëzielú guagnal ra mënë nanádiꞌi më israelitë? ¿Pëzielú guataunul lëꞌë rall? ");
INSERT INTO zacNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Iurní biadiꞌdzë Pedro lu rall lla mudë guc guagná Pedro ra mënë de stubi naciuni. Répiꞌ: ");
INSERT INTO zacNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Na zuhia ciudá Jope. Iurë cagniaꞌa lu Dios, gunahia cusë nabësheꞌldë Dios lua. Gunahia tubi lari naquichi ruꞌbë. Zeꞌdin nezë lu gubeꞌe. Liꞌbi guëzá shquinin, nu gulaguin hashtë catë zugáꞌahia. ");
INSERT INTO zacNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Iurë gunahia niaꞌa pë nanú laꞌni lari, gunahia nanú ra ma nazubë tapë guëáhiꞌ; nanú ra ma dushë; nanú ra ma narllaꞌ lduꞌi lu guiuꞌu; nanú ra ma nariasë. ");
INSERT INTO zacNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nu binia tubi bë naguniꞌi: “Pedro, guasuldí. Gudini ma nagaul.” ");
INSERT INTO zacNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Perë na gucha lúhiꞌ: “Dadë, nunquë adë gudáudiaꞌa ma naná providë según creenci shtë mënë israelitë”. ");
INSERT INTO zacNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Iurní bë guniꞌi lua stubi vueltë: “Lo quë hia bëzunë́ Dios, limpi nahin. Adë chu guëníꞌidiꞌi nahin mal parë Dios.” ");
INSERT INTO zacNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Zni guniꞌi bë tsunë vueltë; despuësë beꞌpi lari guiaꞌa stubi. ");
INSERT INTO zacNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Lueguë iurní bëdchini tsunë nguiu mënë Cesarea catë quërelda parë zeꞌdë caꞌa rall na. ");
INSERT INTO zacNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Lëꞌë Espíritu Santo bëshéꞌldiꞌ na parë tsanalda lëꞌë rall sin ni tubi llgabë de quë na rall de stubi naciuni. También guzënú shuꞌpë nguiu rëꞌ na. Grë naꞌa bëdzutë́ naꞌa lidchi Cornelio. ");
INSERT INTO zacNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Lë́ꞌëll biadíꞌdzëll lu naꞌa gunall zu tubi ianglë lídchill nu repi ianglë: “Bësheꞌldë bëldá shmë́nël ciudá Jope parë tsaglliꞌi rall lëꞌë Simón, stubi lëll Pedro. ");
INSERT INTO zacNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Lë́ꞌëll guëníꞌill lul lla mudë gúnël parë gac salvar, lë́ꞌël con grë shfamílil.” ");
INSERT INTO zacNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Iurë guzublú quëadiꞌdzënúa lëꞌë rall, bëdchini Espíritu Santo parë cuezënúhiꞌ lëꞌë rall tal cumë ziquë bëdchíniꞌ tsana bëdë́ꞌnaꞌa recibir lë́ꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Iurní bëagná lduaꞌa lo quë naguniꞌi Jesús lu naꞌa tsana guzënú naꞌa lëꞌë më. Guniꞌi më: “Juan bëchuꞌbë nisë ra mënë con nisë perë Dios guëneꞌe më Espíritu Santo parë guëzunë́ më lduꞌu të nu parë cuezënúhiꞌ lëꞌë të”. ");
INSERT INTO zacNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Si talë Dios bësheꞌldë Espíritu Santo parë cuezënúhiꞌ ra mënë stubi naciuni, igual cumë ziquë bëꞌnë më con lëꞌë hiaꞌa, ra nagualdí lduꞌi shtiꞌdzë Dadë Jesucristo, adë nu mudë guna cuntrë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Iurë bini ra mënë grë lo quë naguniꞌi Pedro lu rall, bëac dchi rall; hiadë pë guníꞌidiꞌi rall. Iurní guzublú bëꞌnë rall adorar Dios. Guniꞌi rall: ―De verdá Dios bëꞌnë perdunë lëꞌë ra nanádiꞌi më israelitë. Bëshaꞌlë më nezë parë guëabrí lduꞌu rall con lëꞌë më nu parë gapë rall vidë sin fin. ");
INSERT INTO zacNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tsana gudini rall Esteban, guaglaꞌguë rzunaldë mënë los de más ra narialdí lduꞌi dizaꞌquë. Ra shmënë Jesús bëagzë́ rall hashtë regiuni Fenicia nu Chipre nu guëꞌdchi shtë Antioquía. Ndë guagniꞌi rall dizaꞌquë niétiquë lu ra më israelitë, lëdë núdiꞌi lu ra stubi mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Bëldá narialdí lduꞌi Jesús, na rall më Chipre nu Cirene. Bëdchini rall ciudá shtë Antioquía. Guniꞌi rall dizaꞌquë shtë Dadë Jesús lu ra më griego. ");
INSERT INTO zacNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Guniꞌi rall lu mënë con llëruꞌbë pudërë shtë Dios. Zni zihani mënë gualdí lduꞌu raiꞌ dizaꞌquë nu guanaldë rall tëchi enseñansë shtë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Bini ra shmënë Jesús narëtaꞌ Jerusalén de quë zihani më Antioquía, hia rzuꞌbë diaguë rall dizaꞌquë. Iurní bësheꞌldë rall Bernabé parë guall Antioquía. ");
INSERT INTO zacNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Iurë bëdchini Bernabé Antioquía, gunall lla mudë cagdëꞌë Dios ra cusë zaꞌquë parë ra narzuꞌbë diaguë dizaꞌquë. Nalë́ bëquitë lduꞌu Bernabé nu guniꞌinúhiꞌ ra mënë të tsanaldë rall shnezë Dios nu gac rall firmë, adë guëazë guétëdiꞌi rall shnezë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé nall tubi nguiu zaꞌquë. Gualdí ldúꞌull Dios. Cabezënú Espíritu Santo laꞌni ldúꞌull. Zihani ra më Antioquía gualdí lduꞌu rall dizaꞌquë shtë Jesucristo. ");
INSERT INTO zacNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Despuësë gubiꞌ Bernabé parë ziáꞌaiꞌ ciudá Tarso. Ndë guatílill Saulo parë beꞌdë guënull lë́ꞌiꞌ Antioquía. ");
INSERT INTO zacNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ndë bëaꞌnë raiꞌ tubi izë con ra shmënë Jesús. Bëluaꞌa raiꞌ zihani mënë. Ra shmënë Dios naquëreldë Antioquía por primërë vësë bërulë́ raiꞌ cristianos. ");
INSERT INTO zacNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tiempë dzë ni bëdchini bëldá nguiu nabëꞌnë recibir llni shtë Dios parë guëniꞌi rall shtiꞌdzë Dios. Zeꞌdë rall de Jerusalén parë bëdchini rall Antioquía. ");
INSERT INTO zacNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Túbill lë Agabo. Guzull guníꞌill lu ra narialdí lduꞌi dizaꞌquë tubi cusë nagac cumplir. Con pudërë nabëdëꞌë Espíritu Santo, lë́ꞌëll guníꞌill guëdchini tubi gubini dushë guëdubi guë́ꞌdchiliu. Gubini rëꞌ guc cumplirin tiempë tsana cagnibëꞌa rëy Claudio. ");
INSERT INTO zacNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Grë ra më Antioquía narialdí lduꞌi shtiꞌdzë Jesús, guꞌ rall de acuerdë parë gunë rall ayudë; bësheꞌldë rall dumí parë prubi naquëreldë Judea. ");
INSERT INTO zacNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bëtëá rall dumí; cadë tubi rall bëdëꞌë lo más posiblë. Bësheꞌldë rall dumí con Bernabé nu Saulo caꞌa ra mëgulë naná cabësë shchiꞌni Dios Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tiempë ni rëy Herodes nalë́ guzunáldëll bëldá ra shmënë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Gunibë́ꞌall guti Jacobo, bëchi Juan. Gudini rall lë́ꞌiꞌ con spadë. ");
INSERT INTO zacNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herodes guná nalë́ rëuuꞌ lduꞌu ra më israelitë nu guc lduꞌu Herodes guënáꞌzill Pedro. Dzë ni bëꞌnë tucarë laní naráu ra më israelitë guetështildi sin levadurë. ");
INSERT INTO zacNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Gunaꞌzi rall Pedro prësi; Herodes gunibëꞌa tsa Pedro lachiguiꞌbë nu gunibë́ꞌall tapë grupë suldadë gapë rall lëꞌë Pedro. Cadë tapëgá suldadë tubi grupë. Bëꞌnë Herodes llgabë niagull Pedro delantë lu ra mënë despuësë de laní Pascu. ");
INSERT INTO zacNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nalë́ segurë nanú Pedro lachiguiꞌbë purquë quëhapë ra suldadë lë́ꞌëll. Perë ra mënë narialdí lduꞌi dizaꞌquë, ziaglaꞌguë quëhunë raiꞌ orar dzë la gueꞌlë. Con guëdubinú lduꞌu rall cagniꞌinú rall lëꞌë më por shcuendë Pedro. ");
INSERT INTO zacNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodes bëꞌnë llgabë guëgull Pedro lachiguiꞌbë; tsagsáꞌnëll Pedro lu ra mënë grëgueꞌlë. Pedro nagaꞌsi lachiguiꞌbë. Líꞌbiꞌ con chupë cadënë. Nu quëhapë chupë suldadë lë́ꞌiꞌ. Stubi shcuaꞌa suldadë zu ruaꞌ lachiguiꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Iurní bëdchini tubi ianglë shtë Dios laꞌni lachiguiꞌbë nu guꞌtë tubi llni. Ianglë bëníꞌbiꞌ lëꞌë Pedro parë guëbániꞌ. Bëcuaꞌñi ianglë lëꞌë Pedro nu répiꞌ lu Pedro: ―Nasesë guashtë́. Lueguë bëruꞌu ra cadënë naliꞌbi guiaꞌa Pedro. ");
INSERT INTO zacNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Lëꞌë ianglë repi lúhiꞌ: ―Bëshiꞌi dchiꞌchi láꞌnil nu bëquëꞌë shráchil. Iurní bëꞌnë Pedro gan, repi ianglë lull: ―Gutë shábël nu gudeꞌe naldë na. ");
INSERT INTO zacNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro bëruꞌu; zianáldiꞌ tëchi ianglë. Adë rac bë́ꞌadiꞌiꞌ gu nahin verdá lo quë naquëhunë ianglë con lë́ꞌiꞌ. Llúaꞌaiꞌ caniꞌi shcáꞌldëll. ");
INSERT INTO zacNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Gudëdë raiꞌ lu ra primërë puertë guiꞌbë naná parë nezë shtë ciudá; iubi puertë bëllaꞌlë parë bëruꞌu raiꞌ. Iurë guzë́ raiꞌ tubi nezë, lëꞌë ianglë bësáꞌniꞌ lëꞌë Pedro. ");
INSERT INTO zacNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Iurní bëdë́ꞌëiꞌ cuendë; guníꞌiꞌ laꞌni ldúꞌiꞌ: ―Iurneꞌ sí, rdë́ꞌëhia cuendë, Dios bësheꞌldë ianglë shtë́niꞌ parë bëldáꞌaiꞌ na guiaꞌa Herodes. Bëldáꞌaiꞌ na guiaꞌa ra mënë israelitë, grë lo quë naguc lduꞌu rall nihunënú rall na. ");
INSERT INTO zacNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Iurë quëhúniꞌ llgabë, ziáꞌaiꞌ lidchi María, shniꞌa Juan Marcos. Ndë zihani mënë rë ra. Quëhunë rall ruëguë lu Dios parë guëruꞌu Pedro lachiguiꞌbë. ");
INSERT INTO zacNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Iurë bësëdchi Pedro ruaꞌ puertë, bëruꞌu tubi criadë; lëll Rode. Guagnall niaꞌa chu ndë nacagnaꞌbë ruaꞌ nezë. ");
INSERT INTO zacNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Perë iurë guc bë́ꞌall chaꞌ Pedro, por tantë bëquitë ldúꞌull, adë bësháꞌlëdiꞌill ruaꞌ nezë sino quë guagllúꞌnëll; guagníꞌill lu ra mënë nazubë laꞌni hiuꞌu. Répill lu rall: ―Pedro zugaꞌa ruaꞌ nezë. ");
INSERT INTO zacNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Iurní repi rall lu Rode: ―Rac túntël rníꞌil zniꞌi. Perë Rode guniꞌi: ―Guldía, Pedro ndë nazugaꞌa ruaꞌ nezë. Perë ra nazubë laꞌni hiuꞌu rniꞌi rall: ―Lë́ꞌëdiꞌi Pedro sino ianglë shtënë Pedro gudëdë. ");
INSERT INTO zacNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Perë Pedro nianá cagsë́dchiꞌ ruaꞌ nezë. Iurë bëshaꞌlë rall ruaꞌ puertë nu guná rall lu Pedro, nalë́ bëdzëguëëꞌ lduꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pedro bëꞌnë sëñi con guiáꞌaiꞌ të guëac dchi rall. Iurní guniꞌi Pedro, bëldaꞌa Dadë Jesús lë́ꞌëll lachiguiꞌbë. Répiꞌ: ―Gulë biadiꞌdzë ndëꞌë lu Jacobo nu lu ra grë narialdí lduꞌi dizaꞌquë shtë Jesús. Iurní bëruꞌu Pedro parë ziáꞌaiꞌ stubi lugar. ");
INSERT INTO zacNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Iurë brëgueꞌlë, nalë́ rdzëbë ra suldadë. Nezë rëꞌ nezë rëꞌ ziaꞌa rall niaꞌa gua Pedro. ");
INSERT INTO zacNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Gunibëꞌa Herodes tsatili rall lëꞌë Pedro perë cumë adë bëdzélëdiꞌi rall Pedro, rëy Herodes gunaꞌbë díꞌdzëll shcuendë Pedro. Iurní gunibëꞌa Herodes gati ra suldadë. Despuësë bëruꞌu Herodes Judea parë ziaꞌa guëquëréldëll guëꞌdchi Cesarea. ");
INSERT INTO zacNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nalë́ rldënú Herodes ra mënë naquëreldë ra guëꞌdchi Tiro nu Sidón, perë lëꞌë ra mënë gurë́ rall de acuerdë parë gunaꞌbë rall en paz lu rëy purquë lu guiuꞌu shtë rëy rruꞌu naráu ra mënë shtë Tiro nu Sidón. Tubi grupë mënë shtë guëꞌdchi rëꞌ, gulutë́ rall amistá con Blasto, tubi muzë ruꞌbë shtë rëy. Blasto guagniꞌinull lëꞌë rëy parë guꞌ en paz. ");
INSERT INTO zacNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes bëzú tubi tërmë lu rall parë pë dzë tsagdchini rall lidchi Herodes. Dzë ni gutë Herodes shábiꞌ parë guzull de rëy nu guzúbëll lu tribunal shtë́nëll. Iurní guzublú guníꞌill zihani diꞌdzë lu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Lëꞌë ra mënë guzublú gurushtiá; guniꞌi rall: ―Ndëꞌë nacagniꞌi adë nall tubi nguiu sino quë nall tubi dios. ");
INSERT INTO zacNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Lueguë iurní tubi ianglë shtë Dios bëdchini. Bëruꞌldë ianglë lëꞌë Herodes lu tubi galguidzë dushë purquë adë bëdë́ꞌëdiꞌill cuendë diꞌdzë shtë Dios. Más bëuuꞌ ldúꞌull naguniꞌi ra mënë lull. Gudáu ra mbiziuguë lëꞌë Herodes; gútill. ");
INSERT INTO zacNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Dizaꞌquë shtë Dios guaglaꞌguë bërëꞌtsë nezë rëꞌ nezë rëꞌ. Zihani mënë gualdí lduꞌu rall dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé nu Saulo guagsaꞌnë dumí nabësheꞌldë ra mënë Antioquía parë ra prubi ciudá Jerusalén. Iurní bëagrí raiꞌ con Juan Marcos hashtë Antioquía. ");
INSERT INTO zacNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ladi mënë narialdí lduꞌi dizaꞌquë guëꞌdchi Antioquía, nanú Saulo. Nanú Bernabé. Nanú Simón narniꞌi ra mënë Iaꞌsë. Nanú Lucio më Cirene. Nanú Manaén naguaruꞌbë lidchi Herodes, gubernadurë shtë Galilea. ");
INSERT INTO zacNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tubi dzë ni bëdëá raiꞌ; cagnaꞌbë raiꞌ Dios nu quëhunë raiꞌ ayunë; adë ráudiꞌi raiꞌ dzë ni. Guniꞌi Espíritu Santo lu raiꞌ: ―Gulë bëꞌnë nombrar Bernabé nu Saulo parë dchiꞌni naguëdëꞌa gunë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Iurë gualú bëꞌnë rall orar nu bëꞌnë rall ayunë, bëdchiꞌbë rall guiaꞌa rall guëc Saulo nu Bernabé parë gunë raiꞌ recibir shchiꞌni Dios. Iurní bënë rall despedir lëꞌë raiꞌ. Ziaꞌa raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Bësheꞌldë Espíritu Santo lëꞌë Saulo nu Bernabé parë tubi guëꞌdchi nalë Seleucia nanaquë́ ruaꞌ nisëduꞌu. Ndë beꞌpi raiꞌ laꞌni barcu parë ziaꞌa raiꞌ Chipre, tubi dani nananú laꞌni nisë. ");
INSERT INTO zacNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bëdchini raiꞌ Salamina; nahin puertë catë riutë́ barcu. Ndë guzublú Saulo nu Bernabé cagniꞌi raiꞌ dizaꞌquë lu ra mënë laꞌni iáduꞌu shtë ra më israelitë. Nu zac Juan Marcos ziaꞌanú raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Guëdubi guëꞌdchi shtë Chipre guazë́ raiꞌ. Bëdchini raiꞌ tubi guëꞌdchi lë Pafos. Ndë bëdiaꞌguëlú raiꞌ tubi narunë galbëlliú. Nall më israelitë nu lëll Barjesús. Nalë́ runtsáꞌull bishi; guníꞌill grë ra diꞌdzë narníꞌill nahin verdá. ");
INSERT INTO zacNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Barjesús nall amigu shtë gubernadurë nalë Sergio Paulo. Gubernadurë nall tubi nguiu nasini guë́quëll. Bëshéꞌldëll rsunë parë cagnaꞌbë mënë Bernabé nu Saulo purquë gubernadurë rac shtúꞌull guínill dizaꞌquë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Napë Barjesús stubi lë, Elimas, quiere decir narunë dchiꞌni shtë bëlliú. Adë në́diꞌi Elimas niuadiꞌdzënú Saulo gubernadurë purquë adë në́diꞌill tsaldí lduꞌu gubernadurë shtiꞌdzë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Iurní Saulo, nápiꞌ stubi lë́hiꞌ Pablo, con pudërë shtë Espíritu Santo nacabeznú laꞌni ldúꞌiꞌ, gubiꞌa guë́ꞌiꞌ lu Elimas. ");
INSERT INTO zacNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Guniꞌi Pablo lull: ―Lë́ꞌël guëdzë́ bishi nu duldë laꞌni ldúꞌul. Shini mëdzabë nal. Enemigu nal shtë cusë zaꞌquë. Rluáꞌal ra mënë bishi, nu adë rsáꞌnëdiꞌil tsutë́ rall nezë zaꞌquë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Iurneꞌ Dios gunë më cashtigu lë́ꞌël; guëáꞌnël ciegu por tubi tiempë; adë guënádiꞌil lu llni ngubidzë. Lueguë lueguë bëcahi slu Elimas nu bëáꞌnëll ciegu. Caguílill tubi naguënaꞌzi guiáꞌall parë sëll. ");
INSERT INTO zacNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Iurë guná gubernadurë naguc con Elimas, gualdí lduꞌu gubernadurë dizaꞌquë. Nalë́ bëdzëguëëꞌ ldúꞌull iurë bínill shtiꞌdzë Dios naguniꞌi Pablo. ");
INSERT INTO zacNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo con ra sáhiꞌ beꞌpi raiꞌ barcu puertë nalë Pafos parë ziaꞌa raiꞌ hashtë tubi guëꞌdchi nalë Perge nananú regiuni Panfilia; perë bësaꞌnë Juan Marcos dchiꞌni shtë Dios. Mejurë bëagrill Jerusalén. ");
INSERT INTO zacNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Iurní bëruꞌu Pablo con Bernabé guëꞌdchi Perge. Ziaꞌa raiꞌ ciudá Antioquía nanaquë́ regiuni shtë Pisidia. Dzë nabëziꞌi lduꞌu ra mënë, guatë́ Pablo con sáhiꞌ iáduꞌu shtë më israelitë. Ndë guzubë raiꞌ parë guëquë́ diaguë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Biꞌldi ra jëfë shtë iáduꞌu laꞌni librë nabëquëꞌë Moisés nu biꞌldi rall librë shtë ra profetë. Iurní guniꞌi rall lu Pablo: ―Lëꞌë të saꞌ hiaꞌa, talë nuaꞌa të tubi diꞌdzë ziquë cunseju parë grë hiaꞌa, dzu hiaꞌa ndëꞌë. Gulë guniꞌi. ");
INSERT INTO zacNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Iurní guasuldí Pablo; bë́ꞌniꞌ tubi sëñi con guiáꞌaiꞌ parë guëac dchi ra mënë. Guníꞌiꞌ: ―Gulë bëquë́ diaguë lëꞌë të më israelitë, nu grë të nazeꞌdë guëꞌnë adorar Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dios shtë naciuni Israel, gulë́ më shtadë guëlú hiaꞌa parë mizmë lë́ꞌiꞌ. Bëꞌnë më shtádaꞌa tubi naciuni ruꞌbë tsana nianá quëreldë raiꞌ Egipto. Nu despuësë Dios gulú lëꞌë raiꞌ Egipto con pudërë shtë më. ");
INSERT INTO zacNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Durantë cuarenta izë biaꞌa lduꞌu Dios mudë fierë shtë raiꞌ iurë ziaꞌa raiꞌ nezë catë nídiꞌi mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nu gunitilú më gadchi naciuni nanaquë́ regiuni shtë Canaán. Bëdë́ꞌëiꞌ lugar ni parë guquëreldë shtadë guëlú hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Durantë tubi tiempë tapë gahiuꞌa guëruldë izë, guquëreldë naciuni Israel ndë. Ra juësi nabësheꞌldë Dios, gunibëꞌa raiꞌ naciuni Israel hashtë tiempë shtë Samuel. ");
INSERT INTO zacNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Iurní gunaꞌbë ra mënë lu Dios tubi rëy naguënibëꞌa lëꞌë rall. Bëdëꞌë Dios tubi rëy nalë Saúl. Gunibëꞌa Saúl lëꞌë rall cuarenta izë. Saúl nall shini tubi nguiu nalë Cis nazeꞌdë ladi shini Benjamín. ");
INSERT INTO zacNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Despuësë Dios gulú lëꞌë Saúl lugar shtë́nëll parë subë David ziquë rëy naguënibëꞌa më israelitë. Guniꞌi Dios: “Gudilia David llgaꞌnë Isaí. David na tubi nguiu nabëuuꞌ lduaꞌa nu gúnëll cumplir grë lo quë narac shtuaꞌa.” ");
INSERT INTO zacNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Gulë Jesús ladi llëbní David nu lëꞌë Jesús náhiꞌ el quë nagunë salvar më israelitë. Ni bëꞌnë Dios prometer más antsë. ");
INSERT INTO zacNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pues antsë guzublú Jesús dchiꞌni shtë́hiꞌ, Juan Bautista guniꞌi lu zihani mënë israelitë të gunë nadzëꞌë rall mudë nanabani rall nu chubë nisë rall ziquë sëñi de quë bëabrí lduꞌu rall con Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tsana zeꞌdë guëdchini gati Juan, guníꞌiꞌ: “¿Chu runë të llgabë nahia? Adë rúnëdiꞌi të shgabë të nahia el quë nacabezë të. Zeꞌdë stubi më más lasac quë na. Na adë lasáquëdiaꞌa parë lëꞌë më. Ni tubi adë chu nádiaꞌa parë guëshaca du guiꞌdi shtënë shrachi më.” ");
INSERT INTO zacNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Rniaꞌa lu të Dadë nazeꞌdë zu famili shtë Abraham, nu rniaꞌa lu grë të narunë adorar Dios. Dios bësheꞌldë dizaꞌquë rëꞌ parë gac salváraꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ra naguquëreldë Jerusalén nu jëfë shtë rall, adë guc bë́ꞌadiꞌi rall chu na Jesús. Nu adë guasë́diꞌi rall ra diꞌdzë shtë ra profetë nabëquëꞌë shtiꞌdzë Dios guahietë. Rsëꞌdë rall diꞌdzë rëꞌ laꞌni iáduꞌu shtë mënë israelitë cadë dzë narziꞌi lduꞌu ra mënë, perë tsana bëꞌnë rall condenar Jesús, bëꞌnë rall cumplir grë lo quë naná escritë de lëꞌë më. ");
INSERT INTO zacNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Adë bëdzélëdiꞌi rall ni tubi duldë nabëꞌnë Jesús perë gunaꞌbë rall lu Pilato parë gati më. ");
INSERT INTO zacNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Iurë guc cumplir grë lo quë narniꞌi laꞌni Sagradas Escrituras shcuendë Jesús, bësietë mënë lëꞌë më lu cruz parë bëgaꞌchi më laꞌni baꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Perë bëldishtë́ Dios lëꞌë më ladi ra tëgulë parë gubani më stubi vueltë. ");
INSERT INTO zacNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nu zihani dzë bëluaꞌalú Jesús lu ra nabëꞌnë compañi lëꞌë më iurë ziagzë́ më de Galilea parë Jerusalén. Lëꞌë ra mënë ni guná rall lu Jesús nu iurneꞌ quëadiꞌdzë rall ziquë testigu de quë Jesús nabani. ");
INSERT INTO zacNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Nu zac lëꞌë naꞌa, cagniꞌi naꞌa dizaꞌquë nabëꞌnë më prometer lu shtádaꞌa. Guc cumplirin parë lëꞌë hiaꞌa purquë na hiaꞌa shini raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Bëldishtë́ Dios lëꞌë Jesús ladi ra tëgulë. Zni naescritë laꞌni segundë Salmo: “Lë́ꞌël nal shinia. Nedzë́ bënehia vidë parë lë́ꞌël.” ");
INSERT INTO zacNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Guniꞌi Dios guëldishtë́hiꞌ lëꞌë Jesús ladi ra tëgulë parë adë gáudiꞌi guiuꞌu cuerpë shtë më. Zni naescritë laꞌni Sagradas Escrituras naguniꞌi Dios: “Guënehia ra cusë zaꞌquë parë lëꞌë të, lo quë nabëna prometer lu David”. ");
INSERT INTO zacNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Por ni David laꞌni stubi Salmo guniꞌi: “Adë guësëaꞌnëgal cuerpë shtë shínil narac shtúꞌul laꞌni baꞌa parë adë gáudiꞌi guiuꞌu shcuérpiꞌ”. ");
INSERT INTO zacNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David bëꞌnë sirvë lu sáhiꞌ tiempë nabániꞌ. Bëꞌnë záꞌquëll ra cusë ziquë guniꞌi Dios lull. Perë despuësë gútill nu bëgáꞌchill. Guꞌdzë cuerpë shtë́nëll. ");
INSERT INTO zacNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Perë cuerpë shtë nguiu nabëldishtë́ Dios ladi ra tëgulë, adë gúꞌdzëdiꞌin. ");
INSERT INTO zacNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Bëchi, napë quë gac bëꞌa të lo quë narniaꞌa lu të; lë́ꞌësë Jesús napë pudërë parë gunë më perdunë duldë shtë të. ");
INSERT INTO zacNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Grë narialdí lduꞌi Jesús na perdunë duldë shtë rall. Adë nídiꞌi mudë parë sunë́ almë shtë të por lëy nabëquëꞌë Moisés purquë adë nápëdiꞌin pudërë parë nihunin perdunë duldë shtë mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Gulë gupë cuidadë të ldáguëdiꞌi cashtigu shtë Dios guëc të, ra cusë nabëquëꞌë ra profetë iurë guniꞌi raiꞌ shtiꞌdzë Dios narniꞌi: ");
INSERT INTO zacNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Gulë guná, lëꞌë të naquëhunë burnë. Gulë bëtsëbë lduꞌu të nu gulë gapë galguti sin fin. Quëhuna tubi cusë ruꞌbë entrë lëꞌë të, cusë adë tsaldídiꞌi lduꞌu të zeꞌdë ra cusë de na. Nu adë tsaldídiꞌi lduꞌu të si talë chu stubi guëniꞌi lu të. ");
INSERT INTO zacNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Iurë bëruꞌu Pablo con sáhiꞌ, ra mënë nanádiꞌi më israelitë, gunaꞌbë rall tubi favurë lu Pablo, guëabrí raiꞌ stubi vueltë dzë naguëziꞌi lduꞌu mënë naguëdzaꞌguë llmalë parë tsaglaꞌguë guadiꞌdzë Pablo dizaꞌquë lu rall. ");
INSERT INTO zacNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Iurë gualú bëtëꞌtsë ra mënë zihani, sëbëldá më israelitë canaldë lëꞌë Pablo nu Bernabé. Nu zihani ra nanádiꞌi më israelitë perë guatë́ rall creenci shtë ra më israelitë, canaldë rall Pablo nu Bernabé. Pablo nu Bernabé guniꞌinú raiꞌ lu mënë ni të tsaglaꞌguë tsaldí lduꞌu raiꞌ dizaꞌquë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Bëdzaꞌguë llmalë bëdchini dzë descansë; casi grë mënë shtë guëꞌdchi bëdëá rall parë guëquë́ diaguë rall diꞌdzë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Guná ra më israelitë tantë zihani mënë bëdëá, bëldë́ rall; napë rall mbidi. Guniꞌi guidzë rall lëꞌë Pablo nu Bernabé. Bëꞌnë rall insultar Pablo. ");
INSERT INTO zacNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Iurní Pablo nu Bernabé adë bëdzë́bëdiꞌi raiꞌ. Guniꞌi raiꞌ: ―Bësheꞌldë Dios lëꞌë naꞌa primërë lu të, na të më israelitë parë guëquë́ diaguë të dizaꞌquë shtë Dios; perë në́diꞌi të guëzuꞌbë diaguë të shtiꞌdzë Dios. Adë në́diꞌi të gunë të recibir vidë sin fin. Iurneꞌ guiagniꞌi naꞌa lu mënë de stubi naciuni ");
INSERT INTO zacNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","purquë zni bësheꞌldë Dios lëꞌë naꞌa. Bëquëꞌë Isaías shtiꞌdzë më narniꞌi: Na Dios, rzua lë́ꞌël ziquë tubi llni parë grë ra mënë nanádiꞌi më israelitë. Lë́ꞌël tsanul ra dizaꞌquë hashtë lúltimë guëꞌdchi shtë guë́ꞌdchiliu parë gunë Dios salvar lëꞌë ra mënë natsaldí lduꞌi shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Iurë bini ra mënë nanádiꞌi më israelitë, nalë́ bëquitë lduꞌu rall. Guniꞌi rall nalë́ nasaꞌa dizaꞌquë shtë Dios. Nu bëdëꞌë rall graci lu më. Grë ra nagudili Dios parë gac salvar, lueguë gualdí lduꞌu rall shtiꞌdzë më. ");
INSERT INTO zacNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Zni bërëꞌtsë dizaꞌquë guëdubi regiuni shtë Pisidia. ");
INSERT INTO zacNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Perë ra israelitë naquëreldë Antioquía biadiꞌdzë rall con bëldá naꞌa nu nguiu de rëspëti ladi guëꞌdchi. Naꞌa rëꞌ napë rall devociuni parë Dios. Grë rall bëtsatsu rall më guëꞌdchi cuntrë Pablo nu Bernabé. Gulú rall lëꞌë raiꞌ fuërë ruaꞌ guëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pablo nu Bernabé bëdchibi rall gushëguiuꞌu shtë shrachi rall ziquë tubi sëñi de quë ra mënë Antioquía adë bëzuꞌbë diáguëdiꞌi rall dizaꞌquë shtë Jesús. Iurní ziaꞌa raiꞌ ciudá nalë Iconio. ");
INSERT INTO zacNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ra nagualdí lduꞌi shtiꞌdzë Jesús ciudá Antioquía, nalë́ bëquitë lduꞌu rall. Cabezënú Espíritu Santo laꞌni lduꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pablo nu Bernabé guërupë raiꞌ guatë́ raiꞌ iáduꞌu shtë më israelitë guëꞌdchi Iconio. Bëluaꞌa raiꞌ dizaꞌquë shtë Jesús lu ra mënë. Zihani mënë gualdí lduꞌu rall dizaꞌquë, më israelitë nu ra më griego. ");
INSERT INTO zacNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Perë ra më israelitë nadë në́diꞌi tsaldí lduꞌi, bëtsatsu rall mënë nanádiꞌi israelitë parë bëꞌnë rall llgabë mal cuntrë ra narialdí lduꞌi dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pablo nu Bernabé bëaꞌnë raiꞌ llëduni tiempë lugar ni. Adë bëdzë́bëdiꞌi rall guniꞌi rall lu mënë de quë Dios rac shtuꞌu më grë mënë narë́ lu guë́ꞌdchiliu. Dios quëhunë compañi lëꞌë Pablo nu Bernabé parë bëꞌnë raiꞌ milagrë. Bëꞌnë raiꞌ cusë ruꞌbë. Zni guasë́ ra mënë dizaꞌquë naguniꞌi Pablo, zeꞌdin de Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Perë ra mënë guëꞌdchi ni, adë bë́ꞌnëdiꞌi rall tubsë llgabë. Bëldá rall guniꞌi nazaꞌquë na diꞌdzë shtë raiꞌ. Sëbëldá rall guniꞌi adë nazáꞌquëdiꞌi diꞌdzë shtë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Iurní ra më israelitë nu ra nadë nádiꞌi israelitë, guꞌ rall de acuerdë con ra gubiernë parë guënaꞌzi rall Pablo nu Bernabé nu niadëꞌë guëꞌë rall lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bini Pablo nu Bernabé pë nihunë rall. Bëruꞌu raiꞌ guiaꞌa contrari shtë raiꞌ. Gubiꞌ raiꞌ ciudá ni parë zëagzë́ raiꞌ guëꞌdchi nalë Listra nu Derbe naquë́ regiuni shtë Licaonia. ");
INSERT INTO zacNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Guagniꞌi raiꞌ dizaꞌquë guëdubi ciudá nu guëꞌdchi shtë regiuni ni. ");
INSERT INTO zacNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Guëꞌdchi Listra nanú tubi nguiu cujë; ráquëdiꞌi rzëll. Ndë zúbëll purquë dizdë nagúlëll nall cujë. ");
INSERT INTO zacNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Caquë́ diaguë nguiu ni nacagniꞌi Pablo. Iurní nalë́ rbiꞌa Pablo lu nguiu ni; guc bëꞌa Pablo de quë rialdí ldúꞌull parë guëáquëll. ");
INSERT INTO zacNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Iurní fuertë guniꞌi Pablo lull: ―Guasuldí ngaꞌli. Bëzú guëaꞌl lu guiuꞌu. Lueguë guasuldí cujë nu guzublú rzëll. ");
INSERT INTO zacNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Iurë guná ra mënë pë bëꞌnë Pablo con nguiu ni, guzublú guniꞌi rall fuertë diꞌdzë naruadiꞌdzë ra më Licaonia. Guniꞌi rall: ―Dios ndëꞌë bëdchini ládzaꞌa con cuerpë shtë nguiu. ");
INSERT INTO zacNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Guniꞌi rall Bernabé na dios Júpiter nu Pablo na dios Mercurio purquë Pablo ruadíꞌdziꞌ lu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Iáduꞌu shtë dios Júpiter zubin entradë shtë guëꞌdchi. Bëshuzi narunë dchiꞌni laꞌni iáduꞌu ni, bidënull bëldá ngunë con zihani guëꞌë hashtë puertë shtë guëꞌdchi. Bëshuzi nu ra mënë rac shtuꞌu rall gunë rall adorar lëꞌë ra poshtë nu quini rall ngunë ziquë tubi ofrendë parë lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Perë Pablo nu Bernabé guná raiꞌ pë rac shtuꞌu gunënú mënë lëꞌë raiꞌ; guzublú bëchíꞌezë raiꞌ shabë raiꞌ ziquë tubi sëñi de quë adë rëuuꞌdiꞌi lduꞌu raiꞌ lo quë nacanihunë ra mënë. Guniꞌi raiꞌ fuertë. Guatë́ raiꞌ ladi ra mënë ");
INSERT INTO zacNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","nu guniꞌi raiꞌ: ―Lëꞌë të Dadë, ¿pëzielú runë të zniꞌi? Lëꞌë naꞌa na naꞌa nguiu ziquë lëꞌë të. Zëꞌpë guëniꞌi naꞌa lu të parë guësaꞌnë të ra custumbrë nadë guëlluíꞌidiꞌi. Lëꞌë naꞌa rac shtuꞌu naꞌa tsanaldë të tëchi nezë zaꞌquë shtë Dios nanabani. Bëntsaꞌu më gubeꞌe nu guë́ꞌdchiliu nu grë cusë nananú lu guë́ꞌdchiliu bëntsaꞌu më. ");
INSERT INTO zacNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tiempë guahietë Dios bësëaꞌnë më lëꞌë ra mënë gubani rall ziquë mudë narac shtuꞌu rall ");
INSERT INTO zacNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","perë siemprë bëꞌnë Dios bien parë lëꞌë rall nu bësheꞌldë më ganzaꞌquë parë lëꞌë rall. Bëdëꞌë më sufsientë nagáu rall hashtë bëquitë lduꞌu rall. Iurneꞌ Dios quëhunë më lo mizmë con lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Guniꞌi Pablo diꞌdzë rëꞌ lu ra mënë perë apënë bë́ꞌniꞌ gan parë adë gudínidiꞌi ra mënë ra ma ziquë ofrendë lu raiꞌ. Siemprë rac shtuꞌu rall gunë rall adorar lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Zeꞌdë bëldá më israelitë shtë Antioquía nu Iconio. Bëdchini rall Listra catë nanú Pablo. Bëquili rall mënë shtë Listra con bishi parë bëdëꞌë guëꞌë rall Pablo. Bëshaguiú rall lë́ꞌiꞌ parë gulú rall lë́ꞌiꞌ ruaꞌ guëꞌdchi purquë lluaꞌa rall hia guti Pablo. ");
INSERT INTO zacNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Iurní bëdchini ra narialdí lduꞌi dizaꞌquë catë nagaꞌa Pablo; bëdëá rdondë rall catë nagaꞌa Pablo. Iurní bëlë́ ldúꞌiꞌ nu guashtë́hiꞌ. Guatë́hiꞌ stubi vueltë guëꞌdchi. Perë brëgueꞌlë bëruꞌu raiꞌ guëꞌdchi parë ziaꞌa raiꞌ stubi guëꞌdchi nalë Derbe. ");
INSERT INTO zacNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ndë guniꞌi raiꞌ dizaꞌquë shtë Dios lu ra më Derbe. Nalë́ zihani mënë gualdí lduꞌu raiꞌ shtiꞌdzë Dios. Despuësë bëabrí raiꞌ guëꞌdchi Listra, Iconio, nu Antioquía. ");
INSERT INTO zacNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ra lugar ni guniꞌinú raiꞌ mënë narialdí lduꞌi dizaꞌquë parë guaglaꞌguë rall nu gac rall firmë, nu adë guësáꞌnëdiꞌi rall shnezë Dios. Guniꞌi raiꞌ de quë antsë tsutë́ mieti catë rnibëꞌa Dios, napë quë sac zi mieti purquë na raiꞌ shmënë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Cadë guëꞌdchi catë nanú ra narialdí lduꞌi dizaꞌquë, Pablo nu Bernabé bëzú raiꞌ bëldá nguiu naguëná dchiꞌni shtë Dios. Despuësë biadiꞌdzënú raiꞌ Dios nu bëꞌnë raiꞌ ayunë, bëꞌnë raiꞌ animar lëꞌë mënë ni të gac rall firmë lu shnezë Dios, el quë narialdí lduꞌu raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Gudëdë raiꞌ regiuni shtë Pisidia parë bëdchini raiꞌ regiuni shtë Panfilia. ");
INSERT INTO zacNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Guniꞌi raiꞌ dizaꞌquë lu ra mënë ciudá shtë Perge. Despuësë gua raiꞌ guëꞌdchi Atalia. ");
INSERT INTO zacNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ndë beꞌpi raiꞌ barcu parë ziaꞌa raiꞌ Antioquía ciudá catë ra narialdí lduꞌi shtiꞌdzë Dios, bëdëꞌë raiꞌ dchiꞌni shtë Dios parë lëꞌë raiꞌ; mizmë lugar ni antsë biadiꞌdzënú rall Dios parë gunë më compañi lëꞌë raiꞌ. Iurneꞌ bëabrí raiꞌ purquë hia bëꞌnë raiꞌ gan dchiꞌni rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Iurë bëdchini raiꞌ Antioquía, bëtëá raiꞌ grë mënë narialdí lduꞌi dizaꞌquë. Biadiꞌdzë raiꞌ lu rall mudë nabëꞌnë Dios compañi lëꞌë raiꞌ. Guniꞌi raiꞌ Dios bëdëꞌë lugar parë gualdí lduꞌu ra mënë nanádiꞌi më israelitë perë guatë́ rall shnezë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pablo nu Bernabé bëaꞌnë raiꞌ ciudá ni llëduni tiempë con ra narialdí lduꞌi dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tiempë dzë ni bëdchini bëldá nguiu Antioquía. Na rall më Judea. Guzublú cagluaꞌa rall ra mënë narialdí lduꞌi dizaꞌquë. Guniꞌi rall: ―Parë gac salvar të napë quë gunë të cumplir custumbrë riuguë tubi partë delicadë shtë ngulëꞌnë ziquë bëquëꞌë Moisés laꞌni lëy parë guëdë́ꞌnaꞌa cumplir. ");
INSERT INTO zacNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablo nu Bernabé biadiꞌdzënú raiꞌ ra nguiu rëꞌ llëduni tiempë hashtë gudildi diꞌdzë rall. Por fin ra narialdí lduꞌi dizaꞌquë, bëꞌnë rall nombrar Pablo nu Bernabé con sëbëldá nguiu parë ziaꞌa rall Jerusalén. Guaguëꞌnë rall rëglë asuntë ni con los de más ra poshtë con ra mëgulë naná cabësë shtë ra më narialdí lduꞌi Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Bësheꞌldë ra më Antioquía lëꞌë raiꞌ. Gudëdë raiꞌ ra regiuni shtë Fenicia nu Samaria. Quëadiꞌdzë raiꞌ shtiꞌdzë Dios lu ra mënë narialdí lduꞌi dizaꞌquë. Guniꞌi raiꞌ lu ra mënë nanarë́ catë ziaꞌa raiꞌ, grë lo quë nabëꞌnë Dios con ra mënë de stubi naciuni, cumë bëagrí lduꞌu rall con Dios nu bësaꞌnë rall creenci gushë parë zianaldë rall shnezë Dios. Grë ra më narialdí lduꞌi dizaꞌquë, bini rall shtiꞌdzë Pablo nu Bernabé. Nalë́ bëquitë lduꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Tsana bëdchini raiꞌ Jerusalén, ra narialdí lduꞌi dizaꞌquë bëꞌnë rall recibir lëꞌë raiꞌ con llëruꞌbë cariñi. Zubënú ra mënë rëꞌ ra poshtë nu ra mëgulë naná cabësë ladi grupë shtë raiꞌ. Pablo nu Bernabé guzublú biadiꞌdzë raiꞌ grë ra cusë nabëꞌnë Dios con lëꞌë raiꞌ, cumë ziquë mënë stubi naciuni gualdí lduꞌu rall dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Perë iurní bëldá ra fariseo narialdí lduꞌi shtiꞌdzë Jesús, guasuldí rall nu guniꞌi rall: ―Rquiꞌni riuguë duꞌpë partë delicadë shtë nanádiꞌi më israelitë parë gac salvar rall. Cha guëdë́ꞌnaꞌa obligar lëꞌë rall tsanaldë rall tëchi lëy shtë Moisés. Gac salvar rall iurní. ");
INSERT INTO zacNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bëdëá ra poshtë nu ra mëgulë parë bësëꞌdë rall diꞌdzë rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Llëduni tiempë biadiꞌdzë rall. Iurní guasuldí Pedro nu guníꞌiꞌ: ―Rniaꞌa lu grë të narialdí lduꞌi dizaꞌquë, cumë ziquë nanë́ të hia ziaꞌa tiempë gudili Dios na entrë lëꞌë të. Nu bësheꞌldë më na parë guagniaꞌa dizaꞌquë shtë më lu ra mënë nanádiꞌi më israelitë. Nu gualdí lduꞌu rall dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dios rna laꞌni lduꞌu ra mieti; bëꞌnë më recibir lëꞌë raiꞌ cumë ziquë shini më. Bëdëꞌë më Espíritu Santo parë cuezënúhiꞌ lëꞌë raiꞌ igual ziquë bëdëꞌë më Espíritu Santo parë lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Quëhunë Dios compañi lëꞌë raiꞌ igual ziquë lëꞌë hiaꞌa masiá adë nádiꞌi raiꞌ më israelitë. Bëzunë́ më laꞌni lduꞌu raiꞌ purquë gualdí lduꞌu raiꞌ dizaꞌquë shtë më. ");
INSERT INTO zacNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Aunquë lëꞌë të nanë́ të Dios quëhunë më salvar lëꞌë raiꞌ, siemprë riaglaꞌguë rniꞌi të tsanaldë raiꞌ tëchi lëy shtë Moisés. Nahin tubi lëy dushë parë lëꞌë rall; nilë ra shtadë guëlú hiaꞌa, nilë lëꞌë hiaꞌa adë bëdë́ꞌnëdiꞌiaꞌa cumplir lëy ni. Nahin tubi lëy dushë parë lëꞌë hiaꞌa. Adë chu gúnëdiꞌi gan gunë cumplirin. ");
INSERT INTO zacNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Perë lëꞌë hiaꞌa bien nanë́ hiaꞌa, bëꞌnë më salvar lëꞌë hiaꞌa ndigá. Rniaꞌa lu të na rall shini më purquë nalë́ guc shtuꞌu më lëꞌë ra nanádiꞌi më israelitë. Nu na Jesús Shtadë shtë grë ra narialdí lduꞌi dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Grë rall bëac dchi nu bëquë́ diaguë rall; iurní Bernabé nu Pablo guzublú biadiꞌdzë raiꞌ lla gua raiꞌ ladi ra mënë de stubi naciuni. Nu bëꞌnë Dios zihani milagrë por lëꞌë raiꞌ. Dios bënëac zihani clasë galguidzë. ");
INSERT INTO zacNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Iurë gualú biadiꞌdzë raiꞌ, Jacobo guasuldí nu guníꞌiꞌ lu ra mënë: ―Iurneꞌ guadiꞌdza lu të narialdí lduꞌu dizaꞌquë; gulë bëquë́ diaguë. ");
INSERT INTO zacNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Pedro biadiꞌdzë lu hiaꞌa lla bëꞌnë Dios. Dzë ni por primërë vueltë gudili më ra nanádiꞌi më israelitë parë gac rall shmënë më. ");
INSERT INTO zacNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ndëꞌë bëruꞌuin de acuerdë con lo quë nabëquëꞌë ra profetë laꞌni Sagradas Escrituras tiempë guahietë. Rniꞌi rahin zdëꞌë: ");
INSERT INTO zacNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Despuësë guëabría të guëzáꞌahia hiuꞌu shtë David naná ziquë hiuꞌu dachi. Guëcubia reinadë shtë́hiꞌ nagurë́. ");
INSERT INTO zacNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Gúnahin të parë ra mënë nanádiꞌi më israelitë quili rall na, nu ra mënë shtë grë naciuni narnaꞌbë lëa, gac rall shmëna. ");
INSERT INTO zacNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Zni cagniꞌi Dadë dizdë tiempë guahietë të gac bëꞌa mieti. ");
INSERT INTO zacNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Por ni rniaꞌa lu të shgaba. Adë pë gunënúdiꞌi hiaꞌa con ra nanádiꞌi mënë israelitë perë bëabrí lduꞌu rall con Dios. Adë chu gúnëdiꞌi obligar lëꞌë rall parë tsanaldë rall lëy shtë Moisés. ");
INSERT INTO zacNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Perë guëquëꞌë hiaꞌa lu rall parë adë gáudiꞌi rall belë shtë ra ma narunë ra mënë ofrecërë ziquë ofrendë lu ra ídolo. Nu adë guëquënúdiꞌi rall saꞌ rall, nu adë gáudiꞌi rall rënë, nilë belë shtë ra ma nadë bëshë́ꞌëdiꞌi rënë. ");
INSERT INTO zacNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Hia por llëduni tiempë biꞌldi ra mënë lëy nabëquëꞌë Moisés cadë iáduꞌu shtë rall, nu cadë dzë nabëziꞌi lduꞌu rall cagluaꞌa mësë lëꞌë rall nabëquëꞌë Moisés. ");
INSERT INTO zacNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Iurní ra poshtë con ra mëgulë naná cabësë nu grë ra narialdí lduꞌi dizaꞌquë, gudili rall bëldá nguiu ladi lo mizmë saꞌ rall parë bësheꞌldë rall lëꞌë raiꞌ Antioquía con Pablo nu Bernabé. Bëꞌnë rall nombrar Silas con Judas. Judas stubi lëll Barsabás. Na rall nguiu më ruꞌbë ladi ra narialdí lduꞌi dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bëntsaꞌu ra poshtë tubi cartë parë biaꞌa raiꞌ narniꞌi: “Lëꞌë naꞌa ra poshtë nu ra mëgulë nu grë ra narialdí lduꞌu dizaꞌquë shtë Jesús naquëreldë Jerusalén, rsheꞌldë naꞌa tubi saludë parë grë ra narialdí lduꞌi dizaꞌquë, ra nanádiꞌi më israelitë. Rsheꞌldë naꞌa tubi saludë lëꞌë të grë ra naquëreldë Antioquía nu ra naquëreldë regiuni Siria nu Cilicia. ");
INSERT INTO zacNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nanë́ naꞌa bëruꞌu bëldá nguiu ladi naꞌa. Bidë rall ciudá shtë të parë bidë guëniꞌi rall lu të rquiꞌni tsanaldë të tëchi lëy nabëquëꞌë Moisés parë gac salvar të. Perë adë bëshéꞌldëdiꞌi naꞌa lëꞌë rall. Niétiquë bidë guëchili rall shgabë të; rnibëꞌa rall gac circuncidar të nu gunë të cumplir lëy shtë Moisés. ");
INSERT INTO zacNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Por ni bëdzú naꞌa de acuerdë lu juntë shtë naꞌa parë gudili naꞌa bëldá nguiu ladi naꞌa parë guidë guëná raiꞌ lëꞌë të. Bësheꞌldë naꞌa lëꞌë raiꞌ con Pablo nu Bernabé, nguiu narac shtuꞌu hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bernabé nu Pablo na raiꞌ nguiu nabëdchiꞌbë ra vidë shtë raiꞌ lu galguti iurë guagniꞌi raiꞌ dizaꞌquë shtë Jesucristo, Shtádaꞌa, lu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Cagsheꞌldë naꞌa lu të Judas nu Silas parë guëniꞌi rall lu të ra cusë nazeꞌdë laꞌni cartë nanuaꞌa rall. ");
INSERT INTO zacNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Bëuuꞌ lduꞌu Espíritu Santo nu bëuuꞌ lduꞌu naꞌa parë adë guëdchíꞌbëdiꞌi naꞌa ni tubi lëy dushë guëc të. Sulamëntë runë tucarë gunë të cumplir ra cusë nazeꞌdë laꞌni cartë catë rniꞌi: ");
INSERT INTO zacNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Adë gau të belë shtë ra ma nabëꞌnë mënë ofrecer ziquë ofrendë lu ra ídolo, nu adë gau të rënë, nilë belë shtë ra ma nanadë bëshë́ꞌëdiꞌi rënë, nu adë rquënúdiꞌi të saꞌ të. Talë gapë të lëꞌë të lu grë ra cusë rëꞌ, zia të bien. Ndëꞌë gualú cartë. Guëaꞌnë të con Dios.” ");
INSERT INTO zacNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Iurní bëruꞌu raiꞌ parë ziaꞌa raiꞌ Antioquía. Ndë bëtëá raiꞌ grë ra narialdí lduꞌi dizaꞌquë. Bëdëꞌë raiꞌ cartë guiaꞌa ra mënë nabëdëá ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Iurë biꞌldi rall cartë, nalë́ bëquitë lduꞌu rall nu gurëdchí lduꞌu rall por lo quë naguniꞌi laꞌni cartë. ");
INSERT INTO zacNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas nu Silas bëꞌnë rall recibir tubi pudërë shtë Dios parë guëniꞌi rall ra cusë narac shtuꞌu Dios. Biadiꞌdzë raiꞌ con llëruꞌbë pudërë shtë më. Con zihani diꞌdzë naguniꞌi raiꞌ lu ra narialdí lduꞌi dizaꞌquë, bëaꞌnë ra mënë ni más firmë parë tsanaldë rall shnezë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bëaꞌnë raiꞌ tubi tiempë ciudá Antioquía. Despuësë ra narialdí lduꞌi Jesús bëꞌnë rall despedir lëꞌë raiꞌ parë bëabrí raiꞌ Jerusalén. Guniꞌi rall lu raiꞌ: ―Dushquilli Dios, bidë guëná të lëꞌë naꞌa. Guzëá të con bien. ");
INSERT INTO zacNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silas adë bëabrídiꞌiꞌ Jerusalén; bëáꞌniꞌ Antioquía. ");
INSERT INTO zacNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo con Bernabé bëaꞌnë raiꞌ Antioquía parë guaglaꞌguë guëniꞌi raiꞌ dizaꞌquë lu ra mënë. Con stubi tantë ra nguiu, cagluaꞌa raiꞌ mënë dizaꞌquë shtë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Gudëdë bëldá dzë, iurní Pablo guniꞌi lu Bernabé: ―Cha guiá guëgná hiaꞌa nia gua ra narialdí lduꞌi dizaꞌquë, grë ra ciudá catë biagluaꞌa hiaꞌa ra mënë antsë. ");
INSERT INTO zacNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé guc ldúꞌiꞌ niuaꞌa raiꞌ Juan Marcos ");
INSERT INTO zacNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","perë Pablo adë në́diꞌiꞌ nianaldë Juan Marcos purquë más antsë bësëaꞌnëgá Juan Marcos lëꞌë raiꞌ lugar nalë Panfilia. ");
INSERT INTO zacNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Gudildi diꞌdzë raiꞌ por cuendë rëꞌ nu bësaꞌnë saꞌ raiꞌ. Bernabé biaꞌa Juan Marcos parë ziaꞌa raiꞌ Chipre. ");
INSERT INTO zacNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablo gudili lëꞌë Silas parë tsanaldë Silas lë́ꞌiꞌ. Ra narialdí lduꞌi dizaꞌquë, biadiꞌdzënú raiꞌ lëꞌë më parë gunë më compañi lëꞌë Pablo nu Silas iurná guziaꞌa raiꞌ lu shchiꞌni më. ");
INSERT INTO zacNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Iurní Pablo nu Silas bëruꞌu raiꞌ nu gudëdë raiꞌ regiuni shtë Siria nu Cilicia. Guagniꞌi raiꞌ lu ra narialdí lduꞌi dizaꞌquë parë tsaglaꞌguë rall firmë shnezë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bëdchini Pablo nu Silas guëꞌdchi Derbe nu Listra. Ndë bëdiaꞌguëlú raiꞌ tubi nguiu narialdí lduꞌi dizaꞌquë; lëll Timoteo. Shniꞌa Timoteo na më israelitë; lëꞌë quë lëꞌë rialdí lduꞌi dizaꞌquë. Perë shtadë Timoteo na më griego. ");
INSERT INTO zacNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Grë ra mënë narialdí lduꞌi dizaꞌquë naquëreldë Listra nu Iconio, rniꞌi rall na Timoteo tubi nguiu demasiadë humildë nu zaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Guchi Pablo lu Timoteo parë tsanáldëll lëꞌë raiꞌ. Nu bëꞌnë Pablo circuncidar lëꞌë Timoteo ziquë na custumbrë shtë ra më israelitë. Zni bë́ꞌniꞌ parë adë bëldë́diꞌi më israelitë con lëꞌë Pablo. Grë ra israelitë naquëreldë lugar ni, nanë́ rall shtadë Timoteo nall më griego. ");
INSERT INTO zacNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Grë ra guëꞌdchi nardëdë raiꞌ, ruadiꞌdzënú raiꞌ ra mënë narialdí lduꞌi dizaꞌquë. Quëadiꞌdzë raiꞌ rsunë nabëdëꞌë mëgulë naná cabësë shchiꞌni Dios Jerusalén të parë guëzuꞌbë diaguë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ra mënë narialdí lduꞌi Dios, guc rall más firmë lu ra dizaꞌquë shtë Jesús. Dzë con dzë guaruꞌbë grupë shtë shmënë Dios cadë guëꞌdchi. ");
INSERT INTO zacNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Adë bësáꞌnëdiꞌi Espíritu Santo naluaꞌa raiꞌ dizaꞌquë lu ra mënë naquëreldë regiuni shtë Asia. Por ni gudëdë raiꞌ ra regiuni shtë Frigia nu Galacia parë bëdchini raiꞌ la raya shtë Misia. ");
INSERT INTO zacNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ndë bëꞌnë raiꞌ llgabë niutë́ raiꞌ regiuni shtë Bitinia perë Espíritu Santo adë bësáꞌnëdiꞌiꞌ niutë́ raiꞌ ndë. ");
INSERT INTO zacNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mejurë gudëdë nezë raiꞌ hashtë Misia parë guietë raiꞌ puertë shtë Troas. ");
INSERT INTO zacNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ndë bëluaꞌalú tubi nguiu lu Pablo gueꞌlë. Gunáhiꞌ tubi nguiu më Macedonia. Zuldí mënë ni nu rúnëll ruëguë lu Pablo. Rníꞌill: “Cha regiuni shtë naꞌa Macedonia parë gúnël compañi lëꞌë naꞌa”. ");
INSERT INTO zacNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Iurë gudëdë guná Pablo lëꞌë nguiu, na Lucas nacaquëaꞌa librë rëꞌ, bëdëꞌnë naꞌa preparar viajë shtënë naꞌa parë guziá naꞌa Macedonia purquë Dios cagnaꞌbë lëꞌë naꞌa guëdiaꞌa naꞌa dizaꞌquë parë ra mënë shtë Macedonia. ");
INSERT INTO zacNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Puertë Troas bëdzepi naꞌa laꞌni barcu parë zia naꞌa tubldí laꞌni nisë hashtë Samotracia. Samotracia na tubi dani laꞌni nisëduꞌu. Hashtë stubi dzë bëdchini naꞌa puertë Neápolis. ");
INSERT INTO zacNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","De Neápolis bëruꞌu naꞌa parë Filipos. Filipos na tubi guëꞌdchi más llëruꞌbë lu grë ra guëꞌdchi shtë Macedonia. Quëreldë ra më rumanë ndë, nu grë ra më shtë guëꞌdchi bëꞌnë rall rëspëti lëy shtë ra rumanë. Guquëreldë naꞌa Filipos bëldá dzë. ");
INSERT INTO zacNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Tubi dzë nabëziꞌi lduꞌu mënë, bëruꞌu naꞌa ruaꞌ guëꞌdchi parë bia naꞌa ruaꞌ tubi guëëꞌgu. Ra mënë bëneꞌe rsunë ndë nanú tubi lugar catë ruadiꞌdzënú rall Dios. Lugar ni guzubë naꞌa parë guëniꞌi naꞌa dizaꞌquë lu ra naꞌa nabëdëá ngaꞌli. ");
INSERT INTO zacNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ladi ra naꞌa ni nanú tubi naꞌa lë Lidia. Zéꞌdëll guëꞌdchi shtë Tiatira. Nu rtuuꞌll lari zaꞌquë color moradë. Naꞌa ni gualdí lduꞌi Dios perë adë guënë́diꞌill chu na Jesús. Bëdëꞌë më llgabë parë guasëll nu gualdí ldúꞌull dizaꞌquë nacagniꞌi Pablo. ");
INSERT INTO zacNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Lidia bëriubë nísëll con shfamílill. Iurní guníꞌill lu naꞌa: ―Si talë nanë́ të nahia shmënë Jesús, gulë gudeꞌe lidcha të guëaꞌnë të bëldá dzë. Lidia bë́ꞌnëll ruëguë lu naꞌa hashtë bëdëaꞌnë naꞌa lídchill. ");
INSERT INTO zacNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Guzac naꞌa tubi vueltë iurë zia naꞌa lugar catë guëdiaꞌa diꞌdzënú naꞌa Dios, bëdiaꞌguëlú naꞌa tubi lliguënaꞌa. Nápëll tubi mëdzabë laꞌni ldúꞌull. Rúnëll divini por pudërë shtë mëdzabë. Guníꞌill ra cusë nagac con ra mënë. Zni bë́ꞌnëll gan zihani dumí parë ra shlámëll. ");
INSERT INTO zacNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Lliguënaꞌa ni bidë náldëll lëꞌë naꞌa con Pablo. Fuertë guníꞌill: ―Dios nacabezë gubeꞌe, bësheꞌldë më ra nguiu rëꞌ. Cagluaꞌa rall nezë parë gac salváraꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Zihani dzë bëꞌnë lliguënaꞌa rëꞌ zdëꞌë. Glli, glli, fuertë guníꞌill; bidë náldëll lëꞌë naꞌa. Perë bëldë́ Pablo nu guníꞌiꞌ lu mëdzabë nananú laꞌni lduꞌu lliguënaꞌa: ―Con pudërë nabëneꞌe Jesucristo guiahia, rniaꞌa lul por lë shtë më, bëruꞌu laꞌni lduꞌu naꞌa rëꞌ. Lueguë lueguë iurní bëruꞌu espíritu dzabë. ");
INSERT INTO zacNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Iurë guná shlamë shtë lliguënaꞌa, hiadë nídiꞌi mudë gunë rall gan dumí con pudërë nagúpëll, gunaꞌzi rall Pablo nu Silas. Guagsëaꞌnë rall lëꞌë raiꞌ lu gubiernë nazubë culaꞌni galërë. ");
INSERT INTO zacNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bëagnú rall lëꞌë raiꞌ lu ra juësi nu guniꞌi rall: ―Nguiu rëꞌ na rall mënë israelitë. Cagtsatsu rall mënë ciudá shtë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Cagluaꞌa rall creenci adë nádiꞌi de acuerdë con lëy rumanë. Adë nídiꞌi mudë guianáldaꞌa tëchi rall purquë na hiaꞌa më rumanë. ");
INSERT INTO zacNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Iurní bëdzatsu mënë cuntrë Pablo nu Silas. Gunibëꞌa gubiernë parë bëruꞌu shabë Pablo nu Silas parë bëdëꞌë hiaguë rall lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Despuësë huë́tëꞌ bëdëꞌë hiaguë rall lëꞌë raiꞌ, bëldaguë rall lëꞌë raiꞌ lachiguiꞌbë. Nu gunibëꞌa rall lu carcelërë parë gápëll lëꞌë raiꞌ con cuidadë. ");
INSERT INTO zacNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Iurë bëꞌnë carcelërë recibir Pablo nu Silas, guagsëáꞌnëll lëꞌë raiꞌ hashtë tubi cuartë namás dchiꞌchi. Ndë bë́ꞌnëll segurë; bëgáꞌsëll guëaꞌ raiꞌ laꞌni tablë nalë cepo. ");
INSERT INTO zacNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Iurë guc guëruldë gueꞌlë, lëꞌë Pablo nu Silas quëadiꞌdzënú raiꞌ Dios nu quëuꞌldë ruaꞌ raiꞌ cantë lu Dios. Los de más prësi nananú ndë, caquë́ diaguë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","De repëntë bëdchini tubi llu ruꞌbë nabësëniꞌbi hashtë cimientë shtë lachiguiꞌbë. Grë ra puertë shtë lachiguiꞌbë, bëllaꞌlin nu ra cadënë naliꞌbi guiaꞌa ra prësi, gulaguë rahin lu guiuꞌu. ");
INSERT INTO zacNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Iurní gubani carcelërë; gunall ruaꞌ puertë llaꞌlë rahin. Gulull spadë shtë́nëll parë quínill lo mizmë lë́ꞌëll. Bë́ꞌnëll llgabë grë ra prësi bëlluꞌnë. ");
INSERT INTO zacNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Perë Pablo gunall pë nihunë carcelërë nu fuertë guniꞌi Pablo: ―Adë rguínidiꞌi lë́ꞌël. Grë naꞌa zugaꞌa naꞌa ndëꞌë. ");
INSERT INTO zacNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Lueguë iurní gunaꞌbë carcelërë tubi llni. Guatë́ guëllúꞌnëll catë zugaꞌa ra prësi. Nalë́ rchíꞌchill tantë rdzë́bëll. Bëzullíbill lu Pablo nu Silas. ");
INSERT INTO zacNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Iurní gulull lëꞌë raiꞌ lachiguiꞌbë nu gunaꞌbë díꞌdzëll lu raiꞌ: ―Dadë, guniꞌi lua ¿lla guna parë gac salvara? ");
INSERT INTO zacNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Iurní repi raiꞌ: ―Guëdubinú ldúꞌul tsaldí ldúꞌul Jesucristo, lë́ꞌël con grë shfamílil parë gunë Dios salvar lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Iurní biadiꞌdzënú Pablo nu Silas lëꞌë carcelërë dizaꞌquë, lë́ꞌëll con grë shfamílill naquëreldë lídchill. ");
INSERT INTO zacNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mizmë gueꞌlë ni carcelërë gudíbill lu ridë catë bëdiaꞌa hiaguë ladi raiꞌ. Lueguë carcelërë con shfamílill bëriubë nisë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Iurní biaꞌa carcelërë lëꞌë raiꞌ lídchill parë bëdë́ꞌëll nagudáu raiꞌ. Nalë́ rquitë lduꞌu shfamili carcelërë purquë grë rall hia gualdí lduꞌu rall dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Brëgueꞌlë rsili, ra gubiernë bësheꞌldë ra suldadë lu carcelërë parë guëdëꞌë carcelërë libertá lëꞌë Pablo nu Silas. ");
INSERT INTO zacNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Repi carcelërë lu Pablo: ―Bëdchini suldadë shtë gubiernë parë guënehia libertá lëꞌë të. Iurneꞌ guziaꞌa të con bien. ");
INSERT INTO zacNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Perë Pablo guniꞌi lu ra suldadë: ―Adë chu guëruꞌu. Ra gubiernë bëꞌnë bëdiaꞌa hiaguë naꞌa lu ra mënë. Adë bë́ꞌnëdiꞌi rall juzgar lëꞌë naꞌa según lëy rumanë, nu nadapë naꞌa lo mizmë derechë nanapë më rumanë. Bëtiaꞌa rall lëꞌë naꞌa lachiguiꞌbë nu iurneꞌ rac shtuꞌu rall cu të lëꞌë naꞌa llgaꞌchi. Pues guidë ldu rall lëꞌë naꞌa lo mizmë lëꞌë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ra suldadë bëaguënú rall rsunë lu ra gubiernë grë naguchi Pablo lu rall. Bëdzëbë ra gubiernë iurë bini rall Pablo nu Silas napë rall derechë cumë më rumanë. ");
INSERT INTO zacNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Gua ra gubiernë ruaꞌ lachiguiꞌbë. Guadiꞌdzënú rall lëꞌë Pablo nu Silas; guniꞌi rall: ―Gulë bëꞌnë dispensar lëꞌë naꞌa por lo quë nabëdëꞌnë naꞌa. Iurní bëgú rall lëꞌë raiꞌ. Guniꞌi rall: ―Gulë bëꞌnë favurë; gulë bëruꞌu guëꞌdchi shtë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Bëruꞌu Pablo nu Silas lachiguiꞌbë parë ziaꞌa raiꞌ lidchi Lidia. Despuësë guniꞌinú raiꞌ lu ra narialdí lduꞌi dizaꞌquë; guniꞌi raiꞌ: ―Gulë gac firmë con diꞌdzë shtë Jesús. Iurní bëruꞌu raiꞌ ciudá ni. ");
INSERT INTO zacNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Gudëdë Pablo nu Silas ra guëꞌdchi nalë Anfípolis nu Apolonia parë bëdchini raiꞌ ciudá Tesalónica. Ndë zubë tubi iáduꞌu shtë ra më israelitë. ");
INSERT INTO zacNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ziquë na custumbrë shtë Pablo, guáhiꞌ iáduꞌu. Tsunë llmalë bë́ꞌniꞌ parë guagniꞌinull ra mënë cadë dzë descansë. ");
INSERT INTO zacNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Bíꞌldiꞌ laꞌni Sagradas Escrituras lu ra mënë. Nu bëluáꞌaiꞌ ra mënë Cristo napë quë gati më nu despuësë de guti më, napë quë tsashtë́ më ladi ra tëgulë. Rniꞌi Pablo: ―Lo mizmë Jesús nacagniaꞌa lu të, na më Cristo el quë nagudili Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bëldá ra më israelitë gualdí lduꞌu rall dizaꞌquë nu bëtsaꞌguë rall Pablo nu Silas. Zihani më griego narunë adorar Dios, gualdí lduꞌu rall, nu zihani naꞌa tseꞌlë ra më ruꞌbë narnibëꞌa, gualdí lduꞌu rall shtiꞌdzë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Perë los de más ra më israelitë nanadë rialdídiꞌi lduꞌi dizaꞌquë, nalë́ bëldënú rall Pablo nu Silas. Gudili rall bëldá nguiu mal nandigá canzë́ ra nezë. Guniꞌi rall lu mënë ciudá parë guëasë mënë cuntrë Pablo. Guatsutë́ rall lidchi Jasón. Ziatili rall Pablo nu Silas purquë nanë́ rall Jasón bëdëꞌë lugar quëreldë Pablo nu Silas. Rac shtuꞌu rall guënaꞌzi rall lëꞌë raiꞌ parë gunë rall intriegu lëꞌë raiꞌ lu ra mënë parë gunë rall juzgar lëꞌë raiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Perë adë bëdzélëdiꞌi rall lëꞌë raiꞌ lidchi Jasón. Iurní guacaꞌa rall Jasón; bëshaguiú rall lë́ꞌëll con sëbëldá ra narialdí lduꞌu dizaꞌquë. Guagsaꞌnë rall lëꞌë raiꞌ lu gubiernë shtë ciudá. Gurushtiá ra nguiu mal. Guniꞌi rall: ―Guëdubi lugar catë riutë́ Pablo rdzatsu ra më guëꞌdchi con ra creenci shtë rall nu zeꞌdë rall guëꞌdchi rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasón bëdëꞌë lugar lídchill parë lëꞌë rall. Grë ra nguiu rëꞌ nanú rall cuntrë lëy shtë César purquë rniꞌi rall napë rall stubi rëy nalë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Iurë bini ra mënë ra cusë naguniꞌi rall, bëdzatsu rall. ");
INSERT INTO zacNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Perë Jasón con sëbëldá nagunaꞌzi rall, gudilli rall dumí parë gupë rall libertá. Bëruꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ra narialdí lduꞌi dizaꞌquë naquëreldë Tesalónica, lueguë lueguë gugueꞌlë gulú nezë rall lëꞌë Pablo nu Silas. Ziaꞌa rall guëꞌdchi Berea. Zíquësë bëdchini rall ndë, gua rall iáduꞌu shtë ra më israelitë. ");
INSERT INTO zacNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mënë naquëreldë ndë, más nabënë na rall quë ra israelitë naquëreldë Tesalónica purquë guëdubinú lduꞌu rall bëquë́ diaguë rall dizaꞌquë naguniꞌi Pablo, nu glli glli bëꞌnë rall saber niaꞌa gu nahin verdá cumë ziquë na laꞌni Sagradas Escrituras. ");
INSERT INTO zacNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","De manërë quë zihani nguiu israelitë nu më griego, gualdí lduꞌu rall dizaꞌquë. Nu zihani naꞌa tseꞌlë ra më ruꞌbë, gualdí lduꞌu rall dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tsana bini ra contrari naquëreldë Tesalónica de quë nanú Pablo guëꞌdchi Berea, gua rall hashtë Berea parë guagtsatsu rall ra mënë guëꞌdchi ni. Cagniꞌi Pablo dizaꞌquë lu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Perë ra narialdí lduꞌi Jesús, lueguë bësheꞌldë rall lëꞌë Pablo hashtë ruaꞌ nisëduꞌu. Niétiquë Silas nu Timoteo bëaꞌnë rall guëꞌdchi Berea. ");
INSERT INTO zacNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ra naguaguëꞌnë compañi lëꞌë Pablo, guagsaꞌnë rall Pablo ciudá Atenas. Bëabrinú rall rsunë shtë Pablo; rac shtúꞌuiꞌ tsa rall Atenas. Lueguë guziaꞌa Timoteo nu Silas catë nanú Pablo. ");
INSERT INTO zacNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mientras cabezë Pablo lëꞌë Silas nu Timoteo ciudá Atenas, nalë́ adë bëuuꞌdiꞌi ldúꞌiꞌ; adë gurëdchí ldúꞌiꞌ iurë gunáhiꞌ lu zihani ídolo narunë ra mënë adorar. ");
INSERT INTO zacNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Laꞌni iáduꞌu shtë ra më israelitë biadiꞌdzënú Pablo con los de más mënë narunë adorar Dios. Nu cadë dzë rniꞌi Pablo lu ra mënë lu llguëaꞌ catë rdëá rall. ");
INSERT INTO zacNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bëldá ra nguiu naná rsëꞌdë ldaiꞌ shtë narniꞌi rall estoicos nu sëbëldá nguiu naná rsëꞌdë ldaiꞌ narniꞌi rall epicúreos, biadiꞌdzënú rall Pablo. Nanú rall guniꞌi lu saꞌ rall: ―¿Pë quëadiꞌdzë ndë tantë ruadíꞌdzëll? Sëbëldá rall guniꞌi: ―Lluaꞌa naꞌa diꞌdzë shtënë stubi dios cubi quëadíꞌdzëll. Rniꞌi rall zni purquë bini rall Pablo cagniꞌi dizaꞌquë shtë Jesús, chu na më nu Dios bëldishtë́ lëꞌë Jesús ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Iurní biaꞌa rall lëꞌë Pablo tubi lugar nalë́ Areópago catë rdëá ra më ruꞌbë parë guëquë́ diaguë rall pë rniꞌi ra mësë. Ndë guniꞌi rall lu Pablo: ―Rac shtuꞌu naꞌa gac bëꞌa naꞌa pë runë cuntienë ra ldaiꞌ cubi nazeꞌdënul. ");
INSERT INTO zacNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Rníꞌil lu naꞌa ra cusë cubi na nunquë gáꞌadiꞌi guini naꞌa. Rac shtuꞌu naꞌa gac bëꞌa naꞌa pë na ra cusë naruadíꞌdzël. ");
INSERT INTO zacNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Zni guniꞌi rall purquë grë më Atenas nu ra më de stubi naciuni naquëreldë ndë, rëuuꞌ lduꞌu rall cualquier cusë cubi. Llëduni tiempë hiadë ruadiꞌdzë rall stubi cusë, niétiquë ra cusë cubi naguërë́ rini rall ruadiꞌdzë lu saꞌ rall. ");
INSERT INTO zacNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Iurní Pablo guasuldí guëláu rall lugar nalë Areópago nu guníꞌiꞌ: ―Lëꞌë të më Atenas, rnahia demasiadë devociuni napë të parë ra dios shtë të ");
INSERT INTO zacNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","purquë tsana canzë́a, rbíꞌahia lugar catë cabezë ra dios shtë të. Bëdiaꞌguëlúa tubi bëcuꞌguë naquë́ tubi letrërë luhin narniꞌi: “Dios nagáꞌadiꞌi chu guënë́diꞌi”. Pues Dios naquëhunë të adorar sin quë guënë́diꞌi të, nanë́a Dios rëꞌ. Zeꞌdë guëniaꞌa dizaꞌquë shtë më. ");
INSERT INTO zacNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Na më Dios nabëntsaꞌu guë́ꞌdchiliu nu grë ra cusë nananú laꞌnin. Rnibëꞌa më guë́ꞌdchiliu nu gubeꞌe. Adë quëréldëdiꞌi më laꞌni iáduꞌu nabëntsaꞌu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Adë rquíꞌnidiꞌi më ra cusë naruntsaꞌu ra mënë. Niétiquë pë rquiꞌni më purquë mizmë Dios rneꞌe vidë nu grë cusë narquiꞌni hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Grë ra mënë nanarë́ lu guë́ꞌdchiliu na rall shini Adán, nguiu nabëntsaꞌu Dios iurë bësinlú më guë́ꞌdchiliu. Bëꞌnë Dios punërë ra tiempë naguëbani grë ra naciuni nu lugar catë guëquëreldë mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Bëꞌnë Dios ni parë quili ra mënë lë́ꞌiꞌ purquë rac shtuꞌu më grë mieti guëdiaꞌguëlú rall lëꞌë më. Dios adë núdiꞌi zitu de lëꞌë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Por voluntá shtë Dios nacabezë gubeꞌe, nadápaꞌa vidë nu por lëꞌë më rniꞌbi hiaꞌa nezë rëꞌ nezë rëꞌ. Por lëꞌë më quëréldaꞌa guë́ꞌdchiliu. Por voluntá shtë më nabániaꞌa nu rdë́ꞌnaꞌa dchiꞌni. Lo mizmë guniꞌi ra bëldá mësë shtë të: “Na hiaꞌa shini Dios”. ");
INSERT INTO zacNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ziquë shini Dios, adë chu gunë llgabë de quë na më cumë ziquë ra dzanë naguctsaꞌu con orë u bëdchichi u guëꞌë. Mënë runtsaꞌu rall cusë ni ziquë na shgabë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Adë pë guniꞌi Dios lu ra mënë tiempë guahietë tsana gáꞌadiꞌi guënë́ rall lëꞌë më perë iurneꞌ sí, rnibëꞌa më lu mënë gudubi guë́ꞌdchiliu, gunë nadzëꞌë mudë nanabani rall nu guëabrí lduꞌu rall con Dios ");
INSERT INTO zacNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","purquë Dios hia bëꞌnë më designar tubi dzë nagunë më juzguë ra mënë. Dios gulë́ tubi nguiu nagunë juzguë grë mënë lu guë́ꞌdchiliu. Verdá nahin purquë bëldishtë́ Dios nguiu rëꞌ ladi ra tëgulë. ");
INSERT INTO zacNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Iurë bini ra mënë lo quë naguniꞌi Pablo de quë tsashtë́ ra tëgulë, nanú rall bëꞌnë burnë. Sëbëldá rall guniꞌi rall lu Pablo: ―Mejurë stubi dzë guëquë́ diaguë naꞌa ra shtíꞌdzël. ");
INSERT INTO zacNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Iurní Pablo gubiꞌ. Bësëaꞌnëgáhiꞌ lëꞌë ra mënë, ");
INSERT INTO zacNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","perë bëldá rall gualdí lduꞌu rall dizaꞌquë nu guanaldë rall Pablo. Ladi ra mënë ni nanú tubi nguiu lë Dionisio. Nall miembrë shtë partidë Areópago. Nu nanú tubi naꞌa lë Dámaris con zihani ra nagualdí lduꞌu dizaꞌquë shtë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Despuësë de ni, bëruꞌu Pablo Atenas parë ziáꞌaiꞌ ciudá Corinto. ");
INSERT INTO zacNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ndë bëdiaꞌguëlúhiꞌ tubi më israelitë; lëll Aquila. Zeꞌdë nguiu rëꞌ tubi regiuni nalë Ponto. Antsë Aquila nu tséꞌlëll Priscila gubiꞌ rall Italia purquë rëy Claudio gunibëꞌa guëruꞌu grë́tëꞌ më israelitë ciudá Roma. Pablo guagná lëꞌë Aquila lídchiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Cumë nápiꞌ mizmë dchiꞌni nanapë Aquila bëáꞌniꞌ lidchi Aquila parë bëꞌnë raiꞌ dchiꞌni. Bëtiꞌbë raiꞌ lari naꞌldë naguëlluiꞌi parë hiuꞌu lari. ");
INSERT INTO zacNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ra dzë narziꞌi lduꞌu mënë, Pablo ria iáduꞌu catë riagníꞌiꞌ dizaꞌquë lu ra mënë. Zihani rall gualdí lduꞌu rall naguniꞌi Pablo, më israelitë nu ra nanádiꞌi më israelitë. ");
INSERT INTO zacNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Tsana bëruꞌu Silas nu Timoteo regiuni Macedonia, bëdchini rall Corinto. Iurní Pablo bësëaꞌnëgall dchiꞌni shtënë lari naꞌldë parë guagláꞌguiꞌ niétiquë dchiꞌni shtë dizaꞌquë. Guniꞌinúhiꞌ më israelitë quë Jesús na Cristo el quë nacabezë rall të guëdchíniꞌ guë́ꞌdchiliu. ");
INSERT INTO zacNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Perë ra israelitë bëꞌnë rall cuntrë Pablo nu guniꞌi rall diꞌdzë fier guëc Pablo. Repi rall: ―Zeꞌdë guësiguël lëꞌë naꞌa con bishi nanuáꞌal. Iurní Pablo bëdchíbiꞌ shábiꞌ lu ra mënë; nu guníꞌiꞌ: ―Hia beldë guëniaꞌa dizaꞌquë shtë Jesús lu të. Adë në́diꞌi të guaꞌa tëhin. Adë nahia responsablë talë guëniti almë shtë të. Iurneꞌ guziahia lu ra më nanádiꞌi më israelitë. ");
INSERT INTO zacNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Bëruꞌu Pablo iáduꞌu. Ziáꞌaiꞌ lidchi tubi nguiu naquëreldë cuꞌ iáduꞌu, lëll Justo nu runë Justo adorar Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Jëfë shtë iáduꞌu lëll Crispo. Gualdí lduꞌu Crispo Jesucristo con grë shfamili Crispo. Nu zihani mënë Corinto bini rall dizaꞌquë nu gualdí lduꞌu rall nu bëriubë nisë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Tubi gueꞌlë Pablo guná lu Jesús. Bëluaꞌalú më lull nu guniꞌi më: ―Adë rdzë́bëdiꞌil. Guaglaꞌguë guniꞌi dizaꞌquë lu ra mënë ");
INSERT INTO zacNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","purquë na quëhuna compañi lë́ꞌël parë adë chu guënáꞌzidiꞌi lë́ꞌël parë quínidiꞌi rall lë́ꞌël. Napa zihani mënë natsaldí lduꞌi dizaꞌquë ciudá rëꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pablo bëaꞌnë tubi izë guëruldë ciudá Corinto parë cagluáꞌaiꞌ dizaꞌquë shtë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Laꞌni ra dzë nacagnibëꞌa Galión; nall gubernadurë shtë regiuni Acaya; ra israelitë bëꞌnë rall cuntrë Pablo nu biaꞌa rall Pablo lu tribunal. ");
INSERT INTO zacNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ndë guniꞌi rall lu gubernadurë: ―Nguiu rëꞌ cagluáꞌall ra mënë nu rialdí lduꞌu mënë shtíꞌdzëll. Rníꞌill lla gunë ra mënë adorar Dios stubi ldaiꞌ naná cuntrë lëy shtë ra më rumanë. ");
INSERT INTO zacNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Hia guzublú Pablo parë guadiꞌdzë Pablo, iurní Galión guniꞌi lu ra israelitë: ―Si talë ndëꞌë rac tratë tubi delitë ruꞌbë ziquë tubi galguti, pues guëquë́ diaga shtiꞌdzë të ");
INSERT INTO zacNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","perë lëdë znídiꞌi. Rac tratë niétiquë lëy shtë të con diꞌdzë nu ra lë nanuaꞌa të. Gulë bëꞌnë rëglë asuntë ni lo mizmë lëꞌë të. Adë nahia juësi shtë ra cusë naquëhunë të. ");
INSERT INTO zacNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Iurní bëgú Galión ra mënë lu tribunal shtë́nëll. ");
INSERT INTO zacNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Grë ra griego gunaꞌzi rall lëꞌë Sóstenes parë bëdëꞌë galnë́ rall delantë lu gubernadurë. Sóstenes nall jëfë shtë iáduꞌu, perë lëꞌë gubernadurë hiadë bë́ꞌnëdiꞌi casë nacanihunë ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bëaꞌnë Pablo zihani dzë ciudá Corinto. Despuësë bë́ꞌniꞌ despedir ra më narialdí lduꞌi dizaꞌquë nu béꞌpiꞌ barcu con Priscila nu Aquila parë ziaꞌa raiꞌ regiuni Siria. Antsë tsepi raiꞌ barcu puertë nalë Cencrea, bëgaꞌa mënë guëc Pablo. Zni bë́ꞌniꞌ cumplir tubi promësë lu Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Tsana bëdchini raiꞌ ciudá Efeso, Pablo bësëáꞌniꞌ lëꞌë Priscila nu Aquila. Guáhiꞌ iáduꞌu shtë ra israelitë. Ndë biadiꞌdzënúhiꞌ ra mënë nardëá. ");
INSERT INTO zacNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ra mënë bëꞌnë ruëguë lu Pablo parë guëáꞌniꞌ más tiempë con lëꞌë rall perë Pablo adë në́diꞌiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Mejurë bë́ꞌniꞌ despedir ra mënë; répiꞌ: ―Rquiꞌni tsahia Jerusalén parë sua pendientë lu laní nazeꞌdë. Con voluntá shtë Dios guëabría stubi vueltë con lëꞌë të. Beꞌpi Pablo barcu. Gubiꞌll Efeso. ");
INSERT INTO zacNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Despuësë bëdchíniꞌ puertë Cesarea nu guall Jerusalén parë guaguë́ꞌniꞌ saludar grë ra narialdí lduꞌi dizaꞌquë ciudá Jerusalén. Lueguë bëagriꞌ parë Antioquía. ");
INSERT INTO zacNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Zihani tiempë guquëréldiꞌ ciudá Antioquía. Despuësë bërúꞌuiꞌ stubi vueltë parë guaguë́ꞌniꞌ visitar ra mënë narialdí lduꞌi Dios regiuni shtë Galacia nu Frigia. Guniꞌinú Pablo lëꞌë rall tsaglaꞌguë rall firmë shnezë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Bëdchini tubi nguiu ciudá Efeso; lëll Apolos. Nall më israelitë. Gúlëll ciudá Alejandría. Nalë́ nasini guëc Apolos parë ruadíꞌdzëll dizaꞌquë shtë Dios. Bien bëluáꞌall nu guasëll Sagradas Escrituras. ");
INSERT INTO zacNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nanëll bidë Jesús guë́ꞌdchiliu parë gunë më salvar ra mënë natsaldí lduꞌi lëꞌë më. Con guëdubinú ldúꞌull bëluáꞌall ra mënë chu na Jesús. Bien nanëll Juan Bautista bëchuꞌbë nísiꞌ ra mënë perë gáꞌadiꞌi guc bë́ꞌadiꞌill ra nacanaldë Jesús rriubë nisë rall ziquë shmënë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos adë bëdzë́bëdiꞌi guníꞌill lu ra mënë laꞌni iáduꞌu, perë iurë bini Priscila nu Aquila naguniꞌi Apolos, gunaꞌbë rall lëꞌë Apolos stubi ladë. Biadiꞌdzënú rall lëꞌë Apolos ra cusë nadë riasë́diꞌill de quë Jesús bëshéꞌldiꞌ Espíritu Santo parë cuezënúhiꞌ lëꞌë mënë narialdí lduꞌi Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Tsana bëꞌnë Apolos llgabë të́dëll regiuni shtë Acaya, ra më Efeso narialdí lduꞌi Dios, bëꞌnë rall compañi lëꞌë Apolos parë tsáhiꞌ ndë. Bëquëꞌë rall tubi cartë lu ra mënë Acaya të parë gunë rall recibir Apolos. Iurë bëdchini Apolos Acaya, nalë́ bë́ꞌnëll compañi ra shmënë Jesús parë cagsëꞌdë rall shtiꞌdzë Dios. Más antsë Dios bëꞌnë compañi lëꞌë rall parë tsaldí lduꞌu rall dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Biꞌldi Apolos laꞌni Sagradas Escrituras lu ra mënë israelitë. Bëluáꞌall de quë Jesús na Cristo nabësheꞌldë Dios lu guë́ꞌdchiliu hashtë guc rall cunformë lo quë naguniꞌi Apolos. ");
INSERT INTO zacNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nanú Apolos ciudá Corinto tsana gudëdë Pablo lugar laꞌni dani parë bëdchíniꞌ ciudá Efeso. Ndë bëdiaꞌguëlú Pablo zihani narialdí lduꞌi dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Repi Pablo lu rall: ―Iurë gualdí lduꞌu të shtiꞌdzë Jesús ¿gu bëꞌnë të recibir Espíritu Santo laꞌni lduꞌu të? Iurní repi rall: ―Ni siquierë bini naꞌa gu nanú Espíritu Santo u nídiꞌi Espíritu Santo. ");
INSERT INTO zacNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Iurní gunaꞌbë diꞌdzë Pablo lu rall stubi vueltë: ―¿Lla bëriubë nisë të? Repi rall: ―Ziquë bëchuꞌbë nisë Juan Bautista ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Iurní guniꞌi Pablo lu rall: ―Juan Bautista bëchuꞌbë nísiꞌ ra mënë iurë bëꞌnë nadzëꞌë rall mudë nanabani rall. Nu guniꞌi Juan lu rall tsaldí lduꞌu rall Jesús naná Cristo naguëdchini despuësë de Juan. ");
INSERT INTO zacNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Iurë bini ra nguiu rëꞌ naguniꞌi Pablo lu rall, bëriubë nisë rall por lë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Bëdchiꞌbë Pablo guiáꞌaiꞌ guëc rall; lueguë bëdchini Espíritu Santo laꞌni lduꞌu rall nu cadë lëꞌë rall guniꞌi rall stubi dizë́. Guniꞌi rall diꞌdzë narunë rall recibir por pudërë shtë Dios. ");
INSERT INTO zacNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ra nabëꞌnë recibir Espíritu Santo na rall cumë ziquë chiꞌbë chupë nguiu. ");
INSERT INTO zacNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Durantë lu tsunë mbehu Pablo gua iáduꞌu shtë ra më israelitë. Guëdubinú ldúꞌiꞌ guniꞌinúhiꞌ ra mënë, nu gualdí lduꞌu rall lo quë nacagniꞌi Pablo. Adë rdzë́bëdiꞌi Pablo. Cagníꞌiꞌ por lëꞌë Jesús tsutë́ mieti catë rnibëꞌa Dios ziquë rëy. Ra mënë bëaꞌnë rall cunformë lo quë naguniꞌi Pablo. ");
INSERT INTO zacNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Perë bëldá më israelitë adë gualdídiꞌi lduꞌu rall shtiꞌdzë Jesús tantë naguëdchi lduꞌu rall. Delantë lu ra mënë guniꞌi rall lëꞌë nezë naquëadiꞌdzë Pablo, na mal. Iurní Pablo biequi lu rall; biáꞌaiꞌ grë ra narialdí lduꞌi dizaꞌquë laꞌni tubi hiuꞌu shcuelë lidchi tubi nguiu lë Tiranno. Ndë bëluaꞌa Pablo lëꞌë ra mënë glli glli. ");
INSERT INTO zacNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Zni guaglaꞌguë bëaꞌnë Pablo chupë izë ngaꞌli, de manërë grë mënë naquëreldë regiuni shtë Asia bini rall dizaꞌquë shtë Jesús. Ra israelitë nu ra nanádiꞌi më israelitë, bini rall shtiꞌdzë Pablo. ");
INSERT INTO zacNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Dios bëdëꞌë pudërë guiaꞌa Pablo parë bë́ꞌniꞌ zihani milagrë ruꞌbë ");
INSERT INTO zacNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","hashtë ra panitë nu ra lari nabëgaꞌldë Pablo, guanú mënë lu narac lluꞌu. Bëac ra narac lluꞌu nu bëruꞌu ra mëdzabë nananú laꞌni lduꞌu ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Perë bëldá ra israelitë canzë́ rall; rgu rall mëdzabë laꞌni lduꞌu ra mënë. Guc lduꞌu rall niacaꞌa dchiꞌni rall lë Dadë Jesús parë nagú rall mëdzabë. Guniꞌi rall lu espíritu mëdzabë: ―Gulë bëruꞌu. Rnibë́ꞌahia lëꞌë të por pudërë shtë Jesús, el mizmë lë́hiꞌ nacagniꞌi Pablo. ");
INSERT INTO zacNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Zni bëꞌnë gadchi shini tubi nguiu israelitë nalë Esceva. Na Esceva tubi jëfë shtë ra bëshuzi. ");
INSERT INTO zacNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Guzac tsana bëꞌnë shini Esceva nagú rall espíritu mëdzabë, bëquebi mëdzabë lu rall: ―Nanë́a Jesús. Nanë́a Pablo perë lëꞌë të ¿chu na të? ");
INSERT INTO zacNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Iurní nguiu nanapë espíritu mëdzabë laꞌni lduꞌi, gunáꞌzill lëꞌë ra shini Esceva. Bëdëꞌë mëdzabë galnë́. Con guëdubi fuërsë shtëll bë́ꞌnëll gan lu guëzá gadchi nguiu. Guc rall ridë. Bëruꞌu guëlluꞌnë rall lugar ni sin shabë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Grë ra naquëreldë ciudá Efeso, bini rall pë guc. Nalë́ bëdzëbë rall nu guniꞌi rall: ―Llëruꞌbë na pudërë shtë Dadë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Iurní zihani ra narialdí lduꞌi dizaꞌquë, bëquebi rall ra cusë mal nabëꞌnë rall antsë. ");
INSERT INTO zacNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nu zihani ra mënë nabësëꞌdë bëlliú, beꞌdënú rall shlibrë rall parë bëzaꞌi rall librë delantë lu ra mënë. Gulú rall prëci shtë librë. Lasaquin cincuenta mili bëllë bëdchichi. ");
INSERT INTO zacNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Zni guaglaꞌguë bërëꞌtsë dizaꞌquë con llëruꞌbë pudërë. Zihani mënë guatë́ rall shnezë Jesús. ");
INSERT INTO zacNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Despuësë de ni, Pablo bë́ꞌniꞌ llgabë parë tsaguë́ꞌniꞌ visitar ra lugar shtë Macedonia nu Acaya parë tsagláꞌguiꞌ viajë shtë́hiꞌ hashtë Jerusalén. Guníꞌiꞌ despuësë de tsáhiꞌ Jerusalén, guziáꞌaiꞌ ciudá Roma. ");
INSERT INTO zacNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Iurní bëshéꞌldiꞌ chupë sáhiꞌ parë Macedonia. Lë rall Timoteo nu Erasto purquë Pablo bëaꞌnë stubi tiempë regiuni shtë Asia. ");
INSERT INTO zacNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Tiempë dzë ni rëasë ra më Efeso cuntrë Pablo por shcuendë dizaꞌquë. ");
INSERT INTO zacNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tubi nguiu lë Demetrio runtsáꞌull dzanë con bëdchichi. Napë rahin figurë shtë iáduꞌu catë cabezë dios nalë Diana narunë ra mënë adorar. Ra mënë naruntsaꞌu dzanë, runë rall gan zihani dumí. ");
INSERT INTO zacNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Bëtëá Demetrio grë ra saꞌll nu ra nanapë lo mizmë dchiꞌni rëꞌ. Guníꞌill lu ra nguiu ni: ―Lëꞌë të Dadë, cumë ziquë nanë́ të nadápaꞌa tubi vidë zaꞌquë; adë pë rúnëdiꞌi faltë parë lëꞌë hiaꞌa purquë segurë na dumí nardchiꞌbë shchiꞌni hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Perë cumë nanë́ të Pablo cagníꞌill lu ra mënë, ra dios naruntsaꞌu ra nguiu nádiꞌin Dios. Zni rialdí lduꞌu zihani mënë, lëdë niétiquëdiꞌi ndëꞌë më Efeso sino quë casi guëdubi regiuni shtë Asia. ");
INSERT INTO zacNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Demasiadë nadzëꞌbë na ndëꞌë purquë shchiꞌni hiaꞌa, zëdchini dzë hiadë nídiꞌi dchiꞌni guëdë́ꞌnaꞌa. Nu lo mizmë iáduꞌu catë cabezë dios Diana, zëdchini tiempë hiadë tsádiꞌi mënë iáduꞌu. Zni gac desprëci pudërë shtë Diana, el quë narunë ra mënë adorar guëdubi guë́ꞌdchiliu. Nanë́ hiaꞌa grë guë́ꞌdchiliu quëhunë rall adorar lëꞌë Diana. ");
INSERT INTO zacNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Iurë bini rall naguniꞌi Demetrio, nalë́ bëldë́ rall. Gurushtiá rall; guniꞌi rall: ―Guëbani Diana dios shtë́naꞌa. Llëruꞌbë na Diana. ");
INSERT INTO zacNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Nalë́ bëdzatsu ra mënë guëdubi ciudá. Gunaꞌzi rall chupë nguiu naquëhunë compañi lëꞌë Pablo. Túbill lë Gayo; stúbill lë Aristarco. Na rall më Macedonia. Bëshaguiú ra mënë lëꞌë Gayo nu Aristarco hashtë lugar catë rdëá mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Guc lduꞌu Pablo niutë́ Pablo lugar ni parë nianiꞌinúhiꞌ ra mënë, perë ra narialdí lduꞌi dizaꞌquë, adë bësáꞌnëdiꞌi rall nia Pablo ndë. ");
INSERT INTO zacNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nu ra bëldá gubiernë shtë Asia nartsaꞌguë Pablo, bësheꞌldë rall rsunë lu Pablo; bëꞌnë rall ruëguë lu Pablo de quë tsutë́diꞌiꞌ ndë. ");
INSERT INTO zacNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Lu juntë shtë ra mënë gurushtiá rall tubi cusë. Stubi tantë rall gurushtiá stubi cusë purquë nalë́ bëdzatsu rall, perë más zihani rall nabëdëá, adë guc bë́ꞌadiꞌi rall rsunë pëzielú bëdëá rall. ");
INSERT INTO zacNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Perë nanú bëldá ra israelitë nacagsini lëꞌë Alejandro parë guëniꞌi Alejandro lu ra mënë favurë shtë ra më israelitë. Alejandro quëhúnëll sëñi con guiáꞌaiꞌ parë guëac dchi ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Perë iurë bëdëꞌë ra mënë cuendë Alejandro náhiꞌ më israelitë, gurushtiá rall ziquë chupë iurë. Guniꞌi rall: ―Guëbani Diana, dios shtë hiaꞌa. Llëruꞌbë na Diana. ");
INSERT INTO zacNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Iurë bësëac dchi prësëntë lëꞌë ra mënë, guníꞌill: ―Lëꞌë të Dadë, grë më guë́ꞌdchiliu nanë́ rall de quë nadápaꞌa iáduꞌu catë cabezë dios Diana. Llëruꞌbë náhiꞌ. Nanë́ të nadápaꞌa dzanë Júpiter nabietë lu gubeꞌe. ");
INSERT INTO zacNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ndëꞌë adë chu rúnëdiꞌi negar. Gulë cuezë; adë pë rúnëdiꞌi të. Adë pë ziaꞌa guë́ꞌnëdiꞌi të. Gulë bëꞌnë llgabë lla gunë të. ");
INSERT INTO zacNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ra nguiu nazeꞌdënú të, adë quëhunë rall ofender nu adë cagniꞌi rall cuntrë dios shtë hiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Talë Demetrio nu ra narunënull dchiꞌni, napë rall dishiꞌbi con stubi mënë, parë ni nanú gubiernë nu nanú ra juësi parë gunë rall rëglë. Ndë cadë lëꞌë rall quili rall derechë shtë rall. ");
INSERT INTO zacNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Perë si talë rac shtuꞌu të stubi cusë, gac rëglin lu juntë perë gaquin legal ");
INSERT INTO zacNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","purquë nanú peligrë parë lëꞌë hiaꞌa gunë gubiernë rumanë acusar lëꞌë hiaꞌa ziquë enemigu shtë gubiernë. Adë nídiꞌi mudë pë guëniꞌi hiaꞌa lu rall pëzielú bëasë ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Iurë gualú guniꞌi prësëntë zdëꞌë, bëtëꞌtsë ra mënë. ");
INSERT INTO zacNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Iurë gualú bëtëꞌtsë ra mënë lu juntë, Pablo gunaꞌbë ra narialdí lduꞌi dizaꞌquë parë guëniꞌinúhiꞌ lëꞌë raiꞌ más enseñansë. Bë́ꞌniꞌ despedir lëꞌë raiꞌ con tubi abrasë parë ziáꞌaiꞌ Macedonia. ");
INSERT INTO zacNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Grë ra lugar shtë Macedonia guaguë́ꞌniꞌ visitar nu guniꞌinúhiꞌ grë ra narialdí lduꞌi dizaꞌquë të tsaglaꞌguë rall firmë lu shnezë Dios. Despuësë ziáꞌaiꞌ parë regiuni Grecia. ");
INSERT INTO zacNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ndë bëáꞌniꞌ tsunë mbehu. Iurní gubiꞌ parë guënáꞌziꞌ barcu nu guziáꞌaiꞌ Siria. Ndë bini Pablo caguili mënë mudë parë gátiꞌ. Hiadë gualúdiꞌi guall con barcu, mejurë bëagriꞌ nezë ziáꞌaiꞌ. Gudë́diꞌ stubi vueltë Macedonia. ");
INSERT INTO zacNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Gadchi nguiu bëꞌnë compañi lëꞌë Pablo; gudchiꞌbëlú rall hashtë ciudá Tesalónica. Lë rall Sópater më Berea. Stubi lë Aristarco. Stubi lë Segundo; na rall më Tesalónica. Stubi lë Gayo më Derbe. Stubi lë Tíquico nu Trófimo nazeꞌdë regiuni Asia. Nu zugaꞌa Timoteo. ");
INSERT INTO zacNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Gulezë rall lëꞌë naꞌa, Pablo nu Lucas, hashtë ciudá Troas. ");
INSERT INTO zacNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Bëdëaꞌnë naꞌa ciudá Felipos hashtë gudëdë laní naráu më israelitë guetështildi sin levadurë. Iurní bëdzepi naꞌa barcu. Guzë́ naꞌa gaꞌi dzë parë bëdchini naꞌa Troas. Ndë bëdëaꞌnë naꞌa gadchi dzë con ra nguiu nacabezë lëꞌë naꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Primërë dzë shtë llmalë bëdëá ra narialdí lduꞌi dizaꞌquë parë bëshullë rall guetështildi parë gáu rall. Zni rëagná lduꞌu rall la Santa Cena. Bëluaꞌa Pablo lëꞌë rall hashtë guëruldë gueꞌlë purquë grëgueꞌlë napë quë guërúꞌuiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Bëdëá rall laꞌni cuartë naná pisë guiaꞌa nu rquëguiꞌi zihani llni laꞌni cuartë. ");
INSERT INTO zacNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ndë zubë tubi sultërë ruaꞌ ventanë shtë cuartë. Lëll Eutico. Por llëduni tiempë guniꞌi Pablo lu ra mënë; sultërë ni gunaꞌzi mbëcaꞌldë lë́ꞌëll. Nilli nagáꞌsill nu dizdë pisë tsunë hashtë lu guiuꞌu guláguëll. Gútill. Gualdishtë́ mënë lë́ꞌëll. ");
INSERT INTO zacNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Iurní Pablo biétiꞌ hashtë catë gulaguë sultërë. Bëaꞌchu Pablo parë gudëdchi Pablo lë́ꞌëll. Iurní guniꞌi Pablo lu ra mënë: ―Adë rdzë́bëdiꞌi të purquë hia bëagrí gubánill stubi. ");
INSERT INTO zacNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Iurní beꞌpi Pablo parë guiaꞌa. Bëshúlliꞌ guetështildi parë gudáuhiꞌ. Nu guaglaꞌguë biadíꞌdziꞌ hashtë brëgueꞌlë. Iurní gubiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ra mënë biaꞌa rall sultërë lídchiꞌ nabániꞌ. Nalë́ gurëdchí lduꞌu rall. ");
INSERT INTO zacNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Lëꞌë naꞌa gudchiꞌbëlú naꞌa con barcu. Bia naꞌa hashtë guëꞌdchi Asón parë biaglliꞌi naꞌa Pablo ziquë guníꞌiꞌ lu naꞌa antsë. Lë́ꞌiꞌ por guëáhiꞌ bëdchíniꞌ Asón. ");
INSERT INTO zacNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Tsana bëdiaꞌguëlú naꞌa lë́ꞌiꞌ Asón, iurní tubsë bëdzepi naꞌa barcu parë zia naꞌa tubi guëꞌdchi nalë Mitilene. ");
INSERT INTO zacNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ndë bëruꞌu naꞌa parë bëdëdë naꞌa brëgueꞌlë cuꞌ tubi dani laꞌni nisëduꞌu lë Quío. Hashtë stubi dzë bëdchini naꞌa puertë nalë Samos. Bëziꞌi lduꞌu naꞌa guëꞌdchi shtë Trogilio. Hashtë stubi dzë bëdchini naꞌa ciudá Mileto. ");
INSERT INTO zacNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Zni bëdëꞌnë naꞌa purquë Pablo adë gunë́diꞌiꞌ nëáꞌniꞌ llëduni tiempë Asia. Adë gunë́diꞌi Pablo nia Pablo Efeso purquë rac shtúꞌuiꞌ guëdchíniꞌ prontë Jerusalén parë súhiꞌ pendientë laní narniꞌi rall Pentecostés. Guc ldúꞌiꞌ nadchinigáhiꞌ. ");
INSERT INTO zacNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Tsana nanú naꞌa ciudá Mileto, gunibëꞌa Pablo guidë ra mëgulë naná cabësë shchiꞌni Dios ciudá shtë Efeso. ");
INSERT INTO zacNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Iurë bëdchini raiꞌ, Pablo guniꞌi lu raiꞌ: ―Lëꞌë të nanë́ të lla mudë gubania dizdë primërë dzë na belda Asia. ");
INSERT INTO zacNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Guëdubi tiempë guquëreldënúa të, bëna sirvë lu Dios galnaduꞌu shtëna. Nu nalë́ gulaguë nisë slua por tantë naguëdchi lduꞌu ra mënë. Quëhuna sirvë lu më bien aunquë zihani vueltë bëꞌnë mënë israelitë cuntrë na. ");
INSERT INTO zacNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Bëluáꞌahia lëꞌë të dizaꞌquë shtë Jesús lidchi të nu catë bëdëá të parë bien shtë të. Ni tubi diꞌdzë shtë Jesús, adë bëcaꞌchi ldúꞌudiaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Rniaꞌa lu ra më israelitë nu lu ra nanádiꞌi më israelitë guëabrí lduꞌu rall con Dios. Guësaꞌnë rall nezë mal nu tsaldí lduꞌu rall Jesucristo, Shtádaꞌa. ");
INSERT INTO zacNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Iurneꞌ guziahia parë Jerusalén purquë Espíritu Santo cagshéꞌldiꞌ na ndë. Más adë guënédiaꞌa cuendë pë saca ndë. ");
INSERT INTO zacNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Niétiquë nanë́a lo quë Espíritu Santo guniꞌi lua de quë grë ciudá catë riahia, gunë ra mënë cuntrë na hashtë lachiguiꞌbë guëtiaꞌa rall na. ");
INSERT INTO zacNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Perë adë bë rníꞌidiaꞌa pë runënú ra mënë na. Niétiquë rac shtuaꞌa guëzalúa dchiꞌni nabëneꞌe Jesús guiahia. Na më Shtada. Napë guëniaꞌa lu ra mënë quë Dios cagnaꞌbë më ziquë tubi favurë grë ra mënë parë gac rall shini më. ");
INSERT INTO zacNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Antsë guniaꞌa lu të lla tsutë́ të nezë lu gubeꞌe catë rnibëꞌa Dios, perë iurneꞌ nanë́a ni tubi de lëꞌë të hiadë guëabrídiꞌi guëná të lua stubi vueltë. ");
INSERT INTO zacNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Rniaꞌa lu grë të, bëna gan lu dchiꞌni nabëneꞌe Dios guiahia. Si talë tubi të adë tsaldídiꞌi lduꞌu të Jesús nu guëniti almë shtë të, adë nádiaꞌa responsablë ");
INSERT INTO zacNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","purquë grë lo quë naguniꞌi Dios lua, guníꞌihia lu të. Ni tubi diꞌdzë adë bëcaꞌchi ldúꞌudiaꞌa de lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Iurneꞌ mizmë lëꞌë të gulë gupë lëꞌë të. Nu gulë gupë ra grupë mënë narialdí lduꞌi dizaꞌquë purquë Espíritu Santo bëꞌnë më punërë lëꞌë të cumë cabësë shtë rall. Por ni gulë bëluaꞌa shtiꞌdzë Jesús lu ra narialdí lduꞌi Jesús. Jesús bëneꞌe më vidë shtë më ziquë prëci parë gac salvar të. ");
INSERT INTO zacNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nanë́a tsana guziahia, guëdchini mësë falsë nagunë dañi ra nacanaldë shnezë Dios. Ziquë ma dushë nardchini llgurrali lliꞌli, rtëꞌtsë ma ra lliꞌli. Zni guëdchini ra mësë falsë ladi të. ");
INSERT INTO zacNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Lo mizmë ladi të guëruꞌu bëldá nguiu naguëluaꞌa bishi lu ra narialdí lduꞌi Jesús parë tsanaldë rall nezë mal. ");
INSERT INTO zacNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Gulë gupë cuidadë nu gulë bësëagná lduꞌu të purquë durantë lu tsunë izë, dzë la gueꞌlë, adë gulézëdiꞌi guniꞌinúa lëꞌë të. Nisë zubë slua bëluáꞌahia lëꞌë të. ");
INSERT INTO zacNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Iurneꞌ guësëana lëꞌë të con Dios nu con dizaꞌquë shtë më. Cagniaꞌa lu të na të bëcha. Nalë́ rac shtuꞌu Dios lëꞌë hiaꞌa. Dizaꞌquë shtë Dios napin pudërë parë tsaldí lduꞌu të más parë gac të firmë lu shnezë Dios. Cagnaꞌba lu më guëneꞌe më grë ra cusë zaꞌquë nanapë më parë ra më nagudili më parë gac rall shini më. ");
INSERT INTO zacNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nunquë adë rzébidiꞌi lduaꞌa dumí parë gaca ricu purquë lëdë parë nídiꞌi cagluáꞌahia lëꞌë të. Nu adë rzébidiꞌi lduaꞌa lari chulë parë gacua. ");
INSERT INTO zacNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Cumë ziquë nanë́ të bëna dchiꞌni con prupi guiahia parë gudilia grë narquiꞌnia nu parë bëdëꞌa narquiꞌni ra naguzënú na. ");
INSERT INTO zacNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Siemprë bëluáꞌahia lëꞌë të napë quë gunë të dchiꞌni parë gunë të compañi ra nanadë bë nápëdiꞌi. Rëagná lduaꞌa diꞌdzë naguniꞌi Dadë Jesús tsana guniꞌi më: “Más rquitë lduꞌu hiaꞌa guëdëꞌë hiaꞌa nacaꞌa mënë, lë́dëdiꞌi guëneꞌe mënë nacaꞌa hiaꞌa”. ");
INSERT INTO zacNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Iurë gualú guniꞌi Pablo ra diꞌdzë rëꞌ, bëzullibi Pablo parë guëniꞌinúhiꞌ Dios. Bëꞌnë Pablo orar con grë ra nabëquë́ diaguë naguniꞌi Pablo. ");
INSERT INTO zacNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Grë rall biꞌni rall 