﻿USE sofia;
DROP TABLE IF EXISTS sofia.zaaNT_vpl;
CREATE TABLE zaaNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zaaNT_vpl WRITE;
INSERT INTO zaaNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Lista nu riquixá'a ti'iỹa cca Jesucristua relacionar làni David nna Abraham nna adí ca enne' gutsé'e tiempo antigua nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham, tàta qui' Isaac. Isaac, tàta qui' Jacob. Jacob, tàta qui' Judá lani ca bettsi' bi. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá nna Tamar nna tàta nàna qui' Fares lani bettsi' bi Zara. Fares, tàta qui' Esrom. Esrom, tàta qui' Aram. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram, tàta qui' Aminadab. Aminadab, tàta qui' Naasón. Naasón, tàta qui' Salmón. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón nna Rahab nna tàta nàna qui' Booz. Booz nna Ruth nna tàta nàna qui' Obed. Obed, tàta qui' Isai. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí, tàta qui' David enne' uccua rey tiempo lania. David, tàta qui' Salomón lani niula nu uccua ya'la qui' Urías. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón, tàta qui' Roboam. Roboam, tàta qui' Abías. Abías, tàta qui' Asa. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa, tàta qui' Josafat. Josafat, tàta qui' Joram. Joram, tàta qui' Uzias. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzias, tàta qui' Jotam. Jotam, tàta qui' Acaz. Acaz, tàta qui' Ezequías. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequias, tàta qui' Manasés. Manasés, tàta qui' Amón. Amón, tàta qui' Josías. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías, tàta qui' Jeconías lani ca bettsi' bi tiempo loti' guche' ca soldadua cą preso hàstaba le' nación Babilonia. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bitola de chi bette cą cą para Babilonia nna gùlia Salatiel ỹi'ni Jeconías. Salatiel, tàta qui' Zorobabel. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel, tàta qui' Abiud. Abiud, tàta qui' Eliaquim. Eliaquim, tàta qui' Azar. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azar, tàta qui' Sadoc. Sadoc, tàta qui' Aquim. Aquim, tàta qui' Eliud. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud, tàta qui' Eleazar. Eleazar, tàta qui' Matán. Matán, tàta qui' Jacob. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob, tàta qui' José nu uccua tsela María. María nna beditsìna' bi Jesús enne' lá huá Cristo. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Asi es qui'ni dèsdeba gùdua Abraham hàstaba bitsina' rey David nna uccua tsità' libixi. Dèsdeba gùdua rey David hàstaba loti' guche' ca soldadua cą Babilonia nna uccua á tsità' libixi. Dèsdeba loti' bette cą cą para país Babilonia hàstaba gùlia Jesucristua nna uccua á tsità' libixi. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Historia qui' Jesucristua loti' gùlie nna uccua íį: María enne' ccá nàna qui' Jesús nna chì' nábabáni José bi. Pero ántesca thi' luetsi cabi nna gutebé'ni María qui'ni por milagro qui' Espiritu Santo nna nùà' bi huatsa to'. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joséa nna labi uccua latsi' bi guni bi biỹa cosa mal, nihua labí uccua latsi' bi gudà bi titsa' qui' María, acca belaba latsi' bi qui'ni adila tsa' gútse'e latsi' bi María sin qui'ni adí ca enne' nna ccá cą saber. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","De chi belaba latsi' bi anía nna, de repente tabá bitsina' ttu ángel enne' guthel·la' Señor Dios lo yèla qui' Joséa nna gunènie bi nna rèe bi: Lu' José descendiente qui' David, bittu gulaba latsi' lu' làa thi' lu' Maríą' para ccą́ niula qui' lu', porqui'ni por la'huacca qui' Espíritu Santo nna nùà' Maríą' huatsa to'. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maríą' nna guditsìna'ą nitu'ą' nna quixa lu' lée JESUS porqui'ni por medio de lèe nna l·lá ca enne' qui'e le' ca tul·la' qui' quį. Anía ra ángelia Joséa. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Iyaba ca cosį nna uccua cą para qui'ni ccá cumplir nu ra Señor Dios lo libro nu bedia ttu profeta quì'e enne' gùdua tiempo antigua nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ttu niula nu labí chi nabia'nią nubeyu' nna hua' ỹi'nį nna guditsìna'ą ttu nubeyu' to'; nitu'į nna gata' lée Emanuel, titsa' qui' ri'u nna ra: DIOS DUE LANI RI'U. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","De bebani Joséa nna beni bi ti'ba beni ángelia bi mandado nna beni bi María recibir. ");
INSERT INTO zaaNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero labi benibia' bi María hàstaba qui'ni bitsina' primero ỹi'ni bi. Gutixa bi lée JESUS. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesucristua nna gùlie le' yetsi Belén estado qui' Judea tiempo loti' rigú'ubia' rey Herodes. Làniana tuchùppa ca enne' yala la' riyeni tsè' te qui' quį, lá cą magos nna bitsina' cą le' ciudad Jerusalén, da' cą idittu' tsè' lado ril·lani bitsa. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ca máguá nna gunaba titsa' cą nna ra cą: Ti'ani uccua enne' chì' gùlia ba rey qui' ca enne' Israel, qui'ni loti' tsè'e tu' látsi tu'a nna bilá'ni tu' bélia nu rulue' qui'ni chi gùlie, acca da' tu' para guni tu' e adorar. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","De bina rey Herodes nu ra ca máguá nna yala nuyue uccuanią ą'hua iyaba canu Jerusalén nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Acca gutaỹi chìą iyaba ca sacerdote principal tsè'e le' ciudad ą'hua ca maestro nu rulue' nu ra lo Escritura qui' caniá nna gunaba titsa'ą cą nna rą: Gani ná qui'ni galia Cristua. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Lacą nna ra cą na: Le' yetsi Belén región qui' Judea, la'a mísmuba estado qui' rí'uį, porqui'ni ą' ra lo libro nu bedia attu enne' gunne parte Tata Dios nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Lu' Belén región qui' Judá, yetsi yala xcuichu to' ná lu', pero adírula dacca' lu' de lo iyaba canu rigú'ubia' qui' Judá, porqui'ni nì galia ttu enne' ichi'e iyaba ca enne' Israel nna hui'e cą cuidado porqui'ni ná cą enne' quia'. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Làniana gutaỹi gattsi' ba Herodes ca máguá nna. Iyá ỹíabani gunaba titsa'ą cą ą'hua tsáliaỹa itsá chi uccua gul·lani bélia. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Guthel·la' tìą cą Belén nna rą: Litsia linaba titsa' tsè' taá gaỹa gulia huatsą'; canchu chi etseláni li e nna, equixá'ani le inte' para qui'ni tsa'a huá' guni ye' e adorar. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","De biyénini cą nu ra Herodes nna dia tè cą. La'yani' qui' bélia nu bilá'ni canaá nna denéruą lo quį hàstaba qui'ni bitsina'ą làti te huátsáa. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","De bilá'ni cą guleda la'yani' qui' bélia nna yala bedácca'ni cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Làniana gutà'a cą le' yú'a nna bilá'ni cą Jesús lani nàna quì'e María, acca bèdu ỹibi quį nna beni cą Jesús adorar. Làniana guleqquia tè cą ca regalo qui' caniá nna bete cą quì'e oro nna incienso nna mirra nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pero ca máguá nna por medio de lo yèla qui' quį nna uccua cą saber qui'ni bittu eyeqquia cą ru'a lo Herodes. Acca lacą nna deyya cą attu neda huaya' la para látsi quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bedà' diba cą nna làniana ángel enne' guthel·la' Señor Dios bitsina' bi lo yèla qui' Joséa attu nna gunènie bi nna rèe bi: Huàtha, guỹi' huatsą' lani nàna quì'ą' nna becuitta huía Egiptua la, nía ba tsé'e le hàstaba qui'ni equixá'ania' lu', porqui'ni Herodes nna eyilą huatsą' para gúttią ne. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Làniana la'a yèla taá huatha Joséa nna guche' bi María lani huatsa nna gudà' cabi dia cabi idittu' tsè' hàstaba le' nación Egiptua. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nía ba gutsé'e cabi hàstaba qui'ni gùtti Herodes. Anía modo nna uccua cumplir nu ra Señor Dios lo libro nu bedia attu profeta quì'e nna rèe: Egiptua la beyáỹia' ỹi'ni ya'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","De gutelíni Herodes qui'ni uccua bą́ burla por ca máguá nna yala bitsa'ánią nna benią mandado gatti iyaba ca nubeyu' to' nu chì' bitsina' taá hàstaba nu chuppa idani le' yetsi Belén ą'hua le' iyaba ca yetsi to' anta' exa taá nía, de acuerdo lani fecha nu chi ra ca máguá na. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Anía modo nna uccua cumplir ca titsa' nu ra Tata Dios lo libro nu bedia Jeremías attu enne' uccua profeta quì'e nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Biyéniní le' yetsi Ramá ribetsi ca descendiente qui' Raquel enne' gùdua tiempo antigua; yala dìtsa ribetsi cą nna rehuiní'ni cą, pero labí uccua latsi' quį etáni cą la'ỹeni, porqui'ni gùtti ca ỹi'ni to' qui' caniá. Ą' bedia profétaá. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Gùtti diba Herodes nna gudu ángelia attu lo yèla qui' Joséa loti' tsè'e ru cabi Egiptua. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Gunènie bi nna rèe bi: Huàtha nna beche' huatsą' lani nàna quì'ą' para región qui' Israel, porqui'ni chìa gùtti canu uccua latsi' quį gútti cą huatsą'. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Làniana huatha taá Joséa nna beche' bi María lani huátsáa nna deyya cabi para región qui' Israel. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","De bina Joséa qui'ni Arquelao ỹi'ni Herodes rigú'ubi'ą le' región qui' Judea parte ta' tàta qui' niá nna, gùtsibáni bi eya'a bi nía. Pero por medio de lo yèla qui' bi nna uccua bi saber qui'ni adila tsa' tsía bi región qui' Galilea. ");
INSERT INTO zaaNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Bitsina' bi nía nna gùdua bi le' ttu yetsi lá Nazaret. Anía modo nna uccua cumplir ca titsa' qui' Tata Dios nu gune ca profeta qui'ni ą'hua gata' lée Enne' Nazareno. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Làniataá nna gudulo Juan el Bautista hueni predicar fuera ca yetsi canu anta' le' itúbani región qui' Judea. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ra bi ca enne': Liguni reconocer qui'ni ná le enne' tul·la', porqui'ni chi' tení duą il·lani tsá qui'ni Tata Dios nna cu'úbia'nie ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Qui' Juan nì nuá gutixà'a Tata Dios lo libro nu bedia profeta quì'e Isaías enne' gùdua tiempo antigua nna rèe: Ruyeni ttu enne' fuera yetsi nna ra bi: Litsé'e leda porqui'ni chi da' Señor; liutha' lí ca neda qui' la'labani qui' le para lèe. Ą' bedia profétaá. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nu guccu' Juan nna uccuą de ittsa' ỹo camello, ą'hua guthi lè'e bi ttu cincho nu de yeti. Uccuabàni tèni bi tsuą' teruba ttu clase de guxaru' ą'hua ỹixi qui' i'yatò'. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ca enne' ciudad qui' Jerusalén ą'hua itúbani Judea nna iyaba adí ca yetsi to' anta' exa taá yò Jordán nna huía cą ru'a lo bi. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Juan nna beni bi cą bautizar le' yò Jordán porqui'ni beni cą reconocer ca tul·la' qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","De bilá'ni Juan qui'ni iỹetse' canu lání religión fariseo nna saduceo nna dia cą para gugadia bi cą inda, acca ra bi cą: Yala mañoso ná le tì'a ca bèl·la. Nuni rą le qui'ni huaccani le ucuìttani le la' tsìalatsi' qui' Tata Dios nu chì' da'la cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Liulue' lani ca hecho tsè' qui' le canchu là hualigani chi beyacca le arrepentir. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Alàa chì' gutsia la le pretexto nna ina le: Yala enne' tsè' ná tu', porqui'ni ná tu' descendiente qui' ta' enne' gùla qui' tu' Abraham. Pues inte' nna nia' le qui'ni hàstaba ca íyya anta' nì nna huaccani Tata Dios gunie qui'ni eyacca cą ỹi'ni Abraham. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ą'hua chi du leda yètte para ichuą ca yaga dèsdeba l·lú quį; ą'hua iyaba ca yà nu labí runna fruto tsè' nna chú cą tsía cą lo yi'. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Inte' nna hualigani runia' le bautizar lani inda canu reyacca arrepentir. Pero enne' da' bitola de inte' nna adí la'huacca te quì'e tì'chula inte', acca nìdirubani làa dàcca'a' para cueqquia' ca guarachu yù'u nì'e. Lèe nna gunie le bautizar lani Espíritu Santo nna la'huacca tì'a yi'. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ą'hua dènie pala para guthúe ỹua' nu re' lo tsinà' quì'e. Ỹua'xtíla nna gunie na seguro le' yú'u, pero tébáỹua nna gudàl·lèe na lo yi' làti nunca labí eyolą. Anía gunèni Juan ca enni'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Làniana gudà' Jesús Galilea nna díe para yò Jordán làti reqquia Juan, para guni bi e bautizar. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero Juan nna ridúdítsi ba bi nna ra bi e: Inte' la riquina' te' ccá' bautizar por cuią'lu', atsi'íni cuią'lálu' da' ru'a lua' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Becabi Jesús nna rèe bi: Oba gunà guni lu' inte' bautizar porqui'ni ą'ba ná tsè' para guni ri'u cumplir iyábani nu rú'ulatsi' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","De beyacca uccua Jesús bautizar nna beria tìe le' inda, làniana biyàlia ỹiabara' nna bilá'ni Juan qui'ni Espíritu Santo nna huadie ti'ba ttu becha to' nna bitsine'e iqquia Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Làniana biyéniní tsì'i ttu enne' gune de ỹiabara' nna rèe: Là enni'į enni'ą' Ỹì'nia' yala catsi'i ti' e, ą'hua por lèe nna yala la' redacca'latsi' te quia'. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Làniana por medio de Espíritu Santo nna huía Jesús ttu lugar idittu' fuera yetsi para qui'ni numalua nna gunią ne tentar canchu xiaba irialànią gunie nu calatsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nía nna beni Jesús ayunar nna labí gutúe chua' ubitsa nna chua' yèla nna. Bitola nna yala gutùnie. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Làniana bitsina' nu huethacca'ỹía nna rą ne: Canchu hualigani ná lu' Ỹi'ni Tata Dios nna gùtsi ca íyya anta' quį qui'ni eyacca cą ettaxtíla. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Becabi Jesús nna rèe na: Escrítuba ga'na qui'ni alàa tsuą' teruba lani ettaxtíla ccabaniní ca enne', sino ą'hua lani iyábani ca titsa' riria rú'a Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Làniana numalua nna guche' tìą ne le' Jerusalén ciudad nu ná para Tata Dios nna beduą ne iqquia torre qui' templua nna ");
INSERT INTO zaaNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","rą ne: Canchu hualigani ná lu' Ỹi'ni Tata Dios nna bittsía tsanna de nì para loyu nna, porqui'ni escrítuba ga'na qui'ni Tata Dios nna ithel·le'e ca ángel quì'e para gudaxu' cą lu' lo ná' quį para qui'ni làa itsina' nì'a lu' lo íyya nna ccadí' qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Becabi Jesús nna rèe na: Ga'na huá escrito làti ra qui'ni: Bittu guni lu' tentar Tata Dios qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Numalua nna guchi'ą ne attu lo ttu i'ya xeni tsè'ni nna belue'nią ne ituba làti bána'nią le' yétsiloyu lani ituba riqueza quì'į nna, ");
INSERT INTO zaaNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ra tìą ne: Iyaba ca nui nna gunna ya' cą qui' lu' canchu gudu ỹibi lu' nna guni lu' inte' adorar. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús nna ra tìe na: Becuitta ru'a lua' Satanás, porqui'ni escrítuba ga'na qui'ni guni ri'u adorar ttu teruba Señor Dios qui' ri'ua a'hua la terúbée guni ri'u servir. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Betha'na tè numalua ne nna becuittą. Làniana bitsina' ca ángel de ỹiabara' ru'a lo Jesús nna beni cabi e servir. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bina ba Jesús qui'ni te Juan litsi' ìyya, acca labiru gùdue nía sino beyeqquia lée para Galilea hàstaba látsie Nazaret. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Làniana bedè'e Nazaret nna huíe ru'a indatù'a gùdue le' yetsi Capernaum le' región qui' Zabulón nna Neftalí nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Anía modo nna uccua cumplir nu ra Tata Dios lo libro nu bedia profeta quì'e Isaías nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Látsi Zabulón nna Neftalí nna, neda ru'a indatò', attu ládulá yò Jordán, Galilea región qui' canu labí ná raza Israel. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yetsi nu re' le' chul·la nna chi bilá'nią iỹeni la'yani', làti tsè'e ca enne' le' ỹula qui' lu'uti nna huàni' rábani la'yani' para lacą. Anía ra lo libro qui' profeta Isaías. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Dèsdeba lania nna gudulo Jesús hueni predicar nna rèe: Leyacca arrepentir por ca tul·la' qui' le porqui'ni annana calatsi' Tata Dios qui'ni ca enne' nna hue'él·la' cą qui'ni quée enne' cu'úbia'nie cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","De reqquia Jesús ru'a indatò' qui' Galilea nna, bilá'nie chuppa ca enne': Simón enne' lá Pedrua lani bettsi' bi Andrés rudal·la cabi exxa le' inda porqui'ni uccua cabi nu huedaxu' bél·lá. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Rèe cabi: Lità lani inte', inte' nna gunia' qui'ni ca enne' la guni le pescar. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Làcabi nna betha'na taá cabi ca exxa nu rudaxu'ní cabi bél·lá nna dia taá cabi lani e. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Gutte diba Jesús nía nna bilá'nie áchuppa ca enne': Jacóbua lani bettsi'į Juan yù'u cabi le' ttu barco lani tàta qui' cabi Zebedéua reyuni cabi ca exxa nu rudaxu'ní cabi bél·lá. Jesús nna gutàỹie cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Biyeni báni cabi qui'ni rinnie cabi nna betha'na taá cabi bárcuá nna tàta qui' cabía nna dia taá cabi lani e. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Làniana gurèni Jesús ituba Galilea nna gutè'e le' ca sinagoga làti retuppa canaá nna bethète' tènie cą nna bènie predicar ca titsa' cubi nu cca qui' la' rigú'ubia' qui' Tata Dios. Ą'hua gùtue iyábani ca itsahue' ą'hua iyábani clase de dolor qui' ca enne' le' ca yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Gudà tè titsa' quì'e itúbani región lą́ Siria. Acca tahua' cą ru'a lúe iyaba canu ra'ni para eyunie cą: canu rappa cą biỹa tediba dolor nna canu cca sufrir bíỹaáru itsahue' ni nna, ą'hua canu cca padecer por ca espíritu mal nna canu yù'u be', ą'hua ca paralítico canu chi gutsání ra'ni cą nna, tahua' cą iyaba cą ru'a lúe. Lèe nna beyúninìe iyaba cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Enne' ỹétse'ní nna gudulo cą dia cą lani e: ca enne' Galilea nna Decápolis nna, ą'hua qui' Jerusalén nna ituba región qui' Judea nna hàstaba ca enne' qui' attu ládulá yò Jordán nna denó huá cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","De bilá'ni Jesús ca enne' ỹétse'á nna huàppie lo í'yaá nna gùre' bánie nna bebiga' tè ca enne' ruthète'niáa ru'a lúe. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Gudulo tìe riquixa'ánie cabi ca enseñanza tsè' nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ica'rubà canu chi yù qui'ni riquína'ni cą la'ỹeni lo losto' quį; pues quì'ba quį ná iyate nu runna Tata Dios enne' rigú'ubia'nie cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ica'rubà canu ribetsi; porqui'ni lacą nna huetáni cą la'ỹeni. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ica'rubà canu ná ỹénlatsi' losto' quį; porqui'ni huadi' bá cą lóyu nu beni Tata Dios prometer para lacą. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ica'rubà canu yala calatsi' quį gata' ttu la'labàni tsè' qui' quį tì'a calatsi' Tata Dios; pues lèe nna gúnie cą cualani para guni cą nu ná tsè'. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ica'rubà canu té la' retúalatsi' qui' quį lani adí ca enne'; porqui'ni lacą nna huàl·la' huá cą la' retúalatsi'á. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ica'rubà canu labí bèỹia té lo losto' quį delante de Tata Dios; pues lacą nna hualá'ni cą lúe. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ica'rubà canu runi qui'ni étse'etsè' ca enne'; porqui'ni huata' lá quį ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ica'rubà canu cca padecer por la' ruyudí' qui' ca enne' por causa de qui'ni runi cą nu ná tsè'; porqui'ni qui'ba quį ná iyate nu runna Tata Dios enne' rigú'ubia'nie cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ica'rubà le canchu chi inne ca enne' bicca'áỹa titsa' mal ni contra le nna gutsia latsi' quį le porqui'ni denó le inte', ą'hua bèyalo báni ná nu ina cą contra le nna runi latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ledácca' láni le; porqui'ni gudàliani Tata Dios le ỹiabara'. Porqui'ni ą'hua ca enne' nu gutsé'e ttu cuaỹa nuá nna betsiahuá latsi' quį ca enne' uccua profeta qui' caniá. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Lebi'į nna ná le dete' para yétsiloyu. Canchu dèti'á gunittią la' iỹe' quì'į nna, biála lani eyaccanią iỹe' attu vuelta cá. Labiru biỹa íỹu'ą sino para iru'na terubą fuera para gúl·liani ca enne' na. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Lebi'į nna ná le la'yani' para yétsiloyu. Ttu yetsi re' lo ttu i'ya nna labí modo té igàtsi'ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nihua labí rugàl·la' ri'u ttu yi' nna rutòthe' tè ri'u ttu cajón lúį, sino qui'ni gudua la ri'u ą ttu lugar làti gudàni'ą qui' iyábani ca enne' tsè'e le' yú'u. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ą' tèhua ná qui'ni hue'él·la' le qui'ni gudàni' la'yani' nu runna Tata Dios qui' le por medio de ca obra tsè' nu guni le, para qui'ni télini ca enne' nna gudàliani cą Tata Dios qui' le enne' dua ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Bittu gulaba latsi' le qui'ni inte' nna daya' para chu'na' nu ra lo ley nu bedia Moisés enne' gùdua tiempo antigua, nihua nu bedia adí ca enne' uccua profeta qui' Tata Dios; sino qui'ni daya la' para gunia' cumplir iyaỹia tení. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Hualigani te' riquixa'ánia' le qui'ni ántesca l·luỹa latsi' ỹiaba nna yétsiloyu nna, nidi rúbani ttu letra to' nihua ttu acento to' dua lo ley qui' Tata Dios labí ttée qui'ni làa ccą́ cumplir. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Acca canchu nuỹa diba labí runią obedecer nuỹa ttu ca mandamiento hàstaba ca mandamiento nu ná adiru xcuichu tú'į, ą' tèhua ruluè'nią adí ca enne' nna, entonces lą nna tito' teruba la'dàliani gata' quì'į le' la' rigú'ubia' qui' Tata Dios. Pero nuỹa diba runią iyaba nu ra lo ca mandamiéntuį ą'hua ruluè'nią ca enne' nna, lą nna yala enne' ỹeni ccą́ le' la' rigú'ubia' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Acca nia' le qui'ni canchu labí guni le adí tsè' ru'a lo Tata Dios ti'chu nu runi ca maestro de la ley nna ca fariséuą' nna, entonces ą'hua lebi'į nna labí gá'a le le' la' rigú'ubia' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Hua yù bá le biỹa ra ca ta' enne' guláa: Bittu gútti lu'. Ą'hua: Nuỹa diba gúttią ttu enne' nna cca tehuą́ merecer írią sentencia quì'į gattią. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero inte' nna nia' le qui'ni nuỹa diba ruyudí'ą ttu enne' nna, cca tehuą́ merecer ccą́ castigar; ą'hua nuỹa diba ruduadí'ą ttu enne' nna, chi ną́ culpable nna cca tehuą́ merecer tsíą ru'a lo uxticia. Ą'hua nuỹa diba ínnią adiru ca titsa' èl·la ni contra ttu enne' nna, cca tehuą́ merecer tsíą lo yi'. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Acca canchu chi tahua' lu' ofrenda qui' lu' lo meỹa nna, pero de repente tabá exalatsi' lu' qui'ni ttu enne' nna té ttu queja quì'į contra lu'; ");
INSERT INTO zaaNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","entonces bethà'na ofrenda qui' lu' nía nna, beyya ỹa eyaccatsè' lu' ą, làniana eyeqquia lu' gute lu' ofrenda qui' lu'á. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Beyaccatsè' contrario qui' lu' miéntraste yù'urù lu' neda lani ą antesca gunią contra lu' lani juez, juez nna gutią lu' cuenta lani ca policia, lacą nna gudàl·la cą lu' litsi' ìyya. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Hualigani te' riquixa'ánia' lu' qui'ni labí éria lu' nía hàstaba qui'ni quiỹa lu' ituỹiatè multa nu inàbani cą lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Chi yù le qui'ni ga'na escrito: Bittu thúalani lu' niula huaya'. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero inte' nna nia' le: Nuỹa diba rinna'ą ttu niula nna ridà latsi'į thúalanią na, pues chi runią adulterar lani ą por la' rulabalatsi' qui' terubį. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Acca, canchu íyyalo lu' lado bàni runią qui'ni innia lu' le' tul·la' nna, gulèqquia teláą, gurù'na ą; qui'ni adila tsa' gunitti lu' ttu íyyalo lu' ti'ca'lá tsía itute lu' lo yi'bél·laá. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ą'hua canchu ná' lu' lado bàni runią qui'ni innia lu' le' tul·la' nna, guchù telá ą, gurù'na ą; qui'ni adila tsa' gunitti lu' ttu parte qui' cuerpo qui' lu' ti'ca'lá tsía itute lu' lo yi'bél·laá. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ga'na huá escrito: Canchu nuỹa calatsi'į ela'ą́ niula quì'į nna, té qui'ni hué' ỹą́ niuláa acta de divorcio. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero inte' nna nia' le: Nu ela'ą́ niula quì'į pero álahua por causa de qui'ni gùdualani niuláa attu nuhuaya', entonces lą nna ną́ responsable canchu innia niuláa le' adulterio. Ą'hua canchu attu nubeyu' guttsaní'į lani niuláa nna runi huą́ adulterar. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Hua yù bá le biỹa ra lo ley nu bete Tata Dios lani ca ta' tàta gùla qui' lía dèsdeba tiempo antigua: Bittu guni lu' jurar cuèntaba, sino guni la lu' cumplir itute nu beni lu' ofrecer lani Señor Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero inte' nna nia' le: Nú ttú tèhua por nuỹa ni guni le jurar nihua làa gudu le por testigo ttu cosa tsìa ỹiaba, porqui'ni ỹiabara' nna ną́ làti dua Tata Dios enne' rigú'ubia' lo iyate. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nihua bittu guni le jurar nna gudu le por testigo ttu cosa té le' yétsiloyu, porqui'ni ná huą́ parte de la' rigú'ubia' quì'e. Nihua làa gudu le por testigo Jerusalén, porqui'ni ną́ ciudad qui' Tata Dios enne' ná Rey Ỹeni. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nihua bittu guni lu' jurar nna gudu lu' por testigo la'a iqquia bá lu', porqui'ni nidi rúbani ttu ittsa' iqquia lu' labí ccani lu' guni lu' ą tsíttsi o yéthia para siempre. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pero adila tsa' qui'ni la' rinne qui' le nna ccá bą́ làchu o labí, segúnba nu ná lí. Porqui'ni hua ná malo canchu inaáru le bica'áỹáru tì'a canu runi sostener la' beỹia qui' quį ru'a lo ca enne' para íria nàrì cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Chi hua yù le qui'ni ga'na escrito: Bittu gappa lu' la'ỹeni sino íyyalo lani íyyalo bá ą'hua laya' lani laya' bá. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero inte' nna nia' le: Bittu edúdítsini le nu runi mal contra le, ántesla nuỹa diba huí'ą xaga' lu' lado bàni nna, bedà tèla attu lado. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Canchu nuỹa ilìdą pleito lani lu' nna calatsi'į thí'ą camisa qui' lu', pues be'él·la' telá ą thi' huą́ mata qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ą'hua nuỹa diba guthítsinią lu' huá' lu' yùà' quì'į por chuppa kilometro nna, pues huía tèla lani ą áchúppa por propio gani voluntad qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ą'hua nu rinàbanią lu' biỹa nna, bete tènì ą. Ą'hua nu inàbasanią lu' biỹa nna, bittu gutsùna'ni lu' ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Chi hua yù le qui'ni ga'na escrito: Catsi'íni lu' luetsi enne' lu', pero guyudí' la lu' nu ná contrario qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero inte' nna nia' le: Licatsi'i láni ca contrario qui' le. Liuluítsa' tsè'la canu riyé' iqquia le. Liguni tsè' lani canu ruyudí' cą le, ą'hua liguni oración por canu ruduadí' cą le nna rutsia latsi' quį le. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ą' modo télini ca enne' qui'ni ná le ỹi'ni Tata Dios qui' le enne' dua ỹiabara'. Porqui'ni lèe nna runie qui'ni bitsą' nna rudàni'ą tàntua para ca enne' malo ą'hua para ca enne' tsè' nna. Runi huée qui'ni cca iyya tàntua para canu runi nu ná tsè', ą'hua para canu labí runi nu rèe nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Porqui'ni canchu rappatsì'i le làteruba canu catsi'íni cą le nna, biani cosa tsè'ni nuá runi le para ccá le merecer gudàliani Tata Dios le. Tsí álahua ą'hua runi ca enne' malo canu ruquiỹa xàtta qui' impuesto cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Biárua tsè'ni runi le canchu làteruba canu cca tsè' le runi le saludar cá. Tsí álahua ą'hua runi canu labí ríalatsi' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Acca lébi'į nna, lícca completamentetaá enne' tsè' tì'a Tata Dios qui' le enne' dua ỹiabara' née enne' tsè' gani. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Lihue' cuidado qui'ni làa guni le ca obra tsè' ru'a lo ca enne' de tantua calatsi' le qui'ni gudàliani cą le. Porqui'ni canchu ą' runi le, entonces Tata Dios qui' le enne' dua ỹiabara' nna labí gudàlianie le. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Canchu chi rute lu' biỹa lani ca enne' pobre, bittu guni lu' qui'ni cuetsi trompeta para qui'ni ca enne' nna ccá cą saber, tì'a runi canu yala enne' tsè' rulue' cą pero álahua anía ná cą. Porqui'ni lacą nna de yù'u cą le' ca sinagoga qui' quį nna ą'hua lo ca néda nna siempre runi cą qui'ni cuetsi trompeta para qui'ni gappa' ná' ca enne' qui' quį por ca limosna nu runi cą lani ca enne' pobre. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Acca canchu chi calatsi' lu' gute lu' biỹa ofrenda nna bittu cueda lu' para ccá saber ca enne' tsè'e lado ná' yatti lu' nu runi ná' bàni lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Anía modo nna lanú enne' ccą́ saber tsáliaỹa rute lu'. Tata Dios qui' lu' enne' rinna' gattsi' bée lu' nna, lèe nna gudàlianie lu' lo enne' ỹetse'. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ą'hua canchu chi runi lu' oración nna bittu guni lu' tì'a runi canu yala enne' tsè' rulue' cą pero álahua anía ná cą. Lacą nna ridàni cą de runi cą oración le' ca sinagoga qui' quį ą'hua lo ca neda làti tsè'e ca enne', porqui'ni calatsi' quį qui'ni gudàliani cą cą. Hualigani te' nia' le qui'ni lacą nna chìa ridi' cą la'dàliani qui' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero lu' nna canchu chi guni lu' oración nna beyà'a le' litsi' lu' nna bethàya puerta nna, bel·luítsa' Tata Dios qui' lu' enne' du gattsi' bée lani lu' ą'hua rinna' gattsi' bée lu' nna. Lèe nna gudàlianie lu' lo enne' ỹetse'. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","De runi le oración nna bittu iqquiabete bá inne le ca titsa' tì'a canu rul·luítsa' cą ca idolo, porqui'ni rulaba latsi' quį qui'ni de tantua repetir runi cą nna huayénini nu rena cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bittu ccá le tulappa lani cą. Porqui'ni Tata Dios qui' lía nna hua yù bée biỹa cosa riquína'ni le ántescala inàbani li e. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lebi'į nna guni le oración íį: Tata Dios qui' tu' enne' dua ỹiabara', rinàba tu': Qui'ni nombre qui' cuią'lu' nna ccą́ nombre sagrado lo losto' ca enne', ");
INSERT INTO zaaNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ą'hua qui'ni ìta la' rigú'ubia' qui' cuią'lu' le' yétsiloyu nna, Ccá bá nu rú'ulatsi' cuią'lu' tì'ba ỹiabara' ą'hua le' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ą'hua qui'ni gunna cuią'lu' nu go tu' ttu ttu tsá. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Beyuniỹén latsi' cuią'lu' ca falta qui' tu', tì'a intu' nna reyuniỹén latsi' tu' qui' ca luetsi enne' tu' biỹa ruthacca' cą intu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Bittu guthàna ná' cuią'lu' intu' ccá tu' tentar, sino gudilà la cuią'lu' intu' le' iyaba canu ná mal. Porqui'ni làteruba cuią'lu' nna té itute la' rigú'ubia' nna la'huacca nna la'dàliani nna para siémpreni. Amén. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Porqui'ni canchu chi reyuniỹén latsi' le lani itute latsi' le qui' ca enne' rigú'u biỹa falta lani le nna, entonces ą'hua Dios Padre qui' le enne' dua ỹiabara' nna hueyuniỹén latsi'e qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero canchu labí reyuniỹén latsi' le qui' ca enne' biỹa ruthacca' cą le nna, entonces nihua Dios Padre qui' lía nna labí eyuniỹén latsi'e biỹa falta nu rigú'u le. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Canchu chi guni le ayunar de tantua calatsi' le guni le adí oración nna, bittu guni le qui'ni inna' le triste tì'a ca enne' canu rinna' cą qui'ni chi rigutsi latsi' quį para qui'ni ilá'ni ca enne' qui'ni rigua cą labí ro cą. Hualigani te' nía' le qui'ni lacą nna chìa ridi' cą la'dàliani qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero lu' nna canchu chi guni lu' ayunar nna, gùl·liba ittsa' iqquia lu' nna quíi lo lu' nna, ");
INSERT INTO zaaNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","para qui'ni làa tébe'ní qui'ni runi lu' ayunar. Porqui'ni Tata Dios qui' lu' enne' du gattsi' bée lani lu' làterubée yù nna gudàlianie lu' lo enne' yetsi. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Bittu gudua iqquia le gata' riqueza qui' le le' yétsiloyuį, porqui'ni tsè'e taá ca bèl·la dìl·la', ą'hua biỹaáru interés ni nna rel·lani taá cą ìyya, ą'hua ca ubàna nna rithàlia taá cą nna ribana cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sino liúdua la iqquia le gata' riqueza qui' le ỹiabara', porqui'ni nía nna lanuru ca bèl·la dìl·la' té, nihua labiru biỹa rel·lani ìyya, nihua ubàna nna lanuru té. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pues làti té ca cosa nu dacca' qui' lía nna nía huá du la' rulábalatsi' qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Iyyalo ri'u nna ną́ tì'a ttu lámpara para ri'u. Acca canchu íyyalo lu' tsè'ba ną́ nna, entonces labiru biỹa la'yani' reyàtsani lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Canchu iyyalo lu' labí yùą biỹa nuą' la'yani', entonces tálią́ qui'ni reqquia bá lu' le' chul·la. Canchu la' ritelíni qui' lu' re' bą́ le' chul·la nna, entonces la' chul·lį nna áchúppa tanto yethia ną́ le' la'labani qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Lanú ccani thuą bajo la' rigú'ubia' qui' chuppa ca patrón, porqui'ni miéntraste guyudí'ą ttuą nna catsi'í lánią attuą. Ą'hua miéntraste ną́ cumplido lani ttuą nna riníyú lą́ attuą. Ą'hua lebi'į nna labí ccani ccá le huenitsìna qui' Tata Dios nna tse'e huá le bajo la' rigú'ubia' qui' Bel·liu nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Acca inte' nna nia' le qui'ni bittu nùyuegá ccáni le por tì'iỹa ccá le nu í'ya go le para qui'ni ccabàni le, nihua ti'iỹa ccá le nu gaccu' le. Tsí álahua adila dacca' la'labani qui' ri'u tì'chula nu ri'ya ro ri'u cá. Ą'hua cuerpo qui' ri'u nna, tsí álahua adila dacca'ą ti'chula nu raccu' ri'u cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Linna'áruhua ca bìnni to' nu tsè'e lo be'. Bihua rada cą nihua labí rutùppa cą lèna' nihua labí redi' cą le' yú'u. Pero Tata Dios qui' le enne' dua ỹiabara' nna rui'e cą ro cą. Tsí álahua adírula dacca' le tì'chula lacą cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nuni le ccani itùni á tsatsitta de tantua gulaba latsi'į cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Acca por nu gaccu' le nna, biánicca rulaba thùti latsi' le. Liuyuúruhua ca ìyya nu anta' i'yatò' ti'iỹa latsitte riỹeni cą, pues labí biỹa tsina ni runi cą nihua labí rul·la cą tùu. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero inte' nna riquixa'ánia' le qui'ni nìhuani rey Salomón lani itúbani riqueza quì'į nna labí bilá' bi adí latsitte lani ca ỹo tsè'ni qui' bi ti'chu nuỹa ttu ca ìyya tú'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yala tsè'ni rugaccu' Tata Dios ca ixxi' to' canu anta' ttu tiempo to' teruba le' yétsiloyu pero guxtila taá chi bihuèthią nna dia chìą lo yi' le' horno. Acca lebi'į nna, tsí álahua adila dispuesto ná Tata Dios para gunnee adí nu riquína'ni le. Pero lebi'į nna labí confianza té qui' le lani e. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Acca bittu gulaba thùti latsi' le nihua bittu ina le: Ti'ani ccábaníní ri'u attu ida, o, ti'agani ccá ri'u nu gaccu' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Porqui'ni canu labí ríalatsi' nna, pues puro qui' canuá huadua iqquia quį. Pero Tata Dios qui' le enne' dua ỹiabara' nna hua yù bée qui'ni riquína'ni le iyaba ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Acca liudua la iqquia le ya'la tè nu cca qui' la' rigú'ubia' qui' Tata Dios, ą'hua qui'ni guni le nu rú'ulatsi'e; làniana iyábani ca cosa nu rulaba latsi' líį nna, ni nada ba gunnee cą qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Acca bittu gulaba xàttaga latsi' le anna nu ccá qui' guxtila, porqui'ni uxé nna yètsi' bá ná nùyue da' lani ą. Basta lani ca problema qui' ttu ttu tsá bá. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Bittu guyu le la'ditsi qui' ca enne', para qui'ni làa guni Tata Dios le juzgar. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Porqui'ni ti'iỹabá runi le ca enne' juzgar, entonces aníahua ccá le juzgar. Lani la'a mísmuba medida nu rurixibiá'ni le ca enne' nna, nuá huá ebixibiá' huáni le. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Biécca rinna' lu' yiỹi to' nu yù'u lo attu enne', atsi'íni labí runi lu' duel·la' ebèqquia lu' nicùà' nu yù'u íyyalo lu' ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Miéntraste yù'u ttu nicùà' íyyalo lu' nna, ti'ani modo eyáỹani lu' gá lu' attu enne': Gulèda qui'ni ebèqquia' yíỹi nu yù'u íyyalo lu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yala enne' tsè' rulue' lu' pero álahua ą' ná lu'. Ná qui'ni ebèqquia ỹá lu' nicùà' nu yù'u íyyalo lu'ą', làniana ilá' tsè'ni lu' ebèqquia lu' yíỹi to' nu yù'u íyyalo attu luetsi enne' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ca cosa nu beni le'ya Tata Dios nna, bittu gute le cą lani ca beccu', no sea qui'ni eyeqquia cą nna pedázoni guni cą le. Nihua ca cuttsi nna bittu hué' le cą ca perla tsè'ni, porqui'ni nìca'chu labí guni cą cą recibir nna sino gul·lia la cą cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Línaba nna huadi' bá le. Leyìla nna huetselá báni le. Linne ru'a puerta nna hua yàlia bą́. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Porqui'ni nuỹa tediba rinàba nna huadi' bą́. Nu reyìla nna huetsèla bánią. Nu rinne ru'a ttu puerta nna huayàlia bą́. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nuni ttu nubeyu' ni entre lebi'į canchu ttu ỹi'nį nna inàbanią na ttu ettaxtíla gúą, tsí hué' lą́ na ttu íyya cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Canchu inàbą ttu bél·la to' gúą nna, pues aỹa labí capaz ná le gute le ttu bèl·là la quì'į álá. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Lebi'į màsqui'ba ná le enne' tul·la', pero hua yù bá le gute le ca cosa tsè' qui' ca ỹi'ni le. Tsí álahua adí telá lani gusto gunna Tata Dios qui' le ca cosa tsè' nu inàbani li e cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Iyábani ca cosa nu rú'ulatsi' le qui'ni guni ca enne' lani le nna, ą'hua liguni lani lacą; porqui'ni nui ná nu rulue' nu ra lo ley qui' Moisés ą'hua lo ca libro nu bedia adí ca profeta qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Liguni duel·la' gá'a le ru'a puerta xcuichu to'; porqui'ni belaga ná ru'a puerta para lù'uti, ą'hua fácil ná neda nu chì'ą ca enne' para nitti cą; nuỹé cą nna dia cą lo nedą'. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Porqui'ni tabi ná ru'a puerta para la'labàni, ą'hua lathi to' ná neda quì'į; tuchùppa rúbá cą nna runi cą duel·la' thá' cą lúį. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Lihue' cuidado lani canu rena cą qui'ni rinne cą parte Tata Dios, porqui'ni álahua iyá cą rinne cą nu ná lí; yala humilde rulue' cą ti'átsi ttu carnero to' ril·lani cą ru'a lo le; pero liú'u losto' quį nna ná cą tì'a ttu lobo túxu nu dá'ą para gul·lùỹą latsi' iyábani. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Por ca hecho qui' quį nna edácca'ni le cą nuỹa clase de enne' ni ná cą. Tsí ína ri'u hua redi' ri'u betsuli' nna exxuhuí nna lo ca yettse' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Iyaba ca yà canù ribia fruto tsè' lo quį nna es porqui'ni ná cą yà tsè'. Ą'hua iyaba ca yà canu labí runna fruto tsè' nna es porqui'ni ná cą yà nu labí riỹu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Labí ccani ttu yà tsè' gunna fruto nu labí ná tsè'. Nihua labí ccani ttu yà nu labí riỹu' gunną ttu fruto tsè'. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Iyaba ca yà nu labí runna fruto tsè' nna chúu bá cą nna tsía cą lo yi'. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Acca por ca hecho qui' quį nna edácca'ni le canchu hualigani ná lí nu rena cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nuỹetse' ca enne' reya cą inte': Señor, Señor: pero alàa iyá cą té permiso qui' quį para gá'a cą le' ỹiabara', sino làteruba canu runi nu rú'ulatsi' Tata quia' enne' rigú'ubia' le' ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Canchu chi gal·la' tsá juicio nna, nuỹetse' cą nna gá cą inte': Señor, Señor, ti'átsi yala titsa' rappa cą inte'. Laniana ína cą: Tsí álahua gutixà'a huá tu' lani nombre qui' cuią'lu' ca cosa nu chì' ccálá, ą'hua lani nombre qui' cuią'lu' nna bedàl·la tu' fuera iyaba ca espíritu malo de lo losto' ca enne', ą'hua beni tu' iỹetse' ca milagro. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Làniana gudea' lo quį nna epa' ya' cą: Labí nabia' te' le, acca liucuìtta ru'a lua' lebi'į canu hueni tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nuỹa diba riyéninią ca titsa' quíyi'į nna runią cą nna, entonces inte' nna guni ya' ą comparar tì'a ttu enne'yù' nu té la' riyeni tsè' quì'į nna beduą yú'u quì'į lo cimiento tsè' nu púruani íyyaá. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bedà iyya nna biria yò nna uccua be' nna gutsé'e cą yú'a. Pero labí gubixią porqui'ni duą tsìttsì lo íyyaá. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero nuỹa diba riyéninią ca titsa' quíyi'į pero labí runią cą nna, entonces inte' nna guni ya' ą comparar tì'a ttu nubeyu' necio nu beduą yú'u quì'į lo yúỹi. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bedà iyya nna biria yò nna gutte be' nna gutàtsa' cą yú'a lani itute fuerza qui' quį; yú'a nna gubixi chìą nna guche' inda itutią. ");
INSERT INTO zaaNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","De beyacca gunne Jesús ca tìtsi'į nna yala biquila' latsi' ca enni'a de tantua ca enseñanza tsè' gutixa'ánie cą; ");
INSERT INTO zaaNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","porqui'ni gutixa'ánie cą ti'iỹa ná nu guni cą, alàa tì'a ca maestro qui' quį rul·la cą nu ra lo ìttsì qui' ley religioso qui' caniá, sino beluè'nie cą lani la'huacca de ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Beyàdi bá Jesús lo í'yaá nna nuỹetse' ca enne' denó cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Làniana bitsina' ttu nu ra'ni lepra rutsu' látį nna bedu ỹibį ru'a lúe nna rą ne: Señor, canchu calatsi' cuią'lu' nna huaccani cuią'lu' eyuni cuią'lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús nna becàa tè né'e nna beláppe'e na nna ra tìe na: Huacca látsa'a', beyàcca nàrì. Cuanto taání rèe anía nna beníttilo chì itsahue' qui' niá. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Làniana ra tè Jesús na: Bè' cuidado qui'ni nú ttu tehuá nuỹa quixá'ani lu', sino qui'ni huía talue' lo lu' lani sacerdótea, bete tè ofrenda qui' lu' tì'a nu beni Moisés mandado para qui'ni ccaỹén latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","De gutà'a Jesús le' yetsi Capernaum nna bitsina' tè ttu capitán ru'a lúe nna gutta'yúnią ne, ");
INSERT INTO zaaNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","rą ne: Señor, mozo quíya'a nna rà'nią parálisis nna nìdirúbani labí cca ttą́, yàl·la'ni dolor rappą́. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús nna rèe na: Anna tháya' eyuni ya' ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Becàbi capitáan nna rą ne: Señor, labí ná' nu dacca' para qui'ni gá'a cuią'lu' le' litsá'a', sino canchu ína teruba cuią'lu' titsa' nna, entonces mozo quíya'a nna eyacca latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Porqui'ni inte' nna, tsè'e canu runi cą inte' mandado, ą'hua tsè'e ca soldado làtsi' nàya' rúni ya' cą mandado; ą'hua canchu gáỹia' ttuą nna huitą́. Ą'hua mozo quí'a nna canchu épa'a ya' ą: Bèni nui nna, lą nna guni bą́ na. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","De biyénini Jesús ca titsa' qui' niá nna yala biquila' latsi'e nna rèe canu denó cą néa: Hualigani te' nia' le qui'ni nihua entre ca enne' Israel nna lanú enne' té iỹeni fe quì'į tì'a nu té qui' nubéyu'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ą'hua riquixa'ánia' le qui'ni iỹetse' ca enne' da' lado ril·lani bitsa ą'hua lado renia bitsa nna il·lani cą xúaní cą lani ca ta' tàta qui' le Abraham nna Isaac nna Jacob nna lugar de la' rigú'ubia' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero ca enne' becué' Tata Dios primérute nna labí tsé'e cą lani e le' la' rigú'ubia' quì'e, sino tsía la cą le' chul·la; nía nna ccá cą sufrir nna cuetsi cą nna góya'a tsùni laya' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Làniana Jesús nna rèe capitáan: Beyya bá, porqui'ni chìa ríalatsi' lu' nna, acca ccá bá tì' calatsi' lu' ą'. La'a mísmuba hóraá nna beyacca latsi' mozo qui' niá. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Bitsina' Jesús litsi' Pedrua nna bilá'nie suegra qui' niá tíą yi'bél·laníą ỹìl·lá. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús nna bedàxu'e ní'į nna beria chìą ỹìl·láa. Lą nna huatha tìą nna bènią cabí servir. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Gùl·la diba lanía nna tahua' cą ru'a lúe iỹetse' canu cca padecer por ca espíritu malo; lèe nna lani titsa' qui' terúbée nna bebèqquie fuera ca espíritu malua. Ą'hua iyaba canu ra'ni nna beyúnie cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Anía modo nna uccua cumplir nu bedia Isaías enne' uccua profeta tiempo antigua nna ra bi qui'ni: La'a mísmuba Señor nna beyúnie ca itsahue' qui' ri'u nna gùtue iyábani ca dolor qui' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Beyù bá Jesús qui'ni iỹetse' ca enne' tsè'e itá'lubanie nna, acca benie ca enne' ruthète'niáa mandado qui'ni tté cabí lani e attu lado la indatù'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Làniana bitsina' ttu maestro nu rulue' ley qui' caniá nna rą ne: Maestro, hua tànua' cuią'lu' gaỹa tediba tsía cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús nna rèe na: Ca beda' nna hua tsìa bèlia qui' quį, ą'hua ca bìnni to' ridà lo be' nna hua tsìa huá xcu'ni to' qui' quį. Pero Nubeyu' de Ỹiabara' nna labí té gaỹa quixa íqquié. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Attu enne' ruthète'niáa nna ra tìą ne: Señor, tanó huá' cuią'lu', pero bènna cuią'lu' permiso quia' qui'ni priméruỹa éya'a' ugáttsi'a' tàta quí'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús nna rèe na: Gutà tè lani inte', be'él·la' canu yattią' qui'ni ucàttsi' luetsi nu yatti quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Laníala nna gutà'a Jesús le' bárcuá. Ca enne' ruthète'niáa nna dia tè cabi lani e. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","De repente taání nna huatha ttu iyyabe' fuerte lo indatù'a hàstaá qui'ni chi rurixią bárcuá nna chi calatsi'į inétsią le ìndaá, Jesús nna ti'áthi bée. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Làniana ca enne' ruthète'niáa nna bedibàni chì cabi e nna ra cabi e: Señor, bèni xìa cuią'lu' qui'ni l·lá rí'u porqui'ni chi rinetsi ri'u le' indį. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Lèe nna rèe cabi: Biáni cca rátsini le ni'i, hualigani labí ríalatsi' le qui'ni inte' nna té la'huacca quia'. Làniana huàthèe nna gutìtse'e bè'a ą'hua indatù'a. Luego taá indatù'a nna beyàtta' chìa tsi. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Acca uccuaỹí ya'ání latsi' cabí nna ra cabi: Núgani enní'į acca hàstaba be' nna indatù'į nna riyénini cą quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Bitsina' diba Jesús attu ládula indatù'a ru'a loyu qui' ca enne' gadarenos, làniana chuppa canu cca padecer por ca espíritu malo nna beria cą le' bèlia làti bigátsi' canu yatti nna tattsa' cą Jesús. Lacą nna yala túxu runi cą hàstaá qui'ni lanú nuỹa reyáỹani tté neda nía. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Gunne cą iditsa na ra cą: Jesús Ỹi'ni Tata Dios, biáni té qui' lu' nì. Tsí da' chì lu' para guni lu' intu' castigar ántesca gál·la' tiempo cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Idittu' tì'ba de nía nna tsè'e ttu montón ní ca cuttsi huìla go. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ca espíritu malua nna gutta'yúni cą Jesús nna ra cą: Canchu ebèqquia lu' intu' fuera nna, bènna permiso qui'ni tsá' tu' gá'a tu' lani ca cuttsią'. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Lèe nna rèe cą: Líttsía. Lacą nna betsè'e latsi' quį chuppa ca nubéyu'á nna huía cą gutà'a tè cą lani ca cuttsia. Luégutaá nna uccua litsiani ca cuttsia nna gutùl·lu cą lo ttu i'yatò' nn binnia cą le' indatù'a nn gùtti cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Canu rappa ca cuttsia nna bigàa chì cą nna betsina' cą le' yetsia nna gutixà'a cą iyaba ti'iỹa ná nu uccua ą'hua nu uccua lani chuppa ca nubeyu'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Làniana biria chì itúbani yetsi para tattsa' cą Jesús. De bitsina' cą ru'a lúe nna gutta'yúni cą ne qui'ni erie látsi caniá. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Làniana beyappi Jesús le' bárcuá nna huíe attu lado indatù'a nna betsine'e le' yetsi qui'áa. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tuchùppa ca enne' nna tahua' cą ttu nu rà'ni parálisis ru'a lúe, nìdirúbani làa cca ttą́, yu'ą́ lè'e camilla. De gutelíni Jesús qui'ni yala fe té qui' ca nubeyu'a lani e nna ra tìe nu rà'nia: Gùppa confianza ỹì'nia', chìa beyuniỹén látsa'a' ca tul·la' qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Làniana tuchùppa ca maestro de la ley nna liú'u losto' bá quį ra cą: Rinne nui ca titsa' nu ná qui'ni làteruba Tata Dios ínnié ą́'. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","De gutelíni Jesús qui'ni anía rulaba latsi' quį, acca rèe cą: Biánicca rulaba latsi' le nu labí ná tsè' ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Biála adí ỹánaba, tsí inia': Chì beyúniỹén látsa'a' ca tul·la' qui' lu', o, tsí inia': Beyátha nna gùda', acca. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pues annana gulué'nia' le qui'ni inte' Nubeyu' de Ỹiabara' nna té la'huacca quia' le' yétsiloyuį para eyuniỹén látsa'a' ca tul·la'. Làniana rèe paralíticuá: Beyátha nna bedi' camilla qui' lu'ą' nna beyya litsi' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nu rà'niá nna beyátha chìą nna deyyą litsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","De bilá'ni ca enní'a na yala biquila' latsi' quį, bedàliani cą Tata Dios qui'ni betìe luetsi la'huaqquį qui' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Gutte diba Jesús nía nna bilá'nie ttu nubeyu' láą Mateo rì'ą lo meỹa làti ría ca enne' huìỹa impuesto nu ruquiỹa gobierno. Lèe nna rèe na: Gutà, tanó inte'. Matéuá nna gudulí tabą́ nna día tìą lani Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Loti' re' Jesús lo meỹa le' yú'u nna bitsina' huá iỹetse' canu ruquiỹa qui' impuestua nna ą'hua canu dàa tìtsa' qui' quį labí rigua cą ca costumbre religiosa qui' ca judíua. Iyába ca nuá nna guỹua cą junto bá lo meỹa lani Jesús nna ca enne' ruthète'niáa nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ca fariséua, de bilá'ni cą qui'ni re' Jesús lani ca enni'a nna ra tè cą ca enne' ruthète'niáa: Biani cca ro Maestro qui' líą' lani canu ruquiỹa qui' impuesto ą'hua lani adí canu tul·la' ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Biyeni tèni Jesús nui nna rèe cą: Canu bihua rà'ni nna pues bihua riquína'ni cą nuỹa eyúnią cą, sino làteruba canu rà'ni riquína'ni cą médico. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Acca ligùl·la nna liuthète' biỹa nuą' calatsi' Tata Dios làti rèe: La' retúalatsi' calátsa'a', alàa biỹa sacrificio ní. Acca labí daya' para gaỹia' canu rulaba latsi' quį qui'ni chi ná cą enne' tsè', sino daya la' para gaỹia' ca enne' tul·la' para qui'ni eyacca cą arrepentir. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Làniana ca enne' ruthète'ni Juan el Bautista nna bitsina' cabi ru'a lo Jesús nna ra cabi e: Intu' lani ca fariséuą' teruba nna dàatiba runi tu' ayunar. Biani cca ca enne' ruthète' qui' cuíą'lu'ą' nna bihua rigua tí' cą làa ro cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús nna becàbinie cabi nna rèe: Tsí ína ri'u canu tsè'e thá'a nna yala triste tse'e cą miéntraste ènne'yu' ruttsaná'a du bá bi lani cą cá. Labí, pero huì'yu tsá qui'ni itua ènne'yu'a lani cą, laníalá nna guthà'na cą labí go cą por la' rehuiní'latsi'. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Lanú nuỹa regú'u remiendo ttu vestido viejo lani ttu pedazo lari' cubi, porqui'ni la'a mísmuba remiendo cúbía nna ichèda'ą lari' viéjua, anía nna adila iyàl·la' làti chi birèda'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nihua labí rigá'a ca enne' vino cubi le' bolsa vieja nu de yeti; porqui'ni cáalá ą' runi cą nna, entonces por fuerza qui' vino cúbía nna itsu' la ca bolsa yétiá nna ilàlia vínua, ą'hua ca bolsa yétiá nna labiru iỹu' cą. Sino rigá'a la cą vino cubi le' ca bolsa yeti cubi, ą' modo nna júntuba guchia bolsa yétiá lani vino cúbía. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Hua rinne cannabée ca tìtsa'a nna bitsina' ttu ènne'yu' rigú'ubia' le' yétsiá, beduỹibį ru'a lo Jesús nna rą ne: Chi' gùtti tegani ỹi'ni niula to' ya'a. Tsí huacca qui' cuią'lu' ìta cuią'lu' guláppa' cuią'lu' cuerpo to' qui' niá nna eyaccabàni tabą́. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Gudulí tè Jesús nna díe lani ą, dia huá ca enne' ruthète'niáa. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Neda bá yu'ée nna taỹeni ttu niula ne. Chi uccua tsì'nu ida rà'nią réni. Lą nna gubíga'ą cuè'e lée beláppa'ą ru'a ỹuéa. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Anía benią porqui'ni liú'u losto' bíį nna rą: Canchu guláppa'a' màsqui'di ỹúe nna eyacca taá látsa'a'. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Bedeqquia tè lo Jesús nna gùnne'e na ra tìe na: Gùppa confianza ỹì'nia', chi rialatsi' lu' qui'ni té la'huacca quia', acca chi ná lu' salvo. Dèsdeba lanía nna beyacca latsi' niuláa. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Làniana bitsina' Jesús litsi' nubeyu' principal qui' yétsiá nna bilá'nie ca músico ą'hua alboroto nu runi ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Lèe nna rèe cą: Líria cànna tsàstito' qui'ni niula cuiti'į nna labí chi gùttią sino ti'éthi bą́. Pero lacą nna burla la beni cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","De chi benie mandado qui'ni éria ca enni'a nna gutè'e làti té niula cuití'a nna gutèl·lé'e ní'į nna beyátha chìą. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Gudà tè titsa' itúbani nía ti'iỹa ná milagro nu beni Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Gutte diba Jesús nía, làniana chuppa ca enne' ciego nna tanó cą ne, ditsa tsè' rinne cą nna ra cą: Cuią'lu' Ỹi'ni David, betúa latsi' cuią'lu' intu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Làniana Jesús nna de chi rì'e le' yú'u nna bitsina' ca enne' ciéguá ru'a lúe. Lèe nna rèe cą: Tsí hua ríalatsi' le qui'ni huacca te' gunia' nu rinàbani le inte' cá. Becàbi cą nna ra cą: Hua ríalatsi' tu' Señor. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Làniana beláppe'e íyyalo quį nna rèe cą: Porqui'ni chi ríalatsi' le nna ccá bá tí' calatsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Luégutaá nna bilá'ni cą. Làniana Jesús nna yala idí' gunènie cą rèe cą: Lihue' cuidado qui'ni nú ttu nuỹa ccá saber nui. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero lacą nna de beria cą nía nna bedà chì cą titsa' itúbani nía ti'iỹa tsè' ná milagro nu beniáa. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Merua reria cą fuera nna bitsina' tè attu te ca enne' ru'a lo Jesús tahua' cą ttu enne' ỹíì nna ccą padecer por ttu espíritu malo. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Benie mandado qui'ni éria espíritu malua lo losto' enne' múduá nna luégutaá guduluą gùnnią. Ca enne' nna uccuaỹí ya'ání latsi' quį nna ra cą: Nunca labí chi bilá'ni ri'u guni ttu enne' luetsi ca milagruį le' nación qui' ri'u Israel. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero ca fariséua nna ra la cą: Porqui'ni rul·luítsa'ą nu ná huexana' qui' ca espíritu malo, acca rudàl·lą cą fuera. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús nna gurènie le' iyaba ca yetsi ą'hua ca rancho to' nna gutixa'ánie ca enne' le' ca sinagógaá ca enseñanza cubi nna beni huée predicar evangelio nu rulue' ti'iỹa tsè' ná la' rigú'ubia' qui' Tata Dios. Ą'hua beyunie iyábani itsahue' nna gùtue iyábani clase de ca dolor qui' ca enne' qui' ca yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","De bilá'ni Jesús qui'ni yiỹi berèe' ni re' ca enne' nna, yala betúa latsi'e cą porqui'ni tsi'irúbani cani latsi' quį nna gàtti' tsè'e bá cą tì'a ca carnero to' lanú pastor qui' quį té. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Acca rèe ca enne' ruthète'niáa: Hualigani iỹèniní lena' chi té para éỹu', átsi'ini tuchùppa rúbani ca obrero tsè'e. ");
INSERT INTO zaaNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Acca linàbani Tata Dios enne' ná Xana' loyuį qui'ni ithèl·le'e adí ca obrero gutùppa cą lena' quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Làniana gutàỹi Jesús tsì'nu ca enne' ruthète'niáa nna betie la'huacca qui' cabi sobre ca espíritu malo para qui'ni ebèqquia cabi cą fuera, ą'hua para qui'ni eyuni cabi iyábani itsahue' nna cúa cabi iyábani clase de dolor. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tsì'nu ca apóstol nna lá cabí íį: Primérute Simón lá huá bi Pedro, ą'hua Andrés bettsi' bía, ą'hua Jacobo ỹi'ni Zebedeo, lani Juan bettsi' bía nna, ");
INSERT INTO zaaNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felípea nna, Bartoloméa nna, Tomas nna, Mateo enne' bequiỹa qui' impuesto nna, Jacobo ỹi'ni Alfeo nna, ą'hua Lebeo enne' guta' huá lá bi Tadeo, ");
INSERT INTO zaaNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ą'hua Simón enne' gulátsi' partido lą́ cananistas nna, ą'hua Judas Iscariote nu betią ne cuenta para gattie. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Loti' guthel·la' Jesús ca enne' tsì'nua nna betie consejo qui' cabi nna rèe: Bittu tsía le lado qui' adí ca nación, nihua le' ca yetsi anta' le' distritu lą́ Samaria nna bittu gá'a le. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sino tsía la le lani ca enne' Israel porqui'ni ná cą tì'a ca carnero to' nu chi gunitti. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","De dia le nna guni le predicar ína le: Annana calatsi' Tata Dios qui'ni ca enne' nna hue'él·la' cą qui'ni quée enne' cu'úbia'nie cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ą'hua ná qui'ni eyuni le canu ra'ni, ą'hua canu rùtsu' láti quį para eyacca cą nàrì nna, guni le qui'ni eyátha canu yatti, ą'hua ebèqquia le fuera ca espíritu malo. Chi ỹa guỹi' bá le la'huacca para guni le ca cosą', acca ná qui'ni ỹa guni bá le cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Bittu hua' le oro nihua bel·liu nu de plata, nihua nu de cobre, ");
INSERT INTO zaaNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nihua morral nu cu'u le biỹa go le. Nihua bittu cueda le guni le prevenido para hua' le chuppa cue' ỹo le nihua chuppa cue' guarachu, porqui'ni ttu obrero nna dacca' bą́ guni cą na sostener. Nihua làa theni le ttu yà para ccani le defender. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Gaỹa tediba yetsi o rancho to' làti gá'a le, inàba titsa' le canchu hua dua ttu enne' ga'ną dispuesto gunią le atender; entonces níabá ccá lugar qui' le hàsta'na gal·la' tsá eda' le le' yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Canchu chi gá'a le le' yú'u nna guni le cą saludar qui'ni gáta'ni cą la'ỹeni lo losto' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Canu tsè'e le' yú'u nna canchu gudà naga' quį qui' le, làniana la' redacca'latsi' qui' le nna gata' huá qui' quį. Pero canchu gutsìbi cą le nna, entonces egà'na cą sin bendición. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nuỹa diba labí gunią le recibir le' litsi'į nihua labí gudà nagui'į ca titsa' qui' le nna, entonces ná qui'ni eria le le' yú'a o le' yétsiá, pero gucuibi tè bestè nì'a le, seña para télini cą qui'ni labí tsè' beni cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Hualigani te' riquixa'ánia' le qui'ni adila fuerte ccá la' tsìalatsi' qui' Tata Dios nu chì' da'la lani yétsiá tì'chula juicio nu uccua lani ca yetsi Sodoma nna Gomorra nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ca lugar làti rithél·la'a' le nna té peligro, tì'a ca carnero to' tsè'e lahui' ca lobo. Acca ccá le listo tì'a ca bèl·là, ą'hua ccá le humilde tì'a ca becha to'. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Lihue' cuidado lani ca enne' porqui'ni tahua' cą le ru'a lo ca juez para guni cą contra le, ą'hua hué' cą le lani cuarta le' ca sinagoga làti retuppa cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ą'hua tahua' cą le hàstaá ru'a lo ca gobernador ą'hua ca presidente nna por causa de qui'ni riquixá'a le nu cca quia'. Anía modo nna gute le testimonio nu cca quia' ru'a lo quį ą'hua ru'a lo canu idittu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Canchu chi gudaxu' cą le preso nna bittu nùyue cani le ti'iỹa ecàbi le, porqui'ni la'a mísmuba hora nna innia le' la' riyeni qui' le ca titsa' nu ná qui'ni inne le. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Porqui'ni álahua lebi'į nuá inne, sino Espíritu Santo enne' ithel·la' Tata Dios qui' lía, lèe nna ínnié por medio de lebi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ttu bettsi' nna gutią cuenta la'a bettsi' bíį para gattią, ą'hua ttu tàta nna gutią cuenta la'a ỹi'ni bíį. Ca ỹí'niá nna eyeqquia cą contra ca tàta nàna qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Iyaba cą nna guyudí' cą le porqui'ni riquixá'a le nu cca quia', pero canu guchia bá hàstaá fin de cca cą sufrir por inte' nna, làcanuá nna l·lá cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Canchu chi gutsia latsi' quį le le' ttu yetsi nna, lítsía telá attu yetsi huaya'. Hualigani te' nia' le qui'ni labí chi beyáni le tsía le iyaba ca yetsi qui' ca enne' Israel canchu chi gal·la' tsá il·lani Nubeyu' de Ỹiabara' attu. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nu ruthète' nna labí dacca'ą adiru tì'chu maestro qui' niá. Nihua ttu mozo nna labí dacca'ą adiru ti'chu xana' niá. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Basta qui'ni ttu discípulo nna ccą́ tì' ná maestro qui' niá. Ą'hua nu runi servir nna ccą́ tì' ná xana' niá. Ttu tàta nna, canchu téni cą lá bi: enne' malo nna, pues adí teérulá mal inne cą qui' ca familia qui' bi cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Acca bittu gátsini le cą, porqui'ni labí ttu cosa nu gattsi' té sin qui'ni làa ilá'níą, nihua biỹa ttu secrétuni té sin qui'ni làa guni ri'u ą saber. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nu riquixa'ánia' tsuą' teruba lebi'į le' chul·la nna, liguni ą declarar lani iyaba ca enne'. Ą'hua nu riyeni gattsi' báni le nna, lítsappi iqquia yú'u nna guyèni li ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bittu gátsini le canu rutti cą cuerpo, pues bittu ccani cą gul·lùỹa cą latsi' le. Sino lígátsi láni enne' té la'huacca quì'e gudàl·lèe ca enne' lo yi'bél·laá, ą'hua cuerpo qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tsí álahua ritò'o chuppa ca bìnni to' por ttu moneda to' rúbá ca. Pero nidí ttuą labí innią́ loyu sino por voluntad qui' Tata Dios qui' lía. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hàstaá ittsa' iqquia le nna chi babànie iyáỹiani cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Acca bittu gátsini le, porqui'ni adí telá dacca' le ru'a lo Tata Dios tì'chula iỹetse' ca bìnni to'. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nuỹa diba gudàlianią inte' ru'a lo ca enne' nna, ą'hua inte' nna gudàliani huá ya' ą ru'a lo Tata quia' enne' dua ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero nuỹa diba ettú'nią quixá'ą nu cca quia' ru'a lo ca enne' nna, ą'hua inte' nna ettu' huá te' guni ya' ą presentar ru'a lo Tata quia' enne' dua ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Bittu cani le qui'ni inte' nna daya' para qui'ni bíttuúru ccá chuppa la' rulábalatsi' le' yétsiloyu. Labí daya' para qui'ni bíttuúru til·la ca enne' sino ccá la cą dividir por causa de inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Acca por causa de inte' nna til·la ca enne' entre familia: ttu ỹi'ni contra tàta quì'į, ttu ỹi'ni niula contra nàna quì'į, ttu ỹòlitsi' contra suegra quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Pues ca contrario qui' ttu nubeyu' nna ccá cą la'a mísmuba canu le' yú'u quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nu catsi'ínią tàta nàna quì'į adiru ti'chu catsi'ínią inte' nna, entonces labí ccą merecer thá'ą lani inte'. Ą'hua nu catsi'ínią ca ỹi'nį adiru ti'chu catsi'ínią inte', entonces ą'hua labí ccą merecer thá'ą lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nu labí ga'ną dispuesto ccą́ padecer hàstaba canchu gútti ca enne' na porqui'ni denúą inte', entonces labí dacca'ą para ccą́ enne' quia'. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nuỹa tediba dua iqquį etúa latsi'į la'labàni quì'į nì nna, pues lą nna gunittią la'labàni nu adiru dacca' para despuéslá. Pero nu iria latsi' la'labàni quì'į hàstaá canchu gattią porqui'ni denúą inte' nna, lą nna ccabàni láą. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nu gunią le recibir le' litsi'į nna, entonces ti'atsi inte' bá nuá runią recibir. Ą'hua nu runią inte' recibir nna, runi huą́ recibir Tata Dios enne' guthel·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nu runią recibir ttu profeta porqui'ni ną́ enne' rinne parte Tata Dios nna, entonces tulappa bá ná la'dàliani thí'ą lani nu gute Tata Dios qui' profétaá. Ą'hua nu runią recibir ttu enne' quia' porqui'ni runią nu ná tse', entonces lą nna luetsi premio qui' enni'a huá thí'ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ą'hua nuỹa diba gutią biỹa tediba cosa màsqui'di ttu vaso inda dil·la' qui' nuỹa ttu canu xcuichu tú'į porqui'ni ná cą huenitsìna quia', pero inte' nna nia' le qui'ni hualigani labí iỹùl·lani Tata Dios na. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Beyacca diba gutixa'áni Jesús tsì'nu ca discípulo qui'áa ti'iỹa ná nu guni cabi, bede'e nía nna huíe huequixà'a le' ca yetsi anta' nía nna benie predicar. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Litsi' iyyà bá té Juan el Bautista nna bina bi iyábani nu beni Cristua, acca guthel·la' bi chuppa ca enne' ruthète' qui' bía làti rènie. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Gunaba titsa' cabi e nna ra cabi: Tsí cuią'lu' Cristo enne' ná qui'ni ìta, o tsí cueda tu' attu enne' huaya' áccá. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Becàbi Jesús nna rèe ca enne' dia mandado qui' Juáan: Leyya liute razón lani Juáan ca cosa nu riyénini le nna ca milagro nu rilá'ni le nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gá le bi qui'ni ca ciego nna rilá'ni cą; ca cojo nna rida' cą; canu rùtsu' láti quį nna reyacca cą nàrì; canu cuètsu nna riyénini cą; canu yatti nna reyacca bàni cą; ca enne' humilde nna chi runa cą ca titsa' nu runna salvación qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ica'rubà canu bittu redúl·la'a latsi' quį lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bedà' diba cą nna làniana gudulo Jesús riquixé'e nu cca qui' Juáan lani ca enne' nna rèe: Biani nua' calatsi' le úhuia' le acca biria le fuera yetsi cá. Tsí huía le tanna' le ttu nubeyu' variable nu rudu chùppanią latsi'į cá. Labí. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Biani biria le tanna' le. Tsí ttu enne' nu yala tsè' de ỹúį áccá. Canu raccu' ỹo fino quį nna, pues le' palacio qui' ca enne' dacca' tsè'e cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Acca, biani biria le tanna' le áccá. Tsí ttu enne' ná profeta áccá. Hualigani qui'ni biria le iyénini le qui' ttu mensajero nu adírula enne' ỹeni ti'chu ttu profeta. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Porqui'ni qui' bi nuą' riquixá'a Tata Dios làti ga'na escrito: Ni rithél·la'a' mensajero quia', deneru bi lo lu', Para ithàlia bi neda para guni ca enne' lu' recibir. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Hualigani nia' le qui'ni de lo iyábani ca enne' nna, lanú chi gùdua ccą́ adiru enne' ỹeni ti'chu Juan el Bautista. Pero canu bitote le' reino qui' ỹiabara' nna, pues adila enne' ỹeni ná cą tì'chula Juáan. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Dèsdeba loti' gudulo Juan el Bautista hueni predicar hàstaba anna, iyáỹiani ca enne' nna yala rue' latsi' quį gá'a cą le' la' rigú'ubia' qui' Tata Dios; canu violento nna runi cą duel·la' thí' cą na. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Porqui'ni iyaba ca profeta nna ą'hua ca enne' bedia ley qui' Tata Dios nna gutixà'a cabi nu chì' ccálá, ą' beni cą hàstaá qui'ni gul·lani Juáan. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Canchu calatsi' le gudà naga' le qui' bi nna, làbi nuá Elías enne' ná qui'ni ìta. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nu calatsi' télinią nna gudà nagui'į adí. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Acca, núní tì'na gunia' comparar ca enne' tsè'e anna cá. Ná cą tì'a ná ca huatsa cuìti' nu rucuetsi cą flauta qui' quį lo neda nna rul·luítsa' cą iditsa ca luetsi huatsa quį, ");
INSERT INTO zaaNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","rena cą: Chi becuétsi tu' pieza alegre nna, pero labí bedácca'ni le. Chi hua bìl·la tu' qui' enne' yatti, pero nìhua làa gurètsi le. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Anía nia' le, porqui'ni bìta Juáan nna gurèni bi rigua bi labí gu'ya gutó bi bicca'áỹa, pero rena la ca enne' qui'ni espíritu malo nna duą lani bi. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Gul·lani tehuá Nubeyu' de Ỹiabara' ri'ya ro bée lani iyaba ca enne' nna redena la cą: Nui nna puro go bá nna gu'ya bá nna runią ą'hua yala catsì'ą canu ruquiỹa qui' impuesto nna ą'hua adí canu hueni tul·la' nna. Pero nia' le qui'ni canu runi obedecer la' riyeni tsè' nu da' de ỹiabara' nna, lacą nna rulue' rábani cą por ca hecho tsè' qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Làniana Jesús gunnie idí'ni contra ca yetsi làti chi benie adí iỹé ca milagro, porqui'ni labí beni cą reconocer qui'ni ná cą enne' tul·la' delante de Dios, acca rèe cą: ");
INSERT INTO zaaNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Airu lu' yetsi Corazín nna Betsaida nna, porqui'ni cáalá le' ca yetsi Tiro nna Sidón nna uccua ca milagro canu chi uccua lani lebi'į, pues cuando lání chi gùccu' cą lari' corriente nna bedua tte iqquia quį seña de qui'ni reyacca cą arrepentir por ca tul·la' qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Acca nia' le qui'ni de gal·la' tsá juíciua nna huaỹia' la castigo tsía canu yetsi Tiro nna Sidón nna tì'chula lebi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ą'hua lu' nna yetsi Capernaum, màsqui'ba hàsta rúbani ỹiaba rulaba latsi' lu' ri'yu la' dàliani qui' lu', pero hàsta rúbani ỹàrèe' èxxá lu'. Porqui'ni cáalá le' yetsi Sodoma uccua ca milagro canu chi uccua lani lu' nna hualigani hàstaba anna àtsaba rì'ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Acca riquixa'ánia' le qui'ni de gal·la' tsá juíciua nna huaỹia' la castigo tsía canu yetsi Sodomo tì'chula lebi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Laniataá nna beni Jesús oración nna rèe: Cuią'lu' Tàta quia' enne' té làtsi' né'e itute la'huacca qui' ỹiabara' ą'hua qui' yétsiloyu, quiỹarú cuią'lu' porqui'ni canu yala la' riyeni té qui' quį nna labí rue'el·la' cuią'lu' qui'ni gunibia' cą ca enseñanza tsì'į nihua lani canu rulaba latsi' quį qui'ni yala ritelíni cą. Pero lani ca huatsa to' la nna chi beni cuią'lu' cą declarar. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ą'ba beni cuią'lu', porqui'ni anía guyú'u latsi' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Làniana ra Jesús canu tsè'e nía: Iyába ca cosa nna chi benna Tàta qui'a làtsi' nàya'. Lanú nuỹa nabiá'nią Ỹi'ni Tata Dios sino làteruba Tàtáa nna nabiá'nie bi. Lanú nuỹa nabiá'nią Tàtáa sino Ỹi'niáa, ą'hua iyaba canu calatsi' Ỹi'niáa gunie declarar Tàtáa lani cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Iyaba le canu rue' la' dí'latsi' le de nùà'ni le yua' ìdi'i nna, lità lani inte' porqui'ni inte' nna gunia' qui'ni èdi' latsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Liguni la aceptar yugu' nu té quia' para lebi'į, ą'hua lícca canu ruthète' quia' porqui'ni ná' maestro ỹénlatsi' nna labí itìtsi te' le. Ą' modo nna gatà'ni le la'ỹeni nu riquína'ni le. ");
INSERT INTO zaaNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Porqui'ni fácil taá ná yugu' nu té quia' para lebi'į, ą'hua yiỹi dèbá ná yua' nu gunna' huá'ni le. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tiempo làniana gutte Jesús làti té ỹua'. Tsá lanía nna uccua tsá redi' latsi' ca enne' judíua. Ca discípulo qui'áa nna gutuni cabí, acca guchèccu' cabi tuchùppa ỹua'xtíla, beni tsè' tè cabí cą nna gutò cabí. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","De bilá'ni ca fariséua nna ra chì cą ne: Gunna' tsáruhua ca discípulo qui' lu'ą' qui'ni runi cą ttu tsina nu labí ná qui'ni guni ri'u natsa. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Lèe nna rèe cą: Tsí bíhuani' gul·la le làti riquixá'a biỹa beni rey David loti' gutuni bi lani ca enne' tsè'e lani bía. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Gutà'a bi le' templo qui' Tata Dios nna gutò bi ca ettaxtíla nu ná ofrenda para Tata Dios màsqui'ba labí ná qui'ni go bi cą nihua canu tsè'e lani bía nna. Làteruba ca sacerdótea ná qui'ni go cą ca ettaxtílaá pero bíhua beni Tata Dios bi juzgar qui'ni ną́ tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tsí bíhuani' gul·la le lo ley qui' ri'u làti ra qui'ni ca sacerdótea màsqui'ba runi cą tsina le' templua tsá ỹeni nna, pero bihua ra qui'ni rigú'u cą falta por nuá. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Inte' nna nia' le qui'ni nì du ttu enne' adírula dacca' tì'chula templua. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Liudà naga' le nu ra Tata Dios: La' retúalatsi' calátsa'a' para ca enne', Alàa biỹa animal nu guni le ofrecer por inte'. Cáalá rennia le cuenta biỹa nuą', entonces labí la juzgar runi le canu làhuabi mal runi cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","9","Porqui'ni Nubeyu' de Ỹiabara' nna té la' rigú'ubia' quì'e lo iyábani ca tsá màsqui'ba labí ná tsá para guni ri'u tsina. Gutte bá Jesús nía nna bitsine'e le' sinagoga qui' caniá. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nía nna re' ttu nubeyu' gubitsi ya'abá ná' bànį. Gunàba titsa' tè cą Jesús para qui'ni gappa cą neda biỹa caúsani gutsia cą quì'e, acca nna ra cą: Tsí hua ná tsè' eyuni ri'u ttu enne' rà'ni tsá labí ná qui'ni guni ri'u tsina cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Becabínie cą nna rèe: Canchu nuỹa ttu le du ttu carnero to' quì'į nna innią́ le' yeru, tsí bihua ucàa ná' le nna ebèqquia li ą màsqui'ba labí ná tsá qui'ni guni ri'u biỹa tsina. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tsí álahua adírula dacca' ttu enne' ru'a lo Tata Dios ti'chu ttu carnero cá. Acca hua ná bá qui'ni guni ri'u tsè' qui' ttu enne' màsqui'ba labí ná tsá tsina. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Làniana ra tìe nubeyu' rà'nia: Bèl·lií ná' lu'. Lą nna bèl·lií taá ní'į. Làniana beyacca chì ná' niá tsè' tì'ba ná attu lado. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Beria bá ca fariséua nna gunne lettia cą ti'iỹala modo gútti cą Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","De gutelíni Jesús nui nna bede'e nía. Ca enne' ỹetse' nna tanó cą ne. Lèe nna beyunie iyaba canu rà'nia. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Làniana yala recomendar benie cą qui'ni nú ttu tehuá nuỹa quixá'ani cą qui'ni benie ca milagrua. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Anía modo nna uccua cumplir nu ra Tata Dios lo libro nu bedia enne' uccua profeta loti' rèe: ");
INSERT INTO zaaNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nìba du enne' chi becuí'a' para quée huenitsìna quia' nna yala catsi'í ti' e, ą'hua yala agradar cani latsi' lóstu'a' por lèe. Ithél·la'a' Espíritu quia' sobre lèe para qui'ni equixá'anie iyaba ca nación ca titsa' lí. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Labí ilìdèe pleito lani ca enne', nihua labí ínnie idìtsani para qui'ni gudàliani ca enne' ne, nihua labí tá'béba cuenie lo ca néda. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ttu yà to' nu chìa rirèccu' tè nna labí quittsa telée na; ą'hua ttu lámpara nu átito' rúbá cani latsi'į nna labí guthola telée na, sino runi lée iyaba canu débil cualani. Anía gúnié hàstaá qui'ni itute nu ná lí nna ccą vencer le' itute yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ą'hua ca enne' qui' adí ca nación nna gappa cą confianza làni lèe. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Làniana tahua' cą ru'a lo Jesús ttu nu cca padecer por ttu espíritu malo, ną́ ciego nna mudo nna. Lèe nna beyunie na, lą nna bilá' chìnią nna gunne chìą nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iyaba ca enne' tsè'e nía nna biquila' latsi' quį nna ra luetsi quį: Tsí enni'į ỹa nuá Ỹi'ni David enne' ná qui'ni ìta cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","De biyeni báni ca fariséua qui'ni ra ca enne' anía, acca ra tè cą: Nui nna runią qui'ni eria ca espíritu malo, pero runią na lani la'huacca qui' Beelzebú la nu ną́ nu rigú'ubia' entre adí ca espíritu malua. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pero Jesús nna gutelí taánié la' rulábalatsi' qui' quį nna rèe cą: Canchu nuỹa ttu gobierno lá'aní la' rigú'ubia' quì'į nna til·la tìą contra la'a labíį nna, entonces l·luỹa tabá latsi'į. Ą'hua ca enne' qui' ttu yetsi o ttu familia, canchu lá'aní luetsi quį nna, entonces huaỹia' gáarúbá itsá tsé'e cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ą'hua Satanás nna cáalá rudal·lą fuera ca huenitsìna quì'į nna entonces contra la'a labíį ritil·lą. Canchu ą' runią nna, ti'ala modo cue' tsìttsì la' rigú'ubia' quì'į cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Cáalá por medio de Beelzebú runia' mandado ca espíritu malo qui'ni eria cą, entonces canu ruthète'ni lía nna, núlá por la'huacca quí'ní rudal·la cą fuera ca espíritu malo cá. Acca por nu runi la'a mísmuba canu ruthète' qui' le nna rulue'ní qui'ni yala enne' equivocado ná le. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero por la'huacca qui' Espíritu Santo runia' mandado qui'ni eria ca espíritu maluą', acca hualigani qui'ni chi gul·lani la' rigú'ubia' qui' Tata Dios lani le. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Porqui'ni ti'ani modo cueqquia ttu enne' biỹa té le' yú'u qui' attu enne' sin qui'ni làa gudaxu' ỹą́ xana' yú'a nna guxiqquią bi cá. Laníala nna hua rialanią cueqquią iyate nu té le' yú'u qui' bi. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nu labí du lani inte' nna, contra la inte' duą. Ą'hua nu labí rutuppą lani inte' nna, runìttilo lą́. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Acca nia' le qui'ni iyábani tul·la' nu runi ca enne' nna ą'hua iyábani ca titsa' mal nu rinne cą nna té bá perdón qui' quį. Pero canu rinne biỹa titsa' mal ni contra Espíritu Santo nna, entonces labí perdón té qui' quį, nihua tiempo tsè'e ri'uį nihua tiempo nu chì' da'la nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ą'hua nuỹa diba inne biỹa titsa' mal ni contra Nubeyu' de Ỹiabara' nna, hua té bá perdón quì'į. Pero nu inne biỹa titsa' mal ni contra Espíritu Santo nna, entonces labí gata' perdón quì'į, nihua tiempo tsè'e ri'uį nihua tiempo nu chì' da'la nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Canchu rena le qui'ni ttu yà fruta ną́ tsè', pues ná qui'ni gunną fruto tsè' canchu hualigani ną́ ttu yaga nu riỹu'. Ą'hua canchu rena le qui'ni ttu yà fruta ną́ malo nna, entonces nihua fruto nu runną labí riỹu'ą. Porqui'ni ttu yà nna redacca' rabáníą por ca fruto nu runną. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yala mañoso ná le tì'a ca bèl·là. Ti'ani modo inne le ca titsa' nu ná cą tsè' canchu puro taá mal bá ná la' rulábalatsi' qui' le cá. Porqui'ni ti'ba cani latsi' losto' ttu enne' nna, ą́' bá ná nu rinnią. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Por ejemplo, ttu enne' tsè' nna, cani latsi' lostu'į nu ná tsè', acca rinnią ca titsa' nu ná tsè'. Pero ttu enne' mal nna, cca báni latsi' lostu'į nu ná mal, acca rinnią ca titsa' mal. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Inte' nna nia' le qui'ni iyábani ca titsa' nu labí riỹu' nu rinne ca enne' nna, pues té qui'ni gute cą cuenta canchu chi gal·la' tsá juíciua. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Porqui'ni por la'a mísmuba ca titsa' qui' lu' nna iria nàrì lu', ą'hua por la'a mísmuba ca titsa' qui' lu' nna ccá lu' condenar. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Làniana tuchùppa canu yala tsè' nabia'ni cą nu ra lo ley, ą'hua tuchùppa ca fariséua nna ra cą ne: Maestro, calatsi' tu' ilá'ni tu' ttu señal nu gulue' qui'ni té la'huacca qui' cuią'lu' nu dá'ą de ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Lèe nna becàbie nna rèe cą: Canu tul·la' tsè'e anna pues chi biỹul·lani cą enne' catsi'ínie cą, acca chì' rinàba la cą ttu milagro ỹeni para cáỹelatsi' quį. Pero labí biỹa señal ni ilá'ni cą sino làteruba nu chi uccua lani Jonás enne' uccua profeta tiempo antigua. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Porqui'ni tì'a Jonás nna guyú'u bi por tsunna ubitsa nna tsunna yèla nna lè'e bél·la ỹéniá porqui'ni gutàbią bi enteru taá, ą'hua Nubeyu' de Ỹiabara' nna tsu'u huée lè'e guna' por tsunna ubitsa nna tsunna yèla nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ca enne' qui' ciudad Níniveá nna eyátha cą lani le canchu chi gal·la' tsá juíciua nna cueqquia huá cą sentencia qui' le; porqui'ni lacą nna beyacca cą arrepentir por ca tul·la' qui' quį de biyénini cą predicación qui' Jonás. Pero entre lebi'į nna du ttu enne' adila dacca' ti'chu Jonás, pero labí rudà naga' le quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ą'hua niula gulú'ubia' itute lado sur ttu cuaỹa nuá nna, eyátha huą́ lani le canchu chi gal·la' tsá juíciua nna gutsią causa qui' le para thi' le castigo; porqui'ni idittu' tsè'ni huíą para iyéninią ituba la' riyeni tsè' qui' rey Salomón. Pero entre lebi'į nna du ttu enne' adila sabio tì'chula Salomón, pero labí rudà naga' le quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ttu espíritu malo canchu chi betsè'e latsi'į ttu enne' nna, làniana ribèni lo be' bą́ ca lugar bitsi hueyìla gaỹa edi' latsi'į pero labí ritaxácca'ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Acca canią: Eyèqquia ca'á' litsá'a' làti gudáyá ya'a. Canchu chi etsina'ą nna ilá'nią qui'ni enni'a nna ną́ tì'a ttu yú'u nu nettia bą́ pero chi lúba rabą́ nna yala tsè' chi ną́ arreglado. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Làniana tsią taxi'ą agàtsi ca demonio adila mal ti'chu lą nna gá'a tè iyaba cą lo losto' enni'a nna xúa cą nía. Làniana adí teérula peor ccá la' tté qui' enni'a tì'chula néruá. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Hua rinne canna báni Jesús ca enni'a nna bitsina' tè nàna qui'áa nna ca bettsi'áa nna ribèda cabi e fuera, calatsi' cabi inne cabi lani e. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Gutixà'a tèni ttuą ne nna rą: Nàna qui' cuíą'lu'a lani ca bettsi' cuíą'lu'a nna tsè'e cabi fuera calatsi' cabi inne cabi lani cuíą'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Becàbi Jesús nna rèe na: Nuni nuą' ná nàna quia' nna ca bettsi'à' nna cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Làniana gulìtha tè né'e belui'e ca enne' ruthète'niáa nna rèe: Ca nui ná ca bettsi'à' nna nàna quia' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Porqui'ni nuỹa tediba runi nu rú'ulatsi' Tata quia' enne' dua ỹiabara', pues lanuá ná bettsi'à' nna dána'a' nna nàna quia' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tsá lanía nna biria Jesús le' yú'u nna huíe gùri'e ru'a indatù'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bitùppa tè iỹetse' ca enne' ru'a indatù'a làti ri'áa. Lèe nna gutè'e le' ttu barco nna guduánie nna gunne'e cą nna, ");
INSERT INTO zaaNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","gutixa'ánie cą iỹetse' ca comparación nu cca qui' yétsiloyuį nna ỹiabara' nna rèe: Ttu campesino nna díą huedal·la ỹua'. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","De chi yu'ą́ huedal·la ỹú'a nna binnia tí' ỹua' qui' niá cuitta' neda. Huadi tè ca bìnni to' nna bediga' cą ỹú'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Atí' ỹú'a nna binnią le' íyyarrúe làti labí tegá guna' re'. Ỹú'a nna gul·lani tabą́ porqui'ni labí itettia ga re' guna'. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Làniana gul·lani bitsa nna beqquèxu' taą́ ỹú'a nna gubitsi taą́, porqui'ni labí itettia ga día l·lúį. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Atí' ỹú'a nna binnią làti yù'u huá l·lú ca yettse'. Pero ca yettsi'a nna gul·lani tehuá cą nna bedibàga' taá cą lo ỹú'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero átí' ỹú'a nna binnią le' loyu bèbe làti benna tìą lènà' tsè': ttuą gayua' nna, áttuą gayùna' nna, attuą tsìi érua' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nu calatsi' télini nna gudà nagui'į adí. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Làniana gubiga' ca discípulo qui'áa nna gunaba titsa' cabi e nna ra cabi: Biecca rinèni cuią'lu' ca enne' puro taá lani ejemplo cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Becàbie nna rèe cabi: Porqui'ni lebi'į teruba ná qui'ni télini le ca cosa nu cca qui' la' rigú'ubia' qui' Tata Dios nu labí chi bina ca enne' antes. Pero lacą nna labí ná qui'ni télini cą ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Porqui'ni nuỹa diba té iỹeni quì'į nna, entonces lą nna gunią recibir adila iỹeni. Pero nu labí té quì'į nna, pues hàstaba tito' nu té quì'į nna ítua telą́. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Por nui nna acca rinéni ya' cą puro lani ejemplo bá; porqui'ni hua rinna' bá cą pero labí rilá'ni cą, ą'hua hua rudà naga' quį nna pero labí riyénini cą nihua labí ritelíni cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nì nna cca cumplir lani lacą nu riquixá'a Tata Dios lo libro nu bedia Isaías enne' uccua profeta nna rèe: Màsqui'ba gudà naga' le pero labí télini le. Màsqui'ba tetsùni inna' le pero nihua labí ilá'ni le. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Porqui'ni ca enne' tsè'e le' yetsį nna chi bitechuní cą tul·la'. Riyénini cą pero yala tàbi cani cą. Chi bethàya lo quį para qui'ni làa ilá'ni cą. Chi bethàya naga' quį para qui'ni làa iyénini cą. Anía runi cą para qui'ni làa tsíalatsi' quį, nihua làa eyeqquia cą lani inte', para qui'ni gudilá ya' cą de ca tul·la' qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jesús nna beni bée seguir nna rèe: Ica'rubà le por nu rilá'ni le nna riyénini le nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Hualigani te' nia' le qui'ni iỹetse' ca profétaá ą'hua adí ca enne' canu beni nu rú'ulatsi' Tata Dios nna, yala gudà latsi' cabi ilá'ni cabi nu rilá'ni le, pero labí bilá'ni cabi ą. Uccua huá latsi' cabi iyénini cabi ca titsa' nu riyénini le, pero labí biyénini cabi cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Liudaáruhuá naga' le enseñanza acerca de enne' rudal·la ỹú'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ỹua' nu binnia cuitta' nédaá nna ccą comparar nu riyénini titsa' nu cca qui' la' rigú'ubia' qui' Tata Dios, pero labí ritelínią na, entonces ril·lani tè numalua nna riguą ca titsa' nu biyada lo lòstu'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ą'hua ỹua' nu binnia le' iyyarruéa nna ccą comparar nu riyénini ca tìtsi'į nna luego taá ríalatsi'į nna yala redácca'nią. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero labí re' tsìttsì ga latsi'į, acca tito' rúbá bechią, porqui'ni de gul·lani ca prueba lani ą nna rutsia latsi' ca enne' na porqui'ni ríalatsi'į quia', entonces luego taá redúl·la'a latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ỹua' nu binnia le' yèttsi'a nna, ccą comparar nu rudà naga' ca tìtsi'į pero yala nùyue canią por nu cca qui' bíį, ą'hua la' dàlatsi' qui' yétsiloyuį nna ruthàga' tabą́ ca tìtsi'į lo lòstu'į, acca labí lènà' tsè' runna cą para Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero ỹua' nu binnia le' loyu bèbèa nna, ccą comparar nu riyénini nna ritelí huánią ca tìtsi'į nna runną ttu lènà' tsè', tì'a ca ỹua' nu guyú'u lè'e quį gayua' nna gayùna' nna tsìi érua' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Gutixà'a tènie cabí attu ejemplo nna rèe: Reino qui' Tata Dios nna cca huą́ comparar tì'a ttu enne' nu bedal·la bi semilla tsè' gani le' loyu qui' bi. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero de lo ti'áthi ca mozo qui' bía nna bìta contrario qui' bía nna bedal·lą ỹubànaba' le' loyu làti chi té ỹua'xtílaá, làniana bedà' tìą. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","De chi té ỹú'a nna da' tehuá riduą ettse', pero bilá' huání qui'ni gul·lani ỹubànaba' le' lóyúa. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Làniana ca mozua nna betsina' cą ru'a lo xana' caniá nna ra cą: Señor, tsí álahua semilla tsè' bedal·la cuią'lu' le' loyu qui' cuią'lu'a cá. Ti'ala modo acca té huá ỹubànaba' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Becàbi xana' ỹú'a nna ra bi: Ttu contrario benią na. Làniana ca mozua nna ra cą bi: Tsí hua calatsi' cuią'lu' tsá' tu' nna tál·latsu' tu' ỹubànabá'ą' áccá. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Enni'a nna becàbini bi cą nna ra bi: Bittua chì, porqui'ni nicà'chu tiempo de ril·latsu' le ỹubànaba'a nna íl·latsu' huá le ỹua'xtíla. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Adila tsa' cueda ri'u iỹeni cą júntuba hàsta'na gal·la' tsá éỹu' lènà', lànialá nna épa'a' canu echu ỹú'a: Lechù ỹá ỹubànabá'ą' nna liuỹìga' ą nna, liguni ą manojo para tsayią, làniana edi' le ỹua'xtílą' nna cúa li ą le' yú'u quíya'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Gune huánie cabí attu ejemplo nna rèe: Reino qui' Tata Dios nna ną́ tì'ná bétsi' to' qui' ttu clase de cuàna nu guỹi' ttu enne' nna gudą na le' loyu quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bétsi' tú'a nna adí telá xcuichu to' ną́ de lo iyaba ca semilla. Pero de chi gul·lanią nna biỹenią nna ritè láą lo iyaba ca planta hàstaá qui'ni ca bìnni to' tsè'e lo be' nna rutsia xcu'ni quį lúį. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Gutixà'a tehuánie cabi nna rèe íį: Reino qui' Tata Dios nna ną́ tì' ná levadura nu guỹi' ttu niula nna gulù'uą na le' tsunna yà almudo yedia. Luégutaá nna beyaỹilo ituba cúaá. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Gutixa'áni Jesús ca enni'a iyaba ca enseñánzaá puro lani ejemplos. De ruthète'nie ca enne' nna beni bée comparación de ttu cosa qui' yétsiloyu lani ttu cosa de ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Anía modo nna uccua cumplir nu gune ttu enne' uccua profeta tiempo lanía nna ra bi: Quíxa'a' lani comparación para ethátsila'nà' ca enseñanza nu gattsi' bá dèsdeba loti' uccua yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Làniana bechu titsa' Jesús ca enni'a nna betsine'e le' yú'u. Gubiga' tè ca discípulo qui'áa nna ra cabi e: Bethàtsilà'na bálani cuią'lu' intu' comparación qui' ỹubànaba'a nu gul·lani le' lóyúa. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Becàbie nna rèe cabi: Nu rudal·la semilla tsè'a nna née Nubeyu' de Ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Loyu làti huía ỹú'a nna ccą comparar itúbani yétsiloyu. Pero ỹua' tsè'a nna ccą comparar ca ỹi'ni Tata Dios. Ỹubànaba'a nna ccą comparar ca ỹi'ni numalua. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Contrario nu bedal·la ỹubànaba'a le' lóyúa nna ną́ la'a mísmuba numalua. Tiempo lènà'a nna ną́ fin qui' yétsiloyu. Canù rutuppa lènà'a nna ná cabí ca ángel. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Acca, ti'ba ril·latsu' ỹubànaba'a nna ríą lo yi' para tsayą, ą' bá ccá canchu chi il·lani fin qui' tiempo tsè'e ri'uį. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nubeyu' de Ỹiabara' nna ithel·le'e ca ángel quì'e para gutuppa cabi de le' reino quì'e iyaba canu runi qui'ni innia ca enne' le' tul·la', ą'hua iyaba canu runi bíỹaáru mal nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Làcabi nna gudal·la tè cabi cą le' horno yi'; nía nna ccá cą sufrir nna cuetsi cą nna góya'atsùni laya' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pero ca enne' beni tsè' nna, pues yala enne' dacca' ccá cą le' la' rigú'ubia' qui' Tàta qui' quį nna ccá titti cą tì'a rudàni' bitsa. Nu calatsi' télini nna gudà nagui'į adí. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ą'hua reino qui' Tata Dios nna ną́ tì' ná ttu tesoro gattsi' le' ttu loyu. Betseláni ttu enne' na, pero begattsi' bą́ na attu vuelta. De tantua redácca'nią nna beyyą nna bètti'ą iyate nu té quì'į nna huì'ią lóyúa. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ą'hua reino qui' Tata Dios nna ną́ tì' ná ttu enne' runi negocio reyilą ca perla tsè'ni. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","De bilá'nią ttu perla latsitte ni nna beyyą nna bètti'ą iyate nu té quì'į nna huì'ią pérlaá. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ą'hua reino qui' Tata Dios nna ną́ tì' ná ttu exxa nu rudàxu'ni cą bél·lá. Rudal·la cą na le' indatò' nna rudaxu'ą iyábani clase de bél·lá. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","De chi bitsa' èxxaá nna reyèl·la' cą na rú'alá. De chi ỹuani cą nna redi' cą nu ná tsè', pero canu labí ná tsè' nna riru'na bá cą cą fuera. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ą'hua ccá canchu chi l·luỹa latsi' yétsiloyuį: íl·lani ca ángel nna gútse'e cabi ttu lado ca enne' beni mal, pero attu lado nna ca enne' beni tsè'. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ca ángeliá nna gudal·la tè cabi le' horno yí'a iyaba canu beni mal; nía nna ccá cą sufrir nna cuetsi cą nna góya'atsùni laya' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Bitola nna ra tè Jesús cabi: Tsí hua ritelíni le iyaba nu níyi'į. Becàbi cabi nna ra cabi e: Hua ritelí báni tu' Señor. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Làniana rèe cabi: Acca canchu ttu maestro de la ley déte'tsì'ą ca enseñanza qui' la' rigú'ubia' qui' Tata Dios, pues lą nna ną́ tì'a ttu tàta ribèqquią ca cosa latsitte ní tuànią, tàntua canu cubi nna ą'hua canu viejo nna ruluè'nią ca ỹi'nį. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Beyacca diba gutixà'a Jesús ca ejémpluį nna bede'e nía. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Betsina' tìe látsiáa nna gudulue gutixa'ánie ca enne' tsè'e le' sinagoga qui' caniá nna biquila' ya'ání latsi' quį de tantua tsè' gutixa'ánie cą, acca ra tè cą: Gala da' la' ritelíni nna la'huacca nu té qui' nubeyu'į acca runią ca milagruį cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tsí álahua ỹi'ni carpintérua bá nuą' cá. Tsí álahua nàna qui' niá nuą' lá María cá. Ca bettsi' niá nna lá cą Jacobo nna José nna Simón nna Judas nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ą'hua ca dana niá nna pues le' yetsi qui' ri'uį ba tsè'e cą. Gala taxi'ą iyaba ca enseñánzį cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Por nui nna labí huíalatsi' quį quì'e. Accana ra Jesús cą: Ca enne' rinne titsa' qui' Tata Dios nna, pues gaỹa tediba rappa cą cabi titsa', pero canu látsi cabi lani canu tsè'e le' yú'u qui' cabi nna nidí tito' labí rudà naga' quį qui' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Acca labí benie iỹéegá milagro nía por causa de qui'ni labí huíalatsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tiempo lània nna bina gobernador Herodes iyaba nu runi Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Làniana ra tìą canu runi tsina qui' niá: Nuą' nuá Juan el Bautista nu bétti ya'a nna, chi beyathą de lo canu yatti, acca té iỹeni la'huacca quì'į para gunią ca milagruą'. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Anía ra Herodes porqui'ni bedaxu'ą Juáan preso nna beỹiqquią bi lani cadena nna gutixą bi litsi' ìyyà, por causa qui' Herodías niula qui' bettsi'į Felípea. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Porqui'ni Juáan nna ra bi ą: Tsí làa yu hua lu' qui'ni labí dàni lu' thualani lu' niulą'. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Acca uccua latsi' Herodes gúttią Juáan, pero gutsi bánią yétsiá porqui'ni Juáan nna uccua bi ttu profeta para lacą. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero loti' beni cą celebrar cumpleaños qui' Herodes nna, beyà'a niula cuiti' ỹi'ni Herodías ttubą lahui' iyaba quį. Herodes nna yala guyú'u latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Acca benią ofrecer lani juramento qui'ni gutìą qui' niula cuiti'a iyate nu inàbanią na. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Niula cuiti'a nna bitola de chi gulù'u titsa' nàna qui' niá na, acca rą Herodes: Bènnà nì lè' ttu plato iqquia Juan el Bautístą'. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Làniana yala behuiní'ni Herodes. Pero por causa de qui'ni chìla benią jurar, ą'hua labí uccua latsi'į itìniyúą lani canu ỹuàni lo meỹa lani ą, acca benią mandado qui'ni gute cą bega' iqquia Juáan quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Guthel·la' tìą mandado le' litsi' ìyyàa para ichu cą yani Juáan. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Làniana denua' tè cą iqquia Juáan le' ttu plato, bete cą na lani niula cuiti'a, lą nna bete tìą na lani nàna qui' niá. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bitsina' tè ca discípulo qui' Juáan nna bedi' cabí cuerpo qui' bía nna becattsi' cabi ą. Huía tè cabí nna gutixa'áni cabi Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","De biyénini Jesús razón nì nna bede'e nía nna gutè'e le' ttu barco nna huíe para attu ládula indatù'a ttu lugar yà'latsi' làti lanúgá enne' tsè'e. Pero de bina ca enne' qui'ni chi díe, acca biria cą dèsdeba le' ca yetsi qui' quį nna día tè cą néda yúbitsi lani nì'a quį para tattsa' cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","De beria Jesús le' bárcuá nna bilá'nie qui'ni enne' ỹétse'ni tsè'e chi ribeda cą ne nna, yala betúa latsi'e cą nna beyúnie iyaba canu rà'ni tsè'e lani ca enne' ribeda cą néa. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","De chi da' ràl·làa nna gubiga' ca discípulo qui'áa ru'a lúe nna ra cabi e: Chi ràl·la nna ą'hua làti tsè'e ri'uį nna ną́ fuera yetsi. Bechu titsa' dí cuią'lu' ca enne' para qui'ni eyeqquia cą le' ca yetsi tú'ą' nna gó'o cą nu gó cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús nna rèe cabi: Labí náduel·la' eyya cą. Lebi'į bá liúte gó cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Làcabi nna ra cabi: Labí té qui' tu' sino làteruba gayu' ettaxtíla nna chuppa bél·la nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús nna rèe cabí: Ligunna tsanna cą nì. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Làniana benie mandado guỹuàni ca enne' lo tácca'a. Guỹi' tìe gayu' ca ettaxtílaá nna chuppa ca bél·laá nna guchìtha lúe ỹiabara' nna gunàbeé bendición lani Tata Dios. Làniana gùl·le'ée ca ettaxtílaá nna betie lani ca discípulua, làcabi nna gutìthia cabi lani ca enne' ỹétsi'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Iyáỹiate cą nna gutò cą ti'iỹa bá uccuani qui' quį. Betuppa tè cabi atsì'nu ỹa tsummi tsá'ti'ni ca pedazo nu bexa. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Canu gutúa nna hua ná ttu gayu' mili' ti'ga puro taá ca nubeyu', bittua cuenta re' ca enne' niula nna ca huatsa nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Luego taá beni Jesús mandado éya'a ca discípulo qui'áa le' bárcuá para eneru tè cabi nna ettè cabi attu lado indatù'a, miéntraste lèe nna rechu titse'e ca enne' ỹétse'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bechu titsa' diba Jesús ca enne' ỹétse'a, làniana huíe yà'latsi' lo ttu i'ya para gunie oración. Nía bá re' turúbée gùl·là. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Bárcuá nna chi díą lahui' indatù'a, na' nìni rudàl·la inda bárcuá, porqui'ni còntrala cabi du bè'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Chì' tegáabá da' ràni'a nna rida' Jesús lo indatù'a para taỹénie cabí. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","De bilá'ni ca discípulua ne ride'e lo inda nna guretsi ya'ání cabi de tantua tsanì' ùccuani cabi nna ra cabi: Nu tsá'yela cà'a nuą'. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero Jesús nna bel·luítsa' tè cabi nna rèe: Ligappa confianza inte' bá nui, bittu gátsini le. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Làniana gunne tè Pedrua nna ra bi e: Señor, canchu cuią'bálu' nuą' nna, beni qui'ni thaya' lo indį para íl·lania' ru'a lo cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Lèe nna rèe bi: Gutà. Làniana biria Pedrua le' bárcuá nna guda' bi lo inda día bi ru'a lo Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero de beyu Pedrua qui'ni fuérteni du bè' nna yala gutsini bi, gudulo chì rinetsi bi, gunne tè bi iditsa nna ra bi Señor: Bedilàa cuią'lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Becàa chì ná' Jesús nna beyel·lé'e Pedrua nna ra tìe bi: Hualigani tito' rúbá fe té qui' lu'. Biecca labí gùppa lu' confianza qui'ni té la'huacca quia'. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Huappi bá cabi le' bárcuá nna gudutsi taá bè'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Làniana ca discípulo ca enne' yù'u le' bárcuá nna beduỹíbi cabi ru'a lo Jesús nna beni cabi e adorar nna ra cabi: Hualigani qui'ni cuią'lu' Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","De beyacca guttè cabi lo indatù'a nna bitsina' cabi ru'a loyu qui' ca enne' Genesaret. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Benibiá' bá canu nía ne nna bedàa chì cą titsa' le' iyaba ca yetsi to' anta' nía. Làniana tahua' cą iyaba canu rà'ni ru'a lúe. ");
INSERT INTO zaaNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Gutta'yúni cą ne qui'ni hue'èl·le'e cą gulappa' cą màsqui'di ru'a ỹúe. Iyaba canu belappa' cą ne nna beyacca tabá latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Làniana tuchùppa ca maestro de la ley qui' ca judíua lani tuchùppa canu gulátsi' religión lą́ fariseo nna da' cą de Jerusalén nna bitsina' cą ru'a lo Jesús nna ra cą ne: ");
INSERT INTO zaaNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Biecca làa rigua ca discípulo qui' lu'ą' costumbre nu rulue' ca enne' gùla qui' ri'u ni'i, porqui'ni ca discípulo qui' lu'ą' nna labí runi cą ná' quį purificar, tì'a ná qui'ni guni ri'u ántesca go ri'u, acca rappa cą tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Becàbie nna rèe cą: Biala cca lebi'į nna labí rigua le ca mandamiento qui' Tata Dios porqui'ni runi la le ca costumbre qui' bá le ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ttu mandamiento qui' Tata Dios nna ra íį: Gùppa respeto tàta nàna qui' lu'. Ra huée: Nuỹa diba riyèe' iqquia tàta nàna quì'į nna té qui'ni gattią. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero lebi'į nna rena la le qui'ni hua té bá permiso qui' nuỹa para gą́ tàta nàna quì'į: Iyaba nu ná qui'ni gunia' le cualani nna chìla beté ya' ą para Tata Dios, ");
INSERT INTO zaaNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","acca labiru caduel·la' gunia' cualani tàta nàna quia'. Pero inte' nna nia' le qui'ni ą' modo nna riru'na le mandamiento qui' Tata Dios por tantua costumbre qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yala la' beỹia té le' la'riyeni qui' le. Hualibani Tata Dios nu rèe acerca de lebi'į lo libro nu bedia Isaías enne' uccua profeta nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yetsi ri'į nna, pues lani rú'a terúbį́ rudettią inte', pero lostu'į nna idittu' tsè' duą lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","De balde bá rexa latsi' quį inte', porqui'ni rulue' cą ca enseñanza nu guleqquia bá iqquia ca enne' ti'atsi ną́ ttu mandamiento nu ná ligani. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Làniana gutaỹi tè Jesús ca enne' ỹétsi'a nna rèe cą: Liudà naga' le para télini le. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Alahua por nu ro ttu enne' acca chi ną́ enne' tul·la'; sino nu riria la rú'a ttu enne', lànua nna runią qui'ni ną́ nu tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Bitola nna gubiga' ca discípulo qui'áa ru'a lúe nna ra cabi e: Tsí hua yù cuią'lu' qui'ni biyeni dí'ni ca fariséuą' por ca tìtsa'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Becàbi tìe nna rèe cabi: Iyaba ca planta canu labí guda Tata quia' enne' dua ỹiabara' nna, pues té bá qui'ni il·latsu' cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bittu ccani canchu bitsa'áni cą, porqui'ni ná cą tì'a ca ciego canu riyèl·la' cą ná' adí ca ciego. Canchu ttu ciego quél·la'ą ná' attu luetsi ciéguį nna, entonces chuppa tè cą nna innia cą lo bèl·la'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Làniana Pedrua nna ra bi e: Bethàtsi là'nanì cuią'lu' intu' ejemplo nu gutixá'a cuíą'lu'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús nna rèe: Tsí nihua lebi'į nna bihua nì' télini le cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tsí bihua yù le qui'ni iyaba nu rà'a rú'a ttu enne' nna día bą́ lì'į, làniana iru'na bą́ cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero ca titsa' nu riria la rú'a ttu enne' nna dá'ą de lo lòstu'į nna ą'hua de la' riyeni quì'į nna, lànuá nna runią qui'ni ną́ enne' tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Porqui'ni de lo losto' ca enne' nna riria ca la' rulábalatsi' mal para gútti cą enne', ą'hua para thúalani cą attu niula huaya' o adí ca cosa nu labí ná qui'ni guni cą, ą'hua la' ubàna nna, la' huètti enne' nna, ą'hua la' huènilatsi' nna, la' hueqquia bela'na nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iyaba ca cosį nna ná cą nu runi qui'ni ca enne' nna chi ná cą enne' tul·la', pero bíttuhua porqui'ni làa runi cą ná' quį purificar ántesca go cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Beria Jesús nía nna huíe para región qui' ca yetsi Tiro nna Sidón nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Làniana biria tè ttu niula nía ną́ enne' Canaán pero duą nía nna gunnìą iditsa nna rą ne: Cuią'lu' Señor Ỹi'ni David enne' uccua rey, betúalatsi' cuią'lu' inte' porqui'ni yàl·la'ni chi té ỹi'ni ya'a ccą padecer por ttu espíritu malo. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero Jesús nna labí becabínie na titsa'. Làniana gubiga' ca discípulo qui'áa ru'a lúe nna gutta'yúni cabi e nna ra cabi e: Becabíni ą porqui'ni tanto iditsa rinnią dá'ą cuè'e la ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús nna rèe: Guthel·la' Tata Dios inte', alàa para luetsi niulą' sino làteruba para ca enne' Israel, qui'ni ca enne' Israel nna ná cą tì' ná ca carnero to' nu chi gunitti nna lanú pastor qui' quį té. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Gubiga' niuláa nna beduỹíbį ru'a lúe nna rą ne: Señor, beni cuią'lu' inte' cualani. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Becàbi Jesús nna rèe na: Labí ná tsè' qui'ni ttu tàta nna cúą ettaxtíla lo ná' ca ỹi'nį para gudal·lą na ru'a ca beccu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Becàbi tè niuláa nna rą: Hualibani cuią'lu' Señor, pero ca beccu' to' nna ro ba cą ca pedazo nu rinnia ru'a meỹa qui' xana' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Làniana becàbi Jesús nna rèe na: Lu' niula, hualigani chi ríalatsi' lu' qui'ni iỹeni la'huacca té quia', acca ccá bá lani lu' tì'a ná bá la' rinàba qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Guttè diba Jesús nía nna gutèl·lé'e néda nu día ru'a indatò' qui' Galilea, bi'yu tìe lo ttu i'ya, nía nna gure' tènie. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nuỹetse' ca enne' nna bitsina' cą ru'a lúe chè' cą ca enne' ná cojo nna ciego nna ca enne' ỹí nna ca enne' manco nna ą'hua iỹétse'éru canu rà'ni nna betse'e cą iyaba cą ru'a lúe. Lèe nna beyunie iyaba cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ca enne' ỹétsi'á nna biquíla' ya'ání latsi' quį de bilá'ni cą qui'ni ca enne' ỹía nna chi rinne cą, ą'hua ca enne' máncuá nna chi tsìa nì'a ná' quį, ą'hua ca enne' cojua nna chi rida' cą tsè', ca ciégua nna chi rilá'ni cą. Acca yala bedàliani cą Tata Dios enne' runi ca enne' Israel adorar. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús nna gutaỹie ca discípulo qui'áa nna rèe cabi: Yala retúa látsa'a' ca enni'į porqui'ni chi uccua tsunna ubitsa tsè'e cą lani inte' nna labí biỹa té go cą. Labí calátsa'a' ethél·la' ya' cą porqui'ni xiaba igutsi latsi' quį lo néda canchu làa go tí'ỹá cą primero. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Làniana ca discípulo qui'áa nna ra cabi e: Calegáhua taxi' tu' iỹeni tsè'ni ettaxtíla para úgo ri'u ca enne' ỹétsi'į, porqui'ni tsè'e ri'u ttu lugar idittu' de làti anta' ca yetsi. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús nna rèe cabi: Bàl·la cà'a ettaxtíla dèni le. Becàbi cabi nna ra cabi e: Gàtsi teruba, ą'hua tuchùppa bél·la to' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Làniana gunènie ca enne' ỹétsi'á qui'ni xúani cą loyu. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Guỹi' tìe gàtsi ca ettaxtílaá lani ca bél·la tú'a nna, be' tìe gracia lani Tata Dios. Làniana gùl·le'ée cą nna bì'e ca discípulo qui'áa. Ca discípuluá nna gutìthia cabi lani ca enne' ỹétsi'á. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Iyaba cą guto cą ti'iỹa bá uccuani qui' quį. Làniana betuppa tè cabi ca pedazo nu bexa, gàtsi tsummi tsá'ti'ni. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Entre ca enne' gutó lània nna uccua chua' vuelta gayua' ca nubeyu', bíttua cuenta re' ca niula nna ca huatsa nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Làniana bechu tìtse'e ca enne' ỹétsi'á nna gutà'a tìe le' bárcuá nna déyyeé para lado región lą́ Magdala. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Làniana ca fariséua nna ca saducéua nna bitsina' cą ru'a lo Jesús gunàba tèni cą ne qui'ni gunie ttu prueba nu rulue' qui'ni la'huacca quì'e nna dá'ą de ỹiabara'. Anía beni cą para eyìla cą néda ti'iỹalá modo cu'ée ttu falta. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Becàbinie cą nna rèe: De chi rayi bía de diál·lalá nna rena le: Yala tsè' porqui'ni rayi bía, acca huètsa'a bá uxé. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ą'hua canchu chi reyana' bía de díla nna rena le: Iyya l·lá ccá natsá. Hua ritelí báni le ca seña nu cca ỹiaba, atsi'íni rena le qui'ni làa ritelíni le ca cosa de la'huacca de ỹiabara' nu chi cca lani le annana. Labí líni le. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Benie seguir nna rèe: Ca enne' máluį nna chi biỹùl·lani cą enne' catsi'ínie cą, chì' rinàba láni cą inte' qui'ni gunia' ttu milagro nu gulue' qui'ni da' la'huacca quia' dèsdeba ỹiabara'. Pero labí biỹa señal ni ilá'ni cą sino làteruba nu uccua lani Jonás enne' uccua profeta. Beyacca bá rèe cą anía nna bedà' tìe. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","De bitsina' cabi attu lado indatù'a nna bexa latsi' ca discípulo qui'áa qui'ni labí nùà' cabi ettaxtíla. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús nna rèe cabi: Lihue' cuidado lani levadura qui' ca fariséuą' nna ca saducéuą' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ca discípulo qui'áa nna gudulo cabi gunèni luetsi cabi nna ra cabi: Porqui'ni labí nùà' ri'u ettaxtíla, acca rèe lą'. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Gutelí taáni Jesús acca rèe cabi: Biecca rulaba latsi' le porqui'ni labí ettaxtíla nùà' le acca nia' nuą' ni'i. Hualigani tito' rúbá fe té qui' le lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tsí àtsahua labí ritelíni le nihua làa rexa latsi' le de lo gayu' ca ettaxtílaá nna bàl·la cà'a tsummi ca pedazo betuppa le de chi beyacca gutó gayu' mili' ca enni'a cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tsí nihua làa rexa latsi' le de lo gàtsi ca ettaxtíla entre tappa mili' ca enni'a nna ábal·la cà'a tsummi ca pedazo nu bexa bedi' le cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Biani cca àtsahua nì' télini le qui'ni álahua por ettaxtila nuą' acca nia' qui'ni hué' le cuidado por levadura qui' ca fariséuą' nna ca saducéuą' nna cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Làniana bennia cabi cuenta qui'ni calatsi'e hué' cabi cuidado qui'ni làa thacca'ỹí cabi por ca enseñanza bèỹia qui' ca fariséua nna ca saducéua nna, alàa por attu levadura. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Deyya tè Jesús para región làti re' yetsi Cesarea de Filipo, làniana gunàba tìtse'e ca discípulo qui'áa nna rèe cabi: Nubeyu' de Ỹiabara' nna, nuni nua' rena ca enne' qui'ni ną́ cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Becàbi cabi nna ra cabi e: Ttu te cą nna rena cą qui'ni ná cuią'lu' Juan el Bautista; áttu te cą nna rena cą qui'ni ná cuią'lu' Elías; áttu te cą nna rena cą qui'ni ná cuią'lu' Jeremías o nùỹala ttu ca profétaá. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Lèe nna rèe cabi: Lebi'į chúná, biala rulaba latsi' le nu cca quia' ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Gunne tè Simón Pedrua nna ra bi e: Cuią'bálu' Enni'a Cristo Ỹi'ni Tata Dios enne' bàni tulidàba. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Làniana ra Jesús bi: Yala ica'rubà lu' Simón Ỹi'ni Jonás, porqui'ni chi uccua nui declarar lani lu', alàa por nuỹa enne' ni le' yétsiloyuį sino por Tata quia' enne' dua ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ą'hua nia' lu' qui'ni lu' ná lu' Pedro, quiere decir: piedra. Iqquia cimiéntuą' nna ilítha'a' iglesia quia'. La'huacca de lù'uti nna labí írialanią gunią vencer contra iglesia quia'. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Inte' nna gúnná' lani lu' la'huacca para ithàlia lu' reino qui' Tata Dios para ca enne'. Iyaba nu guni lu' permitir le' yétsiloyu nna ą'hua ccą́ permitir ỹiabara', pero canchu labí nna, labí. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Làniana gunèni Jesús ca discípulo qui'áa qui'ni nú ttu tehuá nuỹa quixá'ani cabí qui'ni lèe enni'a Cristo. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dèsdeba lània nna gudulo Jesús gutixa'ánie ca discípulo qui'áa qui'ni naduel·la' éyyeé Jerusalén para quée padecer làtsi' ná' canù rigú'ubia' lè' yétsiá, ą'hua làtsi' ná' ca sacerdote principal nna ca maestro de la ley qui' ca judíua nna. Gutixà'a huée qui'ni gútti cą ne, pero bitsa tsunna nna eyáthèe de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Làniana gulèqquia yetsi' tè Pedrua ne nna gudulo bi ritsa' bi e nna ra bi: Señor, bittu ina cuią'lu' ą', nìdirubani ttu nu ra cuíą'lu'ą' làa tté cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Laniana gùnna' tsè' tè Jesús Pedrua nna rèe bi: Becuìtta ru'a lua' Satanás porqui'ni estorbo la runi lu' quia', labí rulaba latsi' lu' nu cca qui' Tata Dios sino nu cca qui' ca enne' la. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Làniana ra Jesús iyaba ca discípulo qui'áa: Canchu nuỹa calatsi'į thá'ą lani inte' nna té qui'ni iỹùl·lanią la'a labą́ nna ga'ną dispuesto gúchią curutsi ìdi'i qui'į nna tanuą inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Porqui'ni nuỹa tediba dua iqquį etúa latsi'į la'labàni quì'į nna, pues gunìtti lą́ na. Pero nuỹa tediba iria latsi'į la'labàni quì'į hàstaá canchu caduel·la' gattią porqui'ni denúą inte' nna; pues lą nna ccabàni lą́. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Biani liecca canchu ttu enne' nna gunią gana itute yétsiloyu, pero bitola nna nitti bą́ para siempre ni'i. O biani tì'na gute ttu enne' lani Tata Dios para gáỹaní nu dacca' la'labàni quì'į cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Porqui'ni Nubeyu' de Ỹiabara' nna itée lani la'yani' nna la'dàliani qui' Tata qui'áa, ą'hua lani ca ángeli quì'e; làniana quíthie qui' ttu ttu tsa ca enne' ti'iỹa ná bá nu beni cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Hualigani nia' le qui'ni tuchùppa le canu tsè'e nì lani inte' nna labí gatti le hàsta'na ilá'ni le Nubeyu' de Ỹiabara' dé'e para quée Rey nna cu'úbi'e. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Xuppa ubitsa bitola nna, Jesús nna guleqquie Pedrua nna Jacobua nna lani bettsi' bi Juáan yà'latsi', guchi'e cabi lo ttu i'ya ỹeni tsè'. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nía nna bettsiání la' rinna' quì'e ru'a lo cabi nna uccua tittiní lúe tì'a bitsą', ą'hua ỹúe nna beyacca tsíttsi tùni ti' taání ỹiani' bitsą'. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","De repente taá nna gudu Moisés nna Elías nna ru'a lo cabi nna rue' cabi titsa' lani e. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Gunne tè Pedrua nna ra bi Jesús: Señor, yala tsè' canchu eya'na ri'u nì. Canchu hua calatsi' cuią'lu' nna guni tu' tsunna yú'u l·la' to', ttu para cuią'lu' nna, attu para Moisés nna, attu para Elías nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Atsaba rinne Pedrua nna gul·lani ttu bía nu rudàni'raba nna bedibàga'ą cabi. Biyeni tè tsi'i ttu enne' gunnie dèsdeba le' bía nna rèe: Là enni'į Ỹi'nia' yala catsi'í ti' e, yala redacca' te' por nu runie. Liúda naga' le quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","De biyénini ca discípulua ca tìtsi'į nna gubixi cabi gure'ló taá làti tsè'e cabía de tantua gutsini cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Làniana gubiga' Jesús beláppe'e cabi nna rèe: Leyátha nna, bittu gátsini le. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Guchìtha tè lo cabi pero lanuru nuỹa bilá'ni cabi sino áláteruba Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Beyàdi bá cabi lo í'yaá nna gunèni Jesús cabi nna rèe: Nú ttú tehua nuỹa quixa'áni le nu bilá'ni le sino hàsta'na qui'ni Nubeyu' de Ỹiabara' nna eyáthèe de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Làniana ca discípulo qui'áa nna gunàba titsa' cabi e nna ra cabi: Biala cca rena ca maestro de la ley qui'ni naduel·la' ìta yà'la la Elías cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Becàbi Jesús nna rèe cabi: Hualiba yà'la Elías ìta; làbi nna guni bi arreglar iyábani. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pues Elías nna chìla bìta bi, pero labí benibia' ca enne' bi sino bethácca' la cą bi iyate nu uccua latsi' quį. Ą'hua Nubeyu' de Ỹiabara' nna beyàlò bá ná nu guthacca' cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Làniana gutelíni ca discípulua qui'ni qui' Juan el Bautista nuá rèe anía. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","De betsina' cabi làti tsè'e ca enne' ỹétsi'á nna bitsina' tè ttu nubeyu' beduỹíbį ru'a lo Jesús nna rą ne: ");
INSERT INTO zaaNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Señor, betúa latsi' cuią'lu' ỹi'ni yi'į qui'ni yu'ą́ be' nna yala telá fuerte ridacca'ą; iỹé vuelta chi gubixią lo yi' ą'hua le' inda nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Chi tahua' ya' ą ru'a lo ca discípulo qui' cuíą'lu'į pero labí uccuani cabi eyuni cabi ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Becàbi Jesús nna rèe: Lebi'i canu labí ríalatsi' nna díátia le canu tul·la' nna, atsália cà'a itsá dà te' cuenia' lani le. Atsália cà'a itsá té qui'ni guchia' le cá. Lítahuá' ą nì. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Làniana gutil·la Jesús espíritu malua nna betsè'e taá latsi'į nubeyu' cuìti'a. Dèsdeba hora lània nna beyacca chì latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","De chi tsè'e cabi yà'latsi' nna gunàba titsa' ca discípulua Jesús nna ra cabi: Biecca intu' nna bihua uccuani tu' gudal·la tu' ą fuera cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús nna rèe cabi: Porqui'ni labí rappa le confianza lani Tata Dios. Hualigani te' riquixa'ánia' le qui'ni cáalá fe qui' le ną́ màsqui'di medida ttu bétsi' cuàna nna huaccani le guni le mandar i'ya duį: Guttè nà'la, entonces hua ttìą. Porqui'ni labí biỹa té nu làa cca posible canchu ríalatsi' le Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero luetsi ca espíritu maluą' nna labí ỹá eria bą́ sino lani oración nna ayuno nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","De tsè'e cabi región qui' Galilea nna ra Jesús cabi: Nubeyu' de Ỹiabara' nna gute cą ne cuenta làtsi' ná' ca enne' para quée sufrir nna, ");
INSERT INTO zaaNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ą'hua gútti cą ne nna, pero bitsa tsunna nna eyáthèe de lo lù'uti. De biyénini cabi rèe anía nna yala behuiní'ni cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","De bitsina' cabi Capernaum, làniana canu ruquiỹa chuppa dracma huía cą ru'a lo Pedrua nna ra cą bi: Maestro qui' lía' nna, tsí bihua rute qui' ládi bi chuppa moneda cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedrua nna ra bi cą: Hua rutie ỹa. Gutà'a tè Pedrua le' yú'a, pero yà'lala Jesús bel·luítse'e bi nna rèe: Simón, biani ra lu' de nu cca qui' ca impuesto nna qui' ládi nna nu ruquiỹa ca rey le' yétsiloyu. Nuni ruquiỹa cą, tsí ruquiỹa cą ca ỹi'ni quį, o, tsí canu fuera bá áccá. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Becàbi Pedrua nna ra bi e: Canu fuera nna té qui'ni quiỹa cą. Jesús nna ra tìe bi: Entonces ca ỹi'ni rey nna tsè'e bá cą libre álá. ");
INSERT INTO zaaNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero para qui'ni nú ttu nuỹa gutsa'áni iqquį nna, acca lu' nna huía ru'a indatù'ą' para gudaxu' lu' bél·lá. Bél·la nu gudaxu' lu' primero nna ebeqquia lu' ą nna ithàlia lu' rú'į. Porqui'ni nía nna yù'u ttu moneda nu dacca' tappa dracma, thi' lu' ą' nna gute lu' ą' lani cą para qui'ni quiỹa lu' nu cca quia' nna nu cca qui' lu' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tiempo lània nna gubiga' ca discípulua ru'a lo Jesús nna ra cabi e: Nuni ná nu adiru re' cuenta le' reino qui' ỹiabara' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús nna gutaỹi tìe ttu huatsa to' nna bedue na lahui' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Làniana rèe: Hualigani te' riquixa'ánia' le, canchu labí guttsiání la' rulábalatsi' qui' le nna tsíalatsi' le tì'a ca huatsa to' nna entonces labí gá'a le le' reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Acca nuỹa diba ną́ enne' losto' humilde ti'ba huatsa tú'į nna, lanuá nna ną́ nu adiru re' cuenta le' reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ą'hua nuỹa diba gunią recibir ttu huatsa to' luetsi huátsíį porqui'ni ríalatsi'į inte' nna, inte' ba nuá runią recibir. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ą'hua nuỹa diba guni qui'ni innia le' tul·la' nuỹa ttu canu xcuichu to' canu ríalatsi' quį inte' nna, pues enne' gulú'u fáltaá nna adila tsa' iỹìqquia yanį ttu iyya molino nu adiru xeni nna gudal·la tè cą na lahui' indatò'. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ica'rútsi'íru yétsiloyu por ca tul·la', porqui'ni tulidàba ril·lani tentación lani ą. Pero ica'rútsi'íru nu runi qui'ni richèccu' ca enne' nna runią qui'ni innia cą le' tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Acca canchu ná' lu' o nì'a lu' runi cą qui'ni runi lu' tul·la' nna, guchu telá cą nna guru'na cą: porqui'ni adila tsa' qui'ni dua ttu teruba nì'a ná' lu' nna gata' la'labàni nu labí ttíą qui' lu' tì'ca'la tsìa chuppa nì'a ná' lu' nna tsía lu' lo yi' nu labí fin quì'į té. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ą'hua canchu ttu lado íyyalo lu' runią qui'ni runi lu' tul·la' nna, gulèqquia telá ą nna guru'na ą; porqui'ni adila tsa' gata' la'labàni nu labí ttíą qui' lu' lani ttu teruba íyyalo lu', tì'ca'la tsìa chuppa íyyalo lu' nna tsía lu' lo yi'bél·laá. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Bittu guni le despreciar nuỹa ttu canu xcuichu tú'į porqui'ni riquixa'ánia' le qui'ni ca ángel ca enne' rue' cabi cuidado ttu ttu ca huatsa tú'į nna tulidàba tsè'e cabi ru'a lo Tata quia' enne' dua ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nubeyu' de Ỹiabara' nna bitée para gudilèe iyaba canu chi gunitti. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Biala ina le qui' ttu enne' canchu tsè'e gayua' carnero quì'į pero nuỹa ttu cą nna iyàl·lą̀, tsí bihua guni segúruą canu noventa y nuévea nna tsíą lo ca i'ya tatìlą nu biyál·láa cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Canchu chi betselánią na nna, hualigani qui'ni adila redácca'nią por ttu teruba carneru to' qui' niá tì'ca'la por iyaba canu noventa y nueve tsè'e ba cą seguro. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ą'hua labí ná voluntad qui' Tata Dios qui' lía qui'ni níttí nuỹa ttu ca huátsíį. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Canchu ttu hermano qui' lu' rigú'ą falta contra lu' nna, huía litsi'į nna, nía nna entre chùppa teruba le nna eyìla lu' modo para qui'ni ennią cuenta nu benią. Canchu gudà nagui'į qui' lu' nna entonces chi beyacca tsè' lu' hermano qui' lu' a. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero canchu labí gudà nagui'į qui' lu' nna, huía litsi'į attu vuelta nna guche' ttu o chuppa enne' para qui'ni nu ina chuppa o tsunna ca testigua nna tsu'úni iyaba titsa'. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Canchu nihua lani lacą làa iyéninią nna entonces gutixà'a telani itute iglesia. Canchu nihua lani iglesia làa gudà hua nagui'į nna, bèni telá ą tratar ti'atsi ttu nu fuera o ttu nu ruquiỹa xatta qui' impuesto. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Hualigani te' nia' le qui'ni iyaba nu guni le permitir le' yetsiloyu, ą́' cca permitir le' ỹiabara', pero canchu labí nna, labí. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Attu vuelta riquixa'ánia' le qui'ni canchu chuppa le tsè'e le de acuerdo le' yétsiloyuį acerca de biỹa diba cosa nu inàba le lani oración nna, entonces Tata quia' enne' dua ỹiabara' nna gunie na para lebi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Porqui'ni gaỹa tediba tsè'e chuppa o tsunna ca enne' retuppa lani nombre quia', nía nna dua' lahui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Làniana gubiga' Pedrua ru'a lúe nna ra bi e: Señor, bàl·la vuelta cà'a eyuniỹén látsa'a' qui' ttu hermano quia' nu cu'ą́ falta contra inte' cá. Tsí bedaá' gàtsi tì'a cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús nna rèe bi: Alàa nia' lu' gàtsi teruba, sino setenta vuelta gàtsi. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Acca por nui nna reino qui' Tata Dios nna ną́ tì'a ttu rey uccua latsi' bi eyuni bi cuenta lani canu runi tsina qui' bía. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Gudulo tè bi ribeqquia bi cuenta nna biria tè ttu nu dàa qui' bi tsìi mili' ỹa bel·liu nu de oro nna plata nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pero lą nna labí té quì'į quiỹą nu dàa naá, acca enne' uccua rey nna beni bi mandado ca siervo qui' niá qui'ni gutti' cą na por precio lani attu enne' huaya' para gunią tsina lúį, ą'hua qui'ni gutti' huá cą niula qui' niá nna ca ỹi'nį nna tsá'tséla tehua iyate nu té quì'į para quíỹaní cą ỹiyya' qui' niá. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Làniana beduỹíbi nubeyu'a nna gutta'yúnią rey xana' niá nna rą: Señor, guppa cuią'lu' paciencia quia', hua yíỹá bétsi bá' iyate nu dà'a' qui' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Rey enne' ná xana' niá nna yala sentir uccua bi quì'į nna betúa latsi' bi ą nna beyuniỹén latsi' bi itute ỹiyya' nu dàą qui' bía nna bela' tè bi ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Beria dibą nna bitsà' tìą ttu compa' quì'į nu ràl·la' huą́ quì'į tuchùppa gayua' beỹu teruba nna, pero bedaxu' chìą na guduluą rithią yanį nna rą na: Gutìỹa nu ràl·la' lu' quia'. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Làniana nubeyu'a nna beduỹíbį ru'a lúį gutta'yúnią na rą na: Gùppa paciencia quia', hua yíỹá bétsi bá' iyate nu dà'a' qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero lą nna labí uccua latsi'į, sino qui'ni bedal·la lą́ na litsi' ìyyà hàsta'na qui'ni quiỹą quì'į nu ràl·la'ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bilá' báni adí ca mozua ca cosa mal nu beniá nna yala triste uccuani cą nna huía cą taquixá'ani cą xana' ca niá iyaba nu uccua. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Làniana xana' ca niá nna gutaỹi bi ą attu nna ra bi ą: Huenitsìna mal, inte' nna beyuniỹén taá látsa'a' iyate nu dàa lu' quia' porqui'ni gutta'yúni lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Lu' chúná, tsí bihua dàni lu' etúa huá latsi' lu' qui' luetsi to' lu'ą' tì'a inte' betúa látsa'a' lu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Làniana adí telá bitsá'ani bi nna bete tè bi ą para ccą́ castigar hàstaá qui'ni éyíỹą iyáỹiate nu ràl·la'ą qui' bi. ");
INSERT INTO zaaNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Anía guni Tata quia' enne' dua ỹiabara' lani ttu ttu tsa le canchu làa eyuniỹén huá latsi' le lani itute latsi' le ca falta qui' ca hermanos qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Beyacca bá gunne Jesús ca tìtsa'a nna bede'e Galilea nna guttìe yò Jordán, làniana betsine'e región qui' Judea. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ca enne' ỹétse'ní nna denó cą ne. Nía nna beyunie cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Làniana bitsina' tè ca fariséua ru'a lúe para eyìla cą néda ti'iỹlá modo inne cą canchu xiaba uquìnnia cą ne lani ttu titsa', acca gunàba titsa' cą ne nna ra cą: Tsí hua ná tsè' qui'ni ttu nubeyu' nna éla'ą́ niula quì'į para biỹa tediba caúsani cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Becàbie nna rèe: Tsí bihua ni' gul·la le lo Escritura qui'ni Tata Dios enne' betsi'e cą yétsiloyu dèsdeba néruá, nubeyu' nna niula nna benie cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Raáruhuée cą: Por nui nna guthà'na ttu nubeyu' tàta nàna quì'į nna itsà' tìą niula quì'į, làniana chuppa cą nna chi ná cą ttùba. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Làniana labiru ná chuppa cą, sino qui'ni ttùba chi ná cą. Acca por nui nna, nu bettsà' Tata Dios luetsi quį nna, labí ná qui'ni nuỹa el·la'ą́ cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Làniana ca fariséua nna ra cą ne: Biala cca ra Moisés qui'ni huacca bá ilìtha ttu nubeyu' acta de divorcio nna éla'ą́ tìą niula quì'į cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Bécabinie cą nna rèe: Por la' necio bá qui' le acca benna Moisés permiso qui'ni éla'á le niula qui' le, pero néruá nna labí uccua ą́'. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Inte' nna riquixa'ánia' le claru taá qui'ni nuỹa diba éla'ą́ niula quì'į pero álahua porqui'ni gùdualani niula attu nubeyu' huaya' sino porqui'ni calatsi'į thí'ą attu niula huaya' nna, nui nna chi ná adulterio nu runią. Ą'hua nu edi' niula nu béla'á naá nna runi huą́ adulterar. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Làniana ca discípulo qui'áa nna ra cabi e: Canchu ą́'ba ná la'ritè qui' ttu nubeyu' lani niula quì'į nna entonces bihua cuenta tíą na guttsaní'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Làniana rèe cabi: Alahua iyá ca enne' rulaba latsi' quį ą́', sino làteruba canu chi nani Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Por ejemplo, tsè'e canu gùlia sin capacidad para guttsaná' quį. Ą'hua tsè'e canu ná cą incapaz, porqui'ni ą́' uccua latsi' ca enne' qui'ni ccá cą. Ą'hua tsè'e canu dua ttùba cą pero solamente por amor nu té qui' quį por la' rigú'ubia' qui' Tata Dios. Nui nna ną́ para canu rulaba latsi' quį qui'ni nu ra ca tìtsi'į nna hua ná tsè' para lacą. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Làniana ca tàta nàna nna tahua' tè cą ca huatsa to' ru'a lo Jesús para qui'ni gutsia né'e iqquia quį nna gunie oración por lacą. Ca discípulua nna gutil·la la cabi cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero Jesús nna rèe cabi: Lihue'el·la' ca huatsa tú'ą' ibiga' cą ru'a lua', bittu guthàga' le cą; porqui'ni quì'ba luetsi ca huatsį nna ná iyaba canu rue'èl·la' cą qui'ni Tata Dios nna quée enne' rigú'ubia'nie cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","De chi betsia né'e iqquia ca huátsáa nna benie cą bendecir nna, bedà' tìe nía. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Làniana bitsina' tè ttu nubeyu' soltero ru'a lo Jesús nna rą ne: Maestro bueno, biani cosa tsè'ni gunia' para la'labàni nu labí ttįa quia' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Lèe nna rèe na: Biecca ra lu' inte' enne' bueno ni'i. Ni ttú lanú té ná completamente tsè' sino tùteruba Tata Dios. Canchu calatsi' lu' gata' la'labàni qui' lu' nna ná qui'ni guni lu' tsè' taá nu ra ca mandamiento. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Lą nna ra tìą ne: Nula cą. Jesús nna rèe na: Bittu gútti lu'. Bittu thúalani lu' nu labí ná tsela lu'. Bittu cuana lu'. Bittu ichìtha lu' bela'na qui' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gùppa respeto tàta nàna qui' lu'. Catsi'íni lu' luetsi enne' lu' ti'atsi la'a lu' bá. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nubéyu'a nna rą ne: Iyaba ca mandamiéntuą' runia' dèsdeba ná' xcuìchuto'. Biaruálá reyatsa te' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús nna rèe na: Canchu calatsi' lu' cca lu' enne' tsè' gani nna, beyya nna betti' biỹa té qui' lu' nna bete tì ą lani ca enne' rittè là'di', pues ỹiabara' la nna gata' riqueza qui' lu'; làniana gutà tè tanó inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","De biyénini nubeyu' soltérua nu rèe na, triste tsùba beyeqquią, porqui'ni yala rico ną́. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Làniana ra Jesús ca discípulo qui'áa: Hualigani te' riquixa'ánia' le qui'ni yala tàbi ná qui'ni ttu enne' rico nna hue'él·la'ą qui'ni Tata Dios nna quée enne' cu'úbia'nie na. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nia' le qui'ni ỹánaba gá'a ttu camello le' yeru to' qui' ttu guỹa, tì'chula ttu enne' rico gá'ą le' reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","De biyénini ca discípulo qui'áa nui nna yala biquila' latsi' cabi nna ra cabi: Entonces núlá ccani l·lą́ cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Gunna' tè Jesús cabi nna rèe: Para ca enne' nna labí ná posible, pero lani Tata Dios nna ỹánaba iyate ca cosa. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Làniana gunne tè Pedrua nna ra bi e: Intu' nna iyáỹiate chi bethà'na tu' nna chi denó tu' cuią'lu'. Biala thi' tu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Becàbi Jesús nna rèe cabi: Hualigani te' riquixa'ánia' le qui'ni gal·la' tsá qui'ni iyate ca cosa nna eyacca cą cubi, làniana Nubeyu' de Ỹiabara' nna thí'e adí la' huacca glorioso de ỹiabara' nna cué'níe lo xila' tsè'ni quì'e para cú'ubi'e. Làniana lebi'i canu denó le inte' nna xúa huani le lo adí tsì'nu ca xila' tsè'ni para cú'ubia' huáni le iyaba ca descendiente qui' tsì'nu ỹi'ni Israel. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nuỹa tediba guthà'ną ca yú'u quì'į l·le ca bettsi'į l·le ca danį l·le tàta nàna quì'į l·le niula quì'į l·le ca ỹi'nį l·le ca loyu quì'į l·le por inte' nna, pues lą nna thí'ą ágayua' tántula, ą'hua gunią recibir la'labàni nu labí ttíą quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero nuỹetse' canu neru annana ccá lá cą nu bitote. Ą'hua nuỹetse' canu bitote annana, pues lacą nna ccá lá cą nu primeru. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Reino qui' Tata Dios nna ccą comparar tì'a ttu nubeyu' ná bi patrón, huàni' ba nna biria bi huìla mozo para tsía cą tsina qui' bi. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","De chi beyà'na lani bi ca mozo qui' bía qui'ni quiỹa bi cą ttu denario ttu tsá nna, guthel·la' tè bi cą làti runi bi tsina betsulí'. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tsunna hora tì'ga bitola nna biria bi làti cca i'yya nna bilá'ni bi attu te canu cuenta tsè'e bá cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ra tè bi cą: Ą'hua lebi'i nna, lítsía huá tsina quia', inte' nna hua yiỹa ba' le tì'a nu ná bá. Lacą nna huía tè cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Biria tè bi attu ttu tsì'nu hora nna, ą'hua attu vuelta ritìį tsunna nna, anía huá beni bi arreglar lani attu te cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ttu ritìį gayu' diál·lalá nna bilá' huáni bi adí canu cuenta tsè'e bá cą, acca ra bi cą: Biecca betuỹia tsá bá tsè'e le nì bihua biỹa runi le ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Becàbi cą nna ra cą bi: Porqui'ni lanú nuỹa runna tsina qui' tu'. Làniana ra tè bi cą: Ą'hua lebi'i nna lítsía huá tsina quia' nna, huaỹa bá le tì'a nu ná bá. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","De gùl·la tsá lània nna, xana' tsìnàa nna ra bi nu ná jefe qui' ca mozo qui' bía: Beyàỹi iyaba ca mozuą' nna gutìỹa cą qui' natsá, pero thulo lu' quiỹa lu' yà'la canu gutà'a bitótią' làniana canu gutà'a primérua. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Gubiga' tè canu gutà'a ritìį gáyu'a, ttu ttu tsa cą nna guỹi' laỹa quį qui' ttu tsá entero taá. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Làniana gubiga' tehuá canu gutà'a primérua belaba latsi' quį qui'ni thi' cą adí iỹeni, pero lacą nna ttu denario huá guỹa cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","De guỹi' cą bél·liua nna gudulo cą rinàba ỹiya' cą lani patrón qui' caniá nna ");
INSERT INTO zaaNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ra cą: Canu bitotį nna ttu hora rúbá gùtse'e cą tsina, atsi'íni tulappa ná bá laỹa tu' nna, yala guỹàcca' tu' betùỹia tsá lo tsiną' nna uccuani tu' ubá nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Becàbi xana' tsìnàa nna ra bi ttuą: Amigo, bihua biỹa riguánia' lu'. Tsí álahua beya'na ri'u qui'ni quiỹa' lu' ttu denario cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Acca guỹi' bá nu ná laỹa lu' nna beyya tè; inte' nna calátsa'a' gutià' qui' nu bitotį tulappa bá lani lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tsí bihua derecho té quia' gunia' ti'iỹa bá calátsa'a' lani nu té quia' cá. Tsí rappa lu' la'yélatsi' porqui'ni ná' enne' tsè' áccá. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Anía modo nna canu último nna ccá lá cą nu primero, ą'hua canu neru nna ccá cą nu bitote; porqui'ni nuỹetse' cą chi nàỹinie, pero tuchùppa rúbá cą chi rée'. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","De yù'u Jesús néda para Jerusalén nna guleqquie tsì'nu ca discípulo qui'áa yà'latsi' nna rèe cabi: ");
INSERT INTO zaaNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Annana dia ri'u Jerusalén. Nía nna gute cą Nubeyu' de Ỹiabara' cuenta làtsi' ná' ca sacerdote principal nna ca maestro de la ley nna; lacą nna cueqquia cą sentencia quì'e para gattie. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ą'hua gute cą ne cuenta làtsi' ná' canu dittu' rigú'ubia' le' ciudáad para qui'ni guni cą ne burla nna hué' cą ne lani cuarta nna, làniana gutá' cą ne lo curutsi para gattie; pero bitsa tsunna nna eyathèe de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Làniana gubiga' tè nàna qui' ca ỹi'ni Zebedéua nna beduỹíbį ru'a lo Jesús gunàbanią ne favor. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Lèe nna rèe na: Biani calatsi' lu'. Becàbią nna rą ne: Bèni cuią'lu' mandado qui'ni xuàni chuppa ca ỹi'ni yì'į cuitta' cuią'lu' le' reino qui' cuíą'lu'a, ttuą lado ná' bàni nna áttuą lado ná' yatti nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Làniana becàbi Jesús nna rèe na; Labí ritelíni le biỹa nuą' rinàba le. Tsí ína ri'u qui'ni guchia bá le tté le iyaba ca sufrimiento nu ná qui'ni ccá' padecer cá. Làcabi nna ra cabi e. Guchia bá tu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Lèe nna rèe cabi: Hualigani qui'ni cca hua le padecer tì'a inte' ccá' padecer, pero de xuàni le lado ná' bània' nna lado ná' yattia' nna, álahua quia' ną́ para gunna ya' ą, sino Tata quia' chi benie na preparar para gutie na lani canu càba latsi'e. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","De biyénini á tsìi ca discípulua ania nna, yala bitsa'áni cabi canu chuppa bèttsi'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Làniana gutaỹi tè Jesús cabi ru'a lúe nna rèe cabi: Hua yù ba le qui'ni canu rigú'ubia' le' ca nación nna runi taáni qui' quį itúbani; ą'hua adí canu re' cuenta nna yala ruthítsini cą ca enne' qui'ni guni cą tsina lo quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero entre lebi'į nna labí ccá ą́'. Sino qui'ni canchu nuỹa calatsi'į ccą́ enne' ỹeni entre lebi'į nna, pues ná qui'ni ccą́ ttu nu gunią iyaba le servir. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ą'hua canchu nuỹa ttu le calatsi'į ccą́ nu neru nna, pues caduel·la' qui'ni ccą́ ttu nu gunią le servir tulidàba. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tì'a Nubeyu' de Ỹiabara' nna labí bitée para qui'ni guni ca enne' tsina lúe, sino para guni lée iyaba ca enne' servir, ą'hua para íria latsi'e la'labàni quì'e para qui'ni l·lá nuỹetse' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Làniana de beria cabi yetsi nu lá Jericó nna, enne' ỹétse'ní denó cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Chuppa ca ciego ỹuàni cą cuitta' nédaá nna, de biyénini cą qui'ni dia Jesús néda nía nna, acca gunne cą iditsa nna ra cą: Cuią'lu' Ỹi'ni David, guppa cuią'lu' la' retúalatsi' qui' tu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Gutil·la tè ca enne' cą qui'ni guthaya rú'a quį. Pero lacą nna adila iditsa gunne cą nna ra cą: Cuią'lu' Ỹi'ni David, betúa latsi' cuią'lu' intu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Gulèda tè Jesús nna gutàỹie cą nna rèe cą: Biani calatsi' le gunia' por lebi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Lacą nna ra cą ne: Señor, calatsi' tu' iyàlia ca íyyalo tu'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús nna betúa taá latsi'e cą nna beláppe'e iyyalo quį, luegu taá bilá' chìnì cą nna dia tè cą lani e. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Exa tegáabá Jerusalén chi deyya cabi nna betsina' cabi ttu lettia láą Betfagé liuítta' i'ya láą Monte de los Olivos. Guthel·la' tè Jesús chuppa ca discípulo qui'áa, ");
INSERT INTO zaaNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","rèe cabi: Lítsía le' yetsi to' nu re' frente taá tétea nna, hua taxácca' diga le làti ta' ttu burra to' tsa' ỹi'nį ethàtsi li ą nna eche' tètsate' le cą nì. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Canchu nuỹa biỹa gą́ le nna, lebi'į nna gá tè li ą qui'ni: Señor qui' tù'a nna riquína'nie cą. Làniana hue'él·la' tabą́ le eche' le cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iyaba nui nna uccuą para qui'ni ccá cumplir nu ra ttu enne' uccua profeta: ");
INSERT INTO zaaNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Lígatsi ciudad qui' monte Sión: Nì chi da' Rey qui' lù'a, née enne' ỹénlatsi'. Lèe nna tsìe ttu burro to' ỹi'ni ttu burra nu rua' yùà'. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Huía tè ca discípulua nna beni cabi tì'a nu ra Jesús cabía. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Betsina' tè cabi deche' cabi búrraá lani ỹi'ni to' qui' niá nna, guxua tè cabi ca lari' qui' cabi cuè'e quį. Jesús nna gutsia tìe ttuą. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Iỹé mili' tsè'ni ca enne' día tè cą lani e nna gutsìla tè cą ca lari' qui' quį lo néda, adí cą nna gutìttsa cą ca l·la' qui' ca yà nna benìta' tè cą cą lo neda para ttíe. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ca enne' denérua ą'hua canu denál·la'láa nna iditsa tsè' bedàliani cą ne nna ra cą: La'dàliani para enni'į porqui'ni née Ỹi'ni David para ccá huée Rey qui' ri'u. Bendito enne' da' por mandado qui' Señor Dios. La'dàliani para Tata Dios enne' dua ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","De gutà'a Jesús le' ciudad Jerusalén nna, iyáỹiani ca enne' le' ciudáad nna bitùppa cą para inna' cą nna ra cą: Nú gani nui da' nì. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Adí ca enne' nna ra cą: Là enni'į enni'ą' Jesús enne' rinne parte Tata Dios, née enne' Nazaret qui' Galilea. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Laniana gutà'a Jesús le' lí'a qui' templua nna bedal·lèe fuera iyaba canu tsè'e nía huetti' nna hui'i nna, berixie ca meỹa qui' canu ritsìla bél·liua nna ą'hua ca xila' qui' canu rutti' cą becha nna runi cą negocio ru'a templua, ");
INSERT INTO zaaNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ra tìe cą: Tata Dios nna rèe lo titsa' quì'e: Yú'u quíyi'į gata' líį yú'u para oración; atsi'íni lebi'i nna bèlia qui' ubàna la chì nani li ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Le' templua bá rì'e nna, bitsina' tè ca ciego nna ca cojo nna ru'a lúe. Lèe nna beyunie cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero tsè'e huá ca sacerdote principal ą'hua ca maestro de la ley nna bilá'ni cą ca milagro nu runiáa, ą'hua biyénini cą qui'ni ca huatsa cuìti' rudàliani cą ne iditsa tsè' le' templua de ra cą: La'dàliani para enni'į porqui'ni née Ỹi'ni David para ccá huée Rey qui' ri'u. Acca yala bitsa'áni ca sacerdótea nna ą'hua ca maestro nu rulue' nu ra lo ley religiosa qui' caniá nna, ");
INSERT INTO zaaNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ra cą ne: Tsí bihua riyénini lu' nu rinne ca nui. Jesús nna rèe cą: Hua riyeni te', pero tsí bihua nì' gul·la le làti ra: Chi nani cuią'lu' Señor Dios qui'ni ca huatsa to' ą'hua canu atsàba rátsi' nna gudàliani cą cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Làniana Jesús nna bethà'na tìe cą nna berie le' ciudáad nna betsine'e le' yetsi Betania; níaba beya'née yèlàa. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Attu yu'udílaá nna deyya Jesús para ciudad Jerusalén attu. Néda bá yu'ée nna gutùnie. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bilá' tènie ttu yà exxuhuí du exa tegáabá lo néda nna. Huía tìe làti du naá pero labí té exxuhuí lúį sino puro l·la' bá tsìa, acca rèe na: Dèsdeba annana jamás làa cuía teérulá fruta lo lu' cá. Làniana gubitsi chì yà exxuhuía. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","De bilá'ni ca discípulo qui'áa nui nna yala uccuaỹí latsi' cabi nna ra cabi: Ti'ani modo acca gubitsi taá yà exxuhuíą' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Becàbi Jesús nna rèe cabi: Hualigani te' nia' le qui'ni cáalá té tí' fe qui' le nna ą'hua bittu gudu chùppanią le nna, entonces alàarula luetsi nu uccua lani yà exxuhuíą' guni le, sino hàstaá i'ya duį canchu guni li ą mandar gá li ą: Becuìtta nna guttè lo indatò' la nna, pues huattią. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Iyaba nu inàba le lani oración nna, huadi' li ą canchu ríalatsi' le qui'ni ą́' ccá según ba nu rinàba le. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Betsina' bée le' templua nna, bitsina' tè ca sacerdote principal lani canu rigú'ubia' le' ciudáad ru'a lúe miéntraste riquixa'ánie ca enne' nna ra cą ne: Nuni por mandado quí'ní acca runi lu' ca cosį. Nuni benna derecho qui' lu' para quixá'a lu' ca enseñanzį cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Becàbi Jesús nna rèe cą: Ą'hua inte' nna inàba titsa' huá' le, canchu ecàbini le inte' nna làniala nna equixa'á huánia' le nuỹa benna la'huacca quia' acca runia' ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Gala da' derecho qui' Juan el Bautístaá para guni bi bautizar cá, tsí de ỹiabara' la o tsí ca enne' bá bete derecho qui' bi áccá. Làniana gudulo cą be' cą titsa' ti'iỹala ecàbini cą ne nna ra luetsi quį: Canchu ina ri'u qui'ni autoridad qui' Juáan para guni bi bautizar nna dá'ą de ỹiabara', entonces gá taą́ ri'u: Bialacca làa huíalatsi' le qui' bi cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ą'hua canchu ina ri'u qui'ni por mandado qui' ca enne' bá acca beni bi bautizar nna, nìca'chu biỹa guthácca' yetsi ri'u; porqui'ni iyaba cą nna ra cą qui'ni Juáan uccua bi ttu profeta qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Acca mejor la becàbini cą Jesús nna ra cą ne: Labí yù tu'. Làniana becàbi tè Jesús nna rèe cą: Nihua inte' nna labí quixa'ánia' le nuỹa benna la'huacca quia' acca runia' ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Raáruhuá Jesús: Biani rulaba latsi' le acerca de nu iníyi'į. Ttu nubeyu' nna gutsé'e chuppa ỹi'nį. Huía tìą ru'a lo ỹi'ni nu guláa nna rą na: Ỹì'nia', huía tsina qui' ri'u le' loyu làti runi ri'u tsina betsulí'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Lą nna becàbią nna rą tàta qui' niá: Labí calátsa'a'. Pero bitola nna beyaccą arrepentir nna huía báą. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Huía tè nubeyu'a ru'a lo attu ỹi'ni niá nna, aníahua rą na: Becàbią nna rą tàta qui' niá: Ooba Señor, hua ya'aba'. Pero labí huíą. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nula canu chuppáa beni nu rú'ulatsi' tàta qui' caniá cá. Lacą nna ra cą: Nu nerua. Làniana ra Jesús cą: Hualigani te' riquixa'ánia' le qui'ni canu rutebìà' telá cą ruquiỹa cą qui' impuesto, ą'hua ca niula pública nna, pues lacą nna deneru la cą lo le para le' reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Porqui'ni loti' bìta Juáan nna gutixa'áni bi le lo néda nu ná lí, pero labí huíalatsi' le qui' bi. Pero canu ridi' qui' impuesto nna ą'hua ca niula pública nna huía taá latsi' quį qui' bi. Lebi'i nna nìhuani de bilá'ni le loti' huíalatsi' quį, pero bihua beyacca le arrepentir para tsía hua latsi' le ca titsa' qui' bi. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Liudà naga' le attu comparación. Gùdua ttu enne'yu' nna guda bi planta qui' betsulí' le' loyu qui' bi. Bedeqquia tè bi ą li'ya, ą'hua guleqquia bi ttu pozo làti guxàtta cą iqquia betsulí'a para cueqquia cą inda quì'į. Ą'hua bedu tè bi ttu torre. Làniana betèsa tè bi lóyúa lani canu guni cą na tsina. Pero làbi nna guda' tè bi dia bi idittu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","De chi debiga' tiempo edi' cą fruto qui' betsulí'a nna, guthel·la' bi ca mozo qui' bía làti tsè'e canu runi tsina le' lóyúa para qui'ni edi' cą fruto nu ná qui'ni thi' bi qui' loyu qui' bía. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero canu runi tsina le' lóyúa nna bedaxu' la cą ca enne' guthel·la' bía, yala idí' bè' cą ttuą, áttuą nna bè' cą na íyya nna bètti telá cą áttuą nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Xana' lóyúa nna bedethèl·la' gáabá bi adírula iỹé ca enne' runi tsina qui' bi, pero anía hua bedethácca' cą cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Por último nna guthel·la' bi propio gani ỹi'ni bía nna ra bi: Huappa cà'ba cą respeto ỹì'ni yì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero canu runi tsina lóyúa nna de bilá'ni cą ỹi'ni bía nna, gulù'u titsa' luetsi quį nna ra cą: Lànui nuą' eyà'ną ituba loyuį. Litsa' gútti ri'u ą para qui'ni ccá qui' ri'u itute herencia qui' nią'. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Acca bedaxu' chì cą ỹi'ni bía nna bedal·la cą bi fuera lóyúa nna bètti tè cą na. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Acca lebi'i nna, canchu chi el·lani propio gani xana' lóyúa nna, biani guni bi lani canu betèsa bi lóyúa para guni cą na tsìnàa cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Becàbi cą nna ra cą ne: Seguro nna nì tito' làa etúa latsi' bi cą sino gul·luỹa bi latsi' ca enne' malua, làniana gutèsa tè bi loyu qui' bía lani canu huaya' la canu ná cą enne' cumplido nna gute cą fruto qui' bi tiempo de lènà'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Beni ba Jesús seguir nna rèe cą: Tsí nunca huá nì' gul·la le lo Escritura làti ra: Iyya nu labí guyú'u latsi' canu rucùàa' yú'a nna, chi ną́ íyya principal nu adila tsìttsì naxu'ą yú'a. La'a mismu gani Señor Dios chi benie nui, ną́ ttu cosa nu dacca' iquila' báni latsi' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Acca nia' le qui'ni reino qui' Tata Dios nna ituą lani le nna ccą́ para ca enne' huaya' la canu guni cą na tsina para ttu lènà' tsè' quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nuỹa tediba ibixi lo íyya principal ni nna l·luỹa latsi'į completamente taá; ą'hua nuỹa íqquianí ìnnia íyyį nna gútsi'ití'níą na. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","De biyénini ca sacerdotea ą'hua ca fariséua ca comparación por enseñanza nu gutixè'e, entonces gutelíni cą qui'ni quì'ba quį nua rinnie. ");
INSERT INTO zaaNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Acca uccua latsi' quį cu'ú ná' quį Jesús, pero gutsibáni cą biỹa guthácca' ca enne' yétsiá cą, porqui'ni para ca enne' yétsía nna uccuee ttu profeta qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús nna gutixa'ánie cą attu enseñanza por medio de ttu comparación nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Reino qui' Tata Dios nna cca huą́ comparar ti'a ttu enne' uccua rey beni bi thá'a qui' ỹi'ni bía. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Guthel·la' tè bi canu runi tsina qui' bía tanne cą canu chi naỹini bi thá'a. Pero canu nàỹìa nna labí uccua latsi' quį tsía cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Bedethèl·la gáabá bi attu te canu runi tsina qui' bía nna ra bi cą: Lígatsi canu chi naỹi ti'ą' qui'ni chi béttíá' ca gù'na quia' nu adiru riỹeni nna ą'hua adí ca animal quia', chi benia' preparar la'go, iyátení chi ná prevenido, líta taá fiéstį. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero canu nàỹìa nna labí caso beni cą. Ttuą nna huíą lo tsina qui' bíį, attuą nna huía lą́ bíỹaáru negocio quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Adí cą nna bedaxu' la cą ca enne' dia mandádua nna beni la cą cabi maltratar nna betti cą cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Biyeni báni rey noticį nna yala bitsa'áni bi nna guthel·la' chì bi ca soldado qui' bía nna bel·luỹa cą latsi' ca huetti enni'a nna bedayi cą yetsi qui' caniá. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Làniana ra bi canu runi tsina qui' bía: Hualigani chì ná preparado thá'a pero canu naỹi tè'a nna labí ná nu dacca' cue'ni lo meỹa lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Acca lítsía làti retsa' ca neda. Iyabani ca enne' etsà' le nna ligàỹi cą ìta cą fiéstį. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Biria chì canu runi tsina qui' bía lo ca néda nna gutàỹi cą iyábani ca enne' betsàa' cą, tàntua canu runi mal nna ą'hua canu runi nu ná tsè' nna, hàstaá qui'ni bitsà'ti'ni le' yú'u thá'a ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Gutà'a tè rey le' yú'a para inna' bi iyaba ca enne' chi bitùppa, bilá' tèni bi ttu nubeyu' ri'ą nía labí naccu'ą lári' nu bete bi para thá'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Làniana ra bi ą: Amigo, ti'ani modo acca re' lu' nì nna làa naccu' lu' nu benna' para fiéstį. Lą nna tsidi rúbá ri'ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Làniana ra rey canu runi tsina lo meỹa: Líthi' ą nna, liuỹìqquia ca nì'a ní'į nna, líchú'na ą fuera la; nía nna ccą́ sufrir nna cuetsią nna góya'atsùni layi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Porqui'ni nuỹetse' cą chi nàỹinie, pero tuchùppa rúbá cą rée'. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Bedà' tè ca fariséua nna gunne lettia cą ti'iỹala modo guquìnnia cą Jesús lani ttu titsa'. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Guthel·la' tè cą ru'a lúe ca discípulo qui' caniá lani canu gulaní partido qui' Herodes nna ra cą ne: Maestro, hua yù ba tu' qui'ni labí runi latsi' cuią'lu', sino riquixá'a cuią'lu' lo néda lígani qui' Tata Dios, labí rátsini cuią'lu' nu rena ca enne', nihua labí rucué'ní cuią'lu' ca enne' según la' rinna' qui' quį, sino ttu rú'ataá cani cuią'lu' cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Acca calatsi' tu' qui'ni quixá'ani cuią'lu' intu' biỹa opinion ni té qui' cuią'lu'. Tsí hua ná tsè' quiỹa ri'u nu ruthítsini gobierno qui' Cesar ri'u, o tsí bihua áccá. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero Jesús nna gutelí taánie la' rulábalatsi' mal qui' quį contra lèe, acca rèe cą: Biecca calatsi' le guni le inte' prueba ti'iỹala modo uquìnnia le inte' lani ttu titsa' ni'i, atsi'íni ya'lo ba yala enne' tsè' rulue' le nna, ");
INSERT INTO zaaNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","líúlue' tsannanì inte' bel·liu nu ridi' gobierno nna. Làcą nna betsia tè cą ttu denario ru'a lúe. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Làniana gunàba titsa' tìe cą nna rèe: Nuni retrato quí'ní nui dua lo monedį, ą'hua nuni láaní nui dua nì. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Becàbi cą nna ra cą ne: Qui' Cesar enne' rigú'ubia'. Làniana ra tìe cą: Entonces líúte ba qui' Cesar nu ná qui' Cesar, ą'hua líúte ba qui' Tata Dios nu ná para lèe nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Biyeni díbáni cą ti'iỹa becàbinie cą nna yala biquila' ba latsi' quį. Làniana betsè'e latsi' quį ne nna bedà' cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","La'a tsá làniataá nna bitsina' huá ca enne' judio canu gulátsi' religión láą saduceo ru'a lo Jesús. Làcą nna rena cą qui'ni labí posible té eyatha canu yatti nna eyacca bàni cą attu. Gunàba titsa' tè cą ne nna ");
INSERT INTO zaaNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ra cą: Maestro, chi bìl·la tu' qui'ni Moisés nna ra bi lo Escritura qui'ni canchu nuỹa ttu enne' ni gattią pero lanu ỹi'nį uccua nna, entonces bettsi' niá nna ná qui'ni guttsa taá ní'į lani niula qui' niá para qui'ni elìthą descendencia qui' bettsi'į nu gúttía. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pues intu' nna benibia' tu' gàtsi bettsi' ca enne'. Bettsa tè ná' nu nerua nna, pero gùtti bą́ nna lanu ỹi'nį uccua, acca beyà'na ba niula qui' niá lani bettsi' niá. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Anía tehuá uccua lani nu cca chùppáa nna nu cca tsùnnáa nna hàstaá nu cca gàtsía. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bitote nna gùtti huá niùláa. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Canchu chi gal·la' tsá eyatha canu yatti nna, nula canu gàtsi bettsi'a ccá quì'į niùláa ca, yàqui'ni iyaba gàtsi cą nna bettsaná' quį lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Becàbi Jesús nna rèe cą: Ridacca'ỹí ba le porqui'ni labí ritelíni le nu ra lo Escritura, nihua la'huacca qui' Tata Dios labí nabia'ni li ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Porqui'ni canchu chi gal·la' tsá eyatha ca enne' yatti nna, lanuru nuỹa guttsaná' porqui'ni iyaba cą nna ccá cą tì'a ná ca ángel qui' Tata Dios le' ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pero acerca de canu yatti qui'ni ná qui'ni eyatha cą de lo lù'uti nna, tsí bihua nì' gul·la le nu gunne Tata Dios para lebi'į loti' rèe Moisés enne' gùdua tiempo antigua: ");
INSERT INTO zaaNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Inte' ná' Dios qui' lu' ą'hua qui' ca ta' enne' gùla qui' lu' Abraham nna Isaac nna Jacob nna. Nì nna ritelíní qui'ni ą'hua ca enne' chi gùtti nna pues bàni bá cą nna runi bá cą Tata Dios adorar. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","De biyénini cą enseñanza qui'áa nna biquila' yà'aba latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Biyeni báni ca fariséua qui'ni bethia bée rú'a ca saducéua, acca betuppa iyaba cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Làniana ttu maestro qui' quį nu yala tsè' rethàtsilà'ną nu ra lo ley qui' ca judíua nna gunàba titsa'ą Jesús para eyìlą néda ti'iỹa la modo cu'ée ttu falta, acca rą ne: ");
INSERT INTO zaaNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Maestro, biani mandamiento ní nu ra lo ley dàcca'ą adiru cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Becàbi tè Jesús nna rèe na: Catsi'íni lu' Señor Dios qui' lu' lani itute losto' lu', lani itute latsi' lu', ą'hua lani la' rulábalatsi' qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nui nna ną́ primero mandamiento ą'hua nu adiru dacca'. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ą' tegáahuá ná mandamiento nu cca chùppáa: Catsi'í huáni lu' iyaba ca luetsi enne' lu' ti'atsi la'a lu' ba. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Lo chuppa ca mandamiéntuį nna naxu' ituba nu ra lo ley nu bethà'na Moisés lani ri'u ą'hua nu bedia ca enne' uccua profeta nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","De tsè'e iyaba ca fariséua nna gunàba titsa' tè Jesús cą, ");
INSERT INTO zaaNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","rèe: Biani rulaba latsi' le nu cca qui' Cristua. Nuni ỹi'ni ní née. Becàbi cą nna ra cą ne: Née ỹi'ni David. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesús nna ra tìe cą: Entonces ti'ala modo acca por la'huacca qui' Espíritu Santo nna ra David qui'ni Cristua nna née SEÑOR, loti' ra bi íį: ");
INSERT INTO zaaNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Señor Dios nna gunènie Señor quíya'a nna rèe: Gùduani cuittá'a' lado bàni, Hasta qui'ni gúnna' làtsi' ná' lu' iyaba canu làa cca guyu cą lu', Para qui'ni gúl·liani lu' iqquia quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Acca por ca tìtsa'a nna yù ri'u qui'ni la'a mísmuba David nna reya bi Cristua SEÑOR. Entonces ti'ala modo acca née descendiente qui' David cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","De gutixà'a Jesús nuą' nna, ni ttu cą nna labiru betseláni cą biỹa titsa' ni ecàbini cą ne. Acca dèsdeba tsá lània nna lanuru beyáỹani inàba titsa'ą ne adí. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Làniana gunèni Jesús ca enni'a ą'hua ca discípulo qui'áa nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ca judíua nna chi bete cą poder qui' ca fariséuą' nna ca maestro qui' quį nna para ethàtsilà'na cą nu ra lo ley nu bethà'na Moisés lani ca ta' tàta qui' rí'ua. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Acca iyaba nu ina cą acerca de nu ra lo ley nna liudà ba naga' le nna lígúni ą nna. Pero bittu guni le ti'ba runi cą, porqui'ni puro huenne ba runi cą, pero hecho qui' quį nna labí rului'ą na. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ruỹìqquia cą yùà' ìdi'i nna tàbi nna rutsia tè cą na iqquia ca enne' para guni cą na, pero làcą nna nidi ti'to' làa runi cą nu rena cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Antesla runi cą iyábani para ilá'ni ca enne' cą. Rudilàga'áru cą ca listón làti rudia cą ca titsa' nu ra lo Escritura nna rugàl·la' ná' quį cą ą'hua lo ỹigá quį. Ą'hua ruditùniíru cą ca lári' nu raccu' cą adiru ti'chu adí ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ral·la' cą asiento íqquiará' tè canchu chi ral·la' fiesta qui' quį, ą'hua ral·la' cą ca primero asiento le' ca sinagoga làti retùppa cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yala rú'ulatsi' quį gappa ca enne' ỹetse' cą titsa' làti cca i'yya, ą'hua qui'ni gá tè ca enne' cą nombre nu dacca' tì'a maestro. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pero lebi'į nna hué' le cuidado qui'ni làa gudàliani ca enne' le ti'atsi ná le enne' re' cuenta, porqui'ni ttu teruba enne' dua ná Maestro qui' le, es decir Cristua; pero iyaba le nna hermano ba gá luetsi le. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nu ttu nuỹa gá le tàta le' yétsiloyuį ti'atsi runi li ą adorar, porqui'ni ttu teruba Dios Padre enne' dua ỹiabara' née Tata qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nihua bittu gulaba latsi' le qui'ni gá ca enne' le qui'ni ná le nu neru qui' quį, porqui'ni làteruba Cristua nna née Xana' iyate le. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Acca nuỹa enne' nu runią iyaba le servir, là enni'a nua' adiru enne' ỹeni entre lebi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nu cani qui'ni yala dàlianią nna, pues i'yu tsá qui'ni egà'na menos lą́; pero nu rulaba latsi'į qui'ni lanu nuỹa ná rùą nna, pues i'yu tsá qui'ni cca lą́ enne' ỹeni. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Pero lebi'į ca maestro de la ley nna ca fariseo nna, ica'rútsi'íru le porqui'ni yala enne' tsè' rulue' le, pero álahua hualini le. Ruthàya le reino qui' Tata Dios para ca enne', nihua lebi'i làa rà'a le, ą'hua nihua làa rue'él·la' huá le canu calatsi' gá'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ica'rútsi'íru lebi'į ca fariseo nna ca maestro de la ley nna porqui'ni yala enne' tsè' rulue' le, pero álahua hualini le. Rigua le biỹa té qui' ca niula viuda nna, runi tè le oración tùni tse' para gulue' le ti'atsi yala enne' lí ná le. Acca adila fuerte ná castigo thí' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ica'rútsi'íru lebi'į ca maestro de la ley nna ca fariseo nna porqui'ni yala enne' tsè rulue' le, pero álahua hualini le. Ribèni le hàstaá lo indatò' nna yúbitsi nna hueyìla ttu enne' para tanuą ca cosa nu runi le. De chi ną́ enne' qui' le nna, runi le qui'ni ccą́ merecer achùppa tántola tsíą lo yi'bél·laá ti'chula lebi'i por mal nu rulue'ni li ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ica'rútsi'íru lebi'į porqui'ni labí la'yani' qui' Tata Dios té lo losto' le, pero catè latsi' le iche' le ca enne' nna rena le: Nuỹa diba gunią jurar nna gúduą templo qui' Jerusalén por testigo nna, bihua biỹa ccani. Pero rena huá le qui'ni nuỹa diba gúduą oro qui' templua por testigo nna pues chi ną́ obligado para gunią nu chi benią ofrecer. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Lebi'į canu làa rulaba tsè' latsi', yala chul·la re' la' riyeni qui' le. Rena huá le qui'ni canchu bel·liu qui' le nna làa yù'ą le templuą' nna entonces labí ná le'yą para Tata Dios. Biala dacca' adiru para gúdu le por testigo, tsí oruą' o tsí templo nu runi qui'ni cca oruą' le'ya áccá. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ą'hua rena le: Nuỹa diba gúduą altar por testigo nna, bihua biỹa ccani, ą'hua nuỹa diba gúduą por testigo ofrenda nu tsìa lo altar nna pues chi ną́ obligado para gunią nu chi benią ofrecer. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Necio ba ná le ą'hua yala chul·la re' la' ritelíni qui' le. Biala dacca' adiru para gúdu li ą por testigo, tsí ofrendą' o tsí altar nu runi qui'ni cca le'ya ofrendą' áccá. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Inte' nna nia' le qui'ni nuỹa diba runi jurar nna ruduą altar por testigo, pues rudu huą́ por testigo itute ofrenda nu tsìa lúį. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ą'hua nuỹa diba runi jurar nna ruduą templuą' por testigo, pues rudu huą́ Tata Dios por testigo porqui'ni templuą' nna ną́ para lèe. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ą'hua nuỹa diba runi jurar nna ruduą ỹiabara' por testigo, pues rudu huą́ por testigo trono qui' ỹiabara' tsa'tsela tehuá Tata Dios enne' duani lo trono qui'áa. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ica'rútsi'íru lebi'į ca fariseo nna ca maestro de la ley nna porqui'ni yala enne' tsè' rulue' le, pero álahua hualini le. Ribeqquia le para diezmo hàstaá ca semilla lathi to' ti'na menta nna anís nna comino nna, pero labila runi le ca cosa nu adiru dacca' nu da' lo ley qui' Tata Dios ti'na lu'uxtícia tsè' nna la' retúalatsi' nna fe nna. Ca nua' la náduel·la' guni le, pero nihua làa guxùl·la latsi' le gute le qui' diezmo. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nìdiruani titó' labí ritelíni le, pero càte latsi' le iche' le ca enne'. Ca mandamiento xcuìchuto' nna yala ribeqquia latsi' le guni le cą cumplir, pero ca mandamiento nu dacca' adiru nna nìdiruba làa rulaba latsi' le guni le cą. Te ttu dicho nu rena le: Lani cuidado ba ruttèni le vino nu ri'ya le para qui'ni làa gabi le ttu bé'ya to', atsi'íni ràbi la le ttu camello xeni tsè'. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Airu lebi'į ca maestro de la ley nna ca fariseo nna porqui'ni yala enne' tsè' rulue' le, pero álahua hualini le. Reyìi le tsuą' teruba fuera qui' ttu taza nna plato nna, pero liú'u la nna tsa'ti'ni le la'ubàna nna la'hueni lu'uxtícia mal nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Lu' fariseo, labí la'yani' té qui' le, porqui'ni priméruỹa ná qui'ni quíi le le' tazą' nna platuą' nna, làniana ccá huá nàrì lado fuérala. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Airu lebi'i ca maestro de la ley nna ca fariseo nna porqui'ni yala enne' tsè' rulue' le, pero álahua hualini le. Yala latsitte rilá'ló ca bà tsíttsi canu beyú'u ì'yu, pero liú'u lá nna yala cuttsi ril·là' cą porqui'ni tsa'ti'ni cą tsítta yatti. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ą'hua lebi'i nna lo ra' teruba yala enne' lí rulue' le lani ca enne', pero liú'u lá losto' le nna tsa'ti'ni le la' huethacca'ỹí ą'hua adí ca tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ica'rútsi'íru lebi'į ca maestro de la ley nna ca fariseo nna porqui'ni yala enne' tsè' rulue' le, pero álahua hualini le. Rilìtha le monumento lo bà qui' ca profeta nna, ą'hua yala ìyyà latsitte rutsia le lo bà qui' adí ca enne' beni tsè' ru'a lo Tata Dios, ");
INSERT INTO zaaNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","rena tè le: Cáalá chi tsè'e ri'u loti' gutsé'e ca ta' tàta qui' rí'ua nna labí uccua ri'u cabi tulappa enne' mal para gutti ri'u ca enne' uccua profeta. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Inte' nna nia' le qui'ni por ca tìtsa'a nna ribèqquia le sentencia contra la'a lebi'i ba de qui'ni runi le sostener qui'ni ná le descendiente qui' canu betti cą ca profétaá. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Acca lígúni telá cumplir maldad nu beyàtsani ca ta' tàta qui' lía guni cą, porqui'ni chi rulaba latsi' le guni li ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yala mañoso ná le tì'a ca bèl·là. Ti'áruálá modo guni le para làa cca le condenar tsía le lo yi'bél·laá cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Acca rithél·la'a' lani le ca profeta nna ą'hua canu ritelí tsè'nì nna ca maestro tsè' nna, pero lebi'i nna gútti la le cabi nna gutá' le cabi lo yà curutsi nna, attu te cabi nna hué' le cabi le' ca sinagoga làti retuppa le, ą'hua gutsia latsi' le cabi le' ttu ttu ca yetsi nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Anía modo ccá huá le responsable por lù'uti qui' ca enne' labí falta té qui' cabi, dèsdeba lù'uti qui' Abel enne' beni nu rú'ulatsi' Tata Dios, hàstaá lù'uti qui' Zacarías ỹi'ni Berequías enne' bètti le loti' dùą le' lí'a qui' templua èxaba làti du altar fuera. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Hualigani te' riquixa'ánia' le qui'ni iyate nuą' nna tátsią iqquia iyaba lebi'į canu tsè'e anna. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Lebi'i canu tsè'e le' ciudad Jerusalén rútti le ca profeta nna rudua huá le íyya iqquia ca mensajero rithel·la' Tata Dios lani le. Iỹé vuelta tsè' uccua látsa'a' gutùppa' le tì'a ttu yìti rutùppą ca ỹi'ni to' quì'į liú'u xìlį, pero labí uccua latsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Acca nia'le qui'ni templo qui' líą' nna chi dua tàttsi bą́, ");
INSERT INTO zaaNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","porqui'ni dèsdeba annana labiru ilá'ni le inte' hàstaá qui'ni i'yu tsá inne le tsè' nu cca quia' nna ina le: La' dàliani para cuią'lu' porqui'ni da' cuią'lu' por nombre qui' Señor dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","De beria Jesús le' templua chìa déyeé nna, gubiga' tè ca discípulo qui'áa para gulue'ni cabi e adí ca edificio qui' templua. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús nna rèe cabi: Anna teruba rila'ni le iyaba ca nui. Pero hualigani te' riquixa'ánia' le qui'ni i'yu tsá qui'ni labiru eyà'na iqquia luetsi ca íyya xeni nu cua'ni templuį, porqui'ni hual·lani canu da' idittu' nna guthìnnia gutàppa'ní cą iyáỹiate cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Huappi tìe guri'e lo i'ya láą Monte de los Olivos, bitsina' tè ca discípulo qui'áa ru'a lúe nna gunàba titsa' cabi e yà'ba latsi' nna ra cabi e: Calatsi' tu quixá'ani cuią'lu' intu' cuaỹa ccá ca cosį. Biani señal ní ccá canchu chi íl·lani cuią'lu' attu, ą'hua canchu chi íl·lani fin qui' yétsiloyu cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Becàbi Jesús nna rèe cabi: Lihue' cuidado qui'ni nú ttu nuỹa guthácca'ỹíą le. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Porqui'ni nuỹetse' íl·lani lani nombre quia' nna ina cą qui'ni làcą nua Cristua. Anía modo nna ca enne' ỹetse' guthácca'ỹí cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hua iyeni báni le ina cą qui'ni da' guerra o qui'ni chi cca guerra. Pero bittu gátsini le, porqui'ni náduel·la' cca iyaba ca cosį, pero nìhuani labí chi gùl·la' tè fin. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Porqui'ni ttu nación nna til·lą contra attu nación, ą'hua ttu gobierno contra attu gobierno nna. Ą'hua íl·lani itsahue' nna ubina' nna la' riỹú' fuérteni gaỹa tediba lugar nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iyaba ca cosį nna ccá cą nu chì' thulo rubání ca dolor. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Làniana gute cą le cuenta para ccá le sufrir hàstaá qui'ni gútti cą le. Ą'hua iyábani ca enne' nna guyudí' cą le porqui'ni ná le enne' ríalatsi' quia'. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Làniana nuỹetse' cą edúl·la'a latsi' quį nna gute cuenta luetsi quį ą'hua guyudí' luetsi quį nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ą'hua iỹetse' ca enne' íl·lani nna ina ca qui'ni rinne cą parte Tata Dios, pero labí líni cą. Enne' ỹetse' guthácca'ỹí cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Por causa de qui'ni hua dia la ràni tul·la' nna, acca la' tsì'ilatsi' qui' iỹetse' ca enne' nna étu bą́. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero nu thu ba tsìttsì lani inte' hàstaá fin nna, lànua nna l·lą́. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Náduel·la' ccá predicar evangelio nu cca qui' reino qui' Tata Dios le' itúỹiani yetsiloyu para qui'ni ccá saber iyábani ca nación. Làniana íl·lani fin. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Acca canchu chi ilá'ni le nu gunią nu ccábá latsi'į le' lugar nu ná para Tata Dios, tì'a chi gutixà'a profeta Daniel (nu rul·la nna ná qui'ni hue'él·la' latsi'į télinią), ");
INSERT INTO zaaNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","làniana canu tsè'e le' región qui' Judea nna ná qui'ni ucuitta taá cą tsía cą lo ca ló'ya lá. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nuỹa tediba duą iqquia azotea qui' yú'u quì'į nna, ná qui'ni eyàdią nna ucuìtta tabą́, bittu eya'ą le' yú'u para thí'ą biỹa te quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ą'hua nu reni fuera lo tsina quì'į nna, bittu eyeqquią litsi'į para gutùppą ca ỹúį, sino ná qui'ni ucuìtta tabą́. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pero canchu chi gal·la' tsá nna ica'rútsi'íru ca niula nùà' huatsa to', ą'hua canu rugatsi' ỹi'ni quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Acca línnabani Tata Dios lani oración qui'ni canchu chi gal·la' tsá ucuìtta le nna bittu ccą́ tiempo idil·la' nihua tsá redi' latsi' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Porqui'ni íl·lani ca sufrimiento fuérteni nu labí chi uccuą dèsdeba gure' yétsiloyu hàstaá tiempo tsè'e rí'uį, nihua làa ccáruhuą́ bitola nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Canchu labí eto' ca tsá tiempo qui' ca sufrimiéntua nna entonces lanú nuỹa l·lą́. Pero por la' retúalatsi' qui' Señor lani canu chi becuí'e nna, acca labí itsa ca sufrimiéntua. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Làniana canchu nuỹa gą́ le: Línna' tsáruhuá, nì du Cristua, o línna' tsáruhuá nà' taá dùe, bittu tsíalatsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porqui'ni huàl·lani làti tsè'e le canu ina qui'ni làcą nuá Cristua. Hua ría huá canu ina cą qui'ni rinne cą parte Tata Dios pero labí líni cą. Làcą nna guni cą iỹe ca milagro nna ą'hua adí ca cosa de la'huacca nu ccáỹíiní latsi' ca enne' para qui'ni gurèxaèl·la' cą cą xiaba hàstaá canu chi rée'ní Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ca nui riquixa'ánia' le con tiémpuba. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Así es qui'ni canchu gá cą le: Línna' tsáruhuá, fuera yétsią' taá dùe, bittu iria le. O canchu gá cą le: Le' ttu cuarto to' qui' templuą' taá rì'e, bittu tsíalatsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Porqui'ni tì'a rappi étha nna rudàni' rabáníą dèsdeba làti ril·lani bitsa hàstaá làti renią, ą'hua ilá'ni iyáỹiate ca enne' Nubeyu' de Ỹiabara' canchu chi itée attu de repéntetaá. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Porqui'ni gaỹa tediba té ttu nu yatti nna, pues níahuá itùppa ca bechettu. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Cuantu taání tté sufrimiento qui' ca tsá lània nna, entonces bitsą' nna echùl·lą, ą'hua biuá'ą' nna labiru gudàni'ą. Ca bélia nna ìnnia cą de ỹiaba, ą'hua iyaba canu tsìa ỹiaba nna tatìttiní cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Làniana ilá'ní qui'ni dua Nubeyu' de Ỹiabara'. Iyaba ca raza qui' yétsiloyu nna yala ehuiní'ni cą ilá'ni cą ne canchu chi íl·lanie lo bía lani la'huacca ỹeni quì'e nna la'yani' de ỹiabara' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Lèe nna ithèl·la' teée ca ángel quì'e para ucuetsi cabi trompeta nna gutùppa cabi ca enne' rée'ní Tata Dios itúbani yétsiloyu, dèsdeba làti ril·lani bitsa hàstaba làti renią. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Litelíni comparación qui' yexxuhuía: Canchu chi rerè'ne lúį nna rebia ca l·la' quì'į nna, anía modo cca ri'u saber qui'ni chi' taáduą íl·lani tiempo verano. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ą'hua lebi'i nna, canchu chi ilá'ni le qui'ni cca iyaba ca cosa nu chi gutixa'ánia' le nna, ą́' modo nna ccá le saber qui'ni exatàa ru'a puerta chi debíga' fin. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nia' le qui'ni làniana, alàa antes, hual·lani fin qui' tiempo tse'e ri'uį. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ỹiaba nna yétsiloyu lani iyaba ca indatò' nna l·luya bá latsi' quį, pero ca titsa' quíyi'į nna labí tté cą sino té qui'ni iyate cą nna ccá cą cumplir. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Pero lanú nuỹa yù biỹa tsá ní nihua biỹa hora ní, sino làteruba Tata quíya'a nna yùe; nìdirubani Ỹi'nie nna labí yù bi, nihua ca ángel tsè'e ỹiabara' nna labí yù cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ti'a uccua loti' gùdua Noé, ą'hua ccá canchu Nubeyu' de Ỹiabara' nna chì íl·lanie. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Porqui'ni ántesca ccá juicio indaá nna puro gu'ya go bá nna huettsaná' bá nna beni ca enne' hàstaá qui'ni bi'yu tsá gutà'a Noéa le' bárcuá. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Labí bennia cą cuenta hàstaá qui'ni uccua iyya juíciua nna biluỹa latsi' quį. Aníahuá ccá canchu chi íl·lani Nubeyu' de Ỹiabara' de repentetaá. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ą'hua canchu chuppa ca nubeyu' tsè'e cą tsina, ttuą nna édi'e, attuą nna eyà'na bą́. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ą'hua canchu chuppa ca niula yù'u cą huettu, ttuą nna édi'e, attuą nna eyà'na bą́. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Acca lítsé'e al tanto, porqui'ni labí yù le biỹa hora él·lani Señor qui' lía. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Litelíni nui: qui'ni ttu tàta nna, cáalá yùą biỹa hora íl·lani ubàna nna, pues labí gá'athią porqui'ni calatsi'į thuą al tanto para labí hue'él·la'ą nuỹa cuaną biỹa té le' yú'u quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Acca lebi'i nna, litse'e al tanto, porqui'ni Nubeyu' de Ỹiabara' nna là' íl·lani taánié canchu chi nìdirubani làa rulaba latsi' le qui'ni íl·lanie. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nuni enne' ní ná ttu siervo fiel nna té la' riyeni tsè' quì'į, acca bethà'na xana' niá na le' yú'u qui' bía para huí'ą na cuidado nna gutią nu go ca enne' tsè'e tsina hora ná qui'ni gó cą cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ica'rubà enni'a canchu chi etsìna' xana' niá nna ilá'ni bíą qui'ni runią voluntad qui' bi. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Hualigani te' riquixa'ánia' le qui'ni gute bi làtsi' ní'į iyate nu té qui' bi para cu'úbi'ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero ttu siervo nu labí runi tsè' nna gulaba lá latsi'į nna canią: álahua annatè él·lani xana' ya'a, ");
INSERT INTO zaaNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","làniana thulo chìą huí'ą adí canu runi tsìnàa, ą'hua í'ya gúą lani ca borracho. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Níyalatsi' enni'a nna él·lani xana' niá tsá nu nìdi làa ribèdą bi, hora nu labí yùą qui'ni él·lani bi nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Xana' niá nna idí'ni guni bi ą castigar, làniana gudàl·la tè bi ą lani adí canu beỹia. Nía nna yala ccą́ sufrir nna cuetsią nna goyà'atsùni layi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Canchu chi i'yu tsá nna, entonces reino qui' Tata Dios nna ccą́ comparar tì'a tsìi ca niula cuiti', guỹi' cą ca lámpara qui' quį nna biria tè cą tal·lèda cą ènne'yu' gúttsaná'a para guni cą bi acompañar yú'u thá'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gayu' ca niùláa nna uccua cą nu té la' riyeni tsè' qui' quį, pero ágayu' cą nna labí la' rulabalatsi' tsè' té qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Canu bihua rulaba latsi' tsì'a nna guỹi' gáláa cą ca lámpara qui' caniá, pero labí guỹi' cą aceite para cà'a cą le' ca lámpara. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Canu té la' riyeni tsè' qui' caniá nna gutà'a bá cą aceite le' ca lámpara qui' caniá. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pero rìtsa bá ènne'yu' gúttsaná'a nna, gul·lani chìa betsiàlà qui' quį nna gutá'athi cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Merua riluèla yèlà nna biyeni tsì'i ttu nu gunne iditsa nna rą: Nì chi da' ènne'yu' gúttsaná'a, líria tattsà' le bi. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Iyaba ca niula cuìti'a nna huatha chì cą nna begàl·la' cą ca lámpara qui' caniá. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Làniana gayu' canu bihua rulaba latsi' tsì'a nna ra cą canu té la' riyeni tsè' qui' caniá: Lígúnna xiarú bání titó' aceite qui' líą' qui' tu', porqui'ni chi reyòla ca lámpara qui' tu'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Becàbi gayu' canu té la' riyeni tsè' qui' caniá nna ra cą: Para qui'ni làa eyàtsa qui' tu' nihua lebi'i nna, adila tsa' lítsía xìa làti rutti' cą aceite nna lígó'o para lebi'i. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pero miéntraste dia cą huì'i aceite nna gul·lani ènne'yu' gúttsaná'a. Canu tsè'e prevenídua nna gutà'a cą lani bi làti cca thá'a. Làniana beyaya tè puértaá. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Bitola nna betsina' ca niula nu labí rulaba latsi' tsì'a nna bel·làbi cą ru'a puértaá nna ra cą: Señor, señor, guthàlia cuią'lu' gá'a tu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero becàbi enne' rúttsaná'a nna ra bi cą: Hualigani labí nabia' te' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Làniana ra huá Jesús cą: Por nui nna acca lebi'i nna lítsé'e al tanto porqui'ni labí yù le biỹa tsá nihua biỹa hora qui'ni Nubeyu' de Ỹiabara' nna ná qui'ni él·lanie. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Reino qui' Tata Dios nna cca huą́ comparar tì'a ttu ènne'yu' nu rida' bi dia bi idittu' nna, acca gutàỹi tè bi canu runi tsina qui' bía nna bethà'na bi lani cą ca interés qui' bía. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ttuą nna bete bi gayu' bolsa to' nu yù'u oro lani ą, attuą nna bete bi chuppa bolsa to' nu yù'u oro lani ą, attuą nna bè' bi ą ttu bolsa to' nu yù'u oro lani ą. Bete bi según ti'iỹa té bá capacidad qui' ttu ttu quį. Làniana guda' té bi dia bi idittu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nu guỹi' gayu' bolsa bél·liuá nna huia taą́ nna bethà'ą bél·liuá nna beni tìą gana ágayu' tanto. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Anía tehuá nu guỹi' chuppa bolsa bél·liuá nna beni huą́ gana áchúppa tanto. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero nu guỹi' ttùba bólsaá nna huíą nna gutànią liú'u yú nna becattsi' tìą bel·liu qui' xana' niá. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Guttè diba tsá nna bel·lani xana' ca siérvuá nna beyuni bi cuenta lani cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Bitsina' tè nu guỹi' gayu' bólsaá nna nùà' tìą ágayu' bolsa nna rą: Señor, gayu' bolsa betsia cuią'lu' làtsi' nàya' nna, nìba tè ágayu' bolsa nu chi benia' gana iqquį. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Acca ra xana' niá na: Tsè'ba ná nu beni lu' siervo tsè' nna cumplido nna; lani ti'to' rúba uccua lu' fiel, acca adírula iỹeni gúnná' làtsi' ná' lu'; por nui nna yala redacca' látsa'a', ą'hua lu' nna edacca' huáni lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Bitsina' tehuá nu guỹi' chuppa bólsaá nna rą: Señor, chuppa bolsa betsia cuią'lu' làtsi' nàya' nna, nìba tè áchúppa bolsa nu chi benia' gana iqquį. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Xana' niá nna ra bi ą: tsè'ba ná nu beni lu' siervo tsè' nna cumplido nna; lani ti'to' rúbá uccua lu' fiel, acca adírula iỹeni gúnná' làtsi' ná' lu'; por nui nna yala redacca' látsa'a', ą'hua lu' nna edacca' huáni lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Làniana bitsina' tè nu guỹi' ttu bólsaá nna rą: Señor, inte' nna yúá' qui'ni ná cuią'lu' ttu enne' duro, pues redi' cuią'lu' làti labí gùda cuią'lu', ą'hua rutùppa cuią'lu' làti labí bedàl·la cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Por nui nna gutsi te' nna becattsi' bá' bolsa bel·liu qui' cuíą'lu'į liú'u yú, acca nìba tè nu benna cuią'lu' lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Becàbi tè xana' niá nna ra bi ą: Siervo malo nu labí riỹu', hua yù bá lu' qui'ni redi'a' làti labí guda' ą'hua rutuppa' làti labí bedál·la'a' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Biecca labí gulú'u lu' bel·liu quíyi'į banco para qui'ni canchu chi el·lania' nna edi' ya' ą lani ỹi'nį. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Acca lebi'į nna lícua bolsą' lo ní'į nna líúte tì ą lani nu té tsìi bolsa qui' nią' la. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Porqui'ni nuỹa diba té quì'į nna, lą nna thí' lą́ adí nna gata'nìą adí iỹeni. Pero nu labí té quì'į nna, pues hàstaá ti'to' nu té quì'į nna ítua telą́. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Acca lithi' tè siervo nu làa riỹu'ą nna, líúdal·la ą fuera lá le' chul·la, nía nna ccą́ sufrir nna cuetsią nna góya'atsùni layi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Canchu chi íl·lani Nubeyu' de Ỹiabara' le' la'yani' quì'e lani iyaba ca santo ángel, làniana cué'níe lo xila' tsè'ni quì'e para gucuí'e entre ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Por ejemplo: ttu pastor nna rèl·la'a bą́ luetsi ca carneru to' lani ca chivo. Ą'hua Nubeyu' de Ỹiabara' nna etùppa itúỹiate ca enne' qui' iyaba ca nación ru'a lúe. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ca enne' gutsì'e lado ná' bànie nna ccá cą comparar lani ca carnero to' qui' ttu pastor. Pero ca enne' gutsì'e lado ná' yattie nna ccá cą comparar lani ca chivo qui' ttu pastor. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Lèe nna née Rey enne' rigú'ubia' lo iyate acca gá tìe ca enne' tsè'e lado ná' bànie: Lità canu chi beni Tata quí'a bendecir, léya'a le' reino nu chi ná preparado para lebi'į dèsdeba uccua yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Porqui'ni gutùnia' nna benna le gùtua'; gubìtsia' nna benna le inda gu'ya'; guréni ttùba' nna bedi' le inte' litsi' le; ");
INSERT INTO zaaNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","casi xpela' bá gurénia' nna benna le nu gucuá'a'; huì' te' nna tanàba titsa' le inte'; gúttá'a' litsi' iyya nna bìta le tanèl·le' le inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Làniana ca enne' beni tsè'a nna ecàbini cabi e nna ina cabi: Señor, cuani gutùni cuią'lu' nna benna tu' gutó cuią'lu' cá. Cuani gubitsi cuią'lu' nna benna tu' inda gu'ya cuią'lu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ą'hua cuani bilá'ni tu' gureni ttùba cuią'lu' nna bedi' tu' cuią'lu' litsi' tu' cá. Cuani bilá'ni tu' gurèni cuią'lu' casi xpela' bá nna benna tu' nu guccu' cuią'lu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ą'hua cuani huì'ni cuią'lu' nna tanàba titsa' tu' cuią'lu' cá. Ą'hua cuani gùtta' cuią'lu' litsi' ìyyà nna tanèl·le' tu' cuią'lu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ecàbinie cą nna íneé: Hualigani te' nia' le qui'ni loti' beni li ą lani nuỹa ttu ca hermanos quíyi'į màsqui'ba ną́ nu adiru xcuìchuto' nna, pues ti'atsi para inte' bá beni li ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Làniana gá huée canu tsè'e lado ná' yattie: Liucuìtta ru'a lua' porqui'ni maldito bá ná le, tsía le lo yí' nu chi ną́ preparado para numalua lani ca ángel quì'į, làti cca cą sufrir tulidàni. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Porqui'ni gutùnia' nna labí benna le gúá'; gubìtsia' nna labí benna le inda í'yá'; ");
INSERT INTO zaaNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","uccua'a' ttu enne' dittu' lani le nna pero labí benna le ttu lugar to' làti eyà'na'; casi xpela' bá gurénia' nna pero labí benna le ttu lári' to' gaccu'a'; huì' te' nna ą'hua guttá'a' litsi' ìyyà nna, pero labí tanàba titsa' le inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Làniana ecàbi huáni cą ne nna ina cą: Señor, cuani gutùni cuią'lu' nna gubitsi cuią'lu' nna gurèni ttùba cuią'lu' cá. Cuani gurèni cuią'lu' casi xpela' bá nna huì'ni cuią'lu' nna gutta' cuią'lu' litsi' ìyyà nna labí beni tu' cuią'lu' atender cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Làniana ecàbinie cą nna íneé: Hualigani te' nia' le qui'ni lebi'į nna labí beni li ą lani nuỹa ttu canu adiru xcuichu tú'į, acca nihua lani inte' labí beni li ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Acca ca nui nna tsía bá cą para ccá cą sufrir tulidàba ttu castigo nu labí fin quì'į té, pero ca enne' biria tsè' ru'a lúe nna edacca' latsi' quį tulidàni lani la'labàni nu labiru ttíą qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Beyacca ba gutixà'a Jesús iyaba ca tìtsa'a, làniana rèe ca discípulo qui'áa: ");
INSERT INTO zaaNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Chi yù le qui'ni áchúppa ubitsa teruba reyatsa para gal·la' tsá fiesta nu reya ri'u Pascua, làniana gute cą inte' Nubeyu' de Ỹiabara' cuenta para gutá' cą inte' lo yà curutsi. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Làniana iyaba ca sacerdote principal nna ca maestro de la ley ą'hua canu rigú'ubia' entre ca enne' judíua nna betùppa cą le' lí'a qui' Caifás nu ná huexána' qui' ca sacerdótea. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Làcą nna gulu'u titsa' luetsi quį ti'iỹala guni cą para gudaxu' cą Jesús lani máñaba para gútti cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ra cą: Alàa tsá gani fiéstą' gudaxu' ri'u ą preso, para qui'ni làa etùppa ca enne' ỹetse' nna chatha alboroto le' ciudíį. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Làniana re' Jesús le' yetsi láą Betania litsi' Simón enne' huì'ni yetsu' yùtsu'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Bitsina' tè ttu niula ru'a lúe nù'ą ttu frasco tsíttsi to' tá'a lì'į perfume nu dacca' yaỹi tsè' beduą perfúmea iqquia Jesús de rì'e lo méỹaá. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","De bilá'ni ca discípulua nui nna bitsa'áni cabi nna ra cabi: Biecca catìttia nui ni'i, ");
INSERT INTO zaaNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","porqui'ni cáalá bètti' la ri'u perfúmeą' nna, iỹeni tsè' quiỹa cą na guni ri'u cualani ca enne' ritè la'di'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","De gutelíni Jesús nu rulaba latsi' ca discípulua nna rèe cabi: Biani cca ritsa' le niulíį ni'į. Pues lą nna chi benią ttu obra tsè' lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ca enne' pobre nna tulidàba tsè'e cą lani le, pero inte' nna álahua tulidà renia' lani le. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Porqui'ni de beduą perfúmį iqquia' nna benią inte' preparar para canchu chi igàttsi'a'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Hualigani te' nia' le qui'ni gaỹa tediba ccá predicar evangéliuį le' itúbani yétsiloyu nna, guna huá ca enne' nu beni niulíį. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Làniana ttu canu tsì'nua láą Judas Iscariote nna huíą ru'a lo ca sacerdote principal nna, ");
INSERT INTO zaaNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","rą cą: Biani gúnnání le quia' para gútià' cuenta Jesús lani le. Làcą nna beni cą acordar lani ą qui'ni gute cą tsìi érua' moneda nu de plata quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Desdeba lània nna beyìla latsi' Judas ti'iỹala modo gutią ne cuenta. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Primero tsá fiesta qui' Pascua loti' chi ro cą ettaxtíla sin levadura nna, bitsina' ca discípulo qui' Jesús ru'a lúe nna ra cabi e: Gani calatsi' cuią'lu' guni ri'u fiéstį para qui'ni guni tu' preparar go se' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Lèe nna rèe cabi: Lítsía le' ciudą́' le' litsi' ttu nubeyu' nna ga li ą: Maéstrua nna guthèl·le'e intu' nna rèe: Chi debiga' hora quia', acca le' litsi' lu' nna gunia' celebrar páscuį lani ca discípulo quíyi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ca discípulua nna beni cabi tì'taba ra Jesús cabi nna beni cabi preparar para guni cabi celebrar Pascua. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","De gùl·là tsá lània nna gurè'nie lo méỹaá lani tsì'nu ca discípulua. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Miéntraste ro cabi nna gunne Jesús nna rèe: Hualigani te' riquixa'ánia' le qui'ni ttu le nna gutią inte' cuenta làtsi' ná' canu labí cca guyu cą inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Làcabi nna yala triste uccuani cabi. Gudulo ttu ttu tsa cabi nna ra cabi e: Tsí inte' Señor. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Becàbie nna rèe: Nu ruga'a ní'į le' plato lani inte' nna, lą nua gutią inte' cuenta. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nubeyu' de Ỹiabara' nna hualigani ccá bá cumplir lani e iyate nu ga'na escrito nu cca quì'e, pero ica'rútsi'íru nu gutią ne cuenta; pues para lą nna adila tsa' cáalá bittu telá gùlią. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Làniana Judas nu gunią ne traicionar nna rą: Tsí inte', Maestro. Becàbi Jesús nna rèe na: Lu' bá chi ra ą'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","De chi ro cabi ttu te la'góa nna, guỹi' Jesús ettaxtílaá nna gunàbèe bendición lani Tata Dios enne' ná Tata qui'áa nna gùl·le'ée ettaxtílaá nna bì'e ca discípulo qui'áa nna rèe: Líthi' nna ligo nna, nui nna ną́ cuerpo quia'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Làniana guỹi' tìe vásuá. De chi bì'e gracia Tata qui'áa nna betie lani cabi nna rèe: Líthi' nna lí'ya iyate le; ");
INSERT INTO zaaNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","porqui'ni nui nna ną́ reni quia' para qui'ni ccá seguro promesa cubi nu runia' nna ilàlią para qui'ni gata' la' runittiló por ca tul·la' qui' iỹetse' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ą'hua riquixa'ánia' le qui'ni dèsdeba annana labiru i'ya' inda qui' betsulí' hàstaá qui'ni i'yu tsá i'ya ya' ą attu lani le le' reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","De beyacca bìl·la cabi hímnuá nna huía cabi lo i'ya láą Monte de Olivos. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Làniana Jesús nna rèe cabi: Iyaba le nna gutsè'e latsi' le inte' nèlà, porqui'ni ra Tata Dios lo Escritura: inte' nna gútía' permiso para gútti cą enne' ná Pastor, làniana ca carnero qui' bía nna gathilàlia cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero riquixa'ánia' le qui'ni bitola de eyátha'a' de lo lù'uti nna, nérua' lo le para etsa' ri'u Galilea attu vuelta. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Làniana gunne Pedrua nna ra bi e: Màsqui'ba iyaba cą gutsè'e latsi' quį cuią'lu', pero inte' nna nunca labí gutsè'e látsa'a' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús nna rèe bi: Hualigani te' nia' lu' qui'ni nèlà nna tsunna vuelta labí thí'ché' lu' qui'ni nabia'ni lu' inte', làniana cuetsi xcurúdia. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedrua nna ra bi e: Màsqui'ba canchu caduel·la' gatti huá' lani cuią'lu', pero labí ínníá' qui'ni làa nabia' te' cuią'lu'. Anía tehuá ra iyaba ca discípulua. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Làniana bitsina' Jesús lani cabi ttu lettia láą Getsemaní nna rèe ca discípulo qui'áa: Nìba líxuani miéntraste tsa'á' gunia' oración. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesús nna guche' tìe Pedrua ą'hua chuppa ca ỹi'ni Zebedéua nna. Làniana gudulo uccuani triste latsi'e nna tsì'irúbani uccuanie nna ");
INSERT INTO zaaNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","rèe cabi: Yala triste cani latsi' lóstu'a' ti'atsi chì' taání rattia'. Nìba licuèda inte' nna bittu ga'athi le. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Guda' tìe áti'to' tè anía lá nna, beduỹíbie nna benie oración nna rèe: Tata Ỹitsi' quia', canchu ná posible qui'ni bittu ttí'a' ca sufrimiéntuį, pero alàa tì' ccá bá látsa'a' sino ccá bá según voluntad qui' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Làniana beyéqquie làti tsè'e ca discípulo qui'áa nna ti'éthi bá cabi, acca rèe Pedrua: Tsí labí ccani le gúchia le bétsiala ttu hora rúbá para guni le inte' acompañar cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Lítsé'e al tanto, lígúni oración para qui'ni làa innia le le' tentación. Hualígáláa yala dispuesto ná le ccá le enne' fiel lani inte', pero labí fuerza té qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Huía tìe attu nna benie oración nu cca chuppa vuelta nna rèe: Tata Ỹitsi', canchu labí posible té para qui'ni làa ttí'a' ca sufrimiéntuį, pues ccá bá según voluntad qui' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","De betsine'e attu nna dedeti'áthi hua cabi, porqui'ni tsa'ti'bání bétsiala lo cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bethà'na bée cabi nna huíe attu benie oración nu cca tsunna vuelta nna gunnie la'a mísmuba ca tìtsa'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Làniana betsine'e attu làti tsè'e ca discípulo qui'áa nna rèe cabi. Tsí àtsabá ti'éthi le. Chi gùl·la' hora qui'ni inte' Nubeyu' de Ỹiabara' nna ttí'a' làtsì' ná' canu tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Léyátha nna léya', nì chi da' nu gutią inte' cuenta. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Atsabá rinne Jesús nna, gul·lani chì Judas ttu canu tsì'nua. Ą'hua iỹétse'ni ca enne' da' lani ą yù'u ná' quį espada l·le yà l·le. Làcą nna da' cą por orden qui' ca sacerdote principal ą'hua por canu rigú'bia' le' yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas nu gutią ne cuéntaá nna gutixà'ą ti'iỹa ná seña nu gunią, nna rą: Nu gutsa'lo ya'a nna, lą nua, gudaxu' tabá li ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Gubiga' taą́ ru'a lo Jesús nna benią ne saludar nna rą ne: Maestro. Làniana betsa' tè lúį ne. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús nna rèe na: Amigo, bianicca da' lu'. Làniana gubiga' cą làti du Jesús nna bedaxu' chì cą ne preso. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pero ttu enne' entre canu tsè'e lani Jesús nna gulèqquia bi espada qui' bía nna becàa ná' bi nna bè' bi ttu huenitsìna qui' huexána' qui' ca sacerdótea nna guchu bi yéti nagui'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús nna ra tìe bi: Begú'u espada qui' lu'ą' lugar quì'į, porqui'ni iyaba canu ribèqquia cą espada nna, pues lani espada hua il·lùỹaní latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Tsí ina ri'u cani lu' quį'ni inte' nna bihua cca te' inábania' Tata quí'a, lèe nna ithèl·le'e téelá tsì'nu ejército de ca ángel para edi' cabi inte' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero cáalá ná qui'ni cca lą', ti'ala modo ccá cumplir nu ra lo ca Escritura làti riquixa'a qui'ni náduel·la' ccá' padecer ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Làniataá nna ra Jesús canu ỹétse'á: Tì'a canu dia gudaxu' ttu ubàna, ą' da' le yù'u ná' le espada nna yà nna para gudaxu' le inte' preso. Ttu ttu tsá bá gùri'a' le' templua nna gutixa'ánia' iyaba le nu cca qui' Tata Dios, atsi'íni bihua bedaxu' le inte' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero iyaba canui cca para qui'ni ccá cumplir nu bedia ca profétaá acerca de inte'. Làniana iyaba ca discípulua nna betsè'e latsi' cabi e nna becuìtta cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Canu bedaxu' cą Jesús preso nna guche' cą ne ru'a lo Caifás nu ná huexána' qui' ca sacerdótea, làti tuppa ca maestro de la ley ą'hua canu rigú'ubia' entre ca enne' judíua. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedrua nna idittu' bá deno bi e hàstaá le' lí'a ru'a yú'u qui' huexána' qui' ca sacerdótea. Gutà'a tè bi nna gurè'ni bi lani ca policía para inna' bi biỹa guthácca' cą Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Làniana ca sacerdote principal ą'hua canu rigú'ubia' le' yétsiá nna lani iyaba canu retùppa Junta Suprema qui' ca enne' judíua nna reyìla cą ttu causa contra Jesús, para qui'ni gappa cą néda gute cą ne cuenta para gattie. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero labí biỹa caúsani betseláni cą contra lèe màsqui'ba iỹetse' cą gulìtha cą bela'na quì'e. Bitòỹìani nna gubíga' áchúppa testíguá nna beni latsi' quį nna ");
INSERT INTO zaaNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ra cą: Nui nna rą qui'ni huaccanią gutàppa'ą templo qui' Tata Dios, pero le' tsunna ubitsa teruba nna echìthą na attu. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Guduli tè huexána' qui' ca sacerdóteá nna rą ne: Tsi bihua biỹa ecàbi tí' lu'. Biani nuą' ra canui contra lu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero Jesús nna labí becàbie. Làniana huexána' qui' ca sacerdótea nna gunnią attu nna rą ne: En nombre de Dios, pues lèe nna bànie tulidàba, rinábania' lu' qui'ni quíxá'a lu' canchu hualí ná lu' Cristo Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús nna rèe na: Lù'ba chi ra ą́'. Ą'hua nna nia' le qui'ni dèsdeba annana ilá'ni le Nubeyu' de Ỹiabara' duánie lado ná' bàni de la'huacca qui' Tata Dios nna íl·lanie lo bía ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Làniana huexána' qui' ca sacerdótea nna guchèda'ní ỹúi para gulue' qui'ni yala bitsa'ánią nna rą: Labí respeto té quì'į lani Tata Dios. Biáruálá testíguni riquína'ni ri'u cá. Chi biyénini le gunnią ca titsa' nu ná qui'ni làteruba Tata Dios ínnie ą́'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Annana biani ína le ccá quì'į. Becàbi tabá cą nna ra cą: Ccá bą́ merecer gattią. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Làniana betùtu chì xèni' quį lúe nna bè' cą ne puñete. Adí cą nna gutìni ná' quį lúe nna ");
INSERT INTO zaaNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ra cą ne: Canchu ná lu' Cristo nna guna tsanna nuỹa nua' bí'ą lù'na. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedrua nna re' ba bi le' lí'a. Làniana gubiga' ttu criada làti re' bía nna rą bi: Ą'hua lu' nna gurèni huá lu' lani Jesús nu Galiléą'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedrua nna labí guỹí'ché' bi nna ra bi ru'a lo iyaba quį: Labí yua' biỹa nuą' ra lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","De beria bi ru'a puértaá nna bilá' tènì attuą bi nna rą canu tsè'e nía: Ą'hua nui nna gurèni huą́ lani Jesús Nazarénuą'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Labí guỹí'ché' Pedrua attu vuelta nna beni bi jurar nna ra bi: Labí nabia' te' nubéyu'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ti'tó' taá bitola nna gubiga' canu tsè'e nía nna ra cą bi: Ą'hua lu' nna hualigani ná lu' enne' qui' quį porqui'ni hàstaá la' rinne qui' lu' nna redacca' rabání. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Beni chi Pedrua jurar nna ra bi: Nitti ba' canchu labí lí te' de nia' qui'ni labí nabia' te' nubéyu'ą'. Làniana guretsi chì xcurúdia. ");
INSERT INTO zaaNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bexa tè latsi' Pedrua ca titsa' gunne Jesús loti' rèe bi qui'ni: Labí cuetsi xcurúdia ántesca ccá tsunna vuelta guni lu' inte' negar. Làniana yala behuiní'ni bi nna beria bi fuera nna biditsuní bi guretsi bi. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","De chi da' rànì'a nna iyaba ca sacerdote principal ą'hua canu rigú'ubia' entre ca judíua nna gunne lettia cą ti'iỹa modo guni cą contra Jesús para gútti cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Beỹìqquia cą né'e nna bete tè cą ne cuenta lani gobernador Poncio Pilátuá. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Làniana Judas nu benią Jesús traicionar nna, de bilá'nią qui'ni nu ỹeni chi ruthácca' cą ne nna, acca belenínią nna uccua latsi'į ótią tsìi érua' moneda nu de plátaá lani ca sacerdote principal nna canu rigú'ubia' entre ca enne' judíua nna, ");
INSERT INTO zaaNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","acca rą: Inte' chi benia' tul·la', betí'a' cuenta ttu enne' inocente para gattie. Lacą nna ra cą na: Biáruá dacca' guni tu' ni'i. Nà'ba beyu ti'iỹa guni lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas nna guru'na tìą bél·liuá le' templua nna beria tìą nna huíą guthi yánią nna gùttìą. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ca sacerdote principal nna de bedi' cą bél·liuá nna ra luetsi quį: Labí ná qui'ni cu'ú ri'u bél·liuį làti yù'u ofrenda qui' templuį porqui'ni ną́ nu dàcca'ní réni qui' ttu enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Gulèqquia lettia diba cą nna huì'i cą lani bél·liuá ttu pedazo loyu qui' ttu nubeyu' nu runi traste, para ccą́ panteón qui' canu dìttu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Dèsdeba lània nna gutìxa tè cą lá lóyúa: Loyu por precio de réni. Ą'ba té líį hàstaba natsá. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ania modo uccua cumplir nu ra Jeremías enne' uccua profeta qui' Tata Dios tiempo antigua nna ra bi: Guỹi' cą tsìi érua' pieza plata, precio nu bedu ca ỹi'ni Israel nu dàcca'ní ttu enne' lània. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Lani bél·liuá nna huì'i cą loyu qui' nu runi trásteá, ti'a beni Señor inte' mandado. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús nna de gùdue ru'a lo gobernador Pilatua, lą nna gunàba tìtsa'ą ne nna rą: Tsí ná lu' rey qui' ca judíuą' cá. Jesús nna rèe na: Lù'ba chi ra ą́'. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ca sacerdote principal ą'hua canu rigú'ubia' entre ca enne' judíua nna betsia cą queja contra Jesús. Pero lèe nna labí becàbie. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Làniana Pilatua nna rą ne: Tsí bihua riyénini lu' bícca'áỹa rinne cą contra lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús nna nidi ttu titsa' labí becàbie hàstaá qui'ni gobernador nna yala uccuaỹí latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tsá gani fiéstaá nna té costumbre qui' gobernador gúla'ą ttu preso, nuỹa tediba inàba yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Merua lània nna té ttuą litsi' ìyyà láą Barrabás, hua dàa gá titsa' quì'į runią mal qui' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","De betùppa iyaba ca enne' judíua nna ra Pilatua cą: Núlá calatsi' le gúlá'a', tsí Barrabás o tsí Jesús enne' lá Cristo áccá. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Anía ra Pilatua porqui'ni hua yù bą́ qui'ni por la' yélatsi' bá bete cą Jesús cuenta lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","De re' Pilatua le' juzgádua nna bitsina' ttu razón nu guthèl·la' niula qui' Pilatua nna rą: Bittu tehuá gúlatsi' qui' lu' nu cca qui' nubeyu' inocénteą', porqui'ni yèlà tabíní gunne te' bitsiàla por causa quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero ca sacerdote principal nna ą'hua canu rigú'ubia' entre ca enne' judíua nna gulù'u yi' cą latsi' yétsiá qui'ni innàbani cą Pilatua qui'ni gudilą́ Barrabás lá pero Jesús nna gatti bée. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gobernador nna gunàba tìtsa'ą cą nna rą: Núlá canu chuppíį calatsi' le gúdilá'a'. Becàbi taá cą nna ra cą: Barrabás. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatua nna rą cą: Biala gunia' lani Jesús enne' lá Cristuį ni'i. Becàbi iyaba cą nna ra cą: Tá' bą́ lo curutsi. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Làniana ra Pilatua cą: Pues biani mal ni chi benią ni'i. Pero làcą nna adila guretsiyà'a cą nna ra cą: Tá' bą́ lo curutsi. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Beyùba Pilatua qui'ni labí cca tsi qui' quį, ántesla adila escándalo runi cą, acca guỹi'ą inda nna gutìi ní'į ru'a lo canu yétsiá nna rą: Por nui nna cca le saber qui'ni labí ccá' responsable por lù'uti qui' ènne'yu' tsè' du nì. Lebi'i ba ibàga' li ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Làniana ituba yétsiá nna rą: Intu' ba lani ca ỹi'ni tu' nna ibàga' tu' réni quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilatua nna bela' tìą Barrabás. Pero benią mandado iyàa' la Jesús, làniana betią ne cuenta para té'e lo curutsi. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ca soldado qui' gobernador Pilatua nna guche' cą Jesús le' lí'a qui' paláciua nna betùppa iyábani cą ìta'lùbani e. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Gulèqquia tè cą ỹúe nna begàccu' cą ne ttu lári' de color morado. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Gulù'u tè cą iqquie ttu corona tíaníą yèttse'. Gulù'u tè cą ttu vara le' né'e lado bàni, bedu tè ỹibi quį ru'a lúe nna beỹìtsi tènì cą ne nna ra cą: Viva, Rey qui' ca judío. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Làniana betutu xèni' quį ne nna guỹi' tè cą vara nu dèniáa nna bè' cą iqquie. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bitola de beni cą ne burla nna, bebèqquia cą lári' nu naccu'éa nna begàccu' cą ne ca ỹúeá attu. Làniana guche' cą ne para gutá' cą ne lo curutsi. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Merua riria cą lani e nna bettsà' cą ttu nubeyu' Cirenéo láą Simón, behuà'ni duel·la' cą na curutsi qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bitsina' cą lugar láą Gólgota, titsa' qui' ri'u nna rą: Iqquia Bega' Yatti. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bete cą vinagre chixią nu ná ìl·la' para í'yèe. Benìxi díbée vinágrea nna pero labí gú'yèe na. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Betaá' diba cą ne lo curútsia nna làniana bedàl·la cą rifa nuỹa la cą gal·la' ca ỹúeá. Anía modo nna uccua cumplir nu bedia ttu profeta gunne bi nu cca quì'e nna ra bi: Gùl·la'ání cą ca ỹó ya'a nna bedàl·la cą rifa lo quį. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Guỹua tení cą nna gunna' cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Betaá' tè cą ttu letrero iqquia curutsi làti téáa biỹa cca té'e nía nna rą: NUI NUĄ' JESUS REY QUI' CA JUDIO. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Betaá' huá cą lo curutsi ttu ttu lado luítte'é chuppa ca ubàna, ttuą lado ná' bànie, attuą lado ná' yattie. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Canu guttè nía nna beduadí' cą ne nna bettáa iqquia quį para guni cą ne despreciar nna ");
INSERT INTO zaaNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ra cą: Lu' nu rena qui'ni gutàppa' lu' templua nna le' tsunna ubitsa teruba echìtha lu' ą, pues bedilà la'a lù'ba nna beyàdi tsanna lo curútsią' canchu hualigani ná lu' Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Anía tehuá beni ca sacerdote principal ne burla, lani ca maestro de la ley nna ca fariséua nna ą'hua iyaba canu rigú'ubia' le' yétsiá nna ra cą: ");
INSERT INTO zaaNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Canu huaya' nna bedilà bą́ atsi'íni la'a làbą nna labí ccanią gudilàą; Annana eyàdią lo curútsią' canchu hualigani ną́ Rey qui' yetsi Israel, lànialá nna hueyya latsi' ri'u quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Lą nna gùppa bą́ confianza Tata Dios, pues gudilà bée na anna canchu hua catsi'ínie na; porqui'ni la'a làbą nna rą: Inte' ná' Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Anía tehuá beduadí' ca ubàna tá' lo ca curútsia ne. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ttu tsì'nu hora ti'gá nna bechul·la le' itúbani yétsiloyu hàstaá ritìį tsunna. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chi' taáduą gal·la' ritìį tsùnnaá nna gunne Jesús idìtsani nna rèe: Elí, Elí, lama sabactani. Ca tìtsa'a nna quiere decir: Tata Dios quia', Tata Dios quia', biecca betse'e latsi' cuią'lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tuchùppa canu tsè'e nía nna de biyénini cą rèe anía, accana ra cą: Elías bá rul·luítsa'ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Làniataá nna bigàa ttuą guỹi'ą ttu esponja nna bedibìthą́ na lani vinagre, bedua tìą na lo ttu yíi nna bì'ą ne í'yèe. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero adí cą nna ra cą: Bittu, sino inna' ri'u canchu ìta Elías gudilà bi ą. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Làniana iditsa tsè' guretsi ya'a Jesús nna betie espíritu quì'e làtsi' ná' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Làniataá nna lári' rriani nu dàa para gunią dividir le' templua nna bireda'ą uccuą chuppa l·la'áni biyàlia dèsdeba íqquiará' hàstaba ỹàrèe' por la'huacca qui' Tata Dios. Ą'hua gùỹù' yétsiloyu nna, ą'hua ca íyya èl·la nna biỹa' cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ą'hua ca yerubà nna biyàlia cą, nuỹetse' ca enne' qui' Tata Dios canu chi gùttì nna beyátha cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Beria cabi le' yerubà bitola de beyátha Jesús de lo lù'uti nna, huía tè cabi le' Jerusalén ciudad nu ná para Tata Dios; enne' yetse' nna bilá'ni cą cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Làniana ttu capitán lani adí canu tsè'e guardia làti tá' Jesús lo curútsia nna, de gutebé'ni cą qui'ni gùỹù' nna ą'hua bilá'ni cą iyaba ca cosa nu uccua nna, yala gutsini cą nna ra cą: Hualigani qui'ni lą nna ną́ Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Idittu' tí'bá de nía nna tsè'e iỹé ca niula huenna'. Làcą nna tanó cą Jesús dèsdeba Galilea nna beni cą ne servir. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Entre ca niuláa nna látsi' huá María Magdalena, ą'hua María nàna qui' Jacóbua nna Joséa nna, ą'hua nàna qui' ca ỹi'ni Zebedéua nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mérutaá da' ral·la lània nna bitsina' ttu enne'yu' rico nu Arimatea lá bá José. Ą'hua làbi nna uccua bi ttu enne' huíalatsi' qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Joséa nna huía bi ru'alo Pilatua gunàba bi cuerpo qui' Jesús. Pilatua nna benią orden gute cą cuerpo qui' Jesús lani bi. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joséa nna bedi' bi cuérpuá nna betùbi tè bi e ttu sábana cubi. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Gutìxa tè bi cuerpo qui'áa le' ttu bà cubi nu chì' beni ba bi le' ttu íyyatò'. Betsíga' tè bi ttu íyya ỹénitsè' ru'a bàa nna bedà' tè bi. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nía nna du María Magdalena ą'hua attu María nna, guỹuaní cabi ru'a bàa. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Attu yu'utsá nna guttè diba beni cą preparar para tsá redi' latsi' quį nna, betùppa ca sacerdote principal ą'hua ca fariséua ru'a lo Pilatua nna, ");
INSERT INTO zaaNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ra cą: Señor, intu' nna rexa latsi' tu' titsa' nu gunne bèỹiaá loti' bàniru naá, qui'ni bitola de tsunna ubitsa nna eyáthą de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Acca guthel·la' cuią'lu' guardia para qui'ni hué' cą cuidado lo bàa hàstaá bitsa ccá tsunna, para qui'ni làa tsía ca discípulo qui' niá de réla nna cuana cą cuérpuá nna gá tè cą ca enne' qui'ni chi beyaccabàníą, entonces adí teérulá peor ccá la' beỹìį tì'chula nerua. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatua nna rą cą: Nà'ba tsè'e ca soldado qui' le. Lítsía nna lígúni ą seguro tì'a ná bá la' rulábalatsi' qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Làcą nna huía cą beni seguro cą bàa, berèni tè cą sello lati íyyaá nna betsè'e cą guardia. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Guttè diba tsá sábaduá para tsáni' díla primero tsá qui' semánaá, huía María enne' Magdálaá lani attu María huanèl·le' lo bà qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Guttè tè ttu la' rìỹu' fuerte gani, porqui'ni ttu ángel enne' guthel·la' Señor nna huàdi bi de ỹiabara' nna gutua bi íyya nu re' ru'a bàa nna gùdua tení bi iqquį. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","La' rinna' qui' ángeliá nna uccua tì'a la'yani' qui' éthá. Ỹo bi nna uccuą tsíttsi tùni ti' taání beyi'. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Canu tsè'e guardia nna de tántuani gutsini cą nna, biỹìtti'ní cą nna gubixi cą nna gùttì tsaléttia taání cą. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Gunne ángeliá nna ra bi ca niuláa: Bittu gátsini le, hua yúbá' qui'ni reyìla le Jesús enne' betti cą lo curútsia. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Lanúrué té nì pues chi beyathèe de lo lù'uti tì'ba chi rèe. Litaáruhuá inna' le làti gutìxa cą néa, ");
INSERT INTO zaaNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","lítsía quetha taá ligàtsi ca discípulo qui'áa qui'ni chi beyathèe de lo lù'uti. Lèe nna tsíe Galilea, níabá ettsà' li e. Ą' ná qui'ni equixa'ánia' le. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ca niuláa nna yala biquila' latsi' cabi ą'hua yala bedácca'ni cabi nna, beyya chì cabi quethani para equixá'ani cabi ca discípulua. Ca niuláa nna merua deyya cabi taquixá'ani cabi ca discípulua, ");
INSERT INTO zaaNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","tiémputaá nna tàttsa' Jesús ca niuláa nna benie cabi saludar. Làcabi nna gubiga' cabi ru'a lúe nna gunìta' cabi ca nì'e nna beni cabi e adorar. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús nna ra tìe cabi: Bittu gátsini le, lítsía líúte noticį lani iyaba ca bettsi' ya'a para qui'ni tsia cą Galilea nna, nía ba ettsà' tu'. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Dàca'te deyya ca niuláa nna, tuchùppa canu tsè'e guardia nna beyya huá cą le' ciudáad nna gutixa'áni cą ca sacerdote principal iyaba ca cosa nu uccua. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Betùppa tè cą lani canu rigú'ubia' entre ca enne' judíua nna, gunne lettia cą nna bete cą iỹénitse' bel·liu qui' ca soldadua nna, ");
INSERT INTO zaaNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ra cą: Lebi'į nna ínne le qui'ni ca discípulo qui' niá bìta cą de réla lá nna gutua gattsi' ba cą cuerpo qui' niá miéntraste ti'áthi ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Canchu gúna gobernador asúntuį nna, entonces intu' ba ccálaní tu' ą arreglar, bihua cuidado tsé'e le. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Làcą nna guỹi' cą bél·liuá nna beni cą tì'a nu chi gulù'u titsa' ca judíua cą. Iį modo nna riquixa'a ca enne' Judea nu uccua, hàstaá anna. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Huía taá tsinia ca discípulua Galilea lo i'ya làti chi ra Jesús cabía. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","De bilá'ni cabi e nna beni cabi e adorar, pero tuchùppa cabi nna labí huía tè latsi' cabi canchu làganie enni'a. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Làniana gubiga' Jesús gùnnie lani iyaba cabi nna rèe: Itute poder chi benna Tata Dios látsi' nàya' para cu'úbi'a' ỹiabara' ą'hua yétsiloyu nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Acca lítsía nna liquixá'ani iyáỹiate ca enne' le' iyábani ca nación anta' yétsiloyu qui'ni tsíalatsi' quį inte' nna ccá huá cą ca discípulo quia'. Guni tè le cą bautizar lani nombre qui' Tàtáa nna, qui' Ỹí'niáa nna, qui' Espíritu Santo nna. ");
INSERT INTO zaaNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Liulue'ni cą iyate nu ná qui'ni guni cą tì'a chi pá'a' le. Inte' nna du bá' lani le para gunia' le cualani ttu ttu tsáaní hàstaá l·luỹa latsi' yétsiloyuį. Ą' uccua.");
INSERT INTO zaaNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Gudulo evangelio nu cca qui' Jesucristua Ỹi'ni Tata Dios, ");
INSERT INTO zaaNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","tì'ba riquixé'e lo libro nu bedia profeta Isaías enne' gùdua ántescala ìta Jesucristua yétsiloyu: Inte' nna rithél·la'a' mensajero quia', deneru bi lo lu', Para ithàlia bi néda para guni cą lu' recibir. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Rùyeni ttu enne' fuera yetsi nna ra bi ca enne' ritsina' ru'a lo bi: Lítsé'e leda porqui'ni chi da' Señor; liutha' lí ca néda qui' la'labàni qui' le para lèe. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ca tìtsi'į nna uccua cą cumplir por Juan enne' beni bautizar. Gurèni bi fuera yetsi nna, gutixa'áni bi ca enne' lani poder qui'ni dàni cą eyacca cą arrepentir por ca tul·la' qui' quį para qui'ni eyuniỹén latsi' Tata Dios qui' quį nna ccá tè cą bautizar. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Biria tè ca enne' qui' iyaba ca yetsi to' anta' le' región qui' Judea, ą'hua iyaba canu Jerusalén huía cą làti du Juáan para gudà naga' quį qui' bi. Beyuni cą reconocer ca tul·la' qui' quį lani Tata Dios, làniana Juáan nna beni bi cą bautizar le' yò Jordán. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juáan nna guccu' ỹó bi nu de ittsa' ỹó camello, guthi tè lè'e bi ttu cincho nu de yeti. Uccuabàni tèni bi tsua' teruba ttu clase guxaru', ą'hua ỹixi qui' i'yatò'. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Gutixà'a huáni bi cą nna ra bi: Enne' íl·lani bitola de inte' nna, adí la'huacca té quì'e tì'chu inte'; nìdirubani làa dàcca'a' para iyèta'a' cueqquia' ca guarachu yù'u nì'e, porqui'ni née enne' santo. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Inte' nna runia' le bautizar lani inda, pero lèe nna gunie le bautizar lani Espíritu Santo. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tiempo lània nna biria Jesús le' yetsi Nazaret región qui' Galilea. Begàdia tè Juáan ne inda le' yò Jordán. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","De beria Jesús le' indaá nna bilá'nie qui'ni biyàlia ỹiabara' nna huadi Espíritu Santo tì'a ttu becha to' nna bitsine'e iqquie. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Biyeni tení tsi'i ttu enne' gunne de ỹiabara' nna rèe: Lu' nna ná lu' Ỹi'nia', yala catsi'í te' lu'; por lu' nna yala la' redácca'latsi' te quia'. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Làniataá nna guche' Espíritu Sántua Jesús le' desiértuá lá. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nía nna gùdue chua' ubitsa nna chua' yèla nna. Tsè'e huá iỹetse' ca animal tuxu nía. Numalua nna benią ne prueba canchu hua rialànią gunie nu calatsi'į. Bitola nna bitsina' ca ángel nna beni cabi Jesús servir. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Loti' té Juáan litsi' ìyyàa nna, deyya Jesús para Galilea. Nía nna gutixè'e ca titsa' tsè' cubi nu cca qui' la' rigú'ubia' qui' Tata Dios, ");
INSERT INTO zaaNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","rèe: Annana chi bi'yu tsá calatsi' Tata Dios qui'ni ca enne' nna hue'él·la' cą qui'ni quée enne' cu'úbia'nie cą; acca leyàcca arrepentir por ca tul·la' qui' le nna lítsíalatsi' le ca titsa' nu rulue' ti'iỹa modo l·lá le. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Loti' rènie ru'a indatò' qui' Galilea nna, bilá'nie Simón lani bettsi' bi Andrés rudàl·la cabi exxa nu rudàxu'ní cabi bél·la, porqui'ni uccua cabi nu huedàxu' bél·lá. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ra tè Jesús cabi: Lita lani inte', inte' nna gunia' qui'ni ca enne' la guni le pescar. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Betha'na taá cabi ca exxa nna dia tè cabi lani e. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Guttè tí'díbée nía nna bilá'nie Jacóbua lani bettsi' bi Juáan yù'u cabi le' bárcuá lani tàta qui' cabi Zebedéua, reyuni cabi ca exxa nu rudaxu'ní cabi bél·lá. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Gutàỹi tìe cabi. Làcabi nna betha'na taá cabi tàta qui' cabi Zebedéua le' bárcúa lani adí canu tsè'e nía hueni cualani nna, dia tè cabi lani Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bitsina' cabi le' yetsi Capernaum. Ca tsá redi' latsi' ca enne' Israel nna huía Jesús le' sinagoga làti retuppa cą. Nía nna gutixa'ánie cą ca enseñanza tsè' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yala biquila' latsi' quį por ca enseñanza quì'e, porqui'ni adírula tsè' gutixa'ánie cą tì'chu ca maestro nu rulue' nu ra lo ley qui' religión qui' caniá. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Le' sinagoga qui' caniá nna re' ttu nubeyu' ccą padecer por ttu espíritu malo, guduluą gunnią iditsa nna, ");
INSERT INTO zaaNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","rą: Jesús enne' Nazaret, biani té qui' lu' lani intu' acca da' lu' nì. Tsí da' chì lu' para gul·luỹa lu' latsi' tu', áccá. Hua nabia' ba te' lu', ná lu' Enne' Santo guthel·la' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Gutitsa' tè Jesús na nna rèe: Bethia rú'a lu' nna beria lo losto' nubeyu'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Espíritu malua nna becuíbi tsà'tsà'nią nubeyu'a nna, idìtsani gurètsiya'ą, làniana betsè'e latsi'į nubeyu'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Adírulá uccuaỹí latsi' iyábani ca enni'a, acca gunàba titsa' luetsi quį nna ra cą: Biagani nui cá. Biani enseñanza cubi ni nui cá. Nubeyu'į nna té la'huacca quì'į para gunią mandar hàstaá ca espíritu malo, atsi'íni hua runi caso cą qui'į nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Làniana tsàtito'ni gudàa titsa' quì'e ituba región qui' Galilea. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","De beria cabi le' sinagógaá nna huía cabi litsi' Simón nna Andrés nna lani Jacóbua nna Juáan nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Suegra qui' Simón nna té tìą yi'bél·laníą ỹìl·lá. Gutixà'a tèni cabi Jesús qui'ni ra'nią. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Làniana gubígue'e nna bedaxu'e ní'į nna guchìthee na. Luégutaání nna beria chìą ỹìl·láa nna beni tabą́ cabi servir. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Gùl·là diba lània chì' benia taání bitsa nna, tàhua' cą ru'a lúe iyaba canu ra'ni ą'hua canu cca padecer por ca espíritu malo. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Iyábani ca enne' le' yétsiá nna bituppa cą ru'a puértaá. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús nna beyunie iỹétse'ni canu rà'niá télá télá bá ná itsahue' yù'u cą. Ą'hua benie mandado qui'ni beria iỹetse' ca espíritu malo lo losto' ca enne'. Nihua labí be'él·le'e ca espíritua inne cą, porqui'ni benibíá' bá cą nuỹa née. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Attu yu'udílaá hua náru chul·la nna, huatha Jesús nna huíe ttu lugar yà'latsi', nía nna benie oración. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón ą'hua adí ca enne' tsè'e lani bi nía nna beyìla cabi e. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","De betseláni cabi e nna ra cabi e: Iyáỹiani ca enne' reyìla cą cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Lèe nna rèe cabi: Lítsa' adí ca lugar canu anta' exa gáabá para qui'ni guni huáni ya' cą predicar. Porqui'ni para nui la daya'. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Benie predicar le' ca sinagoga qui' ca enne' Israel itúbani Galilea, ą'hua benie mandado qui'ni beria ca espíritu malo lo losto' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Bitsina' tè ttu nubeyu' ra'nią yétsú' yutsu', bedùni ỹibį ru'a lúe nna gutta'yúnią ne nna rą: Canchu hua calatsi' cuią'lu' nna huaccani cuią'lu' eyuni cuią'lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús nna yala betúa latsi'e na, becà tè né'e beláppe'e na ra tìe: Huacca látsa'a', beyacca nàrì. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cuantu taání rèe na anía nna, betua chì itsahue' qui' niá nna beyacca taá latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Làniana bechu titsa' tìe na, pero yala recomendar benie na, ");
INSERT INTO zaaNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","rèe: Bè' cuidado qui'ni nú ttú tè nuỹa quixá'ani lu', sino huía ru'a lo sacerdótea para qui'ni ilá'ni bi lu', bete tè ofrenda qui' lu' tì'a nu beni Moisés mandado muestra de qui'ni chi beyacca nàrì lu', para qui'ni cáỹén latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nubeyu'a nna bedà' dibą nna guduluą bedàą titsa' gutixà'ą iyaba nu uccua. Acca labiru uccua gá'a ga Jesús dàcca'lo taá le' yétsiá, sino adila tsa' bega'na bée fuera làti lanú iỹé enne' tsè'e. Pero siempre dihua huía ca enne' qui' iyábani ca yétsiá ru'a lúe. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tuchùppa ubitsa bitola nna huía Jesús attu le' yetsi Capernaum. Bina tè ca enne' qui'ni rì'e nía. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Làniana bituppa chì nuỹeni ca enne' hasta qui'ni labiru uccuaní cą liú'u, ą'hua ru'a puerta nna bitsa'tí'ní ca enne'. Lèe nna runìnie cą predicar titsa' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bitsina' tè tappa ca nubeyu' nùà'ni cą ttu nu ra'ni parálisis, nidirubani làa cca ttą́. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","De tántuani ca enne' ỹétsi'á nna labí uccua gá'a cą làti dùe, acca huappi cą iqquia yú'u la nna, guthàlia cą liỹia taá làti dùe, guchìda tè cą enne' rà'niá yu'ą́ lè'e camilla. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","De bilá'ni Jesús qui'ni yala fe té qui' quį lani e acca rèe nu rà'niá: Ỹì'nia', chìba beyuniỹén látsa'a' ca tul·la' qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ỹua tení tuchùppa ca maestro de la ley nía nna, liú'u losto' bá quį nna ra cą: ");
INSERT INTO zaaNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Bianicca rena nubeyu'į ą́' ni'i. Ca titsa' mal ba rinnią contra Tata Dios, porqui'ni nuni ccani gunìttiluą ca tul·la' qui' ca enne' canchu álahuá tsuą' teruba Tata Dios cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero Jesús nna gutelí taánie ti'iỹa ná la' rulábalatsi' qui' quį, acca rèe cą: Bianicca rulába latsi' le ą́'. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Biala adí ỹánaba gunia' para nu ra'nią'. Tsí épa' ya' ą: Chìba beyuniỹén látsa'a' ca tul·la' qui' lu', o tsí épa' ya' ą: Beyátha nna bedi' camilla qui' lu'ą' nna gùda' áccá. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pues, para qui'ni ccá le saber qui'ni inte' Nubeyu' de Ỹiabara' té la'huacca quia' le' yétsiloyuį para eyuniỹén látsa'a' ca tul·la', làniana bel·luítse'e nu rà'niá nna, ");
INSERT INTO zaaNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","rèe na: Beyátha nna bedi' camilla qui' lu'ą' nna beyya litsi' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Lą nna beyátha tabą́ nna bedi' tìą camilla qui' niá nna beria ru'a lo iyáỹiani ca enni'a, acca yala biquila' latsi' quį nna bedàliani cą Tata Dios nna ra cą: Nunca labí chi bilá'ni ri'u luetsi nui. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Bitola nna beria Jesús nía nna huía tìe attu ru'a indatù'a. Iyáỹiaba ca enne' nna bitsina' cą ru'a lúe. Lèe nna gutixa'ánie cą ca enseñanza tsè' cubi qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Néda bá yu'ée nna bilá'nie ttu enne' láą Leví ỹi'ni Alfeo rì'ą lo meỹa làti ría ca enne' huiỹa qui' impuesto nu ruquiỹa gobierno. Jesús nna rèe na: Gutà tanó inte'. Lą nna gudulí taą́ nna dia tìą lani e. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Làniana bitsina' Jesús le' yú'u qui' Leví nna guduaníe lo meỹa, tsè'e huá iỹetse' canu ruquiỹa qui' impuesto, ą'hua adí canu dàa titsa' qui' quį runi cą nu labí ná de acuerdo lani ley religiosa qui' ca enne' judíua nna, ỹùàni iyaba cą júntuba lo meỹa lani Jesús nna ca discípulo qui'áa nna, porqui'ni enne' ỹétse'ni denó cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ca maestro de la ley ą'hua adí canu dianó cą religión fariseo nna, de bilá'ni cą qui'ni ro Jesús lani canu riquiỹa qui' impuéstua ą'hua lani adí canu runi tul·la' nna, ra tè cą ca discípulo qui'áa: Bianicca ri'ya ro bá maestro qui' líą' lani canu ruquiỹa qui' impuesto ą'hua lani adí canu tul·la' ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","De biyénini Jesús nui nna rèe cą: Canu bihua ra'ni nna, pues bihua riquina'ni cą médico, sino làteruba canu ra'ni. Labí daya' para gáỹia' canu rulaba latsi' quį qui'ni chi ná cą enne' tsè', sino daya la' para gáỹia' canu tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ttu vuelta loti' ca discípulo qui' Juáan ą'hua ca discípulo qui' ca fariséua nna runi cą ayunar, bitsina' tè tuchùppa ca enne' ru'a lo Jesús nna ra cą ne: Bianicca ca discípulo qui' Juáan ą'hua ca discípulo qui' ca fariséuą' nna runi cą ayunar, atsi'íni ca discípulo qui' cuía'lu'ą' nna bihua rigua tí' cą làa ro cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Becàbini Jesús cą nna rèe: Tsí ína ri'u qui'ni canu tsè'e thá'a guni cą ayunar miéntraste dù ba lani cą nubeyu' ruttsaná'a cá. Pues miéntraste dù nóviua lani cą nna labí guchia cą làa go cą porqui'ni ná tiempo de la' redácca' latsi'. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero canchu i'yu tsá qui'ni ítua ènne'yu'a, lànialá nna guni cą ayunar. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Lanú nuỹa regú'u remiendo ttu vestido viejo lani ttu pedazo lari' cubi, porqui'ni la'a mísmuba remiendo cúbía nna ichèda'ą lari' viéjuá, entonces adila iyàl·la' làti chi birèda'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nihua lanu nuỹa rigá'a vino cubi le' ca bolsa vieja nu de yéti, porqui'ni por fuerza qui' vino cúbía nna itsu' lą́ ca bolsa yétiá nna ilàlia vínuá, ą'hua yétiá nna labiru íỹu'ą. Acca ná qui'ni vino cúbía nna ità'ą le' yéti cubi. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ttu tsá sábadua nna guttè Jesús làti té ỹua'. Ca discípulo qui'áa nna hua dia cànna ba cabi guduló cabi guchèccu' cabi tuchùppa ỹua'. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Làniana ca fariséua nna ra tè cą Jesús: Gunna' tsáruhua, bianicca runi ca discípulo qui' lu'ą' nu labí ná qui'ni guni ttu enne' tsá redi' latsi' ri'u ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero Jesús nna rèe cą: Tsí núncahua ni' gul·la le biỹa beni rey David loti' labí biỹa té go bía nna yala gutùni bi ą'hua canu tsè'e lani bía cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Gutà'a David le' templo qui' Tata Dios loti' Abiatar ną́ huexána' qui' ca sacerdótea nna gutò bi ettaxtíla nu ná ofrenda para Tata Dios, ettaxtíla nu lanu nuỹa dànią gúą na sino làteruba ca sacerdótea. Atsi'íni hàstaá canu tsè'e lani bía nna bete huá bi gutò cą, pero bihua beni Tata Dios bi juzgar qui'ni ną́ tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús nna raáruhuée cą: Beni Tata Dios tsá redi' latsi' ri'u para bien qui' ri'u, alàa benie ca enne' por causa de tsá redi' latsi' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Acca Nubeyu' de Ỹiabara' nna née Señor qui' iyaba ca tsá ą'hua tsá para edi' latsi' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Attu vuelta gutà'a Jesús le' sinagógaá. Nía nna re' ttu nubeyu' nu gubitsi yà'aba ná' bànį. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ca fariséua nna betsia tsìttsì chìni lo quį ne canchu hueyunie na tsá redi' latsi' quį, para qui'ni gappa cą néda biỹa caúsani gutsia cą quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús nna rèe nubeyu' nu gubitsi yà'aba ná' niá: Lu' nna gùduli nna gùdu làhui'. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Làniana rèe cą: Tsí hua ná qui'ni guni ri'u tsè' ca tsá redi'latsi' ri'u, o tsí guni la ri'u mal áccá. Tsí hua ná qui'ni eyuni ri'u ttu enne' màsqui'ba ná tsá redi' latsi' ri'u, o tsí hue'él·la' bá ri'u ą gattią áccá. Pero làcą nna tsi diruba gutsé'e cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Làniana gunne'e iyaba cą lani dí'latsi' nna yala triste uccuanie porqui'ni labí uccua latsi' quį télini cą quì'e, acca ra tìe nubeyu'a: Bèl·lìi ná' lu'. Lą nna bèl·lìi taá ní'į, làniana tì'a viva beyacca chì ná' niá. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Beria bá ca fariséua nna bè' cą titsa' lani canu gulátsi partido láą herodiános contra lèe ti'iỹala modo gudaxu' cą ne preso nna gutti cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pero Jesús nna dia tìe ru'a indatù'a la lani ca discípulo qui'áa. Tanó tehuá ca enne' ỹétse'ni qui' Galilea ne, ą'hua ca enne' Judea nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ą'hua iỹétse'ni ca enne' Jerusalén nna ca enne' Idumea l·le, canu attu lado la yò Jordán l·le, ą'hua ca enne' biria le' ca yetsi Tiro nna Sidón nna, de bina cą qui'ni ca milagro ỹénini runie nna acca bituppa tè cą ru'a lúe. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ra tìe ca discípulo qui'áa qui'ni gúdu cabi bárcuá prevenido taá para qui'ni làa uquìni ca enne' ỹétse' niá ne. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Por tántua ca enne' chi beyunie nna, acca iyábani canu ra'ni nna ritìl·lani cą para gulappa' cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","De bilá'ni ca espíritu malo ne nna bedu ỹibi quį ru'a lúe nna guretsi ya'a cą nna ra cą: Cuią'lu' nuą' ná Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero lèe nna idí'tse' gunnènie cą qui'ni nú ttu tehuá nuỹa quixá'ani cą qui'ni lèe Enni'a Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Bitola nna huappi Jesús lo i'yaá, làniana becuí'e tuchùppa ca enne' nna gutaỹie cabi. Làcabi nna bitsina' tè cabi ru'a lúe. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Benie formar ttu grupo lani tsì'nu ca enni'a para qui'ni tsé'e cabi lani e tulidàba, ą'hua para ithel·le'e cabi hueni predicar evangelio. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Bete huée la'huacca qui' cabi para eyúnini cabi iyábani itsahue', ą'hua para ebeqquia cabi ca espíritu malo lo losto' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Simón enne' gutixa huée lá bi Pedro; ");
INSERT INTO zaaNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ą'hua Jacobo ỹi'ni Zebedeo lani Juan bettsi' Jacóbua ca enne' gutixa huée lá cabi ỹi'ni nu rinne idìtsani tì'a ídiu'; ");
INSERT INTO zaaNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ą'hua Andrés nna Felipe nna Bartolomé nna Mateo nna Tomás nna Jacobo ỹi'ni Alfeo nna, ą'hua Tadeo nna Simón enne' gulátsi' partido láą cananístas nna, ");
INSERT INTO zaaNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote nu betią ne cuéntaá para gattie nna. Làniana deyya cabi le' yú'u. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Attu vuelta nna bituppa ca enne' ỹétse'ni hàstaá para go cabi labí gùppa cabi néda. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","De bina ca pariente qui'áa nna huía cą para eche' cą ne, porqui'ni ra ca enne' chi ribèqquiaỹíą la' riyeni quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ą'hua ca maestro de la ley canu da' de Jerusalén nna rena cą qui'ni Beelzebú nu ná huexána' qui' ca espíritu máluba du lani Jesús. Ra huá cą qui'ni por la'huacca qui' Beelzebú nna runi Jesús mandado reria ca espíritu maluą' lo losto' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Làniana bel·luítse'e ca maestro de la ley nna gutixa'ánie cą ttu comparación nna rèe: Labí gudal·la Satanás fuera ca huenitsìna quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Canchu nuỹa ttu gobierno lá'aní la' rigú'ubia' quì'į nna entonces labí itsáagá cuí'ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ą'hua canchu lá'aní ttu familia por biỹa ca disgústoni nna, entonces labí itsáagá gúchią. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Pues adítelá canchu Satanás chathą para til·lą contra là'a labíį, entonces labí itsá cuí'ą, sino qui'ni l·luỹa tabá latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Lanú nuỹa irialàni gá'ą le' litsi' ttu nubeyu' valiente canchu álahuá gudaxu' ỹą́ na guxiqquią na, lànialá nna hua rialànią cueqquią iyate nu té le' litsi' enni'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Hualigani te' riquixa'ánia' le qui'ni iyábani ca tul·la' nu runi ca enne' nna eyuniỹén bá latsi' Tata Dios qui' quį, ą'hua iyábani ca titsa' mal biỹa tediba cláseni ná cą nna tehua perdón qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero nuỹa tediba runią despreciar nu runi Espíritu Santo nna, jamás labiru eyuniỹén latsi' Tata Dios quì'į, sino qui'ni chi ną́ culpable para siempre. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Anía rèe porqui'ni làcą nna gunne cą quì'e qui'ni dua ttu espíritu malo lo lostu'e. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Bitola nna bitsina' ca bettsi' áa ą'hua nàna qui'áa ribeda cabí fuera, guthel·la' cabi mandado tul·luítsa' cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ca enne' ỹua luítti' áa nna ra cą ne: Nàna qui' cuíą'lu'a ą'hua ca bettsi' cuíą'lu'a tsè'e cabi fuera nna reyila cabi cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Becàbinie cą nna rèe: Nuni nua' ná nàna quia' nna ca bettsi'à' nna cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Làniana gunna' tìe ca enne' ỹua ìta'lubáníe nna ra tìe: Nìba tsè'e ca bettsi'à' nna nàna quia' nna, ");
INSERT INTO zaaNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","porqui'ni nuỹa tediba runi nu rú'u latsi' Tata Dios, pues làcanuá nna ná cą bettsi'à' nna dána'a' nna nàna quia' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Attu vuelta nna gudulo Jesús gutixè'e ca enseñanza tsè' qui' Tata Dios nna bitùppa ca enne' ỹetse' ìta'lubáníe. De tántuani ca enni'a nna gutè'e le' ttu barco duą ru'a indatù'a nna gùdua tènie; iyábani ca enni'a nna tsè'e cą loyu bitsi ru'a indatù'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesús nna gutixa'ánie cą iỹetse' ca enseñanza por medio de ca comparación nu cca qui' yétsiloyuį nna ỹiabara' nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Liudaáruhuá naga' le ca titsa' quíyi'į: Ttu campesino nna dią huadàl·la ỹua'. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","De rudal·lą ỹú'a nna bitsina' tí' ỹua' qui' niá cuitta' néda, huadi tè ca bìnni to' nna bediga' cą na. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ati' ỹú'a nna bitsina'ą le' íyyarrúe làti labí tegá guna' re'. Acca tsastitaá gul·lanią porqui'ni labí itettia ga re' guna'. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero de gul·lani bitsa nna bequèxu' taą́ ỹú'a porqui'ni labí dia l·lúį itettia, acca gubitsi taą́. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ati' ỹú'a nna binnią làti yù'u huá l·lú ca yèttse'. Ca yèttsi'a nna gul·lani tehuá cą nna bedibàga' taá cą lo ỹú'a, acca ỹú'a nna labí benną lènà'. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero ati' ỹú'a nna bitsina'ą le' loyu bèbè. Nía nna gul·lanią nna biỹenią nna benna tìą lènà' nu guyú'u lì'į tsìi érua' nna, nu benna bá gayùna' nna, nu benna ba gayua' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Làniana rèe cą: Nu calatsi' ídete' nna, pues gudà tsè' nagui'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Loti' re' ttubée nna gubiga' tè tuchùppa ca enne' tsè'e nía lani ca enne' tsì'nua nna gunàba titsa' cabi e de nu cca qui' ejémplua. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Lèe nna rèe cabi: Lebi'i nna hua ná qui'ni ccá le saber clárutaá ca enseñanza nu cca qui' reino qui' Tata Dios, ca cosa nu labí chi yù ca enne' antes. Pero canu labí lání cą ri'u nna, entonces puro lani comparación bá riquixa'áni ya' cą; ");
INSERT INTO zaaNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","para qui'ni ccá cą tì'a canu rinna' ccą pero labí edácca'ni cą màsqui'ba iyénini cą pero labí biỹa télini cą nna, labí eyeqquia cą lani Tata Dios para eyuniỹén latsi'e ca tul·la' qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Làniana rèe cą: Tsí bihua nì' télini le enseñanza acerca de comparación nu gutixà'a ya'a cá. Ti'ala modo télini le adí ca comparación nu quixa'ánia' le ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Enne' bedàl·la ỹú'a nna runią comparar ttu enne' riquixá'a titsa' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ttu te ca enne' nna ná cą tì'a ỹua' nu binnia cuitta' nédaá nna bediga' ca bìnni tú'a na. Porqui'ni de riyénini cą ca titsa' qui' Tata Dios nna, ril·lani taá Satanás nna rigua taą́ ca titsa' nu chi biyàda lo losto' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Attu te ca enne' nna ná cą tì'a ỹua' nu binnia le' íyyarrúea nna tsati taá gul·lanią, porqui'ni de riyénini cą titsa' qui' Tata Dios nna yala lani gusto rudà naga' quį, ");
INSERT INTO zaaNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","pero labí tsìttsì ga'na fe qui' quį, acca tito' rúbá ruchia cą. Canchu chi ril·lani ca prueba nna rutsia latsi' ca enne' cą porqui'ni ríalatsi' quį ca titsa' qui' Tata Dios nna, luégutaá redúl·la'a latsi' quį nna ccá taá cą apartar. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Attu te ca enne' nna ná cą tì'a ỹua' nu binnia le' yèttse' nu gul·lani xìą nna bethàga' taą́ lo ỹú'a. Porqui'ni de riyénini cą titsa' qui' Tata Dios, ");
INSERT INTO zaaNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","yala nùyue cani cą por ca cosa qui' yétsiloyuį, ą'hua ridacca'ỹí taá cą porqui'ni ridà latsi' quį bel·liu nna bíỹaáru ca cosa material nna. Iyaba ca nui nna ruthàga' taá cą tsina nu runi ca tìtsi'į lo losto' quį, làniana labiru runi cą nu rú'ulatsi' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ą'hua attu te ca enne' nna runi cą comparar tì'a ỹua' nu binnia le' loyu bèbèa: ttuą nna benną tsìi érua', attuą nna benną gayùna', attuą nna gayua'. Ą'tení ná ca enne' de riyénini cą titsa' qui' Tata Dios, ríalatsi' quį nna runi tè cą nu rú'ulatsi'e según ti'iỹa ná bá capacidad nu te qui' ttu ttu quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Raáruhuée cabi: Tsí hua rugàl·la' ri'u ttu yí' nna rutòthe' tè ri'u ttu cajón lúį, o rudua ri'u ą ỹarèe' lònà cá. Tsí álahuá ną́ para gudua ri'u ą ttu lugar làti gudàni'ą itúỹiani le' yú'u. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Porqui'ni labí biỹa nu gattsi' ní té sin qui'ni làa ilá'níą, nihua biỹa ca enseñanza nu gattsi' ní té sin qui'ni làa iyàtsilà'ną ru'a lo iyaba ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nu calatsi' ídete' nna, pues gudà tsè' nagui'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ra huée cabi: Líútsia tsè' cuidado nu riyénini le; porqui'ni canchu labí gudà tsè' naga' le nna, tito' rúbá la' ritelíni gata' qui' le. Pero lebi'į canu calatsi' ídete' le nna, adítelá tsani la' ritelíni qui' le porqui'ni rutsia tsè' le cuidado nu riyénini le. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Porqui'ni nuỹa tediba té la' ritelini quì'į nna, lą nna thí' lą́ adí, canchu hua runią seguir ríalatsi'į. Pero nu labí té quì'į nna, pues hàstaá tito' nu rulaba latsi'į qui'ni té quì'į nna, ítua telą́. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Raáruhuée: Reino qui' Tata Dios nna náą tì'a nu cca canchu chi ttu campesino rudàl·lą ỹua' le' ttu loyu. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ra'áthi bą́ nna, aníabá runią ritte ca tsá, miéntraste semilla tú'a nna reyattsą nna ril·lanią nna riỹeni huą́ nna; pero nubeyu'a nna nidí làa yùą ti'iỹala modo cca ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Porqui'ni por lóyúa nna reyattsa ỹua' tú'a; primérute de ril·lanią ną́ ttu ixxi' to' teruba, laniana ril·lani èttse' quì'į, pero bitola nna ru'u ỹua' to' lì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Canchu chi rigattsią nna reruą lani ìyyà sela, porqui'ni chi bi'yu tsá gutuppą lènà'. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Raáruhuée: Biani tì' ná reino qui' Tata Dios. Biani guni ri'u ą comparar cá, pues quixa'ánia' le. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ną́ tì'a ttu bétsi' to' qui' cuana, porqui'ni canchu chi riyadą le' loyu nna adí telání xcuichuto' ną́ de lo iyaba ca semilla nu té le' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero ril·lani díbą́ nna riỹenią adiru de lo iyaba ca planta nna, yáỹipà'ni riduą hàstaá qui'ni ca bìnni to' nna riỹua cą le' ỹula quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Lani iỹetse' ca comparación tì'a ca nua' nna gutixa'ánie cą titsa' qui' Tata Dios, ti'iỹa tébá la' riyeni qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tulidàba gutixa'ánie ca enne' por medio de ca comparación, pero iyábani bethàtsi là'nànie ca discípulo qui'áa yà'ba latsi'. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Gùl·là diba tsá lània nna rèe ca discípulo qui'áa: Lítsa' attu ládua'la. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bechu titsa' díbée ca enne' ỹétsi'á, làniana ca discípulo qui'áa nna guche' cabi Jesús attu lado indatù'a la le' barco nu yù'uéa taá. Dia hua adí ca barco to' lani barco nu yù'u Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Lo indatù'a bá dàa cabi nna huatha ttu iyyabe' fuérteni, chi rà'a inda le' bárcuá hàstaá qui'ni chì' taá ritsa'ą inda. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús nna ti'éthibée, ỹua iqquie lo ttu xconi dacca' cuè'e la bárcuá. Ca discípulo qui'áa nna bedibàni tè cabi e nna ra cabi e: Maestro, tsí bihua nùyue du cuią'lu' qui'ni chi rinetsi ri'u le' indį. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Làniana huatha Jesús nna gutìtse'e be'a nna indatù'a nna rèe: Tsi bá, tsi tè. Làniana gudutsi tabá be'a. Indatù'a nna beyatta' tsi tabą́. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesús nna ra tìe cabi: Biecca yala rátsini le ni'i. Tsí bihua ríalatsi' le qui'ni té la'huacca quia' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Làniana adila la' rátsilatsi' bitsina' lo losto' cabi nna ra luetsi cabi: Nugani enni'į, acca hàstaba be' nna indatù'į nna riyénini cą quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bitsina' tè cabi attu lado qui' indatò' Galilea región qui' ca enne' gadarenos. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","De beria Jesús le' bárcuá nna bitsina' tè ttu nubeyu' ru'a lúe berią le' ttu bèlìà nu dua le' panteón nía. Nubeyu'a nna ccą padecer por ttu espíritu malo. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Lą nna gùduą làti rigattsi' canu yatti, lanú nuỹa ririalàni uỹìqquią na tsìttsì nihua lani cadena. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Porqui'ni iỹé vuelta tsè' chi beỹìqquia cą nì'a ní'į lani cadena, pero tsàstiní richuą cą. Acca lanu nuỹa ridàa lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tulidàba ribènią réla ritsá ba ribétsiya'ą lo ca i'ya nna le' panteón nna, la'a làbą nna rue' látį lani ca íyyá nna richu cą látį. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Idittu' nna bilá'nią Jesús, bigàa chìą tattsa'ą ne nna beduỹibį ru'a lúe. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Gunne tìą iditsa nna rą ne: Jesús Ỹi'ni Tata Dios Tsuna', bianicca da' cuią'lu' nì, ratta'yúnia' lu' qui'ni guni lu' jurar nna gudu lu' por testigo Tata Dios qui'ni bittu guni lu' inte' castigar. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Anía rą porqui'ni gunne Jesús nna rèe na: Lu' espíritu malo, beria lo losto' nubeyu'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Gunàba titsa' tìe espíritu malua nna rèe: Lu' nna gutixa'áni inte' biỹa lá lu'. Becàbią nna rą: Batallón lá', porqui'ni nuỹé tsè'ni tu' ná. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Làniana yala gutta'yúnią ne qui'ni bittu ithel·le'e na fuera distrítua. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Exa gáabá nía nna tsè'e tè iỹétse'ní ca cuttsi huila go cuitta' i'yaá. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Iyaba ca espíritu malua nna gutta'yú teni cą Jesús nna ra cą ne: Guthel·la' intu' làti tsè'e ca cùttsią' para tsú'u tu' lo losto' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús nna bete tìe permiso qui' quį. Làniana ca espíritu malua nna betsè'e latsi' quį nubeyu'a nna gutà'a cą lani ca cùttsia. Hua ná ttú chuppa mili' ti'gá ca cùttsia. Iyaba cą nna uccua litsiani cą nna gutùl·lu cą lo ttu iyyatò' nna binnia cą le' inda nna gùttì cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Canu rappa ca cùttsia nna beyya cą quèthani táquixá'ani cą ca enne' le' yétsiá ą'hua ca rancho tú'a. Biria chì ca enne' dia cą tanna' cą biỹa nuá uccua. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bitsina' cą làti du Jesús lani nubeyu' loco nu uccua padecer por iỹetse' ca espíritu malua nna, bilá'ni cą qui'ni nìya'atsùbani rì'ą chi naccu' ỹúį nna, acca yala gutsini cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Canu bilá'nia nna gutixa'a cą ti'iỹa ná nu uccua lani nubeyu' guyú'u espíritu malo lo losto' niá, ą'hua nu uccua lani ca cùttsia nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Acca gutta'yúni cą Jesús qui'ni eria bée látsi caniá. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Loti' díe éye'e le' bárcuá nna, nu uccua padecer por espíritu malua nna gutta'yúnią ne qui'ni hue'él·le'e na cuenią lani e. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero Jesús nna labí be'él·le'e na sino qui'ni rèe na: Beyya litsi' lu' làti tsè'e ca enne' qui' lu'a, gutixa'áni cą ti'iỹa ná ca cosa ỹeni nu chi beni Señor lani lu', ą'hua ti'iỹa chi betúa latsi'e lu' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nubeyu'a nna deyyą guduluą rudàą titsa' le' ituba región qui' tsìi ca yétsiá riquixá'ą ti'iỹa ná ca milagro nu chi beni Jesús lani ą. Iyaba canu biyénini testimonio quì'į nna yala biquíla' latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Bettè bá Jesús attu vuelta le' ttu barco para attu ládula indatù'a nna, bituppa tè iỹé mili' tsè'ni ca enne' ru'a lúe. Lèe nna du bée ru'a indatù'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bitsina' tè Jairo, nubeyu' principal qui' sinagógaá. Bilá' bánią Jesús nna bedu taá ỹibį ru'a lúe. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yala gutta'yúnią ne nna rą: Chì' tení ratti ỹi'ni niula to' ya'a, tsí hua dá' bála cuią'lu' gutsia ná' cuią'lu' iqquį para qui'ni eyacca latsi'į nna ccabànią. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dia tè Jesús lani ą nna. Denó tehuá enne' ỹétse'ni Jesús nna rùquini cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Dia hua nía ttu niula nu chi uccua tsì'nu ida ra'nią rilàlią réni. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yala remedio chi beni ca médico na, chi benittiluą iyate nu té quì'į pero labí reyacca latsi'į, sino adila riyal·la' lánią. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Chì biną qui'ni Jesús runie ca milagro, acca huía tìą cuè'e lée lahui' ca enne' ỹétsi'á nna belappa'ą ỹúe, ");
INSERT INTO zaaNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","porqui'ni uccuanią: Canchu guláppa'a' màsqui'di ỹúe nna eyacca taá látsa'a'. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Làniataá nna guru réni qui' niá, gutebé' taánią qui'ni chi beyacca latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Luégutaá gutebé'ni Jesús qui'ni beyunie nuỹa ttu enne' lani la'huacca quì'e, acca bedeqquia tè lúe gunne'e ca enne' da' cuè'e lée nna rèe: Nuni nua' belappa'ą ỹó yì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ca discípulo qui'áa nna ra cabi e: Hua rilá' báni cuią'lu' qui'ni ca enne' ỹetse' ruquini cą cuią'lu', atsi'íni ra cuią'lu': Nuni nua' belappa'ą inte' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero lèe nna gunne'e ìta'lubáníe nuỹa nuá belappa'ą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Niuláa nna yala gutsinią nna biỹiti'níą nna porqui'ni bennią cuenta nu chi uccua lani ą, acca gubiga'ą nna beduỹíbį ru'a lúe, gutixa'ánią ne nu benią. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús nna bechu tìtse'e niuláa nna rèe: Ỹì'nia', por fe nu té qui' lu' lani inte' nna chi ná lu' salvo; bíttuúru biỹa cani lu', porqui'ni dèsdeba anna chi beyacca latsi' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Atsabá rinne Jesús nna gul·lani mandado da' cą litsi' nubeyu' principal qui' sinagógaá nna ra cą: Chi gùttì ỹi'ni cuíą'lu'a, biáruá liecca uquitsí' rùnì cuią'lu' Maestruą'. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero biyeni taáni Jesús nu ra canaá, acca ra tìe nubeyu' principal qui' sinagógaá: Bittu gátsini lu', huía teruba latsi' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesús nna labí uccua latsi'e qui'ni núỹaáru tsía lànią ne sino làteruba Pedrua nna Jacóbua ą'hua Juáan bettsi' Jacóbua. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bitsine'e litsi' nubeyu' principal qui' sinagógaá nna bilá'nie qui'ni iỹétse'ni ca enne' chi tùppa, ttu te ccą nna yala lani la' rehuini' latsi' tsè'e cą pero attu te cą nna tsè'e cą huìl·là. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Gutà'a tìe nna rèe cą: Bianicca tanto alboroto runi le nna ribetsi le ni'i. Niula cuìti'į nna bihua ną́ nu yatti, sino ti'éthibą́. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","De biyénini cą nu reáa nna, burla la beni ccą ne. Làniana benie mandado qui'ni iria iyaba ca enne' nna gutaỹi tìe tàta nàna qui' niula cuìti'a ą'hua tsùnna canu dia cą lani áa, gutà'a tìe làti té niula cuìti'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Gutèl·le'e ná' niula cuìti'a nna rèe na: Talita cumi. Titsa' quì'ba ri'u nna rą: Niula to', inte' nia' lu', beyátha. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Luegu taání nna beyatha chì niula cuìti'a nna reda' chìą. Chi yu'ą́ tsì'nu ida ti'gá. Ca enne' tsè'e nía nna caligálání tsíá cą uccuani cą de tántua gutsini cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero Jesús nna gunnènie cą qui'ni nú ttu tehuá nuỹa quixá'ani cą, làniana beni tìe mandado qui'ni gute cą nu go niula cuìti'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Bedà' tè Jesús nía nna betsine'e látsi áa. Dia tè ca discípulo qui'áa lani e. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Níabá tsè'e cabi gùl·la' tsá redi' latsi' ca enne' judíua nna, guduló Jesús gutixa'ánie le' sinagógaá titsa' qui' Tata Dios. Iỹetse' canu biyénini cą enseñanza qui'áa nna yala biquíla' latsi' quį nna ra cą: Gala bethete' nui ca cosį cá. Ti'iỹa modo acca tanto tsè' chi nabia'nią hàstaá para gunią ca milágruą' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tsí álahuá nui nua' carpintéruá ỹi'ni María, bettsi' Jacóbua nna Joséa nna Judas nna Simóon nna cá. Tsí álahuá nìba tsè'e ca danį lani ri'u cá. Por nui nna labí huíalatsi' quį qui'ni née Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pero Jesús nna rèe cą: Ttu profeta, gaỹa tediba rappa cą na titsa', pero canu látsį nna ca pariente quì'į nna nìdi caso làa runi cą quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Acca labí iỹéegá milagro benie nía, sino tuchùppa teruba ca enne' nna betsia né'e iqquia quį nna beyunie cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Lèe nna yala uccuaỹí latsi'e porqui'ni labí huíalatsi' quį ne. Làniana gurenie le' ca yetsi to' canu anta' nía, gutixa'ánie ca enne' ca enseñanza tsè' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Bitola nna gutaỹi Jesús ca enne' tsì'nua, gudulúe guthel·le'e chuppa chuppa cabi nna betie la'huacca qui' cabi sobre ca espíritu malo para qui'ni eria cą fuera. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Benie mandado qui'ni bittu biỹa huá' cabi de tsù'u cabi néda, sino ttu yà to'. Ra huée qui'ni bittu huá' cabi morral nihua ettaxtíla, nihua bittu bel·liu cu'ú le' bolsa qui' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Dàni cabi gúl·lia cabi guarachu sencíllotó' taá, pero bittu gaccu' cabi chuppa cua' lári'. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Raáru huée cabi: Gaỹa diba gá'a le le' ttu yú'u nna, nía bá ccá lugar qui' le hàsta'na gal·la' tsá eda' le le' yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nuỹa ttu lugar làti bihua recibir guni cą le nihua làa gudà naga' quį qui' le, entonces eria le nía nna gucuíbi tè bestè nì'a le, ttu seña para télini cą qui'ni labí tsè' beni cą. Hualigani te' riquixa'ánia' le qui'ni adila fuerte cca la' tsìalatsi' qui' Tata Dios nu chì' da'la lani yétsiá tì'chula juicio nu uccua lani ca yetsi Sodoma nna Gomorra nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ca discípulo qui'áa nna guda' tè cabi nna guduló cabi hueni predicar qui'ni ca enne' nna dàni cą ehuiní'ni cą nna gútse'e latsi' quį ca tul·la' qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Beni cabi mandado ca espíritu malo qui'ni eria cą lo losto' ca enne' nna beyacca latsi' quį. Ą'hua bedua cabí aceite iqquia nuỹetse' canu ra'ni nna, beyacca latsi' quį por la'huacca nu betie lani cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Bina tè rey Herodes iyaba nu cca qui' Jesús, porqui'ni chi gùthilàlia ba titsa' quì'e le' ttu ttu yetsi. Acca ra Herodes: Juan el Bautista nu béttí ya'a, pues lą nua' chi beyathą de lo lù'uti acca té iỹeni la'huacca quì'į nna runią ca milágruą'. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Adí cą ra cą: Elías nuą'. Attu te cą nna ra cą: Ttu nu rinne parte Tata Dios nuą' ti'a beni ca profeta gutsé'e ttu cuaỹa nuá. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","De bina Herodes nu ra ca enni'a nna, acca ra tìą: Juan nu benia' mandado ichu cą yáni niá, pues lą nua' chi beyathą de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Porqui'ni la'a mísmuba Herodes nna benią mandado qui'ni gudaxu' cą Juáan preso nna bexìqquia cą bi lani cadena nna bedàl·la cą bi litsi' iyya. Anía beni Herodes porqui'ni de guỹi'ą Herodías niula qui' bettsi'į Felípea, ");
INSERT INTO zaaNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juáan nna ra tè bi ą: Labí ná qui'ni thí' lu' la'a niula qui' bettsi' lu'ą' bá. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Acca Herodías nna yala beyudí'ą Juáan, uccua latsi'į guttią bi. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Pero rey Herodes nna gùppa bą́ Juáan respeto porqui'ni biénba yùą qui'ni yala exa gudu bi lani Tata Dios, ą'hua labí biỹa tul·la' beni bi nna, acca bè' bą́ bi cuidado qui'ni nú ttu nuỹa biỹa gudácca'ą bi. Ą'hua màsqui'ba labí gutelí gánią bícca'áỹa nuá gutixa'a bi, pero yala guyú'u latsi'į gudà nagui'į qui' bi. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero loti' gùl·la' cumpleaños qui' Herodes nna betseláni Herodías ttu opportunidad, porqui'ni beni Herodes ttu fiesta nna gutàỹią canu re' cuenta nna ca capitán nna ą'hua adí canu dacca' qui' Galilea go se' quį lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Gutà'a tè niula cuiti' ỹi'ni Herodías le' yú'u làti cca fiéstaá nna beyà'a ttùbą lahui' quį. Herodes lani canu ỹuàni cą lo meỹa lani ą nna yala guyú'u latsi' quį. Acca ra rey Herodes niula cuìti'a: Gunàbani inte' biỹa tediba calatsi' lu', inte' nna gunna ya' ą qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Làniana beni Herodes prometer lani juramento nna rą: Biỹa tediba inàbani lu' inte' nna gunna ya' ą qui' lu' hàstaba tsal·lue' la' rigú'ubia' quia' canchu calatsi' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Niula cuìti'a nna biria tìą nna rą nàna qui' niá: Biani inába'a'. Nàna qui' niá nna rą na: Iqquia Juan el Bautístą'. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Làniana quèthani beyeqquią làti dua rey nna rą: Calátsa'a' qui'ni anna tení gunna lu' quia' le' ttu plato iqquia Juan el Bautístą'. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Rey Herodes nna yala behuiní'nią, pero por causa de qui'ni chìla benią jurar, ą'hua labí uccua latsi'į itìniyúą lani canu ỹua lo meỹa lani ą, acca labí uccua latsi'į gutsibią niula cuìti'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Luégutaá nna guthel·la'ą ttu soldado táchuą yáni Juaan eyua' tìą iqquia bía. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Huía tè soldadua le' litsi' ìyyàa nna guchuą yáni Juáan, denua' tìą na le' ttu plato, betią na lani niula cuìti'a. Niula cuìti'a nna betią na lani nàna qui' niá. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","De bina ca discípulo qui' Juáan nu uccua nna, huía tè cabi taỹi' cabi cuerpo qui' bía nna becattsi' cabi bi le' ttu yerubà. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Làniana ca tsì'nu discípuluá canu guthel·la' Jesús, betsina' cabi ru'a lúe nna gutixa'áni cabi e iyate nu chi beni cabi, ą'hua iyaba ca enseñanza nu gutixa'a cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lèe nna rèe cabi: Lità tsía ri'u para edi' tí' latsi' ri'u ttu lugar yà'latsi'. Anía rèe porqui'ni ca enne' ỹetse' nu reda' nu ritsina' bá cą ru'a lúe nìdirubani làa rappa cabí neda para go cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Acca dia tè tsua' làteruba cabi le' ttu barco para ttu lugar yà'latsi'. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero iỹétse'ni ca enne' nna bilá'ni cą dia cabi le' bárcuá nna bedacca' huáni cą Jesús. Acca nuỹetse' cą guda' cą le' ca yetsi qui' quį nna dia tè cą lani nì'a bá quį tsàru'a indatù'a bá nna. Yà'lalá làcą bitsina' attu ládua. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","De beria Jesús le' bárcuá, bilá'nie qui'ni enne' ỹétse'ni tsè'e chì nía ribeda cą ne nna, yala betúa latsi'e cą porqui'ni ná cą tì'a ca carneru to' nu lanú pastor qui' quį té. Làniana gudulúe gutixa'ánie cą iỹetse' ca enseñanza nu cca qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","De chi da' ràl·làa nna gubiga' ca discípulo qui' Jesús ru'a lúe nna ra cabi e: Chi ral·la nna ą'hua làti tsè'e rí'uį nna ga'ną fuera yetsi. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Acca bechu titsa' dí cuią'lu' ca enne' para qui'ni tsía cą le' ca rancho to' ą'hua ca yetsi to' canu anta' ìta'lubá nna para gó'o cą ettaxtíla, porqui'ni nì nna labí té biỹa go cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Becàbi Jesús nna rèe cabi: Lebi'i ba líúte go cą. Làcabi nna ra cabi e: Tsí ína ri'u huaccani lani chuppa gayua' denario bel·liu nna tsá' tu' gó'o tu' ettaxtíla suficiente para úgo tu' ca enne' ỹétsi'į cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús nna rèe cabi: Bàl·lacà'a ettaxtíla dèni le, lítsía tsánna líúyu bàl·la ỹa té nná. Belaba tè cabi nna ra cabi e: Gayu' ettaxtíla, chuppa bél·la to' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Làniana beni e mandado qui'ni xuani iyaba ca enni'a lo tácca'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Guỹua tení cą nía por fila nna, tsieyóna' o gayua' ca enne' ttu ttu fila. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Làniana guỹi'e gayu' ettaxtílaá nna chuppa ca bél·la tú'a nna guchìtha lúe gunne'e ỹiabara' nna gunàbèe bendición lani Tata Dios. Làniana gùl·le'ée ca ettaxtílaá nna bete tìe lani ca discípuluá para qui'ni quithia cabi lani ca enni'a. Ą'hua gutìthia tehuée chuppa ca bél·la tú'a entre iyaba cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Iyáỹiate cą nna gutò cą ti'iỹa bá uccuaní qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Làniana betùppa cabi atsì'nu tsummi thú tsà'ti'ni ca pedazo ettaxtila canu béxaá, aníahua ca bél·la tú'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Entre iyaba canu gutúa nna hua ná gayu' mili' tì'ga ca nubeyu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bitola nna ra Jesús ca discípulo qui'áa qui'ni éya'a cabi le' bárcuá nna enèru bétsi cabí para Betsaida ttu yetsi rì'ą attu lado qui' indatù'a, miéntraste lèe nna rechu tìtse'e ca enne' ỹétsi'á. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bechu titsa' díbée ca enni'a nna huía tìe lo ttu i'ya. Nía nna benie oración. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","De bichul·la tsè' nna chi dia bárcuá lahui' indatù'a, Jesús nna turúbée du yúbitsi. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Bilá'nie cabi qui'ni yala ridacca' cabi rutha' cabi bárcuá porqui'ni contra lá cabi du bè'a. Chì' tegáabá da' rànì'a nna dia tè Jesús ride'e lo indatù'a uccua latsi'e tté tabée lo cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero de bilá'ni cabi e ride'e lo indaá nna uccuani cabi qui'ni née ttu nu tsáyela, acca guretsi yà'àni cabi de tántua tsanì' uccuani cabí. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yala gutsini iyaba cabi. Pero bel·luítsa' taá Jesús cabi nna rèe: Ligappa confianza, inte' ba nui, bittu gátsini le. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Gutà'a díbée le' barco làti yù'u cabía nna gudu tsi taá bè'a. Ca discípuluá nna yala biquíla' yà'àni latsi' cabi, ");
INSERT INTO zaaNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","porqui'ni labí chi gutelí tsè'ni cabi acerca de milagro nu beni Jesús lani ca ettaxtílaá; pues àtsaba re'nią chul·la le' la' riyeni qui' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","De beyacca guttè cabi lo indatù'a nna bitsina' cabi región nu lá Genesaret. Nía nna bexìqquia cabi bárcuá ru'a indatù'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Beria cabi le' bárcuá nna bedacca' taáni ca enne' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Huía chì cą bedàa cą titsa' ìta'lubání región nía. Làniana guduló chì ca enne' ril·lani cą gatti' bání da' cą chè' cą canu ra'ni, ỹua cą lo camilla gaỹa tediba runa cą qui'ni rì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gaỹa tediba díe le' ca yetsi to' l·le le' ca ciudad l·le, ą'hua ca rancho to' l·le, pues rixa cą canu ra'ni lo néda làti rittie ratta'yúni cą ne qui'ni hue'él·le'e cą gulappa' cą màsqui'di ru'a ỹúe. Iyaba canu belappa' cą ne nna beyacca taá latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Làniana bitsina' ca fariséua lani tuchùppa ca maestro de la ley ru'a lo Jesús, da' cą de Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Làcą nna bilá'ni cą qui'ni tuchùppa ca discípulo qui' Jesús nna labí beni cabi purificar ná' cabí de gùl·la' go cabí, quiere decir labí gutíi ná' cabi conforme lani nu ra ca enne' fariséua. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Porqui'ni ca fariséua ą'hua iyaba adí ca enne' judíua nna runi cą seguir ca costumbre religiosa qui' ca enne' gùla qui' quį, labí ro cą canchu labí primérute rìi ná' quį conforme lani costumbre qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ą'hua canchu chi retsina' cą ria cą i'yya nna, labí ro cą canchu labí primérute gude cą inda lo la'gó qui' quį. Ą'hua iỹétse'éru adí ca costumbre denó cą; hàstaá ca taza nu ri'yàni cą inda, ca ré'e qui' quį nna ca traste nu de metal qui' quį nna, hàstaba lònà qui' quį nna, pues rìi cą cą según bá ca regla qui' quį para ccá cą purificar. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ca fariséua ą'hua ca maestro de la ley nna gunàba titsa' cą nna ra cą ne: Bianicca ca discípulo qui' lu'ą' làa runi cą según ca costumbre nu bethà'na ca ta' tàta qui' ri'u para guni ri'u, pues bihua rìi ná' quį segúnbá religión qui' tu' ántesca go cą, acca rappa cą tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Becàbi Jesús nna rèe cą: Falso bá ná la' rulábalatsi' qui' le. Làtegáláa riquixá'a Tata Dios acerca de lebi'į lo libro nu bedia Isaías enne' uccua profeta: Yetsi rì'į nna, lani rú'a terúbíį rudettią inte'. Pero lostu'į nna idittu' tsè' duą lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","De balde bá rexa latsi' quį inte', Porqui'ni doctrina nu riquixá'a cą nna ną́ mandamiento nu gulèqquia bá iqquia ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ą'ba runi le, porqui'ni en vez de runi le cumplir nu ra lo mandamiento qui' Tata Dios nna, yala purari cca le para guni le ca costumbre qui' ca enne' tì'a nu runi le canchu chi rìi le ca ré'e l·le ca vaso nu ri'yàni le inda l·le, ą'hua iỹétse'éru adí ca costumbre luetsi ca nua'. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Làniana rèe cą: Buen tì'a tsè' ccani le rirú'na le nu ra lo mandamiento qui' Tata Dios para qui'ni guni la le ca costumbre quì'ba le. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Por ejemplo, ta' tàta qui' le Moisés nna ra bi: Gùppa lu' respeto tàta nàna qui' lu'. Ra huá bi: Nuỹa tediba qué' iqquia tàta nàna quì'į nna té qui'ni gattią. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero lebi'į nna rena la le: Canchu ttu enne' nna gą́ tàta nàna quì'į: Labiru cca quia' gunia' le cualani porqui'ni itute nu ná gunia' le cualani nna chìla ną́ Corbán (Corbán rena cą: ofrenda nu rutsia cą yà'latsi' para Tata Dios), ");
INSERT INTO zaaNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","canchu chi rena ttu enne' anía nna, entonces lebi'į nna labiru rue'él·la' li ą gunią cualani tàta nàna quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Anía modo nna rirú'na le titsa' qui' Tata Dios nna denó lá le ca costumbre malo nu rulue' huáni le ca ỹi'ni le. Ą'hua iỹétse'éru luetsi costumbre máluį runi le. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Làniana gutàỹi Jesús iyaba ca enne' ỹétsi'á nna rèe cą: Iyate le nna liudà naga' le nu inni yì'į para qui'ni télini le. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Labí biỹa té nu ro ttu enne' runią qui'ni ccą́ enne' tul·la', sino nu riria lá lo losto' ttu enne' nna runią qui'ni ccą́ nu tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nu calatsi' ídeti'ą nna pues gudà tsè' nagui'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","De bede'e làti tsè'e ca enne' ỹétse'á nna gutè'e le' yú'a, làniana gunàba titsa' tè ca discípulo qui'áa ne sobre de ejemplo nu beni áa. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús nna rèe cabi: Tsí ą'hua lebi'į bihua té la' riyeni qui' le. Tsí labí ritelíni le qui'ni nì ttu cosa nu ro ttu enne' nna labí runią qui'ni ccą́ nu tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Porqui'ni nu rá'a rú'a ttu enne' nna labí ritsina'ą lo lostu'į, sino qui'ni dia bą́ lì'į, bitola nna reria bą́. Anía ra Jesús para qui'ni télini ri'u qui'ni iyábani ca alimento nna ná cą tsè' para go ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Làniana rèe: Nu riria la lo losto' ttu enne' nna runią qui'ni ccą́ nu tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Porqui'ni de lo losto' la ttu enne' nna riria ca la' rulábalatsi' mal, tì'a ttu nu rìdualàni ttu enne' nu labí ná tselį, ą'hua la' huetti enne' nna, ");
INSERT INTO zaaNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","la' ubànà nna, la' dàalatsi' biỹa té qui' attu enne' nna, la' hueni maldad nna, la' huenilatsi' nna, ą'hua bíỹaáru ca vicio nna, la' yélatsi' nna, la' batta' nna, la' necio nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iyaba ca cosa mal nì nna riria cą de lo losto' ca enne', acca iyaba cą chi ná cą enne' tul·la', alàa porqui'ni labí rigua cą ca costumbre qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bedà' tè Jesús nía nna huíe le' región làti anta' ca yetsi Tiro nna Sidón nna. Gutà'a tìe le' ttu yú'u nna labí uccua latsi'e qui'ni guna ca enne' qui'ni ri'e nía. Pero bina dihua cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ttu niula nía nna bina taą́ qui'ni re' Jesús látsį nna bitsina'ą nna beduỹíbį ru'a lúe, porqui'ni dua ttu ỹi'ni niulíį ccą padecer por ttu espíritu malo. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Lą nna gutta'yúnią ne qui'ni ebèqquie espíritu malo lo losto' ỹi'ni niá. Niuláa nna labí uccuą enne' judío sino nu raza lą́ sirofenicia. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Acca ra Jesús niuláa: Be'él·la' ỹá ca ỹi'ni enne' ná xana' yú'a go cą ti'iỹa bá ccání qui' quį, porqui'ni labí ná tsè' qui'ni ttu tàta cúą etta lo ná' ca ỹi'nį para gudàl·lą na ru'a lo ca beccu' to'. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Becàbi niuláa nna rą ne: Hualibani cuią'lu' Señor, pero hàstaá ca beccu' to' canu tsè'e ỹàrèe' meỹa nna ro cą ca pedazo to' nu rinnia ru'a meỹa làti ro ca ỹi'ni xana' yú'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús nna ra tìe na: Tsè'ba becàbi lu', acca beyya bá litsi' lu', porqui'ni espíritu malua nna chìa bétse'e latsi'į ỹi'ni lu'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","De betsina' niuláa litsi' niá nna bilá'nią ỹi'ni niá tíą lo lònà nna labiru ccą padecer por espíritu malua. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bedà' bá Jesús le' región qui' yetsi Tiro nna guttè tìe le' yetsi Sidón ą'hua le' ca yetsi to' canu anta' le' región nu lá Decápolis, làniana bitsine'e ru'a indatò' qui' Galilea. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nía nna tahua' tè cą ru'a lo Jesús ttu enne' ną́ cuètsu nna rátti rú'į nna. Gutta'yúni cą ne qui'ni gutsia né'e iqquia nubeyu'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Gulèqquia tìe na yà'latsi' la nna begà'a tè ỹubené'e le' ca yeru nagui'į, betutu xèni'e nna belappe'e luèttsí'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Guchìtha tè lúe gunne'e ỹiabara', gunèni latsi'e nna rèe na: Efata, quiere decir: Biyàlia. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Làniataá biyàlia chi ca yeru nagui'į nna biyéni chìnią, ą'hua biyàtsi nu runi qui'ni làa cca ínnią nna yala tsè' gunne chìą. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yala gunèni Jesús cą qui'ni nú ttu tehuá nuỹa quixá'ani cą. Pero adí telá bedàa cą titsa'. ");
INSERT INTO zaaNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Biquila' yà'àba latsi' quį nna ra cą: Iyáteni runie tsè', tàntua ca cuètsu nna runie qui'ni riyénini cą, ą'hua canu ỹí nna runie qui'ni rinne cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tiempo lània taá nna bitùppa iỹétse'ní ca enne' ru'a lo Jesús attu, pero labí biỹa té nía go cą, acca gutàỹi tìe ca discípulo qui'áa nna rèe cabi: ");
INSERT INTO zaaNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Yala retúa látsa'a' ca enni'į porqui'ni chi uccua tsunna ubitsa tsè'e cą nì lani inte', atsi'íni labiru biỹa té go cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Canchu ethèl·la' ya' cą litsi' quį sin qui'ni làa go cą primero nna, hua gútsi latsi' quį lo néda, porqui'ni ttu te cą nna idittu' tsè'ni da' cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ca discípulo qui'áa nna ra cabi e: Caligáhuá taxi' ri'u nu go iyaba ca enni'į porqui'ni tsè'e ri'u ttu lugar idittu' de làti anta' ca yetsi. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús nna gunàba titsa' tìe cabi nna rèe: Bàl·lacà'a ettaxtíla dèni le. Becàbi cabi nna ra cabi e: Gàtsi. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Làniana rèe ca enne' ỹétsi'á qui'ni xúani cą loyu. Guỹi' tìe gàtsi ca ettaxtílaá nna gunàbèe bendición lani Tata Dios, làniana gùl·la'a tìe ca ettaxtílaá nna betie lani ca discípulo qui'áa. Làcabi nna gutìthia cabi cą lani ca enne' ỹétsi'á. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ą'hua dèni huá cabi tuchùppa ca bél·la to'. Gunàbèe bendición, làniana rèe cabi qui'ni gutsia huá cabi cą ru'a lo ca enni'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Gutò cą ti'iỹa bá uccuaní qui' quį. Làniana betùppa tè cabi ca pedazo nu béxaá, gàtsi tsummi. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ca enne' gutò lània nna hua ná ttú tappa mili' ti'gá cą. Làniana bechu titsa' Jesús cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Luégutaá nna gutè'e le' bárcuá lani ca discípulo qui'áa, dia cabi para región nu lá Dalmanuta. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Làniana gul·lani tè ca fariséua guduló cą runi cą discutir lani Jesús, gunàba tènì cą ne qui'ni gunie ttu milagro ru'a lo quį nu gulue' qui'ni té la'huacca quì'e de ỹiabara', solamente para eyìla cą néda ti'iỹala modo cu'ée ttu falta. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús nna yala fuerte gunnèni latsi'e nna rèe: Bianicca calatsi' canu tsè'e nì ilá'ni cą ttu señal milagrosa de ỹiabara'. Hualigani te' riquixa'ánia' le qui'ni nidi ttu señal labí ilá'ni cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","De rèe anía nna, betse'e latsi'e cą nna gutè'e le' bárcuá attu nna déyyeé para attu lado la indatù'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ca discípulo qui'áa nna biỹul·lani cabi labí nùà' cabi biỹa go cabi sino tùteruba ettaxtíla nùà' cabi le' bárcuá. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Làniana gunèni Jesús cabi nna rèe: Lihue' cuidado lani levadura qui' ca fariséuą' ą'hua lani levadura qui' Herodes nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ca discípuluá nna ra luetsi cabi: Porqui'ni labí nùà' ri'u ettaxtíla acca rèe lą'. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Gutelí taáni Jesús nna rèe cabi: Biani nua' rue' le titsa'. Tsí porqui'ni labí ettaxtíla nùà' le. Tsí bihua nì' télini le nihua làa nì' ennia le cuenta cá. Tsí àtsaba re'nią chul·la le' la' riyeni qui' le cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Hua dua gáláa íyyalo le, pero labí rilá'ni le. Ą'hua hua dua gáláa naga' le, pero labí riyénini le. Tsí labí rexa latsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pues loti' gùl·lá'a' gayu' ca ettaxtílaá entre gayu' mili' ca enni'a nna, bàl·lacà'a tsummi thú tsá'ti'ni ca pedazo nu bexa betùppa le. Becàbi cabi nna ra cabi: Tsì'nu. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ą'hua loti' gùl·lá'a' gàtsi ca ettaxtílaá entre tappa mili' ca enni'a, bàl·lacà'a tsummi tsá'ti'ni ca pedazo nu bexa bedi' le. Làcabi nna ra tè cabi: Gàtsi. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Làniana rèe cabi: Ti'ala modo áccá àtsàhua nì' télini le cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Huía tè Jesús yetsi Betsaida. Ca enne' nía nna tahua' tè cą ru'a lúe ttu ciego, gutta'yúni cą ne qui'ni gulappe'e na. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús nna gutèl·la' tìe ná' ciéguá nna guchi'e na fuera yetsi tú'a la nna gutàbie xèni' íyyaluį, betsia tè né'e iqquį, làniana gunàba tìtse'e na canchu hua rilá'nią ti'to'. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Lą nna gunna' tìą nna guduluą rilá'nią nna rą: Rilá' te' ca enne', pues rilá' te' cą tì'a yaga pero rida' cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Làniana belappa' tìe ca íyyaluį attu vuelta. Nubeyu'a nna gunna' tìą attu, làniana benibia' tsì'ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bethèl·la' tè Jesús na litsi'į nna rèe na: Nu ttu tehuá nuỹa quixá'ani lu' le' yétsią'. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Bitola nna huía tè Jesús lani ca discípulo qui'áa le' ca yetsi to' anta' exa bá ciudad nu lá Cesarea qui' Filipo. Néda bá yù'u cabi nna gunàba titsa' tè Jesús ca discípulo qui'áa nna rèe: Nuni rena ca enne' qui'ni ná inte' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Becàbi cabi nna ra cabi e: Ttu te cą nna rena cą qui'ni ná cuią'lu' Juan el Bautista. Attu te cą nna rena cą qui'ni ná cuią'lu' Elías. Adí cą nna rena cą qui'ni ná cuią'lu' ttu nuỹa la ca profétaá. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Lèe nna rèe cabi: Lebi'į chúná, nula rulába latsi' le ná' ni'i. Becàbi Pedrua nna ra bi e: Cuią'bálu' Enni'ą' enne' ná Cristo. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pero Jesús nna gunènie cabi qui'ni nu ttu tehuá nuỹa quixá'ani cabi nui. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Làniana guduló Jesús riquixa'ánie ca discípulo qui'áa qui'ni Nubeyu' de Ỹiabara' nna té qui'ni quée padecer. Raáruhuée qui'ni canu rigú'ubia' le' yétsiá lani ca sacerdote principal nna ca maestro de la ley nna guyudí' cą ne hàstaá qui'ni gutti cą ne, pero bitola de tsunna ubitsa nna eyáthèe de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Claru tabá gutixa'ánie cabi qui'ni aníaba ná la' tté quì'e. Làniana gulèqquia yetsi' tè Pedrua ne nna guduló bi ritsa' bi e. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús nna bedèqquia te lúe gunne'e ca discípulo qui'áa nna gutìtse'e Pedrua nna rèe: Becuitta ru'a lua' Pedro, ná lu' tì'na Satanás porqui'ni labí nabia'ni lu' nu cca qui' Tata Dios sino nu cca qui' ca enne' la. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Làniana gutàỹi Jesús ca discípulo qui'áa ą'hua adí ca enne' tsè'e nía nna rèe cabi: Canchu nuỹa calatsi'į ccą́ ttu discípulo quia' nna, té qui'ni iỹùl·lanią la'a labą́ nna ga'ną dispuesto ccą́ sufrir biỹa para tanuą inte', tì'a inte' hua'nia' curutsi quia'. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Porqui'ni nuỹa tediba dua iqquį etúa latsi'į la'labàni quì'į nna, pues gunitti lą́ na. Pero nuỹa tediba iria latsi'į la'labàni quì'į hàstaá canchu caduel·la' gattią porqui'ni ríalatsi'į inte' ą'hua porqui'ni riquixá'ą evangelio nna; lą nna ccabàni lą́. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Canchu ttu enne' gata'nią itute riqueza qui' yétsiloyu, pero bitola nna nitti bą́ para siempre, biani gana ni benią cá. Labí biỹa. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","O biani tì' ná gute ttu enne' lani Tata Dios para gáỹaní nu dacca' la'labàni quì'į cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yala nu tul·la' ná ca enne' tsè'e yétsiloyu, ą'hua labí fiel ná cą lani enne' catsi'ínie cą. Pero nuỹa tediba ettu'nią quixá'ą nu cca quia' nna ca titsa' quíyi'į nna, entonces inte' Nubeyu' de Ỹiabara' nna ettu' huá te' na canchu chi gal·la' tsá el·lania' lani ca ángeli de ỹiabara' nna la'yani bàni qui' Tàta quí'a nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús nna ra huée cabi: Hualigani te' riquixa'ánia' le qui'ni tuchùppa canu tsè'e nì lani inte' nna labí gatti cą hàstaá qui'ni ilá' ỹáni cą íl·lani reino qui' Tata Dios lani la'huacca quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Xuppa ubitsa bitola nna gulèqquia Jesús Pedrua nna Jacóbua nna Juáan nna yà'latsi', gùchi'e cabi lo ttu i'ya xeni tsè'. Làniana bilá'ni cabi qui'ni bettsiání la' rinna' quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Beyacca tittiní ỹúe tsíttsi tùni tì' taání beyi'. Lanú té le' yétsiloyuį nu ccani reyìi lári' tsíttsi tùni ti'a beyacca ca ỹúeá. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Làniana de repente taá nna gudu Moisés nna Elías nna ru'a lo cabi nna rue' cabi titsa' lani Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Gunne tè Pédrua nna ra bi Jesús: Maestro yala tsè' canchu eyà'na ri'u nì. Annana guni tu' tsunna yú'u l·la' to', ttu para cuią'lu' nna, attu para Moisés nna, attu para Elías nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pédrua nna nihua làa yù bi biỹa nuá ra bi, pues tsè'e la cabi lani la' rátsilatsi'. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Làniana gul·lani ttu bía nna benią ỹula qui' cabi nna biyeni tè tsi'i ttu enne' gunnie dèsdeba le' bía nna rèe: Là enni'į enni'ą' Ỹì'nia' yala catsi'í ti' e, liudà naga' le quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Luégutaá gunna' cabi, pero lanuru nuỹa bilá'ni cabi sino alatèruba Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","De beyadi cabi lo i'yaá nna gunèni Jesús cabi qui'ni nú ttú tehuá nuỹa quixá'ani cabi nu bilá'ni cabi sino hàsta'na qui'ni Nubeyu' de Ỹiabara' nna eyáthee de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Por nui nna bihua bedàa cabi titsa', pero entre làba cabi nna gunàba titsa' luetsi cabi sobre de biỹa nua' diánie loti' rèe qui'ni eyáthee de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Làniana gunàba titsa' cabi e nna ra cabi e: Bianicca ca maestro de la ley nna rena cą qui'ni náduel·la' ìta yà'lala Elías cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Becàbie nna rèe cabi: Hualiba, yà'la Elías ìta, làbi nna guni bi arreglar tsè' iyábani ca cosa. Pero biani ra lo Escritura acerca de nu cca qui' Nubeyu' de Ỹiabara' cá. Pues ra qui'ni yala quée padecer porqui'ni yala rutsibi cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero riquixa'ánia' le qui'ni Elías nna chìla bìta bi, ą'hua bethacca' cą bi iyate nu uccua latsi' quį tì'a ga'na escrito nu cca qui' bi. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","De betsina' Jesús làti tsè'e adí ca discípuluá nna bilá'nie nuỹé tsè'ni ca enne' tsè'e cą ìta'lùba cabi, tsè'e huá ca maestro de la ley nna runi cą discutir lani cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","De bilá'ni iyábani ca enni'a Jesús nna yala biquila' latsi' quį nna bigàa chì cą nna huía cą beni cą ne saludar. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Lèe nna gunàba titsa' tìe cą nna rèe: Bianica yala riyeyya le. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Gunne tè ttu nu látsi' canu ỹétse'á nna rą: Maestro, nì chí'a' ỹi'ni yì'į lani cuią'lu', porqui'ni ccą padecer por ttu espíritu malo nu runią na nu ỹí. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Espíritu maluį nna, gaỹa tediba reqquia ỹì'ni yì'į rel·lanią nna rudàl·la tabą́ na loyu ruxìtti'níą na nna bettsina'ní ruduą rú'į, ą'hua royà'a tsùni layi'į nna yala chi retsìttą runią. Acca chi pá'a' ca discípulo qui' cuíą'lu'ą' qui'ni ebèqquia cabi espíritu maluą' fuera, pero labí uccuani cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Becàbi Jesús nna rèe cą: Lebi'į canu díátia' canu labí ríalatsi'. Atsáliacà'a itsá dà te' cuenia' lani le. Atsáliacà'a itsá té qui'ni guchia' le cá. Litahua' nubeyu' cuìti'ą nì. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Làcą nna tahua' tè cą nubeyu' cuìti'a ru'a lo Jesús. Bilá' báni espíritu malua Jesús nna prontu tabá benią qui'ni biỹìtti'ní nubeyu' cuìti'a fuértení, làniana berixi betetsíníą na loyu nna bettsina'ní beduą rú'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús nna gunàba titsa' tìe tàta qui' niá: Tsaliaỹa itsá chi uccua ridácca'ą anía. Becàbią nna rą ne: Dèsdeba ną́ nito'. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ą'hua iỹé vuelta tsè' chi bedàl·lą na lo yi' ą'hua le' inda para guttią na. Acca canchu huacca qui' cuią'lu', guni cuią'lu' tu favor lani intu' nna, betúarú latsi' cuią'lu' intu' nna beyuni cuią'lu' ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús nna ra tìe na: Canchu hua ríabá latsi' lu', porqui'ni para canu ríalatsi' nna iyaba ná posible. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tàta qui' nubeyu' cuìti'a nna prontu taání gunią idìtsa nna rą: Hua ríalátsa'a', Señor, pero gutua cuią'lu' nu ruthàga'ą qui'ni tsíalátsa'a' adí tsè'. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","De bilá'ni Jesús qui'ni adiru enne' ỹétse'ní rituppa ìta'lubáníe nna ruquìni luetsi quį, acca gutìtsa' chìe espíritu malua nna rèe na: Lu' espíritu mudo nna cuètsu nna, inte' nia' lu': Bèria, bíttuúru eyeqquia lu' attu lani nubeyu' cuìti'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Espíritu malua nna yala fuerte guretsiyà'ą nna bexìtti'níą nubeyu' cuìti'a nna beria tìą. Nubeyu' cuìti'a nna nu yatti taá tíą, acca nuỹé cą nna ra cą: Chi gùttìą. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero Jesús nna bedàxu'e ní'į nna bèthuli tìe na. Lą nna gudu taą́. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bitola de chi re' Jesús le' yú'a yà'ba latsi' nna, ca discípulo qui'áa nna gunàba titsa' cabi e nna ra cabi: Biecca intu' nna bihua uccuani tu' gudàl·la tu' ą fuera cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Lèe nna rèe cabi: Luetsi ca espíritu maluą' nna labí ỹá eria bá cą sino lani oración nna ayuno nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","De bedà' cabi nía nna guttè cabi región qui' Galilea. Jesús nna labí uccua latsi'e qui'ni nuỹa guna, ");
INSERT INTO zaaNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","porqui'ni riquixa'ánie ca discípulo qui'áa nu chì' da'la nna rèe: Nubeyu' de Ỹiabara' nna gute cą ne cuenta latsi' ná' ca enne' nna gutti cą ne, pero tsunna ubitsa bitola de chi gùttìe nna eyáthee de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ca discípuluá nna labí gutéelíni cabi biỹa nuá rèe cabi, ą'hua labí beyáỹani cabi inàba titsa' cabi e. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Làniana huía Jesús le' yetsi Capernaum. De chi ri'e le' yú'u nna, gunàba titsa' tìe ca discípulo qui'áa nna rèe cabi: Biani nuá beni le discutir de yù'u ri'u nédaá. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero làcabi nna labí becàbi cabi, porqui'ni de yù'u cabi nédaá nna bè' cabi titsa' sobre de nùỹalá cabi ccá adiru enne' ỹeni. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesús nna gudua tènie nna gutàỹi tìe tsì'nu ca discípuluá nna rèe cabi: Canchu nuỹa calatsi'į ccą́ nu neru nna, pues ná qui'ni gunią servir iyaba ca compañero quì'į nna ccą́ tì'a ttu nu labí dacca'. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Làniana guỹi' tè Jesús ttu huatsa to', bedue na lahui' cabi, bedua tìe na lo ỹíbie nna rèe cabi: ");
INSERT INTO zaaNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Nuỹa gunią recibir ttu huatsa to' luetsi huátsíį porqui'ni ríalatsi'į inte' nna, pues ti'atsi inte' bá nuá runią recibir. Ą'hua nu runią inte' recibir nna, álahuá tsua' teruba inte' runią recibir, sino hàstala enne' guthel·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Làniana gunne Juáan nna ra bi Jesús: Maestro, bilá'ni tu' ttu enne' qui'ni lani nombre qui' cuią'lu' nna runią mandado ca espíritu malo qui'ni eria cą lo losto' ca enne', pero labiru be'él·la' tu' ą gunią seguir porqui'ni labí láníą ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Becàbi Jesús nna rèe cabi: Bittu guthàga' li ą, porqui'ni nuỹa enne' runi milagro lani nombre quia', pues labí eyeqquia tìą ínnią contra a'. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Porqui'ni nu labí ną́ contrario qui' ri'u nna, pues parte ri'u bá duą. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ą'hua lebi'į nna, nuỹa tediba gunną màsqui'di ttu vaso inda í'ya le lani nombre quia' porqui'ni ná le enne' quia', hualigani te' riquixa'ánia' le qui'ni lą nna segúruní thí'ą bendición. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nuỹa diba gunią qui'ni ìnnia le' tul·la' nuỹa ttu canu xcuichu to' canu ríalatsi' quį inte' nna, pues inte' nna nia' le qui'ni enne' gulú'u fáltaá nna adila tsa' iỹìqquia yánį lani ttu íyya molino nna gudàl·la tè cą na lahui' indatò'. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Canchu por ca cosa mal nu runi ná' lu' acca chi ná lu' enne' tul·la' nna, pues guchu telá ą; porqui'ni adila tsa' thua turuba ná' lu' nna gata' là'labàni nu labí ttíą qui' lu' tì'ca'la tsìa chùppa ná' lu' nna tsía lu' lo yi'bél·laá nu ral·la'ą tulidàba, ");
INSERT INTO zaaNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","làti ca bedua' qui' quį nna labí gatti cą, nihua yí'a nna labí eyòlą. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ą'hua canchu nì'a lu' runią qui'ni runi lu' tul·la' nna, guchu telá ą; porqui'ni adila tsa' qui'ni thua turuba nì'a lu' nna gata' là'labani nu labí ttíą qui' lu' tì'ca'la tsìa chuppa nì'a lu' nna tsía lu' lo yi'bél·laá nu ral·la'ą tulidàba, ");
INSERT INTO zaaNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","làti ca bedua' qui' quį nna labí gatti cą, nihua yí'a nna labí eyòlą. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ą'hua canchu ttu lado íyyalo lu' runią qui'ni runi lu' tul·la' nna, gulèqquia telá ą; porqui'ni adila tsa' ccá lu' pertencer lani Tata Dios le' reino quì'e lani turuba íyyalo lu' tì'ca'la tsìa chuppa íyyalo lu' nna tsía lu' lo yi'bél·laá. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nía nna ca bedua' qui' quį nna labí gatti cą, nihua yí'a nna labí eyòlą. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Acca iyaba ca enne' nna miéntraste bàni cą, pues dàni cą ccá cą probar lani sufrimiento para ccá cą purificar, tì'a iyaba ca sacrificio uccua duel·la' tsù'u cą dete'. ");
INSERT INTO zaaNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yala riỹu' dete', pero canchu dèti'a gunittią la' iỹé' quì'į nna, biala lani eyàccanią iỹé' cá. Dete' nna riỹu'ą para nu ná tsè'. Ą'hua lebi'į nna, líúdua iqquia le guni le nu ná tsè' nna gappa la' ỹeni qui' luetsi le. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Beria tè Jesús le' yetsi Capernaum nna huíe para región qui' Judea ą'hua hàstaá attu lado qui' yò Jordán. Nía nna bedetùppa taá iỹétse'ni ca enne' ru'a lúe. Lèe nna gudulue gutixa'ánie cą ca enseñanza nu cca qui' Tata Dios tì'a runi bée. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bitsina' tè canu gulání religión fariseo para eyìla cą néda ti'iỹa modo cu'ée ttu falta, acca gunàba titsa' tè cą ne sobre de canchu hua ná tsè' éla'á ttu nubeyu' niula quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Lèe nna becàbie nna rèe cą: Biani bedia Moisés para guni le. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Becàbi cą nna ra cą: Moisés nna beni ba bi permitir qui'ni ttu nubeyu' nna ilìthą acta de divorcio nna éla'á tìą niula quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Becàbi Jesús nna rèe cą: Por la' necio quì'ba le acca bedia Moisés nua'. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero dèsdeba nerua loti' beni Tata Dios yétsiloyu nna, pues nubeyu' nna niula nna benie ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Acca por nui nna ná qui'ni guthà'na ttu nubeyu' tàta nàna quì'į itsà' tìą niula quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Làniana chuppa tè cą nna ccá cą ttùba; labiru ná chuppa cą, sino ttùba cuerpo nna espíritu nna chi ná cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Acca por nui nna, nu bettsà' Tata Dios luetsi quį nna, labí ná qui'ni nuỹa el·la'ą́ cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","De tsè'e ca discípuluá lani Jesús le' yú'u nna bede nàba titsa' tè cabi e sobre de matrimonio. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Lèe nna rèe cabi: Nuỹa tediba éla'ą́ niula quì'į nna gúttsaní'į lani attu niula nna, entonces chi ną́ adulterio nu runią. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ą'hua canchu ttu niula gútse'e latsi'į nubeyu' quì'į nna gúttsaní'į lani attu nubeyu' nna, entonces chì hua ná adulterio nu runią. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Làniana tahua' tè ca enne' ca huatsa to' qui' quį ru'a lo Jesús para qui'ni gutsia né'e iqquia quį. Pero ca discípuluá nna gutìl·la la cabi ca enne' dia ritahua' ca huátsáa. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","De biyénini Jesús nu ra ca discípuluá nna yala sentir ucuee nna ra tìe cabi: Líhue'él·la' ca huatsa tú'ą' ibiga' cą ru'a lua', bittu guthàga' le cą; porqui'ni ca enne' té fe qui' quį tì'a nu té qui' ca huatsą' nna, quì'ba quį ná reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Hualigani te' riquixa'ánia' le qui'ni nu labí tsíalatsi'į Tata Dios para qui'ni quée enne' rigú'ubia'nie na tì'a ríalatsi' ttu huatsa to' nna, entonces labí gá'ą le' reino quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Làniana guỹi' Jesús ca huátsáa nna gul·lánie cą nna betsia tè né'e iqquia quį nna benie cą bendecir. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","De chi beyèl·la' Jesús néda déyyeé attu làti huaya' nna, quèthani bigàa ttu nubeyu' bitsina'ą beduỹíbį ru'a lúe nna gunàba titsa'ą ne nna rą: Maestro completamente enne' tsè', biani gunia' para gata' la'labàni nu labí ttíą quia' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús nna rèe na: Bianicca ra lu' inte' enne' completamente tsè' ni'i. Ni ttú lanú té ná completamente tsè' sino tùteruba Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Hua nabia' báni lu' ca mandamiento: Bittu thualàni lu' nu labí ná tsela lu'. Bittu gúttí lu'. Bittu cuana lu'. Bittu ichìtha lu' bela'na qui' ca enne'. Nú ttu nuỹa guthácca'ỹí lu'. Gùppa respeto tàta nàna qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Becàbią nna ra tìą ne: Iyaba ca mandamiéntuą' runia' dèsdeba ná' xcuichu to'. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús nna gunna' tìe na lani la' retúalatsi' nna rèe na: Hua reyatsaárùnì lu' áttuló: Beyya nna betti' iyate nu té qui' lu', bete tì ą lani ca enne' rittè là'di', làniana ỹiabara' lá nna gata' riqueza qui' lu'. Acca lu' nna gutà tè ga'na lu' dispuesto guchia lu' ccá lu' sufrir para tanó lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nubeyu'a nna de biyéninią ca tìtsi'į nna yala nùyue uccuanią nna, triste tsùba beyeqquią, porqui'ni adila uccuatsi'ínią ca interés té quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Làniana gunna' tè Jesús ìta'lùba làti duéa nna rèe ca discípulo qui'áa: Hualigani yala tabi ná para canu té riqueza qui' quį gá'a cą le' reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ca discípuluá nna yala uccuaỹí latsi' cabi por ca titsa' nu rèe. Raáruhuá Jesús cabi: Ỹì'nia', canu rappa confianza bel·liu qui' quį nna, yala tàbi ná qui'ni hue'él·la' cą qui'ni Tata Dios nna quée enne' cu'úbia'nie cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Adila fácil ná tté ttu animal xeni tì'a ttu camello le' yeru to' qui' ttu guỹa, tì'chula ttu rico gá'ą le' reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Làniana adila uccuaỹí latsi ca discípuluá nna ra luetsi cabi: Entonces núlá ccáni l·lą́ cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Gunna' tè Jesús cabi nna rèe: Para ca enne' nna labí ná posible, pero lani Tata Dios nna huacca; porqui'ni lani Tata Dios nna fácil taá ná iyábani ca cosa. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Làniana gunne tè Pédrua nna ra bi e: Intu' nna iyáỹiate chi bethà'na tu' nna chì denó tu' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Becàbi Jesús nna rèe: Hualigani te' riquixa'ánia' le qui'ni iyaba canu iria cą le' litsi' quį por inte' nna guthà'na cą ca loyu qui' quį l·le, ca bettsi' quį l·le, ca dana quį l·le, tàta nàna qui' quį l·le, niula qui' quį l·le, ca ỹi'ni quį l·le, para quíxá'a cą evangelio nna, ");
INSERT INTO zaaNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","làcą nna thí' cą ágáyua' tántula miéntraste tsè'e cą yétsiloyuį: ca yú'u l·le, ca hermano l·le, ca madre l·le, ca hermana l·le, ca ỹi'ni l·le, ca loyu l·le, ą'hua guyudí' ca enne' cą nna gutsia latsi' quį cą l·le. Pero tiempo nu chì' da'la nna edacca' latsi' quį tulidàba porqui'ni té la'labàni nu labí ttíą qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero nuỹetse' canu neru annana, ccá lá cą nu bitote. Ą'hua nuỹetse' canu bitote annana, ccá lá cą nu primeru. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yù'u tè cabi néda dia cabi para Jerusalén, Jesús nna denérue lo cabi. Gul·lani ttu la' rátsi'latsi' lo losto' cabi nna, pero denó tè cabi e nna labí yù cabi biỹa ná la' rulábalatsi' quì'e. Gulèqquia yètsì'e ca discípuluá entre ca enne' ỹétse'á nna gudulúe gutixa'ánie cabi iyaba ca cosa nu guthacca' cą ne nna, ");
INSERT INTO zaaNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","rèe: Annana dia ri'u Jerusalén, nía nna gute cą Nubeyu' de Ỹiabara' cuenta latsi' ná' ca sacerdote principal ą'hua latsi' ná' ca maestro de la ley; làcą nna cueqquia cą sentencia quì'e para gattie, làniana gute cą ne cuenta latsi' ná' canu dittu' canu rigú'ubia' le' ciudáad nna, ");
INSERT INTO zaaNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","guni cą ne burla nna, gututu xèni' quį ne nna gutti cą ne pero bitsa tsunna nna eyáthee de lo lù'uti. Anía rèe cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Làniana gubiga' tè ca ỹi'ni Zebedéua, lá cabi Jacobo nna Juan nna ru'a lo Jesús nna ra cabi e: Maestro, calatsi' tu' inàbani tu' cuią'lu' ttu favor. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Lèe nna rèe cabi: Biani calatsi' le gunia'. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Becàbi tè cabi nna ra cabi e: Canchu gal·la' tsá thí' cuią'lu' la' rigú'ubia', benna bál·la cuią'lu' derecho qui' tu' xúaní tu' cuitta' cuią'lu', ttu tu' lado bàni, attu ttu' lado yatti. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús nna rèe cabi: Labí ritelíni le biỹa nua' rinàba le. Tsí ína ri'u guchia ba le tté le iyaba ca sufrimiento nu ná qui'ni ccá' padecer cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Làcabi nna ra cabi e: Guchia bá tu'. Ra tè Jesús cabi: Hualigani qui'ni ccá huá le padecer tì'a inte' ccá' padecer. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero de xúaní le lado ná' bània' nna lado ná' yattia' nna, álahuá quia' ną́ para gunna ya' ą sino chi beni Tata Dios na preparar para canu càba latsi'e. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","De biyénini á tsìi ca discípuluá anía nna, yala bitsa'áni cabi Jacóbua nna bettsi' bi Juáan nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pero Jesús nna gutàỹi tìe cabi nna rèe cabi: Hua yù ba le qui'ni canu rigú'ubia le' ca nación nna runi taání qui' quį itúbani; ą'hua canu re' cuenta nna yala aprovechar runi cą ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero entre lebi'į nna labí ccá ą́'. Sino qui'ni canchu nuỹa calatsi'į ccą́ enne' ỹeni entre lebi'į nna, ná qui'ni ccá lą́ nu gunią tsina lo le. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ą'hua canchu nuỹa la ttu le calatsi'į ccą́ nu neru nna, ná qui'ni ccá lą́ nu gunią iyaba le servir. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Porqui'ni Nubeyu' de Ỹiabara' nna labí dé'e para guni ca enne' tsina lúe, sino para gunie iyaba cą servir, ą'hua para gute la'labàni quì'e para qui'ni l·lá nuỹetse' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Làniana bitsina' cabi yetsi nu lá Jericó. De chi dia Jesús érie le' yétsiá lani ca discípulo qui'áa nna, dia tehuá iỹétse'ni ca enne'. Nía nna cuitta' nédaá re' tè ttu ciego láą Bartimeo ỹi'ni Timeo huenàba limosna. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","De biyéninią qui'ni dia Jesús enne' Nazaret néda nía nna, acca gunnią iditsa na rą: Jesús Ỹi'ni David enne' uccua rey, gùppa cuią'lu' la' retúalatsi' quia'. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Iỹetse' ca enne' tsè'e nía nna gutìl·la tè cą Bartiméua qui'ni guthàya rú'į, pero lą nna adila iditsa gunnią nna rą: Cuią'lu' Ỹi'ni David, betúa latsi' cuią'lu' inte. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Guleda tè Jesús nna rèe cą qui'ni taxi' cą ciéguá. Làcą nna huía tè cą nna ra cą na: Bedácca'ni nna gùduli, porqui'ni Jesús nna rinnie lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Enne' ciéguá nna guru'na taą́ lári' qui' niá nna gùduli chìą nna bitsina'ą ru'a lo Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús nna rèe na: Biani calatsi' lu' gunia' por lu'. Lą nna rą ne: Maestro, calátsa'a' elá' te'. ");
INSERT INTO zaaNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ra tè Jesús na: Labiru ná lu' ciego, porqui'ni chi ríalatsi' lu' inte'; anna tè béyya litsi' lu'. Enne' ciéguá nna luégutaá belá' chìnią nna dia tìą denúą Jesús lo nédaá. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Exa tegáabá Jerusalén chi deyya cabi nna, bitsina' cabi ca yetsi Betfagé nna Betania nna, frente ttu i'ya láą Monte de los Olivos. Jesús nna guthel·la' tìe chuppa ca discípulo qui'áa nna, ");
INSERT INTO zaaNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","rèe cabi: Lítsía le' yetsi to' nu re' frente taá téteá. Canchu chi bitsina' le nna hua taxácca' diga le làti tá' ttu burro to' nu nidi ttu enne' labí chi gutsią na. Ethàtsi li ą nna eche' tetsate' li ą nì. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Canchu nuỹa gą́ le: Bianicca rithàtsi li ą nna, gá tè li ą qui'ni Señor nna riquìna'nie na, annaba ethèl·le'e na. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Huía cabi nna taxacca' cabi burro tú'a nàl·la'nią ru'a yú'u fuéralá làti rittè nédaá, bethàtsi tè cabi ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tuchùppa canu tsè'e nía nna ra cą ca discípuluá: Bianicca rithàtsi le burro tú'ą' ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Làcabi nna becàbi cabi tì'ba nu chi ra Jesús cabi. Làcą nna be'él·la' taá cą cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Làniana deche' tè cabi burro tú'a làti du Jesús. Guxua tè cabi ca lári' qui' cabía cuì'į. Jesús nna gutsia tìe na. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Làniana iỹetse' ca enne' nna gutsìla cą ca lári' lo néda, attu te cą nna gutìttsa cą ca l·la' qui' ca yà nna benìta' tè cą cą lo neda para ttíe. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ca enne' denérua ą'hua canu denál·la'a nna gunne cą iditsa nna ra cą: Quíỹaru Tata Dios. Bendito enne' da' por mandado qui' Señor Dios, ");
INSERT INTO zaaNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ica'rubà qui'ni chi bi'yu tsá gul·lani la'rigú'ubia' qui' ta' tàta qui' ri'u David, la' dàliani para Tata Dios enne' dua ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","De bitsina' Jesús le' ciudad Jerusalén nna gutà'a tìe le' templua nna gunna' tìe iyaba ca cosa yù'u nía, pero luégutaá berie le' templua nna deyye para Betania la lani tsì'nu ca discípulo qui'áa porqui'ni chi ràl·là lània. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Attu yu'utsa nna beria cabi le' yetsi Betania, Jesús nna gutùnie. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Làniana bilá' tènie idittu' ti'a du ttu yà exxuhuí. Huía tìe hueyu canchu xiaba tsìa exxuhuí lúį, pero de bitsine'e làti dua naá nna labí biỹa té lúį, sino puro l·la' ba ną́, porqui'ni álahuá tiempo exxuhuí nuá. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Làniana ra tè Jesús yà exxuhuía: Dèsdeba anna nú ttu teérulá go fruta lo lu' cá. Ca discípulo qui'áa nna biyeni tènì cabi rèe anía. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Betsina' diba cabi Jerusalén nna gutà'a tè Jesús le' lí'a qui' templua nna bedàl·lèe fuera canu tsè'e nía huetti' nna huì'i nna, berixie ca meỹa qui' canu rittsilá bél·liuá ą'hua ca xila' qui' canu rutti cą becha nna runi cą negocio ru'a templua. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ą'hua lanuru nuỹa be'él·le'e tté frente le' lí'a qui' templua canchu nùà' cą yùà'. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Gutixa'ánie cą nu ga'na lo Escritura nna rèe: Tsí álahuá ra Tata Dios lo titsa' quì'e: Yú'u quíyi'į nna duą para ìta iyáỹiani ca enne' hueni oración lì'į, atsi'íni lebi'į nna ttu bèlìà qui' ubana la chi náni li ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ca maestro de la ley ą'hua ca sacerdote principal nna biyénini cą nu rèe, acca uccua latsi' quį gutti cą ne; pero yala gutsini cą porqui'ni iyaba ca enne' nna yala guyú'u latsi' quį ca titsa' nu gutixe'e. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Gùl·là diba lània nna beria Jesús le' ciudáad. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Attu yu'u dílaá nna guttè cabi làti du yà exxuhuía nna bilá'ni cabi qui'ni chi gubitsią dèsdeba ca l·lúį hàstaba puntu quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pédrua nna bexa tè latsi' bi, acca gunne bi nna ra bi: Maestro, gunna' tsáruhuá cuią'lu' yà exxuhuí nu beni cuią'lu' maldecir nayáa nna, chi gubitsią. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús nna rèe cabi: Lígappa confianza lani Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Hualigani te' nia' le qui'ni nuỹa tediba gą́ i'ya duį: Becuitta nna guttè lo indatò' la, pero bittu gudu chùppanią na sino qui'ni tsíalatsi'į qui'ni nu chi rą na huaccą cumplir, làniana hua ttìą. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Acca nia' le qui'ni iyaba nu inàba le lani oración, canchu hua té fe qui' le qui'ni huadi' le nu inàba le nna, huadi' li ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Canchu chi runi le oración nna rulaba tè latsi' le biỹa contra ttu enne' nna, leyúniỹén ỹá latsi' le quì'į ántesca guni le oración, para qui'ni Tata qui' le enne' dua ỹiabara' nna eyuniỹén huá latsi'e ca tul·la' qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Porqui'ni canchu bihua eyuniỹén latsi' le qui' ca enne' canu rigú'u falta lani le nna, nihua Tata qui' le enne' dua ỹiabara' labí eyuniỹén latsi'e ca tul·la' qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Làniana betsina' tè cabi attu Jerusalén. Loti' reni Jesús le' templua nna bitsina' tè ca sacerdote principal nna ca maestro de la ley nna ą'hua adí canu rigú'ubia' le' yétsiá ru'a lúe nna, ");
INSERT INTO zaaNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ra cą ne: Nuni por mandado qui'ni acca runi lu' ca cosį. Nuni benna derecho qui' lu' para guni lu' ca nui cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Becàbi tèni Jesús cą nna rèe cą: Ą'hua inte' nna inába titsa' huá' le. Canchu ecàbini le inte' nna, lànialá nna quixa'a' nuỹa benna la'huacca quia' acca runia' ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Gala da' derecho qui' Juan el Bautístaá para guni bi bautizar cá, tsí de ỹiabara' o tsí ca enne' ba bete derecho qui' bi áccá. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Làniana guduló cą bè' cą titsa' ti'iỹala ecàbini cą ne nna ra luetsi quį: Canchu ina ri'u qui'ni poder qui' Juáan para guni bi bautizar nna dá'ą de ỹiabara', entonces gá taą́ ri'u: Bialacca làa huíalatsi' le qui' bi cá; ");
INSERT INTO zaaNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ą'hua canchu ina ri'u qui'ni ca enne' ba bete permiso quì'į nna. Pero lá' yala gutsini cą biỹa guthacca' ca enne' yétsiá cą, porqui'ni para iyaba ca enne' nna hualigani uccua Juáan ttu profeta qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Acca mejor la becàbini cą Jesús nna ra cą ne: Labí yù tu'. Làniana becàbi Jesús nna rèe cą: Nihua inte' nna labí quixá'ania' le nuỹa benna la'huacca quia' acca runia' ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Làniana guduló Jesús gunènie cą por medio de comparación nna rèe: Gùdua ttu ènne'yu' nna gùdà bi planta qui' betsulí' le' loyu qui' bi. Bedeqquia tè bi ą li'ya, ą'hua guleqquia tè bi ttu pozo làti guxàtta cą iqquia betsulí'a para cueqquia cą inda quì'į. Ą'hua bedu tè bi ttu torre para tsappi bi hué' bi cuidado loyu làti guda bi betsulí' qui' bi a: Làniana bète sáte bi lóyúa lani canu guni cą na tsina. Làbi nna guda' tè bi dia bi idittu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","De chi gùl·la' tiempo cosecha qui' betsulí'a nna, guthel·la' bi ttu mozo lani canu runi tsina le' lóyúa para qui'ni edi'ą fruto nu ná qui'ni thí' bi qui' loyu qui' bi a. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero canu runi tsina le' lóyúa nna bedaxu' la cą enne' guthel·la' bi a. Yala idí' bè' cą na, bethel·la' tè cą nna, bittu tení biỹa bete cą éyu'ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Bedethèl·la' gáabá bi attu mozo, pero làcą nna gutèl·la' lá cą íyya na bè' cą iqquia niá nna bethel·la' tè cą na ttú ruduadí' ba cą na. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Làniana xana' lóyúa nna bedethèl·la' bi adí iỹé cą, pero bè' huá cą ttu te ą'hua attu te cą nna betti cą cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Por último nna guthel·la' bi propio gani ỹi'ni bi enne' yala catsi'íni bía nna ra bi: Huappa cà'abá cą respeto ỹì'ni yì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero canu runi tsina lóyúa nna gulù'u titsa' luetsi quį nna ra cą: Lá nui nuą' eyà'ną ituba lóyúį, acca lítsa' gutti ri'u ą para qui'ni ccá qui' ri'u itute nu reda' latsi' tàta qui' niá na. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Acca bedaxu' chì cą ỹi'ni bía nna betti cą bi, bedal·la tè cą cuerpo qui' bía fuera lóyúa. Ą' beni cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Acca, biani guni propio gani enne' ná xana' lóyúa canchu chi él·lani bi cá. Pues gul·lùỹa bi latsi' canu betèsa bi lóyúa nna, gutèsa tè bi ą lani canu huaya' la. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Beni ba Jesús seguir gunnie nna rèe: Tsí nihua nì' gúl·la le lo Escritura làti ra: Iyya nu labí guyú'u latsi' canu rucùà' yú'a nna, chi ną́ íyya principal nu adila tsìttsì naxu'ą yú'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","La'a mismu gani Señor Dios chi benie nui, ną́ ttu cosa nu dacca' iquila' báni latsi' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Làniana uccua latsi' quį gudaxu' cą Jesús, porqui'ni gutelíni cą qui'ni contra làba quį nuá gutixe'e ejémplua. Pero gutsi báni cą biỹa guthacca' ca enne' yétsia cą, acca adila tsa' betse'e bá latsi' quį ne nna bedà' cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bitola nna guthel·la' cą tuchùppa ca fariséua lani canu gulání partido qui' Herodes ru'a lo Jesús para canchu xiaba uquìnnia cą ne lani ttu titsa'. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bitsina' tè cą nna ra cą ne: Maestro, hua yùba tu' qui'ni rulue' cuią'lu' tsua' teruba nu ná lí, labí rátsini cuią'lu' nu rena ca enne'; porqui'ni nihua labí rucué'ni cuią'lu' ca enne' según ná la' rinna' qui' quį, sino tturú'a taá cani cuią'lu' cą nna riquixa'a cuią'lu' lo néda lí gani qui' Tata Dios. Gutixà'ani cuią'lu' intu': Tsí hua ná tsè' quiỹa ri'u nu ruthítsini gobierno qui' César ri'u, o tsí bihua áccá. Tsí gute tu' ą, o tsí bíttuá áccá. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero Jesús nna gutelí taánie qui'ni álahuá tsè'ni cą ra cą anía, acca becàbinie cą nna rèe: Biecca calatsi' le guni le inte' prueba canchu xiaba ecàbia' ttu titsa' nu labí ná tsè' ni'i. Litahua' tsánna bel·liu para qui'ni inna' ya' ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Làcą nna betsia tè cą ttu moneda ru'a lúe. Lèe nna rèe cą: Nuni retrato quí'ní nui dua lo monedį nna, ą'hua nuni láa ní nui dua nì. Becàbi cą nna ra cą ne: Qui' César enne' romano ná rey. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Làniana ra tè Jesús cą: Entonces líúte ba qui' César nu ná qui' César, ą'hua líúte ba qui' Tata Dios nu ná para lèe nna. Làcą nna yala biquila' latsi' quį por nu becàbie. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Làniana bitsina' tè ca saducéua ru'a lúe. Làcą nna rena cą qui'ni labí posible té qui'ni canu yatti nna eyatha cą nna eyaccabàni cą attu, acca gunàba titsa' tè cą ne nna ra cą: ");
INSERT INTO zaaNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Maestro: Moisés enne' gùdua tiempo antigua nna bethà'na bi ley lani ri'u nna ra bi qui'ni canchu nuỹa ttu enne' gatti ttu bettsi'į nna pero lanú ỹi'nį uccua, entonces ná qui'ni guttsa taání'į lani niuláa para qui'ni elìthą descendencia qui' bettsi'į nu gúttía. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pues gutsé'e gàtsi bettsi' ca enne'. Bettsa tená' nu néruá nna, pero gùttì bą́ nna lanu ỹi'nį uccua. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Làniana nu cca chuppáa nna bettsa huání'į lani niuláa, pero gùttì huá nubeyu'a nna nihua lanú ỹi'nį uccua. Ania tehua uccua lani nu cca tsunnáa, ");
INSERT INTO zaaNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","hàstaá qui'ni iyaba canu gàtsi bettsi'a gùdua lani cą niuláa nna lanú ỹi'ni quį uccua. Bitó tè nna gùttì huá niuláa. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Acca, canchu chi gal·la' tsá eyátha canu yatti nna eyaccabàni cą attu nna, núlá ca nuá ccá quì'į niuláa cá, yàqui'ni iyaba ca gàtsi bettsi'a nna bettsaná' quį lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Becàbi tè Jesús nna rèe cą: Yala ridacca'ỹí le, porqui'ni labí ritelíni le nu ra lo Escritura, nihua la' huacca qui' Tata Dios nna labí ritelíni li ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Porqui'ni canchu chi gal·la' tsá eyátha canu yatti nna, lanuru nuỹa guttsaná' porqui'ni iyaba cą nna ccá cą tì'a ca ángel tsè'e ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pero acerca de canu yatti ná qui'ni eyátha cą de lo lù'uti nna, tsí bihua nì' gúl·la le lo Escritura qui' Moisés loti' gunèni Tata Dios bi dèsdeba le' ttu tìttsa yèttse' nu ritèlal·laní nna rèe: Inte' ná' Dios qui' lu' ą'hua qui' ca ta' enne' gùla qui' lu' Abraham nna Isaac nna Jacob nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Acca nia' le qui'ni nì nna ritelíní qui'ni ą'hua ca enne' chi gùttì nna bàni bá cą nna runi bá cą Tata Dios adorar. Acca yala equivocado ga'na le. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Làniana gubíga' tè ttu maestro de la ley. Chi biyéninią nu beni cą discutir lani Jesús ą'hua qui'ni yala tsè' becàbinie cą, acca gunàba tìtsa'ą ne nna rą: Biani mandamiento ní ná nu adiru dacca'. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Becàbi Jesús nna rèe na: Mandamiento nu adiru dacca' de lo iyaba cą nna ra íį: Lu' yetsi Israel, bedà naga' lu' níyi'į: Señor Dios qui' lù'a nna ttu terúbée rigú'ubia' lo iyate; ");
INSERT INTO zaaNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","acca cátsi'íni lu' Señor Dios qui' lu' lani itute losto' lu', lani itute la' rulábalatsi' qui' lu', lani itute latsi' lu', ą'hua lani itute fuerza qui' lu'. Lá nui ná mandamiento nu adiru dacca'. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ą' tegáahuá ná mandamiento nu cca chuppáa: Cátsi'í huáni lu' iyaba ca luetsi enne' lu' ti'atsi la'a lù'ba. Labí attu mandamiento té nu adiru dacca' tì'chu ca nui. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Làniana nu ná maestro de la ley nna rą Jesús: Maestro, yala tsè' rinne cuią'lu', hualibani cuią'lu' qui'ni ttu terúbá Dios ná, lanu attu Dios té fuera de lèe. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ą'hua para cátsi'íni ri'u e lani itute losto' ri'u, lani itute la' rulábalatsi' qui' ri'u, lani itute latsi' ri'u, lani itute fuerza qui' ri'u nna, ą'hua para cátsi'íni ri'u iyaba ca enne' ti'atsi la'a ri'u ba nna, pues adírulá tsè' para guni ri'u ca nui tì'chula iyaba ca sacrificio nu rutsia ri'u lo altar o bíỹaáru ca ofrenda ni l·le rute ri'u para Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","De biyénini Jesús qui'ni yala lani razón becàbią, acca rèe na: Ati'to' taá reyàtsa para ccá lu' pertenecer le' reino qui' Tata Dios. Làniana lanuru nuỹa beyáỹani inàba tìtsa'ą ne adí. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Beni ba Jesús seguir gutixe'e ca enseñanza nu cca qui' Tata Dios le' templua nna rèe: Ti'ani modo acca rena ca maestro de la ley qui'ni Cristua nna née Ỹi'ni David enne' uccua rey, ");
INSERT INTO zaaNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","atsi'íni la'a mísmuba David gunne bi acerca de lèe por la' riyeni tsè' nu bete Espíritu Santo qui' bi nna ra bi: Señor Dios nna gunènie Señor quíya'a nna rèe: Gùduani cuittá'a' lado bàni, Hasta qui'ni gúnna' latsi' ná' lu' iyaba canu làa cca guyu cą lu', Para qui'ni gúl·liani lu' iqquia quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Acca nia' le qui'ni por ca tìtsa'a nna yù ri'u qui'ni la'a mísmuba David nna reya bi Cristua SEÑOR. Entonces ti'ala modo acca née Ỹi'ni David, pero runi la David ne adorar cá. De ra Jesús anía nna, acca ca enne' ỹétse'nía nna adírulá guyú'u latsi' quį gudà naga' quį quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús nna gutixà'anie cą attu enseñanza nna rèe: Líhue' cuidado lani ca maestro de la ley, porqui'ni labí ná tsè' la' rulába latsi' qui' quį. Yala rú'ulatsi' quį cueni cą lo ca néda lani ỹó tuni quį para qui'ni gulaba latsi' ca enne' qui'ni yala enne' re' cuenta ná cą, ą'hua yala ru'u latsi' quį gappa ca enne' ỹetse' cą titsa' de reqquia cą lo neda. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yala rú'ulatsi' quį xúaní cą lo ca asiento dàa íqquiará' tè le' ca sinagoga ą'hua canchu chi ral·la' fiesta qui' quį nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Rigua cą ca interés nu te qui' ca niula viuda nna runi tè cą oración tuni tsè' ru'a lo ca enne' para gulue' cą ti'atsi yala enne' lí ná cą. Làcą nna yala fuerte ná castigo thí' cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ttu vuelta nna re' Jesús le' templua èxaba làti tsìa caja làti rigú'u cą ofrenda. Rinna' tìe ca enne' ritsina' rigú'u cą bel·liu le' cájaá. Iỹetse' cą nna yala rico ná cą, iỹeni tsè' ofrenda rute cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Bitsina' tè ttu niula pobre ną́ viuda nna, gulu'ą chuppa moneda nu de cobre dacca' cą ti'to' terúbá. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Gutàỹi tè Jesús ca discípulo qui'áa nna rèe cabi: Hualigani te' riquixa'ánia' le qui'ni niula viúdį nna rittią là'di', pero adila iỹeni ofrenda betią para Tata Dios tì'chula iyaba canu rigú'u bel·liu le' cáją'. ");
INSERT INTO zaaNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Porqui'ni iyaba ca nua' nna bete cą nu rexabáni cą, pero niulíį nna màsqui'ba rittią là'di' pero bete lą́ itute hàstaá nu ná góníą. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","De beria Jesús le' templua nna ra tè ttu discípulo qui'áa ne: Maestro, gunna'áruhuá cuią'lu' ti'iỹa èl·la ná ca iyyą' ą'hua ti'iỹa latsite cua' ca edifíciuą'. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Becàbi tè Jesús nna rèe bi: Tsí hua rilá'ni lu' ca edificio ti'iỹa xeni ná cą; pero i'yu tsá qui'ni labí eyà'na iqquia luetsi ca íyya xeni nu cuáa'ní templuį, porqui'ni hual·lani canu da' idittu' nna guthìnnia gutappa'ní cą iyáỹiate cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Huía tè cabi lo i'ya láą Monte de los Olivos nu dua frente taá templua. Nía nna gure' tèni Jesús. Làniana Pédrua nna Jacóbua nna Juáan nna Andrés nna gunàba titsa' cabi e yà'ba latsi' nna, ");
INSERT INTO zaaNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ra cabi e: Calatsi' tu' quixá'ani cuią'lu' intu' cuaỹa ccá ca cosį, ą'hua biani señal ni ilá'ni tu' para ccá tu' saber ántesca thulo iyaba ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Becàbi tè Jesús nna rèe cabi: Líhue' cuidado qui'ni nú ttu nuỹa guthacca'ỹíą le. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Porqui'ni nuỹetse' íl·lani lani nombre quia' nna ina cą qui'ni làcą nuá Cristua. Anía modo nna ca enne' ỹetse' guthacca'ỹí cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Canchu chi iyénini le ina cą qui'ni da' guerra nna bittu gátsini le, nihua canchu ina cą qui'ni chi cca guerra nna. Porqui'ni náduel·la' cca ca cosį, pero nìhuani labí chi gùl·la' tè fin. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Porqui'ni ttu nación nna til·lą contra attu nación ą'hua ttu gobierno contra attu gobierno nna. Ą'hua iỹé lettia tsè' tté la' riỹú', íl·lani huá ubina' nna ą'hua yala alboroto ccá. Ca cosį nna ná cą nu chì' thulo rubání ca dolor. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Lihue' cuidado por la'labàni qui' le, porqui'ni gute cą le cuenta lani ca uxticia, ą'hua le' ca sinagoga qui' quį nna hué' cą le lani cuarta. Pues hàstaá ru'a lo ca gobernador nna ą'hua ca rey nna tahua' cą le porqui'ni ríalatsi' le inte'. Ą' modo nna gute le ttu testimonio tsè' lani cą acerca de inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Antesca íl·lani fin nna náduel·la' qui'ni yà'laỹa ccá predicar evangelio lani iyáỹiani ca enne' le' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Canchu chi iche' cą le para gute cą le cuenta lani ca uxticia, bittu nùyue ccani le ti'iỹa ecàbi le, nihua labí gulaba xàttàga latsi' le nna. Sino ca titsa' nu etsèla latsi' le la'a mísmuba hóraá nna nuá bá ina le. Porqui'ni álahuá lebi'į nuá inne, sino Espíritu Santo bá ínnie por medio de lebi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ttu bettsi' nna gutią cuenta la'a bettsi' bíį para gattią, ą'hua ttu tàta nna gutią cuenta la'a ỹi'ni bíį, ą'hua ca ỹí'niá nna eyeqquia cą contra ca tàta nàna qui' quį hàstaá qui'ni gutti cą cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Iyaba cą nna guyudí' cą le porqui'ni ná le ca enne' ruthète' quia'. Pero nu thú bá tsìttsì lani inte' hàstaá fin nna, lànuá nna l·lą́. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Pero canchu chi ilá'ni le nu gunią nu ccaba latsi'į lugar làti labí ná qui'ni thúą, tì'a chi gutixa'a Daniel enne' uccua profeta (nu rul·la nna hue'él·la' latsi'į télinią), làniana canu tse'e le' región qui' Judea nna ucuìtta cą tsía cą lo ca ló'ya lá. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nuỹa tediba duą iqquia azotea qui' yú'u quì'į nna, eyàdią nna ucuìtta tabą́, bittu éya'ą le' yú'u para thí'ą biỹa té quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ą'hua nu reni fuera lo tsina quì'į nna, bittu eyeqquią litsi'į para gutuppą ca ỹúį, sino ucuìtta tabą́. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pero canchu chi gal·la' tsá nna ica'rútsi'íru ca niula nu nùà' huatsa to', ą'hua canu rugátsi' ỹi'ni quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Acca línàbani Tata Dios lani oración qui'ni canchu chi gal·la' tsá ucuìtta le nna bittu ccą́ tiempo idil·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Porqui'ni canchu chi gal·la' tsáa nna íl·lani ca sufrimiento fuértení nu labí nì' cca dèsdeba gùre' yétsiloyu hàstaá tiempo tsè'e rí'uį, nihua làa ccá ruhuą́ bitola nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Cáalá Señor nna labí gudàttsi'e ca tsá tiempo qui' ca sufrimiento nu chì' da'la nna entonces lanú nuỹa l·lą́. Pero por la' retúalatsi' quì'e lani canu chi becuí'e nna, acca gudàttsi'e ca tsáa. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Làniana canchu nuỹa gą́ le: Linna' tsaruhua nì du Cristua, o, línna' tsáruhuá nà' taá dùe, bittu tsíalatsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Porqui'ni hual·lani làti tsè'e le canu ina cą qui'ni làcą nuá Cristua ti'a adí canu ina cą qui'ni rinne cą parte Tata Dios, pero labí líni cą. Làcą nna guni cą iỹé ca milagro nna ą'hua adí cosa de la' huacca nu ccáỹíni latsi' ca enne' para qui'ni gurèxaèl·la' cą cą xiaba hàstaba canu chi réeé'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ca nui riquixa'ánia' le con tiempo bá. Acca lítsé'e al tanto. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Cuantu taání tté sufrimiento qui' ca tsáa, làniana bitsą' nna echùl·lą, ą'hua biuá'ą' nna labiru gudàni'ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ca bélia nna ìnnia cą de ỹiaba, ą'hua iyaba canu tsìa ỹiaba nna tatìttiní cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Làniana ilá'ni cą Nubeyu'a íl·lanie le' bía lani la' huacca nna lani itute la' yani' de ỹiabara' nna, ");
INSERT INTO zaaNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ithel·la' tabée ca ángel quì'e nna gutùppa cabi iyáỹiate ca enne' reé'nie le' iyábani lugar qui' yétsiloyu, dèsdeba làti ril·lani bitsa hàstaba làti renią. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Litelíni comparación qui' yexxuhuía: Canchu rerè'ne lúį nna rebia ca l·la' quì'į nna, anía modo ccá le saber qui'ni chì'taá duą íl·lani tiempo verano. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ą'hua lebi'į nna, canchu chi ilá'ni le cca iyaba ca cosa nu chi riquixa'ánia' le nna, entonces ccá le saber qui'ni chì'taání duą íl·lani fin. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Hualigani te' nia' le qui'ni labí tté ca enne' tsè'e tiempo de ca señal nì ántesca thulo cca cumplir iyábani ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ỹiaba nna yétsiloyuį nna l·luỹa bá latsi' quį, pero ca titsa' quíyi'į nna labí tté cą sino té qui'ni iyate cą ccá cą cumplir. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Lanú nuỹa yù biỹa tsá ní nihua biỹa hora ní, sino làteruba Tata Dios nna yùe; nìdirubani Ỹi'ni Tata Dios labí yù bi, nihua ca ángeli tsè'e ỹiabara' nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Acca lebi'į nna lítsé'e al tanto, líhue' cuidado nna, lígúni oración, porqui'ni labí yù le cuaỹa tegá i'yu tsá nna i'yu hora nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nu níyi'į nna ccą comparar ttu enne' dia bi idittu'. Bethà'na bi yú'u qui' bía nna beni bi disponer tsina qui' ttu ttu tsa quį nna, bedu tè bi ttuą ru'a yú'u qui' bía para huí'ą cuidado hàstaá qui'ni él·lani xana' niá. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Acca lebi'į nna, lítsé'e huá al tanto. Porqui'ni labí yù le cuaỹa él·lani xana' lía. Xiaba él·lanie chì' uccua taá yèlà, o ttu ríluela, o xiaba ttu ribetsi béra, o ttú la' dá' rànì' taání l·le. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Porqui'ni xiaba niyyani latsi' le él·lanie, alàa ti'éthi la le sino ribèda li e. ");
INSERT INTO zaaNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nu riquixa'ánia' le nna níya' ą para iyáỹiani ca enne': Lítsé'e al tanto. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Achuppa ubitsa teruba reyatsa para gal·la' tsá pascua fiesta qui' ca enne' Israel canchu chi ro cą ettaxtíla sin levadura. Làniana ca sacerdote principal qui' quį ą'hua ca maestro de la ley nna gulú'u titsa' luetsi quį tì'iỹalá guni cą gudàxu' cą Jesús lani maña ba para gutti cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ra cą: Alàa tsá gani fiéstą' gudàxu' ri'u ą preso, para qui'ni làa ilá'ni ca enne' ỹetse' nna chatha alboroto le' ciudíį. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús nna ri'e le' yetsi Betania litsi' Simón enne' huì'ni yetsu' yùtsu'a. De duaníe lo meỹa nna bitsina' tè ttu niula nù'ą ttu frasco tsíttsi to' tà'a lì'ì puro perfume nu rilàa' iỹixi nu dacca' yaỹi tsè'. Gùl·la'a tìą yáni fráscuá nna bedua tìą perfúmea iqquia Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tuchùppa canu tsè'e nía nna liú'u latsi' ba quį bitsa'áni cą nna ra cą: Biecca uccua tittia perfúmeą' ni'i; ");
INSERT INTO zaaNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","porqui'ni nui nna huatsitò'o telą́ téelá tsunna gayua' denario para guni ri'u cualani ca enne' rittè là'di'. Acca yala betìtse'èl·la' cą niuláa. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero Jesús nna rèe: Lihue'èl·la' ą. Biecca ritsa' li ą, pues lą nna chi benią ttu obra tsè' por inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ca enne' pobre nna tulidàba tsè'e cą lani le; cuaỹa calatsi' le guni le para làcą ttu cosa tsè', huacca bá. Pero inte' nna álahuá tulidà rénia' lani le. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Niulíį nna benią nu uccua rubánią gunią, porqui'ni con tiempo ba beduą perfume cuerpo quia' nna benią inte' preparar para canchu chi igàttsi'a'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Hualigani te' nia' le qui'ni gaỹa tediba ccá predicar evangéliuį le' itúbani yétsiloyu nna, guna huá ca enne' nu beni niulíį. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Làniana ttu canu tsì'nua láą Judas Iscariote nna huíą ru'a lo ca sacerdote principal para gunią trato lani cą nna gutią Jesús cuenta latsi' ná' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Làcą nna de biyénini cą nu ra naá nna yala bedácca'ni cą beni cą ofrecer gute cą bel·liu quì'į. Acca guduló taá Judas beyìla latsi' ti'iỹa modo gutią ne cuenta. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Primero tsá fiesta loti' ro cą ettaxtíla sin levadura nna rutti cą carnero para go cą nna para exa latsi' quį primer pascua qui' ca ta' tàta qui' caniá, entonces ca discípulo qui' Jesús nna ra cabi e: Gani calatsi' cuią'lu' tsá' tu' para guni tu' preparar go se' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Làniana guthèl·la' tìe chuppa ca discípulo qui'áa nna rèe cabi: Lítsía le' ciudą', nía nna etsa' le ttu nubeyu' dénú'ą ttu ré'e inda, tanó tè li ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Làti éya'ą nna línneni xana' yú'a nna gá li ą: Maéstruá nna guthèl·le'e intu' nna rèe: Gani nua' dua ttu cuarto làti ná qui'ni go sía' lani ca discípulo quíyi'į nna guni tu' celebrar páscuį. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Lą nna gulue' taánią le ttu cuarto xeni nu chìa dualéda bą́, duą íqquiará' la porqui'ni yú'a nna ną́ nu chuppa cua'. Nía nna lígúni preparar se' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ca discípuluá nna huía cabi le' ciudáad nna taxácca' cabi tì'a nu chi rèe cabi e. Nía nna beni cabi preparar para guni cabi celebrar pascua. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","De gùl·la tsá lània nna, bitsina' Jesús lani tsì'nu ca discípulo qui'áa. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","De chi ỹuàni cabi lo méỹaá nna hua ro canna bá cabi nna gunne Jesús nna rèe: Hualigani te' riquixa'ánia' le qui'ni nuỹa la ttu le nù ro lani inte' nna gutią inte' cuenta latsi' ná' canu labí cca guyu cą inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Làcabi nna yala triste ùccuanì cabi. Guduló ttu ttu tsa cabi nna ra cabi e: Tsí inte' cá. Attu bi nna ra bi: Tsí inte' áccá. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Becàbi tìe nna rèe cabi: Nuỹa ttùba le nu rugà'a ettaxtíla quì'į lani inte' le' plátuį, lą nua' gutią inte' cuenta. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nubeyu' de Ỹiabara' nna hualigani ccá bá cumplir iyate nu ga'na escrito nu cca quì'e ti'iỹa ná là' ritè quì'e, pero ica'rútsi'íru nu runią ti'atsi ną́ amigo quì'e pero labí línią; para lą nna adila tsa' cáalá bittu telá gùlią. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","De chi ro cabi ttu te là'goá nna, guỹi' Jesús ettaxtílaá nna bì'e ca discípulo qui'áa nna rèe: Ligò, nui nna ną́ cuerpo quia'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Làniana beditsè'e ttu vaso. De chi bì'e gracia Tata Dios nna betie qui' cabi. Iyaba cabi nna gù'yà cabi le' ttùba vásuá. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ra tìe cabi: Nui nna ną́ réni quia' para qui'ni ccá seguro promesa cubi nu runia', para ca enne' ỹetse' ilàlia réni quia'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Hualigani te' riquixa'ánia' le qui'ni labiru í'yá' inda qui' betsulí' hasta qui'ni i'yu tsá í'yá ya' ą attu lani le le' reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","De beyacca bil·la cabi hímnuá nna huía cabi lo i'ya láą Monte de los Olivos. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Laniana Jesús nna rèe cabi: Iyaba le nna gútse'e latsi' le inte' nèlà, porqui'ni Tata Dios nna rèe lo Escritura: Inte' nna gútía' permiso qui'ni gutti cą enne' ná Pastor, làniana ca carnero qui' bía nna gathilàlia cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Beni bá Jesús seguir gunnìe nna rèe: Pero bitola de eyátha'a' de lo lù'uti nna, nérua' lo le para etsa' ri'u Galilea attu vuelta. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Làniana gunne Pedrua nna ra bi e: Màsqui'ba iyaba cą gútse'e latsi' quį cuią'lu', pero inte' nna labí. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús nna ra tìe bi: Hualigani te' riquixa'ánia' lu' qui'ni nèlà nna tsunna vuelta labí thí'ché' lu' qui'ni nabia'ni lu' inte', làniana cuetsi xcurúdia. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedrua nna adila tsìttsì beni bi sostener nna ra bi: Màsqui'ba canchu caduél·la' gatti huá' lani cuią'lu', pero labí ínníá' qui'ni labí nabia' te' cuią'lu'. Anía tehuá ra iyaba ca discípuluá. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Làniana betsina' cabi ttu lettia láą Getsemaní nna rèe ca discípulo qui'áa: Nì bá líxuani làca'te tsa'á' gunia' oración. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Guche' tìe Pédrua nna Jacóbua nna Juáan nna. Làniana guduló ùccuanì triste latsi'e nna tsì'irúbá ùccuanìe. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Rèe cabi: Yala triste cani latsi' lóstu'a' ti'atsi chì' taání rattia'. Nì bá licuèda inte' nna bittu gá'athi le. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Guda' tìe áti'to' tè nía lá nna, beduỹíbie nna benie oración, gunàbèe canchu hua ná posible qui'ni bíttuá quée sufrir nu ná qui'ni ttíe hóraá. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","De chi runie oración nna rèe: Tata Ỹitsi', iyá ỹíábá ná posible para cuią'lu', gùtua cuią'lu' sufrimiéntuį lani inte', pero alàa tì' cabá látsa'a' sino ccábá según voluntad qui' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Beyeqquia tìe làti tsè'e ca discípulo qui'áa nna ti'éthi bá cabi, acca rèe Pedrua: Tsí nihua ttu hora rúbá làa bechia tí' lu' bétsiala para guni lu' inte' acompañar cá, Simón. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Lítsé'e al tanto, lígúni oración para qui'ni làa ìnnia le le' tentación. Hualígáláa yala dispuesto ná le ccá le enne' fiel lani inte', pero labí fuerza té qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Huíe attu nna benie oración, rèe la'a mísmuba ca tìtsa'a. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","De betsine'e attu nna dedeti'éthi huá cabi attu, porqui'ni tsa'tí'bání bétsiala lo cabi, nihua làa yù cabi biỹa ecàbini cabi e. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Betsine'e nu cca tsunna vuelta nna rèe cabi: Tsí àtsabá ti'éthi le. Chi dacca'. Chi gùl·la' hora qui'ni Nubeyu' de Ỹiabara' ttíe latsi' ná' canu tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Léyátha nna léya'. Linna'áruhuá chi da' nu gunią contra inte' lani la' ruthacca'ỹí. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Atsabá rinne Jesús nna gul·lani chì Judas nu uccuą ttu discípulo quì'e entre ca enne' tsì'nuá. Ą'hua iỹétse'ní ca enne' da' lani ą yù'u ná' quį espada l·le yà l·le. Làcą nna da' cą por orden qui' ca sacerdote principal nna ca maestro de la ley ą'hua por canu rigú'ubia' le' yétsiá nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas nu gutią ne cuéntaá nna gutixa'ą ti'iỹa ná seña nu gunią nna rą: Nu gutsa'lo ya'a nna, lą nuá, lebi'į nna gudàxu' tabá li ą, eche' li ą nna guyu le qui'ni làa l·lą́. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Bitsina' bą́ nna gubiga' taą́ ru'a lo Jesús nna rą ne: Maestro, Maestro. Làniana betsa' tè lúį ne. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Làcą nna bedàxu' chi cą Jesús preso. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ttu enne' entre canu tsè'e lani Jesús nna gulèqquia bi espada qui' bía nna becàa ná' bi nna bè' bi huenitsìna qui' nu ná huexána' qui' ca sacerdótea nna guchu bi yeti nagui'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús nna rèe cą: Tsí tì'a canu dia gudàxu' ttu ubàna da' le yù'u ná' le espada nna para gudàxu' le inte' preso cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ttu ttu tsá bá gùri'a' le' templua nna gutixa'ánia' iyaba le nu cca qui' Tata Dios, atsi'íni bihua bedàxu' le inte'. Pero íį bá chi ná para qui'ni ccá tì'a ra lo Escritura acerca de inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Làniana iyaba ca discípuluá nna bétse'e latsi' cabi e nna becuìtta cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Denó tè ttu nubeyu' cuìti' ne tétsíą ttu sábana. Làcą nna bedàxu' huá cą na preso. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero lą nna birią le' sábanaá nna becuìttą, labí ỹúį nàccu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Làcą nna guche' te cą Jesús ru'a lo huexána' qui' ca sacerdótea. Làniana betùppa iyaba ca sacerdote principal nna ca maestro de la ley nna, ą'hua adí canu rigú'ubia' entre ca enne' judíua nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedrua nna idittu' bá denó bi e hàstaá le' lí'a ru'a yú'u qui' huexána' qui' ca sacerdótea. Nía nna gure' tè bi huèttsà'a cuítta' yi' lani ca policíaá. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Làniana ca sacerdote principal lani iyaba canu retùppa Junta Suprema qui' ca enne' judíua nna reyìla cą ttu causa contra Jesús para qui'ni gappa cą néda gute cą ne cuenta para gatti e, pero labí betseláni cą causa lí gani còntre. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Màsqui'ba iỹetse' cą gulìtha cą bela'na quì'e pero yétsi' yétsi' bá rena ttu ttu tsa cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Làniana gudulí tè tuchùppa cą nna gunne cą ca titsa' falso contra lèe nna ra cą: ");
INSERT INTO zaaNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Chi biyénini tu' qui'ni gunnią nna rą: Inte' nna gutáppa'a' témpluį nu bénibàni ca enne', pero le' tsunna ubitsa teruba nna echítha'a' attu templo nu labí ccáni ca enne' guni cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero nìhuani anía nna álahuá ttùdi gunne cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Làniana gudulí tè huexána' qui' ca sacerdótea nna gunàba tìtsa'ą Jesús nna rą: Tsí bihua biỹa ecàbi tí' lu'. Biani nua' ra cą contra lu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús nna tsi bá dùe, labí biỹa becàbie. Acca huexána' qui' ca sacerdótea nna gunàba titsa' tìą ne attu nna rą: Tsí ná lu' Cristo Ỹi'ni Tata Dios Tsùna'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús nna rèe na: Là inte'. Ą'hua i'yu tsá ilá'ni le Nubeyu'a duánie lugar de la' dàliani qui' la'huacca qui' Tata Dios nna íl·lanie lo bía ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Làniana huexána' qui' ca sacerdótea nna guchèda'ní ỹúį para gulue' qui'ni yala bitsa'ánią nna rą: Biáruálá testíguní riquína'ni ri'u cá, ");
INSERT INTO zaaNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","chi biyénini le ca titsa' mal quì'į contra Tata Dios, ti'atsi ną́ tulappa bá lani e. Annana biani ína le ccá quì'į cá. Iyaba cą nna biria cą còntre para gattie. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Làniana guduló ttu te cą nna betùtu xèni' quį ne. Bethàya tè cą lúe lani ttu lári', làniana bè' cą ne puñete nna ra cą ne: Guna tsanna nuỹa nua' bi'ą lù'na. Ca policíaá nna gutìni ná' quį lúe. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedrua nna re' ba bi le' lí'a ỹàrèe'. Bitsina' tè ttu criada qui' huexána' qui' ca sacerdótea. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","De bilá'nią Pedrua qui'ni du bi cuè'e yí'a, acca gunna' tsì'ą bi nna rą: Ą'hua lu' nna gurèni huá lu' lani Jesús nazarénoą'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedrua nna labí guỹí'ché' bi nna ra bi: Labí nabia' te' bi, nìdi làa yúá' biỹa nuą' ra lu'. Biria tè bi fuera ru'a zaguán. Làniana guretsi xcurúdia. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Criádaá nna bilá'nią bi attu vuelta nna rą canu tsè'e nía: nubeyu'į nna gulání huą́ ca nuą'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedrua nna ra bi attu qui'ni labí nabia'ni bi e. Ti'to' taá bitola nna canu tsè'e nía nna ra cą Pedrua attu vuelta: Hualigani qui'ni ą'hua lu' nna ná lu' enne' qui' quį, porqui'ni ná lu' enne' Galilea, ą'hua là' rinne qui' lu' nna ttùba ną́ lani làcą. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Làniana beni chì Pedrua maldecir nna beni bi jurar nna ra bi: Labí nabia' te' nubeyu' nu ra líą'. ");
INSERT INTO zaaNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Luégutaá gurètsi xcurúdia cca chuppa vuelta. Làniana bexa tè latsi' Pedrua ca titsa' nu gunne Jesús loti' rèe bía: Antesca cuetsi xcurúdia chuppa vuelta nna, guni lu' inte' negar tsunna vuelta. De bexa latsi' bi ca titsa' qui' Jesús, làniana yelia yelia ní guretsi bi. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","De da' ràni'a nna betùppa ca sacerdote principal lani ca maestro de la ley ą'hua lani iyaba ca autoridad qui' ca judíua nna, bexìqquia cą Jesús nna guche' tè cą ne nna bete cą ne cuenta lani gobernador Pilatua. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatua nna gunaba tìtsa'ą ne nna rą: Tsí ná lu' rey qui' ca judíuą' cá. Becàbie nna rèe na: Lù'ba chi ra ą́'. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ca sacerdote principal nna betsia cą iỹetse' queja contra lèe. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Acca gunàba titsa' tè Pilátua ne attu vuelta nna rą: Tsí bihua biỹa ecàbi lu', bedaáruhuá naga' lu' iyaba ca queja ribèqquia cą qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero Jesús nna nìhuani labí becàbie, acca Pilátua nna uccuaỹíibá latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tsá gani fiesta qui' ca judíua nna té costumbre qui' gobernador Pilatua gúla'ą ttu preso, nuỹa tediba inàba enne' yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Méruá lània nna té huá ttu nu huetti enne' litsi' ìyyà láą Barrabás, ą'hua adí canu uccua cą rebelde contra ca uxtíciá nna gutìl·la cą nna betti cą enne'. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bitsina' tè canu ỹétse'á nna gunàbani cą Pilatua qui'ni gunią tì'a ná bá costumbre quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Gunàba titsa' Pilatua cą nna rą: Tsí hua calatsi' le gúlá'a' nubeyu' ná Rey qui' lebi'i ca enne' judíuį. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Anía ra Pilátua porqui'ni gutelínią qui'ni por la' yélatsi' bá tahua' ca sacerdote principal Jesús ru'a lúį. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero ca sacerdote principal nna gulù'u yí'ni cą latsi' ca enne' yétsiá qui'ni inàbani cą Pilatua: adila tsa' gúla'ą Barrabás. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Làniana gunàba titsa' tè Pilatua cą attu nna rą: Entonces biani calatsi' le gunia' lani nubeyu' reya le Rey qui' lebi'i ca enne' judíuį cá. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pero làcą nna yala iditsa becàbi cą nna ra cą: Betaá' ą lo curutsi. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ra tè Pilatua cą: Pues, biani mal ni chi benią ni'i. Pero làcą nna adila guretsiyà'a cą nna ra cą: Betaá' ą lo curutsi. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatua nna para qui'ni gudàliani bá enne' yétsiá na, acca bela'ą Barrabás nna benią mandado hue' cą Jesús lani cuarta nna betią ne cuenta para qui'ni gútáa' cą ne lo curutsi. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ca soldádua nna guche' cą Jesús le' lí'a ỹàrèe' palacio qui' gobernador. Nía nna bitùppa iyaba ca soldádua. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Begàccu' tè cą Jesús ttu lári' morado, ą'hua gulù'u cą iqquie ttu corona tíaníą yèttse'. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Guduló tè cą ribétsiyà'a cą ru'a lúe nna ra cą: Viva, Rey qui' ca judío. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Làniana bè' cą iqquie lani yà nna betùtu tè xèni' quį lúe nna beduỹíbi quį ru'a lúe ti'atsi yala titsa' gùppa cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Beni diba cą ne burla nna, bebèqquia cą lári' morado nu náccu'éa nna begàccu' cą ne ca ỹúeá attu. Làniana gulèqquia cą ne nna guche' cą ne para gutá' cą ne lo curutsi. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tiémpua nna bel·lani ttu nubeyu' Cirenéo láą Simón enne' ná tàta qui' Alejandro ą'hua bettsi'į Rufo nna, déda'ą de lo tsina nna, behuà'ni duel·la' cą na curutsi qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Guche' cą Jesús ttu lugar láą Gólgota, titsa' qui' ri'u nna ra: Iqquia Bega' Yatti. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Begù'yà tè cą ne vino chixią mirra, pero labí gú'yèe na. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Betaá' diba cą ne lo curútsiá nna guduló ca soldádua gùl·la'ání cą ca ỹúeá nna bedàl·la cą rifa lo quį para gului'ą nuỹa ca ỹúeá gal·la' ttu ttu cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ttú ritìį gà díla tì'ga nua betaá' cą ne lo curútsiá. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Letrero nu bedia cą biỹa cca té'e nía nna rą: REY QUI' CA ENNE' JUDIO. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Betaá' huá cą lo curutsi ttu ttu lado luítte'e chuppa ca ubana, ttuą lado ná' bànie, attuą lado ná' yattie. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Por anía nna uccua cumplir Escritura làti ra: Belàtsì' huá cą ne entre canu runi mal. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Canu gutté nía nna beduadí' cą ne nna bettá iqquia quį nna ra cą: Eh, lu' nu rena qui'ni gutàppa' lu' témplua nna le' tsunna ubitsa teruba echìtha lu' ą, ");
INSERT INTO zaaNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","pues bedilà la'a lù'ba nna beyàdi tsanna lo curútsią'. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Anía tehuá beni ca sacerdote principal ne burla, ą'hua ca maestro de la ley nna ra luetsi quį: Canu huaya' nna bedilà bą́, átsi'ini la'a labą́ nna labí ccanią gudilą́. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Canchu ilá'ni ri'u Cristo Rey qui' yetsi Israel nà' eyádią lo curútsią' nna, huíyya latsi' ri'u quì'į. Ą'hua canu tá' lo ca curútsiá nna beduadí' huá cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ttú tsì'nu hora tì'ga nna bechùl·la le' itúbani yétsiloyu hàstaá ritìį tsunna. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","La'a mismu taá hóraá nna gunne Jesús idìtsani nna rèe: Eloi, Eloi, lama sabactani; titsa' qui' ri'u nna rèe: Tata Dios quia', Tata Dios quia', biecca betse'e latsi' cuią'lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tuchùppa canu tsè'e nía, de biyénini cą qui'ni rèe anía, acca ra cą: Liúyuúruhuá, Elías bá rul·luítsa'ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Làniana bigàa tè ttuą nna bedibìthą ttu esponja lani vinagre, bedua tìą na lo ttu yíi na bì'ą ne í'yèe, nna rą: Licuèda, inna' ri'u canchu il·lani profeta Elías para echìda bi ą. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Làniana idìtsa tsè' guretsi ya'a Jesús nna gùttie. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Làniataá nna bireda' lári' rriani nu dàa le' témplua nna chuppa l·la'ání uccuą dèsdeba íqquiará' hàstaba ỹàrèe' por milagro qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Capitán nu du guardia fréntetaá làti tá' Jesús lo curútsia, de biyéninią ti'iỹa idìtsa gunne Jesús ántesca gattie nna, acca rą: Hualigani qui'ni nubeyu'į nna ną́ Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Idittu' tí'bá de nía nna tsè'e huá tuchùppa ca niula huenna'. Entre ca niuláa nna látsi' huá María Magdalena, ą'hua Salomé, ą'hua María nàna qui' Joséa bettsi' Jacobo nu cca nu cuìti'a nna. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ca niuláa nna tanó huá cą Jesús loti' gurènie Galilea nna beni huá cą ne servir. Tsè'e huá iỹétse'éru adí ca niula canu beni cą ne acompañar hàstaá Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tsá lània nna runi ca enne' judíua preparar para tsá édi'latsi' quį, acca mérutaá da' ràl·là lània nna ");
INSERT INTO zaaNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","bitsina' José enne' Arimatéa. Uccua bi ttu enne' principal entre iyaba canu rigú'ubia' le' Junta Suprema qui' ca enne' judíua. Làbi nna gulèda huá bi íl·lani la' rigú'ubia' qui' Tata Dios le' yétsiloyu. Lani valor ni gutà'a bi làti dua gobernador Pilatua nna gunàba bi cuerpo qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatua nna yala uccuaỹí latsi'į de biyéninią qui'ni gùttì chì Jesús. Beyàỹi tìą nu ná capitáan nna gunàba tìtsa'ą na canchu là chi gùttìe. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","De chi uccua tsè' Pilatua saber por nu ra capitáan na, betią permiso lani Joséa qui'ni édi' bi cuerpo qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joséa nna huì'i bi ttu sábana tsè'ni nna bechìda tè bi cuerpo qui' Jesús nna betùbi tè bi e sábanaá. Gutìxa tè bi cuerpo qui' Jesús le' ttu bà nu bedua bi le' ttu íyyatò'. Làniana bettsíga' tè bi ttu íyya xeni tsè' ru'a bàa. ");
INSERT INTO zaaNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, ą'hua María nàna qui' José nna, bilá'ni cabi lugar làti gutixa cabi cuerpo qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Guttè diba tsá sábaduá nna, làniana María Magdalénaá lani Saloméa ą'hua María nàna qui' Jacóbua nna huì'i cabi ungüento nu rilàa' iỹíxí para tsía cabi ru'a bàa nna gudua cabi ą cuerpo qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Díla tò'ni primero tsá qui' semánaá huía cabi lo bàa nna bitsina' cabi nía chì' gul·lani taání bitsa. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ra tè luetsi cabi: Nú gání cúą íyya xeni nu yáya rú'a bàa para qui'ni ccá gá'a ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","De bitsina' cabi nía nna gunna' tsè' cabi nna bilá'ni cabi qui'ni íyyaá nna chi bituą ru'a bàa. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","De gutà'a cabi le' bàa nna bilá'ni cabi ttu ènne'yu' re' bi lado bàni, tùbi bi ttu lári' tùnì ní nna tsíttsi tùni nna, yala biquíla' latsi' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Làbi nna ra bi ca niuláa: Bittu gátsini le, hua yúbá' qui'ni reyìla le Jesús enne' Nazaret enne' bétti cą lo curútsia. Chi beyáthèe de lo lù'uti, lanúrué té nì. Litaáruhuá inna' le làti gutíxa cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Acca lítsía nna ligàtsì Pedrua ą'hua adí ca discípulo qui'áa nna, ligàtsi cabi qui'ni tsíe Galilea, nía bá ettsà' iyaba li e tì'ba chi rèe le. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ca niuláa nna bedà' cabi quèthani de lo bàa nna, biỹìtti'ní cabi de tántua gutsini cabi. Lanú nuỹa bè' lani cabi titsa' lo néda de tántua la' rátsilatsi'. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Bitola de beyátha Jesús de lo lù'uti díla primero tsá qui' semánaá nna, primérute María Magdalénaá bilá'ni bi e, niula nu bebèqquie gàtsi ca espíritu malo lo losto' bi. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Làbi nna huía bi taquixá'ani bi ca enne' guréni lani éa. Làcabi nna yala triste ùccuanì latsi' cabi nna ribetsi cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","De biyénini cabi qui'ni María nna bilá'ni bi Jesús qui'ni chi beyaccabànie, pero labí huíalatsi' cabi quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bitola nna de yù'u áchúppa cabi neda dia cabi para yetsi qui' cabi nna bilá'ni cabi Jesús, pero labí bedácca' tènì cabi e. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Huía taá cabi taquixá'ani cabi adí ca discípuluá, pero nìhua labí huíalatsi' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Bitòỹiani nna bilá'ni propio gani tsinia ca discípuluá Jesús loti' ỹuàni cabi lo méỹaá. Gutìl·lèe cabi porqui'ni labí fe té qui' cabi nna yala duro uccua losto' cabi, porqui'ni labí huía tè latsi' cabi qui' ca enne' gutixà'a qui'ni chi bilá'ni cabi e de chi beyáthèe de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Làniana rèe cabi: Lítsía itúỹiani le' yétsiloyu, líquixá'ani iyáỹiani ca enne' ca titsa' nu rulue' ti'iỹa modo l·lá cą. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nuỹa diba tsíalatsi' nna ccą́ bautizar nna, lą nna l·lą́. Pero nu labí tsíalatsi' nna nitti bą́. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Canu tsíalatsi' nna thí' huá cą la' huacca de ỹiabara' para qui'ni lani nombre quia' nna ebèqquia cą fuera ca espíritu malo, ą'hua ínne cą attu te ca titsa'; ");
INSERT INTO zaaNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ą'hua canchu gudàxu' cą ca bèl·là nna labí biỹa thacca' cą, nihua canchu í'ya cą biỹa tì'na chixi veneno nna pues labí biỹa ccáni cą, ą'hua canchu chi gutsia ná' quį iqquia ca enne' ra'ni nna eyacca taá latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Beyacca diba gunèni Señor Jesús cabi, làniana beyàppie ỹiabara' nna, gùri'e lado ná' bàni qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bedà' tè cabi nía nna huía cabi itú lettia taání huequixa'áni ca enne' ti'iỹa modo l·lá cą. La'a mísmuba Señor nna benie cabi cualàni, acca belue'ní qui'ni té la' huacca qui' cabi de ỹiabara', prueba de qui'ni ca titsa' nu gutixa'a cabía nna ną́ titsa' lígani. Ą' uccua.");
INSERT INTO zaaNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nuỹetse' ca enne' chi beni cabi duel·la' gudia cabi en orden historia qui' ca cosa nu hualigani uccua entre ri'u, ");
INSERT INTO zaaNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ti'taání chi nabia'ni ri'u por medio de predicación qui' ca enne' bila'ni ca cosį dèsdeba gudulo uccua cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ą'hua inte', bitola de chi uccua tsì'a' saber acerca de iyaba ca cosį ti'iỹa uccua loti' gudulo cą, acca rú'u huá látsa'a' gùdia ya' cą en orden ba para lu' estimado Teófilo, ");
INSERT INTO zaaNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","para qui'ni gunibiá' tsè' lu' nu ná lígani sobre de nu chi beluè'ni cą lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Loti' uccua Herodes rey le' distrito nu lá Judea nna, gùdua ttu sacerdote le' grupo qui' Abias lá bi Zacarías. Niula qui' bía nna lá bi Elisabet, dá'tia' huá bi dèsdeba le' familia qui' Aarón enne' uccua sacerdote primérute tiempo antigua. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Chuppa taá cabi nna yala èxani gutsé'e cabi lani Tata Dios, gutua cabi iyaba ca mandamiento quì'e nna labí biỹa mal beni cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero lanú ỹi'ni cabi uccua, porqui'ni Elisabet nna uccua bi niula huètsì. Chuppa taá cabi nna chi ná cabi enne' gùla. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ttu vuelta nna de gùl·la' ládi grupo qui' Zacarías para guni cabi tsina nu runi ttu sacerdote tiempo lània para guni cabi Tata Dios servir; ");
INSERT INTO zaaNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","tì'a ná bá costumbre qui' ca sacerdótea nna gùl·la' huá Zacarías gá'a bi le' templo qui' Señor para gudàyi bi tì'a ttu cosa nu ná yàlá'. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Iyaba ca enne' ỹétse'á nna gulèda cą fuera nna beni cą oración miéntraste ral·la' yàlá'á. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Làniana de repente taá gùdu ttu ángel enne' guthel·la' Señor ru'a lo Zacarías lado bàni qui' altar làti ral·la' yàlá'á. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacariías nna bilá' báni bi ángelia, gálá gání tsía bi ùccuanì bi de tántua gutsini bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero ángelia nna rèe bi: Zacarías, bittu gátsini lu'. Chi biyénini Tata Dios oración qui' lu', acca niula qui' lu' Elisabet nna gúditsina' bi ttu nító', quixa lu' lá bi Juan. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yala la' redacca' latsi' gáta'ni lu', ą'hua canchu chi galia bi nna enne' ỹétse'ní nna edacca' huáni cą, ");
INSERT INTO zaaNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","porqui'ni ccá bi enne' ỹeni para lani Tata Dios. Labí í'ya bi vino nihua biỹa licor ni nna. Sino Espíritu Santo nna thúe lani bi dèsdeba ántescala galia bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ą'hua por medio de làbi nna, nuỹetse' ca enne' Israel eyeqquia cą lani Señor enne' ná Dios qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ỹi'ni lu' Juan nna tsía bi lani la'a mísmuba espíritu de la' huacca nu guta' qui' Elías para gútse'e tsè' bi ca tàta lani ca ỹi'ni quį, ą'hua para qui'ni canu cabezudo nna guthete' cą guni cą nu ná tsè' ru'a lo Tata Dios. Anía modo nna guni bi preparar ttu yetsi para guni cą recibir Señor enne' íl·lani bitola. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías nna ra tè bi ángelia: Ti'ani modo tsíalátsa'a' nui ni'i, porqui'ni inte' nna chi ná' enne' gùla, ą'hua niula quíya'a nna yala chi dia ida quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Becàbi ángelia nna ra bi: Inte' ná' Gabriel, runia' servir Tata Dios. Lèe nna guthel·le'e inte' para qui'ni ínnía' lani lu' nna quixa'ánia' lu' ca noticia tsè'. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero annana eyà'na lu' mudo labiru cca inne lu' hàsta'na i'yu tsá qui'ni ccá ca cosį, porqui'ni labí huíalatsi' lu' ca titsa' quíyi'į, pero hui'yu bá tsá ná qui'ni ccá cumplir nu chi gutixa'ánia' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ca enne' yétsiá nna tsè'e bá cą fuera ribèda cą Zacarías, yala nùỹe uccuani cą porqui'ni ritsá bá bi le' templua. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","De beria bi nna labiru uccua inne bi lani cą, acca gutelíni cą qui'ni bila'ni bi nuỹa ttu ángel le' templua. Gunne tènì Zacarías cą puro lani seña ba, puesto qui'ni beyà'na bi mudo. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bedá'a diba tsá nu ná qui'ni guni Zacarías servir le' templua nna, acca beyya bi para litsi' bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bitola de lània nna gutebé'ni niula qui' bía qui'ni nùà' bi huatsa to', acca gùdua bi le' yú'u por gayu' biú' nna ra bi: ");
INSERT INTO zaaNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Por fin nna beni Señor Dios permitir nui lani inte', para qui'ni bíttuúru quiniyu ca enne' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Cca xuppa biú'a nna guthel·la' Tata Dios ángel Gabriel le' región qui' Galilea hàstaá ttu yetsi láą Nazaret, ");
INSERT INTO zaaNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","làti dua ttu niula chì' nábabáni ttu ènne'yu' bi lá bi José. Joséa nna dá'tia' bi dèsdeba le' familia qui' David enne' uccua rey. Niuláa nna lá bi María. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gutà'a tè ángelia làti dua María nna benie bi saludar nna rèe bi: Yala ica'rubà lu', porqui'ni Señor Dios nna dùe lani lu' ą'hua adí bendecir chi runie lu' de lo iyaba ca niula. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pero María de bilá'ni bi ángelia nna uccuaỹí bá latsi' bi por titsa' qui'éa, acca uccuani bi: Biadi' lo acca beni enni'į inte' saludar íį. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Làniana ra tè ángelia bi: María, bittu gátsini lu', porqui'ni chi gùppa lu' favor ru'a lo Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Acca huá' lu' ttu nító' nna; canchu chi itsìne'e nna quixa lu' lée JESUS. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Lèe nna quée enne' ỹeni porqui'ni née Ỹi'ni Tata Dios Tsùna' enne' rigú'ubia' lo iyate nna gunie qui'ni quée rey tì'a ta' tata qui'e David enne' gùdua tiempo antigua. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Lèe nna cu'úbi'e nación qui' ca enne' Israel tulidà taá, ą'hua la' rigú'ubia' quì'e nna nunca labí l·luỹa latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Làniana ra tè María ángelia: Ti'ani modo ccá nui ni'i, porqui'ni labí chi nabia' te' ènne'yu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angelia nna ra tìe bi: Espíritu Santo nna chádie sobre lu' nna íl·lani la' huacca qui' Tata Dios enne' dua ỹiabara', ti'a ttu ỹula làti dua lu'; acca enne' galia nna quée para Tata Dios nna gata' lée Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ą'hua pariente qui' lu' Elisabet enne' reya cą niula huètsìa nna, chi dia para xuppa biú' nùà' bi huatsa to' màsqui'ba chi ná bi enne' gùla. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Porqui'ni labí biỹa té nu ná tàbi para lani Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Làniana ra tè Maríaá: Nì ba dua' para ccá' huenitsìna qui' Señor Dios, ccá bá lani inte' según bá nu ra cuią'lu'. Làniana beda' ángelia ru'a lo bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Bitola nna biria Maríaá na huía chì bi le' ttu yetsi nu ga'ną le' ca i'ya tó' qui' distrito nu lá Judea. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Gutà'a tè bi litsi' Zacarías nna beni bi Elisabet saludar. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tiémpua de biyénini Elisabet saludo qui' María nna, huatsa to' nùà' bía nna bitsiánią lè'e bi por la' redacca' latsi'. Làniana Elisabet, de beni bi recibir la'huacca qui' Espíritu Santo nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","gunne bi idìtsa nna ra bi María: De lo iyaba ca niula nna adila bendecir beni Señor lu' ą'hua huatsa to' nùà' lù'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ti'ani modo acca rídíá' tanto favor hasta qui'ni lu' nàna qui' enne' gunna salvación quia' nna tanèl·le' lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Porqui'ni beni diba lu' inte' saludar nna, huatsa to' núá' yì'į nna bitsiáni bi lí'a'. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ica'rubà lu' porqui'ni ríalatsi' lu'; porqui'ni huacca cumplir nu chi ra Señor Dios qui' rí'ua. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Làniana gunne María nna ra bi: Lani itute látsa'a' rudáliania' Señor, ");
INSERT INTO zaaNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ą'hua tanto la' redacca' latsi' té lo lóstu'a', porqui'ni lèe nna née Dios enne' gunna salvación quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Chi gulèqquie inte' cuenta para gunia' servir ru'a lúe, màsqui'ba labí dacca'a'. Ą'hua dèsdeba anna iyaba ca enne' nna gá cą inte': Ica'rubà lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Porqui'ni Tata Dios enne' té itute la'huacca quì'e nna, chi benie ca cosa ỹénitse' para inte', yala santo ná nombre quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tulidàni té la' retúalatsi' quì'e para lani iyaba canu runi ti'na nu calatsi'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ca cosa nu chi benie nna rulue'ní qui'ni yala la'huacca té quì'e. Gùtue la'huacca qui' canu yala rebatta', benie cą vencer. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Gùtue la' huacca qui' canu rigú'ubia' nna bete tìe la' dàliani qui' ca enne' ỹénlatsi'. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Canu ritùni nna guthel·le'e la' tsè' qui' quį, hàstaá qui'ni labiru biỹa reyàtsani cą. Pero canu rico nna, de una vez tení bequètsie ná' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Benie ri'u cualani porqui'ni ná ri'u yetsi quì'e Israel para guni ri'u e servir nna labí betu la' retúalatsi' quì'e lani ri'u, ");
INSERT INTO zaaNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tì'a nu benie prometer lani ca ta' tàta qui' rí'ua, dèsdeba lani Abraham, ą'hua lani iyaba ca descendencia qui' bi tulidàni. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Gudua tè María lani Elisabet ttú tsunna biú' ti'gá. Bitola nna beyéqquia bi litsi' bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bi'yu bá tsá ná qui'ni itsina' huatsa to' qui' Elisabet nna beditsìna' tè bi ttu nubeyu' to' qui' bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","De bina ca vecínuá ą'hua ca pariente qui' Elisabet qui'ni beni Tata Dios bi bendecir lani ttu nubeyu' to', yala bedacca' latsi' quį nna huía cą litsi' bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","De uccuani huátsáa xunu' ubitsa nna huía cabi para ccá huátsáa circuncidar de beni cabi ą presentar lani Tata Dios. Uccua latsi' cabí gata' láa huátsáa Zacarías tì'ba lá tàta qui' bía. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero Elisabet nàna qui' huátsáa nna ra bi: Alàa ą́', sino Juan la gata' líį. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ra tè cą bi: Bianicca ni'i, lanú pariente qui' lu' té lá ą́'. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Làniana gunàba titsa' cą tàta qui' huátsáa lani seña biỹa calatsi' bi gata' líį. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Gunàba tè bi ttu bereta nna bedia bi lúį: Juan té líį. Iyaba cą nna yala biquila' latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lània taá nna benne Zacarías nna gudulo bi bedàliani bi Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Iyaba ca vecino qui' bía nna yala biquila' latsi' quį. Làniana le' ituba lugar i'ya tó' qui' distrito nu lá Judea gudà titsa' de iyaba nu uccua. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Iyaba canu bina nu uccua nna yala belaba latsi' quį ą'hua gunàba titsa' luetsi quį nna ra cą: Núgani í'yú huátsíį quée cá. Anía ra cą porqui'ni Señor Dios nna hualigani benie huátsáa bendecir. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías enne' uccua tàta qui' huátsáa nna guỹi' bi la'huacca qui' Espíritu Santo nna gunne bi ca titsa' nu beni Tata Dios latsi' bi inne bi nna ra bi: ");
INSERT INTO zaaNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Bendito Señor Dios qui' ca enne' Israel, porqui'ni chi due entre ri'u nu ná ri'u yetsi quì'e nna, chi bedilèe ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Chi guthèl·le'e ttu enne' té la'huacca quì'e para gudilèe ri'u nna dé'e le' familia qui' siervo quì'e David. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Anía benie prometer por nu gunne ca enne' uccua profeta quì'e dèsdeba chìa gutsa. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Rèe qui'ni gudilèe ri'u latsi' ná' ca contrario qui' rí'ua, ą'hua latsi' ná' iyaba canu ruyudí' cą ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ra huée qui'ni éxalatsi'e nu benie prometer lani ca ta' tàta qui' rí'ua porqui'ni retúalatsi'e cabi nna labí iỹul·lanie promesa lígani nu benie lani cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nui nna ną́ titsa' tsè'ni nu gunne Tata Dios lani ta' tàta qui' ri'u Abraham chìa gutsa loti' rèe ");
INSERT INTO zaaNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","qui'ni gudilèe ri'u latsi' ná' ca contrario qui' ri'u, para qui'ni guni ri'u e servir sin la' rátsilatsi', ");
INSERT INTO zaaNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Para qui'ni tsé'e ri'u ru'a lúe lani ttu losto' nàrì de runi ri'u nu rú'ulatsi'e itúỹiani ca tsá ccabàni ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Lu' nna nító' quia', ccá lu' profeta para quixa'a lu' ca titsa' qui' Tata Dios enne' dua ỹiabara'. Porqui'ni ya'la la lu' tsía para guni lu' preparar ca néda para qui'ni guni ca enne' Señor recibir. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Anía modo nna quixá'ani lu' yetsi quì'e titsa' nu gunna salvación qui' quį, para qui'ni eyuniỹén latsi'e ca tul·la' qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Por tántuani la' retúalatsi' qui' Tata Dios lani ri'u nna, chi benie qui'ni huànì' ttu tsá cubi para ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Para qui'ni canu tsè'e le' chul·la, ą'hua canu tsè'e le' ỹula qui' lù'utia nna gudani' ràbani la'yani' lo losto' quį. Ą'hua íchi'e ri'u lo néda lígani nu runna la'ỹeni. ");
INSERT INTO zaaNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Conforme dia ba Juáan riỹeni bi nna guta' huá adí fuerza espiritual qui' bi. Gureni tè bi fuera yétsiá hàstaá qui'ni bi'yu tsá cca bi presentar lani ca enne' Israel. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tiempo lània nna beni Augusto César orden qui'ni ituba làti rigú'ubia'ą nna ichìtha cą censo. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Primer cénsuį nna uccuą loti' Cirenio ną́ gobernador qui' nación láą Siria. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Iyaba ca enni'a nna ná qui'ni eyya ttu ttu tsa cą le' yetsi qui' quį para qui'ni gute cuenta láa quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Acca beria tè Joséa le' yetsi Nazaret de Galilea nna beyya bi attu distritu huaya' láą Judea hàstaá ttu yetsi láą Belén, la'a mísmuba yetsi làti bitsina' David. Joséa nna huía bi Belén porqui'ni ná bí descendiente lígani qui' David nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","huía bi nía para gute cuenta láa bi. María enne' chì' nábabáni bi para ccá bi niula qui' bi nna huía bi lani bi. María nna chi nùà' bi huatsa to'. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Le' yetsi Belén bá tsè'e cabí nna, gùl·la' tiempo nu ná qui'ni itsìna' huatsa to' qui' Maríaá. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Bitsina' tè ttu nubeyu' to' ỹi'ni neru bi nna, betetsí tè bi e lari' nna gutìxa bi e le' ttu yú'u làti ro ca gù'na bia', porqui'ni labí lugar té le' yú'u posádaá para làcabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tsè'e tè tuchùppa ca pastor exa gáabá yetsi Belén, rappa cą ca carnero qui' caniá de réla. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","De repente taá nna bitsina' ttu ángel por mandado qui' Señor nna gùdu bi làti tsè'e canaá. La'yani qui' Señor nna bedàni'e ìta'lùba làti tsè'e canaá nna yala gutsini cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Angelia nna ra tè bi cą: Bittu gátsini le, porqui'ni annana quixa'ánia' le ca titsa' de la' redacca' latsi' para iyaba ca enne': ");
INSERT INTO zaaNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Porqui'ni annana le' yetsi Belén méruani yetsi qui' ta' tàta qui' le David nna chi gùlia ttu nito' enne' quée Salvador qui' le nna née CRISTO enne' cu'úbia' lo iyate. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iį modo nna etseláni li e: Taxacca' le nítú'a tùbie lári' tíe le' ttu yú'u làti ro ca gù'na bia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","De repente tabá nna bitsina' adí iỹé mili' ca ángel qui' ỹiabara' làti du ángelia nna, bedàliani cabi Tata Dios nna ra cabi: ");
INSERT INTO zaaNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","La' dàliani para Tata Dios enne' dua le' ỹíabara', Para yétsiloyu nna voluntad tsè' nna la'ỹeni lo losto' iyaba ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bedà' bá ca ángelia deyya cabi ỹiabara' nna, làniana ra luetsi ca pastor: Léya' xìatsánna hàstaá Belén para ilá'ni ri'u nu uccua nu chi gutixa'áni Señor ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Deyya tè cą quèthani nna betseláni cą María nna Joséa nna, nítú'a nna tíe le' ttu yú'u làti ro ca gù'na bia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","De bila'ni cą huátsáa nna gutixa'áni cą cabi tì'a chi ra ángelia nu cca qui' huátsáa. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Iyaba canu biyénini nna biquíla' bá latsi' quį por nu ra ca pastor. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María nna yala belaba latsi' bi nna tulidàba bexa latsi' bi ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bedà' tè ca pastor nna deyya cą attu làti tsè'e ca carnero qui' caniá nna bedàliani cą Tata Dios nna bè' cą ne gracia por iyaba ca cosa nu chi biyénini cą nna bilá'ni cą nna, porqui'ni uccua cumplir tì' taání gutixa'áni ca ángelia cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","De uccuani huátsáa xunu' ubitsa nna, beni cabi e circuncidar nna gutìxa cabi lée JESUS, ti'a chi ra ángelia ántescala huá' Maríaá huatsa tú'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","María nna Joséa nna gulèda cabi gutè tiempo señalado tì'ba ga'na escrito lo ley qui' Moisés para ccá cabi purificar de chi beditsìna' bi ttu huatsa to'. Bitola nna huía cabi lani huátsáa Jerusalén para guni cabi e dedicar lani Tata Dios, ");
INSERT INTO zaaNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ti'a ga'na bá escrito lo ley qui' Señor: Iyábani ca nubeyu' néru to' nna ná qui'ni ccá cą yà'latsi' para guni cą Señor servir. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ą'hua huía cabi para guni cabi ofrecer nu beni Señor mandado lo ley quì'e: chuppa ca tortolita o chuppa ca becha to'. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Gùdua tè ttu ènne'yu' le' Jerusalén lá bi Simeón, tulidàba beni bi nu rú'ulatsi' Tata Dios nna beni bi e adorar. Por iỹé ida nna gulèda bi íl·lani enne' gúnná bendición qui' ca enne' Israel. La'huacca qui' Espíritu Santo nna gùdue lani bi; ");
INSERT INTO zaaNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","acca uccua bi saber qui'ni labí gatti bi sin qui'ni làa ilá' ỹáni bi Cristo enne' ná qui'ni ithèl·la' Señor Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Espíritu Santo nna benie latsi' Simeón tsía bi le' templua. Loti' Joséa nna Maríaá nna bitsina' cabi lani Jesús le' templua para guni cabi e presentar según nu ná bá costumbre nu ra lo ley, ");
INSERT INTO zaaNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","guỹi' tè Simeón nítú'a nna gul·láni bi e nna bedàliani bi Tata Dios nna ra bi: ");
INSERT INTO zaaNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Annana Señor, bedi' bá cuią'lu' inte' siervo qui' cuią'lu' porqui'ni chi guta' la'ỹeni quia' de chi bì'yu tsá uccua cumplir titsa' qui' cuią'lu' lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Porqui'ni lani propio gani íyyalua' chi bilá' te' Enne' gudilèe intu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Guthèl·la' cuią'lu' e para iyáỹianica enne'. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Porqui'ni ná huée la'yani' para ca enne' qui' adí ca nacitn. Por lèe nna tháliani yetsi qui' cuią'lu' Israel. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Joséa nna Maríaá nna biquila' bá latsi' cabi por nu ra Simeón qui' huatsa to' qui' cabía. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeón nna gunàba bi bendición para làcabi lani Tata Dios. Làniana ra tè bi nàna qui' huátsáa: Huátsíį nna née destinado para qui'ni nuỹetse' ca enne' Israel nitti cą porqui'ni labí tsíalatsi' quį; ą'hua para qui'ni adí cą nna eyacca cą arrepentir nna l·lá cą. Lèe nna née ttu señal nu guthèl·la' Tata Dios atsi'íni nuỹetse' ca enne' inne cą mal còntre; ");
INSERT INTO zaaNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ą' modo nna telini iyaba nu rulaba latsi' ttu ttu ca enne'. Nui nna ccą́ ttu tristeza tì'a ttu espada nu ttíą latsi' lo losto' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gùdua huá ttu niula nía lá bi Ana, ỹi'ni Fanuel, díátia' bi familia qui' ta' enne' gùla qui' cabi Aser enne' gùdua chìa gutsà. Enne' lá Anaá nna gutixà'a huá bi ca titsa' qui' Tata Dios. Yala enne' gùla chi ná bi. De uccua bi cuìti'a nna bettsa gáláaná' bi, pero gàtsi ida teruba guỹua cabi nna gùttì tsèlà bía. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ochenta y cuatro ìdani bi, ą'hua ituba tiempo de ná bi viúdaá nna tulidàba huía bi templua nna beni bi Tata Dios adorar réla rítsání nna gutua bi labí gutò bi nna, yala enne' de oración uccua bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Méruani hóraá bitsina' bi le' templua nna yala gracia bè' bi Tata Dios nna gunne bi qui' nu cca qui' nítú'a lani iyaba canu ribeda huá cą íl·lani enne' gudilèe iyaba ca enne' Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joséa lani María nna beni diba cabi cumplir iyaba nu ra lo ley qui' Señor nna beyeqquia cabi yetsi qui' cabi Nazaret región qui' Galilea. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Conforme dia ba huátsáa riỹenie nna, guta' huá adí la'huacca quì'e, ą'hua yàlani la' riyeni tsè' gutà'nie. Tata Dios nna yala uccuatsi'ínie bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ttu ttu ìdani nna huía Joséa nna María nna ciudad Jerusalén para guttè cabi nía fiesta láą Pascua. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","De uccuani Jesús tsì'nu ida nna, huía cabi Jerusalén attu para guttè cabi fiéstaá tì'a ná bá costumbre qui' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Gutè bá fiéstaá nna beda' tè cabi nía. Huátsáa nna beyà'na bée Jerusalén, pero Joséa nna nàna qui'áa nna labí gutébe'ni cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Rulaba tè latsi' cabi qui'ni látsi'e ca enne' ỹétse'á. De chi guda' cabi ttu tsá nna gudulo cabi beyìla cabi e entre ca pariente qui' cabía nna ą'hua entre adí canu nabia'ni cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero labí betseláni cabi e, acca beyéqquia cabi Jerusalén nna beyìla cabi e. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Guttè diba tsunna ubitsa gutsé'e cabi hueyìla Jesús nna, betseláni cabi e le' templua, ri'e làhui' ca maestro nu nabia' tsè'gani itúbani nu ra lo ley, rudà nàgue'e qui' quį nna gunàba titsa' huée cą nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iyaba canu biyénini nu rèe nna yala biquila' latsi' quį de tántua la' riyeni tsè' té quì'e, ą'hua de tántua tsè' becàbinie cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bilá' báni Joséa nna María nna yala uccuaỹí latsi' cabi. Acca nàna qui'áa nna ra bi e: Ỹì'nia', bianicca bethácca' lu' intu' ą́' ni'i. Tata qui' lù'į nna inte' nna yala lani la' rehuiní' latsi' chi beyìla tu' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús nna rèe cabi: Bianicca beyìla le inte' ni'i. Tsí làa yù huá le qui'ni lo tsina qui' Tata quí'a nna té qui'ni thúá' cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero làcabi nna labí gutéelíni cabi biỹa nuá rèe cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Làniana deyya tìe lani cabi nna betsina' cabi le' yetsi Nazaret. Yala obediente benie seguir lani cabi. Nàna qui'áa nna liú'u losto' ba bi yala belaba latsi' bi iyaba ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús nna conforme riỹeni bée nna rata' huá adí la' riyeni tsè' quì'e, ą'hua Tata Dios nna yala guyú'u latsi'e nu benie; ą'hua iyaba ca enne' nna beni cą ne estimar. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","De uccua tsìnu' ida rigú'ubia' Tiberio César itúbani yétsiloyua, loti' Poncio Pilatua nna uccuą gobernador qui' Judea, Herodes nna uccua tìą gobernador qui' Galilea. Bettsi'į Felipe nna uccua tìą gobernador qui' Iturea ą'hua distrito nu lá Traconite nna. Lisanias nna uccuą gobernador qui' región nu lá Abilinia. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás lani Caifás nna uccua cą huexána' qui' ca sacerdótea. Làniana gureni Juan ỹi'ni Zacarías fuera ca yetsi nna, gutelí tsè'nì bi mensaje nu uccua latsi' Tata Dios quixá'a bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Acca huía tè Juáan itúbani región luítta' yò Jordán nna gutixa'áni bi ca enne' qui'ni dàni cą eyacca cą arrepentir lani Tata Dios para qui'ni eyuniỹen latsi'e ca tul·la' qui' quį nna ccá tè cą bautizar. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Anía uccua cumplir nu ga'na escrito lo libro nu bedia Isaías enne' uccua profeta nna ra bi: Rùyeni ttu enne' fuera yetsi nna ra bi: Lítsé'e leda porqui'ni chi da' Señor; Liutha' lí ca néda qui' la' labàni qui' le para lèe. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Iyaba ca lithá' nna étsa' cą. Iyaba ca i'ya nna ca làttsa nna èxxa cą. Ca néda cuàl·la nna elí cą. Ca néda tabi nna lappatsùni eyacca cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Iyaba ca enne' nna ilá'ni cą salvación nu runna Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ca enne' ỹétse' nna biria tè cą para ccá cą bautizar, acca Juáan nna ra bi cą: Yala mañoso ná le tì'a ca bèl·là. Nuni rą le qui'ni huaccani le ucuìttani le la' tsìalatsi' qui' Tata Dios nu chì' da'la cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Liulue' lani ca hecho tsè' qui' le canchu là hualigani chi beyacca le arrepentir. Alàa chì' gutsia la le pretexto nna ína le: Ná tu' descendiente qui' ta' tàta qui' tu' Abraham acca yala enne' tsè' chi ná tu'. Pero inte' nna nia' le qui'ni hàstaá ca íyya anta' nì nna huaccani Tata Dios gunie qui'ni eyacca cą ỹi'ni Abraham. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ą'hua chi du leda yèttè para íchuą ca yaga dèsdeba l·lú quį; ą'hua iyaba ca yà nu labí runna fruto tsè' nna chú cą tsía cą lo yi'. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ca enne' nna gunàba titsa' tè cą bi nna ra cą: Biala dàni tu' guni tu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Becàbi Juáan nna ra bi cą: Nu té chuppa cue' ỹúį nna dànią gutią ttu qui' nu labí té quì'į. Ą'hua nu té gúą nna dà huánią gutią qui' nu labí té gúą. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bitsina' tehuá tuchùppa canu ruquiỹa qui' impuesto para guni bi cą bautizar nna ra cą bi: Maestro, biani dàni tu' guni tu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juáan nna ra bi cą: Bittu gutèbia' telá le guquiỹa le ca enne', sino guni le de acuerdo nu ra lo ley qui' gobierno. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Làniana tuchùppa ca soldado nna gunàba titsa' huá cą bi nna ra cą: Intu' chù na, biala dàni tu' guni tu' ni'i. Ra te bi cą: Bittu cúani le ca enne' biỹa té qui' quį, nihua làa gúniatsìnì le cą nna gá le cą qui'ni guni le cą castigar canchu labí gunna cą biỹa qui' le màqui'ba labí biỹa beni cą; sino leyà'na tè conforme lani nu ráỹa le. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Iyáỹiani ca ènni'a nna tsè'e ba cą ribèda cą nna yala rulaba latsi' quį canchu xiaba Juáan nna ná bi Cristo enne' ná qui'ni ìta le' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Acca becàbi Juáan nna ra bi cą: Inte' nna hualigani runia' le bautizar lani inda, pero dá' attu enne' té adí la'huacca quì'e tì'chu inte', lèe nna gunie le bautizar lani Espíritu Santo nna la'huacca tì'a fuego nna; acca nìdirubani làa dàcca'a' para ithátsíá' correa qui' ca guarachu yù'u nì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ą'hua dèníe pala para gúthúe ỹua' nu re' lo tsinà' quì'e; ỹua'xtíla nna gunie na seguro le' yú'u, pero ttébáỹua nna gudàl·lee na lo yi' làti nunca labí eyòlą. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Làni ca enseñánzaá ą'hua lani iỹétse'éru adí ca consejo nna gutixa'a bi ca titsa' de la'labàni lani ca enne' yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Làniana gutìl·la Juáan gobernador Herodes porqui'ni guỹi'į Herodías niula qui' bettsi'į Felípea para ccą́ niula quì'į, ą'hua por iyaba adí ca mal nu benią nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Làniana bedàni telá Herodes attu mal nu benią nna: bedàl·lą Juáan litsi' ìyyà. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Antesca cca anía nna, loti' runi Juáan bautizar iyaba ca ènni'a nna, ą'hua Jesús nna uccua huée bautizar. Miéntraste runie oración nna biyàlia ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Làniana bilá'ní huadi Espíritu Santo tì'a ttu becha to' nna bitsine'e iqquia Jesús. Biyeni tení tsì'i ttu enne' gunne de ỹiabara' nna rèe: Lu' ná lu' ỹì'nia', yala catsi'í te' lu'; por lu' nna yala la' redacca' latsi' té quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ttú tsìi érua' ida tì'gani Jesús nna, gudulue benie tsina nu dé'e gunie. Ca enne' ra cą qui'ni Jesús nna née ỹi'ni José. Joséa nna ỹi'ni Elí. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí, ỹi'ni Matat. Matat, ỹi'ni Leví. Leví, ỹi'ni Melquì. Melquì, ỹi'ni Janai. Janai, ỹi'ni José, ");
INSERT INTO zaaNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José, ỹi'ni Matatías. Matatías, ỹi'ni Amós. Amós, ỹi'ni Nahum. Nahum, ỹi'ni Esli. Esli, ỹi'ni Nagaí. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaí, ỹi'ni Maat. Maat, ỹi'ni Matatías. Matatías, ỹi'ni Semei. Semei, ỹi'ni Josec. Josec, ỹi'ni Judá. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá, ỹi'ni Joanán. Joanán, ỹi'ni Resa. Resa, ỹi'ni Zorobabel. Zorobabel, ỹi'ni Salatiel. Salatiel, ỹi'ni Nerí. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerí, ỹi'ni Meljí. Meljí, ỹi'ni Abdí. Abdí, ỹi'ni Cosam. Cosam, ỹi'ni Elmadam. Elmadam, ỹi'ni Er. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er, ỹi'ni Josué. Josué, ỹi'ni Eliezer. Eliezer, ỹi'ni Jorim. Jorim, ỹi'ni Matat. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat, ỹi'ni Leví. Leví, ỹi'ni Simeón. Simeón, ỹi'ni Judá. Judá, ỹi'ni José. José, ỹi'ni Jonán. Jonán, ỹi'ni Eliaquim. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim, ỹi'ni Melea. Melea, ỹi'ni Mainán. Mainán, ỹi'ni Matata. Matata, ỹi'ni Natán. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán, ỹi'ni Davíd. Davíd, ỹi'ni Isaí. Isaí, ỹi'ni Obed. Obed, ỹi'ni Booz. Booz, ỹi'ni Salmón. Salmón, ỹi'ni Naasón. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón ỹi'ni Amidadab. Amidadab, ỹi'ni Aram. Aram, ỹi'ni Esrom. Esrom, ỹi'ni Fares. Fares, ỹi'ni Judá. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá, ỹi'ni Jacob. Jacob, ỹi'ni Isaac. Isaac, ỹi'ni Abraham. Abraham, ỹi'ni Taré. Taré, ỹi'ni Nacor. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor ỹi'ni Seruc. Seruc, ỹi'ni Ragau. Ragau, ỹi'ni Peleg. Peleg, ỹi'ni Heber. Heber, ỹi'ni Sala. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ỹi'ni Cainán. Cainán, ỹi'ni Arfajad. Arfajad, ỹi'ni Sem. Sem, ỹi'ni Noé. Noé, ỹi'ni Lamec. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec, ỹi'ni Matusalá. Matusalá, ỹi'ni Enoc. Enoc, ỹi'ni Jared. Jared, ỹi'ni Mahalaleel. ");
INSERT INTO zaaNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Mahalaleel, ỹi'ni Cainán. Cainán, ỹi'ni Enós. Enós, ỹi'ni Set. Set, ỹi'ni Adán enne' uccua ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús nna benie recibir itute la'huacca qui' Espíritu Santo nna bede'e yò Jordán. Làniana por medio de Espíritu nna huíe idittu' la làti lanú enne' té. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nía nna gùdue chua' ubitsa nna chua' yèlà nna, beni tè numalua ne prueba canchu hua rialànią gunie nu calatsi'į. Labí biỹa gutúe, guttè diba chua' ubitsa nna gutùnie. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Làniana ra tè numalua ne: Canchu hualigani ná lu' Ỹi'ni Tata Dios nna, gùtsi íyya té nì qui'ni eyaccą ettaxtíla. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Becàbi Jesús nna rèe na: Escrítuba ga'na qui'ni alàa tsua' teruba lani ettaxtíla ccabaniní ca enne', sino ą'hua lani iyábani ca titsa' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Guche' tè numalua ne lo ttu i'ya ỹeni tsè'ni; ttu tsastitó' ní nna beluè'nią ne itúỹiani yétsiloyu nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","rą ne: Latsi' ná' bá lu' gunna' itute la'huacca nna itute riqueza qui' ca nación nì, porqui'ni quíbá' ná cą ą'hua guté ya' cą lani nuỹa bá calátsa'a'. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Canchu gudu teruba ỹibi lu' ru'a lua' nna, entonces iyáỹiani ca nui nna quì'ba lu' ccá cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Becàbi Jesús nna rèe na: Becuìtta ru'a lua' Satanás, porqui'ni Tata Dios nna rèe lo Escritura: Beni adorar ttu teruba Señor Dios qui' lu', ą'hua là terubée guni lu' servir. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Làniana numalua nna guche' tìą ne le' Jerusalén nna beduą ne iqquia torre qui' templua nna ra tìą ne: Canchu hualigani ná lu' Ỹi'ni Tata Dios nna bittsía tsanna de nì para loyu nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","porqui'ni escrítuba ga'na qui'ni: Tata Dios nna ithèl·le'e ca ángel quì'e para hué' cą lu' cuidado. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ra huá lo Escritura qui'ni: Ca ángel nna gudàxu' cą lu' lo ná' quį para qui'ni làa itsina' nì'a lu' lo íyya nna ccadí' qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Becàbi Jesús nna rèe na: Ga'na huá escrito làti ra qui'ni: Bittu guni lu' tentar Tata Dios qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Làniana labiru betseláni numalua ti'iỹa modo cu'ą́ Jesús prueba, acca becuìtta sabą́ ru'a lúe. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Bitola nna beyeqquia Jesús para Galilea lani la'huacca qui' Espíritu Santo. Gudàa tè titsa' quì'e itúbani región qui' nía nna ti'iỹa iỹeni ná la'huacca quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Gutixè'e titsa' qui' Tata Dios le' ca sinagoga làti retuppa ca enne' Israel. Iyaba cą nna bedàliani cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús nna betsine'e Nazaret làti biỹeni áa. Tì'ba ná bá costumbre qui'áa nna gutà'a tìe le' sinagoga ttu tsá redi' latsi' ca enne' Israel nna guduli tìe para gúl·lee Escritura. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bè' tè cą ne libro nu bedia Isaías enne' uccua profeta qui' Tata Dios nna guthàlia bée librua nna taxáqque'e lugar làti ra: ");
INSERT INTO zaaNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espíritu enne' guthel·la' Señor Dios nna runne la'huacca quia', porqui'ni chi benie inte' nombrar para quíxa'a' ca titsa' tsè' cubi lani ca enne' pobre. Chi guthèl·le'e inte' para gútià' la'ỹeni lo losto' canu tsè'e lani la' rehuiní' latsi', para guyénia' qui'ni hua té libertad para ca preso, ą'hua para qui'ni ca ciego nna ilá'ni cą nna gudilá'a' canu ridácca'tsì'i. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ą'hua para quixa'a' qui'ni chi gùl·lani tsá retúa latsi' Señor ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Làniana betùbi Jesús ìttsia nna bete tìe na lani nu ga'na encargado qui' nía nna bebé' teníe. Iyaba canu tsè'e le' sinagógaá nna betsia tsìttsì ba lo quį ne. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Gudulo tìe gunnie nna rèe cą: Annana chi uccua cumplir nu chi biyénini le ga'na escrito. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iyaba cą nna yala biquíla' latsi' quį por ca titsa' tsè'gani gutixè'e, acca ra cą: Tsí álahua làbi nuá ỹi'ni José cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús nna rèe: Segúruni nna gá le inte' díchuį: Lu' médico, beyúni la'a lù'ba; iyaba nu bina tu' beni lu' le' yetsi Capernaum nna, beni huá cą látsi lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Beni ba Jesús seguir nna rèe: Hualigani te' riquixa'ánia' le qui'ni nìdi ttu profeta nna labí ruyu tsè' cą na látsį. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ą'hua nia' le qui'ni hualigani gutsé'e iỹetse' ca niula viuda entre ca enne' Israel tiempo qui' Elías enne' uccua profeta loti' labí uccua iyya por tsunna ida xuppa biú' nna uccua ttu bina' fuerte le' ituba lugar nía. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero Tata Dios nna labí guthel·le'e Elías lani nuỹa ttu ca enne' Israel para gudilàa bi cą bina', sino làteruba lani ttu niula viuda le' yetsi Sarepta región qui' Sidón. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ą'hua gutsé'e iỹetse' canu huì'ni yetsu' yùtsù' entre ca enne' Israel tiempo qui' Eliseo enne' uccua profeta, pero ni ttu cą labí beyúni bi, sino làteruba Naamán enne' attu nación huaya' láą Siria. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Biyeni báni canu tsè'e le' sinagógaá ca tìtsi'į nna bitsa'áláni cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Gùduli chì cą nna gulèqquia cą ne yetsi nna guche' cą ne ru'a bèl·la'a qui' i'ya làti re' yétsiá para uquìnnia cą ne lo íyyatù'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero labí birialàni cą gúttí cą ne porqui'ni lèe nna bettìe lahui' quį nna déyyee. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Betsina' tè Jesús le' yetsi Capernaum región qui' Galilea. Gutixa'ánie cą enseñanza nu cca qui' Tata Dios ca tsá redi' latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yala biquila' latsi' quį de biyénini cą ca enseñanza quì'e porqui'ni gùnnie lani poder de ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Le' sinagógaá nna re' ttu nubeyu' cca padecer por ttu espíritu malo. De repente taá yala idìtsa guretsiyà'ą nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","rą: Be'él·la' intu', biani té qui' lu' lani intu' acca dá' lu', Jesús enne' Nazaret. Tsí da' chì lu' para gul·lùỹa lu' latsi' tu' acca. Hua nabia' ba te' lu', ná lu' Enne' Santo guthèl·la' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Gutìtsa' tè Jesús na rèe na: Bèthia rú'a lu' nna beria lo losto' nubéyu'į. De ra Jesús anía nna, làniana bedàl·la chìą nubéyu'a loyu ru'a lo iyaba canu tsè'e nía nna beria tìą lo lostu'į, pero bíttuá biỹa guỹácca' nubéyu'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iyaba cą nna uccuaỹí yà'aba latsi' quį tsè'e cą nna ra luetsi quį; Biagani titsa' ní nui acca tanto lani la'huacca nna valor nna runią mandado ca espíritu malo qui'ni rútse'e latsi' quį ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Làniana itúbani lettia nna gudàa titsa' nu cca qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Gùduli tè Jesús nna berie le' sinagógaá, bitsina' bée litsi' Simón. Suegra qui' Simón nna tíą yi'bél·laníą ỹìl·lá. Gutta'yúni cą ne qui'ni eyúnie na. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Biyèchu tè Jesús ru'a lo niulaa nna gutìtse'e ỹìl·láa. Làniana beyacca chì latsi'į nna luégutaá beyathą nna benią cabi servir. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Benia bá bìtsa nna tahua' cą ru'a lo Jesús iyaba canu ra'ni biỹa tediba itsahue' ní. Lèe nna betsia né'e iqquia ttu ttu tsa canu rà'nia nna beyacca taá latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ą'hua iỹetse' ca enne' beria ca espíritu malo lo losto' quį, yala ribétsi yà'ani cą nna ra cą Jesús: Lu' ná lu' Ỹi'ni Tata Dios. Pero lèe nna gutìtse'e cą, nihua labí be'él·le'e cą inne cą adí, porqui'ni hua yù bá cą qui'ni lèe Enni'a Cristua. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Attu yu'u dílaá nna biria Jesús huíe ttu lugar yà'latsi'. Ca enne' nna biria tehuá cą reyìla cą ne. Bitsina' bá cą làti ri'e nna gutta'yúni cą ne qui'ni bíttuúru tsíe gaỹa. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero lèe nna rèe cą: Náduel·la' qui'ni adí ca yetsi nna guna huá cą mensaje nu cca qui' la' rigú'ubia' qui' Tata Dios, porqui'ni para nui lá chi guthèl·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Beni tìe predicar le' ca sinagoga qui' ituba región qui' Galilea. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ttu vuelta nna du Jesús ru'a indatò' qui' Genesaret, bitùppa tè enne' ỹétse'ní ru'a lúe hàstaá qui'ni chi ruquini cą ne para gudà naga' quį titsa' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bilá' tènie chuppa ca barco to' dàa cą ru'a indatù'a. De chi beyàdi ca enne' yù'u le' ca bárcuá nna tsè'e tè cą huìi ca exxa nu rudàxu' ní cą bél·lá. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Gutà'a tè Jesús le' ttu bárcuá nna. Bárcuá nna uccuą qui' Simón. Jesús nna gutìnanie Simón favor qui'ni gutsíga' bi bárcuá áti' tó' tè le' indaá. Gure' teníe nna gutixa'ánie ca enne' ỹétsi'á titsa' qui' Tata Dios dèsdeba le' bárcuá. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Beyacca diba gunnie nna rèe Simón: Betsíga' bárcuį lahui' indį lá nna liudàl·la ca exxą' para gudàxu' le bél·lá. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Becàbi tè Simón nna ra bi e: Maestro, betù èlà ba gutsé'e tu' chi betsaníni tu', ni ttú bél·la ni'i gudàxu' tu'; pero de acuerdo lani titsa' qui' cuią'lu' nna, gudál·la'a' exxį. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","De beni cabi nu reáa nna bedàxu' cabi ttu cantidad ỹéniní bél·la hàstaá qui'ni chi reyatsiní éxxaa. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Làniana lani seña ba gutàỹi cabi ca compa' qui' cabi yù'u le' attu bárcuá para qui'ni tsía cą cualani cabi. Bitsina' cą nna beditsàa' cą chuppa taá ca bárcuá hàstaá qui'ni áti'tó' taá làa binétsi cą por tántua la' ìdì'i qui' ca bél·laá. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","De bilá'ni Simón Pedrua nu uccua nna, bedu ỹibi bi ru'a lo Jesús nna ra tè bi e: Adilatsa' betse'e latsi' cuią'lu' inte', Señor, porqui'ni yala nu tul·la' ná'. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Anía ra Pedrua porqui'ni guta' ttu la' rátsilatsi' lo losto' bi, ą'hua iyaba canu tsè'e lani bía, por nu uccua. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Anía tehuá guỹàcca' Jacóbua nna Juáan nna ca ỹi'ni Zebedéua, porqui'ni gutsé'e cabi júntubá lani Pedrua. Jesús nna rèe Simón Pedrua: Bittu gátsini lu'. Dèsdeba annana, ca enne' la guni le pescar. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Betsina' bá cabi lani ca bárcuá ru'a yúbitsiá nna, bethà'na taá cabi iyábani nna denó tè cabi e. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Loti' re' Jesús le' ttu yetsi nna bitsina' ttu nubeyu' itúỹianią ra'ni yetsu' yùtsù'. De bilá'nią Jesús nna beduỹíbį ru'a lúe bedètta' lúį loyu nna gutta'yunią ne nna rą: Senor, canchu calatsi' cuią'lu' nna huaccani cuią'lu' eyuni lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Làniana becàa tè né'e beláppe'e na ra tìe: Huacca látsa'a', beyàcca nàrì. Làniataá nna betua chì itsahue' qui' niá. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Lèe nna benie na recomendar qui'ni nú ttu tehuá nuỹa quixá'anią nna ra lée na: Huía ru'a lo sacerdótea para qui'ni ilá'ni bi lu', bete tè ofrenda qui' lu' tì'a nu beni Moisés mandado, muestra de qui'ni chi beyacca lu' nàrì, para qui'ni ccáỹe latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero adila uccua ca enne' saber nu cca qui' Jesús, hàstaá qui'ni ca enne' ỹetse' betùppa para gudà naga' quį quì'e ą'hua para eyunie cą de iyaba ca itsahue' qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero lèe nna huía bée ca lugar yà'latsi', benie oración. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ttu tsá nna re' Jesús ruquixa'ánie ca enne' ca enseñanza nu cca qui' Tata Dios. Nía nnu ỹùa huá canu gulàni religión nu lá Fariseo, ą'hua ca maestro canu nabia' tsè'gani nu ra lo ley qui' caniá. Lacą nna da' cą de iyaba ca yetsi to' qui' ituba región qui' Galilea nna Judea nna Jerusalén nna. Bilá'ni cą qui'ni Jesús nna reyunie ca enne' por la'huacca qui' Tata Dios lani e. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bitsina' tè tuchùppa ca enne' nùà'ni cą ttu nubeyu' tíą lo ttu tá'a rà'nią parálisis, nìdirubani làa cca ttą́. Beyìla cą gaỹa la tté cą para gá'a cą le' yú'u nna quixa cą na ru'a lo Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero de tántua ca enne' ỹétse'á nna, labí betseláni cą gaỹa la gá'a cą, acca huappi chìa cą iqquia yú'u la nna guthàlia cą na guchìda cą nu rà'nia tsa'tsela taá camilla qui' niá tulíỹiani làti du Jesús le' yú'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","De bilá'ni Jesús qui'ni yala fe té qui' quį lani e nna rèe nu rà'nia: Lu' nubeyu', chìba beyuniỹén látsa'a' ca tul·la' qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Làniana ca maestro de la ley lani ca fariséua nna gudulo cą belaba latsi' quį nna uccuani cą: Bianicca rinne nubéyu'į ca titsa' nu ná qui'ni làteruba Tata Dios innie luetsi ca tìtsa'ą' ni'i. Nuni ccani gunìttiluą ca tul·la' qui' ca enne' canchu álahua tsua' teruba Tata Dios cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero Jesús nna gutelí taánie ti'iỹa ná la' rulábalatsi' qui' quį, acca rèe cą: Biani la' rulábalatsi' ní nua' té lo losto' le cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tsí adí ỹá ná bá épa'a' nubéyu'į: Chi beyuniỹén látsa'a' ca tul·la' qui' lu', o tsí épa' telá ya' ą: Beyatha nna gùda' acca. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pues annana gulué'nia' le qui'ni inte' Nubeyu' de Ỹiabara' nna té la'huacca quia' le' yétsiloyuį para eyuniỹén látsa'a' ca tul·la'. Làniana bel·luítse'e nu rà'nia nna rèe na: Beyatha nna, bedi' camilla qui' lù'ą' nna beyya litsi' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nubeyu' paralíticuá nna luegu taání beyatha chìą ru'a lo taá iyaba canu tsè'e nía, bedi' tìą camilla nu nùà'níní cą na tahua' cą na nía nna, deyya tìą lìtsi'į nna yala rudàlianią Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Iyaba cą nna uccuaỹí yà'aba latsi' quį nna bedàliani huá cą Tata Dios nna yala la' rátsilatsi' guta' lo losto' quį nna ra cą: Annana chi bilá'ni ri'u ca cosa nu dacca' iquíla'ní latsi' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Gutè diba ca cosį nna beria Jesús nía nna bilá'nie ttu nubeyu' láą Leví ną́ empleado qui' gobierno nna ri'ą ru'a meỹa làti ría ca enne' huìỹa qui' impuesto. Jesús nna ra tìe na: Gutà, tanó inte'. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levía nna bethà'na taą́ iyábani nna guduli tìą nna díą lani Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Làniana benią ttu banquete ỹénitse' para Jesús le' lìtsi'į. Tsè'e huá iỹétse'ní canu ruquiỹa qui' impuesto, ą'hua adí bá ca enne' ỹùa cą lo méỹaá lani cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ca maestro de la ley nna ca fariséua nna yala betìtse'él·la' cą ca enne' ruthète'ni Jesús nna ra cą: Bianicca rì'ya ro ba le lani canu ruquiỹa qui' impuesto ą'hua lani adí canu fuera ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Becàbi Jesús nna rèe cą: Canu bihua ra'ni nna, pues bihua riquína'ni cą médico, sino làteruba canu ra'ni. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Labí daya' para gáỹia' ca enne' tsè' sino canu tul·la' la para eyacca cą arrepentir. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Làniana ra tè cą Jesús: Bianicca ca discípulo qui' Juáan nna yala ayunar runi cą, ą'hua puro oración bá runi cą, ą'hua ca discípulo qui' ca fariséua nna. Atsi'íni ca discípulo qui' lù'ą' nna gù'ya ba nna go ba nna runi cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Lèe nna rèe cą: Tsí gá le canu tsè'e thá'a qui'ni gúchia cą làa go cą miéntraste du ba nubeyu' ruttsaná'a lani cą cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero i'yu tsá qui'ni ítua ènne'yu'a lahui' quį, lànialá nna guni cą ayunar. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ą'hua gutixa'ánie cą attu comparación nna rèe: Lanú nuỹa richu ttu pedazo vestido cubi para éguá'ą remiendo ttu vestido viejo. Canchu anía runią nna, alàa rulá richèda'ą nu cúbía sino ą'hua pedazo lari' nu gùrúa nna labí retónią lani nu viéjuá. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nìhua lanú nuỹa rigá'ą vino cubi le' bolsa viejo nu de yéti, porqui'ni cáalá anía runią nna, entonces ca bolsa yétiá nna itsu' telá cą nna ilàlia vínuá, ą'hua ca bolsa yétiá nna labiru iỹu' cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pero vino cubi nna íta'ą le' ca bolsa nu de yéti cubi; ą' modo nna tulappa bá gúchia bolsa yétiá lani vino cúbía. ");
INSERT INTO zaaNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ą'hua nu ri'ya vino viejo nna labí catèhua latsi'į nu cubi, sino ina lą́: Bittu guníxia' vino cubi porqui'ni viéjuą' la nna adila tsa' ną́. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ttu tsá sábado nna gutè Jesús làti té ỹua'. Ca enne' ruthète'niáa nna hua dia canna bá cabi guchèccu' cabi tuchùppa ỹua' nna guỹùbi tè cabi cą lani ná' cabi nna gutó cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tuchùppa ca fariséua nna ra tè cą cabi: Biecca runi le nu labí ná qui'ni guni ttu enne' tsá redi' latsi' ri'u ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Becàbi Jesús nna rèe cą: Tsí bihua ni'i gul·la le làti riquixá'a biỹa beni rey David loti' gutùni bía, ą'hua adí canu tsè'e lani bía cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Gutà'a David le' templo qui' Tata Dios nna guỹi' bi ca ettaxtíla nu ná ofrenda para Tata Dios nu lanú nuỹa dànią gúą na sino làteruba ca sacerdótea. Gutò bi nna bete huá bi gutò canu tsè'e lani bía. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Làniana rèe cą: Ccá le saber qui'ni Nubeyu' de Ỹiabara' nna rigú'ubi'e iyaba ca tsá ą'hua tsá redi' latsi' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Attu tsá redi' latsi' ca enne' judíua nna gutà'a Jesús le' sinagógaá nna gudulue gutixa'ánie ca enne' titsa' qui' Tata Dios. Nía nna re' tè ttu nubeyu' nu gubitsi yà'aba ná' bànį. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ca maestro de la ley nna ca fariséua nna betsia tsìttsì ba lo quį Jesús canchu hueyúnie nu rà'nia tsá sábado, para gappa cą néda biỹa causa ni gutsia cą quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero lèe nna nabia' bánie la' rulaba latsi' qui' quį, acca ra tìe nubeyu' nu rà'nia: Lu' nna gùduli nna gùdu làhui' la. Lą nna gùduli taą́ nna gùduą làhui'. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Làniana Jesús nna rèe cą: Ttu cosa teruba inába tìtsa'a' le: Según nu ra lo ley qui' Tata Dios nna, tsí hua ná qui'ni guni ri'u nu na tsè' ca tsá redi' latsi' ri'u, o tsí guni la ri'u mal áccá. Tsí hua ná qui'ni gudilàa ri'u ttu enne' de ca sufrimiento quì'į màsqui'ba ná tsá redi' latsi' ri'u, o tsí hue'él·la' ba ri'u ą gattią áccá. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Làniana gùnne'e iyáỹiani canu tsè'e ìta'lùbani nía nna ra tìe nubéyu'a: Bèl·lìi ná' lu'. Lą nna bèl·lìi taá ní'į, làniana tì'a viva beyacca chì ná' niá. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Làcą nna yala bitsa'áni cą nna gunne tè entre labácą contra Jesús nna abícca'lání guthácca' cą ne uccuani cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tiemplo lània nna huía Jesús lo ttu i'ya huèni oración. Ituba yèlàa nna puro taá oración bá bènie bel·luítse'e Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Huani' bá nna gutàỹie ca enne' ruthète' qui'áa nna becuí'e tsì'nu cabi para ithèl·le'e cabi huenitsìna qui' Tata Dios, acca gutìxà huée lá cabi apóstol: ");
INSERT INTO zaaNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simón enne' gutixa huée láa bi Pedro ą'hua bettsi' bi Andrés, ą'hua Jacobo nna Juan nna, ą'hua Felipe nna Bartolomé nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo nna Tomás nna, Jacobo ỹi'ni Alfeo nna, ą'hua Simón enne' lá huá bi Zelote, ");
INSERT INTO zaaNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas bettsi' Jacobo nna, ą'hua Judas Iscariote nu ná qui'ni gutią ne cuenta. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Beyadi bá Jesús lani cabi lo i'yaá nna gulèdee làti ná ttu làttsi' lani ca discípulo qui'áa. Tsè'e huá ca enne' ỹétse'ní lani cabi porqui'ni ca enne' qui' itúbani Judea nna Jerusalén nna, ą'hua ca enne' da' le' chuppa ca yetsi Tiro nna Sidón nna anta' cą exa ba ru'a indatò' nna, huía cą para iyénini cą qui' Jesús, ą'hua para eyacca latsi' quį de iyaba ca itsahue' nu ra'ni cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ą'hua canu cca padecer por ca espíritu malo nna beyacca huá latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Iyaba ca ènni'a nna beni cą duel·la' gulappa' cą Jesús porqui'ni yala la'huacca té lani lèe nna beyúninie iyaba cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Gunna' tè Jesús ca discípulo qui'áa nna rèe: Ica'rubà lebi'į canu ná pobre, porqui'ni quì'ba le ná iyate nu runna Tata Dios enne' rigú'ubia'nie le. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ica'rubà lebi'į canu ritùni anna, porqui'ni huacca yelia ba le. Ica'rubà lebi'į canu ribétsi, porqui'ni bitola nna yala edácca'ni latsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ica'rubà lebi'į canchu chi guyudí' ca enne' le nna cueqquia cą le fuera nna guduadí' cą le nna yala quiniyu cą le ti'atsi runi le nu ná mal, porqui'ni tanó le Nubeyu' de Yiaba'. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bittu ehuí'ni le, sino adila edácca'ni le porqui'ni ỹiabara' la gata' nu gunna Tata Dios qui' le. Porqui'ni ą'hua bethacca' cą ta' tàta qui' quį ca enne' uccua profeta gutsé'e tiempo antigua. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pero ica'rútsi'íru lebi'į canu ná enne' rico, porqui'ni chi guttè tiempo de la' redacca' latsi' qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ica'rútsi'íru canu labí caliàtsà qui' le anna, porqui'ni huàl·lani tiempo ubina' qui' le. Ica'rútsi'íru canu ruỹìtsi anna, porqui'ni yala élenini le nna gubètsi ba tsè'e le bitola. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ica'rútsi'íru le canchu guni le permitir qui'ni iyaba ca enne' nna gudàliani cą le, porqui'ni ca ta' tàta qui' canu tsè'e annana ą'hua bedàliani cą ca profeta falso gutsé'e ttu cuaỹa nuá. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pero lebi'į canu riyénini nna nia' le: Licàtsi'íni ca contrario qui' le. Lígúni tsè' lani canu ruyudí' cą le. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Línne tsè' qui' canu rinne cą mal contra le. Lígúni oración por canu richìtha cą mal contra le. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nuỹa tediba huí'ą xága' lu' nna, bedàa tè attu lado. Nuỹa tediba calatsi'į thí'ą mata qui' lu' nna, be'él·la tehuą́ thí'ą camisa qui' lù'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nuỹa tediba rinàbanią lu' biỹa nna, bete tènì ą. Nu thí'ą biỹa té qui' lu' nna, bittu enàba lu' ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ti'iỹa ba rú'ulatsi' le qui'ni guni ca enne' lani le nna, ą'hua lígúni lani cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Porqui'ni canchu gáppatsì'i le làteruba canu catsi'í báni cą le nna, biani cosa tsè'ni nua' runi le cá. Tsí álahuá ą'hua runi ca enne' malo cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Canchu runi le tsè' lani làteruba canu runi huá tsè' lani le nna, biani cosa tsè'ni nuá runi le cá. Porqui'ni hàstaá ca enne' malo nna ą'hua runi cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Canchu gutèsa lu' lani làteruba canu catèhua latsi' lu' otèaà huá cą lu' nna, biani cosa tsè'ni nua' runi le cá. Porqui'ni ca enne' malo nna rute sahuá cą lani adí canu runi mal para gudèqquia huá cą qui' quį attu tsánía huá. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lebi'į nna dàni le cátsi'íni ca contrario qui' le nna lígúni tsè' lani cą; líútesa cą biỹa té qui' le nna bittu cani le qui'ni eyuni huá cą le favor. Canchu guni le anía nna, entonces ccá huá le ỹi'ni Tata Dios enne' dua ỹiabara' nna yala gudàlianie le. Porqui'ni lèe nna née enne' tsè' lani ca enne' ingrato ą'hua lani canu runi mal nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Acca lícca enne' de la' retúalatsi' tì'ba Tata Dios qui' lía née enne' retúalatsi'. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Bittu guyu le la'ditsi qui' ca enne', para qui'ni Tata Dios nna làa guni huée le juzgar. Bittu guni le ca enne' condenar, para qui'ni làa guni Tata Dios le condenar. Leyuniỹén latsi' qui' ca enne'; Tata Dios nna eyuniỹén latsi'e qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Líúte para adí ca enne'; Tata Dios nna adila gúnnée qui' le hàstaá ttu medida tsè'ni nna guquìnie nna gudua thúáníe nna gúnnée qui' le. Porqui'ni ti'iỹa ba gurìxibía' le gúte le qui' ca enne' nna, ą'hua orìxibí'e gúnnée qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ra huée cabi attu enzeñanza: Tsí huaccani ttu ciego quél·lá'ą ná' attu ciego cá. Tsí álahua chuppa taá cą ìnnia le bèl·là'a cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ttu nu ruthète' nna labí dàcca'ą adiru tì'chu maestro quì'į màsqui'ba irialànią ca estudio quì'į, pero ccą́ tì'a maestro qui' niá. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Biecca rinna' lu' yíỹi to' nu yù'u lo attu enne', atsi'íni labí runi lu' duel·la' ebèqquia lu' nicùà' nu yù'u íyyalo lu' ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Miéntraste yù'u ttu nicùà' íyyalo lu' nna, biecca gá lu' attu enne': Gulèda qui'ni ebèqquia' yíỹi nu yù'u íyyalo lu'. Yala huethacca'ỹí ná lu'. Bétse'e latsi' lu' ca tul·la' qui' la'a lu' ba, lànialá nna huaccani lu' inèni lu' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Labí yà fruto tsè' té nu ribia fruto mal lúį; nihua labí gaỹa du ttu yà mal nu runna fruto tsè'. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Porqui'ni ttu ttu ca yà nna redacca' rábani cą por ca fruto nu runna cą. Pues labí redi' ri'u exxuhuí nihua betsulí' ỹixi lo ca yèttse'. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ą'hua ttu enne' tsè' nna runi huą́ nu ná tsè', porqui'ni puro nu ná tsè'ba riguą lo lostu'į. Pero ttu nu ná mal nna runi lą́ nu labí ná tsè', porqui'ni yù'u mal lo lòstu'į. Porqui'ni por ca titsa' nu rinne ttu enne' nna, ą' modo nna rulue'ní ti'iỹa ná ca la' rulábalatsi' nu riguą lo lòstu'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Biecca reya le inte': Señor, Señor, ti'atsi yala titsa' rappa le inte', atsi'íni labí runi le nu nia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nuỹa tediba da' lani inte' nna gudà nàgui'į ca titsa' quíyi'į nna runią cą nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","inte' nna guni ya' ą comparar tì'a ttu ènne'yu' bedua bi ttu yú'u. Primérute gutàni bi itéttianí nna gulèqquia bi cimiento tsè' nu púruani íyyaá. De biria yò nna gutsé'e inda yú'a lani itute fuerza quì'į, pero nìdi làa gutá yú'a porqui'ni duą tsìttsì lo íyyaá. ");
INSERT INTO zaaNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero nu riyénini ca titsa' quíyi'į atsi'íni labí runią nu ríquixa'a' nna, ccą́ comparar ttu nubeyu' bedua yú'u quì'į lo gùnà' ba nna labí gúl·lidą cimiento. Acca de biria yò nna gutàttsa'ą yú'a lani itute fuerza quì'į nna gubixi chì yú'u qui' niá nna, de una vez tení bil·lùỹa latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Beyacca ba gunne Jesús lani ca enne' tsè'e nía titsa' qui'áa nna, gutè'e le' yetsi Capernaum. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nía nna dua ttu capitán enne' romano dua tè ttu mozo quì'į nu yala catsi'ínią, pero mózuá nna yala fuerte rà'nią nna lo lù'uti taá chi tíą. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bina bá capitáan nu cca qui' Jesús nna guthèl·la' tìą tuchùppa canu rigú'ubia' qui' ca judíua para gata'yúni cą ne qui'ni tsíe eyúnini mozo qui' niá. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Làcą nna huía cą ru'a lo Jesús nna yala favor gutìnani cą ne nna ra cą: Hua ná bá qui'ni guni cuią'lu' favor lani nubéyu'a, ");
INSERT INTO zaaNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","porqui'ni catsi'ínią nación qui' rí'uį nna chi hua beduą ttu sinagoga qui' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús nna huía tìe lani cą, pero álateérugá idittu' gá reyatsa para itsìna' cabi nna guthèl·la' capitáan ca amigo quì'į para tattsa' cą Jesús nna gá cą ne: Señor, bittu ccá cuią'lu' molestar porqui'ni labí ná' nu dacca' para gá'a cuią'lu' le' litsá'a', ");
INSERT INTO zaaNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","acca nìdi làa beyaỹa te' ìta' propio tegani inte' ru'a lo cuią'lu', pero ina teruba cuią'lu' qui'ni hueyàcca mozo quíya'a nna, eyàcca taá latsi'į, ");
INSERT INTO zaaNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","porqui'ni inte' nna dua huá' bajo la' rigú'ubia', ą'hua tsè'e huá ca soldado bajo la' rigú'ubia' quia' nna. Canchu épa'a' ttuą qui'ni tsíą nna pues huíyą. Ą'hua canchu gáỹia' áttuą nna pues huìtą. Ą'hua mozo quí'a nna épa' ya' ą: Beni nui nna, entonces guni bą́ na. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","De biyénini Jesús nui nna yala biquila' latsi'e. Bedèqquia tè lúe nna rèe ca enne' denó cą néa: Hualigani nia' le qui'ni nìhua entre ca enne' Israel nna labí chi bilá' te' iỹeni fe tì'a té qui' nubéyu'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Làniana ca enne' guthel·la' capitáan nna deyya cą nna, de betsina' cą le' yú'u nna chi beyacca latsi' mozo qui' niá. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bitola nna huía Jesús ttu yetsi láą Naín. Dia tehuá ca discípulo qui'áa lani e ą'hua ca enne' ỹétse'ní nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","De bitsina' Jesús ru'a yétsiá nna, méruá ribèqquia cą ttu nu yatti nna dia cą gucàttsi' cą na, uccua ttu rùbani ỹi'ni niula viúdaá. Iỹetse' ca enne' yétsiá nna dia huá cą hueni niuláa acompañar. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Señor nna bilá' bánie niuláa nna yala betua latsi'e na acca rèe na: Bíttuúru cuetsi lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Gubiga' tìe nna beláppe'e yí'na yàttìa. Gulèda tè canu nùà'ni yí'naá, làniana ra tìe nu yàttìa: Nubeyu' cuìti', lu' rinénia', beyátha. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Làniana beyacca bàni chìą nna bebé' teníą nna, guduluą bènnèą. Jesús nna betie na cuenta lani nàna qui' niá. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Iyaba ca enni'a nna biquila' yà'ani latsi' quį nna bedàliani cą Tata Dios nna ra cą: Ttu profeta lani la'huacca de ỹiabara' chi gul·lani lani ri'u. Ra huá cą: Chi gul·lani Tata Dios le' yetsiloyu para gunie ri'u ca enne' quì'e cualani. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Làniana itúbani Judea ą'hua ìta'lùbani ca yetsi canu anta' nía nna gudà titsa' nu cca qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bina tè Juan el Bautista iyaba ca milagro nu runi Jesús, porqui'ni ca discípulo qui' bía nna gutixa'áni cabi bi. Acca gutàỹi tè Juáan chuppa cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Guthel·la' tè bi cabi para inàba titsa' cabi Jesús canchu lèe Enni'a Cristo enne' ná qui'ni ìta, o canchu cueda cabi attu enne' huaya' áccá. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","De bitsina' cabi ru'a lo Jesús nna ra cabi e: Juan el Bautista nna guthel·la' bi intu' para inàba titsa' tu' cuią'lu': Tsí cuią'lu' ènni'ą' Cristo enne' ná qui'ni íl·lani, o, tsí cueda tu' attu enne' huaya' áccá. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lótaá bitsina' ca enne' qui' Juáan ru'a lo Jesús nna, chi reyúnie iỹetse' ca enne' ra'ni de biỹa tediba itsahue' ní canu bíỹaáruá dolor ní rappa cą l·le, ą'hua rebèqquie ca espíritu malo lo losto' ca enne', ą'hua iỹetse' ca ciego nna beni huée qui'ni bilá'ni cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Becàbi Jesús nna rèe ca enne' guthel·la' Juáan: Léyya líúte razón lani Juáan de nu chi bilá'ni le nna biyénini le nna. Quixá'ani le bi qui'ni ca ciego nna rilá'ni cą; ca cojo nna rida' cą, canu ra'ni yetsu' yùtsù' nna chi reyacca nàrì cą; canu cuètsu nna riyénini cą; canu yatti nna reyaccabàni cą; ą'hua canu ritè la'dí' nna chi runa cą ca titsa' de la'labàni nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ica'rubà canu labí rudu chùppanią cą denó cą inte'. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bedà' diba ca discípulo qui' Juáan nna gudulo Jesús riquixé'e nu cca qui' Juáan lani ca enne' nna rèe: Biani nua' calatsi' le úhuia' le acca biria le fuera yetsi cá. Tsí huía le tánna' le ttu nubeyu' nu ná variable tì'a ttu yíi làthi to' nu rutá titti bá be'. Pues, nia' le: Labí. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Biani biria le tánna' le. Tsí ttu enne' nu yala tsè' du ỹúi áccá. Pues canu raccu' ỹó fino quį nna ą'hua canu redi' bá nna, pues le' ca yú'u tsè'la hua ỹua cą tì'a ca rey. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Acca, biani biria le tánna' le áccá. Tsí ttu enne' ná profeta áccá. Hualigani qui'ni biria le iyénini le ttu mensajero nu adírulá enne' ỹeni tì'chu ca profeta. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Qui' bi nua' ga'na escrito làti ra Tata Dios: Nì rithél·la'a' yà'la mensajero quia', denéru bi lo lu', Para ithàlia bi néda para guni cą lu' recibir. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Riquixa'ánia' le qui'ni de lo iyábani canu chi gùlia nna, lanú profeta chi gùdua uccuą adiru enne' ỹeni tì'chu Juan el Bautista. Pero nu huaỹia' la dacca' le' reino qui' Tata Dios nna adila enne' ỹeni ną́ tì'chula Juáan. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Iyaba ca enni'a nna de biyénini cą ca titsa' qui' Jesús nna beyacca cą arrepentir hàstaá tuchùppa canu ruquiỹa qui' impuéstuá nna uccua huá cą bautizar por Juáan, porqui'ni bennia cą cuenta qui'ni ttu teruba Tata Dios née Enne' Tse' para lani iyaba clase de ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero ca fariséua ą'hua canu rethàtsilà'na nu ra lo ley nna labí guyú'u latsi' quį nu uccua latsi' Tata Dios gunie para làcą, ą'hua labí huía cą para guni Juáan cą bautizar. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Raá ruhuá Señor Jesús cą: Núní tì'na gunia' comparar ca enne' tsè'e anna cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ná cą tì'a ná ca huatsa cuìti' nu rul·la cą instrumento qui' quį lo néda nna rul·luítsa' cą idìtsa ca luetsi huatsa quį rena cą: Chi bìl·la tu' pieza alegre nna pero labí bedácca'ni le. Chì hua bìl·la tu' qui' enne' yatti nna, pero nìhua làa gurètsi le. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Anía nia' le porqui'ni bìta Juan el Bautista nna gurèni bi bechia bi labí gutò bi bìttì' di, pero rena la le qui' bi: Ttu espíritu malo du lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Gul·lani tehuá Nubeyu' de Ỹiabara' ri'ya ro bée nna pero redena le: Nui nna puro go bá nna gù'ya bá nna runią nna yala ccá tsè'ą canu ruquiỹa qui' impuesto ą'hua adí canu hueni tul·la' nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero inte' nna nia' le qui'ni cca declarar nu ná lí, porqui'ni iyaba canu hualigani té la' riyeni tsè' qui' quį nna rulue' rábani cą por ca hecho tsè' qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ttu fariséua nna gutta'yúnią Jesús tsíe lìtsi'į gúe lani ą. Gutà'a bée le' yú'u qui' niá nna gudua teníe lo méỹaá. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Le' yétsiá nna dua ttu niula yala nu tul·la' ną́ nna bina bą́ qui'ni Jesús nna ri'e litsi' fariséua, acca bitsina' tìą nù'ą ttu frasco nu tá'a ttu aceite nu rilàa' iỹixi. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Guduluą ribétsią nna huíą ru'a meỹa làti re' Jesús nna beduỹíbį ru'a lúe nna indahuìna' quì'į nna binnią lo nì'e, lani ittsa' iqquį nna bedibìtsią cą. Bettsa'lúį ca nì'e nna bedua acéiteá lo ca nì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fariseo nu gutàỹią Jesús litsi' niá nna bilá'nią nu runi niuláa, làniana belaba latsi'į lo lostu'į: Cáalá nubéyu'į hualigani ną́ profeta nna, entonces hua nabia' lánią nuỹa clase de niula ní nua' ruláppa'ą na, ą'hua ti'iỹa ná là'dua qui' niulą', pues ttu niula perdida tè ną́. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Làniana ra tè Jesús na: Simón, ttu cosa té qui'ni épa'a' lu'. Lą nna rą ne: Gunàba cuią'lu' Maestro. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús nna rèe na: Ttu nu rutèsa bel·liu nna gutsé'e chuppa ca enne' gudàa cą qui' bi. Ttuą nna gudą̀ gayu' gayua' denario qui' bi. Attuą nna gudą̀ tsieyóna' denario qui' bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero làcą nna labí té qui' quį quiỹa cą, acca beniỹén bá latsi' bi qui' chuppa taá quį. Annana ina lu', núlá canuá adiru catsi'íni cą bi cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Becàbi Simón nna rą: Inte' nna cate' qui'ni nu beniỹén latsi' bi quì'į adiru iỹeniá. Jesús nna rèe na: Làtegani ná la' rulába latsi' qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Raá ruhuá Jesús na acerca de niuláa: Simón, tsí hua rilá'ni lu' niulíį. Hua yù lu' qui'ni loti' gul·lánia' litsi' lu' nna labí benna lu' inda para quíiní ca nì'a', pero niulíį nna chi gutìią ca nì'a' lani indahuìna' quì'į nna bedibìtsi tią cą lani ittsa' iqquį. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Labí bettsa'ló lu' lua' de runi lu' inte' saludar, pero niulíį nna dèsdeba gul·lánia' le' litsi' lu' nna labí ni'i gudùtsią ruttsa'lúį nì'a'. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Labí bedua lu' aceite iqquia', pero niulíį nna chi beduą aceite lo nì'a'. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Acca nì riquixa'ánia' lu' qui'ni niulíį nna porqui'ni chi rului'ą qui'ni yala la' tsì'ilatsi' té lo lòstu'į, acca ritelíni ri'u qui'ni ca tul·la' ỹétse'ní quì'į nna chi ná cą perdonado. Pero nuỹa tediba labí nabia'nią iỹeni perdón qui' Tata Dios nna, nuá nna ti'to' ba la' tsì'ilatsi té lo lòstu'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Làniana rèe niuláa: Chìba beyuniỹén látsa'a' iyaba ca tul·la' qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","De biyénini canu ỹùàni júntuba lani e lo méỹaá ca tìtsa'a nna, gudulo cą ra luetsi quį: Núní ná nui acca reyuniỹén latsi'į ca tul·la' cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús nna rèe niuláa: Por fe nu té qui' lu' lani inte' nna, acca chi gulàa lu', beyya ba lani la' redácca' latsi'. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Gutè ba nna huía Jesús le' iyaba ca ciudad nna ca yetsi nna benie predicar evangelio nna gutixe'e ca enseñanza nu cca qui' reino qui' Tata Dios. Tsì'nu ca discípuluá nna dia huá cabi lani e. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Dia hua tuchùppa ca niula canu huí'ni por ca espíritu malo ą'hua por bíỹaáruá itsahue' ní nna, chi beyuni Jesús cą. Entre ca niuláa nna laní María nu yetsi Magdala nu beria gàtsi ca espiritu malo lo losto' niá, ");
INSERT INTO zaaNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ą'hua Juana niula qui' Chuza nu ná jefe le' palacio qui' gobernador Herodes, ą'hua Susana nna, ą'hua iỹé tse'éruhuá adí ca niula canu beni cą Jesús cualani nna bete cą lani e biỹa té qui' quį nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Làniana bitùppa tè ca enne' ỹétse'ní da' cą le' iyaba ca yétsiá nna bitsina' cą ru'a lo Jesús. Lèe nna gutixa'ánie cą ca enseñanza tsè' por medio de ttu comparación nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ttu campesino nna díą huedàl·la ỹua'. De chi yu'ą́ huedàl·la ỹú'a nna binnia tí' ỹú'a lo néda. Gutè tè ca enne' nna bel·lia cą ca semíllaá, huadi tè ca bìnni to' nna bedíga' cą na. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ati' ỹú'a nna binnią le' íyyarrúe. Gul·lani bą́ nna gubitsi taą́ porqui'ni labí lùppa' re'. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ati' ỹú'a nna binnią làti yù'u huá l·lú ca yèttse'. Ca yèttsi'a nna gul·lani tehuá cą nna bedibàga' taá cą lo ỹú'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ati' ỹú'a binnią le' loyu tsè', gul·lani bą́ nna benna tìą lènà' hàstaá gayua' ttu ttuą. Gunne te Jesús attu adiru idìtsa nna rèe: Nu calatsi' ttélinią nna gudà tsè' nagui'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ca discípulo qui' Jesús nna gunàba titsa' cabi e nna ra cabi: Biani enseñanza ni nua' gutixa'a cuią'lu' lani comparación nà'. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús nna rèe cabi: Lebi'į teruba ná qui'ni ttélini le ca secreto acerca de reino qui' Tata Dios, pero adí ca enne' nna, puro lani ejemplo ba rinéni ya' cą, para qui'ni màsqui'ba hua rinna' cą pero labí ilá'ni cą, ą'hua màsqui'ba hua rudà naga' quį, pero labí ttélini cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Annana ethàtsilà'na' comparación nu beni ya'a para qui'ni ttélini lí ą. Semillaá nna ną́ titsa' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ttu te ca enne' nna ná cą tì'a ỹua' nu binnia cuitta' néda, porqui'ni de riyénini cą tìtsà'a nna ril·lani taá numalua nna runią qui'ni iỹùl·lani cą na, anía modo nna labí tsíalatsi' quį para l·lá cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Attu te ca enne' nna ná cą tì'a ỹua' nu binnia le' íyyarrúeá pero labí dia gá l·lú quį itettia, porqui'ni de riyénini cą ca titsa' qui' Tata Dios nna ria tegáláa latsi' quį. Pero canchu chi ril·lani ca prueba nna, cca taá cą apartar porqui'ni labí fuerza té qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Attu te ca enne' nna ná cą tì'a ỹua' nu binnia le' yèttsi'a; porqui'ni ca tsina qui' quį nna ca riqueza qui' quį nna ca vicio qui' quį nna ruthàga' taá cą lo quį; acca reyà'na cą sin fruto. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero attu te ca enne' nna ná cą tì'a ỹua' nu binnia le' loyu tsè'a, porqui'ni lani ttu losto' tsè'ni nna lani gusto ní nna rigua cą ca titsa' nu riyénini cą nna runi cą seguir lani paciencia; làcanuá nna runna cą fruto tsè'. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Lanú nuỹa rugàl·la' ttu yi' nna rutòthe' tìą ttu yethu' lúį nìhua làa ruduą na ỹarèe' lònà quì'į, sino qui'ni rudua lą́ na ttu lugar làti gudàni'ą qui' iyábani canu gá'a le' yú'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ą'hua labí biỹa secreto ní té qui'ni làa guna ri'u ą, nihua labí biỹa nu gàttsi' té sin qui'ni làa cca ri'u ą saber nna ilá'níą nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Acca liudà tse'éruhuá naga' le, porqui'ni nuỹa tediba té la' ritelíni quì'į nna entonces thí' lą́ adí; pero nu labí té quì'į nna, pues hàstaa ti'to' nu rulaba latsi'į qui'ni chi té quì'į nna ítua telą́. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Làniana bitsina' nàna qui'áa nna ca bettsi' áa nna, pero de tántua ca enne' ỹetse' nna labí uccua ibiga' cabi làti dùe. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Guixa'áni cą ne nna ra cą: Nàna qui' cuíą'lu'a nna ą'hua ca bettsi' cuíą'lu'a nna tsè'e cabi fuera calatsi' cabi ilá'ni cabi cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Becàbi Jesús nna rèe: Canu rudà naga' quį titsa' qui' Tata Dios nna runi cą nu rèe nna, làcą nna ná cą nàna quia' nna ca bèttsi'a' nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Attu vuelta nna gutà'a Jesús le' ttu barco lani ca discípulo qui'áa nna rèe cabi: Tté ri'u attu ládulá indatù'į. Làniana dia tè cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mientras tè dia cabi lo indatù'a nna guta'áthi Jesús. Ttùba là' gul·lani taání ttu iyyabe' fuerte ní lo indatu'a, rà'a chì indaá le' bárcuá nna, lo peligro taá chi dàa cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Gubíga' cabi ru'a lo Jesús nna bedibàni cabi e nna ra cabi e: Maestro, Maestro, chi rinetsi ri'u. Huàtha taá Jesús nna gutìtse'e iyyabe'á nna indatù'a nna, gudu tsi taá cą nna, tsi diruba ùccua taá. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesús nna rèe cabi: Tsí labí fe té qui' le lani inte' cá. Ca discípuluá nna uccuaỹí yà'aba latsi' cabi nna gùtsini cabi nna ra luetsi cabi: Núgani ènni'į, acca hàstaba be' nna indatù'į nna gutìtse'e cą nna biyeni taáni cą quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bitsina' tè cabi terreno qui' ca enne' gadareno, ga'ną attu ládulá indatò' qui' Galilea. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Huàdi bée ru'a yúbitsi nna bitsina' tè ttu nubeyu' qui' yétsiá nna tattsa'ą Jesús. Nubéyu'a nna chi gutsàni ccą padecer por ca espíritu malo nna labí raccu' ỹúį nìhua labí riduą le' yú'u, sino gurèni bą́ làti rigàtsi' canu yatti. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bilá' bánią Jesús nna guretsi yà'anią nna bedu tè ỹibį ru'a lúe, gunnią idìtsa nna rą: Biani té qui' lu' lani inte' acca da' lu' Jesús Ỹi'ni Tata Dios enne' dua ỹiabara'. Ratta'yúnia' lu' bittu guni lu' inte' castigar. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Anía rą porqui'ni beni Jesús espíritu malua mandado qui'ni erią lo losto' nubéyu'a. Chi gutsàni naxu'ą nubéyu'a. Iỹé vuelta tsè' chi beỹìga' ca enne' na lani cadena, pero guchù tì'nią cą. La'a mísmuba espíritu malua nna benią latsi' nubéyu'a cuenią fuera yetsi. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Gunàba titsa' Jesús na, nna rèe: Biani lá lu'. Becàbią nna rą: Legión lá'. Anía becàbią porqui'ni iỹetse' ca espíritu malo chi gutà'a lo lòstu'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ca espíritu malua nna gutta'yú tèni cą Jesús qui'ni bittu gudàl·lee cą le' lugar chul·la. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Bilá'ni ca espíritu malua qui'ni tsè'e iỹetse' ni ca cùttsi huìla go cuitta' i'yaá. Acca gutta'yúni cą ne qui'ni hue'él·le'e cą gá'a cą lani ca cùttsia. Lèe nna bete bée permiso qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Beria bá cą losto' nubéyu'a nna gutà'a tè cą lani ca cùttsia. Ca cùttsia nna uccua litsianì cą nna beduyú iqquia quį lo ttu bèl·la'a, binnia tè cą le' indatù'a nna gutti cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Canu rappa ca cùttsia nna bilá' báni cą nu uccua nna beyya cą quètha tatixá'a cą le' yétsiá nna ca rancho tú'a nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Biria tè ca enni'a tanna' cą biỹa nuá uccua. Bitsina' cą làti du Jesús nna bilá'ni cą nubeyu' nu beria ca espíritu malo lo losto' niá qui'ni tsè' tabá chi ri'ą ru'a lo Jesús naccu' ỹúį Làniana làcą nna yala gùtsini cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Canu bilá'niá nna gutixa'áni cą ca enne' ti'iỹa uccua lani nubéyu'a de gulą̀ latsi' ná' ca espíritu malua. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Làniana iyáỹiani ca enne' qui' ituba región Gadara nna gutta'yúni cą Jesús qui'ni ucuìtta bée lani cą porqui'ni yala rátsini cą. Jesús nna beyàppie le' barcuá nna déyyeé. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Làniana nubeyu' nu beria ca espíritu malo lo losto' niá nna gutta'yúnią Jesús qui'ni hue'él·le'e na tsíą lani e, pero Jesús nna bechu tìtse'e na, nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Beyya ba litsi' lu' nna bè'ni ca enne' titsa' ti'iỹa ná ca cosa ỹeni nu chi beni Tata Dios lani lu'. Lą nna deyya tìą nna rudą̀ titsa' le' itúbani yétsiá ti'iỹa ná ca cosa milagrosa nu chi beni Jesús lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Betsina' ba Jesús attu lado indatù'a nna yala redácca'ni ca enne' de bilá'ni cą ne, porqui'ni iyaba cą nna ribèda cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Làniana bitsina' ttu enne' láą Jairo nubeyu' principal le' sinagógaá, beduỹíbį ru'a lo Jesús nna gutta'yúnią ne qui'ni tsíe litsi'į, ");
INSERT INTO zaaNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","porqui'ni dua turuba ỹi'ni niulíį, ttú tsì'nu ida ti'gánią nna chì' tení rattią. Dia tè Jesús ą'hua ca enne' ỹétse'nía hàstaá qui'ni ruquìni cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Entre ca enne' ỹétse'á nna dia huá ttu niula nu chi dia tsì'nu ida rà'nią riduą́ réni ttu parte qui' cuerpo quì'į. Chi benittiluą iyate nu té quì'į lani ca médico, pero nì ttú cą labí uccuani cą eyuni cą na. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Lą nna gubiga' tìą cuè'e la Jesús nna beláppa'ą ru'a ỹúeá. Làniataá nna beyacca latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesús nna ra cą: Núní nua' beláppa'ą inte'. Iyaba cą nna ra cą: Labí yù tu'. Làniana ra tè Pedrua ą'hua adí canu tsè'e lani bía: Maestro, ca enne' ỹetse' nui da' nì ruquìni cą cuią'lu' nna rihuàttsa'ní cą cuią'lu', atsi'íni ra cuią'lu': Núní nua' beláppa'ą inte'. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero Jesús nna ra tìe: Nuỹa nua' chi beláppa'ą inte' porqui'ni gutebe' te' qui'ni biria la'huacca lani inte' para eyacca latsi' nuỹa ttu enne'. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Niuláa nna de bennią cuenta qui'ni labiru igàtsi'ą nna guduluą biỹìtti'níą nna gubíga'ą nna beduỹíbį ru'a lúe. Gutixa'ánią ne ru'a lo iyáỹiataá ca enne' tsè'e nía biỹa qui' acca beláppa'ą ne, ą'hua ti'iỹa tsàtiní beyacca latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús nna bechu tìtse'e niuláa nna rèe na: Ỹì'nia', por fe nu té qui' lu' lani inte', acca chi beyacca latsi' lu'; bíttuúru nùyue cani lu' sino gappa lu' la'ỹeni. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Atsaba rinne Jesús nna, bitsina' tè ttu enne' da' le' litsi' Jairo nu ná principal qui' sinagógaá nna rą Jaíruá: Ỹi'ni lù'a nna chi gùttìą, bíttuúru uquìtsi'ni lu' Maéstruą'. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Biyeni báni Jesús nna ra tìe Jaíruá: Bittu gátsini lu', huía teruba latsi' lu' nna hueyacca bá latsi' ỹi'ni to' lù'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Làniana gutà'a Jesús le' yú'a. Lanú nuỹa be'él·le'e gá'a le' yú'a sino làteruba Pedrua nna Jacóbua nna Juáan nna, ą'hua tàta nàna qui' niula cuìti'a nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iyaba cą nna yala ribétsi cą nna, yala lani la' rehuiní' latsi' tsè'e cą por niula cuìti'a. Jesús nna rèe cą: Bittu cuetsi le, porqui'ni bihua ną́ nu yatti, sino ti'éthibą́. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Làcą nna burla lá beni cą Jesús porqui'ni hua yù ba cą qui'ni chi gùttìą. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pero lèe nna gutèl·le'e ní'į nna gunnie idìtsa nna rèe: Niula cuìti', beyátha. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Beyaccabàni chìą nna beyátha tìą. Lèe nna rèe cą qui'ni hué' cą na nu gúą. ");
INSERT INTO zaaNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tàta nàna qui' niá nna uccuaỹí yà'aba latsi' quį. Jesús nna gunènie cą qui'ni nú ttú tehuá nuỹa quixá'ani cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Betùppa ba Jesús tsì'nu ca discípuluá qui'áa nna, betie la'huacca qui' cabi para ineni cabi ca espíritu malo qui'ni eria cą lo losto' ca enne', ą'hua para eyuni cabi biỹa tediba clase de itsahue' nu ridácca' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Guthel·la' tìe cabi hueni predicar acerca de la' rigú'ubia' qui' Tata Dios, ą'hua para eyuni cabi canu rà'ni. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ra tè Jesús cabi: Bittu biỹa huá' le para lo néda; nìda ttu yà to' làa theni le, nìhua bolsa, nìhua etta bittu huá' le, nìhua bel·liu nna. Bittu huá' le chuppa camisa, sino ttu teruba nu naccu' le dia le. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nuỹa litsi' ní itsina' le nna, níabá ccá lugar qui' le hàsta'na gal·la' tsá éda' le le' yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Gaỹa tediba lugar ní làa guni cą le recibir nna, eria le le' yétsiá, pero gucuíbi bestè nì'a le, para ttélíní qui'ni bíttuúru ná le responsable qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Làniana biria cabi nna dia cabi iyábani ca yetsi. Itú lettia bání gutixa'áni cabi ca enne' ca titsa' qui' Tata Dios ti'iỹa modo l·lá cą, ą'hua beyuni cabi canu ra'ni. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Bina tè gobernador Herodes iyaba nu runi Jesús nna bedu chùppaníą porqui'ni ttu te cą nna ra cą: Juan el Bautista nua' chi beyáthą de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Attu te cą nna ra cą: Elías nua' chi gul·lani. Adí cą nna ra cą: Ttu profeta gùdua tiempo antigua nua' beyáthą de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Laniana ra Herodes: Inte' benia' mandado ichu cą yáni Juáan. Pero núlá nui iỹetse' ca milagro riyeni te' quì'į cá. Acca yala uccua latsi' Herodes ilá'nią Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","De bitsina' ca apóstol nna bè'ni cabi Jesús titsa' iyaba nu beni cabi. Làniana guchi'e cabi ttu lugar yà'latsi' exataá yetsi Betsaida. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bina bá ca enne' qui'ni nía bá re' Jesús, acca huía tè cą ru'a lúe. Lèe nna benie cą recibir nna gutixa'ánie cą nu cca qui' la' rigú'ubia' qui' Tata Dios, ą'hua beyúnie canu huía para eyacca latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","De chi da' ràl·làa nna gubíga' tsì'nu ca discípulo qui' Jesús ru'a lúe nna ra cabi e: Bechu titsa' dí cuią'lu' ca enne' para qui'ni tsía cą le' ca yetsi to' ą'hua ca rancho to' canu anta' ìta'lùba, para tatìla cą làti eyà'na cą nna gó'o cą nu go cą, porqui'ni labí biỹa té làti tsè'e rí'uį para làcą. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús nna rèe cabi: Lebi'i ba, líhue' cą go cą. Làcabi nna ra cabi e: Labí biỹa té qui' tu' sino làteruba gayu' ettaxtíla nna chuppa bél·la tó' nna. Solamente canchu tsá' gu' gó'o tu' nu go iyaba ca enni'į huaccani tu' úgo tu' cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Hua ná ttú gayu' mili' tì'ga ca nubeyu' lània. Làniana ra tè Jesús ca discípulo qui'áa: Líúxuaní cą por grupos de tsieyóna'. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aníabá beni cabi, bexuaní cabi iyaba cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Làniana guỹi' tè Jesús gayu' ca ettaxtílaá nna chuppa ca bél·la tú'a nna, guchìtha lúe ỹiabara' nna gunàbèe bendición lani Tata Dios Làniana gùl·le'ée cą nna bete tìe lani ca discípulo qui'áa para qui'ni quthia cabi lani ca enni'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Iyaba cą nna gutó cą ti'iỹa ba ùccuaní qui' quį. Bitola nna betùppa cabi átsì'nu ỹa tsùmmi tsà'ti'ni ca pedazo nu bexàni ca enni'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ttu tsá lània nna huía Jesús ttu lugar yà'latsi' lani ca discípulo qui'áa nna benie oración. Bitola nna beyéqquie nna rèe cabi: Núní rena ca enne' qui'ni ná inte' cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Becàbi cabi nna ra cabi: Ttu te cą nna rena cą qui'ni ná cuią'lu' Juan el Bautista. Attu te cą nna rena cą qui'ni ná cuią'lu' Elías. Adí cą nna rena cą qui'ni ná cuią'lu' ttu profeta gùdua tiempo antigua nna beyátha bi de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesús nna rèe cabi: Lebi'į chúná, núlá rulaba latsi' le ná' ni'i. Becàbi Pedrua nna ra bi e: Cuią'bálu' enni'a Cristo enne' chi nani Tata Dios ithel·le'e yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero Jesús nna rèe cabi qui'ni nú ttú tehuá nuỹa quixá'ani cabi nui. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Làniana rèe: Nubeyu' de Ỹiabara' nna té qui'ni quée padecer iỹetse' ca cosa, ą'hua ca sacerdote principal lani adí canu rigú'ubia' entre ca enne' judío nna ca maestro de la ley qui' caniá nna guyudí' cą ne hàstaá qui'ni gutti cą ne, pero bitola de tsunna ubitsa nna eyáthee de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Làniana rèe iyaba cabi: Nuỹa calatsi'į thá'ą lani inte' nna, té qui'ni iỹùl·lanią la'a labą́ ttu ttu tsá bá nna ga'ną dispuesto guchią curutsi ìdi'i qui'į nna tanuą inte'. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Porqui'ni nuỹa tediba dua iqquį etúa latsi'į la'labàni quì'į nna, pues gunìtti lą́ na. Pero nuỹa tediba ga'ną dispuesto tanúą inte' màsqui'ba gutti cą na, entonces ccabàni lą́. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Canchu ttu enne' nna gúniní quì'į itúbani yétsiloyu, pero bitola nna ccą vencer nna nitti bą́. Biani gana ni benią cá. Labí biỹa. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Porqui'ni nuỹa tediba ettu'nią quixá'ą nu cca quia' ą'hua ca titsa' quíyi'į nna, entonces ettu' huáni Nubeyu' de Ỹiabara' na canchu chi el·lanie lani la'yani' qui' Tata Dios nna ca ángeli quì'e nna para cu'úbi'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Hualigani te' nia' le qui'ni tuchùppa canu tsè'e nì lani inte' nna labí gatti cą hàstaá qui'ni ilá' ỹáni cą ti'iỹa ná reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Xunu' ubitsa tì'ga bitola de ra Jesús ca tìtsa'ą' nna, guchi'e Pedrua nna Juáan nna Jacóbua nna huíe lo i'yaá huèni oración. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Miéntraste runie oración nna bettsiání la' rinna' quì'e nna, ą'hua ỹúe nna beyacca tsíttsì tùni nna uccua tittiníą. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Làniana de repente tabá nna gùdu chuppa ca ènne'yu' ru'a lúe nna rue' cabi titsa' lani e. Ca enni'a nna ná cabi Moisés nna Elías nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Gutsé'e cabi làhui' la'yáni'a nna bè' cabi titsa' ti'iỹa ccá Jesús padecer le' Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedrua lani áchuppa ca discípulo tsè'e lani bía nna, demasiado bétsiàla da' qui' cabi, pero ténna' bá cabi nna bilá'ni cabi la'yani' nu cca tittiní cuerpo qui' Jesús lani áchuppa ca ènne'yu' tsè'e cabi lani e. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chi deyya taání Moisés nna Elías nna, gunne tè Pedrua nna ra bi Jesús: Maestro, yala tsè' canchu eyà'na ri'u nì nna guni tu' tsunna yú'u l·la' tó': ttu para cuią'lu' nna, áttu para Moisés nna, attu para Elías nna. Pero Pedrua nna nìhua làa yù bi biỹa nuá ra bía. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Atsaba rinne bi ca tìtsa'a nna gul·lani ttu bía nna bedibàga'ą cabi. Làniana yala gùtsini cabi porqui'ni gutebé'ni cabi chi yù'u cabi le' bía. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Làniana biyénini ttu tsi'i dèsdeba le' bía nna rèe: Là enni'į enni'ą' Ỹì'nia', yala catsi'í ti' e, liudà naga' le quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Biyeni dibáni cabi ca tìtsa'a nna bilá'ni cabi qui'ni álatèruba Jesús du. Ca discípuluá nna uccua taá tsi qui' cabi nna, nú ttú tení nuỹa gutixa'áni cabi nu bilá'ni cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Attu yu'utsá nna de beyàdi cabi lo i'yaá nna, iỹétse'ní ca enne' dia cą tattsa' cą Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ttu nubeyu' entre ca enne' ỹétse'á nna gunne tìą idìtsani nna rą: Maestro, ratta'yúnia' cuią'lu' qui'ni thá' lu' inna' lu' ỹì'ni ya'a, pues turubą dua quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Porqui'ni ttu espíritu malo nna rudàxu'ą na, de repente taá ribétsiya'ą nna ruxitti' tsa'tsa'níą na, betsina' ní ruduą rú'į nna runią na maltratar, nibàni rútse'e latsi'į na. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Chi gunábania' ca discípulo qui' cuíą'lu'ą' qui'ni gudàl·la cabi espíritu malua fuera, pero labí uccuani cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Becàbi Jesús nna rèe: Lebi'į descendiente qui' canu labí ríalatsi' nna ca rebelde nna, atsáliacà'a itsá dàa te' cuénia' lani le nna gúchía' le cá. Tahua' ỹi'ni lù'ą' nì. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","De gubíga' nubeyu' cuìti'a làti du Jesús nna, berixi betetsíní espíritu malua na bexìtti' tsa'tsa'níą na, pero Jesús nna gutìl·lée espíritu malua nna beyuni tìe nubeyu' cuìti'a, bete tìe na cuenta lani tàta qui' niá. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Iyaba cą nna biquila' yà'ani latsi' quį de bilá'ni cą ti'iỹa ná la' retúalatsi' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Miéntraste rulaba latsi' quį acerca de iyaba ca milagro nu beni Jesús nna ra tìe ca discípulo qui'áa: Liudà tsè' naga' le nu équixa'a', bittu iỹùl·lani le na: I'yu tsá qui'ni gute cą cuenta Nubeyu' de Ỹiabara' làtsi' ná' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero làcabi nna labí gutelíni cabi ca tìtsi'į, porqui'ni labí ná qui'ni ennia cabi cuenta, ą'hua labí beyáỹani cabi inàba titsa' cabi e acerca de ca tìtsa'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Làniana gudulo ca discípuluá huèni discutir sobre de nùỹala cabí ccá adiru enne' ỹeni. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","De gutelíni Jesús la' rulaba latsi' nu té lo losto' cabi nna, gùỹi'e ttu huatsa to' bedue na luítte'é. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Làniana rèe cabi ttu ejemplo: Nuỹa tediba gunią recibir huátsíį porqui'ni ríalatsi'į inte' nna, entonces tì'atsi inte' bá nuá runią recibir. Ą'hua nu runią inte' recibir nna, álahua tsuą' teruba inte' runią recibir sino hàstala enne' guthel·le'e inte' runią ne recibir. Porqui'ni canu rulaba latsi' quį qui'ni labí dacca' cą entre lebi'į nna, làcą nna adila enne' ỹeni ná cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Làniana becàbi tè Juáan nna ra bi Jesús: Maestro, bilá'ni tu' enne' qui'ni lani nombre qui' cuią'lu' nna runią mandado ca espíritu malo qui'ni eria cą lo losto' ca enne', pero gunèni tu' ą qui'ni bíttuúru gunią na porqui'ni labí láníą ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús nna rèe bi: Bittu guthàga' li ą, porqui'ni nu labí ná contrario qui' ri'u nna, pues parte ri'u ba dúą. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","De chi bì'yu tiempo qui'ni ccá Jesús recibir le' ỹiabara' nna, gulèqquia tsìttsì taá latsi'e éyyeé Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Beneru tìe tuchùppa ca discípulo qui'áa. Làcabi nna huía cabi hàstaá ttu yetsi qui' región láą Samaria; le' yétsiá nna gunàba cabi ttu lugar para Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero canu Samáriá nna labí beni cą ne recibir porqui'ni née ttu enne' de raza judío nna déyyeé Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","De beyu ca discípuluá qui'ni betsibi bá cą ne nna, acca Jacóbua nna Juáan nna ra tè cabi e: Señor, tsí hua calatsi' cuią'lu' qui'ni inàba ri'u qui'ni chadi yi' qui' ỹiabara' para gul·luỹą latsi' quį de una vez tení tì'a beni Elías tiempo antigua. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Gunna' tè Jesús cabi nna gutìtse'e cabi nna rèe: Lebi'į nna nìdi làa yù le biỹa clase espíritu ní té qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Porqui'ni inte' nna labí daya' para gunia' qui'ni gul·lúỹa taá' latsi' ca enne', sino para gudilàa lá ya' cą. Làniana huía cabi attu yetsi to'. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Néda bá yù'u cabi nna ra tè ttùą: Señor, hua tanua' cuią'lu' gaỹa tediba tsía cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Becàbi Jesús nna rèe na: Ca beda' nna hua tsìa bèlia qui' quį, ą'hua ca bìnni to' ridàa lo be' nna hua tsìa huá xcu'ni to' qui' quį, pero Nubeyu' de Ỹiabara' nna labí té gaỹa quixa iqquie. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ra tè Jesús áttuą: Gutà tanó inte'. Lą nna becàbią nna rą ne: Señor, be'él·la' ỹá inte' éya'a' tacáttsi'a' tàta quí'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús nna rèe na: Be'él·la' canu yàttia' gucàttsi' luetsi nu yatti quį, pero lu' nna huía taquixá'a nu cca qui' reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Làniana ra huá áttuą ne: Tanó huá' cuią'lu' Señor, pero be'él·la' ỹá inte' táchú tìtsa'a' canu tsè'e le' litsá'a'. ");
INSERT INTO zaaNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús nna rèe na: Nu rudàxu' nì'a yarátu nna canchu gudèqquia lúį para inna'ą cuè'e líį nna, entonces labí ttùli rida' náà quì'į. Ą' tehuá nu calatsi'į tánúą inte', porqui'ni canchu dua ba iqquį nu té yétsiloyu nna entonces labí iỹu'ą para reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Gutè ba nuá nna, beni Señor nombrar á setenta ca ènne'yu' nna guthel·le'e chuppa chuppa cabí para neru cąbi tsía cabi iyaba ca yetsi nna ca rancho to' nna làti ná qui'ni tsíe. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ra tìe cabi: Hualigani iỹeniní lènà' chi té para éỹu', atsi'íni tuchùppa rúbani ca obrero tsè'e. Acca linàbani Tata Dios enne' ná Xana' lóyúį qui'ni ithel·le'e adí ca obrero gutùppa cą lènà' quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hué' le cuidado, porqui'ni làti tsía le nna hua té peligro, tì'a canchu tsè'e ca carnero to' entre ca lobo. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bittu huá' le bolsa nìhua bel·liu. Bittu cu'ú nì'a le biỹa. Ą'hua nú ttú tehuá nuỹa gul·luítsa' le lo néda. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Gaỹa tediba yú'u ní gá'a le nna, primérute ina le: La'ỹeni para lo losto' ca enne' tsè'e le' yú'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Canchu tsè'e nía canu rú'ulatsi' quį ca titsa' de la'ỹeni nna, làniana gata' huá la'ỹeni lo losto' quį. Pero canchu gutsìbi cą le nna, entonces labí la'ỹeni egà'ną lani làcą, sino lani lebi'i ba eyà'ną. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Canu guni cą le recibir nna, nía bá ccá lugar qui' le; iyate nu gunna cą qui' le nna pues go ba le cą, í'ya ba le cą nna, porqui'ni ttu obrero nna cca bą́ merecer thí' láỹį. Bittu eyá'na le ttu ttu yú'u bá. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Gaỹa tediba yetsi ní gá'a le nna, canchu guni cą le recibir nna, go ba le nu gutsia cą ru'a lo le. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Eyuni huá le canu rà'ni nía. Gá tè le cą: Calatsi' Tata Dios qui'ni hue'èl·la' li e qui'ni quée enne' cu'úbia'nie le. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero canchu itsina' le ttu yetsi làti labí tsú'ulatsi' quį ca titsa' nu inne le lani cą nna, eria le lo ca néda nna ina le: ");
INSERT INTO zaaNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Hàstaá bestè qui' yetsi qui' líį nu chi uccua nì'a tu' nna rucuíbi tu' ą por ttu seña contra lebi'į, pero ccá le saber qui'ni gul·lani reino qui' Tata Dios ru'a puerta qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Riquixa'ánia' le qui'ni adila fuerte ccá la' tsìalatsi' qui' Tata Dios nu chì' da'la lani yétsiá tì'chula lani ca enne' Sodoma. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ica'rútsi'íru lu' yetsi Corazín. Airu lu' yetsi Betsaida. Porqui'ni cáalá le' ca yetsi Tiro nna Sidón nna uccua ca milagro canu chi uccua lani lebi'į, pues cuando lání chì gucu' cą lári' corriente nna gurè'ni cą lo tte, seña de qui'ni reyacca cą arrepentir por ca tul·la' qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Acca canchu chi íl·lani juicio nna, huaỹia' lá castigo tsía canu yetsi Tiro nna Sidón nna tì'ca'la lebi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Lu' nna yetsi Capernaum, tsí rulaba latsi' lu' qui'ni cca lu' merecer tsía lu' ỹiabara'. Pero hasta rúbani infierno èxxa lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Raá ruhuá Jesús ca discípulo qui'áa: Nuỹa tediba gudà nàgui'į qui' le nna, tì'atsi quíbá' nuá rudà nàgui'į. Nuỹa tediba rutsibią le nna, tì'atsi inte' ba nuá rutsibią. Nuỹa tediba rutsibią inte' nna, rutsibi huą́ Enne' guthel·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Beyeqquia setenta ca enni'a lani la' redacca' latsi' nna ra cabi: Señor, hàstaá ca espíritu malo nna riyénini cą qui' tu', porqui'ni rinèni tu' cą lani nombre qui' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús nna rèe cabi: Làchu. Bilá' huá te' Satanás huàdią de ỹiaba tì'a ttu éthá. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Liúda naga' le. Inte' nna chi benna' la'huacca lani le para gúl·lia le iqquia ca bèl·là nna iqquia caỹareyí' nna, ą'hua guni le vencer itute fuerza qui' nu ná contrario qui' rí'ua nna, pero labí biỹa mal ni thacca' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero inte' nna nia' le: Bittu edácca'ni le de qui'ni té la'huacca qui' le sobre ca espíritu malo, sino lédácca' láni de qui'ni nombre qui' le nna tsìa cą lo lista qui' ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Làniataá nna bitsina' ttu la' redacca' latsi' lo losto' Jesús por Espíritu Santo, acca gunnie nna rèe: Tata Dios quia', runia' cuią'lu' adorar tulidàba nna cuią'bálu' ná Señor qui' ỹiabara' ą'hua qui' yétsiloyu. Inte' nna ruí'a' cuią'lu' gracia porqui'ni canu yala la' riyeni té qui' quį nna labí be'él·la' cuią'lu' qui'ni gunibia' cą ca enseñanzį, nìhua lani canu rulaba latsi' quį qui'ni yala ritelíni cą nna, pero lani ca huatsa to' la nna chi beni cuią'lu' cą declarar. Ą' ba beni cuią'lu' porqui'ni anía guyú'u latsi' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Làniana ra Jesús canu tsè'e nía: Iyaba ca cosa nna chi benna Tata quí'a latsi' nàya'. Lanú nuỹa nabia'nią Ỹi'ni áa sino làteruba Tata Dios nna nabia'nie bi. Lanú nuỹa nabia'nią Tatáa sino Ỹi'ni áa tèruba ą'hua nuỹa ba cálatsi' Ỹi'ni áa gunie Tata qui'áa declarar lani cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Làniana gunna' Jesús ca discípuluá nna gunènie cabi nna rèe: Ica'rubà canu rilá'ni luetsi ca cosa nu rilá'ni le. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Riquixa'ánia' le qui'ni iỹetse' ca enne' uccua profeta tiempo antigua nna ą'hua ca rey nna yala gudà latsi' cabi ilá'ni cabi nu rilá'ni le, pero labí bilá'ni cabi ą. Uccua huá latsi' cabi iyénini cabi nu riyénini le pero labí biyénini cabi ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Làniana guduli ttu nu rethàtsilà'na nu ra lo ley qui' Tata Dios nna uccua latsi'į ccą́ saber ti'iỹa ecàbi Jesús, acca rą ne: Maestro, biani ná qui'ni gunia' para gata' la'labàni nu labí ttíą quia' cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Lèe nna rèe na: Biani ga'na escrito lo ley. Biani ritelíni lu' làti rùl·là lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Becàbią nna rą: Cátsi'íni lu' Señor Dios qui' lu' lani itute losto' lu', lani itute latsi' lu', lani itute fuerza qui' lu', ą'hua lani itute la' rulaba latsi' qui' lu'. Cátsi'í huáni lu' iyaba ca luetsi enne' lu' ti'atsi la'a lu' ba. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús nna rèe na: Tsè'ba becàbi lu'. Beni ba nua' nna huacca bàni bá lú'. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero lą nna uccua latsi'į iria nàrìą, acca rą Jesús: Nú tegá nua' dà te' cátsi'í te' ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Becàbi Jesús nna rèe: Ttu nubeyu' nna beda'ą ciudad Jerusalén nna deyyą para yetsi Jericó. Bedàxu' ca ubànà na, gutua tè cą iyaba nu nùà'ą hàstaá ca ỹó niá, yala idí' bè' cą na, bèttì tsalíáti taání cą na becuìtta tè cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Dia tè ttu sacerdote néda nía nna bilá'nią nubéyu'a nna, pero gutè taą́ ttu lado la. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Anía tehuá beni ttu descendiente qui' Leví. Exa tegáabá nía chi díą nna bilá' bánią nubéyu'a nna, pero gutè tehuą́ ttu lado la. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Làniana ttu nubeyu' samaritano nna yù'u huą́ néda nna gul·lani bą́ exa taá làti té nubéyu'a nna bilá' bánią na, yala betúa latsi'į na. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Gubíga' tìą, gutàbią aceite nna vino nna lo ca huè' qui' niá nna beỹìga' tìą lári'. Làniana beduą na cuè'e bia' qui' niá nna, guche'ą na le' posada nna yala cuidado bè'ą na. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Attu yu'utsá nna de dia enne' samaritánuá éda'ą nna, gulèqquią chuppa moneda nna bete tìą lani nu ná xana' posádaá nna rą na: Beyu bal·la tsàtè' ą nna, iyaba nu gúniíru lu' gasto nna, hua yíỹá bá ya' ą canchu chi eyèqquia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Annana, biani rulaba latsi' lu'. Núlá canu nubéyu'a uccuatsi'íni nu beni dí' ca ubànàa cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Lą nna rą ne: Nu gúta' la' retúalatsi' quì'į lani nubéyu'a. Làniana ra tè Jesús na: Beyya nna beni huá seguir luetsi ejemplo nu bedua enne' samaritánuá. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","De yù'u tè Jesús néda nna, gutà'a tìe le' ttu yetsi to'. Nía nna dua ttu niula láą Marta nna benią ne recibir litsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta nna dua ttu ỹìlíį láą María. María nna gure' taą́ ru'a lo Jesús nna bedà nàgui'į ca titsa' quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero Marta nna yala purari ccą de runią lo sìnį. Gubíga' tìą ru'a lo Jesús nna rą ne: Señor, tsí bihua biỹa cani cuią'lu' qui'ni ỹìlá yì'į nna ruxèba latsi'į qui'ni ttùba' gunia' servir. Gútsí tsàtè' cuią'lu' ą qui'ni guni tí'ą inte' cualani. ");
INSERT INTO zaaNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Becàbi Jesús nna rèe na: Marta, Marta, yala nùyue cani lu', ą'hua yala purari cca lu' lani iỹetse' ca tsina, ");
INSERT INTO zaaNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","pero tturuba cosa adiru caduel·la'. Ỹìlá lu' Maríį nna chi becuí'ą nu adiru dacca' nna, labí ná qui'ni nuỹa enne' ní guthàga'nią na. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ttu tsá lanía nna huía Jesús ttu lugar yà'latsi' para gunie oración. De belùỹa oración qui'áa nna, gunne tè ttu discípulo qui'áa nna ra bi e: Señor, beluè'ni cuią'lu' intu' guni tu' oración, tì'a beluè'ni Juáan ca discípulo qui' bía. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Làniana ra tè Jesús cabi: Canchu chi guni le oración nna ina le íį: Tata Dios qui' tu' enne' dua ỹiabara', rinàba tu': Qui'ni nombre qui' cuią'lu' nna ccą́ nombre sagrado lo losto' ca enne', Ą'hua qui'ni ìta la' rigú'ubia' qui' cuią'lu' le' yétsiloyu nna, Ccá bá nu rú'ulatsi' cuią'lu' tì'ba ỹiabara' ą'hua le' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ą'hua qui'ni gunna cuią'lu' nu go tu' ttu ttu tsá. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Beyuniỹén latsi' cuią'lu' ca tul·la' qui' tu', porqui'ni ą'hua intu' nna reyuniỹén latsi' tu' qui' iyaba ca luetsi enne' tu' biỹa ruthácca' cą intu'. Bittu guthàna ná' cuią'lu' intu' ccá tu' tentar, sino gudilà la cuią'lu' intu' le' iyaba canu ná mal. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ra huá Jesús cabi: Canchu dua ttu amigo qui' le nna tsía le le' litsi'į ríluela yèlà nna gá li ą: Amigo, gulèqquia sàni inte' tsunna ettaxtíla, ");
INSERT INTO zaaNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","porqui'ni gul·lani ttu amigo quia' déda'ą de viaje nna labí biỹa té hué' ya' ą gúą. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Pero nuá nna ecàbią dèsdeba liú'u nna iną: Bittu uquitsí'ni lu' inte' porqui'ni puertą' nna chi yáyą ą'hua chi tía' lani ca huatsa to' quíyi'į nna labí ccá chatha' gunna' nu rinàba lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Beni Jesús seguir nna rèe: Labí chathą gunną nu rinàbą màsqui'ba ną́ amigo quì'į, pero nia' le: porqui'ni bihua rudutsią rinàbą nna, acca huayàtha amigo quì'į nna gutią iyaba nu riquìna'nią. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Inte' nna nia' le: Línaba nna huadi' ba le. Leyìla nna huetsèla báni le. Linne ru'a ttu puerta nna huathàlia báni cą le. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Porqui'ni nuỹa tediba rinàba nna huadi' bą́. Nu reyìla nna huetselá bánią. Nu rinne ru'a ttu puerta nna huayàlia bą́. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Lebi'į nu ná tàta, canchu ttu ỹi'ni le inàbą ttu ettaxtíla gúą, pues labí hué' li ą ttu íyya álá. O canchu inàbą ttu bél·la to' gúą nna, pues aỹa labí ná le capáz gute le ttu bèl·là la quì'į álá. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ą'hua labí hué' li ą ttu ỹareyí' canchu inàbanią le ttu tsitta gúą álá. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Acca canchu lebi'į màsqui'ba ná le enne' tul·la', pero hua yù ba le gute le ca cosa tsè' qui' ca ỹi'ni le, tsí álahuá adí telá Tata qui' le enne' dua ỹiabara' gutie Espíritu Santo lani gusto ní qui' canu rinàbani cą ne álá. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ttu tiempo lània nna dua ttu nubeyu' uccuą mudo por ttu espíritu malo. Jesús nna benie mandado espíritu malua qui'ni gútse'e latsi'į nubeyu' mudua. Beria bą́ nna gunne chì nubéyu'a. Canu bilá'ni nna uccuaỹí yà'aba latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero tuchùppa cą nna ra lá cą: Lani nombre qui' Beelzebú nu ná huexána' qui' ca espíritu malo runią mandado qui'ni eria cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Attu te cą nna, para guni bá cą ne prueba nna, gunàba cą qui'ni gunie ttu milagro de ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero lèe nna gutebé' taánie la' rulaba latsi' mal qui' quį nna rèe cą: Canchu nuỹa ttu gobierno lá'aní la' rigú'ubia' quì'į nna til·la tè contra la'a labíį nna, entonces l·luỹa taá latsi'į. Ą'hua ttu familia nna, canchu lá'aníą por biỹa ca disgusto ní nna, entonces labí itsáagá gúchią. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ą'hua Satanás lani ca espíritu malo quì'į nna, canchu lá'a huání luetsi quį nna, entonces ti'ala modo cue' tsìttsì la' rigú'ubia' quì'į cá. Anía nia' le porqui'ni rena le qui'ni por cualani qui' Beelzebú acca rudál·la' fuera ca espíritu malo. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Cáalá por medio de Beelzebú runia' mandado ca espíritu malo qui'ni eria cą, entonces nú lá por la'huacca quí'ní rudàl·la ca discípulo qui' le fuera ca espíritu malo cá. Acca por nu runi la'a mísmuba ca ỹi'ni le nna rulue'ní qui'ni yala equivocado ná le. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero lani la'huacca qui' Tata Dios runia' mandado qui'ni eria ca espíritu malo, acca ccá le saber qui'ni chi gul·lani la' rigú'ubia' quì'e lani lebi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Runia' le attu comparación: Canchu chi ttu nubeyu' valiente rue' cuidado litsi'į lani yèrìà nna entonces bihua nùyue canią por ca interés nu té quì'į porqui'ni rue' tsì'ą cą cuidado. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero canchu attu enne' adiru valiente íl·lanią nna gunią nubéyu'a vencer, entonces cúa tìą iyate ca yèrìà quì'į nna quithia huą́ iyate nu té le' litsi'į lani ca compa' quì'į, màsqui'ba nubéyu'a nna yala confianza gùppą lani ca yèrìàa. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Acca nia' le qui'ni nu labí du lani inte' nna, entonces contra lá inte' duą. Ą'hua nu labí rutùppą lani inte' nna runittilo lą́. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Canchu chi reria ttu espíritu malo lo losto' ttu enne' nna, làniana ribèni lo be' bą́ ca lugar bitsi hueyìla gaỹa edi' latsi'į, pero labí ritaxácca'ą, acca canią: Eyèqquia ca'á' litsá'a' làti gudáyá ya'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Canchu chi etsìna'ą nna ilá'nią qui'ni enni'a nna ną́ tì'a ttu yú'u nu nettia bą́ nna chi lúba ràba le' yú'a nna yala tsè'ni chi ną́ arreglado. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Làniana tsíą táxi'ą ágàtsi ca espíritu adila mal tì'chu lą nna gá'a tè iyaba cą lo losto' enni'a nna xúa cą nía. Làniana adí teérulá peor ccá la' tté qui' enni'a tì'chula antes. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Loti' ra Jesús ca tìtsa'a nna, idìtsa tsè' gunne ttu niula làhui' ca enne' ỹétse'á nna rą: Ica'rubà niula beditsìna' bi cuią'lu' nna begátsi' bi cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús nna ra tìe: Adítelá ica'rubà canu riyénini titsa' qui' Tata Dios nna runi cą nu rèe. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Hua diala ritùppa ca enne' ỹétse'ní làti du Jesús, làniana gudulo tìe gunnie nna rèe: Ca enne' tsè'e annana yala mal ná la' rulába latsi' qui' quį, acca rinàba cą qui'ni gunia' ttu milagro, pero labí biỹa cosa milagroso ní ilá'ni cą, sino làteruba nu chi uccua lani Jonás tiempo antigua. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Porqui'ni tì'a Jonás uccua bi ttu señal para ca enne' Nínive, ą'hua Nubeyu' de Ỹiabara' nna quée ttu señal para ca enne' tsè'e tiempo anna. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ą'hua niula nu gulú'ubi'ą itute pais sur tiempo antigua nna eyátha huą́ lani ca enne' tsè'e tiempo anna canchu chi gal·la' tsá juíciuá nna gútsią falta qui' quį para thí' cą castigo; porqui'ni idittu' tsè'ni huíą para iyéninią la' riyeni tsè' qui' rey Salomón. Atsi'íni entre lebi'į nna du ttu enne' adila sabio tì'chula Salomón, pero labí caso runi le quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Canchu chi gal·la' tsá juíciuá nna, eyátha huá ca enne' qui' ciudad Níniveá para gútsia cą falta qui' ca enne' tsè'e tiempo anna para qui'ni ccá cą condenar. Porqui'ni ca enne' qui' ciudad Níniveá nna betsìá bání la'labàni qui' quį de biyénini cą titsa' qui' Tata Dios nu gutixà'a Jonás. Pero entre lebi'į nna du ttu enne' adila dacca' tì'chula Jonás. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Lanú nuỹa rugàl·la' ttu yi' para gúduą na làti gàttsi', nìhua ỹareé' ttu cajón, sino qui'ni rudua lą́ na ttu lugar lati gudàni'ą qui' iyábani ca enne' gá'a le' yú'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Iyyalo ri'u nna ną́ tì'a ttu lámpara para ri'u. Acca canchu íyyalo lu' ná tsè'bą́, entonces labiru biỹa la'yani' reyàtsani lu'. Pero canchu íyyalo lu' labí yùą biỹa nua' la'yani', entonces tál·lią́ qui'ni reqquia bá lu' le' chul·la. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Acca bè' cuidado la'yani' nu dua lo losto' lu' qui'ni làa tálią́ lu la' chul·la. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Acca canchu labí biỹa la'yani' reyàtsani lu' nna nìhua nìdi tí' chul·la bíttuúru té qui' lu' nna, entonces itute ccą́ la'yani' tì'a ttu lámpara tsè' canchu chi rudàni'ą qui' lu' lani itute la'yani' quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","De beyacca gunne Jesús ca tìtsa'a nna, ttu enne' fariséua nna benią ne invitar gúe lani ą. Gutè'e le' yú'u qui' nuá nna gure'níe lo meỹa. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bilá'ni fariséua qui'ni labí gutìi né'e ántesca gúe tì'a costumbre qui' caniá para ccá cą purificar nna, acca yala uccuaỹí latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Señor nna ra tìe na: Lebi'į ca fariseo nna reyìi le tsua' teruba fuera la qui' ttu taza nna plato nna, pero liú'u lá nna ná rùą cùttsi, tì'a ná losto' le porqui'ni tsá'tí'níą la' ubàna nna la' huèni maldad nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yala necio ná le. Tsí bihua yù le qui'ni Tata Dios enne' beni nu rilá'ní lo ra' nna, beni huée lado liú'u lá cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Líúte losto' le lani Tata Dios, làniana itúbani le eyacca nàrì hàstaá la' rulábalatsi' qui' le nna ą'hua ca hecho qui' le nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ica'rútsi'íru lebi'į ca enne' fariseo, porqui'ni ribèqquia le qui' diezmo hàstaá ca semilla lathi to' tì'a ná menta nna ruda nna iyaba clase de legumbre nna; pero ca cosa nu ná adírulá importante tì'a ná lu'uxtícia tsè' nn la' tsì'ilatsi' nna labí runi le cą. Ca nua' lá náduel·la' guni le, pero nìhua làa guxùl·la latsi' le gúte le qui' diezmo. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Icarútsi'íru lebi'į ca enne' fariseo, porqui'ni nu catíppá bá runi le para gal·la' le ca asiento nu dàa íqquiará' tè le' ca sinagoga, ą'hua yala ribèni le làti cca i'yya para qui'ni iỹetse' ca enne' nna gappa cą le titsa'. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ica'rútsi'íru lebi'į ca maestro de la ley religioso nna ca fariseo nna, porqui'ni ná le tì'a ca bà nu labiru rulue'ní lo quį; rida' tè ca enne' lo quį sin qui'ni làa ritebé'ni cą; ą́' tení ná le porqui'ni yala enne' tsè' rulue' le, pero álahuá hua líni le. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Làniana gunne ttu maestro de la ley qui' caniá nna rą Jesús: Maestro, hàstaá intu' nna yala chi riyenidí'ni tu' por ca titsa' qui' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús nna rèe na: Ą'hua ica'rútsi'íru lebi'į ca maestro de la ley, porqui'ni ca costumbre nu rutsia le iqquia ca enne' nna ną́ tì'a ttu yùà' idì'iní nu lanu nuỹa ridàą huá'níą na, pero lebi'į nna nìdi tito' làa calatsi' le cúa li ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Airu lebi'į, porqui'ni rilìtha le ca monumento xeni lo bà qui' ca profeta ca enne' betti ca ta' tàta qui' lía. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Anía modo nna ritelíní qui'ni tsè'e hua le de acuerdo lani nu beni ca ta' tàta qui' lía, tulappa tsí'ní ná lé lani cą. Pues làcą nna hualigani betti cą ca profétaá, pero lébi'i nna rilìtha tè le monumento lo bà qui' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Por nua' nna la' riyeni tsè' qui' Tata Dios nna rèe: Ithél·la'a' ca profeta nna ca apóstol nna lani cą. Ttu te cabi nna gùttì lá cą cabi, áttu te cabi nna gútsia latsi' quį cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pues, lani ca enne' tsè'e tiempo annana enàba ỹíiyá' Tata Dios réni qui' iyaba ca profeta ca enne' bétti cą dèsdeba loti' uccua yétsiloyu, ");
INSERT INTO zaaNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","dèsdeba réni qui' Abel hàstaá réni qui' Zacarías enne' bétti le le' lí'a qui' templua èxabá làti du altar. Attu vuelta nia' le qui'ni lani ca enne' tsè'e tiempo annana enàba ỹíiyá' Tata Dios réni qui' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Airu lebi'į canu rethàtsilà'na nu ra lo ley nna té làtsi' ná' le llave nu ithàlia puerta de la' ritelíniá, pero la'a lebi'i ba nna labí rá'a le, nìhua làa rue'él·la' le canu uccua latsi' gá'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Beyacca ba gunne Jesús ca enseñánzaá lani cą nna, entonces ca maestro nu rulue' ley religioso qui' caniá ą'hua ca fariséua nna yala bitsa'áni cą ne nna gudulo cą bequìtsí'ni cą ne nna nuỹé tsè'ni gunàba titsa' cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Bedà tsìttsì tení naga' quį ti'iỹa ecàbie nna gulèda cą canchu xiaba uquìnnia cą ne lani ttu titsa' para gappa cą néda biỹa caúsaní gútsia cą còntre. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bitola nna bitùppa tè iỹé mili' ní ca enne' hàstaá qui'ni rùl·lianí ló nì'a luetsi quį de tántuani iỹé cą. Làniana gudulo Jesús gutixa'ánie ca discípulo qui'áa adí ca enseñanza nna rèe: Guyu le qui'ni làa thí' yeé'ni ca fariséuą' le, porqui'ni yala enne' tsè' rulue' cą pero álahuá hualíni cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pero labí ttu cosa nu gàttsi' té sin qui'ni làa ilá'níą, nihua biỹa ttu secreto ní té sin qui'ni làa guna ri'u ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Acca iyaba ca cosa nu chi gunne le le' chul·la nna, pues ccą́ declarar le' la'yani'. Ą'hua nu chi gunne lànà le le' yú'u nna, ccą́ declarar dacca'ló taá. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Lebi'į amigos quia': Bittu gátsini le canu calatsi' quį gutti cą le, porqui'ni cuerpo teruba ccani cą gutti cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Inte' nna innia' nuỹa dàni le gátsini le: Lígátsi láni enne' huaccanie cúeé la'labàni qui' le, bitola nna té la'huacca quì'e gudàl·lee le lo yi'bél·laá. Acca nia' le qui'ni là enni'a nna ná qui'ni gátsini le. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tsí álahua ritò'o gayu' ca bìnni to' por chuppa moneda to' rúbá làti cca i'yya cá. Pero labí riỹùl·lani Tata Dios nuỹa la ttu cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pues, hàstaá ittsa' iqquia le nna báabànie iyáỹiani cą. Acca bittu gátsini le, porqui'ni lebi'į nna adítelá dacca' le tì'chula iỹetse' ca bìnni to'. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Inte' nna nia' le qui'ni nuỹa tediba gudàlianią inte' ru'a lo ca enne' nna, entonces ą'hua inte' Nubeyu' de Ỹiabara' nna inne huá' nu cca qui' le ru'a lo ca ángel qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero nu labí thí'chí'ą qui'ni ną́ enne' quia' ru'a lo ca enne' nna, entonces ą'hua inte' nna labí guni ya' ą presentar ru'a lo ca ángel qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nuỹa tediba inne contra inte' Nubeyu' de Ỹiabara' nna huatta' bá perdón quì'į. Pero nu inne titsa' mal contra Espíritu Santo nna labí perdón gata' quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Canchu chi iche' cą le le' ca sinagoga nna gute cą le cuenta làtsi' ná' canu rigú'ubia' nna ca uxtícia nna, pues bittu nùyue cani le ti'iỹa o biỹa ecàbi le o biỹa gá le cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Porqui'ni la'a mísmutaá hóraá nna guni Espíritu Santo latsi' le nu dàni le inne le. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Làniana biria ttuą entre ca enne' ỹétsi'á nna rą ne: Maestro, gùtsì bál·la bèttsi' yà'ą' qui'ni íl·la'áníą interés qui' ta' tàta qui' tù'a nna gunną tsal·lue' quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús nna rèe na: Lu' nubeyu', núní chi beduą inte' para ccá' juez qui' le, or para íl·la'áníá' biỹa té qui' le ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ra tìe iyaba cą: Lihue' cuidado de iyaba clase de la' dàlatsi', porqui'ni masqui'ba iỹeni ní ca cosa chi guta' qui' ca enne', pero bel·liu qui' quį nna bihua runną la'labàni qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Gutixa'a huánie cą attu comparación nna rèe: Loyu qui' ttu nubeyu' rico nna yala lènà' chi bedi'ą lì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Lą nna gure' tìą yala belaba latsi'į nna uccuanią. Biagani gunia', qui'ni lagáru ná cu'á' adí ca lènà' quíyi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Làniana uccuanią: Chi yúá' biỹa gunia': adila tsa' gutáppa'a' ca cúrrali quíya'a nna gunia' canu adiru xeni, nía nna cu'ú tìa' iyaba ca lènà' quia', ą'hua adí bíỹaáru té quia' nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","làniana edilátsa'a' nna épa'a' la'a mísmuba inte': Yala iỹeni lènà' chi túani lu' para iỹetse' ni ida, acca bedi' bá latsi' lu' nna gù'ya gutò bá nna bedacca' báni nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Tata Dios nna rèe na: Enne' necio ná lu', porqui'ni nèlà nna gatti lu'; iyaba nu chi túani lu' para la'a lu' ba nna, núlá quí' ccą́ cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ra huá Jesús: Ą' tení ná nu rudàni riqueza quì'į, pero lani Tata Dios nna yala pobre ną́. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Bitola nna ra tè Jesús ca discípulo qui'áa: Acca nia' le qui'ni bittu nùyue ga tsé'e le por ti'iỹa ccá le nu go le nna, nihua ti'iỹa ccá le nu gaccu' le nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pues, la'labàni qui' ri'u nna adila dàcca'ą tì'chula nu ri'ya ro ri'u; ą'hua cuerpo qui' ri'u, tì'chula nu raccu' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Liuyuúruhuá ca bèqquìà. Pues bihua rada cą nìhua labí rutùppa cą lènà', nihua làa rudua cą cúrrali làti cu'ú cą yeda qui' quį. Pero Tata Dios nna ruì'e cą ro cą. Tsí álahuá adírulá dacca' le tì'chula' làcą cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Núní le ccani itùnì á tsàtsìtà de tántua nùyue canią cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Acca, canchu bihua ccani le guni le ttu cosa xcuichu to' rúbá nna, biala cca cathùtini le nùyue por bíỹaáru adí ca cosa cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Liuyuúruhuá ca ìyyà nu anta' i'yatò' ti'iỹa riỹeni cą, pues labí biỹa tsina ní runi cą nihua labí rul·la cą tùu. Pero riquixa'ánia' le qui'ni nìhuani rey Salomón lani iyátení ca lári' fino nu guccu' bi nna, pero labí bilá' bi latsitè gani tì'a ca ìyyà tú'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yala tsè'ni rugàccu' Tata Dios ca ixi' to' átsi'ini anta' cą ttu tsá teruba le' yétsiloyu nna guxtíla taá dia chì cą lo yi' le' horno. Lebi'į nna, tsí álahuá adila dispuesto ga'na Tata Dios para gugàccu'e le cá. Pero labí ríalatsi' le qui'ni iỹeni la'huacca té quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Acca lebi'į nna, bittu nùyue ga tsé'e le por ti'iỹa ccá le nu í'ya go le, bittu gulaba xàttagá latsi' le qui'ni làa etù la'ỹeni qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Porqui'ni iyaba ca cosį dua iqquia canu labí fe qui' quį té. Pero lebi'į nna dua Tàta Dios qui' le enne' hua yù bée qui'ni riquína'ni le ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Acca adila tsa' líúdua iqquia le nu cca qui' reino qui' Tata Dios; làniana iyábani adí ca cosa nna, ni nada bá íl·lani cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Lebi'į ca carnero to' quia', ttu grupo xcuichu to' teruba ná le, pero bittu gátsini le, porqui'ni Tata Dios qui' lía nna chi rappée gusto gúnnée qui' le iyate nu rigú'ubi'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Acca, ligùttì' iyate nu té qui' le nna líúte qui' ca enne' ritè là'di'. Ą' modo nna gáta'ni le ca bolsa nu labí güé, quiere decir ttu tesoro qui' le le' ỹiabara' nu labí tté quì'į, làti lanú ubàna té nìhua làa runittilo bèl·là dìl·la' nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Porqui'ni làti té ca cosa nu dacca' qui' lía nna, nía huá du la' rulábalatsi' qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Lítsé'e listo, liugàl·la' léda taá ca lámpara qui' le, ");
INSERT INTO zaaNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","para qui'ni ccá le tì'a canu rue' cuidado ru'a puerta ribeda cą qui'ni él·lani xana' caniá huía bi thá'a. Para qui'ni cuantu taání él·lani bi ínne taá bi ru'a puértaá nna, luégutaá ithàliani cą bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ica'rubà ca siérvuá, porqui'ni canchu chi él·lani xana' caniá nna, taxácca' bi cą tsè'e cą al tanto. Hualigani te' nia' le qui'ni la'a làbabi nna gudu mandil ru'a lo bi nna gúxuani bi cą lo méỹaá nna gute bi nu go cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Màsqui'ba él·lani bi ttú ríluela yèlà o màsqui'ba él·lani bi ttú ritìį tsunna díla, pero yala ica'rubà ca siérvuá porqui'ni gulèda cą hàstaá qui'ni el·lani bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Lítelíni attu ejémpluį: ttu tàta nna cáalá yùą biỹa hora íl·lani ubana litsi'į nna, entonces labí gá'athią, anía modo nna labí hue'él·la'ą nuỹa cuaną biỹa té le' yu'u qui'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Acca, ą'hua lebi'į nna lítsé'e al tanto, porqui'ni méruání hora nu nìdi làa rulába latsi' le nna, de repente taá él·lani Nubeyu' de Ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Làniana Pedrua nna ra bi e: Señor, tsí gùnne cuią'lu' comparación nì para intu' teruba o tsí para iyaba ca enne' áccá. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Becàbi Señor nna rèe: Nuni nua' ná siervo fiel nu té la' riyenitsè' quì'į acca bethà'na tè xana' niá na le' yú'u qui' bía para huí'ą na cuidado nna gútią nu go qui' adí canu runi tsina hora ná qui'ni go cą cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ica'rubà siérvuá canchu chi étsina' xana' niá nna ilá'ni bi ą qui'ni runią voluntad qui' bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Hualigani te' nia' le qui'ni gute bi làtsi' ní'į iyate nu té qui' bi para cu'úbi'ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero canchu siérvuá gulaba latsi'į nna cánią: Alahuá anna tè él·lani xana' ya'a, làniana thulo chìą huí'ą ca mózuá nna ca criádaá nna, ą'hua í'ya gúą hàstaá qui'ni ttáanią. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Làniana nìyalatsi' siérvuá nna él·lani xana' niá tsá nu nìdi làa ribedą bi, hora nu labí yùą nna. Acca xana' niá nna idí'ni guni bi ą castigar, làniana gudàl·la tè bi ą lani adí canu labí runi tsè'. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Siervo nu hua yù bą́ biỹa nuá rú'ulatsi' xana' niá qui'ni gúnią, atsi'íni labí benią duel·la' gunią nu náni bi ą mandado, entonces lą nna thí'ą iỹetse' castigo. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero siervo nu labí nabia'ni nu rú'ulatsi' xàni'į nna benią nu dacca' ccáníą castigar nna, lą nna huaỹia' lá íyaá'ą. Acca nia' le qui'ni nuỹa tediba thí' iỹeni nna, entonces iỹeni huá enàbani cą na. Ą'hua nuỹa tediba gute cą làtsi' ní'į adí iỹeni nna, entonces adila iỹeni enàba ỹíya'ni cą na. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Inte' nna daya' para thulua' ttu tsina nu gál·lá'ą le' yétsiloyu tì'a ttu yi' nna gunią vencer iyaba ca cosa mal. Demasiado rú'ulátsa'a' qui'ni gál·lá'ą prontu taá. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Náduel·la' ttía' por ttu sufrimiento nna yala sufrir canilátsa'a' hàstaá qui'ni i'yu tsá ccą́ cumplir. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tsí rulaba latsi' le qui'ni daya' para qui'ni bíttuúru ccá chuppa la' rulábalatsi' cá. Labí, sino íl·lá'a lánia' la' rulábalatsi' qui' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Porqui'ni dèsdeba nna làti tsè'e gayu' enne' le' ttu familia nna, la'ání luetsi quį; tsunna cą contra chuppa cą nna, chuppa cą contra tsunna cą nna; ");
INSERT INTO zaaNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ttu tàta nna contra ỹi'nį, ą'hua ỹi'ni contra tàta quì'į; ttu nàna contra ỹi'ni niulíį, ą'hua ỹi'ni niula contra nàna quì'į; suegra contra ỹolitsi'į, ą'hua ỹolitsi' contra suegra quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ra ruhuée ca enne' ỹétsi'á: Canchu chi rilá'ni le rel·lani bía lado renia bitsa nna, entonces rena taá le: Chi da' iyya. Anía ccá nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ą'hua canchu chi riria be' lado sur la nna, entonces rena le: Yala ubá ccá. Anía ccá nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hua ritelí báni le ca seña nu cca qui' ca tiempo ỹiaba nna yétsiloyu nna. Bialacca rena le qui'ni labí télini le ti'iỹa ná cosa importante nu cca le' yétsiloyu anna dacca'ló taá ni'i. Labí líni le. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Bianicca labí la' riyeni tsè' té qui' le para cueqquia latsi' le guni le nu ná tsè' ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Canchu ttu enne' dia bi hue' parte contra lu' ru'a lo uxtícia nna, entonces lu' nna ná qui'ni eyaccatsè' telá lu' bi miéntraste yù'u lu' néda lani bi para qui'ni làa gute bi lu' cuenta lani juez, porqui'ni enne' ná juez nna gute bi lu' cuenta lani ca policia para gudàl·la cą lu' làti ccá lu' castigar. ");
INSERT INTO zaaNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Inte' nna nia' lu' qui'ni labí eria lu' nía hàsta'na quiỹa lu' iyate nu ruthítsini cą lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","La'a tiempo làniataá nna tsè'e hua tuchùppa ca enne' nía ruè'nì cą Jesús titsa' ti'iỹa ná nu beni Pilátua, porqui'ni benią mandado gatti tuchùppa ca enne' Galilea mérubá tsè'e cą huèni sacrificar, hàstaá qui'ni réni qui' ca enni'a nna bichixią lani réni qui' ca animal nu betti cą para sacrifíciuá. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús nna rèe cą: Ca enne' gùttì por mandado nu beni Pilátua nna, tsí rulaba latsi' le qui'ni adiru enne' tul·la uccua cą tì'chu iyaba ca enne' látsi quį acca guỹàcca' cą anía cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Inte' nna nia' le qui'ni bihua uccua cą adiru enne' tul·la'. Pero lebi'į nna canchu bihua gúttsiání la' rulábalatsi' qui' le para eyaccatsè' le Tata Dios nna, entonces iyáỹiani le nna l·luỹa huá latsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ą'hua canu tsìỹúnu' gùttì le' ciudad Jerusalén loti' biyìnnia torre qui' Siloé iqquia caniá nna, tsí rulaba latsi' le qui'ni adiru enne' tul·la' uccua cą tì'chu iyaba ca enne' qui' Jerusalén acca guỹàcca' cą anía cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Inte' nna nia' le qui'ni álahuá là. Pero lebi'į nna canchu bihua eyàcca le arrepentir por ca tul·la' qui' le nna, entonces iyáỹia le nna nitti ba le. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús nna gutixa'a huée ejémpluį: Ttu nubeyu' nna du ttu yà exxuhuí quì'į le' loyu qui'niá. Huía tìą huìla exxuhuí lúį, pero ni ttú làa taxácca'ą lo yà exxuhuía. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Làniana ra tìą nu rue' cuidado lóyúa: Ttu ttu ida ní rìta' huìla exxuhuí lo yaguį, atsi'íni chi uccua tsunna ida nìdi ttu exxuhuí nì' cuía lúį. Acca adila tsa' guchu telá ą, porqui'ni cuenta du bą́ le' lóyúį. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Becàbi tè nu rue' cuidado lóyúa nna rą: Señor, be'él·la' bá cuią'lu' ą màsqui'di attu ida, miéntraste gúlá' tí'a' gùnà' ỹánį nna gúdál·la'a' bèbè, entonces ");
INSERT INTO zaaNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","canchu cuía fruta lúį nna, tsè'ba; pero canchu bihua nna, lànialá nna ichù bá cuią'lu' ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ttu tsá nu labí runi ca judíua tsina nna, du Jesús le' ttu sinagoga làti retùppa cą nna gutixa'ánie cą ca enseñanza nu cca qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Le' sinagógaá nna re' huá ttu niula, chi uccua tsìỹúnu' ida rà'nią. Ttu espíritu malo nna chi bechéetsù'níą niuláa, pues nìdi tí' làa cca elíą. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bilá' báni Jesús niuláa nna gutàỹie nna ra tìe na: Niula, chi ná lu' libre de itsahue' qui' lu'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Betsia tè né'e iqquia niuláa. Lą nna belí chìą nna guduluą bedàlianią Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero nubeyu' principal le' sinagógaá nna yala bitsa'ánią porqui'ni beyuni Jesús ttu enne' tsá ná qui'ni edi' latsi' quį, acca gunnią lo iyaba ca enni'a nna rą: Xuppa ubitsa té para guni ri'u biỹa tsina qui' ri'u, acca le' xuppa ubitsa ìta le eyàccalatsi' le, pero alàa tsá ỹeni qui' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Gunne tè Señor nna rèe nubeyu' principal: Quelebíhuá rena lu' ridu lu' conqui' adila lebi'į nna rethàtsi la le ca gù'na bia' qui' le nna riche' le cą í'ya cą inda, màsqui'ba labí ná tsá tsina. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Atsi'íni niulíį nna ná lą́ descendiente qui' Abraham, chi uccua tsìỹúnu' ida ỹíga'ni Satanás na, tsí bihua ná qui'ni ethàtsi ri'u ą de itsahue' qui' nią' màsqui'ba làa ná tsá tsina ca. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Gunne diba Jesús ca tìtsa'a nna yala bettu'ni canu labí cca guyu cą néa. Pero itúbani yétsiá nna yala bedàcca'ni cą bilá'ni cą ca cosa milagroso nu beni Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Làniana rèe: Biani tì' ná reino qui' Tata Dios cá. Ą'hua biani lani guni ya' ą comparar cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ną́ tì'a ttu bétsi' to' qui' planta mostaza nu guỹi' ttu enne' nna gudą na le' ỹúlali quì'į. Bétsi' tú'a nna gul·lani díbą́ nna biỹenią nna uccuą tì'a ttu yà ỹénitsè' hàstaá qui'ni ca bìnni to' tsè'e lo be' nna radi cą rutsia xcu'ni quį lúį. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Raáruhuá Jesús: Biani lani gunia' comparar reino qui' Tata Dios cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ną́ tì'a ná levadura nu guỹi' ttu niula nna gulù'ą na le' tsunna yà almudo yedia, hàstaá qui'ni beyaỹilo ituba cúa. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","De yù'u Jesús néda para ciudad Jerusalén nna, gutè tìe ca yetsi nna ca rancho nna, gutixa'ánie ca enne' iỹetse' ca enseñanza nu cca qui' ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Gunne tè ttu enne' dia nía nna rą ne: Señor, tsí tuchùppa rúbá ca enne' l·láà cá. Becàbie nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Lígúni duel·la' gá'a le ru'a puerta xcuichu to' miéntraste té tiempo, porqui'ni nuỹetse' cálatsi' gá'a bitola, pero labí irialàni cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Porqui'ni enne' xana' yú'a nna bitola de chi guduli bi bethàya bi puértaá, pues lebi'į canu tsè'e le fuera nna gúl·labi le ru'a puértaá nna ina le: Señor, Señor, guthàliani cuią'lu' intu'. Ecàbi tè bi nna ina bi: Labí yúá' nuỹa enne' ní ná lé. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Làniana ina le: Júntubá guỹua tu' lo meỹa gù'ya gutó bá tu' lani cuią'lu', ą'hua lo ca néda qui' tu' nna biyénini tu' enseñanza nu rulue' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero enne' ná xana' yú'a nna gá lá bi le: Chi nia' qui'ni labí yúá' nuỹa enne' ní ná lé; liucuìtta nì iyaba lebi'į canu runi mal. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nía nna cca le sufrir, íditsùni le cuetsi le nna goyà'atsùni laya' le nna, porqui'ni ilá'ni le Abraham nna Isaac nna Jacob nna ą'hua iyábani ca profeta qui'ni tsè'e iyaba cabi le' reino qui' Tata Dios, pero lebi'į nna fuérabá tsé'e le. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tsé'e canu íl·lani lado ril·lani bitsa nna lado renia bitsa nna ą'hua lado norte nna sur nna xúaní cą lo meỹa lani la' redacca' latsi' le' reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tsá lània nna ttu te canu ná cą bitó tè annana pues ccá cą nu neru; ą'hua ttu te canu ná cą neru annana pues eyacca cą nu bitó tè la. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","La'a mísmuba tsá lània loti' gutixa'a Jesús ca tìtsa'a nna, bitsina' tuchùppa ca fariséua nna ra cą ne: Beria nì nna beyya, porqui'ni Herodes nna calatsi'į gúttíą lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús nna ra tìe cą: Lítsía nna lígatsi enne' mañósuą' qui'ni inte' nna rudál·la'a' fuera ca espíritu malo ą'hua reyùnia' canu ra'ni, annana guxtíla nna, pero huìtsa taá nna irialània' tsina quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Té díhuá qui'ni gunia' seguir tsina quia' áchúppa tsuna ubitsį, làniana etsina'a' Jerusalén, porqui'ni labí gutti ca enne' ttu profeta le' attu yetsi huaya' sino le' ciudad Jerusalén teruba. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Lebi'į canu tsè'e le' ciudad Jerusalén rúttí le ca profeta nna rudua huá le íyya iqquia iyaba ca mensajero nu rithel·la' Tata Dios lani le. Iỹé vuelta tsè' uccua látsa'a' gutùppa' le tì'a ttu yìti rutùppą ca ỹi'ni to' quì'į liú'u xìlį, pero labí uccua latsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Templo qui' líą' nna chi dua tàttsi bą́, labiru la'huacca qui' Tata Dios té lani le, ą'hua nia' le qui'ni labiru ilá'ni le inte' hàsta'na qui'ni i'yu tsá inne le tsè' nu cca quia' nna ína le: La' dàliani para cuią'lu' porqui'ni da' cuią'lu' por nombre qui' Señor Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ttu tsá redi' latsi' ca enne' Israel nna, huía Jesús litsi' ttu nu ná principal qui' ca fariséua para gúe lani ą. Adí ca fariseo tsè'e cą nía nna betsia tsìttsì bání lo quį ne. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Du tè ttu nubeyu' ru'a lo Jesús; fuértení rà'nią, itú ỹíábą́ té yii. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Làniana gunne teni Jesús ca fariséua ą'hua ca maestro de la ley qui' caniá nna rèe cą: Tsí hua ná qui'ni eyuni ri'u ttu nu ra'ni tsá ná qui'ni edi' latsi' ri'u cá, o, tsí ra Tata Dios qui'ni ną́ tul·la' áccá. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero làcą nna labí becàbi cą. Jesús nna bedàxu' tìe ná' nubeyu' rà'nia nna, beyacca taá latsi'į. Làniana bethèl·le'e na litsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ra tè Jesús ca fariséua: Canchu nuỹa ttu le du ttu burro o ttu gù'na qui' le nna innia tè nuỹa ttu cą le' ttu yèrù nna, tsí bihua igàa le para ebèqquia li ą le' yèrùa màsqui'ba ná tsá ỹeni cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Làcą nna labí betseláni cą biỹa ecàbini cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ttu vuelta nna, bilá'ni Jesús qui'ni canu nàỹì yú'u thá'a nna yala nu catippa ba runi cą para gal·la' cą ca asiento dàa íqquiará' tè lo méỹaá. Acca gutixa'ánie cą ttu enseñanza nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Canchu chi nuỹa gùỹią lu' yú'u thá'a nna, bittu cue' tení lu' íqquiará' tè lo meỹa, porqui'ni xiaba íl·lani huá attu enne' nu adila re' cuenta tì'chu lu', ");
INSERT INTO zaaNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","làniana íl·lani huá nu naỹinią lía, nna gą́ lu': Guduli canna para qui'ni cue'ni enni'į. Ą' gą́ lu', làniana ttú la' rettu'lo bá nna tsía lu' táché' lu' lo xila' nu du bitó ỹiatiá. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Acca, canchu chi nuỹa gáỹią lu' nna, huía bá nna gure' tení lo xila' nu du bitó ỹiánía, para qui'ni íl·lani bá nu gutàỹią lu'a nna gą́ lu': Amigo, gutè iqquia meỹa lá. Làniana yala tháliani lu' ru'a lo canu ỹua lani lu' lo meỹa. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Porqui'ni nuỹa tediba rudàlianią la'a labą́ nna, entonces exél·la' lą́; pero nu rulaba latsi'į qui'ni labí nuỹa ną́ nna, ccá lą́ enne' ỹeni. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Raáruhuá Jesús nubeyu' nu gutàỹią néa: Canchu chi gute lu' go ca enne' nna, bittu gaỹi lu' canu cca tsè' lu', nìhua ca bettsi' lu', nìhua ca pariente qui' lu', nìhua ca vecino qui' lu' nu ná enne' rico, porqui'ni iyaba canua' nna guni huá cą lu' invitar go lu' lani cą; anía modo nna labí premio thí' lu' de ỹiabara', porqui'ni chìhua beyunna cą qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero canchu chi guni lu' ttu banquete nna gutàỹi lá ca enne' ritè là'di', ą'hua canu ná manco l·le, ca enne' cojo l·le, ca enne' ciego l·le. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Làniana yala la' redacca' latsi' gata' qui' lu', porqui'ni làcą nna labí té qui' quį para eyíỹáni cą qui' lu'. Pero huadi' bá lu' nu gute Tata Dios qui' lu' canchu chi i'yu tsá eyátha iyaba ca enne' beni cą tsè'. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Biyeni báni ttu nu re' lani e lo méỹaá nna rą ne: Ica'rubà nu cue' go lo meỹa le' reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Becàbi Jesús por medio de ttu ejemplo nna rèe: Ttu ènne'yu' beni bi ttu banquete xeni tsè' nna gutàỹi tè bi ca enne' ỹétse'ní. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","De gùl·la' hora go cabi nna, guthel·la' bi mandado litsi' canu chi naỹini bía nna ra tè cą: Litàxia le qui'ni iyaba chi tsìa léda lo méỹaá. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero iyaba canu chi naỹini bía nna bílá bílá bá pretexto bedu cą. Ttuą nna rą: Chì' huí'ibá' ttu loyu nna, caduél·la'ní tsa'á' tanel·le' ya' ą, acca rinábania' lu' qui'ni thí' lu' la' ỹénlatsi'. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Attuą nna rą: Chì' huí'ibá' gayu' néda gù'na nna dí'a' guni ya' cą prueba, acca rinábania' lu' qui'ni thí' lu' la' ỹénlatsi'. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Attuą nna rą: Chì' bèttsáabá nàya', acca labí cca quia' tháyá'. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","De betsina' nu huía mandáduá nna gutixa'ánią xana' niá nu ra canaá, yala bitsa'áni xana' niá nna ra tè bi mozo qui' bía: Huía xìàtsate' làti cca i'yya nna ą'hua lo ca néda nna taxi' ca enne' ritè là'di' ą'hua canu ná manco l·le, canu ná cojo l·le, ca ciego l·le. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mózuá nna beyéqquią ru'a lo xana' niá nna rą bi: Señor, chi benia' nu ra cuíą'lu'a, pero hua náru lugar le' yú'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Làniana xana' niá nna ra bi ą: Huía lo ca nédayù nna ca néda lathi to', guche' duel·la' taá cą ìta cą para qui'ni itsà' le yú'u quíyi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Porqui'ni nia' le qui'ni nì ttu canu gutáỹia' néruá nna labí go cą là'go quíyi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nu ỹétse'gání ca enne' nna dia tè cą lani Jesús. Lèe nna gunne'e cą nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Canchu nuỹa enne' calatsi'į thá'ą lani inte' nna dànią catsi'ínią inte' adí tì'chu catsi'ínią tàta nàna quì'į nna ca ỹi'nį nna ca bettsi'į nna ca danį nna, hàstaá la'a mísmuba lą nna dànią guyudí'ą nna catsi'ínią inte', porqui'ni canchu labí nna entonces labí ccánią ccą́ discípulo quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nuỹa enne' labí ga'ną dispuesto gúchią propio gani curutsi qui'į nna tanuą inte', entonces labí dàcca'ą para ccą́ discípulo quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Por ejemplo, canchu nuỹa ttu le calatsi' gúduą ttu yú'u nna, tsí álahuá priméruỹa cuí'ą nna guthácca'bia' latsi'į tsáliáỹa bel·liu gudàl·lą qui' yú'a cá para ccą́ saber canchu hua té suficiente nu riquina'nią para gulùỹą tsè'taá yú'u qui' niá. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nìcà'chu ichìda díbą́ cimiento nna bíruhuá té quì'į gulùỹaníą yú'u qui' niá, làniana iyaba canu ilá'ni cą na nna yala gúỹitsíni cą na, ");
INSERT INTO zaaNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ina cą: Nubéyu'ą' nna gùduluą ruduą yú'u nna, pero labí suficiente lo sìnį té para gulùỹą na. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ą'hua ttu enne' rigú'ubia' nna, canchu caduel·la' gunią guerra contra ttu contrario qui'į, tsí álahuá priméruỹa cuí'ą nna guthácca'bia' latsi'į ti'iỹa modo lani tsìi mili' ca soldado quì'į nna huadàą lani gàl·lia mili' ca soldado qui' contrario qui' niá cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Canchu ruthácca'bia' latsi'į qui'ni labí thą́, entonces miéntraste huaduúru contrario qui' niá idittu' nna ithel·la'ą noticia gata'yúnią na qui'ni adila tsa' eyaccatsè' bá cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Acca lebi'į canchu bihua ga'na le dispuesto gutha'na le iyate nu té qui' le nna, entonces labí posible té para ccá le discípulo quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yala riỹu' dète', pero canchu dèti'a gunìttią la' iỹé' quì'į nna, biala lani eyàccanią iỹé' cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pues labiru biỹa íỹu'ą, nìdi para tsíą le' ttu loyu para gunią bèbè, sino para irú'na terúbą́ fuera. Nu calatsi' telinią enseñánzį nna naduel·la' qui'ni gudà tsè' nàgui'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Làniana iyaba canu ruquíỹa qui' impuesto nu redi' gobierno, ą'hua adí canu rena ca enne' judíua qui'ni yala enne' tul·la' ná cą nna gubíga' tè cą ru'a lo Jesús para gudà naga' quį quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Acca ca enne' judío canu gùlàni religión fariseo ą'hua ca maestro de la ley nna beyu tè cą la' dítsi qui' Jesús nna ra cą: Nui nna yala cca tsè'ą canu huèni tul·la' nna ruą lani cą nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesús nna gutixa'ánie cą ttu enseñanza por medio de ttu comparación nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Núní ttu enne' ní entre lebi'į nu tsè'e gayua' carnero quì'į, canchu iyàl·la nuỹa lá ttu cą nna, tsí bihua guthà'ną canu noventa y nuéveá làti ná ìxxì' go cą miéntraste tsíą tatìlą́ nu biyál·láa hàstaá qui'ni etselánią na cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","De chi betselánią na nna enìta' tìą na por tanto la' redacca' latsi' nu té quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Etsina' bą́ le' yú'u nna gaỹią ca vecino qui'į ą'hua adí ca amigo quì'į nna ra tìą cą: Ledácca' huá latsi' le tì'a inte', porqui'ni chi betsela te' carneru to' quia' nu biyál·láa. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Raáruhuá Jesús: Inte' nna nia' le qui'ni adila la' redacca' latsi' té le' ỹiaba ra' por ttu enne' tul·la' reyacca arrepentir, tì'chula por noventa y nueve ca enne' de respeto canu labí caduel·la' eyàcca cą arrepentir. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Raáruhuá Jesús: Ttu niula nu té tsìi moneda quì'į, canchu iyàl·la ttuą nna, tsí bihua gugàl·la'ą yi' nna thulo tìą tetsùbà eyìlą na hàstaá qui'ni etselánią na, màsqui'ba caduel·la' gulùbą itute le' yú'u qui' niá cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","De chi betselánią moneda nna, làniana rą ca vecina qui' niá ą'hua adí ca amiga qui' niá: Ledácca' huá latsi' le tì'ba inte', porqui'ni chi betselá te' bel·liu quia' nu biyál·láa. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Làniana ra Jesús: Inte' nna nia' le qui'ni ą'hua ca ángel qui' Tata Dios té huá la' redacca' latsi' qui' cabi canchu chi ttu enne' tul·la' nna reyaccą arrepentir. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Raáruhuá Jesús adí: Ttu ènne'yu' nna gutsé'e chuppa ỹi'ni bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nu cca nu cuìti'a nna rą tàta qui' niá: Tàa, gùl·la'ání cuią'lu' iyate nu té qui' ri'u para gunna cuią'lu' quia' nu ral·lá'a' thí'á'. Làniana gùl·la'á tèni bi herencia qui' bía, bè' bi cą qui' tsàba quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Dia tí'bá tsá nna, entonces nu cca nu cuìti'a nna betùppą iyábani herencia quì'į nna guda' tìą díą idittu' hàstaá attu nación huaya'. Nía nna benittiluą iyate nu té qui' niá nna gurèni perdido bą́. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","De chi gutittia el·la'níą itute nu té qui' niá nna, uccua ttu ubina' fuerte ní le' distrito làti rèni naá, làniana gudulo beyàtsa quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Huía tìą ru'a lo ttu nu dua nía huìla tsina. Nùa nna guthel·la'ą na rancho qui' niá para gappą ca cùttsi qui' niá. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","De tántua ritùnią nna ridàa tí'ní latsi'į cayélianíą hàstaba nu ro ca cùttsia, pero lanú nuỹa rute gúą. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Làniana bettsiání la' rulábalatsi' quì'į nna uccuanią: Bal·la gání mozo tsè'e le' litsi' tàta quí'a té tsè'eni qui' quį ro cą, atsi'íni inte' nna chi rattia' bìnà' rénia' nì. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Annana edúlia' nna éya'a' ru'a lo tàta quí'a épa' ye' e: Tàa, chi benia' tul·la' contra Tata Dios ą'hua contra cuią'lu' nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","labiru merecer ccà'a' para eyácca'a' ỹi'ni cuią'lu', acca beni ba cuią'lu' inte' tì'a ttu mozo qui' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Làniana lą nna beduli tìą nna deyyą litsi' tàta qui' niá. Idíttu'úruá deyyą nna bilá' chìnì tàta qui' niá na yàlàni betúa latsi' bi ą acca bigaá chì bi nna gunìta' bi yánį nna bettsa'ló bi ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Lą nna ra tìą bi: Tàa, chi benia' tul·la' contra Tata Dios ą'hua contra cuią'lu' nna, labiru merecer ccà'a' para eyácca'a' ỹi'ni cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero tàta qui' niá nna ra bi ca siervo qui' bía: Licuèqquia ca lári' nu adiru tsè' nna líúgaccu' ą. Lícú'u tè ttu anillo de oro ní'į nna ą'hua zapato nì'į nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Litàxì' tè gù'na nu adiru riỹenią para gútti li ą nna go ri'u ą nna guni ri'u fiesta, ");
INSERT INTO zaaNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","porqui'ni ỹì'ni yì'į nna chìa gùttìą pero beyaccabànią, chi gunittią nna pero chi betselą́. Làniana yala bedácca'ni cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Pero ỹi'ni neru bía nna reqquia bą́ lo tsina le' campo. De betsina'ą exa gáabá litsi' niá nna biyéninią cca huìl·la nna hueyà'a danza nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","gutàỹi tìą ttu siérvuá nna gunàba tìtsa'ą na biỹa nuá cca litsi' niá. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Siérvuá nna rą na: Chi bel·lani bettsi' lu'a, acca tàta qui' lu'ą' chi beni bi mandado gatti ttu gù'na nu adiru riỹeniá para qui'ni guni ri'u fiesta, porqui'ni bettsi' lu'a hua náruą bueno nna sano nna bel·lanią. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","De biyénini ỹi'ni néruá notícią' nna labí uccua latsi'į éya'ą le' yú'u. Acca biria chìa tàta qui' niá guta'yúni bi ą qui'ni éya'ą le' yú'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Becàbią nna rą tàta qui' niá: Hua yùba cuią'lu' qui'ni iỹé ida tsè' chi runia' cuią'lu' servir nna bihua cabezudo chi ùccua'a' lani cuią'lu', atsi'íni nìdi rúbani ttu chivo to' nì' gunna cuią'lu' quia' para go laníá' ca amigo quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero de bel·lani ỹi'ni lu'ą' nna, màsqui'ba chi benittiluą itute bel·liu qui' lu' lani ca niula pública, atsi'íni chi beni lu' mandado gatti gù'na nu adiru riỹeniá para guni lu' fiesta quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tàta qui' niá nna ra tè bi ą: Ỹì'nia', tulidàba dua lu' lani inte', ą'hua iyaba nu té quia' nna quì'ba lu' ná cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ti'ani modo làa guni ri'u celebrar ttu fiesta para edácca' latsi' ri'u ni'i. Porqui'ni bettsi' lu'į nna chìa gùttìą nna beyaccabànią, chìa gunittią nna pero chi betselą́. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Gutixà'a huá Jesús attu enseñanza lani ca discípulo qui'áa nna rèe: Gùdua ttu nubeyu' rico nna, gùdua huá ttu nu ná encargado qui' bi nna becà'na bi lani ą iyaba nu té qui' bi. Pero betsia cą queja qui' nu ná encargáduá qui'ni runittilo lą́ nu té qui' xana' niá. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Acca xana' niá nna beyàỹi tè bi ą nna ra bi ą: Biani nua' riyeni te' nu cca qui' lu', beyúnna cuenta tsina qui' lu' porqui'ni labiru ccá lu' nu rigú'ubia' lo iyate nu té quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Lànianá nu ná encargáduá nna belaba latsi'į íį: Annana biagáni gunia', porqui'ni xána' ya'a nna ebèqquia rúbá bi inte' lo tsina qui' bi, atsi'íni tsina ìdi'i nna labí cca te' gunia'; tsà'a' huenàba caridad nna yala ettu' te'; ");
INSERT INTO zaaNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","pero chi yúá' biỹa gunia' para qui'ni canchu chi bíttuúru tsina quia' te nna guni cą inte' recibir le' litsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Làniana gutàỹi tìą ttu ttu tsa canu ràl·la' cą ỹíyya' qui' xana' niá nna gunàba tìtsa'ą nu primérua: Tsáliacà'a ràl·la' lu' qui' xána' ya'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Becàbi nuá nna rą: Gayua' tambo aceite. Làniana nu ná encargáduá nna rą na: Bedi' recibo qui' lu'ą nna, gùre' xianí nna bedua átsìeyóna' terúbá lúį. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bitola nna gunàba tìtsa'ą áttuą nna rą: Lù'chu nna, tsáliacà'a ràl·la' lu' qui' bi. Lą nna, becàbią nna rą: Gayua' beduti ỹua'xtíla. Nu ná encargáduá nna rą na: Bedi' recibo qui' lu' nna bedua ochenta terúbá lúį. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Enne' ná xana' nu ná encargáduá nna gutelíni bi qui'ni yala listo uccuą porqui'ni belaba latsi'į tsè' màsqui'ba yala enne' mal ną́. Raáruhuá Jesús nna rèe: Canu yétsiloyuį nna, pues adila listo runi cą para cca tsè' cą lani iyábani ca enne' tì'chu canu té la'yani' lo losto' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Acca nia' le qui'ni lígúni duel·la' uquìna' le tsè' bel·liu qui' le, alàa ttu manera malo, sino tsè' taá para qui'ni canchu chi étu bel·liu qui' le nna entonces tsé'é ca amigo qui' le canu edi' cą le le' litsi' quį làti tsé'é le para siempre. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nuỹa tediba ná bá enne' cumplido lo nu ti'to' rúbá nna, entonces ccá huą́ enne' cumplido lo nu iỹeni tsè'. Ą'hua nu runittilo ti'to' rúbá nna, pues labí ną́ enne' de confianza para huí'ą cuidado iỹeni. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Canchu labí runi le nu dacca' iỹu' de nu cca qui' bel·liu nna, pues núlá gappą le confianza lani ca riqueza nu adiru dacca'. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ą'hua canchu labí rue' le cuidado tse' nu ná qui' attu enne' nna, entonces núlá gunna nu ná quì'į para ccą́ qui' tegání lé cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Lanú ttu mozo té ccani thuą bajo la' rigú'ubia' qui' chuppa ca patrón, porqui'ni miéntraste guyudí'ą ttuą nna catsi'í lánią áttuą, ą'hua miéntraste ną́ cumplido lani ttuą nna riníyú lą́ áttuą. Ą'hua lebi'į nna labí ccani ccá le huenitsìna qui' Tata Dios nna tse'e huá le bajo la' rigú'ubia' qui' Bel·liu nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","De ra Jesús ca tìtsa'a nna tsè'e huá ca fariséua nía nna biyeni dí'báni cą enseñánzaá nna búrlalá beni cą ne porqui'ni yala nu dàalatsi' bel·liu uccua cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús nna ra tìe cą: Lebi'i ná le canu ribèqquia nàrì la'a lebi'i ba ru'a lo ca enne', pero Tata Dios nna nabia' ranínié liú'u losto' le nna nìdi tito' làa cca guyue ca cosa qui' yetsiloyu nu yala catsi'íni ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Nu ra lo ley nu bethà'na Moisés lani ri'u ą'hua nu bedia ca enne' uccua profeta tiempo antigua nna, pues ą́' ná nu yù ca enne'. Pero dèsdeba gul·lani Juan el Bautista nna entonces gudulo cca predicar reino qui' Tata Dios. Iyáỹiani ca enne' nna yala duel·la' runi cą para gá'a cą le' reínuá. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Adila fácil ná qui'ni l·lúỹa latsi' ỹiaba nna yétsiloyu nna ca indatò' nna, tì'chula tté ttu letra to' nu ra lo ley qui'ni làa ccą́ cumplir. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Nuỹa tediba éla'ą́ niula quì'į nna guttsa tení'į lani attu niula nna, entonces chi ná adulterio nu runią; ą'hua nu édi'ą niula nu béla'á naá nna runi huą́ adulterar. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Gùdua ttu nubeyu' rico nna yala tsè' gudu ỹúį, ą'hua ttu ttu tsá ba benią banquete lani ca là'go tsè'ni. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Gùdua huá ttu enne' pobre rinàbą caridad láą Lázaro nna betuỹíáníą uccua huè', tíą ru'a puerta qui' nubeyu' rícuá. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yala gudà latsi'į gúą ca pedazo to' binnia ru'a meỹa qui' nubeyu' rícuá. Ca beccu' nna bitsina' cą gul·le'e cą lo ca huè' qui' niá. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Bì'yu bá tsá nna gùttì limosnéruá. Ca ángel nna beche' cabi ą hàstaá làti dua Abraham. Gùttì huá nubeyu' rícuá nna becàttsi' cą na. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Lo yi'bél·laá chi ỹuą ccą sufrir nna guchìtha lúį nna bilá'nią Abraham idittu' nna dua tè Lázaruá cuítta' bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Làniana gùnnią idìtsa nna rą Abraham: Gùppa cuią'lu' la' retúalatsi' quia' nna guthèl·la' bá cuią'lu' Lázaruą' qui'ni gulappa' lo ỹubení'į le' inda nna gudibìtha tí'ą luetsí'a', porqui'ni yàlàni dolor chi rappa' de yù'a' lo yí'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero Abraham nna ra bi ą: Lu' nna, hua yù lu' qui'ni buenu ba bedi' lu' le' yétsiloyúa; pero Lázaruį nna triste bá ná la' gutè quì'į. Pero annana yala la' redacca' latsi' chi té quì'į, pero lu' nna yala sufrir cca lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Además de nui nna ttu bèl·là'a chul·la túniní du entre intu' nna lebi'i nna. Acca nuỹa calatsi'į ttíą de nì para íl·lanią làti tsè'e líą' nna, labí irialànią; nìhua nu da' nà'la para íl·lanią nì nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Làniana gunne enne' rícuá attu vuelta nna rą: Entonces ratta'yúnia' cuią'lu' tàta Abraham qui'ni éthel·la' cuią'lu' Lázaruą' le' litsi' tàta quíya'a ");
INSERT INTO zaaNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","para inènią á gayu' ca bettsí'a' canu tsè'erù nía. Ą' modo nna làa èta huá cą lugar de sufrimiéntuį. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham nna ra tè bí ą: Té bá ca libro nu bedia Moisés nna ca profeta nna, níabá gudà naga' quį qui' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Becàbi nubeyu' rícuá nna rą: Labí tàta Abraham, sino canchu nuỹa chi gùttì nna eyáthą éyyą taquixá'anią cą, entonces eyacca cą arrepentir nna tsíalatsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero Abraham nna ra bi ą: Canchu bihua gudà naga' quį qui' Moisés nìhua qui' ca profeta nna, tampoco hua làa tsíalatsi' quį canchu nuỹa eyáthą de lo lù'uti nna quixá'anią cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús nna rèe ca discípulo qui'áa: Siémprení íl·lani ca tentación para guni qui'ni guni ca enne' tul·la', pero ica'rútsi'íru nu runi qui'ni rinnia ca enne' le' tul·la', pues ");
INSERT INTO zaaNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","adila tsa' iỹìqquia yánį ttu ìttsi nna gudàl·la tè cą na làhui' indatò', tì'ca'la gunią qui'ni nuỹa ttu canu xcuichu tú'į nna ìnnia cą le' tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Líhue' cuidado por la'a lebi'i bá. Canchu ttu hermano qui' lu' rigú'ą falta contra lu' nna, gutìtsà' ą. Canchu enàbą la' runittilo lani lu' por nu bénią nna, entonces ná qui'ni eyuniỹénbá latsi' lu' quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Canchu gàtsi vuelta ttu tsá gunią mal contra lu', ą'hua gàtsi vuelta enàbanią lu' la' runittilo nna, eyuniỹénbá latsi' lu' quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ca apóstol nna ra tè cabi Jesús: Señor, benna cuią'lu' adí fe qui' tu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ra tè Jesús cabi: Cáalá fe qui' le ną́ màsqui'di medida ttu bétsi' cuànà nna, huaccani le gá le yà xeni duį: Bilàtsù' nì nna biyàda lahui' indatò' la, entonces yàgą' nna huayéninią qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Raáruhuá Jesús: Núní ttu le dua ttu mozo quì'į rugà'ną gù'na o rappą ca gù'na bia' qui' le, canchu chi él·lanią de lo tsina nna, tsí gą́ mózuá: Gùduani lo meỹa cá. Labíỹá. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tsí álahuá gá lą́ mózuá: Bedappayáni ná' míỹa qui' lu' nna bèni nu go sía' nna guta'a tè quia' hàstaá qui'ni eyacca quia' í'ya gua'; lànialá nna gą́ mózuá: Guta'a qui' lu' nna gù'ya gutó. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tsí ína ri'u qui'ni huą mózuá: Quiỹaru lu' porqui'ni chi beni lu' iyaba tsina nu benia' lu' mandar. Ti' cca te' nna labí. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ą'hua lebi'į, canchu chi eyàcca qui' le guni le iyate nu ra Tata Dios qui'ni guni le, entonces ná qui'ni ina le: Ttu huenitsìna nu labí riỹu' tè ná tu', porqui'ni beni tu' tsua' terúbá nu ná qui'ni guni tu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Loti' deyya Jesús para ciudad Jerusalén nna bedàxu'e néda dia entre Samaria nna Galilea nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Gutà'a bée le' ttu yetsi to' nna biria tè tsìi ca nubeyu' tattsa' cą ne, pero idittu' ba gudàa cą porqui'ni cca cą yetsu' yùtsù'a leproso, yala hue'léte' ną́. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Làcą nna gunne cą idìtsa tsè' nna ra cą: Maestro, betúalatsi' cuią'lu' intu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Bilá' báni Jesús cą nna rèe cą: Lítsía nna lígúni presentar ru'a lo ca sacerdotea, seña de qui'ni chi beyacca nàrì le. Làcą nna de déyu'u cą néda tì'a rèe cą nna, beyacca chì latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Gutebé'báni ttu nuá qui'ni chi beyacca latsi'į nna, beyéqquia taą́ nna bedàlianią Tata Dios idìtsa ní, ");
INSERT INTO zaaNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","betsina' tìą ru'a lo Jesús, beduỹíbį nna bedètta' lúį loyu nna bè'ą ne gracia. Lą nna uccuą ttu enne' samaritano. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Gunne tè Jesús nna rèe: Tsí álahuá tsìi cą nuá beyacca latsi' cá. Adí canu gàá chúná, tì'ala uccua cą nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tsí nùhua nuỹa beyéqquią gudàlianią Tata Dios sino làteruba enni'į atsi'íni ná lą́ enne' idittu' nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Làniana rèe nubéyu'a: Bèduli nna beyya ba, pues por fe qui' lu' nna chi beyacca latsi' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ca fariséua nna gunàba titsa' cą Jesús cuaỹa íl·lani la' rigú'ubia' qui' Tata Dios yétsiloyu. Becàbi tìe nna rèe cą: La' rigú'ubia' qui' Tata Dios nna labí íl·lanią tì'a ttu cosa nu riria ca enne' inna' cą qui'ni chi dá'ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nìhua labí ccá saber ca enne' para ina cą con tiempo ba: Nì chi dùe o nà' taá dùe, porqui'ni reino qui' Tata Dios nna pues entre la'a lebi'į ba chi gul·lani ą'hua lo losto' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ra huée ca discípulo qui'áa: Huàl·lani tiempo canchu chi cálatsi' le ilá'ni le Nubeyu' de Ỹiabara' attu vuelta, màsqui'di por ttu bitsa terúbá, pero labí ilá'ni li e. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ą'hua gá cą le: Nì chi dùe, o, nà'la dùe. Pero bittu tsía le nìhua làa tanó le cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Porqui'ni tì'a rappi étha rudàni' rábanią dèsdeba làti ril·lani bitsa hàstaá làti renia bitsa, ą́' tehuá ccá canchu de repente taá chi íl·lani Nubeyu' de Ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero náduel·la' ỹa qui'ni yala padecer quée nna, ą'hua nuỹetse' guthacca' ca enne' tsè'e anna ne. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tì'a uccua loti' gùdua Noé, ą'hua ccá canchu chi i'yu tsá íl·lani Nubeyu' de Yiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Porqui'ni ą'hua ca enne' tiempo lània nna gù'ya go bá nna huettsaná' bá nna beni cą hàstaá qui'ni bì'yu tsá gutà'a Noéa le' bárcuá, làniana de repente taá gul·lani iyya juíciuá nna gùttì iyáỹiate ca enne' gùtse'e lània. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ą'hua ccá tì'a uccua loti' gùdua sobrino qui' Abraham láą Lot: gù'ya go bá nna huì'i bá nna huètti' bá nna huèni negocio bá nna béni ca enne', ą'hua gùda cą loyu bá nna huèdua yú'u bá nna beni cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero la'a mísmuba tsá biria Lot le' yetsi máluá lą́ Sodoma nna, làniana de repente taá nna binnia fuego lani azufre de ỹiaba nna bel·lùỹą latsi' iyáỹiani ca enni'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Anía tehuá runi ca enne' canchu chi i'yu tsá ilá'ni itute yétsiloyu ril·lani Nubeyu' de Ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Canchu chi i'yu tsáa nna, nuỹa tediba duą iqquia azotea qui' yú'u quì'į nna, eyàdią nna uccuìtta tabáą, bittu éya'ą le' yú'u para thí'ą biỹa té quì'į. Ą'hua nu rèni fuera lo tsina quì'į nna, bittu eyéqquią litsi'į táỹi'ą biỹa té quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Líúrexaáruhuá latsi' le nu uccua lani niula qui' Lot tiempo lània; lą nna bedeqquia lúį para inna'ą cuè'e lí n̨na beyacca taą́ ttu estatua dète'. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Acca riquixa'ánia' le qui'ni nuỹa tediba dua iqquį etúalatsi' la'labàni quì'į por nu cca qui' yétsiloyuį nna, entonces gunitti lą́ na. Pero nuỹa tediba gútse'e latsi'į la'labàni nu cca qui' yétsiloyuį nna, entonces ccabàni lą́. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ą'hua nia' le qui'ni Nubeyu' de Ỹiabara' nna canchu il·lanie de réla làti anta' chuppa ca enne' lo ttu cama, pues ttuą nna édi'e, áttuą nna eyà'na bą́. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ą'hua canchu chuppa ca niula yù'u cą huèttu, pues ttuą nna édi'e, áttuą nna eyà'na bą́. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ą'hua canchu chuppa ca nubeyu' tsè'e cą tsina, pues ttuą nna édi'e, áttuą nna eyà'na bą́. ");
INSERT INTO zaaNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","De beyacca gunne Jesús ca tìtsa'a nna, gunàba titsa' tè cabi e nna ra cabi: Gání, Señor. Jesús nna rèe cabi: Gaỹa tediba té ttu nu yatti nna, pues níahuá itùppa ca bechettu. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Gutixa'a huáni Jesús cabi attu comparación para guthète'nie cabi qui'ni caduel·la' guni cabi oración tulidàba nna bittu edùl·la'a latsi' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ree cabi: Le' ttu yetsi nna gùdua ttu juez nu labí gùppą respeto Tata Dios, nìhua ca enne' nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Gùdua huá ttu niula viuda le' yétsiá nna seguídoní huía ru'a lo juez nna rą na: Beni bál·la cuią'lu' lu'uxtícia quia' contra nu ná contrario quíya'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pero juez nna labí uccua tè latsi'į gunią lu'uxtícia quì'į. Pero bitola nna belaba latsi'į nna uccuanią: Màsqui'ba labí rappa huá' respeto Tata Dios nìhua ca enne' nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nada más porqui'ni niulíį nna yala ruquitsí'nią inte', acca guni chìa' lu'uxtícia quì'į para qui'ni làa ìta rùą huequitsí'ni látsa'a'. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Anía ra nu ná juez malua. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pero inte' nna nia' le: Canchu Tata Dios nna, tsí bihua dispuesto née para gunie defender ca enne' chi réeé'nie, canu rul·luítsa' cą ne la'réla ritsábá cá. Tsí yala itsá cuédée para gunie cą cualani cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nia' le qui'ni adila retúa latsi'e cą para gunie lu'uxtícia qui' quį próntuní. Pero canchu chi íl·lani Nubeyu' de Ỹiabara' nna, tsí hua tse'eỹa le' yétsiloyuį canu hua ligani té fe qui' quį lani e cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Gutixà'a huá Jesús attu comparación, para canu rulaba latsi' qui'ni yala tsè' ná cą, pero bihua cca guyu cą nuỹaáru adí ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Reé: Chuppa ca nubeyu' nna huía cą huèni oración le' templua. Ttu nuá nna uccuą ttu fariseo. Attu nuá nna uccuą ttu nu ruquiỹa qui' impuesto. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nu ná fariséua nna du báníą ru'a altar runią oración nna rą: Quiỹaru cuią'lu' Tata Dios qui'ni labí ná' tì'a ná adí ca enne', ubàna nna yélatsi' nna adúltero nna, nìdirubani tì' ná nu riquíỹa qui' impuesto dùą'; ");
INSERT INTO zaaNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","pues inte' nna runia' ayunar chuppa vuelta le' ttu ttu semana, ą'hua rutía' qui' diezmo de lo iyaba nu té quia'. Anía uccua oración qui' fariséua. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nu ruquíỹa qui' impuéstuá nna du huą́ le' templua pero idittu' nna, nìdirubani làa reyáỹanią ichìtha lúį, sino rue' la lòstu'į porqui'ni yala uccuą sentir por ca tul·la' qui'į nna rą: Señor Dios, betúalatsi' cuią'lu' inte' porqui'ni yala enne' tul·la' ná'. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Làniana ra tè Jesús: Hualigani te' nia' le qui'ni lą nna betsina'ą litsi'į yala lani la'ỹeni, porqui'ni beyuniỹén latsi' Tata Dios ca tul·la' quì'į; pero attu nuá nna labí beni Tata Dios na aceptar. Acca nia' le qui'ni nu cani qui'ni yala dàlianią nna, egà'na menos lą́; pero nu rulaba latsi'į qui'ni lanú nuỹa ną́ nna, lànuá nna ccá lą́ enne' ỹeni. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Làniana tahua' tè cą ca huatsa to' ru'a lo Jesús para qui'ni gutsia né'e iqquia quį. Bilá' báni ca discípuluá nui nna gutìl·la la cabi ca enne' dia ritahua' ca huatsa tú'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero Jesús nna gutàỹie cą nna rèe ca discípuluá: Lihue'él·la' ca huatsa tú'ą' ibíga' cą ru'a lua', bittu guthàga' le cą; porqui'ni reino qui' Tata Dios nna ną́ para ca enne' losto' humilde tì'a ca huatsą'. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Hualigani te' nia' le qui'ni nu labí té fe qui'į tì'a ttu huatsa tó' nna hue'él·la'ą qui'ni Tata Dios nna cu'úbia'nie na, entonces labí gá'ą le' reino quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Làniana ttu nubeyu' principal gunàba tìtsa'ą Jesús nna rą ne: Maestro bueno, biani gunia' para gata' la'labàni nu labí ttíą quia' cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús nna ra tìe na: Biani cca ra lu' inte' bueno nì'i. Nì ttú lanú té ná completamente tse' sino tùteruba Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Hua nabia' báni lu' ca mandamiento: Bittu thualàni lu' nu labí ná tsela lu'. Bittu gutti lu'. Bittu cuána lu'. Bittu ichìtha lu' bela'na qui' ca enne'. Gùppa respeto tàta nàna qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Becàbi tìą nna rą ne: Iyaba ca nuą' runia' dèsdeba ná nu cuìti'. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Biyeni báni Jesús nui nna rèe na: Hua reyatsaáruni lu' attulo: betti' iyate nu té qui' lu' nna, bète tì ą lani ca enne' ritè là'di', ỹiabara' lá nna gata' riqueza qui' riqueza qui' lu'; gutà tè para ccá lu' ttu discípulo quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Biyeni bánią nu rèe na, triste tsúbá beyéqquią, porqui'ni yala rico uccuą. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Gutebé' báni Jesús qui'ni yala triste uccuanią nna, ra tìe: Yala tàbi ná para canu té iỹeni bel·liu qui' quį tsíalatsi' quį nna hue'él·la' cą qui'ni Tata Dios nna quée enne' cu'úbia'nie cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Adila fácil ná tté ttu camello le' yèrù to' qui' ttu guỹa, tì'chula ttu rico gá'ą le' reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Làniana canu biyénini ca tìtsa'ą' nna ra cą: Entonces núlá ccani l·lą́ cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Lèe nna rèe cą: Nu rulaba latsi' ca enne' qui'ni labí ná posible, pues fácil bá ną́ para lani Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Làniana ra tè Pedrua ne: Intu' nna chi bethà'na tu' iyaba nu té qui' tu' nna chi denó tu' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús nna rèe cabi: Hualigani te' nia' le qui'ni hua tse'e canu chi bethà'na cą litsi' quį l·le, tàta nàna qui' quį l·le, ca bettsì' quį le, niula qui' quį l·le, ca ỹi'ni quį l·le por nu cca qui' reino qui' Tata Dios; ");
INSERT INTO zaaNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","acca làcą nna thí' cą adírulá bendición annana, ą'hua tiempo nu chì' da'la nna gata' huá la'labàni nu labí ttíą qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Làniana guleqquia Jesús tsì'nu ca discípuluá yà'latsi' nna rèe cabi: Annana dia ri'u ciudad Jerusalén. Nía nna ccá cumplir iyaba ca titsa' nu bedia ca profeta nu cca qui' Nubeyu' de Ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pues gute cą ne cuenta lani canu dittu' canu rigú'ubia' le' nación qui' ri'u, Ą'hua guni cą ne burla nna gul·luítsa' cą ne ca titsa' malo nna, gutùtu xèni' quį ne nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","hué' díbá cą ne lani cuarta, làniana iche' cą ne para gutti cą ne. Pero tsunna bitsa bitola nna, eyáthee de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ca discípuluá nna nìdi tito' làa gutelíni cabi biỹa nuá gutixe'e, porqui'ni beyà'na ba chul·la le' la' riyeni qui' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Loti' chi deyya Jesús exa taá yetsi Jericó nna, re' tè ttu ciego cuitta' nédaá rinàbą caridad. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","De biyéninią ril·làbì nì'a ca enne' ritè nía, acca gunàba tìtsa'ą biỹa nuá. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Làcą nna ra tè cą na qui'ni da' Jesús enne' nazareno. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Làniana gunne ciéguá iditsa nna rą: Jesús Ỹi'ni David enne' uccua rey, betúalatsi' cuią'lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ca enne' denéruá nna gutìl·la tè cą ciéguá qui'ni guthàya rú'į, pero lą nna adila iditsa gunnią nna rą: Cuią'lu' Ỹi'ni David, gùppa cuią'lu' la' retúalatsi' quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Gulèda tè Jesús nna benie mandado taxi' cą na ru'a lúe. Bitsina' báą nna gunàba titsa' tè Jesús na, ");
INSERT INTO zaaNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","rèe: Biani calatsi' lu' inte'. Becàbią nna rą ne: Señor, calátsa'a' elá' te'. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús nna rèe na: Annana iyàlia ca íyyalo lu' nna ilá'ni lu'; por fe nu té qui' lu' lani inte' nna acca chi té la'yani' qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Luégutaá bilá' chìnią nna dia tìą lani Jesús nna rudàlianią Tata Dios. Ą'hua iyábani ca enne' dia nía nna, de bilá'ni cą nu uccua nna bè' hua cą gracia Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Néda bá chi yù'u Jesús le' yetsi Jericó. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Le' yétsiá nna dua ttu nubeyu' rico láą Zaqueo nna uccuą jefe qui' iyaba canu riquiỹa qui' impuesto para gobiérnuá. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Lą nna yala uccua latsi'į ilá'nią Jesús nna gunibí'ą ne. Biria tìą díą táttsa'ą ne; pero de tántua ca enne' ỹétse'á nna labí uccua ilá'nią ne porqui'ni uccuą chaparro to'. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Acca quèthani beneruą nna huàppią lo ttu yà xeni para ilá'nią ne, porqui'ni níalá ná qui'ni ttíe. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bitsina' bá Jesús nía nna bilá'nie na duą lo yàgàa nna ra tìe na: Zaqueo, beyàdi xìa, porqui'ni le' litsi' lu' ná qui'ni il·lania' anna. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaquéá nna quèthani beyàdi chìą, yala lani la' redácca' latsi' benią ne recibir litsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nuá bá bilá'ni ca enne', acca gudulo chì cą betìtse'él·la' cą Jesús nna ra cą qui'ni huíe litsi' ttu nu huèni tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Bitola nna guduli Zaquéuá nna rą ne: Annana Señor, tsal·lue' taá de lo iyaba nu té quia' nna guté ya' ą lani ca enne' ritè là'di'. Ą'hua canchu chi bethácca'ỹía' nuỹa ttu enne' nna gutú'a' biỹa té quì'į nna, pues annana gudéqquia' átappa tántolá quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús nna rèe: Annana chi gul·lani salvación para ca enne' tsè'e le' yú'į, yà'ni qui'ni nubéyu'į nna chi ríalatsi'į nna ná huą́ ttu ỹi'ni Abraham. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Por nui nna bìta Nubeyu' de Ỹiabara', para hueyìla canu chi gunitti nna gudilèe cą le' ca tul·la' qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Exa gáabá Jerusalén chi dia Jesús nna, iyaba ca enne' biyénini cą titsa' qui'áa nna belaba latsi' quį qui'ni chi' taání duą íl·lani la' rigú'ubia' qui' Tata Dios. Acca gutixè'e ttu comparación nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","rèe: Ttu ènne'yu' tsè' nna huía bi attu país idittu' para thí' bi poder para ccá bi rey, làniana luégutaá eyéqquia bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pero ántesca thá' bi nna gutàỹi bi tsìi canu runi tsina qui' bía nna, bete bi ttu cantidad xeni de moneda qui' ttu ttu tsa quį nna ra tè bi cą: Gutha' le bél·liuį para guni le gana iqquia quį miéntraste tsa'á' nna él·lania'. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Guda' tè bi. Pero ca enne' látsi bía nna, la' yéelatsi' lá gùppa cą qui' bi, acca guthel·la' tè cą ttu comisión ru'a lo canu rigú'ubia' nía para ina cą: Labí calatsi' tu' qui'ni nubéyu'ą' nna ccą́ rey qui' tu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero làbi nna guỹi' la bi poder para ccá bi rey. Làniana beyéqquia bi nna gutàỹi tè bi ca mozo qui' bía canu bete bi bel·liu lani canaá para eyúni bi cuenta lani cą tsáliáỹa gana chi beni ttu ttu cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Bitsina' tè nu priméruá ru'a lo enne' ná rey nna rą: Señor, lani bel·liu qui' cuíą'lu'a nna chi benia' gana átsìi cantidad. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Làbi nna ra tè bi ą: Tsè'ba ná nu beni lu', pues siervo tsè' ná lu' porqui'ni lani ti'to' rúbá nna uccua lu' fiel, acca annana gudúa' lu' para cu'úbia'ni lu' tsìi ca yetsi. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Bitsina' huá áttuą nna rą: Señor, lani bel·liu qui' cuíą'lu'a nna chi benia' gana ágayu' cantidad. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Làbi nna ra bi ą: Ą'hua lu' nna, gudúa' lu' lo gayu' ca yetsi. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Bitsina' huá áttuą nna rą: Señor, nìba té bel·liu qui' lu'a, túabá te' ą le' ttu panitu, pues ");
INSERT INTO zaaNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","anía benia' porqui'ni gùtsi te' cuią'lu', porqui'ni ná cuią'lu' ttu enne' duro, cáalá bethá' ya' ą nna entonces huedi' telá cuią'lu' itútią, porqui'ni redi' cuią'lu' làti labí guda cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Làniana ra bi ą: Siervo malo ná lu'. Por la'a mísmuba titsa' qui' lu' nna acca ccá lu' condenar. Hua yù bá lu' qui'ni ná' ttu enne' duro, redí'a' nu làhuabi guda' ą'hua rutùppa' làti lahuábí bedál·la'a'. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Entonces, bianicca labí gulú'u lu' bel·liu quíyi'į banco para qui'ni canchu chi él·lania' nna edí' ya' ą lani ỹi'nį nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Làniana ra bi canu tsè'e nía: Líccua bél·liuą' lo ní'į nna, líúte tì ą lani nu beni gana átsìi tántua. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Làcą nna ra tè cą bi: Pero Señor, chìa té tsìi quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Becàbi enne' ná rey nna ra bi: Inte' nna nia' le qui'ni nuỹa tediba té quì'į nna, entonces lą nna thí' lą́ adí; pero nu labí té quì'į nna, pues hàstaá ti'to' nu té quì'į nna ítua telą́. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ą'hua iyaba canu na contrario quíya'a nna canu bihua uccualatsi' qui'ni ccá' rey qui' quį, litàxì' tsate' cą nì nna lichù yáni quį ru'a lua'. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Beyacca ba gunne Jesús ca tìtsa'a nna, dia tìe denérue para Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Exa tegáabá ca yetsi Betfagé nna Betania nna chi dia cabi luítta' i'ya láą Monte de los Olivos, guthel·la' tìe chuppa ca discípulo qui'áa nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","rèe cabi: Lítsía le' yetsi to' nu re' frente taá tétiá nna. Canchu chi bitsina' le nna hua taxácca' dígá le làti tá' ttu burro to' nu nìdi ttu enne' labí chi gutsią na. Ethàtsi li ą nna eche' tètsate' li ą nì. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Canchu nuỹa inàba tìtsa'ą le: Bianicca rethàtsi li ą, entonces lebi'į nna ecàbini lí ą: Porqui'ni Señor nna riquína'nie na. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Huía tè ca discípuluá nna taxácca' cabi tì'ba nu chi ra Jesús cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","De rethàtsi cabi burro tú'a nna, biria chì canu ná xana' niá nna ra cą cabi: Bianicca rethàtsi le burro tú'ą' nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Becàbi cabi nna ra cabi: Señor nna riquina'nie na. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Làniana beche' tè cabi burro tú'a làti du Jesús. Guxua tè cabi ca lári' qui' cabía cuì'į, Jesús nna gutsia tìe na. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Gutsìla tè cabi ca lári' lo néda para ttíe. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Chi' tegáabá duą quel·la' cabi liáỹu qui' Monte de los Olivos nna, làniana iyaba ca enne' ỹetse' dia lani áa nna yala bedacca' latsi' quį nna gudulo cą bedàliani cą Tata Dios por iyaba ca milagro nu chi benie lani ca enne' nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","acca gunne cą iditsa tsè': Bendito Enne' da' por nombre qui' Señor Dios para quée rey qui' ri'u. Acca hua té la' redacca' latsi' le' ỹiabara', la' dàliani para Tata Dios nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Làniana tuchùppa ca fariséua canu dia huá cą entre ca enne' ỹétse'á nna ra cą Jesús: Maestro, gutìl·la tí' canu da' lani cuíą'lu'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Becàbi Jesús nna rèe cą: Hualigani te' riquixa'ánia' le: Canchu làcą guthàya rú'a quį nna, pues hàstala ca íyya anta' lo nedį nna thulo cą inne cą idìtsa a favor de inte'. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesús nna bilá' bánie ciudad ri'ą exa taá nna, gudulue guretsie por lą nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ra tìe: Cáalá nabia' tsàni lu' qui'ni anna ná tsá de la'ỹeni para lu', pero bágá' bá ló lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Inte' nna nia' lu' qui'ni huàl·lani tsá qui'ni ca contrario qui' lu'a nna de repente taá íl·lani cą nna tséqquíá cą ìta'lùba lu'; ca soldado qui' quį nna gudàa cą guardia para qui'ni làa l·lá ca enne' qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Gutàppa' guthìnniani cą ca dé'e qui' lu' nna ca yú'u qui' lu' nna, gul·lùỹa cą latsi' ca enne' qui' lu' nna. Pues hàstaba ca íyya nna labí eyà'na iqquia luetsi quį sino iyáỹiani cą iyìnnia. Ą' ccá lani le porqui'ni labí bedácca'ni le loti' gul·lanie lani le. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Gutà'a ba Jesús le' templua nna, bedàl·lee fuera iyaba canu tsè'e nía huètti' nna huì'i nna runi cą negocio nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","rèe cą: Tata Dios nna rèe lo titsa' quì'e: Yú'u quíyi'į nna ną́ yú'u para oración; atsi'íni lebi'i nna, bèlìà qui' ubàna lá chi nani li ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesús nna gutixè'e ca enseñanza nu cca qui' Tata Dios ttu ttu tsá bá le' templua. Acca ca sacerdote principal nna ca maestro de la ley nna ą'hua canu rigú'ubia' entre ca enne' judíua nna yala uccua latsi' quį gutti cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero bihua modo betseláni cą bíỹalá guthácca' cą ne, porqui'ni iyáỹiani ca enne' bedà naga' qui' quì'e nna labí uccua latsi' quį gunitti cą ni ttu titsa' nu gunnie. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ttu tsá lània nna de riquixá'ani Jesús ca enne' le' templua ca enseñanza qui' Tata Dios nna de runie predicar acerca de ca titsa' tse' qui'e nna, bitsina' tè ca sacerdote principal nna ca maestro de la ley lani canu rigú'ubia' entre ca enne' yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Gunne cą lani e nna ra cą ne: Gutixa'áni intu'. Núní por mandado qui'ni acca runi lu' ca cosį. Núní benna deréchuį qui' lu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Becàbi Jesús nna rèe cą: Ą'hua inte' nna guni huá' le ttu pregunta, lecàbini inte': ");
INSERT INTO zaaNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Derecho nu béniní Juáan bautizar, tsí dá'ą de ỹiabara', o tsí ca enne' ba bete cą na áccá. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Làniana gudulo cą gunne lettia cą tì'iỹalá ecàbini cą ne nna ra luetsi quį: Ti'ani ecàbi ri'u annana: Canchu ina ri'u qui'ni Tata Dios bete derecho qui' Juáan para guni bi bautizar, entonces gá taą́ ri'u: Biálacca làa huíalatsi' le qui' bi cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ą'hua canchu ina ri'u qui'ni ca enne' ba bete permiso qui' bi, entonces iyaba ca enne' nna gudua cą íyya iqquia ri'u porqui'ni yala seguro ga'na cą qui'ni Juáan nna uccua bi ttu profeta nu guthel·la' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Acca mejor la becàbi cą nna ra cą: Labí yù tu' gáỹalá da' derecho qui' bía. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Làniana ra tè Jesús cą: Nìhua inte' nna labí quixa'ánia' le nuỹa benna la'huacca quia' acca runia' ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Gutixa'a tènì Jesús ca enni'a ttu comparación nna rèe: Ttu ènne'yu' nna guda bi planta qui' betsulí' le' loyu qui' bi. Betèsa tè bi lóyúa lani canu guni cą na tsina. Làniana guda' tè bi dia bi attu lugar nna labí betsina' tè bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bi'yu díbá tiempo cosecha qui' betsulí'a nna guthel·la' bi ttu mozo lani canu runi tsina le' lóyúa, para qui'ni gute cą qui' rendimiento qui' loyu qui' bía. Pero làcą nna bè' lá cą mózuá idí' tsè' nna bethel·la' tè cą na, bittu tení biỹa bete cą éyu'ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bedethèl·la' gáabá bi attu mozo nna, anía huá bedua dí' cą mózuá nna bè' cą na lani yà nna, ą́' tèruba dénáló ní'į bethel·la' cą na. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Bedethèl·la' gáabá bi attu mozo nu cca tsunnáa nna. Aníahuá bedethácca' cą na, de chi beni dí' cą quì'į nna bedàl·la cą na fuera. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Làniana enne' ná xana' lóyúa nna ra bi: Annana biáttsarúnuá gunia'. Ithél·la' cà'a' ỹì'nia' enne' yala catsi'íti'į, xiaba canchu chi ilá'ni cą bi nna huappa cà'ba cą bi respeto. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero canu runi tsina lóyúa nna de bilá'ni cą ỹi'ni bía nna gulù'u taá titsa' luetsi quį nna ra cą: Là nui nuą' eyà'na itúbá lóyúį. Lítsa', gutti ri'u ą para qui'ni ri'u la thí' nu reda' latsi' tàta qui' niá na ccá ri'u xana' itúbá lóyúį. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Làniana bedàxu' cą ỹi'ni bía nna bedàl·la cą bi fuera nna betti cą bi. Acca, biani guni propio gani enne' ná xana' lóyúa lani làcą cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pues el·lani bi nna gul·lùỹa bi latsi' canu runi tsìnàa nna, gutèsa tè bi loyu qui' bía lani canu huaya' la. Ą' ná comparación nu gutixa'a Jesús. Ca enni'a nna de biyénini cą ca titsa' quì'e nna ra tè cą: Làa ina cànna Tata Dios thacca' tu' tì' ra cuíą'lu'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero Jesús nna gunne'e cą nna rèe: Pues biani ritelíni le titsa' nu ga'na escrito làti ra: Iyya nu labí guyú'u latsi' canu rucùà' yú'a nna, Chi ną́ íyya principal nu adila tsìttsì naxu'ą yú'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Inte' nna nia' le: Nuỹa tediba ibìxi lo íyya principal ni nna l·lúỹa latsi'į, ą'hua nuỹa íqquianí ìnnia íyyį nna gútsi'ití'níą na. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Làniana ca sacerdote principal ą'hua ca maestro de la ley nna gutelíni cą qui'ni contra làbácą nuá gutixa'a Jesús enseñánzaá. Acca yala uccua latsi' quį gudàxu' cą ne, pero gutsibáni cą ca enne' yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Acca guleda ba cą ttu oportunidad nna bete cą bel·liu làtsi' ná' tuchùppa ca enne' para tsía cą guni bá cą ne prueba ti'átsí yala amigo tsè' ná cą lani e, canchu ecàbie ttu titsa' nu labí ná correcto, anía modo nna gappa cą néda gute cą ne cuenta làtsi' ná' gobernador. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Acca gunàba titsa' tè cą ne nna ra cą: Maestro, hua yù bá tu' qui'ni rulue' cuią'lu' nna riquixa'a cuią'lu' puro taá nu ná tsè', nìhua labí rucué'ní cuią'lu' ca enne' según la' rinna' qui' quį, sino ttu ru'ataá cani cuią'lu' cą nna riquixá'ani cuią'lu' iyábani ca enne' lo néda lígani qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gutixa'áni cuią'lu' intu': Tsí hua ná tsè' quiỹa ri'u nu ruthítsini gobierno qui' César ri'u, o tsí bíhuá áccá. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero Jesús nna gutelí taánie la' rulábalatsi' mal qui' quį nna rèe cą: Biecca calatsi' le guquìnnia le inte' lani ca tìtsa'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Líúlue' tsánnanì inte' bél·liuą' nna. Núní retrato quí'ní nui dua lo monédį, ą'hua núní láa ní nui dua nì. Becàbi cą nna ra cą ne: Qui' Cesar enne' romano ná rey. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Làniana ra tìe cą: Entonces líúte bá qui' César nu ná qui' César, ą'hua líúte bá qui' Tata Dios nu ná quì'e nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Por ca tìtsa'a nna labí biríalàni cą uquìnnia cą ne lani ttu titsa' ru'a lo ca enne' yétsiá, sino qui'ni biquíla' bá latsi' quį ti'iỹa becàbie, acca mejor la uccua taá tsi qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Làniana bitsina' tè tuchùppa canu denó cą religión saduceo. Ca saducéuá nna labí ríalatsi' quį qui'ni eyátha ca enne' de lo lù'uti. Làcą nna gunàba titsa' cą Jesús nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ra cą: Maestro, lo escritura nu bethà'na Moisés lani ri'u nna, ra qui'ni canchu nuỹa ttu enne' ní gatti ttu bettsi'į nna pero lanu ỹi'nį uccua, entonces ná qui'ni guttsa taání'į lani niuláa para qui'ni elìthą descendencia qui' bettsi'į nu gúttía. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Gutsé'e gàtsi bettsi' ca enne'. Bettsa tená' nu néruá nna, pero gùtti bą́ nna lanú ỹi'nį uccua. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Làniana nu cca chùppáa nna bettsa huání'į lani viúdaá, pero gùtti huá nubéyu'a nna, nìhua lanú ỹi'nį uccua. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Anía tehuá uccua lani nu cca tsùnnáa, hàstaá qui'ni iyaba canu gàtsi bèttsi'a nna gùdualàni cą niuláa, lanú ỹi'ni quį uccua. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Bitóte nna gùtti huá niuláa. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Canchu chi gal·la' tsá eyátha canu yatti nna, núlá canu gàtsi bèttsi'a ccá quì'į niuláa cá, ya qui'ni iyaba gàtsi cą nna bettsaná' quį lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús nna becàbinie cą nna rèe: Ca enne' qui' yétsiloyuį nna ruttsa báná' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero canu cca merecer tsé'e cą le' la'labàni nu chì' da'la nna eyátha cą de lo lù'uti nna, pues lanuru nuỹa guttsaná'. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Porqui'ni nía nna lanuru nuỹa gatti. Pues iyaba cą nna ccá cą ỹi'ni Tata Dios porqui'ni eyátha cą de lo lù'uti para la' labànía, acca ccá lá cą tì'a ná ca ángel. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pero acerca de canu yatti ná qui'ni eyátha cą de lo lù'uti nna, pues la'a mísmuba Moisés gutixa'a bi acerca de nua' làti rinne bi nu cca qui' tìttsa yèttse' nu ritè làl·lanía loti' ra bi qui'ni Señor nna née Dios qui' Abraham nna Isaac nna Jacob nna màsqui'ba chìa gutsá gùtti cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Quiere decir qui'ni canu yatti nna bàni ba cą. Cáalá labí ná ą́' nna, entonces ti'ani modo ra Tata Dios qui'ni entre canu yatti nna tsè'e canu runi cą ne adorar cá. Pues para lani Tata Dios nna, ą'hua ca enne' canu chi gùtti nna bàni bá cą, tì'a canu labí chi gùtti. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Becàbi tuchùppa ca maestro de la ley nna ra cą ne: Maestro, yala tse' becàbi cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pues labiru beyáỹani cą inàba titsa' cą ne adí. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Làniana Jesús nna rèe cą: Ti'ani modo acca rena cą qui'ni Cristua nna née ỹi'ni David cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Atsi'íni la'a mísmuba David gunne bi acerca de lèe lo libro qui' ca Salmos nna ra bi: Señor Dios nna gunènie Señor quíya'a nna rèe: Gùduani cuittá'a' lado bàni, ");
INSERT INTO zaaNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Hàstaá qui'ni gúnná' latsi' ná' lu' iyaba canu làa cca guyu cą lu', para qui'ni gúl·liani lu' iqquia quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Por ca tìtsa'a nna yù ri'u qui'ni la'a mísmuba David nna reya bi Cristua SENOR. Entonces, ti'ala modo acca née descendiente qui' bi cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Làniana ru'a lo iyaba ca enni'a nna ra Jesús ca discípulo qui'áa: ");
INSERT INTO zaaNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Líhue' cuidado lani ca maestro de la ley, qui'ni làa guni le tì'a runi cą. Yala rú'ulatsi' quį cueni cą lo néda lani ỹo tùni qui' quį, ą'hua yala rú'ulatsi' quį qui'ni ca enne' ỹetse' guni cą cą saludar canchu dia cą lo néda, ą'hua yala rú'ulatsi' quį xúaní cą lo ca asiento dàa íqquiará' tè le' ca sinagoga ą'hua lo ca primero asiento le' ca fiesta qui' quį para qui'ni ilá'ni ca enne' cą qui'ni yala enne' re' cuenta ná cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Làcą nna rigua cą hàstaá ca yú'u qui' ca pobre viuda nna, ą'hua màsqui'ba yala itsá runi cą oración pero labí lí nu runi cą. Acca nia' le qui'ni ca nui nna adila fuerte ná castigo thí' cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Le' templua nna bilá'ni Jesús ca enne' rico rigú'u cą bel·liu le' caja para ofrenda. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Bilá' huánie bitsina' ttu niula pobre ną́ viuda nna, gulù'į chuppa moneda nu de cobre dacca' cą ti'to' rúbá. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ra tè Jesús: Hualigani te' nia' le qui'ni niula viúdį nna yala là'di' rittìą, pero adila iỹeni betią tì'chula iyaba cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Porqui'ni iyaba cą nna rute cą qui' ofrenda para Tata Dios nu réxabáni cą, pero niulíį nna màsqui'ba ną́ pobre, pero bete lą́ itute hàstaá nu ná gonią. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Rinne tè tuchùppa cabi qui'ni yala tsè' ná templua, porqui'ni yala tsè' ná ca íyya cua'ni ca dé'a, ą'hua latsitte ni ná canu beda' latsi' ca enne' bete cą para ccá tsè' le' templua. Làniana ra Jesús cabi: ");
INSERT INTO zaaNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Huàl·lani tsá qui'ni iyaba ca cosa nu rilá'ni le annana, pues itàppa' iyìnniani cą porqui'ni huàl·lani canu dìttu' nna guthìnnia gutàppa'ni cą hàstaá qui'ni labiru eyà'na iqquia luetsi ca íyyį. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Gunàba titsa' tè cabi e nna ra cabi: Maestro, cuani ccá nu gútixa'a cuíą'lu'ą'. Biani señal ni ilá'ni tu' para ccá tu' saber ántesca thulo iyaba ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Becàbi tè Jesús nna rèe: Líhue' cuidado qui'ni làa guthacca'ỹí cą le. Porqui'ni nuỹetse' íl·lani lani nombre quia' nna ina cą qui'ni làcą nuá Cristua. Ą'hua ina cą: Chì' taání duą íl·lani fin. Pero bittu tsíalatsi' le qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Canchu chi guna le qui'ni cca guerra o qui'ni ritìl·la ca gobierno nna, bittu gátsini le. Porqui'ni náduel·la' ccá yà'latè ca cosį, pero nìhuani labí chi gùl·la' tè fin. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Raáruhuée cabi: Ttu nación nna til·lą contra attu nación, ą'hua ttu gobierno contra attu gobierno nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ą'hua íl·lani la' riỹú' fuértení, ą'hua íl·lani ubìna' nna itsahue' nna iỹé lettia tsè' le' yétsiloyuį. Ą'hua ca enne' nna yala gátsini cą porqui'ni ilá'ni cą ca señal nu cca ỹiaba. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pero ántesca íl·lani iyaba ca cosį nna, gutsia latsi' quį le nna gudàxu' cą le nna gute cą le cuenta lani ca enne' principal le' ca sinagoga, ą'hua gudàl·la cą le litsi' ìyya, ą'hua iche' cą le ru'a lo ca rey nna canu rigú'ubia' nna porqui'ni ná le enne' ríalatsi' quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Anía modo nna gappa le néda para quixá'a le nu cca quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Licuèqquia tsìttsi latsi' losto' le qui'ni bittu nùyue gá cani le ti'iỹa ecàbi le para guni sostener qui' le; ");
INSERT INTO zaaNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","porqui'ni inte' nna gunna' titsa' nna la' riyénitse' nna lo losto' le, hàstaá qui'ni canu iria contra le nna labiru ccani cą ecàbi cą biỹa contra ca titsa' qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ą'hua ca tàta nàna qui' le nna, ca bettsi' le nna, ca pariente qui' le nna, ca amigo qui' le nna gute cą le cuenta làtsi' ná' canu labí cca guyu cą le, pues gútti hua cą tuchùppa le. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pues itute yétsiloyu nna guyudí'ą le porqui'ni ná le enne' ríalatsi' quia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero nìdi ttu ittsa' iqquia le labí il·latsu' canchu labí ná voluntad qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Canchu ccá bá le tsìttsì lani inte' nna, huatta' la'labàni qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Canchu chi ilá'ni le iỹetse' ca soldado ìta'lùba ciudad Jerusalén nna, entonces ttélini le qui'ni chi bi'yu tsá qui'ni l·lúỹa latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Làniana canu tsè'e le' región qui' Judea nna dàni cą ucuìtta cą tsía cą lo ca ló'ya lá. Ą'hua canu tsè'e le' ciudáad nna dàni cą ucuìtta cą. Canu tsè'e fuera Jerusalén nna, bittu éya'a cą lì'į sino dàni cą ucuìtta telá cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Porqui'ni anía nna ccá cumplir iyábani nu chi ga'na escrito acerca de tiempo de castíguį. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Canchu chi bi'yu tsáa nna, ica'rútsi'íru ca niula nùà' huatsa to', ą'hua canu rigátsi' ỹi'ni to' qui' quį nna, porqui'ni yala ca sufrimiento íl·lani le' ituba nación nì ą'hua ttu castigo xeni iqquia yétsį. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ttu te cą nna gatti cą lo guerra, adí cą nna iche' canu dìttu' cą preso hàstaá attu nación huaya'. Ca enne' dìttu' nna ebèqquia bestè ní cą ciudad Jerusalén hàstaá qui'ni ilùỹa tiempo nu ná qui'ni guni cą dominar. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Làniana ilá'ní ca señal ỹiaba, porqui'ni labíru gudàni' bitsą' nihua biuá'ą' nna nìhua ca bélia nna. Ca enne' qui' yétsiloyu nna yala uccuè'eníą latsi' quį ą'hua yala gátsini cą porqui'ni yala ruido guni indatù'a thúlíníą. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Làniana igùtsi latsi' quį por tántua la' rátsilatsi' de tebé'ni cą íl·lani ca sufrimiéntua le' yétsiloyuį, pues hàstaá iyaba ca cosa canu tsìa ỹiaba nna, tatìttiní cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Làniana ilá'ni cą Nubeyu' de Ỹiabara' il·lanie le' ttu bía lani itute la'huacca quì'e nna la'yani' quì'e nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Canchu chi thulo ccá ca cosį nna, leyàppa fuerza nna lichìtha lo le nna línna', porqui'ni chi' taání duą íl·lanie para gudilèe le. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Làniana gutixa'a Jesús ttu comparación nna rèe: Linna'tsáruhuá ca yà exxuhuí ą'hua iyaba adí ca yà. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Canchu chi rilá'ni le qui'ni rebia l·la' qui' quį, pues anía modo ritelíni le qui'ni chì' taáduą íl·lani tiempo verano. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ą'hua lebi'į nna, canchu chi ilá'ni le qui'ni cca iyaba ca cosa nu chi gutixa'ánia' le nna, entonces ccá le saber qui'ni exa taá chi debiga' tiempo de la' rigú'ubia' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Hualigani te' riquixa'ánia' le qui'ni labí tté ca enne' tsè'e tiempo de ca señal ni hàstaá qui'ni iyábani ca cosį nna ccá cą cumplir. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ỹiaba nna yétsiloyu nna l·luỹa bá latsi' quį, pero ca titsa' quíyi'į nna labí tté cą sino té qui'ni ccá cą cumplir. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Líhue' cuidado por la'a lebi'į bá, qui'ni làa puro i'ya go le nna guni le borrachar nna yala nùyue ní tsè'e le nu cca qui' yétsiloyu nna, para qui'ni alàa ca nui lá runi le canchu de repente taá chi gal·la' tsá señalado nu nani Tata Dios, ");
INSERT INTO zaaNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","porqui'ni tì'a cca canchu chi là' retò taání ttu trampa, ą' modo de repente taá íl·lani tsáa nna nìyyani latsi' ca enne' tsè'e le' itúỹiani yétsiloyu nna labí l·lá cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Acca litsé'e al tanto, liguni oración tulidàba qui'ni gappa le fuerza para gutè le tsè' iyaba ca cosį canchu chi íl·lani cą nna tsé'e le lani la' redacca' latsi' ru'a lo Nubeyu' de Ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús nna ttu ttu tsá bá gutixe'e le' templua iỹétse' ca enseñanza. Pero de réla lá nna berie nna huíe beyà'née lo i'ya láą Monte de los Olivos. ");
INSERT INTO zaaNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Itúbani yétsiá nna huía cą ru'a lúe de díla lá le' templua para gudà naga' quį quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Exa taá chi debiga' fiesta canchu chi ro cą ettaxtíla sin levadura para qui'ni guni cą celebrar tsá pascua para éxalatsi' quį loti' gulàa ca ta' tàta qui' quį le' pais Egíptua. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ca sacerdote principal lani ca maestro de la ley nna beyìla cą néda ti'iỹa modo gutti cą Jesús, pero yà'latsi' bá gune lettia cą porqui'ni gutsibáni cą ca enne' yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Gutà'a tè Satanás lo losto' Judas nu guta' huá líį Iscariote, uccua huą́ ttu nu tsì'nu ca discípuluá. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas nna huíą làti tsè'e ca sacerdote principal ą'hua canu ná jefe qui' guardia qui' templua nna bè' huą́ titsa' lani cą tì'iỹalá modo gutią Jesús cuenta lani cą para gattie. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Làcą nna yala bedácca'ni cą nna beyà'na cą qui'ni gute cą bel·liu quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Lą nna guỹi'ché' bą́ nna guduluą beyìlą néda ti'iỹa modo gútią ne cuenta lani cą, sin qui'ni làa tébé'ni yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Gùl·la' bá tsá ro cą ettaxtíla sin levadura nna uccua duel·la' gutti cą ttu carneru to' para sacrificio qui' tsá pascua. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús nna guthèl·le'e Pedrua nna Juáan nna rèe cabi: Lítsía nna guni le preparar para go ri'u nna éxalatsi' ri'u tsá ỹénį. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Làcabi nna ra cabi e: Gani calatsi' cuią'lu' guni tu' ą preparar. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Lèe nna rèe cabi: Canchu chi gá'a le le' ciudą́', nía nna etsà' le ttu nubeyu' dénú'ą tu ré'e inda. Tanó tè li ą hàstaá le' yú'u làti éya'ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Línneni enne' ná xana' yú'a nna ga li ą: Guthel·la' Maéstruá intu' para inàba titsa' tu' cuią'lu': Gani nua' dua cuarto làti ná qui'ni gua' lani ca discípulo quíyi'į nna guni tu' celebrar páscuį. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nubéyu'a nna gulue' taánią le ttu cuarto xeni nu chìa dua léda bą́ duą iqquia ráa'lá, porqui'ni yú'a nna ną́ nu chuppa cua', nía nna liguni preparar para ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Làcabi nna huía cabi nna taxácca' cabi tì'a nu chi ra Jesús cabía. Nía nna beni cabi preparar para páscuá. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","De gùl·la' hóraá nna gùduani Jesús lo méỹaá, ą'hua ca apóstol lani e nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Làniana rèe cabi: Yàlani deseo té quia' gua' lani le tsá páscuį ántesca gattia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Porqui'ni nia' le qui'ni labiru go ya' ą attu hàstaá qui'ni ccá cumplir itútią le' reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jesús nna guỹi' tìe vásuá nna gunàbèe bendición lani Tata Dios nna, làniana rèe cabi: Líthi' ą nna líquithia ą entre lebi'i. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Porqui'ni nia' le qui'ni labiru í'yá' inda qui' betsulí' hàsta'na canchu chi íl·lani reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Làniana Jesús nna guỹi' tìe ettaxtílaá nna gunàbèe bendición; làniana gùl·le'ée na nna bì'e cabi nna rèe: Nui nna ną́ cuerpo quia' nu rutía' por lebi'i. Iį ba guni le para nu chì' da'la, pero siempre éxalatsi' le inte'. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Beyacca díbá gutó sé' cabi nna, guỹi' huée vásuá nna rèe: Vásuį nna runią representar convenio cubi nu runia' segúruní por medio de réni quia' nu ilàlia por lebi'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pero linna'áruhuá qui'ni nu gútią inte' cuenta para gattia', pues nìba rucà ní'į lo meỹį lani a'. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Hualigani qui'ni Nubeyu' de Ỹiabara' nna dia bée ttíe iyaba nu chi ná qui'ni ccá, pero ica'rútsi'íru nubeyu' nu gunią inte' traicionar. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","De biyénini ca discípuluá ca tìtsa'a nna gudulo cabi gunàba titsa' luetsi cabi núỹalá cabi nuá guni anía. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Huàdi hua ttu disgusto entre ca discípuluá acerca de núỹalá cabi ccá adiru enne' re' cuenta. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero Jesús nna rèe cabi: Iyaba ca rey yétsiloyuį nna rigú'ubia' cą itúbani, ą'hua iyaba canu té la'huacca qui' quį nna yala rudàliani ca enne' cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero entre lebi'i nna labí ccá ą́', sino qui'ni nu ná enne' principal entre lebi'į nna dànią eyacca lą́ ttu nu ruthète' tì'a ttu nu cuìti'. Ą'hua nu rigú'ubia' entre lebi'į nna dànią thú huą́ al tanto para gunią servir. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Porqui'ni, núlá dacca' adiru segun yétsiloyuį: Tsí nu ribé' lo meỹa, o tsí nu runi servir áccá. Tsí álahua adila dacca' nu ribé'ní lo meỹa cá. Pero inte' nna dua' entre lebi'į tì'a ttu nu runi servir. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Lebi'i nna tulidàba gutsé'e le lani inte' hàstaá lo iỹetse' ca prueba. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Acca inte' nna gutía' derecho qui' le para cu'úbia' le le' reino nu chi benna Tata quí'a lani inte', ");
INSERT INTO zaaNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","para qui'ni í'ya go le lani inte' le' reino quíya'a, ą'hua xuàni le lo ca xila' tsè'ni para guni le juzgar ca tsì'nu yetsi qui' ca enne' Israel. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Señor nna ra huée: Simón, Simón, bè' cuidado qui' la'a mísmuba lu', porqui'ni Satanás nna chi té permiso qui'į gunią iyaba le probar, tì'a ttu campesino rùttìą ỹua'xtila le' ttu harnero. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero inte' nna chi gunábania' Tata Dios por lu' para qui'ni bittu eyàtsa fe qui' lu'. Lu' nna de chi beyéqquia lu' lani inte' attu nna ná qui'ni gútse'e tsìttsì lu' ca bettsi' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedrua nna ra bi e: Señor, lístubá dua' para tsa'á' alàarùla litsi' ìyyà lani cuią'lu', sino ą'hua hàstaá gattia' lani cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús nna rèe bi: Pedro, nì nia' lu' qui'ni annana labí thí'ché' lu' por tsunna vuelta qui'ni nabia'ni lu' inte', làniana cuetsi xcurúdiá. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Raáruhuá Jesús cabi: Loti' guthél·la'a' le sin morral nna sin bolsa para bel·liu nna sin guarachu nna, tsí beyatsa biỹa qui' le cá. Becàbi cabi nna ra cabi: Labí biỹa. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Làniana rèe cabi: Pero annana nu té ttu morral quì'į nna, pues thí'ą na, ą'hua nu té ttu bolsa to' nu yù'uni bel·liu quì'į nna ná qui'ni huá'ą na gaỹa tediba díą. Nu labí té ttu espada quì'į, pues ná qui'ni gúttí'ą biỹa màsqui'di mata quì'į para ccá gó'oníą tu espada, porqui'ni chi' taání duą lanúruà' té lani le. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Porqui'ni caduel·la' ccá cumplir lani inte' iyaba nu ga'na escrito làti ra: Làcą nna belàtsi' cą ne entre canu huèni maldad para gattie. Pues iyate nu ga'na escrito acerca de inte' nna chi gul·lani tsá qui'ni ccą́ cumplir. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Làcabi nna ra cabi e: Señor, nì té chuppa teruba espada. Lèe nna rèe cabi: Huacca taání ca nuą'. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Biria tè Jesús nna huíe Monte de los Olivos tì' ba nu runi bée. Ca discípulo qui'áa nna denó tè cabi e. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bitsina' díbée nía nna rèe cabi: Liguni oración para qui'ni làa ìnnia le le' ttu prueba nu labí ccani le gúchia li ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Làniana biria yètsì'e nna huíe ati'to' tè idittu', beduỹíbie nna benie oración nna ");
INSERT INTO zaaNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","rèe: Tata quia', canchu calatsi' cuią'lu' nna gutua bá cuią'lu' sufrimiento nu tté yì'į lani inte'; pero alàa tì'a cabálátsa'a', sino ccá bá según voluntad qui' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Làniana de repente taá gudu tè ttu ángel qui' ỹiabara' ru'a lúe nna gùppèe adí fuerza quì'e para qui'ni bittu quée desmayar. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","De chi rehuiní' xàttànie nna adila fuerte benie oración nna indétha quì'e nna uccuą ti'taání càniba' él·lani réni binnia cą loyu. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","De beyacca beni oración nna bedulie nna beyéqquie làti tsè'e ca discípulo qui'áa nna, bilá'nie qui'ni ti'áthi bá cabi, porqui'ni yala chi guretsi cabi por tristeza nu uccuani cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesús nna ra tìe cabi: Leyátha nna liguni oración, línaba qui'ni làa ìnnia le le' tentación. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Hua rinne cànna bée nna bitsina' chì canu ỹetse' ca contráriuá. Judas ttu canu tsì'nu ca discípuluá nna dénéruą lo quį nna gubíga'ą ru'a lo Jesús para gúttsa'lúį ne. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesús nna ra tìe na: Judas, tsí lani ttu beso rute lu' cuenta Nubeyu' de Yiabara' cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ca enne' tsè'e nía lani Jesús na, de bilá'ni cabi ti'iỹa chi ruthácca' cą ne nna, acca ra cabi e: Señor, guni dí' cà'a tu' qui' quį lani espada cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ttu bi nna quèthani bè' bi ttu siervo qui' nu ná huexána' qui' ca sacerdóteá nna guchu bi yéti nàgui'į lado bàni. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ra tè Jesús: Bíttuúru biỹa guni le. Líhue'él·la' cą. Làniana beláppa' tìe yéti naga' siérvuá nna beyúnie na. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Làniana gunne Jesús lani ca sacerdote principal ą'hua lani canu ná jefe qui' guardia qui' templua nna ą'hua canu rigú'ubia' le' yétsiá nna, quiere decir iyaba canu bitsina' para gudàxu' cą ne nna, rèe cą: Tsí da' le yù'u ná' le espada nna yà nna para gudàxu' le inte' preso ti'atsi ná' ttu ubana cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ttu ttu tsá bá gudúa' lani le le' templua nna, atsi'íni bihua bedàxu' le inte'. Pero chi gul·la' hora qui'ni lebi'i nna la'huacca de la' chúl·la nna guni le nu calatsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bedàxu' cą ne preso nna guche cą ne litsi' huexána' qui' ca sacerdóteá. Pedrua nna idittu' bá denó bi e. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Becùà' tè cą yi' le' lí'a. Guỹua tení iyaba cą ìta'lùba yí'a. Pedrua nna gure' huá bi lani cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ttu sirvienta nna bilá'nią Pedrua re' bi cuitta' yí'a nna bedácca' tsè'bánią bi nna ra tìą: Ą'hua nui nna gurèni huą́ lani nubéyu'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero Pedrua nna labí guỹi'ché' bí nna ra la bi: Lu' niula, labí nabia' te' nubéyu'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ti'to' taá bitola nna bilá'ni áttuą bi nna rą: Ą'hua lu' nna enne' qui' huá quį ná lu'. Pedrua nna ra bi ą: Labí ná'. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ttu hora ti'gá bitola nna adila fuerte benią sostener nna rą: Hualigani qui'ni nui nna gurèni huą́ lani ą porqui'ni ą'hua lą nna ná huą́ enne' Galilea. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedrua nna ra bi: Lu' nubeyu', nìdi làa yúá' biỹa nuá ra lu'. Atsaba rinne Pedrua nna gurètsi chì xcurúdiá. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Làniana bedèqquia lo Señor nna gunnè'e Pedrua. Pedrua nna bexa tèlatsi' bi ca titsa' qui' Jesús loti' rèe bía: Antesca cuetsi xcurúdiá nna, tsunna vuelta ína lu' qui'ni labí nabia'ni lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Acca yala behuiní'ni bi nna, beria tè bi nía nna biditsùni bi guretsi bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Canu bedàxu' cą Jesús preso nna yala burla beni cą ne nna bè' cą ne golpe. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bethàya tè cą lúe lani ttu lári' nna gutìni ná' quį lúe nna ra tè cą ne: Gùnna tsánna nuỹa nua' bè'ą lu' nna canchu hualigani ná lu' ttu profeta. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ą'hua lani iỹétse'éru ca titsa' mal nna beni cą seguir bedua dí' cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Huàni' bá nna betùppa canu rigú'ubia' entre ca enne' judíua lani ca sacerdote principal nna ca maestro de la ley qui' ca niá nna; iyaba cą nna guche' cą Jesús ru'a lo Junta Suprema. Nía nna gunàba titsa' cą ne nna ra cą: ");
INSERT INTO zaaNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Gutixa'áni intu' canchu lu' nuą' Cristua. Lèe nna rèe cą: Canchu quixa'ánia' le nna, labí tsíalatsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ą'hua canchu biỹa inába tìtsa'a' le nna, labí ecàbini le inte' nìhua làa gúla' huá le inte' nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero dèsdeba annana Nubeyu' de Ỹiabara' nna cué'níe ỹiabara' lugar de la' dàliani qui' Tata Dios enne' té itute la'huacca quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","De rèe ca tìtsa'a nna iyaba cą nna ra cą ne: Tsí hualigani ná lu' Ỹi'ni Tata Dios cá. Jesús nna rèe cą: Lébi'i bá chi ra qui'ni ą́' ná'. ");
INSERT INTO zaaNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Làniana ra cą: Biáruálá titsa' ni riquina' gúna ri'u cóntrį cá. Porqui'ni la'a mísmuba ri'u chi biyénini ri'u ca titsa' quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Làniana guduli chì iyáỹiani cą nna guche' cą Jesús ru'a lo Pilátua. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Gudulo tè cą betsia cą queja contra Jesús nna ra cą: Chi bedàxu' tu' nubéyu'į porqui'ni yala escándalo runią le' nación qui' ri'u nna labí calatsi'į quiỹa tu' nu ruthítsi gobierno qui' rey qui' ri'u César nna reną qui'ni la'a labą́ ná Cristo, ti'átsi ná huą́ ttu enne' rigú'ubia'. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Làniana gunàba titsa' Pilátua Jesús nna rą: Tsí ná lu' Rey qui' ca judíuą' cá. Becàbi Jesús nna rèe na: Ą'chu chi ra lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilátua nna rą ca sacerdote principal ą'hua iyaba ca enne' tsè'e nía: Nìdi ttu falta làa retsèla te' qui' nubéyu'į. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero làcą nna adila dìtsa gunne cą nna ra cą: Yala alboroto runi ca enne' por causa de ca enseñanza quì'į, guduluą dèsdeba Galilea làniana le' itúỹiaba Judea hàstaá nì. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilátua nna de biyéninią qui'ni Jesús nna bethète'nie ca enne' dèsdeba le' estado qui' Galilea, acca gunàba tìtsa'ą canchu née enne' galileo. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","De ùccuą saber qui'ni Jesús nna uccuee enne' galileo, acca gulèqquia latsi'į ithél·la'ą ne ru'a lo Herodes nu uccua gobernador qui' Galilea. Herodes nna re' huą́ ciudad Jerusalén tiempo lània. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bilá' báni Herodes Jesús nna, yala bedácca'nią porqui'ni chìa gutsá uccua latsi'į gunibí'ą ne; porqui'ni iỹetse' ca cosa chi biyéninią nu cca quì'e, acca yala uccua latsi'į ilá'nią ne gunie ttu milagro. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes nna beni tìą Jesús iỹetse' pregunta, pero lèe nna labí biỹa becàbinie na. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tsè'e tè ca sacerdote principal ą'hua ca maestro de la ley, yala fuerte beni cą sostener nu gunne cą còntre. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Làniana Herodes nna lani ca soldado qui' niá nna yala bedua dí' cą ne nna beni cą ne burla nna begàccu' tè cą ne ttu lári' latsitte nu dacca' yáỹi nna. Làniana bethel·la' tìą ne lani Pilátua attu. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dèsdeba tsá lània nna yala amigo beyacca Pilátua lani Herodes. Antes nna bìtsa'a báni luetsi quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilátua nna gutaỹi tìą ca sacerdote principal nna canu rigú'ubi'á nna ą'hua ituba yétsiá nna ");
INSERT INTO zaaNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","rą cą: Chi tahua' le nubéyu'į ru'a lua' nna ra le qui'ni yala rigú'u tìtsa'ą ca enne' para chatha cą contra gobierno qui' rí'uį, pues iyaba chi gunába titsa' ya' ą ru'a lo le nna pero labí causa betsèla te' quì'į acerca de ca queja nu rutsia le còntrį, ");
INSERT INTO zaaNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","nìhua Herodes nna labí causa betseláni bi quì'į, acca bethel·la' bi ą nì attu. Nubéyu'į nna labí biỹa delito ni chi benią nu dacca' gattinią, ");
INSERT INTO zaaNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","acca guni tí'cà'a ya' ą castigar làniana gúlá' ya' ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Anía ra Pilátua porqui'ni uccuą obligado qui'ni ttu ttu fiesta nna gúlá'ą ttu preso nu inàba yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero iyáỹiani cą guretsiyà'a cą ttu tiémpubá nna ra cą: Gatti bá nua' nna bela' bá Barrabás nà'. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás nna tíą litsi' ìyyà porqui'ni gùlanią canu gutíla alboroto le' yétsiá contra gobiérnuá nna betti cą ttu enne'. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Gunèni Pilátua cą attu nna uccua latsi'į gúlá'ą Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero làcą nna adila dìtsa guretsiyà'a cą nna ra cą: Betaá' ą lo curutsi, betaá' ą lo curutsi. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilátua nna bedenàba titsa' gáabą́ cą nu cca tsunna vuelta nna rą: Pues, biani mal ni chi beni nubéyu'į ni'i. Nìdirubani ttu delito ni'i etsèla te' quì'į nu dacca' gattinią. Guni ba ya' ą castigar ti'to', lànialá nna gúlá' ya' ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero làcą nna adila túléchùni gutsé'e cą gunne cą idìtsa nna gunàba cą qui'ni gutá' ca soldádua ne lo ttu yà curutsi. Canu yétsiá ą'hua ca sacerdote principal nna beni ba cą seguir guretsiyà'a cą hàstaá qui'ni uccua tì' calatsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Làniana beni Pilato mandado qui'ni guthácca' cą Jesús tì'ba nu gunàba yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Bethà'na tìą libre nubeyu' nu té litsi' ìyyà nu gutíla ruíduá nna bèttìą enne', porqui'ni ą́' bá gunàba cą. Pero Jesús nna bete tìą ne cuenta làtsi' ná' ca enne' làa cca guyu cą néa. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","De chi dia cą che' cą ne nna, tattsa' cą ttu nubeyu' Cirenéo lą́ Simón, déda'ą de lo tsina. Betsia tè cą curutsi qui' Jesús cùì'į para huá'níą na nna tanó tìą Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Dia tè iỹétse'ní ca enne' qui' ciudáad, entre làcą nna tse'e huá ttu te ca niula canu yala ribetsi cą nna rehuiní'ni cą por nu ruthacca' cą Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Bedèqquia tè lo Jesús gùnne'e ca niuláa nna rèe cą: Lebi'į nu Jerusalén, bittu cuetsi le por inte' sino licuetsi la por la'a lebi'i ba nna por ca ỹi'ni le nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porqui'ni huì'yu tsá qui'ni ina cą: Ica'rubà ca niula ná huètsi, canu labí begátsi' huatsa nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Por ca sufrimiento nu íl·lani nna, thulo ca enne' gatta'yúni cą ca i'ya nna ína cą: Liyìnnia iqquia tu'. Gá huá cą ca i'yatò': Liucàttsi' tí' intu', ");
INSERT INTO zaaNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ą' ná nu ccá lani ca enne' canchu chì' ridulo ba ca sufrimiéntuą', pero tì'a gani ccá la'té qui' quį después lá cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Guche' huá cą lani Jesús chuppa canu hueni delito nu dacca' qui'ni gatti cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","De bitsina' cą lani e làti láą Lugar Iqquia Bega' Yatti, nía nna gùda cą ne lo yà curútsia. Aníahuá gùda cą chuppa canu hueni maldad lo áchúppa ca curútsia. Bedu cą curutsi qui' ttuą lado ná' bànie, áttuą lado ná' yàttie. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","De rutá' cą Jesús lo curútsia nna, gùnnie nna rèe: Tata Dios, beyuniỹén latsi' cuią'lu' qui' quį, porqui'ni labí yù cą biỹa nui runi cą. Làniana ca soldádua nna gùl·la'ání cą ca ỹúeá nna, bedàl·la cą rifa lo quį para gúlui'ą nuỹa ca ỹúeá gal·la' ttu ttu tsa cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Iyábani ca enne' yétsiá nna tsè'e cą rinna' cą. Canu rigú'ubia' le' yétsiá nna beni cą ne burla nna ra cą: Canu huaya' nna bedilà bą́, pues gudilàa la'a làbą canchu hualigani ną́ Cristo enne' becué' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ą'hua ca soldádua nna beni huá cą ne burla, bitsina' cą nna bè' cą ne vinagre í'yèe, ");
INSERT INTO zaaNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ra tè cą ne: Canchu hualigani ná lu' Rey qui' ca enne' judío nna, bedilà la'a lù'ba. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Betá' tè cą ttu letrero ỹíqquie lani ca titsa' griego nna latín nna hebreo nna rą: NUI NUA' NÁ REY QUI' CA JUDÍO. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Làniana ttu canu hueni delito tá' nía nna, bedua dí' huą́ Jesús nna rą ne: Canchu hualigani ná lu' Cristo nna, bedilà la'a lù'ba nna tsa'tsela tehuá intu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Attu nu tá' huá lo attu curútsia nna gutìtsa'ą na nna rą: Tsí átsahuá làa rátsini lu' juicio qui' Tata Dios de chi tá' huá lu' nà' para gatti lu', pues ");
INSERT INTO zaaNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ri'u nna hualigani cca bá ri'u merecer sufrimiento nu ritè ri'u anna porqui'ni chìa ríỹa ri'u por ca mal nu chi beni ri'u. Pero ènni'į nna labí biỹa mal benie. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Làniana ra tìą Jesús: Exa tí' chì latsi' cuią'lu' inte' canchu chi ìta cuią'lu' para cu'úbia' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús nna rèe na: Hualigani te' nia' lu' qui'ni anna taá chi du lu' lani inte' le' lugar de la' redacca' latsi' nna la'ỹeni nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","De gùl·la' ttú tsì'nu hora ti'gá nna, bechul·la le' itúbani yétsiloyu hàstaá ritį tsunna. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Bitsą' nna betua la'yani' quì'į. Lári' rriani nu dàa le' templua nna biredà'ą nna uccuą chuppa l·là'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Gunne tè Jesús idìtsani nna rèe: Tata Dios quia', làtsi' ná' cuią'lu' rucà'na' espíritu quia'. Beyacca ba rèe anía nna, gùttie. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","De bilá'ni capitán románuá iyaba nu uccua nna, guduluą bedàlianią Tata Dios nna rą: Hualigani qui'ni nubéyu'į nna labí biỹa mal benie. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Iyaba ca enne' iỹétse'ní tsè'e nía huia' nna bilá' huáni cą iyaba nu uccua. Deyya tè cą nna yala rue' losto' quį porqui'ni yala sentir uccua cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero iyaba canu benibiá' cą ne, ą'hua ca niula da' dèsdeba Galilea huíalatsi' quį ne nna, idittu' gutsé'e cą bilá'ni cą iyaba ca cosa nu uccua. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Gùdua ttu enne' lá bi José nu yetsi Arimatéa región qui' Judea. Làbi nna uccua bi ttu miembro lani Junta Suprema qui' ca enne' judíua. Yala enne' tsè' nna enne' de respeto nna uccua bi. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Joséa nna hua yù hua bi qui'ni íl·lani reino qui' Tata Dios, acca labí de acuerdo gudu bi lani propósito qui' Júntaá nìhua lani ca hecho qui' caniá nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Huía bi ru'a lo Pilátua nna gunàba bi cuerpo qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Bechìda diba bi e nna betùbi bi e ttu sábana nna gutìxa tè bi e le' bà nu dua le' ttu iyyatò' làti lanú nuỹa nu yàttini chi guyú'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tsá lània nna runi prevenido qui' ca enne' para tsá ỹeni ná qui'ni edi' latsi' quį, nu ridulo gùl·là viernes lània. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ca niula canu beni cą Jesús acompañar dèsdeba birie Galilea nna, huía huá cą nna bila'ni cą qui'ni chi gutta' cuerpo qui' Jesús le' bèlia nu gudua le' iyyatù'a. ");
INSERT INTO zaaNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Beyéqquia tè cą nna beni cą preparar especias nna ungüento nu rilàa' iỹíxí nna, para cuerpo qui'e. Làniana bedi' latsi' quį conforme tì'a ra lo mandamiento qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dilatò'ni qui' tsá domínguá nna huía ca niuláa lo bàa. Làcą nna bìà' cą ca ungüento iỹixi nu beni cą preparar. Huía huá átuchùppa ca niula lani cą. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bitsina' cą nna bilá'ni cą qui'ni íyya nu yáyani ru'a bàa nna, pues ttu lado la chi ri'ą. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Gutà'a ba cą nna pero lanuru cuerpo qui' Señor Jesús té nía. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Acca yala nùyue uccuani cą lani la' rátsilatsi'. De repente taá nna gùdu chuppa ca nubeyu' cuitta' quį, uccua tìttini ỹó cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ca niuláa nna yala gutsini cą nna bedètta' tè lo quį loyu. Ca ángeliá nna ra tè cabi cą: Biecca reyìla le entre canu yatti enne' bàni cá, ");
INSERT INTO zaaNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","lanúrue té nì, pues chi beyáthee de lo lù'uti. Hua yù ba le biỹa gutixe'e loti' reniírue le' Galilea nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Náduel·la' qui'ni Nubeyu' de Yiabara' nna gute cą ne cuenta làtsi' ná' canu tul·la' hàstaá qui'ni gutti cą ne lo yà curútsia, pero tsùnna ubitsa bitola nna eyáthee de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Làniana bexa latsi' ca niuláa ca titsa' nu gunne Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bedà' tè cą lo bàa nna beyya cą huequixa'áni tsìnia ca discípuluá ą'hua adí ca enne' iyaba ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","María enne' Magdala nna, ą'hua Juana nna, ą'hua attu María nàna qui' Jacóbua nna, ą'hua adí ca niula nna gutixa'a cą ca cosį ru'a lo ca apóstol. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero para làcabi nna puro cuento ba ná nu ra ca niuláa, acca labí huíalatsi' cabi nu ra canaá. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero Pedrua nna huía tè bi quèthani lo bàa. Gunna' tè bi liú'u nna bilá'ni bi tsuą' teruba ca lári' nu betètsiní cabi Jesús. Bedà' tè bi nna yala belaba latsi' bi de nu uccua. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","La'a mísmuba tsá lània nna, chuppa cabi nna deyya cabi ttu yetsi to' láą Emaús, ga'ną ttú tsunna legua ti'gá idittu' de Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Dia cabi lo neda rue' cabi titsa' qui' iyaba ca cosa nu chi uccua. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","De rue' thuti cabi titsa' nna bitsina' tè la'a mísmuba Jesús nna dia tìe lani cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero làcabi nna labí bedácca'ni cabi qui'ni Jesús bá enni'a rida' lani cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Làniana rèe cabi: Biani titsa' ní nuą' rue' le de yù'u le néda, biecca yala rehuiní'ni le nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Becàbi ttu bi lá bi Cleofas nna ra bi e: Iyáỹiani ca enne' nna yù cą biỹa ná nu uccua le' Jerusalén nàya náthíą́'. Tsí làteruba lu' nu huía nà' nna labí yù lu' nu uccua cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Làniana rèe cabi: Biani uccua. Làcabi nna ra cabi e: Pues acerca de Jesús enne' Nazaret enne' uccue profeta qui' Tata Dios lani la'huacca, tantua por ca hecho quì'e le' templua ru'a lo iyábani ca enne', ą'hua por ca titsa' tsè'ni quì'e nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","pero ca sacerdote principal nna ca uxtícia qui' tu'ą' nna bete cą ne cuenta hàstaá qui'ni gulèqquia cą sentencia quì'e gattie nna, betaá' cą ne lo yà curútsia. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Atsi'íni intu' nna uccuani tu' qui'ni lèe nuá enne' ná qui'ni ìta gunie librar yetsi Israel. Pero anna lá cca tsunna ubitsa qui'ni gùttie lo curútsia nna bigàttsi' tìe. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ą'hua yala uccuaỹí latsi' tu' por nu ra tuchùppa ca niula canu huía huá latsi' quį ne. Làcą nna huía cą ru'a bàa ántesca tsáni', ");
INSERT INTO zaaNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pero núruhuá cuerpo qui' Jesús té nía, acca beyéqquia cą nna ra cą qui'ni bilá'ni cą ca ángel de ỹiabara' nna ra cabi cą qui'ni Jesús nna beyacca bànie nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","huía tè tuchùppa ca compañero qui' tu' ru'a bàa nna bilá'ni cabi qui'ni hualibani ca niuláa nu ra cą, pero labí bilá'ni cabi Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Làniana ra tè Jesús cabi: Lebi'i nu làa ritelíni. Yala bétsi cca le convencer para tsíalatsi' le iyaba nu gunne ca profeta, ");
INSERT INTO zaaNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","tsí álahua uccua duel·la' qui'ni Cristua nna quée padecer iyaba ca cosį ántesca etsìne'e ỹiabara' para thí'e la' dàliani nna quée enne' ỹeni cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Làniana bethàtsi là'nànie cabi iyaba ca Escritura nu riquixá'a acerca de lèe, dèsdeba ca libro nu bedia Moisés ą'hua ca libro nu bedia iyaba ca profeta nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Betsina' bá cabi yetsi Emaús. Jesús nna benie ti'atsi dia bée adí idittu'. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero làcabi nna yala duel·la' beni cabi gutta'yúni cabi e nna ra cabi: Nìba beyà'na cuią'lu', porqui'ni chì' tegání ràl·là. Làniana gutà'a tìe litsi' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","De chi re'níe lo méỹaá lani cabi nna guỹi'e ettaxtílaá nna gunàbèe bendición nna gùl·le'ée na nna bì'e cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Làniana gutelíni cabi qui'ni Jesús bá enni'a. Pero lèe nna de repente taá bede'e ru'a lo cabi nna labiru bilá'ni cabi e. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Làniana ra tè luetsi cabi: Tsí álahua tì'a ttu yi' nu ràl·la' uccua titsa' quì'e lo losto' ri'u loti' gunènie ri'u de beyú'u ri'u nédaá nna gutixa'ánie ri'u nu ra lo Escritura cá. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Guduli tabá cabi nna beyéqquia cabi Jerusalén nna betseláni cabi tsìnia ca apóstol tsè'e cabi júntubá, ą'hua adí ca enne' tsè'e lani cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Làcabi nna gutixa'a tè cabi qui'ni hualigani chi beyátha Señor de lo lù'uti nna bànie attu nna, ą'hua chi bilá'ni Simón ne. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Làniana chuppa ca ènne'yu'a nna gutixa'a huá cabi iyaba nu uccua loti' deyú'u cabi néda para yetsi Emaús, ą'hua ti'iỹa modo bedácca'ni cabi e tiempo de gùl·le'ée ettaxtílaá nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Atsaba rinne cabi nna, la'a mísmuba Jesús nna gùdue lahui' iyaba cabi nna benie cabi saludar nna rèe: La'ỹeni para lo losto' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero làcabi nna yala gùtsini cabi, belába latsi' cabi qui'ni bilá'ni cabi ttu nu tsayèlà. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero lèe nna rèe cabi: Bianicca rátsini le nna gùl·lani la' rudu chùppanią lo losto' le nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Línna'áruhuá ca nàya' nna ca nì'a' nna, qui'ni la'a inte' ba nui. Liuláppa' nna línna' tsè', porqui'ni ttu espíritu nna labí yu'ą́ bèlá' nìhua tsítta nna, inte' nna entero cuerpu ba ná' tì'taání rilá'ni le inte' dua' nì. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","De rèe anía nna, belue'nie cabi ca né'e nna ca nì'e nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Làcabi nna labí huía tè latsi' cabi por tanto la' redacca' latsi' canchu enni'a nua' Jesús. Lèe nna rèe cabi: Tsí hua té tí' qui' le biỹa go ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bete tè cabi ttu pedazo bél·la nàyì' quì'e ą'hua ttu etta ỹìxi bédu nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Guỹi' tìe cą nna bilá'ni cabi e gùtùe. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Làniana ra tìe cabi: Chi gutixa'ánia' le loti' reniíruà' lani lía qui'ni uccua duel·la' ccá cumplir iyate nu ga'na escrito nu cca quia' lo ley qui' Moisés nna ą'hua nu ra lo ca libro nu bedia ca profeta nna libro láą Salmos nna. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Làniana bethàtsie la' ritelíni qui' cabi para qui'ni telini cabi tsè' ca enseñanza nu ra lo ca Escríturaá acerca de lèe nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","rèe cabi: Ą' bá ga'na escrito, qui'ni uccua duel·la' qui'ni Cristua nna quée padecer, pero bìtsa tsunna nna eyáthee de lo lu'uti nna, ");
INSERT INTO zaaNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ná qui'ni ccá predicar lani nombre quì'e, dèsdeba Jerusalén hàstaá le' iyaba ca nación qui' yétsiloyu qui'ni eyacca ca enne' arrepentir nna eyuniỹén latsi' Tata Dios ca tul·la' qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Lebi'į nna chi bilá'ni le iyaba ca cosa nu uccua lani inte', para qui'ni cueqquia lí lé cą ru'a lo ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Inte' nna ithél·la'a' lani le nu chi beni Tata quí'a prometer qui'ni gúnnée qui' le, pero lebi'i nna ná qui'ni cueda ba le le' ciudad Jerusalén nì hàstaá qui'ni guni le recibir itute la'huacca de ỹiabara' nu gúnnée qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesús nna benérue cabi lo néda para fuera ciudáad nna guda' cabi lani e hàstaá yetsi láą Betania. Nía nna guchìtha né'e ru'a lo cabi nna benie cabi bendecir. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Hua dàa cànna ba né'e runie cabi bendecir nna de repente taá bede'e ru'a lo cabi nna déyyeé ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Làcabi nna bedu taá ỹibi quį nna beni cabi e adorar. Làniana beyéqquia cabi Jerusalén nna yala bedacca' latsi' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tulidàba gùtse'e cabi le' templua bedàliani cabi Tata Dios. Ą' uccua.");
INSERT INTO zaaNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Antes càla cue' yétsiloyu nna, chìlá dua Enne' née Titsa'. Tìtsa'a nna dúe lani Tata Dios, ná huée Dios nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Lèe nna dúe cuitta' Tata Dios dèsdeba néruá. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iyábani ca cosa nna uccua cą por lèe. Cáalá làa por lèe nna, nìdi ttu cosa nu té nna labí uccuą. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Lani lèe nna dua la'labàni. La'labàni nna ną́ la'yani' para ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","La'yani' nna rudàni'ą le' chul·la. La'chul·la nna labí birialànią guthòlą na. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Gùdua ttu ènne'yu' gùta' láa bi Juan. Guthel·la' Tata Dios bi nna, ");
INSERT INTO zaaNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","bìta bi para cueqquia li bi nu cca qui' la'yáni'a, para qui'ni iyaba ca enne' nna tsíalatsi' quį por nu riquixa'a bi. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Álahua làbi nuá ná la'yáni'a, sino bìta bi para quixá'a bi qui' la'yáni'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Porqui'ni Enne' ná la'yani' lí gánia nna runne la'yani' qui' iyábani ca enne'. Lèe nna gul·lanie le' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Gurènie le' yétsiloyu nu benie, pero yétsiloyu nna labí benibí'ą ne. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Bitée gurènie entre ca enne' quì'e nna labí beni cą ne recibir. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero iyaba canu beni cą ne recibir de ríalatsi' quį quì'e nna, betie derecho qui' quį para cca cą ỹi'ni Tata Dios; ");
INSERT INTO zaaNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","pero álahua por medio de réni, nìhua tì' ràlia ca enne' yétsiloyu, nìhua por la' calatsi' qui' ttu nubeyu' nna, sino Dios la nna née Tata qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tìtsa'a nna guỹi'e forma de ènne'yu' nna, gurènie entre ri'u. Intu' nna bilá'ni tu' la'yani' quì'e nna ca milagro nu benie nna, tì' tegáláa tùteruba Ỹi'ni Tata Dios. Uccue enne' de puro taá favor, ą'hua gutixe'e titsa' lígani nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juáan nna gutixa'a bi nu ná lí acerca de lèe, gunne bi idìtsa nna ra bi: Bitola de inte' nna íl·lani ttu enne' adiru dacca' tì'chu inte', porqui'ni antes càla galia' nna chìlá dúe. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Iyaba ri'u nna bànini ri'u de itute la'huacca quì'e; runie ri'u favor lani adí favor nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tata Dios nna betie ley quì'e lani ca enne' chi gùtse'e por medio de Moisés. Pero favor quì'e lani ri'u ą'hua evangéliuį nna gul·lani cą por medio de Jesucristua. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Jamás lanú nuỹa ènne'ni le' yétsiloyu chi bilá'nią Tata Dios. Tùteruba Ỹi'ni áa enne' dua cuitta' áa, làbi nna chi beni bi e declarar lani ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Guthel·la' canu rigú'ubia' entre ca enne' judío qui' Jerusalén tuchùppa ca sacerdote qui' quį lani ca descendiente qui' Leví ru'a lo Juáan para inàba titsa' cą bi nuỹa ná bi. Juáan nna gutixà'a bi nu ná lí, ");
INSERT INTO zaaNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","labí becàttsi' bi titsa', sino claru taá gutixà'a bi nna ra bi: Álahua inte' nuá Cristua. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Gunàba titsa' cą bi attu nna ra cą: Núlá nì'i. Tsí cuią'lu' Elías acca. Ra tè bi: Labí ná'. Tsí cuią'lu' profeta enne' ná qui'ni ìta inne parte Tata Dios acca. Becàbi bi nna ra bi: Labí. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Accana ra cą bi: Pues, núlá ná cuią'lu' nì'i, para qui'ni equixá'ani tu' canu guthel·la' cą intu'. Biala ra cuią'lu' qui' la'a mísmuba cuią'lu' nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juáan nna gunne bi idìtsa nna ra bi: Inte' nna daya' para gunia' predicar al aire libre taá. Lítsé'e leda porqui'ni chi dá' Señor. Porqui'ni anía gutixà'a Isaías enne' uccua profeta tiempo antigua. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Canu huía mandádua nna uccua cą nu la'a mísmuba religión qui' ca fariséua. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Beni ba cą seguir gunàba titsa' cą Juáan nna ra cą: Bialácca runi cuią'lu' bautizar ca enne' canchu álahua cuią'lu' nuą' Cristo, nìhua Elías, nìhua profétaá nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Becàbi tè Juáan nna ra bi cą: Inte' nna runia' bautizar lani inda. Pero entre lebi'i bá chi du ttu enne' labí nabia'ni le, ");
INSERT INTO zaaNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","là ènni'į ènni'ą' ná qui'ni il·lani bitola de inte', pero antes càla inte' nna chìlá dúe. Nìdiruba làa dàcca'a' para ithátsia' correa qui' guarachu quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ca cosį nna uccua cą le' región qui' Betábara attu ládulá yò Jordán làti begàdia Juáan ca enne' inda. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Attu yu'utsá nna bila'ni Juáan qui'ni dia Jesús làti du bía. Gunne tè bi nna ra bi: Nì da' Jesús enne' ná Carnéroto' qui' Tata Dios para quée sacrificar nna, enne' cúa ca tul·la' qui' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Qui' ènni'į nuá gutixà'a' loti' nia': Bitola de inte' nna íl·lani tu ènne'yu' adiru dàqque'e tì'chu la inte', porqui'ni ántesca galia' nna chìlá dúe. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Inte' nna labí bennia' cuenta nuỹa née, pero para qui'ni quée presentar ru'a lo ituba yetsi Israel, acca inte' nna daya' runia' bautizar lani inda. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juáan nna gùnneé ruhuá bi adí nna ra bi: Bilá' te' qui'ni Espíritu Santo nna huàdie de ỹiabara' tì'ba ttu becha to' nna gùdue íqquie. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Labí bennia' cuenta nuỹa née, pero enne' guthel·le'e inte' huèni bautizar lani inda, lèe nna rèe inte': Enne' ilá'ni lu' chadi Espíritu thúe íqquie nna, là ènni'ą' nuá guni bautizar lani Espíritu Santo. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Inte' nna bilá' ti' e nna riquixà'a' qui' Enni'į nuá hualigani née Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Attu yu'utsá nna du Juáan attu vuelta lani chuppa ca discípulo qui' bía. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Bilá' tènì cabi qui'ni dia Jesús nía, acca gunne tè Juáan nna ra bi: Nì da' Jesús enne' ná Carnéroto' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Biyeni báni chuppa ca discípulo qui' Juáan nu ra bi nna tanó tè cabi Jesús nna, ");
INSERT INTO zaaNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","bedèqquia tè lo Jesús nna bilá'nie qui'ni denó cabi e, acca rèe cabi: Biani reyìla le. Becàbi tè cabi nna ra cabi e: Maestro, gani dua cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ra tìe cabi: Lítaáruhuá inna' le. Huía tè cabi lani e nna bila'ni cabi làti dueáa. Tsá lània nna nía ba beyà'na cabi, porqui'ni chi ral·la. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrés bettsi' Simón Pedrua nna uccua bi ttu canu chuppa biyénini cabi nu ra Juáan nna tanó tè cabi Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Primérute Andrés nna betseláni bi bettsi' bi Simóą nna ra bi: Chi bila'ni tu' enne' ná qui'ni ìta para gudilèe ri'u, quiere decir Cristua enne' ribèda ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrés nna guche' tè bi bettsi' bía ru'a lo Jesús. Bila'ni Jesús bi nna rèe bi: Lu' ná lu' Simón ỹi'ni Jonás, pero gata' láa lu' Cefas. Cefas nna quiere decir Pedro. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Attu yu'utsá nna beni Jesús disponer tsíe Galilea. Yù'u bée néda nna bettsà' tìe Felipea nna ra tìe bi: Gutà, tanó inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felípea nna uccua bi ttu enne' Betsaida, yetsi qui' Andrés nna Pedrua nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felípea nna huía bi làti dua Natanael nna ra bi: Chi bila'ni tu' enne' ga'na escrito nu cca quì'e lo ley nu bedia Moisés, ą'hua lo ca libro nu bedia ca profeta nna: Jesús ỹi'ni José, enne' Nazaret. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ra tè Natanael bi: Tsí ína ri'u Nazaret la iria tsagá ttu enne' tsè' cá. Ra tè Felípea bi: Gutà tsáruhuá inna' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Loti' Jesús nna bila'nie Natanael qui'ni dia bi làti dùe nna, gùnnie qui' bi nna rèe: Nì da' ttu nu hualigani ną́ enne' Israel nu labí beỹia té lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael nna ra tè bi e: Gani benibia' cuią'lu' inte'. Becàbi Jesús nna rèe bi: Antes càla gaỹi Felípeą' lu', loti' dù lu' ỹà yexxuhuía nna, bilá' te' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael nna ra tè bi e: Maestro, cuíą'balu' ná Ỹi'ni Tata Dios, ná huá cuią'lu' rey qui' yetsi Israel. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús nna rèe bi: Tsí porqui'ni pá'a' lu' qui'ni bilá' te' lu' du lu' ỹà yexxuhuía acca ríalatsi' lu' cá. Pues, adírulá ca milagro xeni tì'chula ca nui chì' ilá'ni lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Raáruhuée: Hualigani te' nia' le, qui'ni dèsdeba anna para nu chì' da'la nna ilá'ni le yalia ỹiabara'; ą'hua ca ángel qui' Tata Dios tsappi chadi cabi nna itsina' cabi iqquia Nubeyu' de Ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tsunna ubitsa bitola de lània nna uccua ttu thá'a le' yetsi Caná qui' Galilea. Nàna qui' Jesús nna re' tè bi nía. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Beni huá cą invitar Jesús lani ca discípulo qui'áa thá'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chi bebitsi vino qui' caniá, acca nàna qui' Jesús nna ra bi e: Vino reyàtsa qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús nna rèe bi: Biecca ra lu' inte' ą́', niula. Labí chi gùl·la' hora quia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nàna qui'áa nna ra tè bi canu tsè'e mandádua: Iyate nu íneé nna guni le. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nía nna dàa xùppa ca yethu' nu de íyya para inda nu ruquina' ca enne' judíua para eyacca nàrìni cą según bá costumbre qui' quį. Ttu ttu ca yéthu'a nna ùccuaní ttú chuppa o tsunna tì'ga ré'è inda lè'e quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús nna rèe cą: Líúditsa' ca yéthu'į inda. Làcą nna beditsà' tí'ní cą ca yéthu'a inda. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Làniana rèe cą: Annana ligàppi' ą nna tahua' tè le tí'to' gunìxi nu ná encargado qui' fiéstį. Làcą nna aníabá beni cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nu ná encargado qui' fiéstaá nna de benìxią indaá nna chi ną́ vino. Nìdi làa yùą gáỹalá taxi' cą vínuá, sino làteruba canu runi mandádua hua yù cą porqui'ni làcą nna gutàppi' cą indaá. Lą nna gutàỹia nubeyu' nu ruttsaná'a nna, ");
INSERT INTO zaaNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","rą na: Iyaba ca enne' nna rigá'a cą yà'latè vino tsè' nna ri'ya díbá canu nàỹi iỹeni vino nna, lànialá rigá'a cą nu huaỹia' bá ná tsè'. Pero lu' nna gutua bá lu' vino tsì'į para bitola. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Primero milágruį nna beni Jesús le' yetsi Caná qui' Galilea nna belui'e la'huacca quì'e de ỹiabara'. Ca enne' ruthète'niáa nna huíalatsi' cabi e. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Guttè díbá thá'a nna betsina' cabi yetsi Capernaum: lèe nna nàna qui'áa nna ca bettsi' áa nna ca discípulo qui'áa. Níabá gutsé'e cabi tuchùppa ubitsa to'. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Chì' tegáabá debiga' fiesta qui' ca enne' judíua nu reya cą pascua nna, huía Jesús Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nía nna bilá'nie canu tsè'e huètti' ca gù'na l·le ca carnero l·le ca becha l·le ą'hua canu ritsìla bel·liu, iyaba cą nna ỹùa cą le' templua. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Beni tìe ttu cuarta nu de yéti nna bebèqquie iyate cą fuera templua tsà'tsela tehuá ca gù'na qui' quį l·le, ca carnero qui' quį l·le. Ą'hua berìxie ca meỹa qui' canu ritsìla bél·liuá nna bèthitìnnianie bel·liu qui' ca niá loyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ra tìe canu rutti' cą becha: Lícua ca nui nì nna, alàa yú'u làti cca í'yya lá guni le litsi' Tata quí'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Làniana bexa latsi' ca discípulo qui'áa làti ga'na escrito nna ra: De tántuani amor té quia' por litsi' cuią'lu' nna, Labí dejar gunia' qui'ni bìcca'áỹa guni cą nì. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Làniana gunne tè ca judíua nna ra cą ne: Biani milagru ni ccani lu' guni lu' para ilá'ni tu', prueba de qui'ni té derecho qui' lu' de ỹiabara' acca runi lu' ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Becàbi Jesús nna rèe cą: Líútappa' templuį nna làniana le' tsunna ubitsa teruba, elítha ya' ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ra tè ca judíua ne: Le' chua' xùppa ida gutsé'e cabi beni cabi templuį, atsi'íni lu' nna da' tè lu' ína lu' qui'ni le' tsunna ubitsa teruba elítha lu' ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero templo nu beni Jesús tratar nna, la'a nu cca qui' cuerpo qui'áa bá nuá rèe anía. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Acca, loti' beyáthee bitsa tsunnáa de lo lù'uti nna, bexalatsi' ca discípulo qui'áa qui'ni rèe nui nna huíalatsi' cabi nu ra lo Escritura ą'hua ca titsa' nu gunènie cabi. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Loti' gùl·la' fiesta nu láa pascua nna, chi re' Jesús le' Jerusalén. Iỹetse' ca enne' de bila'ni cą ca milagro nu beni áa nna huíalatsi' quį qui'ni née Cristua. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero Jesús nna labí confianza gá gùppee cą, porqui'ni hua nabia' bánie iyaba cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nìhua labí necesidad gùdue qui'ni nuỹa quixá'anią ne nu cca qui' ca enne'; pues la'a mísmuba lèe nna hua yù bée ti'iỹa ná la' rulábalatsi' qui' ttu ttu tsa quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Gùdua ttu nubeyu' láą Nicodemo, denúą religión fariseo. Lą nna uccuą ttu enne' principal de lo iyaba ca enne' judíua. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nicodémua nna huíą de réla lá ru'a lo Jesús nna rą ne: Maestro, yù tu' qui'ni Tata Dios nna guthel·le'e cuią'lu' para gulue'ni cuią'lu' intu' enseñanza, porqui'ni lanú nuỹa ccani guni ca milagro luetsi canu runi cuią'lu' canchu lanú Tata Dios runie na cualani. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Becàbi Jesús nna rèe na: Hualigani te' nia' lu': Nuỹa díbá ttu enne' canchu labí galią attu nna, entonces nunca labí ilá'nią ti'iỹa tsè' ná la' rigú'ubia' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodémua nna rą ne: Ti'ani modo galia ttu enne' attu de chi ną́ enne' gula nì'i. Tsí huacca éya'ą attu vuelta le' nàna quì'į para galią attu cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Becàbi Jesús nna rèe na: Hualigani te' nia' lu': Nu labí galią de inda nna Espíritu nna, entonces nunca labí gá'ą le' reino qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Canu nàlia por medio de enne' ba nna, pues cuerpo material bá ná cą, pero canu nàlia por la'huacca qui' Espíritu Santo nna, làcą nna ná cą enne' espiritual. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Acca bittu caỹílatsi' lu' qui'ni pá'a' lu': Iyaba le nna náduel·la' galia le attu. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Por ejemplo: be' nna gaỹa tediba rittią nna riyeni terúbáni lu' tsì'į, pero labí yù lu' gaỹa la dá'ą nìhua gaỹa la díą nna. Ą'ba ná iyaba canu nàlia por la'huacca qui' Espíritu Santo, labí ritelíni cą ti'iỹa la modo ràlia cą attu. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Becàbi Nicodémua nna rą ne: Ti'ani modo ccá nui cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Becàbi Jesús nna rèe na: Maestro nua' ná lu' qui' ca enne' Israel nna, tsí bihua nabia'ni lu' ca cosį cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Hualigani te' nia' lu': Nu yù ri'u nna, lànuá rinne ri'u. Nu chi bila'ni ri'u nna, lànuá ribèqquiali ri'u. Pero lebi'i nna labí ríalatsi' le nu riquixá'a tu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Chi gutixa'ánia' le ca cosa fácil qui' yetsiloyu ba, pero labí ríalatsi' le. Ti'ala modo tsíalatsi' le canchu quixa'ánia' le ca cosa qui' yíabara' cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Lanú nuỹa chi huàppi ỹiabara', sino Enne' huàdi lá de ỹiabara' nna née Nubeyu' de Ỹiabara'; lèe nna dúe ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ti'ba Moisés betaá' bi ttu bèl·là nu de metal lo ttu yà nna guchìtha bi ą rá' loti' tsè'e cabi le' desiértua; ą'hua caduel·la' qui'ni Nubeyu' de Ỹiabara' nna ichìtha cą ne lo ttu yà, ");
INSERT INTO zaaNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","para qui'ni iyaba canu tsíalatsi' quį ne nna labí nitti cą sino qui'ni gata' la'labàni nu labí ttíą qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Porqui'ni yala telá catsi'íni Tata Dios ca enne' tsè'e yétsiloyu, acca guthèl·le'e ttu teruba Ỹi'ni áa, para qui'ni nuỹa tediba tsíalatsi'į ne nna labí nittią, sino qui'ni gata' la'labàni nu labí ttíą quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Porqui'ni Tata Dios nna labí guthèl·le'e Ỹi'ni áa para gunie condenar yétsiloyu, sino para qui'ni yétsiloyu nna ccá lą́ salvo por lèe. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nu ríalatsi'į Ỹi'ni Tata Dios nna labí té castigo quì'į; pero nu labí ríalatsi'į ne nna, chi ną́ destinado para ccą́ castigar porqui'ni labí nì'i tsíalatsi'į tùteruba enne' ná Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nui nna ną́ razón de qui'ni hua té condenación: qui'ni gul·lani la'yáni'a yétsiloyu, pero ca enne' nna adila guyú'u latsi' quį la'chul:a tì'chula la'yani', porqui'ni yala tul:la' beni cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iyaba ca enne' canu runi mal nna labí cca guyu cą la'yani', nìdi làa ribiga' cą le' la'yani', para qui'ni làa ilá'ló iyaba ca mal nu runi cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero ca enne' canu runi ba de acuerdo lani nu ná lí nna, pues làcą nna ribiga' cą le' la'yani', para qui'ni ilá'ní qui'ni ca obra qui' quį nna ná cą de acuerdo ba lani voluntad qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Guttè díbá nuá nna huía Jesús lani ca discípulo qui'áa para región qui' Judea. Níabá nna gutsé'e cabi tuchùppa ubitsa huèni ca enne' bautizar. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juáan nna beni huá bi bautizar, ttu lugar láą Enón cuitta' taá attu lugar láą Salim, porqui'ni iỹenitsè' inda yù'u nía. Ca enne' nna huía tè cą uccua cą bautizar. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nui nna uccua ántesca gudàl·la cą Juáan litsi' ìyyà. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Làniana ca discípulo qui' Juáan nna beni cabi discutir lani ca judíua acerca de ca costumbre qui' quį para eyacca nàrìni cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Huía tè cą ru'a lo Juáan nna ra cą bi: Maestro, tsí hua yù cuią'lu' qui'ni enne' du lani lu' biỹa tsá nuá attu lado yò Jordán nna, gutixa'a huá lu' nu cca quì'e, pues annana ría iyaba ca enne' ru'a lo bi nna runi huá bi cą bautizar. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Làniana Juáan nna ra bi cą: Ttu enne' nna, labí biỹa runią recibir canchu làhuabi ną́ por voluntad qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","La'a mísmuba lebi'i chi biyénini le loti' nia': Álahua inte' nuá Cristo, sino qui'ni huenitsìna teruba ná' nna guthèl·le'e yà'la inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Le' ttu thá'a nna du ènne'yu' nu ná novio lani novia qui' bi. Amigo qui' nóvioá nna du bą́ cuitta' bi nna rudà nàgui'į rinne bi nna yala redácca'nią. Ą'hua inte' annana yala la' redacca' latsi' chi té quia' de riyeni te' rinnie. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Lèe nna caduel·la' quée adiru enne' ỹeni le' yétsiloyuį; pero inte' nna eyàttsi' lá la' dàliani quia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Enne' da' de ỹiabara' nna adiru dàqque'e de lo iyábani; pero nu da' ba de yétsiloyu nna, nu yétsiloyu ba ną́ ą'hua nu cca qui' yétsiloyu ba rinnią nna. Pero Enne' da' de ỹiabara' nna née enne' bána'ni iyábani. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Lèe nna riquixé'e nu bila'nie nna nu biyéninie nna, pero lanú nuỹa rudà nàgui'į nu riquixé'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero nu ríalatsi' nu riquixé'e nna, lànua nna runią reconocer qui'ni Dios nna siempre rinnie nu ná lí. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Porqui'ni Enne' guthel·la' Tata Dios nna, pues ca titsa' qui' Tata Dios ba rinnie, porqui'ni alàa lani medida ba betie la'huacca qui' Espíritu Santo lanie, sino itute. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tàtaa nna catsi'ínie Ỹi'ni áa. Iyábani ca cosa nna chi betie cą latsi' né'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nu hualigani ríalatsi'į qui' Ỹi'ni áa nna, chi té la'labàni nu labí ttíą quì'į. Pero nu labí ríalatsi'į qui' Ỹi'ni áa nna, entonces labí gata' la'labàni quì'į, sino qui'ni castigo qui' Tata Dios nna seguru bá íl·lanią lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Guteli bani Señor qui'ni ca fariséua nna chi bina cą qui'ni lèe nna adila iỹé ca discípulo quì'e chi ná ą'hua adila ca enne' runie bautizar tì'chula Juáan, ");
INSERT INTO zaaNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","màsqui'ba álahua Jesús tè beni bautizar, sino ca discípulo qui'áa bá. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","De uccue saber nui nna, acca beria tìe le' región qui' Judea nna huíe attu vuelta para Galilea. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Para etsìne'e nía nna uccua duel·la' ttíèe néda nu día para Samaria. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Bitsina' tìe le' ttu yetsi to' láą Sicar le' región qui' Samaria, ru'a loyu qui' tà' Jacob nu beda' latsi' bi bete bi qui' ỹi'ni bi José enne' gùdua tiempo antigua. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nía nna re' ttu pozo inda nu gulèqquia ta' Jacob. Jesús nna de tántua reyàtsanie yu'ée néda nna, acca gure' teníe bedi' latsi'e ru'a pózua. Ttú tsì'nu hora ti'gá nuá. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Làniana bitsina' ttu niula enne' Samaria díą guỹi' inda ru'a pózua. Jesús nna ra tìe na: Benna tí' inda i'ya'. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ca discípulo qui'áa nna día cabi le' yétsiá huì'i nu go cabi. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Niula samaritánaá nna rą ne: Ti'ani modo acca rinàbani lu' inte' inda, yà'ni qui'ni ná lu' enne' judío, inte' nna niula samaritana nì'i. Anía ra niuláa porqui'ni ca enne' judío nna canu samaritano nna labí cca guyu luetsi quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Becàbi Jesús nna rèe na: Cáalá nabia' tsànì lu' nu ỹá rúnna ba Tata Dios ą'hua nuỹa ènni'į nua' rèe lu': Bènna tí' inda i'ya'; pues lu' lá inàbani lu' e inda, lèe nna gúnnée inda bàni tegání qui' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Niuláa nna ra tìą ne: Señor, labí biỹa dèni lu' para cueqquia lu' indį, ą'hua pozuį nna itéttia tsè' ri'ą. Gala taxi' lu' inda bàni para gunna lu' quia' cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tsí ína ri'u adila enne' ỹeni ná lu' tì'chula ta' tàta qui' tu' Jacob enne' gulèqquia pozuį nna bethà'na bi ą lani intu' cá. Nì bá gù'ya bi inda, ą'hua ca ỹi'ni bi nna ca gù'na bia' qui' bi nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Becàbi Jesús nna rèe na: Nuỹa tèdiba í'yą inda nu da' le' pozuį nna, ibìtsi bą́ attu, ");
INSERT INTO zaaNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","pero nu í'yą inda nu gutía' quì'į nna, para siempre labiru ibìtsią; sino qui'ni inda gutía' quì'į nna ccá lą́ lo lòstu'į tì'a ru'a ttu chorro làti ril·lani tì'tìni inda para la'labàni nu labí ttíą quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Niuláa nna ra tìą ne: Señor, benna cuią'lu' indą' quia', para qui'ni bíttúru ibìtsia' nìhua làa ìta rùa' nì guỹi' inda nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús nna rèe na: Beyya tal·luítsa' tsèla lu'a nna, ìta tè lu' nì gunna' indį qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Becàbi niuláa nna rą: Lanú tsèlàa' té. Jesús nna ra tìe na: Hualibani lu' lanú tsèla lu' té. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Porqui'ni gayu' tsèla lu' chi gutsé'e, pero nu dualàni lu' annana labí ną́ tsèla lu', acca hualibani lu' nu ra lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Niuláa nna ra tìą ne: Señor, tì' cca te' nna ná cuią'lu' enne' rinne parte Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ca ta' tàta qui' tu'a nna beni cabi adorar Tata Dios lo i'ya dua nì, pero lebi'į nna rena le qui'ni le' Jerusalén teruba ná qui'ni tsía ca enne' huèni e adorar. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús nna ra tìe na: Niula, huíalatsi' lu' quia', qui'ni huàl·lani tsá canchu chi nìhua lo í'yį nìhua le' Jerusalén nna guni le Tata Dios adorar. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Lebi'i ca enne' samaritano nna yala adorar runi le, pero labí nabia'ni le Tata Dios. Intu' ca enne' de raza judío nna runi tu' e adorar nna nabia'ni tu' e porqui'ni enne' gunna salvación nna dé'e entre ca enne' judío. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pero huàl·lani tsá nna, ą'hua chi gùl·la' hora qui'ni canu hualigani calatsi' quį guni cą Tata Dios adorar, pues guni cą ne adorar lani itute espíritu qui' quį nna de acuerdo ba lani nu ná lí nna. Porqui'ni Tata Dios nna reyìlée ca enne' luetsi ca nua' para guni cą ne adorar. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios nna labí née biỹa cosa material qui' yétsiloyuį; acca canu calatsi' quį guni cą ne adorar nna, ná qui'ni guni cą ne adorar lani espíritu qui' quį nna de acuerdo ba lani nu ná lí. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Niuláa nna rą ne: Yúá' qui'ni huàl·lani Cristo enne' ribèda tu' qui'ni itée para gudilèe intu', canchu chi íl·lanie nna quixá'anie intu' claru taá iyábani ca cosa. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús nna ra tìe na: Inte' Cristo rui'a' lani lu' titsa'. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Làniana betsina' tè ca discípulo qui'áa nna uccuaỹí bá latsi' cabi qui'ni rui'e titsa' lani ttu niula samaritana. Atsi'íni ni ttú cabi labí beyáỹani cabi inàba titsa' cabi e ína cabi: Biani nua' calatsi' niulą', o biani titsa' ní nua' rue' cuią'lu' lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Làniana bethà'na niuláa ré'è qui' niá nna deyyą le' yétsiá taquixá'anią ca enne' nna rą cą: ");
INSERT INTO zaaNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Lítaáruhuá inna' le ttu ènne'yu' chi rèe inte' iyaba nu chi benia'. Xiaba canchu lèe ènni'ą' Cristua enne' ribèda ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ca ènni'a nna biria tè cą le' yétsiá nna gùdulo cą huía cą làti du Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pero miéntraste nna ca discípulo qui'áa nna gutta'yúni cabi e nna ra cabi e: Maestro, gutò tí' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Lèe nna rèe cabi: Té bá ttu la'gò quia' gúá'; lebi'i nna labí yù le biỹa nua'. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Làniana ca discípuluá nna ra luetsi cabi: Tsi alàa nuỹa chi tahua' nu gúe. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús nna rèe cabi: La'gò quia' nna ną́ qui'ni guni ba' voluntad qui' enne' guthèl·le'e inte' nna gul·lúỹa'a' nu rèe gunia' nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tsí álahua rena le qui'ni hua reyàtsaáru atàppa biú' para eỹu' lena' cá. Pero inte' nna nia' le: Linna'áruhuá qui'ni chi da' attu cosecha huaya', chi ną́ listo para eỹù'ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Enne' yù'u tsina huetùppa cosecha nna ridi' huá laỹa bi lena', pero lena' nu rutùppa bía nna ná lą́ para la'labàni tulidàni, para qui'ni enne' rada nna edacca' huáni bi tì'ba enne' redi' coséchaá. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Anía nna cca cumplir ttu dicho ra: Ttu enne' huaya' rada, pero attu enne' huaya' rutùppa lena'. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Inte' nna chi guthél·la'a' le para édi' le cosecha làti álahua lebi'i gùda, sino ca enne' huaya' ba beni tsina; lebi'i nna bitsina' tè le huetùppa cosecha. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Iỹetse' ca enne' le' yetsi Samaria huíalatsi' quį qui'ni Jesús ènni'ą' Cristua por ca titsa' qui' niuláa, porqui'ni betią testimonio nna rą: Chi gutixa'ánie inte' iyaba nu chi benia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bitsina' tè ca enne' Samaria ru'a lúe nna gutta'yúni cą ne qui'ni cuédée tuchùppa ubitsa lani cą. Acca gulèda tìe nía chuppa ubitsa. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nuỹétse'éru ca enne' huíalatsi' quį de rudà naga' quį quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Làniana ra tè cą niuláa: Annana chi ríalatsi' tu', álaárulá por ca titsa' nu chi ra lu' intu', sino porqui'ni la'a mísmubani intu' nna chi biyénini tu' titsa' quì'e nna chi yù tu' qui'ni ènni'į nna hualigani née Cristo Salvador qui' itute yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Gutè díbá chuppa ubitsa nna beria Jesús nía nna huíe Galilea, pero alàa hasta látsie Nazaret, ");
INSERT INTO zaaNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","porqui'ni la'a labée nna gutixè'e qui'ni labí ruyu tsè' ca enne' ttu profeta nu látsi quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bitsina' bée Galilea nna, ca enne' galiléua nna tsè'ba beni cą ne recibir porqui'ni chi bila'ni cą iyaba nu benie le' Jerusalén loti' gùl·la' fiéstaá, porqui'ni huía huá cą nía lània. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Làniana huía Jesús attu vuelta yetsi Caná le' región qui' Galilea làti benie qui'ni indaá nna uccuą vino. Le' yetsi Capernaum nna gùdua ttu nubeyu' uccuą capitán le' palacio qui' rey. Nu ná capitáan nna gùdua ttu ỹi'ni beyu'į yala fuerte huì'nią. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bina bą́ qui'ni Jesús nna bitsine'e Galilea dé'e Judéa lá nna, acca huía tìą ru'a lúe nna gutta'yúnią ne qui'ni tsíe eyúninie ỹi'ni niá, porqui'ni lo lù'uti taá chi tią. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Làniana ra tè Jesús na: Canchu bihua ilá'ni le ca milagro o biỹa prueba de la'huacca nu dacca' iquíla'ní latsi' le nna, entonces bihua tsíalatsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Becàbi nu ná capitáan nna rą ne: Señor, gutà xìa bál·la cuią'lu' ántesca gatti ỹì'ni ya'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús nna rèe na: Beyya ba, ỹi'ni to' qui' lu'a nna huaccabàni bą́. Nubeyu'a nna huía tàa latsi'į titsa' nu ra Jesús na, deyya tìą. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Néda ba deyu'ą́ nna, tattsa' ca mozo qui' niá na nna bete cą noticia tsè' lani ą nna ra cą: Ỹi'ni cuíą'lu'a nna chi beyacca latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Gunàba titsa' taą́ cą biỹa hora gùdulo beyacca latsi'į. Ra tè cą na: Ritį ttu tì'ga nàyaá nna berią ỹìl·láa. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Làniana gutelíni tàta qui' nubeyu' cuìti' rà'nia qui'ni méruání hóraá nuá ra Jesús na: Ỹi'ni to' qui' lu'a nna bàni bą́. Làniana adila huíalatsi'į Jesús, ą'hua iyaba canu tsè'e le' litsi'į nna huía huá latsi' quį qui'ni née Cristo. ");
INSERT INTO zaaNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Milágruį nna beni Jesús loti' gude'e le' región láą Judea nna huíe para Galilea. Nui nna uccua chuppa prueba nu benie nna belue'ní qui'ni té la'huacca quì'e de ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Gutè díbá nuá nna huía Jesús Jerusalén loti' gùl·la' ttu fiesta qui' ca judíua. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ru'a ciudáad èxabá làti du ttu puerta rittè ca carnéruá nna, re' ttu tanque nu láą lani titsa' hebreo Betesda. Ita'lùba tánqueá nna dàa gayu' corredor. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nía nna anta' nuỹé tsè'ni canu ra'ni; ca ciego l·le ca cojo l·le, ca paralítico l·le, ribeda cą qui'ni echìxi luetsi indaá. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Porqui'ni ttu ángel nna hua ràdì ỹégáabá bi làti re' tánqueá ruchixi bi luetsi indaá. Nùỹadiba radi yà'la tè le' tánqueá bitola de bechixi luetsi indaá nna, reyacca taá latsi'į de biỹa tediba itsahue' ní ra'nią. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nía nna re' ttu nubeyu' chi uccua tsiỹúnu' érua' ida ra'nią. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Bilá' báni Jesús na tią nía nna, gutelí taánie qui'ni chi gutsá ridácca'ą anía, acca rèe na: Tsí hua calatsi' lu' eyacca latsi' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Becàbi nu rà'nia nna rą ne: Làchu Señor, pero lanú té quia' nuỹa gúga'ą inte' le' tánquį canchu chi rechixi luetsi indį; porqui'ni dácá' telá ribíga'a' nna, pues attu nu huaya' lá nna ra'a chilą́ antes de inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús nna rèe na: Beyátha nna, bedi' tá'à qui' lu'ą' nna gùdà'. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Luégu taání nna beyacca chì latsi' nubéyu'a nna, betètsi tìą tá'à qui' niá nna benìtta'ą nna deyya tìą. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Làniana ca judíua nna ra cą nu beyacca latsi' niá: Labí ná qui'ni éyua' lu' tá'à qui' lu'ą' qui'ni hua ná tsá redi' latsi' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Becàbią nna rą cą: Enne' beyunie inte' nna, la'a labée nna rèe inte': Bedi' tá'à qui' lu'ą' nna gùdà'. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Gunàba titsa' tè cą nna ra cą: Núní nuą' rą lu' ą'. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nu beyacca latsi' niá nna labí yùą nuỹa ènni'a beyunie na acca reda'ą, porqui'ni iỹétse'ní ca enne' tsè'e nía, ą'hua Jesús nna lanúrue té nía porqui'ni chi díe attu làti huaya'. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bitola nna bila'ni Jesús nubéyu'a le' templua nna ra tìe na: Annana chi beyacca latsi' lu', acca bíttuúru guni lu' tul·la', para qui'ni làa thacca' lu' biỹa attu cosa peor. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Deyya tè nubéyu'a nna gutixa'ánią ca judíua qui'ni Jesús bá ènni'a beyunie na. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Canu rigú'ubia' qui' ca judíua nna gùdulo cą betsia latsi' quį Jesús nna uccua latsi' quį gúttí cą ne, porqui'ni beyunie ca enne' rà'nia tsá ỹeni qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesús nna rèe cą: Tàta quí'a nna tulidàba runie tsina, acca ą'hua inte' nna runi huá' tsina ttu ttu tsá taání. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Por ca tìtsa'a nna adila bitsia latsi' ca judíua nna uccua latsi' quį gúttí cą ne. Porqui'ni álaárulá qui'ni làa gútueé tsá labí ná qui'ni guni cą tsina, sino porqui'ni rèe qui'ni Dios nna née propio gani Tàta quì'e, ti'batsi né tulappa lani Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Làniana becàbi Jesús nna rèe cą: Hualigani te' nia' le: Labí biỹa ccani Ỹi'ni Tata Dios gunie por la' calatsi' qui' bée, sino nu rilá' bánie runi Tata Dios ą'hua runie, porqui'ni iyaba nu runi Tatáa nna, aníahuá runi Ỹi'ni áa. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Porqui'ni Tatáa na yala catsi'ínie Ỹi'ni áa, ą'hua ruluè'nie Ỹi'ni áa iyábani ca cosa nu runie. Pero adírulá ca cosa de la'huacca ỹeni gulue'nie ne, hàstaá qui'ni lebi'i nna iquíla'ní latsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Porqui'ni tì'ba Tatáa rechìthee canu yatti nna rutie la'labàni qui' quį, pues ą'hua Ỹi'ni áa nna rute huée la'labàni qui' canu càba latsi'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Porqui'ni Tatáa nna lanú nuỹa runie juzgar, sino qui'ni latsi' ná' Ỹi'ni áa bá nna chi betie itute derecho para cueqquie sentencia qui' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Anía beni Tatáa para qui'ni iyaba ca enne' nna gudàliani cą Ỹi'ni áa tì'ba rudàliani cą Tatáa. Nuỹa tediba labí rudàlianią Ỹi'ni áa nna, nìhua Tatáa labí rudàlianią, porqui'ni làbe nna guthèl·le'e enne' ná Ỹi'ni áa. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Hualigani te' nia' le: Nuỹa tediba riyéninią titsa' quíyi'į nna ríalatsi'į Enne' guthèl·le'e inte' nna, chi té la'labàni nu labí ttíą quì'į; ą'hua labí da' juicio quì'į, sino chi gulàą de lo lù'uti nna bànią. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Hualigani te' nia' le: Huàl·lani tsá nna, chi gùl·la' hora qui'ni canu yatti nna iyénini cą tsì'i Ỹi'ni Tata Dios. Canu iyénini cą quì'e nna ccabàni cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Porqui'ni tì'a Tatáa nna bànie por la'huacca qui' la'a labée, pues ą'hua chi betie qui' Ỹi'ni áa la'a mísmuba la'huacca para gunie disponer qui' la'a la'labàni qui'bé. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ą'hua betie latsi' né'e derecho para cueqquie sentencia qui' ca enne', yà'nì qui'ni née Nubeyu' de Ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Bittu ccaỹí latsi' le por nui; porqui'ni huàl·lani tsá canchu chi iyábani canu anta' le' yerubà nna iyénini cą tsì'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Canu beni nu ná tsè' nna, eyátha cą de lo lù'uti para la'labània; canu beni mal nna eyátha huá cą, pero para condenación. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Labí cca te' biỹa gunia' por nu cca quíbá'; sino runia' juzgar según nu rinèni Tatáa inte', ą'hua lù'uxtícia quia' nna hua ną́ según nu ná lí, porqui'ni labí rudúa iqquia' gunia' nu càba látsa'a', sino qui'ni runia' según bá tì' rú'ulatsi' Tatáa enne' guthèl·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Porqui'ni inte' nna riquixá'a' nu cca quíbá', acca rena le qui'ni nu riquixa'a' nna labí ną́ nu lí. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero hua dua attu enne' riquixe'e nu cca quia', inte' nna yúá' qui'ni nu riquixe'e acerca de inte' nna ną́ lígani. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Lebi'i nna guthel·la' le ca enne' qui' le ru'a lo Juáan para inàba titsa' cą bi acerca de inte'. Làbi nna nu lí taá gutixa'a bi. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Álahua porqui'ni riquina' te' qui'ni nuỹa ttu enne' le' yétsiloyuį quixa'ą a favor de inte' para ccá' valer, sino ruréxa'a' latsi' le acerca de Juáan para qui'ni tsíalatsi' le nu gutixa'a bi nna l·lá le. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ca titsa' nu gutixa'a bi nna uccua cą tì'a la'yani' nu runna ttu lámpara. Lebi'i nna guyú'u bá latsi' le gudà naga' le qui' bi, pero por ttu tsàstito' teruba. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero inte' nna ccá huá' valer por ca obra nu beni Tatáa inte' mandado gunia'; la'a mísmuba ca obra nu runia' nna runna cą testimonio nu cca quia' lani adiru la'huacca tì'chu ca titsa' nu gutixa'a Juáan acerca de inte', prueba de qui'ni Tatáa nna guthèl·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ą'hua Tatáa enne' guthèl·le'e inte' nna, chi betie testimonio acerca de inte'. Lebi'i nna nunca labí chi biyénini le tsì'e, nìhua nì' ilá'ni le la' rinna' quì'e nna, ");
INSERT INTO zaaNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","nìhua titsa' quì'e labí té lo losto' le, porqui'ni lebi'i nna labí ríalatsi' le enne' guthèl·le'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Lebi'i nna lani cuidado tsè' hua rùl·là ba le Escritura porqui'ni calatsi' le gata' la'labàni nu labí ttíą qui' le. Atsi'íni màsqui'ba retseláni le làti riquixá'a nu cca quia', ");
INSERT INTO zaaNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","pero labí calatsi' le ibiga' le tsíalatsi' le inte' para qui'ni gata' la'labàni nu labí ttíą qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Bihua reyila' la' rudàliani qui' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pero inte' nna, hua nabia' ba te' ti'iỹa ná le, porqui'ni labí té la' tsì'ilatsi' qui' le lani Tata Dios lo losto' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Inte' nna daya' por mandado qui' Tata quíya'á, atsi'íni bihua ríalatsi' le quia'. Pero canchu íl·lani attu nuhuaya' por la' calatsi' qui'bíį nna entonces qui' nuá lá tsíalatsi' le cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ti'ani modo gappa le fe, pues la'a lebi'i ba nna rú'ulatsi' le gudàliani luetsi le, pero rudu lá le ttu lado la' dàliani nu da' qui' tùteruba Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Bittu ccani le qui'ni inte' nna ínnía' contra le ru'a lo Tatáa. Pues dua ba enne' rutsia falta qui' le; la'a mísmuba Moisés enne' ríalatsi' le nna, pues la'a labé nna rinne bi contra lebi'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Cáalá hualigani ríalatsi' le qui' Moisés nna, huiyya huá latsi' le quia'; porqui'ni nu cca quíbá' bedia bi. ");
INSERT INTO zaaNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero canchu bihua ríalatsi' le ca titsa' nu bedia bi nna, ti'ala modo tsíalatsi' le ca titsa' quíyi'į cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bitola de nuá nna, huía Jesús attu ladu indatò' qui' Galilea nu lá huą́ Tiberias. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Enne' ỹétse'ní tanó cą ne, porqui'ni bila'ni cą ca milagro nu benie de beyunie canu ra'ni. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Làniana huàppi Jesús lo ttu i'ya. Nía nna gurè'nie lani ca discípulo qui'áa. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Chì' taá debiga' tsá pascua, fiesta qui' ca enne' judíua. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Gunna' Jesús nna bila'nie qui'ni enne' ỹétse'ní dia làti ri'áa, acca ratìe Felipee: Gani gó'o ri'u ettaxtila para go iyaba ca ènni'į cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pero alàa porqui'ni labí yùe ti'iỹa gunie acca rèe anía, sino para guni bée Felipea prueba. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Becàbi Felipea nna ra bi e: Lani chuppa gayua' denario nna, labí ccání para gó'o ri'u ettaxtíla nna hué' ri'u ttu ttu tsa ca ènni'į ti'tó' tsàto'. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Attu discípulo qui' Jesús, lá bi Andrés bettsi' Simón Pedrua nna, ra bi e: ");
INSERT INTO zaaNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Nì du ttu nubeyu' cuìti' dènią gayu' ettaxtíla cebada, chuppa bél·la to' nna, pero biani gúnini ri'u nui lani ca enne' ỹétse'ní nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús nna ra tìe: Ligatsi ca ènni'ą' qui'ni xúaní cą. Anía rèe porqui'ni yala tacca' té nía nna, guỹua tení ca gayu' mili' tì'ga ca nubeyu' lo tácca'á. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Làniana guỹi' Jesús ca ettaxtílaá nna gunàbèe bendición lani Tata Dios, bete tìe lani ca discípuluá. Làcabi nna gutìthia cabi lani ca enne' ỹuàní lo tácca'á. Anía tehuá gutìthie ca bél·la nna. Gutò iyaba ca ènni'a tì'iỹaba ùccuàni qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","De beyacca gutò cą nna, làniana ra Jesús ca discípuluá: Liutùppa ca pedazo nu bexa para qui'ni bíttu tehuá biỹa cátittia. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bedi' tè cabi ca pedazo nu béxani ca ènni'a nna beditsà' cabi tsì'nu tsùmmithú de lo gayu' ca ettaxtílaá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bilá'báni ca enne' ỹétsi'á milagro nu beni Jesús, accana ra cą: Hualigani ènni'į ènni'ą' profeta enne' ná qui'ni ìta yétsiloyu, porqui'ni té la'huacca de ỹiabara' quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Gutelí báni Jesús qui'ni ca enne' nna uccua latsi' quį gudàxu' cą ne a la fuerza taá para guni cą ne rey; acca bede'e nía nna huíe attu lo i'ya la ttu terúbée. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Uccua bá yèlà nna beyàdi ca discípulo qui'áa lo í'yaá nna bitsina' cabi ru'a indatù'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Gutà'a tè cabi le' ttu barco nna, dia cabi rittè cabi lo indatù'a para itsìna' cabi Capernaum. Chi gùl·la nna atsi'íni lanú Jesús nì'i etsìna' lani cabi. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Làniana huàtha ttu be' fuértení nna, ridúlini lo indatù'a uccua. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ttu legua tì'gá chi guda' cabi lo indaá nna, de bila'ni cabi Jesús ride'e lo indatù'a díe para taỹenie barco nu yù'u cabía nna, yàlàni gutsini cabi. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero lèe nna rèe cabi: Inte' ba nui, bittu gátsini le. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Làcabi nna yala lani la' redácca' latsi' beni cabi e recibir le' bárcuá. Bárcuá nna luégutaá bitsina'ą ru'a loyu làti dia cabía. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Attu yu'utsá nna ca enne' tsè'erù attu lado la indatù'a nna bexa latsi' quį qui'ni lanuru attu barco du ru'a indaá, sino tùteruba barco to'. Hua yù bá cą qui'ni Jesús nna labí guté'e le' barcu tú'a lani ca discípuluá, sino qui'ni tsua' làteruba cabi deyya. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pero adí ca barco da' de Tiberias nna dàa cą èxaba làti gutò cabi ettaxtílaá bitola de gunàba Señor bendición. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ca ènni'a nna bila'ni cą qui'ni lanú Jesús té nía nìhua ca discípuluá nna, acca gutà'a cą le' ca bárcuá nna huía cą attu lado la para Capernaum tatìla cą Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Betselá báni cą ne attu lado la indatù'a nna, ra cą ne: Maestro, cuani gul·lani cuią'lu' nì. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Becàbi Jesús nna rèe cą: Hualigani te' nia' le qui'ni reyìla le inte', álahua por ca obra de la'huacca nu chi bila'ni le benia', sino porqui'ni bìà'cua bání qui' le gutò le ettaxtílaá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ligúni tsina, alàa por la'gò nu retu bá, sino por la'gò nu guchia nna gunna la'labani nu labí ttíą qui' le, nu gunna Nubeyu' de Ỹiabara' qui' le, porqui'ni lani labé chi bete Tata Dios la'huacca quì'e para gunie na. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Làniana ra cą ne: Biani dàni tu' guni tu' para ccá cumplir según nu rú'ulatsi' Tata Dios cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Becàbi Jesús nna rèe cą: Voluntad qui' Tata Dios nna ná íį: ná qui'ni tsíalatsi' le qui' enne' guthèl·le'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ra tè cą ne: Ti'ani modo tsíalatsi' tu' qui' lu' nì'i. Tsí guni lu' ttu prueba de la'huacca para ilá'ni tu' qui'ni té la'huacca qui' lu' de ỹiabara' nna tsíalatsi' tu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ca ta' tàta qui' tu'a nna bila'ni cabi ca milagro, pues gutò cabi ettaxtila de tsè'e cabi le' desiértuá, tì'a ra ttu lettia lo Escritura: Ettaxtíla da' de ỹiabara' betie gutò cabi. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús nna rèe cą: Hualigani te' riquixa'ánia' le: Álahua qui'ni Moisés bete ettaxtila nu da' de ỹiabara' qui' quį, sino Tata quí'a nna runne ettaxtila lígani nu da' de ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Porqui'ni ettaxtila nu runna Tata Dios nna née enne' huàdi de ỹiabara' nna rutie la'labàni qui' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ra tè cą ne: Señor, ttu ttu tsá taá bènna cuią'lu' ettaxtílą' qui' tu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Becàbi Jesús nna rèe cą: Inte' nua' ná ettaxtila nu runna la'labàni; nuỹa tediba tanúą inte' nna labiru túníą, ą'hua nuỹa tediba tsíalatsi'į inte' nna nunca làa ibìtsi rùą. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero chi pá'a' le qui'ni màsqui'ba chi rila'ni le inte' nna, pero labí ríalatsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Iyaba ca enne' runna Tatáa latsi' nàya' nna ril·lani cą lani inte'; nuỹa tediba íl·lani ru'a lua' nna, labí cueqquia ya' ą fuera. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Porqui'ni inte' nna daya' de ỹiabara', alàa para gunia' la' calatsi' quíbá', sino para guni lá' nu rú'ulatsi' enne' guthèl·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nui nna ną́ nu rú'ulatsi' Tatáa enne' guthèl·le'e inte': Qui'ni iyaba nu gúnnée latsi' nàya' nna, nìdi ttuą làa gúníttia', sino qui'ni echítha lá' iyaba cą de lo lù'uti canchu chi gal·la' último tsá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nui nna ną́ voluntad qui' Tata Dios enne' guthèl·le'e inte': Nuỹa tediba ínna'ą Ỹi'nie nna gappą confianza lani e nna, pues lą nna gata' la'labàni nu labí ttíą quì'į; inte' nna echítha ya' ą de lo lù'uti canchu chi gal·la' último tsá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Làniana gùdulo ca enne' judíua gunne cą contra Jesús porqui'ni rèe: Inte' ná' ettaxtila huàdi de ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ra tè luetsi quį. Tsí álahua nui nuą' Jesús ỹi'ni Joséą', pues hua nabia' báni ri'u tàta nàna quì'į. Ti'ala modo acca reną qui'ni de ỹiabara' la huàdią cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús nna ra tìe cą: Bíttuúru inne làna le quia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Lanú nuỹa ìta para tsíalatsi'į inte' canchu álahua Tata Dios enne' guthèl·le'e inte' táhue'e na lani inte'. Inte' nna echítha ya' ą de lo lù'uti canchu chi gal·la' último tsá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Escrítubá chi ga'na nu bedia ca profeta qui'ni: Iyaba ca enne' nna idète' cą por Tata Dios. Acca iyaba canu riyénini qui' Tatáa nna, qui'bée ridete' cą acca rìta cą lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Álahua qui'ni nuỹa ttu enne' chi bila'nią Tata Dios; sino làteruba enne' da' de làti dua Tata Dios, pues làbi nna chi bila'ni bi e. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Hualigani te' nia' le: Nuỹa tediba enne' ríalatsi'į inte' nna chi té la'labàni nu labí ttíą quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Inte' ná' ettaxtila nu runna la'labàni. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ca ta' tàta qui' lía nna gutò cą ettaxtíla to' láą maná loti' gutsé'e cą le' desiértuá, pero gùttì ba cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero inte' nna rìnnià' acerca de attu ettaxtíla nu da' de ỹiabara', para qui'ni nuỹa tediba go ettaxtílį nna labí gattią. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Inte' ná' ettaxtila nu runna la'labàni, huadia' de ỹiabara'. Nuỹa tediba gúą ettaxtilį nna tulidàni ccabànią. Ettaxtíla nu guté yì'į nna ną́ la'a mísmuba inte', porqui'ni gutia' cuerpo quia' para la'labàni qui' ca enne' tsè'e le' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Làniana huàdi ttu disgusto entre ca judíua nna ra cą: Ti'ani modo gunna nubéyu'į cuerpo quì'į go ri'u cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús nna rèe cą: Hualigani te' nia' le: Canchu labí go le cuerpo qui' Nubeyu' de Ỹiabara' nna í'ya le réni quì'e nna, entonces labí gata' la'labàni qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nuỹa tediba chi ną́ ttùba lani inte' de ruą cuerpo quia' nna ri'yą réni quia' nna, entonces chi té la'labàni nu labí ttíą quì'į; inte' nna echítha ya' ą de lo lù'uti canchu chi gal·la' último tsá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Porqui'ni cuerpo quia' nna réni quia' nna ná cą alimento nu hualigani runna la'labàni. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nu ro cuerpo quia' nna ri'yą réni quia' nna, ttùba chi ną́ lani inte', ą'hua inte' lani ą nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tata Dios enne' guthèl·le'e inte' nna bànie tulidàba; inte' nna bània' por medio de lèe. Ą'hua nuỹa tediba gunią inte' recibir ti'atsi ttu alimento para la' labàni quì'į nna, lànuá nna ccabànią por medio de inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nui nna ną́ ettaxtila nu hualigani huàdi de ỹiabara'; alàa tì'a ettaxtila láą maná nu gutò ca ta' tàta qui' lía, pero bì'yu tsá gùttì ba cą; sino nuỹa díbá gúą ettaxtíla nu runi yì'į ofrecer nna, para siempre ní ccabànią. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iyaba ca enseñánzį gutixa'a Jesús le' sinagoga qui' ca enne' Capernaum. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Biyeni báni nuỹetse' canu denó cą néa ca enseñánzaá nna ra cą: Yala tàbi ná ca titsa'ą', nuni ccani guchią cą cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Gutelí báni Jesús qui'ni biyeyya cą por nuá nna acca rèe cą: Tsí riyeni dí'ni le por nu níyi'į cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pues, tì'a telá guni le canchu ilá'ni le Nubeyu'a éyyeé ỹiabara' làti dúe néruá cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Álahua biỹa cosa material ní nua' runna la'labàni, sino Espíritu Santo ba ènni'ą' runi qui'ni gata' la'labàni espiritual qui' ca enne'; ca titsa' nu chi pá'a' le nna ná cą espíritu nna la'labàni nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero hua tse'éru entre lebi'i átuchùppa canu labí ríalatsi'. Anía ra Jesús, porqui'ni chìa yùe dèsdeba néruá nuỹa cą nuá labí huíalatsi', ą'hua nuỹa nuá gutią ne cuenta latsi' ná' canu làa cca guyu cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Acca rèe: Por nui nna chi pá'a' le qui'ni ni ttu lanú ccani ìtą para gata' fe quì'į lani inte' cáalá làa por voluntad qui' Tata quí'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Dèsdeba lània nna nuỹetse' canu denó cą néa nna beyeqquia cą nna labiru huía cą lani e. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Làniana ra Jesús ca enne' tsì'nuá: Canchu lebi'i nna, tsí càhua latsi' le éyya le cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Becàbi tè Simón Pedrua nna ra bi e: Señor nuni attu enne' ní éyya tu' ru'a luį sino làteruba cuią'lu' cá, porqui'ni tùteruba cuią'lu' riquixá'a titsa' nu runna la'labàni tulidàba. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Intu' nna chi huíalatsi' tu' nna chi yù tu' qui'ni cuią'bálu' ná Cristo Ỹi'ni Tata Dios enne' bàni tulidàba. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Becàbi Jesús nna rèe cabi: Tsí álahua chi becuí'a' tsì'nu le, pero nuỹa lá ttu le nna ną́ huenitsìna qui' numalua cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ą' ra Jesús qui' Judas ỹi'ni ttu nu láą Simón Iscariote ba, porqui'ni Judas nuá nu gutią ne cuenta; uccua huą́ canu tsì'nuá. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Gutè diba gunne Jesús ca tìtsa'a nna, le' región qui' Galilea bá gurènie; qui'ni labí uccua latsi'e cuenie le' región qui' Judea porqui'ni canu rigú'ubia' qui' ca enne' judíua nna uccua latsi' quį gutti cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Exa taá chi debiga' fiesta qui' ca judíua, tiempo de rexa latsi' quį loti' guỹua ca ta' tàta qui' quį le' ca yú'u l·la' le' desiértuá nna rue' cą gracia por cosecha qui' quį nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ca bettsi' Jesús nna ra cą ne: Beyya para Judea para qui'ni ca discípulo qui' lu'a nna ilá' huáni cą ca milagro runi lu', ");
INSERT INTO zaaNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","porqui'ni ni ttú nu calatsi' ccą́ enne' ỹeni nna runi gattsi' bą́ biỹa canią gunią; yàqui'ni lu' cani lu' runi lu' ca cosį nna, mejor la dacca' lótaá beni cą ru'a lo ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Anía ra ca bettsi' Jesús ne, porqui'ni nìhua làcą labí huíalatsi' quį ne. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús nna ra tìe cą: Bihua chi gùl·la' tè tiempo para tsa'á', pero lebi'i nna huacca ba tsía le biỹa díbá tiempo ní. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Canu yétsiloyuį nna bihua ruyudí' cą le, pero inte' nna hua ruyudí' cą porqui'ni rudea' lo quį ca hecho mal nu runi cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Littsia ba lebi'i fiéstaá, pero inte' nna bihua thaya tìa', porqui'ni labí chi gùl·la' tè tiempo para ccá' declarar lani yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Beyacca díbá rèe cą anía nna, beyà'na tìe Galilea. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pero guda' díbá ca bettsi' áa dia cą nna, ą'hua lèe nna huía huée fiéstaá, pero alàa dàcca'ló tè sino huía gàttsi' bée. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ca judíua nna reyìla cą ne entre iyaba ca enne' tsè'e le' fiéstaá nna ra cą: Gani tì'icua nubéyu'a cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ca enne' ỹétse'á nna yala gunne cą quì'e. Ttu te cą nna ra cą: Yala enne' tsè' ná bí. Pero áttu te cą nna ra cą: Álahua enne' tsè' nua', sino ruthacca'ỹí bą́ yetsi. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero lanú beyáỹani inne dàcca'ló taá quì'e, porqui'ni gutsi báni cą canu rigú'ubia' entre ca judíua. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ttú rilàhui' tì'ga fiéstaá nna bitsina' Jesús le' templua nna gutixe'e ca enseñanza nu cca qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Biquíla' bá latsi' ca judíua nna ra cą: Ti'ani modo nabia'ni nui Escritura, labí estudiar chi benią. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Becàbi Jesús nna rèe cą: Nu riquixa'ánia' le nna labí ną́ quia', sino qui' enne' guthèl·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nu calatsi' guni voluntad qui' Tata Dios nna huènnią cuenta canchu nu riquixa'ánia' le nna ną por mandado qui' Tata Dios o canchu inte' nna rinnéebá' por la' calatsi' quíbá' acca. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nu rinne por la' calatsi' qui'bíį nna es qui'ni càba latsi'į gudàliani cą na. Pero ttu enne' calatsi' qui'ni adí ca enne' nna gudàliani cą enne' guthèl·le'e bi nna, entonces làbi nuą' riquixà'a nu ná lí nna labí la' beỹia té lani bi. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Tsí álahua Moisés nuá benna ley lani le cá. Pero ni ttú le nna labí runi le cumplir nu ra lo ley. Biala qui' acca calatsi' le gutti le inte' cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Becàbi canu ỹétsi'á nna ra cą ne: Loco bá cca lu'. Núní calatsi' guttią lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Becàbi Jesús nna rèe cą: Por ttu milagro nu benia' tsá redi' latsi' le nna, acca rechul·la taá latsi' iyaba le. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Hualígáláà qui'ni Moisés nna gutìxa bi ley qui' circuncisión, ą'hua ca ta' tàta qui' lía ca enne' gutsé'e ántescàla Moisés nna beni huá cą circuncidar. Acca lebi'i nna runi hua circuncidar ca nubeyu' to' biỹa tediba tsá màsqui'ba ną́ ttu tsá ỹeni qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Lebi'į nna runi le circuncidar ttu nubeyu' to' tsá nu labí ná qui'ni guni le biỹa tsina, solamente para qui'ni làa gudu le ttu lado ley nu gutìxa Moisés nna. Bialácca yala ritsa'áni le inte' porqui'ni beyunia' itute cuerpo qui' ttu nubeyu' tsá redi' latsi' le cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Bittu guni le lu'uxtícia según bá nu rila'ni le lo ra', sino liguni lu'uxtícia según bá nu ná tsè'. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Làniana tuchùppa canu Jerusalén nna ra cą: Tsí álahua nubéyu'į nuá reyìla cą para gutti cą na cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Línna' tsaáruhuá qui'ni publicamente taá rinnią, pero bihua biỹa reya cą na. Tsí ína ri'u chìa ríalatsi' canu rigú'ubia' le' yetsį qui'ni hualigani nubéyu'i nuá Cristua cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nui hua yù ba ri'u gaỹa enne' ní ną́. Pero canchu chi íl·lani Cristua nna, lanú nuỹa ccą́ saber gáỹalá dé'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","De riquixá'ani Jesús ca enne' tsè'e le' templua nna, gunnie idìtsa nna rèe: Tsí hualigani nabia'ni le inte'. Tsí hualigani yù le gaỹa enne' ni ná' áccá. Pero labí daya' por la' calatsi' quíbá', sino daya la' por mandado qui' Tata Dios lígani. Lebi'i nna labí nabia'ni li e. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pero inte' ba nna nabia' ti' e, porqui'ni lani labé dúa' ántesca ìta' nì; lèe nna guthèl·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Làniana uccua latsi' quį gudàxu' cą ne, pero nì ttú cą labí beyáỹani cą cú'u ná' quį ne, porqui'ni labí chi gùl·la' tè hora de quée sufrir. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nuỹé tsè'gani ca ènni'a nna huíalatsi' quį ne nna ra cą: Canchu chì íl·lani Cristua nna, tsí adírulá ca milagro gunie tì'chula nubeyu'į cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Biyeni báni ca fariséua nu ra ca enne' acerca de Jesús; acca ca sacerdote principal lani ca fariséua nna guthèl·la' chì cą ca policia para gudàxu' cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesús nna ra tìe cą: Atuchúppa ubitsa to' teruba rénia' lani le làniana éya'a bá' làti dua Enne' guthèl·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hueyìla inte' ba guni le, pero labí étseláni le inte'; làti thua' nna labí ccani le ìta le. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Làniana ra luetsi ca judíaua: Gá gání eyya nui qui'ni làa etselá huáni ri'u ą cá. Tsí ína ri'u hueyya ỹą́ le' ca yetsi làti gáttí' tsè'e bá ca enne' ná raza qui' ri'u para quixá'anią ca enne' griego cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Biani nua' diánią acca rą: Hueyìla inte' ba guni le pero labí etseláni le inte' porqui'ni làti thua' nna labí ccani le ìta le. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Rechùtsa tsá ỹeni gani qui' fiéstaá nna gùdu Jesús lahui' ca enne' ỹétse'á gunnie idìtsa nna rèe: Canchu nuỹa hualigani ribitsią, pues ná qui'ni itą́ lani inte' nna í'yą nu ná adiru tsè' para la'labàni quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nuỹa tediba ríalatsi'į inte' nna, làniana de lo lòstu'į nna iria la'labàni tì'a ca yò làti yù'u idíla tsè'ni inda, porqui'ni ą' ra lo Escritura. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Anía ra Jesús, para qui'ni tsíalatsi' quį ne nna guni cą recibir Espíritu Santo lo losto' quį; pues labí chi gul·lani Espíritu Santo lània, porqui'ni Jesús nna labí nì'i thí'e la' dàliani nu dá' de ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Làniana ttu te canu lání entre iyaba ca enne' ỹétse'á biyeni báni cą ca titsa' gunne Jesús nna ra cą: Hua libani qui'ni ènni'į nua' ná profeta enne' rinne parte Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Attu te cą nna ra cą: Là ènni'į nua' Cristua enne' ribeda ri'u íl·lani le' yétsiloyu. Adí cą nna ra cą: Tsí ína ri'u qui'ni de Galilea lá ná qui'ni il·lani Cristua cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tsí álahua ra lo Escritura qui'ni le' familia qui' David enne' uccua rey ná qui'ni íl·lani Cristua le' Belén yetsi qui' la'a mísmuba David. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Acca ca enne' tsè'e cą nía nna ritìl·la ritsa' bá cą por nu cca qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ttu te cą nna uccua latsi' quį cú'u ná' quį ne; pero nì ttuą lanú beyáỹani gudàxu'ą ne. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Beyeqquia ba ca policia nna gunaba titsa' ca sacerdote principal ą'hua ca fariséua cą nna ra cą: Biecca làa déché' li ą nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Becàbi ca policíaá nna ra cą: Nunca labí nì'i íria ttu enne' quixa'a tì'a riquixá'a nubéyu'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Becàbi ca fariséua nna ra cą: Tsí tsa' tehuá lebi'i chi guỹacca'ỹí le cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tsí ína ri'u qui'ni nuỹa ttu ca enne' rigú'ubia' qui' ri'uą' o nuỹa ttu ca fariseo chi huía latsi' cabi quì'į cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero iyaba ca enne' tonto tsè'e nà' chi huíalatsi' quį qui' nubéyu'ą', pues basta gáláa qui'ni labí nabia'ni cą nu ra lo ley qui' religión qui' ri'u acca chìa gunitti cą. Anía ra ca fariséua. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Làniana Nicodemo nu huía ru'a lo Jesús de réla lá, uccua huáchúą ttu canu fariséua; gùdulią nna rą iyaba ca fariséua: ");
INSERT INTO zaaNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Tsí hua riquixá'a lo ley qui' ri'u qui'ni ttu nubeyu' nna ccá taą́ castigar sin qui'ni làa iyeni ỹáni ri'u declaración quì'į nna cca ri'u saber nu benią cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Becàbi cą nna ra cą na: Tsí yà' huání lu' ná lu' nu Galileo cá. Pues gútsatsáruhuá lo Escritura para qui'ni ennia lu' cuenta qui'ni nunca nì'i iria ttu profeta le' región qui' Galileą'. ");
INSERT INTO zaaNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Làniana gùduli cą nna deyya tè litsi' tsa ba quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Huía te Jesús lo i'ya láą Monte de los Olivos. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","De díla lá nna betsine'e attu le' templua. Iỹetse' ca enne' nna bitsina' cą ru'a lúe. Lèe nna gure' báníe nna gutixa'ánie cą ca enseñanza nu cca qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Làniana ca maestro de la ley, ą'hua ca fariséua nna tahua' cą ru'a lúe ttu niula beỹuna'nì cą na runią adulterio. Bedu tè cą na lahui' nna, ");
INSERT INTO zaaNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ra cą ne: Maestro, beỹuna'nì tu' niulíį méruání runią adulterio. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lo ley nu bethá'na Moisés nna runi mandado gutti ri'u luetsi ca niulíį lani íyya. Cuíą'chulu' nna, ti'ala ína lu' ccá quì'į cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Anía ra cą para guni ba cą ne prueba nna gappa cą néda biỹa causa ni gutsia cą quì'e. Pero Jesús nna gùnne'e loyu nna bènie letra lani ỹubené'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Beni bá cą seguir gunàba titsa' cą ne, acca bebé' tsè' tèníe gunne'e cą nna rèe: Nuỹa la ttu le nu bíttu tení tul·la' chi benią nna, lą nna hué' bą́ niulą' primero íyyá. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Làniana gùnne'e loyu attu nna bènie letra attu. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Biyeni báni cą ca tìtsa'a nna, la' rulaba latsi' qui' quį labí be'él·la'ą cą qui'ni hué' cą niuláa, acca gùdulo chìa ttu ttu tsa cą beria cą fuera, dèsdeba canu adiru enne' gùla hàstaba nu adiru nu cuìti'a. Beya'na tè tùteruba Jesús ą'hua niula nu beda cą làhui'a nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Gulìtha tè lo Jesús attu nna nìdi áttuą lanuru té, sino là terúbá niuláa du nía, acca ra tìe na: Niula, gání tì'iccua canu beni contra lu'a. Tsí nùhua nuỹa bé'ą lu' íyyá. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Becàbią nna rą ne: Lanú nuỹa Señor. Jesús nna ra tìe na: Nìhua inte' nna bihua gunia' lu' condenar; beyya ba nna, bíttuúru guni lu' tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Attu vuelta gutixa'áni Jesús ca enne' nna rèe: Inte' ná' la'yani' para yétsiloyu; nuỹa tanúą inte' nna labiru cuenią le' chul·la, sino chi té la'yani' nu ną́ la'labàni para lą. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Làniana ra tè ca fariséua ne: Nu riquixá'a lu' nna labí ną́ lígani porqui'ni rudàliani lu' la'a lu' bá. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Becàbi Jesús nna rèe cą: Màsqui'ba riquixà'a' nu cca quíbá', pero riquixà'a bá' nu lígani, porqui'ni hua yú bá' gáỹalá daya' ą'hua gáỹalá éya'a'. Pero lebi'i nna labí yù le gáỹalá daya' nìhua gáỹalá éya'a'. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lebi'i nna runi le juzgar según la' rulába latsi' quì'ba le. Inte' nna núhuá nuỹa runia' juzgar. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero canchu runia' lù'uxtícia nna, es qui'ni lù'uxtícia quíyi'į nna ną́ de acuerdo lani nu ná lí; porqui'ni álahua ttua' ná, sino qui'ni Tata Dios enne' guthèl·le'e inte' nna du bée lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lo ley qui' le nna riquixà'a qui'ni nu inne chuppa ca testigo nna, lànuá ną́ titsa' lígani. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Inte' nna riquixà'a' nu cca quíbá'. Ą'hua Tatáa enne' guthèl·le'e inte' nna rute huée testimonio acerca de inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","De rèe ca tìtsa'a nna, ra tè cą ne: Gání ti'iccua Tàta qui' lu'l cá. Becàbi Jesús nna rèe: Labí nabia'ni le inte' nìhua Tàta quíya'a. Cáalá runibia' le inte' nna, pues gunibia' huá le Tàta quíya'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iyaba ca tìtsa'a gunne Jesús exa taá làti rigú'u cą ofrenda loti' gutixè'e ca enseñánzaá le' templua. Pero lanú nuỹa bedàxu'ą ne preso, porqui'ni labí chi gùl·la' tè hora quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Attu vuelta nna ra Jesús cą: Inte' nna éya'a bá'; lebi'i nna huàl·lani tsá eyìla le inte', pero le' ca tul·la' quì'ba le gatti le. Làti éya'a' nna labí ccani le ìta le. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Làniana ra tè ca judíua: Aỹa càba latsi' nui gutti la'a labą́ acca rą: Làti éya'a' nna labí ccani le ìta le. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús nna rèe cą: Lebi'i nna, nu yétsiloyu ba na le, pero inte' nna de ỹiabara' lá ná'. Lebi'i nna ná le nu yétsiloyuį, inte' nna labí ná' nu yétsiloyuį. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Por nui nna nia' le qui'ni le' ca tul·la' quì'ba le gatti le. Porqui'ni canchu bihua tsíalatsi' le qui'ni inte' nui nna, le' ca tul·la' ba gatti le. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Làniana ra cą ne: Núní ná lu' nì'i. Jesús nna rèe cą: Nu chìbá pá'a' le dèsdeba néruá. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nu ỹeni té quíxa'a' nu cca qui' le, ą'hua gunia' declarar juicio contra lebi'i, porqui'ni enne' guthèl·le'e inte' nna rinnie nu lígani; inte' nna, nu chi biyeni bá te' gunnie nna ą́' bá riquixa'a' ru'a lo ca enne' le' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Anía gutixà'a Jesús, pero labí bennia cą cuenta qui'ni gunènie cą nu cca qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Raá ruhuée cą: Canchu chi gal·la' tsá ichitha le Nubeyu' de Ỹiabara', lànialá nna ennia le cuenta qui'ni inte' bá nuá. Ą'hua labí biỹa runia' por la' calatsi' quíbá', sino tì'a nu gutixa'áni Tatáa inte', ą́' bá rìnnia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Porqui'ni Tatáa enne' guthèl·le'e inte' nna du bée lani inte' nna labí rútse'e latsi'e inte'; porqui'ni siempre ní runia' nu rú'u latsi'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","De gunnie ca tìtsa'a nna, nuỹetse' ca enne' nna huíalatsi' quį ne. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesús nna rèe ca judío canu chi huíalatsi' quį ne: Canchu guni le seguir ccá le tsìttsì lani ca titsa' quia' nna, ą' modo nna rulue'ní qui'ni ná le ca discípulo quia' nna, ");
INSERT INTO zaaNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","gunibia' tè le nu ná lígani. Por ca titsa' liganíį nna ccá le libre. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ra tè cą ne: Intu' nna ná tu' descendiente qui' Abraham enne' gùdua tiempo antigua. Nunca labí chi uccua tu' esclavo qui' nuỹa. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Becàbi Jesús nna rèe cą: Hualigani te' nia' le qui'ni iyaba canu tul·la' nna, pues esclavo qui' tul·la' ná cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tì'a ttu esclavo nu runi servir le' ttu yú'u nna álahua tulidà duą le' litsi' xàni'į, pero ttu ỹi'ni nna tulidàba ccą pertenecer le' yú'u qui' tàta quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Acca canchu inte' Ỹi'ni Tata Dios nna gudilá'a' le nna, es para qui'ni gata' libertad nu ná lígani qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Hua yú bá' qui'ni ná le descendiente qui' Abraham, pero calatsi' le gutti le inte' porqui'ni labí ritsina' tsè' ca titsa' quíyi'į lo losto' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Inte' nna riquixà'a' nu chi bilá' te' loti' dú'a' le' presencia qui' Tàta quí'a, pero lebi'i nna runi le tì'a nu chi bethète'ni tàta qui' lía le. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Becàbi cą nna ra cą Jesús: Abraham bá ná tàta qui' tu'. Jesús nna ra tìe cą: Cáalá hualigani ná le ỹi'ni Abraham nna, pues hua runi le nu ná tsè' tì'a beni Abraham. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero annana càla latsi' le gutti le inte', màsqui'ba chi gutixa'ánia' le nu ná lí según bá nu belue'ni Tata Dios inte'. Abraham nna nunca labí beni bi tì' runi le. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Lebi'i nna runi le tì'a nu runi tàta qui' lía. Ra tè cą ne: Intu' nna alàa nùti'dí ná tàta qui' tu'. Tùteruba tàta qui' tu' dua, née Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Làniana ra Jesús cą: Cáalá Dios ná tàta qui' le nna, hualigani hua catsi'í láni le inte' cá; porqui'ni birí'a' le' ỹiabara' làti dua Tata Dios nna gúl·lania' nì. Nìhua labí daya' por la' calatsi' quíbá', sino labée guthèl·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Biecca labí ritelíni le la' rinne quia' cá. Es porqui'ni labí rennia le cuenta nu riquixa'ánia' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tàta qui' le nna ną́ numalua; ą'hua nu rú'ulatsi' tàta qui' lía, ą́' bá ná nu calatsi' le guni le. Porqui'ni numalua nna dèsdeba néruá ną́ huètti enne', ą'hua púruání nu bèỹia bá ną́ nna labí nu lí té lani ą. La' rinne quì'į nna ną́ puru taá bèỹia, pues ą́' bá runią porqui'ni ną́ tàta qui' la' bèỹia. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pero porqui'ni inte' rìnnia' nu ná lí nna, labí ríalatsi' le quia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Núní ttu le gutsia falta quia' qui'ni nu rìnnia' nna álahua ną́ lígani cá. Pues siempre ba rìnnia' nu ná lí nna, bialácca labí ríalatsi' le quia' nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nuỹa tediba ná qui' Tata Dios nna rudà nàgui'į ca titsa' quì'e. Pero lebi'i nna labí rudà naga' le ca tìtsi'į porqui'ni labí ná le enne' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Becàbi ca judíua nna ra cą ne: Hualibani tu' ra tu' qui'ni ná lu' nu samaritano nna dua ttu espíritu malo lo losto' lu' nna chi runią lu' loco. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús nna ra tìe cą: Álahua loco cca inte', sino qui'ni rudàliani lá' Tàta quí'a. Lebi'i nna rìniyu lá le inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Bihua reyìla' nuỹa gudàlianią inte', pues hua dua ba enne' rinnie a favor de inte'. Lèe nna née Juez. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Hualigani te' riquixa'ánia' le: Nuỹa tediba runi obedecer ca titsa' quíyi'į nna, nunca labí gattią. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Làniana ra ca judíua ne: Anna lá nna hua yù tu' qui'ni yù'u ttu espíritu malo lo losto' lu'. Abraham nna gùttì ba bi, ą'hua ca profeta nna, atsi'íni lu' nna dá' tè lu' rena lu': Nuỹa tediba riguą ca titsa' quíyi'į nna jamás labí gattią. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tsí ína ri'u adila enne' ỹeni ná lu' tì'chula ta' tàta qui' tu' Abraham. Lèe nna màsqui'ba uccue enne' yéni, pero gùttì bée. Ą'hua ca profeta nna gùttì hua cabi. Núní cani lu' ná lu' nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Becàbi Jesús nna rèe cą: Cáalá inte' rudáliania' la'a inte' ba nna, entonces la' dàliani quíyi'į nna labí biỹa dàcca'ą. Pero la'a mísmuba Tata Dios enne' rena le qui'ni runi li e adorar, lèe ènni'a' rudàlianie inte' porqui'ni née Tata quia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Lebi'i nna labí nabia'ni li e, pero inte' nna hua nabia' ti' e. Canchu innia' qui'ni bihua nabia' ti' e nna entonces ná' ttu bèỹia tì'a lebi'i; pero hualigani nabia' ti' e nna rigú'a' ca titsa' quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ta' tàta qui' le Abraham nna yàlaní bedacca' latsi' bi de uccua bi saber qui'ni huàl·lani tiempo qui'ni ìta' le' yétsiloyu; de bila'ni bi ą nna adírulá bedácca' latsi' bi. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ra tè ca judíua ne: Nìhua tsìayona' ida nì'i labí chi du lu' nna, atsi'íni du te lu' rena lu' qui'ni bila'ni lu' Abraham. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús nna rèe cą: Hualigani te' nia' le: Ántesca galia Abraham nna, chìlá dú'a'. ");
INSERT INTO zaaNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Làniana gutèl·la' cą íyya para hué' cą Jesús nna gutti cą ne, pero lèe de repente taá betìe lahui' quį nna berie le' templua nna déyyeé. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Néda bá deyu'u Jesús nna, bila'ni e ttu nubeyu' ciego ri'ą nía. Nubéyu'a nna dèsdeba gùlią ną́ ciego. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Gunàba titsa' tè ca discípulo qui'áa ne nna ra cabi: Maestro, núní gulú'u falta acca gùlia nubéyu'į ciego, tsí labą́, o, tsí tàta nàna quì'į áccá. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Becàbi Jesús nna rèe cabi: Álahua nui rappa tul·la', nìhua tàta nàna quì'į nna, sino gùlią ciego para qui'ni ilá'ni la'huacca qui' Tata Dios lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Náduel·la' qui'ni gunia' tsina qui' Enne' guthèl·le'e inte' daca'tè renia' le' yétsiloyu; porqui'ni huàl·lani hora canchu chi lanuru nuỹa guni tsina. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Miéntraste renia' le' yétsiloyu nna, la'yani' ná' para yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesús nna de chi rèe anía nna, betùtu tè xèni'e loyu nna, benie gútsa' lani xèni'a, gutàbi tìe gútsa'á lo nubeyu' ciéguá. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ra tìe na: Huía tatìi lo lu' ru'a pozo Siloéą'. Siloé nua' tì'ba nu rena ri'u Mandado. Lą nna huía tìą tatìi lúį; de beyéqquią nna chi rilá'nią. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Làniana ca vecino qui' niá ą'hua adí canu bila'ni cą na qui'ni ną́ ciego nna ra cą: Tsí álahua nui nuá nu ribe' huenàba caridad cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tuchùppa cą nna ra cą: Nui nuá. Attu te cą nna ra cą: Ti'taání nuá rului'ą. Lą nna rą: Inte' bá nui. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Acca gunàba titsa' cą na: Biani beni lu' acca biyàlia iyyaló lu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Becàbią nna rą: Enne'yu' lá bí Jesús beni bi gútsa' nna gutàbi bi iyyalúá' nna ra tè bi inte': Huía tatìi lo lu' ru'a pozo Siloéą'. Hua'á tia' gutíi lua' nna bilá' te'. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Làniana ra cą na: Gani tì'iccua nubéyu'a. Lą nna rą: Labí yù inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Guche' tè cą nu uccua ciéguá ru'a lo ca fariséua. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Loti' beni Jesús gútsa'á nna benie qui'ni bila'ni nubeyu' ciéguá nna uccuą ttu tsá nu labí runi ca judíua biỹa tsina. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Canu denó religión fariseo nna bedenàba titsa' cą nubéyu'a tì'iỹalá benią biyàlia lúį. Lą nna rą cą: Gutàbi bi gútsa' lua' nna, gutíi tè lua', annana rila' te'. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tuchùppa ca fariséua nna ra cą: Álahua enne' qui' Tata Dios ná nubéyu'ą' porqui'ni labí riguą tsá ná qui'ni édi' latsi' ri'u. Attu te cą nna ra cą: Pero ti'ani modo ccani ttu nubeyu' gunią luetsi ca milágruį canchu ná bą ttu nu tul·la' nì'i. Acca ritìl·la ritsa' bá cą tsè'e cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Làniana gunàba titsa' cą attu vuelta nu uccuą ciéguá nna ra cą: Lù'chu nna, biani ra lu' qui' nu guthàlia lo lu' ą'. Lą nna rą: Ná bi ttu profeta qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero ca judíua nna labí huíalatsi' quį qui'ni nubéyu'a nna primero uccuą ciego, acca gutàỹi cą hàstaá tàta nàna qui' nu chi biyàlia iyyaló niá. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Gunàba titsa' tè cą nna ra cą: Tsí nui nuá ỹi'ni lía nu rena le qui'ni gùlią ciego. Ti'ala modo acca annana rilá'nią nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Becàbi ca tàta nàna qui' nubéyu'a nna ra cą: Hualígáláà nui nuá ỹi'ni tù'a, ciégubá ną́ loti' gùlią, ");
INSERT INTO zaaNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","pero ti'iỹalá modo acca rilá'nią annana, bihua yù tu'; nìhua làa yù tu' nuỹa guthàlia iyyalúį nna. Nu gùla ba chi ną́; pues làbą linàbatìtsa', lą̀ nna huacca bánią quixá'ą nu cca quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Anía ra ca tàta nàna qui' niá porqui'ni gùtsi báni cą canu rigú'ubia' entre ca judíua, porqui'ni chi gunne lettia cą gudàl·la cą fuera sinagoga qui' caniá iyaba canu ína qui'ni Jesús nna née Cristo. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Acca tàta nàna qui' nubéyu'a nna ra cą ca fariséua: Nu gùla bá chi ną́, nà' bá linàbatìtsa' ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Làniana bedeyàỹì gábá cą nu uccua ciéguá nna ra cą na: Bè' gracia Tata Dios alàa nubéyu'a. Intu' nna yù tu' qui'ni nubéyu'ą' nna ną́ nu tul·la'. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Becàbią nna rą: Bihua yúá' canchu ná bi enne' tul·la', pero ttu cosa nna hua yúá': qui'ni inte' nna uccua'a' ciego, pero annana rilá' té'. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Redeya tè cą na: Biani benią qui' lu'. Ti'ani modo guthàlią iyyaló lu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Becàbią nna rą cą: Chìỹa pá'a' le nna, pero bihua bedà' naga' le. Bianicca calatsi' le quixa'ánia' le attu nì'i. Tsí ą'hua lebi'i nna calatsi' le ccá le discípulo qui' bi áccá. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Làcą nna beduadí' lá cą na, nna ra cą: Lù'ba ná discípulo quì'į ỹa, pero intu' nna discípulo qui' Moisés bá ná tu', ");
INSERT INTO zaaNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","intu' nna yùlí ragání tu' qui'ni Tata Dios nna gunnie directamente taá lani Moisés, pero acerca de nubéyu'į nna nìdi làa yù tu' gáỹalá dá'ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Làniana ra nubéyu'a cą: Caỹí bá látsa'a' qui'ni lebi'i nna labí yù le gáỹalá da' bi, pero beni bi ttu milagro lani ca iyyaló yì'į acca chi rilá' té', ");
INSERT INTO zaaNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","hua yù ba ri'u qui'ni Tata Dios nna labí rudà nague'e qui' canu tul·la'; pero canchu nuỹa ràppą ne respeto ą'hua runią nu rú'ulatsi'e nna, lànuá nna recàbie quì'į, ");
INSERT INTO zaaNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","pues iyaba ca tiempo nu chi gutè nna, bihua nì'i iyénini ri'u canchu nuỹa chi guthàlią iyyaló ttu nu gùlia ciego, ");
INSERT INTO zaaNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","cáalá ènne'yu'a bihua da' bi de ỹiabara' làti dua Tata Dios nna, entonces labí biỹa ccani bi guni bi. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Becàbi cą nna ra cą na: le' tul·la' bá nàliani lu', átsi'ini lu' lá runna lu' intu' consejo cá. Làniana bedàl·la cą na fuera sinagoga qui' caniá. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Bina tè Jesús qui'ni bedàl·la cą nubéyu'a fuera, betsà' tìe na áttu nna rèe na: Tsí hua ríalatsi' lu' Ỹi'ni Tata Dios qui'ni té la'huacca quì'e cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Becàbią nna rą ne: Señor, núní ènni'ą' para qui'ni gappa' fe lani e. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús nna rèe na: Pues, chìa bila'ni lu' e; làbe nui rue' lani lu' titsa'. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nubéyu'a nna ra tìą ne: Hua ríalátsa'a' Señor. Làniana bèni tìą ne adorar. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Raáruhuá Jesús: Inte' nna daya' yétsiloyuį para qui'ni ilá'ní ti'iỹa ná la' rulábalatsi' qui' ttu ttu enne': para qui'ni canu labí rila'ni nna ila'ni cą; ą'hua canu rulába latsi' qui'ni rila'ni cą nna ccá lá cą ciego. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Biyeni báni tuchùppa ca fariseo tsè'e ru'a lúe lània ca tìtsi'į nna ra tè cą ne: Tsí ína ri'u qui'ni intu' nna ciego huá ná tu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Becàbini Jesús cą nna rèe: Cáalá ná telá le ciego nna entonces labí causa qui' le té por ca tul·la' qui' le. Pero porqui'ni rena le: Rila'ni tu', acca rilá' rabání qui'ni ná le responsable por ca tul·la' qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Hualigani te' riquixa'ánia' le: Nuỹa labí ra'ą lado ru'a puerta qui' cúrrali qui' ca carnero, sino qui'ni ràppią attu ládulá para gá'ą le' cúrraliá, pues lànuá nna ną́ ubàna nu ribèqquia gàttsi' nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero nu ra'a bá lado ru'a puértaá nna, làbą nuá pastor qui' ca carnérua. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nu rue' cuidado ru'a puértaá nna rithàlią para gá'a nu ná pastor. Ca carnérua nna nabia' báni cą enne' ná pastor qui' caniá de riyénini cą tsì'į; pastor nna conforme ba rudèttią láa ca carnérua nna riria cą fuera. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","De chi tsè'e iyaba ca carnero qui' niá fuera nna, lą nna rinéru tìą lo quį; ca carnérua nna ritanó tè cą na de riyénini cą tsì'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero áttu nuhuaya' nna labí tanó cą na, sino ucuìtta lá cą ru'a lúį porqui'ni labí nabia'ni cą tsì'ì canu huaya'. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Comparación nì nna gutixa'áni Jesús cą, pero labí gutéelíni cą biỹa nuá rèe cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Acca Jesús nna ra huée cą attu: Hualigani te' nia' le: Inte' ná' tì'a ttu puerta para gá'a ca carnero. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Iyaba canu bìta ántesca inte' nna ubàna nna huebèqquia gàttsi' bá nna ná cą, pero ca carnéruį nna labí caso beni cą qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Inte' ná' puerta de salvación. Nuỹa gá'a ru'a puértį nna labiru duą lo peligro; ą'hua gata' huá la'ỹeni quì'į tì'a ttu carnero to' nu ra'a reria bá le' cúrrali quì'į nna ritaxácca'ą íxi' to' ruą. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ttu ubana nna labí ìtą canchu lahuá para cuana terubą nna guttią nna gutàppa'ą nna. Pero inte' nna daya' para qui'ni gata' la'labàni qui' le, pero ttu la'labàni iỹeni nna completo nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Inte' ná' Pastor Tsè'. Por ejemplo: ttu enne' nu rappa tsè' carnero nna, lą̀ nna ga'ną dispuesto iria latsi' la'labàni quì'į por ca carnero to' quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero ttu nu nàỹa bání nna, pues bihua ną́ propio gání pastor, nìhua labí ną́ xana' ca carnérua. Acca canchu ilá'nią da' ttu lobo nna entonces gútse'e taá latsi'į ca carnérua nna ucuìttą; làniana lóbuá nna gudàxu'ą tuchùppa cą miéntraste ràthilàlia bá adí cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Acca nu nàỹa bánía nna ucuìtta bą́ porqui'ni mozo teruba ną́, bihua nùyue canią para huí'ą cuidado ca carnérua canchu ril·lani peligro. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Inte' ná' Pastor Tse'. Acca nabia' te' ca carnero quia'. Làcą nna nabia'ni cą inte', ");
INSERT INTO zaaNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","tì'ba Tata quíya'a nabia'nie inte'; inte' nna nabia' ti' e. Ą'hua riria látsa'a' la'labàni quia' por ca carnero to' quia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tsè'e huá attu te ca carnero labí yù'u cą le' cúrrali; ą'hua canuá nna caduel·la' huá taỹi ya' cą. Ą'hua làcą nna gudà naga' quį tsí'a' nna tsé'e iyaba cą bajo cuidado qui' tùteruba Pastor. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Acca por nui nna yala catsi'íni Tata quí'a inte', porqui'ni gútía' la'labàni quia' para edi' ya' ą attu. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Lanú nuỹa ccani cúa la'labàni quia', porqui'ni làteruba por la' calatsi' quíbá' rutée ya' ą. Té bá derecho quia' para gutée ya' ą, ą'hua para edi' ya' ą attu nna. Nui nna beni Tata quí'a inte' mandado gunia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ritìl·la ritsa' bá ca judíua tsè'e cą attu por ca titsa' qui' Jesús nna uccua cą chuppa l·la'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nuỹetse' cą nna ra cą: Ttu espíritu malo yù'u lo losto' nuą' ą'hua loco bá ccą, bianicca rudà naga' le quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero attu te cą nna ra cą: Alàa luetsi ca tìtsa'ą' rinne ttu nu yù'u espíritu malo lo lòstu'į, tsí ína ri'u huathàlia ttu espíritu mal iyyaló cc ciego cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Gùl·la' tè fiesta qui' ca judíua tsá rue' cą gracia Tata Dios por qui'ni beyacca templua qui' caniá attu. Làniana uccuą tiempo dìl·la'. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús nna reni tìe làti dua templua, ru'a portal qui' ta' rey Salomón. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ca judíua nna bitùbi cą ru'a lúe nna ra cą ne: Cuani gudùtsi lu' bíttuúru úccubi ya'a lu' latsi' tu'. Canchu lu' nua' Cristo nna entonces ná qui'ni quixá'ani lu' intu' claru taá. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Becàbi Jesús nna rèe cą: Chìỹa gutixa'ánia' le, pero labí ríalatsi' le. Ca cosa nu runia' lani nombre qui' Tàta quí'a nna rulue' cą nu cca quia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero lebi'i nna àtsahua làa ríalatsi' le, porqui'ni labí ná le nuỹa ttu ca carnero quia', tì'ba nu chi gutixa'ánia' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ca carnero quia' nna riyénini cą tsí'a'; inte' nna nabia' te' cą; làcą nna denó cą inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Inte' nna rùtià' la'labàni nu labí ttíą qui' quį; jamás labí nitti cą, nìhua lanú nuỹa cúą cą lo nàya' nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tàta quia' enne' benne cą lani inte' nna, adí la'huacca té quì'e tì'chula nuỹa tediba. Lanú nuỹa ccani cúą cą lo ná' Tata quí'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Inte' nna Tatáa nna ttùba ná tu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Làniana bededàxu' ca judíua íyya para hué' cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesús nna ra tìe cą: Iỹetse' ca cosa tsè' chi benia' por la'huacca qui' Tata quí'a. Por núlá ca cosį acca da' le hué' le inte' íyya para gutti le inte' cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Becàbi ca judíua nna ra cą ne: Álahua por ttu cosa tsè' nu chi beni lu' calatsi' tu' hué' tu' lu' íyya, sino porqui'ni labí respeto té qui' lu' lani Tata Dios. Enne' bá ná lu', atsi'íni rena tè lu' qui'ni ná lu' Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús nna rèe cą: Tsí álahua ga'na escrito lo ley qui' le qui'ni Tata Dios nna rèe ca enni'a: Lebi'i bá ná le ca dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yù ri'u qui'ni nu ra lo Escritura nna ną́ titsa' lí tulidà taá. Tata Dios nna chi rèe qui'ni ná cą dioses porqui'ni gul·lani titsa' quì'e lani cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Inte' enne' becué' Tata Dios nna guthèl·le'e inte' yétsiloyu, bialácca lebi'i nna rena le qui'ni labí respeto té quia' lani e porqui'ni nia': Inte' ná' Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Cáalá bihua runia' ca tsina qui' Tata quí'a nna, entonces razón bá téni le làa ríalatsi' le quia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero hua runi ya' cą, acca màsqui' làa ríalatsi' le quia' pero lítsía latsi' qui' nu rila'ni le runia', para qui'ni ennia le cuenta nna tsíalatsi' le qui'ni Tatáa nna dùe lani inte', ą'hua inte' lani Tatáa nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","De ra Jesús anía nna, attu vuelta uccua latsi' ca judíua gudàxu' cą ne preso, pero lèe nna tsàsti taá becuittée ru'a lo quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Huía tìe attu lado yò Jordán, lugar làti gureni Juáan primero loti' beni bi bautizar. Nía nna gùdue. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Pero enne' ỹétse'ní huía ru'a lúe nna ra cą: Juáan nna hualiba labí biỹa milagro ni beni bi, pero iyaba nu gutixa'a bi acerca de ènni'į nna ną́ nu lígani. ");
INSERT INTO zaaNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nía nna nuỹetse' ca enne' huíalatsi' quį Jesús por primera vez. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Gùdua ttu nubeyu' láą Lázaro, yala fuerte huì'nią. Uccuą enne' Betania yetsi qui' María lani ỹilíį Marta. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Lázaro nu rà'nia nna uccua dàna María nu beduą ungüento iqquia Jesús nna bedibìtsi tìą ca nì'e lani ittsa' iqquį. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ca dàna Lázaruá nna guthel·la' cą mandado tayàtsi cą Jesús: Señor, nu yala ccátse' cuíą'lu'a nna rà'nią. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Biyeni báni Jesús noticia nna rèe: Itsahue' qui' Lázaruá nna labí ną́ para gáttinią, sino para ilá'ní la'huacca qui' Tata Dios, ą'hua por medio de itsahue' quì'į nna tháliani Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús nna yala uccuatsì'e Lázaruá nna Mártaá nna ą'hua ỹilíį María nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pero Jesús nna gulèda bée áchúppa ubitsa làti ri'áa bitola de binee noticia. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Bitola nna ra Jesús ca discípuluá: Lítsa' Judea attu. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ca discípuluá nna ra cabi e: Maestro, ca judíua nna chì' uccua taá latsi' quį hué' cą cuią'lu' íyya. Biecca calatsi'íru cuią'lu' tsía cuią'lu' nía attu nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Becàbi Jesús nna rèe cą: Tsí álahua tsì'nu hora nua' cca ttu tsá cá. Nuỹa tediba ribèni de ritsá nna labí ribixią, porqui'ni rilá' bánią por la'yani' qui' ritsá. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero nuỹa tediba ribèni de réla nna ribixi taą́, porqui'ni labí la'yani' té lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Làniana raáruhuée cabi: Amigo qui' ri'u Lázaruá nna ti'áthi bą́ annana dí'a' tádibáni ya' ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ra tè ca discípulo qui'áa: Señor, canchu ti'áthi bą́ nna hueyàcca bá latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero Jesús nna acerca de lù'uti quì'ba Lázaruá nuá rèe anía, pero ca discípuluá nna belaba latsi' cabi qui'ni gunnie acerca de bétsiala. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Làniana ra Jesús cabi claru taá: Lázaruá nna chi gùttìą, ");
INSERT INTO zaaNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","pero yala redacca' te' qui'ni lànua' té nía, porqui'ni annana ila'ni le la'huacca quia' nna gappa le fe lani inte'. Éyya ri'u tayu ri'u ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Làniana Tomás enne' reya cabi cúáchi'á nna ra bi adí ca discípuluá: Lítsa' lani e para qui'ni gatti hua ri'u lani e. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","De bitsina' Jesús nía nna, chìlá uccua tappa ubitsa bigàttsi' Lázaruá. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Yetsi Betania nna ri'ą èxabá Jerusalén ttu tsal·lue' legua tì'ga. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nuỹetse' ca judíua nna biria cą le' Jerusalén nna huía cą litsi' María nna Mártaá nna para éyue' cą cą la'ỹeni porqui'ni gùttì dana caniá. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bìna bá Mártaá qui'ni dia Jesús litsi' caniá nna, biria chìą para tattsa'ą ne; pero María nna beyà'na bą́ le' yú'u. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mártaá nna ra tìą Jesús: Señor, cáalá re' ba cuią'lu' nì nna, entonces labí gùttì dana ya' a. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero hua yú huá' qui'ni biỹa tediba inàbani cuią'lu' Tata Dios lani oración nna, lèe nna gunie na. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús nna rèe na: Hueyátha bá dana lu'a de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mártaá nna rą ne: Hua yua' qui'ni eyátha dana ya' a canchu chi gal·la' último tsáa nna eyatha huá iyaba canu yatti de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús nna rèe na: Inte' rechítha'a' ca enne' de lo lù'uti, ą'hua ná' la'labàni nna. Nu ríalatsi'į inte', màsqui'ba chi gùttìą nna ccabàni bą́, ");
INSERT INTO zaaNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ą'hua iyaba ca enne' bàni canu ríalatsi' quį inte' nna, para siempre ni labí gatti cą. Tsí hua ríalatsi' lu' nui. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Becàbi Mártaá nna rą ne: Señor, hua ría bá látsa'a' qui'ni cuią'lu' Enni'a Cristo Ỹi'ni Tata Dios, chi gul·lani cuią'lu' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Beyacca bá ra Mártaá anía nna, huíą tatàỹi gàttsi' bą́ ỹilíį María nna rą na: Nì du Maéstruá nna rinnie lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Biyeni báni María nu ra Mártaá nna, guduli chìą quètha taaní nna huíą ru'a lo Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús nna du bée làti tattsa' Mártaá néa, labí chi gutè'e le' yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ca enne' judío tsè'e litsi' María reyue' cą na la'ỹéniá, pues làcą nna bilá' báni cą qui'ni quèthaní gudulí María nna, acca biria tehuá cą denó cą na, nna ra cą: Gubètsi bá díą lo bàá. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bitsina' bá María làti du Jesús nna, de bila'nią ne nna bedu tè ỹibį ru'a lúe nna rą ne: Señor, cáalá re' ba cuią'lu' nì nna, labí gutti dana ya'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús nna bilá' bánie na qui'ni ribetsią ą'hua ca enne' judío canu dia lani naá ribetsi huá cą nna, acca yala triste uccuani latsi'e nna gunnení latsi'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ra tìe: Gání gutìxa li ą. Becàbi cą nna ra tè cą ne: Gutà tsáruhuá inna' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Guretsi tè Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Acca ra tè ca judíua: Hualigani yala uccuani bi ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ttu te cą nna ra cą: Lą nna guthàlią iyyaló nu uccua ciéguá, tsí làa uccua huánią gunią qui'ni bittu gatti Lázaruá ca. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús nna fuértení gunne latsi'e attu de bitsine'e ru'a bàá. Ttu bèlia bá ná nuá nna yáya tè rú'į lani ttu íyya xeni tsè'. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús nna ra tìe: Líccua íyyą'. Marta dana enne' gùttìa nna rą ne: Señor, chi ril·là'ą porqui'ni chi uccua tappa ubitsa bigàttsì'ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús nna rèe na: Tsí álahua chi nia' lu' qui'ni canchu tsíalatsi' lu' nna, hualá'ni lu' la'huacca qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Làniana gutùa cą íyyaá de làti bigattsi' muértuá. Jesús nna guchìtha tè lúe rá' nna benie oración lani Tata Dios nna rèe: Tata quia', quiỹarú cuią'lu' qui'ni chi biyeni cuią'lu' oración quia', ");
INSERT INTO zaaNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","hua yú bá' qui'ni siempre ni rudà naga' cuią'lu' quia'; pero nia' nui para qui'ni ca enne' ỹétse'ní tsè'e ìta'lùba nì nna ilá'ni cą nna tsíalatsi' quį qui'ni cuią'bálu' guthel·la' cuią'lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Beyacca rèe anía nna, gunnie idìtsani nna rèe: Lázaro, beria fuera. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Làniana nu yàttìa nna beria chìą tétsí lári' ca nì'a ní'į, túbí tè lúį ttu lári'. Jesús nna ra tìe cą: Lethàtsi ą nna, líhue'él·la' tì ą éyyą. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Làniana nuỹetse' ca enne' judíua canu beni cą María acompañar nna bilá' báni cą milagro nu beni Jesús nna huíalatsi' quį ne. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero attu te cą nna huía cą ru'a lo ca fariséua nna gutixà'a cą nu beni Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Làniana ca sacerdote principal lani ca fariséua nna gunne tè cą ru'a lo Junta Suprema qui' ca enne' judíua nna ra cą: Biani ína le guni ri'u, porqui'ni nubéyu'į nna nuỹetse' ca milágrua runią, ");
INSERT INTO zaaNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","canchu hue'él·la' bá ri'u ą qui'ni gunią ą́', entonces prontu tabá iyaba ca enne' nna tsíalatsi' quį na, làniana huàl·lani taá ca soldado da' de Roma nna gutàppa' cą templo qui' rí'uą', ą'hua gul·lùỹa cą latsi' nación qui' rí'uį nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Làniana de lo iyaba canu tsè'e nía nna gudulí ttu nu láą Caifás, uccuą huexána' qui' ca sacerdote qui' ida lània. Lą nna gunnią nna rą: Lebi'i nna, labí biỹa yù le, ");
INSERT INTO zaaNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","nìdi làa rulaba latsi' le qui'ni adila tsa' tal·lią ri'u canchu gatti ttu enne' por yetsį tì'ca'la l·lúỹa tebá latsi' ituba nación qui' rí'uį. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Anía rą, pero alàa por la' rulábalatsi' qui' bíį, sino porqui'ni uccuą huexána' qui' ca sacerdotea ida lània nna gunnią parte Tata Dios qui'ni Jesús nna ná qui'ni gattie en vez de ituba nación qui' ca enne' judío. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pero alàa tsua' teruba por làcą gattie sino ą'hua para eyúnie ttùba iyábani ca ỹi'ni Tata Dios canu nàthilàlia bá le' ituba yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Acca dèsdeba lània nna gutsé'e cą de acuerdo para gutti cą Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Acca lèe nna labiru gurènie dacca'ló tè entre ca judíua, sino bede'e nía nna huíe para región luítta' desiértuá le' ttu yetsi láą Efraín. Nía bá gùdue lani ca discípulo qui'áa. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Chì' tegáabá debiga' pascua qui' ca enne' judíua nna, nuỹetse' ca enne' qui' ca yetsi to' anta' nía huía cą Jerusalén ántesca gal·la' fiéstaá para eyacca nàrì cą según costumbre religiosa qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Làcą nna beyìla cą Jesús. Acca de tsè'e cą le' templua nna gunàba titsa' luetsi quį nna ra cą: Biani ra le. Tsí bihua itą́ fiéstį cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ca sacerdote principal ą'hua ca fariséua nna gunèni cą ca enne' qui'ni nuỹa tediba guną gaỹa ri'e nna, ná qui'ni equixá'a taá cą, para qui'ni gudàxu' cą ne preso. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Xuppa ubitsa ántesca gal·la' pascua nna, huía Jesús Betania làti gùdua Lázaro nu gùttia pero Jesús nna bechìthèe na de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nía nna beni cą sí'e; Mártaá nna runi tìą servir lo méỹá. Entre canu ỹuaní lo méỹaá lani Jesús nna, re' huá Lázaruá nía. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Làniana guỹi' María ttu frasco tá'a lì'į ttu medio kilo puru taá ungüento nu de ìyyà láą nardo dàcca'ą yaỹi nna bedua tìą cą lani ittsa' iqquį. Bètu taá le' yú'a gul·làa' iỹíxí. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ttu discípulo qui'áa nu ná qui'ni gutią ne cuenta láą Judas Iscariote ỹi'ni ttu nubeyu' láą Simón, gunnią nna rą: ");
INSERT INTO zaaNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Bianicca làa huatsitò'o lá ungüéntuą' por tsunna gayua' denario nna guni ri'u cualàni ca enne' rittè la'dí'. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Anía rą, pero álahua qui'ni yala retúa latsi'į ca enne' pobre, sino porqui'ni ubàna bá uccuą, ą'hua labą́ nàl·la' bolsa bel·liu nu bitúppá qui' cabía nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús nna ra tè Judas: Be'èl·la' bá ą, porqui'ni para canchu chi gal·la' tsá igàttsi'a', acca runią nui, ");
INSERT INTO zaaNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","pues, ca enne' pobre nna tulidàba tsè'e cą lani le, pero inte' nna álahua tulidà renia' lani le. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Làniana nuỹetse' ca enne' judíua bina cą qui'ni re' Jesús nía, acca huía cą, alàa tsua' teruba por Jesús sino para qui'ni ilá' huáni cą Lázaro nu benie qui'ni beyàcca bàni naá. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Acca ca sacerdote principal nna gunne lettia cą gutti hua cą Lázaruá, ");
INSERT INTO zaaNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","qui'ni por Lázaruá nna nuỹétse'ní ca judíua bétse'e latsi' quį religión fariséuá nna huíalatsi' quį Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Attu yu'utsá nna míli' ní ca enne' tsè'e cą fiéstaá qui' Jerusalén. Biyeni báni cą qui'ni chi dia Jesús nía nna, ");
INSERT INTO zaaNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","guchu cą ca ná' ca ya dina' nna, biria cą para tatsà' cą ne, gunne tè cą idìtsa tsè' nna ra cą: Quiỹarú Tata Dios. Bendito enne' da' por mandado qui' Señor Dios para quée Rey qui' yetsi qui' ri'u Israel. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Gul·lani Jesús làti du ttu burro to' nna, gutsia tìe na, tì'ba chi ga'na escrito nu cca quì'e làti ra: ");
INSERT INTO zaaNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Lebi'i ca enne' qui' yetsi Sión, bittu gátsini le; Linna' tsáruhuá, nì da' enne' cca Rey qui' le. Tsìe ttu burro to'. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Primérute nna labí gutéelíni ca discípulo qui'áa nu uccua tsá lània, pero bitola de chi deyya Jesús ỹiabara' para thí'e la' dàliani nna, lànialá nna bexa latsi' cabi qui'ni iyaba ca cosa nna chi ga'na cą escrito nu cca quì'e, ą'hua qui'ni anía ná qui'ni ttíe. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ca enne' tsè'e lani Jesús loti' beyàỹie Lázaruá berią le' yerubàa nna benie qui'ni beyàcca bànią, pues làcą nna bedàa cą titsa' acerca de nu uccua. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Acca nuỹé tsè'ni ca enne' huía huá cą tatsà' cą Jesús, qui'ni biyénini cą testimonio qui' ca enne' qui'ni Jesús nna benie milágrua. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Acca ca fariséua nna ra luetsi quį: Hua ruyu ba le qui'ni labí biỹa tálią́ ri'u álá. Línna'áruhuá qui'ni iyáỹiani ca enne' ritanó cą na. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tsè'e tè tuchùppa ca enne' griego entre canu huía huèni adorar loti' gùl·la' fiéstaá. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Làcą nna bitsina' cą ru'a lo Felipe enne' yetsi Betsaida estado qui' Galilea nna, gutta'yúni cą bi nna ra cą: Señor, calatsi' tu' ila'ni tu' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Huía tè Felípea tatixà'ani bi Andrés; làniana Andrés lani Felípea nna gutixa'áni cabí Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Becàbi Jesús nna rèe cabi: Chi gul·lani tiempo nu ná señalado qui'ni Nubeyu' de Ỹiabara' nna thí'e la' dàliani. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Hualigani te' riquixa'ánia' le: Canchu ttu ỹua'xtíla labí tsu'ą́ liu'u yú para eyáttsą, pues turubą ná tulidàba. Pero canchu gattią nna, entonces iỹeni lena' gunną. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nuỹa tediba catsi'ínią la'a labą́ nna pues lą nna nittią. Pero nuỹa tediba labí nùyue canią por la'labàni quì'į miéntraste duą le' yetsiloyuį nna, lànuá nna runią preparar por ttu la'labàni nu labí ttíą quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Canchu nuỹa calatsi'į ccą́ siervo quia' nna, té qui'ni tanúą inte'; ą'hua làti thua' nna, nía huá thua siervo quíya'a. Nuỹa runią inte' servir nna, seguru ba rudàliani Tata quíya'a na. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Tsi'irúbani cani latsi' lóstu'a'. Annana, biani inia' cá. Tsí inia': Tata Dios, bedilàa cuią'lu' inte' de ca sufrimiento nu da' lo yì'į. Pero por nui lá daya' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata Dios quia', belue' cuią'lu' le' yétsiloyu qui'ni ná cuią'lu' enne' ỹeni, para qui'ni gudàliani cą cuią'lu'. De ra Jesús anía nna, biyeni tè ttu tsì'i de ỹiabara' nna rèe: Chi beluí'a' qui'ni ná' enne' ỹeni, ą'hua chi' gulue' huá ya' ą attu. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Biyeni báni ca enne' ỹétse'nía tsì'i Enne' gunnea nna pero ra la cą: ídiu' bá nuą'. Attu te cą nna ra cą: Ttu ángel gunèni bi ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús nna ra tè cą: Álahua por inte' acca gul·lani tsì'i Enne' gunnea sino por lebi'i ba para qui'ni tsíalatsi' le, ");
INSERT INTO zaaNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","annana chi gùl·la' tiempo para cca juzgar yétsiloyu; ą'hua annana nu ná príncipe qui' yétsiloyuį nna irù'ną fuera. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Canchu chi ichìtha cą inte' de loyu nna, làniana gunia' qui'ni iyaba ca enne' nna ccá cą sentir la' tsì'ilatsi' quia' por làcą. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Anía rèe para ttélini ti'iỹa la modo gattie. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Becàbi ca enne' nna ra cą ne: Chi biyénini tu' nu ra lo ley qui'ni Cristua nna tulidàba bànie. Bialacca ra lu' qui'ni Nubeyu' de Ỹiabara' nna caduel·la' ichìtha cą ne cá. Núní nua' Nubeyu' de Ỹiabara' nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Becàbi Jesús nna rèe cą: Por attu tiempo xcuichu to' teruba du enne' ná la'yani' entre lebi'i. Acca lebi'i nna lítha' le' la'yáni'į miéntraste dùe lani le, para qui'ni bittu gudàxu' la' chul·la le nìyya latsi' le, porqui'ni nu rida' le' chul·la nna labí yùl gaỹa díą. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Daca'tè du la'yani' lani lebi'i nna, lítsía latsi' le quì'e para qui'ni ccá le enne' qui' la'yani'. Beyacca bá gunne Jesús ca tìtsa'a nna, bede'e nía nna labiru bila'ni cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Pero màsqui'ba bila'ni cą iỹetse' ca milagro nu benie, pero labí huíalatsi' quį ne. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Anía modo nna uccua cumplir ca titsa' qui' Isaías enne' uccua profeta, loti' ra bi: Señor, núní chi huíalatsi'į ca titsa' nu riquixá'a tu' cá. Lani núní chi belue' Señor la'huacca quì'e cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Razón porqui'ni labí huíalatsi' quį, pues la'a mísmuba Isaías nna raáruhuá bi: ");
INSERT INTO zaaNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Tata Dios nna benie qui'ni làa ila'ni cą. Ą'hua gulèqquia chul·la telée la' riyeni qui' quį; Para qui'ni làa ila'ni cą, nìhua làa ttélini cą nna, Nìhua làa eyeqquia cą lani e para eyunie cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ca tìtsa'a gunne Isaías loti' bila'ni bi la'yani' bàni qui' Señor. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero siempre ba nuỹetse' ca enne' judíua nna huíalatsi' quį Jesús, hàstaá tuchùppa canu rigú'ubia' qui' caniá nna huía huá latsi' quį. Pero porqui'ni gùtsi báni cą gudàl·la ca fariséua cą fuera sinagoga qui' caniá, acca labí belue' cą qui'ni huíalatsi' quį Jesús, ");
INSERT INTO zaaNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","porqui'ni adila guyú'u latsi' quį gudàliani ca enne' cą tì'ca'la la' dàliani nu runna Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Gunne Jesús idìtsa nna rèe: Nu ríalatsi'į inte' nna, álahua tsua' teruba inte' ríalatsi'į sino ría huá latsi'į enne' guthel·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nu rila'nią inte' lani fe nna, rilá' huánią enne' guthel·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Inte' ná' la'yani' gul·lania' le' yétsiloyu, para qui'ni nuỹa tediba ríalatsi'į inte' nna labiru cuenią le' chul·la. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nuỹa riyénini ca titsa' quíyi'į, pero labí riguą cą lo lòstu'į nna, pues álahua inte' cueqquia' sentencia quì'į porqui'ni labí daya' ubèqquia sentencia qui' ca enne', sino para qui'ni iyaba ca enne' nna ccá cą salvo. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nuỹa rutsìbią inte' nìhua làa ríalatsi'į ca titsa' quíyi'į nna, pues tébá nu gunią na juzgar, quiere decir qui'ni méruání ca titsa' nu rinnía' nna ná nu gunią na sentenciar canchu chi gal·la' último tsá. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Porqui'ni inte' nna labí rinnía' según la' rulábalatsi' quíbá', sino Tata Dios enne' guthel·le'e inte' nna benie inte' mandado nu ná qui'ni íní'a'. ");
INSERT INTO zaaNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yúlírania' qui'ni enseñanza qui' Tata quíya'a nna ną́ para gata' la'labàni nu labí ttíą qui' ca enne'. Acca nu rinne yì'į nna ną́ según bá nu chi ra Tatáa inte' qui'ni quíxa'a'. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Antesca gal·la' fiesta qui' ca enne' judíua láą pascua, hua yù ba Jesús qui'ni chì' taáduą gal·la' hora quì'e para éde'e yétsiloyuį nna éyyee làti dua Tatáa. Pero tulidàba uccuatsi'ínie ca enne' qui'áa tsè'e cabi le' yétsiloyu, ą'hua belui'e ttu prueba nu adí teérulá xeni qui'ni hualigani uccuatsi'ínie cabi. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Numalua nna chìlá benią latsi' Judas Iscariote ỹi'ni Simón qui'ni gutią Jesús cuenta para gattie. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Pero hua yù bá Jesús qui'ni chi bete Tatáa làtsi' né'e iyábani ca cosa; hua yù huée qui'ni birie làti dua Tata Dios, níahuá éyyee. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","De chi gutò sé' cabía nna gùduli tìe lo méỹaá nna gutue capa qui'áa nna guỹi' tìe ttu toalla nna beteé'e na ru'a lúeá. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Làniana gùte'e inda le' ttu ttsá' nna gùdulue rìe nì'a ca discípulo qui'áa, bedibìtsi tìe cą lani toalla nu dùni ru'a lúeá. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Bitsina' bée làti re' Simón Pedrua nna, ra tè Pedrua ne: Señor, tsí cuią'lálu' quíi ca nì'a' cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Becàbi Jesús nna rèe bi: Nu runi yì'į nna labí ritelíni lu' ą anna, pero bitola nna hua ttelí báni lu' ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedrua nna ra tè bi e: Jamás labí quíi cuią'lu' ca nì'a'. Becàbi Jesús nna rèe bi: Canchu labí hue'él·la' lu' inte' quíià' ca nì'a lu' nna, entonces labí cuenta cue' ba lu' lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedrua nna ra bi e: Señor, gutìi cuią'lu' alàa tsua' teruba ca nì'l ', sino tsa'tsela tehuá ca nàya' nna iqquia' nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús nna rèe bi: Nu ná bá nàrì nna labí riquína'nią tsárią attu, sino quíi teruba ca nì'į, pues itubą ná nàrì. Lebi'i nna chi ná le nàrì, màsqui'ba alàa iyá le. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Anía rèe porqui'ni hua yù bée nuỹa nuá gutią ne cuenta làtsi' ná' canu labí cca guyu cą ne, acca rèe: Álahua iyá le ná nàrì. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Beyacca bá gutìie nì'a cabi nna, beyàccu'e capa qui'áa nna, bedúáníe lo meỹa nna rèe cabi: Tsi hua ritelíni le enseñanza bíỹacca benia' nui cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","14","Lebi'į nna reya le inte' Maestro nna Señor nna; labá ná nu rena le porqui'ni hualiba ná' Señor nna Maestro nna, atsi'íni chi gutíià' ca nì'a le. Ą'hua lebi'i nna dà huáni le quíi nì'a luetsi le. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nu beni yì'į nna ną́ ttu ejemplo para lebi'i. Tì'ba inte' chi benia' le servir nna, ą'hua liguni servir luetsi le. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Hualigani te' riquixa'ánia' le: Ttu siervo nna labí ną́ adí enne' ỹeni tì'chu xana' niá, ą'hua nu dia mandádua nna labí ną́ adí enne' ỹeni tì'chu enne' guthel·la' bi ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Chi hua yù bá le ca cosį nna, icca'rubà le canchu guni le cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Álahua por iyaba le nia' nui, porqui'ni hua nabia' bá te' canu chi becuí'a'. Pero hua té ttu Escritura nu ná qui'ni ccá cumplir nna ra: Nu ro lani ya'a nna runią ti'atsi ną́ amigo quia', pero guni lą́ contra inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Riquixx'ánia' le nui con tiempo ántesca íl·lani hora ccą́ cumplir, para qui'ni canchu chi ccą́ cumplir nna tsíalatsi' le qui'ni hualiba te' nu chi nia' le acerca de inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Hualigani te' nia' le: Nu gunią recibir mensajero ithél·la'a' nna, ti'átsi inte' bá nuá gunią recibir; ą'hua nu gunią inte' recibir nna, guni huą́ recibir enne' guthel·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Beyacca bá ra Jesús anía nna, tsi'írú bání uccuani latsi'e nna benie declarar nna rèe: Hualigani te' riquixa'ánia' le qui'ni nuỹa lá ttu le nna gutią inte' cuenta para gattia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Làniana gùdulo ca discípuluá gunna' lo luetsi cabi, belaba latsi' cabi qui' núdi'ló cabi nuá rèe anía. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ttu discípulo nu yala uccuatsi'íni Jesús nna rè'ni bi exa taá cuítte' e lo meỹa. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Làbi nna benìni Simón Pedrua seña para inàba titsa' bi Jesús nuỹa quí' nuá rèe anía. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Làbi nna guxua tè iqquia bi ỹìqquia Jesús loti' bila'ni bi seña nu beni Pedrua nna ra bi e: Señor, núní nua' gunią contra cuią'lu' lani la' ruthacca'ỹí cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Becàbi Jesús nna rèe: Nu huí'a' ettaxtíla bìtha nna, lą nuá. Làniana Jesús nna bedibìtha tìe ettaxtílaá nna bì'e Judas Iscariote ỹi'ni ttu nubeyu' lą́ Simón. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Guỹi' díbá Judas ettaxtílaá nna, guta'a tehuá Satanás lo lòstu'į. Jesús nna ra tìe Judas: Bè' taá latsi' lu' beni nu calatsi' lu' guni lu' ą'. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero nì ttúhuá ca discípulo ỹuàni lo meỹa nna labí gutéelíni cabi bíỹacca rèe na anía. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yà'ni qui'ni Judas ba dèni bolsa bél·liuá, acca ttu te cabi nna belaba latsi' cabi qui'ni Jesús nna rèe na qui'ni tsía xìą tayò'ą nu riquína'ni cabi para fiésta, o, qui'ni gute tí'ą para ca enne' pobre. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Acca de chi gutò Judas Iscarióteá ettaxtílaá nna, luegu taá birią. Chi uccua yèlà lània. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Biria díbá Judas, làniana ra Jesús: Annana Nubeyu' de Ỹiabara' nna thí' bi la' dàliani, ą'hua Tata Dios nna thí'e adí la' dàliani por iyaba nu ná qui'ni tté bí. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Canchu Tata Dios nna ridi'e adí la' dàliani por medio de nu runi Ỹi'nie, entonces Tata Dios nna gudàliani huée bi lani la'huacca quì'e, luegu taá gunie na. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Lebi'į, ỹi'ni to' quia', áti'to' teruba reyàtsa, làniana lanúrua' thu lani le. Hueyìla inte' ba guni le, pero tì'ba chi pá'a' ca judíua ą'hua nia' le anna: Làti éya'a' nna, labí ccani le ìta le. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ttu mandamiento cubi rinénia' le qui'ni guni le: Ligàppa la' tsì'ilatsi' luetsi le. Tì'ba inte' chi uccuatsi'í te' le, ą'hua lebi'į nna dàni le catsi'íni luetsi le. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ą' modo nna ennia iyaba ca enne' cuenta qui'ni ná le discípulo quia', canchu hualigani gulue' le qui'ni té la' tsì'ilatsi' lo losto' le lani ttu le nna para attu le nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedrua nna ra bi e: Señor, gani éyya cuią'lu'. Jesús nna ra tìe bi: Làti éya'a' nna, labí ccani lu' tanó tè lu' inte' anna, pero bitola nna ìta lu' lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedrua nna ra bi e: Señor, bianicca làa tanó tìa' cuią'lu' anna nì'i. Pues iria taá látsa'a' la'labàni quia' para gattia' por cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Becàbi Jesús nna rèe bi: Tsí hualigani ga'na lu' dispuesto gatti lu' por inte' cá. Pero inte' nna nia' lu': Tsunna vuelta gúnilatsi' lu' nna ína lu' qui'ni labí nabia'ni lu' inte', làniana cuetsi xcurúdiá. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Bittu echùl·la latsi' losto' le. Ná qui'ni tsíalatsi' le Tata Dios, pero lítsía huá latsi' le inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Le' litsi' Tàta quí'a nna yala nettia. Cáalá álahua ą́' ná nna, chìlá gutixa'ánia' le cá. Annana éya'a' huèni preparar lugar para lebi'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Éya'a' huèni preparar lugar para lebi'i, lànialá ìta' attu taỹia' le, para qui'ni làti thú'a', lebi'i nna tsé'e huá lé. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Hua yù bá le gaỹa éya'a', hua nabia' huáni le néda nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás nna ra tè bi e: Señor, labí yù tu' gaỹa éyya cuią'lu'. Ti'ala modo gunibia' tu' néda cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús nna rèe bi: Inte' ná' neda, ą'hua nu lígani nna la' labàni nna. Ni ttu enne' lanú ccani itá ru'a lo Tata Dios sino là teruba por inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Canchu hualigani nabia'ni le inte' nna, entonces chi nabia' huáni le Tata quí'a. Dèsdeba anna chi nabia'ni le Tatáa, chìhuá rila'ni li e nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felípea nna ra bi e: Señor, belue'ni cuią'lu' intu' Tatáa para qui'ni caỹen taá latsi' tu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús nna rèe bi: Felipe, chi gutsání nui renia' lani le, tsí bihua chi nabia'ni lu' inte' cá. Nu chi bila'nią inte' nna chìhuá bila'nią Tatáa. Biálacca ra lu': Belue'ni intu' Tatáa cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Tsí bihua ríalatsi' lu' qui'ni inte' nna ná' ttùba lani Tatáa ą'hua lèe lani inte' nna. Ca titsa' nu rinénia' le nna labí rìnne ya' cą por la' calatsi' quíbá', sino Tata quia' enne' dua lo lóstu'a', làbe runi ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Lítsía latsi' le quia' qui'ni ná' ttùba lani Tatáa ą'hua Tatáa nna dúe lo lóstu'a'. Pues màsqui'di lítsía latsi' le inte' por la'a mísmuba ca obra tsè' nu runia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Hualigani te' riquixa'ánia' le: Nuỹa tediba ríalatsi'į inte' nna, pues lą nna guni huą́ ca hecho nu runia'; ą'hua adí telá ca tsina tsè' nu gulue' la'huacca quia' gunią, porqui'ni inte' nna éya'a bá' làti dua Tatáa. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ą'hua iyate nu inàbani le Tatáa lani nombre quia', pues inte' nna guni ya' ą para qui'ni Tatáa nna thí'e adí la' dàliani por nu runia', porqui'ni ná' Ỹi'nie. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Biỹa diba inàba le lani nombre quia' nna, seguro ní inte' nna guni bá ya' ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Canchu catsi'íni le inte' nna, pues liguni nu ra ca mandamiento quíyi'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Inte' nna inábania' Tatáa para ithl·le'e attu enne' gunna la'ỹeni lo losto' le, para qui'ni thúe lani le tulidàba. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Née Espíritu Santo enne' gulue'nie le adí nu ná lí, pero yétsiloyu nna labí gunią ne recibir porqui'ni labí rila'nią ne, nìhua labí nabia'nią ne. Pero lebi'i nna hua nabia'ni li e porqui'ni dùe lani le ą'hua thúe lo losto' le nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Labí guthá'na' le huìdàbi, ìta' attu por lebi'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Áti'to' teruba reyàtsa nna labiru ila'ni yétsiloyu inte'; pero lebi'i nna ilá' báni le inte' attu; porqui'ni tulidàba bània', acca ą'hua lebi'i nna ccabàni le. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Làniana gunibia' le qui'ni inte' nna ttùba ná' lani Tata quíya'a, ą'hua lebi'i lani inte', inte' lani le nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nuỹa tediba nabia'nią ca mandamiento quíyi'į nna riguą cą nna, lą nna rului'ą qui'ni hualigani catsi'ínią inte'. Nu catsi'ínią inte' nna, entonces Tata quí'a nna cátsi'í huánie na; ą'hua inte' yala cátsi'í ti' ą nna ccá' declarar lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Làniana ra tè Judas ne (pero alàa Judas Iscarióteá): Señor, ti'ani modo acca ccá cuią'lu' declarar lani tsuą' intu' teruba, pero lani yétsiloyu nna bihua nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Becàbi Jesús nna rèe bi: Nu catsi'ínią inte' nna, lànuá riguą ca titsa' quia'; Tata quíya'a nna yala catsi'ínie na, ìta tu' nna ccá tu' ttùba lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nu labí catsi'ínią inte' nna, pues nìhua labí runią obedecer ca titsa' quia'. Ca titsa' nu chi biyénini le nna álahuá ná cą quia', sino qui' Tata quí'a enne' guthel·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nì riquixa'ánia' le ca cosį miéntraste reniírua' lani le. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pero Tatáa nna ithèl·le'e Espíritu Santo para gunie vez quia' nna gúnnée la'ỹeni lo losto' le nna gunie qui'ni ttelíni le iyaba ca enseñanza nu cca qui' Tata Dios, ą'hua gurèxee latsi' le iyate nu chi gutixa'ánia' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","La'ỹeni ruthá'na' lani le, la'ỹeni quia' runna' lani le, alàa luetsi la'ỹeni nu runna yétsiloyu. Bittu echùl·la latsi' losto' le, nìhua làa gátsini le. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Chi biyénini le qui'ni nia': Éya'a', pero ìta' attu. Canchu hualigani catsi'íni le inte' nna, entonces edacca' láni le qui'ni nia' éya'a' làti dua Tatáa, porqui'ni Tatáa nna adiru la'huacca té quì'e tì'chu inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Annana chi gutixa'ánia' le nui con tiempo ba ántesca íl·lani hora qui'ni ccą́ cumplir, para qui'ni canchu chi ccą́ cumplir nna éxalatsi' le ca tìtsi'į nna gappa le confianza lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Bíruhuá innée tegá' lani le, porqui'ni chi debiga' nu ná príncipe qui' yétsiloyuį, pero lani inte' nna labí derecho té quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero para qui'ni yétsiloyu nna gunibí'ą qui'ni catsi'í te' Tatáa, acca runi ba' conforme lani nu chi gunènie inte'. Lédúulí, léya'a'. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Inte' nna ccà'a' comparar tì'a ttu planta betsulí' nu hualigani runna fruto tsè'. Tata quíya'a nna née enne' runie na tsina. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Iyaba ca ná' plantį nu labí ribia lo quį nna, ichèccu'e cą. Ą'hua iyaba nu runna fruto nna, rutsìppèe cą para qui'ni gunna cą adí fruto. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lebi'i nna chìa ná le nàrì por ca titsa' nu chi gunénia' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Liguni seguir tsè'e le ttùba lani inte', ą'hua inte' lani le nna. Tì'a ttu ná' tùbà betsulí' labí cuía lúį canchu labí nèl·la'nią lani tùbà quì'į, nìhua lebi'i labí fruto gunna le canchu labí guni le seguir tsè'e le ttùba lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Inte' nna ccà'a' comparar tì'a tùbà betsulí', lebi'i ca nàya' nna. Nuỹa tediba runią seguir ttùba lani inte' tì'a inte' lani ą nna, lànuá nna yala fruto runną. Porqui'ni sin inte' nna, labí biỹa ccani le guni le. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nu labí runi seguir lani inte' nna, irù'ną fuera tì'a ca ná' tùbà betsulí' canu chi gubitsi. Pues redi' tè ri'u ca yà bìtsìa nna rudàl·la ri'u cą lo yi'. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Canchu guni le seguir lani inte', ą'hua ca titsa' quia' lo losto' le nna, línnaba iyate nu calatsi' le lani oración nna, huàccą. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Por nui nna dàliani Tata quíya'a, qui'ni ccá le tì'a ttu yà nu yala fruto runną; anía modo nna hualigani ccá le discípulo quia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ti'taání catsi'íni Tatáa inte', ą́' tehuá ná la' tsì'ilatsi' lo lóstu'a' para lani le. Liguni seguir lani la' tsi'ilatsi' quia' lo losto' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Canchu guni le nu ra ca titsa' quíyi'į nna, es qui'ni dua ba la' tsì'ilatsi' quia' lo losto' le; tì'ba inte' chi benia' nu gunèni Tatáa quíya'a inte' nna, dua ba la' tsì'ilatsi' quì'e lo lóstu'a'. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ca cosį nna chi gunénia' le para qui'ni thua la' redácca' latsi' quia' lo losto' le, ą́' modo nna labí biỹa la' redacca' latsi' ní eyàtsani le. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nui nna ną́ nu calátsa'a' qui'ni guni le: Ligàppa la' tsì'ilatsi' luetsi le ti'ba inte' uccuatsi'í te' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Lanú nuỹa té adí la' tsì'ilatsi' quì'į tì'chu ttu enne' iria latsi'į la'labàni quì'į por ca amigo quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Lebi'i nna ná le amigo quia' canchu guni le según bá nu rinénia' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Labiru épa'a' le siervo, porqui'ni ttu siervo nna labí yùą ca la' rulábalatsi' qui' xana' niá. Sino chi ná ri'u ttùba amigo lo tsìnį, porqui'ni chi gutixa'ánia' le iyaba nu chi ra Tàta quí'a inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Alàa lebi'į becué' le inte', sino qui'ni inte' la becuí'a' le nna chi bedú'a' le qui'ni tsía le equixá'a le ca titsa' nu gunna fruto, ą'hua qui'ni resultado qui' tsina qui' le nna tulidàba gúchią. Ą' modo nna iyate nu inàbani le Tatáa lani nombre quia', lèe nna gúnnée na qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nui nna rinénia' le: Qui'ni gulue' le qui'ni té la' tsì'ilatsi' lo losto' ttu le nna para attu le nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Canchu chi ritè le ca prueba por la' ruyudí' qui' yétsiloyu, pues éxalatsi' le qui'ni yà'lá telá inte' beyudí'ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Cáalá ná le ttùba lani yétsiloyu nna, entonces yétsiloyu nna yala catsi'ínią le ti'gáláà enne' qui'bį. Pero labí ná le ttùba lani yétsiloyu, sino qui'ni chi becuí'a' le le' yétsiloyu para ccá le enne' quia', acca yétsiloyu nna labí cca guyuą le. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bittu iỹùl·lani le ca titsa' nu chi pá'a' le: Ttu huènitsina nna labí ną́ adí enne' ỹeni tì'chu xana' niá. Chi rutsia latsi' quį inte' nna, pues ą'hua lebi'i nna gutsia latsi' quį le. Cáalá iyaba cą rigua cą ca titsa' quia', entonces ą'hua ca titsa' qui' le nna cúa huá cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pero iyaba ca nui nna guthácca' cą le porqui'ni ríalatsi' le inte'; anía guni cą porqui'ni labí nabia'ni cą Enne' guthèl·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Cáalá labí daya' yétsiloyuį para inéni ya' cą, entonces labí lá tul·la' dà cą cá, pero annana labiru modo té para ína cą qui'ni bihua nabia'ni cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nuỹa ruyudí'ą inte' nna, ruyudí' huą́ Tata quíya'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Cáalá labí benia' ca prueba de la'huacca lo quį canu nìdiruani ttu enne' lanú chi beni nna, entonces labí lá tul·la' dà cą. Pero chi bila'ni cą ca obra de la'huacca nu chi benia', atsi'íni ruyudí' lá cą inte', tsà'tsela tehuá Tata quíya'a ruyudí' cą nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nui nna runią cumplir nu chi ga'na escrito lo ley qui' quį nna ra: Nìdi ttu falta labí té quia', atsi'íni labí uccua guyu cą inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pero canchu chi íl·lani enne' ná Consolador ithél·la'a' de làti dua Tatáa nna, pues lèe nna gúnnée la'ỹeni lo losto' le. Enní'į nna née Espíritu Santo enne' ìta por mandado qui' Tatáa nna íl·lanie le' yétsiloyu. Lèe nna innie titsa' lígani acerca de inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ą'hua lebi'i nna quixá'a huá le nu cca quia' porqui'ni tsè'e le lani inte' dèsdeba gùdulua' tsina quia' le' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Rinénia' le ca cosį con tiémpubá, para qui'ni canchu íl·lani ca prueba lani le nna bittu ccá le apartar lo néda lígani. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Porqui'ni labiru hue'él·la' cą le gá'a le le' ca sinagoga qui' quį. Ą'hua huàl·lani tsá qui'ni canchu nuỹa diba guttią le nna, gulaba latsi'į qui'ni anía modo nna runią Tata Dios servir. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iyaba ca nui guthacca' cą le porqui'ni labí nabia'ni cą Tata Dios nìhua inte' nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pero dèsdeba anna riquixa'ánia' le ca cosį, para qui'ni canchu chi gal·la' hora nna entonces éxalatsi' le qui'ni chìlá gutixa'ánia' le con tiempo. Bihua gutixa'ánia' le nui dèsdeba neru, porqui'ni gùduba' lani le. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero annana éya'a' làti dua enne' guthèl·le'é inte'. Ni ttú huá le nna bihua inàba titsa' le inte': Gání éyya cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pero yala triste cani latsi' losto' le porqui'ni chi pá'a' le ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Riquixa'ánia' le nu ná lí taá, qui'ni para bien qui' ba le acca éya'a'; porqui'ni canchu labí éya'a' nna, entonces labí ìta Enne' ná Consolador lani le. Pero canchu éya'a' nna, ithel·la' ye' e para thúe lani le nna gata' la'ỹeni lo losto' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ą'hua canchu chi íl·lanie nna guluè'nie iyábani ca enne' qui' yétsiloyu qui'ni ná cą canu tul·la', ą'hua qui'ni hua té ttu néda lígani para làcą, ą'hua qui'ni re' ttu castigo nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","De ca tul·la', porqui'ni labí ríalatsi' quį inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","De lo néda lígani, porqui'ni inte' nna de edàya' ru'a lo le nna éya'a ba' làti dua Tatáa ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","De juicio, porqui'ni numalua nna chi biria sentencia quì'į para tsíą castigo nna labiru cu'úbi'ą yétsiloyuį. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Iỹétse'érulá ca enseñanza cca te' épa'a' le, pero anna tè nna labí ná le preparado para gúchia le cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero canchu chi íl·lani Espíritu Santo entonces lèe nna íchi'e le adí lo néda nu ná lí; porqui'ni labí innie por nu cca qui'bée, sino qui'ni innie iyaba nu riyéninie; ą'hua gunie qui'ni ccá le saber ca cosa nu chì' ccálá. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Anía modo nna gudàlianie inte', porqui'ni thí'e de nu ná quia' nna gunie qui'ni ccá li ą saber. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Iyaba nu té qui' Tatáa nna, quíbá' ną́. Acca nia' qui'ni Espíritu Santo nna thí'e de nu ná quia' nna gunie qui'ni ccá li ą saber. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Chì' taáduą íl·lani hora labiru ila'ni le inte', pero áti'to' taá bitola nna ila'ni le inte' attu; porqui'ni éya'a' làti dua Tatáa. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Làniana ra luetsi tuchùppa ca discípulo qui'áa: Biani nuą' rèe ri'u: Chi' taáduą íl·lani hora labiru ila'ni le inte', pero áti'to' taá bitola nna ila'ni le inte' attu porqui'ni éya'a' làti dua Tatáa. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Acca ra luetsi cabi: Biani nua' rèe: Áti'to' teruba reyàtsa cá. Labí ritelíni ri'u biỹa quí'ní nua' rinnie. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Gutelí báni Jesús qui'ni uccua latsi' cabi inàba titsa' cabi e, acca rèe cabi: Tsí rinàba titsa' luetsi le acerca de qui'ni nia': Chì' taáduą íl·lani hora labiru ila'ni le inte', pero áti'to' taá bitola nna ila'ni le inte' attu cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Hualigani te' riquixa'ánia' le qui'ni yala ehuiní'ni latsi' le nna cuetsi le, atsi'íni yétsiloyu nna edacca' lánią. Màsqui'ba yala triste ccáni le, pero la' rehuiní' latsi' qui' le nna eyacca lą́ la' redacca' latsi'. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tì'a ttu niula nna, canchu chi ritsina' huatsa to' quì'į, pues yala dolor ràppą porqui'ni chi gùl·la' hora quì'į. Pero de chi té huatsa to' qui' niá nna, entonces labiru dá' latsi'į dolor qui' niá de tántua la' redacca' latsi' qui'ni chi gùlia ttu nító' le' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ą'hua lebi'į nna, canchu anna cani triste latsi' le, pero hualá' bá te' le attu vuelta, làniana yala edacca' latsi' losto' le nna lanú nuỹa cúą la' redacca' latsi' de lo losto' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Làniana labiru biỹa inàba titsa' le inte'. Hualigani te' riquixa'ánia' le: Biỹa díbá inàbani le Tatáa lani nombre quia' nna, gúnnée na qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Labí biỹa chi gunàba le lani nombre quia'; acca línnaba nna huadi' le, para qui'ni gata' iỹeni la' redacca' latsi' qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ca enseñánzį nna chi gunénia' le por medio de comparación; pero huàl·lani tsá canchu chi labiru inénia' le lani comparación, sino qui'ni directamente taá quixa'ánia' le nu cca qui' Tatáa. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Canchu chi i'yu tsáa nna, inàba le lani nombre quia', pero labí cáduel·la' gatta'yúnia' Tatáa por lebi'i, ");
INSERT INTO zaaNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","pues la'a mísmuba Tatáa nna catsi'ínie le, porqui'ni lebi'i nna chi catsi'íni le inte' nna chi ríalatsi' le qui'ni birí'a' làti dua Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Gùdaya' de ru'a lo Tatáa nna gul·lania' yétsiloyu, pero annana guthá'na' yétsiloyu nna éya'a' attu làti dua Tatáa. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Làniana ra ca discípulo qui'áa ne: Annana chi rinèni cuią'lu' intu' para qui'ni ttélini tu' claru taá, pues labiru biỹa comparación ní runi cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Annana ritelíni tu' qui'ni hua yù bá cuią'lu' iyaba ca cosa, acca labí caduel·la' qui'ni nuỹa inàba tìtsa'ą cuią'lu' adí; por nui nna ríalatsi' tu' qui'ni da' cuią'lu' de làti dua Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús nna ra tìe cabi: Tsí hualigani chi ríalatsi' le cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Chì' taáníduą gal·la' hora, pero ą'hua chi gùl·la' hora qui'ni gathilàlia le nna gàtti' tébá néda thí' le, áturúbá inte' guthà'na le. Pero labí ná teruba', sino qui'ni Tatáa nna dùe lani inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ca tìtsi'į nna chi gunénia' le para qui'ni gappa le adí confianza lani inte' nna gata' la'ỹeni lo losto' le. Le' yétsiloyuį nna nuỹébá ná nu thacca' le; pero licuèqquia tsìttsì latsi' le, porqui'ni inte' nna chi benia' vencer yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Beyacca diba gunne Jesús ca tìtsi'į nna, guchìtha tè lúe ỹiabara' benie oración nna rèe: Tata Dios quia', chi gùl·la' hora nna rinába'a qui'ni gudàliani cuią'lu' Ỹi'ni cuíą'lu'į, para qui'ni Ỹi'ni cuíą'lu'į nna gudàliani huée cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Porqui'ni chi bete cuią'lu' la'huacca quì'e para quée Señor sobre iyábani ca enne', para gutie la'labàni nu labí ttíą qui' iyaba canu bete cuią'lu' làtsi' né'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nui nna ną́ la'labàni para siempre: qui'ni gunibia' cą cuią'lu' porqui'ni tùteruba cuią'lu' ná Dios, ą'hua Jesucristo enne' chi guthèl·la' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Inte' nna chi bedáliania' cuią'lu' le' yétsiloyu nna; chi birialània' tsina nu benna cuią'lu' gunia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Acca Tata Dios quia', bedàliani cuią'lu' inte' èxabá lani cuią'lu' lani la'a mísmuba la' dàliani nu guta' quia' lani cuią'lu' dèsdeba ántesca cue' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Chi benia' cuią'lu' declarar ru'a lo ca enne' benna cuią'lu' làtsi' nàya' tse'e yétsiloyu; quì'ba cuią'lu' uccua cabi, pero chi benna cuią'lu' cabi làtsi' nàya'. Làcabi nna chi runi cabi obedecer titsa' qui' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Annana chi yù cabi qui'ni iyaba nu té quia' nna cuią'bálu' benna lu' ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Porqui'ni chi gutixa'áni ya' cabi ca titsa' nu ra cuią'lu' inte'; làcabi nna chi beni cabi cą recibir nna chi ga'na cabi seguro qui'ni hualigani dáyá' de ru'a lo cuią'lu', ą'hua ríalatsi' cabi qui'ni cuią'bálu' ènni'ą' guthèl·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ratta'yúnia' cuią'lu' por làcabi; pero bihua ratta'yúa' por yétsiloyu, sino por ca enne' chi benna cuią'lu' làtsi' nàya', porqui'ni quì'ba cuią'lu' ná cabi. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Iyate nu ná quia' nna ná huą́ qui' cuią'lu'; ą'hua iyate nu ná qui' cuią'lu' nna ná huą́ quia'. Làcabi nna chi rudàliani cabi inte' le' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Lanúruá' té le' yétsiloyu porqui'ni néda taá chi déyu'á' para él·lania' làti dua cuią'lu'. Pero làcabi nna tse'e bá cabi le' yétsiloyu. Tata Dios Tsùna', rinabá'a' por iyaba ca enne' chi benna cuią'lu' lani inte' qui'ni hué' cuią'lu' cabi cuidado lani itute poder qui' cuią'lu', para qui'ni ą'hua làcabi nna ccá ttùba la' rulábalatsi' qui' cabi tì'ba ri'u ná ri'u ttùba. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ituba tiempo de gurénia' lani cabi le' yétsiloyu nna, bée' ya' cabi cuidado según voluntad qui' cuią'lu'. Canu benna cuią'lu' làtsi' nàya' nna, seguru ni bée' ya' cabi cuidado; nìdi ttu cabi labí gunitti, sino làteruba nu chi ną́ destinado dèsdeba antes para nittią, tì'a nu chi ra ba lo Escritura. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Pero annana chì' teníduą él·lania' ru'a lo cuią'lu', pero rinnia' ca tìtsi'į miéntraste reniírua' le' yétsiloyu, para qui'ni gata' iỹeni la' redacca' latsi' qui' cabi tì'a té la' redácca' latsi' lo lóstu'a'. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Chi betí'a' titsa' qui' cuią'lu' lani làcabi. Pero yétsiloyu nna ruyudí' lą́ cabi porqui'ni labí ná cabi ttùba lani yétsiloyuį, tì'tehuá inte' labí ná' tnu yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Bihua rinába'a qui'ni cúa telá cuią'lu' cabi le' yétsiloyu, sino qui'ni gudilàa cuią'lu' cabi de lo nu ná mal. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Labí ná cabi nu yétsiloyu, tì'ba inte' labí ná' nu yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Rinába'a' qui'ni guni cuią'lu' qui'ni ccá cabi yà'latsi' enne' losto' nàrì por medio de ca enseñanza qui' cuią'lu'; titsa' qui' cuią'lu' nna ną́ puru taá nu ná lí. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tì'ba guthèl·la' cuią'lu' inte' yétsiloyu, ą'hua inte' nna rithél·la' ya' cabi para tsía cabi ituba yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Inte' nna nì bá riria látsa'a' la'labàni quia' nna gutée ya' ą por làcabi, para qui'ni làcabi nna ccá huá cabi yà'latsi' enne' losto' nàrì por medio de ca titsa' lí qui' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ratta'yúa', pero alàa tsuą' teruba por làcabi, sino ą'hua por adí canu tsíalatsi' cabi inte' por predicación qui' cabi, ");
INSERT INTO zaaNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","para qui'ni iyaba cabi nna ccá ttùba la' rulábalatsi' qui' cabi tì'ba cuią'lu' Tàta lo lóstu'a' ą'hua inte' lani cuią'lu', qui'ni ą'hua làcabi nna ccá cabi ttùba lani ri'u. Anía modo nna tsíalatsi' ca enne' tsè'e yétsiloyu qui'ni cuią'bálu' guthèl·le'e inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","La' dàliani nu benna cuią'lu' quia' nna, chi betée ya' ą lani làcabi, para qui'ni ccá cabi ttùba tì' tehuá ri'u ná ri'u ttùba; ");
INSERT INTO zaaNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","inte' lo losto' cabi, ą'hua cuią'lu' lo lóstu'a'. Anía modo nna ccá cabi completamente taá ttùba, para qui'ni ca enne' tsè'e yétsiloyu nna ennia cabi cuenta qui'ni cuią'bálu' guthèl·le'e inte' nna catsi'íni cuią'lu' cabi tì'tehuá catsi'íni cuią'lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tata Dios, canu chi benna cuią'lu' para ccá cabi enne' quia' nna, calátsa'a' qui'ni làti thú'a' nna tsé'e huá cabi lani inte' para qui'ni ila'ni cabi la' dàliani nu chi benna cuią'lu' quia'; porqui'ni catsi'íni cuią'lu' inte' dèsdeba antes càla cue' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata Dios quia', tulidàba ná cuią'lu' enne' completamente tsè', màsqui'ba ca enne' tsè'e le' yétsiloyu labí nabia'ni cą cuią'lu'; pero inte' nna hua nabia' te' cuią'lu', ą'hua canu tsè'e lani inte' annana hualigani chi yù cabi qui'ni guthèl·la' cuią'lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Por medio de inte' nna chi nabia'ni cabi cuią'lu', ą'hua chì' guniíruhuá' qui'ni gúnibia' cabi cuią'lu' adí, para qui'ni la' tsì'ilatsi' nu té qui' cuią'lu' lani inte' nna thua huą́ lo losto' cabi, ą'hua inte' lani cabi nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Beyacca ba gunne Jesús ca tìtsa'a nna, beria tìe nía nna huíe lani ca discípulo qui'áa attu ládulá yò bitsi láą Cedrón. Nía nna re' ttu huerto. Gutà'a tè Jesús nía, ą'hua ca discípulo qui'áa. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas nu gutią ne cuenta nna nabia' huánią huértuá, porqui'ni iỹé vuelta tsè' huía Jesús nía lani ca discípulo qui'áa. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Acca, taxi' chì Judas nuỹétse'ní ca soldado ą'hua ca policia canu guthèl·la' ca sacerdote principal nna ca fariséua nna. Bitsina'ą lani cą nía lani linterna yí' l·le antorcha l·le, hàstaá espada l·le yù'u ná' quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pero Jesús nna hua yù bée iyaba ca cosa nu guthácca' cą ne, acca birie táttse'e cą nna rèe cą: Nuni reyìla le. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Becàbi cą nna ra cą ne: Jesús nu yetsi Nazaret. Làniana ra tè Jesús cą: Inte' bá nua'. Judas, nu beni còntre lani la' ruthacca'ỹí nna du huą́ lani cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Lótaá biyénini cą ra Jesús: Inte' bá nua', entonces bebíga' tè cą dàcca' cuè'e lá quį nna gubìxi chì cą loyu. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Bedenàba titsa' tìe cą attu nna rèe: Núní reyìla le. Làcą nna ra cą: Jesús nu Nazaret. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Becàbi Jesús nna rèe cą: Chìỹá nia' le qui'ni inte' nuą' nna, pues canchu inte' nuą' reyìla le nna, pero líhue'él·la' ca enne' quíyi'į éyya cą cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","De rèe anía nna, uccua cumplir ca titsa' quì'e loti' benie oración lani Tata Dios nna rèe: De lo iyaba canu benna cuią'lu' làtsi' nàya' nna, bè' ya' cą cuidado hasta el fin. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Làniana discípulo lá Simón Pedrua nna dèni bi espada, gulèqquia bi ą le' vaina quì'į nna bè' chì bi ttu nu ná siervo qui' enne' ná huexána' qui' ca sacerdótea nna guchu bi yéti nàgui'į lado bàni. Siérvuá nna láą Malco. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús nna ra tìe Pedrua: Begú'u espada qui' lu'ą' lugar quì'į. Tsi bihua yù lu' qui'ni inte' nna ga'na bá' dispuesto ccá' sufrir iyate nu chi nani Tata quíya'a qui'ni ttía'. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Làniana ca soldádua lani capitán qui' caniá, ą'hua ca policia nu guthèl·la' ca judíua nna, iyaba cą bedàxu' chì cą Jesús preso nna bexìqquia cą ca né'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Guche' tè cą ne ru'a lo yà'la tè Anás porqui'ni uccuą suegro qui' Caifás nu uccua huexána' qui' ca sacerdótea ida lània. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás nuá bete consejo lani ca judíua nna rą qui'ni mejor la gatti tùteruba enne' tì'ca'la l·lúỹa latsi' itute yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Denó tè Simón Pedrua Jesús lani attu discípuluá. Nu ná huexána' qui' ca sacerdótea nna nabia' bánią discípuluá, acca gutà'a tè discípuluá lani Jesús hàstaá le' corredor qui' enne' ná huexána' qui' ca sacerdótea. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedrua nna gulèda ba bi ru'a puértaá lo néda lá. Làniana biria tè discípulo enne' nabia'i sacerdótea nna gunàba bi permiso lani niula nu rue' cuidado ru'a puértaá qui'ni tté Pedrua liú'u. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Làniana ttu criada nu rue' cuiado ru'a puértaá nna ra tìą Pedrua: Tsí álahua ná huá lu' discípulo qui' nubéyu'ą' cá. Pedrua nna ra bi ą: Labí ná'. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Dàa tè ca huenitsìna nna ca policia nna ru'a ttè porqui'ni yala idíl·la' cca lània acca becùà' cą yí'. Pedrua nna du hua bi ru'a ttèa lani cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nu ná principal entre ca sacerdótea nna gunàba tìtsa'ą Jesús acerca de ca discípulo qui'áa, ą'hua acerca de biỹa nuá ruthète'nie cabi. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Becàbi Jesús nna rèe: Inte' nna dàcca'lo taá chi gutixa'ánia' ca enne', ą'hua tulidàba betía' enseñanza le' ca sinagoga nna le' templuą' làti retùppa iyaba ca enne' judíuą' nna, pues labí biỹa titsa' gàttsi' ní chi gunnía'. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Biánícca rinàba titsa' lu' inte' nì'i. Nà' bá gunàba titsa' canu chi biyénini cą ca enseñanza nu gutixà'a'; pues làcą nna hua yù bá cą nu gunnía'. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Lótaá ra Jesús anía nna, ttu policia nu du guardia nía nna gutìni ní'į lúe nna rą ne: Tsí ą́' dàni lu' ecàbini lu' nu ná sacerdote principal cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Becàbi Jesús nna rèe na: Canchu gunnía' ca titsa' nu làa dacca' inne ri'u nna, pues gùnà biỹa mal ní nuą' níá'; pero canchu hualiba nu níyi'į nna, biálácca rue' lu' inte' nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Bitola nna guthèl·la' Anás ne ru'a lo Caifás nu ná meru gani huexána' qui' iyaba ca sacerdótea. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Du bá Pedrua ru'a ttè huètsa'a nna ra tè cą bi: Ttu discípulo qui' nubéyu'a hua ná lu' álá. Pedrua nna labí guỹí'che' bi sino ra lá bi: Labí ná'. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Làniana attu siervo qui' nu ná huexána' qui' ca sacerdótea, pariente qui' nu guchu Pedrua yéti naga' niá nna rą bi: Tsí álahua lu' nuá bilá' te' lani Jesús nà' le' huértuą' cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Labí guỹí'che' Pedrua attu vuelta. Lània taá nna gurètsi chì xcurúdiá. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Díla to' ba lània nna gulèqquia cą Jesús le' yú'u qui' Caifás nna guche' cą ne le' lí'a palacio qui' gobernador Pilato. Ca judíua nna labí gutà'a cą le' paláciuá, porqui'ni según bá costumbre qui' ca judíua nna ná tul·la' canchu gá'a cą le' yú'u qui' canu labí ná raza judío, entonces labí cca go cą para guni cą celebrar fiesta nu reya cą pascua. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Làniana biria Pilátua gunènią cą nna rą: Biani queja ní rutsia le contra nubéyu'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Becàbi cą nna ra cą: Cáalá bihua mal benią nna, labí tahua' tu' ą ru'a lo cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilátua nna ra tìą cą: Lithi' bá ą nna liguni ti'iỹa calatsi' le lani ą según bá nu ra lo ley qui' le nì'iỹa. Becàbi ca judíua nna ra cą na: Gobierno qui' cuią'lu' labí runną qui' tu' derecho para gutti tu' nuỹa. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","De ra cą nía nna gùdulo uccua cumplir nu chi ra Jesús para ttelíni biỹa clase de lù'uti ní ná qui'ni gattie. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Làniana gutà'a Pilátua le' paláciua attu nna benią mandado qui'ni tahua' cą Jesús ru'a lúį. Làniana gunàba tìtsa'ą ne nna rą: Tsí rey ná lu' qui' ca judíuą' cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Becàbi Jesús nna rèe na: Tsí ra lu' nui lani propio ba la' rulaba latsi' qui' lu', o, tsí nuỹaáruá rą lu' nu cca quia' áccá. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Becàbi Pilátua nna rą ne: Tsí ína ri'u judío ná' cá, pues ca sacerdote principal qui' ca judíua lani adí ca enne' yetsi qui' lu'ą' bá chi bete cą lu' cuenta lani inte'. Biani beni lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Becàbi Jesús nna rèe na: La' rigú'ubia' quia' nna labí ną́ nu yétsiloyuį; cáalá nu yétsiloyuį bá ná la' rigú'ubia' quia' nna, entonces ca amigo quíya'a nna gutìl·la lá cą lani canu bedàxu' cą inte' preso para qui'ni làa gute cą inte' cuenta làtsi' ná' ca judíuą'; pero la' rigú'ubia' quíya'a nna labí ną́ nu nì. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ra tè Pilátua ne: Entonces, rey ná lu' álá. Becàbi Jesús nna rèe: Cuią'bálu' chi ra qui'ni ná' rey, pues para nui bá chi gùlia', ą'hua para nui huá chi dú'a' le' yétsiloyuį para quixa'a' nu ná lí; iyaba canu ríalatsi' quį nu ná lí nna rudà naga' quį quia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilátua nna rą ne: Biani nua' nu ná lí nì'i. Beyacca bá rą anía nna birią attu làti ribèda ca judíua nna rą cą: Nìdi ttu falta làa retsèla te' quì'į; ");
INSERT INTO zaaNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","pero lebi'į nna té costumbre qui' le rinàba le qui'ni gudilá'a' ttu preso tsá pascuį. Tsí hua calatsi' le gudilá'a' rey qui' lebi'į ca judío cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Làniana iyaba cą idìtsa tsè' guretsiyà'a cą attu nna ra cą: Alàa nui l·lą́, sino Barrabás. Barrabás nna tíą litsi' ìyyà porqui'ni uccuą ubànà. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Làniana beni Pilátua mandado gudàxu' cą Jesús nna hué' cą ne lani cuarta. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ca soldádua nna beni cą ttu corona yèttse' nna gulù'u cą na íqquie. Begàccu' tè cą ne ttu lári' morado. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Làniana gutìni ná' quį lúe nna beni tè cą ne burla nna ra cą: Viva, Rey qui' ca judío. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Làniana biria Pilátua attu nna rą ca judíua: Nì che' ya' ą ru'a lo le para ennia le cuenta qui'ni nìdi ttu falta làa retsèla te' contrį. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Biria tè Jesús yù'u íqquie corona yèttsi'a nna nàccu'e lári' moráduá nna. Làniana ra Pilátua cą: Nì bá rúdú ya' ą ru'a lo le. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ca sacerdote principal nna ca policia qui' caniá nna bilá' báni cą ne nna, yala idìtsa guretsiyà'a cą nna ra cą: Betaá' ą lo curutsi, betaá' ą lo curutsi. Ra tè Pilátua cą: Líthi' ą lebi'i bá, liutá' ą lo yà curutsi, qui'ni inte' nna labí biỹa falta retsèla te' quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Becàbi ca judíua nna ra cą na: Intu' nna té ttu ley qui' tu'; según nu ra lo ley qui' tu'į nna cca bą merecer gattią, porqui'ni la'a labą́ rudàlianią nna rą qui'ni ną́ Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Biyeni báni Pilátua ra cą anía nna, adí telá gùtsinią. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Bedeyà'a gáabą́ attu le' paláciuá nna rą Jesús: Gání enne' ní ná lu'. Pero Jesús nna labí becàbinie na. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Acca Pilátua nna rą attu: Tsí bihua ecàbini lu' inte'. Tsí bíhuá yù lu' qui'ni té bá poder quia' para gunia' mandado qui'ni gatti lu' lo curutsi nna té huá poder quia' annana para gudilá'a' lu' nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Becàbi Jesús nna rèe: Nìdi tí' poder labí té qui' lu' contra inte' sino por voluntad qui' Tata Dios enne' dua ỹiabara', acca adila tul·la' dàa nu betią inte' cuenta làtsi' ná' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Dèsdeba làniana yala uccua latsi' Pilátua gudilą̀ Jesús; pero ca judíua nna adila idìtsa beni cą seguir gunne cą nna ra cą: Canchu gudilà cuią'lu' nubéyu'į nna entonces labíru ná lu' amigo qui' César enne' romano ná rey, porqui'ni nuỹa diba rudàliani la'a labą́ reną qui'ni ną́ rey, pues ą́' modo nua runią contra César. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Biyeni báni Pilátua ra cą anía nna, gulèqquia tìą Jesús fuera. Làniana gùdua tèníą lo xila' xenia nu re' lo ttu plataforma nu de íyya, lani titsa' hebreo nna lą́ Gabata, làti ribeqquią sentencia qui' ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tsá lània nna ná tsá víspera qui' pascua, ttu tsì'nu hora tì'ga nuá nna ra Pilátua ca judíua: Nì bá du enne' ná rey qui' líį. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero làcą nna guretsiyà'a cą nna ra cą: Gatti bą, betaá' ą lo yà curutsi. Pilátua nna ra tìą cą: Tsí ína ri'u calatsi' le qui'ni gutá'a' enne' ná rey qui' líį lo curutsi cá. Becàbi ca sacerdote principal nna ra cą: Lanuru attu rey té qui' tu' sino làteruba César. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Làniana bete Pilátua ne cuenta làtsi' ná' quį para gutà' cą ne lo curútsiá. Acca bedàxu' tè cą Jesús nna guche' cą ne para gattie. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Behuà'ni tè cą Jesús curutsi qui'áa nna, birie para lugar láą Iqquia Bega' Yatti, titsa' hebreo nna láą Gólgota. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nía nna gùda cą ne lo curútsiá. Betàa' huá cą lo curutsi chuppa ca nubeyu'; ttuą ttu ttu lado, Jesús nna lahui'. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bedia huá Pilátua ttu letrero betaá'ą na iqquia curutsi qui' Jesús: Letrérua nna rą: JESÚS ENNE' NAZARET, REY QUI' CA ENNE' JUDÍO. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nuỹetse' ca judíua bìl·la cą letréruá, porqui'ni làti betàa' cą Jesús lo curútsia nna ga'ną exa taá ciudáad; ą'hua letréruá nna gunnią tsùnna clase de titsa': titsa' hebreo nna, titsa' griego nna, titsa' latín nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ca sacerdote principal qui' ca judíua nna ra tè cą Pilátua: Bittu gudua cuią'lu': Rey qui' ca enne' judío, sino adila tsa' gúdia lá lu' qui'ni làganią nna reną: Rey qui' ca judío ná'. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Becàbi Pilátua nna rą: Nu chi bedú'a' nna nà' dua bą́. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Beyacca bá betàa' ca soldádua Jesús lo curútsia nna, guỹi' tè cą ca ỹuéa nna beni cą cą tappa l·là'a, ttu pedazo qui' ttu ttu ca soldádua. Guỹi' huá cą camisa qui'áa, pero nuá nna ną́ puro tejido taá dèsdeba íqquiará' hàstaba ỹarèe'. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Làniana ra luetsi quį: Bittu ichèda' ri'u ą sino gudàl·la ri'u rifa nuỹa la ri'u gal·la' ri'u ą. Anía modo nna uccua cumplir nu ga'na lo Escritura làti rą: Gùl·la'ání cą ca ỹó ya'a nna, Bedàl·la cą rifa lo quį. Anía tegani beni ca soldádua. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nàna qui' Jesús lani ỹìla bía, ą'hua María niula qui' Cleofas, ą'hua María enne' Magdála nna dàa cabi exa taá làti du curutsi qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Bilá' báni Jesús nàna qui'áa, ą'hua discípulo enne' yala uccuatsi'íni Jesús nna du huá bi nía, làniana rèe nàna qui'áa: Niula, nà' bá du ỹi'ni lu'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Bitola nna rèe discípuluá: Nà' bá du nàna qui' lu'ą'. Acca dèsdeba làniana bedi' discípuluá María le' litsi' bi. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Gutè ba nuá nna, hua yù bá Jesús qui'ni chìa beyacca quì'e benie iyábani tsina nu dé'e gunie. Pero para qui'ni ccá cumplir iyátení nu ra lo Escritura nu cca quì'e, acca gunnie attu nna rèe: Ribìtsia' inda. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nía nna du ttu ré'è tsa'ti' bą vinagre. Ca soldádua nna bedibìtha cą ttu esponja lani vinágrea nna bedua cą na lo ttu yà nna betsìni cą na rú'e. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Beyacca bá gù'yèe vinágrea nna ra tìe: Iyaba chi uccua cumplir. Bedètta' tè íqquie nna gunne tè latsi'e idí' latsi' ní nna gùttìe. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tsá lània nna ná qui'ni guni ca judíua preparar para pascua qui' quį. Para qui'ni làa eyà'na ca cuerpo qui' canu tá' lo ca curutsi nía canchu chi gal·la' tsá edi' latsi' caniá, yà'ni qui'ni tsá fiesta nna ną́ ttu tsá ỹeni gani; acca ca judíua nna gunàbani cą Pilátua permiso para quíttsá telá cą ca latha canu tá' lo ca curútsia para qui'ni gatti xìa cą nna ítua cą nía. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Bitsina' ba ca soldádua làti dàa ca curútsia nna gutìttsa taá cą latha ttu nu tá' nía, anía tehuá gutìttsa cą latha áttu nuá nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero gubiga' bá cą làti tá' Jesús lo curútsia nna, bila'ni cą qui'ni chi gùttie nna, labí gutíttsá cą látheé. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero ttu soldádua nna gudą ttu lanza ru'a costilla quì'e nna biria tè réni nna inda nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Enne' bila'ni ca cosa nna ná bi testigo acerca de nu uccua, acca nu riquixá'a bi nna ną́ lígani. Làbi nna yù bi qui'ni riquixá'a bi nu ná lí, para qui'ni ą'hua lebi'i nna tsíalatsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Anía modo nna uccua cumplir nu ga'na lo Escritura acerca de lèe ántesca bìtee yétsiloyu, làti ra: Nìdi ttu tsitta yu'ée labí gáttsá. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ą'hua attu lettia nna ra: Iỹetse' ca enne' ilá'ni cą Enne' guda cą lanza. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Gutè díbá beni cą iyaba ca cosa nna, làniana José enne' yetsi Arimatea nna uccua hua bi ttu discípulo qui' Jesús, pero labí guréni bi dàcca'lo tè lani ca enne' huíalatsi'a porqui'ni gùtsi báni bi ca judíua. Làbi nna gunàbani bi Pilátua permiso qui'ni edi' bi cuerpo qui' Jesús. Pilátua nna bete bą́ permiso qui' bi. Làniana huía bi nna bedi' bi cuerpo qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ą'hua Nicodémua, enne' huía de réla lá ru'a lo Jesús, làbi nna bitsina' bi nùà' bi ttú chùà' kilo tì'ga especias nu dacca' yaỹi tsè' chixią mirra nna áloes nna yala iỹixi ril·làa' cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Guỹi' cabi cuerpo qui' Jesús nna, betùbi cabi e ca lári' lani ca especia nu ril·làa' iỹíxia, según ná bá costumbre qui' ca judíua canchu chi rucàttsi' cą ttu enne'. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Làti betàa' cą Jesús lo curútsia nna re' ttu jardín. Le' jardíą nna dua ttu bà nu puro taá íyyaá làti lanú nuỹa chi bigàtsi'. ");
INSERT INTO zaaNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Le' bàa nna gutìxa cabi cuerpo qui' Jesús, porqui'ni làteruba bàa ga'ną adiru exa de làti betàa' cą Jesús lo curútsia, ą'hua porqui'ni chì tení ral·la tsá runi ca judíua preparar para tsá ná qui'ni edi' latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Primero tsá qui' semana dílatò' ba hua náru chul·la nna, huía María enne' yetsi Magdala lo bà qui' Jesús. Bilá' tèni bi qui'ni chi bitua íyya xeni nu re' ru'a bàa. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Huía chì bi quèthani ru'a lo Pedrua ą'hua attu discípulo nu yala uccuatsi'íni Jesús nna ra bi cabi: Chi gutua cą cuerpo qui' Señor le' bàa nna labí yù tu' gaỹa tahua' cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedrua lani attu discípulua nna huía chì cabi lo bàa. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tulappa ba biria cabi, pero attu discípulua nna adí quetha bigàa bi ti'chu Pedrua, acca yà'la tè bi bitsina' ru'a bàa. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Bedètta' tè lo bi gunna' bi liú'u nna bila'ni bi ca lári' nu betùbi cabi e anta' cą nía; pero labí gutà'a tè bi. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simón Pedrua enne' denál·la'á nna bitsina' ba bi nna gutà'a taá bi le' bàa, porqui'ni le' ttu bèlia xeni bá ná nuá gutìxa cą cuerpo qui' Jesús. Bilá' huáni Pedrua ca lári'á anta' cą nía. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Bilá' huáni bi qui'ni lári' nu betètsi cabi iqquia Jesús nna labí tsá'ą adí ca lári'á, sino qui'ni re' bą́ yà'latsi' ttùbą. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Làniana discípulo enne' denérua ą'hua yà'la tè bi bitsina' lo bàa, pues làbi nna gutà'a hua bi nna bila'ni bi ca lári'á, lània lá nna huíalatsi' bi. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Porqui'ni labí gutelí tènì cabi nu ra lo Escritura acerca de Jesús qui'ni náduel·la' eyáthee de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chuppa ca discípulua nna beyéqquia cabi litsi' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero María nna du ba bi ru'a bàa ribetsi bi. Aníaba ribetsi bi nna bedètta' lo bi nna gùnna' bi liú'u. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bilá' tènì bi chuppa ca ángel tsíttsì tùni ná ỹó cabi ỹuàni cabi làti gutixa cą cuerpo qui' Jesús: ttu bi lado ỹíqquia lée, attu bi lado ỹà nì'a lée nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ca ángelia nna ra tè cabi María: Niula, biecca ribétsi lu'. Becàbi María nna ra bi: Chi gutua cą cuerpo qui' Señor enne' runia' adorar, labí yúá' gaỹa gutixa cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Aníabá ra María nna, beyeqquia tè bi nna bila'ni bi Jesús dùe nía, pero labí bedácca'ni bi canchu lèe ènni'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús nna ra tìe bi: Niula, biecca ribetsi lu'. Núní reyìla lu'. María nna belaba latsi' bi qui'ni jardinéruá bá nuá, acca ra tè bi: Señor, canchu cuią'lu' nua' gutua lu' e nna, gutixa'a bál·lani inte' gaỹa tahua' cuią'lu' e, inte' nna edi' ye' e. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús nna ra tìe bi: María. Làniana gunna' tè María attu nna bedacca' taáni bi e nna ra tè bi e: Maestro (titsa' hebreo nna rena cabi Raboni). ");
INSERT INTO zaaNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús nna rèe bi: Bittu gulappa' lu' inte', porqui'ni labí nì'i éya'a' ỹiabara' làti dua Dios enne' ná Tàta quí'a. Ná qui'ni tsía lu' làti tsè'e ca hermano quia' nna táyátsí cą qui'ni éya'a' ỹiabara' làti dua Tàta quíya'a enne' ná huá Tàta qui' le, lèe nna née Dios quia', ná huée Dios qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Làniana deyya tè María enne' nu yetsi Magdala para equixá'ani bi ca discípulua ca noticia tsè' acerca de qui'ni chi bila'ni bi Jesús enne' née Señor, ą'hua qui'ni labé nna rèe bi ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","La'a mísmuba primero tsá qui' semana de gùl·là la nna, tsè'e ca discípulua júntubá nna yáya tè ca puerta porqui'ni gùtsini cabi ca judíua. De repente taá nna bitsina' Jesús nna gùdue lahui' cabi nna rèe: La'ỹeni para lo losto' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Beyacca ba rèe cabi anía nna, beluè'nie cabi ca né'e làti ná seña qui' ca clávuá. Ą'hua beluè'nie cabi ru'a costilla qui'áa làti guda cą lanza. Làniana ca discípulua nna yala bedácca'ni cabi de bela'ni cabi Señor. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Làniana ra Jesús cabi attu: La'ỹeni para lo losto' le. Raáruhuée: Ti'ba chi guthel·la' Tatáa inte', pues ą'hua inte' nna rithél·la'a' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Beyacca ba rèe anía nna, belùbie nna rèe cabi: Liguni recibir Espíritu Santo. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nuỹa diba quixá'ani le qui'ni hua té perdón por ca tul·la' quì'į nna, entonces huáta'nią perdón; pero nu labí quixá'ani le acerca de la' reyuniỹén latsi' qui' ca tul·la' quì'į nna, entonces egà'na ba cą làni ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás enne' reya cabi Cuáchi'a, uccua huá bi ttu enne' tsì'nua nna, lanú bi té lani adí ca discípulua loti' gudu Jesús làti tsè'e cabía. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ca discípulua nna gutixà'ani cabi Tomás nna ra cabi bi: Chi bila'ni tu' Jesús enne' née Señor. Tomás nna ra tè bi: Canchu bihua ilá' te' le' né'e nna ugá'a tè ỹubènàya' làti guda cą clávuá, ą'hua canchu bihua ugá'a nàya' làti guda cą lanza costilla qui'áa nna, labí tsíalátsa'a'. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Xunu' ubitsa bitola nna de tsè'e ca discípulua júntubá, lània nna chi re' Tomás lani cabi. Ca puerta nna yáya bá cą. Jesús nna gudu tìe attu lahui' cabi nna rèe: La'ỹeni para lo losto' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jesús nna ra tìe Tomás: Bèga'a ỹubená' lu' le' nàya' nna gùnna' tsè' taá, bèga'a tè ná' lu' cuìtta'a' làti guda cą lanza, para qui'ni làa gudu chùppaniíruą latsi' lu', sino ccá lu' ttu nu ríalatsi'. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Becàbi tè Tomás nna ra bi e: Cuią'bálu' ná Señor quia' nna Dios enne' gunia' adorar. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús nna ra tìe bi: Hàsta'na bila'ni lu' inte' nna huíalatsi' lu', álá Tomás. Pero inte' nna nia': Icca'rubà canu ríalatsi' quį màsqui'ba labí bila'ni cą inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús nna benií ruhuée iỹétse'éru ca milagro bila'ni ca discípulo qui'áa, pero labí ga'na cą escrito lo líbruį. ");
INSERT INTO zaaNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero ca nui nna chi ga'na cą escrito, para qui'ni gata' fe qui' le lani Jesús nna tsíalatsi' le qui'ni née Cristo Ỹi'ni Tata Dios enne' ná qui'ni ìta le' yétsiloyu nna, para qui'ni gata' la'labàni cúbí nu gúnnée qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bitola nna bitsina' Jesús attu ru'a lo ca discípulo qui'áa, loti' tsè'e cabi ru'a indatò' láą Tiberias. Iį modo gùdue ru'a lo cabi: ");
INSERT INTO zaaNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedrua lani Tomás enne' reya cabi Cuáchi'a, ą'hua Natanael enne' Caná qui' Galilea, lani ca ỹi'ni Zebedéua, ą'hua áchúppa ca discípulo qui'áa nna, júntubá tsè'e iyaba cabi. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedrua nna ra tè bi cabi: Dí'a' huedàxu' bél·lá. Làcabi nna ra cabi Pedrua: Hua da' huá tu' lani lu'. De ra cabi anía nna dia tè cabi nna gutà'a cabi le' ttu barco. Pero yèlàa nna nìdi ttu bél·la labí bedàxu' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lótaá da' rànì'a nna bitsina' Jesús ru'a indatù'a, pero ca discípuluá nna labí bedácca'ni cabi qui'ni Jesús bá ènni'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Acca ra tìe cabi: Ỹì'ni to' quia', tsí hua té tí'ni le biỹa go ri'u. Becàbi nna ra cabi e: Labí té. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesús nna rèe cabi: Liudàl·là exxą' lado bàni qui' bárcuą' nna, hua taxácca' le bél·lá. Bedàl·la tè cabi ą le' inda hasta qui'ni labiru retèl·la'ni cabi ą de tántuání idi'áą por iỹé ca bél·la biyàxù'. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Làniana discípulo enne' yala catsi'íni Jesús nna ra bi Pedrua: Señor qui' rí'ua ba ènni'ą'. Biyéni báni Pedrua qui'ni Señor bá ènni'a nna, guỹi' tè bi ttu lari' nna bitètsi bi ą porqui'ni labí ỹó bi nàccu', làniana bitsía chi bi guta'a bi le' indatù'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Làniana deyya tè adí ca discípulua para ru'a indatù'a lani bárcuá, alategá idittu' tsè'e cabi de yúbitsi, ttú gayua' metro teruba nna dené'yabání cabi exxa nu déyu'u ca bél·la. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Beyàdi cabi loyu nna, bila'ni cabi qui'ni re' yí' nna tsìa ttu bél·la lo yí'a, ą'hua ettaxtíla nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús nna rèe cabi: Litàxi' tuchùppa bel·la canu chì' bedàxu' taá líą'. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Huappi tè Simón Pedrua le' bárcuá nna beyé'yabání bi exxa para lo yúbitsi tsá'ti'nią puro taá ca bél·la xeni, gayua' tsí'nutsè' eyóna'; tutsáníaỹá cą, atsi'íni labí bìtsu' exxa nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús nna ra tìe cabi: Libíga' nna, ligò. De biyénini ca discípulua rèe anía nna, nìdi ttu cabi labí beyáỹani cabi inàba titsa' cabi e: Nuni ná cuią'lu'. Porqui'ni chì bá bedácca'ni cabi qui'ni Señor Jesucristo bá ènni'a. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Gubiga' tè Jesús nna gùỹi'e ettaxtíla, gutìthie qui' cabi, ą'hua ca bél·la nu tsìa lo yí'a nna. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ą' modo nna uccua tsunna vuelta gudu Jesús ru'a lo ca discípulo qui'áa dèsdeba loti' beyáthee de lo lù'utiá. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Beyàcca ba gutò xtìlà cabi nna ra tè Jesús Simón Pedrua: Simón ỹi'ni Jonás, tsí hua catsi'íni lu' inte' adiru tì'chu catsi'íni cabi inte' cá. Becàbi Pedrua nna ra bi e: Señor, hua yù bá cuią'lu' qui'ni yala catsi'í te' cuią'lu'. Jesús nna rèe bi: Gute lu' alimento qui' ca carnero to' quia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús nna ra tìe Pedrua attu: Simón ỹi'ni Jonás, tsí hua catsi'íni lu' inte' cá. Becàbi Pedrua nna ra bi e: Señor, hua yù bá cuią'lu' qui'ni yala catsi'í te' cuią'lu'. Jesús nna ra tìe bi: Hué' lu' cuidado ca carnero to' quia'. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Gunne Jesús nu cca tsunna vuelta nna rèe bi: Simón ỹi'ni Jonás, tsí hualigani yala catsi'íni lu' inte' cá. Pedrua nna yala ní behuiní'ni bi de qui'ni chi uccua tsunna vuelta rèe bi: Tsí hua catsi'íni lu' inte'. Acca becàbi bi nna ra bi e: Señor, iyábani hua yù bá cuią'lu', ą'hua hua yù cuią'lu' qui'ni demasiáduni catsi'í te' cuią'lu'. Jesús nna rèe bi: Hué' lu' ca carnero to' quia' go cą. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Hualigani te' riquixa'ánia' lu': Loti' naáru lu' áti'to' tè nu cuìti'a nna, ttùba lu' gùthi lè'e lu' nna huía lu' gaỹa tediba uccua latsi' lu'; pero canchu chi ccá lu' enne' gùla nna, itsìlani ca ná' lu' nna, làniana attu nu huaya' lá nna guỹiqquią cą nna iche' tìą lu' làti labí calatsi' lu' tsía lu'. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Anía ra Jesús para ttelíni ti'iỹa ná la'tté qui' Pedrua canchu chi gatti bi nna thaliani Tata Dios por amor nu té lo losto' Pedrua lani e. Raáruhuá Jesús bi: Tanó inte'. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bedèqquia lo Pedrua nna bila'ni bi qui'ni denó huá discípulo enne' yala uccuatsi'íni Jesús, pues la'a mísmuba discípulo nuá guxua iqquia bi ỹiqquia Jesús nna ra bi e: Señor, núní nua' gunią contra cuią'lu' lani la' ruthacca'ỹí cá. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Bilá' báni Pedrua qui'ni denó bi nna, acca ra tè bi Jesús: Señor, nui chú nná, biani thacca'ą. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús nna rèe bi: Canchu càla látsa'a' qui'ni lą nna eyà'na bą́ hasta qui'ni ìta' attu nna, biánícca ccá lu' saber nì'i, pues làdi qui'ni lu' nna tanó lu' inte' tulidà taá. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ca titsa' nu gunèni Jesús Pedrua nna uccua cą ttu dicho entre ca hermanos, belaba latsi' quį qui'ni discípulua nna labí gatti bi. Pero Jesús nna labí rèe Pedro qui'ni labí gatti discípuluá, sino: Canchu calátsa'a' qui'ni lą nna eyà'na bą́ hasta qui'ni ìta' attu nna, biánícca ccá lu' saber nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Là discípulua nui ná testigo acerca de ca cosį nna bedia huá bi cą lo ìttsì. Intu' nna yù huá tu' qui'ni nu riquixá'a bi nna ną́ nu lígani. ");
INSERT INTO zaaNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Hua téru iỹetse' ca cosa nu beni Jesús. Cáalá té posible para gudia ri'u ttu ttu tsa cą lo ìttsì nna, ti' cca te' qui'ni labí ccání yétsiloyu iyaba ca libro nu quixa'a iyate nu benie. Ą' uccua.");
INSERT INTO zaaNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Titsa' nu bèdi'a' lo primer libro nna gutixa'ánia' lu', estimado Teófilo, iyaba ca cosa nu beni Jesucristua de bitée yetsiloyu, ą'hua nu gutixe'e ántesca edi' Tata Dios bi ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Miéntraste du rùe lani ca discípulo qui'áa nna gutixa'ánie cabi lani la'huacca qui' Espíritu Santo ti'iỹa ná nu guni cabi, porqui'ni labé becuí'e cabi nna guthel·le'e cabi para ccá cabi mensajero quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Bitola de uccuee padecer nna gùttìe nna, làniana enne' bàni tení gùdue ru'a lo cabi iỹé vuelta tsè' durante chua' ubitsa nna benie iỹetse' ca cosa, prueba de qui'ni hualigani chi beyáthee de lo lù'uti nna beyacca bànie nna gutixa'ánie cabi acerca de la' rigú'ubia' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Miéntraste dùe júntubá lani cabi nna gunènie cabi nna rèe: Bittu iria tè le le' ciudad Jerusalén, sino ná qui'ni cueda le hasta qui'ni ccá cumplir ca titsa' nu ra Tata Dios para lebi'i acerca de nu chìa beyénini le gunní'a', ");
INSERT INTO zaaNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","porqui'ni Juáan nna hualiba beni bi bautizar lani inda, pero alaáruhuá iỹé ubitsa ga reyatsa para qui'ni ccá le bautizar lani Espíritu Santo. Anía ra Jesús cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","De tsè'e cabi júntubá lani Jesús nna gunàba titsa' tè cabi e nna ra cabi e: Señor, tsí guni cuią'lu' qui'ni nación qui' ri'u Israel nna eyàtta' la' rigú'ubia' quì'į tiempo tsè'e rí'uį cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Becàbi tìe nna rèe cabi: Labí ná qui'ni ccá le saber ca tiempo nìhua ca tsá señalado nu tsua' teruba Tata Dios yùe biỹa gúnie. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero canchu chi íl·lani Espíritu Santo lani lebi'i nna, la'a labé gúnnée la'huacca qui' le para qui'ni ccá le testigo quia' le' Jerusalén nna tsía le quixá'a le nu cca quia' ituba región Judea nna Samaria nna hàstaá ituba yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","De beyacca gùnnie ca tìtsi'į nna hua rinna' cànna bá cabi e nna déyyee ỹiabara' hasta qui'ni bèyye'e le' ttu bía, làniana labiru bila'ni cabi e. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Miéntraste rinna' cabi déyee ỹiabara' nna prontu taá bitsina' chuppa ca ángel naccu' ỹó tsíttsì cabi nna, ");
INSERT INTO zaaNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ra cabi ca discípulua: Lebi'i ca ènne'yu' qui' Galilee, biecca rehuiní'ni le nna rinna'áru le rá' nì'i, pues la'a mísmuba Jesús enne' chì' bedà' taá ru'a lo le déyyee ỹiabara', pues ą́' bá itée attu ti'ba chi bila'ni li e déyyee ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Làniana bedà' ca discípulua lo i'ya láą Monte de Los Olivos nna deyya cabi Jerusalén ttu distancia nu ná permitido thá' ttu enne' tsá redi' latsi' ca enne' Israel. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","De betsina' cabi Jerusalén nna gutà'a cabi le' ttu yú'u nu de chùppa cùà'. Iqquia rá' lá nna tsè'e iyaba cabi. Entre làcabi nna tsè'e: Pedrua nna, ą'hua Jacóbua nna, Juan nna, Andrés nna, Felípea nna, Tomás nna, Bartoloméa nna, Matéua nna, Jacobo ỹi'ni Alféua nna, ą'hua Simón enne' reya cabi Zelótea, ą'hua Judas alàa Iscariote sino bettsi' attu enne' lá bi Jacobo. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Iyaba cabi nna tulidàba retùppa cabi nía runi cabi oración lani ca bettsi' Jesús ą'hua lani María nàna qui'áa, ą'hua lani adí ca niula creyente nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","Ttu vuelta nna gùduli Pedrua lahui' ca hermanos, làniana hua ná gayua' gàl·lia cabi tsè'e nía nna ra tè bi: Lebi'i hermanos, uccua duel·la' ccá cumplir nu chi ra Espíritu Santo por medio de David acerca de Judas Iscariote nu gunéru lo canu bedàxu' cą Jesús preso. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Lą nna gulàni huą́ intu', ą'hua ttùba tsina nu cca qui' Tata Dios benią lani intu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Lani bel·liu nu bete cą quì'į por mal nu beni naá nna huì'ini cą ttu loyu. Làniana dèsdeba ttu lugar ra' beduyú tè iqquį nna bìtsu' tè lì'į nna biria iyáỹiani ca tuye'e quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bina ba ca enne' Jerusalén nu uccua lani ą nna gutìxa cą lá lóyúa Acéldama ttu titsa' quì'ba quį, pero titsa' quì'ba ri'u nna láą Loyu qui' Réni. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Porqui'ni riquixá'a Tata Dios lo libro Salmos làti rèe: Yú'u làti gùduą nna eyacca tàttsi, Lanuru nuỹa thuą lì'į. Ą'hua ra: Attu enne' huaya' lá thú lugar quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Acca caduel·la' qui'ni gucué' ri'u ttu ca hermanos tsè'e nì canu guda' lani intu' ca apóstol tulidàba loti' gurèni Señor Jesús entre rí'uį, ");
INSERT INTO zaaNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","dèsdeba loti' beni Juáan ne bautizar hàstaa qui'ni Tata Dios nna bedi'e ne ỹiabara'. Caduel·la' qui'ni gucué' ri'u nuỹa ttu ca hermánuį para ccá bi ttu testigo tì'a intu' de qui'ni Jesús nna beyáthee de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Làniana beni cabi nombrar chùppa cabi: José enne' lá huá bi Barsabás ą'hua reya cą bi Justo. Beni hua cabi nombrar Matías. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Beni tè cabi oración nna ra cabi: Señor, hua nabia' báni cuią'lu' la' rulábalatsi' qui' iyate tu'. Annana beluè'ni intu' nuỹa la ttu ca enne' chuppíį chi becué' cuią'lu', ");
INSERT INTO zaaNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","para qui'ni ccá bi mensajero le' tsina qui' cuią'lu' porqui'ni Judas Iscariote nna lanúruą té; por maldad nu beni naá acca día bą́ lugar làti ràl·la'ą tsíą. ");
INSERT INTO zaaNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","De chi beyacca beni cabi oración nna beni cabi ca enne' chùppa sortear. Gùl·la' tè Matías. Acca dèsdeba lània nna gulátsi' hua bi tsìnia ca apóstol. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Bì'yu ba tsá Pentecostés tsieyóna' ubitsa bitola de beyatha Jesús de lo lù'uti, làniana iyaba ca enne' ríalatsi'á nna tsè'e cabi ttùba lugar. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","De repente tabá biyeni ttu ruido fuerte ni da' de ỹiaba tì'ba canchu chi rite ttu be' fuerte gani nna binìnìni le' ituba yú'u làti tsè'e cabía. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bilá' tehuáni cabi gùl·lani fuego nu ràl·la' tì'a ca pedazo yi' nna gùthilàliani cą nna bitsina' cą iqquia ttu ttu tsa cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Làniana iyaba cabi nna beni cabi recibir la'huacca qui' Espíritu Santo nna gùdulo cabi rinne cabi attu te ca titsa' según bá nu beni Espíritua latsi' cabi qui'ni inne cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tiempo lània nna tsè'e hua le' Jerusalén ca enne' Israel nu runi cumplir según religión qui' quį nna da' cą le' iyaba ca nación canu anta' le' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ca enne' ỹétsi'á nna de biyénini cą ruíduá nna bitùppa tè cą nna cuenta uccuaỹí bá latsi' quį tsè'e cą porqui'ni biyénini ca rinne cabi titsa' qui' ttu ttu tsa quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tsè'e tsi bá cą de tántubá biquíla' latsi' quį, làniana ra cą: Tsí álahua iyaba canu rinnį nna ná cą canu Galilea cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ti'ala modo acca riyénini ri'u rinne cą titsa' qui' ttu ttu tsa ri'u nu nàliani ri'u cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ri'u nna da' ri'u le' iỹetse' ca nación nna ca distritu nna: le' Partia, Media, Elam, Mesopotamia l·le, ą'hua le' la'a mísmuba región qui' Judá làti tsè'e rí'uį l·le, ą'hua Capadocia, Ponto, Asia l·le, ");
INSERT INTO zaaNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ą'hua ca lugar lá cą Frigia, Panfilia, Egíptua, ą'hua adí ca lugar qui' Africa attu ládulá làti ga'na ciudad Cirene l·le. Tsè'e hua entre ri'u canu da' de Roma nna ỹua tè cą nì; ttu te cą nna chi ná cą enne' Israel dèsdeba gùlia cą; attu te cą nna chì' uccua bá cą enne' Israel por religión. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Tsè'e hua entre ri'u canu da' de ttu isla láą Creta, ą'hua canu da' dèsdeba Arabia nna. Pero iyaba ri'u nna riyénini ri'u rinne ca ènni'į ca titsa' nu dacca' iquíla'ní latsi' ri'u acerca de Tata Dios lani propio gani titsa' qui' ttu ttu tsa ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Iyaba cą nna uccuaỹí ya'áni latsi' quį nna labí yù cą biỹa nuá, acca gunàba titsa' luetsi quį nna ra cą: Biadi' lo ná nui cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero attu te cą nna beỹìtsi cą nna ra cą: Es qui'ni dùtsi báni cą. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Làniana gùduli Pedrua ą'hua átsinia ca apóstol. Gùnne tè Pedrua iditsa nna ra bi: Lebi'i ca enne' Israel ą'hua adí le canu tsè'e le' Jerusalén, liudaáruhuá naga' le tuchùppa titsa' quixa'ánia' le: ");
INSERT INTO zaaNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Intu' nna bihua dùtsinì tu' tì'a ná la' rulaba latsi' qui' le, porqui'ni ritìį gà teruba tsè'e ri'u, labí chi gùl·la' hora ttani ca enne', ");
INSERT INTO zaaNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","sino qui'ni nu rila'ni le nna riyénini le nna ną́ nu riquixá'a Tata Dios lo libro nu bedia Joel enne' uccua profeta quì'e nna rèe: ");
INSERT INTO zaaNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Canchu chi i'yu ca último tsá nna, ithél·la'a' Espíritu quia' iqquia iyaba ca enne'. Làniana ca ỹi'ni beyu' le ą'hua ca ỹi'ni niula le nna equixá'a cą acerca de inte'. Canu cuìti' qui' le nna ila'ni cą ca cosa nu chì' da'la por poder quia'. Ca enne' gùla qui' le nna ínneni cą yèlà nu cca qui' ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ą'hua ithél·la'a' Espíritu quia' iqquia ca mozo nna ca criada nna canu ríalatsi' quį inte' nna. Canchu chi i'yu tsá nna inne cą parte inte'. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Gunia' ca cosa de la'huacca ỹiaba, ą'hua adí ca milagro le' yétsiloyu: tì'a réni nna yi' nna tsèni ti'taání bía nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Bitsą' nna eyaccą chul·la, biuá'ą' nna ccą́ tì'a réni. Iyaba ca nui ccá ántesca i'yu tsá guni Señor juzgar yétsiloyu lani la'huacca nna la'yani' de ỹiabara' nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Iyaba canu gul·luítsa' cą Señor nna inàbani cą ne qui'ni gudilèe cą, làcą nna gata' salvación qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Beni ba Pedrua seguir mensaje qui' bía nna ra bi: Acca lebi'i ca enne' Israel, liudaáruhuá naga' le ca tìtsi'į porqui'ni rinnía' nu cca qui' Jesús enne' Nazaret. Por ca obra quì'e nna ga'na ri'u seguro qui'ni Tata Dios ènni'a guthèl·le'e bi entre ri'u; porqui'ni por medio de Jesús nna beni Tata Dios iỹetse' ca milagro nu belue' qui'ni la'huacca quì'e nna dá'ą de ỹiabara', ca cosa nu biquíla'ni latsi' ri'u, tì'ba chi yù la'a mísmuba lebi'i porqui'ni benie ca cosį nì làti tsè'e rí'uį. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pero loti' bete cą ne cuenta latsi' ná' le nna, lebi'i nna bedàxu' li e preso nna beni le mandado qui'ni adí canu tul·la' nna gutaá' cą ne lo curutsia, anía modo nna betti li e. Pero Tata Dios nna chì lá yùe nui porqui'ni uccuą conforme lani la' rulaba latsi' quì'e dèsdeba antes. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Acca la'a mísmuba Tata Dios nna bechìthee bi de lo lù'uti nna beyacca bànie, anía modo nna bebèqquie bi le' poder qui' lù'utiá, porqui'ni lù'utiá nna labí té la'huacca quì'į para cu'ubià'nią ne. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Porqui'ni lo Escritura nna gunne rey David nu cca qui' Jesús làti ra bi: Tulidàba bilá' te' Señor gùdue ru'a lua', Lèe nna du bée cuìtta'a' lado bàni acca labí ebána te' nna, ");
INSERT INTO zaaNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yala redácca'ni latsi' lóstu'a' nna rúl·la'a' ca titsa' de la' redacca' latsi' nna, Ą'hua cuerpo quia' nna edi' latsi'į lani itute confianza qui'ni eyáthą de lo lù'uti, ");
INSERT INTO zaaNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Porqui'ni labí guthà'na cuią'lu' espíritu quia' làti ribèda ca espíritu qui' canu chi gùtti, Nìhua labí guni cuią'lu' permitir qui'ni gutsu' cuerpo qui' enne' santo guthel·la' cuią'lu', ");
INSERT INTO zaaNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Chi gutixa'áni cuią'lu' inte' nu cca qui' la'labàni nu ná para siempre, Ą'hua yala edacca' látsa'a' canchu chi él·lania' ru'a lo cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Gutixa'a Pedrua adí ca titsa' nna ra bi: Hermanos, claru taá yù ri'u qui'ni tà' tàta qui' ri'u David gùttì bi nna bigàttsi' bi, pues bà qui' bi nna ga'na bą́ le' yétsiloyuį. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pero David nna gùnne bi parte Tata Dios nna uccua bi saber qui'ni Tata Dios nna hualigani benìnie bi prometer qui'ni ttu descendiente qui' bi lá Cristo nna cu'úbi'e en lugar qui' bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David nna ti'atsi chìa bilá' tènì bi Cristua dèsdeba lània, acca gutixà'a bi quì'e qui'ni eyáthee de lo lù'uti nna ra bi qui'ni espíritu quì'e nna labí eyà'ną entre canu yatti, nìhua cuerpo quì'e nna labí gutsu'ą. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Là Jesús ènni'a bechìtha Tata Dios bi de lo lù'uti. Intu' nna ná tè tu' testigo qui'ni anía uccua. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jesús nna beyacca bànie nna beyáthee de lo lù'uti por la'huacca qui' Tata Dios nna benie recibir Espíritu Santo tì'a nu chi ra Tata Dios dèsdeba antes. Acca ca cosa nu chi bila'ni le nna biyénini le nna da' cą por Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Álahua qui'ni David nna bì'yu bi ỹiabara', sino la'a làbabi nna gùnne bi nu cca qui' Cristua nna ra bi: Señor Dios nna gunènie Señor quíya'a nna rèe: Gùduani cuìtta'a' lado bàni, ");
INSERT INTO zaaNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Hàstaá qui'ni gúnná' latsi' ná' lu' iyaba canu làa cca guyu cą lu'. Para qui'ni gul·liani lu' iqquia quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Acca lebi'i hermanos, ccá le saber nna ga'na le seguro qui'ni la'a mísmuba Jesús enne' betaá' le lo curútsia nna née Cristua enne' ná qui'ni itée para gudilèe ri'u, ná huée Xana' ỹiaba nna yétsiloyu nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","De biyénini cą nui nna yala beléníni cą nna ra tè cą Pedrua nna adí ca apóstol nna: Lebi'i hermanos Israelitas, biala dàni tu' guni tu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Becàbi Pedrua nna ra bi cą: Leyàttà'yu lani e qui'ni eyuniỹén latsi'e qui' le nu beni le, ą'hua ttu ttu tsa le nna ccá le bautizar lani nombre qui' Jesucristua para qui'ni gata' perdón qui' le nna; lahuée nna gúnnée la'huacca qui' Espíritu Santo lani le, ");
INSERT INTO zaaNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","tì'a chi benie prometer para lebi'i ą'hua para ca ỹi'ni le ą'hua para iyate canu tsè'e idittu', tsa'tséla tehuá iyaba ca enne' gaỹi Señor Dios qui' rí'ua. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Làniana Pedrua nna gunèni bi cą adí titsa' nna bete bi consejo qui' quį nna ra bi: Caduel·la' qui'ni ccá le salvo para qui'ni làa nitti le lani yétsiloyuį. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tsá lània nna huàni tè ttú tsùnna mili' ti'ga ca enne' lani ca creyénteá de biyénini cą mensaje qui' Pedrua nna uccua cą bautizar. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Iyaba cą nna beni cą seguir nu gútixa'ani ca apóstol ti'iỹa ná nu guni cą. Ttùba uccua la' rulába latsi' qui' cabi nna betùppa tè cabi tulidàba para guni cabi oración nna guni cabi celebrar cena qui' Señor. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ttu ttu tsa cabi nna yala la' rátsi latsi' gùl·lani lo lòsto' cabi, porqui'ni bila'ni cabi iỹetse' ca milagro nu beni ca apóstol ą'hua adí ca cosa nu rulue' qui'ni la'huacca qui' cabi nna dá'ą de ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Iyaba ca enne' chi huíalatsi'á nna betùppa cabi nna gutìthia cabi nu té qui' cabi lani ca enne' pobre. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bèttì' cabi ca interés qui' cabi ą'hua iyaba nu té qui' cabi nna beni cuàlani luetsi cabi según ti'iỹa ná bá la' ritè qui' ttu ttu cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ttu ttu tsá ní nna betùppa cabi le' templua. Ą'hua le' litsi' ttu ttu tsa cabi nna betùppa cabi nna beni cabi celebrar cena qui' Señor nna gutò cabi júntubá lani la' redacca' latsi'; yala enne' de losto' tsè' uccua cabi nna ");
INSERT INTO zaaNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","bedàliani cabi Tata Dios. Ituba yétsiá nna yala estimar beni cą cabi, ą'hua ttu ttu tsá nna beláppa' Señor losto' ca enne' para tsíalatsi' quį nna ccá cą salvo. Acca yala biỹèni iglesia qui'áa. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ritį tsùnna ti'gá qui' ttu tsá lània nna huía Pedrua lani Juáan le' templua para guni cabi oración. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ru'a puerta qui' templo reya cą Hermosa nna re' ttu nubeyu' nu dèsdeba gùlią nna labí cca thá'ą. Ca enne' nna ritáhua' cą na ttu ttu tsá bá ru'a puerta para qui'ni inàbanią canu ra'a le' templua caridad. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nubeyu' cójuá nna bilá' bánią Pedrua lani Juáan qui'ni ra'a cabi le' templua nna gunàbanią cabi caridad. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Làniana gulèda tè Pedrua nna gùnna' cabi nubéyu'a, acca ra tè Pedrua na: Gùnna' intu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Lą nna bettsia tsìttsì ni lúį cabi belaba latsi'į qui'ni gute cabi biỹa quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedrua nna ra tè bi ą: Labí té plata nihua oro quia', pero nu chi benna Tata Dios quia' nna gúnná huá' qui' lu': En nombre qui' Jesucristo enne' Nazaret, bèduli nna gùda'. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Làniana bedàxu' tè bi ná' bànį nna bèthuli bi ą. Luegu taá nna gùdu tsìttsì ca nì'į nna ca ỹíbį nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nubeyu' cójuá nna bittsíaníą nna gùduą tsìttsì lani ca nì'į, làniana gùduluą gùda'ą nna gutà'a tìą le' templua lani làcabi. Tì'a vívá rida' chìą nna rittsíaníą de tantua la' redacca' latsi' nna bedàlianią Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Iyaba ca enne' nna bila'ni cą nubéyu'a rida'ą nna rudàlianią Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ca ènni'a nna bedácca'ni cą na qui'ni lą nuá gùre' ru'a puerta qui' templua huenàba caridad ttu ttu tsá. Acca yala uccuaỹí latsi' quį nna gùtsini cą porqui'ni bila'ni cą nubéyu'a qui'ni chi beyacca latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nubeyu' nu chi beyacca latsi' niá nna hua denó bą́ Pedrua nna Juáan nna. Acca enne' ỹétse'ní bitùppa chì cą ìta'lùba làti tsè'e cabi ru'a templua le' corredor nu láą Portal qui' Salomón; bila'ni cą nna biquila' bá latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Bilá' báni Pedrua ca enne' ỹétse'á nna ra tè bi cą: Lebi'i ca enne' Israelitas, biánícca riquila' xatta latsi' le nì'i. Biánícca rinna' le intu' ti'atsi intu' ba beni tu' qui'ni rida' nubéyu'į por la'a mísmuba la'huacca qui' tu' ti'atsi yala enne' tsè' ná tu' ru'a lo Tata Dios cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tata Dios enne' huíalatsi' ca tà' tàta qui' ri'u Abraham nna Isaac nna Jacob nna, chi betie la' dàliani qui' Ỹi'nie Jesús enne' bete le cuenta lani canu rugú'ubia' qui' yetsi. Ą'hua loti' uccua latsi' gobernador Pilátua gudilą̀ ne nna, lebi'i nna labí uccua latsi' le. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","En lugar de qui'ni inàba le qui'ni l·lá Enne' labí falta té quì'e ru'a lo ca enne' nìhua ru'a lo Tata Dios nna, gunàba lá le qui'ni l·lá ttu nubeyu' criminal, ");
INSERT INTO zaaNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","hàsta qui'ni betti le Jesús Enne' runna la'labàni, pero Tata Dios nna chi bechìthee bi de entre canu yatti. Intu' nna ná tè tu' testigo qui'ni anía uccua. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Por fe nu té bá qui' tu' lani Jesús, acca nubeyu' nu chi nabia'ni líį nna chi benie qui'ni gùppą fuerza. Por fe lani e nna chi beyacca latsi'į completamente taá tì'ba chi rila'ni li ą duą nì ru'a lo le. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Pero annana hermanos Israelitas, hua yú bá' qui'ni nìhua lebi'i nna nìhua canu rigú'ubia' qui' le nna labí bennia le cuenta biỹa nuá beni le de betti le Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero anía modo nna uccua cumplir nu chi gutixa'a Tata Dios por medio de ca enne' uccua profeta chìa gutsá, làti rèe lo libro nu bedia cabi qui'ni Cristo enne' guthèl·le'e para gudilee ri'u nna ná qui'ni quée padecer. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Acca leyàtta'yú lani e nna leyéqquia lani Señor Dios para qui'ni eyuniỹén latsi'e ca tul·la' nu beni le; làniana ithèl·le'e bendición nu riquína'ni le ");
INSERT INTO zaaNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","por medio de Jesús enne' lá huá Cristo, enne' nuá beni Tata Dios prometer dèsdeba chi gutsání qui'ni ithèl·le'e bi lani le. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jesucristua nna chi déyyee ỹiabara' nna labí eyéqquie nì hasta qui'ni gal·la' tsá señalado nu nani Tata Dios qui'ni cu'úbi'e iyábani ca cosa de acuerdo lani nu gunnie por medio de ca enne' gunne parte quì'e ca tiempo antigua. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Acerca de nui nna gutixa'a huáni Moisés ca tà' tàta qui' rí'ua nna ra bi: Huàl·lani tsá qui'ni Señor Dios enne' becuí'e inte' nna guni huée qui'ni attu descendiente qui' le ccá huée profeta. Acca liúda naga' le quì'e nna liguni iyate nu ínnee. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Porqui'ni nuỹa diba labí gudà nàgui'į quì'e nna ítua telą́ le' nación qui' Israel nna l·lúỹa latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ą'hua iyaba ca enne' gunne parte Tata Dios bitola de gùttì Moisés nna, dèsdeba Samuel ą'hua ca enne' uccua profeta bitola nna gunne hua cabi qui' nu chi cca anna. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yù ri'u qui'ni Tata Dios nna benie ttu promesa lani ca tà' tàta qui' rí'ua nna rèe Abraham enne' gùdua tiempo antigua: Por medio de ttu descendiente qui' lu' bitola nna, cca bendecir iyábani ca enne' le' yétsiloyu. Lebi'i nna ná huá le descendiente qui' ca enne' chi uccua profeta nna belaba latsi' Tata Dios qui' le loti' benie promesą' lani Abraham. ");
INSERT INTO zaaNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Acca primérute lani lebi'i nna guthèl·le'e Ỹi'ni áa para gunie le bendecir de chi bechìthee bi de lo lù'uti, a fin de qui'ni ttu ttu tsa le eyéqquia le lani e nna eria le lo néda mal nu yù'u le. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedrua nna Juáan nna àtsaba rinèni cabi ca enne' ỹetse'á nna, bitsina' chì ca sacerdótea lani nu ná capitán qui' canu rue' cuidado templua nna ą'hua lani canu denó cą religión saducéua. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Làcą nna yala ritsa'áni cą qui'ni Pedrua nna Juáan nna gutixa'a cabi evangelio nna ra cabi qui'ni eyátha ca enne' de lo lù'uti tì'a uccua lani Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Acca bedàxu' cą cabi preso, pero en vista de qui'ni chi ral·la acca bedàl·la taá cą cabi litsi' ìyyà. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero nuỹetse' canu biyénini ca titsa' nu gutixa'a cabía nna huíalatsi' quį. Ttú gayu' mili' ca nubéyu'a nna beni cą Señor Jesús recibir. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Attu yu'utsá nna betùppa canu rigú'ubia' qui' ca enne' judíua le' ciudad Jerusalén lani ca enne' gùla rue' cuenta entre làcą, ą'hua lani ca maestro de la ley qui' caniá nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nía nna lání huá Anás nu ná sumo sacerdote qui' ca judíua, ą'hua Caifás nna Juáan nna Alejandro nna iyaba canu cca pertenecer le' familia qui' ca sacerdote principal nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Làniana guchè' cą Pedrua nna Juáan nna ru'a lo iyaba canuá nna gunàba titsa' tè cą cabi nna ra cą: Núní benna la'huacca qui' le acca runi le ca cosį nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Làniana gunne tè Pedrua lani la'huacca qui' Espíritu Santo nna ra bi cą: Lebi'i canu rigú'ubia' qui' ri'u ca enne' Israel, ą'hua lebi'i ca anciano: ");
INSERT INTO zaaNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Rinàba titsa' le intu' acerca de favor nu uccua lani nubeyu' cójuá, calatsi' le ccá le saber ti'iỹa modo beni tu' acca beyacca latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Annana ccá iyate le saber ą'hua ituba yetsi Israel qui'ni lani la'huacca qui' Jesúscristo de Nazaret enne' betaá' le lo curútsia nna gùttìe, pero Tata Dios nna chi bechìthee bi de lo lù'uti. Por Jesúcristua nna chi beyacca latsi' nubéyu'į nna, tì'a vívá rila'ni li ą duą ru'a lo le. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesucristua nna née Iyya Principal nu labí uccua latsi' le uquìna' le para gudua le yú'u qui' Tata Dios, pero ");
INSERT INTO zaaNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","lanú nuỹa enne' ní ccani gunna salvación qui' ri'u, porqui'ni lanuru attu nuỹa guthèl·la' Tata Dios yétsiloyu para gudilą̀ ca enne', sino làteruba Jesucristua. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bilá' báni iyaba canu tsè'e nía qui'ni yala valor té qui' Pedrua nna Juáan nna, hua yù huá cą qui'ni labí tanto escuela huía cabi porqui'ni enne' sencíllubá uccua cabi; acca yala biquila' latsi' quį por nu gutixa'a Pedrua nna gutelíni cą qui'ni gurèni cabi lani Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bilá' huáni cą qui'ni nubeyu' nu chi beyacca latsi' niá nna chi dunía lani cabi, acca labiru pretexto betseláni cą para guni cą contra cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Làniana bebèqquia cą cabi le' junta nna gùdulo cą bè' cą titsa' entre làba cą, ");
INSERT INTO zaaNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","nna ra cą: Biani guni ri'u lani ca nubéyu'į cá. Pues iyábani canu tsè'e le' Jerusalén nna chi yù cą qui'ni milágruį nna uccuą por làcą; ri'u nna labí razón té para ina ri'u qui'ni álahua ą́' ná, ");
INSERT INTO zaaNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","pero para qui'ni bittu guna adí ca enne' nu uccua nna, adila tsa' guthítsini ri'u cą qui'ni dèsdeba annana bíttuúru ínneni cą nuhuaya' nu cca qui' Jesús. Gá huá ri'u cą qui'ni hua té castigo canchu guni cą seguir quixá'ani cą ca enne' ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Làniana gutàỹi tè cą cabi attu vuelta nna gunèni cą cabi qui'ni bíttuúru derecho té qui' cabi para equixá'a cabi biỹa titsa' nu cca qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero Pedrua nna Juáan nna ra cabi cą: Línna tsánna canchu adí tsè' ná guni ri'u nu ra ca enne' tì'chula nu ra Tata Dios cá, ");
INSERT INTO zaaNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","porqui'ni intu' nna labí ccani tu' gudùtsi tu' làa equixá'a tu' nu chi bila'ni tu' nna biyénini tu' nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","De ra cabi anía nna yala betuxùnì cą cabi nna ra cą qui'ni canchu guni cabi seguir quixa'a cabi anía nna entonces guni cą cabi castigar. Be'èl·la' tè cą cabi éyya cabi, porqui'ni labí betseláni cą ti'iỹa modo guni cą cabi castigar lània en vista de qui'ni yétsiá nna rudàliani cą Tata Dios por milagro nu uccua lani nubeyu' cójuá. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nubeyu' nu beyacca latsi' niá nna télá chùà' ídanią lània. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedrua nna Juáan nna de chi gùta' libertad qui' cabi nna beyya cabi làti tsè'e adí ca discípulua nna gutixà'a cabi iyaba nu ra ca sacerdote principal ą'hua adí canu rigú'ubia' qui' ca enne' yétsiá. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Biyeni báni cc hermanos notícį nna juntu taá beni iyaba cabi oración lani Tata Dios nna ra cabi: Señor, cuią'bálu' ná Dios enne' beni ỹiaba nna yétsiloyu nna indatò' nna iyaba ca cosa nu té nna, ");
INSERT INTO zaaNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","cuią'lu' nna loti' Espíritu Santo benie latsi' David nna ra cuią'lu' lo libro nu bedia bi: Biánícca runi ca yetsi alboroto cá. Ca enne' quia' nna, biánícca rulaba latsi' quį nu làa dacca' iỹu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Betùppa ca rey qui' yétsiloyu, ą'hua canu rigú'ubia' qui' ca yetsi nna uccua cą ttùba contra Señor Dios, ą'hua contra Cristo enne' betie itute la'huacca quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Porqui'ni hualiba qui'ni Herodes nna Poncio Pilato nna betùppa cą le' ciudíį lani adí canu dittu' ą'hua lani la'a mísmuba ca enne' Israel nna biria iyaba cą contra Ỹi'ni Santo qui' cuią'lu' Jesús enne' bete cuią'lu' itute la'huacca quì'e porqui'ni née Cristo. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Anía modo nna beni cą nu chì lá yù cuią'lu' qui'ni anía ccá según ca propóstio qui' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Annaỹa Señor, gunna' tsáruhuá cuią'lu' ti'iỹa rinne cą contra intu' ca huenitsìna qui' cuią'lu'. Acca beni qui'ni gappa tu' adí valor para qui'ni bittu gátsini tu' equixá'a tu' titsa' qui' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Rinàba tu' qui'ni gulappa' cuią'lu' canu ra'ni para qui'ni eyacca latsi' quį, ą'hua qui'ni guni cuią'lu' adí ca milagro nna adí ca cosa de la'huacca por medio de nombre qui' Ỹi'ni cuią'lu' Jesús enne' completamente tsè' due ru'a lo cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Beyacca ba beni cabi oración nna gùỹu' làti tsè'e cabía; iyaba cabi nna gùỹi' cabi adí la'huacca qui' Espíritu Santo nna gutixà'a cabi titsa' qui' Tata Dios sin la' rátsilatsi'. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Iyaba ca enne' chi huíalatsi'á nna ttùba uccua la' rulábalatsi' qui' cabi nna ą'hua yala la' retúalatsi' gùta' qui' luetsi cabi. Lanú nuỹa reną qui'ni nu té quì'į nna ną́ qui' terúbíį, sino qui'ni iyaba ca cosa nna uccua cą qui' iyaba cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ca apóstol qui' Señor nna beni cabi seguir gutixà'a cabi nu cca qui' Señor Jesús qui'ni beyacca bànie, pero gùnne cabi lani adírulá la'huacca nu bete Tata Dios qui' cabi. Yala favor beni Tata Dios lani iyaba cabi, ą'hua ca enne' nna yala tsè' beyu cą cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Entre làcabi nna nìdirubani ttu enne' labí biỹa beyàtsanią porqui'ni iyaba ca creyente canu anta' loyu qui' cabi nna ą'hua canu tsìa yú'u qui' cabi nna, pues bèttì' cabi ca cosį nna tahua' cabi bel·liu laỹa nu bèttì' cabía nna, ");
INSERT INTO zaaNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","betsia cabi ą ru'a lo ca apóstol. Ca apóstol nna gutìthia cabi ą según ti'iỹa ná bá la' ritè qui' ttu ttu ca enne' ríalatsi'á. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nía dua ttu enne' ríalatsi' lá bí José, pero ca apóstol nna gutìxa cabi láa bi Bernabé, titsa' qui' ri'u nna ra Enne' Runna La'ỹeni. Bernabéa nna uccua bi ttu enne' Israel descendiente qui' Leví, biria bi le' isla láą Chipre. ");
INSERT INTO zaaNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Làbi nna gùta' ttu loyu qui' bi nna bèttì' bi ą; làniana bete tè bi laỹa lóyúa lani ca apóstol. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Gùdua huá ttu nubeyu' láą Ananías. Niula qui' niá nna láą Safira. Ananías nna bèttì'ą ttu loyu. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pero labí berią itute bel·liu nu ná laỹa lóyúa lani ca apóstol, sino gutua bą́ tí' para lą; hua yù huá niula qui' niá na. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Acca ra tè Pedrua na; Ananías, ti'ani modo acca gutà'a Satanás lo losto' lu' nna becàttsi'ni lu' intu' ttu parte laỹa lóyúa cá, pues contra Espíritu Santo nna benilatsi' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tsí álahua quì'ba lu' ná lóyúa ántesca gutti' lu' ą cá. Ą'hua de chi bèttì' lu' ą nna tsí álahua quì'ba lu' ná bél·liuá cá. Biálácca belaba latsi' lu' ina lu' qui'ni ttutsíį gutìỹa cą qui' lóyúa cá. Alàa intu' nuą' calatsi' lu' guthacca'ỹí lu', sino Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","De biyéni'ni Ananías ca tìtsa'ą' nna la'a mísmuba làti dùna nna gubìxi chìą nna gùttìą. Làniana yala la' rátsilatsi' gùl·lani lo losto' iyaba canu bina noticia. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Làniana bitsina' tè tuchùppa ca nubeyu' cuìti' nna betùbi cą cuerpo qui' Ananías lári' nna gulèqquia tè cą na tacàttsi' cą na. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ttu tsùnna hora ti'ga bitola de uccua nuá nna gutà'a niula qui' Ananías, pero labí nì'i guną nu uccua. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ra tè Pedrua na: Gùtixa'ani inte', tsí ttu tsą' gutìỹa le qui' lóyúa cá. Becàbią nna rą: Làchu, ttu tsą' bèttì' tu' ą. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedrua nna ra bi ą: Biánícca gulèqquia lèttia le para qui'ni canchu hua rialàni le guthacca'ỹí le Espíritu Santo enne' guthèl·la' Señor cá. Nà' tè chi deda' canu becàttsi' cą tsèla lu'a; làcą nna tacàttsi' tehuá cą lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Luegu taá nna gubìxi chìą ru'a lo Pedrua nna gùttìą. Gutà'a ba ca nubeyu' cuìti'a nna bila'ni cą na qui'ni gùttì chì huą́; acca gulèqquia cą na becàttsi' cą na cuitta' bà qui' tsèla niá. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Làniana iyaba ca enne' chi runi formar iglesia nna adila gùtsini cabi, ą'hua gùl·lani ttu la' rátsilatsi' lo losto' iyaba canu bina noticia nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Por medio de ca apóstol nna iỹetse' ca milagro uccua nu belue' la'huacca qui' Tata Dios lani cabi le' yétsiá. Iyaba ca enne' ríalatsi'á nna retùppa ba cabi le' corredor qui' templua nu reya cą Portal qui' Salomón, para ca reunión qui' cabia. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pero adí ca ènni'a nna labí beyáỹani cą etùppa cą lani làcabi, por nu uccua lani Ananías nna Safira nna. Pero iyaba cą nna yala tsè' beyu cą canu ríalatsi'á. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pero bitola nna adila huàni ca enne' huíalatsi' qui' Señor hasta qui'ni enne' ỹétse'ní, tàntua ca nubeyu' nna ca niula nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Yala fe gùppa cą lani Señor hàsta qui'ni guche' cą canu ra'ni qui' caniá fuera nna gutìxa cą cą lo néda, canu betsia cą lo camilla ba l·le canu betsia cą lo bíỹaáru bequìna' cą l·le, para qui'ni canchu chi tté Pedrua nna eyacca' taá latsi' quį màsqui'di ỹula qui' bi tté làti anta' nuỹa ttu cą. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ą'hua nuỹetse' ca enne' qui' ca yetsi anta' ìta'lùba Jerusalén nna guche' cą canu ra'ni ą'hua canu cca padecer por ca espíritu malo; iyaba cą nna beyacca latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Acca por nui nna yala bitsa'áni nu uccua sumo sacerdote ą'hua iyaba canu tsè'e parte lą qui' partido religioso láą ca saduceos nna, yala la' yélatsi' gùppa cą lani ca apóstol. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Gulù'u chi ná' quį ca apóstol nna bedàl·la cą cabi litsi' ìyyà. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero ttu ángel enne' guthèl·la' Señor nna huíe yèlà lània nna guthàlie ca puerta qui' litsi' ìyyà nna bebèqquie cabi nna rèe cabi: ");
INSERT INTO zaaNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Litsía le' templua, líquixá'ani ca enne' ti'iỹa modo gata' la'labàni cubi nu labí ttíą qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Biyeni báni cabi nu ra ángelia cabi nna gutà'a cabi le' templua nítaání da' rànì' nna gùdulo cabi gùtixa'ani cabi ca enne'. Miéntraste nna nu ná sumo sacerdótea lani iyaba canu tsè'e parte lą nna gutàỹi cą iyaba canu rugú'ubia' entre ca enne' Israel nna beni cą ttu junta. Làniana beni cą mandado taxi' cą ca apóstol anta' le' litsi' ìyyà. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Bitsina' ba ca policía le' litsi' ìyyàa, pero lanuru ca apóstol té nia; acca beyéqquia chì cą nna gùtixa'a cą nna ");
INSERT INTO zaaNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ra cą: Hualigani nna yáya bá litsi' ìyyą̀' tsìttsì tsè'ni, ą'hua ca guardia nna tsè'e ba cą al tanto ru'a puertą', pero de guthàlia tu' gutà'a tu' nna lanruru nuỹa té le' litsi' ìyyà. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Biyeni báni nu ná sumo sacerdótea notícį nna ą'hua adí canu rue' cuenta qui' ca sacerdótea lani nu ná capitán qui' canu rue' cuidado templua nna, uccuaỹí ya'ání latsi' iyaba quį nna ra luetsi quį: Canchu tsíalatsi' adí ca enne' por nu riquixa'a cą nna, ti'ala guni ri'u cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Làniana gùl·ll ni ttu nubeyu' nna rą cą: Ca nubeyu' canu bedàl·la le le' litsi' ìyyą̀', anna tè nna tsè'e cą le' templuą' riquixá'ani cą ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Làniana huía chi nu ná capitán lani ca policía para taxi' cą ca apóstol attu, pero bíttuá maltratar beni cą cabi porqui'ni gùtsi báni cą ca enne' yétsiá nna belaba latsi' quį qui'ni xiaba hué' cą cą íyya para gatti cą. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","De chi taxi' cą cabi nna bèdu cą cabi ru'a lo canu tsè'e júntaá. Nu ná sumo sacerdótea nna gunaba titsa' tìą cabi, nna ");
INSERT INTO zaaNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","rą: Tsí álahua chi bethítsini tu' le qui'ni bíttuúru quixá'a le nu cca qui' Jesús, atsi'íni iyaba ca enne' tsè'e Jerusalén nì nna chi nabia'ni cą nu riquixá'a le nna catè latsi' le tatsia le iqquia tu' qui'ni intu' bèttì tu' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedrua lani adí ca apóstol nna becàbi cabi nna ra cabi: Adila caduel·la' guni tu' obedecer Tata Dios tì'chula nu ra ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Dios enne' huíalatsi' ca tà' tata qui' rí'ua nna belithee Jesús de lo lù'uti para labiru gattie, màsqui'ba lebi'i nna bèttì li e porqui'ni beni le disponer qui'ni betaá' cą ne lo curútsia nna gùttìe. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pero Tata Dios nna chi bèdue bi lado ná' bànie para quée Príncipe nna Enne' Gunna Salvación nna, para qui'ni gappa ri'u ca enne' Israel oportunidad para eyacca ri'u arrepentir por ca tul·la' qui' ri'u nna eyuniỹén latsi'e qui' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Intu' nna ná tu' testigo quì'e acerca de ca cosį, ą'hua chi guthèl·la' Tata Dios Espíritu Santo para thúe lo losto' ca enne' canu runi cą ne obedecer. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Biyeni bani cą ca tìtsa'a nna yalàni bitsa'áni cą cabi nna uccua latsi' quį gúttí cą cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Le' junta nna re' huá ttu nu runi seguir religión fariséua nna lá bí Gamaliel, uccua bi profesor qui' ley qui' ca enne' Israel nna gùppa iyaba ca enne' bi titsa'. Gùduli bi nna beni tè bi mandado qui'ni cueqquia sà cą ca apóstol le' junta. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Làniana ra bi iyaba ca enne' tsè'e le' junta: Lebi'i ca enne' Israel, tsè'taá licuèqquia lèttia qui' le acerca de nu guthuacca' le ca nubéyu'ą', ");
INSERT INTO zaaNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","porqui'ni'ni ttu cuaỹa nuá nna biria tu nu lá Teudas, nuỹé bèninią ca enne' prometer. Ttu tappa gayua' ti'ga ca enne' huíalatsi' quį quì'į, pero bitola nna bèttì ba cą na, ą'hua iyaba canu huíalatsi' quį quì'į nna gùthilàlia bá cą nna beníttilo bá partido quì' niá. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bitola nna bìria attu nubeyu' de Galilea láą Judas tiempo loti' gùỹi' gobierno cuenta láa iyaba ca ènni'a. Iỹétse'huá ca enne' nna tanó cą na, pero bil·lùỹa tehuá latsi'į ą'hua iyaba canu huíalatsi' quį qui' niá nna gùthilàlia bá cą. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Annana gúnná' le ttu consejo: Liuxùl·là latsi' le ca nubéyu'ą' nna lihue'èl·la' cą éyya cą. Porqui'ni canchu nu runi cą nna ną́ según la'huacca nu té qui' ca enne' nna, entonces hueníttiló bą́. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero canchu nu runi cą nna ną́ por la'huacca qui' Tata Dios nna, entonces labí írialàni le gulùỹa le latsi'į, porqui'ni níca'chú tálią́ qui'ni redúdítsi láni le Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Canu tsè'e le' junta nna gutà'a cą razón por nu ra Gamaliel, acca gutàỹi tè cą ca apóstol attu nna. Bitola de bè' cą cabi idí' tsè' nna bethítsini cą cabi attu qui'ni bíttuúru quixá'a cabi nu cca qui' Jesús, làniana bétse'e cą cabi libre. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Beria tè ca apóstol le' junta nna yala bedacca' latsi' cabi porqui'ni Tata Dios nna benie permitir qui'ni ccá cabi padecer por causa de qui'ni bedàliani cabi nombre qui' Señor Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Labí bedùtsì cabi gutixa'a cabi sino beni cabi seguir fiel nna gutsé'e cabi le' templua ttu ttu tsá bá, ą'hua huía cabi litsi' ca enne' nna gutixa'ani cabi cą ca titsa' tsè' qui' Jesucristua. ");
INSERT INTO zaaNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ca tsá lania nna adí iỹetse' ca enne' nna huíalatsi' quį Jesúcristua. Làniana canu gunne titsa' griego nna biyèyya cą contra canu gunne titsa' hebreo nna ra cą qui'ni labí tsè' runi cabi atender ca niula viuda canu tsè'e le' iglesia canchu chi rithia cabi ttu ttu tsá nu ro ca enne' ritè la'dí'. ");
INSERT INTO zaaNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tsì'nu ca apóstol nna betùppa tè cabi iyaba ca enne' ríalatsi'á nna ra cabi: Labí ná tsè' qui'ni gútse'e latsi' tu' predicación qui' ca titsa' qui' Tata Dios para quithia tu' nu té qui' iglesia lani ca enne' pobre. ");
INSERT INTO zaaNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Acca lebi'i hermanos, liguni nombrar gàtsi ca ènne'yu' entre ri'u para tsìnį. Gucué' ri'u ca enne' dàa titsa' qui' cabi runi cabi nu ná tsè' nna té adí experiencia qui' cabi por la'huacca qui' Espíritu Santo lo losto' cabi, canu té adí la' riyeni tsè' qui' cabi nna, para qui'ni gúdu ri'u cabi guni cabi tsìnį. ");
INSERT INTO zaaNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Intu' nna guni ba tu' seguir guni tu' oración nna quixá'a tu' titsa' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Iyaba ca enne' ỹétse'á nna yala guyú'u latsi' cabi nu ra ca apóstol, acca becué' tè cabi primérute Esteban porqui'ni yala fe té qui' bi lani Tata Dios, ą'hua yala enne' de experiencia uccua bi por la'huacca qui' Espíritu Santo. Becué' huá cabi Felípea, ą'hua enne' lá Prócoro nna, ą'hua enne' lá Nicanor nna, ą'hua Timón nna, ą'hua Parmenas nna, ą'hua Nicolás enne' Antioquía nna. Nicolás nna labí ná bi enne' de raza judío, pero ántesca tsialatsi' bi evangelio nna beni bi seguir religión qui' ca judíua. ");
INSERT INTO zaaNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Beni tè ca creyénteá presentar gàtsi ca ènne'yu'a ru'a lo ca apóstol. Làcabi nna betsia ná' cabi iqquia ca enne' gàtsia nna beni cabi oración por làcabi; anía modo nna beni cabi ca ènni'a encomendar latsi' ná' Tata Dios para tsìnį. ");
INSERT INTO zaaNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Itúbani nía nna adí telá bitsìla titsa' qui' Señor hàstaá qui'ni adí ca enne' ỹétse'ní tsè'e le' Jerusalén nna huía huá latsi' quį Señor, ą'hua entre làcą nna tsè'e nuỹetse' ca sacerdótea gùppa huá cą fe lani Señor Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban nna yala favor beni bi lani ca enne' por gracia nu bete Tata Dios qui' bi, ą'hua beni Tata Dios bi bendecir lani la'huacca nna. Beni bi iỹetse' ca milagro le' ciudáad ą'hua adí ca cosa nu rulue' qui'ni la'huacca qui' bi nna dá'ą de ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Le' ciudáad nna dua huá ttu sinagoga làti retùppa canu lá cą Esclavos Libertados. Làcą lani canu da' le' ca ciudad Cirene nna Alejandría nna ą'hua le' ca región Cilicia nna Asia nna gùdulo cą bè' cą titsa' lani Esteban. ");
INSERT INTO zaaNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero labí biríalàni cą gurèxaèl·la' cą bi porqui'ni gunne bi lani la' riyeni tsè' por la'huacca qui' Espíritu Santo lani bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Acca gutìỹa bání cą bel·liu lani tuchùppa ca nubeyu' huaya' para ilìtha cą belá'na qui' Esteban nna ina cą qui'ni biyénini cą gùnne bi ca titsa' nu làa dacca' iỹu' contra Moisés ą'hua contra Tata Dios nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Anía modo nna gulù'uyí' cą latsi' ca enne' yétsiá ą'hua canu rigú'ubia' entre làcaná ą'hua ca maestro de la ley qui' caniá nna. Iyaba cą nna gudunó cą Esteban nna bedàxu' cą bi nna guche' cą bi ru'a lo iyaba canu rigú'ubia' le' junta. ");
INSERT INTO zaaNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bedù tè cą ca testigo fálsuá nna ra cą: Nubéyu'į nna bihua rudùtsią rinnią ca titsa' mal contra templo nu chi uccua lé'yá, ą'hua runią despreciar nu ra lo ley religiosa qui' ri'u nna; ");
INSERT INTO zaaNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","pues la'a mísmuba intu' nna chi biyénini tu' rą qui'ni Jesús nu Nazaret nna gutàppà'ą lugar lé'yá qui' rí'uį nna gutsiáníą ca costumbre nu gutixa'ani Moisés ca tà' tàta qui' rí'ua nu ná qui'ni guni ri'u seguir. ");
INSERT INTO zaaNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Làniana iyaba canu tsè'e le' junta nna gùnna' cą Esteban nna bila'ni cą qui'ni lo bi nna uccua tittíníą tì'a lo ttu ángel de ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Enne' ná sumo sacerdótea nna gunàba tìtsa'ą Esteban nna rą bi: Tsí hua lí ą́' gunne lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Becàbi Esteban nna ra bi: Lebi'i hermanos israelitas nna ca tàta nna liudaáruhuá naga' le ca titsa' nu quixa'ánia' le: Iyaba ri'u nna ná ri'u descendiente qui' tà' tàta qui' ri'u Abraham enne' gùdua tiempo antigua. Tata Dios enne' dua ỹiabara' nna gùnnie lani bi loti' dua rù bi le' región Mesopotamia ántesca tsía bi thua bi le' ttu yetsi láą Harán nna, ");
INSERT INTO zaaNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","rèe bi: Bìria látsi lu' nna bètse'e latsi' ca pariente qui' lu' nna huía attu lèttia lá, inte' nna huànidiga' gaỹa thua lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Biria tè Abraham le' región qui' ca enne' caldeos nna huía bi gùdua bi le' yetsi Harán; nía nna gùttì tàta qui' bía. Làniana guthèl·la' Tata Dios bi làti tsè'e le anna. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero Tata Dios nna labí bete tìe lóyúį lani bi tiempo lània, nìdirubani làti gudu ttu nì'a bi. Sino benìnie bi prometer qui'ni gútie na latsi' ná' bi ą'hua lani ca ỹi'ni bi bitola, màsqui'ba lanú ỹi'ni bi chi té lània. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tata Dios nna rèe bi qui'ni ca descendiente qui' bi canu galia bitola nna ccá cabi enne' dìttu' le' attu nación huaya'. Ą'hua rèe bi qui'ni canu nía nna guthítsini cą cabi para guni cabi tsina lo quį, aníaba tsé'e cabi por tappa gayua' ida. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tata Dios nna ra ruhuée bi: Inte' nna gunia' castigar ca enne' qui' nación làti guni ca descendiente qui' lu' tsina lo quį: pero bitola nna gunia' qui'ni eria cą nía nna guni cą inte' servir lugar nì. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Prueba de qui'ni Tata Dios nna née enne' fiel para gunie cumplir iyaba nu chi rèe Abraham nna uccuą ttu seña cuerpo qui' Abraham láą circuncisión por mandado qui' Tata Dios. Acca loti' bitsina' ỹi'ni bi Isaac nna beni Abraham na circuncidar de uccuanią xùnu' ubitsa, porqui'ni Abraham nna huíalatsi' bi Tata Dios. Anía tehuá beni Isaac lani ỹi'ni bi Jacob, ą'hua Jacob lani tsì'nu ca ỹi'ni bía ca enne' gùdulo raza qui' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","La'a mísmuba ca ỹi'ni Jacob canu ná tà' tàta qui' ri'u gutsé'e tiempo antigua nna gùppa cą la' yélatsi' lani bettsi' quį José nna, bèttì' cą bi lani tuchùppa ca enne' dia para país láą Egipto. Pero Tata Dios gùdu bée lani Joséa nna ");
INSERT INTO zaaNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","gutue iyaba ca problema qui' bi nna benie qui'ni gùta'ni bi gracia nna la' riyeni tsè' nna ru'a lo Faraón enne' uccua rey qui' Egíptua; acca beduą bi para ccá bi gobernador qui' itute Egíptua ą'hua sobre iyaba ca interés nu té quì'į nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Làniana uccua ttu ùbina' fuerte ni le' ituba región qui' Egíptua ą'hua hàstaá Canaán làti gutsé'e ca ỹi'ni Jacob. Yala uccua ca enne' sufrir hasta qui'ni ą'hua ca tà' tàta qui' rí'ua nna labí té nu go cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Bina bá tà' tàta qui' ri'u Jacob qui'ni yala ỹua' té le' país Egiptua, acca guthèl·la' bi ca ỹi'ni bía nía para táyo'o cą ỹua'. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Pero nu cca chùppa vuelta guthèl·la' bi cą Egíptua nna, gutixa'ani Joséa cą qui'ni la'a làbi nuá bettsi' caniá nu beni cą maltratar. Anía modo uccua Faraón saber nuỹa ná familia qui' Joséa. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Làniana gutàỹi Josée tàta qui' bi Jacob ą'hua iyaba ca pariente qui' bía para tsía cą Egíptua. Uccua gàyuna' tsìnu' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Acca huía tè Jacob hàstaá Egíptua para thua bi. Nía bá gùttì bi ą'hua tsì'nu ca ỹi'ni bi canu gùdulo raza qui' ri'u nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bitola nna tahua' cą ca cuerpo qui' cabi hàstaá Canaán, nía nna becàttsi' cą cabi le' ttu loyu nu huí'i Abraham qui' ca ỹi'ni ttu enne' láą Hamor le' yetsi Siquem. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Loti' chi debíga' tiempo qui'ni ccá cumplir promesa lígani qui' Tata Dios lani Abraham, adírulá xeni chi ná yetsi Israel, pues nuỹetse' cą chi huàni le' país Egíptua. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pero bitola nna gùdua attu rey para cu'úbi'ą Egíptua', pero lą nna labí benibí'ą Joséa porqui'ni lanuru Joséa té, qui'ni chi gùttì bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Rey cúbía nna bethacca'ỹíą ca enne' qui' rí'ua nna labí beyu tsì'ą cabi hàstaá qui'ni benią mandado gatti ca huatsa to' qui' cabía confórmea galia cą, para qui'ni bíttuúru tsání raza qui' rí'ua. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","La'a mísmuba tiempo lània nna gùlia ttu nubeyu' to' gùta' láa bi Moisés; Tata Dios nna yala guyú'u latsi'e bi. Por tsùnna biú' teruba bìrialàni ca tàta nàna qui' bía becàttsi' cą bi le' yú'u. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Loti' chìa ná para qui'ni gatti bi nna, la'a mísmuba ỹi'ni niula qui' rey Faraón bedi'ą bi nna bediỹènią bi ti'atsi ỹi'ni bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moisés nna bidète' ba bi ituba ciencia nu nabia'ni ca enne' Egíptua. Yala tsè' gùre' la' riyeni qui' bi para inne bi nna guni bi tsè' biỹa tsina. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Loti' ùccuanì Moisés chùà' ida nna belaba latsi' bi tanèl·lia' bi ca enne' ná raza qui' bi ca enne' Israel. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Bilá' tènì bi ttu nu Egíptua runią maltratar ttu enne' qui' bía, acca bèdi' bi ą nna bèttì bi nu Egíptua, anía modo nna bèdi' bi yèe' qui' enne' qui' bía. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Belaba latsi' bi qui'ni ca enne' qui' bía nna huènnia cą cuenta qui'ni Tata Dios nna gudilèe cą latsi' ná' canu Egíptua por medio de làbi, pero làcą nna labí gutelíni cą anía. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Porqui'ni attu yu'utsá nna bitsina' bi làti tsè'e chùppa canu ritìl·la entre ca enne' qui' bía, acca uccua taá latsi' bi gútse'e tsè' bi cą nna ra bi cą: Bettsi' bá lé cca, biánícca rue' luetsi le. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Entonces nu runi maltratar attu nubéyu'a nna becàbią Moisés: Núní beduą lu' para cu'úbia'ni lu' intu' nna guni lu' lu'uxtícia qui' tu' nì'i, ");
INSERT INTO zaaNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","tsí càhua latsi' lu' gutti lu' inte' tì'a betti lu' enne' Egíptua nàya cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Biyeni báni Moisés ca tìtsa'a nna becuìtta taá bi huía bi idittu' hàstaá látsi ca enne' madianitas. Nía bá bettsaná' bi nna gutsé'e chùppa ỹi'ni bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Chùà' ida ti'ga bitola nna loti' gurèni bi làti dua i'ya láą Monte Sinaí nna bila'ni bi ttu ángel le' ttu tìttsa yèttse' nu ritelàl·làni. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Bilá' báni Moisés nuá nna yala uccuaỹí latsi' bi, acca gubiga' tè bi para inna' tsè' bi biỹa nuá, làniana biyénini bi tsì'i Señor Dios nna rèe bi: ");
INSERT INTO zaaNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Inte' ná Dios qui' ca tà' tàta qui' lu' Abraham nna Isaac nna Jacob nna. Màsqui'ba para yétsiloyu chi gùttì cabi, pero lani inte' nna bàni ba cabi. Biyeni báni Moisés qui'ni rinne Tata Dios lani bi nna gùdulo bi biỹìtti'ni bi. De tantua gùtsini bi nna labiru beyáỹani bi inna' bi làti re' yèttse' nu ràl·la'a. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tata Dios nna gunènie Moisés adí nna rèe bi: Gulèqquia ca guarachu qui' lu'ą' nì'a lu', porqui'ni làti du lu'ą' nna ną́ lugar santo, ");
INSERT INTO zaaNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","hualigani qui'ni chi bila' te' ti'iỹa ná la' ritè qui' ca enne' quia' tsè'e Egíptua; hàstaá ỹiabara' chì huá biyeni te' la' ribetsi qui' quį por iyaba nu ruthacca' canu nía cą; acca rínnía' lani lu' porqui'ni calátsa'a' gudilá ya' le làtsi' ná' canu Egíptua. Annana, bèduli porqui'ni calátsa'a' ithél·la'a' lu' Egíptua. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Anía beni Tata Dios, màsqui'ba chi betsìbi cą Moisés nna ra cą bi: Núní beduą lu' para cu'úbia'ni lu' intu' nna guni lu' lu'uxtícia qui' tu' nì'i; pero Tata Dios nna guthèl·le'e Moisés para ebèqquia bi cą nía nna gudilà bi cą làtsi' ná' nu uccua rey qui' Egíptua, por medio de la'huacca qui' ángel enne' bila'ni bi le' yèttsi'a. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","La'a mísmuba Moisés nna bebèqquia bi cą le' Egíptua bitola de beni bi iỹetse' ca milagro ą'hua adí ca señal de la'huacca qui' Tata Dios le' región qui' Egíptua, ą'hua loti' biyàlia ttu néda le' indatò' nu láą Mar Rojo nna guttè cabi làhui'. Beni hua bi adí ca milagro loti' gutsé'e cabi le' desiértuá por chùà' ida. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","La'a mísmuba Moisés nna gunèni bi ca enne' Israel nna ra bi cą: Huàl·lani tsá qui'ni Señor Dios enne' becuí'e inte' nna guni huée qui'ni attu descendiente quì'ba le ccá huée profeta. Acca líúda naga' le quì'e nna liguni nu ínneé. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ttu ángel nna gudue ru'a lo Moisés loti' huàppi bi lo i'ya nu lá Monte Sinaí. Angeliá nna bì'e titsa' lani bi, ą'hua lani ca tà' tàta qui' ri'u gutsé'e lània. Beni Moisés recibir ca titsa' de la'labàni nu bethà'na bi hàstaá lani ri'u anna. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Pero ca tà' tàta qui' rí'ua nna labí uccua latsi' quį gudà naga' quį qui' Moisés, sino betsìbi lá cą bi nna tulidàba bedua iqquia quį eyéqquia cą Egíptua. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Làniana ra cą Aarón: Beni ttu biỹa imagen para ccą́ dios qui' tu' nna gunią intu' cuàlani porqui'ni Moisés nu guleqquią ri'u le' Egíptua nna, quiligáhuá té néda guỹi' bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Làniana beni cą ttu ídolo nu de oro forma de gù'na para guduỹíbi quį ru'a lúį, ą'hua bèttì cą iỹé ca animal nna betsia cą cą ru'a lo ídoluá nna beni cą fiesta quì'į. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Acca Tata Dios nna bétse'e tè latsi'e cą nna be'èl·la' telée cą guni cą adorar hàstaá ca bélia tsìa ỹiaba tì'a chi ra Tata Dios lo ca libro làti ga'na escrito por ca enne' uccua profeta quì'e: Lebi'i ca enne' Israel, durante chùà' ida nu gureni le le' desiértuá nna iỹétse' ca animal to' betti le para sacrificio. Tsí por inte' ba beni le cą ofrecer cá. Labí. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ą'hua gulèqquia le estatua qui' Moloc lani yáníỹúla quì'į; Ą'hua beni le ttu figura forma de ttu bélia para ccą́ representar Remfán nu rena le qui'ni ná dios qui' le; Ą'hua adí ca figura nu beni le nna beduỹíbi le ru'a lo quį. Acca guté telá' le cuenta para iche' cą le adírulá idittu' de le' nación nu láą Babilonia, para ccá le esclavo nna guni le tsina lo quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ca tà' tàta qui' rí'ua nna beni cabi ttu carpa xeni nu biỹu' de templo provisional para làcabí. Lè' templua nna gutua cabi ca tabla íyyá làti ga'na escrito lo quį ca mandamiento nu bete Tata Dios lani Moisés. Carpa nu biỹu' de templo qui' cabía nna beni cabi ą tì' taání belue'ni Tata Dios lani Moisés loti' gunènie bi qui'ni ą́' ná nu guni bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Adí ca tà' tàta qui' ri'u gutsé'e bitola nna bìà' cabi iyábani material bèniní cabi templua gaỹa tediba huía cabi. Gutà'a cabi le' región qui' ca enne' huaya' lani Josué enne' uccua capitán qui' cabía. Tata Dios nna gulèqquie ca contrario qui' cabía látsi quį, pero lóyú qui' caniá nna betie na qui' ca tà' tàta qui' rí'ua. Anía uccua hàstaá tiempo qui' David. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David nna gùppa bi favor ru'a lo Tata Dios. Gunàbani bi Tata Dios tì'a huía huá latsi' tà' tàta qui' ri'u Jacob, qui'ni gudua bi ttu templo para lèe. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero álahua David bedua templua para Tata Dios, sino ỹi'ni bi Salomón lá bedua bi ą. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Yù bá ri'u qui'ni Tata Dios enne' dua ỹiabara' nna labí due le' ca yú'u nu runi ba ca enne', tì'a ra Tata Dios làti ga'na escrito por enne' uccua profeta quì'e: ");
INSERT INTO zaaNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ỹiabara' ba ná trono quia', yétsiloyu nna ná tìą làti rudu ca nì'a'. Biálá yú'u ní gudua le para inte' cá, gálá nuą' dua lugar làti edi látsa'a' cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tsí álahua inte' ba beni iyaba ca cosį cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Beni ba Esteban seguir gunne bi nna ra bi: Yala enne' cabezudo ná le, ą'hua l·liu'u losto' le nna ą'hua la' riyeni qui' le nna ną́ tì'a rulaba latsi' canu labí ríalatsi' quį Tata Dios. Tùlidàba tsè'e le contra Espíritu Santo. Tì'a beni ca tà' tàta qui' lía, ą́' tehuá runi le. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Porqui'ni nú lá ca profeta bíhuá uccua cabi sufrir por ca tà' tàta qui' lía cá. Anteslá bèttì cą ca enne' gutixa'a con tiémpuní qui'ni íl·lani ttu enne' labí té falta quì'e, pero de gùl·lanie nna bete la li e cuenta hasta qui'ni bètti li e. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Lebi'i lá nuą' beni recibir ca mandamiento nu benna Tata Dios por medio de ca ángelia para guni le nu rèe, pero labí runi le cą. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Biyeni báni cą ca tìtsa'a nna bitsa'á láni cą Esteban nna uccua latsi' quį gúttí cą bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Por la'huacca qui' Espíritu Santo nna gunne Esteban ca tìtsa'a nna gùnna' tè bi ỹiabara' nna bila'ni bi la'yani' nu dá' dèsdeba ỹiabara' la làti dua Tata Dios. Bilá' báni bí Jesús qui'ni du tìe lado ná' bàni qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Làniana ra tè bi: Anna tení rila' te' yalia ỹiabara', linna' tsaáruhuá qui'ni Nubeyu'a nna du tìe lado ná' bàni qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Làcą nna guretsi ya'ání cą nna bethàya naga' quį nna bitsina' chì cą ttu tiempo ba para gúttí cą bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Làniana gulèqquia tè cą bi fuera yétsiá. Canu uccua testigo falso contra Esteban nna becùà' cą ca lári' qui' caniá ru'a lo ttu nubeyu' láą Saulo para qui'ni huí'ą cą cuidado. Gùdulo tè cą rue' cą Esteban íyyá. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Beni ba cą seguir bedua cą íyya iqquia Esteban miéntraste beni bi oración nna ra bi: Señor Jesús, bedi' cuią'lu' espíritu quia' canchu chi gattia'. ");
INSERT INTO zaaNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Làniana beduỹíbi bi nna gunne bi idìtsa nna ra bi: Señor, bittu exalatsi' cuią'lu' túl·li'į nu runi cą. Beyacca ba ra bi anía nna gùdulo descanso eterno qui' bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Nubeyu' lá Saúluá nna gùdu bą́ de acuerdo qui'ni gutti cą Esteban. Ca tsá lània nna gùdulo cą betsia latsi' quį ca creyente qui' iglesia nu re' Jerusalén. Acca gùthilàlia ba iyaba cabi ituba región qui' Judea nna Samaria nna, pero ca apóstol nna beyà'na ba cabi le' Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tuchùppa ca creyente fiel nna guche' cabi cuerpo qui' Esteban nna becàttsi' cabi bi; yala guretsi cabi por nu uccua lani bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saúluá nna beni bą́ seguir betsia latsi'į ca enne' ríalatsi'á; gutà'ą le' ca yú'u qui' cabi nna guté'yą cabi nna bedàl·lą cabi litsi' iyya, tàntua ca nubeyu' l·le ca niula l·le. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pero ca enne' gùthilàlia ba nna huía cabi itú lèttia tabání huèquixa'a evangelio. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felípea nna huía bi para ttu yetsi le' región Samaria nna beni bi predicar nu cca qui' Cristua. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Betùppa tè nuỹetse' ca enne' yétsiá nna yala tsè' bedà naga' quį nu gutixá'ani Felípea cą. Biyénini cą predicación qui' bi nna bila'ni cą ca milagro nu beni bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Porqui'ni por Felípea nna acca iỹetse' canu uccua padecer por ca espíritu malo nna ribetsi yà'ani cą beria cą lo losto' ca ènni'a. Ą'hua iỹetse' canu ra'ni parálisis nna ca enne' cojo nna beyacca latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Acca iyábani ca enne' le' yétsiá nna yàlaní la' redacca' latsi' guta' qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Gùdua ttu nubeyu' láą Simón, chìa gutsá ną́ huatsaa' nna yala bethacca'ỹíą ca enne' Samaria nna yala enne' ỹeni belaba latsi'į uccuą. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Iyaba ca enne' nna yala huíalatsi' quį quì'į, tàntua canu adiru cuìti' hàstaá ca enne' gùla nna ra cą: Là nui nna du meru gani la'huacca ỹeni qui' Tata Dios lani ą. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Yala gùppa cą titsa' nubéyu'a porqui'ni berexaèl·la'ą cą por medio de la' huatsàa' nu runią chìa gutsà ni. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Biyeni báni ca enne' yétsiá predicación qui' Felípea acerca de ca titsa' tsè' cubi nu cca qui' la' rigú'ubia' qui' Tata Dios nna Jesucristua nna, huía tè latsi' quį nna uccua cą bautizar tàntua ca ènne'yu' l·le ca niula l·le. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","La'a mísmuba Simón nna huía huá latsi'į. De chi uccuą bautizar nna tulidàba gurènią lani Felípea; ą'hua de bila'nią ca milagro nu beni Felípea ą'hua adí ca hecho nu rulue' la'huacca qui' Tata Dios lani bi nna yala biquila' latsi'į. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bina bá ca apóstol tsè'e le' Jerusalén qui'ni ca enne' Samaria nna chì huá ríalatsi' quį titsa' qui' Tata Dios, acca guthèl·la' cabi Pedrua nna Juáan nna nía. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bitsina' bá cabi nía nna beni cabi oración por canu ríalatsi'á para qui'ni thi' cabi la'huacca qui' Espíritu Santo. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Porqui'ni lanú nuỹa íqquia ní chi huàdi la'huacca qui' Espíritu Santo lània entre ca enne' Samaria, sino qui'ni uccua cą bautizar tsua' teruba lani nombre qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pero de betsia ná' ca apóstol iqquia ca ènni'a nna gul·lani tabá Espíritu Santo lani cą. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simón nu guỹeni mágia ántesca tsíalatsi' niá nna, de rutsia ná' ca apóstol iqquia ca enne' nna ridi' cą la'huacca qui' Espíritu Santo, acca bèninią cabi ofrecer bel·liu nna, ");
INSERT INTO zaaNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","rą cabi: Ligúnna huá la'huacca quia' para qui'ni nuỹa tediba gútsía nàya' iqquį nna gunią recibir la'huacca qui' Espíritu Santo. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedrua nna ra tè bi ą: Tata Dios nna gunie lu' castigar tsa'tséla tehuá bel·liu qui' lu'ą', porqui'ni rulaba latsi' lu' gó'oní lu' favor nu ỹa runna ba Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Labí té derecho qui' lu' para lání lu' le' tsìnį, porqui'ni la' rulábalatsi' qui' lu' nna labí ną́ tsè' ru'a lo Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Acca beyàtta'yú lani Tata Dios por maldad qui' lu'ą' nna, xiaba canchu lèe nna eyuniỹén latsi'e qui' lu' por la' rulábalatsi' mal nu yù'u lo losto' lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Porqui'ni rilá' te' qui'ni yù'u ba lu' le' la' chul·la, ą'hua tul·la' qui' lu' nna ỹiga' bánią lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Becàbi Simón nna rą: Linàbani Señor por inte' para qui'ni nìdi ttu ca cosa nu chi ra lią́' nna làa thacca' ya' ą. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Làniana Pedrua nna Juáan nna de chi bete cabi testimonio nu cca qui' Jesucristua nna gùtixa'a cabi titsa' qui' Tata Dios le' iỹetse' ca yetsi anta' Samaria nna, beyeqquia cabi Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Bitola nna gunne ttu ángel enne' guthèl·la' Señor lani Felípea nna rèe bi: Gùduli nna huía gutèl·la' néda yúbitsi nu riria dacca' lado sur qui' Jerusalén para yetsi láą Gaza. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Làniana gùduli chì Felípea nna guda' chì bi. Tiémpuá nna bila'ni bi ttu enne' Etiopía nación qui' Africa. Nubéyu'a nna uccu ą empleado nu dacca' le' palacio qui' Candace niula uccua reina qui' ca enne' Etiopía. Nubéyu'a nna ną́ ttu nubeyu' eunuco, bì'ą cuidado iyaba ca riqueza nu té qui' niula rigú'ubi'á. Empleádua nna huíą le' Jerusalén huèni Tata Dios adorar. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Beyeqquia tìą látsį nna deyu'ą́ le' carreta qui' niá nna rul·la tìą escritura nu ga'na escrito por Isaías enne' uccua profeta qui' Tata Dios tiempo chìa gutsá. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Espíritu Santo nna rèe Felípea: Gubíga' luítta' carretą'. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Gubiga' tè Felípea nna biyénini bi qui'ni nubeyu' Etiopía nna rul·lą escritura nu bedia profeta Isaías, acca ra tè bi ą: Tsí hua ritelíni lu' biỹa nuą' rul·la lu' cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Becàbią nna rą bi: Ti'ani modo ttéli te' canchu núhuá nuỹa ethàtsilà'nanią inte' nì'i. Làniana gùtta'yú tènìą Felípea qui'ni tsappi bi nna cue'ni bi lani ą le' carreta. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Lectura làti rul·la naá nna ra íį: Tì'a riche' cą ttu carnero para gutti cą na, ą́' tehuá guche' cą ne. Ą'hua tì'a ttu carneru to' labí biỹa runią canchu chi richu cą ittsa' ỹúį, ą́' tehuá lèe nna labí bedudítsié de chi ruthácca' cą néa biỹa. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Beni cą ne tratar ti'atsi labí enne' re' cuenta née, ą'hua labí lu'uxtícia beni cą quì'e. Acca núní ccani equixá'a ti'iỹa tegá mal uccua canu gutsé'e tiempo quì'e cá. Gutua cą la'labàni quì'e le' yétsiloyuį. Ą' ra lo Escritura. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Làniana ra tìą Felípea: Bethàtsilà'na bál·lani inte': Núní quí'ní nui rinne profeta, tsí la'a quì'ba bi, o, tsí qui' nuỹa attu enne' ba áccá. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Felípea nna gùdulo bi por medio de Escritura nna gutixa'ani bi ą ca titsa' de salvación nu runna Jesucristua. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Néda ba yù'u cabi nna taxácca' cabi ttu lèttia làti yù'u inda. Acca ra tè nubéyu'a: Chi gul·lani ri'u làti yù'u inda. Tsí bihua cca tìà' bautizar anna cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felípea nna ra bi ą: Huacca láaná canchu hua ría latsi' lu' lani itute losto' lu'. Becàbią nna rą: Hua ría ba látsa'a' qui'ni Jesucristua nna née Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Beni tìą mandado qui'ni thutsi carreta. Làniana huàdi tè chùppa taá cabi le' inda nna beni tè Felípea na bautizar. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","De beria cabi le' inda nna, Espíritua nna de repente tabá bedi'e Felípea nna bedue bi attu làti huaya'. Nubeyu' Etiopía nna labiru bilá'nią bi nna deyya tìą látsį lani la' redacca' latsi'. ");
INSERT INTO zaaNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Bitola nna bilá' tènì cą Felípea le' yetsi láą Azoto. Gutè ba bi nía nna beni bi predicar evangelio le' ttu ttu ca yétsiá nna bitsina' bi Cesarea. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo nna beni bą́ seguir betsia latsi'į canu ríalatsi' qui' Señor, hàstaá qui'ni beduą iqquį gúttíą cabi. acca huíą ru'a lo nu uccua sumo sacerdótea, nna ");
INSERT INTO zaaNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","gunàba tìą orden para gutią lani canu rigú'ubia' le' ca sinagoga le' ciudad Damasco, para qui'ni canchu etselánią nuỹa ttu ca ènne'yu' l·le ca niula l·le canu ríalatsi' qui' Cristua nna íchi'ą cabi preso para Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Néda bá yù'u Saúlua chi' taáduą itsina'ą le' ciudad Damáscuá, de repente taá nna gul·lani ttu la'yani' qui' ỹiabara' nna bedàni'ą ìta'lùbanią. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Acca la'a mísmuba làti du naá gubixi chìą loyu nna biyeni tènìą tsì'i ttu enne' gunènie na, nna rèe: Saulo, Saulo, biánícca rutsia latsi' lu' inte' nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saúluá nna ra tìą: Núní lu' nuą' Señor. Enni'a nna rèe na: Inte' ná' Jesús enne' rutsia latsi' lu'; la'a lu' ba runidí' qui' lu' por nu runi lu'ą'. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Biỹìtti'ni Saúlua de tantua la' rátsilatsi' nna rą: Biani calatsi' cuią'lu' gunia' Señor. Lèe nna ra tìe na: Beyátha nna beyya le' ciudą́'; nà' ba nna ccá lu' saber nu ná qui'ni guni lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ca nubeyu' dia lani Saúlua nna cuenta gudàa tsi ba cą nna uccuaỹí bá latsi' quį porqui'ni biyénini cą tsì'iá pero lanú nuỹa bila'ni cą. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Beyatha tè Saúlua nna uccua latsi'į ínna'ą pero labiru bilá'nią. Acca gutèl·la' bání cą ní'į nna guche' cą na Damáscuá. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nía bá gùdua Saúlua tsùnna ubitsa, labí uccua ilá'nią nna. Labí gutúą nìhua inda labí gu'yą. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Le' Damáscuá nna gùdua ttu enne' chi huíalatsi', lá bí Ananías. Gunèni Señor bi lo yèlà nna rèe bi: Ananías. Becàbi bi nna ra bi: Nì bá dua' Señor. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Señor nna rèe bi: Huàtha, huía calle nu láą Derecha litsi' Judas nna, inàba titsa' lu' por ttu nu lá Saulo nu yetsi Tarso, porqui'ni lą nna runią oración anna, ");
INSERT INTO zaaNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ą'hua chi uccuą saber qui'ni itsina' lu' làti duą, porqui'ni tì'a ttu nu rinneni yèlà ba bilá'nią qui'ni gutà'a ttu enne' lá bí Ananías nna betsia ná' bí iqquį para qui'ni elá'nią. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananías nna rabi e: Señor, nuỹetse' cą chi ra cą inte' nu cca qui' nubéyu'ą' qui'ni yala telá mal chi benią qui' ca enne' qui' cuią'lu' tsè'e Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ą'hua ca sacerdote principal nna chi bete cą orden quì'į para gudàxu'ą tu' preso, iyaba tu' canu runi tu' oración lani nombre qui' cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Señor nna rèe bi: Huía, porqui'ni chi réeé' te' nubéyu'ą' para uquína' ya' ą tsíą huèquixa'a nu cca quia' ru'a lo ca enne' qui' adí ca nación nna ca rey qui' quį nna, ą'hua ca enne' Israel nna; ");
INSERT INTO zaaNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","inte' nna gulué'ni ya' ą ti'iỹa tegá ná qui'ni ccą́ padecer por nu cca quia'. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Làniana huía te Ananías. Gutà'a bi le' yú'a nna betsia ná' bi iqquia Saúlua nna ra tè bi: Hermano Saulo: Señor Jesús enne' bila'ni lu' loti' yù'u lu' néda chi guthèl·le'e inte' para qui'ni gunia' oración para lu' para qui'ni elá'ni lu' nna guni lu' recibir la'huacca qui' Espíritu Santo. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Luegu taá nna tì'a ná bía ná nu betua lo Saúlua, lània taá nna belá' chìnì bi. Gùduli tè bi nna uccua bi bautizar. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Làniana beyò bi etta nna beyatta' fuerza qui' bi. Gùdua bi le' ciudad Damáscuá tuchùppa ubitsa lani ca enne' chi ríalatsi'á. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Bitola nna gùdulo bi gùtixa'a bi nu cca qui' Cristua. Le' ca sinagoga qui' ca judíua nna beni bi declarar qui'ni Jesús nna hualigani née Ỹi'ni Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Iyaba canu biyénini cą qui' bi nna uccuaỹí bá latsi' quį nna ra cą: Tsí álahua nui nuá rutsia latsi'į canu rudettia láa Jesús le' ciudad Jerusalén, acca da' huą́ nì para gutsia latsi'į canu ríalatsi' nna íchi'ą cą preso ru'a lo ca sacerdote principal cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero Saúlua nna lani adí lá valor beni bi predicar hasta qui'ni gulèqquia ỹínią́ latsi' ca judío tsè'e Damáscuá, gutixa'áni bi cą claru tení qui'ni Jesús nna née Cristo enne' ribèda cą qui'ni íl·lanie. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Gutè tí' diba tsá nna gulèqquia latsi' ca judíua gutti cą Saúlua. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Gùtse'e tè cą guardia ru'a ciudáad la' réla la' ritsa ba ribèda cą bi para gutti cą bi. Pero Saúlua nna bina bi nu re'ni cą guthacca' cą bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Acca de réla lá nna gulìda ca enne' chi ríalatsi'á Saúlua dacca' lo dé'è nu yeqquia ciudáad, yù'u bi le' ttu tsùmmi xeni. Anía modo nna gulà bi làtsi' ná' canu rutsia latsi' quį bía. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","De betsina' Saúlua Jerusalén nna beyìla bi làti tsè'e ca creyente qui' Señor, pero iyaba cabi nna yala gùtsini cabi bi porqui'ni labí chi yù cabi qui'ni chì huá ná bí creyente. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Làniana guche' Bernabé Saúlua ru'a lo ca apóstol nna, bè'ni bi cabi titsa' ti'iỹa uccua bilá'ni Saúlua Señor Jesucristua loti' yù'u bi néda nna, ą'hua nu rèe bi nna. Gùtixa'a huá bi ti'iỹa beni Saúlua predicar lani valor le' Damáscuá nu cca qui' Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Làniana gurèni ba Saúlua lani cabi le' Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sin la' rátsilatsi' nna gunne bi nu cca qui' Señor, ą'hua beni bi discutir lani ca judíua canu rinne titsa' griego; pero làcą nna luegu taá uccua lá latsi' quį gutti cą bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bina bá ca hermanos nui nna huía cabi lani bi hàstaá yetsi Cesarea; nía nna bethèl·la' cabi bi para yetsi qui' bi Tarso. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Làniana le' ituba región qui' Judea nna Galilea nna Samaria nna labiru betsia latsi' quį ca enne' nu chi ríalatsi' màsqui'ba runi cabi reunión. Ą'hua adí lá tsìttsì uccua cabi nna beni cabi Señor obedecer lani la' rátsilatsi' lo losto' cabi. Espíritu Santo nna betie fuerza qui' espíritu qui' cabi; acca yala huàni adí ca enne' nu ríalatsi' qui' Señor. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Loti' gurèni Pedrua huèni visitar iyaba ca creyente nna, huía huá bi huenèl·le' ca creyente fiel tsè'e le' yetsi láą Lida. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nía nna gùdua ttu ènne'yu' gùta' lá bí Eneas, chi uccua xùnu' ida téą rà'nią lani parálisis nìdi làa cca ttą́. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedrua nna ra bi ą: Eneas, Jesucristua reyúnie lu'. Huàtha nna bedàppa ca lari' qui' lu'ą'. Lą nna beyatha chìą. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Iyaba canu tsè'e le' yetsi Lida ą'hua le' yetsi Sarón, de bila'ni cą qui'ni chi beyacca latsi' nubéyu'a nna, acca betse'e latsi' quį ca creencia qui' quį nna huía latsi' quį Señor Jesucristua. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Gùdua le' yetsi láą Jope ttu niula creyente gùta' líį Tabita, titsa' griego nna lá huą́ Dorcas. Tulidàba gùppą la' retúalatsi' por ca enne' pobre nna benią cą cualani. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tiempo lània nna yala fuerte huì'nią nna labiru beyacca latsi'į. De chi gùttìą nna begàdia cą na gutìxa tè cą na le' yú'u ỹéniá. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yetsi Lida nna rì'ą exa bá yetsi Jope. Acca de bina ca creyente tsè'e le' Jope qui'ni le' yetsi Lida re' Pedrua nna, guthèl·la' tè cą chuppa ca Enne'yu' para gatta'yúni cą bi nna ra cą: Gutàxia bál·la cuią'lu' lani intu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedrua nna huía chì bi lani cą. Bitsina' bi Jopea nna guche' cą bi le' yú'u ỹeni làti téni cą cuerpo qui' Dorcas. Nía huá tsè'e ca niula viuda ritè la'dí' yala ribetsi cą nna belue'ni cą bi ca vestido ą'hua adí ca lári' nu gutía Dorca loti' bàni rù naá. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedrua nna beni bi mandado qui'ni íria sà iyaba cą fuera, làniana beduỹíbi bi nna beni bi oración. Beyacca ba beni bi oración nna bedèqquia lo bi làti té nu yàttìa nna ra bi: Tabita, beyátha. Lą nna benna'ą, bilá' chìnìą Pedrua nna gurè' tènią. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedrua nna bedaxu' tè bi ní'į nna bethùli bi ą. Làniana beyàỹi bi ca enne' chi ríalatsi'á ą'hua ca niula viuda nna beni bi Dorcas presentar lani cą qui'ni chi beyacca bànią. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Itúbani le' yetsi Jópea nna bina cą nu uccua, acca nuỹetse' cą beni cą Señor aceptar. ");
INSERT INTO zaaNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedrua nna beyà'na bi iỹé ubitsa le' yetsi Jópea litsi' ttu nubeyu' láą Simón nu rùcùtsì yéti para zapato. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Gùdua ttu nubeyu' le' yetsi Cesarea láą Cornelio, uccuą capitán qui' gayua' ca soldado qui' ejército italiano. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nubéyu'a nna yala adorar benią Tata Dios, ą'hua yala obedecer beni bi e lani la' rátsilatsi' lo lostu'į; anía bá beni iyaba canu tsè'e lìtsi'į. Yala' huá cualani benią ca enne' Judea canu ritè la'dí', ą'hua tulidàba benią oración. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ttu tsá nna ritį tsùnna ti'gá de diál·lalá nna, ti'a ttu nu rínneni yèlà ba bilá'ni Cornéliua claru tení ttu ángel gutà'a bi làti duą hueni adorar. Ángelia nna ra bi ą: Cornelio. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Lą nna betsia tsìttsì ba lúį bi yala lani la' rátsilatsi' nna ra bi: Biágání nui Señor. Ángelia nna ra tè bi ą: Tata Dios nna chi biyéninie ca oración qui' lu', ą'hua chi bilá'nie la' retúalatsi' nu té qui' lu' lani ca enne' pobre. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Acca guthèl·la' ca mozo qui' lu'ą' le' yetsi láą Jope para taxi' cą Simón enne' lá huá bí Pedro ");
INSERT INTO zaaNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","enne' dua litsi' ttu enne' rùcùtsì yeti para zapato láą Simón, duą exa bá ru'a indatò'. Pedrua nna quixá'ani bi lu' biỹa ná qui'ni guni lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Beria díbá ángelia làti du Cornéliua. Gutàỹi tè Cornéliua chùppa ca huenitsìna qui' niá nna ą'hua ttu soldado fiel nu yala huá adorar benią Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Gutixa'ánią cą iyaba nu uccua acerca de nu bila'ni naá, bitola nna guthèl·la'ą cą para yetsi Jope. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Attu yu'utsá nna exa tegáabá ru'a ciudad chi dia cą, huàppi Pedrua iqquia yú'u lo azotea para guni bi oración. Ttu tsì'nu hora ti'gá nuá. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Gutùni l·lání Pedrua nna quelibí l·lání go bi ùccuanì bi, pero miéntraste runi cą ỹuhué bi nna de repente taá nna bila'ni bi tì'a ttu nu rínneni yèlà. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Bila'ni bi yálíá ỹiabara' nna huàdi' tè ttu lári' ỹíga' tappa esquina quì'į forma de ttu bédútí. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Le' nuá nna yù'u iyábani clase de ca animal: canu tsìa tappa nì'a quį, ą'hua canu riyé'ya bání lè'e quį, ą'hua canu ridàa lo be' nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Làniana biyéni tènì bi tsì'i ttu enne' nna rèe bi: Pedro, gùỹi' nna bèttì nna gùtò. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Becàbi Pedrua nna ra bi: Labí Señor, porqui'ni nìdi tsa ní'i gua' iyání nu ro ca enne' qui' adí ca nación, nìhua biỹa cosa nu rilátsi' lani ca cosa cùttsi nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Làniana biyéniní tsì'i Enni'a nu cca chuppa vuelta nna rèe: Nu chi beni nàrì Tata Dios nna bittu ína lu' qui'ni ną́ cùttsi. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Por tsùnna vuelta uccua anía. Bitola nna beyèl·la' ba Tata Dios lári'á ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Miéntraste dù ba Pedrua cani bi nùyue nna rulaba latsi' bi de nu cca qui' visión nu bila'ni bía nna, bitsina' tè ca nubeyu' canu guthèl·la' Cornéliua, bitola de gunàba titsa' cą gaỹa nua' dua litsi' Simón. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Gunne tè cą ru'a puerta nna gunàba titsa' cą canchu nía dua Simón enne' lá huá bí Pedro. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Àtsaba rulaba latsi' Pedrua sobre de nu guỹácca' bía nna ra tè Espíritu Santo bi: Nà' tè tsè'e tsunna ca nubeyu' reyìla cą lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Acca beyàdi nna bittu tehuá ccani lu' qui'ni làa tsía lu' lani cą, porqui'ni inte' ba guthél·la' ya' cą nì. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Làniana beyàdi tè Pedrua làti tsè'e ca nubeyu' guthèl·la' Cornéliua nna ra tè bi cą: Inte' nuą' reyìla le. Biani razón ni nùà' le. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Becàbi cą nna ra cą: Dá' tu' por mandado qui' ttu Capitán láą Cornelio, ná bi ttu ènne'yu' tsè' nna yala obedecer runi bi Tata Dios lani la' rátsilatsi' lo losto' bi, ą'hua yala tsè' dàa titsa' qui' bi entre ca enne' Judea. Ttu ángel nu guthèl·la' Tata Dios nna chi gunènie bi para tatàỹi bi cuią'lu' litsi' bi nna iyénini bi ttu titsa' rú'a cuią'lu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Làniana bega'a Pedrua cą le' yú'u nna bete bi posada qui' quį. Atu yu'utsá nna guda' tè bi día bi lani cą, huía huá tuchùppa ca creyente le' yetsi Jópea lani cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Attu yu'utsá nna gùta'a cabi le' yetsi Cesaree. Cornéliua nna ribèda bą́ cabi nna chi betùppą iyaba ca pariente quì'į ą'hua ca amigo canu adiru cca tsì'ą nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Bitsina' Pedrua litsi' Cornéliua nna biria chìą para gunią Pedrua recibir nna bedu taá ỹíbį ru'a lo bi para gunią bi adorar. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero Pedrua nna bèthuli bi Cornéliua nna ra tè bi ą: Bèduli, bittu guni lu' inte' adorar porqui'ni luetsi enne' bá lu' inte'. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Àtsaba rue' Pedrua titsa' lani ą nna gutà'a bi le' yú'u qui' Cornéliua nna bilá' tènì bi qui'ni enne' ỹetse' chi tsè'e nía, iyaba ca enne' canu naỹìnì Cornéliua. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Làniana ra Pedrua cą: Lebi'i nna hua yù bá le qui'ni según religión qui' intu' raza Judea nna yala prohibido ná etùppa tu' lani ca enne' qui' adí ca nación, nìhua para gá'a tu' le' litsi' enne' qui' attu raza huaya'. Pero Tata Dios nna chi beluè'nie inte' qui'ni labí dà te' épa'a' attu enne' huaya' qui'ni náą cùttsi o qui'ni labí dacca' iỹu' ru'a lúe. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Accc de gutàỹi le inte' nna dáyá taá' nna labí gudúdítsia'. Annana rinàba tìtsa'a' le: Bíỹalóni'a qui'ni acca gutàỹi le inte'. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Becàbi Cornéliua nna rą: Chi uccua tappa ubitsa méruá hórį nna labí chi gùtua' nna runia' oración tì'a runi bá' le' lìtsa'à' ttu ttu tsá bá de diál·la lá, de repente taá nna gùdu ttu ènne'yu' ru'a lua' yala catìttini ỹo bi, ");
INSERT INTO zaaNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ra tè bi inte': Cornelio, Tata Dios nna chi biyéninie oración qui' lu', ą'hua rilá'nie iyaba cualani nu runi lu' ca enne' pobre. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Acca rinénia' lu' qui'ni ithèl·la' lu' razón para ìta ttu enne' dua le' yetsi Jope lá bí Simón Pedro, dua bi litsi' attu enne' lá huą́ Simón rucùtsią yeti para zapato nna duą exa bá ru'a indatò'. Canchu chi íl·lani Simón Pedrua nna huénni bi lu' titsa'. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Por nui nna luegu taá guthél·la'a' razón para ìta cuią'lu'. Quiỹa rúgání cuią'lu' qui'ni gùl·lani lu' nì. Annana Tata Dios nna yùe qui'ni nì bá tsè'e tu' para gudà naga' tu' iyate nu chi rèe qui'ni quixá'ani cuią'lu' intu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Làniana gùdulo Pedrua gunne bi nna ra bi: Annana ritelí te' qui'ni Tata Dios nna alàa tsua' teruba ca enne' Judea catsi'ínie, ");
INSERT INTO zaaNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","sino qui'ni hua riyeni bánie qui' nuỹa tediba enne' ní, todo es qui'ni calatsi' quį ccá cą enne' adí obediente lani e nna runi cą nu ná tsè' lani la' rátsilatsi'. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Pero lani intu' ca enne' Israel nna chi gunne Tata Dios ca titsa' tsè' cubi para eyacca ri'u ttùba lani e por medio de Jesucristo enne' ná xana' iyaba ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Lebi'i' nna hua yù bá le nu uccua dèsdeba Galilee hàstaba itúbani región Judea bitola de beni Juan predicar nu cca qui' bautismo. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tata Dios nna beni lè'yèe Jesús enne' Nazaret nna betie la'huacca qui' Espíritu Santo lani e; yala enne' tsè' uccue lani ca enne' porqui'ni beyúnie iyaba canu uccua padecer por numalua, anía benie porqui'ni tulidàba gùdu Tata Dios lani e. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Intu' nna ná tu' testigo porqui'ni bila'ni tu' iyaba ca cosa nu beni Jesús le' región Judee nna Jerusalén nna. Bitola nna betaá' cą ne lo yà curútsia de chi gùdà cą clavo nì'a né'e, anía modo betti cą ne. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero tsùnna ubitsa bitola nna beyáthee de lo bà làti becàttsi' cą ne nna beyacca bànie por la'huacca qui' Tata Dios. Làniana gurènie lani intu' attu. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Alaáruhuá iyaba ca enne' bila'ni cą ne de chi beyáthee de lo lù'uti, sino ca enne' becué' Tata Dios dèsdeba neru para ccá cą testigo de nu cca quì'e, ą'hua intu' nna gù'ya gutò tu' lani e bitola de chi beyáthee de lo lù'uti. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Làniana guthèl·la' huée intu' para quixá'ani tu' ca enne' nna cueqquia lí tu' qui'ni Tata Dios nna chi bedue Jesús para quée Juez qui' iyaba canu bàni ą'hua qui' iyaba canu yatti nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Qui' Enni'į nuá gutixà'a iyaba ca profeta qui'ni iyaba canu tsíalatsi' quį ne nna huatta' la' runìttilo qui' ca tul·la' qui' quį por medio de lèe. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Àtsaba rinne Pedrua ca tìtsa'a nna huàdi Espíritu Santo iqquia iyaba canu rudà naga' predicación qui' bía. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ca creyente Judee ca enne' beni cabi Pedrua acompañar nna, uccuaỹí bá latsi' cabi bila'ni cabi qui'ni hàstaá ca enne' labí ná judío nna chi huadi Espíritu Santo lani cą; ");
INSERT INTO zaaNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","bennia cabi cuenta qui'ni chi guỹi' cą la'huacca quì'e de biyénini cabi gunne cą adí ca titsa' huaya' nna rudàliani cą Tata Dios nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Làniana ra tè Pedrua ca enne' judío canu tsè'e lani bía: Tsí bihua ná qui'ni ccá huá cą bautizar cá. Pues chì huá beni cą Espíritu Santo recibir tì' tehuá ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Làniana beni Pedrua mandado qui'ni ccá cą bautizar lani nombre qui' Señor Jesús. Bitola nna gutta'yúni cą bi qui'ni cueda bi nía tuchùppa ubitsa. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bina ca apóstol lani adí ca hermanos canu tsè'e le' región Judea qui'ni ą'hua canu labí ná raza Judee nna chì huá ríalatsi' quį titsa' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Le' ciudad Jerusalén tsè'e huá tuchùppa ca enne' judío chi ná huá cą creyente, pero ruthítsi cą qui'ni iyaba ca enne' ríalatsi' qui' adí ca nación nna ccá huá cą circuncidar nna guni huá cą adí ca ceremonio nu ra lo ley qui' ca judíua. Acca de beyéqquia Pedrua le' Jerusalén nna, là canuá nna yala gutìtsa' cą bi nna, ");
INSERT INTO zaaNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ra cą bi: Biecca huía lu' litsi' canu labí ná judío nna gutò lu' lani cą nì'i. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Làniana gùdulo Pedrua gutixa'áni bi cą nu uccua dèsdeba neru nna ra bi: ");
INSERT INTO zaaNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Loti' rí'a' le' yetsi Jópea nna guỹàcca'a' tì'a ttu nu rínneni yèlà nna bilá' te' ttu cosa tì'a ttu lári' xeni tsè' ỹiga' tappa esquina quì'į huàdią de ỹiabara' nna gùl·lanią hàstaá làti dù ya'a. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Gùnna' tìà' para ilá' te' biỹa yù'u le' bedùtiá nna bilá' te' ca animal canu tsìa tappa nì'a ná' quį ą'hua ca animal tuxu nna canu riyé'ya bání lè'e quį nna ą'hua canu ridàa lo be' nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Làniana biyeni te' tsì'i ttu enne' nna rèe inte': Pedro, guỹi' nna bèttì nna gutò. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Becàbi tìà' nna nia': Labí Señor, porqui'ni nìdi tsa ní'i gua' iyání nu ro ca enne' qui' adí ca nación, nìhua biỹa cosa nu bilátsi' lani ca cosa cùttsi nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Làniana biyeni te' tsì'iá attu nu cca chùppa vuelta nna rèe inte'. Nu chi beni nàrì Tata Dios nna bittu ína lu' qui'ni ną́ cùttsi. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Por tsùnna vuelta uccua anía. Làniana iyaba bedi' Tata Dios para ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Lània taá nna gùl·lani tsùnna ca nubeyu' le' yú'u làti dua ya'a beyìla cą inte'; dá' cą dèsdeba Cesarea. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Espíritu Santo nna rèe inte': Bittu tehuá ccani lu' qui'ni làa tsía lu' lani cą. Làniana xùppa ca hermanos qui' rí'uį nna guda' huá cabi lani inte'; iyaba tu' nna gutà'a tu' le' yú'u qui' Cornéliua. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nubéyu'a nna gutixà'anią intu' ti'iỹa uccua loti' bila'nią gudu ttu ángel le' yú'u qui' niá nna ra tè bi ą: Guthèl·la' ca mozo qui' lu'ą' le' yetsi lą́ Jope para taxi' cą Simón enne' lá huá bí Pedro. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Làbi nna quixá'ani bi lu' ti'iỹa modo gata' salvación qui' lu' ą'hua ituba familia qui' lu' nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Gùdulo tìà' gunéni ya' cą nna huàdi tè Espíritu Santo iqquia quį tì'hua uccua loti' gùl·lanie lani ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Làniana bexa látsa'a' ca titsa' qui' Señor loti' rèe: Hualiba beni Juáan bautizar ca enne' lani inda, pero lebi'i nna ccá lé bautizar lani Espíritu Santo. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tata Dios nna nanie qui'ni ca enne' qui' adí ca nación thí' huá cą la'a mísmuba bendición tì'a nu chi guỹi' ri'u loti' huíalatsi' ri'u Señor Jesucristua nna, entonces núní ná inte' para guthága'a' nu calatsi' Tata Dios gunie cá. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Biyeni báni ca hermanos tsè'e Jerusalén testimonio qui' Pedrua nna, labiru biỹa ra cabi sino bedàliani cabi Tata Dios nna ra cabi: Claru taá ritelíni tu' qui'ni Tata Dios nna chì huá betie oportunidad qui' ca enne' labí ná judío para eyacca huá cą arrepentir nna gata' hua la'labani nu labí ttią qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Gutè diba loti' betti cą Esteban nna gùdulo huá cą betsia latsi' quį adí ca creyente, acca gùthilàlia ba cabi becuìtta cabi hàstaba ca región qui' Fenicia l·le Chipre l·le ą'hua hàstaá ciudad Antioquía nación láą Siria l·le gùtixa'a cabi ca titsa' tsè' cubi qui' Tata Dios. Gùtixa'ani cabi làteruba ca enne' raza Judea, pero adí ca enne' nna labí. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Tuchùppa canu ríalatsi'á nna uccua cabi enne' Chipre nna Cirene nna, pues loti' bitsina' cabi le' ciudad láą Antioquía nna gùtixa'a huáni cabi ca enne' griego ti'iỹa tsè' ná evangelio qui' Señor Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","La'huacca qui' Señor nna gùdue lani cabi, acca nuỹetse' cą nna bethà'na cą ca creencia mal qui' quį nna huíalatsi' quį Señor Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Bina bá iglesia re' le' Jerusalén notícį nna guthèl·la' cabi Bernabé para Antioquía. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bernabéa nna de bitsina' bi nía nna uccua tè bi saber qui'ni yala favor chi beni Tata Dios lani ca enne' nía nna yala bedácca'ni latsi' bi. Bete bi consejo qui' iyaba quį para cueqquia tsìttsì latsi' quį nna ccá cą fiel lani Señor. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabéa nna yala ènne'yu' tsè' uccua bi: yala la'huacca qui' Espíritu Santo gùdu lani bi, ą'hua tulidàba guta' iỹeni fe qui' bi lani Tata Dios. Nuỹetse' ca enne' tsè'e Antioquía nna beni cą aceptar Señor Jesús. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Bitola nna huía Bernabéa yetsi láą Tarso hueyìla Saúlua. De bitsà' bi Saúlua nna guche' bi bi para Antioquía. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Bernabéa nna Saúlua nna gutsé'e cabi le' ciudad Antioquía durante ttu ida; nía nna huía cabi reunión tulidàba nna bete cabi enseñanza tsè' lani iỹetse' ca ènni'a. La'a mísmuba nía nna por primera vez gutìxa cą láa ca enne' rialatsi' qui' Señor: Cristianos. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tiempo lània nna gutsé'e tuchùppa creyente uccua cabi profeta nna gùtixa'a huá cabi acerca de nu chì' da' la; làcabí nna biria cabi Jerusalén nna huía cabi Antioquía. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","De chi tsè'e cabi lahui' ca hermanos nna gudúlí tè ttu bi lá bí Ágabo; Espíritu Santo nna betie la' riyeni tsè' qui' bi nna gutixa'a bi qui'ni ccá ttu ubìna' fuerte ní le' ituba yétsiloyu. (Nu ra bía nna bì'yu tsá uccuą tiempo rigú'ubia' enne' romano láą Claudio.) ");
INSERT INTO zaaNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Làniana ca creyente tsè'e Antioquía nna gulèqquia léttíá qui' cabi para guni cabi cuàlani adí ca hermanos tsè'e le' región Judea. Ttu ttu tsa cabi nna bete cabi según ti'iỹa tébá lo néda qui' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Làniana guthèl·la' tè cabi Bernabéa nna Saúlua nna para tahua' cabi ofrenda lani ca anciano tsè'e Judea. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tiempo lània nna gùdulo Rey Herodes betsia latsi'į tuchùppa ca creyéntea. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Benią mandado gutti cą Jacobo bettsi' apóstol Juan lani espada. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Gutelí báni Herodes qui'ni yala bedácca' ni ca judíua qui'ni bettią Jacobua nna, acca beni tehuą́ duel·la' para gudàxu'ą Pedrua preso. Anía benią méruá loti' gùl·la' fiesta religiosa qui' ca judíua nna ro cą ettaxtíla nu labí chixi levadura. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herodes nna beni tìą orden gudàxu' cą Pedrua nna gudàl·la cą bi litsi' ìyyà. Bedà tìą guardia tappa lettia lani tappa soldado le' ttu ttu lettia para qui'ni guni cą bi seguro, para qui'ni gúduą bi ru'a lo ca enne' yétsiá tté díbá fiesta qui' caniá nu lá Pascua. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Acca chi té Pedrua litsi' ìyyà nna, al tántuní tsè'e ca soldádua gùppa bi. Pero ca enne' ríalatsi'á nna betùppa cabi nna tulidàni beni cabi oración por Pedrua. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Là'a mísmuba yèlà para tsani' dila nu nani Herodes qui'ni cueqquią Pedrua le' litsi' ìyyà nna guduą bi ru'a lo ca enne' yétsiá. Pedrua nna té ba bi ti'áthi bi, ỹiqquia ttu ttu lado ná' bi cadena lahui' chuppa soldado. Miéntraste adí ca soldádua nna dàa ba cą ru'a puerta gùppa. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","De repente taá nna gùdu ttu ángel qui' Señor nía nna huànì' rabani ituba le' litsi' ìyyàa. Ángelia nna belappa' tìe cuitta' Pedrua nna bedibànie bi nna rèe bi: Huàth xìa. Làniana beyàtsi chì ca cadena nu ỹíqquia ní ca ná' bía. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Gunne ángelia attu nna rèe bi: Guthi tsè' lè'e lu' nna begú'u nì'a lu' ca guarachu qui' lu'ą'. Anía bá beni Pedrua. Làniana ra tè ángelia bi: Beyàccu' mata qui' lu'ą' nna tanó tè inte'. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Beria tè ángelia nna denó tè Pedrua bi, pero labí uccuáni bi qui'ni ná lí nuá, sino belaba latsi' bi qui'ni yèlà ba nuá rínneni bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bettè tè cabi làti tsè'e cą guardia, làniana betè cabi làti tsè'e adí ca guardia nna bitsina' cabi ru'a puerta nu de ìyyà, pero ttùbą biyàlia nna beria tè cabi. Gutèl·la' cabi néda nu deyyą para le' ciudáad nna gutè diba cabi ttu calle nna beníttilo tè ángelia ru'a lo Pedrua. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Làniana betenèl·le'nì Pedrua nna ra tè bi lo losto' bi: Anna la nna ritelírani te' qui'ni Señor nna chi guthèl·le'e ángel quì'e nna bedilèe inte' làtsi' ná' Herodes ą'hua de iyaba nu uccua latsi' ca judíuą' guthacca' cą inte'. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Deyya tè bi rulaba latsi' bi acerca de nu uccua nna, betsina' bi litsi' María nàna qui' Juan enne' lá huá Marcos. Nía nna tsè'e iỹé cabi juntu ba huèni oración. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Bél·labi tè Pedrua ru'a puerta qui' zaguán nna, biria ttu niula cuìti' lą́ Rode para tayuą nuỹa nuá du ru'a puerta. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Bedacca' bánią tsì'i Pedrua nna, pero de tantua la' redacca' latsi' nna labí guthàlią sino bigàa lą́ le' yú'u nna gutixa'ą qui'ni Pedrua nuá rinne ru'a puerta. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Làcabi nna ra cabi ą: Locu cà'a cca lu'. Pero Ródea nna beni bą́ seguir nna rą qui'ni hualigani Pedrua nuá. Acca ra tè cabi: Alàtehuá Pedrua gá sino ángel qui' ỹiabara' enne' rui'e bi cuidado cca nua'. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedrua nna ribèda bi fuera rúl·labi bi ru'a puerta. De guthàlia cabi nna bila'ni cabi Pedrua nna uccuaỹí yà'ani latsi' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Làniana benìni Pedrua cabi seña lani ná' bi qui'ni bittu guni cabi ruido. Gutixa'a tènì bi cabi ti'iỹa uccua loti' bebèqquia Señor bi le' litsi' ìyyà. Ra ruhuá bi cabi: Lequixá'a tsàte'ni Jacóbua notícį ą'hua adí ca hermanos nna. Làniana guda' tè bi attu làti huaya'. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Cuantu taá huànì'a nna uccua ttu escándalo ỹéniní entre ca soldádua nna ra luetsi quį: Tì'adì'lo uccua lani Pedrua. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes nna benią mandado qui'ni eyìla cą Pedrua, pero lanú bi betseláni cą. Bitola de benią canu gùtse'e guardia iỹetse' ca pregunta nna, beni tìą mandado gatti canu gùtse'e guardia. Gutè ba nuá nna beria Herodes le' región Judea nna huíą yetsi Cesarea, nía bá gùduą. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes nna yàlani bitsa'ánią lani ca yetsi Tiro nna Sidón nna. Acca entre chuppa ca yétsiá nna gunne lettia cą para tsía cą ru'a lo Herodes. Nía nna bettsà' ru'a quį lani Blasto nu uccua empleado exa tsìttsìni qui' rey Herodes. Ania modo nna gunàba cą qui'ni éttsé'e tsè'ba cą, porqui'ni nu ro cą nna dá'ą le' región nu bána'ni rey Herodes. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes nna beduą ttu tsá para etùppa cą ru'a lúį. Lą nna gùccu' tìą ca lari' nu adiru catìttìni quì'į nna guri'ą lo plataforma nna yala rudàlianią la'a labą́ nna gùnnią ttu discurso para canu yetsi Tiro nna Sidón nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ca enne' qui' ca yétsiá nna de riyénini cą ca titsa' èl·la nu rą, acca idìttsani gunne chì iyaba cą nna ra cą: Alàa tsì'i nùttì'ni enne' dí nua', sino tsì'i ttu dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Làniana taá nna ttu ángel qui' Señor benie na castigar lani ttu itsahue' fuerte ni nna gùttì xìgüì' bą́ porqui'ni bihua cuenta gulèqquią Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Làniana adila gùthilàlia bá titsa' qui' Señor nna enne' ỹétse'ní huíalatsi' quį por primera vez. ");
INSERT INTO zaaNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabéa nna Saúlua nna de chi beni cabi cumplir mandado nu dia cabía nna beria cabi Jerusalén nna deche' tè cabi Juan enne' lá huá Marcos. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Le' iglesia re' le' yetsi Antioquía nna gùtse'e tuchùppa ca enne' bete Tata Dios la' riyeni tsè' qui' cabi para guni cabi predicar nna quixá'a cabi ca cosa nu chì' ccálá, ą'hua bethàtsilà'na cabi claru taá enseñanza tì' tabá ra titsa' qui' Tata Dios; anía beni Bernabéa nna Simón enne' lá Negro nna, ą'hua Lucio enne' Cirene, ą'hua Manaén enne' biỹèni tulappa ba lani Herodes nu uccua gobernador qui' región Galilea, ą'hua Sáulua nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ttu tsá nna tsè'e cabi hueni servir Señor ą'hua runi cabi ayunar nna, ra tè Espíritu Santo cabi: Licuèqquia yà'latsi' Bernabéą' ą'hua Sáuluą' para guni cą tsina nu chi ná te' para làcą, porqui'ni por nui lá chi gutáỹi ya' cą. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Làniana de chi beni cabi adí oración nna ayuno nna, betsia tè ná' cabi iqquia Bernabéa nna Sáulua nna guthèl·la' tè cabi chuppa taá cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Anía modo nna uccua cabi saber qui'ni Espíritu Santo ènni'a guthèl·le'e cabi tsía cabi. Huía tè cabi Seleucia; de nía nna gutèl·la' cabí ttu barco nna huía cabi hàstaá ttu isla lą́ Chipre. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bitsina' tè cabi le' Salamina ttu yetsi qui' isla de Chipre nna beni cabi predicar titsa' qui' Tata Dios le' ca sinagoga làti retùppa ca judíua. Huía huá Juan Marcos lani cabi para guni bi cabi cuàlani le' tsina qui' Señor. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Làniana gutè cabi ituba isla lani nì'a bá cabi nna bitsina' cabi yetsi Pafos. Nía nna taxácca' cabi ttu nubeyu' huatsàa' uccuą profeta falso lą́ Barjesús enne' Judea. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Lą nna uccuą amigo tsè' lani gobernador Sergio nu lá huá Paulo, yala tsè' uccuanią ìttsì. Gobernador nna gutàỹią Bernabéa nna Sáulua nna yala uccua latsi'į quixá'ani cabi ą titsa' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero ttu enne' láą Elimas nna becàbi dí'nią cabí. Elimas naa uccuą huatsà'a (porqui'ni anía rethàtsilà'na ri'u líį), lą nna benią duel·la' gudùl·la'ą́ latsi' gobernador para làa tsíalatsi'į evangelio. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Acca Saulo enne' lá huá Pablua nna gunna' bi nubeyu' huatsà'a nna gunne tè bi lani itute la'huacca qui' Espíritu Santo nna, ");
INSERT INTO zaaNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ra bi ą: Lu' ỹi'ni numalua, tsá'ti'ni lu' la' beỹia ą'hua hueni iyaba maldad nna, ná huá lu' enemigo qui' iyaba nu ná tsè'. Tsí bihua gudùtsi lu' bíttuúru inne lu' ca cosa nu labí ná lí para qui'ni làa guthàga'áru lu' ca enne' ná qui'ni tsíalatsi' quį Señor ni'i. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Acca annana la'a Señor ba gunie lu' castigar nna ccá lu' ciego nna labiru ila'ni lu' bitsą' por ttu tiempo. Lània taá nna bibàga' chì la' chul·la ca íyyalúį nna labiru uccua ila'nią, gùdulo tìą beyìlą ìta'lùbį nuỹa quél·la'ą ní'į échi'ą na. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Bilá' báni gobernador nu uccua nna yala biquila' latsi'į nna huíalatsi'į de biyéninią ca enseñanza gutixà'a Pablo nna Bernabéa nna nu cca qui' Señor. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Làniana bedà' tè Pablua lani ca compañeros qui' bía le' yetsi Pafos, gutèl·la' cabi ttu barco para tsía cabi yetsi Perge región láą Panfilia. Nía nna béttse'e ba latsi' Juan Marcos cabi nna beyéqquia bi Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Làcabi nna gutè ba cabi Perge nna bitsina' cabi le' ciudad Antioquía región lą́ Pisidia. Guta'a tè cabi le' sinagoga ttu tsá sábado nna guỹua tení cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Beyacca diba bìl·la cą nu ra lo ley nu bete Tata Dios lani Moisés ą'hua ca escritura nu bedia ca profeta quì'e nna, làniana canu rigú'ubia' le' sinagoga nna ra tè cą cabi: Lebi'i hermanos israelitas, canchu hua té tuchùppa titsa' qui' le para egú'u le yetsi néda nna, linne ba. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Gùduli tè Páblua nna beni bi seña lani ná' bi para thulo bi inne bi nna ra bi: Lebi'i ca enne' israelitas ą'hua iyaba le canu rappa respeto Tata Dios, líúdatsáruhuá naga' le: ");
INSERT INTO zaaNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tata Dios qui' yetsi Israel nna becuí'e ca tà' tàta qui' rí'ua nna benie cabi ttu nación xeni màsqui'ba uccua cabi enne' dittu' le' nación Egíptua, pero lani la'huacca quì'e nna bebèqquie cabi nía. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Por ttu tiempo de chùà' ida nna bechia bée iyaba ca cosa mal nu beni cabi loti' tsè'e cabi le' desiértua. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Bel·lùỹe latsi' gàtsi ca nación canu anta' le' región Canaán para quíthie loyu qui' caniá nna betie lóyúa qui' ca tà' tàta qui' rí'ua. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Bitola nna bedue tuchùppa cabi para ccá cabi juez para làcabi nna, gulú'ubia'ni cabi yétsiá; aníabá benie durante ttú tappa gayua' tsieyóna' ida hàstaá loti' gùdua Samuel enne' uccua profeta. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Làniana gunàba yétsiá ttu rey para cu'úbia'nią cabi. Tata Dios nna bedue Saul ỹi'ni ttu enne' lą́ Cis descendiente qui' familia qui' Benjamín, para ccą́ rey por chùà' ida. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pero Tata Dios nna bebèqquia tabée rey Sáulua le' la' rigú'ubia' quì'į, làniana bedue David para ccá bi rey cubi qui' cabi. Lo Escritura nna gunne Tata Dios qui' David nna rèe: Yala ru'ulátsa'a' David ỹi'ni Isaí, hua yúá' qui'ni lą nna gunią iyaba nu calátsa'a'. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jesucristua nna née descendiente qui' la'a mísmuba David. Tata Dios nna guthèl·le'e bi para quée enne' gudilà yetsi Israel tì'a chi benie prometer dèsdeba antes. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ántesca thulo Jesús tsina nu dé'e gunie nna, gutixa'áni Juáan ituba yetsi qui'ni dàni cą eyacca cą arrepentir por ca tul·la' qui' quį nna ccá cą bautizar. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Chì' taáduą l·luỹa tsina qui' Juáan nu da' bi runi bía nna, ra bi: Alahua inte' nuą' enne' rulaba latsi' le ná', pero bitola de inte' nna íl·lanie nna nìdi làa dàcca'a' para gudá'a' inda quì'e para quíi né'e, porqui'ni née enne' tsùna'. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Lebi'i hermanos canu dá'tia' le' familia qui' Abraham, ą'hua iyaba le canu calatsi' gudàliani le Tata Dios, pues para iyaba lebi'i nna guthèl·la' Tata Dios titsa' nu riquixá'a ti'iỹa modo gata' salvación qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Porqui'ni canu gùtse'e le' Jerusalén lani canu rigú'ubia' qui' quį nna labí gutéelíni cą nuỹa ènni'a Jesús, nìhua labí gutéelíni cą ca titsa' nu bedia ca profeta, màsqui'ba ttu ttu sábado ba rul·la cą nu ra lo Escritura. Pero de beni cą ne sentenciar para gattie nna, anía modo beni telá cą cumplir nu gutixa'a ca enne' uccua profeta. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Màsqui'ba labí betseláni cą culpa nu dacca' gattinie, pero gunàbani cą Pilátua qui'ni gunią mandado gattie. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","De chi uccua cumplir iyate nu ga'na escrito nu cca quì'e hasta qui'ni gùttìe, làniana bechìda cą ne lo yà curútsia. Bitola nna gutìxa cą ne le' yerubà. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero Tata Dios bechìthe bi de lo lù'uti nna beyacca bànie. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ca enne' huía lani e de Galilea para Jerusalén nna, iỹé ubitsa tse'éru bila'ni cabi e bitola de chi beyáthe de lo lù'uti. Làcabí nna ribèqquia lí cabi ru'a lo iyaba ca enne' qui'ni anía uccua. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Acca intu' nna riquixá'a huáni tu' le ca titsa' tsè' acerca de Cristo enne' beni Tata Dios prometer lani ca tà' tàta qui' rí'ua qui'ni ithèl·le'e bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Annana chi benie na cumplir lani ri'u qui'ni ná ri'u ỹi'ni ca tà' tàta qui' rí'ua. Ga'na ri'u seguro qui'ni la'a Jesús bá née Cristua, porqui'ni bechìtha Tata Dios bi de lo lù'uti, tì'a rèe lo libro Salmo ccá chùppa: Lu' ná lu' ỹì'nia'. Annana rithél·la'a' lu' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Tata Dios nna chì bá benie prometer dèsdeba antes qui'ni echìthe Jesús de lo lù'uti, para qui'ni bittu gutsu' cuerpo quì'e, loti' rèe: Lebi'i ba thí' ca bendición nu benia' prometer lani David. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Acca ra huá lo attu Salmo: Labí hue'él·la' cuią'lu' gutsu' cuerpo qui' Ỹi'ni cuíą'lu'a. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Porqui'ni David nna hua liba beni bi nu rú'ulatsi' Tata Dios loti' gùdua bi yétsiloyu. Gùttì ba bi nna bigàttsì' bi làti bigattsi' ca tà' tàta qui' bía nna gutsu' bá cuerpo qui' bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero Jesús enne' bechìtha Tata Dios de lo lù'utia nna labí gutsu' cuerpo quì'e. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Acca ccá le saber hermanos, nì riquixá'ani tu' le qui'ni por medio de Jesús nna runi Tata Dios ofrecer eyuniỹen latsi'e ca tul·la' qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Por la'a mísmuba Jesús nna iria nàrì ru'a lo Tata Dios iyaba ca enne' tsíalatsi' quį ne, porqui'ni labí uccuáni le iria nàrì le por nu ra lo ley qui' Moisés. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Acca líúhue' cuidado qui'ni làa tátsią iqquia le nu ra Tata Dios làti ga'na escrito por ca profeta: ");
INSERT INTO zaaNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Lebi'i canu ruỹitsíni le inte', caỹí bá latsi' le nna l·lúỹa latsi' le, Porqui'ni inte' Dios nna runia' ca cosa ỹéniní entre lebi'i, Pero labí ríalatsi' le màsqui'ba nuỹa ttu enne' tsè'ni riquixá'anią le. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","De beyacca bete Pablua mensaje nna beria bi le' sinagoga qui' ca judíua, laniana canu bihua ná raza judío nna gutta'yúni cą cabi qui'ni equixá'ani cabi cą sobre de ca tìtsa'a de eyéqquia cabi attu semana. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bechu titsa' diba cabi ca ènni'a nna nuỹetse' ca enne' judío ą'hua adí ca enne' yala fiel ná cą lani religión qui' ca enne' judío nna tanó cą Pablua nna Bernabéa nna. Làcabi nna gunèni cabi cą qui'ni guni cą seguir tsè' nna tsìttsì nna lani salvación nu chi bete Tata Dios lani cą por la' tsì'ilatsi' qui'e. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Bì'yu tsá redi' latsi' caniá nna betùppa adí iỹe ca enne' tsè'e le' yétsiá para gudà naga' quį titsa' qui' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero ca judíua nna bilá' báni cą qui'ni yala telá enne' ỹé betùppa, acca gùppa cą la' yélatsi' nna biria cą contra nu riquixá'a Pablua nna ra cą qui'ni labí ná lí nu ra bía acca beduadí' cą bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Làniana Pablua nna Bernabéa nna gunne cabi lani adí valor nna ra cabi: Uccua duel·la' qui'ni primérute lebi'i ca enne' judío equixá'ani tu' le titsa' qui' Tata Dios. Pero lebi'i nna rutsibi lá le ca tìtsi'į, acca la'a lebi'i ba runi qui'ni làa ccá le merecer para gata' la'labàni nu labí ttíą qui' le. Annana éya' bá tu' le' adí ca nación làti tsè'e canu labí ná raza judío. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Porqui'ni ą' ba chi beni Señor intu' mandado de rèe lo Escritura: Chi bedúa' lu' para ccá lu' la'yani' qui' adí ca enne' huaya', Para qui'ni por lu' nna ccá cą salvo, Ą'hua canu tsè'e hàstaá último qui' yétsiloyu. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","De biyénini ca enne' labí ná raza judío ca tìtsa'a nna yala bedacca' latsi' quį nna ra cą: Hualigani yala tsè' ná titsa' qui' Señor. Huía tè latsi' iyaba ca enne' ná destinado para gata' la'labàni cubi nu labí ttíą qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Uccua ba predicar titsa' qui' Señor le' ituba región nía. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero ca judíua nna gulù'u titsa' cą ca niula canu yala fiel ná cą lani religión qui' ca judíua nna, yala respeto rappa ca enne' ca niuláa porqui'ni beni cą tsè'. Ca judíua nna gulù'u yí' huá cą latsi' ca nubeyu' re' cuenta le' yétsiá qui'ni guyudí' iyaba cą Pablua nna Bernabéa nna, acca gùdulo cą betsia latsi' quį cabi hasta qui'ni bebèqquia cą cabi le' región qui' caniá. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Làcabi nna becuíbi huá bestè nì'a cabi, seña de qui'ni labí tsè' beni cą. Làniana deyya cabi para yetsi Iconio. ");
INSERT INTO zaaNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Iyaba ca enne' ríalatsi'á nna adila bedacca' latsi' cabi, ą'hua yala la'huacca qui' Espíritu Santo gùdu lani cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","De bitsina' Pablua lani Bernabéa le' yetsi Iconio nna gutà'a cabi le' sinagoga làti retuppa ca enne' judío; nía nna yala lani la'huacca beni cabi predicar hasta qui'ni nuỹétse'ní ca enne' huíalatsi' quį, tàntua ca judío ą'hua ca griego. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero ca judío canu labí huíalatsi'á nna gulù'u yí' lá cą latsi' ca enne' griégua nna beni cą qui'ni gulaba latsi' quį mal contra ca creyénteá. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pero Pablo nna Bernabéa nna iỹé ubitsa gùtse'e cabi nía nna gùppa cabi confianza lani Señor, acca gunne cabi lani adí valor. Señor nna benie asegurar qui'ni titsa' quì'e nu riquixá'a cabi nna ną́ favor qui' Tata Dios para ca enne', acca betie poder qui' cabi para guni cabi ca milagro ą'hua adí ca cosa nu rulue' qui'ni la'huacca qui' cabía nna dá'ą de ỹiabara'. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pero ca enne' qui' yétsi'á nna uccua cą chuppa là'a; ttu te cą gùtse'e cą lado qui' ca judíua, attu te cą nna gùtse'e cą lado qui' ca apóstol. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Làniana gunne lettia ca judíua lani adí ca ènni'a tsá'tséla tehuá canu rigú'ubia' qui' quį para guduadí' cą cabi nna hué' cą cabí íyya hàsta'na gutti cą cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pero bina bá cabi nui nna beria cabi nía nna huía cabi para ca yetsi Listra nna Derbe nna canu anta' cą le' región lą́ Licaónia, ą'hua iyaba ca yetsi canu anta' ìta'lùba nía. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Nía nna beni cabi predicar evangelio. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Le' yetsi Listra gùdua ttu nubeyu' labí uccua thá'ą, pues tulidàba gurè'nią porqui'ni ną́ cojo dèsdeba gùlią. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nubéyu'a nna ri'ą rudà nàgui'į titsa' qui' Pablua. Pablua nna gunna' bi lo nubéyu'a nna gutelíni bi qui'ni hua té fe quì'į para ccą́ salvo. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Acca Pablua nna ra bi iditsa tsè': Gudulí nna bedu ca nì'a lu'ą' tulí taá. Nubéyu'a nna gudulí chìą bittsíaníą nna gudulúą gùda'ą. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Bila' báni ca enne' ỹétsi'á nu beni Pablua nna, iditsa tsè' guduló cą gunne cą titsa' Licaónia nna ra cą: Chi huàdi ca dios làti tsè'e rí'uį, ná que tì'a ná ca enne'. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabéa nna gutìxa cą lá bi dios Júpiter. Pablua nna gutìxa cą lá bi dios Mercurio porqui'ni Pablua nna gunne bi adiru. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Imagen qui' Jupiter nna dúą le' yòtò' qui' quį nu dua ru'a yétsiá. Sacerdote qui' yòtù'a nna taxi'ą ca gù'na nàl·la' corona ìyyà yáni quį. Sacerdótea lani ca enne' yétsiá nna uccua latsi' quį guni cą Pablua nna Bernabéa nna adorar, acca beni cą preparar para gutti cą ca gù'na nna para gutsia cą sacrificio ru'a lo cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ca apóstol Bernabéa nna Pablua nna de gutelíni cabi qui'ni uccua latsi' quį guni cą cabi adorar nna, guchèda'ni ỹó cabi seña de qui'ni labí guyú'u latsi' cabi nna, gutà'a chì cabi lahui' ca enne' ỹétse'á gunne cabi iditsa nna ");
INSERT INTO zaaNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ra cabi cą: Biánícca runi le nui nì'i. Tsí làa yù huá le qui'ni luetsi enne' ba le intu'. Riquixá'ani tu' le qui'ni gútse'e latsi' le ca creencia qui' le nna guni le nu rú'ulatsi' Tata Dios bàni enne' beni ỹiaba ą'hua yétsiloyu nna indatò' nna iyábani nu té nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ca tiempo nu chi gutè nna be'èl·la' ba Tata Dios ca enne' guni cą según la' riyeni qui' quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tulidàba benie tsè' lani cą, para qui'ni ennia cą cuenta qui'ni dúe tulidàba. Ą'hua runie iyya nna ubá nna para ca lena' qui' ri'u, té tse'é'ní qui' ri'u runie para edacca' latsi' ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pablua nna Bernabéa nna màsqui'ba ra cabi anía nna, apena bání birialàni cabi qui'ni ca ènni'a nna bittu gutti cą ca gù'na nna gutsia cą sacrificio ru'a lo cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Làniana bitsina' tuchùppa ca judío dá' cą de Antioquía nna Iconio nna gulù'u titsa' taá cą ca enne' ỹétse'á qui'ni bittu gulàbì cą cabi nia. Acca bè' cą Pablua íyya para gutti cą bi nna gutè'ya cą bi fuera yétsiá lá, belaba latsi' quį qui'ni chi gùttì bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Bitùppa tè ca creyéntea ìta'lùba bi, làniana beyatha bi nna betsina' bi le' yétsiá attu. Attu yu'utsá nna beria bi nía lani Bernabéa, deyya cabi para yetsi lą́ Derbe. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Beni cabi predicar evangelio le' yetsi Dérbea ą'hua gutixa'áni cabi ca creyente cúbía ti'iỹa ná nu guni cą, làniana beyeqquia cabi para ca yetsi Listra nna Iconio nna Antioquía nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Le' tsùnna ca yétsiá nna gutixa'a cabi adí ca titsa' tsè' qui' Tata Dios, anía modo nna gùppa ca creyéntea adí ánimo para làa edúl·la'a latsi' quį, sino qui'ni guni cą seguir lani fe. Ra huá cabi cą qui'ni para gata' parte qui' ri'u le' la' rigú'ubia' tsè' qui' Tata Dios nna naduel·la' ccá ri'u sufrir iỹetse' ca prueba. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ą'hua le' ttu ttu ca iglesia nna beni cabi nombrar canu ccá responsable nna hué' cą cuidado la'labàni espiritual qui' ca hermanos. Acca beni cabi ayunar nna, beni cabi oración nna bethà'na cabi cą làtsi' ná' la'a mísmuba Señor enne' chi huíalatsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Làniana gutè cabi le' región láą Pisidia nna bitsina' cabi región láą Panfilia. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Beni díbá cabi predicar titsa' qui' Tata Dios le' yetsi Perge nna huía tè cabi Atalia. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nía nna gutèl·la' cabi ttu barco nna deyya cabi para país Siria hàstaá Antioquía ciudad làti beni ca creyente oración primérute por làcabi qui'ni Tata Dios nna gunie cabi cuàlani lani la' tsi'ilatsi' quì'e lo tsina quì'e nu chi beni cabía. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","De betsina' cabi nía nna betùppa cabi ca enne' runi formar iglesia nna gutixà'a cabi iyaba ca cosa nu beni Tata Dios lani cabi, ą'hua ti'iỹa modo chi guthàlie néda para qui'ni ca enne' qui' adí ca nación nna tsía huá latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Le' ciudad Antioquía gutsé'e cabi lani ca creyéntea iỹé ubitsa tsè'. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Làniana gul·lani le' Antioquía tuchùppa canu da' le' región lą́ Judea gunèni cą ca creyéntea nna ra cą: Canchu làa ccá le circuncidar tì'a costumbre nu gutixa Moisés nna, labí salvación té qui' le. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablua nna Bernabéa nna yala fuerte ni beni cabi discutir lani cą. Làniana beni iglesia nombrar tuchùppa ca hermanos para tsía cabi lani Pablua nna Bernabéa nna hasta Jerusalén, para guni cabi arreglar asúntuį lani ca apóstol ą'hua lani ca anciano tsè'e le' Jerusalén. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Bechu titsa' tè iglesia cabi lani oración. Làcabi nna gutè cabi le' ca región Fenicia ą'hua Samaria gutixa'áni cabi ca creyéntea qui'ni iỹetse' ca enne' qui' adí ca nación nna chi bethà'na cą ca creencia qui' quį nna ría huá latsi' quį evangelio qui' Jesucristua. De biyénini ca creyéntea notícį nna yala bedacca' latsi' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ca apóstol nna ca anciano lani adí ca hermanos tsè'e le' Jerusalén nna beni cabi Pablua nna Bernabéa nna recibir. Làniana gutixa'a Pablua nna Bernabéa nna iyate nu chi beni Tata Dios lani làcabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero tuchùppa canu látsi' cą religión qui' ca fariséua màsqui'ba chi ríalatsi' quį evangelio nna, gudulí tè cą nna ra cą; Ná qui'ni ca enne' ríalatsi' qui' adí ca nación nna ccá huá cą circuncidar ą'hua gá ri'u cą qui'ni guni cą adiru nu ra lo ley qui' Moisés. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Làniana betùppa ca apóstol lani ca anciánua para cueqquia lettia cabi asúntua. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Yala discutir beni cabi sobre de asúntua, làniana gudulí Pedrua nna ra bi: Lebi'i hermanos, hua yù bá le qui'ni dèsdeba cuaỹa nuá becué' Tata Dios inte' entre lebi'i para quixa'ánia' ca enne' qui' adí ca nación ca titsa' de salvación nu runna Jesucristua para qui'ni tsía huá latsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Tata Dios enne' nabia'nie la' rulábalatsi' qui' ttu ttu enne' nna benie nui comprobar lani cą loti' guthèl·le'e Espíritu Santo lani cą tì'tehuá benie lani ri'u. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Labí biỹa diferencia ní benie entre ri'u lani làcą, sino tulappa bá canie lani iyaba ca enne', pues beyuni nàrì huée lo losto' quį por fe nu té qui' quį lani e. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Anna chúná, biánícca ruditù le latsi' Tata Dios nna rutsia le adí yùà' iqquia ca creyente, ca cosa nu nìhua ca tà' tàta qui' rí'ua labí uccuáni cabi guni cabi ą nìhua ri'u nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Porqui'ni annana yù ri'u qui'ni por la' retúalatsi' qui' Señor Jesús nna labí tsía ri'u lo yi'bél·la; ą'hua nuą' chi ríalatsi' quį. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Làniana iyaba canu tsè'e nía nna gùtse'e tsi bá cą bedà naga' quį nu ra Bernabéa nna Pablua nna de requixá'a cabi ca cosa ỹénitse' nna ca milagro canu chi beni Tata Dios por medio de làcabi lani ca enne' labí ná raza judío. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","De beyacca gunne cabi nna làniana ra Jacóbua: Lebi'i hermanos, liudà naga' le nu quixa'ánia' le: ");
INSERT INTO zaaNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro nna chi gutixa'áni bi ri'u ti'iỹa modo bìta Tata Dios por primera vez lani ca enne' nu labí ná judío, rucuí'e entre làcą ttu yetsi para la'a labée, ");
INSERT INTO zaaNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ą'hua ca profeta nna gunne cabi de acuerdo ba lani nui tì'ba làti ga'na escrito nna ra Señor: ");
INSERT INTO zaaNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Bitola nna eyeqquia' nna eyunia' làti gùdua David porqui'ni chi bitàppa'ą, Inte' nna echitha ya' ą attu lo cimiento quì'į tì'atsi nu cubi taá, ");
INSERT INTO zaaNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Para qui'ni adí ca enne' huaya' nna gunibia' cą inte', iyaba canu chi naỹi te' para ccá cą yetsi quia', ");
INSERT INTO zaaNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Iyaba ca nui chi gunne Señor dèsdeba ca tiempo nu chi gutè. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Gunne Jacóbua adí nna ra bi: Por nu ra Tata Dios lo Escritura nna acca nia' qui'ni bittu guni ri'u tàbi para adí ca enne' qui' adí ca nacion canu chi betse'e latsi' quį ca creencia mal qui' quį nna càhua latsi' quį gui cą nu rú'ulatsi' Tata Dios. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Huacca taání qui'ni gúdiani ri'u cą qui'ni eria cą le' ca creencia nu cca qui' ca ídolos, ą'hua qui'ni bittu thualàni cą nu labí ná tsela quį, ą'hua qui'ni bittu go cą bèlá' qui' ca animal nu gutti xìhui' nìhua réni qui' quį nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Porqui'ni chìa gutsá nna tsè'e canu riquixá'a nu ra lo ley qui' Moisés, pues le' ttu ttu yetsi qui' quį nna dua ttu sinagoga làti retuppa cą ttu ttu sábadu ní canu calatsi' quį iyénini nu bedia bi. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","De chi ra cabía ca tìtsa'a nna làniana ituba iglesia lani ca apóstol nna ca anciánua nna ra cabi qui'ni tsè'ba ná gucué' cabi tuchùppa ca enne' entre làcabi para ithèl·la' cabi cą Antioquía lani Pablua nna Bernabéa nna. Acca beni cabi nombrar Judas lá huá bi Barsabás, ą'hua Silas nna, porqui'ni yala enne' dacca' ná cabi le' tsina qui' Señor. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Guthèl·la' tè cabi ttu carta lani cabi nna ra: Lebi'i hermanos ca enne' labí ná raza judío tsè'e le' ciudad Antioquía, ą'hua ca hermanos tsè'e le' adí ca yetsi le' nación Siria nna ituba región lą́ Cilicia nna: Intu' ca apóstol nna ca anciano lani adí ca hermanos creyente nna runi tu' le saludar. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Chi bina tu' qui'ni tuchùppa ca nubeyu' biria làti tsè'e tu' nna riquixá'a cą qui'ni guni le nu ná tàbi nna rucuè'eni cą latsi' le nna ra cą qui'ni caduel·la' ccá le circuncidar nna guni le seguir nu ra lo ley nu bedia Moisés, pero nìdi permiso làa gunàbani cą intu'. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Acca betuppa tu' nna gùnne lettia tu' guni tu' nombrar tuchùppa ca hermanos para ithel·la' tu' cabi làti tsè'e le lani ca hermanos tsè'ni qui' ri'u Bernabé nna Pablo nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Làcabi nna chi biria latsi' cabi la'labàni qui' cabi nna labí rátsini cabi gatti cabi por nu riquixa'a cabi nu cca qui' Xana' Ri'u Jesús enne' ná Cristua. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Acca rithel·la' tu' Judas nna Silas nna para equixá'a huáni cabi le lani titsa' ru'a taá ca cosį. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Espíritu Santo nna labí rú'ulatsi'e qui'ni guni tu' le esforzar para guni le bícca'aỹáru nu làhuabi caduel·la'. Intu' nna tsè'e hua tu' de acuerdo. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Pero rinèni tu' le qui'ni bittu go le bèlá' qui' ca animal nu chi gutsia ru'a lo ca ídolos, nìhua bittu go le réni, nihua belá' qui' ca animal nu gutti xìhui', ą'hua bittu thualàni le nu labí ná tsela le nna. Canchu hué' le cuidado de ca cosį nna tsè'ba runi le. Tata Dios nna gunie le cuàlani. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","De chi guthel·la' ituba iglesia cabi nna, huía tè cabi ciudad Antioquía. Nía nna betuppa cabi ca creyente nna bete cabi cuenta carta. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bil·lùỹa ba bìl·là ca hermanos carta nna yala bedácca'ni cabi por la'ỹeni nu rinne lo carta. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas nna Silas nna yala la'huacca qui' Espíritu té lani predicación qui' cabi nna yala la'ỹeni bete cabi lani ca hermanos, ą'hua bè' cabi adí fuerza espíritu qui' quį por medio de ca titsa' tsè'ni qui' cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tuchùppa ubitsa bitola nna, bechu titsa' ca hermanos cabi lani la'ỹeni para eyéqquia cabi Jerusalén làti tsè'e canu guthel·la' cą cabi Antioquía. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pero Silas nna gulèqquia latsi' bi eyà'na bi Antioquía. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ą'hua Pablo lani Bernabéa nna beyà'na cabi le' Antioquía. Làcabi lani adí iỹé ca hermanos qui' iglesia nna gutixa'áni cabi claru taá ca creyente cúbía ti'iỹa ná nu guni cabi de acuerdo tì'ba ra titsa' qui' Señor, ą'hua beni cabi predicar evangelio nna. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nía bá bitsà cabi, làniana ra Pablua Bernabéa: Tsía ri'u attu vuelta huennèl·le' a creyente le' iyaba ca yetsi làti chi gutixa'áni ri'u cą titsa' qui' Señor para ccá ri'u saber ti'iỹa tsè'e cą. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabéa nna uccua latsi' bi iche' cabi Juáan enne' lá huą́ Marcos. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pero Pablua nna labí guyú'ulatsi' bi iche' cabi Juan Marcos attu vuelta porqui'ni làbi nna betse'e latsi' bi cabi dèsdeba región lą́ Pamfilia pues labí beni bi seguir lani tsina nu chi gùdulo cabía. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Por nui nna gùtà' ttu disgusto entre Bernabéa nna Pablua nna; acca gùla'a luetsi cabi. Bernabéa nna guche' bi Juan Marcos nna gutèl·la' cabi ttu barco nu día para Chipre. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablua nna becué' bi Silas. Lani oración nna gunàba ca hermanos favor qui' Señor para làcabi nna, día tè cabi. ");
INSERT INTO zaaNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Tanèl·le' cabi adí ca iglesia anta' le' nación Siria nna bete cabi adí ca consejo tsè' qui' ca creyéntea nna gùppa cą adí ánimo; anía beni huá cabi le' región lą́ Cilicia. ");
INSERT INTO zaaNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Làniana huía Pablo nna Silas nna attu región nna bitsina' cabi le' ca yetsi Derbe nna Listra nna. Nía nna taxácca' cabi ttu enne' ríalatsi' láą Timotea ỹi'ni ttu niula raza Judea ná huą́ creyente. Tàta qui' Timotéua nna uccuą raza griego. ");
INSERT INTO zaaNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Iyaba ca hermanos tsè'e Listra nna Iconio nna yala tsè' rinne cabi qui' Timotéua. ");
INSERT INTO zaaNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablua nna uccua tè latsi' bi tsía Timotéua lani bi. Acca beni tè bi ą circun