﻿USE sofia;
DROP TABLE IF EXISTS sofia.yuw_vpl;
CREATE TABLE yuw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yuw_vpl WRITE;
INSERT INTO yuw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Oro, ngomai Yesu Duichon ombu sakungnihon ma torop. Yesu yu Devithon morogono, Devit yu Abrahamphon morogono. ");
INSERT INTO yuw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham yu Aisakhon fano, Aisak yu Jeköphon fano Jeköp yu Yuda yomot oröcma yuhon fano. ");
INSERT INTO yuw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda yu Peres orin Serahon fano. Yuhon macno woi Tamar, Peres yu Hesrönthon fano, Hesrön yu Ramphon fano, ");
INSERT INTO yuw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram yu Aminadaphon fano, Aminadap yu Nasönthon fano, Nasön yu Salmonthon fano, ");
INSERT INTO yuw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon yu Böashon fano, macnoi Rahap, Böas yu wömai Öbethon fano, macnoi Rut, Öbet yu Yesihon fano, ");
INSERT INTO yuw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesi yu King Devithon fano, Devit yu wömai Solomonthon fano. Solomonthon macno woi Uriahon oweno. ");
INSERT INTO yuw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon yu Rehöböamphon fano, Rehöböam yu Abiyahon fano, Abiya yu Asahon fano, ");
INSERT INTO yuw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa yu Yehösafathon fano, Yehösafat yu Yöramphon fano, Yöram yu Usiahon fano, ");
INSERT INTO yuw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia yu Yötamphon fano, Yötam yu Ahashon fano, Ahas yu Hesekiahon fano, ");
INSERT INTO yuw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia yu Manasehon fano, Manase yu Amonthon fano, Amon yu Yösaiahon fano, ");
INSERT INTO yuw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yösaia yu Yöyakin orin orugi yuhon fano. Bongono wocin wömai Babilön nano yu Israel nano yangato fonguya youp wabkarac böyo- mo idung. ");
INSERT INTO yuw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ihoroc tongga idiya mongorec toctoc youp wo bödeuna wocin wömai Yöyakin yu Sealtielhon fano idoc. Sealtiel yu Serubabelhon fano, ");
INSERT INTO yuw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel yu Abiuthon fano, Abiut yu Eliakimpon fano, Eliakim yu Asörhon fano, ");
INSERT INTO yuw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asör yu Sadökhon fano, Sadök yu Akimphon fano, Akim yu Eliuthon fano, ");
INSERT INTO yuw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut yu Eleasarhon fano, Eleasar yu Matanthon fano, Matan yu Jeköphon fano, ");
INSERT INTO yuw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jeköp yu Yösephon fano, Yösep yu woi Mariahon opno. Oro Maria yu wömai Yesu Duic bagoc. Duic wömai Kopotorocho ‘owi amna wontucmunodecma öcangyun muuya batip itnung’ yongo inong muuna eboc. ");
INSERT INTO yuw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Oro Abrahamdecma forosingga toropni 14 ihoroc öngkung tonguya worocho menon Devitho öngkuboc. O wönggon Devitdecma forosingga toropni 14 ihoroc öngkung tonguya bongono wocin wömai Babilön nanoho Israel nano inoin youp amna boyömoha yangato fonggung. O Israel nano Babilön sae idiya wönggon torop 14 ihorocho öngkung tonguya Duic öngkuboc. ");
INSERT INTO yuw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Oro, Yesu Duic öngkubocmahon fatno wömai ingoroc: Amna morömaho Maria urop Yösephon fat bogigung. Tuya yu abe kondong maidinya Kunkun Yaruho tuna Maria yu mana modip idoc. ");
INSERT INTO yuw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Oro opno Yösep yu amna nongnongo ididoc. Worocha tongga yu ‘Maria yangam fap tong imityit’ yongo suraroho yangamin mata youpdec tohong yucyucha makombigoc. Muno yu ‘owena öpgon fodingma ongoun’ yongo kombigoc. ");
INSERT INTO yuw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ihoroc kombingga idina duc itudec Morömahon sum yaru auho öngkung imongo inogoc, “Yösep, Devithon morogono, goc Maria tong sicsicha botirocha. Muno Kunkun Yaruho toroc kiap au tuna mana modip wo itac. ");
INSERT INTO yuw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yu woi managumboc amnano baangoc. Tuna gocho mano ‘Yesu’ ihoroc mambengoroc. Ma worochon foro wömai ingoroc: Yu owi amna wontucmunodecma öcangyun muuya batip itnahing.” Sum yaruho Yösep ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Oro, manomano ngo öngkubocmaha tongga Kopotorocho osucgon yong tuctuc amnaho ducdecma mata yogocma worocho boinno öngkuboc. Mata wömai ingoroc yogoc, ");
INSERT INTO yuw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kombiarut, kunkun owi berac au yu modip ito managumboc amnano baangoc. Yuhon mano wömai Emanuel ihoroc mambotnahing.” Emanuel ma worochon foro wömai ‘Kopotoroc nonot itac’ ihoroc. ");
INSERT INTO yuw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Oro Yösep yu duc itu ihoroc tongo wekongga Morömahon sum yaruho mata inogocma worochon toroc tanda Maria tong sigoc. ");
INSERT INTO yuw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Maria tong sigoc mahong yu yuot kondong abe maidinya yu managumboc amnano bagoc. Bauna yuhon mano Yesu ihoroc mambodoc. ");
INSERT INTO yuw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Oro, Maria yu Betlehem bucin Yudia distrikdec woce itmuna Yesu bagoc. Bongono wocin wömai King Heröt yu guroc wo angtorengga idoc. Tuna kombic kombic amna au yu Kantri sep ohonggongin wocenemaho Yerusalem ebung. ");
INSERT INTO yuw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Engmuya owi amna ingoroc inong ac tong tonggung: “Managumboc wego Yudananohon kingno engocma, yu nahenne itac? Nonu sep öngkup öngkupin wocene fitnungno agomon. Tongga nonu yu yong moröng yong imocimocha ebamon.” ");
INSERT INTO yuw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ihoroc yuya King Heröt yu mata woroc kombingga soroc yogoc. O yuhogon muno, Yerusalemma owi amna ambaracho mata wo kombingga soroc yogung. ");
INSERT INTO yuw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tuya Herötho öret socsoc amna dugohu o nongoru gendic fandat fandat amnahu yu ambarac inong yuna eng suran tuya ingoroc inong ac togoc, “Amna wo Duic, yu böcsa nahe sinom öngkuangoc?” ");
INSERT INTO yuw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ihoroc inong ac tuna yu mata ingoroc ibanda inogung, “Yu woi Betlehem bucin Yudia Distrik woce öngkuangoc. Osucgon Kopotorochon yong tuctuc amnaho mata ingoroc irim togoc: ");
INSERT INTO yuw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Son Betlehem nano, son ingoroc yoningyit: Nonthon toropdecma amna moröma au maöngkuic, nonthon ma noni Yudia gurocin maec yo. Muno son ihoroc yoninga, bonip sonidecma wömai amna moröma au öngkuangoc. Tongo yu nochon toropna Israel, yuhon dugo moröma itmuna yu tong batip tongga ogepmagon yangtoreangoc.’” Amna morömaho King Heröt mata ihoroc inogung. ");
INSERT INTO yuw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tuya Heröt yu mata woroc kombingga kombic kombic amna sa korungonma ebungma yu öpgon inong yuna ehuya ingoroc inong ac togoc, “Fitnung worocho bongono yaödec sinom son öngkung kamogoc?” Ihoroc inuna yuho worochon yongburocno tuctugo inuya ");
INSERT INTO yuw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Herötho ingoroc inogoc, “Son ongmuya managumboc worocha yabic yabic youp orongi tonung. Ihoroc tongo wo au feunai wömai son karupgon ibaru fauna nocot engmuya sa nahenne itacno wohon fatno nanonung. Tuya nocho ihorocgon ongmaina yu yong moröng imangot.” Herötho yu mata ihoroc inongga inong muuna onggung. ");
INSERT INTO yuw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Oro King Herötho mata ihoroc inuna kombic kombic amna yu ongga uyapdec idiya fitnung osuc sep ohonggongin auya yangato febocma worocho wönggon osuc fat imongga yangat fongga managumbocho idocan sa woce nongnong yongga idoc. ");
INSERT INTO yuw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kombic kombic amna yu fitnung woroc angga kombing borong moröma sinom togung. ");
INSERT INTO yuw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tongo yu böc ganang öngmuya Maria yan macno woroc yangga goruc yemoc tongo managumboc yong moröng imogung. Tongo yocno öcangga irot ogep toctochon manomano fogida managumboc wo imogung. Irot ogepha wömai yu Gol orin wi boröcno tugo ogepmanima orin unac au mano mir woroc managumboc imogung. ");
INSERT INTO yuw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ihoroc tuya mit wömai Kopotorocho yu duc itudec ‘son wönggon Herötot ongoninga’ yongo ‘muno’ inogoc. ‘Muno’ inuna yu uyap auhongon sindanmuya inoin böcsanon onggung. ");
INSERT INTO yuw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Oro kombic kombic amna yu ongidiya Morömahon sum yaru auho engmuna duc itudec Yösep ingoroc inogoc, “Heröt yu managumboc worocha yabingga wot omom toctocha kombihac. Worocha goc idongga managumboc yan macno Isip kantri woce karupgon öp yangat fongiya woce itnung. Son woce idiya nocho wönggon mata ganangot.” ");
INSERT INTO yuw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sum yaruho Yösep ihoroc inuna yu woroc kombingga idongo kumbonggon managumboc yan macno yangauna Isip kantri sa woce onggung. ");
INSERT INTO yuw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Woce ongga idiya Heröt omboc. Oro, yapmu wo öngkupacma woi osuc Morömaho yong tuctuc amnahon ducdec yogocma worochon toroc öngkuboc. Yu wömai ingoroc yogoc: “Nochon manana yu Isip kantri woce idina nocho yu inong yoya yu sa wo imun fauna ehangoc.” ");
INSERT INTO yuw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Oro, mit wömai Heröt yu kombigoc, ‘Kombic kombic amnaho noc imanang nanogung, yu wönggon nocot maehing’ ihoroc kombingga irotno kombut uuna ec imocno sinom togoc. Tongo yu tawa amnani inong muuna yu Betlehem böc orin böcsa obugu ambehecgon idungma woce ongmuya managumboc amnano abe biruc yai manggiradungma woroc ambarac dong omom togung. Heröt yu wömai osuc kombic kombic amna managumboc worochon öngkup öngkup bongonoha inong ac togoc. Tongo yu kombigoc, ‘Managumbocho biruc yai abe manggirahac’. ");
INSERT INTO yuw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ihoroc öngkubocmaha tongga Kopotorocho osuc yong tuctuc amna Yeremaia yuhon ducdec mata yogocma worocho boinno öngkuboc. Yu ingoroc yogoc: ");
INSERT INTO yuw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Yong uroc moröma sinom Rama böcsadec öngkuboc. Woi owi Resel yuhon obigihon wabkaracni omongbödegung. Worocha tongga yu uroci morö kombingga ointogung. Yuhon managumbocni kömbaha ombungmaha owi amnaho yuhon irot tohoc tohocha tu matogoc.” ");
INSERT INTO yuw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Oro, mit wömai Heröt yu omong fadoc. Omong fauna Morömahon sum yaruho Isip wocin Yösep öngkung imongo duc itudec ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Amna managumboc wotwotha togungma yu ino urop ombung. Worocha tongga goc idongmina managumboc yan macno yangada sa ngo imu fauna Israel Kantri woce fongoi.” ");
INSERT INTO yuw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ihoroc inuna Yösep yu idongo managumboc yan macno yangada Yudia gurocin fonggonga kombigoc. ");
INSERT INTO yuw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yu abe uyapdec ongga itmuya Yösep yu mata au ingoroc kombigoc: Yudia gurocin Heröthon manano Arkelaus yu wömai fanohon abam sogihac yo. Yösep yu ihoroc kombingga sa woce onggonga botogoc. Tuna Kopotorocho duc itudec ‘woce ongirocha’ inuna yu distrik Galili woce onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Woce ongmuya böcsa au mano Nasaret wocin idung. Oro kiapmo ihorocnoho öngkubocmaha tongga Kopotorochon yong tuctuc amnaho mata yogocma worocho boinno öngkuboc. Yu ingoroc yogoc: “Owi amnaho yuha ‘Nasaret amna’ ihoroc yonahing.” ");
INSERT INTO yuw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Oro bongono wocin wömai Jön yamuc gung imocimoc amna yu sa amna maiyan wocegon itmuna forosingga owi amna ingoroc fandat inongidoc, ");
INSERT INTO yuw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Kopotorochon mom toborucno woi urop eng fomtac. Worocha son turongo soni yangmuya uroci kombingga irot soni ibararut,” Jöntho owi amna irotno sakangga mata ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kopotoroc yu wömai osucgon yong tuctuc amna Aisaia yuhon ducdec Jöntha ingoroc yogoc: “Sa moröpmodec amna auhon mambocno ingoroc öngkupac: Morömahon youp tong arangarang tongga yuhon uyapno tobiarut.” ");
INSERT INTO yuw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Oro, Jönthon tec tohomunmöcno woi bot kamelehon dimoho tobic tobicyi ihoroc idoc. Tuna yu wo bot godibdec akep tongo itongidoc. O nacno yoit wömai gucsim orin omong omong worocgon nongidoc. ");
INSERT INTO yuw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Oro Yerusalem nanohu o owi amna Yudia gurocin ididungmahu o owi amna böcno Yödan yamuc tan idtonggungmahu yu ambaracho Jönot ongbödengmuya ");
INSERT INTO yuw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","turongono yong tabung. Ihoroc tuya Jöntho yu Yodan yamucdec yamuc gung imogoc. ");
INSERT INTO yuw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ihoroc tuna Farisi orin Sadyusi koböcma yu ihorocgon Jön yamuc gupgup youp tongidocan woce ebung. Ehuya Jöntho yu yangga ingoroc inogoc, “Son goröm wontucmunohon morogoni! Kopotorocho turongo soniha ecego moröma kombihac. Worocha tongga sontho botongga ‘urago nimicyit’ yongo komanang sinom yamuc gupgup sogit sogitha yang yo. ");
INSERT INTO yuw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Son muyu wontucmuno soni imu fauna irot soni ibanda boinno ogepma fiarut. ");
INSERT INTO yuw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Son ingoroc kombininga: ‘Non Abrahamphon morogo idamonmaha tongga Kopotorocho nontha irot ogep kombihac.’ Muno sinom, nocho ingoroc kantiwa: Kopotoroc yu ogep yuna sop ngorocho Abrahamphon morogoni baun. ");
INSERT INTO yuw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mata tepmo au sontha ingoroc itac: Kopotorochon duric urop ep foro faicfaicha tong arangarang tongga itac. Tuna ep auho boinno ogepma mafingitacma yu wömai duriho faingyun muuya epho dinahing.” ");
INSERT INTO yuw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jöntho ihoroc yongo mata sakaun fiuna yogoc, “Nocu amna komanangno worocha wömai nocho yamucgon gung kamongitat mahong mit wömai amna moröma sinom ehangoc. Yuhon gesönoho wömai nochon gesöna anggirahac. Nocho yuhon mene darange matoctocno yu amna gendicma morö. O nocho youp tongitatma wömai yamucdecgon tongitat mahong amna mit ehangocma yu wömai owi amna yangsoworengga Kunkun Yaru orin ep aranggumot gung imangoc. ");
INSERT INTO yuw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Amna moröma wo yu wömai owi amna tong erac eracha ehangoc. Nonu ‘nacno ogep itachu o moinno itachu’ yongo yang soworengidamonma, worochon toroc wömai yuho non ning soworeangoc. O yu urop youp toctocha tong arangarang tongga itac. Nacno ogepma wömai yu ino bucin fong suran tangoc mahong nacno moinnoma wömai ogutho ep koingdec sangoc. Ep aranggum wo wömai amna auho tu omomno maec, muno woi iditnoho iditno engoc.” Jöntho Yesuha yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Oro bongono wocin Yesu yu ‘Jöntho yamuc gung nampun’ yongo Galili guroc imun fauna Yödan yamucdec ohogoc. ");
INSERT INTO yuw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ohuna Jöntho yu angga ‘muno’ yongo Yesu ingoroc inogoc, “Goc amna moröma worocha gocu noc yamuc gung namontarocma wömai angit in. Tingtinga gocho ‘noc yamuc gung gampiwa’ yongo nocot eparoc?” ");
INSERT INTO yuw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ihoroc inuna Yesuho matano ökene ingoroc iban imogoc, “Goc mata boinno yaroc mahong notu Kopotorochon irot kombic kombic tandup toda. Worocha öngai gocho yamuc gung nampi.” Ihoroc inuna Jöntho yuhon matanogon tanda yamuc gung imogoc. ");
INSERT INTO yuw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ihoroc tongbödeuna Yesu yamuc imun fauna tero öngga itmuna agocmai mompho fagariuna Kopotorochon Kunkun Yaruho yup kanaröm gan tongga ohongga yudec idoc. ");
INSERT INTO yuw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tuna momdecma duc inggun auho öngkungga yogoc, “Goc nakain Manana batip sinom. Noc gocha toup kombingitat. Nocho goc erangga irotnaho gocha kömehat,” duc inggun wo ihoroc öngkuboc. ");
INSERT INTO yuw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Oro mit wömai Kunkun Yaruho Yesu yangato sa amna maiyan woce tonggoc. Sa woce wömai dogu kopotho Yesu tonguc imogoc. ");
INSERT INTO yuw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Woce ida Yesu yu nacno möpgon idina sep youp toctoc 40 bödegoc. Tuna mit worec imogung. ");
INSERT INTO yuw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tuna tonguc imocimoc amna yu yuot engmuna inogoc, “Goc boinno Kopotorochon Manano itarocanu yia sop ngorocho nacno garun.” ");
INSERT INTO yuw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesuho mata woroc kombingga mata urago ingoroc iban imogoc, “Kopotorochon babiyadecu mata ingoroc irim toctocyi itac: ‘Nacnohagon tongga owi amnaho itonggong boinno maun feic. Muno, Kopotorochon duc mata tungu tungu worochogon wömai amnahon itonggong boinno tun öngkung imongitac.’” ");
INSERT INTO yuw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Oro, ihoroc yuna mit dogu kopotho Yesu yangada Kopotorochon kunkun taun Yerusalem woce öret socsoc böc koroc onoce idocan woce tögoc. ");
INSERT INTO yuw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Töngo ingoroc inogoc, “Oro gocu boinno Kopotorochon Manano itarocanu ngocin ida bangmi muhun. Wömai yaha Kopotorochon babiyadec mata ingoroc irim toctocyi itacmaha: ‘Yuho sum yaruni inuna yuho goc tong batip tongga obudec sogito tohong guuya sopho orunga gotgotno maic.’” ");
INSERT INTO yuw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ihoroc inuna Yesuho mata urago ingoroc inogoc, “Kopotorochon bapiyadec wömai mata au ingoroc irim toctocyi itac: ‘Gocho Kopotoroc Morömaya ‘mata boinno yachu munohu’ yongo tonguc yeirocha.’” ");
INSERT INTO yuw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Oro mit dogu kopotho Yesu yangauna sa urongo moröma sinom woce tögoc. Sa wocin itmunya dogu kopotho sa gurochon kantri ambarac orin yudec tong fatfatno manomano ogepma ogepma idangma wo indangdup togoc. ");
INSERT INTO yuw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Indangga yuho Yesu ingoroc inogoc, “Gocho goruc yemoc tong namongga yong moröng namiyai wömai nocho manomano yaharocma wo ambarac gocha boging gamontat.” ");
INSERT INTO yuw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ihoroc inuna Yesuho mata ökene ingoroc inogoc, “Dogu kopot wontucmuno goc ongoi. Kopotorochon bapiyadec mata ingoroc irim toctocyi itac: ‘Goc muyu Morömaya Kopotoroc yuhagon yong moröng imongga o yuhon matagon sumboda itongidiruc.’” ");
INSERT INTO yuw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ihoroc inuna dogu kopotho yu imun fauna onguna Kopotorochon sum yaruho engo Yesu mongorec tong imogung. ");
INSERT INTO yuw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Oro mit Yesuho mata ingoroc kombigoc, ‘Jön yu yi bucin itac.’ Yesuho mata ihoroc kombingga ibarun fauna wönggon Galili gurocin onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Woce ongmuna yu Nasaret taun imun fauna ongga Kaperneam böcsa wocin idoc. Kaperneam woi Galili yamuc öngköring terodec Sebulon orin Naptali guroc ambehecgon woce idoc. ");
INSERT INTO yuw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yesuho woroc togocmaha tongga Kopotorocho yong tuctuc amna Aisaia yuhon ducdec mata yogocma worocho boinno öngkuboc. ");
INSERT INTO yuw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Yu ingoroc yogoc: “Owi amna Sebulon orin Naptalihon gurocin ididangmahu o owi amna guroc top uyap tan ididangmahu o owi amna Yödan yamuc ökene ididangmahu o son bumbumyi nano Galili gurocin idangma son ambaracho mata ngo kombiarut! ");
INSERT INTO yuw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Owi amna kumbong ididangma yu yaguno moröma aang. O owi amna omomphon ötang unenne ididangma yudec itonggongon yaguno öngkung impac.” ");
INSERT INTO yuw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Oro bongono wocin Yesuho forosingga owi amna ingoroc fandat inong tonggoc, “Mom sa toborucno urop engfom tac. Worocha tongga son turongo soni yong tauya irot soni ibarut,” ihoroc inongidoc. ");
INSERT INTO yuw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Oro, Yesu yu Galili yamuc öngkoring terodec itongmuna Saimon yan oröcma yauna umben topdec monda idomoroc. Auma wömai Saimon mano au Pita ihoroc yongidung. O auma mano Andru. Yan oröcma yu söng fogito bisnis youp tongidomoroc. ");
INSERT INTO yuw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Oro yu umben monda idinya Yesuho ingoroc inogoc, “Sot engga noc nararun. Narunya nocho owi amna fogit fogithon foro tong kindaantat.” ");
INSERT INTO yuw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yesu yu Ihoroc inuna yaimaho wohogon umbenno youn fauna Yesu tan tonggomoroc. ");
INSERT INTO yuw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ongmuya Yesuho yan oröcma au yagoc. Woi Sebedihon mananin Jems orin Jön. Yu wömai fano ot girang obugudec itmuya umben dogit dogityi woroc tong arangarang tongo idung. Ihoroc tongga idiya Yesuho yaima inong yuna ");
INSERT INTO yuw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","yu wohogon girang orin fano youn fauya ongga Yesu tan tonggomoroc. ");
INSERT INTO yuw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu yu Galili gurocin itongmuna Yuda nanohon fatmata yocyoc bucin öngo Kopotorochon sa toborucno worochon fatmata ogepma owi amna fandat inong tonggoc. O ihorocgon yu owi amna obukoc foro ihono ihono tong tonggungma yu ambarac youn orokogung. ");
INSERT INTO yuw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tuna yuhon fatno morömaho Siria kantri ongbödeuna owi amnaho wo kombingga nucni obukocno foro ihono ihono togungma yu Yesuot yangat febung. Woi focfoc morö kombingidungmahu o au dogu boyömpho fogit fogityihu o omong möc tongidungmahu o amna orung oburo möng toctocyihu yu ambarac wömai Yesuho youn orokong-bödegung. ");
INSERT INTO yuw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tuna owi amna torop moröma sinom Galili provins-decmahu o Dekapolis distrikdecmahu o Yerusalem taundecmahu o Yudia provinsdecmahu o owi amna Yödan yamuc gino öke idungmahu yu ambaracho engmuya Yesu tan tonggung. ");
INSERT INTO yuw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Oro, Yesu yu yagocmai owi amna torop moröma sinom yuot ebung. Ehuya yu sa urongodec öngo omoc idina owi amna yu tan sogit tongidungma ambaracho ehuya ");
INSERT INTO yuw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yesuho forosingga fatmata ingoroc fandat inogoc, ");
INSERT INTO yuw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Owi amna inoha kombingidangma ‘non Kopotorocho yangamin uroci idamon yo,’ yu yong borongdearut. Mom toboruc woi yuhon fat. ");
INSERT INTO yuw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“O owi amna tong uroc tongidangma yu yong borongdearut. Kopotorocho yu irot ogep tong imuna borongdetnahing. ");
INSERT INTO yuw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“O owi amna inoha kombiuya ohima yu ihorocgon borongdearut. Kopotorocho sa guroc ambarac yuha imuna yuho yangtorenahing. ");
INSERT INTO yuw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“O owi amna ‘toroc kiap nongnongogon bonip nonidec moröma öngkupun’ yongo toup kombingidangma, yu yong borongdearut. Kopotorocho nongnongo kiap tun öngkuuna irotno borongdetdetho foc tuna itnahing. ");
INSERT INTO yuw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“O owi amnaho nucni yangbanauya urago wontucmuno maiban imongidangma yu yong borongdearut. Kopotorocho ihorocgon yu urago wontucmuno maiban imic. ");
INSERT INTO yuw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“O owi amna irotno oweng owengo sinom ididangma yu yong borongdearut. Yu Kopotoroc anahing. ");
INSERT INTO yuw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“O owi amnaho ayamiot irot tungu singidangma yu yong borongdearut. Kopotorocho yu ‘nakain wenai mananai’ ihoroc inangoc. ");
INSERT INTO yuw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“O owi amna toroc kiap nongnongo tuyai amna auho wo yangga dongyu moin tonahing. Tuya owi amna nongnongo ihorocnoma yuho wömai yong borongdearut. Mom toboruc woi yuhon fat. ");
INSERT INTO yuw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“O ihorocgon guroc amnaho sonu noc kombing tobing namongidangmaha kang firic firic tongo koto yong moin moin yong kamonahing. Ihoroc tuyai sonu worocha yong borongdearut. ");
INSERT INTO yuw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kopo-torocho son momphon irot ogep moröma sinom kamangoc. Worocha tongga sonu borongdetmuya irot ogep kombiarut. Toroc kiap wontucmuno worocotmagon wömai Israel nanoho osuc Kopotorochon yong tuctuc amna ididungma yu tong imongidung.” ");
INSERT INTO yuw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesuho yogoc, “Sonu guroc owi amnahon bonipnodec yiphon toroc simbang itongitnung. Yip woi yapmu ibibo sinom mahong worochon ibibono sum faunai wömai nonu tingting tonaya wönggon ibibo in? Yip ihorocnoho woi youpno angit matic. Muno, amnaho wo koringyu onguya yambenidang. ");
INSERT INTO yuw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Oro sonu guroc owi amnahon bonipnodec yaguno simbang itongitnung. Böcsa au sa urongodec onoce itacma woi öp maic. ");
INSERT INTO yuw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","O ihorocgon amnaho gop gango wagadec matau weditac. Muno, yu wömai gop gata abamodec singidang. Ihoroc tuna gopho böc ganang yaguno muuna amna ambaracho yagunodec entang. ");
INSERT INTO yuw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Oro worochon torocgon wömai sonthon yaguno soniho owi amnaho yangamin muhun. Ihoroc tuya toroc kiap ogepma soniho eran idina owi amnaho kangga Nandöng soni momdec itacma yuhon mano yong moröng imontang.” Yesu yu yip orin yagunohon mata tepmo ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesuho mata sakaun fiuna ingoroc yogoc, “Noc ebotma wömai ‘nongoru mata, orin Kopotorochon yong tuctuc amnaho mata kanogungma, woroc körengma ongoun’ yongo maebot. Muno, noc ebotma wömai ‘nongoru orin yong tuctuc amnahon mata wo ambaracho boinno öngkupun’ yongo ebot. ");
INSERT INTO yuw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nocho boinno sinom kantiwa, mom orin gurochon bongono idina nongoruhon gesöno ihorocgon koing songga engoc. Nongoru matahon irim docno obmu obmu au magorong ongic. Muno sinom nongoru mata ambaracho koing songga boinno öngkungdup tonahing. ");
INSERT INTO yuw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Worocha tongga amna auho nongoru obugu tungugon fodingmun onguna ‘nucni ihorocgon tongitnung’ yongo imanang fandat inontacanu wömai yu mom toborucdec madango sinom engoc. Wohong amna auho nongoru mata sumbotdup tongmuna nucni nongoruhon foro nongnongo fandat inongitacma yu wömai mom toborucdec amna moröma engoc. ");
INSERT INTO yuw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nocho ingoroc kantiwa: Farisi orin nongoru gendic fandat fandat amna yu wömai nongoru angit masumbodidang. Worocha tongga yu mom toborucdec mangoning. Kombiarut, son muyu yuhon toroc kiap gendöngni wo yanggirada toroc kiap nongnongo tongitnung. Tongo son ogep mom toborucdec ongonahing,” Yesu yu nongoruhon mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesuho wönggon mata sakaun fiuna ingoroc yogoc, “Son urop kombiang, ombu sakungsoni yu osuc nongoru ingoroc sogidung: ‘Son nuc soni dong omom toninga. Amna au ihoroc tontacanu wömai yu mata youpdec engoc.’ ");
INSERT INTO yuw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Oro ombu sakungsoni yu nongoru ihoroc woi kombingidung mahong nocho nongoru worochon foro ingoroc kantiwa: Amna au yu orugoha ececgo kombiantacma yu woi ihorocgon mata youpdec entac. O amna auho orugo inong möpmöp tontacma yu wömai matano tobic tobicha amna dugohon surandec entac. O ihorocgon amna au yu nucno ‘goc amna bumbumyi’ ihoroc inontacma yu woi ep bohönghon fat entac. ");
INSERT INTO yuw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Worocha wömai woroc, gocu Kopotorochon öret socsocha ececa yongga altadec tongmina wohogon kombiantaroc, ‘oröcnaot mata nodi itac yo’ oro ihoroc kombiantarocanu ");
INSERT INTO yuw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","wömai gocu öreta karupgon sirocha. Muno, goc öreta wo alta tan siiya idina gocho oröcaot ongmina mata soti yongo tobiarun. Tobingbödenggai, wömai goc ogep ongmina Kopotorochon öret sontaroc. ");
INSERT INTO yuw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Oro, ayama auho goc mata soti tobic tobicha mata youpdec tohong guunai wömai gocu uyapdecgon kiring imia mata soti wocegon yun bödehun. Mabödeunai wömai ayamaho goc gangat töngga mata yun bödec bödec amnaho oburodec siantac. Tuna amna worocho mata soti yun bödeuna tawa amnaho goc sogito yi bucin tohong guantac. ");
INSERT INTO yuw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nocho boinno sinom kantiwa, gocho wocegon itmina ongga möneng butogo saringdup tontaroc.” Yesu yu amna wot omom toctochon nongoruha yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Tongo Yesuho mata sakaun fiuna ingoroc yogoc, “Son osucgon nongoru mata ingoroc kombingidung: ‘Son owi göra toninga.’ ");
INSERT INTO yuw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Oro sonu nongoru ihorocgon kombingidung mahong nocho nongoru worochon foro ingoroc kantiwa: Amna auho owi auha angibip tontacma yu wömai irotnon urop owi göra kiap tac. ");
INSERT INTO yuw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Worocha wömai dara arocemaho gangauna wontucmuno tontarocmai wömai dara fonuntho tomi ongoun. Godip föbahon docno tungugon gorong ongontacma woi yapmu moröma muno. Wohong godip föba ambarac ep bohöng tomu ohontacma woi yapmu moröma. ");
INSERT INTO yuw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","O ihorocgon obura arocnemaho tuna goc wontucmuno tontarocanu wömai gocho wo kondong tongo tomi ongoun. Godip föbahon docno tungugon gorong ongungocma woi yapmu moröma muno. Wohong godip föba ambarac ep bohöng tomu muantacma worocho wömai yapmu moröma,” Yesu yu owi göra toctochon nongoruha ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Tongo Yesuho mata sakaun fiuna ingoroc yogoc, “Son osucgon nongoru mata ingoroc kombingidung: ‘Amna au oweno fodingmun onggonga kombiantacma yu muyu oimna fodiun toctochon yong tuctuc bapiya irim tongo oweno impun. Tongo mit wömai yu ogep owi wo fodingyun ongontac.’ ");
INSERT INTO yuw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Oro son nongoru ihorocgon kombingidung mahong nocho worochon foro ingoroc kantiwa: Amna auhon oweno yu amna auot muyu muyu kondong itongunyai wömai opnoho owi wo ogep fodingmun ogoun. Wohong amna auho yu oweno forono muno fodingmun ongunai wömai amna worocho tuna owiho oimnahon nongoru gacmotac. Tuna amna auho owi au osuc opnoho fodingmun onggocma wo tong siantacma yu wömai ihorocgon oimnahon nongoru gacmotac.” Yesu yu oimnahon nongoruha ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Tongo Yesuho mata sakaun fiuna ingoroc yogoc, “Sonu urop kombiang, ombu sakung soni yu nongoru mata ingoroc sogidung: ‘Goc Kopotorocho yangamin yapmu auha yong koing yontarocanu wömai gocho mata yarocma wo fodirocha. Muno, goc muyu yong koing yarocma worochon torocgon tiruc.’ ");
INSERT INTO yuw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Oro sonu nongoru ihorocgon kombingidung mahong nocho worochon foro ingoroc kantiwa: Son muyu mata boinnogon yongitnung. Son mata yong koing yongmuya momdec tong koing toninga. Muno sinom, mom woi Kopotorochon omoc idit abam. ");
INSERT INTO yuw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","O ihorocgon yapmu auha yong koing yongmuya sa gurocdec tongkoing toninga. Sa guroc woi Kopotorochon orung sicsic abamogon. O ihorocgon son mata au yong koing yongmuya Yerusalemdec tong koing toninga. Yerusalem woi King moröma Kopotoroc yuhon taun. ");
INSERT INTO yuw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","O ihorocgon yapmu auha yong koing yongga bicadec tong koing tirocha. Yaha, goc bica sakemo kombutni wo tia föhöc entacnohon gesö maitkamoc. ");
INSERT INTO yuw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Worocha wömai sonu ‘öc’ ihorocgon yongga worochon torocgon tongitnung. O ‘muno’ ihorocgon yongga worochon torocgon tongitnung. Mata ngoroc sakau fiuna yapmu auha yong koing yocyocno woi dogu kopothon toroc kiap.” Yesu yu mata tong koing toctocha ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Tongo Yesuho mata sakaun fiuna ingoroc inogoc, “Son osuc nongoru mata ingoroc kombingidung: ‘Amna auho nucnohon daro tun obökunai wömai nucnoho urago tongga amna worochon daro tun obökoun. O ihorocgon amna auho nucnohon maro fariunai wömai nucnoho urago tongga amna worochon maro ihorocgon fariun.’ ");
INSERT INTO yuw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Son nongoru ihorocgon kombingidung mahong nocho worochon foro ingoroc kantiwa: Amna auho wontucmuno tong gamunai wömai gocu urago tirocha. Amna auho moguma arocne gunai wömai gocu ibanda ökema boging impi. ");
INSERT INTO yuw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","O ihorocgon amna auho gochon tec tohomimöca sogit sogitha goc mata youpdec tohong gunai wömai gocu tec tohomimöca orin sum teca yait yait yu boging imiruc. ");
INSERT INTO yuw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","O ihorocgon amna auho goc kiring gamongga ganontac, ‘Gocho nocot kilomita tunguhon toroc kondonggon uyapdec ongoda.’ ihoroc ganontacanu wömai gocho yuot kilomita yaihon toroc ongiruc. ");
INSERT INTO yuw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Oro amna auho ‘yapmu au nampi’ yongo ganong ac tunai wömai goc muyu imiruc. O amna auho yapmu auha ‘komong sogida oipmon wönggon gamangot’ ganunai wömai goc ‘muno’ inirocha, muyu imontaroc.” Yesu yu urago toctochon mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Tongo Yesuho wönggon owi amna mata ingoroc inogoc, “Son urop nongoru mata ingoroc kombingidung: ‘Goc nucaiha toup kombingidiruc. Wohong ayamaha wömai ayam tong imongidiruc.’ ");
INSERT INTO yuw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Oro son nongoru ihorocgon kombingidung mahong nocho worochon foro ingoroc kantiwa: Son muyu ayam soniha irot mongorec tong imongitnung. O amna auho son kang firic firic tontanganu wömai son muyu ‘Kopotoroc yu tongfat yehun’ yongo dönac youp tongitnung. ");
INSERT INTO yuw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Son kiap ihorocno tontanganu wömai sonu boinno sinom Nandöng soni momdec itacma yuhon weni manani entang. Wömai yaha, Nandöng soni yu sep yaguno kokorengmuna amna ogepmagon maimongitac. Muno yu tuna sepho foringga amna wontucmunohu o amna ogepmahu yu yaityait tongfat yengitac. O ihorocgon Nandöng soni yu komöc kokorengmuna amna nongnongo yuhagon maimongitac. Muno, yu tuna komöc möngga amna nongnongohu o amna gendöngnihu yu ambaracha tongfat yengitac. ");
INSERT INTO yuw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Worochai oro sontho amna son ogep tong kamongidangma yuhagon toup kombiantangma woi yapmu moröma muno. Son kiap ihorocnoha wöngnac soni au masogitning. Muno, takis fogit fogit amna imanangni yu wömai toroc kiap worocotmagon tongidang. ");
INSERT INTO yuw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","O ihorocgon gocho nip oröc yuhagon sep ogep inontarocma woi yapmu moröma muno. Owi amna ambaracho wömai orugi ogepmaha sep ogep inongidang. O bumbumyi nano yu kiap ihorocnogon tongidang. ");
INSERT INTO yuw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Wohong son muyu Nandöng soni momdec itacma yuhon toroc kiap ino yabitno worocgon tanitnung. Yu wömai owi amna ogepmahu o wontucmunohu yu ambarac tongfat yengitac.” Yesu yu ayam noniha irot tong fup imocimocha mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tongo Yesuho mata sakaun fiuna ingoroc yogoc, “Son soni woho, son toroc kiap ogepma soni ‘owi amnaho niuya ma moröma sogitna’ yongo suraroho yangamin toninga. Muno sinom, son ihoroc tontanganu wömai Nandöng soni momdec itacma yu irot ogep soni makamic. ");
INSERT INTO yuw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","O gocho amna urocima yapmu au imontarocanu wömai gocho ‘owi amna ambarac noc ihoroc tontatno kombiarut’ yongo amna au inia yu osuc fat gamongo baro busuya owi amnaho gangga idiya goc amna uroci yapmu au imontaroc. Toroc kiap ihorocno woi wontucmuno sinom. Imanang amna yu fatmata yocyoc bucinthu o uyapdechu kiap ihorocnogon tongidang. Ihoroc tuya owi amnaho ‘yu amna nongnongo ogepma sinom’ yongo ma morö imongidang mahong son soni woho, nocho boinno sinom kantiwa: Amna ihorocnomaho wömai wöngnacno urop guroc ngocin amnaho oburodec fogitdeang. Tuna Kopotorocho yu wönggon momphon irot ogep au maimic, muno sinom. ");
INSERT INTO yuw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Worochoi oro, gocu amna urocima tongfat yecyecha kombiantaroc-anu wömai goc öpgon tongfat yeiruc, suraroho yangamin muno. ");
INSERT INTO yuw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ihoroc tiai wömai gochon toroc kiap ogepma wo guroc ngocin eran maic mahong Nandönga momdec itacma yu wömai manomano öp idangma wo yang tuctuc tongga worochon irot ogep gamangoc.” Yesu yu tong ogep toctochon yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Tongo Yesuho wönggon ingoroc yogoc, “Dönac yocyocha wömai sonu imanang amnaho dönac youp tongidangma ihoroc tongitninga. Yu wömai fatmata yocyoc bucin amnaho yangamin idongga dönacno ubarago yong fandada toup kombingidang. O ihorocgon yu uyap macnodec idongmuya, ‘amnaho niarut’ yongo dönacno yongidang. Nocho boinno sinom kantiwa, amna ihoroc tongidangma yu urop guroc ngocin wöngnacno fogitdeang. Tongo mit yapmu ogepma au masogitning. ");
INSERT INTO yuw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Wohong gocu dönac yontarocanu wömai goc gakabut böc ganang öngga simbu songga Nandönga momdec öp itacma yu dönac inti. Yu wömai goc böc ganang itmina dönaca öpgon yontarocma wo gangga irot ogeba gamontac. ");
INSERT INTO yuw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“O son dönac yonggai, mata koböc koböc komanang yong fandaditninga. Muno bumbumyi nano yu wömai ihoroc tongidang. Yu ‘non mata koböc yonaya Kopotorocho kombing nimontac’ yongo mata koböc koböc yongidang. ");
INSERT INTO yuw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sonu yuhon toroc kiap tanninga. Kombiarut, sonu abe dönac mayi idiya Nandöng soni yu urop son yaö manomanoha docmöangma wo kombingdehac. ");
INSERT INTO yuw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Worocha son dönac soni kiap ingorocnodec yongitnung: ‘Sa Gapgap Nandöng noni, goc momdec iditaroc. ");
INSERT INTO yuw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Engga irot danong guroc danong moröm tong nimpi. Momdec gochon duc sumbot sumbot itac. O ihorocgon gurocdec nondec öngkungbödeng tongoun. ");
INSERT INTO yuw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Goc önga nacno toroc nonidec nimpi. ");
INSERT INTO yuw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Goc turongo noni imi fat nimpun. O nonu ihorocgon amna wontucmuno tong nimongidangma yuhon turongno dongyana faarut. ");
INSERT INTO yuw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Goc tonguc yecyecdec fohong nuirocha. Muno gocho non wontucmuno morömo yuhon oburodecma öcangyi möarut.’ ");
INSERT INTO yuw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kombiang, amnaho wontucmuno tong kamuya sontho yuhon turongono dongyu faantanganu wömai Nandöng soni momdec itacma yuho sonthon turongo soni ihorocgon dongyun fat kamontang. ");
INSERT INTO yuw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wohong sontho nuc sonihon turongono kokoreantanganu wömai woroc, Nandöng soni yu sonthon turongo soni ihorocgon kokoreantac,” Yesu yu dönac yocyocha ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tongo Yesuho wönggon ingoroc yogoc, “Oro son Kopotorocha gending imongmuya nacno manai entanganu wömai son imanang amnaho tongidang ihoroc tongitninga. Yu wömai ‘owi amnaho niarut’ yongo yangam tong uroc uroc tongga itongidang. Tuya owi amnaho yu yangmuya kombingidang, ‘Amna wo yu nacno manai itac yo.’ Oro nocho boinno sinom kantiwa, amna ihorocno yu urop wöngnacno guroc ngocin fogitdeang. ");
INSERT INTO yuw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Wohong goc Kopotoroc gending imongmina nacno manai entarocanu wömai ingoroc toi: Bica sakemo sisorengga yangama sac woti. ");
INSERT INTO yuw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ihoroc tia amnaho gangmuya goc nacno manai itarocma woroc makombining. Wohong Nandönga momdec öp itacma yu wömai manomano öp idangma wo ambarac tangtango yangitac. Tongo yu gangga irot ogep kamontac.” Yesu yu nacnoha gendic sicsicha ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Tongo Yesuho mata sakaun fiuna ingoroc yogoc, “Gurocdec ngocin yoctec manomano idangma woi gongontho nongidanghu o nogotno fatho obukong idanghu o usem amnaho böcsoni gumantho manomano usem fongidang. Worocha tongga sonu gurocdec ngocin yoctec, möneng, o manomano koböcma fengsuran toctocha youp moröma toninga. ");
INSERT INTO yuw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Muno, son muyu ‘ma noni momdec moröma itun’ yongo youp moröma wömai tongitnung. Ihoroc tongga gongontho nocnocnohu o nogotno fatfatnohu o usem amnaho wömai youp sonihon boinno madongyu obukoning. ");
INSERT INTO yuw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kombic kombic soni yansawoha ding fingga entacma wömai irot soniho worochagon kombiantac. Momphon manomanohu o guroc ngorochon manomanohu,” Yesu yu yoctec möneng feng suran toctochon mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yesuho mata sakaun fiuna ingoroc yogoc, “Dan soni woi godibhon gop yaguno. Dan soni ogepma idiyai wömai son angtangtang tongga irot soni yagunobarac entac. ");
INSERT INTO yuw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Wohong dan soni obökuyai wömai irot soni kumbongdiantac. Worocha son yaguno irot sonin itacma wo ogep angtorearut. Yaguno wo kumbong diicyit.” ");
INSERT INTO yuw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yesuho yogoc, “Amna tungu au yu amna moröma yaihon unenne itmuna amna yaihon matano yait yait angit masumbic. Muno, yu woi amna moröma aumaha me imongga youpno angit matic. O amna aumaha wömai irot ogep kombingga youpno ogepgon tong imangoc. Worocha wömai sonu ihorocgon Kopotorochon mongorec youp orin mönengon mongorec youp wo yait yait angit matoning.” ");
INSERT INTO yuw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yesuho mata sakaun fiuna ingoroc yogoc, “Nocho ingoroc kantiwa, son nacno yamuc yaöhong naantamon’ yongo itonggong soniha kombingbanac tongitninga. O ihorocgon ‘tecu yaöhong tong faantamon’ yongo godip föpsoniha kombingbanac tongitninga. Nacnohagon tongga non itonggong ogepma mau feic. O tec boruchogon godip föb noni matongfat yengidang. ");
INSERT INTO yuw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Son yup yaarit. Yu wömai nacno öndec mamöngidang. O yu nacno tonongga bucin fongga fong suran matongidang mahong Nandöng soni momdec itacma yu nacno angitgon imongitac. Oro sonu wömai yup muno, sonu amna, sonu yup yanggiratno sinom tang. Worocha tongga Kopotorocho son ihorocgon angitgon kangtoreantac. ");
INSERT INTO yuw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Oro sondecma numaho sinom kombingbanac moröma tongmuna itonggongno obmugon sakaun fiun? Amna au ihoroc toctocno woi maec. ");
INSERT INTO yuw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“O tec boru soniha wömai sonu ihorocgon kombingbanac tongitninga. Son yoröc bömböpmo yaarut. Worochon tong fatfatno wömai ogepma sinom idimang mahong yu youp au matongidang, o yu tec bubup youp matongidang. ");
INSERT INTO yuw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","O nocho boinno sinom kantiwa, King Solomon yuhon tec tong fatfatno ogepma ogepma sinom idimogoc mahong saröc bömböpmohon tong fatfatnoho wömai yuhon tong fatfatno anggiratbödehac. ");
INSERT INTO yuw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Oro, owen wo wömai önga muyunoho idiya kembotgon amnaho faingo epin fongyu möngidang mahong Kopotorocho yu tongfatfatno ogepma sinom imongitac. O sonu wömai saröchon toroc muno, sonu amna. Worocha tongga Kopotorocho son ogepma sinom kangtorengitac. Mayain, sonthon kombing tobic tobic soni woi obugu sinom yo! ");
INSERT INTO yuw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Son ‘nacno yamuc nahema sogida naantamon, o tec boru noni nahema fogiantamon’ yongo kombingbanac toninga. ");
INSERT INTO yuw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bumbumyi nano yu Kopotorochon foro makombing. Worocha tongga yu gurochon manomanoha yabic yabic youp morö tongga irot yicyic tongidang. Wohong sonu ihoroc toninga, muno, Nandöng soni momdec itacma yu urop son yaö manomanoha docmöangno kombingbödehac. ");
INSERT INTO yuw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Son muyu irot kombic kombic soni osuc Kopotorocdec ding fing akep tongitnung. Woi ‘Kopotorocho moröm tong nimpun’ yongo orin ‘Kopotorocho yangamin nongnongo itna’ yongo irot soni yuha bogiarut. Son ihoroc tontanganu wömai Kopotorocho gurochon manomano angitgon kamangoc. ");
INSERT INTO yuw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Worocha son kembothon manomanoha kombingbanac toninga. Muno, sep öngahon mepmo wömai sep öngahongon,” Yesuho kombingbanac toctochon matano ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesuho wönggon ingoroc yogoc, “Sontho nuc sonihon toroc kiapmo yangsoworeninga. Sontho nuc soni angsoworeantanganu wömai Kopotorocho ihorocgon sonthon toroc kiap soni angsoworengga yun bödeng kamangoc. ");
INSERT INTO yuw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sontho nuc sonihon toroc kiapmo angsoworengidangma worochon torocgon wömai Kopotorocho sonthon toroc kiap soni soworengo yun bödeng kamangoc. Woi toroc kiap obingodechu o kiap koingodechu, sontho tongidangma worochon torocgon wömai mit Kopotorocho urago tongga son tong kamangoc. ");
INSERT INTO yuw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","O goc yaha fön obugu oröcaho daron itacma wo wömai angitaroc mahong ep moröma gakain daran itacma woha wömai makombiroc. ");
INSERT INTO yuw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","O gocu tingtinga oröca ingoroc inontaroc: ‘Oröc, noc fön daran itacma yop yopha kombihat.’ Ihoroc inontaroc mahong gakain daran wömai ep moröma itgon tac. ");
INSERT INTO yuw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Goc imanang amna, gocu osuc ep moröma gakain daran itacma wo tong dengmina, mit wömai oröcahon fön obugu daron itacma woroc tuctugo foringga yohantaroc. ");
INSERT INTO yuw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Son manomano Kopotorochon kunkun fat yongo ficficyi wo sap imoninga. O decno sap korup tong fatfat ogepma wo botot fongyu ongoninga. Bot orungoho wo yambenda tong samborec tongo ibaru fauna soni tong moin moin tong gamoningyit,” Yesu yu mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tongo Yesuho wönggon dönac yocyocha ingoroc yogoc, “Son Kopotorocha dönac inongo kiriuya Kopotorocho son kombing kamontac. O son ‘yapmu ogepma ana fehun’ yongo yabi yabi youp tuyai wömai Kopotorocho tongfat keuna sonu wo au feantac. O son simbudec wagauyai, wömai Kopotorocho simbu fagarit kamontac. ");
INSERT INTO yuw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Boinno sinom, amna Kopotorocha dönac inongitacma yu worochon boinno sogiantac. O amna yabi yabi youp tongitacma yu yapmu wo aun feantac. O amna simbudec wagaantacma, yu wömai Kopotorocho simbu fagarit imontac. ");
INSERT INTO yuw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Sonu tingting kombiang? Managumboc soni batucha ganunai wömai sondecma numaho sopthong imun? ");
INSERT INTO yuw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O ‘söng nampi’ yongga kanunai wömai numaho goröm wöntucmuno imun? Muno sinom, sonu ihoroc matongidang. ");
INSERT INTO yuw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Oro, son wontucmuno toctoc amnahong managumboc soniha wömai yapmu ogepma imongidang. Worocha wömai Nandöng soni momdec itacma yu owi amna yapmu auha dönac inontangma yuha boinno sinom kombing imongo yapmu ogepma imontac. ");
INSERT INTO yuw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Son muyu toroc kiap ‘nuc soniho non tong nimongitnung’ yongo kombingidangma, toroc kiap ihorocnogon wömai nuc soniha tong imongitnung. Sonu kiap ihorocno tontanganu wömai sonu Kopotorochon nongoru orin yong tuctuc matano wo ambarac sumbotbödeantang,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yesuho mata tepmo au ingoroc yogoc, “Son muyu simbu gogocno obugudec ongurit. Gorong onggong sahon simbuno woi furango, o sa woce onggongon uyap woi moröma itac. Tongo owi amna koböcho uyap worocdec ongidang. ");
INSERT INTO yuw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Wohong itonggong sadec onggongon simbu, woi gogocno obugu itac. Worocha tongga owi amna tungu tunguhogon uyap wo angmuya ongidang,” Yesu yu itonggong sadec onggonga ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesuho mata sakaun fiuna ingoroc yogoc, “Son soni woho, son profet imanangniha yacyacho idarut. Godiboha wömai yu bot sipsip simbang ogepmagon yaantaroc mahong irotnon woi sap dunggit simbang amna dou moin toctochon toroc wontucmuno sinom ididang. ");
INSERT INTO yuw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sontho yuhon youpnohon boinno yangmuya soworengga forono tuctugo kombiantang, yu woi profet imanangni. Tingting oro? Amnaho yi dirongonidec ongga yi koburo ibibo fogiuntha? O yu kökec ibibo wömai ep dirongonidecma bariuntha? Woi muno sinom. ");
INSERT INTO yuw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","O ihorocgon ep ogepma ambarac yu boinno ogepmagon fingidang. O ep wontucmuno yu boinno wontucmunogon fingidang. ");
INSERT INTO yuw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ep ogepmaho wömai boinno wontucmuno mafiic, o ep wontucmunoho wömai boinno ogepma mafiic. ");
INSERT INTO yuw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Oro ep auho boinno ogepma mafiantacanu wömai amnaho woroc faingyu muuya epho fongyu dingidang. ");
INSERT INTO yuw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Worochon toroc wömai sonu profet amnahon boinno yangsoworengitnung. Tongo sonu yuhon foro ogepmahu o wontucmunohu wo tuctugo kombiantang.” Yesuho imanang profetha yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Tongo mit yu wönggon ingoroc yogoc, “Son ingoroc kombininga: Owi amna noc ‘Moröma Moröma’ nanongidangma, yu woi ambarac midim sabarac sadec ongonahing yo. Muno sinom, owi amna Nandöngna momdec itacma yuhon irot kombic kombic sindantho itongidangma yuhogon wömai woce ongonahing. ");
INSERT INTO yuw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kombiarut, mata youpdec idit bongono wocin wömai owi amna koböcmaho ingoroc nanonahing, ‘Moröma, nontho gakain maya yongo yong tuctuc youp tongidomon. O gakain maya yongo non owi amnadecma dogu boyömo dong yanidomon. O ihorocgon gochon madecgon toroc kiap gesöbarac koböc tongidomon.’ ");
INSERT INTO yuw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yu ihoroc nanonahing mahong nocho yu mata urago ingoroc inangot, ‘Noc son makombing kamoya sonu youp soni tongidung. Son wontucmuno toctoc amna, ohongo ongurit.’” Yesu yu inoin madec youp toctochon yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesuho mata sakaun fiuna ingoroc yogoc, “Amna auho nochon mata ngo kombingga sindan tongontacma, yu woi böc toctoc amna kombic kombicno ogepma woroc simbang. Yu wömai böc orungo sopdec tong koing togoc. ");
INSERT INTO yuw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ihoroc tuna komöc sum yamuc öngkorop morö tongga, böc wo ‘körengma muhun’ yongo köregoc mahong böc woi maköndet mögoc. Muno, böc worochon orungo guroc ganang omoce sinom ohongga sopdec gango tongkoing toctocyi idungmaha tongga maköndet mögoc. ");
INSERT INTO yuw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Worochoi oro, amna au yu nochon mata ngo kombingga fodingmun ongontacma yui amna bumbumyi sinom. Yu böcno sonorocdec togoc. ");
INSERT INTO yuw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tuna komöc sum yamuc öngkorop tongo böc wo korengmun onguna iban mögoc.” ");
INSERT INTO yuw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yesu yu sa urongdec itmuna mata moröma wo yongbödeuna owi amnaho kombigungmai Yesuho mata gesö orin forobarac yong fandadoc. Tuna yu nanga fatfat moröma togung. Nongoru gendic fandat fandat amna yu wömai mata ihoroc mayongidung. ");
INSERT INTO yuw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Oro, Yesu yu sa urongo wo imun fauna ohuna owi amna koböcma sinompho yu tan tonggung. ");
INSERT INTO yuw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tan tongmuya amna au obukoc lepra toctocyi yu Yesuot engga goruc yemoc tong imongo inogoc, “Moröma, gocho kombia angit idinai goc ogep noc ti orokuna noc Kopotorocho yangamin sacsago em.” ");
INSERT INTO yuw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ihoroc yuna Yesuho oburo yudec wot möngga yogoc, “Öc, noc kombihat, goc orokoti.” Ihoroc inuna wohogon amna worochon obukocno bödegoc. ");
INSERT INTO yuw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tuna Yesuho mata koingo inongo yogoc, “Gocho yapmu ngo gocdec öngkucma worochon fatno amna au inirocha. Goc komong ongga godiba öret socsoc amna indahi. Tongo Möseho nongoru sigocma worochon toroc öreta tiruc. Ihoroc tia owi amnaho gangmuya kombiantang, boinno sinom obukoca bödeuna gocu Kopotorocho yangamin sacsago öngkungga itaroc,” Yesu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tongo mit Yesu yu Kaperneam böcsa onggoc. Woce ongga idina amihon ofisa au tawa amnani 100 yangtorengidocma yu ‘Yesuho tongfat nehun’ yongo Yesuot ongga ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Moröma, nochon youp wabkarac yu orung oburo koing suya focfoc morö kombingmuna bucin bakatgon iditac.” ");
INSERT INTO yuw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ihoroc inuna Yesuho inogoc, “Oro nocho ongmaina yu ta orokontac.” ");
INSERT INTO yuw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ihoroc inuna ofisaho mata wo kombiuna angit maidina mata ökene ingoroc iban imogoc, “Moröma, noc amna ogepma muno, worocha goc nocho bucin ebepa woi angit maehim. Gocu ngocingon itmina mata yia youp wabkaracna orokotun. ");
INSERT INTO yuw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kombihi, nocu wömai amna moröma auho unenne itmaina yuhon mata sumboditat. O tawa amna 100 yu nochon unenne itmuya nochon mata sumbodidang. Nocho amna au ‘goc ongoi’ inoya wömai yuho ongontac. O nocho auma ‘goc epi’ inoya wömai yu ehantac. O nocho youp wabkaracna ‘youp woroc toi’ inoya wömai yu youp wo tontac.” ");
INSERT INTO yuw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ofisaho mata ihoroc inuna Yesuho wo kombingga nanga fatfat tongmuna owi amna ambehecgon idungma inogoc, “Mayain, nocho boinno sinom kantiwa, Israel nano sontho bonip sonidecma wömai nocho amna tungu au kombing tobic tobicno moröma ihorocno idimpacno magot. ");
INSERT INTO yuw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Worocha nocho ingoroc kantiwa: Sa guroc danongdecma owi amna koböcmaho engmuya Abraham, Aisak, Jeköp yuot midim sabarac sadec itmuya tong sonoc morödec inoin inoin abamo sogitmuya nacno nanahing. ");
INSERT INTO yuw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Wohong owi amna osuchagon midim sabarac sahon fat fingdetdetyima yu wömai Kopotorocho dong yaruna ongga sa kumbongnodec ida yong ointongo maro siu tomuya itnahing.” ");
INSERT INTO yuw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesuho ihoroc yongbödengga ibanda ofisa inogoc, “Goc ongoi. Gocho ‘ihoroc öngkupun’ yongo kombing tobiharocma worochon toroc sinom öngkuantac,” ihoroc yuna bongono wocingon sinom wömai ofisahon youp wabkaracno orokongga ogep idoc. ");
INSERT INTO yuw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Oro Yesu yu Pitaho bucin öngga agocmai Pitahon körano godip mönmön toup tongmuna abamodec bakatgon idoc. ");
INSERT INTO yuw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ihoroc idina Yesuho owi worochon oburo sogiuna wohogon obukocno bödegoc. Bödeuna yu idongga Yesu mongorec tong imogoc. ");
INSERT INTO yuw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Oro dobocsisia owi amnaho nucni dogu wontucmunoho fogit fogityima koböcma yangada Yesuot febung. Yangat feuya Yesuho mata gesöbarac inuna dogu wontucmunoho owi amna you fauya onggung. Tongo owi amna obukocnima ambarac youn orokogung. ");
INSERT INTO yuw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yesuho toroc kiap ihorocno togocmaha tongga Kopotorocho yong tuctuc amna Aisaiahon ducdec mata yogocma worocho boinno öngkuboc. Aisaia yu mata ingoroc yogoc, ‘Yui obukoc noni doun bödegung. O yu focfoc noni sumboda youn orokogomon.’ ");
INSERT INTO yuw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Oro Yesu yu foringga yagocmai owi amna koböcma sinompho yuot engmuya angarenggumbec tongga idung. Tuya Yesuho youp amnani inogoc, “Non yamuc öngkoring gino ökene ongona.” ");
INSERT INTO yuw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yu abe mangi idiya nongoru gendic fandat fandat amna auho Yesuot engmuna ingoroc inogoc, “Fandat fandat amna, goc sa nahenne ongontarocma, nocu gakagon gan tongungot.” ");
INSERT INTO yuw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ihoroc inuna Yesuho inogoc, “Arap yu yingonoha kombingidang o yup yu ihorocgon yingono idimang mahong Amnahon Manano yuhon dupdup abam maec.” ");
INSERT INTO yuw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ihoroc yuna wönggon inoin youp amna auho engmuna ingoroc inogoc, “Moröma, noc ongga nandöngna oring singdengga mit wömai nocho engmaina goc gan tongungot.” ");
INSERT INTO yuw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ihoroc inuna Yesuho inogoc, “Goc nakagon nantepi. Amna omimaho wömai nucni omima wo oring fiarut,” Yesu yu ino tan tonggonga mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Oro mit Yesuot youp amnaniot yu ongga girang obugudec bangmu uuna yamuc bonipnodec onggung. ");
INSERT INTO yuw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Woce ongidiya wohogon sum morömaho forosingga toup busuna yamuc funfuro moröma sinom öngmuna girang wo taun wetwetha togoc. Tuna Yesu yu dungo idoc. ");
INSERT INTO yuw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Dungga idina youp amnaniho Yesu tu wekuna inogung, “Moröma, non urop yamuc tumoc ohonggonga tamon. Worocha gocho tongfat neya batip itna.” ");
INSERT INTO yuw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ihoroc inuya Yesuho inogoc, “Kombing tobic tobic soni obugu sinom. Son yaha botodang oro?” Ihoroc inongga idongga sum orin yamuc funfuro inong fauna yamuc nongnong yuna o sum ihorocgon imun fadoc. ");
INSERT INTO yuw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tuna youp amnani woroc angmuya nanga fatfat tongga yogung, “Mayain, amna ngoi numa sinom. Sum orin yamuc funfuro yu yuhon mata kombingo nongnong yamoroc!” Ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Oro Yesu yu Galili yamuc öngkoring gino ökene ongga Gerasa nanoho gurocin woce idina amna yai dogu boyömpho fogit fogityima yu engmunya Yesu aun fedoc. Yu woi amna dong moin toctoc amna dunggit sinom. Yu amna fiiyan kumkumon sa woce itongidomoroc. Worocha tongga owi amnaho woce onggonga botongga uyap worochon mangidung. ");
INSERT INTO yuw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Oro yu Yesu aun feuna orongi sinom mamboda yogomoroc, “Ayöö, Kopotorochon Manano, gocu tingting sinom tong nimoc nimocha kombiharoc? Kopotorocho non dongyun moin toctochon bongono sigocma wo abe maehac mahong gocho urop non focfoc nimongo tong samborec toctocha eparochu yo!” Ihoroc mamboda inogomoroc. ");
INSERT INTO yuw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Oro bongono wocin wömai bot torop morömaho korungon bum itmuya nacano nongo idung. ");
INSERT INTO yuw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tuna dogu boyömpho Yesu dönac ingoroc inogung, “Goc non ninminai ningbanaya botho irodintong ohona.” ");
INSERT INTO yuw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Inuya Yesuho inogoc, “Son woce ohurit!” Inuna dogu boyömpho amna you fauho ongga botho irotnon ohongo bot ambaracho bumbum yongmuya domdomgon sa bohöngnon ohongga yamuc öngkoring ganang ohongmuya omong fatbödegung. ");
INSERT INTO yuw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ihoroc tuya amna bot wo yangtorengidungma yu yapmu woroc angbotongga domdomgon böcnon ongmuya bot ambarac omongbödegungma orin kiapmo amna yai yudec öngkubocma worochon fatno owi amna inongdup togung. ");
INSERT INTO yuw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Inuya böcsa worochon owi amna ambaracho Yesu ot ongga ‘guroc noni imi fahun’ yongo angfirigung. ");
INSERT INTO yuw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Oro Yesu yu girang obugu audec bangmun uuna yamuc öngkoring gino ökene ino böcsanon woce onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tuna amna auho nucno orung oburo möng toctocyi yu abam yorocdec sumboda Yesuot tebung. Tehuya Yesuho yagocmai, yu kombing tobic tobicnobaracho ebung. Woroc angmuna yu amna möng toctocyi inogoc, “Nakain manana, goc irot ogep kombihi. Gochon turongoya urop bödeang.” ");
INSERT INTO yuw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yesu yu ihoroc inuna nongoru gendic fandat fandat amna auho mata wo kombingga inohogon inun ganun tongga yogung, “Amna ngorocho Kopotorocha yong samborec yac yo.” ");
INSERT INTO yuw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ihoroc yongo idiya Yesuho yuhon irot kombic kombicno kombingdengmuna inogoc, “Son foro yaha irot sonin nocha wontucmuno kombiang? ");
INSERT INTO yuw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nocu amna ngo yaö matahong inoya sonthon kombic kombicdec angit in? Mata ingorochu: Noc gochon turongo dongya fat gamang. O ingo yontatma wömai ogephu: Goc idongga ongoi. ");
INSERT INTO yuw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kombiarut, Amnahon Manano yu guroc ngocin idina Kopotorocho yu boinno sinom turongo dongyun fatfathon gesö imogoc.” Yesu ihoroc inogoc. Tongo mit yu amna obukocnima inogoc, “Goc idongga abam yoroca sogida böcan ongoi.” ");
INSERT INTO yuw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ihoroc inuna wohogon amna worocho itongo böcnon onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tuna owi amna yapmu fodibo wo angmuya nanga fatfat tongga Kopotoroc yong moröng imongo yogung, ‘Kopotorocho gesöno moröma sinom amnahon oburodec sing imogoc,’ ihoroc yong tonggung. ");
INSERT INTO yuw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Oro Yesu yu sa wo imun fauna ongga agocmai, amna au mano Matyu yui takis möneng fogit fogit bucin omoc idoc. Tuna Yesuho inogoc, “Goc engga noc nari.” Inuna Matyu yu wohogon idongga Yesu tan tonggoc. ");
INSERT INTO yuw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tuna Yesu yu ongga Matyuho bucin nacno nongo idoc. Woce idina takis fogit fogit amna orin wontucmuno toctoc amna koböcho engmuya Yesuot youp amnaniot nacno kondonggon nagung. ");
INSERT INTO yuw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Yu nacno nongga idiya Farisiho woroc yangga Yesuhon youp amnani ingoroc inong yac togung, “Fandat fandat amna soni yu foro yaha sinom takis fogit fogit amna orin wontucmuno toctoc amna yuot idina nacno kondong naang?” ");
INSERT INTO yuw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Farisiho ihoroc yuya Yesuho mata woroc kombingga yogoc, “Amna obukocno muno yu ‘Doktaho tongfat nehun’ yongo makombingidang. Muno, obukocnimahogon wömai Doktaha kombingidang. ");
INSERT INTO yuw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Sonu ongga mata Kopotorochon bapiyadec itacma wo angmuya kombic kombic sogiarut. Kopotorocho ingoroc yogoc: ‘Sonu öret socsoc youp moröma tongidang mahong nocu worocha makombit. Muno, nocho ‘son nucsoni toroc kiap ogepma tongimarut’ yongo kombihat.’” Yesuho wönggon yogoc, “Nocho amna ‘nongnongo’ inong yocyocha maebot. Muno, nocho ‘wontucmuno toctoc owi amna inong yowa’ yongo ebot. Yu wömai nochon mambocna kombingga turongono yangmuya irotno ibaruya nocot engidang,” Yesuho Farisi mata ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Oro mit Jönthon youp amnaniho engmuya Yesu inong ac tongga yogung, “Nonot Farisiot non nacnoha gendic singga manongidamon. Wohong gochon youp amnayai yu ihoroc matongidang.” ");
INSERT INTO yuw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ihoroc yuya Yesuho mata tepmo au ingoroc iban imogoc, “Amna auho owi somonni mino song imocimocha tuna numa amnaho yong oin tongga muno yun? Muno, non ihoroc matongidamon. Owi min toctoc bongonodec wömai non muyu irot ogep kombingga nacno nana. Wohong bongono au urop ehangoc. Bongono wocin wömai amna minno togocma yu sa korungon idina tong sonoc toctocno maic. Tuna bongono wocin wömai yu uroci kombingmuya nacnoha gendic singga manai itnahing.” ");
INSERT INTO yuw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Oro Yesu mata tepmo au ingoroc yogoc, “Amna au yu tec tohomunmöcno osucno dogiantac. Tuna yu tec docno wego sogida tec osucno bubupno mabuun. Muno yu ihoroc tontacanu wömai tec wegomaho tec osucno wodiuna dogitbödeantac. ");
INSERT INTO yuw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","O ihorocgon wain yamuc tobic tobic amna yu bot meme godibo osucnodec wain yamuc wego makoringidang. Ihoroc tuyai wömai wain yamuc wegoho ohongga out tuuna bot meme godibo osucno fuc tontac. Tuna wain yamuchu o bot meme godibo wo yait yait tong samborec tontamoroc. Worocha wömai yu wain yamuc wego bot meme godibo wegodecgon koringidang. Ihoroc tuya yait yait ogep entamoroc.” Yesu mata tepmo ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu yu Jönthon youp amnaniot mata worocgon yongo idiya amna dugo au Yesuot engmuna orungo forodec goruc yemoc tongga inogoc, “Nochon wena öngahemgon omong fahac mahong gocho ongga obura yudec wotmuya yu wekotun.” ");
INSERT INTO yuw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ihoroc inuna Yesuot youp amnaniot yu idongga amna dugo ot onggung. ");
INSERT INTO yuw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tongo uyapdec ongidiya owi au yu woce idoc. Yu wömai nogotnoho wuna idina biruc 12 ihoroc bödegoc. Owi wo yu Yesuhon menon engmuna oburoho Yesuhon tec tohomunmöcno worochon mondopmo wot mögoc. ");
INSERT INTO yuw_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Yu wömai ingoroc kombingga togoc, ‘noc obunaho tec tohomunmöcnodec wot mönggai orokontat,’ ihoroc kombigoc. ");
INSERT INTO yuw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tuna Yesuho ibarun fauna owi wo angga inogoc, “Wena, irot guc kombihi! Goc noc kombing tobing namparocmaha tongga orokotaroc,” ihoroc inuna owi wo yu wohogon orokogoc. ");
INSERT INTO yuw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tuna Yesu yu ongga amna dugoho bucin öngo yagocmai, owi amna koböcma woce itmuya auho yong oin tong idiya o amna auho koding busongo kekoröpno toup togung. ");
INSERT INTO yuw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ihoroc tuya Yesuho yu inogoc, “Son ohongo ongurit, owi obugu wo yu mamec, yu komong dungo itac.” Yesuho ihoroc inuna owi amnaho mata wo kombingga angyonggudung. ");
INSERT INTO yuw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tuya Yesu yu dong yaruya ongidiya böc ganang öngga owi obugu worochon oburo sogiuna yu wohogon wekogoc. ");
INSERT INTO yuw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Oro Yesuho youp ngo togocma worochon fantoho böcsa danong ongbödeuna owi amna ambaracho kombingbödegung. ");
INSERT INTO yuw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu yu böc wo imun fauna ino bucin onggonga uyapdec ongidina amna yai daro kom toctocyi yu Yesu tan tongmunya ingoroc mambodomoroc, “Devithon Manano, goc ning banango notha uroci kombihi.” ");
INSERT INTO yuw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ihoroc yunya Yesu yu böc ganang öngga idina amna yai yu ihorocgon öngga Yesuot ehunya Yesuho ingoroc inong yac togoc, “Sodu tingting kombiamoroc? Nocho sot ogep dongya orokotaruntha woha muno?” Ihoroc inuna yaimaho yogomoroc, “Öc Moröma, not kombing tobiamot, goc ogep.” ");
INSERT INTO yuw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ihoroc inunya Yesuho oburoho amna yaimahon darodec fingmuna ingoroc inogoc, “Sodu kombing tobingidamorocmahon torocgon öngkung kampun.” ");
INSERT INTO yuw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ihoroc inuna wohogon daro forigomoroc. Tunya Yesuho koingo sinom ingoroc inogoc, “Sodu fat ngo amna au inodimorocha, muno sinom.” ");
INSERT INTO yuw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yesu yu ihoroc inogoc mahong amna yaima yu ongmunya fat wo yong morogic tunya böcsa danong ongbödegoc. ");
INSERT INTO yuw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Oro amna yaima yu Yesu imun fauna ongga idinya amna auho nucno dogu boyömpho sogit sogityi duc matano muno woroc Yesuot yangada tebung. ");
INSERT INTO yuw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tuya Yesuho dogu boyömo wo dong yaruna onguna, amna duc matano muno yu wönggon duc matano yogoc. Tuna owi amnaho woroc angga nanga fatfat tongga yogung, “Israel gurocin toroc kiap ingorocno osuc au maöngkuboc, non ngo fodibo sinom aamon.” ");
INSERT INTO yuw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Owi amnaho ihoroc yogung mahong Farisiho wömai yogung, “Yesuho dogu boyömo dong yanitacma woi dogu boyömphon morömanoho gesö imuna tac yöc,” Farisiho Yesuha mata metec ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Oro, Yesu yu böcsa obuguhu o taunthu woi ambarac itongdup togoc. Itongdup tongo yu Yuda nanohon fatmata yocyoc böc danong öngtongo momphon midim sabarac sahon fatmata ogepma owi amna fandat inong tonggoc. O ihorocgon owi amna obukoc foro ihono ihono tongidungma yu ambarac dongyun orokogung. ");
INSERT INTO yuw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bongono wocin wömai owi amna koböcma sinompho Yesuot idung. Tuya Yesuho yauya yu bot sipsip morömo muno ihoroc simbang ididung. Worocha tongga Yesuho yuha uroc imogoc. ");
INSERT INTO yuw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yong uroc yongo youp amnani ingoroc inogoc, “Öndec nacno koböcma sinom gomondingga idang mahong woroc tonong fepfephon youp amna koböcma maeng. ");
INSERT INTO yuw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Worocha son ön Morömoha dönac inuya yu youp amnani inongmuna engga nacno feng suran tontang,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tongo Yesu yu youp amnani 12 inong yuna ehuya, owi amna decma dogu boyömo dong yan yanthon gesö orin obukoc foro ihono ihono you orokoc orokochon gesö imogoc. ");
INSERT INTO yuw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yesuhon youp amnani 12 Aposel ma sogidungma worochon ma torop woi ingoroc: Saimon mano auma Pita, o orugo Andru, o Sebedihon mananin Jems orin Jön, ");
INSERT INTO yuw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","o Filip, o Bartolomyu, o Tomas, o Matyu yu takis fogit fogit amna, o Alfiushon manano Jems, o Tadius, ");
INSERT INTO yuw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","o Saimon yu wömai Selothon toropdecma, o Yudas Iskariot yu woi Yesu sogida ayamihon oburodec sigocma woroc. ");
INSERT INTO yuw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Oro Yesu yu youp amnani 12 woroc soworengo inong mutmuna youphon yong tuctuc mata ingoroc inogoc, “Son bumbumyi nano ot ongoninga. O ihorocgon Samaria nanohon böcsa audec ongoninga. ");
INSERT INTO yuw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Muno, son muyu Israel nano ot ongonung. Yui bot sipsip gorong ongima simbang. ");
INSERT INTO yuw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Son yuot ongmuya fatmata ingoroc yudec silip tong imongitnung: ‘Kopotorochon mom toborucno urop engfom tac.’ ");
INSERT INTO yuw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ihoroc inongmuya owi amna obukocnima you orokonung, o amna omomyima you wekonung, o obukoc lepra toctocyi yu you orokuya sacsago itnung, o owi amna dogu boyömpho fogit fogityi yu dong yan imonung. Nocho youp woroc toctochon gesö wöngnacno muno kampat. Worocha son ihorocgon owi amna wöngnacno muno tongfat yengitnung. ");
INSERT INTO yuw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Son golhu o silwahu o möneng gomono fongoninga. ");
INSERT INTO yuw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","O ihorocgon yoc moröma mendengga ongoninga. O tec fohongyumöc soni tungutnigon fogida ongurit. O orungtom sonihu o tut kandung sonihu wömai fogitninga. Muno, sonu Kopotorochon youp amnani idang, worocha tongga yu son ogepmagon kangtoreangoc. ");
INSERT INTO yuw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Oro son böcsa wocintu wocintu ongmuya son muyu böc moröm yu yangsoworengga amna ogepma nongnongo yuho bucingon öngo idtongonung. ");
INSERT INTO yuw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Oro sonu amna auho bucin öngmuya owi amna ingoroc inonung: ‘Kopotorochon irot guc sonot itun.’ ");
INSERT INTO yuw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ihoroc inuya böc morömpho son ogepgon kangtoreuyai wömai Kopotorocho yu irot gucno imangoc. Wohong böc morömpho sonthon mata makombiuyai wömai guram mata soni ibarun fauna wönggon soniot ehantac. ");
INSERT INTO yuw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Amna auho son ino bucin makangat fonguyai, orin sonthon fatmata makombiuyai wömai son böchu o taun woroc imu fauna orung sonidecma guroc tong fönfön wo fororop tongyu mönung. ");
INSERT INTO yuw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nocho boinno sinom kantiwa: Kopotorocho owi amna mata youpdec fohong yuangocan bongono wocin wömai böc worochon owi amnadec mepmo moröma sinom öngkuangoc. Mepmo Sodom orin Gomora nanodec öngkubocma woroc woi obugugon mahong yudec öngkuangocma woi moröma sinom.” ");
INSERT INTO yuw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesuho mata sakaun fiuna youp amnani aposel ma sogidungma ingoroc inogoc, “Nocho son kanongmuaya ongmuya bot sipsip sap dunggit ingingohon bonipnodec itongiima worochon toroc sonu itongitnahing. Worocha son goröm simbang arangarango sinom itongitnung. O ihorocgon son yup kanarömphon toroc irot gucot itongmuya amnahon irot dongyu mointoninga. ");
INSERT INTO yuw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Sonu amna wontucmunoha yacyacho itongitnung. Yu worocho wömai mata soni yu bödec bödecha son Yuda nanohon fatmata yocyoc bucin kangat fongga tosipdec kotnahing. ");
INSERT INTO yuw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","O ihorocgon sonu nochon ma sogidungmaha tongga yuho son Gavman morömo othu o kingothu woce kangat fongonahing. Tuya sonu nochon fatmata ogepma inong tauya Yuda nanohu o bumbumyi nanohu yu ambarac wo kombinahing. ");
INSERT INTO yuw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","“Worochoi oro, ayam soniho son mata youpdec kangat fonguyai wömai sontho ‘yaö mata urago iban imontamonthu o tingting sinom inontamonthu’ yongo kombingbanac toninga. Muno sinom, bongono wocin wömai Kopotorocho kombic kombic orogoma kamuna sontho mata urago angitgon iban imonahing. ");
INSERT INTO yuw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Son sonibut mata mayoning. Muno, Nandöng sonihon Kunkun Yaru worocho wömai duc soni tun yungan tuna sonu mata urago inonahing,” Yesu yu youp amnani yong fasun mata ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tongo yu wönggon mata sakaun fiuna ingoroc inogoc, “Kombiarut, mit wömai yan orugo itmunya aumaho orugo mata youpdec tohong yuna matano yu bödeuna wot omom tonahing. O fano yu wömai toroc kiap worocotmagon managumbocni tong imonahing. O managumboc yu macni faniha ecego kombingmuya ayamiho oburodec fiuya dohuya omnahing. ");
INSERT INTO yuw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","O sonu noc kombing tobing namongidangmaha tongga amna tobuno ayam ayam tong kamonahing. Wohong sondecma numariho koing songga itnahingma yu wömai Kopotorocho wontucmunodecma öcangmun muuya itonggong koing imangoc. ");
INSERT INTO yuw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Oro, son nochon youp toctocha böcsa auhon onguya böc morömpho son kang yangam tongo kamontanganu wömai son böcsa auhon ongonung. Nocho boinno sinom kantiwa. Son Israel böcsadec youp abe matongbödei idiya Amnahon Manano wönggon ehangoc. ");
INSERT INTO yuw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kombiarut, wabkaracho wömai fandat fandat amnano manggiradidang. O ihorocgon youp amnaho wömai morömano manggiradidang. ");
INSERT INTO yuw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Wabkarac yu fandat fandat amnanohon toroc entacma wömai angit in. O youp amnaho morömanohon toroc entacma wömai ihorocgon angit in. Oro owi amnaho amna morömaha dogu kopot Belsebul ihoroc inogung. Worocha tongga yu youp amnaniha tingting inonahing? Woi mata wontucmuno sinom inonahing. ");
INSERT INTO yuw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Wohong sonu amna ihorocnoha botoninga. Manomano tomnobarac itacma woi ambarac eran öngkungbödeangoc. O kombic kombic öpma woi Kopotorocho ambarac tun eran engoc. ");
INSERT INTO yuw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nocho son mata kumbong kantatma woroc sontho yagunodec yong tongonung. O mata onggim sonidecgon masang kanontangma woroc soniu böc taitdec suraro inong furang yong tonung. ");
INSERT INTO yuw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Sonu guroc amnaha botoninga. Yu ogep godip föp sonigon tong omom tup mahong yaru soni tu moin toctochon gesö wömai yu maidimoc. Worocha son amnaha botoninga, muno son muyu Kopotoroc yu tunguhagon botodarut. Yu ogep godip föbhu o yaru sonihu wo yait yait dongyun mointuya ep bohöng fongyun munahing. ");
INSERT INTO yuw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Kombiarut, non amna non yup obugu obuguha kombingidamon woi yapmu obugu sinom mahong Nandöng soni yu kombiuna angit maidinai wömai yup obugu tungu au mamic. ");
INSERT INTO yuw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","O sontha tingting, Kopotorocho sontha maedet imic, muno yu wömai bic sakemsoni ambarac embatho kombingbödehac. ");
INSERT INTO yuw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Worocha sonu botoninga, sontho woi yup obugu obugu wo yanggiraang,” Yesuho ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Oro Yesuho wönggon mata sakaun fiuna ingoroc yogoc, “Amna auho nochon ma owi amnadec yong taantacanu wömai nocho amna worochon mano Nandöngna momdec itacma yuho yangamin ihorocgon yong taantat. ");
INSERT INTO yuw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Wohong amna auho nocha yangam fap tongmuna möp yontacanu wömai nocho ihorocgon Nandöngna momdec itacma yuho yangamin amna woroc möp yong imontat.” ");
INSERT INTO yuw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yesuho yogoc, “Nocho ‘ayam ayam kiap ta bödehun’ yongo guroc ngocin maebot. O nocu irot tungu idit kiap temongma öc öcha maebot. Muno sinom, nocha tongga owi amna ayam ayam tonahing. ");
INSERT INTO yuw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nocho ebotmaha tongga ‘mananoho fanoha ayam tangoc, o wenoho macnoha ayam tangoc, o yan obigoho ficfuc tongga ayam idtahamoroc. ");
INSERT INTO yuw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","O amna auhon feno amna worocha ayam tong imonahing.’ ");
INSERT INTO yuw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Tongo amna au yu macnin fanintha toup kombiantac mahong nocha obmugon kombiantacanu wömai yu nochon amna maic. O ihorocgon amna auho weni mananiha toup kombiantac mahong nocha obmugon kombiantacanu wömai yu nochon amna maic. ");
INSERT INTO yuw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","O amna au yu guroc ngorochon focfoc kombingmuna ep goröcno sumbotmuna noc menan maehicma, yu woi ihorocgon nochon amna muno. ");
INSERT INTO yuw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","O amna au yu guroc ngorochon itonggong sogit akep tontacanu wömai yuhon itonggongno sinom momdec itacma wo gorong ongungoc. Wohong amna au yu ‘nocha’ yongo itonggongno guroc ngocin imun faantacanu wömai yu momdec itonggong koing aun feangoc,” Yesuho ino tantanthon yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yesu yu mata sakaun fiuna ingoroc yogoc, “Amna auho son böcnon kangat föngga tong ogep tong kamangocanu wömai yu nocha tong ogep tongnamangoc. Tuna nocho yuot engot. O nocu yuot engotanu wömai nakagon muno, Nandöngna nanöng muna ebotma yu ihorocgon amna worocot engoc. ");
INSERT INTO yuw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kombiarut, amna auho Kopotorochon yong tuctuc amna au böcnon yangat töngga wöngnacno muno komanang sinom tong ogep tong imontacanu wömai mit Kopotorocho amna wo irot ogep wöngnacno moröma imangoc. Woi Kopotorochon yong tuctuc amnaho irot ogep sogididangma worochon toroc imangoc. O ihorocgon amna auho amna nongnongo au yu böcnon yangat töngga komanang sinom tong ogep tong imontacanu wömai mit Kopotorocho amna wo irot ogep wöngnacno imangoc. Woi amna nongnongo irot ogep sogididangma worochon toroc imangoc. ");
INSERT INTO yuw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","O amna auho nochon youp amnani tong fat yecyecha yamuc sumo komong get imontacanu wömai amna worocho irot ogep wöngnacno boinno sinom sogiangoc,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Oro, Yesuho youp amnani 12 yong fasun mata ihorocno inongbödengga mit sa wo imun fauna Galili gurocin itongmuna böcsa woce idtonggungma woce owi amna fatmata ogepma fandat inong tonggoc. ");
INSERT INTO yuw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Oro bongono wocin wömai Jön yamuc gung imocimoc amna yu yi bucin idoc. Tongo yu Duicho manomano tongidocma worochon fatno kombigocmaha inoin youp wabkaracni au inong muuna yu Yesu inong ac toctocha onggung. ");
INSERT INTO yuw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ongga yu Yesu ingoroc inong ac togung, “Kopotorocho amna siuna ebepha mata godingmun fadocma amna wo woi gakaha yogoc woha nonu amna auha torengga itna?” ");
INSERT INTO yuw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yu ihoroc inuya Yesuho mata urago ingoroc iban imogoc, “Son wönggon ibaru fauna ongga manomano yaangma orin kombiangma worochon fatno Jön inarut. ");
INSERT INTO yuw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kombiarut, amna dan komnima yu wönggon dan foric tang. O amna orungo omong fatfatyi yu wönggon uyap itongidang. O amna obukoc lepra toctocyi yu orokodang. O amna onggim tong tongni yu wönggon mata kombiang. O amna omong fadungma yu wönggon wekongga itongeyang. O owi amna uroci yuho wömai fatmata ogepma kombingidang. ");
INSERT INTO yuw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tuna owi amna ambaracho nocha me ma-namingma yu borongdearut.” ");
INSERT INTO yuw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yesuho ihoroc inuna Jönthon youp wabkaracni imu fauna onggung. Ongga idiya Yesu yu forosingga owi amna Jöntha inong tuctuc tongo ingoroc yogoc, “Sonu ‘tingting sinom ana’ yongo sa amna maiyan woce Jönot onggung? Sonu sumpho fondom tongi tepi togocma ‘woroc ana’ yongo yuot onggunghu nuhun? ");
INSERT INTO yuw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Woha yaö acacha kombingo onggung? Amna au tec tohomunmucno ogepma sinom tobic tobicyi worochu? Muno, amna ihorocnomaho wömai kinghon böc moröma wocingon ididang. ");
INSERT INTO yuw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Worochoi oro sonu ‘yaö fodibo sinom ana’ yongo Jönot onggung? Kopotorochon yong tuctuc amna auhu? Boinno sinom, Jön yu yong tuctuc amna osuc idungma yu ambarac yanggirahac. ");
INSERT INTO yuw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Amna ngorocha sinom wömai mata ingoroc irim toctocyi itac: ‘Kopotorocho yac, nocho amna au siaya yu engmuna osuc fat gamongo owi amna nochon yongburoc mata inong tuctuc tangoc. Tongo yu gochon uyap tong arangarang tangoc.’ ");
INSERT INTO yuw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Nocho boinno sinom kantiwa, Jön yui amna moröma sinom, yu wömai guroc amna au ambarac yanggiratbödehac. Wohong mom midim sabarachon owi amna komanangno sinom yu wömai Jön anggiraang.” ");
INSERT INTO yuw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","“Oro, Kopotorochon yong tuctuc amnani orin nongoru mata yu wömai mom toboruchon mata yogung. Worocha tongga Jön yu owi amna yamuc gung imongidocan bongono wocin forosingga engga önga idamonan bongono worocho irotnon wömai owi amna mom toborudec onggonga youp morö gesöbarac tongidang. O amna koingo yu woce onggongon uyap angtorengidang. ");
INSERT INTO yuw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kopotorochon yong tuctuc amna yu wömai osucgon ‘Elaiya ehangoc’ ihoroc yogung, Worocha wömai sonthon kombic kombic sonidec angit idinai wömai woroc, Jön yu Elaiya. ");
INSERT INTO yuw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Amna kombic kombicbaracma yu wömai mata woroc kombiup.” ");
INSERT INTO yuw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Oro, nocho owi amna önga idangma yuhon foroha mata tepmo tingting sinom singo yowa? Wömai ingoroc, yu wabkarac maket taitdec ididangma woroc simbang. Wabkarac wo yu ingoroc mamboda yogung, ");
INSERT INTO yuw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Non koding busogomon mahong sonu kömec matogung. O non yong uroc ap yogomon mahong sonu maointogung.’ ");
INSERT INTO yuw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Mata tepmo worochon foro wömai ingoroc: Jön yu engmuna nacno gucsim omong omong orin yamuc sinom worocgon nongidina owi amnaho yu angmuya yongidang, ‘Dogu wontucmuno au yudec itacmaha ihoroc tac yo!’ ");
INSERT INTO yuw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","O önga wömai Amnahon Manano yu engmuna nacno ogepma orin wain yamuc nongidina owi amnaho yu angga yongidang, ‘Yui amna nongmenni, yu wain yamuc nongga bumbum yongitac. O yu takis fogit fogit amna orin wontucmuno toctoc amna yuot oröc oröc tongitac.’ Owi amna ihoroc yongidang mahong yuhon matano woi kandöc sinom. Kombiarut, owi amna Kopotorochon kombic kombic ogepma sumbodidangma yu wömai Kopotorocho inoin uyap ogepma tong indauna tuctugo kombiantang.” ");
INSERT INTO yuw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Oro, Yesu yu böcsa audec itmuna toroc kiap inobarac sinom koböcma tongidoc mahong owi amna wocin idungma yu irotno maibanidung. Worocha tongga Yesuho böcsa worochon garac mata ingoroc yogoc, ");
INSERT INTO yuw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Son Korazin orin Betsaida nano son soni woho! Nocho toroc kiap inobarac koböcma sinom sonthon bonip sonidec tongidot mahong sontho irot soni maibandung. Wohong nocho toroc kiap sonot togotma wömai böcsa Tairhu o Saidonthu wocin toyai wömai worochon owi amna yu inoin turongo yangga uroci morö sinom kombingga yong oin tongga ep ipmorop wagangga irotno ibandup tup. ");
INSERT INTO yuw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Worocha tongga Kopotorocho owi amna mata youpdec fohong yuangocan bongono wocin wömai sontho urago mepmo sinom au feangoc mahong Tair orin Saidon nano yu mepmo obmugon sogitnahing. ");
INSERT INTO yuw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“O son Kaperneam nano, son tingting kombiang? Son onoce sinom itmuya ma moröma sogitnahinghu? Muno sinom, son wömai omoce sinom omimaho ididangan woce ohonahing. Nocho toroc kiap moröma sonot tongidotma woroc Sodom böcsa woce toyai wömai Sodom nano wo angga irotno ibaruya böcsano maobökun. Muno woi ogepgon idtongga ongga önga in. ");
INSERT INTO yuw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Worocha wömai nocho ingoroc kantiwa: Kopotorocho owi amna mata youpdec fohong yuangocan bongono wocin wömai sontho urago inobarac sinom au feangoc mahong Sodom nano yu mepmo obugugon sogitnahing.” ");
INSERT INTO yuw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Oro bongono wocingon wömai Yesuho Fano ingoroc inogoc, “Nandöngna, goc mom orin guroc ngorochon Morömo. Gocu gakain ibiba orin kombic kombic ogepma worocgon tanda mom toboruchon foro youp amnayai komanangnoma wo indaya tuctugo kombiang. Yu woi managumboc simbang kombic kombicno moröma muno. Worochoi oro, kombic kombic amna moröma yuho gochon foro makombiing. Gocho yuhon daro dongyi sum fauya mom toboruchon foro kombing tangtang mating. ");
INSERT INTO yuw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nandöngna boinno sinom, kiap ihorocnoho woi gochon irot kombic kombic ogepma.” Yesuho yong moröng ihoroc Fano inogoc. ");
INSERT INTO yuw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tongo yu wönggon yogoc, “Nandöngnaho guroc ngorochon gesöno ambarac ‘nocho wo moröm tong impiwa’ yongo noc namogoc. O amna auho inoin kombic kombicdec wömai Mananohon foro makombiing. Muno, Nandöng yu tunguhogon wömai kombihac. O ihorocgon amna auho Nandönghon foro makombiing. Muno, Manano yu tunguhogon wömai Nandönghon foro kombihac. O Mananoho amna yangsoworengga yuho yangamin ogep ima yuha wömai yu Kopotorochon foro ihorocgon tuctugo indaangoc. ");
INSERT INTO yuw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Son owi amna mepmo sumboda gapgap yongidangma son ambarac nocot ehuya nocho tongfat kengga tong yungan tong kamontat. ");
INSERT INTO yuw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Noc irotna ohonggongyi orin irot gucnabarac iditat. Worocha son ehuya nocho kötacna singkamoya forona kombingitnung. Tongo sontho nochon toroc kiapgon tanda nocot youphon mepmo kondonggon sumbotna. Ihoroc tongo irot soni gucno engoc. ");
INSERT INTO yuw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nonu youphon mepmo kondonggon sumbentamonanu wömai youp angitgon tongitnaha-mon. O youphon mepmono yungan tangoc,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Oro, bongono wocin Sabat bongonodec Yesuot youp amnaniot yu wit öndec itonggung. Itongmuya youp amnani worec imuya yu wit yitno au fogito nong tonggung. ");
INSERT INTO yuw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ihoroc tongo idiya Farisi amna auho wo yangga Yesu inogung, “Yahi, youp amnayai yu gendic mata noni yembodang. Sabat bongonodec wömai ihoroc toctocha bongbong morö itac.” ");
INSERT INTO yuw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ihoroc yuya Yesuho mata ökene ingoroc iban imogoc, “Sonu Devitho osuc kiap togocma worochon fatno embatho makombingidanghu nuhun? Devithon toropniho o ino yu nacnoha worec imogung. ");
INSERT INTO yuw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Worec imuya Devit yu Kopotorochon sel böc ganang ongmuna nacno sowarango Kopotorochon fatha fong figungma woroc fogito feuna toropniot nagung. Nacno sowarango worocho wömai amna komanangnoho nocnocno muno, öret socsoc amnahogon nongidung. ");
INSERT INTO yuw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“O ihorocgon öret socsoc amna yu Sabat bongonodec youp toctocha öret socsoc bucin ongidang. Worocha tongga yu Sabathon nongoru gumanidang. Worochoi oro, yudecu tong bumbum au maec. Sonu nongoru mata embada aarut. ");
INSERT INTO yuw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Nocho boinno sinom kantiwa, amna ngo itacma yui moröma sinom, yu öret socsoc böc anggirahac. ");
INSERT INTO yuw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kopotorochon bapiyadec mata ingoroc itac: ‘Noc nip oröc yang banac banachon toroc kiapha toup kombihat mahong son öret socsoc youp komanang tong-idangma wo noc kombiaya angit maec.’ Mata ihoroc itac mahong sontho worochon foro makombing. Worocha son amna ogepmaha möpmo wagang imongidang. ");
INSERT INTO yuw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kombiarut, Amnahon Manano yu Sabat bongonohon Morömo,” Yesu yu Sabathon gendicha mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu yu sa wo imun fauna Yuda nanohon fatmata yocyoc bucin ögoc. ");
INSERT INTO yuw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Uuna amna au oburo omong fatfatyi yu wocin idoc. Oro amna au yu Yesu mataha firing tantantha uyap dabigung. Worocha yu Yesu ingoroc inong ac togung, “Sabat bongonodec amna obukocni dongyu orokoc orokocno woi nongoru mataho yac angitha woha angit maec? ");
INSERT INTO yuw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ihoroc yuya Yesuho mata ingoroc inogoc, “Sonotma amna auhon bot sipsipnoho Sabat bongonodec ongga gopmain muantacmai wömai numa amnaho matongfat yeic? Muno, non ambarac wömai tongfat yengidamon. ");
INSERT INTO yuw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Oro amnaho wömai bot sipsip yanggiratno sinom tang. Worocha tongga non ogep Sabat bongonodec amna tong ogep tong imontamon. Nongoruho worocha ‘muno’ mayoc.” ");
INSERT INTO yuw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yesu ihoroc yongga amna oburo omong fatfatyi inogoc, “Goc obura tong nongnong toi.” Inuna amna wo oburo tong nongnong tuna wohogon oburo orokongdup togoc. Oburo okema idocma worochon toroc. ");
INSERT INTO yuw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ihoroc tuna angga Farisi yu böc wo imu faunto inobarac suran tongmuya Yesu wotwothon matano yogung. ");
INSERT INTO yuw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Oro Farisiho Yesu wot omom toctochon matano yuya Yesu yu wo kombingmuna böcsa wo imun fauna onggoc. Onguna owi amna koböcho Yesu tan tonguya Yesuho owi amna obukocnima ambarac youn orokogung. ");
INSERT INTO yuw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tongo Yesu yu owi amna inoin foro yong taptapha ‘muno sinom’ inogoc. ");
INSERT INTO yuw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Oro Kopotorochon yong tuctuc amna Aisaia yu osucgon ‘Yesuho toroc kiap ihoroc tangoc’ yongo yong tuctuc mata yogoc. Tuna mata worocho boinno ongkuboc. Aisaiaho ingoroc yogoc: ");
INSERT INTO yuw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kopotorocho yac, ngoi nakain youp amna, nakabut yu ‘youpha’ soworegot. Noc yuha toup sinom kombingitat. O irotnaho yuha yong kumengitat. Nocho Kunkun Yaruna yudec siaya yuho toroc kiap nongnongo gurocdec temongmun uuna owi amna ambarac nongnongogon yangtoreangoc. ");
INSERT INTO yuw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tongo yu kararat yongo mataha emoc matic. O ihoroc-gon owi amna surandec wömai yuhon mata maöngkuic. ");
INSERT INTO yuw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Fondom yorong mucmucyi wömai yu kondong tongo ma-fongyun ongoning. O gop yaguno omoc omocha tacma wömai yu matun omic. Yu inoin youpnogon tongga idina ongga nongnongo kiapho koing sangoc. ");
INSERT INTO yuw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Guroc owi amna ambaracho ‘yuho tongfat nehun’ yongo yuhon torec itnahing.” ");
INSERT INTO yuw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Oro mit amna auho nucno dogu boyömoni yu Yesuot yangat tebung. Dogu boyömpho tuna amna worocho obukongga daro kom toctocyi orin o duc matano mayocyoc ihoroc idoc. Tuna Yesuho yu tun orokuna wönggon daro foringo duc mata yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ihoroc tuna owi amnaho woroc angga nangano fauna yogung, “Amna ngoi Devithon Mananohu?” ");
INSERT INTO yuw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ihoroc yuya Farisiho mata woroc kombiuya angit maidina yogung, “Amna wo yu dogu boyömohon morömo mano Belsebul, yuhon gesö sogitmuna dogu wontucmuno dong yanitac yo.” ");
INSERT INTO yuw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ihoroc yuya Yesuho Farisihon irot kombic kombicnohon foro angtangtang tongo yu ingoroc inogoc, “Kantri auho ficfuc tongo owi amna inohogon emoc tonggai wömai kantri worocho obukontac. O ihorocgon böcsa auhonthu o taun auhonthu yu ficfuc tongo inoha emoc tontanganu wömai yuhon gesöno ohongga makoing sic. ");
INSERT INTO yuw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Oro worochon torocgon wömai dogu kopothon toropni yu fuc tongga inoin nucni taruyai wömai yuhon gesöno ohongga koing socsocno main. ");
INSERT INTO yuw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Worochai oro Belsebulho noc gesö namuna nocho dogu wontucmuno dong yarantatanu wömai numaho torop soni tong fat keuna dogu wontucmuno dong yanidang? Kombiarut, torop soni yu inobut wömai mata soni soworengga yu bödeangoc. ");
INSERT INTO yuw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Wohong nocu wömai Kopotorochon Kunkun Yaruhon gesödec dogu boyömo dong yanitat. Sonu woroc angmuya ingoroc kombiup, Kopotorochon mom toborucnoho urop soniot epac yo.” ");
INSERT INTO yuw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yesuho mata wo yongbödengga mit mata tepmo au ingoroc yogoc, “Oro amna au yu ogep amna koingoho bucin öngmuna worochon manomanono usem fogito fonguntha woha muno? Muno sinom, osuc wömai yu amna koingo yidec feto singdengga mit wömai yu ogep yuhon manomanono usem fongontac. ");
INSERT INTO yuw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Amnaho noc oröc matong namontacma yu ayam tong namontac. O amna auho suraro feng suran toctochon youpha noc matongfat neicma yu wömai suraro doun mointuya fuc tontang. ");
INSERT INTO yuw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Worocha wömai nocho kanoya kombiarut. Owi amnaho wontucmuno tontangmahu o Kopotorocha yong samborec yontangmahu worochon turongo ambarac Kopotorocho owi amna youn fat imangoc. Wohong amna auho Kunkun Yaruha yong saha yontacma worochon turongo wömai Kopotorocho maimun fat imic. Muno turongo worocho wömai tohong singimuna idtongungoc. ");
INSERT INTO yuw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Amna au yu Amnahon Mananoha mata metec yontacma worochon turongo wömai bödeangoc mahong amna auho Kunkun Yaruha yong samborec yontacma worochon turongo wömai öngahu o mithu iditnoho iditno yudec engoc.” ");
INSERT INTO yuw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesuho wönggon ingoroc yogoc, “Ep ogepma yu boinno ogepmagon fingidang. O ep wontucmuno wömai boinno wontuc-munogon fingidang. Nonu ephon boinno yaantamonanu wömai tuctugo kombingidamon, woi ep ogepmahu o ep wontucmunohu. ");
INSERT INTO yuw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Son amna wontucmuno, son goröm wontucmunohon morogoni, sonthon irot kombic kombic soni wontucmuno itacmaha duc mata soni ihorocgon wontucmunogon yongidang. Irot soni yansawoho foctacmaha worochon toroc wömai duc mata sonidec uuna yongidang. ");
INSERT INTO yuw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Amna ogepma yu irot kombic kombicno ogepma worocha yu mata ogepma yongidang. O amna wontucmuno yu irot kombic kombicno wontucmuno worocha yu mata wontucmuno yongidang. ");
INSERT INTO yuw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Worochai oro nocho ingoroc kantiwa: Kopotorocho owi amna mata youpdec yangat fohongocan bongono wocin wömai yu mata wontucmuno muyu muyu yongidungma wo ambarac yangsoworengga urago imangoc. ");
INSERT INTO yuw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gakain mataha tongga gocu momphon fatha woha ep bohöngon fat engoroc.” ");
INSERT INTO yuw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Oro mit Farisi au orin nongoru gendic fandat fandat amna yu Yesuot engmuya ingoroc inogung, “Fandat fandat amna goc weran moröma au tia ana.” ");
INSERT INTO yuw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ihoroc inuya Yesuho yogoc, “Son amna torop wontucmuno sinom göra toctocyi, son momphon weran inobarac au acacha yang. Wohong sonu weran au maaing. Weran tungugon wömai Kopotorocho son kindauna anahingmai woi yong tuctuc amna Yönaho togocma worochon werano. ");
INSERT INTO yuw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yönaho yu sep youp toctoc anfi orin kumbong anfi ihoroc söng morömaho irotnon idoc. O worochon torocgon wömai Amnahon Manano yu sep youp toctoc anfi orin kumbong anfi gurochon modibon ida wekongga idongungoc. ");
INSERT INTO yuw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Ninive nano yu wömai Yönahon mata kombingga irotno ibandung. O önga wömai amna moröma au Yöna anggirahacma yu sonot itac mahong sonu yuhon mata kombingga irot soni maibanidang. Worocha tongga Kopotorochon mata youpdec Ninive nano yu idongga owi amna önga idangma yuhon mata yu bödeuna wontucmunohon urago sogitnahing. ");
INSERT INTO yuw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“O ihorocgon Saut kantrihon Kwin owi yu ‘Salomonthon kombic kombic ogepma sogiwa’ yongo uyap ubarago sinom onggoc. O önga wömai amna au Salomon anggirahacma yu sonot itac mahong sontho yuhon mata kombic kombicha koroc koroc kamang. Worocha tongga Kwin owi worocho wömai Kopotorochon mata youpdec idongga owi amna önga idangma yuhon mata yun bödeuna wontucmunohon urago sogitnahing,” Yesuho mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesuho dogu boyömohon foroha mata ingoroc yogoc, “Dogu boyömpho ingoroc tongidang, yu amna au imun fauna ‘idit sa ogepma sogiwa’ yongo ongga sa moropmo wontucmuno woce itongontac. Woce itongmuna idit sa ogepma maun feuna yontac, ");
INSERT INTO yuw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Noc ibara fauna böc ima fadocma woroc wönggon sogiwa.’ Ihoroc yongo ibarun fauna woce ongkungga aantacmai, böc woi sacsago sinom idina amna auho abe masogidoc. ");
INSERT INTO yuw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Worocha tongga yu ongga nucni wontucmuno sinom 7 yu inuna ehuya yu ambaracho böc woroc sogitnahing. Woroc tuyai wömai woroc, amna wo yu osuc obmukusuc obukoc bum idoc mahong mit wömai yu obukocno sinom tontac. Oro kiapmo worocho sinom wömai owi amna wontucmuno önga idangma yudec öngkuangoc,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuho mata ihorocno owi amna inongga idina macno orugi yu ‘Yesuot mata yona’ yongo engga böc taitdec torengga idung. ");
INSERT INTO yuw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Woce idiya amna auho Yesu inogoc, “Kombiharoc, maca oröcai yu gocot mata yocyocha kombingga taitdec idang.” ");
INSERT INTO yuw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ihoroc inuna Yesuho mata urago ingoroc iban imogoc, “Nochon macnai oröcnai woi numari?” ");
INSERT INTO yuw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ihoroc yongga youp amnanidec oburo muto yogoc, “Ngorocho wömai nochon macnai oröcnai idang. ");
INSERT INTO yuw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Owi amna ambaracho Nandöngna momdec itacma yuhon irot kombic kombic tanidangma yu wömai nochon oröcnai, natnai, macnai sinom idang,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Oro sep bongono worocdecgon Yesu yu böc wo imun fauna sumon ongga yamuc öngkoring tero omoc idoc. ");
INSERT INTO yuw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tuna owi amna koböcma sinompho yuot engmuya sing arenggumbe togung. Worocha tongga Yesu yu girang audec bangmun uuna woce omoc idoc. Tuna owi amna ebungma yu terodecgon idiya ");
INSERT INTO yuw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesuho forosingga mom toboruchon foroha mata tepmo ingoroc fandat inogoc, “Amna auho ongga wit yitno öndec antogoc. ");
INSERT INTO yuw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Antongina yitno au uyapdec muuya yupho engmuya nagung. ");
INSERT INTO yuw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Oro wit yitno auho wömai sop koroc guroc obmukusucgon iyan woce mögung. Tongo guroc obmugon idocmaha tongga yu karupgon dogo köbung. ");
INSERT INTO yuw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Dogo kuya sepho öngga yitnodec foring yagoc. Tuna yitno wo fonsirango omoce mahogocmaha tongga sepho diuna song gebung. ");
INSERT INTO yuw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Oro, wit yitno au yu yi dirongoni tumoc woce ohogung. Tuna yiho kungga wit yitno tombuya ombung. ");
INSERT INTO yuw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Oro, wit yitno auho guroc ogepmadec mögung. Woce ida dogo köngmuya boinno ogepma figung. Auho 100thon, au 60hon o au wömai 30hon toroc. ");
INSERT INTO yuw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Oro amna auho onggimobarac idai wömai yu mata ngo kombiun.” Yesu yu mata tepmo ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesuhon youp amnani yu Yesuot engmuya inong ac tongga yogung, “Gocu foro yaha owi amna mata tepmogon inongitaroc?” ");
INSERT INTO yuw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ihoroc inuya Yesuho mata ökene iban imongo yogoc, “Mom toborucnohon foro wömai eran maec. Tuna owi amna koböcmaho wo makombining. Wohong sonu wömai Kopotorocho kang banauna son worochon foro urop kombingdeang. ");
INSERT INTO yuw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kombiarut, amna torop au yu mom toboruchon foro urop obmukusuc kombiang. Tuya Kopotorocho yuhon kombic kombicno obmukusuc wo sakaun fiuna yu worochon foro tuctugo sinom kombinahing. Wohong amna torop au yu mom toboruchon kombic kombic sogit sogitha koroc koroc imang. Tuya Kopotorocho amna worochon kombic kombic ambarac fuun deuna bumbum yongbödenahing. ");
INSERT INTO yuw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Oro foro worocha tongga nocho yu mata tepmogon inongitat. Ihoroc toya Aisayaho mata yogocma worocho boinno entac: ‘Owi amnaho dan foric tontang mahong yapmu au angtangtang matoning. O ihorocgon yu duc mata kombiantang mahong mata worochon foro tuctugo makombining.’ ");
INSERT INTO yuw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Oro, owi amna yu kombing tuctuc matongidungmaha tongga Aisaiahon yong tuctuc mata auho boinno öngkuboc. Yu ingoroc yogoc, ‘Sonu mata koböcma kombingitnahing mahong worochon foro wömai makombining. O ihorocgon sonu manomano koböcma foringo yanahing mahong yapmu au angtangtang matoning. ");
INSERT INTO yuw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Owi amna torop worochon irotno woi foc tongbödegoc. Tuna onggimoho mata kombic kombicha koroc koroc imogoc. O yuhon daro dung gorop wodung. Ihorocnono munohai wömai yu daroho angtangtang tong-ga onggimoho mata tuctugo kombingga o irotnoho matahon foro sogit akep tongmuya irotno ibaruya wönggon nocot ehuya nocho yu dongya orokup.’” ");
INSERT INTO yuw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesuho mata sakaun fiuna youp amnani ingoroc inogoc, “Son dan soniho angtangtang tongidang orin onggim soniho kombing tuctuc tongidang. Worocha son borongdearut. ");
INSERT INTO yuw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nocho boinno sinom kantiwa. Kopotorochon yong tuctuc amna orin amna nongnongo osuc idungma yu wömai son manomano önga yangidangma woroc yacyacha toup kombigung mahong yu woi mayagung. O sonu önga mata kombingidangma ngoroc kombic kombicha wömai yuho toup kombigung mahong yu wo makombigung.” ");
INSERT INTO yuw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesuho mata sakaun fiuna ingoroc yogoc, “Wit yitnohon mata tepmo worochon foro kombiarut. ");
INSERT INTO yuw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wit yitno uyapdec mögungma worochon yong tuctucno wömai ingoroc: Owi amna au yu onggimphagon mom toborucnohon fatmata kombingidang mahong irotnoho tuctugo makombic. Tuna dogu kopotho karupgon engga Kopotorochon mata urop irodin itacma woroc ambarac fuun deantac. ");
INSERT INTO yuw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Oro, wit yitno sop koroc mögungma worochon yong tuctucno wömai ingoroc: Owi amna au yu Kopotorochon mata kombingga karupgon sogida borongdedidang. ");
INSERT INTO yuw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Wohong yitnoho fonsirangono guroc ganang angit mahogocmaha tongga yu bongono docutnogon ogep itnahing. Tuya mataha tongga mepmo au yudec öngkuunai wömai yu kombing tobic tobicno karupgon imu faantac. ");
INSERT INTO yuw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Oro, wit yitnoho yi dirongoni tumoc mögungma worochon yong tuctucno wömai ingoroc: Owi amna au yu Kopotorochon mata kombingidang mahong guroc ngorochon mepmoho orin möneng yoctec manomano worochon ibiboho wömai yu imanang tonguc yec imongga Kopotorochon mata tombuna boinno muno engoc. ");
INSERT INTO yuw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Worochoi oro wit yitno guroc ogepmadec mögungma worochon kiapmo wömai ingoroc: Owi amna au yu Kopotorochon mata tuctugo kombingidang. Tongo yu wömai boinno koböcma fiantac. Boinno au wömai 100thon, o au 60hon o au wömai 30hon toroc finahing.” ");
INSERT INTO yuw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuho owi amna mata tepmo au ingoroc inogoc, “Mom toboruchon foro woi ingoroc: Amna au yu ongga öndec wit yitno ogepma antonggoc. ");
INSERT INTO yuw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Antongga idina kumbong owi amna dungo idiya ayampho engmuna wit bonipnodec owen wontucmuno antongga ibarun fauna onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tuna wit orin owen wontucmuno wo ambarac dogo kungga moröma idiya youp wabkaracho yagungmai au owen wontucmunoho wit bonipnodec öngkubung. ");
INSERT INTO yuw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Woroc yangga youp wabkaracho ongga önthon morömo inogung, ‘Amna moröma goc wit yitno ogepmagon araroc mahong ting tongga owen wontucmuno wo witot kondong kungga idang?’ ");
INSERT INTO yuw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ihoroc inuya yuho inogoc, ‘Ayamna auho engga togoc.’ Ihoroc yuna youp amnaniho yu inong ac tongga yogung, ‘Goc kombia angit ina non ongga owen wontucmuno wo deantamon.’ Ihoroc inuya amna morömaho yogoc, ");
INSERT INTO yuw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Muno, son ‘owen wontucmuno deamon’ yongo witot detningyit. ");
INSERT INTO yuw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wohai son muyu wo yang banauya witot kondong kuya boinno fogit fogithon bongono engoc. Bongono wocin wömai nocho wit boinno fogit fogit amna ingoroc inangot: Son owen wontucmuno wo osuc mango ep socsocha yidec feno fetho fiarut. Tongo mit witgon suran tongo fengo böcnan fiarut.’” ");
INSERT INTO yuw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesuho owi amna mata tepmo au ingoroc inogoc, “Mom toboruc woi mastet yitno obugu woroc simbang. Amna au yu mastet yitno yongga öndec muuna moröma sinom macfigoc. ");
INSERT INTO yuw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastet yitno woi obugu sinomthong macfinggai wömai nacno au öndec ididangma woroc yanggirada ep moröma idina yupho engmuya betomodec yingo tongga ididang.” ");
INSERT INTO yuw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesuho wönggon yogoc, “Mom toboruc woi yis simbang, owi auho yis obmu sogito flaua koböcmaot yamucot wo ambarac mongörec tuna yisho woroc tumoc ohongga flaua ambarac fogito tun out togoc.” ");
INSERT INTO yuw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Oro Yesuho mata ambarac ngo owi amna inongidocma wo mata tepmogon yongidoc. Yu mata au eran mainogoc. ");
INSERT INTO yuw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yu ihoroc togocmaha tongga Kopotorochon yong tuctuc amna auho mata osuc yogocma worocho boinno öngkuboc. Yu ingoroc yogoc: “Osuc Kopotoroc sa guroc gabocan bongono wocingon wömai yu manomanohon foro öp sigoc. Wohong önga wömai nocho worochon foro mata tepmodec yong fandat kanontat.” ");
INSERT INTO yuw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Oro, Yesu yu owi amna torop moröma wo youn fauya böc ganang ögoc. Öngga idina youp amnaniho yuot engmuya ingoroc inogung, “Goc owen wontucmunohon mata tepmohon foro ninia tuctugo kombiantamon.” ");
INSERT INTO yuw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Inuya Yesuho mata ökene ingoroc iban imogoc, “Amna wit yitno antonggocma yu woi Amnahon Manano. ");
INSERT INTO yuw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ön woi sa guroc noni. O wit yitno ogepma woi mom toboruchon owi amna. Owen wontucmuno woi dogu kopothon owi amnani. ");
INSERT INTO yuw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","O ayamo owen wontucmuno andocma yu woi dogu kopot. O nacno fogit fogithon bongono woi guroc ngorochon bödec bödecno. O youp amna nacno feng suran togungma yu woi Kopotorochon sum yaruni. ");
INSERT INTO yuw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","O amnaho owen wontucmuno suran tongga epin fongyu ohogungma toroc kiap worochogon wömai guroc ngorochon bödec bödecane bongono wocin öngkuangoc. ");
INSERT INTO yuw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Amnahon Manano yu inoin sum yaruni inong muuna engmuya mom midim sabarac sadec manomano amnahon kombing tobic tobicno dongyu moin tongidangma woroc dong yan bödenahing. O ihorocgon amna toroc wontucmuno tongidangma yu ambarac feng suran tongga dong yannahing. ");
INSERT INTO yuw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tongo ep bohöng fongyu mönahing. Ihoroc tuya yu woi epmoroc worocdec ida yong yaingo maro siu tomuya itnahing. ");
INSERT INTO yuw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Oro bongono wocin wömai owi amna nongnongoma yu fanohon mom sa midim sabarac sadec itmuya sep simbang yaguno möngga itnahing. Oro amna au yu onggimobarac idai wömai mata ngo kombihun.” ");
INSERT INTO yuw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesuho wönggon mata tepmo au ingoroc yogoc, “Mom toboruc woi gol orin silwa öndec öp idangma woroc simbang. Amna au yu inohogon ön youp tongga gol orin silwa wo aun fedoc. Aun feuna wohogon wönggon öp sigoc. Tongo yu borongdetno sinom tongmuna ‘ön woroc wöangot’ yongo inoin yoctecno manomano mönengha fingga ongga ön gol orin silwabaracma woroc wögoc.” ");
INSERT INTO yuw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesuho wönggon mata tepmo au ingoroc yogoc, “Mom toborucno woi bisnis amna au simbang. Bisnis amna wo yui goreng ogepmaha yabic yabic youp morö togoc. ");
INSERT INTO yuw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tongida goreng tungu wöngnacno önggöngyi sinom agoc. Angga ‘noc woroc wöangot’ yongo wohogon ongga inoin yoctecno manomano ambarac mönengha fingga goreng woroc wögoc.” ");
INSERT INTO yuw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesuho wönggon mata tepmo au ingoroc yogoc, “Mom toboruc woi song fogit fogit umben simbang. Amnaho woroc sogida top ganang tomu muuna söng foro ihono ihono fogidoc. ");
INSERT INTO yuw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tongo umben wo duc muuna wodiuya terodec ögoc. Tuna amnaho omoc itmuya söng ogepmagon soworengga waga audec suran togung. Wohong söng wontucmunoma yu fongyu onggung. ");
INSERT INTO yuw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Oro, guroc ngorochon bongono bödec bödecaneu wömai kiap ihorocnogon öngkuangoc. Sum yaruho wömai engmuya guroc amna yangsoworengga amna wontucmuno fogida ");
INSERT INTO yuw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ep bohöng aranggum mamong fatfatno woce fongyu mönahing. Tuya yong yaic moröma orin maro siu tomuya itnahing.” ");
INSERT INTO yuw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu yu mata tepmo ihoroc yongbödengga youp amnani ingoroc inong ac togoc, “Son mata tobuno yotma worochon foro tuctugo kombianga woha muno?” Ihoroc inuna yui ‘öc’ yogung ‘tuctugo kombiamon’. ");
INSERT INTO yuw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yuya Yesuho wönggon inogoc, “Nongoru gendic fandat fandat amna mom toboruchon foro kombiangma yu woi böc moröm simbang. Böc moröm yu bucin itmuna öngga manomano ogepma osucno ot wego ot wo fogida owi amna tong indangitac.” ");
INSERT INTO yuw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Oro Yesu yu mata tepmo wo ambarac yongbödengga sa woroc imun fauna Nasaret taun woce onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nasaret woi inoin böcsanon sinom. Tongo yu Yuda nanohon fatmata yocyoc bucin öngga Kopotorochon fatmata ogepma surarodec yong fandat inogoc. Inuna owi amna wo kombingga soroc yongga ingoroc yogung, “Amna ngo yu kombic kombic ogepma ihorocno nahe sinom sogidoc. O numa sinompho yu toroc kiap inobarac toctochon gesö imogoc? ");
INSERT INTO yuw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nonu wömai amna ngorochon foro kombingidamon. Yu woi böc toctoc amnahon manano. O macno wömai Maria. O Jems, Yösep, Saimon, Yudas yu woi orugi. ");
INSERT INTO yuw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","O yuhon natni yu ihorocgon bonip nonidec itongidang. Oro tingting sinom tongga yu ogep manomano wo tun?” ");
INSERT INTO yuw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Owi amna yu ihoroc yongga Yesuha irotno wodung mahong Yesu yu mata ingoroc inogoc, “Owi amna böcsa danong yu wömai Kopotorochon yong tuctuc amnaniha gending imongidang mahong inoin böcsanon sinomu o yuhon nip orugihu yuhogon wömai maang gendingidang.” Yesuho ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Oro Nasaret nano yu Yesu makombing tobing imogungmaha tongga yu sa woce toroc kiap inobarac tungu tungugon togoc. ");
INSERT INTO yuw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Oro, bongono wocin Gavmanthon morömo King Heröt yu Yesu youp orongi tongidocma worochon fatno kombigoc. ");
INSERT INTO yuw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tongo yu youp amnani ingoroc inogoc, “Amna woi Jön, yamuc gung imocimoc amna woroc. Yu kumkumonma wekongga gesö orongi sogitmuna youp inobarac ihorocno tongitac.” ");
INSERT INTO yuw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Oro osuc wömai Herötho orugo Filip yuhon oweno usem tongo inoha tongsigoc. Tuna Jön yamuc gung imocimoc amna yu Heröt ‘muno’ inongga yogoc, “Nongoru mata noniho wömai gocho toroc kiap wo tarocmaha ‘muno’ yac.” Jöntho ihoroc inogocmaha tongga Heröt yu wot omom toctocha kombigoc mahong yu suraroha botogoc. Owi amna ambaracho wömai Jöntha kombigung, yui Kopotorochon yong tuctuc amna moröma au. Worocha tongga Heröt yu tawa amna inong muuna yu ongga Jön sogito sendec akep tongo yi bucin tohong yugung. ");
INSERT INTO yuw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Oro, bongono auho wömai King Herötho ‘nochon öngkup öngkup bongonoha kombina’ yongo tong sonoc moröma togoc. Tuna owi moröma au mano Herödias yuhon wenoho engmuna amna nacno nagungmahon yangamin tong kumec au togoc. Tuna Herötho owi berac wo angibip toup sinom togoc. ");
INSERT INTO yuw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Worocha tongga yu yong koing mata ingoroc inogoc, “Goc gakain ibiba tanda yansawoha kombingga nania nocho boinno sinom yapmu woroc gamontat.” ");
INSERT INTO yuw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ihoroc inuna owi berachon macno Herödias, yu kombic kombic au weno imuna yu ongga Heröt ingoroc inogoc, “Noc wömai ingoroc kombihat: Jön yamuc gung imocimoc amna yuhon bigo mangga wagadec singga teng nam.” ");
INSERT INTO yuw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ihoroc inuna King Heröt yu mata woroc kombingga soroc yogoc mahong ino amna koböcho yangamin mata yong koing yogocmaha tongga yu ‘yangam fap tityit’ yongo ‘öc’ yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tongo yuho tawa amna au inuna yu yi bucin ongmuna Jön bangaro magoc. ");
INSERT INTO yuw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mangga waga audec singga tengga owi berac wo imogoc. Tuna yu wo sogitmuna macno ot tonggoc. ");
INSERT INTO yuw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Oro mit wömai Jönthon youp wabkaracniho engmuya Jönthon godip föbogon tongga oring sigung. Oring singga ongmuya King Herötho togocma worochon fatno Yesu inogung. ");
INSERT INTO yuw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Oro Yesu yu Jön wodungmahon fatno wo kombingga inohogon girang sogida böcsa woroc imun fauna sa au amna maiyan woce onggoc. Tuna owi amna yu Yesu woce ongeyacno wo kombingga böcsano dongyu fauya Yesu guroc uyap tan tonggung. ");
INSERT INTO yuw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ihoroc tuya Yesu yu girang imun fauna terodec öngo yagocmai owi amna koböcma sinom woce itmuya yuha torengga idung. Idiya Yesuho yangga yuha uroc imuna obukocnima youn orokogung. ");
INSERT INTO yuw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ihoroc tongo idina sa urop dobocsisicha tuna youp amnaniho yuot engmuya inogung, “Sa ngocinu amna maididang o sep urop ohoc ohocha tac. Worocha goc owi amna ngo yoi fauya ongmuya böcsa woce woce nacno wöarut.” ");
INSERT INTO yuw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ihoroc inuya Yesuho inogoc, “Muno, yu mangoning, sonibut nacno imarut.” ");
INSERT INTO yuw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ihoroc yuna youp amnani yogung, “Nonu nacno sowarango obukema orin söng yaihogon itnimang.” ");
INSERT INTO yuw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yuya Yesuho yogoc, “Nacno sowarango orin söng wo noc namarut.” ");
INSERT INTO yuw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tongo Yesuho ‘owi amna owendec omoc idarut’ yongo inogoc. Tongo nacno sowarango obukema orin söng yai wo fogito momdec foringmun uuna Kopotoroc ecec inongga nacno sowarango wo uboda youp amnani imogoc. Tuna yuho silip tongo owi amna imogung. ");
INSERT INTO yuw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Imuya owi amna ambarac yu nacno wo nangga modibo foc tuna nacno nong docno ambaracno wo youp amnaniho feng suran tongo dumbu 12 ihoroc oheuya foc togung. ");
INSERT INTO yuw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nacno nagungma woi amna 5,000 ihorocho nagung. Owi wabkarac wömai maembadung. ");
INSERT INTO yuw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Oro, Yesu yu wohogon ‘youp amnanai osuc fat namarut’ yongo inong muuna yu girang sogida forosingga yamuc öngköring aramo öke onggonga togung. Onguya Yesuho owi amna inong muuna uyap onggung. ");
INSERT INTO yuw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ongbödeuya yu inogon dönac yocyocha sa urongo audec ögoc. Tuna sep urop ohogoc. ");
INSERT INTO yuw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sa urongo idina youp amnani yu girangdec yamuc bonip idiya sumpho girang tamarodec busuna yamuc funfuroho öngga girang wagang fodigoc. ");
INSERT INTO yuw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tuna isoc isocanneu Yesu yamuc öngkoringdec sansantho ongga yuot eboc. ");
INSERT INTO yuw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ehuna youp amnani yu angmuya toup botongga kudat konoc konoc tongo mamboda yogung, “Ayöö, dogu au epac yo.” ");
INSERT INTO yuw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yuya Yesu yu karupgon inogoc, “Son koing songga idarut. Naka epat, son botoninga!” ");
INSERT INTO yuw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ihoroc inuna Pitaho inogoc, “Moröma, gaka eparocanu goc naniya nocho yamucdec sansantho gocot ongowa.” ");
INSERT INTO yuw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yuna Yesuho yogoc, “Epi!” Ihoroc yuna Pita yu girang imun fauna forosingga yamucdec sansantho Yesuot onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Woce ongmuna agocmai sumpho orongi sinom busongga idoc. Tuna Pitaho wo angbotongga yamuc ganang ohonggonga togoc. Ohongmuna mambodoc, “Moröma, tongfat nehi!” ");
INSERT INTO yuw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ihoroc yuna Yesuho karupgon oburo imonda Pita sogitmuna inogoc, “Kombing tobic tobica obmugon. Goc yaha irot yai taroc?” ");
INSERT INTO yuw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ihoroc tongga girangdec bangyun öngunya wohogon sumpho bödegoc. ");
INSERT INTO yuw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tuna amna girangdec idungma yu Yesu yong moröng imongga yogung, “Boinno sinom, goc Kopotorochon Manano.” ");
INSERT INTO yuw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Oro, Yesuot youp amnaniot yu yamuc öngköring kondong tongga Genesaret böcsa woce ongkubung. ");
INSERT INTO yuw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Woce ongkuya böc morömpho Yesu angga karupgon mata siuya böcsa ambehecgon idungma woce onguna owi amna mata wo kombingga nucni obukocnima yangada Yesuot febung. ");
INSERT INTO yuw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Fengmuya Yesu dönac orongi ingoroc inogung, “Goc owi amna obukocnima ngo yang banaya yu tec tohomamucnodec oburoho got möngga orokodarut.” Ihoroc inuya owi amna obukocniho Yesuhon tec tohomunmucno wot mungga ambarac orokogung. ");
INSERT INTO yuw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Oro, bongono wocingon nongoru gendic fandat fandat amna orin Farisi au yu Yerusalem taun imu fauna Yesuot engmuya ingoroc inong ac togung, ");
INSERT INTO yuw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Gakain youp amnayai yu foro yaha oburo masacwi nacno nongidang? Yu ihoroc tongidangmaha tongga ombusakungnonihon gendicno gumanidang.” ");
INSERT INTO yuw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ihoroc inuya Yesuho mata urago ingoroc iban imogoc, “O sonu foro yaha sinom soniin gendic sonigon tanidang mahong Kopotorochon nongoru wömai gumanidang? ");
INSERT INTO yuw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kopotorocho wömai ingoroc ninogoc: ‘Son muyu mac nandöngsoni gending imongitnung.’ O nongoru mata au ingoroc: ‘Amna auho macnohu o fanohu mata wöntucmuno inontacanu wömai suraroho yu wuya ompun.’ ");
INSERT INTO yuw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“Nongoru ihoroc itac mahong sonthon gendic mata soni wömai ingoroc itac: ‘Amna au yu ogep mönenghu o yapmu au mac nandöng tongfat yecyecha sigocma wo sogida Kopotorochon ececha siantac.’ ");
INSERT INTO yuw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Oro amna au yu gendic woroc sumbentacanu wömai yu mac nandönga magending imic, muno sinom. Sonthon gendicsoni worocho wömai Kopotorochon nongoru sinom taun weuna gendic sonihogon moröma itac. ");
INSERT INTO yuw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Son imanang amna! Kopotorochon yong tuctuc amna Aisaia yu boinno sinom sontha kombingga mata ingoroc yogoc: ");
INSERT INTO yuw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Kopotorocho yac, owi amna torop ngo yu duchogon gending namongidang mahong irot kombic kombicnoho wömai nocha korungon sinom itac. ");
INSERT INTO yuw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yuhon yong moröng kiapmo woi yapmu boyömo sinom, o yuhon gendicno woi amnahon gendicgon, Kopotorochon muno.’” ");
INSERT INTO yuw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Oro Yesuho owi amna inong yuna engsuran tuya ingoroc inogoc, “Kombiarut, son mata ngo kombing tuctuc tarut! ");
INSERT INTO yuw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yapmu auho sumonma amnahon dugo ganang ohontacma worocho wömai Kopotorocho yangamin amna matun bet faditac. Muno sinom, wohong yapmu amna irotdecma ducdec sumon öantacma worocho wömai amna tun bet faditac.” ");
INSERT INTO yuw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yesuho mata tepmo ihoroc yogoc. Tuna mit youp amnani engmuya ingoroc inogung, “Goc mata ngo yarocmaha tongga Farisiho kombiuya obukotac. Goc wo kombiharocha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yuya Yesuho yogoc, “Yapmu au Nandöngna momdec itacma yu inobut mamögocma woroc wömai yu mit foro fonsirangobarac detmuna fongyun ongonahing. ");
INSERT INTO yuw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Worocha son Farisiha kombingbanac toninga. Muno yu wömai amna daro kom tima simbang amna au uyap indac indacha kombiang mahong amna daro kom toctocyiho nucno uyap indac indacha yangat tongontacanu wömai yu yait yaitgon bohöng öhontamoroc.” ");
INSERT INTO yuw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ihoroc yuna Pitaho Yesu inogoc, “Goc mata tepmo worochon foro ninong tuctuc toi.” ");
INSERT INTO yuw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yuna Yesuho yogoc, “Tingting oro, sonu abe matuctuc ying yo. ");
INSERT INTO yuw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sonu ingoroc makombiinghu nuhun, manomano sumon idangma worocho wömai amna dugo ganang ohongga modibin ida sumon ohongitac. ");
INSERT INTO yuw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Wohong manomano amnahon irodin idangma worocho wömai ducdec öngga amna tun bet faditac. ");
INSERT INTO yuw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Wömai yaha, amnahon irot kombic kombicdec wömai manomano wontucmuno ingoroc öngkungidangmaha: Amna dong omom toctochon kiaphu o oimna tong samborec toctochon toroc kiaphu o owi göra toctoc kiaphu o usem toroc kiaphu o imanang mata yocyochu o kombing bunbun kiaphu. ");
INSERT INTO yuw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Oro kiap ihorocnoho wömai amnahon irodin dogo kungga ducdec uuna owi amna Kopotorocho yangamin dou bet fadidang. Wohong amna au yu oburo masacwi nacno naantacma toroc kiap worocho wömai amna Kopotorocho yangamin matun bec faic,” Yesu yu nacnohon gendicha ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Oro Yesu yu Israel sa guroc imun fauna bumbumyi nanohon gurocdec ongmuna Tair taun orin Saidonthon aramo ökene woce idoc. ");
INSERT INTO yuw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Woce idina Kenan owi au yu Yesuot engmuna dönac orongi ingoroc inogoc, “Moröma, Devithon morogono kombihi, dogu boyömo auho nochon wena sogito tun moin tocno sinom tac. Worocha goc nocha uroci kombingmina wena ti orokotun.” ");
INSERT INTO yuw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Owi wo ihoroc inogoc mahong Yesuho yuhon mata maiban imogoc. Muno yu öpgon idina youp amnaniho yuot engmuya kiring imongga yogung, “Owi ngo yu mambotgon tongo ninfepac. Worocha goc inongmuya ongoun.” ");
INSERT INTO yuw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Inuya Yesuho yogoc, “Kopotorocho noc Israelma bot sipsip gorong ongima yu tong fat yecyechongon nanong muuna ebot.” ");
INSERT INTO yuw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ihoroc yuna owi wo yu Yesuot engmuna goruc yemoc tongga wönggon ingoroc inogoc, “Moröma, tongfat nehi.” ");
INSERT INTO yuw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ihoroc yuna Yesuho inogoc, “Non managumbochon nacno fongga sap maimongidamon. Muno kiap ihorocno woi angit maic.” ");
INSERT INTO yuw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yuna owiho kiringga wönggon inogoc, “Moröma goc mata boinno yaroc mahong sap yu wömai morömoho nacno nauya föro föro fadang unenne möngidangma wo nangidang.” ");
INSERT INTO yuw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesu yu mata woroc kombingga ingoroc inogoc, “Owi, kombing tobic tobica moröma sinom. Goc dönac nanorocma woi boinno öngkung gampun,” Ihoroc inuna bongono wocingon owi worochon weno orokogoc. ");
INSERT INTO yuw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Oro Yesu yu sa wo imun fauna uyap ongga Galili yamuc öngkoring tero sindan tonggoc. Tongo mit yu ibarun fauna sa urongo audec öngga omoc idoc. ");
INSERT INTO yuw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Woce idina owi amna koböcma sinompho yuot ebung. Yu wömai nucni obukocnima yangat feuya Yesuhon orungo forodec fohong yuya idung. Yu wömai orung oburo möng toctocyihu, o dan komnimahu, o kudatno gendöngnimahu, o duc matano munomahu o obukoc foro ihono ihono au. Yu ambarac Yesuot yangat fengo dongyun orokogung. ");
INSERT INTO yuw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yesuho ihoroc tuya owi amna wo yangga nanga fatfat togung. Duc matano munomaho wömai mata yogung, o kudatno gendöngnimaho wömai nongnong yogung, o orungo möng toctocyimaho wömai uyap itonggung, o dan komnimaho wömai dan foric foric togung. Ihoroc tuya yangga owi amnaho Israel nanohon Kopotorocha yong moröng imogung. ");
INSERT INTO yuw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Oro, Yesu yu youp amnani inong yuna engsuran tuya ingoroc inogoc, “Noc owi amna ngorocha uroc nampac. Yu nocot idiyagon sep anfi bödeuna nacnoha docmöang. Yu nacnoha worec imong idiya nocho yu inong muayai wömai angit main. Yu uyapdec ongga yangam urip urip tongo muningyit.” ");
INSERT INTO yuw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yesuho ihoroc yuna youp amnaniho yogung, “Sa ngo amnano munon! Non nacno koböcma nahema sinom fengmanaina owi amna torop ngo imonaya angit naup?” ");
INSERT INTO yuw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yuya Yesuho inogoc, “Soniot nacno sowarango tingting idang?” Inuna yuho yogung, “Nacno sowarango 7 orin söng obugu obugu tungutnigon wömai itnimang.” ");
INSERT INTO yuw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Oro Yesu yu owi amna inuna gurocdec omöc idung. ");
INSERT INTO yuw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Omöc idiya Yesu yu nacno sowarango 7 orin söng woroc fogito Kopotoroc ecec inongga uboda youp amnani imuna yuho silip tongo owi amna imogung. ");
INSERT INTO yuw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Imuya owi amna ambarac nacno woroc nauya modibo foctongbödegoc. Tuna mit wömai youp amnani yu docno owi amna managungma woroc feng suran tongo dumbu 7 ihoroc oheuya foc togung. ");
INSERT INTO yuw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Oro amna nacno woroc nagungma worochon nambano wömai 4,000 ihorocho nagung. Owi wabkarac yuhon nambano wömai maembadung. ");
INSERT INTO yuw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Oro mit Yesu yu owi amna inong muuna onguya inoi girangdec bangmun uuna guroc au mano Magadan woce onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Oro, Farisi orin Sadyusi amna au yu ‘Yesu boinno sinom Kopotorochon youp tachu’ yongo tonguc imoc imocha Yesuot ebung. Engmuya ‘toroc kiap au tuna ana’ yongo inuya ");
INSERT INTO yuw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesuho mata urago ingoroc iban imogoc, “Sa dobocsisicha tontacanu wömai mompho gomondingidang. Gomondiuna yangga sonu yongidang, ‘Kembot sa ogep engoc.’ ");
INSERT INTO yuw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","O sa isoc isoc ane sonu yongidang, ‘Mompho sa tombuna komöc möantac.’ Boinno sinom, sontho momphon kiapmo angmuya ogepma sinom angsoworengidang mahong yapmu önga sontho yangam sonidec öngkung kampacma worochon foro wömai sonu angsoworengga tuctugo makombing. ");
INSERT INTO yuw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mayain, owi amna önga idangma yu wontucmuno sinom, o yu oimna dongyu moin tongidang. Oro yu momphon toroc kiap au acacha yang mahong yu toroc kiap au maaing. Muno sinom, toroc kiap tungugon wömai yu anahing. Woi Kopotorochon yong tuctuc amna Yönaho kiap togocma worocgon wömai anahing,” Yesuho mata koingo worocgon inongga dongyun fauya onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Oro, Yesuot youp amnaniot yu girang sogida yamuc öngköring gino ökene onggung. Tuna Yesuhon youp amnani yu agungmai nacno sowarango mayohi onggung. ");
INSERT INTO yuw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tuna Yesu yu inogoc, “Son Farisi amna orin Sadyusihon yisha yacyacho idarut.” ");
INSERT INTO yuw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ihoroc inuna youp amnaniho kombiu tuctuc mayuna inohogon mata inun ganun tongo yogung, “Yu mata yacma woi non nacno sowarango mafeamonmaha yachu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yu mata ihoroc yong tongo idiya Yesu yu woroc kombingga inogoc, “Mayain, sonthon kombing tobic tobic soni opmukusucgon sinom. Son foro yaha ‘nacno sowarango mafeamon’ yongo mata koböc koböc son bonip sonidec yongga idang? ");
INSERT INTO yuw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Son abe kombing tuctuc matingu? Kombiarut, nacno sowarango 5 ihorocgon idung mahong amna 5,000tho nauya sontho nacno nong docno feng suran tongga dumbu koböcma oheuya foc togung. ");
INSERT INTO yuw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","O ihorocgon nacno sowarango 7 ihorocgon idung mahong amna 4,000tho nauya sonu nacno nong docno feng suran tuya dumbu tingting oheuya foc togung! ");
INSERT INTO yuw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Son foro yaha kombing tuctuc mating? Noc Farisihon yisha mata kanotma woi boinno muno, mata tepmogon yogot. Mata tepmo worochon boinno wömai ingoroc, son Farisi orin Sadyusi yuhon toroc kiapha yacyacho itongitnung.” ");
INSERT INTO yuw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yesuho yong tuctuc mata woroc inogocmaha tongga youp amnani yu kombing tuctuc tongmuya ingoroc kombigung: ‘Yesuho owi nacno sowarango tobic tobicha yis sogididangma worocha mayoc. Yu wömai yogoc, son Farisi orin Sadyusi yuho mata fandat tongidangma worocha acacho idarut.’ ");
INSERT INTO yuw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Oro mit Yesu yu taun au mano Sisaria Filipai worochon gurocin öngkuboc. Tongo yu youp amnani ingoroc inong ac togoc, “Owi amna yu Amnahon Mananoha tingting yongidang?” ");
INSERT INTO yuw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ihoroc yuna youp amnaniho yogung, “Auho yongidang, ‘Jön yamuc gung imocimoc amna’, o auho wömai yongidang, ‘Elaiya’, oro auho wömai yongidang, ‘Yeremaiahu o Kopotorochon yong tuctuc amna auhu yo.’” ");
INSERT INTO yuw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ihoroc inuya Yesuho wönggon inong ac tongo yogoc, “Owi amna wömai ihoroc yongidang mahong sonu tingting kombingidang? Noc numa yo?” ");
INSERT INTO yuw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ihoroc inuna Saimon Pitaho yogoc, “Gocu Duic, Kopotoroc Itonggong Morömo yuhon Manano.” ");
INSERT INTO yuw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ihoroc yuna Yesu mata ingoroc iban imogoc, “Saimon, Yönahon manano, goc borongdehi. Gocho mata ngo yarocma wömai guroc amna auho gindauya mayaroc. Muno, Nandöngna momdec itacma worocho ngo gindauna yaroc. ");
INSERT INTO yuw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","O nocho ingoroc gantiwa: Goc maya Pita oro nocho nakain suraro wömai sop ngoroc koroc gaangot. Tuna omochon gesönoho nochon suraro ngo angirada matun obökic. ");
INSERT INTO yuw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Oro nocho wömai mom toborucnohon ki gamangot. Gocho guroc ngocin guroc amnahon turongo akep tiai wömai momdec Kopotorocho wo ihorocgon akep tangoc. O gocho turongo au asariyai wömai momdec Kopotorocho wo ihorocgon asarangoc.” ");
INSERT INTO yuw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ihoroc inongga mit Yesu yu youp amnani garac mata ingoroc inogoc, “Sonu owi amna au ingoroc inoninga, ‘noc Duic.’” ");
INSERT INTO yuw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Oro bongono wocin Yesu yu forosingga youp amnani fasun imongo ingoroc inogoc, “Noc muyu Yerusalem ongoya Israel nanohon amna dugohu o öret socsochon amna morömahu o nongoru gendic fandat fandat amnahu yu ambaracho focfoc moröma foro ihono ihono tong namongo nuya omengot. Tongga sep bongono anfi idina wönggon wekangot. Kopotorocho yong torop ihoroc woroc yongo singdegoc,” Yesuho yong tuctucno ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tuna Pita yu mata woroc kombiuna angit maidina yu Yesu yangato tero tongmuna forosingga yu inong fato inogoc, “Muno sinom, yapmu ngo gocdec öngkuicha.” ");
INSERT INTO yuw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tuna Yesu yu ibarun fauna Pita me imongmuna inong firi firi tongo inogoc, “Dogu kopot, goc menan ongoi! Goc amnahon kombic kombicgon tararoc. Kopotorochon kombic kombic wömai goc makombiroc. Gocu tonguc namongo gesöna tohoc tohocha taroc yo.” ");
INSERT INTO yuw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesuho Pita ihoroc inongga wönggon youp amnani mata ingoroc inogoc, “Amna au yu noc nan nantha kombinggai yu muyu inoin ibibo youn fat bödeuya ep goröcno sumbotmuna noc narun. ");
INSERT INTO yuw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wömai yaha, amna au yu inoin itonggongno guroc ngocin sogit akep tontacanu wömai yu itonggong koing tun muuna gorong ongontac. Wohong amna au yu guroc ngorochon itonggongno ‘nochahu o fatmata ogepmahahu’ yongo imun faantacma yu wömai itonggong koing aun feangoc. ");
INSERT INTO yuw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Oro amna au yu gurochon möneng yoctec manomano ambarac fogida feng suran tunai wömai yapmu worocho tingtingno sinom tongfat yeuna magorong ongic? O amna worocho yaö wöngnacno sinom tongga itonggong koing aun feangoc. Woroc wömai maec. ");
INSERT INTO yuw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Kombiarut, Amnahon Manano yu Fanohon yaguno gesö morömadec mitimni sinom engmuna sum yaruni yangada fehangoc. Tongo yu owi amnahon matano soworengga yun bödeuna yu toroc kiap togungmahon toroc urago ogepmaha woha wontucmunoha wo imangoc. ");
INSERT INTO yuw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nocho boinno sinom kanoya kombiarut. Amna au ngocin idangma yu abe mami idiya Kopotorochon toborucno ehuna anahing.” Yesu yu mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Oro, sep youp toctoc 6 ihoroc bödeuna Yesuho Pita, o yan oröcma Jems orin Jön yu yangauna sa urongo au ubarago sinom wocin ögung. Öngga yu inogon sinom idiya amna au maidung. ");
INSERT INTO yuw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Woce itmuya agungmai Yesuho mongurac tongo foro au sinom öngkuboc. Yangamo wömai sep yaguno simbang möngga idoc. O tec tohomunmucnoho wömai föhöc sinom öngkungga yaguno möngga idoc. ");
INSERT INTO yuw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yesu ihoroc idina wohogon Möse orin Elaiya yu engkungmunya Yesuot mata mata yongo idiya youp amnaniho yagung. ");
INSERT INTO yuw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita yu woroc angmuna Yesu ingoroc inogoc, “Moröma, non ngocin itnaya ogep sinom itac. Goc kombiiya noc sum böc anfi towa. Auma gochon, auma Mösehon, auma Elaiyahon.” ");
INSERT INTO yuw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita yu mata woroc yongidina mom muruc muruc auho föhöcno sinom ohongga yu tom togoc. Tuna momdecma duc mata au ingoroc öngkuboc, “Nochon Manana ngoroc. Noc yuha toup sinom kombingitat. O noc yuha borongdehat. Son yuhon mata sumboditnung.” ");
INSERT INTO yuw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yesuhon youp amnani yu mata woroc kombingga nangano fauna gurocdec möngga yangamo imu tomuya toup sinom botogung. ");
INSERT INTO yuw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tuya Yesuho yuot engmuna godibodec dong möngga ingoroc inogoc, “Son botoninga, idongurit.” ");
INSERT INTO yuw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ihoroc inuna yu foring fadang öngo agungmai amna au maidoc, Yesu inogon idina agung. ");
INSERT INTO yuw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tuna yu sa urongo wo imu fauna uyapdec ohong tohongmuya Yesuho ingoroc inogoc, “Son yapmu woroc aingma worochon fatno amna au fandat inirocha. Amnahon Mananoho omocdecma wekongga idongungocan bongono wocin wömai son ogep fat wo inonahing.” ");
INSERT INTO yuw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tuna youp amnaniho Yesu ingoroc inong ac tongo inogung, “Foro yaha nongoru gendic fandat fandat amnaho ingoroc yongidang: Elaiya yu osuc epun, mit wömai Duic ehangoc.” ");
INSERT INTO yuw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yuya Yesuho inogoc, “Mata ngo wömai yu boinno yongidang. Elaiya yu osuc engmuna manomano ambarac tobingga arangarang yongga engoc. ");
INSERT INTO yuw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Worochoi oro nocho ingoroc kantiwa, Elaiya yu urop eboc mahong amnaho yu makombing imogung. Muno, yu inoin kombic kombicgon tanmuya yu toroc kiap wontucmuno wohon wohon tong imongidung. O toroc kiap wontucmuno worocotmagon wömai yu Amnahon Manano tong imonahing.” ");
INSERT INTO yuw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesuho mata ihoroc inuna youp amnani tuctugo kombigung, Elaiya yui Jön yamuc gung imocimoc amna woroc. ");
INSERT INTO yuw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Oro Yesuot youp amnani anfiot yu sa urongodecma ohuya owi amna torop morömaho yu yau fedung. Yau feuya amna auho engmuna Yesu goruc yemoc tong imongo inogoc, ");
INSERT INTO yuw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Amna moröma, goc nochon mananaha uroc gampun. Yu bongono bongono omong möngga kudat konoc konoc tongo ep moroc ohoi yamucdec ohoi ihoroc tongitac. ");
INSERT INTO yuw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nocho yu gakain youp amnayaiot yangat tonggot mahong yu manana tu orokoc orocha makombigung,” yu Yesu dönac ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Inuna Yesuho yogoc, “Mayain, son owi amna torop gendöngni, sonthon kombing tobic tobic soni maec. Nocu urop sa ubarago sonot itmaina önggöngyi soni sumboditat mahong sonthon kombing tobic tobic soni abe maitkamoc. Karup, managumboc wo nocot yangat tebarut.” ");
INSERT INTO yuw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ihoroc inuna wabkarac wo Yesuot yangat teuya yu dogu boyömo inong fauna onguna managumboc worochon obukocno wohogon bödegoc. ");
INSERT INTO yuw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yesuho ihoroc tuna mit youp amnaniho yuot engmuya inong ac tongga yogung, “Foro yaha non dogu boyömo wo angit madong yandomon?” ");
INSERT INTO yuw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ihoroc inuya Yesuho inogoc, “Sonthon kombing tobic tobic soni maec. Worocha tongga son dogu boyömo dong yanyanta tu matogoc. Nocho boinno sinom kanoya kombiarut. Sonthon kombing tobic tobic soni mastet yitno simbang obugu sinom entacanu wömai son ogep sa urongo ngoroc inontang, ‘Goc ongga okoce iti.’ Ihoroc inuya yu worochon torocgon tun. O son yaö yaö youp toctocha kombiangma woroc woi ambarac ogep tup. ");
INSERT INTO yuw_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Oro dogu boyömo kiap ihorocno dong yan yantha wömai uyap tungugon ingoroc itac: Kopotorocha gending imongo nacno manai itmuya dönac youp tongo taruya ongoun.” ");
INSERT INTO yuw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Oro oipmonu Yesuot youp amnaniot yu Galili Distrik wocin suran tongga itmuya Yesuho ingoroc inogoc, “Guroc amna yu wömai Amnahon Mananoha me imongmuya ayamiho oburodec tohong yunahing. ");
INSERT INTO yuw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tuna yuho wuya omengoc. Omuna sep youp toctoc anfi idina Kopotorocho yu wönggon omocdecma tun wekuna idongungoc,” youp amnaniho mata woroc kombiuya irot mep togung. ");
INSERT INTO yuw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Oro, oipmonu Yesuot youp amnaniot yu Kaperneam böcsa woce ongga idung. Idiya öret socsoc böchon takis fogit fogit amna yu engmuya Pita ingoroc inong ac tongo yogung, “Fandat fandat amna soni yu takis möneng sing itacha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Inuya Pitaho inogoc, “Öc, yu wo singitac.” Ihoroc inongga yu böc ganang ongmuna mata au abe mayi idina Yesuho yu ingoroc inong ac togoc, “Saimon goc tingting kombiharoc? Guroc ngorochon Kinghu o amna moröma idangmahu yu takis möneng numaridecma fogididang. Yu inoin toropnidecma fogididanga woha torop audecma fogididang?” ");
INSERT INTO yuw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Inuna Pitaho yogoc, “Yu wömai torop audecma fogididang.” Yuna Yesuho yogoc, “Oro yu torop audecma fogididangmaha tongga inoin toropniho yu takis möneng au maimongidang. ");
INSERT INTO yuw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Oro nontho yu takis möneng maimontamonanu wömai yu nontha kombiuya obukontac. Worocha goc yamuc öngkoring tero ongmina yi moria söng osuchagon woding töantarocma worochon dugo öcangmina möneng docno au irotnon idina aantaroc. Möneng worocho wömai nodin takis butogo angit tombenthac. Tongo woroc sogida tongga takis sogit sogit amna impi,” Yesu yu Pita ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Oro, bongono worocho Yesuhon youp amnani yu Yesuot engmuya ingoroc inong ac togung, “Numaho wömai mom sa midim sadec amna moröma sinom engoc?” ");
INSERT INTO yuw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ihoroc inuya Yesuho managumboc au inong yuna engmuna youp amnanihon bonipnodec idina Yesuho ingoroc yogoc, ");
INSERT INTO yuw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Nocho boinno sinom kanoya kombiarut. Son irot soni mongurac mati managumboc ngoroc simbang maöngkuuyai wömai sonu mom midim sabarac sadec angit mangoning. ");
INSERT INTO yuw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","O amna au yu inoha kombiuna managumboc ngorochon toroc entacma yu wömai mom midim sabarac sadec amna moröma sinom engoc. ");
INSERT INTO yuw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","O amna au yu nocha kombingmuna managumboc au ngorochon toroc tong ogep tong imontacma yu wömai naka sinom tong ogep tong namontac.” ");
INSERT INTO yuw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Oro Yesu yu wönggon ingoroc yogoc, “Amna auho managumboc obugu noc kombing tobing namongidangma yu tonguc yeuna turongodec möantacma wömai amna worocho urago wontucmuno sinom aun feangoc. Sop moröma bangarodec tungmun muuna tongga top ganang tomun möantacma woi urago mepmo au mahong amna ihorocnoho urago au feangocma wömai mepmo woroc anggirada koingo sinom engoc.” ");
INSERT INTO yuw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Yesuho wönggon yogoc, “Öwec son guroc owi amna son ingoroc kombiningyit, wontucmuno toctochon bongono urop bödeantac. Muno, manomano wontucmunoho wömai amna tonguc yeuya turongodec möngidang. Wohong soni woho, amna toroc kiap wontucmuno ihoroc dongyu öngkungidangma yu wömai urago wontucmuno sinom sogitnahing. ");
INSERT INTO yuw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kombiarut, oburahu o orungaho goc turongodec gangat töngunai wömai gocho wo kondong tongo tomi ongoun. Ihoroc tongga gocho oburahu o orungahu tunguhagon itonggong koing ai feangoc. Gochuhun orunga obura yait yait ep bohöng tomun muirocyit. Wocin wömai ep moroc mami focfoc morö iditno itgamongo engoc. ");
INSERT INTO yuw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","O ihorocgon daraho gangada turongo toctocha gangaunai wömai gocu dara ihorocgon fonunda tomi ongoun. Gocho dara tunguhagon wömai ogep idit koing ai feangoc mahong dara yait yait ito ep böhongnodec tomun muirocyit. Woce wömai ep moroc mamic. ");
INSERT INTO yuw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Son soni woho, son managumboc obugu idangma yu dou obukoninga. Nocho boinno sinom kantiwa, Kopotorochon sum yaruho managumboc obugu wo yangtorengidang. Tongo yu bongono muno momdec Nandöngnaho yangmin ididang.” ");
INSERT INTO yuw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yesu yu mata tepmo au ingoroc yogoc, “Amna au yu bot sipsip 100 ihoroc idimogung. Tuna bot sipsip tungu au korungon ongga gorong onggoc. Oro sonu tingting kombiang? Amna wo yu bot sipsipno 99 woroc sa urongodec dongyun fauya ongga tungu gorong onggocma worocha yabiangocha woha muno? ");
INSERT INTO yuw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nocho boinno sinom kantiwa, amna wo yu yabing tongga gorong onggocma angmuna irot ogep moröma sinom kombiantac. Yu wömai bot sipsip 99 magorong ongimaha irot ogep kombingitac mahong yu bot sipsip tungu woroc wönggon sogidocmaha toup sinom borongdeantac. ");
INSERT INTO yuw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Oro worochon torocgon wömai Nandöng soni momdec itacma yu managumboc obuguha toup kombingitac. Tongo yu tungu au gorong onggongontha makombic.” ");
INSERT INTO yuw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesu yu mata au ingoroc yogoc, “Oröca auho goc tong bumbum tong gamunai wömai goc yuot ongo turongono indaya sot yait yaitgon worochon mata yongo tobiarun. Tongo oröcaho gochon mata kombiantacanu wömai sot wönggon irot tungu entamoroc. ");
INSERT INTO yuw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Oro yu gochon mata makombiantacanu wömai gocho amna tunguhu yaihu iniya ehuya son ambarac mata wo yongo tobiarut. ");
INSERT INTO yuw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ihoroc tongo amna worocho mata soni wönggon makombiantacanu wömai gocho ongmina Kopotorochon suraro ambarac inia suraro ambaracho mata wo tobiarut. Tuya amna worocho surarohon mata ihorocgon fodiantacanu wömai gocho yu aaya amna bumbumyihu o imanang amnahu worochon toroc entac. ");
INSERT INTO yuw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Oro, nocho boinno sinom kantiwa, sontho amna auhon turongo gurocdec ngocin kokoreantanganu wömai Kopotorocho ihorocgon momdec amna worochon turongo kokoreantac. O sontho amna auhon turongo gurocdec ngocin imu faantacanu wömai Kopotorocho ihorocgon momdec turongo wo imun fat imontac. ");
INSERT INTO yuw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Noc wönggon ingoroc kantiwa. Guroc ngocin amna yai yu irot tungu singmunya yapmu auha kombingga dönac yunya wömai Nandöngna momdec itacma yu worochon torocgon imangoc. ");
INSERT INTO yuw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Wömai yaha, amna yaihu anfihu yu nochon madec eng suran tuyai wömai noc naka yuhon bonipnodec engot.” ");
INSERT INTO yuw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Oro mit wömai Pita yu Yesuot engmuna ingoroc inong ac togoc, “Moröma, oröcnaho noc wontucmuno tongnamunai wömai nocho bongo tingting oröcnahon wontucmuno wo dongya fat imam, bongo 7tha woha tingting?” ");
INSERT INTO yuw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Pita ihoroc yuna Yesuho ingoroc inogoc, “Nocho ingoroc gantiwa, oröcahon turongo imi fat imocimocno woi bongo 7gon muno, goc muyu yuhon turongo bongono muno doi fat imonung. ");
INSERT INTO yuw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Kombiarut, mom toborucnohon toroc kiap wömai ingoroc: Amna moröma au yu youp wabkaracnihon möneng butogo tobic tobicha kombigoc. ");
INSERT INTO yuw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tongo yu youp wo forosiuna tawa amnaho youp wabkarac au amna morömaot yangat tebung. Youp wabkarac worochon möneng butogo wömai 10 milion kinahon toroc idoc. ");
INSERT INTO yuw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tuna youp wabkarac wo yu butogo saric sarichon möneng maidimogung. Worocha yu möneng urago imocimocha tun matogoc. Tuna amna morömaho tawa amnani inogoc, ‘Sontho amna ngo orin yomot macnihu o yoctecno manomano ambarac imun gamunthon uyapdec fohong yuarut. Tuya möneng worocho wömai butogono saric sarichon uyap öngkung imangoc.’ ");
INSERT INTO yuw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Amna morömaho ihoroc yongbödeuna youp wabkaracho mata woroc kombingga soroc yongga amna morömahon orungo forodec goruc yemoc tongo dönac ingoroc inogoc, ‘Goc nang bangga opmukusucgon torengga iti. Noc karupgon möneng butogo wo saringbödeangot. ");
INSERT INTO yuw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ihoroc inuna amna morömaho youp wabkaracha uroc imuna möneng butogo wo ambarac sac tongdup imongo youp wabkarac angbanauna onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Oro youp wabkarac wo yu böc amante ohongmuna nucno au aun fedoc. Nucno worochon möneng butogo wömai 10 kinahon toroc ihorocgon idoc. Tongo youp wabkarac yu nucno bangarodec sogitmuna inogoc, ‘Goc nochon möneng fogidorocma wo karupgon namongdup toi.’ ");
INSERT INTO yuw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ihoroc inuna nucno mata woroc kombingmuna youp wabkarachon orungo forodec goruc yemyem tongo inogoc, ‘Goc nang bango obmukusucgon torengga iti. Nocho mönenga butogo wo saringdup tontat.’ ");
INSERT INTO yuw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ihoroc inuna youp wabkaracho kombiuna angit maidina yu me imongo mata siuna tawa amnaho nucno wo sogida yi bucin tohong yugung. Tuna yu wocingon idina ongga möneng urago saringdup tangoc. ");
INSERT INTO yuw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Oro youp wabkaracho nucno toroc kiap wontucmuno ihoroc tong imuna amna morömahon youp wabkaracni au yu wo angga kombiuya obukocno sinom togoc. Tongo yu ongmuya amna moröma yapmu öngkubocma worochon fatno inongburoc togung. ");
INSERT INTO yuw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tuya amna moröma yu youp wabkarac wontucmuno wo inong yuna ehuna ingoroc inogoc, ‘Goc youp amna wontucmuno, goc osuc noc yaing naria noc gocha uroc namuna turongoya ambarac ima fatbödegoc. ");
INSERT INTO yuw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Worocha gocu yaha nuca toroc kiap ogepma matong imoroc? Nocho toroc kiap ogepma tong gamogotma ihoroc gocu nucaha uroci kombiiyai wömai ogep in.’ ");
INSERT INTO yuw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Amna moröma yu ihoroc inongga ecego moröma kombingga amna wo yi böc angtorec amnahon oburodec sigoc. Tuna yu youp wabkarac wontucmuno sogida focfoc youp moröma imuya ongga youp wabkarachon möneng butogo bödeangoc.” ");
INSERT INTO yuw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesuho mata tepmo woroc yun bödeuna worochon foroha wönggon ingoroc yogoc, “Kombiarut, sonu nip oröc sonihon turongono irot sonidec kokoreantanganu wömai Nandöngna momdec itacma yu toroc kiap amna morömaho youp wabkaracno imogocma worocgon sondec kamangoc.” ");
INSERT INTO yuw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Oro Yesu yu mata woroc yongbödengga Galili guroc imun fauna ongga Yudia guroc Yödan yamuc ökenne idoc. ");
INSERT INTO yuw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Woce idina owi amna koböcma sinompho yu tan tonguya Yesuho obukocnima doun orokogung. ");
INSERT INTO yuw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tuna Farisi amna auho engmuya ‘Yesu tonguc imona’ yongo oimna ficfuc toctocha ingoroc inong ac togung, “Goc tingting kombiharoc, amna au yu oweno foro muno komanang sinom fodingmun ongontacanu wömai amna worocho nongoru gumarantacha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ihoroc inuya Yesuho mata ingoroc iban imogoc, “Kopotorochon bapiyadec mata itacma wo sonu makombinghu nuhun? Woce ingoroc itac: Osuc forosicsicdec wömai Kopotoroc Sa Gapgap Nandöng noni yu amna tobingga owino amnano yait yait dongyun öngkubung. ");
INSERT INTO yuw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tongo Kopotorocho yogoc, Amna yu macnin fanin dongyun fauya oweno ot ding fiantac. Tuna yu Kopotorocho yangamin godip föp tungu entamoroc. ");
INSERT INTO yuw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yu yaihong Kopotorocho tuna yu godip föp tungu entamoroc. Tuna Kopotorocho kondong figocmaha tongga amnaho wo guman gumanno angit maic.” ");
INSERT INTO yuw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yesu yu ihoroc inuna Farisiho wönggon inogung, “Tingting oro, Möse yu foro yaha nongoru au ingoroc nimogoc: Amna au yu ogep oimna ficfuc toctochon bapiya irim tongo oweno imongga yu fodingmun ongontac.” ");
INSERT INTO yuw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ihoroc inuya Yesuho mata urago ingoroc inogoc, “Sonthon irot soni koingo, son nuc soniha uroci makombingidang. Worocha tongga Möseho son kang banango nongoru wo kamogoc. Wohong osuc forosicsicnodec wömai oimna ficfuc toroc kiap maididoc. ");
INSERT INTO yuw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nocho boinno sinom kantiwa, owi au yu amna göra matogoc mahong opnoho yu komanang sinom fodingmun onguna owi au tong siantacanu wömai amna worocho oimna gumanmuna owi göra tontac.” ");
INSERT INTO yuw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Oro Yesu yu ihoroc yuna youp amnaniho mata woroc kombingmuya ingoroc inogung, “Oro goc oimnahon mata yarocma worocho boinno entacanu wömai amnaho oweno muno ipma wömai angit in.” ");
INSERT INTO yuw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ihoroc yuna Yesuho inogoc, “Boinno, mata ngoi mepmo, amna koböcmaho tuctucgo makombiing. Wohong Kopotorocho amna auhon irotno tun tumunahai wömai amna wo ogep kombiun. ");
INSERT INTO yuw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kombiang, amna auho wömai owi foro ingorocnoha mayong fingidang: Auma wömai macnoho godibo obukoc obukocyi bagung. O auma wömai amnaho godibo macmacyi yu managumboc madongyu öngkup öngkuphon. O aumaho wömai ‘Kopotorochon toboruchon youpgon tona’ yongo owi mayong fingidang. Oro, amna au yu mata wo kombiuna angit idina yu wömai worochon toroc tun.” ");
INSERT INTO yuw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Oro mit owi amna au yu managumbocni yangada ‘Yesuho oburo bigodec out tohongga dönac youn’ yongo yuot febung. Ihoroc tuya Yesuhon youp amnaniho yu yangga inong fadung. ");
INSERT INTO yuw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ihoroc tuya Yesuho yu ingoroc inogoc, “Son managumboc nocot ebepha bongbong sing imoninga. Muno, yu muyu nocot ebarut. Kopotorocho wömai mom toboruc owi amna managumboc simbang ima yuha bogigoc.” ");
INSERT INTO yuw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yesuho ihoroc yongga oburo managumboc koroc figoc. Tongo mit sa wo imun fauna onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Oro amna berac au yu Yesuot engmuna ingoroc inogoc, “Fandat fandat amna noc yaö youp ogepma tongga itonggong koing aa feangoc?” ");
INSERT INTO yuw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ihoroc yuna Yesuho inogoc, “Goc yaha youp ogepmaha nanong ac taroc? Amna tunguhogon woi ogepma. Worocha goc amna worochon nongoru ambarac sumbotbödengga itonggong koing ai feangoc.” ");
INSERT INTO yuw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ihoroc yuna amna worocho Yesu wönggon inong ac tongo yogoc, “Goc nongoru torop yanömaha yaroc?” Yuna Yesuho inogoc, “Noc nongoru torop ingorocnoha yat: Goc owi göra tirocha, goc amna wot omom tirocha, goc usem tirocha, goc mata youpdec amna auha mata imanang firing tarirocha, ");
INSERT INTO yuw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","goc mac nandöng gending imiruc, o goc gakaha kombingitarocma worochon toroc nucaha kombingidiruc. Nongoruho wömai ihoroc itac.” ");
INSERT INTO yuw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Yesu ihoroc inuna amna beracho yogoc, “Nocu nongoru wo ambarac yandup tongga itongitat. Worochoi noc yapmu yaöha abe docmöhat?” ");
INSERT INTO yuw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yuna Yesuho inogoc, “Goc ongmina yoctec manomanoya wo ambarac imun gamunthon uyapdec fingga möneng woroc fogida owi amna urocimaha silip tong imiruc. Ihoroc tontarocanu wömai momphon itonggong ogepma gochon fat entac. Oro mit wömai engga noc nari.” ");
INSERT INTO yuw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Amna berac yu mata woroc kombingmuna irotno toup mep tuna Yesu imun fauna onggoc. Wömai yaha, yu yoctecno möneng manomano koböcma idimogungmaha onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Onguna Yesuho youp amnani ingoroc inogoc, “Nocho boinno sinom kanoya kombiarut, amna möneng yoctecno koböcma yu wömai mom midim sabarac sadec onggonga mep tongidang. ");
INSERT INTO yuw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bot kamele yu somayang ganang onggongno woi maec. O worochon torocgon wömai amna yoctecno koböc idimangma yu Kopotorochon midim sabarac sadec onggonga tu matangoc.” ");
INSERT INTO yuw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesuho ihoroc yuna youp amnaniho mata woroc kombingmuya soroc yongo yogung, “Mayain, goc ihoroc yarocma wömai amna tungu au itonggong koing maun feic.” ");
INSERT INTO yuw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ihoroc yuya Yesuho yangam dongdong foring yangmuna inogoc, “Amnaho matoctocno worochoi Kopotoroc yu ogep manomano ambarac tuna boinno engoc.” ");
INSERT INTO yuw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yesuho ihoroc yuna Pitaho yu inogoc, “Kombiharoc, nonu manomano noni ambarac dongyana fauya goc gandomon. Worocha wömai nonu urago tingtingno fogitnahamon?” ");
INSERT INTO yuw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ihoroc yuna Yesuho inogoc, “Nocho boinno sinom kantiwa, mit wömai Amnahon Manano yu ma moröma sogitmuna Kinghon abamodec idina Kopotorocho sa guroc manomano ambarac dongyun wego öngkuuya ino yabitno itnahing. Oro bongono wocin wömai sonu ihorocgon amna dugohon abamo 12 inoin inoin fogitmuya Israel nanohon torop 12 wo yuhon matano soworengga yu bödenahing. ");
INSERT INTO yuw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","O amnaho nochon youp toctocha böcnohu, o orugihu, o natnihu, o fanihu, o macnihu, o mananihu, o mondocnohu wo dou fauya noc narantangma yu wömai manomano wo ambarac 100thon toroc urago fogitnahing. Tongo mit itonggong koing au feangoc. ");
INSERT INTO yuw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kombiarut, amna koböcmaho önga osuc ididangma, yu wömai mit madango itnahing. O amna koböcmaho önga madango ididangma yu mit osuc itnahing,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Oro, Yesu yu mom midim sabarac sadec numaho morömahu o obuguhu engocma worochon mata tepmo au ingoroc sakaun figoc, “Mom midim sabarac sahon toroc kiap wömai ingoroc: Amna moröma au yuhon wain ön woi moröma sinom. Tongo yu kembotsum sinom idongga ‘youp wabkarac au wuaya wain öndec youp tarut’ yongo maket taitdec onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ongga youp wabkarac feng suran tuna sep youp toctoc tunguhon wöngnacnoha wömai kina tungu tungu ihoroc yongbödegung. Tongo youp wabkaracho ongmuya wain öndec youp togung. ");
INSERT INTO yuw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ihoroc tongga idiya sep bongono 9 kilok wocin amna moröma yu wönggon maket taitdec ongga yagocmai amna torop au yu komong woce idung. ");
INSERT INTO yuw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tuna amna morömaho yu ingoroc inogoc, ‘Son ihorocgon ongmuya nochon wain öndec youp tarut. Tuya nocho mit youphon wöngnac ogepma kamontat.’ ");
INSERT INTO yuw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ihoroc inuna yu ihorocgon youpdec onggung. Oro amna moröma yu sep bongono 12 kilok orin dobocsisiha 3 kilok bongono wocin wönggon ongmuna youp wabkarac au ‘youp tarut’ yongo fogidoc. ");
INSERT INTO yuw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Oro mit dobocsisiha 5 kilok bongono wocin yu wönggon maket taitdec ongmuna yagocmai amna au yu ihorocgon komanang woce idung. Idiya yu inong yac tongga inogoc, ‘Son foro yaha komanang sinom idiya sep ibarac?’ ");
INSERT INTO yuw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ihoroc inuna yu mata ökene ingoroc iban imogung, ‘Amna auho youp obmu au manimoc.’ Ihoroc yuya amna morömaho inogoc, ‘Son ihorocgon ongmuya nochon wain öndec youp tarut.’ ");
INSERT INTO yuw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Oro sa urop doboc singbödeuna amna morömaho youp wabkarachon yangtorecno ingoroc inogoc, ‘Goc youp wabkarac ambarac inongyia ehuya wöngnacno impi. Osuc wömai torop mit sinom youpdec ongingma yu wöngnacno impi. Tongo mit torop osuc ongingma yu wöngnacno impi ongga youp osuc sinom forosingma yu madango imontaroc.’ ");
INSERT INTO yuw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ihoroc inuna oro youp wabkarac youp 5 kilok forosigungma yu osuc engmuna wöngnacno möneng wan kina wan kina ihoroc fogidung. ");
INSERT INTO yuw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Fogitbödeuya mit torop youp osuc forosigungma yu ambarac ebung. Yu wömai kombigung ‘nonu wöngnac noni moröma sogiantamon yo’ ihoroc kombigung mahong muno woi. Yu ihorocgon wan kina wan kina worocgon fogidung. ");
INSERT INTO yuw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tongo yu amna morömaha mata metec yongo ingoroc inogung, ");
INSERT INTO yuw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Amna torop ngo yu mit sinom engmuya youpno wan auahon torocgon ting mahong gocho wöngnacno nontho sogiamonma ihorocnogon imparoc. Kombihi, nonu kembot sum sinom forosingga youp moröma sinom tongga iditnaya engga sa dobocsihac. Tongo sepho focogo sinom dimon.’ ");
INSERT INTO yuw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Youp wabkaracho ihoroc inuya youp fano yu mata woroc kombingga youp wabkarac ingoroc inogoc, ‘Oröcna, nocho toroc wontucmuno matot. Non maket taitdec wöngnac soni wan kinadec urop tongkoing tomon. ");
INSERT INTO yuw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Worocha goc wöngnaca ngo sogida ongoi. Noc ihoroc toctocha kombihat, torop madango ehingma yu muyu torop osuc ehingma worocotma wöngnacno tunguhon torocgon fogiarut. ");
INSERT INTO yuw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wöngnac imocimoc woi nakain manomanogon. Nocu amna silipnihong gocho worocha iroda ti obökicha.’ Amna morömaho youp wabkarac ihoroc inogoc.” ");
INSERT INTO yuw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Oro Yesu yu mata tepmo ngo yun bödeuna worochon foroha ingoroc yogoc, “Worochon toroc wömai amna önga madango idangma yu mit mom midim sabarac sadec osuc itnahing. O amna au önga osuc idangma yu wömai mit madango itnahing.” ");
INSERT INTO yuw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Oro, Yesu yu ‘Yerusalem taun ongowa’ yongo uyapdec ongga idoc. Tongo yu youp amnani 12 worocgon yangada sa aramo ökene fongo ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kombiarut, non urop Yerusalem taun öantamon. Öngga woce wömai ayampho Amnahon Manano sogida öret socsochon amna moröma orin nongoru gendic fandat fandat amna dugo yuhon oburodec sinahing. Tuya yuho ‘wuya ompun’ yongo matano yu bödeangoc. ");
INSERT INTO yuw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tongo yu bumbumyi nanohon oburodec siuya amna torop worocho kömec toctocha yu inong saha tongmuya tosipdec woda ep goröcdec wuya omengoc. Oro yu omongga idina sep youp toctoc anfinodec wömai Kopotorocho yu tun wekongga idongungoc,” Yesuho yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Oro, mit Sebedihon mananin worochon macno yu mananin yaima yangauna Yesuot ebung. Tongo macnoho ‘Yesu yapmu auha tongfat nehun’ yongo goruc yemoc tongmuna Yesu dönac inogoc. ");
INSERT INTO yuw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Inuna Yesuho inogoc, “Goc yaöha kombiharoc?” Ihoroc yuna owiho inogoc, “Gocho nakain mananain yai ngo kombing imia yu mom midim sabarac sadec gochon dongnodec idarun. Aumaho aroce o aumaho kandoce. Nocu ihoroc kombihat.” ");
INSERT INTO yuw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesuho mata woroc kombingga mata ökene iban imongga yogoc, “Son yapmu ngo naningma worochon foro tuctugo makombing. Sodu ogep focfoc moröma nocdec öngkuangocma woroc sumbotaha-morocha woha muno?” Yuna yaimaho inogomoroc, “Not ogep sumbotahamot.” ");
INSERT INTO yuw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ihoroc inunya Yesuho inogoc, “Boinno sinom, focfoc youp nocho sumbengotma wo wömai sodu ihorocgon sumbotahamoroc. Wohong numaho sinom nochon arocnehu o kandocne engocma woi nocho angit mayit. Muno, Nandöngna yu urop amna wo erangga abamo tong arangarang tong fingdegoc.” ");
INSERT INTO yuw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Oro youp amna nucni 10 yu yan oröcmaho mata Yesu inogo-morocma woroc kombiuya angit maina inong fadung. ");
INSERT INTO yuw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Inong fauya Yesuho youp amnani inong yuna ehuya mata ingoroc inogoc, “Son bumbumyi nanohon kingnohu o amna dugohu yuhon toroc kiapmo urop kombiang. Yu wömai inoin manogon töngga suraro koingo sinom yangtorengidang. ");
INSERT INTO yuw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Oro, toroc kiap ihorocnoho wömai sonthon bonip sonidec icha. Muno sinom, amna au yu ‘amna moröma itiwa’ yongo kombiantacma yu muyu surarohon mongorec toctoc amna itun. ");
INSERT INTO yuw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","O amna au yu dugo soni iditha kombiantacma yu muyu youp wabkarac soni itun. ");
INSERT INTO yuw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kombiarut, Amnahon Manano yu ‘amnaho mongorec youp tong namarut’ yongo maeboc. Muno, yu wömai guroc owi amna tongfat yecyecha eboc. Tongo yu inoin itonggong imun fauna owi amna koböcma dogu kopothon oburodecma wuuna itonggong koing sogitnahing,” Yesu yu amna moröma idithon toroc kiapha ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Oro, Yesuot youp amnaniot yu Yerikö taun imu fauna onguya owi amna koböcma sinompho yu tan tonggung. ");
INSERT INTO yuw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tuna amna dan komni yai yu uyap tero omoc itmunya kombigomoroc, ‘Yesu urop uyap ngoroc ehantac yo’. Ihoroc kombingga forosingga ecnang mamboc tongo yogomoroc, “Moröma, Devithon Morogo, gocu notha uroc gampun.” ");
INSERT INTO yuw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Amna yaimaho mamboc ecnang ihoroc tongga idinya owi amnaho ‘öpgon idarun’ yongo inong fadung mahong yu kiringga mamboc kararatgon yongo yogomoroc, “Moröma, Devithon Morogo, gocu notha uroci kombihi.” ");
INSERT INTO yuw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ihoroc mambunya Yesuho wo kombingga inong yongo yogoc, “Sodu ‘nocho tingting tong kampiwa’ yongo yamoroc?” ");
INSERT INTO yuw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Inuna yaimaho yogomoroc, “Moröma, ‘gocho dan nodi ti dogihun’ yongo yamot.” ");
INSERT INTO yuw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yunya Yesuho amna yaimaha uroci kombingmuna oburoho daro wot muuna wohogon yu forigomoroc. Tongo yaima yu Yesu tan tonggomoroc. ");
INSERT INTO yuw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Oro, Yesuot youp amnaniot yu Yerusalem taun ambehecgon ongkungga böcsa au mano Betfage woce idung. Böcsa wo wömai Oliv sa urongodec idoc. ");
INSERT INTO yuw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Tuna Yesuho youp amnanin yai ingoroc inongga inong mudoc, “Sodu böcsa wocin ongorun. Tongo woce wömai bot donki macno orin gumbogo kaning ficficyi idinya yaantamoroc. Tongo sot woroc asanmunya nocot yangat febarun. ");
INSERT INTO yuw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Oro amna auho ‘sot ting tamoroc yo’ kanuya wömai sot ingoroc inarun, ‘Morömaho youpno imocimocha yac.’ Ihoroc inunya wömai yu wohogon bot donki wo inong muuna sot yangada nocot ehantamoroc,” Yesuho amna yai ihoroc inuna onggomoroc. ");
INSERT INTO yuw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Oro, yapmu ngorocho öngkubocmaha tongga Kopotorocho yong tuctuc amnahon ducdec mata yogocma worocho boinno öngkuboc. Mata wömai ingoroc itac: ");
INSERT INTO yuw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Yerusalem nano yongburoc mata ingorocno inarut: Aarut! Amna moröma king soni yu sonot epac. Yui amna obingno, yu bot donki beracno koroc itmuna epac.” ");
INSERT INTO yuw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Oro, youp amnanin yai yu ongmunya Yesuho inogocmahon toroc togomoroc. ");
INSERT INTO yuw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yu bot donki yan macno yidecma asanmunya yangat febomoroc. Tongo inoin tecno ubarago fuun deuho donki yan macno koroc yon yun fauya Yesuho woroc koroc öngga idoc. ");
INSERT INTO yuw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tuna owi amna koböcho yu ihorocgon tecnohu borunohu fuu deuya uyapdec yonyu fat tonggung. O owi amna au yu ep betomo ubotmuya uyapdec fing tonggung. ");
INSERT INTO yuw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ihoroc tongga owi amna osucit mitit tuya Yesu yu bonipnodec ong tonggoc. Tongo owi amna ambaracho mamboc tong tongga ap inogoroc yogung: “Devithon Morogonoha yong moröng imona. Kopotorocho ‘nontha’ yongo yu siuna epac. Yui Moröma noni, Kopotorochon guram yudec itun. Yuha yong moröng imona.” ");
INSERT INTO yuw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Oro owi amnaho yong moröng ap ihoroc yongo idiya Yesuho Yerusalem taun öngkuna böc morömpho woroc yangmuya irotno fadang uuya yogung, “Amna ngo numa sinom?” ");
INSERT INTO yuw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tuya owi amna Yesuot onggungma yu ingoroc yogung, “Amna ngoi Yesu. Yui Kopotorochon yong tuctuc amna au, Nasaret taun Galili gurocinma,” ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tuna Yesu yu öret socsoc böchon gombo ganang öngmuna amna woce bisnis youp tongidungma yu ambarac dong yandoc. Tongo amna möneng mongurac tongidungma worochon möneng abamo körengyun muya iric arac tongbödegung. Tongo amna öret socsochon ecec yup kanaröm figungma yuhon abamo ihorocgon koringyun mögung. ");
INSERT INTO yuw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Koringyun muuya ingoroc inogoc, “Kopotorochon babiyadec mata ingoroc irim toctocyi itac: ‘Kopotorochon böc woi surarohon dönac yocyoc böc itun’ “Mata ihoroc irim toctocyi itac mahong sontho tuya kunkun böc ngorocho usem amnaho yoctecno öp ficfic böc simbang öngkungbödehac,” Yesu yu bisnis amna wo ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Oro Yesu yu öret socsoc bucin idina owi amna dan komni orin orungo oburo möng toctocyi koböcma yu Yesot ebung. Ehuya dongyun orokogung. ");
INSERT INTO yuw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ihoroc tongo idina managumboc koböcma yu ihorocgon öret böchon gombo ganang itmuya Yesuha yong moröng ingoroc yong tonggung, “Devithon morogoha borongdeda yong moröng imona!” Ihoroc yong tongo idiya öret socsochon amna moröma orin nongoru gendic fandat fandat amna yu yagungmai Yesuho toroc kiap inobarac sinom tuna managumbocho yong moröng imogung. Woroc yangmuya irotno obukogoc. ");
INSERT INTO yuw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tongo yu Yesu inogung, “Managumbocho ngo gocha mata yangma wo kombiharocha woha muno?” Ihoroc inuya Yesuho mata urago ingoroc iban imogoc, “Öc, noc tuctugo kombihat. Wohong sondec tingting, sonu Kopotorochon bapiyadec mata ngo maembadidangu? Woi ingoroc yac: ‘Kopotorocho tuna managumboc obugu orin mumdecma yu gochon maya yong moröng gamonahing.’” ");
INSERT INTO yuw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesuho mata woroc inongga yu dongyun fauya taunthon gombo sumon ohongga Betani böcsa woce idoc. Tongo yu kumbong wocingon idoc. ");
INSERT INTO yuw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Oro, kembotsum sinom Yesu yu Betani böcsa imun fauna wönggon Yerusalem taundec onggonga uyapdec ongidina worec imogung. ");
INSERT INTO yuw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Worec imuya uyap tero wocin ep fik au idina angga ‘boinno baringga nawa’ yongo forodec öngo agocmai ep wo boinno mafi komong biruc tongga idoc. Yesu yu wo yaun matuya ep fik wo möpmo ingoroc inogoc, “Goc wönggon boinno au mafiiroc.” Ihoroc inuna wohogon ep worocho omong fadoc. ");
INSERT INTO yuw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tuna Yesuhon youp amnani yu woroc angga nangano fauna yogung, “Mayain, tingtinga sinom tuna ep ngo karupgon omong fahac yo?” ");
INSERT INTO yuw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ihoroc yuya Yesuho inogoc, “Nocho boinno sinom kantiwa, son kombing tobic tobic soni itkamuya o son irot yai matoninganu wömai son ogep nocho ep fik ngorocdec tatma sonibut toroc ihorocnogon tup. O worocgon muno, son ogep sa urongo wo inontang, ‘goc idongmina top koroc bangmi muhun’ ihoroc inuya sa urongo worochon torocgon tontac. ");
INSERT INTO yuw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Son yaö manomano sogit sogitha kombingmuya dönacsoni kombing tobic tobicbarac yontanganu wömai son worochon torocgon sogitnahing,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Oro, Yesu yu öret socsoc böchon gombo wocin öngga owi amna-dec fandat fandat youp tongo idina öret socsochon amna moröma orin Israel nanohon amna dugo yu Yesuot engmuya ingoroc inong ac togung, “Numaho ‘youp woroc toi’ yongo ganung muna eparoc? O youp toctochon gesö numaho gamuna tongitaroc?” ");
INSERT INTO yuw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Amna morömaho ihoroc inuya Yesuho mata ingoroc iban imogoc, “Nocu ihorocgon yapmu auha kanong ac towa. Sontho mata iban namuyai wömai nocho ihorocgon numahon gesö sogitmaina youpna tongitatno wo kanontat. ");
INSERT INTO yuw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nanarut, Jöntho owi amna yamuc gung imongidocma wo woi momphon manomanoha woha yu amnahon kombic kombicgon sindanda togoc?” Yesu ihoroc inuna amna morömaho inohogon mata inun ganun tongga yogung, “Oro nontho yonaya woi momphon manomano yo, oro wömai yu ninontac, sonu yaha yu makombing tobing imogung yo? ");
INSERT INTO yuw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Worochoi oro non yonaya woi amnahon kombic kombicgon, wömai suraroho non ayam tong nimontang, yaha owi amna ambaracho Jöntha kombingidang, yui Kopotorochon yong tuctuc amna sinom.” ");
INSERT INTO yuw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Amna morömaho ihoroc inun ganun tongo tu matuna Yesu mata ingoroc iban imogung, “Non makombimon.” Ihoroc inuya Yesuho yogoc, “Oro son ma-naningmaha nocho ihorocgon numahon ma sogitmaina youpna tongitatno wo makanit.” ");
INSERT INTO yuw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesuho Israel nanohon amna dugo wönggon mata au ingoroc inogoc, “Nocho mata tepmo au kanoya kombiarut. Wömai ingoroc: Yomot fani anfi ididung. Itmuya fanoho manano borongomaot ongmuna inogoc, ‘Manana, önga goc ongmina wain öndec youp toi.’ ");
INSERT INTO yuw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ihoroc inuna manano yu fanohon mata kombingga koroc koroc imuna ‘noc mangit’ ihoroc inogoc mahong mit wömai yu kombic kombicno mongurac tongo youpdec onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Oro mit fanoho manano mitmaot ongmuna mata worocgon inogoc. Inuna manano yu ‘öc nandöng, noc ongontat’ ihoroc inogoc mahong yu youpdec manggoc. ");
INSERT INTO yuw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Oro, managumboc numaho wömai fanohon duc sumbodoc?” Yesuho amna moröma ihoroc inong ac tuna yuho yogung, “Mana borongoma.” Ihoroc inuya Yesuho inogoc, “Nocho boinno sinom kantiwa, takis fogit fogit amna orin owi uyapdecma yuho osuc fat kamongo Kopotorochon midim sabarac sadec osuc ongonahing. ");
INSERT INTO yuw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jön yamuc gung imocimoc amna yu sonot engmuna mom midim sabarac sadec onggongon uyap kindagoc mahong sonu makombing tobing imogung. Wohong takis fogit fogit amna imanangni orin owi uyapdecma yu wömai Jön kombing tobing imogung. O sonu yagungmai owi amna wontucmuno yu irotno ibandung mahong son sonibut wömai Jön makombing tobing imogung. O son turongo soni yong tangmuya irot soni maibandung.” ");
INSERT INTO yuw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesuho Israel nanohon amna dugo wönggon mata tepmo au ingoroc inogoc, “Kombiarut! Amna moröma au yu wain ön mögoc. Tongo yu ön gombo temongmun uuna o wain koburo dontot dondothon abamo tobingga o youp amnahon ön angtorec torechon böc ubarago au togoc. Ihoroc tongo yu ‘amna torop auho nakain ön ngo angtorehun’ yongo wain ön wo amna torop au imogoc. Tongo yu inoi böcsa korungon ongga sa ubarago woce idoc. ");
INSERT INTO yuw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Woce idina wain koburo urop gomon dingga idina amna morömaho yogoc, ‘Nocho youp wabkarac au inong muaya yu ongmuya öndec wain koburo nochon fat ficficyi idangma woroc yongga febarut,’ ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tuna youp wabkaracho onguya ön angtorec torec amnaho yu yangga fogit akep tongmuya tunguma wodung, o auma tu omboc, o auma sop monda wodung. ");
INSERT INTO yuw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ihoroc tuya amna morömaho wönggon youp wabkarac torop au koböcma sinom inong muuna onggung mahong ön angtorec torec amna yu toroc kiap wontucmuno osuc torop au tong imogungma wo wönggon amna torop wo tong imogung. ");
INSERT INTO yuw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Ihoroc tuya amna morömaho kombigoc, ‘Nocho manana batip sinom yu inong muaya ongoun. Ihoroc toya wain ön angtorec torec amna yu manana wo angga gending imonahing.’ Amna morömaho ihoroc yuna ");
INSERT INTO yuw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","manano onguna ön angtorec torec amna yu woroc angga yogung, ‘Amna ngorocho wömai mit fanohon guroc öresac ambarac inohagon fogitdup tangoc. Worocha non amna ngo wot omom tontamonanu wömai ön manomano ngo ambarac kömbaha nonthon fat engoc.’ ");
INSERT INTO yuw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ihoroc kombingbödengga manano wo sogitmuya ön gombo sumon tohongmuya wuya omboc.” ");
INSERT INTO yuw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesuho mata tepmo ihoroc yun bödeuna mit amna moröma ingoroc inong ac togoc, “Son tingting kombiang? Mit amna morömaho engmuna ön angtorec torec amna urago tingting sinom tong imangoc?” ");
INSERT INTO yuw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yesuho ihoroc inong ac tuna amna dugoho yogung, “Yu wömai engmuna ön angtorec torec amna wontucmuno woroc dong omom tongo wain ön wo amna torop au imuna yu ön woroc ogepmagon angtorengmuya wain koburo baringga silip tongga amna moröma yuhon fat imonahing.” ");
INSERT INTO yuw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ihoroc yuya Yesuho yogoc, “Son boinno sinom yang, worocha wömai Kopotorochon bapiyadec mata au ingoroc irim toctocyi itac: ‘Sop auha wömai böc toctoc amnaho ‘sop wontucmuno’ yongo tomu onggoc mahong önga wömai Kopotorocho sop worocgon sogitmuna tong koing tong imuna sop worocho böchon forodongno sinom öngkupac. Nonu toroc kiap wo anaya ogepma sinom itac.’ ");
INSERT INTO yuw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Worocha wömai nocho ingoroc kantiwa, Kopotoroc yu mom midim sabarac sa wo sonthon obu sonidecma fuun deuho owi amna torop au imangoc. Tuna torop worocho wömai boinno ogepma finahing. ");
INSERT INTO yuw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Oro amna au yu sop Kopotorocho tong koing togocma woroc koroc möantacma yu wömai obökangoc. O sop worocho möngga amna au wuna wömai yu obukongbödeangoc.” ");
INSERT INTO yuw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Oro Yesu yu mata tepmo woroc yongbödeuna öret socsoc amna dugo orin Farisi yu mata woroc kombingga tuctugo kombigung, ‘Yesu yu nontha yac yo’. ");
INSERT INTO yuw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Worocha tongga yu Yesu sogit akep toctocha kombigung mahong yu suraroha botogung. Suraro yu wömai Yesuha kombingidung, yui Kopotorochon yong tuctuc amna au. ");
INSERT INTO yuw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Oro, Yesu yu Yuda nanohon amna moröma wönggon mata tepmo au ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Mom midim sabarac sahon kiap wömai ingoroc, amna moröma au yu mananoha owi tong sicsichon tong sonoc moröma tong arangarang togoc. ");
INSERT INTO yuw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tongo yu youp wabkaracni inong muuna ongga amna morömaho ma torop sigocma worochon toroc owi amna inong wodigung mahong amna torop wo yu tungyu möcmöc mata koböc dongyu öngkuuya ‘muno’ yogung. ");
INSERT INTO yuw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ihoroc tuya amna moröma yu wönggon youp wabkaracni torop au inong muto inogoc, ‘Son ongmuya amna torop nocho inong wodigotma yu wönggon inarut, nacno urop arangarang yongbödec. Bulmakau amnano orin bulmakau beracno moröma wo urop dong socsocyi idang. O tong sonochon manomano au woi ambarac tong arangarang yongga idang. Worocha son karupgon engmuya oimnahon tong sonoc ogepma woroc naarut.’ ");
INSERT INTO yuw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Oro amna moröma yu youp wabkaracni ihoroc inuna ongmuya mata woroc owi amna torop wo inong tonggung mahong yu wönggon ebepha makombigung. Oro amna au yu ön youpha onggoc o amna au yu bisnis youp toctocha onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","O amna torop au yu amna morömahon youp wabkaracni fogito toroc wontucmuno tong imongmuya dou ombung. ");
INSERT INTO yuw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ihoroc tuya amna morömaho worochon fatno kombingga irot kombut tongo tawa amnani inong muuna ongmuya usem wabkarac torop wo dongbödengmuya yuhon böcsano suya dingbödegoc. ");
INSERT INTO yuw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ihoroc tuya mit amna morömaho youp wabkaracni mata ingoroc inongo inong mudoc, ‘Oimna wegohon tong sonoc urop tong arangarang tongo itac mahong amna torop osuc inong yogotma yu amna wontucmuno, yui nacno nocnochon toroc muno. ");
INSERT INTO yuw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Worocha son wönggon ongmuya uyapdec amna morömahu o amna komanangnohu yu ambarac inong yuya engmuya tong sonocdec nacno naarut.’ ");
INSERT INTO yuw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Amna morömaho ihoroc inuna youp wabkaracniho uyap uyap ongmuya owi amna ogepmahu o wöntucmunohu wo ambarac inong yuya nacno nocnocha engmuya böc foc tocno sinom togung. ");
INSERT INTO yuw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Böc foc tongo idiya amna moröma yu owi amna wo yacyacha böc ganang öngmuna agocmai amna au yu tec tohomumöcno sacsago oimna wego toctochon wo matongfai idoc. ");
INSERT INTO yuw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tuna amna morömaho yu inogoc, “Oröc, goc tingtinga tec tohomumöca ogepma matongfai eparoc?” Inuna amna worocho mata uragoha yabiun matogoc. ");
INSERT INTO yuw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tuna amna morömaho youp amnani inogoc, “Son amna woroc sogitmuya orung oburo song fetho tomu sumon kumbongnodec woce ohoun. Sa kumobongnodec woce wömai yong oin toctocno orin agem gigorot tongga idang.” ");
INSERT INTO yuw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu yu mata tepmo ihoroc yongbödengga mata sakaun fiuna yogoc, “Kombiarut, Kopotoroc yu owi amna koböcma inong yongitac mahong amna tungu tunguhogon wömai matano kombingga yuot ongidang.” ");
INSERT INTO yuw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Oro Farisi yu Yesu mata youpdec tohong yucyuchon yong yabic yabic morö tongga yogung, ‘nonu tingting sinom tonaya Yesuho mata au kandöc yuna mata youpdec tohong yuantamon yo’. Oro yu ihoroc yongga ingoroc togung. ");
INSERT INTO yuw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yu inoin toropdecma amna au soworeuya worocho ongga Heröthon toropdecma amna au worocot kondong singo Yesuot ongmuya tonguc yecyec mata ingoroc inogung, “Fandat fandat amna nonu gocha kombiamon, gocu yapmu auha kombiiya ogep idinai wömai gocu worochon torocgon tongitaroc. O gocu Kopotorochon toroc kiapmo nongnongogon fandat ninongitaroc. O gocu amna auha mabotongitaroc. Muno, goc mata tungu gocho kombiiya angit idina worocgon wömai amna morömahu o amna komanangnohu yu ambarac inongitaroc. ");
INSERT INTO yuw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Worocha wömai goc tingting kombiharoc, nontho ogep Sisa King yu takis möneng imontamontha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ihoroc inuya Yesuho yuhon imanang kiapmo urop angtangtang tongo mata urago ingoroc iban imogoc, “Son imanang amna, son foro yaha noc tonguc neang. ");
INSERT INTO yuw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Son takis möneng fing-idangma worochon möneng docno au nindauya awa.” Ihoroc inuna yu möneng docno au tengga imogung. ");
INSERT INTO yuw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tuya Yesuho inong ac tongo yogoc, “Möneng ngodec doguno orin ma irim toctocyi itacma ngomai numahon?” ");
INSERT INTO yuw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ihoroc inuna yuho yogung, “Woi Sisa King yuhon.” Yuya Yesuho inogoc, “Oro worocha sonu Sisahon fat wömai Sisaha imarut. Wohong Kopotorochon fat wömai Kopotorocha imarut.” ");
INSERT INTO yuw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yesu ihoroc yuna yu mata woroc kombingmuya nangano fauna Yesu imu fauna onggung. ");
INSERT INTO yuw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Oro sep bongono worochogon Sadyusi amna auho Yesuot ebung. Amna torop Sadyusi yu wömai kombingidung, amna omomyi yu wönggon mawekoning. Oro yu Yesuot engmuya ingoroc inong ac togung, ");
INSERT INTO yuw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Fandat fandat amna, osuc wömai Möseho ingoroc ninogoc, ‘Amna au yu managumbocno muno ida omunai wömai orugoho ‘oröcnahon morögo ta öngkupun’ yongo worochon oweno tong sihun. ");
INSERT INTO yuw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oro nonthon bonip nonidecma yomot oröc 7 yu idung. Itmuya orugo borongoma yu owi au tong singga managumbocno muno ito omong fadoc. Tuna orugo mitmaho owi worocgon tong sigoc. ");
INSERT INTO yuw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tongo orugo mitma yu ihorocgon managumbocno muno ito omong fadoc. Tuna orugo au yu ihorocgon togoc. Ihorocgon tong tongga idiya orugo madango yuho owi wo tong singga omboc. ");
INSERT INTO yuw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tuna mit wömai owi ihorocgon omong fadoc. ");
INSERT INTO yuw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Oro worocha goc tingting kombiharoc? Yomot oröc 7 yu ambarac owi wo tong sigungmai. Worocha mit bongono morödec omimaho idongonahingan bongono wocin wömai owi wo numahon oweno sinom engoc?” ");
INSERT INTO yuw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ihoroc inuya Yesuho mata urago ingoroc iban imogoc, “Son Kopotorochon bapiyadec mata idangma orin Kopotorochon gesö moröma wo makombing. Worocha tongga kombic kombic soni kandoc ongbödegoc. ");
INSERT INTO yuw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Owi amnaho omocdecma idongonahingan bongono wocin wömai yu owi wönggon mayongfining. Muno, yu wömai momphon sum yaru simbang itnahing. ");
INSERT INTO yuw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Oro Kopotorocho omimaho wönggon idongonahingmaha wömai mata au kanogoc. Sonu wo makombinghu nuhun? Yu ingoroc yogoc: ");
INSERT INTO yuw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nocu Abraham, Aisak, Jeköp yuhon Kopotoroc.’ Yu ihoroc yogocmaha non kombiamon, Kopotoroc yu amna omimahon Kopotoroc muno yu amna wecimahon Kopotoroc.” ");
INSERT INTO yuw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yesuho mata woroc yuna owi amnaho kombingmuya nanga fatfat morö togung. ");
INSERT INTO yuw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Oro Yesuho Sadyusihon matano dogo ubodoc. Tuna Farisi yu mata woroc kombingga suran tongo Yesuot ebung. ");
INSERT INTO yuw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Engmuya yudecma amna tungu au yu wömai nongoruhon mata docno obugu obugu wo ambarac kombingdup togoc. Amna wo yu Yesu tonguc yengo ingoroc inong ac togoc, ");
INSERT INTO yuw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Fandat fandat amna, Möseho nongoru nimogocma worocdecma yaö nongoruho moröma sinom itac?” ");
INSERT INTO yuw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ihoroc inuna Yesuho inogoc, “Nongoru ngo woi moröma sinom: ‘Son irot soni Kopotorocha boging imarut, yu woi Moröma noni. Son irot sonihu o yaru sonihu o kombic kombic sonihu wo ambarac yuha tong fup imongitnung.’ ");
INSERT INTO yuw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nongoru ngorocho wömai nongoru au yanggiratdup tongga moröma sinom itac. ");
INSERT INTO yuw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","O worochon torocgon wömai nongoru au ingoroc: ‘Goc gakaha kombingitarocma worochon torocgon nucaha kombingidiruc.’ ");
INSERT INTO yuw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nongoru yai ngorocho wömai nongoru au idangma orin Kopotorochon yong tuctuc amnaho mata yongidungma worochon forodongno sinom idamoroc,” Yesu yu nongoru morömaha ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Oro Farisi yu wocegon suran tongo idiya Yesu yu ingoroc inong ac tongo inogoc, ");
INSERT INTO yuw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Son Duicha tingting kombiang? Yu numahon manano?” Ihoroc inuna Farisiho inogung, “Yu woi Devithon morogono.” ");
INSERT INTO yuw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ihoroc yuya Yesu yu wönggon ingoroc inong ac togoc, “Worochai oro, foro tingtinga Devitho Kunkun Yaruhon gesödec Duicha yogoc, ‘yu Morömana’. Yu wömai ingoroc yogoc: ");
INSERT INTO yuw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Kopotoroc yu nochon Morömana ingoroc inogoc, ‘Goc nochon arocne omoc idia ongga nocho gochon ayamaihon gesöno fohongga gochon unenne fohong yuangot.’ ");
INSERT INTO yuw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Oro Devit inobut Duicha yogoc ‘yu nochon Morömana.’ Worocha Duic yu tingting sinom Devithon morogono in?” ");
INSERT INTO yuw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesu yu Farisi mata orogoma ihoroc inuna yu mata urago yabiu matuna öpgon idung. Oro bongono wocin forosingga amna ambaracho Yesu yapmu auha inong ac toctocha botogung. ");
INSERT INTO yuw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Oro mit Yesu yu suraro orin youp amnani inogoc, ");
INSERT INTO yuw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Boinno sinom, nongoru gendic fandat fandat amna orin Farisi yu wömai Mösehon abamo sogida surarodec fandat fandat youp tongidang. ");
INSERT INTO yuw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Worocha tongga sontho yuhon mata sumboditnung. O yu manomano kanongidangma worochon toroc itongitnung. Wohong son soni woho, sonu yuhon toroc kiap wontucmuno wo tanninga. Yu wömai mata ogepma fandat kanongidang mahong yu ino wömai worochon toroc maitongidang. ");
INSERT INTO yuw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Muno sinom, yu wömai suraro mepmo moröma sinom imuya suraroho wo sumbot sumbotha sorec tongidang mahong Farisi yu oburo sirago tungugon sinom mepmo woroc sumbot sumbotha matongfat yengidang. ");
INSERT INTO yuw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Muno sinom, yu youpno manomano ambarac ‘amnaho ningga fat tarut’ yongo ihorocnogon tongidang. “Yu wömai dönac yocyochon yino moröma tobingga ‘amnaho aarut’ yongo oburodec akep tongidang. O moru yupyupyi ubarago dönac yocyochon tec mondopmodec akep tongyu muuya wodi wodiho fogidtongidang. ");
INSERT INTO yuw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","O tong sonocdec wömai yu amna morömahon omoc idit abam sogit sogitha toup kombingidang. O fatmata yocyoc bucin wömai yu amna morömahon abam ididangma woroc sogida omoc ididang. ");
INSERT INTO yuw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","O ihorocgon maket taitdec ‘owi amnaho sep ogep orin fandat fandat amna moröma ninarut’ yongo toup kombingidang. ");
INSERT INTO yuw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Oro Farisi orin nongoru gendic fandat fandat amna yu ihoroc tongidang mahong sonidecu wömai kiap ihorocno icha. Kopotoroc yu tungugon wömai Moröma soni itac. Worocha tongga owi amnaho son ‘moröma noni’ ihoroc kanoninga. Sonu wömai nip oröcgon, amna kiap tungu. ");
INSERT INTO yuw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","O ihorocgon gurocdec ngocin wömai sonu amna auha ‘nandöng noni’ ihoroc inoninga. Muno sinom, Nandöng soni tungugon wömai momdec itac. ");
INSERT INTO yuw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","O ihorocgon amna auho son ‘fandat fandat amna moröma’ ihoroc kanoninga. Wömai yaha sonthon fandat fandat amna moröma soni tungugon itac. Woi Duic, Kopotorocho yu owi amnani fogit fogitha soworegocma woroc. ");
INSERT INTO yuw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","“Oro sondecma numaho amna moröma soni entacma yu wömai sonthon mongorec tong kamoc kamoc soni itun. ");
INSERT INTO yuw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Amna au yu inoin mano onoce töantacanu wömai mit Kopotorocho yu omocene sinom tohong yuangoc. Wohong amna au yu ‘amna auhon mongorec tong impiwa’ yongo kombiantacanu wömai mit Kopotorocho yu onoce töng yuangoc.” ");
INSERT INTO yuw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesu yu mata sakaun fiuna ingoroc yogoc, “Son nongoru gendic fandat fandat amna orin Farisi son soni woho. Mata soni orin toroc kiap soni woi yaitni, imanangni. Son mom midim sabarac sahon simbuno owi amna song imongidang. Son soni woce mangoning mahong sonu owi amnaho woce onggonga toup kombiangma yuha bongbong sing imuya yu ihorocgon sa woce mangoning.” ");
INSERT INTO yuw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Son nongoru gendic fandat fandat amna orin Farisi son soni woho. Son amna imanangni. Sonu owi kapi unac mata inong yuuya yuho böc yoctec manomanono kamuya sonu wo soniha fogiuya yu uroci ididang. O son ‘owi amnaho niarut’ yongo dönac ubarago yongidang. Worocha wömai Kopotorocho son urago mepmo sinom kamangoc.” ");
INSERT INTO yuw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Son nongoru gendic fandat fandat amna orin Farisi son soni woho. Son amna imanangni. Son mongmut tongo topdechu o guroc uyapdechu woce itongga ‘amna auho duc noni sumboda nonthon torop nonidec sakau fihun’ yongo itongidang. Tongo amna auho mata soni kombing tobinggai wömai worocho son simbang ep bohönghon fat engoc. O amna worocho wömai soni ambarac kanggiratdup tongmuna toroc kiap wöntucmuno toup sinom tong tongungoc.” ");
INSERT INTO yuw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Son dan komni, son amna uyap indac indacha tongidang mahong sonian woi dan komni idang. Son soni woho! Son ingoroc yongidang: Amna au yu matano öret socsoc böcdec tong koing tontacma kiapmo woroc woi yapmu boyömo. Wohong amna au yu matano öret socsoc böchon goldecma tong koing tontacanu wömai matano boinno sinom koing sontac. Tuna yu muyu worochon torocgon toun. ");
INSERT INTO yuw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mayain, son amna bumbumyi orin dan soni kom toctocyi. Kombiarut, yaö sinompho wömai Kopotorocho yangamin moröma itac? Öret socsoc böchon golhu o öret socsoc böc ino worochu. Kombiarut, gol woi yapmu boyömohong worocho öret socsoc bucin itacmaha tongga wo Kopotorochon fat itac. Wohong öret socsoc böc wo wömai Kopoto-rocho tuna kunkun itac. ");
INSERT INTO yuw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“O ihorocgon sontho yongidang, amna au yu matano altadec tong koing tontacma woi yapmu boyömo. Wohong amna au yu matano yapmu ecec alta koroc itacma worocdec tong koing tontacma amna worochon matano wömai koing sontac. Tuna yu muyu worochon torocgon toun. ");
INSERT INTO yuw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mayain, son amna dankomni. Kombiarut, yaö sinompho wömai Kopotorocho yangamin moröma itac? Yapmu ecec alta koroc itacma worochu o alta inohu. Alta yu tuna ecec wo Kopotorochon fat entac. Worocha tongga alta ino woi yapmu moröma. ");
INSERT INTO yuw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Amna au yu matano altadec tong koing tontacma yu wömai altadecgon yong koing mayic. Muno, yu ihorocgon ecec alta korocdec itacma worocdec yontac. ");
INSERT INTO yuw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","O amna au yu matano öret socsoc böcdec tong koing tontacma yu wömai öret socsoc böcdecgon yong koing mayic. Muno yu ihorocgon Kopotoroc öret socsoc bucin itacma yuhon madec yong koing yontac. ");
INSERT INTO yuw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","O ihorocgon amna au yu matano momdecha tong koing tontacma yu wömai Kopotorochon abamodec yong koing yontac. O worocdecgon muno yu wömai Kopotoroc abam worocdec itacma yuhon madec yong koing yontac. ");
INSERT INTO yuw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Son nongoru gendic fandat fandat amna orin Farisi son soni woho. Son amna imanangni. Sonu yapmu obuguha ‘moröma itac’ yongo ingoroc tongidang: Öndecma nacno obugu anianthu römbohu o kumhu woroc fengga silip tongo docno ten fingmuya docno tungu ‘Kopotorochon fat itun’ yongo tongidang. Worochoi oro yapmu moröma wömai edet kamongidang yo. Woi suraro toroc kiap nongnongo imocimoc kiap, o amna nucni yang banac banac kiap o nuc soni tong fat yecyec kiap. Son muyu nacno docno soni Kopotorocha imocimoc kiap orin owi amna tong ogep tong imocimoc kiap yait yait woroc tongitnung. ");
INSERT INTO yuw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Son amna au uyap indac indacha yang yo, wohong son soniu dan kom toctocyi. Son kairong obugu tanac yamucdec itacma woroc angmuna tomu ongitac, mahong bot kamele moröma wo wömai sonu nango merongmun möngitac. ");
INSERT INTO yuw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Son nongoru gendic fandat fandat amna orin Farisi son soni woho. Son mata soni yaitni o toroc kiap soni woi usemni. Son sonihagon kombingmuya suraro matongfat yengidang. Son kap feret betni woroc simbang. Kap godibo wömai song sac tuya sacsago sinom itac, mahong kap irotno masong sac tuya betni iditac. ");
INSERT INTO yuw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mayain, goc Farisi dara komni. Kombihi, goc osuc kap irotno song sac ogepma sinom tia oro mit wömai godiboi ihorocgon sacsago engoc. ");
INSERT INTO yuw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Son nongoru gendic fandat fandat amna orin Farisi, son soni woho. Son imanang amna. Kombiarut, amna fiiyan wömai owi amna simen gangga kala föhöcmaho wagango fiuya owi amna auho wo auya ogepma sinom iditac. Wohong kumkumon ganango wocin wömai amna omomyima worochon kudatnohu o manomano betnihu worocho foc tongga ididang. Oro son Farisi, sonthon toroc kiapsoni wömai ihorocnogon. ");
INSERT INTO yuw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Worocha tongga godip soniha wömai owi amnaho son kangga kombingidang son amna nongnongo sinom. Wohong irot sonidec wömai imanangon toroc kiap orin nongoru fodic fodichon kiap worocho foc tongga ididang. ");
INSERT INTO yuw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Son nongoru gendic fandat fandat amna orin Farisi, son soni woho. Sonu Kopotorochon yong tuctuc amnahon kumkumon ganango ogepma sinom tobingidang. O ihorocgon sonu amna nongnongohon kumkumon simen tong fauya ogepma sinom ididang. ");
INSERT INTO yuw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","O sonu ingoroc yongidang: Nonu ombu sakung nonihon bongonodec wocin yuot kondonggon itongonamma wömai nonu Kopotorochon yong tuctuc amna tongfat yenaya ombung sakung noniho yu madong omom tup. ");
INSERT INTO yuw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Oro, mata soni worocho wömai ingoroc nindahac. Son soni wömai Kopotorochon yong tuctuc amnani dopdop amna worochon morogoni. ");
INSERT INTO yuw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Worocha tongga son ombu sakung sonihon toroc wontucmuno woroc sakau fiuna moröma sinom engoc. ");
INSERT INTO yuw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Son ibic wontucmuno, o son goromphon manani. Sonu ting tongga Kopotorocho son ep bohöng mafongyun möning? ");
INSERT INTO yuw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kombiarut, noc amna torop au inong muaya sonot epnahing. Woi yong tuctuc amnahu o amna kombic kombicno ogepmahu o fandat fandat amna ogepmahu yu sonot epnahing. Ehuya sontho yuhon toropdecma au fogida douya omonahinghu o au ep goröcdec wotnahinghu o au wömai fatmata yocyoc böcsonin woce yangat föngga tosipdec fic uropnahinghu o au wömai son böcsa sonidecma yaruya botongga böcsa auhon ongonahing. Woce idiya sonu yu wönggon böcsa wodec yaruya böcsa auhon onguya ihoroc ihoroc tong imonahing. ");
INSERT INTO yuw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Worocha tongga ombu sakung soniho amna nongnongo douya ombungma yuhon nogotnoho wömai sonthon bic sonidec engoc o ombu sakung sonihon turongoho sondec itnahing. Forosingga amna nongnongo Abel yudecma engga Sakaraia Berekiahon manano yudec. Sakaraia yu wömai Kopotorochon böc orin alta worochon bonipnodec idina ombu sakung soniho yu wuya omboc. ");
INSERT INTO yuw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nocho boinno sinom kanoya kombiarut. Tong bumbum ngorochon wöngnacno wömai owi amna önga idangma yudec öngkung imangoc.” ");
INSERT INTO yuw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesu yu mata sakaun fiuna yong uroc mata ingoroc yogoc, “Yerusalem Yerusalem, gochon owi amna yu Kopotorochon yong tuctuc amna dong omom tongidang. O amna Kopotorocho inong muuna gocot engidangma yudec wömai böc morömpho sop monda douya omongidang. Oro fup macnoho gumbogo fotno une fengsuran tongitac worochon toroc wömai nocho bongono bongono Yerusalem owi amna feng suran toctocha kombingidot mahong yu nochon mata makombingidung. ");
INSERT INTO yuw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aarut, taun soni wo obukongga komanang engoc. ");
INSERT INTO yuw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nocho boinno sinom kantiwa, sontho nochon yangamna wönggon manaigon itmuya ongga son ingoroc yonahing: ‘Kopotorocho amna au inongmuna epac. Yuhagon wömai nonu yong moröng imona.’” ");
INSERT INTO yuw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu yu öret socsoc böchon gombo imun fauna ongidina youp amnaniho ‘öret socsoc böchon kiapmo ogepma sinom tobic tobicyi woroc indana’ yongo yuot ebung. ");
INSERT INTO yuw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tuya Yesuho mata ingoroc iban imogoc, “Aarut, böc ngo woi ogepma sinom. Wohong nocho boinno sinom kantiwa, mit wömai böc worochon sop au nucno koroc wönggon maitning. Muno, sop worocho ambarac dondot morop morop tongo fonyun woce woce ongbödenahing.” ");
INSERT INTO yuw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Oro Yesu yu Oliv sa urongodec idina youp amnanihogon yuot engmuya ingoroc inong ac togung, “Ninti, mata osuc yorocma worocho wömai yaö bongonodec boinno öngkuangoc? O ihorocgon toroc kiap tingtingno sinom engkuuya nonu wo yangmanaina ingoroc kombiantamon, gocu urop ehantaroc o ihorocgon guroc ngorochon bödec bödecno urop eng fomtac.” ");
INSERT INTO yuw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Youp amnaniho ihoroc yuya Yesuho mata urago ingoroc iban imogoc, “Kombiarut, imanang amna koböcmaho nochon ma sogida engmuya ingoroc kanonahing: ‘Nocu ngoroc, Kopotorocho inoin owi amnani fogit fogitha siuna ebotma woroc.’ Ihoroc yongo owi amna koböcma tonguc yenahing. Worocha son soniha kombic kombicho itongitnung. Amna auho tonguc keuya son gorong ongoningyit. ");
INSERT INTO yuw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“O sonu emoc dirung morömahon kikoröpno orin sum matano kombinahing. Wohong son worocha soroc yoninga. Muno, Kopotorocho ‘toroc kiap ihorocnoho öngkupnahing’ yongo yong torop singdegoc. Singdeuna manomano worocho engkungbödenahing mahong guroc ngorochon bödec bödecno woi abe maic. ");
INSERT INTO yuw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Muno, osuc wömai kantri auho öngkungmuya kantri auot emoc tonahing. O ihorocgon king auhon toropniho öngkungmuya king auhon toropniot emoc tonahing. “O ihorocgon sa woce woce wömai nacno möp öngkupnahing orin konoc fennahing. ");
INSERT INTO yuw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kiap ihorocho wömai guroc ngorochon bödec bödecnohon forosicsicno. Woi owiho managumboc bacbacha focfoc kombingidangma woroc simbang. ");
INSERT INTO yuw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Oro, mit wömai owi amnaho son fogida kuya omong fatnahing. O ‘nocha’ tongga guroc ngorochon owi amna ambaracho sontha ayam tong kamonahing. ");
INSERT INTO yuw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bongono wocin wömai owi amna koböcmaho kombing tobic tobicno imu faangoc. Tongo yu nucnoha ayam tun tun tongo ino ayamphon oburodec fohong yun yun tonahing. ");
INSERT INTO yuw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“O ihorocgon profet imanangni koböcmaho öngkuya owi amna koböcma tonguc imuya sing kapnahing. ");
INSERT INTO yuw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tongo toroc kiap wontucmunoho toup öngkung morogic tangocmaha tongga owi amna koböcmaho nucnoha irot imocimoc kiap wo imu faangoc. ");
INSERT INTO yuw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wohong owi amna mepmo bongono wocin koing songga kombing tobic tobicno maimu faicma yu wömai Kopotorocho wontucmunodecma öcangyun muuya itonggong koing imangoc. ");
INSERT INTO yuw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","“O mom toboruchon fatmata ogepma worocho wömai sa guroc danong ongbödeangoc. Tuna owi amna ambaracho Yesuhon fatmata ogepma kombinahing. Tuna mit wömai guroc ngorochon bödec bödecno engoc.” ");
INSERT INTO yuw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Oro son mata ngo kombic kombicbarac embaarut! “Kopotorochon yong tuctuc amna Daniel yu osuchagon yogoc, yapmu wontucmuno sinom worocho engkungmuna Kopotorochon öret socsoc böc tun mointuna yapmu boyömo engoc. ");
INSERT INTO yuw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Oro yapmu wontucmuno woroc engkuuna anahinganu wömai owi amna Yudia gurocin itnahingma yu wohogon sa wo ibaru fauna karupgon sa urongodec öngbödenung. ");
INSERT INTO yuw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","O owi amna au böc amante itnahingma yu wohogon botongga sa korungon ongonung. Yu wömai ‘yoctec manomano fogitna’ yongo wönggon böcno ganang uninga. ");
INSERT INTO yuw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","O owi amna öndec itnahingma yu ibaru fauna böcnon engga tecno fogit fogitha kombininga. Muno yu muyu wohogon sa korungon ongonung. ");
INSERT INTO yuw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Öwec uroci morö, bongono wocin wömai owi mana modibnima orin managumbocno mum imongo itnahingma yu mepmo moröma sinom au feangoc. ");
INSERT INTO yuw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","21","“Bongono wocin wömai mepmo inobarac moröma sinom öngkuangoc. Mepmo ihorocnoma wömai sa gurochon forosicsicnodec singga engga bongono önga idamonan abe maöngkungidoc. O ihorocgon mit wönggon maöngkuic. Worocha son ‘yapmu wontucmuno worocho sum bongonodechu o Sabat bongonodechu öngkuicyit’ yongo dönac youp tarut. ");
INSERT INTO yuw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mepmo bongono worocho sa ubarago idinai wömai owi amna ambaracho omong faup. Wohong Kopotoroc yu owi amna inoha soworegocma yuha kombingga bongono wo tong docut tangoc. ");
INSERT INTO yuw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Oro bongono wocin wömai imanang amna auho ingoroc kanonahing: ‘Kopotorochon Duic yu ngocin itac!’ O ‘ogocin itac yo!’ Ihoroc kanuyai sonu yuhon mata kombing tobininga. ");
INSERT INTO yuw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Amna auho engmuya imanang yongo kanonahing, ‘noc ngoroc Kopotorochon Duic!’ O auho ingoroc kanonahing: ‘Noc Kopotorochon yong tuctuc amna au yo!’ Ihoroc yongmuya youpno gesöbarac tongo orin toroc kiap inobarac sinom tuya yanahing. Yangga kombic kombicno gorong ongonahing. Wohong owi amna Kopotorocho inoha soworegocma yu wömai ihorocgon imanang amna wo yangmuya irot yai kombinahing mahong Kopotorocho yu irot tong koing tong imuna magorong ongoning. ");
INSERT INTO yuw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“Kombiarut! Yapmu wontucmuno wo abe maöngkui idina nocho worochon yong tuctucno urop önga kanongdehat. ");
INSERT INTO yuw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Worocha woroc, amna auho kanontac, ‘Duic yu sa amna munon ogocin itac yo.’ Ihoroc kanunai sonu woce ongoninga. O auho kanontang, ‘Yui böc ngorochon irotnon öp itac yo!’ Ihoroc kanuyai son matano kombing tobininga. ");
INSERT INTO yuw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Amnahon Mananohon ebepno wömai undip wari warihon toroc eran sinom engoc. Undip wari wari yu sep öngkup öngkupin wariantacma wömai yagunoho ongga sep ohonggongin ongun möngitac. Worochon torocgon wömai Amnahon Mananoho ehuna owi amna ambaracho tuctugo angbödenahing. ");
INSERT INTO yuw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kombiarut, arap omimaha tongga koc-kocho engga ugodiian suran tongidang.” ");
INSERT INTO yuw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Oro, mepmo bongono morö worocho bödeuna mit ‘sep daro kumbong diangoc. O yarop maforii ida yagunono mamuic. O fitnung yu wömai abamo imu fauna möngbödenahing. O ihorocgon mom muruc muruchon gesöno mongurac tongo fendup tonahing.’ ");
INSERT INTO yuw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tuya bongono wocin wömai Amnahon Mananohon werano momdec öngkuuna guroc owi amnaho kantri wohon wohon idangma yu wo angmuya yong yaing tongonahing. Tongo yu anahingmai Amnahon Manano yu yaguno gesönobarac mitimoni sinom ihoroc mom muruc muruc korocma engkuangoc. ");
INSERT INTO yuw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Engkuna baro mano orongi sinom yongga idina Amnahon Manano yu sum yaruni inongmuna yu mom sa guroc danong ongmuya inoin owi amnani yango fogito fengsuran tonahing. ");
INSERT INTO yuw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Oro, sonu ep fikhon toroc kiap angmuya kombic kombic ingoroc sogiarut: Betomo yamugoni idiya sakemo biruc tuya sontho wo angga kombiantang, sep bongono urop ehangoc. ");
INSERT INTO yuw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Oro worochon torocgon sontho manomano woroc yangmuya kombinahing, Amnahon Manano yu urop böc simbun ambehecgon itac yo. ");
INSERT INTO yuw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nocho boinno sinom kantiwa, amna önga ngocin idangma yuhon morogoni abe mabödengidiya manomano yatma ngoi ambarac öngkungdup tonahing. ");
INSERT INTO yuw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mom sa guroc yu wömai bödetahamoroc mahong nochon mataho koing songga iditnoho iditno edengoc,” Yesu yu inoin engkup engkup bongonoha mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yesu yu mata sakaun fiuna ingoroc yogoc, “Manomano worochon öngkup öngkup bongono sinom wömai amna auhu o momphon sum yaru auhu o Mananohu, non ambarac makombimon. Nandöng noni ino tunguhogon wömai kombihac. ");
INSERT INTO yuw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Amnahon Mananoho ehangocan bongono wocin wömai owi amnaho toroc kiap Nöahon bongonodec tongidungma worochon torocgon tongga itnahing. ");
INSERT INTO yuw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yamuc öngkorop morömaho abe maöngkui idina owi amna yu etno itmuya yamuc nacno nongo ididunghu o owi imun gamun tongo ididunghu. Yu ihoroc tongga idiya Nöa yu girang ganang ögoc. ");
INSERT INTO yuw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Uuna owi amna yu yapmu moröma ihorocno yudec öngkup öngkupha tacno woi makombigung. Muno, yui etno idiya komöc yamuc öngkoropho engo owi amna woroc yaun wetdup togoc. Toroc kiap worocotmagon wömai Amnahon Mananohon ebep bongonodec engoc. ");
INSERT INTO yuw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Bongono wocin wömai amna yai öndec idinya Amnahon Mananoho engmuna auma sogida auma imun faangoc. ");
INSERT INTO yuw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","O owi yai yu wit yitno songdup songdup tongo idinya yu engmuna auma sogida auma imun faangoc. ");
INSERT INTO yuw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Oro, sontho Moröma sonihon ebep bongono makombiingmaha tongga son muyu gön tongga acacho itongitnung. ");
INSERT INTO yuw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kombiarut, böc morömpho usem amnahon ebep bongono tuctugo kombinggai wömai yu gön tongga idina usem amnaho böcno magumaric. ");
INSERT INTO yuw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","O worochon toroc son ihorocgon bongono muno gön tongga arangarang yongga iditnung. Wömai yaha, sonu yontang, ‘yu maehic’ mahong bongono wocingon sinom wömai Amnahon Manano ehangoc,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesuho matano sakaun fiuna mata tepmo au ingoroc yogoc, “Oro, amna moröma yu inoin youp wabkaracni soworengga youp wabkarac kombic kombicno ogepma orin youpno gacigon tongitacma yugon wömai youp morömaha soworengga youp mata ingoroc inontac: ‘Gocu youp wabkaracnai ambarac yangtorengga idiruc. Gocho yu bongono muno yamuc nacno inoin inoin torocdec silip tong imiruc,’ amna morömaho youp wabkarac ogepma wo ihoroc inontac. ");
INSERT INTO yuw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Inong-ga sa korungon ongga wönggon ibarun fauna böcnon engmuna auna youp wabkaracnoho youpno ogepma sinom togoc. Tuna amna morömaho youp wabkarac ihorocnomaha irot ogep tong imuna borongdetno sinom tontac. ");
INSERT INTO yuw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nocho boinno sinom kantiwa, amna moröma yu wömai böcnohu o yoctecnohu o manomano ambarac idimangma wo youp amna ogepma worochon oburodec fiuna yu wo ambarac yangtoreantac. ");
INSERT INTO yuw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Wohong youp wabkarac worocho ‘amna morömaho karupgon maehic’ yongo forosingga toroc kiap wöntucmuno tongmuna ");
INSERT INTO yuw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","youp wabkarac nucni dong mong kengga amna wöntucmuno ot itmuna nacno wain bia toup nangmuna in. ");
INSERT INTO yuw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Oro yu ihoroc tongga entacanu wömai amna morömaho bongono youp wabkaracno makombican wocin engmuna aantacmai youp wabkaracno etno itmuna tong bumbum tac. ");
INSERT INTO yuw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tuna amna morömaho youp wabkaracno tun obukocno sinom tongo ‘imanang amnaot itun’ yongo dong yaruna sa woce ongontac. Sa woce wömai yong yaing tongmuya marabo siu tomentang.” Yesuho gön tongga arangarang yongga idithon mata tepmo ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesuho mata tepmo au ingoroc yogoc, “Amnahon Mananoho ehuna mom midim sabarac saho koing sangocan bongono wocin wömai kiapmo owi berac 10tho togungma worochon torocgon öngkuangoc. Woi ihoroc: Amna au yu owiop tongga owi fodip bucin yangat teptepha onggoc. Tuna owi berac 10 yu ‘amna wo uyap bonip ana fehun’ yongo gopno fogitmuya uyap onggung. ");
INSERT INTO yuw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Owi 5 yu wömai kombic kombic ogepma muno o owi 5 yu wömai kombic kombicbarac idung. ");
INSERT INTO yuw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Oro owi bumbumyima yu wömai gopno kudatnogon yamucno muno ihoroc febung. ");
INSERT INTO yuw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","O owi kombic kombicnobaracma yu wömai gopnohon yamucno au urengdec koringyu muuya yongga febung. ");
INSERT INTO yuw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ihoroc tongo idiya amna owi yangat teptepha onggocma yu karupgon maeboc. Worocha tongga owi 10 yu toreu matuna daro dupdup yuya dungo idung. ");
INSERT INTO yuw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Dungo idiya kumbong bongyomun sinom mamboc au ingoroc öngkuboc: ‘Amna oimna wego tocma wo urop ehantac. Son engga au feuna yangat teparut.’ ");
INSERT INTO yuw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Mamboc ihoroc öngkuna kombingga owi berac 10 yu ambarac idongdup tongo gopno tong arangarang togung. ");
INSERT INTO yuw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tongmuya owi bumbumyima yu nucni kombic kombicbaracma ingoroc inogung, ‘Nonthon gop noni omompha tang. Worocha sontho tongfat nengga gop yamuc opmu nimarut yo.’ ");
INSERT INTO yuw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Yu ihoroc inogung mahong owi kombic kombic-baracmaho mata urago ingoroc inogung, ‘Gop yamucno ngorocho wömai non ambaracha angit maic. Muno, son muyu yip bucin ongmuya sonibarac wöarit.’ ");
INSERT INTO yuw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ihoroc inuya owi bumbumyiho yip bucin ongidiya amna oimna wego togocma woroc engkuboc. Ehuna owi tong arangarang tongga idungma yu worocotgon ongo oimna wegohon tong sonoc toctoc bucin onggung. Böc ganang onguya wohogon amnaho böc simbu sobung. ");
INSERT INTO yuw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tuya mit wömai owi berac torop auho engmuya ingoroc mamboc togung, ‘Amna moröma, amna moröma engga simbu fagarit nimpi.’ ");
INSERT INTO yuw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Yu ihoroc mambodung mahong amna moröma yu ingoroc inogoc, ‘Son numari, noc son makombing kamot.’” ");
INSERT INTO yuw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesuho mata tepmo wo yun bödeuna ingoroc yogoc, “Son nochon ebep bongono sinom makombingmaha tongga son bongono muno tong arangarang tongo itongitnung.” ");
INSERT INTO yuw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu yu wönggon mata tepmo au ingoroc yogoc, “Mom midim sabarac sahon toroc kiap au wömai ingoroc engoc: Amna moröma au yu sa korungon woce onggonga togoc. Tongo yu youp wabkaracni anfi inong yuna ehuya yoctecno manomanono ‘yuho yangtorearut’ yongo ambarac yuho oburodec fingdup togoc. ");
INSERT INTO yuw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yu wömai youp amnanihon toroc kiapmo woroc angsoworengmuna worochon toroc möneng imogoc. Youp wabkarac aumaha wömai yu 5,000 kina ihoroc imogoc. O aumaha wömai yu 2,000 kina ihoroc imogoc. O aumaha wömai yu 1,000 kina ihoroc imogoc. Möneng imongbödengga uyap forosigoc. ");
INSERT INTO yuw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Forosingga ongga sa korungon idina amna 5,000 kina sogidocma yu möneng worocdec youp tongmuna wönggon 5,000 kina au sakaun figoc. ");
INSERT INTO yuw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","O amna 2,000 kina sogidocma yu ihorocgon möneng worocdec möneng youp tongmuna 2,000 kina au sakaun figoc. ");
INSERT INTO yuw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Worochoi oro amna 1,000 kina sogidocma yu wömai gopma gitmuna amna morömahon mönengno wo gopma ganang öp sigoc. ");
INSERT INTO yuw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Oro, ihoroc tuya sa ubarago ongbödeuna amna moröma yu youp wabkaracni orin möneng imogocma woroc körec körecha eboc. ");
INSERT INTO yuw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ehuna amna 5,000 kina sogidocma yu engmuna morömano ingoroc inogoc, ‘Amna moröma ahi, goc 5,000 kina ihoroc namogoroc mahong nocho möneng worocdec youp tongga wönggon 5,000 kina au sakaa fihac.’ ");
INSERT INTO yuw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ihoroc inuna amna morömaho inogoc, ‘Goc youp ogepma sinom togoroc. Goc youp wabkarac ogepma nongnongo sinom. Gocu yapmu obugu ogepma sinom angtoregorocmaha worocha wömai nocho manomano koböcma gamoya yangtoreangoroc. Goc ehia nocot kumeda.’ ");
INSERT INTO yuw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Oro mit wömai youp wabkarac 2,000 kina sogidocma yu engmuna morömano ingoroc inogoc, ‘Amna moröma, goc osuc 2,000 kina namogoroc mahong nocu worocdec youp tongga wönggon 2,000 kina au sakaa fihac.’ ");
INSERT INTO yuw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ihoroc inuna amna morömaho ingoroc inogoc, ‘Goc youp ogepma sinom togoroc. Goc youp wabkarac ogepma nongnongo sinom. Gocu yapmu obugu ogepma sinom angtoregorocmaha worocha wömai nocho manomano koböcma gamoya yangtoreangoroc. Goc ehiya nocot kumeda.’ ");
INSERT INTO yuw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ihoroc inuna mit amna 1,000 kina sogidocma yu ihorocgon engmuna morömano ingoroc inogoc, ‘Amna moröma, noc gochon foro kombingbödehat. Goc amna ecego. Amna auho nacno mögocma woroc wömai gocho gakaha detho fonyi ongidang. O ihorocgon amna auho nacno koburo anyun ongidangma worochon boinno wömai gocho feng suran tongo gakaha fogiditaroc. ");
INSERT INTO yuw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Noc worocha kombingmaina botongga 1,000 kina namogorocma wo tongga guroc ganang öp oring sigot. Ngo, gakain mönenga wönggon sogihi.’ ");
INSERT INTO yuw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ihoroc inuna amna morömaho mata wo kombingga ec imuna ingoroc inogoc, ‘Goc youp wabkarac wontucmuno koroc korogo. Boinno sinom, amna auho nacno mögocma woroc nocho fogiditat. O ihorocgon amna auho nacno yitno anidangmahon worochon boinno wömai nocho fogiditat. ");
INSERT INTO yuw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Oro goc nochon foro ihoroc kombingbödegoroc mahong goc mönengna bengdec masigoroc. Woce siiyai sakaun fiuna obmukusuc töngga sogiam.’ ");
INSERT INTO yuw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Amna morömaho ihoroc yongo mit torop au inogoc, ‘Son youp wabkarac koroc korogohon 1,000 kina sogida youp wabkarac ogepma 10,000 kina idimpacma woroc imarut. ");
INSERT INTO yuw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Wömai yaha, amna au yapmu koböcma idimpacma yu wömai nocho yapmu au imoya koböcma sinom idimangoc. Wohong amna au yu yapmu obmugon idimpacma yu wömai nocho yapmu obugu wo ihorocgon föa deuya uroci sinom engoc. ");
INSERT INTO yuw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Oro sontho youp wabkarac wöntucmuno ngo taruya sa kumbongnodec woce ohoun. Sa woce wömai yong yaingga marabo siu tomuya ididang.’” ");
INSERT INTO yuw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesuho wönggon mata au ingoroc yogoc, “Amnahon Manano yu mitimoni gesönobarac sinom ihoroc ehangoc. Engga Kopotorochon sum yaruni ambarac yangauna epnahing. Engmuya Amnahon Manano yu mata yun bödec bödec abamodec idina ");
INSERT INTO yuw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","owi amna kantri wohon wohon idangma yu ambaracho engmuya yuho yangamin suran tonahing. Tuya Amnahon Mananoho yu yang soworengga silip tongga suraro yai fiangoc. Woi bot sipsip yangtorec amnaho bot sipsip orin bot meme torop inoin inoin fingidang. ");
INSERT INTO yuw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Worochon torocgon wömai Amnahon Mananoho owi amna silip tongga bot sipsip wömai arocne fiangoc, o bot meme wömai kandocne fiangoc. ");
INSERT INTO yuw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tongo mata yun bödec bödec abamodec engocma yu owi amna arocne fohong yuangocma ingoroc inangoc: ‘Son Nandöngnahon guram sogidungma son nocot ebarut. Osucgon sinom sa guroc gabocan bongono wocin urop Kopotorocho inoin toboruc ‘sontha’ yongo tong arangarang tongo singdegoc. Worocha son engmuya mom midim sabarac sadec ongorut. ");
INSERT INTO yuw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kombiarut, noc nacnoha worec namuya sontho nacno song namongidung. O noc yamucha kombiaya sontho yamuc namongidung. O noc böcna korungonma engga edeya sontho böc sonin nangat töngidung. ");
INSERT INTO yuw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","O noc tec boruna muno edeya sontho tongfat nengidung. O noc obukoc tongga edeya sontho nangtorengidung. O noc yibucin edeya sontho engmuya nang kubingo ifat nungidung.’ ");
INSERT INTO yuw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ihoroc inuna owi amna nongnongomaho mata ingoroc iban imonahing: ‘Moröma noni, bongono yaönomadec nontho ganaya nacayaha worec gamuya nacno song gamogomon? O bongono yaönomadec non ganaya goc yamucha kombiiya yamuc gamogomon? ");
INSERT INTO yuw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","O bongono yaönomadec non ganaya böca korungonma ehiya non gangato böc nonin tögomon? O ihorocgon bongono yaönomadec non ganaya goc tec boruya muno idiya tec boru gamogomon? ");
INSERT INTO yuw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","O bongono yaönomadec non ganaya goc obukocdechu o yibucin idiya nontho engga gang kubingga itfat gögomon?’ ");
INSERT INTO yuw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yu ihoroc yuya Amna Moröma yu mata ingoroc iban imangoc: ‘Nocho boinno sinom kantiwa, sontho nochon oröcnai ngo mano muno yuha yapmu obmukusucgon tong imogungma woroc wömai sonu nocha tong namogung.’ ");
INSERT INTO yuw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Oro mit mata yun bödec bödec abamodec engocma yu amna torop au obu kandocne itnahingma ingoroc inangoc: ‘Son ongorut, Kopotorochon möpmo sondec itun. Son ep böhonghon fat idang. Son ep moroc bödec bödecno muno wocin idarut. Wo wömai Kopotorocho dogu kopotha orin yuhon toropniha tong arangarang togoc. ");
INSERT INTO yuw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kombiarut, noc nacnoha worec namuya sontho nacno au masong namogung. O noc yamucha kombiaya sontho yamuc manamogung. ");
INSERT INTO yuw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","O noc böcna korungonmaho ehaya sontho bucin manangat tonggung. O noc tec boruna docmöngga edeya sontho obmukusuc matongfat negung. O noc obukocdechu o yi bucin edeya sontho engga obmukusuc au manang kubingo maitfat nugung.’ ");
INSERT INTO yuw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Amna Morömaho ihoroc inuna torop wontucmunoho mata urago ingoroc iban imonahing: ‘Bongono yaönomadec non ganaya goc nacnoha worec gamuya o yamucaha kombiiya o böca korungonma engga idiya o tec boruya muno idiya o obukocdec o yi bucin idiya nontho matongfat gegomon?’ ");
INSERT INTO yuw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ihoroc yuya Amna Morömaho yu inangoc: ‘Nocho boinno sinom kanoya kombiarut. Sontho nochon oröcnai ngo mano muno idangma yuha yapmu obmukusucgon matong imogungma woi woroc noc ihorocgon matong namogung.’ ");
INSERT INTO yuw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ihoroc inuna mit wömai amna torop worocho ongga urago focfocnobarac bödec bödecno muno woroc sogitnahing. Wohong amna torop nongnongo yu wömai itonggong koing sogitnahing,” Yesu yu mata yun bödec bödec bongonoha yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Oro, Yesu yu mata moröma wo yongbödengga youp amnani wönggon ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Son urop kombiang, sep yaihogon bödeunya Israel nanohon bongono morö ‘Pasowa’ worocho engoc. Bongono wocin wömai amnaho Amnahon Manano ayamihon oburodec siuya ep goröcdec wuya omengoc.” ");
INSERT INTO yuw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Oro Yesuho mata wo yogocan bongono wocin sinom wömai öret socsoc böchon amna moröma orin surarohon amna dugo yu ambarac Kaiafasho bucin suran tongga idung. Kaiafas yu woi öret socsoc böchon dugo moröma idoc. ");
INSERT INTO yuw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Suran tongga ida yu ‘Yesu öpgon sogit akep tongmanaina wotnaya omengac’ yongo mata yong torop sigung. ");
INSERT INTO yuw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tongo yu yogung, “Nonu Pasowa bongono morödec ihoroc tontamonanu wömai suraroho wo angga ecimuna emoc morö toningyit. Worocha bongono wocin ihoroc angit matonin,” ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Oro Yesu yu Betani böcsadec ongga Saimontho bucin öngmuna nacno nocnoc abamdec omoc idoc. Saimon yu wömai osuc obukoc lepra togoc. Yesu yu woce idina owi au yu unac tugo ogepma sogida yuot engmuna unac woroc Yesuhon bigodec korigoc. Unac worochon wöngnacno woi önggöngyi sinom, wo kaya ureng ogepma sinom tobic tobicyi worocdec idoc. ");
INSERT INTO yuw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Oro owi yu unac koreuna Yesuhon youp amnaniho kiapmo woroc angmuya irotnoho kombiuya angit maidina yogung, “Owi wo yu unac komanang sinom tong samborec tac yo. ");
INSERT INTO yuw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Non woroc sinaya amna auho möneng morömadec wuup. Tuna non möneng woroc owi amna urocima tongfat yenam.” ");
INSERT INTO yuw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yu ihoroc yongo idiya Yesuho mata woroc kombingmuna ingoroc inogoc, “Owi ngorocho noc toroc ogepma sinom tong nampac. Sonu yu inong saha toninga. ");
INSERT INTO yuw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kombiarut, amna uroci yu bongono muno sonot iditnahing mahong nocu wömai bongono ubarago sonot mait. ");
INSERT INTO yuw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Owi ngorocho unac godibnadec wagang nampacma woi godip föbna oring sicsicha tong arangarang toctochon tac. ");
INSERT INTO yuw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nocho boinno sinom kantiwa, mit wömai owi amnaho ongmuya nochon fatmata ogepma sa guroc danong woce woce yonahing. Tongo yu owi ngorocha kombingga yu kiapmo ngo tong nampacma worochon fatno ihorocgon yong tongonahing,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Oro mit amna au mano Yudas Iskariot yu woi Yesuhon youp amnani 12 yuhon toropdecma yu ongmuna öret socsoc böchon amna moröma ingoroc inong ac togoc, ");
INSERT INTO yuw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Nocho Yesu sonthon obusonidec kamoyai wömai sonu möneng tingting namonahing.” Ihoroc inuna yu silwa möneng 30 ihoroc imuya fogidoc. ");
INSERT INTO yuw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tuna Yudas yu forosingga Yesu ayamphon oburodec sicsichontha uyapha yabigoc. ");
INSERT INTO yuw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Oro urop nacno sowarango yisno muno, ‘Pasowa’, woroc nocnochon bongono idoc. Tuna bongono worochon forosicsicnodec wömai youp amnaniho Yesuot ongmuya ingoroc inong ac togung, “Non sa nahenne ongmanaina Pasowa nacno tong arangarang tona’ yongo kombiharoc?” ");
INSERT INTO yuw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ihoroc yuya Yesuho inogoc, “Son Yerusalem taundec ongmuya amna tungu au feuna ingoroc inarut, ‘Fandat fandat amnaho yac, nochon bongono urop eng fomtacmaha tongga nocot youp amnanaiot gocho bucin engmanaina Kopotorocho Israel nano yang banauna ogep idungma worocha kombingmanaina Pasowa nacno naantamon.’” ");
INSERT INTO yuw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ihoroc inuna youp amna yu Yesuho yogocmahon torocgon tongo Pasowa nacno tong arangarang togung. ");
INSERT INTO yuw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Oro sa dobocsiuna Yesu ehuna youp amnani 12ot nacno nocnoc abamdec woce omoc idung. ");
INSERT INTO yuw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Woce nacno nongo itmuya Yesuho ingoroc inogoc, “Nocho boinno sinom kantiwa, sonthon bonip sonidecma amna tungu yu noc ayamnaihon oburodec siantac.” ");
INSERT INTO yuw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ihoroc inuna youp amnaniho mata woroc kombingga irotnoho kombing mep togung. Tongo yu forosingga amna tungu tunguho yu ingoroc inong ac togung, “Moröma, nocha yarochu?” ");
INSERT INTO yuw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ihoroc yuya Yesuho mata ingoroc iban imogoc, “Amna nocot waga ngorocdec nacnoha obunodi soreamotma yu worocho wömai noc ayamnaihon oburodec siantac. ");
INSERT INTO yuw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Boinno sinom, Amnahon Manano yui Kopoto-rochon bapiyadec irim toctocyi itacma worochon torocgon tanda guroc ngo imun faantac. Wohong koukou sinom, amnaho noc tong tongun namongo noc ayamnaiho oburodec siantacma yu wömai urago mepmo moröma sinom aun feangoc. Macnoho yu mabagochai wömai yu ogep in.” ");
INSERT INTO yuw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Oro Yudas yu urop irotnon Yesu ayamphon oburodec sicsichontha kombing bödengga Yesu inong ac tongo yogoc, “Fandat fandat amna goc nocha yarochu?” Yuna Yesuho inogoc, “Öc gaka worocha yat.” ");
INSERT INTO yuw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Oro yu ambarac nacno nongo itmuya Yesu yu nacno sowarango sogitmuna Kopotoroc ecec inongga uboda youp amnani silip tong imongmuna ingoroc inogoc, “Sogida naarut. Ngoi nochon godip föbna.” ");
INSERT INTO yuw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ihoroc inongga mit wain kap sogitmuna Kopotoroc ecec inongga youp amnani inogoc, “Son ambarac kap ngoroc sogida wain yamuc naarut. ");
INSERT INTO yuw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Wain yamuc ngo woi nochon nogotna. Woi Kopotorocho soniot botup botup sigocma worochon weranno. ‘Nochon nogotnaho koriuna owi amna koböcmahon turongono dongyun bödenung’ yongo yun bödec bödecyi. ");
INSERT INTO yuw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nocho boinno sinom kantiwa, nocu wain yamuc manai edeya ongga non Nandöngnahon midim sabarac sadec wönggon kondong ida wain yamuc wego kondong nanahamon.” ");
INSERT INTO yuw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yesuho youp amnani ihoroc inuna mit yu ambarac yong moröng ap yongga böc woroc imu fauna Oliv sa urongodec ögung. ");
INSERT INTO yuw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Oro mit Yesuho youp amnani ingoroc inogoc, “Kopotorochon bapiyadec mata ingoroc irim toctocyi itac: ‘Nocho bot sipsip yangtorecno weya bot sipsipho botongga woce woce gorong ongbödenahing.’ Oro mata worocho wömai önga kumbongnodec boinno öngkuantac. Son mepmo manomano nocdec öngkuantacma woroc angga noc imu faantac. ");
INSERT INTO yuw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tuna nocho omocdecma idongga son osuc fat kamoya Galili gurocin woce wönggon kondong itnahamon.” ");
INSERT INTO yuw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yesu ihoroc yuna Pitaho inogoc, “Muno sinom, owi amna ambaracho goc me gamontang mahong nocu ihoroc matit.” ");
INSERT INTO yuw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yuna Yesuho inogoc, “Nocho boinno sinom gantiwa, önga kumbong ngocin fup sigo abe mayi idina gocho nocha bongo anfi möp yong namontaroc.” ");
INSERT INTO yuw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ihoroc yuna Pitaho yogoc, “Muno sinom, noc ogep gocot omentamot. Nocu gocha möp mayit.” Pita ihoroc yuna youp amna nucni yu ambarac mata ihorocnogon yogung. ");
INSERT INTO yuw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Oro mit Yesuot youp amnaniot sa au mano Getsemane woce onggung. Woce itmuya Yesuho ingoroc inogoc, “Son ngocin torengga idiya noc okoce ongmaina dönac yontat.” ");
INSERT INTO yuw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ihoroc inongga yu Pita orin Sebedihon mananin yai yu yangauna onggung. Tongo Yesu irotnoho kombingbanac tongo kombing mep tongmuna ");
INSERT INTO yuw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","amna anfima ingoroc inogoc, “Irotnaho toup sinom mep tuna omomno kombihat. Son ngocin itmuya nocot gön tongga idarut.” ");
INSERT INTO yuw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yesu ihoroc inongo yu ino obmukusuc okoce ongga gurocdec möngga yangamo imong sogito itmuna dönac ingoroc yogoc, “Nandöngna, goc ogep focfoc morö nocdec öngkup öngkupha tacma wo tui dehun. Wohong nochon kombic kombic muno, gakain irotgon koing soun.” ");
INSERT INTO yuw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yu dönac ihoroc yun bödeuna ibarun fauna youp amnani anfi fohong yugocan woce ongmuna yagocmai yu dungga idung. Tuna yu Pita inogoc, “Son nocot bongono docutnogon wec itmuya dönac youp angit matup? ");
INSERT INTO yuw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Son muyu gön tongga dönac youp tongga idarut. Tonguc yecyecho sondec öngkuuna sing kapningyit. Irot noniho wömai manomano toctocha kombihac mahong godip föpnoni woi singo.” ");
INSERT INTO yuw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesuho youp amnani ihoroc inongga wönggon obmukusuc oke ongga bongo yai dönac ingoroc yogoc, “Nandöngna, noc kombihat, focfoc youp wo muyu nocdec öngkupun mahong nocu imong dot matit. Muno, nocu ‘gakain irot kombic kombicgon koing soun’ yongo kombihat.” ");
INSERT INTO yuw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yesu yu dönac ihoroc yongbödengga youp amnaniot engmuna yagocmai yu wönggon godibo mep tuya dungo idung. ");
INSERT INTO yuw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ihoroc idiya yu wönggon dongyun fauya obmukusuc oke ongo dönac osuc yogocma worocotmagon yuna bongo anfi idoc. ");
INSERT INTO yuw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yun bödeuna ibarun fauna engmuna youp amnani ingoroc inogoc, “Son dupninga, nochon bongono urop engtepac. Amnahon Manano yu urop wontucmuno toctoc amnahon oburodec entac. ");
INSERT INTO yuw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Son idonguya ongona. Noc ayamahon oburodec sicsic amna yu urop epac.” ");
INSERT INTO yuw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu yu mata wo yongga idina urop Yudas yu ayamphon uyap bigo sing imuna ebung. Yudas yu Yesuhon youp amnani 12 yuhon toropdecma. Öret socsochon amna dugo orin surarohon amna dugo yu amna torop moröma sinom inongmuuya bainat, kandöc fogitmuya ebung. ");
INSERT INTO yuw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Oro Yesu ayamphon oburodec sicsic amna Yudas yu wömai amna torop wo mata ingoroc inogoc, “Nocho ongmaina amna au sogito ducin ducin tontat. Ihoroc toya angmuyai son kombiantang, amna woroc sogit akep tona.” ");
INSERT INTO yuw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Oro Yudas yu wo yogocmahon toroc karupgon Yesuot ongmuna, ‘kumbong ogep fandat fandat amna’ ihoroc inongo ducin ducin tong imogoc. ");
INSERT INTO yuw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tuna Yesuho inogoc, “Oröcna, goc engmina yapmu ngo tarocmahon foro makombiroc, karupgon toi.” Ihoroc inuna amna torop engmuya Yesu bang sogito sogit akep togung. ");
INSERT INTO yuw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ihoroc tongo idiya Yesuhon youp amna au yu gobit bainatno sogitmuna öret socsoc amna dugohon youp wabkaracno wotmuna bainatho onggimo saringmun mögoc. ");
INSERT INTO yuw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ihoroc tuna Yesuho ‘muno’ inongo ingoroc inogoc, “Goc bainata böcno ganang sorengmi muhun. Kombihi, amna bainatdec emoc tongidangma yu wömai bainatho dongyun obukontang. ");
INSERT INTO yuw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Gocu makombirocmai, noc ogep Nandöngna inoya yu karupgon sum yaruhon ami torop 12 woroc inong muuna engga tongfat neup. ");
INSERT INTO yuw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Wohong nocu ihoroc matit. Muno Kopotorochon bapiyadec mata irim toctocyi itacma worocho ambarac nocdec boinno öngkung-bödehun.” ");
INSERT INTO yuw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ihoroc inongga mit Yesuho amna torop yu sogit sgotha ebungma ingoroc inogoc, “Son ingoroc kombianghu, noc ‘gavman taraya ongoun’ yongo emoc toctocha kombihat. Worocha wömai son bainat kandöc sarup soni yongga fengga noc sogit sogitha tanghu nuhun? Woi muno sinom, noc bongono muno öret socsoc böchon gomboin itmaina owi amna fatmata ogepma inongidot. Wohong bongono wocin wömai sontho noc sogit akep toctocha makombigung. ");
INSERT INTO yuw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Oro manomano ngo nocdec öngkuhacmaha tongga Kopotorochon yong tuctuc amnaho mata irim togungma worocho boinno öngkupac.” Yesu yu mata ihoroc yongbödeuna inoin youp amnani ambaracho botongga Yesu angmu fauna ongbödegung. ");
INSERT INTO yuw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Oro, tawa amna yu Yesu yangada öret socsoc amna dugo Kaiafas yuho bucin tonggung. Tuna nongoru gendic fandat fandat amna orin surarohon amna dugo yu ambarac Kaiafasho bucin woce suran tongga idung. ");
INSERT INTO yuw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Oro Pita yu obmukusuc korungon bum itmuna Yesu tan tongmuna ongga Kaiafasho böc gombo ganang woce engkuboc. Engkungga yu tawa amnaot kondonggon woce itmuya ‘amna morömaho Yesu tingting sinom tong imuya ana’ yongga torengga idung. ");
INSERT INTO yuw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kaiafasho bucin wömai öret socsoc amna dugo orin Yuda nanohon kaunsil yu Yesu wot omom toctochon uyapha dabingmuya amna au iniya yu Yesuha imanang mata ihono ihono firing tandung. ");
INSERT INTO yuw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Yu imanang mata koböcma yongo firing tandung mahong tong bumbum au Yesu wot omom toctochon toroc ihoroc wömai matu öngkuboc. Oro mit sinom amna yaiho engmunya amna moröma ingoroc inogomoroc, ");
INSERT INTO yuw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Amna ngo yu ingoroc yogoc, ‘Noc ogep Kopotorochon öret socsoc böc wo gumanda sep anfihon irotnon wönggon tobingga temongma uun.’” ");
INSERT INTO yuw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ihoroc inunya öret socsoc amna dugo yu idongga Yesu inogoc, “Mata ngo gocha firing garamorocma woi boinnoha woha muno. Goc mata urago yoi.” ");
INSERT INTO yuw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ihoroc inogoc mahong Yesu yu öpgon itmuna mata au mayogoc. Tuna öret socsoc amna dugoho wönggon inogoc, “Noc Kopotoroc Itonggong Morömo yuhon madec ganongac toya goc boinno onoce yoi. Duic, Kopotorochon Manano woi gocha woha goc muno” ");
INSERT INTO yuw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ihoroc inuna Yesuho matano ingoroc iban imogoc, “Öc, gaka yarocma woi boinno. Wohong nocho son ambarac kantiwa, mit wömai sonu anahingmai, Amnahon Manano yu Kopotoroc Gesö Morömo yuhon obu aroce itmuna mom muruc muruc koroc ida ehangoc.” ");
INSERT INTO yuw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yesuho ihoroc yuna öret socsoc amna dugo yu mata woroc kombingga inoin tec tohomunmöcno wirangga yogoc, “Yu Kopotorocha yong samborec yac yo. Worocha non amna auhon matano makombining. Muno, non ambarac yuhon mata wontucmuno kombingdeamon. ");
INSERT INTO yuw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Worocha son amna ngorocha tingting kombiang?” Ihoroc yuna amna moröma aumaho yogung, “Yu woi omomphon fat.” ");
INSERT INTO yuw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ihoroc yongmuya forosingga irubo Yesuho yamgamodec sunda orin oburoho wodung. Tongo auho wömai oburo faitnoho aramodec woda ingoroc inogung, ");
INSERT INTO yuw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Goc boinno Kopotorochon Duic itarocanu wömai yoi, numaho gotac?” Amna morömaho Yesuha yong kumec ihoroc togung. ");
INSERT INTO yuw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Oro, Pita yu Kaiafashon gombo ganang idina mongorec toctoc owi au yu engmuna inogoc, “Goc ihorocgon Yesu Galilima yuot kondong itongidomoroc.” ");
INSERT INTO yuw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ihoroc inuna Pita yu owi amna koböcmaho yangamin itmuna yogoc, “Gocho mata yarocma woi nocu makombit yo.” ");
INSERT INTO yuw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ihoroc inongo idongga ongga böc gombo imun fauna simbu ambehecgon idoc. Woce idina owi auho yu angga owi amna ambehecgon idungma ingoroc inogoc, “Amna ngoroc yu osuc Yesu Nasaretmaot itongidoc.” ");
INSERT INTO yuw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ihoroc yuna Pita yu wönggon möp orongi sinom yongo yogoc, “Boinno onoce sinom, noc amna wo makombing imot.” ");
INSERT INTO yuw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tuna wönggon obmukusuc idina amna ambehecgon idungmaho engmuya Pita ingoroc inogung, “Boinno sinom, non gochon duc inggura kombiamon, gocu ihorocgon amna worochon toropdecma.” ");
INSERT INTO yuw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ihoroc inuya Pita yu mata wontucmuno orongi sinom yongo yogoc, “Noc amna wo boinno sinom makombing imot. Noc imanang yatanu wömai Kopotorocho noc möpmo tong namuna obökam.” Yu mata woroc yongbödeuna wohogon fup amnanoho mano yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tuna Pita yu Yesuhon mataha kombigoc. ‘Fup mano abe mayi idina gocho nocha bongo anfi möp yong namangoroc.’ Pita yu woroc kombingmuna taitdec ohongga yong ointoc moröma sinom togoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Oro sa isuna öret socsoc amna moröma orin surarohon amna dugo yu ambarac irot tungu singmuya Yesu wuya omomphon matano yu bödegoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yu bödeuna Yesu yidec kaning yungga Gavmanthon amna moröma Pailat yuho oburodec sigung. ");
INSERT INTO yuw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Oro Yesu ayamphon oburodec sicsic amna Yudas, yu agocmai amna dugoho ‘Yesu ompun’ yongo matano yu bödegoc. Tuna Yudasho irot mepmo sinom kombingga irotno ibanda silwa möneng 30 sogidocma woroc sogida tongga öret socsochon amna dugo orin surarohon amna dugo yu iban imogoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Imongo ingoroc inogoc, “Nocho tong bumbum moröma sinom togot. Nocu amna nongnongo au ayamihon oburodec sigot.” Yudasho ihoroc inuna amna dugoho inogung, “Woi nonthon manomano muno. Gochogon togoroc.” ");
INSERT INTO yuw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ihoroc inuya Yudas yu silwa möneng woroc öret socsoc böc ganang tomun ohuna ibarun fauna ongga ino töe töngga omong fadoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tuna öret socsochon amna moröma yu sop silwa woroc sogida yogung, “Möneng ngo woi amna wotwothon wöngnac. Oro nongoru noniho yac möneng ihorocno öret socsoc böchon fat icha.” ");
INSERT INTO yuw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ihoroc yongga yu yong torop ingoroc sigung, ‘nonu sop worocdec wö tobic tobic amnahon gurocno docno wönahamon. Guroc worocho wömai amna sano korungonmaho omuya ficfichonta engoc.’ Ihoroc yu bödegoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Oro foro worocha wömai owi amna guroc worochon mano ‘nogothon guroc’ ihoroc yongidung, o önga ihorocgon yongidang. ");
INSERT INTO yuw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Woroc öngkubocmaha tongga Kopotorochon yong tuctuc amna Yeremaia yu mata yogocma worocho boinno öngkuboc. Yu osuc mata ingoroc yogoc: “Silwa möneng wo wömai Israel nanoho amna worochon bigo wöcwöcha yu bödegoc. Israel nanohon amna dugo yu silwa möneng 30 wo sogida wö tobic tobic amnahon guroc docno wögung. Morömaho mata nanogocma worochon toroc togung.” ");
INSERT INTO yuw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Oro, Yudasho ino töe togocan bongono wocin wömai Yesuho gavmanthon amna moröma Pailat yuho yangamin idina Pailatho inong ac tongo ingoroc inogoc, “Goc Yuda nanohon king worochu?” Ihoroc inuna Yesuho yogoc, “Öc gaka yarocma woi boinno.” ");
INSERT INTO yuw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ihoroc yuna öret socsoc amna dugo orin surarohon dugo yu mata koböcmaho fir-ing tandung mahong Yesu yu matano urago maiban imogoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tuna Pailatho Yesu kiring imongo inogoc, “Goc mata firing garangma woi makombirochu.” ");
INSERT INTO yuw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ihoroc inogoc mahong Yesu yu mata tungu auhon ökenne maiban imogoc. Tuna Pailatho Yesuha kombic kombic youp morö togoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Oro, gavmanthon morömahon toroc kiap au ingoroc ididoc: Biruc danong Yuda nanohon bongono morödec suraroho amna yi bucinma auhon mano yuya Pailatho amna woroc asan imuna orung ongidoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Oro bongono worocho amna wöntucmuno sinom au mano Barabas yu yi bucin idoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Pailat yu Yuda nanohon amna dugohon foro kombingbödegoc. Yu wömai Yesu suraroho yangamin ma moröma sogidocmaha ecego kombigung. Foro worocha tongga yu Yesu mata youpdec tohong yugung. Oro owi amnaho eng suran tongo idiya Pailatho yu inong yac tongo inogoc, “Nocho amna numa asan kampiwa? Amna ngoroc Barabasha woha Yesu mano ‘Duic’ yongidangma sonu worocha kombiang?” Pailatho ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Oro yu abe mata soworec soworec abamodec idina inoin owenoho mata ingoroc siuna yuot eboc: ‘Noc önga kumbong duc itu audec amna woroc angmaina toup botot. Noc kombihat, amna ngo yui nongnongogon, worocha goc yapmu wontucmuno au yu tong imirocha.’ ");
INSERT INTO yuw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pailat oweno yu mata ihoroc opnoha sing imogoc mahong öret socsoc amna moröma orin surarohon amna dugo yu surarohon irotno toup sakang imuya owi amnaho ‘Barabashong asan nimpun Yesuhong wuya ompun’ yongo kombigung. ");
INSERT INTO yuw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tuna Pailatho suraro inong yac tongo inogoc, “Nocho amna yai ngorocdecma numa asan kampiwa? Sonu ‘numaha’ yongo kombiang?” Ihoroc yuna suraroho mamboc moröma tongo yogung, “Barabas nimpi!” ");
INSERT INTO yuw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ihoroc yuya Pailatho owi amna wönggon inogoc, “Oro nocho amna ngo Yesu Duic yongidangma yuha tingting sinom tong impiwa?” Yuna suraro ambarac sinom duc suran tongo mambodung, “Ep goröcdec wuya ompun.” ");
INSERT INTO yuw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ihoroc yuya Pailatho wönggon inong yac tongo yogoc, “Nocho yuhon tong bumbum au maat, yu yaö tong bumbum togoc?” Ihoroc yogoc mahong suraro yu mamboc koreng orongi sinom tongo yogung, “Ep goröcdec wuya ompun!” ");
INSERT INTO yuw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Mamboc ihoroc toup tongo urop emoc tu öngkup öngkupha tuya Pailatho kiapmo wo angmuna ingoroc kombigoc, ‘Yui nochon mata makombining,’ ihoroc kombingga owi amnaho yangamin oburo yamuc sac tongmuna inogoc, “Amna ngo yu nochon tong bum-bumnaha mamic, muno sontho yangmaha tongga omentac.” ");
INSERT INTO yuw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ihoroc yuna owi amna ambaracho duc suran tongo yogung, “Tong bumbum ngorochon urago wömai nondec orin managumboc nonidec engoc.” ");
INSERT INTO yuw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ihoroc yuya Pailat yu Barabas asan imuna owi amnaot ohogoc. Tuna youp wabkaracho Yesu fihidec fic urobung. Tuna mit Pailatho ‘Yesu ep goröcdec wuya ompun’ yongo tawa amnahon oburodec imogoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Oro mit gavmanthon morömahon tawa amnani yu Yesu yangada gavman böc moröma ganang woce tongo tawa amna nucni inong yuya ambaracho eng suran tongo Yesu sing arenggumbec togung. ");
INSERT INTO yuw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tongo Yesuhon tecno tuu deuna tec tohomunmucno gomono temong imogung. ");
INSERT INTO yuw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Temong imongo yi dirongoni sogitmuya worocdecma amna kinghon tec kutkutno kiap tongo bigodec tohomu möngimogoc. Ihoroc tongo tut kandöng kingho sogididangmahon torocdec oburo aroce sing imogung. Ihoroc tongga goruc yemoc tongimongo imanang yongkumec ingoroc yong imogung, “Sep ogep Yuda nanohon king.” ");
INSERT INTO yuw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ihoroc inongo singmuya irubo yudec sunmuya tut kandöng Yesu oburodecma wu deuna Yesu bigodec wotgon togung. ");
INSERT INTO yuw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ihorocno tong imongbödengga wönggon tec gomono wo tuu deuna inoin tec tohomunmucno temong imongga ep goröcdec wotwotha yangat tonggung. ");
INSERT INTO yuw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Oro tawa amnaho Yesu uyapdec yangat tongmuya amna au mano Saimon yu au fedoc. Yu wömai böcsa Sairinima. Tongo tawa amnaho ‘yu ep goröc sumbotun’ yongo sogito woding tengga Yesuhon ep goröc imuya sumbodoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tuna yu ongga sa mano Golgata wocin ongkubung. Sa mano worochon foro woi ‘bic kudat’ ihoroc. ");
INSERT INTO yuw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Woce itmuya tawa amnaho Yesu wain yamuc marasin beci sinomot tobic tobicyi woroc imogung mahong Yesuho obmugon toroc tongo managoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tuna yu Yesu ep goröcdec wodung. Tongo ‘Yesuhon tec napno silip tona’ yongo tim kumec togung. ");
INSERT INTO yuw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ihoroc tongbödengga omoc itmuya Yesuha gön tongga idung. ");
INSERT INTO yuw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tongo Yesuhon bigo onocenne ep docno au irimnobarac sakau figoc. Irim wo wömai Yuda nanoho Yesuha duc orec mata yogungma woroc ingoroc irim toctocyi idoc: ‘Ngoi Yesu, Yuda nanohon king.’ ");
INSERT INTO yuw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Oro Yesuhon obu kandocne o arocne wocin wömai tawa amnaho usem amna yai ep goröcdec dobung. ");
INSERT INTO yuw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Owi amna sa woce itonggungma yui bic ubung ubung tongmuya Yesu inong saha tongo yogung, ");
INSERT INTO yuw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Öhö, goc ngorocho öret socsoc böc gumanmina sep anfiho irodin wönggon tobic tobicha yogorocha. Oro goc boinno Kopotorochon Manano itarocanu wömai gocha tongfat yengmina ep goröc imi fauna ohoi.” ");
INSERT INTO yuw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Owi amna ihoroc inong saha tong imong idiya öret socsochon amna dugo orin nongoru gendic fandat fandat amna orin surarohon amna dugo yu ihorocgon inong saha tongo yogung, ");
INSERT INTO yuw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Yu osuc owi amna wontucmunodecma öcangyun muuya itonggong koing imocimocha yongidoc mahong inoin itonggong tun öngkup öngkupha wömai makombic. O yu yogoc, ‘Noc Israel nanohon amna moröma kingno itat.’ Oro ihoroc yogocmaha yu ep goröc imun fauna ohoun. Ihoroc tuna wömai nonu kombing tobing imontamon. ");
INSERT INTO yuw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","O yuho yogoc, ‘Noc Kopotorochon Manano, o tongfat necna woi Kopotoroc.’ Worochai oro Kopotorocho yuha kombihacanu wömai yu tong fatyehun.” ");
INSERT INTO yuw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Amna moröma yu ihoroc yogung. O worochon torocgon usem amna yai Yesuot ep goröc-dec dobungma yui ihorocgon Yesu inong saha toup togomoroc. ");
INSERT INTO yuw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Oro apmano forosingga sa kombung dingga idinagon ongga 3 kilok bödegoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tuna sep bongono 3 kilok idina Yesuho ecnang ingoroc mambodoc, “Eli, Eli, lama sabaktani!” Mata worochon foro wömai ingoroc: ‘Kopotorocna, Kopotorocna, goc foro yaha noc me namongga imi fahat!’ ");
INSERT INTO yuw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ihoroc yuna amna au ambehegon idungma yu mata woroc kombingga yogung, “Yu Elaiya inong yac.” ");
INSERT INTO yuw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ihoroc yuya wohogon amna auho karupgon ongmuna top yat au sogitmuna wain yamuc beci wodec tomun muuna öngfoc tuna ‘Yesuho nahun’ yongo bokotdec akep tongga Yesu dugodec sorengmun ögoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ihoroc tuna owi amna auho yu inogung, “Imi fauna ana. Elaiyaho engga tongfat yeantacha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tuna Yesu yu mamboc orongi sinom tongo yaruno onguna omong fadoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yesu omong fadocan bongono wocin sinom wömai boru moröma öret socsoc böc irodin idocma worocho onoce singga fuc tongga ohongga mondopmodec omoce bödeuna fugo yai idomoroc. O ihorocgon konoc feruna sop morömaho fuc togung. ");
INSERT INTO yuw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tongo sop ganang amna omomyi fingidungma worocho fagariuya Kopotorochon kunkun owi amna osuc ombungma koböcma yu wekogung. ");
INSERT INTO yuw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Wekongga sop ganango dongyu fauya itonggung. Oro mit Yesuho omocdecma wekongga idonggocan bongono wocin wömai owi amna worocho Kopotorochon kunkun taun Yerusalem woce ongmuya owi amna koböcma öngkung imogung. ");
INSERT INTO yuw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Oro tawa amnahon ofisa orin tawa amnani Yesu angtorengga idungma yu konoc orin manomano ambarac öngkubocma woroc yangmuya toup sinom botongga yogung, “Boinno sinom, amna ngoroc yui Kopotorochon Manano,” ihoroc yong tabung. ");
INSERT INTO yuw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Oro owi koböcmaho korungonbum itmuya manomano öngkubocma wo agung. Yu wömai osuc Galili sa imu fauna Yesu mongorec tong imocimocha yuot itongidung. ");
INSERT INTO yuw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Owi worochon toropdecma au wömai Maria Makdala bucinma, o auma wömai Jems orin Yösephon macno mano Maria, o auma wömai Sebedi mananin yaima worochon macno. ");
INSERT INTO yuw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Oro, sa urop dobocsisicha tuna amna moröma au mano Yösep yu eboc. Yuhon böcsano Arimatea. O yu yoctec mönengno koböcma idimogung. Yu wömai Yesuhon youp amna idoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tongo yu ‘Yesuhon ep fambangno sogiwa’ yongo Pailatot ongga wo inuna Pailatho kombiun bödeuna ‘ep fambangno imarut’ yongo mata siuna tawa amnaho wo Yösep imogung. ");
INSERT INTO yuw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Imuya Yösep yu woroc sogida boru sacsagodec tombotmuna ");
INSERT INTO yuw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","sumboda tongga amna ficfichon sop ganango au wocin sigoc. Sop ganango wo wömai Yösep ‘inoha’ yongo wego tobing siuya wögoc. Oro Yösep yu ep fambangno woce singga sop moröma ibaruna ongga sop momböngno foctangmun fauna onggoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Tuna owi Maria Makdala bucinma orin Maria au yu sop ganango ambehecgon engmunya omoc idomoroc. ");
INSERT INTO yuw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Oro, Sabathon manomano tong arangarang toctochon sep youp toctoc bongono urop bödengina öret socsoc amna moröma orin Farisi yu Pailatot onggung. ");
INSERT INTO yuw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ongmuya ingoroc inogung, “Amna moröma kombihi, imanang amna worocho abe wec idocan bongono wocin yu mata ingoroc yuna kombigomon, ‘Mit sep youp toctoc anfi bödeuna noc wönggon wekongga idongöngot,’ ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Worocha gocho tawa amna au inia yu ongmuya sop ganango woroc gön tongga idiya ongga sep anfi bödeangoc. Ihoroc tuya Yesuhon youp amnani engga ep fambangno usem matoning. Wo usem tonggai wömai yu mit imanang mata ingoroc yup: ‘Yesu yu urop wekongga idonggoc yo.’ Ihoroc inongga imanang mata worocho böcsa danong ongun. Tuna imanang worocho imanang mata osuc yongidungma wo anggiraicyit.” ");
INSERT INTO yuw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ihoroc inuya Pailatho yogoc, “Oro, son tawa amna au inongga yangat fonguya yu amna fiima woroc gön orongi sinom tongga idarut.” ");
INSERT INTO yuw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pailat ihoroc yuna yu ongmuya sop ganango worocdec gavmanthon weran akep tongga taunno sigung. Ihoroc tuya tawa amnaho woroc gön tongga idung. ");
INSERT INTO yuw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Oro Sabat sep bongono urop bödeuna Söndain kembotsum sinom bongono wocin Maria Makdalama woroc ot Maria auma yu sop ganango Yesu idocma woroc acacha ebomoroc. ");
INSERT INTO yuw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Engga idinya Morömahon sum yaru au yu mom imun fauna gurocdec ohogoc. Ohuna konoc moröma sinom fendoc. Tuna sum yaru yu sop moröma sop ganango foc togocma woroc ibaruna onguna momböngno eran idoc. Tuna inoi sop koroc omoc idoc. ");
INSERT INTO yuw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yaru worochon godibo wömai mom muruc muruc simbang möngga idoc. O tecno wömai föhöc tiptip sinom ais kiap. ");
INSERT INTO yuw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Oro tawa amna yu yaru woroc angbotongga kudat konoc konoc toup sinom tongo amna omima simbang tongga idung. ");
INSERT INTO yuw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tuna yaruho owi yaima ingoroc inogoc, “Sot botodimorocha. Noc kombihat sot ‘Yesu, ep goröcdec wodungma yu ada’ yongo ebamoroc. ");
INSERT INTO yuw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wohong yu ngocin maec. Yu urop osuc kanongdegocmahon toroc wekongga idonggoc. Sot engmunya dupdup abamo aarun. ");
INSERT INTO yuw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Angga sot karupgon ongga Yesuhon youp amnani ingoroc inarun: Yu urop amna fiima imun fauna wekongga idonggoc. Tongo yu Galili guroc woce osuc fat kamuna sontho ihorocgon woce ongga anahing. Oro noc epatma wömai mata woroc kanoc kanocha epat,” Sum yaruho owi yai ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tuna owi yaima yu botogomoroc mahong aramokene toup sinom borongdedomoroc. Tongo yu karupgon amna fiima woroc imun fauna ‘Yesuhon youp amnani fat woroc inoda’ yongo domdomgon onggomoroc. ");
INSERT INTO yuw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Uyapdec ongidinya wohogon Yesu yu yaun feuna inogoc, “Kembotsum ogep.” Ihoroc inuna owi yai yu ambehecgon engmunya orungo sogitmunya yong moröng imogomoroc. ");
INSERT INTO yuw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tunya Yesuho inogoc, “Sot botodimorocha. Sot ongmunya nakain oröcnai inarun, ‘Son Galili gurocin ongorut. Tongo woce wömai noc nanahing.’” ");
INSERT INTO yuw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Oro owi yaima yu uyapdec ongidinya tawa amna sop ganango gön togungma au yu Yerusalem ongmuya manomano öngkubocmahon fatno öret socsoc amna moröma inongdup togung. ");
INSERT INTO yuw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ihoroc tuya öret socsoc amna moröma yu onguya surarohon amna dugo ot suran tongmuya mata yong torop sigung. Tongo yu tawa amna möneng koböcma sinom imongmuya inogung, ");
INSERT INTO yuw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Son owi amna ingoroc inarut: ‘Non kumbong dungo iditnaya Yesuhon youp amnaniho engmuya ep fambangno usem tongo tonging.’ ");
INSERT INTO yuw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Oro mata ngorocho Gavman morömahon onggimon ohuna kombingga yunai wömai nontho yuot matasoni woroc tobinahamon. Son worocha kombingbanac toninga.” ");
INSERT INTO yuw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ihoroc inuya tawa amna yu möneng woroc sogida amna morömahon mata worocgon tanda yong fandat tonguya mata worocho Yuda nanohon bonipnodec furang kango onggoc. Tuna Yuda nano koböcmaho mata worocgon kombingidung, o ihorocgon önga kombing tobingidang. ");
INSERT INTO yuw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Oro mit wömai Yesuhon youp amnani 11 yu Galili gurocin ongga sa urongo audec ögung. Yesuho osucgon ‘woce ongorut’ yongo inogoc. ");
INSERT INTO yuw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Woce öngkungga Yesu au feuna yong moröng imogung. Wohong auho irot yai togung. ");
INSERT INTO yuw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Oro Yesu yu ambehegon engmuna ingoroc inogoc, “Kopotorocho ‘noc mom orin guroc manomano ambarachon Morömo itiwa’ yongo worochon gesö ambarac namogoc. ");
INSERT INTO yuw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Worocha sonu ‘owi amna nakain youp amnanai itnung’ yongo gurocno gurocno ongmuya Nandöng orin Manano orin Kunkun Yaru yuhon madec yamuc gung imongitnung. ");
INSERT INTO yuw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tongo nocho fatmata fandat kanogotma woroc ambarac yu fandat inuya yu kombingo sumboditnung. Kombiarut, nocho bongono bongono sonot itong tongeyagon ongga guroc ngorochon bongono bödeangoc.” ");
INSERT INTO yuw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Oro ngomai Kopotorochon Manano Yesu Duic yuhon fatmata ogepma. ");
INSERT INTO yuw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Fatmata ogepma worocho wömai Kopotorochon yong tuctuc amna Aisaia yuho irim togocma worochon toroc forosigoc. Mata ingoroc irim toctocyi itac: “Kombiarut, nocho yong tuctuc amna au inongmuaya ehantac. Yu wömai osuc fat gamongo gochon uyap tobiangoc.” ");
INSERT INTO yuw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Sa moröpmodec amna auhon mambocno öngkupac: ‘Moröma-hon uyap tong arangarang tongga yuhon uyapno tobiarut.’” ");
INSERT INTO yuw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Oro Aisaiaho yogocma worochon torocgon wömai Jöntho eboc. Yu sa moröpmodec itmuna owi amna Kopotorochon mata fandat inongga ingoroc yogoc, “Son muyu turongo soni yangmuya uroci kombingga irot soni ibararut. Ihoroc tuya nocho son yamuc gung kamoya Kopotorocho turongo soni dongyun fatnahing,” Jöntho owi amna ihoroc inongidoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tuna Yudia owi amna orin Yerusalem owi amna yu ambaracho Jönot ongbödengga turongono yong tahuya Jöntho yu Yodan yamucdec yamuc gung imongidoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Oro Jönthon tec tohomunmöcno woi bot kamelehon dimodec tobic tobicyi ihoroc idina yu wo bot godibdec akep tongo itongidoc. O nacno yoit wömai gucsim orin omong omong worocgon nongidoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Oro yu fatmata ingoroc yongidoc: “Amna au nochon menan eng tepacma, yuhon gesönoho wömai nochon gesöna anggirahac. Nocho yuhon mene darange matoctocno yu woi gendicma morö. ");
INSERT INTO yuw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nocho youp tongitatma wömai yamucdecgon tongitat mahong mit wömai yu engmuna son Kunkun Yaruot gung kamangoc,” Jön yu Yesuha yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Oro bongono wocin Yesu yu Nasaret taun Galili gurocin idocma wo imun fauna Jönot ehuna Jöntho Yodan yamuc gung imogoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ihoroc tongbödeuna Yesu yamuc imun fauna tero öngga ida agocmai mompho fagariuna Kopotorochon Kunkun Yaruho yup kanaröm gan tongga ohongga yudec idoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Yudec idina momdecma duc inggun auho öngkungga ingoroc yogoc, “Goc nakain Manana batip sinom. Noc gocha toup kombingitat. Nocho goc erangga irotnaho gocha kömehat,” inggun wo ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tuna Kunkun Yaruho Yesu inong muuna yu sa amna maiyan woce onggoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tongo yu sa wocegon idina ongga sep youp toctoc 40 ihoroc bödegoc. Bongono wocin wömai dogu kopotho yu tonguc imong tonggoc. Tuna Yesu yu sa amna maiyan arap ingingo ot idina Kopotorochon sum yaruho yu mongorec tong imogung. ");
INSERT INTO yuw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Oro mit King Heröt yu Jön yibucin tohong yugoc. Tuna worochon menon wömai Yesuho Galili gurocin engmuna youpno forosingga Kopotorochon fatmata ogepma owi amnadec yong silip tong imuna ");
INSERT INTO yuw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ingoroc yong tonggoc, “Kopotorochon bongono morö urop epac. Tuna Kopotorochon toborucno engfomtac. Wohai sonu turongo soni yong tangga irotsoni ibaruya fatmata ogepma kombing tobiarut,” ihoroc yong tonggoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Oro, Yesu yu Galili yamuc öngkoring terodec itongga yagocmai Saimon yan oröcma yu umben topdec monda idomoroc. Saimon orugo worochon mano Andru. Yan oröcma yu wömai söng fogito bisnis youp tongidomoroc. ");
INSERT INTO yuw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ihoroc tongga idinya Yesuho ingoroc inogoc, “Sot engga noc nararun. Narunya nocho amna fogit fogithon foro tong kindaantat.” ");
INSERT INTO yuw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yesu yu ihoroc inuna wohogon yu umbenno doun fauya Yesu tan tonggomoroc. ");
INSERT INTO yuw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tuna Yesu yu obmukusuc ongga yagocmai, Sebedihon mananin Jems orin Jön, yu girang obugudec itmunya umbenno tong arangarang tongga idomoroc. ");
INSERT INTO yuw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ihoroc tongo idinya yangga wohogon Yesu yu inong yuna yu fano Sebedi orin youp wabkaracni girang obugudec idungma yu imun fauna engga Yesu tan tonggomoroc. ");
INSERT INTO yuw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Oro, Yesuho youp amnani woroc yauna Kaperneam taun woce onggung. Woce ongga idiya Sabat bongonodec yu Yuda nanohon fatmata yocyoc bucin öngmuna suraro fatmata ogepma fandat inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kopotorocho yu gesö imuna orongi sinom yogoc. Worocha tongga suraroho yuhon mata kombingmuya nanga fatfat togung. Yuda nanohon nongoru gendic fandat fandat amna yu wömai mata gesöno muno yongidung mahong Yesu yu iho matongidoc, yu gesönobarac yongidoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Oro fatmata yocyoc böc wocin amna auho idoc. Yudec wömai dogu boyömo au itmuna ecnang sinom mamboda yogoc, ");
INSERT INTO yuw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yuuu Yesu Nasaretma goc nonot yaöhong tong nimoc nimocha eparoc? Goc non yoi obukoc obukocha eparochu? Noc goc kombing gampat, goc Kopotorochon Kunkun Amna woroc.” ");
INSERT INTO yuw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Dogu boyömpho ihoroc inuna Yesuho mata orongi ingoroc inogoc, “Goc öpgon ida amna wo imi fauna ongoi!” ");
INSERT INTO yuw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ihoroc inuna dogu boyömpho amna wo sogitmuna toup sinom fenda korengmun onguna ecnang sinom mambotmuna amna wo imun faunto onggoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ihoroc tuna suraro wo angmuya toup soroc yongo mata inun ganun tongo Yesuha yogung, “Mayain ngomai tingtingno sinom oro? Kopotorocho yu gesö imuna mata gesönobarac yac. Yu dogu boyömo inuna matano sumbodidang,” suraro yu ihoroc yong tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Oro mit wömai Yesuhon fatno morömaho guroc worochon böcsa danong ongbödeuna owi amna ambarac kombigung. ");
INSERT INTO yuw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Oro Yesu yu fatmata yocyoc böc wo imun fauna Jems orin Jön yuot kondonggon ongga Saimon orin Andruho bucin ögung. ");
INSERT INTO yuw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tuna Saimonthon körano yu godip mönmön tongmuna abamdec dungo idoc. Ihoroc tuna ‘Yesu yu tun orokotun’ yongo inogung. ");
INSERT INTO yuw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Inuya Yesu owi worocot ongmuna oburo sogitmuna tun fadagoc. Ihoroc tuna wohogon godip mönmön obukocho owi wo imun fauna yu ongmuna nacno tong arangarang tongo imogoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Oro, dobocsisia sep urop ohongina, owi amna yu nucni obukocnimahu o dogu boyömoho fogit fogityimahu yu ambarac yangato Yesuot febung. ");
INSERT INTO yuw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ihoroc tuya böc moröm ambaracho engmuya Yesu idocan böc amante suran tongga idung. ");
INSERT INTO yuw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tuya Yesu yu owi amna obukoc foro ihono ihononima koböcma youn orokogung. O ihorocgon yu dogu boyömo koböcma dong yandoc. Oro dogu boyömo yu wömai Yesu kombing imogung. Worocha tongga Yesu yu yuhon foro yong fandat tongoninga yongo ‘muno’ inuna yu öpgon idung. ");
INSERT INTO yuw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Oro, sa isuna Yesu yu böcsa wo imun fauna sa amna maiyan woce ongmuna dönac youp togoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tuna Saimonot nucniot yu Yesuha dabigung. ");
INSERT INTO yuw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Dabing tongmuya angga inogung, “Owi amna ambaracho goc gacgacha yang.” ");
INSERT INTO yuw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ihoroc inuya Yesuho inogoc, “Non böcsa ambehecgon idtonggungma woce ongmanaina nocho yu fatmata ogepma fandat inontat. Nocho ‘youp woroc sinom towa’ yongo ebot,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tongo yu Galili guroc danong itongdup tongo Yuda nanohon fatmata yocyoc bucin öngmuna fatmata ogepma surarodec yong silip tong impi dogu boyömo dongyan tongoi ihoroc tong tongga itonggoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Oro, amna au obukoc lepra toctocyi yu Yesuot engmuna goruc yemoc tongo dönac ingoroc inogoc, “Moröma, goc kombiya angit idinai goc ogep noc ti orokuna noc Kopotorocho yangamin sacsago em.” ");
INSERT INTO yuw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ihoroc inuna Yesu uroc imuna oburo yudec out tohongga inogoc, “Nocho ‘goc orokoti’ yongo kombihat. Goc Kopotorocho yangamin sacsago iti.” ");
INSERT INTO yuw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ihoroc inuna wohogon obukoc lepra worocho amna imun fauna yu orokogoc. ");
INSERT INTO yuw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tuna Yesu yu inong muto garac mata orongi ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Goc yapmu ngo gocdec öngkucma worochon fatno amna au inirocha. Muno, goc ongga godiba öret socsoc amna indahi. Tongo Möseho nongoru sigocma worochon toroc öreta tiruc. Ihoroc tia owi amnaho gangmuya kombiantang, boinno sinom, obukoca bödeuna gocu Kopotorocho yangamin sacsago itaroc.” ");
INSERT INTO yuw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yesu yu ihoroc inogoc mahong amna wo yu ongmuna muyu nucni woce woce orokogocmahon fatno yong fandat tonggoc. Yu ihoroc togocmaha tongga Yesu böcsa auhon eran onggongno wönggon maidoc. Muno yu sa amna maiyan wocegon ididoc mahong owi amna böcno wocema wocemaho toup kiringga yuot epgon togung. ");
INSERT INTO yuw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Oro, sep youp toctoc au ongbödeuna Yesu yu wönggon Kaperneam bucin ongga idina owi amna yu Yesuhon fatno ingoroc kombigung, ‘yu urop ino bucin itac yo’. ");
INSERT INTO yuw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Fatno ihoroc kombigungmaha tongga owi amna koböcmaho yuot engmuya suran tongga böcno wo foc tongga idiya bego au maidoc. O böc amante ihorocgon owi amnahogon foc dabang sinom tongga idung. Ihoroc tuya Yesuho yudec Kopotorochon fatmata ogepma yong silip tong imogoc. ");
INSERT INTO yuw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tuna amna awanomuno yu nucno au orungo oburo mong toctocyi yu sumboda tebung. ");
INSERT INTO yuw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tengga agungmai owi amnaho böc simbu foc tongga idiya Yesuot onggongon bego au maidoc. Tuna yu uyapha dabiu matuna böc bong koroc öngmuya böc bong girato nucno fadangdec idocma wo siuya Yesuot ohogoc. ");
INSERT INTO yuw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ihoroc tuya Yesuho yagocmai yuhon kombing tobic tobicno moröma sinom. Woroc agocmaha yu amna wo inogoc, “Manana, turongoya urop bödehac.” ");
INSERT INTO yuw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ihoroc inuna nongoru gendic fandat fandat amna au wocin idungma yu mata wo kombingga yogung, ");
INSERT INTO yuw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ei, mata ihorocnoma Kopotoroc-decgon itac. Amna auho nucnihon turongono imun fatfatno wömai maec. Yu Kopotorocha yong samborec yac yo.” ");
INSERT INTO yuw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ihoroc yuya Yesuho amna worochon irot kombic kombic urop kombingdengga mata urago ingoroc inogoc, “Son foro yaha irot sonin nocha kombing moin moin tang? ");
INSERT INTO yuw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nocu amna ngo yaö matahong inoya sonthon kombic kombicdec angit in? Mata ingorochu intiwa: Noc gochon turongo dongya fat gamang. O ingo yontatma wömai ogep inthu: Goc idongga abam yoroca sogitmina ongoi. ");
INSERT INTO yuw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Son ingoroc kombiarut, Amnahon Manano yu guroc ngocin itonguna Kopotorocho yu turongo dongyun fatfathon gesö imogoc.” Yesu ihoroc inongga amna obukocnima inogoc, ");
INSERT INTO yuw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nocho gantiwa, goc idongga abam yoroca sogitmina böcan ongoi.” ");
INSERT INTO yuw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ihoroc inuna wohogon amna worocho idongga owi amnaho yangamin böc wo imun fadoc. Tuna owi amna yapmu fodibo wo angmuya nanga fatfat tongga Kopotoroc yong moröng imongo yogung, ‘Kiapmo ihorocno wömai nonu fodibo sinom aamon’ ihoroc yong tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Oro, Yesu yu wönggon Galili yamuc öngkoring tan woce itongga idina owi amna koböcmaho yuot ebung. Ehuya yu Kopotorochon fatmata ogepma fandat inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ihoroc inongga wönggon obmuku-suc ongga agocmai Livai yu takis möneng fogit fogit bucin idoc. Livai yu Alfiushon manano. Yu woce idina Yesu yu inong yongga inogoc, “Goc engga noc nari!” Ihoroc inuna Livai yu möneng böc wohogon imun fauna Yesu tan tonggoc. ");
INSERT INTO yuw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tuna Yesuho Livaiho bucin uuna takis möneng fogit fogit amnahu o wontucmuno toctoc amnahu o youp amnani yu ambarac kondonggon woce itmuya nacno nagung. Amna koböcma sinom wömai urop Yesu tan tongidung. ");
INSERT INTO yuw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Oro yu nacno nongga idiya Farisi amna au nongoru gendic fandat fandat youp tongidungma yu yagungmai Yesuho amna wontucmuno ot nacno nongga idoc. Woroc yangga yu Yesuhon youp amnani ingoroc inong ac togung, “Yesu yu foro yaha sinom wontucmuno toctoc amnahu o takis fogit fogit amnahu yuot kondong ida nacno nongga itac yo?’ ");
INSERT INTO yuw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ihoroc inuya Yesuho matano wo kombingga ingoroc inogoc, “Amna obukocno muno yu ‘Doktaho tongfat nehun’ yongo makombingidang. Muno, obukocnimahogon wömai Doktaha kombingidang. Oro worochon toroc wömai nocu owi amna nongnongoha yongga maebot. Muno nocho ebotma woi wontucmuno toctoc owi amna inong yocyocha ebot,” Yesu yu mata urago ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Oro Jönthon youp amnanihu o Farisihu yu nacnoha gendic singga bongono au nacno manai ididung. Tuna owi amna au yu kiapmo worocha kombingga Yesuot engmuya ingoroc inong ac togung, “Jönthon youp amnanihu o Farisihon youp amnanihu yu nacnoha gendic singga manai ididang mahong gochon youp amnayai wömai ihoroc matongidang.” ");
INSERT INTO yuw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ihoroc yuya Yesuho mata tepmo au ingoroc iban imogoc, “Amna auho owi somonni min song imocimocha tuna numa amnaho muno yun? Muno, non ihoroc matongidamon. Owi min toctoc bongonodec wömai non muyu irot ogep kombingga nacno nana. ");
INSERT INTO yuw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wohong bongono au urop ehangoc. Bongono wocin wömai amna minno togocma yu sa korungon idina tong sonoc toctocno maic. Tuna bongono wocin wömai yu uroci kombingmuya nacnoha gendic singmuya nacno manai itnahing.” ");
INSERT INTO yuw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Oro Yesu mata tepmo au ingoroc inogoc, “Amna au yu tec tohomunmöcno osucno dogiantac. Tuna yu tec docno wego sogida tec osucno bubupno woi mabuhun. Ihoroc tunai wömai tec wegomaho tec osucno wodiuna dogitbödeantac. ");
INSERT INTO yuw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","O ihorocgon wain yamuc tobic tobic amna yu bot meme godibo osucnodec wain yamuc wego makoringidang. Ihoroc tuyai wömai wain yamuc wegoho ohongga out tuuna bot meme godibo osucno fuc tontac. Tuna wain yamuchu o bot meme godibo wo yait yait tong samborec tontamoroc. Worocha wömai yu wain yamuc wego bot meme godibo wegodecgon koringidang,” Yesu yu mata tepmo ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Oro, oipmon Sabat bongonodec Yesuot youp amnaniot yu wit öndec itongmuya youp amnaniho forosingga wit yitno fogito nong tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ihoroc tuya Farisiho wo yangga Yesu inogung, “Yahi, youp amnayai yu gendic mata noni yembodang. Sabat bongonodec ihoroc toctocha wömai bongbong morö itac.” ");
INSERT INTO yuw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ihoroc yuya Yesuho inogoc, “Oro, sonu Devitho osuc kiap togocma worochon fatno embatho makombingidanghu nuhun? Devithon toropni o ino yu manomanoha docmöngga nacnoha worec imogung. ");
INSERT INTO yuw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tuna öret socsoc amna moröma Abiatar yu öret socsoc böc angtoregocan bongono wocin wömai Devitho öret socsoc böc ganang öngga nacno sowarango Kopotorochon fatha fong figungma wo fogida nagoc. Nacno sowarango worocho ungoma ididocmaha tongga öret socsoc youp amnahogon nongidung, amna komanangno muno. Wohong Devit yu wo fogitmuna nongga docno wömai silip tongga nucni imogoc.” ");
INSERT INTO yuw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu yu ihoroc yongga mit mata sakaun fiuna yogoc, “Kopotoroc yu Sabat bongono amna tongfat yecyecha sigoc. Yu mepmo imocimocha wömai masigoc. ");
INSERT INTO yuw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Worocha tongga Amnahon Manano yu Sabat bongonohon morömo.” ");
INSERT INTO yuw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Oro oipmonu Yesu yu Yuda nanohon fatmata yocyoc bucin ögoc. Öngga agocmai amna au oburo omong fatfatyi yu wocin idoc. ");
INSERT INTO yuw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tuna amna au yu Yesu mataho firing tantantha uyap dabigung. Yu ‘Yesu Sabat bongonodec amna wo tun orokontachu’ yongo igo dan togung. ");
INSERT INTO yuw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ihoroc tongga idiya Yesuho amna oburo omong fatfatyi inogoc, “Goc suraroho yangamin idongga iti.” ");
INSERT INTO yuw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ihoroc inuna idonguna Yesuho amna igo dan togungma inogoc, “Nongoruho tingting yac, non ogep Sabat bongonodec youp ogepma tontamontha woha youp wontucmuno tontamonthu? O ihorocgon non ogep Sabat bongonodec nucnoni tong ogep tong imontamontha woha non muyu yu dopnaya omaruthu nuhun?” Yesuho mata ihoroc inuna amna worocho mata mayi onggom songga idung. ");
INSERT INTO yuw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ihoroc idiya Yesu yu foring yangmuna kombigocmai yuhon irotno sop simbang foctogoc. Worocha tongga yu ec imuna amna oburo omong fatfatyi inogoc, “Goc obura tong nongnong toi!” Ihoroc inuna amna wo oburo tong nongnong tuna oburoho orokongdup togoc. ");
INSERT INTO yuw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tuna Farisi wo angga böc imu fauna king Heröthon toropniot suran tongga ‘Yesu yaö uyapdec wotnahamon’ yongo yong torop sigung. ");
INSERT INTO yuw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesuot youp amnaniot yu ‘nonigon itna’ yongo böcsa wo imu fauna yamuc öngkoring tero onggung mahong Galili owi amna koböcmaho yu yan fonggung. ");
INSERT INTO yuw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yan fonggungma woi owi amna Yudia gurocinmahu o Yerusalem taundecmahu o Idumia gurocinmahu o owi amna guroc Yodan yamuc ökenne idocmahu o taun Tair orin Saidon worochon owi amna yu ambarac Yesuhon fatno moröma kombingga yuot ebung. ");
INSERT INTO yuw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ihoroc tuya yangga Yesuho youp amnani inogoc, “Owi amna nucno köreun köreun toup sinom tuya nochon bego angit maec. Worocha son girang obugu au tong arangarang tuya nocho wocin öantat,” ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yu owi amna koböcma sinom doun orokogungmaha owi amna obukocni yu ‘Yesu wotmöngga orokona’ yongo nucno köreun köreun toup sinom togung. ");
INSERT INTO yuw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","O ihorocgon owi amna dogu boyömoni yu Yesu angga goruc yemoc tong imongo mamboc morö tongga yogung, “Yaiöö, Yesu goc Kopotorochon Manano.” ");
INSERT INTO yuw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ihoroc yuya Yesuho ‘yu nochon foro yong fandat tongoninga’ yongo ‘muno’ orongi sinom inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Oro, Yesu yu sa urongodec öngmuna amna soworengga ino kombigocma yu inong yuna ebung. ");
INSERT INTO yuw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ehuya yu amna 12 ihoroc youpha soworengga aposel ma imogoc. Yesu yu ‘amna wo nocot kondonggon itongonahamon’ yongo o ihorocgon ‘nocho yu fiaya ongmuya fatmata ogepma owi amnadec yong silip tong imong tongonung’ yongo amna torop wo soworegoc. ");
INSERT INTO yuw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Soworengga yu dogu boyömo dong yanyanthon gesö sing imogoc. ");
INSERT INTO yuw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Oro amna 12 soworegocma yuhon ma torop wömai ingoroc: Saimon, yuhon mano auma wömai yu Pita ihoroc mambodoc. ");
INSERT INTO yuw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","O Sebedihon mananin yai Jems orin Jön. Yuhon mano au wömai yu Boanesis ihoroc mambodoc. Ma worochon foro woi undiphon mananin. ");
INSERT INTO yuw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","O amna au idungma manoi, Andru, Filip, Bartolomyu, Matyu, Tomas, o Alfiushon manano Jems, o ihorocgon Tadius, o Saimon yui Selothon toropdecma. ");
INSERT INTO yuw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","O Yudas Iskariot, yu wömai mit Yesu ayamihon oburodec sigoc. Amna torop wo wömai Yesuho ‘nochon youp amnanai idarut’ yongo soworegoc. ");
INSERT INTO yuw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Oro, Yesu yu bucin öngga youp amnaniot nacno nocnocha kombigoc mahong owi amna koböcmaho engmuya böc foc tongdup tongga nacno nocnochon bego au maidoc. ");
INSERT INTO yuw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ihoroc tuya Yesuhon nip orugiho fat wo kombingga yogung, “Yesu yu bumbum yongga tac yo.” Ihoroc yongga yu ‘Yesu böcnon yangat tongona’ yongo ebung. ");
INSERT INTO yuw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tuna nongoru gendic fandat fandat amna au yu Yerusalem taundec engmuya Yesuha ingoroc yogung, “Dogu wontucmunohon morömo mano Belsebul yu amna ngorocdec idina dogu boyömo dong yanitac yo,” ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ihoroc yuya Yesu mata wo kombingga owi amna inuna ehuya mata tepmo au ingoroc inogoc, “Dogu kopot yu wömai dogu kopot nucni madong yanitac. ");
INSERT INTO yuw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","O ihorocgon Kantri auho ficfuc tongga owi amna inohogon emoc tontanganu wömai kantri worocho obukontac. ");
INSERT INTO yuw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","O ihorocgon böcsa au yu ficfuc tongga böc morömpho inoha emoc tontanganu wömai gesöno ohongga makoing sic. ");
INSERT INTO yuw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","O worochon torocgon dogu kopotho inoin nucni ayam tontacanu wömai yu makoingsic, muno yuhon gesö bödeup. ");
INSERT INTO yuw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kombiarut, amna au yu amna koingoho bucin öngmuna manomanono usem toctocno wömai maec. Osuc wömai yu böc morömphon orung oburo feto singga mit wömai yu ogep manomanono yongo usem fongontac. ");
INSERT INTO yuw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nocho boinno sinom kantiwa, Kopotoroc yu owi amnahon wontucmuno ambarac younfat imangoc. O owi amnaho Kopotorocha yong saha yongidangma worochon turongo ambarac younfat imangoc. ");
INSERT INTO yuw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Wohong amna au yu Kunkun Yaruhon youpha yong samborec yontacma yuhon turongono wömai Kopotorocho mit maimunfat imic. Muno sinom, turongo worocho wömai mabödec bödecno öngahontu o mithontu woi tohong singimuna idimangoc.” ");
INSERT INTO yuw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Oro Yesuho mata wo yogocma wömai nongoru gendic fandat fandat amnaho ‘dogu wontucmuno au yudec itac,’ ihoroc yongo yogungmaha yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Oro Yesu mata ihoroc yongga idina urop macni orugi böcsa woce engkubung. Engkungga böc amante ida ‘Yesu epun’ yongo mata siuya bucin ögoc. ");
INSERT INTO yuw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mata siuya owi amna bucin idungma yu Yesu inogung, “Macai, oröcai yu engmuya gocha yang.” ");
INSERT INTO yuw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ihoroc inuya Yesuho mata ökene ingoroc iban imogoc, “Nochon macnai oröcnai woi numari?” ");
INSERT INTO yuw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ihoroc yongmuna daroho owi amna yuot arenggumbec tongga idungma wo foring yangmuna yogoc, “Nochon macnai, oröcnai, woi woroc son ngo idangma. ");
INSERT INTO yuw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Owi amna ambaracho Kopotorochon irot kombic kombic tanidangma yu wömai nochon oröcnai, natnai, macnai sinom idang.” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Oro, oipmonu Yesu yu wönggon Galili yamuc öngkoring tero wocin owi amnadec fandat fandat youp togoc. Ihoroc tongga idina owi amna koböcma sinom engmuya sing arenggumbec togung. Worocha tongga Yesu yu girang audec bangmun uuna obmukusuc yamucdec onguna owi amnaho yamuc terodecgon idung. ");
INSERT INTO yuw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ihoroc idiya Yesuho forosingga manomanohon foroha mata tepmo fandat inongga ingoroc yogoc, ");
INSERT INTO yuw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kombiarut, amna auho ongga wit yitno öndec antogoc. ");
INSERT INTO yuw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Antongina yitno au uyapdec muuya yupho engmuya nagung. ");
INSERT INTO yuw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Oro wit yitno auho wömai sop koroc guroc obmukusucgon iyan woce mögung. Tongo guroc obmugon idocmaha tongga yu karupgon dogo köbung. ");
INSERT INTO yuw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Dogo kungga idiya sepho öngga yitnodec foring yagoc. Tuna yitno wo fonsirango omoce mahogungmaha tongga sepho diuna song gebung. ");
INSERT INTO yuw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oro, wit yitno au yu yi dirongo tumoc woce ohuya yiho kungga wit yitno tombuya boinno muno ida ombung. ");
INSERT INTO yuw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Oro, wit yitno auho guroc ogepmadec mögung. Woce ida dogo köngmuya boinno ogepma figung. Auho 30hon toroc, au 60hon toroc o au wömai 100thon toroc ihoroc boinno figung.” ");
INSERT INTO yuw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu yu ihoroc yongbödengga mata sakaun fiuna yogoc, “Amna auho onggimobarac idai wömai yu mata ngo kombiun.” ");
INSERT INTO yuw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Oro, mit owi amna koböcmaho Yesu imu fauna Yesuhon youp amnani 12 yu orin owi amna au Yesu tanidungma yuhogon itmuya Yesu mata tepmo yogocma worochon foroha inong ac togung. ");
INSERT INTO yuw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Inuya Yesuho ingoroc inogoc, “Kopotorochon toborucnohon foro wömai eran maec. Wohong Kopotorocho son kang banagocmaha tongga sonu wo urop kombiang mahong owi amna auha wömai nocho mata tepmogon inongitat. Ihoroc toya Aisayaho mata yogocma worocho boinno entac: ");
INSERT INTO yuw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Owi amnaho dan foric tontang mahong yapmu au angtangtang matoning. O ihorocgon yu matahon kekoröpno kombiantang mahong mata worochon foro tuctugo makombining. Kombing tangtang tonggahai wömai yu ibaru fauna Kopotorocho yuhon turongono imun fat imun.’” ");
INSERT INTO yuw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Oro mit Yesuho mata sakaun fiuna youp amnani inogoc, “O sonidec, sonu wit yitnohon mata tepmohon foro ihorocgon makombiinghu nuhun? Sonu mata tepmo ngo makombing tuctuc tanganu wömai sonu mata tepmo au ihorocgon makombining. ");
INSERT INTO yuw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Oro foro wömai ingoroc: Amna auho yitno öndec antonggoc. ");
INSERT INTO yuw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Antonguna yitno auho uyapdec mögung. Oro owi amna au yu wömai yitno woroc simbang. Yu wömai Kopotorochon mata kombingidang mahong dogu kopotho karupgon engmuna mata ogepma wo irodinma fuun deantac. ");
INSERT INTO yuw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Oro, owi amna au yu wömai yitno sop koroc mögungma woroc simbang. Yu wömai Kopotorochon mata kombingga sogida borongdedidang. ");
INSERT INTO yuw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Wohong yitnoho fonsirangono guroc ganang angit mahogocmaha tongga yu bongono docutnogon ogep itnahing. Tuna mataha tongga mepmo au yudec öngkuantacanu wömai yu kombing tobic tobicno karupgon imu faantac. ");
INSERT INTO yuw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Oro, owi amna au yu wömai yitnoho yi dirongo tumoc mögungma woroc simbang. Yu wömai Kopotorochon mata kombingidang ");
INSERT INTO yuw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mahong guroc ngorochon mepmoho orin möneng yoctec manomano worochon ibiboho wömai yu imanang tonguc yec imongga Kopotorochon mata tombuna boinno muno engoc. ");
INSERT INTO yuw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Oro, owi amna au yu wömai wit yitno guroc ogepmadec mögungma worochon toroc. Yu wömai fatmata ogepma kombingga irotnon sogit akep tongidang. Tongo yu boinno ogepma fingidang, auho wömai 30hon toroc, o auho wömai 60hon toroc, o auho wömai 100thon toroc ihoroc fingidang.” Yesuho withon mata tepmohon foro ihoroc yong tuctuc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesuho wönggon mata tepmo au ingoroc inogoc, “Amnaho gop gata wö gananghu o abam unehu woce masingidang. Muno sinom amnaho wömai gopno gato abam korocgon siuya yaguno möng imontac. ");
INSERT INTO yuw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Worochon toroc wömai manomano öp idangma worocho mit eran öngkupnahing. O ihorocgon manomano amnaho öp yau wedidangma worocho eran öngkungbödeuya amnaho yango tuctugo kombinahing. ");
INSERT INTO yuw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Amna au yu onggimobarac idai wömai yu mata ngo tuctugo kombiun.” ");
INSERT INTO yuw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesuho wönggon yogoc, “Son onggim soni nochon mataha ogepma siarut. Sonthon kombic kombic sonihon torocnodec wömai Kopotorocho kombic kombic soni sakaun fiuna kombic kombic wego kamuna moröma engoc. ");
INSERT INTO yuw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kombiarut, amna au yu mom toboruchon foro urop obmukusuc kombiang. Tuna Kopotorocho yuhon kombic kombicno obugu wo sakaun fiuna yu worochon foro tuctugo sinom kombingbödenahing. Wohong amna au yu mom toboruchon kombic kombicha kombiuya sahano itacma yudec wömai Kopotorocho yuhon kombic kombicno ambarac fuun deuna bumbum yongbödenahing.” ");
INSERT INTO yuw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesuho mata sakaun fiuna ingoroc yogoc, “Kopotorochon mom toborucnohon foro wömai ingoroc: Amna au yu ongga yitno öndec antonggoc. ");
INSERT INTO yuw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Oro amna wo yu kumbong dungo entachu o yu sep bongonodec wec entachu yitno worocho wömai amna wo etno idina komong dogo köngga mac fiantang. ");
INSERT INTO yuw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Guroc inohogon wömai youp tongmuna yitno wo tong iban iban tuna yitnoho dogo köngga mac fingga sakem tangga boinnoho monyu öngidang. ");
INSERT INTO yuw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ihoroc tuya amnaho auna boinno urop orokongga idiya yu ‘urop nacno tonoc tonoc bongono epac’ yongo nacno tonongga bucin feantac.” ");
INSERT INTO yuw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuho mata sakaun fiuna yogoc, “Kopotorochon mom toborucno wo tingtingno sinom, o nocho yaö mata tepmo kanoya sonu worochon foro tuctugo kombiantang? Wömai ingoroc, ");
INSERT INTO yuw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","mom toboruc woi mastet yitno simbang. Mastet yitno woi obugu sinom, manomano yitno au gurocdec möngidamonma wömai worochon toroc maeng. ");
INSERT INTO yuw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mastet yitno woi obugu sinomthong gurocdec mönggai macfingga ep moröma ida nacno au öndec ididangma woroc yanggiraditac. Tuna yupho engmuya betomodec yingo tongga ididang.” ");
INSERT INTO yuw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Oro Yesu yu owi amnahon kombic kombic soworengga worochon toroc mata tepmo koböcma ihorocnogon yong fandat inongidoc. Yu wömai ‘owi amna Kopotorochon fatmata ogepma tuctugo kombiarut’ yongo ihoroc togoc. ");
INSERT INTO yuw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Oro surarodec wömai Yesuho mata tepmogon inongidoc mahong youp amnani wömai yu mata tepmo worochon foro ambarac inong tuctuc tongidoc. ");
INSERT INTO yuw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Oro, bongono wocingon dobocsisisa, Yesuho youp amnani inogoc, “Non yamuc öngkoring gino ökene ongona.” ");
INSERT INTO yuw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ihoroc inuna youp amnaniho owi amna torop morö wo inong muya onggung. Onguya youp amnani girang Yesuho idocan wocin bangmu uuna yamuc bonipnodec onggung. Onguya owi amna torop au yu ihorocgon girang obugu audec öngga yu yan fonggung. ");
INSERT INTO yuw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yamuc bonipnodec idiya karupgon sum moröma busuna yamuc funfuroho girang ganang ohuna girang wo foc toctocha togoc. ");
INSERT INTO yuw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ihoroc tuna Yesu yui girang menon pilo audec dungga idoc. Dungo idina youp amnaniho Yesu tu wekuna inogung, “Fandat fandat amna, goc makombiroc, non urop yamuc tumoc ohonggonga tamon yo!” ihoroc inuya ");
INSERT INTO yuw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesuho idongga sum inong fato inogoc, “Sum, goc onggom songga imi fahun,” ihoroc inuna sum yu imun fauna yamuc nongnong yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tuna Yesuho youp amnani inogoc, “Sonu yaöha botodang oro? Sonu kombing tobic tobic soniu abe maechu nuhun, woha ihoroc yang?” ");
INSERT INTO yuw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yesuho ihoroc inuna youp amnaniho toup sinom botongmuya inohogon mata inun ganun tongga yogung, “Mayain, amna ngoi numa sinom. Sum orin yamuc funfuro yu yuhon mata kombingo nongnong yamoroc,” ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Oro mit Yesuot youp amnaniot yu Galili yamuc öngkoring gino okocene ongga Gerasa nanohon guroc woce ongkubung. ");
INSERT INTO yuw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ong-kungmuya Yesu yu girangdecma bangmun möngina wohogon amna au dogu boyömnima yu domdomgon Yesuot eboc. ");
INSERT INTO yuw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Amna wo yu amna fiiyan kumkumon sa woce itongidoc. Yui amna dunggit sinom idocmaha amna auho yu sogida orung oburo yi koingodechu o sendechu feto akep toctocno woi maidoc. ");
INSERT INTO yuw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Suraroho wömai amna wo sendec akep tongo singidung mahong yu kudat tongga sen orin hankap doun dogiuya ongidoc. Worocha wömai amna auho yu sogit sogitno wömai maididoc. Muno yu amna orongi sinom. ");
INSERT INTO yuw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yu wömai sepno sepno o kumbongno kumbongno amna kumkumonthu o sa urongodechu woce mata kararatgon yongmuna itongo sopdec inoin godip föbo mang tongidoc. ");
INSERT INTO yuw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Oro, amna worocho korungon ida Yesu angmuna domdomgon ohongmuna Yesuhon orungo forodec möngga ");
INSERT INTO yuw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","idina Yesuho inogoc, “Goc dogu wontucmuno, goc amna ngo imi fauna ongoi!” Ihoroc inuna amna wo mata kararat sinom yongga yogoc, “Ayöö Yesu, gocu Kopotoroc onoce sinom yuhon Manano, goc yaö tong namnampha eparoc? Goc Kopotorochon madec yong koing yoi, goc focfoc namongga noc ti obökitha,” dogu wontucmuno amnadec idocma yu ihoroc mambodoc. ");
INSERT INTO yuw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tuna Yesu inogoc, “Goc maya numa?” Ihoroc inuna dogu worocho yogoc, “Non toropnaiu koböc, worocha noc mana ami, ihoroc.” ");
INSERT INTO yuw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ihoroc inongga yu ‘Yesu noc sa guroc audec nanong muicyit’ yongo Yesu dönacgon inong tohogoc. ");
INSERT INTO yuw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Oro, sa urongo woce wömai bot torop moröma sinom ambehecgon nacno nongga idung. ");
INSERT INTO yuw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tuna dogu boyömpho Yesu mata orongi ingoroc inogung, “Gocho non ning banangga niria bot irotnon ohona.” ");
INSERT INTO yuw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ihoroc inuna Yesu yu kombing imuna dogu boyömpho amna wo imu fauna bot irotnon ohongbödegung. Ohongbödeuya bot torop wo yu domdomgon ohongga sa bohöng yamuc öngkoring ganang ohongga omongbödegung. Bot worochon nambano wömai 2,000 ihoroc ombung. ");
INSERT INTO yuw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ihoroc tuya amna bot wo yangtorengidungma yu yapmu woroc angbotongmuya domdomgon ongga worochon fatno inoin böcsanodechu o böc au ambehec idungma woce inong tonggung. Tuya böc moröm yu ‘tingting sinom öngkuboc’ yongo Yesuot ebung. ");
INSERT INTO yuw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Engga agungmai, amna dogu boyömonima yu boru temongga kombiun tuctuc yuna idoc. Ihoroc idina angmuya owi amnaho botogung. ");
INSERT INTO yuw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tuna amna yapmu öngkubocma wo ino darodec agungma yu owi amna worochon fatno fandat inogung. Woi Yesuho dogu dong yandocma o ihorocgon botho yaö kiap togungma worochon fatno inongdup togung. ");
INSERT INTO yuw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ihoroc inuya kombingga yu ‘Yesu sa guroc wo imun fauna sa auhon ongoun’ yongo mata orongi inogung. ");
INSERT INTO yuw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tuna Yesu yu girangdec bangmun uuna amna dogu kopot boyömonima dong yan imogocma yu ‘Yesuot ongowa’ yongo Yesu dönac orongi inogoc ");
INSERT INTO yuw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","mahong Yesuho ‘muno’ yongo ingoroc inogoc, “Goc böcan ongmina Morömaho goc gang banango ogepma sinom tongfat gegocma worochon fatno nip oröcai iniruc.” ");
INSERT INTO yuw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yesuho ihoroc inuna amna wo ongga guroc au mano ‘ten taun’ woce itongmuna Yesuho ogepma sinom tongfat yegocma worochon fatno owi amnadec yong moröging tonguna owi amnaho fatno kombingga nanga fatfat togung. ");
INSERT INTO yuw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Oro, Yesu yu wönggon Galili yamuc öngkoring ökene ongga idina owi amna koböcma sinom Yesuot engmuya suran togung. Oro Yesu yu abe yamuc öngkoring tan ");
INSERT INTO yuw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","idina Israel nanohon fatmata yocyoc böc angtorec amna au mano Yairus yu eboc. Yu engmuna Yesuhon orungo forodec goruc yemoc tongga ");
INSERT INTO yuw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yesu dönac orongi ingoroc inogoc, “Nochon wena obugu yu omompha tac. Worocha goc engmina obura yudec siia orokongga itonggongno wönggon sogiun.” ");
INSERT INTO yuw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yairusho ihoroc inuna Yesu yuot onggoc. Yu uyapdec ongga idinya owi amna koböcmaho yu yan fongga nucno köreun köreun toup tong tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tuya owi au yu owi amna bonipnodec ongtonggoc. Yu wömai nogotnoho wuna biruc 12 ihoroc idoc. ");
INSERT INTO yuw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tuna dokta koböcmaho yu tu orokoc orokocha tu matuna focfoc morö kombingidoc. O yu doktahon wöngnacnoha mönengno ambarac komanang imun fadidoc mahong obukocnoho wömai mabödegoc. Muno sinom, obukocho yudec koingo sinom idoc. ");
INSERT INTO yuw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Oro owi wo yu Yesuhon fatno moröma kombigocmaha engga owi amna koböcmaho bonipnodec Yesuhon menon ongmuna oburoho Yesuhon tec tohomunmöcno wot mögoc. ");
INSERT INTO yuw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yu wömai kombigoc, ‘Nocho Yesuhon tec tohomunmöcno wot muantatanu wömai orokontat.’ ");
INSERT INTO yuw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ihoroc kombingga tecno wot möngmuuna wohogon nogotnoho manman yogoc. Tuna owi wo yu kombigoc, focfocho godip föbna urop imun fauna orokotat. ");
INSERT INTO yuw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ihoroc tuna Yesu yu kombigocmai, gesö auho yu imun fadoc. Ihoroc kombingga ibarun faunto owi amna inong ac tongga yogoc, “Numaho nochon tecna wot möhac yo?” ");
INSERT INTO yuw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ihoroc yuna youp amnaniho yogung, “Ahi, owi amna koböcma sinompho goc gang arenggumbec tongga nucno köreun köreun tongga ida goc got muang. Worocha goc tingtinga yaroc numaho noc not möhac yo?” ");
INSERT INTO yuw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ihoroc inogung mahong Yesu yu kiringga ‘numaho toc’ yongo owi amna foring yang tonggoc. ");
INSERT INTO yuw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ihoroc tuna owi wo yu kiapmo yudec öngkubocma woha kombingga botongga kudat konoc konoc tongga Yesuot engmuna orungo forodec goruc yemoc tong imongga fatno Yesu inong taboc. ");
INSERT INTO yuw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Inong tauna Yesuho inogoc, “Wena, goc kombing tobing namparocmaha tongga orokotaroc. Goc irot gucot ongoi. Obukoca wönggon maehic,” Yesuho owi wo ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Oro, Yesu yu abe mata yongo idina Yairusho bucinma amna auho engmuya Yairus inogung, “Weya urop omec, worocha goc fandat fandat amna ngo youp komanang imirocha.” ");
INSERT INTO yuw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yu Yairus ihoroc inogung mahong Yesuho mata worocha onggim masii Yairus inogoc, “Goc botirocha, nocgon kombing tobing nampi,” ");
INSERT INTO yuw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ihoroc inongga Yesuho ‘owi amna koböcma non ningat fongoninga’ yongo yu yang firigoc. Tuna Pita, orin yan oröcma Jems orin Jön, yuhogon wömai Yesuot onggung. ");
INSERT INTO yuw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ongga Yairusho bucin ongkungmuya yagungmai owi amna koböcmaho woce itfat yongga itmuya yong yaingga yong uroc ap yongga idung. ");
INSERT INTO yuw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tuya Yesu yu böc ganang öngmuna owi amna inogoc, “Son yaöha yong oin tongga yong uroc ap yongga idang? Managumboc yu mamec. Yui komanang dungga itac.” ");
INSERT INTO yuw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yesuho ihoroc inuna owi amnaho angyogudung. Ihoroc tuya Yesuho owi amna ambarac dong yaruna taitdec ohogung. Tuna managumbochon macnin fanin, o youp amnani anfi worochogon wömai Yesuot böc irotnon managumbocho idocan wocin onggung. ");
INSERT INTO yuw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ongmuya Yesuho managumbochon oburo sogitmuna inogoc, “Talita kum!” Mata worochon foroi ingoroc: ‘Owi obugu, nocho gantat, goc idongoi!’ ");
INSERT INTO yuw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ihoroc inuna wohogon owi obugu wo idongga böc irotnon itonggoc. Tuna owi amna woce idungmaho woroc angmuya soroc yogung. Owi obugu yuhon birucno wömai 12 ihoroc idoc. ");
INSERT INTO yuw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tuna Yesuho mata orongi inongga yogoc, “Son yapmu ngorochon fatno owi amna au fandat inoninga.” Ihoroc inongga yogoc, “Owi obugu nacno au imuya nahun.” ");
INSERT INTO yuw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Oro, Yesu yu böcsa wo imun fauna inoin böcsanon sinom Nasaret, woce onguna youp amnaniho yu tan tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Woce itmuya Sabat bongono ehuna Yesuho Yuda nanohon fatmata yocyoc bucin öngga Kopotorochon fatmata ogepma surarodec yong fandat inogoc. Tuna owi amna koböcmaho fatmata wo kombingga soroc yongga yogung, “Mayain amna ngoi mata nahema sinom fengga yac? Numaho kombic kombic orongi ihorocno imuna yu momphon toroc irömbu ihono ihono tongitac yo? ");
INSERT INTO yuw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Non amna ngo kombing imamon, yu kapenda youp tongitac yo. O yuhon macno Maria, o orugi Jems, Yosis, Yudas, Saimon yu woroc nonu kombing imamon. O natniu ambarac nonot ididangmai.” Suraro yu Yesuha ihoroc yong tongga kombiuya obukogoc. ");
INSERT INTO yuw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kombiuya obökuna Yesuho yu inogoc, “Owi amna böcsa danong yu wömai Kopotorochon yong tuctuc amnaniha gending imongidang mahong inoin böcsanon sinomu o nip orugihu yuhogon wömai maang gendingidang,” Yesu ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tongo yu sa wocin momphon toroc kiap inobarac koböcma matogoc. Yu oburoho obukoc owi amna tungu tungudecgon siuna orokogung. ");
INSERT INTO yuw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Oro Nasaret nanoho Yesu makombing tobing imogungmaha tongga Yesuho kombingbanac togoc. Oro, mit Yesu yu böcsa danong itongmuna Kopotorochon fatmata ogepma owi amnadec yong fandat inong tonggoc. ");
INSERT INTO yuw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tongo yu youp amnani 12 yu inong yuna ehuya yu ‘inoin madec dogu boyömo dong yanitnung’ yongo worochon gesö imongga yaitnigon inongmudoc. ");
INSERT INTO yuw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Oro Yesu yu youp amnani youphon yong fasun fasun mata ingoroc inogoc, “Son uyaphon manomano fongitninga. Kandöng worocgon wömai ogep fogiarut. Wohong nacnohu o yochu o mönenghu manomano ihorocnoma wömai fogitninga. ");
INSERT INTO yuw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Son orung tom soni ogep fohongyu öantang mahong tec tohomunmöc soni wömai tungutnigon sogiarut. ");
INSERT INTO yuw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Oro son böcsa auhon ongkuya böc morömpho sonthon idit böc au kamuyai wömai sonu wocingon itmuya böc au mongurac toninga. Muno wocingon idtongga son böcsa wo imu faangoc. ");
INSERT INTO yuw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Oro son böcsa auhon onguya böc morömpho oröc matong kamonggai o mata soni makombiuyai wömai sonu yu me imongo guroc tong fönfön orung sonidecma fororop tongyu muuya böcsa wo imu fauna ongonung. Ihoroc tuya böc morömpho kiap wo angga kombinahing, ‘Ayöö, non toroc kiap wontucmuno tong imogomonmaha tang yo,’ ihoroc kombinahing.” ");
INSERT INTO yuw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yesuho youp amnani yong fasun fasun mata ihoroc inuna yu böcsa wohon wohon itongmuya ‘owi amnaho irot ibararut’ yongo Kopotorochon fatmata ogepma fandat inong tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","O yu dogu boyömo koböcma owi amnadec dong yan tonggung. O ihorocgon yu owi amna obukocnima Kopotorochon madec unac wagang imongmuya you orokong tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Oro Yesuhon fatno moröma böcsa danong öngbödeuna king Heröt yu Yesuhon fatno wo ihorocgon kombigoc. Tuna amna auho wömai Yesuha yongidung, “Jön yamuc gupgup forosicsic amna yu omocdecma wekongga idonggoc yo. Worocha tongga yu momphon toroc kiap ihono ihono toctochon gesö idimpac,” ihoroc yongidung. ");
INSERT INTO yuw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","O auho wömai yongidung, “Yui Elaiya yo.” O auho yongidung, “Yu woi Kopotorochon yong tuctuc amna au yo. Kopotorochon yong tuctuc amnani osuc ididungma worocotma,” ihoroc yong tongidung. ");
INSERT INTO yuw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Oro king Heröt yu sum mata woroc kombingga botongga yogoc, “Ei Jönu, nocho osuc bangaro magotmai, oro yu omocdecma idongga tachu yo?” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Osuc wömai king Herötho inoin orugo Filip worochon oweno tongsigoc. Owi worochon mano wömai Herödias. Ihoroc tuna Jön yu kiap ihorocnoha kombiuna angit maidina Heröt inong fato inogoc, “Goc oröcahon owi usem tong sigorocmaha nongoru noni yembotaroc.” Ihoroc inuna Herötho ec imuna tawa amna inuna yu Jön yi bucin tohong singga sendec akep togung. ");
INSERT INTO yuw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Oro owi Herödias yu ihorocgon Jöntha toup ec imuna yu wot omom toctocha kombigoc mahong king Heröt yu Jöntha kombigoc yu amna kunkun nongnongo au. Heröt yu wömai Jönthon mata kombic kombicha toup kombingidoc mahong ökenne Jönthon matanoho yu toup sakang imuna kombingbanac tongidoc. Worocha tongga yu Jöntha botongidoc mahong tong batip togoc. Worocha tongga owi Herödias yu Jön wot omompha tun matogoc. ");
INSERT INTO yuw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Oro oipmonu wömai owi Herödiasho Jön tun omomphon uyap au ingoroc kombiun öngkung imogoc. Heröt yu ino öngkup öngkup-nohon tong sonoc au toctocha kombigoc. Tongo yu gavmanthon amna morömahu o tawa amnahon amna morömahu o Galili distrikhon amna morömahu yu ambarac inong wodiuna ebung. ");
INSERT INTO yuw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ehuya yu ambarac tong sonoc tongga idiya Herödiashon weno yu böc ganang öngo tong kumec au tuna Herödot amna moröma nucniot yu wo angmuya ibip imogung. Angibip tongmuya king Heröt yu owi berac ingoroc inogoc, “Goc gochon ibiba tanda yaöha kombingga nania nocho woroc ogep gamontat.” ");
INSERT INTO yuw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Heröt yu komanang mayogoc. Muno yu yong koing mata ingoroc sigoc, “Boinno onoce, goc yapmu auha ibip gamuna nania nocho worochon torocgon gamontat. O gocu nochon kantri ngorochon docnoha yontarocanu wömai nocho wo fuc tongga docno goc gamam.” ");
INSERT INTO yuw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","King Herötho owi berac ihoroc inuna yu böc irotno wo imun fauna macno ot ongmuna ingoroc inong ac togoc, “Mac, nocu amna moröma yapmu yaöha intiwa?” Ihoroc inuna macnoho inogoc, “Goc ongmina Jön yamuc gupgup forosicsic amna yuhon bigoha inti.” ");
INSERT INTO yuw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Oro, macnoho ihoroc inuna owi berac wo karupgon ongmuna king Heröt inogoc, “Noc ingoroc kombihat, inga ningo sinom Jön yamuc gupgup worochon bangaro mangga bigo wagadec singga nampi.” ");
INSERT INTO yuw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ihoroc inuna king Heröt yu mata woroc kombingga toup sinom soroc yogoc mahong yu urop amna morömaho yangamin yong koing mata yogocmaha tongga ‘yangam fap tityit’ yongo owi berachon mataha ‘öc’ yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tongo yu tawa amna au inongmuna ongga yi bucin Jönthon bangaro mangga wagadec singo teboc. ");
INSERT INTO yuw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tengmuna owi berac imuna yu tongga macno Herödias imogoc. ");
INSERT INTO yuw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Oro Jönthon youp amnani yu fat woroc kombingga engmuya Jönthon ep fambangno tongo kumkumon tohong sigung. ");
INSERT INTO yuw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Oro mit Yesuhon youp amnani youpha itonggungma yu ibaru fauna wönggon engga Yesuot suran tongmuya owi amnadec youp tonggungma orin fatmata ogepma yong fandat tonggungma worochon fatno yogung. ");
INSERT INTO yuw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yu fatno yongga idiya owi amna koböcmaho ongi epi toup tuya Yesuot youp amnaniot yuhon nacno nocnochon bego maidoc. Tuna Yesuho youp amnani inogoc, “Oro non nonigon sa amna maiyan woce ongmanaina sum sogitna.” ");
INSERT INTO yuw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ihoroc inuna yu ‘nonigon itna’ yongo girangdec bangmu uunto sa amna maiyan woce onggung. ");
INSERT INTO yuw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Wohong muno woi, owi amna koböcmaho onggongno wo yagung. Tuya böcsa danong owi amna koböcmaho yu guroc uyapdec tan tongga sa Yesu onggonga kombigocan woce osuc ongkungmuya yuha torec idung. ");
INSERT INTO yuw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ihoroc tuya Yesuho ihorocgon sa woce ongkungga owi amna torop moröma wo yangmuna uroc imogoc. Wömai yaha suraroho bot sipsip morömono muno ihoroc simbang idiya yagocmaha uroc imogoc. Uroc imuna yu forosingga Kopotorochon manomanohon foro fandat inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Inongga idina urop sep ohong-gorop wuna youp amnaniho yuot engmuya inogung, “Sa ngocinu wömai amna maididang. O sep urop ibarac. ");
INSERT INTO yuw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Worocha goc muyu owi amna torop ngo inongmuiya yu böcsa ambehecgon idangma woce ongmuya nacnono wöngga naarut.” ");
INSERT INTO yuw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ihoroc inuya Yesuho inogoc, “Son sonibut nacnoha tongfat yearut.” Inuna youp amnaniho yogung, “Mayain, nacno koböcma ihorocno wömai 200 Kinadec wönammai wömai ogep yo. Ihoroc tontamonthu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ihoroc yuya Yesuho inogoc, “Oro sonidec nacno sowarango tingting idang? Ongga yaarut.” Ihoroc inuna youp amnaniho ongga yangga inogung, “Non nacno sowarango obukema o söng yai ihorochogon idang.” ");
INSERT INTO yuw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Inuya Yesuho inogoc, “Son owi amna inuya yu fuc tongga tait ogepmadec dingno dingno idarut.” ");
INSERT INTO yuw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ihoroc inuya owi amna yu fuc tongmuya 100thon torochu o 50hon torochu ihorocho dingno dingno idtonggung. ");
INSERT INTO yuw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ihoroc idiya Yesu yu nacno sowarango obukema orin söng yai woroc fogito daro dedec foringo Kopotoroc ecec inongga nacno sowarango wo uboto youp amnani imuna yu suraro silip tong imogung. O söng yai wo ihorocgon silip tuna owi amna imogung. ");
INSERT INTO yuw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ihoroc tuya owi amna ambaracho nacno nongga modibo foc togung. ");
INSERT INTO yuw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tuya youp amnani yu nacno nong docno fogida dumbu 12 ihoroc oheuya foc togung. ");
INSERT INTO yuw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Oro, amna nacno wo nagungma worochon namba wömai 5,000 ihoroc idoc. ");
INSERT INTO yuw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Oro, Yesu yu wohogon ‘youp amnanai osuc fat namarut’ yongo yu inong muuna yu girang sogida forosingga yamuc öngköring aramo öke onggonga togung. Tuya Yesu ino wömai owi amna inong muuna uyap onggung. ");
INSERT INTO yuw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ongbödeuya yu inogon dönac yocyocha sa urongo audec ögoc. ");
INSERT INTO yuw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tuna sep urop ohongga idina youp amnaniho girangdec yamuc bonip sinom idung. Woce idiya Yesu inohogon yamuc tero ida ");
INSERT INTO yuw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","agocmai sumpho koingo sinom girang tamarodec busuna yamuc funfuro toup uuna youp amnani girang fasun fasuntha tu matogoc. Tuna sa isoc isocane Yesuho yamuc öngkoring korocgon sansantho yuot woce onggoc. Tongo urop yu yanggirato onggonga tuna ");
INSERT INTO yuw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","youp amnaniho yu auya yamucdec sansanto ongga idina kombigung, ‘Dogu auho yamuc korocdec epac yo.’ Ihoroc kombingga toup botongga yong yaigung. ");
INSERT INTO yuw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ambaracho woroc angga toup sinom botuya Yesuho karupgon inogoc, “Son koing songga idarut. Naka epat yo son botoninga.” ");
INSERT INTO yuw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ihoroc inongo girang ganang youp amnaniot uuna sum moröma urop imun fadoc. Tuna youp amnaniho soroc yongga nanga fatfat toup togung. ");
INSERT INTO yuw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Youp amna yu wömai Yesuho nacno sowarango tong guram togocma kiap inobaracma wo agung mahong yu abe Yesuhon foro kombing tangtang matogung. Muno, irotno abe koing songga idoc. ");
INSERT INTO yuw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Oro Yesuot youp amnaniot yu yamuc öngkoring kondong tongga Genesaret böcsa woce ongkungga girang kaning sigung. ");
INSERT INTO yuw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kaning singga girang imu faunto gurocdec ongidiya urop böc morömpho Yesu kombing imogung. ");
INSERT INTO yuw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tongo owi amna yu domdomgon böcsa danong ongmuya owi amna nucni obukoc tima wo fadang wöngga sumboda Yesu sa nahenne onggocan wocegon feng tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu yu böcsadechu o taundechu o sa amna maiyan wocehu idina owi amnaho woroc kombingga muyu nucni obukoc tima yu yuot yangat fengo maket taitdechu orin uyap tan wocin fing tongga Yesu dönac orongi ingoroc inong tonggung, “Goc ning banaiya non gochon tec tohomimöca sogito orokona.” Dönac ihoroc inongmuya owi amna tecno wot mögungma yu ambarac orokongbödegung. ");
INSERT INTO yuw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Oro, Farisi orin nongoru gendic fandat fandat amna au yu Yerusalem taun imu fauna Yesuot ebung. ");
INSERT INTO yuw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Engmuya yagungmai Yesuhon youp amnani yu oburo masacti nacno nagung. Yu ihoroc togungmaha tongga yu Yuda nanohon gendicno gumandung. ");
INSERT INTO yuw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisi orin Yudanano ambarac yu obu masati wömai nacno manongidung. Muno yu ombu sakungnihon gendic tanmuya oburo sac tonggagon nacno fogito nongidung. ");
INSERT INTO yuw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","O ihorocgon yu maketdecma böcnon enggai wömai yu osuc ombu sakungnihon toroc kiapdec yamuc gungidung. Tongo mit wömai nacno nongidung. Yu wömai ombu sakungnihon gendicno koböcma tan tongidung. Gendic auma wömai ingoroc tongidung, wö, waga, ting feret, woroc ombu sakungnihon toroc kiapdec sac tongga mit wömai youp imongidung. ");
INSERT INTO yuw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Oro, Farisi orin nongoru gendic fandat fandat amna yu inoin gendicnoha kombingga Yesu ingoroc inong ac togung, “Gakain youp amnayai yu foro yaha ombu sakungnonihon gendicno gumanda oburo masacwi nacno nongidang?” ");
INSERT INTO yuw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ihoroc yuya Yesuho mata ökene ingoroc iban imogoc, “Son imanang amna! Sonthon duc mata soni orin toroc kiap soni woi yaitni. Kopotorochon yong tuctuc amna Aisaia yu sontha kurömna sinom ingoroc yogoc: ‘Owi amna ngorocho wömai duchogon noc yong moröng namongidang mahong irot kombic kombicnoho nocha makombing namongidang. ");
INSERT INTO yuw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ihoroc tongo yuhon yong moröng kiap woi yapmu boyömo. O yuhon gendicno woi amnahon gendicgon Kopotorochon muno.’ ");
INSERT INTO yuw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Son urop Kopotorochon nongoru imu fauna amnahon gendic matagon kokorengidang. ");
INSERT INTO yuw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Boinno sinom sonu Kopotoroc tongu imongga yuhon nongoru kombic kombicbaracho dongyu fauya sonthon gendicsonigon tannidang. ");
INSERT INTO yuw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Möseho wömai Kopotorochon nongoru ingoroc kamogoc: ‘Son muyu mac nandöng soni gending imongitnung.’ O nongoru mata au ingoroc: ‘Amna auho macnohu o fanohu mata wöntucmuno inontacanu wömai suraroho yu wuya ompun.’ ");
INSERT INTO yuw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","“Nongoru ihoroc itac mahong sonthon gendic soni wömai ingoroc itac, ‘Amna au yu ogep mönenghu o yapmu au mac nandöng tongfat yecyecha sigocma wo sogida Kopotorochon ececha siun.’ ");
INSERT INTO yuw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Oro amna au yu gendic woroc tarantacanu wömai yu macni faniha magending imic, muno sinom. ");
INSERT INTO yuw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sonthon gendic soni worocho wömai Kopotorochon nongoru sinom wo taun weuna gendic sonihogon moröma itac. Son toroc kiap ihorocno koböcma tongidang.” ");
INSERT INTO yuw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Oro, Yesu yu wönggon owi amna inong yuna engsuran tuya ingoroc inogoc, “Kombiarut, son mata ngo kombing tuctuc tarut! ");
INSERT INTO yuw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Yapmu au sumonma amnahon irotnon ohontacma worocho wömai yu Kopotorocho yangamin matun bet faditac. Wohong yapmu amnahon irotdecma sumon öantacma worocho wömai amna Kopotorocho yangamin tun betfaditac,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tongo mit yu owi amna doun fauya bucin önguna youp amnaniho ‘mata tepmo worochon foro kombina’ yongo Yesu inong ac togung. ");
INSERT INTO yuw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Inuya Yesuho inogoc, “Sonthon kombic kombic soni abe mepmo itachu nuhun. Worocha son mata worochon foro makombing. Kombiarut, manomano sumon idangma worocho wömai amna dugo ganang ohongga modibin ida sumon ohongitac. Manomano ihorocnoho wömai amnahon irot kombic kombicnodec mahic.” Oro Yesu mata wo yogocma worochon foro wömai ingoroc: Non ogep nacno ambarac nongidamon. Nacnoha tongga non Kopotorocho yangamin mabet fatnin. ");
INSERT INTO yuw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Oro Yesuho mata sakaun fiuna yogoc, “Manomano amnahon irot kombic kombicnodecma öantacma worocho wömai tuna yu Kopotorocho yangamin betni entac. ");
INSERT INTO yuw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wömai yaha, amnahon irot kombic kombicdec wömai manomano wontucmuno ingoroc öngkungga ididang: Owi amna göra kiaphu o usem toctoc kiaphu o amna dong omom toctochon kiaphu o oimna tong samborec toctochon kiaphu ");
INSERT INTO yuw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","o gipmo toroc kiaphu o wontucmuno toctoc kiaphu o nucno inong yucyuc kiaphu o kombing bunbun kiaphu o nucnohon manomanoha yang ibip toroc kiaphu o mata mene yocyoc kiaphu o inoin manogon töctöc kiaphu o önggöngyi toctoc kiaphu ");
INSERT INTO yuw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","toroc kiap ihorocnoho wömai amnahon irot kombic kombicdecma öngkungga amna Kopotorocho yangamin tu bet faditac,” Yesu yu nacnohon gendic sicsicha mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu yu böcsa wo imun fauna bumbumyi nanohon gurocin ongmuna Tair taundec böc auhon ögoc. Tongo yu owi amna yang useng öpgon woce idoc mahong böc morömpho karupgon Yesuho woce itacno kombigung. ");
INSERT INTO yuw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ihoroc kombingmuya owi au yu ihorocgon Yesuhon fatno kombingga wohogon yuot engmuna orungo forodec goruc yemoc tongga idoc. Owi wo yu bumbuyi nanohon toropdecma Fonisia taun Siria kantridec woce öngkuboc. Yuhon weno wömai dogu boyömpho sogitsogityi idoc. Worocha tongga owi worocho engmuna ‘Yesuho dogu boyömo dong yarun’ yongo Yesu dönac orongi inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ihoroc inuna Yesuho inogoc, “Kombiharoc, osuc wömai managumbocho nacno nongbödeuya mit wömai sapho naarut. Non managumbochon nacno yongo sap imonaya yuho nocnocno woi angit maec.” ");
INSERT INTO yuw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yesuho ihoroc yuna owiho mata urago ingoroc iban imogoc, “Moröma goc boinno yaroc mahong managumbocho wömai nacno föro docno docno dou muya sapho abam girarema nongidang.” ");
INSERT INTO yuw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ihoroc yuna Yesuho inogoc, “Mayain goc mata urago ogepma sinom iban namparoc. Worocha goc ongga ahi, dogu boyömpho urop weya imun fahac.” ");
INSERT INTO yuw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ihoroc inuna owi wo böcnon ongmuna agocmai dogu boyömpho wenoi imun fauna onggoc. Tuna weno yu abamdec dungga idoc. ");
INSERT INTO yuw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Oro mit Yesu yu Tair sa guroc wo imun fauna Saidon taun woce onggoc. Tongo uyapno sakaun fiuna guroc mano ‘ten taun’ Galili yamuc öngkoringdec woce ongga idoc. ");
INSERT INTO yuw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Woce idina owi amna auho amna au yangada Yesuot tebung. Amna wo onggimo tongo o dugo ihorocgon mep tuna mata mepmogon yongidoc. Tuna nucniho ‘Yesuho oburo yudec out tohun’ yongo Yesu dönac inogung. ");
INSERT INTO yuw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Inuya Yesuho amna wo yangada obmukusuc aram oke ongmunya yu oburo karamutno yait yait amna worochon onggimodec soregoc. O ihorocgon irubo oburodec sunmuna amna worochon monbirodec taboc. ");
INSERT INTO yuw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ihoroc tongo daro onoce momdec foringmun uunto sum orongi wodingmuna amna ingoroc inogoc, “Efata”, Mata worochon foroi ‘onggimo dugo tumpun.’ ");
INSERT INTO yuw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ihoroc yuna wohogon amna woroc-hon onggimo tumboc. O monbiroho yungan tuna mata tuctugo yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tongo Yesuho owi amna wocin idungma ‘son fat ngo muyu yong fandat tongoninga’ ihoroc inogoc. Wohong muno woi, owi amna yu Yesu ‘muno’ inogocma wo makombii yuhon fatno moröma sinom yong fandat tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wömai yaha, Yesu yu youpno inobarac sinom tuna owi amna wo yangga toup borongdedungmaha fatno moröma yong fandat tonggung. Yu wömai yogung, “Yuhon youpno ambarac ogepmagon. Yu youp moröma sinom tongitacmai amna onggimo tongtongniho onggimo tumang. O dugo mepmoho dugo doun yungan tang,” ihoroc yong tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Oro bongono worochogon wönggon owi amna koböcmaho engsuran togung. Engsuran tongga ida nacno möp idung. Ihoroc idiya Yesuho yu yangmuna youp amnani inong yuna ehuya inogoc, ");
INSERT INTO yuw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Noc owi amna ngorocha uroc nampac. Yu nocot idiyagon sep anfi bödeuna yu nacnoha docmöang. ");
INSERT INTO yuw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Owi amna au yu sa korungonma ebung. Worocha yu nacnoha möp idiya nocho yu inongmuaya uyapdec ongmuya yangam urip urip tongga muningyit.” ");
INSERT INTO yuw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ihoroc yuna youp amnaniho inogung, “Sa ngo amnano munon! Non nacno koböcma nahema sinom fengmanaina owi amna torop ngo imonaya angit naup?” ");
INSERT INTO yuw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ihoroc inuya Yesuho youp amnani inong ac tongo yogoc, “Soniot nacno sowarango tingting idang?” Inuna yuho yogung, “Nacno sowarango 7 ihoroc itnimang.” ");
INSERT INTO yuw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yuya Yesuho owi amna inuna gurocdec omoc idung. Omoc idiya yu nacno sowarango 7 wo fogitmuna Kopotorocha ecec inongo uboto youp amnani imuna yu wo silip tongga owi amna imong tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","O ihorocgon söng obugu au idungma woroc Yesu imuya Yesuho fogitmuna Kopotoroc ecec inongo uboto youp amnani imuna yuho silip tongga owi amna imong tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tuna owi amna nacno wo nauya modibo foc togung. Nongbödeuya youp amnaniho nacno imuno idungma wo feng suran tongga dumbu 7 ihoroc oheuya foc togung. ");
INSERT INTO yuw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Oro amna nacno nagungma worochon nambano wömai 4,000 ihorocho nagung. Tuya mit Yesu yu inongmuna böcnon onggongon uyap forosigung. ");
INSERT INTO yuw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tuya Yesuot youp amnaniot yu girangdec bangmu uuya sa au mano Dalmanuta woce onggung. ");
INSERT INTO yuw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Oro, Farisi amna au yu Yesuot engmuya ‘yu boinno Kopotorochon youp tacha woha muno’ yongo tonguc imocimocha manomanoha inong ac togung. Tongo yu inogung, ‘goc toroc kiap au tia nonu gochon foro angtangtang tona,’ ihoroc inogung. ");
INSERT INTO yuw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tuya Yesuho yarunoha kombing mep tongga inogoc, “Owi amna torop ngo yu tingtinga tong weran au acacha yang yo? Nocho boinno sinom kantiwa, son momphon tong weran au maning, muno sinom.” ");
INSERT INTO yuw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ihoroc inongga amna torop wo dongyun fauya girangdec bangmun uunto yamuc öngkoring tero aramo öke woce onggoc. ");
INSERT INTO yuw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Oro youp amnani yu nacno sowarango etet imuya mafogi ebung. Nacno sowarango tunguhogon wömai idoc. ");
INSERT INTO yuw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tuna Yesuho garac mata ingoroc inogoc, “Son soni woho, son muyu Farisi amna orin Heröthon yisha yacyacho idarut.” ");
INSERT INTO yuw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ihoroc inuna youp amnaniho kombiu tuctuc mayuna inohogon inun ganun tongo yogung, “Non nacno sowarango mafeamonmaha mata ngoroc yachu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ihoroc yongga idiya Yesu yu woroc kombingga inogoc, “Mayain, sonthon irot soniu abe foc tongga idina son kombing tuctuc mating. Worocha son ‘nacno sowarango mafeamon’ yongo mata koböc koböc yongga idang. ");
INSERT INTO yuw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Son dansonibarac idang mahong yapmu au angtangtang matongidang. O son onggimsonibarac idang mahong matahon foro tuctugo makombingidang. ");
INSERT INTO yuw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kombiarut, nocho amna 5,000 ihoroc nacno sowarango 5 silip tong imoya sonu nacno nongdocno feng suran tongga dumbuno tingting sinom oheuya foc togung?” Ihoroc yuna youp amnaniho yogung, “Dumbu 12 ihoroc tong foc togomon.” ");
INSERT INTO yuw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yuya Yesuho inogoc, “O ihorocgon nocho amna 4,000 ihoroc nacno sowarango 7 silip tong imoya sonu nacno nongdocno feng suran tongga dumbuno tingting sinom oheuya foc togung?” Ihoroc yuna youp amnaniho yogung, “Dumbuno 7 ihoroc tong foc togomon.” ");
INSERT INTO yuw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yuna Yesuho inogoc, “Oro sonu kiap moröma wo agung mahong kombing tuctuc abe matinghu nuhun?” Ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Oro, Yesuot youp amnaniot yu Betsaida bucin engköuya böc morömpho amna au daro kom toctocyi yu Yesuot yangat tebung. Yangat tengga ‘Yesuho oburo amna worocdec wot muhun’ yongo dönac inogung. ");
INSERT INTO yuw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tuya Yesuho amna daro kom toctocyi wo yangauna böc tait imu fauna obmukusuc okoce ongmunya Yesuho irubo amnahon darodec sunto oburo yudec singga inogoc, “Goc yapmu au aharocha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ihoroc inuna amna wo daro foringmun tongga yogoc, “Nocu amna au yahat mahong ep simbang idiya yahat.” ");
INSERT INTO yuw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ihoroc yuna Yesuho wönggon oburo darodec out tohuna wohogon amna worochon daroho orokuna yu manomano yaun tuctuc yogung. ");
INSERT INTO yuw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tuna Yesuho amna wo inogoc, “Goc böcsa woce ongirocha. Muyu gaka bucin ongoi.” Ihoroc inongga amna wo inong muuna böcnon onggoc. ");
INSERT INTO yuw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Oro Yesuot youp amnaniot yu Sisaria Filipai worochon gurocin ongmuya böcsa danong woce itonggung. Yu uyapdec ongmuya Yesuho youp amnani inong ac tongga yogoc, “Owi amnaho nocha tingting yongidang, noc numa yo?” ");
INSERT INTO yuw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ihoroc inuna youp amnaniho inogung, “Auho wömai gocha yongidang, ‘gocu Jön yamuc gung imocimoc amna’. O auho wömai yongidang, ‘gocu Elaiya’. O auho wömai yongidang, ‘goc Kopotorochon yong tuctuc amna au yo.’” ");
INSERT INTO yuw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Youp amnaniho ihoroc inuya Yesuho yogoc, “O soniu nocha numa yo kombiang?” Ihoroc inuna Pitaho yogoc, “Gocu Duic, Kopotorocho ‘inoin owi amnani batip itnung’ yongo siuna ebocma woroc.” ");
INSERT INTO yuw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pitaho ihoroc yong tauna Yesuho youp amnani inogoc, “Son mata ngo owi amna au fandat inoninga” ihoroc inongga ‘muno sinom’ inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Oro mit Yesu yu forosingga youp amnani ingoroc inogoc, “Amnahon Manano yu muyu focfoc foro ihono ihono kombiangoc. Tuna Israel nanohon amna dugohu o öret socsoc böchon amna dugohu o nongoru gendic fandat fandat amnahu yu ambaracho me imongga wuya omengoc. Omong fauna sep bongono anfi idina yu wönggon omocdecma wekongga idongungoc. Kopotorocho yong torop ihoroc woroc yongo singdegoc.” ");
INSERT INTO yuw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu yu mata wo eran sinom youp amnani inogoc. Tuna Pita yu kombiuna angit maidina Yesu auna böc tero woce ongmunya Pitaho Yesu ‘ihoroc öngkuicha’ yongo inong fadoc. ");
INSERT INTO yuw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ihoroc tuna Yesuho youp amnani menon idungma yu foringmun onguna Pita inong fato yogoc, “Dogu kopot goc menan ongoi. Gocu Kopotorochon irot matararoc. Muno sinom, goc amnahon kombic kombicgon tararoc,” ihoroc inong fadoc. ");
INSERT INTO yuw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu ihoroc yongbödengga owi amna auot youp amnaniot yu inongyuna ehuya ingoroc inogoc, “Amna au yu noc nan nantha kombinggai yu muyu inoin ibibo youn fat bödengga ep goröcno sumbotmuna noc narun. ");
INSERT INTO yuw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Amna au yu inoin itonggongno guroc ngocin sogit akep toctocha tontacanu wömai yu itonggong koing tun muuna gorong ongontac. Wohong amna au yu guroc ngorochon itonggongno ‘nocha’ yongo imun faantacma yu wömai itonggong koing aun feangoc. ");
INSERT INTO yuw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Oro amna au yu gurochon möneng yoctec manomano ambarac fogida feng suran tunai wömai yapmu worocho tingtingno sinom tongfat yeuna magorong ongic? ");
INSERT INTO yuw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","O amna worocho yaö wöngnacno sinom tongga itonggong koing sogiangoc? Woroc wömai maec. ");
INSERT INTO yuw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Kombiarut, guroc ngorochon owi amna yu görani wontucmuno sinom. Amna auho nochahu o noc mata yogotmahu worocha yangam fap tuyai wömai mit Amnahon Manano wönggon ehangocan bongono wocin yu amna worocha ihorocgon yangam fap tongga me imangoc. Yu ehangocma wömai sum yaruni yangatmuna ino wömai Fanohon yaguno gesö mitimobarac ehuna epnahing.” ");
INSERT INTO yuw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu ihoroc yongga mata sakaun fiuna yogoc, “Nocho boinno sinom kanoya kombiarut. Amna au ngocin idangma yu abe mami idiya Kopotorochon toborucno ehuna yu worochon gesö anahing.” ");
INSERT INTO yuw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Oro, sep youp toctoc 6 ihoroc bödeuna Yesuho Pita, orin yan oröcma Jems orin Jön yu yangauna sa urongo au ubarago sinom woce ögung. Öngga yu inogon sinom idiya amna au maidung. Woce itmuya yu agungmai Yesuho mongurac tongo foro au sinom öngkuboc. ");
INSERT INTO yuw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tec tohomunmucnoho wömai sacsago föhöcno sinom föc narap öngkuboc. Guroc amnaho tec sac tuna sacsago ihoroc maöngkungitac. ");
INSERT INTO yuw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ihoroc tuna Elaiya orin Möse yu youp amnaniho yangamin öngkungmunya Yesuot mata inun ganun tongga idung. ");
INSERT INTO yuw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tuna Pitaho wo yangmuna Yesu inogoc, “Fandat fandat amna, nonu sa ngocin ogepma sinom idamonmaha böc anfi tona. Au wömai gochon o au Mösehon o au Elaiyahon ihoroc tona.” ");
INSERT INTO yuw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita yu wömai kiap foro au wo angmuna soroc yongga mata bumbumyi ihoroc yogoc. O Jems orin Jön yu ihorocgon soroc yongga botogomoroc. ");
INSERT INTO yuw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ihoroc idiya mom muruc muruc auho engmuna yu tombuna mom ganang inggun auho öngkungga yogoc, “Nochon Manana woi ngoroc. Nocho yuha toup kombihat. Sonu yuhon mata kombingga sumboditnung.” ");
INSERT INTO yuw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Inggun worocho ihoroc yongbödeuna wohogon yapmu wo öngkubocma bödeuna youp amnaniho Yesu yu tungugon agung. ");
INSERT INTO yuw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tongo yu saurongo wo imu fauna ohongmuya Yesuho youp amnani inogoc, “Son yapmu aingma worochon fatno amna au fandat inoninga. Amnahon Mananoho omocdecma wekongga idongungocan bongono wocin wömai son ogep fat wo eran yonaya owi amna ambarac kombinahing.” ");
INSERT INTO yuw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ihoroc inuna youp amnani yu mata wo amna au mainogung. Yu inohogon inun ganun tongga yogung, “Yesuho mata osuc yocma, ‘kumkumondecma wekongga idongungot yo,’ mata worochon foroi tingting?” ");
INSERT INTO yuw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ihoroc yongga Yesu inong ac tongga yogung, “Foro yaha nongoru gendic fandat fandat amnaho yongidang, Elaiyaho osuc epun.” ");
INSERT INTO yuw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ihoroc yuya Yesuho inogoc, “Mata ngo wömai yu boinno yongidang. Elaiya yu osuc engmuna manomano ambarac tobiuna arangarang yongga engoc. Wohong mata au wömai ingoroc irim toctocyi itac, ‘Amnahon Manano yu engmuna focfoc morö kombiangoc. Tuna guroc amnaho yu me imonahing,’ mata ihoroc itac. ");
INSERT INTO yuw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Worochoi oro nocho ingoroc kantiwa, Elaiya yu urop eboc mahong guroc amnaho inoin kombic kombicgon tanmuya yu toroc kiap wontucmuno wohon wohon tong imongidung. Kopotorochon bapiyadec wömai ‘kiap ihorocnoho yudec öngkuangoc’ yongo irim toctocyi itac,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Oro, Yesuot youp amnani anfiot yu saurongodec ida ohongmuya youp amnani au yau fedung. Yau feuya yagungmai owi amna torop moröma sinom youp amnani wo yang arenggumbec tongga itmuya nongoru gendic fandat fandat amna auho yuot mata fuic fohoic tong imongo idung. ");
INSERT INTO yuw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ihoroc tongga idiya Yesuho ambehecgon ehuna owi amna yu angga toup soroc yongga domdomgon yuot ebung. ");
INSERT INTO yuw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ehuya Yesuho yu inong ac tongo yogoc, “Son yaha yong osut morö tongga idang?” ");
INSERT INTO yuw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ihoroc yuna suraro bonipnodecma amna auho mata urago ingoroc imogoc, “Fandat fandat amna, nocho manana ngo yangat tepat. Dogu boyömpho au wömai manana ngo sogida dugo tun meptuna mata mayi iditac. ");
INSERT INTO yuw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","O ihorocgon dogu boyömpho mananahon irotnon ohongmuna yu körengmun möuna irupho dugodecma funfuro ohongitac. Tuna yu maro siun tomuna kudatnoho koing songidang. Oro nocho ‘youp amnayai dogu wo taruya ongoun’ yongo inogot mahong yu tu matogoc.” ");
INSERT INTO yuw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ihoroc yuna Yesuho mata wo kombingga yogoc, “Mayain, son owi amna torop bumbumyi, sonthon kombing tobic tobic soni maec. Nocu urop sa ubarago sonot itmaina önggöngyi soni sumboditat mahong sonthon kombing tobic tobic soni abe maitkamoc. Managumboc wo nocot yangat tebarut.” ");
INSERT INTO yuw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yesuho ihoroc yuna yu managumboc yangada yuot tebung. Yangat teuya dogu boyömpho Yesu angga mayain, yu managumboc korengmun gurocdec muuna fep mon tonguna kudat konoc konoc tongga dugo irupho funfunto dugodecma ohogoc. ");
INSERT INTO yuw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ihoroc tuna Yesuho woroc angga fano inong ac tongga yogoc, “Bongono tingnon sinom wo aun fedoc?” Ihoroc yuna fanoho yogoc, “Obuguingon ida forosingga tong teboc. ");
INSERT INTO yuw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Bongono koböcma wömai dogu boyömpho yu wot omom toctocha koreuna yamucdec ohoi ep moröc ohoi ihoroc tongitac. Worochai goc notha uroc gamuna ogep tongfat neimpha muno?” ");
INSERT INTO yuw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ihoroc yuna Yesuho inogoc, “Goc irot yai tirocha. Kombihi, amna au kombing tobic tobicnobarac entacanu wömai yu ogep manomano ambarac tun.” ");
INSERT INTO yuw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ihoroc yuna wohogon managumboc worochon fanoho yogoc, “Nocho boinno sinom kombing tobing gamoc gamocha kombihat mahong nocu angit matit. Worocha goc tongfat neia nocho irot yai tatma bödehun.” ");
INSERT INTO yuw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yu ihoroc yongga agocmai owi amna koböcmaho domdomgon engiya Yesuho dogu boyömo wo inong fato inogoc, “Goc dogu duc mataya muno o onggima tongo, goc managumboc ngo imi fauna ongga wönggon yuot ehirocha.” ");
INSERT INTO yuw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ihoroc inuna dogu worocho ecnang sinom yong yaingmuna managumboc wot wagang tongga köreuna omongmöc tuna imun fauna onggoc. Tuna wabkarac wo omomyi simbang idina owi amnaho yu angmuya auho yogung, “Urop omecmai.” ");
INSERT INTO yuw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ihoroc yuya Yesu yuhon oburo sogida tun fadauna idongga idoc. ");
INSERT INTO yuw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Oro mit Yesu yu bucin önguna yuot youp amnaniotgon idung. Tongo yu Yesu ingoroc inong ac togung, “Foro yaha sinom nonu dogu boyömo wo tantantha tana matoc?” ");
INSERT INTO yuw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ihoroc yuya Yesuho inogoc, “Dönachagon tongga dogu ihorocnoho amna imu faditac. Uyap au wömai maec,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Oro, Yesuot youp amnaniot yu sa wo imu fauna ongga Galili gurocin itonggung. Yesuho ‘owi amna komanangno yu sa nahenne itacno kombininga’ yongo yang usengga öpgon itonggung. ");
INSERT INTO yuw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Yu wömai youp amnanigon fandat inocinocha kombigoc. Tongga yu ingoroc inogoc, “Guroc amnaho wömai Amnahon Mananoha me imongmuya ayamihon oburodec tohong yunahing. Tohong yuya worocho wuya omuna sep anfi idina wönggon wekongga idongungoc.” ");
INSERT INTO yuw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yesuho youp amnani mata ihoroc fandat inogoc mahong yu mata wo kombing tangtang matogung. O yu Yesu inong ac toctocha botogung. ");
INSERT INTO yuw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tuna Yesuot youp amnaniot yu Kaperneam böcsadec ongkungga bucin ögung. Bucin itmuya Yesuho youp amnani inong ac tongga yogoc, “Non uyapdec itmanaina sonu yaö mata inun ganun ting oro?” ");
INSERT INTO yuw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ihoroc inuna youp amnani yu ‘numaho amna morö itac,’ yongo matahogon emoc tingmaha tongga yu yangam fap tongmuya mata au mayogung. ");
INSERT INTO yuw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tuya Yesu yu omoc ida youp amnani inong yuna ehuya ingoroc inogoc, “Amna au yu moröma iditha kombinggai wömai yu nucniho une itmuna yu mongorec tong impun.” ");
INSERT INTO yuw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yesuho mata ihoroc inongga managumboc obugu au sogida teuna youp amnani tan idoc. Woce idina Yesuho yu bac yengmuna yogoc, ");
INSERT INTO yuw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Amna auho nocha kombingga managumboc obugu ngorochon toroc yu tong ogep tong imontacma ‘yu tongimpat’ yongo nocha tong ogep tong namontac. O nocgon muno yu ihorocgon Nandöngna yu tong ogep tong imontac. Yu worocho noc nanong muuna ebot,” Yesu yu amna moröma idithon yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Oro, Jön yu Yesu ingoroc inogoc, “Fandat fandat amna, nonu amna au anaya yu gochon madec dogu boyöm dong yandoc. ");
INSERT INTO yuw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yu ihoroc tuna nonu yu ‘muno’ inogomon, yaha yui nonthon toropdec maecmaha.” Ihoroc yuna Yesuho mata urago ingoroc iban imogoc, “Muno, amna au yu nochon madec toroc kiap inobarac au tontacma yu wömai nocha yong moinmoin mayic. ");
INSERT INTO yuw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Amna au yu ayam matongnimicma yu woi nonthon oröc noni sinom. ");
INSERT INTO yuw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nocho boinno sinom kantiwa, amna auho son Duichon youp amnani idangmaha yamuc get kamontacma yu wömai mit worochon wöngnacno ogepma sogiangoc,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Oro, Yesuho wönggon mata sakaun fiuna yogoc, “Amna auho managumboc obugu noc kombing tobing namongidangma yu tonguc yeuna turongodec möantacma wömai amna worocho urago wontucmuno sinom aun feangoc. Sop moröma bangarodec banganmun muuna tongga top ganang tomun möantacma woi urago mepmo au mahong amna ihorocnoho urago aun feangocma wömai mepmo woroc anggirada koingo sinom engoc. ");
INSERT INTO yuw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Kombiarut, oburaho goc turongodec gangat tonguyai wömai gocho wo kondong tongo tomi ongoun. Ihoroc tongga gocho obura tunguhagon itongga itonggong koing ai feangoc. Gochuhun obura yait yait ito ep bohöng tomun muirocyit. Wocin wömai ep moroc mamic focfoc iditnoho iditno gamongo engoc. ");
INSERT INTO yuw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Sa wocinu focfoc wömai mabödec bödecno o ep wömai ihorocgon mamongitac. ");
INSERT INTO yuw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","O ihoroc-gon orungaho goc turongodec gangat tongunai wömai gocho wo kondong tongo tomi ongoun. Ihoroc tongga goc orunga tunguhogon itonggong koing ai feangoc. Gochuhun orunga yait yait ito ep bohöng tomun muirocyit. ");
INSERT INTO yuw_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Wocinu wömai focfoc moröma iditnoho iditno idina epmoroc mamongitac. ");
INSERT INTO yuw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","O ihorocgon daraho gangada turongo toctocha gangaunai wömai gocu dara tunguma ihorocgon fonunda tomi ongoun. Tongo dara tunguhogon wömai ogep idit koing ai feangoc mahong dara yait yait ito ep böhongnodec tomun muirocyit. Woce wömai epmoroc mamic. ");
INSERT INTO yuw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Sa wocinu wömai focfoc moröma sinom bödec bödecno muno engoc. Epmoroc woce iditnoho iditno edengoc. ");
INSERT INTO yuw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Oro, owi amna yu ‘öretno Kopotorocho yangamin sacsago itun’ yongo yipot fingidang. Worochon torocgon wömai Kopotorocho owi amna ambarac ‘oweng owengo idarut’ yongo ep aranggumot tong sac tong imongitac. ");
INSERT INTO yuw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Yip woi yapmu ogepmahong non angit mangtorenaya ibibono sum faunai wömai ting tonaya wönggon ibibo in? Worochon uyap wömai maec. Worochon torocgon sonu itonggong soni ogepma angtoreuya nuc soniho yangamin amna ogepma idarut. Tongo sonu irot tungu singmuya irot gucot itnahing,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Oro mit Yesu yu sa wo imun fauna ongga Yudia guroc Yodan yamuc ökenne woce onggoc. Tuna wönggon owi amna koböcmaho yuot engsuran tuya Yesuho inoin toroc kiapmo tanda owi amna fatmata ogepma fandat inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tuna Farisi amna auho eng-muya ‘Yesu tonguc imona’ yongo ingoroc inong ac togung, “Goc tingting kombiharoc, amna au yu oweno fodingmun ongontacanu wömai amna worocho nongoru gumarantacha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ihoroc yuya Yesuho inogoc, “Möse yu worocha yaö nongoru kamogoc?” ");
INSERT INTO yuw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iho-roc inuna Farisiho yogung, “Möse yu ‘öc’ yogoc, amna au yu ogep oimna ficfuc toctochon bapiya irim tongo oweno imongga yu fodingmun ongontac.” ");
INSERT INTO yuw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ihoroc yuya Yesuho inogoc, “Sonthon irot soni koingo, son nuc soniha uroci makombingidang. Worocha tongga Möseho son kang banango oimna ficfuc toctochon nongoru wo kamogoc. ");
INSERT INTO yuw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wohong osuc forosicsicnodec wömai oimna ficfuc maidoc. Muno, Kopotoroc yu amnaot owiot yait yait doun öngkubomoroc. ");
INSERT INTO yuw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tuna amna auho macno fano imun fauna oweno ot idina ");
INSERT INTO yuw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","yaimaho irot tungu godip tungu siantamoroc. Yui osuc yai idomoroc mahong mit yu oimna tungugon entamoroc. Kopotorocho ‘ihoroc idarun’ yongo owi amna tobigoc. ");
INSERT INTO yuw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Worocha Kopotorocho oimna iditha yongo sigocma wömai amnaho gumanitninga.” ");
INSERT INTO yuw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Oro Yesu yu mata ihoroc yun bödeuna bucin öngga idina youp amnaniho yu wönggon oimnaha inong ac tuya Yesuho mata urago ingoroc iban imogoc, ");
INSERT INTO yuw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","“Amna auho oweno fodingmun onguna owi au tongsiantacma yu wömai owi göra tontac. ");
INSERT INTO yuw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","O ihorocgon owi auho opno imun fauna amna au tongsiantacma yu wömai amna göra tontac.” Yesuho oimna ficfuc toctochon matano ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Oro mit owi amna yu managumbocni yangada ‘Yesuho oburo yudec out tohoun’ yongo yuot febung mahong Yesuhon youp amnaniho yu yangga inong fadung. ");
INSERT INTO yuw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Inong fauya Yesuho woroc kombingga irotno öbukuna inogoc, “Son managumboc nocot ebepha bongbong sing imoninga. Muno, yu muyu nocot ebarut. Kopotorocho wömai mom toboruc owi amna managumboc simbang ima yuha bogigoc. ");
INSERT INTO yuw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nocho boinno sinom kantiwa amna au yu Kopotorochon toboruc managumboc simbang masogiicanu wömai yu woce mangic.” ");
INSERT INTO yuw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yesuho ihoroc yongga managumboc ebungma yu bac yengga oburoho bigodec out fohongga guram fing imogoc. ");
INSERT INTO yuw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Oro, Yesu yu wönggon uyap forosingga ongga idina amna au yu domdomgon engmuna Yesuhon orungo forodec goruc yemoc tongga ingoroc inong ac togoc, “Fandat fandat amna ogepma, noc ting tongga itonggong koinghon fat em?” ");
INSERT INTO yuw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ihoroc yuna Yesuho inogoc, “Gocu yaha noc amna ogepma ihoroc nantaroc? Non owi amna ambarac ogepma muno, Kopotoroc yu tunguhogon woi ogepma. ");
INSERT INTO yuw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Worocha gocu yuhon nongoru mata ngo sumbotmina worochon torocgon itongidiruc: Goc nucai dohirocha, goc oimna gumarirocha, goc usem tirocha, goc mata youpdec amna auha mata imanang firing tarirocha, goc mata gemdat yirocha, goc macai nandöngai yang gendingidiruc.” ");
INSERT INTO yuw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yesuho ihoroc inuna, amna worocho yogoc, “Fandat fandat amna, nocu abe obugu ida forosingga nongoru mata wo ambarac tanmaina engga önga itat.” ");
INSERT INTO yuw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ihoroc yuna Yesu yu foring angga yuha toup kombingmuna inogoc, “Goc abe yapmu tunguhagon wömai docmöharoc. Goc ongmina yoctec manomanoya ambarac imun gamunthon uyapdec fingga möneng fogida owi amna urociha silip tong imiruc. Goc ihoroc tontarocanu wömai momphon itonggong ogepma gochon fat entac. Oro mit wömai engga noc nari.” ");
INSERT INTO yuw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yesuho mata ihoroc inuna amna worocho kombingga irotno toup mep togoc. Wömai yaha yu yoctecno koböcma idimogungmaha togoc. Tongga yu Yesu imun fauna onggoc. ");
INSERT INTO yuw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Onguna Yesuho youp amnani foring yangga ingoroc inogoc, “Amna möneng yoctecno koböcma yu wömai mom midim sabarac sadec onggonga mep tongidang.” ");
INSERT INTO yuw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yesuho ihoroc yuna youp amnaniho mata wo kombingga soroc yogung. Soroc yuya Yesuho mata sakaun fiuna inogoc, “Mananai, owi amna yoctecno koböcma yu Kopotorochon midim sabarac sadec onggonga toup mep tongidang. ");
INSERT INTO yuw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bot kamele yu somayang ganang onggongno woi maec. O worochon torocgon wömai amna yoctecno koböc idimangma yu Kopotorochon midim sabarac sadec onggonga tu matangoc.” ");
INSERT INTO yuw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesuho ihoroc yuna youp amnaniho wönggon toup soroc yongga inohogon inun ganun tongga yogung, “Mayain, ihorocanu wömai amna tungu au itonggong koing maun feic.” ");
INSERT INTO yuw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ihoroc yuya Yesuho yu foring yangmuna inogoc, “Boinno, amnaho ihoroc matoctocnohong Kopotoroc yu ogep manomano ambarac tun boinno öngkuangoc.” ");
INSERT INTO yuw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yesu ihoroc yuna Pitaho yu inogoc, “Kombiharoc, nonu ‘goc ganna’ yongo manomano noni ambarac dongyana fadung.” ");
INSERT INTO yuw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ihoroc yuna Yesuho inogoc, “Nocho boinno sinom kantiwa, amna au yu ‘nocha’ yongo böcnohu o owi wabkaracnihu o niporugihu o macni fanihu woroc dongyun fauya fatmata ogepmahon youp tontacma ");
INSERT INTO yuw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","yuha wömai Kopotorocho manomano dongyun fadungma worochon urago bongo 100 ihoroc urop guroc ngocin urago iban imontac. Woi böcnohu o niporugihu o macnohu o managumbochu o sa gurochu woroc uragoha iban imangoc mahong ‘nocha’ tongga wömai fatmata ogepmahon ayamiho yu tu obukuna focfoc imongitnahing. Wohong mit bongono morömadec wömai yu itonggong koing aun feangoc. ");
INSERT INTO yuw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kombiarut, amna koböcmaho önga osuc ididangma, yu wömai mit madango itnahing. O amna koböcmaho önga madango ididangma yu mit osuc itnahing,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Oro, Yesu yu ‘Yerusalem ongona’ yongo youp amnani yangada fonggoc. Tuna youp amnani yu ‘tingting sinom nonidec öngkuangoc’ yongo kombingbanac tongmuya Yesu tan tonggung. O owi amna au yu ihorocgon botongmuya yu yan fonggung. Yan fongga uyapdec ongmuya Yesuho youp amnani 12 yugon feng suran tongga mit yaö sinom yudec öngkuangocma worochon yong tuctuc matano ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Kombiarut, non urop Yerusalem taun öantamon. Öngga woce wömai ayampho Amnahon Manano sogida öret socsochon amna moröma orin nongoru gendic fandat fandat amna dugo yuhon oburodec sinahing. Tuya yuho ‘wuya ompun’ yongo matano yu bödeuna bumbuyi nanohon oburodec sinahing. ");
INSERT INTO yuw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tuya amna torop worocho wömai kömec toctocha yu inong saha tongmuya irubo yudec sunda tosipdec woda wuya omengoc. Oro yu omongga idina sep youp toctoc anfinodec wönggon wekongga idongungoc,” Yesu yu ino omomphon yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Oro, Sebedihon mananin yai Jems orin Jön, yu Yesuot engmunya ingoroc inogomoroc, “Fandat fandat amna, ‘goc muyu yapmu au nonthon irothon toroc tanto nimiruc’ yongo ebamot.” ");
INSERT INTO yuw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ihoroc yunya Yesuho inogoc, “Oro yarun, nocho ting tong kampiwa’ yongo yamoroc?” ");
INSERT INTO yuw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ihoroc yuna yaimaho yogomoroc, “Mit gocho idit yaguno koingon sa engorocan bongono wocin wömai gocho kombing nimia auma aroce o auma kandoce ihoroc idta’ yongo kombiamot.” ");
INSERT INTO yuw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ihoroc yunya Yesuho inogoc, “Sot yapmu ngo nanamorocma worochon foro tuctugo makombimoroc. Sodu ogep focfoc moröma nocdec öngkuangocma woroc sumbotahamorocha woha muno? O sodu ogep itonggong soti nocho tangotma worochon toroc imun faangocha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yuna yaimaho inogomoroc, “Öc, not ogep.” Ihoroc yunya Yesuho inogoc, “Boinno sinom, focfoc youp nocho sumbengotma wo wömai sodi ihorocgon sumbotahamoroc. O nocho itonggongna ima faangocma worochon toroc sodu ihoroc itonggong sodu imun faangoc. ");
INSERT INTO yuw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wohong numaho sinom wömai nochon obu arocne kandocne engocma woi nocho angit mayit. Muno, Nandöngna yu urop amna wo erangga abam yuha yongo tong arangarang tongo sigoc.” ");
INSERT INTO yuw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Oro youp amna nucni 10 yu yan oröcmaho mata Yesu inogo-morocma woroc kombiuya angit maina irotno fadang ögung. ");
INSERT INTO yuw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Worocha tongga Yesuho youp amnani inong yuna ehuya mata ingoroc inogoc, “Son bumbumyi nanohon Kingnohu o amna dugohu yuhon toroc kiapmo urop kombiang. Yu wömai inoin manogon töngga suraro koingo sinom yangtorengidang. ");
INSERT INTO yuw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Oro, toroc kiap ihorocnoho wömai sonthon bonip sonidec icha. Muno sinom, amna au yu ‘amna moröma itiwa’ yongo kombiantacma yu muyu surarohon mongorec toctoc amna itun. ");
INSERT INTO yuw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","O amna au yu dugo soni iditha kombiantacma yu muyu youp wabkarac soni itun. ");
INSERT INTO yuw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kombiarut, Amnahon Manano yu ‘amnaho mongorec youp tong namarut’ yongo maeboc. Muno, yu wömai guroc owi amna tongfat yecyecha eboc. Tongo yu inoin itonggongno imun fauna owi amna koböcma dogu kopothon oburodec wuuna itonggong koing sogitnahing,” Yesu yu amna moröma idithon toroc kiapha ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Oro mit Yesuot youp amnaniot yu ongga Yerikö taun wocin ongkungga idung. Tongo yu taun wo imu fauna owi amna koböcmaho yu yan fongidiya amna uroci au daro kom toctocyi yu uyap tan omoc itmuna ‘owi amnaho yapmu auha tongfat nearut’ yongo owi amna dönac inongo idoc. Yuhon mano Bartimeus, yu woi Timeushon manano. ");
INSERT INTO yuw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yu woce ida kombigoc, Yesu Nasaretma yu uyap ngorochon epac. Wo kombingga wohogon forosingga ecnang mamboda yogoc, “Yesu, Devithon Morogo, gocu nocha uroc gampun,” ihoroc yongo idina ");
INSERT INTO yuw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","owi amnaho ‘öpgon iti’ yongo inong fadung mahong yu muyu kiringga ecnang mamboto yogoc, “Devithon Morogo, gocu nocha uroci kombihi.” ");
INSERT INTO yuw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ihoroc yuna Yesuho woroc kombingga onggom songga yogoc, “Amna wo nocot epun.” Ihoroc yuna owi amnaho Bartimeus inogung, “Iroda sum fauna idongoi, Yesuho gocha yac.” ");
INSERT INTO yuw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ihoroc inuya yu idongga sum tecno tomun onguna Yesuot onguna Yesuho inogoc, ");
INSERT INTO yuw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“Nocho ‘ting tong gampiwa’ yongo yaroc?” Ihoroc yuna yu inogoc, “Fandat fandat amna, ‘gocho danna ti dogihun’ yongo kombihat.” ");
INSERT INTO yuw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ihoroc yuna Yesuho inogoc, “Ongoi, kombing tobic tobicaho goc tun orokotaroc.” Ihoroc inuna wohogon daro orokuna foringga Yesu tan tonggoc. ");
INSERT INTO yuw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Oro, Yesuot youp amnaniot yu Yerusalem taun ambehecgon öngkungga böcsa au mano Betfage orin Betani woce idung. Böcsa wo wömai Oliv sa urongodec idoc. Tuna Yesuho youp amnanin yai ingoroc inongga inong mudoc, ");
INSERT INTO yuw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Sodu böcsa wocin ongorun. Woce ongga bot donki macno orin gumbogo kaningyuuya idinya yaantamoroc. Bot donki woroc koroc wömai amna auho abe maitonggung. Sot woroc asanda nocot yangat febarun. ");
INSERT INTO yuw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Oro amna auho ‘sot ngo yaha asan imamoroc’ kanunai wömai sodu ingoroc inarun, ‘Morömaho youpno imocimocha yac. Youp bödeuna wömai yu donki siuna karupgon wönggon ehangoc.’” Yesuho amna yai ihoroc inuna onggomoroc. ");
INSERT INTO yuw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ongga agomorocmai böc auho simbudec bot donki beracno yu wocin kaning yuuya idina yaimaho woroc asan imogomoroc. ");
INSERT INTO yuw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Asan imunya böc moröm au ambehecgon idungma yu wo yangga inogung, “Sot bot donki ngo yaha asan imamoroc?” ");
INSERT INTO yuw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ihoroc inuya yaimaho ‘Yesu ihoroc yarun’ yongo inogocma worochon toroc mata urago imunya owi amnaho yu kombing imuya ");
INSERT INTO yuw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","bot donki yangada Yesuot tebomoroc. Tengga sum tecno fuun deunya bot donki koroc fiuya Yesuho woroc koroc öngga idoc. ");
INSERT INTO yuw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tuna owi amna koböcho yu ihorocgon tecnohu borunohu fuu deuya uyapdec yonyu fat tonggung. O owi amna au yu gosongon ongga ep betomo ubotmuya uyapdec fing tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ihoroc tongga owi amna osucit mitit tuya Yesu yu bonipnodec ong tongga idina owi amna ambaracho mamboda ap inogoroc yogung: “Kopotoroc yong moröng imona!” “Morömahon madec epacma yudec wömai Kopotorochon guram itac.” ");
INSERT INTO yuw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“O ombu sakung noni Devit yuhon midim sabarac saho urop ehantac. Worocha tongga non borongdetna!” “Kopotoroc onoce itacma yuha yong kumena.” ");
INSERT INTO yuw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Oro owi amnaho ihoroc yong kumeng tongmuya ongga Yerusalem ongkubung. Tuya Yesu yu öret socsoc bucin öngmuna manomano woce idungma woroc yangsic togoc mahong sep daro urop ibandocmaha tongga yu ibarun fauna youp amnani 12 yangauna Betani bucin onggung. ");
INSERT INTO yuw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Oro, kembotsum yu Betani böcsa imu fauna wönggon Yerusalem taundec onggonga tongga uyap bonip itmuya Yesu worec imo-gung. ");
INSERT INTO yuw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Worec imuya uyap tero wocin ep fik au idina angga ‘boinno baringga nawa’ yongo forodec öngo agocmai boinno ficfichon bongono maidocmaha ep wo boinno mafi komong biruc tongga idoc. ");
INSERT INTO yuw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yaun matuya yu ep fik wo möpmo ingoroc inogoc, “Amna auho gochon boinno wönggon mananing,” ihoroc inuna youp amnaniho mata woroc kombigung. ");
INSERT INTO yuw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Oro mit Yesu yu ongga Yerusalem ongkungga öret socsoc bucin öngmuna forosingga amna wocin bisnis youp tongga idungma yu dong yandoc. Dong yanda amna möneng mongurac tongidungma worochon möneng abamo körengyun möngbödegung. O amna öret socsochon ecec yup kanaröm figungma yuhon abamo ihorocgon korengyun mögung. ");
INSERT INTO yuw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tongo yu amna wöcwöchon manomano fongi fepi togungma yu ‘muno’ inogoc, “Son öret socsoc böchon gomboin ihoroc toninga!” ");
INSERT INTO yuw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ihoroc inongga owi amnadec yong fandat inongga yogoc, “Kopotorochon bapiyadec mata ingoroc irim toctocyi itac: ‘Kopotorochon böc woi suraro ambarachon dönac yocyoc böc itun.’ Mata ihoroc irim toctocyi itac mahong sontho tuya kunkun böc ngorocho usem amnaho yoctecno öp ficfic böc simbang öngkungbödehac.” ");
INSERT INTO yuw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Oro Yesuho mata orongi ihoroc yuna öret socsoc böchon amna dugo orin nongoru gendic fandat fandat amna yu mata woroc kombingga forosingga Yesu wot omom toctochon uyapha yong yabigung. Wömai yaha suraro ambaracho Yesuhon mataha toup kombingga borongdedidungmaha tongga amna dugohon ma ohogoc. Worocha tongga amna dugoho Yesuha botongga yu wot omom toctochon yong torop sigung. ");
INSERT INTO yuw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Oro dobocsisia Yesuot youp amnaniot Yerusalem imu fauna onggung. ");
INSERT INTO yuw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Oro, sa isuna yu uyapdec ongga itmuya agungmai ep fik Yesuho möpmo wagang imogocma worocho dinengga oruc öngbödengga idoc. ");
INSERT INTO yuw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ihoroc tuna angga Pitaho Yesu inogoc, “Fandat fandat amna ahi, ep möpmo inorocma ngorocho urop onggom sac.” Ihoroc yuna Yesuho mata urago ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","“Son kombing tobic tobic soni Kopotoroc yudecgon siarut. ");
INSERT INTO yuw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nocho boinno sinom kantiwa, amna au yu irot yaiot muno kombing tobic tobicnobarac sa urongo ngo inontac, ‘Goc ongga topdec mondihi!’ ihoroc inongga ‘matana koing soun’ yongo kombing tobiunai wömai woroc, Kopotorocho yuhon dönacnohon toroc tun öngkung imangoc. ");
INSERT INTO yuw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kombiarut, son yaö manomano sogit sogitha kombingmuya dönac soni irot yaino muno kombing tobic tobicbarac yontanganu wömai sonu worochon torocgon sogitnahing. ");
INSERT INTO yuw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Oro, son dönac yocyocha kombinggahai son muyu oröc sonihon turongo dongyu fat imongitnung. Ihoroc tuya Nandöng soni momdec itacma yu sonthon turongo soni ihorocgon dongyun fat kamontac. ");
INSERT INTO yuw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Oro son oröc sonihon turongono madongyu fatninganu wömai Nandöng soni momdec itacma yu ihorocgon turongo soni madongyun fat kamoning.” Yesu yu dönac yocyochon yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Oro Yesuot youp amnaniot yu wönggon Yerusalem engmuya Yesuho öret socsoc gomboin itongga idina öret socsochon amna dugo orin nongoru gendic fandat fandat amna orin surarohon amna dugo yu ambarac Yesuot engmuya ingoroc inong ac togung, ");
INSERT INTO yuw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Numaho ‘youp woroc toi’ yongo ganung muna eboroc? O youp toctochon gesö numaho gamuna tongitaroc?” ");
INSERT INTO yuw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ihoroc inuya Yesuho yogoc, “Nocu ihorocgon yapmu auha kanong ac towa. Sontho mata iban namuyai wömai nocho ihorocgon numahon gesö sogitmaina youpna tongitatno wo kanontat. ");
INSERT INTO yuw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nanarut, Jöntho owi amna yamuc gung imongidocma wo woi momphon manomanoha woha yu amnahon kombic kombicgon sindanda togoc?” ");
INSERT INTO yuw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ihoroc inuna amna moröma inohogon mata inun ganun tongga yogung, “Oro nontho yonaya woi momphon manomano wömai yu ninontac, sonu yaha yu makombing tobing imogung yo? ");
INSERT INTO yuw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Worochoi oro non yonaya woi amnahon kombic kombicgon, wömai suraroho non ayam tong nimontang, yaha owi amna ambaracho Jöntha kombingidang, yui Kopotorochon yong tuctuc amna sinom itacmaha.” ");
INSERT INTO yuw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Amna morömaho ihoroc inun ganun tongo tu matuna Yesu mata ingoroc iban imogung, “Non makombimon.” Ihoroc yuya Yesuho yogoc, “Oro son mananingmaha nocho ihorocgon noc numahon ma sogitmaina youpna tongitatno wo makanit,” Yesu yu ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Oro Yesu yu Yuda nanohon amna morömaha mata tepmo au ingoroc yogoc, “Amna moröma au yu wain ön mögoc. Möngga ön gombo temongmun uuna o wain koburo dontot dondothon abamo tobingga o youp wabkarachon ön angtorec torechon böc ubarago au togoc. Ihoroc tongo yu ‘amna torop auho nakain ön ngo angtorearut’ yongo wain ön wo amna torop au imongo sa korungon woce onggoc. ");
INSERT INTO yuw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Sa korungon idina wain koburo urop gomon diuna amna morömaho yogoc, ‘nocho youp wabkarac au inong muaya yu ongga öndec wain koburo nochon fat ficficyi idangma woroc yongga feangoc,’ ihoroc yongo togoc. ");
INSERT INTO yuw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Worochoi muno, wain ön angtorec amna yu youp wabkarac wo ayam tong imongo woto taruya komong ibarun fauna onggoc. ");
INSERT INTO yuw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Tuna amna morömaho wönggon youp wabkaracno au inong muuna onggoc mahong wain ön angtorec torec amnaho yu bigodec woda toroc kiap yangam fapfapni tong imuya yu komong ibarun fauna onggoc. ");
INSERT INTO yuw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tuna amna morömaho wönggon youp wabkarac au inong muuna onggoc mahong wain angtorec torec amnaho yu wuya omboc. Ihoroc tuya amna morömaho wönggon youp wabkarac torop au koböcma inong muuna onggung mahong ön angtorec torec amna yu aumai dobung o aumai douya ombung. ");
INSERT INTO yuw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ihoroc tuya amna morömahon manano batip sinom yu tunguhogon idoc. Tuna amna morömaho kombigoc, ‘nocho yu inong muaya ongoun. Ihoroc toya wain ön angtorec torec amna yu manana anggendinahing.’ Amna morömaho ihoroc yongo manano inong mudoc. ");
INSERT INTO yuw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wohong ön angtorec torec amna yu woroc angga yogung, “Amna ngorocho wömai mit fanohon guroc öresac ambarac inohagon fogitdup tangoc. Worocha non amna ngo wot omom tontamonanu wömai ön manomano ngo ambarac nonthon fat engoc.’ ");
INSERT INTO yuw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ihoroc kombingbödengga manano wo sogida wuya omuna ön gombo sumon tomu onggoc.” ");
INSERT INTO yuw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Oro Yesuho mata tepmo ihoroc yun bödeuna mit amna moröma inogoc, “Sonu ting kombiang? Ön morömo yu engmuna amna wontucmuno urago tingting sinom tong imangoc? Yu wömai engmuna wain ön angtorec torec amna wontucmuno wo dong omom tongo wain ön amna torop au imangoc. ");
INSERT INTO yuw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kombiarut, Kopotorochon bapiyadec wömai worochon yong tuctuc matano urop irim toctocyi itac, sonu wo makombinghu nuhun? Mata ingoroc irim toctocyi itac: ‘Sop auha wömai böc toctoc amnaho ‘sop wontucmuno’ yongo tomu onggoc mahong önga wömai Kopotorocho sop worocgon sogitmuna tong koing tong imuna sop worocho böchon forodongno sinom itac. ");
INSERT INTO yuw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Morömaho kiapmo ihoroc tuna non wo anaya ogepma sinom itac.’” ");
INSERT INTO yuw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Oro Yesuho mata ihoroc yun bödeuna amna dugoho kombigung, ‘mata ngo yacma wömai nontha kombingo yac yo’. Ihoroc kombingga irotnoho obökuna yu Yesu wot omom toctocha uyapha dabigung mahong yu suraroha botogungmaha uyap au abe makombiu öngkuboc. Tongo yu Yesu imu fauna onggung. ");
INSERT INTO yuw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Oro Irael nanohon amna dugo yu kombigung, ‘Yesuho mata wontucmuno au yunai wömai nontho yu gavmanthon oburodec tohong yunaya wuya ompun.’ Ihoroc kombingga yu Farisi amna au orin amna au Heröthon toropdecma yu inongmuya ");
INSERT INTO yuw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yesuot ongmuya tonguc yecyecha mata ingoroc inogung, “Fandat fandat amna nonu kombiamon, gocu yapmu auha kombiiya ogep idinai wömai gocu worochon torocgon tongitaroc. O gocu amna auha mabotongitaroc. Muno, goc mata tungu gocho kombiiya angit idina worocgon wömai amna morömahu o amna komanangnohu yu ambarac inongitaroc. O gocu Kopotorochon toroc kiapmo boinno worocgon fandat ninongitaroc. Worocha goc nanti, nontho Sisa king yu takis möneng ogep imontamontha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ihoroc yuya Yesu yu inong yucyuchon matanohon foro kombing-dengga inogoc, “Son foro yaha noc tonguc neang. Son takis möneng docno au nindauya awa.” ");
INSERT INTO yuw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ihoroc inuna yu möneng docno au imuya Yesuho wo angga inong ac tongo yogoc, “Möneng ngodec numahon doguno sicsicyi itac?” Ihoroc inuna yuho yogung, “Woi Sisa king yuhon.” ");
INSERT INTO yuw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yuya Yesuho inogoc, “Oro worocha sonu Sisahon fat wömai Sisaha imarut. Wohong Kopotorochon fat wömai Kopotorocha imarut.” Yesu ihoroc yuna yu mata woroc kombingmuya nangano fauna kombic kombic youp morö togung. ");
INSERT INTO yuw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Oro mit Sadyusi amna auho Yesuot ebung. Amna torop Sadyusi yu wömai kombingidung, amna omomyi yu wönggon mawekoning. Oro yu Yesuot engmuya ingoroc inong ac togung, ");
INSERT INTO yuw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Fandat fandat amna, osuc wömai Möseho ingoroc ninogoc, ‘Amna au yu managumbocno muno ida omunai wömai orugoho ‘oröcnahon morögo ta öngkupun’ yongo worochon oweno tong sihun. ");
INSERT INTO yuw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oro yomot oröc 7 ihoroc idung. Tongo orugo borongoma yu owi au tong singga managumbocno muno ito omong fadoc. ");
INSERT INTO yuw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tuna orugo mitmaho owi worocgon tong sigoc. Tongo yu ihorocgon managumbocno muno ito omong fadoc. Tuna orugo auma yu ihorocgon togoc. ");
INSERT INTO yuw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ihorocgon tong tongga idiya orugo madango yuho owi wo tong singga omboc. Tuna mit wömai owi ihorocgon omong fadoc. ");
INSERT INTO yuw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Oro worocha goc tingting kombiharoc? Yomot oröc 7 yu ambarac owi wo tong sigungmai. Worocha mit bongono morödec omimaho idongonahingan bongono wocin wömai owi wo numahon oweno sinom engoc?” ");
INSERT INTO yuw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ihoroc inuya Yesuho mata urago ingoroc iban imogoc, “Son Kopotorochon bapiyadec mata idangma orin Kopotorochon gesö moröma wo makombingmaha tongga kombic kombic soni kandoc ongbödegoc. ");
INSERT INTO yuw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Owi amnaho omocdecma idongonahingan bongono wocin wömai yu owe op wönggon matoning. Muno, yu wömai momphon sum yaru simbang itnahing. ");
INSERT INTO yuw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Oro omomyiho wönggon idongonahingmahon yong tuctucno wömai nocho ingoroc kantiwa, Mösehon bapiyadec wömai ep aranggumpho ohuna ep songmun digocma worochon fatno itac. Tuna wocin wömai Kopotorocho Möse ingoroc inogoc: ‘Nocu Abraham orin Aisak orin Jeköp yuhon Kopotoroc.’ ");
INSERT INTO yuw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ihoroc inuna nonu ingoroc kombina, Kopotoroc yu omimahon Kopotoroc muno, yu wecima yuhon Kopotoroc. Sonthon mata soni woi kandoc sinom,” Yesu yu Sadyusi ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Oro nongoru gendic fandat fandat amna tungu yu engmuna kombigocmai Yesuho Sadyusiot mata inun ganun tongga mata urago orongi sinom imogoc. Worocha tongga yu ihorocgon Yesu inong ac tongga inogoc, “Möseho nongoru nimogocma worocdecma yaö nongoruho moröma sinom itac?” ");
INSERT INTO yuw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ihoroc inuna Yesuho yogoc, “Nongoru ngo woi moröma sinom: ‘Son Israel nano son kombiarut! Moröma noni Kopotoroc yu tunguhogon woi Moröma noni. ");
INSERT INTO yuw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","‘Son irot soni Kopotorocha boging imarut, yu woi Moröma noni. Son irot sonihu o yaru sonihu o kombic kombic sonihu wo ambarac yuha tong fup imarut.’ ");
INSERT INTO yuw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Oro, nongoru worochon nucno woi ingoroc: ‘Goc gakaha kombingitarocma worochon torocgon nucaha kombingidiruc.’ “Nongoru auho wömai nongoru mata yai ngo mayanggirahac, muno, yaima ngoi moröma sinom.” ");
INSERT INTO yuw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ihoroc yuna nongoru gendic fandat fandat amnaho inogoc, “Goc boinno sinom yaroc, Kopotoroc yu tunguhogon wömai Moröma itac, yu simbang au maec. ");
INSERT INTO yuw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Worocha nonu muyu irot nonihu o kombic kombic nonihu o gesö noni wo ambarac yuhagon tong fup tong imonahamon. O non muyu nuc noniha toup kombingitnahamon. Kiap ihorocnoho wömai öret socsoc kiap anggirahac.” ");
INSERT INTO yuw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Oro amna wo ihoroc yuna Yesuho matano kombiuna ogepma sinom idina yu inogoc, “Boinno sinom goc urop Kopotorochon toborucnohon foro obmukusuc kombiharoc.” Yesu ihoroc yongbödeuna mit owi amna ambaracho Yesu inong ac toctocha botongga mata au mainogung. ");
INSERT INTO yuw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Oro Yesu yu öret socsoc bucin owi amna fandat inongmuna ihoroc inogoc, “Foro tingtinga wömai nongoru gendic fandat fandat amnaho Duicha yongidang, yu woi Devithon manano. ");
INSERT INTO yuw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Devit inobut wömai Kunkun Yaruhon gesödec yong tuctuc ingoroc yogoc: ‘Kopotoroc yu nochon Morömana inogoc, Goc nochon arocne omoc idiya ongga nocho gochon ayamaihon gesöno fohongga gochon unenne fohong yuangot.’ ");
INSERT INTO yuw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Oro, Devit inoho wömai Duicha ‘Morömana’ ihoroc yogoc. Worocha wömai Duic yu tingtinga Devithon manano in?” Yesuho ihoroc yuna suraroho yuhon mataha ibip imuna toup kombigung. ");
INSERT INTO yuw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Oro, Yesuho owi amna fandat inongga ingoroc yogoc, “Sonu nongoru gendic fandat fandat amnaha yacyacho itongitnung. Yu wömai inoha kombingidang ‘non amna moröma sinom idamon yo’ worocha tongga yu tec tohomumöcno ubarago fohongyu muya ‘owi amnaho niarut’ yongo uyap itonggonga toup kombingidang. O ihorocgon yu ‘owi amnaho maket taitdec sep ogep amna moröma ninarut’ yongo toup kombingidang. ");
INSERT INTO yuw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","O fatmata yocyoc bucinthu o tong sonoc bongonodechu wömai yu amna morömahon abam ogepmagon woce iditha toup kombingidang. ");
INSERT INTO yuw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","O ihorocgon yui owi kapi imanang inong yucyuc tongo böcno yoctecno manomano inoha usem fogididang. O yu ‘owi amnaho niarut’ yongo dönac ubarago yongidang. Boinno sinom, amna ihorocnoha wömai Kopotorocho urago wontucmuno sinom imangoc,” Yesu yu Farisihon garac mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Oro, Yesu yu ecec möneng ficfic waga ambehecgon omoc ida yauna owi amnaho öret socsoc böchon ecec möneng wagadec fingidung. Amna möneng yoctecno koböcma yu wömai möneng koböc fing tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ihoroc tuya owi kapi uroci sinom yu ihorocgon engmuna möneng docno gomono yai wagadec tomun mögoc. Woi 1 toea worochon torocgon tomun mögoc. ");
INSERT INTO yuw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ihoroc tuna angga Yesuho youp amnani inong yuna ehuya inogoc, “Nocho boinno sinom kantiwa, owi uroci wo yu möneng sihacma woi yapmu moröma sinom. Worocho wömai owi amna auhon ececno yanggiratbödehac. ");
INSERT INTO yuw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Owi amna au yu möneng koböcma idimang mahong yu worochon docno obmugon fingidang. Wohong owi ngo yu tong urocdec itac mahong yu inoin nacno wöcwöchon mönengno ambarac sogida Kopotorochon ececha singbödec,” Yesuho ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu yu öret socsoc böchon gombo imun fauna ongidina youp amna auho inogoc, “Fandat fandat amna ahi, öret socsoc böc woi moröma sinom, sop koingo ogepma sinom worocdec toctocyi.” ");
INSERT INTO yuw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ihoroc yuna Yesuho inogoc, “Boinno, önga böc wo moröma ogepma sinom idina aharoc mahong mit wömai böc worochon sop au nucno koroc wönggon maitning. Muno, sop worocho ambarac dondot morop morop tongo fonyun woce woce ongbödenahing.” ");
INSERT INTO yuw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Oro mit Yesuot youp amnaniot yu sa urongo au mano Oliv woce itmuya öret socsoc böc saurongodec aramo ökenne idina foringmu uuna agung. Auya Pita, Jems, Jön, Andru yuhogon Yesu inong ac tongga yogung, ");
INSERT INTO yuw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ninti, manomano moröma worocho wömai yaö bongonodec boinno öngkupnahing? O ihorocgon toroc kiap tingtingno sinom engkuuya nonu wo yangmanaina kombiantamon, urop manomano worocho boinno öngkupnahing.” ");
INSERT INTO yuw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Ihoroc inuya Yesuho ingoroc inogoc, “Kombiarut, imanang amna koböcmaho nochon ma sogida engmuya ingoroc kanonahing, ‘Nocu ngoroc, Kopotorocho inoin owi amnani fogit fogitha siuna ebotma woroc.’ Ihoroc yongo owi amna koböcma tonguc yenahing. Worocha son soni woho yacyacho itongitnung. ");
INSERT INTO yuw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Sonu wömai emoc dirung morömahon kikoröpno orin sum matano kombinahing. Kombingga soroc yoninga. Muno, Kopotorocho ‘toroc kiap ihorocnoho öngkupnahing’ yongo yong torop singdegoc. Oro kiap nanga fatfatnobarac worocho engkuangoc mahong guroc ngorochon bödec bödecno woi abe maic. ");
INSERT INTO yuw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Muno, osuc wömai kantri auho öngkungmuya kantri auot emoc tonahing. O ihorocgon king auhon toropniho öngkungmuya king auhon toropniot emoc tonahing. O ihorocgon sa woce woce wömai konoc fennahing orin nacno möp morö engoc. Kiap ihorocnoho wömai guroc ngorochon bödec bödecnohon forosicsicno. Woi owiho managumboc bacbacha focfoc kombingidangma woroc simbang. ");
INSERT INTO yuw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Son soniha yacyacho itongitnung. Owi amnaho son ayam tong kamongmuya son fogito mata youpdec fohong kunahinghu o Yuda nanohon fatmata yocyoc bucin fohong kungga kotnahing. O ‘nocha’ tongga sonu gavman amna morömaho yangaminthu o kingho yangaminthu nochon fatmata ogepma yu inong tauya kombinahing. ");
INSERT INTO yuw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","“Kombiarut, fatmata ogepma worocho sa guroc danong ongböde-una owi amna ambaracho kombinahing. Oro mit wömai gurochon bödec bödecno ehangoc. ");
INSERT INTO yuw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Oro owi amnaho son mata youpdec fohong kunahinganu wömai sonu ‘yaö mata yontamon’ yongo kombingbanac toninga. Muno, bongono wocin wömai sonibut ma-yoning, Kunkun Yaruho mata masang tong kamuna sonu woroc kombingga yongitnung. ");
INSERT INTO yuw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Oro bongono wocin wömai orugo aumaho orugo auma ayamiho oburodec siuna wuya omengoc. O faniho wömai managumbocni ayamiho oburodec finahing. O managumbocniho ihorocgon macni fani ayamphon oburodec fiuya dong omom tonahing. ");
INSERT INTO yuw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kombiarut, ‘nocha’ tongga owi amna ambaracho ayam tong kamonahing. Tuya owi amna kombing tobic tobicno maimu faiima yu wömai Kopotorocho bongono bödec bödecnodec inoha fogiuna batip itnahing,” Yesu yu mepmo bongonoha yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Oro son mata ngo kombic kombicbarac embaarut! “Yapmu wontucmuno sinom worocho engkungmuna Kopotorochon öret socsoc böc tun mointuna yapmu boyömo engoc. Yapmu worocho engkuuna anahinganu wömai owi amna Yudia gurocin itnahingma yu wohogon ibaru fauna karupgon sa urongodec öngbödenung. ");
INSERT INTO yuw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","O owi amna au böc koroc itnahingma yu wohogon korungon ongitnung. Yu wömai ‘yoctec manomano fogitna’ yongo wönggon böcno ganang öngga tong unim toninga. ");
INSERT INTO yuw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","O owi amna öndec itnahingma yu ibaru fauna böcnon engga tecno fogit fogitha kombiicha. Muno yu muyu karupgon korungon ongitnung. ");
INSERT INTO yuw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“Kou sinom, uroci morö, bongono wocin wömai owi mana modibnima orin managumbocno mum imongo itnahingma yu mepmo moröma sinom au feangoc. ");
INSERT INTO yuw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","“Bongono wocin wömai mepmo inobarac moröma sinom öngkuangoc. Mepmo ihorocnoma wömai forosicsicnodec Kopotorocho sa guroc dongyun öngkubungan engga bongono önga idamonan abe maidoc. O ihorocgon mit wönggon maic. Worocha son ‘yapmu wontucmuno worocho sum bongonodec öngkuicyit’ yongo dönac youp tarut. ");
INSERT INTO yuw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mepmo bongono worocho sa ubarago idinai wömai owi amna ambaracho omong faup. Wohong Kopotoroc yu owi amna inoha soworec soworecyi yuha kombingga mepmo bongono wo tong docut tangoc. ");
INSERT INTO yuw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Oro bongono wocin wömai imanang amna auho ingoroc kanonahing, ‘Kopotorochon Duic yu ngocin itac!’ O ‘okocin itac yo!’ Ihoroc kanuyai sonu yuhon mata kombing tobininga. ");
INSERT INTO yuw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Muno, amna auho kanong yucyuc tongo ingoroc kanonahing, ‘Noc Duic woroc!’ Tongo yu ‘Kopotorochon owi amna tönguc yenaya gorong ongonung’ yongo weran moröma orin toroc kiapmo inobarac sinom tonahing. Wohong Kopotorochon owi amnani gorong onggongon uyapdec fohong yucyucno wömai maic. ");
INSERT INTO yuw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Oro son soni woho acacho itong-itnung, yapmu wontucmuno wo abe maöngkui idina nocho worochon yong tuctucno urop önga kanongdehat.” ");
INSERT INTO yuw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yesuho mata sakaun fiuna yogoc, “Oro, mepmo bongono morö worocho bödeuna sep daro kumbong diangoc. O yarop maforii ida yagunono mamuic. ");
INSERT INTO yuw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","O fitnung yu wömai abamo imu fauna möngbödenahing. O ihorocgon mom muruc muruchon gesöno mongurac tongo fendup tonahing. ");
INSERT INTO yuw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Oro bongono wocin wömai guroc owi amnaho anahingmai Amnahon Manano yu mom göragodecma gesöbarac mitimoni sinompho ehangoc. ");
INSERT INTO yuw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Engga yu sum yaruni inongmuna yu mom sa guroc mondopmodec forosingga ongga bödec bödecnodec owi amna inoha soworec soworecyi yu feng suran tonahing. ");
INSERT INTO yuw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Oro, sonu ep fikhon toroc kiap angmuya kombic kombic ingoroc sogiarut: Betomo yamugoni idiya sakemo biruc tuya sontho wo angga kombiantang, sep bongono urop ehangoc. ");
INSERT INTO yuw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Oro worochon torocgon sontho manomano woroc yangmuya kombinahing, Amnahon Manano yu urop böc simbun ambehecgon itac yo. ");
INSERT INTO yuw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nocho boinno sinom kantiwa, amna önga ngocin idangma yuhon morogoni abe mabödengidiya manomano yatma ngoi ambarac öngkungdup tonahing. ");
INSERT INTO yuw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mom sa guroc yu bödetahamoroc mahong nochon mataho wömai koing songga iditnoho iditno edengoc.” Yesu yu inoin engkup engkup bongonoha mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesu yu mata sakaun fiuna ingoroc yogoc, “Manomano worochon öngkup öngkup bongono sinom wömai amna auhu o sum yaru auhu o Mananohu, non ambarac makombimon. Nandöng noni ino tunguho-gon wömai wo kombihac. ");
INSERT INTO yuw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Sonu makombing, yu bongono wocinthu wocinthu ehangoc. Worocha son yacyacho orin kombic kombicho itongitnung. ");
INSERT INTO yuw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Ebepnohon mata tepmo au wömai ingoroc: Amna au yu böcno imun fauna sa auhon onggonga togoc. Tongo yu ‘böcna manomano youp wabkaracnai angtorenung’ yongo youp wabkarac inoin inoin youp soworeng imogoc. O youp wabkarac au wömai yu ‘böc simbudec gön tongga iti’ yongo youp imogoc. Youp ihoroc soworeng imongbödengga yu sa auhon onggoc. ");
INSERT INTO yuw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Oro sonu ihorocgon gön tong-ga arangarang yongga iditnung. Wömai yaha son böc morömphon ebep bongono makombiingmaha arangarang yongga iditnung. Dobocsisichahu o kumbong bonipnodechu o fup sigo yonginahu o kembotsumgontu bongono wocin ehangocno woi sonu makombiing. ");
INSERT INTO yuw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yu karupgon ehuna sonu ducedet tongga itningyit. ");
INSERT INTO yuw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Oro nocho mata ngo kantatma woi owi amna ambaracha yongga yat, sonu arangarang yongga idarut.” Yesu yu ino ebep bongonoha yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Oro urop nacno sowarango yisno muno nocnochon bongono morö ‘Pasowa’ worocho engfom togoc. Sep youp toctoc yaihogon idomoroc. Tuna öret socsoc böchon amna dugo orin nongoru gendic fandat fandat amna yu suran tongga ‘Yesu öpgon sogito wotnaya omengac’ yongo worochon uyapha yabigung. ");
INSERT INTO yuw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tongo yu yogung, “Nonu bongono morödec ihoroc tontamonanu wömai suraroho wo angga ecimuna emoc morö tup. Worocha bongono wocinnu angit matonin,” ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Oro Yesu yu Betani böcsa woce idoc. Tongo yu Saimontho bucin öngmuna nacno nocnoc abamdec omoc idoc. Saimon yu wömai osuc obukoc lepra togoc. Yesu yu woce idina owi au yu unac tugo ogepma sogitmuna yuot eboc. Unac worochon wöngnacno woi önggöngyi sinom, wo kaya ureng obugu au wocin idoc. Tuna owi worocho kaya ureng wo fuc tongga unac Yesuhon bigodec korigoc. ");
INSERT INTO yuw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ihoroc tuna amna au wocin idungmaho wo angga yogung, “Owi wo yu unac komanang sinom tong samborec tac yo. ");
INSERT INTO yuw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Non woroc sinaya amna auho 300 Kinahon toroc wuuna non möneng woroc owi amna uroci imonam,” ihoroc yongga owi wo inong fadung. ");
INSERT INTO yuw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tuna Yesuho inogoc, “Owi ngorocho noc toroc ogepma sinom tong namoc. Sonu yu inong saha toninga. ");
INSERT INTO yuw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kombiarut, amna uroci yu bongono muno sonot itnahing. Tongo son ogep yu tongfat yeup mahong nocu wömai bongono ubarago sonot mait. ");
INSERT INTO yuw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Owi ngo yu yapmu ino toctocha kombihacma woroc ogepma sinom tongnamoc. Yu unac godibnadec wagang namocma woi godip föbna oring sicsicha tong arangarang toctochon toc. ");
INSERT INTO yuw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","“Nocho boinno sinom kantiwa. Mit wömai owi amnaho ongmuya nochon fatmata ogepma sa guroc danong woce woce yonahing. Tongo yu owi ngorocha kombingmuya yu kiapmo ngo tong namocma wo ihorocgon yongo itnahing,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Oro mit amna au mano Yudas Iskariot yu woi Yesuhon youp amnani 12 yuhon toropdecma, yu ‘Yesu ayamihon oburodec siantat’ yongo öret socsoc böchon amna morömaot onggoc. ");
INSERT INTO yuw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tuna amna dugoho woroc kombingga toup sinom borongdeda Yudas möneng imimpha yong koing yogung. Ihoroc tuya Yudas yu forosingga Yesu ayamphon oburodec sicsichontha uyapha yabigoc. ");
INSERT INTO yuw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Oro urop bongono morö nacno sowarango yisno muno nocnoc worocho idoc. Tuna bongono wocin wömai Israel nanoho Pasowa nacno nongidung. Tongo yu Kopotorocho yang banagocma worocha kombingmuya bot sipsip beracno dongga sonongidung. Oro bongono worochon forosicsicnodec wömai youp amnaniho Yesuot ongmuya ingoroc inong ac togung, “‘Non sa nahenne sinom ongmanaina Pasowa nacno tong arangarang tona’ yongo kombiharoc?” ");
INSERT INTO yuw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ihoroc inuya Yesuho youp amna yai soworengga ingoroc inogoc, “Sot Yerusalem taun ongunya aantamorocmai amna au yamuc ureng sogida teantac. Teuna sot yu tan tongunya ");
INSERT INTO yuw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","yuho kangato böc auhon fongontac. Tuna sot böc worochon morömo ingoroc inarun, ‘Fandat fandat amnaho ganong ac tac, nocot youp amnanaiot non böc irotno nahenne Pasowa nacno naantamon?’ ");
INSERT INTO yuw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ihoroc inunya yu böc irotno moröma au kindaantac. Böc irotno worocho wömai nucno koroc itac. Wocin wömai nacno nocnochon abam manomano ambarac arangarang yongga idang. Tuna sodu woce ongmunya nacno noni tong arangarang tarun.” ");
INSERT INTO yuw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yesuho ihoroc inuna youp amnanin yaima yu ongga aunya manomano Yesuho yogocma worochon toroc sinom idoc. Tuna yu nacno woce tong arangarang togomoroc. ");
INSERT INTO yuw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Oro, sa dobocsiuna Yesuot youp amnani 12 yu ambarac engga ");
INSERT INTO yuw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","nacno nocnoc abamdec omoc itmuya Yesuho inogoc, “Nocho boinno sinom kantiwa, sonthon bonip sonidecma amna tungu auho ongga noc ayamnaihon oburodec siantac. Amna woroc yu nonot ngocin nacno nongga itac.” ");
INSERT INTO yuw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ihoroc inuna youp amnaniho mata woroc kombingga irotnoho kombing mep tongmuya amna tungu tunguho Yesu inong ac tongga yogung, “Nocha yarochu?” ");
INSERT INTO yuw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ihoroc inong tonguya Yesuho yogoc, “Woi amna au sonthon torop sonidecma, yu wömai nocot waga ngorocdec nacnoha obu nodi soreamot. ");
INSERT INTO yuw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Boinno sinom, Amnahon Manano yui Kopotorochon bapiyadec irim toctocyi itacma worochon torocgon tanto guroc ngo imun faantac. Wohong koukou sinom, amnaho noc ayamnaiho oburodec siantacma yu wömai urago mepmo moröma sinom aun feangoc. Macnoho yu mabaachai wömai yu ogep in.” ");
INSERT INTO yuw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Oro yu ambarac nacno nongo itmuya Yesuho nacno sowarango sogitmuna Kopotoroc ecec inongga uboda youp amnani silip tong imongga ingoroc inogoc, “Sogida naarut. Ngoi nochon godip föbna.” ");
INSERT INTO yuw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ihoroc yongga wain kap sogitmuna Kopotoroc ecec inongga youp amnani wain imuna yu ambarac nagung. ");
INSERT INTO yuw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nauya Yesuho ingoroc inogoc, “Wain yamuc ngoi nochon nogotna. Woi Kopotorocho soniot botup botup sigocma worochon weranno. ‘Nochon nogotnaho koriuna owi amna koböcmahon turongono dongyun bödenung’ yongo yun bödec bödecyi. ");
INSERT INTO yuw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nocho boinno sinom kantiwa, nocu wain yamuc manai edeya ongga wönggon Nandöngnahon midim sabarac sadec wain wego naangot.” ");
INSERT INTO yuw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yesuho youp amnani ihoroc inuna mit yu ambarac yong moröng ap yongga böc woroc imu fauna Oliv sa urongodec ögung. ");
INSERT INTO yuw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Oro, Yesuho youp amnani inogoc, “Son ambaracho botongga noc imu faangot. Wömai yaha Kopotorochon bapiyadec mata ingoroc irim toctocyi itacmaha: ‘Nocho bot sipsip yangtorecno weya bot sipsipho botongga woce woce gorong ongbödenahing.’ ");
INSERT INTO yuw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Tongo nocho omocdecma idongga osuc fat kamongga Galili gurocin kaa feuya kondong itnahamon.” ");
INSERT INTO yuw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yesu yu ihoroc yuna Pitaho inogoc, “Muno sinom, owi amna ambaracho goc me gamontang mahong nocu ihoroc matit.” ");
INSERT INTO yuw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ihoroc yuna Yesuho inogoc, “Nocho boinno sinom gantiwa, önga kumbong ngocin fup sigo abe mayi idina goc gakabut nocha bongo anfi möp yong namontaroc.” ");
INSERT INTO yuw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yuna Pitaho toup kiringga wönggon inogoc, “Muno sinom, noc ogep gocot omentamot mahong nocu gocha möp mayit.” Pita ihoroc yuna youp amna nucni yu ambarac mata ihorocnogon yogung. ");
INSERT INTO yuw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Oro mit Yesuot youp amnaniot yu sa au mano Getsemane woce onggung. Woce ongga itmuya Yesuho ingoroc inogoc, “Son ngocin omoc idiya nocu ongmaina dönac youp tontat.” ");
INSERT INTO yuw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ihoroc inongga Pita, Jems, Jön yu yangat fongga ongga irotnoho kombingbanac tongo kombing mep tongmuna amna wo inogoc, ");
INSERT INTO yuw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Irotnaho toup sinom mep tuna omomno kombihat. Son ngocin itmuya nocot gön tongga idarut.” ");
INSERT INTO yuw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ihoroc inongo obmukusuc okoce ongga gurocdec möngga ‘Kopotorocho kombiuna angit idinai wömai mepmo bongono ngo karupgon bödehun’ yongo dönac ingoroc yogoc, ");
INSERT INTO yuw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Nandöngna, goc ogep focfoc morö nocdec öngkup öngkupha tacma wo tui dehun. Wohong nochon kombic kombic muno, gakain irotho koing soun.” ");
INSERT INTO yuw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesu dönac ihoroc yun bödeuna ibarun fauna youp amnaniot ongmuna yagocmai yu dungga idung. Tuna yu Pita inogoc, “Goc dubarochu? Mayain, goc bongono docutnogon nocot wec ida dönac youp angit matim. ");
INSERT INTO yuw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Son muyu gön tongga itmuya dönac youp tarut. Tonguc yecyecho sondec öngkuuna sing kapningyit. Irot noniho wömai manomano toctocha kombihac mahong godip föpnoni woi singo.” ");
INSERT INTO yuw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesuho youp amnani ihoroc inongga wönggon obmukusuc ökenne ongga dönac osuc yogocma ihorocnogon wönggon yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ihoroc tongga youp amnaniot engmuna yagocmai yu wönggon godibo mep tuya dungo idung. Dungo idiya Yesuho inong yuna yu matano ökene iban imocimochon makombigung. ");
INSERT INTO yuw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tuna Yesu wönggon bongo anfino dönac youpha onggoc. Tongo wönggon engmuna youp amnani inogoc, “Son dupninga! Nochon bongono urop engtepac. Amnahon Manano yu urop wontucmuno toctoc amnahon oburodec entac. ");
INSERT INTO yuw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Idonguya ongona, noc ayamahon oburodec sicsic amna yu urop ambehecgon epac.” ");
INSERT INTO yuw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu yu mata wo yongga idina urop Yudasho sa woce engkuboc. Yudas yu Yesuhon youp amnani 12 yuhon toropdecma. Oro yuot wömai amna torop morömaho bainat, kando fogitmuya ebung. Amna torop wo wömai öret socsochon amna dugo orin nongoru gendic fandat fandat amna orin surarohon amna dugo yuho inong muuya ebung. ");
INSERT INTO yuw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Oro Yesu ayamphon oburodec sicsic amna Yudas yu amna torop wo mata ingoroc inogoc, “Nocho ongmaina amna au sogito ducin ducin tontat. Ihoroc toya angmuyai son kombiantang, amna woroc sogit akep tongga tongona.” ");
INSERT INTO yuw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Oro Yudas yu wo yogocmahon toroc karupgon Yesuot ongmuna, ‘fandat fandat amna’ ihoroc inongo ducin ducin tong imogoc. ");
INSERT INTO yuw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Woroc tuna angga tawa amnaho Yesu sogida akep togung. ");
INSERT INTO yuw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Woroc tuya amna au ambehecgon idocma yu gobitno woding tongga öret socsoc böchon amna dugohon youp wabkarac woda gobitho onggimo saringmun mögoc. ");
INSERT INTO yuw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Saringmun muuna Yesuho tawa amna inogoc, “Son ingoroc kombianghu, noc ‘gavman taraya ongoun’ yongo emoc toctocha kombihat. Worocha wömai son bainat kando fogida fengga noc sogit akep toctocha tanghu nuhun? ");
INSERT INTO yuw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Woi muno sinom, noc bongono muno öret socsoc böchon gomboin itmaina owi amna fandat inongidot mahong sontho noc sogit akep toctocha makombigung. Wohong yong tuctuc mata Kopotorochon bapiyadec itacmaha worocho ambarac boinno öngkungbödenung.” ");
INSERT INTO yuw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yesuho ihoroc yongbödeuna youp amnani ambaracho botongga domdomgon ongbödegung. ");
INSERT INTO yuw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Oro, wabkarac berac au yu ihorocgon Yesu tan tonggoc. Yu wömai boru tungugon temongga eboc. Tuna tawa amnaho yu sogit akep toctocha tuya ");
INSERT INTO yuw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","amna berac wo botongga boruno daruna muroc dom-domgon sa korungon onggoc. ");
INSERT INTO yuw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Oro, tawa amna yu Yesu yangada öret socsoc amna dugo yuho bucin tonggung. Tuna öret socsochon amna dugo orin surarohon amna dugo orin nongoru gendic fandat fandat amna yu ambarac böc wocin suran tongga idung. ");
INSERT INTO yuw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Oro Pita yu obmukusuc korungon bum ida Yesu tan tongmuna ongga böc gombo ganang woce engkuboc. Engkungga yuot tawa amnaot kondonggon ep songgonda idung. ");
INSERT INTO yuw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Oro, bucin wömai öret socsoc amna dugo orin Yuda nanohon kaunsil yu Yesu wot omom toctochon uyapha dabingmuya ‘yuhon wontucmuno au tana eran öngkupun’ yongo youp morö togung mahong Yesuhon wontucmuno au maidoc. ");
INSERT INTO yuw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Amna koböcmaho wömai Yesuha imanang mata ihono ihono firing tandung mahong yu mata tungu mayogungmaha tongga matano makoingsogoc. ");
INSERT INTO yuw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Oro mit amna auho idongga Yesuha imanang mata ingoroc fir-ing tanda yogung, ");
INSERT INTO yuw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Amna ngo yu ingoroc yuna kombigomon, ‘Noc ogep öret socsoc böc wo gumanda sep anfihagon wego temongma öangoc. Öret socsoc böc osucno wömai amnaho togung mahong wego tangotma wömai amnaho tobic tobicyi muno.’” ");
INSERT INTO yuw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Yu mata gemdat ihoroc yogung mahong yuhon mata ihorocgon tungugon maöngkuboc. ");
INSERT INTO yuw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tuna öret socsoc amna dugo yu idongga Yesu inogoc, “Mata ngo gocha firing garangma woi boinnoha woha muno. Goc mata urago au yoi.” ");
INSERT INTO yuw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ihoroc inogoc mahong Yesuho öpgon ito mata au mayogoc. Tuna öret socsoc amna dugoho wönggon inogoc, “Yoi, gocu Duic, Kunkun amnahon Manano worochu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yuna Yesuho inogoc, “Öc, woi naka. Kombiarut, mit wömai sonu anahingmai, Amnahon Manano yu Kopotoroc Gesö Morömo yuhon obu aroce itmuna mom muruc muruc koroc ida ehangoc.” ");
INSERT INTO yuw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ihoroc yuna öret socsoc amna dugo yu mata woroc kombingga inoin tec tohomunmöcno wirangga yogoc, “Urop, non amna auhon matano makombinin. ");
INSERT INTO yuw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Muno, non ambarac yu Kopotorocha yong samborec yacno kombingbödeamon yo. Worocha son tingting kombiang?” Ihoroc yuna amna dugo ambaracho yogung, ‘Wuya ompun.’ ");
INSERT INTO yuw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ihoroc yongga auho forosingga irubo Yesudec sundung. Tongga yu techo daro foc tongga tom tongmuya woda inogung, “Goc yong tuctuc yoi, numaho gotac.” Ihoroc tuya tawa amnaho engga Yesu sogida tongga wodung. ");
INSERT INTO yuw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Oro Pita yu öret socsoc amna dugohon böc gombo ganang woce idina amna dugohon mongorec toctoc owi auho eboc. ");
INSERT INTO yuw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ehuna Pita yu ep songgonto idina owi worocho yu among ficfic tongga inogoc, “Yesu Nasaretma yuhon toropdecma au woi gaka!” ");
INSERT INTO yuw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ihoroc inogoc mahong Pita yu möp yongga yogoc, “Noc gochon matahon foro makombit.” Ihoroc yongo gombo sumonne onguna fup amnanoho mano yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pita woce idina mongorec toctoc owiho yu wönggon angga amna wocin idungma inogoc, “Amna ngoi ihorocgon Yesuhon toropdecma.” ");
INSERT INTO yuw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ihoroc yuna Pitaho wönggon möp yongo ‘muno’ yogoc. Oro, opmukusuc ida amna wocin idungmaho Pita inogung, “Boinno sinom goc yuhon toropdecma, goc ihorocgon Galilima.” ");
INSERT INTO yuw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ihoroc inuya Pitaho inoha möp yongo yong koing yongga yogoc, “Boinno sinom onoce, noc amna woroc makombing imot.” ");
INSERT INTO yuw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ihoroc yong-bödeuna wohogon fup amnanoho mano yuna bongo yai idoc. Fupho mano yuna Pitaho Yesuhon mataha kombigoc. Yesuho wömai ingoroc inogoc, “Fup amnanoho abe bongo yai mayi idina gocho bongo anfi möp yong namangoroc.” Pita yu mata worocha kombingmuna ointogoc. ");
INSERT INTO yuw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Oro sa isuna öret socsoc amna moröma orin nongoru gendic fandat fandat amna orin surarohon amna dugo yu ambarac irot tungu singmuya Yesuhon matano yu bödegoc. Yu bödeuna yu Yesu yidec kaning yungmuya Gavman amna moröma Pailat yuot tohong yugung. ");
INSERT INTO yuw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tuna Pailatho Yesu inong ac tongga inogoc, “Goc Yuda nanohon king worochu?” Ihoroc inuna Yesuho yogoc, “Öc gaka yarocma woi boinno.” ");
INSERT INTO yuw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ihoroc yuna öret socsoc amna dugo yu mata koböcmaho firing tandung. ");
INSERT INTO yuw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ihoroc tuya Pailatho wönggon Yesu inong ac tongga yogoc, “Kombiharoc, yu gocha mata koböc firing garang. Goc mata worochon urago mayirochu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ihoroc inogoc mahong Yesu yu öpgon idoc. Worocha tongga Pailatho nangano fadoc. ");
INSERT INTO yuw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Oro, gavmanthon morömahon toroc kiap au ingoroc ididoc: Biruc danong Yuda nanohon bongono morödec suraroho inobut yi bucinma amna auhon mano yuya Pailatho amna woroc asan imuna orung ongidoc. ");
INSERT INTO yuw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Oro, bongono wocin wömai amna torop au yu ‘gavman tanaya ongoun’ yongo tawa amnaot emoc tuya tawa amnaho yu yibucin fohong yugung. Tuya emoc amna au mano Barabas yu ihorocgon emoc tongga amna au wot sigocmaha yibucin idoc. ");
INSERT INTO yuw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Oro owi amna koböcma sinompho engmuya Pailat inogung, “Gocho toroc kiap biruc danong tongitarocma worochon toroc önga ihorocgon amna au angbanaya orung ongoun. ");
INSERT INTO yuw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ihoroc inuya Pailatho mata urago ingoroc inogoc, “Son tingting kombiang oro, ‘nocho Yuda nanohon king yu woroc asan impiwa’ yongo kombianghu?” ");
INSERT INTO yuw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat yu wömai surarohon foro ingoroc kombingbödegoc. Öret socsoc böchon amna dugo yu Yesuha ecego kombigung, yaha yu suraroho yangamin ma moröma sogidocmaha. Foro worocha tongga yu Yesu mata youpdec tohong yungga ");
INSERT INTO yuw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","surarohon irotno sakangga ingoroc inogung, “Son Pailat kiring imuya yu Barabas asan nimpun” ihoroc inogungmaha suraroho Barabasha yogung. ");
INSERT INTO yuw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ihoroc yuya Pailatho yogoc, “Oro, son Barabasha yangmaha nocho amna ngo son ‘Yuda nanohon king’ ihoroc yongidangma yu tingting tong imontat yo?” ");
INSERT INTO yuw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pailatho ihoroc yuna suraroho ecnang sinom mambodung, “Ep goröcdec wuya ompun.” Ihoroc mambuya Pailatho yogoc, ");
INSERT INTO yuw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Nocu yuhon wontucmuno maat, worocha foro yaha ompun yo?” Pailatho ihoroc yogoc mahong suraroho ecnang sinom mamboto yogung, “Ep goröcdec wuya ompun!” ");
INSERT INTO yuw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ihoroc yuya, Pailatho ‘surarohon irot dongya guc maarut’ yongo Barabas asan imogoc. Tongo yu tawa amna inuna yu Yesu woda ‘ep goröcdec sina’ yongo tohong yugung. ");
INSERT INTO yuw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Oro tawa amnaho Yesu yangada gavmanthon böc moröma worochon gombo ganang tonggung. Tongga yu tawa amna nucni ambarac inong yuya engbödegung. ");
INSERT INTO yuw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Engga yu Yesu tec tohomunmucno yu temong imogung. Tongo yu yi dirongoni sogitmuya worocdecma amna kinghon tec kutkutno kiap tongo bigodec tohomu möngimogoc. ");
INSERT INTO yuw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Oro, ihoroc tongga yu forosingga imanang yongkumec yong imongga yogung, “Sep ogep Yuda nanohon king.” ");
INSERT INTO yuw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tongo kandöng sogitmuya bigodec wotgon tongga irubo yudec sundung. Ihoroc tongga yu goruc yemoc tong imongga imanang yong moröng imogung. ");
INSERT INTO yuw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yu toroc kiap wontucmuno ihorocno tong imongbödengga wönggon tec gomono tuu deuna inoin tec tohomunmucno temong imongga ep goröcdec wotwotha yangat tonggung. ");
INSERT INTO yuw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Oro, amna au mano Saimon Sairini taundecma, yui Aleksander orin Rufas yuhon fano. Yu öndecma engga taun onggonga tongidina tawa amnaho yu sogida woding tengga Yesuhon ep goröc imuya sumboda tonggoc. ");
INSERT INTO yuw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tuna tawa amnaho Yesu yangada sa au mano Golgata wocin tögung. Sa mano ‘Golgata’ worochon foro, wömai ‘bic kudat’ ihoroc. ");
INSERT INTO yuw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Oro, wocin öngkungmuya tawa amnaho Yesu wain yamuc marasin beci sinom tobic tobicyi woroc imogung mahong Yesuho ‘muno’ yongo managoc. ");
INSERT INTO yuw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tuna yu Yesu ep goröcdec wodung. Woroc tongga yu Yesuhon tec napno ‘silip tona’ yongo tim kumec togung. ");
INSERT INTO yuw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Oro, sep bongono 9 kilok kembotsumgon bongono wocin yu Yesu ep goröcdec woto sigung. ");
INSERT INTO yuw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","O ep mondopmodec wömai yu irim au akep togung. Irim wo wömai Yesuhon matanohon yong tuctucno ingoroc, “Ngoi Israel nanohon king,” ihoroc tongo sigung. ");
INSERT INTO yuw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Oro Yesuhon obu kandocne o arocne wocin wömai tawa amnaho usem amna yai ep goröcdec dobung. ");
INSERT INTO yuw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yu ihoroc togungmaha tongga Kopotorochon yong tuctuc mata au boinno öngkuboc. Mata woi ingoroc irim toctocyi itac: ‘Suraroho Yesuha kombigung, yu wontucmuno toctoc amna.’ ");
INSERT INTO yuw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Owi amna sa woce itonggungma yui bic ubung ubung tongmuya Yesu inong saha tongo yogung, “Öhö, goc ngorocho öret socsoc böc gumanmina sep anfiho irodin wönggon tobic tobicha yogorocha. ");
INSERT INTO yuw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Oro gocu gaka tongfat yengmina ep goröc imi fauna ohoi.” ");
INSERT INTO yuw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Owi amna ihoroc inong saha tong imong idiya öret socsochon amna dugo orin nongoru gendic fandat fandat amna yu ihorocgon inohogon mata inun ganun tongga yogung, “Yu osuc owi amna wontucmunodecma öcangyun muuya itonggong koing imocimocha yongidoc mahong inoin itonggong tun öngkup öngkupha wömai makombic. ");
INSERT INTO yuw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","O yu inoha yogoc, ‘Noc Duic, o noc Israel nanohon amna morömano king itat.’ Oro yu boinno Duic itacanu wömai yu ep goröc imun fauna ohuna nonu wo angga yu kombing tobing imontamon.” O worochon torocgon wömai usem amna yai Yesuot ep goröcdec dobungma yui ihorocgon Yesu inong saha toup togomoroc. ");
INSERT INTO yuw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Oro, apmano 12 kilok forosingga sa guroc ambarac kumbong dingga idinagon ongga 3 kilok bödegoc. ");
INSERT INTO yuw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tuna sep bongono 3 kilok idina Yesuho ecnang ingoroc mambodoc, “Eloi, Eloi, Lama Sabaktani!” Mata worochon foro wömai ingoroc: ‘Kopotorocna, Kopotorocna, goc foro yaha noc me namongga imi fahat.’ ");
INSERT INTO yuw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ihoroc yuna amna au ambehegon idungma yu mata woroc kombingga yogung, “Kombiarut, yu Elaiya inong yac.” ");
INSERT INTO yuw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ihoroc yuya wohogon amna auho karupgon ongmuna top yat au sogida wain beci yamucdec tomun muuna öngfoc tuna ‘Yesuho nahun’ yongo bokotdec akep tongga Yesu dugodec sorengmun uuna yogoc, “Imana fauna ana, Elaiyaho engga tongfat yeanthachu o munohu?” ");
INSERT INTO yuw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ihoroc yuna Yesu yu ecnang sinom mamboda omong fadoc. ");
INSERT INTO yuw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Omong fauna wohogon boru moröma öret socsoc böc irodin idocma worocho onoce singga fuc tongga ohongga mondopmodec omoce bödeuna fugo yai idomoroc. ");
INSERT INTO yuw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Oro tawa amnahon ofisano yu Yesu tan itmuna Yesu yaö kiapdec ombocma wo angtangtang togoc. Tongo yu Yesuhon mambocno kombingga ingoroc yong taboc, “Boinno sinom amna ngoi Kopotoroc-hon Manano,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Oro owi au yu korungonbum itmuya manomano öngkubocma wo yangbödegung. Owi worochon bonipno-dec wömai Maria Makdala bucinma, o Jems mitma orin Yosishon macno, o owi au mano Salome yu woce idung. ");
INSERT INTO yuw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Owi wo yu wömai Yesu Galili gurocin itongidocan yuot itongmuya nacno manomanoha mongorec tong imongidung. Oro owi worocot wömai owi torop moröma auot yu Yesu tanda Yerusalem engmuya sa woce ida Yesu ombocma wo agung. ");
INSERT INTO yuw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Oro Sabathon manomano tong arangarang toctochon sep youp toctoc bongono idina dobocsisia ");
INSERT INTO yuw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","amna au mano Yösep yu eboc. Yuhon böcsano woi Arimatea. Yu wömai Yuda nanohon kaunsil memba au idoc. O yu ‘Kopotorochon toborucno urop ehantac’ yongo worocha torengga ididoc. Oro amna wo yu Pailatha mabotogoc, muno yu koing songga ‘Yesuhon ep fambangno sogida oring siwa’ yongo Pailatot ongmuna inong ac togoc. ");
INSERT INTO yuw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Inuna Pailatho irot yai tongga yogoc, “Yesu urop omechu nuhun?” Tongo yu tawa amnahon ofisano inong yuna ehuna Pailatho inogoc, “Yesu yu urop omecha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ihoroc inuna ofisaho ‘urop ompac’ yuna Pailatho Yösep ‘öc’ inongo “Yesuhon ep fambangno ogep sogiantaroc.” ");
INSERT INTO yuw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ihoroc inuna Yösep yu ongga boru sacsago au wöngga Yesu ep fambangno ep goröcdecma tuhun deuna boru sacsagodec tombot-muna sumboda tongga amna ficfichon sop ganango au wocin sigoc. Tongo yu sop moröma ibaruna ongga sop momböngno foctongmun fauna onggoc. ");
INSERT INTO yuw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ihoroc tuna Maria Makdala bucinma orin Yosishon macno Maria, yu wocin itmunya aunya Yesu ep fambangno sa nahenne sigocno wo agomoroc. ");
INSERT INTO yuw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Oro Sabat bongono urop bödeuna, Maria Makdala bucinma ot Maria auot Jemshon macno ot owi Salome ot yu ‘ep fambang-no unac tugo ogepmadec wagana’ yongo ongmuya unac tugo ogepmani wögung. ");
INSERT INTO yuw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ihoroc tongga Sönda kembotsum sinom ongga amna kumkumon sop ganango woce onggung. ");
INSERT INTO yuw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yu uyapdec itmuya mata ingoroc inun ganun togung, “Numaho non tongfat nengga sop moröma ganango köndet mun ongnimontac? ");
INSERT INTO yuw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ihoroc yongga ongga agungmai sop moröma wo urop amna auho ibanmun onguna sop ganango fagarit fagarityi idoc. ");
INSERT INTO yuw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ihoroc idina angga yu sop ganang ohongga agungmai amna berac tungu tec tohomunmöcno föhocno yu obu aroc tanne omoc idoc. Woce idina owiho angga soroc yogung. ");
INSERT INTO yuw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Soroc yongga idiya amna worocho inogoc, “Son botoninga, son Yesu Nasaretma yuha yabiang mahong yu ngocin maec. Yu ep goröcdec wuya omboc mahong yu urop idonggoc. Sonibut aarut, yu abamo ngocin idoc mahong maec. ");
INSERT INTO yuw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Worochai son domdomgon ongga Pita orin youp amnani yu ingoroc inarut, ‘Yesu yu ongga Galili gurocin osuc fat kampac. Son ongga guroc wocin anahing. Yesuho osucgon ‘ihoroc öngkuangoc’ yongo kanong tuctuc togoc.’” Amnaho ihoroc inuna ");
INSERT INTO yuw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","owi yu kombingga kudat konoc konoc tongga botongga sop ganango wo imu fauna domdomgon onggung. Yui toup botogungmaha tongga amna au fatno wo mainogung. ");
INSERT INTO yuw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Oro Yesu yu Sönda kembotsum sinom idongga ongga osuchagon Maria Makdala bucinma öngkung imogoc. Owi worocdecma wömai Yesuho osuc dogu boyömo 7 dongyaruna onggung. ");
INSERT INTO yuw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Öngkung imuna Maria yu ongga worochon fatno owi amna Yesuot itongima yu inogoc. Owi amna torop wo yu wömai irot mepmep toup tongmuya yong oin tongga idung. ");
INSERT INTO yuw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ihoroc tongga idiya Mariaho engmuna inogoc, “Nocho Yesu aat! Yu wec itac.” Ihoroc inogoc mahong yu mata wo makombing tobing imogung. ");
INSERT INTO yuw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Oro mit wömai Yesuho youp amnanin yaima öngkung imogoc. Yu Yerusalem imun fauna uyapdec ongidinya Yesu amna au simbang ganda yu öngkung imogoc. ");
INSERT INTO yuw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ihoroc tuna angga amna yai yu ibaru fauna ongga fatno youp amnani fandat inogomoroc mahong yu yaimahon fatno ihorocgon makombing tobigung. ");
INSERT INTO yuw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Oro oipmon wömai Yesuhon youp amnani 11 yu nacno nongga idiya Yesu yu öngkung imogoc. Youp amnani yu abe kombing tobic tobicno muno idung. Tongo irotno foc tuna owi amna Yesu idonggocmahon fatno inogungma wo makombing tobigung. Worocha tongga Yesuho yu inong fadoc. ");
INSERT INTO yuw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tongo mit yu ingoroc inogoc, “Son gurocno gurocno ongmuya nakain fatmata ogepma owi amna ambarac fandat inongitnung. ");
INSERT INTO yuw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tuya owi amnaho noc kombing tobing namongga yamuc guantangma yu wömai Kopotorocho inoha fogiuna batip itnahing. Wohong owi amna noc makombing tobing namontangma yu wömai mata youpdec öngkungga gorong ongbödenahing. ");
INSERT INTO yuw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Oro kombing tobic tobic owi amna yu wömai toroc kiap ingorocno tongonahing: Nochon madec singga dogu boyömo dong yannahing. O yu mata ingguro auhondec yonahing. ");
INSERT INTO yuw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","O yu gorom ingingo oburin sogitnahing. O ihorocgon yamuc ingingo nangga maobukoning. O yu oburo owi amna obukocnidec out fohuya orokonahing,” Yesuho youp amnani mata ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Oro Moröma Yesu yu mata ihoroc yongbödeuna Kopotorocho yu sogito momdec tögoc. Tuuna yu woce Kopotorochon oburo arocne iditac. ");
INSERT INTO yuw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tuna mit youp amnaniho ongga fatmata ogepma böcsa danong yong morögiuya Morömaho yu tongfat yengga toroc kiap ihono ihono doun öngkuuya fatmatano tong koing togoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Sep ogep amna moröma Tiofilas, osuc wömai amna koböcmaho obu toroc tongo Kopotorocho toroc kiap bonip nonidec dongyun boinno öngkubungma worochon fatno irim togung. ");
INSERT INTO yuw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Irim togungma wömai inoin kombic kombic matandung. Muno, amna auho manomano öngkubungma wo inoin dantho yango ninogungma worocgon wömai yu irim togung. Amna manomano yagungma yu wömai manomano ambarac öngkubungma forosicsicdecma tuctugo sinom yangga fatmata ogepma fandat tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Amna moröma Tiofilas, nocu ihorocgon Yesuho youp tongidocma worochon foro sinom eran sicsicha yangsoworec soworec youp morö togot. Woroc tongo nocho Yesuhon fatno ambarac forosicsicdecma ongga bödec bödecnodec tuctugo sinom kombingbödehat. Kombingbödengmaina ‘gocha’ yongo Yesuhon fatmata ogepma nongnongo sinom irim toctocha tat. ");
INSERT INTO yuw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Irim toya gocu bapiya ngo embatmina ingoroc kombiantaroc: Fatmata ogepma osuc fandat ganogungma woi boinnogon, imanang muno. ");
INSERT INTO yuw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Oro, osuc amna moröma mano Heröt yu Yudia nanohon king idocan bongono wocin wömai öret socsoc amna au mano Sekaraia yu idoc. Yu wömai öret socsoc amna Abiya yuhon youp toropot öret socsoc youp tongidoc. Yuhon oweno mano Elisabet. Yu woi ihorocgon öret socsoc youp forosicsic amna Aron yuhon morogodecma. ");
INSERT INTO yuw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Oro, oimna wo yui Kopotorocho yangamin nongnongo idomoroc. Tongo yu Morömahon nongoru mata orin gendicno wo ambarac angitgon tanidomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Oro owi Elisabet yu wömai gungac bacbachon gesö maidimogoc. Worocha tongga oimna yai yu kowon itmunya urop basi dedomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Oro bongono au, Sekaraiahon youp torop yu öret socsoc bucin youp tongga itmuya Sekaraiaho Kopotorochon yangamin öret socsoc youp togoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Youp torop wo yu wömai Yuda nanohon öret socsoc amnahon toroc kiap tanmuya ‘numaho Kopotorochon öret socsoc kunkun böc irotnon böruc tugo ogepma soun’ yongo sop tim mondung. Sop tim moruya Sekaraiahon sop tim koing sogoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Koing suna Sekaraia yu boröc tugo ogepma socsocha öret socsoc bucin öngga idina owi amna koböcmaho böc worochon amante suran tongga dönac yongo idung. ");
INSERT INTO yuw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Suraroho suran tongga idiya Sekaraia yu böc ganang woce itmuna agocmai, Morömahon sum yaru auho öngkung imongo boröc tugoni socsoc alta worochon obu aroce idina agoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Angga soroc yongga toup botogoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Botongga idina sum yaruho inogoc, “Sekaraia, goc botirocha. Gocho managumbocha dönac yongitarocma wo wömai Kopotorocho kombing gamuna oweya Elisabet yu managumboc amnano baangoc. Bauna mano Jön ihoroc mambiruc. ");
INSERT INTO yuw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Yu wömai Morömaho yangamin ma moröma sogiangoc. O yu wain yamuc orin yamuc koingo au manaic. O yu abe macno modibin idina urop Kunkun Yaruho yudec foc tongga engoc. Worocha tongga gocho manama wo angmina irot ogep moröma kombingga borongdeangoroc. O ihorocgon owi amna koböcmaho manama worocha kombing borongdetnahing. ");
INSERT INTO yuw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Manama worocho tuna Israel nano koböcmaho irotno ibanda Kopotoroc Moröma noni yuhon uyap ogepma tannahing. ");
INSERT INTO yuw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kombihi, osuc wömai Kopotorochon Kunkun Yaruho Elaiyadec idina Elaiyaho toroc kiap gesönobarac itongidoc. Oro worochon torocgon wömai gakain manamaho itongmuna Moröma osuc fat imangoc. Tuna surarodec nandöngho irotno ibaruya managumbocniot irot tungu sinahing. O nongoru fodic fodic amna yu ihorocgon ibaru fauna kombic kombic ogepma sogida amna nongnongo itnahing. Boinno sinom, gakain manama wo yu Morömahon nongnongo suraro dongyun arangarang yuya Morömaha torengga itnahing.” ");
INSERT INTO yuw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Oro sum yaruho ihoroc yongbödeuna Sekaraiaho yu ingoroc inong ac togoc, “Nocot owenaot not urop basi deamotmai, worocha goc mata yarocma tingtingno sinom boinno öngkuun?” ");
INSERT INTO yuw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ihoroc yuna sum yaruho inogoc, “Noc mana Gebriel, nocu Kopotorocho yangamin itongitat. O Kopotoroc inoho ‘mata ngoroc gantiwa’ yongo nanong muuna epat. ");
INSERT INTO yuw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mata ngorocho wömai inoin bongonodec boinno öngkuangoc. Wohong gocu nochon mataha makombing tobing namorocmaha tongga gochon duca meptuna duc mata mayongga idia ongga mata ganotma worocho boinno öngkuangoc.” ");
INSERT INTO yuw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Oro sum yaruho Sakaraiaot mata ihoroc yongga idina böc taitdec suraroho Sekaraiaha torengga idung. Yu wömai kombic kombic youp morö tongga yogung, ‘Sakaria yu foro yaha sinom tong unim tongga sa ubarago Kopotorocho bucin itac yo.’ ");
INSERT INTO yuw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ihoroc kombingga idiya Sakaraia yu böc imun fauna taitdec ohogoc mahong duc mata yocyocno maidoc. Yu obu torocgon tongga idina owi amnaho wo angga kombigung, ‘Yapmu auho Kopotorochon böc irotnon woce öngkung imuna aac’. ");
INSERT INTO yuw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Oro Sekaraia yu duc matano muno youpno tongga idina ongga yuhon youp toctoc bongono bödeuna böcnon onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Oro mit wömai oweno Elisabet yu modip idoc. Modip itmuna yu böcno maimun fauna bucingon idina yarop 5 ihoroc bödegoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisabet yu yogoc, “Boinno sinom, Morömaho noc nang banauna toroc kiap ogepma sinom nocdec öngkupac. Worocha tongga nocho suraroho yangamin wönggon yangam fabfap matit,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Oro owi berac au mano Maria yu Nasaret taun Galili gurocin woce idoc. Yu wömai abe kunkun idoc mahong urop amna auhon fat sicsicyi idoc. Amna worochon mano Yösep, yu woi king Devit yuhon morogodecma. Oro Elisabet yu mana modip idina yarop 6 bödeuna bongono wocin Kopotorocho sum yaru mano Gebriel yu inong muuna owi Mariaot ohogoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yuot ohongga inogoc, “Sep ogep owi. Kopotorocho tong ogep tong gamongga guramno gocdec sicsicha tac.” ");
INSERT INTO yuw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariaho mata woroc kombingga soroc yongo kombigoc, ‘Mayain, mata ngoi tingting sinompha yac.’ ");
INSERT INTO yuw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ihoroc kombingga idina sum yaruho wönggon inogoc, “Maria goc botirocha! Kopotorocho gocha irot ogep kombihac. ");
INSERT INTO yuw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Goc onggim singga mata ngo kombihi. Goc modip ida managumboc amnano bangga mano ‘Yesu’ ihoroc mambiruc. ");
INSERT INTO yuw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yui amna moröma sinom engoc. Tuna owi amnaho yuha yonahing, ‘Yui Kopotoroc onoce sinom yuhon Manano’ ihoroc yonahing. Tuna Kopotorocho yu ombu sakungno Devit yuhon abamodec tohong yuna ma moröma sogiangoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Tongo yu Jeköphon toropni moröm tong imongo yuhon gesöno iditnoho iditno ida inoin toropni ogepgon yangtoreangoc.” ");
INSERT INTO yuw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariaho mata wo kombingga ingoroc inong ac togoc, “Kiap ngo wömai tingtingno sinom öngkuun? Nocu abe amna au matongsitmai, ting tongga managumboc au bacbacha nantaroc.” ");
INSERT INTO yuw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ihoroc yuna sum yaruho inogoc, “Kunkun Yaru yu gocot ehuna Kopotoroc kunkun sinom yuhon gesönoho goc tombengoc. Tuna gocho kunkun amna baangoroc. Amna worocha wömai mit owi amnaho ‘woi Kopotorochon Manano’ ihoroc inonahing. ");
INSERT INTO yuw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kombiharoc, gochon niba Elisabet, yuha wömai owi amnaho yongidung, ‘yu managumboc angit mabaic.’ Ihoroc yongidung mahong yu modip idina urop yarop 6 bödehac. Yu urop owi basi dedoc mahong yu modip ida managumboc amnano baangoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Boinno sinom, Kopotorocho yapmu au matoctocno woi maec. Muno sinom, yu ogep manomano ambarac boinno dongyun öngkuup.” ");
INSERT INTO yuw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Sum yaruho mata ihoroc yongbödeuna Mariaho inogoc, “Nocu Morömahon mongorec toctoc owigon. Gocho yarocma worochon torocgon nocdec öngkung nampun,” ihoroc yuna sum yaruho Maria imun fauna onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Oro bongono wocin Maria yu idongga ‘Elisabet awa’ yongo karupgon yuhon böcsanodec onggoc. Böcsa wo wömai Yudia provinshon sa urongo bonip woce idoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wocin ongga Sekaraiahon bucin öngga Elisabet ‘sep ogep’ inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ihoroc inuna Elisabetho Mariahon ‘sep ogepno’ woroc kombiuna wohogon managumboc Elisabethon modibon idocma worocho borongdeda mong sakagoc. Woroc tuna Kunkun Yaruho Elisabethon irot tun yungan tuna ");
INSERT INTO yuw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisa-betho mamboda Maria inogoc, “Kopotorocho goc gangbanango owi bonipnodec erangga guram moröma sinom sing gamogoc. Tongo gocho modiban managumboc itacma yu wömai Kopotorocho ihorocgon guram moröma sing imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Noc owi komanangno itat mahong nochon Morömanahon macnoho nocot epacmaha nocho toup borongdehat. ");
INSERT INTO yuw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kombiharoc! Goc ‘sep ogep’ yia kombiaya mana modibnan itacma worocho borongdeda mong sakahac. ");
INSERT INTO yuw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Osuc wömai Kopotorocho ‘managumboc baangoroc’ ganogoc. Tuna gocho ‘mata wo boinno öngkuangoc’ yongo kombing tobigoroc. Worocha wömai Kopotorocho guramno sing gampun,” Elisabetho guram mata ihoroc Maria inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Oro, Elisabetho mata ihoroc yongbödeuna Mariaho yong moröng ap ingoroc yogoc: “Noc irotnaho Morömaha yong moröng impat. ");
INSERT INTO yuw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","O yarunaho Kopotorocha kombing borong tac. Yu wömai noc wontucmunodecma öcangyun muuya itonggong koingna tun öngkung namogoc. O yuho tuna noc ogepma sinom iditat. ");
INSERT INTO yuw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nocu yuhon mongorec toctoc owi boyömo itat mahong yuho nocha kombingga nang banango tong ogep tong namogoc. Tuna owi amna önga idangmahu o mit itnahingmahu yu ‘nocha’ kombingga yonahing, ‘Kopotorocho noc guram moröma sinom sing namogoc’. ");
INSERT INTO yuw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Boinno sinom, Kopotorochon gesö woi moröma sinom. Yuho toroc kiap inobarac sinom noc tun öngkung namogoc. Yuhon mano kunkun sinom itun. ");
INSERT INTO yuw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kopotoroc yu owi amna ambarac yu gending imong-idangma yu yang banauna ogep ididang. Woi öngahu o mithu yu bongono muno yu tongfat yengitac. ");
INSERT INTO yuw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yuhon oburoho toroc kiap koingo tongitac. Amna au yu inoha kombingidang, ‘Non moröma sinom idamon yo’. Ihoroc kombingga inoha kombing borong tongidang mahong Kopotorocho amna ihorocno fogida fotingyun ongidang. ");
INSERT INTO yuw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kopotoroc yu amna önggöngyi gesönobarac ididangma wo fohong fiuna gesöno bödengitac. Wohong amna inoha kombiuya ohongitacma yu wömai Kopotorocho doun fadang öngidang. ");
INSERT INTO yuw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","O yuho owi amna nacnoha worec imuya ididangma yu nacno orin manomano ogepma imongitac. Wohong owi amna yoctec möneng manomanono koböcma idimangma yu wömai dong yaruna uroci itnahing. ");
INSERT INTO yuw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Kopotoroc yu ombu sakung noni Abraham orin yuhon morogoni ‘nocho son makangmurat tit’ yongo yong koing matano godingmun fat imogoc. Tongo yu worocha kombingga inoin toropni sinom Israel nano, yu ogepma sinom tongfat yengitac.” ");
INSERT INTO yuw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Oro Maria yu yong moröng apno ihoroc yongbödegoc. Tongo yu Elisabetot idina yarop anfihun bödeuna yu Elisabet imun fauna böcnon onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Oro urop Elisabethon managumboc bacbac bongono fom tuna mana amnano bagoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ihoroc tuna yuhon nipni natniho Elisabethon fatno ingoroc kombigung, ‘Kopotorocho nat noni angbanagoc’. Fatno wo kombingga yuha kombing borong morö togung. ");
INSERT INTO yuw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Elisabetho ");
INSERT INTO yuw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yu ihoroc kombigung mahong macnoho ‘muno’ yongga inogoc, “Muyu mano Jön ihoroc mambotna.” ");
INSERT INTO yuw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ihoroc inuna yuho angit makombingga inogung, “Gochon toropdec amna mano ngomai maec.” ");
INSERT INTO yuw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ihoroc yongga fano obu toroc tong imuya ehuna ingoroc inong ac togung, “Managumbochon mano numa mamben-taroc”. ");
INSERT INTO yuw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Inuya fanoho ‘irim toctoc tabe sogiwa’ yongo obu toroc tong imuna yu tabe au tengga imuya ‘mano Jön’ ihoroc irim togoc. Ihoroc tuna yu agungmai ‘ma fodibo sinom irim tac yo’. Tongo kombic kombic youp morö togung. ");
INSERT INTO yuw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tuna bongono wocingon Sekaraiahon dugo mata yocyochon yungan tuna yu forosingga Kopotorocha yong moröng imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Oro nip orugi yu toroc kiap wo angmuya nanga fatfat morö togung. Tuna worochon fatnoho Yudia gurocin sa urongodec ambarac ongbödeuna owi amnaho wo kombingga worochon matagon yong tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tongo yu ambaracho kombic kombic youp morö tongga yogung, “Mayain, Morömaho managumboc ngo toroc kiap inobarac sinom tong imogoc. Worocha yu mit amna moröma ida yaö youp sinom tangoc?” Ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Oro kiap ihoroc öngkuuna Kunkun Yaruho managumboc worochon fano Sekaraia yuhon irot tong yungan tuna yu Kopotorochon yong tuctuc mata au ingoroc yogoc, ");
INSERT INTO yuw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Yong moröng noni ambarac Kopotorocha imona. Yu woi Israel nanohon tongfat yecyec amna sinom. Yuho engmuna inoin owi amna ayamihon oburodecma asan imuna orung itnahing. ");
INSERT INTO yuw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kopotoroc yu youp wabkaracno Devit yuhon morogo tungu au tun fadang uuna guram gesö moröma imogoc. Tuna amna worocho wömai non wontucmunodecma angyun muuya itonggong koing tun öngkung nimuna batip itnahamon. ");
INSERT INTO yuw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kopotorocho osucgon yong tuctuc amna auho ducdec ingoroc yogoc: ");
INSERT INTO yuw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Amna wo yu wömai non tong batip tongga ayam nonihon oburodecma asan nimangoc. O yuho amna auho nontha kombing moin moin kombingidangma yuhon oburodecma non wönggon fogiangoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kopotoroc yu ombu sakung noni inoin banac banacno moröma indac indacha kombigoc. Tongo yu botup botup kunkun moröma sinom yuot togoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Boinno sinom, Kopotoroc yu öranoni Abraham osucgon yong koing matano kömbaha sinom godingmun fat imogoc. Tongo yu mata worocha maedet imic. ");
INSERT INTO yuw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Muno sinom, Kopotoroc yu non ayam noniho oburodecma ningat fonguna orung itnahamon. Orung itmanaina nonu tong botoc botoc noni muno Morömahon youpgon tongo itnahamon. ");
INSERT INTO yuw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tongo non yuhon kunkun owi amna nongnongo sinom itmanaina yuho yangam-in itnahamon. Woi öngahu o bongono muno, woi boinno.” Sekaraia yu yong tuctuc matano sakaun fiuna mananoha ingoroc yogoc, ");
INSERT INTO yuw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Nakain manana, goc mac fingga Moröma osuc fat imon-go uyapno tong arangarang tangoroc. Worocha tongga owi amnaho gocha yonahing, ‘Yu woi Kopotoroc onoce sinom yuhon yong tuctuc amna itac yo.’ ");
INSERT INTO yuw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kopotoroc yu inoin owi amnanihon turongono dongyun fauya itonggong koing imocimocha kombihac. Worocha tongga gocho Kopotorochon suraro batip idithon uyapno indaia tuctugo kombinahing. ");
INSERT INTO yuw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yuhon banac banacno woi moröma sinom. Worocha tongga momphon yagunoho nonot ohungoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ohongga non owi amna kumbongdec idamonma nontha yaguno möng nimongga obing idithon uyap nindauna kombingmanaina irot gucot itnahamon. Tongo non omompha wönggon mabotonin.” Sekaraia yu yong moröng ap ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Oro mit managumboc Jön yu macfingga godip föbo orin yaruno koing sogoc. Tongo yu ongga amna maiyan woce ididoc. Woce ida mit yu forosingga youpno Israel nanoho yangamin eran tongidoc. ");
INSERT INTO yuw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Oro bongono wocin Röm nanohon amna moröma Sisa King Ogastus yu ‘owi amnahon namba sogiwa’ yongo nongoru ingoroc sigoc: Röm nanohon gurocin böcsa danong owi amna ambaracho ongga mano gavmanthon ma toropdec irim tonung. ");
INSERT INTO yuw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Toroc kiap wo wömai fodibhagon forosingga togung. Woi gavmanthon moröma au mano Kwirinius, yu woroc Siria kantri yangtoregocan bongono wocin forosigung. ");
INSERT INTO yuw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Oro kiap worocha tongga owi amna ambarac ‘gavmantho ma noni bapiyadec fihun’ yongo inoin inoin böcsanodec ongbödegung. ");
INSERT INTO yuw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Oro amna au mano Yösep yu Nasaret taun Galili gurocin woce ididoc. Yösep yu woi king Devithon morogono. Foro worocha tongga yu ‘mana bapiyadec siwa’ yongo Nasaret imun fauna Devithon böcsa Yudia gurocin woce onggoc. Böcsa worochon mano Betlehem. ");
INSERT INTO yuw_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Bongono wocin wömai owi berac Maria yu abe inoin oweno sinom maidoc. Muno yu komong inoin fat yuya idoc mahong yu urop mana modip idoc. Tuna Yösep yu ‘gavmantho ma noti fihun’ yongo oweno Mariaot Betlehem böcsa onggomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ongga woce ongkungga idinya Mariahon managumboc bacbac bongono eng fomtogoc. ");
INSERT INTO yuw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tuna yu kuin böc auha yabigomoroc mahong kuin böc foc tongo idocmaha yuhon bego au maöngkuboc. Tuna yu ongga bot bulmakauho bucin idmunya Mariaho managumboc amnano gatono woce bagoc. Bango boruho tomboto singga bot bulmakauho nacno nocnoc wagadec wocin siuna idoc. ");
INSERT INTO yuw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Oro kumbong dingina bot sipsip yangtorec amna au yu böcsa sumonne ida bot sipsip yangtorengo idung. ");
INSERT INTO yuw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Woce idiya karupgon Morömahon sum yaru tungu yuot wocin ohuna Morömahon yagunoho yang arenggumbec tongo yaguno muuna amna wo yu toup botogung. ");
INSERT INTO yuw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Botongga idiya sum yaruho inogoc, “Son botoninga! Nocho fatmata ogepma sinom kanoya borongdearut. Fatmata ogepma wo woi owi amna ambarac tongfat yecyechon. ");
INSERT INTO yuw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Önga kumbong ngo king Devithon böcsadec wömai owi auho managumboc bahac. Managumboc wo wömai Kopotorocho sontha yongo sigoc. Yuho wömai son wontucmunodecma öcangyun muuya ogep itnahing. Yu woi Moröma soni, Duic. ");
INSERT INTO yuw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Son woce ongga toroc kiap ingoroc aantang: Managumboc wo yu boruho tomboto bot bulmakauho nacno nocnochon wagadec siuna itac. Son woroc angga kombiantang, nocho managumbocha kanotma woi woroc.” ");
INSERT INTO yuw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Oro Kopotorochon sum yaruho yongburocno ihoroc inongbödeuna wohogon Kopotorochon sum yaruni koböcma sinompho momdecma ohongga yaru nucno ot sakau fiuna Kopotorocha yong moröng imongga ap ingoroc yogung: ");
INSERT INTO yuw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Yong moröng noni ambarac Kopotorochagon yong moröng imona. Yu woi onoce sinom itac. Owi amna ambarac ‘Kopotorocho tongfat nehun’ yongo kombiangma yu irot gucot itongitnung.” ");
INSERT INTO yuw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sum yaruho yong moröng ap ihoroc yongga ibaru fauna wönggon momdec ögung. Ihoroc tuya yangga bot sipsip yangtorec torec amna yu inohogon mata inun ganun tongga yogung, “Non karupgon Betlehem ongmanaina Morömaho ninongburoc tocma yapmu moröma wo ana.” ");
INSERT INTO yuw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ihoroc yongo karupgon woce ongga yagungmai, Maria orin Yösep yu wocin idinya managumbocno bot bulmakauhon nacno nocnoc wagadec dungo idoc. ");
INSERT INTO yuw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tuna bot sipsip yangtorec torec amna yu kiapmo wo angmuya sum yaruho managumbocha yongburoc mata inogocma fat wo owi amna woce suran togungma inogung. ");
INSERT INTO yuw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Inuya yu fat wo kombingga nanga fatfat morö togung. ");
INSERT INTO yuw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tuna Maria yu toroc kiap öngkubocma wo angga kombigoc, ‘woi yapmu moröma sinom’. Tongo manomano wo inoin irodin kombiun koing suna idoc. ");
INSERT INTO yuw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tuna bot sipsip yangtorec torec amna yu sa wo imu fauna inoin sanon onggonga manomano yagungmaha uyapdec Kopotoroc yong kumeng imong tonggung. O manomano yagungma wo wömai sum yaruho yongburoc inogocma worochon toroc sinom öngkuboc. ");
INSERT INTO yuw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Oro, Yesuho öngkuuna sep bongono 8dec managumbochon godibo macmac bongono idoc. Tuna yu mano Yesu woroc mambodung. Ma wo wömai osuc Maria abe mana modip maidocan bongono wocin sum yaruho urop inongdegocma woroc. ");
INSERT INTO yuw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Oro, Mösehon nongoruho managumboc bacbacha ingoroc yac: Owi au managumboc bang imonggai wömai yu Kopotorocho yangamin betni entac. Betni idina sep bongono 40 bödeuna owi wo yu muyu ongga öret socsoc youp tongga Kopotorocho yangamin wönggon sacsago entac. Mösehon nongoruho ihoroc itac. Oro Mariahon tong sac toctochon bongono wo bödeuna macnin fanintho ‘managumboc noti Morömahon fat itun’ yongo yangaunya Yerusalem öret socsoc bucin yangato tonggomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Wömai yaha, Kopotorochon nongoru mataho ingoroc yac: ‘Managumboc borongoma amnano wömai Kopotorocha bogingitnung.’ ");
INSERT INTO yuw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Oro nongoru mata auho wömai ingoroc yac: ‘Morömahon ececnoha wömai yup kanaröm yaihu o yup itogoring beracno yaihu woroc wömai Kopotorochon öretnoha songitnung.’ Worocha tongga macnin fanintho manano sogida Kopotorochon öretno socsocha Yerusalem onggomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Oro bongono wocin amna au mano Simeön yu Yerusalem wocin ididoc. Amna wo yu Kopotorocho yangamin nongnongo ida nongoru matano sumbotgon tongo itongidoc. Tuna Kopotorochon Kunkun Yaruho yuhon irotno foc tongga idoc. Foc tongga idina Simeön yu boinno sinom kombigoc, Kopotorocho urop Israel nanohon Tongfat Yecyec Amna siuna ehangoc. Ihoroc kombingmuna bongono muno amna worocha torengga ididoc. ");
INSERT INTO yuw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kunkun Yaruho wömai yu osucgon yong tuctuc mata ingoroc inogoc, “Gocu karupgon mamiroc. Muno, gocu Morömahon Tongfat Yecyec Amna Duic, yu angdengga mit wömai omengoroc,” Kunkun Yaruho ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tongo mit yu Simeönthon irotnon tun fadaunto inong muuna yu öret socsoc bucin ögoc. Öngga yagocmai, macnin fanintho nongoru mata tantantha Yesu yangada öret socsoc bucin tögomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Yangat tongunya Simeöntho managumboc wo sogito bac imongga Kopotoroc yong moröng imongo ingoroc yogoc, ");
INSERT INTO yuw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","“Öö Moröm Kopotoroc, goc gakain kombic kombicgon tanitaroc. Gocho mataho godingmi fadocma worocho önga nocho yangamin boinno öngkupac. Amna ngo wömai gocho ‘yu owi amnayai wömundecma öcangyun möarut’ yongo tong arangarang tongo sigoroc. Tuna nocho yu ngo angga borongdehat. Gocho tia guroc owi amna ambaracho yangamin yaguno au öngkuboc. Yu wömai Israel nano, gochon torop, yuhon tong fatfatno ogep-ma sinom engoc. Öö Moröma, noc woroc angmaina toup borongdehat. Tongo noc irot gucot omengot. Noc gochon youp amnaya.” ");
INSERT INTO yuw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeön yu Yesuha yong tuctuc mata ihoroc yuna Yesuhon macnin fanintho wo kombingga kombic kombic youp morö togomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Woroc tongo Simeöntho Yesu managumboc guram sing imongga macno Maria yong tuctuc mata ingoroc inogoc, “Kombiharoc, managumboc ngorochon foro woi ingoroc: Yuho tuna Israel nano koböcma sinompho mönahing. O Kopotorocho yu temongmun uuna Israel nanohon weran engoc. Tuna owi amna koböcmaho yu angga ayam tong imonahing. Wohong auho wömai yuha borongdeda koing songga ogepgon itnahing. ");
INSERT INTO yuw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","O yuho tuna owi amna koböcmahon irot kombic kombicnoho eran öngkung tangtang tonahing. Maria, gochon manama ngo yu mepmo moröma sinom aun feuna gocho wo angmina yuha kombingbanac moröma sinom tangoroc. Kombingbanac worocho wömai gun simbang gochon iroda sakang gamangoc,” Simeön yu Maria yong tuctuc mata ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Oro Kopotorochon yong tuctuc owi au mano Ana, yu ihorocgon wocin idoc. Yu woi Fanuel weno Asahon morogodecma. Osuc wömai yu opno tong siuna biruc bongono 7 ihoroc opno ot idomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ihoroc itmunya mit wömai opnoho omong fauna Ana yu bongono ubarago ino tungugon idoc. Yu woi owi basi sinom, birucno 84 ihoroc idoc. Yu wömai öret socsoc böc maimun fadidoc. Muno yu wocingon ida kumbonghu o apmanohu bongono muno Kopotorocha yong moröng youp tongidoc. Tongo yu nacnoha gendic iti dönac youp toi, kiap ihorocnogon tongo ididoc. ");
INSERT INTO yuw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Oro owi wo yu ihorocgon Yesu yomot macni fani yangmuna Kopotorocha ecec inongga engga managumboc worochon yong tuctuc matano owi amna fandat inogoc. Inuna owi amna ‘Kopotorocho engga Yerusalem ayam nonihon obudec sogiangoc’ yongo kombingidungma yu wömai Anahon matano wo kombingga borongdedung. ");
INSERT INTO yuw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Oro manomano ihoroc öngkuya mit Maria orin Yösep yu Morömahon nongoru mata tanda öret socsoc youpno tu bödeuna Yerusalem taun imu fauna Galili gurocin onggung. Tongo yu inoin böcsanon sinom Nasaret, wocegon ididung. ");
INSERT INTO yuw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Oro woce itmuya managumboc macfingo koing sogoc. Tuna Kopotorocho yu kombing imongo guramno yudec sing imuna momphon kombic kombic ino yabitno yudec idoc. ");
INSERT INTO yuw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yesuhon macnin fanin yu biruc danong bongono morö mano Pasowa woroc acacha Yerusalem öngidung. ");
INSERT INTO yuw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Oro oipmon Yesu yu urop biruc bongo 12 ihoroc idina macni fani yu inoin toroc kiap tanto bongono morö acacha Yesu yangada Yerusalem woce önggung. ");
INSERT INTO yuw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Öngga idiya bongono morö bödeuna yu wönggon ibaru fauna böcnon onggonga kombigomoroc mahong manano Yesu yu inohogon Yerusalem idina macnin fanin yu mananoha makombii inogon onggomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yu wömai ‘mana noti nip orugiot itac’ yongo uyapdec ongidinya sep youp toctoc tungu bödegoc. Bödeuna macnin fanin yu forosingga owi amna nucniho bonip Yesuha yabigung. Yabiu matuna soroc yongga ");
INSERT INTO yuw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","wönggon ibaru fauna Yerusalem ongga woce Yesuha yabing tonggomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yabing tongga tongga idinya urop sep youp toctoc yai bödeuna sep youp toctoc anfi idina yu manano öret socsoc bucin agomoroc. Yesu yu nongoru gendic fandat fandat amnahon bonipnon omoc ida amna morömahon mataha onggim singga orin yuot manomanoha mata inun ganun togoc. ");
INSERT INTO yuw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ihoroc tongga idina owi amna ambaracho yuhon mata uragoha orin yuhon kombic kombicnoha nanga fatfat morö togung. ");
INSERT INTO yuw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tuna macnin fanintho woroc angga soroc yongmunya macnoho inogoc, “Manana goc yaöha ihoroc tong nimparoc? Nocot nandöngaot not gocha irot nodi foc nimuna gocha yabic yabic youp morö sinom tamot.” ");
INSERT INTO yuw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ihoroc yuna Yesuho inogoc, “Sodu yaha nocha sa woce woce yabiamoroc? Nandöngnahon böc woi ngoroc. Worocha nocu ngocin itiwa yo. Sodu wo makombimorochu nuhun.” ");
INSERT INTO yuw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yesuho macnin fanin mata ihoroc inogoc mahong yu worochon foro tuctugo makombigomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Oro mit yomot macni faniho ambarac ongga Nasaret idung. Tongo yu woce itmuya Yesuho macnin faninthon duc sumbotgon togoc. Macno yu manomano öngkubungma wo ambarac kombingo sogitho irotgon togoc. ");
INSERT INTO yuw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu yu macfingga kombic kombicno ogepma sinom idoc. Tongo yu Kopotorocho yangamin orin owi amnaho yangamin amna ogepma sinom idina ambaracho yuha toup kombingidung. ");
INSERT INTO yuw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Oro, amna moröma Taiberius yu biruc bongono 15 ihoroc Römphon Sisa King itmuna Röm nano yangtorengidoc. Bongono wocin wömai yuhon youp amnani Israel kantrihon provins yangtorengidung. Youp amnanihon ma torop woi ingoroc: Amna moröma Pontius Pailat yu Yudia provinshon namba wan gavman abam sogida idoc. O amna moröma Heröt yu Galili provins angtorengo idoc. O orugo Filip yu wömai Ituria orin Trakonitis provins yangtorengidoc. O amna moröma Lisanias yu wömai Abilene provins angtorengidoc. ");
INSERT INTO yuw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","O amna yai Anas orin Kaiafas yu öret socsoc böchon namba wan abam sogidomoroc. Oro bongono wocin wömai Sekaraiahon manano Jön yu sa amna maiyan wocegon idina Kopotorochon mataho yuot engga inong mudoc. ");
INSERT INTO yuw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Inong muuna Jön yu forosingga guroc Yodan yamuc tan itacma woce itongmuna owi amna Kopotorochon mata fandat inongo yogoc, “Son muyu turongo soni yangmuya uroci kombingga irot soni ibararut. Ibaruya nocho son yamuc gung kamoya Kopotorocho turongo soni dongyun fatnahing.” Jöntho owi amna ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Oro Jön kiapmo wo togocma worochon fatno wömai osuc sinom Kopotorochon yong tuctuc amna Aisaia yuho irim tongo ingoroc yogoc: “Sa moröpmodec amna auhon mambocno ingoroc öngkupac: ‘Morömahon youp tong arangarang tongga yuhon uyapno tobiarut.’ ");
INSERT INTO yuw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kungo kango ngo guroc ohetho foctongo tong suruc tarut. O uyap gendöngni tong nongnong tongo, uyap wöntuc-muno tong ogep tarut. ");
INSERT INTO yuw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tongo guroc owi amna ambaracho ‘Kopotorocho tingtingno sinom yu wontucmunodecma öcangyun muuya batip itnahing’, worochon foro anahing.’” ");
INSERT INTO yuw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ihoroc inuna owi amna koböcma sinompho ‘Jöntho yamuc gung nimpun’ yongo yuot ebung. Yuot ehuya Jöntho ingoroc inogoc, “Son goröm wontucmunohon morogoni! Kopotorocho turongo soniha ecego moröma kombihac. Worocha tongga sontho ‘yu urago nimicyit’ yongo botongga komanang sinom yamuc gupgupha yang yo. ");
INSERT INTO yuw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Son muyu wontucmuno soni imu fauna irot soni ibanda boinno ogepma fiarut. Son ingoroc kombininga, ‘Non Abrahamphon morogo idamonmaha tongga Kopotorocho nontha irot ogep kombihac.’ Muno sinom, nocho ingoroc kantiwa, Kopotoroc yu ogep yuna sop ngorocho Abrahamphon morogoni baun. ");
INSERT INTO yuw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mata tepmo au sontha ingo itac: Kopotorochon duricho urop ep foro faicfaicha tong arangarang tongga itac. Ep auho boinno ogepma mafiicanu wömai duriho yu faingyun muuya epho dinahing.” ");
INSERT INTO yuw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jöntho mata koingo ihoroc owi amna inuna kombingga toup soroc yogung. Soroc yongga inong ac tongga yogung, “O nonu ting tonaya Kopotorocho urago manimic?” ");
INSERT INTO yuw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ihoroc inuya Jöntho inogoc, “Amna au tec tohomumöcno yai idimpacma yu muyu nucno tecno maidimocma yuot silip tongga tungu au yu impun. O amna au nacno koböc idimpacma yu ihorocgon nucno nacno möp itacma yu nacnoha tongfat yehun.” ");
INSERT INTO yuw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jöntho mata ihoroc inuna takis fogit fogit amna au yu ihorocgon ‘Jöntho yamuc gung nimpun’ yongo engmuya inong ac tongga yogung, “Fandat fandat amna nonu ting tona oro?” ");
INSERT INTO yuw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ihoroc yuya Jöntho yu inogoc, “Son gavmantho kanocma worochon torocgon takis möneng fogiditnung. Son möneng au soniin irotha sakau fiuna fogiditninga.” ");
INSERT INTO yuw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Jöntho ihoroc inuna tawa amna auho yuot engmuya inong ac tongga yogung, “Oro nonu ting tongitnahamon?” Ihoroc yuya Jöntho yu inogoc, “Son amna dongyu obökuya mönengno usem fogitninga. O ihorocgon mata youpdec mata imanang firing tanitninga. Muno son muyu möneng gavmantho wöngnac soniha kamongitacma worocgon sogida möneng auha yang ibip toninga.” ");
INSERT INTO yuw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Oro, Jön yu yong tuctuc mata ihoroc owi amna inongidoc. Tuna owi amnaho woroc kombingga yogung, ‘Kopotorocho urop yapmu moröma tun öngkuangoc yo’. Tongo yu Jöntha kombigung, ‘Amna Jön yu woi Duichu nuhun? Kopotorocho guroc owi amna inoha fogit fogitha yogocma worochu nuhun.’ ");
INSERT INTO yuw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ihoroc yuya Jöntho yu mata ingoroc iban imogoc, “Nocu amna komanangno worocha wömai nocho yamucgon gung kamongitat mahong mit wömai amna moröma ehangoc. Yuhon gesöho wömai nochon gesöna anggirahac. Nocho yuhon mene darange matoctocno, nocu amna wontucmuno yui amna gendicma morö. O nocho youp tongitatma woi yamucdecgon tongitat mahong amna mit ehangocma yu wömai owi amna yangsoworengga Kunkun Yaruhon kiapdechu o ep aranggumno ot gung imangoc. ");
INSERT INTO yuw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Amna moröma wo yu owi amna tong erac eracha ehangoc. Nonu wömai nacno noni ‘ogep idangha woha moinno idang’ yongo yangsoworengidamon. Oro worochon toroc wömai yuho non ning soworeangoc. O yu urop youp toctocha tong arangarang tongga itac. Nacno ogepma wömai yu ino bucin fong suran tangoc mahong nacno moinnoma wömai ogutho ep koingodec sangoc. Ep aranggum wo wömai amna auho tu omomno muno, iditnoho engoc.” ");
INSERT INTO yuw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jön yu mata tepmo ihorocno koböcma sinom owi amna inongga yuhon irot sakangga fatmata ogepma inongidoc. ");
INSERT INTO yuw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Oro Jön yu owi amna komanangno mata ihoroc inongidoc. O mit wömai yu ihorocgon amna moröma Heröt yu inong fadoc. Heröt yu namba wan gavman morö ida toroc kiap wontucmuno koböcma tongidoc. Turongono au wömai yu ingoroc togoc. Yu domino Herödias yu tong sigoc. Yu woi Heröt orugohon oweno. Woroc togocmaha Jöntho Heröt nongoru mata koingo inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ihoroc inogocmaha Herötho ec imuna Jön yi bucin tohong yugoc. Oro Heröt kiap wo togocma woi wontucmuno sinom. Tongga turongo au yudec sakaun figoc. ");
INSERT INTO yuw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Oro Jön abe yi bucin maidocan bongono wocin owi amna koböcmaho ‘Jön yamuc gung nimpun’ yongo yuot ongidung. Tuya Yesu yu ihorocgon yamuc gupgupha Jönot onguna Jöntho yu yamuc gung imogoc. Tuna Yesuho dönac yongga idina mom fagariuna ");
INSERT INTO yuw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kunkun Yaru kanaröm ganto yudec ohogoc. Ohuna momdecma inggun au öngkungga ingoroc yogoc, “Goc nakain manana batip sinom. Noc gocha toup kombingitat. Nocho goc erangga irotnaho gocha kömehat,” inggun ihoroc öngkungga yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Oro Yesu yu birucno 30 worochon toroc idocan bongono wocin wömai yu youpno sinom forosigoc. Suraroho wömai Yesuha ingoroc kombigung: Yesu yu Yösephon manano, Yösep yu Helihon ");
INSERT INTO yuw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli yu Matathon, Matat yu Livaihon, Livai yu Melkihon, Melki yu Janaihon, Janai yu Yösephon manano, ");
INSERT INTO yuw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yösep yu Matatiashon, Matatias yu Amoshon, Amos yu Nahumphon, Nahum yu Eslihon, Esli yu Nagaihon manano, ");
INSERT INTO yuw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai yu Mathon, Mat yu Matatiashon, Matatias yu Sementhon, Semen yu Jösekhon, Jösek yu Jödahon manano, ");
INSERT INTO yuw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jöda yu Joanamphon, Joanam yu Resahon, Resa yu Serubabelhon, Serubabel yu Sealtielhon, Sealtiel yu Nerihon manano, ");
INSERT INTO yuw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri yu Melkihon, Melki yu Adihon, Adi yu Kosamphon, Kosam yu Elmadamphon, Elmadam yu Erhon manano, ");
INSERT INTO yuw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er yu Josuahon, Josua yu Elieserhon, Elieser yu Jorimphon, Jorim yu Matathon, Matat yu Livaihon manano, ");
INSERT INTO yuw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai yu Simeönthon, Simeön yu Yudahon, Yuda yu Yösephon, Yösep yu Jonamphon, Jonam yu Eliakimphon, ");
INSERT INTO yuw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim yu Meleahon, Melea yu Menahon, Mena yu Matatahon, Matata yu Natanthon, Natan yu Devithon manano, ");
INSERT INTO yuw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit yu Jesihon, Jesi yu Obethon, Obet yu Boashon, Boas yu Salmonthon, Salmon yu Nasönthon manano, ");
INSERT INTO yuw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasön yu Aminadaphon, Aminadap yu Atminthon, Atmin yu Arnihon, Arni yu Hesrönthon, Hesrön yu Pereshon, Peres yu Yudahon manano, ");
INSERT INTO yuw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda yu Jeköphon, Jeköp yu Aisakhon, Aisak yu Abrahamphon, Abraham yu Terahon, Tera yu Nahorhon manano, ");
INSERT INTO yuw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor yu Serukhon, Seruk yu Reuhon, Reu yu Perekhon, Perek yu Eberhon, Eber yu Selahon manano, ");
INSERT INTO yuw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela yu Kainanthon, Kainan yu Arpaksathon, Arpaksat yu Siemphon, Siem yu Nöahon, Nöa yu Lamekhon manano, ");
INSERT INTO yuw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek yu Metuselahon, Metusela yu Enokhon, Enok yu Jarethon, Jaret yu Mahalalelhon, Mahalalel yu Kenathon, ");
INSERT INTO yuw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan yu Enoshon, Enos yu Sethon, Set yu Adamphon, o Adam yu Kopotorochon manano. ");
INSERT INTO yuw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Oro, Kunkun Yaruho Yesuho irodin foc tongga idina Yesu yu Yödan yamuc imun fauna Kunkun Yaruho yu yangato sa amna maiyan woce tonggoc. ");
INSERT INTO yuw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tuna Yesu yu sep youp toctoc 40 ihoroc wocegon idina dogu kopotho yu tonguc yecgon tong tonggoc. Bongono wocin wömai Yesuho nacno tungu au manongga idina bongono wo bödeuna worec imogung. ");
INSERT INTO yuw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Worec imuna dogu kopotho yuot engmuna inogoc, “Goc boinno Kopotorochon Manano itarocanu yia sop ngorocho nacno garun.” ");
INSERT INTO yuw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesuho mata woroc kombingga mata urago ingoroc iban imogoc, “Kopotorochon bapiyadecu mata ingoroc irim toctocyi itac: ‘Nacnohagon tongga owi amnaho itonggong boinno maun feic.’” ");
INSERT INTO yuw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ihoroc yuna mit dogu kopotho Yesu sa urongo auhon yangato tögoc. Sa wocin itmunya dogu kopotho yu sa gurochon kantri ambarac tong indagoc. ");
INSERT INTO yuw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tong indangga yu Yesu ingoroc inogoc, “Kantri worochon yoctecno mönengno ambarac wömai nocho gamoya goc amna moröma sinom engoroc. Manomano ambarac ngo woi nochon fat itbödeang. Worocha nocho amna au imimpha kombinggai, noc ogep yu imam. ");
INSERT INTO yuw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Gocho goruc yemoc tong namongga yong moröng namontarocanu wömai nocho manomano yaarocma wo ambarac gocha boging gamontat.” ");
INSERT INTO yuw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ihoroc inuna Yesuho mata okene ingoroc inogoc, “Kopotorochon bapiyadec mata ingo irim toctocyi itac: ‘Goc muyu Morömaya Kopotoroc yuhagon yong moröng imongga o yuhon matagon sumboda itongidiruc.’” ");
INSERT INTO yuw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ihoroc yuna mit dogu kopotho Yesu yangada Kopotorochon kunkun taun Yerusalem woce öret socsoc böc koroc onoce sinom itacma woce töngga ingoroc inogoc, “Goc boinno Kopotorochon Manano itarocanu ngocin ida bangmi muhun. ");
INSERT INTO yuw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Wömai yaha Kopotorochon bapiyadec mata ingoroc irim toctocyi itac: ‘Kopotorocho sum yaruni inuna yuho ogepma sinom gangtoreantang. ");
INSERT INTO yuw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tongo yuho goc obura sogito tohong guuya sopho orunga gotgotno maic.’” ");
INSERT INTO yuw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ihoroc yuna Yesuho mata urago ingoroc inogoc, “Kopotorochon bapiyadec wömai mata au ingoroc irim toctocyi itac: ‘Gocho Kopotoroc Morömaya ‘yu mata boinno yachu munohu’ yongo tonguc yeirocha.’” ");
INSERT INTO yuw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Oro, dogu kopot yu Yesu yapmu ihono ihonoha tonguc yeng imongbödengga yu imun fauna ongga ‘oipmonu bongono auho wönggon tonguc yeangat’ yongo Yesuha gön tongga idoc. ");
INSERT INTO yuw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu yu sa amna maiyan imun fauna Kunkun Yaruhon gesö yudec foc tongga idina yu Galili provins onggoc. Tuna yuhon fatno urop böcsa danong ongbödeuna owi amna ambarac kombingbödegung. ");
INSERT INTO yuw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tuna Yesu yu Galili gurocin itongmuna Yuda nanohon fatmata yocyoc bucin fatmata ogepma suraro yong silip tong imong tonggoc. Ihoroc tuna owi amnaho yuhon matano kombingga borongdetmuya yuhon fat morö yong tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Oro Yesu yu Galili gurocin itongmuna Nasaret taun woce onggoc. Yesu managumboc idocan bongono wocin wömai yu taun wocin ito macfigoc. Oro woce ongga itmuna Sabat bongonodec yu inoin toroc kiap tando Yuda nanohon fatmata yocyoc bucin öngga idoc. Tongo yu Kopotorochon fatmata embat embatha idongga idina ");
INSERT INTO yuw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","amna auho yu Kopotorochon yong tuctuc amna Aisaiahon bapiya imuna yu bapiya öcangga irimno angga ingoroc embadoc: ");
INSERT INTO yuw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Morömaho noc youpha soworeng namongo Kunkun Yaru nocdec korigoc. Worocha tongga nocho owi amna uro-ci fatmata ogepma intiwa. Morömaho noc nanong muuna nocho yongburoc ingoroc kantiwa: Son owi amna dogu kopothon yidec idangma son orung itnahing. O son dan tomnima sonu wönggon dan foric tonahing. O önga amna auho son dou obukongidang mahong toroc kiap wo wömai urop bödeuna ogepgon itnahing. ");
INSERT INTO yuw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kopotorocho inoin owi amnani tong batip tong imuna ogep idithon bongono wo urop eng fomtac. Fatmata ogepma woroc yocyocha wömai Kopotorocho noc nanong muuna epat.” ");
INSERT INTO yuw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu yu mata wo embat bödengga bapiya akep tongga amna wönggon imongga omoc idoc. Woroc tuna owi amna fatmata yocyoc bucin idungma ambaracho ‘Yesu yaö mata sinom yontac’ yongo yu among fihic togung. ");
INSERT INTO yuw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Among fihic tongga idiya Yesu yu forosingga mata ingoroc inogoc, “Noc mata ngo embaatma worocho önga sontho yangamin boinno öngkungga itac,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Oro owi amna ambarac yu Yesuhon matano yamugoni kombingga yuha borongdedung. Wohong Yesuho mata fodibo sinom yogocmaha tongga suraroho kombic kombic youp morö tongga yogung, “Amna wo yui Yösephon manano. Worochai tingtinga mata ihorocnoma ogepma sinom yac yo?” ");
INSERT INTO yuw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesuho suraro ingoroc inogoc, “Kombiarut, nocho Kaperneam böcsa woce toroc kiap inobarac sinom togot. Worocha son ingoroc noc nanontanghu: Goc urop Kaperneam woce youp morö tiia fatno kombigomon oro. Worocha önga gakain böc moröin tia ana.’ Worochon mata tagaro au ingoroc itac: ‘Dokta goc muyu gakain godiba ti orokoun.’” ");
INSERT INTO yuw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu ihoroc yongga matano sakaun fiuna wönggon yogoc, “Nocho boinno sinom kantiwa, Kopotorochon yong tuctuc amna au yu inoin bucinmaho oröc ogep matong imongidang. ");
INSERT INTO yuw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Sonu Elaiyahon fatno urop kombiang. Elaiya idocan bongono wocin wömai sepho morö sinom foringga biruc anfi yarop 6 ihoroc bödeuna guroc danong nacnoha möp morö öngkuboc. Oro bongono wocin wömai Israel gurocin owi kapi koböc idung mahong ");
INSERT INTO yuw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kopotorocho ‘Israel owi au tongfat yewa’ yongo makombigoc. Muno, yu Elaiya inong muuna yu bumbumyi nanohon böcsa au mano Serafat woce korungon onggoc. Böc wo wömai Saidon gurocin idoc. Elaiya yu woce ongmuna bumbumyi nanohon owi kapi au tongfat yegoc. ");
INSERT INTO yuw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“O ihorocgon, son Kopotorochon yong tuctuc amna Elisa yuhon fatno urop kombiang. Yuho idocan bongono wocin wömai Israel gurocin amna obukoc lepra toctocyi koböcma ididung. Wohong yuho bonipnodec wömai amna au maorokogoc. Muno, amna tungugon wömai orokogoc. O yu woi Israel amna muno, yu bumbumyi nanohon kantri Siriadecma mano Naeman.” ");
INSERT INTO yuw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yesuho mata koingo ihoroc yuna owi amna fatmata yocyoc bucin idungma yu ambaracho mata woroc kombingga irotno doun fadang uuya ec imuna mata kararat yogung. ");
INSERT INTO yuw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ihoroc tongo idongga Yesu taruya böcsa sumonne onggoc. Böcsa wo wömai sa urongo audec idoc. Worocha yuho Yesu sogit akep tongga sa bohöng wocin körengmu möcmöcha yangat tögung. ");
INSERT INTO yuw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Wohong Yesu yu ibarun fauna yuhon bonipnodec kondong tongga dongyun fauya gorong onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Oro Yesu yu Nasaret taun imun fauna ohongga urop Kaperneam böcsadec ongkuboc. Böcsa woi Galili provinsdec idoc. Yu woce itmuna Sabat bongonodec fatmata ogepma owi amna fandat inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yu fatmata yogocma woi komong muno, gesönobaracgon yongidoc. Worocha tongga suraroho matano kombingga nanga fatfat togung. ");
INSERT INTO yuw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ihoroc tuya fatmata yocyoc böc wocin amna auho idoc. Yudec wömai dogu boyömo au itmuna ecnang sinom mamboda yogoc, ");
INSERT INTO yuw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yaiöö Yesu Nasaretma nocot nucnaiot non kombiamon, goc Kopotorochon Kunkun Amna itaroc. Goc yaö sinom tong nimnimpha eparoc? Gocho non dongyi obukoc obukocha eparochu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Dogu boyömo ihoroc yuna Yesuho yu inong fato yogoc, “Goc öpgon iti! Amna wo imi fahun!” Ihoroc inuna dogu boyömpho suraroho yangamin amna wo korengmun ongga gurocdec omong möc tongga idina doguho imun fauna onggoc. Onggocma woi komanang, amna wo matun obukogoc. ");
INSERT INTO yuw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ihoroc tuna owi amna woroc angga soroc yongga inohogon inun ganun tongga yogung, “Mayain, Yesuhon kombic kombicno ngoi yaö sinom? Yuho mata gesöbarac Kopotorochon madec yuna dogu boyömpho matano sumboda amna dongyu fauya ongidang.” ");
INSERT INTO yuw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Suraroho ihoroc yuya mit Yesuhon fatno morömaho guroc worochon böcsa danong ongbödeuna owi amna ambaracho kombigung. ");
INSERT INTO yuw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Oro Yesu yu idongga fatmata yocyoc böc wo imun fauna ongga Pitaho bucin ögoc. Öngga agocmai Saimon körano yu godip mönmön toup togoc. Ihoroc tuna owi amnaho ‘Yesu yu tun orokotun’ yongo inong ac togung. ");
INSERT INTO yuw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Inong ac tuya Yesuho körano tan ongga kotung möngga obukoc inong fauna obukocho owi wo imun fadoc. Tuna wohogon owi wo idongga nacno tong arangarang tongga mongorec tong imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Oro urop sep daro ohoc ohocha tuna owi amnaho nip orugi obukoc focfocdec idungma yu dong yangato Yesuot febung. Fehuya Yesuho oburo yu ambaracdec fingo dongyun orokogung. ");
INSERT INTO yuw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ihoroc tuna dogu boyömo koböcma owi amnadec idungma yu owi amna dongyu fauya ecnang mamboda yogung, “Gocu Kopotorochon Manano!” Ihoroc yogung. Dogu boyömo yu wömai Yesuha kombigung, Kopotorocho yu owi amnani fogit fogitha inong muuna eboc. Dogu boyömo ihoroc kombigungmaha tongga Yesuho yu ‘muno’ inogoc, ‘sonu nochon foro wönggon yoninga’. ");
INSERT INTO yuw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Oro sa isuna Yesu yu böcsa wo imun fauna sa amna maiyan woce onggoc. Ongga idina owi amnaho ‘Yesuho non dongyun fatningyit’ yongo yu tan tongga inogung, “Goc sa auhon ongirocha.” ");
INSERT INTO yuw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ihoroc inuya Yesuho yogoc, “Kombiarut, Kopotorocho ‘goc nochon toborucnohon fatmata ogepma owi amna ambarac iniruc’ yongo noc nanong muuna ebot. Worocha tongga noc muyu ongmanaina fatmata wo böcsa auhon ihorocgon yong silip tong imangot.” ");
INSERT INTO yuw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ihoroc inongga sa wo imun fauna Yudia provinsdec itongmuna Yuda nanohon fatmata yocyoc bucin Kopotorochon fatmata surarodec yong fandat inong tonggoc. ");
INSERT INTO yuw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Oro bongono auho Yesu yu Genesaret yamuc öngkoring tero woce idina owi amna koböcmaho Kopotorochon fatmata kombic kombicha Yesu angarenggumbec tongga idung. ");
INSERT INTO yuw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Idiya Yesuho yamuc terodec girang yai yagoc. Girang worochon morömo yu söng fogit fogit amna. Yu ambehecgon ito umbenno sac tongo idung. ");
INSERT INTO yuw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Woroc tuya Yesuho yuot ongga Saimonthon girangdec bangmun ögoc. Ihoroc tongo yu Saimon inong yuna girang wo köreuna yamuc öngkoring tero ambehecgon woce ongga idiya owi amna terodec idungmaho yu erangon auya Yesuho girang wocin omoc ito owi amna yong fandat inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Oro Yesuho owi amna fandat inongbödengga Saimon inogoc, “Oro, yamuc öngkoring bonipnodec ongmadeina umben tomi muuna söng fogidta.” ");
INSERT INTO yuw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ihoroc inuna Saimontho yogoc, “Amna moröma, nocot nucnaiot non kumbong youp morö tongga iditnaya isoc tac mahong söng au mafogimon. Wohong gocho yarocmaha nocho wönggon ongga umben moriwa.” ");
INSERT INTO yuw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Saimon ihoroc yongga onguna nucniot umben monmuya söng koböcma sinom fogiuya umbenno dogit dogitha togoc. ");
INSERT INTO yuw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ihoroc tuna yu ‘nucni girang auhon idungmaho engga tongfat nearut’ yongo obu toroc tong imuya yu engga söng fogiuya girang yaihon öngfoc tongga urop yamuc ganang ohoc ohocha togomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tuna Saimon Pita yu woroc angga soroc yongga Yesu orungo forodec goruc yemoc tongga inogoc, “Moröma, nocu wontucmuno toctoc amna, worocha gocho noc imi fauna ongoi.” ");
INSERT INTO yuw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Amna girangdec idungma yu ambaracho söng koböcma wo yangga toup soroc yogung. ");
INSERT INTO yuw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","O Sebedihon mananin Jems orin Jön yu wömai ihorocgon kiapmo wo angga botogomoroc. Yaima wömai Pitaot youp kondong tongidung. Tuna Yesuho Saimon inogoc, “Goc botirocha. Önga wömai gocu söng fogiditaroc mahong mit wömai gocho owi amna fogida nocot feangoroc.” ");
INSERT INTO yuw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ihoroc tongga girang köreng tonguya tero onguna manomanono böc yoctecno owi wabkaracni wo ambarac dongyu fauya Yesu tan tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Oro Yesu yu böcsa auhon ongkungga idina amna au obukoc lepra toctocyi yu Yesu angga eboc. Amna worochon wedecnoho wömai godibo foc tongbödegoc. Yu Yesuot engmuna yangamo gurocdec aring möngga Yesu inogoc, “Moröma, goc kombiiya angit idinai goc ogep noc ti orokuna noc Kopotorocho yangamin sacsago em.” ");
INSERT INTO yuw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ihoroc inuna Yesuho oburo yudec out tohongga inogoc, “Öc, noc kombihat, goc orokoti.” Ihoroc inuna wohogon obukocno bödegoc. ");
INSERT INTO yuw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tuna Yesuho mata koingo ingoroc inogoc, “Goc yapmu ngo gocdec öngkucma worochon fatno amna au inirocha. Muno, goc ongga godiba öret socsoc amna indahi. Tongo Möseho nongoru sigocma worochon toroc öreta tiruc. Ihoroc tia owi amnaho gangmuya kombiantang, boinno sinom, obukoca bödeuna gocu Kopotorocho yangamin sacsago itaroc.” ");
INSERT INTO yuw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Oro Yesu yu amna wo ‘fat wo owi amna au inirocha,’ yongo ‘muno’ inogoc mahong yuhon fatno moröma urop böcsa guroc danong ongbödengga furang kaboc. Worocha tongga owi amna koböcma sinompho yuhon mata kombic kombicha orin obukoc dongyun orokoc orokocha yuot ebung. ");
INSERT INTO yuw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Oro owi amna koböcma sinom yuot epgon togungmaha tongga bongono bongono Yesuho yu dongyun fauya dönac youp toctocha amna maiyan woce ongidoc. ");
INSERT INTO yuw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yesu yu owi amna fatmata ogepma fandat inongidoc. Tuna bongono auho Farisi orin nongoru gendic fandat fandat amna yu ihorocgon ‘Yesuhon mata kombina’ yongo yuot ebung. Yu wömai Yerusalem taun o Galili orin Yudia provins böc danong wocema ebung. Ehuya Kopotorochon gesö morömaho Yesudec idina yu owi amna obukocni dongyun orokongidung. ");
INSERT INTO yuw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ihoroc tongga idina amna auho nucno abam yorocdec sumboda tebung. Yu wömai orung oburo möng toctocyi idoc. Sumboda tengga böc ganang Yesu idocan woce tong sicsicha kombigung. ");
INSERT INTO yuw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Wohong owi amna koböcmaho böc ganang foc tongga idungmaha Yesuot tonggongon uyap maidoc. Worocha tongga yu nucno sumboda böc koroc töngga Yesu nahenne itacno wo kombingmuya böc wocegon gumandung. Gumanda abam yoroc ganangodec tuya ohuna owi amna bucin idungma yuhon bonipnodec Yesu tan ohongga idoc. ");
INSERT INTO yuw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ihoroc tuya Yesuho yagocmai yu kombing tobic tobicnobarac ida togung. Ihoroc angmuna yu amna möng toctocyi inogoc, “Nochon amna, gochon turongoya urop bödehac.” ");
INSERT INTO yuw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yesu ihoroc yuna Farisi orin nongoru gendic fandat fandat amnaho mata wo kombingga inohogon inun ganun tongga yogung, “Amna ngoi numa? Yu Kopotorocha yong samborec yac yo. Amnahon turongono sac toctocno wömai Kopotoroc yuhogon tongitac yo.” ");
INSERT INTO yuw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ihoroc yongga idiya Yesuho yuhon irot kombic kombicno kombingdengmuna inogoc, “Son foro yaöha irot sonin ihoroc kombiang? ");
INSERT INTO yuw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nocu yaö matahong yoya sonthon kombic kombicdec angit in? Mata ingorochu: Noc gochon turongoya dongya fat gamang. O ingo yontatma wömai ogephu: Goc idongga ongoi. ");
INSERT INTO yuw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kombiarut, Amnahon Manano yu guroc ngocin itonguna Kopotorocho yu turongo dongyun fatfathon gesö imogoc.” Yesu ihoroc yongga amna obukocnima foring angga inogoc, “Noc gantat, goc idongga abam yoroca sogitmina böcan ongoi.” ");
INSERT INTO yuw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ihoroc inuna amna worocho wohogon owi amnaho yangamin idongga abam yorocno sogitmuna Kopotorocha yong moröng inongmuna böcnon onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tuna owi amna yapmu fodibo wo agungmaha soroc yogung. Tongo irotnoho Kopotorochon gesö agungmaha fadang uuya Kopotorocha yong moröng imongga yogung, “Önga yapmu moröma sinom öngkuuna aamon,” ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Oro woroc öngkungbödeuna mit Yesuho taitdec ohongga agocmai, takis fogit fogit amna au mano Levi, yu takis möneng bucin idoc. Tuna Yesuho yu inogoc, “Goc engga noc nari.” ");
INSERT INTO yuw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ihoroc inuna Livai yu wohogon idongga manomanono ambarac dongyun fauya Yesu tan tonggoc. ");
INSERT INTO yuw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mit wömai Livaiho Yesu böcnon yangat tongga Yesuha nacno tong sonoc moröma togoc. Tuna takis möneng fogit fogit amna nucnihu o amna koböcma auhu yu ambarac Yesuot nacno nongga idung. ");
INSERT INTO yuw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nacno nongga idiya Farisi orin nongoru gendic fandat fandat amna Farisihon kombic kombic tanidungma yu yauya inoin kombic kombidec angit maidina Yesuhon youp amnani inong fada yogung, “Son foro yaöha takis fogit fogit amna orin wontucmuno toctoc amna yuot kondong itmuya nacno yamuc naang?” ");
INSERT INTO yuw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ihoroc yuya Yesuho mata wo kombingga mata tepmo ingoroc iban imogoc, “Amna obukocno muno yu ‘Doktaho tongfat nehun’ yongo makombingidang. Muno, obukocnimahogon wömai Doktaha kombingidang. ");
INSERT INTO yuw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Woroc-hon torocgon wömai nocho amna ‘nongnongo’ inong yocyocha maebot. Muno, nocho wontucmuno toctoc amna inong yocyocha ebot. Yu wömai nochon mambocna kombingmuya wontucmunono yangga irotno ibaruya nocot engidang.” ");
INSERT INTO yuw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Oro Yesu yu mata wo yongbödeuna Farisiho Yesu wönggon ingoroc inogung, “Jönthon youp amnani yu bongo koböcma dönac youp toi orin nacnoha gendic singga manai ida itongidang. O amna Farisi tanidangma yu ihorocgon bongono bongono nacnoha gendic singga manongidang mahong gochon youp amnayai yu wömai nacno yamuc bongono muno nocgon tongidang.” ");
INSERT INTO yuw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ihoroc yuya Yesuho mata tepmo au ingoroc inogoc, “Amna auho owi somonni mino song imocimocha tuna numa amnaho yong oin tongga muno yun? Muno, ihoroc matongidamon. Owi min toctoc bongonodec wömai non irot ogep kombingga nacno nongidamon. ");
INSERT INTO yuw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wohong bongono au urop ehangoc. Bongono wocin wömai amna minno togocma yu sa korungon idina tong sonoc toctocno maic. Tuna bongono wocin wömai yu uroci kombingmuya nacnoha gendic singga manai itnahing.” ");
INSERT INTO yuw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Oro Yesu mata tepmo au ingoroc yogoc, “Amna au yuhon tec tohomunmöcno osucno dogiunai wömai yuho tec tohomunmöcno wego sogida wirangga tec osucno buantachu nuhun? Muno sinom, ihoroc tunai wömai tec tohomunmöcno wego tun obukontac. O tecno wegomaho wömai tec osucnohon kiap simbang main. ");
INSERT INTO yuw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","O ihorocgon wain yamuc tobic tobic amna yu bot meme godibo osucnodec wain yamuc wego makoringidang. Ihoroc tuyai wömai wain yamuc wegoho ohongga out tuuna bot meme godibo osucno wo fuc tontac. Tuna wain yamuchu o bot meme godibo wo yait yait tong samborec tontamoroc. ");
INSERT INTO yuw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Worocha kombingga wain yamuc tobic tobic amnaho wömai wain yamuc wego bot godibo wegodecgon koringidang. ");
INSERT INTO yuw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Oro amnaho wain yamuc osucno naantacma yu wömai wain yamuc wegoha mayic. Muno yu yontac, ‘Wain yamuc osucno woi ibibo sinom, worocho wegoma anggirahac.’ Oro worochon torocgon wömai owi amna koböcmaho toroc kiap osucnohagon kombingidang. Tongo yu nochon uyap wegoha ‘muno’ yongidang,” Yesu yu mata tepmo ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Oro, oipmon Yudananohon gendic sep Sabat bongonodec Yesuot youp amnaniot yu wit ön bonip itonggung. Woce itongmuya youp amnaniho wit yitno oburodec fogitmuya godibo song dupdup tuya wit sotno muuya yitno boinno nong tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ihoroc tongo idiya Farisi amna auho yangga inogung, “Son foro yaöha gendic mata noni yembodang. Sabat bongonodec ihoroc toctocha bongbong morö itac.” ");
INSERT INTO yuw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ihoroc yuya Yesuho mata urago ingoroc iban imogoc, “Sonu Devitho osuc kiap togocma worochon fatno embatho makombingidanghu nuhun? Devithon toropni o ino yu nacnoha worec imogung. ");
INSERT INTO yuw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Worec imuya Devit yu Kopotorochon öret socsoc böc ganang öngga nacno sowarango Kopotorochon fatha fong figungma wo fogida nagoc. Nacno sowarango wo wömai ungoma ididoc. Worocha öret socsoc youp amnahogon nongidung, amna komanangno muno. Wohong Devit yu wo fogitmuna nongga docno wömai silip tongga nucni imogoc.” ");
INSERT INTO yuw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesuho mata ihoroc inongga mata docno sakaun fiuna yogoc, “Amnahon Manano yu Sabat bongono worochon Morömo itac.” ");
INSERT INTO yuw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Oro oipmonu Sabat bongono auho Yesu yu Yuda nanohon fatmata yocyoc bucin öngga owi amna fatmata ogepma fandat inogoc. Tuna amna au oburo arocne omong fatfatyi yu wocin idoc. ");
INSERT INTO yuw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Oro Farisi orin nongoru gendic fandat fandat amna yu ihorocgon woce ito ‘Yesuho Sabat bongono gendic noni gumarantachu’ yongo yu angsicgon togung. Yu wömai kombigung, ‘Yesuho Sabat bongonodec obukoc amna wo tun orokunai wömai nontho yu mata youpdec tohong yuantamon.’ ");
INSERT INTO yuw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ihoroc kombigung mahong Yesuho yuhon irot kombic kombic wontucmuno kombingbödegoc. Tongo yu amna oburo omong fatfatyi inogoc, “Goc idongga suraroho yangamin eran iti.” Ihoroc inuna idongga idina ");
INSERT INTO yuw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesuho owi amna inogoc, “Nocho son ingo kanong ac towa: Nongoruho Sabat bongonodec toroc kiap ogepma toctocnoha yacha woha toroc kiap wontucmuno toctocnoha yac. O ihorocgon nonu amna dongyana orokodarut woha nonu amna dongyana omaruthu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ihoroc inongga Yesuho owi amna woce idungma foring yangtongga amna oburo obukocni inogoc, “Obura tong nongnong toi.” Inuna amna wo oburo tong nongnong togocmai wohogon orokogoc. ");
INSERT INTO yuw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ihoroc tuna Farisiho wo angmuya irotno toup sinom ec imuna inohogon yogung, “Oro nonu Yesui ting tong imontamon.” ");
INSERT INTO yuw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Oro bongono worochogon Yesu yu dönac yocyocha sa urongo auhon öngga kumbong wocinu itmuna Kopotoroc dönac inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wocegon idina sa isong urang muuna Yesuho youp amnani inong yuna ebung. Ehuya worochon toropdecma amna 12 soworengga ‘Aposel’ ma mambot imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Aposel ma sogidungma yuhon ma torop woi ingoroc: Saimon, yuha wömai Yesu mano Pita mambodoc. O Saimonthon orugo Andru, o Jems, Jön, Filip, Bartolomyu, ");
INSERT INTO yuw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Jems yu woi Alfiushon manano o Saimon yu woi Selotho toropdecma. ");
INSERT INTO yuw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","O Yudas yu woi Jemshon manano o Yudas Iskariot. Yudas yu wömai mit Yesu ayamihon oburodec sigoc. ");
INSERT INTO yuw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Oro Yesuho Aposelni ihoroc yangsoworeuna yu ambarac sa föpmodec ohogung. Tuna sa woce urop owi amna koböcma sinom idung. Woi owi amna Yesuot itongidungma orin owi amna Yudia provinshon böcsa danongma orin owi amna Yerusalemmahu o Tair orin Saidonthon top tanmahu yu ambarac wocin idung. ");
INSERT INTO yuw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yu amba-racho Yesuhon mata kombic kombicha orin ‘Yesuho obukoc noni dongyun orokona’ yongo ebung. Ehuya Yesuho owi amna dogu boyömpho dongyu mointogungma yu dongyun orokogung. ");
INSERT INTO yuw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kopoto-rochon gesö moröma worocho Yesudec foc tongga idina Yesuho owi amna tongfat yegoc. Worocha tongga owi amna ambaracho oburo yudec wot möcmöcha toup tuya gesö worocho owi amna ambarac donyun orokongdup togung. ");
INSERT INTO yuw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Oro urop Yesuho owi amna yu tan tonggungma foring yangga ingoroc inogoc, “Son owi amna uroci son yong borongdearut. Kopotorochon toboruc woi sonthon. ");
INSERT INTO yuw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","O son owi amna önga nacno manomanoha möp idangma son yong borongdearut. Mit wömai sonu yapmu auha madocmui ogepgon itnahing. O son owi amna önga mepmo kombingga yongoin tongo idangma son wömai mit irot guc kombingga yonggutnahing. ");
INSERT INTO yuw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Son Amnahon Mananoha kombing tobing imongidang-maha tongga amnaho son ayam ayam tong kamongga inoin surarodec kangato kanonahing. O ihorocgon yu sontha mata mene yongga dongyu obukonahing. Oro yu kiap ihoroc tong kamontanganu wömai sonu worocha kombing borongdearut. ");
INSERT INTO yuw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Sonthon wöngnac soni moröma sinom worocho wömai Kopoto-rocot momdec sontha torengo itac. Worocha tongga amna auho son mepmo tong kamontangan bongono wocin son borongdearut. Osuc ombung sakung soni yu kiapmo wontucmuno ihorocnogon Kopotorochon yong tuctuc amnani inongidung. ");
INSERT INTO yuw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Worochoi oro, son möneng yoctec amna, son soni woho! Son yapmu ogepma urop guroc ngocin fogitdeang. Worocha son mit yapmu au masogitning. ");
INSERT INTO yuw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","O son owi amna önga nacno koböcma nongga modip soni foc tongidangma son soni woho! Son wömai mit möp itnahing. O son amna önga irot ogep kombingga yonggud-idangma son soni woho! Sonu wömai mit mepmo kombingga ointongga itnahing. ");
INSERT INTO yuw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ombu sakung soni yu wömai osuc imanang yong tuc tuc amnaha yong moröng imongidung. O önga suraro ambaracho ma soni yong moröng tong kamuyai wömai son soni woho!” ");
INSERT INTO yuw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesuho mata sakaun fiuna ingoroc yogoc, “Son numariho nochon mataha onggim singga kombingidangma son woroc nocho ingo kantiwa, sonu ayam soniha oröc tong imongitnung. O amnaho sontha ayam tong kamuyai wömai sonu yuha urago ogepma tong imongitnung. ");
INSERT INTO yuw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","O ihorocgon amna auho son möpmo wagang kamuyai wömai sontho uragoha ‘Kopotorocho tong ogep tong kampun’ yongo mata urago inongitnung. O amna auho son dongyu obökuyai wömai sontho ‘Kopotorocho yu tongfat yehun’ yongo dönac yongitnung. ");
INSERT INTO yuw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","O amna auho moguma aramo ökene guyai wömai moguma ökene boging impi. O amna auho gochon tec tohomunmuca usem tunai wömai gocho yu angbanangga sum teca boging impi. ");
INSERT INTO yuw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Amna auho yapmu manomanoha ‘wo nampi’ yongga ganuya wömai gocho ‘muno’ inirocha, muyu imongidiruc. O ihorocgon amna auho gochon yoctec au yongga fonguyai wömai gocho yu inong fato ‘wo wönggon nampi’ inirocha. ");
INSERT INTO yuw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Son muyu toroc kiap ‘nuc soniho son tong kamongitnung’ yongo kombingidangma, toroc kiap ihorocnogon wömai sonu nuc soniha tong imongitnung. ");
INSERT INTO yuw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Oro gocho amna gakaha toup kombingidangma yuhagon toup kombiantarocanu wömai gocu yapmu moröma matiroc. Kopotorocho worochon wöngnacno ogepma magamic. Wömai yaha wontucmuno toctoc amna yu toroc kiap worocotmagon tongidang. ");
INSERT INTO yuw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","“O gocho amna gakaha tong ogep tong gamontangma yuhagon toroc kiap ogepma tong imontaroc. O amna toroc wontucmuno tong gamontangma yuha wömai ayam tong imontaroc. Oro toroc kiap ihorocno woi yapmu moröma muno. Kopotorocho worochon wöngnacno ogepma magamic. Wömai yaha wontucmuno toctoc amna yu toroc kiap worocotmagon tongidang. ");
INSERT INTO yuw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“O gocho amna auha kombiharoc yu möneng urago wönggon namontac, amna ihorocnohagon wömai möneng imontaroc. Wohong amna au, gocho yuha irot yai kombingga ‘möneng wönggon namontachu munohu’ yongo yuha wömai yapmu au maimiroc. Oro toroc kiap ihorocno woi yapmu moröma muno. Kopotorocho worochon wöngnacno ogepma magamic. Wömai yaha, wontucmuno toctoc amna yu ihorocgon nucni möneng koböc idimangma yuhagon möneng imongidang. Yu wömai kombiang, amna ihorocnoho möneng butogo ambarac saringidang. ");
INSERT INTO yuw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Worochoi oro, son muyu ayam soniha toup kombingga tong ogep tong imongitnung. Tongo son yuha manomano boging imongga urago sogit sogitha kombininga. Son ihoroc tuyai wömai son Kopotoroc onoce sinom itacma yuhon weni manani itmuya wöngnac soni ogepma sinom sogitnahing. Yuho wömai amna wontucmuno orin amna urago matongidangma yuha tong ogep tong imongitac. ");
INSERT INTO yuw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Worocha wömai sontho ihorocgon Nandöng sonihon toroc kiap ogepma tanmuya nuc soni yang banangga tong ogep tong imongitnung.” ");
INSERT INTO yuw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesuho wönggon matano sakaun fiuna ingoroc yogoc, “Sontho nuc sonihon toroc kiapmo angsoworeninga. Tuna Kopotorocho sonthon toroc kiap soni ihorocgon maangsoworeic. O sontho nuc sonihon mata yu bödeuna urago wontucmuno imoninga. Tuna Kopotorocho mata soni ihorocgon mayun bödeuna urago wömun makamic. Sontho nuc sonihon turongono imu fat imongitnung. Tuna Kopotorocho sonthon turongo soni ihorocgon imun fat kamangoc. ");
INSERT INTO yuw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Son muyu manomano soni amna auha silip tong imongitnung. Tuya Kopotorocho urago töngga son ihorocgon manomano iban kamangoc. O yuho wömai gipmohon toroc makamic. Muno yu oheta kureuna ohuna koring önggöngno kiap get kamangoc. Sontho silip tongga nuc soniha manomano imongidangma worochon torocgon wömai Kopotorocho son manomano iban kamangoc.” ");
INSERT INTO yuw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Oro Yesuho wönggon mata tepmo au ingoroc yogoc, “Amna au daro kom toctocyi yuho ogep amna au daro sumo yu uyap indauntha woha muno? Woi muno! Ihoroc tonggai wömai yaityaitgon gopmain ohun. ");
INSERT INTO yuw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","O managumboc auho wömai fandat fandat amnanohon kombic kombic manggiraun. Wohong managumbocho kombic kombic ogepma sogitdup tontacanu wömai yu fandat fandat amnano simbanggon in. ");
INSERT INTO yuw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“O goc yaöha fön obugu oröcaho daron itacma wo wömai angitaroc mahong ep moröma gakain daran itacma woha wömai makombiroc. ");
INSERT INTO yuw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","O gocu tingtinga oröca ingoroc inontaroc, ‘Oröc, noc fön daran itacma yopyopha kombihat.’ Ihoroc inongitaroc mahong gakain daran wömai ep moröma itacma worocha wömai etno itaroc. Goc imanang amna osuc ep moröma gochon daran itacma wo yongdengga mit wömai oröcahon fön obugu daron itacma woroc tuctugo foringga yohantaroc.” ");
INSERT INTO yuw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesuho wönggon mata sakaun fiuna mata tepmo au ingoroc yogoc, “Ep ogepma yu koburo wontucmuno mafingitac. O ihorocgon ep wontucmunoho wömai koburo ogepma mafingitac. ");
INSERT INTO yuw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Amnaho wömai ep koburo ango ephon foro ogepmahu o wontucmunohu kombiantac. Amnaho wömai fik koburo yi dirongo tumoc mabariic. O ihorocgon wain koburo wömai ep gosongonma woce mayaun fetning. ");
INSERT INTO yuw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Oro worochon torocgon wömai amna ogepmahon irotnon manomano ogepmahogon foc tongga ididang. Tuna amna worochon youpno boinnobarac engoc. Wohong amna wontucmuno yuhon irotnon wömai manomano wontucmunoho foc tongga idang. Tuna amna worocho duc matano orin toroc kiapmo wontucmunogon tontac. Amnahon duc matanoho wömai irot kombic kombicnohon kiapmo tarantac. Ogephu o wöntucmunohu yu duc matanoho worochon torocgon yongitac.” ");
INSERT INTO yuw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesuho wönggon ingoroc yogoc, “Tingting oro! Bongono muno sontho nocha ‘Moröma noni, Moröma noni’ ihoroc nanongidang mahong nochon mata sumbot sumbotha wömai sonu makombing. ");
INSERT INTO yuw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Worocha tongga nocho amna nochon mata sumbot tongontacma yuhon toroc kiapha mata tepmo ingoroc kantiwa. ");
INSERT INTO yuw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Amna wo yu böc toctocha tac. Tongo gopma giuna omoce sinom sop koroc ohogoc. Tuna böc orungo sop tumoc omoce akep sinom tongga idiya böcno temongmun öantac. Tuna mit yamuc öngkorop tongga böc wo koreantac mahong amna worocho böcno ogepma koingo sinom togocmaha tongga böcno maköndet ongic. ");
INSERT INTO yuw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Oro amna auho nochon mata kombingga masumbicma yuhon foro wömai ingoroc. Amna wo yu böcno toctocha togoc mahong yu böcno orungohon gopma imanang imananggon giuna böc orungo sop koroc mahogoc. Tuna yamuc öngkoropho engga böc wo koreuna kondet ongga obukogoc,” Yesuho yuhon mata sumbot sumbothon mata tepmo ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesuho mata woroc ambarac owi amna inongbödengga mit Kaperneam böcsa woce onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Böcsa woce wömai tawa amnahon ofisa au idoc. Yu wömai tawa amna 100 yangtorengidoc. Oro ofisa worochon youp wabkaracno yu obukoc morö tongga omompha togoc. Ofisa yu wömai youp wabkaracnoha toup kombingidoc. ");
INSERT INTO yuw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tongo yu Yesuho epacno kombingga Yuda nanohon amna dugo au inong yuna ehuya inogoc, “Son ongmuya Yesu inuya yu engga youp wabkaracna tun orokotun”, ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Inuna amna dugo worocho Yesuot ongmuya kiring imongga inogung, “Kombihi, ofisa wo yu amna ogepma. Yu wömai Yuda nano noniha toup kombingitac. Tongo yu fatmata yocyoc böc noni tong nimogoc. Worocha goc muyu ongga yu tong fat yehi,” ");
INSERT INTO yuw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","ihoroc inuya Yesuho yuot onggoc. Tuna yu böc ambehecgon ongkungidiya ofisaho nucni au inong muuna Yesuot engga mata ingoroc inogung, “Ofisa noni yu ingoroc yongga ninong muuna ebamon: ‘Moröma, goc nocha youp morö tirocha. Noc amna ogepma muno worocha gocu nocho bucin öirocha. Noc kombiaya nakabut gocot ehantatma woi angit maec. Noc kombihat, gakain mataya woi gesöbarac. Worocha goc korungon itmina mata yia youp wabkaracna orokun. ");
INSERT INTO yuw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Noc wömai ihorocgon amna moröma auhon unenne itmaina yuhon matano sumboditat. O nochon unenne wömai ihorocgon tawa amnanai ida nochon mata sumbodidang. Nocho au inontat: ‘Goc ongoi!’ Wömai yu ongontac. O au inontat: ‘Goc epi!’ Wömai yu ehantac. O nocho youp wabkaracna inontat: ‘Goc youp woroc toi!’ wömai yuho youp woroc tontac.” ");
INSERT INTO yuw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesuho amna worochon mata kombingga soroc yongo irotno fadang uuna ibarun fauna owi amna yu tan tebungma inogoc, “Nocho ingo kantiwa: Israel nano sonin bonipsonidecma wömai amna au amna ngorochon kombing tobic tobic toroc kiap simbang magot.” ");
INSERT INTO yuw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yesu ihoroc yuna amna morömaho inong muuna ebungma yu wönggon ibaru fauna böcnon onggung. Ongga agungmai ofisahon youp wabkarac yu urop orokogoc. ");
INSERT INTO yuw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Oro worochon menon wömai Yesuho böcsa auhon onggoc. Böcsa worochon mano wömai Nain ihoroc yongidung. Woce onguna youp amnani orin owi amna koböcmaho yuot ebung. ");
INSERT INTO yuw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yu engga gombo morö böcsa wo arenggumbec togocma worochon simbun ambehecgon idiya yagungmai amna omomyi auhon ep fambangno wömai böcsa sumonne tongga tebung. Amna ombocma yu wömai owi kapi auhon manano tungu sinom idoc. Wo tengga böcsa worochon owi amna koböcma sinompho owi kapiot onggung. ");
INSERT INTO yuw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yu ongga idiya Morömaho owi kapi woroc angmuna irotno meptuna uroci morö kombigoc. Tongo yu owi inogoc, “Goc ointirocha.” ");
INSERT INTO yuw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ihoroc inuna amna fadang tebungmaho ehuya Yesu yu ongga fadang sogiuna amna fadang tebungma yu onggom suya Yesuho amna ombocma inogoc, “Amna berac noc ingo gantiwa, goc idongoi!” ");
INSERT INTO yuw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ihoroc inuna amna omomyi wo idongga forosingga duc mata yogoc. Tuna Yesu yu owi kapi wo manano tungu wönggon imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Owi amnaho toroc kiap wo angga irotno fadang öcno sinom tongo Kopotoroc yong moröng imongga yogung, “Mayain, Kopotorocho inoin owi amnani tongfat yecyecha yong tuctuc amna au moröma sinom yu inong muuna nonthon bonip nonidec ehac.” ");
INSERT INTO yuw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesuho toroc kiap ngo togocma worochon fatno wömai Yuda nanohon guroc orin sa guroc au ambehecgon idungma woce ongbödegoc. ");
INSERT INTO yuw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Oro, Jönthon youp wabkarac yu Yesuho youp inobarac togocma worochon fatno ambarac Jön inongbödegung. Inuya Jöntho youp wabkaracnin yai inong yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Inong yuna ehunya Jöntho ingoroc inogoc, “Sodu Yesuot ongmunya ingoroc inong ac tarun, ‘Amna Kopotorocho siuna ebepha yong koing yogocma woroc woi gakaha woha non amna auha torengga itna?” ");
INSERT INTO yuw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Ihoroc inuna amna yaima yu Yesuot ongga agomorocmai, Yesuho owi amna obukocno foro ihono ihono koböcma sinom dongyun orokogung. O yu dogu wontucmuno koböcma owi amnadecma dongyandoc. O daro kom toctocyi dongyun orokuya daro wönggon forigung. Amna yaimaho wo angga Yesu inogomoroc, “Jön yamuc gung imocimoc amna yu ingo ganong ac toctocha ninong muuna ebamot: ‘Gocu amna Kopotorocho siuna ebepha yong koing yogocma worocha woha amna auha torengga itna?’” ");
INSERT INTO yuw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ihoroc inunya Yesuho Jönthon youp amnanin mata urago ingoroc iban imogoc, “Sot ongga manomano yaamorocma orin kombiamorocma worochon fatno Jön inarun. Amna dan komnima yu wönggon dan foric tang. O amna orungo omong fatfatyi yu wönggon uyap itongidang. O amna obukoc lepra toctocyi yu orokodang. O amna onggim tong tongni yu wönggon mata kombiang. O amna omong fadungma yu wönggon wekongga itongeyang. O owi amna uroci yuho wömai fatmata ogepma kombingidang. ");
INSERT INTO yuw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Boinno sinom, owi amna ambaracho nocha me manamingma yu wömai borongdearut.” ");
INSERT INTO yuw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yesuho Jönthon youp wabkaracnin yaima mata ihoroc inongbödeuna yu ibarun fauna ongunya Yesu yu forosingga owi amna Jöntha inong tuctuc tongo ingoroc yogoc, “Sonu tingting acacha ‘Jön ana’ yongo sa amna maiyan woce onggung? Sonu sumpho fondom tongi tepi togocma ‘woroc ana’ yongo yuot onggunghu nuhun? ");
INSERT INTO yuw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Woha tingting acacha kombingo onggung? Amna au tec tohomunmucno ogepma sinom tobic tobicyi worochu? Muno, amna tec tohomumucno ogepma orin yoctec möneng koböc idimangma yu wömai kinghon böc moröma wocingon ididang. ");
INSERT INTO yuw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Worochoi oro son tingting sinom acacha kombingo Jönot onggung? Kopotorochon yong tuctuc amna auhu? Boinno sinom, amna worocho wömai yong tuctuc amna osuc idungma yu ambarac yanggirahac. ");
INSERT INTO yuw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Amna ngorocha sinom wömai Kopotorochon bapiyadec mata ingoroc irim toctocyi itac: ‘Nocho amna au siaya yu engmuna osuc fat gamongo owi amna nochon yongburoc mata inong tuctuc tangoc. Tongo yu gochon uyap tong arangarang tangoc.’” ");
INSERT INTO yuw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesuho wönggon yogoc, “Nocho boinno sinom kantiwa, Jön yui amna moröma sinom, yu wömai guroc amna ambarac yanggiratbödehac. Wohong Kopotorochon toboruchon owi amna komanangno sinom yu wömai Jön anggiraang.” ");
INSERT INTO yuw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Owi amna ambarac yu Yesuhon mata wo kombingga yogung, “Boinno sinom, Kopotorochon toroc kiapmo woi nongnongogon,” ihoroc yogung. O takis fogit fogit amna yu mata ihorocnogon yogung. Yu wömai osuc Jönot onguya yamuc gungimogoc. ");
INSERT INTO yuw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wohong Farisi orin amna moröma Yuda nanohon gendic nongoru angtorengidungma yu wömai Kopotorocho uyap ogepma tong indagocma wo me imongga Jönthon yamuc gupgup kiapha ‘muno’ yogung. ");
INSERT INTO yuw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Oro Farisiho uyap ogepmaha me imogungmaha tongga Yesuho wönggon ingoroc yogoc, “Oro nocho owi amna önga idangma yuhon foroha tingting sinom yowa? Yuhon toroc kiapmo woi tingting? ");
INSERT INTO yuw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yu wömai wabkarac maket taitdec kömec tongidangma woroc simbang. Wabkaracho maket taitdec itmuya nucni ingo inogung, ‘Non uping mögomon mahong sonu ap mawodung. O non yong uroc ap yogomon mahong sonu maointogung.’ ");
INSERT INTO yuw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Mata tepmo worochon foro wömai ingoroc: Jön yu engmuna nacno gucsim omong omong orin yamuc sinom worocgon nongo itongidina sontho yu angmuya yongidang: ‘Dogu wontucmunoho yudec itacmaha tac yo!’ ");
INSERT INTO yuw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","O önga wömai Amnahon Manano yu engmuna nacno ogepma orin wain yamuc nongidina sontho yu angga yongidang: ‘Yui amna nongmenni, yu wain yamuc nongga bumbum yongitac. O yu takis fogit fogit amna orin wontucmuno toctoc amna yuot itmuya oröc oröc tongitac.’ ");
INSERT INTO yuw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sonu ihoroc yongidang mahong mata soni woi kandöc sinom. Kombiarut, owi amna Kopotorochon kombic kombic ogepma sumbodidangma yuha wömai Kopotorocho inoin uyap ogepma tong indauna tuctugo kombiantang.” ");
INSERT INTO yuw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Oro, Farisi au mano Saimon yu Yesu nacno nocnocha inong yogoc. Inong yuna Yesuho yuho bucin öngga nacno nocnoc abam woce omoc idoc. ");
INSERT INTO yuw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Böcsa wocin wömai wontucmuno toctoc owi au idoc. Yu kombigoc, Yesuho Farisiho bucin nacno nongga itac. Woroc kombingga sanda unac tugo ogepma wo sogitmuna eboc. ");
INSERT INTO yuw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Engmuna Yesuho menon orungo foron woce yong ointongo idina daro yamugoho Yesuhon orungodec ohuna bom togoc. Ihoroc tuna owi inoin bigo sakemoho daro yamugo wo sac tongo Yesu gending imocimocha orungo ducin ducin tongo unac tugo ogepmani sogito Yesu orungodec wagang imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Oro owi yu ihoroc tongga idina Saimontho kiapmo wo angmuna ingoroc kombigoc: ‘Owi ngoi wontucmuno toctoc owi. Worocha woroc, amna ngo boinno Kopotorochon yong tuctuc amna inai wömai yuho owi worochon forono kombiun.’ ");
INSERT INTO yuw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ihoroc kombiuna Yesuho yuhon irot kombic kombicno angga inogoc, “Saimon noc mata au gantiwa.” Inuna Saimontho yogoc, “Oro fandat fandat amna yia kombiwa.” ");
INSERT INTO yuw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Inuna Yesuho mata tepmo ingoroc inogoc, “Amna yai idomoroc. Yuhon möneng butogo amna moröma audec idoc. Aumahon wömai 100 kina o aumahon wömai 10 kina möneng butogo ihoroc idoc. ");
INSERT INTO yuw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tuna möneng butogo saric sarichon bongono urop eboc mahong yaima yu mönengha docmögomoroc. Tuna amna morömaho yu yang banango inogoc, ‘Sotin urago docno wömai nocho komanang ta bödeantac.’” Yesuho mata tepmo wo inongga Saimon ingoroc inong ac togoc, “Amna yaima numaho wömai amna morömaha toup kombiantac? Amna butogo moröma tun bödeng imogocmaha woha möneng butogo obugugon tun bödeng imogocma?” ");
INSERT INTO yuw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Yesuho ihoroc inuna Saimontho ingoroc yogoc, “Nocho wömai ingo kombihat, Amna möneng docnono morö imun fat imogocma yuho wömai amna morömaha toup kombiantac.” Ihoroc yuna Yesuho inogoc, “Goc boinno sinom yaroc.” ");
INSERT INTO yuw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesuho ihoroc yongga owiot ibarun fauna Saimon inogoc, “Owi ngo ahi. Nocu gocho bucin öhat mahong gocu toroc kiap ogepma tanda orungna sac toctochon yamuc au manamoroc. Wohong owi ngorocho wömai daro yamugoho orungna sac tong nampac. Woroc tongo bigo sakemoho tong manman tongnampac. ");
INSERT INTO yuw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","O gocho Yuda nanohon toroc kiap ogepma tanda noc ducin ducin matongnamoroc mahong owi ngorocho wömai noc gending namongga orungnadec ducin ducin tong namocgon tongga itac. ");
INSERT INTO yuw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","O gocho noc ma morö namoc namocha bicnadec unac au mawagang namoroc mahong owi ngorocho wömai unac tugo ogepma sinom wo orungnadec gungnamoc. ");
INSERT INTO yuw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Worocha nocho ingo gantiwa. Owi ngo yu osuc wontucmuno koböc tongidoc mahong yu irotno tong fup nampac. Worocha tongga wontucmunono urop bödehac. Wohong amna auho wontucmuno obmugon tong sac tongimogocma yu wömai nocha toup sinom makombic.” ");
INSERT INTO yuw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesuho Saimon ihoroc inongbödengga mit yu owi wo inogoc, “Owi, gochon wontucmuno urop bödehac.” ");
INSERT INTO yuw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yesuho owi ihoroc inuna amna au woce idungma yu mata woroc kombiuya angit maidina forosingga mata inun ganun tongga yogung, “Amna ngo amna nucnihon turongo dongyun fat imongitacma woi numa sinom?” ");
INSERT INTO yuw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ihoroc yuya Yesuho owi wo wönggon inogoc, “Kombing tobic tobicaho tuna goc Kopotorochon fat itmina batip itaroc. Goc irot gucot ongoi,” ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Oro worochon menon Yesuot youp amnani 12ot yu böcsa danong itongmuya Yesuho Kopotorochon toborucnohon fatmata ogepma owi amna fandat inong tonggoc. ");
INSERT INTO yuw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tuna owi au yu ihorocgon Yesu tan tongidung. Yu wömai osuc dogu boyömoni o obukoc foro ihono ihononi ididung mahong Yesuho yu dongyun orokogung. Owi auhon mano wömai Maria, yui Makdala böcsadecma. Yudec wömai dogu boyömo 7 ihorocho idung mahong Yesuho yu dongyan imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","O owi au mano Jöana. Yu woi Kusahon oweno. Kusa yu wömai king Heröthon böc moröma wo angtorengidoc. O owi au mano Susana. Oro owi worocot owi koböcma auot yu inoin möneng fogitmuya Yesu orin youp amnani tan tongo manomanoha tongfat yengtonggung. ");
INSERT INTO yuw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Oro owi amna koböcmaho böcsa woce wocema Yesuot engmuya suran tongga idiya Yesuho forosingga mata tepmo ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Amna auho ongga wit yitno antonggoc. Antongina yitno au wömai uyapdec möngga idiya amnaho ongi epi tongo yambendung. O au wömai yupho nagung. ");
INSERT INTO yuw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Oro wit yitno auho wömai sop koroc möngga dogo köbung mahong sop koroc woce yamugo maidocmaha tongga yitno wo manman yongmuya ombung. ");
INSERT INTO yuw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Oro yitno auho wömai yi dirongoni tumoc möngga dogo köngmuya yi dirongoniho ihorocgon kungga karupgon macfingga wit yitno tombuya ombung. ");
INSERT INTO yuw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Oro wit yitno auho wömai sa guroc ogepmadec möngga dogo köngmuya boinno ogepma figung. Yitno tungu tungu wömai koburo 100 worochon toroc figung.” Yesuho mata tepmo woroc yongbödengga ingoroc mambodoc, “Amna auho onggimobarac idai wömai yu mata ngo kombiun.” ");
INSERT INTO yuw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Oro Yesuho mata tepmo ihoroc inuna youp amnaniho makombing tuctuc tongo Yesu worochon foroha inong ac tuya Yesuho ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","“Kopotorochon toborucnohon foro wömai eran maec. Wohong Kopotorocho son kang banauna sonu wo urop kombiang mahong owi amna auha wömai nocho mata tepmogon inongitat. Ihoroc toya Aisayaho mata yogocma worocho boinno entac: ‘Owi amnaho dan foric tontang mahong yapmu au angtangtang matoning. O yu matahon kekoröpno kombian-tang mahong mata worochon foro tuctugo makombining.’ ");
INSERT INTO yuw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesuho matano sakaun fiuna ingoroc yogoc, “Wit yitnohon mata tepmo worochon foro kombiarut. Wit yitno woi Kopotorochon matano. ");
INSERT INTO yuw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Oro wit yitno uyapdec mögungma worochon yong tuctucno wömai ingoroc: Owi amna au yu Kopotorochon mata onggimphagon kombingidang. Tuna dogu kopotho engmuna Kopotorochon mata urop irodin idangma wo ambarac fuun deantac. Woi ‘owi amna wo Kopotorochon fatmata kombing tobing imuya Kopotorocho yu wönggon inoha batip fogiicyit’ yongo fatmata tun deditac. ");
INSERT INTO yuw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Oro wit yitno sop koroc mögungma worochon yong tuctucno wömai ingoroc: Owi amna au yu fatmata ogepma kombingga karupgon sogida borongdedidang mahong wit yitnoho fonsirango guroc ganang angit mahogocmaha tongga yu tonguc yecyec bongonodec makoingsi karupgon mönahing. ");
INSERT INTO yuw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Oro, wit yitnoho yi dirongoni tumoc mögungma worochon yong tuctucno wömai ingoroc: Owi amna au yu Kopotorochon fatmata kombingidang mahong yu gurochon itonggongnoha kombingbanac morö tongidang. Tongo yu mönenghahu o gurochon ibibo manomanohahu borongdedidang. Tuna kiap worocho yitno ogepma tun mointuna boinno muno entang. ");
INSERT INTO yuw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Worochoi oro wit yitno guroc ogepmadec mögungma worochon kiapmo wömai ingoroc: Owi amna au yu Kopotorochon mata tuctugo kombingga irotnon sogit akep tongidang. Sogit akep tuya kombing tobic tobicnoho koing songga idina boinno koböcma finahing.” ");
INSERT INTO yuw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesuho wönggon mata tepmo au ingoroc yogoc, “Amnaho gop gata wö gananghu o abam unehu woce masingidang. Muno sinom, amnaho wömai gopno abam korocgon siuya amna auho böc ganang ehuya gopho yaguno möng imontac. ");
INSERT INTO yuw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Worochon toroc wömai manomano öp idangma worocho mit eran öngkupnahing. O ihorocgon manomano amnaho öp yau wedidangma worocho eran öngkungbödeuya amnaho yango tuctugo kombinahing. ");
INSERT INTO yuw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Worochai son soni woho. Son onggim soni nochon mataha ogepma sinom siarut. Wömai yaha, amna au yu mom toboruchon foro urop obmukusuc kombiang. Worocha tongga Kopotorocho yuhon kombic kombicno obugu wo sakaun fiuna yu worochon foro tuctugo sinom kombinahing. Wohong amna au yu mom toboruchon kombic kombicha kombiuya sahano itacma yudec wömai Kopotorocho kombic kombicno ambarac fuun deuna bumbum yongbödenahing.” ");
INSERT INTO yuw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Oro bongono wocingon Yesuhon macno orugi yu Yesu acacha ebung. Engga yagungmai owi amna koböcho Yesu idocan woce arenggumbec tongga idung. Worocha Yesuot onggongon uyapno maidoc. ");
INSERT INTO yuw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ihoroc idiya amna auho woroc yangga Yesu inogoc, “Maca oröcai yu taitdec ida gacgacha yang.” ");
INSERT INTO yuw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ihoroc inuna Yesuho mata ökene ingoroc iban imogoc, “Nochon macnai oröcnai sinom woi numari? Woi owi amna Kopotorochon fatmata kombingga worochon torocgon itongidangma yu woroc.” ");
INSERT INTO yuw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Oro oipmonu Yesuho youp amnani inogoc, “Yamuc öngkoring gino ökene woce ongona.” Ihoroc inuna yu girang audec bangmu uuna onggung. ");
INSERT INTO yuw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ongidiya Yesuho dupdup imuna duboc. Dungo idina wohogon sum morömaho busuna yamuc toup öngmuna girang ganang ohuna yu yamuc ganang ohonggonga togung. ");
INSERT INTO yuw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Woroc tuna youp amnaho wo angbotongga Yesu inong yongga mambodung, “Moröma non urop yamuc tumoc ohonggonga tamon!” Ihoroc inuya Yesuho idongga sum moröma orin yamuc funfuro woroc inong fauna sumpho onggom suna yamucho nongnong yongga idoc. ");
INSERT INTO yuw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ihoroc tunya Yesuho youp amnani inogoc, “Kombing tobic tobic soni nahe?” Ihoroc inuna youp amnani yu Yesu toroc kiap togocma wo angga soroc yongga botongga inohogon mata inun ganun tongga yogung, “Mayain, amna ngoi numa sinom. Yu mata orongi yuna yamuc funfuro orin sumpho yuhon matano sumbodamoroc,” ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Oro mit Yesuot youp amnaniot yu wönggon girangdec ongga Gerasa nanohon guroc woce onggung. Sa wo wömai Galili böcsa yamuc öngkoring worochon tero ökene idoc. ");
INSERT INTO yuw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wocin ongkungga Yesu yu girang imun fauna gurocdec bangmun muuna amna au dogu boyömpho sogit sogityima yu Yesu aun fedoc. Amna wo yu Gerasa böcsaema. O yu böcno muno o tec boruno muno muroc itongidina sa ubarago idoc. Dupdupha wömai yui guroc gopma amna fiiyan woce ongidoc. ");
INSERT INTO yuw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Oro amna worocho Yesu angga Yesuhon orungo forodec möngga ecnang sinom mamboda yogoc, “Ayöö Yesu, goc woi Kopotoroc onoce sinom yuhon Manano. Gocu yaö tong namnampha eparoc. Gocu noc focfoc namongga ti obökityit.” ");
INSERT INTO yuw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesu yu urop dogu wontucmuno wo ‘amna imun fahun’ yongo inong mudocmaha tongga yu ihoroc mambodoc. Oro Gerasa nano yu wömai osuc amna woroc sen orin hankapdec kaning yungidung mahong dogu wontucmunoho yuho irotnon ididungma yuho kudat kudat tongmuya sen orin hankap dong dogit dogit tongga bumbum yongo ongga sa guroc amna maian woce itongidoc. ");
INSERT INTO yuw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Oro Yesuho amna wo inong ac tongo inogoc, “Goc maya numa?” Ihoroc inuna amna worocdec dogu wontucmuno koböcma ididungmaha yu yogoc, ‘nochon mana woi ami’ ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yuna dogu boyömpho ecnang sinom Yesu dönac inongo yogung, “Goc niria ongga dogu kopothon ganango forono muno woce ohonintha.” ");
INSERT INTO yuw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Oro bongono wocin wömai bot koböcma sinom sa urongo ambehecgon woce nacno nongo idung. Tuna dogu boyömpho Yesu dönac ingoroc inogung, “Goc ning banaia non botho irotnon ohona.” Ihoroc inuya Yesuho yu kombing imuna wocegon ohogung. ");
INSERT INTO yuw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Woroc tuya bot worocho bumbum yongmuya domdomgon sa bohöngnon ohongga yamuc ganang ohongmuya omong fatbödegung. ");
INSERT INTO yuw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Oro ihoroc tuya amna bot wo yangtorengidungma yu yapmu woroc angbotongmuya domdomgon ongga worochon fatno böcsa danong inong tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ihoroc tuya owi amna yu ‘yaö sinom tuna kiap wo öngkupac’ yongo Yesuot ebung. Engga agungmai dogu boyömpho amna wo urop imu fauna kombic kombicno ogep idina boru temongga Yesuhon orungo forodec omoc idoc. Tuna owi amnaho wo angga botogung. ");
INSERT INTO yuw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tuna amna Yesuho togocma wo ino daroho agungma yu worochon fatno owi amna inong tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ihoroc inuya Gerasa nano ambaracho wo kombingga toup botongga ‘Yesu sa guroc noni imun fahun’ yongo Yesu dönac inogung. Ihoroc inuya Yesu yu girangdec bangmun uuna onggonga togoc mahong ");
INSERT INTO yuw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","amna dogu wontucmuno dongyan imogocma yu ‘Yesuot itongowa’ yongo dönac inogoc mahong Yesuho ‘muno’ yongo ");
INSERT INTO yuw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ingoroc inogoc, “Goc ibari fauna böcan ongga Kopotorocho goc ogepma sinom tongfat gegocma worochon fatno owi amnadec yong morögiruc.” Ihoroc inuna amna wo ibarun fauna ongga böcsa danong Yesuho yuha ogepma sinom tongfat yegocma worochon fatno owi amna inong tonggoc. ");
INSERT INTO yuw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Oro, yamuc öngkoring gino ökene woce owi amna koböcmaho Yesuha torengga idung. Torengga idiya Yesuho ehuna angga borongdedung. ");
INSERT INTO yuw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ihoroc tuya amna au mano Yairus yu Yesuot eboc. Yu wömai Yuda nanohon fatmata yocyoc böc angtorengidoc. Tongo yuhon weno tungu batip sinom worocho omompha togoc. Yuhon birucno wömai 12 ihoroc idoc. Worocha tongga Yairus yu engmuna Yesuhon orungo forodec goruc yemoc tongimongga ‘Yesuho wena tun orokotun’ yongo kiring imogoc. Ihoroc tuna Yesu urop ‘Yairusho bucin ongowa’ yongo uyapdec ongga idina owi amna koböcmaho foc akep tocno sinom tongga nucno köreun köreun tong tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ihoroc tuya owi auho wocin idoc. Yu wömai nogotnoho wuna idina biruc 12 ihoroc idoc. Amna auho yuhon obukocno tun orokoc orokocno wömai maidoc. ");
INSERT INTO yuw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Worocha tongga owi worocho Yesuhon menon ambehecgon sinom engmuna oburoho Yesuhon tec tohomunmöcno worochon mondopmo wot mögoc. Wot möngga wohogon nogot obukocno wo manman yongo bödegoc. ");
INSERT INTO yuw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Owiho Yesu wot muuna Yesuho woroc kombingga suraro inong ac tongga yogoc, “Numaho oburo nocdec not möhac?” Ihoroc yuna amna ambaracho ‘muno’ yogung, ‘non ihoroc matomon’. Ihoroc yuya Pitaho yogoc, “Moröma yahi, owi amna koböcma sinompho goc gang arenggumbec tongga nucno köreun köreun tongga goc got muang.” ");
INSERT INTO yuw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pitaho ihoroc inogoc mahong Yesuho kiringga wönggon yogoc, “Amna auho oburo nocdec sihac. Noc kombihat, gesöna au noc nangmun fauna ongeyac.” ");
INSERT INTO yuw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yesuho ihoroc yuna owi wo ‘noc angit öp mait’ yongga kudat konoc konoc tongga Yesuho yangamin engmuna orungo forodec goruc yemoc tongga oburo Yesudec sigocma o obukocno karupgon imun fadocma worochon fatno owi amna ambarac inong taboc. ");
INSERT INTO yuw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ihoroc yong tauna Yesuho inogoc, “Wena, gocho kombing tobing namparocmaha tongga orokotaroc. Goc irot gucot onggoi.” ");
INSERT INTO yuw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Oro Yesuho abe mata yongo idina Yairusho bucinma amna auho engga Yairus inogoc, “Managumboca urop omec. Worocha goc fandat fandat amna ngo youp morö komanang imirocha.” ");
INSERT INTO yuw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ihoroc yuna Yesuho mata woroc kombingga Yairus inogoc, “Goc botirocha, goc kombing tobing namia weya orokontac.” ");
INSERT INTO yuw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ihoroc inongga Yesuho Yairusho bucin ongkungga böc ganang ögoc. Yu owi amna yang firiuna yu böc ganang maögung. Muno, Pita, Jön, Jems orin managumboc worochon macnin fanin yu worocgon yauna böc ganang ögung. ");
INSERT INTO yuw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Owi amna böc amante idungma yu managumboc worocha uroci kombingmuya yong ointongo idiya Yesuho inogoc, “Son ointoninga. Yu mamec, yu komanang dungo itac.” ");
INSERT INTO yuw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Inuna owi amnaho matano wo kombingga angyonggudung. Wömai yaha yu kombigung managumboc wo boinno sinom omecmaha angyonggudung. ");
INSERT INTO yuw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wohong Yesu yu managumboc owino worochon oburo sogida ingoroc inong yogoc, “Wena goc idongoi.” ");
INSERT INTO yuw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ihoroc inuna owi worochon yarunoho engmuna irotnon ohuna yu idonggoc. Idonguna Yesuho ‘nacno au imarut’ yongo inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Woroc tuna macnin fanintho wo angga soroc yogomoroc. Tuna Yesuho mata orongi inongo yogoc, “Son yapmu ngo öngkupacma worochon fatno owi amna au inodimorocha.” Yesu yu ihoroc yongo ‘muno’ inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Oro, Yesuho youp amnani 12 inong yuna ebung. Ehuya yuho owi amnadec dogu boyömo dong yanyanthon gesö orin obukoc foro ihono ihono dongyu orokoc orokochon gesö imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tongga yu inoin madec Kopotorochon toborucnohon fatmata owi amnadec yong fandat inoc inocha orin owi amna dongyu orokoc orokocha inong mudoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tongo yu youphon yong fasun fasun mata ingoroc inogoc, “Son uyaphon yapmu manomano au fogitninga. Woi uyaphon kandönghu o yochu o nacnohu o mönenghu yapmu ihorocno fogitninga. O tec tohomumuc soni wömai tungutnigon fogiarut. ");
INSERT INTO yuw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","O son böcsa au woce ongkuya böc morömpho sonthon idit böc au kamuyai son böc wocingon itmuya böc au mongurac toninga. Muno son wocingon idtongga son böcsa wo imu faangoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","“Oro son böcsa auhon onguya böc morömpho oröc matong kamuyai wömai sonu yu me imongo guroc tong fönfön orung sonidecma fororop tongyu muuya böcsa wo imu fauna ongonung. Ihoroc tuya böc morömpho kiap wo angga kombinahing, ‘Ayöö, non toroc kiap wontucmuno tong imogomonmaha tang yo.’” ");
INSERT INTO yuw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yesuho youp mata ihoroc inongga youp amnani inong muuna yu böcsa wohon wohon itongmuya fatmata ogepma owi amna yong fandat inong tonggung orin obukocnima dongyu orokogung. ");
INSERT INTO yuw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Oro, Galili provinshon gavman amna moröma king Heröt, yu Yesuho youp togocma worochon fatno kombigocmaha soroc yongga kombic kombic youp morö togoc. Amna auho wömai yongidung, ‘Kopotorocho Jön kumkumonma tun idonggoc yo’. ");
INSERT INTO yuw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","O auho wömai yongidung, ‘Yong tuctuc amna Elaiya yu öngkung nimogoc yo.’ Oro auho yogung, ‘Kopotorochon yong tuctuc amna osuc itongidungma yudecma tungu auho omocdecma wekongga bonip nonidec itongeyac.’ ");
INSERT INTO yuw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Oro owi amnaho ihoroc yong tonguya Herötho mata wo kombiun gorong gorong yuna yogoc, “Noc urop Jönthon bangaro magot. Worocha amna ngo yu numa sinom? Yu youpno foro au sinom tuna owi amnaho yuya kombihat.” Herötho ihoroc yongga Yesu acacha toup kombigoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Oro Yesuhon youp amnani yu youpno tu bödeuna ibaru fauna Yesuot engmuya youp togungmahon fatno inogung. Inongbödeuya Yesuho ‘nonigon itna’ yongo yu yangauna owi amna dongyu fauya böcsa au mano Betsaida woce onggung ");
INSERT INTO yuw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","mahong owi amna koböcmaho Yesu sa woce itacno kombingga yu tanda ehuya yangga Yesuho yu Kopotorochon toborucnohon fatmata fandat inogoc. Tongo owi amna obukocnima dongyun orokogung. ");
INSERT INTO yuw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yesu ihoroc tongga idina dobocsisi sepho urop ibaruna youp amnani 12 yu engmuya inogung, “Sa ngocinu wömai amna au maididang. Worocha goc muyu owi amna ngo inong muya yu böcsa woce woce ongmuya nacno nongga dubarut.” ");
INSERT INTO yuw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Youp amnaniho ihoroc inuya Yesuho yogoc, “Ihoroc muno, son sonibut nacno yangga tongfat yearut.” Inuna yuho yogung, “Non nacno sowarango obukema orin söng yai nacno worocgon itnimpac. Worochoi oro, gocho yia nontho ongga owi amna ambarachon nacno wöngga fepnam.” ");
INSERT INTO yuw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Sa wocin wömai amna 5,000 ihorocho idung. Oro ihoroc yuya Yesuho youp amnani inogoc, “Son owi amna wo soworeuya fuc tongga 50hon toroc dingno dingno idarut.” ");
INSERT INTO yuw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Inuna youp amnaniho owi amna worochon torocgon fuc tuya ambaracho omoc idung. ");
INSERT INTO yuw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Omoc idiya Yesu urop nacno sowarango obukema orin söng yai woroc fogitmuna momdec foringmun uuna Kopotoroc ecec inongo nacno uboda youp amnani imuna yuho silip tongga owi amna imong tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Woroc tuya ambaracho nongga modibo foc tongga idung. Tuya youp amnani nacno nong docno feng suran tuya dumbu 12 ihoroc oheuya foc togung. ");
INSERT INTO yuw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Bongono auho Yesu yu inogon dönac yongo idoc. Youp amnani yuhogon wömai yuot idung. Tuna Yesuho yu inong ac tongo yogoc, “Owi amnaho nocha tingting yongidang, noc numa yo.” ");
INSERT INTO yuw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ihoroc inuna yuho yogung, “Auho wömai gocha yongidang, ‘gocu Jön yamuc gung imocimoc amna’. O auho wömai yongidang, ‘gocu Elaiya’. O auho wömai gocha yongidang, ‘Kopotorochon yong tuctuc amna osuc idungma yudecma tungu au omocdecma wekongga itongeyac.’ Owi amnaho gocha ihoroc yongidang.” ");
INSERT INTO yuw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ihoroc yuya Yesuho wönggon inong ac tongo yogoc, “Owi amna wömai ihoroc yongidang mahong sonu nocha tingting kombiang? Noc numa yo?” Ihoroc inuna Pitaho ingoroc inogoc, “Gocu Duic, Kopotoroc Itonggong Morömo yuhon Manano.” ");
INSERT INTO yuw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pitaho ihoroc yuna Yesuho ‘mata wo owi amna au inoninga’ yongo ‘muno sinom’ yongga ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“Amnahon Manano yu muyu focfoc foro ihono ihono kombiangoc. Tuna Israel nanohon amna dugohu o öret socsoc böchon amna dugohu o nongoru gendic fandat fandat amnahu yu ambaracho me imongga wuya omengoc. Omong fauna sep bongono anfi idina yu wönggon omocdecma wekongga idongungoc. Kopotorocho yong torop ihoroc woroc yongo singdegoc,” Yesuho yong tuctucno ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tongo yu wönggon mata sakaun fiuna yogoc, “Amna auho noc nanantha kombinggai yu muyu inoin ibibo youn fat tongmuna bongono bongono ep goröcno sumbotmuna noc narun. ");
INSERT INTO yuw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kombiarut, amna auho inoin itonggongno guroc ngocin sogit akep toctocha tontacanu wömai yu itonggong koing tun muuna gorong ongontac. Wohong amna auho guroc ngorochon itonggongno ‘nocha’ yongo imun faantacma yu wömai itonggong koing aun feangoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Oro amna au yu gurochon möneng yoctec manomano ambarac inoha fogida feng suran tunai wömai yapmu worocho itonggong koing sogit sogitha tingting sinom tongfat yeun? Muno sinom, kiap ihorocnoho wömai yu matongfat yeic. Amna worocho wömai gorong ongungoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Kombiarut, amna auho nochahu o noc mata yogotmahu worocha yangam fap tuyai wömai mit Amnahon Manano wönggon ehangocan bongono wocin yu amna worocha ihorocgon yangam fap tongga me imangoc. Yu ehangocma woi inoin yaguno morömadec orin Fanohon yaguno gesöbaracma o ihorocgon sum yaruhon yaguno gesöbaracma worocot mitimni sinom ehangoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nocho boinno sinom kantiwa, amna au ngocin idangma yu abe mami idiya Kopotorochon toborucno ehuna anahing,” Yesu yu mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Oro Yesuho mata woroc yongbödeuna sep youp toctoc bongono 8thun idina Yesuho Pita, Jön Jems yu yangauna dönac yocyocha sa urongo au woce ögung. ");
INSERT INTO yuw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yu wocin öngmuya dönac yongo idiya Yesuhon yangamo mongura tongga kiapmo foro au idoc. O tec tohomunmucno worocho föc narap tongga idoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Woroc tongga idina amna yai Möse orin Elaiya yu ihorocgon mitimoni sinom engkungga Yesuot mata yogung. Yu wömai Yesuho Yerusalem woce sa guroc ngoroc imun faangocma worochon matano yogung. ");
INSERT INTO yuw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Oro Pitaot nucnin yaimaot yu daro mep tuna dupdupha kombigung mahong yu wekongga yagungmai Yesu orin amna yai yu yaguno gesönobarac möngga idina wocin idung. ");
INSERT INTO yuw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tuna amna yai yu urop Yesu imun fatfatha tunya Pitaho Yesu inogoc, “Moröma, non ngocin ogepma sinom idamonmaha nontho ngocin tac böc anfi tona. Auma wömai gochon, auma wömai Mösehon, o auma wömai Elaiya-hon.” Pitaho mata wo yogocma worochon forono wömai makombigoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitaho mata wo abe yongga idina mom auho engmuna yu tombuna botogung. ");
INSERT INTO yuw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tuna duc mata au mom tumocma ingoroc yogoc, “Ngoi nakain Manana. Nocho yu ‘nakain youp toun’ yongo soworegot. Sonu yuhon mata kombingga sumboditnung.” ");
INSERT INTO yuw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mata woroc yongbödeuna wönggon Yesu inohogon idina agung. Oro Yesuhon youp amnani yu kiap öngkubocma worochon fatno amna au bongono wocin mainogung. Oipmon wömai fatno wo yong tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Oro sa isuna Yesuot youp amnaniot yu sa urongo wo imu fauna ohongidiya owi amna koböcma sinompho yu yau fedung. ");
INSERT INTO yuw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yau feuya yuho bonipnodec amna tunguho Yesu dönac inongo ingoroc mambodoc, “Fandat fandat amna goc engmina nochon manana ahi. Yui nochon manana tungu sinom. ");
INSERT INTO yuw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dogu wontucmuno auho yuho irodin ohongitac. Ohuna mananaho yong yaingo kudat konoc konoc toup tongo irubo föhöcnoho öngo dugodec foc tongitac. Toroc kiap worocho wömai yu karupgon maimun faditac. Muno sinom, dogu wontucmuno worocho manana tun obukocno sinom tongitac. ");
INSERT INTO yuw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ihoroc tongo idina nocho youp amnayai ‘dogu wontucmuno woroc tararut’ yongo dönac inogot mahong yu tu matogoc,” amna worocho Yesu dönac ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tuna Yesuho yu inong fato yogoc, “Mayain, son owi amna torop gendöngni, son kombing tobic tobic soni maec. Nocu urop sa ubarago sonot itmaina önggöngyi soni sumboditat mahong sonthon kombing tobic tobic soni abe maitkamoc,” ihoroc yogoc. Tongo mit wabkarachon fano inogoc, “Manama yangat tepi.” ");
INSERT INTO yuw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ihoroc inuna managumboc Yesuot onggonga kombigoc mahong dogu boyömpho yu toup tongi tepi tong imuna gurodec möngga konoc konoc toup tongga kudatno koing sogung. Ihoroc tuna Yesuho dogu wontucmuno woroc inong fauna onguna managumboc wo orokogoc. Orokuna Yesuho wabkarac wo fano imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tuna owi amnaho Kopotorochon gesö inobarac wo angmuya soroc yongga nanga fatfat morö togung. Oro owi amna yu Yesuho manomano kiap inobarac sinom togocma worocha mata koböc yongo idiya Yesuho youp amnani ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nocho mata au kanoya son onggim ogepma siarut: Guroc amnaho wömai Amnahon Mananoha me imongmuya ayamphon oburodec tohong yunahing.” ");
INSERT INTO yuw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yesuho youp amnani ihoroc inogoc mahong mata worochon foro wömai öp idina youp amnaniho kombing tangtang matogung. Kombing tangtang matongga yu Yesu inong ac toctocha botongga öpgon idung. ");
INSERT INTO yuw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Oro oipmonu Yesuhon youp amnani yu ‘numaho mit moröma sinom engoc’ yongo mataho emoc togung. ");
INSERT INTO yuw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ihoroc yongga idiya yangga Yesuho yuhon irot kombic kombicnohon foro yang tangtang tongga managumboc obugu au sogida tehuna ino tan idoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Woce idina Yesuho youp amnani inogoc, “Amna auho nocha kombingga managumboc obugu ngorochon toroc yu tong ogep tong imontacma yu wömai noc tong ogep tong namontac. O nocgon muno yu ihorocgon Nandöngna yu tong ogep tong imontac. Yu worocho noc nanong muuna ebot. O amna au bonip sonidec madango sinom itacma yu worocho son ambarac kanggirada moröma sinom entac.” ");
INSERT INTO yuw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Oro Jöntho Yesu ingoroc inogoc, “Amna moröma, non amna au anaya yuho gochon mayadec dogu wontucmuno owi amnadec dong yandoc. Wohong yu nonthon toropdecma muno. Worocha non yuhon youpnoha bongbong sicsicha togomon.” ");
INSERT INTO yuw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jöntho ihoroc yuna Yesuho yogoc, “Kombiarut, amna auho son ayam maticma yui oröcsoni. Worocha son amna worochon youpha bongbong sininga.” ");
INSERT INTO yuw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Oro Kopotorocho Yesu sogida momdec tönggongon bongono urop eng fom togoc. Worocha tongga Yesuho ‘Yerusalem ongowa’ yongo kombingdegoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tongo yu youp amnani au manomano tong arangarang toctocha inong muuna yu osuc fat imongga ongga Samaria nanohon böcsa au woce ongkungga Yesuhon manomano tong arangarang toctocha togung ");
INSERT INTO yuw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","mahong muno woi, böc morömpho agungmai Yesuho Yerusalem onggonga togoc. Worochatongga yu Yesu ayam tong imongo yu yangada böcnon tonggonga ‘muno’ yogung. ");
INSERT INTO yuw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Youp amna yai Jems orin Jön yui Samaria nanohon toroc kiap wontucmuno wo angga Yesu inong ac tongga yogomoroc, “Moröma gocho kombiya wömai notho mom mambot inong yodaya ep aranggumpho ohuna torop ngo obukodarut.” ");
INSERT INTO yuw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ihoroc inogomoroc mahong Yesuho yuhon mataha kombiuna angit maidina inong fadoc. ");
INSERT INTO yuw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tuna yu böcsa auhon woce onggung. ");
INSERT INTO yuw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Oro Yesuot youp amnaniot yu uyapdec ongga idiya amna auho Yesuot engmuna inogoc, “Goc sa nahenne ongungorocma, nocu gocgon gan sogit tongungot.” ");
INSERT INTO yuw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ihoroc yuna Yesuho inogoc, “Arap yu yingonoha kombingidang o yup yu ihorocgon yingono idimang mahong Amnahon Manano yuhon dupdup abam wömai maec.” ");
INSERT INTO yuw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesuho ihoroc yongga wönggon amna au inogoc, “Goc engga noc nari.” Ihoroc inogoc mahong amna worocho yogoc, “Amna moröma, goc kombing namia noc ongga nandöngna oring singdengga mit wömai ehangot.” ");
INSERT INTO yuw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ihoroc inuna Yesuho inogoc, “Goc kombingbanac tirocha. Amna omimaho wömai nucni omima wo oring fiarut. Wohong gocu ongga Kopotorochon toborucnohon fatmata owi amnadec yong fandahi.” ");
INSERT INTO yuw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Oro Yesuho wönggon amna au inogoc, ‘Goc noc nari’. Ihoroc inuna amna worocho mata iban imongo yogoc, “Moröma noc goc gan tonggonga kombihat mahong goc kombing namia nocho ongga toropnai inongdengga mit wömai ehangot.” ");
INSERT INTO yuw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ihoroc yuna Yesuho yogoc, “Amna au stia sogitmuna metec foringitacma yu wömai nongnongo mangic. Muno, yui kandoc ongontac. Amna ihorocnoma wömai Kopotorochon toborucnohon youp toctochon toroc muno.” Yesuho ino tan tonggongon mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Oro mit Morömaho amna wego au 72 ihoroc yangsoworengga inong mudoc. Inong mudocma woi ‘yu yai yai böcsa ino mit onggonga kombigocan woce osuc fat imonung’ yongo inong mudoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tongo yu youphon yong fasun mata ingoroc inogoc, “Kombiarut, nacno koböcma sinom öndec gomondingga idang mahong woroc tonong fepfephon youp amna koböcma maeng. Worocha sontho ön morömoha dönac inuya yu youp amnani inong muuna nacno feng suran tontang. ");
INSERT INTO yuw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Son ongorut! Nocho son youp yunganoha masit. Muno, fup gumbocho singhon bonipnodec itongidangma worochon toroc wömai nocho son kanoya ongontang. ");
INSERT INTO yuw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sonu wömai mönenghu o yoc sonihu o orung tomsonihu woroc fogida fongoninga. O son owi amna uyapdec yangga mata ubarago inun ganun tongga bongono tong samborec toninga. ");
INSERT INTO yuw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Oro amna auho son böcnon kangat fuunai sontho böc moröm guram mata ingoroc inonung, ‘Kopotorochon irot guc sonot itun’. ");
INSERT INTO yuw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ihoroc inuya böc morömpho amna nongnongo idiyai wömai guram soniho yudec engoc. Wohong amna wo nongnongo maicanu wömai guram soniho ibarun fauna wönggon sonot engoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Oro son böc tungu wocingon iditnung. Böc mongurac tongo ngoce iti woce iti tongitninga. O böc morömpho nacno yamuc yaönoma kamonahingma worocgon nong tongonung. Youp amnaho wömai youphon wöngnacno sogihun.’” Yesuho ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tongo yu matano sakaun fiuna ingoroc yogoc, “Son böcsa auhon ongidiya böc morömpho engo böcnon kangat fongga nacno kamuya wömai sonu nacno wo nong tongonung. ");
INSERT INTO yuw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Woroc tongo son böcsa worochon owi amna obukocnima dongyu orokong tongonung. Tongo son fatmata ogepma ingoroc fandat inong tongonung: ‘Kopotorochon toboruc urop sonot engfom tac,’ ihoroc inonung. ");
INSERT INTO yuw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Oro son ongga böc auhon öngkuya böc morömpho son kangga böcnon makangat fuyai wömai sonu ongga böc worochon owi amnaho yangamin uyaphon tong fönfönno orung sonidec fakangyu muuya ingoroc inonung, ");
INSERT INTO yuw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Böc sonihon guroc tong fönfön tungugon wömai önggöngyi soniha orung nonidec icha. Kombiarut, Kopotorochon toboruc boinno sinom urop ambecgon eng tepac,’ ihoroc inonung. ");
INSERT INTO yuw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nocho boinno sinom kantiwa, Kopotorocho owi amna mata youpdec fohong yuangocan bongono wocin wömai böcsa ihorocnohon owi amna yu mepmo moröma sinom au feangoc. Mepmo worocho wömai Sodom böc mepmo sogidocma wo anggirada moröma sinom engoc,” Yesuho youp amnani ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesuho mata sakaun fiuna garac mata ingoroc yogoc, “Son Korazin orin Betsaida nano son soni woho! Nocho toroc kiap inobarac koböcma sinom sonthon bonip sonidec tongidot mahong sontho irot soni maibandung. Nocho toroc kiap sonot togotma wömai böcsa Tairhu o Saidonthu wocin toyai wömai worochon owi amnano inoin turongo yangga uroci morö sinom kombingga yong oin tongga ep ipmorop wagangga irotno ibandup tup. ");
INSERT INTO yuw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Worocha tongga Kopotorocho owi amna mata youpdec fohong yuangocan bongono wocin wömai sontho urago mepmo sinom au feangoc mahong Tair orin Saidon nano yuho mepmo obmugon sogitnahing. ");
INSERT INTO yuw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","O son Kaperneam nano, son tingting kombiang? Son onoce sinom itmuya ma moröma sogitnahinghu? Muno sinom, sonu wömai omoce sinom omimaho ididangan woce mönahing,” Yesuho garac mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tongo mit yu wönggon youp amnani inogoc, “Amna auho sonthon duc mata soni kombingga sumbentangma yu wömai nakain mata sinom sumbentang. O amnaho sontha me siantangma yu wömai nakaha me siantang. O ihorocgon amnaho nakaha me siantangma yu wömai Kopotorocha me siantang. Wömai yaha yu worocho noc nanong muuna ebotmaha,” Yesuho youp amnani youphon yong fasun mata ihoroc inongga inong muuna onggung. ");
INSERT INTO yuw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Oro amna 72 yu youpno tongbödengga ibaru fauna Yesuot ebung. Yuho wömai youp togungmaha irot ogep morö sinom kombingga borongdetmuya Yesu fat ingoroc inogung, “Moröma noni, osuc dogu wontucmuno yu nonthon mata masumbodidung mahong nonu gochon maya sogida inonaya yu nonthon duc noni sumboda onggung.” ");
INSERT INTO yuw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ihoroc inuya Yesuho yu inogoc, “Boinno sinom, son youp wo tongga idiya nocho agotmai, dogu kopotho undip wari wari simbang momdecma ohongga gesöno bödegoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kombiang, nocho son urop gesö moröma kamogot. Worocha tongga sonu koing songmuya gorom ingingohu o sibat foronthu wo yamberuya kegung mahong sonu maobukogung. Sonu ayam noni dogu kopot yuhon gesöno urop anggiraang. Worocha tongga yapmu auho son dongyun obukoc obukocno woi maic. ");
INSERT INTO yuw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Worochoi oro, dogu wontucmuno yu ducsoni sumbodungma woi yapmu moröma muno. Wohong Kopotorocho masoni kombingga momdec irim toctocyi idangma worocho woi yapmu moröma sinom, sonu worochahong borongdearut,” Yesuho youp amnani ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Oro bongono worochogon Kunkun Yaruho Yesuhon irot tun yungan tuna Yesuho kombing borong morö tongga Fano ingoroc inogoc, “Nandöngna, goc mom orin guroc ngorochon Morömo. Gocu gakain ibiba orin kombic kombic ogepma worocgon tanda gakain gesöhon foro youp amnayai komanangnoma wo indaia tuctugo kombiang. Yu woi managumboc simbang kombic kombicno moröma muno. Worochoi oro, kombic kombic amna moröma yuho gochon foro makombiing. Gocho yuhon daro dongyi sum fauya kombing tangtang mating. Nandöngna boinno sinom kiap ihorocnoho woi gochon irot kombic kombic ogepma,” Yesuho Fano yong moröng ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tongo yu wönggon yogoc, “Nandöngna yu wömai guroc ngorochon gesöno ambarac nocho une fohong fingbödegoc. Amna auho wömai inoin kombic kombicnodec wömai Mananohon foro makombiing. Muno Nandöngna yu tunguhogon wömai kombihac. O ihorocgon amna auho Nandöngnahon foro makombing imoc. Muno Manano yu tunguhogon wömai Nandönghon foro kombihac. O Mananoho amna yangsoworengga yuho yangamin ogep ima yuha wömai Kopotorochon foro tuctugo indaangoc.” ");
INSERT INTO yuw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Yesuho ihoroc yongga ibarun fauna youp amnani foring yangga yugon inogoc, “Kombiarut, osuc Kopotorochon yong tuctuc amnanihu o amna morömahu yu sontho önga manomano yaangma wo yacyacha toup kombigung mahong yu magung. Boinno sinom, sontho önga manomano yangma woi yapmu moröma sinom. Sonu wo yangga borongdearut. O ihorocgon sontho önga mata kombiangma woroc kombic kombicha osucno nanoho osuc toup kombigung mahong yu makombigung,” Yesuho youp amnani ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Oro oipmonu nongoru kombic kombic amna au yu idongga ‘Yesu toroc tonguc yeantat’ yongo ingoroc inong ac togoc, “Fandat fandat amna, nocu ting tongmaina itonggong koing aa feun?” ");
INSERT INTO yuw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ihoroc inuna Yesuho yu inong ac tongo yogoc, “Nongoru mataho itonggong koing sogit sogitha ting yac? Gocu wo embada tingting kombingitaroc?” ");
INSERT INTO yuw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ihoroc inuna Farisiho mata ökene ibanda yogoc, “Nongoru mataho ingoroc yac: ‘Son Moröma soni Kopotoroc, yuha toup kombingitnung. Son wömai irot sonihu o yaru sonihu o gesö sonihu o kombic kombic sonihu wo ambarac Kopotorocha bogiarut. O ihorocgon son soniha toroc kiap ogepmagon tong kamongidangma worochon toroc wömai son nucsoniha tong ogep tong imongitnung.’” ");
INSERT INTO yuw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ihoroc yuna Yesuho inogoc, “Goc boinno sinom yaroc. Ongga worochon torocgon toi. Ihoroc tongminai itonggong koing ai feangoc.” ");
INSERT INTO yuw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Oro Farisi yu Yesuhon mata wo kombigoc mahong yuhon kombic kombicdec angit maidocmaha yu Yesu wönggon inong ac tongo yogoc, “Nongoruho ‘nuca’ yacma wömai numaha sinom kombingga yac?” ");
INSERT INTO yuw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ihoroc yuna Yesuho mata fat au ingoroc iban imogoc, “Amna auho Yerusalem imun fauna Yerikö taun onggonga onggoc. Ongidina usem amnaho uyapdec gön tongga idiya amna wo ehuna sogida tec tohomunmucno orin manomanono ambarac fogitbödengga amna wuya gurocdec ohongga omompha tongo idoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ihoroc idina öret socsoc amna au yu uyap worochongon engga amna wo agoc mahong matongfat yegoc. Muno, yu angmun fauna uyap terodecgon ongga onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","“Woroc tuna mit amna au Levihon toropdecma yuho engga amna uroci wo agoc mahong ihorocgon matongfat yegoc. Yu uyap terodecgon ongga angmurat tongo onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tuna mit Samaria amna au yu ihorocgon uyap worochongon engga amna uroci wo angga irotnoho uroci morö sinom kombigoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Uroci kombingga yuot ongmuna unacot wain yamuot wedecnodec koring tongo wedecno tom tong imogoc. Ihoroc tongo amna uroci tun fadang uuna bang töngo bot donkino koroc tohong yungo yangat tongga kuin böc auhon tohong yugoc. Tongga woce yu ogepma sinom angtoregoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tuna kembotsum idina Samaria amna wo onggonga tongga kuin böc angtorec torec amna silwa möneng yai imongga inogoc, ‘Goc amna ngo ogepmagon angtorehi. Möneng yai gamotma angit maidunai wömai nocho mit wönggon engmaina möneng docno ubot gamangot.” ");
INSERT INTO yuw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Oro Yesuho fatmata wo yongbödengga nongoru kombic kombic amna ingoroc inong ac togoc, “Gocu ting kombiharoc. Amna torop anfidecma numaho sinom wömai amna uroci wo oröc oröc kiap tong imogoc?” Ihoroc yuna yuho yogoc, ");
INSERT INTO yuw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","“Wömai woroc, amna uroci tongfat yegocma, yu woroc.” Ihoroc yuna Yesuho yogoc, “Goc ongga toroc kiap worocotmagon tongidiruc.” ");
INSERT INTO yuw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Oro oipmonu Yesuot youp amnaniot yu uyapdec ongga böcsa auhon öngkubung. Böcsa woce wömai owi au mano Marta yu Yesu yangauna böcnon ögomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Öngga idinya owi worochon dano mano Maria, worocho engmuna Morömahon orungo forodec omoc itmuna onggimo yuhon mataha sigoc. ");
INSERT INTO yuw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Onggimo singga idina dano Marta yuhogon wömai mongorec youp moröma togoc. Worocha tongga yu ec imuna Yesu inogoc, “Moröma, dana ngo yu noc nangmun fauna nakagon youp morö sinom tat. Goc wo makombirochu nuhun? Gocho inia yu noc tongfat nehun.” ");
INSERT INTO yuw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yu ihoroc inogoc mahong Morömaho matanohon urago ingoroc iban imogoc, “Marta Marta, goc manomano koböcmaha kombingbanac tongitaroc mahong ");
INSERT INTO yuw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","yapmu tunguhogon wömai moröma iditac. Ahi, daya ngo, yu manomano soworengga yapmu moröma urop kombingdehac. Worocha nocho yu mainong muit,” Yesuho Marta ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Oro oipmonu Yesu inohogon itmuna dönac youp togoc. Dönac yongbödeuna youp amna auho yu inogoc, “Moröma, Jön yu inoin youp amnani dönac yocyochon foro fandat inongidoc. Worocha goc ihorocgon non dönac yocyochon foro ninong tuctuc toi.” ");
INSERT INTO yuw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ihoroc yuna Yesuho yogoc, “Son dönac soni kiap ingorocno yongitnung: ‘Sa Gapgap Nandöng noni, gochon maya nongnongo kunkun itun. Engga irot danong guroc danong moröm tong nimpi. ");
INSERT INTO yuw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Goc önga nacno noni toroc nonidec nimpi. O öngagon muno, bongono bongono. ");
INSERT INTO yuw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Goc wontucmuno noni imifat nimpun. Non ihorocgon amnaho wontucmuno tong nimingma yuhon wontucmuno imana fahun. Goc tonguc yecyecdec fohong nuirocha.’” ");
INSERT INTO yuw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Yesuho wönggon mata sakaun fiuna youp amnani inogoc, “Oro amna au yu uyap ubarago ongga kumbong bonip sinom nipnoho bucin ongkuboc. Tuna nipnoho yu acacha irot ogep kombingga nacno imocimocha kombigoc mahong nacno au maidoc. Worocha yu gop gada orugo ot ongmuna inogoc, ‘Oröc, nacno au nam. Nakain nipna urop epac mahong nocot nacno au maec.’ ");
INSERT INTO yuw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ihoroc inuna nipno koroc koroc imuna ingoroc inogoc, ‘Goc youp morö namirocha. Non simbu urop soamon. Nakahu o owi wabkarachu urop dungga idamon. Noc idongga nacno au angit magamit,’ ihoroc inogoc ");
INSERT INTO yuw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","mahong mit yu irot mongurac tongga nipno kombing imongo idongga nacno au imogoc.” Oro Yesuho yogoc, “Kombiarut, orugoho orugo nacno imogocma woi yu orugoha borongdedocmaha muno, wohong yu toup kiring imogocmaha tongga yu idongga nacno imogoc.” ");
INSERT INTO yuw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yesuho wönggon yogoc, “Sonu mata tepmo wo kombingga worochon toroc Kopotorocha dönac inongo kiriuya Kopotorocho son kombing kamontac. O son ‘yapmu ogepma ana fehun’ yongo yabic yabic youp tuyai wömai Kopotorocho tongfat keuna sonu wo au feantac. O son simbudec wagauyai, wömai Kopotorocho son simbu fagarit kamontac. ");
INSERT INTO yuw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Boinno sinom, amna Kopotorocha dönac inontacma yu wömai worochon boinno sogiantac. O amna yabi yabi youp tongitacma yu wömai yapmu wo aun feantac. O amna simbudec wagaantacma, yu wömai Kopotorocho simbu fagarit imontac. ");
INSERT INTO yuw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Son nandöng, sonu tingting kombiang? Managumboc soniho söngha kanunai wömai sondecma numaho gorom ingingo imontac? ");
INSERT INTO yuw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O fup modibha kanunai wömai sibat foron imontarochu? Woi muno sinom. ");
INSERT INTO yuw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Oro sonu wontucmuno toctoc amnahong managumboc soniha wömai yapmu ogepma imongidang. Worochoi oro, Nandöng soni momdec itacma yu ogepmagon. Worocha tongga owi amna au yu Kunkun Yaruha inong ac tontangma yuha wömai Kopotorocho Kunkun Yaru boinno sinom imontac,” Yesuho dönac yocyochon yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Oro, dogu wontucmuno auho amna audec itmuna amna worochon dugo mep tuna duc matano muno itongidoc. Ihoroc idina Yesuho yu dogu wontucmuno tan imuna yu duc mata wönggon yogoc. Ihoroc tuna owi amnaho woroc angga soroc yongmuya ");
INSERT INTO yuw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","amna auho yogung, “Dogu wontucmunohon morömo mano Belsebul yu Yesu gesö imuna dogu wontucmuno dong yanitac yo.” ");
INSERT INTO yuw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","O amna auho wömai Yesu toroc toctocha inogung, “Goc momphon toroc au tia ana.” ");
INSERT INTO yuw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ihoroc yuya Yesuho kombic kombicnohon foro angtangtang tongo ingoroc inogoc, “Kantri auho ficfuc tongo owi amna inohogon emoc tontanganu wömai kantri worocho obukontac. O ihorocgon böcsa au yu ficfuc tongga böc morömpho inoha emoc tontanganu wömai gesöno ohongga makoing sic. ");
INSERT INTO yuw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Oro, sonu nocha yang, nocho dogu kopot Belsebulhon gesödec dogu wontucmuno nucni dong yanitat. Wohong dogu kopothon toropni yu fuc tongga inoin nucni tarantanganu wömai yuhon gesöno ohongga koing socsocno main. ");
INSERT INTO yuw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Worochai oro Belsebulho noc gesö namuna nocho dogu wontucmuno dong yanitatanu wömai numaho torop soni tong fat kengo dogu wontucmuno dong yanidang? Kombiarut, torop soni yu inobut wömai mata soni angsoworengga yu bödeangoc. ");
INSERT INTO yuw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Wohong nocu wömai dogu wontucmuno Kopotorochon gesödec dong yanitat. Sonu wo angga ingoroc kombiarut, Kopotorochon toborucno urop soniot epac yo.” ");
INSERT INTO yuw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Yesu ihoroc yongga mit mata tepmo au ingoroc yogoc, “Amna koingo au yu gun tawano sogitmuna böcno angtoreantacanu wömai yoctecno manomanono ogep entang. ");
INSERT INTO yuw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wohong amna au gesöno koingo sinom yu engmuna yuot emoc tongga anggiraantacanu wömai yu böc morömphon gun tawa fogida yoctec manomanono ambarac yongo fongo nucni silip tong imontac. ");
INSERT INTO yuw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Amna au yu noc oröc matongnamicma yu ayam tong namontac. O amna auho suraro feng suran toctochon youpha noc matongfat neicma yu wömai suraro doun mointuya fuc tontang,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesuho dogu wontucmunohon yong tuctuc mata ingoroc yogoc, “Dogu wontucmunoho ingoroc tongidang, yu amna au imun fauna ‘idit sa ogepma sogiwa’ yongo sa moropmo wontucmuno woce itongontac. Woce itongmuna idit sa ogepma maun feuna yontac, ‘Noc ibara fauna böc ima fadocma woroc wönggon sogiwa.’ ");
INSERT INTO yuw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ihoroc yongga ibarun fauna ongga böc osuc ididocan woce engkungo aantacmai böc wo ogepma sinom ogut tangtang tuya itac. ");
INSERT INTO yuw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Woroc angga ongga dogu wontucmuno nucni 7 wontucmuno sinom yu yangada fengga böc wocingon entang. Woroc tuyai wömai woroc, amna wo yu osuc obmukusuc ogep bum idoc mahong mit wömai yu obukocno sinom tontac.” ");
INSERT INTO yuw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Oro Yesuho mata wo owi amna inongga idina owi auho suraro bonipnodec itmuna ingoroc mambodoc, “Owiho goc bangga mum gamogocma yu borongdehun.” ");
INSERT INTO yuw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ihoroc mambuna Yesuho yogoc, “Nochon macna yu woi owi ogepmahong owi amna Kopotorochon mata kombingga sumbodidangma yuho wömai boinno sinom borongdearut,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Oro owi amna koböcho Yesuot epgon tongga idiya Yesuho yogoc, “Guroc ngorochon owi amna önga idangma yui wontucmuno sinom. Yuho momphon weran inobarac au acacha yang mahong yu weran au maaing. Weran tungugon wömai Kopotorocho yu indauna anahingmai woi yong tuctuc amna Yönaho togocma worochon werano. ");
INSERT INTO yuw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Osuc wömai Yönaho toroc kiap au tuna Ninive nanoho angga tuctugo kombigung, Yöna yui Kopotorochon amna. Oro worochon torocgon wömai Amnahon Manano yu toroc kiap au tuna owi amnaho wo angga ingoroc kombiup, yui boinno sinom Kopotorochon amna itac. ");
INSERT INTO yuw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Oro, Saut kantrihon Kwin owi yu ‘Salomonthon kombic kombic ogepma sogiwa’ yongo uyap ubarago sinom onggoc. O önga wömai amna au Salomon angirahacma yu sonot itac mahong sontho yuhon mata kombic kombicha koroc koroc kamang. Worocha wömai Kwin owi worocho Kopotorochon mata youpdec idongga owi amna önga idangma yuhon mata yun bödeuna wontucmunohon urago sogitnahing. ");
INSERT INTO yuw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Oro Ninive taun worochon owi amna yu wömai Yönahon mata kombingga irotno ibandung. O önga wömai amna au Yöna anggirahacma yu sonot itac mahong sonu irot soni maibanidang. Worocha wömai Kopotorochon mata youpdec Ninive nanoho idongga owi amna önga idangma sonthon mata yu bödeuna wontucmunohon urago sogitnahing,” Yesuho mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesuho mata wönggon sakaun fiuna yogoc, “Amnaho gop gata wö ganang öp masingidang. Muno sinom, yuho wömai gop gata fadangdec eran singidang. Tuna yagunoho owi amna böc ganang idangma yaguno möng imontac. ");
INSERT INTO yuw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Worochon toroc wömai dan soni woi godibhon gop yaguno. Dan soniho ogepma entacanu wömai son angtangtang tongga irot soni yagunobarac entac. Wohong dansoniho obökuyai wömai irot soni kumbongdiantac. ");
INSERT INTO yuw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Worocha son muyu yaguno irot sonin itacma wo ogep angtorearut. Yaguno wo kumbong diicyit. ");
INSERT INTO yuw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Oro, yagunoho irot sonin foctongga entacanu wömai godip föp sonihon docno tungu au kumbongdec maic. Tuna itonggong soniho gop simbang yagunobarac entac,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Oro Yesu mata wo yun bödeuna Farisi auho yuot engmuna ‘nacno nana’ yongo inong wodigoc. Inong wodiuna Yesuho yuot ongga böc ganang nacno nocnoc abamdec omoc idoc. ");
INSERT INTO yuw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Omoc idina Farisiho agocmai, Yesu yu Yuda nanohon toroc kiap matandoc. Muno, yu yamuc magui komong omoc idoc. Woroc tuna Farisiho ‘Yesuho gendic noni yembotac’ yongo soroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Soroc yuna Morömaho ingoroc inogoc, “Kombihi, son Farisi amna son wömai kap godibodecgon sac toctocyi woroc simbang idang. Godip soni woi sacsago idang mahong irot sonidec wömai toroc kiap wontucmuno toup foc tongga idang. Son sonihagon kombingmuya suraro matongfat yengidang. ");
INSERT INTO yuw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Son amna bumbumyi. Kombiarut, Kopotorocho amnahon godibohu o irotnohu yait yait inohogon tobing figoc. ");
INSERT INTO yuw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Worocha son muyu irot soni amna urociha imongitnung. Ihoroc tuya wömai godip föp soni Kopotorocho yangamin ihorocgon sacsago entac. ");
INSERT INTO yuw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Farisi son soni woho! Sonu nongoru tantantha öndecma nacno obmu obmu römbohu o anianthu woroc sogida docno 10 silip tongga docno tungu Kopotorocha erangidang. Wohong Kopotorochon toroc kiap moröma wömai sonu matongidang. Woi owi amna tong ogep tong imocimoc kiaphu o owi amna toroc kiap nongnongo tong imocimoc kiap. Kiap wo wömai sonu matongidang. Son muyu nacno docno soni Kopotorocha imocimoc kiap orin owi amna tong ogep tong imocimoc kiap yait yait woroc tongitnung. ");
INSERT INTO yuw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Farisi soni woho. Sonu fatmata yocyoc bucin amna morömahon abamdec iditha wömai toup kombingidang. O maket taitdec owi amnaho ‘sep ogep sinom’ kanoc kanocha toup kombingidang. ");
INSERT INTO yuw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Son soni woho. Sonu kumkumon werano muno worochon toroc idang. Owi amna yu woce ongep tongga bet fadidang. Worochon toroc wömai sonthon kombic kombic soniho owi amna Kopotorocho yangamin dongyu bet fadidang,” Yesuho garac mata orongi ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tuna nongoru kombic kombic amna auho mata wo kombingga Yesu ingoroc inogoc, “Fandat fandat amna, goc mata wo Farisihagon yarocha woha nontha ambarac ninong moin moin tongga yaroc.” ");
INSERT INTO yuw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ihoroc yuna Yesuho yogoc, “Son gendic kombic kombic amna, son soni woho! Sontho owi amna mepmo moröma sinom imuya yuho wo sumbot sumbotha sorec tongidang mahong soniu obu soni sirago tungugon sinom mepmo woroc sumbot sumbotha matongfat yengidang. ");
INSERT INTO yuw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Soni woho! Sontho wömai Kopotorochon yong tuctuc amnanihon kumkumon simen ogepma sinom tobingidang. Wohong kombiarut, yong tuctuc amna wo wömai ombu sakung soniho dou ombung. ");
INSERT INTO yuw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sonthon öra soniho youp forosingga Kopotorochon yong tuctuc amnani dohuya omuya sontho wömai youpno sakau fiuna kumkumonno tongfada ogepma sinom tobingidang. Kiap worocdec wömai sonu toroc kiap wontucmuno ombu sakung soniho tongidungma woroc tong koing tongidang. ");
INSERT INTO yuw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Oro worochon mata wömai Kopotorocho kurömna sinom ingoroc yogoc: ‘Nocho wömai yong tuctuc amna orin aposel inoya onguya amnaho yangga auma fogida dongyu omuya o au wömai yanda toroc kiap wontucmuno tong imonahing.’ ");
INSERT INTO yuw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Worocha tongga Kopotorocho yong tuctuc amnani dongyu ombungma worochon urago owi amna önga idangma son iban kamangoc. Woi yong tuctuc amna osuc sinom dongyun ombungma engga önga dongyun ombungma worochon urago sonidec engoc. ");
INSERT INTO yuw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nocho boinno sinom kanoya kombiarut: Forosingga Abeldec engga Sakaraiya yong tuctuc amna ambarac worochon nogotno wömai sontho obu sonidec idina Kopotorocho urago tong kamangoc. Sakaraia wömai Kopotorochon öret socsoc böc wocin altadec ida ibarun fauna kunkun böc irotnon wocin onggonga tuna wot omom togung. ");
INSERT INTO yuw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Son nongoru kombic kombic amna son soni woho. Sonu Kopoto-rochon kombic kombic ogepma sogit sogithon simbu songmuya kino tomu onggoc. Boinno, son sonibut Kopotorochon uyap ogepma makombiing. O sontho owi amna Kopotorocot onggonga kombing-idangma yu bongbong singimuya gorong ongidang. Worocha soni woho.” Yesuho Farisi orin nongoru gendic fandat fandat amna yuha garac mata orongi ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu mata wo inongbödengga yu sa wo imun fauna onggoc. Tuna Farisi orin nongoru gendic fandat fandat amna yu bongono wocin forosingga Yesuha ayam toup tong imogung. Yu bongono muno Yesuot ongep tongga manomanoha toroc tong imocimocha inong ac tongidung. ");
INSERT INTO yuw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yu ‘Yesu yapmu au kandöc yuna sogida mata youpdec tohong yuantamon’ yongo yuha gön togung. ");
INSERT INTO yuw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Oro Yesuho Farisiha garac mata orongi yongga idina owi amna koböcma tausen tausen worochon toroc yu engmuya suran togung. Suran tongmuya auho nucni yamben yambenno togung. Tuna Yesuho forosingga youp amnani mata ingoroc ingoc, “Son Farisihon toroc kiap imanangniha acacho itongitnung. Yuhon toroc kiap orin duc matano woi yaitni tungugon muno. Toroc kiapmo wontucmuno ihorocnoho wömai yis simbang owi amnadec ohongmuna yu dongyun mointontang. ");
INSERT INTO yuw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Manomano tomnobarac itacma woi ambarac eran öngkungbödeangoc. O kombic kombic öpma woi Kopotorocho ambarac tun eran engoc. ");
INSERT INTO yuw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","O sontho mata kumbong inun ganun tongidangma wo wömai suraroho sepdec tuctugo kombing-bödenahing. O ihorocgon sontho böc ganang itmuya mata masang yogungma wo wömai mit auho böc taitdec suraro inong furang tuya tuctugo kombinahing,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesuho matano sakaun fiuna yogoc, “Oröcnai, nocho ingoroc kantiwa, sontho guroc amnaha botoninga. Yu ogep godip föp soni tong omom tup mahong yaru soni tu moin toctochon gesö wömai yu maidimoc. ");
INSERT INTO yuw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Worocha wömai son numaha sinom gending imongga botodarut? Woi Kopotoroc yu tunguhagon. Guroc amna yu wömai godip föp soni dong omom tontang mahong mit wömai Kopotorocho yaru soni ep bohöng woce tomun ongun. Boinno sinom, son Kopotoroc yu tunguhagon anggendingo botodarut. ");
INSERT INTO yuw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Kombiarut, non amna non yup obugu obuguha kombingidamon woi yapmu obugu sinom mahong Kopotoroc yu wömai yup obugu obugu tungu auha maedet imic. ");
INSERT INTO yuw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","O sontha tingting, sonu amna, son yup obugu wo yanggiraang. Worocha tongga Kopotorocho sontha maedet imic. Muno sinom, yu bic sakemsoni ambarac embat-bödehac. Worocha son botoninga.” ");
INSERT INTO yuw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesuho wönggon mata sakaun fiuna yogoc, “Nocho ingoroc kantiwa, amna auho nochon ma owi amnadec yong taantacanu wömai Amnahon Manano yu amna worochon mano Kopotorochon sum yaruho yangamin ihorocgon yong taantac. ");
INSERT INTO yuw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wohong amna auho nakaha yangam fapfap tongmuna möp yontacanu wömai nocho ihorocgon Kopotorochon sum yaruho yangamin yuha inong möpmöp tangot. ");
INSERT INTO yuw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Amna au yu Amnahon Mananoha mata metec yontacma worochon turongo wömai bödeangoc mahong amna au Kunkun Yaruha yong samborec yontacma worochon turongo wömai öngahu o mithu iditnoho iditno yudec engoc. ");
INSERT INTO yuw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Oro ayam soniho kangato Yuda nanohon fatmata yocyoc bucinthu o gavmanothu o amna morömaho yangaminthu woce mata youpdec fohong kunahing. Ihoroc tuya sonu yuha botongmuya ‘yaö mata urago imontamonthu o tingting sinom inontamonthu’ yongo kombingbanac toninga. ");
INSERT INTO yuw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bongono wocin wömai Kunkun Yaruho fasun kamongga ‘mata ihoroc ihoroc yarut’ yongo kanangoc.” ");
INSERT INTO yuw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Oro owi amna koböcma sinompho Yesuot suran tongmuya amna auho Yesu dönac ingoroc inogoc, “Fandat fandat amna, nochon nandöngna yu urop omboc mahong fim öresac wömai oröcnaho inohagon fogitdup togoc. Worocha gocho oröcna inia yuho silip tongga nochon fadu erangga noc nampun.” ");
INSERT INTO yuw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ihoroc inuna Yesuho mata urago ingoroc iban imogoc, “Tingting oro. Numaho ‘nocho sonthon mata soni ya bödehun’ yongo tohong nugoc? Nocu youp ihorocnoha maebot.” ");
INSERT INTO yuw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yesuho amna wo ihoroc inongga mit owi amna ambarac ingoroc inogoc, “Son soni woho, irot soniho yoctec möneng manomano worocdec ding fiicyit. Son manomano sonihagon fogit fogitha yang ibip toninga. Möneng yoctec manomano koböcma worocho wömai gakain itonggong ogepma matun öngkung gamic, muno sinom.” ");
INSERT INTO yuw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesu ihoroc yongga mit yoctec möneng feng suran toctochon mata tepmo au ingoroc yogoc, “Amna au mönengno koböc idimogungma yuhon öndec wömai nacno koböcma sinom öngkungga idung. ");
INSERT INTO yuw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ihoroc idiya yangga amnaho kombic kombic youp morö tongo yogoc, ‘Oro nocu ting tontat? Nochon böcna obugu worocha nacno ambarac woce feng suran toctocno woi angit matit.’ ");
INSERT INTO yuw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yu ihoroc kombingga wönggon yogoc, ‘Muyu, noc ingoroc tontat, noc nacno ficfic böcnai idangma wo ambarac gumanda böc moröma, moröma sinom temongma öhun. Temongma uuna nacno orin manomano yoctecna ambarac wo fogida wocin feng suran tangot. ");
INSERT INTO yuw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ihoroc toya idiya nocho borongdetmaina yontat, ‘Mayain, nocu amna moröma sinom, noc biruc bongono koböchon toroc nacno manomano ogepma ogepmagon itnamang. Worocha wömai noc sum sogida komong itmaina bongono muno nacno tong sonocgon tongo borongdeda engot.’ ");
INSERT INTO yuw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Oro yoctec amna yu ihoroc kombigoc mahong Kopotorocho yu inogoc, ‘Goc amna bumbumyi sinom. Önga kumbong ngorochagon wömai gocu omentaroc. Omentarocmaha manomano ambarac feng suran togorocma wo tingtingno sinom tongfat geantac? Muno woi gocho youp moröma sinom komanang togoroc’ Kopotorocho yu ihoroc inogoc.” ");
INSERT INTO yuw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Oro Yesuho mata tepmo woroc yongga mata worochon boinnoha wömai ingoroc yogoc, “Kiapmo worocho wömai owi amna gurochon manomano koböcma inohagon feng suran tongidangma yudec öngkuangoc. Yu wömai gurochon manomanogon idimang mahong Kopotorocho yangamin wömai yu uroci sinom itmuya yapmu orogoma au maidimic.” ");
INSERT INTO yuw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Oro mit Yesuho wönggon mata sakaun fiuna youp amnani ingoroc inogoc, “Nocho ingoroc kantiwa, son mata tepmo ono yatma worocha kombingmuya itonggong soniha kombingbanac tongga ingoroc yoninga: Oro yaöhong naantamon? O son godipföp soniha kombingbanac tongga ingoroc kombininga: Tec boru yaöhong tong faantamon. ");
INSERT INTO yuw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kombiarut, nacnohagon tongga son itonggong ogepma mau feic. O tec boruchogon godip föb soni matongfat keic. ");
INSERT INTO yuw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Son köec köec yupha kombiarut. Yu wömai nacno mamöngidang. O ihorocgon nacno oringga bucin fong suran matongitang mahong Kopotorocho yu nacno angitgon imongitac. O owi amna son wömai yup yanggiratno sinom tang. Worocha tongga Kopotorocho son ihorocgon angitgon kangtoreantac. ");
INSERT INTO yuw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Oro sondecma numaho sinom kombingbanac moröma tongmuna itonggongno obmugon sakaun fiun? ");
INSERT INTO yuw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Guroc amna non wömai ihoroc toctochon gesö maitnimic. Worocha son yapmu auha kombingbanac tongitninga! ");
INSERT INTO yuw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Kombiarut, yoröc bömbopho kombingbanac matongidang. Yuho boru bubup worochon foro makombing mahong tong fatfatno wömai ogepma sinom idimpac. Osuc king Salomon yuhon tec tohomumöcno koböcma sinom idimogung mahong saröc bömbopmohon tong fatfatnoho wömai Salomonthon tec borucno anggiratbödehac. ");
INSERT INTO yuw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Oro, owen wo wömai önga muyunoho idiya kembotgon amnaho faingo epin fongyu möngidang mahong Kopotorocho yu tongfatfatno ogepma sinom imongitac. O sonu wömai saröchon toroc muno, sonu amna. Worocha tongga Kopotorocho ogepma sinom kangtorengitac. Mayain, sonthon kombing tobic tobic soni obugu sinom yo! ");
INSERT INTO yuw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Son ‘nacno yamuc nahema sogida naantamon’ yongga kombingbanac toup tongitninga. ");
INSERT INTO yuw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bumbumyi nano yu wömai Kopotorochon foro makombing. Worocha tongga yu kombingbanac morö tongmuya gurochon manomanoha yabic yabic youp morö tongidang. Wohong sonu ihoroc toninga, Kopotoroc Nandöng soni yu urop kombihac, son yaö manomanoha docmöang. ");
INSERT INTO yuw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Son muyu ‘Kopotorocho moröm tong nimpun’ yongo irot soni yuha bogiarut. Son ihoroc tontanganu wömai Kopotorocho gurochon manomano ihorocgon angitgon kamangoc,” Yesuho kombingbanac toctochon matano ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yesuho mata sakaun fiuna ingoroc yogoc, “Nakain owi amna torop obugu, sonu botoninga. Nandöng soni yu urop ‘moröm tong kampiwa’ yongo mom toborucno ‘sontha’ yongo bogigoc. ");
INSERT INTO yuw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Son muyu yoctec manomano soni mönengha fiuya owi amnaho wuuya sonu wöngnacno amna uroci imarut. Ihoroc tuya wömai sonthon wöngnac soni momdec moröma engoc. Momphon wöngnacno wömai nogotno fatfatno muno o usem amnaho usem toctocno muno. ");
INSERT INTO yuw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kombiarut, goc kombiiya yapmu au moröma ogepma sinom itac. Ihoroc kombinggai wömai irodaho yapmu worochagon ibibo kombingmuna worocdecgon sakai fiantac.” ");
INSERT INTO yuw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesuho wönggon matano sakaun fiuna ingoroc yogoc, “Son youp toctocha boru soni tong docut tongga bot godip akep tarut. Son gop gangga tong arangarang tongga iditnung. ");
INSERT INTO yuw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Sonu amna morömahon youp wabkaracni simbang idarut. Amna moröma auho oimnahon tong sonocdec ida dongyun fauya böcnon eboc. Engmuna simbu wagauna youp wabkaracniho tong arangarang tongga ida karupgon simbu fagarit imogung. ");
INSERT INTO yuw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nocho boinno sinom kantiwa, amna morömaho engmuna yauna youp wabkaracni arangarang yongga entanganu wömai yu youp wabkarac yong moröng imuna borongdeantang. Tuya amna morömaho youphon boruno temongga youp wabkaracni ‘omoc idarut’ inongga nacno fengga imuna naantang. ");
INSERT INTO yuw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Oro amna moröma yu kumbong boniphu o fup sigo yongidinahu engmuna yaunai youp wabkaracni maduhi entanganu wömai woroc, amna morömaho youp wabkaracni inong borong tuna yu ogepma sinom entang. ");
INSERT INTO yuw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Oro kombiarut, böc morömpho usem amnahon ebep bongono tuctugo kombinggai wömai yu gön tongga idina usem amnaho böcno magumaric. ");
INSERT INTO yuw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","O worochon toroc son ihorocgon bongono muno gön tongga arangarang yongga iditnung. Wömai yaha, sonu yontang, ‘yu maehic’ mahong bongono wocingon sinom wömai Amnahon Manano ehangoc,” Yesuho arangarang yongga idithon mata tepmo ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ihoroc yuna Pitaho Yesu inong ac tongga yogoc, “Moröma goc mata tepmo yarocma woi nonihagon yarocha woha ‘owi amna ambarac kombiarut’ yongo yaroc?” ");
INSERT INTO yuw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Woroc yuna Morömaho mata urago ingoroc iban imogoc, “Oro, amna moröma yu wömai inoin youp wabkaracni soworengga youp wabkarac kombic kombicno ogepma orin youpno gacigon tongitacma yugon wömai youp morömaha soworengga youp mata ingoroc inontac, ‘Gocu youp wabkaracnai ambarac yangtorengga iti. Gocho yu bongono bongonodec yamuc nacno inoin inoin torocdec silip tong imiruc,’ amna morömaho youp wabkaracno ihoroc inontac. ");
INSERT INTO yuw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ihoroc inongga sa korungon ongga wönggon ibarun fauna böcnon engmuna auna youp wabkaracnoho youpno ogepma sinom togoc. Tuna amna morömaho youp wabkarac ihorocnomaha irot ogep tong imuna borongdetno sinom tontac.” ");
INSERT INTO yuw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yesuho ihoroc yongo yogoc, “Nocho boinno sinom kantiwa, amna moröma yu wömai böcnohu o yoctecnohu o manomano ambarac idimangma wo youp amna ogepma worochon oburodec fiuna yu wo ambarac yangtoreantac. ");
INSERT INTO yuw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Wohong youp wabkarac worocho ‘amna morömaho karup maehic’ yongo forosingga youp wabkarac nucni dong mongkengga obökuya yu inoho tong sonoc tongga wain yamuc nangga bumbum yontacanu ");
INSERT INTO yuw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","wömai amna morömaho bongono youp wabkaracno makombican wocin engga aantacmai youp wabkaracho etno itmuna tong bumbum tac. Tuna amna morömaho youp wabkaracno tun obukocno sinom tongga owi amna kombing tobic tobicno muno yuot tomun ongontac. ");
INSERT INTO yuw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Oro, youp wabkarac au yu amna morömahon youp mata kombihac mahong worochon toroc matichu o morömaha tong arangarang matichu wömai woroc, morömanoho engmuna ecego sinom toup wentac. ");
INSERT INTO yuw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Wohong youp wabkarac au yu amna morömahon irot kombic kombicno makombii toroc kiap wontucmuno tunai wömai amna morömaho yu obmugon wentac. “Wömai yaha, amna kombic kombic moröma idimangma yuho urago moröma tonung. Tuna Morömaho kombiantac, yui nochon youp amna ogepma. O ihorocgon amna manomano koböcma idimangma yuho urago youp moröma tonung. Ihoroc tuya Morömaho kombiantac, yui nochon youp amna ogepma,” Yesuho youp wabkarachon mata tepmo ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesuho yogoc, “Nocho ebotma woi ‘ep aranggum guroc ngocin öhun’ yongo ebot. O ep aranggum urop uunai wömai nocu borongdeam. ");
INSERT INTO yuw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Wohong osuc wömai nocho yamuc gupgup toroc kiap au inobarac sinom sogiwa. Önga noc wo abe masogii itmaina irotnaho toup mep tat. ");
INSERT INTO yuw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sonu ingoroc kombininga: Nocho ayam ayam kiap ta bödec bödecha guroc ngocin ebot. Muno sinom, nocho owi amna suraro tong fuc toctocha ebot. ");
INSERT INTO yuw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Önga forosingga wömai yomot macni fani obukemaho fuc tongga anfiho wömai yaimahon ayam tongga itnahing. O yaimaho wömai anfimaha ayam tongga itnahing. ");
INSERT INTO yuw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","O fanoho wömai mananoha ececgo angga engoc. O mananoho wömai fano ayam tong imongga engoc. O macnoho wömai wenoha ayam tongga engoc. O wenoho macnoha ayam tong imongga edengoc. O ihorocgon yan korama yu inohogon ayam ayam tongga idtahamoroc,” Yesuho inoin foroha ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Owi amna koböcma yu suran tongga idiya Yesuho inogoc, “Mompho sa tombuna sonu yongidang, ‘Urop komöc möantac.’ Ihoroc yunai komöcho boinno möantac. ");
INSERT INTO yuw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","O ihorocgon sum morömaho busongga mom muropmo fongunai wömai sonu yongidang, ‘Önga sepho toup diantamon.’ Ihoroc yuyai sepho boinno toup foriantac. ");
INSERT INTO yuw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Oro, son owi amna imanangni, son guroc orin momphon weranno angga tuctugo kombingidang, iho iho engoc. Worochoi Kopotorocho weran kamongitacma woroc wömai sontho angit mangsoworengidang.” ");
INSERT INTO yuw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yesuho yogoc, “Son sonibut toroc kiap yaönomaho wömai nongnong ogepma itacma, wo kombing soworearut. ");
INSERT INTO yuw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Oro amna auho goc mata youpdec tohong guuna yuot uyap ongmunyai goc ‘matana bödehun’ yongo kiring imia yun bödehun. Wömai yaha, mataya mayun bödeunai wömai yuho mata youpdec tohong guuna mata soworec soworec amnaho goc sogito tawa amnaho oburodec siantac. Woroc tuna tawa amnaho goc yi bucin tohong guantac. ");
INSERT INTO yuw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nocho boinno sinom kantiwa, goc yi bucin itmina yuho möneng namba ganangma woroc wuya wömai asan gamuya ongontaroc mahong möneng au maidgamuyai wömai woroc, gocu yi bucingon edengoroc,” Yesuho ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Oro, bongono wocinu amna au yu Yesuot ongmuya Galili nanohon fat au ingoroc inogung, “Gavmanthon amna moröma Pailat yu tawa amnani inuna onguya Galili amna au öret socsoc bucin öretno songga idungma yu dong omom tuya nogotnoho ohongga öretnohon nogotno worocot mongurec togoc.” ");
INSERT INTO yuw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Amnaho Yesu fat ihoroc inuya yu mata urago ingoroc iban imogoc, “Sonu tingting kombiang? Galili amna wo tawa amnaho dou ombungma yuhon wontucmunoho Galili nucni auhon wontucmuno yanggiradocmaha tongga urago kiap wontucmuno ihorocno yudec öngkuboc. Son ihoroc kombianghu nuhun? ");
INSERT INTO yuw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Muno sinom, nocho ingoroc kanoya kombiarut, son soniin irotsoni maibaruyai wömai son ambarac amna worocot gorong ongonahing.” Yesuho garac mata ihoroc inongga worochon docno au ingoroc sakaun fiuna yogoc, ");
INSERT INTO yuw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Yerusalem taun woce Siloam yamucdec wömai böc ubarago auho kodungga owi amna 18 ihoroc doun ombung. Oro sonu worocha tingting kombiang? Owi amna ombungma yuhon tong bumbumno moröma sinompho Yerusalem nano auhon tong bumbumno anggiradocmaha tongga böc worocho yu doun ombunghu nuhun? ");
INSERT INTO yuw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Muno sinom. Nocho boinno sinom kantiwa, son irotsoni maibaruyai wömai son ambarac amna worocot gorong ongbödenahing,” Yesuho irot iban ibantha mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu yu mata tepmo au ingoroc yogoc, “Amna au yu ep fik worochon yitno öndec mögoc. Ihoroc tuna sa ubarago idina amna worocho ‘ep koburo bariwa’ yongo eboc. Engo agocmai ep wo boinno muno idoc. ");
INSERT INTO yuw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ihoroc angga yu ön angtorec torec amna inogoc, ‘Kombiharoc, noc urop biruc anfi komanang ep ngorochon boinno baric baricha epat mahong ep ngoi boinno mafingitac. Worocha gocu ep ngo karupgon faingmi möhun. Yu guroc unacno komong wödicyit.’ ");
INSERT INTO yuw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ihoroc inuna youp amnaho mata öke ingoroc inogoc, “Moröma, abe, biruc tungu au idina nocho ep worochon forodec guroc oringga usengmaina totnongec fengo fongfingo aangot, biruc onomaho boinno fiuya wömai ogep engoc. ");
INSERT INTO yuw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wohong bongono worocho boinno mafiunai wömai nocho faingo toma ongungoc,” Yesuho boinno ficfichontha mata tepmo ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Oro Sabat bongono auho Yesu yu Yuda nanohon fatmata yocyoc bucin öngo owi amna fatmata ogepma fandat inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Oro böc wocin wömai owi auho idoc. Yudec wömai dogu wontucmuno auho biruc 18 ihoroc itmuna yu tun obukocno sinom tuna owi worochon meno tun gendöng uuna kotung mönggagon itongidoc. ");
INSERT INTO yuw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu yu owi woroc angga inong yuna ehuna inogoc, “Owi, obukoca urop bödeuna gocu orung itaroc.” ");
INSERT INTO yuw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ihoroc inongga oburo bigodec wot muuna wohogon owi worocho nongnongo idongga Kopotorocha yong moröng imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yesuho ihoroc tuna fatmata yocyoc böc worochon morömoho wo angga ec imogoc. Woi Yesuho owi Sabat bongonodec tun orokogocmaha ecimogoc. Ecimuna owi amna woce idungma ingoroc inogoc, ‘Sep youp toctoc 6 ihoroc wömai youp toctochon idang. Worocha sonu bongono wocingon engmuya Yesuho doun orokong kamun. Wohong Sabat bongonodec wömai ihoroc toctocno angit maec.” ");
INSERT INTO yuw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yu ihoroc yuna Moröma Yesu yu mata woroc kombingga ec imuna yogoc, “Son amna imanangni, mata soni orin toroc kiap soni woi tungugoni maec. Son ambaracho Sabat bongonodec wömai bot donkihu o bot bulmakauhu wo ‘nacno yamuc naarut’ yongga asanda taitdec yangato sumon fohongidang. ");
INSERT INTO yuw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Worochoi oro owi ngo yui Abrahamphon morogono. Tuna dogu kopotho yu sogit akep tuna biruc 18 ihoroc idoc. Worocha wömai nocho owi wo Sabat bongonodec ta orokuna dogu kopotohon yidec asan imogotma woi angit sinom.” ");
INSERT INTO yuw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesuho mata ihoroc yuna amna yu ayam tong imogungma yu ambaracho yangam fap togung. Tuna owi amna koböcmaho Yesuhon toroc kiap ogepma sinom wo yangga borongdedung. ");
INSERT INTO yuw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Oro mit Yesu ingoroc yogoc, “Kopotorochon mom toborucno wo tingtingno sinom, o nocho yaö mata tepmo kanoya sonu worochon foro kombiantang? Wömai ingoroc, ");
INSERT INTO yuw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","amna auho mastet yitno öndec mögoc. Ihoroc tuna yitnoho morö fato epno moröma idina yupho engmuya betomodec yingo tongga ididang.” ");
INSERT INTO yuw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesuho wönggon yogoc, “Nocho yaö mata tepmo siaya sonu Kopotorochon mom toborucnohon foro kombiantang? ");
INSERT INTO yuw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Woi yis simbang. Owi auho yis obmukusuc sogito flaua koböcmaot yamucot wo ambarac mongörec tuna yisho woroc tumoc ohongga flaua ambarac fogito tun out togoc,” Yesuho mom toboruchon mata tepmo ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Oro Yesu yu Yerusalem uyap ongmuna böcsa danong fatmata ogepma fandat fandat youp tong tonggoc. ");
INSERT INTO yuw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ihoroc itongga idina amna auho yuot engmuna inogoc, “Moröma, Kopotoroc yu itonggong koing owi amna tungutnigon imangocha woha amna koböcmaha imangoc?” Ihoroc inuna Yesuho owi amna ingoroc inogoc: ");
INSERT INTO yuw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kopotorochon midim sabarac sadec onggongon simbu wömai furango muno gogocnogon. Worocha wömai sonu sa woce onggonga toup kiringga youp morö tongitnung. Nocho boinno sinom kantiwa, owi amna koböcmaho woce onggonga toroc tongga tu matuna wocinu mangoning. ");
INSERT INTO yuw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Oro mithu wömai böc morömpho idongmuna simbu soangoc. Ihoroc tuna son böc amante omoce itmuya simbu wagangga dönac yongga mambotnahing, ‘Moröma, simbu fagarit nimpi,’ ihoroc mambotnahing mahong yuho ingoroc kanangoc, ‘Nocho son makombing kamot. Sonu nahema?’ ");
INSERT INTO yuw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Yu ihoroc kanuna sontho inonahing, ‘Ei nonu gakaot nacno yamuc nongidomon yo. O gakabut nonthon böcsa nonidec itongmina fatmata fandat ninong tongidoroc.’ ");
INSERT INTO yuw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Sonu ihoroc inonahing mahong yuho kanangoc, ‘Nocho urop kanot, son numari o son nahe ida ebang? Son wontucmuno toctoc owi amna son ambarac korungon ongorut!’ ");
INSERT INTO yuw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Yu ihoroc kanuna sontho yanahingmai, Abraham, Aisak, Jeköp o Kopotorochon yong tuctuc amna ambarac yu Kopotorochon midim sabarac sadec idiya yanahing mahong sonu wömai Kopotorocho karuna ongonahing. Ihoroc tuna sonu yong yaing tongga man soni siu tomuya itnahing. ");
INSERT INTO yuw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bongono wocin wömai owi amna tobuno, böcno böcno, kantrino kantrino yu ambaracho ehuya Kopotorochon midim sabarac sadec abam inoin inoin sogitmuya tong sonoc morö tonahing. ");
INSERT INTO yuw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Boinno sinom, owi amna önga osuc idangma yu wömai mit madango itnahing. O önga madango idangma yuho mit wömai osuc itnahing,” Yesuho mom midim sabarac sadec onggongon mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Oro bongono worochogon Farisi amna auho engmuya Yesu inogung, “Gavmanthon moröma Heröt yu goc gotomom toctocha yac. Worocha goc böcsa ngo imi fauna korungon ongoi.” ");
INSERT INTO yuw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ihoroc inuya Yesuho inogoc, “Heröt yui sap dunggit wontucmuno. Son yuot ongmuya ingoroc inarut: Nocho öngahu o kembothu owi amna dogu wontucmunonima o obukocnima yu woroc dongya orokonahing. O sep youp toctoc anfinodec wömai nocho youpna ta bödeangoc.’ ");
INSERT INTO yuw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kopotorochon yong tuctuc amna ambarac ididungma yu wömai Yerusalem wocegon idiya böc morömpho yu douya omongidung. Worocha tongga nocu öngahu o kembothu o yenthu uyap ongga Yerusalem öngkoya nuya omengot. ");
INSERT INTO yuw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yerusalem, Yerusalem kou sinom! Gochon owi amna yu Kopotorochon yong tuctuc amna dong omom tongidang. O amna Kopotorocho inong muuna gocot engidangma yudec wömai Yerusalem nanoho sop monda dou omongidang. Oro fup macnoho gumbogoni fotno une feng suran tongitacma worochon toroc wömai nocho bongono bongono gochon managumbocai feng suran toctocha kombigot mahong yu ihorocha makombiing. ");
INSERT INTO yuw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","“Kombiarut, taun soni ngorocho wömai obukongga komong engoc. O sonu sa ubarago noc manaigon itnahing. Ihoroc itmuya mit wömai sonu noc nangga yonahing: ‘Kopotorocho amna au inongmuna epac. Yuhagon wömai nonu yong moröng imona.’” ");
INSERT INTO yuw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Oro Sabat bongono auho Yesu yu nacno nocnocha Farisi amna moröma auho bucin ögoc. Woce wömai Farisi amna koböcma ida ‘Yesuho Sabat bongono yapmu au tuna aantamon’ yongo yu among fic togung. ");
INSERT INTO yuw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tuya amna au godibo out toctocyi yu Yesuot ambehecgon idina ");
INSERT INTO yuw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesuho yu angmuna Farisi orin nongoru kombic kombic amna inogoc, “Nongoruho amna Sabat bongonodec tun orokoc orokocha tingting yac? Nonu ogep tonampha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yesu ihoroc yuna Farisiho mata mayi komong ang onggom songga idiya Yesu yu amna wo sogito tun orokuna inongmuna onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yu ongga idina Yesuho Farisi inogoc, “Son bonip sonidecma managumboc sonihu o bot bulmakau sonihu yu yamuc gopma ganang ohuna sonu tingting tontang? Sonu ingoroc tontanghu, ‘Sabat sep kunkun bongono noni itacmaha yu wocegon itun’ yongo matongfatyeninga woha sontho yuha uroci kombingga wodiuya öantac?” ");
INSERT INTO yuw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yesu ihoroc yuna Farisiho öpgon itmuya mata uragoha dabigung. ");
INSERT INTO yuw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Oro, Yesu yu Farisiho bucin itmuna yagocmai, amna nacno nocnocha ebungma yu omoc idit abam yangsoworengga amna morömaha ficficyi woce iditha toup kombigung. Yesu woroc yangga mata ingoroc yogoc, ");
INSERT INTO yuw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Amna auho owi op tong sonoc morö tontac. Ihoroc tongga yuho goc nacno nocnocha ganong wodiunai wömai goc ongga omoc idit abam amna morömaha ficficyi woroc karupgon sogirocha. Wömai yaha, amna moröma sinom au yu ehuna ");
INSERT INTO yuw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","wömai tong sonochon morömoho gocot engmuna ingoroc ganicyit: ‘Goc abam ogepma ngo amna moröma ngorocha imia yu woce itun.’ Ihoroc ganuna wömai woroc, gocu abam wo amna moröma sinom yu imongo ongga amna komanang idangan woce itmina yangam fap morö tontaroc. ");
INSERT INTO yuw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Worochai oro amna auho goc tong sonoc toctocha ganong wodiunai wömai goc ongmina amna komanang idangan woce omoc iti. Woce idia tong sonochon morömoho gangga engmuna ganontac, ‘Oröc, goc engga amna morömahon abam ngo sogida wocin omoc iti.’ Ihoroc tuna wömai woroc gocu amna au idangma yuho yangamin ma morö sogiantaroc. ");
INSERT INTO yuw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Kombiarut, amna au yu inoha ‘noc amna moröma’ yongo kombiuna wömai Kopotorocho yu tohontac. O au yu inoha ‘noc amna auhon mongorec toctoc amna itiwa’ yongo kombiuna wömai Kopotorocho yu ma moröma imontac,” Yesuho ma moröma sogit sogitha mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tuna mit Yesuho wönggon Farisi nacno nocnocha inong wodigocma yu ingoroc inogoc, “Tong sonoc toctocha wömai gocho gakain nucaihu o nip oröcaihu o amna morömahu yugon inong wodirocha. Muno, yu wömai worochon ökene urago tong gamo-nahing. Worocha tongga kiap ihorocno woi Kopotorocho yangamin yapmu moröma muno. ");
INSERT INTO yuw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Wohong goc muyu amna urocimahu o amna obukocnihu o amna orungo wöntucmunohu o daro kom toctocyihu amna ihorocno wömai tong sonocha inong wodiruc. ");
INSERT INTO yuw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Yu wömai urago matoning mahong mit amna nongnongo idongonahingan bongono wocin wömai Kopotorocho worochon urago iban gamangoc.” ");
INSERT INTO yuw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Oro Yesuho ihoroc yuna amna au kondong wocin nacno nongo idocma yu Yesuhon mata kombingga inogoc, “Amnaho Kopotorochon midim sabarac sadec itmuya tong sonoc moröma tongga nanahingma yuho wömai borongdearut.” ");
INSERT INTO yuw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ihoroc yuna Yesuho mata tepmo au ingoroc iban imogoc, “Amna moröma au yu tong sonoc moröma tong arangarang togoc. Tongga yu ‘amna koböcho engga naarut’ yongo kombigoc. ");
INSERT INTO yuw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Oro nacno nocnoc bongono eng fomtuna yuho youp wabkaracno inong muuna ongga amna inong wodiima yu inong tonggoc, ‘Son ebarut, manomano ambarac urop arangarang yongbödec.’ ");
INSERT INTO yuw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ihoroc inong tonguna amna torop wo yu tungyu möcmöc mata koböc yogung. Tungu auho wömai yogoc, ‘Öngahemgon nocho ön morö au wöt. Worocha tongga noc muyu ongga woroc angsiwa. Goc amna moröma ingoroc inti, nocu tong sonocdec woce mangit.’ ");
INSERT INTO yuw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","O tungu auho wömai yogoc, ‘Öngahemgon noc bulmakau 10 ihoroc wöt. Worocha noc ongga toroc tongga aantat, bulmakau yu youp ogepma tontanga woha muno. Worocha noc gocho yarocan woce mangit.’ ");
INSERT INTO yuw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","O amna auho wömai yogoc, ‘Noc öngahemgon owi tongsit. Worocha gocho yarocan woce mangit.’ ");
INSERT INTO yuw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ihoroc yong tonguya youp wabkarac yu ibarun fauna ongga amna moröma mata yogungma wo inogoc. Inuna yu wo kombingga ec imuna youp wabkaracno wönggon inong muda yogoc, ‘Goc karupgon ongmina taunthon uyap macnodechu o uyap obugudechu woce ongga amna urocimahu o godibo wontöcmunohu o daro kom toctocyihu o orungo oburo gesöno munomahu amna ihorocnoma yangato böcnan fepi.’ ");
INSERT INTO yuw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Amna morömaho youp wabkarac ihoroc inuna yu ongmuna ibarun fauna engo amna moröma inogoc, ‘Gocho yarocma worochon toroc tongmaina epat mahong gochon böc wo abe mafoc tongga idina amna auhon bego wömai idang.’ ");
INSERT INTO yuw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ihoroc inuna amna morömaho youp wabkaracno wönggon inongmuto inogoc, ‘Goc taun ngo imi fauna uyap obugudec ongmina owi amna au yangmina yangato feia böcna foc tongga idarut.” ");
INSERT INTO yuw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yesuho tong sonochon mata tepmo ihoroc yun bödeuna matano sakaun fiuna yogoc, “Nocho boinno sinom kantiwa, amna osuc inong yogotma yuho nacno tugo obmukusuc au makombining,’” Yesuho tong sonochon mata tepmo ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Owi amna koböcho Yesu tan tonguya ibarun fauna yangmuna inogoc, ");
INSERT INTO yuw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Amna auho noc nan nantha kombinggai yu muyu irotno tong fup nocha bogihun. Non Mac nandöng noniha irot irot kombingidamonma worochon toroc muno. O non owi wabkarac nonihahu o nat oröcnonihahu yuha irot irot kombingidamonma ihoroc muno. O non itonggong noniha toup kombingidamonma worochon toroc muno. Amna au yu noc nan nantha kombinggai yu muyu wo ambarac ayam simbang yangmuna noc narun. Ihoroc maticanu wömai yu nochon youp amna sinom maic. ");
INSERT INTO yuw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","O ihorocgon amna au yu guroc ngorochon focfoc kombingmuna ep goröcno sumbotmuna noc manaricanu wömai yu ihorocgon nochon youp amna maic.” ");
INSERT INTO yuw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Yesuho wönggon ino tantanhon mata au ingoroc yogoc, “Amna auho böcno wego toctochai wömai yu osuc ‘mönengno angit itacha muno’ yongo yang soworeantac. Yangsoworeuna angit idina wömai yu böcno tongga karupgon tun bödeantac. ");
INSERT INTO yuw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wohong möneng angit maidimuna wömai yu böc forosiantac mahong mit yu mönengha döc möngga böcno matun bödeic. Tuna suraroho yu auya yangam fapfap tontac. ");
INSERT INTO yuw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Suraroho wömai yontang, ‘Ei amna ngo yu amna bumbumyi, yu böc toctocha togoc mahong angit matun bödec!’ ");
INSERT INTO yuw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“O ihorocgon king auho king auot emoc toctochai wömai yu osuc tawa amnani embatmuna kombiantac, ‘Nochon tawa amnanai 10tausen ihoroc idang mahong king aumahon tawa amnaniho wömai 20tausen ihoroc idang. Worocha noc ogep king aumaot emoc tongmaina yanggirampha woha muno’ yongo kombiantac. ");
INSERT INTO yuw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tongo yu kombiuna angit matoctocno idinai wömai yu ayamo abe korungon entangan amna au inong muuna yu ongga king au inontang, ‘Emoc matonin.’ ");
INSERT INTO yuw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Worochon torocgon wömai amna au sondecma yu inoin manomano me imongdup matonggai wömai yu nochon youp amna angit maic,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yesuho wönggon ingoroc yogoc, “Yip woi yapmu ibibo au mahong yiphon emocno bödeunai ting tonaya wönggon ibibo in? Nonu ihoroc angit matonin. ");
INSERT INTO yuw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yip sumo wömai youp au imocimocno maec. Muno, wo tomi ongoun. “Amna au onggimobarac ida wömai yu mata ngoroc tuctugo kombihun.” ");
INSERT INTO yuw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Oro, Yesuho mata ihoroc yongbödeuna takis fogit fogit amna orin wontucmuno toctoc amna koböcmaho ‘Yesuhon mata tuctugo kombina’ yongo ambehecgon engmuya Yesu angareng-gumbec tongga idung. ");
INSERT INTO yuw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ihoroc tuya Farisi orin nongoru gendic fandat fandat amna yu kombiuya obökuna inohogon yogung, “Ei amna ngomai wontucmuno toctoc amnaot oröc tongo nacno kondong nongitac.” ");
INSERT INTO yuw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ihoroc yuya Yesuho mata tepmo ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Sonotma amna auhon bot sipsipno 100 ihoroc idimang. Tuna bot sipsip tungu au korungon ongga gorong onggoc. Oro sonu tingting kombiang? Amna wo yu bot sipsipno 99 woroc sa ogepmadec dongyun fauya ongga tungu gorong onggocma worocha yabiuntha woha muno? ");
INSERT INTO yuw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nocho boinno sinom kantiwa, amna wo yu yabing tongga ongga angmuna irot ogep moröma kombiantac. Tongo wo sogito yarugodec sumboda bucin tengmuna ");
INSERT INTO yuw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","nip orugi o suraro ambarac yu inuna eng suran tuya ingoroc inontac, ‘Son ambarac nocot borongdetna. Nochon bot sipsip au gorong onggocma wo urop ango tehat.’” ");
INSERT INTO yuw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yesu mata tepmo ihoroc yongo yogoc, “Nocho boinno sinom kantiwa, worochon torocgon wömai wontucmuno toctoc amna tungu auho inoin turongo yangga irotno ibarunai wömai momdec worocha borongdetdet moröma sinom öngkungitac. Wohong amna 99 yu inoha kombiuya ‘nongnongno idamon’ yongo yuha wömai borongdetdet maöngkuic, yaha yu irotno iban ibantha makombiingmaha.” ");
INSERT INTO yuw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesuho wönggon mata sakaun fiuna mata tepmo au ingoroc yogoc, “Oro, owi au yu möneng docno 10 ihoroc idimuna docno tungu au böc ganang gorong onggoc. Gorong onguna owi yu ingoroc tontac. Yu gop gatmuna böc ganang totnongec ogutho yabic yabic youp tongo mönengno wo aantac. ");
INSERT INTO yuw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Angmunai nip orugi o suraro ambarac inuna ehuya inontac, ‘Nochon mönengna gorong onggocma wo wönggon aa fehac. Worocha non ambarac borongdetna.’ ");
INSERT INTO yuw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Oro wontucmuno toctoc amna au yu irotno ibarunai wömai toroc kiap ihorocnogon onoce Kopotorochon sum yaruniot öngkungitac.” ");
INSERT INTO yuw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu yu mata tepmo au ingoroc sakaun fiuna yogoc, “Amna auot mananin yaiot idung. ");
INSERT INTO yuw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tuna manano mitma yu fano ingoroc inogoc, ‘Nandöng, goc möneng fim öresac manomano erangga nakain fat noc namiruc.’ Ihoroc inuna fanoho manomanono soworengmuna silip tongga mananin yai wo imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Ihoroc tuna maubaraki idina manano mitma yu möneng yoctecno fogitmuna kantri auhon korungon woce ongga idoc. Woce itmuna yu önggöngyi toroc kiap toup tongmuna mönengno manomano idimogocma wo tong samborec tongo bödeng sigoc. ");
INSERT INTO yuw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ihoroc tuna mönengno bödengina kantri wocinmaho nacno möp morö öngkuuna amna wo urop manomanoha docmögoc. ");
INSERT INTO yuw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Worocha tongo yu ong-muna kantri worochon morömo auhon youp amna idoc. Tuna amna morömaho ‘bot yangtorehi’ inongo inong muuna botho bucin onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yu woce ida nacnoha toup docmögoc mahong amna auho yuha uroci kombingga nacno au maimongidung. Tuna yu bothon nacno wontucmuno nocnocha kombigoc. ");
INSERT INTO yuw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Oro yui uroci sinom idocmaha tongga yu wontucmunono tuctugo sinom angmuna ingoroc kombigoc, ‘Nandöngnahon youp amnani yu nacno koböcma sinom nongidang. Wohong nocu wömai ngocin itmaina nacnoha tong uroc morö sinom tat. ");
INSERT INTO yuw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Worocha noc muyu sa ngo ima fauna nandöngnaot ongga nandöng ingoroc inontat, Nandöng, noc Kopotoroc orin gocho yangamin toroc kiap wontucmuno sinom togot. ");
INSERT INTO yuw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Worocha wömai gocho noc ‘manana ogepma’ ihoroc nanirocha muno sinom, nocho gochon youp amnagon entat.’ ");
INSERT INTO yuw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Oro yui ihoroc kombingga idongo fano ot onggoc. Ongga abe korungon idina fanoho yu urop angga uroci morö kombingo domdomgon ongmuna manano bang sogito ducin ducin togoc. ");
INSERT INTO yuw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ihoroc tuna manano fano inogoc, ‘Nandöngna, gocho yangamin orin Kopotorocho yangamin wömai nocho toroc kiap wontucmuno sinom togot. Worocha gocho noc ‘manana ogepma’ ihoroc wönggon manairoc.’ ");
INSERT INTO yuw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mananoho fano ihoroc inogoc mahong fanoho youp amnani inong yuna ehuya inogoc, ‘Son karupgon nakain tec tohoma-möcna ogepma wo tengga manano ngo tohomumöng impun. O ihorocgon oburo siragodec ring au siarut. O orungodec orung tom au sing imarut. ");
INSERT INTO yuw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ihoroc tongga mit ongga bot bulmakau beracno toup macfihacma wo woda tong sonoc moröma tona. ");
INSERT INTO yuw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Wömai yaha, manana ngo yu urop omong fadoc mahong itonggongno wönggon aun fehacmaha. O yu urop gorong onggoc mahong nocho yu wönggon aa fehac.’ Oro fano ihoroc yuna youp amnani worochon toroc tongmuya yu tong sonoc tongo kumec tongga idung. ");
INSERT INTO yuw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Oro bongono worochoi orugo borongoma yu öndec ida youpno imun fauna engmuna böc ambehecgon ida kombigocmai fanohon youp amnani yu tong kumec tongo ap woda yong keröt karöt yogung. ");
INSERT INTO yuw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ihoroc kombingga yu youp amna au inong yuna ehuna inogoc, ‘Son woi yaö tang?’ ");
INSERT INTO yuw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ihoroc yuna youp amnaho inogoc, ‘Oröca yu ibarun fauna wönggon ehacmaha nandöngaho yuna non bot bulmakau beracno wot samon. Wömai yaha, oröca yu wönggon ibarun fauna engga batip itacmaha. Fansodiho wömai irot ogep morö kombihac.’ ");
INSERT INTO yuw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Orugo borongoma yu mata woroc kombingga irotno kombut morö tongo bucin maögoc. Ihoroc tuna fanoho ‘irot ececno tohowa’ yongo taitdec ohongga mata inogoc mahong ");
INSERT INTO yuw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","manano yu fanohon mata makombii ingoroc inogoc, ‘Tingting oro. Biruc koböcma sinom noc mongorec toctoc amna simbang gochon youp morö sinom tongmaina focfoc kombing tengga gochon duc mafodingidot. Worochoi oro gocu nocha nucnaiot tong sonoc toctochon bot meme gumboc au manamogoroc. ");
INSERT INTO yuw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wohong manama wo yu owi uyap-decmaot itongmuna gochon möneng yocteca tong samborec tongmuna wönggon ehac. Tuna goc ‘yuha’ yongo bot bulmakau toup macfihacma woroc woda siya worochon tong kumecno tang.’ ");
INSERT INTO yuw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ihoroc inuna fanoho mata ökenne ingoroc iban inogoc, ‘Manana goc bongono muno nocot iditaroc. Worocha nochon manomano ambarac woi gochon fat itdup tang. ");
INSERT INTO yuw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Worochoi önga bongono ngo wömai non ambaracho borongdetna. Oröca wo yu urop omboc mahong itonggongno wönggon aun fehac. Yu gorong onggoc mahong wönggon engkupac,’” Yesuho yomot fani anfihon mata tepmo ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Oro, Yesu yu youp amnani mata tepmo au ingoroc inogoc, “Amna moröma au möneng manomano koböcma sinom idimogocma yuhon youp wabkaracno au idoc. Youp wabkarac wo yu amna morömahon böcnon manomano yangtorengidoc. Tuna oipmonu amna auho amna morömaot engmuya youp wabkaracha mata metec ingoroc inogung, ‘Youp wabkarac ngo yu wömai gochon manomano tong samborec tongitac yo’. ");
INSERT INTO yuw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ihoroc inuya amna morömaho youp wabkaracno inong yuna ehuna inogoc, ‘Gocha mata wontucmuno au yuya kombihatma woi tingting? Gocu nochon youp wabkarac wönggon mairoc. Karupgon ongga gakain youphon yongburoc bapiya tong arangarang tongga teia nocho gochon youphon foro aantat.’ ");
INSERT INTO yuw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Amna morömaho ihoroc inuna youp wabkaracho soroc yongga ingoroc kombigoc, ‘Mayain, amna morömaho noc youpdecma nan nantha yac. Worocha ting towa? Ön youp toctochon gesöno wömai angit maitnamoc. O nocho amna au ‘möneng komanang nampun’ yongo inong ac toctocha yangam fapfap tontat. ");
INSERT INTO yuw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Worochoi oro, nocho ingoroc tongga ogep entat: Nocho amna auhon möneng butogo wo saring imoya yu oröc tong namonahing. Ihoroc tuya mit amna morömaho narantacan wömai yuho ino bucin nangat tongonahing.’ ");
INSERT INTO yuw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Oro youp wabkarac ihoroc kombingga amna tungu tungu inuna ehuya amna morömahon möneng docno tingting abe urago maimogungmaha woha inong ac togoc. ");
INSERT INTO yuw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ihoroc inong ac tuna amna osuc ebocmaho inogoc, ‘Noc oliv unac dram 100 ihoroc abe urago matogot.’ Ihoroc yuna youp wabkaracho inogoc, ‘Ahi, ngo gochon butogo bapiya. Wo sogitmina dram 100 iho irim toctocyi itacma wo sac woda 50 gon ihoroc irim toi.’ ");
INSERT INTO yuw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ihoroc tuna mit amna auho ehuna youp wabkaracho inogoc, ‘Goc butogoya tingting itac? Ihoroc inuna amna worocho yogoc, ‘Nochon butogo wömai wit bek 100 ihoroc itac.’ Ihoroc yuna youp wabkaracho inogoc, ‘Karup, goc butogo bapiya ngo sogitmina wit bek 80 ihorocgon irim toi.’” ");
INSERT INTO yuw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Oro Yesuho mata tepmo wo yun bödeuna wönggon yogoc, “Youp wabkarac wo yu toroc kiap imanangni togoc mahong yu ino tongfat yecyechon foro ogepma sinom kombigoc. Boinno sinom owi amna guroc ngorochon toroc kiapdec itongidangma yu wömai nucniot toroc kiap kombic kombicbaracho tongidang. Yu wömai yagunohon owi amna yanggiradidang. ");
INSERT INTO yuw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Worocha nocho ingoroc kantiwa: Son guroc ngocin möneng soni youp imongga nuc soni tong ogep tong imongitnung. Tongo sonthon oröc soni koböc itnahing. Ihoroc tongga möneng youp toctochon bongono ngo bödeunai son momphon böc ogepma sogitnahing,” Yesuho möneng youpha ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Yesuho wönggon yogoc, “Oro amna au yu manomano obugu ogepma sinom yangtorengitacma, yuho wömai manomano moröma woi ihorocgon ogepgon yangtoreangoc. Wohong amna au yu yapmu obugu angit mangtorengitacma yuho wömai yapmu moröma ihorocgon angit mangtoreic. ");
INSERT INTO yuw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Worocha son guroc ngorochon möneng manomano angit mayangtoreningma wömai sonu momphon manomano tingting sinom yangtorenahing? ");
INSERT INTO yuw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","O ihorocgon son amna auhon manomano tobingga angit mayangtorengidangma wömai Kopotorocho momphon manomano tingting sinom kamangoc? Woi angit matoning. ");
INSERT INTO yuw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Youp wabkarac au yu amna moröma yaihon une itmuna matano yaityait kombingga youp angit toctocno wömai maec. Muno, youp wabkarac yu wömai amna moröma auha ayam tongga aumahagon irotno imangoc. O ihorocgon amna moröma auha wömai yu tongfat yeangoc mahong aumaha wömai yu me imangoc. Worochon toroc wömai sonu ihorocgon Kopotorocha orin mönengha yu yaityait mongorec tong imocimocno woi maec. Muno sinom, moröm soni wömai Kopotorochu o mönenghu tunguhogon entac,” Yesuho ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Oro, Farisi yu mönengha toup kombingidung. Worocha tongga yu Yesuho mönengha mata yogocma wo kombingga irotno ec imuna Yesuha mata metec yogung. ");
INSERT INTO yuw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ihoroc yuya Yesuho inogoc, “Sonu toroc kiap ogepma tuya owi amnaho kangmuya kombingidang, son amna nongnongo sinom. Wohong Kopotorocho irot soni angsoworengga gendöngni itac. Manomano amnaho kombiuya ogepma sinom itac worocho wömai Kopotorocho yangamin wontucmuno sinom iditac.” ");
INSERT INTO yuw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yesuho yogoc, “Mösehon nongoru mata orin Kopotorochon yong tuctuc amnaho mata yogungma worochogon wömai itonggong nonihon bongbongo ida ongga Jöntho eboc. Jöntho ebocan bongono wocin forosingga mom toboruchon fatmata ogepma böcsa danong fandat inong tonguya owi amna ambaracho mom midim sabarac sadec onggonga kiringga youp morö tongidang. ");
INSERT INTO yuw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Worochoi oro Kopotorochon nongoru mataho wömai mabödeic. Muno sinom, mom sa guroc gorong ongontahamoroc mahong Kopotorochon nongoru matahon irim docno tunguhogon wömai magorong ongic. ");
INSERT INTO yuw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Worocha amna auho oweno fodingmun onguna owi au tongsiantacma yu wömai Kopotorochon nongoru mata fodingga owi göra tontac. O ihorocgon amna auho owi au osuc opnoho imun fadocma yu tong siantacma woi ihorocgon Kopotorochon nongoru fodingga owi göra tontac,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesuho mata fat au ingoroc yogoc, “Oro möneng amna au idoc. Yu wömai bongono muno tec tohomunmöcno ogepmagon fohong yunmuuya itongidoc. Yuhon itonggong kiapnohu o böcnohu o nacno nongidocmahu wo ambarac ogepma ogepma sinomgon ididoc. ");
INSERT INTO yuw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","“Oro yu ihoroc idina yuhon böc simbunodec amna uroci au mano Lasarus yu wocin ididoc. Yu wömai ‘möneng amna worochon nacno föro föro nawa’ yongo woce torengga ididoc. O yuhon orung oburo woi wedec nogot bomtahogon tongga idiya sapho engo erop tongga ongidung. ");
INSERT INTO yuw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Oro mit amna uroci Lasarus yu omboc. Omuna sum yaruho yu sogito tongo Abrahamot wocin tohong yugung. Yu woce idina möneng amna yu ihorocgon omboc. Tuna oringsigung. ");
INSERT INTO yuw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Oring siuya yu sa wontucmuno ep bohöng woce itmuna focfoc moröma sinom kombingga idoc. Tongo yu foringmun uuna agocmai Abraham yu korungon onoce sinom idoc. O Lasarus yu Abrahamot kondong wocin idomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Tongo möneng amna yu mamboc tongo yogoc, ‘Nandöng Abraham! Goc nocha uroci kombingmina Lasarus inia oburo karamutnodec yamuc tangmuna tengo monbinnadec siuna sum fahun. Noc ep moroc ngocin itmaina focfoc morö sinom kombihat.’ ");
INSERT INTO yuw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ihoroc yuna Abrahampho yogoc, ‘Manana, goc abe wec idorocan bongono wocin wömai gocho manomano ogepmagon fogididoroc. O Lasarus yu manomano wöntucmunogon fogididoc. Wohong önga wömai yuho sa ngocin ogepma sinom itac o gocu wömai focfoc inobarac sinom kombing idtongungoroc. ");
INSERT INTO yuw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","O yapmu au wömai ingo. Non bonipnonidec Kopotorocho öngkorip moröma au tong sigoc. Worocha nonotma amna auho öngkorip wo gacmoto sonot onggongno wömai maec. O ihorocgon sonotmaho öngkorip wo gacmoto nonot ebepno woi maec.’ ");
INSERT INTO yuw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Abrahampho ihoroc yuna möneng amnaho yogoc, ‘Abraham nandöng, noc oröcnai awanomuno idang. Worocha goc muyu Lasarus inongmuiya yu nandöngnaho bucin ongmuna oröcnai garac mata inuna yu itonggong kiapmo mongurac tonung. Mongurac tongga yu focfoc sa ngo au fetningyit.’ ");
INSERT INTO yuw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ihoroc yuna Abrahampho yogoc, ‘Möse orin Kopotorochon yong tuctuc amnaho mata yogungma worocho wöami idang. Idiya oröcaiho mata wo embatmuya worochon toroc itongitnung.’ ");
INSERT INTO yuw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ihoroc yuna möneng amnaho wönggon yogoc, ‘Abraham nandöng, ihoroc angit makombining. Wohong amna omimaho kumkumon imun fauna ongga inunai wömai yu ogep irotno ibanda kombing tobinahing.’ ");
INSERT INTO yuw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ihoroc yuna Abrahampho yu inogoc, ‘Kombihi, oröcai yu Möse orin yong tuctuc amnahon mata makombinggai wömai yu omimahon matano ihorocgon makombing tobining,’” Yesuho Lasarushon mata fatno ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu yu youp amnani wönggon garac mata ingoroc inogoc, “Son ingoroc kombiningyit, wontucmuno toctochon bongono urop bödeantac. Muno sinom, toroc kiap foro ihono ihono worocho öngkungmuya owi amna singo toroc tong imuya turongodec mönahing. Son soni woho, amnaho wontucmuno toctochon uyap owi amna fandat inontangma yu wömai mepmo moröma sinom au feangoc. ");
INSERT INTO yuw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Amna auho owi amna singo dongyu mönahingma yu wömai urago mepmo inobarac sinom au feangoc. Bangarodec sop mepmo akep tongga top ganang fonyu mönahingma woi yapmu mepmohong amna wo wömai urago inobarac sinom au feangoc. ");
INSERT INTO yuw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Foro worocha tongga son itonggong soni angsoworec soworecho itongitnung.” “Oro, oröcaho turongo au tunai wömai gocho ‘muno’ inti. Ihoroc inia yuho irotno ibarunai wömai gocho yuhon turongo wo imi fat impun. ");
INSERT INTO yuw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Oro oröcaho sep youp toctoc tungu wohon irotnon toroc wontucmuno bongo 7 ihoroc tong gamongga mit worocha uroci kombingga bongo 7 ihoroc ibarun fauna ‘turongo imi fat nampi’ yongo gocot ehantacma wömai woroc, gocho yu angbanango turongono dongyi fat imonung,” Yesuho turongo dongyun fatfatha ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesuhon youp amnaniho Yesu inogung, “Moröma noni, goc muyu nonthon kombing tobic tobic noni ti morö fahun.” ");
INSERT INTO yuw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ihoroc yuya Yesuho inogoc, “Kombing tobic tobic soni obugu sinom, ep mastet worochon yitno simbang idkamontacanu wömai son ogep ep ngo iniya yuho mata soni sumboda foro fonsirango detmuna ongga top yamuc ganang woce entac.” ");
INSERT INTO yuw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesu yu wönggon youp wabkarachon foroha mata sakaun fiuna ingoroc yogoc, “Son tingting kombiang, amna au son bonip sonidecma yu youp amnano youpha inongmuna ongga ön bang toctochahu o bot sipsip yangtorec torechahu youp ihorocno tongga ibarun fauna wönggon bucin ehuna gocho ingoroc inontarocha: ‘Goc engo nocot omoc ito nacaya ngo nahi.’ ");
INSERT INTO yuw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Muno sinom, gocho youp wabkarac wömai ingoroc inontaroc: ‘Goc ongga nochon nacana tong arangarang tong fingga boru sacsago temongmina nacana geto yongo feng nampi. Nocho osuc nongdeaya mit wömai gaka nahi,’ ihoroc wömai inontaroc. ");
INSERT INTO yuw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“O ihorocgon, gochon youp wabkaracho gocho youp imogorocma wo ambarac tun bödeunai wömai gocho yu ‘ecec moröma’ ihoroc inontarocha woha muno? Woi muno sinom. ");
INSERT INTO yuw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Oro worochon toroc wömai sonu ihorocgon Kopotorocho youp mata kamogocma wo tongbödengga ingoroc yongitnung: ‘Nonu youp amna komanangno, manomano tamonma ngo wömai nonin youpgon tamon, woi yapmu moröma muno,’” Yesuho ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Oro Yesu yu Yerusalem onggonga uyap bonip ongga Samaria orin Galili distrik worochon taunnodec öngkungga sa woce itonggoc. ");
INSERT INTO yuw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tongo yu böcsa auhon ongkungga idina amna 10 obukoc lepra toctocyi yu Yesu au fedoc. Yu obukoc lepra togungmaha Yesuot ambehecgon maebung, muno yu obmukusuc korungon bum idongmuya ");
INSERT INTO yuw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ecnang mambodung, “Yesu amna moröma, goc nontha uroci kombihi.” ");
INSERT INTO yuw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ihoroc yuya Yesu yu yangmuna inogoc, “Son ongmuya godip soni öret socsoc amna indaarut.” Ihoroc inuna yu ibaru fauna ongidiya wohogon godibodec obukoc wo bödeuna sacsago idung. ");
INSERT INTO yuw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ihoroc tongmuya amna torop wodecma amna tungu yu agocmai godibo orokogoc. Tongo yu ibarun fauna mambot tengo Kopotoroc yong moröng imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ihoroc tongo Yesuot engmuna orungo forodec goruc yemoc tongga ecec moröma inogoc. Amna wo yu Samaria sadecma. ");
INSERT INTO yuw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Oro Yesuho amna woroc angmuna yogoc, “Nocho amna 10 yu tong sac tong imot mahong amna ngo yu tunguhogon ibarun fauna epac yo. Amna 9 yu nahe onging? ");
INSERT INTO yuw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Yu ibaru fauna engmuya Kopotoroc yong moröng imocimocha makombing. Amna tungu ngo yuhogon wömai epac. O yu Israel amna muno, yui Samaria amna.” ");
INSERT INTO yuw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ihoroc yongo Yesuho amna woroc inogoc, “Goc idongmina ongoi. Kombing tobic tobicaho goc tun orokotaroc,” ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Oro, Farisi yu Yesu ingoroc inong ac togung, “Bongono yaödec wömai Kopotorochon toborucno ehangoc?” Ihoroc inuya Yesuho mata ökene ingoroc iban imogoc, “Kopotorochon mom toboruc woi guroc ngorochon toroc muno. Woi inobarac sinom, dantho acacnohon toroc maehic. ");
INSERT INTO yuw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","O owi amnaho ingoroc woi mayoning: ‘Ngo ahi, ngoce itac, o okoce itac’. Muno sinom, Kopotorochon toboruc wömai irot sonin orin bonip sonidec woce itac.” ");
INSERT INTO yuw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesu ihoroc yongo mit youp amnani inogoc, “Boinno sinom, oipmon wömai sonu Amnahon Manano acacha toup kombinahing mahong maning. ");
INSERT INTO yuw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","O amnaho wömai imanang kanonahing ‘aarut yu okoce itac,’ o au yonahing ‘yu ngoce itac.’ Yu ihoroc yong tongonahing mahong sonu yuhon mata kombing tobininga. ");
INSERT INTO yuw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kombiarut, Amnahon Mananohon ebep bongonoho wömai undip wari warihon toroc engoc. Momdec onoce forosingga ongga ökenne bödeuna yaguno wariuna owi amna ambaracho tangtango sinom angmuya kombinahing, urop bongono morö epac yo. ");
INSERT INTO yuw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","“Worochoi oro, Amnahon Manano yu osuc focfoc morö foro ihono ihono kombiuna guroc amnaho yu me imuya mit wömai ehangoc. ");
INSERT INTO yuw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Amnahon Mananoho ehangocan bongono wocin wömai owi amnaho toroc kiap Nöahon bongonodec tongidungma worochon torocgon tongga itnahing. ");
INSERT INTO yuw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nöahon bongonodec wömai owi amnaho etno idiya nacno yamuc nahi owi imun gamun toi ihoroc tongga idiya ongga Nöa yu girang ganang uuna yamuc öngkorop ohongo owi amna dongbödegoc. Kiap ihorocnohogon wömai Amnahon Mananohon ebep bongonodec engoc. ");
INSERT INTO yuw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Oro Lothon bongonodec wömai toroc kiap worocotmagon idoc. Owi amna yu etno itmuya inoin inoin youpno tongga idung. Auho wömai nacno yamuc nango idiya o auho wömai manomanono tong wöngnac tongo idiya o auho wömai ön youp tongga idiya o auho böcno wego toctocha tongo idung. ");
INSERT INTO yuw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ihoroc tongo idiya Lot yu Sodom taun wo imun fauna ongidina momdecma sop kobun au mano salfa worocho ep dicdicyi yamuc mönmön simbang ohongmuna owi amna dongyun bödegung. ");
INSERT INTO yuw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Oro toroc kiap ihorocnogon woroc wömai Amnahon Mananoho engkup engkup bongonodec engoc. ");
INSERT INTO yuw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Bongono wocin wömai amnaho ‘yoctecna bucin idangma fogiwa’ yongo kombininga. O amna auho öndec engocma yu yapmu au sogit sogitha ibarun faicha. ");
INSERT INTO yuw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sonu Lothon owenoha kombiarut, yu metec forigocmaha omong fadoc. ");
INSERT INTO yuw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Worocha amna au yu guroc ngorochon itonggong sogit akep tontacmai yuhon itonggong sinom wömai momdec möng wengoc. Wohong amna au yu inoin itonggongno guroc ngocin imun faantacma yuho wömai itonggong koing aun feangoc. ");
INSERT INTO yuw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Nocho ingoroc kantiwa: Amnahon Manano ehangocan kumbong wocin wömai amna yai yu abamdec dungo idinya tunguma wömai nocho sogiangot o tunguma engoc. ");
INSERT INTO yuw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","O ihorocgon owi yaiho nacno sowarango socsocha tongo idinya tunguma wömai nocho sogiangot o tunguma engoc.” ");
INSERT INTO yuw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesuho mata ihoroc yuna youp amnaniho yu inong ac tongga yogung, “Moröma, manomano ngo nahe öngkuangoc?” Ihoroc yuya Yesuho yu inogoc, “Arap omimaho idangan sa wocegon wömai singho arenggumbec tongidang. Toroc kiap worocotma wömai yapmu wo eran sinom öngkuuna anahing.” ");
INSERT INTO yuw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesuho youp amnani inogoc, “Son bongono muno dönac yocgon yongga karup imu fadicha.” Ihoroc inongga worochon mata tepmo ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Böcsa auhon woce mata soworec soworec amna au idoc. Yu wömai Kopotorochahu o amna auhahu yu magending imongidoc. ");
INSERT INTO yuw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Oro böcsa wocingon wömai owi kapi au idoc. Yu wömai amna morömaot epgon tongga ingoroc inongidoc: ‘Gocho mata youpdec tongfatnengga nochon mata nongnongo tobiia ayamnaho koing sicyit.’ Yuho bongono muno mata ihorocgon inong tohongidoc. ");
INSERT INTO yuw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tuna amna morömaho osucha yu tongfat yecyecha makombigoc mahong mit wömai yu ingoroc kombigoc: ‘Noc Kopotorochahu o amna nucnaihahu yu magending imongitat mahong ");
INSERT INTO yuw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","owi ngo yu bongono muno noc youp morö namongitac yo, worocha noc muyu yu tongfatyewa. Matongfat yeitma wömai yu nocot epgon tongo ina noc koroc koroc namontac.’” ");
INSERT INTO yuw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yesuho mata tepmo ihoroc yongga youp amnani wönggon inogoc, “Son mata soworec soworec amna gendöngni yuhon mata wo kombingga ");
INSERT INTO yuw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","tingting kombiang, owi amna Kopotorocho inoha soworec soworecyi yuho sepno sepno o kumbongno kumbongno Kopotorocha dönac orongi inuya Kopotorocho yuhon mata kombingga matongfatyeichu nuhun? Woi muno sinom. ");
INSERT INTO yuw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yu woi karupgon sinom tongfat yeantac mahong mit Amnahon Mananoho wönggon ehangocan bongono wocin wömai owi amna yuha torengga itmuya kombing tobing imonahingha woha muno?” Yesu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Oro, amna au yu nucniha kombiu saha yuna inohagon kombiuya, ‘Non amna nongnongo ogepma idamon yo.’ Yu ihoroc kombing-idungmaha Yesuho yuha mata tepmo au ingoroc yogoc, ");
INSERT INTO yuw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Amna yai yu dönac yocyocha öret socsoc bucin ögomoroc. Amna tunguma woi Farisi o amna tunguma woi takis möneng fogit fogit amna. ");
INSERT INTO yuw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Öng-munya Farisi yu idongga dönacno ingoroc yogoc, ‘Kopotoroc, nocu amna nongnongo ogepma sinom. Worocha noc ecec gantat. Owi amna au yu wömai usem toroc kiaphu o wontucmuno toctoc toroc kiaphu o youp görac ihoroc tongidang mahong nocu ihorocno muno. O amna ngo yu takis möneng fogit fogit youp tongitac mahong nocu yu simbang muno. ");
INSERT INTO yuw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nocu wömai sönda danong sep youp toctoc yai nacnoha gendic singmaina nacno möp iditat. O ihorocgon manomano au fogiditatma wo woi ihorocgon docno 10 fingmaina docno tungu Kopotoroc gocha bogingitat.’ ");
INSERT INTO yuw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Oro Farisiho ihoroc yuna takis fogit fogit amna yu obmukusuc korungon bum idongmuna inoha kombigoc, ‘nocu amna wontucmuno’ ihoroc kombingga daro dedec mafori kunduro wagango dönacno ingoroc yogoc, ‘Kopotoroc, nocu wontucmuno toctoc amna worocha gocho noc nang banango irot guca nampi.’” ");
INSERT INTO yuw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesuho mata tepmo ihoroc yun bödeuna yogoc, “Noc amna yaimaha ingoroc kantiwa: Takis möneng fogit fogit amna yu Kopotorocho yangamin nongnongo itmuna böcnon onggoc mahong Farisi yu ihoroc muno. Amna koböcho inoha kombiuya öantacma yu wömai Kopotorocho tohontac. O au yu inoha kombiuna ohontacma yu wömai Kopotorocho töngga ma morö imangoc,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Oro owi amna au yu managumboc obugu yangato ‘Yesuho oburo yudec out fohoun’ yongo Yesuot febung. Ihoroc tuya Yesuhon youp amnani yu woroc yauya yuhon kombic kombicdec angit maina owi amna wo inong fadung. ");
INSERT INTO yuw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Wohong Yesu yu managumboc wo inong yuna yuot ehuya youp amnani inogoc, “Sontho managumboc nocot ebepha bongbong sing imoninga, muno yu muyu nocot ebarut. Kopotorocho wömai mom toboruc owi amna managumboc simbang ima yuha bogigoc. ");
INSERT INTO yuw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nocho boinno sinom kantiwa amna au yu Kopotorochon toboruc managumboc simbang masogiicanu wömai yu midim sabarac sadec mangic,” Yesuho ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Oro amna dugo au yu Yesu ingoroc inong ac togoc, “Fandat fandat amna ogepma, nocu ting tongga mit itonggong koing aa feangoc?” ");
INSERT INTO yuw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ihoroc yuna Yesuho inogoc, “Goc yaha noc amna ogepma ihoroc nantaroc? Kopotoroc yu tunguhogon woi ogepma. ");
INSERT INTO yuw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Worocha gocu yuhon nongoru mata ngo sumbotmina worochon torocgon itongidiruc: ‘Goc owi göra tirocha, goc amna wot omom tirocha, goc usem tirocha, goc mata youpdec amna auha mata imanang firing tarirocha, o goc mac nandönga gending imongidiruc. Nongoruho wömai ihoroc itac.” ");
INSERT INTO yuw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yesuho ihoroc yuna amna dugoho yogoc, “Noc abe obugu itmaina forosingga nongoru mata wo ambarac tanmaina engga önga itat.” ");
INSERT INTO yuw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesuho mata woroc kombingmuna yu inogoc, “Goc abe yapmu tunguhagon wömai docmöharoc. Goc ongmina yoctec manomanoya ambarac imun gamunthon uyapdec fingga möneng woroc wömai owi amna urociha silip tong imiruc. Goc ihoroc tontarocanu wömai momphon itonggong ogepma gochon fat entac. Oro mit wömai engga noc nari.” ");
INSERT INTO yuw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yesuho ihoroc yuna amna dugoho mata woroc kombingmuna irotno toup mep togoc. Yaha, yu yoctecno möneng manomano koböcma idimogungmaha togoc. ");
INSERT INTO yuw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu yu amna dugo worochon kombingbanacno angmuna mata ingoroc yogoc, “Amna möneng yoc tecno koböcmaho wömai mom midim sabarac sadec onggonga mep tongidang. ");
INSERT INTO yuw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Boinno sinom, bot kamele yu somayang ganang onggongno woi maec. O worochon torocgon wömai amna yoctecno koböc idimangma yu Kopotorochon toborucdec onggonga tu matangoc.” ");
INSERT INTO yuw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yesuho ihoroc yuna amna mata woroc kombigungma yu soroc yongga yogung, “Mayain, goc ihoroc yarocma wömai amna tungu au itonggong koing maun feun.” ");
INSERT INTO yuw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ihoroc yuya Yesuho yogoc, “Manomano amnaho matoctocno woroc wömai Kopotorocho ogep tuna boinno engoc.” ");
INSERT INTO yuw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ihoroc yuna Pitaho Yesu inogoc, “Kombiharoc, nonu manomano noni ambarac dongyana fauya goc gandomon.” ");
INSERT INTO yuw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ihoroc yuna Yesuho inogoc, “Nocho boinno sinom kantiwa, amna au yu böcnohu o owi wabkaracnihu o niporugihu o macni fanihu woroc dongyun fauya Kopotorochon toboruchon youp tontacma ");
INSERT INTO yuw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","yuha wömai Kopotorocho manomano dongyun fadungma worochon urago bongo koböc urop guroc ngocin imontac. O mit bongono morömadec wömai yu itonggong koing sogiangoc,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Oro Yesu yu youp amnani 12 yugon yangada sa aramo ökene fongga ingoroc inogoc, “Kombiarut, non urop Yerusalem taun öantamon. Tuna Kopotorochon yong tuctuc amnaniho osucgon Amnahon Mananoha mata irim togungma wo ambaracho boinno öngkupnahing. ");
INSERT INTO yuw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Yerusalem taun woce wömai Yuda nanohon amna dugo yu Amnahon Manano sogit akep tongo bumbumyi nanohon oburodec siuya yu inong saha tongo, imanang yong kömec yongo, irubo yudec sunda, bokotdec wotmuya wuya omengoc. ");
INSERT INTO yuw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Omongga ida sep youp toctoc anfinodec wönggon wekongga idongungoc.” ");
INSERT INTO yuw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yesuho yong tuctuc mata ihoroc youp amnani inogoc mahong yu mata wo kombing tuctuc matogung. Muno, mata worochon foro wömai öp sicsicyi idina yu tuctugo makombigung. ");
INSERT INTO yuw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Oro Yesu yu Yerikö taun ambehecgon ongidina amna daro kom toctocyi au yu uyap tan woce itmuna owi amna möneng yoctecmaha dönac inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ihoroc tongga itmuna onggim singga kombigocmai owi amna torop moröma epgon tongga idung. Ihoroc tuya amna daro kom toctocyiho ‘wo yaö tang’ yongo owi amna inong ac tuna ");
INSERT INTO yuw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","inogung, “Yesu Nasaretma yuho epac yo.” ");
INSERT INTO yuw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ihoroc inuya amna daro kom toctocyiho forosingga mamboda yogoc, “Yesu, Devithon Morogo, gocu nocha uroc gampun!” ");
INSERT INTO yuw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yu ihoroc mamboda idina amna osuc ebungmaho ‘öpgon iti’ yongo inong fadung mahong muno, yui kiringga ecnang sinom mamboc tongo yogoc, “Devithon Morogo, gocu nocha uroci kombihi.” ");
INSERT INTO yuw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ihoroc mambuna Yesuho wo kombingga onggom songga owi amna inogoc, ‘amna wo, yangat tebarut,’ ihoroc inuna amna daro kom toctocyiho yuot ehuna Yesuho inogoc, ");
INSERT INTO yuw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Goc ‘nocho ting tong gampiwa’ yongo mambot nantaroc.” Ihoroc yuna yuho yogoc, “Moröma noc danna foric foricha kombihat.” ");
INSERT INTO yuw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ihoroc yuna Yesuho inogoc, “Dara wo orokong gampun, kombing tobic tobicaho tuna orokotaroc.” ");
INSERT INTO yuw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ihoroc inuna wohogon daro orokuna yu dan foric tongga Yesu tantongmuna Kopotorocha inong kumengo yong moröng imogoc. Tuna owi amna au yu ihorocgon Yesuho kiap togocma wo angga forosingga Kopotorocha yong moröng imogung. ");
INSERT INTO yuw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Oro, mit Yesuho Yerikö taun öngkungga woce itonggoc. ");
INSERT INTO yuw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tuna amna au mano Sakius yu taun wocin idoc. Yu wömai taun Yerikö worochon takis möneng fogit fogit amna idungma yuhon morömano idoc. Tongo yu möneng yoctecno koböcma sinom idimogung. ");
INSERT INTO yuw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Oro Sakius yu Yesu acacha toup kombigoc mahong owi amna koböcma sinompho Yesu arenggumbec tongga toup focdabang togungmaha yu Yesu acacha tun matogoc. Yaha yu amna docutno ididocmaha. ");
INSERT INTO yuw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tun matuna yu domdomgon ongga owi amna osuc fat imongo ep koroc öngga ‘Yesu urop ngorochon ehantac’ yongo woce torengga idoc. ");
INSERT INTO yuw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tuna Yesu yu urop ep idocan wocin engkungga daroho ep koroc onoce foringmun uuna Sakius angga inogoc, “Sakius, goc karupgon ohoi! Noc önga gocho bucin öantat.” ");
INSERT INTO yuw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ihoroc inuna Sakius yu matano kombingga irot ogep morö kombingmuna karupgon gurocdec ohongo Yesu yangauna ino bucin ögomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ihoroc tunya owi amna koböcho wo yangga mata metec yongga yogung, “Mayain, Yesu yu wontucmuno toctoc amnaho bucin öhac yo.” ");
INSERT INTO yuw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Owi amna ihoroc yongga idung mahong Sakius yu idongga Yesu inogoc, “Moröma, ngo ahi, noc öngai nakain möneng yoctec manomano ambarac erango fugo yai tongmaina, auma wömai amna urocima imontat o auma wömai nakain entac. O ihorocgon nocho osuc amna imanang inong yucyuc tongmaina yuhon manomanono usem fogididot. Worocha nocho manomano usem fogidotma wo bongo awanomunohon toroc urago iban imontat.” ");
INSERT INTO yuw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ihoroc yuna Yesuho yogoc, “Boinno sinom, amna ngo yui ihorocgon Abrahamphon morogono. Worocha wömai önga Kopotorocho amna ngorochon feno inoha fogiuna batip idang. ");
INSERT INTO yuw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Amnahon Manano yu ‘owi amna gorong ongimaho batip itnung’ yongo yuha yabic yabicha guroc ngocin eboc.” Sakiushon fatno woroc. ");
INSERT INTO yuw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Oro amnaho Yesuhon mataha onggim singga idiya Yesuho matano sakaun fiuna Kopotorochon toborucnohon mata tepmo au inogoc. Foro wömai ingoroc, Yesu yu urop Yerusalem ambehecgon idina owi amnaho kombigung, Kopotorochon toborucnoho urop eran öngkuantac. Worocha tongga Yesuho mata tepmo au ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Amna moröma au yu king ma sogit sogitha kantri auhon onggonga togoc. Yu wömai kombigoc, ‘nocho woce ongmaina king ma sogida ibara fauna böcnan ehangot’ ihoroc yongo kombigoc. ");
INSERT INTO yuw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tongo yu youp wabkaracni 10 ihoroc inuna ehuya yu 1,000 Kina 1,000 Kina ihoroc fuc tongga youp amnani imongga ingoroc inogoc, ‘Son möneng ngo fogito bisnis youp tongo idiya ongga nocho wönggon ehangot.’ ");
INSERT INTO yuw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Yu youp mata ihoroc youp wabkaracni inongga mit king ma sogit sogitha kantri auhon onggoc. Yu ihoroc togoc mahong inoin suraro yu wömai kombigung, ‘Amna moröma ngo yui amna wontucmuno, yui king noni angit main.’ Ihoroc kombingmuya yu amna au inong muuya yu amna moröma onggocan woce ongmuya ‘muno’ yogung, ‘yu king noni icha’. ");
INSERT INTO yuw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Yu ihoroc bongbong sicsicha togung mahong amna moröma wo yu kiringga king ma sogida ibarun fauna wönggon ino böcsanon woce onggoc. “Tongo yu kombigoc, ‘Nochon youp wabkaracnai 10 yu bisnis youp tongga möneng tu morogigocha woha muno?’ Ihoroc kombingga inong yuna yuot ebung. ");
INSERT INTO yuw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ehuya youp wabkarac osuc ebocma yuho yogoc, ‘Amna moröma noc gocho 1,000 kina namogorocma wo sogitmaina bisnis youp tongo tong morogiaya 10,000 kina ihoroc idang.’ ");
INSERT INTO yuw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ihoroc yuna amna morömaho wo kombingga borongdeda yogoc, ‘Nakain youp wabkarac ogepma, gocu youp ogepma sinom togoroc. Goc yapmu obugu ngo ogepma sinom angtoregorocmaha nocho yapmu moröma gamontat. Goc ongoi, nochon böcsa 10 woroc gocho yangtorengmina moröm tong imiruc.’ ");
INSERT INTO yuw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Amna morömaho ihoroc yuna oro urop youp wabkarac auho engmuna yogoc, ‘Amna moröma noc gocho 1,000 kina namogorocma wo sogitmaina bisnis youp tongo tong morogiaya 5,000 kina ihoroc idang.’ ");
INSERT INTO yuw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ihoroc yuna amna morömaho yu inogoc, “Goc youp wabkarac ogepma worocha goc ongmina nochon böcsa 5 ihoroc gocho yangtorengmina moröm tong imiruc.” ");
INSERT INTO yuw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Amna morömaho ihoroc yuna mit youp wabkarac auho engmuna yogoc, “Amna moröma goc amna botoc botogo sinom. Amna auho manomano figungma woroc wömai gocu gakaha fogiditaroc. O amna auho nacno mögungma woroc wömai gocu gakaha fogiditaroc. Worocha nocu gocha botongmaina 1,000 Kina ngo boru docnodec tom tongo öp singga bisnis youp matogot.” ");
INSERT INTO yuw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ihoroc yuna amna morömaho mata wo kombingga ec imuna youp wabkarac inogoc, “Goc youp wabkarac wöntucmuno. Nocu gakain matagon sogida ibaraya matayaho gaka sakaantac. Gocu nocha ingoroc kombingitaroc, nocho amnahon manomano nakaha fong fingitat. O ihorocgon amnaho manomano öndec möngidangma wo noc nakaha fogiditat yo. ");
INSERT INTO yuw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ihoroc kombiharocmaha gocu foro yaha möneng gamogotma wo bengdec masigoroc. Bengdec siya möneng worocho tong morogic morogic youp tuna nocho engga möneng koböcma wo sogiam.’ ");
INSERT INTO yuw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Amna morömaho youp wabkaracno ihoroc inong fato mit amna au wocin idungma inogoc, ‘Son amna ngorochon 1,000 Kina wo tu deuna amna 10,000 kina idimpacma wo imarut.’ ");
INSERT INTO yuw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ihoroc yuna amna worocho matano kombingga soroc yongo amna moröma inogung, ‘Moröma, yu urop 10,000 Kina idimongdehac, worocha tingtinga yu wönggon 1,000 Kina imontaroc.’ ");
INSERT INTO yuw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ihoroc yuya amna morömaho yogoc, ‘Nocho boinno sinom kantiwa, amna au yu manomano koböcma idimangma yu wömai wodec sakaun fiuna koböcma sinom aun feangoc. Wohong amna au yu yapmu au maidimocma yu wömai manomano obugu obugu urop fogihacma wo yongo fongyun ongimuya uroci sinom engoc.’ ");
INSERT INTO yuw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Amna morömaho ihoroc yongo wönggon matano sakaun fiuna amna woce idungma yu inogoc, ‘Son karup ongga nochon ayamnai ngocin yangata fengga nocho yangamin dong omom tarut. Wömai yaha yuho yogung, nocho yuhon king maem, worocha sontho yu dou omarut.’” ");
INSERT INTO yuw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Oro Yesu yu mata tepmo wo yun bödeuna wönggon uyap forosingga ongga Yerusalem onggonga togoc. ");
INSERT INTO yuw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yesu yu urop böcsa Betfage orin Betani Oliv sa urongodec wocin ambehecgon öngkungga youp amnanain yai ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Sodu böcsa oko itacma wocin ongmunya aantamoroc, bot donki beracno au woce kaniuya itac. Bot donki woroc koroc wömai amna auho abe maitonggung. Oro sodu wo asanto tebarun. ");
INSERT INTO yuw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Woroc asanto tehunya amna auho kango ‘sodu yaha asan imamoroc’ kanunai wömai ingo inontamoroc: ‘Morömaho youp imocimocha yac.’” ");
INSERT INTO yuw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yesuho ihoroc inuna amna yaiho ongga agomorocmai Yesuho yogocma worochon torocgon idoc. ");
INSERT INTO yuw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ihoroc yangga yu bot donki wo asanto idinya bot donkihon morömoho yu inogung, “Ei sot bot donki ngo foro yaha asan imamoroc yo?” ");
INSERT INTO yuw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ihoroc inuya amna yaimaho mata urago inogomoroc, “Morömaho youp imocimocha yac.” ");
INSERT INTO yuw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ihoroc inongo bot donki wo asanto Yesuot yangato tongga tec tohomumöcno fuun deuya bot koroc figomoroc. Ihoroc tongga Yesu tong fatyeuya bot donki koroc ögoc. ");
INSERT INTO yuw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Woce itmuna yu Yerusalem uyap forosingga onguna owi amnaho tec tohomumöcno fuu deuya uyapdec toropgon fing tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ihoroc tongga yu ongga Oliv sa urongo öngkatingga Yerusalem taun eran angmuya owi amna Yesuot onggungma yu ambarac forosingga Kopotorocha yong moröng imogung. Yui Yesuho toroc kiap inobarac sinom tongidocma worocha kombingmuya irot ogep kombingga ingoroc yogung: ");
INSERT INTO yuw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“King moröma, yuha yong moröng imona. Yu Kopotorochon madec ehuna guroc owi amna irot gucot entang. Yong moröng noni ambarac Kopotorochagon yong kumena.” ");
INSERT INTO yuw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Owi amna Yesu tan tonggungma yu ihoroc yong moröngga idiya Farisi auho toroc kiapmo wo auya angit maidina Yesu inogung, “Fandat fandat amna, goc muyu youp amnayai wo inong fahi. Yu mata ihoroc yoninga.” ");
INSERT INTO yuw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ihoroc yuya Yesuho yogoc, “Nocho boinno sinom kantiwa, owi amna ngo yu ihoroc mayuyai wömai sop ngorocho mamboda Kopotoroc yong moröng imontang,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu yu Yerusalem ambehecgon engkungga taun wo angmuna irotno mep tuna ointogoc. ");
INSERT INTO yuw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ointongmuna ingoroc yogoc, “Kou sinom, son Yerusalem nano, önga sinom tong ogep tong kamoc kamoc amna sonot ambehecgon epac mahong sonu yu makombing iming. Yuhon foro woi sondec öp sicsicyi idina sonu etno idang. ");
INSERT INTO yuw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Worocha tongga oipmon yapmu nanga fatfatnobarac sinom ingoroc sondec öngkuangoc: Ayam soniho engmuya kangaranggömbec tongmuya oke oke idiya son taun sonihon imu fatfathon uyap au maöngkuic. ");
INSERT INTO yuw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tuna ayam soniho taun ngorochon gombono gumanda son ambarac dongyu obukonahing. Kopotorocho son tongfat keckecha amna au siuna eboc mahong sonu yu makombing iming. Worocha wömai taun ambarac orin owi amna taunthon gombo ganang idangma son ambarac obukonahing. Tuna sop auho nucno koroc maitning.” ");
INSERT INTO yuw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Oro mit Yesuho öret socsoc böchon gombo ganang ögoc. Öngga yagocmai amna au yu wocin bisnis youp tongga idung. Ihoroc tuya Yesuho forosingga yu dong yandoc. ");
INSERT INTO yuw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Dong yanmuna ingoroc inogoc, “Kopotorochon bapiyadec mata ingoroc irim toctocyi itac: ‘Nakain böc wömai dönac yocyochon böc engoc.’ Wohong sontho bisnis youp tongidangmaha ‘nochon böc usem amnahon böc öpma simbang tuya öngkungitac.’” Yesuho yu ihoroc inong fadoc. ");
INSERT INTO yuw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tongo mit Yesuho sep danong öret socsoc böc gombo ganang öngmuna fandat fandat youp tongidoc. Ihoroc tongo idina öret socsoc böchon amna moröma o nongoru gendic fandat fandat o surarohon amna dugo, yu ambarac Yesu wu omomphon mata fadang togung. ");
INSERT INTO yuw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ihoroc togung mahong owi amna komanangno yu ambaracho Yesuhon mata kombic kombicha toup kombigung. Worocha tongga Yesu wu omomphon uyap au maöngkuboc. ");
INSERT INTO yuw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Oro sep youp toctoc bongono auho Yesuho öret socsoc böchon gombo wocin owi amnadec fandat fandat youp tongo idina öret socsochon amna moröma o nongoru gendic fandat fandat amna o ihorocgon surarohon amna dugo worocho Yesuot engmuya ingoroc inong ac togung, ");
INSERT INTO yuw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Gocho ninia kombina, numaho ‘youp woroc toi’ yongo ganung muna eboroc? O youp toctochon gesö numaho gamuna tongitaroc?” ");
INSERT INTO yuw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Amna morömaho ihoroc inuya Yesuho mata urago ingoroc iban imogoc, “Oro, nocho ihorocgon yapmu au kanonga ac toya nanarut. ");
INSERT INTO yuw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jöntho owi amna yamuc gung imongidocma wo woi momphon manomano woha amnahon kombic kombicgon sindanda togoc?” ");
INSERT INTO yuw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ihoroc inuna yu kombic kombic youp morö tongmuya inohogon inun ganun tongga yogung, “Oro nontho yonaya woi momphon manomano wömai yuho ninontac, sonu yaha yu makombing tobing imogung yo? ");
INSERT INTO yuw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","O ihorocgon non yonaya wo woi amnahon manomanogon, wömai suraroho non sopdec nihuya omentamon. Wömai yaha owi amna yu boinno kombingidang, Jön yu woi Kopotorochon yong tuctuc amna sinom.” ");
INSERT INTO yuw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Oro amna moröma yu ihoroc kombing mep tongmuya inun ganun tongga tu matuna Yesu ingoroc inogung, “Jöntho youpno numahon gesödec tongidocma wo nonu makombimon.” ");
INSERT INTO yuw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ihoroc yuya Yesuho yogoc, “Oro worocha wömai nocho numahon ma sogida youpna tongitatno wo ihorocgon makanit.” ");
INSERT INTO yuw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu yu wönggon owi amna mata tepmo au ingoroc inogoc, “Amna moröma au yu wain ön au mögoc. Ihoroc tongo yu ‘amna torop auho nakain ön ngo angtorenung’ yongo wain ön wo amna torop au imogoc. Tongo yu inoi böcsa korungon ongga sa ubarago woce idoc. ");
INSERT INTO yuw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Yu woce idina wain koburoho urop gomon dingga idina amna morömaho yogoc, ‘nocho youp wabkarac au inong muaya yu ongmuna wain koburo nochon fat ficficyi idangma woroc yongga fepun’, ihoroc yogoc. Worochoi muno, wain ön angtorec amna yu youp wabkarac wo ayam tong imongo woto taruya yu komong ibarun fauna onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tuna amna morömaho wönggon youp wabkaracno au inong muuna onggoc mahong wain ön angtorec torec amna yu osuc togungma worocotma wönggon toroc kiap yangam fapfapni tong imongo woto taruya komong onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tuna yu bongo anfi youp wabkarac au inong muuna onggoc mahong wain ön angtorec torec amnaho yu ihorocgon woto tu mointuna gombo sumone taruya onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ihoroc tuya amna morömaho wo angmuna kombigoc ‘Nocu tingting sinom tontat yo?’ ihoroc kombingga yogoc, ‘Noc nakain manama batip sinom yu siaya ongoun. Worocho onguna wömai wain ön angtorec torec amnaho yu anggendingmuya wain koburo au imonahing.’ ");
INSERT INTO yuw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Yu ihoroc kombingga manano inong muuna onguna wain ön angtorec amnaho woroc angmuya yogung, ‘Aiö amna morömaho inoin manano sinom siuna epac. Fanoho omengocan wömai worocho sinom fim öresac ambarac inohagon fogitbödeangoc. Worocha non manano ngo wot omom tongo ön ngo kömbaha nonthon fat engoc.’ ");
INSERT INTO yuw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yu ihoroc kombingmuya manano wo taruya gombo sumone ohuna wuya omboc.” Oro Yesuho mata tepmo ihoroc yun bödeuna mit amna moröma inogoc, “Sonu ting kombiang? Ön morömo yu engmuna amna wontucmuno urago tingting sinom tong imangoc? ");
INSERT INTO yuw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yu wömai engmuna wain ön angtorec torec amna wontucmuno wo dong omom tongo wain ön amna torop au imangoc.” Yesuho ihoroc yuna amna auho mata woroc kombingga soroc yongga yogung, “Eei, ihoroc sinomu öngkuicha.” ");
INSERT INTO yuw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ihoroc yuya Yesuho owi amna foring yangga inogoc, “Sonu worocha ‘muno’ yang mahong kombiarut, Kopotorochon bapiyadec wömai mata ingoroc irim toctocyi itac: ‘Sop auha wömai böc toctoc amnaho ‘sop wontucmuno’ yongo tomu onggoc mahong önga wömai Kopotorocho sop worocgon sogitmuna tong koing tong imuna sop worocho böchon forodongno sinom itac.’ ");
INSERT INTO yuw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Worocha wömai woroc, amna auho möngga sop woroc koroc ohontacma yu ino kubit tontac. O sop worocho möngga amna au wentacma wömai amna möp tontac.” ");
INSERT INTO yuw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Oro Yesuho mata ihoroc yun bödeuna nongoru gendic fandat fandat amna orin öret socsoc amna dugo yui kombigung, ‘mata ngo yacma wömai nontha yac yo’. Ihoroc kombingga irotnoho obökuna yu wohogon Yesu sogit akep toctocha kombigung mahong yu suraroha botogungmaha Yesu tu moin toctochon uyap au abe eran maöngkuboc. ");
INSERT INTO yuw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Oro Farisi orin amna moröma au yu ingoroc kombigung, ‘Yesuho mata wontucmuno au yunai wömai nontho yu sogit akep tongga gavmanthon moröma yuhon oburodec tohong yuantamon.’ Ihoroc yongga yu Yesuha gön tongga idung. Tongo yu amna au inongmuya worocho Yesuot ongmuya tonguc yecyecha mata ingoroc inogung, ");
INSERT INTO yuw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","“Fandat fandat amna non gocha kombiamon, gocu amna auhon kombic kombic matanitaroc o ihorocgon goc Kopotorochon mata boinno worocgon owi amna fandat inongitaroc. ");
INSERT INTO yuw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Worocha wömai gocho ninia kombina: Non Sisa King yu takis möneng ogep imonta-montha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ihoroc inuya Yesu yuhon imanang kiapmo urop angtangtang tongo inogoc, ");
INSERT INTO yuw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Möneng docno au tengga nindaarut. Möneng ngodec mano orin doguno irim toctocyi itacma ngomai numahon?” ");
INSERT INTO yuw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ihoroc inuna yuho yogung, “Woi Sisahon.” Ihoroc yuya Yesuho yogoc, “Oro worocha wömai sonu Sisahon fat Sisaha imarut mahong Kopotorochon fat wömai Kopotorocha imarut.” ");
INSERT INTO yuw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yesuho owi amnaho yangamin mata nongnongogon yuna tonguc imocimoc amnaho matano ngo kombingga soroc yongo mata ökenneha dabiu matuna öpgon idung. ");
INSERT INTO yuw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Oro Yuda nanohon amna moröma Sadyusihon toropdecma yu wömai yongidung, ‘amna omomyi yu wönggon maidongoning,’ ihoroc yongidung. Oro amna torop worocho Yesuot ongmuya ingoroc inong ac togung, ");
INSERT INTO yuw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Fandat fandat amna, Möseho nongoru au ingoroc irim togocma wo ingoroc embadidamon: Amna au managumbocno muno yu omunai wömai amna worochon orugoho orugohon oweno wo tong siuna owi worocho managumboc au bang fiun. Ihoroc tuna wömai amna ombocmahon toropmo mabödeic. ");
INSERT INTO yuw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Möseho mata ihoroc irim tong nimogoc. Oro gocho mata worocha kombingmina nonthon fat noni ngo kombihi: Osuc wömai yomot oröc 7 ihoroc idung. Tuna orugo borongomaho wömai owi au tong singga ida managumboc au mayongfii omong fadoc. ");
INSERT INTO yuw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ihoroc omuna orugo au owi worocgon tongsigoc mahong yu woi ihorocgon managumbocno muno ito omboc. ");
INSERT INTO yuw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Omuna mit orugo au yuho owi worocgon tong sigoc. Tong singo yu woi ihorocgon managumbocno muno ito omongfadoc. Yomot oröc tobuno 7 woi ambarac ihorocgon tongo ito managumbocno muno omongbödegung. ");
INSERT INTO yuw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ihoroc tongo mit wömai owi wo yu ihorocgon omong fadoc. ");
INSERT INTO yuw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Oro mit amna omimaho idongonahingan bongono wocin wömai owi wo amna numahon fat engoc. Yaha yomot oröc 7 yu ambarac owi wo tong sigungmaha owi wömai numahon oweno engoc?” ");
INSERT INTO yuw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ihoroc yuya Yesuho mata ingoroc iban imogoc, “Owi amna önga idangma yu wömai owi op tongidang mahong ");
INSERT INTO yuw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","bongono mit ehangocma wocin wömai Kopotorocho owi amna yangsoworeuna yuho yangamin nongnongo ima yuho wömai amna omocdecma idongga Kopotorocot itmuya owi op wönggon matoning. ");
INSERT INTO yuw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Muno yu wömai sum yaru simbang itmuya wönggon mamning. Kopotorocho yu omocdecma doun wekuya yu Kopotorochon weni manani sinom itnahing. ");
INSERT INTO yuw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Kombiang, Mösehon bongonodec wömai ep aranggumpho ohuna ep songmun digoc. Tuna bongono wocin wömai Möseho Kopotoroc ingoroc inogoc, ‘Moröma, gocu Abraham orin Aisak orin Jeköp yuhon Kopotorocno.’ Oro Möseho mata wo yogocmaha ingoroc kombiamon: Abraham orin Aisak orin Jeköp, yu ombung mahong mit idongga Kopotorocot wec idang. ");
INSERT INTO yuw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kopotoroc yu omimahon Kopotoroc muno, yu wecima yuhon Kopotoroc.” ");
INSERT INTO yuw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yesuho Sadyusi mata ihoroc iban imuna nongoru gendic fandat fandat amna auho wo kombingga yogung, “Fandat fandat amna mataya woi ogepma sinom yaroc.” ");
INSERT INTO yuw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Oro, mit wömai amna au Yesu inong ac toctocha botogung. ");
INSERT INTO yuw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Oro midu Yesuho owi amna ingoroc inong ac togoc, “Tingtinga wömai auho yongidang, ‘Duic yu woi Devithon manano?’ ");
INSERT INTO yuw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kombiarut, ap bapiyadec wömai Devitho Duicha ingoroc yogoc, ‘Kopotoroc yu nochon Morömana inogoc, Gocho obuna aroce iti. ");
INSERT INTO yuw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Woce idia ongga nocho ayamai fogito fohong yuaya gocho une itnahing.’ ");
INSERT INTO yuw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Oro, Devit inoho wömai Duicha ‘Morömana’ ihoroc yogoc. Worocha wömai Duic yu tingtinga Devithon manano in?” Yesuho Duicha ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Oro owi amna ambaracho Yesuhon mataha onggim singga idiya Yesuho youp amnani ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Sonu nongoru gendic fandat fandat amnaha yacyacho itongitnung. Yu wömai inoha kombingidang ‘non amna moröma sinom idamon yo’ worocha tongga yu tec tohomumöcno ubarago fohong yumuya uyap itonggonga toup kombingidang. Ihoroc tuya owi amnaho yu maket taitdec ‘sep ogep amna moröma ninarut’ yongo toup kombingidang. O fatmata yocyoc bucinthu o tong sonoc bongonodechu wömai yu amna morömahon abam ogepmagon woce iditha toup kombingidang. ");
INSERT INTO yuw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","O ihorocgon yui owi kapi imanang inong yucyuc tongo böcno yoctecno manomano inoha usem fogididang. O yu ‘owi amnaho non niarut’ yongo dönac ubarago yongidang. Boinno sinom, amna ihorocnoha wömai Kopotorocho urago wontucmuno sinom imangoc.” ");
INSERT INTO yuw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Oro Yesu yu öret socsoc bucin ito yagocmai owi amna mönengno koböcma yu öret socsoc böchon ecec möneng singga ongi epi tongidung. ");
INSERT INTO yuw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ihoroc tongga idiya owi kapi uroci au yu ihorocgon engmuna möneng gomono yai woroc ececha figoc. ");
INSERT INTO yuw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ihoroc tuna angga Yesuho yogoc, “Boinno sinom, owi uroci ngo yu ecec möneng sicma wo wömai owi amna au ecec möneng fingidangma yanggiratbödehac. ");
INSERT INTO yuw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Owi amna au yu mönengno koböcma idimang mahong yu worochon docno obmukusucgon sogida ececha fingidang. Worochoi owi ngo yu tong urocdec itac mahong yu nacno wöcwöchon mönengno ambarac sogida Kopotorochon ececha singbödehac,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesuhon youp amnani au yu öret socsoc böc moröma idocma wo auya ogepma sinom idina yogung, “Öret socsoc böc ngorochon sopno wömai ogepma sinom oripnobarac tobigung. O owi amnaho Kopotoroc irot ogep tong imimpha tongo tongfatfatno ogepma sinom fong figung.” Ihoroc yuya Yesuho yogoc, ");
INSERT INTO yuw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Manomano yaangma ngo worocha wömai nocho boinno sinom kantiwa, mit bongono auho ehuna sopho nucno dedec dedec idangma worocho nucno wo otiun tongo ficfuc ararip tongo mönahing,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tuna youp amnaniho Yesu inong ac tongo yogung, “Fandat fandat amna, yapmu ngo yarocma worocho bongono tingnon sinom öngkuangoc? O toroc kiapmo yaö sinompho osuc öngkuuna nonu woroc angmanaina kombinahamon urop woroc öngkuantac yo?” ");
INSERT INTO yuw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ihoroc inuya Yesuho yogoc, “Son soni woho, imanang amnaho son tonguc keningyit. Amna koböcmaho wömai nochon ma sogitmuya imanang unac mata kanonahing. Aumaho wömai kanonahing, ‘Noc naka Duic ngoroc.’ O aumaho yonahing, ‘bongono urop bödeantac!’ Yu imanang ihoroc kanonahing mahong sonu yu kombing tobing imoninga. ");
INSERT INTO yuw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Oro emoc dirungon koböcmaho öngkuuya sonu worochon fatno kombinahing. Wohong sonu worocha soroc yongo botoninga. Muno, Kopotorocho ‘toroc kiap ihorocnoho öngkupnahing’ yongo yong toropno singdegoc. Worocha tongga emoc dirung worocho osuc öngkuuna guroc ngorochon bödec bödecnoho wömai mit engoc.” ");
INSERT INTO yuw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesuho ihoroc yun bödeuna mit wönggon ingoroc yogoc, “Amna kantri auhonmaho kantri auhonmaot emoc tu fadang öangoc. O sa auhonmaho sa auot emoc dirung tongonahing. ");
INSERT INTO yuw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ihoroc tuya sano sano konoc moröma fennahing. O nacno möp morö orin obukoc inobarac worocho owi amnadec öngkungbödeangoc. O momdec wömai yapmu botoc botogoho orin weran inobarac sinom worocho öngkung tongonahing. ");
INSERT INTO yuw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Worochoi oro manomano wo abe maöngkui idina owi amnaho son ayam tong kamongmuya dongyu moin tonahing. O ‘nocha’ tongga yu son fogito Yuda nanohon mata youpdechu o yi bucinthu o kinghu o gavmanthon moröma yuho yangamin woce fohong kuuya mata soni yu bödeangoc. ");
INSERT INTO yuw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mata youpdec fohong kupnahingmaha tongga sonu nochon fatmata ogepma yu inong tauya kombinahing. ");
INSERT INTO yuw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Oro son osuchagon kombingbanac tongga ‘mata youpdec tingting sinom inontamon’ yongo kombininga. ");
INSERT INTO yuw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Wömai yaha, noc nakabut wömai sonot itmaina duc soni ta yungan tuna mata soni koing sangoc. Koing suna ayam soniho mata uragoha dabiu matuna mata soni boinno engoc. ");
INSERT INTO yuw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Bongono wocin wömai mac sonihu o fan sonihu o niboröc sonihu yu ayam tong kamuya ayam soniho oburodec fohong kunahing. Tuna ayam soniho sondecma au dong omom tonahing. ");
INSERT INTO yuw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kombiarut, ‘nocha’ tongga owi amna tobunoho ayam tong kamonahing, ");
INSERT INTO yuw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","mahong Kopotorocho son kangtoreuna bicsoni sakemo tungu au magorong ongic. ");
INSERT INTO yuw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Son tonguc yecyec bongonodec koing songga iditnung. Tongo sonu itonggong koing au feangoc,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Oro Yesuho wönggon mata sakaun fiuna yogoc, “Sontho yauya tawa amnaho engmuya Yerusalem taun angarenggumbec tonahing. Ihoroc tonahinganu wömai sonu kombinahing, Yerusalemphon obukoc obukochon bongono urop eng fomtac. ");
INSERT INTO yuw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Bongono worocho wömai owi amna Yudia distrikdec itnahingma yu botongga domdomgon sa urongodec önung. O owi amna Yerusalem itnahingma yu karupgon taun wo imu fauna korungon ongonung. O owi amna Yerusalem gombo sumon itnahingma yu ibaru fauna gombo ganang ongoninga. ");
INSERT INTO yuw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Muno sinom, Kopotorocho taun worocha irot ecego moröma kombingga bongono wocin wömai urago tong imangoc. Worochon yong tuctuc matano wömai osucgon Kopotorochon yong tuctuc amnaniho irim togung. Tuna bongono wocin wömai mata worocho boinno engoc. ");
INSERT INTO yuw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“Bongono worocho wömai Kopotorocho urago wontucmuno sinom tuna mepmo inobarac sinom kantri ngorochon owi amnadec öngkuangoc. Worocha tongga owi managumboc mum imongo itnahingma o mana modip itnahingma yu mepmo morö angmuya uroci sinom itnahing. ");
INSERT INTO yuw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","O ayamo yu engmuya owi amna gobit bainatdec dong omom tonahing. O au wömai yu fogito kantri woce woce yongo fohong yuya torop auhon youp wabkarac itnahing. Bongono worocho woi ‘bumbumyi nanohon bongono’ yongo engoc. Yuho engmuya Yerusalem tu obökuna owi amna moröm tong imongga idiya ongga yuhon bongono bödeangoc.” ");
INSERT INTO yuw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesuho mata wönggon sakaun fiuna yogoc, “Bongono morö worocin wömai weran foro wohon wohon onoce sep yarop fitnungdec öngkupnahing. O gurocdec ngocin owi amnaho kombinahingmai top yamuc funfurohon kekoröp morö simbang öngkuuna tong botoc toup tongmuya irotho obökangoc. ");
INSERT INTO yuw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","O sep yarop fitnung yuhon uyapno wömai mongurac tuya owi amnaho toroc kiap fodibo wo yang botongga ‘yaö sinom nonidec öngkuantac’ yongo kudat konoc konoc tongmuya botocno sinom tonahing. ");
INSERT INTO yuw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Owi amna ihoroc tongga ida anahingmai Amnahon Manano yu yaguno wairurunobarac mitimoni sinom ihoroc momdecma ohongga ehangoc. ");
INSERT INTO yuw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Oro, sonu anahingmai toroc kiap ihorocnoho forosingga boinno öngkuunai wömai sonu borongdetnung. Yaha Kopotorocho son inoha fogiuna batip idithon bongono morö worocho urop eng fomtacmaha borong detnung.” ");
INSERT INTO yuw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Oro Yesuho youp amnani inongga bongono moröma ebephon doguno au ingoroc sigoc, “Sonu ep fikhu o ep au idangma wo yaarut. ");
INSERT INTO yuw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Worocho biruc tuya yanggai ingoroc kombingidang, sep bongono urop ehantac. ");
INSERT INTO yuw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Oro worochon torocgon manomano yatma worocho boinno öngkuuyai wömai sonu wo yangmuya ingoroc kombinahing, Kopotorochon mom toborucno urop öngkungga eran entac. ");
INSERT INTO yuw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nocho boinno sinom kantiwa, guroc amnaho abe mabödei idiya yapmu wo ambaracho öngkungbödenahing. ");
INSERT INTO yuw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Boinno sinom, mom saguroc worocho wömai bödeangoc mahong nochon matanaho wömai iditnoho iditno idtongungoc.” ");
INSERT INTO yuw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yesuho wönggon mata sakaun fiuna youp amnani ingoroc inogoc, “Son soni woho, gurochon manomanoho itonggong soni tun obökuna irotsoniho mep toningyit. O son yamuc koingo toup nongo bumbum yongo itongitninga. Son ihoroc tongga etno idiya wohogon Amnahon Mananoho ehuna sonu arangarang mayi itningyit. Arapho gagadec ongga omongidangma worochon toroc wömai bongono morö karupgon ehangoc. ");
INSERT INTO yuw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Bongono worocho wömai owi amna gurocno gurocno ididangma yu ambarac ihorocnogon yaun weangoc. ");
INSERT INTO yuw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Worocha son bongono muno itonggong soni yacyacho itongga Kopotorocha dönac inongitnung. Tuya yuho koing socsoc kamuna mepmo worocho sondec maui kang yembengoc. Tuna sonu Amnahon Mananoho yangamin tong botoc botocsoni muno idongup.” ");
INSERT INTO yuw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Oro Yesuho ihoroc yun bödeuna sepno sepno öret socsoc bucin öngo owi amna fandat inongidoc. Kumbong wömai yu sa urongo mano Oliv woce öngidoc. ");
INSERT INTO yuw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tongo kembotsum sinom wönggon öret socsoc bucin uuna owi amna koböcmaho yuhon mata kombic kombicha yuot engidung. ");
INSERT INTO yuw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Oro, nacno sowarango yisno muno nocnoc bongono ‘Pasowa’ yongidangma worocho urop engfomtogoc. ");
INSERT INTO yuw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tuna öret socsoc böchon amna dugo orin nongoru gendic fandat fandat amna yu Yesu wot omom toctochon uyapha dabigung mahong suraroho Yesuha toup kombigungmaha tongga yu suraroha botogung. ");
INSERT INTO yuw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tuna dogu kopotho Yudashon irotnon ohogoc. Yudashon mano au wömai Iskariot ihoroc yongidung. Yui Yesuhon youp amnani 12hon toropdecma. ");
INSERT INTO yuw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Dogu kopotho yuho irotnon ohuna Yudas yu öret socsoc böchon amna dugo orin öret socsoc böchon tawa amnahon ofisa yuot ongmuna ‘tingting sinom tongga Yesu yuhon oburodec siantat’ yongo worochon mata inun ganun togung. ");
INSERT INTO yuw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tuna Yuda nanohon amna moröma yu Yudasha irot ogep morö kombingo wöngnacnoha ‘möneng au gamontamon’ yongo yong koing mata inogung. ");
INSERT INTO yuw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ihoroc yuya Yudasho ‘öc’ yongo ingoroc kombigoc: ‘Yesu inogon idina wömai nocho ogep yu ayamphon oburodec tong siangot,’ ihoroc kombingga gön tongga idoc. ");
INSERT INTO yuw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Oro urop nacno sowarango yisno muno, ‘Pasowa’, woroc nocnochon bongono idoc. Bongono wocin wömai Israel nanoho bot sipsip beracno dongga sonongidung. ");
INSERT INTO yuw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Worocha tongga Yesuho Pita orin Jön youp imongga inogoc, “Sot ongmunya ‘Pasowa’ nacno noni tong arangarang tarun.” ");
INSERT INTO yuw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ihoroc inuna amna yaimaho Yesu inogomoroc, “‘Nacno noni nahe sinom tong arangarang toda’ yongo kombiharoc?” ");
INSERT INTO yuw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ihoroc yunya Yesuho inogoc, “Sot Yerusalem onguya amna auho yamuc urengno sumbotmuna engo uyapdec kaun feantac. Kaun feuna sot amna woroc tan tongunya yuho böc nahenne öantacan sot wocegon öarun. ");
INSERT INTO yuw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Öngga böc morömo ingoroc inarun: ‘Fandat fandat amnaho yac, Nocot youp amnanaiot non Pasowa nacno nahenne naantamon?’ ");
INSERT INTO yuw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ihoroc inunya böc morömpho böc irotno moröma au kindaantac. Böc irotno worocho nucno koroc itac. Wocin wömai nacno nocnoc abam manomano ambarac idang. Tuna sodu woce ongmunya nacno noni tong arangarang tarun.” ");
INSERT INTO yuw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yesuho Pita orin Jön ihoroc inuna yu ongga angmunya manomano Yesuho yogocma worochon torocgon idoc. Tuna yu nacno woce tong arangarang togomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Oro urop nacno nocnoc bongono fomtongga idina Yesuot youp amnani 12ot yu ongga nacno nocnoc abamdec omoc idung. ");
INSERT INTO yuw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tongo Yesuho youp amnani ingoroc inogoc, “Noc banac banac nacno Pasowa ngo sonot nocnocha toup kombihat. Mit wömai focfoc moröma nocdec öngkuantac. ");
INSERT INTO yuw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kombiarut, nocho nacno ngo wönggon manai edeya ongga Kopotorochon mom toborucno engfauna nacno ngorochon boinno öngkung tangtang tangoc.” ");
INSERT INTO yuw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yesuho ihoroc yongga wain kap sogitmuna Kopotorocha ecec inongo yogoc, “Soni ngo nongga docno nuc soniha imuya docno docno naarut. ");
INSERT INTO yuw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kombiarut, nocho wain yamuc wönggon manai edeya ongga Kopotorochon mom toborucno engfaangoc.” ");
INSERT INTO yuw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ihoroc inongga wönggon nacno sowarango au sogitmuna Kopotorocha ecec inongo uboto youp amnani silip tong imongga inogoc, “Ngoi nochon godip föbna. Nocho itonggongna son tongfat keckecha ima faantac. Mit wömai sonu nacno ngo nongmuya nocha kombiu fudöngengac.” ");
INSERT INTO yuw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ihoroc yongo imuna nacno nongbödeuya Yesuho wönggon wain kap sogitmuna yogoc, “Wain yamuc ngo woi nochon nogotna. Worocho wömai son tong fat keckecha koringma möcmöcyi. Woi Kopotorocho sonot botup botup wego sigocma worochon weran. ");
INSERT INTO yuw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Worochoi oro amna au ngocin itacmaho noc tongo ayamnaihon oburodec siantac. Yu woi nocot nacno nocnoc abamdec ngocin kondong idamot. ");
INSERT INTO yuw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kopotorocho wömai osucgon ‘ayampho noc tu omentat’ yongo kombingdegoc mahong amna wo noc ayamnaihon oburodec siantacma yu wömai mepmo moröma inobarac sinom aun feangoc.” ");
INSERT INTO yuw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yesuho ihoroc inuna youp amnani mata woroc kombingga soroc yongmuya nucno foring yaun tongo yogung, “Nonidecma numaho sinom wömai toroc kiap wontucmuno ihorocno tun?” ");
INSERT INTO yuw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Oro ihoroc yongga Yesuhon youp amnani yu ‘inoin toropdecma numaho amna moröma sinom itac’ yongo mataho emoc togung. ");
INSERT INTO yuw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ihoroc tuya Yesuho inogoc, “Bumbumyi nanohon king yu suraro moröm tong imongmuya mepmo morö tong imongidang. O ihorocgon gavmanthon amna moröma yu inoha borongdeda yongidang: ‘Nonu suraro ogepma sinom tongfat yengidamon yo’. ");
INSERT INTO yuw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wohong sonu toroc kiap ihoroc tongitninga. Muno sinom, sonotma amna auho amna moröma idita kombinggai wömai yu suraroho unenne itmuna yuhon mepmono sumboda edengac. O amna auho ‘nocu dugo soni itat’ yongo moröm tong kamoc kamocha tonggai wömai yu son mongorec tong kampun. ");
INSERT INTO yuw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Tingting oro, numaho woi moröma? Amna nacno nongo itacmaha woha amna mongorec tong imongga nacno feng imongitacma yu worochu? Woi ingoroc, ‘amna nacno nongga itacma yu woi moröma’ ihoroc yongo kombingidamon mahong nocu ihoroc matongitat. Muno, nocho sonot itmaina youp amna soni iditat. ");
INSERT INTO yuw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Oro mepmo koböcmaho nocdec öngkung namongidung mahong sonu nocot itongmuya noc maimu fadot. ");
INSERT INTO yuw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Worocha wömai woroc, nocho gesö kamoya sonu mom toboruchon owi amna entang. Nandöngnaho ‘noc mom midim sabarac sahon Morömo itiwa’ yongo gesö namogoc. Tuna nocho son worochon gesö kamoya ");
INSERT INTO yuw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","son ambaracho woce itmuya nocot nacno kondong nanahamon. O ihorocgon sonu amna morömahon abam sogitmuya Israel nanohon toropmo 12 woroc yangtorenahing,” Yesuho youp amnani ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Oro mit Yesuho Pita yong tuctuc mata ingoroc inogoc, “Saimon Saimon! Kombiharoc, dogu kopot yu sonthon kombing tobic tobicsoni toroc toctocha Kopotoroc inong ac tuna Kopotorocho yu kombing imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wohong nocho ‘gocha’ yongo Kopotoroc dönac inoya gochon kombing tobic tobicaho koing songga mamong wic. Muno, oipmonu wömai gocho wönggon ibari fauna nocot engmina oröcai tong koing tong imangoroc.” ");
INSERT INTO yuw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Yesuho Pita ihoroc inuna Pitaho yogoc, “Moröma, noc gocot yi bucin onggongahu o gocot omomphahu imong dot matit.” ");
INSERT INTO yuw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Pitaho ihoroc yuna Yesuho inogoc, “Pita, nocho boinno sinom gantiwa, önga kumbong ngocin fup mano abe mayi idina gocu nocha bongo anfi möp yongga yontaroc, ‘Nocu yu makombing imot yo,’” Yesuho Pita yong tuctucno ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Oro mit Yesuho youp amnani ingoroc inong ac togoc, “Osuc wömai nocho son youp toctocha kanong muaya sontho mönenghu o yoctechu o orung tomsonihu muno komong sinom onggung. Oro bongono wocin sonu yapmu auha docmögunga woha muno?” Yesuho ihoroc inuna youp amnani mata wo kombingga ‘muno’ yogung, “yapmu auha madocmögomon”. ");
INSERT INTO yuw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ihoroc yuya Yesuho inogoc, “Oro önga wömai nocho kiapmo au ingoroc kantiwa: Son muyu mönengsonihu o yoctecsonihu wo fogida ongorut. O son gobit bainatsoni maidkamuyai son muyu ongga sum tecsoni mönengha fingmuya urago gobit bainatsoni wöarut. ");
INSERT INTO yuw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Wömai yaha, Kopotorochon bapiyadec nocha yong tuctuc mata irim toctocyi itacma worocho boinno entacmaha: ‘Owi amnaho yuha kombiantang, yu wontucmuno toctoc amna.’ “Oro yong tuctuc mata ngorocho wömai urop nocdec boinno öngkup öngkupha tac.” ");
INSERT INTO yuw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yesuho ihoroc yuna youp amnaniho inogung, “Moröma ngo ahi, gobit bainat yai idamoroc.” Ihoroc yuya Yesuho yogoc, “Oro, urop.” ");
INSERT INTO yuw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Oro mit Yesuho Yerusalem imun fauna Oliv sa urongodec ögoc. Osuc tongidocma worochon torocgon tongga uuna youp amnani yu tan tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sa urongodec öngkungmuya Yesuho youp amnani inogoc, “Sonu dönac youp tarut. Tonguc keckec sonidec öngkuicyit.” ");
INSERT INTO yuw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ihoroc inongo inoi korungon bum amnaho sop monidangmahon toroc ihoroc ohongga ito goruc yemoc tongo Kopotorocha dönac ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Nandöngna, goc ogep focfoc morö nocdec öngkuantacma wo tui dehun. Wohong nochon kombic kombic muno, gakain irotgon koing soun.” ");
INSERT INTO yuw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Yu dönac ihoroc yongo idina momdecma yaru auho yuot ohongga tongkoing tong imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tuna Yesuho irot mepmep toup tongmuna dönac youp orongi sinom tuna nepho nogot simbang oririp ohongo gurocdec ohogoc. ");
INSERT INTO yuw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Oro dönac yongbödengga idongga youp amnaniot ongga yagocmai yu ambarac kombingbanac toup togung-maha dungga idung. ");
INSERT INTO yuw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Dungga idiya Yesuho inogoc,” Son yaöha dubang yo. Son idongmuya dönac youp tarut. Tonguc keckecho soni sogiuna möng kahicyit.” ");
INSERT INTO yuw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesuho youp amnani mata ihoroc inongga idina urop amna torop morö engmuya amna mano Yudas worocho osuc fato uyap sing imogoc. Yudas yui youp amna 12hon toropdecma. Yu Yesuot engmuna Yesu ducin ducin tong imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ihoroc tuna Yesuho inogoc, “Yudas, goc Amnahon Manano ducin ducin tong weran tia ayamnaiho noc sogit akep tontanghu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ihoroc inuna Yesuhon youp amnaniho yagungmai tawa amnaho urop Yesu sogit sogita togung. Tongo yu Yesu inogung, “Moröma, gocho yia nontho gobitdec dopna.” ");
INSERT INTO yuw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ihoroc yongmuya urop youp amna auho gobitno sogitmuna öret socsoc amna morömahon youp wabkarac au woto onggimo arocnema wo saringmun möng imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ihoroc tuna Yesuho woroc angga yogoc, “Urop, imi fahun!” Ihoroc yongga ongmuna youp wabkarachon onggimo tun orokogoc. ");
INSERT INTO yuw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","53","Tongo yu amna ebungma ingoroc inogoc, “Tingting oro, nocu emoc amna muno. Worocha tingtinga sinom sonu gopit bainat orin kando yongga febang yo? Sepno sepno wömai nocho öret socsoc bucin soniot itongidot mahong sonu noc sogit akep matogung. Wohong sonu yagunohon fat muno, worocha woroc son kumbong ebangma,” Yesu yu ihoroc inogoc. Oro amna ebungma woi öret socsochon amna dugo orin öret socsoc böchon tawa amna worochon ofisa orin surarohon amna dugo yu ambarac ‘Yesu sogitna’ yongo ebung. ");
INSERT INTO yuw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tuna tawa amnaho Yesu sogida öret socsoc amna morömaho bucin yangat tonggung. Yangat tonguya Pitaho obmukusuc korungon bum ida yu yan fonggoc. ");
INSERT INTO yuw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yan fonguna tawa amnaho böc worochon gomboin ep tobing songga idiya Pitaho yuot onguna ambarac wocin idung. ");
INSERT INTO yuw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tuna mongorec toctoc owi auho Pita among fihic tongo yogoc, “Amna ngo, yu ihorocgon Yesuot itongidoc.” ");
INSERT INTO yuw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ihoroc yuna Pitaho ‘muno’ yongo inogoc, “Noc amna wo makombing imot.” ");
INSERT INTO yuw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ihoroc yongo wönggon obmukusuc idina amna auho Pita angga yogoc, “Yesuhon toropdecma amna au woi goc ngoroc.” Ihoroc inuna Pitaho yogoc, “Muno, noc yuhon toropdecma muno.” ");
INSERT INTO yuw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ihoroc yuna wönggon aua tungu ihoroc bödeuna amna auho Pitaha mata orongi yogoc, “Boinno sinom amna ngorocho Yesuot itongidoc. Yu Galili amna au.” ");
INSERT INTO yuw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ihoroc yuna Pitaho yogoc, “Muno sinom, imanang yaroc.” Mata woroc yongo idina wohogon fup amnanoho mano yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","62","Woroc tuna Yesuho ibanda Pita foring auna Pitaho Morömaho mata osuc inogocma worocha kombingga irotno mep tuna böc gombo wo imun fauna taitdec ongga ointogoc. Morömaho wömai Pita osuc mata ingoroc inogoc, “Önga kumbong ngocin fup abe mano mayi idina goc nocha bongo anfi möp yong namontaroc.” ");
INSERT INTO yuw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Oro, tawa amna Yesuha gön tongga idungma yu forosingga Yesuha mata mene inongga wodung. ");
INSERT INTO yuw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tongo yu Yesu daro borudec tom tongmuya woda möp mata ingoroc inogung, “Numaho gotac? Yong tuctuc yoi!” ");
INSERT INTO yuw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ihoroc tongo mata wontucmuno koböcma au inogung. ");
INSERT INTO yuw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Oro kumbongbödeuna isoc isocane surarohon amna dugo yu engsuran togung. Woi öret socsochon amna dugo orin nongoru gendic fandat fandat amna yu engo wocingon suran tuya tawa amnaho Yesu yuho yangamin yangat tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Yangat tuuya amna morömaho inong ac tongga yogung, “Duic, woi gaka woha muno? Wo tuctugo ninia kombina.” Ihoroc inuya Yesuho yu inogoc, “Nocho son tuctugo kanontatanu wömai son makombing tobing namoning. ");
INSERT INTO yuw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","O ihorocgon nocho son kanong ac tontatanu wömai sonu urago mananoning. ");
INSERT INTO yuw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Worochoi oro, önga forosingga Amnahon Mananoho Gesö Morömo Kopotoroc yuhon obu aroce woce edengoc.” ");
INSERT INTO yuw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ihoroc yuna amna ambaracho yogung, “Ihoroc yarocmaha gocu Kopotorochon Manano itarochu nuhun?” Ihoroc yuya Yesuho yogoc, “Son mata yangma woi boinno.” ");
INSERT INTO yuw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ihoroc yuna yuho yogung, “Oro urop, amna auhon mata makombinin. Yu urop inobut yuna tuctugo kombiamon.” ");
INSERT INTO yuw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Oro amna moröma suran togungma yu ambaracho idongga Yesu Römphon gavman amna moröma Pailat yuot yangat tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yangat tongga Pailatho bucin itmuya amna morömaho forosingga Yesuha mata firing tanda Pailat ingoroc inogung, “Non anaya amna ngorocho kantri ngorochon suraro mata wontucmuno fandat inongga owi amnahon irotno tun fadang uuya yu gavmanthon nongoru yembodidang. Yu wömai namba wan king Sisa yuhon takis möneng sic sicha ‘muno’ ninongitac. O yu inoha yongitac, ‘Duic woi naka, noc amna moröma, king au’ ihoroc yong fandaditac.” ");
INSERT INTO yuw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Amna morömaho Yesuha mata ihoroc firing taruya Pailatho wo kombingga Yesu inong ac tongga yogoc, “Gocu boinno Yudananohon king itarocha woha muno?” Ihoroc yuna Yesuho yogoc, “Gaka yarocma woi boinno.” ");
INSERT INTO yuw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yesuho ihoroc yuna Pailatho öret socsochon amna moröma orin owi amna au wocin idungma yu inogoc, “Noc amna ngorochon tong bumbumnohon foro au maat.” ");
INSERT INTO yuw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pailatho ihoroc yuna owi amnaho yu kiringga imongga mata orongi inogung, “Amna ngo yui Yuda sa guroc danong itongmuna owi amnadec fandat fandat youp tongmuna irotno toup sakangga doun fadang öngidang. Yu wömai Galili provins woce forosingga fandat fandat youpno tong tongmuna urop noniin taundec ngocin öngkupac.” Amna morömaho mata ihoroc firing taruya ");
INSERT INTO yuw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailatho woroc kombingga owi amna inong ac tongo yogoc, “Amna ngo Galilimahu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ihoroc yuna owi amnaho ‘öc’ yuya Pailatho woroc kombingga tawa amnani inuna yuho Yesu sogida king Herötot yangat tonggung. Wömai yaha Heröt yu wömai Galili owi amna yangtorengga matano yun bödengidocmaha yuot yangat tonggung. Bongono worochoi wömai king Heröt Yerusalem taun wocin idoc. ");
INSERT INTO yuw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Oro tawa amnaho Yesu sogida Herötot tohong yugung. Heröt yu wömai Yesuho toroc kiap ihono ihono togocma worochon fatno kombingga ‘Yesuho toroc irömbu au tuna awa’ yongo Yesu acacha toup kombigoc. ");
INSERT INTO yuw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tongo Heröt yu Yesu manomano koböcmaha inong ac togoc mahong Yesuho mata tungu au yu maiban imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ihoroc tuna öret socsochon amna moröma orin nongoru gendic fandat fandat amna yu wocingon itmuya Yesuha mata koböc firing tandung. ");
INSERT INTO yuw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ihoroc tuya mit wömai Herötot tawa amnaniot yu Yesu inong möpmöp toup tongmuya tong kömec toctocha kinghon tec tohomunmöcno ogepma sinom au Yesu tohomu möngimogoc. Woroc tongga yu Yesu wönggon Pailatot yangat tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Oro bongono worocho wömai Herötot Pailatot oröc oröc togomoroc. Osuc wömai yu irot tungudec maididomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Oro Yesu yu wönggon Pailatot idina Pailatho öret socsochon amna moröma orin amna dugo orin suraro yu ambarac inong yuna engsuran tuya ");
INSERT INTO yuw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ingoroc inogoc, “Sonu amna ngo nocot tengga yuha naning, yuho owi amna mata wontucmuno inuna irotno aranggum uuna tong bumbum tongidang. Worochoi oro, non ambarac ngocin itmanaina nocho yuhon foroha inong ac tong imot mahong tong bumbumno au maat. ");
INSERT INTO yuw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","O nakagon muno, king Heröt yu ihorocgon amna ngorochon tong bumbumno maacmaha yu wönggon siuna noniot ngoce epac. Worocha son kombiarut, amna ngo yu wot omom toctochon toroc tong bumbum au matogoc. ");
INSERT INTO yuw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Worocha tongga nocho yu komong tosipdec woda asan imoya ongoun,” Pailatho ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ihoroc yun bödeuna owi amna ambaracho dugo tungu singo mata kararat ingoroc mambodung, “Amna wo wec icha, wuya ompun! Woroc woto o amna au mano Barabas yui asan nimpi!” Ihoroc mambodung. ");
INSERT INTO yuw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas yu wömai owi amnahon irotno tun fadang uuna gavmanot emoc togung. O ihorocgon yu amna au wot omom togoc. Worocha tongga yu yi bucin idoc. ");
INSERT INTO yuw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Oro owi amna yu mata kararat yongga idiya Pailatho wönggon ‘Yesuho orung itun’ yongo surarohon irot tun sum fatfatha mata au inogoc ");
INSERT INTO yuw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","mahong muno woi. Owi amna yu matano makombi köreng toup tongga mambodung, “Ep goröcdec wuya ompun! Ep goröcdec wuya ompun!” ");
INSERT INTO yuw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ihoroc mamboda idiya Pailatho bongo anfi wönggon tun sum fatfathon mata ingoroc inogoc, “Yu yaö tong bumbum togoc? Noc yuhon matahon foro angsoworengga tong bumbumno au maat. Worocha ep goröcdec wotwotno angit maec. Nocho yu komong woda asan imoya ongoun,” ihoroc inogoc ");
INSERT INTO yuw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","mahong owi amna yu ‘Yesu ep goröcdec wuya ompun’ yongo Pailat toup kiring imuya Pailathon matano tohogung. ");
INSERT INTO yuw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tuna Pailat yu owi amnahon matagon tanto ‘Yesu ep goröcdec wuya ompun’ yongo matano yun bödegoc. ");
INSERT INTO yuw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ihoroc tongo amna wontucmuno Barabas woroc Yesu mongurac tongo asan imogoc. Amna woi gavmanot emoc morö tongmuna amna au doun ombung. ");
INSERT INTO yuw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Oro tawa amna yu Yesu yangato tongga uyapdec ongga ida amna au au fedoc. Amna worochon mano Saimon yu woi Sairini böcsadecma. Yu Yerusalem onggonga tongina tawa amnaho yu sogito woding tengga Yesuhon ep goröc imuya yu wo sumbotmuna Yesu tan togoc. ");
INSERT INTO yuw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tuna owi amna koböcho Yesu yan fongmuya owi au Yesuha kombingga yong uroc ap yong tonggung. ");
INSERT INTO yuw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ihoroc tuya Yesu yu ibarun fauna owi wo inogoc, “Yerusalem owi, son nocha yaininga. Muno son muyu soniha o managumboc soniha kombingga yong ointarut. ");
INSERT INTO yuw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kombiarut, mepmo bongono inobarac sinom worocho sonidec öngkuuna sonu tong uroc tongga yonahing, ‘Owi managumboc mabaima yu borongdearut, yu mepmo bongonodec yungano entang.’ ");
INSERT INTO yuw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","O sonu yonahing: ‘Sa urongo, son ohongga non niu weuya öp fiiya focfoc noni bödehun.’ Worocha tongga sonu nocha yongo yaininga, muno son muyu soniha yong ointarut. ");
INSERT INTO yuw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kombiarut, noc naka woi itonggongon ep koingo wohong mepmo ngo nocdec öngkuhac. O sonu woi ep onggomo simbang worocha sondec tingting öngkuangoc? Sondec mepmo moröma sinom öngkuangoc,” Yesuho owi wo ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Oro tawa amna yu Yesuot wöntucmuno toctoc amna yaiot yu kondonggon dopdopha fogito fongga ");
INSERT INTO yuw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","sa au mano bic kudat wocin fohong yugung. Fohong yungga sa woce öngkungmuya Yesu ep goröcdec wodung. Tongo wontucmuno toctoc amna yai tungumaho Yesu oburo aroce o tungumaho wömai oburo kandoce dobung. ");
INSERT INTO yuw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tuna Yesuho yogoc, “Nandöng, goc yuhon turongono imifat impun. Yu toroc kiap tangma worochon foro makombing.” Ihoroc yuna tawa amnaho ‘Yesuhon tec tohomumucno numaho sogiantac’ yongo tim kumec togung. ");
INSERT INTO yuw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Oro owi amna yu foring yango itmuya amna dugo au yu Yesuha mata mene yongo yogung, “Yu amna au wömai tongfat yengidoc, o yu inoha ‘noc Kopotorochon Duic’ ihoroc yongidoc. Worochoi oro, önga ino tongfat yecyechon gesöno wömai maidimoc.” ");
INSERT INTO yuw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ihoroc yongo idiya tawa amna yu ihorocgon engmuya Yesuha mata mene inongmuya auho yamuc beci viniga wo imogung. ");
INSERT INTO yuw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tongo yu inogung, “Goc Yuda nanohon king itarochu nuhun. Itarocanu wömai gakaho gaka tongfat gehi,” ihoroc inogung. ");
INSERT INTO yuw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Oro farang docno au wömai Yesuhon bigo mondopmodec wagang sic sicyi idoc. Irimno wömai ingoroc togung, ‘Amna ngo yu Yuda nanohon king.’ ");
INSERT INTO yuw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Oro wontucmuno toctoc amna au Yesuot ep görucdec idocma yu Yesuha yong samborec mata inongo yogoc, “Goc Kopotorochon Duic itarocanu wömai gocho gaka orin not tongfat neia orung entamon.” ");
INSERT INTO yuw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yu ihoroc yogoc mahong nucno aumaho matano kombingga inongfato yogoc, “Notu omentamot yo. Worocha goc Kopotorocha kombingmina yuha botongga gending impi. ");
INSERT INTO yuw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nodu wömai toroc wontucmuno koböcma tongidomot. Worocha not nibangma wömai forobarac tang. Wohong amna ngo yuhon tong bumbumno tungu au maec.” ");
INSERT INTO yuw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yu ihoroc yongbödengga wönggon Yesu inogoc, “Yesu, goc gakain mom midim sabarac sayadec itmina nocha kombihi.” ");
INSERT INTO yuw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ihoroc inuna Yesuho inogoc, “Nocho boinno sinom gantiwa. Öngagon gocot nocot onoce Kopotorochon sa ogepmadec entamot,” ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Oro apmano 12 kilok bongono wocin sep yaguno bödeuna sa kumbongdigoc. Sa kumbong dingga idina 3aua ihoroc bödeuna sepho wönggon forigoc. Tongo öret socsoc bucin boru moröma idocma worocho bonipnodec wirangga fugo yai idomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tuna Yesu yu ecnang sinom ingoroc mambodoc, “Nandöng, noc yaruna gochon oburadec sihat,” ihoroc yongga omboc. ");
INSERT INTO yuw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Omong fauna tawa amnahon ofisa yu wo angmuna nangano fauna Kopotoroc yong moröng imongga yogoc, “Boinno sinom amna ngo yui Kopotorocho yangamin nongnongo idoc.” ");
INSERT INTO yuw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tuna owi amna engsuran tongga idungma yuho toroc kiap öngkubocma wo angmuya soroc yongo bangaro wicanmuya ‘kou’ yongo ibaru fauna onggung. ");
INSERT INTO yuw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tuna owi amna Yesuha kombing imima orin owi Galili sa guroc imufaunto Yesu tan tebungma yu woi okoce korungonbum itmuya manomano öngkubocma wo foring ac togung. ");
INSERT INTO yuw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","52","Oro amna ogepma nongnongo au mano Yösep yu ‘Yesuhon ep fambangno sogiwa’ yongo Pailatot onggoc. Yu woi Yuda nanohon böcsa mano Arimatea wocema. Yu wömai kombigoc, Kopotorochon mom toborucnoho urop ehantac. Tongo yu worocha torengga idoc. Yu woi Yudananohon kaunsil memba au idoc mahong kaunsilho ‘Yesu wuya ompun’ yongo matano yu bödegocma worocho wömai yuhon irot kombic kombicnodec angit maidoc. Oro amna worocho Pailat Yesuhon epfambangnoha inong ac tuna, Pailatho ‘öc’ inuna ");
INSERT INTO yuw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","yu engo Yesu ep fambangno sogito tohongmuna boru audec tomboda tongo sop ganango auhon woce tongsigoc. Sop ganango worocho wömai amna omima au abe matongsicsicyi kunkun idoc. ");
INSERT INTO yuw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yapmu wo ambaracho wömai Sabathon manomano tong arangarang toctochon sep bongono wocin öngkuboc. Sabat bongono urop engfom togoc. ");
INSERT INTO yuw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Oro owi au yu osuc Galili sa guroc imu fauna Yesuot kondong ebung. Yu wömai Yösep tan tonguya Yösepho Yesuhon ep fambangno sop ganang tohong siuna agung. ");
INSERT INTO yuw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Wo angdengga ibaru fauna böcnon ongmuya manomano unac tugo ogepmani wo ep fambang wagac wagacha tong arangarang fongo figung. Ihoroc tuna Yuda nanohon Sabat bongono urop ebocmaha tongga yu Sabathon gendic sumboda Yesuhon ep fambangno idocan woce wönggon manggung. ");
INSERT INTO yuw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Oro, Sabat bongono bödeuna Söndain kembotsum sinom bongono wocin owiho unac tugoni ogepma tong arangarang togungma wo fogida Yesuhon ep fambangno sigungan woce fonggung. ");
INSERT INTO yuw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ongga agungmai sop morömaho ep fambangno sigocmahon simbuno foc togocma wo ibaruya aramo oke idina sop ganango fagarit fagarityi idoc. ");
INSERT INTO yuw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tuna owi wo angga sop ganang ohongmuya agungmai Yesuhon ep fambangno wocin maidoc. ");
INSERT INTO yuw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Woroc angmuya soroc yongo idiya amna yai tec tohomumöcno föhöc yagunobarac yu wohogon engmunya owi tan idomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Owiho woroc yangga botongga aringmöngga idiya amna yaiho yu inogomoroc, “Son yaha sinom Itonggong Morömoha amna omimahon sadec yabiang? ");
INSERT INTO yuw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yu ngocin maec. Yu urop idongga onggoc. Son osuc Yesuot Galili sae itonggungan bongono wocin yuho worochon yong tuctuc matano urop kanongdegoc. Son edet kamogochu nuhun? ");
INSERT INTO yuw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Yu mata ingoroc kanogoc: ‘Wömuno toctoc amnaho Amnahon Manano sogito ep goröcdec wuya omengoc. Omuna sep youp toctoc anfinodec wömai Kopotorocho yu tun wekuna idongungoc.’” ");
INSERT INTO yuw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Oro amna yaiho owi ihoroc inunya owiho Yesuho mata inogocma worocha kombigung. ");
INSERT INTO yuw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Oro mit owi yu sa wo imu fauna böcnon ongga yapmu agungma worochon fatno Yesuhon youp amnani 11 orin owi amna au wocin idungma yu inogung. ");
INSERT INTO yuw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Oro owi yapmu wo öngkung imogocma woi woroc: Maria woroc böcsa Makdalama, o Yöana, o Jems macno Maria, o ihorocgon owi au ino ot itongidungma yu worocho fatno wo yogung. ");
INSERT INTO yuw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Worochoi owi amna yu fatno wo kombiuya boinno maidoc. Yui yogung, ‘Imanang yang yo.’ ");
INSERT INTO yuw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Wohong Pita yu idongga domdomgon kumkumon woce ongmuna aringmongo sop ganang omoce forigocmai ep fambangu wocin maidoc. Boru ep fambang tom togungma worochogon wömai idina agoc. Ihoroc angga ibarun fauna ‘ngoi tingting sinom öngkupac’ yongo kombic kombic youp morö tongmuna onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Oro sep bongono worochogon Yesuhon youp amnanin yai yu böcnon Emaus woce onggomoroc. Emaus ida Yerusalem onggong woi 10 kilomitahon toroc ihoroc idoc. ");
INSERT INTO yuw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Amna yai yu uyapdec ongtohongmunya manomano öngkubungma worochon fatno inun ganun tongga ongidinya ");
INSERT INTO yuw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","wohogon Yesu ino yuot engkungmuna kondonggon ongtonggung. ");
INSERT INTO yuw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Oro amna yai yui Yesu makombing imongo angtangtang matogomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ihoroc tongo Yesuho amna yai inong ac tongga yogoc, “Sot yaöhon mata fat yong tebamoroc?” Ihoroc yuna yaimaho tonguroc yangam tongmunya ");
INSERT INTO yuw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","nucno auma mano Kliopas worocho Yesu inogoc, “Owi amna Yerusalem taun idangma yu ambaracho manomano öngahemgon öngkubungma wo kombingduptang mahong goc tunguhogon wömai makombiroc?” ");
INSERT INTO yuw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ihoroc yuna Yesuho yogoc, “Yapmu öngkubocma woi yaö sinom yo?” Ihoroc yuna amna yaiho yogomoroc, “Nodu Yesu Nasaretma yudec manomano öngkubocma worochon fatno yongtebamot. Amna wo yu woi Kopotorochon yong tuctuc amna au idoc. Yu youp tongidocmahu o mata yongidocmahu woi Kopotorocho yangamin o owi amnaho yangamin orongi sinom tongidoc. ");
INSERT INTO yuw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wohong öret socsoc amna moröma orin surarohon dugo yu amna wo sogito gavmanthon oburodec siuya gavmantho yu wot omom toctochon matano yun bödeuna ep goröcdec wuya omboc. ");
INSERT INTO yuw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","O au wömai nonu kombigo-mon, Yesuho Israel nanohon ayamihon gesöno tohuna orung itnam, mahong muno woi, yu omong fauna urop sep youp toctoc yai bödeuna sep anfino itac. ");
INSERT INTO yuw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","O önga wömai owi au nonthon toropdecma yu fat au ninuya soroc yomon. Yu kembotgon sinom kumkumon onging. ");
INSERT INTO yuw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Woce ongga aingmai Yesuhon ep fambangno wocin maec. Ihoroc angga ibaru fauna fatno ingoroc nining, ‘Yaru au öngkung nimongo ninogoc, ‘Yesu yu ngocin maec yö! Yu mamec wec itongeyac.’ ");
INSERT INTO yuw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ihoroc ninuya nucnoni auho kumkumon woce ongmuya owiho yingma worochon torocgon aing. Worochoi oro Yesu ino boinno maing.” ");
INSERT INTO yuw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Amna yaima ihoroc yunya Yesuho inogoc, “Sodu irot kombic kombic sodiu maechu nuhun. Sodu Kopotorochon yong tuctuc amnaho mata yogungma wo makombing tobingidamorochu nuhun. ");
INSERT INTO yuw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mata wo kombinggahai wömai sot ingoroc kombiun: Duic yu muyu focfoc kombingga idongga Kopotorochon yaguno sadec ongga ma morö sogihun.” ");
INSERT INTO yuw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yesuho ihoroc inongga mit wömai Kopotorochon bapiya wocin inoha yaö mata sinom idangma, worochon foro fandat inogoc. Forosingga Möseho mata togocma o mit yong tuctuc amna yuhon mata irim toctocyi idangma wo ambarac fandat inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mata ihoroc yongmuya ong tongga urop Emaus böcsa ambehecgon ongkubung. Tuna Yesu yu amna yai wo dongyun fauya uyap auhon onggonga togoc, ");
INSERT INTO yuw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","mahong amna yaimaho ‘muno’ yongga Yesu inogomoroc, “Sep urop ohuna kumbong dicdicha tacmaha goc nodot ngocin itna.” Yaimaho ihoroc inunya ino bucin woce öngo idung. ");
INSERT INTO yuw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wocin itmuya nacno nocnocha tongga Yesuho nacno sowarango sogitmuna Kopotorocha ecec inongo uboto amna yaima imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ihoroc tongo idina wohogon amna yaiho aun tuctuc yogoc. Aun tuctuc yuna wohogon Yesu amna yai dongyun fauna gorong onggoc. ");
INSERT INTO yuw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Gorong onguna amna yai wo inohogon inun ganun tongo yogomoroc, “Boinno sinom not uyapdec engitdaya bonip nodidec öngkung nimongga Kopotorochon bapiyadec mata idangma fandatninong tehuna irotnodi fadaacma wo woi woroc.” ");
INSERT INTO yuw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Amna yai yu ihoroc yongga idongga karupgon Yerusalem onggomoroc. Ongga yagomorocmai Yesuhon youp amnani 11 yuot nucni auot yu suran tongga idung. ");
INSERT INTO yuw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Suran tongga idiya amna yaima ehunya yangga inogung, “Boinno sinom, Moröma noni yu urop idongga Saimon öngkung imoc.” ");
INSERT INTO yuw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ihoroc inuya amna yaima yu ihorocgon yapmu uyapdec öngkung imocma worochon fatno inongo yogomoroc, “Yesu yu not ihorocgon öngkungnimoc mahong osuchai not yu mang tuctuc tomot. Not bumbum yongo itdaya mit wömai bucin öngo itmanaina yu nacno sowarango sogito uboto nimocan wocinthong angtuctuc tomot,” fat ihoroc yogomoroc. ");
INSERT INTO yuw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Oro youp amnaniho mata fat ihoroc yongo idiya urop Yesu inoho yuhon bonipnodec öngkungga inogoc, “Irot soni gucno idarut.” ");
INSERT INTO yuw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ihoroc yuna youp amnaniho soroc yongmuya ‘ei ngo dogu auhu’ yongo kombigung. ");
INSERT INTO yuw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ihoroc kombiuya Yesuho inogoc, “Son foro yaha soroc yongga ‘nocha dogu auhu’ yongo kombiang? ");
INSERT INTO yuw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Son orung obuna ngo yaarut. Noc nakaho sinom ngo itatma. Godibna wot möngga aarut. Dogu yui goumo kudatno muno.” ");
INSERT INTO yuw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yu ihoroc yongga orung oburo indauna agung. ");
INSERT INTO yuw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Angmuya kombingbanac tongmuya borongdedung. Wohong yu abe irot yai tongga idungmaha Yesuho yu inogoc, “Son nacno au idanghu?” ");
INSERT INTO yuw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Ihoroc yuna söng au songo sicsicyi woroc imuya nauna agung. ");
INSERT INTO yuw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yesuho ihoroc tongo inogoc, “Noc osuc sonot itmaina mata ingoroc kanogot: Nakaha mata irim toctocyi idangma woi ambarac boinno öngkungbödehun. Mösehon matadec itacmahu o Kopotorochon yong tuctuc amnahon bapiyadec itacmahu o ihorocgon ap bapiyadec nakaha irim toctocyi itacma woroc woi ambarac boinno öngkungbödehun.” ");
INSERT INTO yuw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ihoroc inongo Yesuho ‘yu Kopotorochon bapiyadec mata idangma wo kombing tangtang tarut’ yongo ");
INSERT INTO yuw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ingoroc inogoc, “Kopotorochon bapiyadec mata ingoroc irim toctocyi itac: Kopotorochon Duic yu focfoc morö kombingga omongga mit sep youp toctoc anfidec omocdecma idongga ongungoc. ");
INSERT INTO yuw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Idonguna yuhon madec wömai fatmata ogepmaho sa guroc danong ongbödeuna owi amnaho kombingga irotno ibaruya Kopotorocho turongono doun fatnahing. O son fatmata ogepma fandat inoc inoc youp ngo wömai Yerusalem taun woce forosinung. ");
INSERT INTO yuw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Sonu nocho toroc kiap ihono ihono tongidotma wo ambarac dan soniho yangidung. Worocha wömai sontho ngorochon fatno yong fandatnahing. ");
INSERT INTO yuw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kombiarut, osuc Nandöngnaho Kunkun Yaru siuna sonot ebepha yongo mataho godingmun fadoc. Ihoroc yogocma woi nocho ongmaina woroc siaya ehangoc. Nocho Nandöngot ongoya son Yerusalem taun ngocingon torengga idiya Kopotorocho gesöno siuna ehangoc,” Yesu yu ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Oro Yesu yu youp amnani dong yangauna böcsa au mano Betani woce onggung. Woce itmuya Yesuho oburo tun fadauna youp amnani guramno sing imogoc. ");
INSERT INTO yuw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ihoroc tongga idina Kopotorocho Yesu sogito momdec tögoc. ");
INSERT INTO yuw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tuna youp amnani wo angga wocingon goruc yemoc tong imongo yong moröng imogung. Ihoroc tongo kombing borong tongmuya ibaru fauna Yerusalem taun onggung. ");
INSERT INTO yuw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Yerusalem itmuya bongono muno öret socsoc bucin öngo Kopotoroc yong moröng imongidung. ");
INSERT INTO yuw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Oro, osucgon sinom, manomano ambarac abe maöngkui idiya, Kopotorochon mata itonggongnobarac, Duic, yu urop itdegoc. Yu Kopotorocot idoc. O Duic ino woi Kopotoroc. ");
INSERT INTO yuw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yu woi osuc sinom forosicsicnodec urop Kopotorocot itdegoc. ");
INSERT INTO yuw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Oro yudec singga Kopotorocho sa guroc manomano ambarac doun öngkubung. Yapmu au komanang maöngkuboc. Muno, manomano ambarac öngkubungma woi Kopotorocho Duicdec singga doun öngkungbödegung. ");
INSERT INTO yuw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Duic yu woi itonggong koingbarac. Tongo yu nonot engmuna guroc amnahon yaguno idoc. ");
INSERT INTO yuw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yu worocho wömai kumbong yaguno möngga iditac. Tuna kumbongo yuhon gesöno obmukusuc au matohogoc. ");
INSERT INTO yuw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Oro Kopotorocho amna au yaguno worochon foro yong tuctuc yocyocha inongmuuna eboc. Amna worochon mano Jön. Kopotoroc yu ‘owi amna ambaracho yuhon matano kombiuya yagunoha kombing tobing imongitnung’ yongo amna woroc inongmuna eboc. ");
INSERT INTO yuw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Wohong Jön ino woi yaguno maidoc. Muno, yu ebocma woi yagunohon foroha ninong tangtang toctocha eboc. ");
INSERT INTO yuw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kopotorochon yaguno boinno woi Duic yu woroc. Yuho wömai owi amna ambarac yaguno möng imocimocha gurocdec noniot eboc. ");
INSERT INTO yuw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yuho engmuna nonot itongidoc mahong guroc amnaho wömai yuhon forono kombing tuctuc matogung. Kopotorocho sa guroc manomano ambarac yudec singga doun öngkubung mahong guroc amnaho yu me imogung. ");
INSERT INTO yuw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mom sa guroc woi yuhon fat itbödeang mahong guroc amnaho yu oröc matong imogung. ");
INSERT INTO yuw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Wohong owi amna yu oröc tong imongmuya kombing tobing imongidungma yu wömai Kopotorocho kombing imuna yuhon weni manani öngkubung. ");
INSERT INTO yuw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kopo-torochon weni manani öngkubungma wömai mac nandöngon nogotha muno, o ihorocgon amna auhon kombic kombicha muno, o ihorocgon godip föbhon ibiboha muno. Kopotorocho ‘yu nakain wenai mananai sinom idarut’ yongo yu doun wego öngkubung. ");
INSERT INTO yuw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Oro Kopotorochon mata worocho amna öngkungmuna nonthon bonip nonidec bongono docutno itongidoc. Itongidina nontho yuhon toroc kiapmo yaguno wairurunobaracho wo angtangtang togomon. Kiapmo ihorocno wömai Kopotorocho inoin Manano batip sinom yuha-gon imongitac. O yuhagon tongga Kopotorocho non ningbangitac. O yu wömai Kopotorochon mata boinno ninuna kombigomon. ");
INSERT INTO yuw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Oro Jön yu Duichon yong tuctuc mata ninogoc. Yu mata orongi yongga yogoc, “Nocho amna ngorocha osucgon kanongdegot, ‘Amna noc menan engtepacma yu woi nochon öngitna. Noc abe maöngkung edeya yui urop idoc,’” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Oro Duicdec wömai Kopoto-rochon banac banacno foc tongga idoc. Worocha tongga yu non ningbanauna bongono bongono guram foro ihono ihono nondec öngkung nimongidoc. ");
INSERT INTO yuw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nongoru wömai Kopotorocho Möseho oburodec nimogoc. Wohong banac banachon uyap boinno wömai Kopotorocho ‘Yesu Duichon youpha’ yongo tun öngkung nimogoc. ");
INSERT INTO yuw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Non guroc amna non Kopotoroc mangidamon. Muno, Kopotorochon Manano batip sinom yuhogon wömai Kopotorochon foro kombingdehac. Tongo yu nonot engmuna Nandöngon foro nindauna nontho kombing tuctuc tongidamon. ");
INSERT INTO yuw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Oro Yuda nanohon amna moröma Yerusalem taun ididungma yu öret socsoc amna orin Livaihon toropdecma amna au inongmuya Jön yamuc gupgup forosicsic amna yuot onggung. Yuot ongmuya inong ac tongga yogung, “Gocu numa sinom, gocu Duic worochu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ihoroc inuya Jöntho inoin forono öp masii eran sinom inong tuctuc tongga yogoc, “Nocu amna Kopotorocho weran sing imogocma Duic, woroc muno.” ");
INSERT INTO yuw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ihoroc yuna amna ebungma yu wönggon inong ac tongga yogung, “Tingting oro, gocu Elaiyahu nuhun?” Ihoroc inuya Jöntho ‘muno’ yogoc. ‘Muno’ yuna yuhoi kiringga wönggon inogung, “Oro, Möseho yogoc, Kopotorochon yong tuctuc amna moröma yu ehangoc. Gocu worochu nuhun?” Ihoroc inuya Jöntho wönggon ‘muno’ yongo yogoc, “Noc woroc muno.” ");
INSERT INTO yuw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ihoroc yuna yu madango inong ac tongga inogung, “Worochoi oro, gocu numa sinom oro. Gocu gakaha tingting yongitaroc. Goc ninong tuctuc tia nonu ongmanaina amna moröma ninong mudungma yu inongburoc tonaya kombiarut.” ");
INSERT INTO yuw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ihoroc inuya Jöntho yong tuctuc amna Aisaia yuhon mataha kombingmuna mata urago ingoroc inogoc, “Nocu sa moropmodec itmaina Kopotorochon mata ingoroc yong mamboditat: ‘Morömahon uyap tong nongnong tarut.’” ");
INSERT INTO yuw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jön yu ihoroc yuna Farisi ebungma ");
INSERT INTO yuw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","yu Jön ingoroc inong ac togung, “Oro gocu Duic muno, o gocu Elaiya muno, o ihorocgon gocu yong tuctuc amna moröma wo muno? Worochai oro, foro yaha gocu owi amna yamuc gung imongitaroc?” ");
INSERT INTO yuw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ihoroc yuya Jöntho inogoc, “Nocu yamucgon gung kamongitat mahong amna moröma yu urop bonip sonidec itongeyac. Wohong sonu yu abe makombing iming. ");
INSERT INTO yuw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nocu yu osuc fat imoya yuho menan ehangoc. Yu woi amna moröma sinom gendicma. Nocu yu simbang muno worocha woroc, noc yuhon mene darange angit matoctocno,” Jön yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Oro mata wo inun ganun togungma wömai Yödan yamuc ökene böcsa au mano Betani, wocin togung. Jöntho sa woce itmuna owi amna yamuc gungimongidoc. ");
INSERT INTO yuw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Oro kembotsum Jöntho agocmai Yesu ino yuot eboc. Wo angmuna yogoc, “Aarut! Kopotorochon bot sipsip beracno. Yu worocho guroc owi amnahon wontucmuno sumbotmuna dongyun bödenahing. ");
INSERT INTO yuw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nocho amna worocha urop kanong tuctuc tongga yogot, ‘Amna noc menan engtepacma yui moröma, yu noc nanggirahac. Noc abe maöngkui edeya yu urop idoc.’ ");
INSERT INTO yuw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nocho yu abe makombing imot. Wohong nocho engmaina ‘Israel nano Duicha tong arangarang tongga idarut’ yongo yu yamucdec gung imongitat.” ");
INSERT INTO yuw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Jön yu mata sakaun fiuna Duicha wönggon ingoroc yong tuctuc yogoc, “Kopotorocho ‘owi amna yamuc gung impi’ yongo noc nanong muuna ebot. Tongo yu nanogoc, ‘Weranno wömai ingoroc engoc: Kunkun Yaruho yudec ohongga yuot engoc. Amna worocho wömai owi amna Kunkun Yarudec gung imangoc.’ Ihoroc nanogocma worochon boinno noc urop angdet. Noc aaya Kunkun Yaruho yup kanaröm gan tongga mom imun fauna ohongga amna worocdec idoc. ");
INSERT INTO yuw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Oro nocu weran wo yudec angdegotmaha ingoroc kanong tuctuc towa: ‘Amna ngoi Kopotorochon Manano,’” Jön yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Oro kembotsum Jönot youp wabkaracnin yaiot yu ongmuya osuc youp togungan woce wönggon idung. ");
INSERT INTO yuw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Woce itmuya Jöntho agocmai, Yesu yu uyap ongga idoc. Tuna Jöntho yogoc, “Aarun! Yu woi Kopotorochon bot sipsip gumboc. Kopotorocho turongo noni tun bödec bödecha tong arangarang togocma woroc.” ");
INSERT INTO yuw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ihoroc yuna youp wabkaracnin yaimaho mata woroc kombingga ongga Yesu tan tonggomoroc. ");
INSERT INTO yuw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tunya Yesuho ibarun fauna yaima yangmuna inogoc, “Sothu yaöha nocot ebamoroc?” Ihoroc inuna yaimaho inogomoroc, “Rabai, gocu böcsa nahe sinom iditaroc?” (Ma ‘Rabai’ ngorochon foro wömai fandat fandat amna.) ");
INSERT INTO yuw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ihoroc yunya Yesuho inogoc, “Sot engga aarun.” Ihoroc inuna yaimaho Yesuot ongmunya böcno wo angtangtang tongga Yesuot kondonggon woce idung. Woi 4 kilokdec ongga dobocsisi. Doboc siuna ibarun fauna onggomoroc. ");
INSERT INTO yuw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Oro amna tunguma woi Saimon Pita worochon orugo mano Andru. Yu Jöntho Yesuha mata yogocma wo kombingga Yesu tan tonggoc. ");
INSERT INTO yuw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tongo mit yu domdomgon ongmuna orugo Pita aun feuna inogoc, “Non urop Mesaia ana fec.” (Ma ‘Mesaia’ worochon foro wömai ingoroc: Kopotorocho amna ngo ‘owi amnani wöntucmunodecma öcangyun möarut’ yongo weran togocma, woi Duic.) ");
INSERT INTO yuw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Oro Andru yu ihoroc tongga orugo Saimon yangada Yesuot tonggoc. Yangat tonguna Yesuho yu angmuna inogoc, “Gocu Saimon Jönthon manano. Nocho maya wego ‘Sepas’ ihoroc mambotiwa.” (Ma ‘Sepas’ woi ‘Pita’ worocgon. Worochon foro wömai grik matadec ‘sop’ ihoroc.) ");
INSERT INTO yuw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Oro kembotsum Yesu yu ‘Galili gurocin ongowa’ yongo uyap forosigoc. Uyap ongmuna Filip aun feuna inogoc, “Goc engga noc nari.” ");
INSERT INTO yuw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip, Andru orin Pita yu böcno tungu, mano Betsaida. ");
INSERT INTO yuw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip yu ongga amna au mano Nataniel yu aun feuna inogoc, “Kombihi, nonu amna moröma ana fec. Yuha wömai Möseho nongoru bapiyadec yongtuctuc mata singdegoc. O yong tuctuc amna osuc idungma yu ihorocgon yuhon yong tuctuc matano irim togung. Amna worochon mano Yesu, yu woi Yösephon manano, taun Nasaretma.” ");
INSERT INTO yuw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Filipho ihoroc inogoc mahong Nataniel yu yogoc, “Yapmu ogepma au Nasaretdecma maöngkuic.” Ihoroc yuna Filipho wönggon inogoc, “Gakabut engga ahi.” ");
INSERT INTO yuw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ihoroc inuna ongunya Yesuho Nataniel angmuna yogoc, “Amna ngo epacma yui Israel amna boinno. Yudec imanang matahu o imanang toroc kiap au maec.” ");
INSERT INTO yuw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ihoroc yuna Natanielho inong ac tongga yogoc, “Gocu noc tingting sinom kombing namparoc?” Ihoroc yuna Yesuho inogoc, “Kombiharoc, Filipho goc abe maganong yongidina noc gaaya ep fik worochon forodec eroc.” ");
INSERT INTO yuw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ihoroc yuna Natanielho mata woroc kombingga inogoc, “Fandat fandat amna, gocu Kopotorochon Manano. Gocu Israel nanohon king.” ");
INSERT INTO yuw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ihoroc yuna Yesuho inogoc, “Nocho ganot, ‘goc ep fik forodec idiya gaat’ ihoroc ganotmaha gocu urop noc kombing tobing namparochu. Woroc woi yapmu obugu. Worochoi oro, oipmon wömai goc aaya yapmu moröma öngkuangoc.” ");
INSERT INTO yuw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ihoroc inongga mata au sakaun fiuna yogoc, “Nocho boinno sinom kantiwa, oipmon son auya mom simbu fagariuna Kopotorochon sum yaruho Amnahon Mananodec uhi ohoi tonahing.” Yesu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Oro Yesuho Filip orin Nataniel inong yuna sep youp toctoc yai bödeuna böcsa au mano Kena, Galili distrik wocin amna au yu oweno obu fogit fogithon tong sonoc morö togoc. Tuna Yesuhon macno yu woce idoc. ");
INSERT INTO yuw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","O Yesu orin youp amnani yu ihorocgon inong wodiuya yu ambarac woce onguya idung. ");
INSERT INTO yuw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Oro tong sonoc morö tongga idiya wain yamuc bödec bödec yuna Yesuhon macnoho Yesu inogoc, “Wain yamuc urop bödec bödecha tac.” ");
INSERT INTO yuw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ihoroc inuna Yesuho inogoc, “Mac, ngomai nochon manomano muno, nochon bongono abe maehac.” ");
INSERT INTO yuw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ihoroc yuna macnoho youp wabkarac inogoc, “Yuho yapmu au toctocha kanunai wömai son muyu matano sumbotmuya worochon torocgon tarut,” ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Oro bongono wocin yamuc ureng moröma 6 sopdec tobic tobicyi ihorocho böc wocin idung. Yuda nano yu wömai inoin toroc kiap sindanmuya yamuc ureng worocdec yamuc geda gungidung. Yamuc ureng worochon irotnon wömai yamuc 100 litahon toroc bego idoc. ");
INSERT INTO yuw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Oro Yesu yu youp wabkarac ingoroc inogoc, “Son yamuc koriuya ureng ngo foc tongga idarut.” Ihoroc inuna yu yamuc geda fengga ureng wo foc tocno sinom togung. ");
INSERT INTO yuw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Foc tongga idiya Yesuho youp wabkarac inogoc, “Son kap au sogitmuya yamuc au geda amna nacno angtorehacma yu teng imarut.” Ihoroc inuna wabkaracho worochon toroc tuya ");
INSERT INTO yuw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","nacno angtorec torec amna yu wo sogida nangga kombigocmai, yamuc wo wain gandup tongga ibibo sinom idoc. Tongo yu wain wo nahema geda tebungma worochon foro makombigoc. Youp wabkarac yamuc ureng tong foc togungma yuhogon wömai kombigung. Tuna amna nacno angtoregocma yu tong sonochon morömo inong yongga ");
INSERT INTO yuw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","inogoc, “Non ambarac wömai toroc kiap ihorocno tongidamon, non wain yamuc soworengga ibibo sinom itacma wo osuc owi amna imongidamon. Tuya owi amnaho yamuc koböcma nongga bumbum yongga idiyai oro mithu wömai wain yamuc sumoma wo geda owi amna imongidamon. Nonu ihoroc tongidamon mahong gocu ihoroc matoroc. Gocu osuc wain yamuc sumoma wo nimparoc. Wo nauya bödeuna oro mit wain yamuc ogepma mönengno önggöngyi feng nimparoc,” ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Oro Yesu yu Kana böcsa Galili gurocin itmuna toroc irömbu wo fodibo sinom togoc. Ihoroc tuna yuhon gesö moröma Kopotorocho imogocma worocho eran öngkuuna youp amnaniho woroc angga yuha kombing tobing imogung. ");
INSERT INTO yuw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Oro mit Yesuho macno ot Kaperneam bucin onggoc. Tuna yuot orugiot youp amnaniot yu ambarac sep youp toctoc au woce idung. ");
INSERT INTO yuw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Oro Yuda nanohon bongono moröma ‘Pasowa’ wo urop eng fom togoc. Woi bongono moröma Kopotorocho Israel nano yang banauna ogep idung worochon bongono. Tuna Yesu yu Yerusalem taun ögoc. ");
INSERT INTO yuw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Öngga yu öret socsoc böchon gombo ganang öngga yagocmai, bisnis amna yu wocin itmuya bot bulmakauhu o bot sipsiphu o yup kanarömphu wo fiuya owi amnaho wöngidung. O aumaho wömai inoin abamodec itmuya möneng imun gamun youp tongo idung. ");
INSERT INTO yuw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ihoroc tongga idiya Yesuho wo yangga ec imuna yi sopsop au sogitmuna bot sipsip, bulmakau wo ambarac dong yandup togoc. Tongo yu amna möneng youp togungma worochon möneng docno tong samborec tongga abamnoi ibanda koringyun möng imogung. ");
INSERT INTO yuw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tongo amna yup kanaröm figungma yu inong fata inogoc, “Son yup soni fogida fongurit. Son ihoroc tuya Nandöngnahon böc ngorocho maket tait simbang öngkupac,” ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tuna Yesuhon youp amnani yu Yesuhon kiapmo wo angmuya Kopotorochon bapiyadec mata au itacma worocha kombigung. Mata wömai ingoroc itac: “Nocu gochon böcaha toup kombihatmaha irotna aranggum uuna ‘böc ngorocho kunkun itun’ yongo youp orongi tangot.” ");
INSERT INTO yuw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ihoroc tuna Yuda nanohon amna dugo au yu wo auya angit maidina Yesu inong ac tongga yogung, “Gocu momphon toroc kiap au tia nontho woroc angga kombinam, ‘boinno gocu Kopotorochon madec engmina amna wo ogep dongyaria ongup.’” ");
INSERT INTO yuw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Amna dugo yu ihoroc yuya Yesuho mata ökene iban imongga inogoc, “Son öret socsoc böc ngo gumaruya nocho wönggon sep anfihagon temongma öangoc.” ");
INSERT INTO yuw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ihoroc yuna amna dugoho yogung, “Mayain öret socsoc böc ngomai biruc 46 worochon irotnon temongmu öcöchon youpno togung. Worochoi oro gocu tingtinga sep youp toctoc anfihagon tongbödec bödecha yaroc yo?” ");
INSERT INTO yuw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ihoroc inogung mahong Yesu yu öret socsoc böc sinompha mayogoc. Muno yu inoin godip föbohon mata tepmogon yogoc. Worocho wömai sep youp toctoc anfi omongga ida wönggon idongungoc. ");
INSERT INTO yuw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kopotorocho Yesu kumkumondecma tun wekogocan bongono wocingon wömai youp amnaniho mata tepmo ngorochon forono kombing tangtang togung. Tongo yu mata Kopotorochon bapiyadec itacma orin Yesuhon mata wo ambarac ‘boinno itac’ yongo kombing tobigung. ");
INSERT INTO yuw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Oro bongono morö ‘Pasowa’ worocho engkuuna Yesu yu Yerusalem taun itmuna toroc kiap inobarac sinom ihono ihono tuna owi amna koböcmaho wo angga Yesu kombing tobing imogung. ");
INSERT INTO yuw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yu kombing tobing imogung mahong Yesu yu inoin foro amna au eran maindagoc. Wömai yaha yu owi amnahon irot urop soworengdeuna arangarang mayogung. ");
INSERT INTO yuw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yesu yu owi amna ambarachon foro kombingbödegoc. Amna auho inong tuctuc matogoc, muno yu inobut soworengga owi amnahon irot kombic kombic kombingbödegoc. ");
INSERT INTO yuw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Oro amna moröma au mano Nikodemus yu wocin idoc. Yu woi Yuda nanohon kaunsil memba o yu Farisihon toropdec sakaun ficficyi. ");
INSERT INTO yuw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Oro, amna worocho kumbong Yesuot engmuna ingoroc inogoc, “Fandat fandat amna gocu toroc kiap inobarac sinom tongitarocmaha nonu kombiamon, Kopotorocho goc ‘fandat fandat amna iti’ yongo ganong yuna eboroc. Kopotorocho amna au matongfat yeunai wömai yu toroc kiap gocho tongitarocma, iho angit matun.” ");
INSERT INTO yuw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ihoroc inuna Yesuho mata ökene ingoroc iban imogoc, “Nocho boinno sinom gantiwa, Kopotorocho tuna amna au yu managumboc simbang wego maöngkuicmai wömai yu Kopotorochon mom toborucno maun feic.” ");
INSERT INTO yuw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ihoroc yuna Nikodemusho kombiun matuctuc yuna wönggon inogoc, “Tingting oro, amna basi detdetyi yu ting tongga wönggon wego öngkupnahing? Yu wönggon macnoho modibon uuna macnoho wönggon bacbacnoha woha tingting?” ");
INSERT INTO yuw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ihoroc yuna Yesuho inogoc, “Nocho boinno sinom gantiwa. Amna au yu irotno ibanda yamuc guantacanu wömai Kunkun Yaruho tuna yu Kopotorocho yangamin nongnongo itmuna Kopotorochon midim sabarac sa woce ongmuna itonggong koing aun feangoc. Ihoroc maticma wömai yu woce mangic. ");
INSERT INTO yuw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Godibhon toroc kiapdec öngkup öngkupyi woi godibhongon o Kunkun Yaruhon toroc kiapdec öngkup öngkupyi woi Kunkun Yaruhon. ");
INSERT INTO yuw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Nocho wego öngkup öngkupha mata ganotma worocha soroc yirocha. ");
INSERT INTO yuw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kiapmo worocho wömai sum tongitacma simbang, sum yu inoin ibibogon tanda woce woce busongitac. Tuna gocu kikoröpnogon kombingitaroc mahong nahe ida epacnohu o nahe ongeyacno wömai makombiroc. Oro, Kunkun Yaruho ting tuna amna au wego öngkuantacno worochon foro wömai gocu ihorocgon angit makombiroc mahong amna auho irotno ibarunai wömai gocu yuhon toroc kiapmo wego angmina kombiantaroc, amna wo yu boinno sinom wego öngkuboc.” ");
INSERT INTO yuw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Yesu ihoroc yuna Nikodemusho kombiun matuctuc yuna wönggon inong ac tongga yogoc, “Manomano ngo yarocma wo woi tingtingno sinom öngkuun?” ");
INSERT INTO yuw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ihoroc yuna Yesuho inogoc, “Mayain, gocu Israel nanohon fandat fandat amna itaroc mahong ngorochon foroi kombing tangtangu matoroc. ");
INSERT INTO yuw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nocho boinno sinom gantiwa, nonu manomano tuctugo kombiamonma worochon matagon yongidamon. O manomano yang tangtang togomonma worochon forogon wömai yong fandadidamon mahong son amna moröma sonu mata noni makombing tobingidang. ");
INSERT INTO yuw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","“Nocho osuc gurochon manomanohagon fandat kanongidot mahong sonu nochon mata makombing tobigung. Worochai oro, nocho momphon manomanoha fandat kanoyai wömai tingtingno kombing tobing namontang? Woi muno. ");
INSERT INTO yuw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Amna auho momdec maögoc. Muno, Amnahon Manano yu tunguhogon wömai momdec ito guroc ngocin ohogoc. ");
INSERT INTO yuw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Osuc Möseho sa amna maiyan woce gorom tun fadauna suraroho wo angmuya orokogung. Oro worochon torocgon wömai Amnahon Manano ep goröcdec tuu fadauna ");
INSERT INTO yuw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","owi amna ambaracho yuha kombing tobing imonahingma yu wömai orokongga itonggong koing sogitnahing. ");
INSERT INTO yuw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Wömai yaha, Kopotoroc irot basi sinom, yu guroc ngorochon owi amnaha toup kombingitac. Worocha tongga yu inoin Manano batip sinom ‘nontha’ yongo boging nimogoc. Tuna owi amna yuha kombing tobing imongidangma yu magorong ongoning. Muno, yui itonggong koing sogitnahing. ");
INSERT INTO yuw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","“Kopotorocho Manano sigocma wömai owi amna mata youpdec fohong yucyucha muno. Mananohon youpha tongga Kopotorocho owi amna wontucmunodecma öcangyun muuya batip itnahing. ");
INSERT INTO yuw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Boinno sinom, owi amna yu kombing tobing imongidangma yu wömai mata youpdec gorong onggongon fat maitning. Wohong owi amna yu makombing tobing imingma yu urop guroc ngocin Kopotorocho yangamin amna omomyi simbang idtongga mata youpdec gorong ongbödenahing. Wömai yaha, yu Kopotorochon Manano batip sinom yuha makombing tobing imogungmaha. ");
INSERT INTO yuw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Oro mata youpdec idithon foro wömai ingoroc: Yagunoho gurocdec engkuboc mahong guroc amnaho kumbongnodec itonggonga toup kombigung. Tongo yu toroc kiap wontucmuno toctocha kiringga yaguno me imongidung. ");
INSERT INTO yuw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Wontucmuno toctoc owi amna yu wömai ‘toroc kiap wontucmunononi eran öngkuicyit’ yongo yagunoha ayam tong imongidang. ");
INSERT INTO yuw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wohong owi amna Kopotorochon toroc kiap boinno tanidangma yu wömai yagunodec eran itongidang. Ihoroc tuya suraroho yu yangmuya kombiantang, boinno sinom, Kopotorocho yu tongfat yeuna toroc kiap nongnongodecgon itongidang,” Yesu yu Nikodemus inong tuctuc ihoroc togoc. ");
INSERT INTO yuw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Oro mit Yesuot youp amnaniot yu Yudia gurocin ongga bongono au woce itmuya Yesuho owi amna yamuc gung imogoc. ");
INSERT INTO yuw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Oro Jön yamuc gupgup forosicsic amna yu ihorocgon owi amna yamuc gung imogoc. Yu wömai sa au mano Ainon woce idina owi amna koböcmaho epgon tuya yu yamuc gung imogoc. Ainon sa woi Salim böcsa ambehecgon. Woce wömai yamuc moröma idoc. ");
INSERT INTO yuw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Bongono wocin wömai Jön abe orung idoc. Herötho yu yi bucin abe matohong yugoc. ");
INSERT INTO yuw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Oro oipmon Jönthon youp amnaniho Yuda amna tunguot mataho emoc togung. Yu wömai ‘yamuc gupgup kiap tingtingno sindanda Kopotorocho yangamin sacsago öngkuantamon’ yongo yong osudung. ");
INSERT INTO yuw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ihoroc tongga yu Jönot ongmuya inogung, “Fandat fandat amna kombihi, amna au osuc Yodan yamuc ökenne gocot idocma o goc yuhon yong tuctuc mata yogorocma, amna wo yu inobut owi amna yamuc gung imongga itac. Ihoroc tuna owi amna ambaracho yuot ongbödeang.” ");
INSERT INTO yuw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ihoroc yuya Jöntho mata ökene iban imongga yogoc, “Oro Kopotorocho amna au youpno imuna amna yu worochon torocgon tun. ");
INSERT INTO yuw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Son sonibut nocho Duicha mata yogotma wo kombingdegung. Nocu Duic muno. Kopotorocho ‘goc Duichon uyap tong arangarang tongga osuc fat impi’ yongo nanong muuna ebot. ");
INSERT INTO yuw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kombiarut, owi berac yu opnoho bucin öngga yuot kondong entac mahong amna worochon orugo yu orugo owi berac tong sihacmaha borongdeantac. Oro worochon torocgon wömai nocho ahatmai suraro moröma urop Yesuot ongidang. Nocho wo angga toup borongdehat. ");
INSERT INTO yuw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","“Kombiarut, Kopotorocho noc youp namogocma urop bödeuna komong engot mahong Duic yu inoin youp forosingga ma moröma sogihun. ");
INSERT INTO yuw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Momphon amnaho non guroc amna ambarac ninggiratbödehac. Non guroc amna nonu gurochon manomanogon kombingmanaina worochon fatnogon yongidamon. Wohong amna momdecma yui manomano ambarachon öngitno. ");
INSERT INTO yuw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yu momdec itmuna momphon manomano angbödegoc. Tongo yu worochon mata fat ninongitac mahong guroc amnaho yuhon fatno kombiuya angit maec. ");
INSERT INTO yuw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wohong owi amna auho yuhon mata kombiuya angit idina sogit akep tongidang. Tuya nonu kiap ihorocno yangmanaina kombiamon, boinno sinom, Kopotorochon mata woi boinnogon. ");
INSERT INTO yuw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kopotoroc yu Kunkun Yaru Duicdec siuna foctuna yu Kopotorochon matagon fandat ninongitac. ");
INSERT INTO yuw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nandöng Kopotoroc yu Mananoha toup kombihac. Worocha tongga yu manomano ambarac yuhon oburodec fingbödegoc. ");
INSERT INTO yuw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Tuna owi amna Kopotorochon Mananoha kombing tobing imongidangma yu wömai itonggong koing sogitdeang. Wohong owi amna Mananoha me imontangma yu wömai itonggong koing masogitning. Muno, Kopotorocho yuha ecego kombingga urago wontucmuno imangoc.” Jön yamuc gupgup forosicsic amna yu Yesuha yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Oro Farisi amna yu Yesuhon fatno ingoroc kombigung, Yesuho urop Jön anggirahac, yu owi amna koböcma sinom yamuc gung imuna torop worocho yu tanidang. ");
INSERT INTO yuw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Wohong Yesu inobut wömai amna yamuc magung imongidoc. Youp amnanihogon wömai togung. ");
INSERT INTO yuw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Oro Farisiho fatno ihoroc kombiuya Yesuho urop yuhon irotnohon foro kombingga Yudia sa imun fauna wönggon Galili gurocin onggoc. ");
INSERT INTO yuw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Oro Galili onggongon uyap wo wömai Samaria nanohon guroc bonipnodec idoc. ");
INSERT INTO yuw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Worocha tongga Yesu yu Samaria nanohon böcsa auhon ongkuboc. Böcsa worochon manoi Sikar. Sikar woi Jeköphon manano Yösep sa guroc imogocma woce ambehecgon idoc. ");
INSERT INTO yuw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Wocin wömai Jeköpho osuc yamucha gopma gidoc. Oro Yesu yu uyap worochon engmuna foc imuna ongga yamuc gopma tan wocin omoc idoc. Sep bongono wömai 12 kilok ihoroc idoc. ");
INSERT INTO yuw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Yesu yu omoc idina youp amnani nacno wöcwöcha taun woce ongbödeuya Yesu inogon idoc. Tuna Samaria owi au yu yamuc getgetha ehuna Yesuho yu inogoc, “Owi, yamuc get nampi.” ");
INSERT INTO yuw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ihoroc inuna Samaria owi yu mata wo kombiuna angit maidina mata ökenne iban imongga yogoc, “Tingting oro, gocu Yudia amna o nocu Samaria owi yo. Worocha goc ‘yamuc get nampi’ yarocma woi angit maec.” Yuda nano yu Samaria nano ot oröc oröc maididungmaha tongga owi worocho mata ökenne ihoroc iban imogoc. ");
INSERT INTO yuw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ihoroc inuna Yesuho inogoc, “Owi, Kopotorocho goc irot ogep gamoc gamocha kombihac mahong gocu wo makombiroc, o ihoroc-gon goc nochon foro makombiroc. Kombiantarocanu wömai gocho noc ‘yamuc nam’ ihoroc nanim. Naniyai nocho yamuc itonggongno-barac gamam.” ");
INSERT INTO yuw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yesuho ihoroc yuna owiho inogoc, “Amna moröma, gocu yamuc urenga muno o yamuc gopma ngoi ubarago sinom, worocha gocho yamuc itonggongnobaracma wo nahema sinom geda namontaroc? ");
INSERT INTO yuw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kombihi, öranoni Jeköp yu inobut yamuc gopma ngomai gidoc. Tongo inohu o mananihu o bulmakaunihu o bot sipsipnihu yu ambarac yamuc ngorocgon nongidung. O gocho wömai Jeköp anggiraharochu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ihoroc yuna Yesuho matano ökene iban imongga yogoc, “Owi amnaho yamuc ngoroc nauya ingguroho karupgon wönggon manman yongitac. ");
INSERT INTO yuw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Wohong nocho amna au yamuc imeya yu woroc nanggai wömai ingguro wönggon manman mayic. Muno sinom, yamuc worocho wömai amna irotnon daro sunda ongocgon tongga itonggong koing tun öngkung imangoc.” ");
INSERT INTO yuw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ihoroc yuna owiho Yesu inogoc, “Amna moröma, goc yamuc woroc namiya nawa. Namiyai wömai nocho yamuc getgetha ngocin wönggon mahit. Muno, ingguna wönggon yamucha ma-manman yic.” ");
INSERT INTO yuw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Oro ihoroc inuna Yesuho inogoc, “Goc ongmina oba inia eparun.” ");
INSERT INTO yuw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ihoroc inuna owiho inogoc, “Noc obna muno.” Yuna Yesuho inogoc, “Gocu boinno sinom yaroc, ‘noc obna muno yo’. ");
INSERT INTO yuw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Noc urop kombing-dehat, goc osuc amna 5ot itongidoroc. O amna önga gocot iditacma yui gochon oba muno.” ");
INSERT INTO yuw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yesu ihoroc yuna owiho mata wo kombingga soroc yongga inogoc, “Mayain, goc yong tuctuc amna au yo. ");
INSERT INTO yuw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Worocha nocho yapmu auha ganong ac towa, ombusakung noni yu sa urongo ngocin suran tongmuya Kopotorocha yong moröng imongidung mahong son Yuda nano sonu ihoroc matongidang. Muno, sonu yongidang, Kopotorocha yong moröng imocimoc wömai Yerusalem taun, wocegon tongitnahamon.’” ");
INSERT INTO yuw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ihoroc yuna Yesuho inogoc, “Owi, önga wömai sonu sa urongo ngocingon yong moröngidang, o Yuda nano yu Yerusalem wocegon tongidang mahong nocho boinno sinom gantiwa, oipmonu wömai owi amnaho böcsa danong woce woce Nandöng Kopotoroc yong moröng imong tongonahing. ");
INSERT INTO yuw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Son Samaria nano sonu yapmu makombing imingma worocha yong moröng imongidang. Wohong Yuda nano nonu wömai yapmu kombiamonma worocha yong moröngidamon. Guroc owi amnahon itonggong koing doun öngkung imocimoc amna wömai Kopotorocho Yuda nanohon bonipnodec tun öngkuangoc. ");
INSERT INTO yuw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Oro bongono wego au öngkup öngkupha tac, o önga urop öngkupac. Bongono wocin wömai owi amnaho irothon kiapdec kombingmuya Nandöng Kopotoroc Kunkun Yaruhon gesödec yong moröng imong-itnahing. Kiap ihorocnoha wömai Nandöng noni Kopotoroc yu toup kombihac. ");
INSERT INTO yuw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kopotoroc yui Yaru kiap. Worocha tongga owi amnaho yuhon mata boinno kombing tobingmuya Kunkun Yaruhon gesödec yong moröng imongitnung.” ");
INSERT INTO yuw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yesu ihoroc yuna owiho yogoc, “Noc urop kombihat, Duic yu engmuna manomano ambarachon foro ninong tangtang tuna tuctugo kombinahamon.” ");
INSERT INTO yuw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ihoroc yuna Yesuho inogoc, “Nocho goc mata gantatma, noc naka Duic woroc.” ");
INSERT INTO yuw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yesuho mata ihoroc yongbödeuna wohogon youp amnaniho engga agungmai, Yesu yu owi auot mata yongo idomoroc. Woroc angga soroc yogung mahong yu ‘goc yaö sogit sogita taroc?’ o ‘gocu yaöha owi ngorocot mata yaroc?’ ihoroc Yesu mainong ac togung,” ");
INSERT INTO yuw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Oro owi yu yamuc urengno woce tong singga imun fauna böc macnon ongmuna owi amna inogoc, ");
INSERT INTO yuw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Engga engga amna au aarut! Yu noc manomano ambarac osuc togotma nanongbödehac. Amna ngo yu Duichu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ihoroc inuna owi amna ambaracho böcsa imu fauna Yesuot ebung. ");
INSERT INTO yuw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Oro owi wo yu böcsa woce idina youp amnaho Yesu kiring imongga inogung, “Fandat fandat amna, muyu nacno au nahi.” ");
INSERT INTO yuw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ihoroc inuya yuho yogoc, “Nocu nacno foro au nongitat mahong sonu wo abe makombing.” ");
INSERT INTO yuw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ihoroc yuna youp amnaniho kombic kombic youp morö tongga yogung, “Amna auho nacno fengga imochu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ihoroc yuya Yesuho inogoc, “Nochon nacno boinno wömai woroc, noc muyu nanong muuna ebotma yuhon irot kombic kombicno tanto yuhon youpno ta bödehun, nacno boinnoi woroc. ");
INSERT INTO yuw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Oro sonu ingoroc yongidang: ‘Yarop 4 ihoroc bödeuna nacno tanac tanac bongono engoc.’ Worochoi oro nocho ingoroc kantiwa: Son ön yang findararut. Nacno urop orokongga arangarang yongga idang. ");
INSERT INTO yuw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tuna youp wabkaracho urop itonggong koingon boinno tanangga youpnohon wöngnacno fogiang. Tuya amna torop nacno mögungma orin amna torop nacno tanac tanac youp tongidangma yu ambaracho youpnohon boinno yangmuya borongdeang. ");
INSERT INTO yuw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Worochon mata owi amnaho ingoroc yongidang: ‘Amna auho nacno möngidang o torop auho wömai worochon boinno tananahing.’ ");
INSERT INTO yuw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Oro osuc amna torop auho yitno möng tonguya mit nocho son nacno tanac tanacha kanongmuaya onggung. Yitno möcmöc youp focfocbaracma wömai sonu matogung. Muno amna torop auho wömai togung. Tuya sontho yuhon youpnohon boinno tanaang,” Yesu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Oro owi wo yu Yesuha ingoroc yong taboc, ‘nocho osuc yaö manomano togotma wo ambarac yuho nindangbödehac.’ Yu ihoroc yong tabocmaha tongga Samaria nano böcsa wocema koböcmaho Yesuha kombing tobing imogung. ");
INSERT INTO yuw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tongo yu Yesuot engmuya ‘yu karupgon ongirocha’ yongo kiring imogung. Tuya Yesu yu sep youp toctoc yai böcsa woce idoc. ");
INSERT INTO yuw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Woce idina owi amna koböcmaho Yesuhon mata kombingga kombing tobing imogung. ");
INSERT INTO yuw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tongo yu owi wo inogung, “Nonu gocho fatno ninogorocmaha worochagon amna ngo makombing tobing imamon. Muno, non nonibut duc matano kombingga ingoroc kombiamon: Amna ngorocho yui boinno sinom guroc owi amna ambarac wontucmunodecma öcangyun muuya itonggong koing imocimoc amna,” ihoroc inogung. ");
INSERT INTO yuw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Oro sep youp toctoc yai bödeuna Yesu yu Samaria nano wo doun fauya Galili gurocin onggoc. ");
INSERT INTO yuw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Oro Yesu inobut wömai yogoc, ‘Kopotorochon yongtuctuc amna yu ino böcsanonu mano muno.’ ");
INSERT INTO yuw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ihoroc yogoc mahong yu inoin böcsanon ongkuuna Galili nanoho yu angga borongdedung. Yu wömai bongono moröma ‘Pasowa’ wocin Yerusalem öngmuya yauya Yesuho manomano toroc kiap inobarac sinom togoc. Worocha tongga yu Yesuha borongdetmuya gending imogung. ");
INSERT INTO yuw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Oro Yesu yu ongga wönggon Galili gurochon böcsa au mano Kana woce idoc. Wocin wömai yu osuc tuna yamucho wain gandoc. Oro kinghon ofisa au yu Kaperneam bucin idoc. Yuhon manano wömai obukoc tongga idoc. ");
INSERT INTO yuw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tuna ofisa yu kombigocmai, ‘Yesu yu urop Yudia sa imun fauna Galili gurocin epac.’ Yu mata wo kombingga Yesuot engmuna dönac inongga yogoc, “Manana urop omompha tac, worocha goc engmina nochon manana wo ti orokotun,” ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tuna Yesuho mata urago inongga yogoc, “Nocu toroc kiap inobarac orin momphon weran au matoyai wömai sonu makombing tobing namoning yo.” ");
INSERT INTO yuw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ihoroc inuna ofisaho kiring imongga wönggon ino-goc, “Moröma, goc karupgon epi, manana omicyit!” ");
INSERT INTO yuw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ihoroc yuna Yesuho inogoc, “Goc ongoi, manama mamic, orokongga idtong-ungoc.” Ihoroc yuna ofisaho mata wo kombing tobingga onggoc. ");
INSERT INTO yuw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yu abe uyapdec idina youp wabkaracni auho engga au feuna inogung, “manama wec itac.” ");
INSERT INTO yuw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ihoroc inuya ofisaho yu inong ac tongga yogoc, “Bongono yaödec sinom manana ogep ec?” Ihoroc yuna yuho yogung, “Oip 1 kilok dobocsisiha obukocnoho imun faac.” ");
INSERT INTO yuw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yuya fanoho kombigoc, ‘Mayain, oip bongono worocdecgon wömai Yesuho yogoc, manama orokongga idtongungoc,’ ihoroc kombingga yu ino orin owi amna yuho bucin ididungma yu ambarac Yesuha kombing tobing imogung. ");
INSERT INTO yuw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Oro Yesuho Yudia sa imun fauna Galili gurocin ebocan bongono wocin yu toroc kiap moröma wo togoc. Tongo yu urop bongo yai inoin gesö moröma Galili owi amna indauna agung. ");
INSERT INTO yuw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Oro oipmon Yesu yu Yuda nanohon yong moröng bongono au acacha Yerusalem taun woce ögoc. ");
INSERT INTO yuw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Oro Yerusalem wocin wömai yamuc öngköring au idoc. Yamuc öngköring wo wömai taunthon simbu mano ‘bot sipsiphon simbu’ woce ambehecgon idoc. Yamuc worochon mano Hibru matadec ‘Betesda’ ihoroc yongidung. Yamuc worochon terodec wömai sum sogit sogit baranda moröma 5 tobing fiuya idung. ");
INSERT INTO yuw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Baranda wocin wömai owi amna obukocni koböcmaho ididung. Woi amna dan komnimahu o orungo wöntucmunohu o amna kudatno omong fatfatyihu yu ambaracho ‘yamuc funfuro uuna ana’ yongo woce torengga ididung. ");
INSERT INTO yuw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bongono bongono wömai Morömahon sum yaru au yamuc ganang ohongga yamuc wot toroc tongidoc. Ihoroc tongo idinai wömai amna osuc yamucdec ohongidocma yuhon obukocno bödengidoc. ");
INSERT INTO yuw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Oro amna au yu obukoc tongga idinagon biruc 38 ihoroc idoc. Yu ihorocgon woce torengga idoc. ");
INSERT INTO yuw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yu bakat woce idina Yesuho yu auna amna auho yuha fat tongga Yesu inogung, “Amna ngoi obukoc sa ubarago tongga iditac.” Ihoroc inuya Yesuho amna obukocni wo inogoc, “Goc godibaho orokotun yongga kombiharoc?” ");
INSERT INTO yuw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ihoroc yuna amna mata ökene iban imongga yogoc, “Amna moröma, Morömahon sum yaruho yamuc öngköringdec ohuna yamuc funfuro öngitacan bongono wocin amna auho noc tongfat nengo mabacneng tohongitac. Woroc tuya ta matuna iditat.” ");
INSERT INTO yuw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ihoroc yuna Yesuho inogoc, “Goc idongga abam yoroca sogitmina ongoi.” ");
INSERT INTO yuw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ihoroc inuna wohogon obukocho amna wo imun fauna yu abamo sogitmuna uyap onggoc.Oro yapmu wo wömai Sabat bongonodec öngkuboc. ");
INSERT INTO yuw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Worocha tongga Yuda nanoho amna orokogocma angga inogung, “Öngai Sabat sep bongono yo. Goc abam yoroca sogida uyap tong-irocha, gendic noni worocha ‘muno’ yac.” ");
INSERT INTO yuw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ihoroc inuya amna orokogocma mata ingoroc iban imogoc, “Amna wo noc tun orokotatma yuho nanoc, ‘Abam yoroca sogitmina itongoi.’” ");
INSERT INTO yuw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ihoroc yuna yu inong ac tongga inogung, “Amna ‘abam yoroca sogitmina itongoi ganocma woi numa?’” ");
INSERT INTO yuw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ihoroc inogung mahong Yesu yu urop owi amna bonipnodec gorong onggocmaha tongga amna orokogocmaho bumbum yongga amna numaho tun orokogocma makombigoc. ");
INSERT INTO yuw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tuna mit Yesu yu öret socsoc böchon gombo ganang öngmuna amna wo wönggon aun feuna inogoc, “Kombiharoc, önga wömai goc orokotaroc. Worocha goc wontucmuno ambarac doi fauya wönggon tirocha. Mepmo morömaho wönggon gocdec öngkung gamicyit.” ");
INSERT INTO yuw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ihoroc inuna amna worocho ongmuna Yuda amna moröma inong buroc tongo yogoc, “Amna noc tun orokotma woi woroc, Yesu,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Oro Yesu yu Sabat sep bongonodec owi amna doun orokogungmaha tongga Yuda nanohon amna dugo Yesu ayam tong imogung. ");
INSERT INTO yuw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tuna Yesuho yu inogoc, “Nandöngna yu bongono muno youpno tongitac. Worocha nocu ihorocgon youpna bongono muno tongitat.” ");
INSERT INTO yuw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Oro Yesu ihoroc yogocmaha tongga Yuda nanoho toup sinom ec imuna yu wot omom toctocha youp orongi togung. Foro wömai ingoroc: Yesu yu Sabathon gendic gumandoc o ihorocgon yu yogoc, Kopotoroc woi yuhon Nandöng. Yu mata woroc yogocmaha tongga yu ino Kopotoroc simbang öngkuboc. ");
INSERT INTO yuw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Oro Yesu yu Yuda nanohon mata ökene ingoroc iban imogoc, “Nocho boinno sinom kantiwa, Nandöngho tongitacma worochon torocgon Mananoho tontac. Worocha tongga Kopotorochon Manano yu inoin gesödec yapmu au matic. Muno, yui auna fanoho tongitacma worochon torocgon tanitac. ");
INSERT INTO yuw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nandöng yu Mananoha toup kombihac. Worocha wömai yui manomano ambarac ino tongitacma wo Mananoha tong indangbödengitac. Nocho önga owi amna dongya orokugungma woi yapmu moröma muno, mit wömai Nandöngho Manano toroc kiap moröma inobarac sinom indauna sonu wo yangga soroc yonahing. ");
INSERT INTO yuw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nandöngnaho owi amna omomyima dongyun wekuya itonggong wönggon imongitac. Oro worochon torocgon wömai Manano yu ihorocgon owi amna omomyimahon itonggong wönggon imocimochon gesöno idimpac. ");
INSERT INTO yuw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“O ihorocgon Nandöngna yu amna au mata youpdec matohong yuic. Muno, mata yun bödec bödechon youp ambarac wömai yu ‘Mananaho toun’ yongo kombingdegoc. ");
INSERT INTO yuw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Worocha tongga owi amna ambaracho Nandöng anggendingga yuha yong moröng imongidangma yu wömai Mananoha ihorocgon yong moröng imonahing. Nandöng yu Manano inong muuna eboc. Worocha tongga amna au yu Mananoha yong moröng maimoningma yu wömai Nandönga ihorocgon mayong moröng imoning. ");
INSERT INTO yuw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nocho boinno sinom kantiwa, owi amnaho nochon mata sogit akep tongmuya Nandöngho noc siuna ebotno yongo yu kombing tobing imontangma yu wömai itonggong koingbarac idang. Yu wömai mata youpdec koing songga itnahing. Yu urop omomphon öngkurip ong katingga itonggongon fat itdeang. ");
INSERT INTO yuw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nocho boinno sinom kantiwa, bongono auho ehangoc o urop önga epac, wocin wömai owi amna omomyimaho Kopotorochon Mananohon mata kombinahing. Tongo owi amna yuhon mata sogit akep tontangma yu wömai itonggongno sogitnahing. ");
INSERT INTO yuw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Wömai yaha Nandöng yui itonggong koing worochon Morömo itac. Tongo yu Manano kombing imuna yui ihorocgon itonggong koingbarac itac. ");
INSERT INTO yuw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","O ihorocgon yu Amnahon Manano itacmaha tongga yu guroc amnahon matano yun bödec bödechon gesö Nandöngon oburodecma sogidoc. ");
INSERT INTO yuw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Sonu mata worocha nanga fatfat toninga. Bongono au ehangoc, wocin wömai Amnahon Mananoho owi amna kumkumon idangma yu inong yuna kombingga ");
INSERT INTO yuw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kumkumon imu faangoc. Owi amna toroc kiap ogepma tongidungma yu wömai idongmuya itonggong koing sogitnahing. O owi amna toroc kiap wontucmuno tongidungma yu wömai idonguya Mananoho matano yun bödeuna möpmo inuna gorong ongonahing. ");
INSERT INTO yuw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nocu nakain gesöhu o nakain kombic kombicdechu yapmu au matit. Muno, nocu Nandöngnahon irot kombic kombicgon sindanda owi amna yangsoworengitat. Worocha tongga nocho owi amna yangsoworengitatma woi nongnongogon. Yaha, nocu nakain irot kombic kombicna masindanitat. Muno, nocu ‘Nandöngon irot koing soun’ yongo owi amna yangsoworengitat. Ino worocho nanong muuna ebot.” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yesuho wönggon mata sakaun fiuna ingoroc yogoc, “Noc nakabut nakain foroha yong tangtang yontatanu wömai nochon matahu o youpnahu wo makoingsun. ");
INSERT INTO yuw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Worochoi oro noc kombihat, amna au yu ihorocgon nocha yong tuctuc yuna nochon matahu o youpnahu wo tong koing tac. Yuhon mata woi boinno. ");
INSERT INTO yuw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","34","“Oro nocho ingoroc kombihat, guroc amnaho nocha yong tuctuc yuyai wömai nochon youp makoingsic. Wohong sontho nochon foro tuctugo kombic kombicha Jönot onggung. Tuna Jöntho nocha yong tuctuc mata kanogoc. Oro nocho ‘son yuhon mata kombing tobingga idit koing sogiarut’ yongo toup kombihat. Worocha tongga son muyu Jöntho nocha yong tuctuc yogocma wo kombing tobiarut. Yui guroc amnagon mahong yuhon mata woi boinnogon. ");
INSERT INTO yuw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jön yu gop simbang amna yaguno möng imongidoc. Tuna sonu bongono docutnogon yuha borongdedung. ");
INSERT INTO yuw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Wohong yapmu au Jön anggira-hacma worocho wömai nochon foroha yong tuctuc yuna koing sac. Woi nocho Nandöngon madec youp tongitatma youp worocho wömai tuctugo sinom kindaang, Nandöng Kopotoroc yu inobut noc nanong muuna ebot. ");
INSERT INTO yuw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“O Nandöngna noc nanong muuna ebotma yu inobut wömai nocha yong tuctuc yogoc. Wohong sonu yuhon duc mata makombigung, o yuhon yangamo magung. ");
INSERT INTO yuw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","O ihorocgon yuhon mataho irot sonidec maec. Yuhon mata irot sonin idinai wömai sonu amna yu inong muuna ebocma yuha kombing tobing imup. ");
INSERT INTO yuw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Oro, sonu ingoroc kombingidang: Mata Kopotorochon bapiyadec itacma worocho wömai itonggong koing soni tun öngkung kamontac. Worocha tongga sonu embat embat youp moröma sinom tongga Kopotorochon matano soworec soworecha toup kombiang. Worochoi oro son soni wöhö, Kopotorochon bapiyaho wömai nakaha yong tuctuc yac. ");
INSERT INTO yuw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wohong sonu nocot engmuya itonggong koing sogit sogitha makombiing. ");
INSERT INTO yuw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","“Kombiarut, nocu sonthon forosoni urop kombingbödehat. Irotsoni wömai Kopotorocha ma borongdeditac, sonu yuha makombingidang. Worocha tongga nocho ‘guroc amnaho ma moröma namarut’ yongo makombit. ");
INSERT INTO yuw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","“Nandöngnaho noc nanong muuna epat mahong sonu noc me namang. Wohong amna au yu inoin madec ehunai wömai sonu karupgon yu irot soni imonahing. ");
INSERT INTO yuw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sonu amna nucsoniho yangamin ma moröma sogit sogithagon kombiang. Wohong Kopotorocho yangamin ma morö sogit sogitha wömai sonu makombing. Kopotoroc yu tungugon Moröm soni itac. Tuna sontho yuho yangamin ma morö sogit sogitha kombinggahai wömai sonu noc kombing tobing namup. ");
INSERT INTO yuw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Nocho mata youpdec Nandöngnaho yangamin son mata mafiring karit. Muno, amna tunguhogon wömai son mataha firing karangoc, woi amna moröma soni Möse. Sonu kombingidang, yu bongbong noni orin tongfat necnec noni sinom. ");
INSERT INTO yuw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Wohong sonu yuhon mata kombic kombicha makombingidang. Möse yu wömai nocha yong tuctuc mata irim togoc. Tuna sonu mata wo kombing tobinggahai wömai sonu nochon mata ihorocgon kombing tobiup. ");
INSERT INTO yuw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Wohong sonu Mösehon mata makombing tobiantanganu wömai sonu nochon mata tingtinga kombing tobiup, woi maec.” Yesuho numa inoin youp tong koing tongitacmaha mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Oro oipmon Yesu yu Galili yamuc öngköring gino ökene onggoc. Galili yamuc worochon mano au wömai ‘Taiberias yamuc’ ihoroc yongidung. ");
INSERT INTO yuw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yesu woce onguna owi amna koböcma sinompho yu angmuya tan tonggung. Yu wömai osuc Yesuho toroc kiap gesöbarac tongo owi amna obukocnima dongyun orokogungma wo agungmaha yu tan tonggung. ");
INSERT INTO yuw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tuya Yesuot youp amnaniot yu sa urongo auhon öngga wocin idung. ");
INSERT INTO yuw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Oro bongono wocin wömai Yuda nanohon bongono moröma ‘Pasowa’ worocho urop engfom togoc. ");
INSERT INTO yuw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Oro Yesu yu sa urongo woce itmuna foringga yagocmai owi amna koböcma sinompho yuot ebung. Ihoroc tuya Yesuho Filip inong ac tongga yogoc, “Oro nonu nacno sowarango nahema wöngga owi amna ngo silip imonaya naup?” ");
INSERT INTO yuw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesuho mata wo yogocma woi Filiphon irot kombic kombic sogit sogitha inogoc. Inoi wömai urop owi amna nacno imocimochon uyap kombingdegoc. ");
INSERT INTO yuw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tuna Filipho mata ökene iban imongga yogoc, “Uyap au maec, owi amna koböcma sinom idangmaha tongga nonu nacno sowarango 200 Kinahon toroc wönaya yu woi nacno angit manaup.” ");
INSERT INTO yuw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Filip yu ihoroc yuna Yesuhon youp amna au mano Andru woi Saimon Pitahon orugo, yu Yesu inogoc, ");
INSERT INTO yuw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Wabkarac au ngocin itac. Yuot nacno sowarango 5 orin söng yai idang mahong nacno worocho owi amna koböcma tingtingno sinom tongfat yeun?” ");
INSERT INTO yuw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ihoroc inuna Yesuho yogoc, “Son owi amna inuya omoc idarut.” Amna wocin omoc idungma worochon nambanoi 5,000 worochon toroc idung. Yu ambarac binsingdec woce omoc idung. ");
INSERT INTO yuw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Omoc idiya Yesuho nacno sowarango fogitmuna Kopotoroc ecec inongga uboto owi amna silip tong imogoc. O söng yai woi ihorocgon fogida toroc worocgon tuna owi amnaho inoin ibibohon toroc fogidung. ");
INSERT INTO yuw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Oro owi amna nacno nongga modibo foc tongga idiya Yesuho youp amnani inogoc, “Sonu nacno nongdocno feng suran tarut. Nacno au obukoningyit.” ");
INSERT INTO yuw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ihoroc inuna yuho nacno sowarango 5 obmukusuc worochon nongdocno fogida dumbu 12 ihoroc oheuya foc togung. ");
INSERT INTO yuw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Oro Yesu yu momphon weran moröma wo tuna owi amnaho angga yogung, “Boinno sinom, amna ngo yui yong tuctuc amna Kopotorocho osuc gurocdec siuna ohoc ohocha yogocma woroc.” ");
INSERT INTO yuw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ihoroc yuya Yesuho surarohon irot kombic kombic angbödengga kombigoc, “‘Yuhon kingno itiwa’ yongo engga noc sogit akep toctocha kombiang.” Ihoroc kombingmuna yu sa wo imun fauna ino tunguho-gon wönggon sa urongodec öngga öp idoc. ");
INSERT INTO yuw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Oro urop dobocsiuna Yesuhon youp amnani yu yamuc öngköring tan ohongga ");
INSERT INTO yuw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","girang audec bangyu uuya Kaperneam onggonga yamuc kondong tongga onggung. Yamuc bonip idiya urop kumbong diuna Yesu yuot maidoc. ");
INSERT INTO yuw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tuna sum orongi au busuna yamuc funfuro moröma ögoc. ");
INSERT INTO yuw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tuna youp amnaniho girang wodic wodic youp morö tong tonguya 5hu o 6 kilomita worochon toroc idoc. Ihoroc tongga yu agungmai Yesu yu yamuc öngköringdec sansantho engmuna urop ino ot ambehecgon idoc. Woroc angmuya toup sinom botogung. ");
INSERT INTO yuw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Botuya Yesuho inogoc, “Son botoninga! Naka epat yo.” ");
INSERT INTO yuw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ihoroc inuna youp amnaniho yu sogida girang ganang tong yucyucha togung mahong yu urop sa onggonga kombigungan woce ongkubung. ");
INSERT INTO yuw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Oro kumbongbödeuna sa isong urang möngidina owi amna yamuc öngköring gino ökene idungma yu agungmai, girang tungu oipno woce idocan wo urop onggoc mahong Yesu yu girang worocdec mabangmun öc. Muno, youp amnanihogon wömai girang worocdec bangyu uuya onging. Yu woroc angmuya ‘Yesu nahe itac’ yongo kombic kombic youp morö togung. ");
INSERT INTO yuw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ihoroc tuya Taiberias nanohon girang au yu sa suraroho nacno sowarango nagungan woce engku-bung. ");
INSERT INTO yuw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Engkuuya owi amnaho yagungmai Yesuhu o youp amnanihu yu woce maidung. Worocha tongga yu ambarac girang worocdec bangyu öngga ‘Yesu ana fehun’ yongo Kaperneam onggung. ");
INSERT INTO yuw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Oro owi amna yu ongga yamuc öngköring gino ökene Yesu au fedoc. Au feuna ingoroc inogung, “Fandat fandat amna gocu ngocin bongono yaödec eboroc?” ");
INSERT INTO yuw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ihoroc inuya Yesuho ingoroc inogoc, “Nocho boinno sinom kantiwa, sontho nocot ehingma woi nocho momphon toroc kiap au toya agungmaha muno. Sontho nocot ehingma woi noc nacno sowarango kamoya nauya modibsoni foc togocmaha worochagon tongga sontho noc nau fec. ");
INSERT INTO yuw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kombiarut, godibhon nacno karupgon moin tongitac. Worocha sonu godibhon nacnohagon kombingbanac toninga. Muno, son muyu nacno boinno itonggongnobaracma worochong sogit sogitha kombingbanac tarut. Nacno wo wömai Amnahon Manano yuhogon kamangoc. Nandöng Kopotoroc yu Manano nacno wo kamoc kamochon gesö imogoc.” ");
INSERT INTO yuw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yesuho ihoroc yuna owi amnaho inogung, “Nonu tingting tong-manaina Kopotorocho yangamin nongnongo öngkupnam?” ");
INSERT INTO yuw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ihoroc yuya Yesuho inogoc, “Kopotorocho ‘son yapmu tungugon tarut’ yongo kombihac, woi son muyu amna yu inong muuna ebocma yuha kombing tobing imarut.” ");
INSERT INTO yuw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ihoroc yuna owi amnaho wönggon inong ac tongga yogung, “Gocu momphon toroc kiap tingtingno tia nontho woroc angmanaina gochon mataha kombing tobiantamon. ");
INSERT INTO yuw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ombu-sakungnoni yu osuc sa amna maiyan nacno mano ‘mana’ woroc nong tonggung. Worochon fatno wömai Kopotorochon bapiyadec ingoroc itac: ‘Yui momphon nacno sowarango suraro imuna nagung.’ “Worochai oro, gocu toroc kiap ihorocnogon tiai angga kombing tobing gamonam.” ");
INSERT INTO yuw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ihoroc yuya Yesuho inogoc, “Nocho boinno sinom noc kantiwa, Möseho momphon nacno boinno makamogoc. Muno, Nandöngna yuhogon wömai momphon nacno boinno kamontac. ");
INSERT INTO yuw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Amna mom imun fauna ohogocma yu wömai guroc owi amna itonggong koing tun öngkung imocimocha ohogoc. O yu inoho wömai Kopotorochon nacno boinno.” ");
INSERT INTO yuw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yesu ihoroc yuna owi amnaho inogung, “Amna moröma, goc muyu nacno wo bongono muno nimocgon tongidiruc.” ");
INSERT INTO yuw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ihoroc yuya Yesuho inogoc, “Nacno itonggongnobarac wo woi noc naka. Owi amnaho nocot ehantangma yu wönggon nacnoha maworec imoning. O owi amna noc kombing tobing namontangma yu wömai yamuc nacnacha wönggon mamning. ");
INSERT INTO yuw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Wohong nocho urop kanogot, sonu noc nangidang mahong kombing tobing namoc namocha wömai makombiing. ");
INSERT INTO yuw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nandöngna yu owi amnani noc namongitac. Tuna owi amna wo yu ambarac nocot ehuya nocho yu matarit, muno yu nocot idtongonahing. ");
INSERT INTO yuw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nocho ‘nakain irot kombic kombicna sindariwa’ yongo mom ima fauna maohogot. Muno sinom, noc ‘Nandöngna nanong muuna ebotma yuhon irotgon koing soun’ yongo ebot. ");
INSERT INTO yuw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Oro Nandöngnaho ingoroc kombingga nanong muuna ebot: Nocho owi amnani yu namogocma yudecma tungu au maima faic. Muno sinom, bongono bödec bödecane wömai nocho yu kumkumonma dongya wekonahing. ");
INSERT INTO yuw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nandöngnahon irot kombic kombic moröma wömai ingoroc: Owi amna ambarac Manano angmuya yuha kombing tobing imongidangma yu wömai itonggong koing sogitnahing. Tuya nocho yu bongono bödeangocan dongya wekonahing.” ");
INSERT INTO yuw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Oro Yuda nano yu Yesuhon mata ngo “nacno momdec ebocma woi naka” woroc kombingga irotno ec imuna ");
INSERT INTO yuw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","mata metec ingoroc yogung, “Amna ngomai Yesu, yu Yösephon manano. Nonu macnin faninu kombing imamon. Worocha yu tingtinga yac, ‘noc mom ima fauna ohogot’ yo?” ");
INSERT INTO yuw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ihoroc yuya Yesuho inogoc, “Sonu bonipsonidec mata metec koböc koböc yoninga. ");
INSERT INTO yuw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Amna au yu inoin irot kombic kombicnoha nocot angit maehic. Muno, Nandöngnaho nanong muuna ebotma yu inobut amnahon irotno tun fadauna yangata nocot ehangoc. Tuna nocho yu bongono madango wocin kumkumonma ta wekangoc. ");
INSERT INTO yuw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Worochon mata woi yong tuctuc amnahon bapiyadec ingoroc itac: ‘Kopotorocho owi amna ambarac fandat inangoc.’ Fandat inuna owi amna yuhon mata sumbentangma yu wömai nocot epnahing. ");
INSERT INTO yuw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Amna auho osuc Nandöngna magoc. Muno, amna Kopotorocot itmuna ebocma yu worochogon wömai Nandöng agoc. ");
INSERT INTO yuw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","48","Nocho boinno sinom kantiwa: Nacno itonggongnobarac woi noc naka. Worocha tongga owi amna noc kombing tobing namontangma yu wömai itonggong koingbarac itdeang. ");
INSERT INTO yuw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ombusakung soni yui osuc sa amna maiyan nacno momdecma ohogocma mano ‘mana’ wo nong tonggung mahong yui omongfat bödegung. ");
INSERT INTO yuw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Oro önga wömai nacno boinnoho mom imun fauna ohogoc. Tuna owi amna wo nongga omoc koing mau feic. ");
INSERT INTO yuw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nacno boinno woi noc naka. Nocu momdec Kopotorocot itmaina ohogot. Amna au yu nacno ngoroc naantacma yu iditno idtongungoc. Nacno boinno woi nakain goumna. Nocho ‘guroc amnaho itonggong koing sogitnung’ yongo godip föbna yuha bogingga omengot.” ");
INSERT INTO yuw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yesuho ihoroc yongbödeuna Yuda nano amna morömaho kombingga inohogon mataho emoc tong tongga yogung, “Tingtinga sinom amna ngorocho inoin goumo non nimuna nacnacha yac?” ");
INSERT INTO yuw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ihoroc yuya Yesuho inogoc, “Nocho boinno sinom kantiwa. Son Amnahon Mananohon goumo orin nogotno wo mananinganu wömai sonu itonggongsonibarac maitning. ");
INSERT INTO yuw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wohong owi amna nochon goumna orin nogotna naantangma yu woi itonggong koingbarac idiya nocho yu bongono madangodec dongya wekuya idongonahing. ");
INSERT INTO yuw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kombiarut, nacno boinno woi nochon goumna. O yamuc boinno woi nochon nogotna, ");
INSERT INTO yuw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","owi amna nochon goumna orin nogotna naan-tangma yu wömai nocdec ding fingga entang, o nocho yuot edengot. ");
INSERT INTO yuw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nochon Nandöngna yui itonggongkoing worochon Morömo, yu noc nanong muuna engmaina yuhon gesödec itongitat. Oro worochon torocgon wömai owi amna nochon goumna naantangma yu wömai nochon gesödec itongitnahing. ");
INSERT INTO yuw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","“Nacno boinno mom imun fauna ohogocma woi woroc, nakain goumna nogotna. Ombusakung noni yu wömai nacno mano ‘manna’ momdecma ohogocma woroc nagung mahong omong fadidung. Wohong owi amna nacno boinno ngo naantangma yu wömai itonggong koing sogitdeang.” ");
INSERT INTO yuw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Oro Yesu yu Kaperneam taun Yuda nanohon fatmata yocyoc bucin itmuna mata ihoroc suraro fandat inogoc. ");
INSERT INTO yuw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Oro owi amna Yesu tan tonggungma koböcma yu Yesuho inoin goumo nocnochon mata yogocma wo kombiuya angit maidina mata metec yongga yogung, “Mata ngorocho woi angit maec, non mata ihorocnoha makombinin.” ");
INSERT INTO yuw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ihoroc yuya Yesuho yuhon irot kombingbödengga ingoroc inogoc, “Nochon mata ngorocho irotsoni doun obukogunghu? ");
INSERT INTO yuw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kombiarut mit wömai sonu anahingmai Amnahon Manano yu osuc idocan woce wönggon öangoc. Ihoroc tuna angga tingting sinom kombinahing? ");
INSERT INTO yuw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Oro, itonggong koing wömai Kunkun Yaru yuhogon nimongitac. Guroc amna yu inoin gesödec itonggong koing masogitning. Nochon mata woi Kunkun Yaruhon toroc worocha tongga nochon mata worocho itonggong koing tun öngkung kamun. ");
INSERT INTO yuw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Wohong amna au son bonipsonidecma yu makombing tobing namang.” Yesuho mata ihoroc yogoc. Yu wömai owi amna makombing tobing imingma yu osucgon kombingdegoc. O ihorocgon numaho sinom yu ayamiho oburodec siangocma wo urop osucgon kombingdegoc. ");
INSERT INTO yuw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tongo Yesu mata sakaun fiuna yogoc, “Foro worocha tongga nocho urop kanongdegot, Nandöngnaho owi amna inong wodiunai wömai worocho ogep nocot ehantang mahong Nandöngnaho ihoroc matuna wömai yu nocot ebephon gesö maitiming.” ");
INSERT INTO yuw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Oro Yesuho mata woroc yongbödeuna owi amna osuc Yesu tan tonggungma yu Yesu me imongga imu fauna yuot wönggon maitonggung. ");
INSERT INTO yuw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ihoroc tuya Yesuho youp amnani 12 inong yac tongo inogoc, “O sonidec tingting, son ihorocgon noc imu fauna onggonga kombianghu?” ");
INSERT INTO yuw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","69","Ihoroc yuna Saimon Pitaho mata ökene ingoroc iban imongga yogoc, “Moröma, non boinno sinom kombiamon, Kopotorochon Kunkun Amna woi goc gaka. Gochon mata woi itonggong koing nimoc nimochon gesöbarac. Worocha tongga nonu goc imana fauna numaot ongonam? Amna au maec, muno sinom non gocot itongitnahamon.” ");
INSERT INTO yuw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Pitaho ihoroc yuna Yesuho yogoc, “Tingting oro, noc nakabut son nocot itonggonga kangsoworegot mahong sonthon toropdecma amna tungu yui dogu kopothon youp wabkarac.” ");
INSERT INTO yuw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Yesu amna worocha yogocma woi Yudasha yogoc. Yudas woi Saimon Iskariot yuhon manano. Yu woi youp amnani 12 yuot itongidoc mahong oipmonu wömai yu Yesu ayamihon oburodec sigoc.) ");
INSERT INTO yuw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Oro Yuda nanohon amna dugo yu Yesu wot omom toctocha yong torop sigung. Worocha tongga Yesu yu Yudia gurocin manggoc. Muno, yui Galili gurocingon itonggoc. ");
INSERT INTO yuw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Woce itongga idina urop Yuda nanohon bongono morö eng teboc. Bongono wocin wömai Yuda nanoho Kopotoroc yu sa amna maiyan woce ogepgon yangtoregocma worocha kombingga tac böc tobingga wocin ididung. ");
INSERT INTO yuw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Oro bongono worocho eng teuna Yesuhon orugiho engmuya Yesu inogung, “Goc muyu sa ngo imi fauna Yudia sadec ongoi. Ongiya owi amna gocha kombiangma yu gochon youp foro au woroc aup. ");
INSERT INTO yuw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Amna au yu suraro ambarachon amna iditha kombinggai wömai yu youpno owi amna ambaracho yangamin eran tuna anung, öpgon muno. Worocha goc muyu eran idiya owi amna sa guroc danong yu gochon toroc kiap inobaracma wo yanahing.” ");
INSERT INTO yuw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yesuhon orugi yu wömai Yesu ihoroc makombing tobing imogung. Worocha yu mata ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ihoroc yuya Yesuho mata ingoroc iban imogoc, “Nandöngnaho abe ‘woce ongoi’ mananogoc mahong sonu wömai soniin irot tanto bongono muno woce woce ongup. ");
INSERT INTO yuw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kombiang, guroc owi amna yu son ayam matong kamoning. Worochoi nocu wömai toroc wöntuc-muno tongidangma wo eran tong indaaya ec imuya ayam tong namongidang. ");
INSERT INTO yuw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Son bongono moröma acacha Yerusalem ongurit. Nochon youp toctochon bongono abe maecmaha nocu woce mangit.” ");
INSERT INTO yuw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu mata ihoroc inongga Galili torengga idoc. ");
INSERT INTO yuw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Worochoi oro orugiho ongdeng idiya Yesu yu ‘owi amnaho naningyit’ yongo ihorocgon öpgon bongono moröma acacha Yerusalem onggoc. ");
INSERT INTO yuw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tuna Yuda nanohon amna dugo yu ‘Yesu sogitna’ yongo yuha gön tongga idung. Tongo yu owi amna inongo yac tongga inogung, “Amna wo nahe itac yo?” ");
INSERT INTO yuw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ihoroc yuya owi amna komongno yui Yesuha mata koböc yong tonggung. Auho wömai yogung ‘yui amna ogepma’, o auho yogung ‘muno, yu suraro inong yungitac’. ");
INSERT INTO yuw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yu ihoroc yong tonggung mahong suraroho amna dugoha botogungmaha yu eran mayogung, muno öpgon yogung. ");
INSERT INTO yuw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Oro bongono moröma worochon sep youp toctoc au bödeuna Yesu yu öret socsoc böchon gombo ganang öngmuna foro singga owi amna fatmata fandat inogoc. ");
INSERT INTO yuw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ihoroc tuna Yuda nanoho matano kombingga soroc yongga yogung, “Mayain, amna ngomai osuc kombic kombic bucin bongono docutnogon ögoc. Yu kombic kombic ogepma sinom nahema sogidoc?” ");
INSERT INTO yuw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ihoroc yuya Yesuho mata ökene ingoroc iban imogoc, “Nocu mata fandat kanongitatma woi nakain kombic kombicha muno. Amna noc nanong muuna ebotma yuhon kombic kombicgon wömai nocho sindanda fandat kanongitat. ");
INSERT INTO yuw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Amna au yu ‘Kopotorochon irot koing soun’ yongo kombihacma yu wömai tuctugo kombiantac, nocho Kopotorochon mata yong fandaditatha woha noc nakain kombic kombicnagon tanitat. ");
INSERT INTO yuw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","“Amna au yu inoin kombic kombicdecma mata yontacma yu wömai inoin mano töctöcha yontac. Wohong amna au yu amna inongmuuna ebocma yuhon irot koing soun yongo kombihacma yu woi amna nongnongo. Yudec wömai imanang au maec. ");
INSERT INTO yuw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kombiarut, Möse yu wömai nongoru mata kamogoc mahong son ambaracho nongoruhon toroc maitongidang. Worocha sonu foro yaöha noc not omompha yong torop siang?” ");
INSERT INTO yuw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yesuho ihoroc inuna suraroho mamboda yogung, “Dogu boyömo au gocdec idina bumbum yarochu? Amna au goc got omompha maying.” ");
INSERT INTO yuw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ihoroc yuya Yesuho inogoc, “Nocho Sabat bongonodec amna tungu ta orokuna irot soni obukogung. ");
INSERT INTO yuw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kombiarut, son ihorocgon Sabat bongonodec managumbochon godibo mangidang. Ombusakung soni yu osucgon managumbochon godibo mangidung. Tuya Möse yu godip macmachon nongoru kamuna son Sabat bongo-nodechu o bongono munohu managumbochon godibo mangidang. ");
INSERT INTO yuw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Oro sonu Sabat bongonodec managumbochon godibo mauya Mösehon nongoru mayembodidang. Worocha tongga nocho ihorocgon Sabat bongonodec amnahon godip föp ambarac ta orokun. Sonu worocha nocha ececgo kombininga. ");
INSERT INTO yuw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Son nochon toroc kiap danthogon angsoworeninga, son muyu nochon toroc kiap irotho kiapmodec nongnongogon angsoworearut.” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Oro Yesuho mata ihoroc yongbödeuna Yerusalem owi amna au yu Yesuha inohogon inun ganun tongga yogung, “Tingting sinom? Amna dugo noniho amna wot omom toctocha yogungma woi amna worochu? ");
INSERT INTO yuw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yu suraroho yangamin eran idongga fatmata fandat inongitac mahong amna dugo yu ‘öpgon itun’ yongo maying. Amna dugo noni yu amna worocha kombiang yu Duic, ihorochu nuhun. ");
INSERT INTO yuw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Muno woi, Duic ino boinno ehunai wömai amna au yuhon böcsano makombining mahong nonu yuhon böcno sanoi tuctugo kombiamon.” ");
INSERT INTO yuw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yerusalem owi amna yu mata mata ihoroc yongga idiya Yesu yu öret socsoc bucin itmuna ingoroc mambodoc: “Boinno, sonu nakahu o nochon böcna sana wömai kombiang mahong amna noc nanong muuna ebotma yu wömai makombing iming. Yuhon toroc kiapmo woi boinno orin nongnongogon. ");
INSERT INTO yuw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Sonu yu makombing iming mahong nocu yu kombing impat. Nocho yuot edeya yuho noc nanong muuna ebot.” ");
INSERT INTO yuw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yesu mata woroc yongbödeuna owi amnaho kombingga ec imogung. Tongo yu Yesu sogit akep toctocha kombigung mahong Yesuhon bongono abe mafom togocmaha amnaho botongga sogit akep matogung. ");
INSERT INTO yuw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wohong owi amna torop au yu wömai Yesu kombing tobing imongo yogung, “Duicho enggai wömai yu toroc kiap amna ngorocho tongitacma wo yanggiraangochu? Muno, amna ngorocho toroc kiap inobarac sinom tongitac, yu ino woi Duic.” ");
INSERT INTO yuw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Oro suraro au yu ihoroc yongga idiya Farisiho mata woroc kombingga ‘sogit akep tona’ yongo öret socsoc böchon amna dugo inongburoc togung. Tuya yu tawa amna inong muuya yu Yesu sogito akep toctocha onggung. ");
INSERT INTO yuw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ihoroc tongga idiya Yesu yu abe suraroho yangamin itmuna yong fandat inongga yogoc, “Nocu bongono docutnogon sonot itmaina son dongya fauya Nandöngot ongöngot. Yu nanong muuna ebot. ");
INSERT INTO yuw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Sonu nocha yabinahing mahong mananing. O sa nocho engotan woce sonu angit mangoning.” ");
INSERT INTO yuw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yesuho ihoroc yuna Yuda nanoho kombiu tuctuc mayuna inohogon inun ganun tongo yogung, “Yu sa nahenne onggonga yac yo, nontho yu woce maanin? Yu sa korungon ongga Grik nano yong fandat inoc inocha yachu nuhun? ");
INSERT INTO yuw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","O tingtinga yu yogoc, ‘Sonu nocha yabinahing mahong mananing. O sa nocho engotan woce sonu angit mangoning’ mata ngorochon foro wömai nonu angit makombimon.” ");
INSERT INTO yuw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Oro bongono moröma ngorochon bödec bödecnodec wömai sep youp toctoc bongono madango moröma sinom ididoc. Sep bongono wocin Yesuho idongga ecnang ingoroc yogoc, “Amna au yu yamucha kombinggai wömai yu nocot engmuna yamuc nahun. ");
INSERT INTO yuw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Owi amna noc kombing tobing namonahingma worocho irotnon wömai yamuc itonggongnobarac sunda moröma fada ongontac. Kopotorochon bapiyadec worochon yong tuctuc mata irim toctocyi itac. Tuna mata worocho boinno engoc.” ");
INSERT INTO yuw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesuho mata tepmo ngo yogocma wömai Kopotorocho Kunkun Yaru kombing tobic tobic owi amna sing imangocma worocha yogoc. Bongono wocin wömai Yesu abe Kopotorocot mangi ida yaguno idit kiap abe masogidoc. Worocha tongga Kunkun Yaruho abe mahogoc. ");
INSERT INTO yuw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Oro suraro yu Yesuhon mata wo kombingmuya auho yogung, “Amna wo yu boinno sinom Kopotorochon yong tuctuc amna moröma.” ");
INSERT INTO yuw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ihoroc yuya torop auho wömai yogung, “Muno, amna ngoi Duic woroc.” Ihoroc yuya auho yogung, “Muno, Duic yui Galili sadec maöngkuic. ");
INSERT INTO yuw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kopotorochon bapiyaho yac, Duic yu king Devithon toropdec Betlehem bucin öngkuangoc. Taun wocin wömai Devitho osuc ididoc.” ");
INSERT INTO yuw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Oro suraroho Yesuha mata koböc koböc ihoroc yong tongmuya fuc tongga torop koböc idung. ");
INSERT INTO yuw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tuna auho Yesu yi bucin sicsichontha yogung mahong yu ambarac botongga tu matogoc. ");
INSERT INTO yuw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Oro suraroho ihoroc yong tongga idiya tawa amnaho Yesu sogit akep toctocha ebungma yu tu matuna ibaru fauna öret socsoc böchon amna dugo orin Farisi yuot onggung. Onguya amna dugoho yu inong yac tongga yogung, “Sonu foro yaha Yesu mayangat tehing?” ");
INSERT INTO yuw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ihoroc yuya tawa amnaho mata ökene iban imongga yogung, “Amna wo yui mata inobarac sinom ninongitac. Amna auho osuc mata ihoroc mayogung.” ");
INSERT INTO yuw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ihoroc yuya Farisiho koroc koroc imuya inogung, “Mayain, yu son ihorocgon kanong yuhachu yo? ");
INSERT INTO yuw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kombiarut, non amna dugohu o Farisihu nonthon torop nonidecma amna tungu au Yesuha makombing tobing imoc. ");
INSERT INTO yuw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Muno sinom owi amna bumbumyi yuhogon wömai kombing tobing imongidang. Yu wömai nongoru mata makombiing. Kopotorocho yu möpmo wagang imuna gorong ongonahing.” ");
INSERT INTO yuw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Amna moröma yu ihoroc yongga itmuya amna au mano Nikodemus yu ihorocgon woce idoc. Yu woi osuc Yesuot onguna mata yogomoroc. Yu woi ihorocgon Farisihon toropdecma. Amna wo yu idongga amna dugo inogoc, ");
INSERT INTO yuw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Tingting oro, nongoru noniho ingoroc yachu: Non ogep amna au foro muno matano yana bödeuntha woha muno? Muno sinom, non muyu osuc yuhon duc mata kombingga youpnohon foro angsoworengga mit wömai matano yana bödehun.” ");
INSERT INTO yuw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ihoroc yuna amna dugoho kombiuya angit maidina inogung, “Tingting oro, goc ihorocgon Galili amnahu? Goc Kopotorochon bapiya sogitmina embahi. Yong tuctuc amna au yu Galili sae maöngkuic.” ");
INSERT INTO yuw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ihoroc yongbödengga mit amna moröma ambaracho inoin inoin böcnon onggung. ");
INSERT INTO yuw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Onguya Yesu yu Oliv sa urongo woce onggoc. ");
INSERT INTO yuw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Oro Yesu yu sa urongodec woce idina isong urang muuna yu öret socsoc böchon gombo ganang onggoc. Tuna owi amna ambaracho yuot eng suran tuya Yesu omoc ida fandat fandat youp togoc. ");
INSERT INTO yuw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ihoroc tongo idina nongoru gendic fandat fandat amna orin Farisi yu owi au yangat tebung. Owi wo yui göra youp tongga idina Farisiho wo angga owi wo Yesuot yangat tengga owi amnaho yangamin tohong yuuya idongga idina ");
INSERT INTO yuw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yesu ingoroc inong ac togung, “Fandat fandat amna, owi ngo yu amna auot usem itongga göra youp tongga idina yagung. ");
INSERT INTO yuw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Oro Möseho owi ihorocnoha nongoru ingoroc sigoc: ‘Yudec sop monda dopnaya omongitnung.’ Möse yu ihoroc yogoc, o goc owi ihorocnoha tingting kombiharoc?” ");
INSERT INTO yuw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Oro Farisi yu ‘Yesu mata youpdec yangat tongga mata firing tanna’ yongo mata ihoroc inongga tonguc yegung. Ihoroc inuya Yesu yu aring möngga forosingga oburo siragoho gurocdec irim togoc. ");
INSERT INTO yuw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ihoroc tongo idina yu toup kiringga inong ac tuya Yesuho foring fadang öngga inogoc, “Sondecma numa amnaho wontucmuno au matongidocma yu wömai owi ngorocdec sop osuc morun.” ");
INSERT INTO yuw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ihoroc yongga wönggon aring möngga gurocdec irim togoc. ");
INSERT INTO yuw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tuna amnaho mata woroc kombingmuya amna tungu tungu ibaru fauna sa wo imu faunto ongbödegung. Amna mata firing tandungma yu osuc onguya amna au yu mit onggung. Ongbödeuya Yesuot owi worocot yuhogon idomoroc. Owi yu osuc yangat tengo tohong yugungan wocingon idongga idoc. ");
INSERT INTO yuw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tuna Yesu yu fadang öngga owi inong ac tongga inogoc, “Amna goc mataho firing garingma yu ongbödengga auho gocdec sop mamoringhu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ihoroc inuna owiho inogoc, “Amna moröma, amna ambarac ongbödeang.” Ihoroc yuna Yesuho inogoc, “Worocha wömai nocho ihorocgon gang banaya ongoi. Goc itonggong kiapa görani woroc imi fauna nongnongo itongidiruc.” Yesuho owi ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Oro oipmon Yesu yu owi amna wönggon yong fandat inongo yogoc, “Noc naka woi gurochon yaguno. Owi amna noc narantangma yu wömai kumbong maitongoning. Muno, yudec wömai itonggonghon yagunoho möng imuna itongontang.” ");
INSERT INTO yuw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ihoroc yuna Farisiho mata woroc kombingga Yesuot mataha emoc toctocha inogung, “Oro woi, gocu gakaha yong moröharoc. Worocha tongga gochon mata Kopotorocho yangamin makoing sic.” ");
INSERT INTO yuw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ihoroc yuya Yesuho inogoc, “Nocu nakain foro tuctugo kombihat. Woi nahe ida ebotma o nahenne ongungotma woi kombing tangtang tat. Worocha tongga nochon mata koing soun. Wohong sonu wömai nochon foro makombing. ");
INSERT INTO yuw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Son gurochon kombic kombic tanmuya noc nangsoworengidang mahong noc nakagon amna au masoworengitat. ");
INSERT INTO yuw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Muno nocot Nandöngnaot not kondonggon idida-mot. Nandöngna noc siuna ebotma yu kombic kombic namuna nocho owi amna yangsoworengitat. Worocha tongga nocho owi amna boinnogon yangsoworengitat. ");
INSERT INTO yuw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Soniin nongoru sonidec wömai mata ingoroc itac. ‘Amna yai yu yapmu auha duc tungu siunyai wömai yuhon mata koing soun.’ ");
INSERT INTO yuw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Oro, worochon torocgon wömai nocu Nandöngna siuna ebotma yuot duc tungu sidaya mata noti koing soun.” ");
INSERT INTO yuw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yesuho mata ihoroc inongyuna Farisiho yu inong ac tongo yogung, “Gochon Nandönga yu nahe itac?” Ihoroc yuya Yesuho inogoc, “Sonu nochon forohu o Nandöngnahon forohu wo makombing. Sontho nochon foro kombinggai wömai Nandöngnahon foro ihorocgon kombiup.” ");
INSERT INTO yuw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Oro Yesu yu öret socsoc böchon gombo ganang ida mata ihoroc surarodec yong fandat inogoc. Woi ecec möneng fiian wocenne ida togoc. Yu mata orongi sinom yogoc mahong yuhon bongono abe maidocmaha tongga amnaho yu sogit akep toctocha botongga abe tu matogoc. ");
INSERT INTO yuw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Oro Yesuho mata sakaun fiuna owi amna ingoroc inogoc, “Nocho sa auhon ongoya sontho nocha yabiu matuna wontucmuno sonibarac omong tongonahing. Sa nocho ongöngotan wocin sonu angit mangoning.” ");
INSERT INTO yuw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ihoroc yuna Yuda nanoho mata woroc kombingga inohogon inun ganun tongga yogung, “Tingtinga yu yac, ‘Sa nocho ongöngotan wocin sonu angit mangoning’ yu ino kubit toctocha yachu?” ");
INSERT INTO yuw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ihoroc yuya Yesuho matano sakaun fiuna yogoc, “Sonu guroc ngorochon fat idang mahong nocu onöcema momphon fat. ");
INSERT INTO yuw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Worocha tongga noc nakaha kanot, Kopotorocho noc nanong muuna ebot, sonu wo makombing tobininganu wömai son womunosonibarac itmuya omnahing.” ");
INSERT INTO yuw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ihoroc inuna yu inong ac tongga inogung, “Tuctugo ninti, gocu numa?” Ihoroc yuya Yesuho inogoc, “Nocu nakain foro urop kanongdet. ");
INSERT INTO yuw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nocho wontucmuno soniha mata koböcma firing karam mahong noc worocha mayit. Muno amna noc nanong muna ebotma yu mata nanongitacma worocgon wömai nocu fandat kanongitat. Yuhon mata woi boinnogon.” ");
INSERT INTO yuw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesuho mata wo inoin fanoha yogoc mahong owi amnaho tuctugo makombigung. ");
INSERT INTO yuw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Worocha tongga Yesuho yogoc, “Sontho Amnahon Manano tuu fadaangoc. Bongono wocin wömai sonu nakain foro tuctugo kombinahing, nocu nakain irot kombic kombic tanmaina yapmu au matongitat. Muno, Nandöngnaho mata nanongitacma worocgon wömai nocho fandat kanongitat. ");
INSERT INTO yuw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Amna nanongmuuna ebotma yu nocot iditac. Tuna nocho ‘yuhon irot kombic kombicgon koing soun’ yongo youp tongitat. Worocha tongga yuho noc maimun faditat.” ");
INSERT INTO yuw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesuho mata orongi ihoroc surarodec silip tong imuna owi amna koböcmaho yu kombing tobing imogung. ");
INSERT INTO yuw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Oro Yuda nano au yu Yesuha kombing tobing imogung. Tuya Yesu yu inogoc, “Son muyu nochon mata fogit akep tongga sumboditnung. Ihoroc tonggai wömai son nochon youp amnanai sinom itnahing. ");
INSERT INTO yuw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Tongo son nochon foro boinno kombingbödenahing. Tuna kombic kombic worocho son asan kamuna dogu kopothon yidec orung itnahing.” ");
INSERT INTO yuw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ihoroc yuna Yuda nanoho inogung, “Goc tingtinga yaroc, non orung itnahamon?’ Nonu urop orung idamon, nonu Abrahamphon morogoni yo, non amna auhon youp wabkarac boyömo maididomon.” ");
INSERT INTO yuw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ihoroc yuya Yesuho inogoc, “Nocho boinno sinom kantiwa, owi amna wöntucmuno tongidangma yu ambarac wontucmunohon youp wabkarac boyömo ididang. ");
INSERT INTO yuw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Youp wabkarac boyömo yu wömai böc morömphon fim öresac masogitning. Muno, böc morömphon manano yuhogon wömai fanohon manomano kömbaha inoha fogiangoc. ");
INSERT INTO yuw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Worocha tongga Mananoho son asan kamunai wömai sonu boinno sinom orung itnahing. ");
INSERT INTO yuw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Noc urop kombihat, sonu Abrahamphon morogoni idang mahong irot sonin wömai nochon matahon bego au maec. Worocha tongga sontho notomom toctocha kombiang. ");
INSERT INTO yuw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kombiarut, nocho Nandöngnaot edeya yuho manomano nindagocma worochon matagon wömai nocho yong fandaditat. O sonu ihorocgon nandöng soniho mata fandat kanuna sonu worochon torocdec itongidang.” ");
INSERT INTO yuw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yesuho ihoroc yuna Yuda nanoho kiringga wönggon yogung, “Nonthon nandöng noni woi Abraham.” Ihoroc yuya Yesuho inogoc, “Son boinno sinom Abrahamphon morogoni itmuyai wömai son Abrahamphon toroc kiap tup. ");
INSERT INTO yuw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nocho Kopotorochon mata boinno kanongitat mahong sontho noc notomom toctocha yang. Abraham yu ihoroc matun. ");
INSERT INTO yuw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Abraham yu sonthon nandöng soni muno, amna auho wömai nandöng soni itac. Tuna sontho yuhon toroc kiap wömunogon tanidang.” Yesu ihoroc yuna owi amnahon irotno obukogoc. Tongo inogung, “Mac noni yu wontucmuno tongga non usem mabagoc. Muno, nonthon Nandöng noni tungugon woi Kopotoroc.” ");
INSERT INTO yuw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ihoroc yuya Yesuho inogoc, “Sonthon Nandöng soni boinno Kopotoroc inai wömai sontho nocha toup kombiup. Yaha nocho Kopotorocot ida ebot. Nocu nakain irot kombic kombic tanda maebot. Muno, Kopotorocho noc nanongmuna ebot. ");
INSERT INTO yuw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Sontho nochon mata tuctugo makombing. Tongo koroc koroc kamongitac. ");
INSERT INTO yuw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sonthon nandöng soni woi dogu kopot yu woroc. Tuna sonu yuhon ibibogon sindan tongidang. Yu wömai osucgon amna dong omom tongidoc o önga kiapmo ihorocnogon tongitac. Kopotorochon mata boinno wömai yudec maec. Worocha yu toroc kiap boinno au matongitac. Muno sinom yu wömai imanang yocyochon foro orin toroc kiap wontucmuno toctochon fano sinom itac. ");
INSERT INTO yuw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Worocha tongga sonu nochon mata boinno wo makombingidang. ");
INSERT INTO yuw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Nocho wömuno au toya sondecma auho noc nagungha woha muno? Muno sinom, noc wömuno au matongitat. Nocho mata boinnogon yongitat mahong sonu makombing tobing namongidang. ");
INSERT INTO yuw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kopotorochon owi amnani yu wömai Kopotorochon mataha onggimo singmuya tuctugo kombingidang mahong sonu Kopotorochon fat maeng, worocha sontho yuhon mata makombingidang.” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tuna Yuda nanoho ec imuya Yesu inogung, “Non kurömna sinom gocha yamon, goc Samariama amna o dogu wontucmunoho gocdec idang.” ");
INSERT INTO yuw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ihoroc yuya Yesuho inogoc, “Dogu wontucmuno auho nocdec maec. Muno, nocho Nandöngna gending imongitat mahong sonu nocha yong samborec yong namang. ");
INSERT INTO yuw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nocu ‘nakain mana onöce itun’ yongo mata au mayongitat. Amna tungu au itac, yu wömai ‘nochon ma onöce itun’ yongo toup kombihac. Amna worocho wömai son kangsoworeangoc. ");
INSERT INTO yuw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nocho boinno sinom kantiwa, owi amna nochon mata sumbodidangma yu wömai omoc koing mau feic.” ");
INSERT INTO yuw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yesuho ihoroc yuna Yuda nanoho Yesu mata kararat inongo yogung, “Boinno sinom, dogu boyömo au gocdec idina yaroc. Goc ingoroc yaroc: ‘Amna au nochon mata sumbentacma yu omom koing maun feic.’ Worochoi oro Abraham orin Kopotorochon yong tuctuc amna yu ambarac urop omongbödegung. ");
INSERT INTO yuw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Gocho yu yanggira-harochu? Öranoni Abraham orin Kopotorochon yong tuctuc amnani yu amna moröma idung mahong yu ambarac osucgon omong fatbödegung. Gocu gakaha tingting kombiharoc gakai numa yo?” ");
INSERT INTO yuw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ihoroc yuya Yesuho inogoc, “Oro noc nakabut, nakain mana onoce töantatma woi yapmu boyömo in. Wohong nocho ihoroc matot, muno Nandöngnaho noc ma moröma nampac. Sontho yuha yongidang, yu Kopotoroc noni. ");
INSERT INTO yuw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Son ihoroc yongidang mahong sonu yuha makombing iming. Nocho wömai yu kombing impat. Tongo nocho ingoroc mayit: ‘Noc yu makombing imot’, ihoroc yonggai wömai nocho son simbang imanang amna em. Nocho yu kombing imongmaina yuhon mata sindanto sumboditat. ");
INSERT INTO yuw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Örasoni Abraham, yu osucgon kombigoc, nocho ehangot. Tongo yu worocha kombingmuna borongdegoc.” ");
INSERT INTO yuw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yesu ihoroc yuna Yuda nanoho mata woroc kombingga ec imuya inogung, “Goc biruca 50 ihoroc abe maeroc worocha gocho Abraham tingtingno aim?” ");
INSERT INTO yuw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ihoroc yuya Yesuho inogoc, “Nocho boinno sinom kantiwa, Abraham abe maöngkui idina nocho urop idot.” ");
INSERT INTO yuw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yesuho ihoroc inuna Yuda nanoho toup sinom ec imuya sop sogita yuha monmontha togung mahong Yesu yu öp gorong ongga öret socsoc böchon gombo imun fauna sumon ohogoc. ");
INSERT INTO yuw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Oro Yesu yu uyap ong tongga auna amna dan komni yu wocin idoc. Macnoho bagocan wocin forosingga yapmu au mayangidoc. ");
INSERT INTO yuw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Oro yu woce idina youp amnaniho Yesu inong ac tongga yogung, “Fandat fandat amna, amna ngo macnoho dan komni bagocma woi inoin turongoha tongga woha macnin faninthon turongoha tongga yu daro komni öngkuboc.” ");
INSERT INTO yuw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ihoroc yuya Yesuho inogoc, “Muno woi, amna inoin turongohahu o macnin faninthon turongoha ihoroc matogoc. ‘Kopotorochon gesö morömaho yudec eran öngkupun’ yongo foro worocha tongga ihorocma öngkuboc. ");
INSERT INTO yuw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kombiarut, öngai abe yagunohon bongonodec idamon. Worocha tongga noc muyu Kopotoroc nanong mudocma yuhon youp towa. Mit wömai sa kumbong diuna amna au yu youp ihorocno angit matoning. ");
INSERT INTO yuw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nocho guroc ngocin itongmaina gurochon yaguno iditat.” ");
INSERT INTO yuw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu mata ihoroc yongga irubo gurocdec sunda irupo gurocot mongorec tongga nanggaram wo sogida amna dan komnihon darodec wagang imogoc. ");
INSERT INTO yuw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ihoroc tongga amna wo inogoc, “Goc ongmina yamuc mano Siloam woce yamuc gupi.” Mano Siloam worochon mata forono woi ‘Kopotorocho inong muuna onggoc’. Inuna amna dan komtoctocni yu woce ongmuna yamuc gubocmai daro orokogoc. Tuna yu böcnon onggoc. ");
INSERT INTO yuw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Woce idina inoin toropnihu o owi amnaho osuc yu kombing imogungmahu yuho yogung, “Mayain, amna ngo yu osuc uroci sinom idoc. Yu daro kom toctocyi itmuna ‘owi amnaho möneng namarut’ yongo uyap tan ididoc. Yu amna worochu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ihoroc yongmuya auho wömai yogung, “Boinno woi amna woroc,” o auho wömai yogung, “Muno, ino sinom muno. Woi amna au yu simbanggon.” Mata ihoroc yongga idiya yu inobut kiringga yogoc, “Noc naka woi ngoroc.” ");
INSERT INTO yuw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ihoroc yuna owi amnaho yu inong ac tongga yogung, “Tingting sinom tongga dara orokuna foriharoc?” ");
INSERT INTO yuw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yuya yu mata ökene iban imongo yogoc, “Amna mano Yesu yongidangma yu gurocot yamucot mongorec tongga dannadec singga nanoc, ‘Goc Siloam yamuc öngkoringdec ongga yamuc gupi.’ Ihoroc nanuna noc woce ongga yamuc gungga danna orokogoc.” ");
INSERT INTO yuw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ihoroc yuna owi amnaho inogung, “Amna wo yu nahe itac?” Yuya yuho yogoc, “Noc makombit.” ");
INSERT INTO yuw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Oro Yesuho guroc tong nanggaram tongmuna amna worochon daro tun orokogocma woi Sabat bongonodec togoc. Worocha tongga owi amnaho amna woroc yangada Farisiot tonggung. ");
INSERT INTO yuw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tuya Farisi yu ihorocgon inong ac tongga yogung, “Ting tongga dara ogep foriharoc?” Inuya yu inogoc, “Yu guroc tong nanggaram tongga dannadec siuna yamuc guaya danna orokogoc.” ");
INSERT INTO yuw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Inuna Farisiho matano kombingga ficfuc tongmuya auho yogung, “Amna wo yu Sabat bongono maanggendingitac worocha tongga yu Kopotorochon madec maeboc.” Oro auho wömai yogung, “Wömuno toctoc amna yu toroc kiap moröma ihoroc matun.” Farisi yu mata koböc koböc ihoroc yong tongmuya soworengga torop yai idung. ");
INSERT INTO yuw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tongo yu wönggon amna osuc dan komni idocma inong ac tongga inogung, “Amna wo gochon dara tun orokocma gocho yuha tingting kombiharoc? Yu amna tingtingno sinom?” Ihoroc inuya yu yogoc, “Yu woi Kopotorochon yong tuctuc amna au.” ");
INSERT INTO yuw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yuna Yuda nanohon amna dugo yu amna worocha abe irot yai tongmuya yogung, “Yu imanang yac yo, yui daro komni maidoc.” Ihoroc yongga amna worochon macnin fanin inong yuya ebomoroc. ");
INSERT INTO yuw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ehunya amna dugoho inongo yac tongga yogung, “Amna wo yu sothon manasotihu nuhun? Macnoho yu bauna dan komni idochu nuhun? Ihorocanu wömai ting tongga yu daro ogep forihac?” ");
INSERT INTO yuw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ihoroc inuya macnin fanintho mata ökene ibanda yogomoroc, “Boinno sinom amna ngo yu nothon mananoti. Macnoho yu bauna dan komni idoc. Wo wömai notu boinno kombiamot. ");
INSERT INTO yuw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Wohong tingting tongga önga daro forihacma o numaho tongfat yeuna orokocmai wömai notu makombimot. Son muyu ino inong ac tarut. Yui ino amna moröma itac. Tongo yu ogep inoin fatno kanun,” ihoroc yogomoroc. ");
INSERT INTO yuw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Oro Yuda nanohon amna dugo yu urop mata ingoroc yu bödeuna nongoru ingoroc sigung: ‘Owi amna au yu Yesuha yuyai yu Kopotorochon Duic, yu wömai Yuda nanohon fatmata yocyoc bucin önggöngno wönggon maic. Muno surarohon dugoho wömai yu taruya ongonung.’ Yu nongoru ihoroc sigungmaha tongga amna dan komnihon macnin fanintho amna dugoha botongmunya mata woroc yogomoroc. ");
INSERT INTO yuw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yu yogomoroc, “Mananoti yu urop amna moröma itac. Worocha not yuha mata au mayotin, son muyu yu inong ac tuya fatno kanun.” ");
INSERT INTO yuw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Oro Farisi yu wönggon bongo yai amna dan komni idocma yu inong yuya eboc. Ehuna amna morömaho kiringga inogung, “Non kombiamon, amna wo goc tong fat gehacma yu woi wömuno toctoc amna. Worocha goc Kopotorocho yangamin amna worochon foro boinno yong taya kombina.” ");
INSERT INTO yuw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ihoroc yuya yu mata ibanda inogoc, “Yu woi wömuno toctoc amnahu o munohu, woi nocu makombit. Yapmu tungugon wömai nocu kombihat, noc osuc dan komni idot mahong öngai nocu danna ogep forihat.” ");
INSERT INTO yuw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ihoroc yuna amna dugoho wönggon kiring imongo inogung, “Yuho ting tuna dara orokogoc?” ");
INSERT INTO yuw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ihoroc yuya yu koroc koroc imuna inogoc, “Noc urop fatno kanongdet mahong sonu makombing. Sonu ihorocgon ‘yuhon youp wabkarac itna’ yongo bongo koböc nochon mata fat wo kombic kombicha yanga?” ");
INSERT INTO yuw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ihoroc inuna amna dugo ec imuya yu inong saha tongo kararat inongga yogung, “Goc gakabut wömai yuhon youp wabkarac itaroc mahong nonu wömai Mösehon youp wabkaracni ididamon. ");
INSERT INTO yuw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Non boinno sinom kombiamon, Kopotorocho osuc Möse mata inongidoc mahong amna worocho nahe ida ebocno wo wömai nonu makombimon.” ");
INSERT INTO yuw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ihoroc yuya amna dan komniho yu inogoc, “Mayain sonu mata foro au yang yo! Amna worocho nochon danna tun orokogoc mahong sonu yu nahe ida ebocno woi makombiing. ");
INSERT INTO yuw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Non ambarac ingoroc kombingidamon: Kopotoroc yu amna wontucmunohon dönac makombingitac. Muno yu amna nongnongohon matagon kombing-itac. ");
INSERT INTO yuw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Oro amna au yu macnoho modibin daro komni itmuna orokogocma yapmu ihorocno wömai nonu fodibo sinom aamon. ");
INSERT INTO yuw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Amna au yu inoin gesödec ihoroc matun. Muno Kopotorocho amna wo siuna ebocmaha tongga yu kiap moröma ihoroc tongitac.” ");
INSERT INTO yuw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ihoroc yuna Farisiho mata woroc kombingga ec imuya inogung, “Tingting sinom oro, gocu wontucmuno toctoc amna, macaho goc uyapdec usem bagoc. Tingtinga fandat nintaroc yo.” Yu ihoroc yongga inong fato taruya onggoc. ");
INSERT INTO yuw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Oro Yesu yu ingoroc kombigoc: Farisiho amna dan komni idocma wo taruya onggoc. Wo kombingga ongmuna amna wo aun feuna inogoc, “Gocu Amnahon Manano kombing tobing imparocha muno?” ");
INSERT INTO yuw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ihoroc inuna yu inogoc, “Amna moröma, Amnahon Manano woi numa? Goc naniya nocho yuha kombing tobing imontat.” ");
INSERT INTO yuw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ihoroc yuna Yesuho inogoc, “Goc urop angderoc. Amna gocot mata yongga itacma woi woroc.” ");
INSERT INTO yuw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ihoroc inuna amna worocho yogoc, “Moröma, noc kombing tobihat.” Ihoroc inongo goruc yemoc tongga Yesu yong moröng imogoc. ");
INSERT INTO yuw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tuna Yesuho yogoc, “Nocho ‘owi amna yangsoworewa’ yongo guroc ngocin ebot. Amna dan komni idangmaho dan foric foric tonahing o dan foric foricniho wömai dan kom tonahing.” ");
INSERT INTO yuw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ihoroc yuna Farisi au yu Yesu tan ambehecgon itmuya mata wo kombingga Yesu inogung, “Tingting oro, nonu ihorocgon dan komnihu?” ");
INSERT INTO yuw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ihoroc yuya Yesuho inogoc, “Oro son dansoni kom tunai wömai turongo soni muno ip. Wohong sonu yongidang, ‘Nonu dannoni foriamon’, worocha tongga wöntucmunosoni wömai idtongungoc.” ");
INSERT INTO yuw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Oro Yesu yu mata ingoroc yogoc, “Nocho boinno sinom kantiwa, amna au yu bot sipsipot onggonga simbudecgon mangic mahong gombo öpgon öng katingga gombo ganang ongitacma yu woi usem amna. ");
INSERT INTO yuw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bot sipsip yangtorec amna ogepmaho ihoroc matongidang. Muno, yu wömai gombohon simbugon tanda bot sipsipot ongidang. ");
INSERT INTO yuw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Simbu angtorec amnaho wömai yu simbu fagarit imuna yu bot sipsipot ongitac. Tuna bot sipsip yu wömai duc ingguro kombingidang. Tuya yu bot sipsipni inoin inoin manodec inong yongo yangato sumon fohongitac. ");
INSERT INTO yuw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yu bot sipsipni ambarac yangada sumon fohongbödengga inoho osuc fat imuna bot sipsip yu duc ingguro kombingga yu menon tan tohongidang. ");
INSERT INTO yuw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bot sipsip yu wömai amna fodibo au mayan fongidang. Muno, yui amna fodibohon duc ingguro makombiingmaha tongga yu angbotongga korungon ongga gorong ongontang.” ");
INSERT INTO yuw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Oro Yesu yu suraro mata tepmo ihoroc inogoc mahong yu mata worochon foro tuctugo makombigung. ");
INSERT INTO yuw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tuna Yesuho wönggon ingoroc inogoc, “Nocho boinno sinom kantiwa, bot sipsipot onggongon simbu woi noc naka. ");
INSERT INTO yuw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Amna ambaracho son kangtorec torecha osuc fat namongo ebungma yu wömai usem amna. Tuna bot sipsipho yuhon duc ingguro makombigung. ");
INSERT INTO yuw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kombiarut, nocu nakai simbu ogepma. Owi amna nocot engidangma yu wömai batip itnahing. Tuna yu gombo ganang ongi epi tongo nacno ogepma nong tongonahing. ");
INSERT INTO yuw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Oro usem amna yu engmuya bot sipsip usem tongidanghu o dong omom tongidangu o dou moin tongidang. Wohong nocho wömai ‘bot sipsipnai itonggong ogepma sogiarut’ yongo ebot. Tuna itonggong worocho maobökic, muno worocho wömai iditnoho iditno yuot edengoc. ");
INSERT INTO yuw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Bot sipsip yangtorec torec amna ogepma woi noc naka. Bot sipsip yangtorec torec amna ogepma yu wömai bot sipsip tongfat yecyecha inoin itonggongno imun faditac. ");
INSERT INTO yuw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Youp wabkarac boyömo yu wömai bot sipsiphon morömo sinom muno. Worocha tongga yu auna sap dunggit ehunai wömai yu bot sipsip dongyun fauya botongga ongontac. Tuna sap dunggitho bot sipsip wo dong yaruna sa wocewoce gorong ongontang. ");
INSERT INTO yuw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Youp wabkarac boyömo yu wömai bot sipsip mönenghagon yangtorengidang. Yu bot sipsipha irot imocno sinom matongidang. Worocha tongga yu karupgon botongga korungon ongidang. ");
INSERT INTO yuw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Bot sipsip yangtorec torec amna ogepma woi noc naka. Nocu bot sipsipnai ambarac kombingbödehat. O nochon bot sipsipnai yu noc kombing namang. ");
INSERT INTO yuw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nandöngnaho noc kombing nampac, o ihorocgon nocho Nandöng kombing impat. Worochon torocgon wömai nocho bot sipsipnai kombing impat. O nocho bot sipsip tongfat yecyecha tongga itonggongna ima faangoc. ");
INSERT INTO yuw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","“Oro nochon bot sipsip torop au idang. Yu wömai abe nochon gomboin maeng. Nocho ongmaina yu ihorocgon nochon gomboin yangat feangot. Nocho bot sipsip torop woroc inong yoya yu duc ingguna kombingmuya nocot ehuya suraro tungu itnahing. O yangtorec amnano tunguhogon engoc. ");
INSERT INTO yuw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nocu nakain itonggongna ima fauna wönggon wego sogiangot. Foro worocha tongga Nandöngnaho nocha toup kombihac. ");
INSERT INTO yuw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","O amna auho nochon itong-gongna tun bödec bödecno woi maic. Muno, noc nakain irot kombic kombic tanda itonggongna ima faangoc. Nandöngnaho noc youpha soworengga itonggongna ima fatfathon gesö namogoc. O ihorocgon itonggongna wönggon sogit sogithon gesö namogoc.” Yesu yu mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tuna Yuda nanoho mata woroc kombingga inohogon mataho emoc tongmuya torop yai idung. ");
INSERT INTO yuw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Aumaho wömai yogung, “Dogu wontucmunoho yudec itac. Worocha tongga yu bumbum yac. Son yuhon mata kombininga,” ihoroc yogung ");
INSERT INTO yuw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","mahong torop auho wömai yogung, “Dogu wömunoho amna au sogiuyai wömai amna worocho mata ogepma ihoroc mayun. O dogu wömunoho amna dan komni matun orokic,” ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Oro Yerusalem taundec komöc sum bongono idina urop Israel nanohon yongmoröng bongono moröma öngkuboc. Bongono wocin wömai Israel nano yu osuc sinom öret socsoc böchon simbuno fagaridungma worocha kombingga eng suran tongidung. ");
INSERT INTO yuw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu yu bongono wocin öret socsoc böchon gombo ganang itmuna Solomonthon sum sogit sogit baranda wocin itongga idoc. ");
INSERT INTO yuw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tuna Yuda nano yu engmuya Yesu angarenggumbec tongga inong ac tongga yogung, “Nonu gocha irot yai tamon. Gocu gakain foro öp sirocha. Goc tuctugo ninti, Kopotorochon Duic woi goc gakaha woha goc muno?” ");
INSERT INTO yuw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ihoroc yuya Yesuho matano ökene ingoroc iban imogoc, “Noc urop kanongdegot mahong sonu makombing tobiing. Nocho Nandöngnahon madec momphon toroc kiapmo inobarac sinom tongitat. Sonu woroc yangmuya nochon foro tuctugo kombiup. ");
INSERT INTO yuw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Wohong sonu nochon bot sipsip toropdecma muno. Worocha tongga sonu makombing tobing namongidang. ");
INSERT INTO yuw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nochon bot sipsip yu wömai nochon duc ingguna kombingga noc nanidang. O nocho wömai yu ambarac kombing impat. ");
INSERT INTO yuw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nocho yu itonggong koing imongo tong batip tongga magorong ongoning. Amna auho yu nochon obunadec usem matic. ");
INSERT INTO yuw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Muno, Nandöngna yui moröma sinom yui manomano ambarachon öngitno. Yuho bot sipsip ‘nocho yangtorewa’ yongo namogoc. Worocha tongga amna auho bot sipsipnai yuhon oburodec fuun detdetno wömai maic, muno sinom. ");
INSERT INTO yuw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nandöngot nocot nodu tungugon.” ");
INSERT INTO yuw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yesuho mata ihoroc yongbödeuna Yuda nanoho kombingga ec imuya ‘Yesu wotnaya ompun’ yongo sop fogida yudec monmontha togung. ");
INSERT INTO yuw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ihoroc tuya Yesuho inogoc, “Nandöngnaho kombing namuna nocho momphon toroc kiap inobarac sinom koböcma toya sonu yagung. Oro nocho yaö kiap kandoc togotmaha sonu sopdec not notha tang?” ");
INSERT INTO yuw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ihoroc yuna Yuda nanoho mata ökene inongga yogung, “Gocho toroc kiap au togorocmaha magotning. Muno, gocho Kopotorocha yong samborec yarocmaha nontho gotgotha tamon. Gocu amna komanangno, wohong gocu yaroc ‘nocu Kopotoroc’.” ");
INSERT INTO yuw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ihoroc yuya Yesuho inogoc, “Soniin nongoru sonidec wömai Kopotorocho amna komanangnoha mata au ingoroc yogoc, ‘Sonu Kopotoroc simbang idang.’ ");
INSERT INTO yuw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Oro, mata wo ‘son Kopotoroc simbang’ wömai numariha yogoc? Woi owi amna komanangno Kopotorochon mata sogidungma yuha wömai yogoc. O mata Kopotorochon bapiyadec itacma woroc guman gumanno wömai maec. ");
INSERT INTO yuw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Oro nocu amna komanangno muno. Nandöngnaho ‘nochon kunkun amna iti’ yongo noc inoin youpha soworengga nanongmuuna gurocdec ebot. Tongo nocho ogep ingoroc yontat, ‘noc Kopotorochon Manano’, noc Kopotorocha yong samborec mayot. Worocha sonu foro yaha nocha mata firing narang yo. ");
INSERT INTO yuw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nocho Nandöngnahon youp matoyai wömai sonu nochon mata kombing tobininga. ");
INSERT INTO yuw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wohong nocho Nandöngnahon youp tontatanu wömai sonu woroc yangmuya kombing tobing namarut. Nochon duc mataha muno, nochon youpha kombing tobing namarut. Tongo sonu boinno sinom kombinahing, Nandöngnaho nocot itac. Nocot Nandöngnaot not irot tungu idamot.” ");
INSERT INTO yuw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yesu mata wo yongbödeuna Yuda nanoho yu wönggon sogit akep toctocha togung mahong Yesu yu öpgon gorong onggoc. ");
INSERT INTO yuw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tongo mit Yesu yu ongga Yödan yamuc ökonda onguna Jöntho osuc owi amna yamuc gung imongidocan sa wocin idoc. ");
INSERT INTO yuw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Woce idina owi amna koböcmaho yuot engmuya yogung, “Boinno, Jön yu osuc momphon toroc kiap au matongidoc mahong yu Yesuha mata yogocma woi ambarac boinnogon yogoc.” ");
INSERT INTO yuw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ihoroc yongmuya owi amna koböcmaho sa wocin Yesuha kombing tobing imogung. ");
INSERT INTO yuw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Oro Betani böcsa amna au mano Lasarus yu obukoc tongga idoc. Yuhon natnin yan dano Maria orin Marta yu ihorocgon böcsa wocin ididomoroc. ");
INSERT INTO yuw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria yu wömai osuc unac tugoni Morömahon orungodec koringmuna inoin bigo sakemoho tong manman togoc. ");
INSERT INTO yuw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Oro Lasarus obukoc tongga idina yan danomaho mata ingoroc siunya Yesuot onggoc: ‘Moröma, amna gocho yuha toup kombingitarocma yu obukoc tongga itac.” ");
INSERT INTO yuw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mata ihoroc siunya Yesuot onguna yu wo kombingo yogoc, “Obukoc worocho omomphon muno. Kopotorochon Mananoho wo tun bödeangoc. Tongo yu ma moröma sogiangoc. O Kopotorochon gesö morömaho owi amnaho yangamin eran öngkuuna ango Kopotoroc yong moröng imonahing.” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yu wömai Maria Marta Lasarus yomot natni yuha toup sinom kombingidoc ");
INSERT INTO yuw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","mahong yu Lasarusho obukoc togocmahon fatno kombingga karupgon yuot manggoc. Muno yu sep youp toctoc yai sa idocan wocegon torengga idoc. ");
INSERT INTO yuw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sep yai bödeuna Yesuho youp amnani inogoc, “Non wönggon Yudia gurocin ongona” ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tuna youp amnaniho kombiuya angit maidina inogung, “Fandat fandat amna, öngahemgon Yuda nanoho goc sopdec gotgotha togung worocha goc woce ongirocha.” ");
INSERT INTO yuw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ihoroc yuya Yesuho mata tepmo au ingoroc iban imogoc, “Sep youp toctoc danong wömai sepho yaguno möng nimongitac. Tuna amna au yu sep bongonodec uyap itongitacma yu wömai acacho ogepgon itongmuna mamöngitac. ");
INSERT INTO yuw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Wohong amna au yu kumbong-nodec yagunono muno uyap itongitacma yu wömai möantac.” ");
INSERT INTO yuw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu yu ihoroc yongo wönggon mata sakaun fiuna youp amnani inogoc, “Oröcnoni Lasarus yu komanang dungo itac mahong nocho yuot ongmaina ta wekangoc.” ");
INSERT INTO yuw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yesuhon youp amnaniho mata woroc kombingga inogung, “Moröma, yui dungga idinai wömai obukocno bödeuna orokontac.” ");
INSERT INTO yuw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Youp amnani yu wömai kombigung, Lasarus komanang dungga idina yoc mahong Yesu yu Lasarus kömbaha ombocmaha yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Worocha tongga Yesuho tuctugo inogoc, “Lasarus yu boinno omboc ");
INSERT INTO yuw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","mahong ‘sontha’ yongo nocho yu ombocan yuot maidot. Ihoroc wömai sonu kombinahing yu boinno sinom omboc. Tuna sonu noc kombing tobing namonahing. Oro urop yuot ongona.” ");
INSERT INTO yuw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ihoroc yuna, amna au mano Tomas yu youp amna nucni inogoc, “Non ambaracho Yesuot ongmanaina kondong omong fatnahamon,” ihoroc yogoc. Oro Tomashon mano au wömai nonin matadec ‘bambam bacbacyi’ ihoroc yongidung. ");
INSERT INTO yuw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesuot youp amnaniot yu ongga Betani böc ambehecgon öngkungmuya Yesu mata ingoroc kombigoc: Lasarus yu omongga urop sep youp toctoc awanomuno kumkumon itac. ");
INSERT INTO yuw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani böc woi Yerusalem ambehecgon idoc. Woi 3 kilomitahon toroc ihoroc. ");
INSERT INTO yuw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Worocha tongga Yuda nano koböcmaho engmuya Marta orin Mariahon natno ombocma worochon singguyano ito itfat yugung. ");
INSERT INTO yuw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Oro Marta yu kombigoc, Yesu urop ehantac. Ihoroc kombingga karupgon ongga Yesu uyapdec aun fedoc. Maria wömai bucin idoc. ");
INSERT INTO yuw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martaho Yesu aun feuna inogoc, “Moröma, gocho nonot idiyai wömai natnodi mamong faun. ");
INSERT INTO yuw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Wohong nocho boinno sinom kombihat, gocho önga yapmu auha Kopotoroc dönac iniyai wömai yuho kombing gamontac.” ");
INSERT INTO yuw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yuna Yesuho inogoc, “Boinno sinom, nada wönggon idongontac.” ");
INSERT INTO yuw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ihoroc yuna Martaho inogoc, “Nocu kombihat, yu wömai mit bongono morömadec wekangoc. Bongono wocin wömai owi amna ambaracho wekongbödenahing.” ");
INSERT INTO yuw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ihoroc yuna Yesuho inogoc, “Omocdecma wekoc wekoc worochon Morömo woi noc naka. O itonggongon Morömo woi ihorocgon noc nakagon. Owi amnaho noc kombing tobing namongidangma yu omnahing mahong mit itonggong koing au feangoc. ");
INSERT INTO yuw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Boinno sinom, owi amnaho wec itmuya noc kombing tobing namonahingma yu ambaracho omong koing mau feic. Gocu mata wo kombing tobiharocha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ihoroc yuna Martaho inogoc, “Öc Moröma, noc kombing tobing gampat. Goc Kopotorochon Manano Duic. Kopotorocho goc owi inoin amnani fogit fogitha ganong muuna gurocdec eboroc.” ");
INSERT INTO yuw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Oro Marta yu ihoroc yongo mit ongga dano Maria inong yuna ehuna inong masang tongo yogoc, “Fandat fandat amnaho urop epac. Yu gocha yac.” ");
INSERT INTO yuw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria yu woroc kombingga wohogon idongga Yesu acacha domdomgon onggoc. ");
INSERT INTO yuw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Onguna Yesu yu abe Betani bucin maeboc. Yu osuc Martaho aun fedocan wocingon torengga idoc. ");
INSERT INTO yuw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Oro Yuda nanoho Maria itfat yuya yuho bucin idungma yu agungmai Maria yu karupgon idongga taitdec ohogoc. Tuna angga Yuda nano ‘yu yong oin toctocha kumkumon ongeyac’ yongo yu tan tonggung. ");
INSERT INTO yuw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tan tuya Maria yu Yesu aun feuna orungo forodec göruc yemoc tong imongga inogoc, “Moröma, gocho nonot idiyai wömai nochon natna mamong faun.” ");
INSERT INTO yuw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ihoroc yuna Yesuho yagocmai Maria orin Yuda nano yuot ebungma yu ambarac yong ointongo idung. Ihoroc yangmuna yu irot mep tongo uroc imocno sinom tongmuna inogoc, ");
INSERT INTO yuw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Son Lasarus sa nahenne oring sigung?” Ihoroc inuna owi amnaho inogung, “Moröma, goc engmina ahi.” ");
INSERT INTO yuw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ihoroc yuya Yesu yu ihorocgon oin tongga idina ");
INSERT INTO yuw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yuda nanoho yu angmuya yogung, “Aarut, yu amna worocha toup sinom kombingidoc.” ");
INSERT INTO yuw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ihoroc yogung mahong auho wömai yogung, “Yu osuc amna dan komnima tun orokogoc. Yu yaha Lasarus matongfat yegoc! Tongfat yeunahai wömai mamun.” ");
INSERT INTO yuw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Oro Yesu yu irot mep sinom tongmuna ongga kumkumondec ongkuboc. Kumkumon woi amnaho sop ganango au tobiuya idoc. Böngo wömai sop moröma au foctongo siuya idoc. ");
INSERT INTO yuw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ihoroc idina angga Yesuho inogoc, “Sop wo öcangmu ongoun.” Ihoroc inuna amna ombocmahon natno Marta yu soroc yongo inogoc, “Moröma, ep fambangno urop sep youp toctoc awanomuno ihoroc kumkumon itac. Worocha tongga tugo wöntucmuno öantac.” ");
INSERT INTO yuw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ihoroc inuna Yesuho inogoc, “Nocho urop ganongdet. Goc kombing tobingminai wömai Kopotorochon gesö moröma aantaroc.” ");
INSERT INTO yuw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ihoroc inuna amna auho sop wo öcangmu onggoc. Tuya Yesuho momdec foringmun uuna dönac yongo yogoc, “Nandöngna, gocu nochon dönac urop kombing namparoc, worocha nocho ecec gantat. ");
INSERT INTO yuw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Noc kombihat, goc bongono muno dönacna kombingitaroc mahong ‘owi amna ngocin idangma yu dönacna ngo kombiarut’ yongo eran gantat. Ihoroc toya yuho kombiantang, gocho boinno sinom noc nanongmuya ebot. Ihoroc woroc kombing tobiarut yongo dönac ngo gantat.” ");
INSERT INTO yuw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu yu dönac ihoroc yun bödeuna ecnang mamboda yogoc, “Lasarus, goc idongga sumonon epi!” ");
INSERT INTO yuw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ihoroc inuna Lasarus yu idongga sumonon eboc. Orungohu oburohu yangamohu wo boru tombarac sumon eboc. Ehuna Yesuho owi amna inogoc, “Son omomphon boru wo asan imuya ongoun,” Yesu yu ihoroc tuna Lasarusho wekongga idonggoc. ");
INSERT INTO yuw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Oro Yuda nano koböcma Mariaot ebungma yu Yesuho toroc kiap inobarac togocma wo angmuya kombing tobing imogung. ");
INSERT INTO yuw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Wohong auho wömai Farisiot ongmuya Yesuho kiap togocma worochon fatno inogung. ");
INSERT INTO yuw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Inuya Farisi orin öret socsochon amna dugo yu Yuda nanohon amna moröma inong yuya engsuran togung. Tongo ingoroc yogung, “Amna woroc yu toroc kiap inobarac koböcma sinom tongitac. Worocha nonu tingting tontamon? ");
INSERT INTO yuw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nontho yu angbananaya suraro ambaracho yu kombing tobing imoningyit. Ihoroc tuyai wömai Röm nanohon tawa amnaho engmuya öret socsoc böc nonihu tu mointuna mepmo moröma sinom nimuya nontho yuhon youp wabkaracni itnam.” ");
INSERT INTO yuw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Oro amna dugo yu ihoroc yong tongga itmuya amna au mano Kaiyafas yu idonggoc. Yu wömai biruc worochon öret socsoc böchon amnahon dugo morömano idoc. Tongo yu idongga yogoc, “Sonu kombic kombic soni maec yo. ");
INSERT INTO yuw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kombiarut, kiap tunguhogon wömai non tongfat neangoc. Amna tunguhogon suraro ambarachon abam sogida ompun. Omentacanu wömai non Yuda nano ambaracho magorong ongonin.” ");
INSERT INTO yuw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiyafasho mata wo yogocma woi inoin kombic kombicdecma mayogoc. Muno, yu biruc worochon öret socsoc böchon amna dugo idocmaha tongga yu yong tuctuc mata ingoroc yogoc, Yesu yu Yuda nano tongfat yecyecha omengoc. ");
INSERT INTO yuw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","O Yuda nanohagon muno, yu omengocmaha tongga Kopotorocho weni manani woce woce sa korungon idangma yu ambarac fengsuran tuna torop tungu itnahing. ");
INSERT INTO yuw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Oro bongono wocin forosingga Yuda nanohon amna morömaho Yesu wuya omomphon mata yong torop yongo sigung. ");
INSERT INTO yuw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Worocha tongga Yesu yu wönggon Yuda nanohon bonipnodec eran maitongidoc. Muno yu youp amnani yangauna böcsa au mano Efraim woce idung. Böcsa wo wömai sa amna maiyan woroc tan idoc. ");
INSERT INTO yuw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Oro Israel nanohon bongono morö ‘Pasowa’ yongidangma worocho urop eng fom togoc. Worocha tongga böc wohon wohonma owi amna koböcma yu Yerusalem ögung. Yu wömai ‘wöntucmuno noni tong sac tongga Kopotorocho yangamin sacsago itna’ yongo Yerusalem öngmuya bongono morömaha tong arangarang togung. ");
INSERT INTO yuw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yerusalem öngmuya yu Yesuha yabiu matuna öret socsoc böchon gombo ganang öngmuya mata ingoroc inun ganun tongga yogung, “Son tingting kombiang oro, Yesu yu yong moröng bongono acacha ehantacha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ihoroc yong tongga idiya öret socsoc böchon amna moröma orin Farisi yu ‘Yesu sogit akep tona’ yongo nongoru ingoroc suraro imogung, Numariho Yesu nahe itacno wo kombinggai yu muyu worochon yongburoc mata amna moröma inarut. ");
INSERT INTO yuw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Oro Yuda nanohon yong moröng bongono ‘Pasowa’ worocho abe maöngkui idina sep youp toctoc 6 ihoroc idina Yesu yu böcsa Betani woce onggoc. Böcsa woi Lasarushon böcsano, yu wömai Yesuho kumkumonma tun wekogoc. ");
INSERT INTO yuw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Oro Yesu sa woce idina böc morömpho Yesuha tong sonoc au togung. Tuya Marta yu amna idungma nacno silip tong imogoc. Lasarus yu ihorocgon Yesuot nacno abamdec omoc idoc. ");
INSERT INTO yuw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tuna Maria yu unac tugo ogepma sinom mano ‘nad’ woroc tengga Yesuhon orungo wagang imogoc. Wagang tongo inoin bigo sakemoho tong manman tong imogoc. Tuna unac tugo ogepma worocho böc ganang tugo mang busongga idoc. Unac worochon wöngnacno woi önggungyi sinom. ");
INSERT INTO yuw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ihoroc tuna Yesuhon youp amna au mano Yudas Iskariot yu kombiuna angit maidoc. Yudas yu wömai mit Yesu ayamihon oburodec sigoc. Yu kombiuna angit maidina yogoc, ");
INSERT INTO yuw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Unac tugo ogepma worochon wöngnacno moröma sinom. Amna auho wuuna 300 Kina ihoroc fogitmanaina amna uroci imonam. Owiho wo komanang sinom tong samborec tac yo.” ");
INSERT INTO yuw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Oro Yudas yu amna urocimaha kombingga mata wo mayogoc. Muno, yui usem amna. Yu wömai Yesu toropnihon möneng koding angtorengidoc. Tongo yu möneng au inoha usem tongidoc. ");
INSERT INTO yuw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Oro yu owi ihoroc inong fauna Yesuho inogoc, “Owi wo imi fahun. Owi ngorocho unac godibnadec wagang nampacma woi godip föbna oring sicsicha tong arangarang toctochon tac. ");
INSERT INTO yuw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Amna uroci yu wömai bongono muno sonot itnahing mahong nocu bongono docutnogon sonot engot,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Oro Yesu yu Betani bucin idina Yuda nano koböcmaho yu woce itacnohon fatno kombingga wocin ebung. Yu woi Yesu acachagon kombingga maebung. Muno, yu Yesuho Lasarus omocdecma tun wekogocmahon fatno wo kombigungmaha tongga yu “Lasarus ana” yongo ebung. ");
INSERT INTO yuw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Engmuya agungmai Lasarus yu boinno wec idoc. Worocha tongga owi amna koböcma sinompho Yesu kombing tobing imogung. Ihoroc tuya öret socsoc böchon amna moröma yu kiapmo wo angga irotno obökuna yu “Lasarus ihorocgon wotnaya omengac” yongo mata yong torop sigung. ");
INSERT INTO yuw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Oro kembotsum owi amna yong moröng bongono acacha ebungma yu Yesuhon fatno ingoroc kombigung: “Yu urop Yerusalem ebepha tac yo.” ");
INSERT INTO yuw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ihoroc kombingga sibat sakemo fogitmuya Yesu au fetfetha ongmuya ingoroc mamboda yogung: “Kopotoroc yong moröng imona! Morömahon madec epacma yudec wömai Kopotorochon guram itun.” “Israel nanohon king moröma yuha yong kumena!” ");
INSERT INTO yuw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Owi amna yu ihoroc yong kumengga idiya Yesuho bot donki beracno aun feuna woroc koroc itmuna onggoc. Kopotorochon bapiyadec wömai worochon yong tuctuc matano ingoroc irim toctocyi itac: ");
INSERT INTO yuw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Israel nano sonu nanga fatfat toninga. Aarut, sonthon king moröma soni yu bot donki beracno koroc itmuna epac.” ");
INSERT INTO yuw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Oro mata worocho bongono wocin boinno öngkuboc mahong youp amnani yu mata worochon foro abe kombing tangtang matogung. Yesuho omocdecma idonggocan bongono wocingon wömai yu kombigung, yong tuctuc worocho Yesuha yac. Tuna bongono wocin boinno öngkuboc, ihoroc kombigung. ");
INSERT INTO yuw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Oro Yesuho Lasarus omocdecma tun wekogocma worochon fatnoho toup wun morögigoc. Owi amna kiapmo wo agungma yu worochon fatno böcsa danong yong tonggung. ");
INSERT INTO yuw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tuya owi amna koböcmaho worochon fatno kombingga ongga Yesu uyapdec au fedoc. ");
INSERT INTO yuw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ihoroc tuya Farisiho wo yangmuya irotnoho obökuna yogung, “Yaarut sa guroc danong suraro ambaracho amna worocgon tan tongidang. Worocha non ting tontamon?” Ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Oro Grik kantrima amna au yu ihorocgon bongono morö acacha Yerusalem ebung. ");
INSERT INTO yuw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tongo yu Filipot engmuya inogung, “Amna moröma, nonu Yesu ac acha ebamon.” Filip yu Galili amna, yuhon böcsano woi Betsaida. ");
INSERT INTO yuw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ihoroc inuya Filip yu Andruot ongo Grik amnahon matano inogoc. Inuna amna yaima yu kondonggon ongga Yesu inogomoroc. ");
INSERT INTO yuw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tuna Yesu yu mata urago ingoroc iban imogoc, “Nochon bongono urop eng fomtac. Amnahon Manano yu urop youpno tun bödeuna ma moröma sogiangoc. ");
INSERT INTO yuw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nocho boinno sinom kantiwa, wit yitno yu gurocdec ohongga mamong faicma, wömai yu boinno mafii ino tunguhogon engoc. Wohong worocho gurocdec ohongga omong faunai wömai yu dogo köngga boinno koböcma fiangoc. ");
INSERT INTO yuw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Worochon torocgon wömai amna au yu gurochon itonggongo ding fing akep tontacma yuhon itonggongno wömai gorong ongungoc. Wohong amna au yu guroc ngorochon itonggongnoha me imontacma yu wömai itonggong koing aun feangoc. ");
INSERT INTO yuw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nochon youp amnanai yu muyu nakagon nan tongitnung. Ihoroc tongo naka engotan woce wömai youp amnanai yu ihorocgon itnahing. Tuya nochon Nandöngnaho yu ma moröma imangoc.” ");
INSERT INTO yuw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesu yu mata sakaun fiuna yogoc, “Nocu nanga fatfat toup tongga irotna mep tongga itac. Worocha nocu dönac ingoroc yontathu nuhun: ‘Nandöng gocho mepmo nocdec öngkup öngkupha tacma wo öcang nampi’, ihoroc yontathu? Woi muno sinom. Nocho mepmo wo sumbot sumbotha guroc ngocin ebot. ");
INSERT INTO yuw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nandöngna, gakain irot kombic kombic guroc ngocin koing soun, o gakain ma moröma itun.” Yesu yu mata ihoroc yun bödeuna momdecma duc inggun auho ingoroc öngkuboc: “Nakain irot urop koing sac. O nocho wönggon kiapmo au toya nakain ma moröma engoc.” ");
INSERT INTO yuw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Duc ingguro ihoroc yuna owi amna woce idungma yu ginonogon kombingmuya auho yogung, “Undip mano yac,” o auho yogung, “Muno, sum yaru auho yu mata intac.” ");
INSERT INTO yuw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Owi amna ihoroc yuya Yesu yu inogoc, “Mata worocho wömai nakaha mayoc muno, woi sontha yac. ");
INSERT INTO yuw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Urop Kopotorochon irot kombic kombic koing songga yu guroc owi amnahon matano yun bödehac. Tongo yu gurochon amna moröma dogu kopot yu taruna ongungoc. ");
INSERT INTO yuw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Amnaho noc ep goröcdec tu fadang uuna nuya nocho owi amna ambarac wodiaya nocot epnahing.” ");
INSERT INTO yuw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesuho kiap tingtingno omong faangocma owi amna tong indac indacha mata wo yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ihoroc yuna owi amnaho kombiuya angit maidina mata urago ingoroc iban imogung, “Kopotorochon nongoru matadec ingoroc embadidamon: ‘Duic yui iditnoho iditno edengoc.’ Oro tingtinga gocu yaroc, ‘Amnahon Manano ep goröcdec tu fadang öangoc.’ Amnahon Manano woi numa sinom?” ");
INSERT INTO yuw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ihoroc yuya Yesuho inogoc, “Yagunoho bongono docutnohagon sonot ida yaguno möng kamangoc. Worocha sonu yaguno möngga itacan itongonung. Kumbongo kaun weicyit. Amna kumbongnon itongontacma yu nahe ongungotno wömai makombic. ");
INSERT INTO yuw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yagunoho sonot idina son muyu wo kombing tobing imarut. Tongga wömai sonu yagunohon weni manani öngkupnahing. Mit wömai kumbong engoc.” Yesu mata wo yongbödengga owi amna dongyun faunto wönggon eran maitonggoc. ");
INSERT INTO yuw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Oro Yesu yu momphon toroc kiap ihono ihono koböcma tuna owi amnaho wo yangbödegung mahong koböcmaho yu makombing tobing imogung. ");
INSERT INTO yuw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Worocha wömai Aisaiaho yong tuctuc mata yogocma worocho boinno ongkuböc. Aisaiaho wömai osuc ingoroc yogoc, “O Moröma, owi amnaho nonthon mata makombing tobigung. Yu momphon toroc kiap orongi yagung mahong me nimogung.” ");
INSERT INTO yuw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Oro Aisaiaho owi amna foro yaha Yesu makombing tobing imogungma worochon yong tuctuc mata au ingoroc irim togoc: ");
INSERT INTO yuw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kopotorocho tuna owi amna dan komni simbang öngkubung. O irot kombic kombicno woi foctongbödegoc. Worocha tongga yu dan foric tang mahong yapmu au angtangtang mating. O irotnoho matahon foro tuctugo makombing. Tuctugo kombinggai wömai yu irotno ibaruya nocho yu dongya orokup.” ");
INSERT INTO yuw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia yu Yesuhon toroc kiapmo inobarac wo osuchagon angdengga yong tuctuc mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Oro owi amna koböcma Yesuha me imogung mahong au wömai yu kombing tobing imogung. O ihorocgon amna dugo auho Yesuha kombing tobing imogung mahong yu Farisiha botongmuya kombing tobic tobicno eran mayong tangidung. Yu “Farisiho non Yuda nanohon fatmata yocyoc bucin niruya ongoninyit” yongo kombic kombicno öp sigung. ");
INSERT INTO yuw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yu wömai ‘amnaho fat tong nimarut’ yongo toup kombingidung worocha yu Kopotorocho yangamin ma moröma sogit sogitha youp morö matongidung. ");
INSERT INTO yuw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu yu mata ecnang yongo yogoc, “Amna au yu nocha kombing tobing namontacma yu wömai Nandöng nanong muuna ebotma yu ihorocgon kombing tobing imontac. ");
INSERT INTO yuw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","O ihorocgon amna au yu noc foring nahacma yu woi Nandöng nanongmuuna ebotma yu ahac. ");
INSERT INTO yuw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nocho owi amna yaguno möng imoc imocha gurocdec ngocin ebot. Worocha tongga owi amna noc kombing tobing namontangma yu wömai kumbongnon maitning. ");
INSERT INTO yuw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Wohong owi amna au yu nochon mata kombingga masumbodidang. Yu wömai nocho mangsoworeit. Nocu guroc owi amna soworec soworecha maebot. Muno, nocho owi amna wömunodecma öcangya muuya Kopotorocha fogit fogitha ebot. ");
INSERT INTO yuw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wohong owi amna noc me namongidangma yuhon mata yun bödec bödec amna wömai itac. Woi nocho mata kanogotma worocho wömai mit bongono bödec bödecane son kangsoworeuna gorong ongbödenahing. ");
INSERT INTO yuw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","“Nocu nakain irot kombic kombicna tanmaina mata au makanong-idot. Muno sinom, Nandöngna nanongmuuna ebotma yu ‘mata woroc yoi’ o ‘mata kiap ihorocnodec yoi’ yongo fandat nanuna yongitat. ");
INSERT INTO yuw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nocu kombihat, Nandöngnahon matanoho non idit itonggong koinghon sadec ningat fongungoc. Worocha tongga nocho Nandöng-naho mata nanogocma worocgon kanongitat,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Oro urop bongono morö ‘Pasowa’ worochon forosicsicno idina Yesu yu kombigoc, yu guroc ngo imun fauna Nandöngot onggongon bongono worocho urop engfom togoc, ihoroc kombigoc. Yesu yu guroc ngocin itmuna irot basi sinom tongmuna inoin owi amnaniha toup kombingidocmaho kombing idtohongitac. ");
INSERT INTO yuw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Oro kumbong diuna Yesuot youp amnaniot yu suran tongo nacno nongga idung. Bongono wocin wömai dogu kopotho urop Yudas Iskariot ‘Yesu ayampho oburodec sihi’ inongo irotno sakang imogoc. ");
INSERT INTO yuw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Tuna Yesu yu kombigoc, ‘Nandöngnaho manomano ambarac nochon obunadec fingdup togoc. Tuna nocu ibara fauna Kopotoroc nanong muuna ebotma yuot ongöngot.’ ");
INSERT INTO yuw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ihoroc kombingmuna nacno doun fauya idongga tec tohomun-möcno ubarago wo asanto singo youp toctoc boru au sogitmuna temboc. ");
INSERT INTO yuw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tongo waga girang audec yamuc koringmun muuna forosingga youp amnanihon orungo sac tong imongga boru tembocma worocdec tong manman tong imogoc. ");
INSERT INTO yuw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ihoroc tong tongga Saimon Pitaot engkuuna Pitaho yu inongac tongo yogoc, “Moröma, gocho nochon orungna sac tarocma worocho angit maec!” ");
INSERT INTO yuw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ihoroc inuna Yesuho inogoc, “Goc önga nocho kiap ngo tong kampatma worochon foro abe makombiroc mahong mit wömai kombing tangtangtangoroc.” ");
INSERT INTO yuw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ihoroc inuna Pitaho yogoc, “Muno, gocho nochon orungna sac tirocha!” Ihoroc inuna Yesuho inogoc, “Nocho masac tong gamoyai wömai gocu nochon fat mairoc.” ");
INSERT INTO yuw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ihoroc inuna Saimon Pitaho inogoc, “Moröma ihoroc yarocmahai orungnagonu sac tirocha. Goc muyu obunahu o bicnahu wo ambarac sac tongdup tong nampi.” ");
INSERT INTO yuw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Inuna Yesuho inogoc, “Amna au godip föbo ambarac yamuc gupgupyi yu wömai wönggon yamuc maguic. Muno yu orungogon sactontac, godip föbo ambaracno wömai urop sacsago itac. O sonu urop sacsago idang, amna tunguhogon wömai muno.” ");
INSERT INTO yuw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu yu ino ayamihon oburodec sicsic amna urop kombingdegocmaha wömai yogoc, ‘Amna tungugon sacsago maec.’ ");
INSERT INTO yuw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Oro Yesu yu youp amnanihon orungo sac tongdup tongga wönggon tecno tohomunmucno ubarago tohomun muuna omoc itmuna youp amnani ingoroc inong ac tongo yogoc, “Sonu nocho kiap tong kampatma worochon foro kombianga woha muno? ");
INSERT INTO yuw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Sonu nocha fandat fandat amna orin Moröma noni ihoroc nanongidang. O son wo boinno nanongidang, nocho woroc itat. ");
INSERT INTO yuw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Oro nocu Moröma soni orin fandat fandat amna soni itat mahong nocho son mongorec tong kamongo orung soni sactong kampat. Worocha tongga sonu ihorocgon nuc sonihon orungo sac tun tun tong imongitnung. ");
INSERT INTO yuw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Noc ‘sontho kiap ihorocnogon tongitnung’ yongo mongorec tong imoc imochon toroc kiapmo ngo tong kindaat. ");
INSERT INTO yuw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","“Nocho boinno sinom kantiwa, youp wabkaracho morömano manggiradidang, muno yui morömanohon unennegon ididang. O ihorocgon amna morömaho youp wabkaracno inong muuna ongontac. Tuna youp wabkaracho amna moröma wo manggiraic. ");
INSERT INTO yuw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Oro, nocho mongorec toctochon foro ngo tong kindahat. Toya sonu kiap ihoroc-nogon tongmuya itongitnung. Tuya Kopotorocho guramno sonidec sing kamangoc. ");
INSERT INTO yuw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Oro nocho son ambaracha mayot. Muno nocu amna nakain fat soworegotma kombing impat, noc sonthagon yat. Kombiarut, Kopotorochon bapiyadec mata irim toctocyi idangma worocho ambarac boinno ongkupnahing. Auho wömai ingoroc yac: ‘Amna nocot nacno kondong nahacma yu ibanmuna ayam tong namontac.’ ");
INSERT INTO yuw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Oro yapmu worocho abe maöngkui idina nocu osuchagon kanongdehat. Toya mit yapmu wömuno worocho boinno öngkuunai wömai sonu kombinahing, Amna Kopotorocho inong muuna ebocma woi noc naka itat. ");
INSERT INTO yuw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","O au son ingoroc kombiarut, amna au yu nochon youp amnanaiha oröc tong imontacma yu wömai nocha oröc tong namontac. O nocha oröc tong namontacma wömai Nandöngna nanong muuna ebotma yu ihorocgon oröc tong imontac,” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu yu mata ihoroc yongbödengga irotnoho kombiun mep tuna ingoroc yogoc, “Nocho boinno sinom kantiwa, sonidecma tunguho wömai noc ayamnaihon oburodec siantac.” ");
INSERT INTO yuw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yesuho ihoroc yuna youp amnaniho kombingga ‘numaha yac’ yongo nucno foring yaun tongmuya irot köboc köboc kombing tonggung. ");
INSERT INTO yuw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ihoroc tongmuya youp amna au yu Yesu tan ambehecgon omoc idoc. Amna woi Yesuho yuha toup sinom kombingidocma woroc. ");
INSERT INTO yuw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Yu woce idina Saimon Pitaho bigoho toroc tong imongga inogoc, “Gocho Moröma inong ac toi, numaha sinom yac?” ");
INSERT INTO yuw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ihoroc inuna youp amna worocho bigo Yesuhon kundurodec tongmuna inongac tongo yogoc, “Moröma goc numaha yaroc?” ");
INSERT INTO yuw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Inuna Yesuho inogoc, “Nocho nacno docno ngo sogitmaina yamucdec ta gac fiuna amna au imontatma yu worocha yat.” Ihoroc inongga nacno docno sogitmuna nacno yamucdec tun gac fiuna Saimonthon manano Yudas Iskariot yu imogoc. ");
INSERT INTO yuw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Imuna Yudas yu nacno docno woroc sogiuna wohogon dogu kopotho engga irotnon ohogoc. Tuna Yesuho Yudas inogoc, “Goc ongmina kiap toctocha kombiharocma woroc karupgon toi.” ");
INSERT INTO yuw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yesuho Yudas mata ihoroc inogoc mahong youp amnaniho mata worochon foro kombing tangtang matogung. ");
INSERT INTO yuw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Auho wömai kombigung, Yudas yu möneng koding angtorengidocmaha Yesuho yu yong moröc bongonohon manomano wöcwöcha inong muhac. O auho kombigung, Yudasho owi amna urocima möneng imocimocha ongeyac, ihoroc kombigung. ");
INSERT INTO yuw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Oro Yudas yu nacno docno sogito wohogon idongga taitdec ohogoc. Tuna sa kumbong digoc. ");
INSERT INTO yuw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas yu ongdengina, oro Yesuho youp amnani ingoroc inogoc, “Urop Kopotorocho Amnahon Mananohon youp tong koing tuna yu ma moröma ino yabitno sogitdehac. O Mananoha tongga Kopotorochon irot koing suna yuhon ma moröma onoce sinom itac. ");
INSERT INTO yuw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","O Mananoha tongga Kopotorochon ma ino yabitno onoce entacanu wömai yu Mananohon ma ihorocgon tong koing tuna onoce sinom entac. Oro kiapmo worocho wömai urop öngkup öngkupha tac. ");
INSERT INTO yuw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Nakain Managumbocnai, nocu sonot bongono docutnohagon itmaina ongontat. Ongoya sonu nocha yabinahing mahong nocho ongga entatanu woce wömai sonu angit mangoning. Nocu mata wo Yuda nano urop inogot. O önga wömai nocho mata worocgon son kantat. ");
INSERT INTO yuw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Nocho nongoru wego ingoroc kantiwa: Nocho sontha toup kombingitat iho wömai sontho nuc soniha toup kombiun kombiun tongo itongitnung. ");
INSERT INTO yuw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Son toroc kiap ihorocnodec itonguyai wömai owi amna ambaracho sonthon toroc kiap soni wo angga kombinahing, boinno sinom sonu nochon youp amnanai sinom idang.” ");
INSERT INTO yuw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yesu ihoroc yongbödeuna Saimon Pitaho yu inong ac tongga yogoc, “Moröma, goc nahe ongontaroc?” Yuna Yesuho matano ökene ingoroc iban imogoc, “Nocho ongontatan sa woce wömai gocu önga angit mangiroc. Wohong mit wömai gocu noc nan tongungoroc.” ");
INSERT INTO yuw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ihoroc inuna Pitaho wönggon inogoc, “Moröma, foro yaöha sinom wömai nocho önga goc magan tongit? Nocho wömai ‘gocha’ yongo itonggongna ima faantac.” ");
INSERT INTO yuw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ihoroc inuna Yesuho inogoc, “Goc itonggonga imi faantachu munohu? Nocho boinno sinom gantiwa, fup mano abe mayi idina gocu bongo anfi nocha möp yongga yontaroc, ‘Nocu yu makombing imot.’” Yesuho Pita ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu yu mata sakaun fiuna wönggon youp amnani ingoroc inogoc, “Son irot mepmep tongga kombingbanac toninga. Son Kopotoroc kombing tobing imarut. O nocha woi ihorocgon kombing tobing namarut. ");
INSERT INTO yuw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nandöngnaho bucin wömai böc irotno koböcma idang. Ihoroc maidinai noc mata ingoroc makanam. Nocho sa woce ongmaina sonthon idit böc soni tong arangarang tangot yo. ");
INSERT INTO yuw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nocho ongmaina sonthon idit sa tong arangarang tangot. Tongo nocho wönggon ibara fauna engmaina son fogiaya non ambarac nocho iditatan wocegon kondong itnahamon. ");
INSERT INTO yuw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Sonu nocho sadec onggongon uyap urop kombingdeang.” ");
INSERT INTO yuw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yesu ihoroc yuna Tomasho inogoc, “Moröma, gocu sa nahe ongontarocno woi nonu makombimon. Worocha wömai nonu tingting sinom woce onggonghon uyap kombingo ongonam?” ");
INSERT INTO yuw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ihoroc yuna Yesuho inogoc, “Uyap ogepma orin toroc kiap boinno orin itonggong koing woroc woi noc naka. Nandöngot onggongon uyap au maec. Muno sinom, uyapu noc tungugon. ");
INSERT INTO yuw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Sontho noc boinno kombing namonggahai wömai son Nandöngna ihorocgon kombing imup. Wohong önga forosingga sonu Nandöng kombing imontang. O sonu Nandöng urop angdeang.” ");
INSERT INTO yuw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ihoroc yuna Filipho Yesu inogoc, “Moröma, goc Nandöng nindaiya kombinaya irot noni bödehun.” ");
INSERT INTO yuw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ihoroc inuna Yesuho inogoc, “Filip, nocu urop bongono ubarago sinom sonot iditat mahong gocu noc abe makombing namorochu yo? Amna au yu noc nahacma yu wömai Nandöngna ahac. Gocu tingtinga sinom ‘Nandöng nindahi’ yongga yaroc? ");
INSERT INTO yuw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nandöngot nocot nodu irot tungu idamot. Nandöngnaho nocot iditac o nocu Nandöngnaot iditat. Gocu wo makombirochu nuhun? Nocho mata kanongitatma woi nakain kombic kombicha mayongitat. Muno, Nandöngnaho nocot itmuna youpno tuna nocho mata yongitat. ");
INSERT INTO yuw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Son muyu kombing tobing namarut, nocot Nandöngnaot nodu irot tungu, nocho yuot iditat o Nandöngnaho nocot iditac. Oro mata woho sonthon irodin angit maidinai wömai sontho nochon youp tongitatma wo yaarut. Nocho momphon toroc kiap inobarac sinom tongidot. Sonu worocha kombingmuya kombing tobing namong-itnung. ");
INSERT INTO yuw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nocho boinno sinom kantiwa, nocho momphon youp gesöbarac tongidot. Worocha tongga owi amna ambaracho nocha kombing tobing namontangma yu wömai youp ihorocnogon tongitnahing. O worocgon muno, nocho Nandöngnaot ongontatmaha tongga yu wömai nocho youp tongidotma wo yanggirada inobarac sinom tonahing. ");
INSERT INTO yuw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Boinno sinom, sonu yapmu manomanoha nochon madec dönac yuyai wömai nocho worochon torocgon tangot. Kiap ihorocnoha tongga Mananoho Fanohon ma tong koing tuna moröma engoc. ");
INSERT INTO yuw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sonu manomano ambaracha nochon madec dönac nanuyai wömai nocho worochon toroc kamangot.” Yesu yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Oro Yesuho mata sakaun fiuna ingoroc yogoc, “Sonu nocha toup kombiantanganu wömai son nochon duc sumbentang. ");
INSERT INTO yuw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tuya nocho Nandöngna dönac inoya yuho tongfat kec soni au kamangoc. Worocho wömai sonot engmuna iditnoho iditno soniot edengoc. ");
INSERT INTO yuw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tongfat kec soni wo wömai Kopotorochon foro kanong tuctuc tongo mata boinnogon yong kamangoc. Yu woi Kunkun Yaru. Guroc owi amna yu wömai Kunkun Yaru daroho mangidang o irotnoho makombingidang. Worocha tongga yu wo masogitning. Wohong sonu yu urop kombing imang. Yu woi soniot iditac. O yuho wömai sontho irodin ohongga woce edengoc. ");
INSERT INTO yuw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nocho son dongya fauya sonu managumboc ungano simbang maitning. Muno nocu wönggon sonot ehangot. ");
INSERT INTO yuw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nocho bongono docutnogon guroc ngocin edeya mit wömai owi amnaho noc wönggon mananing mahong sonu wömai noc nanahing. Nocho itonggongna wönggon sogitmaina idtongungot. Worocha tongga sonu ihorocgon itonggong soni au feuna itong tongonahing. ");
INSERT INTO yuw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Oro bongono wocin wömai sontho kombingbödenahing, Nocu Nandöngnadec iditat o sonu nocdec ididang o nocho sondec iditat. ");
INSERT INTO yuw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Oro owi amna ambaracho nochon nongoru sogit akep tongmuya sumbodidangma yu wömai nocha toup kombingidang. O Nandöngnaho wömai owi amna nocha toup kombingidangma yuha ihorocgon toup kombingitac. O nocho wömai ihorocgon amna worocha toup kombingmaina inong tuctuc toya yu nochon forona tuctugo sinom kombingbödeangoc.” ");
INSERT INTO yuw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yesuho ihoroc yongbödeuna, Yudas, woi Yudas Iskariot muno amna au, yu Yesu inong ac tongga inogoc, “Moröma, gocho gakain foro nonihagon tuctugo ninoc ninocha yaroc, foro yaha gocho foroya guroc owi amna ambaracha maindairoc?” ");
INSERT INTO yuw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ihoroc yuna Yesuho matano ökene ingoroc iban imogoc, “Amna auho nocha toup kombinggai wömai yu nochon mata sumbengoc. Tuna Nandöngnaho amna worocha ihorocgon toup kombingga yuot nocot kondonggon engmadeina yuhon irotnon iditahamot. ");
INSERT INTO yuw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wohong amna au yu nocha makombingitacma yu wömai nochon mata fodiangoc. Boinno sinom nocho mata ngo kantatma woi nakain mata muno, Nandöngna nanong muuna ebotma yuho nanuna kantat. ");
INSERT INTO yuw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nocho soniot itmaina manomano ngo fandat kanotma. ");
INSERT INTO yuw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Oro mit wömai tongfat kec soni Kunkun Yaru yu engmuna manomano ambarachon foro yong fandat kanangoc. O ihorocgon manomano nocho fandat kanongidotma wo tun fusun diuna maedet kamic. Kunkun Yaru wömai Nandöngnaho nochon madec siuna ehangoc. ");
INSERT INTO yuw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nocu son dongya fauya ongontat mahong nocho irot gucna kamoya sonot edengoc. Irot gucna ngomai guroc owi amnaho borongdedidangma worochon toroc muno. Sonu kombingbanac toninga, o sonu botoninga. ");
INSERT INTO yuw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Nocho ingoroc kanoya kombigung, nocu son dongya fauya ongungot. Tongo nocho wönggon ibara fauna ehangot. Oro son nocha toup kombinggai wömai sonu borongdeup. Yaha nocho Nandöngot ongöngot. Nandöngna yu wömai noc nanggirada moröma sinom itac. ");
INSERT INTO yuw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Oro manomano ngomai abe maöngkungidina nocho urop kantat. Mit boinno öngkuya sonu angmuya kombinahing, ‘yu boinno ninogoc’ ihoroc kombinahing. ");
INSERT INTO yuw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Oro urop guroc ngorochon morömo dogu kopot yu epac. Worocha tongga nocho mata koböcma wönggon makanit. Yuho noc ayam tongnampac mahong noc tohoc tohochon gesöno maitimoc. ");
INSERT INTO yuw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Guroc owi amna ambaracho ingoroc kombinahing: Nocho Nandöngnaha toup kombingitat. Tongo noc yuho mata nanonitacma worochon torocgon youpna tongitat.” Yesuho ihoroc yongbödengga mit youp amnani inogoc, “Idongga sa ngo imana fauna ongona.” ");
INSERT INTO yuw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesuho youp amnani ingoroc inogoc, “Wain ephon foro boinno woi noc naka. O Nandöngna yui wain ön worochon morömo. ");
INSERT INTO yuw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tuna betomoho boinno mafiunai wömai Nandöngo wo mangga fonyun ongidang. O betomoho boinno ogepma fingidangma wo wömai Nandönho tobiuna boinno koböcma sinom finahing. ");
INSERT INTO yuw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Oro sonu nochon mata sumbodidangmaha tongga sonu urop sacsago itbödeang. ");
INSERT INTO yuw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ep betomoho epdec mading fiicma, yu wömai boinno mafiic. Worochon toroc wömai sontho nocdec mading fininganu wömai son ihorocgon boinno angit mafining. Son muyu nocot ding fingga idiya o nocho sonot ding fingga edengot. ");
INSERT INTO yuw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Wain epu woi naka o wain ephon betomo woi son. Amna au nocot ding fiunai wömai nocho yuot ding fiaya boinnono koböcma fiangoc. Wohong sontho noc imu fauna soni sing yapmu au ogep matoning. ");
INSERT INTO yuw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Amna nocdec mading fiicma yu wömai betomo boinno muno woroc simbang. Nandöngnaho yu mangga fonyun onguya onggom suya epdec fongyu onguya sonahing. ");
INSERT INTO yuw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Wohong son nocdec ding fingmuya nochon mata sogida kokoreuya irot sonidec idinai wömai son yapmu auha kombingga dönac yuya worochon torocgon öngkung kamangoc. ");
INSERT INTO yuw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Öngkung kamuya sontho boinno soni koböcma fingmuya nakain youp amnanai sinom itnahing. Worocha tongga Nandöngnahon youp koing suna yuhon ma moröma engoc. ");
INSERT INTO yuw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Nandöngna yu irot basi sinom. Yu irot tong fup tong namongitac. O worochon torocgon wömai nocho sontha irotna tong fup tong kamongitat. Worocha sonu nakaot ding fingga idarut. ");
INSERT INTO yuw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nocho Nandöngnahon youp mata sumbot bödehatmaha tongga yuho nocha toup kombingitac. O worochon torocgon wömai sontho nochon nongoru sumentanganu wömai sontho nakaot ding fingo itnahing. ");
INSERT INTO yuw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nandöngnaho irot ogep moröma sinom noc namuna borongdehat. O nocho sontha ihorocgon nakain irot ogep kamoya ‘borongdetno sinom tarut’ yongo mata ngo kantat. ");
INSERT INTO yuw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Oro, nochon nongoru wömai ingoroc: Nocho sontha toup kombingitatma worochon torocgon sonu nuc soniha toup kombingitnung. ");
INSERT INTO yuw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Amna inoin itonggongno nucniha imun faantacma yu wömai irot basi sinom nucniha irot tong fup tong imontac. ");
INSERT INTO yuw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","O sontho nochon duc sumbotmuyai wömai sonu nochon oröcnai sinom itnahing. ");
INSERT INTO yuw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Osuc nocho son youp amnanai ihoroc kanongidot mahong ihoroc wönggon makanit. Youp amna yu wömai morömanohon irot kombic kombic tuctugo makombingidang. Wohong Nandöngnaho mata nanogocma wo wömai nocho ambarac son kanongbödeaya kombingidang. Worocha nocu sontha oröcnai ihoroc kanontat. ");
INSERT INTO yuw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Oro sontho noc masoworegung, muno noc wömai ‘sontho nochon youp tongmuya boinno fiarut’ yongo soworegot. Sonu boinno fiuya worocho bongono muno edengoc. Tongo sonu ‘Nandöng yapmu au nimpun’ yongo nochon madec dönac inuyai wömai yu worochon torocgon kamangoc. ");
INSERT INTO yuw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Oro, nochon nongoru ngomai ingoroc, son muyu irot tong fup nucno imun gamun tongga itongitnung.” Yesuho youp amnani ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesuho mata sakaun fiuna ingoroc yogoc, “Guroc owi amnaho son ayam tong kamuyai wömai son kombingitnung, osuc omocene yu nocha ayam tong namogung. ");
INSERT INTO yuw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Son guroc ngorochon toroc kiap taruyai wömai guroc ngorochon owi amnaho oröc tong kamup. Wohong sonu guroc ngorochon fat maeng. Muno, nocho ‘son nakain fat idarut’ yongo guroc owi amnahon bonipnodecma erangdegot. Worocha tongga guroc owi amnaho son ayam tong kamongidang. ");
INSERT INTO yuw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Nocho urop kanogot, youp wabkaracho morömano maanggirat-ning. Guroc amnaho osuc noc wöntucmuno tong namogung. Worocha mit wömai yu sontha ihorocgon wöntucmuno tong kamonahing. O yu osuc nochon mata kombing tobigungan wömai mit yu sonthon mata ihorocgon kombing tobinahing. Sonu mata worocha edet kamicha. ");
INSERT INTO yuw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Guroc amnaho amna nanong muuna ebotma yu makombing iming. Worocha tongga yu nochon mana kombingga ayam tong kamonahing. ");
INSERT INTO yuw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Oro nocho yuot engmaina fatmata ogepma mainoyai wömai yuhon tong bumbumnohon main. Wohong nocho yuot engmaina fatmata ogepma inogotmaha tongga yuhon turongono idimangoc. ");
INSERT INTO yuw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Amna au yu nocha ayam tong namontacma yu wömai Nandöngna ihorocgon ayam tong imontac. ");
INSERT INTO yuw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nocho yuhon bonipnodec itmaina momphon toroc kiap inobarac sinom matoyai wömai yuhon tong bumbumno main. Wohong nocho yuhon bonipnodec itmaina momphon toroc kiap moröma sinom toya yu yangga nocha ayam tongnampi Nandöngna ayam tongimpi ihoroc tongidung. ");
INSERT INTO yuw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yu kiap wo tong namogungmaha tongga Kopotorochon bapiyadec mata irim toctocyi itacma worocho boinno öngkupac. Ingoroc itac: ‘Yui noc foro muno ayam tong namogung.’ ");
INSERT INTO yuw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Oro, nocho Nandöngnaot öngmaina sonthon tongfat kec soni siaya ehangoc. Yuho Nandöngot itmuna engga nochon foro son kanong tuctuc tangoc. Yui imanang mayongitac muno yui mata boinnohon fano. ");
INSERT INTO yuw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Oro, nocho youp forosigotan ongga bödec bödecnodec wömai sontho nocotgon ididung. Worocha tongga sontho owi amna nochon fatmata ogepma inong fandat tongitnung. ");
INSERT INTO yuw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Oro noc ‘sontho gorong ongoningyit’ yongo mata wo kanot. ");
INSERT INTO yuw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Suraroho wömai son fatmata yocyoc bucinma karuya ongonahing. O mit bongono au öngkuuna owi amnaho ‘Kopotorochon youp tona’ yongo kot omom tonahing. ");
INSERT INTO yuw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yui Nandöngnahu o nakahu makombing nimingmaha tongga yu toroc kiap wömuno ihorocno tong kamonahing. ");
INSERT INTO yuw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Oro noc osuc sonot kondonggon ididomonmaha nocho toroc kiap worochon yongburoc mata abe makanogot mahong nocho son urop dongya faantangmaha tongga nocho önga worochon garac mata ngo kantat. Tuna mit toroc kiap wontucmuno ihorocnoho sondec öngkung kamuyai wömai sonu kombinahing, ‘Yesuho osuc ninogocma worochon torocgon öngkung nimpac,’” ihoroc yogoc. Yesuho mata sakaun fiuna youp amnani ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Noc urop Nandöng nanong muuna ebotma yuot ongontat mahong sondecma auho noc nanongac tongga ingoroc mananoc: ‘Gocu nahe ongon-taroc?’ ");
INSERT INTO yuw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nocho önga mata mepmo ngo kanoya irot soniho toup mep tocno sinom tac. ");
INSERT INTO yuw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Wohong nocho boinno sinom kantiwa, nocho son tongfat keckecha son dongya fauya ongontat. Nocho mangoyai wömai tongfat kec soni yu sonot maehic. Worocha nocho öngga yu inong muaya yu sonot ehangoc. ");
INSERT INTO yuw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yuho engmuna guroc owi amna inong tuctuc tong imuna yu kombinahing, ‘non turongobarac idamon,’ o yu kombinahing ‘Kopotorocho yaö youp tuna non nongnongo öngkupnam’ o ihorocgon yu Kopotorochon mata youpdec idithon foro wo tuctugo kombinahing. ");
INSERT INTO yuw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Guroc amnahon turongohon foro moröma wömai ingoroc: Yu nocha makombing tobing namongidang. ");
INSERT INTO yuw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","O Kopotorochon nongnongo kiaphon foro wömai ingoroc: Kopotorocho nochon youp tong koing tuna nocho yuot ongontat. Ongoya sonu noc wönggon mananing. ");
INSERT INTO yuw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","O Kopotorochon mata youpdec idithon foro wömai ingoroc: Kopotorocho urop guroc ngorochon morömo dogu kopot yuhon matano yun bödeuna möpmo yudec sigoc. ");
INSERT INTO yuw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Oro, nocho son mata koböcma kanoc kanocha kombihat mahong sonu mata woroc kombic kombicha abe maarangarang ying. ");
INSERT INTO yuw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Wohong mit wömai Mata Boinnohon Kunkun Yaru engmuna fasun kamuna sonu manomano wo kombingbödenahing. Yu wömai inoin kombic kombic tanda mata au mayic. Muno, Kopotorocho yu mata inuna kombingga worocgon kanangoc. Yu wömai toroc kiap mit öngkupnahingma worochon yong tuctuc matano kanangoc. ");
INSERT INTO yuw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yuho nochon mata sogito tengga yong tangtang kanuna tuctugo kombi-nahing. Worocha tongga nochon ma moröma engoc. ");
INSERT INTO yuw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nandöngna-hon manomano woi ihorocgon nochon manomano. Worocha tongga nocho ingoroc kanot, yui nochon mata sogitho tengga yong tangtang kanangoc.” ");
INSERT INTO yuw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu yu wönggon mata sakaun fiuna ingoroc yogoc, “Bongono docutnohagon idina sonu noc mananing. O mit wönggon bongono docutnohagon idina sonu nanahing.” ");
INSERT INTO yuw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ihoroc yuna youp amnani auho inogon mata inun ganun tongo yogung, “Yesuhon matanohon foroi tingting oro. Yuho yac, ‘Bongono docutnohagon idina sonu wönggon noc mananing,’ o ‘mit bongono docutnohagon idina sonu wönggon noc nanahing.’ O ihorocgon yuho yac, ‘Noc Nandöngot ongöngot’ oro nonu mata worochon foroi tuctugo makombimon.” ");
INSERT INTO yuw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Youp amani yu mata koböc koböc ihoroc yong tongga wönggon yogung, “Bongono docutnoha yacma worochon foro tingting sinom? Nonu yuhon mata tuctugo makombimon.” ");
INSERT INTO yuw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ihoroc yongga idiya Yesuho irotnon yangga ingoroc inogoc, “Sonu nochon matahon foroha mata koböc koböc yongöang. Nocu yot, ‘Bongono docutnohagon idina son noc mananing. O mit bongono docutnohagon idina sonu wönggon noc nanahing.’ ");
INSERT INTO yuw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Oro nocho boinno sinom kantiwa, guroc owi amna yu borongdeda itnahing mahong sonu yong ointoc tongga yong uroc yongga itnahing. Irot soniho wömai mep tangoc mahong irot mepmep soni worocho wömai ibaruna borongdetnahing. ");
INSERT INTO yuw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“Kombiarut, managumboc bacbachon bongono fom tuna wömai owiho focfoc kombingmuya irot mepmepdec ididang. Wohong managumboc urop öngkuunai wömai yu focfoc worocha wönggon makombining. Muno, yu managumboc angmuya borongdedidang. ");
INSERT INTO yuw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","O worochon torocgon wömai son kombing tobic tobic owi amna sonu guroc ngocin ihorocgon irot mepmepdec ididang. Wohong nocho wönggon ehangotan bongono wocin wömai sonu kombing borong morö tonahing. O borongdetdet soni wömai amna auho maöcaic. ");
INSERT INTO yuw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Bongono wocinu wömai sontho noc yapmu auha nanong-ac matoning. “Nocho boinno sinom kantiwa, sonu nochon madec yapmu auha Nandöng dönac inuyai wömai yuho wo boinno sinom kamangoc. ");
INSERT INTO yuw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Osuc wömai sonu nochon madec yapmu auha dönac mayongidung. Worochoi mit sonu dönac yongo worochon toroc sogitnahing. Tongo borongdetdet soniho irot sonidec foc tongga engoc,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesuho mata sakaun fiuna wönggon ingoroc yogoc, “Nocho manomano mata tagarogon fandat kanongidot mahong mit nocho mata erangon kanoya sonu Nandöngnahon foro tuctugo kombingbödenahing. ");
INSERT INTO yuw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Bongono wocin wömai son sonibut nochon madec Nandöngha dönac inonahing. Nocho ‘Nandöngnaho tongfat kehun’ yongo sontha dönac yongitatma wömai bödeangoc. ");
INSERT INTO yuw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Sontho nocha toup kombingidang. O sonu kombing tobiang, Nandöngnaho noc nangmuuna ebot. Worocha tongga Nandöngnaho sontha ihorocgon toup kombihac. ");
INSERT INTO yuw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nocho Nandöngot itmaina yu ima fauna gurocdec ohogot. Oro önga wömai nocho guroc ngo ima fauna wönggon Nandöngot öangot.” ");
INSERT INTO yuw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yesuho ihoroc yongbödeuna youp amnaniho ingoroc inogung, “Oro urop, gocu mata tagarodec mayoroc. Goc yong tangtang sinom yongo nintaroc. ");
INSERT INTO yuw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Worocha nonu kombia-mon, gocu manomano ambarac kombingbödeharoc. Nontho abe goc yapmu auha ganong ac mati iditnaya gocu urop irot noni kombing-bödeharoc. Worocha non kombiamon, gocho boinno sinom Kopotorocot itmina eboroc.” ");
INSERT INTO yuw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ihoroc yuya Yesuho mata ökene ingoroc iban imogoc, “Sonu öngai kombing tobing namang mahong ");
INSERT INTO yuw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","urop mepmo bongono eng fom tac. Bongono worocho ehuna ayamoho son karuya möngga tangga woce woce böc sonin sonin ongbödenahing. Tongo sontho noc imu fauna naka tungugon engot. Wohong nocu nakagon sinomu mait. Muno Nandöngna yu bongono muno nocot iditac. ");
INSERT INTO yuw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Oro sonu nocot ding fingga irot gucno idarut. Worocha nocho yong fasun mata ihoroc kantatma. Kombiarut, gurocdec ngocin wömai mepmo foro ihono ihono worocho sondec öngkung kamuya botongitnahing. Wohong son botoninga. Nocho guroc ngorochon gesö wontucmuno urop anggiratbödegot,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Oro Yesu yu youp amnani mata wo inongbödengga momdec foringmun uuna dönac ingoroc yogoc, “Nandöngna, nochon bongono urop engfom tac. Worocha gocu Manamahon youp tong koing tongga ma moröma impi. Ihoroc tia Manama yu gochon youp tun bödeuna gochon irot kombic kombic koing sontac. ");
INSERT INTO yuw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Goc ‘Manamaho owi amna ambarachon Morömo itun’ yongo yu gesö moröma imogoroc. Worocha tongga Manamaho owi amna gocho soworeng imogorocma yu itonggong koing ogep imangoc. ");
INSERT INTO yuw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","“Oro idit itonggong koinghon foro wömai ingoroc: Goc tunguho Kopotoroc Moröm boinno itaroc. Gocho Manama Yesu Duic inong muya eboc. Oro owi amna mata wo kombing tobingidangma yu wömai itonggong koingbarac idang. ");
INSERT INTO yuw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Gocho ‘youpna tongidiruc’ yongo noc nanong muya nocho guroc ngocin engmaina youpa ta bödehac. Worocha tongga gochon irot kombic kombic ino yabitnoho guroc ngocin eran öngkupac. ");
INSERT INTO yuw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","“O Nandöng, osuchagon mom saguroc abe maöngkui idina nocot gocot kondonggon gochon idit yaguno sadec ididomot. Oro önga gocho idit kiap wairurunobaracma woroc wönggon noc namiya sogiwa.” ");
INSERT INTO yuw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yesuho dönacno sakaun fiuna yogoc, “Nandöng, nocho gochon foro gakain owi amna indaya kombiang. Yu wömai osuc guroc ngorochon fat idung mahong gocho yu inong yia yu nochon torop öngkubung. Gocho yu osuchagon ‘nakain torop itnahing’ yongo soworengdegoroc. Soworeng imia yu gochon mata sumbotmuya nakain torop öngkubung. ");
INSERT INTO yuw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Tuna gocho yong tuctuc mataya nania nocho wo ambarac yu inongbödehat. Ihoroc toya kombingga yu irot yai matogung. Muno yu gochon mata kombingga kombing tobing namogung. Worocha tongga yui kombiang, nocho osuc gocot edeya goc nanong muya ebot. Tongo youp ambarac nocho tongitatma wo wömai gocho namiya tongitat. ");
INSERT INTO yuw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Oro nocho dönac ngo ‘yuhagon’ yongo gantat. Noc ‘guroc owi amna ambarac tongfat yeiruc’ yongo maganot. Muno, owi amna gocho soworeng namogorocma yuhagon wömai nocho dönac gantat. Yu woi gakain torop. ");
INSERT INTO yuw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nochon toropnai ambarac woi ihorocgon gochon toropai idang. O gochon torop idangma ambaracho wömai ihorocgon nochon toropnai idang. Owi amna torop worocho noc kombing tobing namongidang. Worocha tongga nochon youpnaho boinno fiuna noc ma moröma sogihat. ");
INSERT INTO yuw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Nocho guroc ngo urop ima faantac mahong torop wo yu gurocdec ngocin idtongonahing. Nocu urop gocot öantat. O Nandöng Kopotoroc kunkun iditarocma, gocho gakain maya nocdec sing namogoroc. Gakain maya woi gesöbarac, worocha tongga gocho torop wo tong batip tia wömunohon gesöho yu dongyun mointoninga. Tongo yuot nodiot irot tungu sinom iditnahamon. ");
INSERT INTO yuw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nocho yuot itmaina gakain mayahon gesödec yangtoreaya ayamiho madongyu moin togung. Yudecma tungu auho magorong onging. Muno amna tunguhogon wömai gorong onggoc. Amna worochon yong tuctuc matano wömai gochon bapiyadec irim toctocyi itac. ");
INSERT INTO yuw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Oro nocho urop gocot öantat mahong nocho abe guroc ngocin itmaina torop worocha dönac gantiwa. ‘Nochon borongdetdetho yuho irodin ducmoda itun’ yongo dönac gantat. ");
INSERT INTO yuw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nocu guroc ngorochon fat maet. O nochon toropnai ngo yu ihorocgon gurochon fat muno. Worocha tongga nocho gochon fatmata ogepma yu inoya guroc amnaho yu ayam tong imongidang. ");
INSERT INTO yuw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nocho dönac gantatma woi ‘gocho toropnai gurocdec öcangyi möarut’ yongo maganot, muno ‘yu guroc ngocin idiya gocho tong batip tong imongidiruc’ yongo dönac gantat. Dogu Kopotho yu doun moin toningyit. ");
INSERT INTO yuw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nocu guroc ngoroc-hon fat muno worocha yu ihorocgon guroc ngorochon fat maeng. ");
INSERT INTO yuw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gakain mata woi boinnogon. Tongo worocho yuho irotnon itmuna macfiuna yu gochon kunkun owi amna iditnung. ");
INSERT INTO yuw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Gocho noc guroc ngocin siiya ebot. Tuna worochon torocgon wömai nocho yu inong muaya saguroc danong ongbödenahing. ");
INSERT INTO yuw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nocho ‘yu kunkun itnung’ yongo nakain itonggongna gocha bogihat. Tongo yu gochon torop itmuya inoin itonggongno ihorocgon gocha boginahing.” ");
INSERT INTO yuw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Yesuho dönac wönggon sakaun fiuna yogoc, “Nocho yuhagon dönacna ngo maganot. Muno, owi amna ambaracho yuhon fatmata kombingga noc kombing tobing namonahingma yu ambaracha wömai dönac ngo gantat. ");
INSERT INTO yuw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","‘Yu ambaracho irot tungu iditnung’ yongo kombihat. Gocho nocdec iditaroc o nocho gocdec iditatma, worochon toroc yuho ihorocgon nodiot idiya irot tungu iditnahamon. Ihoroc idiya guroc owi amnaho yu yangga ingoroc kombinahing: Boinno, gocho nanong muya ebot. ");
INSERT INTO yuw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Gocho gakain gesö moröma noc namogoroc. Tia nocho nakain gesö owi amnanai imogot. Worocha tongga yu irot tungudec itnahing. Gocot nocot irot tungu ididamotma worochon toroc yuho iditnung. ");
INSERT INTO yuw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nocho yuot edeya o gocho nocot iditaroc. Toroc kiap worocdec wömai yuho irot tungudec itonguya guroc owi amnaho yuhon toroc kiapmo ogepma yangmuya kombinahing, boinno sinom, gocho noc nanong muya ebot, o gocho irot basi sinom tongmina yuha toup kombingitaroc, gocho nocha toup kombingitarocma worochon toroc. ");
INSERT INTO yuw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“O Nandöng Kopotoroc, gocho owi amna namogorocma yu wömai ‘nocot kondonggon nocho itongungotan itongonung’ yongo dönac ngo gantat. Yu nocot ida nochon yaguno wairuru irimnobarac woroc aarut yongga kombihat. Guroc abe maöngkui idina gocu nocha toup kombingga ma moröma namogoroc. ");
INSERT INTO yuw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“O Nongnongo Nandöng Kopotoroc, guroc owi amnaho goc makombing gaming. Wohong nocho wömai goc kombing gampat. O nochon toropnai yu kombiang, gocho noc nanong muya ebot. ");
INSERT INTO yuw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Tuya ‘yu gochon foro kombiarut’ yongo nocho yong tuctuc mata yong fandat inongidot. O ‘gocho irot tong fup tong namongitarocma kiapmo ihorocnogon yudec itun’ yongo nocho gochon foro inong tangtang tong tongungot. Tongo noc nakabut yuho irodin edengot. Woi boinno,” Yesu yu dönac ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu yu dönac woroc yongbödengga, ino ot youp amnaniot sa wo imu fauna ohongmuya Kidron yamuc okonda gino ökenne ögung. Sa wocin wömai oliv ön au idoc. Tuna yu woce onggung. ");
INSERT INTO yuw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Oro, Yudas, Yesu ayamphon oburodec sicsic amna, yu kombigoc, Yesuot youp amnaniot yu ön wocegon suran tongidung. ");
INSERT INTO yuw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Worocha tongga yu Römphon tawa amna orin amna morömahon youp wabkarac au yu yangada sa woce fonggoc. Tawa amna woroc wömai öret socsoc böchon amna dugo orin Farisi yu inong muya Yudasot onggung. Tawa amna yu wömai lam orin gop o emochon manomano woroc fogitmuya ön woce onggung. ");
INSERT INTO yuw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Onguya Yesu yu osuchagon kombingdegoc, kiap ihoroc ihoroc nocdec öngkung namontac. Worocha tongga yu ongga tawa amna uyapdec yaun feuya inogoc, “Sonu numaha yabiang?” ");
INSERT INTO yuw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Inuna yu yogung, “Nonu Yesu Nasaretma worocha yabing tebamon.” Inuya Yesuho inogoc, “Nocu ngoroc.” Yudas yu wömai ihorocgon tawa amnaot wocin idoc. ");
INSERT INTO yuw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesuho ‘nocu ngoroc’ ihoroc inuna wohogon amna torop ebungma yu metecgon ongga gurocdec mögung. ");
INSERT INTO yuw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tuya Yesu yu wönggon inongac tongo yogoc, “Sonu numaha yabiang?” Inuna yuho yogung, “Yesu Nasaretma.” ");
INSERT INTO yuw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ihoroc yuya Yesuho inogoc, “Nocu urop kanotmai, nocu ngoroc yo. Sontho nochagon yabianganu wömai amna ngo yang banauya ongorut.” ");
INSERT INTO yuw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Oro Yesuho mata woroc yogocmaha tongga yu mata osuc yogocma worocho boinno öngkuboc. Yu wömai ingoroc yogoc, “Nocu yu ogepma sinom yangtoreaya yudecma tungu auho magorong onggoc.” ");
INSERT INTO yuw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tuna Saimon Pita yui gopit bainat au sogit tonggoc. Tongo yu gobit woroc wodingmun uuna öret socsochon amna dugo yuhon youp wabkaracno wodoc. Wuna gobitho youp wabkarachon onggimo aroce saringmun mögoc. Youp wabkarac worochon manoi Malkus. ");
INSERT INTO yuw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pita ihoroc tuna Yesuho inogoc, “Urop, gobit wo böcnodec ohetmi muhun. Tingting oro? Goc ‘Nandöngnaho focfoc youp namogocma wo nocho mata bödeic’ yongo kombiharochu?” Yesu Pita ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Oro mit tawa amna torop worocho Yesu sogitmuya yiho feto sigung. ");
INSERT INTO yuw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tongo yu Anasot yangat tonggung. Anas yu wömai Kaiyafashon körano. Kaiyafasho wömai biruc worocho öret socsoc böchon amna dugo moröma idoc. ");
INSERT INTO yuw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","O Kaiyafas yu wömai osuc Yuda nano amna morömahon surandec ingoroc yogoc, “Amna tunguhogon suraro ambarachon abam sogida ompun,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Oro tawa amnaho Yesu sogito tonguya Saimon Pita orin youp amna nucno auho yu tanto tonggomoroc. Tunya youp amna nucno wo yu öret socsoc böchon amna dugo kombing imongidoc. Worocha tongga owi simbu angtoregocma yu kombing imuna amna dugohon gombo ganang ögoc. ");
INSERT INTO yuw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Yu inohogon onguna Pita yu gombo sumonne simbu tan wocin torengga idoc. Tuna Pitahon nucno öret socsoc böchon amna dugo kombing imogocma yu bongono docutnogon gombo ganang itmuna ibarun fauna engga owi simbu angtoregocma yu mata au inuna angit idina Pita yangauna gombo ganang ögomoroc. ");
INSERT INTO yuw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ihoroc tuna owi simbu angtoregocma yu Pita angmuna inogoc, “Gocu amna worochon youp amna au itarochu nuhun?” Ihoroc inuna Pitaho möp yongo yogoc, “Ei, nocu yuhon youp amna muno yo,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tuna, sa sumfadocmaha tawa amna orin amna morömahon youp wabkarac yu ep tobing songga songgontho idiya Pita yu ihorocgon yuot kondonggon wocin ida ep songgondung. ");
INSERT INTO yuw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Oro yu ep songgonda idiya öret socsochon amna dugo yu Yesu inoin youpha orin youp amnaniha inong ac togoc. ");
INSERT INTO yuw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Inong ac tuna Yesuho mata ökene ingoroc iban imogoc, “Nocho owi amna erangon fandat inongidot. Bongono bongono nocu Yuda nanohon fatmata yocyoc bucinthu o öret socsoc bucinthu surarodec yong fandat inongidot. Toya suraro ambaracho nochon mata erangon kombingidung. Nocho mata au öp mayongidot. ");
INSERT INTO yuw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Worocha goc yaha noc nanong ac taroc? Goc muyu owi amna nochon mata kombigungma worochong inongac toi. Yuho wömai nochon mata kombingbödeang.” ");
INSERT INTO yuw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesuho ihoroc yuna tawa amna au ambehecgon idocma yu Yesu mogumodec woda inogoc, “Gocu öret socsochon amna dugoha gending imongo mata kiap ogepmagon inti.” ");
INSERT INTO yuw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ihoroc yuna Yesuho inogoc, “Nocho mata kandoc mayot. Kandöc yoyai wömai tobing nampi. Wohong nocho mata boinno yatanu wömai yaha notaroc.” Ihoroc inuna ");
INSERT INTO yuw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","mit Anasho yuna tawa amnaniho Yesu sogida öret socsochon amna dugo Kaiyafas yuot tonggung. Oburo yiho fedungma wömai maasan imogung. ");
INSERT INTO yuw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Oro Saimon Pita yu ep songgontho idina amna auho yu inong ac tongga yogung, “Yuhon youp amna au goc ngorochu?” Ihoroc inuya yui möp yongo yogoc, “Ei, nocu muno yo.” ");
INSERT INTO yuw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ihoroc inogoc mahong amna morömahon youp wabkarac au Pitaho onggimo saringmun mögocma yuhon toropdecma yu Pita tonguc imongo yogoc, “Nocho gagotmai, gocu amna worocot öndec idomoroc.” ");
INSERT INTO yuw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ihorocc inuna Pita yu wönggon möp yuna wohogon fup amnanoho mano yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Oro sa isoc isocane Yuda nanoho Yesu yangada Kaiafashon böc imu fauna ongga Römphon gavman amna moröma Pailat yuho bucin tonggung mahong bucin wömai manggung, yaha Yuda nanohon gendicho wömai Pasowa bongonodec bumbumyi nanoho bucin önggönga muno yogoc. Worocha tongga yu ‘Pasowa nacno mananingyit’ yongo böc amantegon torengga idung. ");
INSERT INTO yuw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Woce idiya amna moröma Pailat yu böcno imun fauna yuot ohongmuna inong ac tongga inogoc, “Sonu foro yaha amna ngo mata youpdec tohong yucyucha tang?” ");
INSERT INTO yuw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ihoroc inuna yuho inogung, “Komananga gocot mayangat tepnam, yu wöntucmuno toctoc amna.” ");
INSERT INTO yuw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ihoroc inuya Pailatho inogoc, “Muyu son sonibut gendic soni tanmuya yuhon matano angsoworearut.” Inuna Yuda nanoho yogung, “Muno, nontho amna au wot omom toctochon bongbong itac,” ihoroc inogung. ");
INSERT INTO yuw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ihoroc yogungmaha tongga Yesu inobut yaö kiapdec omengoc-mahon yong tuctuc mata yogocma worocho boinno öngkuboc. ");
INSERT INTO yuw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Oro Pailat yu wönggon gavmantho bucin öngmuna Yesu inong yuna uuna ingoroc inong ac togoc, “Goc boinno Yuda nanohon king itarocha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ihoroc inuna Yesuho inogoc, “Gakabut kombingga mata wo yarocha woha amna auho ganuya yaroc?” ");
INSERT INTO yuw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Yuna Pailatho inogoc, “Tingting oro, nocu Yuda amna muno. Gakain toropai orin öret socsochon amna dugo yu nocot gangat tebang. Worocha goc tuctugo nanti, gocu wontucmuno yaö sinom togoroc?” ");
INSERT INTO yuw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yuna Yesuho mata ökene ingoroc inogoc, “Nocu mom midim sabarac sahon Morömo itat. O midim sabarac sana woi guroc ngorochon fat muno. Guroc ngorochon idinai wömai youp amnanai ‘Yuda nanoho noc sogit akep toninga’ yongo emoc tup mahong nochon idit sa woi guroc ngorochon fat maec.” ");
INSERT INTO yuw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ihoroc inuna Pailatho kiringga wönggon inogoc, “Gochon saha yarocma wömai gocu worochon king itarocmaha yarochu?” Yuna Yesuho inogoc, “Boinno sinom yaroc, nocu king au. Macnaho noc bauna guroc ngocin ebotma worochon foro wömai ingoroc, noc muyu mata boinno yong tangtang yoya suraroho kombinung. Kopotorochon owi amna yu wömai mata boinno kombingga nocha kombing tobing namongidang.” ");
INSERT INTO yuw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Yesuho ihoroc yuna Pailatho yogoc, “Mata boinno wo yaö?” ihoroc yongo ibarun fauna wönggon Yuda nano ot taitdec ohogoc. Pailatho Yuda nano ot ohongmuna inogoc, “Nocho yuhon tong bumbum au maat. ");
INSERT INTO yuw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kombiarut, toroc kiap noni ingoroc itac: Biruc danong Pasowa bongonodec wömai sonibut yuya worochon toroc nocho yi bucinma amna au angbanaaya orung ongitac. Worocha son ‘numa asan ongoun’ yongo kombiang, Yuda nanohon king ngorochu nuhun?” ");
INSERT INTO yuw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ihoroc inuna Yuda nanoho ecnang sinom yogung, “Yu muno, Barabas orung sing nimpi,” ihoroc mambodung. Barabas yu wömai Römphon gavman ayam tong imongo nucni yangauna gavmanot emoc togung. ");
INSERT INTO yuw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Oro Pailatho tawa amna inuna yu Yesu sogida tosipdec wodung. ");
INSERT INTO yuw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Woroc tongo yu yi dirongoni fogida banggem ekonda worocho kinghon tec kutkut simbang tongmuya Yesu bigodec tohomu möngimogoc. Tongga mit tec tohomunmöcno gomono kinghon toroc tohomumöng imogoc. ");
INSERT INTO yuw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ihoroc tongga Yesuot ongmuya yong kumec imanang imanang inongga yogung, “Sep ogep Yuda nanohon king.” Ihoroc bongo koböc tongmuya yangamodec wodung. ");
INSERT INTO yuw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tuya Pailat yu wönggon taitdec ohongga owi amna ingoroc inogoc, “Kombiarut, nocho yuhon tong bumbum au maat. Worocha nocho yu wönggon soniot taitdec yangat tohontat.” ");
INSERT INTO yuw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ihoroc yuna Yesu yu yi dirongobarac orin tec tohomunmöcno gomono tohomu möng imocimocyi worocbarac taitdec ohogoc. Woroc tuna Pailatho owi amna inogoc, “Amna ngo, yu aarut.” ");
INSERT INTO yuw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ihoroc yuna öret socsochon amna dugo orin youp wabkaracni yu Yesu angga wohogon ecnang mamboda yogung, “Ep goröcdec ompun! Ep goröcdec ompun!” Ihoroc mambuya Pailatho inogoc, “Sontho sonibut yu sogitmuya ep goröcdec wagango siarut. Nocho yuhon tong bumbum au maat.” ");
INSERT INTO yuw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ihoroc yogoc mahong Yuda nano yu kiringga mata firing tanda inogung, “Yu nongoru noni yembodoc, yu inoha yogoc ‘nocu Kopoto-rochon Manano’ worocha tongga yu muyu ompun,” ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailatho mata woroc kombingga toup botogoc. ");
INSERT INTO yuw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Botongmuna wönggon gavmantho bucin öngga Yesu inongac tongga yogoc, “Goc böca nahema?” Ihoroc inogoc mahong Yesu yu mata worochon ökene au mainogoc. ");
INSERT INTO yuw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tuna Pailatho inogoc, “Kombiharoc, gang banac banachon gesöhu o ep goröcdec got omom toctochon gesö woi noc itnampac. Worocha goc mata urago iban nampi.” ");
INSERT INTO yuw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ihoroc inuna Yesuho inogoc, “Kopoto-rocho gesö magamunahai wömai gocho noc not omom toctochon gesöya main. Worocha gochon turongo woi obugu mahong amna noc sogida gochon oburadec sigungma worochon turongo wömai moröma.” ");
INSERT INTO yuw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailatho mata woroc kombingga Yesu angbanac banacha kombigoc mahong Yuda nanoho toup kiring imongga mamboda inogung, “Amna wo yu inoha yogoc, ‘noc king’. Amna inoha ihoroc yongidangma yu wömai Sisa King worochon ayami. Worocha tongga gocu amna wo angbanaiya ongontacanu wömai gocu Sisahon amna muno.” ");
INSERT INTO yuw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat yu mata woroc kombingga soroc yongo Yesu yangada teboc. Tongo inoho mata angsoworec soworec amnahon omoc idit abamdec omoc idoc. Böc tait worochon mano wömai ‘sop tait’ ihoroc yongidung, Hibru matadec wömai ‘Gabata’ ihoroc. ");
INSERT INTO yuw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Oro sep youp toctoc bongono wocin wömai Israel nanoho Pasowa nacnohon manomano tong arangarang tongidung. Tongo sep bongono 12 kilok ihoroc idina Pailatho Yuda nano inogoc, “King soni ngo aarut.” ");
INSERT INTO yuw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ihoroc inuna yuda nano yu koreng tongga ecnang sinom mambodung, “Taruya ongoun! Taruya ongoun! Ep goröcdec ompun!” Ihoroc mambuya Pailatho yogoc, “Sonthon king soni yu ep goröcdec ompun? Son ihoroc kombiang?” Ihoroc yuna öret socsochon amna dugoho inogung, “Nonthon king woi Sisa yu tungugon, king noni au maec.” ");
INSERT INTO yuw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yuho ihoroc toup kiriuya Pailat yu ‘Yesu ep goröcdec wagango siarut’ yongo yun bödeuna Yesu Yuda nanohon oburodec imogoc. Ihoroc tuna tawa amnaho Yesu sogida ");
INSERT INTO yuw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","yangat tongga ep goröc imuya Yesu inobut sumbuna taun imu fauna ongga guroc au mano bic kudat woce onggung. Sa mano ‘bic kudat’ woi Hibru matadec wömai ‘Golgata’ ihoroc yongidang. ");
INSERT INTO yuw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Sa wocin yangat tongmuya ep goröcdec wagango sigung. Woroc tongo wöntucmuno toctoc amna yai yu ihorocgon dongmuya öke sic öke sic tuya Yesu yu bonipnodec idoc. ");
INSERT INTO yuw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ihoroc tuya Pailatho yuna yu yongburoc mata au irim tongga ep goröc mondopmodec wagangmu fadoc. Matai ingoroc irim tong sigung: Yesu Nasaretma, Yuda nanohon Kingno. ");
INSERT INTO yuw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mata wo wömai Hibru mata orin Röm mata orin Grik mata ihorocho irim toctocyi idoc. Sa Yesu ep goröcdec wagango sigungma woi Yerusalem taun tan ambehecgon idoc. Worocha tongga Yuda nano koböcmaho ongi epi tongga mata wo embato ango ididung. ");
INSERT INTO yuw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ihoroc tuya öret socsochon amna dugoho kombiuya angit maidina Pailatot ongmuya inogung, “Goc ingoroc irim tirocha ‘Yuda nanohon kingno’. Muno sinom yu nonthon king noni maec. Worocha goc mata ingoroc toi: Amna ngorocho inoha yogoc, nocho Yuda nanohon king itat.” ");
INSERT INTO yuw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ihoroc inogung mahong Pailatho inogoc, “Muyu, matai urop irim tongdetmaha worochogon itun.” ");
INSERT INTO yuw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Oro tawa amna awanomuno yu Yesu ep goröcdec wagango singdengga Yesuhon boru tecno fogida docno awanomuno silip tongmuya inoin inoin fogidung. O tecno tohomunmöcno woi ihorocgon sogida agungmai boru docno tungugon idoc. ");
INSERT INTO yuw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tawa amnaho wo angga inohogon yogung, “Nonu tec tohomunmöcno ngomai mawiranin. Muno, tim kumec tongmanaina koing sontacmaho wömai sogiantac.” Tawa amnaho kiap woroc togungmaha tongga yong tuctuc mata au Kopotorochon bapiyadec irim toctocyi itacma worocho boinno öngkuboc. Ingoroc itac: “Yu nochon boru tecna fogitmuya inoha silip togung. O tec tohomunmöcnaha wömai tim kumec togung.” Oro tawa amna yu worochon torocgon togung. ");
INSERT INTO yuw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Oro Yesuhon ep goröc tane wömai inoin macno o mamno o Klopashon oweno Maria o ihorocgon Maria Makdalama yu ambarac wocin idung. ");
INSERT INTO yuw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Woce idiya Yesu yu yagocmai youp amna inoha toup kombingidocma yu wocin macno ot idomoroc. Wo angga macno inogoc, “Owi, amna ngoi gochon manama.” ");
INSERT INTO yuw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ihoroc inongga mit youp amnano wo inogoc, “Ahi, owi woi gochon maca.” Ihoroc inuna bongono worocho foro singga youp amna worocho Yesuhon macno angtorengidoc. ");
INSERT INTO yuw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Oro Yesuho kombigoc, ‘youpna ambarac bödehac’. Tongo yu ‘mata Kopotorochon bapiyadec mata irim toctocyi itacma worocho boinno öngkupun’ yongo ingoroc yogoc, “Ingguna manman yac.” ");
INSERT INTO yuw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Yesu ihoroc yuna tawa amnaho wain yamuc wö au ambehecgon wocin idocma worocdec top yat au wain yamucdec tohong siuya waintho yat worocdec foctuna tawa amna yu fondom au mano ‘hisop’ worocdec sakangga tun fadauna Yesuhon dugodec sigoc. ");
INSERT INTO yuw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tuna Yesuho wain obmugon nongga yogoc, “Urop youpna ta bödehac.” Woroc yongga bigo aring möngo omong fadoc. ");
INSERT INTO yuw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Oro sep youp toctoc bongono worocho wömai Pasowa nacnohon manomano tong arangarang toctochon bongono idoc. Tuna kembotno wömai Sabat sep bongono gendicno moröma sinom idoc. Worocha tongga Yuda nano yu kombigung, bongono morödec amnahon ep fambangnoho ep goröcdec itninga. Ihoroc kombingga yu Pailatot ongga inogung, “Tawa amnaho amna ep goröcdec idangma yuhon orungo ubuya karupgon omong fauya ep fambangno fohongga oring fiarut” ihoroc inuya ");
INSERT INTO yuw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pailatho ‘öc’ yuna tawa amnaho ongmuya osuc amna yai Yesuot kondong wagango figungma worochon orungo kudatno ubodung. ");
INSERT INTO yuw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ihoroc tongo agungmai Yesu yu urop omboc. Worocha tongga yu Yesuhon orungo maubodung. ");
INSERT INTO yuw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tawa amna auho sarupho Yesuhon tagarodec sakauna wohogon nogot orin yamucho kururuc yongidina ohogoc. ");
INSERT INTO yuw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Oro manomano ngomai imanang fatmata muno. Amna fat ngo irim togocma yu inoin daroho manomano wo ambarac yangbödegoc. Tongo ‘son ambaracho Yesuha kombing tobing imarut’ yongo mano-mano ngo irim togoc. ");
INSERT INTO yuw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Oro manomano wo öngkubocma woi ‘Kopotorochon bapiyadec mata irim toctocyi idangma worocho ambarac boinno öngkungdup tonung’ yongo foro worocha öngkubung. Mata au ingoroc irim toctocyi itac: “Yuhon kudatno au maubotning.” ");
INSERT INTO yuw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","O mata au irim toctocyi itacma woi ingoroc: “Yu wömai amna sakang imogungma yudec dan foric tonahing.” ");
INSERT INTO yuw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Oro amna au mano Yösep yu Arimatea taunma. Yu woi ihorocgon Yesu kombing tobing imongidoc mahong yu Yuda nanohon amna morömaha botongidocmaha tongga yu kombing tobic tobicno öp singidoc. Oro Yösep yu ‘Yesuhon ep fambangno sogida tongowa’ yongo Pailat inong ac togoc. Inong ac tuna Pailatho ‘öc’ yuna yu ep fambang wo sogida tonggoc. ");
INSERT INTO yuw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Woroc tuna amna Nikodemus yu Yösepot kondonggon onggomoroc. Nikodemus yui osuc kumbong Yesuot ongmuna manomanoha inong ac togoc. Oro Nikodemus yu marasin tugo ogepma mano ‘mir’ orin marasin au mano ‘aloe’ woroc mongorec tongo tomboda sogida teboc. Tomno worochon mepmono wömai 30 kilogram worochon toroc idoc. ");
INSERT INTO yuw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Oro amna yai yu Yuda nanohon toroc kiap tanda Yesuhon ep fambangno sogitmunya marasin tugoni woroc wagang imongmunya boruho tombot imogomoroc. ");
INSERT INTO yuw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ep goröc ambehecgon wömai ön au idoc. Tuna woce wömai ‘amna tohong sicsichon’ sop ganango au idoc. Sop ganango wocin wömai amna au abe matong sicsicyi kunkun idoc. ");
INSERT INTO yuw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Oro Yuda nanohon gendic sephon bongono urop engfom togocmaha tongga amna yai yu Yesuhon ep fambangno sumboda sop ganango ambehecgon idocmaha wocin tohong sigomoroc. ");
INSERT INTO yuw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Oro Sönda kembotsumgon sa abe maurang möngbödengidina Maria Makdala bucinma yu kumkumon ongga agocmai sop moröma ganango böngo foc togocma worocho urop ibanmun onguna ganango fagarida idoc. ");
INSERT INTO yuw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Woroc angga ibarun fauna dom-domgon Saimon Pita orin youp amna au Yesuho yuha toup kombigocma yuot ongmuna inogoc, “Kombiarut, yu Morömahon ep fambangno kumkumonma sogida tongga sawoce tonggung. Nocho yu tohong sian angtaa matac.” ");
INSERT INTO yuw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mariaho ihoroc yuna wohogon Pita orin youp amna nucno yu böc wo imun fauna kumkumon onggomoroc. ");
INSERT INTO yuw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Yui yait yaitgon domdomgon onggomoroc mahong youp amna nucno worochogon Pita anggirada osuc kumkumon ongkuboc. ");
INSERT INTO yuw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tongo yu sop ganangodec mangii komanang aring möngga foringga agocmai boru ep fambangno tomboto sigungma worochogon idoc. ");
INSERT INTO yuw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Wo angga idina Saimon Pita yu ihorocgon engkungmuna sop ganango ohongga auna boruhogon wömai idoc. ");
INSERT INTO yuw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Boru au Yesuhon bigo tomtongo sigungma worocho wömai mumbot mumbotyi aram ökenne worochogon idoc. ");
INSERT INTO yuw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tuna youp amna osuchagon kumkumon engkubocma yu ihorocgon sop ganango ohongmuna manomano woroc yangmuna kombing tobigoc, ‘Yesu yu boinno sinom omocdecma idonggoc’, ihoroc kombigoc. ");
INSERT INTO yuw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bongono wocin wömai youp amnani yu Yesuho kumkumonma wekongga idonggongon mata Kopotorochon bapiyadec idocma wo abe kombing tangtang matogung. ");
INSERT INTO yuw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Oro woroc yangbödengga amna yaima yu ibarun fauna böcnon onggomoroc. ");
INSERT INTO yuw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Oro, amna yai yu ongunya Maria yu inohogon sop ganango sumone itmuna yong ointogoc. Ointongo ito aring möngga ganango foringga ");
INSERT INTO yuw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","yagocmai sum yaru yai tecno föhöcno worocho Yesuhon ep fambangno idocan abam wocin omoc idomoroc. Aumaho wömai bigo idocan woce idoc o aumaho orungo idocan woce idoc. ");
INSERT INTO yuw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tongo yu Maria inogomoroc, “Owi, gocu yaha yong ointotaroc?” Yunya Mariaho inogoc, “Yu nochon Morömana sawo sogito tongingno woi noc makombit.” ");
INSERT INTO yuw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Yu ihoroc inongga ibarun fauna Yesu ino agoc mahong Maria yu ‘woi Yesu ino’ ihorocu makombigoc. ");
INSERT INTO yuw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tuna Yesuho yu inong ac tongo inogoc, “Owi gocu yaha ointaroc? O numaha yabiharoc?” Ihoroc inuna Maria yu kombigoc, amna ngoi ön worochon morömo yo. Ihoroc kombingmuna inogoc, “Oro gocho ep fambang wo sogito sa nahenne tong sirocma wo nania nocho ongga sogiwa.” ");
INSERT INTO yuw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ihoroc yuna Yesuho inogoc, “Maria.” Inuna Mariaho Yesu angtangtang tongmuna Hibru matadec inogoc, “Rabonai.” Mata worochon foro woi ‘Fandat fandat amna’ ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ihoroc inuna Yesuho inogoc, “Noc Nandöngnaot abe maötmaha noc not muirocha. Goc ongga oröcnai ingoroc inti: ‘Nocho Nandöngnaot ongontat. Nochon Nandöngna woi ihorocgon sonthon Nandöng soni o nochon Kopotorocna woi ihorocgon sonthon Kopotoroc soni. Nocu yuot öangot.’” ");
INSERT INTO yuw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ihoroc inuna Maria Makdala bucinma yu ibarun fauna youp amnaniot ongmuna inogoc, “Kombiarut, Moröma urop nocho aat.” Tongo yu Yesuho mata inogocma woroc ambarac inongbödegoc. ");
INSERT INTO yuw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Oro sep youp toctoc sönda worochon dobocsisicnodec sep daro urop ohong gorop wuna Yesuhon youp amnani yu suran togung. Yu wömai Yuda nanoha botongmuya buc simbu ambarac songo akep tongga idung. Ihoroc idiya Yesu yu bonipnodec öngkung imongga inogoc, “Irot soni gucno itun.” ");
INSERT INTO yuw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yu ihoroc inongga oburo biringo wagagungma orin tagaro sarupho sakagungma wedec dipmo woroc indagoc. Tuna youp amna yu Morömo angmuya irotnoho toup borongdedung. ");
INSERT INTO yuw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tuna Yesu yu wönggon inogoc, “Irot soni gucno itun. Nandöng-naho noc nanong muuna ebot. Tuna worochon torocgon nocho son kanong muaya son saguroc danong ongonahing.” ");
INSERT INTO yuw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ihoroc inongga duc mönno busuna youp amnanidec onguya inogoc, “Son Kunkun Yaru sogiarut. ");
INSERT INTO yuw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Sontho owi amnahon turongono dongyu fatnahinganu wömai turongono bödeangoc. O sonu owi amnahon turongono madongyu fatninganu wömai yuhon turongono woi idimocgon tonahing.” ");
INSERT INTO yuw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Oro Yesuho youp amnani öngkung imogocan bongono wocin wömai Tomas yu yuot kondong maidoc. Tomas yu youp amnani 12decmahon torop tungu au. Yuhon mano auma Didimus, ihoroc yongidung. ");
INSERT INTO yuw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Oro youp amna nucniho fat tongga yu inogung, “Moröma yu öngkung nimuna aamon.” Ihoroc inuya Tomas yu irot yai tongo inogoc, “Nocu nakabut dannaho oburodec biring wagaima dipmo angga obunaho wot möngga o ihorocgon tagarodec sarupho sakaima dipmo wot möantatanu wömai noc kombing tobiantat. Maanggai wömai makombing tobiit,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Oro, sep youp toctoc 7 bödeuna Sönda idina Yesuhon youp amnani yu wönggon suran tongga böc ganang idung. O Tomas yu ihorocgon wocin idoc. Woce itmuya böc simbu ambarac sopsopyi idung mahong Yesu yu bonipnodec wocin öngkung imongo inogoc, “Irot soni gucno idarut.” ");
INSERT INTO yuw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ihoroc yongga Tomas inogoc, “Goc engmina obura siragoho obuna dipmodec not möngga ahi, o ihorocgon taganadec not möngga kombihi. Goc irot yai tirocha. Goc muyu kombing tobing nampi.” ");
INSERT INTO yuw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tuna Tomasho inogoc, “Nochon Morömana o nochon Kopotorocna woi gakagon.” ");
INSERT INTO yuw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ihoroc yuna Yesuho wönggon inogoc, “Goc naharocmaha kombing tobing namparoc mahong owi amnaho noc manaihong kombing tobing namonahingma yu wömai boinno sinom borongdearut.” Yesu yu Tomas ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu yu toroc kiap ihono ihono koböcma sinom tuya youp amnaniho yagung mahong nocu bapiya ngorocdec ambarac irim matongbödegot. ");
INSERT INTO yuw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nocho mata ngo irim togotma wömai ‘sontho woroc embatmuya Yesuha kombing tobing imongitnung’ yongo irim togot. Yesu yu woi boinno sinom Kopotorochon Manano. Sonu yuha kombing tobing imongo yuhon madec itonggong koing au feangoc. ");
INSERT INTO yuw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Oro worochon menon wömai Yesuho youp amnani Galili yamuc öngköring tan woce wönggon öngkung imogoc. Worochon fatno wömai ingoroc: ");
INSERT INTO yuw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, o Tomas mano au Didimus, o Nataniel Kana taun Galili distrikdecma, o Sebedihon mananin yai, o ihorocgon Yesuhon youp amnanin au yai yu ambarac kondong itmuya ");
INSERT INTO yuw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pitaho yu inogoc, “Nocu söng yabic ongontat.” Ihoroc inuna amna auho yogung, “Oro nonu ambarac kondonggon ongontamon.” Ihoroc yongga girangdec bangmu uuntho ongidiya urop doboc sigoc. Tuna kumbong worocho söng tungu sahano yongo au masogidung, muno sinom. ");
INSERT INTO yuw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ihoroc itongga idiya sa isuna yu agungmai amna au yamuc öngköring tero sonorocdec idoc. Amna wo woi Yesuho idoc mahong youp amnani yu angtangtang matogung. ");
INSERT INTO yuw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tuna Yesuho mamboda inogoc, “Oröcnai, sonu söng au fogianga muno?” Ihoroc inuna youp amnaniho ‘muno yo’ inogung. ");
INSERT INTO yuw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","‘Muno’ inuya Yesuho inogoc, “Son umben girang arocne tömu muuna söng au fogiantang.” Ihoroc inuna youp amnani worochon toroc umben tömu muuna mayain, söng koböcma sinompho umben ganang ohongga idiya woding töctöcha tu matogoc. ");
INSERT INTO yuw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tuya youp amna Yesuho inoha toup kombingidocma yu Pita inogoc, “Ngoi Moröma noni ino sinom!” Saimon Pita mata woroc kombingga wohogon tecno tohomunmöcno youpha asan sigocma wo tohomun muuna akep tongo yamucdec bangmun muuntho ongga terodec ögoc. ");
INSERT INTO yuw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tuna youp amna au yu girangdecgon engga umben söngni wodic wodicho tebung. Yu woi korungon sinom maitonggung. Yamuc öngköring terodec 100 mitahon toroc ihoroc idung. ");
INSERT INTO yuw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Yu eng tengga tero öngmuya agungmai ep au dingga idina morocnodec wömai söng au orin nacno sowarango au idung. ");
INSERT INTO yuw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ihoroc idiya angga Yesuho inogoc, “Son söng fogiangma woroc au febarut.” ");
INSERT INTO yuw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ihoroc inuna Saimon Pitaho girangdec bangmun uuna umben woding tuna sonorocdec idoc. Umben ganang söngo foc tocno sinom togung. Woi söng morömagon 153 ihoroc idung mahong umbenu madogidoc. ");
INSERT INTO yuw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tuna Yesuho inogoc, “Son engmuya nacno naarut.” Ihoroc inogoc mahong youp amnani yu nanga fatfat tongmuya ‘goc numa yo’ ihoroc inong ac toctocha botogung. Yu urop kombigung ngoi Moröma ino. ");
INSERT INTO yuw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tuna Yesuho engmuna söng orin nacno sowarango wo fogida silip tongo imuna nagung. ");
INSERT INTO yuw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Oro, Yesu yu omoc-decma wekongga itongga youp amnani öngkung imuna bongo anfi idoc. ");
INSERT INTO yuw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Oro yu nacno nongbödeuya Yesuho Saimon Pita ingoroc inong ac togoc, “Saimon, Jönthon manano, kombihi, youp amnanai yu nocha kombingidang mahong gocdec tingting, gocu yu yangirada nocha toup sinom kombiharocha woha muno?” Ihoroc inuna Pitaho mata urago ingoroc iban imogoc, “Moröma gaka kombiharoc, nocu gocha toup kombingitat.” Ihoroc inuna Yesuho inogoc, “Gocu nochon bot sipsip gumbocnai nacno imongidiruc.” ");
INSERT INTO yuw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tongo Yesuho yu wönggon inong ac tongo inogoc, “Saimon Jönthon manano, gocho nocha boinno sinom kombiharocha muno?” Yuna Pitaho inogoc, “Öc Moröma, nocho gocha toup kombihatno wömai gocu urop kombingdeharoc.” Ihoroc yuna Yesuho inogoc, “Goc nochon bot sipsipnai moröm tong imongmina yangtorehi.” ");
INSERT INTO yuw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Oro Yesuho wönggon inong ac tuna bongo anfi idina inogoc, “Saimon, Jönthon manano, gocu nocha toup kombiharocha woha muno?” Ihoroc inuna Pitaho irot mep togoc. Yaha Yesuho bongo anfi sinom ‘goc nocha toup kombiharocha muno’ ihoroc inogocmaha irotno mep tuna inogoc, “Moröma, gocu manomano ambarac kombingbödeharoc. Worocha gocu urop ingoroc kombiharoc, nocu gocha toup kombingitat.” Ihoroc yuna Yesuho inogoc, “Gocho nochon bot sipsipnai nacno imongidiruc. ");
INSERT INTO yuw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nocho boinno sinom gantiwa, goc amna berac itmina gaka uyap onggonha tong arangarang tongga gakain ibiba tanmina sa nahe nahe itongidoroc. Wohong mit wömai goc basi deya obura ti fadang uuna amna auho tongfat geuna sa gocho onggonga makombirocan woce gangato tongöngoc.” ");
INSERT INTO yuw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesuho mata tepmo ihorocno inogocma woi ‘Pitaho Kopotoroc ma morö imocimocha yaö kiapdec omong faangoc’ yongo yogoc. Oro, mit Yesuho Pita inogoc, “Gocho noc nari.” ");
INSERT INTO yuw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ihoroc inuna Pitaho metec foringga agocmai youp amna Yesuho toup kombingidocma yu menongon tan tonggoc. Osuc kumbong imu nacno nagungan bongono wocin wömai amna worocho bigo tongga Yesuhon kundurodec singga inongac tongo yogoc, “Moröma numa sinompho wömai goc ayampho oburodec siantac?” ");
INSERT INTO yuw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Oro youp amna worocho yu tan tonguna Pitaho angga Yesu inogoc, “Moröma amna ngorochai tingting oro?” ");
INSERT INTO yuw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ihoroc yuna Yesuho inogoc, “Nocho kombiaya angit idnai wömai yu ogep guroc ngocin itong tongidina ongga nocho wönggon ehangot. Woi gochon manomano muno. Gocu noc nari.” ");
INSERT INTO yuw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Oro Yesu mata ihoroc yogocmaha tongga kombing tobic tobic surarodec sum mata ingoroc öngkuboc: “Youp amna worocho mamong faic.” Wohong Yesuho yuha mata ingorocu mayogoc ‘yu mamong faic’. Muno, yui ingohong yogoc, “Nocho kombiaya angit idinai wömai yu ogep guroc ngocin itong tohongidina ongga nocho wönggon ehangot. Woi gochon manomano muno,” ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Oro Yesuho youp amnaha mata wo yogocma amna worocho sinom wömai manomano Yesuho tongidocma wo angbödeuna boinno idiya irim togoc. Worocha tongga nonu kombiamon, yuho mata bapiya ngocin irim togocma woi ambarac boinnogon. ");
INSERT INTO yuw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu yu guroc ngocin itongmuna manomano koböcma sinom tongidoc mahong worochon fatno ambarac wömai bapiya ngocin maeng. Amna auho Yesu manomano ambarac tongidocma worochon fatno ambarac irim tongdup tunai wömai bapiya koböcma sinom öngkuuya guroc ngocin bapiya worochon bego angit main. ");
INSERT INTO yuw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Sep ogep Tiofilus, nocho urop bapiya au irim tongo siaya gocot onggoc. Bapiya wocin wömai noc Yesuho youp tongidocma orin fatmata ogepma fandat ninongidocma worochon fatno ambarac irim togot. ");
INSERT INTO yuw_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Woi Yesu öngkubocan ongga Kopotorocho yu wönggon sogito momdec tögocma worochon fatno ambarac nocho irim tongdup togot. Oro, Yesu yu abe guroc ngocin idocan bongono wocin wömai Kunkun Yaruho yu fasun imuna yu inoin aposelni erangga ‘youp ihono ihono tongitnung’ yongo youp mata inogoc. ");
INSERT INTO yuw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tongo mit ep goröcdec focfoc moröma kombingga omboc. Omongo wönggon wekongga aposelni öngkung imogoc. Tongo yu momphon toroc kiap koböcma tuna aposelho woroc yango tuctugo kombigung, ‘Yesu yu boinno sinom wekongga itongeyac yo.’ Oro Yesu yu sep youp toctoc 40 worochon irotnon aposelni öngkung imuna angidung. Auya Yesuho yu mom toborucnohon foro fandat inongidoc. ");
INSERT INTO yuw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Oro bongono au wömai Yesuho youp amnaniot itmuna youphon nongoru ingoroc inogoc, “Sonu Yerusalem karupgon imu faicha. Muno son wocegon torengga idiya ongga Kopotorocho Kunkun Yaru siuna sonot ehangoc. Kopotorocho osucgon son Kunkun Yaru kamoc kamocha mata godingmun fatdegoc. O noc ihorocgon yuhon yong tuctuc mata kanoya kombigung. ");
INSERT INTO yuw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jön yu owi amna yamucdec gung imongidoc mahong sonu sep youp toctoc au torengga idiya Kopotorocho Kunkun Yarudec gung kamangoc.” ");
INSERT INTO yuw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yesu yu youp amnani ihoroc inuna yu ingoroc inong ac togung, “Moröma, bongono ngocinu wömai gocho non Israel nano moröm tong nimongmina kantri noni ti koing sontacha woha muno?” ");
INSERT INTO yuw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ihoroc inuya Yesuho mata ökene iban imongo ingoroc yogoc, “Nandöng Kopotoroc yu wömai worochon öngkup öngkup bongono urop singdegoc. Woi sonthon manomano muno. ");
INSERT INTO yuw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sonthon manomano wömai woroc: Mit wömai Kunkun Yaruho sonot engmuna gesöno kamangoc. Kamuna sonu Yerusalem sae forosingga ongga Yudia gurocinthu o Samaria gurocinthu o sa guroc danong woce woce ongmuya nochon fatmata yong moröging tongonahing.” ");
INSERT INTO yuw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu yu mata ihoroc yongbödengga youp amnaniho yangamin momdec uuna mom muruc murucho yu usec tuna youp amnaniho yu wönggon magung. ");
INSERT INTO yuw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yu komanang wocin itmuya momdec onoce foringo idung. Ihoroc tuya wohogon amna yaiho yuot ebomoroc. Amna yai yu woi tec tohomumöcno föhöcno fongyun muuya engmunya inogomoroc, ");
INSERT INTO yuw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Son Galili amna, son yaha komanang sinom ngocin itmuya momdec foriang? Kombiarut, önga Yesuho son dongyun fauya momdec öc mahong mit wömai yu inohogon wönggon ibarun fauna ehangoc. Woi toroc kiap önga aangma worochon toroc yu wönggon ehangoc.” Amna yaimaho Yesuhon youp amnani ihoroc inogomoroc. ");
INSERT INTO yuw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Oro mit Yesuhon youp amnani yu sa urongo mano oliv wo imu faunto ohongga Yerusalem taun engkubung. Oliv sa urongodec ida Yerusalem taun onggongon uyap woi 1 kilomitahon toroc. ");
INSERT INTO yuw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Woce engkungmuya ongga böc osuc suran tongidungan wocin idung. Amna wocin idungmahon ma torop woi ingoroc: Pita, Jön, Jems, Endru, Filip, Tomas, Bartolömyu, Matyu, Alfiushon manano Jems, o Saimon yu wömai Selothon toropdecma, o Jemshon manano Yudas. ");
INSERT INTO yuw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Amna torop ngorocho wömai suran tongga irot tungu singga dönac youp tongidung. O ihorocgon Yesuhon macno Maria o owi au o Yesuhon orugi yu wocingon suran tongga itmuya Yesuhon youp amnaniot dönac youp tongidung. ");
INSERT INTO yuw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Oro bongono wocin wömai owi amna torop obuguhogon Yesuha kombing tobing imongidung. Yuhon nambano wömai 120 ihorocgon idung. Yu suran tongga itmuya Pitaho yuhon bonipnodec idongga mata ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Oro oröc ori kombiarut, osucgon sinom wömai Kunkun Yaruho Devithon duc tun yungan tuna yu Yudasha yong tuctuc mata au yongo yogoc, ‘Yu worocho ayami yangada Yesuot fongungoc.’ Oro mata worocho wömai boinno öngkuboc. ");
INSERT INTO yuw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas yu wömai nonthon toropdec idoc. Tongga nontho youp sogidomonma worochon toroc yu ihorocgon sogidoc. ");
INSERT INTO yuw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Amna Yudas yu wömuno togocmahon wöngnac möneng sogida guroc docno au wögoc. Ihoroc tongga yu guroc wocin ongmuna möngga modibo taboc. Tongo omuro gurocdec sorung möngga wot gapgap togung. ");
INSERT INTO yuw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ihoroc tuna Yerusalem nano ambaracho yuhon fatno kombingga sa guroc worochon mano ‘Akeldama’ ihoroc mambodung. Mata worochon foro wömai ‘nogot guroc’. ");
INSERT INTO yuw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Worochon mata wömai ap bapiyadec ingoroc yac: ‘Yuhon sa gurocno komong engoc. Amna au wocin iditninga.’ “O mata yu ingoroc irim toctocyi itac: ‘Amna auho yuhon youp docno sogihun.’ ");
INSERT INTO yuw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Oro foro worocha tongga non muyu amna au erangga yu Yudashon abam sogihun. Amna wo wömai nonu Yesuot kondong itongima yuhon bonipnodecma soworeantamon. ");
INSERT INTO yuw_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Forosingga Jöntho owi amna Yodan yamuc gungimong tehuna engga Yesuho non youn fauya momdec ögoc. Oro amna wo ambarac yangdegungma yuhon bonipnodec wömai nonu amna tungu soworenaya yu Yudashon abam sogihun. Tongo yu noniot youp kondong tongmanaina Yesuho omocdecma idonggongnohon fatmata yong moröginahamon,” Pita yu ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Yuna amna wocin idungma yu amna yai ino ot kondong itongidungma yu dongyu öngkubung. Tunguma wömai Yösep, yu mano au Barsabas yongidung. O ihorocgon mano au wömai Jastus yongidung. O amna au wömai Matias yu woroc soworegung. ");
INSERT INTO yuw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Sowo-rengga irot tungu singmuya dönac ingoroc yogung, “O Moröma, goc amna ambarachon irot kombingbödeharoc. Worocha gocho amna yai ngodecma numaha sinom kombiharoc, woroc nindahi. ");
INSERT INTO yuw_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Nindaya amna worocho Yudashon abam sogida noniot aposel youp tangoc. Yudas yu youp ngo imun fauna önggöngyinohon urago sogida sa wontucmunodec onggoc.” ");
INSERT INTO yuw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Yu dönac ihoroc yongo sop tim moruya Matiasho koing sogoc. Ihoroc tuna Matias yu aposel 11 yudec sakaun fiuya 12 idung. ");
INSERT INTO yuw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Oro Yuda nanohon bongono moröma, Pentikos worocho ehuna kombing tobic tobic suraro yu ambaracho bucin suran tongga idung. ");
INSERT INTO yuw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Suran tongo idiya karupgon sum morömahon gino koingo sinom worocho momdecma engmuna böc woroc ducmodoc. ");
INSERT INTO yuw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Foc tuna yu agungmai yapmu au ep aranggum mönbiro simbang worocho engmuna fuc tongga owi amna tungu tungu fogiddup togoc. ");
INSERT INTO yuw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ihoroc tuna Kunkun Yaruho owi amnahon irotnon ohongga foc tongo mönbiro sogito ibaruna owi amnaho forosingga mata duc inggun auhon auhon yong tonggung. ");
INSERT INTO yuw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Oro bongono wocin wömai Yuda nano koböcma sinompho kantri wohon wohondecma Kopotoroc yong moröng imoc imocha Yerusalem ebung. ");
INSERT INTO yuw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yu wocin itmuya momdecma gino kekoröp moröma engkubocma woroc kombingga ‘worochon foro ana’ yongo engga woce engsuran togung. Engsuran tongo onggim singga kombigungmai kombing tobic tobic owi amna yu duc mata inoin inoin ingurodec yong tonggung. ");
INSERT INTO yuw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ihoroc yuya kombingga soroc yocno sinom tongga yogung, “Ei owi amna ngo yu Galili nanohogon idang. ");
INSERT INTO yuw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Worocha foro tingtingnoha sinom yu duc mata nonin nonin inggundec yuya kombiamon? ");
INSERT INTO yuw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nonu ngomai Partia, Midia, Elam kantridecma ebamon. O auho Mesopotemia, Yudia, Pontus o Esia provinsdecma ebamon. ");
INSERT INTO yuw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","O au wömai Frigia o Pamfilia provinsdecma o ihorocgon Isip kantridecma ebamon. O au Libia guroc docno Sairini taun ambehecgon wocemaho ebamon. O au non Röm taundecma ebamon. ");
INSERT INTO yuw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","O au non sa muropmo Krithu o distrik Arebiadecma ebamon. Nonu au Yuda nano sinom idamon o au nonu bumbumyi nanohon toropdecma Yudananohon kombic kombic tanidamon. Non ambarac duc inggun nonin nonin yongidamon mahong torop ngo yu Kopotorochon toroc kiap moröma sinom nonin nonin duc inggundec yong tonguya nonu tuctugo kombiamon.” ");
INSERT INTO yuw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yu ihoroc yongo kombiu matuctuc yuna ingoroc yogung, “Yapmu ngo önga öngkupacma worochon foro yaö sinom?” ");
INSERT INTO yuw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ihoroc yong tongmuya auho wömai mata metec yongo yogung, “Yui wain yamuc koböcma naangmaha bumbum yongga yang yo,” ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ihoroc yuya Pitaot aposel nucni 11ot yu idongmuya Pitaho owi amna orongi ingoroc fasun imongo inogoc, “Son Yuda nano o ihorocgon son owi amna torop auhonmaho engga Yerusalem idangma, son ambaracho onggim singga nochon mata kombiarut. Nocho kiapmo fodibo önga ngo öngkupacma worochon foro kanong tuctuc towa. ");
INSERT INTO yuw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Son ingoroc kombianghu nuhun, owi amna ngo yu wain yamuc nangga bumbum yang yo. Muno sinom, sep bongonoi kembotsum 9 kilokgon itac. ");
INSERT INTO yuw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Toroc kiap ngo önga öngkupacma woi Kopotorochon yong tuctuc amna mano Yoel yu osuchagon ‘ihoroc öngkuangoc’ yongo yong tuctuc mata ingoroc yongdegoc: ");
INSERT INTO yuw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Kopotorocho ingoroc yac, Sa gurochon bödec bödecno eng fomtangocan bongono wocinu wömai nocho Kunkun Yaruna koriaya yu owi amna danong yudec ohongo ducmoto foc tong imangoc. Nocho ihoroc toya sonthon we soni mana soni yu Kopoto-rochon mata suraro inong tuctuc tonahing. O sonthon amna berac soni o amna basi soni yu duc itu tongga Kopotorochon manomano yanahing. ");
INSERT INTO yuw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nocho Kunkun Yaruna siaya yu nochon mongorec toctoc owi amnadec ohuna yu Kopotorochon yong tuctuc mata yong tongonahing. ");
INSERT INTO yuw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","O nocho toya momdec toroc kiap fodibo öngkuuya yanahing. O gurocdec wömai nocho weran inobarac dongya öngkupnahing. Weran worocho wömai nogotbarac o ep aranggumbarac öngkuuya boröc moröma öangoc. ");
INSERT INTO yuw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ihoroc tuya sepho kumbong diangoc. O yaropho gomondingga nogot kiap engoc. Ihoroc öngkungbödeuya mit wömai Morömahon bongono moröma gesönobarac sinom ehangoc. ");
INSERT INTO yuw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ehuna bongono wocin wömai Kopotorocho inoin owi amnani fogiuna batip itnahing. Woi owi amna ‘Morömaho tong fatnehun’ yongo inong yonahingma yu wömai Kopoto-rocho inoha fogiuna batip itnahing.’” ");
INSERT INTO yuw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita yu wönggon mata sakaun fiuna yogoc, “Son Israel amna, son onggim singga mata ngo kombiarut: Yesu yu sonthon bonip sonidec komanang maitongidoc. Muno sinom, Kopotorocho yuhon youp tong koing tuna yu momphon toroc kiap inobarac sinom orin weran moröma tongidoc. Kopotorocho ‘son wo yangga Yesu kombing tobing imarut’ yongo ihoroc togoc. Tuna son ambaracho Yesuhon toroc kiap inobaracma wo yangbödegung mahong ");
INSERT INTO yuw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","sonu yu sogida amna wontucmunohon oburodec siuya yu ep goröcdec wuya omboc. Wohong Kopotoroc yu osucgon ‘ihoroc öngkuangoc’ yongo yong torop singdegoc. ");
INSERT INTO yuw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sing dengo yu Yesu omocdecma tun wekongo idonggoc. Omocho yu sogido akep toctocno wömai maidoc, muno sinom. ");
INSERT INTO yuw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Oro Devit yu Yesuha yong tuctuc mata ingoroc yogoc, ‘Nocho bongono muno Morömaha kombingitat. Yu nocot itmuna tong koing tong namongitac. Worocha nocu yapmu auha mabotongitat. ");
INSERT INTO yuw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Muno, irotnaho Morömaha yong kumehat. O ducnaho yuhon yong moröng ap yongitat. Nocho boinno sinom kombihat, godip föbna wömai omentat mahong Kopotorocho noc maimun faic. Muno sinom, yu itonggong koing tun öngkung namangoc. Kopotoroc yu inoin Kunkun Amna omochon oburodec maimun faic. ");
INSERT INTO yuw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Öö Kopotoroc, goc urop itonggong koinghon uyap nindaiya agot. Gocho noc nangbanaiya gocot itmaina irot ogep moröma sinom kombihat.’” Pitaho wönggon mata sakaun fiuna yogoc, ");
INSERT INTO yuw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Oröcnai, nocho boinno sinom kantiwa, öranoni Devit yu osucgon omong fauna kumkumon oring sigung. Tuya yuhon kumkumon weran tongsigungma wo önga bonip nonidec idina angidamon. ");
INSERT INTO yuw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Wohong Devit yu wömai Kopotorochon yong tuctuc amna idoc. Worocha tongga Kopotorocho yong koing mata ingoroc godingmun fat imogoc, ‘Mit wömai gochon morogoya au amna moröma sinom engoc. Tongo yu Israel nano yangtoreangoc.’ ");
INSERT INTO yuw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kopotorocho yu mata ihoroc inogocmaha tongga Devitho Kopotorochon irot kombigoc. “Tongo yu kombigoc, mata wo wömai ‘Duicha’ kombingga yogoc. Tuna Duic yu kumkumondec idoc mahong mabomtogoc. ");
INSERT INTO yuw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Muno, Kopotorocho yu angbanauna idonggoc. Idonguna dan noniho yu agomon. Agomonmaha non kombiamon fatmatano woi boinno. ");
INSERT INTO yuw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yesu yu momdec öngo Kopotorochon oburo arocne itmuna ma moröma sogidoc. Tuna Nandöng Kopotorocho Kunkun Yaru yudec sing imogoc. Sing imuna yu nondec koringmun mugoc. Kunkun Yaruha wömai Kopotorocho osucgon non nimoc nimocha mata godingmun fatdegoc. Oro worochon torocgon wömai yu önga Kunkun Yaru nondec koringmun muuna kiapmo fodibo ngo öngkuuna sonu wo angmuya nanga fatfat tang. ");
INSERT INTO yuw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“Oro Yesu momdec ögocma worochon toroc wömai Devitho maögoc. Wohong yu ihoroc yogoc, ‘Kopotoroc yu nochon Morömana ingoroc inogoc, ‘Goc nochon arocne omoc idiya ");
INSERT INTO yuw_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ongga nocho gochon ayamaihon gesöno fohongga gochon unenne fohong yuangot.’ ");
INSERT INTO yuw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Worocha son Israel nano ambarac, son ingoroc kombiarut: Son osuc Yesu ep goröcdec wodungma yu woroc wömai Kopotorocho temongmun uuna yu mom sa guroc ambarachon Morömo Duic itac. Yuhon oburodec wömai Kopotorocho inoin owi amnani fogiuna batip itnahing,” Pita yu mata moröma ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Oro Pitahon mata worocho wömai owi amna irotno sakacno sinom tuna soroc yogung. Soroc yongo yu Pita orin aposel nucni inong ac tongo yogung, “Oröcnai tingting tontamon oro?” ");
INSERT INTO yuw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ihoroc inuya Pitaho inogoc, “Son tungu tungu ambaracho irot soni ibaruna Yesu Duichon madec yamuc gubarut. Ihoroc tuya wömai Kopotorocho turongo soni tongsac tongbödengga guram sing kamuna Kunkun Yaru sogiantang. ");
INSERT INTO yuw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kopotorocho osuc omocene Kunkun Yaru kamoc kamocha mata godingmun fadocma mata wo wömai yu sontha orin managumboc soniha yogoc. O owi amna abe korungon idiya Kopotorocho inong yangocma yu ambaracha wömai yogoc.” ");
INSERT INTO yuw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Oro Pita yu mata orongi koböcma sakaun fiuna owi amna kiring imongo garac mata ingoroc inogoc, “Son muyu guroc amnahon toroc kiap gendöngniha me imongga Yesuha kombing tobing imarut. Ihoroc tonggai wömai sonu batip itmuya magorong ongoning.” ");
INSERT INTO yuw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pita yu ihoroc yuna matanoho owi amna koböcmahon irotno sakauna kombiuya angit idina yamuc gubung. Yamuc gubungma worochon namba woi 3,000 ihoroc idoc. Yu woi owi amna osuc Yesuha kombing tobing imogungma yuot sakau fiuna kondong ididung. ");
INSERT INTO yuw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Oro suraro wo yu bongono bongono amna aposel ma sogidungma yuhon yong fasun fasun mata kombingidung. O yu irot tungu singmuya oröc tongga ididung. O yu engsuran tongga kumbong imu nacno nahi dönac youp toi ihoroc tongo ididung. ");
INSERT INTO yuw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tongo yu ambaracho irotno Kopotorocha bogingo yu anggendingidung. Tuya Kopotorocho aposelho oburodec toroc kiap inobarac manomano tongidoc. ");
INSERT INTO yuw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kombing tobic tobic owi amna yu wömai irot tungu sinom sing-muya inoin yoctecno möneng manomano ambarac feng suran tongmuya ‘suraro ambarachon fat itun’ yongo soworeng fingidung. ");
INSERT INTO yuw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tongo yu irot basi sinom inoin sa guroc yoctecno manomano maketdec fiuya mönengno fogida nucni urocima silip tong imongidung. ");
INSERT INTO yuw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tongo yu sep danong öret socsoc bucin fatmata ogepma kombic kombicha suran tongidung. O yu irotno borongdetno sinom tongo ino bucin suran tongo imu nacno nongidung. ");
INSERT INTO yuw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tongo yu yong kumengo Kopotorocha yong moröng imong tongidung. Tuya owi amna ambaracho yu yang gendingidung. O Kopotoroc yu sepno sepno owi amna au inong yuna yu Yesuhon surarodec sakau fingidung. Tuna surarohon nambano moröma sinom ögoc. ");
INSERT INTO yuw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Oro oipmonu Pita orin Jön yu dönac youp toctocha öret socsoc bucin ögomoroc. Woi dobocsisi 3kilok bongono wocin ögomoroc. ");
INSERT INTO yuw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Oro bongono wocingon wömai amna au yu nucno orungo wöntucmuno sumboda tengga öret socsochon böc simbu mano ‘orogoma sinom’ woce tohong sigung. Amna wo wömai macnoho ihorocma bagoc. Tuna yu bongono muno simbu wocegon itmuna owi amna ongi epi togungma möneng yoctecnoha dönac inongidoc. ");
INSERT INTO yuw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Oro Pita orin Jön yu öret socsoc bucin öcöcha ehunya amna worocho yu mönengha inogoc. ");
INSERT INTO yuw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Inuna Pita orin Jön yu amna wo foring angmunya Pitaho inogoc, “Goc not nihi.” ");
INSERT INTO yuw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ihoroc inunya amna worocho ‘möneng au namontamoroc’ yongo yu yamong fihic togoc. ");
INSERT INTO yuw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Tuna Pitaho inogoc, “Möneng wömai maitnamoc mahong yapmu itnampacma worocthong gampiwa. Yesu Duic Nasaretma yuhon madec goc idongga itongoi.” ");
INSERT INTO yuw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ihoroc inongga yu amna worochon oburo arocne sogito tun idonggoc. Tuna wohogon orung gorugo tong nongnong tongo idonggoc. ");
INSERT INTO yuw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tongo yu foro singga itongga toup sinom borongdedoc. Tongo yu Pita orin Jön yanmuna öngmondic öngmondic tongo Kopotorocha yong kumeng imogoc. ");
INSERT INTO yuw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ihoroc tongga idina owi amna öret socsoc bucin idungmaho yu angga kombigung, ");
INSERT INTO yuw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","‘Mayain, amna ino ngorocho wömai öret socsoc böc simbunodec ida ‘owi amnaho möneng namarut’ yongo inong yongidoc.’ Ihoroc kombingga yu orokogocmaha soroc yongo kombic kombic youp morö tongo nangano fadoc. ");
INSERT INTO yuw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Oro, owi amna koböcmaho Pitaho amna tun orokogocmahon fatno kombingga soroc yongo ‘woroc ana’ yongo domdomgon yuot ebung. Engmuya yagungmai amna orokogocma yu Pita orin Jönot öret socsoc böchon barandadec wocin idung. Baranda worochon mano wömai ‘Salomonthon baranda’ ihoroc yongidung. ");
INSERT INTO yuw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Oro Pita yu yagocmai owi amna koböcma ebung. Tongo yu forosingga mata ingoroc inogoc, “Son Israel amna, sonu foro yaha sinom yapmu ngo öngkupacmaha soroc yongo not nimong fihic tang? Son ingoroc kombininga, not nodin koing socsocdec amna ngo tada orokoc, o notu Kopotorocho yangamin nongnongo sinom idamotmaha tongga amna ngorochon orungo tada orokuna idongeyac, muno sinom. ");
INSERT INTO yuw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","“Abraham, Aisak, Jeköp orin ombusakung noni yuhon Kopotoroc yu wömai ‘inoin youp amna Yesu yuhon ma onoce sinom itun’ yongo not gesö nimuna notu amna ngo tada orokoc. Amna mano Yesu wo wömai sontho sogida ‘ompun’ yongo ayamphon oburodec sigung. Tuna Pailat yu Yesu imun fauna ohonggonga yogoc mahong sontho kiringga yuha möp yongo mata toup fing tandung. ");
INSERT INTO yuw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Amna worocho wömai Kopotorocho yangamin nongnongo kunkun sinom itac. Yu toroc kiap ogepmagon tongidoc mahong sontho yuha möp yongo Pailat ‘usem amna wohong nimpi’ yongo inogung. ");
INSERT INTO yuw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Son ihoroc togungmaha tongga itonggong tung öngkung nimoc nimoc amna noni Yesu yu ep goröcdec wuya omboc. “Wohong Kopotorocho yu amna woroc kumkumonma tun idonggoc. Woroc wömai nodu dan nodiho agomot. Tongo nodu worochon yong tuctuc matano owi amnadec yong fandadidamot. ");
INSERT INTO yuw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Oro nodu Yesuha kombing tobing imongidamotmaha tongga Kopotorocho amna ngo son kombing imangma yu tun orokoc. Yesuhon mano woi gesönobarac. Amna worocho Yesuhon ma kombing tobingitacmaha tongga yu orokoc. Orokuna dan soniho agung. ");
INSERT INTO yuw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Oro oröc ori noc kombihat, sonot amna moröma soni son Kopotorochon mata angit sinom makombiingmaha tongga sonu Yesu ayamihon oburodec sigung. ");
INSERT INTO yuw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Worochoi oro, Kopotoroc yu osucgon ‘Duic yu muyu focfoc kombiangoc’ yongo yong torop singdegoc. Tuna Kopotorochon yong tuctuc amnani ambarac yu worochon yong tuctuc mata ninogung. Tuya sonu Duic ep goröcdec wuya ombocmaha tongga yong tuctuc mata worocho boinno öngkupoc. ");
INSERT INTO yuw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Worocha son kombic kombic wöntucmuno soni mongurac tongga irot soni ibararut. Ihoroc tuyai wömai Kopotoroc Moröma noni yu turongo soni tongsac tongbödengo koing socsoc wego kamontac. ");
INSERT INTO yuw_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tongo yu Duic inong muuna ehangoc. Duic wömai Kopotorocho son tongfat keckecha soworegoc. ");
INSERT INTO yuw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yesu yu abe momdec iditac mahong mit Kopotorocho mom sa guroc ambarac wego dongyun öngkuangocan bongono wocin wömai yu wönggon ehangoc. Kopotorocho osuc yong tuctuc amnaniho ducdec mata godingmun fadocma worochon toroc. ");
INSERT INTO yuw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Möse yu wömai Yesuha ingoroc yogoc, ‘Moröm soni Kopotoroc yu sonthon bonip sonidecma yong tuctuc amna moröma au noc simbang temongmun öangoc. Son muyu yuhon duc mata ambarac sumbotbödengitnung. ");
INSERT INTO yuw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Amna auho yuhon mata masumbiningma yu wömai Kopoto-rocho Israel nanohon bonipnodecma kondong tongga dong yarangoc.’” ");
INSERT INTO yuw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Pitaho mata sakaun fiuna yogoc, “Boinno sinom Kopotorochon yong tuctuc amnanihon yong tuctuc mata wömai önga bongono ngocin boinno öngkubang. Forosingga Samuel o ihorocgon worochon menon öngkubungma yuhon mata woi önga boinno öngkupac. ");
INSERT INTO yuw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Oro son wömai yong tuctuc amnani orin ombu sakung soni yuhon morogoni idang. Worocha tongga Kopotorocho yu mata godingmun fat imogocma worocho sondec ongeyac. Yu wömai Abraham ingoroc inogoc, ‘Gochon morögoyaha tongga nocho guramna owi amna ambaracdec sing imangot.’ ");
INSERT INTO yuw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“Kopotorocho Abraham ihoroc inogocmaha tongga yu youp amnano Yesu omocdecma tun idonggoc. Tongo yu osuc Israel nano sonot inongmuna eboc. Tuna sonu toroc kiap wontucmuno soni dou fauya irot ibarantanganu wömai Kopotorocho guramno sondec sing kamontac.” Pita yu owi amna ihoroc inogoc. ");
INSERT INTO yuw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita orin Jön yu owi amna mata ihoroc inongga idinya öret socsoc amna orin Sadyusi orin tawa amnahon ofisa yu Pitaot ebung. ");
INSERT INTO yuw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Yu wömai Pitahon mata kombingga toup soroc yogung. Wömai yaha Pitaho yogoc, ‘Yesuha tongga owi amna omocdecma idongonahing’. Pitaho ihoroc yuna amna morömahon irot tun obukogoc. ");
INSERT INTO yuw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tongo yu engmuya Pita orin Jön fogit akep tongga mata youpdec fonggonga kombigung mahong sep urop ibandocmaha tongga yu komong yi bucin fohongyuya woce idomoroc. ");
INSERT INTO yuw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Wohong owi amna koböcma yu Pitahon fatmata kombingga Yesuha kombing tobing imongo kombing tobic tobic surarodec sakau figoc. Tuya surarohon nambano toup uuna owi amna 5,000 ihoroc idung. ");
INSERT INTO yuw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Oro Pita orin Jön yu yi bucin idinya kembotsum wömai öret socsoc amnahon dugo orin Yudananohon amna moröma orin nongoru gendic fandat fandat amna yu Yerusalem engmuya suran togung. ");
INSERT INTO yuw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Suran togungma woi öret socsoc böchon amna dugo mano Anas orin Kaiafas, Jön, Aleksander o ihorocgon öret socsoc amna dugohon toropni yu ambaracho engga suran togung. ");
INSERT INTO yuw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Suran tongga idiya tawa amnaho Pita orin Jön yangat fehuya amna morömaho yu ingoroc inong ac togung, “Numaho sot gesö kamuna sodu amna wo tun orokogoc. Sodu youp sodi numahon madec tongidamoroc?” ");
INSERT INTO yuw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ihoroc inuya Kunkun Yaruho Pitaot ohongo dugo tun yungan tuna Pitaho mata urago ingoroc iban imogoc, “Son Israel nanohon amna dugo son kombiarut. ");
INSERT INTO yuw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Not amna orungo wöntucmuno tongfat yegomotmaha tongga not önga ngo mata youpdec itdaya sonu notha mata firing nirang. Sonu ingoroc ninong ac tang, sodu ting tunya amna wo orokogoc. ");
INSERT INTO yuw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Oro sonot Israel nano ambarac son ingoroc kombiarut: Yesu Duic Nasaretma yuhon manodec wömai nodu amna wo tada orokogoc. Tuna yu ngo sonthon yangam sonidec idonguna aang. Yesu woroc wömai sonu sogida ep goröcdec wuya omboc mahong Kopotorocho yu omocdecma tun idonggoc. ");
INSERT INTO yuw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesuha wömai mata ingoroc irim toctocyi itac: ‘Sop au wömai böc toctoc amnaho ‘sop wontucmuno’ yongo tomu onggoc mahong Kopotorocho sop worocgon sogitmuna tong koing tong imuna sop worocho böchon forodongno sinom öngkupac.’ ");
INSERT INTO yuw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Yesu Duic yuhagon tongga Kopotorocho non wömunodecma öcangyun muuya batip itnahamon. Kopotoroc yu wömai ‘owi amnaho ma tungu worocgon kombing tobing imarut’ yongo ma wo nimogoc. Momdechu o gurocdechu wömai amna auho non itonggong koingdec mafohong nuic, muno sinom.” Pita yu mata ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Yuna amna dugo yu mata wo kombingga nanga fatfat togung. Wömai yaha yu kombigungmai, Pita orin Jön yu amna komongno, yu kombic kombic bucin maöngidomoroc mahong yu mata urago orongi sinom iban imogomoroc. O yu osuc yu Yesuot itongidomoroc. ");
INSERT INTO yuw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","O ihorocgon amna dugo yu amna orokogocma auya yu Jön orin Pitaot kondong yuho yangamin idongga idoc. Worocha tongga yu mata ökenne yocyocha uyap yabiu matogoc. ");
INSERT INTO yuw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tongo amna dugoho inogung, “Son taitdec ohongga torengga idarut.” Ihoroc inuya yu ohongga idiya amna dugoho inohogon mata inun ganun tongo yogung, ");
INSERT INTO yuw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nonu amna yai ngo tingting sinom tong imontamon? Yerusalem owi amna ambarac yu urop toroc kiap moröma togomorocmahon fatno kombingbödeang. Worocha nontho angit öp masinin. ");
INSERT INTO yuw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Wohong yuhon mata woi wömuno sinom, mata ngorocho owi amna ambaracho onggimin ohuna kombiningyit. Worocha non muyu amna yai ‘muno’ inongo ‘sot wönggon mata au Yesuhon madec owi amna inodimorocha’ ihoroc inontamon.” ");
INSERT INTO yuw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Oro amna dugo yu mata ihoroc yu bödeuna amna yai inong wodiuya ehunya nongoru ingoroc inogung, “Sot Yesuhon fatmatano amna au inodimorocha” ihoroc inongo ‘muno’ sinom inogung. ");
INSERT INTO yuw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Wohong Pita orin Jön yu mata woroc kombiunya angit maidina mata urago ingoroc iban imogomoroc, “Son sonibut soworengga yarut, yaö kiapmo ogepma in, nodu sonthon matahong sumbentamotha woha Kopotorochon matahong sumbentamot. ");
INSERT INTO yuw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nodu ducnodi öp singga matomtodin. Muno sinom, nodu yapmu agomotmahu o yapmu kombigomotmahu worochon fatno muyu owi amna fandat inongdup tongitahamot.” ");
INSERT INTO yuw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ihoroc inunya kombingga amna dugoho suraroha botogungmaha tongga yu komong tong botoc mata orongi inongo inongmuya ohogomoroc. Suraro ambaracho wömai Pitaho amna tun orokogocmaha kombigung, woi Kopotorochon werano. Worocha tongga yu borongdetmuya Kopotorochon mano tu fadauna yong kumeng imogung. ");
INSERT INTO yuw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Wömai yaha amna wo yu biruc 40 ihoroc obukoc tongga idina Pitaho tun orokogoc. ");
INSERT INTO yuw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Oro amna dugo yu Pita orin Jön inongmuuya ongga orung idomoroc. Tongo yu kombing tobic tobic suraro ot ongmunya amna dugoho mata inogungma worochon fatno suraro inogomoroc. ");
INSERT INTO yuw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Inun-ya suraro yu woroc kombingga irot tungu singmuya Kopotoroc dönac ingoroc inogung, “Öö Moröm noni Kopotoroc, mom sa guroc manomano ambarac wömai gocho tobing figoroc. ");
INSERT INTO yuw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Gochon youp amna Devit, woi öra noni, yu Kunkun Yaruhon gesödec gakain yong tuctuc mata ingoroc yogoc, ‘Bumbumyi nano yu komanang sinom irot kombut tongidang. O guroc owi amna yu komanang sinom toroc wöntucmuno toctocha yong torop singidang. ");
INSERT INTO yuw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Böcno böcno amna morömaho Morömaot emoc toctocha tong arangarang tang. O sa gurochon amna dugo yu suran tongga Duichon ma tong samborec toctocha yang.’ ");
INSERT INTO yuw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Öö Kopotoroc, boinno sinom Heröt, o Pontius Pailat, o bumbumyi nanohon dugo, o Israel nanohon dugo, yu böcsa ngocin suran tongga gochon youp amna Yesu yuhon ma tong samborec toctocha mata yong torop sigung. Yesuha wömai gocho ‘nakain youp toun’ yongo ma moröma imogoroc. ");
INSERT INTO yuw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yu Yesu ayam tong imongidang mahong gochon gesö woi moröma, o gochon irot kombic kombic woi ogepma sinom. Worocha gocho osucgon ‘ihoroc tonahing’ yongo kombingdegoroc. ");
INSERT INTO yuw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“Öö Moröma, goc kombiharoc, amna dugo yu ‘nonthon youp bödehun’ yongo yong botoc botoc mata ninang. Worocha goc muyu gochon youp amnayai tongfat yeia yu gochon fatmata ogepma tong botoc botocno muno orongi sinom yong tongonung. ");
INSERT INTO yuw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Gocho yu gesö imia yu Yesuhon madec obukoc owi amna dou orokonahing, o yu momphon toroc kiap inobarachu o weran moröma au tuya owi amna yanahing.” Yesuhon suraro yu dönac ihoroc yogung. ");
INSERT INTO yuw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Yongbödeuya wohogon sa wocin konoc fendoc. Tuna Kunkun Yaruho owi amnadec ohuna ducmoto Kopotorochon fatmata orongi sinom yong tonggung. ");
INSERT INTO yuw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Oro bongono wocin wömai kombing tobic tobic owi amna ambaracho oröc oröc tongmuya irot tungu sinom ididung. Amna auho inoin manomanoha makokorengidung. Muno, yu nucno tongfat yeun yeun tongmuya amna tunguhon manomano wömai amna ambarachon itbödegoc. ");
INSERT INTO yuw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ihoroc tongmuya amna aposel ma sogidungma yu Moröma noni Yesu yuhon fatmata ogepma orongi sinom yong moröging tonggung. Yu yongidung, ‘Yesu yu boinno sinom omocdecma wekongga idonggoc.’ Ihoroc yong tongidiya Kopoto-rochon guram moröma sinom surarodec idoc. ");
INSERT INTO yuw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Bongono wocin wömai surarodec amna auho yapmu auha madocmögoc. Muno sinom, amna ambaracho gurochu o böcnohu idimogungma yu woroc mönengha fingga möneng wo suraroha bogingidung. ");
INSERT INTO yuw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Tuna aposelho möneng woroc sogida silip tongga owi amna docmö-gungma yu tongfat yengidung. ");
INSERT INTO yuw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Oro amna au mano Yösep. Yu ihorocgon gurocno docno au siuna amna auho mönengha wögoc. Wuuna Yösep yu möneng wo aposel imogoc. Oro Yösep yuhon mano au wömai Aposelho ‘Barnabas’ ihoroc mambodung. Ma worochon foro wömai ‘irotno tongkoing toctoc amna’ ihoroc. Barnabas yu ihorocgon Livaihon toropdecma. Yuhon böcno sano sinom wömai sa muropmo Saiprus woce idoc. ");
INSERT INTO yuw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Oro bongono wocin wömai oimna au yu suraro ot ididomoroc. Amna mano Ananaias o oweno mano Safaira. Ananaias yu ihorocgon gurocno docno mönengha siuna amna auho wögoc. ");
INSERT INTO yuw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Wöngo möneng imuna Ananaias yu au inoha öp singo o docnogon wömai aposel imogoc. Tuna owenoho toroc kiap wo togocma kombingbödegoc. ");
INSERT INTO yuw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ihoroc tuna Pitaho ingoroc inogoc, “Ananaias, gocu yaha dogu kopot angbanaiya iroda foctogoc. Tuna goc gurocahon möneng docno öp singga Kunkun Yaru imanang inong yuharoc. ");
INSERT INTO yuw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kombihi, guroc docno wo woi gakain fat idoc. O möneng sogidorocma woi ihorocgon gochon manomanogon. Worocha goc gakain ibiba tarim. Foro yaha goc wömuno ihoroc taroc? Goc amnahagon imanang mainoroc, muno gocu Kopotoroc inong yuharoc.” ");
INSERT INTO yuw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pitaho ihoroc yuna Ananaiasho mata woroc kombingga wohogon möng fodop tongo omboc. Tuna suraro yu kiapmo woroc angmuya toup sinom botogung. ");
INSERT INTO yuw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tongo amna berac wocin idungma yu engga ep fambangno tec tomtongga sumboda tongo tongga oringsigung. ");
INSERT INTO yuw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Oring siuya bongono 3 aua ihoroc bödeng idina Ananaiashon oweno yu ihorocgon böc ganang ögoc. Yu wömai toroc kiap opnodec öngkubocma makombii etno ögoc. ");
INSERT INTO yuw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tuna Pitaho möneng indangga inogoc, “Gocho boinno yoi, sodu gurochon mönengno sogidomorocmai worocgonthu nuhun?” Yuna owiho yogoc, “Öc boinno, worocgon.” ");
INSERT INTO yuw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ihoroc yuna Pitaho inogoc, “Sodu yaha sinom Morömahon Yaru imanang inong yucyucha irot tungu sigomoroc? Kombihi, amnaho oba tongo tongga oring siingma yu urop ibaru fauna ebang. Yuho wömai goc ihorocgon sumboto tongontang.” ");
INSERT INTO yuw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ihoroc inuna wohogon owi wo Pitahon orungo forodec möng fotop tongo omboc. Tuna amna beracma yu böc ganang öngga agungmai owi wo yu omongga idoc. Tuna wohogon sumboto tongo opno oring sigungan wocegon oring sigung. ");
INSERT INTO yuw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tuna kombing tobic tobic surarohu o owi amna ambarac fat wo kombigungma yu soroc yongga toup sinom botogung. ");
INSERT INTO yuw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Oro aposel yu owi amnaho yangamin momphon toroc kiap ihono ihono koböcma sinom tongidung. Kombing tobic tobic suraro yui irot tungu singga öret socsoc böchon gombo ganang Solomonthon barandadec woce bongono bongono suran tongidung. ");
INSERT INTO yuw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ihoroc tuya owi amna komanangnoho yu yang gendingidung mahong yuot suran toctocha wömai botogung. ");
INSERT INTO yuw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Wohong owi amna koböcma sinom yu irotno ibaruna Morömaha kombing tobing imongidung. Tongo yu kombing tobic tobic surarodec sakau fiuya worochon nambano moröma ögoc. ");
INSERT INTO yuw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tuna owi amna yu aposelhon gesö moröma angga nucni obukocnima sumboto fengga uyap tagarodec tecyoroc tongo fingyu dubung. Yu ‘Pitaho engo yuhon dogunodec sakauna doguno worocho obukoc owi amna wo yanggecmoto onguna orokontang’ yongo ihoroc togung. ");
INSERT INTO yuw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","O owi amna böcsano Yerusalem taun ambehecgon idungma yu ihorocgon nucni obukocnimahu o dogu boyömonimahu yuot yangat febung. Yangat fehuya aposelho yu ambarac dou orokongbödegung. ");
INSERT INTO yuw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Oro öret socsoc böchon amna dugo orin amna dugo Sadyusi toropdecma yu aposelhon toroc kiapmo yangmuya irotno obukogoc. ");
INSERT INTO yuw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tongo yu aposel fogito yibucin fohong yugung. ");
INSERT INTO yuw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Yi bucin fohong yuya idiya kumbong wömai Morömahon sum yaru auho engmuna yi böchon simbu fagarito aposel yangato sumon fohong yungo inogoc, ");
INSERT INTO yuw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Son ongga wönggon öret socsoc böchon gombo ganang öngga itonggong koinghon fatmata ogepma owi amna inongdup tarut.” ");
INSERT INTO yuw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ihoroc inuna aposelho mata woroc kombingo kembotsumgon öret socsoc bucin öngmuya owi amna fatmata ogepma fandat inogung. Tuna öret socsoc böchon amna dugo yu ehuya Israel nanohon amna dugo inong yuya suran togung. Yu woi Israel nanohon kaunsil. Tongo yu ‘aposel yangat feparut’ yongo tawa amna inong muuya yibucin onggung. ");
INSERT INTO yuw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Woce ongga yagungmai aposel yu woce maidung. Woroc angga ibaru fauna ongga amna dugo yongburoc inongo yogung, ");
INSERT INTO yuw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nonu ongga yi böchon simbu anaya orongi akep toctocyi idina tawa amnaho gön tongga idung. Ihoroc idiya nonu simbu fagarito agomonmai amna tungu au wocin maidoc.” ");
INSERT INTO yuw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tawa amnaho yong-buroc mata ihoroc yuya öret socsoc böchon amna dugo orin tawa amnahon ofisa yu mata woroc kombingga irot koböc koböc kombingga yogung, “Mayain, önga aamonmahon menonu tingting sinom öngkuangoc?” ");
INSERT INTO yuw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tuna amna mit amna auho engmuna inogoc, “Kombiang amna wo sonu yi bucin fohong yuingma yu öret socsoc böchon gombo ganang itmuya owi amna fatmata fandat inongga idang.” ");
INSERT INTO yuw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ihoroc inuna ofisaot tawa amna auot yu ongmuya aposel fogida amna dugoho yangamin yangat febung. Yangat febungma wömai dopdopno muno obinggon febung. Yaha yu suraroha botogungmaha, yu wömai kombigung, ‘Doantamonanu wömai owi amnaho sopdec monda nipningyit.’ ");
INSERT INTO yuw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Oro tawa amnaho aposel fogida amna dugoho yangamin mata youpdec fohong yuuya idung. Idiya öret socsoc amna dugoho ingoroc inogoc, ");
INSERT INTO yuw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Non osuc ‘muno sinom’ kanogomon. Son Yesuhon madec owi amna fandat inoninga. Wohong sonu mata noni fodingga Yesuhon fatmata yong tonguya Yerusalem owi amna ambaracho kombingbödeang. O sonu nontha mata metec yongo owi amna ingoroc inongöang, Yesu wömai nontho wotnaya omboc yo.” ");
INSERT INTO yuw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ihoroc inuna Pita orin aposel au idungma yu mata ökene iban imongo yogung, “Non muyu Kopotorochon mata sumbotna. Amnahon mata muno. ");
INSERT INTO yuw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Sonu boinno sinom Yesu ep goröcdec wuya omboc mahong ombusakung nonihon Kopotorocnoho yu omocdecma tun wekogoc. ");
INSERT INTO yuw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kopotorocho yu sogito töngo onoce sinom inoin oburo arocne singga ma moröma imogoc. Tuna yu Moröma noni itmuna non wontucmunodecma öcangyun muuya itonggong koing nimongitac. Yudec singga wömai Kopotorocho Israel nano tongfat yecyecha kombihac. Tuna yu irotno ibaruya turongono bödeup. ");
INSERT INTO yuw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yesuhon youpno wömai nonu dan noniho agomon. Worocha tongga non yuhon fatmata ogepma yong fandadidamon. O Kunkun Yaru yu mata noni tong koing tongitac. Kunkun Yaru wömai Kopotorocho owi amna inoin mata sumbodidangma yu imongitac.” ");
INSERT INTO yuw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Oro Pitaho mata ihoroc yuna amna dugoho wo kombingga irotno toup sinom obokuna aposel dong omom toctocha yogung mahong ");
INSERT INTO yuw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","amna dugo au mano Gamaliel yu kombiuna angit maidina idonggoc. Yu wömai Israel nanohon nongoru gendic fandat fandat amna au idoc. Yu farisihon toropdecma idina owi amna ambaracho yu gending imongidung. Oro yu idongga tawa amna inuna yu aposel yangat fohuya böc amante torengga idung. ");
INSERT INTO yuw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Woce idiya Gamalielho amna dugo suran ingoroc inogoc, “Son Israel amna, son soni woho, son amna torop wo yapmu wömuno komanang tong imoninga. ");
INSERT INTO yuw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kombiarut, öngahemgon amna au mano Tiudas yu inoin mano töngga yogoc, ‘Noc amna moröma yo.’ Ihoroc yuna amna 400 ihorocho yu tan tonggung mahong tawa amnaho yu wuya omboc. Omuna amna yu tantonggungma ambaracho botongga sa woce woce gorong ongbödeuya Tiudashon youpno urop bödeuna boinno muno idoc. ");
INSERT INTO yuw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Oro worochon menon wönggon amna au mano Yudas yu inoin mano tögoc. Gavmantho sensus togocan bongono wocin wömai yu ‘gavmanot emoc tona’ yongo amna torop au feng suran togoc. Tuna tawa amnaho yu wuya omuna amna yu tan tonggungma yu botongga woce woce ongbödegung. Tuna Yudashon youpno ihorocgon boinno muno idoc. ");
INSERT INTO yuw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Worocha nocho önga garac mata ingoroc kantiwa: Sontho aposel ngo yapmu au tong imoninga. Muno, son yu yangbanauya ongorut. Yuhon youpno amnaho ino irodinmagon tanganu wömai youpnohon boinno maöngkuic. ");
INSERT INTO yuw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Wohong yu Kopotorochon youp boinno tanganu wömai son ogep foc matong imoning. Foc tong imonggahai wömai sonu Kopotorocha ayam tong imonahing.” Gamaliel yu mata orongi ihoroc yogoc. ");
INSERT INTO yuw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yuna amna dugo yu wo kombiuya angit idoc. Tongo yu aposel inong yuya ehuya tawa amnaho yu dobung. Douya amna dugoho nongoru ingoroc inogung, “S