﻿USE sofia;
DROP TABLE IF EXISTS sofia.yut_vpl;
CREATE TABLE yut_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yut_vpl WRITE;
INSERT INTO yut_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Amɨn kɨnda yokwi pakpak amɨn da yabet aŋakwa uŋun yolek dɨma agɨsak, ae amɨn yokwi gat kɨsi dɨma akgaŋ, ae Piŋkop do manji gen yoŋ amɨn gat kaloŋɨ dɨma yɨkgaŋ, uŋun amɨn kɨsɨk kɨsɨk tagɨ asak. ");
INSERT INTO yut_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Uŋun amɨn da Yawe dakon nawa gen do tagɨsi nandɨsak. Gɨldat kalba ae kalbiyo kɨsi uŋun do nandaŋ egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Uŋun amɨn kɨndap kɨnda pakbi ɨleŋon kwaokbi yombem. Bamɨ toktok bɨsapmon bamɨ uŋudon taŋtaŋ asak, ae tamɨ dɨma kɨbɨdosok. Yo morap asak uŋun aban bamɨ tagɨsi gɨn noman toŋ. ");
INSERT INTO yut_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Amɨn yokwi uŋun yaŋ dɨmasi. Uŋun wit dakon gɨpmɨ mɨrɨm da wɨrɨrɨk paŋgwaŋ uŋun yombem. ");
INSERT INTO yut_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Yaŋ do aŋek gen kokwin bɨsap madepmon Piŋkop da amɨn yokwi gen pikon yopban geni arɨpmɨ dɨma abɨŋ yɨpdaŋ. Yokwi pakpak amɨn kɨlegɨ da kabɨkon dɨma egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Nido Yawe da amɨn kɨlegɨ kɨlani asak, mani yoki pakpak uŋun tasɨk tokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Mɨŋat amɨn kabɨ morap mɨktɨmɨ mɨktɨmɨ ekwaŋ uŋun nido kwen wɨgɨk ak do gen yaŋ paŋteban aŋ? Mɨŋat amɨnyo uŋun nido ɨsal dogɨn yokwi ak do gen yaŋ paŋteban aŋ? ");
INSERT INTO yut_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Mɨktɨm morap dakon kɨla amɨn madepni emat ak do tagap toŋ. Uŋun muwugek Yawe gat ae amɨn uŋun mɨŋat amɨn kabɨni kɨla asak do bɨt nelak tagal ɨbi amɨn gat pabɨŋ yop do gen yaŋ paŋteban aŋ. ");
INSERT INTO yut_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Gen yaŋ yoŋ, “Uŋun bamot dakon amɨn wamwam nap teban paŋdagono. Ain nap kandapninon paŋteban agɨmal uŋun wɨtdalno.” ");
INSERT INTO yut_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Kwen Kokup kɨla amɨn madep yɨtyɨt tamonikon yɨkdak amɨn jɨkgo yanjaŋ yomɨsak. Amɨn Tagɨ da jɨgɨlagon da pabɨŋ yopmaŋdak. ");
INSERT INTO yut_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Butjapsi nandaŋ yomɨŋek gen tebai yoyɨŋban pasal kɨmokgoŋ. ");
INSERT INTO yut_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Uŋun da yaŋ yoyɨsak, “Nak da on amɨn kɨla amɨn madepno egɨpjak do kɨlɨ yɨpgum da telagɨ ɨleŋno Saion uŋudon yɨkdak.” ");
INSERT INTO yut_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Kɨla amɨn madep da yaŋ yosok, “Yawe da yo madep kɨnda nayɨgɨt uŋun yaŋ teŋteŋokdɨsat. Yaŋ nayɨgɨt, ‘Gak Monjino. Abɨsok nak gak dakon Datgo dagosot. ");
INSERT INTO yut_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Bɨsit nayɨŋbɨ mɨŋat amɨn morap mɨktɨmɨ mɨktɨmɨ ekwaŋ uŋun gak do gabo mɨktɨm kɨsisi kɨla abi. ");
INSERT INTO yut_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Gak da kɨla amɨn pi tapmɨmɨ toŋsi aŋek kɨla amɨn madep dakon kɨndap kɨrɨŋ ain naŋ wasaŋbi uŋun naŋ uwalgo pudaŋ monɨŋ monɨŋ akdɨsal. Amɨn da mɨktɨm kwoba pudaŋ monɨŋ monɨŋ aŋ uŋun da tɨlagon akdɨsal.’ ” ");
INSERT INTO yut_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Yaŋdo, kɨla amɨn madep ji nandaŋ kokwin tagɨsi aŋek egɨpni. Mɨktɨmon kɨla amɨn, mama geno nandani. ");
INSERT INTO yut_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Ji Yawe do pasal ɨmɨŋek omani ani. Kɨsɨk kɨsɨk aŋɨmɨŋek pasal nɨmnɨmɨk ɨmni. ");
INSERT INTO yut_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Ji monjɨ dakon pɨŋbini egek gawak ɨmni. Butjap tepmɨ nandɨsak, do japmɨ nandaŋ daban dɨ kɨmakbam. Amɨn morap paŋkutnosak do Piŋkopmon kwaŋ uŋun kɨsɨk kɨsɨk tagɨ ani. ");
INSERT INTO yut_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Dewit monji Apsalom do pasalek kɨgɨt bɨsapmon kap on mandagɨt. Yawe, uwalno morapmɨsi! Amɨn morapmɨ da yokwisi aŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Uŋun da yaŋ yoŋ, “Piŋkop da arɨpmɨ dɨma aŋpulugokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Mani Yawe gak pasɨk da yaŋ nak aŋkɨsɨbɨsal. Aŋpulugaŋbɨ emaron teban tosot. Gak kaloŋ dagɨn but yokwino wɨrɨrɨkbɨ pasɨlakwa aŋteban abɨ tebai akdat. ");
INSERT INTO yut_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Yawe da aŋpulugosak do yaŋ tɨdosot. Uŋun telagɨ kabapnikon egek yaŋ ɨlɨtno dakon kobogɨ namɨsak. ");
INSERT INTO yut_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Dɨpmɨn potpot tamokon pagek obɨsi pak ɨŋtosot. Ae don pɨdaŋek tagɨsi egɨsat, nido Yawe da kɨlano tagɨsi asak. ");
INSERT INTO yut_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Uwalno 10 tausen da terɨ terɨ da abɨŋ aŋdagat ayɨŋ, mani uŋun do dɨma pasolgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Yawe gak apbi! Piŋkopno abɨŋ aŋpulugoki! Uwalno mogɨm kulbak dapbi. Amɨn yokwi uŋun dakon geni dapmaŋ bɨrɨpmɨkgi. ");
INSERT INTO yut_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Yawe gak dagɨn nin paŋpulugaŋbɨ teban tomaŋ. Mɨŋat amɨn kabɨgo nin yo tagɨsi aŋ nibi dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Dewit dakon kap kɨnda. Gita tɨdaŋek yogogɨ. Piŋkopno kɨlegɨsi, gak do yaŋ tɨdokeŋ bɨsapmon nandaŋ nabi. But yokwino wɨrɨrɨkbɨ pasɨlgɨt. Bupmɨ nandaŋ namɨŋek bɨsitno nandaki. ");
INSERT INTO yut_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Amɨn ji, bɨsap niaŋ da man madepno abɨŋ yɨp do pi ani? Bɨsap niaŋ da yo ɨsalɨ mibɨlɨ mibɨlɨ do but dasi galak taŋ yomɨŋ kɨmotni? Bɨsap niaŋ da top aŋpak yolni? ");
INSERT INTO yut_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Ji gen on do pakyaŋsi nandani. Amɨn morap Yawe dakon pɨŋbinisi ekwaŋ, uŋun iyɨ do manjɨgɨt. Nak uŋun do yaŋ tɨdoko bɨsitno nandɨsak. ");
INSERT INTO yut_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Ji Piŋkop do si pasalek aŋpak yokwi morap yopmaŋ mudoni. Si potni bɨsapmon gen on do pakyaŋsi nandaŋek gen kagasi sopni. ");
INSERT INTO yut_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Paret Yawe da galak tosok uŋun baŋ aŋek egɨp egɨpji Yawekon tosok yaŋsi nandani. ");
INSERT INTO yut_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Amɨn morapmɨ da yaŋ yoŋ, “Namɨn da nin paŋpulugaŋban tagɨsi egɨpneŋ?” Yawe, butgo ninon yɨpmaŋek yo tagɨsi aŋ nibi. ");
INSERT INTO yut_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Wit gat ae wain gat dakon bamɨ morapmɨ paŋ bɨsapmon amɨn kɨsɨk kɨsɨk aŋ. Mani Yawe gak da kɨsɨk kɨsɨk butnokon yɨpgul uŋun da uŋun dakon kɨsɨk kɨsɨk yapmaŋdak. ");
INSERT INTO yut_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Yawe gak dagɨn kɨlano aŋaki tagɨsi egɨsat, do yo kɨnda do dɨma pasalek tamokon pokdot bɨsapmon tepmɨsi pak ɨŋtosot. ");
INSERT INTO yut_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Dewit dakon kap kɨnda. Kap on amɨn da kasɨsɨŋ pɨsoŋakwa yogogɨ. Yawe bɨsit aŋek iyoŋ iyoŋ yaŋapbo geno do mɨrak yopbi. ");
INSERT INTO yut_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Kɨla Amɨn Madepno ae Piŋkopno, aŋpulugoki do bɨsit asat, do yaŋ ɨlɨtno nandaŋ nabi. ");
INSERT INTO yut_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Yawe, wɨsa dagokdo morap gak do bɨsit asat. Wɨsa dagokdo gak do bɨsit tebaisi asat. Bɨsitno dakon kobogɨ nabi do jomjom asat. ");
INSERT INTO yut_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Piŋkop, gak aŋpak yokwi do kɨsɨk kɨsɨk dɨma asal. Yokwi aŋ amɨn gak da kapmatjok tagɨ dɨma egɨpmɨ. ");
INSERT INTO yut_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Iyɨ do nandaba wɨkwaŋ amɨn gak da dabɨlon tagɨ dɨma atni. Aŋpak yokwi aŋ amɨn morap dɨmasi galak taŋ yomɨsal. ");
INSERT INTO yut_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Yawe, gak da top gen yogok amɨn morap paŋupbal asal. Amɨn dapba kɨmokgoŋ amɨn gat, ae amɨn paŋkewalgaŋ amɨn gat dɨmasi galak taŋ yomɨsal. ");
INSERT INTO yut_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Mani gak da nak but dasi galak taŋ namɨsal, do gak da yutnon tagɨ wɨgɨkeŋ. Telagɨ yutgokon uŋudon ŋwakbeŋ aŋek gawak gabeŋ. ");
INSERT INTO yut_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Yawe, uwal da nak aŋupbal akdaŋ, do kosit yɨpmaŋ namɨŋaki aŋpakgo kɨlegɨ uŋun yolbeŋ. Kosit agɨpbeŋ do nandɨsal uŋun nolɨki. ");
INSERT INTO yut_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Uwalno gen bamɨsok kɨnda dɨmasi yoŋ. Amɨn dɨwarɨ paŋupbal ak dogɨn nandaŋ. Gen kagani uŋun kɨmakbi tamo da yaŋ pɨsoŋ. Amɨn paŋgalak ak do gen morapmɨ yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Piŋkop, gen yaŋ yomɨŋek yo yokwisi aŋ yobi. Nandak nandak yokwini paŋupbal abi. Yo akdo nandaŋ kokwin aŋ iyɨ uŋudon yokwalni. Uŋun kwen wɨgɨk aŋ gamɨŋek yokwi morapmɨ aŋ, do yolbɨ gak da ɨŋam da dubagɨkon kɨŋ mudoni. ");
INSERT INTO yut_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Mani amɨn morap paŋkutnoki do gagon kwaŋ uŋun kɨsɨk kɨsɨk tagɨ ani. Uŋun but galak nandaŋek kɨsɨk kɨsɨk dakon kap dagok dagogɨ mɨni tagɨ yoni. Paŋkutnaŋaki but dasi galak taŋ gamaŋ amɨn kɨsɨk kɨsɨk sigɨn aŋek mango awɨgɨni. ");
INSERT INTO yut_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Gak da amɨn kɨlegɨ do yo tagɨsi aŋ yomɨsal. Emat dakon pasɨk da yaŋ taŋek paŋyoŋgam asal, ae kɨlani tagɨsi aŋaki tagɨsi ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Dewit dakon kap kɨnda. Gita napmɨ 8 kabɨ uŋun naŋ tɨdaŋek yogogɨ. Yawe, butjap nandaŋek gen tebai dɨma nayɨki. Butjap madepsi nandaŋek nak aŋmɨlɨp ak do tepmɨ pi dɨma nabi. ");
INSERT INTO yut_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Yawe, tapmɨmno mɨni, do bupmɨ nandaŋ nabi. Yawe, gɨptɨmno tep namaŋ, do aŋmɨlɨp abi. ");
INSERT INTO yut_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Butno wagɨlsi jɨk tosok. Yawe, bɨsap niaŋ da jɨgɨ paŋegɨpbeŋ? ");
INSERT INTO yut_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Yawe, tobɨl obɨŋek yokwikon baŋ abɨdoki. Bɨsapmɨ bɨsapmɨ amɨn do but dasi galak taŋ yomɨsal, do aŋpulugaŋbɨ dɨma kɨmokgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Amɨn kɨmakbi dɨma nandaŋ gamaŋ. Kɨmakbi tamogwan da gak dɨma aŋkɨsaŋ. ");
INSERT INTO yut_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Iyoŋ iyoŋ yaŋ egapbo tapmɨmno wagɨlsi maŋ mudoŋ. Kalbi morap kunam pakbino da tamono wagɨlsi aŋgɨk asak. Kunam tagapbo busuŋ kɨdɨŋno madepsi gɨk tosok. ");
INSERT INTO yut_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Uwalno morapmɨsi, do kunam gɨn tak egapbo dabɨlno pɨrɨropmaŋ. Aŋakwa yo kɨnda dɨma kosot. ");
INSERT INTO yut_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Kunam tak egapbo Yawe da kɨlɨ nandaŋ namgut, do aŋpak yokwi aŋ amɨn ji kɨsisi nepmaŋdek kɨt. ");
INSERT INTO yut_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Yawe da aŋpulugosak do aŋek yaŋ tɨdaŋapbo nandaŋ namgut. Yawe da bɨsitno nandagɨt. ");
INSERT INTO yut_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Uwalno kɨsisi mayaktok ae but yokwiyo pakdaŋ. Tepmɨsi tobɨl kɨŋek mayaktok pakdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Dewit da amɨn kɨnda Benjamin da kabɨkon nani mani Kus uŋun da yokwi aŋ ɨban butjɨk paŋek kap on Yawe do yagɨt. Yawe Piŋkopno, gak da nak aŋkutnoki do obɨsat. Aŋpulugaŋaki nak aŋsopmaŋgaŋ amɨn da dɨma nɨkba kɨmokgeŋ. Yokwikon naŋ abɨdaŋaki dɨma tasɨk tokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Laion da amɨn dakon gɨpni paŋdagoŋ, uŋun da tɨlak dɨ aŋupbal abam. Ɨlɨk aŋaŋ tɨmɨ kɨndakon aŋkɨŋakwa amɨn da nak yokwikon naŋ arɨpmɨ dɨma dɨ abɨdaŋbam. ");
INSERT INTO yut_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Yawe Piŋkopno, yokwi agɨm dakon gulusuŋno taŋ namɨsak, bo amɨn dɨwarɨ do yokwi aŋ yomgum, ");
INSERT INTO yut_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","bo notno ɨsal dogɨn yokwi aŋ ɨmgum, bo uwalno dakon yo ɨsal dogɨn kabo tɨmɨkgɨm kaŋ, ");
INSERT INTO yut_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","yum pɨndagaki uwalno da nak aŋsopmaŋek abɨdoni. Nak tagɨ bamaŋek obɨsi aŋupbal aŋek gɨptɨmno yɨpba kɨmbabaŋon ɨsal tosak. ");
INSERT INTO yut_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Yawe, pɨdoki! Uwalno da nagon emat tebaisi aŋ. Uŋun butjap nandaŋ yomɨŋek yo yokwisi aŋ yobi. Piŋkopno, aŋpak kɨlegɨ dogɨn galak tosol, do abɨŋek aŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Gak kwensi kɨla amɨn madep yɨtyɨt tamogokon yɨgek mɨŋat amɨn kabɨ morap gak da kapmatjok abɨŋ muwutni do yoyɨki. ");
INSERT INTO yut_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Yawe, mɨŋat amɨn morap dakon aŋpakni kokwin asal, do aŋpulugaŋaki gen pikon teban tokeŋ. Nido, aŋpak kɨlegɨ gat ae aŋpak tagɨsi gat baŋgɨn asat. ");
INSERT INTO yut_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Piŋkop gak wagɨl kɨlegɨsi. Amɨn morap dakon nandak nandak butyo pakyaŋsi pɨndak nandaŋyo asal. Amɨn yokwi aŋpak yokwi saŋbeŋek dɨma ani do kɨrɨŋɨk yobi. Mani amɨn kɨlegɨ paŋpulugaŋaki tebai atni. ");
INSERT INTO yut_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Piŋkop uŋun pasɨkno. Butni kɨlegɨsi amɨn yokwikon baŋ tɨmɨkdak. ");
INSERT INTO yut_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Piŋkop uŋun gen kokwin kɨla amɨn kɨlegɨsi. Gɨldarɨ gɨldarɨ yokwi pakpak do japmɨ nandaŋek pabɨŋ yopmaŋdak. ");
INSERT INTO yut_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Yokwi aŋ amɨn but tobɨl dɨma ani kaŋ, Piŋkop da emat agak sɨbani geni toŋsi asak do ɨlɨtdɨsak, ae obipni paŋɨlɨtdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Amɨn uŋun dapban kɨmotni do dɨkdɨkni kɨlɨ paŋnoman agɨt. Dɨkdɨk mɨleŋ asɨpmɨ toŋ paŋnoman asak. ");
INSERT INTO yut_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Amɨn yokwi uŋun yokwi ak do nandaban teban toŋ. Yokwi mibɨlɨ mibɨlɨ ak do tagap tok asak, ae bɨsapmɨ bɨsapmɨ top yosok. ");
INSERT INTO yut_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Amɨn kɨnda abɨdok do gapma dubagɨ kɨnda wayɨkdak, mani iyɨ uŋun gapma wayɨkdakgwan mosok. ");
INSERT INTO yut_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Gulusuŋ iyɨ asak uŋun da iyɨnaŋ wɨtjɨŋ ɨmɨsak. Ae butjap ematyo amɨn dɨwarɨ do aŋ yom do nandak nandak asak, uŋun da tobɨlek iyɨ naŋ aŋupbal asak. ");
INSERT INTO yut_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Yawe uŋun amɨn kɨlegɨsi, do ya yaŋ iyɨsat. Piŋkop Wukwisi do mani aŋkɨsik do kap yokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Dewit dakon kap kɨnda. Kokup pap Gat dakon gita naŋ tɨdaŋek yogogɨ. Yawe, Amɨn Tagɨnin, mɨktɨmɨ mɨktɨmɨ gak dakon man pɨdaŋbisi. Tɨlɨmgo wukwisi, kundu si yapmaŋdak. ");
INSERT INTO yut_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Gak da man madep gamni do mɨŋat monjɨyo gat ae monjɨ ŋakŋak gat yoyɨŋ dekdal. Man madep gamɨŋakwa uwalgo da gak abɨŋ gep do aŋtɨdok aŋek gen mapmɨt aŋ. ");
INSERT INTO yut_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Kundukon gɨk kanekyo kɨsitgo da wasaŋ kwen yopgul da toŋ uŋun pɨndagek yaŋ nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Mɨŋat amɨnyo nin niaŋen amɨn dɨ baŋ nin do nandak nandak madep asal? Nin yo ɨsalɨsi. Nin dakon kɨla nido kakgɨmansi asal? ");
INSERT INTO yut_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Piŋkop gak da nin gaga da mibɨlgwanjok nipgul. Gak da nin wasaŋek tɨlɨm gat ae man madep gat nimgul. ");
INSERT INTO yut_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Yo morap wasagɨl uŋun nin da kɨlani aneŋ do yaŋ mudagɨl. Uŋun yo morap nin dakon pɨŋbi ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Sipsip bulmakau, ae joŋ bɨt kɨlapyo gat, ");
INSERT INTO yut_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","mɨnam kwen akwaŋ gat, ae tap kɨlap ae yo morap tap kagagwan akwaŋ uŋun kɨsi nin dakon pɨŋbi ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Yawe, Amɨn Tagɨnin, mɨktɨmɨ mɨktɨmɨ gak dakon man pɨdaŋbisi. ");
INSERT INTO yut_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Dewit dakon kap kɨnda. Tek kɨnda mani Almut Laben yaŋ yoŋ tegon da yogogɨ. Yawe, butnokon da ya yaŋsi gayɨkeŋ. Pi tagɨsi morap agɨl uŋun do mɨŋat amɨnyo yoyɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Gak do nandaŋek kɨsɨk kɨsɨk abeŋ. Piŋkop Wukwisi, mango awɨgɨk do kap yokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Uwalno da gandaŋek pasal kwaŋ. Maŋ pagek kɨmak mudoŋ. ");
INSERT INTO yut_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Kɨla amɨn madep yɨtyɨt tamogokon yɨgek gen kokwin kɨlegɨsi asal. Aŋpakno kokwin aŋaki gen pikon teban tosot. ");
INSERT INTO yut_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Mɨktɨmɨ mɨktɨmɨ dɨma nandaŋ gamaŋ amɨn gen tebai yoyɨgɨl. Amɨn yokwi kɨlɨ paŋupbal agɨl, ae dagok dagogɨ mɨni amɨn da ɨŋtaŋ yomdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Uwal wagɨlsi tasɨk tawit. Piŋkop gak da kokup papni kɨlɨ paŋupbal agɨl, ae amɨn da ɨŋtaŋ yomdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Mani Yawe uŋun kɨla amɨn madep dagok dagogɨ mɨni egɨ wɨgɨsak. Uŋun kɨla amɨn madep yɨtyɨt tamonikon yɨgek gen kokwin pi ak do kɨlɨ tagap tagɨt. ");
INSERT INTO yut_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Uŋun aŋpak kɨlegɨkon da mɨŋat amɨn kabɨ morap dakon aŋpakni kokwin akdɨsak. Ae aŋpak tagɨsikon da mɨŋat amɨn kabɨ morap kɨsi kɨla akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Uwalon jɨgɨ paŋ amɨn Yawe da tagɨsi paŋkutnosok. Jɨgɨ bɨsapmon uŋudon kɨŋek pasɨlgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Yawe, mɨŋat amɨnyo gak wɨsɨŋ gandak do pi aŋ amɨn manji dɨma yomɨsal. Yaŋ asal, do mango nandaŋ amɨn egɨp egɨpni gagon tosok yaŋsi nandaŋ. ");
INSERT INTO yut_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Yawe Saion kokup papmon uŋudon kɨla amɨn madep egɨsak. Kap yaŋek mani aŋkɨsini. Amɨn morap kɨsikon pi morap agɨt uŋun do yaŋ teŋteŋok ani. ");
INSERT INTO yut_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Yawe da jɨgɨ paŋ amɨn nandaŋ yomɨsak, ae kunam takba mɨrakni dɨma sopmaŋdak. Yokwi aŋ yomaŋ amɨn do kobogɨ yokwisi yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Yawe, bupmɨ nandaŋ nabi. Uwal da jɨgɨ tepmɨyo namaŋ pɨndakgi. Palɨ kɨmot do asat, do yokwikon naŋ abɨdaŋaki tagɨsi egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Aŋpulugaŋbɨ yo morap agɨl dakon geni tagɨ yaŋek mango awɨgɨkeŋ. Saion kokup pap da wigaron agek yaŋ teŋteŋok aŋek yokwikon naŋ abɨdagɨl uŋun do kɨsɨk kɨsɨk abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Mɨktɨmɨ mɨktɨmɨ dɨma nandaŋ gamaŋ amɨn da nin tɨmɨt do gapma wayaŋ, mani iyɨ uŋungwan moŋ. Nin tɨmɨt do pat yopmaŋ, mani iyɨ uŋun paron yokwalaŋ. ");
INSERT INTO yut_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Yawe dakon gen kokwin pi agakni uŋun kɨlegɨsi yaŋ uŋun amɨn da nandaŋ ɨmaŋ. Amɨn yokwi amɨn dɨwarɨ paŋupbal ak do yo awit, mani uŋun yo yokwi da tobɨlek iyɨ baŋ paŋupbal awit. ");
INSERT INTO yut_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Piŋkop manji ɨmɨŋek yokwi aŋ amɨn morap uŋun kɨmakbi kokupmon paŋkɨ egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Bɨsapmɨ bɨsapmɨ Piŋkop da yoni mɨni amɨn dɨma ɨŋtaŋ yomɨsak. Jɨgɨni madepsi toŋ amɨn, uŋun Piŋkop da paŋpulugosak do nandaŋ gadat aŋek jomjom aŋ. Uŋun yum pɨndagakwan ɨsal dogɨn jomjom dɨma aŋ. ");
INSERT INTO yut_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Yawe, apbi. Yum pɨndagaki mɨktɨm amɨn da teban taŋek dɨma abɨŋ gepni. Mɨktɨmɨ mɨktɨmɨ amɨn dɨma nandaŋ gamaŋ uŋun gaga da ɨŋamon yopmaŋek gen kokwin aŋ yobi. ");
INSERT INTO yut_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Yawe, paŋpasol aŋaki madepsi pasolni, ae iyɨ do nin mɨktɨm amɨn gɨn yaŋsi nandani. ");
INSERT INTO yut_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Yawe, gak nido nak da dubagɨkon egɨsal? Bɨsap yokwikon gak nido pasɨl namɨsal? ");
INSERT INTO yut_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Amɨn yokwi iyɨ do nandaba wɨgakwa yoni mɨni amɨn paŋupbal ak do yolgaŋ. Amɨn dɨwarɨ yokwi aŋyom do nandak nandak aŋ, uŋun yo yokwi iyɨ tɨmɨkgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Amɨn yokwi galaktok yokwini do nandaŋek pɨbɨt tɨdok asak. Yo morapmɨ tɨmɨt do nandaŋ amɨn paŋkɨsisak, ae Yawe ɨbɨpmaŋdak. ");
INSERT INTO yut_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Amɨn yokwi iyɨ do nandaban wɨgakwan Piŋkop wɨsɨŋ kok do pi dɨma asak. Piŋkop do nandaban yo ɨsalɨ asak. ");
INSERT INTO yut_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Yo morap aban tagɨsi noman toŋ. Yawe, gak dakon nandak nandak kɨndasok dɨmasi nandɨsak. Uŋun da uwalni do manji gen yaŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Yaŋ nandɨsak, “Nak arɨpmɨ dɨma mokeŋ. Bɨsapmɨ bɨsapmɨ yo dɨ da nak arɨpmɨ dɨma abɨŋ nepni.” ");
INSERT INTO yut_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Bɨsap morap amɨn jobɨt yomɨsak, ae top gen yosok, ae amɨn dap do yosok. Yokwi ak do ae jɨgɨ paŋalon ak do gen tepmɨsi yosok. ");
INSERT INTO yut_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Uŋun kokupmon pasɨlɨ egek amɨn gulusuŋni mɨni amɨn apba dapban kɨmotni do jomjom asak. Uŋun si pasɨlek amɨn tapmɨmni mɨni paŋupbal ak do yubɨŋ egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Laion da yaŋ pasɨlɨkon yɨgek kɨla tebai asak. Uŋun pasɨl yɨgek tapmɨmni mɨni amɨn paron yokwalban ɨlɨk paŋkɨsak. ");
INSERT INTO yut_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Aŋakwan uŋudon gɨn tapmɨmni mɨni amɨn tasɨk toŋ. Amɨn yokwi dakon tapmɨm madepni da pabɨŋ yopmaŋdak. ");
INSERT INTO yut_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Amɨn yokwi da yaŋ nandɨsak, “Piŋkop da nak ɨŋtaŋ namgut. Iyɨ dakon dabɨl kɨlɨ sopgut, do dɨma nandɨsak.” ");
INSERT INTO yut_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Yawe, abɨŋ yokwi pakpak amɨn kobogɨ yokwi aŋyobi. Piŋkop, amɨn jɨgɨni toŋ uŋun dɨma ɨŋtaŋ yobi. ");
INSERT INTO yut_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Yokwi pakpak amɨn da nido Piŋkop do yaŋba yokwi tok aŋ? Ae nido “Piŋkop da kobogɨ yokwi dɨma nimdɨsak” yaŋ nandaŋ? ");
INSERT INTO yut_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Mani gak da yokwi pakpak amɨn dakon aŋpak pɨndak mudosol. Aŋpak yokwi aba amɨn dɨwarɨ da tepmɨ paŋ uŋun pɨndagek kobogɨ yokwi yomɨsal. Jɨgɨ nandaŋ amɨn gak da paŋpulugoki do burɨ gagon yopmaŋgaŋ. Meŋ datyoni kɨmakbi amɨn gak da tagɨsi paŋpulugosol. ");
INSERT INTO yut_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Yokwi pakpak dakon tapmɨm pabɨŋ yopmaŋek aŋpak yokwini buŋon ae dɨma pɨndakgi. ");
INSERT INTO yut_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Yawe dagok dagogɨ mɨni kɨla amɨn madep egɨ wɨgɨkdɨsak. Piŋkop ŋwakŋwarɨ gawak yomaŋ amɨn mɨktɨmnikon baŋ yolban tasɨk tokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Yawe, gak jɨgɨni toŋ amɨn dakon bɨsit nandaŋek burɨ paŋteban akdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Meŋ datyoni kɨmakgwit amɨn gat ae uwalon jɨgɨ tɨmɨkgaŋ amɨn gat dakon bɨsitni nandaŋ yomdɨsal. Paŋpulugaŋaki gen pikon atni bɨsapmon teban tokdaŋ. Ae mɨktɨmon mɨŋat amɨnyo da saŋbeŋek yo yokwi dɨma aŋyomdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","2","Dewit dakon kap kɨnda. Kap on kap yoŋ dakon kɨla amɨn do mandabi. Nak aŋkutnosak do Yawekon kɨsat. Do gak nido yaŋ nayɨsal, “Amɨn yokwi obipni paŋɨlɨkgaŋ! Pɨlɨn tukgwan amɨn kɨlegɨ yam do dɨkdɨkni bɨsapmon sambaŋ! Do mɨnam kɨnda da yaŋ pasalek kabapgwan wɨgɨ! ");
INSERT INTO yut_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Aŋpak kɨlegɨ dakon teban tokni kɨsi tuwɨl kɨ mudoni kaŋ, amɨn kɨlegɨ niaŋ ani?” ");
INSERT INTO yut_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Mani Yawe telagɨ yutnikon egɨsak. Kwen Kokup kɨla amɨn madep egek dabɨlɨ da amɨn morap kɨsi pɨndakdak. Yo morap aŋ uŋun kɨsisi nandaŋ mudosok. ");
INSERT INTO yut_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Yawe da amɨn kɨlegɨ ae amɨn yokwi kakgɨmansi kokwin asak. Emat do galak toŋ amɨn dɨmasi galak taŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Amɨn yokwi do kɨndap tepmɨsi sosok uŋun tagal yomɨsak. Aŋek gɨptɨmni obɨsi soŋ yomni do mɨrɨm tepmɨsi sosok uŋun yɨpban abɨsak. Uŋun yokwi awit dakon kobogɨni. ");
INSERT INTO yut_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Yawe aŋpak kɨlegɨ gɨn asak. Aŋpak kɨlegɨ aŋ amɨn do but dasi galak taŋ yomɨsak. Aŋpak kɨlegɨ aŋ amɨn uŋun da tomno dabɨlni kokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Dewit dakon kap kɨnda. Yawe, gak gawak gamaŋ amɨn pasɨl mudaŋ. Gak golgaŋ amɨn kɨnda dɨma kokdɨsal, do abɨŋ nak aŋpuluga. ");
INSERT INTO yut_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Amɨn morap kɨsi amɨn dɨwarɨkon top yoŋ. Paŋkewal do gen galagɨ yoyaŋ. ");
INSERT INTO yut_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Yawe, gak da gen galagɨ yoŋ amɨn dakon gen kagani sopbi. Ae pɨbɨt tɨdok aŋ amɨn dakon gen kagani sopbi dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Uŋun amɨn da yaŋ yoŋ, “Top gen yaŋek teban toneŋ. Nin da galak togon gen yokdamaŋ. Amɨn kɨnda da kosit dɨma sopmaŋ nimjak.” ");
INSERT INTO yut_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Mani Yawe da yaŋ yosok, “Amɨn yokwi da tapmɨmni mɨni amɨn pabɨŋ yopmaŋgaŋ, ae yoni mɨni amɨn iyoŋ iyoŋ yaŋek ekwaŋ. Do nak da abɨŋ paŋpulugokeŋ. Uŋun nak da paŋkutnokeŋ do yoŋ, do yaŋsi akdɨsat.” ");
INSERT INTO yut_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Yawe dakon yaŋ teban tok gen uŋun bamɨsi. Uŋun silwa kɨndapmon kosirɨ 7 yaŋ soŋba jɨmjɨmɨ mɨnisi aŋ, uŋun yombem wagɨl tagɨsi. ");
INSERT INTO yut_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","8","Yawe, amɨn yokwi uŋun dukwan dukwan kɨsi agek aŋpak ɨŋani uŋun do yo tagɨsi yaŋ nandaŋ. Do bɨsapmɨ bɨsapmɨ kɨlanin tagɨsi aŋaki amɨn yokwi da nin dɨma paŋupbal ani. ");
INSERT INTO yut_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Dewit dakon kap kɨnda. Kap on kap yoŋ dakon kɨla amɨn do mandabi. Yawe, ni bɨsapmon aego nandaŋ nabi? Nak do dagok dagogɨ mɨni ɨŋtaŋ namɨŋ wɨgɨkdɨsal bo? Gak bɨsap niaŋ da pasɨl namɨŋaki dɨma gandakeŋ? ");
INSERT INTO yut_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Bɨsap niaŋ da butnokon da tepmɨ pasat uŋun sigɨn pakeŋ? Gɨldat niaŋ da but yokwino sigɨn tosak? Bɨsap niaŋ da uwalno da sigɨn abɨŋ nepni? ");
INSERT INTO yut_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Yawe Piŋkopno, nandaŋ namɨŋek bɨsitno nandaki. Dɨma aŋteban aki kaŋ, nak kɨmokgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Yaŋ aŋaki kaŋdo uwalno da “kɨlɨ abɨŋ yɨpmamaŋ” yaŋ dɨma yoni. Ae nak da maŋ pokgo kaŋek kɨsɨk kɨsɨk dɨma ani. ");
INSERT INTO yut_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Mani bɨsapmɨ bɨsapmɨ but dasi galak taŋ namɨsal yaŋsi nandako dagosok. Ae jɨgɨkon baŋ aŋpulugosol, do gak do kɨsɨk kɨsɨk abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Yawe da nak do yo tagɨsi agɨt, do mani awɨgek kap yokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Dewit dakon kap kɨnda. Kap on kap yoŋ dakon kɨla amɨn do mandabi. Nandaŋ kokwini tagɨ dɨma amɨn burɨkon da yaŋ yoŋ, “Piŋkop kɨnda dɨma egɨsak.” Uŋun amɨn yokwisi. Yo wagɨl yokwisi baŋ gɨn aŋ. Kɨnda da aŋpak tagɨ kɨnda dɨma asak. ");
INSERT INTO yut_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Yawe uŋun Kwen Kokup da sɨŋtaŋban pɨŋakwan mɨŋat amɨn morapyo pɨndakdak. Uŋun da amɨn kɨnda nandak nandakni tagɨsi kɨnda Piŋkop wɨsɨŋ kok do pi asak bo dɨma yaŋ do wɨsɨsak. ");
INSERT INTO yut_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Mani dɨma. Kɨsi morap kosit kɨlegɨ kɨlɨ yɨpmaŋ dekgwit. Uŋun amɨn wagɨl amɨn yokwisi, kɨsi morap arɨp gɨn. Kɨndasok da aŋpak tagɨsi kɨnda dɨmasi asak. ");
INSERT INTO yut_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Piŋkop da yaŋ yosok, “Yokwi aŋ amɨn nandak nandak tagɨ dɨ dɨmasi tɨmɨtdaŋ. Bret naŋba mudoŋ, uŋun da tɨlak mɨŋat amɨno naŋ mudoŋ. Ae nak da paŋpulugokeŋ do bɨsit dɨma aŋ namaŋ.” ");
INSERT INTO yut_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Mani Piŋkop mɨŋat amɨnyo geni guramɨkgaŋ amɨn gat egɨsak, do amɨn yokwi uŋun madepsi pasoldaŋ. ");
INSERT INTO yut_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Yoni mɨni amɨn da yo ak do paŋkosit aŋ uŋun tuwɨl do pi aŋ. Mani yoni mɨni amɨn Yawe da paŋkutnosok. ");
INSERT INTO yut_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Nak Piŋkop da Saion amɨn kɨnda yabekban abɨŋ Israel amɨn yokwikon baŋ tɨmɨtjak do nandɨsat. Yawe da mɨŋat amɨni paŋpulugaŋban aeni tagɨsi egɨpni bɨsapmon, Israel amɨn kɨsɨk kɨsɨk akdaŋ. Asi, but galaksi egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Dewit dakon kap kɨnda. Yawe, namɨn da gak da telagɨ yutgwan tagɨ wɨgɨsak? Telagɨ kabapgokon namɨn da tagɨ egɨpjak? ");
INSERT INTO yut_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Amɨn kɨnda suŋ kɨnda aban amɨn da yaŋba yokwi tok dɨma aŋ ɨmgwit, ae aŋpakni kɨlegɨsi, ae burɨkon da nandaŋek gen bamɨ gɨn yosok, uŋun amɨn da tagɨ egɨpjak. ");
INSERT INTO yut_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Amɨn do yaŋba yokwi tok dɨma asak, ae notni do aŋpak yokwi dɨma aŋyomɨsak, ae notni do top dɨma yaŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Yokwi pakpak amɨn do dɨma galak taŋek Yawe do pasolgoŋ amɨn do nandaban wukwan yomɨsak. Yaŋ teban tok asak uŋun jɨgɨ noman taŋ ɨmaŋ bɨsapmon dɨma kɨrɨŋɨgek geni guramɨk kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Amɨn da goman aŋ ɨba dɨ gat saŋbeŋek ɨmni do dɨma yosok. Ae amɨn da topni paŋteban aŋek si yumaŋ naŋakwa amɨn kɨlegɨ gen pikon yop do aba geni dɨma nandaŋ yomɨsak. Uŋun aŋpak kɨlegɨ morap yolgaŋ amɨn uŋun dagok dagogɨ mɨni arɨpmɨ dɨma mokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Dewit dakon kap kɨnda. On kap do “Miktam” yaŋ yoŋ. Piŋkop, aŋkutnoki do gagon obɨsat, do kɨlano aki. ");
INSERT INTO yut_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Nak Yawe yaŋ iyɨgɨm, “Gak Amɨn Tagɨno. Yo tagɨsi morap tɨmɨkdat uŋun gak da kɨsiron dagɨn abaŋ.” ");
INSERT INTO yut_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Piŋkop dakon amɨn uŋun tagɨsi. Nak uŋun gat egɨp do tagɨsi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Amɨn tɨmtɨm yaŋek piŋkop ŋwakŋwarɨkon kwaŋ uŋun jɨgɨ morapmɨ pakdaŋ. Nak paret ak do bɨt kɨlapyo dakon yawi tagal do uŋun gat dɨma muwutneŋ, ae piŋkopni dakon man dɨma yokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Yawe, gak kaloŋ gɨn nak dakon yo morapno. Yo morapno gak da kɨsiron gɨn toŋ. Yo morapno paŋkutnaŋ namɨsal. ");
INSERT INTO yut_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Mɨktɨmno gat ae yo tagɨsi morap gat gagon gɨn tɨmɨkdat. Asisi, yo morap namɨsal uŋun wagɨl tagɨsi. ");
INSERT INTO yut_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Yawe aŋkɨsikeŋ. Uŋun da tagɨsi egɨpbeŋ do nayɨŋ nolɨsak. Ae kalbi butno da nayɨŋ dekdak. ");
INSERT INTO yut_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Bɨsapmɨ bɨsapmɨ Yawe nak da kapmatjok ekwan nandɨsat. Kapmatjok egek tapmɨm namɨsak, do yo kɨnda da arɨpmɨ dɨma aŋkwakwalɨtjak. ");
INSERT INTO yut_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","10","Yum nandaŋaki nak kɨmakbi kokupmon arɨpmɨ dɨma paŋkɨ egɨpbeŋ. Aŋek gak dakon Telagɨ Amɨn yum kaŋaki kɨmakbi tamokon taŋ dɨma mɨktosak. Yaŋdo, butno tagɨsi aŋakwan mango yaŋ aŋkɨsisat. Pasol pasolɨ mɨni tagɨsi egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Gak da egɨp egɨp dakon kosit nolɨsal. Gak nak da kapmatjok egɨsal, do kɨsɨk kɨsɨk madepsi asat. Ae aŋpulugaŋaki butno kɨsɨk kɨsɨk taŋakwan dagok dagogɨ mɨni yaŋgɨn taŋ aŋaŋ kɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Dewit dakon kap kɨnda. Yawe, nak amɨn kɨlegɨ, do aŋpulugaŋek nandaŋ nabi do yaŋ tɨdosot. Nak top amɨn dɨma, do bɨsitno nandaki do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Ni aŋpak da kɨlegɨ uŋun gak da nandɨsal, do aŋpulugaŋaki gen pikon teban tokeŋ dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Gak da nak dakon but nandaŋ mudosol. Kalbi abɨŋ aŋkɨlɨk nandaŋek nagon nandak nandak yokwi kɨnda dɨma taŋban kal. Gen yokwi kɨnda dɨma yokeŋ dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Gen tebango guramɨgek emat pɨdokyo aŋ amɨn dakon aŋpak manji yomgum. ");
INSERT INTO yut_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Bɨsapmɨ bɨsapmɨ gak dakon kosit naŋ agek kandapno suŋ dɨma pɨlɨk bamosot. ");
INSERT INTO yut_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Piŋkop, gak da bɨsitno dakon kobogɨ namɨsal. Uŋun do aŋek gak do bɨsit asat. Mɨrak yopmaŋek bɨsitno nandaki. ");
INSERT INTO yut_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Nin do but dasi galak taŋ nimɨsal, uŋun dakon bamɨ nolɨŋek yo tagɨsi aŋnibi. Tapmɨm madepgokon da nin paŋpulugosol. Nin gak da kapmatjok egek uwalnin da dɨma nindani do pasɨlgamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Gaga dakon dabɨlgo kɨla asal uŋudeŋ kɨlano aki. Pup meŋi da pudɨgɨ pɨrɨgwan wutjɨsak uŋun da tɨlak nak wutjɨki. ");
INSERT INTO yut_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Yaŋ aŋaki kaŋdo uwalno da nak arɨpmɨ dɨma aŋupbal ani. Nɨkba kɨmokgeŋ do aŋdɨgat aŋ. ");
INSERT INTO yut_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Amɨn dɨwarɨ do nandaŋ yawotjok dɨ dɨmasi aŋ yomaŋ. Gen pap yaŋek iyɨ dakon man pawɨkwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Nak abɨŋ nepdosi nandaŋ teban taŋ, do kandap tamono yolek aŋdɨgat ayɨŋ da ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Uŋun laion da kɨlap dap do aŋ uŋun da tɨlak, ae laion bulagɨ da pasɨlek yubɨŋ ekwaŋ uŋun da tɨlak. ");
INSERT INTO yut_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Yawe, gak abɨŋ uwalno gat emat wamaŋek pabɨŋ yopbi. Emat agak sɨbago abɨdaŋek uŋun gat emat wamaŋek yokwi pakpak da kɨsiron baŋ abɨdoki. ");
INSERT INTO yut_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Yawe, tapmɨm madepgokon da aŋpulugaŋaki uwalno da dɨma nɨkba kɨmokgeŋ. Uŋun mɨktɨm dakon yo baŋgɨn paŋmuwut do nandaŋ. Aŋpak yokwini dakon kobogɨ yo yokwisi aŋ yobi. Ae monjɨni gat ae babɨkni don altoni uŋun yo yokwisi aŋyobi. ");
INSERT INTO yut_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Mani nak amɨn kɨlegɨ, do don gandakdɨsat. Pokdot da pɨdosot bɨsapmon gak nak gat egɨsal yaŋ nandaŋek but galaksi nandakeŋ. ");
INSERT INTO yut_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Dewit Yawe dakon oman amɨni dakon kap kɨnda. Kap dakon kɨla amɨn do mandagɨt. Kap on Yawe da Dewit Sol ae uwalni dɨwarɨ morap da kɨsiron baŋ abɨdagɨt bɨsapmon Yawe do yagɨt. Yawe, gak da nak aŋteban asal. Nak but dasi galak taŋ gamɨsat. ");
INSERT INTO yut_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Yawe uŋun tɨp madepno, uŋun da nak aŋkɨsɨbɨsak. Uŋun dam tebano arɨpmɨ dɨma tuwɨlɨ egɨsak. Aŋek uwal da kɨsiron naŋ abɨdosok. Piŋkopno uŋun tɨp madepsi yombem, do uwalno da dɨma nandani yaŋ do uŋudon kɨŋ pasɨldat. Yawe uŋun pasɨkno, ae yokwikon naŋ abɨdaŋek kɨlano asak dakon tapmɨm taŋ ɨmɨsak. Uŋun dam tebano. ");
INSERT INTO yut_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Nak Yawe do bɨsit asat. Aŋpulugaŋakwan uwalno da arɨpmɨ dɨma aŋupbal ani. Yawe uŋun aŋkɨsigɨsi noman. ");
INSERT INTO yut_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Nap teban da nak tebaisi wamaŋdak, ae tap ɨdap da nak wɨtjɨk do madepsi tamalɨkdak, uŋun da tɨlak kɨmot da nak palɨsi abɨdagɨt. ");
INSERT INTO yut_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Paron yokwalek arɨpmɨ dɨma pulugaŋ kɨgɨ, uŋun da tɨlak kɨmot da nak abɨdaŋban kɨmakbi tamokon palɨsi kɨgɨm. ");
INSERT INTO yut_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Butno madepsi yokwi tagɨt, mani Yawe do madepsi yaŋ tɨdagɨm. Piŋkop da aŋpulugosak do yaŋ tɨdoko Telagɨ Yutnikon egek yaŋ ɨlɨtno nandagɨt. Aŋek bɨsitno do mɨrak yopgut. ");
INSERT INTO yut_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Bɨsitno nandaŋek uwalno do butjap madepsi nandaŋ yomgut. Aŋek mɨktɨm aban wudɨp madepsi agɨt. Aŋakwan ɨleŋ dakon mibɨlɨ madepsi kwakwalɨkgwit. ");
INSERT INTO yut_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Mukwa Yawe da tomnokon da pɨdawit. Aŋakwan mɨleŋ asɨp gen kaganikon da baljaŋek yo morapmɨ sowit. Aŋakwan kɨndap patdet yaban dukwan dukwan kɨsi kɨwit. ");
INSERT INTO yut_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Uŋun kundu wɨtdalek pɨgɨt. Aŋakwan gɨkwem pɨlisi da kandapni da mibɨlgwan tawit. ");
INSERT INTO yut_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Uŋun aŋelo madep serabim kɨnda da kwenon yɨkban pɨrɨropmaŋ abɨgɨt. Ae mɨrɨm mɨnam da yaŋ pɨrɨ toŋ da Piŋkop abɨdaŋ tepmɨsi abɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Uŋun da pɨlɨn tuk yɨpban kubɨkgɨt. Gɨkwem pɨlisi sɨkak mok do aŋakwan wamaŋdak uŋun da wɨtjɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Uŋun da gɨkwem aban teŋteŋɨsi aŋakwa ais sɨkak gat kɨndap patdet gat uŋun gɨkwemgwan da mawit. ");
INSERT INTO yut_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Yawe Kwen Kokup egek kɨrɨrɨŋ da yaŋ madepsi yaŋ tɨdagɨt. Piŋkop Wukwisi da madepsi yaŋ tɨdagɨt. ");
INSERT INTO yut_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Uŋun da aban mal da dɨkdɨkni da yaŋ uwalni yaban pasal kɨwit. ");
INSERT INTO yut_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Yawe, gen tebai yɨpmaŋaki tap dakon mibɨlɨ noman tagɨt. Mɨgan pɨsoŋbɨ mɨktɨm dakon mibɨlɨ noman tagɨt. ");
INSERT INTO yut_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Yawe kwen egɨsak uŋun kɨsirɨ yɨpban pɨŋakwan nak yokwikon baŋ abɨdagɨt. Tap madep da nak wɨtjɨgɨt, mani ɨlɨkban wɨgɨm. ");
INSERT INTO yut_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Uwalno da madepsi teban taŋakwa nak da arɨpmɨ dɨmasi pabɨŋ yopmɨ, mani Yawe da nak uŋun da kɨsiron baŋ abɨdagɨt. ");
INSERT INTO yut_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Bɨsap yokwi kɨnda noman taŋ namɨŋakwan uwalno abɨŋ nagon emat awit. Mani Yawe da kɨlano agɨt. ");
INSERT INTO yut_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Uŋun da aŋ pulugaŋakwan tagɨsi egɨpgum. Tagɨsi nandaŋ namgut do aŋek nak yokwikon naŋ abɨdagɨt. ");
INSERT INTO yut_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Nak aŋpak kɨlegɨsi agɨm, do Yawe da kobogɨ do yo tagɨsi morapmɨ namgut. Suŋ kɨnda dɨma agɨm do aŋek Piŋkop da yo tagɨsi aŋ namgut. ");
INSERT INTO yut_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Yawe dakon gen teban tagɨsi yol kɨmakgɨm. Piŋkopno manji ɨmɨŋek yokwi dɨma agɨm. ");
INSERT INTO yut_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Bɨsapmɨ bɨsapmɨ gen tebani do nandaŋek geni tagɨsi uŋun dɨma abɨŋ yɨpgum. ");
INSERT INTO yut_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Uŋun da nandɨsak, nak gulusuŋno mɨni. Kosit agɨpgum uŋun kɨla tebai aŋek yokwi kɨnda dɨma agɨm. ");
INSERT INTO yut_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Dabɨlnikon gwaljɨgɨ mɨnisi egɨpgum, do Yawe da aŋpakno kɨlegɨ uŋun do nandaŋek kobogɨ do aŋpak tagɨsi aŋ namgut. ");
INSERT INTO yut_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Yawe, amɨn kɨnda gak dɨma gepmaŋdetjak kaŋ, gak uŋun amɨn dɨma yɨpmaŋ detdɨsal. Amɨn kɨnda aŋpak kɨlegɨ aŋek gulusuŋni mɨni kaŋ, kobogɨ do yo tagɨsi gɨn aŋ ɨmdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Amɨn kɨnda aŋpak gwaljɨgɨ mɨni asak kaŋ, gak da aŋpakgo gwaljɨgɨ mɨni uŋun yolɨsal. Mani amɨn kɨnda aŋpak yokwi asak kaŋ, kakgɨmansi kaŋek kobogɨ ɨmɨsal. ");
INSERT INTO yut_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Gak da mɨŋat amɨnyo iyɨ do nandaba paŋ amɨn yokwikon baŋ tɨmɨkdal. Mani iyɨ do nandaba wɨkwaŋ amɨn pabɨŋ yopmaŋdal. ");
INSERT INTO yut_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Yawe Piŋkop, gak da lamno yɨpbɨ teŋteŋosok, aŋek nagon pɨlɨn tuk yoldal. ");
INSERT INTO yut_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Piŋkop, aŋpulugaŋaki uwal kabɨ madep uŋun arɨpmɨ tagɨ pabɨŋ yopbeŋ. Ae aŋteban aŋaki kokup pap dakon dam madep arɨpmɨ tagɨ ɨrakgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Piŋkop dakon aŋpak uŋun wagɨl kɨlegɨsi. Yo kɨnda ak do yaŋ teban tok asak kaŋ, geni uŋun bamɨ noman tokdaŋ. Yawe uŋun pasɨk yombem, do amɨn morap uwal da dɨma pɨndatni yaŋ do uŋudon kɨŋ pasɨlakwa tagɨsi paŋkutnosok. ");
INSERT INTO yut_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Yawe kaloŋgɨn Piŋkop bamɨsi. Uŋun kaloŋ dagɨn tɨp madep da yaŋ dam aŋnimɨsak. ");
INSERT INTO yut_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Piŋkop dagɨn nak aŋteban aŋakwan tebai akdat. Ae kosit agɨsat bɨsapmon kɨlano tagɨsi asak. ");
INSERT INTO yut_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Joŋ kɨlap dia uŋun kandapmɨ tagɨsi do gɨlokon arɨpmɨ dɨma mosak, uŋun da arɨpmon aŋpulugaŋakwan ɨleŋon kwensi tagɨsi agɨsat. ");
INSERT INTO yut_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Uŋun da emat agak do nayɨŋ degek kɨsitno aŋteban asak, do obip tebai ain kɨnda mani bras uŋun baŋ wasaŋbi uŋun tagɨ paŋɨlɨkgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Yawe, gak da nak uwal da kɨsiron baŋ abɨdagɨl. Pasɨkgo nabɨ uŋun da manjigwan pasɨldat. Kɨsitnokon abɨdaŋaki tebai akdat. Aŋpulugosol, do mɨŋat amɨnyo da dabɨlon man madepno toŋ. ");
INSERT INTO yut_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Kosit ɨlalogɨ naŋ yul namgul, do sagalek dɨma nɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Nak uwal paŋsopmaŋek tɨmɨkgɨm. Yo yokwisi aŋyomɨŋek wagɨl kɨsisi dapbo pasɨlgwit. ");
INSERT INTO yut_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Nak da yabo maŋ pakgwit. Kandap mibɨlnogwan pakgwit, do arɨpmɨ dɨma pɨdokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Gak da emat dakon tapmɨm namgul, aŋek uwal kɨsitnokon yopmaŋaki pabɨŋ yopgum. ");
INSERT INTO yut_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Aŋaki uwal tobɨl manji namɨŋek pasal kɨwit. Amɨn dɨma galak taŋ namgwit uŋun wagɨl dapbo pasɨlgwit. ");
INSERT INTO yut_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Amɨn da paŋpulugonisi do yaŋ tɨdawit, mani dɨma apgwit. Yawe do kunam takgwit, mani bɨsitni dɨma nandaŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Mɨrɨm da mɨlɨp mɨlɨp pɨsoŋba dukwan dukwan kwaŋ, uŋun da tɨlak obɨsi paŋupbal agɨm. Uwal mabo kɨŋek neŋak da yaŋ kosiron tawit. ");
INSERT INTO yut_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Mɨŋat amɨnyo da uwal aŋ namgwit bɨsapmon, aŋpulugaŋaki dɨma aŋupbal awit. Aŋek Amɨn Ŋwakŋwarɨ Kabɨ dakon mibɨltok amɨni egɨpbeŋ do nak manjɨgɨl. Mɨŋat amɨnyo dɨma nandaŋ yomgum, abɨsok nak da yoŋgamgwan ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Uŋun da mibɨlno nandaŋek uŋudon gɨn geno guramɨkgaŋ. Mɨktɨm dubagɨkon amɨn da nak do pasalek abɨŋ ŋwakbeŋ aŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Tapmɨm pawit uŋun kɨlɨ yɨpba magɨt, ae kokup papni tapmɨmɨ toŋ uŋun yɨpmaŋ degek si nɨmnɨmɨk nɨmnɨmɨk nagon obaŋ. ");
INSERT INTO yut_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Yawe uŋun toktogɨsi egɨsak. Uŋun tɨp madep da yaŋ nak dam asak, do mani aŋkɨsineŋ. Piŋkop da nak yokwikon naŋ abɨdagɨt, do nin man madepni awɨgɨneŋsi. ");
INSERT INTO yut_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Piŋkop da uwalno yokwini dakon kobogɨ do yokwi aŋ yomɨsak. Aŋek amɨn kabɨ mɨktɨmɨ mɨktɨmɨ ekwaŋ uŋun yopban nak da yoŋgamgwan ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Yaŋ aŋek uwalno da kɨsiron naŋ abɨdosok. Asisi, Yawe gak da uwalno da dabɨlon man madep namgul. Aŋpulugaŋaki emat pɨdokyo aŋ amɨn da dɨma nɨkba kɨmakgɨm. ");
INSERT INTO yut_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Uŋun do aŋek Amɨn Ŋwakŋwarɨ Kabɨ da binapmon mango awɨgɨkeŋ. Yawe, mango awɨgɨk do kap yokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Yawe da kɨla amɨn madepni nak Dewit aŋ pulugaŋakwan uwal madepsi pabɨŋ yopmaŋdat. Bɨsapmɨ bɨsapmɨ iyɨ do tɨlak agɨt amɨn nak but dasi galak taŋ namɨsak. Ae dagok dagogɨ mɨni dɨwatno don altoni uŋun but dasi galak taŋ yomdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Dewit dakon kap kɨnda. Kap on kap yoŋ dakon kɨla amɨn do mandabi. Kundu da Piŋkop dakon tɨlɨmni nolɨsak. Kwen yo morap da Piŋkop uŋun napbɨsap amɨnsi yaŋ nolɨsak. ");
INSERT INTO yut_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Gɨldarɨ gɨldarɨ man madepni do yoŋ. Ae pɨlɨni pɨlɨni mibɨlni yaŋakwa nandamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Teŋteŋɨ gat pɨlɨn tuk gat gen kagani mɨni, do gen arɨpmɨ dɨma yonjil. Nin da uŋun bamot dakon tekni dɨma nandamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Mani uŋun da mɨktɨm amɨn morap kɨsi yoyɨŋ dekgamal. Geni kɨŋ mɨktɨm morap kɨsi arɨpmɨ asak. Kundukon Piŋkop da gɨldat do ɨmal yut kɨnda wɨtjɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Gɨldat dabɨl uŋungwan da amɨn kɨnda da mɨŋat paŋek but galagon da yutni yɨpmaŋek waŋga pɨsak, uŋun da tɨlak waŋga pɨsak. Gɨldat dabɨl uŋun amɨn kɨnda da napbɨ gwapbo do tɨmtɨm yaŋek kɨk do asak, uŋun da tɨlak kɨsɨk kɨsɨk aŋek kositni naŋ kɨsak. ");
INSERT INTO yut_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Gɨldat dabɨl uŋun kundu dakon dɨwarɨkon da altaŋ wɨŋek terɨ kɨnda kɨsak. Tedepnikon yo kɨnda arɨpmɨ dɨma pasɨljak. Piŋkop dakon geni uŋun wagɨl tagɨsi ");
INSERT INTO yut_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Yawe dakon nawa gen uŋun gwaljɨgɨ mɨni wagɨl tagɨsisi. Uŋun da egɨp egɨpnin paŋkaluk asak. Yawe dakon gen uŋun bamɨ taŋ taŋ akdaŋ gɨn, dɨma suŋ tokdaŋ. Uŋun da nandak nandakni mɨni amɨn paŋtagap aban nandaŋ kokwini tagɨsi amɨn dagoŋ. ");
INSERT INTO yut_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Yawe dakon geni tagɨsi uŋun abɨdaŋek but galaksi nandamaŋ. Yawe dakon gen tebani uŋun gwaljɨgɨ mɨnisi. Uŋun da nandak nandak tagɨsi nimɨsak. ");
INSERT INTO yut_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Yawe do pasalek gawak ɨmɨm uŋun aŋpak tagɨsi kɨnda, don taŋ aŋaŋ kɨkdɨsak. Yawe da aŋpak aneŋ do niyɨsak uŋun bamɨsi ae kɨlegɨsi gɨn. ");
INSERT INTO yut_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Yawe dakon geni da gol morapmɨ gwaljɨgɨ mɨni yapmaŋdak, do nin uŋun do madepsi galak tomaŋ. Galagɨni madepsi da kabaŋ kok tamonikon da moŋ uŋun dakon galagɨni yapmaŋdak. ");
INSERT INTO yut_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Nak oman amɨngo mama gengo guramɨgek kobogɨ tagɨsi tɨmɨkdat. ");
INSERT INTO yut_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Namɨn da iyɨ dakon aŋpak yokwini morap nandɨsak? Yokwi dɨwarɨ dɨma nandaŋek asat uŋun wɨrɨrɨkbɨ kɨlegɨsi egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Ae uŋun gɨn dɨma, aŋpak yokwi yaŋ dɨno nandaŋek dɨma abeŋ do oman monjɨgo kɨlano aki. Kwen wɨgɨk aŋpak da nak dɨma abɨŋ nepjak do nandɨsat. Nak kɨlegɨsi egek yokwi madep dɨma abeŋ do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Yawe, gen yogokno ae nandak nandakno kɨsi gak da pɨndakbɨ tagɨsi ani dosi nandɨsat. Yawe, gak tɨp madepno, ae yokwikon baŋ yumaŋ naŋ nepnep amɨno. ");
INSERT INTO yut_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Dewit dakon kap kɨnda. Kap on kap yoŋ dakon kɨla amɨn do mandabi. Jɨgɨ noman taŋ gamni bɨsapmon Yawe da gak aŋpulugosak dosi nandɨsat. Jekop dakon Piŋkop da gak aŋkutnosak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Uŋun telagɨ yutnikon Saion kokup papmon egɨsak. Uŋun da gak aŋpulugaŋek aŋteban asak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Uŋun da paret morap asal uŋun do tagɨ nandɨsak dosi nandɨsat. Ae paret morapgo kɨndapmon sosol uŋun do galak tosak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Piŋkop da yo morap galak tosol uŋun gamjak, ae pi morap ak do nandɨsal uŋun da aŋpulugaŋakwan arɨpmɨ tagɨ abi dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Emaron teban toki bɨsapmon kɨsɨk kɨsɨk aneŋ, ae Piŋkopnin dakon man awɨgɨneŋ. Yawe da bɨsit morapgo nandɨsak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Abɨsok nak nandɨsat. Yawe da kɨla amɨn madepni iyɨ manjɨgɨt aŋpulugosok. Uŋun Kwen Kokup kokupni tagɨsikon egek bɨsitni nandɨsak. Iyɨ da tapmɨmon aŋpulugaŋek uwalni da kɨsiron naŋ abɨdosok. ");
INSERT INTO yut_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Amɨn dɨwarɨ emat bɨsapmon os da amɨn ɨlɨk pawɨlgaŋ tamoni uŋun do pɨbɨt tɨdok aŋ. Ae amɨn dɨwarɨ osni do pɨbɨt tɨdok aŋ. Mani nin Yawe Piŋkopnin dakon tapmɨm do yo madepsi yaŋ nandamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Uŋun amɨn maŋ mudokdaŋ. Mani nin pɨdaŋek tebai atdamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Yawe, kɨla amɨn madepnin aŋpulugaŋaki emaron teban toneŋ. Gak do yaŋ tɨdoneŋ bɨsapmon paŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Dewit dakon kap kɨnda. Kap on kap yoŋ dakon kɨla amɨn do mandabi. Yawe, kɨla amɨn madep da tapmɨmgo do kɨsɨk kɨsɨk nandɨsak. Gak da aŋpulugaŋaki emaron teban tagɨt, do gak do but galaksi nandɨsak. ");
INSERT INTO yut_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Yo tɨmɨt do nandagɨt uŋun gak da ɨbɨ kɨlɨ tɨmɨkgɨt. Yo do bɨsit gayɨgɨt, uŋun ɨmgul. ");
INSERT INTO yut_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","But galagon da abɨdaŋek yo tagɨsi ɨmgul. Aŋek kɨla amɨn madep dakon pelɨt gol baŋ wasaŋbi busuŋɨkon yɨpgul. ");
INSERT INTO yut_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Egɨp egɨp do bɨsit gayɨŋban ɨmgul. Aŋek egɨp egɨpni aŋdubak abɨ toktogɨsi egɨpdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Aŋpulugaŋaki man madepni madepsi tosok. Kɨla amɨn madep dakon tɨlɨmni wagɨl tagɨsisi gak da ɨmgul. ");
INSERT INTO yut_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Gak da yo tagɨsi dagok dagogɨ mɨni aŋɨmɨŋ wɨgɨkdɨsal. Gak uŋun da kapmatjok egɨsal, do kɨsɨk kɨsɨk madepsi nandɨsak. ");
INSERT INTO yut_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Kɨla amɨn madep da egɨp egɨpni Yawekon tosok yaŋsi nandɨsak. Piŋkop Wukwisi, uŋun da kɨla amɨn madep do bɨsapmɨ bɨsapmɨ but dasi galak taŋ ɨmɨsak, do tebaisi atdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Kɨla amɨn madep da uwal morapni tebaisi tɨmɨtdɨsak. Amɨn dɨma galak taŋ ɨmaŋ amɨn kɨsirɨ amɨn tet da tebaisi tɨmɨtdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Kɨndap madep da yo sosoŋ, uŋun da tɨlak noman altosak bɨsapmon uwalni dapban pasɨldaŋ. Yawe da butjap nandaŋ yomɨŋek pabɨŋ yopmaŋakwan kɨndap da soŋ yomɨŋ mudokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Kɨla amɨn madep da uwalni dakon monjɨ gwayoni kɨsi morap dapban kɨmak mudokdaŋ. Aŋakwan monjɨ gwayoni mɨktɨmon saŋbeŋek dɨma egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Uwal da nandak nandak aŋek kɨla amɨn madep yokwi aŋ ɨm do gen yaŋ paŋteban aŋ, mani arɨpmɨ dɨma abɨŋ yɨpni. ");
INSERT INTO yut_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Dɨkdɨkgo baŋ yamaŋ yobɨ tobɨlek pasal si kɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Yawe, tapmɨmgo madepsi do gak dakon man aŋkɨsik do kap yoneŋ. ");
INSERT INTO yut_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Dewit dakon kap kɨnda. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban kap tek “Wɨsa dagok dakon dia mɨŋat” uŋun naŋ yoni. Piŋkopno, Piŋkopno, nido nipmaŋ dekgɨl? Iyoŋ iyoŋ yaŋapbo nido dubagɨkon egek jɨgɨkon naŋ dɨma aŋpulugosol? ");
INSERT INTO yut_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Piŋkopno, gɨldarɨ gɨldarɨ gak do yaŋ tɨdosot, mani kobogɨ dɨma nayɨsal. Kalbiyo kɨsi gak do yaŋ tɨdosot, mani yaworɨ kɨnda dɨma abɨdosot. ");
INSERT INTO yut_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Mani gak telagɨ egɨsal. Gak kɨla amɨn madep yɨgaki Israel amɨn da mango aŋkɨsaŋ. ");
INSERT INTO yut_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Kalɨp babɨknin da egɨp egɨpni gagon tosok yaŋsi nandaŋ gamgwit. Aŋakwa gak da uwalni da kɨsiron baŋ pulugagɨl. ");
INSERT INTO yut_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Gak do yaŋ tɨdaŋba jɨgɨkon baŋ pulugagɨl. Nandaŋ gadaŋ gamɨŋakwa paŋpulugagɨl, do nandaŋ gadatni uŋun ɨsalɨ dɨma agɨt. ");
INSERT INTO yut_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Mani nak amɨn dɨma, nak waleŋ yombem yo ɨsalɨ. Amɨn morap da nandaba yokwi tok aŋnamɨŋek manji namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Amɨn morap nak nandaŋ uŋun yaŋsul aŋ namaŋ. Aŋek yaŋba yokwi tok aŋek wunda kwakwal aŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Aŋek yaŋ yoŋ, “Yawe da aŋpulugosak do nandaŋ gadaŋ ɨmɨsak, do yum kaŋakwa uŋun da jɨgɨkon baŋ pulugaŋ yɨpjak. Yawe do madepsi galak taŋ ɨmɨsak, do yum kaŋakwa aŋpulugosak.” ");
INSERT INTO yut_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Piŋkop gak dasi kɨlano aŋaki meŋ da buron da tagɨsi altagɨm. Mum nagɨm bɨsapmon aŋpulugaŋbɨ egɨp egɨpno gagon tosok yaŋsi nandaŋ gamgum. ");
INSERT INTO yut_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Meŋno da aŋalagɨron da wasaŋek gak da kɨsiron egɨpgum da egɨsat. Si altagɨmon da wasaŋek gak Piŋkopno egɨpgul da egɨsal. ");
INSERT INTO yut_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Jɨgɨ mibɨlɨ mibɨlɨ abaŋ, ae paŋpulugokno mɨni, do dubagɨkon dɨma egɨpbi. ");
INSERT INTO yut_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Uwalno uŋun bulmakau wɨli da yaŋ aŋgwasaŋ. Uŋun tapmɨmni madepsi, Basan mɨktɨm dakon bulmakau wɨli yombem. ");
INSERT INTO yut_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Laion da joŋ kɨlap nok do yaŋ tɨdaŋek gen kagani aŋtaŋ kwaŋ, uŋudeŋ uwalno da nak aŋupbal ak do aŋ. ");
INSERT INTO yut_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Pakbi ɨsal dogɨn tagal kɨ mudoŋ, uŋun da tɨlak tapmɨmno mɨnisi aŋ. Kɨdatno dakon saŋbekni kɨsi kalkalaŋ mudoŋ. Bɨt nelak da pakbi dagoŋ uŋun da tɨlak butno wagɨlsi tapmɨmɨ mɨni pakbi ɨdap asak. ");
INSERT INTO yut_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Tapmɨmno mɨni aŋakwan melno tɨptaŋ gen kaganogwan tegosok. Gak da nepbɨ kɨmot da tamokon pokdot. ");
INSERT INTO yut_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Amɨn yokwi da nak pɨŋan da yaŋ aŋgwasaŋ. Aŋek kɨsit kandapyo nokon ɨnjɨŋba geni da gɨptɨmnogwan pɨgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Kɨdatno kɨsi noman taŋakwa tagɨ manjɨkeŋ. Uŋun da nak da yokwi tat uŋun kaŋek kɨsɨk kɨsɨk aŋ. ");
INSERT INTO yut_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Ɨmalno kokwinɨk tɨmɨgek paba pɨgɨkno namɨn da abɨdosak yaŋ do satu wasok aŋ. ");
INSERT INTO yut_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Yawe, nak nepmaŋek dubagɨkon dɨma egɨpbi. Paŋpulugokno, tepmɨ abɨŋ aŋpuluga. ");
INSERT INTO yut_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Aŋpulugaŋbɨ emat agak sɨba baŋ dɨma nɨkba kɨmokgeŋ. Uŋun amɨn pɨŋan yombem da kɨsiron baŋ pulugaŋbɨ dɨma nɨkba kɨmokgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Laion da gen kaga ae joŋ bulmakau da jomon baŋ pulugaŋ nepbi. ");
INSERT INTO yut_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Yaŋ aŋaki notno kabɨkon man madepgo yaŋ teŋteŋokeŋ. Ae mɨŋat amɨn kabɨyo da muwutnikon gak aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Yawe do pasal ɨmaŋ amɨn kabɨ, Yawe aŋkɨsini. Jekop dakon dɨwatni kabɨ, Yawe man madep ɨmni. Israel dakon dɨwatni kabɨ, Yawe gawak ɨmni. ");
INSERT INTO yut_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Nido jɨgɨ madepsi paŋ amɨn manji dɨma yomɨsak. Tepmɨ jɨgɨyo paŋ amɨn uŋun do nandaban yo ɨsalɨ dɨma asak. Uŋun manji dɨma yomɨsak. Paŋpulugosak do yaŋ tɨdaŋba bɨsitni nandaŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Amɨn madepsi Piŋkop gawak ɨm do muwutni bɨsapmon gak aŋkɨsikeŋ. Mɨŋat amɨnyo gak do pasolgoŋ uŋun da dabɨlon kalɨp gak do paret ak do yaŋ teban tagɨm uŋun akdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Bupmɨ amɨn jap arɨpmɨsi naŋ tugokdaŋ. Ae Yawe wɨsɨŋ kokdo pi aŋ amɨn uŋun da mani aŋkɨsikdaŋ. Piŋkop da paŋpulugaŋban dagok dagogɨ mɨni butni tagɨsi taŋ aŋaŋ wɨgɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Amɨn mɨktɨmɨ mɨktɨmɨ ekwaŋ Yawe do nandaŋek tobɨl iyɨkon apdaŋ. Mɨktɨmɨ mɨktɨmɨ amɨn kabi kabi ekwaŋ uŋun da abɨŋek gawak ɨmdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Nido Yawe kɨla amɨn madep egek mɨktɨmɨ mɨktɨmɨ amɨn morap kɨlani asak. ");
INSERT INTO yut_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Mɨktɨmɨ mɨktɨmɨ kwen wɨgɨk amɨn morap da ŋwakbeŋ aŋ ɨmdaŋ. Mɨktɨm amɨn morap kɨmagek mɨktɨm dagokdaŋ uŋun kɨsi morap da abɨŋek Piŋkop gawak ɨmdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Don altaŋ altaŋ ani amɨn da omani aŋɨmdaŋ. Amɨn da Amɨn Tagɨ do yaŋ teŋteŋok aŋakwa don altoni amɨn da nandaŋ aŋaŋ kɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Piŋkop da aŋpakni kɨlegɨkon da iyɨ mɨŋat amɨn kabɨni yokwikon baŋ tɨmɨkgɨt, uŋun dakon geni don altoni amɨn baŋ yoyɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Dewit dakon kap kɨnda. Yawe uŋun kɨla amɨno, do yo kɨnda do wadak wadak dɨma asat. ");
INSERT INTO yut_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Aŋkɨ joŋ kalɨkalɨgɨ tɨmon nepban pak yawokdot. Aŋek pakbi monɨŋ monɨŋ yaworɨ pokgoŋ uŋudon gɨn nayɨŋ awɨldak. ");
INSERT INTO yut_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Tapmɨm kalugɨ namɨŋek man bini tagɨsi tosak do kosit kɨlegɨkon nayɨŋ awɨldak. ");
INSERT INTO yut_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Piŋkop, gak nak gat egɨsal, do gɨlo ae pɨlɨn tukyogwan agɨpbeŋ kaŋ, yo yokwi do dɨma pasolgeŋ. Gandako sipsip kɨla amɨn dakon kɨndap kɨrɨŋ abɨdosol, do uŋun da butno aŋteban asak. ");
INSERT INTO yut_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Japno tagɨsi uwalno da dabɨlon nomansi paŋnoman asal. Yutgokon but galagon da abɨdaŋek bɨt nelak busuŋnokon tagaldal. Yo galagɨ ɨreŋɨsi ɨdawukbɨ ɨdapno si tugosok. ");
INSERT INTO yut_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Mɨktɨmon egɨpbeŋ bɨsap morapmon kɨlano tagɨsi aŋek but dasi galak taŋ namɨŋ wɨgɨkdɨsal. Ae bɨsap mudok mudogɨ mɨni yutgokon egɨ wɨgɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Dewit dakon kap kɨnda. Mɨktɨm gat ae yo morap uŋungwan toŋ uŋun Yawe dakon. Ae kokup morap gat ae mɨŋat amɨn morap uŋungwan ekwaŋ kɨsi uŋun dakon gɨn. ");
INSERT INTO yut_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Pakbi ɨlarɨsi da binapmon mɨktɨm wasagɨt. Mɨktɨm dakon mibɨlɨ tap binap yɨpgut. ");
INSERT INTO yut_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Namɨn da Piŋkop da kabap madepmon tagɨ wɨgɨsak? Ae namɨn da iyɨ da telagɨ tamokon tagɨ atjak? ");
INSERT INTO yut_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Yokwi dɨma asak amɨn, ae butni kɨlegɨ, ae kokup kɨdat do dɨma gawak yomɨsak, ae notni topmon da yaŋ teban tok dɨma aŋyomɨsak, uŋuden amɨn da arɨpmɨ tagɨ. ");
INSERT INTO yut_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Uŋuden amɨn Piŋkop da gɨsamɨtjak. Yokwikon baŋ tɨmɨgek amɨn kɨlegɨ yaŋ iyɨsak. ");
INSERT INTO yut_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Uŋuden amɨn da Piŋkop wɨsɨŋek Jekop dakon Piŋkop da kapmatjok kɨsak. ");
INSERT INTO yut_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Wigat, ji wɨtdal kɨni. Yoma kalɨpmɨ, ji madepsi pɨsoni. Aŋakwa Kɨla Amɨn Madep tɨlɨmɨ toŋsi da wɨgɨsak. ");
INSERT INTO yut_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Kɨla Amɨn Madep tɨlɨmni toŋsi uŋun namɨn? Uŋun Yawe kaloŋ gɨn. Tapmɨmni madepsi, emaron teban tosok. ");
INSERT INTO yut_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Wigat, ji wɨtdal kɨni. Yoma kalɨpmɨ, ji madepsi pɨsoni. Aŋakwa Kɨla Amɨn Madep tɨlɨmɨ toŋsi da wɨgɨsak. ");
INSERT INTO yut_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Kɨla Amɨn Madep tɨlɨmɨ toŋsi uŋun namɨn? Uŋun Yawe tapmɨmni pɨdaŋbisi. Uŋun kaloŋ dagɨn Kɨla Amɨn Madep tɨlɨmɨ toŋsi da egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Dewit dakon kap kɨnda. Yawe, aŋpulugoki do bɨsit gayɨsat. ");
INSERT INTO yut_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Piŋkopno, egɨp egɨpno gagon tosok yaŋsi nandɨsat. Aŋpulugaŋaki mayagɨ dɨma pakeŋ, ae uwalno da abɨŋ nepmaŋek kɨsɨk kɨsɨk dɨma ani. ");
INSERT INTO yut_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Amɨn morap gak do nandaŋ gadaŋ uŋun mayaktok dɨma pani, mani amɨn paŋkewalgaŋ amɨn uŋun mayaktok pakdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Yawe, niaŋ egɨpbeŋ do nandɨsal uŋun nolɨki. Kositgo nolɨki. ");
INSERT INTO yut_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Piŋkopno, yokwikon baŋ aŋpulugosol do nayɨŋ dekbɨ gengo bamɨ yol aŋaŋ kɨkeŋ. Gɨldat kɨnda kaloŋ aŋpulugoki do jomjom aŋegɨsat. ");
INSERT INTO yut_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Yawe, gak amɨn do bupmɨ nandaŋek but dasi galak taŋ yomɨsal uŋun do nandaki. Kalɨpsigwan da aŋpak uŋun agɨl da aŋaŋ obɨsal. ");
INSERT INTO yut_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Piŋkop nak monjɨ bɨlagɨ egek aŋpak yokwi agɨm uŋun do dɨma nandaki. Gak amɨn do bupmɨ nandaŋ yomɨsal, do but dasi galak taŋ nabi. ");
INSERT INTO yut_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Yawe uŋun wagɨl tagɨsi ae kɨlegɨsi. Yaŋdo, yokwi pakpak amɨn kositni yolɨsak. ");
INSERT INTO yut_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Amɨn iyɨ do nandaba paŋ uŋun kositni kɨlegɨ yolɨsak, ae aŋpakni kɨlegɨ yoyɨŋ dekdak. ");
INSERT INTO yut_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Yawe da saŋbek saŋbekni ae gen tebani yolgaŋ mɨŋat amɨnyo uŋun do but dasi galak taŋ yomɨŋek dɨma yopmaŋ dekdak. ");
INSERT INTO yut_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Yawe, man bingo tagɨsi tosak do yokwino morapmɨsi uŋun wɨrɨrɨk nabi. ");
INSERT INTO yut_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Yawe yolgaŋ amɨn kosit kɨlegɨ niaŋ agɨpni uŋun yolɨsak. ");
INSERT INTO yut_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Uŋuden amɨn tagɨsi egɨpdaŋ, ae monjɨ gwayoni uŋun da mɨktɨmni abɨdokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Yawe uŋun mɨŋat amɨnyo pasal ɨmaŋ uŋun dakon notni egɨsak. Aŋek saŋbek saŋbek uŋun gat agɨt uŋun do yoyɨŋ dekdak. ");
INSERT INTO yut_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Yawe da gɨn nak paron naŋ kukwosok, do uŋun da aŋpulugosak do dabɨlno uŋudon gɨn yɨpmaŋdat. ");
INSERT INTO yut_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Naga dage egapbo amɨn da yokwi aŋ namaŋ, do tobɨl abɨŋek nandaŋ yawok nabi. ");
INSERT INTO yut_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Butjɨk morapno uŋun si pap tosok, do wɨrɨrɨk namɨŋaki yaworɨ egɨpbeŋ. Aŋpulugaŋaki jɨgɨ da dɨma abɨŋ nepni. ");
INSERT INTO yut_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Butjɨk morapno gat ae jɨgɨno gat do nandaŋek yokwi morapno yopmaŋ nabi. ");
INSERT INTO yut_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Uwalno morapmɨsi uŋun do pɨndat. Uŋun nak do japmɨsi nandaŋek ukwayɨt aŋ. ");
INSERT INTO yut_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Aŋpulugoki do obɨsat, do egɨp egapno kutnoki, ae uwal da kɨsiron naŋ abɨdoki. Aŋpulugaŋaki mayagɨ dɨma pakeŋ. ");
INSERT INTO yut_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Aŋpulugoki do jomjom aŋegɨsat, do aŋpakno tagɨsi ae kɨlegɨsi uŋun da nak aŋkutnoni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Piŋkop, amɨn kabɨgo Israel yumaŋ naŋaki jɨgɨni mibɨlɨ mibɨlɨ toŋ uŋun da dɨma pabɨŋ yopni. ");
INSERT INTO yut_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Dewit dakon kap kɨnda. Yawe, nak aŋpak kɨlegɨ gɨn aŋek gak dogɨn nandaŋ gadasat, do amɨn kɨlegɨ yaŋ nayɨki. ");
INSERT INTO yut_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Yawe, nak dakon but nandak nandakyo aŋkɨlɨgek koki. ");
INSERT INTO yut_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Nido nak do but dasi galak taŋ namɨsal uŋun bɨsapmɨ bɨsapmɨ nandɨsat. Aŋek bɨsapmɨ bɨsapmɨ gak dakon gen bamɨ yoldat. ");
INSERT INTO yut_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Nak top yoŋ amɨn gat dɨma yɨkgamaŋ. Ae jamba but amɨn gat dɨma akwamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Yokwi pakpak gat egɨp do dɨmasi nandɨsat. Ae uŋun gat yɨt do dɨmasi galak tosot. ");
INSERT INTO yut_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Yawe, nak dɨwarɨno mɨni yaŋ nandaki do kɨsitno pakbi naŋ sugosot. Nak gak dakon alta aŋgwasɨŋek ");
INSERT INTO yut_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","gen papmon da gak aŋkɨsiŋek pi tagɨsisi asal uŋun do amɨn yoyɨsat. ");
INSERT INTO yut_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Yawe, gak dakon yut do but dasi galak tosot. Gak dakon tɨlɨmgo uŋudon tosok. ");
INSERT INTO yut_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Gak yokwi pakpak amɨn dapbɨ kɨmotni bɨsapmon dɨma nɨkbɨ kɨmokgeŋ. Amɨn dapdap amɨn dapmaŋek nakyo kɨsi dɨma nɨkgi. ");
INSERT INTO yut_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Uŋun amɨn yo yokwi ak do gen paŋkosit aŋ. Ae amɨn da notni yo yokwi aŋyomni do amɨn do tomni yomaŋ. ");
INSERT INTO yut_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Mani nak aŋpak kɨlegɨ gɨn asat. Bupmɨ nandaŋ namɨŋek yokwikon baŋ pulugaŋ nepbi. ");
INSERT INTO yut_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Nak mɨktɨm kɨlegɨkon akdat. Yawe, amɨn gawak gam do muwukgaŋ uŋun da bɨkbɨgon gak aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Dewit dakon kap kɨnda. Yawe uŋun teŋteŋɨno ae yokwikon baŋ tɨmɨt tɨmɨt amɨno, do namɨn do pasolgeŋ? Yawe da nak aŋkutnosok, do nido pasol pasol abeŋ? ");
INSERT INTO yut_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Amɨn yokwi nak aŋupbal ak do apni bɨsapmon kosit yokwigɨn agek maŋ potdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Emat amɨn morapmɨsi da abɨŋ aŋgwasɨni kaŋ, dɨma pasolgeŋ. Uwal da nɨt do apni kaŋ, but morap dɨma abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Yawe do yo kaloŋɨ kɨnda do bɨsit asat. Uŋun da nandaŋ naban mɨktɨmon egɨpbeŋ bɨsapmon gɨldarɨ gɨldarɨ iyɨ da yutnon egɨpbeŋ do nandɨsat. Aŋek Yawe uŋun wagɨl tagɨsisi do dabɨlno uŋudongɨn yɨpmaŋek kɨsɨk kɨsɨk aŋek egɨpbeŋ. Aŋek Telagɨ Yut Madepnikon Yawe dogɨn nandaŋek egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Nido yo yokwi da nagon noman toni bɨsapmon uŋun da iyɨ da yutnon aŋkɨsɨbɨŋ nepban egɨpbeŋ. Yoma sopmaŋek tagɨsi aŋkɨsɨbɨŋ nepjak. Tɨp madep kɨnda da kwenon nepban tagɨsi egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Yaŋ aban uwalno nak aŋgwasaŋ uŋun pabɨŋ yopbeŋ. Nak kɨsɨk kɨsɨk aŋek yaŋ tɨdaŋek iyɨ da telagɨ yutnikon paret aŋ ɨbeŋ. Aŋek kap yaŋek mani aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Yawe, gak do bɨsit abo bupmɨkon da bɨsitno nandaŋek aŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Gagon opbeŋ do nayɨsal, do Yawe nak kɨlɨ uŋun obɨsat. ");
INSERT INTO yut_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Dɨma gandakeŋ yaŋ do dɨma pasɨlgi. Nak oman amɨngo, do butjap nandaŋek dɨma akwayɨkgi. Piŋkop, gak paŋpulugokno. Gak da nak yokwikon naŋ abɨdosol. Dɨma nepmaŋ dekgi. ");
INSERT INTO yut_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Meŋ datyo da manji namjil kaŋ, Yawe da kɨlano sigɨn akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Yawe, gaga dakon aŋpak do nayɨŋ dekgi. Uwalno morapmɨ, do kosit kɨlegɨ naŋ nayɨŋ aŋaŋ kɨki. ");
INSERT INTO yut_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Yum nandaŋaki uwalno da nak dɨma abɨdoni. Uŋun topmon da gen yaŋ namɨŋek nak aŋupbal akdo aŋ. ");
INSERT INTO yut_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Nak asisi nandɨsat, don on mɨktɨm egɨsaron Yawe da yo tagɨsi aŋ namdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Yawe aŋpulugosak do jomjom aki. Tebaisi agek nandaŋ gadaŋ ɨmɨŋek but pasol dɨma abi. Yawe do jomjom aki. ");
INSERT INTO yut_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Dewit dakon kap kɨnda. Yawe, gak tɨp madepno, bɨsitno nandaŋek aŋpuluga. Dɨma aŋpulugoki kaŋ, nak amɨn kɨmakbi da tɨlak egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Bupmɨ nandaŋ namɨŋek aŋpulugoki do yaŋ tɨdokeŋ bɨsapmon nandaŋ nabi. Bɨsit aŋek kɨsitno paŋenokgo telagɨ yutgo da tet do wɨgɨsak. ");
INSERT INTO yut_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Yokwi pakpak amɨn gat kɨsi nak dɨma ɨlɨk paŋkɨ mabɨ kɨneŋ. Uŋun amɨn kwen da notni do gen galagɨ galagɨ yoŋ. Mani burɨgwan nandak nandakni yokwi morapmɨ toŋ. ");
INSERT INTO yut_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Aŋpak yokwi awit uŋun da arɨpmon kobogɨ do tepmɨ pi yobi. Amɨn do yokwi awit uŋun paŋtobɨlbɨ iyɨkon kɨni. ");
INSERT INTO yut_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Yawe da pi madepsi aŋek yo morap wasagɨt uŋun do dɨma nandaŋ. Yaŋdo, uŋun amɨn yut kɨnda naŋ yaŋ tuwɨlek dɨma awaldɨsak. ");
INSERT INTO yut_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Bupmɨ nandaŋ namjak do bɨsit abo bɨsitno kɨlɨ nandagɨt, do Yawe dakon man awɨgɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Yawe da tapmɨm namɨŋek pasɨkno asak. Yaŋ asak do aŋek nandaŋ gadaŋ ɨmɨsat. Yawe da nak aŋpulugosok uŋun do kɨsɨk kɨsɨk madepsi nandaŋ ɨmɨsat. Nak ya yaŋ iyɨŋek kap morapmɨ yosot. ");
INSERT INTO yut_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Yawe da mɨŋat amɨn kabɨni tapmɨm yomɨsak. Kɨla amɨn madepni pini asak do manjɨgɨt uŋun aŋpulugok do tagap taŋek dam tebani arɨpmɨ dɨma tuwɨlɨ da yaŋ egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Mɨŋat amɨn kabɨgo yokwikon baŋ pulugaŋ yopbi. Gaga do manjɨgɨl amɨn kabɨ yo tagɨsi aŋ yobi. Kɨla amɨni egek dagok dagogɨ mɨni kɨlani abi. ");
INSERT INTO yut_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Dewit dakon kap kɨnda. Ji aŋelo tapmɨmɨ toŋ, ji Yawe aŋkɨsini. Tɨlɨmni gat ae tapmɨmni gat do nandaŋek aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Yawe dakon man madepni uŋun tɨlɨmɨ toŋ, do aŋkɨsini. Ji si telak taŋek gawak ɨmni. ");
INSERT INTO yut_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Yawe da gen yaŋakwan tap kwenon kɨŋakwan nandaŋ. Piŋkop tɨlɨmni madep kɨrɨrɨŋ da yaŋ madepsi yosok. Gen madepsi yaŋban sulɨgɨ tap madep kwenon kɨŋakwan nandaŋ. ");
INSERT INTO yut_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Yawe gen yosok uŋun tapmɨmɨ toŋsi yosok. Yaŋakwan amɨn morap da Yawe uŋun kɨla amɨn madep wɨkwisi yaŋ nandaŋ ɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Yawe gen yaŋakwan Lebanon mɨktɨm dakon sida kɨndap gawɨkgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Uŋun da wasok aban Lebanon Kabap da bulmakau monjɨ da wɨgɨ mok aŋ uŋudeŋ aŋ. Ae Ɨleŋ Emon da bulmakau wɨli bɨlagɨ da yaŋ wɨgɨ mok asak. ");
INSERT INTO yut_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Yawe da gen yaŋakwan mal asak. ");
INSERT INTO yut_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Uŋun da wasok aban Kedes dakon mɨktɨm kɨbɨrɨ uŋun wudɨp madepsi asak. ");
INSERT INTO yut_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Yawe da gen yaŋakwan kɨndap teban da kwasɨgɨlgaŋ, aŋakwa koron kɨndap tam morap kɨsisi bɨrɨpmɨgɨ moŋ. Yaŋ aŋakwan Telagɨ Yut Madepnikon amɨn kɨsisi da yaŋ tɨdaŋek yaŋ yoŋ, “Piŋkop uŋun tɨlɨmni toŋ!” ");
INSERT INTO yut_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Pakbi ɨgakwa Yawe dagok dagogɨ mɨni kɨla amɨn madep egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Yawe mɨŋat amɨn kabɨni tapmɨm yomɨsak. Yaŋ aŋek gɨsamɨgakwan yaworɨsi ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Dewit dakon kap kɨnda. Kap on telagɨ yut yoma wɨtdal do yawit. Yawe, gak da nak yokwi da kɨsiron naŋ abɨdagɨl. Yum pɨndagaki uwalno da abɨŋ nepmaŋek kɨsɨk kɨsɨk dɨma awit. Yaŋ agɨl do mango yaŋ aŋkɨsisat. ");
INSERT INTO yut_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Yawe Piŋkopno, aŋpulugoki do bɨsit gayɨko aŋpulugaŋbɨ kɨlek tagɨm. ");
INSERT INTO yut_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Yawe, kɨmot do aŋapbo abɨ pɨdagɨm. Kɨmakbi tamogwan pɨgɨk do aŋapbo egɨp egɨpno aego namgul. ");
INSERT INTO yut_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Yawe dakon mɨŋat amɨn kabɨni, Yawe aŋkɨsini. Mani telagɨ aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Bɨsap pɨsɨpmɨsok butjap nandɨsak. Mani mɨktɨmon ekwamaŋ bɨsap morap nin do tagɨsi nandaŋek yo tagɨsi aŋnimɨsak. Dabɨl pakbigo kalbi tagɨ moni, mani wɨsa dagokdo kɨsɨk kɨsɨk aego akdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Kalɨp nak tagɨsi egek yaŋ yagɨm, “Yo kɨnda da arɨpmɨ dɨma aban yokwi tokeŋ.” ");
INSERT INTO yut_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Yawe, gak nak do tagɨsi nandaŋek aŋpulugagɨl bɨsapmon ɨleŋ kɨnda da yaŋ tebaisi akgɨm. Mani manji namgul bɨsapmon uŋudon yokwi tagɨm. ");
INSERT INTO yut_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Yawe nak gak do yaŋ tɨdagɨm. Bupmɨ nandɨsak do Amɨn Tagɨ bɨsit tebaisi aŋek yaŋ iyɨgɨm, ");
INSERT INTO yut_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","“Nak kɨmakbi tamogwan pɨgɨkeŋ kaŋ, ni yo tagɨ kɨnda da noman tosak? Amɨn kɨmakbi da mango tagɨ aŋkɨsini? Gak da toktogɨ ninon yo tagɨsi asal dakon gen uŋun da tagɨ yaŋ teŋteŋoni? Arɨpmɨ dɨma. ");
INSERT INTO yut_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Nandaŋ namɨŋek nak do bupmɨ nandaki. Yawe, nak aŋpulugoki.” ");
INSERT INTO yut_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Gak da butno jɨgɨsi tagɨt uŋun aŋtagap abɨ kɨsɨk kɨsɨk kap asat. Ae but yokwi nandagɨm uŋun aŋyawot abɨ but kwaktok nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Yaŋ agɨl, do gen mapmɨt arɨpmɨ dɨma abeŋ. Mango aŋkɨsikeŋ. Yawe Piŋkopno, dagok dagogɨ mɨni ya yaŋ gayɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Dewit dakon kap kɨnda. Kap on kap yoŋ dakon kɨla amɨn do mandabi. Yawe, gak da nak aŋkutnoki do abɨsat. Aŋpulugaŋaki uwal da dɨma abɨŋ nepni. Gak kɨlegɨsi do uwal da kɨsiron baŋ pulugaŋ nepbi. ");
INSERT INTO yut_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Nandaŋ namɨŋek tepmɨsi pulugoki. Gak gopbatno ae dam tebano arɨpmɨ dɨma tuwɨlɨ egɨsal, do uwal da arɨpmɨ dɨma abɨŋ nepni. ");
INSERT INTO yut_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Asi gak tɨp madepno ae dam tebano arɨpmɨ dɨma tuwɨlɨ egɨsal. Gak dakon man dɨma yokwi tosak do mibɨltaŋ namɨŋek kosit nolayɨki. ");
INSERT INTO yut_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Uwalno da nak abɨdok do pat yɨpmaŋ. Mani gak pasɨlɨ tamono, do abɨŋ aŋkutnaŋaki paron dɨma yokwalgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Wupno gak da kɨsiron yɨpmaŋdat. Yawe, gen bamɨ dakon Piŋkop, yokwikon baŋ pulugaŋ nepbi. ");
INSERT INTO yut_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Gak kokup kɨdat gawak yomaŋ amɨn dɨmasi galak taŋ yomɨsal. Mani egɨp egɨpno Yawekon tosok yaŋsi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Nak do bɨsapmɨ bɨsapmɨ but dasi galak taŋ namɨsal, do nak gak do but galaksi nandɨsat. Jɨgɨ morapno pɨndagek butjɨk pagɨm uŋun pɨndak nandaŋyo agɨl. ");
INSERT INTO yut_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Yum pɨndagaki uwal da nak dɨma abɨdawit. Aŋpulugaŋaki tagɨsi egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Yawe, jɨgɨno madepsi, do bupmɨ nandaŋ nabi. Kunam morapmɨ tagek dabɨlno pɨrɨropmaŋ. But yokwi nandaŋek gɨptɨmno wagɨlsi alek taŋ. ");
INSERT INTO yut_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Butnokon da jɨgɨ nandaŋ egɨsat. Uŋun da egɨp egɨpno aŋpɨsɨp asak. Kunam morapmɨ takdat do bɨsap dubagɨ dɨma egɨpbeŋ. Nak jɨgɨno madepsi do tapmɨmno mɨnisi aŋakwan kɨdatno wagɨlsi yokwi toŋ. ");
INSERT INTO yut_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Uwal da jɨgɨlak yaŋ namaŋ. Kokup ɨsalno da nak do nandaba yokwitok aŋ namaŋ. Aŋakwa notnoni da nak do pasol pasol madepsi aŋ. Kosiron agapbo nak nandaŋ amɨn uŋun pasal si kwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Amɨn kɨmakba ɨŋtaŋ yomamaŋ uŋudeŋ amɨn morap kɨsi nak do ɨŋtaŋ namaŋ. Nak mɨktɨm kwoba pudaŋ kwa maba kwaŋ uŋun yombem. ");
INSERT INTO yut_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Nak nandaŋapbo uwalno morapmɨ da manji gen yaŋ namaŋ. Yo pasolɨsi da nak aŋgwasaŋ. Muwugek niaŋsi aŋek aŋatno kɨmakban yaŋ do yaŋ nandat aŋ. ");
INSERT INTO yut_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Mani Yawe egɨp egɨpno gagon tosok yaŋsi nandɨsat. Nak yaŋ yosot, “Gak Piŋkopno.” ");
INSERT INTO yut_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Nak don egɨ aŋaŋ kɨkdɨsat uŋun gak da kɨsiron tosok. Uwalno nak aŋsopmaŋgaŋ uŋun da kɨsiron baŋ pulugaŋ nepbi. ");
INSERT INTO yut_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Butgo oman amɨngo nagon yɨpmaŋek yo tagɨsi aŋ nabi. Butdasi galak taŋ namɨsal, do uwal da kɨsiron baŋ pulugaŋ nepbi. ");
INSERT INTO yut_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Yawe, aŋpulugoki do yaŋ tɨdosot, do aŋpulugaŋaki mayagɨ dɨma pakeŋ. Yokwi pakpak amɨn paŋmayak abi. Aŋaki kɨmakbi tamogwan pagek gen dɨma yoni. ");
INSERT INTO yut_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Uŋun amɨn kwen wɨgɨk aŋek amɨn kɨlegɨ do yaŋba yokwi tok aŋyomaŋ, do uŋun top yogok amɨn paŋtasɨk abɨ gen dɨma yoni. ");
INSERT INTO yut_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Amɨn gak do pasalek gawak gamɨŋek ekwaŋ uŋun gak da aŋpakgo tagɨsisikon da paŋpulugosol. Mɨŋat amɨn morap da dabɨlon paŋkutnoki do gagon kwaŋ amɨn kɨlani tagɨsi asal. ");
INSERT INTO yut_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Gak da uŋun amɨn gaga da kapmatjok paŋkɨsɨbɨsal. Yaŋ aŋaki dap do yoŋ amɨn dap do si paŋtɨdok aŋ. Gak da yoŋgamgwan egakwa uwalni da gen yokwi yaŋek arɨpmɨ dɨma pabɨŋ yopni. ");
INSERT INTO yut_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Yawe aŋkɨsino. Nak do but dasi galak taŋ namɨsak. Kokup papmon egapbo uwal da aŋgwasɨŋek nɨt do awit bɨsapmon tagɨsi aŋpulugagɨt. ");
INSERT INTO yut_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Uŋun bɨsapmon wurɨpdagek yaŋ yagɨm, “Gak da nak nolbɨ gak da dubagɨkon egɨsat.” Mani bupmɨ nandaŋek aŋpulugoki do yaŋ tɨdoko nandaŋ namgul. ");
INSERT INTO yut_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Telagɨ mɨŋat amɨn kabɨni, ji Yawe but dasi galak taŋ ɨmni. Geni guramɨkgaŋ amɨn kɨlani tagɨsi asak, mani iyɨ do nandaba wɨgɨsak amɨn uŋun kobogɨ yokwisi yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Yawe da paŋpulugosak do jomjom aŋ amɨn morap ji butji paŋteban aŋek atni. ");
INSERT INTO yut_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Dewit dakon kap kɨnda. Kap on do “Maskil” yaŋ yoŋ. Amɨn kɨnda gulusuŋ agɨt dakon yokwini Piŋkop da wɨrɨrɨk ɨmɨsak, uŋun amɨn kɨsɨk kɨsɨk tagɨ asak. ");
INSERT INTO yut_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Amɨn kɨnda Piŋkop da dɨwarɨni wɨrɨrɨk ɨmɨsak, ae topni mɨni egɨsak amɨn uŋun kɨsɨk kɨsɨk tagɨ asak. ");
INSERT INTO yut_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Dɨwarɨno dɨma yaŋ teŋteŋagɨm bɨsapmon gɨldat kalba ae kalbi but yokwi nandaŋek iyoŋ iyoŋ yaŋek egɨpgum. Aŋek tapmɨmno wagɨlsi alek tawit. ");
INSERT INTO yut_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Gɨldarɨ ae kalbi tepmɨ pi namgul. Gɨldat da mɨktɨm kaŋban kɨbɨdosok uŋun da tɨlak tapmɨmno kɨsisi maŋ mudawit. ");
INSERT INTO yut_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Don dɨwarɨno gagon yaŋ teŋteŋagɨm. Aŋpakno yokwi kɨnda dɨma aŋkɨsɨbɨgɨm. “Yawekon dɨwarɨno kɨsi yaŋ kwokeŋ” yaŋ yagɨm. Yaŋkwok abo dɨwarɨno kɨsisi wɨrɨrɨk namgul. ");
INSERT INTO yut_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Do amɨn gak golgaŋ jɨgɨ bɨsapmon gak do bɨsit yoni. Aŋakwa jɨgɨ pakbi ɨkdak uŋun da tɨlak abɨŋek arɨpmɨ dɨma pabɨŋ depni. ");
INSERT INTO yut_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Gak kaloŋ gɨn pasɨlɨ tamono. Gak da kɨlano asal, do jɨgɨ da nak arɨpmɨ dɨma abɨŋ nepni. Gak da nak jɨgɨkon naŋ pulugosol, do nak aŋgwasɨŋek akgaŋ amɨn da but kwaktok kap yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Yawe da yaŋ yosok, “Nak da gayɨŋ degek kosit agɨpbi uŋun golɨkdɨsat. Nawa gen gayɨŋek kɨlago akdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Gak os bo donki da yaŋ kadɨm dɨma dagoki. Uŋun amɨn da gen kaganikon ain tɨm toŋ uŋudon nap teban paŋteban aŋek ɨlɨkba geni guramɨkgaŋ.” ");
INSERT INTO yut_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","But yokwi morapmɨ yokwi pakpak amɨnon noman toŋ. Mani Yawe si nandaŋ gadaŋ ɨmaŋ amɨn uŋun dagok dagogɨ mɨni but dasi galak taŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Amɨn kɨlegɨ ji butji tagɨsi taŋakwan Yawesi aŋkɨsini. Butji gwaljɨgɨ mɨni amɨn, ji kɨsɨk kɨsɨk nandaŋek yaŋ tɨdoni. ");
INSERT INTO yut_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Amɨn kɨlegɨ ji kɨsɨk kɨsɨk nandaŋek Yawe aŋkɨsini. Uŋun aŋpak uŋun ji da agagɨsi. ");
INSERT INTO yut_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Yawe aŋkɨsiŋek kulele tɨdoni. Gita napmɨ 10 kabɨ toŋ uŋun tɨdaŋakwa geni galagɨsi nandɨsak. ");
INSERT INTO yut_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Kap kalugɨ yaŋek gita si nandaŋ kɨmagek tɨdoni. Yaŋ aŋek kɨsɨk kɨsɨk aŋek yaŋ tɨdoni. ");
INSERT INTO yut_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Yawe dakon gen uŋun gen bamɨsi. Yo morap asak uŋun da nin toktogɨsi dɨma nipmaŋ dekdak yaŋ nolɨsak. ");
INSERT INTO yut_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Yawe uŋun aŋpak kɨlegɨ ae gen kokwin kɨlegɨsi uŋun do but dasi galak tosok. Dagok dagogɨ mɨni mɨktɨmɨ mɨktɨmɨ amɨn do but dasi galak taŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Yawe da gen yaŋakwan gɨldat kanek ae gɨkyo kundukon noman tawit. Gen yaŋakwan yo morap kundukon noman tawit. ");
INSERT INTO yut_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Amɨn da kwobakon pakbi koleŋba toŋ uŋun da tɨlagon Yawe da tap pakbi aŋmuwukban tamonikon gɨn tagɨt. ");
INSERT INTO yut_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","9","Gen yaŋakwan on mɨktɨm noman tagɨt. Gen tebai yaŋakwan noman tagɨt do mɨktɨmɨ mɨktɨmɨ amɨn kɨsisi Yawe do pasalek tamtam yaŋ ɨmnisi. ");
INSERT INTO yut_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Mɨktɨmɨ mɨktɨmɨ mɨŋat amɨnyo da yo ak do paŋkosit aŋ uŋun Yawe da tuwɨldak. Ae pi ak do nandaŋ uŋun kosit sopmaŋdak. ");
INSERT INTO yut_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Mani Yawe da yo morap ak do yosok uŋun joŋɨgek aŋ mudosok. Pi morap ak do nandɨsak uŋun toktogɨsi kulabɨk arɨpmɨ dɨma asak. ");
INSERT INTO yut_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Mɨŋat amɨn kabɨyo Yawe yɨpba uŋun da Piŋkopni egɨsak uŋun amɨn kɨsɨk kɨsɨk tagɨ ani. Uŋun mɨŋat amɨn kabɨyo iyɨ do kɨlɨ manjɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Yawe uŋun Kwen Kokup da sɨŋtaŋban pɨŋakwan amɨn kɨsisi pɨndakdak. ");
INSERT INTO yut_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Uŋun kɨla amɨn madep yɨtyɨt tamonikon yɨgek sɨŋtaŋban pɨŋakwan mɨktɨmon amɨn morap pɨndakdak. ");
INSERT INTO yut_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Uŋun da amɨn dakon but nandak nandakni wasagɨt, do yo morap aŋ uŋun pɨndak nandaŋyo asak. ");
INSERT INTO yut_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Kɨla amɨn madep kɨnda uŋun emat amɨni morapmɨ da uwalni arɨpmɨ dɨma pabɨŋ yopni. Ae emat amɨn kɨnda uŋun iyɨ da tapmɨmon da uwalni da kɨsiron da arɨpmɨ dɨma pasal kɨsak. ");
INSERT INTO yut_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Emat dakon os uŋun tapmɨmni madepsi, mani uwal da kɨsiron baŋ arɨpmɨ dɨma paŋpulugosak. ");
INSERT INTO yut_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Mani amɨn morap Yawe do pasolgoŋ uŋun iyɨ kɨlani asak. Dagok dagogɨ mɨni amɨn do but dasi galak taŋ yomɨsak uŋun do nandaŋek jomjom aŋ amɨn uŋun kɨlani tagɨsi asak. ");
INSERT INTO yut_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Uŋun amɨn kabɨ paŋpulugaŋakwan dɨma kɨmokgoŋ, ae jap da mɨni aŋ bɨsapmon jap yomaŋakwan dɨma kɨmokgoŋ. ");
INSERT INTO yut_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Yawe uŋun dagɨn nin tagɨ paŋpulugosak, do uŋun do jomjom amaŋ. Uŋun da pasɨknin egakwan uŋun da yoŋgamgwan tagɨsi ekwamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Nin mani telagɨ uŋun do nandaŋ dagomaŋ, do kɨsɨk kɨsɨk amaŋ. ");
INSERT INTO yut_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Yawe, gak nin paŋpulugoki do jomjom amaŋ. Dagok dagogɨ mɨni but dasi galak taŋ nibi dosi nandamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Dewit Abimelek gat egek topmon da ŋugɨgɨ dagaŋban Abimelek da yolban kɨgɨt. Kɨŋek kap on mandagɨt. Nak Yawe aŋkɨsikeŋ. Bɨsapmɨ bɨsapmɨ mani aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Yawe da aŋpulugagɨt do nandaŋek mani aŋenokgeŋ. Jɨgɨni toŋ amɨn da uŋun do nandaŋek but galaksi nandani. ");
INSERT INTO yut_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Yawe dakon man madepni do yaŋek aŋkɨsineŋ. ");
INSERT INTO yut_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Yawe da nak aŋpulugosak do bɨsit iyɨko nandagɨt. Pasol pasolno wɨrɨrɨkban but yawot pagɨm. ");
INSERT INTO yut_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Yawe nandaŋ gadaŋ ɨmaŋ amɨn kɨsɨk kɨsɨk aŋek mayagɨ dɨma nandaŋ. ");
INSERT INTO yut_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Nak jɨgɨkon egek Yawe do yaŋ tɨdoko bɨsitno nandaŋek jɨgɨ morapnokon naŋ pulugaŋ nepgut. ");
INSERT INTO yut_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Yawe dakon aŋelo da Yawe do pasal ɨmaŋ amɨn da kapmatjok egek yokwikon baŋ paŋpulugosok. ");
INSERT INTO yut_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Yawe aŋkɨlɨk koni, uŋun tagɨsi. Paŋkutnosak do kwaŋ amɨn uŋun kɨsɨk kɨsɨk tagɨ ani. ");
INSERT INTO yut_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Mɨŋat amɨn kabɨyoni ji Yawe do pasal ɨmni. Nido pasal ɨmaŋ amɨn uŋun yo kɨnda do wadak wadak dɨma aŋ. ");
INSERT INTO yut_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Laion da jap do aŋ, mani Yawe wɨsɨŋ kok do pi aŋ amɨn uŋun yo tagɨsi do wadak wadak dɨma aŋ. ");
INSERT INTO yut_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Mɨŋat monjiyono, abɨŋek mɨrak yopgut. Apba Yawe do pasol pasol ani do dayɨŋ dekgo. ");
INSERT INTO yut_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Ji mɨktɨmon bɨsap dubagɨ egek egɨp egɨp tagɨsi egek kɨsɨk kɨsɨk ak do nandaŋ? ");
INSERT INTO yut_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Yaŋ egɨp do nandaŋ kaŋ, ji gen yokwi dɨma yoni, ae top gen dɨma yoni. ");
INSERT INTO yut_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Ji aŋpak yokwi manji yomɨŋek aŋpak kɨlegɨsi gɨn ani. Amɨn gat but kaloŋ aŋek egɨp do pini si teban taŋek ani. ");
INSERT INTO yut_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Yawe uŋun amɨn kɨlegɨ kɨlani aŋek bɨsitni nandaŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Mani yokwi aŋ amɨn dɨma galak taŋ yomɨsak. Kɨmagakwa amɨn da ɨŋtaŋ yomdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Amɨn kɨlegɨ Yawe bɨsit aŋ ɨba nandaŋ yomɨsak. Paŋpulugaŋban jɨgɨ da dɨma pabɨŋ yopmaŋgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Yawe butjɨgon da egɨsak amɨn da kapmatjok egɨsak, ae nagon yo tagɨ dɨ dɨma noman tokdaŋ yaŋ nandɨsak amɨn uŋun aŋpulugosok. ");
INSERT INTO yut_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Amɨn kɨlegɨ jɨgɨ morapmɨ noman taŋ yomaŋ, mani Yawe da jɨgɨ morapnikon baŋ pulugaŋ yopmaŋdak. ");
INSERT INTO yut_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Yawe da kɨlani tagɨsi aŋakwan amɨn kɨnda da kɨdatni kɨnda dɨma jokgaldɨsak. ");
INSERT INTO yut_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Aŋpak yokwi da yokwi aŋ amɨn dapba kɨmotdaŋ. Amɨn kɨlegɨ dakon uwalni Yawe da tepmɨ pi yomdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Mani Yawe da iyɨ dakon oman amɨni yokwikon baŋ yumaŋ naŋ yopmaŋdak. Amɨn morap paŋkutnosak do nandaŋ ɨmaŋ amɨn uŋun dɨma tasɨk toni do yoyɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Dewit dakon kap kɨnda. Yawe, kosit sopmaŋ namaŋ amɨn dakon kositni sopmaŋ yobi. Ae amɨn nak gat emat amaŋ amɨn, gak uŋun gat emat ani. ");
INSERT INTO yut_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Emat dakon yɨk ɨmalyo gat ae pasɨk gat tɨmɨgek abɨŋ nak aŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Dɨkdɨk gat ae gwawiya gat tɨmɨgek nak aŋ sopmaŋgaŋ amɨnon emat abi. “Nak yokwikon baŋ tɨmɨt tɨmɨt amɨngo!” yaŋ nayɨki. ");
INSERT INTO yut_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Uŋun amɨn da nɨkba kɨmokgeŋ do nolgaŋ. Pabɨŋ yopmaŋaki mayaktok pani. Uŋun da nak aŋupbal ak do gen yaŋ paŋteban aŋ. Yopbɨ tobɨl kɨŋakwa paŋɨŋtok abi dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Yawe, mɨrɨm da wit dakon gɨpmɨ wɨrɨrɨk paŋgwaŋ, uŋun da tɨlak aŋelogo da amɨn yokwi uŋun wɨrɨrɨtjak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Aŋelogo da yolban kɨŋakwa kositni aban pɨlɨn tuk ae sagalegɨyo ani dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Nak da yokwi kɨnda dɨma aŋ yomgum, mani nak abɨdok do pat yɨpgwit, ae nak da mokeŋ do gapma kɨnda wayɨkgwit. ");
INSERT INTO yut_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Yaŋ awit, do dɨma nandaŋakwa gak da yum pɨndagaki yokwi da tɨmɨtjak, ae pat yɨpgwiron iyɨ yokwalni, ae gapma uŋun wayɨkgwiron iyɨ uŋudon moni. ");
INSERT INTO yut_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Yawe da yaŋ aŋakwan but galak nandaŋ ɨmdɨsat. Nak aŋpulugokdɨsak do tagɨsi nandaŋ ɨmdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Butnokon da yaŋ iyɨkeŋ, “Yawe, gak yombem kɨnda mɨni. Gak da tapmɨmni mɨni amɨn uŋun tagɨsi paŋpulugaŋaki amɨn tapmɨmni toŋ da dɨma paŋupbal aŋ. Gak da bupmɨ amɨn wadak wadak aŋ uŋun paŋpulugaŋaki kabo noknok da yoni dɨma tɨmɨkgaŋ.” ");
INSERT INTO yut_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Top amɨn da aŋpak yokwi dɨ dɨma agɨmon gen yaŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Nak aŋpak tagɨ baŋ aŋ yomɨŋapbo, uŋun da kobogɨ do aŋpak yokwi baŋ aŋ namaŋ. Do but yokwi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Mani sot awit bɨsapmon bupmɨ madepsi nandaŋ yomɨŋek bupmɨ dakon ɨmal wamgum. Nak jap kelek egek gak da paŋpulugoki do bɨsit agɨm. ");
INSERT INTO yut_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Uŋun notno bo ae padɨgɨno yombem kɨnda do bupmɨ nandagɨm. Nak amɨn kɨnda da meŋi kɨmagakwan bupmɨ ae kunamyokon da agɨsak uŋun yombem. But yokwi nandaŋek kunam ae bupmɨyo aŋek egɨpgum. ");
INSERT INTO yut_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Mani jɨgɨ pasat bɨsapmon uŋun muwugek kɨsɨk kɨsɨk aŋ. Ae amɨn dɨ dɨma nandaŋ yomɨsat uŋun da abɨŋ nep do muwukgaŋ. Ak nandarɨ mɨni gen yokwi yaŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Uŋun da yaŋsul sigɨn yaŋ namɨŋek gen yokwisi nayaŋ. Dɨma galak taŋ namɨŋek mam noŋ. ");
INSERT INTO yut_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Amɨn Tagɨ, bɨsap niaŋ da sigɨn yum pɨndagek nak dɨma aŋpulugoki? Aŋpulugaŋaki nak dɨma aŋupbal ani. Uŋun laion yombem da nak nɨtdaŋ, do uŋun da kɨsiron baŋ pulugoki. ");
INSERT INTO yut_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Gak da yaŋ aŋaki mɨŋat amɨn kabi morapmɨ kɨsi gak gawak gamdo muwutnikon ya yaŋ gayɨkeŋ. Asisi, mɨŋat amɨn kabɨ madepsi da binapmon mango awɨgɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Amɨn dɨwarɨ ɨsal dogɨn uwal aŋ namaŋ. Yum pɨndakbɨ nak abɨŋ nepmaŋek kɨsɨk kɨsɨk dɨ abam. Uŋun ɨsal dogɨn nandaba yokwi tok aŋ namaŋ. Do yum pɨndagaki nak dakon jɨgɨ do kɨsɨk kɨsɨk dɨma ani. ");
INSERT INTO yut_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Amɨn dɨwarɨ gat yɨtyɨt tagɨsi ak do genjok dɨ dɨma yoŋ. Amɨn kokupmon tagɨsi ekwaŋ uŋun paŋupbal ak do gen baŋ yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Uŋun da gen papmon da gen yaŋsi yaŋ namaŋ, “Asisi, nin da gandaŋapno aŋpak yokwi agɨl.” ");
INSERT INTO yut_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Yawe, gak da uŋun amɨn kɨlɨ pɨndak mudal. Gen mapmɨt dɨma aki. Amɨn Tagɨ, gak nak da dubagɨkon dɨma egɨpbi. ");
INSERT INTO yut_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Gak Piŋkopno ae Amɨn Tagɨno. Pɨdaŋ abɨŋ nak aŋpulugaŋek gen kokwin kɨlegɨsi aŋ nabi. Pɨdaŋek nak dakon gen aŋteban ak do yaŋ teŋteŋok abi. ");
INSERT INTO yut_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Yawe Piŋkopno, gak aŋpak kɨlegɨ asal. Do nak aŋpulugaŋbɨ uwalno da nak aŋpak kɨlegɨ asat yaŋsi nandani. Yum pɨndagaki nak da yokwi toko nandaŋek kɨsɨk kɨsɨk dɨma ani. ");
INSERT INTO yut_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Yum pɨndagaki iyɨ do “Nin yo ak do nandagɨmaŋ uŋun abɨsok tagɨsisi kɨlɨ uŋun amaŋ” yaŋ dɨma yoni. Yum pɨndagaki “Kɨlɨ aŋupbal amaŋ” yaŋ dɨma yoni. ");
INSERT INTO yut_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Nagon jɨgɨ noman tak uŋun do kɨsɨk kɨsɨk aŋ, do paŋmayak aŋek paŋɨŋtok abi. Uŋun iyɨ dakon man pawɨgɨk do aŋek nak abɨŋ nepmaŋgaŋ, do mayaktok yomɨŋek mani pabɨŋ yopbi dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Mani nak do amɨn kɨlegɨ yaŋ nayɨki do nandaŋ amɨn, uŋun kɨsɨk kɨsɨk dakon yaŋ tɨdok aŋek burɨ tagɨsi toni dosi nandɨsat. Bɨsapmɨ bɨsapmɨ yaŋ yoni, “Yawe uŋun mani wukwisi! Oman amɨni tagɨsi egɨpjak do but galaksi nandɨsak.” ");
INSERT INTO yut_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Yaŋ aŋakwa nak da aŋpakgo kɨlegɨ do yaŋ teŋteŋok aŋek gɨldat kɨnda kaloŋ gak aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Yawe dakon oman amɨn Dewit da kap on mandagɨt. Kap on kap yoŋ dakon kɨla amɨn do mandabi. Yokwi uŋun amɨn yokwi da buron yɨgek gen iyɨsak. Uŋun amɨn Piŋkop do dɨsok dɨmasi pasoldok. ");
INSERT INTO yut_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Uŋun iyɨ do nandaban wɨgakwan nak yokwi pakpak amɨnsi kɨnda yaŋ iyɨ do dɨma nandɨsak. ");
INSERT INTO yut_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Bɨsapmɨ bɨsapmɨ uŋun amɨn gen yokwi gat ae top gen yosok. Aŋpak kɨlegɨ asak dakon nandaŋ kokwin tagɨsi dɨsok dɨma taŋ ɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Dɨpmɨn tamokon pokdok bɨsapmon yokwi asak dakon kosit dakon nandak nandak asak. Kosit yokwisi baŋgɨn agek aŋpak yokwi manji dɨma yomɨsak. Piŋkop dakon aŋpak tagɨsi ");
INSERT INTO yut_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Yawe, gak amɨn do but dasi galak taŋ yomɨsal. Uŋun dakon tɨlakni kundu gat arɨp, madepsi. Ae gengo aŋteban aŋek nin tagɨsi paŋpulugosol. Tɨlakni uŋun kwen ason gɨkwem da arɨp. ");
INSERT INTO yut_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Aŋpakgo kɨlegɨ uŋun madepsi kabap daman yombem. Gen kokwin pi agakgo uŋun tap ɨdap ɨlarɨsi yombem. Yawe, gak da amɨn gat bɨt kɨlapyo gat kɨlani aŋaki tagɨsi ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Piŋkop, amɨn do but dasi galak taŋ yomyomgo uŋun wagɨl tagɨsisi. Mɨŋat amɨn morap kɨsisi gagon obɨŋek pasɨlgaŋ. Pup pɨdok meŋi da pɨrɨgwan paŋkɨ pasɨl yɨkgaŋ uŋun yombem. ");
INSERT INTO yut_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Yutgokon jap morapmɨsi, do amɨn jap do dɨma aŋ. Yogo galagɨsi uŋun morapmɨsi. Uŋun pakbi madep pokgoŋ uŋun baŋ yaŋ yobɨ noŋ. ");
INSERT INTO yut_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Gak egɨp egɨp dakon mibɨlɨsi. Gak gaga teŋteŋɨ amisi, do teŋteŋɨgokon yo morap tagɨsi pɨndakgamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Bɨsapmɨ bɨsapmɨ amɨn si nandaŋ gamaŋ uŋun amɨn but dasi galak taŋ yobi. Burɨ tagɨsi amɨn paŋpulugaŋaki tagɨsi egɨpni. ");
INSERT INTO yut_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Gak yum pɨndagaki iyɨ do nandaba wɨgɨsak amɨn da nak dɨma bamoni. Ae yum pɨndagaki amɨn yokwi da nak dɨma nolba kɨkeŋ dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Pɨndakgi! Amɨn yokwi mɨktɨmon pɨlɨgɨ maŋ da pokgoŋ, ae arɨpmɨ dɨma pɨdokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Dewit dakon kap kɨnda. Gak amɨn yokwi da aŋpak aŋ uŋun do nandaba kɨk dɨma abi. Gak aŋpak yokwi aŋ amɨn pɨndagek nak da yaŋ asat tam tagɨ yaŋ dɨma nandabi. ");
INSERT INTO yut_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Uŋun joŋ bo ae kɨndap tam da kɨbɨdoŋ, uŋun da tɨlak amɨn yokwi bɨsap pɨsɨpmɨsok kɨbɨdokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Gak egɨp egɨpgo Piŋkopmon tosok yaŋ nandaŋek aŋpak tagɨsi baŋ abi. Yaŋ aŋek mɨktɨmgokon bɨsap dubak tagɨsi egɨpdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Piŋkop do kɨsɨk kɨsɨk aŋ ɨmɨŋaki yo galak tosol uŋun gamjak. ");
INSERT INTO yut_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Gak egɨp egɨpgo Yawe da kɨsiron yɨpbi. Egɨp egɨpno uŋudon tosok yaŋ nandaŋ ɨmɨŋaki, uŋun da gak aŋpulugosak. ");
INSERT INTO yut_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Aŋpakgo tagɨsi uŋun aban noman gɨldat dabɨl da yaŋ teŋteŋokdɨsak. Aŋek gɨldat dabɨl da gɨldat binapsi wɨsisak, uŋun da tɨlak mɨŋat amɨnyo da dabɨlon aŋpakgo kɨlegɨ nomansi aŋteŋteŋ akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Gak Yawe da kapmatjok tayaŋgok yɨkgi. Tayaŋgok egek butgo yaworɨ taŋakwan aŋpulugosak do jomjom abi. Amɨn da aŋpak yokwi mibɨlɨ mibɨlɨ aŋek yo tagɨsi morapmɨ tɨmɨkgaŋ uŋun do nandaba kɨk dɨma abi. ");
INSERT INTO yut_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","9","Amɨn yokwi wagɨl tasɨk taŋ mudokdaŋ. Mani mɨŋat amɨnyo nandaŋ gadat aŋek Yawe da paŋpulugosak do jomjom aŋ, uŋun mɨktɨmnikon tagɨsi egɨpdaŋ. Do gak butjap yɨpbisi. Ae nandaba kɨk yo kɨsi dɨma abi. Yaŋ abi kaŋ, uŋun da gak ɨlɨk aŋkwan yokwi akdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Bɨsap dubak dɨma amɨn yokwi wagɨl tasɨk taŋ mudokdaŋ. Uŋun wusɨŋ pɨndat do pi abi, mani dɨma pɨndatdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Mani mɨŋat amɨnyo aŋpakni yaworɨ, uŋun Piŋkop da mɨktɨm morap kɨsi yomdɨsak. Uŋun yɨyɨt wagɨl tagɨsi aŋek kɨsɨk kɨsɨk egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Amɨn yokwi amɨn kɨlegɨ paŋupbal ak do nandak nandak asak. Aŋek nandaban yokwi tok aŋ yomɨŋek mam naŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Mani Amɨn Tagɨ da nandɨsak, bɨsap kɨnda noman tokdɨsak, uŋun bɨsapmon amɨn yokwi pasɨl mudokdaŋ, do Yawe da jɨkgo yanjaŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Amɨn yokwi uŋun yoni mɨni amɨn gat ae wadak wadak aŋ amɨn yam do emat agak sɨbani yɨknikon baŋ ɨlɨkgaŋ, ae obip paŋɨlɨkgaŋ. Uŋun aŋpak kɨlegɨ yolgaŋ amɨn dapba kɨmot do aŋ. ");
INSERT INTO yut_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Mani emat agak sɨba da iyɨ baŋ wamɨkon sugokdaŋ. Aŋakwa obipni si jokgal kɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Amɨn kɨlegɨ dakon yoni kaloŋɨsok uŋun da amɨn yokwi dakon yoni morapmɨ yapmaŋ mudosok. ");
INSERT INTO yut_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Nido, Yawe da amɨn yokwi dakon tapmɨm pabɨŋ yopmaŋek amɨn kɨlegɨ kɨlani tagɨsi akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Yawe da gulusuŋni mɨni amɨn uŋun kɨlani tagɨsi asak. Ae yo tagɨsi yomɨsak uŋun toktogɨsi tɨmɨk wugɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Bɨsap yokwikon jɨgɨ dɨma pakdaŋ. Ae amɨn dɨwarɨ jap do ani bɨsapmon amɨn kɨlegɨ japni morapmɨ taŋ yomdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Mani amɨn yokwi tasɨk taŋ mudokdaŋ. Jareŋ gat joŋ gat da pasɨlgaŋ, uŋun da tɨlak Yawe dakon uwalni pasɨldaŋ. Asisi, mukwa da bɨsap pɨsɨpmɨsok taŋek pasɨlgaŋ, uŋun da tɨlak pasɨldaŋ. ");
INSERT INTO yut_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Amɨn yokwi yo do goman aŋek sop do dɨma nandɨsak. Mani amɨn kɨlegɨ amɨn dɨwarɨ do yo morapmɨ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Mɨŋat amɨnyo Yawe da gɨsamɨkdak, uŋun mɨktɨmni tɨmɨgek tagɨsi egɨpdaŋ. Mani mɨŋat amɨnyo jobɨt tɨmɨtni do yagɨt uŋun wagɨl tasɨk taŋ mudokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Yawe da amɨn kɨnda do but dasi galak taŋ ɨmɨsak kaŋ, uŋun amɨn aŋteban aŋakwan kosit kɨlegɨsi agɨsak. ");
INSERT INTO yut_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Uŋun amɨn mosak kaŋ, wagɨlsi dɨma yokwi tosak. Yawe da kɨsitnikon abɨdaŋek aŋpulugaŋban aeni pɨdaŋ akdak. ");
INSERT INTO yut_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Kalɨp nak monjɨ bulagɨ, ae abɨsok nak amɨn pelaŋ kɨlɨ at. Mani Piŋkop da amɨn kɨlegɨ kɨnda manji dɨma ɨban kagɨm. Ae amɨn kɨlegɨ dakon monjɨ gwayoni jap do wadak wadak aŋek amɨn da paŋpulugoni do dɨma yaŋ tɨdaŋba pɨndakgɨm. ");
INSERT INTO yut_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Bɨsapmɨ bɨsapmɨ amɨn kɨlegɨ da amɨn dɨwarɨ do yo morapmɨ yomaŋ. Ae monjɨ gwayoni da meŋ datni kɨsɨk kɨsɨk yomaŋ. ");
INSERT INTO yut_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Gak aŋpak yokwi morap do manji yomɨŋek aŋpak tagɨ baŋgɨn abi. Yaŋ abi kaŋ, dagok dagogɨ mɨni mɨktɨmon tagɨsi egɨpdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Nido Yawe gen kokwin kɨlegɨsi aŋ amɨn do but dasi galak taŋ yomɨsak. Mɨŋat amɨn kabɨni geni guramɨkgaŋ uŋun manji dɨma yomdɨsak. Dagok dagogɨ mɨni Yawe da kosit kɨlegɨ akwaŋ amɨn kɨlani asak, mani amɨn yokwi dakon gwakni uŋun tasɨk tokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Amɨn kɨlegɨ Piŋkop da mɨktɨm yomgut uŋun abɨdaŋek uŋudon toktogɨsi egɨ wugɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Amɨn kɨlegɨ uŋun nandaŋ kokwin kɨlegɨsi aŋek gen yosok. Uŋun gen kokwin kɨlegɨ aŋek gen yosok. ");
INSERT INTO yut_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Piŋkop dakon nawa gen butnikon tosok, ae kositni kɨlegɨ uŋun dɨma yɨpmaŋ degek sagalek dɨma aŋakdak. ");
INSERT INTO yut_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Amɨn yokwi amɨn kɨlegɨ aŋakban kɨmotjak do yubɨŋ egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Mani Yawe da amɨn kɨlegɨ yɨpmaŋ dekban amɨn yokwi da arɨpmɨ dɨma aŋakban kɨmotjak. Ae amɨn yokwi da amɨn kɨlegɨ gen pikon yɨpjak kaŋ, Yawe da yum kaŋakwan gen pikon arɨpmɨ dɨma abɨŋ yɨpjak. ");
INSERT INTO yut_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Yawe da gak aŋpulugosak do jomjom aŋek aŋpakni yolgi. Yaŋ abi kaŋ, man madep gamɨŋakwan mɨktɨm uŋun gamgut uŋun abɨdokdɨsal. Aŋek kaŋaki amɨn yokwi paŋupbal akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Nak amɨn yokwi tapmɨmni madepsi kɨnda kagɨm. Sida kɨndap da kɨndap dɨwarɨ yapmaŋ mudosok, uŋun da tɨlak mɨŋat amɨnyo yapmaŋ mudagɨt. ");
INSERT INTO yut_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Mani don uŋudon kɨŋek mɨni kagɨm. Nak uŋun amɨn wusɨk do pi agɨm, mani dɨma kagɨm. ");
INSERT INTO yut_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Amɨn kɨlegɨ, ae gulusuŋni mɨni, ae amɨn dɨwarɨ gat yaworɨsi ekwaŋ amɨn do nandaki. Uŋun amɨn dakon dɨwatni tagɨsi egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Mani Yawe da yokwi pakpak obɨsi paŋupbal akdɨsak. Uŋun dakon dɨwatni wagɨl tasɨk taŋ mudokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Yawe da amɨn kɨlegɨ yokwikon baŋ tɨmɨkdak. Jɨgɨ altaŋ yomaŋ bɨsapmon dam tebani arɨpmɨ dɨma tuwɨlɨ egɨ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Paŋkutnosak do Yawekon kwaŋ, do amɨn yokwi da kɨsiron baŋ tɨmɨgakwan tagɨsi ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Dewit dakon kap kɨnda. Yawe, butjap nandɨsal mani gen tebai dɨma nayɨki. Butjap madepsi nandɨsal mani nak aŋmɨlɨp ak do tepmɨ pi dɨma nabi. ");
INSERT INTO yut_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Gak gaga dakon gobɨŋ naŋ yamaŋ namɨl, aŋek kɨsitgo da nɨkdak. ");
INSERT INTO yut_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Gak da butjap nandaŋ namɨsal, do sot yokwisi asat. Nak dɨwarɨno toŋ, do gɨptɨmno tapmɨmɨ mɨnisi asak. ");
INSERT INTO yut_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Gulusuŋno da kɨlɨ wɨtjɨŋ namgut. Ae uŋun jɨgɨno yɨk yombem jɨgɨni madepsi, do nak da arɨpmɨ dɨma ɨmerɨ. ");
INSERT INTO yut_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Gɨptɨmnokon wuda toŋ dakon tabani uŋun madepsi, ae mɨktaŋbi. Nak nandaŋ kokwini mɨni amɨn da arɨpmon aŋpak gulusuŋ agɨm do aŋek uŋun noman taŋ nameŋ. ");
INSERT INTO yut_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Butnokon jɨgɨ madepsi taŋakwan tasɨk tosot. Gɨldat kɨnda kaloŋ bupmɨ nandaŋek kunam gɨn tak egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Gɨptɨmno tedepmɨsi kɨndap da yaŋ soŋ namɨŋakwan sot madepsi asat. ");
INSERT INTO yut_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Yo kɨnda da tebaisi bamaŋ namɨsak uŋun da tɨlak nak obɨsi tasɨk taŋek yokwisi egɨsat. Butnokon da yokwisi nandaŋek tepmɨ madepsi nandɨsat do iyoŋ iyoŋ yosot. ");
INSERT INTO yut_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Amɨn Tagɨ, gak da nak dakon galaktok teban nandɨsal. Butno da kunam yokwisi takdak, uŋun gak da dabɨlon pasɨlɨ dɨma. ");
INSERT INTO yut_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Wamno gami pi tebaisi aŋakwan tapmɨmno mɨnisi asak. Dabɨlno pɨlɨn taŋakwan tagɨ dɨma sɨŋtosot. ");
INSERT INTO yut_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Notnoni gat ae gen kaloŋno gat nak da kapmatjok ap do dɨma galak toŋ, nido wudano yokwisi. Gwakno kɨsi dubagɨkon ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Nɨkba kɨmokgeŋ do nandaŋ amɨn uŋun nak abɨdok do pat yɨpmaŋ. Amɨn nak aŋtasɨk ak do nandaŋ amɨn yo yokwi aŋ nam do gen yoŋ. Bɨsapmɨ bɨsapmɨ yokwi aŋ nam do gen yaŋ paŋteban aŋ. ");
INSERT INTO yut_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Mani amɨn mɨrakni mɨni yombem geni dɨma nandaŋ yomɨsat. Nak kadɨm yombem, do aŋtaŋ yok kɨnda dɨma asat. ");
INSERT INTO yut_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Nak amɨn kɨnda gen arɨpmɨ dɨma nandagɨ, ae kobogɨ arɨpmɨ dɨma yogogɨ yombem. ");
INSERT INTO yut_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Mani Yawe, nak gak do jomjom asat. Amɨn Tagɨ, gak Piŋkopno, do gaga geno dakon kobogɨ aŋtobɨlbi. ");
INSERT INTO yut_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Nak bɨsit yaŋ asat, “Yum pɨndagaki sagalek nɨkban uwal da but kwaktok dɨma nandani.” ");
INSERT INTO yut_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Nido, nak kɨlɨ uŋunjok mokdɨsat. Ae tepmɨ toktogɨsi pasat. ");
INSERT INTO yut_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Nak gulusuŋno gagon yaŋ teŋteŋosot, aŋek yokwi agɨm do bupmɨsi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Uwal morapno uŋun tapmɨmɨ toŋsi. Uŋun da ɨsal dogɨn uwal aŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Nak aŋpak tagɨsi aŋ yomɨsat, mani kobogɨ do aŋpak yokwi aŋ namaŋ. Nak aŋpak kɨlegɨ yolapbo uŋun do nandaŋek nak dakon uwal dagoŋ. ");
INSERT INTO yut_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Yawe, dɨma nepmaŋ dekgi. Piŋkopno, nak da dubagɨkon dɨma egɨpbi. ");
INSERT INTO yut_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Amɨn Tagɨ, gak yokwikon baŋ tɨmɨt tɨmɨt amɨno. Nak tepmɨsi aŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Dewit dakon kap kɨnda. Kap on kap yoŋ dakon kɨla amɨn Jedutun do mandabi. Nak kɨlɨ yagɨm, “Aŋpak morap abeŋ uŋun kɨla tagɨsi aŋek abeŋ. Ae gen yokeŋon yokwi kɨnda dɨma abeŋ. Amɨn yokwi nak da kapmatjok egɨpni bɨsapmon nak gen kɨnda dɨma yokeŋ.” ");
INSERT INTO yut_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Nak gen mapmɨt aŋek gen kɨnda dɨma yagɨm. Ae yo tagɨ kɨsi do genjok kɨnda dɨma yagɨm. Mani butjɨkno uŋun madepsi tagaŋek paptaŋ madepsi agɨt. ");
INSERT INTO yut_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Aŋek butnokon da nandaba kɨksi agɨm. Nak sigɨn nandaŋek butno da jɨgɨ madepsi nandagɨm, do gen yagɨm. ");
INSERT INTO yut_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Yawe bɨsit yaŋ iyɨgɨm, “Egɨp egɨpno dakon wasɨp nayɨŋbɨ nandako. Bɨsap niaŋ da egɨpbeŋ uŋun nayɨŋbɨ nandakeŋ. Egɨpbeŋ dakon bɨsap uŋun pɨsɨpmɨsok uŋun do nayɨki. ");
INSERT INTO yut_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Nak dakon bɨsap pɨsɨpmɨsok yɨpgul. Gak da dabɨlon nak dakon bɨsap yo ɨsalɨ. Amɨn kɨnda da mɨrɨm yawɨk pɨsosok, amɨn morap uŋun da tɨlak mɨktɨmon bɨsap pɨsɨpmɨsok gɨn ekwaŋ.” ");
INSERT INTO yut_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Amɨn morap gɨldat paŋopmon wupnin noman taŋek tepmɨ pasɨlgaŋ uŋun yombem. Yo morapmɨ tɨmɨt do pi madepsi aŋ, mani pi madep aŋ uŋun bamɨ mɨni. Amɨn da yo morapmɨ paŋmuwukgaŋ, mani namɨn da tɨmɨtjak uŋun dɨma nandaŋ. ");
INSERT INTO yut_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Mani Amɨn Tagɨ, abɨsok nak nido jomjom asat? Nak gak do nandaŋ gadaŋek gak dagɨn aŋpulugoki do jomjom asat. ");
INSERT INTO yut_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Yokwikon naŋ abɨdaŋek dɨwarɨ morapno wɨrɨrɨk nabi. Yum pɨndagaki nandaŋ kokwini tagɨ dɨma amɨn da yaŋsul dɨma aŋ namni. ");
INSERT INTO yut_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Mani nak gen dɨma yosot. Nak gen mapmɨt gɨn asat. Nido, gak da gaga nak do yo uŋun asal. ");
INSERT INTO yut_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Saŋbeŋek tepmɨ pi dɨma nabi. Obɨsi nɨkgɨl, do tapmɨmno mɨnisi asak. ");
INSERT INTO yut_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Gak da amɨn tebai yoyɨŋek yokwini dakon kobogɨ yomɨsal. Yo monɨŋ da ɨmal kɨnda naŋba yokwi tosok, uŋun da tɨlak yo morap uŋun do galak tosok uŋun wagɨl wɨrɨrɨkbɨ pasɨl mudoŋ. Amɨn kɨnda da mɨrɨm pɨsosok, amɨn morap uŋun da tɨlak mɨktɨmon bɨsap pɨsɨpmɨsok gɨn ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Yawe, bɨsitno nandaki. Aŋpulugoki do yaŋ tɨdosot uŋun do mɨrak pakyaŋsi yopbi. Mɨrakgo dɨma sopbi, nido gak gat bɨsap pɨsɨpmɨsok gɨn mɨktɨmon egɨpdamak. Nak babɨkno yombem. Uŋun kɨsi bɨsap pɨsɨpmɨsok gɨn mɨktɨmon egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Saŋbeŋek yo yokwisi dɨma aŋ nabi. Yum nandaŋaki butno ae tagɨsi asak. Aŋaki don kɨmagek on mɨktɨm wagɨl yɨpmaŋ dekgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Dewit dakon kap kɨnda. Kap on kap yoŋ dakon kɨla amɨn do mandabi. Nak butno yaworɨ taŋakwan Yawe da aŋpulugosak do jomjom agɨm. Aŋek yaŋ tɨdaŋapbo nak da tetgɨn do tobɨlek tekno nandagɨt. ");
INSERT INTO yut_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Nak gapma dubagɨsikon maŋ neŋak kagagwan egapbo Yawe da ɨlɨkban wɨgɨm. Awɨŋ tɨp kwenon nepban kosit tagɨ agɨpgum. ");
INSERT INTO yut_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Piŋkopnin aŋkɨsikeŋ do kap kalugɨ kɨnda namgut. Amɨn morapmɨ da yo agɨt uŋun kaŋek Yawe do pasalek egɨp egɨpni Yawekon tosok yaŋsi nandaŋ ɨmdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Egɨp egɨpni Yawekon tosok yaŋsi nandaŋ amɨn uŋun kɨsɨk kɨsɨk ekwaŋ. Uŋuden amɨn iyɨ do nandaba wɨkwaŋ amɨn dɨma yolgaŋ, ae kokup kɨdat dɨma gawak yomaŋ. ");
INSERT INTO yut_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Yawe Piŋkopno, gak nin paŋpulugok do yo tagɨsi morapmɨ agɨl. Gak da nin do nandak nandak asal uŋun madepsi, ae nin paŋpulugok do pi asal uŋun manjɨrɨ mɨni. Nak da amɨn arɨpmɨ dɨma yoyɨko nandaŋ mudogɨ. ");
INSERT INTO yut_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Amɨn da bɨt kɨlapyo dapmaŋ mukwa sosoŋ, ae kɨndapmon wagɨl soŋba sosoŋ, ae dɨwarɨ wɨrɨrɨt do mukwa sosoŋ, uŋun kɨsi do madepsi dɨma galak tosol. Mani gak da nak aŋtagap abɨ gak dakon gengo guramɨt do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Do yaŋ yosot, “Nak gagon kɨlɨ abɨsat. Kalɨp nak do gen kɨlɨ mandabi uŋun yaŋ, ");
INSERT INTO yut_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Piŋkopno, nak gak dakon galaktok yol do tagɨsi nandɨsat. Gak dakon nawa gen butnokon toŋ.” ");
INSERT INTO yut_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Gak da aŋpak kɨlegɨ asal uŋun mɨŋat amɨn kabi morapmɨ kɨsi gak gawak gamdo muwukgaŋon yoyɨsat. Yawe gaga nandɨsal, nak gen mapmɨt dɨma asat. ");
INSERT INTO yut_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Gak da aŋpakgo kɨlegɨkon da nak yokwikon baŋ pulugaŋ nepgul, uŋun dakon geni dɨma wɨtjɨko tagɨt. Gengo guramɨgek nin yokwikon baŋ tɨmɨkgɨl uŋun dakon yaŋkwok asat. Amɨn do but dasi galak taŋ yomɨsal ae aŋpak bamɨsi gɨn asal uŋun dakon geni amɨn morapmɨ muwugakwa yoyɨŋ teŋteŋosot. ");
INSERT INTO yut_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Yawe, bupmɨ nandaŋ nabi. Nak do but dasi galak taŋ namɨŋek gengo guramɨgek kɨlano dagok dagogɨ mɨnisi abi do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Nido jɨgɨ morapmɨ noman taŋ namaŋ, uŋun manjɨrɨ mɨni. Yokwino morapmɨ da wɨtjɨŋ namɨk da tagɨ dɨma sɨŋtosot. Aŋpakno yokwi morapmɨ da busuŋ daŋgwano dakon tɨlak yapmaŋdak. Butno tagɨ dɨma taŋakwan tapmɨmno mɨnisi asak. ");
INSERT INTO yut_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Yawe, jɨgɨkon naŋ tagɨ abɨdoki? Yawe, tepmɨsi abɨŋek nak aŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Amɨn dɨ da nɨkba kɨmotdɨsat. Gak da si pabɨŋ yopmaŋek paŋɨŋ tok abi, aŋaki mayaktok pani. Amɨn dɨwarɨ nak dakon jɨgɨno do kɨsɨk kɨsɨk aŋ. Gak da wɨrɨrɨkbi tobɨl kɨŋakwa pabɨŋ yopbi dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Nak da yokwi toko nandaŋek tagɨsi nandaŋ. Gak da mayaktok sigɨn yomɨŋaki aŋpak yokwini do gembɨŋ pɨkpɨksi nandani dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Mani gak wɨsɨŋ gandak do pi aŋ amɨn burɨ tagɨsi aŋakwa but galaksi nandaŋ. Mɨŋat amɨnyo gak da yokwikon baŋ tɨmɨkgɨl uŋun do but galaksi nandaŋ amɨn, uŋun da, “Yawe uŋun wukwisi” yaŋ tagɨ yoni. ");
INSERT INTO yut_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Nak wadak wadak amɨn. Mani Amɨn Tagɨ da nak do nandak nandak asak. Piŋkop, gak dagɨn paŋpulugok amɨno, ae nak yokwikon naŋ abɨdosol. Do jomjom dɨma abi. Tepmɨsi nak aŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Dewit dakon kap kɨnda. Kap on kap yoŋ dakon kɨla amɨn do mandabi. Amɨn kɨnda da tapmɨmni mɨni amɨn pɨndagek paŋpulugosok, uŋun amɨn kɨsɨk kɨsɨk tagɨ asak. Jɨgɨ altaŋ ɨmni bɨsapmon Yawe da pulugaŋ yɨpdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Yawe da uŋun amɨn aŋkutnaŋakwan kɨmot dɨma asak. Kɨlani aŋakwan mɨktɨmnikon gɨsamɨ toŋ egakwan uwalni da dɨma abɨŋ yɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Amɨn uŋun sot asak bɨsapmon Yawe da aŋmɨlɨp aban tapmɨm kaluk pakdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Nak yaŋ yagɨm, “Yawe, nak yokwi gak do aŋgamɨsat, do bupmɨ nandaŋ namɨŋek sotno aŋmɨlɨp abɨ pasɨljak.” ");
INSERT INTO yut_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Uwalno da nandaba yokwi taŋban namɨŋek yaŋ yoŋ, “Ni bɨsapmon kɨmagek mani pasɨljak?” ");
INSERT INTO yut_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Kɨnda da abɨŋ nandaŋek top yaŋ namɨsak. Aŋek sotno dakon mibɨlɨ nandaŋek kɨŋ amɨn yoyɨŋek aŋupbal ak do yosok. ");
INSERT INTO yut_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Uwalno kɨsi da muwugek gen pɨsɨgon da yo yokwisi kɨnda da altaŋ ɨmɨk yaŋ yaŋek yaŋ yoŋ, ");
INSERT INTO yut_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","“Sot yokwisi kɨnda da abɨdak, do pokdok tamokon da arɨpmɨ dɨma pɨdosak.” ");
INSERT INTO yut_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Nak notno kɨnda kalɨp notnosi yaŋ nandaŋ ɨmɨŋek jap kaloŋɨ nagɨmak. Mani uŋunyo kɨsi da nandaba yokwi tok aŋ namɨŋek uwal aŋnamɨsak. ");
INSERT INTO yut_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Yawe, nak do bupmɨ nandaŋek sotno aŋmɨlɨp aŋaki uŋun amɨn kobogɨ yobeŋ. ");
INSERT INTO yut_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Uwalno da nak dɨma abɨŋ nepmaŋgaŋ, do nak yaŋsi nandɨsat, gak nak do tagɨsi nandaŋ namɨsal. ");
INSERT INTO yut_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Nak aŋpak kɨlegɨ gɨn asat, do kɨlano aŋaki gak da kapmatjok toktogɨsi egɨ wɨgɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Yawe, Israel amɨn dakon Piŋkop toktogɨsi aŋkɨsiŋ aŋaŋ wɨgɨneŋ teban. Uŋun asi. ");
INSERT INTO yut_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Kap on do “Maskil” yaŋ yoŋ. Uŋun Kora amɨn kabɨ dakon. Kap on kap yoŋ amɨn dakon kɨla amɨn do mandabi. Joŋ kɨlap dia mɨktɨm kɨbɨrɨ tɨmon pakbi do tep toŋ, uŋudeŋ nak Piŋkop gak gat egɨp do tagɨsi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Piŋkop, amɨn da pakbi do tep toŋ uŋudeŋ, nak Piŋkop egɨp egɨpmɨ toŋ gak do nandɨsat. Ni bɨsapmon kɨko Piŋkop gat egɨpdeŋ? ");
INSERT INTO yut_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Gɨldarɨ ae kalbiyo amɨn da yaŋ yoŋ, “Piŋkopgo dukon egɨsak?” Yaŋ nayaŋ, do bɨsapmɨ bɨsapmɨ kunam tagegɨsat. Gɨldarɨ ae kalbiyo kunam baŋ japmɨ do naŋegɨsat. ");
INSERT INTO yut_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Bɨsap tagɨsi kalɨpmɨ do nandaŋek butno obɨsi yokwi tosok. Kalɨp nak amɨn morapmɨ Piŋkop da yutnon mibɨltaŋ yomɨŋek paŋkɨgɨm. Nin kɨŋek kɨsɨk kɨsɨk do yaŋ tɨdagɨmaŋ. Aŋek ya yaŋ yagɨmaŋ. Uŋudon gak gawak gam do muwuk mamno kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Nido but yokwi nandɨsat? Nido butno jɨk tosok? Nak Piŋkop do nandaŋ gadaŋek uŋun da yokwikon baŋ kukwaŋ nepjak do jomjom abeŋ. Uŋun Piŋkopno, do aeno mani yaŋ aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Butno madepsi jɨk tosok, do nak gak do nandɨsat. Nak Jodan Pakbi tet do ae Ɨleŋ Emon ae Ɨleŋ Misa uŋudon egek aeno nandaŋ gamɨsat. ");
INSERT INTO yut_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Tap da tagaŋ wɨŋek ɨleŋon mɨktɨm wɨtjisak ae pakbi tek maŋakwa wɨwɨk madep asak, uŋudeŋ gɨn jɨgɨ morapmɨ da wɨtjɨŋ namɨŋakwa yokwisi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Yawe da gɨldaron but dasi galak taŋ namɨsak. Kalbi ya yaŋ iyɨk do kap yosot. Piŋkop egɨp egɨp namɨsak uŋun bɨsit iyɨsat. ");
INSERT INTO yut_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Piŋkop tɨp madepno yaŋ iyɨsat, “Gak nido ɨŋtaŋ namɨsal? Yum pɨndagaki uwal da abɨŋ nepmaŋakwa butno nido obɨsi jɨk tosok?” ");
INSERT INTO yut_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Toktogɨsi uwalno da sɨtnok aŋ namɨŋek yaŋ yoŋ, “Piŋkopgo dukon egɨsak?” Gen uŋun da gobɨŋ da yaŋ yamaŋ namɨŋakwan kɨmot do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Nido but yokwi nandɨsat? Nido butno jɨk tosok? Nak Piŋkop do nandaŋ gadaŋek uŋun da yokwikon baŋ kukwaŋ nepjak do jomjom abeŋ. Uŋun Piŋkopno, do aeno mani yaŋ aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Piŋkop, manji gamaŋ amɨn da nak abɨŋ nep do aŋ. Nak aŋpulugaŋek gen yokwi yaŋ namaŋ uŋun kosit sopmaŋ yobi. Aŋek aŋpak tagɨsi asat uŋun yolɨŋbɨ koni. Uŋun top amɨn, aŋpakni yokwisi, uŋun da kɨsiron baŋ pulugaŋ nepbi. ");
INSERT INTO yut_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Gak Piŋkopno. Amɨn yokwi da dɨma abɨdoni yaŋ do gagon obɨŋ pasɨldat. Yaŋ aŋapbo nido manji namɨsal? Nido uwal da abɨŋ nepmaŋakwa butno obɨsi jɨk tosok? ");
INSERT INTO yut_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Teŋteŋɨgo gat ae gengo bamɨ gat yopbɨ nagon obɨŋek kosit nolɨnjil. Nolɨŋbal kaŋek nomansi telagɨ ɨleŋgokon gaga egɨsalon wɨgɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Wɨgek gak da altakon opbeŋ. Piŋkop, gak da butno aŋtagap aŋaki kɨsɨk kɨsɨk madepsi nandɨsat. Gak Piŋkopno, do nak gita tɨdaŋek kap yaŋek mango aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Nido but yokwi nandɨsat? Nido butno jɨk tosok? Nak Piŋkop do nandaŋ gadaŋek uŋun da yokwikon baŋ kukwaŋ nepjak do jomjom abeŋ. Uŋun Piŋkopno, do aeno mani yaŋ aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Kap on do “Maskil” yaŋ yoŋ. Uŋun Kora amɨn kabɨ dakon. Kap on kap yoŋ dakon kɨla amɨn do mandabi. Piŋkop, babɨknin da kalɨp egɨpgwit bɨsapmon pi tapmɨmɨ toŋ agɨl uŋun dakon geni niyɨwit. Nin mɨrak yopmaŋek gen uŋun kɨlɨ nandagɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Gaga da tapmɨmon da amɨn ŋwakŋwarɨ mɨktɨmnikon egɨpgwit uŋun yolbɨ kɨwit. Aŋek uŋun mɨktɨm babɨknin do yomɨŋaki uŋudon tebai egɨpgwit. Gak da Amɨn Ŋwakŋwarɨ Kabɨ paŋupbal agɨl, mani babɨknin paŋpulugaŋaki tagɨsi egek madepsi ɨreŋ tawit. ");
INSERT INTO yut_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Babɨknin emat agak sɨbakon da mɨktɨm uŋun dɨma abɨdawit. Iyɨ dakon tapmɨmon da emaron dɨma teban tawit. Gak da but dasi galak taŋ yomgul do uŋun gat egek teŋteŋɨ yomgul. Gak da tapmɨmon gɨn emaron teban tawit. ");
INSERT INTO yut_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Gak Kɨla Amɨn Madepno ae Piŋkopno. Gak da yaŋaki Jekop dakon amɨn kabɨ da emaron teban toŋ. ");
INSERT INTO yut_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Gak da tapmɨmon gɨn uwalnin yolno kwaŋ. Gak da manon da uwalnin bamaŋ mɨsɨŋɨkgamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Obip da aŋpulugaŋban emaron teban tokeŋ yaŋ dɨma nandɨsat. Ae emat agak sɨbano da nak aŋpulugaŋban dɨma teban tokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Gak dagɨn paŋpulugaŋaki uwal da nin dɨma pabɨŋ nipgwit. Uŋun da nin do dɨma galak taŋ nimaŋ, mani gak da uŋun gat emat wamaŋek paŋmayak agɨl. ");
INSERT INTO yut_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Piŋkop, nin gɨldat kɨnda kaloŋ gak do man madep gamamaŋ. Bɨsap dagok dagogɨ mɨni mango aŋkɨsineŋ. ");
INSERT INTO yut_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Mani gak manji kɨlɨ nimgul, aŋek pabɨŋ nipmaŋek emat amɨnin gat kɨsi saŋbeŋek emaron dɨma kwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Yaŋ aŋaki uwal da paŋsopba pasal kɨŋapno yo kabɨnin kɨlɨ tɨmɨkgwit. ");
INSERT INTO yut_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Gak da yum nindaŋaki nin sipsip si dapba kɨmorɨ yombem da ekwamaŋ. Aŋek gak da mɨktɨmninon baŋ nolbɨ dukwan dukwan kɨŋ Amɨn Ŋwakŋwarɨ Kabɨ da binapmon ekwamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Gak da yum pɨndagaki mɨŋat amɨn kabɨgo Amɨn Ŋwakŋwarɨ Kabɨ dakon oman monjɨ dagawit. Yumaŋ naŋek tomni pɨŋbisi gamgwit, moneŋni madepsi dɨma tɨmɨkgɨl. ");
INSERT INTO yut_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Gak da ninon yaŋ aŋaki, amɨn nin da kapmatjok ekwaŋ uŋun da yaŋsul aŋ nimaŋ. Mɨktɨm morap nin paŋgwasɨŋek taŋ aŋaŋ kwaŋ uŋun da yaŋsul madepsi aŋ nimɨŋek gen mayagɨsi yaŋ nimaŋ. ");
INSERT INTO yut_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Gak da amɨn kabɨ morap mɨktɨmɨ mɨktɨmɨ ekwaŋ uŋun paŋtagap aŋaki nin dakon man do mayak mayak gen yoŋ. Ninon yo noman taŋ uŋun do jɨkgo madepsi yanjaŋ nimaŋ. ");
INSERT INTO yut_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","16","Uwal da jɨgɨlak gen yaŋ namɨŋek gen gɨreŋ nayaŋ. Aŋek kobogɨ do aŋpak yokwisi aŋ namaŋ. Do bɨsapmɨ bɨsapmɨ yokwisi nandaŋek mayaktok obɨsi pasat. ");
INSERT INTO yut_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Piŋkop, nin gak dɨma ɨŋtaŋ gamgumaŋ, ae gak dakon saŋbek saŋbek dakon gen dɨma abɨŋ yɨpgumaŋ. Mani uŋun yo morap noman taŋ nimgwit. ");
INSERT INTO yut_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Nin manji gamɨŋek gak dakon kosit dɨma yɨpmaŋ dekgɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Mani joŋ kɨlap da ekwaŋ tɨmon gak da nin paŋupbal agɨl. Aŋek pɨlɨn tuk madep naŋ nin wɨtjɨgɨl. ");
INSERT INTO yut_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","21","Piŋkopnin, gak do ɨŋtaŋ gamgumaŋ, bo ae kɨsitnin amɨn ŋwakŋwarɨ dakon piŋkopni do yopno kɨŋakwa bɨsit agɨmaŋ tam gaga nandabim. Nin da butgwan nandak nandak morap pasɨlɨ toŋ uŋun nandaŋ mudosol. ");
INSERT INTO yut_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Nin gak dakon mɨŋat amɨnyo ekwamaŋ, do gɨldat kɨnda kaloŋ uwal da nindapba kɨmokgomaŋ. Nin sipsip si nindapba kɨmorɨ da tɨlak ekwamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Amɨn Tagɨ, gak pɨda! Gak nido pokdol? Pɨda! Nin do toktogɨsi manji dɨma nibi. ");
INSERT INTO yut_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Gak mibɨlɨ nido pasɨl nimɨsal? Amɨn da yokwi aŋ nimɨŋakwa nin jɨgɨ madepsi sigɨn pamaŋ. Nin dakon jɨgɨ do dɨma ɨŋtaŋ nibi. ");
INSERT INTO yut_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Nin maŋ kɨmbabaŋon pagapno gɨptɨmnin amɨn kɨmakbi da yaŋ mɨktɨmon toŋ. ");
INSERT INTO yut_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Piŋkop, pɨdaŋ abɨŋ nin paŋpuluga. Butdasi galak taŋ yomyom aŋpakgo do nandaŋek nin yokwikon baŋ tɨmɨgaki kɨmot dɨma aneŋ. ");
INSERT INTO yut_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Kap on do “Maskil” yaŋ yoŋ. Uŋun Kora amɨn kabɨ dakon. Kap on mɨŋat pakpak dakon kap. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban tek “Jareŋ tagɨsi” kon da yoni. Nandak nandaknokon gen tagɨsi morapmɨ toŋ. Nak kap on mandaŋ yobo kap yoŋ amɨn da kɨla amɨn madep do yaŋ ɨmni. Gen kagano uŋun kɨlda mandak tagɨsi dakon kɨlda mandak yombem. ");
INSERT INTO yut_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Gak amɨn tagɨsi. Amɨn gak yombem mɨni. Gengo uŋun tagɨsi gɨn. Do toktogɨsi Piŋkop da gak do yo tagɨsi aŋ gamdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Gak kɨla amɨn madep tapmɨmɨ toŋ. Gak tɨlɨmgo morapmɨ, ae man madepgo uŋun wukwisi. Gak emat agak sɨba kwengokon aŋteban aŋek emat do tagap toki. ");
INSERT INTO yut_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Gak kɨla amɨn madep mibɨltogɨ man madepgo toŋ. Oskon yɨgek emaron kɨŋek teban toki. Yaŋ aŋaki amɨn da gen bamɨ arɨpmɨ dɨma abɨŋ yɨpni. Ae amɨn da kosit kɨlegɨ naŋ yolek agɨpni do emat asal yaŋ nandani. Pi tapmɨmɨ toŋ aŋaki gandaŋek tamtam yokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Gobɨŋgo uŋun kɨsɨgɨsi do uwalgo wamɨ gamikon obɨsi sugaŋ yomɨsak. Amɨn Ŋwakŋwarɨ Kabɨ pabɨŋ yopmaŋaki gak da kandap mibɨlgogwan ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Piŋkop, gak kɨla amɨn madep toktok teban egɨsal. Mɨŋat amɨngo kosit kɨlegɨkon da kɨla asal. ");
INSERT INTO yut_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Gak aŋpak kɨlegɨ do but dasi galak taŋek aŋpak yokwi do kuragɨsi nandɨsal. Yaŋ nandɨsal do Piŋkopgo da gak kɨsɨk kɨsɨk abi do bɨt nelak tagal gamgut. Notgo kɨnda yaŋ dɨma tagal ɨmgut. ");
INSERT INTO yut_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Ɨmal dubakgo mea ae aloe ae kasia dakon pakbi kɨbaŋɨ tagɨsi uŋun baŋ dapbi. Kɨla amɨn madep dakon yut uŋun elepan dakon jomɨ baŋ paŋtɨlɨm abi. Aŋek gak da kɨsɨk kɨsɨk abi do gita tɨdoŋ. ");
INSERT INTO yut_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Kɨla amɨn madep dakon gwani gat mɨŋat man madepni toŋ dɨwarɨ gat uŋun gak da yutnon ekwaŋ. Kwin amɨn tetgo do akdak. Uŋun tɨlɨmni Opir mɨktɨm dakon gol baŋ wasaŋbi. ");
INSERT INTO yut_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Mɨŋat gɨmoŋɨ kɨla amɨn madep pak do nandɨsal, gak nak dakon gen do mɨrak yopmaŋek uŋun do nandaki. Gak mɨŋat amɨnyo kokupgokon ekwaŋ uŋun ɨŋtaŋ yobi, ae yawi dɨwatgo kɨsi ɨŋtaŋ yobi. ");
INSERT INTO yut_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Nido kɨla amɨn madep da mɨŋat tagɨsi yaŋ gandaŋek but dasi galak taŋ gamɨsak. Uŋun amɨn tagɨgo, do man madep ɨmɨŋ kɨmokgi. ");
INSERT INTO yut_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Tair kokup pap dakon mɨŋat amɨnyo da but galak do yo paŋabɨŋ gamdaŋ. Ae yoni morapmɨ amɨn da gak dakon tagɨ tɨm abɨdok do but galak do yo paŋabɨŋ gamdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Kɨla amɨn madep dakon mɨŋatni iyɨ dakon yutgwan egɨsak. Uŋun mɨŋat tagɨsi. Ɨmal pak uŋun malɨ gol baŋ wasaŋbi uŋun baŋ paŋtɨlɨm abi. ");
INSERT INTO yut_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Ɨmalni uŋun kɨldani mibɨlɨ mibɨlɨ. Abɨsok mɨŋat uŋun kɨla amɨn madepmon aŋaŋ kwaŋ. Aŋakwa mɨŋat gɨmoŋɨ notni kɨsi yol aŋaŋ kwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Kɨsɨk kɨsɨk aŋek but galak nandaŋek kɨla amɨn madep da yut madepgwan wukwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Kɨla amɨn madep gak monjɨgo morapmɨsi altokdaŋ. Uŋun da datgoni dakon tamo tɨmɨgek man madep paŋek mɨktɨm morapmon mɨŋat amɨnyo kɨla akdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Gak dakon man madepgo mɨŋat amɨnyo abɨsok ae don altaŋek egɨ aŋaŋ kɨkdaŋ uŋudon yaŋ teŋteŋaŋ aŋaŋ kɨkeŋ. Aŋapbo toktogɨsi mɨŋat amɨnyo da mango aŋkɨsiŋ wɨgɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Kap on Kora amɨn kabɨ dakon. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban tek “Mɨŋat gɨmoŋɨ kabɨ” kon da yoni. Piŋkop uŋun nin dakon pasɨlɨ tamonin. Uŋun da nin bɨsapmɨ bɨsapmɨ paŋteban asak. Jɨgɨ pamaŋ bɨsapmon uŋun nin da kapmatjok egek paŋpulugosok. ");
INSERT INTO yut_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Yaŋdo, mɨktɨm wudɨp aŋakwan ɨleŋ oba tuwɨl kɨ tapmon pɨgɨni kaŋ, nin uŋun do dɨma pasolneŋ. ");
INSERT INTO yut_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Tap madepsi tamalɨgakwan tarak madepsi aŋek ɨleŋ oba paŋkwakwalɨtjak kaŋ, nin uŋun do dɨma pasolneŋ. ");
INSERT INTO yut_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Piŋkop Wɨkwisi Madep uŋun telagɨ kokup papnikon egɨsak. Uŋun kokupmon pakbi madep kɨnda pagek amɨn kɨsɨk kɨsɨk yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Piŋkop uŋun kokup papmon egɨsak, do kokup uŋun arɨpmɨ dɨma yokwi tosak. Wɨsa mɨgon yɨpmaŋakwan Piŋkop da kokup uŋun aŋkutnosak. ");
INSERT INTO yut_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Mɨktɨmɨ mɨktɨmɨ mɨŋat amɨnyo da pasol pasol madepsi aŋakwa on mɨktɨm dakon kɨla amɨn madep gat mɨŋat amɨn kabɨyoni gat obɨsi tasɨk toŋ. Piŋkop da gen pap yaŋakwan mɨktɨm pakbi dagoŋ. ");
INSERT INTO yut_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Yawe Tapmɨm Ami nin gat egɨsak. Jekop dakon Piŋkop uŋun dam tebanin arɨpmɨ dɨmasi tuwɨlɨ egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Ji abɨŋek Yawe da wasok asak uŋun do pɨndakgɨt. Mɨktɨmon wasok masɨ masɨmɨ asak uŋun pɨndatni. ");
INSERT INTO yut_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Mɨktɨmɨ mɨktɨmɨ emat paŋyawot asak. Obip gat gwawiya gat gwokgalek pasɨkni kɨndapmon sosok. ");
INSERT INTO yut_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Uŋun da yaŋ yosok, “Ji tayaŋgok egek nak Piŋkop bamɨsi uŋun pakyaŋsi nandaŋ namni. Mɨktɨmɨ mɨktɨmɨ amɨn nak do nandaba wukwan namni. On mɨktɨmon nak dogɨn nandaba wɨgɨsak.” ");
INSERT INTO yut_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Yawe Tapmɨm Ami nin gat egɨsak. Jekop dakon Piŋkop uŋun dam tebanin arɨpmɨ dɨma tuwɨlɨ egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Kap on Kora amɨn kabɨ dakon. Kap on kap yoŋ dakon kɨla amɨn do mandabi. Mɨŋat amɨn morap ji kɨsɨk kɨsɨk aŋek kɨsit tɨdok ani. Ji kɨsɨk kɨsɨk dakon yaŋ tɨdok aŋek kap yaŋek Piŋkop aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Yawe Wukwisi Madep uŋun ŋwakŋwarɨsi. Uŋun mɨktɨmon mɨŋat amɨn morap dakon Kɨla Amɨn Madep Wukwisi egɨ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Uŋun da uwalnin pabɨŋ yopban nin dakon pɨŋbinin ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Piŋkop da Jekop dakon dɨwatni nin do but dasi galak taŋ nimgut. Iyɨ mɨktɨm kɨnda manjɨŋek nin do kɨlɨ nimgut. Uŋun mɨktɨm do nandano yo madepsi asak. ");
INSERT INTO yut_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Piŋkop Kwen Kokup wɨgɨgɨt. Wɨgakwan amɨn kɨsɨk kɨsɨk aŋek madepsi yaŋ tɨdaŋek kweŋyo kɨsi pɨsowit. ");
INSERT INTO yut_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Kɨlɨ Piŋkop aŋkɨsik do kap yono. Aŋek Kɨla Amɨn Madepnin kɨsɨk kɨsɨk kap yaŋ ɨmno. ");
INSERT INTO yut_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Piŋkop uŋun Kɨla Amɨn Madep yɨgek mɨktɨm morap kɨsi kɨla asak. Nin mani aŋkɨsik do kɨsɨk kɨsɨk kap yoneŋ. ");
INSERT INTO yut_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Piŋkop uŋun Kɨla Amɨn Madep yɨgek mɨŋat amɨn morap kɨsi kɨla asak. Kɨla Amɨn Madep yɨtyɨt tamoni telagɨ uŋudon yɨkdak. ");
INSERT INTO yut_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Mɨŋat amɨn morap dakon kɨla amɨni uŋun muwukba nin gat kɨsi Abraham dakon Piŋkop yaŋ aŋkɨsamaŋ. Uŋun on mɨktɨm dakon kɨla amɨn madep morap dakon Piŋkop egɨsak. Mɨktɨmɨ mɨktɨmɨ mani wukwisi taŋ aŋaŋ kɨsak. ");
INSERT INTO yut_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Kap on Piŋkop gawak ɨmɨm kap. On Kora amɨn kabɨ dakon. Yawe mani wukwisi. Nin telagɨ kabapnikon wɨgek Piŋkop da kokup papgwan pɨgek aŋkɨsiŋ kɨmotneŋ kaŋ uŋun tagɨsi. ");
INSERT INTO yut_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Piŋkop dakon kabap uŋun wagɨl tagɨsi ae dubagɨsi. Mɨktɨmɨ mɨktɨmɨ amɨn da Saion Kabap do but galaksi nandaŋ. Kɨla Amɨn Madep Wukwisi dakon kokup pap uŋun kabapmon tosok. ");
INSERT INTO yut_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Piŋkop uŋun kokup papgwan egɨsak. Egakwan amɨn da Piŋkop uŋun dam tebanin arɨpmɨ dɨma tuwɨlɨ egɨsak yaŋ kaŋ nandaŋyo aŋ. ");
INSERT INTO yut_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","On mɨktɨm dakon kɨla amɨn madep Saion gat emat aŋek abɨŋ yɨp do awit bɨsapmon muwugek Saion da kapmatjok apgwit. ");
INSERT INTO yut_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Abɨŋ pasolɨsi kaŋ pasal si kɨwit. ");
INSERT INTO yut_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Madepsi nɨmnɨmɨgek mɨŋat da monjɨ altok do aŋakwa tepmɨ madepsi paŋ uŋun da tɨlak nandawit. ");
INSERT INTO yut_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Yaŋ nandaŋakwa gak da dapbɨ kɨmakgwit. Uŋun gɨldat wɨsak tet da mɨrɨm madep da Tarsis amɨn dakon tap wakga paŋupbal asak, uŋun da tɨlak gak da uŋun amɨn paŋupbal agɨl. ");
INSERT INTO yut_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Kalɨp Piŋkop da kokupni aŋkutnaŋek yo agɨt uŋun dakon geni nandagɨmaŋ. Abɨsok aeni yaŋ gɨn aŋakwan komaŋ. Nin Piŋkopnin Yawe Tapmɨm Ami da kokup papmon ekwamaŋ. Piŋkop da kokupni aŋteban aŋakwan bɨsap mudok mudogɨ mɨni tebai taŋ aŋaŋ wɨgɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Piŋkop, nin gak da telagɨ yutgwan egek gak da nin do but dasi galak taŋ nimɨsal uŋun do nandaŋek ekwamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Piŋkop, mɨktɨm dɨwarɨkon da dɨwarɨkon mango wukwisi tosok, do uŋudon amɨn da mango aŋkɨsaŋ. Gak tapmɨmgo madepsi, ae aŋpak kɨlegɨsikon da mɨŋat amɨnyo kɨla asal. ");
INSERT INTO yut_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Gak gen kokwin pi kɨlegɨsi asal, do Saion Kabapmon amɨn da kɨsɨk kɨsɨk aŋakwa Juda mɨktɨm dakon kokup monɨŋ monɨŋ amɨn da but galak nandaŋ. ");
INSERT INTO yut_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Ji kɨŋ Saion kokup pap dakon dam madep aŋgwasɨŋek uwal pɨndat do dam uŋun da kwenon yut dubak dubak abi uŋun manjɨni. ");
INSERT INTO yut_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Ji Saion kokup pap dakon dam madepni gat, ae yut tebani gat, uŋun pakyaŋsi pɨndatni. Yaŋ aŋek don altoni amɨn yoyɨni. ");
INSERT INTO yut_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","On Piŋkop uŋun bɨsap mudok mudogɨ mɨni Piŋkopnin egɨ wɨgɨsak. Uŋun da kosit nolɨŋakwan wɨgɨ kɨmot da paŋ dagosak. ");
INSERT INTO yut_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Kap on Kora amɨn kabɨ dakon. Kap on kap yoŋ dakon kɨla amɨn do mandabi. Mɨŋat amɨn morap ji nandani. Mɨktɨmɨ mɨktɨmɨ ekwaŋ mɨŋat amɨn morap ji nak dakon gen do mɨrak yopni. ");
INSERT INTO yut_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Mani toŋ amɨn ae amɨn ɨsalɨ, yoni morapmɨ amɨn ae yoni mɨni amɨn, ji kɨsi gen on yosot uŋun pakyaŋsi nandani. ");
INSERT INTO yut_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Nawa gen yoko nandaŋek egɨp egɨp tagɨsi dakon mibɨlɨ nandaŋ pɨsoni. ");
INSERT INTO yut_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Nak nawa gen do mɨrak yopmaŋek gita tɨdaŋek tɨlak gen dakon mibɨlɨ dayɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","6","Amɨn egɨp egɨpni moneŋon gɨn toŋ yaŋ nandaŋek pɨbɨt tɨdok aŋ amɨn uŋun da nak aŋgwasɨŋek aŋupbal ak do aŋ. Mani uŋun aŋ amɨn do dɨma pasolgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Amɨn kɨnda da iyɨ dakon egɨp egɨpni yum do Piŋkop do moneŋ arɨpmɨ dɨma ɨmjak. ");
INSERT INTO yut_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","9","Egɨp egɨp dakon yumaŋ nogɨ uŋun wukwisi. Piŋkop do moneŋ ɨmɨŋek mɨktɨmon bɨsap dagok dagogɨ mɨni egɨ aŋaŋ kɨneŋ dakon kosit kɨnda dɨmasi tosok. ");
INSERT INTO yut_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Pɨndakgamaŋ, nandaŋ kokwini tagɨsi amɨn gat, ae nandaŋ kokwini tagɨ dɨma amɨn gat, ae burɨ mɨni amɨn uŋun kɨsi kɨmotdaŋ. Kɨmagakwa yo morapni amɨn ŋwakŋwarɨ da tɨmɨtdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Uŋun kalɨp mɨktɨm yumaŋ naŋek iyɨ do tɨmɨkgwit, mani kɨmakbi kokup da kokupsini aban uŋudon dagok dagogɨ mɨni egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Amɨn dakon yoni tagɨsi uŋun da kɨmot dakon kosit arɨpmɨ dɨma sopjak. Uŋun joŋ bɨt kɨlapyo da yaŋ kɨmotdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Amɨn egɨp egɨpni iyɨkon tosok yaŋ nandaŋ amɨn uŋun kɨmotdaŋ. Uŋuden amɨn nandak nandak tagɨ mɨni. Uŋun amɨn yoni morapmɨ do kɨsɨk kɨsɨk aŋ, mani uŋun kɨmotdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Sipsip da yaŋ kɨmagek kɨmakbi kokupmon kɨni do Piŋkop da yaŋ mudaŋ yomgut. Yutni tagɨsi yɨpmaŋ detni, ae gɨptɨmni da mɨktaŋ mudoni. Aŋakwa kɨmot da kɨla amɨni egɨ yomdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Mani, Piŋkop da nak yokwikon naŋ abɨdokdɨsak. Aŋakwan amɨn kɨmakbi tamo da nak abɨdosak dakon tapmɨm dɨma taŋ ɨmdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Amɨn dɨwarɨ moneŋ morapmɨ tɨmɨtni, ae yutni madepsi ani, ae tɨlɨmni morapmɨ kaŋ, gak uŋun do but yokwi dɨma abi. ");
INSERT INTO yut_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Uŋun kɨmagek yo dɨ arɨpmɨ dɨma pabɨdaŋek kɨkdaŋ. Yo morapni tɨlɨmɨ toŋ uŋun gat kɨsi tɨmɨgek kɨmakbi kokupmon arɨpmɨ dɨma kɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Ekwaŋ bɨsapmon, yoni uŋun do kɨsɨk kɨsɨk aŋ. Uŋun pi madepsi aŋek yo morapmɨ tɨmɨgakwa mɨŋat amɨnyo da “amɨn tagɨsi” yaŋ yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Mani uŋun kɨmagek babɨkni gat gɨldat ae dɨma kokogɨ kokupmon egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Man madepnin da kɨmot dakon kosit arɨpmɨ dɨma sopjak. Nin joŋ bɨt kɨlapyo da arɨpmon kɨmotdamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Asap dakon kap kɨnda. Piŋkop Tapmɨm Ami uŋun Yawe. Uŋun da amɨn kɨsisi mɨktɨmon ekwaŋ uŋun yaŋ ɨlɨkdak. Gɨldat wɨsak tetgɨn da wasaŋek kɨŋ si pɨgɨsak tetgɨn amɨn ekwaŋ kɨsisi yaŋ ɨlɨkdak. ");
INSERT INTO yut_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Piŋkop uŋun Saion kokup papmon egɨsak. Kokup uŋun gwaljɨgɨ mɨni wagɨl tagɨsisi. Piŋkop dakon tɨlɨmni uŋudon da teŋteŋaŋ kɨsak. ");
INSERT INTO yut_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Piŋkopnin tayaŋgok dɨma abɨsak. Yo morapmɨ soŋban mudoŋ uŋun dakon kɨndapni da mibɨltaŋ ɨban abɨsak. Sɨkak mɨrɨmyo madepsi kagagwan da abɨsak. ");
INSERT INTO yut_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Mɨŋat amɨn kabɨyoni dakon aŋpak kokwin aŋakwan pɨndatjil do Kwen Kokup gat ae mɨktɨm gat yaŋ yoban abamal. ");
INSERT INTO yut_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Piŋkop da yaŋ yosok, “Mɨŋat amɨn kabɨno nak gat saŋbek saŋbek aŋek uŋun aŋteban ak do mukwa sowit ji nagon apba muwutneŋ.” ");
INSERT INTO yut_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Kwen Kokup da iyɨ yaŋ teŋteŋaŋek yaŋ yosok, “Piŋkop uŋun aŋpakni kɨlegɨsi. Uŋun iyɨ gen kokwin agak ami.” ");
INSERT INTO yut_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Piŋkop da yaŋ yosok, “Mɨŋat amɨn kabɨno mɨrak pani. Nak gen kɨnda dayɨkdɨsat. Israel amɨn nak da gen pikon depdɨsat. Nak Piŋkop egɨsat. Nak ji dakon Piŋkop. ");
INSERT INTO yut_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Ji da bɨt kɨlapyo parekgaŋ ae bɨt kɨlapyo bɨsapmɨ bɨsapmɨ nagon paŋabɨŋ soŋba soŋ mudoŋ nak uŋun do gen tebai dɨma dayɨsat. ");
INSERT INTO yut_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Nak bulmakau wɨli bo meme ji da nagalon baŋ tɨmɨt do dɨma nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Joŋ kɨlap morap koron ekwaŋ gat ae bulmakau ɨleŋ tausenon ekwaŋ gat uŋun kɨsi nak dakon gɨn. ");
INSERT INTO yut_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Kabapmon mɨnam morap ekwaŋ uŋun kɨsi nandaŋ yomɨŋ mudosot. Ae joŋ kaga yo monɨŋ morap ekwaŋ uŋun kɨsi nak dakon. ");
INSERT INTO yut_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Nak jap do abeŋ kaŋ, but pɨso dɨma dayɨkdɨsat. Mɨktɨm madep gat ae yo morap uŋungwan toŋ uŋun kɨsi nak dakon gɨn. ");
INSERT INTO yut_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Nak bulmakau dakon sabamni gat ae meme dakon yawi gat uŋun nosot yaŋ nandaŋ, ma? Uŋun dɨmasi. ");
INSERT INTO yut_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Ji nak do ya yaŋ nayɨni kaŋ, uŋun da mukwa sogok tagɨsi asak. But galak do yo morap Piŋkop Wɨkwisi nak do nam do yaŋ teban tok awit uŋun namni. ");
INSERT INTO yut_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Ji yaŋ aŋek jɨgɨ altaŋ damni bɨsapmon nak do yaŋ tɨdaŋba paŋpulugokdɨsat. Yaŋ aŋapbo man madep namni.” ");
INSERT INTO yut_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Mani Piŋkop da amɨn yokwi do yaŋ yosok, “Ji nido gen tebano ɨsaldogɨn gen kagakon da yoŋ? Ae nak dakon saŋbek saŋbekno dakon gen nido yoŋ? ");
INSERT INTO yut_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Ji nak da egɨp egɨpji paŋmɨlɨp abeŋ do kuragɨsi nandaŋ, aŋek bɨsapmɨ bɨsapmɨ nak dakon gen pabɨŋ yopmaŋgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Ji kabo noknok pɨndagek not aŋyomaŋ. Aŋek yumabi amɨn gat kɨsi akwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Ji gen yokwi gat ae top gen gat yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Aŋek notji gen yaŋ yomaŋ. Dɨsi dakon meŋji dakon monjini yaŋba yokwi tok aŋ yomaŋ. ");
INSERT INTO yut_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Ji yaŋ aŋakwa nak gen kɨnda dɨma yagɨm. Do nak dɨsi yombem yaŋ nandaŋ namaŋ, mani dɨmasi. Abɨsok nak tebai dayɨŋek nomansi gen pikon depdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","“Mɨŋat amɨnyo manji namaŋ amɨn ji nandani. Ji yaŋ gɨn egɨpni kaŋ, nak da ji paŋupbal aŋapbo amɨn kɨnda da ji yokwikon baŋ arɨpmɨ dɨma tɨmɨtjak. ");
INSERT INTO yut_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Amɨn kɨnda ya yaŋ nayɨsak, uŋun paret naŋ yaŋ namɨsak. Uŋun amɨn da mano awɨgɨsak. Ae nak da amɨn geno guramɨtni uŋun yokwikon baŋ tɨmɨtdɨsat.” ");
INSERT INTO yut_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Dewit da Batsiba kon yumabi aban don kombɨ amɨn Natan da yokwini yolɨgɨt. Aban Dewit da yokwini do nandaŋek kap on mandagɨt. Kap on kap yoŋ dakon kɨla amɨn do mandabi. Piŋkop, gak bɨsapmɨ bɨsapmɨ amɨn do but dasi galak taŋ yomɨsal, do nandaŋ yawok nabi. Bupmɨgo madepsi do nak dakon dɨwarɨno yɨpmaŋ nabi. ");
INSERT INTO yut_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Sugaŋ aŋmɨlɨp aŋaki aŋpak yokwino mudoni. Dɨwarɨno wɨrɨrɨk namɨŋaki kɨlek tokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Gulusuŋ at yaŋsi nandɨsat. Uŋun gulusuŋno toktogɨsi taŋba nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Nak gulusuŋ gak naŋgɨn aŋ gamɨsat. Gak da dabɨlon yokwisi at. Yaŋdo, gen pikon nepmaŋek gen yaŋ nabi uŋun tagɨsi. Gen kokwin kɨlegɨsi aŋek kobogɨ namdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Asisi, yokwi gat kɨsi altagɨm. Meŋ da butgwan wasaŋek yɨkgɨm bɨsapmon yokwi gat kɨsi yɨkgɨm. ");
INSERT INTO yut_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Asi, nin butninon da topmɨ mɨni egɨpneŋ do nandɨsal. Do gak da nandaŋ kokwingo tagɨsi butnokon nayɨŋ dekgi do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Yokwino wɨrɨrɨkbɨ kɨlegɨsi egɨpbeŋ do nandɨsat. Sugaŋ nepbɨ ais kwakwagɨsi uŋun da tɨlak kɨlegɨsi egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Butno aŋtagap abɨ aeno kɨsɨk kɨsɨgɨ toŋ egɨpbeŋ. Asi, wagɨlsi abɨŋ nepgul, mani aeno kɨsɨk kɨsɨk abeŋ do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Dɨwarɨno aego dɨma pɨndakgi. Yokwino kɨsi wɨrɨrɨk mudoki. ");
INSERT INTO yut_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Piŋkop, butno aŋkaluk abɨ kɨlegɨsi asak. Butno aŋkaluk abɨ gak naŋgɨn golbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Nolbɨ gak da dubagɨkon dɨma egɨpbeŋ. Telagɨ Wupgo nagon egɨsak uŋun dɨmasi gwayeki. ");
INSERT INTO yut_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Kalɨp yokwikon naŋ aŋpulugaŋbɨ kɨsɨk kɨsɨk nandagɨm uŋun aego nabi. Aŋpulugaŋbɨ gak dakon gen guramɨkgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Aŋek yokwi pakpak amɨn aŋpakgo yoyɨŋ dekgo tobɨlek gagon opni. ");
INSERT INTO yut_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Piŋkop, Yokwikon Baŋ Tɨmɨt Tɨmɨt Amɨno, nak yokwi aŋapbo amɨn kɨnda kɨmakgɨt. Mani dɨwarɨno yɨpmaŋ nabi. Yaŋ aŋaki aŋpakgo kɨlegɨ do nandaŋek kɨsɨk kɨsɨk kap yokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Amɨn Tagɨ, gen dulumno aŋtagap abɨ mango aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Gak bɨt kɨlapyo parek gabeŋ uŋun do dɨma galak tosol. Ae bɨt kɨlapyo gak do mukwa sok do dapmaŋ soko soŋ pasɨlni kaŋ, gak uŋunyo kɨsi do dɨma galak tosol. ");
INSERT INTO yut_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Piŋkop, nak naga do nandako pɨŋbisi asak uŋun da paret si galak tosol asak. Amɨn iyɨ do nandaba pɨŋakwa but tobɨl aŋ uŋun manji dɨma yomɨsal. ");
INSERT INTO yut_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Saion kokup pap amɨn do galak taŋek paŋpulugoki. Jerusalem kokup pap dakon dam madep aego abɨ atjak. ");
INSERT INTO yut_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Yaŋ aŋek uŋun bɨsapmon gak paret tagɨsi uŋun do galak tokdɨsal. Ae soŋba wagɨl pasɨldaŋ uŋunyo kɨsi do galak tokdɨsal. Nin bulmakau wɨli gak da altakon soŋ gamneŋ. ");
INSERT INTO yut_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Kap on kap yoŋ dakon kɨla amɨn do mandabi. Dewit dakon kap kɨnda. On kap do “Maskil” yaŋ yoŋ. Dewit da kap on Idom mɨktɨmon amɨn kɨnda mani Doek uŋun da kɨŋ Sol, “Dewit Aimelek da yutnon kɨk” yaŋ iyɨgɨt bɨsapmon mandagɨt. Amɨn tebai, gak nido Piŋkop dakon mɨŋat amɨnyo do aŋpak yokwi aŋ yomgul uŋun do pɨbɨt tɨdok asal? Bɨsapmɨ bɨsapmɨ Piŋkop da nandaŋ yawot aŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Gak top amɨn, gengo sɨba geni tepmɨsi yombem geni tepmɨsi da amɨn dɨwarɨ obɨsi mandaŋ yomɨsak. Gɨldarɨ gɨldarɨ amɨn dɨwarɨ paŋupbal ak do nandak nandak asal. ");
INSERT INTO yut_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Gak aŋpak kɨlegɨ do dɨma galak tosol. Aŋpak yokwi dogɨn galak tosol. Gak gen bamɨ yogok do dɨma galak tosol. Top yogok dogɨn galak tosol. ");
INSERT INTO yut_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Gak top amɨn. Amɨn dɨwarɨ paŋupbal ak dakon gen dogɨn galak tosol. ");
INSERT INTO yut_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Mani nandaki. Piŋkop da gak wagɨlsi aŋupbal akdɨsak. Gak tebaisi abɨdaŋek yutgokon naŋ maban abɨgɨkdɨsal. Aŋek obɨsi gɨkban pasɨlaki mɨktɨmon saŋbeŋek dɨma egɨpbi. ");
INSERT INTO yut_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Amɨn kɨlegɨ da uŋun yo noman taŋ gaba pɨndagek si pasoldaŋ. Gak do jɨkgo yanjaŋ gamɨŋek yaŋ yokdaŋ, ");
INSERT INTO yut_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Kabɨt. Uŋun amɨn Piŋkop da aŋpulugaŋek aŋteban asak do dɨma nandagɨt. Uŋun moneŋ yo morapni do nandaŋ gadagɨt, aŋek aŋpak yokwi da aŋpulugaŋakwa tagɨsi egɨpbeŋ yaŋ nandagɨt.” ");
INSERT INTO yut_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Mani nak dɨma. Nak olip kɨndap da yaŋ Piŋkop dakon yut kɨdɨpmɨŋon tagɨsi kwosot. Nak Piŋkop but dasi galak taŋ namɨsak uŋun do toktogɨsi nandaŋ dagokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Piŋkop, gak da nak aŋpulugagɨl, do bɨsapmɨ bɨsapmɨ ya yaŋ gayɨkeŋ. Aŋek mɨŋat amɨnyogo da dabɨlon mango awɨgek “Piŋkop da nak do yo tagɨsi aŋ namɨsak” yaŋ yokdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Dewit dakon kap kɨnda. On kap do “Maskil” yaŋ yoŋ. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban tek “Malat” ron da yoni. Nandaŋ kokwini tagɨ dɨma amɨn da “Piŋkop kɨnda dɨma egɨsak” yaŋ yoŋ. Uŋun amɨn aŋpak kosirɨkon dɨma aŋ. Uŋun aŋpak amɨn da dɨmasi agagɨ baŋ aŋ. Kɨnda da aŋpak tagɨ kɨnda dɨmasi asak. ");
INSERT INTO yut_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Piŋkop Kwen Kokup egek sɨŋtaŋban mɨŋat amɨnyokon pɨsak. Aŋek nandaŋ kokwini tagɨsi ae Piŋkop dakon mibɨlɨ nandak do pi aŋ amɨn dɨ ekwaŋ bo dɨma yaŋ do wɨsisak. ");
INSERT INTO yut_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Mani dɨma. Kɨsi morap kosit kɨlegɨ kɨlɨ yɨpmaŋ dekgwit. Kɨsi morap arɨpgɨn, uŋun amɨn wagɨl yokwisi. Kɨnda da aŋpak tagɨ kɨnda dɨmasi asak. ");
INSERT INTO yut_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Piŋkop da yaŋ yosok, “Yokwi aŋ amɨn nandak nandak tagɨ dɨ dɨma tɨmɨkgaŋ. Amɨn da bret naŋba mudoŋ, uŋun da tɨlak amɨn yokwi da mɨŋat amɨno naŋ mudoŋ. Ae nak da paŋpulugokeŋ do bɨsit dɨma aŋ.” ");
INSERT INTO yut_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Mani madepsi pasoldaŋ. Kalɨp yaŋ dɨma pasalgwit. Nido, Piŋkop da uwal morapji uŋun wagɨlsi dapmaŋek kɨdatni maban dukwan dukwan kɨkdaŋ. Ji da uwalji paŋmayak akdaŋ, nido Piŋkop da manji kɨlɨ yomgut. ");
INSERT INTO yut_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Nak Piŋkop da amɨn kɨnda Saion naŋ yabekban abɨŋ Israel amɨn yokwikon baŋ tɨmɨtjak dosi nandɨsat. Piŋkop da mɨŋat amɨni paŋpulugaŋban aeni tagɨsi egɨpni bɨsapmon Israel amɨn kɨsɨk kɨsɨk akdaŋ. Asi, but galaksi nandakdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Kap on kap yoŋ dakon kɨla amɨn do mandabi. Dewit dakon kap kɨnda. On kap do “Maskil” yaŋ yoŋ. Sip kokup dakon amɨn da kɨŋ “Dewit nin da binapmon pasɨlak da egɨsak” yaŋ Sol iyɨwit bɨsapmon Dewit da kap on mandagɨt. Kap on gita tɨdaŋek yogogɨ. Piŋkop mango wukwisi, do amɨn yokwi da kɨsiron baŋ pulugaŋ nepbi. Tapmɨmgo madepsi do aŋpulugaŋbɨ tagɨsi egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Piŋkop, nak dakon bɨsit nandaki. Mɨrakgo yopmaŋek geno nandaki. ");
INSERT INTO yut_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Nak dɨma nandaŋ yomɨsat amɨn da abɨŋ nɨtdaŋ. Ematni yokwisi amɨn da nɨkba kɨmokgeŋ do abaŋ. Uŋun amɨn da Piŋkop do yo ɨsalɨ yaŋ nandaŋ. ");
INSERT INTO yut_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Mani Piŋkop uŋun paŋpulugokno. Amɨn Tagɨ da tapmɨm namɨŋakwan sigɨn egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Yo yokwi aŋnamaŋ uŋun iyɨkon noman toni. Bɨsapmɨ bɨsapmɨ dɨma nepmaŋ dekdal, do uwalno dapbɨ pasɨl mudoni. ");
INSERT INTO yut_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Yawe, naga dakon galaktok yolek paret gabeŋ. Mango uŋun tagɨsi, do mango aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Aŋpulugaŋaki jɨgɨ morapno da dɨma abɨŋ nepgwit. Dabɨl da pɨndagapbo gak da uwalno pabɨŋ yopgul. ");
INSERT INTO yut_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Kap on kap yoŋ dakon kɨla amɨn do mandabi. Dewit dakon kap kɨnda. On kap do “Maskil” yaŋ yoŋ. Kap on gita tɨdaŋek yogogɨ. Piŋkop, nak dakon bɨsit nandaki. Aŋpulugoki do yaŋ tɨdoko dɨma nandabi da tɨlak dɨma egɨpbi. ");
INSERT INTO yut_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Bɨsitno pakyaŋsi tagɨsi nandaŋek gen kobogɨ nayɨki. Jɨgɨ uŋun da nak aŋupbal akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Uwal da nak aŋupbal ak do gen tebai yɨpmaŋ. Amɨn yokwi uŋun da nak abɨŋ nepmaŋgaŋ, do butnokon da yokwisi nandɨsat. Uŋun da jɨgɨ morapmɨ namɨŋek butjap madepsi nandaŋek uwal madepsi aŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Nak madepsi pasoldot, aŋek kɨmot do nandɨsat. Aŋek uŋun da aban butno madepsi jɨk tosok. ");
INSERT INTO yut_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Asi, nak madepsi pasoldot, aŋek gɨptɨmno madepsi nɨmnɨmɨkdak. Pasol pasol da obɨsi abɨŋ nepmaŋdak. ");
INSERT INTO yut_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Do yaŋ yosot, “Bupmɨsi, nak kɨnarɨm da yaŋ pɨtno toŋ ak do nandɨsat. Aŋek pɨrɨropmaŋ kɨŋ yɨk yawot tamo kɨnda wusɨŋ kaŋ uŋudon yɨkgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Nak pɨrɨropmaŋ dubagɨsi kɨndakon kɨŋ mɨktɨm amɨn dɨma ekwaŋon egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Tepmɨsi kɨŋek yoŋgamno kɨnda aŋalon aŋek mɨrɨm ae sɨkakyo madepsi da dubagɨkon tagɨ egɨpbeŋ.” ");
INSERT INTO yut_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Nak pɨndakgo kokup papgwan pɨdok aŋek emat aŋ, do Amɨn Tagɨ, gak da geni paŋɨŋtok abi. ");
INSERT INTO yut_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Uŋun gɨldarɨ ae kalbi kokup pap dakon tɨp dam da kwenon akwaŋ. Kokup pap dakon mɨŋat amɨnyo gulusuŋ morapmɨ gat ae yokwi morapmɨ aŋ. ");
INSERT INTO yut_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Kokup pap dukwan dukwan amɨn da amɨn dɨwarɨ gat ae yo morap gat paŋupbal aŋ. Kosit ɨleŋon notni pabɨŋ yopmaŋek yoni gwayek do paŋkewalgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Uwal kɨnda da nabɨpjak kaŋ, uŋun jɨgɨ tagɨ pakeŋ. Uwal da nɨt do asak kaŋ tagɨ pasɨlgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Mani dɨma. Gak kaloŋgɨn. Gak notnosi, egɨp egɨpnit kaloŋɨ. Aŋpak yokwi uŋun gak da gaga asal. ");
INSERT INTO yut_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Nit kalɨp but kaloŋon da Piŋkop da yutnon amɨn dɨwarɨ gat kɨsi kɨgɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Aŋpak yokwi da butnikon tugawit, do uwalno but pɨsoni mɨni tepmɨsi kɨmotni do nandɨsat. Kalugɨ sigɨn egek kɨmakbi kokupmon kɨnisi. ");
INSERT INTO yut_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Mani Piŋkop da aŋpulugosak do bɨsit asat, do iyɨ nak yokwikon naŋ abɨdosak. ");
INSERT INTO yut_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Jɨgɨ da nak aŋupbal aŋ, do wɨsa dagokdo, ae gɨldat binap, ae kalbi kɨsi kunam tak ɨbo bɨsitno nandɨsak. ");
INSERT INTO yut_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Amɨn morapmɨ da nɨkgaŋ, mani gɨptɨmno dɨma yokwi taŋ, nido Piŋkop da jɨgɨkon naŋ pulugaŋ nepmaŋek kɨlano aŋakwan tagɨsi egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Piŋkop toktok teban kɨla amɨn madep egɨsak. Uwalno Piŋkop do dɨma pasal ɨmaŋ, ae aŋpakni kulabɨk ak do dɨma nandaŋ, do Piŋkop bɨsitno nandaŋek uwal emaron pabɨŋ yopdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Nak dakon notno iyɨ dakon notni gat emat aŋ. Aŋek kalɨp notni gat saŋbek saŋbek awit uŋun tuwɨldak. ");
INSERT INTO yut_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Gen kaga da gen galagɨ yosok, mani butnikon da emat ak do nandak nandak asak. Geni da aban but yawot ekwamaŋ, mani geni uŋun geni tepmɨsi, emat agak sɨba yombem da nin mandaŋ nimɨsak. ");
INSERT INTO yut_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Jɨgɨ morap ɨmekdal, uŋun Yawe da kɨsiron yopbisi. Aŋaki uŋun da ɨmegek kɨlago aŋek gak aŋteban asak. Amɨn kɨlegɨ yɨpban arɨpmɨ dɨmasi mosak. ");
INSERT INTO yut_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Mani Piŋkop, gak da amɨn dapba kɨmokgoŋ amɨn gat, ae top yoŋ amɨn gat wɨrɨrɨkbɨ kɨmakbi kokupgwan pɨgek pasɨl mudokdaŋ. Kɨmot bɨsapni taŋakwa yawi kalɨk da tepmɨ kɨmotdaŋ. Mani egɨp egɨpno gagon tosok yaŋsi nandaŋ gabeŋ. ");
INSERT INTO yut_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Dewit dakon kap kɨnda. On kap do “Miktam” yaŋ yoŋ. Uwalni Pilistia amɨn da Gat kokupmon Dewit tebaisi abɨdawit bɨsapmon Dewit da kap on mandagɨt. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban “Kɨnarɨm kɨnda dubagɨkon kɨndapmon yɨkdak” uŋun tegon da yoni. Piŋkop, nak do nandaŋ yawok nabi. Amɨn da nak nɨt do aŋek nolgaŋ. Gɨldat kɨnda kaloŋ uwalno da nɨt do abaŋ. ");
INSERT INTO yut_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Wɨsa dagokdo da wɨgɨ pɨlɨndosi uwal da nɨt do pi aŋ. Amɨn morapmɨ da iyɨ do nandaba wɨgakwa abɨŋ nep do aŋ. ");
INSERT INTO yut_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Piŋkop, yo kɨnda do pasoldot bɨsapmon, egɨp egɨpno gagon tosok yaŋsi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Egɨp egɨpno Piŋkopmon tosok yaŋsi nandaŋek geni bamɨsi do nandak nandak aŋek mani awɨgɨsat. Nak Piŋkop nandaŋ gadaŋ ɨmɨŋek yo kɨnda do dɨma pasolgeŋ. Amɨn da nak do yo kɨnda arɨpmɨ dɨma ani. ");
INSERT INTO yut_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Yo morap akdɨsat uŋun uwal da paŋupbal ak do pi aŋ. Toktogɨsi nak aŋupbal ak do kosit wusɨk aŋ. ");
INSERT INTO yut_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Uŋun kɨsi muwugek si pasɨlek ekwaŋ. Nak da kosit agɨsat uŋudon yubɨŋek nɨkba kɨmokgeŋ do pi aŋ. ");
INSERT INTO yut_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Piŋkop, gak da aŋpak yokwi aŋ uŋun do yo yokwisi aŋ yobi. Gak butjap nandaŋ yomɨŋek emaron teban taŋek pabɨŋ yopbi. ");
INSERT INTO yut_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Jɨgɨ pasat uŋun gak da nandɨsal. Aŋek nak uŋun do jɨgɨsi nandaŋek kunam tagegɨsat. Kunam pakbino niaŋ da moŋ uŋun gak da manjɨŋek papiagokon kɨlɨ mandal. ");
INSERT INTO yut_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Nak yaŋsi nandɨsat, Piŋkop uŋun paŋpulugokno, do bɨsit aŋ ɨbeŋ bɨsapmon uŋun da uwalno yolban kɨŋ mudokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Nak Piŋkop dakon gen awɨgɨsat. Asisi, Yawe dakon gen awɨgɨsat. ");
INSERT INTO yut_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Egɨp egɨpno Piŋkopmon tosok yaŋsi nandɨsat, do yo kɨnda do dɨma pasolgeŋ. Amɨn da nak do yo kɨnda arɨpmɨ dɨma ani. ");
INSERT INTO yut_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Piŋkop, nak kalɨp yo ak do yaŋ teban tok agɨm uŋun akdɨsat. Nak ya yaŋ gayɨŋek paret abeŋ, ");
INSERT INTO yut_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","nido gak da kɨmoron naŋ pulugaŋaki dɨma kɨmakgɨm. Aŋpulugaŋaki sagalek dɨma nɨkgwit. Do Piŋkop da dabɨlon toktogɨsi teŋteŋɨnikon agɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Dewit dakon kap kɨnda. On kap do “Miktam” yaŋ yoŋ. Dewit Sol do pasalek kɨŋ tɨp kɨnamgwan pasɨl egɨpgut bɨsapmon kap on mandagɨt. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban “Dɨma paŋtasɨk ani” uŋun tegon da yoni. Piŋkop, bupmɨ nandaŋ nabi. Nak gagon abɨsat, kɨlano aki do nandɨsat. Pup pudɨk da meŋi da pɨt kagagwan pasɨlek ekwaŋ, uŋun da tɨlak aŋkutnaŋaki tagɨsi egɨsat. Nak yaŋ gɨn egapbo wɨgɨ aŋupbal ani dakon yo da pasɨlni. ");
INSERT INTO yut_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Nak Piŋkop Wukwisi do yaŋ tɨdosot. Uŋun da aŋpulugaŋban galaktokni tagɨ yolgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Uŋun Kwen Kokup egek nak yokwikon naŋ abɨdaŋek nak aŋupbal ak do aŋ amɨn uŋun pabɨŋ yopdɨsak. Piŋkop toktogɨsi but dasi galak taŋ namɨŋek dɨmasi nepmaŋ dekdak. ");
INSERT INTO yut_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Amɨn da nak aŋgwasaŋ. Uŋun laion amɨn noknok yombem. Geni uŋun tepmɨsi, gwawia ae gobɨŋ yombem. Melni uŋun emat agak sɨba yombem geni tepmɨsi. ");
INSERT INTO yut_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Piŋkop, mɨŋat amɨnyo da gak dakon man kundu yapmaŋek kwensi awɨgɨni do nandɨsat. Tapmɨmgo yɨpbi mɨktɨm morap kɨsikon nomansi teŋteŋosak. Yaŋ aŋaki mɨŋat amɨn morap kɨsi da man madepgo do nandani. ");
INSERT INTO yut_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Uwal da nak abɨdok do pat yɨpmaŋ, do jɨgɨ madepsi da nak obɨsi abɨŋ nepmaŋdak. Nak da mokeŋ do kosiron gapma wayɨk yɨpmaŋ. Mani dɨma magɨm. Iyɨ uŋun gapmagwan mawit. ");
INSERT INTO yut_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Piŋkop, butnokon da gak do tebaisi nandaŋ gadasat. Do gak dakon man awɨgɨk do kap yokdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Dɨpmɨn yɨpmaŋek pɨdokeŋsi. Gita ae kuleleyo tɨdokeŋsi. Wɨsa dɨma dagaŋakwan nak da kalɨp pɨdaŋek kap yokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Amɨn Tagɨ, Amɨn Ŋwakŋwarɨ Kabɨ da binapmon ya yaŋ gayɨkeŋ. Mɨŋat amɨn morap kɨsikon agek mango awɨgɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Nin do but dasi madepsi galak taŋ nimɨsal. Uŋun dakon tɨlak yɨpneŋ kaŋ, wɨgɨ kundu da arɨp akdɨsak. Toktogɨsi gengo tagɨsi uŋun yol kɨmagek ninon yo tagɨ asal uŋun arɨpmɨ tagɨ manjɨneŋ kaŋ, tɨlakni uŋun wɨgɨ gɨkwem kagagwan da arɨp. ");
INSERT INTO yut_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Piŋkop, mɨŋat amɨnyo da gak dakon man madepsi awɨgɨni do nandɨsat. Tapmɨmgo yɨpbɨ mɨktɨm morap kɨsikon nomansi teŋteŋosak. Yaŋ aŋaki mɨŋat amɨn morap kɨsi da man madepgo do nandani. ");
INSERT INTO yut_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Dewit dakon kap kɨnda. On kap do “Miktam” yaŋ yoŋ. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban “Dɨma paŋtasɨk ani” uŋun tegon da yoni. Kɨla amɨn, ji gen pikon gen kɨlegɨ yoŋ, ma? Amɨn morap kɨsi dakon gen kokwin tagɨsi aŋ bo? ");
INSERT INTO yut_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Dɨmasi. Nandak nandakji yokwi ak dogɨn nandaŋ. Ji gen kokwin kɨlegɨsi dɨma aŋek dukwan dukwan mɨŋat amɨnyo madepsi paŋupbal aŋ. ");
INSERT INTO yut_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Amɨn yokwi uŋuden kaluk altoŋon da wasaŋek kosit tagɨsi yɨpmaŋ degek aŋpak yokwi gɨn aŋ, ae top baŋgɨn yaŋekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Geni uŋun tuŋon amɨn dakon pakbi emarɨ toŋ yombem. Mɨrakni ɨŋtagɨt, do ");
INSERT INTO yut_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","tuŋon amɨn uŋun pɨdaŋ kap asak do kasɨsɨŋ pɨsoŋ bɨsapmon, ami dakon kasɨsɨŋni dakon tekni dɨma nandɨsak. Ami kasɨsɨŋ dakon mibɨlɨ pakyaŋ nandaŋek pɨsosok, mani tuŋon amɨn tekni dɨma nandɨsak. ");
INSERT INTO yut_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Piŋkop, kɨla amɨn yokwi uŋun paŋupbal akisi. Uŋun laion emat yokwisi aŋ yombem, do geni bɨrɨpmɨk mudoki. ");
INSERT INTO yut_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Pakbi da pak kɨŋek mɨktɨmgwan pasɨlgaŋ uŋudeŋ si pasɨlni. Amɨn da joŋ bamaŋba kɨbɨdoŋ uŋudeŋ gak da si bamaŋaki yokwi toni. ");
INSERT INTO yut_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Uŋun galjisip da kɨmagek mɨktɨmon mɨktoŋ, uŋudeŋ tasɨk toni. Ae monjɨ meŋ da butgwan kɨmagek gɨldat dɨma koŋ, uŋudeŋ tagɨ kɨmotni. ");
INSERT INTO yut_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Amɨn kɨnda da kɨndap monɨŋgok kɨnda pasɨsak, uŋun da tɨlak, Piŋkop da tepmɨsi paŋupbal akdɨsak. Uŋun kalugɨ egakwa Piŋkop da butjapsi nandaŋ yomɨŋek sɨbɨt sɨbɨt yaŋ maban kɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Piŋkop da amɨn yokwi yo yokwisi aŋ yomjak bɨsapmon, amɨn kɨlegɨ kɨsɨk kɨsɨk akdaŋ. Amɨn kɨlegɨ da amɨn yokwi dakon yawi baŋ kandapni sugokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Aŋakwa amɨn dɨwarɨ da yaŋ yokdaŋ, “Asisi, Piŋkop da amɨn kɨlegɨ do kobogɨ do tomni tagɨsi yomɨsak. Asisi, Piŋkop da gen pikon amɨn morap dakon aŋpak kokwin asak.” ");
INSERT INTO yut_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Dewit dakon kap kɨnda. On kap do “Miktam” yaŋ yoŋ. Sol da Dewit abɨdaŋek aŋakba kɨmotjak do amɨn yabekba yutnikon kɨwit bɨsapmon Dewit da kap on mandagɨt. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban “Dɨma paŋtasɨk ani” uŋun tegon da yoni. Piŋkopno, uwalno da kɨsiron baŋ nak abɨdoki. Kɨlano aŋaki dɨma aŋupbal ani. ");
INSERT INTO yut_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Amɨn yokwi da kɨsiron naŋ gwayeki, aŋek amɨn nɨkba kɨmotdɨsat da kɨsiron baŋ nak abɨdoki. ");
INSERT INTO yut_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Pɨndakgi. Nɨkba kɨmokgeŋ do yubɨŋ ekwaŋ. Yawe, yokwi kɨnda dɨma agɨm, mani amɨn yokwi emat agak amɨn uŋun nɨt do muwukgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Yawe, suŋ kɨnda dɨma agɨm, mani tepmɨsi nak gat emat wam do tagap taŋ. Jɨgɨno do kaŋek abɨŋ aŋpuluga! ");
INSERT INTO yut_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Piŋkop Yawe, Tapmɨm Ami, tepmɨsi abɨŋek nak aŋpulugoki. Gak Israel amɨn dakon Piŋkop, tepmɨsi abɨŋ amɨn kabɨ morap egɨ aŋaŋ kwaŋ tepmɨ pi yobi. Uŋun jamba but amɨnsi, do bupmɨ dɨma nandaŋ yobi. ");
INSERT INTO yut_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Pɨlɨn kaga abɨŋek kokup pap da kosiron agek pɨŋan da yaŋ nɨmɨ yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Nandaki, gen kaganikon da gen yokwisi da moŋ. Uŋun emat agak sɨba geni tepmɨsi yombem. Mani yaŋ yoŋ, “Namɨn da nandaŋ nimjak?” ");
INSERT INTO yut_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Mani Yawe, gak da jɨkgo yokwisi yanjaŋ yomɨsal. Gak da uŋun mɨŋat amɨn morap kabɨ kɨsi do yaŋsul aŋ yomɨsal. ");
INSERT INTO yut_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Gak dagɨn nak aŋteban aŋek kɨlano asal. Piŋkop, gak dam tebano arɨpmɨ dɨma tuwɨlɨ egɨsal. ");
INSERT INTO yut_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Piŋkopno da but dasi galak taŋ namɨsak, ae uŋun da abɨŋ aŋpulugokdɨsak. Piŋkop da nak yum nandaŋek nepban pɨndagapbo uwalno pabɨŋ yopdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Amɨn Tagɨ, dɨma dapbɨ kɨmotni. Mɨŋat amɨno da tapmɨmgo madep do dɨ ɨŋtaŋbam. Gak pasɨknin tebaisi, gaga da tapmɨmon uwal yolbɨ kɨŋakwa paŋupbal aki. ");
INSERT INTO yut_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Toktogɨsi yokwi ak dogɨn yoŋ. Iyɨ do nandaba wɨkwaŋ do yum pɨndagaki iyɨ da paron yokwalni. Jobɨt tɨmɨtdo dakon gen ae top gen gat kɨsi yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Do gak da butjap nandaŋ yomɨŋek dapbɨ kɨmotni kaŋ tagɨsi. Amɨn yokwi uŋun dapbɨ pasɨlni. Yaŋ aŋaki mɨŋat amɨnyo da gak do Piŋkop, ae Israel amɨn dakon kɨla amɨn madep, ae dukwan dukwan kɨsi dakon kɨla amɨn madep egɨsal yaŋ nandaŋ gamni. ");
INSERT INTO yut_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Pɨlɨn kaga abɨŋek kokup pap da kosiron agek pɨŋan da yaŋ nɨmɨ yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Jap wusɨŋ pɨndak nok do kɨŋ ap aŋ. Ae burɨ dɨma tugoni kaŋ, nɨmɨ yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Mani, nak tapmɨm madepgo do kap yokeŋ. Wɨsa dagokdo but dasi galak taŋ namɨsal, uŋun do nandaŋek kap yokeŋ. Nido, kalɨp jɨgɨ mibɨlɨ mibɨlɨ noman taŋ namgwit bɨsapmon tagɨsi aŋkutnagɨl, aŋek dam tebano arɨpmɨ dɨma tuwɨlɨ egɨpgul. ");
INSERT INTO yut_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Piŋkop, gak kaloŋgɨn teban tokno. Gak dakon man awɨgɨk do kap yokdɨsat. Piŋkop, toktogɨsi but dasi galak taŋ namɨsal, ae dam tebano arɨpmɨ dɨma tuwɨlɨ egɨsal. ");
INSERT INTO yut_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Dewit dakon kap kɨnda. On kap do “Miktam” yaŋ yoŋ. On kap da niyɨŋdet kɨnda asak. Dewit da Siria amɨn Mesopotemia mɨktɨmon nani gat emat wamgwit bɨsapmon mɨktɨm Soba gat Joap gat dakon amɨn da tobɨl abɨŋek Idom amɨn 12 tausen mɨktɨm kɨnda mani Galegɨ Tapmɨ Morapmɨ uŋudon dapgwit. Uŋun bɨsapmon Dewit da kap on mandagɨt. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban “Saŋbek saŋbek dakon jareŋ tagɨsi” uŋun tegon da yoni. Piŋkop, gak da manji nimgul. Ninon yaŋ abɨ emaron magɨmaŋ. Nin do butjap nandagɨl, mani abɨsok aego tobɨl abɨŋek nin paŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Gak da abɨ mɨktɨmnin wudɨp agɨt. Mɨktɨm pudaŋbɨ gapma madep kɨnda noman tagɨt. Abɨsok mɨktɨmnin obɨsi tasɨk tosok. Aego aŋmɨlɨp abi. ");
INSERT INTO yut_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Mɨŋat amɨn kabɨgo nin do jɨgɨ morapmɨ nimgul. Uŋun wain baŋ yaŋ nibɨ naŋ mudaŋek but upbal obɨsi agɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Mani gak da tɨlak kɨnda aŋenakgɨl. Do amɨn gak do pasolgoŋ uŋun tɨlagon kɨŋ altaŋek tagɨsi egakwa uwal da arɨpmɨ dɨma dapni. ");
INSERT INTO yut_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Gak da nin but dasi galak taŋ nimɨsal, do bɨsitnin nandaŋ nibi. Aŋek tapmɨm madepgokon da nin yokwikon baŋ tɨmɨgaki nin tagɨsi egɨpneŋ. ");
INSERT INTO yut_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Piŋkop iyɨ da yutnon egek yaŋ yagɨt, “Nak emaron kɨlɨ teban tat. Do nak kɨsɨk kɨsɨk aŋek Sekem dakon mɨktɨm gat ae Sukot dakon galegɨ oba uŋun gat mɨŋat amɨno do kokwinɨk yomdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Giliat mɨktɨm gat Manase mɨktɨm gat uŋun nak dakon. Epraim mɨktɨm uŋun busuŋ kutnokno. Ae Juda mɨktɨm uŋun kɨla amɨn madep dakon kɨndap kɨrɨŋno. ");
INSERT INTO yut_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Mani Moap mɨktɨm uŋun nak dakon pakbi sogok ɨdap. Ae Idom mɨktɨm uŋun nak dakon kandap gwɨl yopyop tamo. Aŋek nak emaron Pilistia amɨn pabɨŋ yopmaŋek kɨsɨk kɨsɨk aŋek yaŋ tɨdokdɨsat.” ");
INSERT INTO yut_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Piŋkop, namɨn da nak aŋaŋ kokup pap dam tebani toŋon aŋkɨsak? Ae namɨn da nak Idom mɨktɨmon emat ak do aŋkɨsak? ");
INSERT INTO yut_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Piŋkop, gak da nin manji kɨlɨ nimgul, ma? Nin dakon emat amɨn dɨma paŋpulugok do nandɨsal, ma? ");
INSERT INTO yut_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Amɨn dakon paŋpulugok uŋun yo ɨsalɨ gɨn, do nin paŋpulugaŋaki uwal gat emat tagɨ wamneŋ. ");
INSERT INTO yut_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Piŋkop da nin paŋpulugaŋakwan emaron teban toneŋ. Iyɨ uwalnin pabɨŋ yopdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Kap on kap yoŋ dakon kɨla amɨn do mandabi. Dewit dakon kap kɨnda. Gita tɨdaŋek yogogɨ. Piŋkop, mɨrakgo yopmaŋek aŋpulugoki do yaŋ tɨdosot uŋun nandaki. Bɨsitno nandaki. ");
INSERT INTO yut_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Nak mɨktɨm dubagɨsikon da gak do yaŋ tɨdosot. Butnokon da paŋpulugogɨ mɨni egɨsat yaŋ nandaŋek yaŋ tɨdosot. Aŋkɨ nepbɨ tɨp madep da yoŋgamon pasɨlɨ egɨpbeŋ, ");
INSERT INTO yut_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","nido tagɨsi aŋkutnosol. Nagal tebano agaki uwalno da arɨpmɨ dɨma abɨŋ nepni. ");
INSERT INTO yut_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Nak bɨsap mudok mudogɨ mɨni gak da yutnon egɨpbeŋ do nandɨsat. Pup pudɨk meŋi da pɨtgwan tagɨsi ekwaŋ, uŋun da tɨlak gak da kapmatjok egapbo aŋkutnoki do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Piŋkop, nak yaŋ teban tok agɨm uŋun gak da nandagɨl. Yo tagɨsi gak do pasolgoŋ amɨn kabɨ do yomɨsal uŋun nak do kɨlɨ namgul. ");
INSERT INTO yut_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Kɨla amɨn madep aŋteban abɨ bɨlak morapmɨsi egɨpjak. Aŋteban abɨ babɨkni morapmɨ altaŋ altaŋ ani uŋun pɨndatjak. ");
INSERT INTO yut_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Piŋkop, aŋteban aŋaki bɨsap dagok dagogɨ mɨni gak da dabɨlon kɨla amɨn madep egɨpjak. Toktogɨsi but dasi galak taŋ ɨmɨŋek kɨlani aŋek aŋkutnoki dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Yaŋ aŋaki gɨldarɨ gɨldarɨ yo ak do yaŋ teban tok agɨm uŋun abeŋ. Aŋek gɨldarɨ gɨldarɨ kap yaŋek mango aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Dewit dakon kap kɨnda. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban “Jedutun” uŋun tegon da yoni. Nak tayaŋgok egek Piŋkop dogɨn jomjom asat. Uŋun da nak yokwikon naŋ abɨŋakwan egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Uŋun kaloŋ gɨn tɨp madepno ae yokwikon baŋ tɨmɨt tɨmɨt amɨno. Uŋun kaloŋgɨn dam tebano arɨpmɨ dɨma tuwɨlɨ, do uwalno da arɨpmɨ dɨma abɨŋ nepni. ");
INSERT INTO yut_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Bɨsap niaŋ da nak nɨkba kɨmokgeŋ do emat akdaŋ? Ji nak dam garaŋɨ yombem kɨnda da yaŋ wagɨlsi tuwɨl kɨkeŋ do nandaŋ. ");
INSERT INTO yut_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Nak man madepno toŋ, mani ji nak dakon man madepno aŋupbal ak do nandak nandak paŋkosit aŋ. Ji top gen dogɨn galak toŋ. Ji Piŋkop da nak do yo tagɨsi aŋ namjak do gen tagɨsi yoŋ, mani butjikon da “Piŋkop da aŋupbal asak kaŋ tagɨsi” yaŋ nandaŋ. ");
INSERT INTO yut_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Nak tayaŋgok egek Piŋkop do jomjom asat. Aŋek uŋun kaloŋ dagɨn aŋpulugosak do nandaŋ teban taŋek jomjom asat. ");
INSERT INTO yut_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Uŋun kaloŋ gɨn tɨp madepno ae yokwikon baŋ tɨmɨt tɨmɨt amɨno. Uŋun kaloŋgɨn dam tebano arɨpmɨ dɨma tuwɨlɨ, do uwalno da arɨpmɨ dɨma abɨŋ nepni. ");
INSERT INTO yut_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Piŋkop kaloŋ dagɨn yokwikon baŋ abɨdaŋek man madep namɨsak. Uŋun da tɨp madepno agakwan tebaisi akdat. Uŋun dagɨn dam madepno agakwan tagɨsi aŋkutnosok. ");
INSERT INTO yut_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Mɨŋat amɨn kabɨ bɨsapmɨ bɨsapmɨ egɨp egɨpji Piŋkopmon tosok yaŋsi nandani. Nin Piŋkopmon kɨŋapno tagɨsi paŋkutnosok, do butjikon yo morap toŋ uŋun Piŋkop do ɨmɨŋ mudoni. ");
INSERT INTO yut_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Amɨn ɨsalɨ uŋun mɨrɨm pamaŋ yombem bamɨ mɨni. Ae amɨn mani toŋ uŋun jɨgɨ bɨsapmon nin arɨpmɨ dɨma paŋpulugogɨ. Uŋuden amɨn kokwin aneŋ kaŋ, bamɨ mɨni tagapmɨsi pɨndatdamaŋ. Uŋun mɨrɨm pamaŋ yombem bamɨ mɨni. ");
INSERT INTO yut_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Ji amɨn dakon yo tɨmɨt do tebai dɨma yoyɨni. Ji amɨn paŋkewalek kabokon da yo tɨmɨt tɨmɨt uŋun aŋpak tagɨ yaŋ dɨma nandani. Moneŋ ae yo kabɨyosi ɨreŋ taŋba uŋun do butjikon da uŋun yo madep yaŋ dɨma nandani. ");
INSERT INTO yut_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Bɨsap morapmɨ Piŋkop da yaŋ yaŋban nandagɨm, “Nak naga Piŋkop, tapmɨmno madepsi. ");
INSERT INTO yut_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Nak bɨsapmɨ bɨsapmɨ amɨn do but dasi galak taŋ yomɨsat.” Amɨn Tagɨ, aŋpak amaŋ uŋun da arɨpmon gak da amɨn kaloŋ kaloŋ do kobogɨ nimɨŋ nimɨŋ asal. ");
INSERT INTO yut_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Dewit Juda mɨktɨmon mɨktɨm amɨn da arɨpmɨ dɨma egɨpmɨ uŋudon egek kap on mandagɨt. Piŋkop, gak Piŋkopno. Nak pi madepsi aŋek gak wɨsisat. Nak mɨktɨm kɨbɨrɨ amɨn da arɨpmɨ dɨma egɨpmɨ tɨmon egek tapmɨmno mɨnisi aŋakwa amɨn da pakbi do aŋ uŋudeŋ wupno da gak do tepmɨsi nandɨsak. Aŋek gɨptɨmno da gak gat egɨpdosi nandɨsak. ");
INSERT INTO yut_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Telagɨ yutnon gandagɨm. Tapmɨmgo madep gat ae tɨlɨmgo gat pɨndakgɨm. ");
INSERT INTO yut_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Mɨktɨmon egɨp egɨp uŋun tagɨsi, mani uŋun yapmaŋek gak da nin do but dasi galak taŋ nimɨsal uŋun da wukwisi asak. Do nak mango yaŋ aŋkɨsisat. ");
INSERT INTO yut_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Nak si egɨpbeŋ bɨsapmon mango yaŋ aŋkɨsiŋ wɨgɨkeŋ. Kɨsitno si paŋenagek gak do bɨsit aŋ aŋ abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Amɨn da jap galagɨsi nelagɨ toŋ naŋek arɨpmɨ aŋ uŋudeŋ wupno galagɨsi nandɨsak. Do nak kɨsɨk kɨsɨk kap yaŋek mango yaŋ aŋkɨsisat. ");
INSERT INTO yut_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Nak dɨpmɨn potpot tamokon si pokdot bɨsapmon gakdosi nandaŋ egɨsat. Kalbi nandak nandak gak dogɨn asat. ");
INSERT INTO yut_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Gak paŋpulugokno egɨsal, do nak gak da pɨt kagagwan tagɨsi egek gak do kɨsɨk kɨsɨk kap yosot. ");
INSERT INTO yut_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Wupno gak da kapmatjok gol awɨldak. Aŋakwan kɨsitgo amɨnsi tet da nak tebaisi abɨdosok. ");
INSERT INTO yut_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Amɨn nɨkba kɨmokgeŋ do nandaŋ amɨn, uŋun tasɨk tokdaŋ. Uŋun kɨmakbi kokupgwan pɨgɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Uwalni da emat agak sɨbabaŋ dapba kɨmagakwa joŋ pɨŋan da gɨptɨmni nokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Mani kɨla amɨn madep nak naga Piŋkop do kɨsɨk kɨsɨk akdɨsat. Ae Piŋkop yol do uŋun da manon da yaŋ teban tok awit amɨn, uŋun kɨsɨk kɨsɨk tagɨ ani. Mani uŋun da top amɨn dakon gen kagani sopdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Dewit dakon kap kɨnda. Kap yoŋ amɨn dakon kɨla amɨn do mandabi. Piŋkop, nak jɨgɨno madepsi, do bɨsitno nandaki. Nak uwal do pasoldot, do aŋpulugaŋbɨ nak arɨpmɨ dɨma nɨtni. ");
INSERT INTO yut_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Amɨn yokwi nak aŋupbal ak do pasulɨkon da gen yaŋ paŋkosit aŋ. Aŋek nak nɨt do muwukgaŋ, do kɨlano aŋaki yo yokwi dɨma aŋ namni. ");
INSERT INTO yut_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Geni uŋun geni tepmɨsi. Emat agak sɨba da yaŋ mandaŋ namaŋ. Amɨn da amɨn do tɨlak aŋek obip paŋɨlɨkgaŋ, uŋun da tɨlak geni emarɨ toŋ baŋ nak paŋɨlɨk namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Uŋun pasɨl egek amɨn kɨlegɨ do obip yamaŋgaŋ. Uŋun dɨma pasolgoŋ, do tepmɨsi yamaŋgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Iyɨ paŋteban ak do aŋpak yokwi uŋun aŋ. Amɨn dɨwarɨ yokwalni do pat yopmaŋek gen yaŋ yoŋ, “Amɨn kɨnda da nin arɨpmɨ dɨma nindakdɨsak.” ");
INSERT INTO yut_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Aŋpak yokwi ak do gen yaŋ paŋteban aŋek yaŋ yoŋ, “Aŋpak yokwi kɨnda ak do dakon nandak nandak tagɨsi amaŋ. Yo uŋun akdamaŋ uŋun amɨn kɨnda da arɨpmɨ dɨma kaŋ nandaŋyo asak.” Amɨn dakon but nandak nandakyo arɨpmɨ dɨma nandaneŋ. Uŋun pasɨlɨsi. ");
INSERT INTO yut_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Mani Piŋkop da iyɨ dakon gobɨŋ baŋ yamaŋ yomdɨsak. Aŋakwan uŋudon gɨn wuda madepsi noman tokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Amɨn dɨwarɨ paŋupbal ak do yawit, do Piŋkop da paŋupbal akdɨsak. Amɨn morap uŋun pɨndatni amɨn da jɨkgo yokwisi yanjaŋ yomɨŋek wɨnda kwakwal aŋ yomdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Mɨŋat amɨn morap kɨsi Piŋkop do pasoldaŋ. Aŋek Piŋkop da yo uŋun asak uŋun do yokdaŋ, ae uŋun do nandaŋ egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Amɨn kɨlegɨ morap Yawe do kɨsɨk kɨsɨk akdaŋ. Aŋek paŋkutnosak do iyɨkon kɨŋek tagɨsi egɨpdaŋ. Amɨn kɨlegɨ morap Yawe dakon man awɨgɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Dewit dakon kap kɨnda. Kap on Piŋkop gawak ɨmɨm kap. Kap yoŋ amɨn dakon kɨla amɨn do mandabi. Piŋkop, nin Saion kokup papmon kɨŋek gak aŋkɨsineŋsi. Yaŋ aŋapno yo morap ak do yagɨmaŋ uŋun kɨnda dɨma suŋ tosak. ");
INSERT INTO yut_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Gak da bɨsitnin nandaŋ nimɨsal. Amɨn morap kɨsisi gagon opdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Dɨwarɨnin da wɨtjɨŋba wagɨl yokwisi egɨpgumaŋ, mani gak da dɨwarɨnin wɨrɨrɨk nimgul. ");
INSERT INTO yut_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Amɨn gak da yutnon opni do manjɨsal uŋun kɨsɨk kɨsɨk ekwaŋ. Gak da Telagɨ Yut Madepmon yo tagɨsi toŋ uŋun baŋ tugok tugogɨsi paŋek ekwamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Piŋkop gak dasi nin yokwikon baŋ tɨmɨk tɨmɨk aŋaki tagɨsi ekwamaŋ. Gak bɨsitnin nandaŋek pi tapmɨmɨ toŋ aŋek nin paŋpulugosol. Amɨn mɨktɨm dɨwarɨsikon ae tap dɨwarɨsikon ekwaŋ uŋun kɨsi gak da paŋpulugoki do jomjom aŋ. ");
INSERT INTO yut_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Gaga da tapmɨmon kabap morap wasaŋ yopgul da tamonikon toŋ. Gak tapmɨmgo madepsi. ");
INSERT INTO yut_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Gak da tap madep paptaŋ tamalɨgakwan aŋyawot aŋaki wayɨŋɨ mɨni tosok. Ae mɨŋat amɨn kabɨ egɨ aŋaŋ kwaŋ gen pap yaŋek pɨdok pɨdok aŋ uŋun gak da paŋyawot asal. ");
INSERT INTO yut_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Wasok madep madep aŋaki amɨn uŋun do pasolgoŋ. Gɨldat wɨsak tetgɨn ae pɨgɨsak tetgɨn wasok tapmɨmɨ toŋ asal uŋun do nandaŋek kɨsɨk kɨsɨk kap yaŋ gamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Gak da mɨktɨm kɨlani ak do sɨkak yɨpbɨ mosok. Yaŋ aŋaki mɨktɨm tagɨsi aŋakwan jap bamɨ tagɨsi toŋ. Piŋkop gak da pakbi morapmɨ yopgul da dɨma dugoŋ. Yaŋdo, jap bamɨ madepsi ɨreŋ taŋakwa amɨn da arɨpnikon paŋ noŋ. Gak da yaŋ ak do kɨlɨ nandagɨl. ");
INSERT INTO yut_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Gak da sɨkak morapmɨ yopbɨ maŋek mɨktɨm aŋyawot aŋakwan pakbini toŋ aŋakwa jap gɨsamɨgaki bamɨ tagɨ toŋ. ");
INSERT INTO yut_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Gak nin do tagɨsi nandaŋek jap pakpak bɨsapmon jap madepsi paŋɨreŋaŋ nimɨsal. Jap tamokon jap morapmɨsi tugaŋ wɨgɨsak. ");
INSERT INTO yut_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Mɨktɨm amɨn dɨma ekwaŋon joŋ tɨm morap taŋ aŋaŋ kwaŋ uŋudon bulmakau gat ae sipsip gat morapmɨsi ekwaŋ. Ae ɨleŋ morapmon joŋ kalɨkalɨgɨsi kwaŋakwa kɨsɨk kɨsɨk aŋ. ");
INSERT INTO yut_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Joŋ tɨmon sipsip morapmɨsi ekwaŋ ae galegɨkon wit morapmɨsi kwaŋek toŋ, do yo morap kɨsɨk kɨsɨk aŋek kap yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Kap on Piŋkop gawak ɨmɨm kap. Kap yoŋ amɨn dakon kɨla amɨn do mandabi. Mɨktɨmon mɨŋat amɨn morap kɨsɨk kɨsɨk aŋek yaŋ tɨdaŋek Piŋkop aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Kap yaŋek man madepni yaŋ aŋkɨsini. Man madepni madepsi yaŋ aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Piŋkop yaŋsi iyɨni, “Yo morap asal uŋun wagɨl tagɨsisi. Tapmɨmgo uŋun madepsi, do uwalgo da madepsi pasolgoŋ. ");
INSERT INTO yut_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Mɨktɨmon amɨn morap gak gawak gamaŋ. Kap yaŋek mango yaŋ aŋkɨsaŋ.” ");
INSERT INTO yut_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Ji abɨŋek Piŋkop da yo agɨt uŋun pɨndatni. Yo masɨ masɨmɨ amɨn da binapmon agɨt uŋun do pɨndatni. ");
INSERT INTO yut_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Uŋun da Tap Gami aban kɨbɨdaŋ mɨktɨm kɨbɨrɨ yombem aŋakwan uŋudon da terɨ kɨnda wugɨwit. Ji abɨŋek mani yaŋ aŋkɨsino. ");
INSERT INTO yut_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Uŋun tapmɨmni madepsi, ae kɨla amɨn madep dagok dagogɨ mɨni egɨ wugɨsak teban. Egek amɨn da yo morap aŋ uŋun pakyaŋsi pɨndakdak. Do kwen wugɨk dɨma aŋ ɨmneŋ. ");
INSERT INTO yut_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Mɨŋat amɨn kabɨ morap ji Piŋkopnin aŋkɨsiŋakwa amɨn da wɨwɨkni nandani. ");
INSERT INTO yut_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Uŋun da kɨlanin aŋakwan sigɨn ekwamaŋ, ae sagalek dɨma nindapmaŋgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Piŋkop, amɨn da silwa soŋba gwaljɨgɨ mɨnisi aŋ uŋun da tɨlak gak da nin kɨlɨ paŋkewalgɨl. ");
INSERT INTO yut_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Gak da nin paron baŋ tɨmɨkgɨl. Yaŋ aŋek ninon jɨgɨ madepsi yɨpmaŋ nimgul. ");
INSERT INTO yut_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Gak yum pɨndagaki uwal da obɨsi bamaŋ nimgwit. Aŋaki nin kɨndap ae pakbi madep kagagwan agɨpgumaŋ. Mani abɨsok gak da kokup tagɨsikon paŋabɨl. ");
INSERT INTO yut_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","14","Kalɨp jɨgɨ noman taŋ naban paret kɨndap da si soŋ mudogɨ uŋun gam do gen kagano kon da yaŋ teban tok kɨlɨ agɨm. Yaŋ agɨm do on paret gak da yutnon paŋobɨŋek kɨndapmon sokdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Gak do bɨt kɨlapyo madepsi baŋ altakon soŋek gak do paret abeŋ. Sipsip wɨli madepsi baŋ soŋapbo uŋun dakon kɨbaŋɨ tagɨsi uŋun nandabi. Bulmakau wɨli ae meme wɨli kɨsi gak do paret abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Mɨŋat amɨn morap ji Piŋkop do pasalek ekwaŋ amɨn ji abɨŋ nak dakon gen nandani. Piŋkop nak aŋpulugok do yo madepsi agɨt, uŋun dakon geni dayɨkdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Nak mani yaŋ aŋkɨsiŋek aŋpulugosak do yaŋ tɨdagɨm. ");
INSERT INTO yut_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Butnokon dɨwarɨno tawit uŋun yaŋkwok dɨma agɨm tam, Amɨn Tagɨ bɨsitno dɨma nandaban. ");
INSERT INTO yut_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Mani Piŋkop da nak kɨlɨ nandaŋ namgut. Asisi, tekno nandaŋek bɨsitno kɨlɨ nandagɨt. ");
INSERT INTO yut_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Nak Piŋkop dakon man aŋkɨsisat. Uŋun bɨsitno nandaban ɨsalɨ dɨma agɨt. Aŋek nak do but dasi sigɨn galak taŋ namɨsak. ");
INSERT INTO yut_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Kap on Piŋkop gawak ɨmɨm kap. Kap yoŋ amɨn dakon kɨla amɨn do mandabi. Gita tɨdaŋek yogogɨ. Piŋkop nin do nandaŋ yawok nimɨŋek ninon yo tagɨsi abi. Butgo ninon yɨpmaŋek yo tagɨsi aŋ nibi dosi nandamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Yaŋ aŋaki amɨn kɨsi da gak dakon aŋpakgo nandani. Ae gak da amɨn yokwikon baŋ tagɨ tɨmɨkdal dakon tapmɨm mɨktɨm amɨn kɨsi morap da nandani. ");
INSERT INTO yut_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Piŋkop, amɨn da gak aŋkɨsini do nandɨsat. Amɨn morap kɨsi da gak aŋkɨsini dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Gak gen kokwin pi agakgo kɨlegɨsi, ae mɨktɨmɨ mɨktɨmɨ mɨŋat amɨn kabɨ kosit kɨlegɨ yolɨsal. Yaŋ asal do mɨŋat amɨn kɨsi dakon but tagɨsi aŋakwa kɨsɨk kɨsɨk kap yoni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Piŋkop, amɨn da gak aŋkɨsini do nandɨsat. Amɨn morap kɨsi da gak aŋkɨsini dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Mɨktɨm da jap morapmɨ paŋalon asak, ae Piŋkop, nin dakon Piŋkop da nin gɨsamɨtjak. ");
INSERT INTO yut_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Asisi, Piŋkop da nin gɨsamɨgakwan amɨn morap mɨktɨmɨ mɨktɨmɨ ekwaŋ uŋun da Piŋkop do pasal ɨmdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Dewit dakon kap kɨnda. Kap on Piŋkop gawak ɨmɨm kap. Kap yoŋ amɨn dakon kɨla amɨn do mandabi. Piŋkop da tepmɨsi abɨŋek uwalni yoljak. Piŋkop do uwal aŋ amɨn pasalek kɨŋ mudoni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Mɨrɨm da mukwa pɨsoŋba kɨŋ pasɨlgaŋ, yaŋ gɨn Piŋkop da uwal yoldɨsak. Kɨndap tedep da kendol pɨndakban pakbi dagoŋ, yaŋ gɨn amɨn yokwi Piŋkop da ɨŋamon tasɨk tokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Mani amɨn kɨlegɨ kɨsɨk kɨsɨk akdaŋ. Aŋek Piŋkop da dabɨlon butni tagɨsi aŋek kɨsɨk kɨsɨk madepsi akdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Piŋkop aŋkɨsineŋ. Man madepni do nandaŋek aŋkɨsiŋek kap yoneŋsi. Uŋun gɨkwemon yɨgek kɨsak. Mani uŋun Yawe. Nin iyɨ da dabɨlon kɨsɨk kɨsɨk aneŋ. ");
INSERT INTO yut_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Piŋkop iyɨ da telagɨ kokupmon egek mɨŋat monjɨyo datni kɨmakgwit uŋun kɨlani asak, ae sakwabatyo kɨsi kɨlani asak. ");
INSERT INTO yut_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Ae mɨŋat amɨnyo dage dage aŋek ekwaŋ uŋun dɨwatni paŋalon aŋyoban tagɨsi yɨkgaŋ. Ae dam tebanon ekwaŋ amɨn pulugaŋban kokupmon tagɨsi ekwaŋ. Mani kwen wugɨk aŋ amɨn mɨktɨm kɨbɨrɨ tɨm yokwisikon paŋkɨ egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Piŋkop, kalɨp gak mɨŋat amɨnyogo mibɨltaŋ yomɨŋek mɨktɨm amɨn da arɨpmɨ dɨma egɨpmɨ tɨmon tɨmɨk pawɨlgɨl. ");
INSERT INTO yut_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Uŋun bɨsapmon Sinai dakon Piŋkop abɨŋakwan mɨktɨm wudɨp agɨt. Asi, Israel dakon Piŋkop abɨŋakwan sɨkak madepsi magɨt. ");
INSERT INTO yut_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Piŋkop, gak da sɨkak madepsi yɨpbɨ mɨktɨmgokon magɨt. Aŋaki mɨktɨm yokwi da mɨktɨm tagɨsi ae dagagɨt. ");
INSERT INTO yut_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Uŋun mɨktɨmon mɨŋat amɨn kabɨgo da kokup wasawit. Gak yogo morapmɨsi uŋun baŋ wadak wadak amɨn paŋpulugaŋaki tagɨsi egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Amɨn Tagɨ da mɨŋat amɨni do gen yomgut, aban mɨŋat morapmɨ da kɨŋ gen uŋun yaŋ teŋteŋawit. ");
INSERT INTO yut_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Gen uŋun yaŋ, Uwal dakon kɨla amɨn madep gat ae emat amɨn morapni gat kɨsi pasal kwaŋ. Aŋakwa mɨŋat kokupmon ekwaŋ da amɨn emaron yo tɨmɨkgaŋ uŋun kokwin aŋ. ");
INSERT INTO yut_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Mɨŋat uŋun sipsip kɨla aŋ, mani silwa gat gol gat baŋ gɨptɨmni tagɨsisi paŋtɨlɨm aŋek mɨnam dakon tɨlɨmɨ yombem dagoŋ. ");
INSERT INTO yut_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Piŋkop Tapmɨm Ami da Salmon Kabapmon kɨla amɨn madep yolban kɨwit, aŋek uŋun kabapmon ais yopban mawit. ");
INSERT INTO yut_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Basan dakon kabap uŋun madepsi. Ɨleŋ monɨŋ monɨŋni morapmɨsi. ");
INSERT INTO yut_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Kabap madep Basan, gak nido Piŋkop da Jerusalem dakon kabap Saion uŋudon iyɨ yɨt do tɨlak agɨt uŋun do nandabɨ yokwi tok asal? Yawe iyɨ toktogɨ uŋun kabapmon egɨpdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Amɨn Tagɨ emat amɨni gat os da emat amɨn ɨlɨk pawɨlgaŋ tamo tausen morapmɨ kon da apgut. Sinai Kabap yɨpmaŋek pɨgɨt da iyɨ da telagɨ yutnon egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Piŋkop kabap dubagɨsikon wɨgek uwalni morapmɨ emaron teban taŋek iyɨ tɨmɨkgɨt uŋun amɨn tɨmɨkban kɨsi wɨgɨwit. Uŋun kwen wɨgɨk amɨn uŋun dakon yoni baŋ but galak do tɨmɨkgɨt. Piŋkop Yawe iyɨ uŋun kabapmon egɨpdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Amɨn Tagɨ dakon man awɨgɨno. Gɨldarɨ gɨldarɨ nin dakon jɨgɨ ɨmekdak. Piŋkop kaloŋ dagɨn nin yokwikon baŋ tɨmɨkdak. ");
INSERT INTO yut_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Piŋkopnin da nin paŋpulugaŋakwan tagɨsi ekwamaŋ. Amɨn Tagɨ Yawenin da nin paŋpulugaŋakwan dɨma kɨmokgomaŋ. ");
INSERT INTO yut_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Mani Piŋkop da uwalni dakon busuŋni paŋsulɨtdɨsak. Uŋun aŋpak yokwi toktogɨsi aŋ amɨn paŋtasɨk akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Amɨn Tagɨ da yaŋ yosok, “Nak da uwalji Basan ekwaŋ uŋun aeno tɨmɨk paŋapdɨsat. Tap ɨdap da kadagɨkonsi baŋ tɨmɨk pawɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Ji uwalji dakon yawi baŋ kandapji sugokdaŋ. Aŋakwa pɨŋanji da galak toknikon nokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Piŋkopno, ae Kɨla Amɨn Madepno, mɨŋat amɨn morap da gandaba gak emaron teban tal da kɨsɨk kɨsɨk aŋek abɨsal. Kɨsi morap da gandaŋakwa telagɨ yutgogwan wɨgɨsal. ");
INSERT INTO yut_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Kap yogok amɨn mibɨltok kwaŋ, aŋakwa dubaŋ tɨdok amɨn buŋon obaŋ. Aŋakwa mɨŋatjok tambarin tɨdoŋ uŋun binapmon kwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Uŋun kap yaŋ yoŋ, “Nin Piŋkop dakon mɨŋat amɨnyo, nin muwugek Piŋkop dakon man awɨgɨno. Israel amɨn, nin Yawe dakon man awɨgɨno.” ");
INSERT INTO yut_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Benjamin dakon mɨŋat amɨnyo kaloŋɨsok da mibɨltok kwaŋ. Ae Juda amɨn dakon kɨla amɨn gat ae mɨŋat amɨnyo gat Benjamin dakon amɨn kabɨ baŋ yolgaŋ. Aŋakwa Sebulan gat Naptali gat dakon kɨla amɨn buŋon yolgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Piŋkop, gak tapmɨmgo kalɨp nolɨgɨl, uŋun naŋ abɨsok nomansi nolɨki. ");
INSERT INTO yut_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Kɨla amɨn madep da yutgo Jerusalem tosok uŋudon abɨŋek gak do but galak do yo paŋabaŋ. ");
INSERT INTO yut_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Piŋkop, Isip uŋun joŋ kɨlap yokwi yombem, uŋun tebaisi iyɨki. Gak da uwalnin morap kwen wɨgɨk aŋ uŋun tebaisi yoyɨki. Tebai yoyɨŋaki wɨgɨ ŋwakbeŋ aŋek silwa gamni dakon bɨsapmon wugɨsak. Emat ak do nandaŋ amɨn yolbɨ dukwan dukwan kɨni. ");
INSERT INTO yut_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Isip amɨn da but galak dakon yo tɨmɨgek Jerusalem opdaŋ. Aŋakwa Itopia amɨn da Piŋkop do kɨsitni paŋenagek gawat gawat akdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Amɨn Ŋwakŋwarɨ Kabɨ, ji Piŋkop do kap yaŋek Amɨn Tagɨ dakon man awɨgɨk do kap yoni. ");
INSERT INTO yut_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Uŋun kundu wasok wasogɨkon da kɨlɨ tagɨt da tosok uŋudon agɨsak. Nandani. Piŋkop madepsi yaŋ tɨdosok. ");
INSERT INTO yut_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Mɨŋat amɨnyo morap, ji Piŋkop dakon tapmɨm madepni do yaŋ teŋteŋoni. Uŋun Israel amɨn dakon kɨla amɨn madepni. Kundukon tapmɨm madepni nomansi komaŋ. ");
INSERT INTO yut_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Piŋkop iyɨ da telagɨ yutnon tapmɨmɨ toŋsi yɨkdak, do pasal ɨmɨŋ kɨmotneŋ. Israel amɨn dakon Piŋkop mɨŋat amɨni do tapmɨm madepni yomɨsak. Piŋkop aŋkɨsino! ");
INSERT INTO yut_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Dewit dakon kap kɨnda. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban “Jareŋ tagɨsi” uŋun tegon da yoni. Piŋkop, nak aŋpuluga! Pakbi wɨŋaŋek teknokon kɨlɨ wɨk. ");
INSERT INTO yut_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Nak neŋak kagagwan maŋ pɨgɨgɨm da egɨsat. Mɨktɨm tebai nikon bamaŋek tebai akgeŋ? Pakbi ɨlarɨgwan agapbo pakbi da ɨgek wagɨl wɨtjɨŋban tokdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Piŋkop gak da aŋpulugoki do toktogɨsi yaŋ tɨdaŋ egek tapmɨmno mɨnisi asak. Bɨsap dubagɨ gak do jomjom aŋek egɨt, do tekno bap taŋakwan dabɨlno tep namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Ɨsal dogɨn nandaba yokwi tok aŋ namaŋ amɨn morapmɨ ekwaŋ. Busuŋ daŋgwano dakon tɨlak yapmaŋdak. Uwalno mibɨlɨ mɨni nak aŋtasɨk ak do aŋ. Nak kabo dɨma naŋ yomɨŋapbo top yaŋ namaŋ, do naga dakon yo kabɨno dɨwarɨ yomɨsat. ");
INSERT INTO yut_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Piŋkop, nak nandaŋ kokwini tagɨ dɨma amɨn kɨnda gak da nandaŋ namɨsal. Dɨwarɨno arɨpmɨ dɨma paŋkɨsɨbɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Amɨn Tagɨ Yawe Tapmɨm Ami, yum nandaŋaki yokwi dɨ abo gak da paŋpulugosak do nandaŋ gadat aŋek jomjom aŋ amɨn da mayaktok dɨ pabam. Israel amɨn nin dakon Piŋkopnin yum nandaŋaki yokwi dɨ abo gak wɨsɨŋ gandak do pi aŋ amɨn da mayaktok dɨ pabam. ");
INSERT INTO yut_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Nak gak goldat, do amɨn da manji gen yaŋ namaŋ. Yaŋ aŋakwa mayaktok pasat. ");
INSERT INTO yut_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Peno padɨk padɨkyo da dɨma nandaŋ namaŋ wup aŋ. Gwakno da nak kokup ŋwakŋwarɨkon amɨn kɨnda yombem nandaŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Nak gak dakon yut do madepsi galak tosot, do yutgo da tagɨsi tosak do pi madepsi asat. Amɨn da gak do gen yokwi yaŋ gamaŋ uŋun yaŋba nagon obɨsak. ");
INSERT INTO yut_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Nak kunam tagek gak do nandaŋek jap kelkel aŋek gawak gamɨsat bɨsapmon, amɨn da nak do gen yokwi yaŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Nak but yokwi dakon ɨmal pasat bɨsapmon, amɨn da manji gen yaŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Muwut muwut tamokon amɨn da nak do yaŋba yokwi tok aŋ. Ae pakbi teban naŋek but upbal aŋ amɨn da abɨŋ nep do kap yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Mani Yawe, nak gak do bɨsit asat. Piŋkop gaga nandɨsal bɨsapmon bɨsitno dakon bamɨ uŋudon nabi. Gak nak do but dasi galak taŋ namɨsal, do asi pulugaŋ nep do yagɨl uŋun do nandaŋek bɨsitno dakon kobogɨ nabi. ");
INSERT INTO yut_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Pulugaŋ nepmaŋaki neŋak kagagwan dɨma pɨgɨ pasɨlgeŋ. Nak do yaŋba yokwi tok aŋ namaŋ amɨn da kɨsiron baŋ pulugaŋ nepmaŋaki pakbi ɨlarɨgwan dɨma pasɨlgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Yum nandaŋaki pakbi da ɨgek nak dɨma wɨtjisak, ae pakbi ɨlarɨgwan dɨma pɨgɨ pasɨlgeŋ. Yum nandaŋaki bumjot gapma da nak dɨma galautjak. ");
INSERT INTO yut_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Yawe, gak bɨsapmɨ bɨsapmɨ but dasi galak taŋ namɨŋek yo tagɨsi aŋ namɨsal. Yaŋdo, bɨsitno dakon bamɨ nabi. Bupmɨgo uŋun madepsi, do abɨŋ aŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Nak gak dakon oman monjɨgo. Pasɨlɨkon dɨma egɨ nabi. Nak jɨgɨkon egɨsat, do bɨsitno tepmɨsi nandaŋek bamɨ nabi. ");
INSERT INTO yut_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Nak da kapmatjok abɨŋek yokwikon baŋ yumaŋ naŋ nepbi. Uwalno da kɨsiron naŋ pulugaŋ nepbi. ");
INSERT INTO yut_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Uwalno nak do gen yokwi yoŋ uŋun gak da nandaŋaki nayaŋ. Mano abɨŋ yɨpmaŋakwa mayaktok pasat uŋun nandɨsal. ");
INSERT INTO yut_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Gen yokwi uŋun yaŋ namaŋ uŋun do but yokwisi nandɨsat. Aŋek tapmɨmno mɨnisi asak. Amɨn dɨ da nak dakon but bo aŋteban ani yaŋ nandagɨm, mani dɨma. Ae amɨn dɨ da nak aŋteban ak do gen tagɨ dɨ bo nayɨni yaŋ nandagɨm, mani dɨma. ");
INSERT INTO yut_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Jap do agɨm bɨsapmon marasin yokwi baŋ namgwit. Tekno kɨbɨdaŋban wain ɨsɨpmɨ baŋgɨn nokeŋ do namgwit. ");
INSERT INTO yut_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Jap noknok madep ak do muwutni bɨsapmon uŋun kɨsɨk kɨsɨk bɨsap da tobɨlek kɨlap da yaŋ paron depban yokwalni, ae gapmagwan maŋek tasɨk toni dakon yo yaŋ asak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Dabɨlni abɨ pɨlɨn tuk ani, aŋek yo saŋbeŋek dɨma pɨndatni. Manji paŋupbal abɨ tebai dɨma atni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Butjap sigɨn nandaŋ yomɨŋek yo yokwisi aŋ yobi. Aŋek butjapgo da aban pasɨl mudoni. ");
INSERT INTO yut_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Kokup ekwaŋ uŋun ɨsal tosak. Ae ɨmal yutnikon amɨn kɨnda dɨma egɨpjak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Amɨn dɨwarɨ yokwini dakon kobogɨ yomgul, amɨn yokwi da yokwi aŋ yom do pi sigɨn aŋ. Gak da amɨn dɨwarɨ dakon gɨptɨm paŋdagaŋek gɨptɨm tedep yomgul, amɨn yokwi da jɨgɨlak gen yaŋ yomɨŋek jɨgɨ yomaŋ. ");
INSERT INTO yut_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Amɨn yokwi dakon yokwini do dɨma ɨŋtaŋ yobi. Uŋun amɨn dɨmasi paŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Gak da egɨp egɨp papiakon mani wɨrɨrɨkgi. Ae amɨn kɨlegɨ dakon man gat kɨsi mani dɨma mandaki dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Nak jɨgɨ tepmɨyo madepsi pasat. Piŋkop, gak da nak yokwikon naŋ abɨdaŋek nak aŋmɨlɨp abi. ");
INSERT INTO yut_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Yaŋ aŋaki nak kap yaŋek Piŋkop dakon man awɨgɨkdɨsat. Aŋek ya yaŋ iyɨŋek man madepni do yaŋ teŋteŋok abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Aŋapbo Yawe da aŋpak uŋun abeŋ do but dasi galak taŋ kɨmotjak. Bulmakau baŋ paret abeŋ uŋun do madepsi dɨma galak tosok. ");
INSERT INTO yut_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Nak Piŋkop aŋkɨsikeŋ bɨsapmon mɨŋat amɨnyo jɨgɨ paŋ da uŋun kaŋek kɨsɨk kɨsɨk akdaŋ. Ae mɨŋat amɨnyo Piŋkop wɨsɨŋ kok do pi aŋ amɨn uŋun Piŋkop da butni paŋteban akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Yawe da yo do wadak wadak aŋ amɨn dakon bɨsitni nandaŋ yomɨsak. Mɨŋat amɨni dam tebanon ekwaŋ uŋun do dɨma ɨŋtaŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Kundu gat ae mɨktɨm, ae tap ɨdap gat ae tap kɨlap ae yo morap tap kagagwan ekwaŋ, ji kɨsi morap Piŋkop dakon man awɨgɨni. ");
INSERT INTO yut_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Nido, Piŋkop da Saion kokup pap dakon mɨŋat amɨnyo uwal da kɨsiron baŋ tɨmɨtdɨsak. Aŋek Juda mɨŋat amɨnyo paŋpulugaŋban kokup papni ae akdaŋ. Yaŋ aban Piŋkop dakon mɨŋat amɨnyo uŋun kokup papmon tagɨsi egek, uŋun mɨktɨm wagɨl abɨdoni. ");
INSERT INTO yut_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Piŋkop dakon oman amɨni dakon dɨwatni da uŋun mɨktɨm abɨdokdaŋ, ae mɨŋat amɨn Piŋkop but dasi galak taŋ ɨmaŋ uŋun da uŋun mɨktɨmon egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Piŋkop da Dewit dakon jɨgɨ kaŋ nandaŋyo asak do Dewit da kap on mandagɨt. Kap yoŋ amɨn dakon kɨla amɨn do mandabi. Piŋkop, nak yokwikon naŋ abɨdoki. Yawe, tepmɨsi abɨŋek nak aŋpuluga. ");
INSERT INTO yut_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Amɨn dɨwarɨ da nak nɨkba kɨmotdɨsat. Gak dasi pabɨŋ yopmaŋek paŋɨŋtok aŋaki mayaktok pani. Ae amɨn dɨwarɨ nak dakon jɨgɨ do kɨsɨk kɨsɨk aŋ, wɨrɨrɨkbɨ tobɨl kɨŋakwa mani pabɨŋ yopbi dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Nak do manji gen yoŋ amɨn, obɨsi paŋmayak aŋaki aŋpak yokwini do wɨrɨpdatni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Mani amɨn gagon obaŋ, uŋun burɨ tagɨsi aŋakwa gak do kɨsɨk kɨsɨk ani. Mɨŋat amɨnyo uŋun gak da yokwikon baŋ tɨmɨkgɨl uŋun do but galaksi nandaŋek toktogɨsi “Piŋkop uŋun wagɨl tagɨsisi!” yaŋ tagɨ yoni. ");
INSERT INTO yut_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Mani Piŋkop, nak wadak wadak amɨn, ae nak naga arɨpmɨ dɨma aŋpulugokeŋ, do tepmɨsi abɨŋ aŋpulugoki. Yawe, gak gaga nak dakon paŋpulugokno ae yokwikon baŋ tɨmɨt tɨmɨt amɨno. Jomjom dɨma abi, tepmɨsi aŋpulugoki! ");
INSERT INTO yut_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Yawe, aŋkutnoki do gagon obɨsat. Nak aŋkutnaŋaki mayagɨ dɨma pakeŋ. ");
INSERT INTO yut_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Gak wagɨl kɨlegɨsi, do nak aŋpulugaŋek uwalno da kɨsiron naŋ kukwaŋ nepbi. Bɨsitno nandaŋek pulugaŋ nepbi. ");
INSERT INTO yut_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Gak tɨp madepno egek nak tagɨsi aŋkutnosol. Gak tɨp tebano ae dam tebano arɨpmɨ dɨma tuwɨlɨ, do gen teban yɨpmaŋaki uwal da kɨsiron da pulugaŋ kɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Piŋkopno, amɨn yokwi da kɨsiron baŋ pulugaŋ nepbi. Uŋun emat amɨnsi, ae aŋpakni uŋun wagɨl yokwisi. ");
INSERT INTO yut_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Amɨn Tagɨ Yawe, gak dasi pulugaŋ nepdɨsal yaŋ nandaŋek egɨsat. Nak monɨŋɨsogon da nandaŋ gadaŋ gamɨŋ aŋaŋ wɨgɨm. ");
INSERT INTO yut_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Meŋno da nak aŋalaŋban gak da kɨla aŋaki wɨk da abɨsok egɨsat. Yaŋ asal do bɨsapmɨ bɨsapmɨ mango yaŋ aŋkɨsiŋ kɨmokgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Amɨn morapmɨ nandaŋakwa yo noman taŋ namɨŋakwa yaŋ nandaŋ, gak kaloŋ dagɨn tagɨsi aŋkutnosol. ");
INSERT INTO yut_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Gɨldat kɨnda kaloŋ nak gak dakon man awɨgɨsat, aŋek mɨŋat amɨnyokon gak dakon tɨlɨmgo do yaŋ teŋteŋok asat. ");
INSERT INTO yut_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Abɨsok nak amɨn pelaŋ kɨlɨ at, do tapmɨmno mɨnisi. Gak nepmaŋ degek manji dɨ nabɨm. ");
INSERT INTO yut_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Uwalno nɨkba kɨmokgeŋ do muwugek aŋupbal ak do gen yaŋ paŋteban aŋ. ");
INSERT INTO yut_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Uŋun yaŋ yoŋ, “Kɨlɨ yolek abɨdono. Uŋun aŋpulugosak amɨn kɨnda dɨma egɨsak. Piŋkop kɨlɨ yɨpmaŋ dekgɨt.” ");
INSERT INTO yut_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Piŋkop, dubagɨkon dɨma egɨpbi. Piŋkopno, tepmɨsi abɨŋek nak aŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Gen yaŋ namaŋ amɨn uŋun pabɨŋ yopmaŋek dapbɨ pasɨlni. Nak aŋupbal ak do nandaŋ, do gak da paŋɨŋtok aŋek madepsi paŋmayak abi dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Mani nak toktogɨsi gak nandaŋ gadaŋ gamɨŋek aŋpulugoki do jomjom abeŋ. Mango madepsi sigɨn awɨgɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Aŋpakgo kɨlegɨsi uŋun do amɨn yoyɨkeŋ. Yo masɨ masɨmɨ morapmɨsi nagon agɨl uŋun arɨpmɨ dɨma manjɨŋ mudogɨ, do gɨldat kɨnda kaloŋ gak do nandaŋ egek pulugaŋ nepgul uŋun dakon geni amɨn yoyɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Amɨn Tagɨ Yawe, gak dakon tapmɨm do nandaŋek gak aŋkɨsikeŋ. “Yawe kaloŋ gɨn uŋun amɨn kɨlegɨsi” yaŋ yoyɨŋ teŋteŋokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Piŋkop, nak monɨŋɨsogon da gak da nayɨŋ dek aŋaŋ wɨgɨl. Gak da yo masɨ masɨmɨsi asal uŋun do amɨn yoyɨŋ teŋteŋosot. ");
INSERT INTO yut_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Abɨsok nak amɨn pelaŋ kɨlɨ at, ae kuluno madepsi kwaŋ, do Piŋkop nak dɨma nepmaŋ dekgi. Nak gat egaki gak dakon tapmɨm madepgo do mɨŋat amɨn kabɨyo altaŋ altaŋ ani uŋun yaŋ teŋteŋok aŋyomɨŋ yomɨŋ abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Piŋkop, aŋpakgo kɨlegɨ uŋun tugaŋ kundu da arɨpmon wɨgɨgɨt. Gak pi madepsi agɨl. Amɨn kɨnda gak yombem mɨni. Gak da yapmaŋ mudosol. ");
INSERT INTO yut_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Gak da jɨgɨ mibɨlɨ mibɨlɨ yopbɨ nagon apgwit, mani nak nandɨsat, gak da nak aego aŋteban akdɨsal. Mɨktɨm kagagwan naŋ abɨ pɨdokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Gak da mano abɨ madepsi sigɨn pap tokdɨsak. Aŋek butno aego aŋteban akdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Piŋkopno, gak dɨmasi nepmaŋ dekdal, do mango awɨgɨk do gita tɨdokeŋ. Israel amɨn dakon Piŋkop telagɨ, mango awɨgɨk do gita tɨdaŋek kap yokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Nak kɨsɨk kɨsɨk aŋek yaŋ tɨdokeŋ. Gak do kap yaŋek mango awɨgɨkeŋ, nido yokwikon naŋ abɨdagɨl. ");
INSERT INTO yut_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Amɨn da nak abɨŋ nep do awit, mani gak da pabɨŋ yopmaŋek obɨsi paŋmayak agɨl. Yaŋ agɨl do nak gɨldat kɨnda kaloŋ gak dakon aŋpak kɨlegɨ do mɨŋat amɨnyokon yaŋ teŋteŋok abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Solomon dakon kap kɨnda. Piŋkop, aŋpakgo kɨlegɨ uŋun kɨla amɨn madep do iyɨŋ dekbɨ gen kokwin kɨlegɨ asak. ");
INSERT INTO yut_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Aŋaki aŋpak kɨlegɨkon da mɨŋat amɨn kabɨyogo ae yoni mɨni amɨn gen kokwin tagɨsi aŋ yomjak. ");
INSERT INTO yut_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Kɨla amɨn madep aŋpak kɨlegɨ asak, uŋun do ɨleŋ madep ae monɨŋɨkon jap bamɨ tagɨsi pani. ");
INSERT INTO yut_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Aŋpulugaŋbɨ kɨla amɨn madep da bupmɨ amɨn paŋpulugaŋban tagɨsi egɨpni. Ae yo do wadak wadak aŋ amɨn dakon gwakni paŋpulugosak. Mani amɨn do yokwi aŋyomaŋ amɨn uŋun pabɨŋ yopjak. ");
INSERT INTO yut_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Kɨla amɨn madep aŋpulugaŋbɨ gɨldat ae kanek tonjil da arɨpmon egɨpjak. ");
INSERT INTO yut_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Kɨla amɨn madep aŋpulugaŋbɨ aŋpak tagɨsi baŋgɨn asak. Aŋaki sɨkak da maŋek jap paŋɨreŋ asak uŋun da tɨlak aŋpakni tagɨ da tagɨsi noman tosak. ");
INSERT INTO yut_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Mɨktɨmon egɨpjak bɨsapmon amɨn aŋpak kɨlegɨsi baŋgɨn ani. Kanek da taŋ aŋaŋ kɨsak bɨsapmon yo kɨnda do wadak wadak dɨma ani. ");
INSERT INTO yut_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Kɨla amɨn madep egek tap terɨ kɨnda da tap terɨ kɨnda mɨktɨm daman tosok, gat ae Pakbi Yupretis kon da mɨktɨm morap taŋ aŋaŋ kwaŋ uŋun gat kɨsi kɨla akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Mɨktɨm kɨbɨrɨ tɨmon amɨn da gawagek pasal ɨmni. Ae uwalni da mɨktɨmonsi maŋ pagek pasal ɨmni. ");
INSERT INTO yut_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Spen mɨktɨm dakon kɨla amɨn madep gat ae tap binap mɨktɨm tɨm toŋ uŋun dakon kɨla amɨn madep kɨsi da gawat gawat aŋ ɨmɨŋek yo tomni madep baŋ ɨmni. Arebia mɨktɨm gat ae Seba mɨktɨm gat dakon kɨla amɨn madep da yaŋ gɨn akdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Kɨla amɨn madep morap da ŋwakbeŋ aŋ ɨmɨŋakwa mɨŋat amɨn morapyo da oman aŋ ɨmdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Yoni mɨni amɨn da paŋpulugosak do yaŋ tɨdaŋba paŋpulugosak. Ae jɨgɨ paŋek paŋpulugogɨ mɨni amɨn paŋpulugosak. ");
INSERT INTO yut_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Ae amɨn tapmɨmɨ mɨni wadak wadak ekwaŋ uŋun do bupmɨ nandaŋek paŋpulugosak. ");
INSERT INTO yut_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Uŋuden amɨn do but dasi galak taŋ yomɨsak, do uwal da pabɨŋ yopmaŋek paŋupbal ani bɨsapmon uwal da kɨsiron baŋ pulugaŋ yopdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Kɨla amɨn madep uŋun bɨlak morapmɨ egɨpjak dosi nandɨsat. Arebia mɨktɨm amɨn da gol ɨmni. Gɨldat kɨnda kaloŋ Piŋkop da aŋpulugosak do mɨŋat amɨnyo da bɨsit aŋ ɨmni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Lebanon mɨktɨmon wit tagɨsi kwoŋ, uŋudeŋ gɨn amɨn da pigaga yaŋ gɨn kwoni. Joŋ morap kwaŋ ɨreŋ toŋ uŋun da tɨlak kokup papmon amɨn yaŋ gɨn ɨreŋ toni. ");
INSERT INTO yut_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Kɨla amɨn madep uŋun dakon man madepni do dɨma ɨŋtoni dosi nandɨsat. Gɨldat da toktogɨsi tosok uŋun da arɨpmon man madepni toktogɨsi yaŋ gɨn taŋ aŋ aŋ kɨsak. Uŋun amɨn dogɨn aŋek mɨktɨmɨ mɨktɨmɨ amɨn da gɨsamɨ toŋ egek kɨla amɨn madep do gɨsamɨ toŋ amɨn yaŋ iyɨni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Piŋkop, Israel amɨn dakon Yawe aŋkɨsino. Yo masɨ masɨmɨsi uŋun kaloŋ dagɨn asak. ");
INSERT INTO yut_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Mani tɨlɨmni toŋ uŋun toktogɨsi aŋkɨsino. Mɨktɨmɨ mɨktɨmɨ tɨlɨmni tugok tugogɨsi taŋ aŋaŋ kɨkdɨsak. Uŋun bamɨ, uŋun asi. ");
INSERT INTO yut_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","(Dewit, Jesi dakon monji, uŋun dakon bɨsit obɨŋ ɨdon dagosok.) ");
INSERT INTO yut_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Asap dakon kap kɨnda. Piŋkop da Israel amɨn do yo tagɨsi aŋ yomɨsak. Piŋkop da butnigwan yoni mɨnisi amɨn do yo tagɨsi yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Mani nak da naga yokwikon palɨ magɨm. Nak kandapno sagalek yaŋ nɨkban maŋek nandaŋ gadatno palɨ yɨpmaŋ dekgɨm. ");
INSERT INTO yut_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Nido, nak kwen wugɨk amɨn yokwi pakpak uŋun pɨndakgo yoni morapmɨsi aŋakwa uŋun dakon yoni do pɨndak galaktok agɨm. ");
INSERT INTO yut_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Gɨptɨmnikon tepmɨ dɨma nandaŋ. Uŋun amɨn tebai ae gɨptɨmni uŋun tagɨsi gɨn. ");
INSERT INTO yut_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Jɨgɨ amɨn dɨwarɨ da paŋ uŋudeŋ dɨma paŋ. Amɨn dɨwarɨ jɨgɨ mibɨlɨ mibɨlɨ paŋ, mani yo uŋuden dɨ dɨma noman taŋ yomaŋ. ");
INSERT INTO yut_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Do iyɨ do nandaba wɨgakwa kɨsɨk kɨsɨk aŋ, ae nomansi amɨn dɨwarɨ dapmaŋek paŋupbal aŋ. ");
INSERT INTO yut_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Uŋun but nandak nandaknikon da aŋpak yokwi ak do nandaŋ uŋun paŋalon aŋ. ");
INSERT INTO yut_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Amɨn dɨwarɨ do manji gen yaŋ yomɨŋek yokwi aŋ yom do gen yoŋ. Uŋun kwen wugɨksi aŋek amɨn dɨwarɨ paŋupbal ak do gen madepsi yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Piŋkop Kwen Kokup egɨsak uŋun do gen yokwi yaŋ ɨmaŋ. Aŋek iyɨ dakon man pawɨgek amɨn morap da geni guramɨtni do pi tebaisi aŋ kɨmokgoŋ. ");
INSERT INTO yut_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Do Piŋkop dakon mɨŋat amɨnyo dɨwarɨ kwen wɨgɨk amɨn dakon gen do galak taŋek geni uŋun nandaŋ gadaŋ. ");
INSERT INTO yut_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Amɨn yokwi da gen yaŋ yoŋ, “Piŋkop da yo nin da amaŋ uŋun arɨpmɨ dɨma nandɨsak. Piŋkop Wukwisi da nin dakon aŋpaknin dakon mibɨlɨ nandɨsak dakon kosit kɨnda dɨma tosok.” ");
INSERT INTO yut_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Amɨn yokwi uŋun jɨgɨ dɨ dɨma noman taŋ yomaŋ. Aŋakwa yoni morapmɨsi, ae sigɨn ɨreŋ toŋ. ");
INSERT INTO yut_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Nak naga dakon egɨp egɨpno kɨla tebaisi agɨm, ae butno gwaljɨgɨ mɨni tosok, ae yokwi dɨ dɨma agɨm. Uŋun ɨsal dogɨn agɨm, ma? ");
INSERT INTO yut_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Piŋkop, nak yokwi dɨma agɨm, mani gak da gɨldat kɨnda kaloŋ gɨp tedep namɨsal, ae wɨsa dagokdo morap kobogɨ yokwisi namɨsal. ");
INSERT INTO yut_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Nak gak dakon mɨŋat amɨnyogo do amɨn yokwi da gen yoŋ uŋudeŋ yoyɨgɨm tam, top yoyɨkom. ");
INSERT INTO yut_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Nak amɨn yokwi da yo uŋun aŋ dakon mibɨlɨ wɨsɨŋ kok do agɨm, mani aŋtɨdok agɨm. ");
INSERT INTO yut_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Piŋkop, nak gak da telagɨ yutnon wɨgɨgɨm bɨsapmon nandak nandakno pɨsagɨt. Aŋek amɨn yokwikon yo noman tokdaŋ uŋun do nandako pɨsagɨt. ");
INSERT INTO yut_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Piŋkop, gak da amɨn yokwi abɨ kosit sagalegɨsi baŋ akwaŋ, aŋek abɨ maŋek wagɨlsi tasɨk toŋ. ");
INSERT INTO yut_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Uŋun tepmɨsi tasɨk toŋ. Ae kɨmotni uŋun pasol pasolɨsi ae yokwisi. ");
INSERT INTO yut_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Amɨn Tagɨ, uŋun amɨn da dɨpmɨn pɨndakgaŋ da wɨsa dagaŋakwan pasɨlgaŋ uŋun yombem. Gak da abɨŋaki amɨn yokwi pasɨl mudoni. ");
INSERT INTO yut_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Uŋun bɨsapmon nak bupmɨsi nandagɨm, aŋek butnokon da yokwisi nandagɨm. ");
INSERT INTO yut_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Nandak nandakno mɨnisi agɨt. Joŋ kɨlap burɨ mɨni da yaŋ gak da dabɨlon aŋpak agɨm. ");
INSERT INTO yut_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Mani nak gak gat toktogɨsi egapbo kɨsitno amɨnsi tet do abɨdosol. ");
INSERT INTO yut_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Nak da kosit kɨlegɨ agɨpbeŋ do nayɨŋ dekdal. Ae don gak da nak abɨdaŋbɨ kokup tɨlɨmni toŋ uŋudon gak gat egɨpdamak. ");
INSERT INTO yut_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Namɨn amɨn dɨ da Kwen Kokup egek nak dakon kɨla aŋ? Amɨn dɨ mɨnisi, gak kaloŋ gɨn. Piŋkop, nak gak do but dasi galak taŋ gamɨŋ kɨmokdot. Gak do but dasi galak tosot uŋudeŋ mɨktɨm dakon yo morap do dɨma galak tosot. ");
INSERT INTO yut_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Gɨptɨmno ae wupno tapmɨmni mɨnisi anjil kaŋ, Piŋkop gak kaloŋgɨn teban tokno. Aŋek nak gat egaki toktogɨsi wadak wadagɨ mɨni egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Asisi, mɨŋat amɨnyo manji gamaŋ uŋun tasɨk tokdaŋ. Amɨn gak golgwit da ae kɨlɨ gepmaŋ dekgwit, uŋun paŋupbal abɨ mɨni ani. ");
INSERT INTO yut_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Mani nak gak da kapmatjok egɨsat, uŋun da tagɨsi. Amɨn Tagɨ Yawe, gak da nak tagɨsi aŋkutnosol. Nak yo morap agɨl do yaŋ teŋteŋok abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Asap dakon kap kɨnda. Kap on do Maskil yaŋ yoŋ. Piŋkop, gak nido toktogɨsi manji nimɨsal? Nido sipsip kabɨgo tagɨsi pawɨldal nin do butjap tebaisi nandaŋ nimɨsal? ");
INSERT INTO yut_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Mɨŋat amɨnyogo nin do aego nandaki. Kalɨpsigwan mɨŋat amɨnyogo nin manjɨŋ nipgul. Gak da nin yumaŋ nagɨl da nin gak dakon kabɨ ekwamaŋ. Saion Kabap kalɨp egɨpgul uŋun do aego nandaki. ");
INSERT INTO yut_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Uwalnin da gak dakon telagɨ yutgo dakon yo morap kɨlɨ paŋtasɨk awit. Abɨŋek yo morap paŋtasɨk awit uŋun pɨndakgi. ");
INSERT INTO yut_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Uwalgo da telagɨ yutgokon wɨgek yaŋ tɨdaŋek galak toknikon yo awit. Gak dakon yo kulabɨk aŋek iyɨ emaron teban tawit uŋun dakon tɨlakni baŋ yopgwit. ");
INSERT INTO yut_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Amɨn da koron kɨndap pasaŋ uŋudeŋ, gak dakon yut pasɨwit. ");
INSERT INTO yut_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Kɨndap kwɨk tɨlak tagɨsi baŋ paŋtɨlɨm abi, uŋun uwal da pareŋka ae ama madep baŋ tɨdaŋ tuwɨlgwit. ");
INSERT INTO yut_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Kɨndap baŋ yutgo sowit. Uŋun aŋpak yokwisi aŋek yut uŋun gaga egɨp do manjɨgɨl, uŋun aŋupbal aba telagɨ dɨma tagɨt. ");
INSERT INTO yut_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Nin wagɨlsi pabɨŋ nip do nandak nandak awit, do mɨktɨmninon Piŋkop gawak ɨmɨm yut morap toŋ uŋun soŋ mudawit. ");
INSERT INTO yut_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Gak da wasok tapmɨmɨ toŋ kɨnda abɨ dɨma komaŋ. Ae abɨsok kombɨ amɨnin mɨni. Ni bɨsapmon jɨgɨ uŋun pasɨljak uŋun ninon da kɨnda dɨma nandɨsak. ");
INSERT INTO yut_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Piŋkop, bɨsap niaŋ da uwal da yaŋsul yokwisi aŋ gamni? Toktogɨsi gak dakon man do yaŋba yokwi tok aŋegɨpni? ");
INSERT INTO yut_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Gak nido nin dɨma paŋpulugok do nandɨsal? Tapmɨm madepgokon da uwalnin dapbɨ tasɨk toni. ");
INSERT INTO yut_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Mani Piŋkop, kalɨpsigwan gak kɨla amɨn madepnin egɨpgul, ae abɨsok kɨsi kɨla amɨn madepnin egɨ nimɨsal. Bɨsap morapmɨ gak da nin paŋpulugaŋbɨ emaron dɨma tasɨk tagɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","14","Gak dasi tapmɨm madepgokon da tap pudagɨl, aŋek uŋun tap pakbi kagagwan nugɨm madep mani Liwaiatan uŋun dakon busuŋɨ paŋsulɨkgɨl. Aŋek gɨptɨm tɨmni mɨktɨm kɨbɨrɨ nɨmani toŋ tɨmon joŋ kɨlap do yobɨ nawit. ");
INSERT INTO yut_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Gak dasi abɨ pakbi monɨŋ mɨktɨm tɨmon noman taŋek pak abɨgɨwit. Ae gak dasi pakbi madep abɨ wagɨlsi kɨbɨdawit. ");
INSERT INTO yut_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Gak dasi gɨldat kalba gat ae pɨlɨn gat wasagɨl. Ae gɨldat gat kanek gat kwen yopgul. ");
INSERT INTO yut_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Gak dasi mɨktɨm morap dakon wasɨpni yopgul. Ae bɨlagɨ bɨlagɨ dakon gɨldat ae sɨkak bɨsap yopgul. ");
INSERT INTO yut_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Yawe, gak dɨma ɨŋtoki. Uwalgo da yaŋsul yokwisi aŋ gamaŋ. Uŋun nandaŋ kokwini tagɨ dɨma amɨn da mango do yaŋba yokwi tok aŋ. ");
INSERT INTO yut_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Mɨŋat amɨngo kɨnarɨm yombem tapmɨmni mɨni, do gak da nin nipmaŋ dekbɨ joŋ bɨt kɨlapyo da dɨma paŋupbal ani. Uwal da mɨŋat amɨngo nin obɨsi paŋupbal aŋ, do dɨmasi ɨŋtaŋ nibi. ");
INSERT INTO yut_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Mɨktɨmninon dukwan dukwan morap kɨsi emat aŋ, ae pɨlɨn tuk madepsi tosok, do gak da nin gat saŋbek saŋbek agɨl uŋun do aego nandaki. ");
INSERT INTO yut_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Yum pɨndagaki amɨn yokwi da bupmɨ amɨn bamaŋ yomɨŋek dɨma paŋmayak ani. Wadak wadak amɨn uŋun da mango aŋkɨsini do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Piŋkop, uwal da gen yaŋ gamaŋ, do gak abɨŋek gen pikon gaga da tet kɨla tebai abi. Gɨldat kɨnda kaloŋ nandaŋ kokwini tagɨ dɨma amɨn da yaŋsul yokwisi aŋ gamaŋ uŋun do nandaki. ");
INSERT INTO yut_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Uwalgo da gen pap yaŋek gen yokwi yaŋ gamaŋ. Uŋun toktogɨsi madepsi yaŋ tɨdoŋ. Piŋkop, aŋpak yokwini do dɨma ɨŋtaŋ yobi. ");
INSERT INTO yut_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Asap dakon kap kɨnda. Kap on Piŋkop gawak ɨmɨm dakon kap. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban “Dɨma paŋtasɨk ani” uŋun tegon da yoni. Piŋkop, nin gak do ya yaŋ gayɨŋek mango toktogɨsi awɨkwamaŋ. Aŋek man madepgo do yaŋ teŋteŋok aŋek wasok tapmɨmɨ toŋ mibɨlɨ mibɨlɨ agɨl uŋun do yomaŋ. ");
INSERT INTO yut_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Piŋkop da yaŋ yosok, “Nak da gen pikon depbeŋ dakon bɨsap kɨnda kɨlɨ manjɨgɨm. Gen kokwin kɨlegɨsi akdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Mɨktɨm wudɨp aŋakwan mɨŋat amɨnyo uŋun yaworɨ dɨma ekwaŋ. Mani mɨktɨm dakon mibɨlɨ tebai abɨdaŋapbo tebai tosak. ");
INSERT INTO yut_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Nak da iyɨ do nandaba wɨkwaŋ amɨn yaŋ yoyɨsat, ‘Ji pɨbɨt tɨdok dɨma ani.’ Ae amɨn yokwi yaŋ yoyɨsat, ‘Ji dɨsi dakon man dɨma pawɨgɨni. ");
INSERT INTO yut_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Dɨsi dakon tapmɨm do kɨsɨk kɨsɨk dɨma ani, ae madepsi yaŋ tɨdaŋek manji gen dɨma yaŋ namni.’ ” ");
INSERT INTO yut_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Mɨŋat amɨnyo man madep yomyom dakon pi uŋun mɨktɨm terɨ terɨ taŋ aŋ aŋ kwaŋ dakon amɨn kɨnda da arɨpmɨ dɨma agagɨ. ");
INSERT INTO yut_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Piŋkop kaloŋ dagɨn aŋpaknin kokwin asak. Uŋun da amɨn dɨwarɨ pabɨŋ yopmaŋek amɨn dɨwarɨ pawɨgɨsak. ");
INSERT INTO yut_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Yawe da kɨsitnikon kap kɨnda abɨdosok, uŋun wain yokwisi ae tebaisi yo ɨsɨpmɨ gat ɨktagɨlbi uŋungwan tugaŋbi. Uŋun tagalban amɨn yokwi morap da kɨsi naŋ mudoŋ. ");
INSERT INTO yut_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Mani nak toktogɨsi Jekop dakon Piŋkop do yaŋ teŋteŋok aŋek mani awɨgɨk do kap yokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Piŋkop da amɨn yokwi dakon tapmɨm wɨrɨrɨkban pasɨldaŋ. Mani amɨn kɨlegɨ do tapmɨm madepsi yomdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Asap dakon kap kɨnda. Kap on Piŋkop gawak ɨmɨm dakon kap. Gita tɨdaŋek yogogɨ. Juda mɨktɨmon amɨn da Piŋkop pakyaŋsi nandaŋ ɨmaŋ. Israel mɨktɨmon mani wukwisi tosok. ");
INSERT INTO yut_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Yutni uŋun Jerusalem tosok. Saion Kabapmon tosok. ");
INSERT INTO yut_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Uŋun kokupmon uwal dakon gobɨŋni gat, ae pasɨkni gat, ae emat agak sɨbani gat jokgalgɨt. Piŋkop da emat dakon yo morapni paŋupbal agɨt. ");
INSERT INTO yut_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Piŋkop, gak tɨlɨmgo uŋun madepsi, ae gak kɨla amɨn madep mibɨltogɨ. Gak wukwisi, man madepgo da kabap madep dakon man madep yapmaŋ mudosok. ");
INSERT INTO yut_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Gak uwal dakon emat amɨni tapmɨmɨ toŋ dakon yoni tagɨsi gwayeŋ paŋapgul. Uŋun emat amɨn uŋun kɨlɨ kɨmak mudawit, ae emat dakon yo kabɨni tɨmɨtni dakon tapmɨm mɨni. ");
INSERT INTO yut_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Jekop dakon Piŋkop, gak da tebai yoyɨgɨl, do os gat ae amɨn ɨlɨk pawɨlgaŋ tamo gat kɨsi wayɨŋɨ mɨni. ");
INSERT INTO yut_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Piŋkop, amɨn gak do si pasolgoŋ. Gak da butjap nandaŋ yobi bɨsapmon, namɨn da gak da dabɨlon tagɨ atjak? Amɨn kɨnda da arɨpmɨ dɨma. ");
INSERT INTO yut_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Gak kwen kokupmon da uwal da kobogɨ yokwisi tɨmɨtni do yagɨl, aŋaki mɨktɨmon mɨŋat amɨnyo da pasalek tayaŋgok egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Piŋkop gak pɨdaŋ agek amɨn yokwi dakon aŋpakni kokwin aŋek jɨgɨni toŋ amɨn pulugaŋ yopmaŋdal. ");
INSERT INTO yut_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Gak butjap nandaŋek kobogɨ yomɨsal, do amɨn dɨwarɨ mango awɨkwaŋ. Ae amɨn emaron dɨma yokwi toni uŋun da gak gawak gamdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Yawe Piŋkopgo yaŋ teban tok aŋ ɨmɨŋek uŋun gen si guramɨkgi. Mɨŋat amɨn morap ji Yawe do pasalek but galak do yo paŋkɨ ɨmni. ");
INSERT INTO yut_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Uŋun on mɨktɨm dakon kɨla amɨn madep kwen wɨgɨk aŋ, uŋun pabɨŋ yopmaŋdak, do madepsi pasal ɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Asap dakon kap kɨnda. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban “Jedutun” uŋun tegon da yoni. Nak Piŋkop da aŋpulugosak do yaŋ tɨdosot. Bɨsitno nandɨsak do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Jɨgɨ bɨsapmon nak Amɨn Tagɨ do bɨsit asat. Kalbi bɨsit aŋ ɨmɨsat, mani but yawot dɨma abɨdosot. ");
INSERT INTO yut_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Nak Piŋkop do nandak nandak aŋek iyoŋ iyoŋ yosot. Nandak nandak aŋegek butno jɨk tosok. ");
INSERT INTO yut_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Butno jɨgɨsi, do gen arɨpmɨ dɨma yokeŋ. Piŋkop gak da yum nandaŋaki dɨpmɨn dɨma pokdot. ");
INSERT INTO yut_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Nak kalɨp tagɨ egɨpgum uŋun do nandɨsat. Bɨlak uŋun kɨlɨ kɨŋ mudawit, uŋun do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Kalbi nak nandak nandak morapmɨ aŋek naga do yaŋ yosot, ");
INSERT INTO yut_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Amɨn Tagɨ da toktogɨ manji namjak bo? Nak do saŋbeŋek dɨma galak tosak bo? ");
INSERT INTO yut_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Amɨn do but dasi galaktaŋ yomyom aŋpakni wagɨl pasɨlgɨt bo? Yaŋ teban tok morapni ɨsalɨ bo akdaŋ? ");
INSERT INTO yut_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Piŋkop da kɨlɨ ɨŋtaŋ nimgut da bupmɨ nandaŋ nim do dɨma bo nandɨsak? Butjapni da bupmɨni sopmaŋdak bo?” ");
INSERT INTO yut_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Nak yaŋ nandaŋek yagɨm, “Piŋkop Wukwisi, gak abɨsok nak dɨma aŋpulugosol, do nak uŋun do butno obɨsi jɨk tosok.” ");
INSERT INTO yut_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Piŋkop, nak gak dakon pi madep do aeno nandakeŋ. Asi, wasok tapmɨmɨ toŋ kalɨp agɨl uŋun do nandakeŋ. ");
INSERT INTO yut_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Pi morap agɨl uŋun do nandakeŋ. Pi tapmɨmɨ toŋ agɨl uŋun kɨsi do nandakeŋ. ");
INSERT INTO yut_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Piŋkop, aŋpakgo telagɨ. Kokup kɨdat kɨnda gak gat arɨp dɨma. Gak da yapmaŋ mudosol. ");
INSERT INTO yut_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Piŋkop, gak kaloŋ dagɨn wasok tapmɨmɨ toŋ asal. Kalɨp gak da tapmɨmgo madepsi mɨŋat amɨn kabɨ morapmon yolɨgɨl. ");
INSERT INTO yut_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Gaga da tapmɨmon da mɨŋat amɨn kabɨgo Jekop gat Josep gat dakon babɨkni yokwikon baŋ tɨmɨkgɨl. ");
INSERT INTO yut_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Piŋkop, Tap Gami da gak gandagɨt bɨsapmon si pasalek kwakwalɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Sɨkak madepsi maŋakwa kɨrɨrɨŋ madepsi awit. Aŋek mal madepsi aŋek teŋteŋɨ dukwan dukwan kɨsi yamgwit. ");
INSERT INTO yut_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Mɨrɨm kwasɨgɨlgwit da binapgwan gak da kɨrɨrɨŋ yopbɨ yawit. Mal da aban mɨktɨm morap dukwan dukwan kɨsi teŋteŋaŋakwa mɨktɨm kwakwalɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Gak tap binap naŋ agɨpgul. Kosit tap ɨdap madep da binap tagɨt, mani gak dakon kandap tamo dɨma kawit. ");
INSERT INTO yut_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Gak mibɨltok kɨŋaki mɨŋat amɨnyo da buŋon golgwit. Gak da Moses gat Aron gat do pi yobɨ uŋun da kɨlani agɨmal. ");
INSERT INTO yut_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Asap dakon kap kɨnda. Kap on do Maskil yaŋ yoŋ. Nak dakon mɨŋat amɨnyo, ji nak dakon nawa gen pakyaŋsi nandani. Gen yokdɨsat uŋun do mɨrak pakyaŋsi yopni. ");
INSERT INTO yut_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Nak ji do tɨlak gen dayɨkdɨsat. Nak da yo kalɨpsigwan noman tawit uŋun dakon mibɨlɨ do yokdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Kalɨp babɨknin da yo uŋun do kɨlɨ niyɨŋba nandaŋek tɨmɨkgɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Nin monjɨ gwayonin do gen uŋun dɨma paŋkɨsɨbɨneŋ. Monjɨ gwayonin uŋun yoyɨneŋ. Piŋkop dakon tapmɨmni gat ae pi tapmɨmɨ toŋ agɨt gat ae wasok tapmɨmɨ toŋ mibɨlɨ mibɨlɨ agɨt uŋun do yoyɨneŋ. ");
INSERT INTO yut_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Piŋkop da Jekop do geni yomgut. Israel dakon babɨni da guramɨtni do yomgut. Kalɨpsigwan babɨknin yaŋ yoyɨgɨt, “Ji monjɨ gwayosi nak dakon gen teban morapno pakyaŋsi yoyɨŋdetni.” ");
INSERT INTO yut_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Yaŋ ani kaŋ, mɨŋat monjɨyo don altoni uŋun da nandaŋ pɨsaŋek yoyɨŋ dek aŋ aŋ ani. ");
INSERT INTO yut_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Yaŋ aŋakwa uŋun amɨn kabɨ kɨsi da egɨp egɨpni Piŋkopmon tosok yaŋsi nandaŋek jomjom aŋek yo agɨt uŋun do dɨma ɨŋtoni. Aŋek gen teban morapni tagɨ guramɨtni. ");
INSERT INTO yut_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Aŋek babɨkni yombem dɨma egɨpni. Babɨkni kwen wɨgɨk aŋek Piŋkop dakon gen pabɨŋ yopmaŋek tebai dɨma nandaŋ gadaŋ ɨmgwit. Aŋek wupmon da toktogɨsi dɨma yolgwit. ");
INSERT INTO yut_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Kalɨp Epraim amɨn obip gobɨŋyo taŋ yomgwit, mani emat noman taŋban pasal kɨwit. ");
INSERT INTO yut_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Piŋkop da saŋbek saŋbek agɨt uŋun dɨma guramɨkgwit, ae nawa geni dɨmasi yol do nandawit. ");
INSERT INTO yut_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Wasok tapmɨmɨ toŋ yolɨŋban pɨndakgwit uŋun do kɨlɨ ɨŋtawit. ");
INSERT INTO yut_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Babɨkni da dabɨlon Isip mɨktɨm uŋudon Soan mɨktɨm tɨmon Piŋkop da wasok tapmɨmɨ toŋ agɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Uŋun da tap ɨdap pudaŋban tap ɨdap terɨ terɨ agakwan Israel amɨn binapmon da paŋkɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Gɨldarɨ uŋun gɨkwem naŋ yolɨŋakwan uŋun naŋ kaŋek yolgwit, ae kalbi kɨndap teŋteŋ naŋ yolɨŋakwan uŋun naŋ kaŋek yolgwit. ");
INSERT INTO yut_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Mɨktɨm kɨbɨrɨ tɨmon tɨp pudaŋban pakbi madepsi mibɨlɨkon noman taŋban nawit. ");
INSERT INTO yut_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Tɨpmon pakbi aban noman tagɨt uŋun koron pakbi madep da yaŋ pak kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Mani Piŋkop Wukwisi do yokwi sigɨn aŋ ɨmgwit. Mɨktɨm kɨbɨrɨ tɨmon egek kwen wɨgɨk aŋ ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Piŋkop aŋkɨlɨt do aŋek yaŋ awit, jap si galak tawit uŋun si yomjak dosi tebai iyɨwit. ");
INSERT INTO yut_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Piŋkop manji gen yaŋ ɨmɨŋek yaŋ yawit, “Piŋkop mɨktɨm kɨbɨrɨ tɨmon jap morapmɨ arɨpmɨ tagɨ nimjak? ");
INSERT INTO yut_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Asi, mibɨltok tɨp tɨdaŋban pakbi madepsi noman tagɨt. Mani bret gat ae bɨt kɨlapyo dɨ arɨpmɨ tagɨ nimjak bo dɨma?” ");
INSERT INTO yut_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Yawe da geni uŋun nandaŋek Jekop do butjap nandaŋ yomgut. Israel dakon amɨn kabɨ do kɨndap yɨpban pɨŋakwan japmɨsi nandaŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Nido, dɨma nandaŋ gadaŋ ɨmgwit. Uŋun da kɨlani arɨpmɨ tagɨ asak yaŋ dɨma nandawit. ");
INSERT INTO yut_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Yaŋ awit, mani Piŋkop da yaŋban kundu yoma wɨtdal kɨgɨt. Wɨtdal kɨŋakwan Kwen Kokup da ");
INSERT INTO yut_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","mana yopban pɨŋakwa nawit. Uŋun Kwen Kokup dakon jap. ");
INSERT INTO yut_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Uŋun aŋelo dakon jap. Piŋkop da mana morapmɨ arɨpnikon yomgut. ");
INSERT INTO yut_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Aŋek gɨldat wɨsak tet da mɨrɨm yɨpban kɨgɨt. Ae tapmɨm madepnikon da saut tet da mɨrɨm yɨpban kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Aŋek mɨnam morapmɨsi, kɨmbabaŋ ae tap nɨman da tɨlak, morapmɨsi yopban bɨkbɨknikon mawit. ");
INSERT INTO yut_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Piŋkop da mɨnam morapmɨ yopban maŋek yut kabeŋni paŋgwasɨŋek tawit. ");
INSERT INTO yut_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Maŋakwa naŋek arɨpmɨsi tugawit. Yo uŋun do galak tawit uŋun Piŋkop da yomgut. ");
INSERT INTO yut_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Mani jap si galak tawit uŋun sigɨn naŋ egakwa ");
INSERT INTO yut_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Piŋkop da butjap nandaŋek Israel amɨn dakon monjɨ tebaisi ae tagɨsi uŋun dapban kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Piŋkop da wasok tapmɨmɨ toŋ yaŋ agɨt, mani mɨŋat amɨnyo da yokwi sigɨn aŋek dɨma nandaŋ gadaŋ ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Do mɨrɨm da gen kagakon noman taŋek tepmɨsi pasɨlgaŋ uŋun da tɨlak tepmɨsi paŋpasɨl agɨt. Uŋun paŋupbal aban pasol pasol madepsi aŋek kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Piŋkop da dɨ dapban kɨmakgwit bɨsapmon dɨwarɨ but tobɨl aŋek tobɨl abɨŋ yolgwit. ");
INSERT INTO yut_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Aeni nandawit, Piŋkop uŋun tɨp damanin. Piŋkop Wukwisi uŋun yokwikon baŋ tɨmɨt tɨmɨt amɨnin. ");
INSERT INTO yut_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Mani uŋun si aŋgalak aŋek top yawit. ");
INSERT INTO yut_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Uŋun but dasi dɨma yolgwit. Uŋun gat saŋbek saŋbek awit uŋun kɨrɨŋɨkgwit. ");
INSERT INTO yut_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Mani bupmɨ nandaŋ yomɨŋek dɨwarɨni wɨrɨrɨk yomɨŋek dɨma paŋupbal agɨt. Bɨsap morapmɨ butjapni yɨpmaŋek dɨma japtaŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Uŋun do aeni nandagɨt, uŋun mɨktɨm amɨn gɨn, uŋun mɨrɨm da yaŋ kɨŋ mudoŋ, aeni dɨma abaŋ. ");
INSERT INTO yut_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Bɨsap morapmɨ mɨktɨm kɨbɨrɨ tɨmon kwen wɨgɨk aŋakwa bupmɨsi nandagɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Israel amɨn dakon Piŋkop Telagɨsi bɨsap morapmɨ aŋkewalakwa nandaban yokwi tok aŋyomgut. ");
INSERT INTO yut_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Tapmɨm madepni do ɨŋtawit, ae uwal da kɨsiron baŋ tɨmɨkgɨt uŋun do dɨma nandawit. ");
INSERT INTO yut_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Uŋun tɨlak tapmɨmɨ toŋ Isip mɨktɨmon Soan mɨktɨm tɨmon agɨt uŋun do dɨma nandawit. ");
INSERT INTO yut_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Pakbi aŋtobɨlban yawi dagaŋba arɨpmɨ dɨma noknogɨ agɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Ae bɨgal morapmɨ yabekban ɨnjɨŋ yomgwit. Ae meŋgak morapmɨ yabekban yo morapni paŋupbal awit. ");
INSERT INTO yut_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Ae pɨlak pɨlak yabekban kɨŋ pigagani yo kwawit uŋun naŋ mudawit. ");
INSERT INTO yut_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Ae ais yɨpban maŋek wain napni ae pik kɨndapni paŋupbal awit. ");
INSERT INTO yut_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Ae ais yopban maŋek bulmakauni dapba kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Butjap madepsi nandaŋ yomɨŋek yo yokwisi aŋ yomgut. Aŋek aŋelo kabɨ kɨnda yabekban kɨŋ paŋupbal aŋakwa jɨgɨ madepsi pawit. ");
INSERT INTO yut_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Butjap madepsi nandaŋek yum dɨma pɨndakgɨt. Sot madepsi yoban kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Isip amɨn morap kɨsi dakon monjɨ mibɨltogɨ dapban kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Mani uŋun sipsip kɨla amɨn yombem da iyɨ mibɨltok kɨŋek mɨŋat amɨn kabɨni kɨla agɨt. Mɨktɨm kɨbɨrɨ tɨmon kosit yolɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Tɨmɨk paŋgwan jɨgɨni mɨni egɨpgwit, do dɨma pasalgwit. Mani tap ɨdap da uwalni wɨtjɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Tɨmɨk paŋpaŋ telagɨ mɨktɨmnikon paŋapgut. Uŋun mɨktɨm ɨleŋɨ obani toŋ iyɨ da tapmɨmon abɨdagɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Mɨŋat amɨni apgwit bɨsapmon amɨn ŋwakŋwarɨ yolban kɨwit. Kɨŋakwa mɨktɨm uŋun Israel amɨn kabɨ do kokwinɨk yomgut. Aŋek yopban yutnikon yɨkgwit. ");
INSERT INTO yut_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Mani Israel amɨn da Piŋkop Wukwisi aŋkewalek kwen wɨgɨk aŋ ɨmɨŋek gen tebani dɨma guramɨkgwit. ");
INSERT INTO yut_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Kalɨp babɨkni da awit, uŋudeŋ gɨn, kwen wɨgɨk aŋek Piŋkop manji ɨmgwit. Uŋun obip gɨreŋɨ dɨkdɨk suŋ yamaŋdak uŋun yombem. ");
INSERT INTO yut_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Kokup kɨdat dakon alta wasaŋakwa uŋun do aŋek Piŋkop da butjap madep nandagɨt. Piŋkop yɨpmaŋek kokup kɨdat gawak yomɨŋakwa nandaba yokwi tok aŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Piŋkop da aŋpakni pɨndagek butjap nandaŋ yomgut, do Israel amɨn do manji wagɨlsi yomgut. ");
INSERT INTO yut_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Aŋek ɨmal yutni telagɨ Silo kokup papmon tagɨt uŋun yɨpmaŋ kɨgɨt. Kalɨp uŋun yutnon egɨpgut bɨsapmon mɨŋat amɨnyo da binapmon egɨpgut. ");
INSERT INTO yut_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Mani yum pɨndagakwan Saŋbek Saŋbek Kɨnam uwal da abɨdawit. Uŋun tamo tɨmon tapmɨmni gat ae tɨlɨmni uŋudon tagɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Mɨŋat amɨn kabɨni do butjap nandaŋek yum pɨndagakwan uwal da emat agak sɨba baŋ dapba kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Monjɨ bulagɨ emat madepmon kɨmagakwa mɨŋatjok wɨli mɨni, do amɨn dɨma pawit. ");
INSERT INTO yut_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Uwal da mukwa sogok amɨn dapba kɨmagakwa mɨŋatni da bupmɨ kunamyo ani dakon bɨkbɨk dɨma taŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Amɨn da dɨpmɨnon da pɨdoŋ uŋudeŋ Amɨn Tagɨ pɨdagɨt. Ae amɨn tebai wain morapmɨ naŋek pokgoŋ da don pɨdaŋek yaŋ tɨdoŋ uŋun da tɨlak Yawe pɨdagɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Aŋek uwal gat emat aŋek yolban kɨŋ mudawit. Pabɨŋ yopmaŋakwan mayaktok toktok teban pawit. ");
INSERT INTO yut_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Mani Josep dakon babɨkni dɨma manjɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Uŋun Juda amɨn kabɨ gat ae Saion Kabap iyɨ but dasi galak taŋ ɨmɨsak uŋun baŋ manjɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Yutni telagɨ uŋun kabapmon agɨt. Kwen kundu wasagɨt, ae mɨktɨm wasagɨt da tebai tomal, uŋudeŋ yutni aŋteban aban tebaisi toktogɨsi tokdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Piŋkop da oman amɨni Dewit manjɨŋek sipsip kɨla agɨron naŋ abɨdagɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Sipsip kɨla agɨron naŋ abɨdaŋek yɨpban amɨn kabɨni Jekop dakon kɨla amɨni dagagɨt. Piŋkop iyɨ dakon amɨn kabɨni Israel kɨla agɨt. ");
INSERT INTO yut_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Dewit but dasi nandaŋek kɨlani tagɨsi agɨt. Aŋek tagɨsi tɨmɨk paŋkɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Asap dakon kap kɨnda. Piŋkop, Amɨn Ŋwakŋwarɨ Kabɨ gak da mɨktɨmon kɨlɨ abeŋ da mɨŋat amɨn kabɨgo nin gat emat aŋ. Yutgo telagɨ uŋun aŋupbal aba telagɨ dɨma tagɨt. Aŋek Jerusalem obɨsi aŋupbal awit. ");
INSERT INTO yut_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Telagɨ oman amɨngo dapmaŋek bumjotni yo ɨsalɨ yaŋ nandaŋek yum pɨndagakwa sɨŋgɨŋ gat ae joŋ pɨŋan gat da gɨptɨmni noŋ. ");
INSERT INTO yut_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Mɨŋat amɨngo dapmaŋakwa yawi da tagal kɨŋek Jerusalem pak pukwaŋ. Ae bumjotni wayɨtni amɨn kɨnda dɨma egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Mɨktɨm nin da kapmatjok toŋ uŋun dakon amɨn da yaŋsul aŋ nimaŋ. Mɨktɨm morap nin paŋgwasɨŋek taŋ aŋaŋ kwaŋ uŋun da yaŋsul madepsi aŋ nimɨŋek gen mayagɨsi yaŋ nimaŋ. ");
INSERT INTO yut_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Yawe, bɨsap niaŋ da butjap nandaŋ nibi? Gak toktogɨsi butjap nandaŋ nimdɨsal bo? Gepmaŋ dekgɨmaŋ do butjapgo kɨndap da yaŋ soŋek dɨma kɨmotdɨsak, ma? ");
INSERT INTO yut_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Gak mɨŋat amɨn kabɨ dɨma gawak gamaŋ ae mango yaŋek bɨsit dɨma aŋ amɨn uŋun do butjap nandaki. ");
INSERT INTO yut_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Uŋun amɨn kabɨ da mɨŋat amɨn kabɨgo Jekop dapba kɨmakgwit, aŋek mɨktɨmni obɨsi aŋupbal awit. ");
INSERT INTO yut_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Babɨknin da aŋpak yokwi awit uŋun do yo yokwi dɨma aŋ nibi. Abɨsok nin yokwisi ekwamaŋ do bupmɨ nandaŋ nimɨŋek tepmɨsi paŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Piŋkop, gak yokwikon baŋ tɨmɨt tɨmɨt Piŋkopnin. Man madepgo do nandaŋek nin paŋpulugaŋek dɨwarɨnin wɨrɨrɨkgi. ");
INSERT INTO yut_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Amɨn Ŋwakŋwarɨ Kabɨ da nin do yaŋ yoŋ, “Piŋkopni dukon egɨsak?” Uŋun tagɨ dɨma. Uwal da oman amɨngo dapba kɨmakgwit, do yawinin dakon kobogɨ do gak da Amɨn Ŋwakŋwarɨ Kabɨ yo yokwisi aŋ yomɨŋaki gandak do nandamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Dam tebanon ekwaŋ amɨn dakon kunamni nandaki. Aŋek tapmɨm madepgokon da uwal da amɨn dapba kɨmotni dosi kɨlɨ yawit, uŋun yokwikon baŋ tɨmɨkgi dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Uwal nin da kapmatjok ekwaŋ uŋun da gak do gen yokwisi yawit, do Amɨn Tagɨ aŋpak yokwini dakon kobogɨ yomɨŋaki kosirɨ 7 yaŋ asak. ");
INSERT INTO yut_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Yaŋ aŋaki mɨŋat amɨn kabɨgo, sipsip kabɨgo, nin toktogɨsi ya yaŋ gayɨneŋ. Ae babɨknin don altoni uŋun kɨsi da mango aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Asap dakon kap kɨnda. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban “Saŋbek saŋbek dakon jareŋ tagɨsi” uŋun tegon da yoni. Israel dakon Sipsip Kɨla Amɨn, gak Josep dakon amɨn kabɨ sipsip baŋ yaŋ kosit yolɨsal. Bɨsitnin nandaŋ nibi. Aŋelo madep serabim bamot da binapmon kɨla amɨn madep yɨgek tɨlɨmgo mɨŋat amɨn kabɨgo do yolɨŋbɨ pɨndatni. ");
INSERT INTO yut_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Epraim ae Benjamin ae Manase da bɨkbɨgon tapmɨm madepgo nolɨki. Abɨŋ nin yokwikon baŋ tɨmɨkgi. ");
INSERT INTO yut_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Piŋkop, kalɨp egɨp egɨp tagɨsi egɨpgumaŋ uŋun aego aŋkaluk abi. Butgo ninon yɨpmaŋek yo tagɨsi aŋ nibi. Aŋek yokwikon baŋ pulugaŋ nipbi. ");
INSERT INTO yut_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Yawe Piŋkop Tapmɨm Ami, mɨŋat amɨn kabɨgo bɨsit gayɨŋakwa bɨsap niaŋ da butjap nandaŋ yobi? ");
INSERT INTO yut_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Butjap nandaŋ nimaŋaki kunam tagapno dabɨl pakbinin da jap pakbiyonin asak. ");
INSERT INTO yut_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Gak da yum pɨndagaki amɨn kabɨ nin da ɨleŋon ekwaŋ uŋun da abɨŋ nin dakon mɨktɨm abɨdok do emat aŋ. Uwalnin da yaŋsul aŋ nimɨŋek yanjaŋ nimaŋ. ");
INSERT INTO yut_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Piŋkop Tapmɨm Ami, kalɨp egɨp egɨp tagɨsi egɨpgumaŋ uŋun aego aŋkaluk abi. Butgo ninon yɨpmaŋek yo tagɨsi aŋ nibi. Aŋek yokwikon baŋ pulugaŋ nipbi. ");
INSERT INTO yut_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Kalɨpsigwan gak wain nap kɨnda Isip mɨktɨmon naŋ aŋapgul. Aŋek on mɨktɨmon amɨn kabɨ yolbɨ kɨŋakwa wain nap uŋun kwaokgɨl. ");
INSERT INTO yut_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Mɨktɨm uŋun garam aŋek kwaokbɨ kwaŋek gelɨ dubagɨsi pɨgɨwit. Pɨgakwa madepsi kwaŋek mɨktɨm kɨsi ɨlɨmɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Aŋek kabap aŋyoŋgam aŋek uŋun dakon kɨlɨŋɨ da sida kɨndap madepsi uŋun kɨsi wɨtjɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Uŋun dakon kɨlɨŋɨ da tap madep Mediterenian da arɨpmon kɨwit. Ae terɨ kɨnda do gɨgɨ da kwaŋek pakbi madep Yupretis da arɨpmon kɨwit. ");
INSERT INTO yut_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Gak mibɨlɨ nido wain pi dakon dam tuwɨlgɨl? Yaŋ agɨl do amɨn da kɨŋ ap aŋek bamɨ paŋ. ");
INSERT INTO yut_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Joŋ bɨt da abɨŋ paŋupbal aŋ, ae joŋ kɨlap da noŋ. ");
INSERT INTO yut_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Piŋkop Tapmɨm Ami, ninon tobɨl apbi. Kwen Kokupmon da ninon sɨŋtaŋbɨ pɨŋakwan wain pi do kɨlani abi. ");
INSERT INTO yut_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Gak da gaga da tapmɨmon nin kwaokgɨl, do abɨsok abɨŋ nin paŋpulugoki. Nin wain nap bulagɨ yombem baŋ gak da paŋteban abɨ tebaisi awit. ");
INSERT INTO yut_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Uwalnin da mandaŋ kɨndapmon kɨlɨ sowit, do gak da butjap nandaŋ yomɨŋek paŋupbal aki. ");
INSERT INTO yut_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Mani, mɨŋat amɨnyo nin gaga do manjɨgɨl, ae gak da abɨ madepsi tagaŋek teban tagɨmaŋ, do paŋpulugaŋek kɨlanin aki. ");
INSERT INTO yut_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Yaŋ aki kaŋ, nin gak dɨma gepmaŋ detneŋ. Gak da paŋpulugaŋbɨ tagɨ egek bɨsit aŋ gamɨŋek mango awɨgɨneŋ. ");
INSERT INTO yut_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Yawe Piŋkop Tapmɨm Ami, kalɨp egɨp egɨp tagɨsi egɨpgumaŋ uŋun aego aŋkaluk abi. Butgo ninon yɨpmaŋek yo tagɨsi aŋ nibi. Aŋek yokwikon baŋ pulugaŋ nipbi. ");
INSERT INTO yut_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Asap dakon kap kɨnda. Kokup pap Gat dakon gita tɨdaŋek yogogɨ. Piŋkop paŋpulugoknin do kɨsɨk kɨsɨk kap kɨnda yoneŋ. Jekop dakon Piŋkop do kɨsɨk kɨsɨk kap yoneŋ. ");
INSERT INTO yut_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Kap yoni. Tambarin tɨdaŋek, gita gat ae kulele gat kɨsi tɨdoni. ");
INSERT INTO yut_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Kanek kaluk abɨsak bɨsapmon kweŋ pɨsoni. Kanek binap taŋakwan Piŋkop gawak ɨmɨm bɨsap madepmon kweŋ pɨsoni. ");
INSERT INTO yut_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Yaŋ aneŋ do Jekop dakon Piŋkop da Israel amɨn nin do gen teban uŋun nimgut. ");
INSERT INTO yut_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Kalɨpsi Isip amɨn pabɨŋ yopgut bɨsapmon, Piŋkop da gen teban uŋun Israel amɨn nin do nimgut. ");
INSERT INTO yut_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Nak amɨn kɨnda tekni dɨma nandɨsat uŋun da gen yaŋban nandɨsat. Uŋun da yaŋ yosok, “Nak yo jɨgɨ morap ji da kwapmon tawit uŋun kukwaŋ yopgum. Ae mɨktɨm sɨmɨl gok paŋpulugoko mibɨlɨkon yopba taŋakwa pi teban saŋbeŋek dɨma awit. ");
INSERT INTO yut_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Jɨgɨkon egek bɨsit nayɨŋba pulugaŋ depgum. Gɨkwem kɨrɨrɨŋ yosok uŋungwan da bɨsitji nandagɨm. Nak Meriba pakbikon nandaŋ gadatji pɨndat do aŋek ji paŋkewalgɨm. ");
INSERT INTO yut_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","“Nak dakon amɨn kabɨno, nawa dayɨko nandabɨt. Israel amɨn, nak dakon gen nandaŋek guramɨtni do madepsi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Ji mɨktɨm ŋwakŋwarɨ dakon kokup kɨdatni dɨma yolni, ae dɨma gawak yomni. ");
INSERT INTO yut_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Nak kaloŋgɨn ji dakon Yawe ae Piŋkopji egɨsat. Nak naga Isip mɨktɨmon baŋ ji tɨmɨk paŋopgum. Gen kagasi aŋtaŋ kɨŋakwa upmokgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","“Mani babɨkji da nak dakon gen nandak do dɨma galak tawit. Asisi, Israel amɨn nak dakon gen guramɨt do dɨma galak tawit. ");
INSERT INTO yut_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Do yum pɨndagapbo kwen wɨgɨk aŋpakni yolek galak toknikon yo awit. ");
INSERT INTO yut_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","“Nak mɨŋat amɨno da geno guramɨk kɨmotni dosi nandɨsat. Ae Israel amɨn nak dakon galaktok yol kɨmotni do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Yaŋ ani kaŋ, nak da uwalni tepmɨsi pabɨŋ yopdɨsat. Aŋek uwal gat emat wamaŋek pabɨŋ yopbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Aŋapbo mɨŋat amɨnyo nak do nandaba yokwi tok aŋ, uŋun madepsi pasal nɨmnɨmɨk namni. Aŋakwa toktogɨsi yo yokwisi aŋ yobeŋ. ");
INSERT INTO yut_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Mani nak da ji do bret galagɨsi, ae kabaŋ kok koron nani dabeŋ, aŋapbo butji tugokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Asap dakon kap kɨnda. Piŋkop uŋun Kwen Kokup muwut muwut madep dakon mibɨltok amɨn yɨkdak. Mɨktɨm morap dakon kɨla amɨn da muwugakwa nandak nandakni kokwinɨkdak. ");
INSERT INTO yut_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Aŋek yaŋ yoyɨsak, “Ji bɨsap niaŋ da gen kokwin pi gulusuŋ ani? Ji yokwi pakpak amɨn nido paŋpulugoŋ? ");
INSERT INTO yut_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Ji yoni mɨni amɨn ae monjɨ datni kɨmakbi paŋpulugoni. Aŋek jɨgɨ paŋek yokwi ekwaŋ amɨn uŋun paŋkutnoni. ");
INSERT INTO yut_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Amɨn yokwi ekwaŋ ae yo do wadaŋ amɨn uŋun yokwi pakpak da kɨsiron baŋ pulugaŋ tɨmɨgek paŋpulugoni. ");
INSERT INTO yut_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Ji pɨlɨn tukgwan agek nandak nandakji mɨnisi, do mɨktɨmɨ mɨktɨmɨ amɨn aŋpak kɨlegɨ dɨma aŋ. ");
INSERT INTO yut_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Nak gen yaŋ yosot, ‘Ji piŋkop ekwaŋ. Ji Piŋkop Wukwi Madep dakon monjini ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Mani amɨn morap kɨmokgoŋ jiyo yaŋ gɨn kɨmotdaŋ. Kɨla amɨn morap kɨmokgoŋ jiyo yaŋ gɨn kɨmotdaŋ.’ ” ");
INSERT INTO yut_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Piŋkop, mɨŋat amɨn morapyo uŋun gak dakon gɨn, do abɨŋ mɨktɨm amɨn morap gen kokwin aŋyobi. ");
INSERT INTO yut_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Asap dakon kap kɨnda. Kap on Piŋkop gawak ɨmɨm dakon kap. Piŋkop, gak gen mapmɨt dɨma abi. Gak ɨsal dɨma yɨkgi. Piŋkop, gak ɨsal dɨma egɨpbi. ");
INSERT INTO yut_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Pɨndakgi. Uwalgo emat wasaŋek aŋ. Gak do nandaba yokwi tok aŋ amɨn kwen wɨgɨk aŋgamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Uŋun pasɨlɨ egek mɨŋat amɨngo yokwi aŋ yom do gen yaŋ paŋteban aŋ. Gak da mɨŋat amɨngo uŋun kɨlani tagɨsi asal, mani uwal uŋun paŋupbal ak do muwugek gen yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Uŋun da yaŋ yoŋ, “Kɨlɨ kɨno! Israel amɨn dapno pasɨl mudaŋakwa, amɨn da saŋbeŋek dɨma nandaŋ yomni.” ");
INSERT INTO yut_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Piŋkop, uŋun amɨn gak abɨŋ gep do but kaloŋ aŋ. ");
INSERT INTO yut_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Idom amɨn, ae Ismael amɨn, ae Moap amɨn, ae Akri amɨn, ");
INSERT INTO yut_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","ae Gebal amɨn, ae Amon amɨn, ae Amelek amɨn, ae Pilistia amɨn ae Tair amɨn, uŋun mɨktɨm morap dakon amɨn da yo uŋun ak do nandaŋ. ");
INSERT INTO yut_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Siria yo kɨsi uŋun gat muwukgaŋ. Uŋun amɨn tapmɨmɨ toŋ kabɨ uŋun Lot dakon babɨni kabɨ paŋpulugoŋ. ");
INSERT INTO yut_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Uŋun amɨn kabɨ da gak aŋupbal ak do but kaloŋ aŋ, do kalɨp Midian amɨn do agɨl, bo pakbi madep Kison uŋudon Sisera amɨn gat Jabin amɨn gat do agɨl yaŋ gɨn uŋun amɨn paŋupbal abi. ");
INSERT INTO yut_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Uŋun bɨsapmon gak da kokup pap Endo uŋudon paŋupbal abɨ bumjotni mɨktɨmon taŋek mɨktawit. ");
INSERT INTO yut_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Kalɨp kɨla amɨn bamot Orep gat ae Sep garon agɨl uŋudeŋ gɨn emat amɨni dakon mibɨltok amɨni paŋupbal aki. Kɨla amɨn madep bamot Seba gat ae Salmuna garon agɨl uŋudeŋ gɨn kɨla amɨni pabɨŋ yopbi. ");
INSERT INTO yut_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Uŋun amɨn da yaŋ yawit, “Piŋkop dakon sipsip upmot mɨktɨmni nin do aŋawatneŋ.” ");
INSERT INTO yut_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Piŋkopno, mɨktɨmon kɨmbabaŋ baŋ yaŋ uwalgo wɨrɨrɨkbɨ kɨni. Mɨrɨm da wit dakon gɨpmɨ pɨsoŋba kwaŋ uŋudeŋ wɨrɨrɨkbɨ kɨni. ");
INSERT INTO yut_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Kɨndap da koron sosoŋ, ae ɨleŋ gurɨgɨ toŋ da madepsi sosoŋ, ");
INSERT INTO yut_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","yaŋ gɨn gak da sɨkak mal kɨrɨrɨŋyo madepsi yɨpbɨ abɨŋek uŋun amɨn kabɨ yolban pasal kɨni. Ae uŋun da pasolni do mɨrɨm madepsi yɨpbɨ kɨsak. ");
INSERT INTO yut_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Yawe, pabɨŋ yopmaŋaki mayaktok madepsi pani. Aŋek gak tapmɨmgo madepsi yaŋ yokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Pabɨŋ yopmaŋaki toktogɨsi pasal kɨmotni do nandɨsat. Paŋmayak aŋek dapbɨ kɨmotni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Yaŋ aŋaki uŋun da gak kaloŋgɨn Yawe ae Piŋkop Wukwisi egek mɨktɨm morap kɨsi kɨla asal yaŋ nandaŋ gamni. ");
INSERT INTO yut_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Kora amɨn kabɨ dakon kap kɨnda. Kokup pap Gat dakon gita tɨdaŋek yogogɨ. Piŋkop Tapmɨm Ami, gak dakon yut tɨlɨmɨ toŋ galagɨsi. ");
INSERT INTO yut_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Nak uŋudon egɨp do but dasi madepsi galak tosot. Galak tok morapno kɨsi gak dakon yut do tosok. Gɨptɨm ae nandak nandakno kɨsi da Piŋkop egɨp egɨpmɨ toŋ gak do kɨsɨk kɨsɨk kap yosot. ");
INSERT INTO yut_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Yawe Tapmɨm Ami, gak Kɨla Amɨn Madepno ae Piŋkopno. Bibagap ae bibagap gɨman da gak dakon alta da kapmatjok yutni aŋek pudɨgɨ kɨla amal. ");
INSERT INTO yut_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Mɨŋat amɨnyo gak da yutnon ekwaŋ uŋun kɨsɨk kɨsɨk aŋek bɨsapmɨ bɨsapmɨ mango awɨgɨk do kap yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Mɨŋat amɨnyo gak dakon tapmɨm tɨmɨgek Saion Kabapmon wɨgɨk do but dasi galak toŋ, uŋun kɨsɨk kɨsɨk tagɨ ani. ");
INSERT INTO yut_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Mɨktɨm kɨnda mani Mɨktɨm Kunam Pakbi Kulduk Gɨbaŋ, uŋudon kɨŋakwa uŋun mɨktɨmon pakbi gapma morapmɨ noman toŋ. Aŋakwa sɨkak maŋakwa pakbi gapmakon wɨŋoŋ. ");
INSERT INTO yut_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Uŋun amɨn kosit agek tapmɨm kaluk sigɨn paŋ. Uŋun Saion kɨŋ Piŋkop da ɨŋamon altokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Piŋkop Yawe Tapmɨm Ami, bɨsitno nandaki. Jekop dakon Piŋkop, mɨrak pak yaŋsi yopmaŋek geno nandaki. ");
INSERT INTO yut_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Nin dakon kɨla amɨn madep do koki. Pasɨknin da yaŋ nin dam aŋek kɨlanin tagɨsi asak. Yawe, gaga kɨla amɨn madep egɨpjak do manjɨgɨl, do yo tagɨsi aŋ ɨbi. ");
INSERT INTO yut_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Nak gɨldat kaloŋ kɨndagɨn gak dakon yut da yomakon egɨpbeŋ kaŋ, uŋun da tagɨsisi asak. Uŋun da gɨldat 1 tausen tɨmɨ dukon egɨ egɨ asat uŋun yapmaŋ mudosok. Nak oman amɨn pɨŋbisi egek Piŋkopno dakon yoma kagakon yoma kɨla agak amɨni egɨp do but dasi galak taŋ kɨmokdot. Mani amɨn yokwi da yutnon egɨp do dɨma galak tosot. ");
INSERT INTO yut_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Nido Yawe uŋun paŋkutnok amɨnin ae teŋteŋɨnin. Uŋun da nin do yo tagɨsi aŋ nimɨŋek man madep nimɨsak. Kɨlegɨ akwaŋ amɨn do yo tagɨ yom do dɨma paŋkutnosok. ");
INSERT INTO yut_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Yawe Tapmɨm Ami, mɨŋat amɨnyo gak nandaŋ gadaŋ gamaŋ amɨn uŋun kɨsɨk kɨsɨk tagɨ ani. ");
INSERT INTO yut_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Kap on Kora amɨn kabɨ dakon kap. Kap yoŋ amɨn dakon kɨla amɨn do mandabi. Yawe, gak da mɨktɨmgo ae amɨn kabɨgo Jekop nin paŋpulugaŋaki kalɨp tagɨsi egɨpgumaŋ abɨsokyo kɨsi yaŋ gɨn aŋaki tagɨsi ekwamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Amɨn kabɨgo nin yokwi morap agɨmaŋ dakon dɨwarɨnin uŋun wɨrɨrɨk nimgul. ");
INSERT INTO yut_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Gak kalɨp nin do butjap nandagɨl uŋun nandabɨ magɨt. Nin do japmɨsi nandagɨl, mani kulabɨk aŋek butgo magɨt. ");
INSERT INTO yut_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Piŋkop, yokwikon baŋ tɨmɨt tɨmɨt amɨnin, kalɨpsi nin tagɨsi egɨpgumaŋ abɨsok paŋkaluk abɨ yaŋgɨn egɨpneŋ. Butjap saŋbeŋek dɨma nandaŋ nibi. ");
INSERT INTO yut_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Bɨsap mudok mudogɨ mɨni butjap sigɨn nandaŋ nimɨŋ wɨgɨkdɨsal? Babɨkon da babɨkon yaŋ gɨn taŋ aŋaŋ wɨgɨkdɨsak? ");
INSERT INTO yut_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Mɨŋat amɨn kabɨyogo aego paŋteban abɨ nin kɨsɨk kɨsɨk aŋek gak aŋkɨsineŋ. ");
INSERT INTO yut_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Yawe, gak asisi mudok mudogɨ mɨni nin do but dasi galak taŋ nimɨsal uŋun dakon bamɨ nolɨŋbɨ koneŋ. Yokwikon baŋ tɨmɨgaki tagɨsi egɨpneŋ. ");
INSERT INTO yut_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Nak Piŋkop Yawe da gen yosok uŋun do mɨrak pakyaŋsi yopmaŋdat. Nin da aŋpak yokwi kalɨp agɨmaŋon tobɨl dɨma pɨgɨneŋ kaŋ, uŋun iyɨ dakon telagɨ amɨn kabɨni nin but yawot nim do yosok. ");
INSERT INTO yut_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Asisi, amɨn Piŋkop do pasal ɨmaŋ uŋun yokwikon baŋ tɨmɨtdɨsak. Aŋakwan tɨlɨmni mɨktɨmninon tokdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Uŋun bɨsapmon amɨn da amɨn do but dasi galak taŋ yomɨŋek aŋpak tagɨsi aŋ yomdaŋ. Yaŋ aŋek kɨlegɨsi egek but yaworon da tagɨsi egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Mɨktɨmon Piŋkop but dasi yolyol aŋpak mɨktɨmgwan da pawɨŋban pɨsaŋek kwokdɨsak. Ae Kwen Kokup da aŋpak kɨlegɨ sɨŋtaŋban mɨktɨmon pɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Asisi, Yawe da yo tagɨsi nimɨŋakwan mɨktɨmnin da jap morapmɨsi paŋalon akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Yawe apjak dakon kosit yul ɨm do kaŋ, amɨn da aŋpak kɨlegɨ aba kaŋek uŋudon tagɨ apjak. ");
INSERT INTO yut_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Dewit dakon bɨsit kɨnda. Yawe, nak wadak wadak amɨn, do bɨsitno nandaŋek aŋpulugoki do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Yokwikon naŋ abɨdaŋaki dɨma kɨmokgeŋ, nido nak gak naŋ goldat. Nak oman amɨngo, gak naŋ nandaŋ gadaŋ gamɨsat, do aŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Amɨn Tagɨno, nak gɨldat kɨnda kaloŋ gak do bɨsit asat, do nak do bupmɨ nandaŋ nabi. ");
INSERT INTO yut_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Amɨn Tagɨ, nak gak dogɨn bɨsit asat, do oman amɨngo nak do kɨsɨk kɨsɨk nabi. ");
INSERT INTO yut_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Amɨn Tagɨ, gak tagɨsisi, dɨwarɨnin wɨrɨrɨk nimɨsal. Gak mɨŋat amɨnyo bɨsit gayaŋ uŋun but dasi galak taŋ yomɨsal. ");
INSERT INTO yut_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Yawe, gak bɨsitno do mɨrak pakyaŋsi yopbi. Nak do bupmɨ nandaŋ nabi do yaŋ tɨdosot. Yaŋ ɨlɨtno nandaki. ");
INSERT INTO yut_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Nak gak do yaŋ tɨdosot bɨsapmon aŋpulugosol, do jɨgɨ pakeŋ bɨsapmon gak do bɨsit abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Amɨn Tagɨ, piŋkop gak yombem dɨ mɨni. Gak da kɨsi morap yapmaŋdal. Ae amɨn kɨnda da wasok tapmɨmɨ toŋ asal uŋudeŋ kɨnda arɨpmɨ dɨma asak. ");
INSERT INTO yut_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Amɨn Tagɨ, mɨŋat amɨn kabɨ morap gak da wasagɨl, uŋun da abɨŋ ŋwakbeŋ aŋ gamɨŋek gak dakon man awɨgɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Nido, gak kaloŋgɨn tapmɨmgo madep ae gak dagɨn yo masɨ masɨmɨsi asal. Gak kaloŋgɨn Piŋkop bamɨsi. ");
INSERT INTO yut_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Yawe kositgo kɨlegɨ do nayɨŋ dekbɨ gengo bamɨsi yolek egɨpbeŋ. Nayɨŋ dekbɨ gak dogɨn nandaŋ egek mango awɨgɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Amɨn Tagɨ Piŋkopno, nak but dasi gak aŋkɨsikeŋ. Toktogɨsi mango aŋkɨsiŋ wɨgɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Nido gak nak do madepsi but dasi galak taŋ namɨsal. Kɨmoron naŋ pulugaŋ nepbɨ gapmagwan dɨma pɨgɨgɨm. ");
INSERT INTO yut_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Piŋkop, kwen wɨgɨk amɨn da nak nɨt do abaŋ. Uŋun amɨn yokwi bupmɨni mɨni da nak nɨkba kɨmokgeŋ do abɨŋ muwukgaŋ. Uŋun manji gamɨŋek gengo dɨma guramɨkgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Mani Amɨn Tagɨ, gagon bupmɨ ae nandaŋ yawotyo tugagɨt da tosok. Gak butjap tepmɨ dɨma nandɨsal. Gak nin do but dasi galak taŋ nimɨŋek gengo aŋteban aŋek nin paŋpulugaŋ wɨgɨsal. ");
INSERT INTO yut_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Tobɨl nagon abɨŋek bupmɨ nandaŋ nabi. Meŋno da kalɨp gak dakon pi agɨt, abɨsok monji nakyo kɨsi pigo asat, do nak dakon but aŋteban aŋek yokwikon naŋ pulugaŋ nepbi. ");
INSERT INTO yut_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Yawe, gak da nak do but dasi galak taŋ namɨsal uŋun dakon tɨlak kɨnda nolɨŋbɨ kokeŋ. Yaŋ aŋaki uwalno da gak da nak aŋpulugaŋek aŋteban asal uŋun kaŋ nandaŋyo aŋek aŋpak yokwini dakon mayagɨ pani. ");
INSERT INTO yut_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Kora amɨn kabɨ dakon kap kɨnda. Kap on Piŋkop gawak ɨmɨm dakon kap. Piŋkop da kokup papni telagɨ kabapmon agɨt. ");
INSERT INTO yut_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Yawe da Israel mɨktɨm dakon kokup morap do galak tosok, mani Jerusalem do madepsi but dasi galak tosok. ");
INSERT INTO yut_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Piŋkop dakon kokup pap dakon mɨŋat amɨnyo, ji nandani, Piŋkop da yo tɨlɨmɨ toŋ tagɨsi jikon asak. ");
INSERT INTO yut_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Piŋkop da yaŋ yosok, “Namɨn amɨn da nak dakon gen guramɨkdak, uŋun manjɨkeŋ bɨsapmon, Isip ae Babilon kɨsi manjɨkeŋ. Aŋek Pilistia, Tair ae Itopia do yaŋ yokdɨsat, ‘Uŋun yo kɨsi Jerusalem amɨn gɨn.’ ");
INSERT INTO yut_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","“Nak Jerusalem do yaŋ yokdɨsat, ‘Uŋun mɨŋat amɨn morap kɨsi dakon kokup pap.’ ” Ae Piŋkop Wukwisi da Jerusalem aŋpulugaŋban tebaisi tokdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Yawe da amɨn dɨwarɨ dakon man mandakdɨsak. Aŋek paŋmuwugek Jerusalem mɨŋat amɨnyo gat kɨsi manjɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Aŋakwan mɨŋat amɨnyo uŋun kap yaŋek kɨsɨk kɨsɨk aŋek yaŋ yokdaŋ, “Jerusalem, gak yo tagɨsi morap ninon toŋ uŋun dakon mibɨlɨsi.” ");
INSERT INTO yut_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Eman uŋun Sera kabɨkon nani kɨnda da kap on mandagɨt. Kap on do Maskil yaŋ yoŋ. Kora amɨn kabɨ da Piŋkop gawak ɨmɨŋek kap on yoŋ. Kap yoŋ amɨn dakon kɨla amɨn da mɨŋat amɨnyo yoyɨŋban “Malat Leanot” uŋun tegon da yoni. Piŋkop, Yawe, gak paŋpulugokno. Gɨldarɨ ae kalbi gak do yaŋ tɨdosot. ");
INSERT INTO yut_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Bɨsitno nandaki. Aŋpulugoki do yaŋ tɨdosot, ");
INSERT INTO yut_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","nido jɨgɨ morapmɨ nagon noman taŋ namɨŋakwa palɨ kɨmokdot. ");
INSERT INTO yut_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Amɨn dɨwarɨ da si kɨmot do aŋ, nak uŋun yombem. Tapmɨmno kɨsisi mudaŋ. ");
INSERT INTO yut_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Nepmaŋ degakwa amɨn kɨlɨ kɨmakgwit gat kɨsi ekwamaŋ. Amɨn da amɨn kɨnda aŋakba kɨlɨ kɨmakgɨt da kɨmakbi tamokon tosok, nak uŋun yombem. Amɨn wagɨlsi ɨŋtaŋ yomɨŋek saŋbeŋek dɨma paŋpulugokdɨsal uŋun yombem. ");
INSERT INTO yut_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Mabɨ gapma dubagɨsi kɨdagɨsikon kɨlɨ pɨgɨgɨm, da pɨlɨn tuksigwan egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Butjapgo da obɨsi abɨŋ nepgut. Tap ɨdap da yaŋ tamalɨgek wutjɨŋban tagɨm. ");
INSERT INTO yut_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Gak da yopbɨ notnoni da manji namgwit. Gak da nepbɨ nak amɨn yokwisi dagaŋapbo madepsi pasal namaŋ. Uŋun da tebai abɨdaŋakwa arɨpmɨ dɨma pulugaŋ kɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Nak jɨgɨ paŋapbo dabɨlno yokwi taŋakwan tagɨ dɨma sɨŋtosot. Ae gɨldarɨ gɨldarɨ kɨsitno paŋenagek gak da aŋpulugoki do bɨsit asat. ");
INSERT INTO yut_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Gak wasok tapmɨmɨ toŋ amɨn kɨmakbi paŋpulugok do aŋek asal, ma? Amɨn kɨlɨ kɨmakgwit da pɨdaŋek mango awɨkwaŋ, ma? ");
INSERT INTO yut_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Ae kɨmakbi tamokon kɨlɨ pakgwit kabɨ da gak da but dasi galak taŋ nimɨsal yaŋ dɨ yoŋ bo dɨma? Si tasɨk togɨ tamokon da gak da kɨlanin tagɨsi asal yaŋ dɨ yoŋ bo dɨma? ");
INSERT INTO yut_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Pɨlɨn tuk tamogwan ekwaŋ amɨn da wasokgo tapmɨmɨ toŋ uŋun dɨ pɨndakgaŋ? Amɨn gak da kɨlɨ ɨŋtaŋ yomgul tamokon ekwaŋ uŋun da aŋpakgo kɨlegɨ dɨ pɨndakgaŋ? Uŋun dɨmasi! ");
INSERT INTO yut_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Yawe, nak gak da aŋpulugoki do yaŋ tɨdosot. Nak wɨsa dagokdo morap gak do bɨsit asat. ");
INSERT INTO yut_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Mani Yawe, nido manji namɨsal? Nido pasɨl namɨsal? ");
INSERT INTO yut_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Monjɨ bulagɨ egɨpgum bɨsapmon da wɨŋ abɨsok egɨsaron, jɨgɨ paŋek kɨlɨ uŋunjok kɨmotdɨsat. Gak da yo yokwisi pasol pasolɨsi aŋ namɨŋaki tapmɨmno mɨni asak. ");
INSERT INTO yut_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Yawe, butjapgo da wutjɨŋ namɨsak. Gak da obɨsi nɨgek obɨsi aŋupbal asal. ");
INSERT INTO yut_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Gɨldat kɨnda kaloŋ nak do yaŋ asal. Pakbi da ɨgek mɨktɨm morap kɨsi wutjɨsak, uŋun da tɨlak amɨn da nak aŋgwaseŋ. ");
INSERT INTO yut_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Gak da abɨ notno tagɨsi nepmaŋ dekgaŋ. Nagon pɨlɨn tuk dagɨn tosok. ");
INSERT INTO yut_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Etan uŋun Esra amɨn kabɨkon nani kɨnda dakon kap. Kap on do Maskil yaŋ yoŋ. Yawe, gak da amɨn do but dasi galak taŋ yomɨsal, uŋun do nak toktogɨsi kap yokeŋ. Gak gengo aŋteban aŋek nin tagɨsi paŋpulugosol uŋun dakon geni babɨkon da babɨkon yaŋ teŋteŋokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Gak toktogɨsi nin do but dasi galak taŋ nimɨsal uŋun dakon geni yaŋ teŋteŋaŋ wɨgɨkeŋ. Gak gengo aŋteban aŋek nin tagɨsi paŋpulugosol. Uŋun aŋpak kundu da tebai tosok uŋudeŋ toktogɨsi tokdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Gak da yaŋ yagɨl, “Naga dakon amɨno manjɨŋek uŋun gat saŋbek saŋbek kɨlɨ agɨm. Oman monjɨno Dewit uŋun do yaŋ teban tok kɨlɨ agɨm. ");
INSERT INTO yut_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Aŋek yaŋ iyɨgɨm, ‘Israel dakon kɨla amɨn madep noman taŋ noman taŋ ani uŋun gak da kabɨkon dagɨn noman tokdaŋ. Babɨkon da babɨkon gak da kabɨkon nani kɨnda da kɨla amɨn madep yɨyɨt tamokon yɨtdɨsak.’ ” ");
INSERT INTO yut_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Yawe, Kwen Kokup aŋelo gak da yo tagɨsi agɨl uŋun do kap yaŋek mango awɨkwaŋ. Gak da gengo guramɨkdal uŋun do nandaŋek kap yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Nido Kwen Kokupmon Yawe gak yombem kɨnda mɨni. Aŋelo kɨnda gak yombem mɨni. ");
INSERT INTO yut_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Aŋelo dakon kɨla amɨn da muwukgaŋon Piŋkop do si pasolgoŋ. Uŋun aŋelo kabɨ aŋgwasɨŋek akgaŋ uŋun masɨ masɨmɨ, mani Piŋkop da uŋun kabɨ si yapmaŋek wagɨl masɨ masɨmɨsi. ");
INSERT INTO yut_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Piŋkop Tapmɨm Ami, gagon tapmɨm madep tosok uŋuden amɨn kɨnda mɨni. Toktogɨsi gak kulabɨk dɨma aŋek gengo guramɨk kɨmokdol. ");
INSERT INTO yut_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Gak da tap ɨdap tapmɨmɨ toŋ uŋun kɨla asal. Tap ɨdap si pɨdosok bɨsapmon gak da abɨŋ yɨpmaŋaki wayɨŋ dɨma asak. ");
INSERT INTO yut_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Gak da Isip dakon tapmɨm madepni tuwɨlek obɨsi aŋupbal agɨl. Aŋek tapmɨm madepgokon da uwalgo pabɨŋ yopgul. ");
INSERT INTO yut_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Kundu gat mɨktɨm gat uŋun gak dakon gɨn. Gak da mɨktɨm gat yo morap uŋudon toŋ gat wasagɨl. ");
INSERT INTO yut_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Gak da not tetgɨn dakon mɨktɨm wasagɨl, ae saut tetgɨn dakon mɨktɨm kɨsi wasagɨl. Ɨleŋ Tabor gat ae Ɨleŋ Emon gat gak do kɨsɨk kɨsɨk aŋek kap yaŋ gamamal. ");
INSERT INTO yut_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Yawe, gak tapmɨmgo madepsi. Tapmɨmgo pɨdaŋbisi. ");
INSERT INTO yut_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Gak kɨla amɨn madep egek aŋpak kɨlegɨkon da amɨn kɨlani aŋek gen kokwin pi kɨlegɨsi asal. Gak mɨŋat amɨn do but dasi galak taŋ yomɨŋek gengo aŋteban aŋek tagɨsi paŋpulugosol. ");
INSERT INTO yut_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Amɨn gak gawak gamɨŋek kap yaŋ gamaŋ uŋun kɨsɨk kɨsɨk tagɨ ani. Yawe, amɨn morap gak da ɨŋamon teŋteŋɨgokon akwaŋ uŋun kɨsɨk kɨsɨk tagɨ ani. ");
INSERT INTO yut_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Uŋun amɨn aŋpakgo kɨlegɨ do gɨldat kɨnda kaloŋ uŋun do nandaŋek kɨsɨk kɨsɨk aŋek mango aŋkɨsaŋ. ");
INSERT INTO yut_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Gak kaloŋgɨn teban toknin, ae gak do kɨsɨk kɨsɨk madepsi nandamaŋ. Nin do nandaŋ yawok nimɨŋek paŋpulugaŋaki emaron teban tomaŋ. ");
INSERT INTO yut_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Asisi, Yawe uŋun pasɨknin egɨ nimɨsak. Gak Israel amɨn nin dakon Piŋkop Telagɨsi nin da kɨla amɨn madepnin nimgul. ");
INSERT INTO yut_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Kalɨpsigwan oman amɨn kabɨgo tagɨsi do dɨpmɨn yolɨgɨl, aŋek yaŋ yoyɨgɨl, “Nak da emat amɨn tagɨsi kɨnda kɨlɨ manjɨgɨm. Nak da mɨŋat amɨnyo da binapmon naŋ kɨla amɨn madep egɨpjak do abɨdagɨm. Aŋek kɨla amɨn madep dakon pelɨt kɨnda busuŋɨkon yɨpmaŋ ɨmgum. ");
INSERT INTO yut_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Nak da oman amɨno Dewit kɨlɨ manjɨgɨm, aŋek yɨpbo ji dakon kɨla amɨn madep dagagɨt. ");
INSERT INTO yut_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Nak tapmɨmno yɨpbo uŋun gat toktogɨsi egɨpdamal. Nak dakon tapmɨm da aban teban tokdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Uwalni da emaron arɨpmɨ dɨma abɨŋ yɨpni. Ae amɨn yokwi da arɨpmɨ dɨma abɨŋ yɨpni. ");
INSERT INTO yut_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Nak da uwalni bamaŋ yomdɨsat, aŋek amɨn nandaba yokwi taŋ ɨmni amɨn dapbo kɨmotdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Nak da but dasi galak taŋ ɨmɨŋ kɨmagek uŋun gat toktogɨsi egɨpdɨsat. Uwal gat emat wamni bɨsapmon nak da aŋpulugaŋapbo pabɨŋ yopdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Nak da mɨktɨmni abo tap ɨdap Mediterenian uŋudon da wasaŋek kɨŋ pakbi madep Yupretis da arɨpmon kɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Aŋek Dewit da yaŋ nayɨkdɨsak, ‘Gak Datno ae Piŋkopno. Gak da tɨp tebano egek toktogɨsi aŋpulugosol.’ ");
INSERT INTO yut_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Nak da manjɨko monjɨno mibɨltogɨ dagosak, ae kɨla amɨn madep mibɨltogɨ dagaŋek mɨktɨmon kɨla amɨn madep morap yapmaŋ mudosak. ");
INSERT INTO yut_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Nak toktogɨsi but dasi galak taŋ ɨmɨŋ kɨmotdɨsat. Aŋek uŋun gat saŋbek saŋbek aŋapdo saŋbek saŋbek uŋun toktok teban taŋ wɨgɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Toktogɨsi uŋun da kabɨkon kɨnda da kɨla amɨn madep egɨ egɨ akdɨsak. Kundu da toktogɨsi tosok uŋun da tɨlak, uŋun da kabɨkon kɨla amɨn madep kɨnda da toktogɨsi Israel amɨn kɨla akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","“Mani babɨni kabɨ nawa geno pabɨŋ yopni, ae nak dakon gen dɨma yolni kaŋ, ");
INSERT INTO yut_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","bo ae geno do manji ɨmɨŋek gen tebano dɨma guramɨtni kaŋ, ");
INSERT INTO yut_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","yokwini do nandaŋek baljokdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Mani uŋun bɨsapmon kɨsi nak Dewit but dasi galak taŋ ɨmdɨsat. Aŋek dɨma yɨpmaŋ dekgeŋ, ae uŋun do yaŋ teban tok agɨm uŋun dɨma aŋsuŋ abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Nak uŋun gat saŋbek saŋbek agɨmak dɨma kɨrɨŋɨkgeŋ, ae geno kulabɨk kɨnda dɨma abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Nak Dewit do yaŋ teban tok agɨm. Nak telagɨsi, do top dɨmasi yosot. ");
INSERT INTO yut_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Babɨkni kabɨ toktogɨsi egɨ wugɨkdaŋ. Gɨldat da tosok uŋun da tɨlak uŋun dakon dɨwatni da mɨŋat amɨnyo bɨsap dubagɨ kɨla akdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Kanek da kundukon tosok, uŋun da tɨlak toktogɨsi yaŋ egɨ wɨgɨkdaŋ.” Uwal da kɨla amɨn madep abɨŋ yɨpgwit bɨsapmon kunam takgwit ");
INSERT INTO yut_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Mani abɨsok kɨla amɨn madep manjɨgɨl uŋun do butjap nandaŋ ɨmɨsal. Kɨlɨ yɨpmaŋ dekgɨl, aŋek manji ɨmgul. ");
INSERT INTO yut_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Oman amɨngo gat saŋbek saŋbek agɨmal uŋun paŋdagagɨl. Gak da kɨla amɨn madep pelɨtni mabɨ mɨktɨmon maŋek yo ɨsalɨ agɨt. ");
INSERT INTO yut_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Gak da kokup papni dakon dam kɨlɨ tuwɨlgɨl. Yutni tebaisi uŋun kɨlɨ tasɨk tawit. ");
INSERT INTO yut_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Mɨŋat amɨn morap kapmatjok akwaŋ uŋun da yo kabɨni kabo tɨmɨkgaŋ. Ae amɨn kapmatjok ekwaŋ da yaŋsul aŋ ɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Gak da yum pɨndagaki uwal da emaron abɨŋ yɨpgwit. Yaŋ aŋyomɨŋaki kɨsɨk kɨsɨk awit. ");
INSERT INTO yut_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Gak da abɨ emat amɨni emaron dɨma teban tawit, aŋek emat bɨsapmon dɨma aŋpulugagɨl. ");
INSERT INTO yut_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Gak da abɨŋ yɨpgul da kɨla amɨn madep saŋbeŋek dɨma egɨsak, ae saŋbeŋek mɨŋat amɨnyo kɨla dɨma asak. ");
INSERT INTO yut_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Gak da abɨ amɨn pelaŋ tepmɨsi asak, aŋek mayaktok madepsi da wutjɨŋ ɨmɨsak. ");
INSERT INTO yut_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Yawe, gak bɨsap niaŋ da pasɨldɨsal? Toktogɨsi, ma? Bɨsap niaŋ da butjapgo kɨndap da yaŋ tebai sosak? ");
INSERT INTO yut_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Yawe, nin bɨsap pɨsɨpmɨsok gɨn ekwamaŋ, do nandaŋ nibi. Gak da nin wasagɨl, mani mibɨlɨ mɨni ekwamaŋ da kɨmak mudokdamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Namɨn da toktogɨsi egek arɨpmɨ dɨma kɨmotjak? Namɨn da tebaisi egek kɨmakbi tamokon arɨpmɨ dɨma kɨsak? Amɨn kɨnda mɨnisi. ");
INSERT INTO yut_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Amɨn Tagɨ abɨsok nin dɨma galak taŋ nimɨsal, ma? Dewit gat yaŋ teban tok aŋek nin but dasi galak taŋ nim do yagɨl uŋun niaŋɨ? ");
INSERT INTO yut_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Amɨn Tagɨ, oman amɨngo nak do nandaki. Amɨn da nak do yaŋsul aŋ namaŋ. Amɨn Ŋwakŋwarɨ Kabɨ dakon manji gen yokwini dakon jɨgɨ ɨmekdat. ");
INSERT INTO yut_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Yawe, gak da nak kɨla amɨn madep manjɨgɨl, mani uwal da yaŋsul aŋ namaŋ. Dukwan dukwan morap kɨsat yaŋsul aŋ namaŋ gɨn. ");
INSERT INTO yut_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Nin Yawe dakon man toktogɨsi awɨgɨ kɨmotneŋ. Uŋun asi. ");
INSERT INTO yut_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Kap on Piŋkop dakon pi amɨni Moses dakon bɨsit. Amɨn Tagɨ, gak nin dakon yutsi yombem. Kalɨp babɨknin gagon egɨpgwit, ae abɨsokyo kɨsi, nin yaŋ gɨn gagon ekwamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Kalɨpsigwan ae don kɨsi toktok teban egɨpgul da egɨsal. Kabap morap dɨma noman tawit, ae mɨktɨmon yo morap dɨma wasagɨl, mani gak kɨlɨ egɨpgul. ");
INSERT INTO yut_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Gak da yaŋ yosol, “Mɨŋat amɨnyo ji aesi mɨktɨm dagoni.” Yaŋ yaŋek mɨŋat amɨnyo abɨ kɨmagek ae mɨktɨm dagoŋ. ");
INSERT INTO yut_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Gak da bɨlak 1 tausen uŋun bɨsap pɨsɨpmɨsok gɨldat kaloŋgɨn, apma gɨldat egapno tepmɨ mudak uŋun yombem gɨn yaŋ kosol, ae emat amɨn da kalbi bɨsap pɨsɨpmɨsok kɨla aŋ uŋun da arɨp gɨn. ");
INSERT INTO yut_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Pakbi da ɨgek amɨn tɨmɨk paŋabɨkwa kɨmokgoŋ, uŋudeŋ gak da amɨn abɨ kɨmokgoŋ. Bɨsap pɨsɨpmɨsok ekwaŋ, uŋun dɨpmɨn yombem gɨn pɨndakgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","madep taŋek tɨlɨmni yopmaŋgaŋ, mani pɨlɨndo si kɨbɨdaŋ mudoŋ. ");
INSERT INTO yut_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Gak nin do butjap nandɨsal, do nin paŋupbal asal. Gak nin do butjap nandɨsal, do madepsi pasolgomaŋ. ");
INSERT INTO yut_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Gak da nin dakon yokwi morap kɨsi pɨndak mudosol. Yokwi morap pasɨlɨ amaŋ, uŋun gak da nomansi yopmaŋek pɨndak mudosol. ");
INSERT INTO yut_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Mɨktɨmon egɨpneŋ bɨsap morapmon butjapgo da kagagwan ekwamaŋ. Egɨp egɨpnin mudok do aŋakwan yaŋwɨk aŋek kɨmokgomaŋ. ");
INSERT INTO yut_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Nin bɨlak 70 yaŋ da arɨpmon gɨn ekwamaŋ. Ae tapmɨmnin toni kaŋ, bɨlak 80 da arɨp tagɨ egɨpneŋ. Mani uŋun bɨlak morap ekwamaŋon, nin pi madepsi amaŋ, aŋek jɨgɨ morapmɨ paŋalon amaŋ. Uŋun bɨlak morap tepmɨsi kɨŋ mudaŋakwa nin tepmɨsi pasɨlgamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Namɨn da butjap madepgo dakon tapmɨm uŋun nandɨsak? Butjapgo uŋun madepsi, do amɨn da gak do pasol pasol madepsi nandani kaŋ, uŋun da tagɨ asak. ");
INSERT INTO yut_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Niyɨŋ dekbɨ on mɨktɨmon bɨsap dubagɨ dɨma egɨpdamaŋ yaŋsi nandaneŋ. Yaŋ aki kaŋdo nandaŋ kokwin tagɨsi baŋ paŋek egɨpneŋ. ");
INSERT INTO yut_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Yawe, butjapgo bɨsap niaŋ da sigɨn tosak? Oman amɨngo nin do bupmɨ nandaŋ nibi. ");
INSERT INTO yut_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Wɨsa dagokdo but dasi galak taŋ nimaŋaki butnin kadɨmɨsi tosak. Yaŋ aŋaki mɨktɨmon egɨ aŋaŋ kɨneŋ daman kɨsɨk kɨsɨk kap yaŋek tagɨsi egɨpneŋ. ");
INSERT INTO yut_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Gɨldat niaŋ da jɨgɨ nimgul uŋun da arɨp kɨsɨk kɨsɨk nibi. Ae bɨlak niaŋ da yokwisi egɨpgumaŋ uŋun da arɨp kɨsɨk kɨsɨk nibi. ");
INSERT INTO yut_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Wasok tapmɨmɨ toŋ asal uŋun oman amɨngo nin do nolɨŋbɨ pɨndatneŋ. Ae tɨlɨmgo tagɨsi mɨŋat monjɨyonin do yolɨŋbɨ pɨndatni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Amɨn Tagɨ Piŋkopnin, gɨsamgo ninon tosak do nandamaŋ. Ninon taŋakwan pi morap amaŋ uŋun bamɨ tagɨsi tosak. Asi, paŋteban aŋaki pi amaŋ dakon bamɨ tagɨsi tosak. ");
INSERT INTO yut_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Piŋkop Wukwi Madep gat ekwaŋ amɨn uŋun Piŋkop Tapmɨm Ami da yoŋgamgwan egek yɨk yawot tagɨsi aŋ. ");
INSERT INTO yut_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Nak Yawe do yaŋ yosot, “Gak da dam madepno arɨpmɨ dɨma tuwɨlɨ egek nak tagɨsi aŋkutnosol. Gak Piŋkopno. Egɨp egɨpno gagon tosok yaŋsi nandɨsat.” ");
INSERT INTO yut_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Piŋkop da kɨlago tagɨsi aŋakwan paron dɨma yokwalgi. Ae gak nagal aŋakwan sot teban gagon dɨma noman toni. ");
INSERT INTO yut_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Pup da pudɨgɨ pɨrɨgwan wutjaŋ uŋudeŋ Yawe da tagɨsi aŋkutnosak. Uŋun toktok teban kɨlago aŋek pasɨkgo asak. ");
INSERT INTO yut_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Kalbi binap bo gɨldat kalba yo yokwisi kɨnda da aŋupbal asak yaŋ do pasol pasol dɨma abi. ");
INSERT INTO yut_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Ae sot teban kɨnda da kalbi altaŋ gamjak, bo gɨldat binap yo yokwisi kɨnda da gak aŋupbal asak yaŋ do pasol pasol dɨma abi. ");
INSERT INTO yut_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Amɨn 1 tausen gak da kapmatjok kɨmagakwa ae amɨn 10 tausen amɨn tetgo do kɨmotni kaŋ, uŋun yo yokwi gak da kapmatjok arɨpmɨ dɨma apni. ");
INSERT INTO yut_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Dabɨlgo da si pɨndagaki Piŋkop da amɨn yokwi kobogɨ yokwi yomdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Yawe Wukwi Madep da yoŋgamgwan egɨpbi kaŋ, ");
INSERT INTO yut_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","yo yokwisi gagon arɨpmɨ dɨma noman toni. Ae sot teban gak da yut da kapmatjok arɨpmɨ dɨma apni. ");
INSERT INTO yut_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Kosit morap agɨpbikon Yawe da aŋeloni pi yoban kɨlago akdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Aŋakwa kandapgo tɨpmon tɨdoki yaŋ do gak kɨsit da bedaŋ awɨldaŋ. ");
INSERT INTO yut_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Gak da laion emarɨ yokwi gat ae tuŋon amɨn emarɨ toŋ gat bamaŋ mɨsɨŋɨtdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Yawe da yaŋ yosok, “Amɨn nak do but dasi galak taŋ namaŋ uŋun yokwikon baŋ tɨmɨkgeŋ. Amɨn nak dakon man do nandaŋ teban toŋ uŋun paŋkutnokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Nak do bɨsit aba bɨsitni nandaŋ yobeŋ. Ae jɨgɨ noman taŋ yomni kaŋ, nak uŋun gat egɨpneŋ. Nak da yokwikon baŋ tɨmɨgek man madep yobeŋ. ");
INSERT INTO yut_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Nak da yokwikon baŋ tɨmɨgek egɨp egɨpni saŋbeko dubagɨ aŋakwan tagɨsi nandakdaŋ.” ");
INSERT INTO yut_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Kap on Sabat bɨsapmon Piŋkop gawak ɨmɨŋek yogogɨ. Yawe, gak Piŋkop Wɨkwisi egɨsal. Ya yaŋ yaŋek kap yaŋek mango aŋkɨsineŋ kaŋ uŋun tagɨsi. ");
INSERT INTO yut_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Wɨsa dagok morap gak da nin do but dasi galak taŋ nimɨsal uŋun do yaŋ teŋteŋok aneŋ kaŋ uŋun tagɨsi. Ae kalbi morap bɨsapmɨ bɨsapmɨ paŋpulugaŋek dɨma nipmaŋ dekdal uŋun do yaŋ teŋteŋok aneŋ kaŋ uŋun tagɨsi. ");
INSERT INTO yut_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Gita napmɨ 10 kabɨ dakon ae gita napmɨ morapmɨ toŋ uŋun baŋ tɨdaŋek kɨsɨk kɨsɨk aŋek uŋun dakon yaŋ teŋteŋok aneŋ kaŋ uŋun tagɨsi. ");
INSERT INTO yut_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Yawe, gak yo tagɨsi asal uŋun do nandaŋek butno tagɨsi asak. Kɨsitgo da pi asak uŋun do nandaŋek kɨsɨk kɨsɨk kap yosot. ");
INSERT INTO yut_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Yawe, gak pi tapmɨmɨ toŋsi asal. Nandak nandakgo uŋun ɨlarɨsi. ");
INSERT INTO yut_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","7","Amɨn yokwi joŋ yombem tagɨ kwoŋ, ae yo morapmɨ tɨmɨgek tagɨsi ekwaŋ. Mani gak da wagɨlsi paŋupbal akdɨsal. Amɨn nandak nandakni mɨni ae nandaŋ kokwini tagɨ dɨma amɨn on yo morap do arɨpmɨ dɨma nandaŋ pɨsoni. ");
INSERT INTO yut_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Mani Yawe gaga kɨla amɨn madep toktok teban egɨ wɨgɨsal. ");
INSERT INTO yut_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Yaŋsi nandamaŋ, amɨn gak do uwal aŋ gamaŋ, uŋun kɨmotdaŋ. Yo yokwi aŋ amɨn pabɨŋ yopbɨ bɨrapmɨgɨ dukwan dukwan kɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Mani gak da tapmɨm madep namgul uŋun joŋ bulmakau wɨli dakon tapmɨm yombem. Gak da yo tagɨsi aŋ namɨsal, do but galaksi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Dabɨlno da pɨndagapbo uwalno tasɨk taŋ mudawit. Mɨrakno yopmaŋek uwalno yokwisi dakon kunam wɨwɨk nandagɨm. ");
INSERT INTO yut_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Amɨn kɨlegɨ uŋun silbat da yaŋ madepsi tagaŋek bamɨ tokdaŋ. Sida kɨndap Lebanon mɨktɨmon toŋ uŋun da tɨlak tagokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Amɨn kɨlegɨ uŋun Yawe da yutnon kɨlɨ kwaokbi. Piŋkopnin da yutnon egek madepsi tagoŋ. ");
INSERT INTO yut_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Amɨn pelaŋ aŋek bamɨ sigɨn tokdaŋ. Tagɨsi taŋek tamɨ dɨma bɨrɨpmɨgɨ maŋek kalɨkalɨgɨ sigɨn tokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Aŋek yaŋsi yaŋ teŋteŋokdaŋ, “Yawe uŋun aŋpakni kɨlegɨ gɨn. Uŋun tɨp madepnin egɨsak, ae yokwini kɨnda dɨmasi taŋ ɨmɨsak.” ");
INSERT INTO yut_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Yawe uŋun kɨla amɨn madep egɨsak. Kɨla amɨn madep dakon ɨmal pasak. Asi, kɨla amɨn madep dakon ɨmal pasak, ae tapmɨmni uŋun madepsi. Mɨktɨm daman uŋun wasaŋban tebaisi tosok, arɨpmɨ dɨma puweŋ kɨsak. ");
INSERT INTO yut_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Yawe, gak kɨla amɨn madep yɨtyɨt tamogokon kalɨpsigwan kɨlɨsi yɨkgɨl. Yo morap dɨma noman taŋakwa gak kɨlɨsi egɨpgul. ");
INSERT INTO yut_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Yawe, tap pakbi madep uŋun da madepsi tamalɨkgaŋ. Aŋek wɨwɨk madepsi yaŋek sulukwaŋ, ae ɨleŋɨkon tebaisi tɨdoŋ. ");
INSERT INTO yut_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Mani Yawe, gak dakon tapmɨmgo uŋun pɨdaŋbisi. Tap pakbi madepsi tamalɨkgaŋ uŋun dakon tapmɨm yapmaŋdak, ae ɨleŋɨkon tɨdoŋ uŋun dakon tapmɨm yo kɨsi yapmaŋdak. ");
INSERT INTO yut_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Gak dakon gen tebango uŋun toktogɨsi tokdaŋ. Yawe, gak dakon yut dagok dagogɨ mɨni telagɨsi tokdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Yawe, gak Piŋkop, gak da yokwi pakpak amɨn yokwi aŋ dakon kobogɨ yomɨsal. Do abɨsok butjapgo yolɨŋaki tɨlɨmgo koni. ");
INSERT INTO yut_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Mɨktɨm daman dakon gen kokwin amɨn madep pɨdoki. Abɨsok abɨŋek iyɨ do nandaba wɨgɨsak amɨn dakon aŋpak yokwini do kobogɨ yokwisi yobi. ");
INSERT INTO yut_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Yawe, bɨsap niaŋ da amɨn yokwi da aŋpakni do kɨsɨk kɨsɨk ani? ");
INSERT INTO yut_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Amɨn yokwi da iyɨ do nandaba wɨgakwa aŋpak yokwini aŋ uŋun do pɨbɨt tɨdok aŋ. ");
INSERT INTO yut_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Yawe, mɨŋat amɨn kabɨ gaga do manjɨgɨl, amɨn da pabɨŋ yopmaŋek jɨgɨ madepsi yomaŋ. ");
INSERT INTO yut_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Uŋun da sakwabat gat, ae mɨŋat monjɨyo meŋi datni yopmaŋ kɨmakgwit gat, ae amɨn kokup ŋwakŋwarɨkon da apgwit da mɨktɨmninon ekwaŋ, uŋun dapba kɨmokgoŋ. ");
INSERT INTO yut_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Aŋek yaŋ yoŋ, “Yawe da nin dɨma nindasak. Israel amɨn dakon Piŋkop yo nin da amaŋ uŋun do nandaba kɨk dɨma asak.” ");
INSERT INTO yut_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Nandak nandakji mɨni amɨn, mɨrak yopmaŋek butji pɨsoni! Ji ŋugɨgɨsi. Ni bɨsapmon nandaŋ kokwin tagɨsi amɨn dagoni? ");
INSERT INTO yut_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Piŋkop da mɨraknin wasagɨt, do arɨpmɨ dɨma nandɨsak, ma? Ae dabɨlnin wasagɨt, do iyɨ arɨpmɨ dɨma sɨŋtosak, ma? ");
INSERT INTO yut_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Mɨŋat amɨn kabɨ egɨ aŋ aŋ kwaŋ kobogɨ yokwi yomɨsak, do ji do kobogɨ yokwi arɨpmɨ dɨma damjak, ma? Uŋun mɨŋat amɨn morap kɨsi dakon yoyɨŋdetni. Uŋun nandak nandakni mɨni, ma? ");
INSERT INTO yut_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Yawe da mɨŋat amɨn morap kɨsi dakon nandak nandak kɨlɨ nandaŋ mudagɨt. Uŋun nandɨsak, yo morap ak do nandaŋ, uŋun bamɨ tagɨsi dɨma noman tokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Yawe, gak da amɨn kɨnda aŋmɨlɨp akdo tepmɨ ɨmɨŋek nawa gengo iyɨŋ dekgi kaŋ, uŋun amɨn kɨsɨk kɨsɨk tagɨ asak. ");
INSERT INTO yut_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Jɨgɨ bɨsapmon gak da yɨk yawot ɨmɨsal. Yaŋgɨn egakwan amɨn yokwi kɨmagek mɨktɨm kagagwan pɨkwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Nido, Yawe da mɨŋat amɨni arɨpmɨ dɨma yopmaŋ detjak. Asisi, mɨŋat amɨn kabɨ iyɨ do manjɨgɨt uŋun manji arɨpmɨ dɨma yomjak. ");
INSERT INTO yut_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Ae don aŋpak kɨlegɨkon da gen kokwin akdaŋ. Aŋakwa amɨn kɨlegɨ da uŋun yoldaŋ. ");
INSERT INTO yut_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Namɨn da nak aŋpulugaŋek amɨn yokwi pabɨŋ yopjak? Namɨn da nak aŋpulugaŋek amɨn gulusuŋ aŋ uŋun pabɨŋ yopjak? ");
INSERT INTO yut_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Yawe da nak dɨma aŋpulugagɨt tam, bɨsap dubak dɨma kɨmakbi tamokon pakgɨm. ");
INSERT INTO yut_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Nak yaŋ nandagɨm, “Kandapno sagalegɨ, do kɨlɨ uŋun maŋ nɨtdɨsak.” Mani dɨma. Yawe, nak do but dasi galak taŋ namɨŋek abɨdaŋaki dɨma magɨm. ");
INSERT INTO yut_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Butjɨk nandagɨm bɨsapmon, butno aŋteban aŋek aŋpulugaŋbɨ kɨsɨk kɨsɨk agɨm. ");
INSERT INTO yut_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Gak kɨla amɨn yokwi gat pi dɨma aŋ. Uŋun amɨn da mɨŋat amɨnyo aŋpak yokwi tagɨ ani do gen teban yopmaŋgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Uŋun muwugek amɨn kɨlegɨ paŋupbal ak do gen yaŋ paŋteban aŋ. Ae gulusuŋ dɨma aŋ amɨn dapba kɨmotni do gen yaŋ yomaŋ. ");
INSERT INTO yut_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Mani, Yawe dam madepno arɨpmɨ dɨma tuwɨlɨ egɨsak. Piŋkopno da tagɨsi aŋkutnosok. ");
INSERT INTO yut_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Uŋun aŋpak yokwi awit dakon kobogɨ yomdɨsak. Yokwini uŋun nandaŋ yomɨsak, do dapban kɨmotdaŋ. Asi, Yawe Piŋkopnin da obɨsi paŋtasɨk akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Apba kɨsɨk kɨsɨk kap Yawe do yono! Piŋkop tɨp madepnin yokwikon baŋ pulugaŋ nipgut uŋun do nandaŋek yaŋ tɨdaŋek kɨsɨk kɨsɨk kap yono. ");
INSERT INTO yut_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Uŋun da kapmatjok kɨŋek ya yaŋ iyɨneŋ. Aŋek kɨsɨk kɨsɨk kap yaŋek mani aŋkɨsino. ");
INSERT INTO yut_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Nido Yawe uŋun Piŋkop tapmɨmɨ toŋsi egɨsak. Uŋun Kɨla Amɨn Madep tapmɨmɨ toŋsi egek amɨn da piŋkopnin yaŋ yoŋ yo morap yapmaŋ mudosok. ");
INSERT INTO yut_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Mɨktɨm galegɨ ae kabap mɨktɨm kɨsi uŋun iyɨ dakon. ");
INSERT INTO yut_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Mɨktɨm gat tap gat kɨsi iyɨ wasagɨt, do kɨsi bamot iyɨ dakon gɨn. ");
INSERT INTO yut_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Ji apba ŋwakbeŋ aŋek gawak ɨmno. Yawe uŋun da nin wasaŋ nipgut. ");
INSERT INTO yut_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Uŋun Piŋkopnin egɨsak. Nin sipsip kabɨni, do nin dakon kɨla aŋek japnin nimɨsak. Abɨsok geni nandaŋ ɨmni. ");
INSERT INTO yut_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Yawe da yaŋ yosok, “Kalɨp babɨkji da mɨktɨm kɨbɨrɨ tɨmon, Meriba ae Masa mɨktɨmon, but teban awit. Ji yaŋ dɨma ani. ");
INSERT INTO yut_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Yo agɨm uŋun pɨndakgwit, mani nak aŋkewal do pi madepsi awit. ");
INSERT INTO yut_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Nak bɨlak 40 uŋun amɨn do butjap nandaŋ yomgum. Aŋek yaŋ yagɨm, ‘Butdasi nak dɨma nolgaŋ. Nak dakon gen dɨma guramɨkgaŋ.’ ");
INSERT INTO yut_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Yaŋdo, nak japtaŋek yaŋ yoyɨgɨm, ‘Asi dayɨsat, ji nak dakon yɨk yawot kokupgwan dɨmasi pɨgɨni.’ ” ");
INSERT INTO yut_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Yawe do kap kalugɨ kɨnda yaŋ ɨmni. Mɨktɨmɨ mɨktɨmɨ amɨn ekwaŋ, ji Yawe do kap yaŋ ɨmni. ");
INSERT INTO yut_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Yawe do kap yaŋ ɨmɨŋek mani aŋkɨsini. Gɨldarɨ gɨldarɨ amɨn yokwikon baŋ tɨmɨk tɨmɨk asak uŋun dakon geni yaŋ teŋteŋoni. ");
INSERT INTO yut_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Amɨn kɨsisi mɨktɨmɨ mɨktɨmɨ ekwaŋ tɨlɨmni gat ae yo masɨ masɨmɨsi asak uŋun do yaŋ teŋteŋaŋ yomni. ");
INSERT INTO yut_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Yawe uŋun wagɨl tagɨsisi, do aŋkɨsiŋ kɨmorɨsi. Uŋun kokup kɨdat morap yapmaŋdak, do si pasal ɨmɨmɨsi. ");
INSERT INTO yut_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Mɨktɨm dɨwarɨ dakon piŋkopni uŋun kokup kɨdat dakon wupmɨ gɨn. Mani Yawe da kundu wasagɨt. ");
INSERT INTO yut_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Yawe uŋun kɨla amɨn madep egek man madepni taŋ ɨmɨsak. Tapmɨmni madep gat ae yo morapni kɨldani tagɨsi telagɨ yutnikon taŋ ɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Mɨŋat amɨn kabɨ morap, yaŋ sɨmɨl aŋek Yawe dakon tɨlɨmni gat ae tapmɨm madepni gat do yoni. ");
INSERT INTO yut_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Yaŋ sɨmɨl aŋek tɨlɨm madepni do nandaŋek Yawe aŋkɨsini. Paretji tɨmɨgek Telagɨ Yut Madepni da nagalgwan pɨgɨni. ");
INSERT INTO yut_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Uŋun telagɨsi ae tɨlɨmni ŋwakŋwarɨsi, do Yawe gawak ɨmni. Amɨn mɨktɨmɨ mɨktɨmɨ ekwaŋ, ji nɨmnɨmɨgek pasal ɨmni. ");
INSERT INTO yut_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Mɨktɨmɨ mɨktɨmɨ egɨ aŋaŋ kwaŋ uŋun dakon amɨn yaŋ yoyɨni, “Yawe uŋun kɨla amɨn madep egɨsak. Uŋun da mɨktɨm daman aŋteban aban wayɨŋ dɨma asak. Yawe da don gen kokwin pi kɨlegɨsi aŋek amɨn dakon aŋpak kokwin akdɨsak.” ");
INSERT INTO yut_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Kundu gat mɨktɨm gat, jil kɨsɨk kɨsɨk anjil. Tap ɨdap, gak wayɨŋ madepsi aŋek kɨsɨk kɨsɨk abi. Ae yo morap tap kagagwan toŋ, jiyo kɨsi kɨsɨk kɨsɨk ani. ");
INSERT INTO yut_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Jap pi gat ae yo morap uŋungwan toŋ, ji kɨsɨk kɨsɨk ani. Uŋun bɨsapmon kɨndap morap koron toŋ uŋun kɨsɨk kɨsɨk kap yokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Yawe da buron kɨsɨk kɨsɨk akdaŋ, nido Yawe abɨŋ gen kokwin aŋek mɨktɨm daman kɨsi dakon mɨŋat amɨnyo dakon aŋpak kokwin aŋ yomdɨsak. Aŋpak kɨlegɨkon da, ae gen bamɨkon da, mɨktɨmon mɨŋat amɨn morapyo gen kokwin aŋyomdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Yawe uŋun kɨla amɨn madep egɨsak. Mɨktɨm gak kɨsɨk kɨsɨk aki. Mɨktɨm tɨm tap binap toŋ ji but galak nandani. ");
INSERT INTO yut_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Gɨkwem gat ae pɨlɨn gat da aŋgwasamal. Aŋpak kɨlegɨkon da amɨn kɨla asak. ");
INSERT INTO yut_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Kɨndap da mibɨl taŋ ɨmɨŋek uwalni aŋgwasɨŋek ekwaŋ uŋun soŋban pasɨlgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Uŋun da malni yopban mɨktɨm teŋteŋosok. Mɨktɨm da kaŋek nɨmnɨmɨkdak. ");
INSERT INTO yut_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Yawe apban kaŋek kabap da pakbi dagoŋ. Uŋun mɨktɨm morap kɨsi dakon Amɨn Tagɨ egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Kundu da aŋpakni kɨlegɨ do yaŋ teŋteŋok aŋakwan mɨŋat amɨn morapyo da tɨlɨmni koŋ. ");
INSERT INTO yut_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Amɨn kokup kɨdat gawak yomɨŋek paŋkɨsaŋ uŋun mayak tok paŋ. Kokup kɨdat, ji Yawe gawak ɨmni. ");
INSERT INTO yut_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Saion kokup pap amɨn gat, ae Juda mɨktɨmon kokup pap taŋ aŋaŋ kwaŋ uŋun dakon amɨn gat da uŋun nandaŋek, gen kokwin tagɨsi asal uŋun do but galak nandaŋek kɨsɨk kɨsɨk aŋ. ");
INSERT INTO yut_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Nido Yawe gak Piŋkop Wɨkwisi egek mɨktɨm morap kɨsi kɨla asal. Gak piŋkop ŋwakŋwarɨ morap kɨsi yapmaŋek mango wukwisi tosok. ");
INSERT INTO yut_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Ji Yawe but dasi galak taŋ ɨmaŋ amɨn, ji aŋpak yokwi do nandaba ɨŋanisi asak. Iyɨ dakon telagɨ amɨn kabɨni, yokwi aŋ amɨn da kɨsiron baŋ tɨmɨgek kɨlani asak. ");
INSERT INTO yut_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Piŋkop da amɨn kɨlegɨ teŋteŋaŋ yoban kɨsɨk kɨsɨk paŋ. ");
INSERT INTO yut_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Amɨn kɨlegɨ, ji Yawe kɨsɨk kɨsɨk aŋɨmɨŋek mani telagɨ do nandaŋek ya yaŋ iyɨni. ");
INSERT INTO yut_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Yawe da yo masɨ masɨmɨsi agɨt, do kap kalugɨ kɨnda yaŋ ɨmno. Tapmɨmni madepsi ae aŋpakni telagɨ, do emaron teban tagɨt. ");
INSERT INTO yut_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Yawe emaron teban tagɨt uŋun dakon yaŋ teŋteŋok agɨt. Aŋpakni kɨlegɨ yolɨŋban mɨktɨmɨ mɨktɨmɨ amɨn kɨsi da kawit. ");
INSERT INTO yut_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Israel amɨn do but dasi galak taŋek dɨma yopmaŋ det do yaŋ teban tok agɨt uŋun do sigɨn nandɨsak. Piŋkopnin da emaron teban taŋek nin yokwikon baŋ pulugaŋ nipgut, uŋun mɨktɨmɨ mɨktɨmɨ amɨn ekwaŋ uŋun da kɨlɨ kawit. ");
INSERT INTO yut_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Mɨktɨm amɨn morap, ji yaŋ tɨdaŋek Yawe aŋkɨsini. Kɨsɨk kɨsɨk kap yaŋek aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Gita tɨdaŋek kap yaŋek Yawe aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Kweŋ gat ae kasɨsɨŋ gat pɨsoŋek yaŋ tɨdaŋek kɨsɨk kɨsɨk aŋek Yawe aŋkɨsini. Uŋun Kɨla Amɨn Madep egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Tap gat yo morap tapgwan toŋ, ji yaŋ tɨdoni. Mɨktɨm gat amɨn mɨktɨmon ekwaŋ, jiyo kɨsi yaŋ tɨdoni. ");
INSERT INTO yut_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Pakbi madep ji kɨsit tɨdoni. Kabap ji kɨsɨk kɨsɨk aŋek kap yoni. ");
INSERT INTO yut_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Ji kɨsisi Yawe da buron kɨsɨk kɨsɨk aŋek kap yoni, nido Yawe mɨktɨm amɨn morap gen kokwin aŋ yom do abɨsak. Gen kokwin kɨlegɨsi akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Yawe uŋun kɨla amɨn madep egɨsak. Mɨktɨmɨ mɨktɨmɨ amɨn ji pasal nɨmnɨmɨkyo ani. Kɨla amɨn madep tamonikon yɨgakwan aŋelo madep serabim da terɨ terɨ akgaŋ. Aŋakwa mɨktɨm wudɨp asak. ");
INSERT INTO yut_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Saion kokup papmon uŋudon Yawe tapmɨm madepni taŋ ɨmɨsak. Ae uŋun da mɨŋat amɨn morap kɨsi dakon man yapmaŋek mani da wɨkwisi asak. ");
INSERT INTO yut_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Amɨn kɨsi da mango madepsi ae masɨ masɨmɨ uŋun do yaŋ aŋkɨsiŋ kɨmotnisi. Gak telagɨsi. ");
INSERT INTO yut_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Kɨla amɨn madep tapmɨmɨ toŋ gak aŋpak kɨlegɨsi uŋun do galagɨsi nandɨsal. Gak da Israel amɨn nin do aŋpak tagɨsi gat ae aŋpak kɨlegɨ gat nibɨ yolgamaŋ. Gak da Israel mɨktɨmon gen kokwin kɨlegɨ gat ae aŋpak kɨlegɨ gat asal. ");
INSERT INTO yut_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Ji Yawe Piŋkopnin aŋkɨsini. Uŋun telagɨ egɨsak, do burɨkon kɨŋek gawak ɨmni. ");
INSERT INTO yut_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Moses gat Aron gat Yawe dakon mukwa sogok amɨn egɨpgumal. Ae Samuel yo kɨsi mani yaŋek gawak ɨmgwit amɨn kabɨkon nani kɨnda. Uŋun da Yawe do bɨsit aba bɨsitni nandaŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Gɨkwem tɨmɨ kɨnda dubagɨsi wɨgɨsak uŋudon egek gen tebani yomgut. Yoban gen teban morap Piŋkop da yomgut uŋun guramɨkgwit. ");
INSERT INTO yut_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Yawe Piŋkopnin, gak da mɨŋat amɨnyogo dakon bɨsitni nandaŋ yomgul. Gak da dɨwarɨni wɨrɨrɨk yomgul, mani gulusuŋni dakon kobogɨ do jɨgɨ yomgul. ");
INSERT INTO yut_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Yawe Piŋkopnin uŋun telagɨ, do mani awɨgek iyɨ da telagɨ kabapmon gawak ɨmneŋ. ");
INSERT INTO yut_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Amɨn mɨktɨmɨ mɨktɨmɨ ekwaŋ ji kɨsɨk kɨsɨk aŋek yaŋ tɨdaŋek Yawe aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Ji but galagon da Yawe gawak ɨmni. Kɨsɨk kɨsɨk kap yaŋek uŋun da kapmatjok kɨni. ");
INSERT INTO yut_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Yawe uŋun Piŋkop yaŋsi nandaŋ ɨmni. Uŋun da iyɨ nin wasaŋ nipgut. Nin uŋun dakon gɨn. Nin uŋun dakon mɨŋat amɨn kabɨni, nin sipsip kabɨni iyɨ pawɨlakwan ekwamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Telagɨ yut madep da nagalgwan pɨgek ya yaŋ iyɨŋek aŋkɨsineŋ. Nin ya yaŋ iyɨŋek mani yaŋ aŋenotneŋ. ");
INSERT INTO yut_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Nido Yawe uŋun tagɨsi. Dagok dagogɨ mɨni amɨn do but dasi galak taŋ yomɨsak. Babɨkon da babɨkon geni aŋteban aŋek amɨn kabɨni paŋpulugaŋ aŋaŋ kɨkdɨsak teban. ");
INSERT INTO yut_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Dewit dakon kap kɨnda. Yawe, nak amɨn do but dasi galak taŋ yomɨsal, ae amɨn dakon aŋpak kokwin kɨlegɨsi asal uŋun do kap yokeŋ. Nak gak aŋkɨsik do kap yokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Nak aŋpak kɨlegɨ baŋ gɨn yolgeŋ. Yawe, ni bɨsapmon gak abɨŋ nak aŋpulugoki? Nak naga da yutnon aŋpak kɨlegɨ baŋ gɨn abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Nak yo ɨŋani kɨnda dɨmasi kokeŋ. Piŋkop manji ɨmaŋ amɨn dakon aŋpak do dɨma galak tosot. Nak uŋun gat kaloŋɨ dɨma agɨpneŋ. ");
INSERT INTO yut_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Nak butnokon da yokwi dɨ dɨma abeŋ. Ae aŋpak dɨma agagɨ do nandak nandak dɨma abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Nak da amɨn do yaŋba yokwi tok aŋ amɨn obɨsi paŋupbal akdɨsat. Iyɨ do nandaba wɨgɨsak amɨn gat dɨma egɨpneŋ. ");
INSERT INTO yut_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Nak amɨn Piŋkop yolgaŋ uŋun baŋ galak taŋ yobeŋ, ae uŋun gat gɨn nak da yutnon tagɨ egɨpneŋ. Amɨn toktogɨsi aŋpak kɨlegɨ aŋ, uŋun amɨn dagɨn oman amɨno egɨpni. ");
INSERT INTO yut_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Jamba but amɨn nak da yutnon dɨma egɨpni, ae top yoŋ amɨn nak gat dɨma egɨpneŋ. ");
INSERT INTO yut_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Gɨldarɨ gɨldarɨ amɨn yokwi mɨktɨmninon ekwaŋ uŋun paŋupbal ak do pi abeŋ. Nak da amɨn aŋpak yokwi aŋ amɨn wɨrɨrɨgapbo Yawe da kokup papmon saŋbeŋek dɨma egɨpni. ");
INSERT INTO yut_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Amɨn kɨnda jɨgɨ paŋek tapmɨmni mɨnisi aŋakwan Yawe da aŋpulugosak do bɨsit agɨt. Yawe, bɨsitno nandaki. Nak gak da aŋpulugoki do yaŋ tɨdosot. Nak dakon kunamno nandaŋ nabi. ");
INSERT INTO yut_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Jɨgɨ madepsi pakeŋ bɨsapmon dɨma gandakeŋ yaŋ do dɨma pasɨlgi. Bɨsitno nandaki. Gak do yaŋ tɨdokeŋ bɨsapmon tepmɨsi nandaŋek nak aŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Egɨp egɨpno uŋun mukwa da yaŋ bɨsap pɨsɨpmɨsok taŋek pasɨlgaŋ uŋun yombem. Kɨndap madep da sosok uŋun da tɨlak gɨptɨmno tepmɨsi sosok. ");
INSERT INTO yut_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Amɨn da joŋ kɨbɨdaŋbi bamoŋ uŋudeŋ nak yokwisi egɨsat. Do jap nok do dɨma galak tosot. ");
INSERT INTO yut_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Nak iyoŋ iyoŋ yosot, ae gɨptɨmno madep dɨma, nak kɨdarɨ gɨnsi. ");
INSERT INTO yut_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Nak sɨŋgɨŋ da yaŋ mɨktɨm kɨbɨrɨ tɨmon yokwisi egɨsat. Ae kalbi dakon mɨnam da kokup amɨn da aŋtasɨk abi do amɨn da arɨpmɨ dɨma egɨpmɨ tɨmon ekwaŋ uŋun da arɨp egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Nak dɨpmɨn potpot tamokon pokdot, mani dabɨlno si sɨŋtaŋ egɨsak. Bupmɨsi, nak mɨnam kɨnda da yut kwenon yɨkdak uŋun da tɨlak nak naga gɨn egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Gɨldat kɨnda kaloŋ uwal da nak gen yokwi nayaŋ. Tasɨk tokeŋ do yaŋek yaŋsul aŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","10","Gak nak do butjap madepsi nandɨsal, do abɨlak baŋgɨn nosot, ae dabɨl pakbino kapmon maŋba pakbi gat kɨsi nosot. Nak sɨbɨt sɨbɨt baŋ yaŋ abɨdaŋ mabɨ tɨmɨ kɨndakon kɨgɨm. ");
INSERT INTO yut_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Pɨlɨndo gɨldat da pɨgɨsak uŋun da arɨpmon egɨp egɨpno bɨsap pɨsɨpmɨsok gɨn. Nak joŋ da kɨbɨdoŋ uŋun yombem. ");
INSERT INTO yut_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Mani Yawe, gak kɨla amɨn madep toktogɨsi egɨsal. Mango uŋun wukwisi, do mɨŋat amɨnyo don altokdaŋ uŋun da gak nandaŋ gamdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Abɨsok abɨŋ Saion kokup pap do bupmɨ nandaŋ ɨmɨŋek aŋpulugoki. Bupmɨ nandaŋ ɨbi dakon bɨsap kɨlɨ noman tak. Abɨsok bupmɨ bɨsap. ");
INSERT INTO yut_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Saion kokup pap uŋun yokwi tak, mani oman amɨngo da yut agak tɨp morapni do but dasi galak taŋ yomaŋ. Abɨsok yokwi tak, mani kosit madepni dakon kɨmbabaŋ pɨndagek uŋun da but yokwi yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","16","Piŋkop da Saion kokup pap aeni wasaŋek tɨlɨmni mɨŋat amɨn kabɨkon yolɨkdɨsak. Aŋakwan mɨŋat amɨn kabɨ morap Yawe do pasolni, ae mɨktɨm dakon kɨla amɨn madep morap tɨlɨmni do pasal ɨmdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Uŋun gɨptɨm dakon yo do wadaŋ amɨn uŋun dakon bɨsitni nandaŋ yomdɨsak. Bɨsit aba saŋbeŋek manji dɨma yomdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Yo uŋun Yawe da asak uŋun papiakon mandano babɨ kabɨ don altoni da Yawe da pi uŋun agɨt dakon gen nandaŋek mani awɨgɨni. ");
INSERT INTO yut_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Gen uŋun yaŋ mandaneŋ, “Yawe iyɨ da telagɨ kokupmon kwen egek sɨŋtaŋban pɨgɨt. Uŋun Kwen Kokup egek sɨŋtaŋban mɨktɨmon pɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Aŋek dam tebanon amɨn jɨgɨ paŋek kunam tagakwa nandagɨt. Ae dapba kɨmotni do yaŋbi amɨn uŋun pulugaŋ yopban kɨwit.” ");
INSERT INTO yut_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","Yaŋ agɨt do Saion mɨŋat amɨnyo da Yawe dakon man yaŋ teŋteŋoni. Jerusalem mɨŋat amɨnyo da aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","Uŋun bɨsapmon mɨŋat amɨnyo gat ae kɨla amɨn madepni gat Yawe gawak ɨm do Jerusalem muwugek yaŋ akdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Nak tagaŋ amɨn madep egapbo Yawe da tapmɨmno aŋupbal aŋek bɨsapno aŋpɨsɨp agɨt. ");
INSERT INTO yut_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Do nak yaŋ iyɨgɨm, “Piŋkopno, toktok teban egɨsal. Nak amɨn pelaŋ dɨma at, do egɨp egɨpno abɨsok dɨma gwayeki. ");
INSERT INTO yut_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","On mɨktɨm dakon teban tokni kalɨpsigwan kɨlɨ yɨpgul da tosok. Ae kundukon yo morap toŋ uŋun gak dakon kɨsit kɨlda. ");
INSERT INTO yut_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Kundu gat mɨktɨm gat tasɨk tokdamal. Ɨmal gɨraŋɨ da pudaŋ kwaŋ, uŋun da tɨlak yokwi tokdamal. Amɨn da ɨmal kulabɨk aŋ, uŋun da tɨlagon gak da kulabɨk aŋaki saŋbeŋek dɨma tokdamal. Mani gak toktok teban egɨpdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Gak kulabɨk dɨma aŋek yaŋ gɨn egɨpgul da egɨsal. Gak dagok dagogɨ mɨni egɨ wɨgɨkdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Oman amɨngo nin dakon mɨŋat monjɨyo gak da buron egɨpdaŋ. Ae uŋun dakon dɨwatni paŋpulugaŋaki gak gat tagɨsi egɨpdaŋ.” ");
INSERT INTO yut_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Dewit dakon kap kɨnda. Yawe aŋkɨsikeŋ. Nak butno naŋ yaŋ iyɨsat, gak gwɨnɨmbɨl mani telagɨ aŋkɨsiki. ");
INSERT INTO yut_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Yawe aŋkɨsikeŋ. Nak do yo morap tagɨsi asak uŋun do dɨma ɨŋtokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Uŋun da dɨwarɨno kɨsisi wɨrɨrɨk namɨsak. Ae sotno kɨsisi paŋmɨlɨp aban kɨlek tosot. ");
INSERT INTO yut_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Yawe da yokwikon baŋ pulugaŋban dɨma kɨmokdot. Ae but dasi galak taŋ namɨŋek bupmɨ nandaŋ namɨsak. ");
INSERT INTO yut_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Yo tagɨsi do galak tosot uŋun arɨpnokonsi namɨsak. Yaŋ aŋakwan nak aeno amɨn kalugɨ dagaŋek sɨŋgɨŋ da yaŋ tapmɨmɨ toŋ agɨsat. ");
INSERT INTO yut_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Amɨn da pabɨŋ yopmaŋakwa yokwi ekwaŋ amɨn Yawe da aŋpakni kɨlegɨkon da gen kokwin tagɨsi aŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Kalɨpsigwan yo morap ak do nandagɨt uŋun Moses naŋ iyɨgɨt. Ae pi tapmɨmɨ toŋ agɨt uŋun Israel amɨn do yolɨŋban pɨndakgwit. ");
INSERT INTO yut_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Yawekon bupmɨ ae nandaŋ yawotyo tosok. Uŋun butjap tepmɨ dɨma nandɨsak, ae amɨn do but dasi madepsi galak taŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Bɨsapmɨ bɨsapmɨ yokwi amaŋ do gen dɨma yaŋ nimɨsak. Ae butjapni bɨsap dagok dagogɨ mɨni dɨma taŋ aŋaŋ kɨsak. ");
INSERT INTO yut_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Dɨwarɨnin dakon kobogɨ yokwisi tɨmɨrɨ mani dɨma nimɨsak. Nin yokwi morapmɨsi amaŋ uŋun dakon kobogɨ do yo jɨgɨsi tɨmɨrɨ mani dɨma nimɨsak. ");
INSERT INTO yut_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Nido amɨn iyɨ do pasal ɨmaŋ amɨn uŋun but dasi galak taŋ yomɨsak. Butdasi galak taŋ yomyomni uŋun pɨdaŋbisi, mɨktɨm yapmaŋek kwensi ason kundu tosok uŋun dakon tɨlak. ");
INSERT INTO yut_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Gɨldat wɨsagon da si pɨgɨsak tet uŋun dubagɨsi. Uŋun da tɨlak Piŋkop da dɨwarɨnin wɨrɨrɨkban dubagɨsikon toŋ. ");
INSERT INTO yut_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Dat da mɨŋat monjɨyoni do bupmɨ nandaŋ yomaŋ uŋun da tɨlak Yawe da amɨn iyɨ do pasal ɨmaŋ amɨn do yaŋsi nandaŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Nido tapmɨmnin madep dɨma, nin mɨktɨm gɨn yaŋ nandaŋ nimɨsak. ");
INSERT INTO yut_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Amɨn nin joŋ yombem egɨp egɨpnin pɨsɨpmɨsok. Nin joŋ dakon jareŋɨ yombem da bɨsap pɨsɨpmɨsok egek kɨbɨdomaŋ. ");
INSERT INTO yut_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Mɨrɨm da jareŋ paŋwayɨŋ aba maŋakwa amɨn da jareŋ saŋbeŋek dɨma pɨndakgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Mani Yawe da toktok teban mɨŋat amɨnyo pasal ɨmɨŋek ekwaŋ uŋun do but dasi galak taŋ yomɨsak. Ae babɨk don altoni uŋun do aŋpak kɨlegɨsi aŋ yomdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","Yawe da saŋbek saŋbek agɨt uŋun yolek geni guramɨkgaŋ amɨn do yo tagɨsi aŋ yomdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Yawe Kwen Kokupmon kɨla amɨn madep yɨgek yo morap kɨla asak. ");
INSERT INTO yut_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Aŋelo tapmɨmɨ madepsi kabɨ, ji Yawe dakon geni do mɨrak pakyaŋsi yopmaŋek guramɨk kɨmokgoŋ kabɨ, ji Yawe aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Ji Yawe dakon pi amɨn Kwen Kokup egek galaktokni yolek omani aŋ, ji Yawe aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Yo morap Yawe da wasagɨt da kɨlani asak uŋun dukwan dukwan taŋ aŋaŋ kwaŋ, ji Yawe aŋkɨsini. Nak Yawe aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Nak Yawe aŋkɨsikeŋ. Yawe Piŋkopno, gak wukwisi. Gak kɨla amɨn madep mibɨltogɨ ae man madepgo toŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Amɨn da ɨmal baŋ gɨptɨmni wamaŋgaŋ uŋudeŋ, gak gaga naŋ teŋteŋɨ naŋ wamaŋdal. Amɨn da ɨmal yut ɨlɨkba pɨkwaŋ uŋudeŋ, gak da kundu gat ae gɨk morap gat yopmaŋdal. ");
INSERT INTO yut_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Aŋek yutgo kwen ason pakbi kwenon asal. Gɨkwem da os da amɨn ɨlɨk pawɨlgaŋ tamo tɨmgo dagaŋakwan mɨrɨm da gak aŋaŋ kɨsak. ");
INSERT INTO yut_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Gak da mɨrɨm yabekbɨ uŋun da gengo aŋaŋ kɨsak. Ae gak da abɨ mal da oman amɨngo dagoŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Gak da mɨktɨm on yɨpgul da tamonikon wagɨl tebai tosok, ae arɨpmɨ dɨma duwalɨk kɨsak. ");
INSERT INTO yut_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Gak da tap ɨdap yɨpbɨ ɨmal da yaŋ mɨktɨm wutjɨgɨt. Aŋaki pakbi da kabap morap kɨsi wutjɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Mani don tap ɨdap tebai iyɨŋbɨ duwalɨk kɨgɨt. Tap ɨdap gak da tebai yaŋbɨ nandaŋek tɨmtɨm yaŋek kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Tap ɨdap kabap morap yɨpmaŋ degek mɨktɨm kuldugɨ tɨmon pɨgɨgɨt. Gak da tap ɨdap uŋudon tosak do yagɨl da abɨsok uŋudon tosok. ");
INSERT INTO yut_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Gak da tɨlak kɨlɨ yɨpgul, do tap ɨdap tɨlak uŋun dɨma ɨratjak. Tap ɨdap mɨktɨm morap aeni dɨma wutjɨsak. ");
INSERT INTO yut_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Kabap da galegɨkon mɨktɨmgwan pakbi dabɨl paŋnoman aŋaki pakbi pagek kuldugɨ tɨmon pukwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Joŋ bɨt kɨlapyo pakbi uŋun baŋ noŋ, ae joŋ donki kɨsi uŋun pakbi noŋ, aŋek tekni paŋyawot aŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Pakbi ɨleŋon kɨndap toŋ, mɨnam uŋudon yutni aŋek kɨndap kɨlɨŋon yɨgek gen yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Gak kokupgokon kwen egek sɨkak yɨpbɨ kabap morapmon moŋ. Pi asal dakon bamɨ da on mɨktɨmon tugosok. ");
INSERT INTO yut_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Gak da bulmakau da noni do joŋ yopbɨ kwoŋ. Ae yo mibɨlɨ mibɨlɨ abɨ kwaŋakwa nin jap uŋudon pamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Nin wain nok do wain sop pamaŋ, aŋek but galaksi nandamaŋ. Ae tomno dabɨlnin sono gulgwa ani yaŋ do olip dakon nelagɨ pamaŋ. Ae jap da gɨptɨmnin paŋteban ani do pigaga jap pamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Sɨkak maŋakwa Lebanon dakon kɨndap dakon gelɨ da pakbi morapmɨ ɨlɨkgaŋ. Yawe dakon sida kɨndap uŋun kalɨpsigwan iyɨ kwaokgɨt. ");
INSERT INTO yut_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Uŋun sida kɨndapmon mɨnam da yutni aŋ. Ae bɨlak mɨnam uŋun kwat kwenon yutni uŋudon aŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Joŋ meme kabap madepsikon akwaŋ. Aŋakwa mɨsan kabap dakon tɨp madep da paŋyoŋgam aŋakwa ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Gak da kanek wasagɨl da uŋun da bɨlak dakon kanek morap dakon tɨlakni asak. Ae gɨldat dabɨl ni bɨsapmon pɨgɨsak uŋun gɨldat da iyɨ nandɨsak. ");
INSERT INTO yut_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Gak da pɨlɨn tuk abɨ noman taŋakwan koron joŋ bɨt kɨlapyo akwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Laion kɨlap wɨsɨŋek madepsi yaŋ tɨdoŋ. Piŋkop gak da kɨlap wɨsaŋ uŋun yomɨsal. ");
INSERT INTO yut_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Gɨldat wɨsak bɨsapmon tamonigwan si paŋkɨ pokgoŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Aŋakwa amɨn pɨdaŋ kɨŋ pini aŋakwa wɨgɨ gɨldat pɨgɨsak. ");
INSERT INTO yut_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Yawe, gak da yo morapmɨ wasagɨl. Gak nandaŋ kokwin aŋek yo morap uŋun wasagɨl. Gak da yo morap wayɨŋ aŋek ekwaŋ wasagɨl uŋun on mɨktɨmon tugaŋbisi. ");
INSERT INTO yut_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Tap ɨdap uŋun madepsi. Tap kɨlap madep ae monɨŋ monɨŋ morapmɨsi gat ae yo dɨwarɨ gat kɨsi uŋungwan ekwaŋ. Nin da arɨpmɨ dɨma manjɨtneŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Tap kwenon tap wakga kɨŋ ap aŋakwa tap kɨlap madepsi wasagɨl uŋun tap pɨdaŋek kɨsɨk kɨsɨk aŋek wɨgɨ mok aŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Uŋun kɨsisi jap do aŋ bɨsapmon gak da upmokgi do jomjom aŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Gak da jap yomɨŋaki noŋ. Gak da upmagaki burɨ tugoŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Mani manji yomɨŋaki si pasolgoŋ. Ae mɨrɨm gwayesal bɨsapmon kɨmagek mɨktɨm dagoŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Gak da egɨp egɨp dakon mɨrɨm yobɨ egɨp egɨp kalugɨ abɨdoŋ. Yo morap paŋkaluk aŋaki mɨktɨmon kalugɨsi toŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Yawe dakon tɨlɨmni dagok dagogɨ mɨni taŋ aŋaŋ kɨsak dosi nandɨsat. Aŋakwan yo morap wasagɨt do kɨsɨk kɨsɨk asak. ");
INSERT INTO yut_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Uŋun mɨktɨmon sɨŋtaŋban mɨktɨm wudɨp asak. Kɨsitni kabapmon yopban mukwa pɨdoŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Nak si egɨpbeŋ bɨsapmon Yawe do kap yokeŋ. Nak mɨktɨmon egɨ aŋaŋ kɨkdɨsat uŋun da arɨpmon Piŋkopno sigɨn yaŋ aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Nak Yawe do kɨsɨk kɨsɨk asat. Do uŋun da nandak nandakno do galak tosak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Yawe, yokwi aŋ mɨŋat amɨnyo paŋupbal aki. Nak amɨn yokwi wagɨl pasɨlni do nandɨsat. Nak Yawe aŋkɨsikeŋ. Yawe aŋkɨsini! ");
INSERT INTO yut_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Yawe bɨsit iyɨŋek ya yaŋ iyɨno. Pi madep madep agɨt uŋun dakon geni yoyɨno mɨktɨmɨ mɨktɨmɨ amɨn da nandani. ");
INSERT INTO yut_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Kap yaŋek mani aŋkɨsiŋek wasok tapmɨmɨ toŋsi morapmɨ agɨt uŋun do yaŋ teŋteŋono. ");
INSERT INTO yut_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Mani telagɨ aŋkɨsineŋ. Amɨn morap Yawe gawak ɨm do uŋun da kapmatjok kwaŋ uŋun kɨsɨk kɨsɨk madep ani. ");
INSERT INTO yut_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Bɨsapmɨ bɨsapmɨ Yawe da kapmatjok kɨŋek paŋpulugaŋek tapmɨm nimjak do sigɨn iyɨneŋ. ");
INSERT INTO yut_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","Ji Yawe dakon oman amɨni Abraham dakon babɨni kabɨ, ji Jekop da kabɨkon nani, Yawe da iyɨ do manjɨkbi kabɨ, Yawe da pi tapmɨmɨ toŋ ae yo masɨ masɨmɨ agɨt uŋun do aesi nandani. Ae amɨn yokwi do kobogɨ yokwi yomgut uŋun do nandani. ");
INSERT INTO yut_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Yawe uŋun Piŋkopnin. Uŋun da mɨktɨmɨ mɨktɨmɨ mɨŋat amɨn morap kɨlani asak. ");
INSERT INTO yut_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Yawe da saŋbek saŋbekni nin gat toktogɨsi agɨt. Dagok dagogɨ mɨni saŋbek saŋbekni do nandaŋ egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Yawe da Abraham gat saŋbek saŋbek uŋun agɨt. Uŋun saŋbek saŋbek agɨt uŋun dɨma kɨrɨŋɨt do Aisak naŋ yaŋ teban tok aŋ ɨmgut. ");
INSERT INTO yut_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Ae Jekop, Israel amɨn dakon babi, saŋbek saŋbek uŋun toktogɨsi tosak do Yawe da iyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","Uŋun da yaŋ yagɨt, “Nak da Kenan mɨktɨm gak do gabeŋ. Mɨktɨm uŋun babɨgoni do tosak.” ");
INSERT INTO yut_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Kalɨp Israel amɨn kaloŋɨsok, ae apbi amɨn yombem da egɨpgwit. Asi, Kenan mɨktɨmon egɨpgwit, mani iyɨ dakon mɨktɨm uŋun mɨni. ");
INSERT INTO yut_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Uŋun amɨn ŋwakŋwarɨ da mɨktɨmon agɨ agɨ awit. ");
INSERT INTO yut_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Mani, Yawe da yum pɨndagakwan amɨn dɨ da dɨma pabɨŋ yopgwit. Paŋpulugaŋek kɨla amɨn madep yokwi aŋyom do nandawit uŋun tebai yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","Kɨla amɨn madep uŋun yaŋ yoyɨgɨt, “Mɨŋat amɨnyo uŋun nak dakon pi ani do manjɨgɨm, do aŋpak yokwi dɨma aŋyomni. Nak dakon kombɨ amɨno do yokwi dɨma aŋyomni.” ");
INSERT INTO yut_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Yawe da aban Kenan mɨktɨmon jap do madepsi awit. Aŋek japni paŋpasɨl agɨt. ");
INSERT INTO yut_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Mani Josep yabekban uŋun da mibɨl taŋek uŋun da kalɨp paŋkɨ Isip mɨktɨmon egɨpgut. Peni padɨk padɨkyo da moneŋ tɨmɨt do nandaŋek amɨn dakon oman monjɨni egɨpjak do amɨn do yomgwit. ");
INSERT INTO yut_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Ain nap baŋ kandapnikon paŋteban aba kandapmɨ pɨlɨn tagɨt. Ae ain gɨroŋɨkbi madep kɨnda tegɨkon aŋteban awit. ");
INSERT INTO yut_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Yaŋ egakwan wɨgɨ yo uŋun altoni do kalɨp yaŋkwok agɨt uŋun bamɨ noman tagɨt. Yawe dakon gen da Josep dakon gen uŋun bamɨsi yaŋ yolɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Kɨlɨ Isip amɨn dakon kɨla amɨn madep da amɨn kɨnda yabekban kɨŋ Josep dam tebanon naŋ pulugagɨt. Amɨn Ŋwakŋwarɨ Kabɨ dakon kɨla amɨn uŋun da Josep pulugaŋ yɨpban kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Aŋek yɨpban yut madepni gat ae yo morapni kɨla asak do man madep ɨmgut. ");
INSERT INTO yut_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Kɨla amɨn madep dakon yo morapni kɨla aŋ uŋun dakon mibɨltok amɨn morapni kɨla agɨt. Ae kɨla amɨn madep nandak nandak ɨmaŋ amɨn kabɨ uŋun yoyɨŋdetjak dakon tapmɨm kɨsi taŋ ɨmgut. ");
INSERT INTO yut_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Don Jekop paŋkɨ Isip egɨpgut. ");
INSERT INTO yut_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Ae don Yawe da mɨŋat amɨn kabɨni paŋpulugaŋban gwakni morapmɨ awit. Ae paŋpulugaŋban tapmɨmni da uwalni dakon tapmɨm yapgut. ");
INSERT INTO yut_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Yawe da Isip amɨn dakon butni paŋtobɨlban mɨŋat amɨn kabɨni do uwal aŋ yomgwit. Aŋek Yawe dakon oman amɨni do yokwi aŋ yom do kosit wusɨk awit. ");
INSERT INTO yut_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Mani don, Yawe da oman amɨni Moses gat Aron gat manjɨŋek yabekban Isip kɨgɨmal. ");
INSERT INTO yut_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Kɨŋ altaŋek Yawe dakon wasok tapmɨmɨ toŋ Isip mɨktɨmon agɨmal. ");
INSERT INTO yut_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Yawe da pɨlɨn tuk yɨpban pɨlɨn tuk da mɨktɨm wutjɨgɨt, mani Isip da geni abɨŋ yɨpgwit. ");
INSERT INTO yut_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Pakbi kulabɨk aban yawi dagaŋek tap kɨlap kɨsi morap dapban kɨmak mudawit. ");
INSERT INTO yut_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Meŋgak morapmɨsi ɨreŋ taŋek mɨktɨmni kɨsi tugawit, ae kɨla amɨn madep iyɨ dakon yut tamoyo kɨsi tugawit. ");
INSERT INTO yut_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Yawe da yaŋakwan bɨgal gat ae gugɨm gugɨm kɨsi morapmɨsi ɨreŋ taŋek Isip mɨktɨm kɨsi tugawit. ");
INSERT INTO yut_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Ae sɨkak kulabɨk aŋek ais gat ae mal gat baŋ yopban pɨwit. ");
INSERT INTO yut_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Wain napni gat ae pik kɨndapni gat paŋupbal aŋek kɨndap dɨwarɨ dapban sulugɨ tɨmɨ morapmɨ awit. ");
INSERT INTO yut_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Gen yaŋakwan pɨlak pɨlak noman tawit. Tɨlakni uŋun morapmɨsi, amɨn da arɨpmɨ dɨma manjɨrɨ. ");
INSERT INTO yut_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Pɨlak pɨlak da yo tamɨ toŋ morap nawit. Aŋek Isip amɨn da jap kwaokgwit dakon bamɨ kɨsi nawit. ");
INSERT INTO yut_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Ae Isip amɨn morapmon amɨn yurɨ kɨndakon monjɨ mibɨltogɨ Piŋkop da dapban kɨmak kɨmak awit. ");
INSERT INTO yut_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Mani don, Israel amɨn tɨmɨk paŋkɨŋakwan Isip yɨpmaŋ dekgwit. Silva ae gol kɨsi tɨmɨgek kɨwit. Israel amɨn morap kɨsi tagɨsi egɨpgwit, kɨnda sot dɨma agɨt. ");
INSERT INTO yut_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Isip amɨn Israel do madepsi pasalgwit, do kɨŋ mudaŋakwa but galak nandawit. ");
INSERT INTO yut_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Yawe da gɨkwem tɨmɨ kɨnda yɨpban kwen taŋek uŋun da mɨŋat amɨni paŋyoŋgam agɨt. Ae kalbi kɨndap madep kɨnda yɨpban uŋun da teŋteŋɨ yomgut. ");
INSERT INTO yut_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Jap do iyɨŋba mɨnam yopban apba nawit. Ae Kwen Kokup dakon bret yoban naŋek tugawit. ");
INSERT INTO yut_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Tɨp madep kɨnda wɨtdal kɨŋakwan pakbi kɨnda tagal kɨŋek mɨktɨm kɨbɨrɨ tɨmon pakbi madep kɨnda pak kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Yo morap yaŋ agɨt, nido kalɨp Abraham oman amɨni do yaŋ teban tok agɨt uŋun do sigɨn nandagɨt. ");
INSERT INTO yut_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Do aŋek mɨŋat amɨni tɨmɨk paŋkɨgɨt. Aŋakwan mɨŋat amɨn kabɨ iyɨ do kɨlɨ manjɨgɨt uŋun kap yaŋek kɨsɨk kɨsɨk aŋek kɨwit. ");
INSERT INTO yut_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Kɨŋakwa Amɨn Ŋwakŋwarɨ Kabɨ dakon mɨktɨm uŋun do yomgut. Ae yum pɨndagakwan uŋun dakon pi tɨmɨkgwit. ");
INSERT INTO yut_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Israel amɨn da gen morapni gat ae gen teban morapni guramɨk kɨmotni do yaŋ agɨt. Yawe dakon man awɨgɨni! ");
INSERT INTO yut_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Yawe dakon man awɨgɨni. Yawe aŋpakni uŋun tagɨsisi, do ya yaŋ iyɨneŋsi. Dagok dagogɨ mɨni nin do but dasi galak taŋ nimɨsak. ");
INSERT INTO yut_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Yo madep agɨt do namɨn da uŋun dakon geni tagɨ yaŋ teŋteŋosak? Ae aŋpak tagɨsi morap agɨt uŋun da arɨpmon namɨn da mani tagɨ awɨgɨsak? ");
INSERT INTO yut_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Amɨn do gen kokwin kɨlegɨsi aŋ yomɨŋek bɨsapmɨ bɨsapmɨ aŋpak kɨlegɨsi aŋ amɨn uŋun kɨsɨk kɨsɨk tagɨ ani. ");
INSERT INTO yut_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Yawe, mɨŋat amɨn kabɨgo paŋpulugaŋek yokwikon baŋ tɨmɨkgi bɨsapmon, nakyo kɨsi abɨdoki. ");
INSERT INTO yut_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Nak mɨŋat amɨn kabɨgo pɨndagapbo tagɨsi yɨgek yo tagɨsi tɨmɨtni do nandɨsat. Ae amɨn kabɨgo da kɨsɨk kɨsɨk aŋakwa nak uŋun do kɨsɨk kɨsɨk abeŋ. Aŋek nin gak dakon amɨn kabɨgo ekwamaŋ do mango aŋkɨsineŋ dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Kalɨp babɨknin da awit, uŋudeŋ nin yokwi agɨmaŋ. Nin aŋpak yokwi mibɨlɨ mibɨlɨ agɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Isip mɨktɨmon babɨknin gak da wasok tapmɨmɨ toŋ agɨl uŋun do pakyaŋsi dɨma nandawit. Gak da bɨsap morapmɨ aŋpak tagɨsi aŋ yomgul, mani uŋun do si ɨŋtawit. Aŋek Tap Gamikon kɨŋ altawit bɨsapmon gak kwen wɨgɨk aŋ gamgwit. ");
INSERT INTO yut_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Mani Yawe da tapmɨm madepni yolɨk do nandagɨt, ae man bini dɨma mosak do yokwikon baŋ tɨmɨgakwan dɨma yokwi tawit. ");
INSERT INTO yut_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Tap Gami tebai iyɨŋban mɨktɨm kɨbɨrɨ tɨm dagagɨt, do amɨn da mɨktɨm kɨbɨrɨ tɨmon kwaŋ uŋun da tɨlak mɨŋat amɨnyo mibɨltaŋ yomɨŋek tap ɨdap pudaŋek paŋpaŋ kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Amɨn uwal aŋ yomgwit amɨn da kɨsiron baŋ tɨmɨgakwan dɨma paŋupbal awit. ");
INSERT INTO yut_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Mani pakbi da uwal wutjɨba kɨmak mudawit, kɨnda dɨma egɨpgut. ");
INSERT INTO yut_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Yawe da yaŋ aŋakwan mɨŋat amɨnyoni da yaŋ teban tok morap aŋ yomgut uŋun do nandaŋ gadawit. Aŋek kap yaŋek aŋkɨsiwit. ");
INSERT INTO yut_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Mani Yawe da yo agɨt uŋun do tepmɨsi ɨŋtawit. Aŋek mibɨltok Piŋkop da si yoyɨŋakwan yo ak do dɨma nandawit. Iyɨ da nandak nandagon da yo awit. ");
INSERT INTO yut_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Mɨktɨm kɨbɨrɨkon egek burɨkon da jap dogɨn madepsi nandaŋek Piŋkop aŋkɨlɨkgwit. ");
INSERT INTO yut_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Piŋkop yo nido iyɨwit uŋun yomgut, mani sot madep kɨnda kɨsi yɨpban sot awit. ");
INSERT INTO yut_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Mɨktɨm kɨbɨrɨ tɨmon egek dɨ da Moses gat Aron Yawe dakon mukwa sogok amɨni telagɨ gat do nandaba yokwi tok aŋ yomgwit. Aŋek Piŋkop da nin do tapmɨm yaŋgɨn nimɨsak tam tagɨ yaŋ nandawit. ");
INSERT INTO yut_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Aŋakwa mɨktɨmon gapma madep kɨnda pɨsaŋ pɨgakwan Datan gat ae Abiram gat amɨn kabɨni gat kɨsi uŋun gapmagwan pɨgakwa mɨktɨm da abɨŋ sopmaŋakwan pasɨlgwit. ");
INSERT INTO yut_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Aŋakwa kɨndap da pɨŋek uŋun amɨn bamot yolgwit amɨn soŋban mɨni awit. ");
INSERT INTO yut_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Orep Kabapmon uŋudon egek gol baŋ bulmakau wup kɨnda wasaŋek uŋun Piŋkopnin yaŋ yaŋek gawak ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Bulmakau joŋ nosok dakon wupmɨ kɨnda gawak ɨmgwit. Uŋun aŋpak aŋek Piŋkopni tɨlɨmɨ toŋsi abɨŋ yɨpgwit. ");
INSERT INTO yut_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Piŋkop da Isip mɨktɨmon pi tapmɨmɨ toŋsi aŋek Isip da kɨsiron baŋ tɨmɨkgɨt, mani Israel amɨn da si ɨŋtaŋ ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Piŋkop da wasok tapmɨmɨ toŋ Isip mɨktɨmon agɨt, ae yo ŋwakŋwarɨsi Tap Gamikon aban mɨŋat amɨnyo madepsi wɨrɨpdakgwit. ");
INSERT INTO yut_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Piŋkop da mɨŋat amɨni dapban kɨmotni do yagɨt. Mani pi amɨni uŋun manjɨgɨt uŋun Moses, uŋun da Piŋkop da dabɨlon agek Israel amɨn paŋpulugaŋek Piŋkop dakon butjap dakon kosit sopmaŋakwan Piŋkop da dɨma paŋupbal agɨt. ");
INSERT INTO yut_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Uŋun Piŋkop da paŋpulugosak do yaŋ teban tok agɨt uŋun do dɨma nandaŋ gadawit, do mɨktɨm tagɨsi abɨdok do dɨma galak tawit. ");
INSERT INTO yut_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Ɨmal yut kabeŋnigwan egɨ egɨ aŋek Yawe do yaŋba yokwi tok aŋek geni dɨma guramɨkgwit. ");
INSERT INTO yut_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Yaŋ awit, do Piŋkop da gen tebaisi yomɨŋek mɨktɨm kɨbɨrɨ tɨmon kɨmotni do yagɨt. ");
INSERT INTO yut_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","Aŋek babɨkni yolban paŋkɨ Amɨn Ŋwakŋwarɨ Kabɨ da binapmon egek mɨktɨm ŋwakŋwarɨkon egɨpni do yagɨt. ");
INSERT INTO yut_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Don Peor mɨktɨmon kokup kɨdat Bal gawak ɨmɨŋek kokup kɨdat egɨp egɨpmɨ mɨni uŋun do paret abi uŋun nawit. ");
INSERT INTO yut_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Aŋpak uŋun aba Yawe butjap nandaŋek sot madep yokwisi kɨnda yomgut. ");
INSERT INTO yut_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Mani Pinias da pɨdaŋ agek binap amɨni egɨ yomɨŋakwan sot madep uŋun pasɨlgɨt. ");
INSERT INTO yut_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Pinias da yo uŋun agɨt uŋun do aŋpak kɨlegɨsi kɨnda asak yaŋ nandaŋ ɨmgwit da wuŋ abɨsok ekwamaŋon kɨsi yaŋ gɨn nandamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Israel amɨn Meriba pakbikon yokwi aba Piŋkop butjap nandaŋ yomgut, do uŋun aŋpakni do aŋek Moses jɨgɨ madep pagɨt. ");
INSERT INTO yut_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Moses burɨ yokwi taŋban dɨma yogogɨ gen yagɨt. ");
INSERT INTO yut_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Yawe da yoyɨgɨt uŋudeŋ, Amɨn Ŋwakŋwarɨ Kabɨ dɨma dapba kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Israel amɨn Piŋkop dɨma nandaŋ ɨmaŋ kabɨkon mɨŋat eyo aŋek uŋun dakon aŋpak yokwini yolek awit. ");
INSERT INTO yut_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Yaŋ aŋek kokup kɨdatni gawak yomɨŋek aŋpak yokwisi aŋek egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Uŋun da monjɨ gwayoni dapmaŋ kokup kɨdat do paret awit. ");
INSERT INTO yut_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Iyɨ dakon monjɨ gwayoni baŋ dapgwit. Monjɨ gwayoni gulusuŋ dɨma awit, mani dapmaŋ paretni do Kenan amɨn dakon kokup kɨdat do ɨmgwit. Aŋakwa yawini da mɨktɨm aŋupbal aban Piŋkop da dabɨlon ɨŋani agɨt. ");
INSERT INTO yut_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Aŋpak uŋun aŋek iyɨ baŋ paŋupbal aba Piŋkop da dabɨlon ɨŋani awit, aŋek mɨŋat kɨnda da eni yɨpmaŋek yumabi asak uŋun da tɨlak Piŋkop manji ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Yaŋ awit do Yawe mɨŋat amɨn kabɨni do japmɨ nandaŋek nandaban ɨŋanisi agɨt. ");
INSERT INTO yut_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Ae yopmaŋ degek yum pɨndagakwan Amɨn Ŋwakŋwarɨ Kabɨ da kɨsiron kɨwit. Aŋakwan uwalni dakon pɨŋbi egek geni guramɨkgwit. ");
INSERT INTO yut_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Uwal da jɨgɨ morapmɨ yomɨŋakwa uŋun dakon tapmɨm da yoŋgamgwan egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Bɨsap morapmɨ Yawe da mɨŋat amɨni paŋpulugagɨt, mani iyɨ dakon galaktok yolek kwen wɨgɨk aŋek yokwi morapmɨsi awit, do yokwisi egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Mani bɨsit awit bɨsapmon bɨsitni nandaŋ yomgut. Aŋek yokwisi egɨpgwit do bupmɨ nandaŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Bupmɨsi nandaŋ yomɨŋek saŋbek saŋbek agɨt uŋun do ae nandagɨt. Ae amɨn kabɨni do but dasi galak taŋ yomgut, do nandak nandakni ae kulabɨk agɨt. ");
INSERT INTO yut_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Aŋek uwal Israel amɨn dam tebanon yopgwit amɨn dakon burɨ paŋtobɨlban Israel amɨn do bupmɨ nandawit. ");
INSERT INTO yut_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Yawe Piŋkopnin, yokwikon baŋ tɨmɨkgi. Nin Amɨn Ŋwakŋwarɨ Kabɨ da binapmon ekwamaŋ, mani aego paŋmuwugek mɨktɨmninon paŋkɨ nipbi. Yaŋ aŋaki mango telagɨ do nandaŋek ya yaŋ gayɨneŋ, ae kɨsɨk kɨsɨk aŋek gak aŋkɨsineŋ. ");
INSERT INTO yut_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Yawe aŋkɨsineŋ. Uŋun Israel amɨn nin dakon Piŋkop abɨsok ae don egɨ aŋaŋ kɨneŋ kɨsi dakon. Amɨn morap kɨsi da yoni, “Uŋun asi!” Yawe aŋkɨsini! ");
INSERT INTO yut_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Yawe aŋpakni uŋun tagɨsisi, do ya yaŋ iyɨnisi. Dagok dagogɨ mɨni nin do but dasi galak taŋ nimɨsak. ");
INSERT INTO yut_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Mɨŋat amɨn morapyo, Yawe da nin uwal da kɨsiron baŋ pulugaŋ nipgut, do yaŋsi yaŋek mani aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Uŋun da ji mɨktɨm dubagɨkon egakwa tɨmɨk paŋopgut. Gɨldat wɨsak tet da, ae pɨgɨsak tet da, ae not tet da, ae saut tet da ji tɨmɨk paŋopgut. ");
INSERT INTO yut_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Dɨwarɨ mɨktɨm kɨbɨrɨ tɨmon agɨpgwit. Kokup pap kɨnda aŋalon aŋek uŋudon paŋkɨ egɨpni dakon kosit kɨnda dɨma kawit. ");
INSERT INTO yut_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Jap ae pakbiyo do obɨsi aŋek palɨ kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Yokwi yaŋsi egek, Yawe do yaŋ tɨdaŋba yokwikon baŋ pulugaŋ yopgut. ");
INSERT INTO yut_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Aŋek tɨmɨk kosit kɨlegɨ naŋ paŋpaŋ kokup pap kɨndakon kɨŋ altaŋek uŋudon egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Yawe da toktogɨsi but dasi galak taŋ yomɨsak ae amɨn kabɨni tagɨsi paŋpulugosok, do ya yaŋsi iyɨni. ");
INSERT INTO yut_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Nido mɨŋat amɨnyo pakbi do tegɨ kɨbɨdoŋ uŋun pakbi yoban naŋek yawokgoŋ, ae jap do aŋ amɨn jap morapmɨ yoban naŋek tugoŋ. ");
INSERT INTO yut_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Dɨwarɨ dam teban yutnon pɨlɨn tukgwan egɨpgwit. Amɨn da nap teban baŋ paŋteban aŋek jɨgɨ yomgwit. ");
INSERT INTO yut_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Nido, Piŋkop Wukwisi kwen wɨgɨk aŋ ɨmɨŋek geni abɨŋ yɨpgwit. ");
INSERT INTO yut_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Yaŋ aba Piŋkop da pi madepsi yoban jɨgɨsi nandawit. Aŋek mɨktɨmon maŋ pagakwa paŋpulugoni dakon amɨn mɨni. ");
INSERT INTO yut_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Yaŋ egek Yawe do yaŋ tɨdaŋba paŋpulugaŋek jɨgɨni uŋun wɨrɨrɨkban pasɨlgwit. ");
INSERT INTO yut_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Yawe da pɨlɨn tukgwan baŋ tɨmɨk paŋabɨŋek dam teban dakon nap tebani paŋdagagɨt. ");
INSERT INTO yut_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Yawe da toktogɨsi but dasi galak taŋ yomɨsak ae amɨn kabɨni tagɨsi paŋpulugosok, do ya yaŋsi iyɨni. ");
INSERT INTO yut_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Nido, yoma ain kɨnda mani bras uŋun baŋ dapmaŋ paŋteban abi uŋun tuwɨldak, ae dam teban yut dakon dam dakon ain oba paŋjokgal jokgal asak. ");
INSERT INTO yut_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Dɨwarɨ kwen wɨgɨk aŋek nandaŋ kokwini tagɨ dɨma amɨn dagawit. Gulusuŋ morapmɨ awit, do jɨgɨ tepmɨyo madepsi pawit. ");
INSERT INTO yut_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Jap nok do dɨma nandawit, do palɨsok kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Yokwi yaŋ egek Yawe do yaŋ tɨdaŋba jɨgɨni uŋun wɨrɨrɨkban pasɨlgwit. ");
INSERT INTO yut_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Iyɨ yaŋek gɨptɨmni paŋmɨlɨp aban kɨmakbi tamogwan dɨma pɨgɨwit. ");
INSERT INTO yut_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Yawe da toktogɨsi but dasi galak taŋ yomɨsak ae amɨn kabɨni tagɨsi paŋpulugosok, do ya yaŋsi iyɨni. ");
INSERT INTO yut_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Ya yaŋ iyɨk do paret anisi. Ae kap yaŋek kɨsɨk kɨsɨk aŋek yo tagɨsi agɨt uŋun do mɨŋat amɨnyokon yaŋ teŋteŋonisi. ");
INSERT INTO yut_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Dɨwarɨ tap binap tap wakgakon pi awit. Tap madepmon agek moneŋ ɨlɨt pi awit. ");
INSERT INTO yut_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Yawe da wasok agɨt uŋun pɨndakgwit. Tap ɨlarɨsikon wasok tapmɨmɨ toŋ agɨt uŋun pɨndakgwit. ");
INSERT INTO yut_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Yawe da yaŋban mɨrɨm madep aŋakwan tap pakbi da madepsi tamalɨkgwit. ");
INSERT INTO yut_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Aŋakwan tap wakga kwen aŋenakban wɨgɨgɨt, ae yɨpban yawok mibɨlɨkon pɨgɨgɨt. Yaŋ aŋakwan pasɨldamaŋ yaŋ nandaŋek but pasol madepsi awit. ");
INSERT INTO yut_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Pakbi teban morapmɨ naŋek obɨgɨ abɨgɨ aŋ uŋun da tɨlak tap wakgakon agɨpgwit. Ae tap wakga awɨl do aŋtɨdok awit. ");
INSERT INTO yut_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Yokwisi agek Yawe do yaŋ tɨdaŋba paŋpulugaŋban jɨgɨni pasɨl yomgwit. ");
INSERT INTO yut_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Mɨrɨm madep aŋyawot aban tap pakbi tamalɨkgɨt uŋun yaworɨ tagɨt. ");
INSERT INTO yut_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Tap pakbi kaŋba yaworɨsi taŋakwan but kwaktok nandawit. Yaŋ nandaŋakwa Yawe da dukwan kɨk do nandawit uŋun tamo tagɨsikon paŋkɨ yopban akgwit. ");
INSERT INTO yut_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Yawe da toktogɨsi but dasi galak taŋ yomɨsak ae amɨn kabɨni tagɨsi paŋpulugosok, do ya yaŋsi iyɨni. ");
INSERT INTO yut_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Piŋkop dakon mɨŋat amɨn kabɨ gat muwugek mani aŋkɨsinisi, ae kɨla amɨn muwut muwuron mani aŋkɨsinisi. ");
INSERT INTO yut_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Yawe da yaŋban pakbi madep kɨbɨdoŋ, ae pakbi dabɨl dugoŋ. ");
INSERT INTO yut_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Uŋun da yaŋban mɨktɨm pakbini toŋ uŋun da kulabɨk aban yosok kɨnda uŋudon dɨma kwosok. Uŋun mɨktɨm amɨn da aŋpak yokwi awit, do Yawe da jɨgɨ yaŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Yawe da yaŋban mɨktɨm kɨbɨrɨkon pakbi noman toŋ, ae mɨktɨm pakbini mɨnikon pakbi dabɨl morapmɨ noman taŋek pokgoŋ. ");
INSERT INTO yut_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Aŋakwa jap do aŋ amɨn paŋabɨŋ yopban uŋudon kokup pap kɨnda aŋek yɨkgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Yɨgek jap pi ae wain pi aŋek bamɨ ɨreŋɨsi paŋ. ");
INSERT INTO yut_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Yawe da paŋgɨsam aban mɨŋat monjɨyoni morapmɨ ɨreŋ toŋ, ae bulmakauniyo kɨsi yaŋ gɨn ɨreŋ toŋ. ");
INSERT INTO yut_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Mani don uwalni da pabɨŋ yopba kaloŋɨsok dagɨn egek bupmɨ nandaŋek yokwisi ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Yawe da kɨla amɨni pabɨŋ yopban mɨktɨm kɨbɨrɨ ae kosit mɨnikon ɨsal yumgɨn akwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Mani wadak wadak aŋ amɨn paŋpulugaŋban mɨŋat monjɨyoni uŋun sipsip da yaŋ ɨreŋ toŋ. ");
INSERT INTO yut_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Amɨn kɨlegɨ da Yawe dakon aŋpakni kaŋek but kwaktok nandaŋ. Mani yokwi pakpak amɨn uŋun gen kagani sopmaŋek gen dɨma yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Nandaŋ kokwinji tagɨsi amɨn, ji uŋun yo morap do pakyaŋsi nandaŋek egɨpni. Yawe da bɨsapmɨ bɨsapmɨ amɨn do but dasi galak taŋ yomɨsak uŋun do nandani. ");
INSERT INTO yut_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Dewit dakon kap kɨnda. Kap on Piŋkop gawak ɨmɨm dakon kap. Piŋkop, butnokon da gak do tebai nandaŋ gadasat. Asi, nak wagɨl gakdosi nandaŋ gadasat. Nak mango awɨgɨk do kap yokdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Nak pɨdaŋek dɨpmɨn yopbo kɨŋakwan gita gat kulele gat tɨdokeŋ. Wɨsa wɨsa do uŋun baŋ tɨdokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Yawe, nak Amɨn Ŋwakŋwarɨ Kabɨ da binapmon ya yaŋ gayɨkeŋ. Nak mɨŋat amɨn morap kabɨkon kɨŋek mango awɨgɨkdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Gak da nin do but dasi madepsi galak taŋ nimɨsal. Nin da uŋun dakon tɨlak yɨpneŋ kaŋ, kundu da arɨpmon wɨgɨkdɨsak. Gak toktogɨsi gengo yolek nin paŋpulugaŋek dɨma nipmaŋ dekdal. Nin da uŋun dakon tɨlak yɨpneŋ kaŋ, gɨkwem da arɨpmon wɨgɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Piŋkop, nak mɨŋat amɨnyo da mango madepsi awɨgɨni do nandɨsat. Tɨlɨmgo yɨpbɨ noman taŋakwan mɨŋat amɨnyo mɨktɨm morap kɨsikon ekwaŋ uŋun da koni. ");
INSERT INTO yut_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Gak da nin but dasi galak taŋ nimɨsal, do bɨsitno nandaki. Aŋek tapmɨm madepgokon da nin yokwikon baŋ tɨmɨgaki nin tagɨsi egɨpneŋ. ");
INSERT INTO yut_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Piŋkop telagɨ yutnikon egek yaŋ yosok, “Nak emaron kɨlɨ teban tat, do nak kɨsɨk kɨsɨk aŋek mɨŋat amɨno do Sekem mɨktɨm kokwinɨtdɨsat, ae Sukot mɨktɨm dakon kuldukgɨbaŋ kokwinɨk yomdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Gileat mɨktɨm gat Manase mɨktɨm gat uŋun nak dakon. Epraim mɨktɨm uŋun nak dakon busuŋ kutnokno. Aŋakwa Juda mɨktɨm uŋun kɨla amɨn madep kalɨŋ kɨrɨŋno. ");
INSERT INTO yut_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Moap mɨktɨm uŋun pakbi sogok ɨdapno. Ae Idom mɨktɨm uŋun kandap gwɨl yopyop tamono. Pilistia amɨn emaron pabɨŋ yopmaŋek kɨsɨk kɨsɨk aŋek yaŋ tɨdokdɨsat.” ");
INSERT INTO yut_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Piŋkop, namɨn da nak aŋaŋ kokup pap dam tebani toŋon tagɨ aŋkɨsak? Ae namɨn da nak Idom mɨktɨmon emat ak do tagɨ aŋkɨsak? ");
INSERT INTO yut_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Piŋkop, gak da nin manji kɨlɨ nimgul, ma? Nin dakon emat amɨn dɨma paŋpulugok do nandɨsal, ma? ");
INSERT INTO yut_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Amɨn dakon paŋpulugok uŋun yo ɨsalɨ gɨn, do nin paŋpulugaŋaki uwal gat emat tagɨ wamneŋ. ");
INSERT INTO yut_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Piŋkop da nin paŋpulugosak kaŋ, emaron teban toneŋ. Iyɨ uwalnin pabɨŋ yopdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Dewit dakon kap kɨnda. Kap on Piŋkop gawak ɨmɨm dakon kap. Kap yoŋ amɨn dakon kɨla amɨn do mandabi. Piŋkop, nak mango aŋkɨsisat. Manji dɨma namɨŋek bɨsitno nandaŋ nabi. ");
INSERT INTO yut_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Nido, amɨn yokwi da uwal aŋ namɨŋek amɨnon nak do top gen yoyaŋ. ");
INSERT INTO yut_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Uŋun nak do kuragɨsi nandaŋek gen yokwisi nayaŋ, mani uŋun gen dakon mibɨlɨ mɨni. ");
INSERT INTO yut_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Nak uŋun do butdasi galak taŋ yomɨŋek uŋun paŋpulugok do bɨsit asat, mani gen yaŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Nak aŋpak tagɨ baŋ aŋyomɨsat, mani kobogɨ yokwi baŋ aŋnamaŋ. Nak uŋun do but dasi galak taŋ yomɨsat, mani nak do kuragɨsi nandaŋ. ");
INSERT INTO yut_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Amɨn yokwi kɨnda manjɨkbɨ uŋun da uwalno tagɨ abɨŋ yɨpjak. Iyɨ dakon uwalni kɨnda da gen tagɨ yaŋ ɨmjak. ");
INSERT INTO yut_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Gen kokwin asak amɨn da uŋun amɨn gulusuŋni toŋ yaŋ kosak. Ae uŋun amɨn dakon bɨsitni kɨsi dɨwarɨni toŋ yaŋ kosak. ");
INSERT INTO yut_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Nak uŋun amɨn tepmɨsi kɨmagakwan amɨn ŋwakŋwarɨ da uŋun dakon pi tamo abɨdosak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Tepmɨ kɨmagakwan monjɨ gwayoni datni mɨni egɨpni, ae mɨŋatni sakwabat egɨpjak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Ae monjɨ gwayoni yutni mɨni ae amɨn da jap yomni do bɨsit yoyɨŋek egɨpni dosi nandɨsat. Ae yut tasɨk taŋbikon egɨpdaŋ uŋudon baŋ amɨn da yolakwa abɨgɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Uwalno goman amɨni da abɨŋ mɨktɨm ae yo morapni kɨsi tɨmɨtjak dosi nandɨsat. Aŋakwa kokup ŋwakŋwarɨkon amɨn da abɨŋ yo morapni yum do aŋek pi agɨt uŋun tagɨ tɨmɨtni. ");
INSERT INTO yut_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Amɨn kɨnda da aŋpak yaworɨ dɨma aŋ ɨmjak dosi nandɨsat. Ae amɨn kɨnda da monjɨ datni mɨni egɨpni uŋun do bupmɨ dɨma nandaŋ yomjak. ");
INSERT INTO yut_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Mɨŋat monjɨyoni tagɨ kɨmotni, aŋakwa amɨn don altoni da uŋun amɨn dakon man dɨma nandani dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Nak babɨkni da aŋpak yokwi awit do Yawe da uŋun do nandɨsak dosi nandɨsat. Aŋek meŋi dakon dɨwarɨni dɨma wɨrɨrɨk ɨmjak do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Yawe da dɨwarɨni do toktogɨsi nandaŋ yomjak, aŋakwan mɨŋat amɨnyo da uŋun dakon dɨwatni do wagɨlsi ɨŋtaŋ yomni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Uŋun amɨn, amɨn dɨwarɨ do aŋpak yaworɨ aŋ yom do dɨma nandagɨt. Uŋun yoni mɨni amɨn gat, ae yo do wadak wadak awit amɨn gat, ae butjɨk madepsi nandawit amɨn gat paŋsopmaŋek dapban kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Amɨn jobɨt yom do tagɨsi nandagɨt, do abɨsok iyɨ jobɨt pasak dosi nandɨsat. Piŋkop da amɨn dɨwarɨ gɨsamɨtjak do bɨsit ak do dɨma nandagɨt, do uŋunyo kɨsi Piŋkop dakon gɨsam dɨma tɨmɨtjak. ");
INSERT INTO yut_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Toktogɨsi amɨn dɨwarɨ jobɨt pani do yagɨt, uŋun gen yagɨt da iyɨ dakon ɨmalni agɨt. Uŋun gen yagɨt da gɨptɨm kaganigwan pakbi da yaŋ pɨgɨsak. Aŋek kɨdarɨgwan bɨt nelak da yaŋ pɨgɨsak. ");
INSERT INTO yut_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Jobɨt yagɨt uŋun naŋ ɨmalɨ do tagɨ baŋgaljak, aŋek bobaŋ nap naŋ yaŋ wamjak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Amɨn nak do gen yokwi yaŋek gen yaŋ namaŋ amɨn uŋun do Yawe da kobogɨ yaŋ aŋyomjak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Mani Amɨn Tagɨ Yawe, man bingo tagɨsi tosak do aŋek yo tagɨsi aŋ nabi. Gak nak do toktogɨsi but dasi galak taŋ namɨsal, do yokwikon naŋ abɨdoki. ");
INSERT INTO yut_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Nak wadak wadak amɨn. Butjɨk madepsi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Wupnin gɨldat paŋop do noman toŋ da gɨldat pɨgakwan pasɨlgaŋ uŋun da tɨlak nak pasɨl do asat. Nak pɨlak pɨlak kɨnda mɨrɨm da aŋkɨ maban kɨsak uŋun yombem. ");
INSERT INTO yut_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Nak gak do nandaŋek jap kelek egapbo ŋwak tukwalno tapmɨmɨ mɨni ak. Nak amɨn kɨdarɨ gɨn agɨm. ");
INSERT INTO yut_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Gen yaŋ namaŋ amɨn da nandaŋek jɨkgo yanjaŋ namaŋ. Busuŋ kwakwal aŋek jɨkgo yanjaŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Yawe Piŋkopno, gak da toktogɨsi nak but dasi galak taŋ namɨsal, do aŋpulugaŋek yokwikon naŋ abɨdoki. ");
INSERT INTO yut_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Uwalno burɨ paŋtobɨlbɨ gak dagɨn nak aŋpulugaŋek yokwikon naŋ abɨdosol yaŋsi nandaŋ gamni. ");
INSERT INTO yut_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Piŋkop da nak aŋupbal asak do yokdaŋ, mani gak da nak do yo tagɨ gɨn akdɨsal. Yokwi aŋ namaŋ amɨn pabɨŋ yopmaŋaki mayak tok pani do nandɨsat. Aŋaki pi amɨngo nak but kwaktok nandabeŋ. ");
INSERT INTO yut_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Uwalno da mayaktok baŋ ɨmal baŋ yaŋ pani, aŋakwa mɨŋat amɨnyo da mayaktokni uŋun pɨndatni. ");
INSERT INTO yut_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","31","Mani Yawe da wadak wadak amɨn paŋpulugaŋek kɨlani asak. Amɨn da gen yaŋ yomɨŋek kɨmotni do yaŋ dagok aŋakwa uŋun da kɨsiron baŋ tɨmɨkdak. Yaŋsi asak, do nak gen pap yaŋek Yawe ya yaŋ iyɨkeŋ. Mɨŋat amɨnyo da gak gawak gam do muwutni bɨsapmon mango aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Dewit dakon kap kɨnda. Kap on Piŋkop gawak ɨmɨm dakon kap. Yawe da nak dakon Amɨn Tagɨ yaŋ iyɨgɨt, “Gak abɨŋ nak da amɨnsi tet do yɨkgi. Aŋaki uwalgo dakon tapmɨm pabɨŋ yopbo gak dakon pɨŋbisi egɨpni.” ");
INSERT INTO yut_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Yawe Saion kokup papmon egɨsak. Uŋun da man madep gaban mɨktɨm madep kɨla akdɨsal. Ae yaŋ yosok, “Gak da uwalgo kɨla akdɨsal.” ");
INSERT INTO yut_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Uwalgo gat emat wamni bɨsapmon mɨŋat amɨn kabɨgo gat kɨŋek uŋun da but dasi nandaŋek gak aŋpulugokdaŋ. Gak kɨla amɨn madep dakon telagɨ ɨmalgo pakdɨsal. Kalbi morap gɨk sɨtnaŋ maŋek joŋ paŋkaluk aŋ, uŋun da tɨlak gak gɨldarɨ gɨldarɨ tapmɨm kalugɨ pakdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Yawe da gen yaŋ aŋteban aŋek nandak nandakni uŋun kulabɨk dɨma asak. Gen uŋun yaŋ yagɨt, “Melkisedek da mukwa sogok amɨn egɨpgut, uŋudeŋ gak mukwa sogok amɨn kɨnda dagok dagogɨ mɨni egɨ wɨgɨkdɨsal.” ");
INSERT INTO yut_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Amɨn Tagɨ gak aŋteban ak do gak da kapmatjok egɨsak. Butjap nandɨsak bɨsapmon kɨla amɨn madep madep gat emat wamaŋek obɨsi pabɨŋ yopdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Mɨktɨmɨ mɨktɨmɨ gen kokwin aŋyomɨŋek madepsi dapban kɨmotdaŋ. Mɨktɨmɨ mɨktɨmɨ kɨla amɨn madep madep obɨsi pabɨŋ yopdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Kosit ɨleŋon pakbi kɨnda pokdok uŋudon pakbi naŋ teban taŋek emaron teban tokdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Yawe dakon man aŋkɨsino! Mɨŋat amɨn kabɨnikon nak but dasi nandaŋek ya yaŋ iyɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Yawe uŋun pini wagɨl tagɨsi asak. Amɨn morap Piŋkop dakon pi do galak toŋ pini uŋun do nandaŋ ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Yo morap asak uŋun da tɨlɨmni aŋalon aban wagɨl tagɨsisi asak. Aŋpakni kɨlegɨ uŋun toktogɨsi taŋ aŋaŋ kɨsak. ");
INSERT INTO yut_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Yawe da mɨŋat amɨnyo dakon nandak nandakni paŋtagap aban yo madep madep agɨt uŋun do sigɨn nandaŋek ekwaŋ. Yawe bɨsapmɨ bɨsapmɨ nandaŋ yawok nimɨŋek nin do bupmɨ nandɨsak. ");
INSERT INTO yut_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Iyɨ do pasolgoŋ amɨn jap yomɨsak. Saŋbek saŋbek agɨt uŋun dɨma ɨŋtosok. ");
INSERT INTO yut_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Amɨn ŋwakŋwarɨ dakon mɨktɨm mɨŋat amɨni do yomɨŋek tapmɨmni madep aŋalon agɨt. ");
INSERT INTO yut_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Aŋpakni uŋun bamɨsi ae kɨlegɨsi. Gen morapni uŋun bamɨsi gɨn, do tagɨ guramɨtneŋ. ");
INSERT INTO yut_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Gen tebani uŋun bamɨsi ae toktogɨsi taŋ aŋaŋ kɨkdaŋ. Uŋun butdasi nandaŋek yol kɨmotneŋ do nimgut. ");
INSERT INTO yut_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Piŋkop da iyɨ dakon mɨŋat amɨn kabɨni yumaŋ nagɨt. Aŋek uŋun gat saŋbek saŋbek dagok dagogɨ mɨni agɨt. Piŋkop uŋun mani telagɨ ae masɨ masɨmɨ. ");
INSERT INTO yut_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Amɨn kɨnda nandaŋ kokwini tagɨsi amɨn kɨnda dagok do nandɨsak kaŋ, Yawe do pasal ɨmjak. Amɨn geni guramɨkgaŋ uŋun nandak nandak tagɨsi yomɨsak. Dagok dagogɨ mɨni mani aŋkɨsiŋ aŋaŋ kɨneŋ! ");
INSERT INTO yut_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Yawe aŋkɨsini! Amɨn morap Yawe do pasalek geni do galak toŋ uŋun kɨsɨk kɨsɨk tagɨ ani. ");
INSERT INTO yut_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Monjɨ gwayoni mɨŋat amɨnyo da binapmon man madepni toŋ da egɨpdaŋ. Amɨn kɨlegɨ uŋun dakon dɨwatni Piŋkop da yo tagɨsi aŋyomdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Yutnikon yo kabɨni morapmɨ taŋ ɨmni, ae aŋpakni tagɨsi uŋun do amɨn da dɨma ɨŋtoni. ");
INSERT INTO yut_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Pɨlɨn tukgwan teŋteŋɨ da altaŋek amɨn kɨlegɨ paŋpulugosok. Amɨn kɨlegɨ uŋun amɨn do nandaŋ yawot aŋ yomɨŋek bupmɨ nandaŋek kosit kɨlegɨ agɨsak. ");
INSERT INTO yut_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Amɨn kɨnda yo kabɨni amɨn do yum yomɨsak, bo ae goman do yaŋba nandaŋ yomɨsak, ae yumaŋ gwayek kosit kɨlegɨkon da asak uŋun amɨn tagɨsi egɨpjak. ");
INSERT INTO yut_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Uŋun amɨn tebaisi atjak. Aŋakwan man bini don taŋ aŋaŋ kɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Gen bin yokwi nandɨsak bɨsapmon pasol pasol dɨma asak. Yawe tebaisi nandaŋ gadaŋ ɨmɨsak. ");
INSERT INTO yut_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Uŋun tebaisi agek pasol pasol dɨma nandɨsak. Ae uwalni emaron arɨpmɨ dɨma teban tokdaŋ yaŋ nandɨsak. ");
INSERT INTO yut_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Yoni mɨni amɨn do yo morapmɨ yomɨsak. Man bini amɨn da binapmon taŋakwan uŋun do nandaba wukwan ɨmaŋ. Aŋpakni tagɨsi uŋun do amɨn da dɨma ɨŋtoni. ");
INSERT INTO yut_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Yokwi pakpak amɨn da uŋun kaŋek but jap nandaŋ. Yaŋ aŋek mam naŋ yomɨŋek gɨptɨmni maŋ mudoŋ. Yo ak do nandaŋ uŋun suŋ toŋ. ");
INSERT INTO yut_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Yawe aŋkɨsini. Oman amɨni ji Yawe aŋkɨsini. Mani aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Dagok dagogɨ mɨni Yawe dakon man aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Gɨldat da wɨsak tetgɨn ae pɨgɨsak tetgɨn mɨŋat amɨn morap ekwaŋ kɨsi da Yawe aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Yawe uŋun mɨktɨmɨ mɨktɨmɨ man madepni tosok. Tɨlɨmni uŋun kundu si yapmaŋek wagɨl tagɨsisi. ");
INSERT INTO yut_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Yawe Piŋkopnin egɨsak, uŋun yombem kɨnda mɨni. Uŋun kwensi kɨla amɨn madep yɨtyɨt tamonikon yɨkdak. ");
INSERT INTO yut_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Uŋudon da mibɨlɨsigwan sɨŋtaŋek kundu gat mɨktɨm gat pɨndakdak. ");
INSERT INTO yut_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Aŋek yoni mɨni amɨn sɨbɨt sɨbɨt tamokon ekwaŋ uŋun paŋpulugaŋek ");
INSERT INTO yut_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","iyɨ dakon mɨŋat amɨn kabɨni dakon kɨla amɨn gat yopban tagɨsi ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Mɨŋat monjɨ suŋ ekwaŋ uŋun paŋpulugaŋban monjɨ morapmɨ paŋalaŋek kɨsɨk kɨsɨk madepsi aŋ. Yawe aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Israel amɨn kalɨp Isip yɨpmaŋ degek kɨwit. Jekop dakon dɨwatni da amɨn gen ŋwakŋwarɨ yoŋ kabɨ dakon kokup yɨpmaŋek kɨwit. ");
INSERT INTO yut_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Yaŋ awit bɨsapmon Juda mɨŋat amɨnyo Yawe dakon telagɨ yut dagawit. Israel amɨn Piŋkop da kɨla agɨt. ");
INSERT INTO yut_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Tap Ɨdap Gami Israel amɨn pɨndagek pasal kɨgɨt. Ae Jodan Pakbi ɨsal taŋek dɨma pak kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Kabap uŋun meme da yaŋ wɨgɨ mokmok awit, ae ɨleŋ uŋun sipsip da yaŋ wɨgɨ mokmok awit. ");
INSERT INTO yut_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Tap Gami gak yo ni da noman taŋban pasal kɨgɨl? Jodan Pakbi gak nido dɨma pak kɨgɨl? ");
INSERT INTO yut_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Kabap morap nido meme da yaŋ wɨgɨ mokmok awit? Ae ɨleŋ monɨŋ monɨŋ ji nido sipsip da yaŋ wɨgɨ mokmok awit? ");
INSERT INTO yut_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Mɨktɨm daman, abɨsok Amɨn Tagɨ abɨsak, do gak wudɨp aki. Jekop dakon Piŋkop uŋun kɨlɨ abɨk, do gak wudɨp aki. ");
INSERT INTO yut_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Uŋun da tɨp kulabɨk aban pakbi ɨdap monɨŋ kɨnda dagagɨt. Aŋek tɨp tebanon wasok aban pakbi dabɨl noman tagɨt. ");
INSERT INTO yut_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Piŋkop gak bɨsapmɨ bɨsapmɨ nin do but dasi galak taŋ nimɨŋek dɨma nipmaŋ dekdal. Yaŋ asal do nin dakon man dɨma pawɨgɨneŋ. Gak dakon man madepgo naŋgɨn aŋkɨsineŋ. ");
INSERT INTO yut_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Amɨn Ŋwakŋwarɨ Kabɨ da “Piŋkopji dukwan egɨsak?” nido yaŋ niyaŋ? ");
INSERT INTO yut_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Piŋkopnin Kwen Kokup egɨsak. Uŋun yo kɨnda ak do nandɨsak kaŋ si akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Amɨn Ŋwakŋwarɨ Kabɨ kokup kɨdatni dakon wupmɨ uŋun gol ae silwa baŋ wasoŋ. Uŋun amɨn kɨsit da wasoŋ. ");
INSERT INTO yut_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Kokup kɨdat dakon wup uŋun gen kagani toŋ, mani gen arɨpmɨ dɨma yoni. Dabɨlni toŋ mani arɨpmɨ dɨma sɨŋtoni. ");
INSERT INTO yut_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Mɨrakni toŋ, mani gen arɨpmɨ dɨma nandani. Uŋun tomnoni toŋ, mani yo dakon kɨbaŋɨ arɨpmɨ dɨma nandani. ");
INSERT INTO yut_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Uŋun kɨsitni toŋ mani yo arɨpmɨ dɨma ɨgayɨni. Ae kandapni toŋ, mani kosit arɨpmɨ dɨma agɨpni. Ae gen kɨnda tegɨkon da dɨma noman tokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Kokup kɨdat dakon wupmɨ wasoŋ amɨn uŋun kokup kɨdat wup yombem aŋ. Ae amɨn morap egɨp egɨpni kokup kɨdaron toŋ yaŋsi nandaŋ uŋun kɨsi kokup kɨdat yombem gɨn aŋ. ");
INSERT INTO yut_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Israel mɨŋat amɨn kabɨ, egɨp egɨpji Yawekon tosok yaŋsi nandani. Uŋun da ji paŋpulugaŋek paŋkutnosok. ");
INSERT INTO yut_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Piŋkop dakon mukwa sogok amɨn Aron da kabɨkon nani, egɨp egɨpji Yawekon tosok yaŋsi nandani. Uŋun da ji paŋpulugaŋek paŋkutnosok. ");
INSERT INTO yut_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Yawe do pasolgoŋ amɨn kabɨ, egɨp egɨpji Yawekon tosok yaŋsi nandani. Uŋun da ji paŋpulugaŋek paŋkutnosok. ");
INSERT INTO yut_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Yawe da nin sigɨn nandaŋ nimɨŋek gɨsamɨtjak. Uŋun da Israel mɨŋat amɨn kabɨ gat ae Aron dakon amɨn kabɨ kɨsi gɨsamɨtjak. ");
INSERT INTO yut_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Yawe da amɨn mani toŋ ae mani mɨni iyɨ do pasal ɨmaŋ amɨn uŋun kɨsisi gɨsamɨtjak. ");
INSERT INTO yut_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Yawe da ji gat ae gwakji gat morapmɨsi paŋɨreŋ asak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Yawe Kwen Kokup ae mɨktɨmyo wasagɨt uŋun da ji gɨsamɨtjak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Kwen Kokup kwensi ason tosok uŋun Yawe iyɨ dakon. Mani mɨktɨm uŋun amɨn nin do nimgut. ");
INSERT INTO yut_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Amɨn kɨmakbi gen wayɨŋyo mɨni tamo uŋungwan pɨgek Yawe dɨma aŋkɨsaŋ. ");
INSERT INTO yut_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Mani nin abɨsok ae don dagok dagogɨ mɨni Yawe aŋkɨsineŋ. Yawe aŋkɨsini! ");
INSERT INTO yut_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Yawe da bɨsitno nandɨsak, do nak but dasi galak taŋ ɨmɨsat. Asisi, bɨsitno nandɨsak. ");
INSERT INTO yut_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Nagon tobɨlek bɨsitno nandagɨt, do mɨktɨmon egɨpbeŋ bɨsapmon bɨsit dɨma yɨpmaŋ dekgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Kɨmot da nak nap da yaŋ wamgut. Nak kɨmakbi kokup do nandaŋek pasol pasol madepsi agɨm. Yaŋ aŋek nandaba kɨk madepsi agɨm. ");
INSERT INTO yut_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Yaŋ nandaŋ egek Yawe yaŋ iyɨgɨm, “O Yawe, pulugaŋ nepbi!” ");
INSERT INTO yut_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Yawe da nin nandaŋ yaworon dasi yo tagɨsisi aŋnimɨsak. Piŋkopnin da bupmɨ nandaŋ nimɨsak. ");
INSERT INTO yut_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Yawe da nandak nandakni mɨni amɨn paŋkutnosok. Kalɨp tapmɨmno mɨni da egapbo pulugaŋ nepgut. ");
INSERT INTO yut_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Yawe da nak do yo tagɨsisi aŋ namgut, do butno aeni yaworɨsi tosok. ");
INSERT INTO yut_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Yawe, pulugaŋ nepbɨ dɨma kɨmakgɨm. Yaŋ aŋek dabɨl pakbino wɨrɨrɨgek kɨlano aŋaki dɨma kesal nɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Yaŋdo, nak mɨktɨmon egɨpbeŋ bɨsapmon Yawe gat kaloŋɨ agɨpdeŋ. ");
INSERT INTO yut_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Nak Piŋkop nandaŋ gadaŋ ɨmɨŋek bɨsit yaŋ agɨm, “Yawe, nak jɨgɨsi nandaŋek egɨsat.” ");
INSERT INTO yut_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Ae si pasalgɨm bɨsapmon yaŋ yagɨm, “Amɨn kɨsi morap uŋun top amɨn gɨn.” ");
INSERT INTO yut_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Yawe da nak do yo tagɨsi aŋ namɨsak, do kobogɨ do yo ninaŋ ɨbeŋ? ");
INSERT INTO yut_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Yawe da nak yokwikon naŋ abɨdagɨt, do ya yaŋ iyɨŋek paret ak do wain kap aŋenokgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Mɨŋat amɨn kabɨni abɨŋ muwutni da dabɨlon nak kalɨp Yawe do yo ak do yaŋ teban tok agɨm uŋun abo pɨndatdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Yawe dakon telagɨ amɨn uŋun iyɨ dakon wam tabɨlni, do kɨmokgoŋ bɨsapmon pɨndakban yo madepsi aŋ. ");
INSERT INTO yut_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Yawe, nak gak dakon oman monjɨgo. Meŋno da kalɨp gak dakon pi agɨt, abɨsok monji nakyo kɨsi pigo asat. Nak nap tebanon egapbo pulugaŋ nepgul. ");
INSERT INTO yut_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Nak ya yaŋ gayɨŋek paret aŋek mangokon da bɨsit abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Mɨŋat amɨn kabɨni abɨŋ muwutni da dabɨlon nak kalɨp Yawe do yo ak do yaŋ teban tok agɨm uŋun abo pɨndatdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Yawe, nak Jerusalem kokup papmon gak da telagɨ yutnon paret uŋun abeŋ. Yawe aŋkɨsini! ");
INSERT INTO yut_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Mɨŋat amɨn kabɨ morap egɨ aŋaŋ kwaŋ, ji Yawe aŋkɨsini. Mɨktɨmɨ mɨktɨmɨ mɨŋat amɨn morap ji mani yaŋ aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Nin do but dasi galak taŋ nimɨsak. Bɨsapmɨ bɨsapmɨ geni guramɨk kɨmagek nin dɨma nipmaŋ dekdak. Yawe aŋkɨsini! ");
INSERT INTO yut_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Yawe aŋpakni uŋun tagɨsi, do ya yaŋ iyɨni. Dagok dagogɨ mɨni nin do but dasi galak taŋ nimɨsak. ");
INSERT INTO yut_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Israel amɨn ji yaŋ yoni, “Dagok dagogɨ mɨni nin do but dasi galak taŋ nimɨsak.” ");
INSERT INTO yut_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Piŋkop dakon mukwa sogok amɨn kabɨni yaŋ yoni, “Dagok dagogɨ mɨni nin do but dasi galak taŋ nimɨsak.” ");
INSERT INTO yut_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Mɨŋat amɨnyo morap Yawe do pasal ɨmaŋ amɨn yaŋ yoni, “Dagok dagogɨ mɨni nin do but dasi galak taŋ nimɨsak.” ");
INSERT INTO yut_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Nak jɨgɨno madepsi, do Yawe bɨsit iyɨko nandaŋek jɨgɨno uŋun wɨrɨrɨkban pasɨlgwit. ");
INSERT INTO yut_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Yawe nak gat egɨsak, do arɨpmɨ dɨma pasolgeŋ. Amɨn da nak do yo kɨnda arɨpmɨ dɨma ani. ");
INSERT INTO yut_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Yawe paŋpulugokno nak gat egɨsak. Kaŋapbo Yawe da uwalno pabɨŋ yopdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Paŋkutnosak do Yawekon kɨneŋ kaŋ tagɨsi. Egɨp egɨpnin amɨn kɨndakon tosok yaŋ nandaneŋ kaŋ, uŋun da tagɨ dɨma. ");
INSERT INTO yut_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Paŋkutnosak do Yawekon kɨneŋ kaŋ tagɨsi. Egɨp egɨpnin kɨla amɨn madep kɨndakon tosok yaŋ nandaneŋ kaŋ, uŋun da tagɨ dɨma. ");
INSERT INTO yut_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Uwal morapmɨ da nak aŋgwasɨwit, mani Yawe da manon dapbo pasɨlgwit. ");
INSERT INTO yut_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Terɨ terɨ kɨsi da nak aŋgwasɨwit, mani Yawe da manon dapbo pasɨlgwit. ");
INSERT INTO yut_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Kabaŋ morapmɨ da yaŋ nak aŋgwasɨwit. Mani joŋ kɨbɨrɨ soŋba soŋek tepmɨ pasɨlgaŋ, uŋun da tɨlak tepmɨ kɨmakgwit. Yawe da manon dapbo pasɨlgwit. ");
INSERT INTO yut_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Nak gat emat madepsi wamaŋek abɨŋ nep do aba nandagɨm. Mani Yawe da nak aŋpulugagɨt. ");
INSERT INTO yut_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Yawe da tapmɨm madepsi namɨsak. Iyɨ nak yokwikon naŋ pulugaŋ nepmaŋdak. ");
INSERT INTO yut_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Piŋkop dakon mɨŋat amɨn kabɨni da ɨmal yutnigwan kɨsɨk kɨsɨk aŋek yaŋ tɨdoŋ do nandaki. Yaŋ yoŋ, “Yawe dakon tapmɨm madepni da yo uŋun agɨt! ");
INSERT INTO yut_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Yawe dakon tapmɨm madepni da nin paŋpulugaŋban emaron teban tagɨmaŋ! Yawe dakon tapmɨm madepni da yo uŋun agɨt!” ");
INSERT INTO yut_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Nak dɨma kɨmokgeŋ. Nak egek Yawe da yo agɨt uŋun do yaŋ teŋteŋok abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Yawe da nak aŋkɨlek ak do yo yokwisi aŋnamgut, mani yum nandaŋakwan dɨma kɨmakgɨm. ");
INSERT INTO yut_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Wigat amɨn kɨlegɨ da tagɨ pɨgɨgɨ uŋun wɨtdal namɨŋaki pɨgek Yawe ya yaŋ iyɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Uŋun Yawe dakon wigat. Amɨn kɨlegɨ da uŋun naŋ tagɨ pɨgɨni. ");
INSERT INTO yut_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Gak bɨsitno nandaŋek yokwikon naŋ pulugaŋ nepgul, uŋun do ya yaŋ gayɨsat. ");
INSERT INTO yut_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Yut agak amɨn da gwak yokwi yaŋ yaŋek maba kɨgɨt, uŋun gwak tɨp kɨnda naŋ tɨdawit da akdak. ");
INSERT INTO yut_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Yawe da iyɨ yo uŋun aban nin da kono yo masɨ masɨmɨsi asak. ");
INSERT INTO yut_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Yawe on gɨldat uŋun nin do nimɨk. Nin kɨsɨk kɨsɨk aŋek but galak nandaneŋ. ");
INSERT INTO yut_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Yawe, gak da nin yokwikon baŋ tɨmɨkgi do gayamaŋ. Gak da nin paŋpulugaŋbɨ yo morap ano tagɨsi gɨn noman toni. ");
INSERT INTO yut_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Yawe da manon abɨsak amɨn uŋun Piŋkop da yo tagɨsi aŋ ɨmjak. Yawe da yutnon nin mani aŋkɨsineŋ. ");
INSERT INTO yut_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Yawe uŋun Piŋkop. Uŋun da teŋteŋɨ nimɨsak. Kɨndap kɨlɨŋ tɨmɨgek kɨŋ alta aŋgwasɨni. ");
INSERT INTO yut_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Gak Piŋkopno, do ya yaŋ gayɨsat. Gak Piŋkopno, do mango awɨgɨsat. ");
INSERT INTO yut_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Yawe aŋpakni uŋun tagɨsi, do ya yaŋ iyɨni. Dagok dagogɨ mɨni nin do but dasi galak taŋ nimɨsak. ");
INSERT INTO yut_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Amɨn kosit kɨlegɨkon akwaŋ, ae gulusuŋni mɨni, ae Yawe dakon gen teban guramɨkgaŋ, uŋuden amɨn kɨsɨk kɨsɨk ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Amɨn Piŋkop dakon gen guramɨgek but dasi nandaŋek yolgaŋ uŋuden amɨn kɨsɨk kɨsɨk ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Uŋuden amɨn gulusuŋ kɨnda dɨma aŋ. Yawe dakon aŋpak baŋgɨn yolgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Gak da gen morapgo nimɨŋek nin da kɨlani tagɨsi aŋek guramɨtneŋ dosi gen teban yɨpgul. ");
INSERT INTO yut_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Gak dakon gen si teban taŋek guramɨk kɨmokgeŋ dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Nak yaŋ abeŋ kaŋ, gak dakon gen teban do nandaŋ egɨpbeŋ bɨsapmon mayagɨ dɨma pakeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Gen tebango kɨlegɨ do pini aŋek nandabo pɨsosak bɨsapmon butno kɨlegɨsi taŋakwan mango aŋenokgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Nak gen tebango kɨsi morap guramɨkgeŋ. Wagɨl dɨma nepmaŋ dekgi. ");
INSERT INTO yut_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Niaŋ aŋek monjɨ gɨmoŋɨ da aŋpak kɨlegɨ gɨn aŋek egɨpni? Gak dakon gen guramɨgek kaŋdo kɨlegɨsi egɨpni. ");
INSERT INTO yut_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Nak but dasi nandaŋek gak wɨsɨŋ gandak do pi asat. Aŋpulugaŋaki gak dakon gen teban dɨma yɨpmaŋ dekgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Nak yokwi kɨnda dɨma aŋgabeŋ do aŋek gengo butnokon yopgum. ");
INSERT INTO yut_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Yawe mango aŋkɨsisat. Gen tebango nayɨŋ dekgi. ");
INSERT INTO yut_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Gen teban morap niyɨgɨl uŋun mɨŋat amɨn morapyo yoyɨŋ teŋteŋosot. ");
INSERT INTO yut_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Nak amɨn da moneŋ ae yo galagɨsi do galak toŋ, nak uŋun da tɨlak gak dakon gen guramɨt do galagɨsi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Nak gengo do pakyaŋsi nandaŋ egɨsat. Ae aŋpakgo do nandaŋ egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Nak gen tebango do galagɨsi nandɨsat. Uŋun dɨma ɨŋtokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Oman amɨngo nak do yo tagɨsi aŋ nabi. Yaŋ aŋaki nak kalugɨ egek gengo guramɨkgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Nandak nandakno dakon yoma wɨtdalaki nawa gengokon gen wagɨl tagɨsi morap toŋ uŋun arɨpmɨ tagɨ nandaŋ pɨsokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Nak on mɨktɨmon mɨktɨm ŋwakŋwarɨkon amɨn kɨnda da egɨsat. Do gen tebango dɨma aŋkɨsɨbɨŋ nabi. ");
INSERT INTO yut_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Butnokon da gɨldarɨ gɨldarɨ gak dakon gen teban yol do tek kɨndap pasat. ");
INSERT INTO yut_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Gak da iyɨ do nandaba wɨkwaŋ amɨn gen tebai yoyɨsal. Uŋun amɨn jobɨrɨ toŋ, ae gen tebango manji yomɨŋek iyɨ da galak togon akwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Uŋun da jɨgɨlak yaŋ namɨŋek nabɨpmaŋgaŋ. Mani gak dakon gen teban yoldat, do yum pɨndagaki gen uŋuden dɨma nayɨni. ");
INSERT INTO yut_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Kɨla amɨn muwugek nak dakon man abɨŋ yɨpmaŋgaŋ. Mani oman amɨngo nak toktogɨ gak dakon gen do nandakeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Gak dakon gen do but dasi galak tosot. Gengo da kosit kɨlegɨ agɨpbeŋ do nayɨŋ dekdak. ");
INSERT INTO yut_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Nak kɨmbabaŋon yokwisi pokdot. Yaŋ teban tok agɨl uŋun da arɨpmon abɨ pɨdaŋapbo aŋteban aki. ");
INSERT INTO yut_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Aŋpak morapno do gayɨko kobogɨ paŋtobɨl namgul. Gengo nayɨŋ dekgi. ");
INSERT INTO yut_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Nayɨŋ dekbɨ gengo dakon mibɨlɨ nandaŋ pɨsokeŋ. Ae wasok tapmɨmɨ toŋ morapgo uŋun do nandaŋ egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Butno jɨgɨsi asak. Yaŋ teban tok agɨl uŋun da arɨpmon nak aŋteban aki. ");
INSERT INTO yut_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Aŋpak toptopmɨ yolbɨ nak da dubagɨkon kɨŋ mudoni. Aŋpak tagɨsi aŋ namɨŋek nawa gengo do nayɨŋ dekgi. ");
INSERT INTO yut_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Nak gak gol do gen yaŋ aŋteban agɨm. Toktogɨsi nawa gengo dogɨn nandaŋ egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Yawe, gengo uŋun guramɨk kɨmokdot. Aŋkutnaŋaki mayaktok dɨma pakeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Gen tebango tepmɨsi guramɨtdɨsat. Nido, gak da nandak nandak dɨ gat saŋbeŋek namdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Yawe, gengo nayɨŋ dekbɨ guramɨk egapbo bɨsapno mudosak. ");
INSERT INTO yut_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Nawa gengo dakon mibɨlɨ nolɨŋbɨ but dasi nandaŋek guramɨkgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Gak dakon gen teban do galagɨsi nandɨsat, do uŋun dakon kosit nolɨŋbɨ uŋun naŋ kɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Butno aŋtagap abɨ gak dakon gen do galagɨ nandaŋek yo do pɨndak galaktok dɨma abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Aŋpulugaŋaki yo ɨsalɨ do pɨndak galak tok dɨma abeŋ. Yaŋ teban tok agɨl uŋun da arɨpmon egɨp egɨpno aŋkutnoki. ");
INSERT INTO yut_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Oman amɨngo nak do yo ak do yaŋ teban tok agɨl uŋun da arɨpmon aŋaki amɨn da pasal gamni. ");
INSERT INTO yut_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Nawa gengo uŋun tagɨsi. Aŋpulugaŋbɨ mayaktok dɨma pakeŋ. Mayagɨ pak do si pasoldot. ");
INSERT INTO yut_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Gengo guramɨt do galagɨsi nandɨsat. Aŋpakgo kɨlegɨsi, do egɨp egɨpno aŋkutnoki. ");
INSERT INTO yut_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Yawe, bɨsapmɨ bɨsapmɨ nak do but dasi galak taŋ nabi, aŋek nak yokwikon naŋ abɨdoki dosi nandɨsat. Gak yaŋ ak do kɨlɨ yaŋ teban tagɨl. ");
INSERT INTO yut_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Nawa gengo do nandaŋ dagosot. Do aŋpulugaŋaki nabɨpmaŋgaŋ amɨn do gen kobogɨ arɨpmɨ tagɨ paŋtobɨl yobeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Nawa gengo da nak tagɨ aŋpulugosak yaŋ nandaŋ teban taŋek jomjom asat. Do aŋteban aŋaki bɨsapmɨ bɨsapmɨ gengo bamɨ yaŋ teŋteŋokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Bɨsap dagok dagogɨ mɨni nawa gengo guramɨk kɨmokgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Gengo guramɨt do pini asat, do yo yokwi kɨnda da kosit dɨma sopmaŋ namjak. ");
INSERT INTO yut_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Nak da kɨla amɨn madep gengo do yoyɨkeŋ. Uŋun da mayagɨ dɨma namni. ");
INSERT INTO yut_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Gen tebango do but galaksi nandɨsat. Gen teban morapgo uŋun do but dasi galak tosot. ");
INSERT INTO yut_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Gen tebango uŋun tagɨsi yaŋ nandaŋek, uŋun do but dasi galak taŋ kɨmokdot. Gengo uŋun do nandaŋ egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Gak oman amɨngo nak do kalɨp yaŋ teban tok agɨl uŋun do nandaki. Uŋun da nak aŋtagap aban tagɨsi egɨpbeŋ yaŋsi nandaŋ teban taŋek jomjom asat. ");
INSERT INTO yut_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Yaŋ teban tokgo da egɨp egɨp namɨsak. Jɨgɨ pasat bɨsapmon uŋun da butno aŋteban asak. ");
INSERT INTO yut_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Iyɨ do nandaba wɨkwaŋ amɨn da yaŋsul yokwisi aŋ namaŋ. Mani nawa gengo do manji dɨma yomɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Yawe, gak dakon nawa gen kalɨpmɨsi uŋun do nandaŋ egɨsat. Uŋun da butno aŋteban asak. ");
INSERT INTO yut_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Amɨn yokwi da nawa gengo manji yomɨŋakwa japmɨsi nandaŋ yomɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Nak kokupno da dubagɨkon egek gengo do kap yosot. ");
INSERT INTO yut_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Yawe, nak kalbi mango do nandak nandak aŋek nawa gengo yoldat. ");
INSERT INTO yut_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Gak dakon gen guramɨkdat. Uŋun da but galak namɨsak. ");
INSERT INTO yut_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Yawe, gak nak gat egɨsal, do yo do wadak wadak dɨma asat. Gengo yol do yaŋ teban tok asat. ");
INSERT INTO yut_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Gak da nandaŋ yawot aŋ nabi do yaŋ teban tok agɨl, do yaŋsi abi do bɨsit gayɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Aŋpak morapno do kɨlɨ nandagɨm, aŋek tobɨlek gengo guramɨt do agɨm. ");
INSERT INTO yut_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Jomjom dɨma abeŋ. Gen tebango tepmɨsi guramɨkgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Amɨn yokwi da nap naŋ nak aŋteban aŋek aŋpak yokwinikon ɨlɨk aŋaŋ kɨk do aŋ, mani nawa gengo do dɨma ɨŋtosot. ");
INSERT INTO yut_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Kalbi binap nawa gengo kɨlegɨsi do ya yaŋ gayɨk do pɨdosot. ");
INSERT INTO yut_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Amɨn morap gak do pasalek gengo guramɨkgaŋ amɨn not aŋ yomɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Yawe, gak da mɨktɨmon mɨŋat amɨn morap kɨsi do but dasi galak taŋ yomɨsal. Gengo do nayɨŋdet abi. ");
INSERT INTO yut_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Yawe, yaŋ teban tok agɨl uŋun da arɨpmon oman amɨngo nak do aŋpak tagɨsi aŋ namgul. ");
INSERT INTO yut_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Gen tebango do nandaŋ gadasat. Do nandak nandak gat ae gen kokwin tagɨsi agak dakon nandak nandak do nayɨŋ dekgi. ");
INSERT INTO yut_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Nak aŋkɨlek akdo pi dɨma agɨl bɨsapmon kositgo yapgum. Mani abɨsok gengo guramɨkdat. ");
INSERT INTO yut_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Gak tagɨsi, do yo asal uŋun tagɨsi baŋ asal. Gengo do nayɨŋ dekgi. ");
INSERT INTO yut_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Iyɨ do nandaba wɨkwaŋ amɨn da top morapmɨ yaŋ namgwit. Mani but dasi nandaŋek gengo guramɨkdat. ");
INSERT INTO yut_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Uŋun amɨn nandak nandakni kɨlegɨ mɨni. Mani nawa gengo do but dasi galak tosot. ");
INSERT INTO yut_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Gak da jɨgɨ namgul uŋun tagɨsi agɨl. Uŋun da gengo do nayɨŋdet tagɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Nawa gengo do nandako yo madepsi asak. Uŋun da gol ae silva moneŋ morapmɨsi yapmaŋdak. ");
INSERT INTO yut_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Kɨsitgo da nak wasagɨl. Nandak nandak namɨŋaki gen teban morapgo nandaŋ pɨsokeŋ do pi tagɨsi abeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Gengo da nak tagɨ aŋpulugosak yaŋ nandaŋ teban taŋek jomjom asat. Do mɨŋat amɨn morap gak do pasolgoŋ amɨn nak nandani bɨsapmon kɨsɨk kɨsɨk ani dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Yawe, nak nandɨsat, gak dakon gen teban morap uŋun kɨlegɨsi gɨn. Gak gengo yolek aŋpakno aŋmɨlɨp ak do aŋek jɨgɨ namgul. ");
INSERT INTO yut_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Gak nak do toktogɨsi but dasi galak taŋ nam do yaŋ teban tok kɨlɨ agɨl. Do gen yagɨl da arɨpmon nak oman amɨngo dakon but aŋteban abi dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Nawa gengo do but dasi galak tosot. Do nak do bupmɨ nandaŋaki tagɨsi egɨpbeŋ dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Iyɨ do nandaba wɨkwaŋ amɨn da top yaŋek ɨsal dogɨn abɨŋ nepgwit. Aŋpakni uŋun do gak da paŋmayak abɨ mayak toni dosi nandɨsat. Mani, nak toktogɨsi gengo do nandaŋ egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Namɨn amɨn da gak do pasolgoŋ ae gak dakon gen teban nandaŋ uŋun da nagon apni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Aŋpulugaŋaki gen teban morapgo guramɨgek aŋpakno do mayaktok dɨma pakeŋ dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Gak da nak yokwikon naŋ abɨdoki do jomjom aŋek butjɨksi nandɨsat, aŋek tapmɨmno mɨnisi ayɨŋ. Mani gengo da nak tagɨ aŋpulugosak yaŋ nandaŋ teban taŋek jomjom asat. ");
INSERT INTO yut_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Gak da yaŋ teban tok agɨl uŋun arɨpmɨ akdɨsal yaŋ do jomjom aŋek sɨŋtaŋ egɨt da dabɨlno tep namaŋ. Aŋek yaŋ yosot, “Ni bɨsapmon butno aŋteban abi?” ");
INSERT INTO yut_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Nak wain tɨbɨt meme gɨp baŋ wasaŋbi kalɨpmɨ kɨnda amɨn da mukwakon yɨpba teban taŋbi yombem. Mani gen tebango do dɨma ɨŋtosot. ");
INSERT INTO yut_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Bɨsap niaŋ da oman amɨngo nak jomjom sigɨn abeŋ? Yo yokwi aŋ namaŋ amɨn do ni bɨsapmon kobogɨ yokwi aŋ yobi? ");
INSERT INTO yut_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Iyɨ do nandaba wɨkwaŋ amɨn, nawa gengo dɨma guramɨkgaŋ. Nak da mokeŋ do gapma wayɨkgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Mɨŋat amɨnyo nin da gen teban morapgo tagɨ nandaŋ gadaneŋ. Amɨn da ɨsal dogɨn yokwi aŋ namaŋ, do aŋpulugoki do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Palɨsok nɨkba kɨmakgɨm, mani gengo dɨma yɨpmaŋ dekgɨm. ");
INSERT INTO yut_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Nak do toktogɨsi but dasi galak taŋ namɨsal, do aŋpulugaŋaki dɨma kɨmokgeŋ. Yaŋ aŋaki gen teban morapgo guramɨkgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Yawe, gak dakon gengo toktogɨsi taŋ aŋaŋ kɨkdɨsak. Uŋun Kwen Kokup tebaisi tosok. ");
INSERT INTO yut_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Aŋpakgo tagɨsi uŋun amɨn don altaŋek egɨpdaŋ kabɨkon toktogɨsi taŋ aŋaŋ kɨkdɨsak. Mɨktɨm yɨpgul da tamonikon taŋek dɨma dɨwalɨk kɨsak. ");
INSERT INTO yut_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Gaga yagɨl uŋun da arɨpmon yo morap tawit da abɨsokyo kɨsi toŋ gɨn. Nido yo morap kɨsi da gak dakon pi aŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Nawa gengo do but dasi dɨma galak tagɨm tam, nak jɨgɨ paŋek kɨlɨ kɨmakgɨm. ");
INSERT INTO yut_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Gengo dɨmasi ɨŋtokeŋ. Nido uŋun yolapbo gak da egɨp egɨpno aŋkutnal. ");
INSERT INTO yut_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Nak gak dakonsi, do yokwikon naŋ abɨdoki. Nak gengo guramɨt do pini asat. ");
INSERT INTO yut_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Amɨn yokwi nɨkba kɨmokgeŋ do jomjom aŋ. Mani, gen tebango do nandaŋ egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Abɨsok nak nandɨsat, yo wagɨl tagɨsi kɨnda mɨnisi. Mani gengo uŋun yo tagɨsisi, ae tɨlakni mɨni. ");
INSERT INTO yut_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Nak gen tebango do but dasi galak tosot. Gɨldat kɨnda kaloŋ uŋun dogɨn nandaŋ egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Gen tebango nagon toktogɨsi tosok, do nandaŋ kokwin tagɨsi amɨn kɨnda dagaŋek uwalno dakon nandak nandak yapmaŋdat. ");
INSERT INTO yut_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Nak toktogɨ gak dakon gen bamɨ dogɨn nandaŋ egɨsat, do nandak nandak tagɨsi tɨmɨgek yoyɨŋdet morapno kɨsi yapmaŋdat. ");
INSERT INTO yut_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Gengo kɨlegɨsi uŋun guramɨkdat, do nandaŋ kokwino tagɨsi da amɨn pelaŋ dakon nandak nandak yapmaŋdak. ");
INSERT INTO yut_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Aŋpak yokwi ak do dɨmasi nandɨsat, nido gengo baŋgɨn guramɨt do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Gak da gaga dakon gen do nayɨŋ dekgɨl, do gen uŋun dɨma yɨpmaŋ dekgɨm. ");
INSERT INTO yut_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Kabaŋ kok uŋun gen kaganokon galagɨsi, mani gengo da uŋun yapmaŋek wagɨl galagɨsisi asak. ");
INSERT INTO yut_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Gengo da nandak nandak tagɨsi namɨsak, do aŋpak yokwi morap do dɨmasi galak tosot. ");
INSERT INTO yut_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Gengo da nak aŋpulugaŋban kosit kɨlegɨ agɨpbeŋ dakon lamno asak. Ae kosit agɨpbeŋ dakon teŋteŋno asak. ");
INSERT INTO yut_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Gen tebango kɨlegɨsi guramɨt do yaŋ teban tok kɨlɨ agɨm, do yaŋ gɨn akdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Yawe, jɨgɨ madepsi da wutjɨŋ namɨsak. Yaŋ teban tok agɨl da arɨpmon aŋpulugaŋbɨ kalugɨ egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Yawe, nak ya yaŋ gayɨsat uŋun da paretno asak, uŋun tɨmɨkgi. Gen tebango do nayɨŋ dekgi. ");
INSERT INTO yut_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Nak toktogɨsi kɨmot da kapmatjok kɨŋ kɨŋ asat. Mani nawa gengo dɨma ɨŋtokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Amɨn yokwi da nak abɨdok do pat yɨpmaŋ, mani gengo dɨma yɨpmaŋ dekdat. ");
INSERT INTO yut_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Toktogɨsi gengo abɨdaŋ kɨmokdot. Aŋapbo uŋun gen da kɨsɨk kɨsɨk namɨsak. ");
INSERT INTO yut_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Gengo guramɨk kɨmokgeŋsi, aŋapbo wɨgɨ kɨmokgeŋ da bɨsapmon wɨgɨsak. ");
INSERT INTO yut_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Amɨn gak gol do but bamot aŋ uŋun do dɨma galak taŋ yomɨsat. Mani nawa gengo do but dasi galak tosot. ");
INSERT INTO yut_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Gak kaloŋgɨn pasɨlɨ tamono ae pasɨkno. Gengo da nak tagɨ aŋpulugosak yaŋ nandaŋ teban taŋek jomjom asat. ");
INSERT INTO yut_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Yokwi pakpak mɨŋat amɨnyo ji nepmaŋ dekgɨt. Piŋkopno dakon gen teban guramɨt do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Yaŋ teban tok agɨl da arɨpmon aŋteban aŋaki egɨpbeŋ. Aŋaki yo abɨdok do nandaŋ teban taŋek jomjom asat uŋun dɨma suŋ tosak. ");
INSERT INTO yut_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Kɨsitnokon abɨdaŋaki tagɨsi egɨpbeŋ. Aŋaki toktogɨsi gengo do nandaŋ egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Mɨŋat amɨn morapyo gen tebango yɨpmaŋ dekgaŋ uŋun manji yomɨsal. Top geni uŋun suŋ tokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Gak da amɨn yokwi morap sɨbɨt sɨbɨt gɨn yaŋ nandaŋ yomɨŋek mabɨ kwaŋ, do gengo do but dasi galak tosot. ");
INSERT INTO yut_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Nak gak do pasalek gɨptɨmno madepsi nɨmnɨmɨkdak. Gen kokwin tamokon gak da amɨn gen yaŋ yomdɨsal uŋun do nandaŋek madepsi pasoldot. ");
INSERT INTO yut_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Nak aŋpak kɨlegɨ tagɨsi baŋ agɨm. Yum nandaŋaki uwalno da yokwi dɨma aŋ namni do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Pi amɨngo nak aŋpulugok do yaŋ teban tok abi do nandɨsat. Yum pɨndagaki kwen wɨgɨk amɨn da jɨgɨ dɨma namni. ");
INSERT INTO yut_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Yokwikon naŋ abɨdoki do yaŋ teban tok agɨl uŋun arɨpmɨ akdɨsal yaŋ do jomjom aŋek sɨŋtaŋ egɨt da dabɨlno tep namaŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Oman amɨngo nak butdasi galak taŋ namɨŋek gen bamɨ do nayɨŋ dekgi. ");
INSERT INTO yut_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Nak oman amɨngo, do nandak nandak namɨŋaki gengo do tagɨ nandabo pɨsosak. ");
INSERT INTO yut_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Abɨsok mɨŋat amɨnyo nawa gengo kɨrɨŋɨkgaŋ uŋun Yawe gak da kobogɨ yobi dakon bɨsap. ");
INSERT INTO yut_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Gol uŋun yo tagɨsi, mani uŋun yapmaŋek gen tebango do but dasi galak tosot. ");
INSERT INTO yut_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Gen morapgo kɨsi guramɨkdat. Aŋpak yokwi morap do dɨma galak tosot. ");
INSERT INTO yut_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Gen tebango uŋun wagɨl tagɨsisi do aŋek guramɨkdat. ");
INSERT INTO yut_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Amɨn kɨnda da notni kɨnda aŋpulugaŋban gengo dakon mibɨlɨ nandɨsak kaŋ, teŋteŋɨkon egɨpdɨsak. Gengo uŋun da nandak nandakni mɨni amɨn nandak nandak yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Nak amɨn da pakbi do tep toŋ uŋun da tɨlak gen tebango do galagɨsi nandɨsat. Uŋun nandak do but dasi galak tosot. ");
INSERT INTO yut_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Amɨn morap mango do but dasi galak toŋ uŋun bupmɨ nandaŋ yomɨsal, uŋudeŋ gɨn abɨŋ bupmɨ nandaŋ nabi. ");
INSERT INTO yut_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Yaŋ teban tok agɨl uŋun da arɨpmon kosit nolayɨki. Aŋkutnaŋaki yokwi kɨnda da nak abɨŋ nep do pi dɨma asak. ");
INSERT INTO yut_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Pulugaŋ nepmaŋaki nak abɨŋ nep do yoŋ amɨn da dɨma aŋupbal ani. Yaŋ aŋaki gengo guramɨkgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Butgo oman amɨngo nagon yɨpmaŋek yo tagɨsi aŋ nabi. Gen teban morapgo do nayɨŋ dekgi. ");
INSERT INTO yut_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Amɨn da nawa gengo dɨma guramɨkgaŋ do aŋek kunam tagapbo dabɨl pakbino pakbi madep da yaŋ pokgoŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Yawe gak kɨlegɨsisi. Ae gen teban morapgo kɨsi kɨlegɨ gɨn. ");
INSERT INTO yut_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Gen teban morap nimgul uŋun kɨlegɨ ae nin da tagɨ nandaŋ gadaneŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Uwalno gengo do nandak nandak dɨma aŋ, do butjap madepsi nandaŋek tapmɨmno moŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Yaŋ teban tokgo uŋun paŋkɨlɨgek uŋun bamɨsi yaŋ kɨlɨ pɨndakgɨm. Do oman amɨngo nak yaŋ teban tok gengo uŋun do but dasi galak tosot. ");
INSERT INTO yut_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Nak amɨn ɨsalɨ naŋ amɨn da abɨŋ nepmaŋgaŋ. Mani gengo do dɨma ɨŋtosot. ");
INSERT INTO yut_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Aŋpakgo kɨlegɨ uŋun toktogɨsi taŋ aŋaŋ kɨkdaŋ. Ae nawa gengo uŋun bamɨsi. ");
INSERT INTO yut_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Jɨgɨ morapmɨ nagon noman toŋ, mani gengo do but galaksi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Gengo uŋun toktogɨsi kɨlegɨsi. Aŋpulugaŋbɨ gen uŋun do nandaŋ pɨsaŋek tagɨsi egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Yawe, nak gak do bɨsit tebai asat. Bɨsitno nandaŋaki gen morapgo guramɨkgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Nak gak do yaŋ tɨdosot. Yokwikon naŋ abɨdaŋaki gen tebango tagɨ guramɨkgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Wɨsa dɨma dagaŋakwan pɨdaŋek aŋpulugoki do yaŋ tɨdosot. Gen tebango da nak tagɨ aŋpulugosak yaŋ nandaŋ teban taŋek jomjom asat. ");
INSERT INTO yut_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Kalbi dɨpmɨn dɨma pokdot. Toktogɨsi yaŋ teban tok gengo dogɨn nandaŋ egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Yawe, toktogɨsi but dasi galak taŋ namɨsal, do bɨsitno nandaki. Gak kɨlegɨsi, do kɨlano aŋaki egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Amɨn nandak nandakni yokwi da nak aŋupbal ak do nak da kapmatjok abaŋ. Uŋun amɨn nawa gengo dɨma guramɨkgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Mani Yawe, gak nak da kapmatjok egɨsal. Ae gen teban morapgo uŋun bamɨsi gɨn. ");
INSERT INTO yut_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Gengo uŋun aŋteban aŋaki dagok dagogɨ mɨni toktogɨsi tosok uŋun kalɨpsigwan kɨlɨ nandagɨm. ");
INSERT INTO yut_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Nak nawa gengo do dɨma ɨŋtosot, do jɨgɨno madepsi uŋun kaŋek aŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Uwal da gen yaŋ namaŋ, do aŋpulugaŋek yokwikon naŋ abɨdoki. Kalɨp yaŋ teban tok agɨl uŋun yolek egɨp egɨp nabi. ");
INSERT INTO yut_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Amɨn yokwi gen tebango uŋun dɨma guramɨkgaŋ, do yokwikon baŋ dɨmasi tɨmɨtdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Yawe, bupmɨgo uŋun madepsi. Gak kɨlegɨsi, do kɨlano aŋaki egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Amɨn morapmɨ da yokwi aŋ namɨŋek uwal aŋ namaŋ. Mani gengo bamɨ dɨma yɨpmaŋ dekdat. ");
INSERT INTO yut_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Manji gamaŋ amɨn pɨndakdat bɨsapmon nandaba yokwitok aŋ yomɨsat, nido uŋun gengo dɨma guramɨkgaŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Gengo do but dasi galak tosot uŋun nandɨsal. Yawe, gak da but dasi galak taŋ namɨŋ kɨmokdol, do yokwikon naŋ abɨdaŋaki tagɨsi egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Gen morapgo uŋun bamɨsi gɨn. Nawa gen morapgo kɨlegɨsi uŋun toktogɨsi taŋ aŋaŋ kɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Kɨla amɨn da mibɨlɨ mɨni nak yokwi aŋ namaŋ. Mani nak gengo do nandaŋek nɨmnɨmɨkdat. ");
INSERT INTO yut_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Amɨn kɨnda da yo tagɨsi morapmɨ tɨmɨkdak, uŋun da tɨlak yaŋ teban tok gengo do kɨsɨk kɨsɨk madepsi asat. ");
INSERT INTO yut_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Nak aŋpak toptopmɨ do nandabo tagɨ dɨma aŋ. Mani gen tebango do but dasi galak tosot. ");
INSERT INTO yut_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Nawa gengo uŋun kɨlegɨsi, do gɨldat morap kɨsi nak gak do ya yaŋ kosirɨ 7 kabɨ yaŋ yaŋ asat. ");
INSERT INTO yut_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Mɨŋat amɨnyo nawa gengo do but dasi galak toŋ, uŋun butni yaworɨsi toŋ, ae yo kɨnda da kesalban dɨma maŋ dapni. ");
INSERT INTO yut_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Yawe, yokwikon naŋ abɨdoki do jomjom asat. Nak gen tebango guramɨkdat. ");
INSERT INTO yut_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Nak gengo do but dasi galak tosot, do gengo guramɨkdat. ");
INSERT INTO yut_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Aŋpak morapno uŋun pɨndakdal, do gen teban morapgo uŋun guramɨkdat. ");
INSERT INTO yut_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Yawe, aŋpulugoki do yaŋ tɨdosot, do nandaŋ nabi dosi nandɨsat. Yaŋ teban tok agɨl uŋun da arɨpmon nandak nandak tagɨsi nabi. ");
INSERT INTO yut_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Kalɨp yagɨl uŋun da arɨpmon bɨsitno do mɨrak yopmaŋek yokwikon naŋ abɨdoki dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Gengo do tagɨsi nayɨŋ dekdal, do toktogɨsi mango aŋkɨsikeŋ dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Gen teban morapgo uŋun kɨlegɨ gɨn, do gengo do kap yokeŋ dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Nak gengo yoldosi nandagɨm, do toktogɨsi nak aŋpulugok do tagap toki dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Yawe, gak da nak yokwikon naŋ abɨdoki do madepsi nandaŋ egɨsat. Nawa gengo da kɨsɨk kɨsɨk namɨsak. ");
INSERT INTO yut_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Egɨp egɨp namɨŋaki mango aŋkɨsikeŋ. Gengo da aŋpulugosak do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Sipsip da kɨŋ pasɨlgaŋ uŋun da tɨlak kosit tagɨsi kɨlɨ yɨpmaŋ dekgɨm. Do abɨŋ oman amɨngo nak do wusɨki. Nak gen tebango do dɨma ɨŋtosot. ");
INSERT INTO yut_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. Jɨgɨ noman taŋ namgwit bɨsapmon Yawe do yaŋ tɨdoko bɨsitno nandaŋ namgut. ");
INSERT INTO yut_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Bɨsit yaŋ agɨm, “Yawe, top amɨn da nak aŋkewalni yaŋ do nak pulugaŋ nepbi.” ");
INSERT INTO yut_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Top amɨn ji, Piŋkop da ji do yo ni baŋ aŋ damjak? ");
INSERT INTO yut_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Uŋun da emat amɨn dakon gobɨŋ baŋ yamaŋ damdɨsak. Aŋek kɨndapni tedepmɨ jikon tagaldɨsak. ");
INSERT INTO yut_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Nak ji da binapmon yokwisi egɨsat. Amɨn da Mesek mɨktɨmon bo Kade amɨn da binapmon yokwisi ekwaŋ uŋun da tɨlak jikon yokwisi egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Nak mɨŋat amɨnyo yaworɨ egɨp egɨp do ɨkwayɨt aŋ amɨn gat kɨsi bɨsap dubagɨsi ekwamaŋ, do kuragɨsi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Nak da tagɨsi yɨtni do yosot bɨsapmon uŋun emat gɨn ak do nandaŋ. ");
INSERT INTO yut_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. Nak sɨŋtoko ɨleŋon wɨgɨsak. Paŋpulugokno dukwan da apban kokeŋ? ");
INSERT INTO yut_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Yawe kundu gat ae mɨktɨm gat wasagɨt uŋun dagɨn paŋpulugokno egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Kɨlago asak, do arɨpmɨ dɨma maŋ pokgi. Kɨlago aŋek dɨpmɨn dɨma pokdok. ");
INSERT INTO yut_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Pakyaŋsi nandani, Israel amɨn dakon kɨla amɨn uŋun pak nandat kɨnda dɨmasi asak. ");
INSERT INTO yut_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Yawe uŋun gak da ɨleŋonjok egek kɨlago aŋek gak aŋyoŋgam asak. ");
INSERT INTO yut_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Gɨldat da gɨldat kalba ae kanek da kalbi arɨpmɨ dɨma aŋupbal anjil. ");
INSERT INTO yut_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Yawe da kɨlago aŋakwan yo yokwi morap toŋ kɨndasok da gak dɨma aŋupbal asak. Egɨp egɨpgo kɨsi kɨla asak. ");
INSERT INTO yut_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Yawe da abɨsok ae don kɨŋ apyo akdɨsal uŋun kɨlago aŋaŋ wɨgɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Dewit dakon kap kɨnda. Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. “Kɨlɨ apba Yawe da yutnon kɨno” yaŋ nayɨŋba nandabo tagɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Nin kɨlɨ abɨŋ Jerusalem dakon wigat yapmaŋek nagalgwan pɨgɨmaŋ da akgamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Jerusalem kokup pap uŋun wagɨl tagɨsi wasaŋbi. ");
INSERT INTO yut_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Israel amɨn ɨdon abɨŋ Yawe ya yaŋ iyɨni do kalɨp kɨlɨ yoyɨgɨt uŋun gen yolek abɨŋ abɨŋ aŋ. ");
INSERT INTO yut_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Uŋudon gen kokwin agak tamo tosok. Dewit dakon dɨwatni kɨla amɨn madep egɨ egɨ awit uŋun dakon gen kokwin tamo toŋ. ");
INSERT INTO yut_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Jerusalem yaworɨsi tosak do bɨsit ani. Bɨsit yaŋ ani, “Yawe, Jerusalem do galagɨ nandaŋ amɨn paŋpulugaŋbɨ tagɨsi egɨpni. ");
INSERT INTO yut_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Paŋpulugaŋbɨ Jerusalem da nagalgwan ekwaŋ amɨn emarɨ mɨni tagɨsi egɨpni, ae kɨla amɨni gat kɨsi tagɨsi egɨpni dosi nandamaŋ.” ");
INSERT INTO yut_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Gwakno gat ae notno gat do nandaŋek Jerusalem amɨn do bɨsit yaŋ abeŋ, “Ji emarɨ mɨni tagɨsi egɨpni.” ");
INSERT INTO yut_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Nak Yawe Piŋkopnin dakon telagɨ yut do nandaŋek bɨsit yaŋ abeŋ, “Yo kɨnda do wadak wadagɨ mɨni tagɨsi egɨpni.” ");
INSERT INTO yut_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. Yawe, nak Kwen Kokup sɨŋtoko wɨgakwan gandako kɨla amɨn madep yɨyɨt tamogokon yɨkdal. ");
INSERT INTO yut_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Oman amɨn amɨn tagɨni do nandaŋ gadasak, aŋakwan pi amɨn mɨŋat uŋun amɨn tagɨ mɨŋat do nandaŋ gadasak, yaŋ gɨn nin Yawe gak do nandaŋ gadamaŋ. Gak Piŋkopnin, gak dagɨn bupmɨ nandaŋ nibi do jomjom amaŋ. ");
INSERT INTO yut_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Yawe, amɨn da yokwi aŋ nimɨŋakwa jɨgɨsi nandamaŋ, do bupmɨ nandaŋ nibi. ");
INSERT INTO yut_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Bɨsap dubagɨsi iyɨ do nandaba wɨkwaŋ amɨn da pabɨŋ nipgwit, do jɨgɨsi nandamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Dewit dakon kap kɨnda. Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. “Yawe da nin dɨma paŋpulugagɨt tam, niaŋɨ?” Israel amɨn da uŋun gen dakon kobogɨ yoni. ");
INSERT INTO yut_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","3","“Amɨn da butjap nandaŋ nimɨŋek ninon emat awit bɨsapmon Yawe da nin dɨma paŋpulugagɨt tam, uwal da japmɨsi nandaŋek obɨsi tagɨ paŋupbal abam. ");
INSERT INTO yut_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Butjapni pakbi da yaŋ ɨgek tɨmɨkban tagɨ pasɨlnom. ");
INSERT INTO yut_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","Pakbi madep uŋun ɨgek tɨmɨkban tagɨ kɨmak mudonom. Mani dɨma.” ");
INSERT INTO yut_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Nin Yawe do ya yaŋsi iyɨneŋ. Yum nindaŋakwan uwal da nin dɨma nindapba pasɨlgɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Nin mɨnam da yaŋ amɨn kɨnda da pat yɨpguron yokwalgɨmaŋ da pulugaŋ kɨgɨmaŋ. Pat uŋun tuwɨl kɨgɨt, do nin pulugaŋ kɨgɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Yawe Kwen Kokup ae mɨktɨmyo wasagɨt, uŋun da iyɨ nin tagɨsi paŋpulugosok. ");
INSERT INTO yut_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. Mɨŋat amɨnyo egɨp egɨpni Yawekon tosok yaŋsi nandaŋ amɨn uŋun Saion Kabap yombem. Kabap uŋun dɨma nɨmnɨmɨgek tebaisi tokdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Ɨleŋ da Jerusalem aŋgwasɨŋek toŋ uŋun da tɨlak Yawe da abɨsok ae don paŋgwasɨŋek mɨŋat amɨni kɨlani akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Amɨn yokwi da amɨn kɨlegɨ dakon mɨktɨm toktogɨ kɨlani dɨma ani. Yaŋ ani kaŋ, amɨn kɨlegɨ yokwi akdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Yawe, amɨn tagɨsi butni kɨlegɨ uŋun amɨnon aŋpak tagɨsi aŋyobi. ");
INSERT INTO yut_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Mani mɨŋat amɨnyo iyɨ dakon aŋpak yokwini yolek aŋ, uŋun yo yokwisi aŋ yobi. Yokwi pakpak amɨn do yo yokwisi aŋ yobi. Israel amɨn yaworɨ tagɨ egɨpni. ");
INSERT INTO yut_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. Yawe da nin uwal da kɨsiron baŋ tɨmɨk aeni Saion kokup papmon paŋapgut bɨsapmon dɨpmɨn yombem pɨndakgɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Nin jɨkgo madepsi yanjagɨmaŋ. Aŋek kɨsɨk kɨsɨk kap yagɨmaŋ. Yaŋ aŋapno mɨktɨm dɨwarɨ dakon mɨŋat amɨnyo da yaŋ yawit, “Yawe da Israel amɨn paŋpulugok do pi madepsi agɨt.” ");
INSERT INTO yut_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Asisi, Piŋkop da nin paŋpulugok do pi madepsi agɨt, do nin wagol tagɨsisi nandamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Yawe, mɨktɨm kɨbɨrɨkon sɨkak maŋakwa joŋ yo morap ae kwoŋ uŋun da tɨlak paŋpulugaŋaki kalɨp tagɨsi egɨpgumaŋ yaŋ gɨn aenin tagɨsi egɨpneŋ. ");
INSERT INTO yut_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Amɨn kunam tagek jap kwaokgaŋ, uŋun kɨsɨk kɨsɨk nandaŋek bamɨ pakdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Asisi, amɨn kunam tagek jap yet kwaot do jap yet pigaga paŋgwaŋ, uŋun don jap bamɨ pektaŋba paŋ paŋobɨŋek kɨsɨk kɨsɨk kap yokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Solomon dakon kap kɨnda. Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. Yawe da paŋpulugaŋban kɨsit kɨlda yut dɨma aŋ tam, pi ɨsal dogɨn abam. Yawe da paŋpulugaŋban kɨla amɨn kokup pap kɨnda kɨlani dɨma aŋ tam, kɨla ɨsal dogɨn abam. ");
INSERT INTO yut_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Nin jap tɨmɨt do nandaba kɨk aŋek wɨsa dɨma dagaŋakwan pɨdaŋ pi gɨn aŋegapno wɨgɨ pɨlɨn toni kaŋ, pi uŋun ɨsal dogɨn amaŋ. Nido, Piŋkop da mɨŋat amɨnyo but dasi galak taŋ yomɨsak uŋun yɨk yawot yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Piŋkop da nin do yo tagɨsi aŋ nimɨŋek monjɨ gwayo but galak do nimɨsak. Uŋun gɨsam tagɨsi Piŋkopmon tɨmɨkgamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Yawi kaluk dakon monjɨ gwayo uŋun gobɨŋ da yaŋ emat amɨn kɨnda da kɨsiron toŋ. ");
INSERT INTO yut_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Amɨn monjɨ gwayo morapmɨ amɨn kɨsɨk kɨsɨk tagɨ ani. Uŋun da gen pi tamokon uwal gat gen pi aŋakwa aŋpulugokdaŋ. Aŋakwa mayagɨ dɨma pakdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. Amɨn morap Yawe do pasalek geni guramɨkgaŋ uŋun amɨn kɨsɨk kɨsɨk tagɨ ani. ");
INSERT INTO yut_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Ji pi aŋek uŋun dakon bamɨ paŋ noni. Ji kɨsɨk kɨsɨk aŋek tagɨsi egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Mɨŋatgo da yutgokon wain nap da yaŋ bamɨ madepsi toni. Ae mɨŋat monjɨyogo da olip kɨndap monɨŋ yombem da yutgokon tamokon aŋgwasɨŋek yɨtni. ");
INSERT INTO yut_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Asi, Yawe do pasalek ekwaŋ amɨn kɨsɨk kɨsɨk tagɨ ani. ");
INSERT INTO yut_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Yawe Saion kokup papmon egɨsak uŋun da gɨsam tagɨ damjak. Ji mɨktɨmon egɨpni bɨsap morapmon Jerusalem kaŋakwa tagɨsi tosak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Ji bɨsap dubagɨsi egek babɨkji pɨndatni do nandɨsat. Israel amɨn yaworɨ tagɨ egɨpni. ");
INSERT INTO yut_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. Israel amɨn, gak monɨŋɨsogon da wɨŋ abɨsok ekwamaŋon gak uwal da yokwi aŋ gamgwit dakon gen niyɨki. ");
INSERT INTO yut_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","Gak yaŋ yoki, “Monɨŋɨsogon da wɨŋ abɨsok ekwamaŋ bɨsapmon uwal da nak yo yokwisi aŋ namaŋ. Mani nak arɨpmɨ dɨma abɨŋ nepni. ");
INSERT INTO yut_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Nak obɨsi baljaŋakwa nap kɨrɨŋ da manjinokon gɨptɨmno dapba kɨrɨŋɨkwaŋ. Pi kaga daŋgap pɨndakgamaŋ uŋun da tɨlak baljaŋba wuda dubagɨsi dɨ noman toŋ. ");
INSERT INTO yut_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Mani Yawe uŋun kɨlegɨsi. Nak amɨn yokwi da nap teban wamgwit uŋun mandaŋ dagaŋakwan oman monjɨ saŋbeŋek dɨma egɨsat.” ");
INSERT INTO yut_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Nak Yawe da mɨŋat amɨnyo Saion kokup pap do uwal aŋ, uŋun mayaktok yomɨŋek pabɨŋ yopmaŋek yolban tobɨlek kokupnikon kɨni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Uŋun joŋ yut kwenon kwaŋek don dubak tokdo aŋakwa gɨldat da pɨndakban tepmɨ kɨbɨdoŋ uŋun yombem ani dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","Amɨn kɨnda da joŋ uŋun baljaŋ paŋmuwuk wamaŋek dɨma paŋkɨsak. ");
INSERT INTO yut_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Ae mɨŋat amɨnyo uwalnin da kapmatjok kɨŋek “Yawe da yo tagɨsi aŋ damɨŋek gɨsam damjak” yaŋ dɨmasi yoyɨni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. Yawe, butno jɨgɨsi taŋakwan aŋpulugoki do yaŋ tɨdosot. ");
INSERT INTO yut_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Amɨn Tagɨ, bɨsitno nandaki. Aŋpulugoki do gayɨsat, do nandaŋ nabi. ");
INSERT INTO yut_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Yawe, gak da dɨwarɨnin manjɨŋek gen pikon nipbim tam, Amɨn Tagɨ namɨn da gengo yapban? ");
INSERT INTO yut_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Mani gagon dɨwarɨ wɨrɨrɨt tosok, do nin gak do pasal gamneŋsi. ");
INSERT INTO yut_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Nak Yawe da aŋpulugosak do nandaŋek jomjom asat. Aŋek geni do tebaisi nandaŋ gadasat. ");
INSERT INTO yut_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Nak Amɨn Tagɨ da aŋpulugosak dosi nandaŋek but kɨndap asat. Kalbi kɨla amɨn da uwal apni do kɨla aŋek wɨsa tepmɨ dagosak do aŋtep aŋ uŋun yapmaŋek but kɨndap madepsi asat. ");
INSERT INTO yut_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Israel amɨn, Yawe da nin do but dasi galak taŋ nimɨsak, ae dɨma yokwi toneŋ yaŋ do bɨsapmɨ bɨsapmɨ nin paŋpulugosok, do Yawe da nin paŋpulugokdɨsak yaŋsi nandaŋ teban taŋek uŋun do jomjom aneŋ. ");
INSERT INTO yut_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Uŋun da Israel amɨn nin yokwikon baŋ tɨmɨgek dɨwarɨnin kɨsisi wɨrɨrɨk nimɨsak. ");
INSERT INTO yut_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Dewit dakon kap kɨnda. Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. Yawe, nak naga do nandako dɨma wɨgɨsak. Mano dɨma awɨgɨsat. Nak yo kɨnda ni da wɨkwisi asak ae yo uŋun dakon mibɨlɨ arɨpmɨ dɨma nandako pɨsosak uŋun do nandaba kɨk dɨma asat. ");
INSERT INTO yut_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Nak butno tagɨsi tosak do pi at da butno yaworɨ tosok. Nak egɨsat uŋun monjɨ ŋakŋak da yaŋ meŋi da kɨsiron nandaba kɨgɨ mɨni pagegɨsak nak uŋun yombem. ");
INSERT INTO yut_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Israel amɨn, ji abɨsok ae bɨsap morap don kɨsi Yawe da paŋpulugosak do nandaŋ teban taŋek jomjom ani. ");
INSERT INTO yut_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. Yawe, gak Dewit do dɨma ɨŋtoki. Ae jɨgɨ morap pagɨt kɨsi do dɨma ɨŋtoki. ");
INSERT INTO yut_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Dewit da Israel amɨn dakon Yawe, Piŋkop tapmɨmɨ toŋ, uŋun do yaŋ teban tok kɨnda yaŋ yagɨt, ");
INSERT INTO yut_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","“Nak yutnon dɨma kɨkeŋ, ae dɨpmɨn potpot tamokon dɨma pokgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","Nak dɨpmɨn dɨma pokgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","Mibɨltok Yawe do yut kɨnda abeŋ, uŋun Israel amɨn dakon Piŋkop Tapmɨmɨ Toŋ uŋun da egɨpjakdo. Aŋek don yɨk yawot abeŋ.” ");
INSERT INTO yut_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Nin Betlehem kokupmon egek Saŋbek Saŋbek Kɨnam dukwan tosok uŋun dakon geni nandagɨmaŋ. Aŋek uŋun Kiriat Jearim da mɨktɨmon taŋban kagɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Kaŋek yaŋ yagɨmaŋ, “Nin kɨlɨ Yawe da yutnon wɨgɨno. Ae uŋun da kapmatjok kɨŋek gawak ɨmneŋ.” ");
INSERT INTO yut_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Yawe, gak Saŋbek Saŋbek Kɨnamgo gat kɨsi abɨŋek yɨk yawot yutgokon yɨkgi. Saŋbek Saŋbek Kɨnam uŋun gak dakon tapmɨm madepgo dakon tɨlak asak. ");
INSERT INTO yut_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Mukwa sogok amɨngo paŋpulugaŋaki toktogɨsi aŋpak kɨlegɨ ani. Aŋaki uŋun aŋpakni kɨlegɨ da ɨmalni tagɨsi da yaŋ asak. Ae mɨŋat amɨnyogo paŋpulugaŋaki kɨsɨk kɨsɨk aŋek kap yoni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Yawe, oman amɨngo Dewit do nandaŋ ɨbi. Kɨla amɨn madep gaga manjɨgɨl uŋun manji dɨma ɨbi. ");
INSERT INTO yut_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Gak da kalɨp Dewit do yaŋ teban tok tebaisi aŋ ɨmgul, ae gengo kulabɨk arɨpmɨ dɨma akdɨsal. Yaŋ iyɨgɨl, “Nak da monjɨ kabɨgokon kɨnda yɨpbo kɨla amɨn madep egɨpjak. ");
INSERT INTO yut_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Monjɨgoni nak dakon saŋbek saŋbekno guramɨtni, ae gen morapno yobeŋ uŋun guramɨtni kaŋ, don bɨsap dagok dagogɨ mɨni babɨgoni dakon monjini kɨla amɨn madep dagokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Yawe da Saion kokup pap iyɨ do tɨlak agɨt da uŋudon toktogɨsi egɨp do nandɨsak. ");
INSERT INTO yut_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Yaŋ yagɨt, “Nak uŋun kokup papmon toktogɨsi egɨpdɨsat. Nak uŋun kokup papmon kɨla amɨn madep egɨpbeŋ do tɨlak kɨlɨ agɨm. ");
INSERT INTO yut_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Nak Saion kokup pap dakon mɨŋat amɨnyo do yo morapmɨ ɨmdɨsat. Aŋapbo yo do wadak wadak dɨma akdaŋ. Aŋek yoni mɨni amɨn do jap morapmɨ yobo naŋ tugokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Nak da Saion kokup pap dakon mukwa sogok amɨn kabɨni yokwikon baŋ tɨmɨkgo uŋun da ɨmalni yombem asak. Aŋapbo Saion dakon mɨŋat amɨnyo da kɨsɨk kɨsɨk kap yokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Nak da Dewit da kabɨkon amɨn kɨnda abɨdaŋek yɨpbo uŋun kokup papmon kɨla amɨn madep dagosak. Aŋek mɨŋat amɨn kabɨno do lam kɨnda da yaŋ teŋteŋaŋ yomjak. ");
INSERT INTO yut_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Nak da uwalni paŋmayak akdɨsat. Mani kɨla amɨn madepno tɨlɨm madepni gat yɨtdɨsak.” ");
INSERT INTO yut_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Dewit dakon kap kɨnda. Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. Piŋkop dakon mɨŋat amɨnyo but kaloŋ aŋek egɨpni kaŋ uŋun tagɨsi, ae burɨ tagɨsi akdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Uŋun aŋpak uŋun wagɨl tagɨsisi. Uŋun olip dakon nelagɨ yombem. Olip dakon nelagɨ Aron do tagal ɨmɨŋakwa mogɨm daŋgwanikon pɨgek ɨmal dubakni da dɨwarɨkon pɨgɨgɨt. ");
INSERT INTO yut_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","But kaloŋ aŋpak uŋun kalbi gɨk sɨtnaŋ Emon Kabap ae Saion Kabapmon moŋ uŋun yombem tagɨsi. Yawe da but kaloŋ ekwaŋ amɨn gɨsamni yomɨsak. Egɨp egɨp dagok dagogɨ mɨni uŋun yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Piŋkop gawak ɨmɨm tamokon kɨgɨk dakon kap. Yawe dakon oman amɨn morap, ji kalbi yutnikon pi aŋ amɨn, ji mani aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Telagɨ yutnikon kɨsitji paŋenagek Yawe dakon man aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Yawe kundu ae mɨktɨm wasagɨt uŋun Saion egɨsak, uŋun da yo tagɨsi aŋdamjak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Yawe aŋkɨsini! Yawe dakon oman amɨn, ji mani aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","Ji Yawe da nagalgwan Piŋkop da yutnon omani aŋ, ji Yawe aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Yawe uŋun tagɨsi, do Yawe aŋkɨsineŋ. Mani uŋun tagɨsisi, do kap yaŋek aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Yawe da Jekop iyɨ do aŋawakgɨt. Israel uŋun Piŋkop iyɨ dakon amɨn kabɨ. ");
INSERT INTO yut_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Yawe uŋun mani wukwisi yaŋ nandɨsat. Amɨn Tagɨ da piŋkop toptopmɨ morap kɨsisi yapmaŋ mudosok. ");
INSERT INTO yut_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Yawe kwen kundukon, ae mɨktɨmon, ae tap kwenon, ae tap kagagwan, galaktokni yolek yo morap ak do nandɨsak uŋun asak. ");
INSERT INTO yut_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Uŋun da yaŋban gɨkwem noman toŋ, ae mal aŋek sɨkak mosok, ae yo morap yopyop yutnikon da mɨrɨm yopban kwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Isip mɨktɨmon Isip amɨn dakon monjɨ mibɨltogɨ gat ae bɨt kɨlapyo dakon monjɨ mibɨltogɨ uŋun dapban kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Isip mɨktɨmon kɨla amɨn madep gat ae kɨla amɨni gat paŋupbal ak do wasok tapmɨmɨ toŋ mibɨlɨ mibɨlɨ agɨt. ");
INSERT INTO yut_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Yawe da mɨktɨm morapmɨ paŋupbal aŋek kɨla amɨn madep tapmɨmɨ toŋ morapmɨ dapban kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Amo amɨn kabɨ dakon kɨla amɨn madep Sion aŋakban kɨmakgɨt, ae Basan dakon kɨla amɨn madep Ok, ae Kenan mɨktɨm dakon kɨla amɨn madep morap gat kɨsi dapban kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Yaŋ aŋek uŋun kɨla amɨn madep dakon mɨktɨmni amɨn kabɨni Israel do yomgut. ");
INSERT INTO yut_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Yawe, mango bɨsap mudok mudogɨ mɨni taŋ aŋaŋ kɨkdɨsak. Babɨkon da babɨkon man bingo do nandaŋ aŋaŋ kɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Yawe dakon amɨn kabɨ uwalni da yo yokwi aŋyoba iyɨ paŋkutnokdɨsak. Oman amɨni do bupmɨ nandaŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Amɨn Ŋwakŋwarɨ Kabɨ kokup kɨdatni uŋun silwa ae gol baŋ wasoŋ. Amɨn kɨsit da wup uŋun wasoŋ. ");
INSERT INTO yut_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Kokup kɨdat dakon wupmɨ uŋun gen kagani toŋ, mani gen arɨpmɨ dɨma yoni. Ae dabɨlni toŋ, mani yo arɨpmɨ dɨma pɨndatni. ");
INSERT INTO yut_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Ae mɨrakni toŋ, mani gen arɨpmɨ dɨma nandani. Ae mɨrɨm dɨma paŋ. ");
INSERT INTO yut_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Kokup kɨdat dakon wupmɨ wasoŋ amɨn, ae egɨp egɨpni kokup kɨdaron tosok yaŋsi nandaŋ amɨn morap, uŋun kokup kɨdat dakon wupmɨ yombem akdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Israel mɨŋat amɨnyo, ji Yawe aŋkɨsini. Yawe dakon mukwa sogok amɨn, ji mani aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Liwai da kabɨkon nani, ji Yawe aŋkɨsini. Mɨŋat amɨnyo Yawe do pasolgoŋ amɨn, ji mani aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Yawe Jerusalem kokup papmon egɨsak, do mɨŋat amɨnyo ji Saion wɨgek mani aŋkɨsini. Yawe aŋkɨsini! ");
INSERT INTO yut_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Yawe aŋpakni uŋun tagɨsisi, do ya yaŋ iyɨneŋsi. Dagok dagogɨ mɨni nin do but dasi galak taŋ nimɨsak. ");
INSERT INTO yut_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Nin Yawe ya yaŋ iyɨneŋ. Uŋun da piŋkop toptopmɨ morap yapmaŋ mudosok. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Nin Amɨn Tagɨ ya yaŋ iyɨneŋ. Uŋun da amɨn tagɨ morap yapmaŋ mudosok. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Uŋun kaloŋ da wasok tapmɨmɨ toŋ madep asak. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Iyɨ da nandak nandagon da kundu ae yo morap kwen toŋ uŋun wasagɨt. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Mɨktɨm yɨpban kwen tagɨt, ae pakbi yɨpban mibɨlɨkon tagɨt. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Gɨldat gat kanek gat wasagɨt. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Gɨldat yɨpban gɨldat kɨnda kɨla asak. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Kanek gat gɨk morap gat yopban pɨlɨn kɨla aŋ. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Nin Yawe ya yaŋ iyɨneŋ. Uŋun Isip amɨn dakon monjɨ mibɨltogɨ dapban kɨmakgwit. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Israel amɨn tɨmɨk paŋobɨŋakwan Isip yɨpmaŋ dekgwit. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Iyɨ da tapmɨm madepmon da tɨmɨk paŋopgut. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Tap Gami pudaŋban tɨmɨ bamorɨ agɨt. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Iyɨ mibɨltok kɨŋek mɨŋat amɨni tɨmɨk paŋabɨŋakwan tap ɨdap pudawit. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Mani Isip dakon kɨla amɨn madep gat ae emat amɨni gat yopban pakbi naŋ kɨmakgwit. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Mɨktɨm kɨbɨrɨ tɨmon mɨŋat amɨni mibɨltaŋ yomɨŋek kɨgɨt. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Kɨla amɨn madep tapmɨmɨ toŋ dapban kɨmakgwit. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Ae kɨla amɨn madep man bini toŋ dapban kɨmakgwit. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Amo amɨn kabɨ dakon kɨla amɨn madep Sion aŋakban kɨmakgɨt. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Ae Basan dakon kɨla amɨn madep Ok aŋakban kɨmakgɨt. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Aŋek uŋun kɨla amɨn madep dakon mɨktɨmni mɨŋat amɨni do yomgut. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Mɨktɨm uŋun oman amɨni Israel do yomgut. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Uwal da pabɨŋ nipgwit bɨsapmon nin do sigɨn nandaŋ nimgut. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Aŋek uwal da kɨsiron baŋ tɨmɨkgɨt. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Mɨŋat amɨnyo gat ae bɨt kɨlap morap gat jap yomɨsak. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Do Kwen Kokup Piŋkop ya yaŋsi iyɨneŋ. Toktok teban nin do but dasi galak taŋ nimɨŋ kɨmokdok. ");
INSERT INTO yut_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Nin Babilon amɨn dakon pakbini da ɨleŋɨkon yɨgek Saion kokup pap do nandak nandak aŋek kunam takgɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Kɨndap kapmatjok tawit uŋun da kɨlɨŋɨkon gitanin mɨndano taŋakwa saŋbeŋek dɨma tɨdagɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Nido nin tɨmɨk mɨktɨmnikon paŋkɨwit amɨn da kap yoneŋ do niyɨwit. Yokwi aŋnimgwit amɨn da tebai yaŋ niyɨwit, “Nin da kɨsɨk kɨsɨk paneŋ do ji da kap yoni do nandamaŋ. Saion dakon kap kɨnda yoni.” ");
INSERT INTO yut_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Mani mɨktɨm dubagɨkon egek Yawe dakon kap niaŋon da tagɨ yoneŋ? ");
INSERT INTO yut_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Jerusalem, nak gak do ɨŋtokeŋ kaŋ, Piŋkop da nak aŋɨŋtok aban saŋbeŋek gita dɨma tɨdokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Jerusalem, nak gak do ɨŋtaŋek yo ɨsalɨ yaŋ gandaŋek yo dɨwarɨ do nandako wɨgɨni kaŋ, Piŋkop da nak melno aŋkadɨm aban kap dɨma yokeŋ dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Yawe, gak Idom amɨn da kalɨp Babilon dakon emat amɨn joŋɨkgwit uŋun do aego nandaki. Babilon amɨn da emat wamaŋek Jerusalem abɨdawit bɨsapmon Idom amɨn da gen yaŋ yawit, “Yut morapni kɨsi tuwɨl mudaŋek paŋupbal aŋ mudoni.” ");
INSERT INTO yut_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Babilon, nandaki. Gak tasɨk tokdɨsal. Nin do aŋpak yokwi niaŋ aŋ nimgul uŋudeŋ gɨn kobogɨ yokwisi tɨmɨtdɨsal. Kobogɨ yokwi gamjak amɨn uŋun kɨsɨk kɨsɨk tagɨ asak. ");
INSERT INTO yut_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Uŋun da gak dakon monjɨ monɨŋ monɨŋ tɨmɨk maban tɨpmon maŋek obɨsi tasɨk taŋek kɨmotdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Dewit dakon kap kɨnda. Yawe, nak but dasi nandaŋek ya yaŋ gayɨsat. Piŋkop toptopmɨ da dabɨlon kap yaŋek mango yaŋ aŋkɨsisat. ");
INSERT INTO yut_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Bɨsapmɨ bɨsapmɨ but dasi galak taŋ namɨŋek kɨlano tagɨsi asal, ae mango gat gengo gat da yo morap yapmaŋ mudaŋek uŋun da wukwisi amal. Yaŋdo, nak Telagɨ Yut Madepgokon gawak gamɨŋek mango yaŋ aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Gak do bɨsit asat bɨsapmon nandaŋ namɨsal. Aŋek tapmɨm namɨŋek butno aŋteban asal. ");
INSERT INTO yut_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Yawe, mɨktɨmon kɨla amɨn madep morap da gengo kɨlɨ nandayɨŋ, do uŋun da mango yaŋ aŋkɨsini dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Tɨlɨmni uŋun madepsi, do uŋun da Yawe dakon wasokni do nandaŋek kap yoni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Yawe uŋun wukwisi egek amɨn iyɨ do nandaba paŋ amɨn uŋun nandaŋ yomɨŋek kɨlani asak. Mani iyɨ do nandaba wɨgɨsak amɨn uŋun yum dabɨl dagɨn pɨndakdak. ");
INSERT INTO yut_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Jɨgɨ mibɨlɨ mibɨlɨ altaŋ naba kɨlano aŋaki dɨma kɨmokdot. Uwalno da nak do japmɨ nandaŋ, mani gak tapmɨmgo madep, do si pabɨŋ yopmaŋek nak aŋpulugosol. ");
INSERT INTO yut_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Yawe da nak niaŋsi egɨpbeŋ ae pi ni baŋ abeŋ do nandagɨt uŋun kɨlano aŋakwan aŋ mudokeŋ. Mudok mudogɨ mɨni nak do but dasi galak taŋ namɨsal. Gak da nak wasagɨl, do dɨma ɨŋtaŋ nabi. ");
INSERT INTO yut_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Dewit dakon kap kɨnda. Kap yoŋ amɨn dakon kɨla amɨn do mandabi. Yawe, gak butnokon yo ni da toŋ uŋun kokwin aŋek bamɨsi nandaŋ namɨsal. ");
INSERT INTO yut_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Gak nak da yɨk pɨdotyo asat uŋun nandaŋ mudosol. Dubagɨkon da nandak nandakno nandaŋ mudosol. ");
INSERT INTO yut_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Nak kosit agɨsat bo ae dɨpmɨn pokdoron niaŋ egɨsat uŋun gak da nandɨsal. Gak aŋpakno kɨsisi nandaŋ mudosol. ");
INSERT INTO yut_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Yawe, nak gen kɨnda yok do asat uŋun gak da kɨlɨ nandagɨl. ");
INSERT INTO yut_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Gak mibɨltok ae buŋonyo agaki kɨsitgo da nak abɨdosok. ");
INSERT INTO yut_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Nandak nandakgo da nandak nandakno yapmaŋek wukwisi asak. Uŋun nak da arɨpmɨ dɨma nandakeŋ. ");
INSERT INTO yut_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Nak dukwan kɨŋek Wupgo yɨpmaŋ dekgeŋ? Nak pasal dukwan kɨŋapbo gak kapmatjok dɨma egɨpdɨsal? ");
INSERT INTO yut_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Kwen Kokupmon wɨgɨkeŋ kaŋ, gak uŋudon egɨpdɨsal. Ae kɨmakbi tamogwan pɨgɨkeŋ kaŋ, uŋudon kɨsi egɨpdɨsal gɨn. ");
INSERT INTO yut_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Pɨdaŋ pɨrɨropmaŋ gɨldat wɨsak tetgɨn do dubagɨsi kɨkeŋ bo tap dɨwarɨsikon kɨkeŋ kaŋ, ");
INSERT INTO yut_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","gak uŋudon egɨpdɨsal gɨn. Aŋek kɨsitgo da nak abɨdaŋek kosit nolɨkdɨsal. Tapmɨmgo madep, do nak aŋpulugokdɨsal. ");
INSERT INTO yut_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Nak “Pɨlɨn tuk da nak aŋkɨsɨbɨsak, ae gɨldat dakon teŋteŋ nak aŋgwasisak uŋun da pɨlɨn tuk asak” yaŋ yokeŋ kaŋ ");
INSERT INTO yut_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","pɨlɨn tuk da nak arɨpmɨ dɨma aŋkɨsɨbɨsak. Kalbi uŋun gɨldat kalba yombem akdɨsak. Pɨlɨn gat ae teŋteŋɨ gat kɨsi pɨndakbɨ arɨpsi amal. ");
INSERT INTO yut_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Gak da gɨptɨm dɨwat morapno kɨsi wasagɨl. Meŋ da butgwan nak uŋungwan wasaŋ mudagɨl. ");
INSERT INTO yut_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Nak da gak aŋkɨsisat, nido gak da pi ŋwakŋwarɨsi aŋek nak wasaŋ nepgul. Nak pakyaŋsi nandɨsat, gak da yo morap wasagɨl uŋun ŋwakŋwarɨsi. ");
INSERT INTO yut_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Meŋ da butgwan pasɨlɨ tamogwan tagok tagok agɨm bɨsapmon gak da pɨndagaki kɨdat morapno tagaŋek notnikon saŋbewit. ");
INSERT INTO yut_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Meŋ da dɨma aŋalaŋakwan kɨlɨ nandagɨl. Nak mɨktɨmon dɨma altagɨm, mani gak da gɨldarɨ gɨldarɨ mɨktɨmon egɨpbeŋ do nandagɨl uŋun papiagokon kɨlɨ mandagɨl. ");
INSERT INTO yut_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Piŋkop, nandak nandak morapgo uŋun wagɨl tagɨsisi. Nandak nandakgo uŋun madepsi, amɨn da arɨpmɨ dɨma manjɨrɨ. ");
INSERT INTO yut_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Gak da nandɨsal yo morap manjɨkeŋ kaŋ, tap ɨleŋon nɨman morap yapjak. Dɨpmɨnon da pɨdosot bɨsapmon nak gak gat sigɨn egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Piŋkop, amɨn yokwi dapbɨ kɨmotni do nandɨsat. Amɨn dapdap amɨn ji nepmaŋ dek kɨt! ");
INSERT INTO yut_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Uŋun amɨn da gak do gen yokwi yoŋ, ae gak dakon man do gen gɨreŋ yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Yawe, nak amɨn gak do kuragɨ nandaŋ amɨn do kuragɨ nandaŋ yomɨsat. Ae amɨn kwen wɨgɨk aŋgamaŋ amɨn do nandaba yokwi tok aŋ yomɨsat. ");
INSERT INTO yut_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Asisi, nak uŋun amɨn do kuragɨsi nandɨsat. Uŋun pɨndakgo nak dakon uwalno aŋ. ");
INSERT INTO yut_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Piŋkop, kokwin tagɨsi aŋek nak dakon nandak nandak morap butnokon toŋ uŋun do nandaki. Aŋkewalek nandak nandak morapno do pakyaŋsi nandaki. ");
INSERT INTO yut_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Egɨp egɨpno kokwin tagɨsi abi. Aŋpak yokwi dɨ nandak nandaknokon dɨ taŋbam. Egɨp egɨp teban dakon kosit naŋ aŋaŋ kɨki. ");
INSERT INTO yut_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Dewit dakon kap kɨnda. Kap yoŋ amɨn dakon kɨla amɨn do mandabi. Yawe, amɨn yokwi da kɨsiron baŋ pulugaŋ nepbi. Kɨlano tagɨsi aŋaki emat amɨn da dɨma aŋupbal ani. ");
INSERT INTO yut_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Toktogɨsi aŋpak yokwi ak do nandak nandak aŋ, aŋek toktogɨsi mɨŋat amɨnyo da binapmon pɨdok pɨdok paŋalon aŋ. ");
INSERT INTO yut_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Gen yogokni uŋun tuŋon amɨn emarɨ toŋ dakon geni yombem, geni tepmɨsi. Ae gen yogokni uŋun tuŋon amɨn emarɨ toŋ dakon pakbi yokwini yombem da gen kagakon tugawit da mɨŋat amɨnyo paŋupbal aŋ. ");
INSERT INTO yut_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Yawe, kɨlano tagɨsi aŋaki amɨn yokwi da dɨma abɨŋ nepni. Dam aŋaki emat amɨn nak aŋupbal ak do gen yoŋ, uŋun yo kɨnda dɨma ani. ");
INSERT INTO yut_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Kwen wɨgɨk amɨn da nak do pat yɨpmaŋ. Nak do kɨlap naŋ yaŋ abɨdok do nap teban baŋ nak da kosiron pat yɨpmaŋ. ");
INSERT INTO yut_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Yawe yaŋ iyɨsat, “Gak Piŋkopno.” Yawe, nak aŋpulugoki. Yaŋ tɨdosot, do nandaŋ nabi. ");
INSERT INTO yut_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Amɨn Tagɨ Yawe, gak yokwikon baŋ tɨmɨt tɨmɨt amɨno tapmɨmɨ toŋsi. Kalɨp uwal gat emat wamgumaŋ bɨsapmon aŋkutnagɨl. ");
INSERT INTO yut_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Yawe, amɨn yokwi da yo tɨmɨt do galak toŋ uŋun dɨma yobi. Yum pɨndagaki aŋpak yokwi ak do gen yaŋ paŋteban awit uŋun dɨma ani. ");
INSERT INTO yut_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Yum pɨndagaki uwalno da emaron dɨma abɨŋ nepni. Yo uŋun ak do nandaŋ uŋun paŋtobɨlbɨ iyɨkon noman toni. ");
INSERT INTO yut_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Kɨndap yɨpbɨ kwenikon moni. Mabɨ gapma madepgwan pɨgek ae dɨma wɨni. ");
INSERT INTO yut_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Ɨsal dogɨn amɨn dɨwarɨ gen yaŋ yomaŋ amɨn yum pɨndagaki nin da mɨktɨmon tagɨ dɨma egɨpni. Ae emat amɨnon yo yokwisi noman taŋ yoba pasɨlni do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Yawe, gak da jɨgɨ paŋ amɨn gat ae yo do wadak wadak aŋ amɨn gat paŋpulugosol. ");
INSERT INTO yut_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Mɨŋat amɨnyo kɨlegɨ da mango aŋkɨsikdaŋ. Uŋun gak gat kɨsi egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Dewit dakon kap kɨnda. Yawe, nak gak do yaŋ tɨdosot. Tepmɨsi aŋpulugoki do nandɨsat. Gak do yaŋ tɨdosot, do bɨsitno nandaki. ");
INSERT INTO yut_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Bɨsitno da mukwa kɨbaŋɨ tagɨsi da yaŋ gagon opjak dosi nandɨsat. Ae gak do kɨsitno paŋenokdot uŋun da pɨlɨndo dakon paretno yaŋ asak. ");
INSERT INTO yut_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Yawe, gen kagano do kɨla tagɨsi aŋaki gen yokwi kɨnda dɨma yokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Yum nandaŋaki butnokon da aŋpak yokwi ak do dɨma nandakeŋ. Ae yum nandaŋaki amɨn yokwi gat muwuk agek yokwi dɨma aneŋ. Yum nandaŋaki uŋun dakon jap noknok bɨsap madepmon uŋun gat dɨma yɨtneŋ. ");
INSERT INTO yut_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Yum nandaŋaki amɨn kɨlegɨ kɨnda da nak aŋmɨlɨp ak do jɨgɨ tagɨ namjak. Mani nak amɨn yokwi not dɨma aŋ yobeŋ. Piŋkop da amɨn yokwi uŋun aŋpak yokwini dakon kobogɨ paŋtobɨl yomjak do bɨsit asat. ");
INSERT INTO yut_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Amɨn da amɨn yokwi dakon kɨla amɨni uŋun tɨmɨgek maba tɨp domon pɨgɨni bɨsapmon Yawe dakon gen uŋun bamɨsi yaŋ nandaba pɨsokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Aŋek amɨn da jap pi do mɨktɨm pɨdaŋek paŋdamɨt aŋ, uŋun da tɨlak uŋun amɨn dakon kɨdarɨ paŋdamɨt aŋek maba kɨmakbi tamogwan pɨgɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Mani Amɨn Tagɨ Yawe, nak gak do nandaŋ gadasat. Gak da nak tagɨsi aŋkutnosol. Yum nandaŋaki dɨma kɨmokgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Aŋpulugaŋaki amɨn yokwi da pat yɨpgwit uŋudon dɨma yokwalgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Yopbɨ iyɨ pat yɨpgwiron iyɨ yokwalni. Mani nak kosit tagɨsi agek yo kɨnda da dɨma aŋupbal asak. ");
INSERT INTO yut_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Dewit dakon kap kɨnda. Kap on do Maskil yaŋ yoŋ. Dewit tɨp kɨnamgwan egek bɨsit on mandagɨt. Nak Yawe da aŋpulugosak do tebaisi yaŋ tɨdosot. Bupmɨ nandaŋ namɨŋek aŋpulugosak do bɨsit asat. ");
INSERT INTO yut_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Nandaba kɨkno gat ae jɨgɨ morap noman taŋ namaŋ uŋun kɨsi iyɨŋ mudosot. ");
INSERT INTO yut_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Jɨgɨsi nandaŋek wagɨlsi yokwi tokdɨsat yaŋ nandɨsat bɨsapmon, Yawe niaŋsi abeŋ uŋun gak da nandɨsal. Kosiron yokwalgeŋ do amɨn da pat pɨwit. ");
INSERT INTO yut_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Nak aŋpulugosak amɨn kɨnda kapmat dɨma akban kosot. Amɨn kɨnda da kɨlano dɨma asak, ae amɨn kɨnda da nak do bup taŋek dɨma aŋkutnosok. ");
INSERT INTO yut_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Yaŋdo, Yawe nak aŋpulugoki do bɨsit gayɨsat. Gak kaloŋgɨn pasɨlɨ tamono. Mɨktɨmon egɨsat bɨsapmon gak gat gɨn egɨp do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Butno obɨsi jɨk tosok, do aŋpulugoki do bɨsit asat uŋun nandaki. Nak aŋsopmaŋgaŋ amɨn uŋun tapmɨmni madepsi. Arɨpmɨ dɨma pabɨŋ yopbeŋ, do uŋun da kɨsiron baŋ pulugaŋ nepbi. ");
INSERT INTO yut_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Jɨgɨkon yɨkdat, do pulugaŋ nepbɨ tagɨsi egɨpbeŋ. Yaŋ aŋaki yo tagɨsi aŋnamɨsal uŋun do nandaŋek mɨŋat amɨn kabɨyogo muwutnikon mango aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Dewit dakon kap kɨnda. Yawe bɨsitno nandaki. Mɨrakgo yopmaŋek aŋpulugoki do yaŋ tɨdosot uŋun nandaki. Gak amɨn kɨlegɨsi, ae bɨsapmɨ bɨsapmɨ dɨma nepmaŋ dekdal, do bɨsitno nandaki. ");
INSERT INTO yut_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Gak da dabɨlon amɨn kɨlegɨ kɨnda dɨma egɨsak, do oman amɨngo nak gen pikon dɨma nepbi. ");
INSERT INTO yut_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Uwalno da nol aŋkɨ nɨkban maŋ mɨktɨmon pokdot. Aŋakwan amɨn kɨlɨ kɨmakgwit da arɨpmon pɨlɨn tukgwan egɨsat. ");
INSERT INTO yut_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Nandak nandakno upbal taŋakwan but pasol madepsi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Kalɨpsi egɨpgum uŋun do nandɨsat. Yo morap agɨl ae pi tagɨsi agɨl uŋun do nandak nandak tebaisi asat. ");
INSERT INTO yut_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Aŋpulugoki do didasat. Mɨktɨm kɨbɨrɨsi da sɨkak do nandɨsak, uŋun da arɨpmon nak gak do madepsi galak taŋ gamɨsat. ");
INSERT INTO yut_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Yawe, butno tapmɨmɨ mɨni aban nandɨsat, do bɨsitno nandaŋek tepmɨsi aŋpulugoki. Dɨma pasɨl nabi. Yaŋ abi kaŋ, amɨn kɨlɨ kɨmakgwit uŋun da tamokon kɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Egɨp egɨpno gagon tosok yaŋsi nandɨsat, do aŋpulugaŋbɨ wɨsa dagokdo gak da amɨn nin do but dasi galak taŋ nimɨsal uŋun do nandakeŋ. Nak bɨsit gayɨsat, do kosit nolɨŋbɨ uŋun naŋ kɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Yawe, kɨlano abi do gagon obɨsat, do uwalno da kɨsiron baŋ pulugaŋ nepbi. ");
INSERT INTO yut_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Gak Piŋkopno, do nayɨŋ dekbɨ gak dakon galaktok yolek egɨpbeŋ. Wupgo tagɨsi uŋun da mibɨltaŋ namɨŋakwan kosit kɨlegɨkon agɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Yawe, man bingo tagɨsi tosak do yokwikon naŋ pulugaŋ nepbi. Gak amɨn kɨlegɨsi, do jɨgɨ morap pasat uŋun wɨrɨrɨk nabi. ");
INSERT INTO yut_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Nak do but dasi galak taŋ namɨsal, do uwalno dapbɨ kɨmotni. Nak oman amɨngo, do uwalno obɨsi dapbɨ kɨmotni. ");
INSERT INTO yut_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Dewit dakon kap kɨnda. Nak Yawe dakon man aŋkɨsisat. Uŋun tɨp madepno. Emat dakon mibɨlɨ tagɨsi nayɨŋ dekdak. Aŋek aŋtagap aban emat do tagap tosot. ");
INSERT INTO yut_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Uŋun but dasi galak taŋ namɨsak, ae dam tebano arɨpmɨ dɨma tuwɨlɨ egɨsak. Uŋun pasɨlɨ tamono, ae yokwikon baŋ tɨmɨt tɨmɨt amɨno. Uŋun pasɨkno tebaisi, do aŋkutnaŋakwan tagɨsi egɨsat. Amɨn Ŋwakŋwarɨ Kabɨ pabɨŋ yopmaŋakwan nak da yoŋgamgwan ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Yawe, mɨŋat amɨnyo nin niaŋen amɨn dɨ baŋ nin do nandak nandak madep asal? Nin yo ɨsalɨsi. Gak nido kɨlanin kakgɨmansi asal? ");
INSERT INTO yut_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Mɨrɨm bɨsap kaloŋ pɨsono kwaŋ uŋun da tɨlak bɨsap pɨsɨpmɨsi ekwamaŋ. Wupnin gɨldaron tepmɨsi altaŋ pasɨlgaŋ uŋun da tɨlak bɨsap pɨsɨpmɨsok gɨn ekwamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Yawe, kundu wɨtdalek pɨki. Kɨsitgo kabapmon yopmaŋaki mukwa madepsi pɨdoni. ");
INSERT INTO yut_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Mal yɨpbɨ noman taŋek uwal yolban kɨŋ mudoni. Gobɨŋgo yamaŋaki pasal kɨŋ mudoni. ");
INSERT INTO yut_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Kɨsitgo yɨpbɨ pɨŋakwan nak ɨlɨkbɨ wɨkeŋ. Aŋaki pakbi ɨlarɨsi yɨpmaŋ dekgeŋ. Amɨn Ŋwakŋwarɨ Kabɨ da kɨsiron baŋ abɨdoki. ");
INSERT INTO yut_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Uŋun amɨn gen bamɨ dɨma yoŋ. Top baŋ gɨn yaŋek gen uŋun bamɨsi yaŋ yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Piŋkop, nak abɨsok gak do kap kalugɨ yokeŋ. Gita tɨdaŋek gak do kap yokdɨsat. ");
INSERT INTO yut_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Kɨla amɨn madep paŋpulugaŋaki emaron teban toŋ. Oman amɨngo Dewit nak yokwikon naŋ abɨdagɨl. ");
INSERT INTO yut_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Uwal yo yokwi aŋ namaŋ da kɨsiron baŋ abɨdoki. Aŋek Amɨn Ŋwakŋwarɨ Kabɨ da kɨsiron baŋ abɨdoki. Uŋun gen bamɨ dɨma yoŋ. Top baŋgɨn yaŋek gen uŋun bamɨ yaŋ yoŋ. ");
INSERT INTO yut_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Nin monjinin wɨli kɨndap da yaŋ tebaisi tagoni do nandamaŋ. Ae gwanin da kɨla amɨn madep dakon yut dakon tɨlɨmni tagɨsi da egɨpni do nandamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Pigaganin da jap bamɨ morapmɨ taŋakwa jap paŋ yopyop yut madepsi tugaŋ toni do nandamaŋ. Aŋakwa sipsipnin da monjɨ morapmɨ sigɨn paŋalani. ");
INSERT INTO yut_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Ae bulmakau da monjɨ morapmɨ paŋalani. Aŋakwa yokwi dɨ dɨma altoni ae kɨnda dɨma kɨmotjak. Nin dakon kosiron mɨŋat bo wɨli kɨnda da jɨgɨ bo ae tepmɨ paŋek kunam dɨma tatjak do nandamaŋ. ");
INSERT INTO yut_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Mɨŋat amɨn kabɨ yo uŋuden tɨmɨkgaŋ uŋun kɨsɨk kɨsɨk tagɨ ani. Mɨŋat amɨnyo Yawe yɨpba Piŋkopni egɨsak uŋun kɨsɨk kɨsɨk tagɨ ani. ");
INSERT INTO yut_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Dewit dakon kap kɨnda. Kap on Piŋkop dakon man aŋkɨsik dakon kap. Piŋkopno ae Kɨla Amɨn Madepno, bɨsapmɨ bɨsapmɨ mango aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Gɨldarɨ gɨldarɨ mango aŋkɨsikeŋ. Dagok dagogɨ mɨni gak aŋkɨsiŋ wɨgɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Yawe uŋun mani wukwisi, do mani aŋkɨsiŋ kɨmotneŋ. Mani wukwisi, do uŋun dakon mibɨlɨ kɨsi amɨn da arɨpmɨ dɨma nandaba pɨsogɨ. ");
INSERT INTO yut_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Babɨkon da babɨkon pi madep aŋ aŋ agɨl uŋun do yaŋ yaŋ akdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Amɨn da tapmɨm madepgo gat ae Kɨla Amɨn Madep Wɨkwisi egɨsal uŋun do yokdaŋ. Aŋakwa nak do pi madep madep asal uŋun do nandaŋek egɨpbeŋ. ");
INSERT INTO yut_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Amɨn da pi masɨ masɨmɨ asal uŋun dakon geni yokdaŋ. Aŋakwa nak da man madepgo do yokeŋ. ");
INSERT INTO yut_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Aŋpakgo tagɨsi uŋun dakon geni yaŋek kapmon da aŋpakgo kɨlegɨsi uŋun do yoni. ");
INSERT INTO yut_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Yawe da nin do nandaŋ yawok nimɨŋek bupmɨ nandaŋ nimɨsak. Butjap tepmɨ dɨma nandaŋek but dasi galak taŋ nimɨsak. ");
INSERT INTO yut_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Amɨn morap kɨsi do aŋpak tagɨsi aŋyomɨsak. Aŋek yo morap wasagɨt uŋun do bupmɨkon da kɨlani asak. ");
INSERT INTO yut_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Yawe, yo morap wasagɨl uŋun da mango aŋkɨsini. Mɨŋat amɨn kabɨgo da mango aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Amɨn kɨla agakgokon tɨlɨmgo tosok uŋun do yokdaŋ. Aŋek tapmɨm madepgo dakon geni yokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Yaŋ aŋakwa amɨn morap da pi madep asal uŋun do nandani. Aŋek gak kɨla amɨn madep tapmɨmɨ toŋ egɨsal ae mango wukwisi tosok yaŋ nandaŋ gamni. ");
INSERT INTO yut_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Gak kɨla amɨn madep dagok dagogɨ mɨni egek amɨn morap kɨlani akdɨsal. Yawe yaŋ teban tok gen yagɨt uŋun kɨnda dɨma yapmaŋek guramɨk kɨmokdok. Nin paŋpulugok do yo tagɨsi gɨn asak. ");
INSERT INTO yut_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Jɨgɨni toŋ amɨn paŋpulugaŋek amɨn da pabɨŋ yopmaŋgaŋ amɨn uŋun paŋenakban tagɨsi ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Yo morap egɨp egɨpmɨ toŋ jap do aŋ bɨsapmon gagon sɨŋtaŋba wɨkwan jap upmokdol. ");
INSERT INTO yut_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Jap gat ae yo morap gat arɨpnikon yomaŋaki tagɨsi ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Yawe uŋun aŋpak kɨlegɨ gɨn asak. Yo morap wasaŋ yopguron aŋpak tagɨsi baŋ aŋyomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Butdasi nandaŋek bɨsit iyaŋ amɨn Yawe uŋun amɨn da kapmatjok egɨsak. ");
INSERT INTO yut_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Iyɨ do pasolgoŋ amɨn yo nido galak toŋ uŋun yoban tɨmɨkgaŋ. Bɨsitni nandaŋek yokwikon baŋ tɨmɨkdak. ");
INSERT INTO yut_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Iyɨ do but dasi galak taŋ ɨmaŋ amɨn Yawe da kɨlani asak. Mani yokwi aŋ amɨn paŋupbal akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Bɨsapmɨ bɨsapmɨ Yawe dakon mani aŋkɨsikeŋ. Yo morap egɨp egɨpmɨ toŋ ji dagok dagogɨ mɨni mani telagɨ aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Yawe dakon man aŋkɨsini. Nak naga mani aŋkɨsikeŋ. ");
INSERT INTO yut_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Mɨktɨmon egɨpbeŋ bɨsapmon Yawe dakon mani aŋkɨsikeŋ. Piŋkopno do kap yaŋek aŋkɨsiŋ wɨgek kɨmokgeŋ. ");
INSERT INTO yut_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","On mɨktɨm dakon kɨla amɨn madep da gak arɨpmɨ dɨma aŋpulugokdaŋ, do egɨp egɨpji uŋun amɨnon tosok yaŋ dɨma nandani. ");
INSERT INTO yut_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Uŋun kɨmagek mɨktɨm dagokdaŋ. Yo ak do yawit uŋun bamɨ dɨma noman tokdaŋ. ");
INSERT INTO yut_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Mani amɨn kɨnda Jekop dakon Piŋkop da aŋpulugosak do nandaŋ gadaŋek jomjom asak uŋun amɨn kɨsɨk kɨsɨk tagɨ asak. ");
INSERT INTO yut_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Piŋkop da kundu ae mɨktɨm ae tap ae yo morap uŋungwan toŋ wasagɨt. Toktogɨsi yo morap ak do yosok uŋun akdɨsak. ");
INSERT INTO yut_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Jɨgɨkon ekwaŋ amɨn paŋpulugosok. Ae jap do aŋ amɨn jap yomɨsak. Yawe da dam tebanon ekwaŋ amɨn wɨtdal yopban kwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Dabɨlɨ mɨni amɨn dabɨlni paban pɨsaŋban sɨŋtoŋ. Ae jɨgɨ da tebai pabɨŋ yopmaŋgaŋ amɨn uŋun jɨgɨni kukwaŋ yomɨsak. Yawe uŋun amɨn kɨlegɨ do but dasi galak taŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Dubagɨkon amɨn nin da mɨktɨmon ekwaŋ uŋun kɨlani asak. Ae sakwabat gat ae monjɨ meŋi datniyo kɨmakbi uŋun kɨsi kɨlani asak. Mani amɨn yokwi aŋ uŋun da yo ak do nandaŋ uŋun kosit sopmaŋ yoban dɨma aŋ. ");
INSERT INTO yut_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Yawe uŋun dagok dagogɨ mɨni kɨla amɨn madep egɨpdɨsak. Saion kokup pap amɨn ji dakon Piŋkop dagok dagogɨ mɨni Kɨla Amɨn Madep egɨpdɨsak. Yawe dakon man aŋkɨsini! ");
INSERT INTO yut_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Yawe aŋkɨsini! Piŋkopnin kap yaŋek aŋkɨsamaŋ kaŋ, aŋpak kɨlegɨsi amaŋ. Yaŋ aŋapno butnin tagɨsisi tosok, ae aŋkɨsamaŋ uŋun agagɨsi naŋ amaŋ. ");
INSERT INTO yut_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Yawe da Jerusalem kokup pap aeni aŋkaluk aŋek Israel amɨn kalɨp uwal da tɨmɨk mɨktɨm dubagɨkon paŋkɨwit uŋun aeni paŋmuwukdak. ");
INSERT INTO yut_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Burɨ yokwi tawit uŋun paŋmɨlɨp aŋek wudani wamaŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Uŋun da gɨk manjɨŋek gɨk kaloŋ kaloŋ do man yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Amɨn Tagɨnin uŋun wukwisi madep, ae tapmɨmni madepsi. Nandak nandakni uŋun tɨlakni mɨni. ");
INSERT INTO yut_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Yawe da amɨn iyɨ do nandaba paŋ uŋun paŋpulugosok. Mani yokwi pakpak amɨn pabɨŋ yopban mɨktɨmon maŋ pokgoŋ. ");
INSERT INTO yut_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Yawe ya yaŋ iyɨŋek kap yaŋ ɨmno. Gita tɨdaŋek Piŋkopnin aŋkɨsino. ");
INSERT INTO yut_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Uŋun da gɨkwem kwen yopban sɨkak maŋakwa ɨleŋon joŋ kwoŋ. ");
INSERT INTO yut_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Uŋun da joŋ kɨlap do jap yomɨsak, ae mɨnam pɨdɨkyo kɨsi yaŋ tɨdaŋba jap yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Yawe uŋun os dakon tapmɨm gat ae amɨn dakon tapmɨm gat do nandaban yo madep dɨma asak. ");
INSERT INTO yut_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Mani, amɨn iyɨ do pasal ɨmaŋ ae Yawe da nin do but dasi bɨsapmɨ bɨsapmɨ galak taŋ nimɨsak yaŋsi nandaŋ gadaŋ amɨn uŋun do galak taŋ yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Jerusalem amɨn ji Yawe aŋkɨsini. Saion amɨn ji Piŋkopji aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Uŋun da kokup papji dakon wigat paŋteban aŋek amɨn kabɨgo gɨsam yomɨsak. ");
INSERT INTO yut_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Uŋun da paŋpulugaŋban emarɨ mɨni tagɨsi ekwaŋ. Ae wit tagɨsi dakon baŋ paŋɨreŋ aban naŋek butji tugoŋ. ");
INSERT INTO yut_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Gen kɨnda yɨpmaŋdak uŋun tepmɨsi mɨktɨmon pɨsak. ");
INSERT INTO yut_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Uŋun da ais yopban sipsip dakon daŋgwi da yaŋ maŋ mɨktɨm yalɨsak. Aŋek gɨk sɨtnaŋ yopban abɨlak da yaŋ maŋ tayɨŋɨkwaŋ. ");
INSERT INTO yut_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Ais madep yopban tɨp da yaŋ mɨktɨmon moŋ. Aŋek uŋun da aba kokup mɨrɨmɨsi aŋakwan amɨn kɨnda da mɨrɨm abɨŋ yɨpmɨ mɨni. ");
INSERT INTO yut_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Ae don gen yɨpban mɨrɨm aŋakwan ais pakbi dagaŋek pokgoŋ. ");
INSERT INTO yut_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Geni Jekop do ɨmgut. Nawa geni Israel amɨn do yomgut. ");
INSERT INTO yut_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Mɨktɨm dɨwarɨ taŋ aŋ aŋ kwaŋ dakon mɨŋat amɨnyo do yaŋ dɨma agɨt. Nawa geni dɨma nandaŋ. Yawe dakon man aŋkɨsini! ");
INSERT INTO yut_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Yawe aŋkɨsini! Ji ason Kwen Kokup ekwaŋ, Yawe aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Aŋelo morapni aŋkɨsini. Kwen Kokup emat amɨn kabɨ morapni aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Gɨldat gat kanek gat jil aŋkɨsinjil. Gɨk morap teŋteŋoŋ ji aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Kundu kwen ason aŋkɨsiki. Pakbi kundu yapmaŋek kwensi toŋ, ji aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Iyɨ yaŋakwan uŋun yo morap noman tawit, do uŋun yo morap Yawe dakon man aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Uŋun yo morap wasaŋakwan tamonikon toktogɨsi tebai toŋ. Gen yagɨt uŋun dɨma pasɨljak. ");
INSERT INTO yut_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Mɨktɨmon yo morap toŋ, ji Yawe aŋkɨsini. Ji tap kɨlap madep madep gat, ae tap ɨdap morap ɨlarɨsi, ");
INSERT INTO yut_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","ae mal, ae ais madep monɨŋɨyo, ae gɨkwem, ae mɨrɨm madep Yawe dakon galaktok yolgaŋ, ji kɨsi da aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Ji kabap madep ae monɨŋɨ gat ae kɨndap sopmɨ toŋ ae sida kɨndap madep, ");
INSERT INTO yut_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","ae joŋ kɨlap gat ae bulmakau ae yo monɨŋ morap egɨp egɨpmɨ toŋ gat ae mɨnam gat, ji kɨsisi Yawe aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Ji kɨla amɨn madep gat ae amɨn gat ae gapman gat ae kɨla amɨn morap gat, ");
INSERT INTO yut_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","ae wɨlisok ae mɨŋatjok ae amɨn pelaŋ ae mɨŋat monjɨyo, ji kɨsisi Yawe aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Uŋun kɨsi morap Yawe aŋkɨsiŋ kɨmotni. Uŋun kaloŋ gɨn mani wukwisi. Tɨlɨmni da mɨktɨm gat kundu gat yapmaŋ mudosok. ");
INSERT INTO yut_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Uŋun da iyɨ dakon amɨn kabɨ Israel uŋun do but dasi galak taŋ yomɨŋek paŋteban asak do aŋek aŋkɨsaŋ. Yawe aŋkɨsini! ");
INSERT INTO yut_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Yawe aŋkɨsini! Kap kalugɨ yaŋ ɨmni. Piŋkop yol kɨmokgoŋ mɨŋat amɨn kabɨni ji muwugek aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Israel amɨn ji Piŋkop da wasagɨt, do but galak nandaŋ ɨmni. Saion kokup pap amɨn ji Kɨla Amɨn Madepji do kɨsɨk kɨsɨk ani. ");
INSERT INTO yut_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Kap aŋek mani yaŋ aŋkɨsini. Tambarin gat ae gita gat tɨdaŋek mani aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Yawe da mɨŋat amɨn kabɨni do galak taŋ yomɨsak. Aŋek amɨn iyɨ do nandaba pɨŋbi aŋ uŋun yokwikon baŋ tɨmɨkdak. ");
INSERT INTO yut_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Yaŋ asak, do mɨŋat amɨn kabɨni but dasi yolgaŋ uŋun kɨsɨk kɨsɨk ani dosi nandɨsat. Dɨpmɨn potpot tamokon kɨsɨk kɨsɨk kap yoni. ");
INSERT INTO yut_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Piŋkop yaŋ aŋkɨsiŋek emat agak sɨba geni tepmɨsi baŋ tɨmɨgek ");
INSERT INTO yut_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","Amɨn Ŋwakŋwarɨ Kabɨ gat emat wamaŋek yo yokwisi aŋ yomɨŋek pabɨŋ yopni dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","Aŋek ain nap baŋ kɨla amɨn madepni gat ae kɨla amɨni gat dakon kandap paŋteban ani. ");
INSERT INTO yut_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","Aŋakwa Piŋkop da yagɨt uŋun da arɨpmon kobogɨ yokwisi tɨmɨtni. Aŋakwa amɨn kabɨni iyɨ yol kɨmokgoŋ uŋun dakon man madep tokdɨsak. Yawe aŋkɨsini! ");
INSERT INTO yut_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Yawe aŋkɨsini! Piŋkop telagɨ yutnikon egɨsak, uŋun aŋkɨsini. Kwen Kokup tapmɨmɨ toŋsi uŋudon egɨsak, uŋun aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Pi masɨ masɨmɨsi asak do aŋkɨsini. Mani uŋun wagɨl wukwisi do aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Kweŋ pɨsoŋek aŋkɨsini. Gita mibɨlɨ mibɨlɨ tɨdaŋek aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Tambarin tɨdaŋek kap aŋek aŋkɨsini. Gita tɨdaŋek kasɨsɨŋ pɨsoŋek aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Ain ɨdap notnikon tɨdaŋ tɨdaŋ aŋek aŋkɨsini. Uŋun tɨdaŋba gen madepsi yaŋakwa aŋkɨsini. ");
INSERT INTO yut_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Yo morap mɨrɨm paŋ uŋun Yawe aŋkɨsini! Yawe aŋkɨsini! ");
INSERT INTO yut_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","On man sɨlɨp uŋun Yesu Kristo dakon babɨkni dakon man sɨlɨp. Yesu uŋun Dewit da kabɨkon nani. Aŋakwan Dewit uŋun Abraham da kabɨkon nani. ");
INSERT INTO yut_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham uŋun Aisak dakon datni. Aisak uŋun Jekop dakon datni Jekop uŋun Juda gat ae peni padɨk padɨkni gat dakon datni. ");
INSERT INTO yut_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda uŋun Peres gat Sera gat dakon datni. (Meŋi uŋun Tamar.) Peres uŋun Esron dakon datni. Esron uŋun Ram dakon datni. ");
INSERT INTO yut_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram uŋun Aminadap dakon datni. Aminadap uŋun Nason dakon datni. Nason uŋun Salmon dakon datni. ");
INSERT INTO yut_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon uŋun Boas dakon datni. (Meŋi uŋun Reap.) Boas uŋun Obet dakon datni. (Meŋi uŋun Rut.) Obet uŋun Jesi dakon datni. ");
INSERT INTO yut_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi uŋun kɨla amɨn madep Dewit dakon datni. Aŋakwan Dewit uŋun Solomon dakon datni. (Solomon dakon meŋi kalɨp Uria dakon mɨŋatni egɨpgut.) ");
INSERT INTO yut_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon uŋun Reoboam dakon datni. Reoboam uŋun Abiya dakon datni. Abiya uŋun Asa dakon datni. ");
INSERT INTO yut_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa uŋun Jeosapat dakon datni. Jeosapat uŋun Jeoram dakon datni. Jeoram uŋun Usia dakon datni. ");
INSERT INTO yut_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia uŋun Jotam dakon datni. Jotam uŋun As dakon datni. As uŋun Esekia dakon datni. ");
INSERT INTO yut_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekia uŋun Manase dakon datni. Manase uŋun Emon dakon datni. Emon uŋun Josaia dakon datni. ");
INSERT INTO yut_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia uŋun Joiakin gat ae notni kabɨ gat dakon datni. (Uŋun amɨn kabɨ da bɨsapmon Israel amɨn uwalni da tɨmɨk Babilon mɨktɨmon paŋkɨ yopba egɨpgwit.) ");
INSERT INTO yut_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilon paŋkɨ egɨpgwit bɨsapmon, Joiakin uŋun Sealtiel dakon datni. Sealtiel uŋun Serubabel dakon datni. ");
INSERT INTO yut_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel uŋun Abiut dakon datni. Abiut uŋun Eliakim dakon datni. Eliakim uŋun Aso dakon datni. ");
INSERT INTO yut_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso uŋun Sadok dakon datni. Sadok uŋun Akim dakon datni. Akim uŋun Eliut dakon datni. ");
INSERT INTO yut_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut uŋun Eleasa dakon datni. Eleasa uŋun Matan dakon datni. Matan uŋun Jekop dakon datni. ");
INSERT INTO yut_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop uŋun Josep dakon datni. Josep uŋun Maria dakon eni. Aŋakwan Maria da Yesu aŋalagɨt. Yesu uŋun Kristo yaŋ iyaŋ. ");
INSERT INTO yut_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abrahamon da wɨŋ Dewiron dagagɨt uŋun babɨkni 14 kabɨ. Aŋakwan Dewiron da wɨŋ uwalni da tɨmɨk Babilon mɨktɨmon paŋkɨwit bɨsap uŋun babɨkni 14 kabɨ. Aŋakwan Babilon egɨpgwiron da wɨŋ Kristo altagɨt uŋun kɨsi babɨkni 14 kabɨ. ");
INSERT INTO yut_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Kristo altagɨt uŋun dakon gen yaŋ. Meŋi Maria uŋun Josep da pasak do kɨlɨ manjɨwit. Mani dɨma paŋakwan Maria uŋun monjɨ kwap kɨlɨ awɨlgɨt. Monjɨ kwap awɨlgɨt uŋun Telagɨ Wup da tapmɨmon da awɨlgɨt. ");
INSERT INTO yut_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Aŋakwan Josep uŋun Maria monjɨ kwapni kɨnda awɨlak yaŋ nandaŋek yɨpmaŋ det do nandagɨt. Mani eni amɨn kɨlegɨ do amɨn morap da ɨŋamon Maria mayagɨ ɨm do dɨma nandagɨt. Yaŋ do aŋek pasɨlɨkon da kɨrɨŋɨk ɨm do nandagɨt. ");
INSERT INTO yut_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep yaŋ nandaŋek egakwan Amɨn Tagɨ dakon aŋelo kɨnda da dɨpmɨnon altaŋ ɨmɨŋek yaŋ iyɨgɨt, “Josep, Dewit da kabɨkon nani, Maria da monjɨ kwap uŋun Telagɨ Wup da tapmɨmon awɨlak, do Maria pak do dɨma pasolgi. ");
INSERT INTO yut_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Uŋun monjɨ wɨli aŋalaŋban mɨŋat amɨn kabɨni dɨwarɨni wɨrɨrɨgek iyɨ do tɨmɨtdɨsak, do mani Yesu yaŋ iyɨki.” ");
INSERT INTO yut_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Uŋun yo morap altaŋakwa Amɨn Tagɨ da kombɨ amɨn aŋtagap aban gen yagɨt uŋun bamɨ noman tagɨt. Gen uŋun yaŋ tosok. ");
INSERT INTO yut_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nandaki. Mɨŋat kɨnda amɨn gat dɨma pakbi kɨnda da monjɨ kwap awɨlek monjɨ wɨli kɨnda aŋalasak. Aŋalaŋban mani Emanuel yaŋ yoni.” (Emanuel dakon mibɨlɨ uŋun yaŋ: “Piŋkop nin gat egɨsak.”) ");
INSERT INTO yut_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep dɨpmɨnon da pɨdaŋek Amɨn Tagɨ dakon aŋelo da gen iyɨgɨt uŋun guramɨgek mɨŋatni Maria pagɨt. ");
INSERT INTO yut_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mani kaloŋɨ dɨma pagek egɨ wɨgɨ Maria da monjɨ wɨli kɨnda aŋalagɨt. Aŋalaŋban Josep da mani Yesu yaŋ iyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Judia mɨktɨmon kokup kɨnda mani Betlehem uŋudon Maria da Yesu aŋalagɨt. Uŋun bɨsapmon Erot da kɨla amɨn madep yɨkgɨt. Yesu altaŋakwan nandak nandak amɨn gɨldat wɨsak tetgɨn da Jerusalem kokup papmon apgwit. ");
INSERT INTO yut_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Abɨŋ Jerusalem amɨn yaŋ yoyɨwit, “Juda amɨn dakon kɨla amɨn madep altagɨt uŋun dukwan yɨkdak? Nin gɨkni gɨldat wɨsak tetgɨn da kaŋek gawak ɨm do abamaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kɨla amɨn madep Erot gen yawit uŋun nandaŋek wɨrɨpdakgɨt. Ae amɨn morap Jerusalem egɨpgwit uŋunyo kɨsi yaŋ gɨn nandaŋek wɨrɨpdakgwit. ");
INSERT INTO yut_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Erot da gen uŋun nandaŋek Israel amɨn dakon mukwa sogok amɨn dakon amɨn madep kabɨ gat ae gen teban yoyɨŋdet amɨn gat yaŋ yoban abɨŋ muwukgwit. Muwukba yaŋ yoyɨgɨt, “Kristo ni kokupmon altosak do yaŋbi?” ");
INSERT INTO yut_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yaŋban kobogɨ yaŋ iyɨwit, “Judia mɨktɨmon Betlehem kokupmon altosak. Kombɨ amɨn kɨnda da kalɨpsigwan yaŋ mandagɨt, ");
INSERT INTO yut_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlehem, Judia mɨktɨmon tosok, gagon kɨla amɨn madep kɨnda altokdɨsak, do gak Judia mɨktɨm dakon kokup morap yapmaŋdal. Uŋun amɨn da amɨn kabɨno Israel uŋun dakon kɨla amɨn madep egɨpdɨsak.’ ” ");
INSERT INTO yut_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yaŋ yaŋba nandaŋek yoyɨŋban kɨwit. Kɨŋakwa pasɨlɨkon da gɨk dakon mibɨlɨ nandak nandak amɨn Erot da yoyɨŋban apgwit. Apba yaŋ yoyɨgɨt, “Gɨk uŋun ni bɨsapmonsi altagɨt?” ");
INSERT INTO yut_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Yoyɨŋban gɨk noman tagɨt dakon bɨsap iyɨŋba nandaŋek Betlehem kokupmon yabegek yaŋ yoyɨgɨt, “Ji kɨŋ monjɨ uŋun kɨlegɨsi wusɨŋ koni. Kaŋek abɨŋ nayɨŋba nakyo kɨsi kɨŋ gawak ɨbeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Yaŋ yaŋban nandaŋek kɨŋakwa gɨk gɨldat wɨsak tetgɨn da kalɨp kawit aeni altaŋ yomgut. Gɨk uŋun kɨŋakwan yol aŋkɨ Monjɨ si pakgɨt yut da tɨlagon yɨkban kawit. ");
INSERT INTO yut_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Gɨk uŋun kaŋek but galak madepsi ");
INSERT INTO yut_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","nandaŋek yutnon wɨgek Monjɨ gat meŋi Maria gat pɨndakgwit. Pɨndagek ŋwakbeŋ aŋek Monjɨ gawak ɨmgwit. Yaŋ aŋek yɨkni wɨtdalek gol ae yo dɨwarɨ kɨbaŋɨ tagɨsi yumaŋ nogɨ wukwi but galak do ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Piŋkop da dɨpmɨnon Erot do dɨma tobɨl kɨni do yoyɨŋban nandaŋek kosit ŋwakŋwarɨ naŋ mɨktɨmnikon si kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nandak nandak amɨn uŋun kɨŋ mudaŋakwa, Amɨn Tagɨ dakon aŋelo da Josep dɨpmɨnon altaŋ ɨmɨŋek yaŋ iyɨgɨt, “Erot da Monjɨ aŋakban kɨmotjak do wɨsɨkdɨsak, do gak pɨdaŋ monjɨ ŋakŋak gat meŋi gat tɨmɨkbɨ Isip mɨktɨmon pasal kɨni. Isip sigɨn egakwa nak da aesi apni do don gayɨkeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yaŋban uŋudon gɨn Josep uŋun kalbi monjɨ ŋakŋak gat meŋi gat tɨmɨkban Isip kɨk do kosit wasawit. ");
INSERT INTO yut_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yaŋ aŋakwa kombɨ amɨn kɨnda da kalɨpsigwan gen yagɨt uŋun bamɨ noman tagɨt. Amɨn Tagɨ da aŋtagap aban yaŋ yagɨt: “Monjɨno Isip egɨsak uŋun opjak do yaŋ ɨmɨsat.” Josep gat mɨŋatni Monjiyo gat Isip mɨktɨmon paŋkɨ egakwa Erot don kɨmakgɨt. ");
INSERT INTO yut_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Erot da nandak nandak amɨn nak aŋkewalaŋ yaŋ nandaŋek butjap madepsi nandagɨt. Yaŋ nandaŋek Betlehem kokupmon ae kokup monɨŋ monɨŋ Betlehem da kapmatjok tawit uŋudon monjɨ wɨli morap bɨlakni bamorɨ dɨma yapbi uŋun emat amɨni da kɨsisi dapmaŋ mudoni do gen teban yɨpgut. Nandak nandak amɨn da gɨk ni bɨsapmon noman tagɨt uŋun kɨlɨ iyɨwit, do monjɨ morap uŋun bɨsapmon altawit uŋun kɨsi kɨmotni do gen teban yɨpgut. ");
INSERT INTO yut_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yaŋ aban kombɨ amɨn Jeremaia da kalɨpsigwan gen yagɨt uŋun bamɨ noman tagɨt. Gen uŋun yaŋ: ");
INSERT INTO yut_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama kokupmon kunam ae bupmɨ kapyo madepsi altosok. Resel uŋun monji kɨmakgwit uŋun do nandaŋek kunam madepsi takdak. Monjɨni kɨsi kɨmakgwit, do amɨn da burɨ aŋteban ak do aŋtɨdok aŋ. Kunamni kɨrɨŋɨk ɨmni do dɨma nandagɨt.” ");
INSERT INTO yut_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Erot kɨmagakwan Amɨn Tagɨ dakon aŋelo da Isip mɨktɨmon Josep dɨpmɨnon altaŋ ɨmgut. ");
INSERT INTO yut_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Altaŋ ɨmɨŋek yaŋ iyɨgɨt, “Monjɨ aŋat do yawit amɨn uŋun kɨlɨ kɨmakgwit. Do gak pɨdaŋ Monjɨ gat meŋi gat tɨmɨkbɨ aesi tobɨl Israel mɨktɨmon kɨni.” ");
INSERT INTO yut_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yaŋban Monjɨ gat meŋi gat tɨmɨkban Israel kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mani Erot kɨmagakwan monji Akelas da kɨla amɨn madep tamoni abɨdaŋek Judia mɨktɨm kɨla agɨt, do Judia mɨktɨmon kɨk do pasalgɨt. Josep dɨpmɨnon gen kɨnda yaŋ nandagɨt, “Ji Judia mɨktɨmon dɨma kɨni. Galili tetgɨn do kɨni.” ");
INSERT INTO yut_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Uŋun nandaŋek kokup kɨnda mani Nasaret, Galili mɨktɨmon tosok, uŋudon paŋkɨ egɨpgwit. Yaŋ aba kombɨ amɨn dakon gen bamɨ noman tagɨt. Gen uŋun yaŋ: “Nasaret amɨn yaŋ iyɨni.” ");
INSERT INTO yut_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Uŋun bɨsapmon Telagɨ Pakbi Sogok Amɨn Jon uŋun abɨŋ altagɨt. Abɨŋ altaŋek Judia mɨktɨmon amɨn da arɨpmɨ dɨma egɨpmɨ tɨmon mɨŋat amɨnyo uŋudon kwa Piŋkop gen yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Yoyɨŋek yaŋ yagɨt, “Piŋkop da Amɨn Kɨla Asak uŋun dakon bɨsap kwaŋ tosok, do ji but tobɨl ani.” ");
INSERT INTO yut_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kalɨpsigwan kombɨ amɨn Aisaia da Jon do gen yaŋ mandagɨt: “Mɨktɨm amɨn da arɨpmɨ dɨma egɨpmɨ tɨmon amɨn kɨnda da yaŋ tɨdaŋek yosok, ‘Amɨn Tagɨ dakon kosit aŋdɨmdɨm ani, kositni pasɨŋ aŋmɨlɨp ani.’ ” ");
INSERT INTO yut_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon da ɨlɨkba pɨgɨk paŋ egɨpgut uŋun bɨt madep kɨnda mani kamel uŋun dakon daŋgwani baŋ wasaŋbi. Aŋek bɨt gɨp kɨnda naŋ bobaŋ napmɨ do wamgut. Japni uŋun pɨlak pɨlak ae kabaŋ kok. ");
INSERT INTO yut_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Amɨn morapmɨ Jerusalem kokup papmon egɨpgwit, ae Judia mɨktɨmon egɨpgwit, ae Jodan Pakbi terɨ terɨ egɨpgwit uŋun kɨsi Jonon kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kɨŋ yokwini yaŋkwok aŋakwa Jodan Pakbikon telagɨ pakbi soŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aŋakwan Parisi amɨn morapmɨ gat Sadyusi amɨn morapmɨ gat telagɨ pakbi soŋ yomjak do Jonon apgwit. Apba pɨndagek yaŋ yoyɨgɨt, “Ji tuŋon amɨn emarɨ toŋ dakon gwakni kabɨ, Piŋkop da butjap nandaŋek yokwi pakpak do yo yokwisi aŋ yomdɨsak. Piŋkop dakon butjap apdɨsak namɨn da uŋun dakon but pɨso dayɨk da uŋun yap do pasal kwaŋ? ");
INSERT INTO yut_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ji but tobɨl bamɨsi aŋek aŋpakjikon but tobɨl dakon bamɨ aŋalon ani. ");
INSERT INTO yut_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ji dɨsi do ‘Nin Abraham dakon babɨkni’ yaŋ dɨma yoni. Yaŋsi dayɨsat, Piŋkop da yaŋban on tɨp kabɨ da Abraham dakon babɨkni tagɨ dagoni. Ji uŋun Abrahamon da altawit uŋun da yo madep dɨma asak. ");
INSERT INTO yut_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pareŋka uŋun kɨndap mibɨlon yɨpbi da tosok. Kɨndap morap bamɨ tagɨ dɨma toni uŋun mandaŋ kɨndapmon maba pɨgɨ sokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nak amɨn pakbisi baŋ telagɨ pakbi soŋ yomɨsat uŋun amɨn but tobɨl bamɨ aŋ dakon tɨlak asak. Mani nak da manjikon abɨsak amɨn uŋun dakon tapmɨm da nak dakon tapmɨm yapmaŋdak. Nak yombem yokwi da kandap gwɨlni tagɨ dɨma abɨdaŋ awɨlɨ. Uŋun amɨn da Telagɨ Wup gat ae kɨndap gat soŋ damdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Uŋun wit dakon sɨbɨt sɨbɨt wɨrɨrɨt kɨndap kɨrɨŋni kɨsitnikon taŋakwan apdɨsak. Abɨŋek bamɨ kokwinɨk tamonikon yopmaŋek sɨbɨt sɨbɨt wɨrɨrɨk maban kɨndap kɨmot kɨmorɨ mɨni uŋudon sokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Uŋun bɨsapmon Yesu Galili Provins yɨpmaŋek Jodan Pakbikon, Jon da telagɨ pakbi soŋ ɨmjak do opgut. ");
INSERT INTO yut_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mani Jon da kɨrɨŋɨk ɨmɨŋek yaŋ iyɨgɨt, “Nak da telagɨ pakbi soŋ gabeŋ do abɨl, uŋun tagɨ dɨma. Gak da telagɨ pakbi soŋ nabi kaŋ, uŋun da tagɨ asak.” ");
INSERT INTO yut_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yaŋ yaŋban Yesu da iyɨgɨt, “Dɨma, gak telagɨ pakbi soŋ nabi. Yaŋ aŋaki Piŋkop da yo morap aneŋ do nandɨsak uŋun kɨndasok dɨma yapmaŋek kɨsisi aŋ mudoneŋ.” Yaŋban Jon da geni guramɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pakbi soŋek Yesu pakbikon da wɨgɨt. Wɨŋek uŋudon gɨn kundu wɨtdal kɨŋakwan Yesu yaŋ kagɨt, Piŋkop dakon Wup kɨnarɨm da mɨktɨmon paŋ uŋun da tɨlak pɨŋ kwenikon yɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aŋakwan Kwen Kokupgwan da gen kɨnda yaŋ altagɨt: “Uŋun Monjɨno. Butno uŋun do tagɨsi aŋakwan but dasi galak taŋ ɨmɨsat.” ");
INSERT INTO yut_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Uŋun bɨsapmon Telagɨ Wup da Yesu Sunduk da aŋkewaljak do mɨktɨm amɨn da arɨpmɨ dɨma egɨpmɨ tɨmon aŋkɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aŋkɨ yɨpban Piŋkop do nandaŋek jap kelek egakwan gɨldat 40 ae pɨlɨn 40 mudagɨt, do jap do agɨt. ");
INSERT INTO yut_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aŋakwan Paŋkewal Amɨn da abɨŋ altaŋ ɨmɨŋek yaŋ iyɨgɨt, “Gak asi Piŋkop dakon Monji egɨsalon yoyɨŋbɨ tɨp on da bret dagabɨt.” ");
INSERT INTO yut_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mani Yesu da kobogɨ yaŋ iyɨgɨt, “Piŋkop da papiakon gen yaŋ tosok: ‘Bret dagɨn amɨn egɨp egɨp tagɨ dɨma yomjak. Piŋkop dakon gen kɨsi morap paŋek egɨp egɨp paŋ.’ ” ");
INSERT INTO yut_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yaŋ yaŋban Sunduk da Yesu aŋaŋ Piŋkop dakon telagɨ kokup papmon Jerusalem aŋaŋ kɨgɨt. Aŋkɨ Telagɨ Yut Madep da kwenon kwensi yɨpgut. ");
INSERT INTO yut_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Yɨpmaŋek yaŋ iyɨgɨt, “Piŋkop papiakon gen yaŋ tosok: ‘Uŋun da aŋeloni yoyɨŋban kɨlago tagɨsi ani. Ae kandapgo tɨpmon dɨma gɨtni yaŋ do aŋelo da gak kɨsit da kendak abɨŋ gepni.’ Gen yaŋ tosok, do gak asi Piŋkop dakon Monji kaŋ, gak amon mibɨlɨkon paŋ ma.” ");
INSERT INTO yut_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mani Yesu da yaŋ iyɨgɨt, “Piŋkop dakon papia da gen kɨnda gat yaŋ yosok, ‘Amɨn Tagɨ Piŋkopji dakon tapmɨm kok do aŋek dɨmasi aŋkewaldo.’ ” ");
INSERT INTO yut_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sunduk da aeni Yesu iyɨŋ aŋaŋ ɨleŋ dubagɨsi kɨndakon awɨgɨgɨt. Awɨgɨ on mɨktɨmon mɨktɨm madep madep morap kɨsi ae uŋudon yo tɨlɨmni toŋ gat kɨsi yolɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Yolɨŋek yaŋ iyɨgɨt, “Ŋwakbeŋ aŋek gawak nabi kaŋ, on yo morap kɨsi gabeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yaŋban Yesu da yaŋ iyɨgɨt, “Sunduk gak nepmaŋdet! Piŋkop dakon papia da yaŋ yosok: ‘Amɨn Tagɨ Piŋkopji uŋun naŋ gɨn gawak ɨmɨŋek oman aŋɨmni.’ ” ");
INSERT INTO yut_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yaŋ iyɨŋban Sunduk Yesu yɨpmaŋ dek kɨŋakwan aŋelo da abɨŋ Yesu aŋpulugawit. ");
INSERT INTO yut_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu Jon dam tebanon yɨpgwit yaŋ nandaŋek tobɨl Galili mɨktɨmon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasaret kokup yɨpmaŋek Kapaneam kokupmon kɨŋ uŋudon egɨpgut. Kapaneam uŋun Galili Pakbi Ɨdap ɨleŋɨkon, Sebulan ae Naptali mɨktɨmon uŋudon tosok. ");
INSERT INTO yut_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kapaneam kokupmon ekwan kombɨ amɨn Aisaia da gen kɨnda yagɨt uŋun bamɨ noman tagɨt. Gen uŋun yaŋ: ");
INSERT INTO yut_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulan mɨktɨm, ae Naptali mɨktɨm, Jodan Pakbi usugap tet do Galili mɨktɨmon tomal. Uŋun mɨktɨm bamot kosit tapmon pɨkwaŋ mɨktɨmon tomal. Galili mɨktɨmon Amɨn Ŋwakŋwarɨ Kabɨkon nani morapmɨ ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Uŋun amɨn pɨlɨn tukgwan egek kɨmot do pasolgoŋ, mani uŋun da teŋteŋɨ madep altaŋ yoban kɨlɨ kaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Uŋun bɨsapmon Yesu wasaŋek Piŋkop dakon gen yaŋ teŋteŋaŋek yaŋ yagɨt, “Piŋkop da Amɨn Kɨla Asak uŋun dakon bɨsap kwaŋ tosok, do ji but tobɨl ani.” ");
INSERT INTO yut_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu da Galili Pakbi Ɨdap kɨdɨpmɨŋ agek tap kɨlap do pi agak amɨn bamorɨ pɨndakgɨt. Kɨnda uŋun mani Saimon (ae mani kɨnda Pita), uŋun gat ae padɨge Andru gat pɨndakgɨt. Uŋun amɨn bamot tap kɨlap sɨmɨl sɨmɨl yɨkni pakbi ɨdapgwan mabal pɨgakwan egɨpgumal. ");
INSERT INTO yut_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Uŋun amɨn bamot pɨndagek Yesu da yaŋ yoyɨgɨt, “Abɨŋ nak nolgɨl, aŋakwal amɨn tɨmɨt tɨmɨt dakon kosit dolɨko.” ");
INSERT INTO yut_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yaŋban uŋudon gɨn tap kɨlap sɨmɨl sɨmɨl yɨkni yopmaŋek yolgɨmal. ");
INSERT INTO yut_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesu tɨmɨsok dɨ kɨŋek ae amɨn bamorɨ gat pɨndakgɨt, kɨnda uŋun Jems, Sebedi dakon monji, ae padɨge Jon. Uŋun bamot gat datni gat boron yɨgek tap kɨlap sɨmɨl sɨmɨl yɨkni bɨsawɨk paŋmɨlɨp aŋyo aŋakwal pɨndakgɨt. Pɨndagek yaŋ yoban ");
INSERT INTO yut_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","nandaŋek uŋudon gɨn botni gat datni Sebedi gat yopmaŋek yolgɨmal. ");
INSERT INTO yut_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu Galili mɨktɨm morap kɨsi agek muwut muwut yutnikon amɨn yoyɨŋ dekgɨt. Aŋek Piŋkop da amɨn kɨla akdɨsak dakon Gen Bin Tagɨsi yoyɨŋ teŋteŋagɨt. Yaŋ aŋek sotni toŋ ae gɨptɨmni yokwisi awit amɨn kɨsi morap paŋmɨlɨp agɨt. ");
INSERT INTO yut_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yaŋ aŋakwan gen bini da kɨŋ ɨreŋtaŋ Siria mɨktɨm kɨsi arɨpmɨ agɨt. Do amɨn da sot amɨn mibɨlɨ mibɨlɨ gat, ae amɨn gɨptɨmɨkon tepmɨ madepsi pawit amɨn gat, ae koŋni toŋ gat, ae sot kɨnda uŋun amɨn mɨktɨmon maŋ pagek gɨptɨmni nɨmnɨmɨkgaŋ uŋun gat, ae kɨdarɨ alek taŋbi uŋun kɨsi paŋapba Yesu da paŋmɨlɨp agɨt. ");
INSERT INTO yut_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Aŋakwan Galili mɨŋat amɨn morapmɨ gat, ae Dekapolis amɨn gat, ae Jerusalem, ae Judia, ae Jodan Pakbi usugap tet amɨn gat kɨsi da Yesu yolgwit. ");
INSERT INTO yut_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu mɨŋat amɨn kabɨ madep pɨndagek ɨleŋon pawɨgɨ yɨgakwan paŋdet kabɨni iyɨ yɨkgɨron apgwit. ");
INSERT INTO yut_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Apba yoyɨŋ degek yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Amɨn morap iyɨ do nak butnokon yo tagɨ mɨnisi yaŋ nandaŋ amɨn, uŋun amɨn da Piŋkop da Amɨn Kɨla Asak da kagagwan ekwaŋ, do uŋun kɨsɨk kɨsɨk ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Amɨn morap burɨkon da bupmɨ kunamyo madep aŋ, uŋun Piŋkop da butni paŋteban akdɨsak, do uŋun kɨsɨk kɨsɨk ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Amɨn morap iyɨ do nandaba paŋ, uŋun Piŋkop da yo morap yom do yagɨt uŋun yoban tɨmɨtdaŋ, do uŋun kɨsɨk kɨsɨk ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Amɨn morap aŋpak kɨlegɨ do amɨn da jap pakbiyo do nandaŋ uŋudeŋsi nandaŋ amɨn, uŋun Piŋkop da arɨpnikon yoban tugokdaŋ, do uŋun kɨsɨk kɨsɨk ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Amɨn morap notni do bupmɨ nandaŋ, uŋun amɨn Piŋkop da bupmɨ nandaŋ yomdɨsak, do uŋun kɨsɨk kɨsɨk ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Amɨn morap burɨ kɨlegɨsi toŋ, uŋun amɨn da Piŋkop kokdaŋ, do uŋun kɨsɨk kɨsɨk ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Amɨn morap emat pɨdokyo aŋakwa nawa gen yoŋ amɨn do, amɨn da Piŋkop dakon monjɨni yaŋ yoyɨkdaŋ, do uŋun kɨsɨk kɨsɨk ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Amɨn morap aŋpak kɨlegɨ aŋakwa aŋpakni kɨlegɨ do aŋek amɨn da yokwi aŋyomaŋ, uŋuden amɨn da Piŋkop da Amɨn Kɨla Asak da kagagwan egɨpdaŋ, do uŋun kɨsɨk kɨsɨk ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Amɨn da ji do Yesu dakon amɨn kabɨ yaŋ yaŋek yaŋba yokwi tok, ae top gen mibɨlɨ mibɨlɨ yaŋ damni, ae yokwiyo kɨsi aŋdamni kaŋ, ji kɨsɨk kɨsɨk ani. ");
INSERT INTO yut_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kalɨp kombɨ amɨn yaŋ gɨn dapmaŋ yolyo awit. Do jiyo kɨsi aŋpakji kɨlegɨ dakon tomni wukwisi Kwen Kokupmon tɨmɨtdaŋ, do but galak nandaŋek kɨsɨk kɨsɨk ani.” ");
INSERT INTO yut_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesu da saŋbeŋek yaŋ yagɨt, “Ji amɨn dakon tap ekwaŋ. Mani tap galagɨni pasɨlni kaŋ, niaŋsi aŋek galagɨni aŋkaluk aneŋ? Galagɨni yɨpmaŋ detjak kaŋ, pini mɨni. Ɨsal maba kwa amɨn da bamoŋ. ");
INSERT INTO yut_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ji amɨn dakon teŋteŋɨ yombem da ekwaŋ. Kokup madep kɨnda ɨleŋon taŋban yo kɨnda da arɨpmɨ dɨma aŋyoŋgam asak. ");
INSERT INTO yut_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Amɨn da lam koleŋ kwoba baŋ dɨma wɨtjɨŋba toŋ. Kwen tamonikon yopba yut kagagwan amɨn ekwaŋ uŋun kɨsi teŋteŋaŋ yomaŋ. ");
INSERT INTO yut_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yaŋgɨn, teŋteŋɨsi da amɨn da dabɨlon teŋteŋosak. Yaŋ aŋakwa amɨn da aŋpakji tagɨsi kaŋek Kwen Kokup Datji aŋkɨsini.” ");
INSERT INTO yut_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesu da saŋbeŋek yaŋ yagɨt, “Nak gen teban ae kombɨ amɨn dakon gen abo kɨŋ ɨsalɨ asak do dɨma pɨgɨm. Gen teban ae kombɨ amɨn dakon gen bamɨ toŋ aŋmudoni do pɨgɨm. ");
INSERT INTO yut_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nak asisi dayɨsat, kundu gat mɨktɨm gat tonjil da arɨpmon gen teban dakon gen jɨmjɨmjok kɨnda dɨma pasɨldɨsak. Gen kɨsi morap taŋ bamɨ toŋ akdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Amɨn kɨnda da gen teban monɨŋɨsok kɨnda yapmaŋek amɨn dɨwarɨ yaŋ gɨn ani do yoyɨŋdetjak kaŋ, uŋun amɨn Kwen Kokup Piŋkop da Kɨla Asak kokupmon mani pɨŋbisi. Mani amɨn kɨnda da gen teban guramɨgek amɨn dɨwarɨ yaŋ gɨn ani do yoyɨŋdetjak kaŋ, uŋun amɨn Kwen Kokup Piŋkop da Kɨla Asak kokupmon mani wukwisi. ");
INSERT INTO yut_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Asisi dayɨsat, ji dakon aŋpak kɨlegɨ uŋun da gen teban yoyɨŋdet ae Parisi amɨn dakon aŋpak dɨma yapni kaŋ, ji Piŋkop da Kwen Kokup Kɨla Asagon dɨma wɨgɨkdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesu da saŋbeŋek yaŋ yagɨt, “Gen kɨnda babɨk da abɨdawit uŋun ji kɨlɨ nandawit. Gen uŋun yaŋ: ‘Amɨn dɨma dapba kɨmotni. Amɨn kɨnda da amɨn kɨnda aŋakban kɨmotjak kaŋ, uŋun amɨn gen pikon kɨsak.’ ");
INSERT INTO yut_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mani nak yaŋ dayɨsat, amɨn kɨnda notni do butjap nandɨsak kaŋ, uŋun amɨn gen pikon kɨsak. Ae amɨn kɨnda notni do yaŋba yokwi tok asak kaŋ, uŋun amɨn gen kokwin amɨn kabɨ madepmon kɨsak. Ae amɨn kɨnda da amɨn kɨnda ‘Gak nandaŋ kokwingo tagɨ mɨni!’ yaŋ iyɨsak kaŋ, uŋun amɨn Tɨpdom dakon kɨndap tebanon pɨgɨsak. ");
INSERT INTO yut_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Do paretgo altakon paŋobɨŋek notgo kɨnda da nandaba yokwi tok aŋgamɨsak yaŋ nandɨsal kaŋ, ");
INSERT INTO yut_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","paretgo alta da kapmatjok yopbɨ toni. Yopbɨ taŋakwa mibɨltok gak kwi notgo uŋun gat but kaloŋ anjil. But kaloŋ aŋek don kɨŋ Piŋkop do paret aki. ");
INSERT INTO yut_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Amɨn kɨnda da gen pikon gep do gen yaŋ gaban kaŋ, jil gen pi tamokon kɨk do aŋek kosiron kɨŋek gen uŋun tepmɨsi aŋmɨlɨp ak do pi anjil. Yaŋ dɨma anjil kaŋ, uŋun amɨn da gen kokwin kɨla agak amɨn da kɨsiron gepban uŋun da obip amɨn da kɨsiron gepban dam teban yutnon gepdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Asisi gayɨsat, gak dam tebanon sigɨn egaki wɨgɨ moneŋ niaŋ yopbi do gayɨni uŋun kɨsisi yopmaŋek don waŋga kɨkdɨsal.” ");
INSERT INTO yut_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yesu da saŋbeŋek yaŋ yagɨt, “Ae gen kɨnda babɨk da abɨdawit uŋun ji kɨlɨ nandawit. Gen uŋun yaŋ: ‘Mɨŋat eyo kɨlɨ abi amɨn ji yumabi aŋpak dɨma ani.’ ");
INSERT INTO yut_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mani abɨsok nak da yaŋ dayɨsat, amɨn kɨnda mɨŋat kɨnda kaŋek uŋun do galak taŋ ɨmjak kaŋ, uŋun amɨn butnikon da yumabi kɨlɨ ak. ");
INSERT INTO yut_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Dabɨlgo amɨn tet da yokwikon gepban kaŋ, pɨlɨk mabɨ kɨsak. Gɨptɨm dɨwatgo kɨnda pasɨljak kaŋ, uŋun da yo madep dɨma asak. Mani gɨptɨmgo kɨsi kaloŋ maba Tɨpdomon pɨgɨsak kaŋ, uŋun da jɨgɨsi. ");
INSERT INTO yut_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ae kɨsitgo amɨn tet da yokwikon gepban kaŋ, mandaŋ dagaŋ mabɨ kɨsak. Gɨptɨm dɨwatgo kɨnda pasɨljak kaŋ, uŋun da yo madep dɨma asak. Mani gɨptɨmgo kɨsi kaloŋ maba Tɨpdomon pɨgɨsak kaŋ, uŋun da jɨgɨsi.” ");
INSERT INTO yut_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yesu da saŋbeŋek yaŋ yagɨt, “Kalɨp gen yaŋ yawit: ‘Amɨn kɨnda mɨŋatni kwɨnɨt do kaŋ, mɨŋat paŋkwɨnɨt dakon but pɨso papia kɨnda mɨŋatni do mandaŋ ɨmjak.’ ");
INSERT INTO yut_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mani abɨsok nak da yaŋ dayɨsat, mɨŋatgo kwɨnɨk yɨpbɨ kwan wɨli kaluk pasak kaŋ, eni gak da gulusuŋ al, do mɨŋatgo da yumabi asak. Aŋakwan wɨli uŋun kaluk pasak uŋun kɨsi yumabi asak. Do mɨŋatgo yumabi dɨma aŋakwan ɨsal dogɨn dɨma kwɨnɨkgi.” ");
INSERT INTO yut_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yesu da saŋbeŋek yaŋ yagɨt, “Ae gen kɨnda babɨk da abɨdawit uŋun ji kɨlɨ nandawit. Gen uŋun yaŋ: ‘Amɨn Tagɨ da dabɨlon gen yaŋ paŋteban asal uŋun dɨma yapmaŋek kɨsi guramɨgek abi.’ ");
INSERT INTO yut_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mani nak abɨsok yaŋ dayɨsat, gen yaŋ paŋteban ak dɨmasi ani. Kwen Kokup uŋun Piŋkop dakon kɨla amɨn madep yɨtyɨt tamoni, do Kwen Kokup manon da genji dɨma paŋteban ani. ");
INSERT INTO yut_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ae mɨktɨm uŋun Piŋkop dakon kandap yɨpyɨp tamoni, do mɨktɨm da manon genji dɨma yaŋ paŋteban ani. Ae Jerusalem uŋun Amɨn Tagɨ Madep Wɨkwisi dakon kokup papni, do Jerusalem da manon genji dɨma yaŋ paŋteban ani. ");
INSERT INTO yut_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ae ji da busuŋ daŋgwanji kɨnda kulabɨk aba kwakwagɨ bo pɨli uŋun arɨpmɨ dɨma asak, do busuŋji da manon genji dɨma yaŋ paŋteban ani. ");
INSERT INTO yut_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ji ‘asi’ bo ‘dɨma’ yaŋ gɨn yoni kaŋ, uŋun da tagɨ. Gen uŋun da kwenon saŋbeŋek yoŋ uŋun Yokwi Ami da paŋalon asak.” ");
INSERT INTO yut_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yesu da saŋbeŋek yaŋ yagɨt, “Ae gen kɨnda babɨk da abɨdawit uŋun ji kɨlɨ nandawit. Gen uŋun yaŋ: ‘Amɨn kɨnda da amɨn kɨnda dakon dabɨl aŋupbal asak kaŋ, uŋun amɨn dakon dabɨlniyo kɨsi aŋupbal ani. Ae amɨn kɨnda da amɨn kɨnda dakon geni aŋak bɨrɨpmɨtjak kaŋ, uŋun amɨn dakon geni kɨsi aŋak bɨrɨpmɨtni.’ ");
INSERT INTO yut_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mani nak da abɨsok yaŋ dayɨsat, amɨn da yokwi aŋdaba kobogɨ do yokwi dɨma aŋyomni. Amɨn kɨnda da mogɨm kulbak gɨkban kaŋ, mogɨmgo terɨ kɨnda kɨsi aŋtobɨl ɨbi. ");
INSERT INTO yut_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Amɨn kɨnda da gen pikon gepmaŋek kobogɨ do paba pɨgɨkgo abɨdok do yosak kaŋ, mɨrɨm ɨmalgo gat kɨsi ɨbi. ");
INSERT INTO yut_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ae amɨn kɨnda da yɨkni ɨmegek kosit 1 kilomita kɨki do tebaisi gayɨsak kaŋ, yɨk uŋun ɨmegek 2 kilomita kɨki. ");
INSERT INTO yut_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ae amɨn kɨnda da yo kɨnda ɨbi do gayɨsak kaŋ, ɨbi. Ae amɨn kɨnda da gagon goman ak do gayɨŋban kaŋ, manji dɨma ɨbi.” ");
INSERT INTO yut_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yesu da saŋbeŋek yaŋ yagɨt, “Ae gen kɨnda babɨk da abɨdawit uŋun ji kɨlɨ nandawit. Gen uŋun yaŋ: ‘Notgo do but dasi galak taŋ yomɨŋek uwalgo do nandabɨ yokwi toni.’ ");
INSERT INTO yut_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mani nak da yaŋ dayɨsat, ji uwalji do but dasi galak taŋ yomni. Aŋek yokwi aŋdamaŋ amɨn do bɨsit ani. ");
INSERT INTO yut_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yaŋ aŋek Piŋkop Datji Kwen Kokup egɨsak uŋun dakon monjinisi egɨpni. Uŋun da gɨldatni yɨpban amɨn yokwi ae kɨlegɨ kɨsikon mosok. Ae sɨkak yɨpban amɨn aŋpak kɨlegɨ aŋ ae yokwi aŋ kɨsikon mosok. ");
INSERT INTO yut_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Amɨn yokwi takis tɨmɨt tɨmɨt amɨn da notni baŋgɨn but dasi galak taŋ yomaŋ. Jiyo yaŋ gɨn ani kaŋ, Piŋkop da kobogɨ do yo tagɨ kɨnda dɨma damdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ji notji baŋgɨn gɨldat tagɨ yaŋ yoyɨni kaŋ, uŋun da tagɨ dɨma asak. Piŋkop dɨma nandaŋ ɨmaŋ amɨn kabɨ kɨsi yaŋ gɨn aŋ. ");
INSERT INTO yut_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kwen Kokup Datji gwaljɨgɨ mɨni kɨlegɨsi egɨsak, do jiyo yaŋ gɨn gwaljɨgɨ mɨni kɨlegɨsi egɨpni.” ");
INSERT INTO yut_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesu da saŋbeŋek yaŋ yagɨt, “Ji kaŋ kɨmotni. Amɨn da dandani yaŋ do uŋun da dabɨlon aŋpak tagɨ ani kaŋ, Datji Kwen Kokup egɨsak uŋun da uŋun dakon kobogɨ do yo tagɨ kɨnda dɨma daban abɨdokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Wadak wadak amɨn do yo yom do aki bɨsapmon jamba but amɨn dɨwarɨ da muwut muwut yutnon ae kosit madepmon aŋ, uŋudeŋ amɨn kɨnda yabekbɨ mibɨltaŋ gamɨŋek kweŋ dɨma pɨsosak. Yaŋ aŋ amɨn uŋun amɨn da nandaba wukwan yomni yaŋ do aŋ. Nak asisi dayɨsat, uŋun kobogɨ kɨsisi wagɨlni tɨmɨkgaŋ. ");
INSERT INTO yut_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mani yo do wadak wadak aŋ amɨn do yo yobi bɨsapmon noman amɨn da gandani do dɨma yobi. ");
INSERT INTO yut_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yaŋ aŋaki Datgo yo pasɨlɨ pɨndakdak uŋun da kobogɨ do yo tagɨ gamdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yesu da saŋbeŋek yaŋ yagɨt, “Ji bɨsit ani bɨsapmon jamba but amɨn da aŋ uŋudeŋ dɨma ani. Jamba but amɨn uŋun muwut muwut yut madepmon ae kokup papmon kosit amal amalon uŋudon agek bɨsit ak do galagɨsi nandaŋ. Uŋun amɨn amɨn da pɨndatni do yaŋ aŋ. Nak asisi dayɨsat, kobogɨni kɨsi wagɨlni tɨmɨkgaŋ. ");
INSERT INTO yut_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mani gak bɨsit ak do nandɨsal kaŋ, yutgokon wɨgɨ yoma sopmaŋek Datgo pasɨlɨ egɨsak uŋun bɨsit iyɨki. Yaŋ aŋaki Datgo yo pasɨlɨ pɨndakdak uŋun da kobogɨ tagɨsi gamdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Amɨn Ŋwakŋwarɨ Kabɨ gen ɨsalɨ morapmɨ yaŋapno piŋkopnin da genin nandɨsak yaŋ nandaŋ. Mani ji bɨsit ani bɨsapmon yaŋ dɨma ani. ");
INSERT INTO yut_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ji uŋun amɨn da aŋ uŋudeŋ dɨma ani, nido Datji dɨma iyɨŋakwa yo morap do wadak wadak aŋ uŋun nandaŋ mudosok. ");
INSERT INTO yut_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ji bɨsit yaŋ ani: ‘Datnin Kwen Kokup egɨsal, gak dakon man telagɨ tosak. ");
INSERT INTO yut_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Amɨn Kɨla Agakgo yɨpbɨ ninon apjak. Gak dakon gen guramɨt Kwen Kokup tosok, mɨktɨmon ninon yaŋ gɨn tosak. ");
INSERT INTO yut_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Abɨsok gɨldat dakon jap arɨpninon nibi. ");
INSERT INTO yut_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nin amɨn notnin dakon yokwini yopmaŋgamaŋ. Uŋudeŋ gɨn yokwinin wɨrɨrɨk nibi. ");
INSERT INTO yut_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Paŋkewalon dɨmasi nipbi. Yokwi Ami da kɨsiron naŋ pulugaŋ nipbi.’ ");
INSERT INTO yut_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ji notji dakon yokwini yopmaŋ yomni kaŋ, Datji Kwen Kokup egɨsak uŋun da yokwisi yopmaŋ damjak. ");
INSERT INTO yut_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mani amɨn dakon yokwini dɨma yopmaŋ yomni kaŋ, Datji da yokwisi dɨma yopmaŋ damjak.” ");
INSERT INTO yut_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesu da saŋbeŋek yaŋ yagɨt, “Ji Piŋkop do nandaŋek jap kelek egɨp do nandaŋ kaŋ, jamba but amɨn da aŋ uŋudeŋ tomno dabɨlyosi dɨma ɨŋan toni. Yaŋ ani kaŋ, amɨn da ji Piŋkop do nandaŋek jap dɨma noŋ yaŋ dandani. Nak asisi dayɨsat, uŋun amɨn kobogɨni kɨsi wagɨlni tɨmɨk mudoŋ. ");
INSERT INTO yut_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mani ji Piŋkop do nandaŋek jap kelek egɨp do nandaŋ kaŋ, busuŋ daŋgwanji wayɨgek tomno dabɨlyosi pakbi baŋ sugoni. ");
INSERT INTO yut_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yaŋ aŋakwa amɨn da ji jap kelek ekwaŋ yaŋ dɨma nandaŋ damni. Mani Datji pasɨlɨ egek yo pasɨlɨ pɨndakdak uŋun da dandaŋek kobogɨ tagɨsi damdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yesu da saŋbeŋek yaŋ yagɨt, “Ji on mɨktɨmon yo tagɨsi paŋmuwut do nandak nandak dɨma ani. Uŋun yo monɨŋ da nokdaŋ, ae maŋut maŋut akdaŋ, ae kabo noknok da yutji tuwɨlek paŋkɨsɨbɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yo tagɨsi Kwen Kokupmon paŋmuwut do nandak nandak ani. Uŋudon yo monɨŋ da dɨma nokdaŋ, ae maŋut maŋut dɨma akdaŋ, ae kabo noknok da yutji tuwɨlek arɨpmɨ dɨma tɨmɨtdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yo kabɨgo tagɨsi dukwan toŋ, but nandak nandakyosi kɨsi uŋudon gɨn tokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yesu da saŋbeŋek yaŋ yagɨt, “Dabɨl uŋun gɨptɨm dakon teŋteŋɨ. Dabɨlgo tagɨsi kaŋ, gɨptɨmgo kaloŋ teŋteŋɨni toŋ. ");
INSERT INTO yut_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mani dabɨlgo yokwi kaŋ, gɨptɨmgo kɨsi pɨlɨn tuksi asak. Do teŋteŋɨ butgokon tosok uŋun pɨlɨn tuksi asak kaŋ, uŋun da pɨlɨn tuk madepsi asak.” ");
INSERT INTO yut_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yesu da saŋbeŋek yaŋ yagɨt, “Amɨn kɨnda da amɨn tagɨ bamorɨ dakon oman arɨpmɨ dɨma asak. Yaŋ kaŋ, kɨnda naŋgɨn galak taŋ ɨmɨŋek kɨnda do nandaban yokwi taŋ ɨmdɨsak. Ae kɨnda dakon gen guramɨgek kɨnda manji ɨmdɨsak. Ji Piŋkop gat ae moneŋ gat kɨsi dakon oman monjɨni arɨpmɨ dɨma egɨpmɨ.” ");
INSERT INTO yut_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yesu da saŋbeŋek yagɨt, “Uŋun do aŋek yaŋ dayɨsat, ji egɨp egɨpji do nandaba kɨk aŋek jap pakbiyo ni baŋ noneŋ yaŋ dɨma nandani. Ae gɨptɨmji do nandaŋek ɨmal dukon baŋ paneŋ, yaŋ nandaŋek nandaba kɨk dɨma ani. Egɨp egɨpji da jap yapmaŋdak, ae gɨptɨmji da ɨmal yapmaŋdak. ");
INSERT INTO yut_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ji mɨnam pɨndakgaŋ uŋun do nandani. Jap yet dɨma kwaokgaŋ, ae jap paŋmuwut yutnon jap dɨma paŋek paŋmuwuk yopmaŋgaŋ. Mani Datji Kwen Kokup egɨsak uŋun da jap upmokdok. Ji pɨŋbi aŋakwa mɨnam da yo madep yaŋ nandaŋ, ma? ");
INSERT INTO yut_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ji nandaba kɨk aŋek egɨp egɨpji tɨmɨsok dɨ gat tagɨ saŋbeŋba wɨgɨsak yaŋ nandaŋ, ma? Uŋun arɨpmɨ dɨmasi. ");
INSERT INTO yut_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ji nido ɨmal do nandaba kɨk aŋ? Jareŋ oni taŋ aŋaŋ kwaŋ uŋun do nandani. Pi madep aŋek ɨmal dɨma bupmaŋgaŋ. ");
INSERT INTO yut_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mani yaŋ dayɨsat, jareŋ pɨndakgaŋ uŋun dakon tɨlɨmni da kalɨp kɨla amɨn madep Solomon dakon tɨlɨmni tagɨsi pagɨt uŋun yapmaŋdak. ");
INSERT INTO yut_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","On joŋ taŋ aŋaŋ kwaŋ uŋun aŋwa amɨn da baljaŋ kɨndapmon sokdaŋ. Mani Piŋkop da si paŋtɨlɨm asak, do nandaŋ gadatji pɨsɨpmɨsok amɨn ji yaŋsi nandani, Piŋkop da ji do nandaban yo madepsi aŋakwan ɨmal tɨlɨmɨ toŋsi baŋ paŋ damdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Nandaba kɨk aŋek jap pakbiyo dukon baŋ noneŋ, bo ɨmal dukon baŋ paneŋ yaŋ dɨma nandani. ");
INSERT INTO yut_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Piŋkop dɨma nandaŋ ɨmaŋ amɨn kabɨ da yo morap uŋuden wusɨk do nandaba kɨk aŋ. Mani Datji Kwen Kokup egɨsak uŋun da ji uŋun yo morap do wadaŋ uŋun nandaŋ mudosok. ");
INSERT INTO yut_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Do mibɨltok Piŋkop dakon Amɨn Kɨla Agakni uŋun wɨsɨŋ kok do pini ani, ae aŋpakni kɨlegɨ wusɨk do pini ani. Yaŋ aŋakwa yo dɨwarɨ do wadak wadak aŋ uŋun kɨsi damdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Do aŋwa gɨldat do nandaba kɨk dɨma ani. Gɨldat kaloŋ kaloŋ dakon jɨgɨ uŋun iyɨ da arɨpmon taŋ taŋ aŋ.” ");
INSERT INTO yut_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesu da saŋbeŋek yagɨt, “Ji amɨn dakon aŋpak dɨma kokwinɨtni. Yaŋ ani kaŋ, Piŋkop da jiyo kɨsi kokwin akdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Amɨn dakon aŋpak kokwin niaŋsi ani, Piŋkop da jiyo kɨsi uŋudeŋ gɨn kokwin akdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Gaga da dabɨlon kɨndap kwɨk tosok uŋun do dɨma nandaŋek notgo da dabɨlon jɨmjɨm nido kosol? ");
INSERT INTO yut_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Gaga da dabɨlon kɨndap kwɨk taŋakwan niaŋon da notgo ‘Dabɨlgokon jɨmjɨm tosok uŋun paŋ gamdɨsat’ yaŋ tagɨ iyɨki? ");
INSERT INTO yut_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Gak jamba but amɨn. Mibɨltok gaga da dabɨlon kɨndap kwɨk tosok uŋun abɨ kɨŋakwan notgo da dabɨlon jɨmjɨmjok tosok uŋun kaŋbɨ pɨsaŋakwan tagɨ paki. ");
INSERT INTO yut_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Yo telagɨ pɨŋan do dɨma yomni. Yoba tobɨlek ɨnjɨŋ dabam. Ae kɨndɨrɨŋji tagɨsi bɨt do dɨma yomni. Yoba kandap da dɨ bamaŋ mɨsɨŋɨkbam.” ");
INSERT INTO yut_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesu da saŋbeŋek yaŋ yagɨt, “Piŋkop bɨsit iyɨŋba yo damjak. Pinisi aŋek wusɨŋ pɨndatni. Yoma domon tɨdaŋba Piŋkop da wɨtdal damjak. ");
INSERT INTO yut_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Amɨn morap Piŋkop bɨsit iyaŋ uŋun yo tɨmɨkgaŋ, ae yo wɨsaŋ amɨn uŋun bamɨ koŋ, ae yoma domon tɨdoŋ amɨn uŋun wɨtdal yomɨsak. ");
INSERT INTO yut_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Monjɨsi kɨnda da datni bret do iyɨŋban tɨp kɨnda tagɨ ɨmjak? ");
INSERT INTO yut_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bo tap kɨlap do iyɨŋban tuŋon amɨn emarɨ toŋ kɨnda tagɨ ɨmjak? Uŋun arɨpmɨ dɨmasi. ");
INSERT INTO yut_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ji yokwi morapmɨ aŋ, mani yo tagɨsi monjɨsi do yom do nandaŋ. Do yaŋsi nandani. Bɨsit iyɨŋba Datji Kwen Kokup egɨsak uŋun da but galagon da yo tagɨsi damdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Amɨn da aŋpak tagɨsi niaŋsi aŋdamni do nandaŋ, uŋun aŋpak amɨn do aŋyomni. Moses dakon gen teban gat ae kombɨ amɨn dakon gen gat da yaŋsi ani do yosok.” ");
INSERT INTO yut_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yesu da saŋbeŋek yaŋ yagɨt, “Ji wigat gɨtni naŋ pɨgɨni. Amɨn wagɨl tasɨk tokdaŋ dakon kokupmon pɨgɨk dakon wigat gat ae kositni gat uŋun ɨlalogɨsi, do uŋun naŋ yolek pɨgɨk uŋun tagapmɨsi. Amɨn morapmɨsi da wigat uŋun naŋ pɨkwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mani egɨp egɨp dagok dagogɨ mɨnikon kɨgɨk dakon wigat gat ae kositni uŋun gɨtnisi, uŋudon kɨgɨk dakon pini jɨgɨsi. Amɨn kaloŋ kaloŋ dagɨn wigat uŋun kaŋ kwoŋ.” ");
INSERT INTO yut_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesu da saŋbeŋek yaŋ yagɨt, “Ji kombɨ amɨn toptopmɨ uŋun do pɨndak kɨmotni. Gɨptɨmni yaworɨsi sipsip yombem, mani burɨgwan joŋ pɨŋan butni taŋ yomaŋ. ");
INSERT INTO yut_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ji aŋpakni pɨndak nandaŋyo aŋek kombɨ amɨn toptopmɨ yaŋ pɨndakba pɨsoni. Nap kelɨ toŋ da wain sop arɨpmɨ dɨma potni. Ae jal da kɨmɨp arɨpmɨ dɨma wigɨljak. ");
INSERT INTO yut_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kɨndap tagɨ da bamɨ tagɨ pokgoŋ, ae kɨndap yokwi da bamɨ yokwi pokgoŋ. ");
INSERT INTO yut_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kɨndap tagɨ da bamɨ yokwi arɨpmɨ dɨma potni, ae kɨndap yokwi da bamɨ tagɨ arɨpmɨ dɨma potni. ");
INSERT INTO yut_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kɨndap morap bamɨ dɨma pokgoŋ uŋun amɨn da mandaŋ kɨndapmon sosoŋ. ");
INSERT INTO yut_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yaŋdo, ji aŋpakni pɨndak nandaŋyo aŋek kombɨ amɨn toptopmɨ yaŋ pɨndakba pɨsoni. ");
INSERT INTO yut_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‘Amɨn Tagɨno’ yaŋ yaŋ namaŋ amɨn uŋun kɨsisi Piŋkop da Kwen Kokup Kɨla Asagon dɨma wɨgɨkdaŋ. Datno Kwen Kokup egɨsak uŋun dakon gen guramɨkgaŋ amɨn uŋun dagɨn wɨgɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Amɨn morapmɨ da bɨsap madepmon yaŋsi nayɨkdaŋ, ‘Amɨn Tagɨnin, nin gak da manon kombɨ gen yagɨmaŋ, ae koŋ yolgɨmaŋ, ae pi madep agɨmaŋ.’ ");
INSERT INTO yut_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yaŋ yaŋba yaŋsi yoyɨkdɨsat, ‘Yokwi pakpak amɨn, ji dɨma nandaŋ damɨsat. Nepmaŋ dek kɨŋ mudabɨt!’ ” ");
INSERT INTO yut_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nak dakon gen guramɨkgaŋ amɨn uŋun amɨn kɨnda yombem. Uŋun amɨn nandaŋ kokwini tagɨsi, yutni mɨktɨm tebaikon wɨtjɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Aŋakwan sɨkak pakbi kulup mɨrɨmyo da abɨŋ tɨdaŋ aŋtɨdok aba mɨktɨm tebaikon wɨtjɨŋbi, do tebai tagɨt. ");
INSERT INTO yut_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mani geno dɨma guramɨkgaŋ amɨn uŋun amɨn kɨnda yombem. Uŋun nandaŋ kokwini tagɨ dɨma, do yutni mɨktɨm yaworɨkon wɨtjɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Aŋakwan sɨkak pakbi kulup mɨrɨmyo da abɨŋ tɨdaŋ tuwɨlba maŋ tasɨk tagɨt.” ");
INSERT INTO yut_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu gen uŋun yaŋ mudaŋban mɨŋat amɨn kabɨ madep da kaŋek tamtam yaŋ ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Nido yoyɨŋdet pi agɨt uŋun gen teban yoyɨŋdet amɨn yapmaŋ mudaŋek ŋwakŋwarɨsi agɨt. Amɨn kɨnda da pi uŋun asak do yaŋ mudaŋ ɨbi da tɨlak agɨt. ");
INSERT INTO yut_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu ɨleŋon da pɨŋ kɨŋakwan mɨŋat amɨn kabɨyo morapmɨ da yolgwit. ");
INSERT INTO yut_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yolek amɨn wuda tebani toŋ kɨnda da Yesukon kɨŋ ŋwakbeŋ aŋ ɨmɨŋek yaŋ iyɨgɨt, “Amɨn Tagɨ, Piŋkop da dabɨlon kɨlek tokeŋ do nandɨsal kaŋ, tagɨ aŋmɨlɨp abɨ kɨlek tokeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yaŋban Yesu da kɨsitni amɨn uŋun da kwenon wɨtjɨŋek yaŋ iyɨgɨt, “Kɨlek toki do nandɨsat, do pasɨl gamni!” Yaŋ yaŋakwan uŋudon gɨn wudani kɨbɨdaŋakwa gɨptɨmni kɨlek tagɨt. ");
INSERT INTO yut_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kɨlek taŋban Yesu da yaŋ iyɨgɨt, “Nandaki, gak uŋun do amɨn dɨma yoyɨŋek mukwa sogogon kɨŋek gɨptɨmgo yolɨki. Aŋek Moses da yagɨt uŋun da tɨlagon paret aŋaki amɨn da asi kɨlek tal yaŋ gandani.” ");
INSERT INTO yut_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu Kapaneam kokupmon pɨgakwan Rom dakon emat amɨn 100 dakon kɨla amɨn kɨnda da abɨŋ aŋpulugosak do aŋek yaŋ iyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Amɨn Tagɨ, oman monjɨno yutnon pokdok. Kɨdarɨ alek taŋ, ae tepmɨ madepsi nandɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yaŋban Yesu da yaŋ iyɨgɨt, “Nak da kɨŋ aŋmɨlɨp abeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Yaŋban mibɨltok amɨn uŋun da yaŋ iyɨgɨt, “Amɨn Tagɨ, nak madepno da yoŋgamgwan egɨsat, do nak da yutnon wɨki uŋun da tagɨ dɨma asak. Ɨsal yum gen gɨn yaŋaki oman monjɨno kɨlek tosak. Nak naga mibɨltok amɨno egakwan pɨŋbini egɨsat. Ae emat amɨno uŋun nak dakon pɨŋbino ekwaŋ. Emat amɨno kɨnda ‘Kɨ!’ yaŋ iyɨko kɨsak. Ae kɨnda ‘Ap!’ yaŋ iyɨko abɨsak. Ae oman amɨno kɨnda ‘Pi on aki!’ yaŋ iyɨko pi asak. Do ɨsal yum gen gɨn yaŋaki oman monjɨno kɨlek tosak.” ");
INSERT INTO yut_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu da gen uŋun yagɨt do nandaban yo madepsi aban buŋon yol awɨlgwit amɨn yaŋ yoyɨgɨt, “Asisi dayɨsat, Israel amɨnon nandaŋ gadatni madep on amɨn dakon yombem kɨnda dɨma kagɨm. ");
INSERT INTO yut_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yaŋ dayɨsat, amɨn morapmɨsi da gɨldat wɨsak, ae si pɨgɨsak tetgɨn da apba Kwen Kokup Piŋkop da Amɨn Kɨla Asak da kagagwan Abraham, Aisak, ae Jekop gat jap noknok tamo madepmon yɨtdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mani Juda amɨn kalɨp Piŋkop da iyɨ Amɨn Kɨla Asak da kagagwan pɨgɨni do manjɨkbi uŋun maban pɨlɨn tukgwan pɨgɨkdaŋ. Uŋungwan kunam tagek iyoŋ iyoŋ yaŋ tɨdaŋek egɨpdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yaŋ yaŋek emat amɨn 100 dakon kɨla amɨn yaŋ iyɨgɨt, “Gak kɨŋ yo altoni do nandaŋ teban tal uŋun yaŋ gɨn noman taŋ ɨmeŋ kokdɨsal.” Gen uŋun iyɨgɨt uŋun bɨsapmonsi oman monjɨni kɨlek tagɨt. ");
INSERT INTO yut_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu uŋudon da kɨŋ Pita da yutnon wɨgɨ kaŋban Pita dakon yopmi gɨptɨmɨ kɨndapmɨ soŋakwan sot aŋek pakgɨt. ");
INSERT INTO yut_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yaŋ kaŋek kɨsitni kɨsirɨkon wutjɨŋban sotni yɨpmaŋ dekgɨt. Yaŋ aban pɨdaŋek Yesu do jap paŋnoman agɨt. ");
INSERT INTO yut_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Gɨldat pɨgakwan pɨlɨndo koŋni toŋ amɨn morapmɨ paŋpaŋ apba gen yaŋek koŋ yol yomgut. Aŋek sot amɨn kɨsisi paŋmɨlɨp agɨt. ");
INSERT INTO yut_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yaŋ aŋakwan kombɨ amɨn Aisaia da kalɨpsigwan gen mandagɨt uŋun bamɨ noman tagɨt. Gen uŋun yaŋ: “Iyɨ sotnin mibɨlɨ mibɨlɨ iyɨ do tɨmɨgakwan kɨlek tagɨmaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu da amɨn morapmɨ aŋgwasɨŋek akba pɨndagek paŋdetni yaŋ yoyɨgɨt, “Nin pakbi ɨdap terɨ kɨnda do kɨno.” ");
INSERT INTO yut_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aŋakwan gen teban yoyɨŋdet amɨn kɨnda da obɨŋ Yesu yaŋ iyɨgɨt, “Yoyɨŋdet, gak dukwan dukwan agɨpbi uŋun nak gol awɨlgeŋ gɨn.” ");
INSERT INTO yut_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yaŋban Yesu da yaŋ iyɨgɨt, “Joŋ pɨŋan uŋun mɨktɨmgwan yutni toŋ. Ae mɨnam kwen akwaŋ uŋun yutni toŋ. Mani Amɨn Dakon Monjɨ uŋun dɨpmɨn potpot tamoni mɨni.” ");
INSERT INTO yut_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yaŋban paŋdetni kɨnda da Yesu yaŋ iyɨgɨt, “Amɨn Tagɨ, nandaŋ namɨŋaki kɨŋ datno wayɨk yɨpmaŋek don abɨŋ golgeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mani Yesu da yaŋ iyɨgɨt, “Amɨn kɨmakbi da kɨmakbi notni iyɨ tagɨ wayɨtni. Aŋakwa gak nak nol.” ");
INSERT INTO yut_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yaŋ yaŋek boron wɨgakwan paŋdetni kɨsi yolek wɨgɨwit. ");
INSERT INTO yut_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Wɨgɨ pakbi ɨdapmon kɨŋakwa tepmɨsi mɨrɨm madepsi da abɨŋ pakbi tamalɨgakwan boron pɨgɨwit. Yaŋ aŋakwan Yesu dɨpmɨn pagakwan ");
INSERT INTO yut_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","paŋdetni da kɨŋ aŋyolek iyɨwit, “Amɨn Tagɨ, nin paŋpuluga! Pakbi oni naŋ kɨmotdamaŋ!” ");
INSERT INTO yut_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yaŋ yaŋba Yesu da yoyɨgɨt, “Ji nido pasolgoŋ? Nandaŋ gadatji pɨsɨpmɨ.” Yaŋ yaŋek pɨdaŋ agek mɨrɨm gat ae pakbi gat tebai yoyɨŋban mɨrɨm yawogakwan pakbi wayɨŋ dɨmasi agɨt. ");
INSERT INTO yut_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Aban paŋdetni tamtam yaŋek yawit, “On niaŋen amɨn kɨnda da mɨrɨm pakbiyo yoyɨŋban geni guramɨkgamal?” ");
INSERT INTO yut_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu pakbi ɨdap terɨ kɨnda Gadara mɨktɨmon kɨŋ altaŋban amɨn bamorɨ koŋni toŋ uŋun da amɨn kɨmakba paŋkɨ tɨp kɨnamgwan yopmaŋgaŋ mɨktɨmon da abɨŋ Yesu altaŋ ɨmgumal. Uŋun amɨn bamot amɨn dapdapni yokwisi. Do amɨn uŋun do pasalek uŋun kosit naŋ dɨma agɨpgwit. ");
INSERT INTO yut_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Uŋun amɨn bamot da yaŋ tɨdaŋek Yesu yaŋ iyɨgɨmal, “Piŋkop dakon Monji, niaŋsi aŋnim do abɨsal? Tepmɨ yomyom bɨsap dɨma noman taŋakwan tepmɨ pi nimdɨsal?” ");
INSERT INTO yut_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Dubagɨ yaŋgok bɨt kabɨ madep dɨ jap naŋek egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Koŋ uŋun da Yesu bɨsit tebaisi yaŋ iyɨgɨmal, “Nol nipbɨ abɨgɨneŋ kaŋ, uŋun bɨt kabɨ da butgwan pɨgɨneŋ do nandamaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yaŋba yoyɨgɨt, “Ji abɨgɨt!” Yaŋ yaŋban koŋ da amɨnon da wɨŋ kɨŋek bɨt da butgwan pɨgɨwit. Pɨgakwa bɨt uŋun tɨmtɨm yaŋek gɨlokon da pakbi ɨdapgwan maŋek pakbi naŋ kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kɨmagakwa bɨt kɨla amɨn da tɨmtɨm yaŋek kɨŋ kokupmon bɨt gat ae koŋni toŋ amɨn gat dakon geni amɨn yoyɨwit. ");
INSERT INTO yut_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yoyɨŋba amɨn kɨsisi Yesu kok do abɨŋ mudawit. Abɨŋ kaŋek mɨktɨm uŋun yɨpmaŋek kɨsak do bɨsit tebai iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu bot kɨnda abɨdaŋek pakbi ɨdap terɨ kɨnda iyɨ da kokupmon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aŋakwan amɨn kabɨ kɨnda da amɨn kɨsit kandapmɨyo kɨmakbi kɨnda wamaŋ uŋudon aŋapgwit. Aŋapba Yesu da nandaŋ gadatni pɨndagek amɨn uŋun yaŋ iyɨgɨt, “Monjɨ, dɨma pasolgi, dɨwarɨgo wɨrɨrɨk gamɨsat.” ");
INSERT INTO yut_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yaŋ yaŋban gen teban yoyɨŋdet amɨn dɨwarɨ da notni yoyɨŋ yoyɨŋ aŋek yaŋ yawit, “Ma! On amɨn Piŋkop kulabɨsak!” ");
INSERT INTO yut_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yaŋ yaŋakwa Yesu da pɨndak mudaŋek yaŋ yoyɨgɨt, “Nidosi butjikon da nandak nandak yokwi uŋun nandaŋ? ");
INSERT INTO yut_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Dɨwarɨ wɨrɨrɨt ae amɨn kɨsit kandapmɨyo kɨmakbi paŋmɨlɨp agak uŋun kɨsi amɨn da arɨpmɨ dɨma agagɨ. Mani nak Amɨn Dakon Monji. Amɨn gɨptɨm paŋmɨlɨp agak dakon pi abeŋ do yaŋ mudaŋ nabi, do nandani, on mɨktɨmon dɨwarɨ wɨrɨrɨt dakon pi abeŋ do yaŋ mudaŋ nabi yaŋsi nandaba pɨsosak.” Yaŋ yaŋek amɨn kɨsit kandapmɨyo kɨmakbi yaŋ iyɨgɨt, “Gak pɨdaŋ yalɨŋ potgo tɨmɨgek yutgokon kɨ.” ");
INSERT INTO yut_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yaŋ yaŋban nandaŋek amɨn uŋun pɨdaŋ yutnikon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mɨŋat amɨn kabɨ madep uŋun yo ŋwakŋwarɨsi kaŋek pasalgwit. Aŋek Piŋkop aŋkɨsiŋek yaŋ yawit, “Mao, Piŋkop da tapmɨm madepsi amɨn do yomɨsak!” ");
INSERT INTO yut_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu uŋudon da kɨŋ amɨn kɨnda kagɨt mani Matyu, uŋun takis tɨmɨt tɨmɨt yut kabeŋon yɨkgɨt. Kaŋek yaŋ iyɨgɨt, “Abɨŋ nak nol.” Yaŋban Matyu pɨdaŋ Yesu yolgɨt. ");
INSERT INTO yut_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu Matyu da yutnon yɨgek jap naŋek takis tɨmɨt tɨmɨt amɨn morapmɨ ae yokwi pakpak amɨn morapmɨ da apba Yesu gat paŋdetni gat kɨsi yɨgek jap nawit. ");
INSERT INTO yut_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jap naŋakwa pɨndagek Parisi amɨn dɨwarɨ da paŋdetni yaŋ yoyɨwit, “Yoyɨŋdetji uŋun nido takis tɨmɨt tɨmɨt amɨn gat yokwi pakpak amɨn gat kɨsi yɨgek jap noŋ?” ");
INSERT INTO yut_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu da gen uŋun nandaŋek yaŋ yoyɨgɨt, “Sotni mɨni amɨn wuda wamagon dɨma kwaŋ. Sotni toŋ amɨn dagɨn wuda wamagon kwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ji kɨŋ Piŋkop da papiakon gen kɨnda tosok uŋun dakon mibɨlɨ nandaŋ kɨmotni. Gen uŋun yaŋ: ‘Ji da paret aŋ uŋun do dɨma galak tosot. Ji da amɨn do bupmɨ nandaŋ yomni uŋun do galak tosot.’ Gen yaŋ tosok, do nandani, amɨn kɨlegɨ yaŋ ɨlɨt do dɨma pɨgɨm. Yokwi pakpak amɨn yaŋ ɨlɨt do pɨgɨm.” ");
INSERT INTO yut_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yaŋ yaŋban Jon Telagɨ Pakbi Sogok Amɨn dakon paŋdetni da abɨŋ yaŋ iyɨwit, “Nin gat ae Parisi amɨn gat Piŋkop do nandaŋek jap kelek egapno gak dakon paŋdet kabɨgo nido yaŋ dɨma aŋ?” ");
INSERT INTO yut_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iyɨŋba Yesu da yoyɨgɨt, “Monjɨsok kɨnda mɨŋat pak do asak bɨsapmon monjɨsok notni gat kɨsi ekwaŋ, do bupmɨ dɨma nandaŋ. Mani don monji uŋun gwayeŋ aŋaŋ kɨŋakwa notni uŋun bɨsapmon Piŋkop do nandaŋek jap kelek ekwaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Nin ɨlɨkba pɨgɨk garaŋɨ pudaŋkwi kon ɨmal dɨwat kalugɨ pakbikon dɨma sugaŋbi kɨnda naŋ dɨma bupmaŋgamaŋ. Yaŋ kaŋ, pakbikon sugono ɨmal dɨwat uŋun da garaŋɨ ɨlɨkban pudaŋ kɨ madepsi akdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ae wain kalugɨ meme gɨp kalɨpmɨkon dɨma koleno pɨgɨsak. Yaŋ kaŋ, wain da paptaŋban meme gɨp sulukwan wain gat meme gɨp gat kɨsi yokwi tokdamal. Amɨn da wain kalugɨ meme gɨp kalugɨkon koleŋba wain gat meme gɨp gat kɨsi tagɨ tomal.” ");
INSERT INTO yut_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Gen uŋun yoyɨŋakwan kɨla amɨn kɨnda da abɨŋ Yesu burɨkon gawak ɨmɨŋek yaŋ iyɨgɨt, “Gwano ongwanjok kɨmokdok, mani gak da kɨŋ kɨsitgo da kwenikon wutjɨŋbɨ pɨdosak.” ");
INSERT INTO yut_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iyɨŋban nandaŋek Yesu paŋdetni gat kɨsi kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kɨŋakwa mɨŋat kɨnda da abɨŋ manjigwan da Yesu dakon ɨlɨkba pɨgɨkni ɨleŋɨkon ɨgayɨgɨt. Mɨŋat uŋun dagaŋ mok aŋek yawini maŋakwa egakwan bɨlak 12 agɨt. ");
INSERT INTO yut_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mɨŋat uŋun ɨlɨkba pɨgɨknikon ɨgayɨŋek noman tokeŋ yaŋ nandagɨt. ");
INSERT INTO yut_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Aban Yesu da tobɨl kaŋek yaŋ iyɨgɨt, “Gwano, dɨma pasolgi. Nandaŋ gadaŋ namɨsal, do kɨlek tosol.” Yaŋ yaŋban uŋudon gɨn gɨptɨmni kɨlek tagɨt. ");
INSERT INTO yut_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu kɨla amɨn da yutnon wɨgek kasɨsɨŋ pɨsok amɨn gat ae mɨŋat amɨn kabɨ madep kunam upbalapyo aŋakwa pɨndagek ");
INSERT INTO yut_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","yaŋ yoyɨgɨt, “Abɨgɨt. Mɨŋatjok uŋun dɨma kuŋwak, uŋun yum dɨpmɨn pokdok.” Yesu da yaŋ yaŋban nandaŋek jɨkgo yanjaŋ ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yaŋ aba yoyɨŋban yomakon pɨgɨ mudaŋakwa wɨgɨ mɨŋatjok kɨsirɨkon abɨdaŋban pɨdagɨt. ");
INSERT INTO yut_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yaŋ aban wasok tapmɨmɨ toŋ uŋun agɨt dakon gen bini yoyɨŋba uŋun mɨktɨm dakon mɨŋat amɨnyo kɨsi da nandawit. ");
INSERT INTO yut_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu uŋun mɨktɨm yɨpmaŋ kɨŋakwan dabɨlɨ mɨni amɨn bamorɨ da abɨŋ yolgumal. Yolek yaŋ tɨdaŋek yaŋ yagɨmal, “Dewit Dakon Monji, bupmɨ nandaŋ nim!” ");
INSERT INTO yut_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu yutnon wɨgakwan amɨn dabɨlɨ mɨni bamot uŋudon wɨŋbal yaŋ yoyɨgɨt, “Nak da dabɨljil paŋmɨlɨp abeŋ do nandaŋ gadaŋ namamal bo dɨma?” Yaŋban iyɨgɨmal, “Amɨn Tagɨ, nandaŋ gadaŋ gamamak.” ");
INSERT INTO yut_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yaŋ yaŋbal Yesu da kɨsitni dabɨlnikon wɨtjɨŋek yaŋ yoyɨgɨt, “Nandaŋ gadaŋ namamal uŋun da arɨpmon gɨn noman taŋ damdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yaŋban dabɨlɨ sɨŋtaŋakwal Yesu da yaŋsop tebai aŋyomɨŋek yoyɨgɨt, “Yo madep asat do amɨn dɨmasi yoyɨnjil.” ");
INSERT INTO yut_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mani Yesu dakon gen yaŋbal uŋun mɨktɨmon madepsi ɨreŋtaŋ aŋaŋ kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Amɨn bamot uŋun Yesu yɨpmaŋ dek kɨŋakwal amɨn kadɨm koŋni toŋ kɨnda Yesukon aŋaŋ opgwit. ");
INSERT INTO yut_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aŋopba Yesu da koŋni yol ɨmɨŋakwan amɨn kadɨm uŋun gen yagɨt. Yaŋ aban amɨn da kaŋek nandaba yo ŋwakŋwarɨsi aban yaŋ yawit, “Yo uŋuden kɨnda Israel mɨktɨmon dɨma altagɨt.” ");
INSERT INTO yut_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mani Parisi amɨn da yaŋ yawit, “Koŋ dakon kɨla amɨn madep da tapmɨmon koŋ yoldak.” ");
INSERT INTO yut_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu kokup monɨŋ ae kokup pap kɨsi agek Juda amɨn da muwut muwut yutni taŋ taŋ awiron wɨgek amɨn yoyɨŋ degek Piŋkop da Amɨn Kɨla Asak dakon Gen Bin Tagɨsi do yoyɨŋ teŋteŋagɨt. Aŋek gɨptɨmnikon sot wudaniyo mibɨlɨ mibɨlɨ tawit uŋun paŋmɨlɨp agɨt. ");
INSERT INTO yut_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mɨŋat amɨn kabɨyo madepsi pɨndakban paŋpulugogɨ mɨni yokwi egɨpgwit. Sipsip kɨla amɨni mɨni yombemsi ekwa pɨndagek bupmɨsi nandaŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yesu burɨ da bupmɨsi nandaŋek paŋdet kabɨni yaŋ yoyɨgɨt, “Pigaga jap bamɨ madepsi taŋ pektaŋ, mani pi monjɨ bamɨ pakpak amɨn morapmɨ dɨma. ");
INSERT INTO yut_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Do ji bamɨ pakpak dakon Amɨn Tagɨni bɨsit iyɨŋba pi amɨn paŋalon aŋ yopban pinikon kɨŋ jap paŋ paŋmuwutni.” ");
INSERT INTO yut_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu da paŋdetni 12 kabɨ yoyɨŋban apba koŋ yolyol ae sot mibɨlɨ mibɨlɨ kɨsisi paŋmɨlɨp agak dakon pi ani do yaŋ mudaŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yabekbi 12 kabɨ dakon man uŋun yaŋ: mibɨltok Saimon (mani kɨnda Pita), ae padɨge Andru, Sebedi dakon monji Jems, ae padɨge Jon. ");
INSERT INTO yut_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ae Pilip, Batolomiu, Tomas, ae takis tɨmɨt tɨmɨt amɨn Matyu, ae Alpius dakon monji, Jems, ae Tadius, ");
INSERT INTO yut_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ae Saimon (uŋun kalɨp Selot da kabɨkon egɨpgut), ae Judas Iskariot. (Judas uŋun da don Yesu uwal da kɨsiron yɨpgut.) ");
INSERT INTO yut_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu da amɨn 12 kabɨ uŋun yabegek yaŋ yoyɨgɨt, “Ji Amɨn Ŋwakŋwarɨ Kabɨkon bo ae Samaria amɨn da kokupmon dɨma kɨni. ");
INSERT INTO yut_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ji Israel amɨn kabɨ sipsip da yaŋ kɨlɨ pasɨlgwit uŋun amɨn kabɨkon kɨni. ");
INSERT INTO yut_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kɨŋek Piŋkop da Amɨn Kɨla Asak dakon bɨsap uŋun kwaŋ tosok uŋun dakon gen yaŋ teŋteŋoni. ");
INSERT INTO yut_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Aŋek sotni toŋ amɨn paŋmɨlɨp ani, ae amɨn kɨmakbi paba pɨdoni, ae wuda tebani toŋ paŋmɨlɨp ani, ae koŋni toŋ amɨn koŋni yol yomni. Ji yo yumaŋ nogɨ mɨni yumsi tɨmɨkgaŋ, do amɨn do yumsi yomni. Tomni do dɨma nandani. ");
INSERT INTO yut_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ji yɨk monɨŋjikon gol bo silwa moneŋ bo kopa moneŋ dɨma sɨmɨlek agɨpni. ");
INSERT INTO yut_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kosit agɨpni bɨsapmon yɨk dɨma ɨmetni, paba pɨgɨk bamorɨ dɨma tɨmɨtni, ae kandap gwɨl gat kosit dakon wɨn kɨrɨŋyo kɨsi dɨma tɨmɨtni. Pi aŋakwa wadak wadakji amɨn da damdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kokup pap kɨndakon bo ae kokup monɨŋ kɨndakon kɨŋ altoni kaŋ, uŋun kokupmon amɨn kɨlegɨ kɨnda wusɨŋ kaŋ uŋun gat gɨn egek yɨpmaŋ kɨni. ");
INSERT INTO yut_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yut kɨndakon wɨgɨni bɨsapmon, uŋun yutnon amɨn ‘Amɨn Tagɨ dakon but yawot jikon tosak’ yaŋ yoyɨni. ");
INSERT INTO yut_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ae uŋun yutnon amɨn da ji but dasi tɨmɨtni kaŋ, ji dakon but yawot uŋun amɨnon tosak. Mani but dasi dɨma tɨmɨtni kaŋ, but yawotji uŋun dɨsikon gɨn tosak. ");
INSERT INTO yut_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Amɨn kɨnda da ji but dasi dɨma tɨmɨtjak bo ae genji nandak do kurak tosak kaŋ, yut kokupyoni yɨpmaŋ degek kandap jikon kɨmbabaŋ tegoni uŋun tɨdaŋba kɨni. ");
INSERT INTO yut_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Asisi dayɨsat, kokwin agak bɨsap madepmon, uŋuden amɨn da Sodom kokup amɨn gat ae Gomora kokup amɨn gat da jɨgɨ pakdaŋ uŋun si yapmaŋek jɨgɨ madepsi pakdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesu da saŋbeŋek yaŋ yagɨt, “Nandani, nak da ji sipsip yombem baŋ joŋ pɨŋan da bɨkbɨgon yabekdat. Do tuŋon amɨn da nandaŋ kokwin tagɨsi aŋek akwaŋ uŋun da tɨlagon agɨpni. Ae kɨnarɨm dakon aŋpak yolek yaworɨsi agɨpni. ");
INSERT INTO yut_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Amɨn do pɨndak kɨmotni. Gen kokwin amɨn kabɨnikon depmaŋek muwut muwut yutnikon baljokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nak dakon man abɨŋ yɨp do aŋek ji tɨmɨk paŋpaŋ gapmanon ae kɨla amɨn madepmon paŋkɨkdaŋ. Paŋkwa kɨla amɨn madepmon ae Amɨn Ŋwakŋwarɨ Kabɨkon nak dakon Gen Bin Tagɨsi yoyɨŋ teŋteŋoni. ");
INSERT INTO yut_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Gen pikon paŋkɨ depmaŋakwa gen ni baŋ yoneŋ ae gen kobogɨ niaŋ yoyɨneŋ yaŋ nandaŋek pasol pasol dɨma ani. Uŋun bɨsapmon gɨn ni gen baŋ yoyɨni uŋun Piŋkop da dolɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ji da dɨma yokdaŋ. Datji dakon Wup da ji da dulumon da yokdɨsak, do pasol pasol dɨma ani. ");
INSERT INTO yut_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Peni da padɨge si aŋakba kɨmotjak do gen pikon yɨpdɨsak. Ae dat da monjɨ gwayoni yaŋ gɨn akdɨsak. Aŋakwa monjɨ gwayoni da meŋi datniyo do uwal aŋek si dapba kɨmotni do amɨn yoyɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nak nandaŋ namaŋ do aŋek amɨn morapmɨ da ji do nandaba yokwi tok aŋdamdaŋ. Mani tebai agek egɨ wɨgakwa bɨsap madepmon wɨgɨsak amɨn Piŋkop da yokwikon baŋ tɨmɨtdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kokup kɨndakon amɨn da uwal aŋdaba kaŋ, kokup uŋun yɨpmaŋek pasal kokup kɨndakon kɨni. Nak asi dayɨsat, ji Israel amɨn dakon kokup morapmon pi wasɨp dɨma aŋakwa Amɨn Dakon Monji apdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Papia yut mɨŋat monjɨyo da yoyɨŋdetni dɨma yapmaŋgaŋ. Ae oman amɨn da madepni dɨma yapmaŋgaŋ. ");
INSERT INTO yut_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mɨŋat monjɨyo da yoyɨŋdetni da tɨlagon egɨpni kaŋ, uŋun tagɨ. Ae oman amɨn da madepni da tɨlagon egɨpni kaŋ, uŋun kɨsi tagɨ. Yut dakon ami nak do Belsebul yaŋ nayɨni kaŋ, gwakni ji do nandaba pɨŋbisi aŋakwa man wagɨl yokwisi damdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yesu da gen saŋbeŋek yaŋ yagɨt, “Ji amɨn da yo yokwi aŋ damni do dɨma pasolni. Yo wɨtjɨŋbi da toŋ uŋun don noman tokdaŋ. Ae gen pasɨlɨ toŋ uŋun don amɨn kɨsi da nandakdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Gen pɨlɨn kaga dayɨsat, uŋun gɨldat kalba yaŋ teŋteŋoni. Gen pɨsɨk mɨrakjikon dayɨsat uŋun yut kwenon da agek yaŋ teŋteŋaŋ yomni. ");
INSERT INTO yut_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Amɨn da gɨp dapba kɨmokgoŋ uŋun do dɨma pasolni, wupji arɨpmɨ dɨma dapba kɨmotdaŋ. Ji Piŋkop dosi pasolni. Uŋun da gɨp gat wup gat kɨsi Tɨpdomon maban pɨgɨ tasɨk tokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mɨnam monɨŋ uŋun yo monɨŋɨsok, bamorɨ dakon yumaŋ nogɨ uŋun moneŋ gɨman tabɨlɨ kaloŋɨ gɨn. Mani Datji da kɨnda mɨktɨmon dɨma mosak do nandɨsak kaŋ, arɨpmɨ dɨma mokdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Piŋkop da busuŋ daŋgwanji niaŋ da toŋ uŋun kɨsisi nandaŋ mudosok, ");
INSERT INTO yut_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","do dɨma pasolni. Mɨnam monɨŋ monɨŋ morapmɨ dakon yumaŋ nogɨ uŋun madep dɨma, mani ji dakon yumaŋ nogɨ uŋun wukwisi.” ");
INSERT INTO yut_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yesu da gen saŋbeŋek yaŋ yagɨt, “Amɨn kɨnda mɨŋat amɨnyokon ‘Nak Yesu dakon amɨn’ yaŋ yosak kaŋ, nak da Datno Kwen Kokup egɨsak ‘Uŋun amɨn nak dakon amɨn’ yaŋ iyɨkdɨsat. ");
INSERT INTO yut_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mani amɨn kɨnda mɨŋat amɨnyokon ‘Nak Yesu dakon amɨn dɨma’ yaŋ yosak kaŋ, nak da Datno Kwen Kokup egɨsak ‘Uŋun amɨn nak dakon amɨn dɨma’ yaŋ iyɨkdɨsat.” ");
INSERT INTO yut_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yesu da saŋbeŋek yaŋ yagɨt, “Nak da mɨktɨmon emat aŋyawot ak do pɨgɨm yaŋ dɨma nandani. Nak emat agak sɨbanaŋ aŋaŋ pɨgɨm. ");
INSERT INTO yut_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nak uwal pɨdok pɨdokyo noman tosak do pɨgɨm. ‘Amɨn kɨnda da datni uwal aŋ ɨmdɨsak. Ae gwa kɨnda da meŋi uwal aŋ ɨmdɨsak. Aŋakwan mɨŋat kɨnda da namdi uwal aŋ ɨmdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Aŋakwan amɨn kɨnda iyɨ dakon gwakni da uwalni dagokdaŋ.’ ");
INSERT INTO yut_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Amɨn kɨnda meŋi datniyo do but dasi galak taŋ yomɨsak uŋun yapmaŋek nak do wukwisi yaŋ dɨma nandɨsak kaŋ, uŋun amɨn nak dakon notno dɨma. Ae amɨn kɨnda monji bo ae gwi do but dasi galak taŋ yomɨsak uŋun yapmaŋek nak do wukwisi yaŋ dɨma nandɨsak kaŋ, uŋun amɨn nak dakon notno dɨma. ");
INSERT INTO yut_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ae amɨn kɨnda tɨlak kɨndapni guramɨgek nak dɨma noljak kaŋ, uŋun amɨn nak dakon notno dɨma. ");
INSERT INTO yut_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Amɨn kɨnda mɨktɨmon tagɨsi egɨp do nandaŋek pi madepsi asak kaŋ, uŋun amɨn egɨp egɨpni pasɨl ɨmdɨsak. Mani amɨn kɨnda nak do nandaŋek egɨp egɨpni yɨpjak kaŋ, uŋun amɨn egɨp egɨp dagok dagogɨ mɨni abɨdokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yesu da saŋbeŋek yaŋ yagɨt, “Amɨn kɨnda ji but dasi tɨmɨkdak, uŋun nak naŋ abɨdosok. Amɨn kɨnda nak abɨdosok, Piŋkop nak yabekban pɨgɨm uŋun naŋ abɨdosok. ");
INSERT INTO yut_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Amɨn kɨnda da nak kombɨ amɨn kɨnda aŋpulugosot yaŋ nandaŋek kombɨ amɨn kɨnda abɨdaŋ aŋkɨ yutnikon kɨlani asak kaŋ, Piŋkop da yo tagɨsi kombɨ amɨn do yomɨsak yaŋ gɨn uŋun amɨn do ɨmdɨsak. Ae amɨn kɨnda da nak amɨn kɨlegɨsi kɨnda aŋpulugosot yaŋ nandaŋek amɨn kɨlegɨ kɨnda abɨdaŋ aŋkɨ yutnikon kɨlani asak kaŋ, uŋun amɨn da yo tagɨsi amɨn kɨlegɨ da tɨmɨkgaŋ yaŋ gɨn tɨmɨtdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ae amɨn kɨnda da nak Yesu dakon paŋdetni kɨnda aŋpulugosot yaŋ nandaŋek nak dakon paŋdetno mani mɨni kɨnda do pakbi mɨrɨmjok kɨnda koleŋ ɨmjak kaŋ, asisi dayɨsat, kobogɨ do yo tagɨsi tɨmɨtdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu paŋdetni 12 kabɨ yoyɨŋ dek mudaŋek uŋun kokup yɨpmaŋek Galili mɨktɨm dakon kokup pap tawit uŋudon agek Piŋkop dakon gen yoyɨŋ dekgɨt. ");
INSERT INTO yut_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Aŋakwan Jon dam tebanon yɨgek Kristo da pi agɨt dakon gen bin nandaŋek paŋdet kabɨni yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Ji Yesukon kɨŋ yaŋ iyɨni, ‘Piŋkop da amɨn yabet do yagɨt uŋun gak, bo nin amɨn kɨnda don apdɨsak uŋun do jomjom aneŋ?’ ” ");
INSERT INTO yut_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yaŋba Yesu da kobogɨ yaŋ yoyɨgɨt, “Ji kɨŋ yo morap kaŋ nandaŋyo aŋ uŋun Jon iyɨni. ");
INSERT INTO yut_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Dabɨlɨ mɨni amɨn sɨŋtoŋ, kandapmɨ alek taŋbi kosit akwaŋ, wuda tebani toŋ amɨn kɨlek toŋ, mɨragɨ mɨni gen nandaŋ, kɨmakbi kɨmoron da pɨdoŋ, ae yoni mɨni amɨn da Piŋkop dakon Gen Bin Tagɨsi nandaŋ. ");
INSERT INTO yut_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Amɨn kɨnda nak nandaŋek nandaŋ gadatni dɨma wɨtdal kɨsak uŋun amɨn kɨsɨk kɨsɨgɨ toŋ egɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yoyɨŋban Jon dakon paŋdet kabɨni kɨŋakwa Yesu da mɨŋat amɨn kabɨ madep Jon do yaŋ yoyɨgɨt, “Ji mɨktɨm amɨni mɨnikon ninaŋ kok do kɨwit? Mɨrɨm da nagal paŋwayɨŋ aban pɨndat do kɨwit? ");
INSERT INTO yut_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Uŋun dɨma kaŋ, ninaŋ kok do kɨwit? Amɨn kɨnda da ɨlɨkba pɨgɨkni mani toŋsi pagɨt uŋun kok do kɨwit? Dɨma, kɨla amɨn madep da yutnon uŋuden amɨn da ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Dɨma kaŋ, ae ninaŋ kok do kɨwit? Kombɨ amɨn kɨnda kok do kɨwit? Asi ji kombɨ amɨn kok do kɨwit. Mani Jon da kombɨ amɨn dɨwarɨ yapmaŋ mudosok. ");
INSERT INTO yut_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Uŋun amɨn dogɨn Piŋkop da papiakon gen yaŋ tosok: ‘Nandani, geno yaŋ teŋteŋosak do amɨn kɨnda yabekgo uŋun da mibɨltaŋ gamjak. Aŋek kositgo aŋnoman asak.’ ");
INSERT INTO yut_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nak asisi dayɨsat, amɨn morap mɨktɨmon altoŋ uŋun Jon Telagɨ Pakbi Sogok Amɨn da yapmaŋ mudosok. Mani amɨn morap Piŋkop da Amɨn Kɨla Asak da kagagwan pɨŋbisi ekwaŋ uŋun da Jon yapmaŋgaŋ. ");
INSERT INTO yut_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","“Kombɨ amɨn morap gat ae gen teban papia kɨsi da Piŋkop da Amɨn Kɨla Akdɨsak uŋun do yaŋ teŋteŋaŋakwa wɨŋ Jon Telagɨ Pakbi Sogok pini wasagɨt bɨsapmon wɨgɨt. Jon da Piŋkop dakon gen wasaŋek yagɨron da wɨŋ abɨsok ekwamaŋon Piŋkop da Amɨn Kɨlani Ak do pi madepsi asak. Aŋakwan amɨn da uŋun kɨrɨŋɨt do pi madep aŋ. Yaŋ aŋek emat jɨgɨyo morapmɨsi paŋalon aŋ. ");
INSERT INTO yut_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","15","Uŋun papia da Elaija don apjak do yagɨt. Ji but bamot aŋ yaŋ nandɨsat. Gen on nandak do galak toŋ amɨn ji pakyaŋsi nandaŋek mibɨlɨ nandaŋ pɨsoni. Jon uŋun Elaija. ");
INSERT INTO yut_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Amɨn abɨsok ekwaŋ uŋun nandaŋ kokwini tagɨ dɨma. Uŋun dakon mibɨlɨ tɨmɨsok dɨ dayɨko nandabɨt. Uŋun mɨŋat monjɨyo da yaŋ, yumaŋ gwayek tamokon yɨgek notni yoyɨŋ yoyɨŋ aŋek yaŋ yoŋ, ");
INSERT INTO yut_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nin kasɨsɨŋ kɨlɨ pɨsomaŋ, mani ji kap ak do dɨma nandayɨŋ. Nin bupmɨ kap yamaŋ, mani ji bupmɨ nandaŋek kunam tat do dɨma nandayɨŋ.’ ” ");
INSERT INTO yut_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yesu da saŋbeŋek yaŋ yagɨt, “Jon abɨŋek jap morapmɨ dɨma nagɨt, ae wain dɨma nagɨt. Yaŋ aŋakwan, ‘Koŋni toŋ’ yaŋ yawit. ");
INSERT INTO yut_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ae Amɨn Dakon Monji da abɨŋ jap pakbiyo agɨt. Yaŋ aŋakwan kaŋek yaŋ yawit, ‘Kabɨt, jap morapmɨ noknok amɨn ae wain morapmɨsi noknok amɨn. Takis tɨmɨt tɨmɨt ae yokwi pakpak amɨn dakon notni.’ Yaŋ yaŋ ɨmgwit, mani Piŋkop da pi morap agɨt uŋun pɨndagek nandano nandaŋ kokwini tagɨsi gɨn asak.” ");
INSERT INTO yut_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kokup pap dɨwarɨkon Yesu wasok tapmɨmɨ toŋ morapmɨ agɨt, mani but tobɨl dɨma awit. Do Yesu da tebaisi yaŋ yagɨt, ");
INSERT INTO yut_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Korasin ae Betsaida amɨn, awa! Nak wasok tapmɨmɨ toŋ abo pɨndagek ji but tobɨl dɨma awit. Tair kokupmon amɨn gat Saidon kokupmon amɨn gat da pɨndakgwit tam, but tobɨl bamɨsi abam. Aŋek bupmɨ dakon yɨk ɨmalyo paŋek abɨlagon yɨkbam. ");
INSERT INTO yut_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mani nak yaŋ dayɨsat, gen kokwin bɨsap madepmon Tair gat Saidon kokupmon amɨn gat da kobogɨ do jɨgɨ tagapmɨ paŋakwa ji da kobogɨ do jɨgɨ madepsi pakdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aŋakwa Kapaneam kokupmon amɨn, ji ason Kwen Kokupmon wɨgɨni yaŋ nandaŋ, ma? Uŋun arɨpmɨ dɨmasi. Ji mibɨlɨgwan Tɨpdomon pɨgɨkdaŋ. Nak wasok tapmɨmɨ toŋ abo pɨndagek ji but tobɨl dɨma awit. Uŋun morap Sodom kokupmon amɨn da pɨndakgwit tam, abɨsok Sodom tosok gɨn. ");
INSERT INTO yut_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Do yaŋsi dayɨsat, Piŋkop da amɨn kokwin ak do bɨsap yɨpguron Sodom amɨn da jɨgɨ pakdaŋ uŋun si yapmaŋek ji da jɨgɨ madepsi pakdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Uŋun bɨsapmon Yesu da yaŋ yagɨt, “Dat, kundu ae mɨktɨm dakon Amɨn Tagɨ, amɨn dɨwarɨ mɨktɨm dakon nandak nandakni uŋun wukwisi, mani iyɨ do nandaba wɨgɨsak, do uŋuden amɨn do gen bamɨ morap si paŋkɨsɨbɨsal. Aŋek amɨn monɨŋɨ da tɨlagon ekwaŋ amɨn, uŋun do yolɨsal. ");
INSERT INTO yut_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O Dat, gak gaga dakon galaktok yolek yaŋ asal. ");
INSERT INTO yut_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Datno da yo morap kɨlɨ namgut. Dat uŋun dagɨn Monji nandaŋ ɨmɨsak. Aŋek Monjɨ gat ae amɨn Monjɨ da Dat dakon mibɨlɨ yoyɨsak uŋun amɨn dagɨn Datno nandaŋ ɨmaŋ. ");
INSERT INTO yut_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Jɨgɨ mibɨlɨ mibɨlɨ paŋek wararɨ nandaŋ amɨn, ji nagon opba bɨkbɨk dabo yɨk yawotni. ");
INSERT INTO yut_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Bulmakau da tegon amɨn da yɨk pawɨl kɨndap kɨrɨŋ paŋteban aba yo jɨgɨ ɨlɨkgaŋ, uŋun da tɨlak ji nak dakon kɨndap kɨrɨŋ pani. Nak dakon kɨndap kɨrɨŋ uŋun yaworɨ ae yɨk ɨmetni uŋun tagapmɨ. Nak amɨn yaworɨ ae butno pɨŋbi, do nak gat egek Piŋkop do dayɨŋ dekgo butji yaworɨ tosak.” ");
INSERT INTO yut_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sabat kɨndakon Yesu gat paŋdetni uŋun wit pi kɨnda da bɨkbɨk naŋ kɨwit. Kɨŋek paŋdetni jap do awit, do wit bamɨ dɨwarɨ jɨmɨk dagaŋ nawit. ");
INSERT INTO yut_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aŋakwa pɨndagek Parisi amɨn da Yesu yaŋ iyɨwit, “Pɨndat, paŋdet kabɨgo Sabat bɨsapmon nido gen teban yapmaŋek pi aŋ?” ");
INSERT INTO yut_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yaŋba Yesu da yoyɨgɨt, “Dewit gat amɨn kabɨni gat da jap do aŋek yo awit uŋun ji manjɨŋ nandaŋyo awit bo dɨma? ");
INSERT INTO yut_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dewit uŋun telagɨ yutnon wɨgɨ bret Piŋkop do parekbi uŋun abɨdaŋ naŋek amɨn kabɨni kɨsi do yoban nawit. Bret uŋun telagɨ, amɨn ɨsalɨ da dɨma noknogɨ, mukwa sogok amɨn dagɨn tagɨ nawit. ");
INSERT INTO yut_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bo ae Piŋkop da papiakon gen kɨnda mukwa sogok amɨn do yosok uŋun kɨsi dɨma manjɨŋ nandaŋyo awit? Mukwa sogok amɨn Sabat bɨsap morapmon gen teban yapmaŋek pi aŋ, mani dɨwarɨni mɨni ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nak asi dayɨsat, amɨn kɨnda oni egɨsak uŋun da Telagɨ Yut Madep yapmaŋdak. ");
INSERT INTO yut_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","8","Piŋkop da papiakon gen kɨnda tosok uŋun yaŋ: ‘Nak ji da paret aŋ uŋun do dɨma galak tosot. Nak ji da amɨn do bupmɨ nandaŋ yomni uŋun do galak tosot.’ Ji uŋun dakon mibɨlɨ nandabam tam, gulusuŋni mɨni amɨn gen dɨma yaŋ yobam. Amɨn Dakon Monji uŋun Sabat bɨsap dakon Amɨn Tagɨ egɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu uŋudon da muwut muwut yutni kɨndakon wɨgek ");
INSERT INTO yut_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","amɨn kɨsirɨ gɨreŋɨkbi kɨnda ekwan kagɨt. Amɨn yɨkgwit uŋun da Yesu gen teban kɨnda yapmaŋakwan gen pikon yɨpneŋ yaŋ nandaŋek iyɨwit, “Sabat bɨsapmon amɨn kɨnda da notni kɨnda aŋmɨlɨp asak kaŋ, uŋun gen teban yapmaŋdak?” ");
INSERT INTO yut_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yaŋba yaŋ yoyɨgɨt, “Niaŋ nandaŋ? Jikon da kɨnda dakon sipsipni kɨnda Sabat bɨsapmon gapmagwan mosak kaŋ, yum kaŋakwa uŋungwan di egɨpjak? Dɨmasi, aŋpulugaŋek abɨdaŋ ɨlɨkba wɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sipsip uŋun yo ɨsalɨ, mani amɨn da yo madepsi. Yaŋdo, Sabat bɨsapmon amɨn kɨnda aŋpulugoneŋ kaŋ, gen teban yapmaŋgaŋ yaŋ dɨma nandani.” ");
INSERT INTO yut_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yaŋ yaŋek amɨn kɨsirɨ gɨreŋɨkbi yaŋ iyɨgɨt, “Kɨsitgo aŋnɨŋnɨŋ a.” Yaŋban amɨn uŋun kɨsirɨ aŋnɨŋnɨŋ aban kɨlek taŋ kɨsirɨ terɨ kɨnda yombem gɨn agɨt. ");
INSERT INTO yut_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Aŋakwan Parisi amɨn da kɨŋ “Niaŋ aŋek Yesu aŋatneŋ?” yaŋon da gen paŋkosit awit. ");
INSERT INTO yut_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu uŋun Parisi amɨn da yo aŋ ɨmdo yawit uŋun kɨlɨ pɨndak mudagɨt, do kokup uŋun yɨpmaŋek kɨgɨt. Kɨŋakwan amɨn morapmɨ da yolgwit. Aŋakwa sot amɨn kɨsisi paŋmɨlɨp aŋek ");
INSERT INTO yut_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yesu iyɨ niaŋen amɨn kɨnda uŋun amɨn dɨma yoyɨni do yaŋsop aŋyomgut. ");
INSERT INTO yut_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yaŋ aŋakwan Piŋkop da kalɨpsigwan kombɨ amɨn Aisaia aŋtagap aban gen yagɨt uŋun bamɨ noman tagɨt. Gen uŋun yaŋ: ");
INSERT INTO yut_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“On uŋun oman monjɨno, nak da naga manjɨgɨm. Nak uŋun do but dasi galak taŋ ɨmɨsat. Nak da Wupno yɨpmaŋ ɨbo amɨn mɨktɨmɨ mɨktɨmɨ egɨ aŋaŋ kwaŋ uŋun gen kokwin kɨlegɨsi dakon mibɨlɨ yoyɨŋ teŋteŋokdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Uŋun pɨdok pɨdok dɨma asak, ae dɨma yaŋ tɨdosak. Do kokup pap da kosiron amɨn kɨnda da tekni dɨma nandakdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nagal si gawut do asak uŋun arɨpmɨ dɨma jokgaljak. Ae lam kɨmot do asak uŋun arɨpmɨ dɨma aban kɨmotjak. Pi tebai aŋakwan wɨgɨ aŋpak kɨlegɨ da aŋpak yokwi wutjɨban tapmɨmɨ mɨni akdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aŋakwan amɨn mɨktɨmɨ mɨktɨmɨ egɨ aŋaŋ kwaŋ uŋun da mani do nandaŋ gadaŋ ɨmɨŋek paŋpulugosak do nandaŋ teban taŋek jomjom akdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Uŋun bɨsapmon amɨn da koŋni toŋ amɨn kɨnda aŋaŋ Yesukon aŋopgwit. Uŋun amɨn dabɨlɨ mɨni ae kadɨm. Yesu da aŋmɨlɨp aban gen yaŋek dabɨlɨ pɨsagɨt. ");
INSERT INTO yut_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yaŋ aban mɨŋat amɨn kabɨ madep da kaŋ wurɨpdagek yawit, “On amɨn Dewit dakon monji bo?” ");
INSERT INTO yut_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mani Parisi amɨn da gen uŋun nandaŋek yawit, “On amɨn koŋ dakon mibɨltok amɨn madepni Belsebul uŋun da tapmɨmon koŋ yoldak.” ");
INSERT INTO yut_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yaŋba Yesu da nandak nandakni pɨndak nandaŋyo aŋek yaŋ yoyɨgɨt, “Mɨktɨm kɨnda da pudaŋ kabi bamorɨ aŋek emat wamjil kaŋ, uŋun mɨktɨm yokwi tokdɨsak. Ae kokup pap kɨnda bo ae yut kɨnda dakon amɨn da pudaŋ kabi bamorɨ aŋek emat wamni kaŋ, uŋunyo kɨsi tagɨ dɨma egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Yaŋgɨn Sunduk da Sunduk yoljak kaŋ, Sunduk da iyɨ waseŋ kɨ kabi bamorɨ aŋek yo morap kɨla agak dakon tapmɨm pasɨl ɨmdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nak Belsebul da aŋpulugaŋban koŋ yoldat kaŋ, dɨsi dakon notji koŋ yolgaŋ uŋun amɨn kabɨ ni tapmɨmon da koŋ yolgaŋ? Uŋun amɨn kabɨ da genji kokwinɨgek gulusuŋ yoŋ yaŋ tagɨ dayɨni. ");
INSERT INTO yut_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mani Piŋkop dakon Wup da nak aŋpulugaŋban koŋ yoldat kaŋ, Piŋkop dakon Amɨn Kɨla Agakni jikon kɨlɨ abɨk. ");
INSERT INTO yut_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Amɨn kɨnda da niaŋ aŋek amɨn tebai kɨnda da yutnon wɨgɨ yo kabɨni tagɨ tɨmɨtjak? Mibɨltok amɨn tebai uŋun nap teban naŋ wamaŋ yɨpmaŋek yo kabɨni tagɨ tɨmɨtjak. ");
INSERT INTO yut_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Amɨn nak dakon notno dɨma, uŋun da nak uwal aŋnamaŋ. Ae amɨn nak dɨma aŋpulugaŋban amɨn paŋmuwukgamaŋ, uŋun amɨn da amɨn paŋwaseŋban waseŋ kwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Do yaŋ dayɨsat, Piŋkop da yokwi morap gat ae Piŋkop do yaŋba yokwi tok agak morap tagɨ wɨrɨrɨtjak. Mani amɨn kɨnda Telagɨ Wup do yaŋba yokwi tok asak kaŋ, Piŋkop da uŋun amɨn dakon dɨwarɨni dɨma wɨrɨrɨk ɨmdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Amɨn kɨnda Amɨn Dakon Monji do yaŋba yokwi tok asak kaŋ, Piŋkop da dɨwarɨni tagɨ wɨrɨrɨk ɨmjak. Mani amɨn kɨnda Telagɨ Wup do yaŋba yokwi tok asak kaŋ, Piŋkop da abɨsok on mɨktɨmon ae don bɨsap madepmon kɨsi dɨwarɨni uŋun dɨma wɨrɨrɨk ɨmdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesu da saŋbeŋek yaŋ yagɨt, “Kɨndap kɨnda tagɨsi kaŋ, bamɨ kɨsi tagɨ. Ae kɨndap yokwi kaŋ, bamɨ kɨsi yokwi. Amɨn da kɨndap bamɨ pɨndagek kɨndap yokwi bo ae tagɨ yaŋ pɨndakgaŋ. ");
INSERT INTO yut_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ji tuŋon amɨn emarɨ toŋ yombem. Gen tagɨsi niaŋsi aŋek yoni? Yo ni da butjigwan toŋ uŋun gen yogokjikon paŋalon aŋ. ");
INSERT INTO yut_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Amɨn kɨlegɨ uŋun burɨkon yo tagɨsi morapmɨ toŋ, do aŋpak kɨlegɨsi aŋ. Ae amɨn yokwi uŋun burɨkon yo yokwi morapmɨ toŋ, do aŋpak yokwi aŋ. ");
INSERT INTO yut_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Mani yaŋ dayɨsat, gen kokwin bɨsap madepmon ɨsal dogɨn gen yum yawit amɨn morap Piŋkop da mibɨlɨ nido yawit uŋun do yoyɨŋban kobogɨ iyɨŋ iyɨŋ akdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gaga gen yosol uŋun da tɨlagon gak amɨn kɨlegɨ bo amɨn yokwi yaŋ gayɨkdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Gen teban yoyɨŋdet amɨn dɨ gat ae Parisi amɨn dɨ gat da Yesu yaŋ iyɨwit, “Yoyɨŋdet, gak da wasok tapmɨmɨ toŋ kɨnda abɨ kaŋek asi gak Piŋkop dakon pi naŋ asal yaŋ gandaneŋ.” ");
INSERT INTO yut_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yaŋba yaŋ yoyɨgɨt, “Amɨn on bɨsapmon ekwaŋ uŋun amɨn yokwisi gɨn. Piŋkop dakon pi naŋ asat yaŋ nandak do wasok tapmɨmɨ toŋ kɨnda kok do yoŋ. Mani kɨnda dɨma kokdaŋ. Kombɨ amɨn Jona dakon tɨlak naŋgɨn kokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona gɨldat kapbɨ ae pɨlɨn kapbɨ yaŋ tap kɨlap da but kagagwan egɨpgut, yaŋgɨn Amɨn Dakon Monji mɨktɨm kagagwan gɨldat kapbɨ ae pɨlɨn kapbɨ yaŋ potdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Niniwe amɨn Jona da Piŋkop dakon gen yoyɨŋban but tobɨl awit. Mani ji da binapmon amɨn kɨnda egɨsak uŋun da Jona yapmaŋ mudosok, mani ji but tobɨl dɨma aŋ. Do gen kokwin bɨsap madepmon Niniwe amɨn da pɨdaŋ agek abɨsok ekwaŋ amɨn kabɨ dakon aŋpak yokwi uŋun do yaŋ teŋteŋokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mɨktɨm saut tetgɨn dakon kɨla amɨn mɨŋat madep uŋun Solomon dakon nandaŋ kokwini tagɨsi iyɨŋakwan nandak do mɨktɨm dubagɨsikon da apgut. Mani amɨn kɨnda oni egɨsak, uŋun da Solomon yapmaŋdak, mani geni dɨma nandaŋ. Do gen kokwin bɨsap madepmon uŋun kɨla amɨn mɨŋat madep da pɨdaŋ agek abɨsok ekwaŋ amɨn kabɨ dakon aŋpak yokwi uŋun do yaŋ teŋteŋokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesu da saŋbeŋek yaŋ yagɨt, “Koŋ kɨnda da amɨn kɨnda yɨpmaŋ degek kɨŋ mɨktɨm kɨbɨrɨ tɨmon agek yɨk yawot tamo wɨsisak. Mani tamo kɨnda dɨma kosok do ");
INSERT INTO yut_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yaŋ yosok, ‘Nak aeno tobɨl yut kalɨp egɨpgumon kɨkeŋ.’ Kɨŋ kaŋban yut uŋun ɨsal tosok ae sɨbɨt sɨbɨt ɨkdɨgaŋ aŋtɨlɨm abi kosok. ");
INSERT INTO yut_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yaŋ kosok, do kɨŋ koŋ 7 kabɨ iyɨ yapmaŋek wagɨl yokwisi gat tɨmɨkban kwa uŋun yutnon egek aŋpak yokwisi aŋ. Mibɨltok uŋun amɨn yokwi egɨpgut, mani abɨsok uŋun yapmaŋek wagɨl yokwisi egɨsak. Yaŋgɨn abɨsok yokwi pakpak amɨn ekwaŋon yaŋ gɨn altosok.” ");
INSERT INTO yut_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu mɨŋat amɨn kabɨ madep gen yoyɨŋakwan meŋi padɨk padɨkni paŋabɨŋ yomakon agek Yesu gat yaŋ nandat ak do yawit. ");
INSERT INTO yut_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yaŋba yutgwan amɨn kɨnda da Yesu iyɨgɨt, “Meŋgo padɨk padɨkgo yomakon abeŋ da gak gat yaŋ nandat ak do yoŋ.” ");
INSERT INTO yut_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yaŋban iyɨgɨt, “Meŋno padɨk padɨkno uŋun namɨn?” ");
INSERT INTO yut_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yaŋek paŋdetni kabɨkon kɨsit sugaŋek yagɨt, “Meŋno padɨk padɨkno oni. ");
INSERT INTO yut_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Datno Kwen Kokup egɨsak uŋun dakon gen guramɨkgaŋ amɨn uŋun meŋno padɨk padɨkno ae samɨnoyo.” ");
INSERT INTO yut_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Uŋun gɨldaron gɨn Yesu yut uŋun yɨpmaŋek pakbi ɨdap da ɨleŋon pabɨgɨ yɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yɨgakwan amɨn morapmɨsi da opba pɨndakgɨt, do bot kɨndakon wɨgɨgɨt. Boron pawɨgɨ yɨgakwan amɨn pakbi ɨdap da ɨleŋon akgwit. ");
INSERT INTO yut_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Agakwa Yesu da tɨlak gen kɨnda yaŋ yoyɨgɨt, “Amɨn kɨnda uŋun jap yet tɨŋtɨŋok do pigaga kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Jap yet tɨŋtɨŋaŋakwan dɨwarɨ kosiron maŋba mɨnam da abɨŋ nawit. ");
INSERT INTO yut_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Ae yerɨ dɨwarɨ da mɨktɨm tɨpmɨ toŋ tɨmon mawit. Uŋun kwenjok tawit, do tepmɨ kwawit, mani tɨp kwenon mɨktɨm morapmɨ dɨma, do gelɨ tagɨ dɨma yopba kɨwit. Do gɨldat da wɨŋ pɨndakban alek tawit. ");
INSERT INTO yut_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aŋakwa jap yet dɨwarɨ joŋ kelɨ toŋ tɨmgwan mawit. Uŋun joŋ kelɨ toŋ gat kɨsi kwaŋek wutjɨŋba kɨbɨdawit. ");
INSERT INTO yut_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ae jap yet dɨwarɨ da mɨktɨm tagɨsikon maŋ kwawit. Maŋ kwaŋakwa dɨwarɨ da bamɨ 100, ae dɨwarɨ da 60, ae dɨwarɨ da 30 yaŋ tawit. ");
INSERT INTO yut_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Gen yosot uŋun pakyaŋsi nandani.” ");
INSERT INTO yut_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tɨlak gen uŋun yoyɨŋ mudaŋban paŋdet kabɨni da abɨŋ iyɨwit, “Mɨŋat amɨn kabɨyo madep gen yoyɨŋek tɨlak gen baŋ nido yoyɨsal?” ");
INSERT INTO yut_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yaŋba yaŋ yoyɨgɨt, “Piŋkop da Amɨn Kɨla Asak uŋun dakon mibɨlɨ pasɨlɨ tosok uŋun ji da tagɨ nandani do Piŋkop da nandɨsak, mani uŋun amɨn do dɨma yolɨsak. ");
INSERT INTO yut_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Amɨn nak dakon gen nandaŋek burɨkon yɨpmaŋdak uŋun amɨn Piŋkop da saŋbeŋek nandak nandak tagɨ madepsi ɨmdɨsak. Mani amɨn nak dakon gen nandaŋek burɨkon dɨma yɨpmaŋdak uŋun amɨn nak dakon gen dɨwarɨ nandagɨt uŋun pasɨl ɨmdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mibɨlɨ yaŋ do tɨlak gen gɨn yosot. Amɨn uŋun dabɨl sɨŋtaŋek koŋ, mani yo kɨnda dɨma koŋ. Mɨrak paŋek nandaŋ, mani dɨma nandaba pɨsosok. ");
INSERT INTO yut_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Amɨn da yaŋ aŋakwa kombɨ amɨn Aisaia da kombɨ gen kɨnda yagɨt uŋun bamɨ toŋ asak. Gen uŋun yaŋ yagɨt: ‘Ji bɨsap morapmɨsi gen nandakdaŋ, mani mibɨlɨ dɨma nandaba pɨsokdɨsak. Bɨsap morapmɨ dabɨl sɨŋtaŋek kokdaŋ, mani dɨma kaŋba pɨsokdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Uŋun do aŋek on amɨn but teban kɨlɨ awit. Gen kalugɨ dɨ gat nandak do kurak taŋek mɨrakni paŋ sopgwit, ae dabɨlni wamaŋ sopgwit. Yaŋ dɨma awit tam, dabɨlni ae mɨrakni ae butniyo da kaŋ nandaŋyo aba pɨsaŋban nagon tobɨlba tagɨ paŋmɨlɨp abom.’ ");
INSERT INTO yut_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mani ji dabɨlji da tagɨ pɨndakgaŋ, ae mɨrakji da tagɨ nandaŋ, do ji kɨsɨk kɨsɨk ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Asisi dayɨsat, kalɨp kombɨ amɨn morapmɨ gat ae amɨn kɨlegɨ morapmɨ gat da yo ji da abɨsok pɨndak nandaŋyo aŋ uŋun pɨndat do but kɨndap pawit, mani dɨma pɨndakgwit. Ae abɨsok ji da gen nandaŋ uŋun nandak do but kɨndap pawit, mani dɨma nandawit.” ");
INSERT INTO yut_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesu da saŋbeŋek yaŋ yagɨt, “Kɨlɨ jap yet tɨŋtɨŋok dakon tɨlak gen dakon mibɨlɨ dayɨko nandani. ");
INSERT INTO yut_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Amɨn Piŋkop da Amɨn Kɨla Asak dakon gen nandaŋek butni dɨma pɨsoŋ uŋun jap yet kosiron mawit uŋuden. Yokwi Ami da abɨŋ gen tagɨ butnikon toŋ uŋun gwayeŋ paŋkɨsak. ");
INSERT INTO yut_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jap yet tɨpmɨ toŋ tɨmon mawit uŋun amɨn kɨnda yombem. Uŋun amɨn Piŋkop dakon gen nandaŋek uŋun bɨsapmon gɨn kɨsɨk kɨsɨgon da abɨdosok. ");
INSERT INTO yut_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mani butnikon gelɨ tagɨ dɨma yɨpban kɨgɨt, do bɨsap pɨsɨpmɨsok akdak. Jɨgɨ mibɨlɨ mibɨlɨ altaŋ ɨmni ae Piŋkop dakon gen dakon uwal apni bɨsapmon nandaŋ gadatni yɨpban wɨtdal kɨsak. ");
INSERT INTO yut_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ae jap yet joŋ kelɨ toŋ tɨmon mawit uŋun amɨn kɨnda yombem. Uŋun amɨn Piŋkop dakon gen nandɨsak, mani mɨktɨm dakon yo do nandaba kɨk asak, ae moneŋ da aŋkɨlɨkban uŋun do galagɨsi nandaŋakwan uŋun da Piŋkop gen wɨtjɨŋban bamɨ dɨma tosok. ");
INSERT INTO yut_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mani jap yet mɨktɨm tagɨsikon mawit uŋun amɨn kɨnda yombem. Uŋun amɨn Piŋkop dakon gen nandaŋek mibɨlɨ nandaŋ kɨmokdok. Uŋun amɨn bamɨ 100, ae kɨnda bamɨ 60, ae kɨnda bamɨ 30 yaŋ taŋtaŋ aŋ.” ");
INSERT INTO yut_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu da tɨlak gen kɨnda gat yaŋ yoyɨgɨt, “Piŋkop da Amɨn Kɨla Asak uŋun yaŋ. Amɨn kɨnda da jap yet pigagani kon tɨŋtɨŋagɨt. ");
INSERT INTO yut_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mani amɨn dɨpmɨn pak mudaŋakwa uwalni da abɨŋ jap yet tagɨ yopgut uŋun bɨkbɨkgwan joŋ yokwi dakon yerɨ tɨŋtɨŋaŋek kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jap yet kwaŋek bamɨ tok do aŋakwa joŋ yokwi kɨsi kwaŋ wɨwit. ");
INSERT INTO yut_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Kwaŋakwa pɨndagek pi monjɨ da kɨŋ pi ami aŋalon aŋek yaŋ iyɨwit, ‘Amɨn tagɨ, gak pigokon jap yet tagɨ baŋgɨn yopgul kagagwan joŋ yokwi uŋun niaŋon da kwawit?’ ");
INSERT INTO yut_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Iyɨŋba yaŋ yagɨt, ‘Uwal kɨnda da tɨŋtɨŋagɨt.’ “Yaŋban iyɨwit, ‘Niaŋ nandɨsal? Kɨŋ joŋ yokwi pɨlɨtneŋ do nandɨsal bo niaŋ?’ ");
INSERT INTO yut_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Yaŋba yaŋ yoyɨgɨt, ‘Dɨma. Joŋ yokwi pɨlɨtni kaŋ, jap bamɨ dɨ kɨsi pɨlɨtdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yum pɨndagakwa jap gat joŋ gat kɨsi kwaŋakwa bamɨ pakpak bɨsapmon jap bamɨ pakpak pi monjɨno yaŋ yoyɨkeŋ: Mibɨltok ji joŋ yokwi kɨndapmon sok do baljaŋ gwɨlɨk yopni. Aŋek jap bamɨ paŋ ɨlɨgek jap yutnokon pawɨgɨ yopni.’ ” ");
INSERT INTO yut_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tɨlak gen kɨnda gat yaŋ yoyɨgɨt: “Piŋkop da Amɨn Kɨla Asak uŋun mastat yet yombem. Amɨn kɨnda da mastat yet pinikon kwaokgɨt. ");
INSERT INTO yut_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastat yet uŋun jap yet kɨsi morap dakon pɨŋbi. Yerɨ monɨŋɨsisok. Mani kwaotno madepsi kwosok. Jap dɨwarɨ dakon tagok tagokni uŋun yapmaŋ mudaŋek kɨndap da yaŋ kwosok. Ae kɨlɨŋɨ madep yopban kɨŋakwa mɨnam morapmɨ da paŋabɨŋ uŋungwan yɨkgaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu da aeni tɨlak gen kɨnda gat yaŋ yoyɨgɨt, “Piŋkop da Amɨn Kɨla Asak uŋun yis yombem. Mɨŋat kɨnda da plaua ɨdap madep kɨnda gat ɨktagɨldak. Yaŋ aŋakwan plaua uŋun kɨsisi paptaŋ madep tawit.” ");
INSERT INTO yut_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Gen morap uŋun Yesu da mɨŋat amɨn kabɨ yoyɨgɨt uŋun tɨlak genon dagɨn yagɨt. Gen noman dɨma yoyɨŋ teŋteŋagɨt. Tɨlak gengɨn yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yaŋ aŋakwan kombɨ gen kɨnda kalɨp yaŋbi uŋun bamɨ toŋ agɨt. Gen uŋun yaŋ: “Nak da ji tɨlak gen dayɨkeŋ. Yo kalɨpsi Piŋkop da mɨktɨm wasagɨt bɨsapmon pasɨlɨ tawit da ae abɨsok toŋ uŋun do dayɨkeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu da mɨŋat amɨn kabɨ madepsi yopmaŋek yutnon wɨgakwan paŋdetni da Yesukon kɨŋek yaŋ iyɨwit, “Joŋ pigaga kwoŋ dakon tɨlak gen uŋun dakon mibɨlɨ yaŋbɨ nandano.” ");
INSERT INTO yut_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iyɨŋba yaŋ yoyɨgɨt, “Jap yet tagɨ yopmaŋdak amɨn uŋun Amɨn Dakon Monji. ");
INSERT INTO yut_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Pi uŋun on mɨktɨm. Aŋek jap yet tagɨ uŋun Piŋkop da Amɨn Kɨla Asak da kagagwan ekwaŋ mɨŋat amɨn kabɨyo. Ae joŋ yokwi uŋun Yokwi Ami dakon mɨŋat amɨn kabɨyo. ");
INSERT INTO yut_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Aŋek uwal joŋ tɨŋtɨŋagɨt uŋun Sunduk, ae jap pakpak bɨsap uŋun mɨktɨm da mudosak bɨsap madep. Ae jap bamɨ pakpak pi monjɨ uŋun Piŋkop dakon aŋelo kabɨni. ");
INSERT INTO yut_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Amɨn da joŋ pɨlɨk kɨndapmon sosoŋ uŋudeŋ gɨn bɨsap mudok mudogɨkon yaŋ gɨn altokdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Amɨn Dakon Monji uŋun aŋelo kabɨni yabekban uŋun da yo morap yokwi agak dakon yo paŋalon aŋ gat ae yokwi pakpak amɨn gat kɨsi Iyɨ Kɨla Asak da kagagwan baŋ pɨlɨk maba kɨndap tepmɨsi sosok uŋungwan pɨgɨkdaŋ. Pɨgɨ uŋungwan kunam tagek iyoŋ iyoŋ yaŋek egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Uŋun bɨsapmon amɨn kɨlegɨ kabɨ Datni da Amɨn Kɨla Asak da kagagwan gɨldat da teŋteŋosok uŋudeŋ teŋteŋaŋek egɨpdaŋ. Nak da gen yosot pakyaŋsi nandani.” ");
INSERT INTO yut_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesu da saŋbeŋek yaŋ yagɨt, “Piŋkop da Amɨn Kɨla Asak uŋun moneŋ kɨnam kɨnda wɨtjɨŋbi yombem. Amɨn kɨnda da moneŋ kɨnam kɨnda mɨktɨm kagagwan yɨpbi naŋ kaŋkwaŋ aeni aŋkɨ sɨbɨgɨt. Aŋek but galak nandaŋek yo kabɨni taŋ ɨmgwit uŋun kɨsisi amɨnon yumaŋ naŋek uŋun dakon moneŋɨ baŋ uŋun mɨktɨm tɨm yumaŋ nagɨt.” ");
INSERT INTO yut_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesu da saŋbeŋek yaŋ yagɨt, “Ae Piŋkop da Amɨn Kɨla Asak uŋun moneŋ ɨlɨt amɨn kɨnda yombem. Uŋun amɨn yo tomni wɨkwisi wɨsɨŋ pɨndat do pi asak. ");
INSERT INTO yut_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aŋek kɨndɨrɨŋ kɨnda wagɨl mani toŋsi tomni wukwisi kɨnda kosok bɨsapmon kɨŋ yo kabɨni taŋ ɨmgwit uŋun kɨsisi amɨnon yumaŋ naŋek uŋun dakon moneŋɨ baŋ uŋun kɨndɨrɨŋ tagɨsi yumgut.” ");
INSERT INTO yut_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesu da saŋbeŋek yaŋ yagɨt, “Aeno tɨlak gen kɨnda dayɨko nandani. Piŋkop da Amɨn Kɨla Asak uŋun tap kɨlap sɨmɨl sɨmɨl yɨk yombem. Amɨn da uŋun yɨk pakbi ɨdapgwan yɨpba pɨkwan tap kɨlap mibɨlɨ mibɨlɨ yɨkgwan pɨkwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pɨgɨ tugaŋba ɨlɨkba ɨleŋɨkon wɨkwan yɨgek tap kɨlap kokwinɨkgaŋ. Tagɨ amɨn ɨdap madepmon yopmaŋek yokwi amɨn maba kwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mɨktɨm dakon bɨsap mudosak bɨsapmon yaŋ gɨn altokdɨsak. Aŋelo kabɨ da abɨŋ amɨn yokwi amɨn kɨlegɨ da bɨkbɨgon ekwaŋ uŋun tɨmɨtdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tɨmɨgek maba kɨndap tebanon pɨgek uŋungwan kunam tagek iyoŋ iyoŋ yaŋek egɨpdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yaŋ yaŋek Yesu da paŋdetni yaŋ yoyɨgɨt, “Gen morap dayɨsat uŋun dakon mibɨlɨ nandaŋ mudoŋ bo dɨma?” Yoyɨŋban iyɨwit, “O, nandaŋ mudomaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yaŋba Yesu da yoyɨgɨt, “Gen teban dakon yoyɨŋdet amɨn Piŋkop da Amɨn Kɨla Asak uŋun dakon mibɨlɨ kaluk nandaŋek nandaŋ gadasak uŋun yut kɨnda dakon ami yombem. Uŋun amɨn yo kabɨ yopyop tamonikon kɨŋ yo kalugɨ ae kalɨpmɨ kɨsi paŋabɨŋ amɨn yolɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu uŋun tɨlak gen morap yoyɨŋ mudaŋek uŋun kokup yɨpmaŋek ");
INSERT INTO yut_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","iyɨ da kokupmon kɨgɨt. Uŋudon Juda amɨn da muwut muwut yutnon wɨgɨ amɨn yoyɨŋ degakwan tamtam yaŋek yaŋ yawit, “Nandaŋ kokwin tagɨsi ae wasok tapmɨmɨ toŋ agak dakon tapmɨm dukwan baŋ pagɨt? ");
INSERT INTO yut_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Uŋun kɨsit kɨlda dakon monji. Meŋi uŋun Maria, ma? Ae padɨk padɨk kabɨni Jems, Josep, Saimon ae Judas, ma? ");
INSERT INTO yut_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Aŋek samɨni kabɨ bɨkbɨk ninon ekwaŋ. Yo morap uŋun dukon tɨmɨkgɨt?” ");
INSERT INTO yut_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yaŋ yaŋek kurak taŋ ɨmɨŋek nandaba pɨŋban ɨmgwit. Yaŋ nandaŋek egakwa Yesu da yaŋ yoyɨgɨt, “Kombɨ amɨn kɨnda iyɨ dakon kokupni ae dɨwatniyo da nandaba pɨŋban ɨmɨŋakwa mɨktɨm dɨwarɨkon amɨn da nandaba wɨkwan ɨmaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Amɨn uŋun dɨma nandaŋ gadaŋ ɨmgwit, do Yesu uŋudon wasok tapmɨmɨ toŋ morapmɨ dɨma agɨt. ");
INSERT INTO yut_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kɨla amɨn madep Erot uŋun Yesu dakon gen bin nandaŋek ");
INSERT INTO yut_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","oman amɨn kabɨni yaŋ yoyɨgɨt, “Jon Telagɨ Pakbi Sogok Amɨn uŋun kɨmoron da pɨdak, do wasok tapmɨmɨ toŋ agak uŋun dakon tapmɨm taŋ ɨmɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kalɨp Erot da padɨge Pilip dakon mɨŋatni Erodias tuwɨl pagɨt. Aban Jon da Erot yaŋ iyɨgɨt, “Gak gen teban yapmaŋek padɨgɨgo dakon mɨŋatni tuwɨl pal. Uŋun tagɨ dɨma.” Gen uŋun nandaŋek Erot da obip amɨni yabekban kɨŋ Jon abɨdaŋek nap teban naŋ wamaŋ dam tebanon yɨpgwit. ");
INSERT INTO yut_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erot uŋun Jon aŋakban kɨmotjak do nandagɨt, mani amɨn da Jon uŋun kombɨ amɨn kɨnda yaŋ nandawit. Do amɨn do pasalek Jon dɨma aŋakgɨt. ");
INSERT INTO yut_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Don Erot dakon altok altok bɨsap do nandaŋek jap noknok awit bɨsapmon Erodias dakon gwi da kap aban Erot da kaŋek nandaban yo madepsi agɨt. ");
INSERT INTO yut_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Aŋek yaŋ teban tok kɨnda aŋek yaŋ iyɨgɨt, “Yo nido nayɨki, tagɨ gabeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Iyɨŋban meŋi da gwi nandak nandak ɨban Erot yaŋ iyɨgɨt, “Jon Telagɨ Pakbi Sogok Amɨn uŋun dakon busuŋɨ ɨdapmon yɨpmaŋ nabi.” ");
INSERT INTO yut_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Gen yaŋ yaŋban Erot burɨkon jɨgɨ nandagɨt, mani amɨn jap nawit uŋun da ɨŋamon yaŋ teban tok agɨt uŋun do pasalek gen yagɨt dɨma kɨrɨŋɨkgɨt. Obip amɨni yoyɨŋban mɨŋatjok da gen iyɨgɨt uŋudeŋ aŋek ");
INSERT INTO yut_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","dam tebanon kɨŋ Jon dakon busuŋɨ mandaŋ dagawit. ");
INSERT INTO yut_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mandaŋ dagaŋ ɨdapmon yɨpmaŋ aŋabɨŋ mɨŋatjok uŋun do ɨba aŋkɨ meŋi do ɨmgut. ");
INSERT INTO yut_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aŋakwan Jon dakon paŋdetni da kɨŋ bumjotni abɨdaŋ aŋkɨ wayɨkgwit. Wayɨgek kɨŋ Yesu uŋun dakon geni iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu uŋun Jon aŋakba kɨmakgɨt dakon gen bin nandaŋek iyɨ gɨn bot kɨnda abɨdaŋek mɨktɨm amɨni mɨnikon kɨgɨt. Kɨŋakwan mɨŋat amɨn kabɨ madep Yesu uŋudon kɨsak yaŋ nandaŋek kokupni yopmaŋ yopmaŋ aŋek pakbi ɨdap ɨleŋɨ naŋ yol aŋkɨwit. ");
INSERT INTO yut_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Aŋakwa bot uŋun paŋkɨ ɨleŋɨkon agakwan Yesu pɨŋ ɨleŋɨkon wɨŋek amɨn kabɨ madepsi pɨndak bupmɨ nandaŋek sot amɨn paŋmɨlɨp agɨt. ");
INSERT INTO yut_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Aŋakwan pɨlɨndo paŋdetni da abɨŋ Yesu yaŋ iyɨwit, “Mɨktɨm amɨni mɨnikon ekwamaŋ, ae gɨldat kɨlɨ pɨgɨkdɨsak, do yoyɨŋbɨ amɨn kabɨ madep kokup monɨŋ monɨŋ kɨŋek iyɨ do jap yumaŋ noni.” ");
INSERT INTO yut_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yaŋba yaŋ yoyɨgɨt, “Nido kɨni? Dɨsi jap yomgut.” ");
INSERT INTO yut_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yoyɨŋban yaŋ yawit, “Ninon jap morapmɨ dɨma. Bret kɨsit kɨnda ae tap kɨlap bamorɨ dagɨn taŋ nimaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yaŋba Yesu da yaŋ yoyɨgɨt, “Uŋun nagon paŋopni.” ");
INSERT INTO yut_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yaŋ yaŋek amɨn morap joŋ tɨmon yɨtni do yoyɨgɨt. Aŋek bret kɨsit kɨnda ae tap kɨlap bamot pabɨdaŋek Kwen Kokup sɨŋtaŋek gɨsamɨkgɨt. Yaŋ aŋek bret jokgalek paŋdetni do yoban uŋun da amɨn do yomgwit. ");
INSERT INTO yut_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yoba tɨmɨk amɨn morap kɨsisi arɨpmɨsi nawit. Naŋba bret dɨwat tawit uŋun paŋdetni da sɨmɨlba yɨk madepsi 12 kabɨ yaŋ tugawit. ");
INSERT INTO yut_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wɨli 5 tausen da jap nawit. Ae mɨŋat monjɨyo jap nawit uŋun dɨma manjɨkbi. ");
INSERT INTO yut_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu paŋdet kabɨni boron wɨgek pakbi ɨdap terɨ kɨnda uŋun da kalɨp wɨgɨni do yoyɨgɨt. Kɨŋakwa Yesu mɨŋat amɨn kabɨ madep yoyɨŋban kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yoyɨŋban kɨŋakwa iyɨ gɨn ɨleŋ kɨndakon bɨsit ak do wɨgɨgɨt. Wɨgɨ gɨldat pɨgakwan iyɨ gɨn ɨleŋon egɨpgut. ");
INSERT INTO yut_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Yesu ɨleŋon egakwan paŋdet kabɨni boron da kɨŋ dubak taŋakwa mɨrɨm da abɨŋ bot tomnikon tɨdaŋakwan pakbi da madepsi tamalɨgakwan bot tobɨl tobɨl agɨt. ");
INSERT INTO yut_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kɨlɨ wɨsawɨsa do Yesu da pakbi ɨdapmon bamaŋ bamaŋ kɨŋ paŋdetni kabɨkon noman taŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pakbi ɨdapmon bamaŋ bamaŋ apban kaŋek paŋdetni si pasalgwit. Aŋek “Koŋ kɨnda abɨsak!” yaŋ yaŋek yaŋ tɨdawit. ");
INSERT INTO yut_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yaŋ tɨdaŋakwa uŋudon gɨn Yesu da yaŋ yoyɨgɨt, “Ji si teban taŋek egɨpni. Nak naga abɨsat. Dɨma pasolni.” ");
INSERT INTO yut_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yoyɨŋban Pita da iyɨgɨt, “Amɨn Tagɨ, gaga abɨsal kaŋ, yaŋbɨ pakbi kwenon da bamaŋ bamaŋ gagon opbo.” ");
INSERT INTO yut_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iyɨŋban Yesu da yagɨt, “Kɨlɨ op.” Yaŋ yaŋban Pita da bot yɨpmaŋek pɨŋ pakbi kwenon bamaŋek Yesukon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kɨŋakwan mɨrɨm uŋun tebai aban kaŋ pasalek pakbi kagagwan tɨmɨsok dɨ pɨgek yaŋ tɨdaŋek yagɨt, “Amɨn Tagɨ nak aŋpuluga!” ");
INSERT INTO yut_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yaŋ tɨdaŋban uŋudon gɨn Yesu da Pita abɨdaŋek yaŋ iyɨgɨt, “Gak nandaŋ gadatgo pɨsɨpmɨ, nido but bamot asal?” ");
INSERT INTO yut_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yaŋ iyɨŋban boron wɨgakwal mɨrɨm dagagɨt. ");
INSERT INTO yut_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dagaŋakwan boron yɨkgwit amɨn uŋun Yesu gawak ɨmɨŋek yawit, “Asisi, gak Piŋkop dakon Monji.” ");
INSERT INTO yut_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pakbi ɨdap terɨ kɨnda Genesaret mɨktɨmon kɨŋ ɨleŋɨkon wɨgakwan ");
INSERT INTO yut_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","uŋun mɨktɨm amɨn da Yesu kaŋ nandaŋyo awit. Kaŋ nandaŋyo aŋek Yesu abɨk dakon gen bin saŋbeŋba mɨktɨm terɨ terɨ kɨgɨt. Kwan nandaŋek sot amɨn kɨsisi paŋabɨŋ yopmaŋakwa ");
INSERT INTO yut_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","sot amɨn da Yesu dakon paba pɨgɨk dɨwatni ɨgayɨk do bɨsit tebai iyɨwit. Ɨgayɨwit amɨn uŋun kɨlek taŋ mudawit. ");
INSERT INTO yut_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parisi amɨn dɨwarɨ gat ae gen teban yoyɨŋdet amɨn dɨwarɨ gat Jerusalem kokup papmon da obɨŋek Yesu yaŋ iyɨwit, ");
INSERT INTO yut_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nido paŋdet kabɨgo babɨk dakon gen teban yapmaŋek kɨsirɨ dɨma sugaŋek jap noŋ?” ");
INSERT INTO yut_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yaŋba Yesu da yaŋ yoyɨgɨt, “Ji Piŋkop dakon gen teban yɨpmaŋek babɨkji dakon gen paŋteban aŋek uŋun baŋ paŋ ekwaŋ. Uŋun tagɨ dɨma. ");
INSERT INTO yut_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Piŋkop da yaŋ yagɨt, ‘Ji meŋ datyo dakon pɨŋbi egek geni guramɨtni’ ae kɨnda gat yaŋ yosok, ‘Amɨn kɨnda da meŋ datyo do gen yokwi kɨnda yosak kaŋ, uŋun amɨn si aŋakba kɨmotjak.’ ");
INSERT INTO yut_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mani ji da amɨn gulusuŋ yoyɨŋ degek yaŋ yoyaŋ, ‘Meŋ datyo do nandaba wɨkwanek yo kabɨ uŋun do paŋpulugogɨ uŋun Piŋkop do paretni kaŋ uŋun tagɨ’ ji da suŋ yaŋ yoyaŋ. ");
INSERT INTO yut_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ji yaŋ aŋek babɨkji dakon gen teban guramɨgek Piŋkop dakon gen teban maba kɨsak. ");
INSERT INTO yut_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ji jamba but amɨn, Piŋkop da kombɨ amɨn Aisaia dakon nandak nandak aŋtagap aban ji do gen yaŋsi mandagɨt: ");
INSERT INTO yut_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Uŋun amɨn kabɨ gen kaga dagɨn nak man madep namaŋ, mani but dasi nak dɨma nandaŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Iyɨ dakon gen teban do, “On uŋun Piŋkop dakon gen” yaŋ yaŋek amɨn yoyɨŋ dekgaŋ. Nak gawak namaŋ uŋun koko yo ɨsalɨ asak.’ ” ");
INSERT INTO yut_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu da mɨŋat amɨn kabɨ madep yaŋ ɨlɨkban apba yoyɨgɨt, “Gen dayɨko mɨrak yopmaŋek nandaba pɨsosak. ");
INSERT INTO yut_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yo si nono pɨkwaŋ uŋun do Piŋkop da nandaban yokwi dɨma asak. Mani gen yomaŋ uŋun do Piŋkop da nandaban yokwi tosok.” ");
INSERT INTO yut_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yaŋ yaŋban paŋdetni da obɨŋ yaŋ iyɨwit, “Gen on yaŋaki Parisi amɨn dakon but yokwi toŋ gak uŋun dɨ nandɨsal, bo dɨma?” ");
INSERT INTO yut_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yaŋba Yesu da yaŋ yoyɨgɨt, “Kwen Kokup Datno yo iyɨ dɨma kwaokgɨt uŋun gelɨmbɨl pɨlɨk mudokdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ji on amɨn do nandaba kɨk dɨma ani. On amɨn kosit yolɨk amɨn dabɨlɨ mɨni yombem. Dabɨlɨ mɨni kɨnda da notni kɨnda kosit yolɨsak kaŋ, kɨsi bamot gapmakon mokdamal.” ");
INSERT INTO yut_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Yaŋban Pita da Yesu yaŋ iyɨgɨt, “Gak amɨn tɨlak gen yoyɨl uŋun dakon mibɨlɨ tagɨ niyɨŋbɨ nandaneŋ?” ");
INSERT INTO yut_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yaŋban Yesu da yaŋ yagɨt, “Jiyo kɨsi dɨma nandaŋ pɨsoŋ? ");
INSERT INTO yut_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Jap morap nomaŋ uŋun kwasopninon pɨgek kosirɨ naŋ abɨgɨsak. ");
INSERT INTO yut_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mani gen yokwi yomaŋ uŋun nandak nandakninon da wɨŋ butnin paŋupbal asak. ");
INSERT INTO yut_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yo uŋun yaŋ do yosot: nandak nandak yokwi, amɨn dapba kɨmot, yumabi aŋpak mibɨlɨ mibɨlɨ, kabo, topmon da gen pikon yopyop, ae yaŋba yokwi tok. ");
INSERT INTO yut_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Amɨn da uŋun aŋpak morap aŋakwa Piŋkop da pɨndakban yokwi aŋ. Mani ji kɨsitji dɨma sugaŋek jap noŋ uŋun da yokwi dɨma asak.” ");
INSERT INTO yut_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu kokup uŋun yɨpmaŋek Tair ae Saidon kokup bamot tomal uŋudon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kɨŋ altaŋakwan Kenan mɨŋat kɨnda uŋudon egɨpgut uŋun da abɨŋ yaŋ tɨdaŋek yaŋ yagɨt, “Amɨn Tagɨ, Dewit Dakon Monjɨ, bupmɨ nandaŋ nam! Gwano koŋ da madepsi aŋupbal asak.” ");
INSERT INTO yut_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yaŋban Yesu da gen kobogɨ kɨnda dɨma iyɨgɨt. Aŋakwan paŋdet kabɨni da obɨŋek Yesu yaŋ iyɨwit, “Mɨŋat on yaŋ tɨdaŋek jɨgɨ nimɨŋek noldak. Uŋun tagɨ dɨma. Iyɨŋbɨ kwan.” ");
INSERT INTO yut_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yaŋba Yesu da yaŋ yagɨt, “Piŋkop da nak Israel amɨn sipsip kabɨni pasɨlbi uŋun baŋgɨn paŋpulugokeŋ do yabekgɨt.” ");
INSERT INTO yut_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yaŋban nandaŋek mɨŋat da abɨŋ gawak ɨmɨŋek yaŋ iyɨgɨt, “Amɨn Tagɨ, aŋpulugoki dosi nandɨsat!” ");
INSERT INTO yut_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yaŋ yaŋban Yesu da iyɨgɨt, “Mɨŋat monjɨyo dakon jap pɨŋan do yomyomɨ mɨni.” ");
INSERT INTO yut_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yaŋban mɨŋat da yaŋ iyɨgɨt, “Amɨn Tagɨ, bamɨ yosol, mani pɨŋan tewɨgɨ da tamokon da jap jɨmjɨm moŋ uŋun tagɨ noŋ.” ");
INSERT INTO yut_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yaŋban Yesu da nandaŋek yaŋ iyɨgɨt, “O mɨŋat, nandaŋ gadatgo uŋun wukwisi. Yo nido yal uŋun yaŋ gɨn altaŋ gamdɨsak.” Yaŋ iyɨŋakwan uŋudon gɨn gwi kɨlek tagɨt. ");
INSERT INTO yut_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu uŋun kokup yɨpmaŋek Galili Pakbi Ɨdap da ɨleŋɨkon kɨgɨt. Kɨŋek uŋudon da ɨleŋ kɨndakon pawɨgɨ yɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Pawɨgɨ yɨgakwan mɨŋat amɨn kabɨ madepsi da sot amɨn morapmɨ paŋapgwit. Kandapmɨ yokwi ae gɨreŋɨkbi, dabɨlɨ mɨni, amɨn kadɨm, ae sot mibɨlɨ mibɨlɨ toŋ uŋun Yesu da buron paŋabɨŋ yopmaŋakwa paŋmɨlɨp agɨt. ");
INSERT INTO yut_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Aŋakwan kadɨm da gen yawit, ae kandapmɨ yokwi ae gɨreŋɨkbi da kosit agɨpgwit, ae dabɨlɨ mɨni da sɨŋtawit. Amɨn da uŋun pɨndagek Israel dakon Piŋkop do tamtam yaŋek aŋkɨsiwit. ");
INSERT INTO yut_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu da paŋdet kabɨni yaŋ yoban apba yaŋ yoyɨgɨt, “On mɨŋat amɨn kabɨyo nin gat gɨldat kapbɨ egɨpmamaŋ. Kɨlɨ japni kɨsi naŋ mudaŋ, do nak bupmɨ nandaŋ yomɨsat. Jap dɨma yomɨŋek yabetno kɨni kaŋ, kosiron ɨŋam kɨmot aŋek maŋ potdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yaŋban paŋdetni da yaŋ iyɨwit, “On mɨktɨm amɨni mɨnikon bret morapmɨ dukon baŋ on mɨŋat amɨn morapyo yomno noni?” ");
INSERT INTO yut_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yaŋba yoyɨgɨt, “Jikon bret niaŋ da toŋ?” Yaŋban yawit, “Ninon bret 7 ae tap kɨlap monɨŋgok bamorɨsok dagɨn taŋ nimaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yaŋ yaŋakwa Yesu da mɨŋat amɨn kabɨyo madep mɨktɨmon pabɨŋ yɨtni do yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yoyɨŋban yɨgakwa Yesu da bret 7 kabɨ gat ae tap kɨlap gat tɨmɨk Piŋkop ya yaŋ iyɨŋek pudaŋ paŋdetni do yoban uŋun da amɨn do yoba nawit. ");
INSERT INTO yut_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kɨsi arɨpmɨsi naŋba jap dɨwat tawit uŋun paŋdetni da tɨmɨgek yɨk madepsi 7 kabɨ sɨmɨlgwit. ");
INSERT INTO yut_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wɨli 4 tausen da jap nawit. Ae mɨŋat monjɨyo jap nawit uŋun dɨma manjɨkbi. ");
INSERT INTO yut_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu uŋun mɨŋat amɨn kabɨ madepsi yoyɨŋban kɨŋakwa iyɨ boron wɨgek Magadan tet do kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisi amɨn ae Sadyusi amɨn dɨwarɨ da Yesu aŋkewal do aŋek opgwit. Asi Piŋkop dakon pi naŋ asak bo dɨma yaŋ do wasok tapmɨmɨ toŋ kɨnda aban koni do iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Iyɨŋba yoyɨgɨt, “Gɨldat pɨgɨk do aŋakwan ji yaŋ yoŋ, ‘Kwen gami asak, do aŋwa bɨsap tagɨsi.’ ");
INSERT INTO yut_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ae wɨsa dagokdosi ji yaŋ yoŋ, ‘Gɨkwem pɨli ae kwen gami asak, do sɨkak mɨrɨmyo akdɨsak.’ Ji gɨldat wɨsayo pɨndagek kokwin tagɨsi aŋ, mani abɨsok bɨsap ekwamaŋ uŋun kaŋek kokwin tagɨ dɨma aŋ. ");
INSERT INTO yut_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Amɨn on bɨsapmon ekwaŋ uŋun amɨn yokwisi gɨn. Piŋkop dakon pi naŋ asat yaŋ nandak do wasok tapmɨmɨ toŋ kɨnda kok do yoŋ. Mani kɨnda dɨma kokdaŋ. Kombɨ amɨn Jona dakon tɨlak naŋgɨn kokdaŋ.” Yaŋ yoyɨŋek yopmaŋ kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu gat paŋdetni gat pakbi ɨdap terɨ kɨnda kɨwit bɨsapmon paŋdetni bret do ɨŋtaŋek kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yaŋ aba Yesu da yaŋ yoyɨgɨt, “Ji Parisi gat ae Sadyusi amɨn gat uŋun dakon yis do pakyaŋsi kaŋ kɨmotni.” ");
INSERT INTO yut_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yaŋban notni yoyɨŋ yoyɨŋ aŋek yaŋ yawit, “Ninon bret mɨni uŋun do bo yosok?” ");
INSERT INTO yut_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Gen uŋun yaŋba Yesu burɨkon da pɨndak nandaŋyo aŋek yaŋ yoyɨgɨt, “Ji nido ninon bret mɨni yaŋ yoŋ? Ji nandaŋ gadatji pɨsɨpmɨ! ");
INSERT INTO yut_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ji butji sigɨn pakyaŋsi dɨma nandaŋ pɨsoŋ, ma? Nak bret 5 kabɨ baŋ amɨn 5 tausen do yobo naŋakwa dɨwarɨ yɨk morapmɨ sɨmɨlba tugawit ji uŋun do si ɨŋtoŋ? ");
INSERT INTO yut_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ae bret 7 kabɨ baŋ amɨn 4 tausen do yobo naŋakwa dɨwarɨ yɨk morapmɨ sɨmɨlba tugawit ji uŋun do si ɨŋtoŋ? ");
INSERT INTO yut_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nak bret do yat yaŋ nandaŋ, ma? Dɨma. Ji Parisi gat ae Sadyusi amɨn gat dakon yisni do pakyaŋsi kaŋ kɨmotni, nak uŋun do dayɨt.” ");
INSERT INTO yut_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yaŋ yaŋban nandaŋek burɨ pɨsawit. Bret dakon yis do dɨma yosok, Parisi gat ae Sadyusi amɨn gat dakon yoyɨŋdetni toptopmɨ do kaŋ kɨmotneŋ do yosok yaŋ nandawit. ");
INSERT INTO yut_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu Sisaria Pilipai kokup pap aŋkapmat aŋek paŋdetni yaŋ yoyɨgɨt, “Amɨn da Amɨn Dakon Monji do namɨn amɨn kɨnda yaŋ yoŋ?” ");
INSERT INTO yut_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yaŋban iyɨwit, “Dɨwarɨ da Jon Telagɨ Pakbi Sogok Amɨn yaŋ yoŋ, ae dɨwarɨ da Elaija yaŋ yoŋ, ae dɨwarɨ da kombɨ amɨn Jeremaia, bo kombɨ amɨn ŋwakŋwarɨ kɨnda yaŋ yoŋ.” ");
INSERT INTO yut_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yaŋba Yesu da yaŋ yoyɨgɨt, “Ae dɨsi nak do namɨn yaŋ yoŋ?” ");
INSERT INTO yut_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Yaŋ yoyɨŋban Saimon Pita da yaŋ iyɨgɨt, “Gak Kristo, Piŋkop egɨp egɨpmɨ toŋ uŋun dakon Monji egɨsal.” ");
INSERT INTO yut_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yaŋban Yesu da yaŋ iyɨgɨt, “Saimon, Jon dakon monji, gak kɨsɨk kɨsɨk tagɨ abi. Gen yal uŋun mɨktɨm amɨn kɨnda da dɨma golɨgɨt. Kwen Kokup Dat da iyɨ golɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nak yaŋ gayɨsat, mango uŋun Pita. Aŋakwan tɨp uŋun da kwenon paŋmuwukbi kabɨno paŋ- muwuk yopbo Tɨpdom dakon tapmɨm da arɨpmɨ dɨma pabɨŋ yopmaŋakwan toktogɨsi taŋ aŋ aŋ kɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Piŋkop da Amɨn Kɨla Asak uŋun dakon yoma wɨtdal gabeŋ. Gen mɨktɨmon yaŋ aŋteban abi, Kwen Kokupmon Piŋkop da yaŋ gɨn yaŋ aŋteban asak. Ae gen mɨktɨmon yaŋ wɨtdalbi, Kwen Kokup-mon Piŋkop da yaŋ gɨn yaŋ wɨtdaljak.” ");
INSERT INTO yut_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yaŋ yaŋek Yesu da paŋdetni dɨma yoni do kɨrɨŋɨk yomɨŋek yaŋ yoyɨgɨt, “Nak Kristo egɨsat uŋun amɨn kɨnda dɨmasi iyɨni.” ");
INSERT INTO yut_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Uŋun bɨsapmon Yesu da wasaŋek yo noman taŋ ɨmdaŋ uŋun do paŋdetni yoyɨŋek yaŋ yagɨt, “Nak Jerusalem kokup papmon kɨŋek kɨla amɨn, ae mukwa sogok amɨn dakon amɨn madep kabɨ, ae gen teban yoyɨŋdet amɨn uŋun da yo yokwisi aŋ namɨŋek nɨkba kɨmotdɨsat. Aŋek gɨldat kapbɨ aŋakwan Piŋkop da aban pɨdokdɨsat.” ");
INSERT INTO yut_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yaŋban Pita da uŋun gen nandaŋek Yesu ɨleŋɨkon aŋkɨ tebai yaŋ iyɨgɨt, “Amɨn Tagɨ! Uŋun yo morap dɨmasi altaŋ gamni!” ");
INSERT INTO yut_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yaŋban Yesu da Pita yaŋ iyɨgɨt, “Sunduk gak nepmaŋ det! Kosit sopsop dɨma aŋnam. Gak Piŋkop dakon nandak nandak naŋ dɨma yoldal, gak amɨn dakon nandak nandak naŋ yoldal.” ");
INSERT INTO yut_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yaŋ yaŋek Yesu da paŋdetni yaŋ yoyɨgɨt, “Amɨn kɨnda nak nol do nandɨsak kaŋ, uŋun amɨn iyɨ dakon galaktok morapni kɨsi yopmaŋ mudaŋek tɨlak kɨndapni guramɨgek nak noljak. ");
INSERT INTO yut_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Amɨn kɨnda iyɨ dakon yɨyɨtni tagɨsi tosak do nandaŋek pi madep asak kaŋ, egɨp egɨpni pasɨl ɨmjak. Mani amɨn kɨnda nak do nandaŋek egɨp egɨpni do nandaban yo madep dɨma asak kaŋ, uŋun amɨn egɨp egɨp dagok dagogɨ mɨni abɨdosak. ");
INSERT INTO yut_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Amɨn kɨnda da mɨktɨm dakon yo morap paŋ egakwan egɨp egɨpni pasɨljak kaŋ, uŋun yo morap da niaŋ aŋek aŋpulugoni? Bo egɨp egɨpni aeni abɨdok do tomni ninaŋ yumjak? ");
INSERT INTO yut_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Amɨn Dakon Monji uŋun Datni dakon tɨlɨmni gat ae aŋelo kabɨni gat apdɨsak. Uŋun bɨsapmon mɨŋat amɨn morapyo aŋpakni awit uŋun da arɨpmon tomni yomdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nak asisi dayɨsat, on akgaŋ kabɨkon da dɨ dɨma kɨmagek egakwa gɨn Amɨn Dakon Monji uŋun kɨla amɨn madep mani paŋek apban kokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Gɨldat 6 kabɨ mudaŋakwa Yesu da Pita, Jems ae padɨge Jon yoyɨŋban buŋon yolba ɨleŋ dubagɨ kɨndakon pawɨgɨ iyɨ gɨn egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ɨleŋon egek kaŋakwa Yesu dakon gɨptɨm ŋwakŋwarɨsi agɨt. Aŋakwan tomno dabɨlniyo gɨldat da yaŋ teŋteŋagɨt. Ae ɨmalniyo kɨsi kwakwagɨsi ae teŋteŋɨni toŋsi agɨt. ");
INSERT INTO yut_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yaŋ aban kaŋakwa Moses gat Elaija gat altaŋbal Yesu gat gen yaŋ nandatyo aba pɨndakgwit. ");
INSERT INTO yut_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Yaŋ aŋakwa Pita da Yesu iyɨgɨt, “Yoyɨŋdet, nin ɨdon egɨp do tagɨsi nandamaŋ. Gak da tagɨ yaŋ nandabɨ kaŋ, nak da yut kabeŋ kapbɨ abeŋ. Kɨnda gak do, kɨnda Moses do ae kɨnda Elaija do abeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita da gen yaŋakwan gɨn gɨkwem teŋteŋɨni madep da pɨŋ ɨlɨmɨk yomɨŋakwan gen kɨnda uŋungwan da yaŋ noman tagɨt, “Uŋun Monjɨno, but dasi galak taŋ ɨmɨsat, ae uŋun do nandabo wagɨl tagɨsisi asak. Ji geni nandani.” ");
INSERT INTO yut_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Paŋdetni gen uŋun nandaŋek mɨktɨmon maŋ pagek madepsi pasal nɨmnɨmɨkgwit. ");
INSERT INTO yut_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yaŋ aba Yesu da abɨŋ gɨptɨmɨkon wɨtjɨŋek yaŋ yoyɨgɨt, “Ji dɨma pasalek pɨdabɨt.” ");
INSERT INTO yut_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Yaŋ yaŋban pɨdaŋ kwen sɨŋtaŋek amɨn bamot dɨma pɨndakgwit, Yesu naŋgɨn kawit. ");
INSERT INTO yut_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ɨleŋon da tobɨl pɨŋek Yesu da yaŋ yoyɨgɨt, “Yo uŋun pɨndaŋ uŋun dakon gen amɨn kɨnda dɨma iyɨni. Aŋakwa Amɨn Dakon Monji kɨmoron da pɨdosak uŋun bɨsapmon tagɨ yoyɨni.” ");
INSERT INTO yut_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Paŋdetni da Yesu yaŋ iyɨwit, “Gen teban yoyɨŋdet amɨn da gen kɨnda yaŋ yoŋ, ‘Elaija mibɨltok abɨŋakwan Kristo uŋun buŋon apjak.’ Gen uŋun nido yoŋ?” ");
INSERT INTO yut_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iyɨŋba Yesu da gen kobogɨ yaŋ yoyɨgɨt, “Gen uŋun bamɨ yoŋ. Elaija da abɨŋ yo morap paŋkaluk akdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mani Elaija kɨlɨ apgut, aban amɨn da dɨma kaŋba pɨsagɨt, do galaktokni yolek yo yokwi mibɨlɨ mibɨlɨ aŋ ɨmgwit. Ae Amɨn Dakon Monji uŋunyo kɨsi yo yokwi mibɨlɨ mibɨlɨ yaŋ gɨn aŋɨmdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yaŋ yaŋban paŋdetni da Jon Telagɨ Pakbi Sogok Amɨn do yosok yaŋ nandaba pɨsagɨt. ");
INSERT INTO yut_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu gat paŋdetni kapbɨ gat ɨleŋon da pɨŋ mɨŋat amɨn morapmɨ muwukgwit kabɨkon kɨŋakwa amɨn kɨnda da abɨŋ Yesu da buron gawagek yaŋ iyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Amɨn Tagɨ, gak monjɨno do bupmɨ nandaŋ ɨbi! Uŋun bɨsap morapmɨ tebaisi nɨmnɨmɨgek jɨgɨ tepmɨyo madepsi pasak. Aŋek bɨsap morapmɨ kɨndapmon mosok bo ae pakbi kagagwan maŋ pɨgɨsak. ");
INSERT INTO yut_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nak paŋdet kabɨgokon aŋkɨko aŋmɨlɨp ak do aŋtɨdok ayɨŋ.” ");
INSERT INTO yut_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yaŋban Yesu da yaŋ yagɨt, “Ji nandaŋ gadatji mɨni amɨn, ji aŋpakji yokwisi. Nak bɨsap niaŋ da ji gat egek jɨgɨsi guramɨk dabeŋ? Monjɨ uŋun nagon aŋopgut!” ");
INSERT INTO yut_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yaŋ yoyɨŋban aŋopba Yesu da koŋ uŋun gen tebaisi iyɨŋban wɨŋ abɨgɨŋakwan uŋun bɨsapmon gɨn monji uŋun kɨlek tagɨt. ");
INSERT INTO yut_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aŋakwan don paŋdetni iyɨ gɨn obɨŋ Yesu yaŋ iyɨwit, “Nin nido koŋ uŋun yol do aŋtɨdok amaŋ?” ");
INSERT INTO yut_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Yaŋba yaŋ yoyɨgɨt, “Ji dakon nandaŋ gadatji uŋun pɨsɨpmɨsi, yaŋ do aŋek aŋtɨdok ayɨŋ. Nak asisi dayɨsat, ji dakon nandaŋ gadatji uŋun monɨŋɨsisok, mastat yet yombem taŋ damɨsak kaŋ, ji kabap on iyɨŋba tuwɨl kɨ tɨmɨ kɨndakon tagɨ kɨsak. Ae pi morap kɨsi tagɨ ani.” ");
INSERT INTO yut_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesu paŋdetni gat Galili mɨktɨmon muwugek yaŋ yoyɨgɨt, “Amɨn Dakon Monji amɨn da uwal da kɨsiron yɨpba ");
INSERT INTO yut_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","uŋun da aŋakba kɨmotdɨsak. Aŋakwa gɨldat kapbɨ aŋakwan Piŋkop da kɨmoron naŋ aban pɨdokdɨsak.” Gen uŋun yaŋban nandaŋek bupmɨsi nandawit. ");
INSERT INTO yut_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu gat paŋdetni gat Kapaneam kokupmon kɨŋ altaŋakwa Telagɨ Yut Madep dakon takis tɨmɨt tɨmɨt amɨn da Pitakon kɨŋ yaŋ iyɨwit, “Yoyɨŋdetgo Telagɨ Yut Madep do takis yopmaŋdak bo dɨma?” ");
INSERT INTO yut_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Yaŋba Pita da yagɨt, “O, yopmaŋdak.” Pita da yaŋ yoyɨŋek yutnon wɨgɨ gen kɨnda dɨma yaŋakwan Yesu da kalɨp yaŋ iyɨgɨt, “Saimon gak niaŋ nandɨsal? On mɨktɨmon kɨla amɨn madep madep takis tɨmɨkgaŋ, uŋun takis namɨn da yopmaŋgaŋ? Iyɨ dakon monjini da bo amɨn ŋwakŋwarɨ da yopmaŋgaŋ?” ");
INSERT INTO yut_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Yaŋban Pita da yagɨt, “Amɨn ŋwakŋwarɨ da yopmaŋgaŋ.” Yaŋban iyɨgɨt, “Yaŋdo, iyɨ dakon monjini da takis dɨma yopmaŋgaŋ. ");
INSERT INTO yut_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mani nin takis dɨma yopneŋ kaŋ, uwal aŋnimdaŋ. Do gak pakbi ɨdapmon kɨŋ nap yɨpbɨ pɨkwan tap kɨlap mibɨltok aŋatjak uŋun da gen kagakon moneŋ kɨnda taŋban kokdɨsal. Uŋun moneŋ naŋ nit do Telagɨ Yut Madep do takis yopbi.” ");
INSERT INTO yut_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Uŋun bɨsapmon paŋdetni da Yesukon kɨŋek yaŋ iyɨwit, “Piŋkop da Amɨn Kɨla Asak da kagagwan namɨn da amɨn dɨwarɨ yapmaŋek man madepni toŋ?” ");
INSERT INTO yut_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yaŋba Yesu da amɨn monɨŋ kɨnda iyɨŋban opban paŋdetni da bɨkbɨgon yɨpban agakwan ");
INSERT INTO yut_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yaŋ yoyɨgɨt, “Nak asisi dayɨsat, ji kulabɨk aŋek amɨn monɨŋ da tɨlagon dɨma egɨpni kaŋ, ji Piŋkop da Amɨn Kɨla Asak da kagagwan dɨma egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Amɨn kɨnda iyɨ do nandaban pɨŋakwan amɨn monɨŋ da tɨlagon egɨpjak kaŋ, uŋun amɨn Piŋkop da Amɨn Kɨla Asak da kagagwan man madepni toŋ. ");
INSERT INTO yut_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ae amɨn kɨnda da amɨn monɨŋ oden kɨnda nak nandaŋ gadaŋ namɨŋek egakwan aŋpulugosok kaŋ, uŋun amɨn nak naŋ aŋpulugosok.” ");
INSERT INTO yut_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yesu da saŋbeŋek yaŋ yagɨt, “Amɨn kɨnda da amɨn monɨŋ kɨnda nak nandaŋ gadaŋ namɨŋek egakwan yokwi asak do yabetjak kaŋ, uŋun dakon kobogɨ yokwisi. Yabet dɨma aŋakwan amɨn da wit mɨsɨŋɨt tɨp madep tegɨkon wamaŋ maba tap ɨlarɨgwan pɨgek kɨmotjak kaŋ uŋun tagɨ. ");
INSERT INTO yut_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Mɨktɨmon amɨn ekwaŋ, awa! Amɨn dɨwarɨ da yokwikon depdaŋ. Mani yokwi ani do yabetdaŋ amɨn, awa! ");
INSERT INTO yut_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kɨsitgo bo kandapgo da yokwi aki do gayɨŋban kaŋ, mandaŋ dagaŋ mabɨ kɨsak. Gwɨnɨmbɨl egek Tɨpdomon kɨndap tebanon pɨgɨki yaŋ do kɨsitgo bo kandapgo mandaŋ dagaŋek tagapmɨ egɨp egɨp dagok dagogɨ mɨni do amɨn aki. ");
INSERT INTO yut_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ae dabɨlgo da yokwi aki do gayɨsak kaŋ, pɨlɨk mabɨ kɨsak. Gwɨnɨmbɨl egek Tɨpdomon kɨndap tebanon pɨgɨki yaŋ do dabɨlgo kɨnda pɨlɨgek tagapmɨ egɨp egɨp dagok dagogɨ mɨni do amɨn aki. ");
INSERT INTO yut_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Ji kaŋ kɨmotni. Amɨn monɨŋ dakon aŋeloni Kwen Kokupmon Piŋkop da ɨŋamon toktogɨsi ekwaŋ. Do amɨn monɨŋ do nandaba yo ɨsalɨ dɨma ani.” ");
INSERT INTO yut_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yesu da saŋbeŋek yaŋ yagɨt, “Ji niaŋ nandaŋ? Amɨn kɨnda sipsipni 100 kabɨkon da kɨnda pasɨljak kaŋ, niaŋ asak? Kaŋ 99 kabɨ ɨleŋ obakon yopban jap naŋek egakwa kaloŋɨ pasɨljak uŋun wusɨk do kɨsak. ");
INSERT INTO yut_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","“Nak asisi dayɨsat, sipsipni kaŋ kwosak bɨsapmon but galak madepsi nandakdɨsak. 99 kabɨ dɨma pasɨlgwit uŋun do tagɨ nandɨsak. Mani kaloŋɨ pasɨljak naŋ kaŋ kwokdɨsak uŋun do kɨsɨk kɨsɨk madepsi nandakdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yaŋgɨn Kwen Kokup Datji da amɨn monɨŋ kɨnda pasɨljak do dɨma galak tosok.” ");
INSERT INTO yut_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesu da saŋbeŋek yaŋ yagɨt, “Notgo kɨnda yokwi aŋgaban kaŋ, kɨŋ kaŋbɨ dɨsilgɨn gen uŋun yaŋ aŋmɨlɨp ak do pi anjil. Gengo nandaŋ yawokban kaŋ notgo abɨdaŋbɨ gagakon apjak. ");
INSERT INTO yut_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mani gengo dɨma nandaŋ yawokban kaŋ, amɨn kaloŋɨ bo bamorɨ yaŋ tɨmɨkbɨ kɨni. ‘Yaŋ aŋek ji amɨn bamorɨ bo kapbɨ da gen uŋun tagɨ aŋteban ani.’ ");
INSERT INTO yut_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Uŋun amɨn kapbɨ dakon gen dɨma nandɨsak kaŋ, kɨŋ paŋmuwukbi kabɨkon mibɨlni yoyɨni. Aŋek paŋmuwukbi kabɨ dakon gen dɨma nandɨsak kaŋ, uŋun amɨn yokwisi asak. Uŋun amɨn do Piŋkop dɨma nandaŋ ɨmaŋ amɨn ae takis tɨmɨt tɨmɨt amɨn yaŋ nandaŋ ɨmni. ");
INSERT INTO yut_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nak asisi dayɨsat, gen mɨktɨmon yaŋ aŋteban asal, Kwen Kokupmon Piŋkop da yaŋ gɨn yaŋ aŋteban akdɨsak. Ae gen mɨktɨmon yaŋ wɨtdaldal, Kwen Kokupmon Piŋkop da yaŋ gɨn yaŋ wɨtdaldɨsak. ");
INSERT INTO yut_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","“Nak saŋbeŋek yaŋ dayɨsat, on mɨktɨmon amɨn bamorɨ bo kapbɨ nak da manon da muwutni kaŋ, nak bɨkbɨknikon egɨpbeŋ, do but kaloŋ aŋek yo kɨnda do bɨsit yoni kaŋ, Datno Kwen Kokup egɨsak uŋun da tagɨ damjak.” ");
INSERT INTO yut_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Uŋun bɨsapmon Pita da abɨŋ Yesu yaŋ iyɨgɨt, “Amɨn Tagɨ, notno kɨnda da yokwi aŋnaban kosirɨ niaŋ da yokwini yopmaŋ ɨbeŋ? Kosirɨ 7 kabɨ bo niaŋ?” ");
INSERT INTO yut_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yaŋban Yesu da yaŋ iyɨgɨt, “Nak yaŋ gayɨsat, yokwini kosirɨ 7 kabɨ dɨma, yokwini yopmaŋ ɨbɨ kosirɨ 77 kabɨ yaŋ asak. ");
INSERT INTO yut_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nandani, Piŋkop da Amɨn Kɨla Asak uŋun yaŋ. Kɨla amɨn madep kɨnda pi monjɨni da goman aŋ ɨmgwit, uŋun gomani paŋkɨlek ak do nandagɨt. ");
INSERT INTO yut_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wasaŋek gomani paŋkɨlek aŋakwan amɨn kɨnda aŋaŋ opgwit. Uŋun amɨn goman moneŋ 50 milion danari. ");
INSERT INTO yut_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mani goman uŋun sopsop dakon moneŋ uŋun da arɨpmon dɨma taŋ ɨmgut. Do kɨla amɨn madep da uŋun amɨn gat gwakni gat oman amɨn egakwa tomni do amɨn da moneŋ ɨba gomani sopjak do yagɨt. Ae yo morapni yumaŋ naŋ mudaŋek uŋun dakon moneŋ baŋ goman sopjak do amɨn tagɨni da gen tebai yagɨt. ");
INSERT INTO yut_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Oman monjɨ gen uŋun nandaŋek amɨn tagɨ ŋwakbeŋ aŋ ɨmɨŋek bɨsit tebai yaŋ iyɨgɨt, ‘Butgo yaworɨ taŋakwan egaki don gomango kɨsisi sopbeŋ.’ ");
INSERT INTO yut_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yaŋ yaŋban amɨn tagɨni da bupmɨ nandaŋ ɨmɨŋek goman madepni yɨpmaŋ ɨmɨŋakwan ɨsal kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Aŋakwan oman monjɨ uŋun waŋga pɨgɨ pi ɨsalni kɨnda uŋun goman moneŋ 10 danari taŋ ɨmgut uŋun kagɨt. Kaŋek tegɨkon tebai abɨdaŋek gen tebai yaŋ iyɨgɨt, ‘Gomano agɨl uŋun paŋop!’ ");
INSERT INTO yut_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Pi ɨsalni uŋun geni nandaŋek ŋwakbeŋ aŋ ɨmɨŋek bɨsit tebai yaŋ iyɨgɨt, ‘Butgo yaworɨ taŋakwan egaki don gomango gabeŋ.’ ");
INSERT INTO yut_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Mani geni dɨma nandaŋek pi ɨsalni abɨdaŋ aŋkɨ dam tebanon yɨpmaŋek gomani ɨmɨŋek don waŋga pɨsak do yagɨt. ");
INSERT INTO yut_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Aŋakwan pi ɨsalni dɨwarɨ da kaŋek burɨ yokwi taŋba kɨŋ amɨn tagɨnikon yo uŋun agɨt do iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Yaŋba nandaŋek amɨn tagɨ uŋun da oman monjɨ uŋun iyɨŋban opban yaŋ iyɨgɨt, ‘Gak pi monjɨ yokwi. Gak bɨsit tebai nayɨŋbɨ goman kɨsisi yɨpmaŋ gamɨt. ");
INSERT INTO yut_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nak da bupmɨ nandaŋ gamɨt, gak nido pi ɨsalgo do bupmɨ yaŋ gɨn dɨma nandaŋ ɨmɨl?’ ");
INSERT INTO yut_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yaŋ yaŋek japmɨ nandaŋek obip amɨni yaŋ yoyɨgɨt, ‘Ji aŋakba tepmɨ nandaŋek gomano kɨsisi sopban don yɨpbo kɨsak.’ ” ");
INSERT INTO yut_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tɨlak gen on dakon wasɨpmɨ do Yesu da saŋbeŋek yaŋ yagɨt, “Yaŋgɨn notji da yokwi aŋdaba yokwi yopyop but dasi nandaŋek dɨma ani kaŋ, Kwen Kokup Datno da yo jɨgɨ yaŋ gɨn aŋ damdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu gen uŋun yaŋ mudaŋek Galili mɨktɨm yɨpmaŋek Jodan Pakbi terɨ kɨnda Judia mɨktɨmon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kɨŋakwan mɨŋat amɨn kabɨ madepsi da yol aŋaŋ kɨŋakwa Yesu da sot amɨn morapmɨ paŋmɨlɨp agɨt. ");
INSERT INTO yut_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Aŋakwan Parisi amɨn dɨwarɨ da Yesukon abɨŋ aŋkewalek yaŋ iyɨwit, “Nin da gen tebanon niaŋ tosok? Amɨn kɨnda da mɨŋatni galak toknikon tagɨ kwɨnɨtjak, bo dɨma?” ");
INSERT INTO yut_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yaŋba Yesu da yaŋ yagɨt, “Ji Piŋkop da papiakon gen kɨnda tosok uŋun dɨma manjɨŋ kawit? Uŋun yaŋ tosok, ‘Wasok wasogɨkon Piŋkop da amɨn wasaŋek mɨŋat ae wɨliyo kɨsi wasagɨt.’ ");
INSERT INTO yut_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wasaŋek yaŋ yagɨt, ‘Wɨli da meŋi datniyo yopmaŋek mɨŋatni gat muwukbal gɨptɨm kaloŋɨ anjil.’ ");
INSERT INTO yut_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Gen yaŋ tosok, do amɨn wam da bamorɨ dɨma, gɨptɨm kaloŋɨ amal. Uŋun do Piŋkop da mɨŋat wɨli kɨlɨ paŋmuwukgɨt, do amɨn da dɨma paŋwasekdo.” ");
INSERT INTO yut_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yaŋ yaŋban Parisi amɨn da iyɨwit, “Yaŋ kaŋ ae mibɨlɨ nido Moses da gen teban kɨnda yaŋ mandagɨt? Gen uŋun yaŋ: ‘Amɨn kɨnda mɨŋatni kwɨnɨt do kaŋ, mɨŋat paŋkwɨnɨt papia kɨnda mandaŋ ɨmɨŋek kwɨnɨtjak.’ ” ");
INSERT INTO yut_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yaŋba Yesu da yagɨt, “Moses uŋun but tebanji do aŋek gen teban uŋun mandagɨt. Mani wasok wasogɨkon mɨŋat paŋkwɨnɨt dakon kosit uŋuden kɨnda dɨma tagɨt. ");
INSERT INTO yut_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yaŋ dayɨsat, amɨn kɨnda mɨŋatni yumabi dɨma aŋakwan kwɨnɨgek mɨŋat kaluk pasak kaŋ, uŋun wɨli iyɨ yumabi asak.” ");
INSERT INTO yut_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Paŋdetni da gen uŋun nandaŋek yaŋ iyɨwit, “Yaŋ kaŋ mɨŋat eyo dɨma aŋek egɨpdo.” ");
INSERT INTO yut_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yaŋba Yesu da yaŋ yoyɨgɨt, “Amɨn dɨwarɨ Piŋkop da paŋpulugaŋakwan mɨŋat dɨma paŋek tagɨ egɨpni. ");
INSERT INTO yut_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ae amɨn dɨwarɨ uŋun gɨptɨmni yokwi da altoŋ, ae dɨwarɨ amɨn da yabi pabi, ae dɨwarɨ Piŋkop da Amɨn Kɨla Asak dakon pi do nandaŋek egɨp egɨpni parekgaŋ, yaŋ do aŋek mɨŋat dɨma paŋ. Gen on abɨdok do nandaŋ amɨn uŋun tagɨ abɨdoni.” ");
INSERT INTO yut_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Uŋun bɨsapmon amɨn da mɨŋat monjɨyoni Yesu da kɨsitni kwenikon wutjɨŋek bɨsit aŋyomjak do paŋopgwit. Paŋopba paŋdetni da dɨma paŋopni do tebai yoyɨwit. ");
INSERT INTO yut_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yaŋ aba Yesu da paŋdetni yaŋ yoyɨgɨt, “Mɨŋat monjɨyo yopba nagon apgut. Dɨma kɨrɨŋɨk yomni. Piŋkop da Amɨn Kɨla Asak uŋun amɨn mɨŋat monjɨyo da tɨlagon ekwaŋ uŋuden amɨn dakon.” ");
INSERT INTO yut_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yaŋ yaŋek kɨsitni mɨŋat monjɨyo da kwenon wutjɨŋek don uŋun kokup yɨpmaŋ kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Bɨsap kɨndakon amɨn kɨnda da Yesukon obɨŋek yaŋ iyɨgɨt, “Yoyɨŋdet, nak ni aŋpak tagɨ kɨnda naŋ aŋek egɨp egɨp dagok dagogɨ mɨni abɨdokeŋ?” ");
INSERT INTO yut_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yaŋban yaŋ iyɨgɨt, “Gak aŋpak tagɨ do nido nayɨsal? Amɨn Kaloŋɨ gɨn uŋun tagɨsi. Gak Piŋkop dakon gen teban guramɨgek egɨp egɨp dagok dagogɨ mɨnikon tagɨ kɨki.” ");
INSERT INTO yut_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yaŋban iyɨgɨt, “Gak ni gen teban do yosol?” Yaŋban Yesu da iyɨgɨt, “Amɨn dɨma dapba kɨmotni, mɨŋat eyo kɨlɨ abi ji yumabi dɨma ani, yo kabo dɨma noni, top gen yaŋek amɨn notji yum dogɨn gen pikon dɨma yopni, ");
INSERT INTO yut_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","meŋ dat do nandaba wukwanek geni guramɨtni, ae gaga do but dasi niaŋ galak tosol, uŋudeŋ gɨn amɨn do but dasi galak taŋ yobi.” ");
INSERT INTO yut_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Yaŋ yaŋban monjɨ gɨmoŋɨ da yaŋ iyɨgɨt, “Nak uŋun gen teban morap guramɨk mudosot. Mani yo kɨnda gat ninaŋsi aŋek egɨp egɨp dagok dagogɨ mɨni abɨdokeŋ?” ");
INSERT INTO yut_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yaŋban Yesu da yaŋ iyɨgɨt, “Gak kɨlegɨsi egɨp do nandɨsal kaŋ, kɨŋ yo morapgo yumaŋ naŋek uŋun dakon moneŋ baŋ yoni mɨni amɨn do yobi. Yaŋ aŋaki yo tagɨsi Kwen Kokupmon taŋ gamdɨsak. Yaŋ aŋek abɨŋ nak nol.” ");
INSERT INTO yut_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Amɨn uŋun yoni morapmɨ taŋ ɨmgwit, do gen uŋun nandaŋ burɨ jɨk taŋban si kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kɨŋakwan Yesu da paŋdetni yaŋ yoyɨgɨt, “Nak asisi dayɨsat, yoni morapmɨ amɨn uŋun Piŋkop da Amɨn Kɨla Asak da kagagwan pɨgɨk do aŋtɨdok akdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Asisi, bɨt madepsi kamel uŋun da ɨmal bupbup da kosit gwagagon arɨpmɨ dɨma pɨgɨgɨ asak. Mani uŋun yapmaŋek yoni morapmɨ amɨn uŋun Piŋkop da Amɨn Kɨla Asak uŋun da kagagwan arɨpmɨ dɨmasi pɨgɨgɨ asak.” ");
INSERT INTO yut_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yaŋban paŋdetni nandaŋ wɨrɨpdagek yaŋ yawit, “Yaŋ kaŋ namɨn amɨn da egɨp egɨp dagok dagogɨ mɨni abɨdosak?” ");
INSERT INTO yut_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yaŋba Yesu da paŋdet kabɨni pɨndagek yaŋ yoyɨgɨt, “Amɨn iyɨ arɨpmɨ dɨma ani, mani Piŋkop da yo morap ak do tagɨ asak.” ");
INSERT INTO yut_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yaŋban Pita da Yesu gen kɨnda yaŋ iyɨgɨt, “Nin yo morap yopmaŋek gak naŋ gɨn gol awɨlgamaŋ. Do nin yo ni baŋ tɨmɨtneŋ?” ");
INSERT INTO yut_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yaŋban Yesu da yaŋ yoyɨgɨt, “Nak asisi dayɨsat, yo aeni kalugɨ mudoni uŋun bɨsap madepmon Amɨn Dakon Monji man madep paŋek kɨla amɨn madep yɨtyɨt tamoni tɨlɨmɨ toŋ uŋudon yɨtdɨsak. Aŋakwan ji nak nolgaŋ amɨn uŋun bɨsapmon kɨla amɨn madep tamo 12 kabɨ uŋudon yɨgek Israel amɨn kabi 12 dakon gen kokwin kɨla agak pi akdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Amɨn morap nak do nandaŋek yutni, notni, sami, meŋi, datni, mɨŋat monjɨyoni, ae jap pini yopmaŋ detni, uŋun yo morapni kosirɨ 100 yaŋ tɨmɨk tɨmɨk akdaŋ. Yaŋ aŋek egɨp egɨp dagok dagogɨ mɨni abɨdokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mani amɨn morapmɨ abɨsok mibɨltok ekwaŋ uŋun da buŋon amɨn akdaŋ. Aŋakwa amɨn morapmɨ abɨsok buŋon ekwaŋ uŋun da mibɨltok amɨn akdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesu da saŋbeŋek yaŋ yagɨt, “Piŋkop dakon Amɨn Kɨla Agakni uŋun yaŋ. Amɨn kɨnda mɨktɨmni morapmɨ. Uŋun amɨn wɨsa dagokdosi kɨŋ pi monjɨ wain pinikon pi ani do tɨmɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Gɨldat kaloŋɨ do moneŋ 1 danari tɨmɨtni do yoyɨŋban but kaloŋ aba wain pinikon yabekban kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Kɨŋakwa tɨmɨ dɨ egɨ 9 kilok aŋakwan pi ami kɨŋ makeron amɨn dɨwarɨ ɨsal ekwa pɨndagek ");
INSERT INTO yut_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","yaŋ yoyɨgɨt, ‘Jiyo kɨsi wain pinokon kɨŋ pi aŋakwa pi ani da arɨpmon moneŋ dabeŋ.’ Yaŋban nandaŋek wain pinikon kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Kɨŋakwa don gɨldat binap aeni makeron kɨŋ dɨ gat tɨmɨkgɨt. Aeni 3 kilok kɨŋ yaŋ gɨn pi monjɨ dɨ gat tɨmɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Aŋek egɨ pɨlɨndosi kɨŋ amɨn dɨwarɨ ɨsal agakwa pɨndagek yaŋ yoyɨgɨt, ‘Ji nido gɨldat daman pini mɨni ɨsal ekwaŋ?’ ");
INSERT INTO yut_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Yaŋban gen kobogɨ yaŋ iyɨwit, ‘Amɨn kɨnda da nin pi dɨma nimɨk.’ “Yaŋ yaŋba pi dakon ami da yaŋ yoyɨgɨt, ‘Ji kɨsi kɨŋ wain pinokon pi ani.’ ");
INSERT INTO yut_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Yaŋ yoyɨŋek egɨ pɨlɨn pɨlɨndo pi ami da kɨŋ pi monjɨ dakon kɨla amɨn yaŋ iyɨgɨt, ‘Pi monjɨ yaŋ paŋmuwugek moneŋni yobi. Buŋonsi abeŋ uŋudon da wasaŋek yomɨŋaki wɨgɨ mibɨltok abeŋ uŋudon dagosak.’ ");
INSERT INTO yut_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Yaŋ paŋ muwugek pi monjɨ pɨlɨndosi abeŋ uŋun do moneŋ 1 danari yomɨŋ yomɨŋ agɨt. ");
INSERT INTO yut_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yaŋ aban kaŋek pi monjɨ mibɨltok apgwit uŋun nin da moneŋ madep tɨmɨtdamaŋ yaŋ nandawit. Mani dɨma, kɨsi morap moneŋ 1 danari gɨn tɨmɨk tɨmɨk awit. ");
INSERT INTO yut_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mibɨltok abeŋ amɨn uŋun moneŋ 1 danari tɨmɨgek pi uŋun dakon ami do nandaba yokwi taŋban ");
INSERT INTO yut_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","yaŋ iyɨwit, ‘Nin wɨsa dagokdosi abɨŋ pi aŋapno gɨldat da madepsi nindaŋakwan pɨlɨn tosok. Buŋonsi abeŋ uŋun bɨsap pɨsɨpmɨsok pi ayɨŋ, do nido moneŋ tɨlak kaloŋɨ kongɨn nimɨsal?’ ");
INSERT INTO yut_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Yaŋ yaŋba nandaŋek amɨn tagɨ da pi monjɨ kɨnda yaŋ iyɨgɨt, ‘Not, nak da gak yokwi kɨnda dɨma aŋgamɨt. Nak moneŋ 1 danari gabeŋ do gayɨko gaga but kaloŋ al. ");
INSERT INTO yut_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Do gak moneŋgo abɨdaŋek kɨ. Naga da galaktogon amɨn buŋon abeŋ uŋun gat moneŋ tɨlak kaloŋɨkon damɨsat. ");
INSERT INTO yut_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Uŋun nak dakon yo. Naga dakon galaktok yolek moneŋno tagɨ kokwinɨk dabeŋ. Nak amɨn do yo tagɨsi aŋapbo gak nido nandaba yokwi tok asal?’ ” ");
INSERT INTO yut_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yaŋ yaŋek Yesu da wasɨp do yaŋ yagɨt, “Yaŋgɨn buŋon amɨn da mibɨltokdaŋ, aŋakwa mibɨltok amɨn da buŋon amɨn akdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu Jerusalem kokup papmon kɨŋek paŋdetni 12 kabɨ tɨmɨkban iyɨ gɨn kosiron kɨŋek yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nin abɨsok Jerusalem kɨŋapno amɨn da Amɨn Dakon Monji mukwa sogok amɨn dakon amɨn madep kabɨ ae gen teban yoyɨŋdet amɨn uŋun da kɨsiron yɨpdaŋ. Yaŋ aŋek gen pikon yɨpmaŋek kɨmotjak do yaŋ dagok akdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Yaŋ dagok aŋek Amɨn Ŋwakŋwarɨ Kabɨ da kɨsiron yɨpdaŋ. Yɨpba uŋun da toptopmon da man madep ɨmɨŋek, baljaŋek tɨlak kɨndapmon aŋakba kɨmotdɨsak. Kɨmagek gɨldat kapbɨ aŋakwan Piŋkop da kɨmoron naŋ aban pɨdokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yaŋ yaŋakwan Sebedi dakon monji bamot gat meŋi gat Yesukon kɨŋ altaŋek meŋi da ŋwakbeŋ aŋek Yesu da yo kɨnda aŋ yomjak do iyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iyɨŋban Yesu da yaŋ iyɨgɨt, “Nak da ninaŋ abeŋ do nandɨsal?” Iyɨŋban yaŋ yagɨt, “Gak kɨla amɨn madep egɨpbi bɨsapmon on monjɨ bamotno man madep paŋek kɨnda da gak da amɨn tet do ae kɨnda da gwandeŋ tet do yɨtjil do yaŋ dagok aŋyobi do nandɨsat.” ");
INSERT INTO yut_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yaŋban Yesu da monjɨ bamot yaŋ yoyɨgɨt, “Jil gen uŋun yomal dɨma nandaŋ pɨsaŋek yomal. Nak da tepmɨ madep pakdɨsat uŋun tagɨ panjil?” Yaŋban iyɨgɨmal, “Tagɨ pandeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yaŋ yaŋbal Yesu da yoyɨgɨt, “Uŋun asi, tepmɨ pakdɨsat uŋun pakdamal. Mani namɨn da nak da amɨn tet do ae gwandeŋ tet do yɨtjak, uŋun nak da arɨpmɨ dɨma yaŋ dagokeŋ. Tamo uŋun Datno da amɨn kɨlɨ manjɨŋ yopgut uŋun dakon.” ");
INSERT INTO yut_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Paŋdetni 10 kabɨ gen uŋun nandaŋek amɨn bamot uŋun do butjap nandawit. ");
INSERT INTO yut_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yaŋ nandaŋakwa Yesu da yoyɨŋban opba yaŋ yoyɨgɨt, “Ji Amɨn Ŋwakŋwarɨ Kabɨ dakon kɨla amɨni dakon mibɨlɨ dɨsi nandaŋ. Uŋun iyɨ do nandaba wukwanek mɨŋat amɨn kabɨyoni da geni guramɨk kɨmotni do nandaŋ. ");
INSERT INTO yut_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mani uŋun dakon aŋpak uŋun jikon dɨma tosak. Jikon da amɨn kɨnda amɨn tagɨ man pak do nandɨsak kaŋ, uŋun amɨn oman amɨnji egek amɨn tagɨ man pasak. ");
INSERT INTO yut_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Amɨn kɨnda jikon da mibɨltok amɨn egɨp do nandɨsak kaŋ, uŋun amɨn mɨŋat amɨn morap dakon oman amɨni egek mibɨltok amɨn asak. ");
INSERT INTO yut_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Amɨn Dakon Monji uŋun yaŋ gɨn kɨlɨ agɨt. Amɨn da oman aŋ tyuɨmni do dɨma pɨgɨt. Iyɨ mɨŋat amɨn morap paŋpulugokdo, ae iyɨ dakon gɨptɨmnaŋ paregek yumaŋ naŋ yop do pɨgɨt.” ");
INSERT INTO yut_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu gat paŋdetni gat Jeriko kokup pap yɨpmaŋ degakwa mɨŋat amɨn kabɨyo madepsi da yolgwit. ");
INSERT INTO yut_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kɨŋakwa kosit ɨleŋon dabɨlɨ mɨni amɨn bamorɨ yɨkgɨmal. Yɨgakwal amɨn da “Yesu abɨsak” yaŋ yaŋba nandaŋek madepsi yaŋ tɨdaŋek yaŋ yagɨmal, “Amɨn Tagɨ, Dewit Dakon Monji, bupmɨ nandaŋ nim!” ");
INSERT INTO yut_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yaŋ tɨdaŋbal amɨn kabɨ madepsi da dɨma yaŋ tɨdonjil do yaŋsop aŋyomgwit. Mani madepsi sigɨn yaŋ tɨdaŋek yagɨmal, “Amɨn Tagɨ, Dewit Dakon Monji, bupmɨ nandaŋ nim!” ");
INSERT INTO yut_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yaŋ tɨdaŋbal Yesu da nandaŋ kosiron agek yaŋ yoyɨgɨt, “Nak ninaŋ aŋ dabeŋ do nandamal?” ");
INSERT INTO yut_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Yoyɨŋban yaŋ iyɨgɨmal, “Amɨn Tagɨ, nit sɨŋtok do nandamak.” ");
INSERT INTO yut_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yaŋbal Yesu bupmɨ nandaŋek kɨsit da dabɨlɨ wɨtjɨŋban uŋudon gɨn sɨŋtaŋek Yesu yolgɨmal. ");
INSERT INTO yut_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu gat paŋdetni gat Jerusalem kokup pap aŋkapmat aŋek Betpage kokupmon kɨŋ altawit. (Kokup uŋun Ɨleŋ Olipmon tosok.) Altaŋek Yesu da paŋdetni bamorɨ yabegek ");
INSERT INTO yut_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","yaŋ yoyɨgɨt, “Jil ason kokup komaŋ uŋudon kɨŋ altaŋek uŋudon gɨn donki meŋi kɨnda napmon agakwan monji ɨsal akban pɨndatdamal. Uŋun wɨtdal ɨlɨk ɨdon paŋopjil. ");
INSERT INTO yut_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Amɨn kɨnda da ‘Nido yaŋ amal’ yaŋ dayɨŋban kaŋ, ‘Amɨn Tagɨ da pi kɨnda ak do aŋek yosok’ yaŋ iyɨŋbal uŋun da tepmɨ daban paŋopjil.” ");
INSERT INTO yut_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yaŋ yaŋakwan kombɨ amɨn kɨnda da kalɨpsigwan gen yagɨt uŋun bamɨ noman tagɨt. Gen uŋun yaŋ: ");
INSERT INTO yut_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Saion kokup pap amɨn do gen yaŋ yoyɨki, ‘Kabɨt, kɨla amɨn madepgo abɨsak. Burɨ maŋbi da donki da kwenon yɨgek abɨsak. Donki gɨmoŋɨ da kwenon yɨgek abɨsak.’ ” ");
INSERT INTO yut_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yesu da paŋdet bamot yoyɨŋban geni guramɨgek kɨgɨmal. ");
INSERT INTO yut_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kɨŋ donki meŋi gat monji gat paŋabɨŋ ɨmalni donki bamot da kwenikon yopmaŋakwal Yesu pawɨgɨ uŋudon yɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yaŋ aŋakwan amɨn morapmɨ da kosiron ɨmalni kukwaŋ yalɨwit. Aŋakwa amɨn dɨwarɨ da kɨŋ kɨndap kɨlɨŋ mandaŋ paŋobɨŋ kosiron yalɨwit. ");
INSERT INTO yut_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mɨŋat amɨn kabɨ madepsi mibɨltok kɨwit ae buŋon yolgwit kɨsi da gen pap yaŋek yaŋ yawit: “Osana! Dewit Dakon Monji aŋkɨsino! Amɨn on Amɨn Tagɨ da manon abɨsak, uŋun Piŋkop da gɨsamɨgakwan abɨsak. Piŋkop Wɨkwisi aŋkɨsino!” ");
INSERT INTO yut_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu uŋun Jerusalem kokup papmon pɨgakwan kokup amɨn kɨsi da burɨ pɨdaŋba yaŋ yawit, “On namɨn amɨnsi kɨnda?” ");
INSERT INTO yut_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yaŋba Yesu gat agɨpgwit mɨŋat amɨn kabɨ madep da yaŋ yawit, “On Yesu, uŋun kombɨ amɨn kɨnda, Nasaret kokup Galili mɨktɨmon da abɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu kɨŋ Telagɨ Yut Madep da nagalgwan pɨgɨ moneŋ ɨlɨt pi awit amɨn uŋun yolban waŋga abɨgɨwit. Yaŋ aŋek moneŋ kulabɨk awit amɨn gat mɨnam yumaŋ nawit amɨn dakon tamo uŋun kɨsi paŋtobɨlban tagal kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yaŋ aŋek gen yaŋ yoyɨgɨt, “Piŋkop da papiakon gen yaŋ tosok: ‘Nak dakon yut uŋun mɨŋat amɨnyo da abɨŋ bɨsit aŋnamni do tosok.’ Mani ji da kulabɨk aba ‘kabo noknok dakon pasɨlɨ tamo’ yombem asak.” ");
INSERT INTO yut_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesu Telagɨ Yut Madepmon egakwan amɨn dabɨlɨ mɨni ae kandapmɨ yokwi uŋudon opba paŋmɨlɨp agɨt. ");
INSERT INTO yut_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aŋakwan mukwa sogok amɨn dakon amɨn madep kabɨ ae gen teban yoyɨŋdet amɨn da wasok tapmɨmɨ toŋ agɨt uŋun do japmɨ nandawit. Ae mɨŋat monjɨyo da Telagɨ Yut Madepmon yaŋ tɨdaŋek yaŋ yawit, “Osana! Dewit Dakon Monji aŋkɨsino!” Yaŋ yaŋba uŋunyo kɨsi do japmɨ nandawit. ");
INSERT INTO yut_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yaŋ nandaŋek Yesu yaŋ iyɨwit, “Gak on gen yoŋ nandɨsal?” Yaŋ yaŋba Yesu da gen kobogɨ yaŋ yoyɨgɨt, “Gen yoŋ uŋun nandɨsat, mani ji gen kɨnda tosok uŋun dɨma manjaŋ? Gen uŋun yaŋ: ‘Gak mɨŋat monjɨyo gat ae monjɨ ŋakŋak gat paŋtagap aŋaki mango yaŋ aŋenokgoŋ.’ ” ");
INSERT INTO yut_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yaŋ yoyɨŋek kokup pap uŋun yɨpmaŋ waŋga pɨgek uŋun pɨlɨn kaga Betani kokupmon paŋkɨ pakgɨt. ");
INSERT INTO yut_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wɨsa dagaŋakwan Yesu aeni kokup papmon tobɨl kɨŋek kosiron jap do agɨt. ");
INSERT INTO yut_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aŋek kosit ɨleŋon pik kɨndap kɨnda akban kagɨt. Kaŋek kapmatjok da kɨŋ bamɨ dɨ dɨma pɨndakgɨt. Tamɨ gɨn pɨndagek yaŋ iyɨgɨt, “Gak buŋon ae bamɨ dɨmasi toki dosi nandɨsat!” Yaŋ iyɨŋakwan uŋudon gɨn wagɨlsi kɨbɨdagɨt. Tamɨ kɨsi alek taŋ mudawit. ");
INSERT INTO yut_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Aŋakwa paŋdetni da pɨndagek tamtam yaŋek iyɨwit, “Pik kɨndap niaŋon da tepmɨ kɨbɨdak?” ");
INSERT INTO yut_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yaŋba Yesu da gen kobogɨ yaŋ yoyɨgɨt, “Nak asisi dayɨsat, ji but bamot dɨma aŋek nandaŋ gadat bamɨsi aŋek egɨpni kaŋ, pik kɨndapmon wasok at jiyo kɨsi yaŋ gɨn tagɨ akdaŋ. Ae uŋun gɨn dɨma, on ɨleŋ pɨdaŋ tap kaga pɨgɨsak do iyɨni kaŋ, yaŋ gɨn akdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Uŋun do ji yo morap tɨmɨt do nandaŋ uŋun Piŋkop nandaŋ gadaŋ ɨmɨŋ kɨmagek bɨsit iyɨni kaŋ, uŋun yo morap damdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu uŋudon da kɨŋ Telagɨ Yut Madep da nagalgwan pɨgɨ amɨn yoyɨŋ dekgɨt. Yoyɨŋ degakwan mukwa sogok amɨn dakon amɨn madep kabɨ ae kɨla amɨn dɨwarɨ Yesukon obɨŋek yaŋ iyɨwit, “Namɨn da pi uŋun abi do yaŋ mudaŋ gamgut da yo uŋun asal? Ae namɨn da man madep gamgut?” ");
INSERT INTO yut_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yaŋba Yesu da yaŋ yoyɨgɨt, “Nak gen kɨnda dayɨkdɨsat. Dayɨko kobogɨ nayɨni kaŋ, nakyo kɨsi kobogɨ tagɨ dayɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon telagɨ pakbi sogɨt bɨsapmon, Piŋkop da yabekban pi agɨt bo amɨn da yabekba agɨt?” Yaŋban iyɨ gɨn notni yoyɨŋ yoyɨŋ aŋek yaŋ yawit, “ ‘Piŋkop da yabekgɨt’ yaŋ iyɨneŋ kaŋ, gen kobogɨ yaŋ niyɨkdɨsak, ‘Yaŋ kaŋ ji nido dɨma nandaŋ gadaŋ ɨmgwit?’ ");
INSERT INTO yut_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mani amɨn morapmɨ da Jon do kombɨ amɨn bamɨsi kɨnda yaŋ nandaŋ, do ‘Amɨn da yabekgwit’ yaŋ iyɨneŋ kaŋ, uŋun kɨsi tagɨ dɨma asak. Yaŋ kaŋ Jon dakon man bin aŋupbal ano mɨŋat amɨn kabɨ madep da nindapdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yaŋ nandaŋek Yesu do gen kobogɨ yaŋ iyɨwit, “Nin dɨma nandamaŋ.” Yaŋba Yesu da yaŋ yoyɨgɨt, “Nakyo kɨsi namɨn da pi uŋun abeŋ do yaŋ mudaŋ namgut uŋun dɨma dayɨkeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu da mukwa sogok amɨn tagɨ gat ae kɨla amɨn gat saŋbeŋek yaŋ yoyɨgɨt, “Amɨn kɨnda monjɨ bamorɨ gat egɨpgwit. Egek monji mibɨltogɨ yaŋ iyɨgɨt, ‘Monjɨno abɨsok kɨŋ wain pinokon pi aki.’ ");
INSERT INTO yut_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Iyɨŋban yagɨt, ‘Pi dɨma akeŋ.’ Mani don nandak nandakni kulabɨk aŋek kɨŋ pi agɨt. ");
INSERT INTO yut_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Aŋakwan datni da kɨŋ monji buŋon nani yaŋ gɨn iyɨŋban monji da yaŋ iyɨgɨt, ‘Dat, pi tagɨ abeŋ’, mani pikon dɨma kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Niaŋ nandaŋ? Monjɨ bamoron da jɨt amɨn da datni dakon gen guramɨkgɨt?” Yaŋban yaŋ iyɨwit, “Mibɨltok amɨn.” Yaŋba Yesu da yaŋ yoyɨgɨt, “Nak asisi yosot, takis tɨmɨt tɨmɨt amɨn yokwi gat ae kosit oba mɨŋat gat da ji gwapmaŋek Piŋkop da Amɨn Kɨla Asak da kagagwan mibɨltaŋ damɨŋek kwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jon da jikon obɨŋek kosit kɨlegɨ dayɨŋ dolɨŋban geni nandaba bamɨ dɨma agɨt. Mani takis tɨmɨt tɨmɨt amɨn yokwi gat ae kosit oba mɨŋat gat da geni nandaba bamɨ agɨt. Ji uŋun kawit mani nandak nandakji kulabɨk aŋek geni nandaba bamɨ dɨma agɨt.” ");
INSERT INTO yut_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu da saŋbeŋek yaŋ yoyɨgɨt, “Nak tɨlak gen kɨnda gat yoko nandabɨt. Amɨn kɨnda da wain pini aŋek nagal aŋ uŋun nagalon wain sop bamaŋ tɨl do gapma kɨnda wayɨkgɨt. Wayɨk mudaŋek kabo noknok pɨndat do yut dubak kɨnda aban wɨgɨgɨt. Yut aŋ mudaŋek amɨn da moneŋ pini dɨ aŋek pi ami do bamɨ dɨ paŋ ɨmni yaŋ nandaŋek pi uŋun da kɨsiron yɨpmaŋek mɨktɨm dubagɨkon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kɨŋ egɨ don wain sop pakpak bɨsap kwaŋ taŋakwan pi monjɨni yabekban wain bamɨ tɨmɨk paŋopni do kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Kɨŋ altaŋba wain pi dakon kɨla amɨn da uŋun pi monjɨ tɨmɨgek, kɨnda aŋak ukwayɨtyo awit, aŋek kɨnda aŋakba kɨmagakwan, kɨnda tɨp baŋ aŋakgwit. ");
INSERT INTO yut_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yaŋ aba pi ami da aeni pi monjɨni mibɨltok yabekgɨt uŋun dakon tɨlak yapmaŋek morapmɨ yabekgɨt. Yabekban kwa pi kɨla amɨn da mibɨltok awit uŋudeŋ gɨn yokwi aŋyomgwit. ");
INSERT INTO yut_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Buŋonsi iyɨ dakon monji naŋ yabegek yaŋ yagɨt, ‘Monjɨno kwan kɨla amɨn da uŋun do nandaba wukwan ɨmdaŋ.’ ");
INSERT INTO yut_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Mani kɨla amɨn da monji kaŋek notni yoyɨŋ yoyɨŋ aŋek yaŋ yawit, ‘Amɨn on da egɨ don datni dakon yo morap tɨmɨtdɨsak, do aŋatno kɨmagakwan wain pini nin do aŋawatneŋ.’ ");
INSERT INTO yut_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yaŋ yaŋek monjɨ uŋun abɨdaŋ ɨlɨk pigaga da waŋga aŋaŋ abɨgɨ aŋakba kɨmakgɨt. ");
INSERT INTO yut_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ji niaŋ nandaŋ? Don pi ami da abɨŋ pi kɨla amɨn niaŋ aŋyomjak?” ");
INSERT INTO yut_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yaŋban yaŋ iyɨwit, “Pi ami da abɨŋ uŋun amɨn yokwi kobogɨ yo yokwisi aŋyomdɨsak. Aŋek wain pi uŋun amɨn ŋwakŋwarɨ da kɨsiron yɨpban uŋun da wain sop pakpak bɨsapmon bamɨ tagɨ paŋ ɨmni.” ");
INSERT INTO yut_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yaŋba Yesu da yoyɨgɨt, “Ji Piŋkop da papiakon gen tosok uŋun dɨma manjɨŋ nandawit? Gen uŋun yaŋ: ‘Yut agak amɨn da gwak yokwi yaŋ yaŋek maba kɨgɨt. Mani Amɨn Tagɨ da uŋun gwak yut kodɨgɨkon tɨp kɨnda naŋ tɨdagɨt da gwak teban akdak. Yo uŋun Amɨn Tagɨ da iyɨ aban nin da kono yo masɨ masɨmɨsi asak.’ ");
INSERT INTO yut_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Uŋun do nak yaŋ dayɨsat, Piŋkop da iyɨ Amɨn Kɨla Asak jikon tosok uŋun ji da kɨsiron naŋ gwayeŋ amɨn kabi kɨnda bamɨ tagɨ paŋalon agagɨ uŋun da kɨsiron yɨpdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Amɨn morap gwak kwenon da maŋ dapba bɨsal kɨkdaŋ, ae gwak da amɨn morap da kwenon mosak uŋun wagɨl bɨsal kɨ mudokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yesu da tɨlak gen bamot uŋun yaŋban mukwa sogok amɨn dakon amɨn madep kabɨ gat ae Parisi amɨn gat da nin do yosok yaŋ nandawit. ");
INSERT INTO yut_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yaŋ nandaŋek Yesu abɨdokdosi nandawit, mani mɨŋat amɨn kabɨ madepsi uŋun da Yesu do kombɨ amɨn kɨnda yaŋ nandawit, do abɨdok do si pasalgwit. ");
INSERT INTO yut_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu da tɨlak gen kɨnda gat yaŋek amɨn yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Piŋkop dakon Amɨn Kɨla Agakni uŋun dakon tɨlak kɨnda uŋun yaŋ. Kɨla amɨn madep kɨnda monji do mɨŋat paŋek soŋnok madepsi agɨt. ");
INSERT INTO yut_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kɨlɨ jap noknok bɨsap kwaŋ taŋakwan kalɨp yaŋ yomgut amɨn yoyɨŋba opni do pi monjɨni yabekban kɨwit. Mani kɨŋ yoyɨŋba op do dɨma galak tawit. ");
INSERT INTO yut_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Yaŋ aba pi monjɨ dɨ gat aeni yabekgɨt. Yabegek yaŋ yoyɨgɨt, ‘Ji kɨŋ mibɨltok but pɨso yoyɨŋbi amɨn uŋun yaŋ yoyɨni: Nandani, nak bapalo gat ae bulmakau binap amɨn nelagɨ toŋsi kɨlɨ dapmaŋ mandaŋ soŋ yopmat. Jap morap kɨlɨ soŋ paŋnoman aŋ yopmat. Do ji opba monjino do mɨŋat pagɨm uŋun dakon soŋnok aneŋ.’ ");
INSERT INTO yut_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Pi monjɨni uŋun gen aŋaŋ uŋun amɨn kabɨkon aŋkɨwit, mani geni nandak do kuragɨ nandaŋek iyɨ da galak togon kɨŋ kɨŋ awit. Kɨnda uŋun pigagani kɨgɨt, ae kɨnda moneŋ ɨlɨt pinikon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yaŋ aŋakwa amɨn dɨwarɨ da pi monjɨ tɨmɨgek yo yokwi aŋ yomɨŋek dapba kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yaŋ aba kɨla amɨn madep uŋun japmɨsi nandaŋek emat amɨni yabekban kɨŋ pi monjɨni dapgwit amɨn uŋun kɨsisi dapba mɨni awit. Aŋek kokupni sowit. ");
INSERT INTO yut_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Aŋakwa kɨla amɨn madep da pi monjɨni yaŋ yoyɨgɨt, ‘Mɨŋat pakpak dakon jap kɨlɨ paŋ noman abi, mani si yaŋ yomgum amɨn uŋun amɨn yokwi, do nak dakon jap dɨma noni. ");
INSERT INTO yut_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yaŋdo, ji kɨŋ kosit papmon agek amɨn pɨndak yoyɨŋba apba jap pakbiyo aneŋ.’ ");
INSERT INTO yut_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yaŋ yoyɨŋban pi monjɨni kosit papmon kɨŋ amɨn aŋpakni tagɨ ae aŋpakni yokwi kɨsi pɨndak yoyɨŋba opba jap noknok yut madep uŋun yɨkba tugagɨt. ");
INSERT INTO yut_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Yɨgakwa kɨla amɨn madep da amɨn obeŋ uŋun pɨndat do yutnon wɨgɨgɨt. Wɨgɨ kaŋban amɨn kɨnda mɨŋat paŋek jap noknok aŋ bɨsapmon ɨmal tagɨsi paŋ uŋuden kɨnda dɨma pagɨt kagɨt. ");
INSERT INTO yut_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kaŋek yaŋ iyɨgɨt, ‘Not, gak nidosi mɨŋat pakpak bɨsap madep dakon ɨmal tagɨsi dɨma paŋek ɨdon wɨl?’ Yaŋ iyɨŋban amɨn uŋun geni mɨni yɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Geni mɨni yɨgakwan amɨn madep da pi monjɨni yaŋ yoyɨgɨt, ‘Ji on amɨn abɨdaŋek kɨsit kandapmɨyo wamaŋ waŋga abɨgɨ maba pɨlɨn tukgwan pɨgɨsak. Uŋudon kunam tagek iyoŋ iyoŋ yaŋ tɨdaŋek egɨpdɨsak.’ ” ");
INSERT INTO yut_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu uŋun tɨlak gen yoyɨŋ mudaŋek yaŋ yagɨt, “Amɨn yaŋ yobi uŋun da morapmɨsi asak, mani yutnon amɨn tagɨ gat yɨtni do kokwinɨkbi uŋun da tagapmɨ.” ");
INSERT INTO yut_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Parisi amɨn dɨwarɨ da kɨŋ Yesu suŋ kɨnda yaŋban nandaŋek gen pikon yɨpneŋ yaŋ do gen paŋkosit awit. ");
INSERT INTO yut_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Aŋek iyɨ dakon paŋdetni gat ae Erot da kabɨkon amɨn dɨwarɨ gat yabekba kɨŋ Yesu yaŋ iyɨwit, “Yoyɨŋdet, gak gen bamɨ yogok amɨn kɨnda yaŋ nandamaŋ. Gak amɨn do dɨma pasoldol. Amɨn mani toŋ ae mani mɨni uŋun kɨsi Piŋkop dakon aŋpak yoyɨŋ dek mudosol. ");
INSERT INTO yut_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gak niaŋ nandɨsal? Sisa do takis ɨmno tagɨ asak?” ");
INSERT INTO yut_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yaŋ yaŋba Yesu da niaŋon da nak abɨŋ nep do nandaŋ kokwin aŋ uŋun pɨndak mudaŋek yaŋ yoyɨgɨt, “Jamba but amɨn ji nak nido aŋkewalgaŋ? ");
INSERT INTO yut_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Moneŋ tabɨlɨ kɨnda takis do yɨpmaŋgaŋ kɨnda aŋobɨŋ naba koko.” Yaŋ yaŋban moneŋ tabɨlɨ kɨnda aŋobɨŋ ɨba ");
INSERT INTO yut_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","yaŋ yoyɨgɨt, “On wup gat ae man mandabi gat uŋun namɨn dakon?” ");
INSERT INTO yut_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yaŋban yaŋ iyɨwit, “Sisa dakon.” Yaŋ yaŋba Yesu da yaŋ yoyɨgɨt, “Yo Sisa dakon uŋun Sisa iyɨ do ɨmdo, ae yo Piŋkop dakon uŋun Piŋkop iyɨ do ɨmdo.” ");
INSERT INTO yut_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yesu da gen uŋun yaŋban nandaba ŋwakŋwarɨsi aban yɨpmaŋ kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Uŋun gɨldaron gɨn Sadyusi amɨn dɨwarɨ da Yesukon apgwit. (Sadyusi amɨn kabɨ amɨn kɨmakbi dɨma pɨdoŋ yaŋ nandaŋ.) Abɨŋek yaŋ iyɨwit, ");
INSERT INTO yut_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Yoyɨŋdet, Moses da gen kɨnda yaŋ mandagɨt, ‘Amɨn kɨnda monji mɨni da kɨmagakwan mɨŋatni ɨsal egɨpjak kaŋ, padɨge da paŋakwan yawi dɨwatni dɨma pasɨlni yaŋ do monjɨ paŋalasak.’ ");
INSERT INTO yut_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nin da bɨkbɨgon peni padɨgeyo 7 kabɨ egɨpgwit. Mibɨltok nani uŋun mɨŋat paŋek monjɨ mɨni egek kɨmakban padɨge da kwabatni pagɨt. ");
INSERT INTO yut_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Paŋek uŋunyo kɨsi monjɨ mɨni egek kɨmakgɨt. Ae uŋun da buŋon nani kɨsi yaŋ gɨn agɨt. Yaŋ aŋakwa amɨn 7 kabɨ uŋun kɨsi kɨmak mudawit. ");
INSERT INTO yut_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kɨmak mudaŋakwa mɨŋat uŋun don kɨmakgɨt. ");
INSERT INTO yut_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Wɨli 7 kabɨ kɨsi da pawit, do amɨn da kɨmoron da pɨdoni bɨsap madepmon namɨn dakon mɨŋatni asak?” ");
INSERT INTO yut_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yaŋba Yesu da yaŋ yoyɨgɨt, “Ji Piŋkop da papiakon gen tosok uŋun dɨma nandaŋ. Ae Piŋkop dakon tapmɨmni uŋun kɨsi dɨma kaŋ nandaŋ yo aŋek ji gen gulusuŋ yoŋ. ");
INSERT INTO yut_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pɨdot pɨdot bɨsap madepmon mɨŋat wɨliyo agak dɨma tokdɨsak. Aŋelo Kwen Kokup ɨsal ekwaŋ uŋun da tɨlagon egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ji kɨmoron da pɨdot pɨdot dakon mibɨlɨ pakyaŋsi dɨma nandaba pɨsosok. Piŋkop da uŋun do kɨlɨ dayɨgɨt. Ji dɨma manjɨŋ nandaŋ, ma? Yaŋ yagɨt: ");
INSERT INTO yut_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nak Abraham, Aisak, ae Jekop dakon Piŋkopni.’ Piŋkop uŋun amɨn kɨmakbi dakon Piŋkop dɨma, amɨn egɨp egɨpmɨ toŋ uŋun dakon Piŋkop.” ");
INSERT INTO yut_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yesu da gen uŋun yaŋban nandaŋek mɨŋat amɨn kabɨ madepsi da yoyɨŋdet uŋun agɨt do tamtam yawit. ");
INSERT INTO yut_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sadyusi amɨn da Yesu aŋkewal do iyɨŋba gen tagɨsi yaŋakwan kobogɨ iyɨk do dɨma nandawit. Parisi amɨn da uŋun nandaŋek Yesukon opgwit. ");
INSERT INTO yut_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Obɨŋ gen teban dakon mibɨlɨ nandak nandak amɨni kɨnda da Yesu aŋkewalek yaŋ iyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Yoyɨŋdet, ni gen teban da gen teban morap kɨsi yapmaŋ mudosok?” ");
INSERT INTO yut_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yaŋban Yesu da yaŋ iyɨgɨt, “Ji Amɨn Tagɨ Piŋkopji uŋun but gat ae nandak nandak gat kɨsisi paregek but dasi galak taŋ ɨmɨŋek egɨpni. ");
INSERT INTO yut_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Gen teban on da gen teban dɨwarɨ yapmaŋ mudosok. ");
INSERT INTO yut_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ae uŋun da buŋon nani mibɨltok yosok uŋun yombem gɨn. Uŋun yaŋ yosok: Gaga do but dasi niaŋ galak tosol, uŋudeŋ gɨn amɨn do but dasi galak taŋ yobi. ");
INSERT INTO yut_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","On gen teban bamot da gen teban dɨwarɨ gat ae kombɨ amɨn dakon gen morap kɨsi tɨmɨkgamal.” ");
INSERT INTO yut_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisi amɨn sigɨn egakwa Yesu da yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ji Kristo do namɨn dakon monjɨ yaŋ nandaŋ?” Yaŋban yaŋ iyɨwit, “Dewit dakon monji.” ");
INSERT INTO yut_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yaŋ yaŋba Yesu da yoyɨgɨt, “Yaŋ kaŋ nido Telagɨ Wup da Dewit aŋpulugaŋakwan Kristo do ‘Amɨn Tagɨ’ yaŋ iyɨgɨt? Dewit uŋun yaŋ yagɨt: ");
INSERT INTO yut_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Piŋkop da nak dakon Amɨn Tagɨ yaŋ iyɨgɨt, “Gak abɨŋ nak da amɨnsi tet do yɨkbɨ don uwalgo kandap gɨbaŋgogwan yopbo gengo guramɨtni.” ’ ");
INSERT INTO yut_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dewit da Kristo Amɨn Tagɨno yaŋ iyɨgɨt. Uŋun do niaŋon da Kristo uŋun Dewit dakon Amɨn Tagɨni ae monji kɨsi egɨsak?” ");
INSERT INTO yut_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yaŋ yaŋakwan amɨn kɨnda da gen kobogɨ kɨnda dɨma iyɨwit. Ae uŋun bɨsapmon gɨn wasaŋek Yesu gen iyɨk do pasalgwit. ");
INSERT INTO yut_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesu da mɨŋat amɨn kabɨ madepsi gat iyɨ dakon paŋdet kabɨni gat yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Gen teban yoyɨŋdet amɨn gat ae Parisi amɨn gat da kalɨp Moses da man madepni gat yɨgek gen teban yoyɨŋ dekgɨt uŋudeŋ gɨn dayɨŋ dekgaŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yaŋdo, gen morap dayɨŋ dekgaŋ uŋun kɨsi guramɨk mudoni. Mani gen dayaŋ uŋun iyɨ dɨma guramɨkgaŋ, do aŋpak aŋ uŋun dɨma yolni. ");
INSERT INTO yut_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Uŋun da gen teban mibɨlɨ mibɨlɨ jɨgɨsi guramɨtni do dayaŋ, mani iyɨ paŋpulugaŋba guramɨtni do kɨsitjok kɨnda dɨmasi yɨpmaŋgaŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Yo morap aŋ uŋun amɨn da pɨndatni yaŋ do aŋ. Piŋkop dakon gen sop sɨmɨl sɨmɨl kɨnam madepsi ɨŋamɨkon wamaŋgaŋ, ae ɨmalnikon nap tɨlɨmɨ toŋ dubagɨsi uŋun baŋ paŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Jap noknok tamokon ae muwut muwut yutnikon amɨn mani toŋ da yɨkgaŋ tamokon yɨt do galak toŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Aŋek amɨn da maket tamokon ‘Yoyɨŋdet, gɨldat tagɨ’ yaŋ yoyɨni yaŋ do galak toŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ji dakon Yoyɨŋdetji kaloŋɨ kɨnda dagɨn egɨsak, do amɨn da ji gawak damɨŋek ‘Yoyɨŋdet’ yaŋ dɨma dayɨni. Ji kɨsi morap not dagɨn ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Datji kaloŋɨ uŋun Kwen Kokup egɨsak, do mɨktɨm amɨn kɨnda do dat yaŋ dɨma iyɨni. ");
INSERT INTO yut_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ae ji dakon Madepji kaloŋɨ uŋun Kristo, do amɨn kɨnda do gawak ɨmɨŋek madepno yaŋ dɨma iyɨni. ");
INSERT INTO yut_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ji da binapmon mibɨltok amɨnji ekwaŋ uŋun oman amɨnji egɨ damni. ");
INSERT INTO yut_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Amɨn kɨnda iyɨ do nandaban wɨgɨsak amɨn uŋun mani mɨni da egɨpdɨsak, aŋakwan amɨn kɨnda iyɨ do nandaban pɨsak amɨn uŋun mani toŋ da egɨpdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Yesu da saŋbeŋek yaŋ yoyɨgɨt, “Gen teban yoyɨŋdet amɨn ae Parisi amɨn, ji jamba but amɨnsi. Awa! Piŋkop da Amɨn Kɨla Asak da kagagwan pɨgɨk do aŋ amɨn ji da kosit sopmaŋ yomaŋ. Yaŋ aŋek dɨsiyo kɨsi uŋungwan dɨma pɨkwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Gen teban yoyɨŋdet amɨn ae Parisi amɨn ji jamba but amɨnsi. Awa! Ji amɨn kaloŋɨ kɨnda da paŋdetji dagosak do pi teban aŋek tap kwenon da mɨktɨmɨ mɨktɨmɨ akwaŋ. Ji Tɨpdom do amɨn aŋ, do amɨn kɨnda abɨdoni kaŋ, iyɨŋ dekba uŋun amɨn yaŋ gɨn Tɨpdom do amɨn akdɨsak. Ae uŋun gɨn dɨma, ji da aŋpak yokwi aŋ uŋun si yapmaŋek uŋun amɨn aŋpak yokwisi asak. ");
INSERT INTO yut_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kosit yolɨk amɨn, ji dabɨlji mɨni da ekwaŋ. Awa! Ji yaŋ yoŋ: ‘Amɨn kɨnda da Piŋkop dakon Telagɨ Yut Madep do yaŋek geni yaŋ aŋteban aŋek ae don tagɨ kɨrɨŋɨtjak. Mani amɨn kɨnda da telagɨ yut dakon gol do yaŋek geni yaŋ aŋteban asak kaŋ, tagɨ dɨma kɨrɨŋɨtjak.’ ");
INSERT INTO yut_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ji nandaŋ kokwinji mɨni, dabɨlji mɨni. Yo ni da Piŋkop da dabɨlon yo madep asak? Gol yutgwan toŋ uŋun bo ae Telagɨ Yut Madep? Nandani, gol telagɨ yutgwan toŋ do telagɨ yut da aban telagɨ asak. ");
INSERT INTO yut_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ae kɨnda yoŋ uŋun yaŋ: ‘Amɨn kɨnda da alta do yaŋek geni yaŋ aŋteban asak kaŋ, tagɨ kɨrɨŋɨtjak. Mani amɨn kɨnda da altakon paret toŋ do geni yaŋ aŋteban asak kaŋ, tagɨ dɨma kɨrɨŋɨtjak.’ ");
INSERT INTO yut_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ji dabɨlji mɨni. Yo ni da Piŋkop da dabɨlon yo madep asak? Paret altakon toŋ uŋun bo ae alta? Nandani, paret altakon toŋ do alta da aban telagɨ asak. ");
INSERT INTO yut_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yaŋdo, amɨn kɨnda alta do yaŋek geni yaŋ aŋteban asak kaŋ, alta gat ae yo morap altakon toŋ uŋun kɨsi do yaŋek geni yaŋ aŋteban asak. ");
INSERT INTO yut_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ae amɨn kɨnda Piŋkop dakon telagɨ yut do yaŋek geni yaŋ aŋteban asak kaŋ, telagɨ yut gat ae Piŋkop yutnikon egɨsak uŋun gat kɨsi do yaŋek geni yaŋ aŋteban asak. ");
INSERT INTO yut_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ae amɨn kɨnda Kwen Kokup do yaŋek geni yaŋ aŋteban asak kaŋ, Piŋkop dakon kɨla amɨn madep yɨtyɨt tamo gat ae Piŋkop iyɨ tamonikon yɨkdak uŋun gat kɨsi do geni yaŋ aŋteban asak. ");
INSERT INTO yut_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Gen teban yoyɨŋdet amɨn ae Parisi amɨn ji jamba but amɨnsi. Awa! Ji jap tam galagɨsi pi kagasi toŋ uŋun paŋ kabi 10 kabɨ kokwinɨgek uŋudon baŋ kabi kɨndanaŋ Piŋkop do paret tagɨ aŋ. Mani gen tebanon gen madep madep toŋ uŋun yapmaŋ mudoŋ. Amɨnon gen kokwin kɨlegɨ ani do yosok, ae amɨn bupmɨ nandaŋ yomni do yosok, ae nandaŋ gadat dakon bamɨ aŋpak jikon noman tosak do yosok. Ji uŋun dɨma aŋ. Gen tebanon gen madep madep toŋ uŋun guramɨk mudaŋek paret do yosok uŋun kɨsi guramɨtni kaŋ uŋun tagɨsi. ");
INSERT INTO yut_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kosit yolɨk amɨn, ji dabɨlji mɨni da ekwaŋ. Ji dakon tɨlak uŋun yaŋ. Amɨn da pakbi nok do aŋek yo monɨŋ pakbikon toŋ uŋun pɨndak maba kɨŋakwa pakbi noŋ, mani kamel madep dɨma noknogɨ uŋun dɨma kaŋek kaloŋ galaukba pɨgɨsak. ");
INSERT INTO yut_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Gen teban yoyɨŋdet amɨn ae Parisi amɨn ji jamba but amɨnsi. Awa! Ji kap ɨdapyo dakon manji sugoŋ, mani burɨgwan da kabo ae sukwap nandak nandakyo tugawit da toŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Parisi dabɨlɨ mɨni amɨn, ji mibɨltok kap dakon burɨ ɨkdɨgoni kaŋ, manji iyɨ tagɨ kɨlek tosak. ");
INSERT INTO yut_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Gen teban yoyɨŋdet amɨn ae Parisi amɨn ji jamba but amɨnsi. Awa! Ji amɨn kɨmakba yopmaŋgaŋ tɨp kɨnam yombem. Kwen da kwak soŋbi do kwakwagɨ tagɨsi asak. Mani mɨkgwan amɨn kɨdat gat ae yo garagɨ tɨgɨ morapmɨ toŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jiyo kɨsi yaŋ gɨn ekwaŋ. Amɨn da dandaba ji amɨn kɨlegɨsi ekwaŋ yaŋ nandaŋ, mani butjikon ji jamba but amɨnsi ae gen teban yapyap amɨnsi ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Gen teban yoyɨŋdet amɨn ae Parisi amɨn ji jamba but amɨnsi. Awa! Ji kombɨ amɨn ae amɨn kɨlegɨ kalɨpsi egɨ kɨmakba yopgwit tamo paŋtɨlɨm aŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aŋek yaŋ yoŋ, ‘Nin kalɨpsi babɨknin da bɨsapmon egɨpgumaŋ tam, nin paŋpulugaŋek kombɨ amɨn dɨma dapnom.’ ");
INSERT INTO yut_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Gen yaŋ yaŋakwa ji kombɨ amɨn dapdap dakon babɨkni yaŋsi nandaŋ damamaŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Do ji kɨŋ babɨkji da wasaŋek aŋpak yokwi awit uŋun aŋ mudoni. ");
INSERT INTO yut_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ji tuŋon amɨn emarɨ toŋ dakon gwakni kabɨ. Piŋkop da ji yaŋ dagaŋ depban Tɨpdom do amɨn aŋakwa namɨn da pulugaŋ depjak? ");
INSERT INTO yut_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Do yaŋ dayɨsat, nak da kombɨ amɨn ae nandak nandak amɨn ae yoyɨŋdet amɨn yabekgo jikon apdaŋ. Apba ji da uŋun amɨn dɨwarɨ yolba pasal kokupmɨ kokupmɨ kɨkdaŋ. Aŋakwa dɨwarɨ tɨmɨgek dapba kɨmotdaŋ, ae dɨwarɨ tɨlak kɨndapmon dapdaŋ, ae dɨwarɨ muwut muwut yutjikon nap kɨrɨŋbaŋ baljokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yaŋ do aŋek on mɨktɨmon amɨn kɨlegɨ morap dapba kɨmakgwit uŋun dakon kobogɨ ji da tɨmɨtdaŋ. Wasok wasok do amɨn kɨlegɨ Abel aŋagek ae amɨn kɨlegɨ morapmɨ kɨsi dapgwit. Egɨ wɨgɨ wasɨp do ji da Berekia dakon monji Sekaraia Telagɨ Yut Madep ae altayo da binapmon aŋakba kɨmakgɨt. Uŋun dakon kobogɨ yo jɨgɨsi ji da tɨmɨtdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nak asisi dayɨsat, abɨsok amɨn ekwaŋ ji da uŋun dakon kobogɨ yo jɨgɨsi tɨmɨtdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Jerusalem, Jerusalem amɨn, ji kombɨ amɨn dapba kɨmokgoŋ. Amɨn Piŋkop da yabekban jikon abaŋ uŋun ji da tɨpbaŋ dapba kɨmokgoŋ. Pup meŋi da monjini paŋmuwuk pɨrɨgwan yopmaŋdak, uŋun da tɨlak nak da bɨsap morapmɨ ji paŋmuwut do nandagɨm, mani ji da kurak taŋ namgwit. ");
INSERT INTO yut_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nak asisi dayɨsat, kokup yomasiyo yokwi taŋek yumsi tokdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ji nak dɨma nandaŋek egɨ wɨgɨ ni bɨsapmon nak do ‘Amɨn on Amɨn Tagɨ da manon abɨsak, uŋun Piŋkop da gɨsamɨgakwan abɨsak’ yaŋ nak do yoni uŋun bɨsapmon nandakdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu Telagɨ Yut Madep dakon nagal yɨpmaŋek waŋga kɨŋakwan paŋdetni da Yesukon kɨŋek Telagɨ Yut Madep dakon yut madep madep pɨndatjak do yolɨwit. ");
INSERT INTO yut_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yolɨŋba Yesu da yaŋ yoyɨgɨt, “On yut madep madep pɨndakgaŋ uŋun dakon tɨp notni da kwenon dɨma taŋ taŋ akdaŋ. Tuwɨlba kɨsisi maŋ mudokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu Ɨleŋ Olipmon yɨgakwan paŋdetni da iyɨ gɨn kɨŋ yaŋ iyɨwit, “Gen uŋun niyɨl uŋun ni bɨsapmon altokdaŋ? Ninaŋ kaŋek gak aego tobɨl abɨŋaki on mɨktɨm dakon bɨsap mudokdɨsak yaŋ nandaneŋ?” ");
INSERT INTO yut_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yaŋ yaŋba Yesu da yoyɨgɨt, “Amɨn da paŋkewalni do kaŋ kɨmotni. ");
INSERT INTO yut_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Amɨn morapmɨ da abɨŋ nak dakon man yaŋek yaŋ yokdaŋ, ‘Nak naga Kristo.’ Yaŋ yaŋek amɨn morapmɨ paŋkewaldaŋ. ");
INSERT INTO yut_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Uŋun bɨsapmon emat wuwɨk gat ae dubagɨkon emat aŋ uŋun dakon gen bin apba nandaŋek butji dɨma pasolni. Uŋun yo morap altokdaŋ, mani mɨktɨm da mudosak bɨsap madep kɨlɨ uŋun noman tosok yaŋ dɨma nandani. ");
INSERT INTO yut_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mɨktɨm kɨnda dakon amɨn da pɨdaŋba mɨktɨm kɨnda dakon amɨn gat emat wamdaŋ. Ae kɨla amɨn madep kɨnda dakon amɨn da pɨdaŋba kɨla amɨn madep kɨnda dakon amɨn gat emat wamdaŋ. Aŋakwa mɨktɨm dɨwarɨkon wudɨp akdaŋ. Ae amɨn da jap do madepsi aŋek dɨwarɨ da kɨmotdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mɨŋat monjɨ kwapmɨ toŋ da monjɨ altok do aŋakwa wasaŋek tepmɨ paŋ, yaŋ gɨn uŋun yo morap altaŋakwa bɨsap madep kwaŋ tosok yaŋ nandani. ");
INSERT INTO yut_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Uŋun bɨsapmon amɨn da ji tɨmɨgek tepmɨ damɨŋek dɨkba kɨmotdaŋ. Ae ji nak nolgaŋ do aŋek amɨn kɨsi morap da ji do butjap nandaŋ damdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Uŋun bɨsapmon amɨn morapmɨ nak nandaŋ gadaŋ namaŋ uŋun nandaŋ gadatni yopba wɨtdal kɨŋakwa notni do nandaba yokwi tok aŋek uwal da kɨsiron yopmaŋ yopmaŋ akdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Aŋakwa kombɨ amɨn toptopmɨ morapmɨ da altaŋek amɨn morapmɨ paŋkewalba nandaŋ yomɨŋek yoldaŋ. ");
INSERT INTO yut_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aŋakwa aŋpak yokwi da madepsi ɨreŋ taŋ aŋ aŋ kɨkdɨsak. Yaŋ aŋakwa amɨn morapmɨ da not do but dasi galak taŋ yomyom aŋpak yɨpba wɨtdal kɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mani amɨn morap tebaisi sigɨn agakwa wɨgɨ mibɨ bɨsapmon wɨgɨsak uŋun Piŋkop da pulugaŋ yopdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Amɨn da mɨktɨmɨ mɨktɨmɨ mɨŋat amɨnyo ekwaŋ uŋun Piŋkop da Amɨn Kɨla Asak dakon Gen Bin Tagɨsi yoyɨŋ mudaŋakwa bɨsap madep uŋun apdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesu da saŋbeŋek yaŋ yagɨt, “Yo wagɨl yokwisi kɨnda don Telagɨ Yut Madepmon akban kokdaŋ. Kombɨ amɨn Daniel da uŋun do kɨlɨ yagɨt.” (On gen manjɨsak amɨn uŋun da pakyaŋsi nandɨsak.) ");
INSERT INTO yut_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Uŋun bɨsapmon amɨn Judia mɨktɨmon egɨpni uŋun pasal kabapgwan tepmɨsi wɨgɨni. ");
INSERT INTO yut_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Amɨn kɨnda yut kwenon egɨpjak kaŋ, yo kabɨni tɨmɨt do yutgwan pɨgɨk do nandak nandak dɨmasi asak. ");
INSERT INTO yut_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ae amɨn kɨnda pigaga egɨpjak kaŋ, yutnon ɨlɨkba pɨgɨkni kɨŋ abɨdok do nandak nandak dɨmasi asak. ");
INSERT INTO yut_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Uŋun bɨsapmon mɨŋat monjɨ kwapni toŋ, ae mɨŋat monjɨ mum noŋ uŋun bupmɨsi. ");
INSERT INTO yut_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ji da Piŋkop bɨsit iyɨŋba nandaŋakwan yo uŋun ais bɨsapmon bo Sabat bɨsapmon dɨma noman toni. ");
INSERT INTO yut_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Uŋun bɨsapmon yo jɨgɨsi altokdaŋ. Piŋkop da mibɨlɨkon yo morap wasagɨron da egɨ abɨsok ekwamaŋon yo jɨgɨsi uŋuden kɨnda dɨma altagɨt, ae buŋon dɨma altokdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Amɨn Tagɨ da uŋun bɨsap dɨma aŋpɨsɨp asak tam mɨŋat amɨn morap kɨsi kɨmak mudonom. Mani mɨŋat amɨn kabɨ iyɨ do kɨlɨ manjɨgɨt uŋun do bupmɨ nandaŋek bɨsap aŋpɨsɨp asak. ");
INSERT INTO yut_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Uŋun bɨsapmon amɨn kɨnda da ‘Kristo oni!’ bo ‘Asoni!’ yaŋ yaŋban kaŋ, top yosok yaŋ nandani. ");
INSERT INTO yut_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Amɨn dɨwarɨ da abɨŋ ‘Nak Kristo’ yaŋ top yokdaŋ. Ae dɨwarɨ da ‘Nak kombɨ amɨn kɨnda’ yaŋ top yokdaŋ. Yaŋ yaŋek wasok tapmɨmɨ toŋ mibɨlɨ mibɨlɨ akdaŋ. Aŋek mɨŋat amɨn kabɨ Piŋkop da iyɨ do kɨlɨ manjɨkbi uŋun paŋkewal do pini madep akdaŋ. Mani arɨpmɨ dɨma paŋkewaldaŋ. ");
INSERT INTO yut_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“Nandani, yo jɨgɨsi morap uŋun dɨma altaŋakwa mibɨltok dayɨsat. ");
INSERT INTO yut_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","Mal da gɨldat wɨsak tetgɨn da teŋteŋaŋ kɨŋ gɨldat pɨgɨsak tetgɨn noman taŋban komaŋ, uŋun da tɨlak Amɨn Dakon Monji uŋun apban amɨn kɨsi da kokdaŋ. Do amɨn kɨnda da ‘Kristo uŋun mɨktɨm kɨbɨrɨ amɨn da arɨpmɨ dɨma egɨpmɨ tɨmon egɨsak!’ yaŋ dayɨŋban kaŋ, uŋudon dɨma kɨni. Bo amɨn kɨnda da ‘Kristo yut uŋudon pasɨlek egɨsak!’ yaŋ dayɨŋban kaŋ, top yosok yaŋ nandani. ");
INSERT INTO yut_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Yo kɨmakbi da toŋ sɨŋgɨŋ uŋudon abɨŋ muwukgaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesu da saŋbeŋek yaŋ yagɨt, “Yo jɨgɨ dakon bɨsap mudaŋakwan, ‘Gɨldat dabɨl pɨlɨn tuk akdɨsak, ae kanek dɨma teŋteŋokdɨsak. Ae gɨk kundu yɨpmaŋek mokdaŋ. Aŋakwa kwen kundukon yo tebai toŋ uŋun da kwakwalɨtdaŋ.’ ");
INSERT INTO yut_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Uŋun bɨsapmon Amɨn Dakon Monji dakon tɨlak kundukon altaŋban kaŋek mɨktɨmɨ mɨktɨmɨ amɨn kɨsi morap da kunam tatdaŋ. Kaŋakwa Amɨn Dakon Monji tapmɨmni gat ae tɨlɨm madepni gat gɨkwemon da apban kokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kweŋ madepsi da yaŋakwan aŋelo kabɨni yabekban kɨŋ amɨn iyɨ do manjɨkbi kabɨ mɨktɨmɨ mɨktɨmɨ ekwaŋ uŋun paŋmuwutdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yesu da saŋbeŋek yaŋ yagɨt, “Ji pik kɨndap kaŋek butji pɨsosak. Kɨlɨŋɨ pakbini toŋ ae tamɨ kaluk yopmaŋdak, uŋun bɨsapmon gɨldat bɨsap kwaŋ tosok yaŋ nandaŋ. ");
INSERT INTO yut_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Uŋudeŋ gɨn yo morap dayɨt uŋun da altaŋakwa mɨktɨm da mudosak bɨsap madep kɨlɨ uŋunjok kwaŋ tosok yaŋ nandani. ");
INSERT INTO yut_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Nak asisi dayɨsat, uŋun bɨsapmon egɨpni amɨn dɨma kɨmagakwa yo morap uŋun kɨsi altaŋ mudokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kundu gat mɨktɨm gat pasɨldamal, mani nak dakon gen uŋun dɨmasi pasɨldɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yesu da saŋbeŋek yaŋ yagɨt, “Yo morap altosak uŋun dakon bɨsap uŋun amɨn kɨnda da dɨma nandɨsak. Kwen Kokup aŋeloyo dɨma nandaŋ, ae Monjɨyo kɨsi dɨma nandɨsak. Dat da iyɨ gɨn nandɨsak. ");
INSERT INTO yut_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noa da bɨsapmon amɨn egɨpgwit uŋudeŋ gɨn Amɨn Dakon Monji apjak bɨsapmon yaŋ gɨn egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kulup madep dɨma altaŋakwan jap pakbiyo aŋek mɨŋat pakpak awit. Yaŋ aŋek egakwa Noa tap wakgakon wɨgɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wɨgakwan yo jɨgɨ altaŋ nimdaŋ uŋun dɨma nandawit. Butni dɨma pɨsaŋakwa kulup madep da altaŋek wutjɨŋban pasɨlgwit. Amɨn yaŋ gɨn egakwa Amɨn Dakon Monji apdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Amɨn bamorɨ pigaga egakwal Piŋkop da kɨnda yapmaŋek kɨnda abɨdokdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mɨŋat bamorɨ da plaua wasaŋek yɨgakwal kɨnda yapmaŋek kɨnda abɨdokdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Yaŋdo, kaŋ kɨmotni. Amɨn Tagɨsi ni gɨldaron apdɨsak uŋun ji dɨma nandaŋ. ");
INSERT INTO yut_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nandaŋ pɨsoni. Yut kɨnda dakon ami kalbi kabo noknok ni bɨsapmon apdɨsak yaŋ nandagɨt tam, kɨla aŋakwan yutni arɨpmɨ dɨma tuwɨlban. ");
INSERT INTO yut_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Dɨma apdɨsak yaŋ nandaŋek egakwa Amɨn Dakon Monji uŋudon apdɨsak. Yaŋdo, ji tagap taŋek egɨpni.” ");
INSERT INTO yut_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu da saŋbeŋek yaŋ yagɨt, “Oman monjɨ kɨnda nandaŋ kokwini tagɨsi ae pi agakni tagɨsi, uŋuden oman monjɨ amɨn tagɨni da oman monjɨni dɨwarɨ kɨlani asak do manjɨsak. Yaŋ aban jap yomyom bɨsapmon japni yomɨŋ yomɨŋ asak. ");
INSERT INTO yut_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Oman monjɨ uŋun amɨn tagɨni da tobɨl abɨŋ kaŋban pini tagɨsi asak kaŋ tagɨsi. ");
INSERT INTO yut_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nak asisi dayɨsat, amɨn tagɨni da uŋun oman monjɨ iyɨŋban yo morapni kɨla akdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mani oman monjɨ kɨnda pi yokwi asak uŋun burɨkon da yaŋ nandɨsak, ‘Amɨn tagɨno uŋun tepmɨ dɨma apdɨsak.’ ");
INSERT INTO yut_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yaŋ nandaŋek oman monjɨ notni dapmaŋek pakbi teban naŋek but upbal aŋ amɨn gat muwugek jap pakbiyo aŋ. ");
INSERT INTO yut_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Yaŋ aŋek dɨma apdɨsak yaŋ nandaŋakwan amɨn tagɨni da but pɨsogɨ mɨni apdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Abɨŋek uŋun oman monjɨ tepmɨ pi ɨmɨŋek yɨpban jamba but amɨn gat kunam tagek iyoŋ iyoŋ yaŋ tɨdaŋek egɨpdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu da saŋbeŋek yaŋ yagɨt, “Uŋun bɨsap madepmon Piŋkop dakon Amɨn Kɨla Agakni dakon tɨlak kɨnda uŋun yaŋ. Amɨn kɨnda mɨŋat pak do agɨt. Aŋakwan mɨŋat uŋun pakdɨsak dakon notni mɨŋatjok 10 kabɨ da lamni tɨmɨgek kosiron kɨŋ wɨli uŋun kaŋ abɨdaŋ aŋop do kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mɨŋatjok 5 kabɨ uŋun nandaŋ kokwini tagɨ dɨma, ae 5 kabɨ uŋun nandaŋ kokwini tagɨsi. ");
INSERT INTO yut_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mɨŋatjok nandaŋ kokwini tagɨ dɨma uŋun lamni tɨmɨgek lam kolek do pakbi dɨ gat dɨma paŋkɨwit. ");
INSERT INTO yut_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mani mɨŋatjok nandaŋ kokwini tagɨsi uŋun lamni tɨmɨgek lam kolek do pakbi dɨ gat kɨsi tɨmɨgek kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kɨŋ jomjom aŋ egakwa amɨn uŋun tepmɨ dɨma abɨŋakwan dɨpmɨni wɨŋba dɨpmɨn pak mudawit. ");
INSERT INTO yut_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pak mudaŋakwa kalbi binap aban amɨn kɨnda yaŋ tɨdaŋek yaŋ yagɨt, ‘Amɨn mɨŋat pak do asak kɨlɨ uŋun abɨsak! Opba kɨŋ abɨdono!’ ");
INSERT INTO yut_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Yaŋ yaŋban mɨŋatjok kɨsi pɨdaŋ lamni paŋkosit ");
INSERT INTO yut_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","aŋakwa mɨŋatjok nandaŋ kokwini tagɨ dɨma uŋun da mɨŋatjok nandaŋ kokwini tagɨsi yaŋ yoyɨwit, ‘Nin do pakbi dɨwatji nimgut, lamnin kɨmotdaŋ.’ ");
INSERT INTO yut_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Yaŋba nandaŋ kokwini tagɨsi da yaŋ yoyɨwit, ‘Pakbi on nin kɨsi da arɨpmon dɨma toŋ. Ji kɨŋ yumaŋ nok yutnon pakbi yumni.’ ");
INSERT INTO yut_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Kɨŋakwa amɨn mɨŋat pak do agɨt uŋun apgut. Apban mɨŋat tagap taŋek egɨpgwit uŋun gat soŋnok ak do yutnon wɨgakwa yoma sopgwit. ");
INSERT INTO yut_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Buŋon don mɨŋat kabɨ pakbi do kɨwit uŋun abɨŋ yawit, ‘Amɨn tagɨ, amɨn tagɨ, abɨŋ yoma wɨtdal nim!’ ");
INSERT INTO yut_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Mani amɨn tagɨ da gen kobogɨ yaŋ yoyɨgɨt, ‘Nak asisi dayɨsat, nak dɨmasi nandaŋ damɨsat.’ ” ");
INSERT INTO yut_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu da tɨlak gen uŋun yaŋ mudaŋek yaŋ yoyɨgɨt, “Amɨn Tagɨsi altaŋ damjak uŋun dakon bɨsap ji dɨma nandaŋ, do tagap taŋek egɨpni.” ");
INSERT INTO yut_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu da saŋbeŋek yaŋ yagɨt, “Piŋkop da Amɨn Kɨla Asak uŋun do tɨlak kɨnda ako mibɨlɨ nandani. Amɨn kɨnda kokup dubagɨ kɨndakon kɨk do aŋek pi monjɨni yaŋ yoban opba yo kabɨni kɨla ani do yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pi monjɨ kaloŋ kaloŋ dakon pi agakni da arɨpmon moneŋni kɨla ani do yomgut. Kɨnda do moneŋ 25 tausen danari, ae kɨnda do 10 tausen danari, ae kɨnda do 5 tausen danari yaŋ yomɨŋ mudaŋek kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kɨŋakwan uŋudon gɨn 25 tausen danari tɨmɨkgɨt amɨn uŋun yomɨŋ gwayek aŋakwan 25 tausen danari kɨnda gat noman tagɨt. ");
INSERT INTO yut_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ae 10 tausen danari tɨmɨkgɨt amɨn uŋunyo yaŋ gɨn aŋakwan 10 tausen danari kɨnda gat noman tagɨt. ");
INSERT INTO yut_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mani 5 tausen danari tɨmɨkgɨt amɨn uŋun kɨŋ gapma wayɨgek amɨn tagɨni dakon moneŋni gapmakon yopban ɨsal tawit. ");
INSERT INTO yut_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Amɨn tagɨni bɨsap dubagɨ egek aeni tobɨl apgut. Abɨŋ moneŋni yomgut uŋun dakon pini niaŋ awit uŋun dakon mibɨlɨ nandak do yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yoyɨŋban 25 tausen danari tɨmɨkgɨt amɨn uŋun da yomɨŋ gwayek aŋakwan 25 tausen danari kɨnda gat noman tagɨt uŋun yolɨŋek yaŋ iyɨgɨt, ‘Amɨn tagɨ, gak da 25 tausen danari kɨla akeŋ do namgul uŋun pini ako 25 tausen danari kɨnda gat oni noman tak.’ ");
INSERT INTO yut_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Yaŋ iyɨŋban amɨn tagɨ da yaŋ yagɨt, ‘Gak pi monjɨno gen guramɨt tagɨsi agɨl. Aŋek pigo dakon kɨla tagɨsi agɨl. Yo monɨŋɨsok gabo kɨla tagɨsi agɨl do yo madep gabo kɨla tagɨ aki. Gak apbɨ kɨsɨk kɨsɨk ando.’ ");
INSERT INTO yut_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ae 10 tausen danari tɨmɨkgɨt amɨn uŋun da abɨŋ yaŋ iyɨgɨt, ‘Amɨn tagɨ, gak da 10 tausen danari kɨla akeŋ do namgul uŋun pini ako 10 tausen danari kɨnda gat oni noman tak.’ ");
INSERT INTO yut_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Yaŋ iyɨŋban amɨn tagɨ da yaŋ yagɨt, ‘Gak pi monjɨno gen guramɨt tagɨsi agɨl. Aŋek pigo dakon kɨla tagɨsi agɨl. Yo monɨŋɨsok gabo kɨla tagɨsi agɨl, do yo madep gabo kɨla tagɨ aki. Gak apbɨ kɨsɨk kɨsɨk ando.’ ");
INSERT INTO yut_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ae 5 tausen danari tɨmɨkgɨt amɨn uŋun da abɨŋ yaŋ iyɨgɨt, ‘Amɨn tagɨ, gak dakon mibɨlgo nandɨsat, gak bupmɨgo mɨni. Amɨn ŋwakŋwarɨ da pi aŋakwa jap bamɨ gak da pasal, ae mɨktɨmon jap yet tɨŋtɨŋoŋ dakon bamɨ gaga do pasal. ");
INSERT INTO yut_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yaŋ asal, do pasalek moneŋgo 5 tausen danari namgul uŋun aŋkɨ mɨktɨm kagagwan yɨpbo tagɨt. Moneŋgo uŋun oni.’ ");
INSERT INTO yut_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Yaŋban amɨn tagɨni da gen kobogɨ yaŋ iyɨgɨt, ‘Gak oman monjɨ yokwi, pi ak do kurak tosol. Nak dakon mibɨlno kɨlɨ nandagɨl. Nak amɨn da pigaga jap bamɨ pasat, ae amɨn da jap yet tɨŋtɨŋoŋ dakon bamɨ naga do pasat. ");
INSERT INTO yut_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yaŋ nandagɨl, do moneŋno beŋon yopgul tam uŋun tagɨ. Yaŋ agɨl tam abɨŋ nak da moneŋno gat ae beŋ da dɨwarɨ saŋbesak uŋun gat tagɨ tɨmɨkgom.’ ");
INSERT INTO yut_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","29","“Amɨn yoni taŋ ɨmaŋ amɨn uŋun nak da saŋbeŋek yo ɨbo morapmɨsi taŋ ɨmdaŋ. Ae amɨn yoni kaloŋɨsok taŋ ɨmaŋ amɨn uŋun nak da uŋunjok gwayeŋ mudokeŋ. Yaŋdo, on amɨn moneŋni uŋun gwayeŋ moneŋ 50 tausen danari taŋ ɨmaŋ uŋun amɨn do ɨmni. ");
INSERT INTO yut_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aŋek on oman monjɨ kurak tok amɨn waŋga abɨgɨ maba pɨlɨn tukgwan pɨgɨsak. Uŋudon kunam tagek iyoŋ iyoŋ yaŋ tɨdaŋek egɨpdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesu da saŋbeŋek yaŋ yagɨt, “Amɨn Dakon Monji apjak bɨsapmon Kwen Kokup dakon tɨlɨmni gat ae aŋelo kabɨni gat abɨŋek kɨla amɨn madep yɨyɨt tamokon uŋudon yɨtdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yɨgakwan amɨn mɨktɨmɨ mɨktɨmɨ ekwaŋ uŋun abɨŋ burɨkon muwuk mudoni. Abɨŋ muwukba kɨla amɨn da sipsip ae meme kokwinɨkgaŋ uŋun da tɨlagon amɨn kokwinɨtdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kokwinɨgek sipsip amɨnsi tet do yopmaŋek meme gwandeŋ tet do yopdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Kɨla Amɨn Madep uŋun da amɨnsi tet do amɨn yaŋ yoyɨsak, ‘Datno da gɨsam dabi amɨn, abɨŋek Datno dakon Amɨn Kɨla Agakni ji do aŋnoman abi uŋun abɨŋek abɨdoni. Uŋun mɨktɨm wasok wasogɨkon ji do kɨlɨ aŋnoman agɨt da tosok. ");
INSERT INTO yut_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nak kalɨp jap do abo jap naba nagɨm, ae pakbi do abo pakbi naba nagɨm, ae kokup ŋwakŋwarɨkon da apbo but dasi abɨdaŋba yutjikon paŋkɨ egɨpgum. ");
INSERT INTO yut_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ɨmalno mɨni egapbo ɨmal namgwit. Sot abo aŋpulugawit. Dam teban yutnon yɨgapbo abɨŋ nandawit.’ ");
INSERT INTO yut_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Yaŋ yaŋban kɨlegɨ kabɨ da gen kobogɨ yaŋ iyɨni, ‘Amɨn Tagɨ, ni bɨsapmon jap do abɨ gandaŋek jap gamgumaŋ, ae ni bɨsapmon pakbi do asal yaŋ gandaŋek pakbi gamgumaŋ? ");
INSERT INTO yut_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ae ni bɨsapmon kokup ŋwakŋwarɨkon da abɨsal yaŋ gandaŋek aŋkɨ yutninon gepgumaŋ, ae ni bɨsapmon ɨmalgo mɨni yaŋ gandaŋek ɨmal gamgumaŋ? ");
INSERT INTO yut_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ae ni bɨsapmon sot asal yaŋ gandaŋek kɨlago agɨmaŋ, ae ni bɨsapmon dam teban yutnon yɨkdal yaŋ gandaŋek abɨŋ gandagɨmaŋ?’ ");
INSERT INTO yut_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Yaŋba Amɨn Madep da yaŋ yoyɨsak, ‘Asisi dayɨsat, yo morap notno kɨnda mani mɨni do awit uŋun yo morap nak do awit.’ ");
INSERT INTO yut_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Yaŋ yoyɨŋek Amɨn Madep uŋun da tobɨl gwandeŋ tet do amɨn yaŋ yoyɨsak, ‘Jobɨt pabi kabɨ ji aŋgwikon kɨŋek kɨndapmon pɨgɨt. Uŋun kɨndap uŋun Sunduk gat aŋelo kabɨni gat uŋun do aŋnoman abi, uŋun kɨmot kɨmorɨ mɨni. ");
INSERT INTO yut_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kalɨp jap do abo jap dɨma namgwit, ae pakbi do abo pakbi dɨma namgwit. ");
INSERT INTO yut_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kokup ŋwakŋwarɨkon da apbo yutjikon dɨma aŋkɨ nepgwit, ae ɨmalno mɨni egapbo ɨmal dɨma namgwit, ae sot agɨm ae dam teban yutnon yɨkgɨm bɨsapmon kɨlano dɨma awit.’ ");
INSERT INTO yut_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Yaŋ yaŋban gen kobogɨ yaŋ iyɨni, ‘Amɨn Tagɨ ni bɨsapmon gandano jap do agɨl, bo pakbi do agɨl, bo kokup ŋwakŋwarɨkon da apgul, bo ɨmalgo mɨni, bo sot agɨl, bo dam teban yutnon yɨkgɨl, abɨ dɨma aŋpulugagɨmaŋ?’ ");
INSERT INTO yut_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Yaŋba yaŋ yoyɨsak, ‘Nak asisi dayɨsat, yo morap amɨn mani mɨni do dɨma awit uŋun nak do awit.’ ");
INSERT INTO yut_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Yaŋ yoyɨŋban uŋun amɨn kabɨ kobogɨ yokwisi dagok dagogɨ mɨni pakdaŋ. Mani kɨlegɨ amɨn kabɨ uŋun da egɨp egɨp dagok dagogɨ mɨni uŋudon kɨkdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu uŋun gen morap yaŋ mudaŋek paŋdetni yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Dɨsi nandaŋ, gɨldat bamorɨ gɨn egek Yapyap Bɨlak egɨpmɨ. Uŋun bɨsapmon Amɨn Dakon Monji amɨn da abɨdaŋ uwal da kɨsiron yɨpba tɨlak kɨndapmon aŋatdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Uŋun bɨsapmon mukwa sogok amɨn dakon amɨn madep kabɨ gat ae Israel dakon kɨla amɨn uŋun mukwa sogok amɨn dakon mibɨltok amɨn Kaiapas uŋun da yutnon muwukgwit. ");
INSERT INTO yut_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Muwugek Yesu ni kosiron da pasɨlek abɨdaŋ aŋatno kɨmotjak uŋun dakon gen yawit. ");
INSERT INTO yut_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yaŋ yaŋek yawit, “Telagɨ bɨsap madepmon dɨma abɨdoneŋ. Yaŋ aneŋ kaŋ, mɨŋat amɨnyokon pɨdok pɨdok noman tokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu Betani kokupmon amɨn kɨnda mani Saimon uŋun da yutnon yɨkgɨt. (Saimon uŋun kalɨp wuda tebani toŋ egɨpgut.) ");
INSERT INTO yut_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesu jap noknok tamokon yɨgakwan mɨŋat kɨnda pakbi kɨbaŋɨ tagɨsi abɨdaŋ awɨŋ Yesu da busuŋon tagalgɨt. (Uŋun pakbi yumaŋ nogɨ wukwisi ae tɨbɨrɨ uŋun tɨpnaŋ wasaŋbi.) ");
INSERT INTO yut_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yaŋ aban paŋdet kabɨni da kaŋek burɨ yokwi taŋba yaŋ yawit, “Nidosi aŋek pakbi kɨbaŋɨ tagɨsi uŋun yumsi tagaldak? ");
INSERT INTO yut_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Amɨn da yubam tam, moneŋ madepsi tɨmɨk yoni mɨni amɨn do yomnom.” ");
INSERT INTO yut_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yaŋ yaŋba nandaŋek Yesu da yoyɨgɨt, “Mɨŋat on nido jɨgɨ ɨmaŋ? Mɨŋat on nak do yo tagɨsi asak. ");
INSERT INTO yut_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yoni mɨni amɨn ji gat bɨsapmɨ bɨsapmɨ egɨpdaŋ, mani nak ji gat bɨsapmɨ bɨsapmɨ dɨma egɨpdamaŋ. ");
INSERT INTO yut_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","On mɨŋat da mibɨltok gɨptɨmnokon pakbi kɨbaŋɨ tagɨsi naŋ soŋ namɨŋek kɨmakbi tamokon nepni do aŋtagap asak. ");
INSERT INTO yut_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Asisi dayɨsat, mɨktɨmɨ mɨktɨmɨ amɨn da Gen Bin Tagɨsi yoyɨŋek mɨŋat on da yo ak uŋun dakon gen bin kɨsi yoyɨŋakwa nandakdaŋ. Aŋakwa uŋun mɨŋat dakon man bini dɨma pasɨldɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Uŋun bɨsapmon paŋdetni 12 kabɨkon da kɨnda mani Judas Iskariot uŋun da mukwa sogok amɨn dakon amɨn madep kabɨkon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Kɨŋ yaŋ yoyɨgɨt, “Yesu kɨsitjikon yɨpbo ninaŋ namni?” Yaŋban silwa moneŋ tabɨlɨ 30 yaŋ manjɨŋ ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ɨba wasaŋek Yesu kɨsitnikon yɨpjak do kosit wɨsɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bret Yisni Mɨni Bɨlak wasok wasogɨkon paŋdetni da Yesukon kɨŋ yaŋ iyɨwit, “Nin kɨŋ dukwan Yapyap Bɨlak dakon jap paŋkosit aneŋ do nandɨsal?” ");
INSERT INTO yut_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yaŋba Yesu da yaŋ yoyɨgɨt, “Kokup papmon kɨŋ amɨn kɨnda kokdaŋ. Kaŋek yaŋ iyɨni: Yoyɨŋdet da yaŋ yosok, Nak dakon bɨsap kɨlɨ uŋun kwaŋ tosok. Nak gat paŋdet kabɨno gat gak da yutnon apno Yapyap Bɨlak dakon jap noneŋ.” ");
INSERT INTO yut_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yaŋban paŋdetni da Yesu dakon gen guramɨgek kɨŋ Yapyap Bɨlak dakon jap paŋkosit awit. ");
INSERT INTO yut_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yaŋ aŋek pɨlɨn taŋakwan Yesu gat paŋdetni 12 kabɨ gat yɨgek jap nawit. ");
INSERT INTO yut_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jap naŋ yɨgek Yesu da yaŋ yoyɨgɨt, “Asisi dayɨsat, jikon da kɨnda da uwal da kɨsiron nepdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yaŋ yaŋban paŋdetni burɨ yokwi taŋba kaloŋ kaloŋ yaŋ yawit, “Amɨn Tagɨ, nak do dɨma yosol, ma?” ");
INSERT INTO yut_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yaŋ yaŋba Yesu da yoyɨgɨt, “Kɨnda nak gat jap ɨdapmon kɨsitnit kaloŋɨ yɨpmaŋgamak, uŋun amɨn da nak uwalno da kɨsiron nepdɨsak. ");
INSERT INTO yut_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Asi Piŋkop da papiakon gen mandabi uŋun da tɨlagon Amɨn Dakon Monji kɨmoron kɨkdɨsak. Mani Amɨn Dakon Monji uwal da kɨsiron yɨpjak amɨn, awa! Uŋun amɨn meŋi da dɨma aŋalagɨt tam tagɨ.” ");
INSERT INTO yut_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yaŋ yaŋban uwal da kɨsiron yɨpyɨp amɨn Judas da Yesu yaŋ iyɨgɨt, “Yoyɨŋdet, nak do dɨma yosol, ma?” Yaŋban iyɨgɨt, “Uŋun gak mani.” ");
INSERT INTO yut_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jap naŋ yɨgakwa Yesu da bret kɨnda abɨdaŋ, Piŋkop ya yaŋ iyɨŋek, pudaŋ paŋdetni do yomgut. Yomɨŋek yaŋ yoyɨgɨt, “Pabɨdaŋek noni, on nak dakon gɨptɨm tɨmno.” ");
INSERT INTO yut_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yaŋ yaŋek wain kɨnam abɨdaŋek Piŋkop ya yaŋ iyɨŋek yomɨŋek yaŋ yagɨt, “Ji kɨsi da noni. ");
INSERT INTO yut_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","On yawino. Piŋkop gat amɨn gat saŋbek saŋbek abi uŋun aŋteban asak. Amɨn morapmɨ dakon dɨwarɨni yopmaŋ yom do parekdat. ");
INSERT INTO yut_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nak asisi dayɨsat, nak wain ae dɨma naŋek egɨ wɨgɨ Datno da Amɨn Kɨla Asak da kagagwan don ji gat wain kalugɨ noneŋ.” ");
INSERT INTO yut_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yaŋ yaŋban kap kɨnda yaŋek yomakon pɨgek Ɨleŋ Olipmon wɨgɨwit. ");
INSERT INTO yut_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ɨleŋ Olipmon wɨgek Yesu da paŋdetni yaŋ yoyɨgɨt, “Piŋkop da papiakon gen yaŋ tosok: ‘Sipsip dakon kɨla amɨn aŋakgo kɨmagakwan sipsip bɨrapmɨgɨ iyɨ iyɨ kɨkdaŋ.’ Gen uŋun da arɨpmon abɨsok kalbi yo morap nagon noman taŋakwa pɨndagek ji manji namdaŋ. ");
INSERT INTO yut_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mani kɨmoron da pɨdaŋek nak da kalɨp Galili mɨktɨmon mibɨltaŋ damɨŋek kɨkeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yaŋban Pita da yaŋ iyɨgɨt, “Amɨn dɨwarɨ da manji gamɨŋakwa nak yaŋ dɨmasi abeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yaŋ yaŋban Yesu da iyɨgɨt, “Asisi gayɨsat, abɨsok kalbi pup gen dɨma yaŋakwan gak da nak do ‘Uŋun amɨn dɨma nandaŋ ɨmɨsat’ yaŋ kosit kapbɨ yokdɨsal.” ");
INSERT INTO yut_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Yaŋban Pita da yaŋ iyɨgɨt, “Uwal da gɨkba kɨmagaki nakyo kɨsi nɨkba kɨmokgeŋ do ani kaŋ, gak do wasɨp dɨma yokeŋ.” Yaŋ yaŋban paŋdet kabɨ dɨwarɨ kɨsi yaŋ gɨn yawit. ");
INSERT INTO yut_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu gat paŋdetni gat mɨktɨm tɨm kɨnda mani Getsemani uŋudon kɨwit. Kɨŋ altaŋek Yesu da yaŋ yoyɨgɨt, “Ji ɨdon yɨgakwa nak asɨdon kɨŋ bɨsit akeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yaŋ yaŋek Pita gat ae Sebedi dakon monjɨ yat tɨmɨkban kɨwit. Kɨŋ burɨkon jɨgɨ madepsi nandaŋek ");
INSERT INTO yut_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","yaŋ yoyɨgɨt, “Butno jɨk taŋakwan kɨmot kɨmotno noman taŋ naban nandɨsat. Do ji nak gat kɨsi ɨdon Piŋkop do nandaŋek egɨpneŋ.” ");
INSERT INTO yut_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yaŋ yaŋek tɨmɨsok dɨ kɨŋek mɨktɨmon maŋ pagek bɨsit yaŋ agɨt, “O Dat, yo morap tagɨ aki. Do nak da kwenon jɨgɨ apdɨsak uŋun kukwoki do nandɨsat. Mani nak dakon nandak nandak dɨma yolgi. Gak dakon galak tok niaŋsi tosok uŋun dagɨn noman toni.” ");
INSERT INTO yut_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yaŋ yaŋek tobɨl paŋdetni kapbɨ egɨpgwiron kɨŋ pɨndakban dɨpmɨn pakgwit pɨndagek Pita yaŋ iyɨgɨt, “Ji nak gat awa kaloŋɨ da arɨpmon gɨn Piŋkop do nandaŋek dɨma egɨpneŋ? ");
INSERT INTO yut_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ji teban taŋek bɨsit aŋek egɨpni. Yaŋ aŋek egɨpni kaŋ, paŋkewalon arɨpmɨ dɨma mokdaŋ. But da nak nol do galak tosok mani gɨp dakon tapmɨmni mɨni.” ");
INSERT INTO yut_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yaŋ yaŋek aeni tobɨl kɨŋ bɨsit yaŋ agɨt, “Datno, jɨgɨ pakeŋdosi nandɨsal kaŋ, tagɨ pakeŋ.” ");
INSERT INTO yut_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Bɨsit aban dagaŋban abɨŋ pɨndakban paŋdetni dɨpmɨn do yokwisi aŋek aeni dɨpmɨn sigɨn pakgwit. ");
INSERT INTO yut_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yaŋ pɨndagek aeni tobɨl kɨŋ bɨsit mibɨltok agɨt uŋudeŋ gɨn agɨt. ");
INSERT INTO yut_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yaŋ aŋek tobɨl abɨŋ paŋdetni yaŋ yoyɨgɨt, “Ji dɨpmɨn sigɨn pagek tapmɨm paŋ, ma? Bɨsap kɨlɨ abɨk. Amɨn Dakon Monji yokwi pakpak da kɨsiron kɨlɨ uŋun yɨpmaŋgaŋ. ");
INSERT INTO yut_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pɨdaŋba kɨno! Kabɨt, uwal da kɨsiron nepjak amɨn kɨlɨ abɨk.” ");
INSERT INTO yut_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu gen yaŋakwan uŋudon gɨn paŋdetni 12 kabɨkon da kɨnda mani Judas altaŋ yomgut. Amɨn kabɨ madep emat agak sɨbani ae kɨndap kɨrɨŋni tɨmɨgek buŋon yolgwit. Mukwa sogok amɨn dakon amɨn madep kabɨ gat ae Juda amɨn dakon kɨla amɨn gat da yabekba opgwit. ");
INSERT INTO yut_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Uwal da kɨsiron yɨpyɨp amɨn da gen kɨnda kɨlɨ yaŋ yoyɨgɨt, “Amɨn kɨnda nak da mandaŋ noko kaŋ, uŋun amɨn naŋ tebai abɨdoni.” ");
INSERT INTO yut_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas tepmɨ Yesukon kɨŋ altaŋek yaŋ iyɨgɨt, “Yoyɨŋdet, kalbi tagɨsi!” Yaŋ iyɨŋek mandaŋ nagɨt. ");
INSERT INTO yut_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yaŋ aban Yesu da yaŋ iyɨgɨt, “Not, yo ak do nandaŋek abɨl uŋun abi.” Yaŋ iyɨŋban emat amɨn da Yesu tebai abɨdawit. ");
INSERT INTO yut_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aba Yesu da kabɨkon nani kɨnda da emat agak sɨbani ɨlɨkban wɨŋban mukwa sogok amɨn dakon mibɨltok amɨn dakon oman monjɨni mɨragɨ mandaŋ dagagɨt. ");
INSERT INTO yut_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aban Yesu da yaŋ yagɨt, “Gak emat agak sɨbago yɨgɨkon sɨmɨl. Emat agak sɨba pawɨlgaŋ amɨn uŋun emat agak sɨba da mandaŋ yoba kɨmokgoŋ. ");
INSERT INTO yut_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nak Datno arɨpmɨ tagɨ iyɨko uŋun da aŋelo 72 tausen yabekban abɨŋ nak tagɨ aŋpulugoni. Gak uŋun dɨma nandɨsal, ma? ");
INSERT INTO yut_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mani yaŋ abeŋ kaŋ, Piŋkop da papiakon gen tosok uŋun niaŋon da bamɨ toŋ asak? Uwalno da yo yaŋsi aŋnamni do yosok.” ");
INSERT INTO yut_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yaŋ yaŋek uŋudon gɨn Yesu da amɨn kabɨ madep yaŋ yoyɨgɨt, “Ji nak do kabo noknok kɨnda yaŋ nandaŋek emat agak sɨba ae kɨndap kɨrɨŋyo tɨmɨgek nak abɨdok do abeŋ, ma? Nak gɨldarɨ gɨldarɨ Telagɨ Yut Madep da nagalgwan ji gat egek amɨn yoyɨŋ dekgɨm. Uŋun bɨsapmon nak abɨdok do dɨma nandawit. ");
INSERT INTO yut_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mani Piŋkop da papiakon kombɨ amɨn da gen mandawit yaŋ gɨn bamɨ noman tosok.” Yaŋ yaŋban paŋdet morapni Yesu yɨpmaŋek pasal kɨŋ mudawit. ");
INSERT INTO yut_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesu abɨdawit amɨn uŋun Yesu abɨdaŋ aŋaŋ mukwa sogok amɨn dakon mibɨltok amɨn Kaiapas da yutnon aŋkɨwit. Uŋudon gen teban dakon yoyɨŋdet amɨn gat ae kɨla amɨn gat kɨsi muwukgwit. ");
INSERT INTO yut_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita kagɨ kagɨsok da Yesu yol aŋkɨŋek, mukwa sogok amɨn dakon mibɨltok amɨn dakon yoma nagalgwan pɨgɨgɨt. Pɨkwan obip amɨn gat yɨgek Yesu yo niaŋsi aŋɨba kokeŋ yaŋ do pɨndak egɨpgut. ");
INSERT INTO yut_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aŋakwan mukwa sogok amɨn dakon amɨn madep kabɨ gat ae gen kokwin amɨn kɨsi morap gat da yaŋ nandawit, amɨn dɨ yaŋ yomno abɨŋ Yesu top gen yaŋ ɨmɨŋek gulusuŋ agɨt yaŋ yaŋakwa aŋatno kɨmotjak yaŋ nandawit. ");
INSERT INTO yut_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mani amɨn morapmɨ yaŋ yoba abɨŋek top gen morapmɨ yawit, mani asi gulusuŋ kɨnda agɨt yaŋ dɨma kawit. Don amɨn bamorɨ da abɨŋ yaŋ yagɨmal, ");
INSERT INTO yut_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Nin da nandaŋapno Yesu da yaŋ yagɨt, ‘Nak da Piŋkop dakon Telagɨ Yut Madep uŋun tuwɨlek gɨldat kapbɨ da butgwan ae wɨtjɨkeŋ.’ ” ");
INSERT INTO yut_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yaŋ yaŋakwal mukwa sogok amɨn dakon mibɨltok amɨn da pɨdaŋ agek Yesu yaŋ iyɨgɨt, “Gak gen kobogɨ kɨnda dɨma yoyɨki? On amɨn morap gen yaŋ gaba niaŋ nandaŋ yomɨsal?” ");
INSERT INTO yut_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mani Yesu da gen kɨnda dɨma yagɨt. Yaŋ aban mukwa sogok amɨn dakon mibɨltok amɨn da aeni iyɨgɨt, “Gak Piŋkop egɨp egɨpmɨ toŋ uŋun da manon yaŋ teban tok aŋek gen bamɨsi yoki. Gak asi Kristo, Piŋkop dakon Monji bo dɨma? Kɨlɨ bamɨ ya!” ");
INSERT INTO yut_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yaŋban Yesu da yaŋ yagɨt, “Gen yosol uŋun bamɨ. Ji don kaŋakwa Amɨn Dakon Monji Tapmɨm Ami da amɨnsi tet do yɨkban kokdaŋ. Aŋek kaŋakwa kundukon gɨkwemon da apban kokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yaŋ yaŋban nandaŋek mukwa sogok amɨn dakon mibɨltok amɨn burɨ wagɨl yokwi taŋban iyɨ dakon paba pɨgɨkni pudaŋek yagɨt, “Mibɨlni nandak do amɨn nido saŋbeŋek yoyɨno apni? Iyɨ Piŋkop kulabɨŋek ‘nak Piŋkop dakon Monji’ yaŋ yosok, ");
INSERT INTO yut_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","do ji da niaŋ aŋ ɨmneŋ do nandaŋ?” Yaŋban kɨsi morap da yawit, “Gulusuŋ asak, do si kɨmotjak.” ");
INSERT INTO yut_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yaŋ yaŋek dɨwarɨ da ɨlɨp sul ɨmɨŋek kɨsit da aŋakgwit. Ae dɨwarɨ da mogɨm kulbak aŋagek ");
INSERT INTO yut_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","yaŋ iyɨwit, “Kristo gak namɨn da gɨkdak? Kombɨ gen ya!” ");
INSERT INTO yut_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Aŋakwa Pita uŋun yut da nagalgwan yɨgakwan mukwa sogok mibɨltok amɨn dakon oman mɨŋatjok kɨnda da abɨŋ yaŋ iyɨgɨt, “Gak Yesu Galili amɨn gat kɨsi egɨpgwit.” ");
INSERT INTO yut_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Yaŋban Pita da wasɨp yaŋek yagɨt, “Gak da gen uŋun yosol nak dɨma nandɨsat.” ");
INSERT INTO yut_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Yaŋ yaŋek wigaron pɨgakwan oman mɨŋat kɨnda Pita kaŋek amɨn uŋudon akgwit yaŋ yoyɨgɨt, “On amɨn uŋun Yesu Nasaret amɨn gat kɨsi egɨpgwit.” ");
INSERT INTO yut_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yaŋ yaŋban Pita aeni geni aŋteban aŋek yaŋ iyɨgɨt, “Asisi, nak uŋun amɨn dɨmasi nandaŋ ɨmɨsat!” ");
INSERT INTO yut_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tɨmɨsok dɨ egek amɨn kapmatjok akgwit uŋun da kɨŋ Pita yaŋ iyɨwit, “Gak dakon tek nandano asi gak uŋun amɨn kabɨ dakon kokup ɨsalni kɨnda yaŋ asak, do gak uŋun da kabɨkon nani yaŋ nandamaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yaŋ yaŋba Pita da tebaisi yaŋek yagɨt, “Asisi dayɨsat, amɨn uŋun yoŋ nak dɨmasi nandaŋ ɨmɨsat. Top yosot kaŋ, Piŋkop da nak tagɨ aŋupbal asak!” Yaŋ yaŋakwan uŋudon gɨn pup gen yagɨt. ");
INSERT INTO yut_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yaŋban nandaŋek Pita Yesu da gen yagɨt uŋun do burɨ pɨsagɨt. Gen uŋun yaŋ yagɨt: “Pup da gen dɨma yaŋakwan gak da nak do wasɨp yaŋbɨ kosit kapbɨ akdɨsak.” Pita da gen uŋun do burɨ pɨsaŋban waŋga pɨgɨ kunam madepsi takgɨt. ");
INSERT INTO yut_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wɨsawɨsa do mukwa sogok amɨn dakon amɨn madep kabɨ gat ae kɨla amɨn gat da muwugek Yesu aŋakba kɨmotjak do yaŋ dagok awit. ");
INSERT INTO yut_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Aŋek Yesu kɨsirɨ wamaŋ aŋkɨ gapman dakon mibɨltok amɨn Pailat da kɨsiron yɨpgwit. ");
INSERT INTO yut_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas Yesu uwal da kɨsiron yɨpgut amɨn kaŋban Yesu kɨmotjak do yaŋ dagok aŋakwa mabisi at yaŋ nandagɨt. Aŋek nandak nandakni kulabɨk aŋek silwa moneŋ 30 yaŋ tɨmɨkgɨt uŋun mukwa sogok amɨn dakon amɨn madep kabɨ gat ae kɨla amɨn gat do aeni paŋtobɨl yomgut. ");
INSERT INTO yut_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yomɨŋek yaŋ yoyɨgɨt, “Nak suŋsi aŋek amɨn kɨlegɨ kɨnda uwal da kɨsiron yɨpmat. Uŋun ji da aŋakba kɨmotdɨsak.” Yoyɨŋban yaŋ iyɨwit, “Uŋun nin dakon yo dɨma. Uŋun gak dakon yo gɨn.” ");
INSERT INTO yut_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yaŋ yaŋba Judas silwa moneŋ uŋun telagɨ yut da nagalgwan dapban pɨgakwa kɨŋ iyɨ tɨpgut. ");
INSERT INTO yut_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Aban mukwa sogok amɨn dakon amɨn madep kabɨ da silwa moneŋ uŋun tɨmɨgek yaŋ yawit, “Moneŋ on yawi dakon tomni. Do telagɨ yut dakon moneŋ gat kɨsi yopneŋ kaŋ, gen tebanin yapdamaŋ.” ");
INSERT INTO yut_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yaŋ yaŋek uŋun moneŋ baŋ mɨktɨm kwoba wasawit mɨktɨm tɨm kɨnda yumaŋ nawit. Yumaŋ naŋek amɨn dubagɨkon da abɨŋ kɨmokgoŋ uŋun dakon amɨn kɨmakba yopyop tamo kɨnda wasawit. ");
INSERT INTO yut_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yaŋ awit do uŋun mɨktɨm tɨm uŋun do Yawi Mɨktɨm yaŋ yawit da yoŋ. ");
INSERT INTO yut_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Yaŋ aŋakwa kombɨ amɨn Jeremaia da gen mandagɨt uŋun bamɨ noman tagɨt. Gen uŋun yaŋ, “Israel amɨn da uŋun amɨn yumaŋ noni do silwa moneŋ 30 baŋ tomni yomgwit. ");
INSERT INTO yut_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Yaŋ aŋek Amɨn Tagɨ da nayɨgɨt, uŋun da tɨlagon uŋun moneŋ baŋ mɨktɨm kwoba wasawit mɨktɨm tɨm kɨnda yumaŋ nawit.” ");
INSERT INTO yut_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu gapman dakon mibɨltok amɨn Pailat da ɨŋamon agakwan Pailat da yaŋ iyɨgɨt, “Gak Juda amɨn dakon kɨla amɨn madep, ma?” Yaŋban Yesu da gen kobogɨ yaŋ yagɨt, “Yosol uŋun mani.” ");
INSERT INTO yut_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Yaŋ yaŋban mukwa sogok amɨn dakon amɨn madep kabɨ gat ae kɨla amɨn dɨwarɨ gat da gen yaŋ ɨmɨŋba gen kobogɨ kɨnda dɨma yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yaŋ aban Pailat da aeni iyɨgɨt, “Amɨn on da gak wasok yokwi agɨl do gen morapmɨ yaŋ gamaŋ. Uŋun dɨma nandɨsal, ma?” ");
INSERT INTO yut_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yaŋ yaŋban Yesu da gen kobogɨsok kɨnda dɨmasi yaŋakwan Pailat da Yesu do nandaban ŋwakŋwarɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bɨlagɨ bɨlagɨ Yapyap Bɨlak bɨsapmon gapman dakon mibɨltok amɨn da wasok kɨnda yaŋ agɨt. Mɨŋat amɨnyo da amɨn kɨnda dam tebanon yɨkdak uŋun mani yaŋakwa, Pailat da pulugaŋ yopban kɨŋ kɨŋ awit. ");
INSERT INTO yut_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Uŋun bɨsapmon amɨn yokwisi kɨnda dam tebanon yɨkgɨt, mani Barabas. ");
INSERT INTO yut_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Amɨn abɨŋ muwugakwa Pailat da amɨn da Yesu do nandaba yokwi taŋban top yaŋek gen pikon yɨpgwit yaŋ nandagɨt. Yaŋ nandaŋek Yesu aŋkutnaŋek yaŋ yoyɨgɨt, “Ji dakon galaktok namɨn naŋ pulugaŋ yɨpbo jikon opjak, Barabas do nandaŋ bo Yesu mani kɨnda Kristo yaŋ yoŋ uŋun naŋ?” ");
INSERT INTO yut_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Yaŋ yaŋek Pailat gen kokwin tamokon yɨgakwan mɨŋatni da gen kɨnda yaŋ yɨpban apgut, “Nak uŋun amɨn kalbi dɨpmɨnon kat, do jɨgɨsi nandɨsat. Uŋun amɨn kɨlegɨsi, do gak yo kɨnda dɨmasi aŋ ɨbi.” ");
INSERT INTO yut_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mani mukwa sogok amɨn dakon amɨn madep kabɨ gat ae kɨla amɨn gat da mɨŋat amɨn kabɨ madep burɨ sugaŋek yaŋ yoyɨwit, “Ji Pailat da Barabas naŋ pulugaŋek Yesu naŋ aŋakban kɨmotjak do iyɨni.” ");
INSERT INTO yut_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Yaŋba Pailat da aeni yaŋ yoyɨgɨt, “Ji dakon galaktok on amɨn bamoron baŋ namɨn naŋ pulugaŋ yɨpbo kɨsak do nandaŋ?” Yoyɨŋban “Barabas naŋ” yaŋ yawit. ");
INSERT INTO yut_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Yaŋba yaŋ yoyɨgɨt, “Yesu, mani kɨnda Kristo yaŋ yoŋ, uŋun do ninaŋ aŋ ɨbeŋ?” Yaŋ yaŋban amɨn kɨsi da yaŋ yawit, “Tɨlak kɨndapmon aŋakba kɨmotjak!” ");
INSERT INTO yut_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yaŋba Pailat da yoyɨgɨt, “Mibɨlɨ nido? Ni gulusuŋ naŋ agɨt?” Yaŋban mibɨltok yawit si yapmaŋek madepsi yaŋ tɨdaŋek yawit, “Tɨlak kɨndapmon aŋakba kɨmotjak!” ");
INSERT INTO yut_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yaŋba Pailat da iyɨ yaŋ nandagɨt, “Gen yoko dɨma nandaŋek emat madepsi akdaŋ.” Yaŋ nandaŋek mɨŋat amɨn kabɨ madep da dabɨlon kɨsitni pakbikon sugaŋek yaŋ yoyɨgɨt, “On amɨn kɨmakban nak da dɨwarɨ dɨma pakeŋ, ji da pani.” ");
INSERT INTO yut_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yaŋban amɨn kɨsi da geni yaŋ aŋtobɨl ɨmgwit, “Nin gat ae mɨŋat monjɨyonin gat da kɨmotjak dakon kobogɨ tagɨ paneŋ.” ");
INSERT INTO yut_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yaŋ yaŋba Pailat da Barabas pulugaŋ yɨpban mɨŋat amɨn kabɨyokon kɨgɨt. Kɨŋakwan emat amɨn yoyɨŋban Yesu baljawit. Aba don tɨlak kɨndapmon aŋakba kɨmotjak do yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gapman dakon emat amɨn da Yesu abɨdaŋ aŋaŋ gapman dakon yut madepmon wɨgakwa emat amɨn dɨwarɨ kɨsi abɨŋ Yesu aŋgwasɨŋek akgwit. ");
INSERT INTO yut_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Aŋek Yesu iyɨ dakon ɨmalni ɨlɨgek kɨla amɨn madep da ɨmal gami dubak paŋ uŋuden kɨnda paŋ ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yaŋ aŋek nap kelɨ toŋ naŋ kɨla amɨn madep dakon pelɨt yombem kɨnda wasaŋ busuŋɨkon aba pɨgɨgɨt. Aba pɨgakwan kɨndap kɨrɨŋ kɨnda kɨsirɨ amɨnsi tet do yɨpmaŋ ɨmgwit. Yɨpmaŋ ɨmɨŋek gawak ɨmɨŋek topmon da man madep ɨmɨŋek gen yaŋ iyɨwit, “Gɨldat tagɨ, Juda amɨn dakon kɨla amɨn madep!” ");
INSERT INTO yut_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aŋek ɨlɨp sul ɨmɨŋek kɨndap kɨrɨŋ kɨsirɨkon yɨpgwit uŋun gwayeŋ busuŋɨkon kosirɨ morapmɨ baljawit. ");
INSERT INTO yut_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Aŋek topmon da man madep ɨmɨŋ mudaŋek ɨmal gami ɨlɨgek iyɨ dakon pabɨ pɨgɨk paŋ ɨmgwit. Paŋ ɨmɨŋek tɨlak kɨndapmon aŋakba kɨmotjak do ɨlɨk aŋaŋ kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kosiron kɨŋek emat amɨn da Sairini kokupmon amɨn kɨnda kawit, mani Saimon. Uŋun tebai iyɨŋba Yesu dakon tɨlak kɨndapni guramɨkban kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kɨŋ mɨktɨm tɨm kɨnda mani Golgata uŋudon altawit. (Golgata dakon mibɨlɨ uŋun Busuŋ Kɨdat Ɨleŋ.) ");
INSERT INTO yut_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kɨŋ altaŋek wain gat ae pakbi ɨsɨpmɨ kɨnda gat ɨktagɨlek ɨmɨŋba naŋ nandat aŋek nok do kurak tagɨt. ");
INSERT INTO yut_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aŋakwan tɨlak kɨndapmon aŋagek emat amɨn da satu wasok aŋek ɨmalni kokwinɨk tɨmɨkgwit. ");
INSERT INTO yut_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Satu wasok aba mudaŋban mɨktɨmon pabɨŋ yɨgek kɨla aŋek kaŋ egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kwen busuŋɨkon mibɨlɨ nido aŋakgwit uŋun dakon but pɨso yaŋ mandawit, ON YESU, JUDA AMƗN DAKON KƗLA AMƗN MADEPNI ");
INSERT INTO yut_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kabo noknok bamorɨ Yesu gat kɨsi dapgwit. Kɨnda amɨnsi tetdo, ae kɨnda gwandeŋ tet do tɨlak kɨndapmon dapmaŋ dapmaŋ awit. ");
INSERT INTO yut_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Amɨn kɨŋ ap awit uŋun da yaŋba yokwi tok aŋ ɨmɨŋek wunda kwalkwal aŋek yaŋ iyɨwit, ");
INSERT INTO yut_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Gak Telagɨ Yut Madep tuwɨlek gɨldat kapbɨ da butgwan ae wɨtjɨk do yagɨl, do gɨptɨmgo aŋkutnoki! Gak asi Piŋkop dakon Monji egɨsalon tɨlak kɨndapmon da pɨ!” ");
INSERT INTO yut_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Yaŋ yaŋba mukwa sogok amɨn dakon amɨn madep kabɨ gat gen teban yoyɨŋdet amɨn gat ae kɨla amɨn gat uŋun kɨsi yaŋ gɨn jɨgɨlak iyɨŋek yawit, ");
INSERT INTO yut_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Amɨn dɨwarɨ paŋpulugagɨt da nido iyɨ aŋpulugok do aŋtɨdok asak? On Israel amɨn dakon kɨla amɨn madepni ma! Kaŋ tɨlak kɨndapmon da pɨŋban kaŋek nandaŋ gadaŋ ɨmneŋ. ");
INSERT INTO yut_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Piŋkop nandaŋ gadaŋ ɨmɨŋek yaŋ yosok, ‘Nak Piŋkop dakon Monji egɨsat.’ Piŋkop da Monji aŋpulugok do nandɨsak kaŋ, tagɨ aŋpulugosak.” ");
INSERT INTO yut_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Uŋudeŋ gɨn kabo noknok bamot terɨ terɨ dapbi uŋunyo kɨsi yaŋba yokwi tok yaŋ gɨn agɨmal. ");
INSERT INTO yut_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Gɨldat binap 12 kilok mɨktɨm kɨsi pɨlɨn tuk aŋakwan kɨŋ pɨlɨndo 3 kilok agɨt. ");
INSERT INTO yut_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","kilok aŋakwan Yesu da yaŋ tɨdaŋek yaŋ yagɨt, “Eli, Eli, lama sabaktani?” Gen uŋun dakon mibɨlɨ yaŋ: “Piŋkopno, Piŋkopno, nido nepmaŋ dekdal?” ");
INSERT INTO yut_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Yaŋ yaŋban amɨn dɨwarɨ kapmatjok akgwit uŋun nandaŋek yawit, “Nandaŋ, uŋun Elaija do yaŋ ɨmɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yaŋba uŋudon gɨn amɨn kɨnda tɨmtɨm yaŋek kɨŋ yo kɨnda gugɨdan yombem jol dɨwaron wamaŋ wain gat ae pakbi ɨsɨpmɨ gat uŋungwan sɨbɨŋek Yesu da nosak do aŋenak ɨmgut. ");
INSERT INTO yut_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aŋakwan dɨwarɨ da yawit, “Yum kaŋba koneŋ. Elaija da abɨŋ aŋpulugaŋban koneŋ bo dɨma?” ");
INSERT INTO yut_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yaŋ yaŋakwa Yesu aeni yaŋ tɨdaŋek wupni yɨpban kɨŋakwan kɨmakgɨt. ");
INSERT INTO yut_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kɨmagakwan uŋun bɨsapmon gɨn Telagɨ Yut Madep dakon yoma ɨmal uŋun kwen da sulugɨ pɨŋ mibɨlɨkon dagaŋek tɨmɨ bamorɨ agɨt. Yaŋ aŋakwan mɨktɨm wudɨp aŋakwan tɨp madep morapmɨ da sulugɨwit. ");
INSERT INTO yut_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Uŋun yo morap altaŋakwa amɨn kɨmakba yopmaŋgaŋ tamo wɨtdal kɨŋakwa Piŋkop dakon amɨn morapmɨ kalɨp kɨmakba yopbi uŋun pɨdawit. ");
INSERT INTO yut_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pɨdaŋ don Yesu da kɨmoron da pɨdaŋakwan telagɨ kokup papmon pukwa amɨn morapmɨ da pɨndakgwit. ");
INSERT INTO yut_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Aŋakwa emat amɨn 100 dakon kɨla amɨn gat ae emat amɨn Yesu do kaŋ egɨpgwit amɨn uŋun wudɨp ae yo morap altawit uŋun pɨndagek si pasalgwit. Pasalek yaŋsi yawit, “On amɨn asisi Piŋkop dakon Monji egɨpgut.” ");
INSERT INTO yut_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aŋakwa mɨŋat dɨwarɨ dubagɨsogon da agek yo uŋun pɨndakgwit. Yesu Galili mɨktɨm yɨpmaŋ abɨŋakwan uŋun mɨŋat kabɨ da yol awɨlek oman aŋ ɨmɨŋek agɨpgwit. ");
INSERT INTO yut_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Uŋun kabɨkon kɨnda mani Maria, kokupni Makdala. Ae Maria ŋwakŋwarɨ kɨnda Jems gat Josep gat dakon meŋi. Ae Sebedi dakon monjɨ bamot uŋun dakon meŋi kɨsi akgwit. ");
INSERT INTO yut_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pɨlɨndo yoni morapmɨ amɨn kɨnda Arimatea kokupmon da apgut. Uŋun mani Josep. Uŋun Yesu dakon paŋdetni kɨnda. ");
INSERT INTO yut_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Josep uŋun Pailaron kɨŋ Yesu dakon bumjotni abɨdok do iyɨgɨt. Iyɨŋban emat amɨni yoyɨŋban bumjotni Josep do ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ɨmɨŋba abɨdaŋ aŋkɨ ɨmal garagɨ mɨni kɨnda naŋ wamaŋek ");
INSERT INTO yut_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","aŋkɨ iyɨ dakon tɨp kɨnam amɨn kɨmakbi do kaluk pasɨŋbi uŋungwan aŋkɨ yɨpgut. Yɨpmaŋek tɨp madepsi kɨnda aŋtobɨlban abɨŋ yoma sopmaŋakwan yɨpmaŋ kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Makdala kokupmon nani gat ae Maria kɨnda gat tɨp kɨnam da kapmatjok yɨgek yo agɨt uŋun nomansi kagɨmal. ");
INSERT INTO yut_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sabat bɨsap do tagap tok aŋ mudaŋek wɨsa dagokdo mukwa sogok amɨn dakon amɨn madep kabɨ gat ae Parisi amɨn gat Pailaron kɨwit. ");
INSERT INTO yut_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kɨŋ yaŋ iyɨwit, “Top amɨn si egɨpgut bɨsapmon gen kɨnda yaŋ yagɨt, ‘Gɨldat kapbɨ mudaŋakwa kɨmoron da pɨdokeŋ’ yaŋ yagɨt. ");
INSERT INTO yut_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yaŋ yagɨt, do gak obip amɨngo tebaisi yoyɨŋbɨ tɨp kɨnam dakon kɨla tebaisi aŋakwa wɨgɨ gɨldat kapbɨ mudoni. Yaŋ dɨma ani kaŋ, paŋdetni da abɨŋ bumjotni kabo aŋkɨsɨbɨŋ aŋkɨŋek Yesu kɨlɨ pɨdak yaŋ amɨn yoyɨkdaŋ. Yaŋ ani kaŋ, mibɨltok iyɨ do top gen yagɨt uŋun yapmaŋek top gen yokdaŋ uŋun da yo yokwisi kɨnda akdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Yaŋba Pailat da yaŋ yoyɨgɨt, “Ji obip amɨn tɨmɨkba kɨŋ tɨp kɨnam uŋun niaŋsi aŋek kɨlani ak do nandaŋ uŋun da tɨlagon yoyɨŋba ani.” ");
INSERT INTO yut_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yaŋ yoyɨŋban tɨp kɨnamon kɨŋ tɨp madep yoma kaga sopguron tɨlak kɨnda dɨma abɨdoni do yɨpgwit. Yɨpmaŋek obip amɨn da kɨlani tebaisi ani do yopba akgwit. ");
INSERT INTO yut_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat bɨsap mudaŋakwan pakgwit da Sonda wɨsa dagokdo Maria Makdala kokupmon nani gat ae Maria kɨnda gat tɨp kɨnam kok do kɨgɨmal. ");
INSERT INTO yut_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kɨŋakwal uŋudon gɨn wudɨp madep agɨt. Aŋakwan Amɨn Tagɨ dakon aŋelo kɨnda Kwen Kokupmon da pɨŋ tɨp madep uŋun aŋtobɨlban kɨŋakwan kwenikon yɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Aŋelo uŋun mal da yaŋ teŋteŋaŋakwan ɨmalni uŋun gɨk sitnaŋ yombem kwakwagɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Obip amɨn uŋun kaŋ pasal nɨmnɨmɨk maŋ pagek kɨmakbi yombem awit. ");
INSERT INTO yut_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yaŋ aŋakwa aŋelo da mɨŋat bamot yaŋ yoyɨgɨt, “Jil dɨma pasoljil. Yesu tɨlak kɨndapmon aŋakbi naŋ wusɨk do abamal yaŋ nandɨsat. ");
INSERT INTO yut_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yesu yagɨt da arɨpmon Piŋkop da kɨlɨ aban pɨdak. Ɨdon dɨma egɨsak. Abɨŋ tamoni do konjil. ");
INSERT INTO yut_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jil tepmɨsi kɨŋ paŋdetni yaŋ yoyɨnjil, ‘Uŋun Piŋkop da kɨmoron naŋ kɨlɨ aban pɨdak. Mibɨltaŋ damɨŋek Galili mɨktɨmon kɨk, do uŋudon kɨŋ koni.’ Nak gen on dayɨk do pɨt.” ");
INSERT INTO yut_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yaŋ yoyɨŋban mɨŋat bamot uŋun pasalgɨmal, mani kɨsɨk kɨsɨk nandaŋek tɨmtɨm yaŋek paŋdet kabɨni gen uŋun yoyɨk do kɨgɨmal. ");
INSERT INTO yut_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kɨŋakwal Yesu gat domdom aŋek yaŋ yoyɨgɨt, “Wɨsa dagokdo tagɨsi.” Yaŋ yoyɨŋban kandapmɨ abɨdaŋek gawak ɨmgumal. ");
INSERT INTO yut_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Aŋakwal Yesu da saŋbeŋek yaŋ yoyɨgɨt, “Dɨma pasoljil. Jil kɨŋ notnoni kabɨ yoyɨŋbal Galili kɨŋ uŋudon nandani.” ");
INSERT INTO yut_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mɨŋat bamot kɨŋakwal obip amɨn dɨwarɨ tɨp kɨnam dakon kɨla awit uŋun da kokup papmon kɨŋ mukwa sogok amɨn dakon amɨn madep kabɨ yo morap altawit uŋun dakon gen morap yoyɨŋ mudawit. ");
INSERT INTO yut_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yoyɨŋba mukwa sogok amɨn dakon mibɨltok amɨn gat ae kɨla amɨn gat muwugek niaŋ ano kɨlek tosak yaŋ do gen paŋkosit awit. Aŋek obip amɨn do moneŋ madepsi yomɨŋek ");
INSERT INTO yut_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","yaŋ yoyɨwit, “Ji yaŋsi yoni, ‘Nin kalbi pak ɨŋtaŋapno paŋdetni da abɨŋ bumjotni kabo aŋkɨsɨbeŋ.’ ");
INSERT INTO yut_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gapman dakon mibɨltok amɨn da uŋun dakon geni nandɨsak kaŋ, nin da iyɨno burɨ maŋakwan jikon jɨgɨ kɨnda dɨma tosak.” ");
INSERT INTO yut_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yaŋ yoyɨŋba obip amɨn moneŋ tɨmɨgek geni guramɨkgwit. Gen uŋun Juda amɨn da yaŋ aŋ ɨreŋ aba abɨsokyo kɨsi yaŋ gɨn yoŋ. ");
INSERT INTO yut_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Paŋdetni 11 kabɨ Galili mɨktɨmon kɨŋ, Yesu da kabap kɨnda uŋudon wɨgɨni do kɨlɨ yoyɨgɨt uŋudon wɨgɨwit. ");
INSERT INTO yut_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wɨgɨ Yesu kaŋek gawak ɨmgwit, mani dɨwarɨ da but bamot awit. ");
INSERT INTO yut_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aŋakwa Yesu da paŋdet kabɨnikon kɨŋek yaŋ yoyɨgɨt, “Piŋkop da yo morap Kwen Kokupmon ae mɨktɨmon kɨla abeŋ dakon pi nak do yaŋ mudaŋ namgut. ");
INSERT INTO yut_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Uŋun do ji mɨktɨmɨ mɨktɨmɨ kɨŋ mɨŋat amɨn morapyo paŋpulugaŋba nak dakon paŋdet kabɨno dagoni. Aŋek Dat ae Monji ae Telagɨ Wup uŋun da manon telagɨ pakbi soŋ yomni. ");
INSERT INTO yut_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nak da gen dayɨŋ dolɨgɨm uŋun kɨsisi guramɨtni do yoyɨŋdetni. Nandani, nak ji gat gɨldarɨ gɨldarɨ egapno mɨktɨm dakon bɨsap mudosak.” ");
INSERT INTO yut_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu Kristo, Piŋkop dakon Monji, uŋun dakon Gen Bin Tagɨsi ɨdon da wasosok. ");
INSERT INTO yut_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kombɨ amɨn Aisaia da gen yaŋ mandagɨt: “Nandani, geno yaŋ teŋteŋosak do amɨn kɨnda yabekgo uŋun da mibɨltaŋ gamjak. Aŋek kositgo aŋnoman asak. ");
INSERT INTO yut_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mɨktɨm amɨn da arɨpmɨ dɨma egɨpmɨ tɨmon amɨn kɨnda da yaŋ tɨdaŋek yosok, ‘Amɨn Tagɨ dakon kosit aŋdɨmdɨm ani, kositni pasɨŋ aŋmɨlɨp ani.’ ” ");
INSERT INTO yut_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Gen uŋun da tɨlagon Telagɨ Pakbi Sogok Amɨn Jon da mɨktɨm amɨn da arɨpmɨ dɨma egɨpmɨ tɨmon kɨŋ altagɨt. Altaŋek but tobɨl aŋek telagɨ pakbi soŋakwa Piŋkop da dɨwarɨni yopmaŋ yomjak do yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aŋakwan Judia mɨktɨmon ae Jerusalem kokup papmon egɨpgwit amɨn Jonon kɨwit. Yokwini yaŋkwok aŋakwa Jodan Pakbikon telagɨ pakbi soŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon da ɨlɨkba pɨgɨk paŋ egɨpgut uŋun bɨt madep kɨnda mani kamel uŋun dakon daŋgwani baŋ wasaŋbi. Aŋek bɨt gɨp kɨnda bobaŋ napmɨ do wamgut. Japni uŋun pɨlak pɨlak ae kabaŋ kok. ");
INSERT INTO yut_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Gen yaŋ yagɨt: “Amɨn kɨnda nak da manjikon apdɨsak. Uŋun dakon tapmɨm da nak dakon tapmɨm yapmaŋdak. Nak oman monjɨni dakon pɨŋbinisi egɨsat, do kandap gwɨlni dakon nap pabɨŋ yɨgek tagɨ dɨma wɨtdalgeŋ. ");
INSERT INTO yut_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nak pakbisi baŋ telagɨ pakbi soŋ damɨsat, mani uŋun da Telagɨ Wup soŋ damdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Uŋun bɨsapmon Yesu Nasaret kokup Galili Provins yɨpmaŋek apgut. Apban Jon da Jodan Pakbikon telagɨ pakbi soŋ ɨmgut. ");
INSERT INTO yut_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Aban pakbikon da wɨŋek wɨŋek Yesu yaŋ kagɨt: Kundu wɨtdal kɨŋakwan Telagɨ Wup kɨnarɨm da mɨktɨmon paŋ uŋun da tɨlak iyɨkon pɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aŋakwan Kwen Kokupgwan da gen kɨnda yaŋ altagɨt: “Gak Monjɨno. Butdasi galak taŋ gamɨsat. Butno gak do tagɨsi asak.” ");
INSERT INTO yut_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Uŋudon gɨn Wup da Yesu yabekban mɨktɨm amɨn da arɨpmɨ dɨma egɨpmɨ tɨmon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kɨŋ uŋudon gɨldat 40 egakwan Sunduk da aŋkewalgɨt. Bɨt kɨlapyo da bɨkbɨgon egakwan aŋelo da aŋpulugawit. ");
INSERT INTO yut_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jon dam teban yutnon yɨpba yɨgakwan Yesu Galili Provinskon kɨgɨt. Kɨŋ Piŋkop dakon Gen Bin Tagɨsi yaŋ teŋteŋaŋek yaŋ yagɨt, ");
INSERT INTO yut_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Piŋkop da Amɨn Kɨla Akdɨsak uŋun dakon bɨsap kwaŋ tosok. Uŋun do ji but tobɨl aŋek Gen Bin Tagɨsi uŋun do nandaŋ gadani.” ");
INSERT INTO yut_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu da Galili Pakbi Ɨdap kɨdɨpmɨŋ kɨŋek Saimon gat padɨge Andru gat pɨndakgɨt. Uŋun amɨn bamot tap kɨlap sɨmɨl sɨmɨl yɨkni pakbi ɨdapmon mabal pɨgakwan egɨpgumal. Pini uŋun tap kɨlap sɨmɨl sɨmɨl do pi agak amɨn bamot. ");
INSERT INTO yut_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Uŋun amɨn bamot pɨndagek Yesu da yaŋ yoyɨgɨt, “Abɨŋ nak nolgɨl, aŋakwal amɨn tɨmɨt tɨmɨt dakon kosit dolɨko.” ");
INSERT INTO yut_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yaŋban uŋudon gɨn tap kɨlap sɨmɨl sɨmɨl yɨkni yopmaŋek Yesu yolgɨmal. ");
INSERT INTO yut_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu da tɨmɨsok dɨ kɨŋek Jems, Sebedi dakon monji gat padɨge Jon gat pɨndakgɨt. Uŋun bamot boron yɨgek tap kɨlap sɨmɨl sɨmɨl yɨkni bɨsawɨk paŋmɨlɨp aŋyo aŋakwal pɨndakgɨt. ");
INSERT INTO yut_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pɨndagek uŋudon gɨn yaŋ yoban nandaŋek datni Sebedi gat pi amɨni gat boron si yɨgakwa Yesu yolgɨmal. ");
INSERT INTO yut_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu gat paŋdetni gat Kapaneam kokupmon kɨwit. Kɨŋ altaŋek Sabat bɨsapmon Yesu da Juda amɨn da muwut muwut yutnon wɨgek Piŋkop gen yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Gen teban yoyɨŋdet amɨn da tɨlagon dɨma yagɨt, amɨn mani toŋ da tɨlagon yagɨt, do amɨn da Piŋkop gen yogokni do nandaba ŋwakŋwarɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Aŋakwan uŋudon gɨn koŋni toŋ amɨn kɨnda da yaŋ tɨdaŋek yaŋ yagɨt, ");
INSERT INTO yut_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu, Nasaret amɨn, gak nibaŋ aŋnim do nandɨsal? Nin paŋupbal ak do abɨl? Nak nandaŋ gamɨsat, gak Piŋkop Dakon Telagɨ Amɨni.” ");
INSERT INTO yut_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yaŋ yaŋban Yesu da gen tebaisi yaŋ iyɨgɨt, “Gak gen dɨma yaŋek amɨn on yɨpmaŋ det!” ");
INSERT INTO yut_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yaŋban koŋ da amɨn uŋun ukwayɨgek madepsi yaŋ tɨdaŋek yɨpmaŋ degek wɨŋ kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wɨŋ kɨŋakwan amɨn da uŋun kaŋek wurɨpdagek notni yoyɨŋ yoyɨŋ aŋek yaŋ yawit, “Mao, uŋun ni yo kɨnda da altosok? On amɨn gen ŋwakŋwarɨsi yosok. Amɨn mani toŋ da tɨlagon yosok. Koŋ gen yoyɨŋban geni guramɨkgaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yaŋ yaŋakwa man bini da tepmɨsi ɨreŋ taŋek Galili Provins arɨpmɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Juda amɨn da muwut muwut yutnon da pɨŋek uŋudon gɨn Jems gat Jon gat tɨmɨkban, Saimon gat Andru gat uŋun da yutnon wɨgɨwit. ");
INSERT INTO yut_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Uŋun yutnon Saimon yopmi gɨptɨmɨ kɨndapmɨ soŋakwan sot aŋek pakgɨt. Uŋun dakon mibɨlɨ ");
INSERT INTO yut_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","iyɨŋba Yesu kɨŋ kɨsitnikon abɨdaŋek ɨlɨkban pɨdagɨt. Yaŋ aban sotni yɨpmaŋakwan jap noni do oman agɨt. ");
INSERT INTO yut_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Gɨldat pɨgakwan pɨlɨndo sot amɨn gat koŋni toŋ amɨn gat kɨsisi Yesukon paŋpaŋ apgwit. ");
INSERT INTO yut_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aŋek kokup amɨn kɨsi morap yut uŋun da yomakon muwukgwit. ");
INSERT INTO yut_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Muwugakwa Yesu da amɨn morapmɨsi sot mibɨlɨ mibɨlɨ awit uŋun paŋmɨlɨp agɨt. Aŋek koŋni toŋ amɨn morapmɨ koŋni yol yomgut. Aŋek koŋ uŋun nandaŋ ɨmgwit, do yaŋsop aŋyomgut. ");
INSERT INTO yut_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wɨsa dɨma dagaŋakwan Yesu pɨlisisok pɨdaŋ yut yɨpmaŋek mɨktɨm amɨn da arɨpmɨ dɨma egɨpmɨ tɨmon paŋkɨ egek bɨsit pi agɨt. ");
INSERT INTO yut_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Aŋakwan Saimon gat notni kabɨ gat Yesu wɨsɨŋek apgwit. ");
INSERT INTO yut_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Abɨŋ aŋalon aŋek iyɨwit, “Amɨn morapmɨsi da gak wɨsaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yaŋba yaŋ yoyɨgɨt, “Nak uŋun amɨn kabɨ dogɨn dɨma pɨgɨm. Do nin kokup taŋ aŋaŋ kwaŋ uŋudon kɨŋek Piŋkop gen yoyɨkeŋ. Nak pi uŋun ak do pɨgɨm.” ");
INSERT INTO yut_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yaŋ yaŋek Galili Provinskon dukwan dukwan kɨsi agek Juda amɨn dakon muwut muwut yut morapmon Piŋkop dakon gen yoyɨŋek koŋ yol yomɨŋek agɨpgut. ");
INSERT INTO yut_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Amɨn wuda tebani toŋ kɨnda da uŋudon kɨŋek ŋwakbeŋ aŋ ɨmɨŋek bɨsit tebai yaŋ iyɨgɨt, “Piŋkop da dabɨlon kɨlek tokeŋ do nandɨsal kaŋ, tagɨ aŋmɨlɨp abɨ kɨlek tokeŋ.” ");
INSERT INTO yut_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yaŋban Yesu da uŋun do bupmɨ nandaŋek kɨsitni amɨn uŋun da kwenon wɨtjɨŋek yaŋ iyɨgɨt, “Kɨlek toki do nandɨsat, do pasɨl gamni!” ");
INSERT INTO yut_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yaŋ iyɨŋban uŋudon gɨn wudani kɨbɨdaŋakwa gɨptɨmni kɨlek tagɨt. ");
INSERT INTO yut_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kɨlek taŋban uŋudon gɨn Yesu da amɨn uŋun yabegek gen tebai yaŋ iyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Gak uŋun dakon mibɨlɨ amɨn dɨma yoyɨki. Aŋek mukwa sogok amɨnon kɨŋek gɨptɨmgo yolɨki. Aŋek Moses da yagɨt uŋun da tɨlagon paret aŋaki amɨn da asi kɨlek tal yaŋ gandani.” ");
INSERT INTO yut_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yaŋ yaŋban yum kaŋek kɨŋ gen bin yaŋ aŋɨreŋ agɨt. Uŋun do aŋek Yesu kokup papmon noman kɨsak do nandaban tɨdok tagɨt. Kokup ɨleŋɨ ɨleŋɨkon gɨn agakwan amɨn morap dukwan dukwan egɨpgwit Yesukon apgwit. ");
INSERT INTO yut_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesu gɨldat dɨ egɨ aeni Kapaneam kokupmon kɨŋek yutnikon wɨgakwan kokup amɨn da abapni dakon gen nandawit. ");
INSERT INTO yut_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nandaŋek morapmɨsi da yutnon muwuk tugaŋek dɨwarɨ yomakon yɨk tugaŋba Piŋkop dakon gen yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yoyɨŋakwan amɨn kabɨ kɨnda apgwiron da amɨn 4 kabɨ da amɨn kɨsirɨ kandapmɨyo kɨmakbi kɨnda wamaŋ uŋudon aŋapgwit. ");
INSERT INTO yut_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Aŋek yutnon awɨgɨ Yesu da buron yɨpdo aŋek amɨnon kwa tɨdaŋba yut kwenon awɨgɨwit. Awɨgek Yesu da si yɨkgɨt da kwenon yut tuwɨlba kosit pɨsaŋakwan uŋudon da amɨn uŋun wayɨgon pagakwan nap aŋyawot aŋakwa pɨgɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yaŋ aŋakwa Yesu da nandaŋ gadatni kaŋek amɨn kɨsirɨ kandapmɨyo kɨmakbi yaŋ iyɨgɨt, “Monjɨ, dɨwarɨgo yopmaŋ gamɨsat.” ");
INSERT INTO yut_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yaŋ yaŋban gen teban yoyɨŋdet amɨn dɨwarɨ uŋudon yɨkgwit uŋun da burɨ da yaŋ nandawit, ");
INSERT INTO yut_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ma, amɨn on ni gen naŋ yosok? On Piŋkop kulabɨsak on! Namɨn amɨn da dɨwarɨ wɨrɨrɨt pi asak? Uŋun pi Piŋkop dagɨn agagɨ!” ");
INSERT INTO yut_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yaŋ nandaŋakwa Yesu uŋun burɨkon da pɨndak nandaŋ yomɨŋ mudaŋek yoyɨgɨt, “Ji nido butjikon da nandak nandak uŋun nandaŋ namaŋ? ");
INSERT INTO yut_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Jit da tagapmɨ, amɨn kɨsirɨ kandapmɨyo kɨmakbi yaŋ iyɨkdo, ‘Dɨwarɨgo wɨrɨrɨk gamɨsat’, bo uŋudeŋ iyɨkdo, ‘Pɨdaŋ yalɨŋ potgo tɨmɨgek pɨlɨk bamok aki’? ");
INSERT INTO yut_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Amɨn Dakon Monji uŋun mɨktɨmon dɨwarɨ wɨrɨrɨt dakon pi asak do yaŋ mudaŋ ɨbi yaŋ nandaba pɨsosak do on amɨn aŋmɨlɨp abeŋ.” Yaŋ yaŋek amɨn kɨsirɨ kandapmɨyo kɨmakbi yaŋ iyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nak gayɨsat, pɨdaŋ yalɨŋ potgo tɨmɨgek yutgokon kɨ.” ");
INSERT INTO yut_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yaŋban uŋudon gɨn amɨn morapmɨ da dabɨlon yalɨŋ potni tɨmɨgek abɨgɨgɨt. Yaŋ aŋakwan amɨn kawit uŋun da tamtam yaŋek Piŋkop aŋkɨsiŋek yawit, “Yo kalugɨsi altaŋban komaŋ!” ");
INSERT INTO yut_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu yaŋ aŋek aeni pakbi ɨdap ɨleŋɨkon pɨgɨgɨt. Pɨgakwan amɨn morapmɨ yol aŋaŋ uŋudon kwa Piŋkop gen yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Aŋek uŋudon da kɨŋek Liwai, Alpius dakon monji, takis tɨmɨt tɨmɨt yutnikon yɨgakwan kagɨt. Kaŋek yaŋ iyɨgɨt, “Abɨŋ nak nol.” Yaŋban Liwai pɨdaŋek Yesu yolgɨt. ");
INSERT INTO yut_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Aŋakwan Yesu Liwai da yutnon kwan yɨgek jap nawit. Moneŋ tɨmɨt tɨmɨt amɨn ae yokwi pakpak amɨn morapmɨ Yesu gat paŋdetni gat jap nawit. (Uŋuden amɨn morapmɨsi da Yesu yolgwit.) ");
INSERT INTO yut_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Uŋudon Parisi amɨn dɨwarɨ yɨkgwit uŋun gen teban yoyɨŋdet amɨn. Uŋun da Yesu moneŋ tɨmɨt tɨmɨt amɨn gat ae yokwi pakpak amɨn gat kɨsi yɨgek jap naŋba kaŋek paŋdetni yaŋ yoyɨwit, “Ma, uŋun nido takis tɨmɨt tɨmɨt amɨn gat ae yokwi pakpak amɨn gat kɨsi yɨgek jap noŋ? Uŋun tagɨ dɨma.” ");
INSERT INTO yut_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yaŋba Yesu da nandaŋek yoyɨgɨt, “Amɨn sotni mɨni uŋun wuda wamagon dɨma kwaŋ. Amɨn sotni toŋ uŋun dagɨn wuda wamagon kwaŋ. Nak amɨn kɨlegɨ yaŋ ɨlɨt do dɨma opgum, yokwi pakpak yaŋ ɨlɨt do opgum.” ");
INSERT INTO yut_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jon dakon paŋdetni gat ae Parisi amɨn gat uŋun bɨsapmon Piŋkop do nandaŋek jap kelek egɨpgwit. Aŋakwa amɨn dɨwarɨ uŋun Yesukon kɨŋek yaŋ iyɨwit: “Jon dakon paŋdetni gat ae Parisi amɨn dakon paŋdetni gat uŋun Piŋkop do nandaŋek jap kelek egakwa gak dakon paŋdetgoni nido jap naŋek ekwaŋ?” ");
INSERT INTO yut_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iyɨŋba Yesu da yoyɨgɨt, “Monjɨsok mɨŋat pak do aŋ uŋun bɨsapmon notni gat jap kelek tagɨ egɨpni? Dɨma. Monjɨsok egakwan jap kelek arɨpmɨ dɨma egɨpmɨ. ");
INSERT INTO yut_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mani don monjɨ uŋun abɨdaŋ aŋaŋ kɨŋakwa notni uŋun bɨsapmon jap kelek ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Nin ɨlɨkba pɨgɨk garaŋɨ pudaŋkwikon ɨmal dɨwat kalugɨ pakbikon dɨma sugaŋbi kɨnda naŋ bupnom kaŋ, pakbikon sugono ɨmal dɨwat uŋun da garaŋɨ ɨlɨkban pudaŋ kɨ madepsi akdɨsak. ");
INSERT INTO yut_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ae amɨn kɨnda da wain kalugɨ tɨbɨrɨ meme gɨp baŋ wasaŋbi tɨbɨrɨ kalɨpmɨkon kolesak kaŋ uŋun tagɨ dɨma. Yaŋ asak kaŋ, wain da pukwa paptaŋ meme gɨp kɨrɨŋɨgakwa wain maŋ mudokdaŋ. Amɨn da wain kalugɨ meme gɨp kalugɨkon koleŋba wain gat meme gɨp gat kɨsi tagɨ tomal.” ");
INSERT INTO yut_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat kɨndakon Yesu gat paŋdetni gat uŋun wit pi kaga kɨndakon kɨwit. Kɨŋek paŋdetni da wit bamɨ dɨwarɨ jɨmɨk dagawit. ");
INSERT INTO yut_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aŋakwa Parisi amɨn da Yesu yaŋ iyɨwit, “Pɨndat, amɨn Sabat bɨsapmon nido gen teban yapmaŋek pi aŋ?” ");
INSERT INTO yut_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yaŋba Yesu da yoyɨgɨt, “Dewit ae amɨn kabɨni jap do aŋek yo awit uŋun ji manjɨŋ nandaŋyo awit bo dɨma? ");
INSERT INTO yut_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Uŋun Abiata da mukwa sogok amɨn dakon mibɨltok amɨn egɨpgut bɨsapmon yaŋ awit. Piŋkop da yutnon wɨgek bret Piŋkop do parekbi uŋun tɨmɨk naŋek amɨn kabɨni kɨsi do yoban nawit. Bret uŋun amɨn ɨsalɨ da dɨma nok nogɨ, mukwa sogok amɨn dagɨn tagɨ nawit.” ");
INSERT INTO yut_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yaŋ yaŋek yagɨt, “Sabat bɨsap uŋun do nandaba yo madep aŋakwan amɨn kɨrɨŋɨk yomaŋ uŋun da tagɨ dɨma asak. Sabat bɨsap uŋun amɨn paŋpulugok do aŋek yɨpbi. ");
INSERT INTO yut_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yaŋdo, Amɨn Dakon Monji uŋun Sabat bɨsap uŋun dakon Amɨn Tagɨni egɨsak.” ");
INSERT INTO yut_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu aeni bɨsap kɨnda gat Juda amɨn da muwut muwut yutnon wɨgek amɨn kɨnda kɨsirɨ gɨreŋɨkbi kɨnda yɨkban kagɨt. ");
INSERT INTO yut_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Uŋun da Sabat bɨsapmon amɨn paŋmɨlɨp aban kaŋek gen pikon yɨpneŋ yaŋon da amɨn dɨwarɨ Yesu tebai kaŋek yɨkgwit. ");
INSERT INTO yut_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Aŋakwa Yesu da amɨn kɨsirɨ gɨreŋɨkbi yaŋ iyɨgɨt, “Amɨn da ɨŋamon pɨdaŋ at.” ");
INSERT INTO yut_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pɨdaŋ agakwan mɨŋat amɨnyo yaŋ yoyɨgɨt, “Sabat bɨsap dakon gen teban da yokwi aneŋ do yosok? Bo tagɨ aneŋ do yosok? Amɨn paŋmɨlɨp aneŋ do yosok, bo dapba kɨmotni do yosok?” Yaŋban gen tamoni dɨma iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yaŋ aŋakwa but tebani do butjap nandagɨt. Aŋek butni yokwi taŋban kobok tobɨl tobɨl aŋek pɨndagek amɨn kɨsirɨ gɨreŋɨkbi yaŋ iyɨgɨt, “Kɨsitgo aŋnɨŋnɨŋ a.” Yaŋban amɨn uŋun kɨsirɨ aŋnɨŋnɨŋ aban kɨlek tagɨt. ");
INSERT INTO yut_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Aŋakwan uŋudon gɨn Parisi amɨn kɨŋek Erot dakon amɨn kabɨ uŋun gat muwugek “Niaŋ aŋek aŋatneŋ?” yaŋ do gen paŋkosit awit. ");
INSERT INTO yut_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yaŋ aŋakwa Yesu da paŋdetni tɨmɨkban pakbi ɨdapmon kɨwit. Kɨŋakwa Galili amɨn morapmɨsi da yolgwit. Ae uŋun gɨn dɨma, Judia mɨktɨmon da, ");
INSERT INTO yut_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ae Jerusalem kokup papmon da, ae Idumea mɨktɨmon da, ae Jodan Pakbi usugap tet amɨn, ae Tair ae Saidon kokup tetgɨn do amɨn morapmɨ da Yesu dakon wasok agakni dakon gen bin nandaŋek apgwit. ");
INSERT INTO yut_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Amɨn madepsi apgwit do Yesu da paŋdetni yaŋ yoyɨgɨt, “Amɨn morapmɨsi do gɨtni gɨtni aba kaŋ bot kɨnda aŋnoman aba nak uŋudon mɨlkaŋ wɨgɨkeŋ.” ");
INSERT INTO yut_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesu da sot wudani toŋ morapmɨ paŋmɨlɨp agɨt, uŋun do aŋek sot wudani toŋ amɨn Yesu ɨgayɨk do aŋek ukwayɨt ukwayɨt aŋek Yesu da buron kɨwit. ");
INSERT INTO yut_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kɨŋakwa koŋ uŋun Yesu kaŋek mɨktɨmon gawagek madepsi yaŋ tɨdaŋek yawit, “Gak Piŋkop dakon Monji.” ");
INSERT INTO yut_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mani Yesu da mibɨlni dɨma yaŋ teŋteŋoni do yaŋsop tebaisi aŋyomgut. ");
INSERT INTO yut_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kɨlɨ Yesu pakbi ɨdap yɨpmaŋek ɨleŋ kɨndakon wɨgɨgɨt. Wɨgek yabekbini dagoni do nandagɨt amɨn yoyɨŋban iyɨkon abɨŋ muwukgwit. ");
INSERT INTO yut_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Amɨn 12 uŋun gat egɨpni do yabekbi kabɨni tɨmɨkgɨt. Aŋek yaŋ yoyɨgɨt, “Ji yabekgo kɨŋ Piŋkop gen amɨn yoyɨni, ae koŋ yolni do yaŋ mudaŋ dabo koŋ yolni.” ");
INSERT INTO yut_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yabekbini 12 uŋun dakon mani yaŋ: Saimon (mani kalugɨ Pita yaŋ iyɨgɨt), ");
INSERT INTO yut_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ae Jems, Sebedi dakon monji, ae Jems dakon padɨge Jon (uŋun bamot mani Boanages yaŋ yoyɨgɨt, uŋun dakon mibɨlɨ Kɨrɨrɨŋ Amɨn), ");
INSERT INTO yut_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ae Andru, Pilip, Batolomiu, Matyu, Tomas, Jems Alpius dakon monji, Tadius, Saimon Selot, ");
INSERT INTO yut_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ae Judas Iskariot (uŋun egɨ don Yesu uwalni da kɨsiron yɨpgut). ");
INSERT INTO yut_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Aŋek Yesu yutnon wɨgakwan amɨn kabɨ madepsi aeni uŋudon muwukgwit. Muwugakwa Yesu gat paŋdetni gat jap noni dakon bɨkbɨk dɨma pɨsaŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aŋek dabɨni uŋun bini nandaŋek “Burɨ upbal tak” yaŋ yaŋek yutnikon iyɨŋ aŋaŋ kɨk do apgwit. ");
INSERT INTO yut_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aŋakwa gen teban yoyɨŋdet amɨn Jerusalem kokup papmon da apgwit uŋun da Yesu do yaŋ yawit, “Koŋ dakon amɨn tagɨni Belsebul uŋun da burɨgwan egakwan uŋun dakon tapmɨmon da koŋ yoldak.” ");
INSERT INTO yut_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yaŋba Yesu da paŋmuwugek tɨlak gen kɨnda yaŋ yoyɨgɨt: “Sunduk da Sunduk notni arɨpmɨ dɨma yolyolɨ. ");
INSERT INTO yut_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mɨktɨm kɨnda dakon amɨn da pudaŋ kabɨ bamorɨ aŋek emat wamjil kaŋ, uŋun mɨktɨm tebai dɨma tokdɨsak. ");
INSERT INTO yut_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ae amɨn yurɨ kɨnda dakon amɨn da pudaŋ kɨ kabɨ bamot aŋek emat wamjil kaŋ, uŋun amɨn yut tebai dɨma egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Uŋudeŋ gɨn Sunduk da pudaŋ kɨ kabi bamot aŋek iyɨ emat wamjil kaŋ, amɨn kabɨni tebai dɨma egɨpdaŋ. Yaŋ ani kaŋ pasɨl mudokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Bo namɨn dasi amɨn tebai kɨnda yɨgakwan yutnikon wɨgɨ yo kabɨni gwayeŋ tɨmɨtjak? Uŋun arɨpmɨ dɨma. Mibɨltok tebai kendagek kɨsit kandapmɨyo wamaŋek yo kabɨni tagɨ gwayeni. ");
INSERT INTO yut_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nak asisi dayɨsat, Piŋkop da yokwi mibɨlɨ mibɨlɨ gat ae Piŋkop abɨŋ yɨp do manji gen yogok gat dakon dɨwarɨ tagɨ wɨrɨrɨtjak. ");
INSERT INTO yut_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mani amɨn kɨnda da Telagɨ Wup abɨŋ yɨp do manji gen kɨnda yosak kaŋ, Piŋkop da dɨwarɨni dɨma wɨrɨrɨtjak. Uŋun dɨmasisi, uŋun dɨwarɨni mudok mudogɨ mɨni taŋ wɨgɨkdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Amɨn da Yesu burɨkon koŋ kɨnda egɨsak yaŋ yawit uŋun do aŋek gen uŋun yagɨt. ");
INSERT INTO yut_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Gen yaŋ yoyɨŋakwan meŋi padɨk padɨkni da abɨŋ yomakon agek Yesu yomakon pɨsak do gen yɨpba wɨgɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wɨkwan amɨn Yesu gat yɨkgwit uŋun da yaŋ iyɨwit, “Meŋgo padɨk padɨkgo yomakon da gak do yoŋ.” ");
INSERT INTO yut_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yaŋba yaŋ yoyɨgɨt, “Meŋno padɨk padɨkno uŋun namɨn?” ");
INSERT INTO yut_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yaŋ yaŋek amɨn aŋgwasɨŋek yɨkgwit kabɨkon dabɨl sɨŋtaŋek yagɨt, “Nak dakon meŋno ae padɨk padɨkno oni. ");
INSERT INTO yut_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Piŋkop dakon gen guramɨkgaŋ amɨn uŋun nak dakon meŋno ae padɨk padɨkno ae samɨno kabɨ.” ");
INSERT INTO yut_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Bɨsap kɨndakon pakbi ɨdap ɨleŋɨkon mɨŋat amɨnyo aeni yoyɨŋ dekgɨt. Amɨn madepsi da abɨŋ uŋudon muwugakwa Yesu boron wɨgɨgɨt. Boron yɨgakwan amɨn morap ɨleŋɨkon yɨkgwit. ");
INSERT INTO yut_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yɨgakwa Yesu da tɨlak gen morapmɨ yoyɨŋek kɨnda yaŋ yagɨt, ");
INSERT INTO yut_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nandani! Amɨn kɨnda da jap yet tɨŋtɨŋok do pigaga kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Jap yet tɨŋtɨŋaŋakwan dɨwarɨ da kosiron maŋba mɨnam da abɨŋ nawit. ");
INSERT INTO yut_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Yerɨ dɨwarɨ da mɨktɨm tɨpmɨ toŋ tɨmon mawit. Uŋun kwenjok tawit, do tepmɨ kwawit, mani tɨp kwenon mɨktɨm morapmɨ dɨma, do gelɨ tagɨ dɨma yopba kɨwit. Do gɨldat da wɨŋ pɨndakban alek tawit. ");
INSERT INTO yut_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ae jap yet dɨwarɨ da joŋ kelɨ toŋ tɨmgwan mawit. Uŋun joŋ kelɨ toŋ gat kɨsi kwaŋek wutjɨŋba kɨmak mudawit. ");
INSERT INTO yut_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ae jap yet dɨwarɨ mɨktɨm nelagɨ toŋ uŋudon maŋ kwawit. Dɨwarɨ bamɨ 100, ae dɨwarɨ bamɨ 60, ae dɨwarɨ bamɨ 30 tawit.” ");
INSERT INTO yut_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Gen uŋun yaŋek aeni saŋbeŋek yaŋ yagɨt, “Gen on nandak do galak toŋ amɨn ji pakyaŋsi nandaŋek mibɨlɨ nandaŋ pɨsoni.” ");
INSERT INTO yut_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Amɨn kabɨ madep kɨŋakwa iyɨ dakon paŋdetni 12 kabɨ gat ae amɨn dɨwarɨ gat da tɨlak gen dakon mibɨlɨ nandak do iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iyɨŋba yagɨt, “Piŋkop dakon Amɨn Kɨla Agakni dakon gen pasɨlɨ uŋun dakon mibɨlɨ ji baŋ dayɨŋ teŋteŋosot. Mani Piŋkop dɨma nandaŋ ɨmɨŋek waŋga ekwaŋ amɨn tɨlak gen gɨn nandaŋ. ");
INSERT INTO yut_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Uŋun dabɨl da yo asat uŋun pɨndakgaŋ mani mibɨlɨ dɨma nandaŋ, ae geno nandaŋ, mani mibɨlɨ dɨma nandaŋ pɨsoŋ. Do Piŋkop da dɨwarɨni wɨrɨrɨk yomjak do but tobɨl ak do dɨma nandaŋ.’ ” ");
INSERT INTO yut_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yaŋ yaŋek yagɨt, “Tɨlak gen yat dakon mibɨlɨ dɨma nandaŋ kaŋ, tɨlak gen dɨwarɨ yoko niaŋ aŋek nandaŋ pɨsoni? ");
INSERT INTO yut_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Amɨn jap yet tɨŋtɨŋosok uŋun Piŋkop gen tɨŋtɨŋosok. ");
INSERT INTO yut_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Amɨn Piŋkop gen nandaŋek butni dɨma pɨsoŋ uŋun jap yet kosiron mawit uŋuden. Sunduk da abɨŋ gen tagɨ butnikon toŋ uŋun gwayeŋ paŋkɨsak. ");
INSERT INTO yut_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Amɨn dɨwarɨ mɨktɨm tɨpmɨ toŋ tɨm yombem, uŋun amɨn Piŋkop gen nandaŋek but galagon da abɨdoŋ. ");
INSERT INTO yut_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mani butnikon gelɨ tagɨ dɨma yɨpban kɨgɨt do bɨsap pɨsɨpmɨsok akgaŋ. Jɨgɨ mibɨlɨ mibɨlɨ ae Piŋkop dakon gen dakon uwal apni bɨsapmon nandaŋ gadatni yopba wɨtdal kɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ae amɨn dɨwarɨ mɨktɨm nap kelɨ toŋ tɨm yombem. Uŋun Piŋkop gen nandaŋ, ");
INSERT INTO yut_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mani nandak nandakni mɨktɨm dakon yo morap do nandaŋ, ae moneŋ paŋmuwut dakon galaktok da Piŋkop gen wɨtjɨŋba bamɨ dɨma tosok. ");
INSERT INTO yut_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ae amɨn dɨwarɨ mɨktɨm nelagɨ toŋ tɨm yombem, uŋun amɨn Piŋkop gen nandaŋek abɨdoŋ. Uŋun amɨn bamɨ 100, ae kɨnda bamɨ 60, ae kɨnda bamɨ 30, yaŋ taŋ taŋ aŋ.” ");
INSERT INTO yut_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Gen kɨnda saŋbeŋek yaŋ yoyɨgɨt, “Namɨn da lam koleŋek kwoba naŋ gap asak, bo pɨgat kagagwan yɨpjak? Dɨmasi, tamonikon yɨpno teŋteŋosok. ");
INSERT INTO yut_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yo pasɨlɨ toŋ ae yo wɨtjɨŋbi da toŋ uŋun kɨsi teŋteŋɨkon tokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Gen on nandak do galak toŋ amɨn ji pakyaŋsi nandaŋek mibɨlɨ nandaŋ pɨsoni.” ");
INSERT INTO yut_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yaŋ yaŋek yagɨt, “Ji gen uŋun nandaŋ uŋun pakyaŋsi nandani. Ji Piŋkop dakon gen nandaŋek guramɨtni kaŋ, Piŋkop da saŋbeŋek damdɨsak. Mani geni dɨma nandani kaŋ, saŋbeŋek dɨma damdɨsak. ");
INSERT INTO yut_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nak dakon gen nandaŋek burɨkon yɨpmaŋdak uŋun amɨn Piŋkop da saŋbeŋek nandak nandak ɨmdɨsak. Mani geno nandaŋek burɨkon dɨma yɨpmaŋdak uŋun amɨn geno dɨwarɨ nandagɨt uŋun pasɨl ɨmdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu da saŋbeŋek yaŋ yagɨt, “Piŋkop da Amɨn Kɨla Asak uŋun dakon mibɨlɨ nandani do tɨlak gen kɨnda gat dayɨko nandani. Amɨn kɨnda jap yet pigaga tɨŋtɨŋosok. ");
INSERT INTO yut_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kalbi dɨpmɨn pokdok ae gɨldat kalba waŋga waŋga agakwan jap yet kwoŋ. Mani niaŋsi aŋek kwoŋ uŋun dakon mibɨlɨ dɨma nandɨsak. ");
INSERT INTO yut_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mɨktɨm da iyɨ upmagakwan gɨgɨ wɨŋ tamɨ yopmaŋek bamɨ toŋ. ");
INSERT INTO yut_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bamɨ taŋakwa pi ami da bamɨ pasak.” ");
INSERT INTO yut_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu da saŋbeŋek yaŋ yagɨt, “Piŋkop da Amɨn Kɨla Asak uŋun dakon mibɨlɨ yo nikon tɨlak ako nandani? ");
INSERT INTO yut_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Uŋun mastat yet yombem. Mastat dakon yerɨ uŋun jap yet kɨsi morap dakon pɨŋbi, monɨŋɨsisok. ");
INSERT INTO yut_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mani mɨktɨmon kwaotno madepsi kwosok. Jap dɨwarɨ dakon tagok tagokni uŋun yapmaŋ mudosok. Kɨlɨŋɨ madep yopban kɨŋakwa mɨnam morapmɨ da paŋabɨŋ uŋun da yoŋgamgwan yɨkgaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu da nandak nandakni da arɨpmon Piŋkop dakon gen yoyɨŋek tɨlak gen uŋuden morapmɨ yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Amɨn madep kabɨkon Piŋkop gen tɨlak genon dagɨn yoyɨgɨt. Mani paŋdetni gat egek tɨlak gen dakon mibɨlɨ yoyɨŋ teŋteŋagɨt. ");
INSERT INTO yut_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Uŋun gɨldat da pɨlɨn pɨlɨndo Yesu boron yɨgek paŋdetni yaŋ yoyɨgɨt, “Pakbi ɨdap terɨ kɨnda do kɨno.” ");
INSERT INTO yut_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yaŋ yaŋban paŋdetni amɨn kabɨ madep yopmaŋ degek boron wɨkwa paŋdetni gat kɨsi kɨwit. Ae bot dɨwarɨ gat kɨsi kɨwit. ");
INSERT INTO yut_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kɨŋakwa mɨrɨm madep aŋek pakbi tamalɨgakwan boron pɨgɨwit. Pɨgɨ tugaŋban bot pakbigwan pɨgɨk do agɨt. ");
INSERT INTO yut_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Aŋakwan Yesu bot buŋɨkon busuŋ kɨdɨŋ kɨndakon wɨtjɨŋek dɨpmɨn pagakwan paŋdetni da aŋyolek iyɨwit, “Yoyɨŋdet, nin pakbi naŋ kɨmotneŋ do nandabɨ yo ɨsalɨ asak?” ");
INSERT INTO yut_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yaŋ iyɨŋba Yesu da pɨdaŋ agek mɨrɨm gat ae pakbi gat tebai yoyɨŋek yagɨt, “Yawokgɨl!” Yaŋban mɨrɨm yawogakwan pakbi wayɨŋ dɨmasi agɨt. ");
INSERT INTO yut_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aŋek paŋdetni yaŋ yoyɨgɨt, “Ji nido pasolgoŋ? Sigɨn dɨma nandaŋ gadaŋ namaŋ, ma?” ");
INSERT INTO yut_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yaŋban paŋdetni si pasalek iyɨ gɨn yawit, “On niaŋen amɨn kɨnda da mɨrɨm ae pakbiyo yoyɨŋban geni guramɨkgamal?” ");
INSERT INTO yut_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu gat paŋdetni gat pakbi ɨdap terɨ kɨnda Gerasa amɨn da mɨktɨmon kɨwit. ");
INSERT INTO yut_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Boron da pɨŋakwan, amɨn kɨnda koŋni toŋ uŋun da amɨn kɨmakba paŋkɨ tɨp kɨnamgwan yopmaŋgaŋ mɨktɨmon da abɨŋ altaŋ ɨmgut. ");
INSERT INTO yut_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Amɨn uŋun amɨn da kɨsitni ae kandapmɨyo nap teban naŋ wamwamɨ dakon arɨp dɨma agɨt. ");
INSERT INTO yut_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Amɨn da bɨsapmɨ bɨsapmɨ kɨsit kandapyoni wamgwit, mani uŋun amɨn tebai do nap teban si paŋdagagɨt. Amɨn da arɨpmɨ dɨma abɨdogɨ. ");
INSERT INTO yut_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Uŋun pɨlɨn kaga ae gɨldat kalba amɨn kɨmakba yopmaŋgaŋ mɨktɨmon ae kabapmon egek madepsi yaŋ tɨdaŋek gɨptɨmɨ tɨpbaŋ mandagɨt. ");
INSERT INTO yut_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yesu dubagɨkon akban kaŋek tɨmtɨm yaŋek Yesu da buron kɨŋ gawak ɨmgut. ");
INSERT INTO yut_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Aŋek yaŋ tɨdaŋek yaŋ iyɨgɨt, “Yesu, Piŋkop Wɨkwisi dakon Monji, gak niaŋsi aŋnam do abɨsal? Piŋkop da manon tepmɨ pi dɨma nabi do yaŋ teban ta.” ");
INSERT INTO yut_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Uŋun da yaŋ yagɨt, nido Yesu da yaŋ iyɨgɨt, “Koŋ gak on amɨn yɨpmaŋ degek wɨŋ kɨ!” ");
INSERT INTO yut_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yaŋban Yesu da aŋtobɨlek iyɨgɨt, “Mango namɨn?” Yaŋ iyɨŋban yagɨt, “Nak mano Amɨn Kabɨ Madep. Nin morapmɨ da ekwamaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Yaŋ yaŋek bɨsit tebai saŋbek saŋbek iyɨwit, “Nin nolbɨ on mɨktɨm tɨm dɨma yɨpmaŋ detneŋ.” ");
INSERT INTO yut_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mɨktɨm uŋun da ɨleŋon bɨt kabɨ madep jap naŋek egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Koŋ uŋun Yesu da nandaŋ yoban bɨt da butgwan pɨgɨni do bɨsit tebai iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yaŋba Yesu da nandaŋ yoban koŋ da amɨnon da wɨŋek bɨt da butgwan pɨgɨwit. Pɨgakwa bɨt uŋun pasal abɨgɨŋek pakbi ɨdap tagɨt uŋungwan pɨgek kɨmakgwit. Bɨt kaloŋɨsok dɨma, 2 tausen da kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kɨmagakwa bɨt dakon kɨla amɨn da kokup kapmat tagɨt ae mɨktɨm dɨwarɨkon kɨŋ yo uŋun noman tawit dakon gen bin yoyɨwit. Yoyɨŋba amɨn da yo noman tagɨt uŋun kok do aŋek abɨŋ mudawit. ");
INSERT INTO yut_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesukon abɨŋek amɨn koŋni morapmɨ gat egɨpgut uŋun burɨ pɨsagɨt ae ɨlɨkba pɨgɨkni toŋ da yɨkban kawit. Yaŋ yɨkban kaŋ pasalgwit. ");
INSERT INTO yut_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yo dabɨl da kaŋ nandaŋyo awit amɨn uŋun da koŋ gat egɨpgut amɨn gat ae bɨt kabɨ dakon gen bin gat kɨsi amɨn yoyɨŋ mudawit. ");
INSERT INTO yut_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Gen uŋun nandaŋ mudaŋek Yesu mɨktɨm uŋun yɨpmaŋ kɨsak do tebai iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iyɨŋba nandaŋek Yesu uŋun boron wɨgakwan amɨn koŋ gat egɨpgut uŋun da Yesu yol do bɨsit tebai iyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tebaisi iyɨŋban kɨrɨŋɨk ɨmɨŋek yaŋ iyɨgɨt, “Gak yutgokon kɨŋ Amɨn Tagɨ da gak do bupmɨ nandaŋek wasok madep ak uŋun dakon gen bin yawi dɨwat kabɨgo yoyɨŋ mudoki.” ");
INSERT INTO yut_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yaŋban amɨn uŋun kɨŋ Yesu da yo agɨt uŋun dakon gen bin Dekapolis mɨktɨm uŋudon amɨn yoyɨŋban nandaba ŋwakŋwarɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu uŋun boron wɨgek pakbi ɨdap terɨ kɨnda do wɨgakwan amɨn morapmɨsi abɨŋ muwukgwit. ");
INSERT INTO yut_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Muwugakwa Juda amɨn dakon muwut muwut yut dakon kɨla amɨn kɨnda mani Jairus, uŋun da abɨŋ Yesu kaŋek burɨkon kɨŋek gawak ɨmgut. ");
INSERT INTO yut_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Aŋek si aŋpulugosak do madepsi yaŋ iyɨgɨt, “Gwano kɨmotdɨsak, do abɨŋek kɨsitgo da wɨtjɨŋbɨ kɨlek taŋek egɨpjak.” ");
INSERT INTO yut_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iyɨŋban nandaŋek Yesu gat kɨgɨmal. Kɨŋakwal amɨn morapmɨ da yolek gadat gadat tebaisi awit. ");
INSERT INTO yut_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aŋakwa binapnikon mɨŋat kɨnda akgɨt, uŋun dagaŋ mok aŋek yawini maŋakwa egakwan bɨlak 12 agɨt. ");
INSERT INTO yut_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Aŋakwan wuda wamak morapmɨ da aŋpulugok do pi aŋtɨdok aŋakwa tepmɨ madepsi nandaŋek egɨpgut. Wuda wamak yumaŋ nok do aŋek moneŋni kɨsi yomɨŋ mudagɨt. Aban sotni dɨma tagap tagɨt, si madep tagɨt. ");
INSERT INTO yut_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Aban mɨŋat uŋun da Yesu dakon bin nandaŋek, mɨŋat amɨn dɨwarɨ uŋun da bɨkbɨgon egek manjikon kɨŋek ɨlɨkba pɨgɨknikon ɨgayɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ɨgayɨŋek yaŋ nandagɨt, “Ɨlɨkba pɨgɨknikon ɨgayɨkeŋ kaŋ, kɨlek tokeŋ.” ");
INSERT INTO yut_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yaŋ nandaŋek ɨgayɨŋban uŋudon gɨn yawini jɨptaŋban gɨptɨmɨ kɨlek taŋban nandagɨt. ");
INSERT INTO yut_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aban Yesu uŋun tapmɨmni abɨkwa nandaŋek tobɨlek yaŋ yagɨt, “Ɨlɨkba pɨgɨkno namɨn da ɨgayɨsak?” ");
INSERT INTO yut_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yaŋban paŋdetni da yaŋ iyɨwit, “Amɨn da gadat gadat tebaisi aŋakwa namɨn da ɨgayɨŋ namɨsak yaŋ nido yosol?” ");
INSERT INTO yut_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mani Yesu uŋun amɨn ɨgayɨŋ ɨmgut uŋun kok do sigɨn wɨsɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mɨŋat uŋun gɨptɨmɨkon wasok noman tagɨt uŋun nandaŋek burɨ sugaŋban nɨmnɨmɨgek Yesu da buron gawak ɨmɨŋek mibɨlni yaŋ teŋteŋagɨt. ");
INSERT INTO yut_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Mibɨlni yaŋ teŋteŋaŋban Yesu da yaŋ iyɨgɨt, “Gwano, nandaŋ gadatgo da gak aŋkɨlek ak. Uŋun do butgo yaworɨ taŋakwan kɨki. Sotgo kɨlɨ pasɨlak.” ");
INSERT INTO yut_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu gen yaŋ iyɨŋakwan, muwut muwut yutni dakon kɨla amɨn Jairus da yutnon da amɨn dɨwarɨ da abɨŋ Jairus yaŋ iyɨwit, “Gwago kɨlɨ kuŋwak, uŋun do nido yoyɨŋdet ɨsal dogɨn jɨgɨ ɨmɨsal?” ");
INSERT INTO yut_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yaŋba Yesu da gen uŋun nandagɨt, mani dɨma nandabi wup agɨt. Aŋek kɨla amɨn yaŋ iyɨgɨt, “Dɨma pasolgi. Ɨsal nandaŋ gadat aki.” ");
INSERT INTO yut_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yaŋ yaŋek mɨŋat amɨnyo dɨwarɨ yopmaŋek, Pita, Jems ae padɨge Jon uŋun baŋgɨn tɨmɨkban kɨwit. ");
INSERT INTO yut_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kɨŋ kɨla amɨn da yomakon altaŋek amɨn da upbalap madep ae gen kunamyo aŋakwa pɨndak nandaŋyo agɨt. ");
INSERT INTO yut_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Aŋek yutnon wɨgek amɨn yaŋ yoyɨgɨt, “Ji nido kunam kugɨyo madepsi aŋ? Mɨŋatjok uŋun dɨma kuŋwak, uŋun ɨsal dɨpmɨn pokdok.” ");
INSERT INTO yut_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yesu da yaŋ yaŋban nandaŋek jɨkgo yanjaŋ ɨmgwit. Yaŋ aba yoyɨŋban yomakon pɨgɨ mudaŋakwa, mɨŋatjok dakon meŋi datniyo ae paŋdetni tɨmɨkban mɨŋatjok pakgɨron wɨgɨwit. ");
INSERT INTO yut_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wɨgɨ mɨŋatjok kɨsirɨkon abɨdaŋek iyɨgɨt, “Talita kum!” (Uŋun dakon mibɨlɨ, “Mɨŋatjok pɨdoki do gayɨsat!”) ");
INSERT INTO yut_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Yaŋban uŋudon gɨn mɨŋatjok pɨdaŋek kɨŋ ap aban kaŋek yaŋ kɨmakgwit. (Mɨŋatjok bɨlakni 12 kabɨ.) ");
INSERT INTO yut_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Aŋakwa Yesu da amɨn dɨma yoyɨni do yaŋsop tebaisi aŋyomgut. Aŋek mɨŋatjok jap ɨmɨŋba nosak do yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Aŋakwa Yesu uŋun kokup yɨpmaŋek, kokupnikon kɨŋakwan paŋdetni yolgwit. ");
INSERT INTO yut_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Paŋkɨ egek Sabat bɨsapmon Juda amɨn da muwut muwut yutnon wɨgɨ Piŋkop gen yoyɨgɨt. Aŋakwan amɨn morapmɨ Piŋkop dakon gen nandaŋek yɨkgwit amɨn uŋun tamtam yaŋek yaŋ yawit, “Yo uŋun dukon tɨmɨkgɨt? Nandaŋ kokwin tagɨsi gat ae wasok tapmɨmɨ toŋ agak uŋun namɨnon tɨmɨkgɨt? ");
INSERT INTO yut_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Uŋun kɨsit kɨlda kɨnda, Maria dakon monji. Padɨk padɨkni uŋun Jems, Josep, Judas ae Saimon. Ae samɨni binapninon ekwaŋ.” Yaŋ yaŋek ɨŋtaŋ ɨmɨŋek nandaba pɨŋban ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yaŋ nandaŋek egakwa Yesu da yaŋ yoyɨgɨt, “Kombɨ amɨn kɨnda man bini mɨktɨm dɨwarɨkon toŋ, mani iyɨ da kokupmon yawi dɨwatni gat ae yutnikon amɨn gat da mani dɨma aŋenokgoŋ.” ");
INSERT INTO yut_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Uŋudon wasok tapmɨmɨ toŋ ak do aŋtɨdok agɨt. Uŋun yum amɨn sotni toŋ kaloŋɨsok dɨ baŋ kɨsitni kwenikon wɨtjɨŋek paŋmɨlɨp agɨt. ");
INSERT INTO yut_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aŋek nandaŋ gadatni mɨni do, uŋun do nandaban ŋwakŋwarɨsi agɨt. Yaŋ nandaŋek kokup taŋ aŋaŋ kɨwit uŋudon kɨŋ Piŋkop dakon gen yoyɨŋ dekgɨt. ");
INSERT INTO yut_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu paŋdetni 12 kabɨ yaŋ yoban opba, bamot bamot Piŋkop dakon gen yoni do yabekgɨt. Yabegek koŋ yolni do yaŋ mudaŋ yomɨŋek yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“Ji yo dɨwarɨ dɨ dɨma paŋek kɨni, wɨn kɨrɨŋ baŋgɨn pabɨdaŋek kɨni. Jap bo yɨk bo moneŋyo dɨma paŋek kɨni. ");
INSERT INTO yut_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kandap gwɨl paŋek agɨpni, aŋek paba pɨgɨk kaloŋɨ gɨn ɨlɨkba pɨgɨsak. ");
INSERT INTO yut_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kokup kɨndakon kɨŋ yut kɨndakon gɨn yɨgek pɨŋ kɨni. ");
INSERT INTO yut_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kokup kɨndakon kɨŋ altaŋba not dɨma aŋdamɨŋek genji dɨma nandaŋek manji damni kaŋ, kandapjikon kɨmbabaŋ toŋ uŋun kokup yɨp do aŋek tɨdaŋba kɨni. Yaŋ aŋakwa uŋun kokup amɨn da ‘Geni dɨma nandamaŋ, uŋun do aŋ’ yaŋ nandani.” ");
INSERT INTO yut_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yaŋ yaŋban paŋdetni da kɨŋek amɨn but tobɨl ani do yoyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yaŋ yoyɨŋek koŋ morapmɨ yol yomɨŋek sot amɨn morapmɨ bɨt nelak soŋ yoba kɨlek tawit. ");
INSERT INTO yut_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesu dakon man bin ɨreŋ taŋban kɨla amɨn madep Erot uŋun kɨsi da nandagɨt. Amɨn dɨwarɨ da Yesu do yaŋ yawit, “Jon Telagɨ Pakbi Sogok Amɨn uŋun kɨmoron da pɨdagɨt, aŋek wasok tapmɨmɨ toŋ agak dakon tapmɨm taŋ ɨmɨsak” yaŋ yawit. ");
INSERT INTO yut_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yaŋ yaŋakwa amɨn dɨwarɨ da yawit, “Uŋun Elaija.” Ae dɨwarɨ da yawit, “Uŋun kombɨ amɨn kɨnda, kombɨ amɨn kalɨp egɨpgwit uŋuden amɨn kɨnda.” ");
INSERT INTO yut_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mani Erot uŋun nandaŋek yagɨt, “Kalɨp nak da Jon dakon tegɨ mandaŋ dagagɨm, uŋun amɨn dasi kɨmoron da pɨdagɨt.” ");
INSERT INTO yut_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kalɨp Erot da padɨge Pilip dakon mɨŋatni Erodias tuwɨl pagɨt. Aban Jon da Erot yaŋ iyɨgɨt, “Gak gen teban yapmaŋek padɨgɨgo dakon mɨŋatni tuwɨl pal. Uŋun tagɨ dɨma.” Gen uŋun nandaŋek Erot da obip amɨni yabekban kɨŋ Jon abɨdaŋek nap teban naŋ wamaŋ dam tebanon yɨpgwit. ");
INSERT INTO yut_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jon da gen yaŋ yaŋban Erodias da Jon do nandaban yokwi taŋban aŋakba kɨmotjak do si nandagɨt. Mani arɨpmɨ dɨma, ");
INSERT INTO yut_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","nido Erot da Jon do pasalek yaŋ nandagɨt, “Jon uŋun amɨn kɨlegɨ ae telagɨsi.” Yaŋ nandaŋek si aŋkutnagɨt. Erot da Jon dakon gen nandaŋek but morap agɨt, mani geni nandak do galak tagɨt. ");
INSERT INTO yut_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Buŋon Erodias da Jon aŋakba kɨmotjak uŋun dakon kosit kagɨt. Altok altok bɨsapnikon Erot da jap noknok ak do amɨn madep paŋmuwukgɨt. Gapman dakon pi amɨn madep ae emat amɨn dakon mibɨltok amɨni ae Galili mɨktɨm dakon kɨla amɨn kɨsi paŋmuwukgɨt. ");
INSERT INTO yut_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Jap naŋ yɨgakwa Erodias dakon gwi da paŋabɨŋ ɨŋamnikon kap agɨt. Aban Erot ae amɨn jap nawit uŋun kɨsi da kaŋ galak tawit. Kaŋ galak taŋ Erot da mɨŋat gɨmoŋ yaŋ iyɨgɨt, “Ni yo do galak tosol uŋun nayɨŋbɨ tagɨ gabeŋ.” ");
INSERT INTO yut_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yaŋ yaŋek yaŋ teban tok gen kɨnda yaŋ yagɨt, “Yo nido nayɨki, tagɨ gabeŋ. Mɨktɨmno terɨ kɨnda pɨdaŋ gak do tagɨ gabeŋ.” ");
INSERT INTO yut_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yaŋban mɨŋat gɨmoŋ uŋun da waŋga kɨŋ meŋi yaŋ iyɨgɨt, “Ni yo naŋ namjak do iyɨkeŋ?” Yaŋban iyɨgɨt, “Kɨŋ Jon Telagɨ Pakbi Sogok Amɨn uŋun dakon busuŋɨ uŋun do iyɨki.” ");
INSERT INTO yut_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Meŋi yaŋ yaŋban mɨŋat gɨmoŋ uŋun tepmɨ wɨgek Erot yaŋ iyɨgɨt, “Jon Telagɨ Pakbi Sogok Amɨn dakon busuŋɨ abɨsok gɨn ɨdapmon yɨpmaŋ nabi.” ");
INSERT INTO yut_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Gen yaŋ yaŋban Erot burɨ wagɨl yokwi tagɨt. Mani amɨn jap nawit uŋun da ɨŋamon yaŋ teban tok gen yagɨt uŋun kɨrɨŋɨt do mayak taŋek gen yagɨt uŋun dɨma kɨrɨŋɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Uŋudon gɨn emat amɨn kɨnda Jon dakon busuŋɨ aŋopjak do yabekgɨt. Yabekban uŋun da kɨŋ dam teban yutnon wɨgɨ Jon dakon tegɨ mandaŋ dagagɨt. ");
INSERT INTO yut_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mandaŋ dagaŋ ɨdapmon yɨpmaŋ aŋabɨŋ mɨŋatjok uŋun do ɨban aŋkɨ meŋi do ɨmgut. ");
INSERT INTO yut_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aŋakwan Jon dakon paŋdetni gen bini nandaŋek kɨŋ bumjotni abɨdaŋ aŋkɨ tɨp kɨnamon yɨpgwit. ");
INSERT INTO yut_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Don yabekbi kabɨ da abɨŋ Yesu aŋgwasɨŋek yo awit ae Piŋkop gen yawit uŋun dakon geni iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Iyɨŋ mudaŋba amɨn morapmɨsi kɨŋ abɨŋ abɨŋ aŋakwa Yesu gat yabekbi kabɨni gat jap noknok dakon bɨkbɨk dɨma pɨsaŋ yomgut. Aban Yesu da yabekbi kabɨni yaŋ yoyɨgɨt, “Opba mɨktɨm amɨn dɨma ekwaŋ tɨmon kɨno. Uŋudon egek tapmɨm pani.” ");
INSERT INTO yut_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yaŋ yaŋek boron wɨgek mɨktɨm amɨn da dɨma ekwaŋ tɨmon kɨwit. ");
INSERT INTO yut_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mani amɨn morapmɨ da uŋudon kwaŋ yaŋ pɨndak nandaŋyo awit. Yaŋ nandaŋek kokup morapni yopmaŋ yopmaŋ aŋek amɨn morapmɨ mɨktɨm kosit tɨmtɨm yaŋek uŋun da kalɨp kɨŋ altawit. ");
INSERT INTO yut_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kɨŋ altaŋakwa Yesu boron da ɨleŋɨkon obɨŋek amɨn morapmɨsi pɨndagek sipsip kɨla amɨni mɨni yombem da egɨpgwit, do bupmɨsi nandaŋ yomgut. Yaŋ nandaŋek uŋudon gɨn wasaŋek Piŋkop gen morapmɨ yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Piŋkop dakon gen yoyɨŋakwan pɨlɨn pɨlɨndo paŋdetni da abɨŋ Yesu yaŋ iyɨwit, “Mɨktɨm amɨn dɨma ekwaŋon ekwamaŋ, ae gɨldat kɨlɨ pɨgɨkdɨsak, ");
INSERT INTO yut_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","do yoyɨŋbɨ amɨn kabɨ madep kokup monɨŋ monɨŋ ae kokup terɨ dɨŋgwan kɨŋek jap yumaŋ noni.” ");
INSERT INTO yut_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Iyɨŋba yagɨt, “Disi jap yoba noni.” Yaŋban paŋdetni da yaŋ iyɨwit, “Amɨn morapmɨsi ekwaŋ, do moneŋ 200 danari baŋ jap yumneŋ kaŋ arɨpmɨ asak. Yaŋ aneŋ do yosol, ma?” ");
INSERT INTO yut_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yaŋba yoyɨgɨt, “Disikon bret niaŋ da toŋ. Kɨŋ pɨndakgɨt.” Kɨŋ pɨndak abɨŋ yaŋ iyɨwit, “Bret kɨsit kɨnda, ae tap kɨlap bamorɨ yaŋ gɨn taŋ nimaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yaŋ yaŋba Yesu da yoyɨŋban paŋdetni da amɨn kɨsisi kosirɨ kosirɨ joŋ tɨmon yɨtni do yoyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kosirɨ kɨnda 50 ae kosirɨ kɨnda 100 yaŋ yɨk aŋaŋ kɨwit. ");
INSERT INTO yut_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yɨk mudaŋba bret kɨsit kɨnda ae tap kɨlap bamot uŋun gat tɨmɨgek Kwen Kokup sɨŋtaŋek gɨsamɨkgɨt. Gɨsamɨgek bret jokgal paŋdetni do yoban uŋun da amɨn do kokwinɨk yomgwit. Ae tap kɨlap yaŋ gɨn kokwinɨk paŋdetni do yoban uŋun da amɨn do yomgwit. ");
INSERT INTO yut_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Yoba tɨmɨgek amɨn kɨsisi jap arɨpmɨsi nawit. ");
INSERT INTO yut_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Naŋba arɨpmɨ aŋakwan bret dɨwat ae tap kɨlap dɨwat tawit uŋun paŋdetni da yɨk madepsi 12 kabɨ sɨmɨlba tugawit. ");
INSERT INTO yut_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Amɨn jap nawit uŋun 5 tausen yaŋ da nawit. ");
INSERT INTO yut_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Uŋudon gɨn Yesu da paŋdetni yoyɨŋban boron wɨgek Betsaida kokupmon mibɨl taŋ kɨŋakwa Yesu da amɨn kabɨ madep uŋun yoyɨŋban waseŋ kɨwit. ");
INSERT INTO yut_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yoyɨŋban kɨŋakwa iyɨ bɨsit pi ak do kabapmon wɨgɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pɨlɨn pɨlɨndo bot pakbi ɨdap binapmon taŋakwan Yesu iyɨ gɨn tap kɨdɨpmɨŋon egɨpgut. ");
INSERT INTO yut_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Egakwan mɨrɨm madep aŋakwan paŋdetni pakbi wayɨt do aŋtɨdok aŋakwa pɨndakgɨt. Yaŋ pɨndagek wɨsa wɨsa do pakbi ɨdapmon bamaŋ bamaŋ kɨŋek kɨŋ paŋdetni yap do agɨt. ");
INSERT INTO yut_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pakbi ɨdap kwenon kɨŋakwan kaŋek paŋdetni kɨsi da yaŋ nandawit, “Koŋ kɨnda da abɨsak!” ");
INSERT INTO yut_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yaŋ nandaŋek madepsi pasalek yaŋ tɨdawit. Mani uŋudon gɨn Yesu da yaŋ yoyɨgɨt, “Ji teban taŋek atni. Nak naga obɨsat. Dɨma pasolni.” ");
INSERT INTO yut_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yaŋ yaŋek boron wɨgakwan mɨrɨm yawokgɨt. Yawogakwan paŋdetni da tamtamsi yawit. ");
INSERT INTO yut_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nido Yesu da mɨŋat amɨnyo do bret kokwinɨk yomgut uŋun dakon mibɨlɨ dɨma nandawit. But nandak nandakni dɨma pɨsaŋakwan egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pakbi ɨdap terɨ kɨnda Genesaret mɨktɨmon wɨgek bot ɨleŋɨkon aŋteban awit. ");
INSERT INTO yut_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Aŋteban aŋek bot yɨpmaŋek pɨgakwa uŋudon gɨn mɨŋat amɨnyo da Yesu kaŋ nandaŋyo awit. ");
INSERT INTO yut_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Yaŋ kaŋ nandaŋyo aŋek tɨmtɨm yaŋek kokupmɨ kokupmɨ kɨŋ yoyɨŋba sotni toŋ amɨn wayɨk wamaŋek Yesu dukwan dukwan egɨpgut uŋudon paŋkɨwit. ");
INSERT INTO yut_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Aŋek kokup pap bo kokup monɨŋ ae dukwan dukwan kɨgɨt amɨn da sot amɨn muwut muwut tamokon uŋudon paŋabɨŋ yopgwit. Aŋek paba pɨgɨk dɨwatnikon ɨgayɨni do bɨsit tebai iyɨwit. Yaŋ ɨgayɨwit amɨn uŋun kɨlek taŋ mudawit. ");
INSERT INTO yut_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisi amɨn gat gen teban yoyɨŋdet amɨn gat Jerusalem kokup papmon da obɨŋ Yesu aŋgwasɨŋek muwukgwit. ");
INSERT INTO yut_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Muwugek paŋdet kabɨnikon da dɨwarɨ kɨsitni dɨma sugaŋek jap ɨsal tɨmɨk naŋyo aba pɨndakgwit. ");
INSERT INTO yut_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisi amɨn ae Juda amɨn kɨsisi babɨkni dakon gen teban yolek kɨsirɨ sugaŋek gɨn jap naŋ naŋ aŋ. ");
INSERT INTO yut_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ae maket tamokon da tobɨlek obɨŋ yaŋ gɨn kɨsirɨ sugaŋek jap noŋ. Uŋun gɨn dɨma, gen teban morapmɨ yolek kap, kwoba, ɨdapyo kɨsi sugoŋ. ");
INSERT INTO yut_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yaŋdo, Parisi amɨn ae gen teban yoyɨŋdet amɨn da Yesu yaŋ iyɨwit, “Nido paŋdetgoni uŋun babɨk dakon gen teban yapmaŋek kɨsirɨ dɨma sugaŋek jap noŋ?” ");
INSERT INTO yut_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yaŋba aŋtobɨlek yoyɨgɨt, “Piŋkop da kombɨ amɨn Aisaia dakon nandak nandakni aŋtagap aban jamba but amɨn ji do gen yaŋ mandagɨt: ‘Uŋun amɨn kabɨ gen kaga dagɨn nak man madep namaŋ, mani but dasi nak dɨma nandaŋ namaŋ. ");
INSERT INTO yut_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Iyɨ dakon gen teban do, “On uŋun Piŋkop dakon gen” yaŋ yaŋek amɨn yoyɨŋ dekgaŋ. Nak gawak namaŋ uŋun koko yo ɨsalɨ asak.’ ");
INSERT INTO yut_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ji Piŋkop dakon gen teban yɨpmaŋek babɨkji dakon gen paŋteban aŋek paŋ ekwaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu da saŋbeŋek yaŋ yagɨt, “Ji Piŋkop dakon gen teban yum pɨndagek dɨsi dakon yaŋ teban tok gen guramɨkgaŋ. ");
INSERT INTO yut_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses da kalɨp yaŋ mandagɨt: ‘Ji meŋ datyo dakon pɨŋbi egek geni guramɨtni’, ae ‘Amɨn kɨnda da meŋ datyo do gen yokwi kɨnda yosak kaŋ, uŋun amɨn si aŋakba kɨmotjak.’ ");
INSERT INTO yut_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mani dɨsi Moses dakon gen maba kwanek yaŋ yoŋ, ‘Amɨn kɨnda da meŋi bo datni yaŋ iyɨsak, “Nak yo on kɨlɨ Piŋkop do manjɨgɨm. Dɨma tam tagɨ paŋpulugokom.” ’ ");
INSERT INTO yut_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yaŋ yaŋek meŋi ae datni dɨma paŋpulugosok. Aŋek ji da uŋun amɨn do yaŋ yoŋ, ‘Uŋun amɨn tagɨ asak nido yo uŋun Piŋkop do kɨlɨ manjɨgɨt.’ ");
INSERT INTO yut_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ji yaŋ aŋek babɨkji dakon yaŋ teban tok gen guramɨgek Piŋkop dakon gen maba kɨsak. Ae uŋun gɨn dɨma, yo morap dɨwarɨ kɨsi yaŋ gɨn aŋ.” ");
INSERT INTO yut_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu da aeni amɨn yaŋ ɨlɨkban apba yoyɨgɨt, “Gen dayɨko ji morap kɨsi da mɨrak yopmaŋek nandaba pɨsosak. ");
INSERT INTO yut_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Yo kɨnda amɨn kwasopgwan pɨgɨsak uŋun da amɨn dakon but arɨpmɨ dɨma aŋupbal asak. Yo kɨnda amɨn butgwan da wɨŋ waŋga kɨsak uŋun da amɨn dakon but aŋupbal asak.” ");
INSERT INTO yut_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yaŋ yaŋek amɨn kabɨ madep yopmaŋek yutnon wɨgakwan paŋdetni da tɨlak gen dakon mibɨlɨ nandak do iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iyɨŋba Yesu yaŋ yagɨt, “Jiyo kɨsi nandak nandakji mɨni aŋakwan uŋun dakon mibɨlɨ dɨma nandaŋ, ma? Yo kɨnda amɨn kwasopgwan pɨgɨsak uŋun da amɨn dakon but arɨpmɨ dɨma aŋupbal asak. ");
INSERT INTO yut_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nido but nandak nandak nikon dɨma pɨgɨsak, ɨsal kwasopnikon pɨgakwan uŋun da aŋkosit aŋakwan kosirɨ naŋ abɨgɨsak.” (Yesu yaŋ yagɨt, do jap kɨsisi Piŋkop da dabɨlon kɨlegɨ gɨn.) ");
INSERT INTO yut_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesu da saŋbeŋek yaŋ yagɨt, “Yo amɨn but nandak nandagon da wɨŋ waŋga kwaŋ uŋun da amɨn dakon but paŋupbal aŋ. ");
INSERT INTO yut_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Yo amɨn but nandak nandagon da wɨsak uŋun yaŋ: nandak nandak yokwi, yumabi aŋpak mibɨlɨ mibɨlɨ, yo kabo, amɨn dapdap, ");
INSERT INTO yut_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","amɨn wam kɨlɨ abi da yumabi aŋpak, pɨndak galaktok, aŋpak yokwi mibɨlɨ mibɨlɨ, top gen yogok, kwen wɨgɨk, tagɨsi ekwaŋ amɨn do nandaba yokwi tok nandak nandak, ae not do yokwi yogok, gen kɨrɨŋɨt, ae ŋugɨgɨ aŋpak. ");
INSERT INTO yut_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Uŋun yokwi morap amɨn buron da wɨŋ waŋga kwaŋ uŋun da amɨn paŋupbal aŋ.” ");
INSERT INTO yut_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu da uŋun kokup yɨpmaŋek Tair kokupmon kɨgɨt. Kɨŋ yut kɨndakon wɨgek pasɨlɨ egek yɨk yawot akeŋ yaŋ nandagɨt, mani pasɨlɨ egɨp do aŋtɨdok agɨt. ");
INSERT INTO yut_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Uŋun bɨsapmon mɨŋat kɨnda gwi koŋni toŋ uŋun da Yesu dakon gen bini nandaŋek abɨŋ Yesu da kandap mibɨlon gawak ɨmgut. ");
INSERT INTO yut_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Uŋun mɨŋat Israel mɨŋat kɨnda dɨma, uŋun Grik mɨŋat kɨnda Ponisia tetgɨn Siria mɨktɨmon altagɨt. Yesu da gwi dakon koŋ yol ɨmjak do bɨsit tebai iyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iyɨŋban Yesu da yaŋ iyɨgɨt, “Mibɨltok Juda amɨn paŋpulugaŋek ae don mɨktɨm dɨwarɨkon amɨn paŋpulugokeŋ. Yosol uŋudeŋ abeŋ kaŋ, mɨŋat monjɨyo dakon jap pɨŋan do yomdɨsat. Uŋun tagɨ dɨma.” ");
INSERT INTO yut_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yaŋban mɨŋat da kobogɨ yaŋ iyɨgɨt, “Amɨn Tagɨ, asi yosol, mani mɨŋat monjɨyo da jap naŋakwa jɨmjɨmɨ mibɨlɨkon moŋ uŋun pɨŋan da si noŋ.” ");
INSERT INTO yut_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yaŋban Yesu da yaŋ iyɨgɨt, “Gak gen kobogɨ tagɨsi yosol, do koŋ gwago kɨlɨ yɨpmaŋ dek, do tobɨlek yutgokon kɨŋek koki.” ");
INSERT INTO yut_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Yaŋ iyɨŋban mɨŋat uŋun yutnikon kɨŋ kaŋban gwi koŋni mɨni da tamokon pakban kagɨt. ");
INSERT INTO yut_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kɨlɨ Yesu Tair kokup yɨpmaŋek Saidon kokup kɨŋ yapmaŋek Dekapolis mɨktɨm uŋun kɨsi yapmaŋek Galili Pakbi Ɨdap uŋudon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kɨŋ altaŋakwan amɨn kabɨ kɨnda da amɨn kadɨm mɨragɨ mɨni kɨnda aŋaŋ opgwit. Aŋobɨŋ Yesu da kɨsitni gɨptɨmɨkon wɨtjɨsak do bɨsit tebai iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iyɨŋba nandaŋek Yesu da amɨn kadɨm uŋun abɨdaŋban amɨn kabɨ madep yopmaŋek ɨleŋɨkon kɨgɨmal. Kɨŋ Yesu da kɨsitni amɨn uŋun da mɨragon yɨpban pɨgɨgɨt. Aŋek kɨsitnikon ɨlɨp sulek melɨkon wɨtjɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yaŋ aŋek Kwen Kokup sɨŋtaŋek yaŋba kɨk aŋek iyɨgɨt, “Epata!” (Uŋun dakon mibɨlɨ “Pɨsoki!”) ");
INSERT INTO yut_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yaŋ iyɨŋban uŋudon gɨn mɨragɨ pɨsagɨt, ae melɨ tagap taŋek gen kɨlegɨsi yagɨt. ");
INSERT INTO yut_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Aban Yesu da wasok agɨt uŋun dakon gen bin amɨn dɨma yoyɨni do yaŋsop aŋyomgut. Mani amɨn da geni dɨma nandaŋek yaŋba madepsi ɨreŋ tagɨt. ");
INSERT INTO yut_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mɨŋat amɨnyo da tamtam yaŋek yaŋ yawit, “Yo morap asak uŋun wagɨl tagɨsi asak. Wasok aban mɨragɨ mɨni uŋun da gen nandaŋ, ae amɨn kadɨm da gen yoŋ.” ");
INSERT INTO yut_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Uŋun bɨsapmon mɨŋat amɨn kabɨ madep aeni abɨŋ muwukgwit. Jap mɨni do Yesu da paŋdetni yoyɨŋban apba yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“On mɨŋat amɨn kabɨyo nin gat gɨldat kapbɨ ekwamaŋ. Kɨlɨ japni kɨsi naŋ mudaŋ, do bupmɨ nandaŋ yomɨsat. ");
INSERT INTO yut_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Dɨwarɨ da kokup dubagɨkon da apgwit, do yabekgo kɨni kaŋ, kosiron jap do aŋek dabɨlɨ upbal taŋba maŋ potdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yaŋ yaŋban paŋdetni da yaŋ iyɨwit, “On ekwamaŋon amɨn dɨma ekwaŋ, do jap dukon baŋ paŋabɨŋ on mɨŋat amɨn madep yomneŋ?” ");
INSERT INTO yut_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yaŋba Yesu da yaŋ yoyɨgɨt, “Jikon bret niaŋ da toŋ?” Yaŋban iyɨwit, “7 kabɨ.” ");
INSERT INTO yut_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yaŋba Yesu da mɨŋat amɨn kabɨ madep yoyɨŋban mɨktɨmon yɨkgwit. Yɨgakwa bret 7 kabɨ tɨmɨgek Piŋkop ya yaŋ iyɨŋek paŋdetni da kokwinɨk yomni do yomgut. Yoban mɨŋat amɨnyo do yomgwit. ");
INSERT INTO yut_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tap kɨlap monɨŋ monɨŋ kaloŋ kaloŋ kɨsi taŋ yomgwit. Uŋun kɨsi gɨsamɨgek paŋdetni da kokwinɨk yomni do yomgut. ");
INSERT INTO yut_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mɨŋat amɨn jap naŋba arɨpmɨ aŋakwa jap dɨwat tawit uŋun paŋdetni da yɨk madepsi 7 yaŋ sɨmɨlba tugawit. ");
INSERT INTO yut_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","(Amɨn jap nawit uŋun 4 tausen yaŋ da nawit.) Yaŋ aŋek Yesu da mɨŋat amɨn kabɨ madep yabekban kɨŋakwa, ");
INSERT INTO yut_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","paŋdetni gat boron wɨgek mɨktɨm Dalmanuta tetgɨn do kɨwit. ");
INSERT INTO yut_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Uŋun bɨsapmon Parisi amɨn da abɨŋ Yesu aŋkewal do aŋek yaŋ iyɨwit, “Gak da wasok tapmɨmɨ toŋ kɨnda abɨ kaŋek nin da gandano Piŋkop da gak yabekban pɨl da pini asal yaŋ gandaneŋ.” ");
INSERT INTO yut_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yaŋ yaŋba burɨ yokwi taŋban yaŋba kɨk aŋek yaŋ yoyɨgɨt, “Apmiap amɨn ekwaŋ nido wasok tapmɨmɨ toŋ kɨnda kok do yoŋ? Nak asisi dayɨsat, wasok tapmɨmɨ toŋ kɨnda dɨma koni, dɨmasi.” ");
INSERT INTO yut_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yaŋ yoyɨŋek boron wɨgek pakbi ɨdap terɨ kɨnda kɨwit. ");
INSERT INTO yut_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kɨŋek paŋdet kabɨni ɨŋtaŋek bret dɨwarɨ dɨma paŋkɨwit, bret kaloŋɨ kɨnda da gɨn boron tagɨt. ");
INSERT INTO yut_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yaŋ aba Yesu da nawa gen yaŋ yoyɨgɨt, “Ji Parisi amɨn gat ae Erot gat uŋun dakon yis do pasalek kaŋ kɨmotni.” ");
INSERT INTO yut_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yaŋban notni yoyɨŋ yoyɨŋ aŋek yaŋ yawit, “Ninon bret mɨni uŋun do bo yosok?” ");
INSERT INTO yut_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Gen uŋun yaŋba nandaŋek Yesu da yaŋ yoyɨgɨt, “Ji nido ‘ninon bret mɨni’ yaŋ yoŋ? Gen dayɨsat uŋun dɨma nandaba pɨsosok, ma? Nandak nandak kositji sopgwit? ");
INSERT INTO yut_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Dabɨlji toŋ mani yo dɨma kaŋba pɨsosok? Mɨrakji toŋ mani dɨma nandaŋ? Kɨlɨ ɨŋtaŋ mudaŋ, ma? ");
INSERT INTO yut_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nak amɨn 5 tausen do bret 5 kabɨ pɨdaŋ yomgum bɨsapmon, ji jap dɨwat yɨk madepsi niaŋ da sɨmɨlba tugawit?” Yaŋban yaŋ iyɨwit, “Yɨk madepsi 12 kabɨ.” ");
INSERT INTO yut_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yaŋba yagɨt, “Nak amɨn 4 tausen do bret 7 kabɨ pɨdaŋ yomgum bɨsapmon, ji jap dɨwat yɨk madepsi niaŋ da sɨmɨlba tugawit?” Yaŋban yaŋ iyɨwit, “Yɨk madepsi 7 kabɨ.” ");
INSERT INTO yut_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yaŋ yaŋba yoyɨgɨt, “Ji sigɨn dɨma nandaba pɨsosok, ma?” ");
INSERT INTO yut_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Betsaida kokupmon kɨŋ altaŋba amɨn dɨ da amɨn dabɨlɨ mɨni kɨnda aŋaŋ opgwit. Aŋobɨŋek Yesu da kɨsitni da wɨtjɨsak do bɨsit tebai iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Amɨn uŋun kɨsirɨkon da abɨdaŋek yaŋban kokup yɨpmaŋek waŋga pɨgɨgɨmal. Pɨgɨ dabɨlɨkon ɨlɨp sulek kɨsit da wɨtjɨŋ yɨpmaŋek iyɨgɨt, “Yo dɨ pɨndakdal, bo dɨma?” ");
INSERT INTO yut_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Amɨn uŋun sɨŋtaŋek yaŋ iyɨgɨt, “Nak amɨn pɨndakdat. Mani pɨndakgo kɨndap yombem da obɨgɨ abɨgɨyo yaŋ aŋ.” ");
INSERT INTO yut_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yaŋ yaŋban Yesu da aeni dabɨlɨkon kɨsirɨ wɨtjɨgɨt. Yaŋ aban dabɨlɨ wagɨl kɨlek taŋban yo morap tagɨ pɨndakgɨt. ");
INSERT INTO yut_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Dabɨlɨ kɨlek taŋban Yesu da yabegek yaŋ iyɨgɨt, “Gak kokupmon dɨma kɨki, yutgokon kɨki.” ");
INSERT INTO yut_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu gat paŋdetni gat Sisaria Pilipai kokup pap uŋun dakon kokup monɨŋ monɨŋ tawit uŋudon kɨwit. Kɨŋek paŋdetni kosiron yaŋ yoyɨgɨt, “Mɨŋat amɨn da nak do namɨn yaŋ yoŋ?” ");
INSERT INTO yut_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yaŋban yaŋ iyɨwit, “Dɨwarɨ da gak do Jon Telagɨ Pakbi Sogok Amɨn yaŋ yoŋ, ae dɨ da Elaija yaŋ yoŋ, ae dɨ da kombɨ amɨn kɨnda kalɨp egɨpgut uŋun da pɨdak da egɨsak yaŋ yoŋ.” ");
INSERT INTO yut_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yaŋ yaŋba Yesu da yoyɨgɨt, “Ae dɨsi nak do namɨn yaŋ yoŋ?” Yaŋban Pita da gen kobogɨ yaŋ iyɨgɨt, “Gak Kristo.” ");
INSERT INTO yut_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yaŋban Yesu da mibɨlni amɨn dɨmasi yoyɨni do yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Uŋun bɨsapmon Yesu da wasaŋek paŋdetni yoyɨŋ degek yaŋ yoyɨgɨt, “Amɨn Dakon Monji da tepmɨ madepsi pakdɨsak. Aŋakwan kɨla amɨn, ae mukwa sogok amɨn dakon mibɨltok amɨn, ae gen teban yoyɨŋdet amɨn gat da manji ɨmɨŋek aŋakba kɨmotdɨsak. Kɨmagek gɨldat kapbɨ aŋakwan kɨmoron da pɨdokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Gen uŋun yaŋ teŋteŋaŋban Pita da Yesu abɨdaŋ aŋkɨ ɨleŋɨkon agek tebai iyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mani Yesu da tobɨl paŋdetni pɨndagek Pita gen tebai yaŋ iyɨgɨt, “Sunduk, gak nepmaŋ det. Gak Piŋkop dakon nandak nandak dɨma yoldal, amɨn dakon nandak nandak yoldal.” ");
INSERT INTO yut_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","35","Yaŋ iyɨŋek amɨn kabɨ madep gat paŋdetni gat yoyɨŋban iyɨ akgɨron apgwit. Apba yaŋ yoyɨgɨt, “Amɨn kɨnda iyɨ dakon yɨyɨtni tagɨsi tosak do nandaŋek pi madep asak kaŋ, egɨp egɨpni pasɨl ɨmjak. Mani amɨn kɨnda nak do nandaŋek, ae Piŋkop dakon Gen Bin Tagɨsi do nandaŋek, egɨp egɨpni do nandaban yo madep dɨma asak kaŋ, uŋun amɨn egɨp egɨp dagok dagogɨ mɨni do amɨn asak. Amɨn kɨnda nak nol do nandɨsak kaŋ, iyɨ dakon galaktok manji yomɨŋek tɨlak kɨndapni guramɨgek noljak. ");
INSERT INTO yut_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Amɨn kɨnda mɨktɨm dakon yo morap kɨsi paŋ egakwan egɨp egɨpni pasɨl ɨmjak kaŋ, uŋun yo morap da arɨpmɨ dɨma aŋpulugoni. Egɨp egɨpni uŋun yo kɨnda naŋ arɨpmɨ dɨma yumjak, wagɨlsi pasɨl ɨmjak. ");
INSERT INTO yut_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Abɨsok mɨŋat amɨnyo ekwaŋ uŋun Piŋkop manji ɨmɨŋek yo yokwi mibɨlɨ mibɨlɨ aŋ. Uŋun kabɨkon da amɨn kɨnda nak ae geno do mayagɨ nandɨsak kaŋ, Datni dakon tɨlɨmni paŋek telagɨ aŋelo kabɨ gat apni bɨsapmon, Amɨn Dakon Monji da uŋun amɨn do mayagɨ yaŋ gɨn nandakdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu da saŋbeŋek yaŋ yoyɨgɨt, “Nak asisi dayɨsat, on akgaŋ kabɨkon dɨ dɨma kɨmagek Piŋkop dakon Amɨn Kɨla Agakni tapmɨmɨ toŋsi apban kokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Gɨldat 6 mudaŋakwa Yesu da Pita, Jems, ae Jon yoyɨŋban buŋon yolba ɨleŋ dubagɨ kɨndakon wɨgɨwit. Ɨleŋon iyɨ gɨn egek kaŋakwa Yesu dakon gɨptɨm kulabɨk aŋek ŋwakŋwarɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Aŋakwan Yesu dakon ɨmalni kwakwagɨsi teŋteŋagɨt. Uŋun mɨktɨm amɨn kɨnda da arɨpmɨ dɨma agagɨ, kwakwagɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yaŋ aban kaŋakwa Elaija gat Moses gat altaŋbal Yesu gat gen yaŋ nandat aba pɨndakgwit. ");
INSERT INTO yut_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yaŋ aba Pita da Yesu yaŋ iyɨgɨt, “Yoyɨŋdet, nin ɨdon egɨp do tagɨsi nandamaŋ. Nin yut kabeŋ kapbɨ aneŋ. Kɨnda gak do, kɨnda Moses do, ae kɨnda Elaija do aneŋ.” ");
INSERT INTO yut_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Pita gat notni gat madepsi pasalgwit, ae ni gen baŋ yoneŋ yaŋ kɨnda dɨma nandawit, do Pita gen uŋun yumsi yagɨt.) ");
INSERT INTO yut_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yaŋ yaŋban gɨkwem da pɨŋ ɨlɨmɨk yomaŋakwan gen kɨnda uŋungwan da yaŋ altagɨt, “Uŋun Monjɨno, nak uŋun do but dasi galak taŋ ɨmɨsat. Ji geni nandani.” ");
INSERT INTO yut_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Gen uŋun nandaŋek uŋudon gɨn terɨ terɨ sɨŋtaŋek amɨn bamot ae dɨma pɨndakgwit. Yesu iyɨ gɨn kawit. ");
INSERT INTO yut_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ɨleŋon da tobɨl pɨŋek Yesu da yaŋ yoyɨgɨt, “Yo uŋun pɨndakgaŋ uŋun dakon gen amɨn kɨnda dɨmasi iyɨni. Aŋakwa Amɨn Dakon Monji kɨmoron da pɨdosak, uŋun bɨsapmon amɨn tagɨ yoyɨni.” ");
INSERT INTO yut_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yoyɨŋban paŋdetni da gen uŋun iyɨ gɨn yaŋ nandaŋek yaŋ yawit, “Kɨmoron da pɨdot pɨdot uŋun yo kɨnda nido nandaŋek yosok.” ");
INSERT INTO yut_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aŋek Yesu yaŋ iyɨwit, “Gen teban yoyɨŋdet amɨn da gen kɨnda yaŋ yoŋ ‘Elaija mibɨltok abɨŋakwan Kristo buŋon apjak.’ Gen uŋun nido yoŋ?” ");
INSERT INTO yut_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Iyɨŋba Yesu da gen kobogɨ yaŋ yoyɨgɨt, “Gen uŋun bamɨ yoŋ. Elaija kɨlɨ abɨŋ yo morap paŋmɨlɨp agɨt. Aŋakwan amɨn da galaktokni yolek yo mibɨlɨ mibɨlɨ Piŋkop da papiakon gen tosok uŋun da tɨlagon aŋ ɨmgwit. Mani Piŋkop da papiakon gen kɨnda mandabi uŋun yaŋ: ‘Amɨn da Amɨn Dakon Monji manji ɨmɨŋek yo yokwi madepsi aŋ ɨmdaŋ.’ Uŋun gen mibɨlɨ nido tosok?” ");
INSERT INTO yut_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu paŋdetni kapbɨ gat kɨŋ notni kabɨkon altawit. Kɨŋ altaŋek mɨŋat amɨn kabɨ madep notni paŋgwasɨŋba pɨndakgwit. Ae gen teban yoyɨŋdet amɨn dɨwarɨ da apba notni gat gen emat aba pɨndakgwit. ");
INSERT INTO yut_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aŋakwa mɨŋat amɨn kabɨ madep Yesu kaŋek but galak nandaŋek uŋudon gɨn Yesukon kɨŋek “Gɨldat tagɨ!” yaŋ iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yaŋba Yesu da yaŋ yoyɨgɨt, “Ji gen emat nido aŋ?” ");
INSERT INTO yut_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yaŋban uŋun mɨŋat amɨn kabɨkon da amɨn kɨnda da gen kobogɨ yaŋ iyɨgɨt, “Yoyɨŋdet, monjɨno koŋ da burɨkon yɨgek gen yogok kositni sopmaŋdak, do gagon aŋobɨsat. ");
INSERT INTO yut_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Koŋ da bɨsap morapmɨ yaŋ asak. Monjɨno tebai abɨdaŋek maban mɨktɨmon maŋ pagek tarak kwakwagɨ da gen kaganikon pawɨŋ tɨmɨkdak, aŋakwan geni wamtɨmsisak, ae gɨptɨmɨ kɨsisi kɨtɨraŋ kɨsak. Nak paŋdetgoni koŋ yolni do yoyɨko aŋtɨdok aŋ, uŋun da arɨpmɨ dɨmasi yolyolɨ.” ");
INSERT INTO yut_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Gen uŋun nandaŋek Yesu da yaŋ yoyɨgɨt, “Ji nandaŋ gadatji mɨni amɨn nak bɨsap niaŋ da ji gat egɨpbeŋ? Ae bɨsap niaŋ da ji dakon jɨgɨ guramɨkgeŋ? Monjɨ uŋun nagon aŋopgut.” ");
INSERT INTO yut_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yaŋ yaŋban monjɨ uŋun Yesukon aŋopgwit. Aŋopba koŋ da Yesu kaŋek uŋudon gɨn monjɨ maban mɨktɨmon pagek tobɨl tobɨl aŋek tarak kwakwagɨ da gen kaganikon pawɨŋ tɨmɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yaŋ aban Yesu da datni iyɨgɨt, “Bɨsap niaŋ da yaŋ agɨt?” Yaŋban datni da yagɨt, “Ŋakŋagɨkon da altaŋ ɨmgut da tosok. ");
INSERT INTO yut_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Bɨsap morapmɨ koŋ da aŋakgo kɨmotjak yaŋ nandaŋek maban kɨndapmon ae pakbikon pɨgɨgɨt. Tapmɨm taŋ gamɨsak kaŋ, nit do bupmɨ nandaŋek paŋpulugoki.” ");
INSERT INTO yut_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yaŋban Yesu da yaŋ iyɨgɨt, “Tapmɨm taŋ namɨsak bo dɨma nido but bamot aŋ namɨsal? Amɨn nandaŋ gadatni toŋ uŋun yo morap tagɨ aŋ mudoni.” ");
INSERT INTO yut_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Iyɨŋban uŋudon gɨn monjɨ dakon datni da madepsi yaŋ yagɨt, “Nak nandaŋ gadasat, mani nandaŋ gadatno uŋun madep dɨma, do nak aŋpuluga!” ");
INSERT INTO yut_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yaŋban Yesu da mɨŋat amɨn kabɨ madep tɨmtɨm yaŋek apba pɨndagek koŋ tebai yaŋ iyɨgɨt, “Koŋ, gen kaga ae mɨrak sopsop amɨn, gak monjɨ on yɨpmaŋdet! Wagɨl kɨŋek buŋon on monjɨgwan dɨmasi pɨgɨki!” ");
INSERT INTO yut_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yaŋban koŋ da madepsi yaŋ tɨdaŋek monjɨ uŋun maban bumjot yombem pagakwan koŋ yɨpmaŋek wɨŋ kɨgɨt. Kɨŋakwan amɨn morapmɨ da monjɨ kaŋek yaŋ yawit, “Kuŋwakni.” ");
INSERT INTO yut_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mani Yesu da kɨsirɨkon abɨdaŋek aban pɨdaŋ akgɨt. ");
INSERT INTO yut_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yaŋ aŋek Yesu yut kɨndakon wɨgakwan paŋdetni da iyɨ gɨn egek yaŋ iyɨwit, “Nido koŋ uŋun nin da yol do aŋtɨdok amaŋ?” ");
INSERT INTO yut_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yaŋba yoyɨgɨt, “Koŋ uŋuden uŋun yum yolyolɨ dɨma. Bɨsiron da tagɨ yolyolɨ.” ");
INSERT INTO yut_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Yesu gat paŋdetni gat mɨktɨm uŋun yɨpmaŋek Galili mɨktɨm da binapgwan kɨwit. Kɨŋakwa Yesu paŋdetni yoyɨŋdet ak do nandagɨt, do gen bini amɨn da dɨma nandani do si pasɨlek kɨwit. Aŋek yaŋ yoyɨgɨt, “Amɨn Dakon Monji don amɨn da kɨsiron yɨpba aŋakba kɨmotdɨsak. Kɨmak gɨldat kapbɨ aŋakwan kɨmoron da pɨdokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yaŋ yoyɨŋban gen uŋun dakon mibɨlɨ dɨma nandaba pɨsagɨt ae iyɨk do si pasalgwit. ");
INSERT INTO yut_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu gat paŋdetni gat Kapaneam kokupmon kɨŋ pɨsaŋek yutnon wɨgek Yesu da paŋdetni yaŋ yoyɨgɨt, “Kosiron ji ni gen naŋ yaŋ?” ");
INSERT INTO yut_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kosiron gen emat aŋek yaŋ yawit, “Nin kabɨkon namɨn da mibɨltok amɨn asak?” Yaŋ yawit, do gen kobogɨ iyɨk do mayak tawit. ");
INSERT INTO yut_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Aŋakwa pabɨŋ yɨgek paŋdetni 12 kabɨ yoyɨŋban apba yaŋ yoyɨgɨt, “Amɨn kɨnda mibɨltok amɨn ak do nandɨsak kaŋ, buŋonsi agek amɨn morap dakon oman amɨn egɨpjak.” ");
INSERT INTO yut_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yaŋ yaŋek amɨn monɨŋ kɨnda abɨdaŋ aŋobɨŋ bɨkbɨknikon yɨpban agakwan kɨsirɨ da abɨdaŋek yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Amɨn kɨnda nak do nandaŋek amɨn monɨŋ oden kɨnda but da abɨdosak kaŋ, uŋun nak naŋ abɨdosok. Ae amɨn kɨnda nak abɨdosak kaŋ, uŋun nak naŋ gɨn dɨma abɨdosok, Datno nak yabekban pɨgɨm uŋun naŋ abɨdosok.” ");
INSERT INTO yut_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yaŋban Jon da yaŋ iyɨgɨt, “Yoyɨŋdet, nin kaŋapno amɨn kɨnda da gak da manon koŋ yolban kamaŋ. Mani nin da kabɨkon nani kɨnda dɨma, do yaŋsop aŋ ɨmɨmaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yaŋban Yesu da yaŋ yagɨt, “Dɨma kɨrɨŋɨk ɨmni. Amɨn kɨnda nak dakon man yaŋek wasok tapmɨmɨ toŋ asak uŋun amɨn nikon da nak do yaŋba yokwi tok asak? Uŋun arɨpmɨ dɨma. ");
INSERT INTO yut_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Amɨn kɨnda uwal dɨma aŋ nimjak amɨn uŋun notnin. ");
INSERT INTO yut_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nak asisi dayɨsat, amɨn kɨnda nak do nandaŋek ji do Kristo dakon amɨn kabɨ yaŋ nandaŋek pakbi koleŋ damjak kaŋ, uŋun amɨn dakon yumaŋ nogɨ dɨma pasɨl ɨmjak.” ");
INSERT INTO yut_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesu da saŋbeŋek yaŋ yagɨt, “Amɨn kɨnda da amɨn monɨŋ kɨnda nak nandaŋ gadaŋ namɨŋakwan yokwi asak do yabekban yokwi asak kaŋ, yabet asak amɨn wit mɨsɨŋɨt tɨp madep kɨnda tegɨkon amɨn da wamaŋ maba tap ɨlarɨsigwan pɨgek tagɨ kɨmotjak. ");
INSERT INTO yut_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Kɨsitgo da yokwi aki do gayɨŋban kaŋ, kɨsitgo mandaŋ dagoki. Gwɨnɨmbɨl egek Tɨpdomon kɨndap tebanon pɨgɨki yaŋ do kɨsitgo mandaŋ dagaŋek tagapmɨ egɨp egɨp dagok dagogɨ mɨni do amɨn aki. ");
INSERT INTO yut_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ae kandapgo da yokwi aki do gayɨŋban kaŋ, kandapgo mandaŋ dagoki. Gwɨnɨmbɨl egek Tɨpdomon kɨndap tebanon pɨgɨki yaŋ do kandapgo mandaŋ dagaŋek tagapmɨ egɨp egɨp dagok dagogɨ mɨni do amɨn aki. ");
INSERT INTO yut_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ae dabɨlgo da yokwi aki do gayɨŋban kaŋ, dabɨlgo pɨlɨkgi. Gwɨnɨmbɨl egek Tɨpdomon kɨndap tebanon pɨgɨki yaŋ do dabɨlgo kɨnda pɨlɨgek tagapmɨ Piŋkop da Amɨn Kɨla Asagon tagɨ wɨgɨki. ");
INSERT INTO yut_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Tɨpdomon namat dɨma kɨmokgoŋ, ae kɨndap dɨma kɨmokdok.’ ");
INSERT INTO yut_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tap gat kɨndap gat amɨn kɨsikon altosak. ");
INSERT INTO yut_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tap uŋun yo galagɨsi. Mani tap dakon galagɨ pasɨljak kaŋ, niaŋsi aŋek galagɨni aŋkaluk aneŋ? Ji tap yombem egek notji gat but kaloŋsi egɨpni.” ");
INSERT INTO yut_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu uŋun kokup yɨpmaŋek Judia mɨktɨmon ae Jodan Pakbi terɨ kɨnda uŋudon kɨgɨt. Uŋudon egakwan mɨŋat amɨn madepsi apgwit. Apba Yesu iyɨ aŋ aŋ agɨt uŋudeŋ ae Piŋkop gen yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Yoyɨŋakwan Parisi amɨn dɨwarɨ da abɨŋ Yesu gen yokwi kɨnda yaŋban kaŋek gen pikon yɨpneŋ yaŋ nandaŋek yaŋ iyɨwit, “Gen tebanin da amɨn kɨnda mɨŋatni tagɨ kwɨnɨtjak do yosok bo dɨma?” ");
INSERT INTO yut_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yaŋba yoyɨgɨt, “Moses da ni gen teban naŋ damgut?” ");
INSERT INTO yut_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yaŋban iyɨwit, “Moses da yaŋ mandagɨt: Amɨn kɨnda mɨŋatni kwɨnɨt do kaŋ, mɨŋat paŋkwɨnɨt papia kɨnda mandaŋ ɨmɨŋek kwɨnɨtjak.” ");
INSERT INTO yut_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yaŋ yaŋba Yesu da yagɨt, “Moses uŋun but tebanji do aŋek gen teban uŋun mandagɨt. ");
INSERT INTO yut_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mani wasok wasogɨkon Piŋkop da amɨn wasaŋek ‘mɨŋat ae wɨliyo kɨsi wasagɨt.’ ");
INSERT INTO yut_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Uŋun do aŋek wɨli da meŋi datniyo yopmaŋek mɨŋatni gat muwukbal ");
INSERT INTO yut_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","gɨptɨm kaloŋɨ anjil.’ Gen yaŋ tosok, do amɨn wam da bamorɨ dɨma, gɨptɨm kaloŋɨ amal. ");
INSERT INTO yut_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Uŋun do Piŋkop da mɨŋat wɨli kɨlɨ paŋmuwukgɨt, do amɨn da dɨma paŋwasekdo.” ");
INSERT INTO yut_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yaŋ yaŋban yutnon wɨgek paŋdetni da uŋun gen dakon mibɨlɨ nandak do iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","IIyɨŋba yaŋ yoyɨgɨt, “Amɨn kɨnda da mɨŋatni yɨpmaŋek kɨŋ mɨŋat kalugɨ pasak kaŋ, uŋun amɨn yumabi asak. ");
INSERT INTO yut_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ae mɨŋat kɨnda da eni yɨpmaŋek kɨŋ wɨli kalugɨ pasak kaŋ, uŋun mɨŋat yumabi asak.” ");
INSERT INTO yut_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Amɨn da mɨŋat monjɨyoni Yesukon tɨmɨk paŋopgwit. Paŋobɨŋ Yesu da kɨsirɨ kwenikon wɨtjɨsak do iyɨwit. Mani paŋdetni da yaŋ yoyɨwit, “Dɨma paŋopni. Paŋkɨt!” ");
INSERT INTO yut_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yaŋba Yesu da burɨ yokwi taŋban yaŋ yoyɨgɨt, “Mɨŋat monjɨ yopba nagon apgut. Dɨma kɨrɨŋɨk yomni. Piŋkop da Amɨn Kɨla Asak uŋun amɨn mɨŋat monjɨyo da tɨlagon ekwaŋ uŋuden amɨn dakon. ");
INSERT INTO yut_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nak asisi dayɨsat, amɨn kɨnda da mɨŋat monjɨyo da Piŋkop da Amɨn Kɨla Asak abɨdoŋ uŋun da tɨlak dɨma abɨdoni kaŋ, uŋungwan arɨpmɨ dɨma pɨgɨkdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yaŋ yaŋek Yesu da mɨŋat monjɨyo tɨmɨgek kɨsirɨ kwenikon wɨtjɨŋek gɨsam yomgut. ");
INSERT INTO yut_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu pɨdaŋ kɨk do aŋakwan amɨn kɨnda tɨmtɨm yaŋek abɨŋ gawak ɨmɨŋek yaŋ iyɨgɨt, “Yoyɨŋdet gɨman, niaŋsi aŋek egɨp egɨp dagok dagogɨ mɨni abɨdokeŋ?” ");
INSERT INTO yut_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yaŋban Yesu da yaŋ iyɨgɨt, “Gak nido nak do amɨn tagɨsi yaŋ nayɨsal? Piŋkop kaloŋɨ gɨn uŋun amɨn tagɨsi. ");
INSERT INTO yut_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gak gen teban nandaŋ mudosol, uŋun yaŋ: ‘Amɨn dɨma dapba kɨmotni; mɨŋat eyo kɨlɨ abi ji yumabi dɨma ani; yo kabo dɨma noni; top dɨma yoni; top gen yaŋek amɨn notji yum dogɨn gen pikon dɨma yopni; amɨn dakon yo kabɨ paŋkɨlɨgek dɨma tɨmɨtni; meŋ dat do nandaba wukwanek geni guramɨtni.’ ” ");
INSERT INTO yut_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yaŋban amɨn uŋun yaŋ yagɨt, “Yoyɨŋdet, nak monɨŋɨsogon da gen teban morap guramɨk aŋ aŋ opgum da obɨsat.” ");
INSERT INTO yut_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yaŋban Yesu da kaŋ galak taŋek yaŋ iyɨgɨt, “Yo kaloŋɨ tosok uŋun dɨma asal. Gak kɨŋ yo morapgo yumaŋ naŋek uŋun dakon moneŋ baŋ yoni mɨni amɨn do yobi. Yaŋ aŋaki yo tagɨsi Kwen Kokupmon taŋ gamdɨsak. Yaŋ aŋek abɨŋ nak nol.” ");
INSERT INTO yut_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Amɨn uŋun yoni morapmɨ taŋ ɨmgwit, do gen uŋun nandaŋ but yokwi nandaŋek si kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kɨŋakwan Yesu da paŋdetni pɨndagek yaŋ yoyɨgɨt, “Yoni morapmɨ amɨn uŋun Piŋkop da Amɨn Kɨla Asak da kagagwan pɨgɨk do aŋtɨdok aŋ.” ");
INSERT INTO yut_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Gen uŋun nandaŋek nandaba ŋwakŋwarɨsi agɨt. Mani Yesu da saŋbeŋek yaŋ yoyɨgɨt, “Monjɨnoni, amɨn Piŋkop da Amɨn Kɨla Asak da kagagwan pɨgɨk do aŋtɨdok aŋ. ");
INSERT INTO yut_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Asisi, bɨt madepsi kamel uŋun da ɨmal bupbup da kosit gwagagon arɨpmɨ dɨma pɨgɨgɨ asak. Mani uŋun yapmaŋek yoni morapmɨ amɨn uŋun Piŋkop da Amɨn Kɨla Asak uŋun da kagagwan arɨpmɨ dɨmasi pɨgɨgɨ asak.” ");
INSERT INTO yut_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yaŋban paŋdetni nandaba ŋwakŋwarɨsi aban notni yoyɨŋ yoyɨŋ aŋek yaŋ yawit, “Yaŋ kaŋ namɨn da egɨp egɨp dagok dagogɨ mɨni abɨdosak?” ");
INSERT INTO yut_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yaŋba Yesu da paŋdet kabɨni pɨndagek yaŋ yoyɨgɨt, “Amɨn iyɨ arɨpmɨ dɨma ani, mani Piŋkop da arɨpmɨ tagɨ asak. Piŋkop da yo morap ak do tagɨ asak.” ");
INSERT INTO yut_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yaŋban Pita da Yesu gen kɨnda yaŋ iyɨgɨt, “Nin yo morap yopmaŋek gak naŋ gɨn gol awɨlgamaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yaŋban Yesu da yaŋ yagɨt, “Nak asisi dayɨsat, amɨn kɨnda da nak do ae Gen Bin Tagɨsi do nandaŋek yutni, peni padɨk padɨkyo, sami, meŋi, datni, mɨŋat monjɨyoni, ae mɨktɨmni yopmaŋ detjak kaŋ, ");
INSERT INTO yut_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tamoni do Piŋkop da yo madepsi ɨmdɨsak. Mɨktɨmon egɨpjak bɨsapmon yo morap kalɨp yopmaŋ dekgɨt uŋun dakon tɨlak yapmaŋek yo morapmɨ ɨmdɨsak. Uŋun amɨn da yutni, peni padɨk padɨkyo, sami, meŋi, mɨŋat monjɨyo ae mɨktɨm morapmɨsi tɨmɨtdɨsak. Mani uŋun gɨn dɨma, amɨn da yo yokwi aŋyomdaŋ. Yaŋ aŋakwa bɨsap madep apjak bɨsapmon egɨp egɨp dagok dagogɨ mɨni abɨdokdɨsak. ");
INSERT INTO yut_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mani amɨn morapmɨ abɨsok mibɨltok ekwaŋ uŋun da buŋon amɨn akdaŋ. Aŋakwa amɨn morapmɨ abɨsok buŋon ekwaŋ uŋun da mibɨltok amɨn akdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu gat paŋdetni gat Jerusalem kokup papmon wɨgɨk do aŋek Yesu iyɨ mibɨltok aŋyoban kɨwit. Kɨŋakwa paŋdetni da nandak nandak morapmɨ aŋakwa amɨn buŋon yolgwit uŋun da but pasol awit. Yaŋ aŋakwa Yesu da paŋdetni 12 kabɨ aeni tɨmɨk paŋmuwugek yo altaŋ ɨmni uŋun dakon but pɨso yoyɨŋek ");
INSERT INTO yut_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","yaŋ yagɨt, “Nin abɨsok Jerusalem kɨŋapno amɨn da Amɨn Dakon Monji mukwa sogok amɨn dakon amɨn madep kabɨ ae gen teban yoyɨŋdet amɨn uŋun da kɨsiron yɨpdaŋ. Yaŋ aŋek gen pikon yɨpmaŋek kɨmotjak do yaŋ dagok akdaŋ. Yaŋ dagok aŋek Amɨn Ŋwakŋwarɨ Kabɨ da kɨsiron yɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Uŋun amɨn kabɨ da aŋsolat aŋek, ɨlɨp sul ɨmɨŋek, baljaŋek aŋakba kɨmotjak. Gɨldat kapbɨ aŋakwan kɨmoron da pɨdokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jems gat Jon gat, Sebedi dakon monjɨ bamot, uŋun da Yesukon altaŋ ɨmɨŋek yaŋ iyɨgɨmal, “Yoyɨŋdet, nit yo kɨnda do gayɨkdamak, uŋun gak da abi do nandamak.” ");
INSERT INTO yut_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yaŋbal yaŋ yoyɨgɨt, “Niaŋ abeŋ do nandamal?” ");
INSERT INTO yut_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yaŋban yaŋ iyɨgɨmal, “Gak don tɨlɨmgo gat yɨkgi bɨsapmon nit kɨnda da gak da amɨn tetdo, ae kɨnda da gwandeŋ tet do yɨtdeŋ do nandamak.” ");
INSERT INTO yut_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yaŋbal Yesu da yaŋ yoyɨgɨt, “Jil gen uŋun yomal uŋun dɨma nandaŋ pɨsaŋek yomal. Nak da tepmɨ madep pakdɨsat uŋun tagɨ panjil?” ");
INSERT INTO yut_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yaŋban iyɨgɨmal, “Tagɨ pandeŋ.” Yaŋ yaŋbal Yesu da yoyɨgɨt, “Uŋun asi, tepmɨ pakdɨsat uŋun pakdamal. ");
INSERT INTO yut_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mani, namɨn da nak da amɨn tet do yɨtjak, ae namɨn da gwandeŋ tet do yɨtjak uŋun arɨpmɨ dɨma yaŋ dagokeŋ. Tamo uŋun Piŋkop da amɨn kɨlɨ manjɨŋ yopgut uŋun dakon gɨn.” ");
INSERT INTO yut_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Paŋdetni 10 kabɨ gen uŋun nandaŋek Jems gat Jon gat do butjap nandawit. ");
INSERT INTO yut_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mani Yesu da yoyɨŋban opba yaŋ yoyɨgɨt, “Ji nandaŋ, Amɨn Ŋwakŋwarɨ Kabɨ dakon amɨn tagɨ da iyɨ do nandaba wukwanek pi madepsi amɨn do yoba aŋ. Ae geni guramɨk kɨmotni do nandaŋ. ");
INSERT INTO yut_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mani uŋun dakon aŋpak uŋun jikon dɨma tosak. Jikon da amɨn kɨnda amɨn tagɨ man pak do nandɨsak kaŋ, uŋun amɨn oman amɨnji egek amɨn tagɨ man pasak. ");
INSERT INTO yut_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Amɨn kɨnda jikon da mibɨltok amɨn egɨp do nandɨsak kaŋ, uŋun amɨn mɨŋat amɨn morap dakon oman amɨni egek mibɨltok amɨn tagɨ egɨpjak. ");
INSERT INTO yut_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Amɨn Dakon Monji uŋun yaŋ gɨn kɨlɨ agɨt. Amɨn da oman aŋɨmni do dɨma pɨgɨt. Iyɨ mɨŋat amɨn morap paŋpulugokdo, ae iyɨ dakon gɨptɨmnaŋ paregek yumaŋ naŋ yop do pɨgɨt.” ");
INSERT INTO yut_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu gat paŋdetni gat Jeriko kokup papmon kɨŋ altawit. Yesu uŋun kokup yɨpmaŋ degakwan paŋdet kabɨni gat ae mɨŋat amɨn kabɨ madep gat kɨsi kɨwit. Kɨŋakwa kosit ɨleŋon amɨn dabɨlɨ mɨni kɨnda yɨkgɨt, mani Batimeus, uŋun Timeus dakon monji. Uŋun amɨn dabɨlɨ mɨni do amɨn da moneŋ ɨmni do bɨsit yoyɨŋek yɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yɨgakwan amɨn da “Yesu Nasaret amɨn obɨsak” yaŋ yaŋba nandaŋek gen madepsi yaŋ tɨdaŋek yagɨt, “Yesu, Dewit Dakon Monji, bupmɨ nandaŋ nam!” ");
INSERT INTO yut_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yaŋ tɨdaŋban amɨn morapmɨ da gen tebai iyɨŋek dɨma yaŋ tɨdosak do iyɨwit. Mani madepsi sigɨn yaŋ tɨdaŋek yagɨt, “Dewit Dakon Monji, bupmɨ nandaŋ nam!” ");
INSERT INTO yut_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yaŋ tɨdaŋban Yesu da nandaŋek kosiron agek yaŋ yagɨt, “Iyɨŋba apban.” Yaŋban amɨn da dabɨlɨ mɨni amɨn yaŋ iyɨwit, “But galak nandaŋek pɨda. Opbi do yosok.” ");
INSERT INTO yut_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Gen uŋun yaŋba nandaŋek ɨmalni kukwaŋ yɨpmaŋek Yesukon opgut. ");
INSERT INTO yut_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Opban Yesu da yaŋ iyɨgɨt, “Nak ninaŋ aŋgabeŋ do nandɨsal?” Yaŋban dabɨlɨ mɨni amɨn da yaŋ iyɨgɨt, “Yoyɨŋdet, nak sɨŋtok do nandɨsat.” ");
INSERT INTO yut_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yaŋban Yesu da yaŋ iyɨgɨt, “Gak nandaŋ gadaŋ namɨsal, do kɨlek taŋek kɨki.” Yaŋ iyɨŋban uŋudon gɨn dabɨlɨ sɨŋtaŋek Yesu yolgɨt. ");
INSERT INTO yut_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu gat paŋdetni gat Jerusalem kokup pap aŋkapmat aŋek Betpage ae Betani kokupmon kɨŋ altawit. (Kokup bamot uŋun Ɨleŋ Olipmon tomal.) Altaŋek Yesu da paŋdetni bamorɨ yabegek, ");
INSERT INTO yut_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","yaŋ yoyɨgɨt, “Jil ason kokup komaŋ uŋudon kɨŋ altaŋek uŋudon gɨn donki bɨlagɨ kɨnda napmon akban konjil. Uŋun donki amɨn da kwenikon dɨma yɨkbi. Napmɨ wɨtdalek aŋopjil. ");
INSERT INTO yut_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Amɨn kɨnda da ‘Nido yaŋ amal’ yaŋ dayɨŋban kaŋ yaŋ iyɨnjil, ‘Amɨn Tagɨ da pi kɨnda ak do aŋek yosok. Donjok yɨpban opdɨsak.’ ” ");
INSERT INTO yut_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Uŋun amɨn bamot kɨŋ donki bɨlagɨ uŋun kosiron kagɨmal. Uŋun amɨn kɨnda da yoma kagakon gwɨlɨkba akgɨt. Napmɨ wɨtdalbal, ");
INSERT INTO yut_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","amɨn akgwit en da pɨndagek yawit, “Nibaŋ ak do aŋek on donki bɨlagɨ wɨtdalgamal?” ");
INSERT INTO yut_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yaŋba Yesu da gen yoyɨgɨt uŋudeŋ gɨn yoyɨgɨmal. Abal nandaŋ yomɨŋakwa donki aŋkɨgɨmal. ");
INSERT INTO yut_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Yesukon altaŋek ɨmalni ɨlɨk donki bɨlagɨ da kwenon yopmaŋakwal Yesu pawɨgɨ uŋudon yɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yaŋ aŋakwan amɨn morapmɨ da kosiron ɨmalni yalɨwit. Aŋakwa amɨn dɨwarɨ da kɨŋ kɨndap kɨlɨŋ mandaŋ paŋobɨŋ kosiron yalɨwit ");
INSERT INTO yut_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Amɨn mibɨltok kɨwit ae buŋon yolgwit kɨsi da yaŋ tɨdaŋek yaŋ yawit, “Osana! Piŋkop aŋkɨsino! ‘Piŋkop dakon gɨsamɨ toŋ amɨn uŋun Amɨn Tagɨ da manon abɨsak.’ ");
INSERT INTO yut_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Osana! Babɨknin Dewit da amɨn kɨla agɨt uŋudeŋ gɨn on amɨn kɨla amɨn madepnin egɨp do abɨsak, uŋun do Piŋkop Wɨkwisi Kwen Kokup Amɨn aŋkɨsino!” ");
INSERT INTO yut_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu Jerusalem kɨŋ altaŋek Telagɨ Yut Madep uŋun da nagalgwan pɨgɨgɨt. Pɨgɨ yo morap pɨndak aŋ aŋ kɨgɨt, mani gɨldat pɨgɨk do aŋakwan paŋdetni 12 kabɨ gat tobɨlek Betani kokupmon kɨwit. ");
INSERT INTO yut_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wɨsa dagaŋakwan Betani kokup yɨpmaŋ dek obɨŋ kosiron Yesu jap do agɨt. ");
INSERT INTO yut_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yaŋ aŋek pik kɨndap kɨnda dubagɨkon da tam dɨrɨm kagɨt. Yaŋ kaŋek bamɨ dɨ toŋ bo dɨma yaŋ do kapmatjok da kɨŋ wɨsɨgɨt. Mani bamɨ dɨ dɨma pɨndakgɨt. Tamɨ gɨn pɨndakgɨt, nido pik kɨndap dakon bamɨ toktok bɨsap dɨma. ");
INSERT INTO yut_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu da kɨndap uŋun yaŋ kaŋek yagɨt, “Buŋon bamɨ dɨmasi toki, aŋaki amɨn da dɨmasi paŋ noni dosi nandɨsat.” Gen yagɨt uŋun paŋdetni da nandawit. ");
INSERT INTO yut_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesu gat paŋdetni gat Jerusalem kɨŋ altawit. Kɨŋ altaŋek Yesu Telagɨ Yut Madep da nagalgwan pɨgɨ pɨndakban amɨn moneŋ ɨlɨt pi awit. Uŋun wasaŋek amɨn yolban waŋga abɨgɨwit. Yaŋ aŋek moneŋ kulabɨk awit amɨn dakon tamo, ae mɨnam baŋ moneŋ ɨlɨt awit amɨn dakon tamo uŋun kɨsi paŋtobɨlban tagal kɨwit. ");
INSERT INTO yut_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yaŋ aŋek amɨn Telagɨ Yut Madep da nagalgwan yoni tɨmɨgek kɨŋ ap dɨma ani do yaŋsop aŋyomgut. ");
INSERT INTO yut_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yaŋsop aŋyomɨŋek yaŋ yoyɨŋ dekgɨt, “Piŋkop da papiakon gen yaŋ mandabi: ‘Nak dakon yut uŋun amɨn mɨktɨmɨ mɨktɨmɨ ekwaŋ uŋun da abɨŋ bɨsit aŋnamni do tosak.’ Mani ji da kulabɨk aba ‘kabo noknok dakon pasɨlɨ tamo asak.’ ” ");
INSERT INTO yut_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yaŋ yaŋban mukwa sogok amɨn dakon amɨn madep kabɨ ae gen teban yoyɨŋdet amɨn gen uŋun nandaŋek Yesu aŋakba kɨmotjak do kosit wɨsɨwit. Uŋun Yesu do si pasalgwit, nido mɨŋat amɨnyo da Yesu dakon gen yogokni do tamtam yawit. ");
INSERT INTO yut_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yaŋ yaŋakwa pɨlɨn pɨlɨndo Yesu gat paŋdetni gat Jerusalem yɨpmaŋek kɨwit. ");
INSERT INTO yut_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wɨsa dagokdo Yesu gat paŋdetni gat kosiron kɨwit. Kɨŋek pik kɨndap uŋun kɨlɨ wagɨlsi kɨbɨdagɨt kawit. ");
INSERT INTO yut_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yaŋ kaŋek Pita da Yesu da gen yagɨt uŋun nandaŋek yaŋ iyɨgɨt, “Yoyɨŋdet, ka! Apma pik kɨndap yokwi tosak do yagɨl abɨsok oni kɨbɨdak!” ");
INSERT INTO yut_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yaŋban Yesu da gen kobogɨ yaŋ yagɨt, “Ji Piŋkop nandaŋ gadaŋ ɨmni. ");
INSERT INTO yut_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nak asisi dayɨsat, amɨn kɨnda da ɨleŋ kɨnda yaŋ iyɨsak, ‘Gak pɨdaŋ tap kaga pɨgɨ’ yaŋ iyɨŋek but bamot dɨma asak kaŋ, uŋun iyɨsak uŋudeŋ gɨn altokdɨsak. ");
INSERT INTO yut_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Uŋun do nak yaŋ dayɨsat, ni yo kɨnda do Piŋkop bɨsit iyɨŋek yo uŋun tɨmɨtni do nandaŋ gadaŋ kɨmotni kaŋ, yaŋ gɨn tɨmɨtdaŋ. ");
INSERT INTO yut_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ji bɨsit ani bɨsapmon amɨn kɨnda da yokwi aŋ damgut kaŋ, yokwini yopmaŋ ɨbi. Yaŋ ani kaŋ, Kwen Kokup Datji da yokwisi yaŋ gɨn yopdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu gat paŋdetni gat aeni Jerusalem kɨŋ altawit. Aŋek Yesu Telagɨ Yut Madep da nagalgwan pɨgɨ agɨpgut. Agakwan mukwa sogok amɨn dakon amɨn madep kabɨ, ae gen teban dakon yoyɨŋdet amɨn, ae kɨla amɨn Yesukon opgwit. Obɨŋek yaŋ iyɨwit, ");
INSERT INTO yut_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Namɨn da pi uŋun abi do yaŋ mudaŋ gamgut da yo uŋun asal? Ae namɨn da man madep gamgut?” ");
INSERT INTO yut_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yaŋba Yesu da yaŋ yoyɨgɨt, “Nak jibaŋ gen kɨnda dayɨkdɨsat. Dayɨko kobogɨ nayɨni kaŋ, nakyo kɨsi kobogɨ tagɨ dayɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon telagɨ pakbi sogɨt bɨsapmon, Piŋkop da yabekban pi agɨt, bo amɨn da yabekba agɨt? Uŋun do nayɨni.” ");
INSERT INTO yut_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yaŋban iyɨ gɨn notni yoyɨŋ yoyɨŋ aŋek yaŋ yawit, “Kobogɨ ni gen kɨnda naŋ iyɨneŋ? ‘Piŋkop da yabekgɨt’ yaŋ iyɨneŋ kaŋ, gen tebai yaŋ niyɨsak, ‘Ji nido dɨma nandaŋ gadaŋ ɨmgwit?’ ");
INSERT INTO yut_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mani ‘Amɨn da yabekgɨt’ yaŋ iyɨneŋ kaŋ, uŋun kɨsi tagɨ dɨma asak, nido amɨn morapmɨ da Jon do kombɨ amɨn bamɨsi kɨnda yaŋ nandaŋ. Do Jon dakon man bin aŋupbal aneŋ kaŋ nindapdaŋ.” Yaŋ do si pasalek ");
INSERT INTO yut_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yesu do gen kobogɨ yaŋ iyɨwit, “Nin dɨma nandamaŋ.” Yaŋba Yesu da yaŋ yoyɨgɨt, “Nakyo kɨsi namɨn da pi uŋun abeŋ do yaŋ mudaŋ namgut da pi asat uŋun dɨma dayɨkeŋ.” ");
INSERT INTO yut_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ae Yesu da tɨlak gen kɨnda yaŋ yoyɨgɨt, “Amɨn kɨnda da wain pini aŋek nagal agɨt. Aŋek uŋun nagalon wain sop bamaŋ tɨl do gapma kɨnda wayɨkgɨt. Aŋek kɨla amɨn da kabo noknok pɨndat do yut dubak kɨnda wɨtjɨŋban wɨgɨgɨt. Yut wɨtjɨŋek kɨla amɨn da pini aŋek bamɨ pakpak bɨsapmon bamɨ dɨ namni yaŋ nandaŋek wain pi uŋun da kɨsiron yɨpmaŋek mɨktɨm dubagɨkon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Wain sop pakpak bɨsap kwaŋ taŋakwan oman monjɨ kɨnda yabekban wain bamɨ tɨmɨk paŋopjak do kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kɨŋ altaŋban wain pi dakon kɨla amɨn da uŋun pi monjɨ abɨdaŋ aŋagek bamɨ kɨnda dɨma ɨmɨŋek yɨpba kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yaŋ aba pi ami da aeni oman monjɨ kɨnda yabekdak. Uŋun pi monjɨ busuŋɨkon aŋagek yo yokwisi aŋɨmgwit. ");
INSERT INTO yut_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yaŋ aba kɨnda gat yabekban kwan aŋakba kɨmakgɨt. Yaŋ aba pi monjɨ morapmɨ yabekgɨt. Dɨwarɨ si baljaŋek dɨwarɨ dapba kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Dapmaŋakwa kaloŋɨ kɨnda egɨpgut uŋun iyɨ dakon monji. Monji uŋun do galagɨsi nandagɨt. Buŋon iyɨ dakon monji yabegek yaŋ nandagɨt, ‘Monjɨno kwan kɨla amɨn da uŋun do nandaba wukwanek geni nandaŋek bamɨ dɨ ɨmni.’ ");
INSERT INTO yut_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Mani kɨla amɨn da monjɨ kaŋek notni yoyɨŋ yoyɨŋ aŋek yaŋ yawit, ‘Amɨn on da egɨ don datni dakon yo morap tɨmɨtdɨsak, do nin amɨn on aŋagek wain pini nin do aŋawatneŋ.’ ");
INSERT INTO yut_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yaŋ yaŋek monjɨ uŋun aŋakba kɨmakgɨt. Kɨmakban bumjotni pigaga naŋ maba waŋga kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ji niaŋ nandaŋ? Don pi ami da abɨŋ pi kɨla amɨn niaŋ aŋyomjak? Pi ami da abɨŋ uŋun kɨla amɨn dapban kɨmotdaŋ. Dapban kɨmagakwa wain pi uŋun amɨn ŋwakŋwarɨ da kɨsiron yɨpdɨsak. ");
INSERT INTO yut_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ji Piŋkop da papiakon gen tosok uŋun dɨma manjɨŋ nandawit? Gen uŋun yaŋ: ‘Yut agak amɨn da gwak yokwi yaŋ yaŋek maba kɨgɨt, uŋun gwak amɨn da yut kodɨgɨkon tɨp kɨnda naŋ tɨdawit da akdak. ");
INSERT INTO yut_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yo uŋun Amɨn Tagɨ da agɨt, aŋakwan nin da kono yo masɨ masɨmɨsi asak.’ ” ");
INSERT INTO yut_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yaŋ yoyɨŋban mukwa sogok amɨn dakon amɨn madep kabɨ, ae gen teban yoyɨŋdet amɨn ae kɨla amɨn da “Tɨlak gen uŋun nin do yosok” yaŋ nandaŋek Yesu abɨdok do nandawit. Mani mɨŋat amɨn do pasalek yɨpba si kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Parisi amɨn dɨwarɨ gat ae Erot da kabɨkon amɨn dɨwarɨ gat da Yesu dakon gen nandaŋek suŋ kɨnda yaŋban abɨdoni do kɨla amɨn da yabekgwit. ");
INSERT INTO yut_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yesukon kɨŋ altaŋek yaŋ iyɨwit, “Yoyɨŋdet, gak gen bamɨ yogok amɨn yaŋ nandamaŋ. Gak amɨn do dɨma pasoldol. Amɨn mani toŋ ae amɨn mani mɨni uŋun kɨsi Piŋkop dakon aŋpak yoyɨŋ dek mudosol. Gak niaŋ nandɨsal? Sisa do moneŋ ɨmno tagɨ asak bo dɨma? Ɨmneŋ bo dɨma?” ");
INSERT INTO yut_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mani Yesu da uŋun jamba but amɨn yaŋ nandaŋ yomɨŋek yaŋ yoyɨgɨt, “Ji nido nak aŋkewalgaŋ? Moneŋ tabɨlɨ kɨnda aŋabɨŋ naba koko.” ");
INSERT INTO yut_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Moneŋ tabɨlɨ kɨnda aŋobɨŋ ɨba abɨdaŋek yaŋ yoyɨgɨt, “On wup gat ae man mandabi gat uŋun namɨn dakon?” Yaŋban yaŋ yawit, “Sisa dakon.” ");
INSERT INTO yut_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yaŋba yaŋ yoyɨgɨt, “Sisa dakon yo uŋun Sisa iyɨ do ɨmni, ae Piŋkop dakon yo uŋun Piŋkop iyɨ do ɨmni.” Gen uŋun yaŋban nandaŋek Yesu do nandaba ŋwakŋwarɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Yaŋ aŋakwa Sadyusi amɨn dɨwarɨ da Yesukon apgwit. (Uŋun amɨn kabɨ amɨn kɨmakbi arɨpmɨ dɨma pɨdoni yaŋ nandaŋ.) Abɨŋek yaŋ iyɨwit, ");
INSERT INTO yut_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Yoyɨŋdet, Moses da gen kɨnda yaŋ mandagɨt, ‘Amɨn kɨnda monjɨ mɨni da kɨmagakwan mɨŋatni ɨsal egɨpjak kaŋ, padɨge da paŋakwan monjɨ paŋalasak.’ ");
INSERT INTO yut_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bɨsap kɨndakon peni padɨge 7 kabɨ egɨpgwit. Mibɨltok nani uŋun mɨŋat paŋek monji mɨni egek kɨmakgɨt. ");
INSERT INTO yut_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kɨmakban uŋun da buŋon nani da sakwabat paŋek yaŋ gɨn monji mɨni egɨ kɨmakgɨt. Ae uŋun da buŋon nani yaŋ gɨn agɨt. ");
INSERT INTO yut_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Uŋuden gɨn notni dɨwarɨ kɨsi mɨŋat uŋun paŋek monji mɨni da kɨmakgwit. Kɨmagakwa mɨŋat uŋun don kɨmakgɨt. ");
INSERT INTO yut_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Wɨli 7 kabɨ kɨsi da pawit, do amɨn da kɨmoron da pɨdoni bɨsap madepmon namɨn dakon mɨŋatni asak?” ");
INSERT INTO yut_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yaŋba Yesu da yaŋ yoyɨgɨt, “Ji Piŋkop da papiakon gen tosok uŋun dɨma kaŋ nandaŋyo aŋ. Ae Piŋkop dakon teban tok tosok uŋun kɨsi dɨma kaŋ nandaŋyo aŋ. Uŋun do aŋek ji gen gulusuŋ yoŋ. ");
INSERT INTO yut_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kɨmakbi da pɨdoni bɨsapmon mɨŋat eyo agak dɨma tokdɨsak. Aŋelo Kwen Kokup ɨsal ekwaŋ uŋun da tɨlagon egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nak amɨn da kɨmoron da pɨdot pɨdot uŋun dakon mibɨlɨ dayɨkeŋ. Moses da gen kɨnda mandagɨt ji manjɨŋ nandaŋ bo dɨma? Moses da kɨndap kɨnda soŋban kaŋakwan Piŋkop da gen yaŋ iyɨgɨt: ‘Nak Abraham, Aisak, ae Jekop dakon Piŋkop.’ ");
INSERT INTO yut_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Uŋun do nak yaŋ dayɨsat, Piŋkop uŋun amɨn kɨmakbi dakon Piŋkop dɨma, amɨn egɨp egɨpmɨ toŋ uŋun dakon Piŋkop.” ");
INSERT INTO yut_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Aŋakwan gen teban yoyɨŋdet amɨn kɨnda da abɨŋ pɨndakban Yesu gat Sadyusi amɨn gat gen emat awit. Yesu da gen kobogɨ tagɨsi yoyɨŋban nandaŋek Yesu yaŋ iyɨgɨt, “Ni gen teban da gen teban morap yapmaŋ mudaŋek mibɨltok asak?” ");
INSERT INTO yut_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yaŋban Yesu da gen kobogɨ yaŋ iyɨgɨt, “Gen teban mibɨltok asak uŋun yaŋ: ‘Israel amɨn kabɨ, gen uŋun nandani. Amɨn Tagɨ kaloŋ gɨn uŋun Piŋkopnin. ");
INSERT INTO yut_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ji Amɨn Tagɨ Piŋkopji uŋun but gat, ae wup gat, ae tapmɨmgo gat, ae nandak nandakgo gat kɨsi but dasi galak taŋ ɨbi.’ ");
INSERT INTO yut_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ae uŋun da buŋon yaŋ tosok: ‘Gaga do but dasi niaŋ galak tosol, uŋudeŋ gɨn amɨn do but dasi galak taŋ yobi.’ Uŋun gen teban bamot da gen teban morap yapmaŋ mudomal.” ");
INSERT INTO yut_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yaŋban uŋun gen teban yoyɨŋdet amɨn da Yesu yaŋ iyɨgɨt, “Yoyɨŋdet, tagɨsi yosol. Uŋun asisi, Piŋkop uŋun kaloŋ dagɨn egɨsak, ae Piŋkop kɨnda dɨma egɨsak. ");
INSERT INTO yut_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Notgo do galagɨ niaŋ nandɨsal uŋun si yapmaŋek Piŋkop do galagɨ madepsi nandaŋ ɨmni. Bɨsapmɨ bɨsapmɨ uŋun do nandaŋek ae oman aŋ ɨmɨŋek egɨpni. Yaŋ aŋek gaga do but dasi niaŋ galak tosol, uŋudeŋ gɨn amɨn do but dasi galak taŋ yobi. Uŋun gen bamot da mukwa sogok mibɨlɨ mibɨlɨ yapmaŋ mudomal.” ");
INSERT INTO yut_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yaŋban Yesu da amɨn nandaŋ kokwini toŋ kɨnda da yosok yaŋ nandaŋek iyɨgɨt, “Piŋkop da Amɨn Kɨla Asak uŋun gak kɨlɨ aŋkwaŋ asal.” Yaŋ yaŋban amɨn morap Yesu gen saŋbeŋek iyɨk do pasalgwit. ");
INSERT INTO yut_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu telagɨ yut nagalgwan egek amɨn yoyɨŋ degek yaŋ yoyɨgɨt, “Gen teban yoyɨŋdet amɨn da gen kɨnda yaŋ yoŋ, ‘Kristo uŋun Dewit dakon yawi dɨwatni.’ Mibɨlɨ nido yaŋ yoŋ? ");
INSERT INTO yut_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dewit Telagɨ Wup da aŋpulugaŋban iyɨ yaŋ yagɨt: ‘Piŋkop da nak dakon Amɨn Tagɨ yaŋ iyɨgɨt, “Gak abɨŋ nak da amɨnsi tet do yɨkbɨ don uwalgo kandap gɨbaŋgogwan yopbo gengo guramɨtni.” ’ ");
INSERT INTO yut_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dewit da uŋun amɨn do Amɨn Tagɨ yaŋ iyɨgɨt, do Kristo uŋun Dewit dakon yawi dɨwatni dɨma, uŋun Amɨn Tagɨni.” Yesu da gen uŋun yaŋakwan mɨŋat amɨn kabɨ madep da nandaŋ galak tawit. ");
INSERT INTO yut_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Aŋakwa Yesu da yoyɨŋ degek yaŋ yoyɨgɨt, “Ji gen teban yoyɨŋdet amɨn da dayɨŋdet aŋ uŋun do pɨndak kɨmotni. Uŋun amɨn ɨlɨkba pɨgɨkni dubagɨ paŋek mɨŋat amɨnyo da makeron ‘gɨldat tagɨ’ yaŋ yoyɨni yaŋ do galak toŋ. ");
INSERT INTO yut_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Muwut muwut yutnikon ae jap noknok bɨsap madepmon amɨn mani toŋ da yɨyɨt tamokon yɨt do galak toŋ. ");
INSERT INTO yut_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Uŋun amɨn sakwabat paŋkewalek yutni tɨmɨkgaŋ. Ae amɨn da pɨndatni yaŋ do bɨsit dubagɨsi aŋ. Uŋuden amɨn gen kokwin bɨsap madepmon kobogɨ do yo jɨgɨsi pakdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu Telagɨ Yut Madepmon wɨgek paret yopyop tamo da kapmatjok yɨkgɨt. Yɨgek pɨndagakwan amɨn morapmɨ da paret yopgwit. Moneŋ morapmɨ taŋ yomgwit amɨn uŋun da moneŋ madep yopgwit. ");
INSERT INTO yut_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Aŋakwa sakwabat yoni mɨni kɨnda da abɨŋ moneŋ gɨmani tabɨlɨ bamorɨ monɨŋɨsisok paret yopyop tamokon yopgut. ");
INSERT INTO yut_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yaŋ yopban kaŋek Yesu da paŋdetni yaŋ paŋmuwugek yaŋ yoyɨgɨt, “Nak asisi dayɨsat, on sakwabat uŋun da paret yopmaŋdak uŋun da amɨn morap da yopmaŋ si yapmaŋdak. ");
INSERT INTO yut_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Amɨn morap uŋun moneŋni morapmɨ taŋ yomaŋakwa dɨwarɨ gɨn paret ɨdapmon yopmaŋ. Mani on mɨŋat wadak wadaksi aŋek moneŋni kɨsi yopmaŋdak. Kɨlɨ jap yumaŋ nosak moneŋni dɨ dɨma taŋ ɨmaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu gat paŋdetni gat telagɨ yut madep dakon nagal yɨpmaŋ waŋga pɨŋakwa monjɨ kɨnda da yaŋ iyɨgɨt, “Yoyɨŋdet, tɨp madepsi baŋ yut tagɨsisi dɨ awit do dɨgo pɨndat!” ");
INSERT INTO yut_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yaŋban Yesu da gen kobogɨ yaŋ iyɨgɨt, “On yut madep pɨndakdal, uŋun dakon tɨp notni da kwenon dɨma taŋ taŋ akdaŋ. Tuwɨlba kɨsisi maŋ mudokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu Ɨleŋ Olipmon yɨgakwan Telagɨ Yut Madep ason tet tagɨt. Aŋakwan Pita, Jems, Jon ae Andru da iyɨ gɨn Yesu yaŋ iyɨwit, ");
INSERT INTO yut_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Gak da gen uŋun yal, uŋun ni bɨsapmon altokdaŋ? Ni yo da mibɨltok altaŋban kaŋek uŋun yo morap altosak dakon bɨsap kwaŋ tosok yaŋ nandaneŋ?” ");
INSERT INTO yut_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yaŋ yaŋba Yesu da yoyɨgɨt, “Amɨn da paŋkewalni do kaŋ kɨmotni. ");
INSERT INTO yut_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Amɨn morapmɨ da abɨŋ nak dakon man yaŋek yaŋ yokdaŋ, ‘Nak naga Kristo.’ Yaŋ yaŋek amɨn morapmɨ paŋkewaldaŋ. ");
INSERT INTO yut_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Uŋun bɨsapmon emat wuwɨk gat ae dubagɨkon emat aŋ uŋun dakon gen bin apba nandaŋek butji dɨma pasolni. Uŋun yo morap altokdaŋ, mani mɨktɨm da mudosak bɨsap madep kɨlɨ uŋun yaŋ dɨma nandani. ");
INSERT INTO yut_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mɨktɨm kɨnda dakon amɨn da pɨdaŋba mɨktɨm kɨnda dakon amɨn gat emat wamdaŋ. Ae kɨla amɨn madep kɨnda dakon amɨn da pɨdaŋba kɨla amɨn madep kɨnda dakon amɨn gat emat wamdaŋ. Aŋakwa mɨktɨm dɨwarɨkon wudɨp akdɨsak, ae mɨktɨm dɨwarɨkon amɨn da jap do madepsi aŋek dɨwarɨ da kɨmotdaŋ. Mɨŋat monjɨ kwapmɨ toŋ da monjɨ altok do aŋek sugaŋba tepmɨ nandaŋ, uŋudeŋ gɨn uŋun yo morap altoni bɨsapmon, bɨsap madep kwaŋ tosok yaŋ nandani. ");
INSERT INTO yut_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Uŋun bɨsapmon ji dɨsi do kɨla ani. Amɨn da gen pikon depdaŋ ae Juda amɨn da muwut muwut yutnon pawɨgɨ nap kɨrɨŋbaŋ baljokdaŋ. Ji nak nandaŋ namaŋ do amɨn da ji paŋkɨ mɨktɨm dakon kɨla amɨn madep da ɨŋamon depba atdaŋ. Uŋun bɨsapmon nak dakon gen yoyɨni. ");
INSERT INTO yut_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mɨktɨm da mudosak bɨsap madep tepmɨ dɨma apdɨsak. Mibɨltok amɨn mɨktɨmɨ mɨktɨmɨ ekwaŋ uŋun da Gen Bin Tagɨsi nandani. ");
INSERT INTO yut_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Amɨn da ji tɨmɨk paŋpaŋ gen pikon depni bɨsapmon dɨma pasolni. Ni gen baŋ yoyɨneŋ yaŋ dɨma nandani. Uŋun bɨsapmon Piŋkop da ni gen dayɨsak uŋun baŋ yoyɨni. Yaŋ aŋakwa ji dakon gen dɨma asak, uŋun Telagɨ Wup dakon gen asak. ");
INSERT INTO yut_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Uŋun bɨsapmon amɨn da yaŋ akdaŋ: peni kɨnda da padɨge uwal da kɨsiron yɨpban aŋakba kɨmotdɨsak, ae amɨn kɨnda da mɨŋat monjɨyoni uwal da kɨsiron yopban dapba kɨmotdaŋ, ae mɨŋat monjɨyo da meŋi datniyo do yaŋ gɨn akdaŋ. ");
INSERT INTO yut_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yaŋ aba ji nak nolgaŋ do aŋek amɨn kɨsi morap da ji do butjap nandakdaŋ. Mani tebai agek egɨ wɨgakwa bɨsap madepmon wɨgɨsak amɨn uŋun Piŋkop da yokwikon baŋ tɨmɨtdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu da saŋbeŋek yaŋ yagɨt, “Yo yokwisi amɨn paŋupbal ak kɨnda don dɨma toktogɨ tamokon akban kokdaŋ.” (On gen manjɨsak amɨn da pakyaŋsi nandɨsak.) “Uŋun bɨsapmon amɨn Judia mɨktɨmon egɨpni uŋun pasal kabapgwan tepmɨsi wɨgɨni. ");
INSERT INTO yut_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Amɨn kɨnda yut kwenon egɨpjak kaŋ, yo kabɨni tɨmɨt do yutgwan dɨma pɨgɨsak. ");
INSERT INTO yut_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","“Ae amɨn kɨnda pigaga egɨpjak kaŋ, yutnon ɨlɨkba pɨgɨkni kɨŋ abɨdok do dɨmasi kɨsak. ");
INSERT INTO yut_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Uŋun bɨsapmon mɨŋat monjɨ kwapni toŋ, ae mɨŋat monjɨ mum noŋ uŋun bupmɨsi. ");
INSERT INTO yut_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ji da Piŋkop bɨsit iyɨŋba nandaŋakwan yo uŋun ais bɨsapmon dɨma altoni. ");
INSERT INTO yut_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Uŋun bɨsapmon yo jɨgɨsi altokdaŋ. Piŋkop da yo morap wasagɨron da egɨ abɨsok ekwamaŋon yo jɨgɨsi uŋuden kɨnda dɨma altagɨt. Ae buŋon yo jɨgɨ uŋuden aeni dɨma altokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Amɨn Tagɨ da uŋun bɨsap dɨma aŋpɨsɨp asak tam mɨŋat amɨn morap kɨsi pasɨlnom. Mani mɨŋat amɨn kabɨ iyɨ do kɨlɨ manjɨgɨt uŋun do bupmɨ nandaŋek bɨsap aŋpɨsɨp akdɨsak. ");
INSERT INTO yut_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Uŋun bɨsapmon amɨn kɨnda da ‘Kristo oni!’ bo ‘Asoni!’ yaŋ yaŋban kaŋ, geni dɨma nandaŋ gadani. ");
INSERT INTO yut_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Amɨn dɨwarɨ da abɨŋ ‘Nak Kristo’ yaŋ yokdaŋ. Ae dɨwarɨ da ‘Nak kombɨ amɨn kɨnda’ yaŋ yokdaŋ. Yaŋ yaŋek wasok tapmɨmɨ toŋ mibɨlɨ mibɨlɨ akdaŋ. Aŋek mɨŋat amɨn kabɨ Piŋkop da iyɨ do kɨlɨ manjɨkbi uŋun paŋkɨlɨkba kosit kɨlegɨ yɨpmaŋ detni do pini madep akdaŋ. Mani arɨpmɨ dɨma akdaŋ. ");
INSERT INTO yut_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yo jɨgɨsi morap uŋun dɨma altaŋakwa wagɨl dayɨsat, do dɨsi kaŋ kɨmotni.” ");
INSERT INTO yut_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yesu da saŋbeŋek yaŋ yagɨt, “Yo jɨgɨ dakon bɨsap mudaŋakwan ‘gɨldat dabɨl pɨlɨn tuk akdɨsak, ae kanek dɨma teŋteŋokdɨsak. ");
INSERT INTO yut_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ae gɨk kundu yɨpmaŋek mokdaŋ, aŋakwa kwen kundukon yo tebai toŋ uŋun da kwakwalɨtdaŋ.’ ");
INSERT INTO yut_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Uŋun bɨsapmon amɨn da Amɨn Dakon Monji kaŋba tapmɨmni ae tɨlɨmni gat gɨkwemon da apban kokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Uŋun da aŋelo kabɨni yabekban kɨŋ amɨn iyɨ do manjɨkbi kabɨ mɨktɨmɨ mɨktɨmɨ ekwaŋ uŋun paŋmuwutdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesu da saŋbeŋek yaŋ yagɨt, “Ji pik kɨndap kaŋek butji pɨsosak. Kɨlɨŋɨ pakbini toŋ ae tamɨ kaluk yopmaŋdak, uŋun bɨsapmon gɨldat bɨsap kwaŋ tosok yaŋ nandaŋ. ");
INSERT INTO yut_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Uŋudeŋ gɨn yo morap dayɨt uŋun da altaŋakwa mɨktɨm da mudosak bɨsap madep kɨlɨ uŋunjok kwaŋ tosok yaŋ nandani. ");
INSERT INTO yut_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nak asisi dayɨsat, amɨn uŋun bɨsapmon nani dɨma kɨmagakwa yo morap uŋun kɨsi altaŋ mudokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kundu gat mɨktɨm gat pasɨldamal, mani nak dakon gen uŋun dɨmasi pasɨldɨsak.” ");
INSERT INTO yut_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesu da saŋbeŋek yaŋ yagɨt, “Yo morap altokdɨsak uŋun dakon bɨsap amɨn kɨnda da dɨma nandɨsak. Kwen Kokup aŋeloyo dɨma nandaŋ, ae Monjɨyo kɨsi dɨma nandɨsak. Dat da iyɨ gɨn nandɨsak. ");
INSERT INTO yut_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yo morap altokdaŋ dakon bɨsap ji dɨma nandaŋ, do kaŋ kɨmagek egɨpni.” ");
INSERT INTO yut_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yaŋ yaŋek tɨlak gen kɨnda yaŋ yoyɨgɨt, “Amɨn kɨnda kokup kɨndakon kɨk do aŋek oman amɨni do pi kokwinɨk yomɨŋek yut dakon kɨla ani do yoyɨsak. Aŋek yoma sopsop dakon kɨla amɨn yoma kɨlani tebai asak do iyɨsak. ");
INSERT INTO yut_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Uŋun do aŋek ji kaŋ kɨmotni. Ji yut dakon ami ni bɨsapmon apjak uŋun dɨma nandaŋ. Apjak bɨsap uŋun pɨlɨndo bo kalbi binap bo pup da gen yosok bɨsapmon bo wɨsa dagokdo uŋun ji dɨma nandaŋ. ");
INSERT INTO yut_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tepmɨ abɨŋ dandaban dɨpmɨn potni kaŋ, uŋun tagɨ dɨma. ");
INSERT INTO yut_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Gen dayɨsat uŋun amɨn morap kɨsi do yosot. Kaŋ kɨmotni.” ");
INSERT INTO yut_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gɨldat bamorɨ egek don Yapyap Bɨlak ae Bret Yisni Mɨni Dakon Jap Noknok Bɨsap Madep altok do aŋakwan mukwa sogok amɨn dakon amɨn madep kabɨ ae gen teban yoyɨŋdet amɨn da muwugek yaŋ yawit, “Niaŋ aŋek Yesu aŋkewalek abɨdaŋ aŋatno kɨmotjak?” ");
INSERT INTO yut_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yaŋ yaŋek yawit, “Telagɨ bɨsap madepmon dɨma abɨdoneŋ. Yaŋ aneŋ kaŋ, mɨŋat amɨnyokon pɨdok pɨdok noman tokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu Betani kokupmon amɨn kɨnda mani Saimon uŋun da yutnon yɨkgɨt. (Saimon uŋun kalɨp wuda tebani toŋ egɨpgut.) Yesu jap noknok tamokon yɨgakwan mɨŋat kɨnda pakbi kɨbaŋɨ toŋ tagɨsi kɨnamɨ kɨnda abɨdaŋek wɨgɨgɨt. Awɨŋ gapmɨ jokgalek Yesu da busuŋon tagalgɨt. (Uŋun pakbi dakon yumaŋ nogɨ madepsi ae tɨbɨrɨ uŋun tɨpnaŋ wasaŋbi.) ");
INSERT INTO yut_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yaŋ aban amɨn dɨwarɨ da kaŋek burɨ yokwi taŋba notni yoyɨŋ yoyɨŋ aŋek yaŋ yawit, “Nidosi pakbi kɨbaŋɨ toŋ tagɨsi uŋun yumsi tagaldak? ");
INSERT INTO yut_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Amɨn da yubam tam, moneŋ madepsi tɨmɨk yoni mɨni amɨn do yomnom.” Yaŋ yaŋek mɨŋat uŋun gen tebai iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Iyɨŋba Yesu da nandaŋek yaŋ yoyɨgɨt, “Ji mɨŋat on yum koni. Nido jɨgɨ ɨmaŋ? Mɨŋat on nak do yo tagɨsi asak. ");
INSERT INTO yut_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yoni mɨni amɨn ji gat bɨsapmɨ bɨsapmɨ egɨpdaŋ, do tagɨ paŋpulugoni. Mani nak ji gat bɨsapmɨ bɨsapmɨ dɨma egɨpdamaŋ. ");
INSERT INTO yut_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yo mɨŋat da agagɨ kɨlɨ aban dagak. Nak kɨmokgo gapmakon nepni do uŋun mɨŋat da pakbi kɨbaŋɨ toŋ naŋ kɨlɨ soŋ namɨk. ");
INSERT INTO yut_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nak asisi dayɨsat, mɨktɨmɨ mɨktɨmɨ amɨn da Gen Bin Tagɨsi yoyɨŋek mɨŋat on da yo ak uŋun dakon gen bin kɨsi yoyɨŋakwa nandakdaŋ. Aŋek uŋun mɨŋat dakon man bini dɨma pasɨldɨsak.” ");
INSERT INTO yut_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Uŋun bɨsapmon paŋdetni 12 kabɨkon kɨnda egɨpgut mani Judas Iskariot. Uŋun da mukwa sogok amɨn dakon amɨn madep kabɨkon kɨŋek Yesu kɨsitnikon yɨpjak do yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yoyɨŋban but galak nandaŋek moneŋ ɨmni do yaŋ teban tawit. Judas uŋun nandaŋek Yesu kɨsitnikon yɨpjak dakon kosit wɨsɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Aŋakwan Bret Yisni Mɨni Dakon Jap Noknok Bɨsap Madep altagɨt. Uŋun bɨsapmon Israel amɨn da Yapyap Bɨlak do nandaŋek sipsip monɨŋ dapmaŋ soŋ noŋ. Uŋun bɨsapmon paŋdetni da Yesu yaŋ iyɨwit, “Nin kɨŋ dukwan Yapyap Bɨlak dakon jap paŋkosit aneŋ do nandɨsal?” ");
INSERT INTO yut_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yaŋ yaŋba Yesu da paŋdetni bamorɨ yabegek yaŋ yoyɨgɨt, “Kokupmon kɨŋ kaŋbal amɨn kɨnda pakbi kwoba kɨnda guramɨk apban jil gat domdom akdaŋ. Jil uŋun amɨn naŋ yol aŋkɨnjil. ");
INSERT INTO yut_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kaŋbal yut kɨndakon wɨkwan kaŋ, uŋun yut dakon ami yaŋ iyɨnjil, ‘Yoyɨŋdetnit da yosok, “Nak gat paŋdetnoni gat da Yapyap Bɨlak dakon jap noneŋ dakon yut burɨ dukwan tosok?” ’ ");
INSERT INTO yut_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yaŋ iyɨŋbal uŋun amɨn da yut madep kɨnda kwen nani do dolɨsak. Uŋun yutnon jap noknok tamo ae amɨn yɨyɨt tamo kɨlɨ paŋnoman abi da toŋ. Uŋudon japnin paŋkosit anjil.” ");
INSERT INTO yut_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yoyɨŋban kokupmon kɨŋ Yesu da yo morap do yoyɨgɨt uŋudeŋsi pɨndakgɨmal. Yaŋ pɨndagek Yapyap Bɨlak dakon jap paŋkosit agɨmal. ");
INSERT INTO yut_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pɨlɨn pɨlɨndo Yesu gat paŋdetni 12 kabɨ gat uŋun yutnon opgwit. ");
INSERT INTO yut_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Obɨŋ jap noknok tamokon jap naŋ yɨgek Yesu da yaŋ yoyɨgɨt, “Nak asisi dayɨsat, jikon da kɨnda da nak uwalno da kɨsiron nepdɨsak. Uŋun amɨn nin gat yɨgek jap nomaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yaŋ yaŋban paŋdetni burɨ yokwi taŋba kaloŋ kaloŋ yaŋ yawit, “Nak dɨma, ma?” ");
INSERT INTO yut_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yaŋ yaŋba Yesu da yoyɨgɨt, “12 kabɨ jikon kɨnda nak gat bret ɨdapmon sɨbɨŋek nomak uŋun. ");
INSERT INTO yut_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Asi, Piŋkop da papiakon gen mandabi uŋun da arɨpmon Amɨn Dakon Monji kɨmot akdɨsak. Mani Amɨn Dakon Monji uwal da kɨsiron yɨpjak amɨn, awa! Uŋun amɨn meŋi da dɨma aŋalagɨt tam tagɨ.” ");
INSERT INTO yut_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jap naŋ yɨgakwa Yesu da bret kɨnda abɨdaŋ, Piŋkop ya yaŋ iyɨŋek, pudaŋ paŋdetni do yomgut. Yomɨŋek yaŋ yoyɨgɨt, “Tɨmɨgek noni, on nak dakon gɨptɨm tɨmno.” ");
INSERT INTO yut_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yaŋ yaŋek aeni wain kɨnam abɨdaŋek, Piŋkop ya yaŋ iyɨŋek, yoban kɨsi da nawit. ");
INSERT INTO yut_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Naŋakwa Yesu da saŋbeŋek yaŋ yoyɨgɨt, “On yawino. Amɨn morapmɨ gat saŋbek saŋbek ak do parekdat. ");
INSERT INTO yut_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nak asisi dayɨsat, nak wain ae dɨma naŋek egɨ wɨgɨ Piŋkop da Amɨn Kɨla Agak kokupmon don wain kalugɨ nokeŋ.” ");
INSERT INTO yut_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yaŋ yaŋban kap kɨnda yaŋek yomakon pɨgek Ɨleŋ Olipmon wɨgɨwit. ");
INSERT INTO yut_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ɨleŋ Olipmon wɨgakwa Yesu da paŋdetni yaŋ yoyɨgɨt, “Piŋkop da papiakon gen kɨnda tosok uŋun da arɨpmon ji manji namdaŋ. Gen uŋun yaŋ: ‘Sipsip dakon kɨla amɨn aŋakgo kɨmagakwan sipsip waseŋ kɨ iyɨ iyɨ kɨkdaŋ.’ ");
INSERT INTO yut_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mani kɨmoron da pɨdaŋek nak da kalɨp Galili mɨktɨmon mibɨltaŋ damɨŋek kɨkeŋ.” ");
INSERT INTO yut_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yaŋban Pita da yaŋ iyɨgɨt, “Amɨn dɨwarɨ dakon nandaŋ gadat wɨtdal kɨsak kaŋ, nak yaŋ arɨpmɨ dɨma abeŋ.” ");
INSERT INTO yut_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yaŋ yaŋban Yesu da iyɨgɨt, “Nak asisi gayɨsat, abɨsok kalbi pup kosit bamot dɨma yaŋakwan gak da nak do wasɨp kosit kapbɨ yokdɨsal.” ");
INSERT INTO yut_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yaŋban Pita da yaŋ iyɨgɨt, “Uwal da gɨgek nakyo kɨsi nɨt do ani kaŋ, gak do wasɨp dɨma yokeŋ.” Yaŋ yaŋban notni kabɨ kɨsi yaŋ gɨn yawit. ");
INSERT INTO yut_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu gat paŋdetni gat mɨktɨm kɨnda mani Getsemani uŋudon kɨwit. Kɨŋ altaŋek Yesu da yaŋ yoyɨgɨt, “Ji ɨdon yɨgakwa nak bɨsit akeŋ.” ");
INSERT INTO yut_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yaŋ yaŋek Pita, Jems, ae Jon kɨsi tɨmɨkban kɨwit. Kɨŋ burɨkon jɨgɨ madepsi nandaŋek ");
INSERT INTO yut_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","yaŋ yoyɨgɨt, “Butno jɨk taŋakwan kɨmot kɨmotno noman taŋ naban nandɨsat. Do ji ɨdon Piŋkop do nandaŋek egɨpni.” ");
INSERT INTO yut_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yaŋ yaŋek aŋgwikon kɨŋ mɨktɨmon maŋ pagek bɨsit agɨt. Kosit kɨnda tosagon uŋun bɨsap yokwi yapjak yaŋ nandaŋek bɨsit yaŋ yagɨt, ");
INSERT INTO yut_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Aba, Dat, gak da yo morap tagɨ aki. Do nak da kwenon jɨgɨ apdɨsak uŋun kukwoki do nandɨsat. Mani nak dakon galaktok dɨma yolgi, gaga dakon galaktok uŋun gɨn yolgi.” ");
INSERT INTO yut_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yaŋ yaŋek tobɨl paŋdetni kapbɨ egɨpgwiron kɨŋ pɨndakban dɨpmɨn pakgwit. Pɨndagek Pita yaŋ iyɨgɨt, “Saimon, gak dɨpmɨn pokdol, ma? Bɨsap awa kaloŋɨ da arɨpmon gɨn nak gat Piŋkop do nandaŋek dɨma egɨpneŋ? ");
INSERT INTO yut_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ji teban taŋek bɨsit aŋek egɨpni. Yaŋ aŋek egɨpni kaŋ, paŋkewalon arɨpmɨ dɨma moni. But da nak nol do galak tosok mani gɨp dakon teban tokni mɨni.” ");
INSERT INTO yut_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yaŋ yaŋek aeni tobɨlek kɨŋ bɨsit mibɨltok agɨt uŋudeŋ gɨn agɨt. ");
INSERT INTO yut_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bɨsit aŋek abɨŋ pɨndakban paŋdetni dɨpmɨn do yokwisi aŋek aeni dɨpmɨn sigɨn pakgwit. Paŋyolban pɨdaŋ ni gen naŋ iyɨneŋ yaŋ do ɨŋtaŋek ɨsal yɨkgwit. ");
INSERT INTO yut_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Aeni kɨŋ bɨsit aŋ tobɨl abɨŋ paŋdetni yaŋ yoyɨgɨt, “Ji dɨpmɨn sigɨn pagek tapmɨm paŋ, ma? Dɨpmɨn arɨpmɨ kwayɨŋ. Bɨsap kɨlɨ abɨk. Amɨn Dakon Monji yokwi pakpak da kɨsiron kɨlɨ uŋun yɨpmaŋgaŋ. ");
INSERT INTO yut_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pɨdaŋba kɨno! Kabɨt, uwal da kɨsiron nepjak amɨn kɨlɨ abɨk.” ");
INSERT INTO yut_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu gen yaŋakwan uŋudon gɨn paŋdetni 12 kabɨkon da kɨnda mani Judas altaŋ yomgut. Amɨn kabɨ madep emat agak sɨbani ae kɨndap kɨrɨŋni tɨmɨgek buŋon yolgwit. Mukwa sogok amɨn dakon amɨn madep kabɨ ae gen teban yoyɨŋdet amɨn ae kɨla amɨn uŋun da yabekba apgwit. ");
INSERT INTO yut_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Uwal da kɨsiron yɨpyɨp amɨn da gen kɨnda kɨlɨ yaŋ yoyɨgɨt, “Amɨn kɨnda nak da mandaŋ noko kaŋ, uŋun amɨn naŋ abɨdoni. Abɨdaŋek kɨlani tebai aŋek aŋaŋ kɨni.” ");
INSERT INTO yut_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas uŋudon gɨn Yesukon kɨŋ altaŋek yaŋ iyɨgɨt, “Yoyɨŋdet!” Yaŋ iyɨŋek mogɨmɨkon mandaŋ nagɨt. ");
INSERT INTO yut_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yaŋ aban kaŋek Yesu tebai abɨdawit. ");
INSERT INTO yut_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aba uŋun akgwit kabɨkon da kɨnda da emat agak sɨbani ɨlɨkgɨt. Ɨlɨgek mukwa sogok amɨn dakon mibɨltok amɨn dakon oman monjɨ mɨragɨ mandaŋ dagagɨt. ");
INSERT INTO yut_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Mandaŋ dagaŋban Yesu da obip amɨn yaŋ yoyɨgɨt, “Ji nak do kabo noknok kɨnda yaŋ nandaŋek emat agak sɨba ae kɨndap kɨrɨŋ tɨmɨgek nak abɨdok do abeŋ, ma? ");
INSERT INTO yut_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nak gɨldarɨ gɨldarɨ Telagɨ Yut Madep da nagalgwan ji gat egek amɨn yoyɨŋ dekgɨm. Uŋun bɨsapmon nak abɨdok do dɨma nandawit? Mani Piŋkop da papiakon nak do gen mandabi uŋun da arɨpmon noman tosak.” ");
INSERT INTO yut_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Yaŋ yaŋban paŋdet morapni yɨpmaŋek pasal kɨŋ mudawit. ");
INSERT INTO yut_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kɨŋ mudaŋakwa monjɨsok kɨnda ɨmalni kwakwagɨ kɨndanaŋ gɨn ɨmegek Yesu yolgɨt. Emat amɨn da uŋun monjɨsok kɨsi abɨdok do awit, ");
INSERT INTO yut_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","mani ɨmalni naŋ kukwaŋek pasal molaŋ molaŋ kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesu abɨdawit amɨn uŋun da Yesu abɨdaŋ aŋaŋ mukwa sogok amɨn dakon amɨn madep kabɨ da yutnon wɨgɨwit. Uŋun yutnon mukwa sogok amɨn dakon mibɨltok amɨn ae gen teban yoyɨŋdet ae kɨla amɨn kɨsi muwuk egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita kagɨ kagɨsok da Yesu yol aŋkɨŋek, mukwa sogok amɨn dakon mibɨltok amɨn da nagalgwan pɨgɨgɨt. Pɨkwan obip amɨn gat kɨndapmon yɨgek kɨndapni alɨwit. ");
INSERT INTO yut_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Aŋakwan mukwa sogok amɨn dakon amɨn madep kabɨ gat ae gen kokwin amɨn kɨsi morap gat da yaŋ nandawit, amɨn dɨ yaŋ yomno abɨŋ Yesu top gen yaŋ ɨmɨŋek gulusuŋ agɨt yaŋ yaŋakwa aŋatno kɨmotjak yaŋ nandawit, mani Yesu suŋ kɨnda dɨma agɨt yaŋ kawit. ");
INSERT INTO yut_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Aŋakwa amɨn morapmɨ da Yesu do top sɨtnok genyo yaŋba geni dakon kosirɨ dɨma pɨsagɨt. ");
INSERT INTO yut_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Aba amɨn dɨwarɨ da pɨdaŋ Yesu do top sɨtnok gen yaŋ yawit, ");
INSERT INTO yut_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nin da nandaŋapno Yesu da yaŋ yagɨt, ‘Nak da Telagɨ Yut Madep amɨn da awit uŋun tuwɨlek gɨldat kapbɨ da butgwan yut ŋwakŋwarɨ kɨnda abeŋ. Yut uŋun amɨn kɨsit da agagɨ dakon tɨlak dɨma abeŋ.’ ” ");
INSERT INTO yut_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mani gen uŋun yawit uŋun kɨsi upbal taŋek gen dakon kosirɨ dɨma pɨsagɨt. ");
INSERT INTO yut_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kɨlɨ mukwa sogok amɨn dakon mibɨltok amɨn kɨla amɨn da ɨŋamon agek Yesu yaŋ iyɨgɨt, “Gak gen kobogɨ kɨnda dɨma yoyɨki? On amɨn morap gen yaŋ gaba niaŋ nandaŋ yomɨsal?” ");
INSERT INTO yut_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mani Yesu gen kagani sopmaŋek gen kobogɨ kɨnda dɨma iyɨgɨt. Yaŋ aban mukwa sogok amɨn dakon mibɨltok amɨn da aeni iyɨgɨt, “Gak Kristo? Gak Piŋkop gawak ɨmamaŋ uŋun dakon Monji bo dɨma?” ");
INSERT INTO yut_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yaŋban Yesu da yaŋ yagɨt, “Uŋun nak mani. Ji don kaŋakwa Amɨn Dakon Monji Tapmɨm Ami da amɨnsi tet do yɨkban kokdaŋ. Aŋek kaŋakwa Kwen Kokup dakon gɨkwemon da apban kokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yaŋ yaŋban nandaŋek mukwa sogok amɨn dakon mibɨltok amɨn iyɨ dakon paba pɨgɨkni pudagɨt. Yaŋ aŋek yagɨt, “Mibɨlni nandak do amɨn nido saŋbeŋek yoyɨno apni? ");
INSERT INTO yut_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Iyɨ do ‘nak Piŋkop dakon Monji’ yaŋ yosok, do ji da niaŋ aŋ ɨmneŋ do nandaŋ?” Yaŋban kɨsi morap da yawit, “Gulusuŋ asak, do si kɨmotjak.” ");
INSERT INTO yut_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yaŋ yaŋek dɨwarɨ da ɨlɨp sul ɨmgwit. Yaŋ aŋek dabɨlɨ ɨmal naŋ wamaŋ sopmaŋek kɨsit da aŋakgwit. Kɨsit da aŋagek yaŋ iyɨwit, “Namɨn da gɨkdak? Kombɨ gen ya!” Yaŋ iyɨŋakwa obip amɨn da abɨdaŋek aŋakgwit. ");
INSERT INTO yut_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Aŋakwa Pita uŋun yut da nagalgwan egakwan mukwa sogok amɨn dakon mibɨltok amɨn dakon oman mɨŋatjok kɨnda da opgut. ");
INSERT INTO yut_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Obɨŋ Pita kɨndap alɨŋek ekwan kagɨt. Mɨŋat uŋun da pakyaŋsi yɨpban kwan kaŋek yaŋ iyɨgɨt, “Gak Yesu Nasaret kokupmon nani gat kɨsi egɨpgumal.” ");
INSERT INTO yut_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Yaŋban Pita da wasɨp yaŋek yagɨt, “Gak da gen uŋun yosol nak dɨma nandɨsat.” Yaŋ yaŋek nagalon da wigat mibɨlon pɨgɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Aŋakwan oman mɨŋatjok uŋun da Pita aeni kaŋek amɨn uŋudon akgwit yaŋ yoyɨgɨt, “On amɨn uŋun Yesu da kabɨkon nani kɨnda.” ");
INSERT INTO yut_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mani aeni wasɨp yaŋek yagɨt, “Dɨma.” Tɨmɨsok dɨ egek amɨn kapmatjok akgwit uŋun da yaŋ iyɨwit, “Gak asi Yesu da kabɨkon nani kɨnda. Gak Galili amɨn kɨnda.” ");
INSERT INTO yut_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yaŋ yaŋba Pita da tebaisi yaŋek yagɨt, “Asisi dayɨsat, amɨn uŋun yoŋ nak dɨmasi nandaŋ ɨmɨsat. Top yosot kaŋ, jobɨt tagɨ tɨmɨkgeŋ.” ");
INSERT INTO yut_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Yaŋ yaŋakwan uŋudon gɨn pup gen yaŋban kosit bamot agɨt. Yaŋban nandaŋek Pita Yesu da gen yagɨt uŋun do nandagɨt. Gen uŋun yaŋ yagɨt, “Nak dakon man kosit kapbɨ wasɨp yaŋaki pup da kosit bamot gen yosak.” Gen uŋun do nandaŋek burɨ yokwi taŋban kunam madepsi takgɨt. ");
INSERT INTO yut_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wɨsawɨsa do mukwa sogok amɨn dakon amɨn madep kabɨ ae kɨla amɨn ae gen teban yoyɨŋdet amɨn ae gen kokwin amɨn kabɨ morap gat da muwugek gen kɨnda aŋteban awit. Aŋek Yesu nap teban naŋ wamaŋ ɨlɨk aŋaŋ Pailat da kɨsiron aŋkɨ yɨpgwit. ");
INSERT INTO yut_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Yɨpba Pailat da Yesu yaŋ iyɨgɨt, “Gak Juda amɨn dakon kɨla amɨn madep, ma?” Yaŋban Yesu da gen kobogɨ yaŋ yagɨt, “Yosol uŋun mani.” ");
INSERT INTO yut_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yaŋ yaŋban mukwa sogok amɨn dakon amɨn madep kabɨ da gen morapmɨ yaŋ ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yaŋba Pailat da aeni Yesu yaŋ iyɨgɨt, “Gak gen kobogɨ kɨnda dɨma yoyɨki? Amɨn on da yokwi agɨl do gen morapmɨ yaŋ gamaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yaŋ yaŋban Yesu da gen kobogɨ kɨnda dɨma yagɨt. Yaŋ aban kaŋek Pailat nandaban ŋwakŋwarɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bɨlagɨ bɨlagɨ Yapyap Bɨlak bɨsapmon wasok kɨnda yaŋ awit: Juda mɨŋat amɨnyo da dam tebanon yɨkdak amɨn kɨnda dakon man yaŋakwa, Pailat da yopban kɨŋ kɨŋ awit. ");
INSERT INTO yut_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yesu gen pikon yɨpgwit bɨsapmon amɨn kɨnda mani Barabas uŋun gat notni gat dam tebanon yɨkgwit. Uŋun amɨn kabɨ Rom gapman do japmɨ nandaŋek emat wamaŋek amɨn kɨnda aŋakba kɨmakgɨt. Uŋun do dam tebanon yopgwit. ");
INSERT INTO yut_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kɨlɨ amɨn morapmɨ da Pailaron kɨŋ altaŋek yaŋ iyɨwit, “Bɨlagɨ bɨlagɨ asal, uŋudeŋ gɨn dam tebanon yɨkdak kɨnda pulugaŋ yɨpbɨ kɨsak.” ");
INSERT INTO yut_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Yaŋba Pailat da yaŋ yoyɨgɨt, “Juda amɨn dakon kɨla amɨn madep naŋ yɨpbo kɨsak do nandaŋ?” ");
INSERT INTO yut_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat yaŋ yagɨt nido iyɨ nandagɨt: mukwa sogok amɨn dakon amɨn madep kabɨ Yesu do nandaba yokwi taŋban top yaŋek gen pikon yɨpgwit. ");
INSERT INTO yut_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mani mukwa sogok amɨn dakon amɨn madep kabɨ da mɨŋat amɨn kabɨ madep burɨ sugaŋek yaŋ yoyɨwit, “Ji Pailat da Barabas naŋ yɨpban kɨsak do iyɨni.” Yaŋ yoyɨŋba amɨn da yaŋ gɨn iyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Yaŋba Pailat da aeni yoyɨgɨt, “On amɨn ji da ‘Juda amɨn dakon kɨla amɨn madep’ yaŋ iyaŋ, niaŋ aŋ ɨbeŋ do nandaŋ?” ");
INSERT INTO yut_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yaŋban yaŋ tɨdaŋek yawit, “Tɨlak kɨndapmon aŋakbɨ kɨmotjak!” ");
INSERT INTO yut_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Yaŋba yoyɨgɨt, “Mibɨlɨ nido? Ni gulusuŋ naŋ agɨt?” Yaŋban mibɨltok yawit si yapmaŋek madepsi yaŋ tɨdaŋek yawit, “Tɨlak kɨndapmon aŋakbɨ kɨmotjak!” ");
INSERT INTO yut_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Yaŋba Pailat da amɨn dakon burɨ moni do Barabas pulugaŋ yɨpban mɨŋat amɨn kabɨyokon kɨgɨt. Kɨŋakwan emat amɨn yoyɨŋban Yesu baljawit. Aba don tɨlak kɨndapmon aŋakba kɨmotjak do yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Emat amɨn da Yesu abɨdaŋ aŋaŋ gapman yut madep da nagalgwan pɨgɨwit. Pɨgek emat amɨn notni dɨwarɨ kɨsisi yaŋ yoba abɨŋ mudawit. ");
INSERT INTO yut_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Muwugek Yesu do paba pɨgɨk gami kɨnda paŋ ɨmgwit. Yaŋ aŋek nap kelɨ toŋ kɨnda naŋ kɨla amɨn madep dakon pelɨt yombem kɨnda wasaŋek busuŋɨkon wamaŋ ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wamaŋ ɨmɨŋek top iyɨŋek yaŋ yawit, “Gɨldat tagɨ, Juda amɨn dakon kɨla amɨn madep!” ");
INSERT INTO yut_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Yaŋ yaŋek kɨndap kɨrɨŋ naŋ busuŋɨkon aŋagek ɨlɨp sul ɨmgwit. Yaŋ aŋek gawak ɨmɨŋek toptopmon da man madep ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Aŋek topmon da man madep ɨmɨŋ mudaŋek ɨmal gami ɨlɨgek iyɨ dakon pabɨ pɨgɨk paŋ ɨmgwit. Paŋ ɨmɨŋek tɨlak kɨndapmon aŋakba kɨmotjak do ɨlɨk aŋaŋ kɨwit. ");
INSERT INTO yut_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kosiron kɨŋ amɨn kɨnda kokup pap kɨk do apban kawit, mani Saimon. Uŋun Sairini kokupmon nani kɨnda, Aleksanda gat Rupas gat dakon datni. Emat amɨn da Saimon gen tebai iyɨŋba Yesu dakon tɨlak kɨndapni guramɨkban kɨwit. ");
INSERT INTO yut_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kɨŋ mɨktɨm tɨm kɨnda mani Golgata uŋudon altawit. (Golgata uŋun dakon mibɨlɨ uŋun Busuŋ Kɨdat Ɨleŋ.) ");
INSERT INTO yut_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kɨŋ altaŋek wain gat pakbi ɨsipmɨ kɨnda mani mea gat ɨktagɨlek ɨmɨŋba nok do kurak tagɨt. ");
INSERT INTO yut_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Aŋek tɨlak kɨndapmon aŋakgwit. Aŋagek ɨmalni tɨmɨt do satu wasok awit. ");
INSERT INTO yut_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wɨsa dagokdo 9 kilok aŋakwan aŋakgwit. ");
INSERT INTO yut_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aŋagek mibɨlɨ yaŋ do aŋakgamaŋ uŋun dakon but pɨso gen yaŋ mandawit, JUDA AMƗN DAKON KƗLA AMƗN MADEP. ");
INSERT INTO yut_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yesu da ɨleŋ bamoron kabo noknok bamorɨ kɨsi dapgwit. ");
INSERT INTO yut_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Dapba Piŋkop da papiakon gen tosok uŋun bamɨ noman tagɨt. Gen uŋun yaŋ: “Yokwi pakpak amɨn uŋun kabɨkon aŋakbi.” ");
INSERT INTO yut_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Amɨn kɨŋ ap awit uŋun da yaŋba yokwi tok aŋ ɨmɨŋek wunda kwalkwal aŋek yaŋ iyɨwit, “Ae! Gak Telagɨ Yut Madep tuwɨlek gɨldat kapbɨ da butgwan kaluk ak do yagɨl, ");
INSERT INTO yut_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","do gɨptɨmgo aŋkutnaŋek tɨlak kɨndapmon da pɨ!” ");
INSERT INTO yut_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Yaŋ yaŋba mukwa sogok amɨn dakon amɨn madep kabɨ ae gen teban yoyɨŋdet amɨn kɨsi yaŋ gɨn notni yoyɨŋ yoyɨŋ aŋek aŋsolat aŋek yaŋ yawit, “Amɨn dɨwarɨ paŋpulugagɨt da nido iyɨ dakon gɨptɨm aŋpulugok do aŋtɨdok asak? ");
INSERT INTO yut_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","On amɨn Kristo, asi Juda amɨn dakon Kɨla Amɨn Madepni kaŋ, tɨlak kɨndapmon da pɨŋban kaŋek nandaŋ gadaŋ ɨmneŋ.” Uŋudeŋ gɨn kabo noknok bamot terɨ terɨ dapbi uŋunyo kɨsi yaŋba yokwi tok aŋ ɨmgumal. ");
INSERT INTO yut_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Gɨldat binap 12 kilok aŋakwan mɨktɨm kɨsi pɨlɨn tuk aŋakwan kɨŋ pɨlɨndo 3 kilok agɨt. ");
INSERT INTO yut_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kɨŋ 3 kilok aŋakwan Yesu da yaŋ tɨdaŋek yaŋ yagɨt, “Eloi, eloi lama sabaktani?” Gen uŋun dakon mibɨlɨ yaŋ: “Piŋkopno, Piŋkopno, nido nepmaŋ dekdal?” ");
INSERT INTO yut_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Yaŋ yaŋban amɨn dɨwarɨ kapmatjok akgwit uŋun nandaŋek yawit, “Nandaŋ, uŋun Elaija do yaŋ ɨmɨsak.” ");
INSERT INTO yut_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yaŋba amɨn kɨnda tɨmtɨm yaŋek kɨŋ yo kɨnda gugɨdan yombem jol dɨwaron wamaŋ wain gat ae pakbi ɨsɨpmɨ gat uŋungwan sɨbɨŋek Yesu da nosak do aŋenakgɨt. Aŋenagek yaŋ yagɨt, “Ji yɨpba koneŋ. Elaija da asi abɨŋ tɨlak kɨndapmon naŋ abɨdaŋ abɨŋban koneŋ, bo dɨma.” ");
INSERT INTO yut_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yaŋ yaŋban Yesu madepsi yaŋ tɨdaŋek kɨmakgɨt. ");
INSERT INTO yut_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kɨmagakwan Telagɨ Yut Madep dakon yoma ɨmal uŋun kwen da sulugɨ pɨŋ mibɨlɨkon dagaŋ kɨ tɨmɨ bamorɨ agɨt. ");
INSERT INTO yut_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aŋakwan emat amɨn 100 dakon kɨla amɨn da Yesu ɨŋamɨkon kɨmakban kaŋek yagɨt, “On amɨn asisi Piŋkop dakon Monji egɨpgut.” ");
INSERT INTO yut_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aŋakwan mɨŋat dɨwarɨ dubagɨsogon da agek pɨndak nandaŋyo awit. Uŋun mɨŋat kabɨkon kɨnda mani Maria, kokupni Makdala, ae Maria ŋwakŋwarɨ kɨnda uŋun Jems buŋon nani gat Josep gat dakon meŋi, ae Salome gat kɨsi akgwit. ");
INSERT INTO yut_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yesu Galili mɨktɨmon egɨpgut bɨsapmon uŋun mɨŋat kabɨ da yol awɨlek oman aŋ ɨmɨŋek egɨpgwit. Uŋun dagɨn dɨma, ae mɨŋat dɨwarɨ kɨsi Yesu gat Jerusalem kokup papmon kɨwit uŋun kɨsi kaŋakwa Yesu kɨmakgɨt. ");
INSERT INTO yut_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sabat dakon tagaptok bɨsap Neŋgo pɨlɨndo ");
INSERT INTO yut_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josep Arimatea kokupmon nani da apgut. Uŋun gen kokwin amɨn kabɨ dakon kɨla amɨn egɨpgut. Amɨn morapmɨ da nandaba wukwan ɨmgwit. Ae uŋun Piŋkop da Amɨn Kɨla Akdɨsak uŋun do jomjom aŋek egɨpgut. Josep uŋun pasol pasolɨ mɨni Pailaron kɨŋ Yesu dakon bumjotni abɨdok do iyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Iyɨŋban Pailat da emat amɨn 100 dakon kɨla amɨn yaŋ ɨban opban iyɨgɨt, “Asi Yesu kuŋwak, bo dɨma?” ");
INSERT INTO yut_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Iyɨŋban emat amɨn 100 dakon kɨla amɨn da yaŋ yagɨt, “Asi kuŋwak.” Yaŋ yaŋban nandaŋek Josep da bumjot aŋkɨsak do yaŋ mudaŋ ɨmgut. ");
INSERT INTO yut_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aban Josep da kɨŋ ɨmal kwakwagɨ kɨnda yumaŋ aŋabɨŋ Yesu dakon bumjot tɨlak kɨndapmon naŋ abɨŋ uŋun ɨmal naŋ wamgut. Wamaŋ aŋkɨ tɨp kɨnam kɨndakon yɨpmaŋek tɨp madepsi kɨnda aŋtobɨlban abɨŋ yoma sopgut. ");
INSERT INTO yut_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Makdala kokupmon nani gat ae Maria Josep dakon meŋi gat da kaŋakwal Yesu dakon bumjotni yɨpgut. ");
INSERT INTO yut_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat bɨsap mudaŋakwan pɨlɨn pɨlɨndo Maria Makdala kokupmon nani, ae Maria Jems dakon meŋi, ae Salome, uŋun mɨŋat kapbɨ da bɨt nelak, ae yo mibɨlɨ mibɨlɨ kɨbaŋɨ tagɨsi, Yesu dakon bumjotni soŋ ɨm do yumaŋ paŋkosit awit. ");
INSERT INTO yut_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Yaŋ aŋek pakgwit da Sonda wɨsa dagokdo tɨp kɨnamon kɨk do kɨŋakwa gɨldat wɨgɨt. ");
INSERT INTO yut_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kɨŋek kosiron yaŋ nandat aŋek yaŋ yawit, “Namɨn da tɨp kɨnam dakon tɨp madep aŋtobɨlban pɨsosak?” ");
INSERT INTO yut_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yaŋ yaŋek kɨŋ kaŋba tɨp madep kɨlɨ aŋtobɨlbi kawit. ");
INSERT INTO yut_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yaŋ kaŋek tɨp kɨnamgwan pɨgɨ wɨli gɨmoŋɨ kɨnda kawit. Uŋun ɨlɨkba pɨgɨk kwakwagɨ dubagɨ kɨnda pabi da amɨnsi tet do yɨkban kawit. Kaŋek wurɨpdagek pasalgwit. ");
INSERT INTO yut_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Yaŋ nandaŋakwa yoyɨgɨt, “Ji wurɨpdagek dɨma pasolni. Yesu Nasaret kokupmon nani tɨlak kɨndapmon aŋakbi uŋun kok do abeŋ. Uŋun kɨlɨ pɨdaŋ kɨk, ɨdon mɨni. Tamoni oni kabɨt. ");
INSERT INTO yut_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kɨŋ paŋdetni gat Pita gat yaŋ yoyɨni, ‘Uŋun da kalɨp Galili mɨktɨmon mibɨltaŋ damɨŋek kɨk do kɨlɨ dayɨgɨt, do uŋudon kɨŋ koni.’ ” ");
INSERT INTO yut_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yaŋ yoyɨŋban mɨŋat kapbɨ uŋun pasal nɨmnɨmɨgek tɨp kɨnamon da wɨŋ tɨmtɨm yaŋek kɨwit. Kɨŋ pasol pasol aŋek amɨn dɨ dɨma yoyɨwit. ");
INSERT INTO yut_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu Sonda wɨsa dagokdo kɨmoron da pɨdaŋek mibɨltok Maria Makdala kokupmon nani altaŋ ɨmgut. (Uŋun mɨŋat Yesu da kalɨp koŋ 7 kabɨ burɨgwan egɨpgwit baŋ yol ɨmgut.) ");
INSERT INTO yut_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Altaŋ ɨban kɨŋ Yesu dakon paŋdet kabɨni kunam takba pɨndagek yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Yesu kalugɨ egakwan kat.” Yaŋ yaŋban gen uŋun do nandaba bamɨ dɨma agɨt. ");
INSERT INTO yut_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Buŋon paŋdetni bamorɨ da kokup kɨndakon kɨk do kɨŋakwal Yesu da gɨptɨmɨ kulabɨk aŋek altaŋ yoban amɨn ŋwakŋwarɨ kɨnda yaŋ kagɨmal. ");
INSERT INTO yut_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Altaŋ yoban tobɨl kɨŋ notni dɨwarɨ yoyɨŋbal nandaba bamɨ dɨma agɨt. ");
INSERT INTO yut_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Aeni don paŋdetni 11 kabɨ muwuk yɨgek jap naŋakwa altaŋ yomgut. Altaŋ yomɨŋek gen tebaisi yaŋek yaŋ yoyɨgɨt, “Ji amɨn da ‘pɨdak da egɨsak’ yaŋ dayɨŋba nido nandaba bamɨ dɨma ak? Nandaŋ gadatji mɨni?” ");
INSERT INTO yut_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aeni saŋbeŋek yaŋ yoyɨgɨt, “Ji mɨktɨmɨ mɨktɨmɨ kɨŋ Gen Bin Tagɨsi amɨn kɨsisi yoyɨŋ mudoni. ");
INSERT INTO yut_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Amɨn kɨnda nak nandaŋ gadaŋ namɨŋek telagɨ pakbi sosak kaŋ, uŋun amɨn Kwen Kokup do amɨn asak. Ae amɨn kɨnda nak dɨma nandaŋ gadaŋ namjak kaŋ, uŋun amɨn Tɨpdom do amɨn asak. ");
INSERT INTO yut_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nak nandaŋ gadaŋ namni amɨn tapmɨm yobo wasok tapmɨmɨ toŋ yaŋ baŋ akdaŋ: nak dakon man yaŋek koŋ yoldaŋ, ae gen ŋwakŋwarɨ yokdaŋ. ");
INSERT INTO yut_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ae uŋun amɨn da tuŋon amɨn emarɨ toŋ abɨdokdaŋ, ae pakbi emarɨ toŋ naŋba uŋun da dɨma paŋupbal akdaŋ. Uŋun amɨn da sot amɨn kɨsirɨ kwenikon wɨtjɨŋba sotni mudokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Amɨn Tagɨ Yesu gen uŋun yoyɨŋ mudaŋakwan Piŋkop da aŋenakban Kwen Kokup wɨgɨgɨt da Piŋkop da amɨnsi tet do yɨkdak. ");
INSERT INTO yut_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aŋakwan paŋdetni mɨktɨmɨ mɨktɨmɨ kɨŋ Piŋkop dakon geni yoyɨŋ aŋaŋ kɨwit. Kɨŋakwa Amɨn Tagɨ uŋun gat egek paŋpulugaŋakwan wasok tapmɨmɨ toŋ aŋek geni joŋɨk paŋteban agɨt. ");
INSERT INTO yut_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Kɨla amɨn madep Tiopilas, amɨn morapmɨ da Piŋkop da yo morap nin da binapmon agɨt uŋun dakon geni papiakon mandak do awit. Yo morap wasaŋek altaŋakwa dabɨl da si pɨndagek yaŋ teŋteŋok awit amɨn dakon gen yolek mandawit. Uŋun amɨn Piŋkop gen do pi awit. Ae nak uŋun yo morap si wasaŋek noman taŋ aŋaŋ opgwit uŋun dakon mibɨlɨ pakyaŋsi nandak do pini madepsi agɨm. Do gen morap on papiakon kɨlegɨsi mandaŋ yɨpbo gagon opjak kaŋ nandabo tagɨsi asak. ");
INSERT INTO yut_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Papia on manjɨŋek amɨn da gen morap gayɨwit uŋun nandabɨ bamɨsi asak. ");
INSERT INTO yut_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Erot da Judia mɨktɨm dakon kɨla amɨn madep yɨkgɨt bɨsapmon mukwa sogok amɨn kɨnda egɨpgut mani Sekaraia. Sekaraia uŋun mukwa sogok amɨn Abiya da kabɨkon nani kɨnda. Mɨŋatni Elisabet uŋun Aron da kabɨkon nani. ");
INSERT INTO yut_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Piŋkop da dabɨlon kɨlegɨsi egek Amɨn Tagɨ dakon gen teban madep ae monɨŋɨ kɨsi guramɨkgɨmal. ");
INSERT INTO yut_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mani Elisabet monjɨ suŋ egɨpgut, do ɨsal egek mɨŋat amɨn pelaŋyo agɨmal. ");
INSERT INTO yut_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Bɨsap kɨndakon Sekaraia gat mukwa sogok amɨn notni gat Piŋkop da dabɨlon mukwa sogok pi awit. ");
INSERT INTO yut_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Aŋek namɨn dasi Amɨn Tagɨ da telagɨ tamogwan wɨgɨ yo kɨbaŋɨ tagɨsi sosak yaŋ do aŋpakni yolek satu wasok awit. Yaŋ aba Sekaraia dakon man da noman taŋban mukwa sok do wɨgɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wɨgɨ mukwa soŋakwan yomakon mɨŋat amɨn morap muwuk egek bɨsit pi awit. ");
INSERT INTO yut_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aŋakwa Amɨn Tagɨ dakon aŋelo kɨnda Sekaraia altaŋ ɨmgut. Uŋun alta mukwa kɨbaŋɨ tagɨsi sosoŋ da tosok uŋun da amɨnsi tet do akgɨt. ");
INSERT INTO yut_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Akban kaŋek Sekaraia wurɨpdagek pasalgɨt. ");
INSERT INTO yut_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mani aŋelo da yaŋ iyɨgɨt, “Sekaraia, Piŋkop da bɨsitgo kɨlɨ nandagɨt, do dɨma pasolgi. Mɨŋatgo Elisabet da monji wɨli kɨnda aŋalakdɨsak. Mani Jon yaŋ iyɨki. ");
INSERT INTO yut_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Amɨn Tagɨ da ɨŋamon mani wukwisi tokdɨsak, do gak butgo tagɨsi aŋakwan kɨsɨk kɨsɨk akdɨsal. Ae amɨn morapmɨ da monjɨ uŋun altosak bɨsapmon kɨsɨk kɨsɨk akdaŋ. Meŋ da butgwan yɨtjagon da Telagɨ Wup da tugaŋ ɨban egɨ aŋaŋ kɨkdɨsak. Wain ae pakbi tebanyo dɨmasi nosak. ");
INSERT INTO yut_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Uŋun da Israel amɨn morapmɨ paŋtobɨlban aeni Amɨn Tagɨni Piŋkopmon kɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Elaija dakon aŋpak tapmɨmyo paŋek Amɨn Tagɨ mibɨltaŋ ɨmɨŋek kɨkdɨsak. Uŋun da mɨŋat monjɨyo gat datni gat dakon but paŋkɨlek aban but kaloŋ akdaŋ. Ae gen kɨrɨŋɨt amɨn dakon nandak nandak paŋmɨlɨp aban amɨn kɨlegɨ dakon nandaŋ kokwin tagɨsi yombem akdaŋ. Aŋek amɨn paŋtagap aban tagap taŋakwa Amɨn Tagɨ apdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Yaŋ yaŋban Sekaraia da aŋelo iyɨgɨt, “Nit mɨŋat amɨn pelaŋyo kɨlɨ agɨmak. Do gen yaŋaki but bamot asat. Gen uŋun niaŋon da bamɨ yosol yaŋ nandakeŋ?” ");
INSERT INTO yut_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yaŋban aŋelo da yagɨt, “Nak Gebriel, nak Piŋkop da ɨŋamon akdat da yabekban gak do gen tagɨsi on gayɨk do abɨsat. ");
INSERT INTO yut_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Gen gayɨsat uŋun asi Piŋkop da bɨsap yɨpgut uŋun bɨsapmon noman tokdɨsak, mani nandabɨ bamɨ dɨma asak, do gen yogok kositgo sopmaŋakwan gen dɨmasi yaŋek egɨ wɨgaki gen gayɨsat uŋun bamɨ noman tokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Yaŋ nandat aŋek egakwal amɨn jomjom aŋegek Sekaraia nido bɨsap dubak Telagɨ Yut Madepmon egɨsak yaŋ nandaŋek but morap awit. ");
INSERT INTO yut_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Yaŋ nandaŋek egakwa Sekaraia yomakon pɨŋ gen yok do aŋtɨdok aŋek kɨsit dagɨn tɨlak aŋyomgut. Yaŋ aŋakwan kaŋek Telagɨ Yut Madepmon dɨpmɨn yombem kɨnda bo kak yaŋ nandawit. ");
INSERT INTO yut_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sekaraia Telagɨ Yut Madepmon pi agak bɨsapni mudaŋakwan tobɨl kokupnikon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Paŋkɨ egakwan don mɨŋatni Elisabet monjɨ kwap awɨlek yutnon pasɨlɨ egakwan kanek 5 mudawit. ");
INSERT INTO yut_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Aŋakwan yaŋ yagɨt, “Amɨn Tagɨ da nak aŋpulugaŋban monjɨ kwap awɨldat. Kalɨp monjɨ mɨni egek amɨn da dabɨlon mayagɨsi nandagɨm, mani abɨsok kɨlɨ uŋun mayagɨno mudosok.” ");
INSERT INTO yut_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Elisabet monjɨ kwap awɨlgɨt uŋun dakon kanek 6 mudaŋakwan Piŋkop da aŋeloni Gebriel yabekban mɨŋatjok kɨnda mani Maria uŋun do kɨgɨt. Galili mɨktɨmon, kokup kɨnda mani Nasaret uŋudon egɨpgut. Maria uŋun amɨn kɨnda mani Josep, Dewit da kabɨkon nani uŋun pasak do manjɨkbi. ");
INSERT INTO yut_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gebriel Mariakon altaŋ ɨmɨŋek yaŋ iyɨgɨt, “Gɨldat tagɨ. Amɨn Tagɨ gak gat egɨsak. Piŋkop da mɨŋat dɨwarɨ yapmaŋek gak do yo madep yaŋ nandɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria gen uŋun nandaŋek burɨgwan da jɨgɨsi nandaŋek yaŋ nandagɨt, “Ni gen kɨnda naŋ nayɨsak?” ");
INSERT INTO yut_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yaŋ nandaŋakwan iyɨgɨt, “Maria, dɨma pasolgi. Piŋkop da gak do nandaban tagɨsi asak. ");
INSERT INTO yut_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nandaki, gak monjɨ kwap awɨlek monjɨ kɨnda aŋalakdɨsal. Monjɨ uŋun mani Yesu yaŋsi iyɨki. ");
INSERT INTO yut_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Uŋun da amɨn man madepni toŋ kɨnda egakwan amɨn da Piŋkop Wɨkwisi Dakon Monji yaŋ iyɨkdaŋ. Kalɨp babi Dewit da kɨla amɨn madep egɨpgut, uŋun da tɨlagon Amɨn Tagɨ Piŋkop da yɨpban kɨla amɨn madep kɨnda egɨpdɨsak. ");
INSERT INTO yut_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Uŋun da Jekop dakon dɨwatni dakon kɨla amɨn madepni bɨsap dagok dagogɨ mɨni egɨ aŋaŋ kɨŋek kɨlani akdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Yaŋ yaŋban Maria da aŋelo yaŋ iyɨgɨt, “Yo yosol uŋun niaŋ aŋek altosak? Nak amɨn kɨnda pagɨm.” ");
INSERT INTO yut_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yaŋban aŋelo da gen kobogɨ yaŋ iyɨgɨt, “Telagɨ Wup da gagon obɨŋakwan Piŋkop Wɨkwisi uŋun dakon tapmɨm da gak kɨbɨtdɨsak. Uŋun do aŋek monjɨ aŋalaki uŋun telagɨ egakwan amɨn da Piŋkop dakon Monji yaŋ iyɨkdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nandaki, mamago Elisabet mɨŋat pelaŋ kɨlɨ agɨt, mani monjɨ kwapni toŋ, do monji wɨli kɨnda aŋalakdɨsak. Kalɨp amɨn da ‘Monjɨ arɨpmɨ dɨma paŋalasak’ yaŋ yawit, mani abɨsok monjɨ kwap kɨnda awɨlakwan kanek 6 mudosok. ");
INSERT INTO yut_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Piŋkop da yo kɨnda ak do nandɨsak kaŋ, arɨpmɨ dɨmasi aŋtɨdok asak.” ");
INSERT INTO yut_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Yaŋban Maria da yaŋ iyɨgɨt, “Nak Amɨn Tagɨ dakon oman mɨŋat egɨsat, do uŋun yosol nagon yaŋ gɨn noman tosak dosi nandɨsat.” Yaŋ yaŋakwan aŋelo da yɨpmaŋ kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Uŋun bɨsapmon Maria tepmɨ kɨŋek mɨktɨm ɨleŋɨ toŋ tɨmon Judia mɨktɨm dakon kokup pap kɨndakon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kɨŋ Sekaraia da yutnon wɨgɨ Elisabet gɨldat tagɨ yaŋ iyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Iyɨŋakwan uŋudon gɨn Elisabet monjɨ burɨgwan yɨkgɨt uŋun wɨgɨ mok agɨt. Aŋakwan Elisabet Telagɨ Wup da burɨkon pɨgɨ tugaŋban ");
INSERT INTO yut_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","madepsi yaŋ tɨdaŋek yagɨt, “Piŋkop da yo tagɨsi mɨŋat dɨwarɨ do yomɨsak uŋun si yapmaŋ mudaŋek gɨsamni madepsi gamɨsak. Ae monjɨ uŋun gak da buron yɨkdak uŋunyo kɨsi Piŋkop da gɨsamɨkdak! ");
INSERT INTO yut_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Amɨn Tagɨno dakon meŋi nagon nido obɨsak? Nak mɨŋat tagɨ dɨma. ");
INSERT INTO yut_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gak da gɨldat tagɨ yaŋ nayɨŋaki uŋudon gɨn monjɨ butnogwan yɨkdak kɨsɨk kɨsɨk aŋek wɨgɨ mok ak. ");
INSERT INTO yut_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Amɨn Tagɨ da gen gayɨgɨt uŋun nandabɨ bamɨ asisi noman tokdɨsak yaŋ nandagɨl, do kɨsɨk kɨsɨk tagɨ abi.” ");
INSERT INTO yut_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","49","Yaŋ yaŋban Maria da yagɨt, “Nak oman mɨŋatni gɨn, ae mano mɨnisi, mani nak do yo tagɨsi asak, do but dasi Amɨn Tagɨ aŋkɨsisat. Aŋakwan butno da Piŋkop Paŋpulugok Amɨno do kɨsɨk kɨsɨk asak. Piŋkop Tapmɨm Ami da nak do yo madepsi kɨnda asak, do abɨsok ae don kɨsi amɨn da Piŋkop da gɨsamni madepsi namɨsak uŋun do yokdaŋ. Mani uŋun telagɨsi tosok. ");
INSERT INTO yut_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Amɨn Piŋkop do pasolgoŋ uŋun amɨn bupmɨ nandaŋ yomɨsak. Abɨsok ae don mɨŋat amɨn morapyo yaŋ gɨnsi bupmɨ nandaŋ yomɨŋ aŋaŋ kɨkdɨsak. ");
INSERT INTO yut_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iyɨ dakon kɨsit dasi pi tapmɨmɨ toŋ agɨt. Amɨn iyɨ do nandaba wɨgɨwit amɨn uŋun yolban waseŋ kɨwit. ");
INSERT INTO yut_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kɨla amɨn madep yɨtyɨt tamo madepmon yɨkgaŋ uŋun pabɨŋ yopmaŋek mani mɨni amɨn paŋenokdok. ");
INSERT INTO yut_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Amɨn jap do aŋ uŋun yo tagɨsi morapmɨ yomɨŋakwan burɨ tugoŋ. Aŋek amɨn yoni morapmɨ uŋun yolban yoni mɨni da kwaŋ. ");
INSERT INTO yut_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Iyɨ dakon oman monjɨni Israel paŋpulugaŋek yaŋ teban tok gen Abraham gat ae babɨkni gat do yoyɨgɨt uŋun dɨma ɨŋtagɨt. Yaŋ teban tok geni aŋteban aŋek uŋun yawi dɨwatni dagok dagogɨ mɨni bupmɨ nandaŋ yomɨŋ aŋaŋ kɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria kanek kapbɨ Elisabet gat egek don kokupnikon tobɨl kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet da monjɨ aŋalasak dakon bɨsap abɨŋakwan monji wɨli aŋalagɨt. ");
INSERT INTO yut_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aŋalaŋek kɨsɨk kɨsɨk aŋakwan Amɨn Tagɨ da bupmɨ nandaŋ ɨmgut dakon gen nandaŋek kokup ɨsalni gat ae yawi dɨwatni gat kɨsi da but galaksi nandawit. ");
INSERT INTO yut_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Altaŋ gɨldatni 8 mudaŋakwan gɨptɨmni mandak do apgwit. Abɨŋek datni Sekaraia dakon man naŋ iyɨk do nandawit, ");
INSERT INTO yut_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","mani meŋi da yaŋ yagɨt, “Dɨma, mani Jon yaŋsi iyɨneŋ.” ");
INSERT INTO yut_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yaŋban iyɨwit, “Yawi dɨwatjikon Jon man kɨnda dɨma tosok.” ");
INSERT INTO yut_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yaŋ yaŋek datni ni man naŋ yok do nandɨsak yaŋ do kɨsit tɨlak aŋ ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Aba Sekaraia da yo kɨnda kaŋ ɨba kɨlda mandɨsak do tɨlak aŋ yoban ɨba yaŋ mandagɨt, “Mani uŋun Jon.” Yaŋ mandaban nandaba yo ŋwakŋwarɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Uŋudon gɨn gen yogokni pɨsaŋakwan gen wasaŋek yaŋek Piŋkop aŋkɨsigɨt. ");
INSERT INTO yut_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aŋakwan kokup ɨsalni da kaŋ pasalek uŋun dakon geni yaŋba Judia mɨktɨm ɨleŋɨ toŋ tɨmon kokup morap tawit amɨn kɨsisi da nandawit. ");
INSERT INTO yut_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aŋek uŋun do nandaŋ kokwin aŋek egɨpgwit. Amɨn Tagɨ dakon tapmɨm taŋ ɨmgut, do yaŋ yawit, “Uŋun monjɨ tagaŋek niaŋ amɨn kɨnda egɨpdɨsak?” ");
INSERT INTO yut_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jon dakon datni Sekaraia Telagɨ Wup da burɨkon pɨgɨ tugaŋban kombɨ gen yaŋek yaŋ yagɨt: ");
INSERT INTO yut_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israel dakon Piŋkop da abɨŋ amɨni yokwikon baŋ yumaŋ naŋ nipgut, do Amɨn Tagɨ aŋkɨsino. ");
INSERT INTO yut_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Oman monjɨni Dewit da kabɨkon da nin paŋpulugosak do amɨn tebaisi kɨnda aŋnoman agɨt. ");
INSERT INTO yut_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kalɨp kombɨ amɨn telagɨ da yaŋ yawit, ");
INSERT INTO yut_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Piŋkop da uwalnin gat ae amɨn morap nin do nandaba yokwi tok aŋ nimaŋ amɨn da kɨsiron baŋ pulugaŋ nipdɨsak.’ ");
INSERT INTO yut_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Saŋbek saŋbek telagɨsi agɨt uŋun sigɨn nandaŋek babɨknin bupmɨ nandaŋ yom do yagɨt. ");
INSERT INTO yut_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Babɨknin Abraham yaŋ iyɨgɨt, ‘Nak asisi uwalji da kɨsiron baŋ pulugaŋ depbo pasol pasolɨ mɨni egek oman amɨno egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Gɨldarɨ gɨldarɨ nak da ɨŋamon telagɨsi ae kɨlegɨsi egɨ aŋaŋ kɨkdaŋ.’ ");
INSERT INTO yut_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Jon, monjɨno, gak don Piŋkop Wɨkwisi dakon kombɨ amɨn kɨnda yaŋ gayɨkdaŋ. Gak Amɨn Tagɨ mibɨltaŋ ɨmɨŋek kositni yuldɨsal. ");
INSERT INTO yut_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Aŋek mɨŋat amɨn kabɨyoni yoyɨŋ dekbɨ mibɨlni nandaba pɨsosak. Piŋkopnin uŋun bupmɨni madepsi, do dɨwarɨni wɨrɨrɨk yomɨŋek pulugaŋ tɨmɨtdɨsak yaŋ nandani. Uŋun da Kwen Kokup dakon teŋteŋɨ madep yɨpban ");
INSERT INTO yut_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","pɨlɨn tukgwan ekwaŋ amɨn da teŋteŋɨ kokdaŋ. Uŋun da kosit nolɨŋban kaŋek but yawot dakon kositnaŋ kɨneŋ.” ");
INSERT INTO yut_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Uŋun monjɨ, wup gɨpyo kɨsi tapmɨmɨ toŋsi tagagɨt. Aŋakwan mɨktɨm amɨn dɨma ekwaŋ tɨmon egakwan don noman taŋban Israel amɨn da kawit. ");
INSERT INTO yut_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Uŋun bɨsapmon Rom dakon kɨla amɨn madep Sisa Ogastus da gen teban kɨnda yɨpgut. Pi monjɨni kɨŋ amɨn mɨktɨmɨ mɨktɨmɨ ekwaŋ uŋun mani mandani do gen teban yɨpgut. ");
INSERT INTO yut_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Man mandawit uŋun pi kaluksi awit. Uŋun bɨsapmon Kwirinius da Siria provins dakon kɨla amɨn madep egɨpgut. ");
INSERT INTO yut_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sisa Ogastus da gen teban yaŋ yɨpgut, do amɨn kɨsisi mani mandani do kokupni kokupni kɨŋ mudawit. ");
INSERT INTO yut_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep uŋun Galili provinskon, Nasaret kokupmon egɨpgut. Mani Dewit da yawi dɨwaron da altagɨt, do Judia provinskon, Dewit dakon kokup Betlehem uŋudon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mɨŋatni pasak do manjɨkbi Maria uŋun gat kɨsi mani mandani do kɨgɨmal. Uŋun bɨsapmon Maria monjɨ kwapni toŋ da kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kɨŋ Betlehem kokupmon altaŋ egakwal Maria monjɨ altosak dakon bɨsapni apgut. ");
INSERT INTO yut_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Amɨn da yumaŋ naŋek dɨpmɨn pokgoŋ yut uŋun amɨn da yɨkba tugagɨt, do bulmakau yut kɨndakon pawɨgɨ yɨkgɨmal. Yɨgakwal monjɨ mibɨltogɨ altaŋban Maria da ɨmalnaŋ wamaŋ bulmakau ɨdapmon yɨpban pakgɨt. ");
INSERT INTO yut_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bulmakau yutnon yɨgakwa Betlehem kokup da kapmatjok sipsip kɨla amɨn dɨwarɨ da pɨlɨn kaga sipsip kɨla aŋek joŋ tɨmon egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Egakwa Amɨn Tagɨ dakon aŋelo kɨnda da altaŋ yomgut. Aban Amɨn Tagɨ dakon teŋteŋɨ da teŋteŋaŋ yoban madepsi pasalgwit. ");
INSERT INTO yut_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aŋakwa aŋelo da yaŋ yoyɨgɨt, “Ji dɨma pasolni. Nandani, nak gen tagɨsi kɨnda aŋabɨsat. Uŋun amɨn kɨsi da nandaŋek kɨsɨk kɨsɨk madepsi akdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Abɨsok Amɨn Tagɨ Kristo uŋun Dewit da kokupmon ji do altak. Uŋun ji yokwikon baŋ tɨmɨt do altak. ");
INSERT INTO yut_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ji kɨŋ monjɨ ŋakŋak ɨmalnaŋ wabi bulmakau ɨdapmon potdɨsak do wɨsɨŋ koni. Uŋun kaŋek bamɨ dayɨsat yaŋ nandani.” ");
INSERT INTO yut_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Gen yaŋ yaŋakwan uŋudon gɨn Kwen Kokup aŋelo morapmɨsi da pɨŋ notnikon muwugek Piŋkop aŋkɨsiŋek yaŋ yawit: ");
INSERT INTO yut_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ason Kwen Kokup Piŋkop aŋkɨsino. Mɨktɨmon amɨn galak taŋ yomɨsak uŋun kabɨkon but yawot tosak.” ");
INSERT INTO yut_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aŋelo da Kwen Kokup tobɨl wɨgakwa sipsip kɨla amɨn da notni yoyɨŋ yoyɨŋ aŋek yaŋ yawit, “Nin Betlehem kokupmon wɨgɨ Amɨn Tagɨ da gen niyɨsak uŋun dakon bamɨ kono.” ");
INSERT INTO yut_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yaŋ yaŋek tepmɨsi wɨgɨ Maria gat Josep gat paŋalon aŋek, monjɨ ŋakŋak uŋun bulmakau ɨdapmon pakban kawit. ");
INSERT INTO yut_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kaŋek monjɨ dakon gen bin nandawit uŋun yaŋ teŋteŋaŋba ");
INSERT INTO yut_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","nandaŋek amɨn kɨsisi nandaba yo ŋwakŋwarɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Aŋakwa Maria da gen uŋun nandaban yo madep aban nandaŋek egɨpgut. ");
INSERT INTO yut_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aŋakwan sipsip kɨla amɨn da tobɨl kɨŋek aŋelo da gen yoyɨgɨt uŋun da arɨpmon pɨndakgwit, do Piŋkop aŋkɨsiwit. ");
INSERT INTO yut_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Gɨldatni 8 aŋakwan, gɨptɨm mandak bɨsapmon, mani Yesu yaŋ iyɨwit. Dɨma altaŋakwan aŋelo da uŋun man kɨlɨ yagɨt. ");
INSERT INTO yut_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Josep gat Maria gat Piŋkop da ɨŋamon kɨlek tok dakon bɨsap kɨlɨ noman tagɨt. Uŋun dakon gen Moses dakon gen tebanon tosok. Do Maria gat Josep gat da Yesu Monjɨ Amɨn Tagɨ do paret do Jerusalem aŋkɨgɨmal. ");
INSERT INTO yut_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Amɨn Tagɨ dakon gen teban kɨnda mandabi naŋ yolek kɨgɨmal. Gen uŋun yaŋ: “Mɨŋat kɨnda monjɨ mibɨltogɨ uŋun wɨli kaŋ, uŋun Amɨn Tagɨ do paret do.” ");
INSERT INTO yut_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ae Amɨn Tagɨ dakon gen teban yolek paret ak do kɨgɨmal. Gen teban uŋun yaŋ tosok: “Kɨnarɨm bamorɨ bo ae yɨgɨ yɨgɨ bulagɨ bamorɨ baŋ mukwa soni.” ");
INSERT INTO yut_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Uŋun bɨsapmon amɨn kɨnda Jerusalem egɨpgut uŋun mani Simeon. Uŋun amɨn aŋpakni kɨlegɨsi ae Piŋkop gawak ɨmɨŋ aŋkɨsiŋyo aŋek egɨpgut. Piŋkop da Israel amɨn kabɨ but yokwikon egɨpgwit uŋun butni paŋteban asak do manjɨkbi amɨn uŋun do jomjom aŋek egɨpgut. Simeon uŋun Telagɨ Wup da burɨkon tugaŋbi amɨn kɨnda. ");
INSERT INTO yut_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Telagɨ Wup da burɨkon gen yaŋ kɨlɨ iyɨgɨt, “Gak tepmɨ dɨma kɨmotdɨsal. Amɨn Tagɨ dakon Kristo kaŋek don kɨmotdɨsal.” ");
INSERT INTO yut_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simeon Telagɨ Wup da aŋtagap aban Telagɨ Yut Madepmon kɨgɨt. Aŋakwan Yesu meŋi datniyo da gen teban yolek Yesu aŋaŋ opgumal. ");
INSERT INTO yut_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Aŋopbal Simeon da Yesu bedaŋek Piŋkop aŋkɨsiŋek yaŋ yagɨt: ");
INSERT INTO yut_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Amɨn Tagɨ Tapmɨm Ami, kalɨp yagɨl uŋun da tɨlagon oman amɨngo nak but yaworon da tagɨ kɨmokgeŋ. ");
INSERT INTO yut_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nin yokwikon baŋ tɨmɨt do aŋek yo asal uŋun dabɨlno da kɨlɨ uŋun kosot. ");
INSERT INTO yut_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Amɨn morap da dabɨlon yo aŋnoman asal oni komaŋ. ");
INSERT INTO yut_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Uŋun da Amɨn Ŋwakŋwarɨ Kabɨ mɨktɨmɨ mɨktɨmɨ ekwaŋ uŋun dakon but paŋteŋteŋ aban Piŋkop dakon mibɨlɨ nandakdaŋ. Aŋek gak dakon amɨn kabɨgo Israel dakon tɨlɨmni egɨpdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yesu dakon meŋi datniyo Simeon da gen yagɨt uŋun nandaŋek nandabal ŋwakŋwarɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Aŋakwal Simeon da gɨsam yomɨŋek Monjɨ dakon meŋi Maria yaŋ iyɨgɨt, “Nandaki, Israel amɨn morapmɨ da on Monjɨ do aŋek maŋ potdaŋ, ae morapmɨ da pɨdokdaŋ. But tobɨl ani do Piŋkop da yabekgɨt, mani yaŋba yokwi tok aŋ ɨmdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Yaŋ aŋek amɨn morapmɨ dakon nandak nandak pasɨlɨ toŋ uŋun paŋteŋteŋ akdɨsak. Aŋek but yokwi da emat agak sɨba da yaŋ wamgo sugokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Uŋun bɨsapmon kombɨ amɨn mɨŋat pelaŋsi kɨnda egɨpgut, mani Ana. Uŋun Panuel, Ase da kabɨkon nani dakon gwi. Uŋun kalɨp amɨn paban egakwal bɨlak 7 kabɨ mudaŋakwan eni kɨmakgɨt. ");
INSERT INTO yut_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Eni kɨmagakwan sakwabat egakwan bɨlakni 84 agɨt. Ana uŋun telagɨ yut dɨma yɨpmaŋ dekgɨt. Jap kelek egek bɨsit pi aŋek kalbi ae gɨldat kalba Piŋkop gawak ɨmɨŋek egɨpgut. ");
INSERT INTO yut_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Uŋun bɨsapmon uŋun kɨsi obɨŋ Monjɨ kaŋek Piŋkop ya yaŋ iyɨgɨt. Yaŋ aŋek Piŋkop da Jerusalem amɨn paŋpulugosak do jomjom awit amɨn, uŋun baŋ Monjɨ dakon gen yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yo morap Amɨn Tagɨ da gen tebanon tosok uŋun aŋ mudaŋek tobɨl Galili provinskon iyɨ da kokup Nasaret uŋudon kɨwit. ");
INSERT INTO yut_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Monjɨ tagaŋ teban taŋek nandaŋ kokwini tagɨsi taŋ ɨmgut. Ae Piŋkop dakon gɨsamni madepsi taŋ ɨmgut. ");
INSERT INTO yut_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bɨlagɨ bɨlagɨ Yesu dakon meŋi datniyo Yapyap Bɨlak kok do Jerusalem kɨŋ kɨŋ awit. ");
INSERT INTO yut_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu bɨlakni 12 aŋakwan Yapyap Bɨlak dakon aŋpak yolek Jerusalem kɨwit. ");
INSERT INTO yut_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Uŋun bɨlak dakon bɨsap madep mudaŋakwan meŋi datniyo tobɨl kokupnikon kɨk do kɨgɨmal. Mani Yesu Jerusalem sigɨn egɨpgut. Egakwan meŋi datniyo Yesu sigɨn egɨsak yaŋ dɨma nandagɨmal. ");
INSERT INTO yut_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Amɨn agɨpgwit gat akwaŋ bo yaŋ nandaŋek agakwal gɨldat kɨnda mudagɨt. Don dɨwatni ae notni agɨpgwit da bɨkbɨknikon wusɨgɨmal. ");
INSERT INTO yut_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wusɨŋ dɨma aŋalon aŋ aeni tobɨl Yesu wusɨŋek Jerusalem kɨgɨmal. ");
INSERT INTO yut_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kɨŋ gɨldat kapbɨ wusɨŋ mudaŋek don Telagɨ Yut Madepmon aŋalon agɨmal. Uŋudon kaŋbal yoyɨŋdet amɨn da binapmon yɨgek gen yaŋakwa nandaŋek mibɨlɨ nandak do yoyɨŋ yoyɨŋ agɨt. ");
INSERT INTO yut_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Amɨn morap mɨrak paŋek yɨkgwit uŋun nandak nandakni ae kobogɨ bamɨsi yagɨt uŋun do nandaba ŋwakŋwarɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Meŋi datniyo kaŋ wɨrɨpdagek meŋi da yaŋ iyɨgɨt, “Monjɨ, gak nido yaŋ aŋaki wusamak? Datgo gat nit gak do nandaba kɨk aŋek wusamak.” ");
INSERT INTO yut_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mani kobogɨ yaŋ yoyɨgɨt, “Jil nido nak wusɨk do pi amal? Nak Datno da yutnon egɨpmɨsi egɨsat jil uŋun dɨma nandamal?” ");
INSERT INTO yut_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mani gen yoyɨgɨt dakon mibɨlɨ nandabal dɨma pɨsagɨt. ");
INSERT INTO yut_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesu meŋi datni yolban tobɨl Nasaret si kɨŋek bɨsapmɨ bɨsapmɨ meŋi datni dakon geni guramɨkgɨt. Aŋakwan meŋi da uŋun yo morap agɨt do nandaban yo madep aban nandaŋek egɨpgut. ");
INSERT INTO yut_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu tagaŋek nandaŋ kokwini tagɨsi taŋ ɨmgut, ae Piŋkop da galak taŋ ɨmɨŋakwan amɨnyo kɨsi da galak taŋ ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisa Taiberius da Rom dakon kɨla amɨn madep egakwan bɨlak 15 aŋakwan Pontias Pailat da Juda gapman dakon mibɨltok amɨn egɨpgut. Ae uŋun bɨsapmon gɨn Erot da Galili mɨktɨm kɨla agɨt. Aŋakwan padɨge Pilip da Ituria mɨktɨm ae Takonitis mɨktɨm kɨla agɨt. Aŋakwan Lisanias da Abilene mɨktɨm kɨla agɨt. ");
INSERT INTO yut_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Aŋakwan Anas gat Kaiapas gat da mukwa sogok amɨn dakon mibɨltok amɨn egɨpgumal. Uŋun bɨsapmon Sekaraia dakon monji Jon mɨktɨm amɨn da arɨpmɨ dɨma egɨpmɨ tɨmon egakwan Piŋkop da geni ɨmgut. ");
INSERT INTO yut_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ɨban Jon uŋun Jodan Pakbi oba tosogon mɨktɨm morap toŋ uŋudon agek Piŋkop dakon gen yagɨt. Amɨn but tobɨl aŋek telagɨ pakbi soŋakwa Piŋkop da dɨwarɨni yopmaŋ yomjak do yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yaŋ aŋakwan kombɨ amɨn Aisaia da papiakon gen mandabi uŋun bamɨ tagɨt. Gen uŋun yaŋ: “Mɨktɨm amɨn da arɨpmɨ dɨma egɨpmɨ tɨmon amɨn kɨnda da yaŋ tɨdaŋek yosok, ‘Amɨn Tagɨ dakon kosit aŋdɨmdɨm ani, kositni pasɨŋ aŋmɨlɨp ani. ");
INSERT INTO yut_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Aŋek daŋgap madep pekba tugoni ae ɨleŋ morap pasɨŋba kositni kɨlegɨsi asak. Ae kosit gɨreŋɨ paŋmɨlɨp aba kɨlegɨsi asak. Ae kosit yokwi paŋmɨlɨp aba wagɨl gwaljɨgɨ mɨnisi asak. ");
INSERT INTO yut_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yaŋ aŋakwa mɨŋat amɨn morapyo da Piŋkop da nin yokwikon baŋ tɨmɨt do aŋek pi asak uŋun koni.’ ” ");
INSERT INTO yut_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Amɨn morapmɨ Jon da telagɨ pakbi soŋ yomjak do abɨŋakwa yaŋ yoyɨgɨt, “Ji tuŋon amɨn emarɨ toŋ dakon gwakni kabɨ. Piŋkop da butjap nandaŋek yokwi pakpak do yo yokwisi aŋ yomdɨsak. Piŋkop dakon butjap apdɨsak yaŋ namɨn da uŋun dakon but pɨso dayɨk da uŋun yap do pasal kwaŋ? ");
INSERT INTO yut_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ji but tobɨl bamɨsi aŋek aŋpakjikon but tobɨl dakon bamɨ aŋalon ani. Ji dɨsi do ‘Nin Abraham dakon babɨkni’ yaŋ dɨma yoni. Nak yaŋsi dayɨsat, Piŋkop da yaŋban on tɨp kabɨ da Abraham dakon babɨkni tagɨ dagoni. Ji uŋun Abrahamon da altawit uŋun da yo madep dɨma asak. ");
INSERT INTO yut_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Pareŋka kɨndap mibɨlon yɨpbi da tosok. Kɨndap morap bamɨ tagɨ dɨma toni uŋun mandaŋ kɨndapmon maba pɨgɨ sokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Amɨn da Jon dakon gen uŋun nandaŋek yaŋ iyɨwit, “Nin niaŋsi aneŋ?” ");
INSERT INTO yut_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yaŋba Jon da kobogɨ yaŋ yoyɨgɨt, “Amɨn kɨnda paba pɨgɨkni bamorɨ kaŋ, mɨnini amɨn do kɨnda ɨmjak. Ae japni taŋ ɨmaŋ amɨnyo kɨsi yaŋ gɨn asak.” ");
INSERT INTO yut_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Yaŋ yaŋban takis tɨmɨt tɨmɨt amɨn dɨwarɨ telagɨ pakbi sok do apgwit uŋun da yaŋ iyɨwit, “Yoyɨŋdet, nin niaŋsi aneŋ?” ");
INSERT INTO yut_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Iyɨŋba yoyɨgɨt, “Ji takis gapman da dayɨsak uŋun da arɨpmon gɨn tɨmɨtni. Ae saŋbeŋek dɨ gat dɨma tɨmɨtni.” ");
INSERT INTO yut_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ae emat amɨn dɨwarɨ da yaŋ iyɨwit, “Ae nin niaŋsi aneŋ?” Iyɨŋba yoyɨgɨt, “Ji amɨn yo yokwi aŋ yomɨŋek top yoyɨŋek moneŋni dɨma tɨmɨtni. Topmon da gen pikon dɨma yopni. Pi aŋ dakon yumaŋ nogɨ tɨmɨkgaŋ uŋun arɨpninon tɨmɨkgamaŋ yaŋ nandaba mudosak.” ");
INSERT INTO yut_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Amɨn da butni pɨdaŋban but morap aŋek yaŋ nandawit, “Jon uŋun Kristo bo?” ");
INSERT INTO yut_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yaŋ nandaŋakwa Jon da yaŋ yoyɨgɨt, “Nak pakbisi baŋ telagɨ pakbi soŋ damɨsat. Mani nak da manjikon abɨsak amɨn uŋun dakon tapmɨm da nak dakon tapmɨm yapmaŋdak. Nak yombem yokwi da kandap gwɨl napni tagɨ dɨma wɨtdalgeŋ. Uŋun amɨn da Telagɨ Wup gat ae kɨndap gat soŋ damdɨsak. ");
INSERT INTO yut_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Uŋun wit dakon sɨbɨt sɨbɨt wɨrɨrɨt kɨndap kɨrɨŋni kɨsitnikon taŋakwan apdɨsak. Abɨŋek bamɨ kokwinɨk tamonikon yopmaŋek sɨbɨt sɨbɨt wɨrɨrɨk maban kɨndap kɨmot kɨmorɨ mɨni uŋudon sokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon nawa gen morapmɨ gat kɨsi amɨn dakon but pɨsoni do yoyɨgɨt. Yaŋ aŋek Gen Bin Tagɨsi yaŋ teŋteŋaŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jon da gapman dakon kɨla amɨn madep Erot tebai kaŋ yagɨt, nido Erot da padɨge dakon mɨŋatni Erodias tuwɨl pagɨt, ae aŋpak yokwi dɨ kɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Erot yokwi kɨnda gat sigɨn saŋbeŋ aŋek Jon dam tebanon yɨpgut. ");
INSERT INTO yut_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Amɨn morap telagɨ pakbi soŋakwa Yesu yo kɨsi sogɨt. Soŋek bɨsit aŋakwan kundu wɨtdal kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Wɨtdal kɨŋakwan Telagɨ Wup kɨnarɨm da mɨktɨmon paŋ uŋun da tɨlak Yesukon pɨgɨt. Aŋakwan Kwen Kokupgwan da gen kɨnda yaŋ altagɨt: “Gak Monjɨno. Butdasi galak taŋ gamɨsat. Butno gak do tagɨsi asak.” ");
INSERT INTO yut_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu bɨlakni 30 da tɨlak aŋakwan pini wasagɨt. Yesu uŋun Josep dakon monji amɨn da yaŋ nandawit. Josep uŋun Eli dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli uŋun Matat dakon monji. Matat uŋun Liwai dakon monji. Liwai uŋun Melki dakon monji. Melki uŋun Janai dakon monji. Janai uŋun Josep dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep uŋun Matatias dakon monji. Matatias uŋun Amos dakon monji. Amos uŋun Naum dakon monji. Naum uŋun Esli dakon monji. Esli uŋun Nagai dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai uŋun Mat dakon monji. Mat uŋun Matatias dakon monji. Matatias uŋun Semen dakon monji. Semen uŋun Josek dakon monji. Josek uŋun Joda dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda uŋun Joanan dakon monji. Joanan uŋun Resa dakon monji. Resa uŋun Serubabel dakon monji. Serubabel uŋun Sealtiel dakon monji. Sealtiel uŋun Neri dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri uŋun Melki dakon monji. Melki uŋun Adi dakon monji. Adi uŋun Kosam dakon monji. Kosam uŋun Elmadam dakon monji. Elmadam uŋun Er dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er uŋun Josua dakon monji. Josua uŋun Eliesa dakon monji. Eliesa uŋun Jorim dakon monji. Jorim uŋun Matat dakon monji. Matat uŋun Liwai dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai uŋun Simeon dakon monji. Simeon uŋun Juda dakon monji. Juda uŋun Josep dakon monji. Josep uŋun Jonam dakon monji. Jonam uŋun Eliakim dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim uŋun Melea dakon monji. Melea uŋun Mena dakon monji. Mena uŋun Matata dakon monji. Matata uŋun Natan dakon monji. Natan uŋun Dewit dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dewit uŋun Jesi dakon monji. Jesi uŋun Obet dakon monji. Obet uŋun Boas dakon monji. Boas uŋun Salmon dakon monji. Salmon uŋun Nason dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason uŋun Aminadap dakon monji. Aminadap uŋun Atmin dakon monji. Atmin uŋun Ani dakon monji. Ani uŋun Esron dakon monji. Esron uŋun Peres dakon monji. Peres uŋun Juda dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda uŋun Jekop dakon monji. Jekop uŋun Aisak dakon monji. Aisak uŋun Abraham dakon monji. Abraham uŋun Tera dakon monji. Tera uŋun Nao dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nao uŋun Seruk dakon monji. Seruk uŋun Reu dakon monji. Reu uŋun Pelek dakon monji. Pelek uŋun Ebe dakon monji. Ebe uŋun Sela dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela uŋun Kainan dakon monji. Kainan uŋun Apaksat dakon monji. Apaksat uŋun Siem dakon monji. Siem uŋun Noa dakon monji. Noa uŋun Lamek dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek uŋun Metusela dakon monji. Metusela uŋun Enok dakon monji. Enok uŋun Jaret dakon monji. Jaret uŋun Malalel dakon monji. Malalel uŋun Kenan dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan uŋun Enos dakon monji. Enos uŋun Set dakon monji. Set uŋun Adam dakon monji. Adam uŋun Piŋkop dakon monji. ");
INSERT INTO yut_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu Telagɨ Wup da burɨkon tugaŋban Jodan Pakbikon da tobɨl apgut. Abɨŋakwan Telagɨ Wup da iyɨŋ aŋaŋ mɨktɨm amɨn da arɨpmɨ dɨma egɨpmɨ tɨmon aŋkɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kɨŋ uŋudon gɨldat 40 japmɨ mɨni egek jap do madepsi agɨt. Aŋakwan Sunduk da aŋkewalgɨt. ");
INSERT INTO yut_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Aŋkewalek yaŋ iyɨgɨt, “Gak asi Piŋkop dakon Monji egɨsalon yaŋbɨ tɨp on da bret dagaŋban.” ");
INSERT INTO yut_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yaŋban Yesu da yaŋ iyɨgɨt, “Piŋkop da papiakon gen yaŋ tosok: ‘Bret dagɨn amɨn egɨp egɨp tagɨ dɨma yomjak.’ ” ");
INSERT INTO yut_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yaŋ yaŋban Sunduk da Yesu iyɨŋ aŋaŋ ɨleŋ dubagɨsi kɨndakon wɨgek uŋudon gɨn on mɨktɨmon mɨktɨm madep madep morap kɨsi yolɨŋban pɨndakgɨt. ");
INSERT INTO yut_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aŋek yaŋ iyɨgɨt, “On mɨktɨm madep kɨsi kɨlani aki do yaŋ mudaŋ gabo man madep paki. On mɨktɨm madep kɨsi nak dakon, do amɨn kɨnda do ɨm do nandakeŋ kaŋ tagɨ ɨbeŋ. ");
INSERT INTO yut_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Gawak nabi kaŋ, on yo morap gak do gamɨŋ mudokeŋ.” ");
INSERT INTO yut_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yaŋ yaŋban Yesu da iyɨgɨt, “Piŋkop da papiakon gen yaŋ tosok: ‘Amɨn Tagɨ Piŋkopji uŋun naŋ gɨn gawak ɨmɨŋek oman aŋɨmni.’ ” ");
INSERT INTO yut_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Yaŋ yaŋban Sunduk da Yesu iyɨŋ aŋaŋ Jerusalem kokup papmon kɨgɨt. Kɨŋ Telagɨ Yut Madep da kwenon awɨgɨ yɨpmaŋek yaŋ iyɨgɨt, “Piŋkop da papiakon gen kɨnda yaŋ tosok: ‘Uŋun da aŋeloni yoyɨŋban kɨlago tagɨsi ani. Ae kandapgo tɨpmon dɨma gɨtni yaŋ do aŋelo da gak kɨsit da kendak abɨŋ gepni.’ Gen yaŋ tosok, do gak asi Piŋkop dakon Monji kaŋ, gak amon mibɨlɨkon paŋ ma.” ");
INSERT INTO yut_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yaŋban Yesu da iyɨgɨt, “Piŋkop da papiakon gen kɨnda yaŋ yosok: ‘Amɨn Tagɨ Piŋkopji dakon tapmɨm kok do aŋek dɨmasi aŋkewaldo.’ ” ");
INSERT INTO yut_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sunduk da paŋkewal morap uŋun aŋ mudaŋek ae bɨsap kɨndakon don aŋkewalgeŋ yaŋ nandaŋek Yesu yɨpmaŋ kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu uŋun Wup da teban togon aeni tobɨl Galili mɨktɨmon kɨgɨt. Kɨŋakwan mɨŋat amɨn morapyo kokup terɨ terɨ egɨpgwit uŋun da gen bini nandawit. ");
INSERT INTO yut_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Bɨsapmɨ bɨsapmɨ Juda amɨn da muwut muwut yutnon wɨgek amɨn yoyɨŋ dekgɨt. Yaŋ aŋakwan amɨn kɨsi da aŋkɨsiwit. ");
INSERT INTO yut_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu uŋun Nasaret kokupmon kɨgɨt. Kalɨp uŋun kokupmon egek tagaŋ teban taŋek amɨn tagɨ agɨt. Sabat bɨsapmon Juda amɨn da muwut muwut yutnon wɨgɨ wɨgɨ agɨt uŋudeŋ gɨn Sabat kɨndakon wɨgɨgɨt. Aŋek Piŋkop dakon gen manjɨk do pɨdaŋ akgɨt. ");
INSERT INTO yut_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pɨdaŋ agakwan kombɨ amɨn Aisaia dakon papia ɨba abɨdaŋ wɨtdalek gen yaŋ naŋ manjɨgɨt: ");
INSERT INTO yut_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Amɨn Tagɨ dakon Wupni nagon tosok, nido amɨn yoni mɨnikon kɨŋek Gen Bin Tagɨsi yoyɨkeŋ do nak manjɨŋek but nelak tagɨl namgut. Ae dam tebanon ekwaŋ amɨn pulugaŋ kɨ abɨgɨni yaŋ yoyɨkeŋ do yabekgɨt. Ae dabɨlɨ mɨni amɨn tagɨ sɨŋtoni, ae amɨn da pabɨŋ yopmaŋgaŋ amɨn uŋun pulugaŋ yopbeŋ do yabekgɨt. ");
INSERT INTO yut_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Amɨn Tagɨ da mɨŋat amɨn kabɨni yo tagɨsi aŋyomdɨsak dakon bɨsap kɨlɨ abɨsak uŋun dakon yaŋ teŋteŋok akeŋ do yabekgɨt.” ");
INSERT INTO yut_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu uŋun gen manjɨŋ mudaŋek papia gɨroŋɨgek kɨla amɨn do ɨmɨŋek yɨkgɨt. Yɨgakwan uŋun muwut muwut yutnon amɨn kɨsi dabɨlni Yesukon gɨn taŋakwan yɨkgwit. ");
INSERT INTO yut_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aŋakwa Yesu da yaŋ yoyɨgɨt, “Piŋkop dakon gen manjɨko nandayɨŋ uŋun abɨsok dabɨljikon bamɨ toŋ asak.” ");
INSERT INTO yut_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yaŋban amɨn gen yagɨt do nandaba tagɨsi aŋakwan yawit, “Mao! On Josep dakon monji da niaŋonsi da gen galagɨsi on yosok?” ");
INSERT INTO yut_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yaŋba Yesu yoyɨgɨt, “Amɨn da gen kɨnda yoŋ uŋun yaŋ: ‘Wuda wamak gaga dakon gɨptɨm aŋmɨlɨp a.’ Uŋun gen nak nayɨkdaŋ, ma? Ae ‘Kapaneam kokupmon wasok agɨl do amɨn da yaŋba nandagɨmaŋ uŋun yomaninon yaŋ gɨn abi do nandamaŋ’ yaŋ nayɨkdaŋ, ma? ");
INSERT INTO yut_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nak asisi dayɨsat, kombɨ amɨn morap kokup kaloŋni da geni dɨma nandaŋ yomaŋ. ");
INSERT INTO yut_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Asisi, kombɨ amɨn Elaija da bɨsapmon sɨkak dɨma maŋakwan bɨlak kapbɨ ae kanek 6 yaŋ egek jap do madepsi awit. Uŋun bɨsapmon Israel mɨktɨmon sakwabat morapmɨ egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Mani Piŋkop da Elaija Israel sakwabat kɨnda do dɨma yabekgɨt. Sakwabat kɨnda Sarepat kokupmon egɨpgut uŋun do yabekban kɨgɨt. Sarepat uŋun Saidon kokup da tetgɨn do tosok. ");
INSERT INTO yut_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ae kombɨ amɨn Elisa da bɨsapmon Israel mɨktɨmon wuda tebani toŋ amɨn morapmɨ egɨpgwit, mani kɨnda dɨma kɨlek tagɨt. Siria mɨktɨmon nani amɨn kɨnda mani Neman uŋun dagɨn kɨlek tagɨt.” ");
INSERT INTO yut_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yaŋ yaŋban amɨn muwut muwut yutnon egɨpgwit kɨsi da japmɨsi nandaŋek ");
INSERT INTO yut_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","pɨdaŋ Yesu yolba kokup da waŋga pɨgɨgɨt. Kokup uŋun ɨleŋon tagɨt, do tɨpdomon maba pɨgɨsak do aŋkɨwit. ");
INSERT INTO yut_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mani amɨn da bɨkbɨgon da si kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu Nasaret kokup yɨpmaŋek Galili mɨktɨmon kokup kɨnda mani Kapaneam uŋudon pɨgɨgɨt. Pabɨgɨ egek Sabat bɨsap morapmon amɨn yoyɨŋ dekgɨt. ");
INSERT INTO yut_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yoyɨŋ degakwan amɨn kɨnda man madepni toŋ da gen ŋwakŋwarɨsi niyɨsak yaŋ nandawit. ");
INSERT INTO yut_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Koŋni toŋ amɨn kɨnda Juda amɨn da muwut muwut yutnon yɨkgɨt. Uŋun da madepsi yaŋ tɨdaŋek yaŋ yagɨt, ");
INSERT INTO yut_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yesu, Nasaret amɨn, gak nibaŋ aŋnim do nandɨsal? Nin paŋupbal ak do abɨl? Nak nandaŋ gamɨsat, gak Piŋkop Dakon Telagɨ Amɨni.” ");
INSERT INTO yut_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mani Yesu da koŋ tebai yaŋ iyɨgɨt, “Gak gen dɨma yaŋek amɨn on yɨpmaŋ det!” Yaŋ iyɨŋakwan koŋ uŋun da amɨn ukwayɨkban maŋ amɨn da binapmon pakgɨt. Pagakwan amɨn uŋun dɨma aŋupbal aŋek yɨpmaŋ kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Amɨn da uŋun kaŋ wurɨpdagek notni yoyɨŋ yoyɨŋ aŋek yawit, “Mao, niaŋ gen kɨnda yosok? Amɨn man madepni toŋ ae tapmɨmni toŋ da tɨlagon koŋ gen tebai yoyɨŋban geni nandaŋek pasal kwaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yaŋ yaŋakwa Yesu da pi agɨt dakon gen uŋun provins dakon amɨn kɨsi da nandawit. ");
INSERT INTO yut_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu Juda amɨn dakon muwut muwut yut yɨpmaŋek Saimon da yutnon kɨgɨt. Saimon dakon yopmi sot aŋek gɨptɨmni kɨndapmɨ sogɨt. Yaŋ aŋakwan Yesu da aŋpulugosak do iyɨwit. ");
INSERT INTO yut_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aba Yesu uŋun mɨŋat da kapmatjok paŋkɨ agek gɨptɨmni kɨndapmɨ sogɨt uŋun pasɨl ɨmjak do tebai yagɨt. Yaŋban sotni pasɨl ɨmɨŋakwan uŋudon gɨn pɨdaŋek japni paŋkosit agɨt. ");
INSERT INTO yut_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Gɨldat si pɨgɨk do aŋakwan amɨn da notni sot mibɨlɨ mibɨlɨ awit uŋun Yesukon paŋopgwit. Paŋopba Yesu da kɨsitni kwenikon kaloŋ kaloŋ wutjɨŋek paŋmɨlɨp agɨt. ");
INSERT INTO yut_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ae amɨn morapmɨ koŋni toŋ uŋun yol yomgut. Yolakwan koŋ da yaŋ tɨdaŋek yawit, “Gak Piŋkop dakon Monji.” Yesu uŋun Kristo yaŋ nandaŋ ɨmgwit, do Yesu da koŋ gen dɨmasi yoni do kɨrɨŋɨk yomgut. ");
INSERT INTO yut_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wɨsa dagokdosi Yesu amɨn dɨma egɨpgwit tɨm kɨndakon kɨgɨt. Aŋakwan amɨn da wusɨŋ aŋalon aŋek dɨma yopmaŋ kɨsak do nandaŋek abɨdok do awit. ");
INSERT INTO yut_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mani yaŋ yoyɨgɨt, “Nak Piŋkop da Amɨn Kɨla Akdɨsak uŋun dakon Gen Bin Tagɨsi kokup pap dɨwarɨkon kɨsi agek yoyɨŋ teŋteŋokeŋ. Nak Piŋkop da uŋun pi abeŋ dosi yabekgɨt.” ");
INSERT INTO yut_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yaŋ yaŋek Judia mɨktɨmon muwut muwut yut taŋ aŋaŋ kɨwit uŋudon agek Piŋkop gen yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Bɨsap kɨndakon Yesu Genesaret Pakbi Ɨdap ɨleŋɨkon agek Piŋkop dakon gen yaŋakwan amɨn morapmɨ da abɨŋ uŋun da kapmatsisok aŋgwasɨŋek nandawit. ");
INSERT INTO yut_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu bot bamorɨ ɨleŋɨkon taŋbal pɨndakgɨt. Uŋun tap kɨlap sɨmɨl sɨmɨl amɨn da yopba taŋakwal tap kɨlap sɨmɨl sɨmɨl yɨkni pakbikon sugawit. ");
INSERT INTO yut_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu uŋun bot kɨndakon mɨlkaŋ wɨgɨgɨt. Bot uŋun Saimon dakon. Uŋun boron wɨgek Saimon yaŋ iyɨgɨt, “Bot ɨmɨŋdɨlbɨ tɨmɨsok dɨ pakbikon kwan.” Yaŋ iyɨŋek Yesu boron yɨgek amɨn yoyɨŋ dekgɨt. ");
INSERT INTO yut_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yoyɨŋ dek mudaŋek Saimon yaŋ iyɨgɨt, “Tɨmɨsok dɨ gat kɨŋek pakbi ɨlarɨkon kɨŋek tap kɨlap sɨmɨl do yɨk yopba pɨgɨni.” ");
INSERT INTO yut_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Yaŋban Saimon da iyɨgɨt, “Amɨn tagɨ, nin kalbi tap kɨlap sɨmɨl do pi madep aŋek tap kɨlap kɨnda dɨma ɨlɨgapdo wɨsa dagak. Mani gak dakon gen guramɨgek yɨk yum yopno pɨgɨni.” ");
INSERT INTO yut_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yoyɨgɨt uŋudeŋ aŋakwa tap kɨlap morapmɨsi yɨgon pɨgɨ tugaŋek yɨk dagok do awit. ");
INSERT INTO yut_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Aŋakwa notni bot kɨndakon agɨpgwit amɨn da abɨŋ paŋpulugoni do kɨsit da tɨlak aŋ yomgwit. Tɨlak aŋ yoba apba tap kɨlap bot bamot kɨsikon yopba tugaŋ jɨk taŋek pakbi kagagwan pɨgɨk do agɨmal. ");
INSERT INTO yut_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Saimon gat notni kabɨ gat tap kɨlap ɨlɨkgwit uŋun pɨndagek tamtam yawit. Ae Saimon dakon pi ɨsal bamotni Jems gat Jon gat Sebedi dakon monji yat uŋun kɨsi tamtam yagɨmal. Aŋek Saimon Pita da Yesu ŋwakbeŋ aŋ ɨmɨŋek yaŋ iyɨgɨt, “Amɨn Tagɨ, nepmaŋ dek kɨ. Nak yokwi pakpak!” Yaŋban Yesu da Saimon yaŋ iyɨgɨt, “Gak dɨma pasolbi. Abɨsok onda wasaŋek gak amɨn tɨmɨtdɨsal.” ");
INSERT INTO yut_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yaŋ yaŋban bot bamotni ɨlɨkba ɨleŋɨkon wɨgakwal yo morapni kɨsi yopmaŋek Yesu yolgwit. ");
INSERT INTO yut_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Bɨsap kɨndakon Yesu kokup pap kɨndakon egakwan amɨn wuda tebani toŋ kɨnda egɨpgut. Uŋun da Yesu kaŋek ŋwakbeŋ aŋ ɨmɨŋek mɨktɨmon gawagek Yesu bɨsit tebai iyɨgɨt, “Amɨn Tagɨ, Piŋkop da dabɨlon kɨlek tokeŋ do nandɨsal kaŋ, tagɨ aŋmɨlɨp abɨ kɨlek tokeŋ.” ");
INSERT INTO yut_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yaŋban Yesu da kɨsitni amɨn uŋun kwenikon wɨtjɨŋek yaŋ iyɨgɨt, “Kɨlek toki do nandɨsat, do pasɨl gamni!” Yaŋ yaŋban uŋudon gɨn wuda tebani pasɨl ɨmɨŋakwa kɨlek tagɨt. ");
INSERT INTO yut_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aban Yesu da yaŋ iyɨgɨt, “Gak amɨn dɨmasi yoyɨŋek kɨŋ mukwa sogok amɨnon gɨptɨmgo yolɨki. Aŋek Moses da yagɨt uŋun da tɨlagon paret aŋaki amɨn da asi kɨlek tal yaŋ gandani.” ");
INSERT INTO yut_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mani Yesu da yo agɨt dakon geni sigɨn kɨŋ ɨreŋ tagɨt. Aŋakwan amɨn morapmɨ da geni nandak do opgwit. Ae sotni paŋmɨlɨp aŋyomjak do opgwit. ");
INSERT INTO yut_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mani Yesu bɨsap morapmɨ mɨktɨm amɨn dɨma ekwaŋ tɨmon paŋkɨ egek bɨsit pi agɨt. ");
INSERT INTO yut_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Bɨsap kɨndakon Yesu amɨn yoyɨŋ degakwan Parisi amɨn ae gen teban yoyɨŋdet amɨnyo kɨsi paŋobɨŋ yɨkgwit. Uŋun amɨn Jerusalem, ae Galili dakon kokup morap toŋ, ae Judia mɨktɨmon da opgwit. Yesu Amɨn Tagɨ dakon tapmɨm taŋ ɨmgut, do sot amɨn paŋmɨlɨp agɨt. ");
INSERT INTO yut_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Aŋakwan amɨn kabi kɨnda da amɨn kɨsirɨ kandapmɨyo kɨmakbi kɨnda wamaŋ aŋaŋ opgwit. Uŋun wayɨgon yɨpba pagakwan aŋaŋ Yesu da akgɨron awɨgɨk do awit. ");
INSERT INTO yut_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mani amɨn morapmɨ, do yutnon awɨgɨk do aŋtɨdok awit. Do yut kwenon wɨgɨ yut tuwɨlek amɨn uŋun wayɨgon pagakwan napmon da abɨdaŋakwa amɨn morap da binapmon pɨgek Yesu da buronsi pɨgɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu da nandaŋ gadatni pɨndagek yagɨt, “Not, dɨwarɨgo yopmaŋ gamɨsat.” ");
INSERT INTO yut_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yaŋban Parisi amɨn gat ae gen teban yoyɨŋdet amɨn gat da iyɨ yaŋ nandawit, “On namɨn amɨn kɨnda da Piŋkop kulabɨŋek gen uŋun yosok? Dɨwarɨ yopyop uŋun amɨn kɨnda da arɨpmɨ dɨmasi agagɨ. Uŋun Piŋkop kaloŋ dagɨn asak.” ");
INSERT INTO yut_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu da nandak nandakni uŋun pɨndak nandaŋyo aŋek yaŋ yoyɨgɨt, “Ji nido butjikon da nandak nandak uŋun nandaŋ namaŋ? ");
INSERT INTO yut_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Dɨwarɨ yopyop ae amɨn kɨsit kandapmɨyo kɨmakbi paŋmɨlɨp agak uŋun kɨsi amɨn da arɨpmɨ dɨma agagɨ. ");
INSERT INTO yut_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mani Amɨn Dakon Monji on mɨktɨmon dɨwarɨ wɨrɨrɨt dakon pi asak do yaŋ mudaŋ ɨbi yaŋ nandaba pɨsosak do on amɨn aŋmɨlɨp abeŋ.” Yesu yaŋ yaŋek kɨsirɨ kandapmɨyo kɨmakbi amɨn kaŋek yaŋ iyɨgɨt, “Nak gayɨsat, gak pɨdaŋ yalɨŋ potgo tɨmɨgek yutgokon kɨ.” ");
INSERT INTO yut_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yaŋban uŋudon gɨn amɨn uŋun pɨdaŋek yalɨŋ potni tɨmɨgek Piŋkop aŋkɨsiŋek yutnikon kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Aŋakwan mɨŋat amɨn morapyo uŋun kaŋ wurɨpdagek Piŋkop aŋkɨsiŋek yawit, “Abɨsok yo ŋwakŋwarɨsi altaŋban komaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Uŋun da kwenon Yesu yomakon pɨgek kɨŋ kaŋban takis tɨmɨt tɨmɨt yut kabeŋon takis tɨmɨt tɨmɨt amɨn kɨnda yɨkban kagɨt. Uŋun mani Liwai. Yesu da Liwai yaŋ iyɨgɨt, “Abɨŋ nak nol.” ");
INSERT INTO yut_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yaŋ iyɨŋban Liwai pɨdaŋ yo morapni kɨsi yopmaŋek Yesu yolgɨt. ");
INSERT INTO yut_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Aŋek Liwai da yutnikon Yesu do jap madepsi paŋkosit agɨt. Yaŋ aban takis tɨmɨt tɨmɨt amɨn morapmɨ gat ae amɨn dɨwarɨ gat kɨsi yɨgek jap nawit. ");
INSERT INTO yut_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aŋakwa Parisi amɨn gat ae gen teban yoyɨŋdet amɨn Parisi da kabɨkon nani uŋun da Yesu dakon paŋdetni do yaŋba yokwi tok aŋek yaŋ yoyɨwit, “Ji jap pakbiyo takis tɨmɨt tɨmɨt amɨn ae yokwi pakpak amɨn gat nido aŋ?” ");
INSERT INTO yut_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yaŋba Yesu da yaŋ yoyɨgɨt, “Amɨn sotni mɨni uŋun wuda wamagon dɨma kwaŋ. Amɨn sotni toŋ uŋun dagɨn wuda wamagon kwaŋ. ");
INSERT INTO yut_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nak amɨn kɨlegɨ yaŋ ɨlɨt do dɨma pɨgɨm. Yokwi pakpak yaŋ ɨlɨkgo but tobɨl ani do pɨgɨm.” ");
INSERT INTO yut_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Parisi amɨn da Yesu yaŋ iyɨwit, “Jon dakon paŋdetni bɨsap morapmɨ Piŋkop do nandaŋek jap kelek egek bɨsit pi aŋ. Ae Parisi amɨn nin dakon paŋdetnin kɨsi yaŋ gɨn aŋ. Mani gak dakon paŋdetgoni jap pakbiyo aŋek ekwaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yaŋba Yesu da yoyɨgɨt, “Monjɨ kɨnda mɨŋat pasak bɨsapmon uŋun jap noknok bɨsap madep kɨnda, ae monjɨ notni gat ekwaŋ, do jap kelek tagɨ dɨma egɨpni. ");
INSERT INTO yut_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mani don monjɨ uŋun abɨdaŋ aŋaŋ kɨŋakwa notni uŋun bɨsapmon jap kelek ekwaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu da tɨlak gen kɨnda gat yoyɨŋek yagɨt, “Amɨn kɨnda da ɨmal kalugɨ kɨnda pudaŋ ɨmal garaŋɨ dagaŋ kwi kɨndakon bupjak kaŋ uŋun tagɨ dɨma. Yaŋ asak kaŋ, ɨmal kalugɨ aŋupbal asak. Ae ɨmal kalugɨ uŋun kalɨpmɨ gat arɨp dɨma. ");
INSERT INTO yut_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ae amɨn kɨnda da wain kalugɨ tɨbɨrɨ meme gɨp baŋ wasaŋbi kalɨpmɨ kɨndakon kolesak kaŋ uŋun tagɨ dɨma. Yaŋ asak kaŋ, wain da pukwa paptaŋ meme gɨp kɨrɨŋɨgakwa wain maŋ mudokdaŋ. Ae meme gɨpyo kɨsi yokwi tokdɨsak. ");
INSERT INTO yut_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Do wain kalugɨ meme gɨp kalugɨkon kolaŋ. ");
INSERT INTO yut_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ae wain kalɨpmɨ nosok amɨn wain kalugɨ nok do kuragɨ nandaŋek yaŋ yosok, ‘Wain kalɨpmɨ uŋun tagɨsi.’ ” ");
INSERT INTO yut_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat bɨsap kɨndakon Yesu wit pi binap kɨnda naŋ kɨgɨt. Kɨŋakwan paŋdetni da wit bamɨ dɨ jɨmɨk kɨsit da mɨsɨŋɨkba gɨpmɨ maŋakwa bamɨ si nawit. ");
INSERT INTO yut_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aŋakwa Parisi amɨn dɨ da pɨndagek yawit, “Ji Sabat bɨsap dakon gen teban yapmaŋek nido yaŋ aŋ?” ");
INSERT INTO yut_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yaŋba Yesu da kobogɨ yaŋ yoyɨgɨt, “Ji Dewit gat amɨn kabɨni gat da jap do awit bɨsapmon yo awit uŋun dɨ manjɨŋ nandaŋ bo dɨma? ");
INSERT INTO yut_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dewit uŋun Piŋkop da yutnon wɨgɨ bret Piŋkop do parekbi uŋun tɨmɨkgɨt. Bret uŋun mukwa sogok amɨn dagɨn tagɨ noknogɨ. Mani Dewit da naŋek amɨn kabɨni kɨsi do yomgut.” ");
INSERT INTO yut_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu da sigɨn yaŋ yoyɨgɨt, “Amɨn Dakon Monji uŋun Sabat bɨsap dakon Amɨn Tagɨ.” ");
INSERT INTO yut_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat bɨsap kɨndakon Yesu Juda amɨn da muwut muwut yutnon wɨgek yoyɨŋdet agɨt. Uŋudon amɨn kɨsirɨ amɨnsi tetni gɨreŋɨkbi kɨnda egɨpgut. ");
INSERT INTO yut_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Parisi amɨn gat ae gen teban yoyɨŋdet amɨn gat da Yesu Sabat bɨsapmon amɨn paŋmɨlɨp aban kaŋek gen yaŋ ɨmneŋ yaŋ do kaŋ egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mani Yesu da nandak nandakni pɨndak nandaŋyo aŋek amɨn kɨsirɨ gɨreŋɨkbi yaŋ iyɨgɨt, “Gak pɨdaŋ amɨn da ɨŋamon at.” Iyɨŋban amɨn uŋun pɨdaŋ akgɨt. ");
INSERT INTO yut_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pɨdaŋ agakwan Yesu da yoyɨgɨt, “Ji niaŋ nandaŋ? Sabat bɨsap dakon gen teban uŋun aŋpak tagɨ bo yokwi aneŋ do yosok? Amɨn kutnok do yosok, bo ae amɨn si paŋupbal ano kɨmotni do yosok?” ");
INSERT INTO yut_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu da amɨn morap kɨsi pɨndak aŋaŋ kɨ mudaŋek yaŋ iyɨgɨt, “Kɨsitgo aŋnɨŋnɨŋ a.” Iyɨŋban yaŋ gɨn aŋakwan kɨsirɨ kɨlek tagɨt. ");
INSERT INTO yut_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mani Parisi amɨn gat ae gen teban yoyɨŋdet amɨn gat da japmɨsi nandaŋ ɨmɨŋek iyɨ gɨn yaŋ nandat aŋek Yesu niaŋsi aŋ ɨmno yaŋ yawit. ");
INSERT INTO yut_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Uŋun bɨsapmon Yesu kalbi bɨsit pi ak do kabap kɨndakon wɨgɨ Piŋkop bɨsit iyɨgɨt. Bɨsit pi aŋ egakwan wɨsa dagaŋban ");
INSERT INTO yut_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","paŋdetni yaŋ yoban apba 12 kabɨ manjɨgɨt. Manjɨŋek yabekbi man yomgut. ");
INSERT INTO yut_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kɨnda uŋun mani Saimon (uŋun Yesu da Pita yaŋ iyɨgɨt). Ae Saimon dakon padɨge Andru, ae Jems, Jon, Pilip, Batolomiu, ");
INSERT INTO yut_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Alpius dakon monji Jems, ae Saimon (uŋun Selot da kabɨkon nani), ");
INSERT INTO yut_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ae Jems dakon monji Judas, ae Judas Iskariot (uŋun da don Yesu uwal da kɨsiron yɨpgut). ");
INSERT INTO yut_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu uŋun amɨn kabɨ tɨmɨkban ɨleŋon da mɨktɨm kuldukgɨbaŋ kɨndakon pukwa paŋdetni morapmɨ gat kɨsi akgwit. Aŋakwa Judia mɨktɨm dakon amɨn morapmɨ gat, ae Jerusalem kokup papmon amɨn gat, ae tap amɨn Tair ae Saidon kokup da kapmatjok egɨpgwit amɨn uŋun gat kɨsi egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Uŋun geni nandakdo, ae sotni paŋmɨlɨp asak do nandaŋek apgwit. Koŋ da paŋupbal abi amɨn uŋun Yesu da paŋmɨlɨp agɨt. ");
INSERT INTO yut_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sot amɨn paŋmɨlɨp agak dakon tapmɨm Yesukon da apgut, do amɨn morap kɨsitni kwenikon ɨgayɨk do awit. Yaŋ aŋek kɨlek tawit. ");
INSERT INTO yut_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu da paŋdetni pɨndagek yagɨt, “Yoni mɨni amɨn ji kɨsɨk kɨsɨk ekwaŋ, nido ji Piŋkop da Amɨn Kɨla Asak uŋun da kagagwan ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Abɨsok jap do aŋ amɨn ji kɨsɨk kɨsɨk ekwaŋ. Don jap naŋ tugokdaŋ. Abɨsok kunam takgaŋ amɨn ji kɨsɨk kɨsɨk ekwaŋ. Don jɨkgo yanjakdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Amɨn da dandaba ji Amɨn Dakon Monji yolyol amɨn yaŋ dandaŋek nandaba yokwi tok aŋdamdaŋ. Ji uŋun gat gadaŋek dɨma egɨpni do dayɨŋek yaŋba yokwi tok aŋ damɨŋek man yokwisi damdaŋ. Yo morap uŋun altaŋ damdaŋ, mani ji kɨsɨk kɨsɨk ani. ");
INSERT INTO yut_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Uŋun bɨsapmon ji butji tagɨsi taŋakwan kɨsɨk kɨsɨk aŋek wɨgɨ mok ani. Nandani. Kobogɨ do tomni wukwisi Kwen Kokupmon taŋ damɨsak. Kalɨp babɨni da kombɨ amɨn do yo yokwi yaŋ gɨn aŋyomgwit. ");
INSERT INTO yut_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Mani yoni morapmɨ amɨn, awa! Ji yo tagɨsi wagɨl tɨmɨkgaŋ. Don butji paŋteban ak do yo dɨ dɨma tɨmɨtdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Abɨsok jap naŋek butji paptoŋ amɨn, awa! Don jap do akdaŋ. “Abɨsok jɨkgo yanjaŋ amɨn, awa! Don kunam tagakwa dabɨl pakbisi mokdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Amɨn da man madep damaŋ amɨn, awa! Kalɨp babɨkji da kombɨ amɨn toptopmɨ do yaŋ gɨn aŋ yomgwit.” ");
INSERT INTO yut_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesu da saŋbeŋek yaŋ yagɨt, “Geno nandaŋ amɨn yaŋ dayɨsat, ji uwalji do but dasi galak taŋ yomni. Ae nandaba yokwi tok aŋ damaŋ amɨn do aŋpak tagɨ aŋyomni. ");
INSERT INTO yut_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ae jobɨt tɨmɨtni do dayaŋ amɨn, uŋun Piŋkop da paŋpulugosak do bɨsit iyɨni. Ae yokwi aŋ damaŋ amɨn do bɨsit ani. ");
INSERT INTO yut_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Amɨn kɨnda da mogɨm kulbak gɨkban kaŋ, terɨ kɨnda kɨsi aŋtobɨl ɨbi. Ae amɨn kɨnda da mɨrɨm ɨmalgo gwayeŋban kaŋ, yum kaŋaki paba pɨgɨkgo kɨsi abɨdosak. ");
INSERT INTO yut_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ae amɨn morap da yo kabɨgo yobi do gayɨŋba kaŋ yobi. Ae amɨn kɨnda da yogo kɨnda abɨdaŋ aŋkɨsak kaŋ, aŋtobɨl gamjak do tebai dɨma iyɨki. ");
INSERT INTO yut_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Amɨn da aŋpak niaŋsi aŋdamni do nandaŋ, uŋun aŋpak amɨn do aŋyomni. ");
INSERT INTO yut_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Amɨn butdasi galak taŋ damaŋ baŋgɨn butdasi galak taŋ yomni kaŋ, ji amɨn tagɨ dɨma. Yokwi pakpak amɨn uŋun kɨsi amɨn butdasi galak taŋ yomaŋ baŋ butdasi galak taŋ yomaŋ. ");
INSERT INTO yut_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ae aŋpak tagɨ aŋdamaŋ amɨn baŋgɨn aŋpak tagɨ aŋyomni kaŋ, ji amɨn tagɨ dɨma. Yokwi pakpak da aŋpak uŋun kɨsi aŋ. ");
INSERT INTO yut_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ae uŋun amɨn goman tagɨ sopjak yaŋ nandaŋ teban taŋek amɨn kɨnda do yo ɨmni kaŋ, ji amɨn tagɨ dɨma. Yokwi pakpak amɨn notni da goman uŋun kɨsisi sopdaŋ yaŋ nandaŋek notni do yo yomaŋ. ");
INSERT INTO yut_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mani ji uwalji do but dasi galak taŋ yomɨŋek aŋpak tagɨsi aŋ yomni. Aŋek amɨn do yo yomɨŋek sopni do dɨma yoyɨni. Piŋkop da yokwi pakpak ya yaŋ dɨma iyaŋ amɨn uŋun do yo tagɨ yumsi yomɨsak, do ji aŋpak tagɨsi ani kaŋ, Piŋkop Wɨkwisi da kobogɨ do yo tagɨsi damɨŋakwan monjinisi egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Datgo da amɨn do bupmɨ nandɨsak, do jiyo yaŋ gɨn amɨn do bupmɨ nandani.” ");
INSERT INTO yut_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesu da saŋbeŋek yaŋ yagɨt, “Ji amɨn dakon aŋpak dɨma kokwinɨtni kaŋ, Piŋkop da jiyo kɨsi dɨma kokwinɨtjak. Ji amɨn yokwi aba uŋun do kobogɨ tɨmɨtni do dɨma yoyɨni kaŋ, Piŋkop da jiyo kɨsi yokwisi do tebai dɨma dayɨkdɨsak. Ji amɨn dakon dɨwarɨni yopmaŋ yomni kaŋ, Piŋkop da ji dakon dɨwarɨsi yaŋ gɨn yopmaŋ damdɨsak. ");
INSERT INTO yut_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ji amɨn do yo yomni kaŋ, Piŋkop da ji do yo damdɨsak. Uŋun da yo morapmɨsi damɨŋakwan tugok tugogɨsi egɨpdaŋ. Tɨlak niaŋsi yomni uŋun da tɨlak yaŋ gɨn tɨmɨtdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu da tɨlak gen kɨnda yaŋ yoyɨgɨt, “Dabɨlɨ mɨni kɨnda dabɨlni mɨni notni kɨnda kosit tagɨ yolɨsak? Kaŋ kɨsi bamot gapmagwan mokdamal. ");
INSERT INTO yut_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Papia yut mɨŋat monjɨyo yoyɨŋdetni dɨma yapmaŋgaŋ. Mani papia yut tagɨsi wɨgɨ mudaŋek don yoyɨŋdetni yombem aŋ. ");
INSERT INTO yut_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Gaga da dabɨlon kɨndap kwɨk tosok uŋun do dɨma nandaŋek notgo da dabɨlon jɨmjɨm nido kosol? ");
INSERT INTO yut_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Gaga da dabɨlon kɨndap kwɨk tosok uŋun dɨma kaŋek niaŋon da notgo ‘Dabɨlgokon jɨmjɨm tosok uŋun paŋ gamdɨsat’ yaŋ iyɨki? Gak jamba but amɨn. Mibɨltok gaga da dabɨlon kɨndap kwɨk tosok uŋun abɨ kɨŋakwan notgo da dabɨlon jɨmjɨmjok tosok uŋun kaŋbɨ pɨsaŋakwan tagɨ paki.” ");
INSERT INTO yut_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesu da saŋbeŋek yagɨt, “Kɨndap tagɨ da bamɨ yokwi arɨpmɨ dɨma potni. Ae kɨndap yokwi da bamɨ tagɨ arɨpmɨ dɨma potni. ");
INSERT INTO yut_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Amɨn da kɨndap sop bamɨ baŋ pɨndagek kɨndap yokwi bo tagɨ yaŋ pɨndak nandaŋyo aŋ. Amɨn da pik kɨndap dakon bamɨ pak do nap kelɨ toŋon kɨŋ dɨma dekgaŋ. Ae wain sop kɨndap yokwi kelɨ toŋon kɨŋ dɨma paŋ. ");
INSERT INTO yut_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Amɨn kɨlegɨ uŋun nandak nandakni kɨlegɨ morapmɨ butnikon toŋ, do aŋpak kɨlegɨsi asak. Aŋakwan amɨn yokwi uŋun nandak nandak yokwi butnikon toŋ, do aŋpak yokwi asak. Nandak nandak niaŋ amɨn butgwan toŋ, uŋun gen kagakon da yoŋ.” ");
INSERT INTO yut_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesu da saŋbeŋek yaŋ yagɨt, “Ji nido nak Amɨn Tagɨ yaŋ nayɨŋek geno dɨma guramɨkgaŋ? ");
INSERT INTO yut_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nagon obɨŋek geno nandaŋek guramɨkgaŋ amɨn uŋun dakon tɨlak kɨnda dolɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Amɨn kɨnda yutni ak do aŋek gapma wayɨkban mibɨlɨsigwan pɨgakwan mɨktɨmgwan tɨp madep da kwenon gwak magɨt. Aŋek don yut uŋun da kwenon agɨt. Aban pakbi madepsi ɨgek yutni tɨdaŋ tuwɨl do agɨt mani yutni tebaisi agɨt, do tebaisi akgɨt. ");
INSERT INTO yut_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mani amɨn kɨnda nak dakon gen nandaŋek dɨma guramɨkdak amɨn uŋun amɨn kɨnda yombem. Uŋun yutni teban tokni mɨni ɨsal mɨktɨm kwenon gɨn agɨt. Don pakbi ɨgek yut uŋun tɨdaŋban uŋudon gɨn tuwɨl kɨ madepsi tasɨk tagɨt.” ");
INSERT INTO yut_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu gen uŋun amɨn yoyɨŋ mudaŋek Kapaneam kokupmon pɨgɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Uŋun kokupmon Rom dakon emat amɨn 100 dakon mibɨltok amɨn kɨnda egɨpgut. Uŋun dakon oman amɨni si galak taŋ ɨmgut uŋun sot madep aŋek kɨmotdosi agɨt. ");
INSERT INTO yut_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Aŋakwan uŋun mibɨltok amɨn da Yesu dakon gen bini nandagɨt, do Juda amɨn dakon kɨla amɨn dɨ yabekban Yesukon kɨwit. Kɨŋ Yesu da abɨŋ oman amɨni aŋmɨlɨp asak do iyɨwit. ");
INSERT INTO yut_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Aŋek Yesu da aŋpulugosak do madepsi yaŋ iyɨwit, “Uŋun amɨn tagɨsi, do geni nandaŋek kɨŋ oman monjɨni aŋpulugoki. ");
INSERT INTO yut_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Uŋun amɨn da Juda amɨn nin do galak taŋ nimɨsak, ae muwut muwut yutnin wɨtjɨŋ nimgut.” ");
INSERT INTO yut_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yaŋ iyɨŋba Yesu gat kɨsi kɨwit. Kɨŋ yutni aŋkapmat aŋakwa mibɨltok amɨn da notni dɨ yabekban obɨŋ Yesu yaŋ iyɨwit, “Mibɨltok amɨn da gak do yaŋ yosok, ‘Amɨn Tagɨ, pi madep dɨma gabeŋ. Nak amɨn pɨŋbisi, do nak da yutnon wɨki uŋun da tagɨ dɨma asak. ");
INSERT INTO yut_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yaŋdo, naga gagon dɨma abɨt. Mani gak da kɨlek tosak do yaŋaki tagɨ kɨlek tosak. ");
INSERT INTO yut_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nido nak madepno da yoŋgamgwan egɨsat, do nak da uŋun dakon pɨŋbini egɨsat. Ae emat amɨno nak da yoŋgamgwan ekwaŋ, do kɨnda “Kɨ!” yaŋ iyɨko kɨsak. Ae kɨnda “Ap!” yaŋ iyɨko abɨsak. Ae oman amɨno kɨnda “Pi on aki!” yaŋ iyɨko pi asak.’ ” ");
INSERT INTO yut_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu gen uŋun nandaŋek nandaban yo madepsi aban tobɨlek amɨn madepsi buŋon yolgwit yaŋ yoyɨgɨt, “Nak yaŋ dayɨsat, Israel amɨnon nandaŋ gadatni madep on amɨn dakon yombem kɨnda dɨma kagɨm.” ");
INSERT INTO yut_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yaŋ yaŋban amɨn yabekgɨt uŋun tobɨl yutnon wɨgɨ oman monjɨ uŋun kɨlɨ kɨlek tagɨt kawit. ");
INSERT INTO yut_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yesu bɨsap pɨsɨpmɨsok egek kokup kɨnda mani Nain uŋudon kɨŋakwan paŋdetni gat ae amɨn morapmɨsi gat kɨsi kɨwit. ");
INSERT INTO yut_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kɨŋ uŋun kokup dakon tɨp dam dakon wigat aŋkapmat agɨt. Aŋek amɨn da amɨn kɨmakbi kɨnda wamaŋ aŋaŋ waŋga pɨŋba pɨndakgɨt. Amɨn kɨmakgɨt uŋun dakon meŋi uŋun sakwabat egakwan monjɨ kaloŋɨsi da kɨmakgɨt. Uŋun kokup madep dakon amɨn morapmɨsi uŋun sakwabat gat kɨsi pɨŋba pɨndakgɨt. ");
INSERT INTO yut_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Amɨn Tagɨ da sakwabat uŋun kaŋek bupmɨsi nandaŋ ɨmɨŋek yaŋ iyɨgɨt, “Gak kunam dɨma takgi.” ");
INSERT INTO yut_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yaŋ yaŋek kɨŋ bumjot abɨwit tamo wɨtjɨŋakwan bumjot guramɨkgwit amɨn uŋun akgwit. Agakwa Yesu da yaŋ yagɨt, “Monjɨ gɨmoŋɨ pɨdoki do gayɨsat!” ");
INSERT INTO yut_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yaŋ iyɨŋban amɨn kɨmakbi uŋun pɨdaŋ yɨgek wasaŋek gen yagɨt. Yaŋban Yesu da meŋi do ɨmgut. ");
INSERT INTO yut_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Aban amɨn morap kɨsi pasalek Piŋkop aŋkɨsiŋek yaŋ yawit, “Kombɨ amɨn madepsi kɨnda nin da bɨkbɨgon altaŋban komaŋ. Piŋkop da mɨŋat amɨn kabɨyoni Israel paŋpulugok do abɨk.” ");
INSERT INTO yut_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ae Yesu da yo agɨt uŋun dakon gen bin da madepsi ɨreŋ taŋek Judia mɨktɨm kɨsi arɨpmɨ agɨt, ae mɨktɨm dɨwarɨkon kɨsi kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon dakon paŋdetni da Yesu da yo morap agɨt dakon geni Jon iyɨwit. ");
INSERT INTO yut_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Iyɨŋba paŋdetni bamorɨ yaŋ yoban opbal Amɨn Tagɨ yaŋ iyɨnjil do yabekgɨt, “Gak Piŋkop da amɨn yabet do yagɨt uŋun, bo nin amɨn kɨnda don apdɨsak do jomjom aneŋ?” ");
INSERT INTO yut_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Amɨn bamot uŋun kɨŋ Yesu altaŋ ɨmɨŋek yaŋ iyɨgɨmal, “Jon Telagɨ Pakbi Sogok Amɨn da yaŋ gayɨk do aŋek nit yabekban abamak, ‘Gak Piŋkop da amɨn yabet do yagɨt uŋun, bo nin amɨn kɨnda don apdɨsak do jomjom aneŋ?’ ” ");
INSERT INTO yut_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Uŋun bɨsapmon gɨn Yesu amɨn sotni mibɨlɨ mibɨlɨ taŋ yomgwit uŋun paŋmɨlɨp aŋek koŋni taŋ yomgwit uŋun yol yomgut. Ae dabɨlni mɨni morapmɨ paban pɨsawit. ");
INSERT INTO yut_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Do gen kobogɨ yaŋ yoyɨgɨt, “Jil kɨŋ abɨsok yo pɨndak nandaŋyo amal uŋun do Jon iyɨnjil. Dabɨlni mɨni amɨn sɨŋtoŋ, ae kandapmɨ alek taŋbi amɨn kosit akwaŋ, ae wuda tebani toŋ amɨn uŋun kɨlek toŋ, ae mɨragɨ mɨni amɨn da gen nandaŋ, ae amɨn kɨmakbi pɨdoŋ, ae yoni mɨni amɨn da Gen Bin Tagɨsi nandaŋ. ");
INSERT INTO yut_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Amɨn kɨnda nak nandaŋek nandaŋ gadatni dɨma wɨtdal kɨsak uŋun amɨn kɨsɨk kɨsɨgɨ toŋ egɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Amɨn bamot Jon da yabekgɨt uŋun tobɨl kɨŋakwal, Yesu da mɨŋat amɨn kabɨ madep Jon do yaŋ yoyɨgɨt, “Ji mɨktɨm amɨni mɨnikon ninaŋ kok do kɨwit? Mɨrɨm da nagal kɨnda aŋwayɨŋ aban kok do kɨwit? ");
INSERT INTO yut_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Dɨma kaŋ, ninaŋ kok do kɨwit? Amɨn kɨnda yɨk ɨmalyo tagɨsi baŋgɨn pagɨt uŋun kok do kɨwit? Dɨma, yɨk ɨmalyo tagɨsi paŋek gɨptɨm dakon yoni tagɨ tagɨ dagɨn taŋ yomaŋ amɨn uŋun kɨla amɨn madep da yutnon gɨn ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mani ji ninaŋ kok do kɨwit? Kombɨ amɨn kɨnda kok do kɨwit? Uŋun bamɨ, nak asisi dayɨsat, Jon da kombɨ amɨn dɨwarɨ yapmaŋ mudosok. ");
INSERT INTO yut_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Uŋun amɨn do Piŋkop da papiakon gen yaŋ mandabi: ‘Nandani, geno yaŋ teŋteŋosak do amɨn kɨnda yabekgo uŋun da mibɨltaŋ gamjak. Aŋek kositgo aŋnoman asak.’ ");
INSERT INTO yut_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nak yaŋsi dayɨsat, amɨn morap mɨktɨmon altoŋ uŋun Jon da yapmaŋ mudosok. Mani amɨn morap Piŋkop da Amɨn Kɨla Asak da kagagwan pɨŋbisi ekwaŋ uŋun da Jon yapmaŋgaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Jon da amɨn gat ae takis tɨmɨt tɨmɨt amɨn gat telagɨ pakbi kɨlɨ soŋ yomgut, do gen uŋun nandaŋek yaŋ yawit, “Piŋkop dakon aŋpak uŋun kɨlegɨsi.” ");
INSERT INTO yut_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mani Parisi amɨn gat ae gen teban mibɨlɨ nandak nandak amɨn gat uŋun Jonon telagɨ pakbi dɨma sowit. Yaŋ aŋek Piŋkop da kosit kɨlegɨ yolɨk do agɨt uŋun manji ɨmgwit.) ");
INSERT INTO yut_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu da saŋbeŋek yaŋ yagɨt, “Ni tɨlak gen kɨnda naŋ dayɨko amɨn abɨsok ekwaŋ uŋun dakon aŋpak do nandaba pɨsosak? Uŋun niaŋen amɨn dɨ da ekwaŋ? ");
INSERT INTO yut_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Uŋun mɨŋat monjɨyo da yaŋ, yumaŋ gwayek tamokon yɨgek notni yoyɨŋ yoyɨŋ aŋek yaŋ yoŋ: ‘Nin kasɨsɨŋ kɨlɨ pɨsomaŋ, mani ji kap ak do dɨma nandayɨŋ. Nin bupmɨ kap yamaŋ, mani ji bupmɨ nandaŋek kunam tat do dɨma nandayɨŋ.’ ” ");
INSERT INTO yut_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yesu da sigɨn yaŋ yagɨt, “Jon Telagɨ Pakbi Sogok Amɨn abɨŋek bret dɨma nagɨt, ae wain dɨma nagɨt. Yaŋ aŋakwan, ‘Koŋni kɨnda taŋ ɨmɨsak’ ji da gen uŋun yawit. ");
INSERT INTO yut_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ae Amɨn Dakon Monji da abɨŋ jap pakbiyo agɨt. Yaŋ aŋakwan kaŋek ji da yaŋ yoŋ, ‘Kabɨt, jap morapmɨ noknok amɨn ae wain morapmɨsi noknok amɨn. Takis tɨmɨt tɨmɨt ae yokwi pakpak amɨn dakon notni.’ ");
INSERT INTO yut_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ji da gen uŋun yoŋ, mani Piŋkop da pi morap agɨt uŋun pɨndagek nandano nandaŋ kokwini tagɨsi gɨn asak.” ");
INSERT INTO yut_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisi amɨn kɨnda da Yesu yutnikon obɨŋ jap nosak do yaŋ ɨban yutnikon obɨŋ jap tamokon yɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Uŋun kokupmon yokwi pakpak mɨŋat kɨnda egɨpgut. Uŋun mɨŋat Yesu Parisi da yutnon yɨgek jap nosok yaŋ amɨn da yaŋba nandaŋek pakbi kɨbaŋɨ tagɨsi kɨnamɨ kɨnda abɨdaŋek yutnon wɨgɨgɨt. Tɨbɨrɨ uŋun tɨpnaŋ wasaŋbi. ");
INSERT INTO yut_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wɨgɨ Yesu da manjikon kandapnikon paŋkɨ agek kunam tagakwan dabɨl pakbini da kandapnikon maŋ guktaŋba busuŋ daŋgwani baŋ ɨkdɨgagɨt. Yaŋ aŋek kandapmɨkon mandaŋ naŋek pakbi kɨbaŋɨ tagɨsi naŋ soŋ ɨmgut. ");
INSERT INTO yut_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yaŋ aŋakwan Parisi amɨn uŋun Yesu yaŋ ɨmgut iyɨ burɨkon da yaŋ nandagɨt, “On amɨn asi kombɨ amɨn kɨnda tam, on mɨŋat kɨsirɨ kwenikon wɨtjɨsak uŋun yokwi pakpak mɨŋat kɨnda yaŋ nandaban.” ");
INSERT INTO yut_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yaŋ nandaŋakwan Yesu da iyɨgɨt, “Saimon, nak gen kɨnda gayɨko.” Yaŋban iyɨgɨt, “Yoyɨŋdet, kɨlɨ nayɨ.” ");
INSERT INTO yut_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yaŋban Yesu da iyɨgɨt, “Amɨn bamorɨ uŋun amɨn kɨndakon gomani toŋ. Kɨnda dakon gomani uŋun moneŋ 500 danari, ae kɨnda dakon gomani uŋun moneŋ 50 danari. ");
INSERT INTO yut_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Uŋun amɨn bamot gomani sopjil dakon moneŋni arɨpmɨ dɨma, do gomani dɨma sopjil do yoyɨgɨt. Gak niaŋ nandɨsal? Yaŋ aban jit amɨn da uŋun amɨn do madepsi galak taŋ ɨmgut?” ");
INSERT INTO yut_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Yaŋban Saimon da iyɨgɨt, “Goman madepni dɨma sopjak do iyɨgɨt amɨn uŋun da, yaŋ nandɨsat.” Yaŋban Yesu da yaŋ iyɨgɨt, “Gak kokwin kɨlegɨsi aŋek yosol.” ");
INSERT INTO yut_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yaŋ yaŋek Yesu da tobɨl mɨŋat uŋun kaŋek Saimon yaŋ iyɨgɨt, “On mɨŋat do koki? Nak yutgokon wɨko kandapno sugokeŋ do pakbi dɨma namɨl. Mani on mɨŋat da dabɨl pakbini naŋ kandapno sugaŋek busuŋ daŋgwani baŋ ɨkdɨgak. ");
INSERT INTO yut_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nak dɨma mandaŋ nal, mani yutgokon si wɨron da wasaŋek mɨŋat on da kandapno mandaŋ nak da sigɨn mandaŋ nosok. ");
INSERT INTO yut_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gak busuŋnokon bɨt nelak dɨma tagal namɨl. Mani mɨŋat on da pakbi kɨbaŋɨ tagɨsi kandapnokon soŋ namɨk. ");
INSERT INTO yut_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Do yaŋ gayɨsat, on mɨŋat dakon dɨwarɨni morapmɨ Piŋkop da yopmaŋ ɨban nak do but dasi galagɨ madepsi nandaŋ namɨsak. Mani dɨwarɨni tagapmɨsok taŋ ɨmaŋ amɨn Piŋkop da dɨwarɨni yopmaŋ ɨmjak kaŋ, uŋun amɨn da nak do galagɨ madep dɨma nandaŋ namjak.” ");
INSERT INTO yut_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yaŋ yaŋek Yesu da mɨŋat uŋun yaŋ iyɨgɨt, “Nak da dɨwarɨgo yopmaŋ gamɨsat.” ");
INSERT INTO yut_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yaŋ iyɨŋban amɨn kabɨ Yesu gat jap naŋek yɨkgwit uŋun iyɨ gɨn yaŋ yawit, “On niaŋen amɨn kɨnda da dɨwarɨ yopyop asak?” ");
INSERT INTO yut_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yaŋ yaŋakwa Yesu da mɨŋat uŋun yaŋ iyɨgɨt, “Nandaŋ gadatgo do aŋek Piŋkop da gak yokwikon naŋ abɨdosok. Butgo yaworɨ taŋakwan kɨki.” ");
INSERT INTO yut_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Uŋun da kwenon Yesu kokup pap ae kokup monɨŋ monɨŋ tawit uŋudon agek Piŋkop da Amɨn Kɨla Asak uŋun dakon Gen Bin Tagɨsi yoyɨŋ teŋteŋagɨt. Yabekbi 12 kabɨ kɨsi agɨpgwit. ");
INSERT INTO yut_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ae mɨŋat dɨwarɨ Yesu da koŋni yol yomgut ae sotni paŋmɨlɨp agɨt uŋun kɨsi Yesu gat agɨpgwit. Kɨnda uŋun Maria. Maria uŋun Makdala kokupmon nani yaŋ iyɨwit. Kalɨp Yesu da koŋni 7 kabɨ yol ɨmgut. ");
INSERT INTO yut_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ae Joana, Susana ae mɨŋat morapmɨ gat kɨsi Yesu gat agɨpgwit. Joana uŋun Kusa dakon mɨŋatni. Kusa uŋun Erot dakon yutni dakon kɨla amɨn kɨnda. Uŋun mɨŋat kabɨ yo kabɨni iyɨ dakon baŋ Yesu gat paŋdetni gat paŋpulugawit. ");
INSERT INTO yut_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Amɨn morapmɨsi kokup morap tawiron da abɨŋ muwukgwit. Abɨŋ muwugakwa Yesu da tɨlak gen kɨnda yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Amɨn kɨnda uŋun jap yetni pigaga paŋkɨ tɨŋtɨŋagɨt. Tɨŋtɨŋaŋakwan jap yet dɨwarɨ kosiron maŋba amɨn da bamaŋakwa mɨnam da abɨŋ si nawit. ");
INSERT INTO yut_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aŋakwa jap yet dɨwarɨ tɨpmɨ toŋ tɨmon mawit. Maŋ kwawit, mani mɨktɨm pakbini mɨni, do kɨbɨdaŋ pasɨlgwit. ");
INSERT INTO yut_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Aŋakwa jap yet dɨwarɨ joŋ kelɨ toŋ tɨmgwan mawit. Uŋun joŋ kelɨ toŋ gat kɨsi kwaŋek wutjɨŋba kɨmak mudawit. ");
INSERT INTO yut_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ae jap yet dɨwarɨ mɨktɨm tagɨsikon maŋ kwawit. Uŋun bamɨ 100 taŋ taŋ awit.” Yesu da tɨlak gen uŋun yaŋ mudaŋek yaŋ yagɨt, “Gen on nandak do galak toŋ amɨn ji pakyaŋsi nandaŋek mibɨlɨ nandaŋ pɨsoni.” ");
INSERT INTO yut_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Paŋdetni da tɨlak gen uŋun yagɨt dakon mibɨlɨ do iyɨwit. ");
INSERT INTO yut_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iyɨŋba yagɨt, “Piŋkop da ji baŋgɨn iyɨ dakon Amɨn Kɨla Agakni uŋun dakon mibɨlɨ pasɨlɨ toŋ uŋun damɨsak. Mani amɨn dɨwarɨ tɨlak gen gɨn nandaŋ. ‘Do dabɨl sɨŋtaŋek kokdaŋ, mani dɨma kaŋ nandaŋyo akdaŋ. Ae gen nandakdaŋ, mani mibɨlɨ dɨma nandaba pɨsokdaŋ.’ ” ");
INSERT INTO yut_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesu da saŋbeŋek paŋdetni baŋgɨn yaŋ yoyɨgɨt, “Tɨlak gen dayɨt dakon mibɨlɨ uŋun yaŋ. Jap yet uŋun Piŋkop dakon gen. ");
INSERT INTO yut_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jap yet kosiron mawit, uŋun amɨn Piŋkop gen nandaŋ dakon tɨlak. Amɨn nandaŋ gadat aba Piŋkop da yokwikon baŋ tɨmɨtjak yaŋ do Sunduk da abɨŋ butnikon Piŋkop dakon gen gwayesak. ");
INSERT INTO yut_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ae jap yet tɨpmɨ toŋ tɨmon mawit, uŋun amɨn da Piŋkop gen nandaŋ abɨdaŋek kɨsɨk kɨsɨk aŋ dakon tɨlak. Mani gelɨ tagɨ dɨma yɨpban kɨgɨt. Do nandaŋ gadat bɨsap pɨsɨpmɨsok aŋek paŋkewal altaŋ yoba tepmɨsi Piŋkop manji ɨmɨŋ mudoŋ. ");
INSERT INTO yut_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ae jap yet joŋ kelɨ toŋ bɨkbɨkgwan mawit, uŋun amɨn Piŋkop dakon gen nandaŋek kɨŋ mɨktɨmon egɨp egɨpni do nandaba kɨk aŋ uŋun dakon tɨlak asak. Uŋun moneŋ gat ae on mɨktɨm dakon yo morap gat do galagɨ nandaŋakwa uŋun da wutjɨŋ yomɨŋakwa bamɨ dɨma toŋ. ");
INSERT INTO yut_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mani jap yet mɨktɨm tagɨsikon mawit, uŋun amɨn Piŋkop dakon gen nandaŋek tebaisi abɨdoŋ uŋun dakon tɨlak. Uŋun burɨ kɨlegɨsi taŋakwan tebai agek bamɨ tagɨsi paŋalon aŋ.” ");
INSERT INTO yut_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesu da saŋbeŋek yaŋ yagɨt, “Amɨn da lam koleŋ kwoba naŋ dɨma wutjɨŋba toŋ, bo ae dɨpmɨn potpot tamo da mibɨlgwan dɨma yopmaŋgaŋ. Noman tamokon yopmaŋakwa amɨn da yutnon wɨŋek teŋteŋɨ uŋun koŋ. ");
INSERT INTO yut_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yo morap pasɨlɨ toŋ uŋun don nomansi altaŋ mudokdaŋ. Ae yo morap wutjɨŋbi da toŋ uŋun noman taŋ mudaŋakwa amɨn da pɨndak nandaŋyo akdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Ji kaŋ kɨmagek gen pakyaŋsi nandani. Taŋ yomaŋ amɨn uŋun Piŋkop da dɨ gat saŋbeŋ daban tɨmɨtdaŋ. Mani mɨnini amɨn uŋun taŋ namaŋ yaŋ nandɨsak uŋun Piŋkop da gwayekdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Uŋun bɨsapmon meŋi padɨk padɨkyo Yesu kok do opgwit. Mani amɨn morapmɨ, do Yesu da kapmatjok kɨk do aŋtɨdok awit. ");
INSERT INTO yut_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aŋakwa amɨn dɨ da Yesu yaŋ iyɨwit, “Meŋgo padɨk padɨkgoyo yomakon agek gak gandak do yoŋ.” ");
INSERT INTO yut_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yaŋba yoyɨgɨt, “Amɨn Piŋkop dakon gen nandaŋek guramɨkgaŋ uŋun meŋno ae padɨk padɨknoni.” ");
INSERT INTO yut_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Bɨsap kɨndakon Yesu paŋdetni gat bot kɨndakon wɨgek yaŋ yoyɨgɨt, “Pakbi ɨdap terɨ kɨnda do kɨno.” Yaŋ yaŋban kɨwit. ");
INSERT INTO yut_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Boron yɨgek kɨŋakwa Yesu dɨpmɨn pakgɨt. Aŋakwan mɨrɨm madepsi kɨnda pakbi ɨdapmon obɨŋakwan boron pakbi pɨgɨ tugaŋakwa pasɨl do awit. ");
INSERT INTO yut_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Aŋakwa paŋdetni da kɨŋ Yesu aŋyolek iyɨwit, “Amɨn Tagɨ, nin pasɨldamaŋ!” Iyɨŋba pɨdaŋ pakbi gat mɨrɨm gat tebai yoyɨŋban mɨrɨm dɨma aŋakwan pakbi yaworɨsi tagɨt. ");
INSERT INTO yut_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Aŋakwan Yesu da paŋdetni yaŋ yoyɨgɨt, “Nandaŋ gadatji dukon yɨpmaŋ?” Yaŋban paŋdetni si pasalgwit. Aŋek wurɨpdagek notni yoyɨŋ yoyɨŋ aŋek yawit, “On niaŋen amɨn kɨnda da pakbi mɨrɨmyo gen tebai yoyɨŋban geni guramɨkgamal?” ");
INSERT INTO yut_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu gat paŋdetni gat Gerasa mɨktɨm tetgɨn kɨŋ altawit. (Gerasa mɨktɨm uŋun terɨ kɨnda taŋakwan Galili mɨktɨm uŋun pakbi ɨdap terɨ kɨnda tosok.) ");
INSERT INTO yut_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu bot yɨpmaŋek ɨleŋon wɨŋakwan uŋun kokup papmon amɨn kɨnda da abɨŋ altaŋ ɨmgut. Uŋun amɨn koŋni taŋ ɨmgwit. Bɨsap dubagɨsi molaŋ egɨpgut, ae yut kɨndakon dɨma egɨpgut. Amɨn kɨmakba paŋkɨ tɨp kɨnamgwan yopmaŋgaŋ mɨktɨmon gɨn egɨpgut. ");
INSERT INTO yut_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Uŋun amɨn da Yesu kaŋek madepsi yaŋ tɨdaŋek Yesu da kandapmon maŋ pagek gen papmon da yaŋ yagɨt, “Yesu, gak Piŋkop Wɨkwisi dakon Monji, gak ninaŋ aŋnamdɨsal? Bupmɨ nandaŋ nabi. Yo yokwi dɨmasi aŋ nabi!” ");
INSERT INTO yut_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Koŋ da amɨn uŋun yɨpmaŋ detjak do Yesu da kɨlɨ iyɨgɨt, uŋun do madepsi yaŋ tɨdaŋek gen uŋun yagɨt. Uŋun amɨn koŋ da bɨsap morapmɨ aŋupbal awit, do amɨn da bɨsapmɨ bɨsapmɨ kɨlani tebaisi aŋek nap teban tebaisi baŋ kɨsit kandapyoni paŋteban awit. Mani nap teban uŋun paŋdagaŋek koŋ da ɨmɨŋ sugaŋakwan mɨktɨm amɨn dɨma ekwaŋ tɨmon kɨŋ kɨŋ agɨt. ");
INSERT INTO yut_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu da yaŋ iyɨgɨt, “Mango namɨn?” Iyɨŋban koŋni morapmɨ taŋ ɨmgwit, do “Amɨn Kabɨ Madep” yaŋ iyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yesu da bupmɨ nandaŋ yomjak do koŋ da bɨsit tebai yaŋ iyɨwit, “Nin gapma kɨdagɨ mɨni uŋungwan pɨgɨneŋ do dɨma niyɨki.” ");
INSERT INTO yut_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Bɨt kabi madep kɨnda kapmatjok ɨleŋon egek jap naŋek egɨpgwit. Koŋ uŋun bɨt da butgwan pɨgɨk do Yesu bɨsit tebai iyɨŋba nandaŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aŋakwan koŋ amɨn uŋun yɨpmaŋ degek wɨŋ abɨgɨ bɨt da butgwan pɨgɨwit. Pɨgakwa bɨt uŋun tɨmtɨm yaŋek obandom naŋ pɨgɨ pakbi ɨdapgwan pɨgek pakbi naŋ kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aŋakwa bɨt kɨla amɨn yo uŋun pɨndagek tɨmtɨm yaŋek kɨŋ kokup papmon amɨn gat ae kokup terɨ terɨ egɨ aŋaŋ kɨwit uŋun amɨn gat kɨsi yoyɨwit. ");
INSERT INTO yut_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Aŋakwa amɨn da yo niaŋensi kɨnda da altagɨt, uŋun kok do apgwit. Abɨŋ Yesu altaŋ ɨmɨŋek amɨn uŋun koŋni kɨlɨ yɨpmaŋ dekgwit kawit. Kaŋba amɨn uŋun Yesu da buron burɨ kɨlɨ pɨsagɨt ae ɨlɨkba pɨgɨkni toŋ da yɨkgɨt. Yaŋ yɨkban kaŋ pasalgwit. ");
INSERT INTO yut_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aŋakwa yo dabɨl da kaŋ nandaŋyo awit amɨn uŋun da koŋ da aŋupbal abi amɨn niaŋon da kɨlek tagɨt uŋun dakon mibɨlɨ yoyɨwit. ");
INSERT INTO yut_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yoyɨŋba Gerasa mɨktɨm dakon mɨŋat amɨn morap kɨsi pasol pasol madepsi nandaŋek Yesu uŋun yopmaŋ dek kɨsak do iyɨwit. Iyɨŋba boron wɨgek yopmaŋ kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mani amɨn uŋun koŋ da yɨpmaŋ dek kɨwit amɨn da Yesu yol do bɨsit tebai iyɨgɨt. Iyɨŋban Yesu da tobɨl kɨsak do yabegek yaŋ iyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Gak tobɨl yutgokon kɨŋek Piŋkop da gak aŋpulugaŋek yo madepsi ak uŋun do amɨn yoyɨki.” Yaŋ iyɨŋban amɨn uŋun tobɨl kɨŋ kokupni dakon amɨn morap Yesu da aŋpulugaŋek yo morap agɨt uŋun do yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu pakbi ɨdap terɨ kɨnda do kɨŋ altaŋakwan amɨn morapmɨ da but dasi abɨdawit, nido uŋun do jomjom aŋek egɨpgwit. ");
INSERT INTO yut_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Uŋun bɨsapmon amɨn kɨnda apgut, mani Jairus. Uŋun Juda amɨn dakon muwut muwut yut dakon kɨla amɨn kɨnda egɨpgut. Uŋun da Yesu da kandap mibɨlon maŋ pagek yutnikon kɨsakdosi madepsi iyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Uŋun monjɨ mɨni, gwi kaloŋɨ kɨnda gɨn bɨlakni uŋun 12 da tɨlak, uŋun da si kɨmot do agɨt. Yesu yutnikon kɨk do kosiron kɨŋakwan amɨn madepsi, do gɨtni gɨtni aŋakwa kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kɨŋakwan mɨŋat kɨnda uŋungwan agɨpgɨt. Uŋun dagaŋ mok aŋek yawini maŋakwa bɨlak 12 yaŋ agɨt, mani amɨn kɨnda da arɨpmɨ dɨma aŋkɨlek agagɨ. ");
INSERT INTO yut_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Uŋun mɨŋat Yesu da manjikon kapmatjok abɨŋek Yesu dakon ɨmal dubakni da ɨleŋɨkon ɨgayɨgɨt. Aŋakwan uŋudon gɨn yawini pasɨl ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aŋakwan Yesu da yagɨt, “Namɨn da ɨgayɨŋ namɨk?” Yaŋban amɨn morap nin dɨma dɨma yaŋakwa Pita da iyɨgɨt, “Amɨn tagɨ, amɨn morapmɨsi da gak gat gadat gadatsi akwaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mani Yesu da yagɨt, “Amɨn kɨnda da ɨgayɨŋ namɨŋakwan tapmɨmno dɨwarɨ kwan nandat.” ");
INSERT INTO yut_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yaŋban mɨŋat uŋun arɨpmɨ dɨma pasɨlgeŋ yaŋ nandaŋek nɨmnɨmɨk abɨŋ Yesu da kandap mibɨlon maŋ pakgɨt. Maŋ pagek amɨn morap da dabɨlon mibɨlɨ nido Yesu ɨgayɨgɨt uŋun dakon yaŋkwok aŋek yaŋ yagɨt, “Ɨgayɨko sotno uŋudon gɨn pasɨlak.” ");
INSERT INTO yut_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yaŋban Yesu da iyɨgɨt, “Gwano, nandaŋ gadatgo da gak aŋkɨlek ak. Butgo yaworɨ taŋakwan kɨki.” ");
INSERT INTO yut_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu gen uŋun yaŋakwan muwut muwut yut dakon kɨla amɨn Jairus da yutnon da amɨn kɨnda apgut. Abɨŋek Jairus yaŋ iyɨgɨt, “Gwago kɨlɨ kuŋwak, do yoyɨŋdet ɨsal dogɨn dɨma iyɨŋbɨ kɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu uŋun nandaŋek Jairus yaŋ iyɨgɨt, “Dɨma pasolgi. Ɨsal nandaŋ gadat gɨn aŋaki gwago kɨlek tosak.” ");
INSERT INTO yut_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yaŋ yaŋek yutnikon kɨŋ altaŋek amɨn dɨwarɨ dɨma wɨgɨni do yoyɨŋek Pita, Jon, ae Jems gat, ae mɨŋatjok dakon meŋi datniyo gat tɨmɨkban yutnon wɨgɨwit. ");
INSERT INTO yut_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Uŋun yutnon amɨn morapmɨ da mɨŋatjok do bupmɨ nandaŋek kunam tagek iyoŋ iyoŋ yaŋek egɨpgwit. Aŋakwa Yesu da yoyɨgɨt, “Ji kunam yopgut. Dɨma kuŋwak, ɨsal dɨpmɨn pokdok.” ");
INSERT INTO yut_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yaŋban mɨŋatjok wagɨl kuŋwak yaŋ nandaŋek jɨkgo yanjaŋ ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mani Yesu da mɨŋatjok kɨsirɨkon abɨdaŋek gen papmon da yagɨt, “Gwano, pɨda!” ");
INSERT INTO yut_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yaŋ yaŋban mɨŋatjok uŋun dakon wupmɨ aeni tobɨl abɨŋ pɨgakwan uŋudon gɨn pɨdagɨt. Pɨdaŋakwan Yesu da jap dɨ ɨba nosak do yoyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Aban meŋi datni da uŋun kaŋek tamtam yagɨmal. Mani Yesu da tebai yoyɨgɨt, “Jil on yo noman taŋban komal uŋun do amɨn dɨmasi yoyɨnjil.” ");
INSERT INTO yut_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu da yabekbini 12 kabɨ yaŋ yoban obɨŋ muwukba sot amɨn paŋmɨlɨp agak, ae koŋ kɨsisi yolni dakon pi ani do yaŋ mudaŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yomɨŋek Piŋkop da Amɨnon Kɨla Asak dakon gen yaŋ teŋteŋoni, ae sot amɨnyo paŋmɨlɨp ani yaŋ do yabekgɨt. ");
INSERT INTO yut_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aŋek yaŋ yoyɨgɨt, “Ji kosit agɨp do yo dɨ dɨma tɨmɨtni. Wɨn kɨrɨŋ, ae yɨk, ae bret, ae moneŋ, ae paba pɨgɨk bamorɨ dɨma tɨmɨtni. ");
INSERT INTO yut_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yut kɨndakon wugɨni kaŋ, uŋudon gɨn egek kokup uŋun yɨpmaŋ kɨni. ");
INSERT INTO yut_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kwa amɨn da ji dɨma tɨmɨkba kaŋ, kokup pap uŋun yɨpmaŋ det do kandapjikon kɨmbabaŋ tegoŋ uŋun tɨdaŋba kɨni. Yaŋ aba amɨn da yokwi aŋapno uŋun do aŋek kwaŋ yaŋ nandani.” ");
INSERT INTO yut_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yaŋ yoyɨŋban kokupmɨ kokupmɨ agek Gen Bin Tagɨsi yoyɨŋ teŋteŋaŋek amɨn dakon sotni paŋmɨlɨp awit. ");
INSERT INTO yut_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gapman dakon kɨla amɨn madep mibɨltogɨ Erot da Yesu dakon gen bini nandagɨt. Dɨ da Yesu kaŋek Jon kɨmoron da aeni pɨdagɨt yaŋ yawit, do Erot but morap agɨt. ");
INSERT INTO yut_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ae dɨ da yawit, “Elaija da noman tak.” Ae dɨ da “Kombɨ amɨn kalɨpsi egɨpgwit uŋun kɨnda da kɨmoron da pɨdak” yaŋ yawit. ");
INSERT INTO yut_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mani Erot da yaŋ yagɨt, “Jon dakon tegɨ kɨlɨ mandaŋ dagagɨm. Mani abɨsok namɨn amɨn kɨnda dasi yo madepsi aŋakwan gen bini nayɨŋba nandɨsat?” Yaŋ yaŋek Yesu kok do pini agɨt. ");
INSERT INTO yut_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yabekbi kabɨ aeni tobɨl Yesukon abɨŋek yo morap awit dakon geni iyɨwit. Iyɨŋba Yesu da tɨmɨkban iyɨ gɨn kokup kɨnda mani Betsaida uŋudon kɨwit. ");
INSERT INTO yut_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Aŋakwa mɨŋat amɨn kabɨ madepsi uŋun Yesu uŋudon kɨsak yaŋ kaŋ nandaŋyo aŋek buŋon yolgwit. Aŋakwa Yesu da tagɨsi nandaŋ yomɨŋek Piŋkop da Amɨnon Kɨla Asak uŋun do yoyɨŋek sot amɨn paŋmɨlɨp agɨt. ");
INSERT INTO yut_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pɨlɨn pɨlɨndo yabekbini 12 kabɨ da obɨŋ Yesu yaŋ iyɨwit, “Kokup amɨni mɨnikon ekwamaŋ, do yoyɨŋbɨ mɨŋat amɨn morapyo kɨŋek kokup monɨŋ monɨŋ ae tɨmɨ dɨgwan kɨŋ jap pakbiyo gat ae dɨpmɨn potpot tamoyo gat wɨsini.” ");
INSERT INTO yut_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mani Yesu da yabekbini yoyɨgɨt, “Dɨsi jap yomgut.” Yoyɨŋban yawit, “Nin japnin morapmɨ dɨma. Bret 5 kabɨ gat ae tap kɨlap bamorɨ gat gɨn. Nin kɨŋ on mɨŋat amɨn morap do jap moneŋ baŋ si yumneŋ do nandɨsal?” ");
INSERT INTO yut_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Wɨli 5 tausen da tɨlak egɨpgwit.) Yaŋba Yesu da paŋdetni yaŋ yoyɨgɨt, “Amɨn 50 50 yaŋ paŋmuwuk yopba yɨk yɨk ani.” ");
INSERT INTO yut_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yaŋ yaŋban paŋdetni da yaŋ gɨn aba amɨn kɨsi yɨk mudawit. ");
INSERT INTO yut_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yɨgakwa Yesu da bret 5 kabɨ gat ae tap kɨlap bamot gat kɨsi tɨmɨk Kwen Kokup sɨŋtaŋek gɨsamɨkgɨt. Aŋek bret gat ae tap kɨlap gat paŋdagaŋek paŋdetni do yomɨŋakwan amɨn do kokwinɨk yomgwit. ");
INSERT INTO yut_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Yoba tɨmɨk amɨn morap kɨsisi arɨpmɨsi naŋakwa jap nawit dakon dɨwarɨ tawit uŋun paŋdetni da sɨmɨlba yɨgɨ 12 yaŋsi tugawit. ");
INSERT INTO yut_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Bɨsap kɨndakon Yesu iyɨ gɨn bɨsit pi agɨt. Uŋun bɨsapmon paŋdetni kɨsi uŋudon egɨpgwit. Egɨ yaŋ yoyɨgɨt, “Amɨn kabɨ madep da nak do namɨn yaŋ yoŋ?” ");
INSERT INTO yut_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yoyɨŋban yaŋ iyɨwit, “Dɨda Jon Telagɨ Pakbi Sogok Amɨn yaŋ yoŋ, ae dɨ da Elaija yaŋ yoŋ, ae dɨ da kombɨ amɨn kalɨpmɨ kɨnda da kɨmoron da pɨdagɨt yaŋ yoŋ.” ");
INSERT INTO yut_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yaŋba yaŋ yoyɨgɨt, “Mani ji dɨsi nak do namɨn yaŋ yoŋ?” Yaŋban Pita da aŋtobɨlek iyɨgɨt, “Gak Kristo, Piŋkop da yabekban apgul.” ");
INSERT INTO yut_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yaŋ yaŋban Yesu da iyɨ Kristo egɨsak uŋun dakon geni amɨn kɨndakon dɨmasi yoni do yaŋsop aŋyomgut. ");
INSERT INTO yut_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Aŋek yaŋ yagɨt, “Amɨn Dakon Monji da egɨ yo yokwi morapmɨ noman taŋ ɨba tepmɨ pakdɨsak. Ae Juda amɨn dakon kɨla amɨn, ae mukwa sogok amɨn dakon amɨn madep kabɨ, ae gen teban yoyɨŋdet amɨn uŋun da manji ɨmɨŋek aŋakba kɨmotdɨsak. Aŋakwa gɨldat kapbɨ aŋakwan pɨdokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yaŋ yaŋek amɨn kɨsi yaŋ yoyɨgɨt, “Amɨn kɨnda nak nol do nandɨsak kaŋ, iyɨ dakon galaktok manji yomɨŋek tɨlak kɨndapni gɨldarɨ gɨldarɨ guramɨgek nak noljak. ");
INSERT INTO yut_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Amɨn kɨnda iyɨ dakon yɨyɨtni tagɨsi tosak do nandaŋek pi madep asak kaŋ, egɨp egɨpni pasɨl ɨmdɨsak. Mani amɨn kɨnda nak do nandaŋek egɨp egɨpni do nandaban yo madep dɨma asak kaŋ, uŋun amɨn egɨp egɨp dagok dagogɨ mɨni abɨdosak. ");
INSERT INTO yut_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Amɨn kɨnda mɨktɨm dakon yo morap paŋek egɨ kɨmotjak bɨsapmon iyɨ pasɨljak kaŋ, uŋun yo morap da arɨpmɨ dɨma aŋpulugokdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Amɨn kɨnda nak do ae nak dakon gen do mayagɨ nandɨsak kaŋ, Amɨn Dakon Monji iyɨ dakon tɨlɨmni gat ae Datni dakon tɨlɨmni gat ae Piŋkop dakon telagɨ aŋelo kabɨ dakon tɨlɨmni gat apjak bɨsapmon uŋun amɨn do mayagɨ yaŋ gɨn nandaŋ ɨmdɨsak. ");
INSERT INTO yut_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nak asisi dayɨsat, ji on akgaŋ kabɨkon da dɨ dɨma kɨmagek Piŋkop dakon Amɨn Kɨla Agakni kokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu uŋun gen yaŋek egɨ gɨldat 8 yaŋ da tɨlak mudaŋakwa Pita, Jon ae Jems gat tɨmɨkban ɨleŋ kɨndakon bɨsit pi ak do wɨgɨwit. ");
INSERT INTO yut_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wɨgek Yesu bɨsit pi aŋakwan tomno dabɨlni kulabɨk aŋek ɨmalni mal dakon teŋteŋɨ yombem agɨt. ");
INSERT INTO yut_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Yaŋ aban kaŋakwa Moses gat Elaija gat tɨlɨmni gat noman tagɨmal. Noman taŋbal Yesu gat gen yaŋ nandat aba pɨndakgwit. Yesu Piŋkop dakon galaktok yolek Jerusalem kokup papmon on mɨktɨm yɨpmaŋ detjak uŋun dakon gen yawit. ");
INSERT INTO yut_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita gat notni bamot gat dɨpmɨn do yokwisi awit. Mani dɨpmɨnon da pɨdaŋ Yesu tɨlɨmni gat ae amɨn bamot gat kɨsi akba pɨndakgwit. ");
INSERT INTO yut_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Amɨn bamot Yesu yɨpmaŋ det do aŋakwal Pita da Yesu yaŋ iyɨgɨt, “Amɨn Tagɨ, nin ɨdon tagɨsi ekwamaŋ. Nin yut kabeŋ kapbɨ aneŋ. Kɨnda gak do, ae kɨnda Moses do, ae kɨnda Elaija do aneŋ.” (Pita gen uŋun naŋ yosot yaŋ uŋun dɨma nandaŋek yum yagɨt.) ");
INSERT INTO yut_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita gen sigɨn yaŋakwan gɨkwem da pɨŋ ɨlɨmɨk yomaŋakwan pasalgwit. ");
INSERT INTO yut_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Gɨkwem kagagwan da gen kɨnda yaŋ altagɨt, “On Monjɨno, pino asak do manjɨgɨm, do ji geni nandani.” ");
INSERT INTO yut_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Yaŋ mudaŋakwan Yesu naŋgɨn kawit. Yo ɨleŋon altaŋba pɨndakgwit uŋun iyɨ dogɨn nandaba tawit. Uŋun bɨsapmon amɨn dɨ dɨma yoyɨwit. ");
INSERT INTO yut_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wɨsa dagok do Yesu gat paŋdetni gat ɨleŋ yɨpmaŋ pɨgakwa amɨn kabɨ madepsi kosiron domdom awit. ");
INSERT INTO yut_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Amɨn madep kabɨgwan da amɨn kɨnda da yaŋ tɨdaŋek aŋpulugosak do yaŋ iyɨgɨt, “Yoyɨŋdet, monjɨno kaloŋɨ kɨndagɨn. Do kɨŋ koki do nandɨsat. ");
INSERT INTO yut_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Bɨsap morapmɨ koŋ kɨnda da burɨgwan pɨgakwan uŋudon gɨn madepsi yaŋ tɨdosok. Aŋek tebai aŋupbal aŋakwan nɨmnɨmɨgakwan tarak da gen kaganikon wuŋ tugoŋ. Gɨptɨmɨ obɨsi aŋupbal aŋek bɨsap kaloŋ kaloŋ gɨn yɨpmaŋ dekdak. ");
INSERT INTO yut_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Paŋdetgoni da yol ɨmni do bɨsit tebai yoyɨgɨm, mani aŋtɨdok awit.” ");
INSERT INTO yut_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yaŋ yaŋban Yesu da yagɨt, “Nandaŋ gadatji mɨni amɨn, ji aŋpakji yokwisi. Nak bɨsap niaŋ da ji gat egek jɨgɨsi guramɨk dabeŋ? Monjɨgo ɨdon aŋop.” ");
INSERT INTO yut_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Monjɨ uŋun Yesu da akgɨron obɨŋakwan koŋ da monjɨ uŋun ukwayɨkban mɨktɨmon maŋ pagek nɨmnɨmɨkgɨt. Mani Yesu da koŋ tebaisi iyɨŋek monjɨ uŋun aŋmɨlɨp aban kɨlek taŋban datni do aŋtobɨl ɨmgut. ");
INSERT INTO yut_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yaŋ aban amɨn da Piŋkop dakon tapmɨm madepsi kaŋek tamtam yawit. Amɨn Yesu da yo morap agɨt do nandaba ŋwakŋwarɨsi aŋakwa, Yesu da paŋdetni yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Gen dayɨkdɨsat uŋun pakyaŋsi nandani. Amɨn Dakon Monji amɨn da kɨsiron yɨpdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mani paŋdetni gen uŋun dakon mibɨlɨ pasɨlɨ taŋ yomgut, do dɨma nandaba pɨsagɨt. Ae gen uŋun dakon mibɨlɨ nandak do aŋek iyɨk do si pasalgwit. ");
INSERT INTO yut_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bɨsap kɨndakon Yesu dakon paŋdetni namɨn da mibɨltok amɨnin egɨsak yaŋ do gen emat kɨnda awit. ");
INSERT INTO yut_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Aŋakwa Yesu da paŋdetni dakon but pɨndak nandaŋyo aŋek amɨn monɨŋ kɨnda iyɨ akgɨron aŋobɨŋ yɨpban akgɨt. ");
INSERT INTO yut_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Yɨpban agakwan paŋdetni yaŋ yoyɨgɨt, “Amɨn kɨnda nak do nandaŋek on amɨn monɨŋ but dasi abɨdosok, uŋun nak naŋ but dasi abɨdosok. Ae amɨn kɨnda nak but dasi abɨdosok, uŋun Dat nak yabekban pɨgɨm uŋun naŋ but dasi abɨdosok. Ji kabɨkon kɨnda da pɨŋbisi egɨ damjak kaŋ, uŋun da mibɨltok amɨnji asak.” ");
INSERT INTO yut_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon Yesu da gen yagɨt nandaŋek yaŋ yagɨt, “Amɨn Tagɨ, nin kaŋapno amɨn kɨnda da gak da manon koŋ yolban kamaŋ. Mani nin da kabɨkon nani kɨnda dɨma, do yaŋsop aŋɨmɨmaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mani Yesu da iyɨgɨt, “Yaŋsop dɨma aŋɨmni. Amɨn kɨnda uwal dɨma aŋdamjak kaŋ uŋun notji.” ");
INSERT INTO yut_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Piŋkop da Yesu abɨdaŋ aŋaŋ Kwen Kokup wɨgɨsak dakon bɨsap kwaŋ tagɨt. Aŋakwan Yesu uŋun Jerusalem kɨkeŋ yaŋsi nandaban teban tagɨt. ");
INSERT INTO yut_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aŋek amɨn dɨ yabekban uŋun da kalɨp mibɨltaŋ Samaria dakon kokup kɨndakon yut tamoyo paŋnoman ani do kɨwit. ");
INSERT INTO yut_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mani Yesu Jerusalem kɨkdɨsak yaŋ nandawit, do uŋun kokupmon amɨn da Yesu abɨdok do dɨma galak tawit. ");
INSERT INTO yut_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jems gat Jon gat da uŋun pɨndagek Yesu yaŋ iyɨgɨmal, “Amɨn Tagɨ, nit da yondo Kwen Kokup kɨndap da pɨŋ soŋba mɨni ani do tagɨ nandɨsal?” ");
INSERT INTO yut_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yaŋbal Yesu da tobɨl tebaisi yaŋ yoyɨgɨt, “Dɨma yogogɨsi yomal!” ");
INSERT INTO yut_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yaŋ yoyɨŋban ae kokup ŋwakŋwarɨ kɨndakon kɨwit. ");
INSERT INTO yut_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kosiron kɨŋakwa amɨn kɨnda da iyɨgɨt, “Dukwan dukwan agɨpbi uŋun nak gol awɨlgeŋ gɨn.” ");
INSERT INTO yut_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yaŋban Yesu da iyɨgɨt, “Joŋ pɨŋan uŋun mɨktɨmgwan yutni toŋ. Ae mɨnam kwen akwaŋ uŋun yutni toŋ. Mani Amɨn Dakon Monji uŋun dɨpmɨn potpot tamoni mɨni.” ");
INSERT INTO yut_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yaŋ iyɨŋek ae amɨn kɨnda yaŋ iyɨgɨt, “Abɨŋ nak nol.” Mani amɨn uŋun da yaŋ iyɨgɨt, “Amɨn Tagɨ, nandaŋ namɨŋaki kɨŋ datno wayɨk yɨpmaŋek don abɨŋ golbeŋ.” ");
INSERT INTO yut_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yaŋ yaŋban Yesu da iyɨgɨt, “Amɨn kɨmakbi da kɨmakbi notni iyɨ tagɨ wayɨtni. Mani gak kɨŋ Piŋkop da Amɨnon Kɨla Asak uŋun dakon gen yaŋ teŋteŋoki.” ");
INSERT INTO yut_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yaŋ yaŋban ae amɨn kɨnda da Yesu yaŋ iyɨgɨt, “Amɨn Tagɨ, gol do nandɨsat, mani nandaŋ namɨŋaki kɨŋ gwakno galok gen yoyɨŋek don abɨŋ golgeŋ.” ");
INSERT INTO yut_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yaŋban iyɨgɨt, “Sapa naŋ mɨktɨm pudaŋek dambɨ da manjigwan wusɨsak uŋuden amɨn da Piŋkop da Amɨn Kɨla Asak da kagagwan arɨpmɨ dɨma egɨpmɨ.” ");
INSERT INTO yut_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Egɨ Amɨn Tagɨ da paŋdet 72 gat manjɨgɨt. Aŋek iyɨ kokup dukwan dukwan kɨk do agɨt, uŋudon mibɨltok uŋun da kalɨp kɨni do bamot bamot yabekgɨt. ");
INSERT INTO yut_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Aŋek yaŋ yoyɨgɨt, “Pigaga jap bamɨ madepsi taŋ pektaŋ, mani pi monjɨ bamɨ pakpak amɨn morapmɨ dɨma. Uŋun do ji bamɨ pakpak dakon Amɨn Tagɨ bɨsit iyɨŋba pi amɨn paŋalon aŋ yopban pinikon kɨni. ");
INSERT INTO yut_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Ji kɨŋek yaŋ nandani: Ji sipsip monɨŋ baŋ yaŋ joŋ pɨŋan da bɨkbɨgon yabekdat. ");
INSERT INTO yut_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Moneŋ sɨmɨl kɨnam, ae yɨk, ae kandap gwɨl dɨma tɨmɨgek kɨni. Aŋek kosiron amɨn pɨndak ‘Gɨldat tagɨ!’ yaŋ dɨma yoyɨni. ");
INSERT INTO yut_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yut kɨndakon wɨgek mibɨltok yaŋ yoyɨni, ‘On yut amɨn butji yaworɨ tosak.’ ");
INSERT INTO yut_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Yut uŋudon but yawot amɨn kɨnda ekwan kaŋ, but yawot genji dakon bamɨ uŋudon tosak. Mɨnini da egɨpjak kaŋ, but yawotji dakon bamɨ jikon aeni tobɨljak. ");
INSERT INTO yut_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yut wɨgɨni uŋudon gɨn yɨk egɨyo aŋakwa jap daba noni. Pi agak amɨn uŋun tomni tagɨ tɨmɨkgaŋ. Ji yurɨ yurɨ dɨma agɨpni. ");
INSERT INTO yut_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Kokup kɨndakon kɨŋakwa not aŋ damɨŋek jap daba kaŋ uŋun si noni. ");
INSERT INTO yut_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Aŋek amɨn sotni toŋ paŋmɨlɨp aŋek yaŋ yoyɨni, ‘Piŋkop da Amɨn Kɨla Agakni ji da kapmatjok kɨlɨ abɨk.’ ");
INSERT INTO yut_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kokup kɨndakon kɨŋakwa not dɨma aŋ daba kaŋ, uŋun kokup dakon kosit madepmon agek yaŋ yoyɨni, ");
INSERT INTO yut_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kokupji dakon kɨmbabaŋ kandapninon tegoŋ, uŋun tɨdono kɨŋakwa dɨwarɨsi taŋ damaŋ yaŋsi nandani. Aŋek yaŋsi nandani, Piŋkop dakon Amɨn Kɨla Agakni ji da kapmatjok kɨlɨ abɨk.’ ");
INSERT INTO yut_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yaŋsi dayɨsat, gen kokwin bɨsap madepmon Sodom kokup amɨn da kobogɨ do jɨgɨ tagapmɨ pakdaŋ. Mani kokup uŋuden amɨn kobogɨ do jɨgɨ madepsi pakdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesu da saŋbeŋek yaŋ yagɨt, “Korasin ae Betsaida kokupmon amɨn, awa! Nak wasok tapmɨmɨ toŋ abo pɨndagek ji but tobɨl dɨma awit. Tair ae Saidon kokupmon amɨn da pɨndakgwit tam, but tobɨl bamɨsi abam. Aŋek bupmɨ dakon yɨk ɨmalyo paŋek abɨlagon yɨkbam. ");
INSERT INTO yut_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mani gen kokwin bɨsap madepmon Tair gat Saidon kokupmon amɨn gat da kobogɨ do jɨgɨ tagapmɨ paŋakwa ji da kobogɨ do jɨgɨ madepsi pakdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aŋakwa Kapaneam kokupmon amɨn, ason Kwen Kokup nin da wɨgɨkdamaŋ yaŋ nandaŋ, ma? Uŋun arɨpmɨ dɨmasi. Ji mibɨlɨgwan Tɨpdomon pɨgɨkdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu da paŋdetni saŋbeŋek yaŋ yoyɨgɨt, “Ji dakon gen nandɨsak amɨn, uŋun da nak dakon gen nandɨsak. Ae manji damɨsak amɨn, uŋun nak naŋ manji namɨsak. Ae nak manji namɨsak amɨn, uŋun da nak yabekgɨt amɨn manji ɨmɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Paŋdet 72 uŋun kɨsɨk kɨsɨgon da tobɨl abɨŋek Yesu yaŋ iyɨwit, “Amɨn Tagɨ, gak dakon man yaŋapno koŋ da genin guramɨkgaŋ!” ");
INSERT INTO yut_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yaŋ yaŋba yoyɨgɨt, “Sunduk uŋun Kwen Kokup da mal da yaŋ maŋban kagɨm. ");
INSERT INTO yut_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nandani. Nak ji da tuŋon amɨn emarɨ toŋ gat ae skopion gat bamoni, ae uwal dakon tapmɨm kɨsisi pabɨŋ yopni do yaŋ mudaŋ damɨsat. Yo kɨnda da ji arɨpmɨ dɨma paŋupbal asak. ");
INSERT INTO yut_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mani koŋ da genji guramɨkgaŋ, uŋun do kɨsɨk kɨsɨk dɨma ani. Ji dakon man Kwen Kokupmon mandabi da toŋ, uŋun do nandaŋek kɨsɨk kɨsɨk ani.” ");
INSERT INTO yut_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Uŋun bɨsapmon Yesu Telagɨ Wup da kɨsɨk kɨsɨk ɨban yaŋ yagɨt, “Dat, kundu ae mɨktɨm dakon Amɨn Tagɨ, amɨn dɨwarɨ mɨktɨm dakon nandak nandakni uŋun wukwisi, mani iyɨ do nandaba wɨgɨsak, do uŋuden amɨn do gen bamɨ morap si paŋkɨsɨbɨsal. Aŋek amɨn monɨŋɨ da tɨlagon ekwaŋ amɨn, uŋun do yolɨsal. Yaŋ asal do gak aŋkɨsisat. O Dat, gaga dakon galaktok yolek yaŋ asal. ");
INSERT INTO yut_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Datno da yo morap kɨlɨ namgut. Dat uŋun dagɨn Monjɨ nandaŋ ɨmɨsak. Aŋek Monjɨ gat ae amɨn morap Monjɨ da Dat dakon mibɨlɨ yolɨsak, uŋun amɨn dagɨn Datno nandaŋ ɨmaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yaŋ yaŋek Yesu tobɨl paŋdetni baŋgɨn yaŋ yoyɨgɨt, “Ji da yo pɨndak nandaŋyo aŋ, uŋun pɨndakgaŋ amɨn uŋun kɨsɨk kɨsɨk ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nak yaŋsi dayɨsat, kalɨpsigwan kombɨ amɨn morapmɨ gat ae kɨla amɨn madep morapmɨ gat da yo ji da pɨndakgaŋ uŋun pɨndatdosi nandawit, mani dɨma pɨndakgwit. Ae gen nandaŋ uŋun nandakdosi nandawit, mani dɨma nandawit.” ");
INSERT INTO yut_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bɨsap kɨndakon gen teban dakon mibɨlɨ nandak nandak amɨn kɨnda da pɨdaŋ agek Yesu aŋkewal do aŋek yaŋ iyɨgɨt, “Yoyɨŋdet, yo ninaŋ aŋek egɨp egɨp dagok dagogɨ mɨni abɨdokeŋ?” ");
INSERT INTO yut_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iyɨŋban Yesu da iyɨgɨt, “Gen teban papiakon gen tosok uŋun manjɨŋek niaŋ kokwinɨkdal?” ");
INSERT INTO yut_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Iyɨŋban yagɨt, “Ji Amɨn Tagɨ Piŋkopji uŋun but gat ae wup gat ae tapmɨmgo gat ae nandak nandakgo gat kɨsi but dasi galak taŋ ɨbi. Ae gaga do but dasi niaŋ galak tosol, uŋudeŋ gɨn amɨn do but dasi galak taŋ yobi.” ");
INSERT INTO yut_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yaŋban Yesu da iyɨgɨt, “Kobogɨ bamɨsi yosol. Yaŋsi aŋek egɨp egɨp abɨdokdɨsal.” ");
INSERT INTO yut_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mani uŋun amɨn iyɨ do Yesu da amɨn kɨlegɨ kɨnda yaŋ kosak do nandaŋek yaŋ iyɨgɨt, “Nak namɨn amɨn baŋ but dasi galak taŋ yobeŋ do yosol?” ");
INSERT INTO yut_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yaŋ yaŋban Yesu da iyɨgɨt, “Amɨn kɨnda Jerusalem yɨpmaŋek Jeriko kokup papmon kɨk do aŋek kosiron pɨgɨgɨt. Pɨgakwan kabo noknok da abɨdaŋ yɨk ɨmalni gwayeŋek aŋakba palɨ kɨmakban yɨpmaŋ kɨwit. ");
INSERT INTO yut_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Kɨŋakwa mukwa sogok amɨn kɨnda uŋun kosit naŋgɨn pɨgɨgɨt. Pɨgɨ amɨn uŋun kaŋek aŋpekwolek kosit ɨleŋ naŋ yapmaŋ kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yapmaŋ kɨŋakwan Liwai amɨn kɨnda obɨŋ kaŋek yaŋ gɨn aŋpekwolek yapmaŋ kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Mani Samaria amɨn kɨnda da uŋun kositnaŋ obɨŋ amɨn uŋun kaŋek bupmɨ nandaŋ ɨmgut. ");
INSERT INTO yut_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Bupmɨ nandaŋ ɨmɨŋek gɨptɨmɨ aŋak aŋupbal awit uŋun wain gat ae bɨt nelak gat baŋ soŋ ɨmɨŋek wamaŋ ɨmgut. Yaŋ aŋek amɨn uŋun kendak aŋenak iyɨ da donkikon yɨpgut. Yɨpmaŋek aŋkɨ amɨn da yumaŋ naŋek pokgoŋ yut kɨndakon yɨpmaŋek kɨlani agɨt. ");
INSERT INTO yut_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Aŋek wɨsa dagok do silwa moneŋ tabɨlɨ bamorɨ uŋun yut pakgɨmal dakon kɨla amɨn do ɨmɨŋek yaŋ iyɨgɨt, ‘Kɨlani aŋaki on moneŋ da arɨpmɨ dɨma aŋakwan naŋ mudok dɨ abi kaŋ, tobɨl abɨŋek don gabeŋ.’ ” ");
INSERT INTO yut_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yaŋ yaŋek Yesu da gen teban dakon nandak nandak amɨn yaŋ iyɨgɨt, “Niaŋ nandɨsal, uŋun amɨn kapbɨ da kabɨkon namɨn da kabo noknok da aŋakgwit amɨn uŋun do but dasi galak taŋ ɨmgut?” ");
INSERT INTO yut_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yaŋban iyɨgɨt, “Bupmɨ nandaŋ ɨmɨŋek aŋpulugagɨt amɨn uŋun da.” Yaŋban Yesu da iyɨgɨt, “Gak kɨŋ aŋpak yaŋ gɨn abi.” ");
INSERT INTO yut_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu gat paŋdetni gat kɨŋek kokup kɨndakon altawit. Uŋun kokupmon mɨŋat kɨnda egɨpgut mani Mata. Uŋun da yaŋban Yesu uŋun yutnikon wɨgɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wɨkwan Mata dakon padɨge mani Maria uŋun Amɨn Tagɨ da kandap mibɨlon yɨgek geni nandagɨt. ");
INSERT INTO yut_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mani Mata uŋun jap dakon oman do nandaba kɨk morapmɨ aŋek obɨŋ Yesu iyɨgɨt, “Amɨn Tagɨ, padɨgɨno nepmak da naga gɨn pi madep asat. Gak uŋun do dɨma nandɨsal? Iyɨŋbɨ obɨŋ nak aŋpulugaŋban.” ");
INSERT INTO yut_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yaŋban Amɨn Tagɨ da Mata yaŋ iyɨgɨt, “Mata, gak yo morapmɨ do nandaba kɨk aŋek butgo yokwi tosok. ");
INSERT INTO yut_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mani gak yo kaloŋɨ kɨnda dogɨn nandaki kaŋ tagɨ. Maria uŋun dogɨn nandɨsak, do tagɨ dɨma kɨrɨŋɨk ɨbeŋ.” ");
INSERT INTO yut_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Bɨsap kɨndakon Yesu uŋun bɨsit pi aŋek egɨpgut. Bɨsit aban mudaŋakwan paŋdetni kɨnda da yaŋ iyɨgɨt, “Amɨn Tagɨ, Jon da paŋdetni bɨsit agak do yoyɨŋ dekgɨt, yaŋ gɨn niyɨŋ dekgi.” ");
INSERT INTO yut_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yaŋban Yesu da yoyɨgɨt, “Bɨsit ani bɨsapmon yaŋ yoni: ‘Dat, gak dakon man telagɨ tosak. Amɨn Kɨla Agakgo yɨpbɨ ninon apjak. ");
INSERT INTO yut_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gɨldarɨ gɨldarɨ jap arɨpninon nibi. ");
INSERT INTO yut_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nin yokwi aŋnimaŋ amɨn dakon dɨwarɨni yopmaŋ yomamaŋ, do gak yaŋ gɨn nin dakon dɨwarɨnin yopmaŋ nibi. Paŋkewalon dɨma nipbi.’ ” ");
INSERT INTO yut_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yaŋ yaŋek yoyɨgɨt, “Jikon da kɨnda da kalbi binap notni da yutnon kɨŋ yaŋ iyɨsak, ‘Not, bret tɨmɨ kapbɨ nabɨ tamoni don gabeŋ. ");
INSERT INTO yut_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Notno kɨnda kosit dubagɨkon da abɨk da yutnokon ɨsal yɨkdak. Japno mɨni.’ ");
INSERT INTO yut_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Yaŋban notni yutgwan da gen kobogɨ yaŋ iyɨsak, ‘Jɨgɨ dɨma nabi. Pɨdaŋek arɨpmɨ dɨma gabeŋ. Yoma beŋgan kɨlɨ at, ae gwakno gat kɨlɨ pak mudamaŋ.’ ");
INSERT INTO yut_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nak yaŋ dayɨsat, amɨn uŋun notni da bɨsit iyɨk uŋun do dɨma ɨmɨsak. Mani saŋbek saŋbek yaŋakwan uŋun do kurak taŋek yo nido wadaŋek yosok uŋun kɨsi ɨmɨsak. ");
INSERT INTO yut_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Yaŋdo, nak yaŋ dayɨsat: Ji Piŋkop bɨsit iyɨŋba tagɨ damdɨsak, ae wɨsɨŋek bamɨ kokdaŋ, ae yoma domon tɨdaŋba wɨtdal damdɨsak. ");
INSERT INTO yut_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Amɨn morap Piŋkop bɨsit iyaŋ uŋun yo tɨmɨkgaŋ, ae yo wɨsaŋ amɨn uŋun bamɨ koŋ, ae yoma domon tɨdoŋ amɨn uŋun wɨtdal yomɨsak. ");
INSERT INTO yut_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Dat kabɨ, ji kabɨkon da monjɨsi kɨnda da tap kɨlap do dayɨŋban tuŋon amɨn emarɨ toŋ kɨnda tagɨ ɨmni? ");
INSERT INTO yut_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bo pup kwap do dayɨŋban skopion kɨnda tagɨ ɨmni? ");
INSERT INTO yut_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ji yokwi pakpak amɨn, mani monjɨsi do yo tagɨ yomaŋ. Do yaŋsi nandani. Ji bɨsit iyɨŋba Datji Kwen Kokup egɨsak uŋun da Telagɨ Wup tagɨ damjak.” ");
INSERT INTO yut_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu da amɨn kɨnda koŋ kɨnda da aŋkadɨm aban gen dɨma yagɨt, uŋun koŋni yol ɨmgut. Yol ɨban amɨn kadɨm uŋun gen yaŋakwan amɨn da kaŋba yo ŋwakŋwarɨsi agɨt. ");
INSERT INTO yut_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mani amɨn dɨ da yaŋ yawit, “Koŋ dakon mibɨltok amɨn Belsebul da tapmɨmon koŋ yoldak.” ");
INSERT INTO yut_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yaŋakwa amɨn dɨwarɨ da Yesu aŋkewal do aŋek iyɨŋba wasok tapmɨmɨ toŋ kɨnda aŋakwan, asi Piŋkop da yabekban pɨgɨt da pini asak yaŋ kok do nandawit. ");
INSERT INTO yut_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mani Yesu da nandak nandakni pɨndak nandaŋyo aŋek yoyɨgɨt, “Mɨktɨm kɨnda dakon amɨn da pudaŋ kɨ kabi bamorɨ aŋek emat wamjil kaŋ, mɨktɨm uŋun yokwi tokdɨsak. Ae amɨn yurɨ kɨnda da pudaŋ kɨŋek emat wamni kaŋ, uŋun amɨn yut tagɨ dɨma egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sunduk dakon amɨn kabɨni da pudaŋ kɨ kabi bamorɨ aŋek emat wamjil kaŋ, niaŋon da Sunduk gat amɨn kabɨni gat tebai atni? Nak da koŋ Belsebul da tapmɨmon yoldat yaŋ yoŋ. ");
INSERT INTO yut_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mani nak Belsebul da aŋpulugaŋban koŋ yoldat kaŋ, dɨsi dakon notji koŋ yolgaŋ uŋun amɨn kabɨ ni tapmɨmon da koŋ yolgaŋ? Uŋun amɨn kabɨ da genji kokwinɨgek gulusuŋ yoŋ yaŋ tagɨ dayɨni. ");
INSERT INTO yut_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mani Piŋkop da iyɨ tapmɨm namɨŋakwan koŋ yoldat kaŋ, Piŋkop dakon Amɨn Kɨla Agakni jikon kɨlɨ abɨk. ");
INSERT INTO yut_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Amɨn tebaisi kɨnda emat agak yo kabɨni tɨmɨgek iyɨ dakon yut kɨlani tebai aŋakwan, yo kabɨni tagɨsi toŋ. ");
INSERT INTO yut_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mani amɨn kɨnda uŋun yut ami dakon tapmɨm yapmaŋdak amɨn kɨnda da abɨsak. Abɨŋ aŋagek emat agak yo kabɨni tɨmɨgek tapmɨm pagɨt uŋun gwayesak. Yaŋ aŋek yo morapni kabo naŋek kokwinɨk notni do yomɨsak. ");
INSERT INTO yut_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Amɨn nak dakon notno dɨma, uŋun da nak uwal aŋnamaŋ. Ae amɨn nak dɨma aŋpulugaŋban amɨn paŋmuwukgamaŋ, uŋun amɨn da amɨn paŋwaseŋban waseŋ kwaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesu da saŋbeŋek yaŋ yagɨt, “Koŋ kɨnda da amɨn kɨnda yɨpmaŋ degek kɨŋ mɨktɨm kɨbɨrɨ tɨmon agek yɨk yawot tamo wɨsisak. Mani tamo kɨnda dɨma kosok, do yaŋ yosok, ‘Nak aeno tobɨl yut kalɨp egɨpgumon kɨkeŋ.’ ");
INSERT INTO yut_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yaŋ yaŋek kɨŋ kaŋban sɨbɨt sɨbɨt wɨrɨrɨgek yo morap paŋkosit abi pɨndakdak. ");
INSERT INTO yut_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Yaŋ kosok, do kɨŋ koŋ 7 kabɨ iyɨ yapmaŋek wagɨl yokwisi gat tɨmɨkban kwa uŋun yutnon egek aŋpak yokwisi aŋ. Mibɨltok uŋun amɨn yokwi egɨpgut, mani abɨsok uŋun yapmaŋek wagɨl yokwisi egɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu gen uŋun yaŋakwan mɨŋat amɨn kabɨ madep kabɨgwan da mɨŋat kɨnda da pɨdaŋ yaŋ iyɨgɨt, “Meŋgo si aŋalaŋek mum gaban nagɨl uŋun dasi kɨsɨk kɨsɨk tagɨ asak!” ");
INSERT INTO yut_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yaŋban Yesu da yagɨt, “Mani uŋun yapmaŋek amɨn Piŋkop dakon gen nandaŋek guramɨkgaŋ amɨn uŋun da kɨsɨk kɨsɨk ekwaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Amɨn morapmɨsi da Yesukon sigɨn obɨŋ muwugakwa Yesu da yoyɨgɨt, “Amɨn on bɨsapmon ekwaŋ uŋun amɨn yokwisi gɨn. Piŋkop dakon pi naŋ asat yaŋ nandak do wasok tapmɨmɨ toŋ kɨnda kok do yoŋ. Mani kɨnda dɨma kokdaŋ. Jona dakon tɨlak naŋgɨn kokdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kalɨpsigwan Piŋkop da kombɨ amɨn Jonakon tɨlak aban Niniwe kokup pap amɨn da asi Piŋkopmon da abɨk da asak yaŋ kawit. Uŋudeŋ gɨn yo Amɨn Dakon Monjikon noman taŋ ɨba apmiap amɨn da kaŋek asi Piŋkop da yabekban abɨk yaŋ kokdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Mɨktɨm saut tetgɨn dakon kɨla amɨn mɨŋat madep uŋun Solomon dakon nandaŋ kokwini tagɨsi iyɨŋakwan nandak do mɨktɨm dubagɨsikon da apgut. Mani amɨn kɨnda oni egɨsak, uŋun da Solomon yapmaŋdak, mani geni dɨma nandaŋ. Do gen kokwin bɨsap madepmon uŋun kɨla amɨn mɨŋat madep da pɨdaŋ agek abɨsok ekwaŋ amɨn kabɨ dakon aŋpak yokwi uŋun do yaŋ teŋteŋokdɨsak. ");
INSERT INTO yut_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niniwe amɨn Jona da Piŋkop dakon gen yoyɨŋban but tobɨl awit. Mani ji da binapmon amɨn kɨnda egɨsak uŋun da Jona yapmaŋ mudosok, mani ji but tobɨl dɨma aŋ. Do gen kokwin bɨsap madepmon Niniwe amɨn da pɨdaŋ agek abɨsok ekwaŋ amɨn kabɨ dakon aŋpak yokwi uŋun do yaŋ teŋteŋokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesu da sigɨn yagɨt, “Amɨn da lam koleŋ pasɨlɨgwan yopba dɨma toŋ. Bo ae kwoba baŋ wutjɨba dɨma toŋ. Noman tamokon yopba taŋ teŋteŋaŋakwan amɨn da wɨŋ teŋteŋɨ koŋ. ");
INSERT INTO yut_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Dabɨlgo uŋun gɨptɨmgo dakon teŋteŋɨ. Dabɨlgo tagɨsi kaŋ, gɨptɨmgo kaloŋ teŋteŋɨni toŋ. Mani dabɨlgo yokwi kaŋ, gɨptɨmgo pɨlɨn tuksi tosok. ");
INSERT INTO yut_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yaŋdo, gɨptɨmgo dakon teŋteŋɨ uŋun pɨlɨn tuk asak yaŋ do kaŋ kɨmokgi. ");
INSERT INTO yut_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Gɨptɨmgo kaloŋ teŋteŋɨni toŋ ae pɨlɨn tuk kɨnda dɨma tosak kaŋ, gɨptɨmgo lam dakon teŋteŋɨ dakon paŋop pɨndakdal uŋudeŋ teŋteŋokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu gen yaŋ mudaŋakwan Parisi amɨn kɨnda da yutnikon kwan yɨgek jap nonjil do iyɨgɨt. Iyɨŋban Yesu kɨŋ yutnikon wɨgɨ jap noknok tamokon yɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yɨgek mibɨltok kɨsirɨ dɨma sugaŋek jap naŋban Parisi amɨn uŋun da kaŋek dɨma agagɨ asak yaŋ nandagɨt. ");
INSERT INTO yut_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aban Amɨn Tagɨ da yaŋ iyɨgɨt, “Parisi amɨn ji kap ɨdapyo dakon manji baŋgɨn sugoŋ. Mani kabo gat ae aŋpak yokwi mibɨlɨ mibɨlɨ gat uŋun butjigwan tugawit da toŋ. ");
INSERT INTO yut_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ji nandaŋ kokwinji tagɨ mɨni! Piŋkop da manji baŋ gɨn dɨma, burɨ gat kɨsi wasagɨt. ");
INSERT INTO yut_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ji bupmɨ amɨn do but dasi galak taŋek paŋpulugoni kaŋ, ji amɨn kɨlegɨsi. ");
INSERT INTO yut_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mani Parisi amɨn, awa! Ji jap tam galagɨsi pi kagasi toŋ uŋun paŋ kabi 10 kabɨ yopmaŋek uŋun kabɨkon baŋ kabi kɨndanaŋ Piŋkop do paret aŋ. Mani gen kokwin kɨlegɨ agak gat, ae Piŋkop do but dasi galak taŋ ɨmɨm uŋun ji dɨma aŋ. Aŋpak kɨlegɨ uŋun gat ae paretyo kɨsi ani kaŋ tagɨsi. ");
INSERT INTO yut_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Parisi amɨn, awa! Ji muwut muwut yut madepmon tamo mibɨltogɨ uŋudon yɨt do galagɨ nandaŋ. Ae amɨn da maket tamokon nandaba wukwan damɨŋek gɨldat tagɨ yaŋ dayɨni do galagɨ nandaŋ. ");
INSERT INTO yut_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Parisi amɨn, awa! Ji amɨn kɨmakbi yopyop tamo mɨktɨmgwan taŋakwa amɨn da dɨma pɨndagek kwenikon bamaŋ akwaŋ ji uŋun yombem.” ");
INSERT INTO yut_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Gen teban mibɨlɨ nandak nandak amɨn kɨnda da gen uŋun yaŋban nandaŋek Yesu yaŋ iyɨgɨt, “Yoyɨŋdet, Parisi amɨn do gen uŋun yaŋek, ninyo kɨsi pabɨŋ nipmaŋdal.” ");
INSERT INTO yut_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yaŋban Yesu da yagɨt, “Gen teban mibɨlɨ nandak nandak amɨn jiyo kɨsi, awa! Ji amɨn gen teban mibɨlɨ mibɨlɨ jɨgɨsi guramɨtni do yoyaŋ, mani kɨsitjok kɨnda yomɨŋek paŋpulugaŋek guramɨt do dɨmasi nandaŋ. ");
INSERT INTO yut_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Awa! Ji kombɨ amɨn dakon bumjot tamo wasoŋ. Mani babɨkji da dapba kɨmakgwit. ");
INSERT INTO yut_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Babɨkji da kombɨ amɨn dapba kɨmakgwit uŋun dakon bumjot tamoni ji da paŋtɨlɨm aŋ. Yaŋ aŋ uŋun babɨknin da tagɨsi dapba kɨmakgwit yaŋ nandaŋ dakon tɨlak asak. ");
INSERT INTO yut_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Uŋun do aŋek Piŋkop da nandaŋ kokwini tagɨsikon da yaŋ yagɨt, ‘Nak da kombɨ amɨno gat ae yabekbi kabɨno gat uŋun amɨn kabɨkon yabetdɨsat. Yabekgo dɨwarɨ dapba kɨmotdaŋ, ae dɨwarɨ yo yokwisi aŋyomdaŋ.’ ");
INSERT INTO yut_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yaŋ do aŋek Piŋkop da mɨktɨm wasagɨron da kombɨ amɨn morap dapba kɨmakgwit uŋun dakon kobogɨ amɨn abɨsok ekwaŋ uŋun da tɨmɨtdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Wasok wasok do amɨn kɨlegɨ Abel aŋagek ae amɨn dɨwarɨ dapmaŋakwa wɨgɨ wasɨp do Sekaraia Telagɨ Yut Madep ae altayo da binapmon aŋakba kɨmakgɨt uŋun dakon kobogɨ yo jɨgɨsi amɨn abɨsok ekwaŋ uŋun da tɨmɨtdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Gen teban mibɨlɨ nandak nandak amɨn, awa! Nandak nandak pakpak tamo dakon yoma wɨtdal dɨsi kɨlɨ gwayewit. Dɨsi uŋungwan dɨma wɨgɨwit. Aŋek uŋungwan wɨgɨk do awit amɨn ji da kosit sopsop aŋyomgwit.” ");
INSERT INTO yut_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu uŋun yut egɨpgut yɨpmaŋ degakwan gen teban yoyɨŋdet amɨn gat ae Parisi amɨn gat da Yesu do uwal aŋ ɨmɨŋek gen mibɨlɨ mibɨlɨ iyɨwit. ");
INSERT INTO yut_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Aŋkewalno suŋ kɨnda yaŋakwan gen pikon yɨpneŋ yaŋon da iyɨwit. ");
INSERT INTO yut_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Amɨn tausen morapmɨ da abɨŋ muwugek gɨtni gɨtnisi aŋek notni bamaŋ bamaŋ aŋakwa Yesu da mibɨltok paŋdetni baŋ kalɨp yaŋ yoyɨgɨt, “Parisi amɨn dakon yisni do kaŋ kɨmotni. Uŋun jamba but amɨnsi ekwaŋ. ");
INSERT INTO yut_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yo morap gwɨlɨgwan toŋ uŋun altaŋ teŋteŋaŋ mudokdaŋ. Ae yo morap pasɨlɨ toŋ uŋun amɨn da nandaba pɨsokdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Do gen morap ji da pɨlɨn tukgwan yawit uŋun amɨn da teŋteŋɨkon nandakdaŋ. Ae gen morap yut kagagwan gen pɨsɨgon da yawit uŋun yut kwenon wɨgɨ gen papmon da yoyɨŋ teŋteŋokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesu da saŋbeŋek yaŋ yagɨt, “Not kabɨ, yaŋsi dayɨsat. Amɨn da gɨptɨm dapba kɨmagakwa uŋun da kwenon yo dɨ arɨpmɨ dɨma akdaŋ, do uŋun do dɨma pasolni. ");
INSERT INTO yut_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mani namɨn amɨn dosi pasolni uŋun do dayɨkdɨsat. Ji Piŋkop do pasolni. Piŋkop da gɨptɨm dapban kɨmagakwa Tɨpdomon maban pɨgɨni uŋun dakon tapmɨm taŋ ɨmɨsak. Asisi dayɨsat, ji Piŋkop dosi pasolni. ");
INSERT INTO yut_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mɨnam monɨŋ uŋun yo monɨŋɨsok, 5 kabɨ dakon yumaŋ nogɨ uŋun moneŋ gɨman tabɨlɨ bamorɨ gɨn. Mani Piŋkop da mɨnam monɨŋgok uŋun dakon kɨndasok dɨmasi ɨŋtaŋ ɨmgut. ");
INSERT INTO yut_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Piŋkop da busuŋ daŋgwanji niaŋ da toŋ uŋun kɨsisi nandaŋ mudosok, do ji dɨma pasolni. Mɨnam monɨŋ monɨŋ morapmɨ dakon yumaŋ nogɨ uŋun madep dɨma, mani ji dakon yumaŋ nogɨ uŋun wukwisi.” ");
INSERT INTO yut_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesu da saŋbeŋek yaŋ yagɨt, “Nak da yaŋsi dayɨsat, amɨn kɨnda da ‘Nak Yesu dakon amɨn kɨnda’ yaŋ amɨn yoyɨsak kaŋ, Amɨn Dakon Monji da Piŋkop dakon aŋelo kabɨnikon uŋun amɨn nak dakon amɨn kɨnda yaŋ yoyɨsak. ");
INSERT INTO yut_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mani amɨn kɨnda ‘Nak Yesu dakon amɨn dɨma’ yaŋ amɨn yoyɨsak kaŋ, nakyo kɨsi Piŋkop dakon aŋelo kabɨnikon uŋun amɨn nak dakon amɨn dɨma yaŋ yoyɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Amɨn morap Amɨn Dakon Monji do yaŋba yokwi tok ani amɨn uŋun Piŋkop da dɨwarɨni yopmaŋ yomdɨsak, mani amɨn morap Telagɨ Wup do yaŋba yokwi tok ani amɨn uŋun Piŋkop da dɨwarɨni dɨma yopmaŋ yomdɨsak. ");
INSERT INTO yut_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Amɨn da ji Juda amɨn dakon muwut muwut yut madepmon, bo gapmanon, bo ae amɨn mani wukwi da ɨŋamon paŋkɨ depni bɨsapmon, dɨsi kutnok do aŋek ni gen baŋ yoyɨneŋ yaŋ nandaŋek nandaba kɨk dɨma ani. ");
INSERT INTO yut_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Uŋun bɨsapmonsi ni gen baŋ yoyɨni uŋun Telagɨ Wup da dayɨŋ detdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Uŋun amɨn kabɨ madepgwan da amɨn kɨnda da Yesu yaŋ iyɨgɨt, “Yoyɨŋdet, peno iyɨŋbɨ datnit da yo morap yopgut uŋun kokwinɨk dɨwarɨ nak do namjak.” ");
INSERT INTO yut_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yaŋban Yesu da iyɨgɨt, “Not, namɨn da jilon gen kokwin pi aŋek yo kabɨsil kokwinɨk dabeŋ do manjɨŋ nepgut?” ");
INSERT INTO yut_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yaŋ yaŋek mɨŋat amɨnyo yaŋ yoyɨgɨt, “Ji kaŋ kɨmotni. Yo mibɨlɨ mibɨlɨ tɨmɨt tɨmɨt dakon galagɨ dɨ pabam. Yo kabɨsi uŋun morapmɨsi kaŋ, uŋun da egɨp egɨp bamɨsi arɨpmɨ dɨma damdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yaŋ yaŋek tɨlak gen kɨnda yaŋ yoyɨgɨt, “Yoni morapmɨ amɨn kɨnda dakon pigagani jap bamɨ tagɨsi morapmɨ tawit. ");
INSERT INTO yut_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Aŋakwa amɨn uŋun iyɨ yaŋ nandagɨt, ‘Jap bamɨ yopbeŋ dakon tamo kɨlɨ tugaŋ, do ae dɨ gat yopbeŋ dakon tamo arɨpmɨ dɨma, do niaŋsi abeŋ?’ ");
INSERT INTO yut_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yaŋ nandaŋek yagɨt, ‘Nak yaŋsi abeŋ: Jap yopyop yutno kɨsi tuwɨlek madepsi wutjɨŋek wit gat ae yo kabɨno gat kɨsi uŋun yutnon yopbeŋ. ");
INSERT INTO yut_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yaŋ aŋek naga do yaŋsi yokeŋ, “Nak bɨlak morapmɨ tagɨsi egɨ aŋaŋ kɨkeŋ dakon yo morapno arɨpmɨsi. Do yaworɨsi egek jap pakbiyo madepsi aŋek bɨsap morapmɨ kɨsɨk kɨsɨk aŋek egɨpbeŋ.” ’ ");
INSERT INTO yut_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Mani Piŋkop da iyɨgɨt, ‘Gak nandaŋ kokwingo tagɨ mɨni. Gak abɨsok kalbi kɨmotdɨsal. Yo morapgo gaga do paŋkosit agɨl uŋun amɨn da tɨmɨtdaŋ.’ ” ");
INSERT INTO yut_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu da gen uŋun yaŋek yaŋ yagɨt, “Amɨn yoni morapmɨ paŋmuwut do pi aŋegek Piŋkop do dɨma nandaŋek ekwaŋ amɨn, uŋun amɨnon yo yaŋsi altokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yaŋ yaŋek Yesu da paŋdetni yaŋ yoyɨgɨt, “Yaŋsi dayɨsat, egɨp egɨpji do nandaba kɨk aŋek ‘Jap dukon baŋ noneŋ’ bo ae gɨptɨmji do nandaba kɨk aŋek ‘Ɨmal dukon baŋ paneŋ’ yaŋ dɨma nandani. ");
INSERT INTO yut_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Egɨp egɨp da jap yapmaŋdak, ae gɨptɨm da ɨmal yapmaŋdak. ");
INSERT INTO yut_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ji mɨnam do nandani. Jap yet dɨma kwaokgaŋ, ae jap dɨma paŋ, ae jap paŋmuwut yutni mɨni. Mani Piŋkop da jap upmokdok. Mɨnam dakon yumaŋ nogɨ pɨŋbisi aŋakwa amɨn ji dakon yumaŋ nogɨ uŋun madepsi. ");
INSERT INTO yut_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ji nandaba kɨk aŋek egɨp egɨpji tɨmɨsok dɨ gat tagɨ saŋbeŋba wɨgɨsak yaŋ nandaŋ, ma? Uŋun arɨpmɨ dɨmasi. ");
INSERT INTO yut_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yo monɨŋɨsok uŋuden ji da arɨpmɨ dɨmasi agagɨ, do nido yo dɨwarɨ morap do nandaba kɨk aŋ? ");
INSERT INTO yut_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Jareŋ oni taŋ aŋaŋ kwaŋ uŋun do nandani. Pi madep aŋek ɨmal dɨma bupmaŋgaŋ. Mani yaŋ dayɨsat, jareŋ pɨndakgaŋ uŋun dakon tɨlɨmni da kalɨp kɨla amɨn madep Solomon dakon tɨlɨmni tagɨsi pagɨt uŋun yapmaŋdak. ");
INSERT INTO yut_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","On joŋ taŋ aŋaŋ kwaŋ uŋun aŋwa amɨn da baljaŋ kɨndapmon sokdaŋ. Mani Piŋkop da si paŋtɨlɨm asak, do nandaŋ gadatji pɨsɨpmɨsok amɨn ji yaŋsi nandani, Piŋkop da ji do nandaban yo madepsi aŋakwan ɨmal tɨlɨmɨ toŋsi baŋ paŋ damdɨsak. ");
INSERT INTO yut_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","30","Piŋkop dɨma nandaŋ ɨmaŋ amɨn kabɨ da yo morap uŋuden wusɨŋ pɨndat do pini aŋ. Mani Datji da yo uŋun do wadak wadak aŋ uŋun nandɨsak, do ji jap pakbiyo dukon baŋ noneŋ yaŋ nandaŋek nandaba kɨk dɨma ani. ");
INSERT INTO yut_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nandaba kɨkji yɨpmaŋek Piŋkop dakon Amɨn Kɨla Agakni uŋun wɨsɨŋ kok do pi ani. Yaŋ aŋakwa yo dɨwarɨ do wadak wadak aŋ uŋun kɨsi damdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yesu da saŋbeŋek yaŋ yagɨt, “Sipsip kabɨsok, ji dɨma pasolni. Datji da iyɨ Amɨn Kɨla Asak da kagagwan egɨpni do tagɨsi nandɨsak. ");
INSERT INTO yut_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ji yo morapji taŋ damaŋ uŋun yopba amɨn da yumaŋ noni. Yaŋ aba moneŋ tɨmɨgek yoni mɨni amɨn do yomni. Aŋek yo kabɨsi tagɨsi Kwen Kokupmon paŋmuwuk yopba uŋudon tagɨsi tokdaŋ. Uŋun tamokon toni kaŋ, yo kabɨsi dɨma pasɨldaŋ, ae kabo noknok da dɨma tɨmɨtdaŋ, ae yo monɨŋ da dɨma nokdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yo kabɨsi tagɨsi dukwan toŋ, but nandak nandakyosi kɨsi uŋudon gɨn tokdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesu da saŋbeŋek yaŋ yagɨt, “Ji ɨmalji paŋek lamji koleŋek tagap taŋek egɨpni. ");
INSERT INTO yut_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Oman monjɨ da tagap taŋek amɨn tagɨni da mɨŋat pakpak dakon soŋnogon da tobɨl apjak do jomjom aŋek ekwaŋ ji yaŋ gɨn tagap toni. Do ni bɨsapmon abɨŋ yoma domon tɨdosak ji yoma tepmɨ wɨtdal ɨmni. ");
INSERT INTO yut_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Oman monjɨ amɨn tagɨni da pɨndakban tagap taŋek ekwaŋ kaŋ tagɨsi. Nak asisi dayɨsat, amɨn tagɨni da iyɨ oman dakon ɨmal paŋek oman monjɨ yoyɨŋban jap tamokon pabɨŋ yɨgakwa iyɨ jap yomdɨsak. ");
INSERT INTO yut_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Amɨn tagɨ uŋun kalbi binap bo wɨsa dagokdosi abɨŋ pɨndakban tagap taŋek egɨpni kaŋ tagɨsi. ");
INSERT INTO yut_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ji yaŋ nandani. Yut kɨnda dakon ami kalbi kabo noknok ni bɨsapmon apjak yaŋ nandagɨt tam, kɨla aŋakwan arɨpmɨ dɨma tuwɨlban. ");
INSERT INTO yut_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ji kɨsi tagap taŋek egɨpni. Dɨma apjak yaŋ nandaŋakwa Amɨn Dakon Monji uŋudon apdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita da Yesu yaŋ iyɨgɨt, “Amɨn Tagɨ, tɨlak gen yal uŋun nin dogɨn yal, bo ae amɨn kɨsi do yal?” ");
INSERT INTO yut_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yaŋban Amɨn Tagɨ da yagɨt, “Oman monjɨ kɨnda nandaŋ kokwini tagɨsi ae pi agakni tagɨsi, uŋuden oman monjɨ amɨn tagɨni da oman monjɨni dɨwarɨ kɨlani asak do manjɨsak. Yaŋ aban jap yomyom bɨsapmon japni yomɨŋ yomɨŋ asak. ");
INSERT INTO yut_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Oman monjɨ uŋun amɨn tagɨni da tobɨl abɨŋ kaŋban pini tagɨsi asak kaŋ tagɨsi. ");
INSERT INTO yut_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nak asisi dayɨsat, amɨn tagɨni da uŋun oman monjɨ iyɨŋban yo morapni kɨla akdɨsak. ");
INSERT INTO yut_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mani uŋun oman monjɨ burɨkon da amɨn tagɨni tepmɨ dɨma apdɨsak yaŋ nandaŋek oman monjɨ gat ae oman mɨŋat gat dapmaŋek jap pakbiyo madep aŋek pakbi tebanyo kɨsi naŋ but upbal asak kaŋ, ");
INSERT INTO yut_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","dɨma apdɨsak yaŋ nandaŋakwan amɨn tagɨni da but pɨsogɨ mɨni abɨŋ uŋun oman monjɨ tepmɨ pi ɨmɨŋek gen kɨrɨŋɨt amɨn kabɨ gat yopban egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Oman monjɨ kɨnda amɨn tagɨni dakon galaktokni nandaŋek tagap taŋek galaktokni dɨma yoljak kaŋ, amɨn tagɨ da kosirɨ morapmɨ baljokdɨsak. ");
INSERT INTO yut_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mani oman monjɨ kɨnda amɨn tagɨni dakon galaktokni dɨma nandaŋek aŋpak yokwi si baljoni da arɨpmon asak kaŋ, amɨn tagɨni da kosirɨ morapmɨ dɨma baljokdɨsak. Yo morapmɨ tɨmɨkgaŋ amɨn uŋun yo morapmɨ paŋtobɨl yomyomɨ. Yo morapmɨ kɨla ani do dabi amɨn uŋun yo morapmɨ paŋtobɨl yomyomɨ.” ");
INSERT INTO yut_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesu da saŋbeŋek yaŋ yagɨt, “Nak mɨktɨmon kɨndap sokeŋ do pɨgɨm. Kɨlɨsi kwaŋ sok tam tagɨ. ");
INSERT INTO yut_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nak tepmɨ madepsi pakdɨsat. Butno jɨk tosok, do pako dagosak dosi nandɨsat. ");
INSERT INTO yut_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nak amɨn da mɨktɨmon but yawot pani yaŋ do pɨgɨm yaŋ nandaŋ, ma? Uŋun dɨma. Yaŋ dayɨsat, nak mɨktɨm amɨnon pɨdok pɨdok paŋalon ak do pɨgɨm. ");
INSERT INTO yut_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Abɨsok da wasaŋek amɨn yurɨ kɨndakon amɨn 5 kabɨ da pɨdaŋ kɨŋek bamorɨ da kapbɨ gat uwal uwal akdaŋ. Ae kapbɨ da bamorɨ gat uwal uwal akdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Waseŋ kɨŋek dat da monji gat pɨdok pɨdok akdamal, ae meŋ da gwi gat pɨdok pɨdok akdamal, ae mɨŋat kɨnda gat namdi gat pɨdok pɨdok akdamal.” ");
INSERT INTO yut_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Amɨn kabɨ madepsi yaŋ yoyɨgɨt, “Ji gɨldat da si pɨgɨsak tetgɨn do meŋi wamaŋdak yaŋ pɨndagek ‘Sɨkak mokdɨsak’ yaŋ yaŋakwa asi sɨkak mosok. ");
INSERT INTO yut_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ae saut tetgɨn dakon mɨrɨm madep abɨŋakwan ji da yaŋ yoŋ, ‘Gɨldat tepmɨsi wusɨkdɨsak.’ Yaŋ yaŋakwa asi gɨldat tepmɨsi wusɨsak. ");
INSERT INTO yut_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jamba but amɨn, ji da mɨktɨmon ae kwen yo morap toŋ pɨndagek kokwin tagɨsi aŋ. Mani abɨsok yo morap altoŋ uŋun pɨndagek kokwin nido tagɨ dɨma aŋ?” ");
INSERT INTO yut_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yesu da saŋbeŋek yaŋ yagɨt, “Ji dɨsi aŋpak yokwi tagɨyo nido dɨma kokwinɨkgaŋ? ");
INSERT INTO yut_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Amɨn kɨnda da gen yaŋ gam do aban gen kokwin tamokon kɨk do kosiron kɨnjil bɨsapmon genjil uŋun yaŋ aŋmɨlɨp ak do pi anjil. Yaŋ dɨma aŋek kwal gen kokwin kɨla agak amɨn da obip amɨn da kɨsiron gepban uŋun da dam teban yutnon gepdɨsak. ");
INSERT INTO yut_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nak asisi gayɨsat, gak dam tebanon sigɨn egaki wɨgɨ moneŋ niaŋ yopbi do gayɨni uŋun kɨsisi yopmaŋek don waŋga kɨkdɨsal.” ");
INSERT INTO yut_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yesu da gen uŋun yaŋ mudaŋakwan amɨn dɨwarɨ da Pailat da yo agɨt uŋun do iyɨwit. Pailat da obip amɨni yoyɨŋban kɨŋ Galili amɨn dɨwarɨ Piŋkop do mukwa soŋakwa uŋun dapba kɨmakgwit. Do uŋun amɨn dakon yawini gat ae paret do yo mukwa sowit dakon yawini kɨsi mawit. ");
INSERT INTO yut_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Uŋun do iyɨŋba Yesu da yoyɨgɨt, “Niaŋ nandaŋ? Galili amɨn kɨmakgwit uŋun dakon yokwini da Galili amɨn dɨwarɨ dakon yokwini yapgut, uŋun do aŋek jɨgɨ uŋun pawit yaŋ nandaŋ? ");
INSERT INTO yut_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Uŋun dɨmasi! Nak asisi dayɨsat, ji but tobɨl dɨma ani kaŋ, uŋun amɨn kabɨ da kɨmakgwit jiyo kɨsi yaŋ gɨn kɨmotdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bo Silom yut dubak tuwɨl kɨ maŋ amɨn 18 kabɨ wɨtjɨŋban kɨmakgwit do nandani. Uŋun amɨn kabɨ dakon yokwini da Jerusalem amɨn dɨwarɨ dakon yokwini yapgut uŋun do aŋek pasɨlgwit yaŋ nandaŋ? ");
INSERT INTO yut_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Uŋunyo kɨsi dɨmasi! Nak asisi dayɨsat, ji but tobɨl dɨma ani kaŋ, jiyo kɨsi yaŋ gɨn kɨmotdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu da tɨlak gen kɨnda yaŋ yoyɨgɨt, “Amɨn kɨnda da wain pinikon pik kɨndap kɨnda kwaokgɨt. Bɨsap kɨnda bamɨ wɨsɨk do kɨgɨt, mani bamɨ mɨni pɨndakgɨt. ");
INSERT INTO yut_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bamɨ mɨni pɨndagek pi kɨla amɨni yaŋ iyɨgɨt, ‘Nandaki. Nak bɨlak kapbɨ abɨŋ pik kɨndap dakon sopmɨ wɨsɨŋ wɨsɨŋ aŋek mɨni pɨndakdat. Yaŋ do kɨndap on si pasɨki. Mɨktɨm dakon tapmɨm nido ɨsal dogɨn ɨlɨk mudosok?’ ");
INSERT INTO yut_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Yaŋban pi kɨla amɨn da yaŋ iyɨgɨt, ‘Amɨn tagɨ, yum kaŋbɨ bɨlak kɨnda gat atjak. Aŋakwan mibɨlɨkon mɨktɨm wayɨgek yalɨk yopbeŋ. ");
INSERT INTO yut_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bɨlak kwenikon bamɨ tosak kaŋ tagɨsi. Mani bamɨ dɨma tosak kaŋ, tagɨ pasɨki.’ ” ");
INSERT INTO yut_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat bɨsap kɨndakon Yesu da Juda amɨn dakon muwut muwut yut kɨndakon amɨn yoyɨŋ dekgɨt. ");
INSERT INTO yut_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Uŋudon mɨŋat kɨnda egɨpgut. Uŋun koŋ kɨnda da yɨgek abɨdaŋakwan sot aŋakwan bɨlak 18 agɨt. Manji gɨroŋɨkgɨt, do kwen kɨlegɨ arɨpmɨ dɨma akgɨt. ");
INSERT INTO yut_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu da kaŋek iyɨŋban opban yaŋ iyɨgɨt, “Mɨŋat, sotgo kɨlɨ gepmaŋ dek kɨk.” ");
INSERT INTO yut_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yaŋ iyɨŋek kɨsirɨ kwenikon wutjɨŋban uŋudon gɨn manji kɨlek taŋakwa Piŋkop aŋkɨsigɨt. ");
INSERT INTO yut_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mani muwut muwut yut dakon kɨla amɨn da Sabat bɨsapmon Yesu da amɨn aŋmɨlɨp agɨt uŋun do butjap nandagɨt. Butjap nandaŋek mɨŋat amɨnyo yaŋ yoyɨgɨt, “Pi agak dakon gɨldat 6 kabɨ toŋ. Uŋun bɨsapmon sot amɨn apba tagɨ paŋmɨlɨp ani. Mani Sabat bɨsapmon dɨmasi ani.” ");
INSERT INTO yut_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yaŋban Amɨn Tagɨ da kobogɨ yaŋ iyɨgɨt, “Ji jamba but amɨn! Ji Sabat bɨsapmon bulmakausi gat ae donkisi gat yutnikon baŋ wɨtdal ɨlɨk paŋkɨ yopba pakbi noŋ, ma? ");
INSERT INTO yut_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mɨŋat on Abraham dakon gwi, Sunduk da tebai abɨdaŋakwan bɨlakni 18 agɨt. Sabat bɨsapmon dɨma pulugaŋ kɨsak do nandaŋ, ma?” ");
INSERT INTO yut_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yaŋ yaŋban uwalni mayagɨ nandawit. Mani mɨŋat amɨnyo Yesu da yo morap wagɨl tagɨsisi agɨt uŋun do kɨsɨk kɨsɨk awit. ");
INSERT INTO yut_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu da saŋbeŋek yaŋ yagɨt, “Piŋkop dakon Amɨn Kɨla Agakni uŋun niaŋsi? Yo ni gat tɨlak abo? ");
INSERT INTO yut_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Uŋun mastat yet yombem. Amɨn kɨnda da mastat yet kɨnda pigagani kwaokgɨt. Aŋakwan mastat uŋun kwaŋ madep taŋ kɨndap kɨnda da yaŋ agakwan mɨnam da abɨŋ kɨlɨŋɨkon yutni uŋudon awit.” ");
INSERT INTO yut_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu da saŋbeŋek yaŋ yagɨt, “Piŋkop dakon Amɨn Kɨla Agakni yo ni gat tɨlak abo? ");
INSERT INTO yut_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Uŋun yis yombem. Mɨŋat kɨnda da plaua ɨdap madep kɨnda gat ɨktagɨldak. Yaŋ aŋakwan plaua uŋun kɨsisi paptaŋ madep tawit.” ");
INSERT INTO yut_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu uŋun Jerusalem kokup papmon kɨk do aŋek kokup pap ae kokup monɨŋ monɨŋ tawit uŋudon agek amɨn yoyɨŋ dekgɨt. ");
INSERT INTO yut_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aŋakwan amɨn kɨnda da yaŋ iyɨgɨt, “Amɨn Tagɨ, Piŋkop da amɨn kaloŋɨsok dɨ baŋgɨn yokwikon baŋ tɨmɨtjak bo niaŋ?” Yaŋban Yesu da yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nak yaŋsi dayɨsat, amɨn morapmɨ da egɨp egɨpmon wɨgɨk do pini akdaŋ, mani arɨpmɨ dɨma wɨgɨkdaŋ. Do ji yoma kosit gwagak monɨŋɨ naŋ wɨgɨk do pi tebai ani. ");
INSERT INTO yut_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yut dakon ami da pɨdaŋ yoma sopban ji da kɨŋ yomakon agek yoma tɨdaŋek yaŋ yokdaŋ, ‘Amɨn Tagɨ, nin do yoma wɨtdal nim.’ “Mani gen kobogɨ yaŋ dayɨkdɨsak, ‘Nak dɨma nandaŋ damɨsat. Ji dukon nani amɨn?’ ");
INSERT INTO yut_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Yaŋ yaŋban ji da kobogɨ yaŋ iyɨkdaŋ, ‘Nin gak gat kɨsi egek jap pakbiyo agɨmaŋ. Ae kokup papnin dakon kosit madepmon agek niyɨŋ dekgɨl.’ ");
INSERT INTO yut_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Mani uŋun da yaŋ dayɨkdɨsak, ‘Nak asisi dayɨsat, nak dɨma nandaŋ damɨsat. Ji dukon nani uŋun dɨma nandɨsat. Yokwi pakpak ji kɨsisi nepmaŋ dek kɨt!’ ");
INSERT INTO yut_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ji Abraham, Aisak, Jekop, ae kombɨ amɨn kɨsisi Piŋkop da Amɨn Kɨla Asak kokupmon ekwa pɨndatdaŋ. Mani ji maba waŋga kɨŋ mudokdaŋ. Uŋun bɨsapmon ji kunam tagek iyoŋ iyoŋ yaŋ tɨdaŋek egɨpdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Amɨn da gɨldat wɨsak ae si pɨgɨsak tet, ae not tet ae saut tet da Piŋkop da Amɨn Kɨla Asak kokupmon abɨŋek jap noknok tamo madepmon yɨtdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nandani, amɨn dɨwarɨ abɨsok buŋon ekwaŋ, uŋun don mibɨltok amɨn akdaŋ. Ae amɨn dɨwarɨ abɨsok mibɨltok ekwaŋ, uŋun don buŋon amɨn akdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Uŋun bɨsapmon gɨn Parisi amɨn dɨwarɨ da abɨŋ Yesu yaŋ iyɨwit, “Gak ɨdon dɨma egɨpbi, kokup dɨgwan kɨki. Erot da gak gɨkban kɨmokgi do nandɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yaŋba Yesu da yoyɨgɨt, “Ji kɨŋ uŋun top amɨn yaŋ iyɨni, ‘Nandaki. Nak abɨsok ae aŋwa koŋ yolgeŋ, ae sot amɨn paŋmɨlɨp abeŋ. Ae pɨdaŋɨ do pi abeŋ do nandagɨm uŋun aŋwasɨp abeŋ.’ ");
INSERT INTO yut_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kombɨ amɨn Jerusalem kokup papmon gɨn dapba kɨmokgoŋ. Kokup ŋwakŋwarɨkon dɨma dapba kɨmokgoŋ, do nak abɨsok ae aŋwa ae pɨdaŋɨ do sigɨn kɨkeŋ. ");
INSERT INTO yut_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem, Jerusalem amɨn, ji kombɨ amɨn dapba kɨmokgoŋ. Amɨn Piŋkop da yabekban jikon abaŋ uŋun ji da tɨpbaŋ dapba kɨmokgoŋ. Pup meŋi da monjini paŋmuwuk pɨrɨgwan yopmaŋdak, uŋun da tɨlak nak da bɨsap morapmɨ ji paŋmuwut do nandagɨm, mani ji da kurak taŋ namgwit. ");
INSERT INTO yut_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nak asisi dayɨsat, kokup yomasiyo yokwi taŋek yumsi tokdɨsak. Ji nak dɨma nandaŋek egɨ wɨgɨ ni bɨsapmon nak do ‘Amɨn on Amɨn Tagɨ da manon abɨsak, uŋun Piŋkop da gɨsamɨgakwan abɨsak’ yaŋ nak do yoni uŋun bɨsapmon nandakdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat kɨndakon Yesu jap nok do Parisi amɨn dakon kɨla amɨn kɨnda da yutnon kɨgɨt. Aŋakwan yɨpba kɨk aŋek kaŋ yɨkgwit, ");
INSERT INTO yut_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","nido Yesu da buron gɨptɨmɨ paptaŋbi amɨn kɨnda yɨkgɨt. ");
INSERT INTO yut_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu da uŋun amɨn kaŋek gen teban mibɨlɨ nandak nandak amɨn gat ae Parisi amɨn gat yaŋ yoyɨgɨt, “Sabat bɨsapmon sot amɨn tagɨ paŋmɨlɨp aneŋ bo dɨma? Gen teban da niaŋ yosok?” ");
INSERT INTO yut_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mani gen kobogɨ kɨnda dɨma iyɨwit. Yaŋ aŋakwa Yesu da amɨn uŋun abɨdaŋek aŋmɨlɨp aŋek dɨgo kɨ yaŋ iyɨŋban si kɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kɨŋakwan yaŋ yoyɨgɨt, “Jikon da kɨnda dakon monji bo bulmakauni Sabat bɨsapmon pakbi gapmakon maŋban tepmɨ tagɨ ɨlɨkba wɨsak bo dɨma?” ");
INSERT INTO yut_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yaŋban gen kobogɨ arɨpmɨ dɨma iyɨgɨ yaŋ kawit. ");
INSERT INTO yut_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu da amɨn jap nok do apgwit uŋun pɨndakban tamo mibɨltogɨ nanikon gɨn yɨt do awit. Do tɨlak gen kɨnda yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Amɨn kɨnda da mɨŋat pakpak dakon soŋnogon yaŋ gaban kɨki kaŋ, tamo mibɨltogɨ nanikon dɨma yɨkgi. Tamo uŋun amɨn madep kɨnda gak gwapmaŋdak uŋun do manjɨkbi naŋ dɨ yɨkbɨm. ");
INSERT INTO yut_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Yaŋ kaŋ amɨn yaŋ daban kɨki uŋun da abɨŋ yaŋ gayɨsak, ‘On tamo on amɨn do ɨmɨŋ.’ Yaŋ gayɨŋban gak gaga do mayagɨsi nandaŋek tamo amɨn pɨŋbisi do yopbi uŋudon paŋkɨ yɨtdɨsal. ");
INSERT INTO yut_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Amɨn kɨnda da yaŋ gaban kaŋ, gak tamo amɨn pɨŋbisi do yopbi uŋudon paŋkɨ yɨkgi. Yɨgaki amɨn yaŋ gamjak uŋun da ‘Not, on tamo tagɨkon pawɨŋ yɨt’ yaŋ gayɨŋban pawɨŋ yɨgaki amɨn dɨwarɨ da amɨn mani toŋ kɨnda yaŋ gandani. ");
INSERT INTO yut_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Amɨn kɨnda iyɨ do nandaban wugɨsak kaŋ, Piŋkop da uŋun amɨn abɨŋ yɨpdɨsak. Mani amɨn kɨnda iyɨ do nandaban pɨsak kaŋ, Piŋkop da mani awɨgɨkdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu da amɨn uŋun yaŋ ɨban kɨgɨt uŋun yaŋ iyɨgɨt, “Gak jap noknok kɨnda asal kaŋ, notgo, bo ae pego padɨk padɨkgo bo ae yawi dɨwatgo bo ae yoni morapmɨ amɨn dɨbaŋ dɨma yaŋ yobi. Uŋun da kobogɨ do don yaŋ gamdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Gak jap noknok kɨnda abi kaŋ, yoni mɨni amɨn, ae gɨptɨmɨ yokwi taŋbi, ae kandap yokwi ae dabɨlɨ mɨni amɨn baŋgɨn yaŋ yobi. ");
INSERT INTO yut_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Yaŋ abi kaŋ, gak kɨsɨk kɨsɨgɨ toŋsi egɨpbi. Uŋuden amɨn kobogɨ tagɨ dɨma gamni, mani Piŋkop da amɨn kɨlegɨ kɨmoron baŋ paban pɨdoni bɨsapmon don kobogɨ gamdɨsak.” ");
INSERT INTO yut_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Amɨn kɨnda jap nawitgwan da gen uŋun nandaŋek Yesu yaŋ iyɨgɨt, “Piŋkop da Amɨn Kɨla Asak kokupmon yɨgek jap nokdaŋ amɨn uŋun kɨsɨk kɨsɨk ekwaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mani Yesu da yaŋ iyɨgɨt, “Amɨn kɨnda da jap madepsi kɨnda paŋkosit aŋek amɨn morapmɨ yaŋ yomgut. ");
INSERT INTO yut_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jap noknok bɨsapmon oman monjɨni kɨnda yabekban amɨn yaŋ yomgut uŋun yoyɨk do kɨgɨt. Kɨŋ yaŋ yoyɨgɨt, ‘Yo morap kɨlɨ paŋkosit abi, do ji tagɨ opni.’ ");
INSERT INTO yut_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Mani amɨn kɨsisi dɨma op do yawit. Kɨnda da yaŋ yagɨt, ‘Nak pi kɨnda kaluk yumɨt uŋun kɨŋ kokeŋ. Do nandaŋ namɨŋaki dɨma opbeŋ.’ ");
INSERT INTO yut_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ae kɨnda da yagɨt, ‘Nak pi agak bulmakau 10 kabɨ yumɨt, uŋun kɨŋ paŋkɨlɨk pɨndatgeŋ. Do nandaŋ namɨŋaki dɨma opbeŋ.’ ");
INSERT INTO yut_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ae kɨnda da yagɨt, ‘Nak mɨŋat kaluk pat, do arɨpmɨ dɨma opbeŋ.’ ");
INSERT INTO yut_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Oman monjɨni tobɨl obɨŋ amɨn tagɨni amɨn yoyɨŋban gen yawit dakon mibɨlɨ iyɨgɨt. Iyɨŋban yut uŋun dakon ami uŋun da butjap nandaŋek oman monjɨni tebai yaŋ iyɨgɨt, ‘Gak tepmɨsi kokup madep da kosit madep ae kosit monɨŋon kɨŋ, amɨn yoni mɨni, ae gɨptɨmɨ yokwi taŋbi, ae dabɨlɨ mɨni, ae kandap yokwi uŋun tɨmɨk paŋopbi.’ ");
INSERT INTO yut_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Yaŋ iyɨŋban oman monjɨ da yaŋ gɨn aŋek yaŋ iyɨgɨt, ‘Amɨn tagɨ, yo abeŋ dosi nayɨl uŋun kɨlɨ aŋmudat, mani tamo toŋ.’ ");
INSERT INTO yut_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Iyɨŋban amɨn tagɨ da oman monjɨ yaŋ iyɨgɨt, ‘Gak kokup madep yɨpmaŋek kɨŋ kosit madepmon bo ae pigaga da dam kɨdɨpmɨŋ agek amɨn pɨndak tebai yoyɨŋbɨ abɨŋ yɨkba yutno tugosak. ");
INSERT INTO yut_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nak yaŋsi dayɨsat, amɨn uŋun kalɨp yaŋ yomgum uŋun da nak dakon jap jɨmjɨmjok kɨnda dɨmasi nokdaŋ.’ ” ");
INSERT INTO yut_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mɨŋat amɨn kabɨ madepsi yolakwa Yesu da tobɨlek yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Amɨn kɨnda nak nol do nandɨsak kaŋ, meŋi datni, ae mɨŋatni gwakniyo gat, ae peni samɨni padɨgeyo gat, ae iyɨ dakon egɨp egɨpni gat kɨsi do uwal dɨma aŋyomjak kaŋ, uŋuden amɨn nak dakon paŋdetno arɨpmɨ dɨma egɨpjak. ");
INSERT INTO yut_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tɨlak kɨndapni guramɨgek dɨma noljak amɨn paŋdetno arɨpmɨ dɨma egɨpjak. ");
INSERT INTO yut_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Amɨn kɨnda yut madep kɨnda ak do kaŋ, mibɨltok yɨgek moneŋni manjɨsak. Aŋek yut tagɨ aŋ mudogɨ bo dɨma uŋun dakon nandak nandak asak. ");
INSERT INTO yut_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yaŋ dɨma aŋek yut gwak maŋek yo dɨwarɨ do wadaŋek yut dɨma aŋ mudosok kaŋ, amɨn morap koni uŋun kɨsi jɨgɨlak yaŋek yanjaŋ ɨmdaŋ. ");
INSERT INTO yut_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Aŋek yaŋ yokdaŋ, ‘On amɨn yutni aŋ dɨwarɨkgɨt, mani wasɨp ak do aŋtɨdok asak.’ ");
INSERT INTO yut_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Bo kɨla amɨn madep kɨnda da uwalni gat emat wam do nandɨsak kaŋ, mibɨltok nandaŋ kokwin asak. Iyɨ dakon emat amɨn 10 tausen da uwalni dakon 20 tausen tagɨ yolni bo dɨma, yaŋ do nandak nandak asak. ");
INSERT INTO yut_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tagɨ dɨma yolni yaŋ nandɨsak kaŋ, uwalni kapmat dɨma abɨŋakwa amɨn kabi kɨnda yabekban kɨŋ emat dɨma wamni do gen yoyɨŋ paŋyawot aŋ. ");
INSERT INTO yut_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jiyo yaŋ gɨn yo morapji dɨma yopmaŋ mudoni kaŋ, paŋdetnoni tagɨ dɨma egɨpni.” ");
INSERT INTO yut_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yesu da saŋbeŋek yaŋ yagɨt, “Tap uŋun yo tagɨsi kɨnda. Mani galagɨni pasɨlni kaŋ, niaŋsi aŋek galagɨni aŋkaluk aneŋ? ");
INSERT INTO yut_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tap uŋuden mɨktɨm arɨpmɨ dɨma paŋpulugogɨ. Bo bulmakau dakon kok gat ɨktagɨlɨ arɨpmɨ dɨma. Tap uŋuden ɨsal mamno kwaŋ. Mɨrakni toŋ amɨn da gen on pakyaŋsi nandaŋek mibɨlɨ nandaŋ pɨsoni.” ");
INSERT INTO yut_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takis tɨmɨt tɨmɨt amɨn gat ae yokwi pakpak amɨn gat da geni nandak do Yesu da kapmatjok opgwit. ");
INSERT INTO yut_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Aŋakwa Parisi amɨn gat gen teban yoyɨŋdet amɨn gat da yaŋba yokwi tok aŋek yaŋ yawit, “On amɨn yokwi pakpak amɨn not aŋyoban yɨgek jap noŋ.” ");
INSERT INTO yut_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yaŋ yaŋakwa Yesu da tɨlak gen kɨnda yaŋ yoyɨgɨt, ");
INSERT INTO yut_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Jikon da amɨn kɨnda sipsipni 100 baŋ kaloŋɨ da pasɨljak kaŋ niaŋ asak? Uŋun da sipsip 99 joŋ tɨmon yopban egakwa kaloŋɨ pasɨldak uŋun wɨsɨŋek don aŋalon asak. ");
INSERT INTO yut_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Wɨsɨŋ kaŋ abɨdosok bɨsapmon but galak nandaŋek kwapmɨkon guramɨk aŋaŋ ");
INSERT INTO yut_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","yomanikon aŋkɨsak. Aŋkɨŋek notni gat ae kokup ɨsalni gat yaŋ yoban obɨŋ muwukba yaŋ yoyɨsak, ‘Sipsipno pasɨlak uŋun kɨlɨ wɨsɨŋ kat, do kɨsɨk kɨsɨk ano.’ ” ");
INSERT INTO yut_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yesu da saŋbeŋek yaŋ yoyɨgɨt, “Nak asisi dayɨsat, yokwi pakpak kɨnda da but tobɨl asak kaŋ, Kwen Kokupmon kɨsɨk kɨsɨk madepsi yaŋ gɨn akdaŋ. Amɨn 99 uŋun kɨlegɨ do but tobɨl agagɨ mɨni do uŋun dakon kɨsɨk kɨsɨk madep dɨma ani. Mani yokwi pakpak kɨnda but tobɨl asak uŋun dakon kɨsɨk kɨsɨk uŋun madepsi noman tosok.” ");
INSERT INTO yut_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ae Yesu da saŋbeŋek yaŋ yagɨt, “Mɨŋat kɨnda da silwa moneŋ tabɨlɨ 10 kabɨ baŋ kaloŋɨ da yutnon maŋ pasɨljak kaŋ uŋun niaŋ asak? Uŋun da lamni koleŋek yutni ɨkdɨgaŋek tebaisi wɨsɨŋek don kosak. ");
INSERT INTO yut_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kaŋ abɨdosok bɨsapmon but galak nandaŋek notni gat ae kokup ɨsalni gat yoyɨŋban obɨŋ muwukba yaŋ yoyɨsak, ‘Moneŋno pasɨlak uŋun kɨlɨ wɨsɨŋ kat, do kɨsɨk kɨsɨk ano.’ ” ");
INSERT INTO yut_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yesu da yaŋ yoyɨgɨt, “Nak asisi dayɨsat, yokwi pakpak kɨnda da but tobɨl asak kaŋ, Piŋkop dakon aŋelo da kɨsɨk kɨsɨk yaŋ gɨn akdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu da saŋbeŋek yaŋ yagɨt, “Amɨn kɨnda egɨpgut uŋun monji bamorɨ. ");
INSERT INTO yut_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Monjɨ buŋon nani da datni yaŋ iyɨgɨt, ‘Dat, gak peno gat nit do yo morap nim do nandɨsal uŋun nak dakon dɨwarɨno abɨsok kokwinɨk nabi.’ Yaŋ yaŋban datni da yo kabɨni kokwinɨk monjɨ bamotni do yomgut. ");
INSERT INTO yut_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Yoban bɨsap pɨsɨpmɨsok egek monji buŋon nani da yo kabɨni kɨsisi tɨmɨk dubagɨsi kɨŋ mɨktɨm kɨndakon paŋkɨ egɨpgut. Paŋkɨ egek aŋpak yokwi mibɨlɨ mibɨlɨ aŋek moneŋni naŋ mudagɨt. ");
INSERT INTO yut_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Moneŋni naŋ mudaŋakwan uŋun mɨktɨm amɨn da jap do madepsi aŋek dɨwarɨ da kɨmakgwit. Aŋakwa monji uŋun wadak wadak madepsi agɨt. ");
INSERT INTO yut_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Do kɨŋ uŋun mɨktɨm dakon amɨn kɨndakon pi kɨnda abɨdagɨt. Aban amɨn tagɨni da yabekban bɨt damnikon kɨŋ bɨt jap yomgut. ");
INSERT INTO yut_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aŋek bɨt da bɨrap gɨp nawit uŋun pɨndak galak taŋek uŋun baŋ naŋek butno kadɨm tosak yaŋ nandagɨt. Mani amɨn kɨnda da jap kɨnda dɨma ɨmgut. ");
INSERT INTO yut_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Nandak nandakni kulabɨk aŋek yaŋ yagɨt, ‘Datno dakon oman monjɨ morapni uŋun japni arɨpmɨsi taŋ yomaŋakwa ekwaŋ, mani nak ɨdon egek jap do kɨmotdɨsat. ");
INSERT INTO yut_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Do yaŋsi abeŋ, nak tobɨl kɨŋ datno yaŋ iyɨkeŋ: “Dat, nak Piŋkop da ɨŋamon ae gak yo kɨsikon yo yokwisi agɨm, ");
INSERT INTO yut_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","do buŋon monjɨno yaŋ dɨma nayɨki. Yum oman monjɨgo yumaŋ naŋaki ekwaŋ uŋuden kɨnda da tɨlak egɨpbeŋ.” ’ ");
INSERT INTO yut_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yaŋ nandaŋek pɨdaŋ datnikon kɨgɨt. Kɨŋakwan datni dubagɨkon da monji kaŋ bupmɨ nandaŋ tɨmtɨm yaŋek kɨŋ monji bedaŋek mandaŋ nagɨt. ");
INSERT INTO yut_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yaŋ aban monji da datni yaŋ iyɨgɨt, ‘Dat, nak Piŋkop da ɨŋamon ae gagon yo yokwisi agɨm, do buŋon monjɨno yaŋ dɨma nayɨki.’ ");
INSERT INTO yut_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","24","Mani datni da oman monjɨni yaŋ yoyɨgɨt, ‘Monjɨno kɨmoron da yaŋ abɨsak. Pasɨlbikon naŋ aŋalon amaŋ. Do ji tepmɨ kɨŋ paba pɨgɨk dubagɨ tagɨsi kɨnda aŋabɨŋ paŋ ɨmni. Ae kɨsirɨkon sɨp tagɨsi kɨnda yɨpmaŋ ɨmɨŋek kandap gwɨl kɨsi paŋ ɨmni. Ae bulmakau monjɨ nelagɨ toŋ kɨnda naŋ aŋapba aŋak soŋ naŋek kɨsɨk kɨsɨk ano.’ Datni da yaŋ yaŋakwan jap noknok aŋek kɨsɨk kɨsɨk awit. ");
INSERT INTO yut_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Yaŋ aŋek egakwa monji mibɨltogɨ pigaga egɨpgut da yutnon obɨŋ aŋkapmat aŋek nandaban amɨn da kap kɨsɨk kɨsɨkyo awit. ");
INSERT INTO yut_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yaŋ aŋakwa nandaŋek oman monjɨ kɨnda yaŋ ɨban apban iyɨgɨt, ‘Uŋun nibaŋ aŋ?’ ");
INSERT INTO yut_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yaŋ yaŋban iyɨgɨt, ‘Padɨgɨgo tagɨsi egɨsak da abɨk do datgo da kaŋek bulmakau monjɨ nelagɨ toŋ aŋwak.’ ");
INSERT INTO yut_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yaŋ iyɨŋban monji mibɨltogɨ butjap nandaŋek yutnon wɨgɨk do kurak tagɨt. Yaŋ aŋakwan datni da yomakon pɨŋek butni maŋakwan yutnon wɨgɨsak do iyɨgɨt. ");
INSERT INTO yut_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mani datni yaŋ iyɨgɨt, ‘Dat, gak yaŋ nido asal? Nak oman monjɨ ɨsalɨ kɨnda da yaŋ bɨlak morapmɨ egek omango aŋ egɨsat. Aŋek gengo bɨsap kɨndakon dɨma kɨrɨŋɨkgɨm. Notnoni gat kɨsɨk kɨsɨk aneŋ do memesok kɨnda dɨmasi namgul. ");
INSERT INTO yut_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mani monjɨgo on yo morapgo kosit mɨŋat gat egek yomɨŋ mudagɨt, uŋun da apban kaŋek bulmakau monjɨ nelagɨ toŋ uŋun aŋwal.’ ");
INSERT INTO yut_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Yaŋban datni da yaŋ iyɨgɨt, ‘Monjɨno, bɨsapmɨ bɨsapmɨ gak nak gat ekwamak. Ae yo morapno uŋun gak dakon gɨn. ");
INSERT INTO yut_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mani padɨgɨgo kɨmoron da yaŋ abɨk, ae pasɨlbikon naŋ aŋalon amaŋ, do nin but kwaktok nandaŋek kɨsɨk kɨsɨk tagɨsi amaŋ.’ ” ");
INSERT INTO yut_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu da paŋdetni yaŋ yoyɨgɨt, “Yoni morapmɨ amɨn kɨnda gat ae yo morapni dakon kɨla amɨni gat egɨpgumal. Amɨn da abɨŋ yoni morapmɨ amɨn yaŋ iyɨwit, ‘Yo morapgo dakon kɨla amɨn ɨsal dogɨn yo morapgo naŋ mudok aŋgamɨsak.’ ");
INSERT INTO yut_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Iyɨŋba nandaŋek yo kɨla amɨni uŋun yaŋ ɨban opban yaŋ iyɨgɨt, ‘Gak niaŋ aŋaki gengo nandat? Gak kɨŋ yo morapno kɨlɨ niaŋ asal uŋun dakon but pɨso kɨnda mandaŋ nabi. Gak pi uŋun saŋbeŋek dɨma akdɨsal.’ ");
INSERT INTO yut_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Iyɨŋban yo kɨla agak pi amɨni uŋun iyɨ yaŋ nandagɨt, ‘Amɨn tagɨno da pikon noldak, do niaŋ abeŋ? Amɨn kɨnda dakon oman monjɨni egek mɨktɨmni pudaŋ ɨbeŋ dakon tapmɨmno mɨni. Ae amɨn moneŋ do bɨsit yoyɨk do mayagɨ nandɨsat. ");
INSERT INTO yut_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Do pi yopbeŋ bɨsapmon amɨn da but galagon da yaŋ naba yutnikon kɨŋ kɨŋ akeŋ do niaŋ abeŋ uŋun kɨlɨ uŋun nandɨsat.’ ");
INSERT INTO yut_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yaŋ nandaŋek amɨn kaloŋ kaloŋ amɨn tagɨnikon goman awit uŋun yaŋ yoban apgwit. Mibɨltok abɨŋ altagɨt amɨn yaŋ iyɨgɨt, ‘Gak amɨn tagɨnokon goman niaŋ da agɨl?’ ");
INSERT INTO yut_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Iyɨŋban yagɨt, ‘Olip pakbi tɨbɨrɨ madep 100 da arɨp.’ “Yaŋban yaŋ iyɨgɨt, ‘Gak tepmɨsi yɨgek on papia tam gomango mandabikon olip pakbi tɨbɨrɨ 50 yaŋ manda.’ ");
INSERT INTO yut_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ae kɨnda abɨŋ altaŋban yaŋ iyɨgɨt, ‘Gak gomango niaŋ da?’ “Iyɨŋban yagɨt, ‘Wit yɨgɨ 100 da arɨp.’ Yaŋ iyɨŋban yagɨt, ‘On gomango mandabi papia tamon wit yɨgɨ 80 yaŋ manda.’ ");
INSERT INTO yut_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Yaŋ aŋakwan amɨn tagɨni da yo agɨt uŋun kaŋban amɨn nandaŋ kokwini tagɨsi da arɨpmon agɨt, do yo kɨla agak pi amɨni yokwi uŋun do nandaban wukwan ɨmgut. On mɨktɨm dakon amɨn kabɨ da nandaŋ kokwin tagɨsi aŋek notni gat yumaŋ gwayek pi aŋ. Uŋun teŋteŋɨ dakon amɨn kabɨ yapmaŋgaŋ. ");
INSERT INTO yut_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nak da yaŋ dayɨsat, on mɨktɨm dakon moneŋ baŋ amɨn not aŋyomni. Yaŋ ani kaŋ, moneŋgo mudoni bɨsapmon ji egɨp egɨp dagok dagogɨ mɨni da yutgwan tagɨsi wɨgɨni. ");
INSERT INTO yut_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Amɨn kɨnda yo monɨŋɨsisok kɨlani tagɨ asak kaŋ, uŋun amɨn da yo madep kɨlani tagɨ asak. Ae amɨn kɨnda yo monɨŋɨsok kɨlani yokwi asak kaŋ, uŋun amɨn yo madepyo kɨsi kɨlani yokwi asak. ");
INSERT INTO yut_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yaŋdo, ji on mɨktɨm dakon moneŋ kɨlani tagɨ dɨma ani kaŋ, namɨn da nandaŋ gadaŋ damɨŋek yo tagɨsi bamɨsi daban kɨlani ani? ");
INSERT INTO yut_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ae ji amɨn dakon yo kabɨ kɨlani tagɨ dɨma ani kaŋ, namɨn da yo kabɨ dɨsi do damjak? ");
INSERT INTO yut_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Amɨn kɨnda da amɨn tagɨ bamorɨ dakon oman arɨpmɨ dɨma asak. Yaŋ kaŋ, kɨnda naŋgɨn galak taŋ ɨmɨŋek kɨnda do nandaban yokwi taŋ ɨmdɨsak. Ae kɨnda dakon gen guramɨgek kɨnda manji ɨmdɨsak. Ji Piŋkop gat ae moneŋ gat kɨsi dakon oman monjɨni arɨpmɨ dɨma egɨpmɨ.” ");
INSERT INTO yut_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisi amɨn moneŋ do galagɨsi nandaŋ, do Yesu da gen yagɨt uŋun nandaŋek yaŋba yokwi tok aŋ ɨmgwit. ");
INSERT INTO yut_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mani Yesu da yaŋ yoyɨgɨt, “Ji amɨn da amɨn kɨlegɨsi yaŋ dandani yaŋ do pi madep aŋ. Mani Piŋkop da butjigwan yo pasɨlɨ toŋ uŋun pɨndak mudosok. Amɨn da yo tagɨsi yaŋ yoŋ uŋun Piŋkop da dabɨlon yo wagɨl ɨŋanisi. ");
INSERT INTO yut_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Gen teban gat ae kombɨ amɨn dakon gen gat yaŋ teŋteŋaŋba Jon da bɨsapmon wugɨt. Mani Jon da bɨsapmon da wasaŋek Piŋkop dakon Amɨn Kɨla Agakni dakon Gen Bin Tagɨsi yaŋ teŋteŋoŋ. Aŋakwa amɨn uŋungwan pɨgɨk do pi tebaisi aŋ. ");
INSERT INTO yut_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mɨktɨm gat kundu gat tagɨ pasɨljil. Mani gen teban dakon gen jɨmjɨmjok kɨnda arɨpmɨ dɨmasi pasɨldɨsak. Kɨsisi bamɨ taŋ mudokdaŋ.” ");
INSERT INTO yut_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Yesu da saŋbeŋek yaŋ yagɨt, “Amɨn kɨnda mɨŋatni kwɨnɨk yɨpban kɨŋakwan mɨŋat kaluk pasak kaŋ, uŋun amɨn yumabi asak. Ae amɨn kɨnda mɨŋat kɨnda kalɨp eni da kwɨnɨkgɨt uŋun pasak kaŋ, uŋun amɨn kɨsi yumabi asak.” ");
INSERT INTO yut_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu da saŋbeŋek yaŋ yagɨt, “Yoni morapmɨ amɨn kɨnda egɨpgut, uŋun bɨsapmɨ bɨsapmɨ ɨlɨkba pɨgɨkni kɨldani toŋ tagɨsi ae ɨmalni gami baŋ paŋek yoni arɨpmɨsi taŋ ɨmɨŋakwa yaworɨsi egɨpgut. ");
INSERT INTO yut_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Yaŋ egakwan uŋun da yut yoma kagakon yoni mɨni amɨn kɨnda mani Lasarus uŋudon pak egɨpgut. Lasarus yaŋ nandagɨt, yoni morapmɨ amɨn dakon jap tamokon da jap jɨmjɨm moŋ uŋun baŋ nokeŋ kaŋ tagɨsi yaŋ nandagɨt. Ae pɨŋan da abɨŋ wudani asɨwukgwit. ");
INSERT INTO yut_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Yoni mɨni amɨn egek kɨmakban aŋelo da abɨdaŋ aŋkɨ yɨpba Abraham gat egɨpgumal. Egakwal yoni morapmɨ amɨn uŋun yo kɨsi kɨmakban wayɨkgwit. ");
INSERT INTO yut_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Aba Tɨpdomon tepmɨ madepsi nandaŋek egɨpgut. Egek sɨŋtaŋban wɨkwanek Abraham dubagɨsikon Lasarus gat kapmat kapmat yɨgakwal pɨndakgɨt. ");
INSERT INTO yut_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pɨndagek yaŋ tɨdaŋek yaŋ iyɨgɨt, ‘Abraham dat, bupmɨ nandaŋ nam. Lasarus iyɨŋbɨ uŋun da pakbi jɨmjɨmjok dɨ kɨsirɨkon yopmaŋ paŋabɨŋ melnokon yopban tɨmɨsok dɨ yawotjak. Nak on kɨndapmon egek tepmɨ madepsi nandɨsat!’ ");
INSERT INTO yut_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Mani Abraham da yaŋ yagɨt, ‘Monjɨno, gak kalɨp egɨpgul do nandaki. Gak kalɨp yo kabɨgo tagɨsi baŋgɨn paŋek egaki Lasarus uŋun yo kabɨni yokwi baŋgɨn paŋek egɨpgut. Mani abɨsok Lasarus on kokupmon butni yaworɨsi taŋakwan gak da tepmɨ madepsi nandɨsal. ");
INSERT INTO yut_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ae uŋun gɨn dɨma. Nin da binapmon daŋgap dubagɨsi kɨnda tosok. Yaŋ tosok do ɨdon ekwaŋ amɨn jikon arɨpmɨ dɨma kɨkɨgɨ, ae uŋudon ekwaŋ amɨn ɨdon arɨpmɨ dɨma obopmɨ.’ ");
INSERT INTO yut_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Yaŋ yaŋban yoni morapmɨ amɨn da gen tebaisi yaŋ iyɨgɨt, ‘Yaŋ kaŋ, dat, nandaŋ namɨŋek Lasarus iyɨŋbɨ datno da yutnon kɨŋ ");
INSERT INTO yut_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","padɨk padɨkno 5 kabɨ ekwaŋ uŋun nawa gen tebai yoyɨŋban nandaŋek on tepmɨ kokupmon dɨma apni.’ ");
INSERT INTO yut_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Mani Abraham da yaŋ yagɨt, ‘Moses gat ae kombɨ amɨn gat dakon gen do padɨk padɨkgo mɨrak yopmaŋek tagɨ nandani.’ ");
INSERT INTO yut_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Yaŋban yoni morapmɨ amɨn da yagɨt, ‘Abraham dat, uŋun arɨpmɨ dɨma. Mani amɨn kɨmakbi kɨnda da kɨŋ altaŋ yomjak kaŋ, padɨk padɨkno da but tobɨl tagɨ ani.’ ");
INSERT INTO yut_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Yaŋban Abraham da yaŋ iyɨgɨt, ‘Moses gat ae kombɨ amɨn gat dakon gen dɨma nandani kaŋ, amɨn kɨnda kɨmoron da pɨdaŋban kaŋek nandaŋ gadat arɨpmɨ dɨma akdaŋ.’ ” ");
INSERT INTO yut_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu da paŋdetni yaŋ yoyɨgɨt, “Yokwi mibɨlɨ mibɨlɨ da abɨŋ amɨn paŋkewalba yokwi aŋek maŋ mudokdaŋ. Mani uŋun yokwi ani do dayɨkdaŋ amɨn, awa! ");
INSERT INTO yut_vpl VALUES ("LK17_2","07